-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_176
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_176`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_176` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_176`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3274 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3264,20048,'',0,'20','1','176','SALES','','2021-03-19 05:37:30',5,0.00,0.00,'','479','2021-03-19 05:37:30','479',0,1),(3265,40048,'',0,'6.1','1','176','CASH','','2021-03-19 05:37:46',5,0.00,0.00,'','479','2021-03-19 05:37:46','479',0,1),(3266,400305,'',0,'24','1','176','SALARIES & WAGES','','2021-03-19 05:38:25',5,0.00,0.00,'','479','2021-03-19 05:38:25','479',0,1),(3267,400306,'',0,'24','1','176','PURCHASES','','2021-03-19 05:38:54',5,0.00,0.00,'','479','2021-03-19 05:38:54','479',0,1),(3268,400516,'',0,'2','1','176','ZNB E-BILLS:1015372548','','2021-03-19 05:40:26',5,0.00,0.00,'','479','2021-03-19 05:40:26','479',0,1),(3269,400517,'',0,'2','1','176','ZNB(POS):1015965368','','2021-03-19 05:42:00',5,0.00,0.00,'','479','2021-03-19 05:42:00','479',0,1),(3270,400518,'',0,'2','1','176','DANKANO-EBILLS(ZNB:1014717618)','','2021-03-19 05:45:00',5,0.00,0.00,'','479','2021-03-19 05:45:00','479',0,1),(3271,400519,'',0,'2','1','176','FID POS COLLECTION-5620141491','','2021-03-19 05:45:55',5,0.00,0.00,'','479','2021-03-19 05:45:55','479',0,1),(3272,400520,'',0,'2','1','176','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 13:56:29',5,0.00,0.00,'','792','2023-02-20 13:56:29','792',0,0),(3273,400521,'',0,'2','1','176','MONIE POINT LPG COLL ACCT:-823','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:12:38',5,0.00,0.00,'2023-03-17','792','2023-03-17 10:40:25','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4285 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2399,'','1','176','GAS RIGHT LTD','GAS RIGHT','08065635593','aaranoapolpg@gmail.com','abuja','fct','gudu','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 19:52:52',5,'615','2021-03-25 19:52:52','615'),(2400,'','1','176','chica gas ltd','chica gas','08138500672','aaranoapolpg@gmail.com','abuja','fct','apo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 20:08:22',5,'615','2021-03-25 20:08:22','615'),(2401,'','1','176','o. edeson ltd','edeson gas','08036782042','aaranoapolpg@gmail.com','abuja','fct','apo ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 20:14:06',5,'615','2021-03-25 20:14:06','615'),(2402,'','1','176','Okwy gas ltd','Okwy','08166813055','aaranoapolpg@gmail.com','abuja','fct','apo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 20:21:25',5,'615','2022-11-28 11:50:19','615'),(2406,'','1','176','Ossy Gas','Ossy','08160192957','aaranoapolpg@gmail.com','abuja','fct','APO Resettlement','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 11:57:11',5,'615','2021-03-26 11:57:11','615'),(2408,'','1','176','VINING GAS LTD','VINING','080388058817','aaranoapolpg@gmail.com','abuja','fct','AREA 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 13:18:36',5,'615','2021-03-26 13:18:36','615'),(2409,'','1','176','LIGUPASS GAS','LIGUPASS','08032688591','aaranoapolpg@gmail.com','abuja','fct','APO CETLIMENT CENTER','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 15:05:38',5,'615','2021-03-26 15:05:38','615'),(2411,'','1','176','GAS LORD LTD','GAS LORD','08060999616','aaranoapolpg@gmail.com','abuja','fct','DUTSE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 09:30:01',5,'615','2021-03-27 09:30:01','615'),(2412,'','1','176','FIRST BOSS LTD ','FIRST BOSS','08166740280','aaranoapolpg@gmail.com','abuja','fct','WUMBA SITE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 09:49:04',5,'615','2021-03-27 09:49:04','615'),(2413,'','1','176','ANDREW GAS LTD','ANDREW',' 08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 10:01:05',5,'615','2021-03-27 10:01:05','615'),(2414,'','1','176','MIKE GAS LTD','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 10:14:21',5,'615','2021-06-10 17:14:05','615'),(2415,'','1','176','FAVOUR GAS LTD','FAVOUR GAS','07037116669','aaranoapolpg@gmail.com','abuja','fct','WUMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 10:17:38',5,'615','2021-03-27 10:17:38','615'),(2417,'','1','176','VISENT  GAS LTD ','VISENT GAS','09046631080','aaranoapolpg@gmail.com','abuja','fct','WARU APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 12:43:50',5,'615','2021-03-27 12:43:50','615'),(2418,'','1','176','EBUKAZI GAS LTD','EBUKAZI','O8O86859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 13:14:23',5,'615','2021-03-27 13:14:23','615'),(2421,'','1','176','CHIDERA GAS LTD ','CHIDERA GAS','09027512338','aaranoapolpg@gmail.com','abuja','fct','APO RECETIMENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 15:25:08',5,'615','2021-03-27 15:25:08','615'),(2423,'','1','176','EFEDI CHAFI LTD','EFEDI GAS','09138893039','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 10:24:09',5,'615','2021-03-28 10:24:09','615'),(2424,'','1','176','WAKILI GAS LTD','WAKILI GAS','09094601815','aaranoapolpg@gmail.com','abuja','fct','APO RECETILIMENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 10:59:49',5,'615','2021-03-28 10:59:49','615'),(2427,'','1','176','DIGITAL GAS LTD ','DIGITAL','08050802698','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 13:28:15',5,'615','2021-03-28 13:28:15','615'),(2433,'','1','176','JOHN GAS LTD ','JOHN','08050802698','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 14:02:33',5,'615','2021-03-29 14:02:33','615'),(2434,'','1','176','KING SLEY GAS LTD ','KING SLEY','08160306579','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 14:06:49',5,'615','2021-03-29 14:06:49','615'),(2435,'','1','176','TAM TAM GAS LTD ','TAM TAM GAS ','08132254122','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 14:13:29',5,'615','2021-03-29 14:13:29','615'),(2436,'','1','176','DIVEN GAS LTD ','DIVEN ','090 67698976','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 14:17:44',5,'615','2021-03-29 14:17:44','615'),(2441,'','1','176','DOGARA GAS LTD ','DOGARA','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 14:53:07',5,'615','2021-03-29 14:53:07','615'),(2442,'','1','176','CHASPA GASLTD ','CHASPA ','08037881364','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 15:44:22',5,'615','2021-03-29 15:44:22','615'),(2453,'','1','176','operational loss','operational loss','07039341949','aaranoapolpg@gmail.com','abuja','fct','nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 11:55:41',5,'615','2021-03-30 11:55:41','615'),(2455,'','1','176','CHUKS GAS LTD ','CHUKS GAS ','07030953767','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 14:12:29',5,'615','2021-05-10 10:25:11','615'),(2457,'','1','176','MADE GREAT GAS ','MADE GREAT ','07039351446','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 14:17:42',5,'615','2021-03-30 14:17:42','615'),(2459,'','1','176','RAY GAS LTD ','RAY GAS ','09033753142','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 14:26:28',5,'615','2021-03-30 14:26:28','615'),(2460,'','1','176','SYSTEM GAS LTD ','SYSTEM GAS ','08139331114','aaranoapolpg@gmail.com','abuja','fct','DUROMI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 15:29:52',5,'615','2021-03-30 15:29:52','615'),(2466,'','1','176','IFEYDEY GAS LTD ','IFEYDEY ','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 10:36:34',5,'615','2021-04-01 10:36:34','615'),(2467,'','1','176','EDWIN GAS LTD ','EDWIN GAS ','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 10:40:13',5,'615','2021-04-01 10:40:13','615'),(2468,'','1','176','PIUS GAS LTD ','PIUS GAS','08164838679','aaranoapolpg@gmail.com','abuja','fct','DURUMI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 10:50:18',5,'615','2021-04-01 10:50:18','615'),(2469,'','1','176','ROYAL ENERGY GAS LTD ','ROYAL ENERGY ','07063708162','aaranoapolpg@gmail.com','abuja','fct','LOKO GOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 10:54:40',5,'615','2021-04-01 10:54:40','615'),(2470,'','1','176','SUNNY BEST','GADUWA','08035967426','aaranoapolpg@gmail.com','abuja','fct','APO VILLEGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 11:35:03',5,'615','2022-11-24 06:57:52','615'),(2473,'','1','176','METRO GAS','METRO','08036120277','aaranoapolpg@gmail.com','abuja','fct','AREA 11','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 12:28:37',5,'615','2021-04-01 12:28:37','615'),(2474,'','1','176','AGBO GAS LTD','AGBO','08103912787','aaranoapolpg@gmail.com','abuja','fct','LOKO GOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 15:38:38',5,'615','2021-04-01 15:38:38','615'),(2479,'','1','176','SAMO GAS LTD ','SAMO GAS ','08073414109','aaranoapolpg@gmail.com','abuja','fct','DURUMI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 17:39:06',5,'615','2021-04-02 17:39:06','615'),(2480,'','1','176','UZO  BEST GAS LTD','UZU BEST','08139316631','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 18:16:06',5,'615','2023-02-06 15:57:42','615'),(2481,'','1','176','SP GAS LTD ','SP GAS LTD ','07037222125','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 18:23:30',5,'615','2021-04-02 18:23:30','615'),(2482,'','1','176','KOLA GAS LTD ','KOLA GAS ','08178581448','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 18:26:27',5,'615','2021-04-02 18:26:27','615'),(2488,'','1','176','NAJJA GAS LTD ','NAJJA GAS ','09072744444','aaranoapolpg@gmail.com','abuja','fct','WUSE ZONE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 10:09:42',5,'615','2021-04-03 10:09:42','615'),(2490,'','1','176','SAMANGER PLIMAN GAS LTD ','SAMANGER ','09037139132','aaranoapolpg@gmail.com','abuja','fct','GALADIMAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 10:52:58',5,'615','2021-04-03 10:52:58','615'),(2491,'','1','176','SYLBEST GAS LTD ','SYLBEST','08030494419','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 13:26:40',5,'615','2021-04-03 13:26:40','615'),(2492,'','1','176','EMEEY GAS LTD ','EMEEY','09083038478','aaranoapolpg@gmail.com','abuja','fct','APO RECITILIMENT ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 13:30:39',5,'615','2021-04-03 13:30:39','615'),(2493,'','1','176','ALBAT GAS LTD ','ALBAT',' 08086859435','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 15:01:08',5,'615','2021-04-03 15:01:08','615'),(2494,'','1','176','PRESIDOR GAS LTD.','CHAFI VILLAGE','08120113718','aaranoapolpg@gmail.com','abuja','fct','CHAFI VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 10:42:00',5,'615','2021-04-04 10:42:00','615'),(2496,'','1','176','COLA GAS LTD.','GAS RIGHT','08138447802','aaranoapolpg@gmail.com','abuja','fct','P&P EASTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 10:47:40',5,'615','2021-04-04 10:47:40','615'),(2498,'','1','176','VIN ENERGY GAS LTD ','VIN ENERGY','080388058817','aaranoapolpg@gmail.com','abuja','fct','AREA 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 12:23:36',5,'615','2021-05-10 13:02:13','615'),(2499,'','1','176','JULIUS GAS LTD ','JUDES GAS  ','08069516979','aaranoapolpg@gmail.com','abuja','fct','KADUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 12:29:58',5,'615','2022-11-27 11:07:26','615'),(2503,'','1','176','ENDURANCE GAS','GAS RIGHT','08135125514','aaranoapolpg@gmail.com','abuja','fct','DURUMI NEW SITE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 14:02:36',5,'615','2021-04-04 14:02:36','615'),(2507,'','1','176','patric gas','GAS RIGHT','08063661964','aaranoapolpg@gmail.com','abuja','fct','kabusa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-05 08:22:19',5,'615','2021-04-05 08:22:19','615'),(2509,'','1','176','NICE GAS LTD.','GAS RIGHT','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 07:35:50',5,'615','2021-04-06 07:35:50','615'),(2510,'','1','176','UGO BEST LTD.','GAS RIGHT','08131109277','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 07:38:25',5,'615','2021-04-06 07:38:25','615'),(2513,'','1','176','EBUKA GAS LTD','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 09:26:12',5,'615','2021-04-06 09:26:12','615'),(2519,'','1','176','glory gas l.td','JOHN','08086859435','abdull196596@gmail.com','abuja','fct','apo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 08:18:10',5,'615','2021-04-07 08:18:10','615'),(2520,'','1','176','EKENE GAS','GAS RIGHT','08160783096','abdull196596@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 08:35:53',5,'615','2021-04-07 08:35:53','615'),(2521,'','1','176','BUDIES GAS','GAS RIGHT','08091761813','abdull196596@gmail.com','abuja','fct','DURUMI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 08:44:30',5,'615','2021-04-07 08:44:30','615'),(2522,'','1','176','STEPHEN GAS','GAS RIGHT','08086859435','aaranoapolpg@gmail.com','abuja','fct','DURUMI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 09:32:57',5,'615','2021-04-07 09:32:57','615'),(2526,'','1','176','VIC GAS LTD.','GAS RIGHT','08032808008','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-08 09:03:05',5,'615','2021-04-08 09:03:05','615'),(2530,'','1','176','SOLOMON GAS LTD.','GAS RIGHT','08069621995','aaranoapolpg@gmail.com','abuja','fct','KAURA MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-08 14:58:57',5,'615','2021-04-08 14:58:57','615'),(2531,'','1','176','I.K GAS LTD.','GAS RIGHT','08033713967','abdull196596@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-08 15:27:47',5,'615','2021-04-08 15:27:47','615'),(2532,'','1','176','CHI BOY GAS LTD.','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-09 07:03:08',5,'615','2021-04-09 07:03:08','615'),(2533,'','1','176','CHINEDU GAS LTD ','CHINEDU GAS ','09014953282','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-09 10:01:36',5,'615','2021-04-09 10:01:36','615'),(2534,'','1','176','GABON GAS LTD.','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-09 11:14:24',5,'615','2021-04-09 11:14:24','615'),(2539,'','1','176','KELVIN GAS LTD ','KELVIN','09025087446','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 10:05:43',5,'615','2021-04-10 10:05:43','615'),(2542,'','1','176','EVER GREEN GAS ','EVER GREEN ','08035861408','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 16:06:23',5,'615','2021-04-10 16:06:23','615'),(2543,'','1','176','AESSY GAS LTD ','AESSY','09015126016','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 17:04:32',5,'615','2021-04-10 17:04:32','615'),(2544,'','1','176','AZIGVA GAS LTD','AZIGVA','07068606648','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 17:11:34',5,'615','2021-04-10 17:11:34','615'),(2549,'','1','176','PAUL GAS LTD ','PAUL','08028414966','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-11 14:03:57',5,'615','2021-07-04 09:17:49','615'),(2550,'','1','176','SYLVES GAS LTD.','GAS RIGHT','08030494412','aaranoapolpg@gmail.com','abuja','fct','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-12 11:06:22',5,'615','2021-04-12 11:06:22','615'),(2551,'','1','176','MERGIC GAS LTD.','GAS RIGHT','07033203960','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-12 11:47:49',5,'615','2021-04-12 11:47:49','615'),(2562,'','1','176','CHINDO YUSUFU GAS LTD ','CHNDO GAS ','07082041581','aaranoapolpg@gmail.com','abuja','fct','APO / DURUMI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-15 09:43:45',5,'615','2021-04-15 09:43:45','615'),(2563,'','1','176','CEE JAY GAS LTD.','GAS RIGHT','09059220495','aaranoapolpg@gmail.com','abuja','fct','DURUMI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-15 11:33:48',5,'615','2021-04-15 11:33:48','615'),(2574,'','1','176','ISAAC GAS LTD.','GAS RIGHT','09015126616','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-18 14:54:16',5,'615','2021-04-18 14:54:16','615'),(2578,'','1','176','JELIUS GAS LTD.','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-19 13:25:00',5,'615','2021-04-19 13:25:00','615'),(2579,'','1','176','K.C GAS LTD.','MIKE','08022152395','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-20 06:43:19',5,'615','2021-04-20 06:43:19','615'),(2582,'','1','176','PROMISE GAS LTD.','MIKE','08034030085','aaranoapolpg@gmail.com','abuja','fct','DURUMI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-20 09:05:40',5,'615','2021-04-20 09:05:40','615'),(2588,'','1','176','JONAL GAS LTD.','MIKE','07030307428','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 07:33:35',5,'615','2021-04-22 07:33:35','615'),(2591,'','1','176','VALANTINE GAS LTD ','VALANTINE ','08140331478','aaranoapolpg@gmail.com','abuja','fct','KABUSA JECTION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 12:45:11',5,'615','2021-04-22 12:45:11','615'),(2592,'','1','176','JONATHAN GAS LTD','MIKE','08086859435','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 16:06:05',5,'615','2021-04-22 16:06:05','615'),(2602,'','1','176','KENNETH GAS LTD','MIKE','08145528481','abdull196596@gmail.com','abuja','fct','DURUMI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-24 08:14:50',5,'615','2021-04-24 08:14:50','615'),(2607,'','1','176','BLESSING GAS LTD.','MIKE','07034750366','aaranoapolpg@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-25 11:47:38',5,'615','2021-04-25 11:47:38','615'),(2614,'','1','176','OMEGA GAS LTD.','MIKE','07066157935','abdull196596@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 07:01:10',5,'615','2021-04-27 07:01:10','615'),(2622,'','1','176','SUNDAY GAS LTD.','MIKE','08167795808','abdull196596@gmail.com','abuja','fct','APO DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-28 09:25:55',5,'615','2021-04-28 09:25:55','615'),(2626,'','1','176','ANTONY GAS LTD.','MIKE','08133914161','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-29 15:18:51',5,'615','2021-04-29 15:18:51','615'),(2628,'','1','176','PEACE GAS','MIKE','08039241980','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-30 09:02:35',5,'615','2021-04-30 09:02:35','615'),(2642,'','1','176','JOSEPH GAS LTD','JOSEPH GAS LTD','08022928967','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 13:37:42',5,'615','2021-05-02 13:37:42','615'),(2645,'','1','176','FRIADAY GAS ','FRIADAY ','09033709031','aaranoapolpg@gmail.com','abuja','fct','DURUMI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-03 10:51:16',5,'615','2021-05-03 10:51:16','615'),(2653,'','1','176','DURA GAS LTD ','DURA GAS ','08163338437','aaranoapolpg@gmail.com','abuja','fct','GARKI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-05 14:20:20',5,'615','2021-05-05 14:20:20','615'),(2658,'','1','176','FRANK WHAT GAS LTD ','FRANK ','08039597284','aaranoapolpg@gmail.com','abuja','fct','SAVANAH ESTATE DURUMI 2 ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-07 16:18:46',5,'615','2021-05-07 16:18:46','615'),(2663,'','1','176','EJIKE GAS LTD.','EJIKE GAS LTD.','07030767699','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-09 08:57:45',5,'615','2021-05-09 08:57:45','615'),(2664,'','1','176','EVARISTUS GAS LTD','EVARITUS','08066782921','aaranoapolpg@gmail.com','abuja','fct','CHAPI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-09 11:34:38',5,'615','2021-05-09 11:34:38','615'),(2666,'','1','176','BEN GAS LTD.','BEN GAS LTD.','08036328248','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-10 13:03:33',5,'615','2021-05-10 13:03:33','615'),(2673,'','1','176','ENERGY GAS LTD.','ENERGY GAS LTD.','08032108297','aaranoapolpg@gmail.com','abuja','fct','DURUMI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-13 11:38:25',5,'615','2021-05-13 11:38:25','615'),(2674,'','1','176','LOLO GAS LTD','MIKE','08035958700','aaranoapolpg@gmail.com','abuja','fct','PRINCE AND PRINCEES EASTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-14 06:33:49',5,'615','2021-05-14 06:33:49','615'),(2686,'','1','176','ONYEKA GAS','ONYEKA','07034598578','abdull196596@gmail.com','abuja','fct','APO DUTSE OPP BAKASI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-18 15:37:56',5,'615','2022-11-24 13:05:07','615'),(2687,'','1','176','OLUNIFE ','BAKERY','08022579512','aaranoapolpg@gmail.com','abuja','fct','COPA CABANA EASTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-18 16:01:08',5,'615','2021-05-18 16:01:08','615'),(2688,'','1','176','SHAKULALA GAS LTD.','GAS RIGHT','08035222818','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-18 16:02:32',5,'615','2021-05-18 16:02:32','615'),(2695,'','1','176','A.B GAS','GAS LORD','08033586827','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-20 13:05:09',5,'615','2021-05-20 13:05:09','615'),(2697,'','1','176','IGNATIUS GAS','MIKE',' 08157505041','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-21 07:10:06',5,'615','2021-05-21 07:10:06','615'),(2699,'','1','176','FRANCO GAS','FRANCO','08060312287','aaranoapolpg@gmail.com','abuja','fct','AREA II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-21 14:58:00',5,'615','2021-05-21 14:58:00','615'),(2700,'','1','176','ISAH GAS LTD','ISAH GAS ','08036456147','aaranoapolpg@gmail.com','abuja','fct','GARKI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-22 08:06:46',5,'615','2021-05-22 08:06:46','615'),(2712,'','1','176','T0VIST GAS ','TOVIST','08123292635','aaranoapolpg@gmail.com','abuja','fct','AREA 11','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-30 13:21:42',5,'615','2021-05-30 13:21:42','615'),(2725,'','1','176','ELVIS GAS LTD ','ELVIS GAS ','09060731783','aaranoapolpg@gmail.com','abuja','fct','DUTSE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-03 16:59:47',5,'615','2021-06-03 16:59:47','615'),(2730,'','1','176','I G GAS LTD ','I G GAS ','08167505041','aaranoapolpg@gmail.com','abuja','fct','KABUSA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-08 10:58:28',5,'615','2021-06-08 10:58:28','615'),(2766,'','1','176','ROCK GAS LTD.','GAS RIGHT','08132428017','aaranoapolpg@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:57:48',5,'615','2021-06-18 11:57:48','615'),(2793,'','1','176','RECHINEL UKA GAS LTD ','REJENEL GAS ','080523828','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 12:59:43',5,'615','2021-06-21 12:59:43','615'),(2838,'','1','176','JIORJI OTI GAS ','O T I GAS ','08038914536','aaranoapolpg@gmail.com','abuja','fct','ZONE C','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 15:21:48',5,'615','2021-06-25 15:21:48','615'),(2853,'','1','176','GEORGE OTI GAS','GAS RIGHT','08038914536','abdull196596@gmail.com','abuja','fct','APO ZONE C','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 06:11:24',5,'615','2021-06-28 06:11:24','615'),(2858,'','1','176','TIMOTHY GAS LTD.','TIMOTHY ','08068037188','aaranoapolpg@gmail.com','abuja','fct','ASOKORO VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 13:24:04',5,'615','2021-06-28 13:24:04','615'),(2879,'','1','176','LIVERTY GAS ','LIVERTY GAS','08117677888','aaranoapolpg@gmail.com','abuja','fct','ASOKORO VILAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 15:37:54',5,'615','2021-06-30 15:37:54','615'),(2881,'','1','176','JUWELL GAS ','JUWELL','08050779151','aaranoapolpg@gmail.com','abuja','fct','ASOKORO ESTENTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 16:52:48',5,'615','2021-06-30 16:52:48','615'),(2903,'','1','176','YANNI GAS ','YANNI ','09054218262','aaranoapolpg@gmail.com','abuja','fct','KABUSA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-06 09:55:18',5,'615','2021-07-06 09:55:18','615'),(2904,'','1','176','SUCCESS GAS','SUCCESS','08187092447','aaranoapolpg@gmail.com','abuja','fct','DURUMI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-06 14:18:34',5,'615','2021-07-06 14:18:34','615'),(2909,'','1','176','ARIZONA GAS LTD.','EMMA','09064058560','abdull196596@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-07 13:00:53',5,'615','2023-01-04 17:05:17','615'),(2952,'','1','176','JIDEOFOR GAS LTD.','GAS RIGHT','08036407301','aaranoapolpg@gmail.com','abuja','fct','DURUMI I','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-18 08:36:25',5,'615','2021-07-18 08:36:25','615'),(2997,'','1','176','ATUSON GAS LTD','GAS RIGHT','09039177615','aaranoapolpg@gmail.com','abuja','fct','AREA III','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 07:43:59',5,'615','2021-07-31 07:43:59','615'),(3009,'','1','176','SPIDINO GAS LTD.','SPIDINO ','08055537379','abdull196596@gmail.com','abuja','fct','AREA III','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-02 11:42:59',5,'615','2021-08-02 11:42:59','615'),(3075,'','1','176','EDSEEN GAS LTD','EDESEN','07032860196','aaranoapolpg@gmail.com','abuja','fct','PRINCESS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 14:35:00',5,'615','2021-08-14 14:35:00','615'),(3106,'','1','176','CJ NIG LTD','CJ GAS ','09059220495','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 15:18:15',5,'615','2021-08-17 15:18:15','615'),(3119,'','1','176','JIMOH GAS LTD','JIMOH','08050606401','abdull196596@gmail.com','abuja','fct','AREA I','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-19 11:25:19',5,'615','2021-08-19 11:25:19','615'),(3144,'','1','176','OKWISCO GAS ','OKWISCO','08037258644','aaranoapolpg@gmail.com','abuja','fct','NNPC GAMES VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-23 13:20:26',5,'615','2021-08-23 13:20:26','615'),(3147,'','1','176','S G GAS LTD.','S G GAS','08065009007','abdull196596@gmail.com','abuja','fct','KOBI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-24 08:58:05',5,'615','2021-08-24 08:58:05','615'),(3164,'','1','176','JACOB GAS','JACOB','09045353601','abdull196596@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 09:40:50',5,'615','2021-08-30 09:40:50','615'),(3171,'','1','176','JOSSY GAS LTD ','JOSSY','07066196320','aaranoapolpg@gmail.com','abuja','fct','KOBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 14:51:23',5,'615','2021-08-30 14:51:23','615'),(3177,'','1','176','UCHE GAS LTD','UCHE GAS','08089236614','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-31 08:02:54',5,'615','2021-08-31 08:02:54','615'),(3180,'','1','176','MAKEL GAS LTD','MAKEL','0000000000','aaranoapolpg@gmail.com','abuja','fct','APO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-01 15:44:39',5,'615','2021-09-01 15:44:39','615'),(3184,'','1','176','CHIMA GAS LTD','CHIMA','08184583377','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-02 14:39:45',5,'615','2021-09-02 14:39:45','615'),(3185,'','1','176','TOBEST GAS LTD','TOBEST GAS','08036271195','aaranoapolpg@gmail.com','abuja','fct','AREA 11','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-03 07:47:51',5,'615','2021-09-22 15:22:13','615'),(3340,'','1','176','SHEHU GAS','SHEHU','09096224542','aaranoapolpg@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-22 11:13:20',5,'615','2021-09-22 11:13:20','615'),(3727,'','1','176','KING JAMES GAS LTD.','KING JAMES','08025302498','aaranoapolpg@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-11 09:10:30',5,'615','2021-11-11 09:10:30','615'),(3757,'','1','176','NAPSON GAS L.T.D','NAPSON ','08035918906','aaranoapolpg@gmail.com','abuja','fct','GARKI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-15 11:51:20',5,'615','2021-11-15 11:51:20','615'),(3934,'','1','176','A.E.S.G OIL & GAS','A.E.S.G','07032397359','abdull196596@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-02 10:11:40',5,'615','2021-12-02 10:11:40','615'),(4052,'','1','176','CHIDI GAS ','CHIDI','07051652832','aaranoapolpg@gmail.com','abuja','fct','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-19 13:32:16',5,'615','2021-12-19 13:32:16','615'),(4238,'','1','176','HAYATU GAS LTD.','HAYATU','07067552126','abdull196596@gmail.com','abuja','fct','DURUMI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-25 08:26:43',5,'615','2022-01-25 08:26:43','615'),(4239,'','1','176','OBEC OIL & GAS','LIVERTY GAS','08035899212','abdull196596@gmail.com','abuja','fct','GARKI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-25 14:29:08',5,'615','2022-01-25 14:29:08','615'),(4250,'','1','176','BUY MY GAS LIMITED','BMG','08131375754','aaranoapolpg@gmail.com','abuja','fct','LITTLE ACCORNS LOKOGOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-29 14:50:50',5,'615','2022-01-29 14:50:50','615'),(4251,'','1','176','GIGEON GAS LTD ','GIGEON GAS','08117775538','aaranoapolpg@gmail.com','abuja','fct','DURUMI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-10 13:13:20',5,'615','2022-02-10 13:13:20','615'),(4252,'','1','176','BEN I GAS','OKWISCO','08037910046','abdull196596@gmail.com','abuja','fct','PRINCE&PRINCESS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-11 11:09:57',5,'615','2022-02-11 11:09:57','615'),(4253,'','1','176','LIFE GAS LTD.','GAS RIGHT','09037032289','abdull196596@gmail.com','abuja','fct','ASOKORO  VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-18 16:42:05',5,'615','2022-02-18 16:42:05','615'),(4254,'','1','176','EMMA BEST NIG LTD ','EMMA BEST','08068502811','aaranoapolpg@gmail.com','abuja','fct','GARKI ABUJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 13:29:00',5,'615','2022-03-05 13:29:00','615'),(4255,'','1','176','DAN JOS GAS','DAN JOS','07041252209','aaranoapolpg@gmail.com','abuja','fct','GARKI II','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-31 08:37:39',5,'615','2022-03-31 08:37:39','615'),(4256,'','1','176','IFEANYE GAS ','LIVERTY GAS','07055229074','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-03 07:39:07',5,'615','2022-04-03 07:39:07','615'),(4257,'','1','176','DAVID GAS LTD ','DAVID GAS ','08094184644','aaranoapolpg@gmail.com','abuja','fct','APO INTERNER ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-21 16:27:43',5,'615','2022-04-21 16:27:43','615'),(4258,'','1','176','HASSAN GAS LTD ','HASSAN GAS ','08062842079','aaranoapolpg@gmail.com','abuja','fct','GARKI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-29 15:23:48',5,'615','2022-04-29 15:23:48','615'),(4259,'','1','176','ZAKS GAS LTD ','ZAKS GAS ','080675453454','abdull196596@gmail.com','abuja','fct','ETERNER ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-30 14:43:54',5,'615','2022-04-30 14:43:54','615'),(4260,'','1','176','SANI BACHA','SANI BACHA','08067144842','aaranoapolpg@gmail.com','abuja','fct','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 15:49:21',5,'615','2022-05-25 15:49:21','615'),(4261,'','1','176','EMESON GAS','GAS RIGHT','07035560376','aaranoapolpg@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 09:19:07',5,'615','2022-05-26 09:19:07','615'),(4262,'','1','176','DOME GAS','GAS RIGHT','07030640989','aaranoapolpg@gmail.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 14:55:30',5,'615','2022-08-06 14:55:30','615'),(4263,'','1','176','EMEKUS GAS','EMEKUS GAS','09025923418','emekusgas@gmail.com','ABUJA','ABUJA','APO PIGBMA SAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-02 08:51:52',5,'615','2022-10-02 08:51:52','615'),(4264,'','1','176','TRUSTED GAS','PRINCE CHIBOZOR','08177909741','princechibozor@gmail.com','ABUJA','FCT','DIRIMI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-02 12:48:45',5,'615','2022-10-02 12:48:45','615'),(4265,'','1','176','EMEKA GAS','CHUKUMA','07058872034','emekagas@gmail.com','ABUJA','ABUJA','DURUMI AP','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 07:25:19',5,'615','2022-11-21 07:25:19','615'),(4266,'','1','176','ONSHINE GLOBAL','SUNDAY','08036860643','sundaynwodo@gmail.com','FCT','Abuja','Area 1 by zenith bank, FCT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 07:00:11',5,'615','2022-11-24 07:00:11','615'),(4267,'','1','176','PRIN-SEN','ABUJA','08036288473','sundayprn@yahoo.com','FCT','ABUJA','ABJ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 14:07:43',5,'615','2022-11-29 14:07:43','615'),(4268,'','1','176','ONYI GAS','ONYI','08105227286','apolpg@gmail.com','FCT','ABUJA','Durumi 2, ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-01 16:08:27',5,'615','2022-12-01 16:08:27','615'),(4269,'','1','176','JUDEX GAS','JUDEX','08028906457','apolpg@gmail.com','FCT','ABUJA','DURUMI 3','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-02 17:42:23',5,'615','2022-12-02 17:42:23','615'),(4270,'','1','176','LOUIS GAS','LOUIS','08169895009','apolpg@gmail.com','APO','ABUJA','APO DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-19 08:08:51',5,'615','2022-12-19 08:08:51','615'),(4271,'','1','176','OLAS GAS','AKEEM','09015066799','akeembabayemi94@gmail.com','FCT','ABUJA','DURUMI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-20 09:33:03',5,'615','2022-12-20 09:33:03','615'),(4272,'','1','176','C K 1 GAS','CK1','08037017953','apolpg@gmail.com','FCT','ABUJA','GARKI AREA 11','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-20 11:02:46',5,'615','2022-12-20 11:02:46','615'),(4273,'','1','176','CHIDON GAS','CHIDI','07051652832','apolpg@gmail.com','FCT','ABUJA','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-22 09:12:44',5,'615','2022-12-22 09:12:44','615'),(4274,'','1','176','A K C GAS','A K C GAS','08068032081','apolpg@gmail.com','FCT','ABUJA','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-25 16:41:55',5,'615','2022-12-25 16:41:55','615'),(4275,'','1','176','DOGARA GAS','DOGARA','09072134106','apolpg@gmail.com','FCT','ABUJA','APO PRIMARY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-26 12:20:18',5,'615','2022-12-26 12:20:18','615'),(4276,'','1','176','UGOCHUKWU GAS','UGOCHUKWU','08133462967','apolpg@gmail.com','FCT','ABUJA','KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-26 12:36:45',5,'615','2022-12-26 12:36:45','615'),(4277,'','1','176','CALYON GAS','CALYON','08036268839','apolpg@gmail.com','FCT','ABUJA','DURUMI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-26 14:00:28',5,'615','2022-12-26 14:00:28','615'),(4278,'','1','176','ROMSY GAS','BENEDICT','08181194567','apolpg@gmail.com','FCT','ABUJA','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-08 16:23:24',5,'615','2023-01-08 16:23:24','615'),(4279,'','1','176','AFACO GAS','AFACO','08036190714','apolpg@gmail.com','FCT','ABUJA','AMINA ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-10 12:51:35',5,'615','2023-01-10 12:51:35','615'),(4280,'','1','176','BELLA GAS','BELLA','09081831824','apolpg@gmail.com','ABUJA','FCT','APO PRIMARY SCH','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-07 11:15:36',5,'615','2023-02-07 11:15:36','615'),(4281,'','1','176','CHIBIKE GAS','CHIBUEKE','08171147164','apolpg@gmail.com','ABUJA','FCT','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-07 12:45:56',5,'615','2023-02-07 12:45:56','615'),(4282,'','1','176','CHICON GAS','CHICON','08037041476','apolpg@gmail.com','ABUJA','FCT','AREA 3, GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-09 09:06:00',5,'615','2023-02-09 09:06:00','615'),(4283,'','1','176','CHIBUZOR','IBRAHIM IBRAHIM BILYA','07039471647','apolpg@gmail.com','KANO','NIGERIA','299, MAIFATA STREET, UNGUWA UKU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-22 12:04:57',5,'615','2023-02-22 12:04:57','615'),(4284,'','1','176','O G B GAS','OGB','07069751777','apolpg@gmail.com','ABUJA','FCT','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-26 09:42:11',5,'615','2023-02-26 09:42:11','615');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=356 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (354,'1','176','2455',0,'MY HOT LINE','2021-05-05 15:51:00'),(355,'1','176','2455',5,'MY HOT LINE','2021-05-05 15:53:06');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16361 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','176',16360,'920',1568.33,594.00,'2021-09-08','new dipping','2021-09-08 18:14:19','483','483',2021,'483','2021-09-08 18:14:19',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2724 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','176','920',2720,'5','LPG NOZZLE 1',490643.85,'LPG DESPENSER','',NULL,NULL,'',5,'2022-02-01 20:39:10','483'),('1','176','920',2721,'5','LPG NOZZLE 2',208768.18,'LPG DESPENSER','',NULL,NULL,'',5,'2022-02-01 20:39:52','483'),('1','176','920',2722,'5','LPG NOZZLE 3',110013.54,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','176','920',2723,'5','LPG NOZZLE 4',37116.77,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258046 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','176',186034,'DAILY SALES','2021-03-22','2021-03-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-22 17:20:47','615','2021-03-22 17:21:07',10,0),('1','176',186126,'DAILY SALES','2021-03-23','2021-03-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-23 16:12:44','615','2021-03-23 16:13:39',10,0),('1','176',186376,'DAILY SALES','2021-03-24','2021-03-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-24 17:29:00','615','2021-03-24 17:29:33',10,0),('1','176',186557,'DAILY SALES','2021-03-25','2021-03-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-25 20:25:12','615','2021-03-25 20:26:07',10,0),('1','176',186779,'DAILY SALES','2021-03-26','2021-03-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-26 18:05:37','615','2021-03-26 18:10:00',10,0),('1','176',187012,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-27 17:18:16','615','2021-03-27 17:18:40',10,0),('1','176',187218,'DAILY SALES','2021-03-28','2021-03-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-28 17:26:02','615','2021-03-28 17:32:35',10,0),('1','176',187465,'DAILY SALES','2021-03-29','2021-03-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-29 17:49:10','615','2021-03-29 17:51:40',10,0),('1','176',187681,'DAILY SALES','2021-03-30','2021-03-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-30 11:50:27','615','2021-03-30 11:50:57',10,0),('1','176',187682,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-30 12:01:01','615','2021-03-30 12:01:20',10,0),('1','176',187687,'DAILY SALES','2021-03-30','2021-03-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-30 12:11:14','615','2021-03-30 12:11:42',10,0),('1','176',187718,'DAILY SALES','2021-03-30','2021-03-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-30 17:55:06','615','2021-03-30 17:57:13',10,0),('1','176',187864,'DAILY SALES','2021-03-31','2021-03-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-03-31 18:18:49','615','2021-03-31 18:19:06',10,0),('1','176',188091,'DAILY SALES','2021-03-31','2021-03-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-02 14:08:02','615','2021-04-02 14:08:30',10,0),('1','176',188355,'DAILY SALES','2021-04-02','2021-04-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-02 16:18:16','615','2021-04-02 16:19:05',10,0),('1','176',188367,'DAILY SALES','2021-04-02','2021-04-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-02 18:41:09','615','2021-04-02 18:49:57',10,0),('1','176',188443,'DAILY SALES','2021-04-02','2021-04-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-03 08:02:44','615','2021-04-03 08:03:26',10,0),('1','176',188453,'DAILY SALES','2021-04-03','2021-04-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-03 17:28:14','615','2021-04-03 17:28:52',10,0),('1','176',188564,'DAILY SALES','2021-04-03','2021-04-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-03 17:51:52','615','2021-04-03 17:56:21',10,0),('1','176',188663,'DAILY SALE','2021-04-04','2021-04-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-04 16:59:58','615','2021-04-04 17:00:24',10,0),('1','176',188802,'DAILY SALES','2021-04-05','2021-04-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-05 13:52:47','615','2021-04-05 13:53:28',10,0),('1','176',188920,'DAILY SALES','2021-04-05','2021-04-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-05 14:10:10','615','2021-04-05 14:11:05',10,0),('1','176',188924,'DAILY SALES','2021-04-05','2021-04-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-05 17:34:29','615','2021-04-05 17:35:01',10,0),('1','176',189012,'DAILY SALES','2021-04-06','2021-04-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-06 17:37:16','615','2021-04-06 17:37:40',10,0),('1','176',189158,'DAILY SALES','2021-04-06','2021-04-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-06 18:23:21','615','2021-04-06 18:24:06',10,0),('1','176',189160,'DAILY SALES','2021-04-06','2021-04-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-06 18:37:03','615','2021-04-06 18:37:23',10,0),('1','176',189216,'DAILY SALES','2021-04-07','2021-04-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-07 15:35:03','615','2021-04-07 15:35:40',10,0),('1','176',189378,'DAILY SALES','2021-04-07','2021-04-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-07 18:32:03','615','2021-04-07 18:32:25',10,0),('1','176',189425,'DAILY SALES','2021-04-08','2021-04-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-08 17:05:18','615','2021-04-08 17:05:39',10,0),('1','176',189582,'DAILY SALES','2021-04-08','2021-04-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-08 17:51:36','615','2021-04-08 17:52:05',10,0),('1','176',189620,'DAILY SALES','2021-04-09','2021-04-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-09 18:06:17','615','2021-04-09 18:06:47',10,0),('1','176',189823,'DAILY SALES','2021-04-10','2021-04-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-10 09:07:30','615','2021-04-10 09:07:49',10,0),('1','176',189874,'DAILY SALES','2021-04-10','2021-04-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-10 09:54:51','615','2021-04-10 09:55:14',10,0),('1','176',189878,'DAILY SALES','2021-04-10','2021-04-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-10 17:57:01','615','2021-04-10 17:57:20',10,0),('1','176',190038,'DAILY SALES','2021-04-11','2021-04-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-11 13:51:37','615','2021-04-11 13:51:59',10,0),('1','176',190131,'DAILY SALES','2021-04-11','2021-04-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-11 16:45:42','615','2021-04-11 16:46:09',10,0),('1','176',190222,'DAILY SALES','2021-04-12','2021-04-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-12 17:06:32','615','2021-04-12 17:16:01',10,0),('1','176',190397,'DAILY SALES','2021-04-11','2021-04-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-12 17:49:22','615','2021-04-12 17:49:40',10,0),('1','176',190398,'DAILY SALES','2021-04-12','2021-04-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-12 17:53:46','615','2021-04-12 17:54:04',10,0),('1','176',190430,'DAILY SALES','2021-04-13','2021-04-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-13 15:41:23','615','2021-04-13 15:42:12',10,0),('1','176',190624,'DAILY SALES','2021-04-13','2021-04-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-13 16:10:42','615','2021-04-13 16:11:36',10,0),('1','176',190693,'DAILY SALES','2021-04-14','2021-04-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-14 16:58:56','615','2021-04-14 17:00:22',10,0),('1','176',190891,'DAILY SALES','2021-04-15','2021-04-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-15 07:33:07','615','2021-04-15 07:34:24',10,0),('1','176',190900,'DAILY SALES','2021-04-15','2021-04-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-15 16:37:54','615','2021-04-15 16:38:40',10,0),('1','176',191172,'DAILY SALES','2021-04-16','2021-04-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-16 11:43:55','615','2021-04-16 11:44:33',10,0),('1','176',191185,'DAILY SALES','2021-04-16','2021-04-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-16 17:23:53','615','2021-04-16 17:24:50',10,0),('1','176',191289,'DAILY SALES','2021-04-17','2021-04-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-17 09:24:13','615','2021-04-17 09:24:34',10,0),('1','176',191351,'DAILY SALES','2021-04-17','2021-04-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-17 17:35:29','615','2021-04-17 17:35:47',10,0),('1','176',191499,'DAILY SALES','2021-04-18','2021-04-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-18 14:01:46','615','2021-04-18 14:02:20',10,0),('1','176',191617,'DAILY SALES','2021-04-18','2021-04-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-18 17:13:28','615','2021-04-18 17:15:40',10,0),('1','176',191713,'DAILY SALES','2021-04-19','2021-04-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-19 12:35:22','615','2021-04-19 12:35:44',10,0),('1','176',191839,'DAILY SALES','2021-04-19','2021-04-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-19 12:55:08','615','2021-04-19 12:55:29',10,0),('1','176',191845,'DAILY SALES','2021-04-19','2021-04-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-19 17:30:31','615','2021-04-19 17:30:53',10,0),('1','176',191935,'DAILY SALES','2021-04-20','2021-04-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-20 12:48:21','615','2021-04-20 12:50:51',10,0),('1','176',192054,'DAILY SALES','2021-04-20','2021-04-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-20 13:43:22','615','2021-04-20 13:43:48',10,0),('1','176',192061,'DAILY SALES','2021-04-20','2021-04-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-20 17:41:51','615','2021-04-20 17:42:10',10,0),('1','176',192137,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-21 11:13:07','615','2021-04-21 11:13:30',10,0),('1','176',192225,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-21 17:11:58','615','2021-04-21 17:14:29',10,0),('1','176',192343,'DAILY SALES','2021-04-22','2021-04-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-22 11:22:09','615','2021-04-22 11:23:23',10,0),('1','176',192447,'DAILY SALES','2021-04-22','2021-04-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-22 16:31:38','615','2021-04-22 16:32:32',10,0),('1','176',192575,'DAILY SALES','2021-04-23','2021-04-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-23 11:24:40','615','2021-04-23 11:27:00',10,0),('1','176',192646,'DAILY SALES','2021-04-23','2021-04-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-23 17:00:48','615','2021-04-23 17:01:30',10,0),('1','176',192759,'DAILY SALES','2021-04-24','2021-04-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-24 09:13:02','615','2021-04-24 09:14:02',10,0),('1','176',192854,'DAILY SALES','2021-04-24','2021-04-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-24 16:42:22','615','2021-04-24 16:42:51',10,0),('1','176',192991,'DAILY SALES','2021-04-25','2021-04-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-25 09:58:37','615','2021-04-25 09:58:58',10,0),('1','176',193014,'DAILY SALES','2021-04-25','2021-04-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-25 10:36:04','615','2021-04-25 10:36:23',10,0),('1','176',193019,'DAILY SALES','2021-04-25','2021-04-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-25 16:48:03','615','2021-04-25 16:48:39',10,0),('1','176',193177,'DAILY SALES','2021-04-26','2021-04-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-26 12:27:21','615','2021-04-26 12:29:00',10,0),('1','176',193282,'DAILY SALES','2021-04-26','2021-04-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-26 12:57:45','615','2021-04-26 12:58:18',10,0),('1','176',193291,'DAILY SALES','2021-04-26','2021-04-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-26 16:44:20','615','2021-04-26 16:45:30',10,0),('1','176',193407,'DAILY SALES','2021-04-27','2021-04-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-27 12:05:29','615','2021-04-27 12:08:31',10,0),('1','176',193510,'DAILY SALES','2021-04-27','2021-04-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-27 12:29:17','615','2021-04-27 12:29:41',10,0),('1','176',193513,'DAILY SALES','2021-04-27','2021-04-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-27 16:58:32','615','2021-04-27 16:59:30',10,0),('1','176',193628,'DAILY SALES','2021-04-28','2021-04-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-28 11:12:52','615','2021-04-28 11:13:14',10,0),('1','176',193732,'DAILY SALES','2021-04-28','2021-04-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-28 17:48:13','615','2021-04-28 17:48:43',10,0),('1','176',193852,'DAILY SALES','2021-04-29','2021-04-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-29 12:49:36','615','2021-04-29 12:50:25',10,0),('1','176',193979,'DAILY SALES','2021-04-28','2021-04-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-29 12:55:23','615','2021-04-29 12:55:40',10,0),('1','176',193983,'DAILY SALES','2021-04-29','2021-04-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-29 13:01:50','615','2021-04-29 13:02:24',10,0),('1','176',193990,'DAILY SALES','2021-04-29','2021-04-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-29 16:48:02','615','2021-04-29 16:49:52',10,0),('1','176',194082,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-30 12:41:03','615','2021-04-30 12:41:37',10,0),('1','176',194184,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-04-30 16:58:51','615','2021-04-30 17:00:07',10,0),('1','176',194292,'DAILY SALES','2021-05-01','2021-05-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-01 12:45:44','615','2021-05-01 12:46:05',10,0),('1','176',194393,'DAILY SALES','2021-05-01','2021-05-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-01 17:18:57','615','2021-05-01 17:19:56',10,0),('1','176',194498,'DAILY SALES','2021-05-02','2021-05-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-02 13:16:31','615','2021-05-02 13:16:59',10,0),('1','176',194577,'DAILY SALES','2021-05-02','2021-05-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-02 16:12:19','615','2021-05-02 16:12:41',10,0),('1','176',194685,'DAILY SALES','2021-05-03','2021-05-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-03 11:40:38','615','2021-05-03 11:41:12',10,0),('1','176',194781,'DAILY SALES','2021-05-03','2021-05-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-03 16:57:00','615','2021-05-03 16:57:36',10,0),('1','176',194963,'DAILY SALES','2021-05-04','2021-05-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-04 14:02:06','615','2021-05-04 14:02:29',10,0),('1','176',194978,'DAILY SALES','2021-05-04','2021-05-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-04 14:14:36','615','2021-05-04 14:14:56',10,0),('1','176',194992,'DAILY SALES','2021-05-04','2021-05-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-04 17:11:39','615','2021-05-04 17:11:59',10,0),('1','176',195081,'DAILY SALES','2021-05-05','2021-05-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-05 11:21:56','615','2021-05-05 11:22:29',10,0),('1','176',195186,'DAILY SALES','2021-05-05','2021-05-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-05 17:02:57','615','2021-05-05 17:03:49',10,0),('1','176',195312,'DAILY SALES','2021-05-06','2021-05-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-06 11:17:48','615','2021-05-06 11:18:31',10,0),('1','176',195397,'DAILY SALES','2021-05-06','2021-05-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-06 16:36:20','615','2021-05-06 16:36:54',10,0),('1','176',195519,'DAILY SALES','2021-05-07','2021-05-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-07 10:05:17','615','2021-05-07 10:05:44',10,0),('1','176',195608,'DAILY SALES','2021-05-07','2021-05-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-07 17:04:16','615','2021-05-07 17:04:52',10,0),('1','176',195781,'DAILY SALES','2021-05-08','2021-05-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-08 11:53:07','615','2021-05-08 11:54:23',10,0),('1','176',195876,'DAILY SALES','2021-05-08','2021-05-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-08 17:00:43','615','2021-05-08 17:01:04',10,0),('1','176',196004,'DAILY SALES','2021-05-09','2021-05-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-09 10:35:57','615','2021-05-09 10:36:34',10,0),('1','176',196083,'DAILY SALES','2021-05-09','2021-05-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-09 10:55:53','615','2021-05-09 10:56:15',10,0),('1','176',196089,'DAILY SALES','2021-05-09','2021-05-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-09 16:51:38','615','2021-05-09 16:54:59',10,0),('1','176',196232,'DAILY SALES','2021-05-10','2021-05-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-10 10:01:17','615','2021-05-10 10:02:46',10,0),('1','176',196313,'DAILY SALES','2021-05-10','2021-05-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-10 16:52:55','615','2021-05-10 16:59:17',10,0),('1','176',196443,'DAILY SALES','2021-05-11','2021-05-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-11 09:39:27','615','2021-05-11 09:41:16',10,0),('1','176',196522,'DAILY SALES','2021-05-11','2021-05-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-11 17:12:21','615','2021-05-11 17:19:54',10,0),('1','176',196678,'DAILY SALES','2021-05-12','2021-05-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-12 11:45:52','615','2021-05-12 11:46:15',10,0),('1','176',196755,'DAILY SALES','2021-05-12','2021-05-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-12 16:57:44','615','2021-05-12 16:58:07',10,0),('1','176',196905,'Daily sales ','2021-05-13','2021-05-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-13 14:27:50','615','2021-05-13 14:28:12',10,0),('1','176',196957,'DAILY SALES','2021-05-13','2021-05-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-13 18:22:52','615','2021-05-13 18:23:16',10,0),('1','176',197033,'DAILY SALES','2021-05-14','2021-05-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-14 17:19:36','615','2021-05-14 17:20:00',10,0),('1','176',197177,'Daily sales ','2021-05-14','2021-05-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-14 17:36:26','615','2021-05-14 17:37:01',10,0),('1','176',197319,'DAILY SALES','2021-05-16','2021-05-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-16 13:05:23','615','2021-05-16 13:05:45',10,0),('1','176',197394,'DAILY SALES','2021-05-16','2021-05-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-16 13:16:02','615','2021-05-16 13:16:22',10,0),('1','176',197424,'DAILY SALES','2021-05-16','2021-05-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-16 17:20:12','615','2021-05-16 17:24:53',10,0),('1','176',197513,'DAILY SALES','2021-05-17','2021-05-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-17 17:04:25','615','2021-05-17 17:11:30',10,0),('1','176',197882,'DAILY SALES','2021-05-18','2021-05-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-18 09:32:27','615','2021-05-18 09:34:29',10,0),('1','176',197952,'DAILY SALES','2021-05-18','2021-05-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-18 17:21:22','615','2021-05-18 17:22:13',10,0),('1','176',198130,'DAILY SALES','2021-05-19','2021-05-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-19 10:49:05','615','2021-05-19 10:49:24',10,0),('1','176',198205,'DAILY SALES','2021-05-19','2021-05-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-19 17:12:49','615','2021-05-19 17:13:14',10,0),('1','176',198347,'DAILY SALES','2021-05-20','2021-05-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-20 15:58:33','615','2021-05-20 15:58:56',10,0),('1','176',198518,'DAILY SALES','2021-05-20','2021-05-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-20 16:05:58','615','2021-05-20 16:06:22',10,0),('1','176',198521,'DAILY SALES','2021-05-20','2021-05-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-20 17:38:30','615','2021-05-20 17:38:56',10,0),('1','176',198573,'DAILY SALES','2021-05-21','2021-05-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-21 17:41:57','615','2021-05-21 17:42:19',10,0),('1','176',198786,'DAILY SALES','2021-05-22','2021-05-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-22 07:44:49','615','2021-05-22 07:45:20',10,0),('1','176',198808,'DAILY SALES','2021-05-22','2021-05-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-22 17:26:24','615','2021-05-22 17:26:48',10,0),('1','176',198949,'DAILY SALES','2021-05-22','2021-05-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-22 18:02:07','615','2021-05-22 18:02:29',10,0),('1','176',198987,'DAILY SALES','2021-05-23','2021-05-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-23 16:41:44','615','2021-05-23 16:42:02',10,0),('1','176',199210,'DAILY SALES','2021-05-24','2021-05-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-24 07:34:24','615','2021-05-24 07:34:46',10,0),('1','176',199244,'DAILY SALES','2021-05-24','2021-05-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-24 17:39:44','615','2021-05-24 17:40:11',10,0),('1','176',199434,'DAILY SALES','2021-05-25','2021-05-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-25 08:11:10','615','2021-05-25 08:11:34',10,0),('1','176',199480,'DAILY SALES','2021-05-25','2021-05-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-25 17:40:30','615','2021-05-25 17:41:02',10,0),('1','176',199648,'DAILY SALES','2021-05-26','2021-05-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-26 10:50:08','615','2021-05-26 10:50:36',10,0),('1','176',199770,'DAILY SALES','2021-05-26','2021-05-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-26 10:55:10','615','2021-05-26 10:55:48',10,0),('1','176',199771,'DAILY SALES','2021-05-26','2021-05-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-26 17:24:55','615','2021-05-26 17:25:29',10,0),('1','176',199865,'DAILY SALES','2021-05-27','2021-05-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-27 16:31:03','615','2021-05-27 16:31:48',10,0),('1','176',200056,'DAILY SALES','2021-05-27','2021-05-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-27 17:21:19','615','2021-05-27 17:21:43',10,0),('1','176',200094,'DAILY SALES','2021-05-28','2021-05-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-28 17:28:27','615','2021-05-28 17:28:55',10,0),('1','176',200292,'DAILY SALES','2021-05-29','2021-05-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-29 06:38:04','615','2021-05-29 06:38:26',10,0),('1','176',200299,'DAILY SALES','2021-05-29','2021-05-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-29 17:23:42','615','2021-05-29 17:24:10',10,0),('1','176',200453,'DAILY SALES','2021-05-29','2021-05-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-29 17:33:56','615','2021-05-29 17:34:12',10,0),('1','176',200485,'DAILY SALES','2021-05-30','2021-05-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-30 17:21:57','615','2021-05-30 17:22:37',10,0),('1','176',200692,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-31 07:45:58','615','2021-05-31 07:46:23',10,0),('1','176',200725,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-31 16:11:41','615','2021-05-31 16:12:19',10,0),('1','176',200864,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-05-31 16:16:01','615','2021-05-31 16:16:19',10,0),('1','176',200916,'DAILY SALES','2021-06-01','2021-06-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-01 17:24:44','615','2021-06-01 17:25:10',10,0),('1','176',201105,'DAILY SALES','2021-06-02','2021-06-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-02 08:37:33','615','2021-06-02 08:37:54',10,0),('1','176',201158,'DAILY SALES','2021-06-02','2021-06-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-02 17:53:51','615','2021-06-02 17:54:15',10,0),('1','176',201309,'DAILY SALES','2021-06-03','2021-06-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-03 07:34:32','615','2021-06-03 07:34:59',10,0),('1','176',201344,'DAILY  SALES ','2021-06-03','2021-06-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-03 17:23:54','615','2021-06-03 17:24:14',10,0),('1','176',201507,'DAILY SALES','2021-06-04','2021-06-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-04 09:01:04','615','2021-06-04 09:01:22',10,0),('1','176',201548,'DAILY  SALES ','2021-06-04','2021-06-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-04 17:28:08','615','2021-06-04 17:28:42',10,0),('1','176',201762,'DAILY  SALES ','2021-06-05','2021-06-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-05 09:06:05','615','2021-06-05 09:06:22',10,0),('1','176',201815,'DAILY SALES','2021-06-05','2021-06-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-05 17:43:48','615','2021-06-05 17:44:30',10,0),('1','176',202051,'DAILY  SALES ','2021-06-06','2021-06-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-06 10:57:07','615','2021-06-06 10:57:23',10,0),('1','176',202117,'DAILY SALES','2021-06-06','2021-06-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-06 12:47:49','615','2021-06-06 12:48:07',10,0),('1','176',202133,'DAILY SALES','2021-06-06','2021-06-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-06 17:19:23','615','2021-06-06 17:19:44',10,0),('1','176',202259,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-07 14:37:25','615','2021-06-07 14:37:52',10,0),('1','176',202361,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-07 14:44:36','615','2021-06-07 14:44:56',10,0),('1','176',202365,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-07 17:45:51','615','2021-06-07 17:46:22',10,0),('1','176',202442,'DAILY  SALES ','2021-06-08','2021-06-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-08 20:29:38','615','2021-06-08 20:30:03',10,0),('1','176',202652,'DAILY  SALES ','2021-06-08','2021-06-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-09 06:37:50','615','2021-06-09 06:38:23',10,0),('1','176',202657,'DAILY  SALES ','2021-06-09','2021-06-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-09 17:02:42','615','2021-06-09 17:03:05',10,0),('1','176',202854,'DAILY SALES','2021-06-10','2021-06-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-10 17:35:22','615','2021-06-10 17:38:31',10,0),('1','176',203107,'DAILY SALES','2021-06-11','2021-06-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-11 17:48:48','615','2021-06-11 17:49:25',10,0),('1','176',203313,'DAILY SALES','2021-06-12','2021-06-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-12 17:22:41','615','2021-06-12 17:23:06',10,0),('1','176',203521,'DAILY SALES','2021-06-13','2021-06-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-13 17:24:39','615','2021-06-13 17:24:57',10,0),('1','176',203724,'DAILY SALES','2021-06-14','2021-06-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-14 12:04:08','615','2021-06-14 12:04:54',10,0),('1','176',203834,'DAILY SALES','2021-06-14','2021-06-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-14 12:11:03','615','2021-06-14 12:11:21',10,0),('1','176',203836,'DAILY SALES','2021-06-14','2021-06-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-14 17:14:41','615','2021-06-14 17:14:59',10,0),('1','176',203961,'DAILY SALES','2021-06-15','2021-06-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-15 16:54:58','615','2021-06-15 16:56:40',10,0),('1','176',204199,'DAILY  SALES ','2021-06-16','2021-06-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-16 09:39:27','615','2021-06-16 09:39:50',10,0),('1','176',204257,'DAILY SALES','2021-06-16','2021-06-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-16 09:57:59','615','2021-06-16 09:59:07',10,0),('1','176',204267,'DAILY SALES','2021-06-16','2021-06-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-16 17:33:56','615','2021-06-16 17:34:16',10,0),('1','176',204405,'DAILY SALES','2021-06-17','2021-06-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-17 17:39:22','615','2021-06-17 17:39:52',10,0),('1','176',204613,'DAILY SALES','2021-06-18','2021-06-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-18 09:54:57','615','2021-06-18 09:55:26',10,0),('1','176',204689,'DAILY SALES','2021-06-18','2021-06-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-18 10:01:58','615','2021-06-18 10:02:21',10,0),('1','176',204701,'DAILY SALES','2021-06-18','2021-06-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-18 18:00:07','615','2021-06-18 18:00:28',10,0),('1','176',204837,'DAILY SALES','2021-06-19','2021-06-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-19 13:59:06','615','2021-06-19 13:59:28',10,0),('1','176',204978,'DAILY SALES','2021-06-19','2021-06-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-19 14:05:45','615','2021-06-19 14:06:06',10,0),('1','176',204984,'DAILY SALES','2021-06-19','2021-06-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-19 17:35:38','615','2021-06-19 17:36:26',10,0),('1','176',205037,'DAILY SALES','2021-06-20','2021-06-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-20 17:29:38','615','2021-06-20 17:30:00',10,0),('1','176',205247,'DAILY SALES','2021-06-21','2021-06-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-21 12:32:19','615','2021-06-21 12:33:59',10,0),('1','176',205341,'DAILY SALES','2021-06-21','2021-06-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-21 12:48:43','615','2021-06-21 12:49:22',10,0),('1','176',205344,'DAILY SALES','2021-06-21','2021-06-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-21 17:11:46','615','2021-06-21 17:12:41',10,0),('1','176',205470,'DAILY SALES','2021-06-22','2021-06-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-22 17:49:56','615','2021-06-22 17:50:58',10,0),('1','176',205726,'DAILY SALES','2021-06-23','2021-06-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-23 09:11:22','615','2021-06-23 09:11:55',10,0),('1','176',205785,'DAILY SALES','2021-06-23','2021-06-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-23 09:15:35','615','2021-06-23 09:15:56',10,0),('1','176',205788,'DAILY SALES','2021-06-23','2021-06-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-23 17:39:11','615','2021-06-23 17:39:51',10,0),('1','176',205939,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-24 14:54:34','615','2021-06-24 14:54:56',10,0),('1','176',206081,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-24 15:26:31','615','2021-06-24 15:26:57',10,0),('1','176',206087,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-24 18:12:07','615','2021-06-24 18:12:32',10,0),('1','176',206150,'DAILY SALES','2021-06-25','2021-06-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-25 17:19:21','615','2021-06-25 17:20:51',10,0),('1','176',206360,'DAILY SALES','2021-06-26','2021-06-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-26 08:45:53','615','2021-06-26 08:46:20',10,0),('1','176',206406,'DAILY SALES','2021-06-26','2021-06-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-26 18:04:44','615','2021-06-26 18:05:17',10,0),('1','176',206569,'DAILY SALES','2021-06-27','2021-06-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-27 08:26:51','615','2021-06-27 08:27:13',10,0),('1','176',206606,'DAILY SALES','2021-06-27','2021-06-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-27 17:30:08','615','2021-06-27 17:30:45',10,0),('1','176',206797,'DAILY SALES','2021-06-28','2021-06-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-28 08:19:53','615','2021-06-28 08:20:35',10,0),('1','176',206860,'DAILY SALES','2021-06-28','2021-06-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-28 17:33:44','615','2021-06-28 17:34:07',10,0),('1','176',207020,'DAILY SALES','2021-06-29','2021-06-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-29 10:36:17','615','2021-06-29 10:36:45',10,0),('1','176',207115,'DAILY SALES','2021-06-29','2021-06-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-29 17:46:09','615','2021-06-29 17:46:33',10,0),('1','176',207246,'DAILY SALES','2021-06-30','2021-06-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-30 10:26:53','615','2021-06-30 10:27:20',10,0),('1','176',207354,'DAILY SALES','2021-06-30','2021-06-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-30 13:04:03','615','2021-06-30 13:05:11',10,0),('1','176',207387,'DAILY SALES','2021-06-30','2021-06-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-06-30 18:07:15','615','2021-06-30 18:07:45',10,0),('1','176',207476,'DAILY SALES','2021-07-01','2021-07-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-01 17:48:36','615','2021-07-01 17:49:18',10,0),('1','176',207657,'DAILY SALES','2021-07-01','2021-07-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-01 18:05:36','615','2021-07-01 18:05:57',10,0),('1','176',207719,'DAILY SALES','2021-07-02','2021-07-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-02 17:47:37','615','2021-07-02 17:48:36',10,0),('1','176',207901,'DAILY SALES','2021-07-03','2021-07-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-03 15:41:22','615','2021-07-03 15:42:13',10,0),('1','176',208060,'DAILY SALES','2021-07-03','2021-07-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-03 15:47:19','615','2021-07-03 15:47:43',10,0),('1','176',208110,'DAILY SALES','2021-07-04','2021-07-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-04 16:39:59','615','2021-07-04 16:40:41',10,0),('1','176',208281,'DAILY SALES','2021-07-04','2021-07-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-04 16:54:47','615','2021-07-04 16:55:13',10,0),('1','176',208318,'DAILY SALES','2021-07-05','2021-07-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-05 15:39:22','615','2021-07-05 15:40:09',10,0),('1','176',208554,'DAILY SALES','2021-07-06','2021-07-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-06 17:40:01','615','2021-07-06 17:44:13',10,0),('1','176',208756,'DAILY SALES','2021-07-07','2021-07-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-07 07:42:41','615','2021-07-07 07:43:01',10,0),('1','176',208797,'DAILY SALES','2021-07-05','2021-07-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-07 07:46:52','615','2021-07-07 07:47:20',10,0),('1','176',208800,'DAILY SALES','2021-07-07','2021-07-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-07 07:50:53','615','2021-07-07 07:51:18',10,0),('1','176',208805,'DAILY SALES','2021-07-07','2021-07-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-07 18:19:30','615','2021-07-07 18:20:07',10,0),('1','176',208990,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-08 06:07:23','615','2021-07-08 06:07:58',10,0),('1','176',208993,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-08 13:00:46','615','2021-07-08 13:01:12',10,0),('1','176',209126,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-08 13:59:12','615','2021-07-08 14:00:21',10,0),('1','176',209127,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-08 17:40:54','615','2021-07-08 17:42:41',10,0),('1','176',209207,'DAILY SALES','2021-07-09','2021-07-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-09 17:36:15','615','2021-07-09 17:36:55',10,0),('1','176',209429,'DAILY SALES','2021-07-10','2021-07-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-10 12:27:03','615','2021-07-10 12:27:39',10,0),('1','176',209540,'DAILY SALES','2021-07-10','2021-07-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-10 12:30:37','615','2021-07-10 12:30:55',10,0),('1','176',209547,'DAILY SALES','2021-07-10','2021-07-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-10 17:40:35','615','2021-07-10 17:41:35',10,0),('1','176',209647,'DAILY SALES','2021-07-11','2021-07-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-11 16:02:41','615','2021-07-11 16:03:01',10,0),('1','176',209799,'DAILY SALES','2021-07-11','2021-07-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-11 16:10:34','615','2021-07-11 16:10:51',10,0),('1','176',209804,'DAILY SALES','2021-07-11','2021-07-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-11 17:50:26','615','2021-07-11 17:50:59',10,0),('1','176',209857,'DAILY SALES','2021-07-12','2021-07-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-12 17:49:57','615','2021-07-12 17:50:32',10,0),('1','176',210101,'DAILY SALES','2021-07-13','2021-07-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-13 17:34:25','615','2021-07-13 17:35:12',10,0),('1','176',210311,'DAILY SALES','2021-07-14','2021-07-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-14 18:16:21','615','2021-07-14 18:18:35',10,0),('1','176',210516,'DAILY SALES','2021-07-15','2021-07-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-15 17:33:16','615','2021-07-15 17:34:19',10,0),('1','176',210725,'DAILY SALES','2021-07-16','2021-07-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-16 16:35:57','615','2021-07-16 16:36:17',10,0),('1','176',210968,'DAILY SALES','2021-07-17','2021-07-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-17 07:12:21','615','2021-07-17 07:12:44',10,0),('1','176',210971,'DAILY SALES','2021-07-17','2021-07-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-17 07:15:51','615','2021-07-17 07:16:26',10,0),('1','176',211019,'DAILY SALES','2021-07-17','2021-07-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-17 17:35:26','615','2021-07-17 17:35:46',10,0),('1','176',211186,'DAILY SALES','2021-07-18','2021-07-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-18 17:55:11','615','2021-07-18 17:55:36',10,0),('1','176',211371,'DAILY SALES','2021-07-19','2021-07-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-19 10:01:26','615','2021-07-19 10:02:01',10,0),('1','176',211456,'DAILY SALES','2021-07-19','2021-07-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-19 10:05:57','615','2021-07-19 10:06:18',10,0),('1','176',211562,'DAILY SALES','2021-07-19','2021-07-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-19 18:07:04','615','2021-07-19 18:07:31',10,0),('1','176',211636,'DAILY SALES','2021-07-20','2021-07-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-20 16:53:54','615','2021-07-20 16:54:32',10,0),('1','176',211775,'DAILY SALES','2021-07-21','2021-07-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-21 17:25:06','615','2021-07-21 17:25:30',10,0),('1','176',211986,'DAILY SALES','2021-07-22','2021-07-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-22 17:04:03','615','2021-07-22 17:04:25',10,0),('1','176',212223,'DAILY SALES','2021-07-23','2021-07-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-23 17:24:36','615','2021-07-23 17:25:16',10,0),('1','176',212454,'DAILY SALES','2021-07-24','2021-07-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-24 18:15:58','615','2021-07-24 18:16:38',10,0),('1','176',212664,'DAILY SALES','2021-07-25','2021-07-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-25 17:10:04','615','2021-07-25 17:10:28',10,0),('1','176',212863,'DAILY SALES','2021-07-26','2021-07-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-26 17:07:33','615','2021-07-26 17:08:38',10,0),('1','176',213130,'DAILY SALES','2021-07-27','2021-07-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-27 11:55:05','615','2021-07-27 11:55:27',10,0),('1','176',213271,'DAILY SALES','2021-07-27','2021-07-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-27 12:01:42','615','2021-07-27 12:02:14',10,0),('1','176',213319,'DAILY SALES','2021-07-27','2021-07-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-27 17:57:45','615','2021-07-27 17:58:08',10,0),('1','176',213386,'DAILY SALES','2021-07-28','2021-07-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-28 17:43:17','615','2021-07-28 17:43:42',10,0),('1','176',213628,'DAILY SALES','2021-07-29','2021-07-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-29 18:19:53','615','2021-07-29 18:21:46',10,0),('1','176',213877,'DAILY SALES','2021-07-30','2021-07-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-30 07:25:05','615','2021-07-30 07:26:44',10,0),('1','176',213909,'DAILY SALES','2021-07-30','2021-07-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-30 07:34:27','615','2021-07-30 07:34:55',10,0),('1','176',213917,'DAILY SALES','2021-07-30','2021-07-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-30 17:37:23','615','2021-07-30 17:39:47',10,0),('1','176',214091,'DAILY SALES','2021-07-31','2021-07-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-31 11:09:42','615','2021-07-31 11:10:59',10,0),('1','176',214175,'DAILY SALES','2021-07-31','2021-07-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-31 11:19:00','615','2021-07-31 11:19:26',10,0),('1','176',214267,'DAILY SALES','2021-07-31','2021-07-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-07-31 17:57:16','615','2021-07-31 17:59:46',10,0),('1','176',214328,'DAILY SALES','2021-08-01','2021-08-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-01 17:49:51','615','2021-08-01 17:51:02',10,0),('1','176',214522,'DAILY SALES','2021-08-02','2021-08-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-02 11:03:01','615','2021-08-02 11:04:33',10,0),('1','176',214634,'DAILY SALES','2021-08-02','2021-08-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-02 11:08:06','615','2021-08-02 11:08:39',10,0),('1','176',214645,'DAILY SALES','2021-08-02','2021-08-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-02 17:28:19','615','2021-08-02 17:29:10',10,0),('1','176',214770,'DAILY SALES','2021-08-03','2021-08-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-03 11:12:44','615','2021-08-03 11:13:06',10,0),('1','176',214875,'DAILY SALES','2021-08-03','2021-08-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-03 11:22:10','615','2021-08-03 11:22:53',10,0),('1','176',214929,'DAILY SALES','2021-08-03','2021-08-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-03 17:56:58','615','2021-08-03 17:59:01',10,0),('1','176',215022,'DAILY SALES','2021-08-04','2021-08-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-04 18:20:16','615','2021-08-04 18:20:53',10,0),('1','176',215191,'DAILY SALES','2021-08-04','2021-08-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-04 18:24:45','615','2021-08-04 18:25:14',10,0),('1','176',215223,'DAILY SALES','2021-08-05','2021-08-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-05 17:44:06','615','2021-08-05 17:45:08',10,0),('1','176',215436,'DAILY SALES','2021-08-06','2021-08-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-06 18:02:14','615','2021-08-06 18:02:36',10,0),('1','176',215670,'DAILY SALES','2021-08-07','2021-08-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-07 17:33:35','615','2021-08-07 17:38:07',10,0),('1','176',215900,'DAILY SALES','2021-08-08','2021-08-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-08 17:39:00','615','2021-08-08 17:39:42',10,0),('1','176',216175,'DAILY SALES','2021-08-09','2021-08-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-09 16:56:17','615','2021-08-09 16:56:59',10,0),('1','176',216286,'DAILY SALES','2021-08-09','2021-08-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-09 17:21:27','615','2021-08-09 17:21:56',10,0),('1','176',216418,'DAILY SALES','2021-08-10','2021-08-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-10 18:22:43','615','2021-08-10 18:24:33',10,0),('1','176',216548,'DAILY SALES','2021-08-11','2021-08-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-11 18:00:55','615','2021-08-11 18:02:36',10,0),('1','176',216781,'DAILY SALES','2021-08-12','2021-08-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-12 10:54:38','615','2021-08-12 10:56:29',10,0),('1','176',216879,'DAILY SALES','2021-08-12','2021-08-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-12 10:59:16','615','2021-08-12 11:00:10',10,0),('1','176',217018,'DAILY SALES','2021-08-13','2021-08-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-13 18:09:40','615','2021-08-13 18:11:07',10,0),('1','176',217271,'DAILY SALES','2021-08-14','2021-08-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-14 18:07:03','615','2021-08-14 18:07:51',10,0),('1','176',217506,'DAILY SALES','2021-08-15','2021-08-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-15 08:10:34','615','2021-08-15 08:11:11',10,0),('1','176',217530,'DAILY SALES','2021-08-15','2021-08-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-15 08:16:37','615','2021-08-15 08:17:14',10,0),('1','176',217608,'DAILY SALES','2021-08-15','2021-08-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-15 17:30:32','615','2021-08-15 17:30:59',10,0),('1','176',217705,'DAILY SALES','2021-08-16','2021-08-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-16 18:25:21','615','2021-08-16 18:26:34',10,0),('1','176',217979,'DAILY SALES','2021-08-17','2021-08-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-17 11:33:55','615','2021-08-17 11:37:03',10,0),('1','176',218091,'DAILY SALES','2021-08-17','2021-08-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-17 11:40:39','615','2021-08-17 11:52:05',10,0),('1','176',218096,'DAILY SALES','2021-08-17','2021-08-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-17 17:59:09','615','2021-08-17 17:59:57',10,0),('1','176',218214,'DAILY SALES','2021-08-18','2021-08-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-18 17:55:32','615','2021-08-18 17:56:14',10,0),('1','176',218453,'DAILY SALES','2021-08-19','2021-08-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-19 10:32:23','615','2021-08-19 10:32:53',10,0),('1','176',218543,'DAILY SALES','2021-08-19','2021-08-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-19 10:38:47','615','2021-08-19 10:39:12',10,0),('1','176',218544,'DAILY SALES','2021-08-19','2021-08-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-19 17:41:30','615','2021-08-19 17:42:37',10,0),('1','176',218672,'DAILY SALES','2021-08-20','2021-08-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-20 13:46:18','615','2021-08-20 13:47:12',10,0),('1','176',218821,'DAILY SALES','2021-08-20','2021-08-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-20 13:52:57','615','2021-08-20 13:54:05',10,0),('1','176',219030,'DAILY SALES','2021-08-21','2021-08-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-21 18:34:33','615','2021-08-21 18:35:31',10,0),('1','176',219112,'DAILY SALES','2021-08-22','2021-08-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-22 17:46:16','615','2021-08-22 17:47:52',10,0),('1','176',219295,'DAILY SALES','2021-08-22','2021-08-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-22 17:50:57','615','2021-08-22 17:51:19',10,0),('1','176',219326,'DAILY SALES','2021-08-23','2021-08-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-23 17:41:53','615','2021-08-23 17:47:29',10,0),('1','176',219591,'DAILY SALES','2021-08-24','2021-08-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-24 09:39:23','615','2021-08-24 09:40:12',10,0),('1','176',219673,'DAILY SALES','2021-08-24','2021-08-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-24 18:01:17','615','2021-08-24 18:01:37',10,0),('1','176',219806,'DAILY SALES','2021-08-25','2021-08-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-25 15:05:12','615','2021-08-25 15:05:48',10,0),('1','176',219969,'DAILY SALES','2021-08-25','2021-08-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-25 17:38:21','615','2021-08-25 17:44:55',10,0),('1','176',220035,'DAILY SALES','2021-08-26','2021-08-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-26 09:19:30','615','2021-08-26 09:20:10',10,0),('1','176',220107,'DAILY SALES','2021-08-26','2021-08-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-26 18:10:26','615','2021-08-26 18:21:15',10,0),('1','176',220241,'DAILY SALES','2021-08-27','2021-08-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-27 07:22:40','615','2021-08-27 07:23:03',10,0),('1','176',220271,'DAILY SALES','2021-08-27','2021-08-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-27 17:53:30','615','2021-08-27 17:56:15',10,0),('1','176',220458,'DAILY SALES','2021-08-28','2021-08-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-28 16:10:14','615','2021-08-28 16:12:41',10,0),('1','176',220635,'DAILY SALES','2021-08-28','2021-08-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-28 17:47:22','615','2021-08-28 17:48:38',10,0),('1','176',220678,'DAILY SALES','2021-08-29','2021-08-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-29 16:14:23','615','2021-08-29 16:15:50',10,0),('1','176',220843,'DAILY SALES','2021-08-29','2021-08-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-29 16:19:47','615','2021-08-29 16:20:13',10,0),('1','176',220847,'DAILY SALES','2021-08-29','2021-08-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-29 18:37:28','615','2021-08-29 18:38:07',10,0),('1','176',220906,'DAILY SALES','2021-08-30','2021-08-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-30 16:41:24','615','2021-08-30 16:44:30',10,0),('1','176',221096,'DAILY SALES','2021-08-30','2021-08-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-30 17:46:21','615','2021-08-30 17:46:42',10,0),('1','176',221150,'DAILY SALES','2021-08-31','2021-08-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-31 16:12:35','615','2021-08-31 16:12:58',10,0),('1','176',221330,'DAILY SALES','2021-08-31','2021-08-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-08-31 17:30:27','615','2021-08-31 17:36:21',10,0),('1','176',221397,'DAILY SALES','2021-09-01','2021-09-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-01 17:34:25','615','2021-09-01 17:34:52',10,0),('1','176',221623,'DAILY SALES','2021-09-02','2021-09-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-02 07:18:46','615','2021-09-02 07:19:19',10,0),('1','176',221640,'DAILY SALES','2021-09-02','2021-09-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-02 14:00:03','615','2021-09-02 14:00:41',10,0),('1','176',221750,'DAILY SALES','2021-09-02','2021-09-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-02 17:50:29','615','2021-09-02 17:51:05',10,0),('1','176',221834,'DAILY  SALES ','2021-09-03','2021-09-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-03 14:29:04','615','2021-09-03 14:29:38',10,0),('1','176',221974,'DAILY SALES','2021-09-03','2021-09-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-03 14:37:03','615','2021-09-03 14:37:22',10,0),('1','176',221978,'DAILY SALES','2021-09-03','2021-09-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-03 17:53:12','615','2021-09-03 17:53:31',10,0),('1','176',222057,'DAILY  SALES ','2021-09-04','2021-09-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-04 10:37:16','615','2021-09-04 10:37:38',10,0),('1','176',222133,'DAILY SALES','2021-09-04','2021-09-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-04 10:43:23','615','2021-09-04 10:43:43',10,0),('1','176',222156,'DAILY SALES','2021-09-04','2021-09-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-04 17:15:06','615','2021-09-04 17:16:34',10,0),('1','176',222323,'DAILY  SALES ','2021-09-05','2021-09-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-05 17:56:09','615','2021-09-05 17:56:32',10,0),('1','176',222492,'DAILY SALES','2021-09-06','2021-09-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-07 06:43:19','615','2021-09-07 06:44:28',10,0),('1','176',222728,'DAILY SALES','2021-09-07','2021-09-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-09 06:11:22','615','2021-09-09 06:11:40',10,0),('1','176',223175,'DAILY SALES','2021-09-08','2021-09-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-09 06:13:55','615','2021-09-09 06:14:15',10,0),('1','176',223177,'DAILY SALES','2021-09-08','2021-09-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-09 06:17:37','615','2021-09-09 06:18:04',10,0),('1','176',223178,'DAILY SALES','2021-09-09','2021-09-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-09 17:31:58','615','2021-09-09 17:32:23',10,0),('1','176',223421,'DAILY SALES','2021-09-10','2021-09-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-10 12:11:47','615','2021-09-10 12:12:21',10,0),('1','176',223520,'DAILY SALES','2021-09-10','2021-09-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-10 17:24:39','615','2021-09-10 17:25:14',10,0),('1','176',223638,'DAILY SALES','2021-09-11','2021-09-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-11 15:55:33','615','2021-09-11 15:56:57',10,0),('1','176',223818,'DAILY SALES','2021-09-11','2021-09-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-11 16:07:01','615','2021-09-11 16:07:24',10,0),('1','176',223829,'DAILY SALES','2021-09-11','2021-09-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-11 17:27:52','615','2021-09-11 17:28:12',10,0),('1','176',223864,'DAILY SALES','2021-09-12','2021-09-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-12 17:50:52','615','2021-09-12 17:52:00',10,0),('1','176',224075,'DAILY SALES','2021-09-13','2021-09-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-13 10:40:45','615','2021-09-13 10:41:45',10,0),('1','176',224170,'DAILY SALES','2021-09-13','2021-09-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-13 10:47:55','615','2021-09-13 10:49:30',10,0),('1','176',224190,'DAILY SALES','2021-09-13','2021-09-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-13 18:06:13','615','2021-09-13 18:06:36',10,0),('1','176',224302,'DAILY SALES','2021-09-14','2021-09-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-14 17:39:00','615','2021-09-14 17:39:46',10,0),('1','176',224521,'DAILY SALES','2021-09-15','2021-09-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-15 11:44:44','615','2021-09-15 11:47:19',10,0),('1','176',224668,'DAILY SALES','2021-09-15','2021-09-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-15 13:05:53','615','2021-09-15 13:06:17',10,0),('1','176',224702,'DAILY SALES','2021-09-15','2021-09-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-15 17:36:11','615','2021-09-15 17:37:15',10,0),('1','176',224781,'DAILY SALES','2021-09-16','2021-09-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-16 12:19:57','615','2021-09-16 12:20:50',10,0),('1','176',224891,'DAILY SALES','2021-09-16','2021-09-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-16 17:34:58','615','2021-09-16 17:35:39',10,0),('1','176',225014,'DAILY SALES','2021-09-17','2021-09-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-17 11:16:43','615','2021-09-17 11:19:01',10,0),('1','176',225121,'DAILY SALES','2021-09-17','2021-09-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-17 11:29:48','615','2021-09-17 11:31:32',10,0),('1','176',225138,'DAILY SALES','2021-09-17','2021-09-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-17 18:10:40','615','2021-09-17 18:13:39',10,0),('1','176',225270,'DAILY SALES','2021-09-18','2021-09-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-18 16:11:37','615','2021-09-18 16:12:02',10,0),('1','176',225427,'DAILY SALES','2021-09-18','2021-09-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-18 16:37:18','615','2021-09-18 16:38:48',10,0),('1','176',225475,'DAILY SALES','2021-09-19','2021-09-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-19 17:43:09','615','2021-09-19 17:48:50',10,0),('1','176',225689,'DAILY SALES','2021-09-20','2021-09-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-20 10:12:27','615','2021-09-20 10:13:00',10,0),('1','176',225803,'DAILY SALES','2021-09-20','2021-09-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-20 10:30:06','615','2021-09-20 10:30:55',10,0),('1','176',225809,'DAILY SALES','2021-09-20','2021-09-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-20 18:15:10','615','2021-09-20 18:18:40',10,0),('1','176',225965,'DAILY SALES','2021-09-21','2021-09-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-21 17:13:01','615','2021-09-21 17:13:51',10,0),('1','176',226186,'DAILY SALES','2021-09-21','2021-09-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-21 17:16:40','615','2021-09-21 17:17:09',10,0),('1','176',226234,'DAILY SALES','2021-09-22','2021-09-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-22 17:45:16','615','2021-09-22 17:45:45',10,0),('1','176',226468,'DAILY SALES','2021-09-23','2021-09-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-23 09:52:09','615','2021-09-23 09:52:36',10,0),('1','176',226557,'DAILY SALES','2021-09-23','2021-09-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-23 09:57:27','615','2021-09-23 09:59:35',10,0),('1','176',226736,'DAILY SALES','2021-09-24','2021-09-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-24 17:58:16','615','2021-09-24 17:59:02',10,0),('1','176',226948,'DAILY SALES','2021-09-25','2021-09-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-25 09:22:51','615','2021-09-25 09:23:15',10,0),('1','176',227016,'DAILY SALES','2021-09-25','2021-09-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-25 09:26:54','615','2021-09-25 09:27:17',10,0),('1','176',227021,'DAILY SALES','2021-09-25','2021-09-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-25 18:40:55','615','2021-09-25 18:44:44',10,0),('1','176',227182,'DAILY SALES','2021-09-26','2021-09-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-26 08:57:33','615','2021-09-26 08:57:56',10,0),('1','176',227223,'DAILY SALES','2021-09-26','2021-09-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-26 09:00:54','615','2021-09-26 09:01:16',10,0),('1','176',227271,'DAILY SALES','2021-09-26','2021-09-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-26 18:03:02','615','2021-09-26 18:06:46',10,0),('1','176',227360,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-27 10:58:53','615','2021-09-27 11:00:05',10,0),('1','176',227532,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-27 13:45:54','615','2021-09-27 13:47:00',10,0),('1','176',227538,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-27 19:56:48','615','2021-09-27 20:09:09',10,0),('1','176',227598,'DAILY  SALES ','2021-09-28','2021-09-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-28 16:36:31','615','2021-09-28 16:50:50',10,0),('1','176',227835,'DAILY  SALES ','2021-09-29','2021-09-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-29 15:28:55','615','2021-09-29 15:29:47',10,0),('1','176',228037,'DAILY  SALES ','2021-09-29','2021-09-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-09-29 15:38:36','615','2021-09-29 15:39:28',10,0),('1','176',228349,'DAILY  SALES ','2021-10-01','2021-10-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-01 17:33:37','615','2021-10-01 17:36:06',10,0),('1','176',228533,'DAILY  SALES ','2021-10-02','2021-10-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-02 17:37:22','615','2021-10-02 17:38:09',10,0),('1','176',228751,'DAILY SALES','2021-10-03','2021-10-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-03 07:47:21','615','2021-10-03 07:47:55',10,0),('1','176',228768,'DAILY SALES','2021-10-03','2021-10-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-03 07:50:47','615','2021-10-03 07:51:11',10,0),('1','176',228862,'DAILY SALES','2021-10-03','2021-10-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-03 17:40:10','615','2021-10-03 17:40:31',10,0),('1','176',228944,'DAILY SALES','2021-10-04','2021-10-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-04 14:58:02','615','2021-10-04 14:58:37',10,0),('1','176',229086,'DAILY SALES','2021-10-04','2021-10-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-04 15:01:14','615','2021-10-04 15:01:38',10,0),('1','176',229098,'DAILY SALES','2021-10-04','2021-10-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-04 17:40:14','615','2021-10-04 17:40:38',10,0),('1','176',229162,'DAILY SALES','2021-10-05','2021-10-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-05 13:08:26','615','2021-10-05 13:09:17',10,0),('1','176',229289,'DAILY SALES','2021-10-05','2021-10-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-05 13:11:46','615','2021-10-05 13:12:06',10,0),('1','176',229409,'DAILY SALES','2021-10-06','2021-10-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-06 18:33:07','615','2021-10-06 18:33:51',10,0),('1','176',229659,'DAILY SALES','2021-10-07','2021-10-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-07 12:32:55','615','2021-10-07 12:33:29',10,0),('1','176',229765,'DAILY SALES','2021-10-07','2021-10-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-07 12:37:24','615','2021-10-07 12:38:31',10,0),('1','176',229890,'DAILY SALES','2021-10-08','2021-10-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-08 17:37:00','615','2021-10-08 17:38:37',10,0),('1','176',230091,'DAILY SALES','2021-10-09','2021-10-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-09 17:56:16','615','2021-10-09 17:56:57',10,0),('1','176',230285,'DAILY SALES','2021-10-10','2021-10-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-10 17:23:40','615','2021-10-10 17:25:56',10,0),('1','176',230529,'DAILY SALES','2021-10-11','2021-10-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-11 17:56:10','615','2021-10-11 17:57:33',10,0),('1','176',230773,'DAILY SALES','2021-10-12','2021-10-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-12 18:02:37','615','2021-10-12 18:04:33',10,0),('1','176',231054,'DAILY SALES','2021-10-13','2021-10-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-13 17:49:56','615','2021-10-13 17:50:41',10,0),('1','176',231329,'DAILY SALES','2021-10-13','2021-10-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-13 17:59:26','615','2021-10-13 17:59:45',10,0),('1','176',231388,'DAILY SALES','2021-10-14','2021-10-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-14 17:31:45','615','2021-10-14 17:32:25',10,0),('1','176',231630,'DAILY SALES','2021-10-15','2021-10-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-15 17:47:07','615','2021-10-15 17:48:09',10,0),('1','176',231879,'DAILY SALES','2021-10-16','2021-10-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-16 17:49:06','615','2021-10-16 17:49:59',10,0),('1','176',232101,'DAILY SALES','2021-10-17','2021-10-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-17 17:42:17','615','2021-10-17 17:43:01',10,0),('1','176',232328,'DAILY SALES','2021-10-18','2021-10-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-18 12:29:29','615','2021-10-18 12:30:56',10,0),('1','176',232458,'DAILY SALES','2021-10-18','2021-10-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-18 17:50:45','615','2021-10-18 17:54:22',10,0),('1','176',232580,'DAILY SALES','2021-10-19','2021-10-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-19 11:40:15','615','2021-10-19 11:45:25',10,0),('1','176',232695,'DAILY SALES','2021-10-19','2021-10-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-19 11:50:14','615','2021-10-19 11:51:59',10,0),('1','176',232696,'DAILY SALES','2021-10-19','2021-10-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-19 17:21:21','615','2021-10-19 17:22:12',10,0),('1','176',232833,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-20 14:45:18','615','2021-10-20 14:46:14',10,0),('1','176',233029,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-20 14:48:50','615','2021-10-20 14:49:11',10,0),('1','176',233041,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-20 17:43:34','615','2021-10-20 17:45:01',10,0),('1','176',233097,'DAILY SALES','2021-10-21','2021-10-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-21 16:34:41','615','2021-10-21 16:35:15',10,0),('1','176',233317,'DAILY.......SALES','2021-10-21','2021-10-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-21 18:00:27','615','2021-10-21 18:01:21',10,0),('1','176',233397,'DAILY SALES','2021-10-22','2021-10-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-22 17:30:12','615','2021-10-22 17:31:54',10,0),('1','176',233614,'DAILY SALES','2021-10-23','2021-10-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-23 17:53:03','615','2021-10-23 17:55:09',10,0),('1','176',233841,'DAILY SALES','2021-10-24','2021-10-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-24 18:04:08','615','2021-10-24 18:05:21',10,0),('1','176',234034,'DAILY SALES','2021-10-25','2021-10-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-25 10:57:55','615','2021-10-25 10:59:35',10,0),('1','176',234171,'DAILY SALES','2021-10-25','2021-10-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-25 11:11:01','615','2021-10-25 11:11:27',10,0),('1','176',234240,'DAILY SALES','2021-10-25','2021-10-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-25 17:42:30','615','2021-10-25 17:43:25',10,0),('1','176',234302,'DAILY SALES','2021-10-26','2021-10-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-26 17:53:38','615','2021-10-26 17:54:12',10,0),('1','176',234573,'DAILY SALES','2021-10-27','2021-10-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-27 10:48:49','615','2021-10-27 10:49:13',10,0),('1','176',234687,'DAILY SALES','2021-10-27','2021-10-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-27 10:51:44','615','2021-10-27 10:52:07',10,0),('1','176',234698,'DAILY SALES','2021-10-27','2021-10-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-27 17:48:57','615','2021-10-27 17:50:57',10,0),('1','176',234807,'DAILY SALES','2021-10-28','2021-10-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-28 18:30:23','615','2021-10-28 18:48:24',10,0),('1','176',235060,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-29 06:10:10','615','2021-10-29 06:10:32',10,0),('1','176',235077,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-29 06:13:27','615','2021-10-29 06:13:48',10,0),('1','176',235136,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-29 18:17:23','615','2021-10-29 18:24:14',10,0),('1','176',235288,'DAILY SALES','2021-10-30','2021-10-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-30 13:50:50','615','2021-10-30 13:57:42',10,0),('1','176',235448,'DAILY SALES','2021-10-30','2021-10-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-30 14:01:54','615','2021-10-30 14:02:30',10,0),('1','176',235456,'DAILY SALES','2021-10-30','2021-10-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-30 18:31:38','615','2021-10-30 18:35:34',10,0),('1','176',235512,'DAILY SALES','2021-10-31','2021-10-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-10-31 18:08:24','615','2021-10-31 18:14:34',10,0),('1','176',235743,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-01 08:31:29','615','2021-11-01 08:33:03',10,0),('1','176',235831,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-01 08:36:23','615','2021-11-01 08:36:52',10,0),('1','176',235861,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-01 18:56:08','615','2021-11-01 19:08:14',10,0),('1','176',236001,'DAILY SALES','2021-11-02','2021-11-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-02 11:50:55','615','2021-11-02 11:51:25',10,0),('1','176',236128,'DAILY SALES','2021-11-02','2021-11-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-02 11:56:09','615','2021-11-02 11:57:59',10,0),('1','176',236130,'DAILY SALES','2021-11-02','2021-11-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-02 17:40:44','615','2021-11-02 17:46:15',10,0),('1','176',236228,'DAILY SALES','2021-11-03','2021-11-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-03 13:34:14','615','2021-11-03 13:41:41',10,0),('1','176',236404,'DAILY SALES','2021-11-03','2021-11-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-03 13:46:59','615','2021-11-03 13:47:26',10,0),('1','176',236511,'DAILY SALES','2021-11-04','2021-11-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-04 17:49:06','615','2021-11-04 17:53:07',10,0),('1','176',236724,'DAILY SALES','2021-11-05','2021-11-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-05 08:43:42','615','2021-11-05 08:49:28',10,0),('1','176',236803,'DAILY SALES','2021-11-05','2021-11-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-05 08:53:39','615','2021-11-05 08:54:08',10,0),('1','176',236857,'DAILY SALES','2021-11-05','2021-11-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-05 17:51:11','615','2021-11-05 17:51:35',10,0),('1','176',236950,'DAILY SALES','2021-11-06','2021-11-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-06 15:40:57','615','2021-11-06 15:44:50',10,0),('1','176',237108,'DAILY SALES','2021-11-06','2021-11-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-06 15:49:30','615','2021-11-06 15:49:53',10,0),('1','176',237110,'DAILY SALES','2021-11-06','2021-11-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-06 17:30:06','615','2021-11-06 17:30:37',10,0),('1','176',237170,'DAILY SALES','2021-11-07','2021-11-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-07 18:05:57','615','2021-11-07 18:11:01',10,0),('1','176',237378,'DAILY SALES','2021-11-08','2021-11-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-08 09:58:03','615','2021-11-08 10:01:20',10,0),('1','176',237477,'DAILY SALES','2021-11-08','2021-11-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-08 10:05:21','615','2021-11-08 10:05:39',10,0),('1','176',237486,'DAILY SALES','2021-11-08','2021-11-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-08 17:49:06','615','2021-11-08 17:57:08',10,0),('1','176',237606,'DAILY SALES','2021-11-09','2021-11-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-09 18:06:45','615','2021-11-09 18:07:10',10,0),('1','176',237871,'DAILY SALES','2021-11-10','2021-11-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-10 09:24:19','615','2021-11-10 09:24:42',10,0),('1','176',237952,'DAILY SALES','2021-11-10','2021-11-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-10 09:27:06','615','2021-11-10 09:27:25',10,0),('1','176',237967,'DAILY SALES','2021-11-10','2021-11-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-10 18:15:07','615','2021-11-10 18:15:56',10,0),('1','176',238109,'DAILY SALES','2021-11-11','2021-11-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-11 13:31:13','615','2021-11-11 13:31:34',10,0),('1','176',238267,'DAILY SALES','2021-11-11','2021-11-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-11 13:46:57','615','2021-11-11 13:47:13',10,0),('1','176',238269,'DAILY SALES','2021-11-11','2021-11-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-11 18:18:30','615','2021-11-11 18:18:58',10,0),('1','176',238346,'DAILY SALES','2021-11-12','2021-11-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-12 15:51:38','615','2021-11-12 15:52:29',10,0),('1','176',238535,'DAILY SALES','2021-11-12','2021-11-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-12 15:55:30','615','2021-11-12 15:55:48',10,0),('1','176',238538,'DAILY SALES','2021-11-12','2021-11-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-12 18:19:02','615','2021-11-12 18:19:24',10,0),('1','176',238598,'DAILY SALES','2021-11-13','2021-11-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-13 14:53:41','615','2021-11-13 15:06:49',10,0),('1','176',238761,'DAILY SALES','2021-11-13','2021-11-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-13 15:11:55','615','2021-11-13 15:12:16',10,0),('1','176',238763,'DAILY SALES','2021-11-13','2021-11-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-13 18:27:17','615','2021-11-13 18:28:19',10,0),('1','176',238831,'DAILY SALES','2021-11-14','2021-11-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-14 18:19:48','615','2021-11-14 18:26:27',10,0),('1','176',239062,'DAILY SALES','2021-11-15','2021-11-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-15 10:16:09','615','2021-11-15 10:16:25',10,0),('1','176',239160,'DAILY SALES','2021-11-15','2021-11-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-15 10:20:28','615','2021-11-15 10:20:49',10,0),('1','176',239165,'DAILY SALES','2021-11-15','2021-11-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-15 18:13:24','615','2021-11-15 18:17:56',10,0),('1','176',239287,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-16 13:13:58','615','2021-11-16 13:15:52',10,0),('1','176',239412,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-16 13:18:33','615','2021-11-16 13:18:48',10,0),('1','176',239417,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-16 17:39:47','615','2021-11-16 17:48:52',10,0),('1','176',239524,'DAILY SALES','2021-11-17','2021-11-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-17 14:43:08','615','2021-11-17 14:43:35',10,0),('1','176',239679,'DAILY SALES','2021-11-17','2021-11-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-17 14:49:16','615','2021-11-17 14:49:32',10,0),('1','176',239683,'DAILY SALES','2021-11-17','2021-11-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-17 16:57:03','615','2021-11-17 17:01:30',10,0),('1','176',239767,'DAILY SALES','2021-11-18','2021-11-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-18 09:16:54','615','2021-11-18 09:17:54',10,0),('1','176',239845,'DAILY SALES','2021-11-18','2021-11-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-18 17:32:39','615','2021-11-18 17:33:09',10,0),('1','176',239934,'DAILY SALES','2021-11-18','2021-11-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-18 17:35:28','615','2021-11-18 17:35:43',10,0),('1','176',240025,'DAILY SALES','2021-11-19','2021-11-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-19 17:34:10','615','2021-11-19 17:40:27',10,0),('1','176',240200,'DAILY SALES','2021-11-20','2021-11-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-20 17:42:27','615','2021-11-20 17:42:45',10,0),('1','176',240368,'DAILY SALES','2021-11-20','2021-11-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-20 17:50:21','615','2021-11-20 17:50:38',10,0),('1','176',240451,'DAILY SALES','2021-11-21','2021-11-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-21 18:21:39','615','2021-11-21 18:27:27',10,0),('1','176',240674,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-22 09:08:22','615','2021-11-22 09:10:58',10,0),('1','176',240768,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-22 09:14:11','615','2021-11-22 09:14:53',10,0),('1','176',240795,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-22 18:15:24','615','2021-11-22 18:21:00',10,0),('1','176',240959,'DAILY SALES','2021-11-23','2021-11-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-23 12:46:51','615','2021-11-23 12:47:12',10,0),('1','176',241102,'DAILY SALES','2021-11-23','2021-11-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-23 17:57:07','615','2021-11-23 18:04:54',10,0),('1','176',241221,'DAILY SALES','2021-11-24','2021-11-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-24 06:36:50','615','2021-11-24 06:37:07',10,0),('1','176',241234,'DAILY SALES','2021-11-24','2021-11-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-24 18:54:23','615','2021-11-24 18:55:45',10,0),('1','176',241493,'DAILY SALES','2021-11-25','2021-11-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-25 08:33:01','615','2021-11-25 08:35:52',10,0),('1','176',241562,'DAILY SALES','2021-11-25','2021-11-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-25 08:42:14','615','2021-11-25 08:42:34',10,0),('1','176',241563,'DAILY SALES','2021-11-25','2021-11-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-25 18:17:56','615','2021-11-25 18:22:08',10,0),('1','176',241733,'DAILY SALES','2021-11-26','2021-11-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-26 11:01:56','615','2021-11-26 11:04:42',10,0),('1','176',241841,'DAILY SALES','2021-11-26','2021-11-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-26 11:07:57','615','2021-11-26 11:08:15',10,0),('1','176',241978,'DAILY SALES','2021-11-27','2021-11-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-27 18:05:05','615','2021-11-27 18:10:11',10,0),('1','176',242209,'DAILY SALES','2021-11-28','2021-11-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-28 10:21:15','615','2021-11-28 10:24:10',10,0),('1','176',242282,'DAILY SALES','2021-11-28','2021-11-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-28 10:32:42','615','2021-11-28 10:35:05',10,0),('1','176',242299,'DAILY SALES','2021-11-28','2021-11-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-28 18:03:22','615','2021-11-28 18:09:14',10,0),('1','176',242422,'DAILY SALES','2021-11-29','2021-11-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-29 13:01:18','615','2021-11-29 13:01:48',10,0),('1','176',242565,'DAILY SALES','2021-11-29','2021-11-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-29 13:03:49','615','2021-11-29 13:04:05',10,0),('1','176',242568,'DAILY SALES','2021-11-29','2021-11-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-29 17:41:15','615','2021-11-29 17:42:39',10,0),('1','176',242662,'DAILY SALES','2021-11-30','2021-11-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-30 18:17:18','615','2021-11-30 18:21:46',10,0),('1','176',242857,'DAILY SALES','2021-11-30','2021-11-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-11-30 18:27:09','615','2021-11-30 18:29:52',10,0),('1','176',242919,'DAILY SALES','2021-12-01','2021-12-01 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-01 17:10:41','615','2021-12-01 17:16:21',10,0),('1','176',243133,'DAILY SALES','2021-12-02','2021-12-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-02 08:18:53','615','2021-12-02 08:19:21',10,0),('1','176',243203,'DAILY SALES','2021-12-02','2021-12-02 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-02 18:05:25','615','2021-12-02 18:09:14',10,0),('1','176',243356,'DAILY SALES','2021-12-03','2021-12-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-03 12:05:13','615','2021-12-03 12:06:48',10,0),('1','176',243476,'DAILY SALES','2021-12-03','2021-12-03 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-03 17:42:42','615','2021-12-03 17:44:14',10,0),('1','176',243582,'DAILY  SALES ','2021-12-04','2021-12-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-04 16:05:32','615','2021-12-04 16:09:24',10,0),('1','176',243751,'DAILY SALES','2021-12-04','2021-12-04 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-04 17:56:50','615','2021-12-04 18:00:05',10,0),('1','176',243832,'DAILY SALES','2021-12-05','2021-12-05 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-05 17:51:04','615','2021-12-05 17:55:59',10,0),('1','176',244044,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-06 07:49:06','615','2021-12-06 07:51:41',10,0),('1','176',244113,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-06 07:58:46','615','2021-12-06 07:59:08',10,0),('1','176',244124,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-06 17:39:20','615','2021-12-06 17:47:05',10,0),('1','176',244273,'DAILY SALES','2021-12-07','2021-12-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-07 08:56:28','615','2021-12-07 09:00:45',10,0),('1','176',244368,'DAILY SALES','2021-12-07','2021-12-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-07 09:03:07','615','2021-12-07 09:03:34',10,0),('1','176',244386,'DAILY SALES','2021-12-07','2021-12-07 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-07 17:52:56','615','2021-12-07 17:53:32',10,0),('1','176',244511,'DAILY SALES','2021-12-08','2021-12-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-08 15:22:43','615','2021-12-08 15:26:09',10,0),('1','176',244665,'DAILY SALES','2021-12-08','2021-12-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-08 15:31:29','615','2021-12-08 15:31:51',10,0),('1','176',244672,'DAILY SALES','2021-12-08','2021-12-08 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-08 18:15:02','615','2021-12-08 18:19:39',10,0),('1','176',244733,'DAILY SALES','2021-12-09','2021-12-09 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-09 18:20:29','615','2021-12-09 18:25:49',10,0),('1','176',244968,'DAILY SALES','2021-12-10','2021-12-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-10 11:26:53','615','2021-12-10 11:30:39',10,0),('1','176',245082,'DAILY SALES','2021-12-10','2021-12-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-10 11:34:43','615','2021-12-10 11:35:14',10,0),('1','176',245103,'DAILY SALES','2021-12-10','2021-12-10 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-10 18:16:56','615','2021-12-10 18:20:28',10,0),('1','176',245206,'DAILY SALES','2021-12-11','2021-12-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-11 16:12:06','615','2021-12-11 16:15:46',10,0),('1','176',245359,'DAILY SALES','2021-12-11','2021-12-11 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-11 16:32:14','615','2021-12-11 16:32:35',10,0),('1','176',245429,'DAILY SALES','2021-12-12','2021-12-12 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-12 18:19:38','615','2021-12-12 18:26:21',10,0),('1','176',245666,'DAILY SALES','2021-12-13','2021-12-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-13 11:18:04','615','2021-12-13 11:18:29',10,0),('1','176',245773,'DAILY SALES','2021-12-13','2021-12-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-13 11:24:40','615','2021-12-13 11:24:58',10,0),('1','176',245776,'DAILY SALES','2021-12-13','2021-12-13 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-13 17:54:12','615','2021-12-13 17:58:39',10,0),('1','176',245938,'DAILY SALES','2021-12-14','2021-12-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-14 13:14:33','615','2021-12-14 13:15:31',10,0),('1','176',246067,'DAILY SALES','2021-12-14','2021-12-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-14 13:22:21','615','2021-12-14 13:22:43',10,0),('1','176',246072,'DAILY SALES','2021-12-14','2021-12-14 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-14 18:16:24','615','2021-12-14 18:21:52',10,0),('1','176',246179,'DAILY  SALES ','2021-12-15','2021-12-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-15 14:40:46','615','2021-12-15 14:48:08',10,0),('1','176',246370,'DAILY SALES','2021-12-15','2021-12-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-15 14:51:44','615','2021-12-15 14:52:06',10,0),('1','176',246379,'DAILY SALES','2021-12-15','2021-12-15 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-15 17:48:28','615','2021-12-15 17:52:41',10,0),('1','176',246444,'DAILY SALES','2021-12-16','2021-12-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-16 17:50:53','615','2021-12-16 18:04:33',10,0),('1','176',246640,'DAILY SALES','2021-12-16','2021-12-16 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-16 18:07:26','615','2021-12-16 18:07:42',10,0),('1','176',246725,'DAILY SALES','2021-12-17','2021-12-17 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-17 17:44:30','615','2021-12-17 17:51:32',10,0),('1','176',246925,'DAILY SALES','2021-12-18','2021-12-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-18 09:04:21','615','2021-12-18 09:08:24',10,0),('1','176',247005,'DAILY SALES','2021-12-18','2021-12-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-18 09:12:24','615','2021-12-18 09:13:39',10,0),('1','176',247011,'DAILY SALES','2021-12-18','2021-12-18 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-18 17:57:14','615','2021-12-18 17:59:39',10,0),('1','176',247163,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-19 11:37:25','615','2021-12-19 11:38:12',10,0),('1','176',247263,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-19 11:40:23','615','2021-12-19 11:40:44',10,0),('1','176',247264,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-19 17:45:43','615','2021-12-19 17:53:49',10,0),('1','176',247395,'DAILY SALES','2021-12-20','2021-12-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-20 16:08:16','615','2021-12-20 16:09:10',10,0),('1','176',247587,'DAILY SALES','2021-12-20','2021-12-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-20 16:14:34','615','2021-12-20 16:14:51',10,0),('1','176',247588,'DAILY SALES','2021-12-20','2021-12-20 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-20 18:35:33','615','2021-12-20 18:36:11',10,0),('1','176',247663,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-21 10:55:50','615','2021-12-21 10:56:14',10,0),('1','176',247754,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-21 15:27:57','615','2021-12-21 15:28:24',10,0),('1','176',247827,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-21 15:31:27','615','2021-12-21 15:31:52',10,0),('1','176',247828,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-21 17:49:14','615','2021-12-21 17:53:11',10,0),('1','176',247904,'DAILY SALES','2021-12-22','2021-12-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-22 17:03:03','615','2021-12-22 17:08:40',10,0),('1','176',248079,'DAILY SALES','2021-12-22','2021-12-22 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-22 17:14:13','615','2021-12-22 17:15:03',10,0),('1','176',248152,'DAILY SALES','2021-12-23','2021-12-23 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-23 17:51:43','615','2021-12-23 17:56:39',10,0),('1','176',248398,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-24 07:05:27','615','2021-12-24 07:08:47',10,0),('1','176',248431,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-24 07:16:06','615','2021-12-24 07:16:33',10,0),('1','176',248435,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-24 17:02:38','615','2021-12-24 17:03:37',10,0),('1','176',248565,'DAILY  SALES ','2021-12-24','2021-12-24 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-24 17:09:55','615','2021-12-24 17:10:22',10,0),('1','176',248663,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-25 15:31:28','615','2021-12-25 15:32:59',10,0),('1','176',248786,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-25 15:35:45','615','2021-12-25 15:36:05',10,0),('1','176',248800,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-25 18:33:40','615','2021-12-25 18:35:50',10,0),('1','176',248857,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-26 09:45:46','615','2021-12-26 09:46:07',10,0),('1','176',248946,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-26 18:12:02','615','2021-12-26 18:12:32',10,0),('1','176',249048,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-26 18:17:36','615','2021-12-26 18:17:52',10,0),('1','176',249139,'DAILY SALES','2021-12-27','2021-12-27 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-27 17:52:07','615','2021-12-27 17:55:23',10,0),('1','176',249329,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-28 13:16:45','615','2021-12-28 13:17:06',10,0),('1','176',249482,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-28 13:19:29','615','2021-12-28 13:19:46',10,0),('1','176',249493,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-28 18:15:50','615','2021-12-28 18:16:36',10,0),('1','176',249577,'DAILY SALES','2021-12-29','2021-12-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-29 17:46:44','615','2021-12-29 17:54:22',10,0),('1','176',249787,'DAILY SALES','2021-12-29','2021-12-29 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-29 17:57:05','615','2021-12-29 17:57:27',10,0),('1','176',249841,'DAILY SALES','2021-12-30','2021-12-30 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-30 18:09:28','615','2021-12-30 18:17:10',10,0),('1','176',250080,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-31 09:29:36','615','2021-12-31 09:36:18',10,0),('1','176',250179,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-31 09:45:36','615','2021-12-31 09:46:01',10,0),('1','176',250193,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'615',0.00,0.00,'615','2021-12-31 18:19:36','615','2021-12-31 18:20:31',10,0),('1','176',250321,'DAILY SALES','2022-01-01','2022-01-01 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-01 17:26:59','615','2022-01-01 17:30:34',10,0),('1','176',250553,'DAILY SALES','2022-01-02','2022-01-02 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-02 17:31:17','615','2022-01-02 17:31:57',10,0),('1','176',250781,'DAILY SALES','2022-01-03','2022-01-03 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-03 12:25:52','615','2022-01-03 12:26:25',10,0),('1','176',250892,'DAILY SALES','2022-01-03','2022-01-03 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-03 17:56:26','615','2022-01-03 17:56:49',10,0),('1','176',251014,'DAILY SALES','2022-01-04','2022-01-04 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-04 14:06:27','615','2022-01-04 14:07:38',10,0),('1','176',251169,'DAILY SALES','2022-01-04','2022-01-04 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-04 17:56:20','615','2022-01-04 17:56:43',10,0),('1','176',251263,'DAILY SALES','2022-01-05','2022-01-05 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-05 19:05:50','615','2022-01-05 19:06:32',10,0),('1','176',251552,'DAILY SALES','2022-01-06','2022-01-06 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-06 08:18:42','615','2022-01-06 08:19:05',10,0),('1','176',251554,'DAILY SALES','2022-01-06','2022-01-06 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-06 19:16:33','615','2022-01-06 19:17:20',10,0),('1','176',251791,'DAILY SALES','2022-01-07','2022-01-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-07 11:52:30','615','2022-01-07 11:52:49',10,0),('1','176',251853,'OPERATIONAL LOSS','2022-01-07','2022-01-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-07 12:13:12','615','2022-01-07 12:13:35',10,0),('1','176',251858,'DAILY SALES','2022-01-07','2022-01-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-07 18:44:44','615','2022-01-07 18:45:23',10,0),('1','176',252012,'DAILY  SALES ','2022-01-08','2022-01-08 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-08 16:12:50','615','2022-01-08 16:14:14',10,0),('1','176',252156,'DAILY SALES','2022-01-08','2022-01-08 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-08 19:07:08','615','2022-01-08 19:08:51',10,0),('1','176',252251,'DAILY SALES','2022-01-09','2022-01-09 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-09 16:41:17','615','2022-01-09 16:42:03',10,0),('1','176',252379,'DAILY SALES','2022-01-09','2022-01-09 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-09 19:03:56','615','2022-01-09 19:05:27',10,0),('1','176',252510,'DAILY SALES','2022-01-10','2022-01-10 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-10 18:33:39','615','2022-01-10 18:34:32',10,0),('1','176',252743,'DAILY SALES','2022-01-11','2022-01-11 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-11 18:58:41','615','2022-01-11 19:00:34',10,0),('1','176',252987,'DAILY  SALES ','2022-01-12','2022-01-12 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-12 08:46:03','615','2022-01-12 08:46:27',10,0),('1','176',253015,'DAILY SALES','2022-01-12','2022-01-12 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-12 19:07:54','615','2022-01-12 19:08:43',10,0),('1','176',253220,'DAILY SALES','2022-01-13','2022-01-13 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-13 14:35:38','615','2022-01-13 14:36:28',10,0),('1','176',253370,'OPERATIONAL LOSS','2022-01-13','2022-01-13 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-13 14:38:56','615','2022-01-13 14:39:21',10,0),('1','176',253373,'DAILY SALES','2022-01-13','2022-01-13 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-13 19:25:42','615','2022-01-13 19:27:35',10,0),('1','176',253464,'DAILY SALES','2022-01-14','2022-01-14 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-14 16:11:46','615','2022-01-14 16:12:29',10,0),('1','176',253634,'OPERATIONAL LOSS','2022-01-14','2022-01-14 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-14 16:19:53','615','2022-01-14 16:20:14',10,0),('1','176',253714,'DAILY SALES','2022-01-15','2022-01-15 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-15 19:11:04','615','2022-01-15 19:12:59',10,0),('1','176',253959,'DAILY SALES','2022-01-16','2022-01-16 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-16 19:07:13','615','2022-01-16 19:08:52',10,0),('1','176',254197,'DAILY SALES','2022-01-17','2022-01-17 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-17 09:47:10','615','2022-01-17 09:47:43',10,0),('1','176',254273,'DAILY SALES','2022-01-17','2022-01-17 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-17 19:05:32','615','2022-01-17 19:11:52',10,0),('1','176',254439,'DAILY SALES','2022-01-18','2022-01-18 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-18 11:41:15','615','2022-01-18 11:42:20',10,0),('1','176',254553,'DAILY SALES','2022-01-18','2022-01-18 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-18 19:15:16','615','2022-01-18 19:17:48',10,0),('1','176',254703,'DAILY SALES','2022-01-19','2022-01-19 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-19 14:50:26','615','2022-01-19 14:52:47',10,0),('1','176',254868,'DAILY SALES','2022-01-19','2022-01-19 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-19 19:04:03','615','2022-01-19 19:06:29',10,0),('1','176',254950,'DAILY SALES','2022-01-20','2022-01-20 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-20 16:04:10','615','2022-01-20 16:04:39',10,0),('1','176',255112,'OPERATIONAL LOSS','2022-01-20','2022-01-20 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-20 16:20:04','615','2022-01-20 16:20:22',10,0),('1','176',255115,'DAILY SALES','2022-01-20','2022-01-20 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-20 18:46:03','615','2022-01-20 18:46:40',10,0),('1','176',255186,'DAILY SALES','2022-01-21','2022-01-21 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-21 18:36:44','615','2022-01-21 18:37:24',10,0),('1','176',255464,'DAILY SALES','2022-01-22','2022-01-22 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-22 10:46:02','615','2022-01-22 10:46:31',10,0),('1','176',255539,'OPERATIONAL LOSS','2022-01-22','2022-01-22 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-22 10:50:07','615','2022-01-22 10:50:30',10,0),('1','176',255541,'DAILY SALES','2022-01-22','2022-01-22 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-22 19:08:09','615','2022-01-22 19:13:18',10,0),('1','176',255713,'DAILY SALES','2022-01-23','2022-01-23 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-23 16:44:15','615','2022-01-23 16:45:00',10,0),('1','176',255868,'OPERATIONAL LOSS','2022-01-23','2022-01-23 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-23 17:00:42','615','2022-01-23 17:01:17',10,0),('1','176',255872,'DAILY SALES','2022-01-23','2022-01-23 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-23 19:10:00','615','2022-01-23 19:10:36',10,0),('1','176',255937,'DAILY SALES','2022-01-24','2022-01-24 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-24 12:43:28','615','2022-01-24 12:43:58',10,0),('1','176',256063,'OPERATIONAL LOSS','2022-01-24','2022-01-24 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-24 12:46:35','615','2022-01-24 12:46:56',10,0),('1','176',256096,'DAILY SALES','2022-01-24','2022-01-24 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-24 19:04:45','615','2022-01-24 19:09:17',10,0),('1','176',256210,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-25 13:24:59','615','2022-01-25 13:26:22',10,0),('1','176',256337,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-25 13:30:42','615','2022-01-25 13:31:07',10,0),('1','176',256341,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-25 19:10:00','615','2022-01-25 19:19:10',10,0),('1','176',256470,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-26 11:26:46','615','2022-01-26 11:27:47',10,0),('1','176',256582,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-26 19:02:40','615','2022-01-26 19:10:14',10,0),('1','176',256715,'DAILY SALES','2022-01-27','2022-01-27 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-27 08:46:06','615','2022-01-27 08:46:41',10,0),('1','176',256769,'DAILY SALES','2022-01-27','2022-01-27 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-27 18:57:20','615','2022-01-27 19:03:18',10,0),('1','176',256960,'DAILY SALES','2022-01-28','2022-01-28 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-28 12:22:52','615','2022-01-28 12:26:06',10,0),('1','176',257078,'DAILY SALES','2022-01-28','2022-01-28 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-28 19:12:28','615','2022-01-28 19:12:54',10,0),('1','176',257235,'DAILY SALES','2022-01-29','2022-01-29 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-29 16:43:07','615','2022-01-29 16:44:04',10,0),('1','176',257404,'DAILY SALES','2022-01-29','2022-01-29 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-29 19:11:21','615','2022-01-29 19:14:01',10,0),('1','176',257490,'DAILY SALES','2022-01-30','2022-01-30 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-30 19:28:26','615','2022-01-31 06:16:03',10,0),('1','176',257491,'DAILY SALES','2022-01-31','2022-01-31 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-31 08:40:43','615','2022-01-31 08:40:57',10,0),('1','176',257492,'DAILY SALES','2022-01-31','2022-01-31 00:00:00',NULL,'615',0.00,0.00,'615','2022-01-31 19:35:04','615','2022-01-31 19:36:06',10,0),('1','176',257493,'DAILY SALES','2022-02-01','2022-02-01 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-01 12:28:51','615','2022-02-01 12:29:09',10,0),('1','176',257494,'OPERATIONAL LOSS','2022-02-01','2022-02-01 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-01 12:39:19','615','2022-02-01 12:39:34',10,0),('1','176',257495,'DAILY SALES','2022-02-01','2022-02-01 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-01 19:07:22','615','2022-02-01 19:07:44',10,0),('1','176',257496,'DAILY SALES','2022-02-02','2022-02-02 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-03 07:44:37','615','2022-02-03 07:49:11',10,0),('1','176',257497,'OPERATIONAL LOSS','2022-02-03','2022-02-03 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-03 08:15:20','615','2022-02-03 08:15:39',10,0),('1','176',257498,'DAILY SALES','2022-02-03','2022-02-03 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-03 19:07:37','615','2022-02-03 19:08:02',10,0),('1','176',257499,'DAILY SALES','2022-02-04','2022-02-04 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-04 11:02:07','615','2022-02-04 11:02:22',10,0),('1','176',257500,'OPERATIONAL LOSS','2022-02-04','2022-02-04 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-04 11:29:33','615','2022-02-04 11:29:55',10,0),('1','176',257501,'DAILY SALES','2022-02-04','2022-02-04 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-04 19:28:00','615','2022-02-04 19:28:33',10,0),('1','176',257502,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-05 16:55:02','615','2022-02-05 16:58:24',10,0),('1','176',257503,'OPERATIONAL LOSS','2022-02-05','2022-02-05 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-05 17:26:18','615','2022-02-05 17:26:41',10,0),('1','176',257504,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-05 19:36:52','615','2022-02-05 19:37:17',10,0),('1','176',257505,'DAILY SALES','2022-02-06','2022-02-06 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-06 19:22:44','615','2022-02-06 19:23:37',10,0),('1','176',257506,'DAILY SALES','2022-02-07','2022-02-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-07 08:14:49','615','2022-02-07 08:15:06',10,0),('1','176',257507,'OPERATIONAL LOSS','2022-02-07','2022-02-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-07 08:17:15','615','2022-02-07 08:17:31',10,0),('1','176',257508,'DAILY SALES','2022-02-07','2022-02-07 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-07 19:04:03','615','2022-02-07 19:07:22',10,0),('1','176',257509,'DAILY SALES','2022-02-08','2022-02-08 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-08 11:22:17','615','2022-02-08 11:22:32',10,0),('1','176',257510,'OPERATIONAL LOSS','2022-02-08','2022-02-08 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-08 11:30:28','615','2022-02-08 11:30:45',10,0),('1','176',257511,'DAILY SALES','2022-02-08','2022-02-08 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-08 17:43:42','615','2022-02-08 17:44:04',10,0),('1','176',257512,'DAILY SALES','2022-02-09','2022-02-09 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-09 19:26:22','615','2022-02-09 19:26:57',10,0),('1','176',257513,'DAILY SALES','2022-02-10','2022-02-10 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-10 16:58:57','615','2022-02-10 17:00:36',10,0),('1','176',257514,'OPERATIONAL LOSS','2022-02-11','2022-02-11 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-11 06:48:46','615','2022-02-11 06:49:09',10,0),('1','176',257515,'DAILY SALES','2022-02-11','2022-02-11 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-11 19:27:47','615','2022-02-11 19:28:08',10,0),('1','176',257516,'DAILY SALES','2022-02-13','2022-02-13 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-13 08:23:50','615','2022-02-13 08:24:28',10,0),('1','176',257517,'DAILY SALES','2022-02-13','2022-02-13 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-13 17:09:27','615','2022-02-13 17:10:32',10,0),('1','176',257518,'DAILY SALES','2022-02-14','2022-02-14 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-14 18:55:26','615','2022-02-14 18:56:12',10,0),('1','176',257519,'DAILY SALES','2022-02-15','2022-02-15 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-15 10:18:18','615','2022-02-15 10:18:53',10,0),('1','176',257520,'DAILY SALES','2022-02-15','2022-02-15 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-15 19:17:29','615','2022-02-15 19:17:54',10,0),('1','176',257521,'DAILY SALES','2022-02-16','2022-02-16 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-16 16:44:36','615','2022-02-16 16:50:54',10,0),('1','176',257522,'OPERATIONAL LOSS','2022-02-16','2022-02-16 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-16 17:01:01','615','2022-02-16 17:01:30',10,0),('1','176',257523,'DAILY SALES','2022-02-17','2022-02-17 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-17 19:18:38','615','2022-02-17 19:19:05',10,0),('1','176',257524,'DAILY SALES','2022-02-18','2022-02-18 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-18 12:04:14','615','2022-02-18 12:04:50',10,0),('1','176',257525,'DAILY SALES','2022-02-18','2022-02-18 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-18 15:47:18','615','2022-02-18 15:47:35',10,0),('1','176',257526,'DAILY SALES','2022-02-18','2022-02-18 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-18 19:31:32','615','2022-02-18 19:33:01',10,0),('1','176',257527,'DAILY SALES','2022-02-19','2022-02-19 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-19 16:43:13','615','2022-02-19 16:44:31',10,0),('1','176',257528,'OPERATIONAL LOSS','2022-02-19','2022-02-19 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-19 16:48:02','615','2022-02-19 16:48:30',10,0),('1','176',257529,'DAILY SALES','2022-02-20','2022-02-20 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-20 19:37:27','615','2022-02-20 19:38:06',10,0),('1','176',257530,'DAILY SALES','2022-02-21','2022-02-21 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-21 09:10:27','615','2022-02-21 09:10:58',10,0),('1','176',257531,'OPERATIONAL LOSS','2022-02-21','2022-02-21 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-21 09:20:48','615','2022-02-21 09:21:12',10,0),('1','176',257532,'DAILY SALES','2022-02-21','2022-02-21 00:00:00',NULL,'615',0.00,0.00,'615','2022-02-21 19:40:57','615','2022-02-21 19:41:17',10,0),('1','176',257533,'DAILY SALES','2022-02-22','2022-02-22 09:27:11','2022-02-23 09:27:11','615',0.00,0.00,'615','2022-02-22 09:28:44','615','2022-02-22 09:29:00',10,0),('1','176',257534,'OPERATIONAL LOSS','2022-02-22','2022-02-22 09:29:36','2022-02-23 09:29:36','615',0.00,0.00,'615','2022-02-22 09:31:44','615','2022-02-22 09:32:05',10,0),('1','176',257535,'DAILY SALES','2022-02-22','2022-02-22 09:32:30','2022-02-23 09:32:30','615',0.00,0.00,'615','2022-02-22 19:18:52','615','2022-02-22 19:19:16',10,0),('1','176',257536,'DAILY SALES','2022-02-23','2022-02-23 06:43:15','2022-02-24 06:43:15','615',0.00,0.00,'615','2022-02-23 15:53:48','615','2022-02-23 15:54:22',10,0),('1','176',257537,'OPERATIONAL LOSS','2022-02-23','2022-02-23 15:57:22','2022-02-24 15:57:22','615',0.00,0.00,'615','2022-02-23 15:59:54','615','2022-02-23 16:00:18',10,0),('1','176',257538,'DAILY SALES','2022-02-23','2022-02-23 16:51:37','2022-02-24 16:51:37','615',0.00,0.00,'615','2022-02-23 19:39:48','615','2022-02-23 19:40:15',10,0),('1','176',257539,'DAILY  SALES ','2022-02-24','2022-02-24 06:09:39','2022-02-25 06:09:39','615',0.00,0.00,'615','2022-02-24 18:52:17','615','2022-02-24 18:52:37',10,0),('1','176',257540,'DAILY SALES','2022-02-25','2022-02-25 08:55:28','2022-02-26 08:55:28','615',0.00,0.00,'615','2022-02-25 19:23:23','615','2022-02-25 19:39:29',10,0),('1','176',257541,'DAILY  SALES ','2022-02-26','2022-02-26 06:25:52','2022-02-27 06:25:52','615',0.00,0.00,'615','2022-02-26 11:31:33','615','2022-02-26 11:31:49',10,0),('1','176',257542,'OPERATIONAL LOSS','2022-02-26','2022-02-26 11:39:30','2022-02-27 11:39:30','615',0.00,0.00,'615','2022-02-26 11:42:11','615','2022-02-26 11:42:28',10,0),('1','176',257543,'DAILY SALES','2022-02-26','2022-02-26 11:43:16','2022-02-27 11:43:16','615',0.00,0.00,'615','2022-02-26 19:17:23','615','2022-02-26 19:17:43',10,0),('1','176',257544,'DAILY  SALES ','2022-02-27','2022-02-27 06:34:43','2022-02-28 06:34:43','615',0.00,0.00,'615','2022-02-27 13:20:00','615','2022-02-27 13:20:19',10,0),('1','176',257545,'OPERATIONAL LOSS','2022-02-27','2022-02-27 13:22:16','2022-02-28 13:22:16','615',0.00,0.00,'615','2022-02-27 13:25:25','615','2022-02-27 13:25:41',10,0),('1','176',257546,'DAILY SALES','2022-02-27','2022-02-27 13:27:39','2022-02-28 13:27:39','615',0.00,0.00,'615','2022-02-27 19:43:53','615','2022-02-27 19:44:11',10,0),('1','176',257547,'DAILY  SALES ','2022-02-28','2022-02-28 06:25:16','2022-03-01 06:25:16','615',0.00,0.00,'615','2022-02-28 15:02:57','615','2022-02-28 15:03:28',10,0),('1','176',257548,'OPERATIONAL LOSS','2022-02-28','2022-02-28 15:30:36','2022-03-01 15:30:36','615',0.00,0.00,'615','2022-02-28 15:33:11','615','2022-02-28 15:33:26',10,0),('1','176',257549,'DAILY SALES','2022-02-28','2022-02-28 15:40:25','2022-03-01 15:40:25','615',0.00,0.00,'615','2022-02-28 21:27:28','615','2022-02-28 21:27:46',10,0),('1','176',257550,'DAILY SALES','2022-03-01','2022-03-01 07:49:21','2022-03-02 07:49:21','615',0.00,0.00,'615','2022-03-01 11:32:06','615','2022-03-01 11:32:22',10,0),('1','176',257551,'DAILY SALES','2022-03-01','2022-03-01 11:37:44','2022-03-02 11:37:44','615',0.00,0.00,'615','2022-03-01 19:36:57','615','2022-03-01 19:37:21',10,0),('1','176',257552,'DAILY SALES ','2022-03-02','2022-03-02 06:27:20','2022-03-03 06:27:20','615',0.00,0.00,'615','2022-03-02 12:00:53','615','2022-03-02 12:01:46',10,0),('1','176',257553,'DAILY SALES','2022-03-02','2022-03-02 12:05:16','2022-03-03 12:05:16','615',0.00,0.00,'615','2022-03-02 19:30:40','615','2022-03-02 19:30:57',10,0),('1','176',257554,'DAILY SALES','2022-03-03','2022-03-03 07:28:48','2022-03-04 07:28:48','615',0.00,0.00,'615','2022-03-03 15:16:56','615','2022-03-03 15:17:15',10,0),('1','176',257555,'DAILY SALES','2022-03-03','2022-03-03 15:39:42','2022-03-04 15:39:42','615',0.00,0.00,'615','2022-03-03 19:51:06','615','2022-03-03 19:51:57',10,0),('1','176',257556,'DAILY  SALES ','2022-03-04','2022-03-04 06:38:25','2022-03-05 06:38:25','615',0.00,0.00,'615','2022-03-04 20:00:32','615','2022-03-04 20:00:51',10,0),('1','176',257557,'DAILY SALES','2022-03-05','2022-03-05 07:33:12','2022-03-06 07:33:12','615',0.00,0.00,'615','2022-03-05 18:10:22','615','2022-03-05 18:10:41',10,0),('1','176',257558,'DAILY SALES ','2022-03-06','2022-03-06 07:21:12','2022-03-07 07:21:12','615',0.00,0.00,'615','2022-03-06 22:05:22','615','2022-03-06 22:05:42',10,0),('1','176',257559,'DAILY SALES','2022-03-07','2022-03-07 10:39:42','2022-03-08 10:39:42','615',0.00,0.00,'615','2022-03-07 20:16:07','615','2022-03-07 20:16:24',10,0),('1','176',257560,'DAILY  SALES ','2022-03-08','2022-03-08 06:49:52','2022-03-09 06:49:52','615',0.00,0.00,'615','2022-03-08 13:01:41','615','2022-03-08 13:02:10',10,0),('1','176',257561,'DAILY SALES','2022-03-08','2022-03-08 13:05:18','2022-03-09 13:05:18','615',0.00,0.00,'615','2022-03-08 19:39:55','615','2022-03-08 19:40:15',10,0),('1','176',257562,'DAILY SALES','2022-03-09','2022-03-09 07:50:25','2022-03-10 07:50:25','615',0.00,0.00,'615','2022-03-09 20:15:02','615','2022-03-09 20:15:26',10,0),('1','176',257563,'DAILY  SALES ','2022-03-10','2022-03-10 07:13:12','2022-03-11 07:13:12','615',0.00,0.00,'615','2022-03-10 19:36:22','615','2022-03-10 19:36:43',10,0),('1','176',257564,'DAILY SALES','2022-03-11','2022-03-11 08:02:24','2022-03-12 08:02:24','615',0.00,0.00,'615','2022-03-11 19:57:06','615','2022-03-11 19:57:34',10,0),('1','176',257565,'DAILY SALES','2022-03-12','2022-03-12 08:04:04','2022-03-13 08:04:04','615',0.00,0.00,'615','2022-03-12 18:43:01','615','2022-03-12 18:43:18',10,0),('1','176',257566,'DAILY SALES','2022-03-13','2022-03-13 06:41:20','2022-03-14 06:41:20','615',0.00,0.00,'615','2022-03-13 18:34:11','615','2022-03-13 18:39:38',10,0),('1','176',257567,'DAILY SALES','2022-03-14','2022-03-14 06:53:50','2022-03-15 06:53:50','615',0.00,0.00,'615','2022-03-14 19:41:51','615','2022-03-14 19:42:26',10,0),('1','176',257568,'DAILY SALES','2022-03-15','2022-03-15 07:20:58','2022-03-16 07:20:58','615',0.00,0.00,'615','2022-03-15 19:06:44','615','2022-03-15 19:07:12',10,0),('1','176',257569,'OPERATIONAL LOSS','2022-03-15','2022-03-15 19:18:35','2022-03-16 19:18:35','615',0.00,0.00,'615','2022-03-15 19:21:51','615','2022-03-15 19:22:08',10,0),('1','176',257570,'DAILY SALES','2022-03-15','2022-03-15 19:33:30','2022-03-16 19:33:30','615',0.00,0.00,'615','2022-03-16 07:22:50','615','2022-03-16 07:23:16',10,0),('1','176',257571,'DAILY SALES ','2022-03-16','2022-03-16 07:23:52','2022-03-17 07:23:52','615',0.00,0.00,'615','2022-03-16 19:44:29','615','2022-03-16 19:44:47',10,0),('1','176',257572,'DAILY SALES','2022-03-17','2022-03-17 07:09:06','2022-03-18 07:09:06','615',0.00,0.00,'615','2022-03-17 19:36:42','615','2022-03-17 19:37:01',10,0),('1','176',257573,'DAILY SALES','2022-03-18','2022-03-18 06:34:57','2022-03-19 06:34:57','615',0.00,0.00,'615','2022-03-18 20:17:07','615','2022-03-18 20:17:26',10,0),('1','176',257574,'DAILY SALES','2022-03-19','2022-03-19 06:52:37','2022-03-20 06:52:37','615',0.00,0.00,'615','2022-03-19 11:14:07','615','2022-03-19 11:14:28',10,0),('1','176',257575,'DAILY SALES','2022-03-19','2022-03-19 11:22:08','2022-03-20 11:22:08','615',0.00,0.00,'615','2022-03-19 20:04:40','615','2022-03-19 20:04:57',10,0),('1','176',257576,'DAILY SALES','2022-03-20','2022-03-20 06:28:33','2022-03-21 06:28:33','615',0.00,0.00,'615','2022-03-20 15:44:36','615','2022-03-20 15:44:54',10,0),('1','176',257577,'OPERATIONAL LOSS','2022-03-20','2022-03-20 15:46:10','2022-03-21 15:46:10','615',0.00,0.00,'615','2022-03-20 15:48:39','615','2022-03-20 15:48:58',10,0),('1','176',257578,'DAILY SALES','2022-03-20','2022-03-20 15:52:08','2022-03-21 15:52:08','615',0.00,0.00,'615','2022-03-20 19:37:50','615','2022-03-20 19:38:37',10,0),('1','176',257579,'DAILY SALES','2022-03-21','2022-03-21 06:52:28','2022-03-22 06:52:28','615',0.00,0.00,'615','2022-03-21 18:42:15','615','2022-03-21 18:42:49',10,0),('1','176',257580,'OPERATIONAL LOSS','2022-03-21','2022-03-21 18:43:30','2022-03-22 18:43:30','615',0.00,0.00,'615','2022-03-21 18:46:27','615','2022-03-21 18:48:14',10,0),('1','176',257581,'DAILY SALES','2022-03-22','2022-03-22 06:30:30','2022-03-23 06:30:30','615',0.00,0.00,'615','2022-03-22 19:43:06','615','2022-03-22 19:43:22',10,0),('1','176',257582,'DAILY SALES','2022-03-23','2022-03-23 07:02:17','2022-03-24 07:02:17','615',0.00,0.00,'615','2022-03-23 19:37:25','615','2022-03-23 19:37:42',10,0),('1','176',257583,'DAILY SALES','2022-03-24','2022-03-24 06:28:46','2022-03-25 06:28:46','615',0.00,0.00,'615','2022-03-24 11:02:28','615','2022-03-24 11:02:47',10,0),('1','176',257584,'DAILY SALES','2022-03-24','2022-03-24 11:13:37','2022-03-25 11:13:37','615',0.00,0.00,'615','2022-03-24 20:27:20','615','2022-03-24 20:27:38',10,0),('1','176',257585,'DAILY SALES','2022-03-25','2022-03-25 07:00:35','2022-03-26 07:00:35','615',0.00,0.00,'615','2022-03-25 12:27:48','615','2022-03-25 12:28:12',10,0),('1','176',257586,'DAILY SALES','2022-03-25','2022-03-25 12:28:37','2022-03-26 12:28:37','615',0.00,0.00,'615','2022-03-25 19:33:14','615','2022-03-25 19:33:34',10,0),('1','176',257587,'DAILY SALES','2022-03-26','2022-03-26 06:32:26','2022-03-27 06:32:26','615',0.00,0.00,'615','2022-03-26 17:07:36','615','2022-03-26 17:07:55',10,0),('1','176',257588,'DAILY SALES','2022-03-26','2022-03-26 17:09:08','2022-03-27 17:09:08','615',0.00,0.00,'615','2022-03-26 20:05:15','615','2022-03-26 20:05:34',10,0),('1','176',257589,'DAILY SALES','2022-03-27','2022-03-27 06:46:48','2022-03-28 06:46:48','615',0.00,0.00,'615','2022-03-27 12:13:13','615','2022-03-27 12:13:29',10,0),('1','176',257590,'DAILY SALES','2022-03-27','2022-03-27 12:14:21','2022-03-28 12:14:21','615',0.00,0.00,'615','2022-03-27 17:45:04','615','2022-03-27 17:45:52',10,0),('1','176',257591,'DAILY SALES','2022-03-27','2022-03-27 18:19:58','2022-03-28 18:19:58','615',0.00,0.00,'615','2022-03-27 18:23:28','615','2022-03-27 18:23:51',10,0),('1','176',257592,'DAILY SALES','2022-03-28','2022-03-28 07:07:00','2022-03-29 07:07:00','615',0.00,0.00,'615','2022-03-28 19:26:22','615','2022-03-28 19:26:52',10,0),('1','176',257593,'DAILY SALES','2022-03-29','2022-03-29 06:41:43','2022-03-30 06:41:43','615',0.00,0.00,'615','2022-03-29 12:58:31','615','2022-03-29 12:58:55',10,0),('1','176',257594,'OPERATIONAL LOSS','2022-03-29','2022-03-29 12:59:16','2022-03-30 12:59:16','615',0.00,0.00,'615','2022-03-29 13:02:14','615','2022-03-29 13:02:32',10,0),('1','176',257595,'DAILY SALES','2022-03-29','2022-03-29 13:02:53','2022-03-30 13:02:53','615',0.00,0.00,'615','2022-03-29 19:34:10','615','2022-03-29 19:34:33',10,0),('1','176',257596,'DAILY SALES','2022-03-30','2022-03-30 06:30:25','2022-03-31 06:30:25','615',0.00,0.00,'615','2022-03-30 11:00:56','615','2022-03-30 11:13:48',10,0),('1','176',257597,'DAILY SALES','2022-03-30','2022-03-30 11:18:24','2022-03-31 11:18:24','615',0.00,0.00,'615','2022-03-30 19:24:44','615','2022-03-30 19:25:02',10,0),('1','176',257598,'DAILY SALES','2022-03-31','2022-03-31 07:00:23','2022-04-01 07:00:23','615',0.00,0.00,'615','2022-03-31 07:31:34','615','2022-03-31 07:32:50',10,0),('1','176',257599,'DAILY SALES','2022-03-31','2022-03-31 07:35:28','2022-04-01 07:35:28','615',0.00,0.00,'615','2022-03-31 19:13:40','615','2022-03-31 19:14:01',10,0),('1','176',257600,'DAILY SALES','2022-04-01','2022-04-01 06:29:17','2022-04-02 06:29:17','615',0.00,0.00,'615','2022-04-01 13:41:32','615','2022-04-01 13:43:36',10,0),('1','176',257601,'DAILY SALES','2022-04-01','2022-04-01 13:51:27','2022-04-02 13:51:27','615',0.00,0.00,'615','2022-04-01 19:32:34','615','2022-04-01 19:32:57',10,0),('1','176',257602,'DAILY SALES','2022-04-02','2022-04-02 06:34:21','2022-04-03 06:34:21','615',0.00,0.00,'615','2022-04-02 14:57:00','615','2022-04-02 14:58:03',10,0),('1','176',257603,'DAILY SALES','2022-04-02','2022-04-02 14:58:39','2022-04-03 14:58:39','615',0.00,0.00,'615','2022-04-02 19:41:08','615','2022-04-02 19:41:25',10,0),('1','176',257604,'DAILY SALES','2022-04-03','2022-04-03 06:46:00','2022-04-04 06:46:00','615',0.00,0.00,'615','2022-04-03 13:32:05','615','2022-04-03 13:32:27',10,0),('1','176',257605,'DAILY SALES','2022-04-03','2022-04-03 13:40:08','2022-04-04 13:40:08','615',0.00,0.00,'615','2022-04-03 18:37:00','615','2022-04-03 18:37:24',10,0),('1','176',257606,'DAILY SALES','2022-04-04','2022-04-04 06:34:11','2022-04-05 06:34:11','615',0.00,0.00,'615','2022-04-04 13:16:10','615','2022-04-04 13:16:24',10,0),('1','176',257607,'OPERATIONAL LOSS','2022-04-04','2022-04-04 13:18:05','2022-04-05 13:18:05','615',0.00,0.00,'615','2022-04-04 13:21:18','615','2022-04-04 13:21:32',10,0),('1','176',257608,'DAILY SALES','2022-04-04','2022-04-04 16:26:21','2022-04-05 16:26:21','615',0.00,0.00,'615','2022-04-04 19:25:37','615','2022-04-04 19:26:24',10,0),('1','176',257609,'DAILY SALES','2022-04-05','2022-04-05 06:33:35','2022-04-06 06:33:35','615',0.00,0.00,'615','2022-04-05 15:37:09','615','2022-04-05 15:37:30',10,0),('1','176',257610,'DAILY SALES','2022-04-05','2022-04-05 15:39:04','2022-04-06 15:39:04','615',0.00,0.00,'615','2022-04-05 19:23:29','615','2022-04-05 19:24:03',10,0),('1','176',257611,'DAILY SALES','2022-04-06','2022-04-06 06:37:49','2022-04-07 06:37:49','615',0.00,0.00,'615','2022-04-06 07:51:23','615','2022-04-06 07:52:10',10,0),('1','176',257612,'OPERATIONAL LOSS','2022-04-06','2022-04-06 08:07:21','2022-04-07 08:07:21','615',0.00,0.00,'615','2022-04-06 08:12:22','615','2022-04-06 08:12:42',10,0),('1','176',257613,'DAILY SALES','2022-04-06','2022-04-06 08:13:14','2022-04-07 08:13:14','615',0.00,0.00,'615','2022-04-06 19:25:40','615','2022-04-06 19:26:12',10,0),('1','176',257614,'DAILY SALES','2022-04-07','2022-04-07 06:35:37','2022-04-08 06:35:37','615',0.00,0.00,'615','2022-04-08 06:35:39','615','2022-04-08 06:35:54',10,0),('1','176',257615,'DAILY SALES','2022-04-08','2022-04-08 06:36:32','2022-04-09 06:36:32','615',0.00,0.00,'615','2022-04-08 19:48:16','615','2022-04-08 19:48:33',10,0),('1','176',257616,'DAILY SALES','2022-04-09','2022-04-09 07:23:44','2022-04-10 07:23:44','615',0.00,0.00,'615','2022-04-09 19:08:05','615','2022-04-09 19:08:23',10,0),('1','176',257617,'DAILY SALES','2022-04-10','2022-04-10 06:45:21','2022-04-11 06:45:21','615',0.00,0.00,'615','2022-04-10 14:36:12','615','2022-04-10 14:36:29',10,0),('1','176',257618,'OPERATIONAL LOSS','2022-04-10','2022-04-10 14:37:00','2022-04-11 14:37:00','615',0.00,0.00,'615','2022-04-10 14:39:18','615','2022-04-10 14:39:40',10,0),('1','176',257619,'DAILY SALES','2022-04-12','2022-04-12 12:15:05','2022-04-13 12:15:05','615',0.00,0.00,'615','2022-04-12 18:43:40','615','2022-04-12 18:44:01',10,0),('1','176',257620,'DAILY SALES','2022-04-13','2022-04-13 06:37:05','2022-04-14 06:37:05','615',0.00,0.00,'615','2022-04-13 18:22:38','615','2022-04-13 18:22:55',10,0),('1','176',257621,'DAILY SALES','2022-04-14','2022-04-14 06:47:44','2022-04-15 06:47:44','615',0.00,0.00,'615','2022-04-14 18:23:40','615','2022-04-14 18:24:09',10,0),('1','176',257622,'OPERATIONAL LOSS','2022-04-14','2022-04-14 18:40:24','2022-04-15 18:40:24','615',0.00,0.00,'615','2022-04-14 18:42:25','615','2022-04-14 18:42:59',10,0),('1','176',257623,'DAILY SALES','2022-04-15','2022-04-15 06:34:56','2022-04-16 06:34:56','615',0.00,0.00,'615','2022-04-15 18:39:50','615','2022-04-15 18:40:14',10,0),('1','176',257624,'DAILY SALES','2022-04-16','2022-04-16 06:46:12','2022-04-17 06:46:12','615',0.00,0.00,'615','2022-04-16 20:20:01','615','2022-04-16 20:20:31',10,0),('1','176',257625,'DAILY SALES','2022-04-17','2022-04-17 06:38:48','2022-04-18 06:38:48','615',0.00,0.00,'615','2022-04-17 17:54:44','615','2022-04-17 17:55:09',10,0),('1','176',257626,'DAILY SALES','2022-04-18','2022-04-18 06:38:59','2022-04-19 06:38:59','615',0.00,0.00,'615','2022-04-18 18:11:02','615','2022-04-18 18:11:21',10,0),('1','176',257627,'DAILY SALES57409','2022-04-19','2022-04-19 06:49:06','2022-04-20 06:49:06','615',0.00,0.00,'615','2022-04-19 10:03:29','615','2022-04-19 10:04:40',10,0),('1','176',257628,'OPERATIONAL LOSS','2022-04-19','2022-04-19 10:05:02','2022-04-20 10:05:02','615',0.00,0.00,'615','2022-04-19 10:09:52','615','2022-04-19 10:10:09',10,0),('1','176',257629,'DAILY SALES','2022-04-19','2022-04-19 10:10:26','2022-04-20 10:10:26','615',0.00,0.00,'615','2022-04-19 18:45:43','615','2022-04-19 18:46:01',10,0),('1','176',257630,'DAILY SALES57409','2022-04-20','2022-04-20 06:30:56','2022-04-21 06:30:56','615',0.00,0.00,'615','2022-04-20 20:02:20','615','2022-04-20 20:02:50',10,0),('1','176',257631,'DAILY SALES','2022-04-21','2022-04-21 06:37:04','2022-04-22 06:37:04','615',0.00,0.00,'615','2022-04-21 07:40:35','615','2022-04-21 07:40:53',10,0),('1','176',257632,'DAILY SALES','2022-04-21','2022-04-21 07:42:01','2022-04-22 07:42:01','615',0.00,0.00,'615','2022-04-21 19:13:54','615','2022-04-21 19:14:10',10,0),('1','176',257633,'DAILY SALES','2022-04-22','2022-04-22 06:23:01','2022-04-23 06:23:01','615',0.00,0.00,'615','2022-04-22 12:15:33','615','2022-04-22 12:15:49',10,0),('1','176',257634,'DAILY SALES','2022-04-22','2022-04-22 12:20:19','2022-04-23 12:20:19','615',0.00,0.00,'615','2022-04-22 19:01:01','615','2022-04-22 19:01:18',10,0),('1','176',257635,'DAILY SALES','2022-04-23','2022-04-23 06:32:15','2022-04-24 06:32:15','615',0.00,0.00,'615','2022-04-23 17:24:29','615','2022-04-23 17:26:08',10,0),('1','176',257636,'DAILY SALES','2022-04-23','2022-04-23 17:29:46','2022-04-24 17:29:46','615',0.00,0.00,'615','2022-04-23 18:46:04','615','2022-04-23 18:46:26',10,0),('1','176',257637,'DAILY SALES','2022-04-24','2022-04-24 07:48:27','2022-04-25 07:48:27','615',0.00,0.00,'615','2022-04-24 19:17:56','615','2022-04-24 19:18:14',10,0),('1','176',257638,'DAILY SALES','2022-04-25','2022-04-25 06:36:02','2022-04-26 06:36:02','615',0.00,0.00,'615','2022-04-25 11:49:04','615','2022-04-25 11:49:29',10,0),('1','176',257639,'DAILY SALES','2022-04-25','2022-04-25 11:54:16','2022-04-26 11:54:16','615',0.00,0.00,'615','2022-04-25 19:29:20','615','2022-04-25 19:30:09',10,0),('1','176',257640,'DAILY SALES','2022-04-26','2022-04-26 06:36:37','2022-04-27 06:36:37','615',0.00,0.00,'615','2022-04-26 13:42:36','615','2022-04-26 13:42:55',10,0),('1','176',257641,'DAILY SALES','2022-04-26','2022-04-26 13:43:35','2022-04-27 13:43:35','615',0.00,0.00,'615','2022-04-26 18:45:47','615','2022-04-26 18:46:01',10,0),('1','176',257642,'DAILY SALES','2022-04-27','2022-04-27 06:57:52','2022-04-28 06:57:52','615',0.00,0.00,'615','2022-04-27 17:05:44','615','2022-04-27 17:06:16',10,0),('1','176',257643,'OPERATIONAL LOSS','2022-04-27','2022-04-27 17:07:03','2022-04-28 17:07:03','615',0.00,0.00,'615','2022-04-27 17:09:08','615','2022-04-27 17:09:36',10,0),('1','176',257644,'DAILY SALES','2022-04-27','2022-04-27 17:54:24','2022-04-28 17:54:24','615',0.00,0.00,'615','2022-04-27 18:59:08','615','2022-04-27 18:59:24',10,0),('1','176',257645,'DAILY SALES','2022-04-28','2022-04-28 06:26:12','2022-04-29 06:26:12','615',0.00,0.00,'615','2022-04-28 18:59:03','615','2022-04-28 18:59:22',10,0),('1','176',257646,'DAILY SALES','2022-04-29','2022-04-29 07:24:05','2022-04-30 07:24:05','615',0.00,0.00,'615','2022-04-29 10:31:40','615','2022-04-29 10:32:13',10,0),('1','176',257647,'DAILY SALES ','2022-04-29','2022-04-29 10:37:26','2022-04-30 10:37:26','615',0.00,0.00,'615','2022-04-29 19:17:14','615','2022-04-29 19:17:32',10,0),('1','176',257648,'DAILY SALES','2022-04-30','2022-04-30 06:46:25','2022-05-01 06:46:25','615',0.00,0.00,'615','2022-04-30 10:57:50','615','2022-04-30 10:58:12',10,0),('1','176',257649,'DAILY SALES ','2022-04-30','2022-04-30 11:00:56','2022-05-01 11:00:56','615',0.00,0.00,'615','2022-04-30 19:27:28','615','2022-04-30 19:27:46',10,0),('1','176',257650,'DAILY SALES ','2022-05-01','2022-05-01 05:28:54','2022-05-02 05:28:54','615',0.00,0.00,'615','2022-05-01 05:31:05','615','2022-05-01 05:31:33',10,0),('1','176',257651,'DAILY SALES','2022-05-01','2022-05-01 06:37:56','2022-05-02 06:37:56','615',0.00,0.00,'615','2022-05-01 19:41:46','615','2022-05-01 19:42:03',10,0),('1','176',257652,'DAILY SALES','2022-05-02','2022-05-02 11:03:45','2022-05-03 11:03:45','615',0.00,0.00,'615','2022-05-02 14:07:01','615','2022-05-02 14:07:35',10,0),('1','176',257653,'DAILY SALES','2022-05-02','2022-05-02 14:11:43','2022-05-03 14:11:43','615',0.00,0.00,'615','2022-05-02 18:26:15','615','2022-05-02 18:26:32',10,0),('1','176',257654,'DAILY SALES','2022-05-03','2022-05-03 07:21:52','2022-05-04 07:21:52','615',0.00,0.00,'615','2022-05-03 16:34:58','615','2022-05-03 16:35:20',10,0),('1','176',257655,'OPERATIONAL LOSS','2022-05-03','2022-05-03 16:36:06','2022-05-04 16:36:06','615',0.00,0.00,'615','2022-05-03 16:38:59','615','2022-05-03 16:39:29',10,0),('1','176',257656,'DAILY SALES ','2022-05-04','2022-05-04 07:47:09','2022-05-05 07:47:09','615',0.00,0.00,'615','2022-05-04 16:47:49','615','2022-05-04 16:48:11',10,0),('1','176',257657,'DAILY SALES','2022-05-04','2022-05-04 17:21:25','2022-05-05 17:21:25','615',0.00,0.00,'615','2022-05-04 18:43:45','615','2022-05-04 18:44:19',10,0),('1','176',257658,'DAILY SALES','2022-05-05','2022-05-05 06:04:45','2022-05-06 06:04:45','615',0.00,0.00,'615','2022-05-05 18:08:20','615','2022-05-05 18:09:48',10,0),('1','176',257659,'OPERATIONAL LOSS','2022-05-05','2022-05-05 18:11:25','2022-05-06 18:11:25','615',0.00,0.00,'615','2022-05-05 18:19:03','615','2022-05-05 18:19:55',10,0),('1','176',257660,'DAILY SALES','2022-05-06','2022-05-06 06:34:10','2022-05-07 06:34:10','615',0.00,0.00,'615','2022-05-06 18:59:58','615','2022-05-06 19:00:16',10,0),('1','176',257661,'DAILY SALES','2022-05-07','2022-05-07 06:45:20','2022-05-08 06:45:20','615',0.00,0.00,'615','2022-05-07 13:22:34','615','2022-05-07 13:22:56',10,0),('1','176',257662,'OPERATIONAL LOSS','2022-05-07','2022-05-07 13:23:22','2022-05-08 13:23:22','615',0.00,0.00,'615','2022-05-07 13:33:28','615','2022-05-07 13:34:00',10,0),('1','176',257663,'DAILY SALES','2022-05-07','2022-05-07 16:40:01','2022-05-08 16:40:01','615',0.00,0.00,'615','2022-05-07 19:11:36','615','2022-05-07 19:11:53',10,0),('1','176',257664,'DAILY SALES','2022-05-08','2022-05-08 06:52:40','2022-05-09 06:52:40','615',0.00,0.00,'615','2022-05-08 18:51:29','615','2022-05-08 18:51:54',10,0),('1','176',257665,'DAILY SALES','2022-05-09','2022-05-09 06:30:16','2022-05-10 06:30:16','615',0.00,0.00,'615','2022-05-09 18:54:53','615','2022-05-09 18:55:14',10,0),('1','176',257666,'DAILY SALES','2022-05-10','2022-05-10 06:50:27','2022-05-11 06:50:27','615',0.00,0.00,'615','2022-05-11 06:02:29','615','2022-05-11 06:02:47',10,0),('1','176',257667,'DAILY SALES','2022-05-11','2022-05-11 06:39:56','2022-05-12 06:39:56','615',0.00,0.00,'615','2022-05-11 19:42:47','615','2022-05-11 19:43:14',10,0),('1','176',257668,'DAILY SALES','2022-05-12','2022-05-12 06:25:07','2022-05-13 06:25:07','615',0.00,0.00,'615','2022-05-12 22:47:31','615','2022-05-12 22:47:51',10,0),('1','176',257669,'DAILY SALES','2022-05-13','2022-05-13 06:35:12','2022-05-14 06:35:12','615',0.00,0.00,'615','2022-05-13 18:43:59','615','2022-05-13 18:44:17',10,0),('1','176',257670,'DAILY SALES','2022-05-14','2022-05-14 06:36:42','2022-05-15 06:36:42','615',0.00,0.00,'615','2022-05-14 18:36:14','615','2022-05-14 18:36:30',10,0),('1','176',257671,'OPERATIONAL LOSS','2022-05-14','2022-05-14 18:38:43','2022-05-15 18:38:43','615',0.00,0.00,'615','2022-05-14 18:40:33','615','2022-05-14 18:40:47',10,0),('1','176',257672,'DAILY SALES','2022-05-18','2022-05-18 15:04:29','2022-05-19 15:04:29','615',0.00,0.00,'615','2022-05-18 19:05:21','615','2022-05-18 19:05:36',10,0),('1','176',257673,'DAILY SALES','2022-05-19','2022-05-19 06:36:38','2022-05-20 06:36:38','615',0.00,0.00,'615','2022-05-19 19:26:48','615','2022-05-19 19:27:09',10,0),('1','176',257674,'DAILY SALES','2022-05-20','2022-05-20 06:31:04','2022-05-21 06:31:04','615',0.00,0.00,'615','2022-05-20 19:08:29','615','2022-05-20 19:08:48',10,0),('1','176',257675,'DAILY SALES','2022-05-21','2022-05-21 06:32:39','2022-05-22 06:32:39','615',0.00,0.00,'615','2022-05-21 19:16:23','615','2022-05-21 19:16:43',10,0),('1','176',257676,'DAILY SALES','2022-05-22','2022-05-22 06:31:58','2022-05-23 06:31:58','615',0.00,0.00,'615','2022-05-22 19:14:12','615','2022-05-22 19:15:25',10,0),('1','176',257677,'DAILY SALES','2022-05-23','2022-05-23 06:28:11','2022-05-24 06:28:11','615',0.00,0.00,'615','2022-05-23 18:58:55','615','2022-05-23 18:59:11',10,0),('1','176',257678,'DAILY SALES','2022-05-24','2022-05-24 06:02:05','2022-05-25 06:02:05','615',0.00,0.00,'615','2022-05-24 20:39:36','615','2022-05-24 20:39:54',10,0),('1','176',257679,'DAILY SALES','2022-05-25','2022-05-25 06:23:10','2022-05-26 06:23:10','615',0.00,0.00,'615','2022-05-25 10:00:00','615','2022-05-25 10:00:15',10,0),('1','176',257680,'DAILY SALES','2022-05-25','2022-05-25 10:04:25','2022-05-26 10:04:25','615',0.00,0.00,'615','2022-05-25 10:07:51','615','2022-05-25 10:08:07',10,0),('1','176',257681,'DAILY SALES','2022-05-25','2022-05-25 10:08:21','2022-05-26 10:08:21','615',0.00,0.00,'615','2022-05-25 18:55:31','615','2022-05-25 18:57:12',10,0),('1','176',257682,'DAILY SALES','2022-05-26','2022-05-26 06:09:40','2022-05-27 06:09:40','615',0.00,0.00,'615','2022-05-26 19:34:07','615','2022-05-26 19:35:08',10,0),('1','176',257683,'DAILY SALES','2022-05-27','2022-05-27 06:14:10','2022-05-28 06:14:10','615',0.00,0.00,'615','2022-05-27 09:17:22','615','2022-05-27 09:17:38',10,0),('1','176',257684,'Operational loss','2022-05-27','2022-05-27 09:18:26','2022-05-28 09:18:26','615',0.00,0.00,'615','2022-05-27 09:22:11','615','2022-05-27 09:22:27',10,0),('1','176',257685,'DAILY SALES','2022-05-27','2022-05-27 09:22:59','2022-05-28 09:22:59','615',0.00,0.00,'615','2022-05-27 19:30:36','615','2022-05-27 19:30:54',10,0),('1','176',257686,'DAILY SALES','2022-05-28','2022-05-28 06:04:11','2022-05-29 06:04:11','615',0.00,0.00,'615','2022-05-28 13:21:41','615','2022-05-28 13:22:09',10,0),('1','176',257687,'OPERATIONAL LOSS','2022-05-28','2022-05-28 13:22:46','2022-05-29 13:22:46','615',0.00,0.00,'615','2022-05-28 13:26:43','615','2022-05-28 13:27:02',10,0),('1','176',257688,'DAILY SALES','2022-05-29','2022-05-29 12:36:12','2022-05-30 12:36:12','615',0.00,0.00,'615','2022-05-29 19:33:56','615','2022-05-29 19:34:15',10,0),('1','176',257689,'DAILY SALES','2022-05-30','2022-05-30 06:30:59','2022-05-31 06:30:59','615',0.00,0.00,'615','2022-05-30 11:08:51','615','2022-05-30 11:09:07',10,0),('1','176',257690,'OPERATIONAL LOSS','2022-05-30','2022-05-30 11:09:53','2022-05-31 11:09:53','615',0.00,0.00,'615','2022-05-30 11:13:00','615','2022-05-30 11:13:15',10,0),('1','176',257691,'DAILY SALES','2022-05-31','2022-05-31 06:01:36','2022-06-01 06:01:36','615',0.00,0.00,'615','2022-05-31 06:07:31','615','2022-05-31 06:07:53',10,0),('1','176',257692,'DAILY SALES','2022-05-31','2022-05-31 06:09:20','2022-06-01 06:09:20','615',0.00,0.00,'615','2022-05-31 16:26:31','615','2022-05-31 16:27:33',10,0),('1','176',257693,'OPERATIONAL LOSS','2022-06-01','2022-06-01 10:34:46','2022-06-02 10:34:46','615',0.00,0.00,'615','2022-06-01 10:36:30','615','2022-06-01 10:36:46',10,0),('1','176',257694,'DAILY SALES','2022-06-03','2022-06-03 10:22:09','2022-06-04 10:22:09','615',0.00,0.00,'615','2022-06-03 19:39:21','615','2022-06-03 19:39:42',10,0),('1','176',257695,'DAILY SALES','2022-06-04','2022-06-04 06:03:47','2022-06-05 06:03:47','615',0.00,0.00,'615','2022-06-04 16:57:13','615','2022-06-04 16:59:07',10,0),('1','176',257696,'Operational loss','2022-06-05','2022-06-05 11:48:28','2022-06-06 11:48:28','615',0.00,0.00,'615','2022-06-05 11:51:33','615','2022-06-05 11:51:49',10,0),('1','176',257697,'DAILY SALES','2022-06-05','2022-06-05 11:52:18','2022-06-06 11:52:18','615',0.00,0.00,'615','2022-06-05 19:11:41','615','2022-06-05 19:13:06',10,0),('1','176',257698,'DAILY SALES','2022-06-06','2022-06-06 06:24:59','2022-06-07 06:24:59','615',0.00,0.00,'615','2022-06-06 19:12:05','615','2022-06-06 19:12:19',10,0),('1','176',257699,'DAILY SALES','2022-06-07','2022-06-07 06:29:38','2022-06-08 06:29:38','615',0.00,0.00,'615','2022-06-07 18:46:35','615','2022-06-07 18:47:08',10,0),('1','176',257700,'OPERATIONAL LOSS','2022-06-08','2022-06-08 06:41:46','2022-06-09 06:41:46','615',0.00,0.00,'615','2022-06-08 19:05:54','615','2022-06-08 19:07:18',10,0),('1','176',257701,'DAILY SALES','2022-06-09','2022-06-09 06:27:45','2022-06-10 06:27:45','615',0.00,0.00,'615','2022-06-09 13:49:45','615','2022-06-09 13:50:10',10,0),('1','176',257702,'Operational loss','2022-06-09','2022-06-09 13:51:29','2022-06-10 13:51:29','615',0.00,0.00,'615','2022-06-09 13:56:05','615','2022-06-09 13:56:22',10,0),('1','176',257703,'DAILY SALES','2022-06-10','2022-06-10 13:42:15','2022-06-11 13:42:15','615',0.00,0.00,'615','2022-06-10 18:20:56','615','2022-06-10 18:23:18',10,0),('1','176',257704,'DAILY SALES','2022-06-11','2022-06-11 07:27:16','2022-06-12 07:27:16','615',0.00,0.00,'615','2022-06-11 18:36:21','615','2022-06-11 18:36:39',10,0),('1','176',257705,'DAILY SALES','2022-06-12','2022-06-12 06:22:07','2022-06-13 06:22:07','615',0.00,0.00,'615','2022-06-12 18:52:52','615','2022-06-12 18:53:20',10,0),('1','176',257706,'DAILY SALES','2022-06-13','2022-06-13 07:45:01','2022-06-14 07:45:01','615',0.00,0.00,'615','2022-06-13 16:47:33','615','2022-06-13 16:47:50',10,0),('1','176',257707,'Operational loss','2022-06-14','2022-06-14 07:38:03','2022-06-15 07:38:03','615',0.00,0.00,'615','2022-06-14 07:41:42','615','2022-06-14 07:41:57',10,0),('1','176',257708,'DAILY SALES','2022-06-14','2022-06-14 07:42:31','2022-06-15 07:42:31','615',0.00,0.00,'615','2022-06-14 18:09:30','615','2022-06-14 18:09:46',10,0),('1','176',257709,'DAILY SALES','2022-06-15','2022-06-15 06:23:06','2022-06-16 06:23:06','615',0.00,0.00,'615','2022-06-15 18:41:27','615','2022-06-15 18:41:48',10,0),('1','176',257710,'DAILY SALES','2022-06-16','2022-06-16 06:48:03','2022-06-17 06:48:03','615',0.00,0.00,'615','2022-06-16 18:27:24','615','2022-06-16 18:27:45',10,0),('1','176',257711,'OPERATIONAL LOSS','2022-06-16','2022-06-16 18:29:32','2022-06-17 18:29:32','615',0.00,0.00,'615','2022-06-16 18:31:53','615','2022-06-16 18:32:09',10,0),('1','176',257712,'DAILY SALES','2022-06-18','2022-06-18 06:27:47','2022-06-19 06:27:47','615',0.00,0.00,'615','2022-06-18 19:21:49','615','2022-06-18 19:22:07',10,0),('1','176',257713,'DAILY SALES','2022-06-19','2022-06-19 06:41:16','2022-06-20 06:41:16','615',0.00,0.00,'615','2022-06-19 18:56:03','615','2022-06-19 18:56:22',10,0),('1','176',257714,'DAILY SALES','2022-06-20','2022-06-20 07:11:17','2022-06-21 07:11:17','615',0.00,0.00,'615','2022-06-20 14:44:21','615','2022-06-20 14:44:40',10,0),('1','176',257715,'OPERATIONAL LOSS','2022-06-20','2022-06-20 14:45:00','2022-06-21 14:45:00','615',0.00,0.00,'615','2022-06-20 14:47:51','615','2022-06-20 14:48:13',10,0),('1','176',257716,'DAILY SALES','2022-06-20','2022-06-20 14:49:34','2022-06-21 14:49:34','615',0.00,0.00,'615','2022-06-20 18:11:56','615','2022-06-20 18:12:21',10,0),('1','176',257717,'DAILY SALES','2022-06-21','2022-06-21 06:27:34','2022-06-22 06:27:34','615',0.00,0.00,'615','2022-06-21 19:15:38','615','2022-06-21 19:16:12',10,0),('1','176',257718,'DAILY SALES','2022-06-22','2022-06-22 06:33:07','2022-06-23 06:33:07','615',0.00,0.00,'615','2022-06-22 18:39:57','615','2022-06-22 18:40:19',10,0),('1','176',257719,'DAILY SALES','2022-06-23','2022-06-23 06:51:47','2022-06-24 06:51:47','615',0.00,0.00,'615','2022-06-23 17:14:02','615','2022-06-23 17:14:19',10,0),('1','176',257720,'DAILY SALES','2022-06-24','2022-06-24 07:13:29','2022-06-25 07:13:29','615',0.00,0.00,'615','2022-06-24 18:53:33','615','2022-06-24 18:53:48',10,0),('1','176',257721,'DAILY SALES','2022-06-25','2022-06-25 06:31:22','2022-06-26 06:31:22','615',0.00,0.00,'615','2022-06-25 18:30:00','615','2022-06-25 18:30:16',10,0),('1','176',257722,'DAILY SALES','2022-06-25','2022-06-25 18:35:43','2022-06-26 18:35:43','615',0.00,0.00,'615','2022-06-25 18:37:40','615','2022-06-25 18:37:56',10,0),('1','176',257723,'DAILY SALES','2022-06-26','2022-06-26 08:29:12','2022-06-27 08:29:12','615',0.00,0.00,'615','2022-06-26 18:36:20','615','2022-06-26 18:36:37',10,0),('1','176',257724,'DAILY SALES','2022-06-27','2022-06-27 07:04:37','2022-06-28 07:04:37','615',0.00,0.00,'615','2022-06-27 18:23:55','615','2022-06-27 18:25:40',10,0),('1','176',257725,'DAILY SALES','2022-06-28','2022-06-28 07:12:28','2022-06-29 07:12:28','615',0.00,0.00,'615','2022-06-28 18:54:25','615','2022-06-28 18:54:49',10,0),('1','176',257726,'DAILY SALES','2022-06-29','2022-06-29 07:14:48','2022-06-30 07:14:48','615',0.00,0.00,'615','2022-06-29 13:29:17','615','2022-06-29 13:29:36',10,0),('1','176',257727,'OPERATIONAL LOSS','2022-06-29','2022-06-29 13:29:55','2022-06-30 13:29:55','615',0.00,0.00,'615','2022-06-29 13:32:37','615','2022-06-29 13:32:50',10,0),('1','176',257728,'DAILY SALES','2022-06-29','2022-06-29 14:15:18','2022-06-30 14:15:18','615',0.00,0.00,'615','2022-06-29 19:19:48','615','2022-06-29 19:20:06',10,0),('1','176',257729,'DAILY SALES','2022-06-30','2022-06-30 07:03:39','2022-07-01 07:03:39','615',0.00,0.00,'615','2022-06-30 19:10:33','615','2022-06-30 19:10:49',10,0),('1','176',257730,'DAILY SALES','2022-07-01','2022-07-01 07:13:04','2022-07-02 07:13:04','615',0.00,0.00,'615','2022-07-01 11:03:30','615','2022-07-01 11:03:54',10,0),('1','176',257731,'OPERATIONAL LOSS','2022-07-01','2022-07-01 11:04:18','2022-07-02 11:04:18','615',0.00,0.00,'615','2022-07-01 11:07:01','615','2022-07-01 11:07:14',10,0),('1','176',257732,'DAILY SALES','2022-07-01','2022-07-01 11:07:32','2022-07-02 11:07:32','615',0.00,0.00,'615','2022-07-01 18:43:39','615','2022-07-01 18:43:58',10,0),('1','176',257733,'DAILY SALES','2022-07-02','2022-07-02 06:18:43','2022-07-03 06:18:43','615',0.00,0.00,'615','2022-07-02 15:27:30','615','2022-07-02 15:27:45',10,0),('1','176',257734,'OPERATIONAL LOSS','2022-07-02','2022-07-02 15:28:04','2022-07-03 15:28:04','615',0.00,0.00,'615','2022-07-02 15:31:04','615','2022-07-02 15:31:23',10,0),('1','176',257735,'DAILY SALES','2022-07-02','2022-07-02 15:35:29','2022-07-03 15:35:29','615',0.00,0.00,'615','2022-07-02 18:54:36','615','2022-07-02 18:58:52',10,0),('1','176',257736,'DAILY SALES','2022-07-03','2022-07-03 06:27:47','2022-07-04 06:27:47','615',0.00,0.00,'615','2022-07-03 18:38:53','615','2022-07-03 18:39:20',10,0),('1','176',257737,'DAILY SALES','2022-07-04','2022-07-04 07:00:08','2022-07-05 07:00:08','615',0.00,0.00,'615','2022-07-04 07:44:03','615','2022-07-04 07:44:34',10,0),('1','176',257738,'DAILY SALES','2022-07-04','2022-07-04 07:45:08','2022-07-05 07:45:08','615',0.00,0.00,'615','2022-07-04 19:05:29','615','2022-07-04 19:05:57',10,0),('1','176',257739,'DAILY SALES','2022-07-05','2022-07-05 07:12:54','2022-07-06 07:12:54','615',0.00,0.00,'615','2022-07-05 19:02:08','615','2022-07-05 19:02:31',10,0),('1','176',257740,'DAILY SALES','2022-07-06','2022-07-06 07:22:36','2022-07-07 07:22:36','615',0.00,0.00,'615','2022-07-06 11:56:30','615','2022-07-06 11:56:53',10,0),('1','176',257741,'DAILY SALES','2022-07-06','2022-07-06 12:02:38','2022-07-07 12:02:38','615',0.00,0.00,'615','2022-07-06 19:17:36','615','2022-07-06 19:20:40',10,0),('1','176',257742,'DAILY SALES','2022-07-07','2022-07-07 06:43:45','2022-07-08 06:43:45','615',0.00,0.00,'615','2022-07-07 19:27:57','615','2022-07-07 19:28:42',10,0),('1','176',257743,'DAILY SALES','2022-07-08','2022-07-08 06:48:07','2022-07-09 06:48:07','615',0.00,0.00,'615','2022-07-08 10:03:37','615','2022-07-08 10:04:07',10,0),('1','176',257744,'DAILY SALES','2022-07-08','2022-07-08 10:04:27','2022-07-09 10:04:27','615',0.00,0.00,'615','2022-07-08 18:58:56','615','2022-07-08 18:59:22',10,0),('1','176',257745,'DAILY SALES','2022-07-09','2022-07-09 11:32:00','2022-07-10 11:32:00','615',0.00,0.00,'615','2022-07-09 17:45:42','615','2022-07-09 17:46:05',10,0),('1','176',257746,'DAILY SALES','2022-07-10','2022-07-10 06:53:16','2022-07-11 06:53:16','615',0.00,0.00,'615','2022-07-10 08:40:20','615','2022-07-10 08:40:36',10,0),('1','176',257747,'Operational loss','2022-07-10','2022-07-10 08:40:56','2022-07-11 08:40:56','615',0.00,0.00,'615','2022-07-10 08:44:17','615','2022-07-10 08:44:35',10,0),('1','176',257748,'DAILY SALES','2022-07-10','2022-07-10 08:45:05','2022-07-11 08:45:05','615',0.00,0.00,'615','2022-07-10 18:35:13','615','2022-07-10 18:35:29',10,0),('1','176',257749,'DAILY SALES','2022-07-11','2022-07-11 06:36:44','2022-07-12 06:36:44','615',0.00,0.00,'615','2022-07-11 18:45:18','615','2022-07-11 18:45:40',10,0),('1','176',257750,'DAILY SALES','2022-07-12','2022-07-12 06:57:02','2022-07-13 06:57:02','615',0.00,0.00,'615','2022-07-12 18:46:30','615','2022-07-12 18:46:57',10,0),('1','176',257751,'DAILY SALES','2022-07-13','2022-07-13 06:56:18','2022-07-14 06:56:18','615',0.00,0.00,'615','2022-07-13 18:58:59','615','2022-07-13 18:59:16',10,0),('1','176',257752,'DAILY SALES','2022-07-14','2022-07-14 07:13:23','2022-07-15 07:13:23','615',0.00,0.00,'615','2022-07-14 18:43:46','615','2022-07-14 18:44:31',10,0),('1','176',257753,'DAILY SALES','2022-07-15','2022-07-15 07:03:18','2022-07-16 07:03:18','615',0.00,0.00,'615','2022-07-15 18:23:40','615','2022-07-15 18:24:00',10,0),('1','176',257754,'DAILY SALES','2022-07-16','2022-07-16 07:31:45','2022-07-17 07:31:45','615',0.00,0.00,'615','2022-07-16 17:46:11','615','2022-07-16 17:46:26',10,0),('1','176',257755,'DAILY SALES','2022-07-16','2022-07-16 17:49:36','2022-07-17 17:49:36','615',0.00,0.00,'615','2022-07-16 17:55:39','615','2022-07-16 17:55:56',10,0),('1','176',257756,'DAILY SALES','2022-07-17','2022-07-17 12:10:02','2022-07-18 12:10:02','615',0.00,0.00,'615','2022-07-17 18:25:42','615','2022-07-17 18:26:01',10,0),('1','176',257757,'DAILY SALES','2022-07-18','2022-07-18 07:36:24','2022-07-19 07:36:24','615',0.00,0.00,'615','2022-07-18 18:42:20','615','2022-07-18 18:42:41',10,0),('1','176',257758,'DAILY SALES','2022-07-19','2022-07-19 06:40:09','2022-07-20 06:40:09','615',0.00,0.00,'615','2022-07-19 19:00:40','615','2022-07-19 19:00:57',10,0),('1','176',257759,'DAILY SALES','2022-07-20','2022-07-20 06:55:52','2022-07-21 06:55:52','615',0.00,0.00,'615','2022-07-20 17:51:01','615','2022-07-20 17:52:07',10,0),('1','176',257760,'OPERATIONAL LOSS','2022-07-20','2022-07-20 17:52:26','2022-07-21 17:52:26','615',0.00,0.00,'615','2022-07-20 17:54:35','615','2022-07-20 17:54:50',10,0),('1','176',257761,'DAILY SALES','2022-07-21','2022-07-21 07:17:22','2022-07-22 07:17:22','615',0.00,0.00,'615','2022-07-21 19:10:35','615','2022-07-21 19:10:59',10,0),('1','176',257762,'DAILY SALES','2022-07-22','2022-07-22 07:09:53','2022-07-23 07:09:53','615',0.00,0.00,'615','2022-07-22 18:56:32','615','2022-07-22 18:57:18',10,0),('1','176',257763,'DAILY SALES','2022-07-23','2022-07-23 06:37:37','2022-07-24 06:37:37','615',0.00,0.00,'615','2022-07-23 12:10:12','615','2022-07-23 12:10:44',10,0),('1','176',257764,'OPERATIONAL LOSS','2022-07-23','2022-07-23 12:11:04','2022-07-24 12:11:04','615',0.00,0.00,'615','2022-07-23 12:15:47','615','2022-07-23 12:16:00',10,0),('1','176',257765,'DAILY SALES','2022-07-23','2022-07-23 12:17:12','2022-07-24 12:17:12','615',0.00,0.00,'615','2022-07-23 19:22:20','615','2022-07-23 19:22:36',10,0),('1','176',257766,'DAILY SALES','2022-07-24','2022-07-24 06:54:50','2022-07-25 06:54:50','615',0.00,0.00,'615','2022-07-24 20:02:26','615','2022-07-24 20:03:00',10,0),('1','176',257767,'DAILY SALES','2022-07-25','2022-07-25 07:56:27','2022-07-26 07:56:27','615',0.00,0.00,'615','2022-07-25 10:54:00','615','2022-07-25 10:54:15',10,0),('1','176',257768,'DAILY SALES','2022-07-25','2022-07-25 10:54:35','2022-07-26 10:54:35','615',0.00,0.00,'615','2022-07-25 19:18:03','615','2022-07-25 19:18:32',10,0),('1','176',257769,'DAILY SALES','2022-07-26','2022-07-26 06:34:38','2022-07-27 06:34:38','615',0.00,0.00,'615','2022-07-26 19:21:06','615','2022-07-26 19:21:30',10,0),('1','176',257770,'DAILY SALES','2022-07-27','2022-07-27 08:31:14','2022-07-28 08:31:14','615',0.00,0.00,'615','2022-07-27 08:43:38','615','2022-07-27 08:44:15',10,0),('1','176',257771,'DAILY SALES','2022-07-27','2022-07-27 08:44:37','2022-07-28 08:44:37','615',0.00,0.00,'615','2022-07-27 19:30:38','615','2022-07-27 19:31:05',10,0),('1','176',257772,'DAILY SALES','2022-07-28','2022-07-28 06:53:06','2022-07-29 06:53:06','615',0.00,0.00,'615','2022-07-28 13:35:52','615','2022-07-28 13:36:12',10,0),('1','176',257773,'DAILY SALES','2022-07-28','2022-07-28 13:37:06','2022-07-29 13:37:06','615',0.00,0.00,'615','2022-07-28 19:17:12','615','2022-07-28 19:18:19',10,0),('1','176',257774,'DAILY SALES','2022-07-29','2022-07-29 06:42:07','2022-07-30 06:42:07','615',0.00,0.00,'615','2022-07-29 19:18:20','615','2022-07-29 19:18:55',10,0),('1','176',257775,'DAILY SALES','2022-07-30','2022-07-30 06:36:42','2022-07-31 06:36:42','615',0.00,0.00,'615','2022-07-30 10:08:14','615','2022-07-30 10:08:34',10,0),('1','176',257776,'DAILY SALES','2022-07-30','2022-07-30 10:09:05','2022-07-31 10:09:05','615',0.00,0.00,'615','2022-07-30 18:24:06','615','2022-07-30 18:25:13',10,0),('1','176',257777,'DAILY SALES','2022-07-31','2022-07-31 06:34:23','2022-08-01 06:34:23','615',0.00,0.00,'615','2022-07-31 13:51:54','615','2022-07-31 13:52:12',10,0),('1','176',257778,'OPERATIONAL LOSS','2022-07-31','2022-07-31 13:53:07','2022-08-01 13:53:07','615',0.00,0.00,'615','2022-07-31 13:56:49','615','2022-07-31 13:57:11',10,0),('1','176',257779,'DAILY SALES','2022-07-31','2022-07-31 14:50:19','2022-08-01 14:50:19','615',0.00,0.00,'615','2022-07-31 19:08:39','615','2022-07-31 19:08:56',10,0),('1','176',257780,'DAILY SALES','2022-08-01','2022-08-01 06:55:27','2022-08-02 06:55:27','615',0.00,0.00,'615','2022-08-01 21:23:11','615','2022-08-01 21:23:32',10,0),('1','176',257781,'DAILY SALES','2022-08-02','2022-08-02 07:48:17','2022-08-03 07:48:17','615',0.00,0.00,'615','2022-08-02 13:38:25','615','2022-08-02 13:38:48',10,0),('1','176',257782,'DAILY SALES','2022-08-03','2022-08-03 07:56:52','2022-08-04 07:56:52','615',0.00,0.00,'615','2022-08-03 18:18:57','615','2022-08-03 18:19:14',10,0),('1','176',257783,'DAILY SALES','2022-08-04','2022-08-04 07:03:07','2022-08-05 07:03:07','615',0.00,0.00,'615','2022-08-04 19:03:56','615','2022-08-04 19:04:20',10,0),('1','176',257784,'DAILY SALES','2022-08-05','2022-08-05 07:27:42','2022-08-06 07:27:42','615',0.00,0.00,'615','2022-08-05 10:32:39','615','2022-08-05 10:33:22',10,0),('1','176',257785,'OPERATIONAL LOSS','2022-08-05','2022-08-05 10:40:09','2022-08-06 10:40:09','615',0.00,0.00,'615','2022-08-05 10:41:49','615','2022-08-05 10:42:04',10,0),('1','176',257786,'DAILY SALES','2022-08-05','2022-08-05 14:17:09','2022-08-06 14:17:09','615',0.00,0.00,'615','2022-08-05 18:45:32','615','2022-08-05 18:45:48',10,0),('1','176',257787,'DAILY SALES','2022-08-06','2022-08-06 06:34:51','2022-08-07 06:34:51','615',0.00,0.00,'615','2022-08-06 17:38:14','615','2022-08-06 17:38:32',10,0),('1','176',257788,'DAILY SALES','2022-08-07','2022-08-07 06:32:43','2022-08-08 06:32:43','615',0.00,0.00,'615','2022-08-07 18:41:21','615','2022-08-07 18:49:48',10,0),('1','176',257789,'DAILY SALES','2022-08-08','2022-08-08 06:33:39','2022-08-09 06:33:39','615',0.00,0.00,'615','2022-08-08 18:25:30','615','2022-08-08 18:25:52',10,0),('1','176',257790,'DAILY SALES','2022-08-09','2022-08-09 06:11:46','2022-08-10 06:11:46','615',0.00,0.00,'615','2022-08-09 18:47:57','615','2022-08-09 18:48:15',10,0),('1','176',257791,'DAILY SALES','2022-08-10','2022-08-10 06:53:04','2022-08-11 06:53:04','615',0.00,0.00,'615','2022-08-10 17:50:51','615','2022-08-10 17:53:08',10,0),('1','176',257792,'DAILY SALES','2022-08-11','2022-08-11 08:37:30','2022-08-12 08:37:30','615',0.00,0.00,'615','2022-08-11 18:30:16','615','2022-08-11 18:30:39',10,0),('1','176',257793,'DAILY SALES','2022-08-12','2022-08-12 07:06:54','2022-08-13 07:06:54','615',0.00,0.00,'615','2022-08-13 05:03:08','615','2022-08-13 05:03:28',10,0),('1','176',257794,'DAILY SALES','2022-08-13','2022-08-13 07:35:48','2022-08-14 07:35:48','615',0.00,0.00,'615','2022-08-13 22:38:06','615','2022-08-13 22:39:06',10,0),('1','176',257795,'DAILY SALES','2022-08-14','2022-08-14 06:56:48','2022-08-15 06:56:48','615',0.00,0.00,'615','2022-08-15 07:43:24','615','2022-08-15 07:44:00',10,0),('1','176',257796,'DAILY SALES','2022-08-15','2022-08-15 12:46:57','2022-08-16 12:46:57','615',0.00,0.00,'615','2022-08-15 18:23:10','615','2022-08-15 18:23:32',10,0),('1','176',257797,'DAILY shift','2022-08-16','2022-08-16 07:22:31','2022-08-17 07:22:31','615',0.00,0.00,'615','2022-08-16 19:46:55','615','2022-08-16 19:47:16',10,0),('1','176',257798,'DAILY shift','2022-08-17','2022-08-17 06:49:26','2022-08-18 06:49:26','615',0.00,0.00,'615','2022-08-17 09:42:18','615','2022-08-17 09:42:39',10,0),('1','176',257799,'DAILY SALES','2022-08-17','2022-08-17 10:19:33','2022-08-18 10:19:33','615',0.00,0.00,'615','2022-08-17 21:13:49','615','2022-08-17 21:14:09',10,0),('1','176',257800,'DAILY SALES','2022-08-18','2022-08-18 07:11:48','2022-08-19 07:11:48','615',0.00,0.00,'615','2022-08-18 20:16:50','615','2022-08-18 20:17:26',10,0),('1','176',257801,'DAILY SALES','2022-08-19','2022-08-19 07:32:19','2022-08-20 07:32:19','615',0.00,0.00,'615','2022-08-19 17:36:51','615','2022-08-19 17:37:11',10,0),('1','176',257802,'DAILY SALES','2022-08-19','2022-08-19 17:39:58','2022-08-20 17:39:58','615',0.00,0.00,'615','2022-08-19 17:43:58','615','2022-08-19 17:44:16',10,0),('1','176',257803,'DAILY shift','2022-08-20','2022-08-20 07:08:38','2022-08-21 07:08:38','615',0.00,0.00,'615','2022-08-20 18:23:58','615','2022-08-20 18:24:17',10,0),('1','176',257804,'DAILY SALES','2022-08-21','2022-08-21 08:01:03','2022-08-22 08:01:03','615',0.00,0.00,'615','2022-08-21 21:48:38','615','2022-08-21 21:49:03',10,0),('1','176',257805,'DAILY SALES','2022-08-22','2022-08-22 07:51:52','2022-08-23 07:51:52','615',0.00,0.00,'615','2022-08-22 15:05:58','615','2022-08-22 15:06:17',10,0),('1','176',257806,'DAILY SALES','2022-08-22','2022-08-22 15:07:02','2022-08-23 15:07:02','615',0.00,0.00,'615','2022-08-22 21:59:39','615','2022-08-22 21:59:58',10,0),('1','176',257807,'DAILY SALES','2022-08-23','2022-08-23 07:08:15','2022-08-24 07:08:15','615',0.00,0.00,'615','2022-08-23 22:07:33','615','2022-08-23 22:07:52',10,0),('1','176',257808,'DAILY SALES','2022-08-24','2022-08-24 07:06:55','2022-08-25 07:06:55','615',0.00,0.00,'615','2022-08-25 07:29:36','615','2022-08-25 07:30:39',10,0),('1','176',257809,'DAILY SALES','2022-08-25','2022-08-25 07:31:03','2022-08-26 07:31:03','615',0.00,0.00,'615','2022-08-25 15:57:57','615','2022-08-25 15:58:19',10,0),('1','176',257810,'DAILY SALES','2022-08-25','2022-08-25 16:47:14','2022-08-26 16:47:14','615',0.00,0.00,'615','2022-08-25 16:51:35','615','2022-08-25 16:52:00',10,0),('1','176',257811,'DAILY SALES','2022-08-28','2022-08-28 14:44:23','2022-08-29 14:44:23','615',0.00,0.00,'615','2022-08-28 19:16:03','615','2022-08-28 19:16:22',10,0),('1','176',257812,'DAILY SALES','2022-08-29','2022-08-29 07:29:55','2022-08-30 07:29:55','615',0.00,0.00,'615','2022-08-29 20:26:25','615','2022-08-29 20:26:47',10,0),('1','176',257813,'DAILY SALES','2022-08-30','2022-08-30 07:50:46','2022-08-31 07:50:46','615',0.00,0.00,'615','2022-08-30 19:54:19','615','2022-08-30 19:54:44',10,0),('1','176',257814,'DAILY SALES','2022-08-31','2022-08-31 07:19:04','2022-09-01 07:19:04','615',0.00,0.00,'615','2022-08-31 16:13:58','615','2022-08-31 16:14:17',10,0),('1','176',257815,'DAILY SALES','2022-08-31','2022-08-31 16:16:06','2022-09-01 16:16:06','615',0.00,0.00,'615','2022-08-31 16:19:45','615','2022-08-31 16:20:04',10,0),('1','176',257816,'DAILY SALES','2022-09-01','2022-09-01 11:39:28','2022-09-02 11:39:28','615',0.00,0.00,'615','2022-09-02 07:52:25','615','2022-09-02 07:52:47',10,0),('1','176',257817,'DAILY SALES','2022-09-02','2022-09-02 07:53:16','2022-09-03 07:53:16','615',0.00,0.00,'615','2022-09-02 19:27:26','615','2022-09-02 19:28:02',10,0),('1','176',257818,'DAILY SALES','2022-09-03','2022-09-03 07:25:57','2022-09-04 07:25:57','615',0.00,0.00,'615','2022-09-03 19:27:33','615','2022-09-03 19:28:06',10,0),('1','176',257819,'DAILY SALES','2022-09-04','2022-09-04 07:24:52','2022-09-05 07:24:52','615',0.00,0.00,'615','2022-09-04 18:26:44','615','2022-09-04 18:27:07',10,0),('1','176',257820,'DAILY SALES','2022-09-05','2022-09-05 07:39:05','2022-09-06 07:39:05','615',0.00,0.00,'615','2022-09-05 19:59:25','615','2022-09-05 20:00:08',10,0),('1','176',257821,'DAILY SALES','2022-09-06','2022-09-06 07:21:25','2022-09-07 07:21:25','615',0.00,0.00,'615','2022-09-06 19:21:43','615','2022-09-06 19:21:59',10,0),('1','176',257822,'DAILY SALES','2022-09-07','2022-09-07 07:47:49','2022-09-08 07:47:49','615',0.00,0.00,'615','2022-09-07 19:09:17','615','2022-09-07 19:09:33',10,0),('1','176',257823,'DAILY SALES','2022-09-08','2022-09-08 07:06:05','2022-09-09 07:06:05','615',0.00,0.00,'615','2022-09-08 18:07:29','615','2022-09-08 18:08:21',10,0),('1','176',257824,'DAILY SALES','2022-09-09','2022-09-09 07:29:05','2022-09-10 07:29:05','615',0.00,0.00,'615','2022-09-09 19:02:22','615','2022-09-09 19:02:38',10,0),('1','176',257825,'DAILY SALES','2022-09-10','2022-09-10 06:48:32','2022-09-11 06:48:32','615',0.00,0.00,'615','2022-09-10 18:57:30','615','2022-09-10 18:57:50',10,0),('1','176',257826,'Daily Shift ','2022-09-11','2022-09-11 07:30:41','2022-09-12 07:30:41','615',0.00,0.00,'615','2022-09-11 19:25:00','615','2022-09-11 19:25:19',10,0),('1','176',257827,'DAILY SALES','2022-09-12','2022-09-12 07:14:47','2022-09-13 07:14:47','615',0.00,0.00,'615','2022-09-12 19:16:42','615','2022-09-12 19:17:19',10,0),('1','176',257828,'Daily Shift ','2022-09-13','2022-09-13 06:59:43','2022-09-14 06:59:43','615',0.00,0.00,'615','2022-09-13 19:31:40','615','2022-09-13 19:31:59',10,0),('1','176',257829,'DAILY SALES','2022-09-14','2022-09-14 07:32:19','2022-09-15 07:32:19','615',0.00,0.00,'615','2022-09-14 19:41:43','615','2022-09-14 19:42:09',10,0),('1','176',257830,'Daily Shift ','2022-09-15','2022-09-15 07:24:10','2022-09-16 07:24:10','615',0.00,0.00,'615','2022-09-15 19:29:46','615','2022-09-15 19:30:04',10,0),('1','176',257831,'DAILY SALES','2022-09-16','2022-09-16 08:04:12','2022-09-17 08:04:12','615',0.00,0.00,'615','2022-09-16 18:20:16','615','2022-09-16 18:20:33',10,0),('1','176',257832,'DAILY SALES','2022-09-17','2022-09-17 09:21:24','2022-09-18 09:21:24','615',0.00,0.00,'615','2022-09-17 09:37:29','615','2022-09-17 09:37:42',10,0),('1','176',257833,'DAILY SALES','2022-09-17','2022-09-17 19:44:57','2022-09-18 19:44:57','615',0.00,0.00,'615','2022-09-17 19:45:57','615','2022-09-17 19:46:16',10,0),('1','176',257834,'DAILY SALES','2022-09-18','2022-09-18 09:36:01','2022-09-19 09:36:01','615',0.00,0.00,'615','2022-09-18 19:28:17','615','2022-09-18 19:28:34',10,0),('1','176',257835,'DAILY SALES','2022-09-19','2022-09-19 09:08:04','2022-09-20 09:08:04','615',0.00,0.00,'615','2022-09-19 18:52:55','615','2022-09-19 18:58:01',10,0),('1','176',257836,'DAILY SALES','2022-09-20','2022-09-20 07:25:23','2022-09-21 07:25:23','615',0.00,0.00,'615','2022-09-20 19:04:52','615','2022-09-20 19:05:10',10,0),('1','176',257837,'DAILY SALES','2022-09-21','2022-09-21 07:57:12','2022-09-22 07:57:12','615',0.00,0.00,'615','2022-09-21 19:57:01','615','2022-09-21 19:57:51',10,0),('1','176',257838,'Daily Shift ','2022-09-22','2022-09-22 07:30:55','2022-09-23 07:30:55','615',0.00,0.00,'615','2022-09-22 19:01:48','615','2022-09-22 19:02:02',10,0),('1','176',257839,'DAILY SALES','2022-09-23','2022-09-23 06:56:16','2022-09-24 06:56:16','615',0.00,0.00,'615','2022-09-23 07:50:36','615','2022-09-23 07:50:55',10,0),('1','176',257840,'DAILY SALES','2022-09-23','2022-09-23 07:55:25','2022-09-24 07:55:25','615',0.00,0.00,'615','2022-09-23 19:46:54','615','2022-09-23 19:47:10',10,0),('1','176',257841,'DAILY SALES','2022-09-24','2022-09-24 07:41:27','2022-09-25 07:41:27','615',0.00,0.00,'615','2022-09-24 20:58:03','615','2022-09-24 20:58:20',10,0),('1','176',257842,'DAILY SALES','2022-09-25','2022-09-25 07:31:46','2022-09-26 07:31:46','615',0.00,0.00,'615','2022-09-25 19:14:18','615','2022-09-25 19:14:43',10,0),('1','176',257843,'DAILY SALES','2022-09-26','2022-09-26 06:41:03','2022-09-27 06:41:03','615',0.00,0.00,'615','2022-09-26 19:07:08','615','2022-09-26 19:07:21',10,0),('1','176',257844,'Daily Shift ','2022-09-27','2022-09-27 07:24:03','2022-09-28 07:24:03','615',0.00,0.00,'615','2022-09-28 07:46:50','615','2022-09-28 07:47:07',10,0),('1','176',257845,'DAILY SALES','2022-09-28','2022-09-28 07:47:29','2022-09-29 07:47:29','615',0.00,0.00,'615','2022-09-28 10:43:07','615','2022-09-28 10:43:22',10,0),('1','176',257846,'DAILY SALES','2022-09-28','2022-09-28 10:46:06','2022-09-29 10:46:06','615',0.00,0.00,'615','2022-09-28 21:37:17','615','2022-09-28 21:37:37',10,0),('1','176',257847,'DAILY SALES','2022-09-29','2022-09-29 07:04:05','2022-09-30 07:04:05','615',0.00,0.00,'615','2022-09-29 20:10:57','615','2022-09-29 20:11:13',10,0),('1','176',257848,'DAILY SALES','2022-09-30','2022-09-30 07:05:14','2022-10-01 07:05:14','615',0.00,0.00,'615','2022-10-01 08:20:46','615','2022-10-01 08:21:02',10,0),('1','176',257849,'DAILY SALES','2022-10-01','2022-10-01 08:21:28','2022-10-02 08:21:28','615',0.00,0.00,'615','2022-10-01 17:23:22','615','2022-10-01 17:23:40',10,0),('1','176',257850,'DAILY SALES','2022-10-02','2022-10-02 08:39:17','2022-10-03 08:39:17','615',0.00,0.00,'615','2022-10-03 08:02:22','615','2022-10-03 08:02:40',10,0),('1','176',257851,'DAILY SALES','2022-10-03','2022-10-03 08:03:04','2022-10-04 08:03:04','615',0.00,0.00,'615','2022-10-03 19:19:23','615','2022-10-03 19:19:38',10,0),('1','176',257852,'DAILY SALES','2022-10-04','2022-10-04 09:05:15','2022-10-05 09:05:15','615',0.00,0.00,'615','2022-10-04 19:28:52','615','2022-10-04 19:29:06',10,0),('1','176',257853,'Daily Shift ','2022-10-05','2022-10-05 07:56:08','2022-10-06 07:56:08','615',0.00,0.00,'615','2022-10-05 12:59:31','615','2022-10-05 12:59:47',10,0),('1','176',257854,'DAILY SALES','2022-10-05','2022-10-05 13:01:34','2022-10-06 13:01:34','615',0.00,0.00,'615','2022-10-06 16:50:44','615','2022-10-06 16:51:07',10,0),('1','176',257855,'DAILY SALES','2022-10-07','2022-10-07 07:42:21','2022-10-08 07:42:21','615',0.00,0.00,'615','2022-10-07 19:28:15','615','2022-10-07 19:28:34',10,0),('1','176',257856,'Daily Shift ','2022-10-08','2022-10-08 07:21:00','2022-10-09 07:21:00','615',0.00,0.00,'615','2022-10-09 07:27:02','615','2022-10-09 07:27:20',10,0),('1','176',257857,'DAILY SALES','2022-10-09','2022-10-09 07:28:02','2022-10-10 07:28:02','615',0.00,0.00,'615','2022-10-09 18:05:25','615','2022-10-09 18:05:57',10,0),('1','176',257858,'DAILY SALES','2022-10-12','2022-10-12 10:52:37','2022-10-13 10:52:37','615',0.00,0.00,'615','2022-10-12 18:52:09','615','2022-10-12 18:52:35',10,0),('1','176',257859,'DAILY SALES','2022-10-13','2022-10-13 07:15:32','2022-10-14 07:15:32','615',0.00,0.00,'615','2022-10-13 19:19:05','615','2022-10-13 19:19:26',10,0),('1','176',257860,'DAILY SALES','2022-10-14','2022-10-14 08:20:14','2022-10-15 08:20:14','615',0.00,0.00,'615','2022-10-14 19:04:42','615','2022-10-14 19:05:03',10,0),('1','176',257861,'DAILY SALES','2022-10-15','2022-10-15 07:23:26','2022-10-16 07:23:26','615',0.00,0.00,'615','2022-10-15 22:09:11','615','2022-10-15 22:09:30',10,0),('1','176',257862,'Daily Shift ','2022-10-16','2022-10-16 07:16:19','2022-10-17 07:16:19','615',0.00,0.00,'615','2022-10-16 10:59:44','615','2022-10-16 10:59:59',10,0),('1','176',257863,'DAILY SALES','2022-10-16','2022-10-16 15:26:37','2022-10-17 15:26:37','615',0.00,0.00,'615','2022-10-16 19:41:28','615','2022-10-16 19:41:47',10,0),('1','176',257864,'DAILY SALES','2022-10-17','2022-10-17 07:16:32','2022-10-18 07:16:32','615',0.00,0.00,'615','2022-10-17 19:12:05','615','2022-10-17 19:12:38',10,0),('1','176',257865,'DAILY SALES','2022-10-18','2022-10-18 07:05:48','2022-10-19 07:05:48','615',0.00,0.00,'615','2022-10-18 20:10:40','615','2022-10-18 20:11:04',10,0),('1','176',257866,'DAILY SALES','2022-10-19','2022-10-19 07:32:19','2022-10-20 07:32:19','615',0.00,0.00,'615','2022-10-19 21:01:58','615','2022-10-19 21:02:15',10,0),('1','176',257867,'DAILY SALES','2022-10-20','2022-10-20 07:19:31','2022-10-21 07:19:31','615',0.00,0.00,'615','2022-10-20 19:18:26','615','2022-10-20 19:18:43',10,0),('1','176',257868,'DAILY SALES','2022-10-21','2022-10-21 07:29:43','2022-10-22 07:29:43','615',0.00,0.00,'615','2022-10-21 19:30:08','615','2022-10-21 19:30:29',10,0),('1','176',257869,'DAILY SALES','2022-10-22','2022-10-22 07:22:25','2022-10-23 07:22:25','615',0.00,0.00,'615','2022-10-22 19:20:56','615','2022-10-22 19:21:16',10,0),('1','176',257870,'DAILY SALES','2022-10-23','2022-10-23 07:23:01','2022-10-24 07:23:01','615',0.00,0.00,'615','2022-10-23 18:55:37','615','2022-10-23 18:55:52',10,0),('1','176',257871,'Daily Shift ','2022-10-24','2022-10-24 07:42:57','2022-10-25 07:42:57','615',0.00,0.00,'615','2022-10-24 16:52:56','615','2022-10-24 16:53:19',10,0),('1','176',257872,'DAILY SALES','2022-10-24','2022-10-24 18:18:06','2022-10-25 18:18:06','615',0.00,0.00,'615','2022-10-24 18:21:43','615','2022-10-24 18:22:00',10,0),('1','176',257873,'DAILY SALES','2022-10-25','2022-10-25 10:52:08','2022-10-26 10:52:08','615',0.00,0.00,'615','2022-10-25 19:47:01','615','2022-10-25 19:47:17',10,0),('1','176',257874,'DAILY SALES','2022-10-26','2022-10-26 07:30:24','2022-10-27 07:30:24','615',0.00,0.00,'615','2022-10-26 20:49:56','615','2022-10-26 20:50:10',10,0),('1','176',257875,'DAILY SALES','2022-10-27','2022-10-27 06:48:01','2022-10-28 06:48:01','615',0.00,0.00,'615','2022-10-27 19:18:37','615','2022-10-27 19:18:52',10,0),('1','176',257876,'DAILY SALES','2022-10-28','2022-10-28 06:58:09','2022-10-29 06:58:09','615',0.00,0.00,'615','2022-10-28 18:40:09','615','2022-10-28 18:40:49',10,0),('1','176',257877,'DAILY SALES','2022-10-29','2022-10-29 07:13:31','2022-10-30 07:13:31','615',0.00,0.00,'615','2022-10-29 19:53:06','615','2022-10-29 19:53:19',10,0),('1','176',257878,'DAILY SALES','2022-10-30','2022-10-30 07:32:01','2022-10-31 07:32:01','615',0.00,0.00,'615','2022-10-30 19:17:06','615','2022-10-30 19:17:22',10,0),('1','176',257879,'DAILY SALES','2022-10-31','2022-10-31 06:59:22','2022-11-01 06:59:22','615',0.00,0.00,'615','2022-10-31 19:44:08','615','2022-10-31 19:44:34',10,0),('1','176',257880,'DAILY SALES','2022-11-05','2022-11-05 07:59:42','2022-11-06 07:59:42','615',0.00,0.00,'615','2022-11-05 19:24:56','615','2022-11-05 19:25:13',10,0),('1','176',257881,'DAILY SALES','2022-11-06','2022-11-06 07:54:19','2022-11-07 07:54:19','615',0.00,0.00,'615','2022-11-06 19:04:37','615','2022-11-06 19:04:54',10,0),('1','176',257882,'DAILY SALES','2022-11-07','2022-11-07 08:17:27','2022-11-08 08:17:27','615',0.00,0.00,'615','2022-11-08 06:47:27','615','2022-11-08 06:47:42',10,0),('1','176',257883,'DAILY SALES','2022-11-08','2022-11-08 06:49:03','2022-11-09 06:49:03','615',0.00,0.00,'615','2022-11-08 19:00:21','615','2022-11-08 19:00:38',10,0),('1','176',257884,'DAILY SALES','2022-11-09','2022-11-09 07:14:20','2022-11-10 07:14:20','615',0.00,0.00,'615','2022-11-09 19:37:43','615','2022-11-09 19:37:58',10,0),('1','176',257885,'DAILY SALES','2022-11-10','2022-11-10 07:00:32','2022-11-11 07:00:32','615',0.00,0.00,'615','2022-11-10 18:52:38','615','2022-11-10 18:52:58',10,0),('1','176',257886,'DAILY SALES','2022-11-11','2022-11-11 07:45:53','2022-11-12 07:45:53','615',0.00,0.00,'615','2022-11-11 18:44:02','615','2022-11-11 18:44:20',10,0),('1','176',257887,'DAILY SALES','2022-11-12','2022-11-12 07:31:13','2022-11-13 07:31:13','615',0.00,0.00,'615','2022-11-13 06:25:02','615','2022-11-13 06:25:22',10,0),('1','176',257888,'DAILY SALES','2022-11-13','2022-11-13 08:09:55','2022-11-14 08:09:55','615',0.00,0.00,'615','2022-11-14 07:13:26','615','2022-11-14 07:13:43',10,0),('1','176',257889,'DAILY SALES','2022-11-14','2022-11-14 07:14:12','2022-11-15 07:14:12','615',0.00,0.00,'615','2022-11-14 20:10:36','615','2022-11-14 20:10:50',10,0),('1','176',257890,'DAILY SALES','2022-11-15','2022-11-15 07:39:12','2022-11-16 07:39:12','615',0.00,0.00,'615','2022-11-15 18:34:38','615','2022-11-15 18:34:52',10,0),('1','176',257891,'DAILY SALES','2022-11-16','2022-11-16 07:11:40','2022-11-17 07:11:40','615',0.00,0.00,'615','2022-11-16 20:02:10','615','2022-11-16 20:02:26',10,0),('1','176',257892,'DAILY SALES','2022-11-17','2022-11-17 07:00:01','2022-11-18 07:00:01','615',0.00,0.00,'615','2022-11-17 22:13:41','615','2022-11-17 22:13:56',10,0),('1','176',257893,'DAILY SALES','2022-11-18','2022-11-18 06:52:09','2022-11-19 06:52:09','615',0.00,0.00,'615','2022-11-18 18:42:27','615','2022-11-18 18:42:40',10,0),('1','176',257894,'DAILY SALES','2022-11-19','2022-11-19 07:22:19','2022-11-20 07:22:19','615',0.00,0.00,'615','2022-11-19 19:40:27','615','2022-11-19 19:40:44',10,0),('1','176',257895,'DAILY SALES','2022-11-20','2022-11-20 08:27:32','2022-11-21 08:27:32','615',0.00,0.00,'615','2022-11-20 21:03:14','615','2022-11-20 21:03:29',10,0),('1','176',257896,'DAILY SALES','2022-11-21','2022-11-21 06:49:25','2022-11-22 06:49:25','615',0.00,0.00,'615','2022-11-21 19:52:30','615','2022-11-21 19:52:45',10,0),('1','176',257897,'DAILY SALES','2022-11-22','2022-11-22 07:29:52','2022-11-23 07:29:52','615',0.00,0.00,'615','2022-11-23 06:52:06','615','2022-11-23 06:52:22',10,0),('1','176',257898,'DAILY SHIFT','2022-11-23','2022-11-23 06:52:51','2022-11-24 06:52:51','615',0.00,0.00,'615','2022-11-23 19:03:28','615','2022-11-23 19:03:44',10,0),('1','176',257899,'DAILY SHIFT','2022-11-24','2022-11-24 06:56:02','2022-11-25 06:56:02','615',0.00,0.00,'615','2022-11-24 22:22:50','615','2022-11-24 22:23:06',10,0),('1','176',257900,'DAILY SHIFT','2022-11-25','2022-11-25 07:35:04','2022-11-26 07:35:04','615',0.00,0.00,'615','2022-11-25 17:30:43','615','2022-11-25 17:31:03',10,0),('1','176',257901,'DAILY SHIFT','2022-11-25','2022-11-25 17:31:22','2022-11-26 17:31:22','615',0.00,0.00,'615','2022-11-25 19:05:50','615','2022-11-25 19:06:08',10,0),('1','176',257902,'DAILY SHIFT','2022-11-26','2022-11-26 07:44:05','2022-11-27 07:44:05','615',0.00,0.00,'615','2022-11-27 06:53:58','615','2022-11-27 06:54:15',10,0),('1','176',257903,'DAILY SALES','2022-11-27','2022-11-27 06:55:08','2022-11-28 06:55:08','615',0.00,0.00,'615','2022-11-27 18:37:55','615','2022-11-27 18:39:14',10,0),('1','176',257904,'DAILY SALES','2022-11-28','2022-11-28 07:55:42','2022-11-29 07:55:42','615',0.00,0.00,'615','2022-11-28 17:09:45','615','2022-11-28 17:10:04',10,0),('1','176',257905,'DAILY SALES','2022-11-28','2022-11-28 17:10:32','2022-11-29 17:10:32','615',0.00,0.00,'615','2022-11-29 06:39:27','615','2022-11-29 06:39:47',10,0),('1','176',257906,'DAILY SALES','2022-11-29','2022-11-29 07:24:14','2022-11-30 07:24:14','615',0.00,0.00,'615','2022-11-29 23:52:17','615','2022-11-29 23:52:38',10,0),('1','176',257907,'DAILY SALES','2022-11-30','2022-11-30 07:05:26','2022-12-01 07:05:26','615',0.00,0.00,'615','2022-11-30 20:47:25','615','2022-11-30 20:47:39',10,0),('1','176',257908,'DAILY SALES','2022-12-01','2022-12-01 07:33:47','2022-12-02 07:33:47','615',0.00,0.00,'615','2022-12-01 17:59:08','615','2022-12-01 17:59:25',10,0),('1','176',257909,'DAILY SALES','2022-12-01','2022-12-01 18:16:04','2022-12-02 18:16:04','615',0.00,0.00,'615','2022-12-01 19:48:17','615','2022-12-01 19:48:35',10,0),('1','176',257910,'DAILY SALES','2022-12-02','2022-12-02 07:03:46','2022-12-03 07:03:46','615',0.00,0.00,'615','2022-12-03 07:18:30','615','2022-12-03 07:19:01',10,0),('1','176',257911,'DAILY SALES','2022-12-03','2022-12-03 07:19:36','2022-12-04 07:19:36','615',0.00,0.00,'615','2022-12-03 17:43:59','615','2022-12-03 17:44:15',10,0),('1','176',257912,'DAILY SALES','2022-12-04','2022-12-04 07:41:40','2022-12-05 07:41:40','615',0.00,0.00,'615','2022-12-05 07:49:28','615','2022-12-05 07:49:46',10,0),('1','176',257913,'DAILY SALES','2022-12-05','2022-12-05 07:50:10','2022-12-06 07:50:10','615',0.00,0.00,'615','2022-12-05 10:20:16','615','2022-12-05 10:20:34',10,0),('1','176',257914,'DAILY SALES','2022-12-05','2022-12-05 10:38:00','2022-12-06 10:38:00','615',0.00,0.00,'615','2022-12-05 23:27:53','615','2022-12-05 23:28:36',10,0),('1','176',257915,'DAILY SALES','2022-12-06','2022-12-06 07:40:40','2022-12-07 07:40:40','615',0.00,0.00,'615','2022-12-07 09:09:27','615','2022-12-07 09:09:47',10,0),('1','176',257916,'DAILY SALES','2022-12-07','2022-12-07 09:10:07','2022-12-08 09:10:07','615',0.00,0.00,'615','2022-12-07 21:01:30','615','2022-12-07 21:01:45',10,0),('1','176',257917,'DAILY SALES','2022-12-07','2022-12-07 21:02:58','2022-12-08 21:02:58','615',0.00,0.00,'615','2022-12-07 21:51:50','615','2022-12-07 21:52:07',10,0),('1','176',257918,'DAILY SALES','2022-12-08','2022-12-08 11:12:12','2022-12-09 11:12:12','615',0.00,0.00,'615','2022-12-08 19:34:02','615','2022-12-08 19:34:17',10,0),('1','176',257919,'DAILY SALES','2022-12-09','2022-12-09 07:28:32','2022-12-10 07:28:32','615',0.00,0.00,'615','2022-12-09 19:24:39','615','2022-12-09 19:24:55',10,0),('1','176',257920,'DAILY SALES','2022-12-10','2022-12-10 07:19:42','2022-12-11 07:19:42','615',0.00,0.00,'615','2022-12-11 06:12:59','615','2022-12-11 06:13:35',10,0),('1','176',257921,'Daily Shift ','2022-12-11','2022-12-11 09:16:22','2022-12-12 09:16:22','615',0.00,0.00,'615','2022-12-11 20:13:56','615','2022-12-11 20:14:20',10,0),('1','176',257922,'DAILY SALES','2022-12-12','2022-12-12 07:41:49','2022-12-13 07:41:49','615',0.00,0.00,'615','2022-12-12 22:09:48','615','2022-12-12 22:10:06',10,0),('1','176',257923,'DAILY SALES','2022-12-13','2022-12-13 07:07:56','2022-12-14 07:07:56','615',0.00,0.00,'615','2022-12-14 08:07:49','615','2022-12-14 08:08:25',10,0),('1','176',257924,'DAILY SALES','2022-12-14','2022-12-14 08:09:21','2022-12-15 08:09:21','615',0.00,0.00,'615','2022-12-15 05:59:14','615','2022-12-15 05:59:30',10,0),('1','176',257925,'DAILY SALES','2022-12-15','2022-12-15 07:11:04','2022-12-16 07:11:04','615',0.00,0.00,'615','2022-12-16 08:58:58','615','2022-12-16 08:59:18',10,0),('1','176',257926,'Daily Shift ','2022-12-16','2022-12-16 08:59:53','2022-12-17 08:59:53','615',0.00,0.00,'615','2022-12-16 22:23:54','615','2022-12-16 22:24:10',10,0),('1','176',257927,'DAILY SALES','2022-12-15','2022-12-16 22:28:16','2022-12-17 22:28:16','615',0.00,0.00,'615','2022-12-16 22:31:06','615','2022-12-16 22:31:29',10,0),('1','176',257928,'DAILY SALES','2022-12-17','2022-12-17 07:15:08','2022-12-18 07:15:08','615',0.00,0.00,'615','2022-12-17 23:12:59','615','2022-12-17 23:13:15',10,0),('1','176',257929,'DAILY SALES','2022-12-17','2022-12-17 23:23:03','2022-12-18 23:23:03','615',0.00,0.00,'615','2022-12-17 23:32:57','615','2022-12-17 23:33:16',10,0),('1','176',257930,'DAILY SALES','2022-12-18','2022-12-18 07:22:01','2022-12-19 07:22:01','615',0.00,0.00,'615','2022-12-18 21:04:52','615','2022-12-18 21:05:13',10,0),('1','176',257931,'DAILY SHIFTS','2022-12-19','2022-12-19 07:34:26','2022-12-20 07:34:26','615',0.00,0.00,'615','2022-12-19 19:18:27','615','2022-12-19 19:18:49',10,0),('1','176',257932,'DAILY SALES','2022-12-19','2022-12-19 19:19:40','2022-12-20 19:19:40','615',0.00,0.00,'615','2022-12-19 19:28:36','615','2022-12-19 19:28:51',10,0),('1','176',257933,'DAILY SALES','2022-12-20','2022-12-20 07:09:43','2022-12-21 07:09:43','615',0.00,0.00,'615','2022-12-20 18:30:24','615','2022-12-20 18:30:46',10,0),('1','176',257934,'DAILY SALES','2022-12-21','2022-12-21 07:16:46','2022-12-22 07:16:46','615',0.00,0.00,'615','2022-12-21 19:54:14','615','2022-12-21 19:54:27',10,0),('1','176',257935,'DAILY SALES','2022-12-22','2022-12-22 07:49:02','2022-12-23 07:49:02','615',0.00,0.00,'615','2022-12-22 16:56:08','615','2022-12-22 16:56:30',10,0),('1','176',257936,'DAILY SALES','2022-12-23','2022-12-23 07:18:56','2022-12-24 07:18:56','615',0.00,0.00,'615','2022-12-23 19:25:50','615','2022-12-23 19:26:06',10,0),('1','176',257937,'DAILY SALES','2022-12-24','2022-12-24 07:25:28','2022-12-25 07:25:28','615',0.00,0.00,'615','2022-12-25 06:59:26','615','2022-12-25 06:59:45',10,0),('1','176',257938,'DAILY SALES','2022-12-25','2022-12-25 07:03:56','2022-12-26 07:03:56','615',0.00,0.00,'615','2022-12-25 19:39:55','615','2022-12-25 19:40:12',10,0),('1','176',257939,'DAILY SALES','2022-12-26','2022-12-26 07:57:35','2022-12-27 07:57:35','615',0.00,0.00,'615','2022-12-26 11:24:13','615','2022-12-26 11:24:30',10,0),('1','176',257940,'DAILY SALES','2022-12-26','2022-12-26 11:34:13','2022-12-27 11:34:13','615',0.00,0.00,'615','2022-12-26 18:51:17','615','2022-12-26 18:51:35',10,0),('1','176',257941,'DAILY SALES','2022-12-27','2022-12-27 07:29:58','2022-12-28 07:29:58','615',0.00,0.00,'615','2022-12-27 19:53:01','615','2022-12-27 19:53:15',10,0),('1','176',257942,'DAILY SALES','2022-12-28','2022-12-28 07:56:55','2022-12-29 07:56:55','615',0.00,0.00,'615','2022-12-28 19:13:08','615','2022-12-28 19:13:25',10,0),('1','176',257943,'DAILY SALES','2022-12-29','2022-12-29 07:46:21','2022-12-30 07:46:21','615',0.00,0.00,'615','2022-12-29 11:01:04','615','2022-12-29 11:01:19',10,0),('1','176',257944,'DAILY SALES','2022-12-29','2022-12-29 11:01:44','2022-12-30 11:01:44','615',0.00,0.00,'615','2022-12-29 20:29:21','615','2022-12-29 20:29:36',10,0),('1','176',257945,'DAILY SALES','2022-12-30','2022-12-30 07:32:53','2022-12-31 07:32:53','615',0.00,0.00,'615','2022-12-30 19:34:09','615','2022-12-30 19:34:23',10,0),('1','176',257946,'DAILY SALES','2022-12-31','2022-12-31 07:12:28','2023-01-01 07:12:28','615',0.00,0.00,'615','2022-12-31 18:27:43','615','2022-12-31 18:28:05',10,0),('1','176',257947,'DAILY SHIFTS','2023-01-01','2023-01-01 07:24:03','2023-01-02 07:24:03','615',0.00,0.00,'615','2023-01-01 19:13:58','615','2023-01-01 19:14:12',10,0),('1','176',257948,'DAILY SHIFTS','2023-01-02','2023-01-02 07:11:32','2023-01-03 07:11:32','615',0.00,0.00,'615','2023-01-02 19:29:00','615','2023-01-02 19:29:15',10,0),('1','176',257949,'DAILY SHIFTS','2023-01-03','2023-01-03 07:18:52','2023-01-04 07:18:52','615',0.00,0.00,'615','2023-01-03 12:27:55','615','2023-01-03 12:28:23',10,0),('1','176',257950,'DAILY SHIFTS','2023-01-03','2023-01-03 12:31:38','2023-01-04 12:31:38','615',0.00,0.00,'615','2023-01-03 21:01:48','615','2023-01-03 21:02:15',10,0),('1','176',257951,'DAILY SHIFTS','2023-01-04','2023-01-04 07:17:30','2023-01-05 07:17:30','615',0.00,0.00,'615','2023-01-04 19:12:14','615','2023-01-04 19:12:32',10,0),('1','176',257952,'DAILY SHIFTS','2023-01-05','2023-01-05 07:02:23','2023-01-06 07:02:23','615',0.00,0.00,'615','2023-01-06 09:00:34','615','2023-01-06 09:00:52',10,0),('1','176',257953,'DAILY SHIFTS','2023-01-06','2023-01-06 09:01:11','2023-01-07 09:01:11','615',0.00,0.00,'615','2023-01-06 11:32:17','615','2023-01-06 11:32:33',10,0),('1','176',257954,'DAILY SHIFTS','2023-01-06','2023-01-06 16:14:22','2023-01-07 16:14:22','615',0.00,0.00,'615','2023-01-06 19:18:28','615','2023-01-06 19:18:44',10,0),('1','176',257955,'DAILY SHIFTS','2023-01-07','2023-01-07 07:33:28','2023-01-08 07:33:28','615',0.00,0.00,'615','2023-01-07 19:13:23','615','2023-01-07 19:13:39',10,0),('1','176',257956,'DAILY SHIFTS','2023-01-08','2023-01-08 07:35:37','2023-01-09 07:35:37','615',0.00,0.00,'615','2023-01-08 15:32:24','615','2023-01-08 15:32:48',10,0),('1','176',257957,'DAILY SHIFTS','2023-01-08','2023-01-08 15:33:09','2023-01-09 15:33:09','615',0.00,0.00,'615','2023-01-08 19:14:26','615','2023-01-08 19:14:44',10,0),('1','176',257958,'DAILY SHIFTS','2023-01-09','2023-01-09 07:25:47','2023-01-10 07:25:47','615',0.00,0.00,'615','2023-01-09 19:50:12','615','2023-01-09 19:50:27',10,0),('1','176',257959,'DAILY SHIFTS','2023-01-10','2023-01-10 07:20:18','2023-01-11 07:20:18','615',0.00,0.00,'615','2023-01-10 18:23:46','615','2023-01-10 18:24:01',10,0),('1','176',257960,'DAILY SHIFTS','2023-01-11','2023-01-11 07:16:05','2023-01-12 07:16:05','615',0.00,0.00,'615','2023-01-11 19:58:35','615','2023-01-11 19:58:55',10,0),('1','176',257961,'DAILY SHIFTS','2023-01-12','2023-01-12 07:37:14','2023-01-13 07:37:14','615',0.00,0.00,'615','2023-01-12 19:50:18','615','2023-01-12 19:50:36',10,0),('1','176',257962,'DAILY SHIFTS','2023-01-13','2023-01-13 07:45:51','2023-01-14 07:45:51','615',0.00,0.00,'615','2023-01-13 12:40:03','615','2023-01-13 12:40:20',10,0),('1','176',257963,'DAILY SHIFTS','2023-01-13','2023-01-13 12:43:36','2023-01-14 12:43:36','615',0.00,0.00,'615','2023-01-13 20:16:49','615','2023-01-13 20:17:04',10,0),('1','176',257964,'DAILY SHIFTS','2023-01-14','2023-01-14 07:23:08','2023-01-15 07:23:08','615',0.00,0.00,'615','2023-01-14 19:16:15','615','2023-01-14 19:16:32',10,0),('1','176',257965,'DAILY SHIFTS','2023-01-15','2023-01-15 07:39:28','2023-01-16 07:39:28','615',0.00,0.00,'615','2023-01-15 10:20:43','615','2023-01-15 10:21:05',10,0),('1','176',257966,'DAILY SHIFTS','2023-01-15','2023-01-15 10:59:03','2023-01-16 10:59:03','615',0.00,0.00,'615','2023-01-15 22:59:37','615','2023-01-15 22:59:55',10,0),('1','176',257967,'DAILY SHIFTS','2023-01-16','2023-01-16 07:02:34','2023-01-17 07:02:34','615',0.00,0.00,'615','2023-01-17 00:26:32','615','2023-01-17 00:26:50',10,0),('1','176',257968,'DAILY SHIFTS','2023-01-17','2023-01-17 08:45:02','2023-01-18 08:45:02','615',0.00,0.00,'615','2023-01-18 07:26:35','615','2023-01-18 07:26:51',10,0),('1','176',257969,'DAILY SALES','2023-01-18','2023-01-18 07:55:40','2023-01-19 07:55:40','615',0.00,0.00,'615','2023-01-19 01:49:20','615','2023-01-19 01:49:35',10,0),('1','176',257970,'DAILY SALES','2023-01-19','2023-01-19 08:18:38','2023-01-20 08:18:38','615',0.00,0.00,'615','2023-01-19 20:44:26','615','2023-01-19 20:44:42',10,0),('1','176',257971,'Daily shifts','2023-01-20','2023-01-20 07:30:13','2023-01-21 07:30:13','615',0.00,0.00,'615','2023-01-20 14:27:15','615','2023-01-20 14:27:30',10,0),('1','176',257972,'DAILY SHIFTS','2023-01-20','2023-01-20 14:27:49','2023-01-21 14:27:49','615',0.00,0.00,'615','2023-01-20 19:34:47','615','2023-01-20 19:35:04',10,0),('1','176',257973,'DAILY SALES','2023-01-21','2023-01-21 07:32:17','2023-01-22 07:32:17','615',0.00,0.00,'615','2023-01-22 00:36:55','615','2023-01-22 00:37:11',10,0),('1','176',257974,'DAILY SHIFTS','2023-01-22','2023-01-22 07:45:55','2023-01-23 07:45:55','615',0.00,0.00,'615','2023-01-22 20:18:48','615','2023-01-22 20:19:10',10,0),('1','176',257975,'DAILY SALES','2023-01-23','2023-01-23 08:22:15','2023-01-24 08:22:15','615',0.00,0.00,'615','2023-01-24 09:02:18','615','2023-01-24 09:02:34',10,0),('1','176',257976,'DAILY SHIFTS','2023-01-24','2023-01-24 09:04:10','2023-01-25 09:04:10','615',0.00,0.00,'615','2023-01-25 10:20:26','615','2023-01-25 10:20:45',10,0),('1','176',257977,'DAILY SHIFTS','2023-01-25','2023-01-25 10:21:41','2023-01-26 10:21:41','615',0.00,0.00,'615','2023-01-25 20:12:02','615','2023-01-25 20:12:20',10,0),('1','176',257978,'Daily shifts','2023-01-26','2023-01-26 06:21:39','2023-01-27 06:21:39','615',0.00,0.00,'615','2023-01-26 08:58:33','615','2023-01-26 08:58:51',10,0),('1','176',257979,'DAILY SHIFTS','2023-01-26','2023-01-26 08:59:22','2023-01-27 08:59:22','615',0.00,0.00,'615','2023-01-27 07:03:42','615','2023-01-27 07:04:07',10,0),('1','176',257980,'Daily shifts','2023-01-27','2023-01-27 07:04:48','2023-01-28 07:04:48','615',0.00,0.00,'615','2023-01-27 18:02:40','615','2023-01-27 18:03:02',10,0),('1','176',257981,'DAILY SHIFTS','2023-01-28','2023-01-28 07:16:40','2023-01-29 07:16:40','615',0.00,0.00,'615','2023-01-28 21:03:07','615','2023-01-28 21:03:28',10,0),('1','176',257982,'DAILY SHIFTS','2023-01-29','2023-01-29 06:54:46','2023-01-30 06:54:46','615',0.00,0.00,'615','2023-01-29 13:23:40','615','2023-01-29 13:24:04',10,0),('1','176',257983,'DAILY SHIFTS','2023-01-29','2023-01-29 13:25:16','2023-01-30 13:25:16','615',0.00,0.00,'615','2023-01-30 09:05:26','615','2023-01-30 09:05:43',10,0),('1','176',257984,'DAILY SHIFTS','2023-01-30','2023-01-30 09:05:59','2023-01-31 09:05:59','615',0.00,0.00,'615','2023-01-31 06:41:41','615','2023-01-31 06:42:06',10,0),('1','176',257985,'DAILY SHIFTS','2023-01-31','2023-01-31 06:42:53','2023-02-01 06:42:53','615',0.00,0.00,'615','2023-01-31 15:27:15','615','2023-01-31 15:27:36',10,0),('1','176',257986,'DAILY SHIFTS','2023-02-01','2023-02-01 06:34:20','2023-02-02 06:34:20','615',0.00,0.00,'615','2023-02-01 21:46:29','615','2023-02-01 21:46:54',10,0),('1','176',257987,'DAILY SHIFTS','2023-02-02','2023-02-02 07:16:59','2023-02-03 07:16:59','615',0.00,0.00,'615','2023-02-02 16:17:30','615','2023-02-02 16:17:51',10,0),('1','176',257988,'DAILY SHIFTS','2023-02-02','2023-02-02 16:22:20','2023-02-03 16:22:20','615',0.00,0.00,'615','2023-02-02 21:49:27','615','2023-02-02 21:49:49',10,0),('1','176',257989,'DAILY SHIFTS','2023-02-03','2023-02-03 06:13:22','2023-02-04 06:13:22','615',0.00,0.00,'615','2023-02-03 21:25:24','615','2023-02-03 21:25:48',10,0),('1','176',257990,'DAILY SHIFTS','2023-02-04','2023-02-04 06:18:57','2023-02-05 06:18:57','615',0.00,0.00,'615','2023-02-04 14:40:09','615','2023-02-04 14:40:24',10,0),('1','176',257991,'DAILY SHIFTS','2023-02-04','2023-02-04 14:40:51','2023-02-05 14:40:51','615',0.00,0.00,'615','2023-02-04 20:33:42','615','2023-02-04 20:34:07',10,0),('1','176',257992,'DAILY SALES','2023-02-05','2023-02-05 07:08:08','2023-02-06 07:08:08','615',0.00,0.00,'615','2023-02-05 21:47:01','615','2023-02-05 21:47:21',10,0),('1','176',257993,'DAILY SHIFTS','2023-02-06','2023-02-06 06:28:34','2023-02-07 06:28:34','615',0.00,0.00,'615','2023-02-06 13:28:41','615','2023-02-06 13:29:02',10,0),('1','176',257994,'DAILY SHIFTS','2023-02-06','2023-02-06 13:29:30','2023-02-07 13:29:30','615',0.00,0.00,'615','2023-02-06 21:17:08','615','2023-02-06 21:17:30',10,0),('1','176',257995,'DAILY SHIFTS','2023-02-07','2023-02-07 06:45:59','2023-02-08 06:45:59','615',0.00,0.00,'615','2023-02-07 21:49:46','615','2023-02-07 21:50:12',10,0),('1','176',257996,'DAILY SHIFTS','2023-02-08','2023-02-08 06:36:52','2023-02-09 06:36:52','615',0.00,0.00,'615','2023-02-08 20:26:46','615','2023-02-08 20:27:09',10,0),('1','176',257997,'DAILY SHIFTS','2023-02-09','2023-02-09 07:51:40','2023-02-10 07:51:40','615',0.00,0.00,'615','2023-02-09 13:11:57','615','2023-02-09 13:12:18',10,0),('1','176',257998,'DAILY SHIFTS','2023-02-09','2023-02-09 13:18:48','2023-02-10 13:18:48','615',0.00,0.00,'615','2023-02-09 20:49:59','615','2023-02-09 20:50:25',10,0),('1','176',257999,'DAILY SHIFTS','2023-02-10','2023-02-10 06:26:47','2023-02-11 06:26:47','615',0.00,0.00,'615','2023-02-10 20:37:24','615','2023-02-10 20:37:50',10,0),('1','176',258000,'DAILY SHIFTS','2023-02-11','2023-02-11 07:23:28','2023-02-12 07:23:28','615',0.00,0.00,'615','2023-02-11 20:32:20','615','2023-02-11 20:32:44',10,0),('1','176',258001,'DAILY SHIFTS','2023-02-12','2023-02-12 07:07:39','2023-02-13 07:07:39','615',0.00,0.00,'615','2023-02-12 23:26:01','615','2023-02-12 23:26:25',10,0),('1','176',258002,'DAILY SHIFTS','2023-02-13','2023-02-13 07:21:19','2023-02-14 07:21:19','615',0.00,0.00,'615','2023-02-13 22:00:29','615','2023-02-13 22:00:49',10,0),('1','176',258003,'DAILY SHIFTS','2023-02-14','2023-02-14 07:03:55','2023-02-15 07:03:55','615',0.00,0.00,'615','2023-02-14 21:02:39','615','2023-02-14 21:03:14',10,0),('1','176',258004,'DAILY SHIFTS','2023-02-15','2023-02-15 07:10:13','2023-02-16 07:10:13','615',0.00,0.00,'615','2023-02-15 21:41:48','615','2023-02-15 21:42:10',10,0),('1','176',258005,'DAILY SHIFTS','2023-02-16','2023-02-16 07:18:14','2023-02-17 07:18:14','615',0.00,0.00,'615','2023-02-16 20:37:20','615','2023-02-16 20:37:48',10,0),('1','176',258006,'DAILY SHIFTS','2023-02-17','2023-02-17 07:13:16','2023-02-18 07:13:16','615',0.00,0.00,'615','2023-02-17 09:58:02','615','2023-02-17 09:58:16',10,0),('1','176',258007,'DAILY SHIFTS','2023-02-17','2023-02-17 10:43:51','2023-02-18 10:43:51','615',0.00,0.00,'615','2023-02-17 21:59:06','615','2023-02-17 21:59:27',10,0),('1','176',258008,'DAILY SHIFTS','2023-02-18','2023-02-18 07:37:02','2023-02-19 07:37:02','615',0.00,0.00,'615','2023-02-19 07:40:19','615','2023-02-19 07:40:39',10,0),('1','176',258009,'DAILY SHIFTS','2023-02-19','2023-02-19 07:41:09','2023-02-20 07:41:09','615',0.00,0.00,'615','2023-02-19 20:31:34','615','2023-02-19 20:31:54',10,0),('1','176',258010,'DAILY SHIFTS','2023-02-20','2023-02-20 07:28:07','2023-02-21 07:28:07','615',0.00,0.00,'615','2023-02-20 22:10:50','615','2023-02-20 22:11:16',10,0),('1','176',258011,'DAILY SHIFTS','2023-02-21','2023-02-21 06:59:34','2023-02-22 06:59:34','615',0.00,0.00,'615','2023-02-21 21:53:23','615','2023-02-21 21:53:44',10,0),('1','176',258012,'DAILY SHIFTS','2023-02-22','2023-02-22 07:01:40','2023-02-23 07:01:40','615',0.00,0.00,'615','2023-02-22 22:53:43','615','2023-02-22 22:54:03',10,0),('1','176',258013,'DAILY SHIFTS','2023-02-23','2023-02-23 07:24:56','2023-02-24 07:24:56','615',0.00,0.00,'615','2023-02-23 22:29:37','615','2023-02-23 22:29:55',10,0),('1','176',258014,'DAILY SHIFTS','2023-02-24','2023-02-24 07:58:25','2023-02-25 07:58:25','615',0.00,0.00,'615','2023-02-24 18:12:52','615','2023-02-24 18:13:28',10,0),('1','176',258015,'DAILY SHIFTS','2023-02-24','2023-02-24 18:14:06','2023-02-25 18:14:06','615',0.00,0.00,'615','2023-02-24 21:19:30','615','2023-02-24 21:19:46',10,0),('1','176',258016,'DAILY SHIFTS','2023-02-26','2023-02-26 07:43:16','2023-02-27 07:43:16','615',0.00,0.00,'615','2023-02-27 07:48:27','615','2023-02-27 07:48:43',10,0),('1','176',258017,'DAILY SHIFTS','2023-02-27','2023-02-27 07:49:03','2023-02-28 07:49:03','615',0.00,0.00,'615','2023-02-27 23:34:53','615','2023-02-27 23:50:06',10,0),('1','176',258018,'DAILY SHIFTS','2023-02-28','2023-02-28 07:19:03','2023-03-01 07:19:03','615',0.00,0.00,'615','2023-02-28 20:10:19','615','2023-02-28 20:10:38',10,0),('1','176',258019,'DAILY SHIFTS','2023-03-01','2023-03-01 09:52:17','2023-03-02 09:52:17','615',0.00,0.00,'615','2023-03-01 20:59:32','615','2023-03-01 20:59:48',10,0),('1','176',258020,'DAILY SHIFTS','2023-03-02','2023-03-02 07:38:46','2023-03-03 07:38:46','615',0.00,0.00,'615','2023-03-02 22:01:13','615','2023-03-02 22:04:15',10,0),('1','176',258021,'DAILY SHIFTS','2023-03-03','2023-03-03 07:20:27','2023-03-04 07:20:27','615',0.00,0.00,'615','2023-03-03 21:52:35','615','2023-03-03 21:52:57',10,0),('1','176',258022,'DAILY SHIFTS','2023-03-04','2023-03-04 07:54:41','2023-03-05 07:54:41','615',0.00,0.00,'615','2023-03-04 12:56:40','615','2023-03-04 13:01:20',10,0),('1','176',258023,'DAILY SHIFTS','2023-03-04','2023-03-04 13:21:04','2023-03-05 13:21:04','615',0.00,0.00,'615','2023-03-04 20:50:12','615','2023-03-04 20:50:30',10,0),('1','176',258024,'DAILY SHIFTS','2023-03-05','2023-03-05 07:32:13','2023-03-06 07:32:13','615',0.00,0.00,'615','2023-03-05 15:45:22','615','2023-03-05 15:45:39',10,0),('1','176',258025,'DAILY SHIFTS','2023-03-05','2023-03-05 15:56:53','2023-03-06 15:56:53','615',0.00,0.00,'615','2023-03-05 20:15:18','615','2023-03-05 20:15:37',10,0),('1','176',258026,'DAILY SHIFTS','2023-03-06','2023-03-06 07:05:52','2023-03-07 07:05:52','615',0.00,0.00,'615','2023-03-07 08:11:58','615','2023-03-07 08:12:14',10,0),('1','176',258027,'DAILY SHIFTS','2023-03-07','2023-03-07 08:12:36','2023-03-08 08:12:36','615',0.00,0.00,'615','2023-03-07 18:49:51','615','2023-03-07 18:50:07',10,0),('1','176',258028,'DAILY SHIFTS','2023-03-08','2023-03-08 07:44:28','2023-03-09 07:44:28','615',0.00,0.00,'615','2023-03-08 20:16:21','615','2023-03-08 20:16:35',10,0),('1','176',258029,'DAILY SHIFTS','2023-03-09','2023-03-09 07:16:02','2023-03-10 07:16:02','615',0.00,0.00,'615','2023-03-09 18:43:35','615','2023-03-09 18:43:51',10,0),('1','176',258030,'DAILY SHIFTS','2023-03-10','2023-03-10 07:43:10','2023-03-11 07:43:10','615',0.00,0.00,'615','2023-03-10 20:04:47','615','2023-03-10 20:05:12',10,0),('1','176',258031,'DAILY SHIFTS','2023-03-11','2023-03-11 07:40:35','2023-03-12 07:40:35','615',0.00,0.00,'615','2023-03-11 13:49:07','615','2023-03-11 13:49:23',10,0),('1','176',258032,'DAILY SHIFTS','2023-03-11','2023-03-11 14:22:21','2023-03-12 14:22:21','615',0.00,0.00,'615','2023-03-12 08:44:06','615','2023-03-12 08:44:22',10,0),('1','176',258033,'DAILY SHIFTS','2023-03-12','2023-03-12 10:12:39','2023-03-13 10:12:39','615',0.00,0.00,'615','2023-03-13 07:01:55','615','2023-03-13 07:02:29',10,0),('1','176',258034,'DAILY SHIFTS','2023-03-13','2023-03-13 07:03:06','2023-03-14 07:03:06','615',0.00,0.00,'615','2023-03-13 08:38:34','615','2023-03-13 08:38:47',10,0),('1','176',258035,'DAILY SHIFTS','2023-03-13','2023-03-13 08:39:03','2023-03-14 08:39:03','615',0.00,0.00,'615','2023-03-13 21:03:35','615','2023-03-13 21:03:54',10,0),('1','176',258036,'DAILY SHIFTS','2023-03-14','2023-03-14 06:54:41','2023-03-15 06:54:41','615',0.00,0.00,'615','2023-03-14 20:57:36','615','2023-03-14 20:57:59',10,0),('1','176',258037,'DAILY SHIFTS','2023-03-15','2023-03-15 07:07:41','2023-03-16 07:07:41','615',0.00,0.00,'615','2023-03-15 10:42:22','615','2023-03-15 10:42:37',10,0),('1','176',258038,'DAILY SHIFTS','2023-03-15','2023-03-15 10:43:18','2023-03-16 10:43:18','615',0.00,0.00,'615','2023-03-16 07:41:30','615','2023-03-16 07:41:52',10,0),('1','176',258039,'DAILY SHIFTS','2023-03-16','2023-03-16 07:42:11','2023-03-17 07:42:11','615',0.00,0.00,'615','2023-03-17 07:25:37','615','2023-03-17 07:26:03',10,0),('1','176',258040,'DAILY SHIFTS','2023-03-17','2023-03-17 07:26:43','2023-03-18 07:26:43','615',0.00,0.00,'615','2023-03-17 08:25:28','615','2023-03-17 08:25:49',10,0),('1','176',258041,'DAILY SHIFTS','2023-03-17','2023-03-17 08:28:28','2023-03-18 08:28:28','615',0.00,0.00,'615','2023-03-17 20:55:01','615','2023-03-17 20:55:20',10,0),('1','176',258042,'DAILY SHIFTS','2023-03-18','2023-03-18 08:18:02','2023-03-19 08:18:02','615',0.00,0.00,'615','2023-03-18 11:41:38','615','2023-03-18 11:41:57',10,0),('1','176',258043,'DAILY SHIFTS','2023-03-18','2023-03-18 11:42:20','2023-03-19 11:42:20','615',0.00,0.00,'615','2023-03-18 18:42:54','615','2023-03-18 18:43:11',10,0),('1','176',258044,'DAILY SHIFTS','2023-03-19','2023-03-19 07:31:46','2023-03-20 07:31:46','615',0.00,0.00,'615','2023-03-19 20:31:43','615','2023-03-19 20:32:01',10,0),('1','176',258045,'DAILY SHIFTS','2023-03-20','2023-03-20 06:27:56','2023-03-21 06:27:56','615',0.00,0.00,'615','2023-03-20 20:54:50','615','2023-03-20 20:55:06',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905717 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','176','920','186034',3645891,'2720','409',0.00,50.79,0.00,0.00,50.79,12799.08,0.00,0.00,0.00),('1','176','920','186034',3645892,'2721','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','186126',3647502,'2720','409',50.79,75.79,0.00,0.00,25.00,8800.00,0.00,0.00,0.00),('1','176','920','186126',3647503,'2721','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','186376',3651553,'2720','409',75.79,138.49,0.00,0.00,62.70,22070.40,0.00,0.00,0.00),('1','176','920','186376',3651554,'2721','409',0.00,25.00,0.00,0.00,25.00,8800.00,0.00,0.00,0.00),('1','176','920','186557',3654697,'2720','409',138.49,1044.99,0.00,0.00,906.50,297632.00,0.00,0.00,0.00),('1','176','920','186557',3654698,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','186779',3658518,'2720','409',1044.99,1964.83,0.00,0.00,919.84,304415.68,0.00,0.00,0.00),('1','176','920','186779',3658519,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187012',3662351,'2720','409',1964.83,4611.93,0.00,0.00,2647.10,870075.20,0.00,0.00,0.00),('1','176','920','187012',3662352,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187218',3665996,'2720','409',4611.93,6023.14,0.00,0.00,1411.21,465857.92,0.00,0.00,0.00),('1','176','920','187218',3665997,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187465',3670639,'2720','409',6023.14,8468.09,0.00,0.00,2444.95,803034.40,0.00,0.00,0.00),('1','176','920','187465',3670640,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187681',3674368,'2720','409',8468.09,9371.89,0.00,0.00,903.80,297874.40,0.00,0.00,0.00),('1','176','920','187681',3674369,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187682',3674370,'2720','409',9371.89,9371.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187682',3674371,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187687',3674444,'2720','409',9371.89,9371.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187687',3674445,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187718',3674946,'2720','409',9371.89,11545.65,0.00,0.00,2173.76,714643.52,0.00,0.00,0.00),('1','176','920','187718',3674947,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','187864',3677438,'2720','409',11545.65,14384.14,0.00,0.00,2838.49,932929.60,0.00,0.00,0.00),('1','176','920','187864',3677439,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188091',3681421,'2720','409',14384.14,18439.20,0.00,0.00,4055.06,1336736.48,0.00,0.00,0.00),('1','176','920','188091',3681422,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188355',3686010,'2720','409',18439.20,18977.12,0.00,0.00,537.92,176857.76,0.00,0.00,0.00),('1','176','920','188355',3686011,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188367',3686219,'2720','409',18977.12,23856.82,0.00,0.00,4879.70,1601209.76,0.00,0.00,0.00),('1','176','920','188367',3686220,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188443',3687425,'2720','409',23856.82,23856.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188443',3687426,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188453',3687588,'2720','409',23856.82,28147.50,0.00,0.00,4290.68,1413923.36,0.00,0.00,0.00),('1','176','920','188453',3687589,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188564',3689804,'2720','409',28147.50,28147.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188564',3689805,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188663',3691298,'2720','409',28147.50,30715.77,0.00,0.00,2568.27,846203.04,0.00,0.00,0.00),('1','176','920','188663',3691299,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188802',3693938,'2720','409',30715.77,33273.81,0.00,0.00,2558.04,841469.28,0.00,0.00,0.00),('1','176','920','188802',3693939,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188920',3695987,'2720','409',33273.81,33273.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188920',3695988,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','188924',3696057,'2720','409',33273.81,35469.00,0.00,0.00,2195.19,722306.88,0.00,0.00,0.00),('1','176','920','188924',3696058,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189012',3697731,'2720','409',35469.00,38292.84,0.00,0.00,2823.84,926887.68,0.00,0.00,0.00),('1','176','920','189012',3697732,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189158',3700298,'2720','409',38292.84,38292.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189158',3700299,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189160',3700307,'2720','409',38292.84,40322.97,0.00,0.00,2030.13,668633.76,0.00,0.00,0.00),('1','176','920','189160',3700308,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189216',3701169,'2720','409',40322.97,43057.60,0.00,0.00,2734.63,903933.76,0.00,0.00,0.00),('1','176','920','189216',3701170,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189378',3704488,'2720','409',43057.60,43057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189378',3704489,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189425',3705119,'2720','409',43057.60,48048.89,0.00,0.00,4991.29,1641722.08,0.00,0.00,0.00),('1','176','920','189425',3705120,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189582',3707978,'2720','409',48048.89,48048.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189582',3707979,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189620',3708488,'2720','409',48048.89,52473.20,0.00,0.00,4424.31,1452237.12,0.00,0.00,0.00),('1','176','920','189620',3708489,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189823',3711992,'2720','409',52473.20,53243.20,0.00,0.00,770.00,253160.00,0.00,0.00,0.00),('1','176','920','189823',3711993,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189874',3712769,'2720','409',53243.20,53243.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189874',3712770,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','189878',3712809,'2720','409',53243.20,57471.85,0.00,0.00,4228.65,1391692.80,0.00,0.00,0.00),('1','176','920','189878',3712810,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190038',3716284,'2720','409',57471.85,58087.72,0.00,0.00,615.87,203198.88,0.00,0.00,0.00),('1','176','920','190038',3716285,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190131',3718141,'2720','409',58087.72,59098.06,0.00,0.00,1010.34,331459.68,0.00,0.00,0.00),('1','176','920','190131',3718142,'2721','409',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190222',3719815,'2720','409',59098.06,62982.94,0.00,0.00,3884.88,1278147.36,0.00,0.00,0.00),('1','176','920','190222',3719816,'2721','409',25.00,86.00,0.00,0.00,61.00,20008.00,0.00,0.00,0.00),('1','176','920','190397',3723230,'2720','409',62982.94,62982.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190397',3723231,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190398',3723232,'2720','409',62982.94,62982.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190398',3723233,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190430',3723765,'2720','409',62982.94,68043.05,0.00,0.00,5060.11,1661638.96,0.00,0.00,0.00),('1','176','920','190430',3723766,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190624',3727344,'2720','409',68043.05,68043.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190624',3727345,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190693',3728481,'2720','409',68043.05,72384.92,0.00,0.00,4341.87,1428500.40,0.00,0.00,0.00),('1','176','920','190693',3728482,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190891',3732210,'2720','409',72384.92,73043.05,0.00,0.00,658.13,217198.64,0.00,0.00,0.00),('1','176','920','190891',3732211,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','190900',3732301,'2720','409',73043.05,76911.24,0.00,0.00,3868.19,1272707.60,0.00,0.00,0.00),('1','176','920','190900',3732302,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191172',3737063,'2720','409',76911.24,78043.06,0.00,0.00,1131.82,371819.68,0.00,0.00,0.00),('1','176','920','191172',3737064,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191185',3737295,'2720','409',78043.06,80995.03,0.00,0.00,2951.97,969133.44,0.00,0.00,0.00),('1','176','920','191185',3737296,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191289',3739246,'2720','409',80995.03,83043.04,0.00,0.00,2048.01,674290.80,0.00,0.00,0.00),('1','176','920','191289',3739247,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191351',3740099,'2720','409',83043.04,86613.53,0.00,0.00,3570.49,1172225.68,0.00,0.00,0.00),('1','176','920','191351',3740100,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191499',3742998,'2720','409',86613.53,88043.04,0.00,0.00,1429.51,470413.36,0.00,0.00,0.00),('1','176','920','191499',3742999,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191617',3745210,'2720','409',88043.04,89336.34,0.00,0.00,1293.30,424679.52,0.00,0.00,0.00),('1','176','920','191617',3745211,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191713',3747209,'2720','409',89336.34,92777.81,0.00,0.00,3441.47,1130925.44,0.00,0.00,0.00),('1','176','920','191713',3747210,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191839',3749653,'2720','409',92777.81,92777.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191839',3749654,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191845',3749736,'2720','409',92777.81,95601.90,0.00,0.00,2824.09,932613.28,0.00,0.00,0.00),('1','176','920','191845',3749737,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','191935',3751570,'2720','409',95601.90,97889.20,0.00,0.00,2287.30,750680.80,0.00,0.00,0.00),('1','176','920','191935',3751571,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192054',3753510,'2720','409',97889.20,97889.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192054',3753511,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192061',3753646,'2720','409',97889.20,100560.79,0.00,0.00,2671.59,876761.52,0.00,0.00,0.00),('1','176','920','192061',3753647,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192137',3754982,'2720','409',100560.79,102890.11,0.00,0.00,2329.32,764316.96,0.00,0.00,0.00),('1','176','920','192137',3754983,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192225',3756591,'2720','409',102890.11,104638.06,0.00,0.00,1747.95,574456.56,0.00,0.00,0.00),('1','176','920','192225',3756592,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192343',3758904,'2720','409',104638.06,107890.12,0.00,0.00,3252.06,1067275.68,0.00,0.00,0.00),('1','176','920','192343',3758905,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192447',3760530,'2720','409',107890.12,109431.09,0.00,0.00,1540.97,505738.16,0.00,0.00,0.00),('1','176','920','192447',3760531,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192575',3762919,'2720','409',109431.09,112871.62,0.00,0.00,3440.53,1129924.24,0.00,0.00,0.00),('1','176','920','192575',3762920,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192646',3764193,'2720','409',112871.62,115029.58,0.00,0.00,2157.96,712673.28,0.00,0.00,0.00),('1','176','920','192646',3764194,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192759',3766293,'2720','409',115029.58,117884.12,0.00,0.00,2854.54,936963.52,0.00,0.00,0.00),('1','176','920','192759',3766294,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192854',3768039,'2720','409',117884.12,122209.42,0.00,0.00,4325.30,1419145.04,0.00,0.00,0.00),('1','176','920','192854',3768040,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','192991',3770469,'2720','409',122209.42,122614.91,0.00,0.00,405.49,133000.72,0.00,0.00,0.00),('1','176','920','192991',3770470,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193014',3770947,'2720','409',122614.91,122614.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193014',3770948,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193019',3771031,'2720','409',122614.91,125005.30,0.00,0.00,2390.39,785247.92,0.00,0.00,0.00),('1','176','920','193019',3771032,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193177',3774077,'2720','409',125005.30,127799.09,0.00,0.00,2793.79,917525.68,0.00,0.00,0.00),('1','176','920','193177',3774078,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193282',3776085,'2720','409',127799.09,127799.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193282',3776086,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193291',3776276,'2720','409',127799.09,129366.93,0.00,0.00,1567.84,515519.68,0.00,0.00,0.00),('1','176','920','193291',3776277,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193407',3778846,'2720','409',129366.93,132681.88,0.00,0.00,3314.95,1088176.72,0.00,0.00,0.00),('1','176','920','193407',3778847,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193510',3780666,'2720','409',132681.88,132681.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193510',3780667,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193513',3780674,'2720','409',132681.88,135257.35,0.00,0.00,2575.47,852217.44,0.00,0.00,0.00),('1','176','920','193513',3780675,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193628',3782886,'2720','409',135257.35,137710.61,0.00,0.00,2453.26,805473.76,0.00,0.00,0.00),('1','176','920','193628',3782887,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193732',3784766,'2720','409',137710.61,139641.61,0.00,0.00,1931.00,634066.40,0.00,0.00,0.00),('1','176','920','193732',3784767,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193852',3786851,'2720','409',139641.61,142735.35,0.00,0.00,3093.74,1016096.00,0.00,0.00,0.00),('1','176','920','193852',3786852,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193979',3789145,'2720','409',142735.35,142735.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193979',3789146,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193983',3789162,'2720','409',142735.35,142735.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193983',3789163,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','193990',3789199,'2720','409',142735.35,144362.67,0.00,0.00,1627.32,534443.52,0.00,0.00,0.00),('1','176','920','193990',3789200,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194082',3790921,'2720','409',144362.67,147735.35,0.00,0.00,3372.68,1108369.76,0.00,0.00,0.00),('1','176','920','194082',3790922,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194184',3792730,'2720','409',147735.35,149374.71,0.00,0.00,1639.36,538160.08,0.00,0.00,0.00),('1','176','920','194184',3792731,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194292',3794863,'2720','409',149374.71,152735.45,0.00,0.00,3360.74,1107092.24,0.00,0.00,0.00),('1','176','920','194292',3794864,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194393',3796588,'2720','409',152735.45,155264.47,0.00,0.00,2529.02,837823.04,0.00,0.00,0.00),('1','176','920','194393',3796589,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194498',3798445,'2720','409',155264.47,157735.45,0.00,0.00,2470.98,812366.64,0.00,0.00,0.00),('1','176','920','194498',3798446,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194577',3799711,'2720','409',157735.45,158813.10,0.00,0.00,1077.65,354389.60,0.00,0.00,0.00),('1','176','920','194577',3799712,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194685',3801762,'2720','409',158813.10,162735.45,0.00,0.00,3922.35,1288885.20,0.00,0.00,0.00),('1','176','920','194685',3801763,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194781',3803779,'2720','409',162735.45,165309.84,0.00,0.00,2574.39,845292.72,0.00,0.00,0.00),('1','176','920','194781',3803780,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194963',3807393,'2720','409',165309.84,167141.46,0.00,0.00,1831.62,601453.20,0.00,0.00,0.00),('1','176','920','194963',3807394,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194978',3807688,'2720','409',167141.46,167141.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194978',3807689,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','194992',3807913,'2720','409',167141.46,169314.11,0.00,0.00,2172.65,713853.44,0.00,0.00,0.00),('1','176','920','194992',3807914,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195081',3809392,'2720','409',169314.11,172141.46,0.00,0.00,2827.35,930574.80,0.00,0.00,0.00),('1','176','920','195081',3809393,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195186',3811304,'2720','409',172141.46,175509.93,0.00,0.00,3368.47,1106870.08,0.00,0.00,0.00),('1','176','920','195186',3811305,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195312',3813419,'2720','409',175509.93,177141.46,0.00,0.00,1631.53,537196.48,0.00,0.00,0.00),('1','176','920','195312',3813420,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195397',3814944,'2720','409',177141.46,179461.96,0.00,0.00,2320.50,764040.00,0.00,0.00,0.00),('1','176','920','195397',3814945,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195519',3817135,'2720','409',179461.96,182141.47,0.00,0.00,2679.51,881639.76,0.00,0.00,0.00),('1','176','920','195519',3817136,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195608',3818594,'2720','409',182141.47,185214.40,0.00,0.00,3072.93,1010729.76,0.00,0.00,0.00),('1','176','920','195608',3818595,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195781',3821485,'2720','409',185214.40,187141.47,0.00,0.00,1927.07,632378.96,0.00,0.00,0.00),('1','176','920','195781',3821486,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','195876',3823145,'2720','409',187141.47,190023.03,0.00,0.00,2881.56,948129.12,0.00,0.00,0.00),('1','176','920','195876',3823146,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196004',3825601,'2720','409',190023.03,191820.53,0.00,0.00,1797.50,590120.00,0.00,0.00,0.00),('1','176','920','196004',3825602,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196083',3826862,'2720','409',191820.53,191820.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196083',3826863,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196089',3827005,'2720','409',191820.53,194034.66,0.00,0.00,2214.13,727810.96,0.00,0.00,0.00),('1','176','920','196089',3827006,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196232',3829938,'2720','409',194034.66,196820.53,0.00,0.00,2785.87,914704.72,0.00,0.00,0.00),('1','176','920','196232',3829939,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196313',3831417,'2720','409',196820.53,199776.39,0.00,0.00,2955.86,972079.04,0.00,0.00,0.00),('1','176','920','196313',3831418,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196443',3833778,'2720','409',199776.39,201820.53,0.00,0.00,2044.14,671518.08,0.00,0.00,0.00),('1','176','920','196443',3833779,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196522',3835120,'2720','409',201820.53,204160.36,0.00,0.00,2339.83,768678.64,0.00,0.00,0.00),('1','176','920','196522',3835121,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196678',3837836,'2720','409',204160.36,206820.53,0.00,0.00,2660.17,872835.76,0.00,0.00,0.00),('1','176','920','196678',3837837,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196755',3839201,'2720','409',206820.53,210148.58,0.00,0.00,3328.05,1081108.36,0.00,0.00,0.00),('1','176','920','196755',3839202,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196905',3841838,'2720','409',210148.58,211820.53,0.00,0.00,1671.95,543197.76,0.00,0.00,0.00),('1','176','920','196905',3841839,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','196957',3842837,'2720','409',211820.53,212311.83,0.00,0.00,491.30,159321.20,0.00,0.00,0.00),('1','176','920','196957',3842838,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197033',3844294,'2720','409',212311.83,216581.09,0.00,0.00,4269.26,1387405.80,0.00,0.00,0.00),('1','176','920','197033',3844295,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197177',3846777,'2720','409',216581.09,216581.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197177',3846778,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197319',3849766,'2720','409',216581.09,221581.09,0.00,0.00,5000.00,1622102.24,0.00,0.00,0.00),('1','176','920','197319',3849767,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197394',3850350,'2720','409',221581.09,222696.58,0.00,0.00,1115.49,362118.76,0.00,0.00,0.00),('1','176','920','197394',3850351,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197424',3850658,'2720','409',222696.58,226581.10,0.00,0.00,3884.52,1261253.16,0.00,0.00,0.00),('1','176','920','197424',3850659,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197513',3852431,'2720','409',226581.10,229932.28,0.00,0.00,3351.18,1089371.36,0.00,0.00,0.00),('1','176','920','197513',3852432,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197882',3858967,'2720','409',229932.28,231581.10,0.00,0.00,1648.82,536210.72,0.00,0.00,0.00),('1','176','920','197882',3858968,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','197952',3860209,'2720','409',231581.10,234652.44,0.00,0.00,3071.34,997850.60,0.00,0.00,0.00),('1','176','920','197952',3860210,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198130',3863242,'2720','409',234652.44,236581.10,0.00,0.00,1928.66,625842.32,0.00,0.00,0.00),('1','176','920','198130',3863243,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198205',3864474,'2720','409',236581.10,237830.01,0.00,0.00,1248.91,405618.16,0.00,0.00,0.00),('1','176','920','198205',3864475,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198347',3867045,'2720','409',237830.01,241147.22,0.00,0.00,3317.21,1066824.32,0.00,0.00,0.00),('1','176','920','198347',3867046,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198518',3870065,'2720','409',241147.22,241147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198518',3870066,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198521',3870106,'2720','409',241147.22,241603.49,0.00,0.00,456.27,146998.40,0.00,0.00,0.00),('1','176','920','198521',3870107,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198573',3870867,'2720','409',241603.49,245559.38,0.00,0.00,3955.89,1273289.92,0.00,0.00,0.00),('1','176','920','198573',3870868,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198786',3874411,'2720','409',245559.38,246147.22,0.00,0.00,587.84,189499.52,0.00,0.00,0.00),('1','176','920','198786',3874412,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198808',3874714,'2720','409',246147.22,251147.22,0.00,0.00,5000.00,1605397.76,0.00,0.00,0.00),('1','176','920','198808',3874715,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198949',3877368,'2720','409',251147.22,251634.72,0.00,0.00,487.50,156000.00,0.00,0.00,0.00),('1','176','920','198949',3877369,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','198987',3877923,'2720','409',251634.72,255423.25,0.00,0.00,3788.53,1216720.64,0.00,0.00,0.00),('1','176','920','198987',3877924,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199210',3881943,'2720','409',255423.25,256147.22,0.00,0.00,723.97,232070.40,0.00,0.00,0.00),('1','176','920','199210',3881944,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199244',3882420,'2720','409',256147.22,260153.09,0.00,0.00,4005.87,1288626.24,0.00,0.00,0.00),('1','176','920','199244',3882421,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199434',3885497,'2720','409',260153.09,261147.22,0.00,0.00,994.13,318521.60,0.00,0.00,0.00),('1','176','920','199434',3885498,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199480',3886065,'2720','409',261147.22,263593.16,0.00,0.00,2445.94,788810.88,0.00,0.00,0.00),('1','176','920','199480',3886066,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199648',3889214,'2720','409',263593.16,265716.97,0.00,0.00,2123.81,680019.20,0.00,0.00,0.00),('1','176','920','199648',3889215,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199770',3890878,'2720','409',265716.97,265716.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199770',3890879,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199771',3890880,'2720','409',265716.97,268484.67,0.00,0.00,2767.70,889296.00,0.00,0.00,0.00),('1','176','920','199771',3890881,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','199865',3892477,'2720','409',268484.67,270716.97,0.00,0.00,2232.30,715763.84,0.00,0.00,0.00),('1','176','920','199865',3892478,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200056',3896163,'2720','409',270716.97,270966.18,0.00,0.00,249.21,79747.20,0.00,0.00,0.00),('1','176','920','200056',3896164,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200094',3896761,'2720','409',270966.18,275278.00,0.00,0.00,4311.82,1383204.80,0.00,0.00,0.00),('1','176','920','200094',3896762,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200292',3900203,'2720','409',275278.00,275770.00,0.00,0.00,492.00,157440.00,0.00,0.00,0.00),('1','176','920','200292',3900204,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200299',3900253,'2720','409',275770.00,280770.00,0.00,0.00,5000.00,1604123.20,0.00,0.00,0.00),('1','176','920','200299',3900254,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200453',3903298,'2720','409',280770.00,280988.00,0.00,0.00,218.00,69760.00,0.00,0.00,0.00),('1','176','920','200453',3903299,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200485',3903938,'2720','409',280988.00,285167.66,0.00,0.00,4179.66,1344319.04,0.00,0.00,0.00),('1','176','920','200485',3903939,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200692',3907491,'2720','409',285167.66,285770.00,0.00,0.00,602.34,192748.80,0.00,0.00,0.00),('1','176','920','200692',3907492,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200725',3907955,'2720','409',285770.00,290025.09,0.00,0.00,4255.09,1363020.80,0.00,0.00,0.00),('1','176','920','200725',3907956,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200864',3910661,'2720','409',290025.09,290025.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200864',3910662,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','200916',3911453,'2720','409',290025.09,294027.87,0.00,0.00,4002.78,1285136.64,0.00,0.00,0.00),('1','176','920','200916',3911454,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201105',3914603,'2720','409',294027.87,295025.10,0.00,0.00,997.23,319709.12,0.00,0.00,0.00),('1','176','920','201105',3914604,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201158',3915223,'2720','409',295025.10,299167.03,0.00,0.00,4141.93,1328807.36,0.00,0.00,0.00),('1','176','920','201158',3915224,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201309',3918015,'2720','409',299167.03,300025.10,0.00,0.00,858.07,274673.28,0.00,0.00,0.00),('1','176','920','201309',3918016,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201344',3918447,'2720','409',300025.10,302991.17,0.00,0.00,2966.07,955424.64,0.00,0.00,0.00),('1','176','920','201344',3918448,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201507',3921568,'2720','409',302991.17,305025.07,0.00,0.00,2033.90,651548.80,0.00,0.00,0.00),('1','176','920','201507',3921569,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201548',3922214,'2720','409',305025.07,308820.93,0.00,0.00,3795.86,1217166.72,0.00,0.00,0.00),('1','176','920','201548',3922215,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201762',3926598,'2720','409',308820.93,310025.07,0.00,0.00,1204.14,405391.04,0.00,0.00,0.00),('1','176','920','201762',3926599,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','201815',3927453,'2720','409',310025.07,313071.16,0.00,0.00,3046.09,1026235.68,0.00,0.00,0.00),('1','176','920','201815',3927454,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202051',3931815,'2720','409',313071.16,314379.96,0.00,0.00,1308.80,440012.80,0.00,0.00,0.00),('1','176','920','202051',3931816,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202117',3933055,'2720','409',314379.96,314379.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202117',3933056,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202133',3933355,'2720','409',314379.96,316861.03,0.00,0.00,2481.07,835223.20,0.00,0.00,0.00),('1','176','920','202133',3933356,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202259',3935318,'2720','409',316861.03,319427.16,0.00,0.00,2566.13,862669.76,0.00,0.00,0.00),('1','176','920','202259',3935319,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202361',3937293,'2720','409',319427.16,319427.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202361',3937294,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202365',3937398,'2720','409',319427.16,320661.28,0.00,0.00,1234.12,415362.24,0.00,0.00,0.00),('1','176','920','202365',3937399,'2721','409',86.00,86.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202442',3938588,'2720','409',320661.28,324484.60,0.00,0.00,3823.32,1287032.64,0.00,0.00,0.00),('1','176','920','202442',3938589,'2721','409',86.00,136.00,0.00,0.00,50.00,16800.00,0.00,0.00,0.00),('1','176','920','202652',3942264,'2720','409',324484.60,324484.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202652',3942265,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202657',3942325,'2720','409',324484.60,324757.09,0.00,0.00,272.49,95916.48,0.00,0.00,0.00),('1','176','920','202657',3942326,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','202854',3945943,'2720','409',324757.09,325038.04,0.00,0.00,280.95,98894.40,0.00,0.00,0.00),('1','176','920','202854',3945944,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203107',3950811,'2720','409',325038.04,328306.06,0.00,0.00,3268.02,1101400.32,0.00,0.00,0.00),('1','176','920','203107',3950812,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203313',3954564,'2720','409',328306.06,328575.08,0.00,0.00,269.02,94695.04,0.00,0.00,0.00),('1','176','920','203313',3954565,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203521',3958268,'2720','409',328575.08,328905.90,0.00,0.00,330.82,116448.64,0.00,0.00,0.00),('1','176','920','203521',3958269,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203724',3961985,'2720','409',328905.90,329593.06,0.00,0.00,687.16,236812.16,0.00,0.00,0.00),('1','176','920','203724',3961986,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203834',3963840,'2720','409',329593.06,329593.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203834',3963841,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203836',3963862,'2720','409',329593.06,331404.75,0.00,0.00,1811.69,611577.04,0.00,0.00,0.00),('1','176','920','203836',3963863,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','203961',3966107,'2720','409',331404.75,334102.77,0.00,0.00,2698.02,933998.56,0.00,0.00,0.00),('1','176','920','203961',3966108,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204199',3970426,'2720','409',334102.77,334680.41,0.00,0.00,577.64,198708.16,0.00,0.00,0.00),('1','176','920','204199',3970427,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204257',3971355,'2720','409',334680.41,334680.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204257',3971356,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204267',3971607,'2720','409',334680.41,336665.21,0.00,0.00,1984.80,689452.80,0.00,0.00,0.00),('1','176','920','204267',3971608,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204405',3974055,'2720','409',336665.21,339050.18,0.00,0.00,2384.97,824162.48,0.00,0.00,0.00),('1','176','920','204405',3974056,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204613',3978007,'2720','409',339050.18,339837.68,0.00,0.00,787.50,271492.00,0.00,0.00,0.00),('1','176','920','204613',3978008,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204689',3979155,'2720','409',339837.68,339837.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204689',3979156,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204701',3979414,'2720','409',339837.68,342013.44,0.00,0.00,2175.76,751845.76,0.00,0.00,0.00),('1','176','920','204701',3979415,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204837',3981589,'2720','409',342013.44,344803.61,0.00,0.00,2790.17,965068.72,0.00,0.00,0.00),('1','176','920','204837',3981590,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204978',3983993,'2720','409',344803.61,344803.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204978',3983994,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','204984',3984133,'2720','409',344803.61,345601.74,0.00,0.00,798.13,275264.88,0.00,0.00,0.00),('1','176','920','204984',3984134,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205037',3985195,'2720','409',345601.74,349015.36,0.00,0.00,3413.62,1181268.96,0.00,0.00,0.00),('1','176','920','205037',3985196,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205247',3988893,'2720','409',349015.36,349925.36,0.00,0.00,910.00,313632.00,0.00,0.00,0.00),('1','176','920','205247',3988894,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205341',3990626,'2720','409',349925.36,349925.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205341',3990627,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205344',3990681,'2720','409',349925.36,350511.36,0.00,0.00,586.00,203584.00,0.00,0.00,0.00),('1','176','920','205344',3990682,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205470',3993099,'2720','409',350511.36,354724.73,0.00,0.00,4213.37,1454726.64,0.00,0.00,0.00),('1','176','920','205470',3993100,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205726',3997709,'2720','409',354724.73,355196.13,0.00,0.00,471.40,162161.60,0.00,0.00,0.00),('1','176','920','205726',3997710,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205785',3998696,'2720','409',355196.13,355196.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205785',3998697,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205788',3998728,'2720','409',355196.13,358110.24,0.00,0.00,2914.11,1005641.36,0.00,0.00,0.00),('1','176','920','205788',3998729,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','205939',4001550,'2720','409',358110.24,360245.10,0.00,0.00,2134.86,740108.96,0.00,0.00,0.00),('1','176','920','205939',4001551,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206081',4004019,'2720','409',360245.10,360245.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206081',4004020,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206087',4004145,'2720','409',360245.10,360870.04,0.00,0.00,624.94,216196.96,0.00,0.00,0.00),('1','176','920','206087',4004146,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206150',4005247,'2720','409',360870.04,363993.31,0.00,0.00,3123.27,1078557.52,0.00,0.00,0.00),('1','176','920','206150',4005248,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206360',4008842,'2720','409',363993.31,365245.11,0.00,0.00,1251.80,433374.72,0.00,0.00,0.00),('1','176','920','206360',4008843,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206406',4009529,'2720','409',365245.11,369598.83,0.00,0.00,4353.72,1501878.72,0.00,0.00,0.00),('1','176','920','206406',4009530,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206569',4012554,'2720','409',369598.83,370245.11,0.00,0.00,646.28,223280.32,0.00,0.00,0.00),('1','176','920','206569',4012555,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206606',4013046,'2720','409',370245.11,374532.22,0.00,0.00,4287.11,1478226.64,0.00,0.00,0.00),('1','176','920','206606',4013047,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206797',4016514,'2720','409',374532.22,375245.11,0.00,0.00,712.89,245383.28,0.00,0.00,0.00),('1','176','920','206797',4016515,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','206860',4017445,'2720','409',375245.11,378656.56,0.00,0.00,3411.45,1176369.20,0.00,0.00,0.00),('1','176','920','206860',4017446,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207020',4020626,'2720','409',378656.56,380245.12,0.00,0.00,1588.56,549273.28,0.00,0.00,0.00),('1','176','920','207020',4020627,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207115',4022128,'2720','409',380245.12,382079.66,0.00,0.00,1834.54,633263.84,0.00,0.00,0.00),('1','176','920','207115',4022129,'2721','409',136.00,136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207246',4024685,'2720','409',382079.66,383745.42,0.00,0.00,1665.76,574309.76,0.00,0.00,0.00),('1','176','920','207246',4024686,'2721','409',136.00,236.00,0.00,0.00,100.00,34400.00,0.00,0.00,0.00),('1','176','920','207354',4026345,'2720','409',383745.42,383745.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207354',4026346,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207387',4027010,'2720','409',383745.42,385147.28,0.00,0.00,1401.86,485309.60,0.00,0.00,0.00),('1','176','920','207387',4027011,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207476',4028784,'2720','409',385147.28,388943.90,0.00,0.00,3796.62,1310716.32,0.00,0.00,0.00),('1','176','920','207476',4028785,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207657',4031863,'2720','409',388943.90,388943.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207657',4031864,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207719',4032779,'2720','409',388943.90,391493.00,0.00,0.00,2549.10,902192.00,0.00,0.00,0.00),('1','176','920','207719',4032780,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','207901',4036031,'2720','409',391493.00,394165.93,0.00,0.00,2672.93,945495.36,0.00,0.00,0.00),('1','176','920','207901',4036032,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208060',4038707,'2720','409',394165.93,394165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208060',4038708,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208110',4039607,'2720','409',394165.93,398995.09,0.00,0.00,4829.16,1711465.28,0.00,0.00,0.00),('1','176','920','208110',4039608,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208281',4042983,'2720','409',398995.09,398995.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208281',4042984,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208318',4043436,'2720','409',398995.09,404133.52,0.00,0.00,5138.43,1816376.32,0.00,0.00,0.00),('1','176','920','208318',4043437,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208554',4047483,'2720','409',404133.52,408415.22,0.00,0.00,4281.70,1511066.56,0.00,0.00,0.00),('1','176','920','208554',4047484,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208756',4051062,'2720','409',408415.22,409105.93,0.00,0.00,690.71,243696.64,0.00,0.00,0.00),('1','176','920','208756',4051063,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208797',4051470,'2720','409',409105.93,409105.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208797',4051471,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208800',4051474,'2720','409',409105.93,409105.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208800',4051475,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208805',4051573,'2720','409',409105.93,412900.45,0.00,0.00,3794.52,1340767.04,0.00,0.00,0.00),('1','176','920','208805',4051574,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208990',4055092,'2720','409',412900.45,413184.45,0.00,0.00,284.00,99968.00,0.00,0.00,0.00),('1','176','920','208990',4055093,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','208993',4055097,'2720','409',413184.45,414288.26,0.00,0.00,1103.81,411754.12,0.00,0.00,0.00),('1','176','920','208993',4055098,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209126',4057278,'2720','409',414288.26,414288.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209126',4057279,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209127',4057280,'2720','409',414288.26,415326.51,0.00,0.00,1038.25,388784.00,0.00,0.00,0.00),('1','176','920','209127',4057281,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209207',4058915,'2720','409',415326.51,418288.24,0.00,0.00,2961.73,1105893.56,0.00,0.00,0.00),('1','176','920','209207',4058916,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209429',4062809,'2720','409',418288.24,419638.99,0.00,0.00,1350.75,507540.00,0.00,0.00,0.00),('1','176','920','209429',4062810,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209540',4064632,'2720','409',419638.99,419638.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209540',4064633,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209547',4064732,'2720','409',419638.99,421862.64,0.00,0.00,2223.65,828905.80,0.00,0.00,0.00),('1','176','920','209547',4064733,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209647',4066604,'2720','409',421862.64,424837.65,0.00,0.00,2975.01,1109013.72,0.00,0.00,0.00),('1','176','920','209647',4066605,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209799',4069455,'2720','409',424837.65,424837.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209799',4069456,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209804',4069578,'2720','409',424837.65,425576.68,0.00,0.00,739.03,275395.16,0.00,0.00,0.00),('1','176','920','209804',4069579,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','209857',4070389,'2720','409',425576.68,429172.97,0.00,0.00,3596.29,1357829.56,0.00,0.00,0.00),('1','176','920','209857',4070390,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210101',4074757,'2720','409',429172.97,429376.64,0.00,0.00,203.67,85541.40,0.00,0.00,0.00),('1','176','920','210101',4074758,'2721','409',236.00,236.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210311',4078371,'2720','409',429376.64,429663.04,0.00,0.00,286.40,120288.00,0.00,0.00,0.00),('1','176','920','210311',4078372,'2721','409',236.00,247.19,0.00,0.00,11.19,4699.80,0.00,0.00,0.00),('1','176','920','210516',4082226,'2720','409',429663.04,429878.09,0.00,0.00,215.05,90321.00,0.00,0.00,0.00),('1','176','920','210516',4082227,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210725',4085939,'2720','409',429878.09,430158.83,0.00,0.00,280.74,117910.80,0.00,0.00,0.00),('1','176','920','210725',4085940,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210968',4089866,'2720','409',430158.83,430318.53,0.00,0.00,159.70,67074.00,0.00,0.00,0.00),('1','176','920','210968',4089867,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210971',4089885,'2720','409',430318.53,430318.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','210971',4089886,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211019',4090664,'2720','409',430318.53,430349.53,0.00,0.00,31.00,13020.00,0.00,0.00,0.00),('1','176','920','211019',4090665,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211186',4093730,'2720','409',430349.53,433572.07,0.00,0.00,3222.54,1267981.60,0.00,0.00,0.00),('1','176','920','211186',4093731,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211371',4097268,'2720','409',433572.07,435282.86,0.00,0.00,1710.79,672240.88,0.00,0.00,0.00),('1','176','920','211371',4097269,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211456',4098652,'2720','409',435282.86,435282.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211456',4098653,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211562',4100583,'2720','409',435282.86,435911.99,0.00,0.00,629.13,249558.48,0.00,0.00,0.00),('1','176','920','211562',4100584,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211636',4101785,'2720','409',435911.99,437320.44,0.00,0.00,1408.45,553881.68,0.00,0.00,0.00),('1','176','920','211636',4101786,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211775',4104077,'2720','409',437320.44,439083.67,0.00,0.00,1763.23,696432.88,0.00,0.00,0.00),('1','176','920','211775',4104078,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','211986',4107846,'2720','409',439083.67,439240.17,0.00,0.00,156.50,66356.00,0.00,0.00,0.00),('1','176','920','211986',4107847,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','212223',4112074,'2720','409',439240.17,439448.31,0.00,0.00,208.14,88251.36,0.00,0.00,0.00),('1','176','920','212223',4112075,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','212454',4116292,'2720','409',439448.31,439695.66,0.00,0.00,247.35,104876.40,0.00,0.00,0.00),('1','176','920','212454',4116293,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','212664',4120056,'2720','409',439695.66,440041.89,0.00,0.00,346.23,146801.52,0.00,0.00,0.00),('1','176','920','212664',4120057,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','212863',4123572,'2720','409',440041.89,440165.54,0.00,0.00,123.65,52427.60,0.00,0.00,0.00),('1','176','920','212863',4123573,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213130',4128152,'2720','409',440165.54,440274.11,0.00,0.00,108.57,46033.68,0.00,0.00,0.00),('1','176','920','213130',4128153,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213271',4130373,'2720','409',440274.11,440274.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213271',4130374,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213319',4131191,'2720','409',440274.11,440661.73,0.00,0.00,387.62,153470.88,0.00,0.00,0.00),('1','176','920','213319',4131192,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213386',4132365,'2720','409',440661.73,443356.18,0.00,0.00,2694.45,1060869.20,0.00,0.00,0.00),('1','176','920','213386',4132366,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213628',4136392,'2720','409',443356.18,445025.76,0.00,0.00,1669.58,658554.72,0.00,0.00,0.00),('1','176','920','213628',4136393,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213877',4140501,'2720','409',445025.76,445230.76,0.00,0.00,205.00,80360.00,0.00,0.00,0.00),('1','176','920','213877',4140502,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213909',4140866,'2720','409',445230.76,445230.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213909',4140867,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','213917',4140945,'2720','409',445230.76,448458.35,0.00,0.00,3227.59,1268953.84,0.00,0.00,0.00),('1','176','920','213917',4140946,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214091',4144123,'2720','409',448458.35,450539.36,0.00,0.00,2081.01,817644.24,0.00,0.00,0.00),('1','176','920','214091',4144124,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214175',4145366,'2720','409',450539.36,450539.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214175',4145367,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214267',4147264,'2720','409',450539.36,450910.72,0.00,0.00,371.36,147973.12,0.00,0.00,0.00),('1','176','920','214267',4147265,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214328',4148260,'2720','409',450910.72,454711.92,0.00,0.00,3801.20,1495415.68,0.00,0.00,0.00),('1','176','920','214328',4148261,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214522',4151536,'2720','409',454711.92,455665.99,0.00,0.00,954.07,374557.68,0.00,0.00,0.00),('1','176','920','214522',4151537,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214634',4153271,'2720','409',455665.99,455665.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214634',4153272,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214645',4153500,'2720','409',455665.99,459382.99,0.00,0.00,3717.00,1461344.32,0.00,0.00,0.00),('1','176','920','214645',4153501,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214770',4155835,'2720','409',459382.99,460734.89,0.00,0.00,1351.90,532608.80,0.00,0.00,0.00),('1','176','920','214770',4155836,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214875',4157530,'2720','409',460734.89,460734.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214875',4157531,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','214929',4158397,'2720','409',460734.89,462144.63,0.00,0.00,1409.74,554908.64,0.00,0.00,0.00),('1','176','920','214929',4158398,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215022',4159876,'2720','409',462144.63,465460.72,0.00,0.00,3316.09,1304441.36,0.00,0.00,0.00),('1','176','920','215022',4159877,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215191',4162892,'2720','409',465460.72,465460.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215191',4162893,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215223',4163498,'2720','409',465460.72,465705.71,0.00,0.00,244.99,105978.88,0.00,0.00,0.00),('1','176','920','215223',4163499,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215436',4167061,'2720','409',465705.71,466437.38,0.00,0.00,731.67,309339.52,0.00,0.00,0.00),('1','176','920','215436',4167062,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215670',4171064,'2720','409',466437.38,467372.64,0.00,0.00,935.26,394580.48,0.00,0.00,0.00),('1','176','920','215670',4171065,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','215900',4175025,'2720','409',467372.64,469479.30,0.00,0.00,2106.66,882128.64,0.00,0.00,0.00),('1','176','920','215900',4175026,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216175',4179601,'2720','409',469479.30,470529.11,0.00,0.00,1049.81,439077.76,0.00,0.00,0.00),('1','176','920','216175',4179602,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216286',4181724,'2720','409',470529.11,470529.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216286',4181725,'2721','409',247.19,247.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216418',4183764,'2720','409',470529.11,472409.19,0.00,0.00,1880.08,788900.72,0.00,0.00,0.00),('1','176','920','216418',4183765,'2721','409',247.19,285.19,0.00,0.00,38.00,15808.00,0.00,0.00,0.00),('1','176','920','216548',4186252,'2720','409',472409.19,474193.50,0.00,0.00,1784.31,747755.76,0.00,0.00,0.00),('1','176','920','216548',4186253,'2721','409',285.19,285.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216781',4190448,'2720','409',474193.50,475694.40,0.00,0.00,1500.90,627635.64,0.00,0.00,0.00),('1','176','920','216781',4190449,'2721','409',285.19,285.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216879',4191917,'2720','409',475694.40,475694.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','216879',4191918,'2721','409',285.19,285.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217018',4194462,'2720','409',475694.40,476600.42,0.00,0.00,906.02,402889.60,0.00,0.00,0.00),('1','176','920','217018',4194463,'2721','409',285.19,285.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217271',4199315,'2720','409',476600.42,480141.27,0.00,0.00,3540.85,1563729.20,0.00,0.00,0.00),('1','176','920','217271',4199316,'2721','409',285.19,333.19,0.00,0.00,48.00,21120.00,0.00,0.00,0.00),('1','176','920','217506',4203268,'2720','409',480141.27,480689.08,0.00,0.00,547.81,242336.40,0.00,0.00,0.00),('1','176','920','217506',4203269,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217530',4203556,'2720','409',480689.08,480689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217530',4203557,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217608',4205011,'2720','409',480689.08,482348.34,0.00,0.00,1659.26,733441.20,0.00,0.00,0.00),('1','176','920','217608',4205012,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217705',4206691,'2720','409',482348.34,485642.92,0.00,0.00,3294.58,1454674.40,0.00,0.00,0.00),('1','176','920','217705',4206692,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','217979',4211704,'2720','409',485642.92,485961.74,0.00,0.00,318.82,141439.20,0.00,0.00,0.00),('1','176','920','217979',4211705,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218091',4213441,'2720','409',485961.74,485961.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218091',4213442,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218096',4213517,'2720','409',485961.74,487393.97,0.00,0.00,1432.23,633356.00,0.00,0.00,0.00),('1','176','920','218096',4213518,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218214',4215716,'2720','409',487393.97,490205.75,0.00,0.00,2811.78,1244093.20,0.00,0.00,0.00),('1','176','920','218214',4215717,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218453',4219863,'2720','409',490205.75,491065.54,0.00,0.00,859.79,379499.20,0.00,0.00,0.00),('1','176','920','218453',4219864,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218543',4221565,'2720','409',491065.54,491065.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218543',4221566,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218544',4221567,'2720','409',491065.54,492739.34,0.00,0.00,1673.80,740455.20,0.00,0.00,0.00),('1','176','920','218544',4221568,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218672',4223981,'2720','409',492739.34,496257.07,0.00,0.00,3517.73,1553237.20,0.00,0.00,0.00),('1','176','920','218672',4223982,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218821',4226465,'2720','409',496257.07,496257.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','218821',4226466,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219030',4229940,'2720','409',496257.07,498633.06,0.00,0.00,2375.99,1046918.80,0.00,0.00,0.00),('1','176','920','219030',4229941,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219112',4231520,'2720','409',498633.06,501564.66,0.00,0.00,2931.60,1292974.80,0.00,0.00,0.00),('1','176','920','219112',4231521,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219295',4234754,'2720','409',501564.66,501564.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219295',4234755,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219326',4235281,'2720','409',501564.66,505338.78,0.00,0.00,3774.12,1666132.80,0.00,0.00,0.00),('1','176','920','219326',4235282,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219591',4239757,'2720','409',505338.78,506564.67,0.00,0.00,1225.89,540350.00,0.00,0.00,0.00),('1','176','920','219591',4239758,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219673',4240993,'2720','409',506564.67,509149.88,0.00,0.00,2585.21,1139825.20,0.00,0.00,0.00),('1','176','920','219673',4240994,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219806',4243697,'2720','409',509149.88,511564.67,0.00,0.00,2414.79,1067620.80,0.00,0.00,0.00),('1','176','920','219806',4243698,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','219969',4246665,'2720','409',511564.67,512598.45,0.00,0.00,1033.78,457571.60,0.00,0.00,0.00),('1','176','920','219969',4246666,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220035',4247849,'2720','409',512598.45,514196.20,0.00,0.00,1597.75,704976.80,0.00,0.00,0.00),('1','176','920','220035',4247850,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220107',4248974,'2720','409',514196.20,515836.34,0.00,0.00,1640.14,713960.64,0.00,0.00,0.00),('1','176','920','220107',4248975,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220241',4251423,'2720','409',515836.34,516564.67,0.00,0.00,728.33,314638.56,0.00,0.00,0.00),('1','176','920','220241',4251424,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220271',4251699,'2720','409',516564.67,518477.16,0.00,0.00,1912.49,835219.20,0.00,0.00,0.00),('1','176','920','220271',4251700,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220458',4255488,'2720','409',518477.16,521564.67,0.00,0.00,3087.51,1343054.40,0.00,0.00,0.00),('1','176','920','220458',4255489,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220635',4258429,'2720','409',521564.67,522040.53,0.00,0.00,475.86,206271.36,0.00,0.00,0.00),('1','176','920','220635',4258430,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220678',4259200,'2720','409',522040.53,526054.48,0.00,0.00,4013.95,1744785.12,0.00,0.00,0.00),('1','176','920','220678',4259201,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220843',4262105,'2720','409',526054.48,526054.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220843',4262106,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220847',4262162,'2720','409',526054.48,526474.88,0.00,0.00,420.40,181612.80,0.00,0.00,0.00),('1','176','920','220847',4262163,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','220906',4263229,'2720','409',526474.88,531054.72,0.00,0.00,4579.84,1988849.28,0.00,0.00,0.00),('1','176','920','220906',4263230,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221096',4266660,'2720','409',531054.72,531672.72,0.00,0.00,618.00,266976.00,0.00,0.00,0.00),('1','176','920','221096',4266661,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221150',4267427,'2720','409',531672.72,536054.72,0.00,0.00,4382.00,1901897.76,0.00,0.00,0.00),('1','176','920','221150',4267428,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221330',4270783,'2720','409',536054.72,536218.27,0.00,0.00,163.55,71923.68,0.00,0.00,0.00),('1','176','920','221330',4270784,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221397',4271875,'2720','409',536218.27,539647.64,0.00,0.00,3429.37,1489068.48,0.00,0.00,0.00),('1','176','920','221397',4271876,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221623',4276107,'2720','409',539647.64,541054.72,0.00,0.00,1407.08,608774.40,0.00,0.00,0.00),('1','176','920','221623',4276108,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221640',4276271,'2720','409',541054.72,546054.72,0.00,0.00,5000.00,2172080.16,0.00,0.00,0.00),('1','176','920','221640',4276272,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221750',4278380,'2720','409',546054.72,548050.09,0.00,0.00,1995.37,864595.68,0.00,0.00,0.00),('1','176','920','221750',4278381,'2721','409',333.19,333.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221834',4279837,'2720','409',548050.09,550492.89,0.00,0.00,2442.80,1059225.60,0.00,0.00,0.00),('1','176','920','221834',4279838,'2721','409',333.19,393.19,0.00,0.00,60.00,25920.00,0.00,0.00,0.00),('1','176','920','221974',4282352,'2720','409',550492.89,550492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221974',4282353,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','221978',4282414,'2720','409',550492.89,552964.65,0.00,0.00,2471.76,1074690.24,0.00,0.00,0.00),('1','176','920','221978',4282415,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222057',4283989,'2720','409',552964.65,555519.44,0.00,0.00,2554.79,1110275.04,0.00,0.00,0.00),('1','176','920','222057',4283990,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222133',4285149,'2720','409',555519.44,555519.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222133',4285150,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222156',4285575,'2720','409',555519.44,558454.60,0.00,0.00,2935.16,1274554.08,0.00,0.00,0.00),('1','176','920','222156',4285576,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222323',4288155,'2720','409',558454.60,559116.28,0.00,0.00,661.68,298646.40,0.00,0.00,0.00),('1','176','920','222323',4288156,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222492',4291335,'2720','409',559116.28,559715.16,0.00,0.00,598.88,271409.76,0.00,0.00,0.00),('1','176','920','222492',4291336,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','222728',4295738,'2720','409',559715.16,559995.29,0.00,0.00,280.13,134462.40,0.00,0.00,0.00),('1','176','920','222728',4295739,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223175',4303727,'2720','409',559995.29,560225.60,0.00,0.00,230.31,110548.80,0.00,0.00,0.00),('1','176','920','223175',4303728,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223177',4303759,'2720','409',560225.60,560225.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223177',4303760,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223178',4303761,'2720','409',560225.60,561400.58,0.00,0.00,1174.98,520142.40,0.00,0.00,0.00),('1','176','920','223178',4303762,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223421',4307977,'2720','409',561400.58,561704.13,0.00,0.00,303.55,136104.00,0.00,0.00,0.00),('1','176','920','223421',4307978,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223520',4309536,'2720','409',561704.13,562080.89,0.00,0.00,376.76,180559.36,0.00,0.00,0.00),('1','176','920','223520',4309537,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223638',4312021,'2720','409',562080.89,564504.40,0.00,0.00,2423.51,1135922.08,0.00,0.00,0.00),('1','176','920','223638',4312022,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223818',4315441,'2720','409',564504.40,564504.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223818',4315442,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223829',4315691,'2720','409',564504.40,565192.51,0.00,0.00,688.11,319283.04,0.00,0.00,0.00),('1','176','920','223829',4315692,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','223864',4316312,'2720','409',565192.51,567723.51,0.00,0.00,2531.00,1187300.80,0.00,0.00,0.00),('1','176','920','223864',4316313,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224075',4319914,'2720','409',567723.51,569589.40,0.00,0.00,1865.89,870810.08,0.00,0.00,0.00),('1','176','920','224075',4319915,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224170',4321349,'2720','409',569589.40,569589.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224170',4321350,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224190',4321777,'2720','409',569589.40,572153.50,0.00,0.00,2564.10,1195349.76,0.00,0.00,0.00),('1','176','920','224190',4321778,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224302',4324052,'2720','409',572153.50,573953.90,0.00,0.00,1800.40,886890.14,0.00,0.00,0.00),('1','176','920','224302',4324053,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224521',4327856,'2720','409',573953.90,574506.74,0.00,0.00,552.84,271978.62,0.00,0.00,0.00),('1','176','920','224521',4327857,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224668',4330243,'2720','409',574506.74,574506.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224668',4330244,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224702',4330777,'2720','409',574506.74,575228.05,0.00,0.00,721.31,354947.36,0.00,0.00,0.00),('1','176','920','224702',4330778,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224781',4332254,'2720','409',575228.05,576879.52,0.00,0.00,1651.47,811861.84,0.00,0.00,0.00),('1','176','920','224781',4332255,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','224891',4334160,'2720','409',576879.52,577983.37,0.00,0.00,1103.85,538277.20,0.00,0.00,0.00),('1','176','920','224891',4334161,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225014',4336513,'2720','409',577983.37,579646.58,0.00,0.00,1663.21,806899.32,0.00,0.00,0.00),('1','176','920','225014',4336514,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225121',4338409,'2720','409',579646.58,579646.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225121',4338410,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225138',4338755,'2720','409',579646.58,581849.48,0.00,0.00,2202.90,1068943.40,0.00,0.00,0.00),('1','176','920','225138',4338756,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225270',4341139,'2720','409',581849.48,584842.66,0.00,0.00,2993.18,1453388.28,0.00,0.00,0.00),('1','176','920','225270',4341140,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225427',4344175,'2720','409',584842.66,584842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225427',4344176,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225475',4345027,'2720','409',584842.66,588056.35,0.00,0.00,3213.69,1560863.28,0.00,0.00,0.00),('1','176','920','225475',4345028,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225689',4348660,'2720','409',588056.35,590113.36,0.00,0.00,2057.01,996631.92,0.00,0.00,0.00),('1','176','920','225689',4348661,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225803',4350440,'2720','409',590113.36,590113.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225803',4350441,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225809',4350522,'2720','409',590113.36,592310.32,0.00,0.00,2196.96,1081973.38,0.00,0.00,0.00),('1','176','920','225809',4350523,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','225965',4353332,'2720','409',592310.32,595537.46,0.00,0.00,3227.14,1595733.88,0.00,0.00,0.00),('1','176','920','225965',4353333,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226186',4357496,'2720','409',595537.46,595537.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226186',4357497,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226234',4358381,'2720','409',595537.46,599357.64,0.00,0.00,3820.18,1883527.90,0.00,0.00,0.00),('1','176','920','226234',4358382,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226468',4362487,'2720','409',599357.64,600801.79,0.00,0.00,1444.15,711097.60,0.00,0.00,0.00),('1','176','920','226468',4362488,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226557',4363771,'2720','409',600801.79,600801.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226557',4363772,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226736',4367300,'2720','409',600801.79,605028.79,0.00,0.00,4227.00,2082236.28,0.00,0.00,0.00),('1','176','920','226736',4367301,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','226948',4371202,'2720','409',605028.79,606063.58,0.00,0.00,1034.79,508049.88,0.00,0.00,0.00),('1','176','920','226948',4371203,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227016',4372155,'2720','409',606063.58,606063.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227016',4372156,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227021',4372216,'2720','409',606063.58,610727.64,0.00,0.00,4664.06,2296976.72,0.00,0.00,0.00),('1','176','920','227021',4372217,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227182',4375241,'2720','409',610727.64,611312.67,0.00,0.00,585.03,290971.20,0.00,0.00,0.00),('1','176','920','227182',4375242,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227223',4375657,'2720','409',611312.67,611312.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227223',4375658,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227271',4376546,'2720','409',611312.67,614295.73,0.00,0.00,2983.06,1469953.30,0.00,0.00,0.00),('1','176','920','227271',4376547,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227360',4378476,'2720','409',614295.73,616584.85,0.00,0.00,2289.12,1125988.80,0.00,0.00,0.00),('1','176','920','227360',4378477,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227532',4381307,'2720','409',616584.85,616584.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227532',4381308,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227538',4381400,'2720','409',616584.85,617833.07,0.00,0.00,1248.22,614069.68,0.00,0.00,0.00),('1','176','920','227538',4381401,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227598',4382482,'2720','409',617833.07,621022.05,0.00,0.00,3188.98,1571979.46,0.00,0.00,0.00),('1','176','920','227598',4382483,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','227835',4386774,'2720','409',621022.05,621507.01,0.00,0.00,484.96,261118.24,0.00,0.00,0.00),('1','176','920','227835',4386775,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228037',4390587,'2720','409',621507.01,621507.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228037',4390588,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228349',4396466,'2720','409',621507.01,623261.63,0.00,0.00,1754.62,904175.84,0.00,0.00,0.00),('1','176','920','228349',4396467,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228533',4399869,'2720','409',623261.63,626128.25,0.00,0.00,2866.62,1480949.76,0.00,0.00,0.00),('1','176','920','228533',4399870,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228751',4404068,'2720','409',626128.25,626622.89,0.00,0.00,494.64,254421.60,0.00,0.00,0.00),('1','176','920','228751',4404069,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228768',4404229,'2720','409',626622.89,626622.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228768',4404230,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228862',4405998,'2720','409',626622.89,628597.40,0.00,0.00,1974.51,1019630.88,0.00,0.00,0.00),('1','176','920','228862',4405999,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','228944',4407474,'2720','409',628597.40,631669.30,0.00,0.00,3071.90,1585412.32,0.00,0.00,0.00),('1','176','920','228944',4407475,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229086',4410509,'2720','409',631669.30,631669.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229086',4410510,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229098',4410683,'2720','409',631669.30,632137.07,0.00,0.00,467.77,242096.96,0.00,0.00,0.00),('1','176','920','229098',4410684,'2721','409',393.19,393.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229162',4411925,'2720','409',632137.07,636949.17,0.00,0.00,4812.10,2475327.68,0.00,0.00,0.00),('1','176','920','229162',4411926,'2721','409',393.19,493.19,0.00,0.00,100.00,51200.00,0.00,0.00,0.00),('1','176','920','229289',4414129,'2720','409',636949.17,636949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229289',4414130,'2721','409',493.19,493.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229409',4416267,'2720','409',636949.17,641040.78,0.00,0.00,4091.61,2187346.60,0.00,0.00,0.00),('1','176','920','229409',4416268,'2721','409',493.19,505.69,0.00,0.00,12.50,7300.00,0.00,0.00,0.00),('1','176','920','229659',4421141,'2720','409',641040.78,642247.85,0.00,0.00,1207.07,645282.28,0.00,0.00,0.00),('1','176','920','229659',4421142,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229765',4422978,'2720','409',642247.85,642247.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229765',4422979,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','229890',4425689,'2720','409',642247.85,642520.02,0.00,0.00,272.17,158947.28,0.00,0.00,0.00),('1','176','920','229890',4425690,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','230091',4429362,'2720','409',642520.02,643684.74,0.00,0.00,1164.72,636405.20,0.00,0.00,0.00),('1','176','920','230091',4429363,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','230285',4433072,'2720','409',643684.74,644237.06,0.00,0.00,552.32,309096.76,0.00,0.00,0.00),('1','176','920','230285',4433073,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','230529',4437622,'2720','409',644237.06,645299.58,0.00,0.00,1062.52,577756.76,0.00,0.00,0.00),('1','176','920','230529',4437623,'2721','409',505.69,505.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','230773',4442041,'2720','409',645299.58,646519.53,0.00,0.00,1219.95,662004.04,0.00,0.00,0.00),('1','176','920','230773',4442042,'2721','409',505.69,509.71,0.00,0.00,4.02,2347.68,0.00,0.00,0.00),('1','176','920','231054',4446885,'2720','409',646519.53,647572.19,0.00,0.00,1052.66,574739.44,0.00,0.00,0.00),('1','176','920','231054',4446886,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','231329',4451333,'2720','409',647572.19,647572.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','231329',4451334,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','231388',4451979,'2720','409',647572.19,647810.83,0.00,0.00,238.64,139365.76,0.00,0.00,0.00),('1','176','920','231388',4451980,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','231630',4456361,'2720','409',647810.83,648199.29,0.00,0.00,388.46,226860.64,0.00,0.00,0.00),('1','176','920','231630',4456362,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','231879',4460916,'2720','409',648199.29,648539.56,0.00,0.00,340.27,198717.68,0.00,0.00,0.00),('1','176','920','231879',4460917,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232101',4464906,'2720','409',648539.56,648892.92,0.00,0.00,353.36,206362.24,0.00,0.00,0.00),('1','176','920','232101',4464907,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232328',4468886,'2720','409',648892.92,649011.66,0.00,0.00,118.74,69344.16,0.00,0.00,0.00),('1','176','920','232328',4468887,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232458',4471254,'2720','409',649011.66,650939.32,0.00,0.00,1927.66,1082337.44,0.00,0.00,0.00),('1','176','920','232458',4471255,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232580',4473566,'2720','409',650939.32,652796.69,0.00,0.00,1857.37,1045834.00,0.00,0.00,0.00),('1','176','920','232580',4473567,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232695',4475634,'2720','409',652796.69,652796.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232695',4475635,'2721','409',509.71,509.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','232696',4475636,'2720','409',652796.69,654823.52,0.00,0.00,2026.83,1140871.20,0.00,0.00,0.00),('1','176','920','232696',4475637,'2721','409',509.71,539.71,0.00,0.00,30.00,16800.00,0.00,0.00,0.00),('1','176','920','232833',4478112,'2720','409',654823.52,657942.21,0.00,0.00,3118.69,1752892.80,0.00,0.00,0.00),('1','176','920','232833',4478113,'2721','409',539.71,539.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','233029',4481570,'2720','409',657942.21,657942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','233029',4481571,'2721','409',539.71,539.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','233041',4481798,'2720','409',657942.21,658416.48,0.00,0.00,474.27,266917.60,0.00,0.00,0.00),('1','176','920','233041',4481799,'2721','409',539.71,587.71,0.00,0.00,48.00,26880.00,0.00,0.00,0.00),('1','176','920','233097',4482893,'2720','409',658416.48,663103.31,0.00,0.00,4686.83,2634658.00,0.00,0.00,0.00),('1','176','920','233097',4482894,'2721','409',587.71,592.71,0.00,0.00,5.00,3000.00,0.00,0.00,0.00),('1','176','920','233317',4486921,'2720','409',663103.31,663103.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','233317',4486922,'2721','409',592.71,592.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','233397',4488106,'2720','409',663103.31,663976.31,0.00,0.00,873.00,516323.54,0.00,0.00,0.00),('1','176','920','233397',4488107,'2721','409',592.71,605.21,0.00,0.00,12.50,7800.00,0.00,0.00,0.00),('1','176','920','233614',4492133,'2720','409',663976.31,664716.65,0.00,0.00,740.34,440824.58,0.00,0.00,0.00),('1','176','920','233614',4492134,'2721','409',605.21,639.02,0.00,0.00,33.81,21097.44,0.00,0.00,0.00),('1','176','920','233841',4496198,'2720','409',664716.65,666640.11,0.00,0.00,1923.46,1127142.28,0.00,0.00,0.00),('1','176','920','233841',4496199,'2721','409',639.02,660.66,0.00,0.00,21.64,13503.36,0.00,0.00,0.00),('1','176','920','234034',4499712,'2720','409',666640.11,667996.02,0.00,0.00,1355.91,787210.14,0.00,0.00,0.00),('1','176','920','234034',4499713,'2721','409',660.66,860.66,0.00,0.00,200.00,115600.00,0.00,0.00,0.00),('1','176','920','234171',4502299,'2720','409',667996.02,667996.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','234171',4502300,'2721','409',860.66,860.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','234240',4503457,'2720','409',667996.02,668660.26,0.00,0.00,664.24,385606.50,0.00,0.00,0.00),('1','176','920','234240',4503458,'2721','409',860.66,863.06,0.00,0.00,2.40,1497.60,0.00,0.00,0.00),('1','176','920','234302',4504602,'2720','409',668660.26,671209.33,0.00,0.00,2549.07,1484822.90,0.00,0.00,0.00),('1','176','920','234302',4504603,'2721','409',863.06,900.56,0.00,0.00,37.50,23400.00,0.00,0.00,0.00),('1','176','920','234573',4509319,'2720','409',671209.33,673270.30,0.00,0.00,2060.97,1196699.02,0.00,0.00,0.00),('1','176','920','234573',4509320,'2721','409',900.56,910.18,0.00,0.00,9.62,6002.88,0.00,0.00,0.00),('1','176','920','234687',4511380,'2720','409',673270.30,673270.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','234687',4511381,'2721','409',910.18,910.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','234698',4511549,'2720','409',673270.30,675348.94,0.00,0.00,2078.64,1207341.46,0.00,0.00,0.00),('1','176','920','234698',4511550,'2721','409',910.18,932.68,0.00,0.00,22.50,14040.00,0.00,0.00,0.00),('1','176','920','234807',4513632,'2720','409',675348.94,678001.82,0.00,0.00,2652.88,1541312.06,0.00,0.00,0.00),('1','176','920','234807',4513633,'2721','409',932.68,976.43,0.00,0.00,43.75,27300.00,0.00,0.00,0.00),('1','176','920','235060',4518073,'2720','409',678001.82,678077.15,0.00,0.00,75.33,43540.74,0.00,0.00,0.00),('1','176','920','235060',4518074,'2721','409',976.43,1065.43,0.00,0.00,89.00,51442.00,0.00,0.00,0.00),('1','176','920','235077',4518308,'2720','409',678077.15,678077.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235077',4518309,'2721','409',1065.43,1065.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235136',4519334,'2720','409',678077.15,680688.92,0.00,0.00,2611.77,1517561.06,0.00,0.00,0.00),('1','176','920','235136',4519335,'2721','409',1065.43,1127.93,0.00,0.00,62.50,36700.00,0.00,0.00,0.00),('1','176','920','235288',4522002,'2720','409',680688.92,683254.34,0.00,0.00,2565.42,1491824.62,0.00,0.00,0.00),('1','176','920','235288',4522003,'2721','409',1127.93,1182.93,0.00,0.00,55.00,32020.00,0.00,0.00,0.00),('1','176','920','235448',4524905,'2720','409',683254.34,683254.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235448',4524906,'2721','409',1182.93,1182.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235456',4525042,'2720','409',683254.34,684976.25,0.00,0.00,1721.91,996827.06,0.00,0.00,0.00),('1','176','920','235456',4525043,'2721','409',1182.93,1213.54,0.00,0.00,30.61,17950.64,0.00,0.00,0.00),('1','176','920','235512',4525951,'2720','409',684976.25,687467.41,0.00,0.00,2491.16,1448769.40,0.00,0.00,0.00),('1','176','920','235512',4525952,'2721','409',1213.54,1216.58,0.00,0.00,3.04,1896.96,0.00,0.00,0.00),('1','176','920','235743',4530064,'2720','409',687467.41,688655.58,0.00,0.00,1188.17,714402.00,0.00,0.00,0.00),('1','176','920','235743',4530065,'2721','409',1216.58,1229.08,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','176','920','235831',4531532,'2720','409',688655.58,688655.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235831',4531533,'2721','409',1229.08,1229.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','235861',4532044,'2720','409',688655.58,691623.68,0.00,0.00,2968.10,1786164.00,0.00,0.00,0.00),('1','176','920','235861',4532045,'2721','409',1229.08,1229.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236001',4534522,'2720','409',691623.68,693833.95,0.00,0.00,2210.27,1328152.80,0.00,0.00,0.00),('1','176','920','236001',4534523,'2721','409',1229.08,1271.27,0.00,0.00,42.19,27001.60,0.00,0.00,0.00),('1','176','920','236128',4536835,'2720','409',693833.95,693833.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236128',4536836,'2721','409',1271.27,1271.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236130',4536848,'2720','409',693833.95,696358.90,0.00,0.00,2524.95,1521782.00,0.00,0.00,0.00),('1','176','920','236130',4536849,'2721','409',1271.27,1271.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236228',4538622,'2720','409',696358.90,698739.62,0.00,0.00,2380.72,1431587.20,0.00,0.00,0.00),('1','176','920','236228',4538623,'2721','409',1271.27,1302.37,0.00,0.00,31.10,19904.00,0.00,0.00,0.00),('1','176','920','236404',4541678,'2720','409',698739.62,698739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236404',4541679,'2721','409',1302.37,1302.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236511',4543564,'2720','409',698739.62,703028.93,0.00,0.00,4289.31,2582211.60,0.00,0.00,0.00),('1','176','920','236511',4543565,'2721','409',1302.37,1388.37,0.00,0.00,86.00,52640.00,0.00,0.00,0.00),('1','176','920','236724',4547053,'2720','409',703028.93,703922.06,0.00,0.00,893.13,538523.20,0.00,0.00,0.00),('1','176','920','236724',4547054,'2721','409',1388.37,1461.81,0.00,0.00,73.44,45001.60,0.00,0.00,0.00),('1','176','920','236803',4548457,'2720','409',703922.06,703922.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236803',4548458,'2721','409',1461.81,1461.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236857',4549438,'2720','409',703922.06,705701.44,0.00,0.00,1779.38,1071881.20,0.00,0.00,0.00),('1','176','920','236857',4549439,'2721','409',1461.81,1461.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','236950',4551110,'2720','409',705701.44,709218.72,0.00,0.00,3517.28,2113437.20,0.00,0.00,0.00),('1','176','920','236950',4551111,'2721','409',1461.81,1585.44,0.00,0.00,123.63,77123.20,0.00,0.00,0.00),('1','176','920','237108',4553953,'2720','409',709218.72,709218.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237108',4553954,'2721','409',1585.44,1585.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237110',4553978,'2720','409',709218.72,709881.48,0.00,0.00,662.76,398799.60,0.00,0.00,0.00),('1','176','920','237110',4553979,'2721','409',1585.44,1700.45,0.00,0.00,115.01,70606.40,0.00,0.00,0.00),('1','176','920','237170',4554903,'2720','409',709881.48,712411.06,0.00,0.00,2529.58,1523461.20,0.00,0.00,0.00),('1','176','920','237170',4554904,'2721','409',1700.45,1782.67,0.00,0.00,82.22,50200.80,0.00,0.00,0.00),('1','176','920','237378',4558732,'2720','409',712411.06,714106.52,0.00,0.00,1695.46,1019651.20,0.00,0.00,0.00),('1','176','920','237378',4558733,'2721','409',1782.67,1843.14,0.00,0.00,60.47,36700.80,0.00,0.00,0.00),('1','176','920','237477',4560606,'2720','409',714106.52,714106.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237477',4560607,'2721','409',1843.14,1843.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237486',4560754,'2720','409',714106.52,716507.18,0.00,0.00,2400.66,1446609.60,0.00,0.00,0.00),('1','176','920','237486',4560755,'2721','409',1843.14,2243.14,0.00,0.00,400.00,240000.00,0.00,0.00,0.00),('1','176','920','237606',4562772,'2720','409',716507.18,717950.10,0.00,0.00,1442.92,903695.36,0.00,0.00,0.00),('1','176','920','237606',4562773,'2721','409',2243.14,2317.16,0.00,0.00,74.02,45892.40,0.00,0.00,0.00),('1','176','920','237871',4567131,'2720','409',717950.10,718909.60,0.00,0.00,959.50,585038.72,0.00,0.00,0.00),('1','176','920','237871',4567132,'2721','409',2317.16,2322.16,0.00,0.00,5.00,3200.00,0.00,0.00,0.00),('1','176','920','237952',4568467,'2720','409',718909.60,718909.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237952',4568468,'2721','409',2322.16,2322.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','237967',4568721,'2720','409',718909.60,721408.40,0.00,0.00,2498.80,1523619.84,0.00,0.00,0.00),('1','176','920','237967',4568722,'2721','409',2322.16,2328.18,0.00,0.00,6.02,3852.80,0.00,0.00,0.00),('1','176','920','238109',4571020,'2720','409',721408.40,724170.19,0.00,0.00,2761.79,1683884.16,0.00,0.00,0.00),('1','176','920','238109',4571021,'2721','409',2328.18,2328.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238267',4573707,'2720','409',724170.19,724170.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238267',4573708,'2721','409',2328.18,2328.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238269',4573721,'2720','409',724170.19,725963.68,0.00,0.00,1793.49,1092162.56,0.00,0.00,0.00),('1','176','920','238269',4573722,'2721','409',2328.18,2328.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238346',4575204,'2720','409',725963.68,728980.57,0.00,0.00,3016.89,1837862.08,0.00,0.00,0.00),('1','176','920','238346',4575205,'2721','409',2328.18,2571.30,0.00,0.00,243.12,148364.80,0.00,0.00,0.00),('1','176','920','238535',4578303,'2720','409',728980.57,728980.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238535',4578304,'2721','409',2571.30,2571.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238538',4578332,'2720','409',728980.57,729422.63,0.00,0.00,442.06,270022.72,0.00,0.00,0.00),('1','176','920','238538',4578333,'2721','409',2571.30,2576.30,0.00,0.00,5.00,3200.00,0.00,0.00,0.00),('1','176','920','238598',4579330,'2720','409',729422.63,734223.62,0.00,0.00,4800.99,2925667.52,0.00,0.00,0.00),('1','176','920','238598',4579331,'2721','409',2576.30,2629.55,0.00,0.00,53.25,32501.12,0.00,0.00,0.00),('1','176','920','238761',4582206,'2720','409',734223.62,734223.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238761',4582207,'2721','409',2629.55,2629.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','238763',4582222,'2720','409',734223.62,735108.88,0.00,0.00,885.26,539080.96,0.00,0.00,0.00),('1','176','920','238763',4582223,'2721','409',2629.55,2690.11,0.00,0.00,60.56,36870.40,0.00,0.00,0.00),('1','176','920','238831',4583431,'2720','409',735108.88,737840.02,0.00,0.00,2731.14,1667358.08,0.00,0.00,0.00),('1','176','920','238831',4583432,'2721','409',2690.11,2823.08,0.00,0.00,132.97,81900.80,0.00,0.00,0.00),('1','176','920','239062',4587565,'2720','409',737840.02,739111.28,0.00,0.00,1271.26,775000.96,0.00,0.00,0.00),('1','176','920','239062',4587566,'2721','409',2823.08,2868.08,0.00,0.00,45.00,27360.00,0.00,0.00,0.00),('1','176','920','239160',4589292,'2720','409',739111.28,739111.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239160',4589293,'2721','409',2868.08,2868.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239165',4589386,'2720','409',739111.28,743015.10,0.00,0.00,3903.82,2381690.88,0.00,0.00,0.00),('1','176','920','239165',4589387,'2721','409',2868.08,3057.33,0.00,0.00,189.25,115264.00,0.00,0.00,0.00),('1','176','920','239287',4591484,'2720','409',743015.10,744116.96,0.00,0.00,1101.86,670572.48,0.00,0.00,0.00),('1','176','920','239287',4591485,'2721','409',3057.33,3107.33,0.00,0.00,50.00,30400.00,0.00,0.00,0.00),('1','176','920','239412',4593557,'2720','409',744116.96,744116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239412',4593558,'2721','409',3107.33,3107.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239417',4593639,'2720','409',744116.96,746351.58,0.00,0.00,2234.62,1361826.56,0.00,0.00,0.00),('1','176','920','239417',4593640,'2721','409',3107.33,3157.33,0.00,0.00,50.00,30400.00,0.00,0.00,0.00),('1','176','920','239524',4595477,'2720','409',746351.58,749456.03,0.00,0.00,3104.45,1890104.32,0.00,0.00,0.00),('1','176','920','239524',4595478,'2721','409',3157.33,3162.80,0.00,0.00,5.47,3500.80,0.00,0.00,0.00),('1','176','920','239679',4598211,'2720','409',749456.03,749456.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239679',4598212,'2721','409',3162.80,3162.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239683',4598242,'2720','409',749456.03,750147.14,0.00,0.00,691.11,422740.80,0.00,0.00,0.00),('1','176','920','239683',4598243,'2721','409',3162.80,3262.80,0.00,0.00,100.00,60800.00,0.00,0.00,0.00),('1','176','920','239767',4599675,'2720','409',750147.14,751401.81,0.00,0.00,1254.67,764715.20,0.00,0.00,0.00),('1','176','920','239767',4599676,'2721','409',3262.80,3262.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239845',4601076,'2720','409',751401.81,753843.93,0.00,0.00,2442.12,1517286.40,0.00,0.00,0.00),('1','176','920','239845',4601077,'2721','409',3262.80,3323.69,0.00,0.00,60.89,38001.80,0.00,0.00,0.00),('1','176','920','239934',4602628,'2720','409',753843.93,753843.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','239934',4602629,'2721','409',3323.69,3323.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','240025',4604139,'2720','409',753843.93,756715.01,0.00,0.00,2871.08,1782895.00,0.00,0.00,0.00),('1','176','920','240025',4604140,'2721','409',3323.69,3339.09,0.00,0.00,15.40,9856.00,0.00,0.00,0.00),('1','176','920','240200',4607244,'2720','409',756715.01,758571.14,0.00,0.00,1856.13,1155280.80,0.00,0.00,0.00),('1','176','920','240200',4607245,'2721','409',3339.09,3842.34,0.00,0.00,503.25,312140.00,0.00,0.00,0.00),('1','176','920','240368',4610171,'2720','409',758571.14,758571.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','240368',4610172,'2721','409',3842.34,3842.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','240451',4611285,'2720','409',758571.14,762284.26,0.00,0.00,3713.12,2310715.40,0.00,0.00,0.00),('1','176','920','240451',4611286,'2721','409',3842.34,3907.92,0.00,0.00,65.58,40659.60,0.00,0.00,0.00),('1','176','920','240674',4614819,'2720','409',762284.26,763647.00,0.00,0.00,1362.74,846453.60,0.00,0.00,0.00),('1','176','920','240674',4614820,'2721','409',3907.92,4012.76,0.00,0.00,104.84,65000.80,0.00,0.00,0.00),('1','176','920','240768',4616264,'2720','409',763647.00,763647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','240768',4616265,'2721','409',4012.76,4012.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','240795',4616692,'2720','409',763647.00,765105.82,0.00,0.00,1458.82,909469.60,0.00,0.00,0.00),('1','176','920','240795',4616693,'2721','409',4012.76,4132.45,0.00,0.00,119.69,74601.60,0.00,0.00,0.00),('1','176','920','240959',4619828,'2720','409',765105.82,767719.68,0.00,0.00,2613.86,1624010.80,0.00,0.00,0.00),('1','176','920','240959',4619829,'2721','409',4132.45,4132.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241102',4622264,'2720','409',767719.68,768563.79,0.00,0.00,844.11,518602.24,0.00,0.00,0.00),('1','176','920','241102',4622265,'2721','409',4132.45,4132.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241221',4624515,'2720','409',768563.79,768563.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241221',4624516,'2721','409',4132.45,4132.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241234',4624631,'2720','409',768563.79,773089.48,0.00,0.00,4525.69,2757549.76,0.00,0.00,0.00),('1','176','920','241234',4624632,'2721','409',4132.45,4214.29,0.00,0.00,81.84,50798.72,0.00,0.00,0.00),('1','176','920','241493',4629059,'2720','409',773089.48,773397.81,0.00,0.00,308.33,188214.72,0.00,0.00,0.00),('1','176','920','241493',4629060,'2721','409',4214.29,4300.29,0.00,0.00,86.00,52288.00,0.00,0.00,0.00),('1','176','920','241562',4630298,'2720','409',773397.81,773397.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241562',4630299,'2721','409',4300.29,4300.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241563',4630300,'2720','409',773397.81,776382.43,0.00,0.00,2984.62,1819094.72,0.00,0.00,0.00),('1','176','920','241563',4630301,'2721','409',4300.29,4572.29,0.00,0.00,272.00,165376.00,0.00,0.00,0.00),('1','176','920','241733',4633307,'2720','409',776382.43,778325.23,0.00,0.00,1942.80,1182182.40,0.00,0.00,0.00),('1','176','920','241733',4633308,'2721','409',4572.29,4587.79,0.00,0.00,15.50,9920.00,0.00,0.00,0.00),('1','176','920','241841',4634997,'2720','409',778325.23,778325.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241841',4634998,'2721','409',4587.79,4587.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','241978',4637453,'2720','409',778325.23,782920.73,0.00,0.00,4595.50,2802734.08,0.00,0.00,0.00),('1','176','920','241978',4637454,'2721','409',4587.79,4722.79,0.00,0.00,135.00,82080.00,0.00,0.00,0.00),('1','176','920','242209',4641580,'2720','409',782920.73,783582.04,0.00,0.00,661.31,402566.40,0.00,0.00,0.00),('1','176','920','242209',4641581,'2721','409',4722.79,4724.35,0.00,0.00,1.56,998.40,0.00,0.00,0.00),('1','176','920','242282',4642862,'2720','409',783582.04,783582.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242282',4642863,'2721','409',4724.35,4724.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242299',4643131,'2720','409',783582.04,785937.30,0.00,0.00,2355.26,1437606.40,0.00,0.00,0.00),('1','176','920','242299',4643132,'2721','409',4724.35,4724.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242422',4645362,'2720','409',785937.30,788692.95,0.00,0.00,2755.65,1681120.64,0.00,0.00,0.00),('1','176','920','242422',4645363,'2721','409',4724.35,4855.35,0.00,0.00,131.00,79648.00,0.00,0.00,0.00),('1','176','920','242565',4647834,'2720','409',788692.95,788692.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242565',4647835,'2721','409',4855.35,4855.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242568',4647858,'2720','409',788692.95,789958.76,0.00,0.00,1265.81,773320.96,0.00,0.00,0.00),('1','176','920','242568',4647859,'2721','409',4855.35,4905.35,0.00,0.00,50.00,30400.00,0.00,0.00,0.00),('1','176','920','242662',4649633,'2720','409',789958.76,793547.09,0.00,0.00,3588.33,2186259.84,0.00,0.00,0.00),('1','176','920','242662',4649634,'2721','409',4905.35,5001.21,0.00,0.00,95.86,60550.40,0.00,0.00,0.00),('1','176','920','242857',4652801,'2720','409',793547.09,793893.11,0.00,0.00,346.02,210380.16,0.00,0.00,0.00),('1','176','920','242857',4652802,'2721','409',5001.21,5001.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','242919',4653827,'2720','409',793893.11,796487.30,0.00,0.00,2594.19,1564166.40,0.00,0.00,0.00),('1','176','920','242919',4653828,'2721','409',5001.21,5031.37,0.00,0.00,30.16,18502.40,0.00,0.00,0.00),('1','176','920','243133',4657656,'2720','409',796487.30,798466.93,0.00,0.00,1979.63,1189002.00,0.00,0.00,0.00),('1','176','920','243133',4657657,'2721','409',5031.37,5081.37,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','176','920','243203',4658842,'2720','409',798466.93,801180.49,0.00,0.00,2713.56,1635480.40,0.00,0.00,0.00),('1','176','920','243203',4658843,'2721','409',5081.37,5095.75,0.00,0.00,14.38,9203.20,0.00,0.00,0.00),('1','176','920','243356',4661760,'2720','409',801180.49,803402.55,0.00,0.00,2222.06,1335578.40,0.00,0.00,0.00),('1','176','920','243356',4661761,'2721','409',5095.75,5145.75,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','176','920','243476',4663721,'2720','409',803402.55,804693.13,0.00,0.00,1290.58,780004.00,0.00,0.00,0.00),('1','176','920','243476',4663722,'2721','409',5145.75,5159.82,0.00,0.00,14.07,9004.80,0.00,0.00,0.00),('1','176','920','243582',4665612,'2720','409',804693.13,807779.98,0.00,0.00,3086.85,1861778.40,0.00,0.00,0.00),('1','176','920','243582',4665613,'2721','409',5159.82,5768.32,0.00,0.00,608.50,365300.00,0.00,0.00,0.00),('1','176','920','243751',4668587,'2720','409',807779.98,808222.48,0.00,0.00,442.50,265500.00,0.00,0.00,0.00),('1','176','920','243751',4668588,'2721','409',5768.32,5768.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','243832',4669876,'2720','409',808222.48,811538.75,0.00,0.00,3316.27,2002201.20,0.00,0.00,0.00),('1','176','920','243832',4669877,'2721','409',5768.32,5878.32,0.00,0.00,110.00,66400.00,0.00,0.00,0.00),('1','176','920','244044',4673610,'2720','409',811538.75,812316.58,0.00,0.00,777.83,466698.00,0.00,0.00,0.00),('1','176','920','244044',4673611,'2721','409',5878.32,5878.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244113',4674646,'2720','409',812316.58,812316.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244113',4674647,'2721','409',5878.32,5878.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244124',4674890,'2720','409',812316.58,816211.07,0.00,0.00,3894.49,2348002.80,0.00,0.00,0.00),('1','176','920','244124',4674891,'2721','409',5878.32,5929.82,0.00,0.00,51.50,31760.00,0.00,0.00,0.00),('1','176','920','244273',4677487,'2720','409',816211.07,817579.07,0.00,0.00,1368.00,823100.00,0.00,0.00,0.00),('1','176','920','244273',4677488,'2721','409',5929.82,5932.95,0.00,0.00,3.13,2003.20,0.00,0.00,0.00),('1','176','920','244368',4679084,'2720','409',817579.07,817579.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244368',4679085,'2721','409',5932.95,5932.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244386',4679457,'2720','409',817579.07,819662.05,0.00,0.00,2082.98,1255533.60,0.00,0.00,0.00),('1','176','920','244386',4679458,'2721','409',5932.95,6063.58,0.00,0.00,130.63,79003.20,0.00,0.00,0.00),('1','176','920','244511',4681610,'2720','409',819662.05,822263.61,0.00,0.00,2601.56,1566918.40,0.00,0.00,0.00),('1','176','920','244511',4681611,'2721','409',6063.58,6383.58,0.00,0.00,320.00,192600.00,0.00,0.00,0.00),('1','176','920','244665',4684355,'2720','409',822263.61,822263.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244665',4684356,'2721','409',6383.58,6383.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244672',4684479,'2720','409',822263.61,822861.50,0.00,0.00,597.89,360129.20,0.00,0.00,0.00),('1','176','920','244672',4684480,'2721','409',6383.58,6383.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','244733',4685350,'2720','409',822861.50,826365.57,0.00,0.00,3504.07,2111818.40,0.00,0.00,0.00),('1','176','920','244733',4685351,'2721','409',6383.58,6496.08,0.00,0.00,112.50,68000.00,0.00,0.00,0.00),('1','176','920','244968',4689539,'2720','409',826365.57,827484.22,0.00,0.00,1118.65,660095.12,0.00,0.00,0.00),('1','176','920','244968',4689540,'2721','409',6496.08,6496.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245082',4691539,'2720','409',827484.22,827484.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245082',4691540,'2721','409',6496.08,6496.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245103',4691863,'2720','409',827484.22,829285.06,0.00,0.00,1800.84,1063293.92,0.00,0.00,0.00),('1','176','920','245103',4691864,'2721','409',6496.08,6496.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245206',4693778,'2720','409',829285.06,832769.21,0.00,0.00,3484.15,2057610.44,0.00,0.00,0.00),('1','176','920','245206',4693779,'2721','409',6496.08,6647.66,0.00,0.00,151.58,89198.56,0.00,0.00,0.00),('1','176','920','245359',4696474,'2720','409',832769.21,832769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245359',4696475,'2721','409',6647.66,6647.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245429',4697627,'2720','409',832769.21,836315.06,0.00,0.00,3545.85,2094328.72,0.00,0.00,0.00),('1','176','920','245429',4697628,'2721','409',6647.66,6802.72,0.00,0.00,155.06,91397.92,0.00,0.00,0.00),('1','176','920','245666',4701767,'2720','409',836315.06,837513.95,0.00,0.00,1198.89,706457.84,0.00,0.00,0.00),('1','176','920','245666',4701768,'2721','409',6802.72,6808.73,0.00,0.00,6.01,3798.32,0.00,0.00,0.00),('1','176','920','245773',4703584,'2720','409',837513.95,837513.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245773',4703585,'2721','409',6808.73,6808.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245776',4703618,'2720','409',837513.95,840799.08,0.00,0.00,3285.13,1945615.00,0.00,0.00,0.00),('1','176','920','245776',4703619,'2721','409',6808.73,6808.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','245938',4705846,'2720','409',840799.08,842764.57,0.00,0.00,1965.49,1158729.60,0.00,0.00,0.00),('1','176','920','245938',4705847,'2721','409',6808.73,6863.73,0.00,0.00,55.00,32340.00,0.00,0.00,0.00),('1','176','920','246067',4708018,'2720','409',842764.57,842764.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246067',4708019,'2721','409',6863.73,6863.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246072',4708092,'2720','409',842764.57,844013.99,0.00,0.00,1249.42,711496.84,0.00,0.00,0.00),('1','176','920','246072',4708093,'2721','409',6863.73,6888.73,0.00,0.00,25.00,15400.00,0.00,0.00,0.00),('1','176','920','246179',4709994,'2720','409',844013.99,847076.47,0.00,0.00,3062.48,1731533.92,0.00,0.00,0.00),('1','176','920','246179',4709995,'2721','409',6888.73,7056.91,0.00,0.00,168.18,95798.88,0.00,0.00,0.00),('1','176','920','246370',4712990,'2720','409',847076.47,847076.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246370',4712991,'2721','409',7056.91,7056.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246379',4713200,'2720','409',847076.47,848101.67,0.00,0.00,1025.20,580500.28,0.00,0.00,0.00),('1','176','920','246379',4713201,'2721','409',7056.91,7056.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246444',4714420,'2720','409',848101.67,851968.50,0.00,0.00,3866.83,2193133.96,0.00,0.00,0.00),('1','176','920','246444',4714421,'2721','409',7056.91,7295.06,0.00,0.00,238.15,136300.40,0.00,0.00,0.00),('1','176','920','246640',4717893,'2720','409',851968.50,851968.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246640',4717894,'2721','409',7295.06,7295.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','246725',4719048,'2720','409',851968.50,856410.11,0.00,0.00,4441.61,2518015.00,0.00,0.00,0.00),('1','176','920','246725',4719049,'2721','409',7295.06,7485.19,0.00,0.00,190.13,107753.32,0.00,0.00,0.00),('1','176','920','246925',4722944,'2720','409',856410.11,856972.17,0.00,0.00,562.06,317001.84,0.00,0.00,0.00),('1','176','920','246925',4722945,'2721','409',7485.19,7497.69,0.00,0.00,12.50,7050.00,0.00,0.00,0.00),('1','176','920','247005',4724064,'2720','409',856972.17,856972.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247005',4724065,'2721','409',7497.69,7497.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247011',4724220,'2720','409',856972.17,860467.11,0.00,0.00,3494.94,1981095.32,0.00,0.00,0.00),('1','176','920','247011',4724221,'2721','409',7497.69,7527.72,0.00,0.00,30.03,18498.48,0.00,0.00,0.00),('1','176','920','247163',4726885,'2720','409',860467.11,861727.90,0.00,0.00,1260.79,715403.64,0.00,0.00,0.00),('1','176','920','247163',4726886,'2721','409',7527.72,7914.94,0.00,0.00,387.22,220899.52,0.00,0.00,0.00),('1','176','920','247263',4728623,'2720','409',861727.90,861727.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247263',4728624,'2721','409',7914.94,7914.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247264',4728625,'2720','409',861727.90,863682.84,0.00,0.00,1954.94,1110917.60,0.00,0.00,0.00),('1','176','920','247264',4728626,'2721','409',7914.94,8006.47,0.00,0.00,91.53,52534.48,0.00,0.00,0.00),('1','176','920','247395',4731038,'2720','409',863682.84,866758.95,0.00,0.00,3076.11,1738594.12,0.00,0.00,0.00),('1','176','920','247395',4731039,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247587',4734200,'2720','409',866758.95,866758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247587',4734201,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247588',4734202,'2720','409',866758.95,868130.92,0.00,0.00,1371.97,773791.08,0.00,0.00,0.00),('1','176','920','247588',4734203,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247663',4735469,'2720','409',868130.92,868668.54,0.00,0.00,537.62,307201.92,0.00,0.00,0.00),('1','176','920','247663',4735470,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247754',4737025,'2720','409',868668.54,872039.19,0.00,0.00,3370.65,1880464.56,0.00,0.00,0.00),('1','176','920','247754',4737026,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247827',4738240,'2720','409',872039.19,872039.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247827',4738241,'2721','409',8006.47,8006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','247828',4738242,'2720','409',872039.19,872820.62,0.00,0.00,781.43,436943.96,0.00,0.00,0.00),('1','176','920','247828',4738243,'2721','409',8006.47,8023.03,0.00,0.00,16.56,9803.52,0.00,0.00,0.00),('1','176','920','247904',4739575,'2720','409',872820.62,876248.20,0.00,0.00,3427.58,1915130.48,0.00,0.00,0.00),('1','176','920','247904',4739576,'2721','409',8023.03,8540.03,0.00,0.00,517.00,287902.00,0.00,0.00,0.00),('1','176','920','248079',4742581,'2720','409',876248.20,876248.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248079',4742582,'2721','409',8540.03,8540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248152',4743776,'2720','409',876248.20,881143.41,0.00,0.00,4895.21,2733062.36,0.00,0.00,0.00),('1','176','920','248152',4743777,'2721','409',8540.03,8851.85,0.00,0.00,311.82,173797.44,0.00,0.00,0.00),('1','176','920','248398',4747944,'2720','409',881143.41,881232.91,0.00,0.00,89.50,49762.00,0.00,0.00,0.00),('1','176','920','248398',4747945,'2721','409',8851.85,8851.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248431',4748311,'2720','409',881232.91,881232.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248431',4748312,'2721','409',8851.85,8851.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248435',4748340,'2720','409',881232.91,886255.57,0.00,0.00,5022.66,2802787.32,0.00,0.00,0.00),('1','176','920','248435',4748341,'2721','409',8851.85,9161.11,0.00,0.00,309.26,172495.76,0.00,0.00,0.00),('1','176','920','248565',4750789,'2720','409',886255.57,886255.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248565',4750790,'2721','409',9161.11,9161.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248663',4752164,'2720','409',886255.57,891244.11,0.00,0.00,4988.54,2784857.36,0.00,0.00,0.00),('1','176','920','248663',4752165,'2721','409',9161.11,9293.89,0.00,0.00,132.78,75005.76,0.00,0.00,0.00),('1','176','920','248786',4754555,'2720','409',891244.11,891244.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248786',4754556,'2721','409',9293.89,9293.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248800',4754755,'2720','409',891244.11,892136.74,0.00,0.00,892.63,496302.28,0.00,0.00,0.00),('1','176','920','248800',4754756,'2721','409',9293.89,9293.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','248857',4755798,'2720','409',892136.74,893594.89,0.00,0.00,1458.15,812392.80,0.00,0.00,0.00),('1','176','920','248857',4755799,'2721','409',9293.89,9551.39,0.00,0.00,257.50,143170.00,0.00,0.00,0.00),('1','176','920','248946',4757055,'2720','409',893594.89,896290.10,0.00,0.00,2695.21,1437023.50,0.00,0.00,0.00),('1','176','920','248946',4757056,'2721','409',9551.39,9587.54,0.00,0.00,36.15,21400.80,0.00,0.00,0.00),('1','176','920','249048',4759010,'2720','409',896290.10,896290.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249048',4759011,'2721','409',9587.54,9587.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249139',4760160,'2720','409',896290.10,899501.35,0.00,0.00,3211.25,1710325.06,0.00,0.00,0.00),('1','176','920','249139',4760161,'2721','409',9587.54,9640.62,0.00,0.00,53.08,28509.36,0.00,0.00,0.00),('1','176','920','249329',4763820,'2720','409',899501.35,901201.89,0.00,0.00,1700.54,906150.10,0.00,0.00,0.00),('1','176','920','249329',4763821,'2721','409',9640.62,9736.01,0.00,0.00,95.39,51499.10,0.00,0.00,0.00),('1','176','920','249482',4766315,'2720','409',901201.89,901201.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249482',4766316,'2721','409',9736.01,9736.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249493',4766470,'2720','409',901201.89,902206.66,0.00,0.00,1004.77,540561.44,0.00,0.00,0.00),('1','176','920','249493',4766471,'2721','409',9736.01,9851.01,0.00,0.00,115.00,60950.00,0.00,0.00,0.00),('1','176','920','249577',4767923,'2720','409',902206.66,906174.79,0.00,0.00,3968.13,2114315.40,0.00,0.00,0.00),('1','176','920','249577',4767924,'2721','409',9851.01,10101.45,0.00,0.00,250.44,133256.48,0.00,0.00,0.00),('1','176','920','249787',4771495,'2720','409',906174.79,906174.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249787',4771496,'2721','409',10101.45,10101.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','249841',4772385,'2720','409',906174.79,910250.45,0.00,0.00,4075.66,2175186.26,0.00,0.00,0.00),('1','176','920','249841',4772386,'2721','409',10101.45,10111.58,0.00,0.00,10.13,5996.96,0.00,0.00,0.00),('1','176','920','250080',4776385,'2720','409',910250.45,911485.76,0.00,0.00,1235.31,657730.60,0.00,0.00,0.00),('1','176','920','250080',4776386,'2721','409',10111.58,10166.65,0.00,0.00,55.07,29501.44,0.00,0.00,0.00),('1','176','920','250179',4777956,'2720','409',911485.76,911485.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','250179',4777957,'2721','409',10166.65,10166.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','250193',4778106,'2720','409',911485.76,913233.15,0.00,0.00,1747.39,936022.44,0.00,0.00,0.00),('1','176','920','250193',4778107,'2721','409',10166.65,10231.65,0.00,0.00,65.00,34450.00,0.00,0.00,0.00),('1','176','920','250321',4780536,'2720','409',913233.15,916248.80,0.00,0.00,3015.65,1616312.32,0.00,0.00,0.00),('1','176','920','250321',4780537,'2721','409',10231.65,10403.61,0.00,0.00,171.96,92500.32,0.00,0.00,0.00),('1','176','920','250553',4784287,'2720','409',916248.80,918163.87,0.00,0.00,1915.07,1023931.22,0.00,0.00,0.00),('1','176','920','250553',4784288,'2721','409',10403.61,10747.24,0.00,0.00,343.63,182898.90,0.00,0.00,0.00),('1','176','920','250781',4788295,'2720','409',918163.87,920794.65,0.00,0.00,2630.78,1400337.94,0.00,0.00,0.00),('1','176','920','250781',4788296,'2721','409',10747.24,10857.76,0.00,0.00,110.52,62141.84,0.00,0.00,0.00),('1','176','920','250892',4790128,'2720','409',920794.65,922502.90,0.00,0.00,1708.25,913169.00,0.00,0.00,0.00),('1','176','920','250892',4790129,'2721','409',10857.76,10857.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251014',4792460,'2720','409',922502.90,925322.35,0.00,0.00,2819.45,1504908.02,0.00,0.00,0.00),('1','176','920','251014',4792461,'2721','409',10857.76,11330.06,0.00,0.00,472.30,251701.60,0.00,0.00,0.00),('1','176','920','251169',4795075,'2720','409',925322.35,927096.45,0.00,0.00,1774.10,943698.50,0.00,0.00,0.00),('1','176','920','251169',4795076,'2721','409',11330.06,11383.44,0.00,0.00,53.38,28500.96,0.00,0.00,0.00),('1','176','920','251263',4796745,'2720','409',927096.45,929822.74,0.00,0.00,2726.29,1461408.96,0.00,0.00,0.00),('1','176','920','251263',4796746,'2721','409',11383.44,11417.17,0.00,0.00,33.73,18096.38,0.00,0.00,0.00),('1','176','920','251552',4801409,'2720','409',929822.74,930235.25,0.00,0.00,412.51,218630.30,0.00,0.00,0.00),('1','176','920','251552',4801410,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251554',4801412,'2720','409',930235.25,932997.67,0.00,0.00,2762.42,1486076.48,0.00,0.00,0.00),('1','176','920','251554',4801413,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251791',4805759,'2720','409',932997.67,934639.38,0.00,0.00,1641.71,872305.44,0.00,0.00,0.00),('1','176','920','251791',4805760,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251853',4806779,'2720','409',934639.38,934639.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251853',4806780,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','251858',4806887,'2720','409',934639.38,936732.09,0.00,0.00,2092.71,1122184.82,0.00,0.00,0.00),('1','176','920','251858',4806888,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252012',4809530,'2720','409',936732.09,939639.38,0.00,0.00,2907.29,1555514.30,0.00,0.00,0.00),('1','176','920','252012',4809531,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252156',4812238,'2720','409',939639.38,940776.12,0.00,0.00,1136.74,604514.48,0.00,0.00,0.00),('1','176','920','252156',4812239,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252251',4813711,'2720','409',940776.12,944639.38,0.00,0.00,3863.26,2067029.90,0.00,0.00,0.00),('1','176','920','252251',4813712,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252379',4816091,'2720','409',944639.38,945030.30,0.00,0.00,390.92,209172.22,0.00,0.00,0.00),('1','176','920','252379',4816092,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252510',4818306,'2720','409',945030.30,949639.38,0.00,0.00,4609.08,2456430.08,0.00,0.00,0.00),('1','176','920','252510',4818307,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252743',4822407,'2720','409',949639.38,953645.90,0.00,0.00,4006.52,2140410.74,0.00,0.00,0.00),('1','176','920','252743',4822408,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','252987',4826278,'2720','409',953645.90,954639.38,0.00,0.00,993.48,529272.40,0.00,0.00,0.00),('1','176','920','252987',4826279,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253015',4826674,'2720','409',954639.38,957111.25,0.00,0.00,2471.87,1325831.66,0.00,0.00,0.00),('1','176','920','253015',4826675,'2721','409',11417.17,11417.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253220',4830342,'2720','409',957111.25,959178.05,0.00,0.00,2066.80,1089032.08,0.00,0.00,0.00),('1','176','920','253220',4830343,'2721','409',11417.17,11431.70,0.00,0.00,14.53,8601.76,0.00,0.00,0.00),('1','176','920','253370',4832778,'2720','409',959178.05,959178.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253370',4832779,'2721','409',11431.70,11431.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253373',4832825,'2720','409',959178.05,960510.94,0.00,0.00,1332.89,710844.36,0.00,0.00,0.00),('1','176','920','253373',4832826,'2721','409',11431.70,11591.97,0.00,0.00,160.27,85359.84,0.00,0.00,0.00),('1','176','920','253464',4834665,'2720','409',960510.94,963379.48,0.00,0.00,2868.54,1514429.48,0.00,0.00,0.00),('1','176','920','253464',4834666,'2721','409',11591.97,11728.01,0.00,0.00,136.04,71491.68,0.00,0.00,0.00),('1','176','920','253634',4837515,'2720','409',963379.48,963379.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253634',4837516,'2721','409',11728.01,11728.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','253714',4838790,'2720','409',963379.48,967779.64,0.00,0.00,4400.16,2322075.92,0.00,0.00,0.00),('1','176','920','253714',4838791,'2721','409',11728.01,12327.85,0.00,0.00,599.84,316889.28,0.00,0.00,0.00),('1','176','920','253959',4843070,'2720','409',967779.64,971072.31,0.00,0.00,3292.67,1744404.52,0.00,0.00,0.00),('1','176','920','253959',4843071,'2721','409',12327.85,12452.82,0.00,0.00,124.97,67862.24,0.00,0.00,0.00),('1','176','920','254197',4847412,'2720','409',971072.31,972565.91,0.00,0.00,1493.60,787218.72,0.00,0.00,0.00),('1','176','920','254197',4847413,'2721','409',12452.82,12541.58,0.00,0.00,88.76,46969.92,0.00,0.00,0.00),('1','176','920','254273',4848631,'2720','409',972565.91,974319.60,0.00,0.00,1753.69,929969.28,0.00,0.00,0.00),('1','176','920','254273',4848632,'2721','409',12541.58,12805.30,0.00,0.00,263.72,140142.24,0.00,0.00,0.00),('1','176','920','254439',4851651,'2720','409',974319.60,977202.19,0.00,0.00,2882.59,1516542.76,0.00,0.00,0.00),('1','176','920','254439',4851652,'2721','409',12805.30,12905.30,0.00,0.00,100.00,52400.00,0.00,0.00,0.00),('1','176','920','254553',4853437,'2720','409',977202.19,979506.02,0.00,0.00,2303.83,1216786.76,0.00,0.00,0.00),('1','176','920','254553',4853438,'2721','409',12905.30,13137.87,0.00,0.00,232.57,123061.44,0.00,0.00,0.00),('1','176','920','254703',4856116,'2720','409',979506.02,981905.43,0.00,0.00,2399.41,1268249.72,0.00,0.00,0.00),('1','176','920','254703',4856117,'2721','409',13137.87,13202.06,0.00,0.00,64.19,34600.48,0.00,0.00,0.00),('1','176','920','254868',4858956,'2720','409',981905.43,983494.41,0.00,0.00,1588.98,835439.36,0.00,0.00,0.00),('1','176','920','254868',4858957,'2721','409',13202.06,13202.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','254950',4860339,'2720','409',983494.41,986516.61,0.00,0.00,3022.20,1590777.56,0.00,0.00,0.00),('1','176','920','254950',4860340,'2721','409',13202.06,13202.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255112',4863228,'2720','409',986516.61,986516.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255112',4863229,'2721','409',13202.06,13202.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255115',4863264,'2720','409',986516.61,987585.18,0.00,0.00,1068.57,566570.20,0.00,0.00,0.00),('1','176','920','255115',4863265,'2721','409',13202.06,13208.14,0.00,0.00,6.08,3599.36,0.00,0.00,0.00),('1','176','920','255186',4864475,'2720','409',987585.18,990982.58,0.00,0.00,3397.40,1790529.40,0.00,0.00,0.00),('1','176','920','255186',4864476,'2721','409',13208.14,13276.66,0.00,0.00,68.52,36823.84,0.00,0.00,0.00),('1','176','920','255464',4869144,'2720','409',990982.58,991544.82,0.00,0.00,562.24,294613.76,0.00,0.00,0.00),('1','176','920','255464',4869145,'2721','409',13276.66,13276.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255539',4870116,'2720','409',991544.82,991544.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255539',4870117,'2721','409',13276.66,13276.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255541',4870119,'2720','409',991544.82,995659.68,0.00,0.00,4114.86,2168305.60,0.00,0.00,0.00),('1','176','920','255541',4870120,'2721','409',13276.66,13351.66,0.00,0.00,75.00,39300.00,0.00,0.00,0.00),('1','176','920','255713',4873249,'2720','409',995659.68,996548.93,0.00,0.00,889.25,471710.28,0.00,0.00,0.00),('1','176','920','255713',4873250,'2721','409',13351.66,13451.66,0.00,0.00,100.00,52400.00,0.00,0.00,0.00),('1','176','920','255868',4875764,'2720','409',996548.93,996548.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255868',4875765,'2721','409',13451.66,13451.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','255872',4875801,'2720','409',996548.93,999163.63,0.00,0.00,2614.70,1378511.00,0.00,0.00,0.00),('1','176','920','255872',4875802,'2721','409',13451.66,13550.26,0.00,0.00,98.60,52355.92,0.00,0.00,0.00),('1','176','920','255937',4876953,'2720','409',999163.63,1001584.03,0.00,0.00,2420.40,1275834.20,0.00,0.00,0.00),('1','176','920','255937',4876954,'2721','409',13550.26,13663.44,0.00,0.00,113.18,60202.56,0.00,0.00,0.00),('1','176','920','256063',4879074,'2720','409',1001584.03,1001584.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','256063',4879075,'2721','409',13663.44,13663.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','256096',4879631,'2720','409',1001584.03,1004256.46,0.00,0.00,2672.43,1409026.72,0.00,0.00,0.00),('1','176','920','256096',4879632,'2721','409',13663.44,13725.94,0.00,0.00,62.50,33600.00,0.00,0.00,0.00),('1','176','920','256210',4881247,'2720','409',1004256.46,1006589.42,0.00,0.00,2332.96,1229617.16,0.00,0.00,0.00),('1','176','920','256210',4881248,'2721','409',13725.94,13743.51,0.00,0.00,17.57,10401.44,0.00,0.00,0.00),('1','176','920','256337',4883370,'2720','409',1006589.42,1006589.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','256337',4883371,'2721','409',13743.51,13743.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','256341',4883423,'2720','409',1006589.42,1007978.93,0.00,0.00,1389.51,731051.72,0.00,0.00,0.00),('1','176','920','256341',4883424,'2721','409',13743.51,13824.59,0.00,0.00,81.08,47999.36,0.00,0.00,0.00),('1','176','920','256470',4885917,'2720','409',1007978.93,1009149.62,0.00,0.00,1170.69,618529.32,0.00,0.00,0.00),('1','176','920','256470',4885918,'2721','409',13824.59,13853.81,0.00,0.00,29.22,15598.24,0.00,0.00,0.00),('1','176','920','256582',4887648,'2720','409',1009149.62,1010891.55,0.00,0.00,1741.93,923512.72,0.00,0.00,0.00),('1','176','920','256582',4887649,'2721','409',13853.81,13966.31,0.00,0.00,112.50,59400.00,0.00,0.00,0.00),('1','176','920','256715',4889861,'2720','409',1010891.55,1011366.62,0.00,0.00,475.07,247036.40,0.00,0.00,0.00),('1','176','920','256715',4889862,'2721','409',13966.31,13966.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','256769',4890557,'2720','409',1011366.62,1014623.39,0.00,0.00,3256.77,1715712.96,0.00,0.00,0.00),('1','176','920','256769',4890558,'2721','409',13966.31,14016.31,0.00,0.00,50.00,26000.00,0.00,0.00,0.00),('1','176','920','256960',4894120,'2720','409',1014623.39,1016243.37,0.00,0.00,1619.98,850563.04,0.00,0.00,0.00),('1','176','920','256960',4894121,'2721','409',14016.31,14114.39,0.00,0.00,98.08,51001.60,0.00,0.00,0.00),('1','176','920','257078',4896162,'2720','409',1016243.37,1017135.42,0.00,0.00,892.05,471199.92,0.00,0.00,0.00),('1','176','920','257078',4896163,'2721','409',14114.39,14136.35,0.00,0.00,21.96,13000.32,0.00,0.00,0.00),('1','176','920','257235',4899067,'2720','409',1017135.42,1021153.91,0.00,0.00,4018.49,2106453.44,0.00,0.00,0.00),('1','176','920','257235',4899068,'2721','409',14136.35,14203.85,0.00,0.00,67.50,36000.00,0.00,0.00,0.00),('1','176','920','257404',4902183,'2720','409',1021153.91,1022007.67,0.00,0.00,853.76,447823.04,0.00,0.00,0.00),('1','176','920','257404',4902184,'2721','409',14203.85,14203.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257490',4903519,'2720','409',1022007.67,1025022.25,0.00,0.00,3014.58,1581465.12,0.00,0.00,0.00),('1','176','920','257490',4903520,'2721','409',14203.85,14432.52,0.00,0.00,228.67,121388.56,0.00,0.00,0.00),('1','176','920','257491',4903521,'2720','409',1025022.25,1025763.24,0.00,0.00,740.99,385314.80,0.00,0.00,0.00),('1','176','920','257491',4903522,'2721','409',14432.52,14594.52,0.00,0.00,162.00,84240.00,0.00,0.00,0.00),('1','176','920','257492',4903523,'2720','409',1025763.24,1028829.68,0.00,0.00,3066.44,1608225.92,0.00,0.00,0.00),('1','176','920','257492',4903524,'2721','409',14594.52,14618.02,0.00,0.00,23.50,13348.00,0.00,0.00,0.00),('1','176','920','257493',4903525,'2720','409',1028829.68,1030252.04,0.00,0.00,1422.36,736671.78,0.00,0.00,0.00),('1','176','920','257493',4903526,'2721','409',14618.02,14618.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257494',4903527,'2720','409',1030252.04,1030252.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257494',4903528,'2721','409',14618.02,14618.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257495',4903529,'2720','409',1030252.04,1032062.78,0.00,0.00,1810.74,940636.38,0.00,0.00,0.00),('1','176','920','257495',4903530,'2721','409',14618.02,15197.49,0.00,0.00,579.47,297847.58,0.00,0.00,0.00),('1','176','920','257496',4903531,'2720','409',1048.01,3752.82,0.00,0.00,2704.81,1402713.94,0.00,0.00,0.00),('1','176','920','257496',4903532,'2721','409',836.59,953.32,0.00,0.00,116.73,66302.64,0.00,0.00,0.00),('1','176','920','257497',4903533,'2720','409',3752.82,3752.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257497',4903534,'2721','409',953.32,953.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257498',4903535,'2720','409',3752.82,7834.97,0.00,0.00,4082.15,2111412.98,0.00,0.00,0.00),('1','176','920','257498',4903536,'2721','409',953.32,967.40,0.00,0.00,14.08,7997.44,0.00,0.00,0.00),('1','176','920','257499',4903537,'2720','409',7834.97,8898.44,0.00,0.00,1063.47,547758.66,0.00,0.00,0.00),('1','176','920','257499',4903538,'2721','409',967.40,967.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257500',4903539,'2720','409',8898.44,8898.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257500',4903540,'2721','409',967.40,967.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257501',4903541,'2720','409',8898.44,10418.77,0.00,0.00,1520.33,791237.12,0.00,0.00,0.00),('1','176','920','257501',4903542,'2721','409',967.40,1242.40,0.00,0.00,275.00,142700.00,0.00,0.00,0.00),('1','176','920','257502',4903543,'2720','409',10418.77,13847.03,0.00,0.00,3428.26,1777986.52,0.00,0.00,0.00),('1','176','920','257502',4903544,'2721','409',1242.40,1300.80,0.00,0.00,58.40,30255.20,0.00,0.00,0.00),('1','176','920','257503',4903545,'2720','409',13847.03,13847.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257503',4903546,'2721','409',1300.80,1300.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257503',4903547,'2722','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257503',4903548,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257504',4903549,'2720','409',13847.03,14914.65,0.00,0.00,1067.62,548864.68,0.00,0.00,0.00),('1','176','920','257504',4903550,'2721','409',1300.80,1300.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257504',4903551,'2722','409',0.00,200.00,0.00,0.00,200.00,102800.00,0.00,0.00,0.00),('1','176','920','257504',4903552,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257505',4903553,'2720','409',14914.65,18428.55,0.00,0.00,3513.90,1818471.18,0.00,0.00,0.00),('1','176','920','257505',4903554,'2721','409',1300.80,1452.12,0.00,0.00,151.32,79047.48,0.00,0.00,0.00),('1','176','920','257505',4903555,'2722','409',200.00,200.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257505',4903556,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257506',4903557,'2720','409',18428.55,18466.05,0.00,0.00,37.50,19275.00,0.00,0.00,0.00),('1','176','920','257506',4903558,'2721','409',1452.12,1452.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257506',4903559,'2722','409',200.00,200.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257506',4903560,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257507',4903561,'2720','409',18466.05,18466.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257507',4903562,'2721','409',1452.12,1452.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257507',4903563,'2722','409',200.00,200.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257507',4903564,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257508',4903565,'2720','409',18466.05,21962.98,0.00,0.00,3496.93,1802459.68,0.00,0.00,0.00),('1','176','920','257508',4903566,'2721','409',1452.12,1535.00,0.00,0.00,82.88,47075.84,0.00,0.00,0.00),('1','176','920','257508',4903567,'2722','409',200.00,200.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257508',4903568,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257509',4903569,'2720','409',21962.98,23463.42,0.00,0.00,1500.44,772201.94,0.00,0.00,0.00),('1','176','920','257509',4903570,'2721','409',1535.00,1547.50,0.00,0.00,12.50,7100.00,0.00,0.00,0.00),('1','176','920','257509',4903571,'2722','409',200.00,248.00,0.00,0.00,48.00,24672.00,0.00,0.00,0.00),('1','176','920','257509',4903572,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257510',4903573,'2720','409',23463.42,23463.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257510',4903574,'2721','409',1547.50,1547.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257510',4903575,'2722','409',248.00,248.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257510',4903576,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257511',4903577,'2720','409',23463.42,23726.36,0.00,0.00,262.94,135151.16,0.00,0.00,0.00),('1','176','920','257511',4903578,'2721','409',1547.50,1547.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257511',4903579,'2722','409',248.00,398.00,0.00,0.00,150.00,77100.00,0.00,0.00,0.00),('1','176','920','257511',4903580,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257512',4903581,'2720','409',23726.36,24715.74,0.00,0.00,989.38,508541.32,0.00,0.00,0.00),('1','176','920','257512',4903582,'2721','409',1547.50,1760.56,0.00,0.00,213.06,121018.08,0.00,0.00,0.00),('1','176','920','257512',4903583,'2722','409',398.00,440.80,0.00,0.00,42.80,21999.20,0.00,0.00,0.00),('1','176','920','257512',4903584,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257513',4903585,'2720','409',24715.74,27586.54,0.00,0.00,2870.80,1479769.18,0.00,0.00,0.00),('1','176','920','257513',4903586,'2721','409',1760.56,1845.11,0.00,0.00,84.55,48024.40,0.00,0.00,0.00),('1','176','920','257513',4903587,'2722','409',440.80,809.42,0.00,0.00,368.62,189470.68,0.00,0.00,0.00),('1','176','920','257513',4903588,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257514',4903589,'2720','409',27586.54,27586.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257514',4903590,'2721','409',1845.11,1845.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257514',4903591,'2722','409',809.42,809.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257514',4903592,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257515',4903593,'2720','409',27586.54,30708.14,0.00,0.00,3121.60,1607705.68,0.00,0.00,0.00),('1','176','920','257515',4903594,'2721','409',1845.11,2126.56,0.00,0.00,281.45,157238.12,0.00,0.00,0.00),('1','176','920','257515',4903595,'2722','409',809.42,2374.05,0.00,0.00,1564.63,804219.82,0.00,0.00,0.00),('1','176','920','257515',4903596,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257516',4903597,'2720','409',30708.14,30880.46,0.00,0.00,172.32,88572.48,0.00,0.00,0.00),('1','176','920','257516',4903598,'2721','409',2126.56,2126.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257516',4903599,'2722','409',2374.05,2374.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257516',4903600,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257517',4903601,'2720','409',30880.46,34396.33,0.00,0.00,3515.87,1812981.08,0.00,0.00,0.00),('1','176','920','257517',4903602,'2721','409',2126.56,2331.57,0.00,0.00,205.01,113745.68,0.00,0.00,0.00),('1','176','920','257517',4903603,'2722','409',2374.05,3547.00,0.00,0.00,1172.95,602896.30,0.00,0.00,0.00),('1','176','920','257517',4903604,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257518',4903605,'2720','409',34396.33,37098.33,0.00,0.00,2702.00,1388828.00,0.00,0.00,0.00),('1','176','920','257518',4903606,'2721','409',2331.57,2672.28,0.00,0.00,340.71,193523.28,0.00,0.00,0.00),('1','176','920','257518',4903607,'2722','409',3547.00,4599.00,0.00,0.00,1052.00,540728.00,0.00,0.00,0.00),('1','176','920','257518',4903608,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257519',4903609,'2720','409',37098.33,37596.15,0.00,0.00,497.82,255879.48,0.00,0.00,0.00),('1','176','920','257519',4903610,'2721','409',2672.28,2717.91,0.00,0.00,45.63,25917.84,0.00,0.00,0.00),('1','176','920','257519',4903611,'2722','409',4599.00,5038.97,0.00,0.00,439.97,226144.58,0.00,0.00,0.00),('1','176','920','257519',4903612,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257520',4903613,'2720','409',37596.15,38578.63,0.00,0.00,982.48,505089.76,0.00,0.00,0.00),('1','176','920','257520',4903614,'2721','409',2717.91,2840.05,0.00,0.00,122.14,69375.52,0.00,0.00,0.00),('1','176','920','257520',4903615,'2722','409',5038.97,5133.97,0.00,0.00,95.00,48830.00,0.00,0.00,0.00),('1','176','920','257520',4903616,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257521',4903617,'2720','409',38578.63,41443.32,0.00,0.00,2864.69,1475150.66,0.00,0.00,0.00),('1','176','920','257521',4903618,'2721','409',2840.05,3048.77,0.00,0.00,208.72,118552.96,0.00,0.00,0.00),('1','176','920','257521',4903619,'2722','409',5133.97,5847.97,0.00,0.00,714.00,366996.00,0.00,0.00,0.00),('1','176','920','257521',4903620,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257522',4903621,'2720','409',41443.32,41443.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257522',4903622,'2721','409',3048.77,3048.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257522',4903623,'2722','409',5847.97,5847.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257522',4903624,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257523',4903625,'2720','409',41443.32,43443.37,0.00,0.00,2000.05,1028296.78,0.00,0.00,0.00),('1','176','920','257523',4903626,'2721','409',3048.77,3291.46,0.00,0.00,242.69,137847.92,0.00,0.00,0.00),('1','176','920','257523',4903627,'2722','409',5847.97,7749.80,0.00,0.00,1901.83,977540.62,0.00,0.00,0.00),('1','176','920','257523',4903628,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257524',4903629,'2720','409',43443.37,43589.01,0.00,0.00,145.64,74858.96,0.00,0.00,0.00),('1','176','920','257524',4903630,'2721','409',3291.46,3349.02,0.00,0.00,57.56,32694.08,0.00,0.00,0.00),('1','176','920','257524',4903631,'2722','409',7749.80,8663.75,0.00,0.00,913.95,469770.30,0.00,0.00,0.00),('1','176','920','257524',4903632,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257525',4903633,'2720','409',43589.01,43589.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257525',4903634,'2721','409',3349.02,3349.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257525',4903635,'2722','409',8663.75,8663.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257525',4903636,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257526',4903637,'2720','409',43589.01,44000.19,0.00,0.00,411.18,211346.52,0.00,0.00,0.00),('1','176','920','257526',4903638,'2721','409',3349.02,3401.25,0.00,0.00,52.23,29666.64,0.00,0.00,0.00),('1','176','920','257526',4903639,'2722','409',8663.75,9437.26,0.00,0.00,773.51,397584.14,0.00,0.00,0.00),('1','176','920','257526',4903640,'2723','409',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257527',4903641,'2720','409',44000.19,44888.05,0.00,0.00,887.86,457985.44,0.00,0.00,0.00),('1','176','920','257527',4903642,'2721','409',3401.25,4376.85,0.00,0.00,975.60,511038.54,0.00,0.00,0.00),('1','176','920','257527',4903643,'2722','409',9437.26,11165.62,0.00,0.00,1728.36,888377.04,0.00,0.00,0.00),('1','176','920','257527',4903644,'2723','409',0.00,80.02,0.00,0.00,80.02,41401.36,0.00,0.00,0.00),('1','176','920','257528',4903645,'2720','409',44888.05,44888.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257528',4903646,'2721','409',4376.85,4376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257528',4903647,'2722','409',11165.62,11165.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257528',4903648,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257529',4903649,'2720','409',44888.05,47301.78,0.00,0.00,2413.73,1240657.22,0.00,0.00,0.00),('1','176','920','257529',4903650,'2721','409',4376.85,4788.18,0.00,0.00,411.33,231259.44,0.00,0.00,0.00),('1','176','920','257529',4903651,'2722','409',11165.62,13283.49,0.00,0.00,2117.87,1088585.18,0.00,0.00,0.00),('1','176','920','257529',4903652,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257530',4903653,'2720','409',47301.78,47689.78,0.00,0.00,388.00,199432.00,0.00,0.00,0.00),('1','176','920','257530',4903654,'2721','409',4788.18,4788.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257530',4903655,'2722','409',13283.49,13283.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257530',4903656,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257531',4903657,'2720','409',47689.78,47689.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257531',4903658,'2721','409',4788.18,4788.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257531',4903659,'2722','409',13283.49,13283.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257531',4903660,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257532',4903661,'2720','409',47689.78,50093.85,0.00,0.00,2404.07,1235691.98,0.00,0.00,0.00),('1','176','920','257532',4903662,'2721','409',4788.18,5105.45,0.00,0.00,317.27,180209.36,0.00,0.00,0.00),('1','176','920','257532',4903663,'2722','409',13283.49,15956.25,0.00,0.00,2672.76,1373798.64,0.00,0.00,0.00),('1','176','920','257532',4903664,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257533',4903665,'2720','409',50093.85,50142.25,0.00,0.00,48.40,24877.60,0.00,0.00,0.00),('1','176','920','257533',4903666,'2721','409',5105.45,5105.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257533',4903667,'2722','409',15956.25,15956.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257533',4903668,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257534',4903669,'2720','409',50142.25,50142.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257534',4903670,'2721','409',5105.45,5105.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257534',4903671,'2722','409',15956.25,15956.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257534',4903672,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257535',4903673,'2720','409',50142.25,51729.01,0.00,0.00,1586.76,815594.64,0.00,0.00,0.00),('1','176','920','257535',4903674,'2721','409',5105.45,5215.05,0.00,0.00,109.60,62252.80,0.00,0.00,0.00),('1','176','920','257535',4903675,'2722','409',15956.25,16152.25,0.00,0.00,196.00,100744.00,0.00,0.00,0.00),('1','176','920','257535',4903676,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257536',4903677,'2720','409',51729.01,53275.03,0.00,0.00,1546.02,794982.06,0.00,0.00,0.00),('1','176','920','257536',4903678,'2721','409',5215.05,5370.62,0.00,0.00,155.57,88363.76,0.00,0.00,0.00),('1','176','920','257536',4903679,'2722','409',16152.25,17433.85,0.00,0.00,1281.60,658742.40,0.00,0.00,0.00),('1','176','920','257536',4903680,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257537',4903681,'2720','409',53275.03,53275.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257537',4903682,'2721','409',5370.62,5370.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257537',4903683,'2722','409',17433.85,17433.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257537',4903684,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257538',4903685,'2720','409',53275.03,53852.03,0.00,0.00,577.00,296578.00,0.00,0.00,0.00),('1','176','920','257538',4903686,'2721','409',5370.62,5435.63,0.00,0.00,65.01,36925.68,0.00,0.00,0.00),('1','176','920','257538',4903687,'2722','409',17433.85,17841.21,0.00,0.00,407.36,212858.48,0.00,0.00,0.00),('1','176','920','257538',4903688,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257539',4903689,'2720','409',53852.03,56093.15,0.00,0.00,2241.12,1152772.68,0.00,0.00,0.00),('1','176','920','257539',4903690,'2721','409',5435.63,5794.85,0.00,0.00,359.22,195936.96,0.00,0.00,0.00),('1','176','920','257539',4903691,'2722','409',17841.21,19403.83,0.00,0.00,1562.62,803186.68,0.00,0.00,0.00),('1','176','920','257539',4903692,'2723','409',80.02,80.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257540',4903693,'2720','409',56093.15,58541.04,0.00,0.00,2447.89,1262442.58,0.00,0.00,0.00),('1','176','920','257540',4903694,'2721','409',5794.85,6564.88,0.00,0.00,770.03,406419.92,0.00,0.00,0.00),('1','176','920','257540',4903695,'2722','409',19403.83,20288.38,0.00,0.00,884.55,455333.70,0.00,0.00,0.00),('1','176','920','257540',4903696,'2723','409',80.02,242.02,0.00,0.00,162.00,83268.00,0.00,0.00,0.00),('1','176','920','257541',4903697,'2720','409',58541.04,58861.72,0.00,0.00,320.68,166594.24,0.00,0.00,0.00),('1','176','920','257541',4903698,'2721','409',6564.88,6626.23,0.00,0.00,61.35,32146.80,0.00,0.00,0.00),('1','176','920','257541',4903699,'2722','409',20288.38,20802.86,0.00,0.00,514.48,264442.72,0.00,0.00,0.00),('1','176','920','257541',4903700,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257542',4903701,'2720','409',58861.72,58861.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257542',4903702,'2721','409',6626.23,6626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257542',4903703,'2722','409',20802.86,20802.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257542',4903704,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257543',4903705,'2720','409',58861.72,60302.27,0.00,0.00,1440.55,740442.70,0.00,0.00,0.00),('1','176','920','257543',4903706,'2721','409',6626.23,6994.04,0.00,0.00,367.81,205136.08,0.00,0.00,0.00),('1','176','920','257543',4903707,'2722','409',20802.86,23014.95,0.00,0.00,2212.09,1137014.26,0.00,0.00,0.00),('1','176','920','257543',4903708,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257544',4903709,'2720','409',60302.27,61112.06,0.00,0.00,809.79,418266.78,0.00,0.00,0.00),('1','176','920','257544',4903710,'2721','409',6994.04,7280.05,0.00,0.00,286.01,151545.68,0.00,0.00,0.00),('1','176','920','257544',4903711,'2722','409',23014.95,23064.10,0.00,0.00,49.15,25757.20,0.00,0.00,0.00),('1','176','920','257544',4903712,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257545',4903713,'2720','409',61112.06,61112.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257545',4903714,'2721','409',7280.05,7280.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257545',4903715,'2722','409',23064.10,23064.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257545',4903716,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257546',4903717,'2720','409',61112.06,61878.34,0.00,0.00,766.28,395825.96,0.00,0.00,0.00),('1','176','920','257546',4903718,'2721','409',7280.05,7638.27,0.00,0.00,358.22,190049.96,0.00,0.00,0.00),('1','176','920','257546',4903719,'2722','409',23064.10,24559.98,0.00,0.00,1495.88,769210.10,0.00,0.00,0.00),('1','176','920','257546',4903720,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257547',4903721,'2720','409',61878.34,63366.55,0.00,0.00,1488.21,765757.50,0.00,0.00,0.00),('1','176','920','257547',4903722,'2721','409',7638.27,7861.29,0.00,0.00,223.02,117173.52,0.00,0.00,0.00),('1','176','920','257547',4903723,'2722','409',24559.98,25297.09,0.00,0.00,737.11,379202.32,0.00,0.00,0.00),('1','176','920','257547',4903724,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257548',4903725,'2720','409',63366.55,63366.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257548',4903726,'2721','409',7861.29,7861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257548',4903727,'2722','409',25297.09,25297.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257548',4903728,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257549',4903729,'2720','409',63366.55,63886.22,0.00,0.00,519.67,267110.38,0.00,0.00,0.00),('1','176','920','257549',4903730,'2721','409',7861.29,8067.35,0.00,0.00,206.06,117042.08,0.00,0.00,0.00),('1','176','920','257549',4903731,'2722','409',25297.09,27679.12,0.00,0.00,2382.03,1224363.42,0.00,0.00,0.00),('1','176','920','257549',4903732,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257550',4903733,'2720','409',63886.22,64811.53,0.00,0.00,925.31,475780.52,0.00,0.00,0.00),('1','176','920','257550',4903734,'2721','409',8067.35,8304.14,0.00,0.00,236.79,128772.72,0.00,0.00,0.00),('1','176','920','257550',4903735,'2722','409',27679.12,28409.22,0.00,0.00,730.10,375271.40,0.00,0.00,0.00),('1','176','920','257550',4903736,'2723','409',242.02,242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257551',4903737,'2720','409',64811.53,65738.61,0.00,0.00,927.08,476709.20,0.00,0.00,0.00),('1','176','920','257551',4903738,'2721','409',8304.14,8462.57,0.00,0.00,158.43,89988.24,0.00,0.00,0.00),('1','176','920','257551',4903739,'2722','409',28409.22,29703.25,0.00,0.00,1294.03,665131.42,0.00,0.00,0.00),('1','176','920','257551',4903740,'2723','409',242.02,392.02,0.00,0.00,150.00,77100.00,0.00,0.00,0.00),('1','176','920','257552',4903741,'2720','409',65738.61,68076.37,0.00,0.00,2337.76,1201703.68,0.00,0.00,0.00),('1','176','920','257552',4903742,'2721','409',8462.57,8639.27,0.00,0.00,176.70,92373.60,0.00,0.00,0.00),('1','176','920','257552',4903743,'2722','409',29703.25,29743.29,0.00,0.00,40.04,20851.64,0.00,0.00,0.00),('1','176','920','257552',4903744,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257553',4903745,'2720','409',68076.37,69585.21,0.00,0.00,1508.84,775543.76,0.00,0.00,0.00),('1','176','920','257553',4903746,'2721','409',8639.27,8765.50,0.00,0.00,126.23,71698.64,0.00,0.00,0.00),('1','176','920','257553',4903747,'2722','409',29743.29,31080.72,0.00,0.00,1337.43,687439.02,0.00,0.00,0.00),('1','176','920','257553',4903748,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257554',4903749,'2720','409',69585.21,70684.22,0.00,0.00,1099.01,593465.40,0.00,0.00,0.00),('1','176','920','257554',4903750,'2721','409',8765.50,8970.80,0.00,0.00,205.30,118074.00,0.00,0.00,0.00),('1','176','920','257554',4903751,'2722','409',31080.72,31719.87,0.00,0.00,639.15,345141.00,0.00,0.00,0.00),('1','176','920','257554',4903752,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257555',4903753,'2720','409',70684.22,71370.52,0.00,0.00,686.30,370602.00,0.00,0.00,0.00),('1','176','920','257555',4903754,'2721','409',8970.80,9089.41,0.00,0.00,118.61,68793.80,0.00,0.00,0.00),('1','176','920','257555',4903755,'2722','409',31719.87,32381.30,0.00,0.00,661.43,357172.20,0.00,0.00,0.00),('1','176','920','257555',4903756,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257556',4903757,'2720','409',71370.52,72845.70,0.00,0.00,1475.18,796597.20,0.00,0.00,0.00),('1','176','920','257556',4903758,'2721','409',9089.41,10725.54,0.00,0.00,1636.13,888475.40,0.00,0.00,0.00),('1','176','920','257556',4903759,'2722','409',32381.30,32803.65,0.00,0.00,422.35,228069.00,0.00,0.00,0.00),('1','176','920','257556',4903760,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257557',4903761,'2720','409',72845.70,73894.86,0.00,0.00,1049.16,568225.20,0.00,0.00,0.00),('1','176','920','257557',4903762,'2721','409',10725.54,11082.29,0.00,0.00,356.75,202463.00,0.00,0.00,0.00),('1','176','920','257557',4903763,'2722','409',32803.65,36362.68,0.00,0.00,3559.03,1922876.20,0.00,0.00,0.00),('1','176','920','257557',4903764,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257558',4903765,'2720','409',73894.86,76637.70,0.00,0.00,2742.84,1485842.80,0.00,0.00,0.00),('1','176','920','257558',4903766,'2721','409',11082.29,12134.33,0.00,0.00,1052.04,579895.60,0.00,0.00,0.00),('1','176','920','257558',4903767,'2722','409',36362.68,37741.28,0.00,0.00,1378.60,744606.00,0.00,0.00,0.00),('1','176','920','257558',4903768,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257559',4903769,'2720','409',76637.70,79120.40,0.00,0.00,2482.70,1344548.40,0.00,0.00,0.00),('1','176','920','257559',4903770,'2721','409',12134.33,12803.75,0.00,0.00,669.42,365423.60,0.00,0.00,0.00),('1','176','920','257559',4903771,'2722','409',37741.28,37929.19,0.00,0.00,187.91,101826.60,0.00,0.00,0.00),('1','176','920','257559',4903772,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257560',4903773,'2720','409',79120.40,80854.02,0.00,0.00,1733.62,937541.20,0.00,0.00,0.00),('1','176','920','257560',4903774,'2721','409',12803.75,12832.07,0.00,0.00,28.32,16425.60,0.00,0.00,0.00),('1','176','920','257560',4903775,'2722','409',37929.19,37952.35,0.00,0.00,23.16,12506.40,0.00,0.00,0.00),('1','176','920','257560',4903776,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257561',4903777,'2720','409',80854.02,81417.75,0.00,0.00,563.73,304462.60,0.00,0.00,0.00),('1','176','920','257561',4903778,'2721','409',12832.07,13041.51,0.00,0.00,209.44,118435.20,0.00,0.00,0.00),('1','176','920','257561',4903779,'2722','409',37952.35,39413.16,0.00,0.00,1460.81,788837.40,0.00,0.00,0.00),('1','176','920','257561',4903780,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257562',4903781,'2720','409',81417.75,81579.56,0.00,0.00,161.81,103558.40,0.00,0.00,0.00),('1','176','920','257562',4903782,'2721','409',13041.51,13379.45,0.00,0.00,337.94,216281.60,0.00,0.00,0.00),('1','176','920','257562',4903783,'2722','409',39413.16,39425.66,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','176','920','257562',4903784,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257563',4903785,'2720','409',81579.56,81843.00,0.00,0.00,263.44,168601.60,0.00,0.00,0.00),('1','176','920','257563',4903786,'2721','409',13379.45,13707.01,0.00,0.00,327.56,209638.40,0.00,0.00,0.00),('1','176','920','257563',4903787,'2722','409',39425.66,39439.65,0.00,0.00,13.99,8953.60,0.00,0.00,0.00),('1','176','920','257563',4903788,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257564',4903789,'2720','409',81843.00,82049.75,0.00,0.00,206.75,132320.00,0.00,0.00,0.00),('1','176','920','257564',4903790,'2721','409',13707.01,13816.07,0.00,0.00,109.06,69798.40,0.00,0.00,0.00),('1','176','920','257564',4903791,'2722','409',39439.65,39439.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257564',4903792,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257565',4903793,'2720','409',82049.75,82369.38,0.00,0.00,319.63,204563.20,0.00,0.00,0.00),('1','176','920','257565',4903794,'2721','409',13816.07,14087.58,0.00,0.00,271.51,173766.40,0.00,0.00,0.00),('1','176','920','257565',4903795,'2722','409',39439.65,39439.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257565',4903796,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257566',4903797,'2720','409',82369.38,82439.46,0.00,0.00,70.08,44851.20,0.00,0.00,0.00),('1','176','920','257566',4903798,'2721','409',14087.58,14745.52,0.00,0.00,657.94,421081.60,0.00,0.00,0.00),('1','176','920','257566',4903799,'2722','409',39439.65,39439.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257566',4903800,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257567',4903801,'2720','409',82439.46,82439.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257567',4903802,'2721','409',14745.52,15414.60,0.00,0.00,669.08,428211.20,0.00,0.00,0.00),('1','176','920','257567',4903803,'2722','409',39439.65,39439.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257567',4903804,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257568',4903805,'2720','409',82439.46,83244.02,0.00,0.00,804.56,514918.40,0.00,0.00,0.00),('1','176','920','257568',4903806,'2721','409',15414.60,15494.37,0.00,0.00,79.77,54243.60,0.00,0.00,0.00),('1','176','920','257568',4903807,'2722','409',39439.65,39874.65,0.00,0.00,435.00,278400.00,0.00,0.00,0.00),('1','176','920','257568',4903808,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257569',4903809,'2720','409',83244.02,83244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257569',4903810,'2721','409',15494.37,15494.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257569',4903811,'2722','409',39874.65,39874.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257569',4903812,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257570',4903813,'2720','409',83244.02,83489.49,0.00,0.00,245.47,157100.80,0.00,0.00,0.00),('1','176','920','257570',4903814,'2721','409',15494.37,15643.84,0.00,0.00,149.47,101639.60,0.00,0.00,0.00),('1','176','920','257570',4903815,'2722','409',39874.65,39874.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257570',4903816,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257571',4903817,'2720','409',83489.49,83757.74,0.00,0.00,268.25,171680.00,0.00,0.00,0.00),('1','176','920','257571',4903818,'2721','409',15643.84,15947.64,0.00,0.00,303.80,206584.00,0.00,0.00,0.00),('1','176','920','257571',4903819,'2722','409',39874.65,40488.13,0.00,0.00,613.48,392627.20,0.00,0.00,0.00),('1','176','920','257571',4903820,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257572',4903821,'2720','409',83757.74,83821.80,0.00,0.00,64.06,40998.40,0.00,0.00,0.00),('1','176','920','257572',4903822,'2721','409',15947.64,16246.55,0.00,0.00,298.91,202258.80,0.00,0.00,0.00),('1','176','920','257572',4903823,'2722','409',40488.13,40840.35,0.00,0.00,352.22,225420.80,0.00,0.00,0.00),('1','176','920','257572',4903824,'2723','409',392.02,392.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257573',4903825,'2720','409',83821.80,84158.27,0.00,0.00,336.47,204679.60,0.00,0.00,0.00),('1','176','920','257573',4903826,'2721','409',16246.55,16729.42,0.00,0.00,482.87,312547.60,0.00,0.00,0.00),('1','176','920','257573',4903827,'2722','409',40840.35,41803.14,0.00,0.00,962.79,585376.32,0.00,0.00,0.00),('1','176','920','257573',4903828,'2723','409',392.02,442.02,0.00,0.00,50.00,30400.00,0.00,0.00,0.00),('1','176','920','257574',4903829,'2720','409',84158.27,84158.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257574',4903830,'2721','409',16729.42,16967.32,0.00,0.00,237.90,147660.00,0.00,0.00,0.00),('1','176','920','257574',4903831,'2722','409',41803.14,42060.79,0.00,0.00,257.65,156651.20,0.00,0.00,0.00),('1','176','920','257574',4903832,'2723','409',442.02,542.02,0.00,0.00,100.00,60800.00,0.00,0.00,0.00),('1','176','920','257575',4903833,'2720','409',84158.27,84842.27,0.00,0.00,684.00,415872.00,0.00,0.00,0.00),('1','176','920','257575',4903834,'2721','409',16967.32,17130.40,0.00,0.00,163.08,110894.40,0.00,0.00,0.00),('1','176','920','257575',4903835,'2722','409',42060.79,43428.14,0.00,0.00,1367.35,831883.04,0.00,0.00,0.00),('1','176','920','257575',4903836,'2723','409',542.02,1045.06,0.00,0.00,503.04,305848.32,0.00,0.00,0.00),('1','176','920','257576',4903837,'2720','409',84842.27,85808.33,0.00,0.00,966.06,587364.48,0.00,0.00,0.00),('1','176','920','257576',4903838,'2721','409',17130.40,17395.64,0.00,0.00,265.24,173163.20,0.00,0.00,0.00),('1','176','920','257576',4903839,'2722','409',43428.14,44318.34,0.00,0.00,890.20,541241.60,0.00,0.00,0.00),('1','176','920','257576',4903840,'2723','409',1045.06,1364.53,0.00,0.00,319.47,194237.76,0.00,0.00,0.00),('1','176','920','257577',4903841,'2720','409',85808.33,85808.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257577',4903842,'2721','409',17395.64,17395.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257577',4903843,'2722','409',44318.34,44318.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257577',4903844,'2723','409',1364.53,1364.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257578',4903845,'2720','409',85808.33,86126.33,0.00,0.00,318.00,193344.00,0.00,0.00,0.00),('1','176','920','257578',4903846,'2721','409',17395.64,17470.87,0.00,0.00,75.23,51156.40,0.00,0.00,0.00),('1','176','920','257578',4903847,'2722','409',44318.34,44354.52,0.00,0.00,36.18,21997.44,0.00,0.00,0.00),('1','176','920','257578',4903848,'2723','409',1364.53,1591.58,0.00,0.00,227.05,138046.40,0.00,0.00,0.00),('1','176','920','257579',4903849,'2720','409',86126.33,87073.33,0.00,0.00,947.00,575776.00,0.00,0.00,0.00),('1','176','920','257579',4903850,'2721','409',17470.87,17630.83,0.00,0.00,159.96,108772.80,0.00,0.00,0.00),('1','176','920','257579',4903851,'2722','409',44354.52,45753.31,0.00,0.00,1398.79,850464.32,0.00,0.00,0.00),('1','176','920','257579',4903852,'2723','409',1591.58,3380.78,0.00,0.00,1789.20,1087833.60,0.00,0.00,0.00),('1','176','920','257580',4903853,'2720','409',87073.33,87073.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257580',4903854,'2721','409',17630.83,17630.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257580',4903855,'2722','409',45753.31,45753.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257580',4903856,'2723','409',3380.78,3380.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257581',4903857,'2720','409',87073.33,88475.28,0.00,0.00,1401.95,852385.60,0.00,0.00,0.00),('1','176','920','257581',4903858,'2721','409',17630.83,18010.50,0.00,0.00,379.67,250111.60,0.00,0.00,0.00),('1','176','920','257581',4903859,'2722','409',45753.31,48182.30,0.00,0.00,2428.99,1477710.08,0.00,0.00,0.00),('1','176','920','257581',4903860,'2723','409',3380.78,4140.16,0.00,0.00,759.38,461703.04,0.00,0.00,0.00),('1','176','920','257582',4903861,'2720','409',88475.28,89332.14,0.00,0.00,856.86,521817.60,0.00,0.00,0.00),('1','176','920','257582',4903862,'2721','409',18010.50,18376.93,0.00,0.00,366.43,235060.40,0.00,0.00,0.00),('1','176','920','257582',4903863,'2722','409',48182.30,49061.36,0.00,0.00,879.06,534468.48,0.00,0.00,0.00),('1','176','920','257582',4903864,'2723','409',4140.16,5955.22,0.00,0.00,1815.06,1104403.20,0.00,0.00,0.00),('1','176','920','257583',4903865,'2720','409',89332.14,89647.90,0.00,0.00,315.76,192987.92,0.00,0.00,0.00),('1','176','920','257583',4903866,'2721','409',18376.93,18727.93,0.00,0.00,351.00,215208.00,0.00,0.00,0.00),('1','176','920','257583',4903867,'2722','409',49061.36,49273.12,0.00,0.00,211.76,129596.80,0.00,0.00,0.00),('1','176','920','257583',4903868,'2723','409',5955.22,6187.27,0.00,0.00,232.05,141668.88,0.00,0.00,0.00),('1','176','920','257584',4903869,'2720','409',89647.90,90222.93,0.00,0.00,575.03,350835.76,0.00,0.00,0.00),('1','176','920','257584',4903870,'2721','409',18727.93,19201.42,0.00,0.00,473.49,299669.04,0.00,0.00,0.00),('1','176','920','257584',4903871,'2722','409',49273.12,50853.73,0.00,0.00,1580.61,964714.56,0.00,0.00,0.00),('1','176','920','257584',4903872,'2723','409',6187.27,7037.27,0.00,0.00,850.00,516800.00,0.00,0.00,0.00),('1','176','920','257585',4903873,'2720','409',90222.93,91210.27,0.00,0.00,987.34,600302.72,0.00,0.00,0.00),('1','176','920','257585',4903874,'2721','409',19201.42,19244.86,0.00,0.00,43.44,29539.20,0.00,0.00,0.00),('1','176','920','257585',4903875,'2722','409',50853.73,51193.82,0.00,0.00,340.09,206774.72,0.00,0.00,0.00),('1','176','920','257585',4903876,'2723','409',7037.27,7187.27,0.00,0.00,150.00,91200.00,0.00,0.00,0.00),('1','176','920','257586',4903877,'2720','409',91210.27,91537.68,0.00,0.00,327.41,199065.28,0.00,0.00,0.00),('1','176','920','257586',4903878,'2721','409',19244.86,19370.81,0.00,0.00,125.95,85646.00,0.00,0.00,0.00),('1','176','920','257586',4903879,'2722','409',51193.82,51466.71,0.00,0.00,272.89,166277.12,0.00,0.00,0.00),('1','176','920','257586',4903880,'2723','409',7187.27,7724.37,0.00,0.00,537.10,326556.80,0.00,0.00,0.00),('1','176','920','257587',4903881,'2720','409',91537.68,92008.21,0.00,0.00,470.53,286399.76,0.00,0.00,0.00),('1','176','920','257587',4903882,'2721','409',19370.81,19640.63,0.00,0.00,269.82,168961.68,0.00,0.00,0.00),('1','176','920','257587',4903883,'2722','409',51466.71,53256.79,0.00,0.00,1790.08,1094014.88,0.00,0.00,0.00),('1','176','920','257587',4903884,'2723','409',7724.37,8930.58,0.00,0.00,1206.21,733666.56,0.00,0.00,0.00),('1','176','920','257588',4903885,'2720','409',92008.21,93019.14,0.00,0.00,1010.93,614645.44,0.00,0.00,0.00),('1','176','920','257588',4903886,'2721','409',19640.63,19708.85,0.00,0.00,68.22,46389.60,0.00,0.00,0.00),('1','176','920','257588',4903887,'2722','409',53256.79,53411.79,0.00,0.00,155.00,94240.00,0.00,0.00,0.00),('1','176','920','257588',4903888,'2723','409',8930.58,9030.58,0.00,0.00,100.00,60800.00,0.00,0.00,0.00),('1','176','920','257589',4903889,'2720','409',93019.14,93744.57,0.00,0.00,725.43,441061.44,0.00,0.00,0.00),('1','176','920','257589',4903890,'2721','409',19708.85,19877.67,0.00,0.00,168.82,111197.60,0.00,0.00,0.00),('1','176','920','257589',4903891,'2722','409',53411.79,53498.34,0.00,0.00,86.55,53680.80,0.00,0.00,0.00),('1','176','920','257589',4903892,'2723','409',9030.58,9030.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257590',4903893,'2720','409',93744.57,94822.90,0.00,0.00,1078.33,672877.92,0.00,0.00,0.00),('1','176','920','257590',4903894,'2721','409',19877.67,19928.88,0.00,0.00,51.21,35232.48,0.00,0.00,0.00),('1','176','920','257590',4903895,'2722','409',53498.34,53860.87,0.00,0.00,362.53,227018.72,0.00,0.00,0.00),('1','176','920','257590',4903896,'2723','409',9030.58,9127.58,0.00,0.00,97.00,60528.00,0.00,0.00,0.00),('1','176','920','257591',4903897,'2720','409',94822.90,94822.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257591',4903898,'2721','409',19928.88,19928.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257591',4903899,'2722','409',53860.87,53860.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257591',4903900,'2723','409',9127.58,9127.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257592',4903901,'2720','409',94822.90,96384.67,0.00,0.00,1561.77,976433.12,0.00,0.00,0.00),('1','176','920','257592',4903902,'2721','409',19928.88,20420.18,0.00,0.00,491.30,315742.40,0.00,0.00,0.00),('1','176','920','257592',4903903,'2722','409',53860.87,55032.63,0.00,0.00,1171.76,735112.96,0.00,0.00,0.00),('1','176','920','257592',4903904,'2723','409',9127.58,9582.61,0.00,0.00,455.03,283938.72,0.00,0.00,0.00),('1','176','920','257593',4903905,'2720','409',96384.67,97258.18,0.00,0.00,873.51,545070.24,0.00,0.00,0.00),('1','176','920','257593',4903906,'2721','409',20420.18,20620.96,0.00,0.00,200.78,131736.64,0.00,0.00,0.00),('1','176','920','257593',4903907,'2722','409',55032.63,55485.09,0.00,0.00,452.46,282335.04,0.00,0.00,0.00),('1','176','920','257593',4903908,'2723','409',9582.61,9582.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257594',4903909,'2720','409',97258.18,97258.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257594',4903910,'2721','409',20620.96,20620.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257594',4903911,'2722','409',55485.09,55485.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257594',4903912,'2723','409',9582.61,9582.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257595',4903913,'2720','409',97258.18,98312.74,0.00,0.00,1054.56,658045.44,0.00,0.00,0.00),('1','176','920','257595',4903914,'2721','409',20620.96,20725.60,0.00,0.00,104.64,71582.08,0.00,0.00,0.00),('1','176','920','257595',4903915,'2722','409',55485.09,55714.09,0.00,0.00,229.00,142896.00,0.00,0.00,0.00),('1','176','920','257595',4903916,'2723','409',9582.61,9632.61,0.00,0.00,50.00,31200.00,0.00,0.00,0.00),('1','176','920','257596',4903917,'2720','409',98312.74,98548.74,0.00,0.00,236.00,147264.00,0.00,0.00,0.00),('1','176','920','257596',4903918,'2721','409',20725.60,20768.18,0.00,0.00,42.58,29295.04,0.00,0.00,0.00),('1','176','920','257596',4903919,'2722','409',55714.09,56587.89,0.00,0.00,873.80,545446.40,0.00,0.00,0.00),('1','176','920','257596',4903920,'2723','409',9632.61,9780.69,0.00,0.00,148.08,92401.92,0.00,0.00,0.00),('1','176','920','257597',4903921,'2720','409',98548.74,98998.74,0.00,0.00,450.00,279000.00,0.00,0.00,0.00),('1','176','920','257597',4903922,'2721','409',20768.18,21027.04,0.00,0.00,258.86,170321.92,0.00,0.00,0.00),('1','176','920','257597',4903923,'2722','409',56587.89,57790.68,0.00,0.00,1202.79,745729.80,0.00,0.00,0.00),('1','176','920','257597',4903924,'2723','409',9780.69,10070.86,0.00,0.00,290.17,180596.96,0.00,0.00,0.00),('1','176','920','257598',4903925,'2720','409',98998.74,98998.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257598',4903926,'2721','409',21027.04,21027.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257598',4903927,'2722','409',57790.68,57850.19,0.00,0.00,59.51,36420.12,0.00,0.00,0.00),('1','176','920','257598',4903928,'2723','409',10070.86,10070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257599',4903929,'2720','409',98998.74,99169.74,0.00,0.00,171.00,104652.00,0.00,0.00,0.00),('1','176','920','257599',4903930,'2721','409',21027.04,21219.12,0.00,0.00,192.08,127541.12,0.00,0.00,0.00),('1','176','920','257599',4903931,'2722','409',57850.19,60061.68,0.00,0.00,2211.49,1355931.00,0.00,0.00,0.00),('1','176','920','257599',4903932,'2723','409',10070.86,10570.86,0.00,0.00,500.00,306000.00,0.00,0.00,0.00),('1','176','920','257600',4903933,'2720','409',99169.74,99535.86,0.00,0.00,366.12,224328.04,0.00,0.00,0.00),('1','176','920','257600',4903934,'2721','409',21219.12,21272.59,0.00,0.00,53.47,35504.08,0.00,0.00,0.00),('1','176','920','257600',4903935,'2722','409',60061.68,61207.50,0.00,0.00,1145.82,704221.44,0.00,0.00,0.00),('1','176','920','257600',4903936,'2723','409',10570.86,10930.88,0.00,0.00,360.02,220645.28,0.00,0.00,0.00),('1','176','920','257601',4903937,'2720','409',99535.86,99630.08,0.00,0.00,94.22,57662.64,0.00,0.00,0.00),('1','176','920','257601',4903938,'2721','409',21272.59,21473.89,0.00,0.00,201.30,133663.20,0.00,0.00,0.00),('1','176','920','257601',4903939,'2722','409',61207.50,61754.08,0.00,0.00,546.58,334506.96,0.00,0.00,0.00),('1','176','920','257601',4903940,'2723','409',10930.88,11824.99,0.00,0.00,894.11,547195.32,0.00,0.00,0.00),('1','176','920','257602',4903941,'2720','409',99630.08,100754.18,0.00,0.00,1124.10,687949.20,0.00,0.00,0.00),('1','176','920','257602',4903942,'2721','409',21473.89,21624.63,0.00,0.00,150.74,100091.36,0.00,0.00,0.00),('1','176','920','257602',4903943,'2722','409',61754.08,63363.03,0.00,0.00,1608.95,985327.40,0.00,0.00,0.00),('1','176','920','257602',4903944,'2723','409',11824.99,12204.99,0.00,0.00,380.00,232560.00,0.00,0.00,0.00),('1','176','920','257603',4903945,'2720','409',100754.18,102643.57,0.00,0.00,1889.39,1156502.72,0.00,0.00,0.00),('1','176','920','257603',4903946,'2721','409',21624.63,21678.91,0.00,0.00,54.28,36041.92,0.00,0.00,0.00),('1','176','920','257603',4903947,'2722','409',63363.03,63775.61,0.00,0.00,412.58,252498.96,0.00,0.00,0.00),('1','176','920','257603',4903948,'2723','409',12204.99,12354.99,0.00,0.00,150.00,91800.00,0.00,0.00,0.00),('1','176','920','257604',4903949,'2720','409',102643.57,104344.22,0.00,0.00,1700.65,1040797.80,0.00,0.00,0.00),('1','176','920','257604',4903950,'2721','409',21678.91,21778.90,0.00,0.00,99.99,66393.36,0.00,0.00,0.00),('1','176','920','257604',4903951,'2722','409',63775.61,64172.72,0.00,0.00,397.11,243344.36,0.00,0.00,0.00),('1','176','920','257604',4903952,'2723','409',12354.99,12650.99,0.00,0.00,296.00,181152.00,0.00,0.00,0.00),('1','176','920','257605',4903953,'2720','409',104344.22,105716.15,0.00,0.00,1371.93,839777.68,0.00,0.00,0.00),('1','176','920','257605',4903954,'2721','409',21778.90,21959.31,0.00,0.00,180.41,119792.24,0.00,0.00,0.00),('1','176','920','257605',4903955,'2722','409',64172.72,64207.03,0.00,0.00,34.31,20997.72,0.00,0.00,0.00),('1','176','920','257605',4903956,'2723','409',12650.99,13438.30,0.00,0.00,787.31,481833.72,0.00,0.00,0.00),('1','176','920','257606',4903957,'2720','409',105716.15,107662.97,0.00,0.00,1946.82,1191610.36,0.00,0.00,0.00),('1','176','920','257606',4903958,'2721','409',21959.31,22057.38,0.00,0.00,98.07,65118.48,0.00,0.00,0.00),('1','176','920','257606',4903959,'2722','409',64207.03,64502.03,0.00,0.00,295.00,180540.00,0.00,0.00,0.00),('1','176','920','257606',4903960,'2723','409',13438.30,13468.30,0.00,0.00,30.00,18360.00,0.00,0.00,0.00),('1','176','920','257607',4903961,'2720','409',107662.97,107662.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257607',4903962,'2721','409',22057.38,22057.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257607',4903963,'2722','409',64502.03,64502.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257607',4903964,'2723','409',13468.30,13468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257608',4903965,'2720','409',107662.97,108048.47,0.00,0.00,385.50,235926.00,0.00,0.00,0.00),('1','176','920','257608',4903966,'2721','409',22057.38,22057.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257608',4903967,'2722','409',64502.03,65223.00,0.00,0.00,720.97,441233.64,0.00,0.00,0.00),('1','176','920','257608',4903968,'2723','409',13468.30,13468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257609',4903969,'2720','409',108048.47,109767.78,0.00,0.00,1719.31,1052468.36,0.00,0.00,0.00),('1','176','920','257609',4903970,'2721','409',22057.38,22174.24,0.00,0.00,116.86,77595.04,0.00,0.00,0.00),('1','176','920','257609',4903971,'2722','409',65223.00,65490.16,0.00,0.00,267.16,163501.92,0.00,0.00,0.00),('1','176','920','257609',4903972,'2723','409',13468.30,13518.30,0.00,0.00,50.00,30600.00,0.00,0.00,0.00),('1','176','920','257610',4903973,'2720','409',109767.78,110478.83,0.00,0.00,711.05,430483.20,0.00,0.00,0.00),('1','176','920','257610',4903974,'2721','409',22174.24,22191.20,0.00,0.00,16.96,11261.44,0.00,0.00,0.00),('1','176','920','257610',4903975,'2722','409',65490.16,66406.91,0.00,0.00,916.75,554633.75,0.00,0.00,0.00),('1','176','920','257610',4903976,'2723','409',13518.30,13596.23,0.00,0.00,77.93,51745.52,0.00,0.00,0.00),('1','176','920','257611',4903977,'2720','409',110478.83,110823.29,0.00,0.00,344.46,208398.30,0.00,0.00,0.00),('1','176','920','257611',4903978,'2721','409',22191.20,22191.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257611',4903979,'2722','409',66406.91,66406.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257611',4903980,'2723','409',13596.23,13596.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257612',4903981,'2720','409',110823.29,110823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257612',4903982,'2721','409',22191.20,22191.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257612',4903983,'2722','409',66406.91,66406.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257612',4903984,'2723','409',13596.23,13596.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257613',4903985,'2720','409',110823.29,113161.90,0.00,0.00,2338.61,1414859.05,0.00,0.00,0.00),('1','176','920','257613',4903986,'2721','409',22191.20,22493.08,0.00,0.00,301.88,200448.32,0.00,0.00,0.00),('1','176','920','257613',4903987,'2722','409',66406.91,66792.91,0.00,0.00,386.00,233530.00,0.00,0.00,0.00),('1','176','920','257613',4903988,'2723','409',13596.23,14656.20,0.00,0.00,1059.97,641281.85,0.00,0.00,0.00),('1','176','920','257614',4903989,'2720','409',113161.90,113777.90,0.00,0.00,616.00,372680.00,0.00,0.00,0.00),('1','176','920','257614',4903990,'2721','409',22493.08,22562.39,0.00,0.00,69.31,46021.84,0.00,0.00,0.00),('1','176','920','257614',4903991,'2722','409',66792.91,67256.13,0.00,0.00,463.22,280248.10,0.00,0.00,0.00),('1','176','920','257614',4903992,'2723','409',14656.20,14884.68,0.00,0.00,228.48,138230.40,0.00,0.00,0.00),('1','176','920','257615',4903993,'2720','409',113777.90,116516.46,0.00,0.00,2738.56,1656962.14,0.00,0.00,0.00),('1','176','920','257615',4903994,'2721','409',22562.39,22800.39,0.00,0.00,238.00,157442.00,0.00,0.00,0.00),('1','176','920','257615',4903995,'2722','409',67256.13,67813.92,0.00,0.00,557.79,337462.95,0.00,0.00,0.00),('1','176','920','257615',4903996,'2723','409',14884.68,15234.68,0.00,0.00,350.00,211750.00,0.00,0.00,0.00),('1','176','920','257616',4903997,'2720','409',116516.46,116516.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257616',4903998,'2721','409',22800.39,23259.11,0.00,0.00,458.72,304590.08,0.00,0.00,0.00),('1','176','920','257616',4903999,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257616',4904000,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257617',4904001,'2720','409',116516.46,116516.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257617',4904002,'2721','409',23259.11,24065.94,0.00,0.00,806.83,535735.12,0.00,0.00,0.00),('1','176','920','257617',4904003,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257617',4904004,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257618',4904005,'2720','409',116516.46,116516.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257618',4904006,'2721','409',24065.94,24065.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257618',4904007,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257618',4904008,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257619',4904009,'2720','409',116516.46,116522.48,0.00,0.00,6.02,3997.28,0.00,0.00,0.00),('1','176','920','257619',4904010,'2721','409',24065.94,24490.71,0.00,0.00,424.77,282047.28,0.00,0.00,0.00),('1','176','920','257619',4904011,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257619',4904012,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257620',4904013,'2720','409',116522.48,116522.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257620',4904014,'2721','409',24490.71,24808.03,0.00,0.00,317.32,210700.48,0.00,0.00,0.00),('1','176','920','257620',4904015,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257620',4904016,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257621',4904017,'2720','409',116522.48,116524.74,0.00,0.00,2.26,1500.64,0.00,0.00,0.00),('1','176','920','257621',4904018,'2721','409',24808.03,25173.10,0.00,0.00,365.07,242406.48,0.00,0.00,0.00),('1','176','920','257621',4904019,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257621',4904020,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257622',4904021,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257622',4904022,'2721','409',25173.10,25173.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257622',4904023,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257622',4904024,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257623',4904025,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257623',4904026,'2721','409',25173.10,25463.10,0.00,0.00,290.00,192560.00,0.00,0.00,0.00),('1','176','920','257623',4904027,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257623',4904028,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257624',4904029,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257624',4904030,'2721','409',25463.10,25888.78,0.00,0.00,425.68,282651.52,0.00,0.00,0.00),('1','176','920','257624',4904031,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257624',4904032,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257625',4904033,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257625',4904034,'2721','409',25888.78,26649.96,0.00,0.00,761.18,505423.52,0.00,0.00,0.00),('1','176','920','257625',4904035,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257625',4904036,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257626',4904037,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257626',4904038,'2721','409',26649.96,26988.11,0.00,0.00,338.15,224531.60,0.00,0.00,0.00),('1','176','920','257626',4904039,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257626',4904040,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257627',4904041,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257627',4904042,'2721','409',26988.11,27491.23,0.00,0.00,503.12,334071.68,0.00,0.00,0.00),('1','176','920','257627',4904043,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257627',4904044,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257628',4904045,'2720','409',116524.74,116524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257628',4904046,'2721','409',27491.23,27491.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257628',4904047,'2722','409',67813.92,67813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257628',4904048,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257629',4904049,'2720','409',116524.74,117119.15,0.00,0.00,594.41,355457.18,0.00,0.00,0.00),('1','176','920','257629',4904050,'2721','409',27491.23,27568.82,0.00,0.00,77.59,51519.76,0.00,0.00,0.00),('1','176','920','257629',4904051,'2722','409',67813.92,68830.19,0.00,0.00,1016.27,607729.46,0.00,0.00,0.00),('1','176','920','257629',4904052,'2723','409',15234.68,15234.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257630',4904053,'2720','409',117119.15,119143.87,0.00,0.00,2024.72,1210782.56,0.00,0.00,0.00),('1','176','920','257630',4904054,'2721','409',27568.82,27920.42,0.00,0.00,351.60,233462.40,0.00,0.00,0.00),('1','176','920','257630',4904055,'2722','409',68830.19,69025.19,0.00,0.00,195.00,116610.00,0.00,0.00,0.00),('1','176','920','257630',4904056,'2723','409',15234.68,15738.68,0.00,0.00,504.00,301392.00,0.00,0.00,0.00),('1','176','920','257631',4904057,'2720','409',119143.87,119412.90,0.00,0.00,269.03,160879.94,0.00,0.00,0.00),('1','176','920','257631',4904058,'2721','409',27920.42,27920.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257631',4904059,'2722','409',69025.19,69025.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257631',4904060,'2723','409',15738.68,15738.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257632',4904061,'2720','409',119412.90,120932.35,0.00,0.00,1519.45,908631.10,0.00,0.00,0.00),('1','176','920','257632',4904062,'2721','409',27920.42,28564.37,0.00,0.00,643.95,403822.80,0.00,0.00,0.00),('1','176','920','257632',4904063,'2722','409',69025.19,69837.87,0.00,0.00,812.68,485982.64,0.00,0.00,0.00),('1','176','920','257632',4904064,'2723','409',15738.68,15913.73,0.00,0.00,175.05,104679.90,0.00,0.00,0.00),('1','176','920','257633',4904065,'2720','409',120932.35,121441.36,0.00,0.00,509.01,304387.98,0.00,0.00,0.00),('1','176','920','257633',4904066,'2721','409',28564.37,28598.70,0.00,0.00,34.33,22795.12,0.00,0.00,0.00),('1','176','920','257633',4904067,'2722','409',69837.87,70748.87,0.00,0.00,911.00,544778.00,0.00,0.00,0.00),('1','176','920','257633',4904068,'2723','409',15913.73,16307.26,0.00,0.00,393.53,236126.24,0.00,0.00,0.00),('1','176','920','257634',4904069,'2720','409',121441.36,122336.94,0.00,0.00,895.58,535556.84,0.00,0.00,0.00),('1','176','920','257634',4904070,'2721','409',28598.70,28730.32,0.00,0.00,131.62,87395.68,0.00,0.00,0.00),('1','176','920','257634',4904071,'2722','409',70748.87,70870.87,0.00,0.00,122.00,72956.00,0.00,0.00,0.00),('1','176','920','257634',4904072,'2723','409',16307.26,16609.57,0.00,0.00,302.31,180781.38,0.00,0.00,0.00),('1','176','920','257635',4904073,'2720','409',122336.94,123321.35,0.00,0.00,984.41,588677.18,0.00,0.00,0.00),('1','176','920','257635',4904074,'2721','409',28730.32,29166.40,0.00,0.00,436.08,281113.74,0.00,0.00,0.00),('1','176','920','257635',4904075,'2722','409',70870.87,72325.87,0.00,0.00,1455.00,870090.00,0.00,0.00,0.00),('1','176','920','257635',4904076,'2723','409',16609.57,17283.57,0.00,0.00,674.00,403052.00,0.00,0.00,0.00),('1','176','920','257636',4904077,'2720','409',123321.35,123926.54,0.00,0.00,605.19,361903.62,0.00,0.00,0.00),('1','176','920','257636',4904078,'2721','409',29166.40,29166.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257636',4904079,'2722','409',72325.87,72503.37,0.00,0.00,177.50,106145.00,0.00,0.00,0.00),('1','176','920','257636',4904080,'2723','409',17283.57,17283.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257637',4904081,'2720','409',123926.54,125518.34,0.00,0.00,1591.80,952045.56,0.00,0.00,0.00),('1','176','920','257637',4904082,'2721','409',29166.40,29544.65,0.00,0.00,378.25,251158.00,0.00,0.00,0.00),('1','176','920','257637',4904083,'2722','409',72503.37,72883.29,0.00,0.00,379.92,227192.16,0.00,0.00,0.00),('1','176','920','257637',4904084,'2723','409',17283.57,17901.57,0.00,0.00,618.00,369564.00,0.00,0.00,0.00),('1','176','920','257638',4904085,'2720','409',125518.34,126363.00,0.00,0.00,844.66,505106.68,0.00,0.00,0.00),('1','176','920','257638',4904086,'2721','409',29544.65,29709.33,0.00,0.00,164.68,109347.52,0.00,0.00,0.00),('1','176','920','257638',4904087,'2722','409',72883.29,73073.29,0.00,0.00,190.00,113620.00,0.00,0.00,0.00),('1','176','920','257638',4904088,'2723','409',17901.57,17951.57,0.00,0.00,50.00,29900.00,0.00,0.00,0.00),('1','176','920','257639',4904089,'2720','409',126363.00,128173.00,0.00,0.00,1810.00,1082380.00,0.00,0.00,0.00),('1','176','920','257639',4904090,'2721','409',29709.33,29779.34,0.00,0.00,70.01,46486.64,0.00,0.00,0.00),('1','176','920','257639',4904091,'2722','409',73073.29,73955.98,0.00,0.00,882.69,527848.62,0.00,0.00,0.00),('1','176','920','257639',4904092,'2723','409',17951.57,18351.57,0.00,0.00,400.00,239200.00,0.00,0.00,0.00),('1','176','920','257640',4904093,'2720','409',128173.00,129213.88,0.00,0.00,1040.88,622446.24,0.00,0.00,0.00),('1','176','920','257640',4904094,'2721','409',29779.34,29861.12,0.00,0.00,81.78,54301.92,0.00,0.00,0.00),('1','176','920','257640',4904095,'2722','409',73955.98,74547.62,0.00,0.00,591.64,353800.72,0.00,0.00,0.00),('1','176','920','257640',4904096,'2723','409',18351.57,18474.57,0.00,0.00,123.00,73554.00,0.00,0.00,0.00),('1','176','920','257641',4904097,'2720','409',129213.88,129935.11,0.00,0.00,721.23,431444.70,0.00,0.00,0.00),('1','176','920','257641',4904098,'2721','409',29861.12,30033.67,0.00,0.00,172.55,114573.20,0.00,0.00,0.00),('1','176','920','257641',4904099,'2722','409',74547.62,74652.62,0.00,0.00,105.00,62790.00,0.00,0.00,0.00),('1','176','920','257641',4904100,'2723','409',18474.57,18514.70,0.00,0.00,40.13,23997.74,0.00,0.00,0.00),('1','176','920','257642',4904101,'2720','409',129935.11,132630.11,0.00,0.00,2695.00,1611610.00,0.00,0.00,0.00),('1','176','920','257642',4904102,'2721','409',30033.67,30369.01,0.00,0.00,335.34,222665.76,0.00,0.00,0.00),('1','176','920','257642',4904103,'2722','409',74652.62,75171.39,0.00,0.00,518.77,310224.46,0.00,0.00,0.00),('1','176','920','257642',4904104,'2723','409',18514.70,18816.52,0.00,0.00,301.82,180488.36,0.00,0.00,0.00),('1','176','920','257643',4904105,'2720','409',132630.11,132630.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257643',4904106,'2721','409',30369.01,30369.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257643',4904107,'2722','409',75171.39,75171.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257643',4904108,'2723','409',18816.52,18816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257644',4904109,'2720','409',132630.11,133226.38,0.00,0.00,596.27,356569.46,0.00,0.00,0.00),('1','176','920','257644',4904110,'2721','409',30369.01,30369.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257644',4904111,'2722','409',75171.39,75171.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257644',4904112,'2723','409',18816.52,18816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257645',4904113,'2720','409',133226.38,135692.44,0.00,0.00,2466.06,1474703.88,0.00,0.00,0.00),('1','176','920','257645',4904114,'2721','409',30369.01,30634.82,0.00,0.00,265.81,176497.84,0.00,0.00,0.00),('1','176','920','257645',4904115,'2722','409',75171.39,75345.39,0.00,0.00,174.00,104052.00,0.00,0.00,0.00),('1','176','920','257645',4904116,'2723','409',18816.52,19366.75,0.00,0.00,550.23,329037.54,0.00,0.00,0.00),('1','176','920','257646',4904117,'2720','409',135692.44,135865.88,0.00,0.00,173.44,103717.12,0.00,0.00,0.00),('1','176','920','257646',4904118,'2721','409',30634.82,30697.89,0.00,0.00,63.07,41878.48,0.00,0.00,0.00),('1','176','920','257646',4904119,'2722','409',75345.39,75645.39,0.00,0.00,300.00,179400.00,0.00,0.00,0.00),('1','176','920','257646',4904120,'2723','409',19366.75,19777.87,0.00,0.00,411.12,245849.76,0.00,0.00,0.00),('1','176','920','257647',4904121,'2720','409',135865.88,137606.23,0.00,0.00,1740.35,1040729.30,0.00,0.00,0.00),('1','176','920','257647',4904122,'2721','409',30697.89,30929.12,0.00,0.00,231.23,153536.72,0.00,0.00,0.00),('1','176','920','257647',4904123,'2722','409',75645.39,76528.18,0.00,0.00,882.79,527908.42,0.00,0.00,0.00),('1','176','920','257647',4904124,'2723','409',19777.87,20169.25,0.00,0.00,391.38,234045.24,0.00,0.00,0.00),('1','176','920','257648',4904125,'2720','409',137606.23,138846.55,0.00,0.00,1240.32,741711.36,0.00,0.00,0.00),('1','176','920','257648',4904126,'2721','409',30929.12,31143.01,0.00,0.00,213.89,142022.96,0.00,0.00,0.00),('1','176','920','257648',4904127,'2722','409',76528.18,76638.18,0.00,0.00,110.00,65780.00,0.00,0.00,0.00),('1','176','920','257648',4904128,'2723','409',20169.25,20359.29,0.00,0.00,190.04,113643.92,0.00,0.00,0.00),('1','176','920','257649',4904129,'2720','409',138846.55,140702.85,0.00,0.00,1856.30,1110067.40,0.00,0.00,0.00),('1','176','920','257649',4904130,'2721','409',31143.01,31398.22,0.00,0.00,255.21,169459.44,0.00,0.00,0.00),('1','176','920','257649',4904131,'2722','409',76638.18,78566.84,0.00,0.00,1928.66,1153338.68,0.00,0.00,0.00),('1','176','920','257649',4904132,'2723','409',20359.29,21212.93,0.00,0.00,853.64,510476.72,0.00,0.00,0.00),('1','176','920','257650',4904133,'2720','409',140702.85,140702.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257650',4904134,'2721','409',31398.22,31398.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257650',4904135,'2722','409',78566.84,78673.03,0.00,0.00,106.19,63501.62,0.00,0.00,0.00),('1','176','920','257650',4904136,'2723','409',21212.93,21212.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257651',4904137,'2720','409',140702.85,142893.04,0.00,0.00,2190.19,1309733.62,0.00,0.00,0.00),('1','176','920','257651',4904138,'2721','409',31398.22,31660.56,0.00,0.00,262.34,174193.76,0.00,0.00,0.00),('1','176','920','257651',4904139,'2722','409',78673.03,79004.15,0.00,0.00,331.12,198009.76,0.00,0.00,0.00),('1','176','920','257651',4904140,'2723','409',21212.93,21362.93,0.00,0.00,150.00,89700.00,0.00,0.00,0.00),('1','176','920','257652',4904141,'2720','409',142893.04,144008.25,0.00,0.00,1115.21,666895.58,0.00,0.00,0.00),('1','176','920','257652',4904142,'2721','409',31660.56,31902.70,0.00,0.00,242.14,147910.96,0.00,0.00,0.00),('1','176','920','257652',4904143,'2722','409',79004.15,79263.15,0.00,0.00,259.00,154882.00,0.00,0.00,0.00),('1','176','920','257652',4904144,'2723','409',21362.93,21812.93,0.00,0.00,450.00,269100.00,0.00,0.00,0.00),('1','176','920','257653',4904145,'2720','409',144008.25,144775.73,0.00,0.00,767.48,458953.04,0.00,0.00,0.00),('1','176','920','257653',4904146,'2721','409',31902.70,31966.22,0.00,0.00,63.52,42177.28,0.00,0.00,0.00),('1','176','920','257653',4904147,'2722','409',79263.15,79730.54,0.00,0.00,467.39,279499.22,0.00,0.00,0.00),('1','176','920','257653',4904148,'2723','409',21812.93,22078.38,0.00,0.00,265.45,158739.10,0.00,0.00,0.00),('1','176','920','257654',4904149,'2720','409',144775.73,146692.26,0.00,0.00,1916.53,1146084.94,0.00,0.00,0.00),('1','176','920','257654',4904150,'2721','409',31966.22,32208.23,0.00,0.00,242.01,160694.64,0.00,0.00,0.00),('1','176','920','257654',4904151,'2722','409',79730.54,80084.97,0.00,0.00,354.43,211949.14,0.00,0.00,0.00),('1','176','920','257654',4904152,'2723','409',22078.38,22752.38,0.00,0.00,674.00,403052.00,0.00,0.00,0.00),('1','176','920','257655',4904153,'2720','409',146692.26,146692.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257655',4904154,'2721','409',32208.23,32208.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257655',4904155,'2722','409',80084.97,80084.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257655',4904156,'2723','409',22752.38,22752.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257656',4904157,'2720','409',146692.26,149871.35,0.00,0.00,3179.09,1901095.82,0.00,0.00,0.00),('1','176','920','257656',4904158,'2721','409',32208.23,32392.24,0.00,0.00,184.01,122182.64,0.00,0.00,0.00),('1','176','920','257656',4904159,'2722','409',80084.97,81141.09,0.00,0.00,1056.12,631559.76,0.00,0.00,0.00),('1','176','920','257656',4904160,'2723','409',22752.38,22775.79,0.00,0.00,23.41,13999.18,0.00,0.00,0.00),('1','176','920','257657',4904161,'2720','409',149871.35,150224.35,0.00,0.00,353.00,211094.00,0.00,0.00,0.00),('1','176','920','257657',4904162,'2721','409',32392.24,32428.69,0.00,0.00,36.45,24202.80,0.00,0.00,0.00),('1','176','920','257657',4904163,'2722','409',81141.09,81291.09,0.00,0.00,150.00,89700.00,0.00,0.00,0.00),('1','176','920','257657',4904164,'2723','409',22775.79,22775.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257658',4904165,'2720','409',150224.35,153560.81,0.00,0.00,3336.46,1995203.08,0.00,0.00,0.00),('1','176','920','257658',4904166,'2721','409',32428.69,32700.96,0.00,0.00,272.27,178027.82,0.00,0.00,0.00),('1','176','920','257658',4904167,'2722','409',81291.09,81770.09,0.00,0.00,479.00,286442.00,0.00,0.00,0.00),('1','176','920','257658',4904168,'2723','409',22775.79,23141.43,0.00,0.00,365.64,218652.72,0.00,0.00,0.00),('1','176','920','257659',4904169,'2720','409',153560.81,153560.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257659',4904170,'2721','409',32700.96,32700.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257659',4904171,'2722','409',81770.09,81770.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257659',4904172,'2723','409',23141.43,23141.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257660',4904173,'2720','409',153560.81,156384.90,0.00,0.00,2824.09,1689238.78,0.00,0.00,0.00),('1','176','920','257660',4904174,'2721','409',32700.96,32871.29,0.00,0.00,170.33,113099.12,0.00,0.00,0.00),('1','176','920','257660',4904175,'2722','409',81770.09,82175.02,0.00,0.00,404.93,242148.14,0.00,0.00,0.00),('1','176','920','257660',4904176,'2723','409',23141.43,23603.10,0.00,0.00,461.67,276078.66,0.00,0.00,0.00),('1','176','920','257661',4904177,'2720','409',156384.90,157127.01,0.00,0.00,742.11,443781.78,0.00,0.00,0.00),('1','176','920','257661',4904178,'2721','409',32871.29,32943.56,0.00,0.00,72.27,47987.28,0.00,0.00,0.00),('1','176','920','257661',4904179,'2722','409',82175.02,82422.26,0.00,0.00,247.24,147849.52,0.00,0.00,0.00),('1','176','920','257661',4904180,'2723','409',23603.10,23732.92,0.00,0.00,129.82,77632.36,0.00,0.00,0.00),('1','176','920','257662',4904181,'2720','409',157127.01,157127.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257662',4904182,'2721','409',32943.56,32943.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257662',4904183,'2722','409',82422.26,82422.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257662',4904184,'2723','409',23732.92,23732.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257663',4904185,'2720','409',157127.01,158137.98,0.00,0.00,1010.97,604560.06,0.00,0.00,0.00),('1','176','920','257663',4904186,'2721','409',32943.56,33019.93,0.00,0.00,76.37,50709.68,0.00,0.00,0.00),('1','176','920','257663',4904187,'2722','409',82422.26,82431.26,0.00,0.00,9.00,5382.00,0.00,0.00,0.00),('1','176','920','257663',4904188,'2723','409',23732.92,23782.92,0.00,0.00,50.00,29900.00,0.00,0.00,0.00),('1','176','920','257664',4904189,'2720','409',158137.98,158137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257664',4904190,'2721','409',33019.93,33349.47,0.00,0.00,329.54,218814.56,0.00,0.00,0.00),('1','176','920','257664',4904191,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257664',4904192,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257665',4904193,'2720','409',158137.98,158137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257665',4904194,'2721','409',33349.47,33590.68,0.00,0.00,241.21,160163.44,0.00,0.00,0.00),('1','176','920','257665',4904195,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257665',4904196,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257666',4904197,'2720','409',158137.98,158144.00,0.00,0.00,6.02,3997.28,0.00,0.00,0.00),('1','176','920','257666',4904198,'2721','409',33590.68,34009.36,0.00,0.00,418.68,278003.52,0.00,0.00,0.00),('1','176','920','257666',4904199,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257666',4904200,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257667',4904201,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257667',4904202,'2721','409',34009.36,34591.12,0.00,0.00,581.76,386288.64,0.00,0.00,0.00),('1','176','920','257667',4904203,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257667',4904204,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257668',4904205,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257668',4904206,'2721','409',34591.12,34924.47,0.00,0.00,333.35,221344.40,0.00,0.00,0.00),('1','176','920','257668',4904207,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257668',4904208,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257669',4904209,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257669',4904210,'2721','409',34924.47,35482.83,0.00,0.00,558.36,370751.04,0.00,0.00,0.00),('1','176','920','257669',4904211,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257669',4904212,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257670',4904213,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257670',4904214,'2721','409',35482.83,35940.70,0.00,0.00,457.87,304025.68,0.00,0.00,0.00),('1','176','920','257670',4904215,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257670',4904216,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257671',4904217,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257671',4904218,'2721','409',35940.70,35940.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257671',4904219,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257671',4904220,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257672',4904221,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257672',4904222,'2721','409',35940.70,36032.29,0.00,0.00,91.59,62281.20,0.00,0.00,0.00),('1','176','920','257672',4904223,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257672',4904224,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257673',4904225,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257673',4904226,'2721','409',36032.29,36450.39,0.00,0.00,418.10,284308.00,0.00,0.00,0.00),('1','176','920','257673',4904227,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257673',4904228,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257674',4904229,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257674',4904230,'2721','409',36450.39,36824.51,0.00,0.00,374.12,254401.60,0.00,0.00,0.00),('1','176','920','257674',4904231,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257674',4904232,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257675',4904233,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257675',4904234,'2721','409',36824.51,37315.35,0.00,0.00,490.84,333771.20,0.00,0.00,0.00),('1','176','920','257675',4904235,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257675',4904236,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257676',4904237,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257676',4904238,'2721','409',37315.35,38377.84,0.00,0.00,1062.49,722493.20,0.00,0.00,0.00),('1','176','920','257676',4904239,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257676',4904240,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257677',4904241,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257677',4904242,'2721','409',38377.84,39018.73,0.00,0.00,640.89,435805.20,0.00,0.00,0.00),('1','176','920','257677',4904243,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257677',4904244,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257678',4904245,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257678',4904246,'2721','409',39018.73,39468.71,0.00,0.00,449.98,305986.40,0.00,0.00,0.00),('1','176','920','257678',4904247,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257678',4904248,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257679',4904249,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257679',4904250,'2721','409',39468.71,39768.71,0.00,0.00,300.00,204000.00,0.00,0.00,0.00),('1','176','920','257679',4904251,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257679',4904252,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257680',4904253,'2720','409',158144.00,158144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257680',4904254,'2721','409',39768.71,39768.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257680',4904255,'2722','409',82431.26,82431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257680',4904256,'2723','409',23782.92,23782.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257681',4904257,'2720','409',158144.00,158584.00,0.00,0.00,440.00,297880.00,0.00,0.00,0.00),('1','176','920','257681',4904258,'2721','409',39768.71,39871.48,0.00,0.00,102.77,73994.40,0.00,0.00,0.00),('1','176','920','257681',4904259,'2722','409',82431.26,82759.26,0.00,0.00,328.00,222056.00,0.00,0.00,0.00),('1','176','920','257681',4904260,'2723','409',23782.92,24003.07,0.00,0.00,220.15,149041.55,0.00,0.00,0.00),('1','176','920','257682',4904261,'2720','409',158584.00,160961.21,0.00,0.00,2377.21,1609371.17,0.00,0.00,0.00),('1','176','920','257682',4904262,'2721','409',39871.48,40335.17,0.00,0.00,463.69,333727.80,0.00,0.00,0.00),('1','176','920','257682',4904263,'2722','409',82759.26,83417.12,0.00,0.00,657.86,445371.22,0.00,0.00,0.00),('1','176','920','257682',4904264,'2723','409',24003.07,24327.44,0.00,0.00,324.37,219598.49,0.00,0.00,0.00),('1','176','920','257683',4904265,'2720','409',160961.21,160961.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257683',4904266,'2721','409',40335.17,40335.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257683',4904267,'2722','409',83417.12,83642.86,0.00,0.00,225.74,152825.98,0.00,0.00,0.00),('1','176','920','257683',4904268,'2723','409',24327.44,24327.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257684',4904269,'2720','409',160961.21,160961.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257684',4904270,'2721','409',40335.17,40335.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257684',4904271,'2722','409',83642.86,83642.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257684',4904272,'2723','409',24327.44,24327.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257685',4904273,'2720','409',160961.21,162640.89,0.00,0.00,1679.68,1137143.36,0.00,0.00,0.00),('1','176','920','257685',4904274,'2721','409',40335.17,40688.87,0.00,0.00,353.70,254664.00,0.00,0.00,0.00),('1','176','920','257685',4904275,'2722','409',83642.86,84546.98,0.00,0.00,904.12,612089.24,0.00,0.00,0.00),('1','176','920','257685',4904276,'2723','409',24327.44,24377.44,0.00,0.00,50.00,33850.00,0.00,0.00,0.00),('1','176','920','257686',4904277,'2720','409',162640.89,164293.01,0.00,0.00,1652.12,1119282.46,0.00,0.00,0.00),('1','176','920','257686',4904278,'2721','409',40688.87,40943.77,0.00,0.00,254.90,183528.00,0.00,0.00,0.00),('1','176','920','257686',4904279,'2722','409',84546.98,84797.98,0.00,0.00,251.00,169927.00,0.00,0.00,0.00),('1','176','920','257686',4904280,'2723','409',24377.44,24477.44,0.00,0.00,100.00,67700.00,0.00,0.00,0.00),('1','176','920','257687',4904281,'2720','409',164293.01,164293.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257687',4904282,'2721','409',40943.77,40943.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257687',4904283,'2722','409',84797.98,84797.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257687',4904284,'2723','409',24477.44,24477.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257688',4904285,'2720','409',164293.01,165902.27,0.00,0.00,1609.26,1089469.02,0.00,0.00,0.00),('1','176','920','257688',4904286,'2721','409',40943.77,41293.78,0.00,0.00,350.01,250287.20,0.00,0.00,0.00),('1','176','920','257688',4904287,'2722','409',84797.98,85065.98,0.00,0.00,268.00,181436.00,0.00,0.00,0.00),('1','176','920','257688',4904288,'2723','409',24477.44,24689.44,0.00,0.00,212.00,143524.00,0.00,0.00,0.00),('1','176','920','257689',4904289,'2720','409',165902.27,166994.72,0.00,0.00,1092.45,739588.65,0.00,0.00,0.00),('1','176','920','257689',4904290,'2721','409',41293.78,41439.57,0.00,0.00,145.79,104968.80,0.00,0.00,0.00),('1','176','920','257689',4904291,'2722','409',85065.98,85237.42,0.00,0.00,171.44,116064.88,0.00,0.00,0.00),('1','176','920','257689',4904292,'2723','409',24689.44,25215.04,0.00,0.00,525.60,355831.20,0.00,0.00,0.00),('1','176','920','257690',4904293,'2720','409',166994.72,166994.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257690',4904294,'2721','409',41439.57,41439.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257690',4904295,'2722','409',85237.42,85237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257690',4904296,'2723','409',25215.04,25215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257691',4904297,'2720','409',166994.72,167229.72,0.00,0.00,235.00,159095.00,0.00,0.00,0.00),('1','176','920','257691',4904298,'2721','409',41439.57,41439.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257691',4904299,'2722','409',85237.42,85237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257691',4904300,'2723','409',25215.04,25215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257692',4904301,'2720','409',167229.72,168403.57,0.00,0.00,1173.85,821695.00,0.00,0.00,0.00),('1','176','920','257692',4904302,'2721','409',41439.57,41856.39,0.00,0.00,416.82,313783.20,0.00,0.00,0.00),('1','176','920','257692',4904303,'2722','409',85237.42,87268.68,0.00,0.00,2031.26,1421882.00,0.00,0.00,0.00),('1','176','920','257692',4904304,'2723','409',25215.04,25569.04,0.00,0.00,354.00,247800.00,0.00,0.00,0.00),('1','176','920','257693',4904305,'2720','409',168403.57,168403.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257693',4904306,'2721','409',41856.39,41856.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257693',4904307,'2722','409',87268.68,87268.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257693',4904308,'2723','409',25569.04,25569.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257694',4904309,'2720','409',168403.57,169015.57,0.00,0.00,612.00,428400.00,0.00,0.00,0.00),('1','176','920','257694',4904310,'2721','409',41856.39,42158.65,0.00,0.00,302.26,229717.60,0.00,0.00,0.00),('1','176','920','257694',4904311,'2722','409',87268.68,87964.68,0.00,0.00,696.00,487200.00,0.00,0.00,0.00),('1','176','920','257694',4904312,'2723','409',25569.04,26181.81,0.00,0.00,612.77,428939.00,0.00,0.00,0.00),('1','176','920','257695',4904313,'2720','409',169015.57,169901.57,0.00,0.00,886.00,620200.00,0.00,0.00,0.00),('1','176','920','257695',4904314,'2721','409',42158.65,42501.95,0.00,0.00,343.30,260908.00,0.00,0.00,0.00),('1','176','920','257695',4904315,'2722','409',87964.68,88785.54,0.00,0.00,820.86,574602.00,0.00,0.00,0.00),('1','176','920','257695',4904316,'2723','409',26181.81,26948.97,0.00,0.00,767.16,537012.00,0.00,0.00,0.00),('1','176','920','257696',4904317,'2720','409',169901.57,169901.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257696',4904318,'2721','409',42501.95,42501.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257696',4904319,'2722','409',88785.54,88785.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257696',4904320,'2723','409',26948.97,26948.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257697',4904321,'2720','409',169901.57,172392.74,0.00,0.00,2491.17,1743819.00,0.00,0.00,0.00),('1','176','920','257697',4904322,'2721','409',42501.95,42912.32,0.00,0.00,410.37,311881.20,0.00,0.00,0.00),('1','176','920','257697',4904323,'2722','409',88785.54,88941.06,0.00,0.00,155.52,109495.20,0.00,0.00,0.00),('1','176','920','257697',4904324,'2723','409',26948.97,27168.97,0.00,0.00,220.00,154000.00,0.00,0.00,0.00),('1','176','920','257698',4904325,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257698',4904326,'2721','409',42912.32,43659.23,0.00,0.00,746.91,567651.60,0.00,0.00,0.00),('1','176','920','257698',4904327,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257698',4904328,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257699',4904329,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257699',4904330,'2721','409',43659.23,44262.55,0.00,0.00,603.32,458523.20,0.00,0.00,0.00),('1','176','920','257699',4904331,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257699',4904332,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257700',4904333,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257700',4904334,'2721','409',44262.55,44760.10,0.00,0.00,497.55,378138.00,0.00,0.00,0.00),('1','176','920','257700',4904335,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257700',4904336,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257701',4904337,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257701',4904338,'2721','409',44760.10,44995.47,0.00,0.00,235.37,178881.20,0.00,0.00,0.00),('1','176','920','257701',4904339,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257701',4904340,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257702',4904341,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257702',4904342,'2721','409',44995.47,44995.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257702',4904343,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257702',4904344,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257703',4904345,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257703',4904346,'2721','409',44995.47,45281.27,0.00,0.00,285.80,217208.00,0.00,0.00,0.00),('1','176','920','257703',4904347,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257703',4904348,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257704',4904349,'2720','409',172392.74,172392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257704',4904350,'2721','409',45281.27,46079.36,0.00,0.00,798.09,606548.40,0.00,0.00,0.00),('1','176','920','257704',4904351,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257704',4904352,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257705',4904353,'2720','409',172392.74,172592.74,0.00,0.00,200.00,152000.00,0.00,0.00,0.00),('1','176','920','257705',4904354,'2721','409',46079.36,48520.99,0.00,0.00,2441.63,1855638.80,0.00,0.00,0.00),('1','176','920','257705',4904355,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257705',4904356,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257706',4904357,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257706',4904358,'2721','409',48520.99,49964.28,0.00,0.00,1443.29,1096900.40,0.00,0.00,0.00),('1','176','920','257706',4904359,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257706',4904360,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257707',4904361,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257707',4904362,'2721','409',49964.28,49964.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257707',4904363,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257707',4904364,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257708',4904365,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257708',4904366,'2721','409',49964.28,52337.59,0.00,0.00,2373.31,1803715.60,0.00,0.00,0.00),('1','176','920','257708',4904367,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257708',4904368,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257709',4904369,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257709',4904370,'2721','409',52337.59,53869.68,0.00,0.00,1532.09,1164388.40,0.00,0.00,0.00),('1','176','920','257709',4904371,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257709',4904372,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257710',4904373,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257710',4904374,'2721','409',53869.68,55202.37,0.00,0.00,1332.69,1012844.40,0.00,0.00,0.00),('1','176','920','257710',4904375,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257710',4904376,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257711',4904377,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257711',4904378,'2721','409',55202.37,55202.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257711',4904379,'2722','409',88941.06,88941.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257711',4904380,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257712',4904381,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257712',4904382,'2721','409',55202.37,57724.28,0.00,0.00,2521.91,1916651.60,0.00,0.00,0.00),('1','176','920','257712',4904383,'2722','409',88941.06,88946.98,0.00,0.00,5.92,4499.20,0.00,0.00,0.00),('1','176','920','257712',4904384,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257713',4904385,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257713',4904386,'2721','409',57724.28,59678.52,0.00,0.00,1954.24,1485222.40,0.00,0.00,0.00),('1','176','920','257713',4904387,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257713',4904388,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257714',4904389,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257714',4904390,'2721','409',59678.52,60502.17,0.00,0.00,823.65,625974.00,0.00,0.00,0.00),('1','176','920','257714',4904391,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257714',4904392,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257715',4904393,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257715',4904394,'2721','409',60502.17,60502.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257715',4904395,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257715',4904396,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257716',4904397,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257716',4904398,'2721','409',60502.17,60919.16,0.00,0.00,416.99,316912.40,0.00,0.00,0.00),('1','176','920','257716',4904399,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257716',4904400,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257717',4904401,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257717',4904402,'2721','409',60919.16,61907.98,0.00,0.00,988.82,751503.20,0.00,0.00,0.00),('1','176','920','257717',4904403,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257717',4904404,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257718',4904405,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257718',4904406,'2721','409',61907.98,62943.33,0.00,0.00,1035.35,786866.00,0.00,0.00,0.00),('1','176','920','257718',4904407,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257718',4904408,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257719',4904409,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257719',4904410,'2721','409',62943.33,63834.56,0.00,0.00,891.23,677334.80,0.00,0.00,0.00),('1','176','920','257719',4904411,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257719',4904412,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257720',4904413,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257720',4904414,'2721','409',63834.56,64691.30,0.00,0.00,856.74,651122.40,0.00,0.00,0.00),('1','176','920','257720',4904415,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257720',4904416,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257721',4904417,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257721',4904418,'2721','409',64691.30,65638.51,0.00,0.00,947.21,719879.60,0.00,0.00,0.00),('1','176','920','257721',4904419,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257721',4904420,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257722',4904421,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257722',4904422,'2721','409',65638.51,65638.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257722',4904423,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257722',4904424,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257723',4904425,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257723',4904426,'2721','409',65638.51,66867.14,0.00,0.00,1228.63,933758.80,0.00,0.00,0.00),('1','176','920','257723',4904427,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257723',4904428,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257724',4904429,'2720','409',172592.74,172592.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257724',4904430,'2721','409',66867.14,67404.39,0.00,0.00,537.25,408310.00,0.00,0.00,0.00),('1','176','920','257724',4904431,'2722','409',88946.98,88946.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257724',4904432,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257725',4904433,'2720','409',172592.74,173820.26,0.00,0.00,1227.52,883814.40,0.00,0.00,0.00),('1','176','920','257725',4904434,'2721','409',67404.39,68020.35,0.00,0.00,615.96,464129.60,0.00,0.00,0.00),('1','176','920','257725',4904435,'2722','409',88946.98,89174.98,0.00,0.00,228.00,164160.00,0.00,0.00,0.00),('1','176','920','257725',4904436,'2723','409',27168.97,27168.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257726',4904437,'2720','409',173820.26,174640.70,0.00,0.00,820.44,590716.80,0.00,0.00,0.00),('1','176','920','257726',4904438,'2721','409',68020.35,68153.57,0.00,0.00,133.22,101247.20,0.00,0.00,0.00),('1','176','920','257726',4904439,'2722','409',89174.98,89424.98,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','176','920','257726',4904440,'2723','409',27168.97,27318.97,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','176','920','257727',4904441,'2720','409',174640.70,174640.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257727',4904442,'2721','409',68153.57,68153.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257727',4904443,'2722','409',89424.98,89424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257727',4904444,'2723','409',27318.97,27318.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257728',4904445,'2720','409',174640.70,175730.27,0.00,0.00,1089.57,784490.40,0.00,0.00,0.00),('1','176','920','257728',4904446,'2721','409',68153.57,68277.38,0.00,0.00,123.81,94095.60,0.00,0.00,0.00),('1','176','920','257728',4904447,'2722','409',89424.98,89522.98,0.00,0.00,98.00,70560.00,0.00,0.00,0.00),('1','176','920','257728',4904448,'2723','409',27318.97,27588.97,0.00,0.00,270.00,194400.00,0.00,0.00,0.00),('1','176','920','257729',4904449,'2720','409',175730.27,178552.89,0.00,0.00,2822.62,2032286.40,0.00,0.00,0.00),('1','176','920','257729',4904450,'2721','409',68277.38,68626.85,0.00,0.00,349.47,265597.20,0.00,0.00,0.00),('1','176','920','257729',4904451,'2722','409',89522.98,89711.98,0.00,0.00,189.00,136080.00,0.00,0.00,0.00),('1','176','920','257729',4904452,'2723','409',27588.97,27726.97,0.00,0.00,138.00,99360.00,0.00,0.00,0.00),('1','176','920','257730',4904453,'2720','409',178552.89,178697.16,0.00,0.00,144.27,103874.40,0.00,0.00,0.00),('1','176','920','257730',4904454,'2721','409',68626.85,68776.85,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','176','920','257730',4904455,'2722','409',89711.98,89711.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257730',4904456,'2723','409',27726.97,27726.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257731',4904457,'2720','409',178697.16,178697.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257731',4904458,'2721','409',68776.85,68776.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257731',4904459,'2722','409',89711.98,89711.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257731',4904460,'2723','409',27726.97,27726.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257732',4904461,'2720','409',178697.16,180557.35,0.00,0.00,1860.19,1339336.80,0.00,0.00,0.00),('1','176','920','257732',4904462,'2721','409',68776.85,69096.47,0.00,0.00,319.62,242911.20,0.00,0.00,0.00),('1','176','920','257732',4904463,'2722','409',89711.98,89711.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257732',4904464,'2723','409',27726.97,27726.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257733',4904465,'2720','409',180557.35,182424.20,0.00,0.00,1866.85,1344132.00,0.00,0.00,0.00),('1','176','920','257733',4904466,'2721','409',69096.47,69437.55,0.00,0.00,341.08,259220.80,0.00,0.00,0.00),('1','176','920','257733',4904467,'2722','409',89711.98,90476.98,0.00,0.00,765.00,550800.00,0.00,0.00,0.00),('1','176','920','257733',4904468,'2723','409',27726.97,27823.97,0.00,0.00,97.00,69840.00,0.00,0.00,0.00),('1','176','920','257734',4904469,'2720','409',182424.20,182424.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257734',4904470,'2721','409',69437.55,69437.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257734',4904471,'2722','409',90476.98,90476.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257734',4904472,'2723','409',27823.97,27823.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257735',4904473,'2720','409',182424.20,182970.00,0.00,0.00,545.80,394976.00,0.00,0.00,0.00),('1','176','920','257735',4904474,'2721','409',69437.55,69599.28,0.00,0.00,161.73,122914.80,0.00,0.00,0.00),('1','176','920','257735',4904475,'2722','409',90476.98,90476.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257735',4904476,'2723','409',27823.97,28559.97,0.00,0.00,736.00,529920.00,0.00,0.00,0.00),('1','176','920','257736',4904477,'2720','409',182970.00,184977.84,0.00,0.00,2007.84,1445644.80,0.00,0.00,0.00),('1','176','920','257736',4904478,'2721','409',69599.28,69930.94,0.00,0.00,331.66,252061.60,0.00,0.00,0.00),('1','176','920','257736',4904479,'2722','409',90476.98,90986.53,0.00,0.00,509.55,366876.00,0.00,0.00,0.00),('1','176','920','257736',4904480,'2723','409',28559.97,29047.97,0.00,0.00,488.00,351360.00,0.00,0.00,0.00),('1','176','920','257737',4904481,'2720','409',184977.84,185194.47,0.00,0.00,216.63,155973.60,0.00,0.00,0.00),('1','176','920','257737',4904482,'2721','409',69930.94,69930.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257737',4904483,'2722','409',90986.53,90986.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257737',4904484,'2723','409',29047.97,29047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257738',4904485,'2720','409',185194.47,188534.60,0.00,0.00,3340.13,2404893.60,0.00,0.00,0.00),('1','176','920','257738',4904486,'2721','409',69930.94,70222.86,0.00,0.00,291.92,221859.20,0.00,0.00,0.00),('1','176','920','257738',4904487,'2722','409',90986.53,92354.48,0.00,0.00,1367.95,985082.00,0.00,0.00,0.00),('1','176','920','257738',4904488,'2723','409',29047.97,29047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257739',4904489,'2720','409',188534.60,191194.74,0.00,0.00,2660.14,1915300.80,0.00,0.00,0.00),('1','176','920','257739',4904490,'2721','409',70222.86,70572.55,0.00,0.00,349.69,264164.40,0.00,0.00,0.00),('1','176','920','257739',4904491,'2722','409',92354.48,93298.82,0.00,0.00,944.34,679924.80,0.00,0.00,0.00),('1','176','920','257739',4904492,'2723','409',29047.97,29534.91,0.00,0.00,486.94,350596.80,0.00,0.00,0.00),('1','176','920','257740',4904493,'2720','409',191194.74,191451.69,0.00,0.00,256.95,185004.00,0.00,0.00,0.00),('1','176','920','257740',4904494,'2721','409',70572.55,70697.80,0.00,0.00,125.25,95190.00,0.00,0.00,0.00),('1','176','920','257740',4904495,'2722','409',93298.82,93336.82,0.00,0.00,38.00,27360.00,0.00,0.00,0.00),('1','176','920','257740',4904496,'2723','409',29534.91,29673.59,0.00,0.00,138.68,99849.60,0.00,0.00,0.00),('1','176','920','257741',4904497,'2720','409',191451.69,191988.46,0.00,0.00,536.77,386474.40,0.00,0.00,0.00),('1','176','920','257741',4904498,'2721','409',70697.80,70944.36,0.00,0.00,246.56,187385.60,0.00,0.00,0.00),('1','176','920','257741',4904499,'2722','409',93336.82,93445.15,0.00,0.00,108.33,77997.60,0.00,0.00,0.00),('1','176','920','257741',4904500,'2723','409',29673.59,30010.70,0.00,0.00,337.11,242719.20,0.00,0.00,0.00),('1','176','920','257742',4904501,'2720','409',191988.46,193085.74,0.00,0.00,1097.28,790041.60,0.00,0.00,0.00),('1','176','920','257742',4904502,'2721','409',70944.36,71278.66,0.00,0.00,334.30,254068.00,0.00,0.00,0.00),('1','176','920','257742',4904503,'2722','409',93445.15,94457.04,0.00,0.00,1011.89,728560.80,0.00,0.00,0.00),('1','176','920','257742',4904504,'2723','409',30010.70,30805.90,0.00,0.00,795.20,572544.00,0.00,0.00,0.00),('1','176','920','257743',4904505,'2720','409',193085.74,193559.89,0.00,0.00,474.15,341388.00,0.00,0.00,0.00),('1','176','920','257743',4904506,'2721','409',71278.66,71337.07,0.00,0.00,58.41,44391.60,0.00,0.00,0.00),('1','176','920','257743',4904507,'2722','409',94457.04,94457.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257743',4904508,'2723','409',30805.90,30805.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257744',4904509,'2720','409',193559.89,195369.50,0.00,0.00,1809.61,1302919.20,0.00,0.00,0.00),('1','176','920','257744',4904510,'2721','409',71337.07,71700.61,0.00,0.00,363.54,276290.40,0.00,0.00,0.00),('1','176','920','257744',4904511,'2722','409',94457.04,95167.31,0.00,0.00,710.27,511394.40,0.00,0.00,0.00),('1','176','920','257744',4904512,'2723','409',30805.90,31047.57,0.00,0.00,241.67,174002.40,0.00,0.00,0.00),('1','176','920','257745',4904513,'2720','409',195369.50,196316.25,0.00,0.00,946.75,681660.00,0.00,0.00,0.00),('1','176','920','257745',4904514,'2721','409',71700.61,71831.63,0.00,0.00,131.02,99575.20,0.00,0.00,0.00),('1','176','920','257745',4904515,'2722','409',95167.31,95167.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257745',4904516,'2723','409',31047.57,31047.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257746',4904517,'2720','409',196316.25,196316.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257746',4904518,'2721','409',71831.63,71831.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257746',4904519,'2722','409',95167.31,95167.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257746',4904520,'2723','409',31047.57,31284.32,0.00,0.00,236.75,170460.00,0.00,0.00,0.00),('1','176','920','257747',4904521,'2720','409',196316.25,196316.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257747',4904522,'2721','409',71831.63,71831.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257747',4904523,'2722','409',95167.31,95167.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257747',4904524,'2723','409',31284.32,31284.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257748',4904525,'2720','409',196316.25,198453.32,0.00,0.00,2137.07,1538690.40,0.00,0.00,0.00),('1','176','920','257748',4904526,'2721','409',71831.63,71940.59,0.00,0.00,108.96,82809.60,0.00,0.00,0.00),('1','176','920','257748',4904527,'2722','409',95167.31,95573.36,0.00,0.00,406.05,292356.00,0.00,0.00,0.00),('1','176','920','257748',4904528,'2723','409',31284.32,31584.32,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','176','920','257749',4904529,'2720','409',198453.32,198453.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257749',4904530,'2721','409',71940.59,72162.35,0.00,0.00,221.76,168537.60,0.00,0.00,0.00),('1','176','920','257749',4904531,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257749',4904532,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257750',4904533,'2720','409',198453.32,198453.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257750',4904534,'2721','409',72162.35,72511.84,0.00,0.00,349.49,265612.40,0.00,0.00,0.00),('1','176','920','257750',4904535,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257750',4904536,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257751',4904537,'2720','409',198453.32,198453.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257751',4904538,'2721','409',72511.84,72633.26,0.00,0.00,121.42,92279.20,0.00,0.00,0.00),('1','176','920','257751',4904539,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257751',4904540,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257752',4904541,'2720','409',198453.32,198465.82,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','176','920','257752',4904542,'2721','409',72633.26,72930.29,0.00,0.00,297.03,225742.80,0.00,0.00,0.00),('1','176','920','257752',4904543,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257752',4904544,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257753',4904545,'2720','409',198465.82,198465.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257753',4904546,'2721','409',72930.29,73315.91,0.00,0.00,385.62,293071.20,0.00,0.00,0.00),('1','176','920','257753',4904547,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257753',4904548,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257754',4904549,'2720','409',198465.82,198465.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257754',4904550,'2721','409',73315.91,74033.25,0.00,0.00,717.34,545178.40,0.00,0.00,0.00),('1','176','920','257754',4904551,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257754',4904552,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257755',4904553,'2720','409',198465.82,198465.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257755',4904554,'2721','409',74033.25,74033.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257755',4904555,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257755',4904556,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257756',4904557,'2720','409',198465.82,198465.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257756',4904558,'2721','409',74033.25,75079.78,0.00,0.00,1046.53,795362.80,0.00,0.00,0.00),('1','176','920','257756',4904559,'2722','409',95573.36,95573.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257756',4904560,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257757',4904561,'2720','409',198465.82,198835.15,0.00,0.00,369.33,265917.60,0.00,0.00,0.00),('1','176','920','257757',4904562,'2721','409',75079.78,75598.30,0.00,0.00,518.52,394075.20,0.00,0.00,0.00),('1','176','920','257757',4904563,'2722','409',95573.36,95623.36,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','176','920','257757',4904564,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257758',4904565,'2720','409',198835.15,199720.16,0.00,0.00,885.01,630127.12,0.00,0.00,0.00),('1','176','920','257758',4904566,'2721','409',75598.30,75854.99,0.00,0.00,256.69,195084.40,0.00,0.00,0.00),('1','176','920','257758',4904567,'2722','409',95623.36,95935.36,0.00,0.00,312.00,222144.00,0.00,0.00,0.00),('1','176','920','257758',4904568,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257759',4904569,'2720','409',199720.16,201176.86,0.00,0.00,1456.70,1037170.40,0.00,0.00,0.00),('1','176','920','257759',4904570,'2721','409',75854.99,76059.03,0.00,0.00,204.04,155070.40,0.00,0.00,0.00),('1','176','920','257759',4904571,'2722','409',95935.36,95935.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257759',4904572,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257760',4904573,'2720','409',201176.86,201176.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257760',4904574,'2721','409',76059.03,76059.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257760',4904575,'2722','409',95935.36,95935.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257760',4904576,'2723','409',31584.32,31584.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257761',4904577,'2720','409',201176.86,202633.69,0.00,0.00,1456.83,1037262.96,0.00,0.00,0.00),('1','176','920','257761',4904578,'2721','409',76059.03,76319.25,0.00,0.00,260.22,197767.20,0.00,0.00,0.00),('1','176','920','257761',4904579,'2722','409',95935.36,96019.07,0.00,0.00,83.71,59601.52,0.00,0.00,0.00),('1','176','920','257761',4904580,'2723','409',31584.32,32000.32,0.00,0.00,416.00,296192.00,0.00,0.00,0.00),('1','176','920','257762',4904581,'2720','409',202633.69,203707.95,0.00,0.00,1074.26,764873.12,0.00,0.00,0.00),('1','176','920','257762',4904582,'2721','409',76319.25,76556.75,0.00,0.00,237.50,180500.00,0.00,0.00,0.00),('1','176','920','257762',4904583,'2722','409',96019.07,96281.07,0.00,0.00,262.00,186544.00,0.00,0.00,0.00),('1','176','920','257762',4904584,'2723','409',32000.32,32050.32,0.00,0.00,50.00,35600.00,0.00,0.00,0.00),('1','176','920','257763',4904585,'2720','409',203707.95,204692.95,0.00,0.00,985.00,684575.00,0.00,0.00,0.00),('1','176','920','257763',4904586,'2721','409',76556.75,76702.26,0.00,0.00,145.51,108259.44,0.00,0.00,0.00),('1','176','920','257763',4904587,'2722','409',96281.07,96281.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257763',4904588,'2723','409',32050.32,32260.72,0.00,0.00,210.40,146228.00,0.00,0.00,0.00),('1','176','920','257764',4904589,'2720','409',204692.95,204692.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257764',4904590,'2721','409',76702.26,76702.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257764',4904591,'2722','409',96281.07,96281.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257764',4904592,'2723','409',32260.72,32260.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257765',4904593,'2720','409',204692.95,206142.58,0.00,0.00,1449.63,1007492.85,0.00,0.00,0.00),('1','176','920','257765',4904594,'2721','409',76702.26,76993.86,0.00,0.00,291.60,216950.40,0.00,0.00,0.00),('1','176','920','257765',4904595,'2722','409',96281.07,96649.64,0.00,0.00,368.57,256156.15,0.00,0.00,0.00),('1','176','920','257765',4904596,'2723','409',32260.72,32367.72,0.00,0.00,107.00,74365.00,0.00,0.00,0.00),('1','176','920','257766',4904597,'2720','409',206142.58,206644.37,0.00,0.00,501.79,348744.05,0.00,0.00,0.00),('1','176','920','257766',4904598,'2721','409',76993.86,77384.71,0.00,0.00,390.85,290792.40,0.00,0.00,0.00),('1','176','920','257766',4904599,'2722','409',96649.64,97248.79,0.00,0.00,599.15,416409.25,0.00,0.00,0.00),('1','176','920','257766',4904600,'2723','409',32367.72,32755.71,0.00,0.00,387.99,269653.05,0.00,0.00,0.00),('1','176','920','257767',4904601,'2720','409',206644.37,207491.75,0.00,0.00,847.38,588929.10,0.00,0.00,0.00),('1','176','920','257767',4904602,'2721','409',77384.71,77440.76,0.00,0.00,56.05,41701.20,0.00,0.00,0.00),('1','176','920','257767',4904603,'2722','409',97248.79,97248.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257767',4904604,'2723','409',32755.71,32755.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257768',4904605,'2720','409',207491.75,209195.33,0.00,0.00,1703.58,1183988.10,0.00,0.00,0.00),('1','176','920','257768',4904606,'2721','409',77440.76,77627.62,0.00,0.00,186.86,139023.84,0.00,0.00,0.00),('1','176','920','257768',4904607,'2722','409',97248.79,97518.79,0.00,0.00,270.00,187650.00,0.00,0.00,0.00),('1','176','920','257768',4904608,'2723','409',32755.71,32805.71,0.00,0.00,50.00,34750.00,0.00,0.00,0.00),('1','176','920','257769',4904609,'2720','409',209195.33,211255.75,0.00,0.00,2060.42,1431991.90,0.00,0.00,0.00),('1','176','920','257769',4904610,'2721','409',77627.62,77963.05,0.00,0.00,335.43,249559.92,0.00,0.00,0.00),('1','176','920','257769',4904611,'2722','409',97518.79,97589.65,0.00,0.00,70.86,49247.70,0.00,0.00,0.00),('1','176','920','257769',4904612,'2723','409',32805.71,32845.82,0.00,0.00,40.11,27876.45,0.00,0.00,0.00),('1','176','920','257770',4904613,'2720','409',211255.75,211538.49,0.00,0.00,282.74,196504.30,0.00,0.00,0.00),('1','176','920','257770',4904614,'2721','409',77963.05,77963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257770',4904615,'2722','409',97589.65,97589.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257770',4904616,'2723','409',32845.82,32845.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257771',4904617,'2720','409',211538.49,213045.19,0.00,0.00,1506.70,1047156.50,0.00,0.00,0.00),('1','176','920','257771',4904618,'2721','409',77963.05,78289.21,0.00,0.00,326.16,242663.04,0.00,0.00,0.00),('1','176','920','257771',4904619,'2722','409',97589.65,98310.44,0.00,0.00,720.79,500949.05,0.00,0.00,0.00),('1','176','920','257771',4904620,'2723','409',32845.82,33172.82,0.00,0.00,327.00,227265.00,0.00,0.00,0.00),('1','176','920','257772',4904621,'2720','409',213045.19,214507.29,0.00,0.00,1462.10,1016159.50,0.00,0.00,0.00),('1','176','920','257772',4904622,'2721','409',78289.21,78546.46,0.00,0.00,257.25,191394.00,0.00,0.00,0.00),('1','176','920','257772',4904623,'2722','409',98310.44,98710.44,0.00,0.00,400.00,278000.00,0.00,0.00,0.00),('1','176','920','257772',4904624,'2723','409',33172.82,33172.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257773',4904625,'2720','409',214507.29,214978.67,0.00,0.00,471.38,327609.10,0.00,0.00,0.00),('1','176','920','257773',4904626,'2721','409',78546.46,78648.17,0.00,0.00,101.71,75672.24,0.00,0.00,0.00),('1','176','920','257773',4904627,'2722','409',98710.44,98976.69,0.00,0.00,266.25,185043.75,0.00,0.00,0.00),('1','176','920','257773',4904628,'2723','409',33172.82,33172.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257774',4904629,'2720','409',214978.67,217627.15,0.00,0.00,2648.48,1840693.60,0.00,0.00,0.00),('1','176','920','257774',4904630,'2721','409',78648.17,78849.96,0.00,0.00,201.79,150131.76,0.00,0.00,0.00),('1','176','920','257774',4904631,'2722','409',98976.69,99417.94,0.00,0.00,441.25,306668.75,0.00,0.00,0.00),('1','176','920','257774',4904632,'2723','409',33172.82,33621.82,0.00,0.00,449.00,312055.00,0.00,0.00,0.00),('1','176','920','257775',4904633,'2720','409',217627.15,218047.29,0.00,0.00,420.14,291997.30,0.00,0.00,0.00),('1','176','920','257775',4904634,'2721','409',78849.96,78849.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257775',4904635,'2722','409',99417.94,99417.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257775',4904636,'2723','409',33621.82,33621.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257776',4904637,'2720','409',218047.29,220382.36,0.00,0.00,2335.07,1622873.65,0.00,0.00,0.00),('1','176','920','257776',4904638,'2721','409',78849.96,79378.31,0.00,0.00,528.35,393092.40,0.00,0.00,0.00),('1','176','920','257776',4904639,'2722','409',99417.94,99647.28,0.00,0.00,229.34,159391.30,0.00,0.00,0.00),('1','176','920','257776',4904640,'2723','409',33621.82,33672.82,0.00,0.00,51.00,35445.00,0.00,0.00,0.00),('1','176','920','257777',4904641,'2720','409',220382.36,221869.27,0.00,0.00,1486.91,1033402.45,0.00,0.00,0.00),('1','176','920','257777',4904642,'2721','409',79378.31,79512.78,0.00,0.00,134.47,100045.68,0.00,0.00,0.00),('1','176','920','257777',4904643,'2722','409',99647.28,99672.28,0.00,0.00,25.00,17375.00,0.00,0.00,0.00),('1','176','920','257777',4904644,'2723','409',33672.82,33672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257778',4904645,'2720','409',221869.27,221869.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257778',4904646,'2721','409',79512.78,79512.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257778',4904647,'2722','409',99672.28,99672.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257778',4904648,'2723','409',33672.82,33672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257779',4904649,'2720','409',221869.27,222152.89,0.00,0.00,283.62,197115.90,0.00,0.00,0.00),('1','176','920','257779',4904650,'2721','409',79512.78,79725.27,0.00,0.00,212.49,158092.56,0.00,0.00,0.00),('1','176','920','257779',4904651,'2722','409',99672.28,100022.28,0.00,0.00,350.00,243250.00,0.00,0.00,0.00),('1','176','920','257779',4904652,'2723','409',33672.82,33672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257780',4904653,'2720','409',222152.89,223472.94,0.00,0.00,1320.05,917566.56,0.00,0.00,0.00),('1','176','920','257780',4904654,'2721','409',79725.27,80130.57,0.00,0.00,405.30,301543.20,0.00,0.00,0.00),('1','176','920','257780',4904655,'2722','409',100022.28,100891.28,0.00,0.00,869.00,603955.00,0.00,0.00,0.00),('1','176','920','257780',4904656,'2723','409',33672.82,34180.97,0.00,0.00,508.15,353164.25,0.00,0.00,0.00),('1','176','920','257781',4904657,'2720','409',223472.94,224730.33,0.00,0.00,1257.39,873886.05,0.00,0.00,0.00),('1','176','920','257781',4904658,'2721','409',80130.57,80278.36,0.00,0.00,147.79,109955.76,0.00,0.00,0.00),('1','176','920','257781',4904659,'2722','409',100891.28,100937.28,0.00,0.00,46.00,31970.00,0.00,0.00,0.00),('1','176','920','257781',4904660,'2723','409',34180.97,34180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257782',4904661,'2720','409',224730.33,224730.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257782',4904662,'2721','409',80278.36,80806.22,0.00,0.00,527.86,392727.84,0.00,0.00,0.00),('1','176','920','257782',4904663,'2722','409',100937.28,100937.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257782',4904664,'2723','409',34180.97,34180.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257783',4904665,'2720','409',224730.33,226421.79,0.00,0.00,1691.46,1175564.70,0.00,0.00,0.00),('1','176','920','257783',4904666,'2721','409',80806.22,81389.29,0.00,0.00,583.07,433804.08,0.00,0.00,0.00),('1','176','920','257783',4904667,'2722','409',100937.28,101437.28,0.00,0.00,500.00,347500.00,0.00,0.00,0.00),('1','176','920','257783',4904668,'2723','409',34180.97,34501.97,0.00,0.00,321.00,223095.00,0.00,0.00,0.00),('1','176','920','257784',4904669,'2720','409',226421.79,226875.93,0.00,0.00,454.14,315627.30,0.00,0.00,0.00),('1','176','920','257784',4904670,'2721','409',81389.29,81478.75,0.00,0.00,89.46,66558.24,0.00,0.00,0.00),('1','176','920','257784',4904671,'2722','409',101437.28,101437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257784',4904672,'2723','409',34501.97,34501.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257785',4904673,'2720','409',226875.93,226875.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257785',4904674,'2721','409',81478.75,81478.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257785',4904675,'2722','409',101437.28,101437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257785',4904676,'2723','409',34501.97,34501.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257786',4904677,'2720','409',226875.93,227554.93,0.00,0.00,679.00,471905.00,0.00,0.00,0.00),('1','176','920','257786',4904678,'2721','409',81478.75,81733.77,0.00,0.00,255.02,189734.88,0.00,0.00,0.00),('1','176','920','257786',4904679,'2722','409',101437.28,101766.28,0.00,0.00,329.00,228655.00,0.00,0.00,0.00),('1','176','920','257786',4904680,'2723','409',34501.97,34601.97,0.00,0.00,100.00,69500.00,0.00,0.00,0.00),('1','176','920','257787',4904681,'2720','409',227554.93,230131.56,0.00,0.00,2576.63,1791021.47,0.00,0.00,0.00),('1','176','920','257787',4904682,'2721','409',81733.77,82320.47,0.00,0.00,586.70,433858.80,0.00,0.00,0.00),('1','176','920','257787',4904683,'2722','409',101766.28,102378.88,0.00,0.00,612.60,426369.50,0.00,0.00,0.00),('1','176','920','257787',4904684,'2723','409',34601.97,34601.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257788',4904685,'2720','409',230131.56,232440.16,0.00,0.00,2308.60,1604674.47,0.00,0.00,0.00),('1','176','920','257788',4904686,'2721','409',82320.47,82815.50,0.00,0.00,495.03,368302.32,0.00,0.00,0.00),('1','176','920','257788',4904687,'2722','409',102378.88,102523.07,0.00,0.00,144.19,102573.36,0.00,0.00,0.00),('1','176','920','257788',4904688,'2723','409',34601.97,34863.40,0.00,0.00,261.43,182253.92,0.00,0.00,0.00),('1','176','920','257789',4904689,'2720','409',232440.16,232465.16,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','176','920','257789',4904690,'2721','409',82815.50,83176.07,0.00,0.00,360.57,281773.20,0.00,0.00,0.00),('1','176','920','257789',4904691,'2722','409',102523.07,102861.17,0.00,0.00,338.10,241206.00,0.00,0.00,0.00),('1','176','920','257789',4904692,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257790',4904693,'2720','409',232465.16,232465.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257790',4904694,'2721','409',83176.07,83757.22,0.00,0.00,581.15,441674.00,0.00,0.00,0.00),('1','176','920','257790',4904695,'2722','409',102861.17,102862.49,0.00,0.00,1.32,1003.20,0.00,0.00,0.00),('1','176','920','257790',4904696,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257791',4904697,'2720','409',232465.16,232465.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257791',4904698,'2721','409',83757.22,84188.18,0.00,0.00,430.96,327529.60,0.00,0.00,0.00),('1','176','920','257791',4904699,'2722','409',102862.49,102874.99,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','176','920','257791',4904700,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257792',4904701,'2720','409',232465.16,232477.66,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','176','920','257792',4904702,'2721','409',84188.18,84694.44,0.00,0.00,506.26,384757.60,0.00,0.00,0.00),('1','176','920','257792',4904703,'2722','409',102874.99,102874.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257792',4904704,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257793',4904705,'2720','409',232477.66,232477.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257793',4904706,'2721','409',84694.44,85099.93,0.00,0.00,405.49,308172.40,0.00,0.00,0.00),('1','176','920','257793',4904707,'2722','409',102874.99,102874.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257793',4904708,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257794',4904709,'2720','409',232477.66,232477.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257794',4904710,'2721','409',85099.93,85674.02,0.00,0.00,574.09,436308.40,0.00,0.00,0.00),('1','176','920','257794',4904711,'2722','409',102874.99,102879.99,0.00,0.00,5.00,3800.00,0.00,0.00,0.00),('1','176','920','257794',4904712,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257795',4904713,'2720','409',232477.66,232477.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257795',4904714,'2721','409',85674.02,86301.79,0.00,0.00,627.77,477105.20,0.00,0.00,0.00),('1','176','920','257795',4904715,'2722','409',102879.99,102879.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257795',4904716,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257796',4904717,'2720','409',232477.66,232477.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257796',4904718,'2721','409',86301.79,86537.13,0.00,0.00,235.34,178858.40,0.00,0.00,0.00),('1','176','920','257796',4904719,'2722','409',102879.99,102879.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257796',4904720,'2723','409',34863.40,34863.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257797',4904721,'2720','409',232477.66,232477.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257797',4904722,'2721','409',86537.13,87005.38,0.00,0.00,468.25,348378.00,0.00,0.00,0.00),('1','176','920','257797',4904723,'2722','409',102879.99,103707.15,0.00,0.00,827.16,587283.60,0.00,0.00,0.00),('1','176','920','257797',4904724,'2723','409',34863.40,35916.81,0.00,0.00,1053.41,747921.10,0.00,0.00,0.00),('1','176','920','257798',4904725,'2720','409',232477.66,232559.58,0.00,0.00,81.92,58163.20,0.00,0.00,0.00),('1','176','920','257798',4904726,'2721','409',87005.38,87105.92,0.00,0.00,100.54,74801.76,0.00,0.00,0.00),('1','176','920','257798',4904727,'2722','409',103707.15,103707.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257798',4904728,'2723','409',35916.81,35964.81,0.00,0.00,48.00,34080.00,0.00,0.00,0.00),('1','176','920','257799',4904729,'2720','409',232559.58,233648.71,0.00,0.00,1089.13,776682.30,0.00,0.00,0.00),('1','176','920','257799',4904730,'2721','409',87105.92,87649.28,0.00,0.00,543.36,404259.84,0.00,0.00,0.00),('1','176','920','257799',4904731,'2722','409',103707.15,103982.15,0.00,0.00,275.00,195250.00,0.00,0.00,0.00),('1','176','920','257799',4904732,'2723','409',35964.81,36338.81,0.00,0.00,374.00,265540.00,0.00,0.00,0.00),('1','176','920','257800',4904733,'2720','409',233648.71,235188.28,0.00,0.00,1539.57,1093094.70,0.00,0.00,0.00),('1','176','920','257800',4904734,'2721','409',87649.28,87942.65,0.00,0.00,293.37,218267.28,0.00,0.00,0.00),('1','176','920','257800',4904735,'2722','409',103982.15,103982.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257800',4904736,'2723','409',36338.81,36338.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257801',4904737,'2720','409',235188.28,235987.63,0.00,0.00,799.35,567538.50,0.00,0.00,0.00),('1','176','920','257801',4904738,'2721','409',87942.65,88244.95,0.00,0.00,302.30,224911.20,0.00,0.00,0.00),('1','176','920','257801',4904739,'2722','409',103982.15,104132.15,0.00,0.00,150.00,106500.00,0.00,0.00,0.00),('1','176','920','257801',4904740,'2723','409',36338.81,36429.81,0.00,0.00,91.00,64610.00,0.00,0.00,0.00),('1','176','920','257802',4904741,'2720','409',235987.63,235987.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257802',4904742,'2721','409',88244.95,88244.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257802',4904743,'2722','409',104132.15,104132.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257802',4904744,'2723','409',36429.81,36429.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257803',4904745,'2720','409',235987.63,237332.05,0.00,0.00,1344.42,954538.20,0.00,0.00,0.00),('1','176','920','257803',4904746,'2721','409',88244.95,89056.58,0.00,0.00,811.63,603852.72,0.00,0.00,0.00),('1','176','920','257803',4904747,'2722','409',104132.15,104132.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257803',4904748,'2723','409',36429.81,36429.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257804',4904749,'2720','409',237332.05,237969.44,0.00,0.00,637.39,454246.90,0.00,0.00,0.00),('1','176','920','257804',4904750,'2721','409',89056.58,89914.32,0.00,0.00,857.74,638158.56,0.00,0.00,0.00),('1','176','920','257804',4904751,'2722','409',104132.15,104430.15,0.00,0.00,298.00,211580.00,0.00,0.00,0.00),('1','176','920','257804',4904752,'2723','409',36429.81,36561.81,0.00,0.00,132.00,93720.00,0.00,0.00,0.00),('1','176','920','257805',4904753,'2720','409',237969.44,238797.31,0.00,0.00,827.87,587787.70,0.00,0.00,0.00),('1','176','920','257805',4904754,'2721','409',89914.32,90108.59,0.00,0.00,194.27,144536.88,0.00,0.00,0.00),('1','176','920','257805',4904755,'2722','409',104430.15,104480.15,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','176','920','257805',4904756,'2723','409',36561.81,36561.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257806',4904757,'2720','409',238797.31,239046.31,0.00,0.00,249.00,176790.00,0.00,0.00,0.00),('1','176','920','257806',4904758,'2721','409',90108.59,90263.17,0.00,0.00,154.58,115007.52,0.00,0.00,0.00),('1','176','920','257806',4904759,'2722','409',104480.15,104480.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257806',4904760,'2723','409',36561.81,36561.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257807',4904761,'2720','409',239046.31,239960.73,0.00,0.00,914.42,649238.20,0.00,0.00,0.00),('1','176','920','257807',4904762,'2721','409',90263.17,90907.55,0.00,0.00,644.38,479418.72,0.00,0.00,0.00),('1','176','920','257807',4904763,'2722','409',104480.15,104480.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257807',4904764,'2723','409',36561.81,36656.88,0.00,0.00,95.07,67499.70,0.00,0.00,0.00),('1','176','920','257808',4904765,'2720','409',239960.73,240666.23,0.00,0.00,705.50,500905.00,0.00,0.00,0.00),('1','176','920','257808',4904766,'2721','409',90907.55,91481.47,0.00,0.00,573.92,426996.48,0.00,0.00,0.00),('1','176','920','257808',4904767,'2722','409',104480.15,104639.65,0.00,0.00,159.50,113245.00,0.00,0.00,0.00),('1','176','920','257808',4904768,'2723','409',36656.88,36702.88,0.00,0.00,46.00,32660.00,0.00,0.00,0.00),('1','176','920','257809',4904769,'2720','409',240666.23,241166.23,0.00,0.00,500.00,355000.00,0.00,0.00,0.00),('1','176','920','257809',4904770,'2721','409',91481.47,91827.29,0.00,0.00,345.82,257290.08,0.00,0.00,0.00),('1','176','920','257809',4904771,'2722','409',104639.65,105346.69,0.00,0.00,707.04,501998.40,0.00,0.00,0.00),('1','176','920','257809',4904772,'2723','409',36702.88,36767.52,0.00,0.00,64.64,45894.40,0.00,0.00,0.00),('1','176','920','257810',4904773,'2720','409',241166.23,241166.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257810',4904774,'2721','409',91827.29,91827.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257810',4904775,'2722','409',105346.69,105346.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257810',4904776,'2723','409',36767.52,36767.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257811',4904777,'2720','409',241166.23,241235.66,0.00,0.00,69.43,49295.30,0.00,0.00,0.00),('1','176','920','257811',4904778,'2721','409',91827.29,92296.25,0.00,0.00,468.96,348906.24,0.00,0.00,0.00),('1','176','920','257811',4904779,'2722','409',105346.69,105346.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257811',4904780,'2723','409',36767.52,36767.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257812',4904781,'2720','409',241235.66,241849.66,0.00,0.00,614.00,435940.00,0.00,0.00,0.00),('1','176','920','257812',4904782,'2721','409',92296.25,92834.76,0.00,0.00,538.51,400651.44,0.00,0.00,0.00),('1','176','920','257812',4904783,'2722','409',105346.69,105346.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257812',4904784,'2723','409',36767.52,36817.52,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','176','920','257813',4904785,'2720','409',241849.66,242497.66,0.00,0.00,648.00,460080.00,0.00,0.00,0.00),('1','176','920','257813',4904786,'2721','409',92834.76,93305.42,0.00,0.00,470.66,350171.04,0.00,0.00,0.00),('1','176','920','257813',4904787,'2722','409',105346.69,105609.69,0.00,0.00,263.00,186730.00,0.00,0.00,0.00),('1','176','920','257813',4904788,'2723','409',36817.52,36979.52,0.00,0.00,162.00,115020.00,0.00,0.00,0.00),('1','176','920','257814',4904789,'2720','409',242497.66,242848.66,0.00,0.00,351.00,249210.00,0.00,0.00,0.00),('1','176','920','257814',4904790,'2721','409',93305.42,93871.40,0.00,0.00,565.98,415989.12,0.00,0.00,0.00),('1','176','920','257814',4904791,'2722','409',105609.69,105664.69,0.00,0.00,55.00,39050.00,0.00,0.00,0.00),('1','176','920','257814',4904792,'2723','409',36979.52,36979.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257815',4904793,'2720','409',242848.66,242848.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257815',4904794,'2721','409',93871.40,93871.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257815',4904795,'2722','409',105664.69,105664.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257815',4904796,'2723','409',36979.52,36979.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257816',4904797,'2720','409',242848.66,243451.66,0.00,0.00,603.00,428130.00,0.00,0.00,0.00),('1','176','920','257816',4904798,'2721','409',93871.40,94354.81,0.00,0.00,483.41,359657.04,0.00,0.00,0.00),('1','176','920','257816',4904799,'2722','409',105664.69,105664.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257816',4904800,'2723','409',36979.52,36979.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257817',4904801,'2720','409',243451.66,243663.66,0.00,0.00,212.00,150520.00,0.00,0.00,0.00),('1','176','920','257817',4904802,'2721','409',94354.81,95199.79,0.00,0.00,844.98,628665.12,0.00,0.00,0.00),('1','176','920','257817',4904803,'2722','409',105664.69,105819.69,0.00,0.00,155.00,110050.00,0.00,0.00,0.00),('1','176','920','257817',4904804,'2723','409',36979.52,37116.77,0.00,0.00,137.25,97447.50,0.00,0.00,0.00),('1','176','920','257818',4904805,'2720','409',243663.66,244596.68,0.00,0.00,933.02,662512.88,0.00,0.00,0.00),('1','176','920','257818',4904806,'2721','409',95199.79,96262.12,0.00,0.00,1062.33,782281.52,0.00,0.00,0.00),('1','176','920','257818',4904807,'2722','409',105819.69,106178.53,0.00,0.00,358.84,254776.40,0.00,0.00,0.00),('1','176','920','257818',4904808,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257819',4904809,'2720','409',244596.68,245123.90,0.00,0.00,527.22,374417.66,0.00,0.00,0.00),('1','176','920','257819',4904810,'2721','409',96262.12,96767.62,0.00,0.00,505.50,376092.00,0.00,0.00,0.00),('1','176','920','257819',4904811,'2722','409',106178.53,106641.60,0.00,0.00,463.07,328779.70,0.00,0.00,0.00),('1','176','920','257819',4904812,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257820',4904813,'2720','409',245123.90,245812.90,0.00,0.00,689.00,489190.00,0.00,0.00,0.00),('1','176','920','257820',4904814,'2721','409',96767.62,97333.52,0.00,0.00,565.90,421029.60,0.00,0.00,0.00),('1','176','920','257820',4904815,'2722','409',106641.60,106651.60,0.00,0.00,10.00,7100.00,0.00,0.00,0.00),('1','176','920','257820',4904816,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257821',4904817,'2720','409',245812.90,246582.90,0.00,0.00,770.00,543000.00,0.00,0.00,0.00),('1','176','920','257821',4904818,'2721','409',97333.52,97699.06,0.00,0.00,365.54,271961.76,0.00,0.00,0.00),('1','176','920','257821',4904819,'2722','409',106651.60,106651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257821',4904820,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257822',4904821,'2720','409',246582.90,247574.04,0.00,0.00,991.14,693798.00,0.00,0.00,0.00),('1','176','920','257822',4904822,'2721','409',97699.06,98220.42,0.00,0.00,521.36,387891.84,0.00,0.00,0.00),('1','176','920','257822',4904823,'2722','409',106651.60,106651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257822',4904824,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257823',4904825,'2720','409',247574.04,247779.32,0.00,0.00,205.28,143696.00,0.00,0.00,0.00),('1','176','920','257823',4904826,'2721','409',98220.42,98782.38,0.00,0.00,561.96,418098.24,0.00,0.00,0.00),('1','176','920','257823',4904827,'2722','409',106651.60,106901.60,0.00,0.00,250.00,177200.00,0.00,0.00,0.00),('1','176','920','257823',4904828,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257824',4904829,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257824',4904830,'2721','409',98782.38,99326.50,0.00,0.00,544.12,404825.28,0.00,0.00,0.00),('1','176','920','257824',4904831,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257824',4904832,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257825',4904833,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257825',4904834,'2721','409',99326.50,99801.47,0.00,0.00,474.97,353377.68,0.00,0.00,0.00),('1','176','920','257825',4904835,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257825',4904836,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257826',4904837,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257826',4904838,'2721','409',99801.47,100471.11,0.00,0.00,669.64,498212.16,0.00,0.00,0.00),('1','176','920','257826',4904839,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257826',4904840,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257827',4904841,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257827',4904842,'2721','409',100471.11,101214.33,0.00,0.00,743.22,552955.68,0.00,0.00,0.00),('1','176','920','257827',4904843,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257827',4904844,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257828',4904845,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257828',4904846,'2721','409',101214.33,101854.27,0.00,0.00,639.94,476115.36,0.00,0.00,0.00),('1','176','920','257828',4904847,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257828',4904848,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257829',4904849,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257829',4904850,'2721','409',101854.27,102520.37,0.00,0.00,666.10,495578.40,0.00,0.00,0.00),('1','176','920','257829',4904851,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257829',4904852,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257830',4904853,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257830',4904854,'2721','409',102520.37,103097.30,0.00,0.00,576.93,429235.92,0.00,0.00,0.00),('1','176','920','257830',4904855,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257830',4904856,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257831',4904857,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257831',4904858,'2721','409',103097.30,103455.94,0.00,0.00,358.64,266828.16,0.00,0.00,0.00),('1','176','920','257831',4904859,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257831',4904860,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257832',4904861,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257832',4904862,'2721','409',103455.94,103463.74,0.00,0.00,7.80,5803.20,0.00,0.00,0.00),('1','176','920','257832',4904863,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257832',4904864,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257833',4904865,'2720','409',247779.32,247779.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257833',4904866,'2721','409',103463.74,103625.12,0.00,0.00,161.38,120066.72,0.00,0.00,0.00),('1','176','920','257833',4904867,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257833',4904868,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257834',4904869,'2720','409',247779.32,247784.70,0.00,0.00,5.38,4002.72,0.00,0.00,0.00),('1','176','920','257834',4904870,'2721','409',103625.12,104577.85,0.00,0.00,952.73,708831.12,0.00,0.00,0.00),('1','176','920','257834',4904871,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257834',4904872,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257835',4904873,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257835',4904874,'2721','409',104577.85,105057.66,0.00,0.00,479.81,356978.64,0.00,0.00,0.00),('1','176','920','257835',4904875,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257835',4904876,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257836',4904877,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257836',4904878,'2721','409',105057.66,105623.76,0.00,0.00,566.10,421178.40,0.00,0.00,0.00),('1','176','920','257836',4904879,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257836',4904880,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257837',4904881,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257837',4904882,'2721','409',105623.76,106106.63,0.00,0.00,482.87,356963.84,0.00,0.00,0.00),('1','176','920','257837',4904883,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257837',4904884,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257838',4904885,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257838',4904886,'2721','409',106106.63,106682.02,0.00,0.00,575.39,423487.04,0.00,0.00,0.00),('1','176','920','257838',4904887,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257838',4904888,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257839',4904889,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257839',4904890,'2721','409',106682.02,106719.72,0.00,0.00,37.70,27747.20,0.00,0.00,0.00),('1','176','920','257839',4904891,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257839',4904892,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257840',4904893,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257840',4904894,'2721','409',106719.72,106719.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257840',4904895,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257840',4904896,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257841',4904897,'2720','409',247784.70,247784.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257841',4904898,'2721','409',106719.72,107436.61,0.00,0.00,716.89,527631.04,0.00,0.00,0.00),('1','176','920','257841',4904899,'2722','409',106901.60,106901.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257841',4904900,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257842',4904901,'2720','409',247784.70,247790.75,0.00,0.00,6.05,4452.80,0.00,0.00,0.00),('1','176','920','257842',4904902,'2721','409',107436.61,109161.08,0.00,0.00,1724.47,1269209.92,0.00,0.00,0.00),('1','176','920','257842',4904903,'2722','409',106901.60,106906.64,0.00,0.00,5.04,3709.44,0.00,0.00,0.00),('1','176','920','257842',4904904,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257843',4904905,'2720','409',247790.75,247790.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257843',4904906,'2721','409',109161.08,109651.98,0.00,0.00,490.90,361302.40,0.00,0.00,0.00),('1','176','920','257843',4904907,'2722','409',106906.64,106906.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257843',4904908,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257844',4904909,'2720','409',247790.75,247909.25,0.00,0.00,118.50,82950.00,0.00,0.00,0.00),('1','176','920','257844',4904910,'2721','409',109651.98,110300.14,0.00,0.00,648.16,477045.76,0.00,0.00,0.00),('1','176','920','257844',4904911,'2722','409',106906.64,108326.12,0.00,0.00,1419.48,1002195.72,0.00,0.00,0.00),('1','176','920','257844',4904912,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257845',4904913,'2720','409',247909.25,248064.25,0.00,0.00,155.00,108500.00,0.00,0.00,0.00),('1','176','920','257845',4904914,'2721','409',110300.14,110442.12,0.00,0.00,141.98,104497.28,0.00,0.00,0.00),('1','176','920','257845',4904915,'2722','409',108326.12,108326.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257845',4904916,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257846',4904917,'2720','409',248064.25,249137.41,0.00,0.00,1073.16,751212.00,0.00,0.00,0.00),('1','176','920','257846',4904918,'2721','409',110442.12,110824.96,0.00,0.00,382.84,281770.24,0.00,0.00,0.00),('1','176','920','257846',4904919,'2722','409',108326.12,108464.12,0.00,0.00,138.00,96600.00,0.00,0.00,0.00),('1','176','920','257846',4904920,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257847',4904921,'2720','409',249137.41,249502.41,0.00,0.00,365.00,255500.00,0.00,0.00,0.00),('1','176','920','257847',4904922,'2721','409',110824.96,111148.97,0.00,0.00,324.01,238471.36,0.00,0.00,0.00),('1','176','920','257847',4904923,'2722','409',108464.12,108872.12,0.00,0.00,408.00,285600.00,0.00,0.00,0.00),('1','176','920','257847',4904924,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257848',4904925,'2720','409',249502.41,250065.41,0.00,0.00,563.00,394100.00,0.00,0.00,0.00),('1','176','920','257848',4904926,'2721','409',111148.97,111578.09,0.00,0.00,429.12,315832.32,0.00,0.00,0.00),('1','176','920','257848',4904927,'2722','409',108872.12,108872.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257848',4904928,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257849',4904929,'2720','409',250065.41,250110.41,0.00,0.00,45.00,31500.00,0.00,0.00,0.00),('1','176','920','257849',4904930,'2721','409',111578.09,111959.26,0.00,0.00,381.17,280541.12,0.00,0.00,0.00),('1','176','920','257849',4904931,'2722','409',108872.12,109760.12,0.00,0.00,888.00,621600.00,0.00,0.00,0.00),('1','176','920','257849',4904932,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257850',4904933,'2720','409',250110.41,251485.22,0.00,0.00,1374.81,962367.00,0.00,0.00,0.00),('1','176','920','257850',4904934,'2721','409',111959.26,113410.08,0.00,0.00,1450.82,1067803.52,0.00,0.00,0.00),('1','176','920','257850',4904935,'2722','409',109760.12,109965.12,0.00,0.00,205.00,143500.00,0.00,0.00,0.00),('1','176','920','257850',4904936,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257851',4904937,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257851',4904938,'2721','409',113410.08,114462.25,0.00,0.00,1052.17,774397.12,0.00,0.00,0.00),('1','176','920','257851',4904939,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257851',4904940,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257852',4904941,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257852',4904942,'2721','409',114462.25,115052.89,0.00,0.00,590.64,434711.04,0.00,0.00,0.00),('1','176','920','257852',4904943,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257852',4904944,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257853',4904945,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257853',4904946,'2721','409',115052.89,115208.24,0.00,0.00,155.35,114337.60,0.00,0.00,0.00),('1','176','920','257853',4904947,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257853',4904948,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257854',4904949,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257854',4904950,'2721','409',115208.24,115208.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257854',4904951,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257854',4904952,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257855',4904953,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257855',4904954,'2721','409',115208.24,115722.95,0.00,0.00,514.71,378826.56,0.00,0.00,0.00),('1','176','920','257855',4904955,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257855',4904956,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257856',4904957,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257856',4904958,'2721','409',115722.95,117706.89,0.00,0.00,1983.94,1460179.84,0.00,0.00,0.00),('1','176','920','257856',4904959,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257856',4904960,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257857',4904961,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257857',4904962,'2721','409',117706.89,118818.04,0.00,0.00,1111.15,848918.60,0.00,0.00,0.00),('1','176','920','257857',4904963,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257857',4904964,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257858',4904965,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257858',4904966,'2721','409',118818.04,119208.73,0.00,0.00,390.69,292236.12,0.00,0.00,0.00),('1','176','920','257858',4904967,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257858',4904968,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257859',4904969,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257859',4904970,'2721','409',119208.73,119663.60,0.00,0.00,454.87,340242.76,0.00,0.00,0.00),('1','176','920','257859',4904971,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257859',4904972,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257860',4904973,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257860',4904974,'2721','409',119663.60,120690.39,0.00,0.00,1026.79,768038.92,0.00,0.00,0.00),('1','176','920','257860',4904975,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257860',4904976,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257861',4904977,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257861',4904978,'2721','409',120690.39,123724.84,0.00,0.00,3034.45,2269768.60,0.00,0.00,0.00),('1','176','920','257861',4904979,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257861',4904980,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257862',4904981,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257862',4904982,'2721','409',123724.84,123882.45,0.00,0.00,157.61,117892.28,0.00,0.00,0.00),('1','176','920','257862',4904983,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257862',4904984,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257863',4904985,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257863',4904986,'2721','409',123882.45,124359.26,0.00,0.00,476.81,356653.88,0.00,0.00,0.00),('1','176','920','257863',4904987,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257863',4904988,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257864',4904989,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257864',4904990,'2721','409',124359.26,125309.07,0.00,0.00,949.81,710457.88,0.00,0.00,0.00),('1','176','920','257864',4904991,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257864',4904992,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257865',4904993,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257865',4904994,'2721','409',125309.07,126584.96,0.00,0.00,1275.89,954365.72,0.00,0.00,0.00),('1','176','920','257865',4904995,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257865',4904996,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257866',4904997,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257866',4904998,'2721','409',126584.96,127512.76,0.00,0.00,927.80,705128.00,0.00,0.00,0.00),('1','176','920','257866',4904999,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257866',4905000,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257867',4905001,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257867',4905002,'2721','409',127512.76,128829.81,0.00,0.00,1317.05,1000958.00,0.00,0.00,0.00),('1','176','920','257867',4905003,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257867',4905004,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257868',4905005,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257868',4905006,'2721','409',128829.81,129594.08,0.00,0.00,764.27,580845.20,0.00,0.00,0.00),('1','176','920','257868',4905007,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257868',4905008,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257869',4905009,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257869',4905010,'2721','409',129594.08,130832.49,0.00,0.00,1238.41,941191.60,0.00,0.00,0.00),('1','176','920','257869',4905011,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257869',4905012,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257870',4905013,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257870',4905014,'2721','409',130832.49,131967.01,0.00,0.00,1134.52,862235.20,0.00,0.00,0.00),('1','176','920','257870',4905015,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257870',4905016,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257871',4905017,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257871',4905018,'2721','409',131967.01,132713.36,0.00,0.00,746.35,567226.00,0.00,0.00,0.00),('1','176','920','257871',4905019,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257871',4905020,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257872',4905021,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257872',4905022,'2721','409',132713.36,132713.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257872',4905023,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257872',4905024,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257873',4905025,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257873',4905026,'2721','409',132713.36,133643.48,0.00,0.00,930.12,706891.20,0.00,0.00,0.00),('1','176','920','257873',4905027,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257873',4905028,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257874',4905029,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257874',4905030,'2721','409',133643.48,134160.31,0.00,0.00,516.83,413464.00,0.00,0.00,0.00),('1','176','920','257874',4905031,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257874',4905032,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257875',4905033,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257875',4905034,'2721','409',134160.31,134800.08,0.00,0.00,639.77,511816.00,0.00,0.00,0.00),('1','176','920','257875',4905035,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257875',4905036,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257876',4905037,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257876',4905038,'2721','409',134800.08,135440.04,0.00,0.00,639.96,511968.00,0.00,0.00,0.00),('1','176','920','257876',4905039,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257876',4905040,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257877',4905041,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257877',4905042,'2721','409',135440.04,136083.78,0.00,0.00,643.74,489242.40,0.00,0.00,0.00),('1','176','920','257877',4905043,'2722','409',109965.12,109965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257877',4905044,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257878',4905045,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257878',4905046,'2721','409',136083.78,136843.10,0.00,0.00,759.32,577083.20,0.00,0.00,0.00),('1','176','920','257878',4905047,'2722','409',109965.12,109971.04,0.00,0.00,5.92,4499.20,0.00,0.00,0.00),('1','176','920','257878',4905048,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257879',4905049,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257879',4905050,'2721','409',136843.10,137763.08,0.00,0.00,919.98,699184.80,0.00,0.00,0.00),('1','176','920','257879',4905051,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257879',4905052,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257880',4905053,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257880',4905054,'2721','409',137763.08,138408.22,0.00,0.00,645.14,490306.40,0.00,0.00,0.00),('1','176','920','257880',4905055,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257880',4905056,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257881',4905057,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257881',4905058,'2721','409',138408.22,139114.27,0.00,0.00,706.05,536598.00,0.00,0.00,0.00),('1','176','920','257881',4905059,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257881',4905060,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257882',4905061,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257882',4905062,'2721','409',139114.27,139683.50,0.00,0.00,569.23,432614.80,0.00,0.00,0.00),('1','176','920','257882',4905063,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257882',4905064,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257883',4905065,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257883',4905066,'2721','409',139683.50,140377.45,0.00,0.00,693.95,527402.00,0.00,0.00,0.00),('1','176','920','257883',4905067,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257883',4905068,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257884',4905069,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257884',4905070,'2721','409',140377.45,140699.38,0.00,0.00,321.93,244666.80,0.00,0.00,0.00),('1','176','920','257884',4905071,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257884',4905072,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257885',4905073,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257885',4905074,'2721','409',140699.38,141187.12,0.00,0.00,487.74,370682.40,0.00,0.00,0.00),('1','176','920','257885',4905075,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257885',4905076,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257886',4905077,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257886',4905078,'2721','409',141187.12,141547.82,0.00,0.00,360.70,274132.00,0.00,0.00,0.00),('1','176','920','257886',4905079,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257886',4905080,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257887',4905081,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257887',4905082,'2721','409',141547.82,142172.89,0.00,0.00,625.07,475053.20,0.00,0.00,0.00),('1','176','920','257887',4905083,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257887',4905084,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257888',4905085,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257888',4905086,'2721','409',142172.89,143117.61,0.00,0.00,944.72,717987.20,0.00,0.00,0.00),('1','176','920','257888',4905087,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257888',4905088,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257889',4905089,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257889',4905090,'2721','409',143117.61,143396.41,0.00,0.00,278.80,211888.00,0.00,0.00,0.00),('1','176','920','257889',4905091,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257889',4905092,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257890',4905093,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257890',4905094,'2721','409',143396.41,143810.61,0.00,0.00,414.20,314792.00,0.00,0.00,0.00),('1','176','920','257890',4905095,'2722','409',109971.04,109971.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257890',4905096,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257891',4905097,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257891',4905098,'2721','409',143810.61,144186.79,0.00,0.00,376.18,285896.80,0.00,0.00,0.00),('1','176','920','257891',4905099,'2722','409',109971.04,109976.04,0.00,0.00,5.00,3800.00,0.00,0.00,0.00),('1','176','920','257891',4905100,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257892',4905101,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257892',4905102,'2721','409',144186.79,144673.82,0.00,0.00,487.03,370142.80,0.00,0.00,0.00),('1','176','920','257892',4905103,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257892',4905104,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257893',4905105,'2720','409',251485.22,251485.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257893',4905106,'2721','409',144673.82,145121.07,0.00,0.00,447.25,339910.00,0.00,0.00,0.00),('1','176','920','257893',4905107,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257893',4905108,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257894',4905109,'2720','409',251485.22,252786.22,0.00,0.00,1301.00,930215.00,0.00,0.00,0.00),('1','176','920','257894',4905110,'2721','409',145121.07,145767.60,0.00,0.00,646.53,491362.80,0.00,0.00,0.00),('1','176','920','257894',4905111,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257894',4905112,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257895',4905113,'2720','409',252786.22,253051.22,0.00,0.00,265.00,189475.00,0.00,0.00,0.00),('1','176','920','257895',4905114,'2721','409',145767.60,146175.78,0.00,0.00,408.18,310216.80,0.00,0.00,0.00),('1','176','920','257895',4905115,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257895',4905116,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257896',4905117,'2720','409',253051.22,253331.28,0.00,0.00,280.06,200242.90,0.00,0.00,0.00),('1','176','920','257896',4905118,'2721','409',146175.78,146616.82,0.00,0.00,441.04,335190.40,0.00,0.00,0.00),('1','176','920','257896',4905119,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257896',4905120,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257897',4905121,'2720','409',253331.28,253730.28,0.00,0.00,399.00,285285.00,0.00,0.00,0.00),('1','176','920','257897',4905122,'2721','409',146616.82,147190.53,0.00,0.00,573.71,436019.60,0.00,0.00,0.00),('1','176','920','257897',4905123,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257897',4905124,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257898',4905125,'2720','409',253730.28,254454.25,0.00,0.00,723.97,517638.55,0.00,0.00,0.00),('1','176','920','257898',4905126,'2721','409',147190.53,147686.93,0.00,0.00,496.40,377264.00,0.00,0.00,0.00),('1','176','920','257898',4905127,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257898',4905128,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257899',4905129,'2720','409',254454.25,254987.25,0.00,0.00,533.00,381095.00,0.00,0.00,0.00),('1','176','920','257899',4905130,'2721','409',147686.93,148151.62,0.00,0.00,464.69,353164.40,0.00,0.00,0.00),('1','176','920','257899',4905131,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257899',4905132,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257900',4905133,'2720','409',254987.25,255278.30,0.00,0.00,291.05,208100.75,0.00,0.00,0.00),('1','176','920','257900',4905134,'2721','409',148151.62,148521.18,0.00,0.00,369.56,280865.60,0.00,0.00,0.00),('1','176','920','257900',4905135,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257900',4905136,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257901',4905137,'2720','409',255278.30,255383.30,0.00,0.00,105.00,74550.00,0.00,0.00,0.00),('1','176','920','257901',4905138,'2721','409',148521.18,148570.16,0.00,0.00,48.98,37224.80,0.00,0.00,0.00),('1','176','920','257901',4905139,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257901',4905140,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257902',4905141,'2720','409',255383.30,257038.88,0.00,0.00,1655.58,1175988.30,0.00,0.00,0.00),('1','176','920','257902',4905142,'2721','409',148570.16,149193.91,0.00,0.00,623.75,474050.00,0.00,0.00,0.00),('1','176','920','257902',4905143,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257902',4905144,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257903',4905145,'2720','409',257038.88,258080.92,0.00,0.00,1042.04,739848.40,0.00,0.00,0.00),('1','176','920','257903',4905146,'2721','409',149193.91,149813.50,0.00,0.00,619.59,470888.40,0.00,0.00,0.00),('1','176','920','257903',4905147,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257903',4905148,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257904',4905149,'2720','409',258080.92,259013.35,0.00,0.00,932.43,662091.30,0.00,0.00,0.00),('1','176','920','257904',4905150,'2721','409',149813.50,149972.15,0.00,0.00,158.65,120574.00,0.00,0.00,0.00),('1','176','920','257904',4905151,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257904',4905152,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257905',4905153,'2720','409',259013.35,259293.39,0.00,0.00,280.04,198828.40,0.00,0.00,0.00),('1','176','920','257905',4905154,'2721','409',149972.15,150098.44,0.00,0.00,126.29,95980.40,0.00,0.00,0.00),('1','176','920','257905',4905155,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257905',4905156,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257906',4905157,'2720','409',259293.39,260508.59,0.00,0.00,1215.20,862792.00,0.00,0.00,0.00),('1','176','920','257906',4905158,'2721','409',150098.44,150498.58,0.00,0.00,400.14,304106.40,0.00,0.00,0.00),('1','176','920','257906',4905159,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257906',4905160,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257907',4905161,'2720','409',260508.59,261607.29,0.00,0.00,1098.70,769090.00,0.00,0.00,0.00),('1','176','920','257907',4905162,'2721','409',150498.58,150858.45,0.00,0.00,359.87,273501.20,0.00,0.00,0.00),('1','176','920','257907',4905163,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257907',4905164,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257908',4905165,'2720','409',261607.29,262865.27,0.00,0.00,1257.98,881754.80,0.00,0.00,0.00),('1','176','920','257908',4905166,'2721','409',150858.45,151350.58,0.00,0.00,492.13,374018.80,0.00,0.00,0.00),('1','176','920','257908',4905167,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257908',4905168,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257909',4905169,'2720','409',262865.27,263189.47,0.00,0.00,324.20,226940.00,0.00,0.00,0.00),('1','176','920','257909',4905170,'2721','409',151350.58,151400.32,0.00,0.00,49.74,37802.40,0.00,0.00,0.00),('1','176','920','257909',4905171,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257909',4905172,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257910',4905173,'2720','409',263189.47,264964.90,0.00,0.00,1775.43,1242801.00,0.00,0.00,0.00),('1','176','920','257910',4905174,'2721','409',151400.32,151696.90,0.00,0.00,296.58,225400.80,0.00,0.00,0.00),('1','176','920','257910',4905175,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257910',4905176,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257911',4905177,'2720','409',264964.90,266866.05,0.00,0.00,1901.15,1330805.00,0.00,0.00,0.00),('1','176','920','257911',4905178,'2721','409',151696.90,152264.15,0.00,0.00,567.25,425710.00,0.00,0.00,0.00),('1','176','920','257911',4905179,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257911',4905180,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257912',4905181,'2720','409',266866.05,266866.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257912',4905182,'2721','409',152264.15,152264.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257912',4905183,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257912',4905184,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257913',4905185,'2720','409',266866.05,270194.10,0.00,0.00,3328.05,2329635.00,0.00,0.00,0.00),('1','176','920','257913',4905186,'2721','409',152264.15,153040.48,0.00,0.00,776.33,590010.80,0.00,0.00,0.00),('1','176','920','257913',4905187,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257913',4905188,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257914',4905189,'2720','409',270194.10,271001.79,0.00,0.00,807.69,565383.00,0.00,0.00,0.00),('1','176','920','257914',4905190,'2721','409',153040.48,153112.52,0.00,0.00,72.04,54750.40,0.00,0.00,0.00),('1','176','920','257914',4905191,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257914',4905192,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257915',4905193,'2720','409',271001.79,271386.69,0.00,0.00,384.90,269430.00,0.00,0.00,0.00),('1','176','920','257915',4905194,'2721','409',153112.52,153313.56,0.00,0.00,201.04,152790.40,0.00,0.00,0.00),('1','176','920','257915',4905195,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257915',4905196,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257916',4905197,'2720','409',271386.69,273040.23,0.00,0.00,1653.54,1157478.00,0.00,0.00,0.00),('1','176','920','257916',4905198,'2721','409',153313.56,153969.96,0.00,0.00,656.40,498864.00,0.00,0.00,0.00),('1','176','920','257916',4905199,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257916',4905200,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257917',4905201,'2720','409',273040.23,275049.54,0.00,0.00,2009.31,1406517.00,0.00,0.00,0.00),('1','176','920','257917',4905202,'2721','409',153969.96,154423.43,0.00,0.00,453.47,344637.20,0.00,0.00,0.00),('1','176','920','257917',4905203,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257917',4905204,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257918',4905205,'2720','409',275049.54,276398.18,0.00,0.00,1348.64,944048.00,0.00,0.00,0.00),('1','176','920','257918',4905206,'2721','409',154423.43,154765.05,0.00,0.00,341.62,259631.20,0.00,0.00,0.00),('1','176','920','257918',4905207,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257918',4905208,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257919',4905209,'2720','409',276398.18,277873.60,0.00,0.00,1475.42,1032794.00,0.00,0.00,0.00),('1','176','920','257919',4905210,'2721','409',154765.05,155321.01,0.00,0.00,555.96,422529.60,0.00,0.00,0.00),('1','176','920','257919',4905211,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257919',4905212,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257920',4905213,'2720','409',277873.60,278615.89,0.00,0.00,742.29,519603.00,0.00,0.00,0.00),('1','176','920','257920',4905214,'2721','409',155321.01,155688.90,0.00,0.00,367.89,273846.72,0.00,0.00,0.00),('1','176','920','257920',4905215,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257920',4905216,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257921',4905217,'2720','409',278615.89,281772.74,0.00,0.00,3156.85,2216095.00,0.00,0.00,0.00),('1','176','920','257921',4905218,'2721','409',155688.90,156718.11,0.00,0.00,1029.21,757498.56,0.00,0.00,0.00),('1','176','920','257921',4905219,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257921',4905220,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257922',4905221,'2720','409',281772.74,282280.74,0.00,0.00,508.00,355600.00,0.00,0.00,0.00),('1','176','920','257922',4905222,'2721','409',156718.11,156954.05,0.00,0.00,235.94,173651.84,0.00,0.00,0.00),('1','176','920','257922',4905223,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257922',4905224,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257923',4905225,'2720','409',282280.74,284258.74,0.00,0.00,1978.00,1384600.00,0.00,0.00,0.00),('1','176','920','257923',4905226,'2721','409',156954.05,158542.72,0.00,0.00,1588.67,1169261.12,0.00,0.00,0.00),('1','176','920','257923',4905227,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257923',4905228,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257924',4905229,'2720','409',284258.74,285626.74,0.00,0.00,1368.00,957600.00,0.00,0.00,0.00),('1','176','920','257924',4905230,'2721','409',158542.72,158891.31,0.00,0.00,348.59,256562.24,0.00,0.00,0.00),('1','176','920','257924',4905231,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257924',4905232,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257925',4905233,'2720','409',285626.74,286981.44,0.00,0.00,1354.70,948290.00,0.00,0.00,0.00),('1','176','920','257925',4905234,'2721','409',158891.31,159500.57,0.00,0.00,609.26,448415.36,0.00,0.00,0.00),('1','176','920','257925',4905235,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257925',4905236,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257926',4905237,'2720','409',286981.44,288897.28,0.00,0.00,1915.84,1341088.00,0.00,0.00,0.00),('1','176','920','257926',4905238,'2721','409',159500.57,160140.96,0.00,0.00,640.39,471327.04,0.00,0.00,0.00),('1','176','920','257926',4905239,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257926',4905240,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257927',4905241,'2720','409',288897.28,289144.35,0.00,0.00,247.07,172949.00,0.00,0.00,0.00),('1','176','920','257927',4905242,'2721','409',160140.96,160140.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257927',4905243,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257927',4905244,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257928',4905245,'2720','409',289144.35,289469.15,0.00,0.00,324.80,227360.00,0.00,0.00,0.00),('1','176','920','257928',4905246,'2721','409',160140.96,160268.90,0.00,0.00,127.94,94163.84,0.00,0.00,0.00),('1','176','920','257928',4905247,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257928',4905248,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257929',4905249,'2720','409',289469.15,291198.66,0.00,0.00,1729.51,1210657.00,0.00,0.00,0.00),('1','176','920','257929',4905250,'2721','409',160268.90,160732.92,0.00,0.00,464.02,341518.72,0.00,0.00,0.00),('1','176','920','257929',4905251,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257929',4905252,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257930',4905253,'2720','409',291198.66,293107.66,0.00,0.00,1909.00,1336300.00,0.00,0.00,0.00),('1','176','920','257930',4905254,'2721','409',160732.92,161340.48,0.00,0.00,607.56,447164.16,0.00,0.00,0.00),('1','176','920','257930',4905255,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257930',4905256,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257931',4905257,'2720','409',293107.66,294825.83,0.00,0.00,1718.17,1205347.00,0.00,0.00,0.00),('1','176','920','257931',4905258,'2721','409',161340.48,161728.25,0.00,0.00,387.77,285398.72,0.00,0.00,0.00),('1','176','920','257931',4905259,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257931',4905260,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257932',4905261,'2720','409',294825.83,295107.30,0.00,0.00,281.47,197029.00,0.00,0.00,0.00),('1','176','920','257932',4905262,'2721','409',161728.25,161794.94,0.00,0.00,66.69,49083.84,0.00,0.00,0.00),('1','176','920','257932',4905263,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257932',4905264,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257933',4905265,'2720','409',295107.30,297851.26,0.00,0.00,2743.96,1920772.00,0.00,0.00,0.00),('1','176','920','257933',4905266,'2721','409',161794.94,161939.43,0.00,0.00,144.49,106344.64,0.00,0.00,0.00),('1','176','920','257933',4905267,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257933',4905268,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257934',4905269,'2720','409',297851.26,300291.51,0.00,0.00,2440.25,1708175.00,0.00,0.00,0.00),('1','176','920','257934',4905270,'2721','409',161939.43,162503.68,0.00,0.00,564.25,415288.00,0.00,0.00,0.00),('1','176','920','257934',4905271,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257934',4905272,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257935',4905273,'2720','409',300291.51,301880.51,0.00,0.00,1589.00,1112300.00,0.00,0.00,0.00),('1','176','920','257935',4905274,'2721','409',162503.68,162740.18,0.00,0.00,236.50,174064.00,0.00,0.00,0.00),('1','176','920','257935',4905275,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257935',4905276,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257936',4905277,'2720','409',301880.51,304150.88,0.00,0.00,2270.37,1589259.00,0.00,0.00,0.00),('1','176','920','257936',4905278,'2721','409',162740.18,163355.27,0.00,0.00,615.09,452706.24,0.00,0.00,0.00),('1','176','920','257936',4905279,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257936',4905280,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257937',4905281,'2720','409',304150.88,305458.29,0.00,0.00,1307.41,915187.00,0.00,0.00,0.00),('1','176','920','257937',4905282,'2721','409',163355.27,164139.69,0.00,0.00,784.42,577333.12,0.00,0.00,0.00),('1','176','920','257937',4905283,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257937',4905284,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257938',4905285,'2720','409',305458.29,309609.75,0.00,0.00,4151.46,2906382.00,0.00,0.00,0.00),('1','176','920','257938',4905286,'2721','409',164139.69,164967.38,0.00,0.00,827.69,609179.84,0.00,0.00,0.00),('1','176','920','257938',4905287,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257938',4905288,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257939',4905289,'2720','409',309609.75,309860.89,0.00,0.00,251.14,175798.00,0.00,0.00,0.00),('1','176','920','257939',4905290,'2721','409',164967.38,165097.09,0.00,0.00,129.71,95466.56,0.00,0.00,0.00),('1','176','920','257939',4905291,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257939',4905292,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257940',4905293,'2720','409',309860.89,311340.89,0.00,0.00,1480.00,1036000.00,0.00,0.00,0.00),('1','176','920','257940',4905294,'2721','409',165097.09,165386.08,0.00,0.00,288.99,212696.64,0.00,0.00,0.00),('1','176','920','257940',4905295,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257940',4905296,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257941',4905297,'2720','409',311340.89,312788.74,0.00,0.00,1447.85,1013495.00,0.00,0.00,0.00),('1','176','920','257941',4905298,'2721','409',165386.08,165781.78,0.00,0.00,395.70,291235.20,0.00,0.00,0.00),('1','176','920','257941',4905299,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257941',4905300,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257942',4905301,'2720','409',312788.74,313595.31,0.00,0.00,806.57,564599.00,0.00,0.00,0.00),('1','176','920','257942',4905302,'2721','409',165781.78,166180.31,0.00,0.00,398.53,293318.08,0.00,0.00,0.00),('1','176','920','257942',4905303,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257942',4905304,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257943',4905305,'2720','409',313595.31,313646.11,0.00,0.00,50.80,35560.00,0.00,0.00,0.00),('1','176','920','257943',4905306,'2721','409',166180.31,166180.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257943',4905307,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257943',4905308,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257944',4905309,'2720','409',313646.11,314758.11,0.00,0.00,1112.00,778400.00,0.00,0.00,0.00),('1','176','920','257944',4905310,'2721','409',166180.31,166581.76,0.00,0.00,401.45,295467.20,0.00,0.00,0.00),('1','176','920','257944',4905311,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257944',4905312,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257945',4905313,'2720','409',314758.11,316128.11,0.00,0.00,1370.00,959000.00,0.00,0.00,0.00),('1','176','920','257945',4905314,'2721','409',166581.76,166876.85,0.00,0.00,295.09,217186.24,0.00,0.00,0.00),('1','176','920','257945',4905315,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257945',4905316,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257946',4905317,'2720','409',316128.11,317438.67,0.00,0.00,1310.56,917392.00,0.00,0.00,0.00),('1','176','920','257946',4905318,'2721','409',166876.85,167258.39,0.00,0.00,381.54,280813.44,0.00,0.00,0.00),('1','176','920','257946',4905319,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257946',4905320,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257947',4905321,'2720','409',317438.67,319585.81,0.00,0.00,2147.14,1502998.00,0.00,0.00,0.00),('1','176','920','257947',4905322,'2721','409',167258.39,167635.67,0.00,0.00,377.28,277678.08,0.00,0.00,0.00),('1','176','920','257947',4905323,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257947',4905324,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257948',4905325,'2720','409',319585.81,321640.81,0.00,0.00,2055.00,1438500.00,0.00,0.00,0.00),('1','176','920','257948',4905326,'2721','409',167635.67,167937.68,0.00,0.00,302.01,222279.36,0.00,0.00,0.00),('1','176','920','257948',4905327,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257948',4905328,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257949',4905329,'2720','409',321640.81,322030.96,0.00,0.00,390.15,273324.96,0.00,0.00,0.00),('1','176','920','257949',4905330,'2721','409',167937.68,168106.10,0.00,0.00,168.42,123957.12,0.00,0.00,0.00),('1','176','920','257949',4905331,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257949',4905332,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257950',4905333,'2720','409',322030.96,322502.96,0.00,0.00,472.00,330400.00,0.00,0.00,0.00),('1','176','920','257950',4905334,'2721','409',168106.10,168432.87,0.00,0.00,326.77,240502.72,0.00,0.00,0.00),('1','176','920','257950',4905335,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257950',4905336,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257951',4905337,'2720','409',322502.96,324095.96,0.00,0.00,1593.00,1115100.00,0.00,0.00,0.00),('1','176','920','257951',4905338,'2721','409',168432.87,168907.15,0.00,0.00,474.28,349070.08,0.00,0.00,0.00),('1','176','920','257951',4905339,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257951',4905340,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257952',4905341,'2720','409',324095.96,325211.96,0.00,0.00,1116.00,781200.00,0.00,0.00,0.00),('1','176','920','257952',4905342,'2721','409',168907.15,169683.05,0.00,0.00,775.90,571062.40,0.00,0.00,0.00),('1','176','920','257952',4905343,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257952',4905344,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257953',4905345,'2720','409',325211.96,325856.46,0.00,0.00,644.50,451150.00,0.00,0.00,0.00),('1','176','920','257953',4905346,'2721','409',169683.05,169734.92,0.00,0.00,51.87,38176.32,0.00,0.00,0.00),('1','176','920','257953',4905347,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257953',4905348,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257954',4905349,'2720','409',325856.46,326548.46,0.00,0.00,692.00,484400.00,0.00,0.00,0.00),('1','176','920','257954',4905350,'2721','409',169734.92,169821.99,0.00,0.00,87.07,64083.52,0.00,0.00,0.00),('1','176','920','257954',4905351,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257954',4905352,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257955',4905353,'2720','409',326548.46,328676.96,0.00,0.00,2128.50,1489950.00,0.00,0.00,0.00),('1','176','920','257955',4905354,'2721','409',169821.99,170407.47,0.00,0.00,585.48,430913.28,0.00,0.00,0.00),('1','176','920','257955',4905355,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257955',4905356,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257956',4905357,'2720','409',328676.96,329607.96,0.00,0.00,931.00,651700.00,0.00,0.00,0.00),('1','176','920','257956',4905358,'2721','409',170407.47,170858.34,0.00,0.00,450.87,331840.32,0.00,0.00,0.00),('1','176','920','257956',4905359,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257956',4905360,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257957',4905361,'2720','409',329607.96,330634.61,0.00,0.00,1026.65,718689.20,0.00,0.00,0.00),('1','176','920','257957',4905362,'2721','409',170858.34,170992.65,0.00,0.00,134.31,98852.16,0.00,0.00,0.00),('1','176','920','257957',4905363,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257957',4905364,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257958',4905365,'2720','409',330634.61,331810.46,0.00,0.00,1175.85,823095.00,0.00,0.00,0.00),('1','176','920','257958',4905366,'2721','409',170992.65,171510.41,0.00,0.00,517.76,381071.36,0.00,0.00,0.00),('1','176','920','257958',4905367,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257958',4905368,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257959',4905369,'2720','409',331810.46,333687.89,0.00,0.00,1877.43,1314201.00,0.00,0.00,0.00),('1','176','920','257959',4905370,'2721','409',171510.41,171759.08,0.00,0.00,248.67,183021.12,0.00,0.00,0.00),('1','176','920','257959',4905371,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257959',4905372,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257960',4905373,'2720','409',333687.89,335567.68,0.00,0.00,1879.79,1316097.44,0.00,0.00,0.00),('1','176','920','257960',4905374,'2721','409',171759.08,172210.50,0.00,0.00,451.42,332245.12,0.00,0.00,0.00),('1','176','920','257960',4905375,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257960',4905376,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257961',4905377,'2720','409',335567.68,337616.30,0.00,0.00,2048.62,1436648.32,0.00,0.00,0.00),('1','176','920','257961',4905378,'2721','409',172210.50,172636.30,0.00,0.00,425.80,313388.80,0.00,0.00,0.00),('1','176','920','257961',4905379,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257961',4905380,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257962',4905381,'2720','409',337616.30,337780.01,0.00,0.00,163.71,114597.00,0.00,0.00,0.00),('1','176','920','257962',4905382,'2721','409',172636.30,172679.65,0.00,0.00,43.35,31905.60,0.00,0.00,0.00),('1','176','920','257962',4905383,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257962',4905384,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257963',4905385,'2720','409',337780.01,339017.87,0.00,0.00,1237.86,866502.00,0.00,0.00,0.00),('1','176','920','257963',4905386,'2721','409',172679.65,172996.71,0.00,0.00,317.06,233356.16,0.00,0.00,0.00),('1','176','920','257963',4905387,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257963',4905388,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257964',4905389,'2720','409',339017.87,341009.58,0.00,0.00,1991.71,1394197.00,0.00,0.00,0.00),('1','176','920','257964',4905390,'2721','409',172996.71,173514.62,0.00,0.00,517.91,381181.76,0.00,0.00,0.00),('1','176','920','257964',4905391,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257964',4905392,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257965',4905393,'2720','409',341009.58,341027.01,0.00,0.00,17.43,12201.00,0.00,0.00,0.00),('1','176','920','257965',4905394,'2721','409',173514.62,173514.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257965',4905395,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257965',4905396,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257966',4905397,'2720','409',341027.01,343228.90,0.00,0.00,2201.89,1541323.00,0.00,0.00,0.00),('1','176','920','257966',4905398,'2721','409',173514.62,174130.92,0.00,0.00,616.30,453596.80,0.00,0.00,0.00),('1','176','920','257966',4905399,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257966',4905400,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257967',4905401,'2720','409',343228.90,344644.73,0.00,0.00,1415.83,991081.00,0.00,0.00,0.00),('1','176','920','257967',4905402,'2721','409',174130.92,174909.88,0.00,0.00,778.96,573314.56,0.00,0.00,0.00),('1','176','920','257967',4905403,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257967',4905404,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257968',4905405,'2720','409',344644.73,345894.22,0.00,0.00,1249.49,874643.00,0.00,0.00,0.00),('1','176','920','257968',4905406,'2721','409',174909.88,175201.50,0.00,0.00,291.62,214632.32,0.00,0.00,0.00),('1','176','920','257968',4905407,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257968',4905408,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257969',4905409,'2720','409',345894.22,346868.86,0.00,0.00,974.64,682248.00,0.00,0.00,0.00),('1','176','920','257969',4905410,'2721','409',175201.50,175607.75,0.00,0.00,406.25,299000.00,0.00,0.00,0.00),('1','176','920','257969',4905411,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257969',4905412,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257970',4905413,'2720','409',346868.86,348266.99,0.00,0.00,1398.13,965209.70,0.00,0.00,0.00),('1','176','920','257970',4905414,'2721','409',175607.75,176059.37,0.00,0.00,451.62,332392.32,0.00,0.00,0.00),('1','176','920','257970',4905415,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257970',4905416,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257971',4905417,'2720','409',348266.99,348372.03,0.00,0.00,105.04,72477.60,0.00,0.00,0.00),('1','176','920','257971',4905418,'2721','409',176059.37,176143.27,0.00,0.00,83.90,61750.40,0.00,0.00,0.00),('1','176','920','257971',4905419,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257971',4905420,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257972',4905421,'2720','409',348372.03,348985.91,0.00,0.00,613.88,423577.20,0.00,0.00,0.00),('1','176','920','257972',4905422,'2721','409',176143.27,176451.97,0.00,0.00,308.70,227203.20,0.00,0.00,0.00),('1','176','920','257972',4905423,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257972',4905424,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257973',4905425,'2720','409',348985.91,350906.41,0.00,0.00,1920.50,1325207.56,0.00,0.00,0.00),('1','176','920','257973',4905426,'2721','409',176451.97,176976.11,0.00,0.00,524.14,385767.04,0.00,0.00,0.00),('1','176','920','257973',4905427,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257973',4905428,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257974',4905429,'2720','409',350906.41,352126.97,0.00,0.00,1220.56,832946.00,0.00,0.00,0.00),('1','176','920','257974',4905430,'2721','409',176976.11,177304.19,0.00,0.00,328.08,241466.88,0.00,0.00,0.00),('1','176','920','257974',4905431,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257974',4905432,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257975',4905433,'2720','409',352126.97,355355.59,0.00,0.00,3228.62,2195461.60,0.00,0.00,0.00),('1','176','920','257975',4905434,'2721','409',177304.19,177903.05,0.00,0.00,598.86,440760.96,0.00,0.00,0.00),('1','176','920','257975',4905435,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257975',4905436,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257976',4905437,'2720','409',355355.59,356776.11,0.00,0.00,1420.52,965953.60,0.00,0.00,0.00),('1','176','920','257976',4905438,'2721','409',177903.05,178094.10,0.00,0.00,191.05,140612.80,0.00,0.00,0.00),('1','176','920','257976',4905439,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257976',4905440,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257977',4905441,'2720','409',356776.11,360919.52,0.00,0.00,4143.41,2817518.80,0.00,0.00,0.00),('1','176','920','257977',4905442,'2721','409',178094.10,178359.62,0.00,0.00,265.52,195422.72,0.00,0.00,0.00),('1','176','920','257977',4905443,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257977',4905444,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257978',4905445,'2720','409',360919.52,361225.52,0.00,0.00,306.00,208080.00,0.00,0.00,0.00),('1','176','920','257978',4905446,'2721','409',178359.62,178400.74,0.00,0.00,41.12,30264.32,0.00,0.00,0.00),('1','176','920','257978',4905447,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257978',4905448,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257979',4905449,'2720','409',361225.52,364032.96,0.00,0.00,2807.44,1909059.20,0.00,0.00,0.00),('1','176','920','257979',4905450,'2721','409',178400.74,178919.64,0.00,0.00,518.90,381910.40,0.00,0.00,0.00),('1','176','920','257979',4905451,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257979',4905452,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257980',4905453,'2720','409',364032.96,365373.95,0.00,0.00,1340.99,911873.20,0.00,0.00,0.00),('1','176','920','257980',4905454,'2721','409',178919.64,179168.35,0.00,0.00,248.71,183050.56,0.00,0.00,0.00),('1','176','920','257980',4905455,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257980',4905456,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257981',4905457,'2720','409',365373.95,368172.27,0.00,0.00,2798.32,1902933.76,0.00,0.00,0.00),('1','176','920','257981',4905458,'2721','409',179168.35,179900.41,0.00,0.00,732.06,538796.16,0.00,0.00,0.00),('1','176','920','257981',4905459,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257981',4905460,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257982',4905461,'2720','409',368172.27,369548.32,0.00,0.00,1376.05,935714.00,0.00,0.00,0.00),('1','176','920','257982',4905462,'2721','409',179900.41,180113.98,0.00,0.00,213.57,157187.52,0.00,0.00,0.00),('1','176','920','257982',4905463,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257982',4905464,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257983',4905465,'2720','409',369548.32,371046.49,0.00,0.00,1498.17,1019097.76,0.00,0.00,0.00),('1','176','920','257983',4905466,'2721','409',180113.98,180467.66,0.00,0.00,353.68,260308.48,0.00,0.00,0.00),('1','176','920','257983',4905467,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257983',4905468,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257984',4905469,'2720','409',371046.49,372679.19,0.00,0.00,1632.70,1110236.00,0.00,0.00,0.00),('1','176','920','257984',4905470,'2721','409',180467.66,180976.58,0.00,0.00,508.92,374565.12,0.00,0.00,0.00),('1','176','920','257984',4905471,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257984',4905472,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257985',4905473,'2720','409',372679.19,373857.16,0.00,0.00,1177.97,801019.60,0.00,0.00,0.00),('1','176','920','257985',4905474,'2721','409',180976.58,181022.59,0.00,0.00,46.01,33863.36,0.00,0.00,0.00),('1','176','920','257985',4905475,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257985',4905476,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257986',4905477,'2720','409',373857.16,376348.47,0.00,0.00,2491.31,1696890.80,0.00,0.00,0.00),('1','176','920','257986',4905478,'2721','409',181022.59,181654.11,0.00,0.00,631.52,464798.72,0.00,0.00,0.00),('1','176','920','257986',4905479,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257986',4905480,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257987',4905481,'2720','409',376348.47,378324.47,0.00,0.00,1976.00,1343680.00,0.00,0.00,0.00),('1','176','920','257987',4905482,'2721','409',181654.11,181855.28,0.00,0.00,201.17,148061.12,0.00,0.00,0.00),('1','176','920','257987',4905483,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257987',4905484,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257988',4905485,'2720','409',378324.47,378626.38,0.00,0.00,301.91,205298.80,0.00,0.00,0.00),('1','176','920','257988',4905486,'2721','409',181855.28,181999.67,0.00,0.00,144.39,106271.04,0.00,0.00,0.00),('1','176','920','257988',4905487,'2722','409',109976.04,109976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257988',4905488,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257989',4905489,'2720','409',378626.38,380417.88,0.00,0.00,1791.50,1218220.00,0.00,0.00,0.00),('1','176','920','257989',4905490,'2721','409',181999.67,182469.40,0.00,0.00,469.73,345721.28,0.00,0.00,0.00),('1','176','920','257989',4905491,'2722','409',109976.04,109988.54,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','176','920','257989',4905492,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257990',4905493,'2720','409',380417.88,382122.31,0.00,0.00,1704.43,1159012.40,0.00,0.00,0.00),('1','176','920','257990',4905494,'2721','409',182469.40,182703.88,0.00,0.00,234.48,172577.28,0.00,0.00,0.00),('1','176','920','257990',4905495,'2722','409',109988.54,109988.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257990',4905496,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257991',4905497,'2720','409',382122.31,382848.55,0.00,0.00,726.24,493843.20,0.00,0.00,0.00),('1','176','920','257991',4905498,'2721','409',182703.88,182946.62,0.00,0.00,242.74,178656.64,0.00,0.00,0.00),('1','176','920','257991',4905499,'2722','409',109988.54,109988.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257991',4905500,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257992',4905501,'2720','409',382848.55,385456.16,0.00,0.00,2607.61,1773555.04,0.00,0.00,0.00),('1','176','920','257992',4905502,'2721','409',182946.62,184247.88,0.00,0.00,1301.26,957727.36,0.00,0.00,0.00),('1','176','920','257992',4905503,'2722','409',109988.54,110013.54,0.00,0.00,25.00,18400.00,0.00,0.00,0.00),('1','176','920','257992',4905504,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257993',4905505,'2720','409',385456.16,385874.62,0.00,0.00,418.46,284552.80,0.00,0.00,0.00),('1','176','920','257993',4905506,'2721','409',184247.88,184281.03,0.00,0.00,33.15,24398.40,0.00,0.00,0.00),('1','176','920','257993',4905507,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257993',4905508,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257994',4905509,'2720','409',385874.62,387329.95,0.00,0.00,1455.33,989624.40,0.00,0.00,0.00),('1','176','920','257994',4905510,'2721','409',184281.03,184526.24,0.00,0.00,245.21,180474.56,0.00,0.00,0.00),('1','176','920','257994',4905511,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257994',4905512,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257995',4905513,'2720','409',387329.95,390292.44,0.00,0.00,2962.49,2014493.20,0.00,0.00,0.00),('1','176','920','257995',4905514,'2721','409',184526.24,185252.56,0.00,0.00,726.32,534571.52,0.00,0.00,0.00),('1','176','920','257995',4905515,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257995',4905516,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257996',4905517,'2720','409',390292.44,392199.68,0.00,0.00,1907.24,1296923.20,0.00,0.00,0.00),('1','176','920','257996',4905518,'2721','409',185252.56,185880.04,0.00,0.00,627.48,461825.28,0.00,0.00,0.00),('1','176','920','257996',4905519,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257996',4905520,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257997',4905521,'2720','409',392199.68,394514.77,0.00,0.00,2315.09,1574261.20,0.00,0.00,0.00),('1','176','920','257997',4905522,'2721','409',185880.04,186063.88,0.00,0.00,183.84,135306.24,0.00,0.00,0.00),('1','176','920','257997',4905523,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257997',4905524,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257998',4905525,'2720','409',394514.77,395892.52,0.00,0.00,1377.75,936870.00,0.00,0.00,0.00),('1','176','920','257998',4905526,'2721','409',186063.88,186313.96,0.00,0.00,250.08,184058.88,0.00,0.00,0.00),('1','176','920','257998',4905527,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257998',4905528,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257999',4905529,'2720','409',395892.52,397904.22,0.00,0.00,2011.70,1357943.25,0.00,0.00,0.00),('1','176','920','257999',4905530,'2721','409',186313.96,186940.48,0.00,0.00,626.52,458678.72,0.00,0.00,0.00),('1','176','920','257999',4905531,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','257999',4905532,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258000',4905533,'2720','409',397904.22,400851.01,0.00,0.00,2946.79,1989083.25,0.00,0.00,0.00),('1','176','920','258000',4905534,'2721','409',186940.48,187599.33,0.00,0.00,658.85,484913.60,0.00,0.00,0.00),('1','176','920','258000',4905535,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258000',4905536,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258001',4905537,'2720','409',400851.01,403245.52,0.00,0.00,2394.51,1616294.25,0.00,0.00,0.00),('1','176','920','258001',4905538,'2721','409',187599.33,188159.44,0.00,0.00,560.11,412240.96,0.00,0.00,0.00),('1','176','920','258001',4905539,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258001',4905540,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258002',4905541,'2720','409',403245.52,406046.63,0.00,0.00,2801.11,1890749.25,0.00,0.00,0.00),('1','176','920','258002',4905542,'2721','409',188159.44,188845.78,0.00,0.00,686.34,505146.24,0.00,0.00,0.00),('1','176','920','258002',4905543,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258002',4905544,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258003',4905545,'2720','409',406046.63,409759.34,0.00,0.00,3712.71,2506079.25,0.00,0.00,0.00),('1','176','920','258003',4905546,'2721','409',188845.78,189435.72,0.00,0.00,589.94,434195.84,0.00,0.00,0.00),('1','176','920','258003',4905547,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258003',4905548,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258004',4905549,'2720','409',409759.34,412382.93,0.00,0.00,2623.59,1770923.25,0.00,0.00,0.00),('1','176','920','258004',4905550,'2721','409',189435.72,189915.71,0.00,0.00,479.99,353272.64,0.00,0.00,0.00),('1','176','920','258004',4905551,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258004',4905552,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258005',4905553,'2720','409',412382.93,414624.87,0.00,0.00,2241.94,1513309.50,0.00,0.00,0.00),('1','176','920','258005',4905554,'2721','409',189915.71,190311.93,0.00,0.00,396.22,291617.92,0.00,0.00,0.00),('1','176','920','258005',4905555,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258005',4905556,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258006',4905557,'2720','409',414624.87,415081.68,0.00,0.00,456.81,308346.75,0.00,0.00,0.00),('1','176','920','258006',4905558,'2721','409',190311.93,190438.43,0.00,0.00,126.50,93104.00,0.00,0.00,0.00),('1','176','920','258006',4905559,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258006',4905560,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258007',4905561,'2720','409',415081.68,416775.80,0.00,0.00,1694.12,1143531.00,0.00,0.00,0.00),('1','176','920','258007',4905562,'2721','409',190438.43,190950.68,0.00,0.00,512.25,377016.00,0.00,0.00,0.00),('1','176','920','258007',4905563,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258007',4905564,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258008',4905565,'2720','409',416775.80,419966.68,0.00,0.00,3190.88,2154216.71,0.00,0.00,0.00),('1','176','920','258008',4905566,'2721','409',190950.68,191879.93,0.00,0.00,929.25,683928.00,0.00,0.00,0.00),('1','176','920','258008',4905567,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258008',4905568,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258009',4905569,'2720','409',419966.68,422002.14,0.00,0.00,2035.46,1373935.50,0.00,0.00,0.00),('1','176','920','258009',4905570,'2721','409',191879.93,192751.75,0.00,0.00,871.82,641659.52,0.00,0.00,0.00),('1','176','920','258009',4905571,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258009',4905572,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258010',4905573,'2720','409',422002.14,423809.27,0.00,0.00,1807.13,1219812.75,0.00,0.00,0.00),('1','176','920','258010',4905574,'2721','409',192751.75,193106.98,0.00,0.00,355.23,261449.28,0.00,0.00,0.00),('1','176','920','258010',4905575,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258010',4905576,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258011',4905577,'2720','409',423809.27,425621.11,0.00,0.00,1811.84,1222992.00,0.00,0.00,0.00),('1','176','920','258011',4905578,'2721','409',193106.98,193611.19,0.00,0.00,504.21,368048.56,0.00,0.00,0.00),('1','176','920','258011',4905579,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258011',4905580,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258012',4905581,'2720','409',425621.11,428945.24,0.00,0.00,3324.13,2243787.75,0.00,0.00,0.00),('1','176','920','258012',4905582,'2721','409',193611.19,194461.87,0.00,0.00,850.68,626100.48,0.00,0.00,0.00),('1','176','920','258012',4905583,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258012',4905584,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258013',4905585,'2720','409',428945.24,432130.53,0.00,0.00,3185.29,2150070.75,0.00,0.00,0.00),('1','176','920','258013',4905586,'2721','409',194461.87,195114.81,0.00,0.00,652.94,480563.84,0.00,0.00,0.00),('1','176','920','258013',4905587,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258013',4905588,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258014',4905589,'2720','409',432130.53,433789.95,0.00,0.00,1659.42,1120108.50,0.00,0.00,0.00),('1','176','920','258014',4905590,'2721','409',195114.81,195917.78,0.00,0.00,802.97,574332.92,0.00,0.00,0.00),('1','176','920','258014',4905591,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258014',4905592,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258015',4905593,'2720','409',433789.95,435581.35,0.00,0.00,1791.40,1209195.00,0.00,0.00,0.00),('1','176','920','258015',4905594,'2721','409',195917.78,196356.79,0.00,0.00,439.01,323111.36,0.00,0.00,0.00),('1','176','920','258015',4905595,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258015',4905596,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258016',4905597,'2720','409',435581.35,441679.05,0.00,0.00,6097.70,4116030.46,0.00,0.00,0.00),('1','176','920','258016',4905598,'2721','409',196356.79,197278.12,0.00,0.00,921.33,665898.88,0.00,0.00,0.00),('1','176','920','258016',4905599,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258016',4905600,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258017',4905601,'2720','409',441679.05,444139.05,0.00,0.00,2460.00,1660500.00,0.00,0.00,0.00),('1','176','920','258017',4905602,'2721','409',197278.12,197921.08,0.00,0.00,642.96,473218.56,0.00,0.00,0.00),('1','176','920','258017',4905603,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258017',4905604,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258018',4905605,'2720','409',444139.05,446811.93,0.00,0.00,2672.88,1804194.00,0.00,0.00,0.00),('1','176','920','258018',4905606,'2721','409',197921.08,198497.72,0.00,0.00,576.64,424407.04,0.00,0.00,0.00),('1','176','920','258018',4905607,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258018',4905608,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258019',4905609,'2720','409',446811.93,448565.05,0.00,0.00,1753.12,1183356.00,0.00,0.00,0.00),('1','176','920','258019',4905610,'2721','409',198497.72,198769.33,0.00,0.00,271.61,199904.96,0.00,0.00,0.00),('1','176','920','258019',4905611,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258019',4905612,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258020',4905613,'2720','409',448565.05,450258.32,0.00,0.00,1693.27,1142957.25,0.00,0.00,0.00),('1','176','920','258020',4905614,'2721','409',198769.33,199372.37,0.00,0.00,603.04,443837.44,0.00,0.00,0.00),('1','176','920','258020',4905615,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258020',4905616,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258021',4905617,'2720','409',450258.32,453291.84,0.00,0.00,3033.52,2050286.21,0.00,0.00,0.00),('1','176','920','258021',4905618,'2721','409',199372.37,199886.92,0.00,0.00,514.55,378708.80,0.00,0.00,0.00),('1','176','920','258021',4905619,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258021',4905620,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258022',4905621,'2720','409',453291.84,454106.39,0.00,0.00,814.55,549821.25,0.00,0.00,0.00),('1','176','920','258022',4905622,'2721','409',199886.92,200191.60,0.00,0.00,304.68,224244.48,0.00,0.00,0.00),('1','176','920','258022',4905623,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258022',4905624,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258023',4905625,'2720','409',454106.39,456359.46,0.00,0.00,2253.07,1520822.25,0.00,0.00,0.00),('1','176','920','258023',4905626,'2721','409',200191.60,200569.53,0.00,0.00,377.93,275106.48,0.00,0.00,0.00),('1','176','920','258023',4905627,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258023',4905628,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258024',4905629,'2720','409',456359.46,458466.82,0.00,0.00,2107.36,1422468.00,0.00,0.00,0.00),('1','176','920','258024',4905630,'2721','409',200569.53,200937.87,0.00,0.00,368.34,271098.24,0.00,0.00,0.00),('1','176','920','258024',4905631,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258024',4905632,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258025',4905633,'2720','409',458466.82,458877.41,0.00,0.00,410.59,277148.25,0.00,0.00,0.00),('1','176','920','258025',4905634,'2721','409',200937.87,201135.66,0.00,0.00,197.79,145573.44,0.00,0.00,0.00),('1','176','920','258025',4905635,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258025',4905636,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258026',4905637,'2720','409',458877.41,461025.34,0.00,0.00,2147.93,1449852.75,0.00,0.00,0.00),('1','176','920','258026',4905638,'2721','409',201135.66,201471.97,0.00,0.00,336.31,247524.16,0.00,0.00,0.00),('1','176','920','258026',4905639,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258026',4905640,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258027',4905641,'2720','409',461025.34,462700.22,0.00,0.00,1674.88,1130544.00,0.00,0.00,0.00),('1','176','920','258027',4905642,'2721','409',201471.97,201788.16,0.00,0.00,316.19,232715.84,0.00,0.00,0.00),('1','176','920','258027',4905643,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258027',4905644,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258028',4905645,'2720','409',462700.22,464844.92,0.00,0.00,2144.70,1411212.60,0.00,0.00,0.00),('1','176','920','258028',4905646,'2721','409',201788.16,202320.70,0.00,0.00,532.54,372778.00,0.00,0.00,0.00),('1','176','920','258028',4905647,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258028',4905648,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258029',4905649,'2720','409',464844.92,466780.69,0.00,0.00,1935.77,1273736.66,0.00,0.00,0.00),('1','176','920','258029',4905650,'2721','409',202320.70,202847.69,0.00,0.00,526.99,368893.00,0.00,0.00,0.00),('1','176','920','258029',4905651,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258029',4905652,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258030',4905653,'2720','409',466780.69,469469.15,0.00,0.00,2688.46,1771196.14,0.00,0.00,0.00),('1','176','920','258030',4905654,'2721','409',202847.69,203297.76,0.00,0.00,450.07,315049.00,0.00,0.00,0.00),('1','176','920','258030',4905655,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258030',4905656,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258031',4905657,'2720','409',469469.15,471041.27,0.00,0.00,1572.12,1034454.96,0.00,0.00,0.00),('1','176','920','258031',4905658,'2721','409',203297.76,203590.16,0.00,0.00,292.40,204680.00,0.00,0.00,0.00),('1','176','920','258031',4905659,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258031',4905660,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258032',4905661,'2720','409',471041.27,472020.27,0.00,0.00,979.00,644182.00,0.00,0.00,0.00),('1','176','920','258032',4905662,'2721','409',203590.16,204005.68,0.00,0.00,415.52,290864.00,0.00,0.00,0.00),('1','176','920','258032',4905663,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258032',4905664,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258033',4905665,'2720','409',472020.27,474511.18,0.00,0.00,2490.91,1639018.78,0.00,0.00,0.00),('1','176','920','258033',4905666,'2721','409',204005.68,204726.27,0.00,0.00,720.59,504413.00,0.00,0.00,0.00),('1','176','920','258033',4905667,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258033',4905668,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258034',4905669,'2720','409',474511.18,474955.09,0.00,0.00,443.91,292092.78,0.00,0.00,0.00),('1','176','920','258034',4905670,'2721','409',204726.27,204756.34,0.00,0.00,30.07,21049.00,0.00,0.00,0.00),('1','176','920','258034',4905671,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258034',4905672,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258035',4905673,'2720','409',474955.09,477188.90,0.00,0.00,2233.81,1469846.98,0.00,0.00,0.00),('1','176','920','258035',4905674,'2721','409',204756.34,205210.13,0.00,0.00,453.79,317653.00,0.00,0.00,0.00),('1','176','920','258035',4905675,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258035',4905676,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258036',4905677,'2720','409',477188.90,478495.28,0.00,0.00,1306.38,859598.04,0.00,0.00,0.00),('1','176','920','258036',4905678,'2721','409',205210.13,205599.37,0.00,0.00,389.24,272468.00,0.00,0.00,0.00),('1','176','920','258036',4905679,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258036',4905680,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258037',4905681,'2720','409',478495.28,478608.32,0.00,0.00,113.04,74380.32,0.00,0.00,0.00),('1','176','920','258037',4905682,'2721','409',205599.37,205652.44,0.00,0.00,53.07,37149.00,0.00,0.00,0.00),('1','176','920','258037',4905683,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258037',4905684,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258038',4905685,'2720','409',478608.32,480726.88,0.00,0.00,2118.56,1394012.48,0.00,0.00,0.00),('1','176','920','258038',4905686,'2721','409',205652.44,205989.11,0.00,0.00,336.67,235669.00,0.00,0.00,0.00),('1','176','920','258038',4905687,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258038',4905688,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258039',4905689,'2720','409',480726.88,482553.68,0.00,0.00,1826.80,1202034.40,0.00,0.00,0.00),('1','176','920','258039',4905690,'2721','409',205989.11,206443.28,0.00,0.00,454.17,317919.00,0.00,0.00,0.00),('1','176','920','258039',4905691,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258039',4905692,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258040',4905693,'2720','409',482553.68,482553.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258040',4905694,'2721','409',206443.28,206547.08,0.00,0.00,103.80,72660.00,0.00,0.00,0.00),('1','176','920','258040',4905695,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258040',4905696,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258041',4905697,'2720','409',482553.68,484733.58,0.00,0.00,2179.90,1434374.20,0.00,0.00,0.00),('1','176','920','258041',4905698,'2721','409',206547.08,207107.72,0.00,0.00,560.64,392448.00,0.00,0.00,0.00),('1','176','920','258041',4905699,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258041',4905700,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258042',4905701,'2720','409',484733.58,485390.90,0.00,0.00,657.32,432516.56,0.00,0.00,0.00),('1','176','920','258042',4905702,'2721','409',207107.72,207253.00,0.00,0.00,145.28,101696.00,0.00,0.00,0.00),('1','176','920','258042',4905703,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258042',4905704,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258043',4905705,'2720','409',485390.90,486582.05,0.00,0.00,1191.15,774247.50,0.00,0.00,0.00),('1','176','920','258043',4905706,'2721','409',207253.00,207519.16,0.00,0.00,266.16,186312.00,0.00,0.00,0.00),('1','176','920','258043',4905707,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258043',4905708,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258044',4905709,'2720','409',486582.05,489150.82,0.00,0.00,2568.77,1669700.50,0.00,0.00,0.00),('1','176','920','258044',4905710,'2721','409',207519.16,208218.00,0.00,0.00,698.84,489188.00,0.00,0.00,0.00),('1','176','920','258044',4905711,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258044',4905712,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258045',4905713,'2720','409',489150.82,490643.85,0.00,0.00,1493.03,971719.50,0.00,0.00,0.00),('1','176','920','258045',4905714,'2721','409',208218.00,208768.18,0.00,0.00,550.18,385126.00,0.00,0.00,0.00),('1','176','920','258045',4905715,'2722','409',110013.54,110013.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','176','920','258045',4905716,'2723','409',37116.77,37116.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730184 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','176','186034','409',323.00,252.00,0.00,50.79,16405.17,12799.08,-3606.09,544408),('1','176','186126','409',323.00,352.00,0.00,25.00,8075.00,8800.00,725.00,544633),('1','176','186376','409',323.00,352.00,0.00,87.70,28327.10,30870.40,2543.30,545288),('1','176','186557','409',323.00,352.00,0.00,906.50,292799.50,297632.00,4832.50,545765),('1','176','186779','409',323.00,352.00,0.00,919.84,297108.32,304415.68,7307.36,546337),('1','176','187012','409',323.00,352.00,0.00,2647.10,855013.30,870075.20,15061.90,546922),('1','176','187218','409',323.00,352.00,0.00,1411.21,455820.83,465857.92,10037.09,547473),('1','176','187465','409',323.00,352.00,0.00,2444.95,789718.85,803034.40,13315.55,548136),('1','176','187681','409',323.00,352.00,0.00,903.80,291927.40,297874.40,5947.00,548708),('1','176','187682','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,548709),('1','176','187687','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,548721),('1','176','187718','409',323.00,352.00,0.00,2173.76,702124.48,714643.52,12519.04,548800),('1','176','187864','409',323.00,352.00,0.00,2838.49,916832.27,932929.60,16097.33,549184),('1','176','188091','409',323.00,352.00,0.00,4055.06,1309784.38,1336736.48,26952.10,549772),('1','176','188355','409',323.00,352.00,0.00,537.92,173748.16,176857.76,3109.60,550468),('1','176','188367','409',323.00,352.00,0.00,4879.70,1576143.10,1601209.76,25066.66,550498),('1','176','188443','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,550680),('1','176','188453','409',323.00,352.00,0.00,4290.68,1385889.64,1413923.36,28033.72,550704),('1','176','188564','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,550999),('1','176','188663','409',323.00,352.00,0.00,2568.27,829551.21,846203.04,16651.83,551241),('1','176','188802','409',323.00,352.00,0.00,2558.04,826246.92,841469.28,15222.36,551624),('1','176','188920','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,551936),('1','176','188924','409',323.00,352.00,0.00,2195.19,709046.37,722306.88,13260.51,551944),('1','176','189012','409',323.00,352.00,0.00,2823.84,912100.32,926887.68,14787.36,552175),('1','176','189158','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,552565),('1','176','189160','409',323.00,352.00,0.00,2030.13,655731.99,668633.76,12901.77,552569),('1','176','189216','409',323.00,352.00,0.00,2734.63,883285.49,903933.76,20648.27,552698),('1','176','189378','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,553144),('1','176','189425','409',323.00,352.00,0.00,4991.29,1612186.67,1641722.08,29535.41,553257),('1','176','189582','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,553668),('1','176','189620','409',323.00,352.00,0.00,4424.31,1429052.13,1452237.12,23184.99,553760),('1','176','189823','409',323.00,352.00,0.00,770.00,248710.00,253160.00,4450.00,554270),('1','176','189874','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,554405),('1','176','189878','409',323.00,352.00,0.00,4228.65,1365853.95,1391692.80,25838.85,554414),('1','176','190038','409',323.00,352.00,0.00,615.87,198926.01,203198.88,4272.87,554838),('1','176','190131','409',323.00,352.00,0.00,1010.34,326339.82,331459.68,5119.86,555090),('1','176','190222','409',323.00,352.00,0.00,3945.88,1274519.24,1298155.36,23636.12,555322),('1','176','190397','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,555795),('1','176','190398','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,555796),('1','176','190430','409',323.00,352.00,0.00,5060.11,1634415.53,1661638.96,27223.43,555873),('1','176','190624','409',323.00,352.00,0.00,0.00,0.00,0.00,0.00,556401),('1','176','190693','409',313.00,352.00,0.00,4341.87,1359005.31,1428500.40,69495.09,556556),('1','176','190891','409',313.00,352.00,0.00,658.13,205994.69,217198.64,11203.95,557085),('1','176','190900','409',313.00,352.00,0.00,3868.19,1210743.47,1272707.60,61964.13,557106),('1','176','191172','409',313.00,352.00,0.00,1131.82,354259.66,371819.68,17560.02,557827),('1','176','191185','409',313.00,352.00,0.00,2951.97,923966.61,969133.44,45166.83,557862),('1','176','191289','409',313.00,352.00,0.00,2048.01,641027.13,674290.80,33263.67,558133),('1','176','191351','409',313.00,352.00,0.00,3570.49,1117563.37,1172225.68,54662.31,558290),('1','176','191499','409',313.00,352.00,0.00,1429.51,447436.63,470413.36,22976.73,558686),('1','176','191617','409',313.00,352.00,0.00,1293.30,404802.90,424679.52,19876.62,559005),('1','176','191713','409',313.00,352.00,0.00,3441.47,1077180.11,1130925.44,53745.33,559255),('1','176','191839','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,559600),('1','176','191845','409',313.00,352.00,0.00,2824.09,883940.17,932613.28,48673.11,559614),('1','176','191935','409',313.00,352.00,0.00,2287.30,715924.90,750680.80,34755.90,559856),('1','176','192054','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,560168),('1','176','192061','409',313.00,352.00,0.00,2671.59,836207.67,876761.52,40553.85,560187),('1','176','192137','409',313.00,352.00,0.00,2329.32,729077.16,764316.96,35239.80,560382),('1','176','192225','409',313.00,352.00,0.00,1747.95,547108.35,574456.56,27348.21,560614),('1','176','192343','409',313.00,352.00,0.00,3252.06,1017894.78,1067275.68,49380.90,560924),('1','176','192447','409',313.00,352.00,0.00,1540.97,482323.61,505738.16,23414.55,561194),('1','176','192575','409',313.00,352.00,0.00,3440.53,1076885.89,1129924.24,53038.35,561520),('1','176','192646','409',313.00,352.00,0.00,2157.96,675441.48,712673.28,37231.80,561715),('1','176','192759','409',313.00,352.00,0.00,2854.54,893471.02,936963.52,43492.50,562009),('1','176','192854','409',313.00,352.00,0.00,4325.30,1353818.90,1419145.04,65326.14,562256),('1','176','192991','409',313.00,352.00,0.00,405.49,126918.37,133000.72,6082.35,562606),('1','176','193014','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,562670),('1','176','193019','409',313.00,352.00,0.00,2390.39,748192.07,785247.92,37055.85,562683),('1','176','193177','409',313.00,352.00,0.00,2793.79,874456.27,917525.68,43069.41,563105),('1','176','193282','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,563396),('1','176','193291','409',313.00,352.00,0.00,1567.84,490733.92,515519.68,24785.76,563420),('1','176','193407','409',313.00,352.00,0.00,3314.95,1037579.35,1088176.72,50597.37,563718),('1','176','193510','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,563980),('1','176','193513','409',313.00,352.00,0.00,2575.47,806122.11,852217.44,46095.33,563983),('1','176','193628','409',313.00,352.00,0.00,2453.26,767870.38,805473.76,37603.38,564291),('1','176','193732','409',313.00,352.00,0.00,1931.00,604403.00,634066.40,29663.40,564549),('1','176','193852','409',313.00,352.00,0.00,3093.74,968340.62,1016096.00,47755.38,564846),('1','176','193979','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,565170),('1','176','193983','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,565176),('1','176','193990','409',313.00,352.00,0.00,1627.32,509351.16,534443.52,25092.36,565189),('1','176','194082','409',313.00,352.00,0.00,3372.68,1055648.84,1108369.76,52720.92,565423),('1','176','194184','409',313.00,352.00,0.00,1639.36,513119.68,538160.08,25040.40,565693),('1','176','194292','409',313.00,352.00,0.00,3360.74,1051911.62,1107092.24,55180.62,565975),('1','176','194393','409',313.00,352.00,0.00,2529.02,791583.26,837823.04,46239.78,566226),('1','176','194498','409',313.00,352.00,0.00,2470.98,773416.74,812366.64,38949.90,566484),('1','176','194577','409',313.00,352.00,0.00,1077.65,337304.45,354389.60,17085.15,566689),('1','176','194685','409',313.00,352.00,0.00,3922.35,1227695.55,1288885.20,61189.65,566958),('1','176','194781','409',313.00,352.00,0.00,2574.39,805784.07,845292.72,39508.65,567220),('1','176','194963','409',313.00,352.00,0.00,1831.62,573297.06,601453.20,28156.14,567706),('1','176','194978','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,567745),('1','176','194992','409',313.00,352.00,0.00,2172.65,680039.45,713853.44,33813.99,567782),('1','176','195081','409',313.00,352.00,0.00,2827.35,884960.55,930574.80,45614.25,568012),('1','176','195186','409',313.00,352.00,0.00,3368.47,1054331.11,1106870.08,52538.97,568286),('1','176','195312','409',313.00,352.00,0.00,1631.53,510668.89,537196.48,26527.59,568601),('1','176','195397','409',313.00,352.00,0.00,2320.50,726316.50,764040.00,37723.50,568818),('1','176','195519','409',313.00,352.00,0.00,2679.51,838686.63,881639.76,42953.13,569140),('1','176','195608','409',313.00,352.00,0.00,3072.93,961827.09,1010729.76,48902.67,569362),('1','176','195781','409',313.00,352.00,0.00,1927.07,603172.91,632378.96,29206.05,569792),('1','176','195876','409',313.00,352.00,0.00,2881.56,901928.28,948129.12,46200.84,570019),('1','176','196004','409',313.00,352.00,0.00,1797.50,562617.50,590120.00,27502.50,570359),('1','176','196083','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,570556),('1','176','196089','409',313.00,352.00,0.00,2214.13,693022.69,727810.96,34788.27,570567),('1','176','196232','409',313.00,352.00,0.00,2785.87,871977.31,914704.72,42727.41,570926),('1','176','196313','409',313.00,352.00,0.00,2955.86,925184.18,972079.04,46894.86,571130),('1','176','196443','409',313.00,352.00,0.00,2044.14,639815.82,671518.08,31702.26,571480),('1','176','196522','409',313.00,352.00,0.00,2339.83,732366.79,768678.64,36311.85,571675),('1','176','196678','409',313.00,352.00,0.00,2660.17,832633.21,872835.76,40202.55,572068),('1','176','196755','409',313.00,352.00,0.00,3328.05,1041679.65,1081108.36,39428.71,572279),('1','176','196905','409',313.00,352.00,0.00,1671.95,523320.35,543197.76,19877.41,572668),('1','176','196957','409',313.00,352.00,0.00,491.30,153776.90,159321.20,5544.30,572803),('1','176','197033','409',313.00,352.00,0.00,4269.26,1336278.38,1387405.80,51127.42,573001),('1','176','197177','409',313.00,352.00,0.00,0.00,0.00,0.00,0.00,573386),('1','176','197319','409',307.00,352.00,0.00,5000.00,1535000.00,1622102.24,87102.24,573763),('1','176','197394','409',307.00,352.00,0.00,1115.49,342455.43,362118.76,19663.33,573881),('1','176','197424','409',307.00,352.00,0.00,3884.52,1192547.64,1261253.16,68705.52,573944),('1','176','197513','409',313.00,352.00,0.00,3351.18,1048919.34,1089371.36,40452.02,574161),('1','176','197882','409',313.00,352.00,0.00,1648.82,516080.66,536210.72,20130.06,575146),('1','176','197952','409',313.00,352.00,0.00,3071.34,961329.42,997850.60,36521.18,575327),('1','176','198130','409',313.00,352.00,0.00,1928.66,603670.58,625842.32,22171.74,575779),('1','176','198205','409',313.00,352.00,0.00,1248.91,390908.83,405618.16,14709.33,575967),('1','176','198347','409',307.00,352.00,0.00,3317.21,1018383.47,1066824.32,48440.85,576353),('1','176','198518','409',307.00,352.00,0.00,0.00,0.00,0.00,0.00,576808),('1','176','198521','409',307.00,352.00,0.00,456.27,140074.89,146998.40,6923.51,576815),('1','176','198573','409',307.00,352.00,0.00,3955.89,1214458.23,1273289.92,58831.69,576940),('1','176','198786','409',307.00,352.00,0.00,587.84,180466.88,189499.52,9032.64,577457),('1','176','198808','409',307.00,352.00,0.00,5000.00,1535000.00,1605397.76,70397.76,577504),('1','176','198949','409',307.00,352.00,0.00,487.50,149662.50,156000.00,6337.50,577893),('1','176','198987','409',307.00,352.00,0.00,3788.53,1163078.71,1216720.64,53641.93,577984),('1','176','199210','409',307.00,352.00,0.00,723.97,222258.79,232070.40,9811.61,578542),('1','176','199244','409',307.00,352.00,0.00,4005.87,1229802.09,1288626.24,58824.15,578625),('1','176','199434','409',307.00,352.00,0.00,994.13,305197.91,318521.60,13323.69,579095),('1','176','199480','409',307.00,352.00,0.00,2445.94,750903.58,788810.88,37907.30,579197),('1','176','199648','409',307.00,352.00,0.00,2123.81,652009.67,680019.20,28009.53,579636),('1','176','199770','409',307.00,352.00,0.00,0.00,0.00,0.00,0.00,579910),('1','176','199771','409',307.00,352.00,0.00,2767.70,849683.90,889296.00,39612.10,579911),('1','176','199865','409',307.00,352.00,0.00,2232.30,685316.10,715763.84,30447.74,580150),('1','176','200056','409',307.00,352.00,0.00,249.21,76507.47,79747.20,3239.73,580666),('1','176','200094','409',307.00,352.00,0.00,4311.82,1323728.74,1383204.80,59476.06,580757),('1','176','200292','409',307.00,352.00,0.00,492.00,151044.00,157440.00,6396.00,581270),('1','176','200299','409',307.00,352.00,0.00,5000.00,1535000.00,1604123.20,69123.20,581283),('1','176','200453','409',307.00,352.00,0.00,218.00,66926.00,69760.00,2834.00,581699),('1','176','200485','409',307.00,352.00,0.00,4179.66,1283155.62,1344319.04,61163.42,581777),('1','176','200692','409',307.00,352.00,0.00,602.34,184918.38,192748.80,7830.42,582316),('1','176','200725','409',307.00,352.00,0.00,4255.09,1306312.63,1363020.80,56708.17,582394),('1','176','200864','409',307.00,352.00,0.00,0.00,0.00,0.00,0.00,582763),('1','176','200916','409',307.00,352.00,0.00,4002.78,1228853.46,1285136.64,56283.18,582884),('1','176','201105','409',307.00,352.00,0.00,997.23,306149.61,319709.12,13559.51,583368),('1','176','201158','409',307.00,352.00,0.00,4141.93,1271572.51,1328807.36,57234.85,583488),('1','176','201309','409',307.00,352.00,0.00,858.07,263427.49,274673.28,11245.79,583890),('1','176','201344','409',307.00,352.00,0.00,2966.07,910583.49,955424.64,44841.15,583969),('1','176','201507','409',307.00,352.00,0.00,2033.90,624407.30,651548.80,27141.50,584402),('1','176','201548','409',307.00,352.00,0.00,3795.86,1165329.02,1217166.72,51837.70,584502),('1','176','201762','409',307.00,352.00,0.00,1204.14,369670.98,405391.04,35720.06,585084),('1','176','201815','409',307.00,352.00,0.00,3046.09,935149.63,1026235.68,91086.05,585217),('1','176','202051','409',307.00,352.00,0.00,1308.80,401801.60,440012.80,38211.20,585836),('1','176','202117','409',307.00,352.00,0.00,0.00,0.00,0.00,0.00,586010),('1','176','202133','409',317.00,352.00,0.00,2481.07,786499.19,835223.20,48724.01,586053),('1','176','202259','409',317.00,352.00,0.00,2566.13,813463.21,862669.76,49206.55,586370),('1','176','202361','409',317.00,352.00,0.00,0.00,0.00,0.00,0.00,586640),('1','176','202365','409',317.00,352.00,0.00,1234.12,391216.04,415362.24,24146.20,586650),('1','176','202442','409',317.00,352.00,0.00,3873.32,1227842.44,1303832.64,75990.20,586842),('1','176','202652','409',317.00,352.00,0.00,0.00,0.00,0.00,0.00,587380),('1','176','202657','409',317.00,352.00,0.00,272.49,86379.33,95916.48,9537.15,587392),('1','176','202854','409',317.00,352.00,0.00,280.95,89061.15,98894.40,9833.25,587902),('1','176','203107','409',317.00,352.00,0.00,3268.02,1035962.34,1101400.32,65437.98,588559),('1','176','203313','409',317.00,352.00,0.00,269.02,85279.34,94695.04,9415.70,589108),('1','176','203521','409',317.00,352.00,0.00,330.82,104869.94,116448.64,11578.70,589625),('1','176','203724','409',317.00,352.00,0.00,687.16,217829.72,236812.16,18982.44,590156),('1','176','203834','409',317.00,376.00,0.00,0.00,0.00,0.00,0.00,590438),('1','176','203836','409',317.00,376.00,0.00,1811.69,574305.73,611577.04,37271.31,590441),('1','176','203961','409',317.00,376.00,0.00,2698.02,855272.34,933998.56,78726.22,590763),('1','176','204199','409',317.00,376.00,0.00,577.64,183111.88,198708.16,15596.28,591385),('1','176','204257','409',317.00,376.00,0.00,0.00,0.00,0.00,0.00,591527),('1','176','204267','409',322.00,376.00,0.00,1984.80,639105.60,689452.80,50347.20,591552),('1','176','204405','409',322.00,376.00,0.00,2384.97,767960.34,824162.48,56202.14,591914),('1','176','204613','409',322.00,376.00,0.00,787.50,253575.00,271492.00,17917.00,592457),('1','176','204689','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,592639),('1','176','204701','409',322.00,376.00,0.00,2175.76,700594.72,751845.76,51251.04,592670),('1','176','204837','409',322.00,376.00,0.00,2790.17,898434.74,965068.72,66633.98,592989),('1','176','204978','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,593352),('1','176','204984','409',322.00,376.00,0.00,798.13,256997.86,275264.88,18267.02,593368),('1','176','205037','409',322.00,376.00,0.00,3413.62,1099185.64,1181268.96,82083.32,593507),('1','176','205247','409',322.00,376.00,0.00,910.00,293020.00,313632.00,20612.00,594048),('1','176','205341','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,594291),('1','176','205344','409',322.00,376.00,0.00,586.00,188692.00,203584.00,14892.00,594297),('1','176','205470','409',322.00,376.00,0.00,4213.37,1356705.14,1454726.64,98021.50,594623),('1','176','205726','409',322.00,376.00,0.00,471.40,151790.80,162161.60,10370.80,595289),('1','176','205785','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,595436),('1','176','205788','409',322.00,376.00,0.00,2914.11,938343.42,1005641.36,67297.94,595443),('1','176','205939','409',322.00,376.00,0.00,2134.86,687424.92,740108.96,52684.04,595841),('1','176','206081','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,596207),('1','176','206087','409',312.00,376.00,0.00,624.94,194981.28,216196.96,21215.68,596222),('1','176','206150','409',312.00,376.00,0.00,3123.27,974460.24,1078557.52,104097.28,596376),('1','176','206360','409',312.00,376.00,0.00,1251.80,390561.60,433374.72,42813.12,596911),('1','176','206406','409',312.00,376.00,0.00,4353.72,1358360.64,1501878.72,143518.08,597023),('1','176','206569','409',312.00,376.00,0.00,646.28,201639.36,223280.32,21640.96,597447),('1','176','206606','409',312.00,376.00,0.00,4287.11,1337578.32,1478226.64,140648.32,597530),('1','176','206797','409',312.00,376.00,0.00,712.89,222421.68,245383.28,22961.60,598032),('1','176','206860','409',312.00,376.00,0.00,3411.45,1064372.40,1176369.20,111996.80,598187),('1','176','207020','409',312.00,376.00,0.00,1588.56,495630.72,549273.28,53642.56,598616),('1','176','207115','409',312.00,376.00,0.00,1834.54,572376.48,633263.84,60887.36,598856),('1','176','207246','409',312.00,376.00,0.00,1765.76,550917.12,608709.76,57792.64,599199),('1','176','207354','409',312.00,376.00,0.00,0.00,0.00,0.00,0.00,599464),('1','176','207387','409',322.00,376.00,0.00,1401.86,451398.92,485309.60,33910.68,599552),('1','176','207476','409',322.00,376.00,0.00,3796.62,1222511.64,1310716.32,88204.68,599794),('1','176','207657','409',322.00,376.00,0.00,0.00,0.00,0.00,0.00,600251),('1','176','207719','409',322.00,384.00,0.00,2549.10,820810.20,902192.00,81381.80,600396),('1','176','207901','409',322.00,384.00,0.00,2672.93,860683.46,945495.36,84811.90,600870),('1','176','208060','409',322.00,384.00,0.00,0.00,0.00,0.00,0.00,601281),('1','176','208110','409',322.00,384.00,0.00,4829.16,1554989.52,1711465.28,156475.76,601404),('1','176','208281','409',322.00,384.00,0.00,0.00,0.00,0.00,0.00,601859),('1','176','208318','409',322.00,384.00,0.00,5138.43,1654574.46,1816376.32,161801.86,601939),('1','176','208554','409',322.00,384.00,0.00,4281.70,1378707.40,1511066.56,132359.16,602540),('1','176','208756','409',322.00,384.00,0.00,690.71,222408.62,243696.64,21288.02,603071),('1','176','208797','409',322.00,384.00,0.00,0.00,0.00,0.00,0.00,603150),('1','176','208800','409',322.00,384.00,0.00,0.00,0.00,0.00,0.00,603153),('1','176','208805','409',322.00,384.00,0.00,3794.52,1221835.44,1340767.04,118931.60,603166),('1','176','208990','409',322.00,384.00,0.00,284.00,91448.00,99968.00,8520.00,603661),('1','176','208993','409',322.00,400.00,0.00,1103.81,355426.82,411754.12,56327.30,603664),('1','176','209126','409',322.00,400.00,0.00,0.00,0.00,0.00,0.00,603995),('1','176','209127','409',322.00,400.00,0.00,1038.25,334316.50,388784.00,54467.50,603996),('1','176','209207','409',322.00,400.00,0.00,2961.73,953677.06,1105893.56,152216.50,604216),('1','176','209429','409',322.00,400.00,0.00,1350.75,434941.50,507540.00,72598.50,604776),('1','176','209540','409',322.00,400.00,0.00,0.00,0.00,0.00,0.00,605060),('1','176','209547','409',360.00,400.00,0.00,2223.65,800514.00,828905.80,28391.80,605079),('1','176','209647','409',360.00,400.00,0.00,2975.01,1071003.60,1109013.72,38010.12,605326),('1','176','209799','409',360.00,400.00,0.00,0.00,0.00,0.00,0.00,605736),('1','176','209804','409',360.00,400.00,0.00,739.03,266050.80,275395.16,9344.36,605749),('1','176','209857','409',360.00,420.00,0.00,3596.29,1294664.40,1357829.56,63165.16,605881),('1','176','210101','409',360.00,420.00,0.00,203.67,73321.20,85541.40,12220.20,606514),('1','176','210311','409',360.00,420.00,0.00,297.59,107132.40,124987.80,17855.40,607050),('1','176','210516','409',360.00,420.00,0.00,215.05,77418.00,90321.00,12903.00,607597),('1','176','210725','409',360.00,420.00,0.00,280.74,101066.40,117910.80,16844.40,608148),('1','176','210968','409',360.00,420.00,0.00,159.70,57492.00,67074.00,9582.00,608760),('1','176','210971','409',360.00,420.00,0.00,0.00,0.00,0.00,0.00,608767),('1','176','211019','409',360.00,420.00,0.00,31.00,11160.00,13020.00,1860.00,608885),('1','176','211186','409',360.00,420.00,0.00,3222.54,1160114.40,1267981.60,107867.20,609315),('1','176','211371','409',360.00,424.00,0.00,1710.79,615884.40,672240.88,56356.48,609809),('1','176','211456','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,610029),('1','176','211562','409',360.00,424.00,0.00,629.13,226486.80,249558.48,23071.68,610314),('1','176','211636','409',360.00,424.00,0.00,1408.45,507042.00,553881.68,46839.68,610501),('1','176','211775','409',360.00,424.00,0.00,1763.23,634762.80,696432.88,61670.08,610848),('1','176','211986','409',360.00,424.00,0.00,156.50,56340.00,66356.00,10016.00,611395),('1','176','212223','409',360.00,424.00,0.00,208.14,74930.40,88251.36,13320.96,612019),('1','176','212454','409',360.00,424.00,0.00,247.35,89046.00,104876.40,15830.40,612626),('1','176','212664','409',360.00,424.00,0.00,346.23,124642.80,146801.52,22158.72,613186),('1','176','212863','409',360.00,424.00,0.00,123.65,44514.00,52427.60,7913.60,613702),('1','176','213130','409',360.00,424.00,0.00,108.57,39085.20,46033.68,6948.48,614399),('1','176','213271','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,614760),('1','176','213319','409',360.00,424.00,0.00,387.62,139543.20,153470.88,13927.68,614887),('1','176','213386','409',360.00,424.00,0.00,2694.45,970002.00,1060869.20,90867.20,615060),('1','176','213628','409',360.00,424.00,0.00,1669.58,601048.80,658554.72,57505.92,615704),('1','176','213877','409',360.00,424.00,0.00,205.00,73800.00,80360.00,6560.00,616355),('1','176','213909','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,616425),('1','176','213917','409',360.00,424.00,0.00,3227.59,1161932.40,1268953.84,107021.44,616446),('1','176','214091','409',360.00,424.00,0.00,2081.01,749163.60,817644.24,68480.64,616914),('1','176','214175','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,617120),('1','176','214267','409',360.00,424.00,0.00,371.36,133689.60,147973.12,14283.52,617369),('1','176','214328','409',360.00,424.00,0.00,3801.20,1368432.00,1495415.68,126983.68,617528),('1','176','214522','409',360.00,424.00,0.00,954.07,343465.20,374557.68,31092.48,618027),('1','176','214634','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,618314),('1','176','214645','409',360.00,424.00,0.00,3717.00,1338120.00,1461344.32,123224.32,618339),('1','176','214770','409',360.00,424.00,0.00,1351.90,486684.00,532608.80,45924.80,618674),('1','176','214875','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,618942),('1','176','214929','409',360.00,424.00,0.00,1409.74,507506.40,554908.64,47402.24,619091),('1','176','215022','409',360.00,424.00,0.00,3316.09,1193792.40,1304441.36,110648.96,619323),('1','176','215191','409',360.00,424.00,0.00,0.00,0.00,0.00,0.00,619765),('1','176','215223','409',360.00,424.00,0.00,244.99,91955.34,105978.88,14023.54,619842),('1','176','215436','409',378.00,448.00,0.00,731.67,276571.26,309339.52,32768.26,620395),('1','176','215670','409',378.00,448.00,0.00,935.26,353528.28,394580.48,41052.20,621002),('1','176','215900','409',378.00,448.00,0.00,2106.66,796317.48,882128.64,85811.16,621586),('1','176','216175','409',378.00,448.00,0.00,1049.81,396828.18,439077.76,42249.58,622295),('1','176','216286','409',378.00,448.00,0.00,0.00,0.00,0.00,0.00,622596),('1','176','216418','409',392.00,452.00,0.00,1918.08,751887.36,804708.72,52821.36,622928),('1','176','216548','409',392.00,452.00,0.00,1784.31,699449.52,747755.76,48306.24,623285),('1','176','216781','409',392.00,452.00,0.00,1500.90,588352.80,627635.64,39282.84,623898),('1','176','216879','409',392.00,452.00,0.00,0.00,0.00,0.00,0.00,624145),('1','176','217018','409',392.00,480.00,0.00,906.02,389519.62,402889.60,13369.98,624511),('1','176','217271','409',431.00,480.00,0.00,3588.85,1546794.35,1584849.20,38054.85,625179),('1','176','217506','409',431.00,480.00,0.00,547.81,236106.11,242336.40,6230.29,625792),('1','176','217530','409',431.00,480.00,0.00,0.00,0.00,0.00,0.00,625845),('1','176','217608','409',392.00,480.00,0.00,1659.26,650429.92,733441.20,83011.28,626052),('1','176','217705','409',392.00,480.00,0.00,3294.58,1291475.36,1454674.40,163199.04,626313),('1','176','217979','409',392.00,480.00,0.00,318.82,124977.44,141439.20,16461.76,627032),('1','176','218091','409',392.00,480.00,0.00,0.00,0.00,0.00,0.00,627321),('1','176','218096','409',392.00,480.00,0.00,1432.23,561434.16,633356.00,71921.84,627331),('1','176','218214','409',392.00,480.00,0.00,2811.78,1102217.76,1244093.20,141875.44,627651),('1','176','218453','409',392.00,480.00,0.00,859.79,337037.68,379499.20,42461.52,628274),('1','176','218543','409',392.00,480.00,0.00,0.00,0.00,0.00,0.00,628511),('1','176','218544','409',392.00,480.00,0.00,1673.80,656129.60,740455.20,84325.60,628512),('1','176','218672','409',392.00,480.00,0.00,3517.73,1378950.16,1553237.20,174287.04,628851),('1','176','218821','409',392.00,480.00,0.00,0.00,0.00,0.00,0.00,629230),('1','176','219030','409',392.00,480.00,0.00,2375.99,931388.08,1046918.80,115530.72,629777),('1','176','219112','409',392.00,480.00,0.00,2931.60,1149187.20,1292974.80,143787.60,629995),('1','176','219295','409',392.00,480.00,0.00,0.00,0.00,0.00,0.00,630482),('1','176','219326','409',421.00,480.00,0.00,3774.12,1588904.52,1666132.80,77228.28,630558),('1','176','219591','409',421.00,480.00,0.00,1225.89,516099.69,540350.00,24250.31,631249),('1','176','219673','409',421.00,480.00,0.00,2585.21,1088373.41,1139825.20,51451.79,631459),('1','176','219806','409',421.00,480.00,0.00,2414.79,1016626.59,1067620.80,50994.21,631815),('1','176','219969','409',421.00,480.00,0.00,1033.78,435221.38,457571.60,22350.22,632261),('1','176','220035','409',421.00,480.00,0.00,1597.75,672652.75,704976.80,32324.05,632433),('1','176','220107','409',392.00,480.00,0.00,1640.14,642934.88,713960.64,71025.76,632613),('1','176','220241','409',392.00,480.00,0.00,728.33,285505.36,314638.56,29133.20,632970),('1','176','220271','409',421.00,480.00,0.00,1912.49,805158.29,835219.20,30060.91,633034),('1','176','220458','409',421.00,480.00,0.00,3087.51,1299841.71,1343054.40,43212.69,633543),('1','176','220635','409',421.00,480.00,0.00,475.86,200337.06,206271.36,5934.30,633999),('1','176','220678','409',421.00,480.00,0.00,4013.95,1689872.95,1744785.12,54912.17,634112),('1','176','220843','409',421.00,480.00,0.00,0.00,0.00,0.00,0.00,634541),('1','176','220847','409',421.00,480.00,0.00,420.40,176988.40,181612.80,4624.40,634551),('1','176','220906','409',421.00,480.00,0.00,4579.84,1928112.64,1988849.28,60736.64,634704),('1','176','221096','409',421.00,480.00,0.00,618.00,260178.00,266976.00,6798.00,635203),('1','176','221150','409',421.00,480.00,0.00,4382.00,1844822.00,1901897.76,57075.76,635326),('1','176','221330','409',421.00,480.00,0.00,163.55,68854.55,71923.68,3069.13,635817),('1','176','221397','409',421.00,480.00,0.00,3429.37,1443764.77,1489068.48,45303.71,635976),('1','176','221623','409',421.00,480.00,0.00,1407.08,592380.68,608774.40,16393.72,636566),('1','176','221640','409',421.00,480.00,0.00,5000.00,2105000.00,2172080.16,67080.16,636605),('1','176','221750','409',421.00,480.00,0.00,1995.37,840050.77,864595.68,24544.91,636907),('1','176','221834','409',421.00,480.00,0.00,2502.80,1053678.80,1085145.60,31466.80,637120),('1','176','221974','409',421.00,480.00,0.00,0.00,0.00,0.00,0.00,637486),('1','176','221978','409',431.00,480.00,0.00,2471.76,1065328.56,1074690.24,9361.68,637496),('1','176','222057','409',431.00,480.00,0.00,2554.79,1101114.49,1110275.04,9160.55,637704),('1','176','222133','409',431.00,480.00,0.00,0.00,0.00,0.00,0.00,637893),('1','176','222156','409',431.00,480.00,0.00,2935.16,1265053.96,1274554.08,9500.12,637951),('1','176','222323','409',431.00,480.00,0.00,661.68,285184.08,298646.40,13462.32,638374),('1','176','222492','409',431.00,480.00,0.00,598.88,258117.28,271409.76,13292.48,638812),('1','176','222728','409',431.00,480.00,0.00,280.13,120736.03,134462.40,13726.37,639437),('1','176','223175','409',431.00,480.00,0.00,230.31,99263.61,110548.80,11285.19,640618),('1','176','223177','409',431.00,480.00,0.00,0.00,0.00,0.00,0.00,640622),('1','176','223178','409',424.00,480.00,0.00,1174.98,498191.52,520142.40,21950.88,640623),('1','176','223421','409',424.00,480.00,0.00,303.55,128705.20,136104.00,7398.80,641219),('1','176','223520','409',464.00,512.00,0.00,376.76,174816.64,180559.36,5742.72,641461),('1','176','223638','409',464.00,512.00,0.00,2423.51,1124508.64,1135922.08,11413.44,641775),('1','176','223818','409',464.00,512.00,0.00,0.00,0.00,0.00,0.00,642240),('1','176','223829','409',459.00,512.00,0.00,688.11,315842.49,319283.04,3440.55,642269),('1','176','223864','409',459.00,512.00,0.00,2531.00,1161729.00,1187300.80,25571.80,642361),('1','176','224075','409',459.00,512.00,0.00,1865.89,856443.51,870810.08,14366.57,642909),('1','176','224170','409',459.00,512.00,0.00,0.00,0.00,0.00,0.00,643140),('1','176','224190','409',459.00,512.00,0.00,2564.10,1176921.90,1195349.76,18427.86,643192),('1','176','224302','409',459.00,512.00,0.00,1800.40,826383.60,886890.14,60506.54,643495),('1','176','224521','409',459.00,512.00,0.00,552.84,253753.56,271978.62,18225.06,644081),('1','176','224668','409',459.00,512.00,0.00,0.00,0.00,0.00,0.00,644453),('1','176','224702','409',459.00,512.00,0.00,721.31,331081.29,354947.36,23866.07,644543),('1','176','224781','409',459.00,512.00,0.00,1651.47,758024.73,811861.84,53837.11,644730),('1','176','224891','409',459.00,512.00,0.00,1103.85,506667.15,538277.20,31610.05,645017),('1','176','225014','409',459.00,512.00,0.00,1663.21,763413.39,806899.32,43485.93,645331),('1','176','225121','409',459.00,512.00,0.00,0.00,0.00,0.00,0.00,645614),('1','176','225138','409',459.00,512.00,0.00,2202.90,1011131.10,1068943.40,57812.30,645657),('1','176','225270','409',459.00,512.00,0.00,2993.18,1373869.62,1453388.28,79518.66,645990),('1','176','225427','409',459.00,512.00,0.00,0.00,0.00,0.00,0.00,646405),('1','176','225475','409',459.00,512.00,0.00,3213.69,1475083.71,1560863.28,85779.57,646529),('1','176','225689','409',459.00,512.00,0.00,2057.01,944167.59,996631.92,52464.33,647079),('1','176','225803','409',459.00,512.00,0.00,0.00,0.00,0.00,0.00,647377),('1','176','225809','409',475.00,544.00,0.00,2196.96,1043556.00,1081973.38,38417.38,647390),('1','176','225965','409',475.00,544.00,0.00,3227.14,1532891.50,1595733.88,62842.38,647803),('1','176','226186','409',475.00,544.00,0.00,0.00,0.00,0.00,0.00,648383),('1','176','226234','409',475.00,544.00,0.00,3820.18,1814585.50,1883527.90,68942.40,648499),('1','176','226468','409',475.00,544.00,0.00,1444.15,685971.25,711097.60,25126.35,649101),('1','176','226557','409',475.00,544.00,0.00,0.00,0.00,0.00,0.00,649315),('1','176','226736','409',475.00,544.00,0.00,4227.00,2007825.00,2082236.28,74411.28,649785),('1','176','226948','409',475.00,544.00,0.00,1034.79,491525.25,508049.88,16524.63,650348),('1','176','227016','409',475.00,544.00,0.00,0.00,0.00,0.00,0.00,650518),('1','176','227021','409',486.00,544.00,0.00,4664.06,2266733.16,2296976.72,30243.56,650531),('1','176','227182','409',486.00,544.00,0.00,585.03,284324.58,290971.20,6646.62,650952),('1','176','227223','409',486.00,544.00,0.00,0.00,0.00,0.00,0.00,651048),('1','176','227271','409',486.00,544.00,0.00,2983.06,1449767.16,1469953.30,20186.14,651177),('1','176','227360','409',486.00,544.00,0.00,2289.12,1112512.32,1125988.80,13476.48,651412),('1','176','227532','409',486.00,544.00,0.00,0.00,0.00,0.00,0.00,651853),('1','176','227538','409',486.00,544.00,0.00,1248.22,606634.92,614069.68,7434.76,651869),('1','176','227598','409',484.00,544.00,0.00,3188.98,1543466.32,1571979.46,28513.14,652025),('1','176','227835','409',484.00,544.00,0.00,484.96,234720.64,261118.24,26397.60,652643),('1','176','228037','409',484.00,544.00,0.00,0.00,0.00,0.00,0.00,653174),('1','176','228349','409',486.00,544.00,0.00,1754.62,852745.32,904175.84,51430.52,653981),('1','176','228533','409',486.00,560.00,0.00,2866.62,1393177.32,1480949.76,87772.44,654444),('1','176','228751','409',486.00,560.00,0.00,494.64,240395.04,254421.60,14026.56,655007),('1','176','228768','409',486.00,560.00,0.00,0.00,0.00,0.00,0.00,655043),('1','176','228862','409',486.00,560.00,0.00,1974.51,959611.86,1019630.88,60019.02,655285),('1','176','228944','409',486.00,560.00,0.00,3071.90,1492943.40,1585412.32,92468.92,655492),('1','176','229086','409',486.00,560.00,0.00,0.00,0.00,0.00,0.00,655871),('1','176','229098','409',486.00,560.00,0.00,467.77,227336.22,242096.96,14760.74,655905),('1','176','229162','409',486.00,560.00,0.00,4912.10,2387280.60,2526527.68,139247.08,656081),('1','176','229289','409',486.00,560.00,0.00,0.00,0.00,0.00,0.00,656396),('1','176','229409','409',486.00,584.00,0.00,4104.11,1994597.46,2194646.60,200049.14,656711),('1','176','229659','409',486.00,584.00,0.00,1207.07,586636.02,645282.28,58646.26,657349),('1','176','229765','409',486.00,584.00,0.00,0.00,0.00,0.00,0.00,657610),('1','176','229890','409',486.00,584.00,0.00,272.17,143161.42,158947.28,15785.86,657938),('1','176','230091','409',526.00,584.00,0.00,1164.72,612642.72,636405.20,23762.48,658455),('1','176','230285','409',526.00,584.00,0.00,552.32,290520.32,309096.76,18576.44,658954),('1','176','230529','409',526.00,584.00,0.00,1062.52,558885.52,577756.76,18871.24,659590),('1','176','230773','409',526.00,584.00,0.00,1223.97,643808.22,664351.72,20543.50,660231),('1','176','231054','409',526.00,584.00,0.00,1052.66,553699.16,574739.44,21040.28,660980),('1','176','231329','409',526.00,584.00,0.00,0.00,0.00,0.00,0.00,661723),('1','176','231388','409',526.00,584.00,0.00,238.64,125524.64,139365.76,13841.12,661855),('1','176','231630','409',526.00,584.00,0.00,388.46,204329.96,226860.64,22530.68,662499),('1','176','231879','409',526.00,584.00,0.00,340.27,178982.02,198717.68,19735.66,663181),('1','176','232101','409',526.00,584.00,0.00,353.36,185867.36,206362.24,20494.88,663764),('1','176','232328','409',526.00,584.00,0.00,118.74,62457.24,69344.16,6886.92,664344),('1','176','232458','409',526.00,584.00,0.00,1927.66,936842.76,1082337.44,145494.68,664688),('1','176','232580','409',486.00,584.00,0.00,1857.37,902681.82,1045834.00,143152.18,665020),('1','176','232695','409',486.00,600.00,0.00,0.00,0.00,0.00,0.00,665313),('1','176','232696','409',486.00,600.00,0.00,2056.83,1123029.18,1157671.20,34642.02,665314),('1','176','232833','409',546.00,600.00,0.00,3118.69,1702804.74,1752892.80,50088.06,665692),('1','176','233029','409',546.00,600.00,0.00,0.00,0.00,0.00,0.00,666204),('1','176','233041','409',546.00,600.00,0.00,522.27,285159.42,293797.60,8638.18,666236),('1','176','233097','409',546.00,600.00,0.00,4691.83,2561739.18,2637658.00,75918.82,666383),('1','176','233317','409',546.00,600.00,0.00,0.00,0.00,0.00,0.00,666959),('1','176','233397','409',570.00,624.00,0.00,885.50,505117.00,524123.54,19006.54,667157),('1','176','233614','409',570.00,624.00,0.00,774.15,441265.50,461922.02,20656.52,667724),('1','176','233841','409',570.00,624.00,0.00,1945.10,1108707.00,1140645.64,31938.64,668323),('1','176','234034','409',570.00,624.00,0.00,1555.91,886868.70,902810.14,15941.44,668842),('1','176','234171','409',570.00,624.00,0.00,0.00,0.00,0.00,0.00,669194),('1','176','234240','409',570.00,624.00,0.00,666.64,379984.80,387104.10,7119.30,669384),('1','176','234302','409',546.00,624.00,0.00,2586.57,1412267.22,1508222.90,95955.68,669548),('1','176','234573','409',546.00,624.00,0.00,2070.59,1130542.14,1202701.90,72159.76,670261),('1','176','234687','409',546.00,624.00,0.00,0.00,0.00,0.00,0.00,670561),('1','176','234698','409',546.00,624.00,0.00,2101.14,1147222.44,1221381.46,74159.02,670588),('1','176','234807','409',546.00,624.00,0.00,2696.63,1472359.98,1568612.06,96252.08,670891),('1','176','235060','409',546.00,624.00,0.00,164.33,89724.18,94982.74,5258.56,671574),('1','176','235077','409',546.00,624.00,0.00,0.00,0.00,0.00,0.00,671613),('1','176','235136','409',546.00,624.00,0.00,2674.27,1460151.42,1554261.06,94109.64,671757),('1','176','235288','409',546.00,624.00,0.00,2620.42,1430749.32,1523844.62,93095.30,672162),('1','176','235448','409',546.00,624.00,0.00,0.00,0.00,0.00,0.00,672577),('1','176','235456','409',546.00,624.00,0.00,1752.52,956875.92,1014777.70,57901.78,672596),('1','176','235512','409',546.00,624.00,0.00,2494.20,1361833.20,1450666.36,88833.16,672740),('1','176','235743','409',600.00,640.00,0.00,1200.67,720402.00,722402.00,2000.00,673336),('1','176','235831','409',600.00,640.00,0.00,0.00,0.00,0.00,0.00,673553),('1','176','235861','409',546.00,640.00,0.00,2968.10,1620582.60,1786164.00,165581.40,673635),('1','176','236001','409',546.00,640.00,0.00,2252.46,1229843.16,1355154.40,125311.24,674022),('1','176','236128','409',546.00,640.00,0.00,0.00,0.00,0.00,0.00,674343),('1','176','236130','409',592.00,640.00,0.00,2524.95,1494770.40,1521782.00,27011.60,674347),('1','176','236228','409',592.00,640.00,0.00,2411.82,1427797.44,1451491.20,23693.76,674617),('1','176','236404','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,675085),('1','176','236511','409',592.00,640.00,0.00,4375.31,2590183.52,2634851.60,44668.08,675361),('1','176','236724','409',592.00,640.00,0.00,966.57,572209.44,583524.80,11315.36,675907),('1','176','236803','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,676104),('1','176','236857','409',592.00,640.00,0.00,1779.38,1053392.96,1071881.20,18488.24,676253),('1','176','236950','409',592.00,640.00,0.00,3640.91,2155418.72,2190560.40,35141.68,676495),('1','176','237108','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,676902),('1','176','237110','409',592.00,640.00,0.00,777.77,460439.84,469406.00,8966.16,676906),('1','176','237170','409',592.00,640.00,0.00,2611.80,1546185.60,1573662.00,27476.40,677051),('1','176','237378','409',592.00,640.00,0.00,1755.93,1039510.56,1056352.00,16841.44,677587),('1','176','237477','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,677847),('1','176','237486','409',592.00,640.00,0.00,2800.66,1657990.72,1686609.60,28618.88,677870),('1','176','237606','409',592.00,656.00,0.00,1516.94,898028.48,949587.76,51559.28,678183),('1','176','237871','409',592.00,656.00,0.00,964.50,570984.00,588238.72,17254.72,678876),('1','176','237952','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,679076),('1','176','237967','409',592.00,640.00,0.00,2504.82,1482853.44,1527472.64,44619.20,679117),('1','176','238109','409',592.00,640.00,0.00,2761.79,1634979.68,1683884.16,48904.48,679499),('1','176','238267','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,679898),('1','176','238269','409',592.00,640.00,0.00,1793.49,1079680.98,1092162.56,12481.58,679902),('1','176','238346','409',602.00,640.00,0.00,3260.01,1962526.02,1986226.88,23700.86,680099),('1','176','238535','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,680610),('1','176','238538','409',602.00,640.00,0.00,447.06,269130.12,273222.72,4092.60,680617),('1','176','238598','409',602.00,640.00,0.00,4854.24,2922252.48,2958168.64,35916.16,680767),('1','176','238761','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,681180),('1','176','238763','409',602.00,640.00,0.00,945.82,569383.64,575951.36,6567.72,681184),('1','176','238831','409',602.00,640.00,0.00,2864.11,1724194.22,1749258.88,25064.66,681359),('1','176','239062','409',602.00,640.00,0.00,1316.26,792388.52,802360.96,9972.44,681955),('1','176','239160','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,682216),('1','176','239165','409',602.00,640.00,0.00,4093.07,2464028.14,2496954.88,32926.74,682229),('1','176','239287','409',602.00,640.00,0.00,1151.86,693419.72,700972.48,7552.76,682552),('1','176','239412','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,682876),('1','176','239417','409',602.00,640.00,0.00,2284.62,1375341.24,1392226.56,16885.32,682890),('1','176','239524','409',602.00,640.00,0.00,3109.92,1872171.84,1893605.12,21433.28,683169),('1','176','239679','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,683572),('1','176','239683','409',602.00,640.00,0.00,791.11,476248.22,483540.80,7292.58,683580),('1','176','239767','409',602.00,640.00,0.00,1254.67,755311.34,764715.20,9403.86,683801),('1','176','239845','409',602.00,640.00,0.00,2503.01,1506812.02,1555288.20,48476.18,683997),('1','176','239934','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,684238),('1','176','240025','409',602.00,640.00,0.00,2886.48,1737660.96,1792751.00,55090.04,684452),('1','176','240200','409',602.00,640.00,0.00,2359.38,1420346.76,1467420.80,47074.04,684919),('1','176','240368','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,685356),('1','176','240451','409',602.00,640.00,0.00,3778.70,2274777.40,2351375.00,76597.60,685571),('1','176','240674','409',602.00,640.00,0.00,1467.58,883483.16,911454.40,27971.24,686120),('1','176','240768','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,686346),('1','176','240795','409',602.00,640.00,0.00,1578.51,950263.02,984071.20,33808.18,686414),('1','176','240959','409',602.00,640.00,0.00,2613.86,1573543.72,1624010.80,50467.08,686881),('1','176','241102','409',602.00,640.00,0.00,844.11,508154.22,518602.24,10448.02,687244),('1','176','241221','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,687560),('1','176','241234','409',602.00,640.00,0.00,4607.53,2773733.06,2808348.48,34615.42,687585),('1','176','241493','409',602.00,640.00,0.00,394.33,237386.66,240502.72,3116.06,688283),('1','176','241562','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,688462),('1','176','241563','409',602.00,640.00,0.00,3256.62,1927919.04,1984470.72,56551.68,688463),('1','176','241733','409',592.00,640.00,0.00,1958.30,1159313.60,1192102.40,32788.80,688915),('1','176','241841','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,689193),('1','176','241978','409',592.00,640.00,0.00,4730.50,2847350.80,2884814.08,37463.28,689557),('1','176','242209','409',602.00,640.00,0.00,662.87,399047.74,403564.80,4517.06,690155),('1','176','242282','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,690335),('1','176','242299','409',602.00,640.00,0.00,2355.26,1417866.52,1437606.40,19739.88,690375),('1','176','242422','409',602.00,640.00,0.00,2886.65,1737763.30,1760768.64,23005.34,690701),('1','176','242565','409',602.00,640.00,0.00,0.00,0.00,0.00,0.00,691073),('1','176','242568','409',602.00,640.00,0.00,1315.81,792117.62,803720.96,11603.34,691080),('1','176','242662','409',602.00,640.00,0.00,3684.19,2217882.38,2246810.24,28927.86,691328),('1','176','242857','409',602.00,640.00,0.00,346.02,208304.04,210380.16,2076.12,691840),('1','176','242919','409',600.00,640.00,0.00,2624.35,1574610.00,1582668.80,8058.80,691998),('1','176','243133','409',600.00,640.00,0.00,2029.63,1217778.00,1219002.00,1224.00,692563),('1','176','243203','409',582.00,640.00,0.00,2727.94,1587661.08,1644683.60,57022.52,692731),('1','176','243356','409',582.00,640.00,0.00,2272.06,1322338.92,1365578.40,43239.48,693157),('1','176','243476','409',582.00,640.00,0.00,1304.65,759306.30,789008.80,29702.50,693447),('1','176','243582','409',582.00,640.00,0.00,3695.35,2150693.70,2227078.40,76384.70,693732),('1','176','243751','409',582.00,640.00,0.00,442.50,257535.00,265500.00,7965.00,694164),('1','176','243832','409',582.00,640.00,0.00,3426.27,1994089.14,2068601.20,74512.06,694369),('1','176','244044','409',582.00,640.00,0.00,777.83,452697.06,466698.00,14000.94,694916),('1','176','244113','409',582.00,640.00,0.00,0.00,0.00,0.00,0.00,695086),('1','176','244124','409',592.00,640.00,0.00,3945.99,2336026.08,2379762.80,43736.72,695117),('1','176','244273','409',592.00,640.00,0.00,1371.13,811708.96,825103.20,13394.24,695524),('1','176','244368','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,695759),('1','176','244386','409',592.00,640.00,0.00,2213.61,1310457.12,1334536.80,24079.68,695803),('1','176','244511','409',592.00,640.00,0.00,2921.56,1729563.52,1759518.40,29954.88,696135),('1','176','244665','409',592.00,640.00,0.00,0.00,0.00,0.00,0.00,696542),('1','176','244672','409',592.00,640.00,0.00,597.89,353950.88,360129.20,6178.32,696559),('1','176','244733','409',592.00,640.00,0.00,3616.57,2141009.44,2179818.40,38808.96,696720),('1','176','244968','409',592.00,640.00,0.00,1118.65,657766.20,660095.12,2328.92,697329),('1','176','245082','409',588.00,632.00,0.00,0.00,0.00,0.00,0.00,697613),('1','176','245103','409',572.00,632.00,0.00,1800.84,1030080.48,1063293.92,33213.44,697666),('1','176','245206','409',572.00,632.00,0.00,3635.73,2079637.56,2146809.00,67171.44,697942),('1','176','245359','409',572.00,632.00,0.00,0.00,0.00,0.00,0.00,698332),('1','176','245429','409',572.00,632.00,0.00,3700.91,2153929.62,2185726.64,31797.02,698516),('1','176','245666','409',582.00,632.00,0.00,1204.90,701251.80,710256.16,9004.36,699131),('1','176','245773','409',582.00,632.00,0.00,0.00,0.00,0.00,0.00,699388),('1','176','245776','409',582.00,632.00,0.00,3285.13,1879094.36,1945615.00,66520.64,699395),('1','176','245938','409',572.00,632.00,0.00,2020.49,1155720.28,1191069.60,35349.32,699834),('1','176','246067','409',572.00,632.00,0.00,0.00,0.00,0.00,0.00,700169),('1','176','246072','409',572.00,632.00,0.00,1274.42,711126.36,726896.84,15770.48,700181),('1','176','246179','409',558.00,616.00,0.00,3230.66,1802708.28,1827332.80,24624.52,700459),('1','176','246370','409',558.00,616.00,0.00,0.00,0.00,0.00,0.00,700972),('1','176','246379','409',558.00,616.00,0.00,1025.20,572061.60,580500.28,8438.68,700997),('1','176','246444','409',558.00,616.00,0.00,4104.98,2290578.84,2329434.36,38855.52,701162),('1','176','246640','409',558.00,616.00,0.00,0.00,0.00,0.00,0.00,701681),('1','176','246725','409',558.00,616.00,0.00,4631.74,2584510.92,2625768.32,41257.40,701882),('1','176','246925','409',558.00,616.00,0.00,574.56,320604.48,324051.84,3447.36,702412),('1','176','247005','409',558.00,616.00,0.00,0.00,0.00,0.00,0.00,702592),('1','176','247011','409',558.00,616.00,0.00,3524.97,1966933.26,1999593.80,32660.54,702605),('1','176','247163','409',558.00,616.00,0.00,1648.01,919589.58,936303.16,16713.58,703027),('1','176','247263','409',558.00,616.00,0.00,0.00,0.00,0.00,0.00,703269),('1','176','247264','409',558.00,616.00,0.00,2046.47,1141930.26,1163452.08,21521.82,703270),('1','176','247395','409',558.00,616.00,0.00,3076.11,1716469.38,1738594.12,22124.74,703610),('1','176','247587','409',558.00,616.00,0.00,0.00,0.00,0.00,0.00,704119),('1','176','247588','409',558.00,616.00,0.00,1371.97,765559.26,773791.08,8231.82,704120),('1','176','247663','409',558.00,616.00,0.00,537.62,299991.96,307201.92,7209.96,704316),('1','176','247754','409',548.00,592.00,0.00,3370.65,1847116.20,1880464.56,33348.36,704524),('1','176','247827','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,704725),('1','176','247828','409',548.00,592.00,0.00,797.99,437298.52,446747.48,9448.96,704726),('1','176','247904','409',548.00,592.00,0.00,3944.58,2161629.84,2203032.48,41402.64,704938),('1','176','248079','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,705387),('1','176','248152','409',548.00,592.00,0.00,5207.03,2853452.44,2906859.80,53407.36,705576),('1','176','248398','409',548.00,592.00,0.00,89.50,49046.00,49762.00,716.00,706214),('1','176','248431','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,706282),('1','176','248435','409',548.00,592.00,0.00,5331.92,2921892.16,2975283.08,53390.92,706290),('1','176','248565','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,706637),('1','176','248663','409',548.00,592.00,0.00,5121.32,2806483.36,2859863.12,53379.76,706871),('1','176','248786','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,707204),('1','176','248800','409',548.00,592.00,0.00,892.63,489161.24,496302.28,7141.04,707243),('1','176','248857','409',548.00,592.00,0.00,1715.65,940176.20,955562.80,15386.60,707395),('1','176','248946','409',548.00,592.00,0.00,2731.36,1496785.28,1458424.30,-38360.98,707605),('1','176','249048','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,707891),('1','176','249139','409',548.00,592.00,0.00,3264.33,1788852.84,1738834.42,-50018.42,708090),('1','176','249329','409',548.00,592.00,0.00,1795.93,984169.64,957649.20,-26520.44,708607),('1','176','249482','409',548.00,592.00,0.00,0.00,0.00,0.00,0.00,708981),('1','176','249493','409',548.00,592.00,0.00,1119.77,571788.74,601511.44,29722.70,709012),('1','176','249577','409',510.00,592.00,0.00,4218.57,2151470.70,2247571.88,96101.18,709234),('1','176','249787','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,709780),('1','176','249841','409',510.00,592.00,0.00,4085.79,2083752.90,2181183.22,97430.32,709914),('1','176','250080','409',510.00,592.00,0.00,1290.38,658093.80,687232.04,29138.24,710529),('1','176','250179','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,710761),('1','176','250193','409',500.00,592.00,0.00,1812.39,906195.00,970472.44,64277.44,710801),('1','176','250321','409',500.00,592.00,0.00,3187.61,1593805.00,1708812.64,115007.64,711146),('1','176','250553','409',500.00,592.00,0.00,2258.70,1129350.00,1206830.12,77480.12,711730),('1','176','250781','409',500.00,592.00,0.00,2741.30,1370650.00,1462479.78,91829.78,712331),('1','176','250892','409',500.00,592.00,0.00,1708.25,854125.00,913169.00,59044.00,712587),('1','176','251014','409',500.00,592.00,0.00,3291.75,1645875.00,1756609.62,110734.62,712925),('1','176','251169','409',500.00,592.00,0.00,1827.48,913740.00,972199.46,58459.46,713314),('1','176','251263','409',500.00,592.00,0.00,2760.02,1380010.00,1479505.34,99495.34,713573),('1','176','251552','409',500.00,592.00,0.00,412.51,206255.00,218630.30,12375.30,714311),('1','176','251554','409',500.00,592.00,0.00,2762.42,1381210.00,1486076.48,104866.48,714313),('1','176','251791','409',500.00,592.00,0.00,1641.71,820855.00,872305.44,51450.44,714935),('1','176','251853','409',500.00,592.00,0.00,0.00,0.00,0.00,0.00,715101),('1','176','251858','409',500.00,592.00,0.00,2092.71,1046355.00,1122184.82,75829.82,715112),('1','176','252012','409',500.00,592.00,0.00,2907.29,1453645.00,1555514.30,101869.30,715516),('1','176','252156','409',500.00,592.00,0.00,1136.74,568370.00,604514.48,36144.48,715896),('1','176','252251','409',500.00,592.00,0.00,3863.26,1931630.00,2067029.90,135399.90,716147),('1','176','252379','409',500.00,592.00,0.00,390.92,195460.00,209172.22,13712.22,716486),('1','176','252510','409',500.00,592.00,0.00,4609.08,2304540.00,2456430.08,151890.08,716798),('1','176','252743','409',500.00,592.00,0.00,4006.52,2003260.00,2140410.74,137150.74,717414),('1','176','252987','409',500.00,592.00,0.00,993.48,496740.00,529272.40,32532.40,718048),('1','176','253015','409',500.00,592.00,0.00,2471.87,1235935.00,1325831.66,89896.66,718111),('1','176','253220','409',500.00,592.00,0.00,2081.33,1040665.00,1097633.84,56968.84,718668),('1','176','253370','409',500.00,592.00,0.00,0.00,0.00,0.00,0.00,719058),('1','176','253373','409',500.00,592.00,0.00,1493.16,761511.60,796204.20,34692.60,719065),('1','176','253464','409',510.00,592.00,0.00,3004.58,1532335.80,1585921.16,53585.36,719314),('1','176','253634','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,719745),('1','176','253714','409',510.00,592.00,0.00,5000.00,2500000.00,2638965.20,138965.20,719948),('1','176','253959','409',500.00,592.00,0.00,3417.64,1708820.00,1812266.76,103446.76,720583),('1','176','254197','409',500.00,592.00,0.00,1582.36,791180.00,834188.64,43008.64,721204),('1','176','254273','409',500.00,592.00,0.00,2017.41,1008705.00,1070111.52,61406.52,721390),('1','176','254439','409',500.00,592.00,0.00,2982.59,1491295.00,1568942.76,77647.76,721845),('1','176','254553','409',500.00,592.00,0.00,2536.40,1268200.00,1339848.20,71648.20,722107),('1','176','254703','409',500.00,592.00,0.00,2463.60,1231800.00,1302850.20,71050.20,722498),('1','176','254868','409',500.00,592.00,0.00,1588.98,794490.00,835439.36,40949.36,722922),('1','176','254950','409',500.00,592.00,0.00,3022.20,1511100.00,1590777.56,79677.56,723127),('1','176','255112','409',500.00,592.00,0.00,0.00,0.00,0.00,0.00,723546),('1','176','255115','409',500.00,592.00,0.00,1074.65,548071.50,570169.56,22098.06,723553),('1','176','255186','409',510.00,592.00,0.00,3465.92,1767619.20,1827353.24,59734.04,723746),('1','176','255464','409',510.00,592.00,0.00,562.24,286742.40,294613.76,7871.36,724429),('1','176','255539','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,724588),('1','176','255541','409',510.00,592.00,0.00,4189.86,2136828.60,2207605.60,70777.00,724590),('1','176','255713','409',510.00,592.00,0.00,989.25,504517.50,524110.28,19592.78,725044),('1','176','255868','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,725437),('1','176','255872','409',510.00,592.00,0.00,2713.30,1383783.00,1430866.92,47083.92,725445),('1','176','255937','409',510.00,592.00,0.00,2533.58,1292125.80,1336036.76,43910.96,725623),('1','176','256063','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,725924),('1','176','256096','409',510.00,592.00,0.00,2734.93,1394814.30,1442626.72,47812.42,726007),('1','176','256210','409',510.00,592.00,0.00,2350.53,1198770.30,1240018.60,41248.30,726286),('1','176','256337','409',510.00,592.00,0.00,0.00,0.00,0.00,0.00,726604),('1','176','256341','409',500.00,592.00,0.00,1470.59,735295.00,779051.08,43756.08,726614),('1','176','256470','409',500.00,592.00,0.00,1199.91,599955.00,634127.56,34172.56,726983),('1','176','256582','409',500.00,592.00,0.00,1854.43,927215.00,982912.72,55697.72,727244),('1','176','256715','409',500.00,592.00,0.00,475.07,237535.00,247036.40,9501.40,727602),('1','176','256769','409',500.00,592.00,0.00,3306.77,1653385.00,1741712.96,88327.96,727713),('1','176','256960','409',500.00,592.00,0.00,1718.06,859030.00,901564.64,42534.64,728248),('1','176','257078','409',500.00,592.00,0.00,914.01,457005.00,484200.24,27195.24,728534),('1','176','257235','409',500.00,592.00,0.00,4085.99,2042995.00,2142453.44,99458.44,728957),('1','176','257404','409',500.00,592.00,0.00,853.76,426880.00,447823.04,20943.04,729396),('1','176','257490','409',500.00,592.00,0.00,3243.25,1621625.00,1702853.68,81228.68,729628),('1','176','257491','409',500.00,568.00,0.00,902.99,451495.00,469554.80,18059.80,729629),('1','176','257492','409',500.00,568.00,0.00,3089.94,1544970.00,1621573.92,76603.92,729630),('1','176','257493','409',500.00,568.00,0.00,1422.36,711180.00,736671.78,25491.78,729631),('1','176','257494','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729632),('1','176','257495','409',500.00,568.00,0.00,2390.21,1195105.00,1238483.96,43378.96,729633),('1','176','257496','409',500.00,568.00,0.00,2821.54,1410770.00,1469016.58,58246.58,729634),('1','176','257497','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729635),('1','176','257498','409',500.00,568.00,0.00,4096.23,2048115.00,2119410.42,71295.42,729636),('1','176','257499','409',500.00,568.00,0.00,1063.47,531735.00,547758.66,16023.66,729637),('1','176','257500','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729638),('1','176','257501','409',500.00,568.00,0.00,1795.33,897665.00,933937.12,36272.12,729639),('1','176','257502','409',500.00,568.00,0.00,3486.66,1743330.00,1808241.72,64911.72,729640),('1','176','257503','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729641),('1','176','257504','409',500.00,568.00,0.00,1267.62,633810.00,651664.68,17854.68,729642),('1','176','257505','409',500.00,568.00,0.00,3665.22,1832610.00,1897518.66,64908.66,729643),('1','176','257506','409',500.00,568.00,0.00,37.50,18750.00,19275.00,525.00,729644),('1','176','257507','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729645),('1','176','257508','409',500.00,568.00,0.00,3579.81,1789905.00,1849535.52,59630.52,729646),('1','176','257509','409',500.00,568.00,0.00,1560.94,780470.00,803973.94,23503.94,729647),('1','176','257510','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729648),('1','176','257511','409',500.00,568.00,0.00,412.94,206470.00,212251.16,5781.16,729649),('1','176','257512','409',500.00,568.00,0.00,1245.24,622620.00,651558.60,28938.60,729650),('1','176','257513','409',500.00,568.00,0.00,3323.97,1661985.00,1717264.26,55279.26,729651),('1','176','257514','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729652),('1','176','257515','409',500.00,568.00,0.00,4967.68,2483840.00,2569163.62,85323.62,729653),('1','176','257516','409',500.00,568.00,0.00,172.32,86160.00,88572.48,2412.48,729654),('1','176','257517','409',500.00,568.00,0.00,4893.83,2446915.00,2529623.06,82708.06,729655),('1','176','257518','409',500.00,568.00,0.00,4094.71,2047355.00,2123079.28,75724.28,729656),('1','176','257519','409',500.00,568.00,0.00,983.42,491710.00,507941.90,16231.90,729657),('1','176','257520','409',500.00,568.00,0.00,1199.62,599810.00,623295.28,23485.28,729658),('1','176','257521','409',500.00,568.00,0.00,3787.41,1893705.00,1960699.62,66994.62,729659),('1','176','257522','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729660),('1','176','257523','409',500.00,568.00,0.00,4144.57,2072285.00,2143685.32,71400.32,729661),('1','176','257524','409',500.00,568.00,0.00,1117.15,558575.00,577323.34,18748.34,729662),('1','176','257525','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729663),('1','176','257526','409',500.00,568.00,0.00,1236.92,618460.00,638597.30,20137.30,729664),('1','176','257527','409',500.00,568.00,0.00,3671.84,1835920.00,1898802.38,62882.38,729665),('1','176','257528','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729666),('1','176','257529','409',500.00,568.00,0.00,4942.93,2471465.00,2560501.84,89036.84,729667),('1','176','257530','409',500.00,568.00,0.00,388.00,194000.00,199432.00,5432.00,729668),('1','176','257531','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729669),('1','176','257532','409',500.00,568.00,0.00,5394.10,2697050.00,2789699.98,92649.98,729670),('1','176','257533','409',500.00,568.00,0.00,48.40,24200.00,24877.60,677.60,729671),('1','176','257534','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729672),('1','176','257535','409',500.00,568.00,0.00,1892.36,946180.00,978591.44,32411.44,729673),('1','176','257536','409',500.00,568.00,0.00,2983.19,1491595.00,1542088.22,50493.22,729674),('1','176','257537','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729675),('1','176','257538','409',500.00,568.00,0.00,1049.37,524685.00,546362.16,21677.16,729676),('1','176','257539','409',500.00,568.00,0.00,4162.96,2081480.00,2151896.32,70416.32,729677),('1','176','257540','409',500.00,568.00,0.00,4264.47,2132235.00,2207464.20,75229.20,729678),('1','176','257541','409',500.00,568.00,0.00,896.51,448255.00,463183.76,14928.76,729679),('1','176','257542','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729680),('1','176','257543','409',500.00,568.00,0.00,4020.45,2010225.00,2082593.04,72368.04,729681),('1','176','257544','409',500.00,568.00,0.00,1144.95,572475.00,595569.66,23094.66,729682),('1','176','257545','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729683),('1','176','257546','409',500.00,568.00,0.00,2620.38,1310190.00,1355086.02,44896.02,729684),('1','176','257547','409',500.00,568.00,0.00,2448.34,1224170.00,1262133.34,37963.34,729685),('1','176','257548','409',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729686),('1','176','257549','409',500.00,568.00,0.00,3107.76,1553880.00,1608515.88,54635.88,729687),('1','176','257550','409',500.00,568.00,0.00,1892.20,946100.00,979824.64,33724.64,729688),('1','176','257551','409',490.00,568.00,0.00,2529.54,1239474.60,1308928.86,69454.26,729689),('1','176','257552','409',490.00,568.00,0.00,2554.50,1251705.00,1314928.92,63223.92,729690),('1','176','257553','409',490.00,568.00,0.00,2972.50,1456525.00,1534681.42,78156.42,729691),('1','176','257554','409',490.00,568.00,0.00,1943.46,952295.40,1056680.40,104385.00,729692),('1','176','257555','409',490.00,580.00,0.00,1466.34,718506.60,796568.00,78061.40,729693),('1','176','257556','409',490.00,580.00,0.00,3533.66,1731493.40,1913141.60,181648.20,729694),('1','176','257557','409',490.00,580.00,0.00,4964.94,2432820.60,2693564.40,260743.80,729695),('1','176','257558','409',522.00,580.00,0.00,5173.48,2700556.56,2810344.40,109787.84,729696),('1','176','257559','409',522.00,580.00,0.00,3340.03,1743495.66,1811798.60,68302.94,729697),('1','176','257560','409',522.00,580.00,0.00,1785.10,931822.20,966473.20,34651.00,729698),('1','176','257561','409',522.00,580.00,0.00,2233.98,1166137.56,1211735.20,45597.64,729699),('1','176','257562','409',522.00,580.00,0.00,512.25,267394.50,327840.00,60445.50,729700),('1','176','257563','409',522.00,640.00,0.00,604.99,315804.78,387193.60,71388.82,729701),('1','176','257564','409',522.00,640.00,0.00,315.81,164852.82,202118.40,37265.58,729702),('1','176','257565','409',522.00,640.00,0.00,591.14,308575.08,378329.60,69754.52,729703),('1','176','257566','409',522.00,640.00,0.00,728.02,380026.44,465932.80,85906.36,729704),('1','176','257567','409',522.00,640.00,0.00,669.08,349259.76,428211.20,78951.44,729705),('1','176','257568','409',522.00,640.00,0.00,1319.33,799513.98,847562.00,48048.02,729706),('1','176','257569','409',606.00,680.00,0.00,0.00,0.00,0.00,0.00,729707),('1','176','257570','409',606.00,680.00,0.00,394.94,239333.64,258740.40,19406.76,729708),('1','176','257571','409',606.00,680.00,0.00,1185.53,718431.18,770891.20,52460.02,729709),('1','176','257572','409',606.00,680.00,0.00,715.19,433405.14,468678.00,35272.86,729710),('1','176','257573','409',606.00,680.00,0.00,1832.13,1091949.48,1133003.52,41054.04,729711),('1','176','257574','409',596.00,680.00,0.00,595.55,354947.80,365111.20,10163.40,729712),('1','176','257575','409',596.00,680.00,0.00,2717.47,1619612.12,1664497.76,44885.64,729713),('1','176','257576','409',596.00,680.00,0.00,2440.97,1454818.12,1496007.04,41188.92,729714),('1','176','257577','409',596.00,680.00,0.00,0.00,0.00,0.00,0.00,729715),('1','176','257578','409',596.00,680.00,0.00,656.46,391250.16,404544.24,13294.08,729716),('1','176','257579','409',596.00,680.00,0.00,4294.95,2559790.20,2622846.72,63056.52,729717),('1','176','257580','409',596.00,680.00,0.00,0.00,0.00,0.00,0.00,729718),('1','176','257581','409',588.00,680.00,0.00,4969.99,2922354.12,3041910.32,119556.20,729719),('1','176','257582','409',588.00,680.00,0.00,3917.41,2303437.08,2395749.68,92312.60,729720),('1','176','257583','409',588.00,680.00,0.00,1110.57,653015.16,679461.60,26446.44,729721),('1','176','257584','409',588.00,680.00,0.00,3479.13,2045728.44,2132019.36,86290.92,729722),('1','176','257585','409',588.00,680.00,0.00,1520.87,894271.56,927816.64,33545.08,729723),('1','176','257586','409',588.00,680.00,0.00,1263.35,742849.80,777545.20,34695.40,729724),('1','176','257587','409',588.00,680.00,0.00,3736.64,2197144.32,2283042.88,85898.56,729725),('1','176','257588','409',588.00,680.00,0.00,1334.15,784480.20,816075.04,31594.84,729726),('1','176','257589','409',588.00,680.00,0.00,980.80,576710.40,605939.84,29229.44,729727),('1','176','257590','409',588.00,680.00,0.00,1589.07,934373.16,995657.12,61283.96,729728),('1','176','257591','409',588.00,688.00,0.00,0.00,0.00,0.00,0.00,729729),('1','176','257592','409',588.00,688.00,0.00,3679.86,2200556.28,2311227.20,110670.92,729730),('1','176','257593','409',598.00,688.00,0.00,1526.75,912996.50,959141.92,46145.42,729731),('1','176','257594','409',598.00,688.00,0.00,0.00,0.00,0.00,0.00,729732),('1','176','257595','409',598.00,688.00,0.00,1438.20,846011.60,903723.52,57711.92,729733),('1','176','257596','409',588.00,688.00,0.00,1300.46,764670.48,814407.36,49736.88,729734),('1','176','257597','409',588.00,688.00,0.00,2201.82,1294670.16,1375648.68,80978.52,729735),('1','176','257598','409',588.00,688.00,0.00,59.51,34991.88,36420.12,1428.24,729736),('1','176','257599','409',588.00,664.00,0.00,3074.57,1807847.16,1894124.12,86276.96,729737),('1','176','257600','409',588.00,664.00,0.00,1925.43,1132152.84,1184698.84,52546.00,729738),('1','176','257601','409',582.00,664.00,0.00,1736.21,1010474.22,1073028.12,62553.90,729739),('1','176','257602','409',582.00,664.00,0.00,3263.79,1899525.78,2005927.96,106402.18,729740),('1','176','257603','409',582.00,664.00,0.00,2506.25,1458637.50,1536843.60,78206.10,729741),('1','176','257604','409',582.00,664.00,0.00,2493.75,1451362.50,1531687.52,80325.02,729742),('1','176','257605','409',582.00,664.00,0.00,2373.96,1381644.72,1462401.36,80756.64,729743),('1','176','257606','409',582.00,664.00,0.00,2369.89,1379275.98,1455628.84,76352.86,729744),('1','176','257607','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729745),('1','176','257608','409',592.00,664.00,0.00,1106.47,655030.24,677159.64,22129.40,729746),('1','176','257609','409',592.00,664.00,0.00,2153.33,1274771.36,1324165.32,49393.96,729747),('1','176','257610','409',592.00,664.00,0.00,1722.69,1019832.48,1048123.91,28291.43,729748),('1','176','257611','409',592.00,664.00,0.00,344.46,203920.32,208398.30,4477.98,729749),('1','176','257612','409',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729750),('1','176','257613','409',592.00,664.00,0.00,4086.46,2419184.32,2490119.22,70934.90,729751),('1','176','257614','409',592.00,664.00,0.00,1377.01,815189.92,837180.34,21990.42,729752),('1','176','257615','409',592.00,664.00,0.00,3884.35,2299535.20,2363617.09,64081.89,729753),('1','176','257616','409',592.00,664.00,0.00,458.72,271562.24,304590.08,33027.84,729754),('1','176','257617','409',592.00,664.00,0.00,806.83,477643.36,535735.12,58091.76,729755),('1','176','257618','409',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729756),('1','176','257619','409',592.00,664.00,0.00,430.79,255027.68,286044.56,31016.88,729757),('1','176','257620','409',592.00,664.00,0.00,317.32,187853.44,210700.48,22847.04,729758),('1','176','257621','409',592.00,664.00,0.00,367.33,217459.36,243907.12,26447.76,729759),('1','176','257622','409',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729760),('1','176','257623','409',592.00,664.00,0.00,290.00,171680.00,192560.00,20880.00,729761),('1','176','257624','409',592.00,664.00,0.00,425.68,252002.56,282651.52,30648.96,729762),('1','176','257625','409',592.00,664.00,0.00,761.18,450618.56,505423.52,54804.96,729763),('1','176','257626','409',592.00,664.00,0.00,338.15,200184.80,224531.60,24346.80,729764),('1','176','257627','409',592.00,664.00,0.00,503.12,297847.04,334071.68,36224.64,729765),('1','176','257628','409',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729766),('1','176','257629','409',592.00,664.00,0.00,1688.27,992702.76,1014706.40,22003.64,729767),('1','176','257630','409',588.00,664.00,0.00,3075.32,1808288.16,1862246.96,53958.80,729768),('1','176','257631','409',588.00,664.00,0.00,269.03,158189.64,160879.94,2690.30,729769),('1','176','257632','409',588.00,664.00,0.00,3151.13,1789841.84,1903116.44,113274.60,729770),('1','176','257633','409',568.00,664.00,0.00,1847.87,1049590.16,1108087.34,58497.18,729771),('1','176','257634','409',582.00,664.00,0.00,1451.51,844778.82,876689.90,31911.08,729772),('1','176','257635','409',582.00,664.00,0.00,3549.49,2065803.18,2142932.92,77129.74,729773),('1','176','257636','409',582.00,664.00,0.00,782.69,455525.58,468048.62,12523.04,729774),('1','176','257637','409',582.00,664.00,0.00,2967.97,1727358.54,1799959.72,72601.18,729775),('1','176','257638','409',582.00,664.00,0.00,1249.34,727115.88,757974.20,30858.32,729776),('1','176','257639','409',582.00,664.00,0.00,3162.70,1840691.40,1895915.26,55223.86,729777),('1','176','257640','409',582.00,664.00,0.00,1837.30,1069308.60,1104102.88,34794.28,729778),('1','176','257641','409',582.00,664.00,0.00,1038.91,604645.62,632805.64,28160.02,729779),('1','176','257642','409',582.00,664.00,0.00,3850.93,2241241.26,2324988.58,83747.32,729780),('1','176','257643','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729781),('1','176','257644','409',582.00,664.00,0.00,596.27,347029.14,356569.46,9540.32,729782),('1','176','257645','409',582.00,664.00,0.00,3456.10,2011450.20,2084291.26,72841.06,729783),('1','176','257646','409',582.00,664.00,0.00,947.63,551520.66,570845.36,19324.70,729784),('1','176','257647','409',582.00,664.00,0.00,3245.75,1889026.50,1956219.68,67193.18,729785),('1','176','257648','409',582.00,664.00,0.00,1754.25,1020973.50,1063158.24,42184.74,729786),('1','176','257649','409',582.00,664.00,0.00,4893.81,2848197.42,2943342.24,95144.82,729787),('1','176','257650','409',582.00,664.00,0.00,106.19,61802.58,63501.62,1699.04,729788),('1','176','257651','409',582.00,664.00,0.00,2933.65,1707384.30,1771637.14,64252.84,729789),('1','176','257652','409',582.00,664.00,0.00,2066.35,1202615.70,1238788.54,36172.84,729790),('1','176','257653','409',582.00,664.00,0.00,1563.84,910154.88,939368.64,29213.76,729791),('1','176','257654','409',582.00,664.00,0.00,3186.97,1854816.54,1921780.72,66964.18,729792),('1','176','257655','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729793),('1','176','257656','409',582.00,664.00,0.00,4442.63,2585610.66,2668837.40,83226.74,729794),('1','176','257657','409',582.00,664.00,0.00,539.45,313959.90,324996.80,11036.90,729795),('1','176','257658','409',582.00,664.00,0.00,4453.37,2591861.34,2678325.62,86464.28,729796),('1','176','257659','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729797),('1','176','257660','409',582.00,664.00,0.00,3861.02,2247113.64,2320564.70,73451.06,729798),('1','176','257661','409',582.00,664.00,0.00,1191.44,693418.08,717250.94,23832.86,729799),('1','176','257662','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729800),('1','176','257663','409',582.00,664.00,0.00,1146.34,667169.88,690551.74,23381.86,729801),('1','176','257664','409',582.00,664.00,0.00,329.54,191792.28,218814.56,27022.28,729802),('1','176','257665','409',582.00,664.00,0.00,241.21,140384.22,160163.44,19779.22,729803),('1','176','257666','409',582.00,664.00,0.00,424.70,247175.40,282000.80,34825.40,729804),('1','176','257667','409',582.00,664.00,0.00,581.76,338584.32,386288.64,47704.32,729805),('1','176','257668','409',582.00,664.00,0.00,333.35,194009.70,221344.40,27334.70,729806),('1','176','257669','409',582.00,664.00,0.00,558.36,324965.52,370751.04,45785.52,729807),('1','176','257670','409',582.00,664.00,0.00,457.87,266480.34,304025.68,37545.34,729808),('1','176','257671','409',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729809),('1','176','257672','409',582.00,680.00,0.00,91.59,53878.58,62281.20,8402.62,729810),('1','176','257673','409',592.00,680.00,0.00,418.10,247515.20,284308.00,36792.80,729811),('1','176','257674','409',592.00,680.00,0.00,374.12,221479.04,254401.60,32922.56,729812),('1','176','257675','409',592.00,680.00,0.00,490.84,290577.28,333771.20,43193.92,729813),('1','176','257676','409',592.00,680.00,0.00,1062.49,628994.08,722493.20,93499.12,729814),('1','176','257677','409',592.00,680.00,0.00,640.89,379406.88,435805.20,56398.32,729815),('1','176','257678','409',592.00,680.00,0.00,449.98,266388.16,305986.40,39598.24,729816),('1','176','257679','409',592.00,680.00,0.00,300.00,177600.00,204000.00,26400.00,729817),('1','176','257680','409',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729818),('1','176','257681','409',592.00,680.00,0.00,1090.92,711279.84,742971.95,31692.11,729819),('1','176','257682','409',652.00,720.00,0.00,3823.13,2492680.76,2608068.68,115387.92,729820),('1','176','257683','409',652.00,720.00,0.00,225.74,147182.48,152825.98,5643.50,729821),('1','176','257684','409',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729822),('1','176','257685','409',652.00,720.00,0.00,2987.50,1947850.00,2037746.60,89896.60,729823),('1','176','257686','409',652.00,720.00,0.00,2258.02,1472229.04,1540437.46,68208.42,729824),('1','176','257687','409',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729825),('1','176','257688','409',652.00,720.00,0.00,2439.27,1590404.04,1664716.22,74312.18,729826),('1','176','257689','409',652.00,720.00,0.00,1935.28,1261802.56,1316453.53,54650.97,729827),('1','176','257690','409',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729828),('1','176','257691','409',652.00,720.00,0.00,235.00,153220.00,159095.00,5875.00,729829),('1','176','257692','409',652.00,720.00,0.00,3975.93,2592306.36,2805160.20,212853.84,729830),('1','176','257693','409',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729831),('1','176','257694','409',652.00,760.00,0.00,2223.03,1468677.16,1574256.60,105579.44,729832),('1','176','257695','409',672.00,760.00,0.00,2817.32,1893239.04,1992722.00,99482.96,729833),('1','176','257696','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729834),('1','176','257697','409',672.00,760.00,0.00,3277.06,2202184.32,2319195.40,117011.08,729835),('1','176','257698','409',672.00,760.00,0.00,746.91,501923.52,567651.60,65728.08,729836),('1','176','257699','409',672.00,760.00,0.00,603.32,405431.04,458523.20,53092.16,729837),('1','176','257700','409',672.00,760.00,0.00,497.55,334353.60,378138.00,43784.40,729838),('1','176','257701','409',672.00,760.00,0.00,235.37,158168.64,178881.20,20712.56,729839),('1','176','257702','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729840),('1','176','257703','409',672.00,760.00,0.00,285.80,192057.60,217208.00,25150.40,729841),('1','176','257704','409',672.00,760.00,0.00,798.09,536316.48,606548.40,70231.92,729842),('1','176','257705','409',672.00,760.00,0.00,2641.63,1775175.36,2007638.80,232463.44,729843),('1','176','257706','409',672.00,760.00,0.00,1443.29,969890.88,1096900.40,127009.52,729844),('1','176','257707','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729845),('1','176','257708','409',672.00,760.00,0.00,2373.31,1594864.32,1803715.60,208851.28,729846),('1','176','257709','409',672.00,760.00,0.00,1532.09,1029564.48,1164388.40,134823.92,729847),('1','176','257710','409',672.00,760.00,0.00,1332.69,895567.68,1012844.40,117276.72,729848),('1','176','257711','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729849),('1','176','257712','409',672.00,760.00,0.00,2527.83,1698701.76,1921150.80,222449.04,729850),('1','176','257713','409',672.00,760.00,0.00,1954.24,1313249.28,1485222.40,171973.12,729851),('1','176','257714','409',672.00,760.00,0.00,823.65,553492.80,625974.00,72481.20,729852),('1','176','257715','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729853),('1','176','257716','409',672.00,760.00,0.00,416.99,280217.28,316912.40,36695.12,729854),('1','176','257717','409',672.00,760.00,0.00,988.82,664487.04,751503.20,87016.16,729855),('1','176','257718','409',672.00,760.00,0.00,1035.35,695755.20,786866.00,91110.80,729856),('1','176','257719','409',672.00,760.00,0.00,891.23,598906.56,677334.80,78428.24,729857),('1','176','257720','409',672.00,760.00,0.00,856.74,575729.28,651122.40,75393.12,729858),('1','176','257721','409',672.00,760.00,0.00,947.21,636525.12,719879.60,83354.48,729859),('1','176','257722','409',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729860),('1','176','257723','409',682.00,760.00,0.00,1228.63,837925.66,933758.80,95833.14,729861),('1','176','257724','409',682.00,760.00,0.00,537.25,366404.50,408310.00,41905.50,729862),('1','176','257725','409',682.00,760.00,0.00,2071.48,1412749.36,1512104.00,99354.64,729863),('1','176','257726','409',682.00,760.00,0.00,1353.66,923196.12,979964.00,56767.88,729864),('1','176','257727','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729865),('1','176','257728','409',682.00,760.00,0.00,1581.38,1078501.16,1143546.00,65044.84,729866),('1','176','257729','409',682.00,760.00,0.00,3499.09,2386379.38,2533323.60,146944.22,729867),('1','176','257730','409',682.00,760.00,0.00,294.27,200692.14,211874.40,11182.26,729868),('1','176','257731','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729869),('1','176','257732','409',682.00,760.00,0.00,2179.81,1486630.42,1582248.00,95617.58,729870),('1','176','257733','409',682.00,760.00,0.00,3069.93,2093692.26,2223992.80,130300.54,729871),('1','176','257734','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729872),('1','176','257735','409',672.00,760.00,0.00,1443.53,970052.16,1047810.80,77758.64,729873),('1','176','257736','409',672.00,760.00,0.00,3337.05,2242497.60,2415942.40,173444.80,729874),('1','176','257737','409',672.00,760.00,0.00,216.63,145575.36,155973.60,10398.24,729875),('1','176','257738','409',672.00,760.00,0.00,5000.00,3360000.00,3611834.80,251834.80,729876),('1','176','257739','409',672.00,760.00,0.00,4441.11,2984425.92,3209986.80,225560.88,729877),('1','176','257740','409',672.00,760.00,0.00,558.88,375567.36,407403.60,31836.24,729878),('1','176','257741','409',682.00,760.00,0.00,1228.77,838021.14,894576.80,56555.66,729879),('1','176','257742','409',682.00,760.00,0.00,3238.67,2208772.94,2345214.40,136441.46,729880),('1','176','257743','409',682.00,760.00,0.00,532.56,363205.92,385779.60,22573.68,729881),('1','176','257744','409',682.00,760.00,0.00,3125.09,2131311.38,2264606.40,133295.02,729882),('1','176','257745','409',682.00,760.00,0.00,1077.77,735039.14,781235.20,46196.06,729883),('1','176','257746','409',682.00,760.00,0.00,236.75,161463.50,170460.00,8996.50,729884),('1','176','257747','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729885),('1','176','257748','409',682.00,760.00,0.00,2952.08,2013318.56,2129856.00,116537.44,729886),('1','176','257749','409',682.00,760.00,0.00,221.76,151240.32,168537.60,17297.28,729887),('1','176','257750','409',682.00,760.00,0.00,349.49,238352.18,265612.40,27260.22,729888),('1','176','257751','409',682.00,760.00,0.00,121.42,82808.44,92279.20,9470.76,729889),('1','176','257752','409',682.00,760.00,0.00,309.53,211099.46,235242.80,24143.34,729890),('1','176','257753','409',682.00,760.00,0.00,385.62,262992.84,293071.20,30078.36,729891),('1','176','257754','409',682.00,760.00,0.00,717.34,489225.88,545178.40,55952.52,729892),('1','176','257755','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729893),('1','176','257756','409',682.00,760.00,0.00,1046.53,713733.46,795362.80,81629.34,729894),('1','176','257757','409',682.00,760.00,0.00,937.85,639613.70,695992.80,56379.10,729895),('1','176','257758','409',682.00,760.00,0.00,1453.70,991423.40,1047355.52,55932.12,729896),('1','176','257759','409',682.00,760.00,0.00,1660.74,1132624.68,1192240.80,59616.12,729897),('1','176','257760','409',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729898),('1','176','257761','409',682.00,760.00,0.00,2216.76,1511830.32,1590823.68,78993.36,729899),('1','176','257762','409',682.00,760.00,0.00,1623.76,1107404.32,1167517.12,60112.80,729900),('1','176','257763','409',665.00,744.00,0.00,1340.91,891705.15,939062.44,47357.29,729901),('1','176','257764','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729902),('1','176','257765','409',665.00,744.00,0.00,2216.80,1511857.60,1554964.40,43106.80,729903),('1','176','257766','409',682.00,744.00,0.00,1879.78,1282009.96,1325598.75,43588.79,729904),('1','176','257767','409',682.00,744.00,0.00,903.43,616139.26,630630.30,14491.04,729905),('1','176','257768','409',682.00,744.00,0.00,2210.44,1507520.08,1545411.94,37891.86,729906),('1','176','257769','409',682.00,744.00,0.00,2506.82,1709651.24,1758675.97,49024.73,729907),('1','176','257770','409',682.00,744.00,0.00,282.74,192828.68,196504.30,3675.62,729908),('1','176','257771','409',682.00,744.00,0.00,2880.65,1964603.30,2018033.59,53430.29,729909),('1','176','257772','409',682.00,744.00,0.00,2119.35,1445396.70,1485553.50,40156.80,729910),('1','176','257773','409',682.00,744.00,0.00,839.34,572429.88,588325.09,15895.21,729911),('1','176','257774','409',682.00,744.00,0.00,3740.52,2551034.64,2609549.11,58514.47,729912),('1','176','257775','409',682.00,744.00,0.00,420.14,286535.48,291997.30,5461.82,729913),('1','176','257776','409',682.00,744.00,0.00,3143.76,2090600.40,2210802.35,120201.95,729914),('1','176','257777','409',665.00,744.00,0.00,1646.38,1094842.70,1150823.13,55980.43,729915),('1','176','257778','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729916),('1','176','257779','409',665.00,744.00,0.00,846.11,562663.15,598458.46,35795.31,729917),('1','176','257780','409',665.00,744.00,0.00,3102.50,2063162.50,2176229.01,113066.51,729918),('1','176','257781','409',665.00,744.00,0.00,1451.18,965034.70,1015811.81,50777.11,729919),('1','176','257782','409',665.00,744.00,0.00,527.86,351026.90,392727.84,41700.94,729920),('1','176','257783','409',665.00,744.00,0.00,3095.53,2058527.45,2179963.78,121436.33,729921),('1','176','257784','409',665.00,744.00,0.00,543.60,361494.00,382185.54,20691.54,729922),('1','176','257785','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729923),('1','176','257786','409',665.00,744.00,0.00,1363.02,906408.30,959794.88,53386.58,729924),('1','176','257787','409',665.00,744.00,0.00,3775.93,2510993.45,2651249.77,140256.32,729925),('1','176','257788','409',665.00,744.00,0.00,3209.25,2134151.25,2257804.07,123652.82,729926),('1','176','257789','409',665.00,760.00,0.00,723.67,481240.55,541979.20,60738.65,729927),('1','176','257790','409',665.00,760.00,0.00,582.47,387342.55,442677.20,55334.65,729928),('1','176','257791','409',665.00,760.00,0.00,443.46,294900.90,337029.60,42128.70,729929),('1','176','257792','409',665.00,760.00,0.00,518.76,344975.40,394257.60,49282.20,729930),('1','176','257793','409',665.00,760.00,0.00,405.49,269650.85,308172.40,38521.55,729931),('1','176','257794','409',665.00,760.00,0.00,579.09,385094.85,440108.40,55013.55,729932),('1','176','257795','409',665.00,760.00,0.00,627.77,417467.05,477105.20,59638.15,729933),('1','176','257796','409',665.00,760.00,0.00,235.34,156501.10,178858.40,22357.30,729934),('1','176','257797','409',665.00,760.00,0.00,2348.82,1561965.30,1683582.70,121617.40,729935),('1','176','257798','409',665.00,744.00,0.00,230.46,153255.90,167044.96,13789.06,729936),('1','176','257799','409',665.00,744.00,0.00,2281.49,1517190.85,1641732.14,124541.29,729937),('1','176','257800','409',665.00,744.00,0.00,1832.94,1218905.10,1311361.98,92456.88,729938),('1','176','257801','409',665.00,744.00,0.00,1342.65,892862.25,963559.70,70697.45,729939),('1','176','257802','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729940),('1','176','257803','409',665.00,744.00,0.00,2156.05,1433773.25,1558390.92,124617.67,729941),('1','176','257804','409',665.00,744.00,0.00,1925.13,1280211.45,1397705.46,117494.01,729942),('1','176','257805','409',665.00,744.00,0.00,1072.14,712973.10,767824.58,54851.48,729943),('1','176','257806','409',665.00,744.00,0.00,403.58,268380.70,291797.52,23416.82,729944),('1','176','257807','409',665.00,744.00,0.00,1653.87,1099823.55,1196156.62,96333.07,729945),('1','176','257808','409',665.00,744.00,0.00,1484.92,987471.80,1073806.48,86334.68,729946),('1','176','257809','409',665.00,744.00,0.00,1617.50,1075637.50,1160182.88,84545.38,729947),('1','176','257810','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729948),('1','176','257811','409',665.00,744.00,0.00,538.39,358029.35,398201.54,40172.19,729949),('1','176','257812','409',665.00,744.00,0.00,1202.51,799669.15,872091.44,72422.29,729950),('1','176','257813','409',665.00,744.00,0.00,1543.66,1026533.90,1112001.04,85467.14,729951),('1','176','257814','409',665.00,744.00,0.00,971.98,646366.70,704249.12,57882.42,729952),('1','176','257815','409',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729953),('1','176','257816','409',665.00,744.00,0.00,1086.41,722462.65,787787.04,65324.39,729954),('1','176','257817','409',665.00,744.00,0.00,1349.23,897237.95,986682.62,89444.67,729955),('1','176','257818','409',665.00,744.00,0.00,2354.19,1565536.35,1699570.80,134034.45,729956),('1','176','257819','409',665.00,744.00,0.00,1495.79,994700.35,1079289.36,84589.01,729957),('1','176','257820','409',665.00,744.00,0.00,1264.90,841158.50,917319.60,76161.10,729958),('1','176','257821','409',665.00,744.00,0.00,1135.54,755134.10,814961.76,59827.66,729959),('1','176','257822','409',665.00,744.00,0.00,1512.50,1005812.50,1081689.84,75877.34,729960),('1','176','257823','409',665.00,744.00,0.00,1017.24,676464.60,738994.24,62529.64,729961),('1','176','257824','409',665.00,744.00,0.00,544.12,361839.80,404825.28,42985.48,729962),('1','176','257825','409',665.00,744.00,0.00,474.97,315855.05,353377.68,37522.63,729963),('1','176','257826','409',665.00,744.00,0.00,669.64,445310.60,498212.16,52901.56,729964),('1','176','257827','409',665.00,744.00,0.00,743.22,494241.30,552955.68,58714.38,729965),('1','176','257828','409',665.00,744.00,0.00,639.94,425560.10,476115.36,50555.26,729966),('1','176','257829','409',665.00,744.00,0.00,666.10,442956.50,495578.40,52621.90,729967),('1','176','257830','409',665.00,744.00,0.00,576.93,383658.45,429235.92,45577.47,729968),('1','176','257831','409',665.00,744.00,0.00,358.64,238495.60,266828.16,28332.56,729969),('1','176','257832','409',665.00,744.00,0.00,7.80,5187.00,5803.20,616.20,729970),('1','176','257833','409',665.00,744.00,0.00,161.38,107317.70,120066.72,12749.02,729971),('1','176','257834','409',665.00,744.00,0.00,958.11,637143.15,712833.84,75690.69,729972),('1','176','257835','409',665.00,744.00,0.00,479.81,319073.65,356978.64,37904.99,729973),('1','176','257836','409',665.00,744.00,0.00,566.10,376456.50,421178.40,44721.90,729974),('1','176','257837','409',665.00,744.00,0.00,482.87,321108.55,356963.84,35855.29,729975),('1','176','257838','409',665.00,736.00,0.00,575.39,382634.35,423487.04,40852.69,729976),('1','176','257839','409',665.00,736.00,0.00,37.70,25070.50,27747.20,2676.70,729977),('1','176','257840','409',665.00,736.00,0.00,0.00,0.00,0.00,0.00,729978),('1','176','257841','409',665.00,736.00,0.00,716.89,473147.40,527631.04,54483.64,729979),('1','176','257842','409',660.00,736.00,0.00,1735.56,1145469.60,1277372.16,131902.56,729980),('1','176','257843','409',660.00,736.00,0.00,490.90,323994.00,361302.40,37308.40,729981),('1','176','257844','409',660.00,736.00,0.00,2186.14,1442852.40,1562191.48,119339.08,729982),('1','176','257845','409',660.00,736.00,0.00,296.98,196006.80,212997.28,16990.48,729983),('1','176','257846','409',660.00,736.00,0.00,1594.00,1052040.00,1129582.24,77542.24,729984),('1','176','257847','409',660.00,736.00,0.00,1097.01,724026.60,779571.36,55544.76,729985),('1','176','257848','409',660.00,736.00,0.00,992.12,654799.20,709932.32,55133.12,729986),('1','176','257849','409',660.00,736.00,0.00,1314.17,867352.20,933641.12,66288.92,729987),('1','176','257850','409',660.00,736.00,0.00,3030.63,2000215.80,2173670.52,173454.72,729988),('1','176','257851','409',660.00,736.00,0.00,1052.17,694432.20,774397.12,79964.92,729989),('1','176','257852','409',660.00,736.00,0.00,590.64,389822.40,434711.04,44888.64,729990),('1','176','257853','409',660.00,736.00,0.00,155.35,102531.00,114337.60,11806.60,729991),('1','176','257854','409',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729992),('1','176','257855','409',660.00,736.00,0.00,514.71,339708.60,378826.56,39117.96,729993),('1','176','257856','409',660.00,736.00,0.00,1983.94,1309400.40,1460179.84,150779.44,729994),('1','176','257857','409',660.00,764.00,0.00,1111.15,733359.00,848918.60,115559.60,729995),('1','176','257858','409',660.00,748.00,0.00,390.69,257855.40,292236.12,34380.72,729996),('1','176','257859','409',660.00,748.00,0.00,454.87,300214.20,340242.76,40028.56,729997),('1','176','257860','409',660.00,748.00,0.00,1026.79,677681.40,768038.92,90357.52,729998),('1','176','257861','409',660.00,748.00,0.00,3034.45,2002737.00,2269768.60,267031.60,729999),('1','176','257862','409',660.00,748.00,0.00,157.61,104022.60,117892.28,13869.68,730000),('1','176','257863','409',660.00,748.00,0.00,476.81,314694.60,356653.88,41959.28,730001),('1','176','257864','409',660.00,748.00,0.00,949.81,626874.60,710457.88,83583.28,730002),('1','176','257865','409',660.00,748.00,0.00,1275.89,842087.40,954365.72,112278.32,730003),('1','176','257866','409',660.00,760.00,0.00,927.80,612348.00,705128.00,92780.00,730004),('1','176','257867','409',660.00,760.00,0.00,1317.05,869253.00,1000958.00,131705.00,730005),('1','176','257868','409',660.00,760.00,0.00,764.27,504418.20,580845.20,76427.00,730006),('1','176','257869','409',660.00,760.00,0.00,1238.41,817350.60,941191.60,123841.00,730007),('1','176','257870','409',660.00,760.00,0.00,1134.52,748783.20,862235.20,113452.00,730008),('1','176','257871','409',660.00,760.00,0.00,746.35,492591.00,567226.00,74635.00,730009),('1','176','257872','409',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730010),('1','176','257873','409',660.00,760.00,0.00,930.12,613879.20,706891.20,93012.00,730011),('1','176','257874','409',660.00,800.00,0.00,516.83,341107.80,413464.00,72356.20,730012),('1','176','257875','409',660.00,800.00,0.00,639.77,422248.20,511816.00,89567.80,730013),('1','176','257876','409',660.00,800.00,0.00,639.96,422373.60,511968.00,89594.40,730014),('1','176','257877','409',660.00,760.00,0.00,643.74,424868.40,489242.40,64374.00,730015),('1','176','257878','409',660.00,760.00,0.00,765.24,505058.40,581582.40,76524.00,730016),('1','176','257879','409',660.00,760.00,0.00,919.98,607186.80,699184.80,91998.00,730017),('1','176','257880','409',660.00,760.00,0.00,645.14,425792.40,490306.40,64514.00,730018),('1','176','257881','409',660.00,760.00,0.00,706.05,465993.00,536598.00,70605.00,730019),('1','176','257882','409',660.00,760.00,0.00,569.23,375691.80,432614.80,56923.00,730020),('1','176','257883','409',660.00,760.00,0.00,693.95,458007.00,527402.00,69395.00,730021),('1','176','257884','409',660.00,760.00,0.00,321.93,212473.80,244666.80,32193.00,730022),('1','176','257885','409',660.00,760.00,0.00,487.74,321908.40,370682.40,48774.00,730023),('1','176','257886','409',660.00,760.00,0.00,360.70,238062.00,274132.00,36070.00,730024),('1','176','257887','409',660.00,760.00,0.00,625.07,412546.20,475053.20,62507.00,730025),('1','176','257888','409',660.00,760.00,0.00,944.72,623515.20,717987.20,94472.00,730026),('1','176','257889','409',660.00,760.00,0.00,278.80,184008.00,211888.00,27880.00,730027),('1','176','257890','409',660.00,760.00,0.00,414.20,273372.00,314792.00,41420.00,730028),('1','176','257891','409',660.00,760.00,0.00,381.18,251578.80,289696.80,38118.00,730029),('1','176','257892','409',660.00,760.00,0.00,487.03,321439.80,370142.80,48703.00,730030),('1','176','257893','409',660.00,760.00,0.00,447.25,295185.00,339910.00,44725.00,730031),('1','176','257894','409',660.00,760.00,0.00,1947.53,1288560.05,1421577.80,133017.75,730032),('1','176','257895','409',665.00,760.00,0.00,673.18,447664.70,499691.80,52027.10,730033),('1','176','257896','409',665.00,760.00,0.00,721.10,479531.50,535433.30,55901.80,730034),('1','176','257897','409',665.00,760.00,0.00,972.71,646852.15,721304.60,74452.45,730035),('1','176','257898','409',665.00,760.00,0.00,1220.37,811546.05,894902.55,83356.50,730036),('1','176','257899','409',665.00,760.00,0.00,997.69,663463.85,734259.40,70795.55,730037),('1','176','257900','409',665.00,760.00,0.00,660.61,439305.65,488966.35,49660.70,730038),('1','176','257901','409',675.00,760.00,0.00,153.98,103936.50,111774.80,7838.30,730039),('1','176','257902','409',675.00,760.00,0.00,2279.33,1538547.75,1650038.30,111490.55,730040),('1','176','257903','409',675.00,760.00,0.00,1661.63,1121600.25,1210736.80,89136.55,730041),('1','176','257904','409',675.00,760.00,0.00,1091.08,736479.00,782665.30,46186.30,730042),('1','176','257905','409',675.00,760.00,0.00,406.33,274272.75,294808.80,20536.05,730043),('1','176','257906','409',675.00,760.00,0.00,1615.34,1090354.50,1166898.40,76543.90,730044),('1','176','257907','409',675.00,760.00,0.00,1458.57,963406.20,1042591.20,79185.00,730045),('1','176','257908','409',660.00,760.00,0.00,1750.11,1155072.60,1255773.60,100701.00,730046),('1','176','257909','409',660.00,760.00,0.00,373.94,246800.40,264742.40,17942.00,730047),('1','176','257910','409',660.00,760.00,0.00,2072.01,1367526.60,1468201.80,100675.20,730048),('1','176','257911','409',660.00,760.00,0.00,2468.40,1629144.00,1756515.00,127371.00,730049),('1','176','257912','409',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730050),('1','176','257913','409',660.00,760.00,0.00,4104.38,2708890.80,2919645.80,210755.00,730051),('1','176','257914','409',660.00,760.00,0.00,879.73,580621.80,620133.40,39511.60,730052),('1','176','257915','409',660.00,760.00,0.00,585.94,386720.40,422220.40,35500.00,730053),('1','176','257916','409',660.00,760.00,0.00,2309.94,1524560.40,1656342.00,131781.60,730054),('1','176','257917','409',660.00,760.00,0.00,2462.78,1625434.80,1751154.20,125719.40,730055),('1','176','257918','409',660.00,760.00,0.00,1690.26,1115571.60,1203679.20,88107.60,730056),('1','176','257919','409',660.00,760.00,0.00,2031.38,1340710.80,1455323.60,114612.80,730057),('1','176','257920','409',660.00,760.00,0.00,1110.18,732718.80,793449.72,60730.92,730058),('1','176','257921','409',660.00,736.00,0.00,4186.06,2762799.60,2973593.56,210793.96,730059),('1','176','257922','409',660.00,736.00,0.00,743.94,491000.40,529251.84,38251.44,730060),('1','176','257923','409',660.00,736.00,0.00,3566.67,2354002.20,2553861.12,199858.92,730061),('1','176','257924','409',660.00,736.00,0.00,1716.59,1132949.40,1214162.24,81212.84,730062),('1','176','257925','409',660.00,736.00,0.00,1963.96,1296213.60,1396705.36,100491.76,730063),('1','176','257926','409',660.00,736.00,0.00,2556.23,1687111.80,1812415.04,125303.24,730064),('1','176','257927','409',660.00,736.00,0.00,247.07,163066.20,172949.00,9882.80,730065),('1','176','257928','409',660.00,736.00,0.00,452.74,298808.40,321523.84,22715.44,730066),('1','176','257929','409',660.00,736.00,0.00,2193.53,1447729.80,1552175.72,104445.92,730067),('1','176','257930','409',660.00,736.00,0.00,2516.56,1660929.60,1783464.16,122534.56,730068),('1','176','257931','409',660.00,736.00,0.00,2105.94,1389920.40,1490745.72,100825.32,730069),('1','176','257932','409',660.00,736.00,0.00,348.16,229785.60,246112.84,16327.24,730070),('1','176','257933','409',660.00,736.00,0.00,2888.45,1906377.00,2027116.64,120739.64,730071),('1','176','257934','409',660.00,736.00,0.00,3004.50,1982970.00,2123463.00,140493.00,730072),('1','176','257935','409',660.00,736.00,0.00,1825.50,1204830.00,1286364.00,81534.00,730073),('1','176','257936','409',660.00,736.00,0.00,2885.46,1904403.60,2041965.24,137561.64,730074),('1','176','257937','409',660.00,736.00,0.00,2091.83,1380607.80,1492520.12,111912.32,730075),('1','176','257938','409',660.00,736.00,0.00,4979.15,3286239.00,3515561.84,229322.84,730076),('1','176','257939','409',660.00,736.00,0.00,380.85,251361.00,271264.56,19903.56,730077),('1','176','257940','409',660.00,736.00,0.00,1768.99,1167533.40,1248696.64,81163.24,730078),('1','176','257941','409',660.00,736.00,0.00,1843.55,1216743.00,1304730.20,87987.20,730079),('1','176','257942','409',660.00,736.00,0.00,1205.10,795366.00,857917.08,62551.08,730080),('1','176','257943','409',660.00,736.00,0.00,50.80,33528.00,35560.00,2032.00,730081),('1','176','257944','409',660.00,736.00,0.00,1513.45,998877.00,1073867.20,74990.20,730082),('1','176','257945','409',660.00,736.00,0.00,1665.09,1098959.40,1176186.24,77226.84,730083),('1','176','257946','409',660.00,736.00,0.00,1692.10,1116786.00,1198205.44,81419.44,730084),('1','176','257947','409',660.00,736.00,0.00,2524.42,1666117.20,1780676.08,114558.88,730085),('1','176','257948','409',660.00,736.00,0.00,2357.01,1555626.60,1660779.36,105152.76,730086),('1','176','257949','409',660.00,736.00,0.00,558.57,368656.20,397282.08,28625.88,730087),('1','176','257950','409',660.00,736.00,0.00,798.77,527188.20,570902.72,43714.52,730088),('1','176','257951','409',660.00,736.00,0.00,2067.28,1364404.80,1464170.08,99765.28,730089),('1','176','257952','409',660.00,736.00,0.00,1891.90,1248654.00,1352262.40,103608.40,730090),('1','176','257953','409',660.00,736.00,0.00,696.37,459604.20,489326.32,29722.12,730091),('1','176','257954','409',660.00,736.00,0.00,779.07,514186.20,548483.52,34297.32,730092),('1','176','257955','409',660.00,736.00,0.00,2713.98,1791226.80,1920863.28,129636.48,730093),('1','176','257956','409',660.00,736.00,0.00,1381.87,912034.20,983540.32,71506.12,730094),('1','176','257957','409',660.00,736.00,0.00,1160.96,766233.60,817541.36,51307.76,730095),('1','176','257958','409',660.00,736.00,0.00,1693.61,1117782.60,1204166.36,86383.76,730096),('1','176','257959','409',660.00,736.00,0.00,2126.10,1403226.00,1497222.12,93996.12,730097),('1','176','257960','409',660.00,736.00,0.00,2331.21,1538598.60,1648342.56,109743.96,730098),('1','176','257961','409',660.00,736.00,0.00,2474.42,1633117.20,1750037.12,116919.92,730099),('1','176','257962','409',660.00,736.00,0.00,207.06,136659.60,146502.60,9843.00,730100),('1','176','257963','409',660.00,736.00,0.00,1554.92,1026247.20,1099858.16,73610.96,730101),('1','176','257964','409',660.00,736.00,0.00,2509.62,1656349.20,1775378.76,119029.56,730102),('1','176','257965','409',660.00,736.00,0.00,17.43,11503.80,12201.00,697.20,730103),('1','176','257966','409',660.00,736.00,0.00,2818.19,1860005.40,1994919.80,134914.40,730104),('1','176','257967','409',660.00,736.00,0.00,2194.79,1448561.40,1564395.56,115834.16,730105),('1','176','257968','409',660.00,736.00,0.00,1541.11,1017132.60,1089275.32,72142.72,730106),('1','176','257969','409',660.00,736.00,0.00,1380.89,911387.40,981248.00,69860.60,730107),('1','176','257970','409',660.00,736.00,0.00,1849.75,1220835.00,1297602.02,76767.02,730108),('1','176','257971','409',660.00,736.00,0.00,188.94,124700.40,134228.00,9527.60,730109),('1','176','257972','409',660.00,736.00,0.00,922.58,608902.80,650780.40,41877.60,730110),('1','176','257973','409',660.00,736.00,0.00,2444.64,1613462.40,1710974.60,97512.20,730111),('1','176','257974','409',660.00,736.00,0.00,1548.64,976576.50,1074412.88,97836.38,730112),('1','176','257975','409',630.00,736.00,0.00,3827.48,2411312.40,2636222.56,224910.16,730113),('1','176','257976','409',630.00,736.00,0.00,1611.57,1015289.10,1106566.40,91277.30,730114),('1','176','257977','409',630.00,736.00,0.00,4408.93,2777625.90,3012941.52,235315.62,730115),('1','176','257978','409',630.00,736.00,0.00,347.12,218685.60,238344.32,19658.72,730116),('1','176','257979','409',630.00,736.00,0.00,3326.34,2095594.20,2290969.60,195375.40,730117),('1','176','257980','409',630.00,736.00,0.00,1589.70,1001511.00,1094923.76,93412.76,730118),('1','176','257981','409',630.00,736.00,0.00,3530.38,2224139.40,2441729.92,217590.52,730119),('1','176','257982','409',630.00,736.00,0.00,1589.62,1001460.60,1092901.52,91440.92,730120),('1','176','257983','409',630.00,736.00,0.00,1851.85,1166665.50,1279406.24,112740.74,730121),('1','176','257984','409',630.00,736.00,0.00,2141.62,1349220.60,1484801.12,135580.52,730122),('1','176','257985','409',630.00,736.00,0.00,1223.98,771107.40,834882.96,63775.56,730123),('1','176','257986','409',630.00,736.00,0.00,3122.83,1967382.90,2161689.52,194306.62,730124),('1','176','257987','409',630.00,736.00,0.00,2177.17,1371617.10,1491741.12,120124.02,730125),('1','176','257988','409',630.00,736.00,0.00,446.30,281169.00,311569.84,30400.84,730126),('1','176','257989','409',630.00,736.00,0.00,2273.73,1432449.90,1573141.28,140691.38,730127),('1','176','257990','409',630.00,736.00,0.00,1938.91,1221513.30,1331589.68,110076.38,730128),('1','176','257991','409',630.00,736.00,0.00,968.98,610457.40,672499.84,62042.44,730129),('1','176','257992','409',630.00,736.00,0.00,3933.87,2478338.10,2749682.40,271344.30,730130),('1','176','257993','409',630.00,736.00,0.00,451.61,284514.30,308951.20,24436.90,730131),('1','176','257994','409',630.00,736.00,0.00,1700.54,1071340.20,1170098.96,98758.76,730132),('1','176','257995','409',630.00,736.00,0.00,3688.81,2323950.30,2549064.72,225114.42,730133),('1','176','257996','409',630.00,736.00,0.00,2534.72,1596873.60,1758748.48,161874.88,730134),('1','176','257997','409',630.00,736.00,0.00,2498.93,1574325.90,1709567.44,135241.54,730135),('1','176','257998','409',630.00,736.00,0.00,1627.83,1025532.90,1120928.88,95395.98,730136),('1','176','257999','409',630.00,736.00,0.00,2638.22,1662078.60,1816621.97,154543.37,730137),('1','176','258000','409',630.00,736.00,0.00,3605.64,2271553.20,2473996.85,202443.65,730138),('1','176','258001','409',630.00,736.00,0.00,2954.62,1861410.60,2028535.21,167124.61,730139),('1','176','258002','409',630.00,736.00,0.00,3487.45,2197093.50,2395895.49,198801.99,730140),('1','176','258003','409',630.00,736.00,0.00,4302.65,2710669.50,2940275.09,229605.59,730141),('1','176','258004','409',630.00,736.00,0.00,3103.58,1955255.40,2124195.89,168940.49,730142),('1','176','258005','409',630.00,736.00,0.00,2638.16,1662040.80,1804927.42,142886.62,730143),('1','176','258006','409',630.00,736.00,0.00,583.31,367485.30,401450.75,33965.45,730144),('1','176','258007','409',630.00,736.00,0.00,2206.37,1390013.10,1520547.00,130533.90,730145),('1','176','258008','409',630.00,736.00,0.00,4120.13,2595681.90,2838144.71,242462.81,730146),('1','176','258009','409',630.00,736.00,0.00,2907.28,1831586.40,2015595.02,184008.62,730147),('1','176','258010','409',630.00,736.00,0.00,2162.36,1362286.80,1481262.03,118975.23,730148),('1','176','258011','409',630.00,736.00,0.00,2316.05,1459111.50,1591040.56,131929.06,730149),('1','176','258012','409',630.00,736.00,0.00,4174.81,2630130.30,2869888.23,239757.93,730150),('1','176','258013','409',630.00,736.00,0.00,3838.23,2418084.90,2630634.59,212549.69,730151),('1','176','258014','409',630.00,736.00,0.00,2462.39,1551305.70,1694441.42,143135.72,730152),('1','176','258015','409',630.00,736.00,0.00,2230.41,1405158.30,1532306.36,127148.06,730153),('1','176','258016','409',630.00,736.00,0.00,7019.03,4421988.90,4781929.34,359940.44,730154),('1','176','258017','409',630.00,736.00,0.00,3102.96,1954864.80,2133718.56,178853.76,730155),('1','176','258018','409',630.00,736.00,0.00,3249.52,2047197.60,2228601.04,181403.44,730156),('1','176','258019','409',630.00,736.00,0.00,2024.73,1275579.90,1383260.96,107681.06,730157),('1','176','258020','409',630.00,736.00,0.00,2296.31,1446675.30,1586794.69,140119.39,730158),('1','176','258021','409',630.00,736.00,0.00,3548.07,2235284.10,2428995.01,193710.91,730159),('1','176','258022','409',630.00,736.00,0.00,1119.23,705114.90,774065.73,68950.83,730160),('1','176','258023','409',630.00,736.00,0.00,2631.00,1657530.00,1795928.73,138398.73,730161),('1','176','258024','409',630.00,736.00,0.00,2475.70,1559691.00,1693566.24,133875.24,730162),('1','176','258025','409',630.00,736.00,0.00,608.38,383279.40,422721.69,39442.29,730163),('1','176','258026','409',630.00,736.00,0.00,2484.24,1565071.20,1697376.91,132305.71,730164),('1','176','258027','409',630.00,736.00,0.00,1991.07,1254374.10,1363259.84,108885.74,730165),('1','176','258028','409',630.00,736.00,0.00,2677.24,1670597.76,1783990.60,113392.84,730166),('1','176','258029','409',624.00,700.00,0.00,2462.76,1536762.24,1642629.66,105867.42,730167),('1','176','258030','409',624.00,700.00,0.00,3138.53,1958442.72,2086245.14,127802.42,730168),('1','176','258031','409',624.00,700.00,0.00,1864.52,1163460.48,1239134.96,75674.48,730169),('1','176','258032','409',624.00,700.00,0.00,1394.52,870180.48,935046.00,64865.52,730170),('1','176','258033','409',624.00,700.00,0.00,3211.50,2003976.00,2143431.78,139455.78,730171),('1','176','258034','409',624.00,700.00,0.00,473.98,295763.52,313141.78,17378.26,730172),('1','176','258035','409',624.00,700.00,0.00,2687.60,1677062.40,1787499.98,110437.58,730173),('1','176','258036','409',624.00,700.00,0.00,1695.62,1058066.88,1132066.04,73999.16,730174),('1','176','258037','409',624.00,700.00,0.00,166.11,103652.64,111529.32,7876.68,730175),('1','176','258038','409',624.00,700.00,0.00,2455.23,1532063.52,1629681.48,97617.96,730176),('1','176','258039','409',624.00,700.00,0.00,2280.97,1423325.28,1519953.40,96628.12,730177),('1','176','258040','409',624.00,700.00,0.00,103.80,64771.20,72660.00,7888.80,730178),('1','176','258041','409',624.00,700.00,0.00,2740.54,1710096.96,1826822.20,116725.24,730179),('1','176','258042','409',624.00,700.00,0.00,802.60,500822.40,534212.56,33390.16,730180),('1','176','258043','409',624.00,700.00,0.00,1457.31,909361.44,960559.50,51198.06,730181),('1','176','258044','409',624.00,700.00,0.00,3267.61,2038988.64,2158888.50,119899.86,730182),('1','176','258045','409',624.00,700.00,0.00,2043.21,1274963.04,1356845.50,81882.46,730183);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=373 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',372,'176','PRODUCT TANK','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=921 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','176','372',920,1,'409','LPG TANK',6000.00,1.00,1568.33,'TANK CONTAINING LPG PRODUCT.','479','2021-03-19 05:35:40','2021-03-19 05:35:40','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','176',920,79.18,'2023-03-20 20:36:47');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2678048 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108518,'1','176','920',409,'Retail Sale Id 1254265',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 06:53:05','',''),(2108519,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 06:53:05','',''),(2108538,'1','176','920',409,'Retail Sale Id 1254281',12000.00,0.00,0.00,0.00,0.00,'2021-12-01 06:54:13','',''),(2108539,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 06:54:13','',''),(2108591,'1','176','920',409,'Retail Sale Id 1254304',90000.00,0.00,0.00,0.00,0.00,'2021-12-01 06:56:02','',''),(2108592,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 06:56:02','',''),(2108848,'1','176','920',409,'Retail Sale Id 1254418',90000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:08:53','',''),(2108849,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 07:08:53','',''),(2108939,'1','176','920',409,'Retail Sale Id 1254453',2003.20,0.00,0.00,0.00,125.20,'2021-12-01 07:11:59','',''),(2108940,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:11:59','',''),(2109213,'1','176','920',409,'Retail Sale Id 1254567',22500.00,0.00,0.00,0.00,0.00,'2021-12-01 07:23:55','',''),(2109214,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 07:23:55','',''),(2109380,'1','176','920',409,'Retail Sale Id 1254648',12800.00,0.00,0.00,0.00,800.00,'2021-12-01 07:34:18','',''),(2109381,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 07:34:18','',''),(2109416,'1','176','920',409,'Retail Sale Id 1254673',3200.00,0.00,0.00,0.00,200.00,'2021-12-01 07:35:55','',''),(2109417,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:35:55','',''),(2110376,'1','176','920',409,'Retail Sale Id 1255125',3801.60,0.00,0.00,0.00,237.60,'2021-12-01 08:22:37','',''),(2110377,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 08:22:37','',''),(2110523,'1','176','920',409,'Retail Sale Id 1255200',24000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:32:43','',''),(2110524,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 08:32:43','',''),(2111310,'1','176','920',409,'Retail Sale Id 1255603',90000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:18:41','',''),(2111311,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 09:18:41','',''),(2111388,'1','176','920',409,'Retail Sale Id 1255644',93600.00,0.00,0.00,0.00,0.00,'2021-12-01 09:23:28','',''),(2111389,'1','176','920',409,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-01 09:23:28','',''),(2111430,'1','176','920',409,'Retail Sale Id 1255660',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:25:54','',''),(2111431,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:25:54','',''),(2112066,'1','176','920',409,'Retail Sale Id 1255983',16000.00,0.00,0.00,0.00,1000.00,'2021-12-01 10:09:40','',''),(2112067,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 10:09:40','',''),(2112078,'1','176','920',409,'Retail Sale Id 1255993',120000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:10:47','',''),(2112079,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 10:10:47','',''),(2112194,'1','176','920',409,'Retail Sale Id 1256047',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:17','',''),(2112195,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:16:17','',''),(2112217,'1','176','920',409,'Retail Sale Id 1256058',4000.00,0.00,0.00,0.00,250.00,'2021-12-01 10:18:08','',''),(2112218,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:18:08','',''),(2112272,'1','176','920',409,'Retail Sale Id 1256089',18000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:23:06','',''),(2112273,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 10:23:06','',''),(2112473,'1','176','920',409,'Retail Sale Id 1256183',3001.60,0.00,0.00,0.00,187.60,'2021-12-01 10:38:18','',''),(2112474,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 10:38:18','',''),(2112622,'1','176','920',409,'Retail Sale Id 1256258',36000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:50:41','',''),(2112623,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 10:50:41','',''),(2112728,'1','176','920',409,'Retail Sale Id 1256318',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:00:30','',''),(2112729,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 11:00:30','',''),(2112784,'1','176','920',409,'Retail Sale Id 1256345',2003.20,0.00,0.00,0.00,125.20,'2021-12-01 11:05:33','',''),(2112785,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:05:33','',''),(2112974,'1','176','920',409,'Retail Sale Id 1256430',1497.60,0.00,0.00,0.00,93.60,'2021-12-01 11:16:39','',''),(2112975,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 11:16:39','',''),(2113064,'1','176','920',409,'Retail Sale Id 1256471',1952.00,0.00,0.00,0.00,122.00,'2021-12-01 11:21:44','',''),(2113065,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:21:44','',''),(2113142,'1','176','920',409,'Retail Sale Id 1256506',60000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:26:13','',''),(2113143,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 11:26:13','',''),(2113172,'1','176','920',409,'Retail Sale Id 1256523',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:27:51','',''),(2113173,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 11:27:51','',''),(2113196,'1','176','920',409,'Retail Sale Id 1256535',21498.00,0.00,0.00,0.00,0.00,'2021-12-01 11:29:48','',''),(2113197,'1','176','920',409,'Retail sales',0.00,0.00,0.00,35.83,0.00,'2021-12-01 11:29:48','',''),(2113218,'1','176','920',409,'Retail Sale Id 1256542',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:31:13','',''),(2113219,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 11:31:13','',''),(2113286,'1','176','920',409,'Retail Sale Id 1256586',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:37:10','',''),(2113287,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 11:37:10','',''),(2113577,'1','176','920',409,'Retail Sale Id 1256740',37200.00,0.00,0.00,0.00,0.00,'2021-12-01 11:59:43','',''),(2113578,'1','176','920',409,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-01 11:59:43','',''),(2114003,'1','176','920',409,'Retail Sale Id 1256957',36000.00,0.00,0.00,0.00,2250.00,'2021-12-01 12:33:51','',''),(2114004,'1','176','920',409,'Retail sales',0.00,0.00,0.00,56.25,0.00,'2021-12-01 12:33:52','',''),(2114071,'1','176','920',409,'Retail Sale Id 1256992',30000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:41:51','',''),(2114072,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:41:51','',''),(2114176,'1','176','920',409,'Retail Sale Id 1257043',28002.00,0.00,0.00,0.00,0.00,'2021-12-01 12:52:49','',''),(2114177,'1','176','920',409,'Retail sales',0.00,0.00,0.00,46.67,0.00,'2021-12-01 12:52:49','',''),(2114625,'1','176','920',409,'Retail Sale Id 1257298',285000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:27:49','',''),(2114626,'1','176','920',409,'Retail sales',0.00,0.00,0.00,475.00,0.00,'2021-12-01 13:27:49','',''),(2114685,'1','176','920',409,'Retail Sale Id 1257333',28500.00,0.00,0.00,0.00,0.00,'2021-12-01 13:33:11','',''),(2114686,'1','176','920',409,'Retail sales',0.00,0.00,0.00,47.50,0.00,'2021-12-01 13:33:11','',''),(2114760,'1','176','920',409,'Retail Sale Id 1257362',3852.80,0.00,0.00,0.00,240.80,'2021-12-01 13:37:48','',''),(2114761,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 13:37:48','',''),(2115498,'1','176','920',409,'Retail Sale Id 1257686',0.00,0.00,0.00,0.00,0.00,'2021-12-01 14:19:37','',''),(2115499,'1','176','920',409,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-01 14:19:37','',''),(2115514,'1','176','920',409,'Retail Sale Id 1257694',3852.80,0.00,0.00,0.00,240.80,'2021-12-01 14:20:50','',''),(2115515,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:20:50','',''),(2115607,'1','176','920',409,'Retail Sale Id 1257747',4998.40,0.00,0.00,0.00,312.40,'2021-12-01 14:27:38','',''),(2115608,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 14:27:38','',''),(2115684,'1','176','920',409,'Retail Sale Id 1257775',39900.00,0.00,0.00,0.00,0.00,'2021-12-01 14:33:03','',''),(2115685,'1','176','920',409,'Retail sales',0.00,0.00,0.00,66.50,0.00,'2021-12-01 14:33:03','',''),(2116551,'1','176','920',409,'Retail Sale Id 1258175',5120.00,0.00,0.00,0.00,320.00,'2021-12-01 15:29:40','',''),(2116552,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 15:29:40','',''),(2116790,'1','176','920',409,'Retail Sale Id 1258285',29400.00,0.00,0.00,0.00,0.00,'2021-12-01 15:44:51','',''),(2116791,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-01 15:44:51','',''),(2116976,'1','176','920',409,'Retail Sale Id 1258381',8000.00,0.00,0.00,0.00,500.00,'2021-12-01 15:52:38','',''),(2116977,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:52:38','',''),(2117022,'1','176','920',409,'Retail Sale Id 1258402',24000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:54:41','',''),(2117023,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 15:54:41','',''),(2117066,'1','176','920',409,'Retail Sale Id 1258423',2003.20,0.00,0.00,0.00,125.20,'2021-12-01 15:56:25','',''),(2117067,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:56:25','',''),(2117185,'1','176','920',409,'Retail Sale Id 1258483',60000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:01:38','',''),(2117186,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 16:01:38','',''),(2118064,'1','176','920',409,'Retail Sale Id 1258923',8000.00,0.00,0.00,0.00,500.00,'2021-12-01 16:40:04','',''),(2118065,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:40:04','',''),(2118264,'1','176','920',409,'Retail Sale Id 1259030',998.40,0.00,0.00,0.00,62.40,'2021-12-01 16:50:24','',''),(2118265,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:50:24','',''),(2118306,'1','176','920',409,'Retail Sale Id 1259049',3852.80,0.00,0.00,0.00,240.80,'2021-12-01 16:52:10','',''),(2118307,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:52:10','',''),(2118486,'1','176','920',409,'Retail Sale Id 1259137',2003.20,0.00,0.00,0.00,125.20,'2021-12-01 16:59:19','',''),(2118487,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:59:19','',''),(2118686,'1','176','920',409,'Retail Sale Id 1259233',4128.00,0.00,0.00,0.00,0.00,'2021-12-01 17:09:03','',''),(2118687,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.88,0.00,'2021-12-01 17:09:03','',''),(2120349,'1','176','920',409,'Retail Sale Id 1259814',240000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:00:47','',''),(2120350,'1','176','920',409,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-02 06:00:47','',''),(2120369,'1','176','920',409,'Retail Sale Id 1259837',1952.00,0.00,0.00,0.00,122.00,'2021-12-02 06:02:24','',''),(2120370,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 06:02:24','',''),(2120425,'1','176','920',409,'Retail Sale Id 1259846',300000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:06:44','',''),(2120426,'1','176','920',409,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-02 06:06:44','',''),(2120498,'1','176','920',409,'Retail Sale Id 1259903',51600.00,0.00,0.00,0.00,0.00,'2021-12-02 06:13:51','',''),(2120499,'1','176','920',409,'Retail sales',0.00,0.00,0.00,86.00,0.00,'2021-12-02 06:13:51','',''),(2120690,'1','176','920',409,'Retail Sale Id 1259992',90000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:28:23','',''),(2120691,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 06:28:23','',''),(2120710,'1','176','920',409,'Retail Sale Id 1260004',30000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:29:59','',''),(2120711,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 06:29:59','',''),(2121094,'1','176','920',409,'Retail Sale Id 1260154',43200.00,0.00,0.00,0.00,0.00,'2021-12-02 06:49:57','',''),(2121095,'1','176','920',409,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-02 06:49:57','',''),(2121244,'1','176','920',409,'Retail Sale Id 1260218',90000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:59:10','',''),(2121245,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 06:59:10','',''),(2121280,'1','176','920',409,'Retail Sale Id 1260235',5120.00,0.00,0.00,0.00,320.00,'2021-12-02 07:00:52','',''),(2121281,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 07:00:52','',''),(2122027,'1','176','920',409,'Retail Sale Id 1260610',1952.00,0.00,0.00,0.00,122.00,'2021-12-02 07:39:01','',''),(2122028,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:39:01','',''),(2122096,'1','176','920',409,'Retail Sale Id 1260648',30000.00,0.00,0.00,0.00,0.00,'2021-12-02 07:41:55','',''),(2122097,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:41:55','',''),(2122128,'1','176','920',409,'Retail Sale Id 1260663',30000.00,0.00,0.00,0.00,0.00,'2021-12-02 07:43:04','',''),(2122129,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:43:04','',''),(2122369,'1','176','920',409,'Retail Sale Id 1260772',139500.00,0.00,0.00,0.00,0.00,'2021-12-02 07:53:07','',''),(2122370,'1','176','920',409,'Retail sales',0.00,0.00,0.00,232.50,0.00,'2021-12-02 07:53:07','',''),(2122428,'1','176','920',409,'Retail Sale Id 1260799',2560.00,0.00,0.00,0.00,160.00,'2021-12-02 07:55:35','',''),(2122429,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:55:35','',''),(2122472,'1','176','920',409,'Retail Sale Id 1260820',60000.00,0.00,0.00,0.00,0.00,'2021-12-02 07:57:33','',''),(2122473,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 07:57:33','',''),(2122611,'1','176','920',409,'Retail Sale Id 1260877',8000.00,0.00,0.00,0.00,500.00,'2021-12-02 08:02:13','',''),(2122612,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:02:13','',''),(2122908,'1','176','920',409,'Retail Sale Id 1261031',95118.00,0.00,0.00,0.00,0.00,'2021-12-02 08:18:16','',''),(2122909,'1','176','920',409,'Retail sales',0.00,0.00,0.00,158.53,0.00,'2021-12-02 08:18:16','',''),(2123008,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2910000.00,5000.00,0.00,0.00,'2021-12-02 08:23:08','',''),(2123047,'1','176',NULL,409,'Reception corrector for bridging 125917',0.00,0.00,0.00,5000.00,0.00,'2021-12-02 08:24:34','',''),(2123048,'1','176','920',409,'Received from bridging 125917',0.00,0.00,5000.00,0.00,0.00,'2021-12-02 08:24:34','',''),(2123065,'1','176','920',409,'Retail Sale Id 1261111',93600.00,0.00,0.00,0.00,2808.00,'2021-12-02 08:25:39','',''),(2123066,'1','176','920',409,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-02 08:25:39','',''),(2123159,'1','176','920',409,'Retail Sale Id 1261157',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 08:30:45','',''),(2123160,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:30:45','',''),(2123340,'1','176','920',409,'Retail Sale Id 1261228',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 08:39:03','',''),(2123341,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:39:03','',''),(2123721,'1','176','920',409,'Retail Sale Id 1261419',60000.00,0.00,0.00,0.00,1800.00,'2021-12-02 09:00:18','',''),(2123722,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 09:00:18','',''),(2123783,'1','176','920',409,'Retail Sale Id 1261465',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 09:03:41','',''),(2123784,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 09:03:41','',''),(2123821,'1','176','920',409,'Retail Sale Id 1261482',28800.00,0.00,0.00,0.00,864.00,'2021-12-02 09:05:31','',''),(2123822,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-02 09:05:31','',''),(2123873,'1','176','920',409,'Retail Sale Id 1261496',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 09:07:50','',''),(2123874,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:07:50','',''),(2123941,'1','176','920',409,'Retail Sale Id 1261547',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 09:11:15','',''),(2123942,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 09:11:15','',''),(2123975,'1','176','920',409,'Retail Sale Id 1261557',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 09:12:22','',''),(2123976,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:12:22','',''),(2124364,'1','176','920',409,'Retail Sale Id 1261723',20800.00,0.00,0.00,0.00,1885.00,'2021-12-02 09:32:27','',''),(2124365,'1','176','920',409,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-02 09:32:27','',''),(2124531,'1','176','920',409,'Retail Sale Id 1261815',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 09:43:54','',''),(2124532,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:43:54','',''),(2124741,'1','176','920',409,'Retail Sale Id 1261929',57000.00,0.00,0.00,0.00,1710.00,'2021-12-02 09:53:55','',''),(2124742,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-02 09:53:55','',''),(2124871,'1','176','920',409,'Retail Sale Id 1261996',120000.00,0.00,0.00,0.00,3600.00,'2021-12-02 10:00:35','',''),(2124872,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 10:00:35','',''),(2125061,'1','176','920',409,'Retail Sale Id 1262095',217500.00,0.00,0.00,0.00,6525.00,'2021-12-02 10:12:14','',''),(2125062,'1','176','920',409,'Retail sales',0.00,0.00,0.00,362.50,0.00,'2021-12-02 10:12:14','',''),(2125293,'1','176','920',409,'Retail Sale Id 1262204',75000.00,0.00,0.00,0.00,2250.00,'2021-12-02 10:24:17','',''),(2125294,'1','176','920',409,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-02 10:24:17','',''),(2125712,'1','176','920',409,'Retail Sale Id 1262411',120000.00,0.00,0.00,0.00,3600.00,'2021-12-02 10:49:54','',''),(2125713,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 10:49:54','',''),(2125842,'1','176','920',409,'Retail Sale Id 1262479',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 10:59:52','',''),(2125843,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 10:59:52','',''),(2126064,'1','176','920',409,'Retail Sale Id 1262597',25800.00,0.00,0.00,0.00,774.00,'2021-12-02 11:13:05','',''),(2126065,'1','176','920',409,'Retail sales',0.00,0.00,0.00,43.00,0.00,'2021-12-02 11:13:05','',''),(2126178,'1','176','920',409,'Retail Sale Id 1262665',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 11:19:30','',''),(2126179,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:19:30','',''),(2126424,'1','176','920',409,'Retail Sale Id 1262780',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 11:32:10','',''),(2126425,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 11:32:10','',''),(2126577,'1','176','920',409,'Retail Sale Id 1262826',39000.00,0.00,0.00,0.00,1170.00,'2021-12-02 11:39:30','',''),(2126578,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-02 11:39:30','',''),(2127048,'1','176','920',409,'Retail Sale Id 1263076',1952.00,0.00,0.00,0.00,176.90,'2021-12-02 12:19:54','',''),(2127049,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:19:54','',''),(2127104,'1','176','920',409,'Retail Sale Id 1263107',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 12:23:18','',''),(2127105,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:23:18','',''),(2127475,'1','176','920',409,'Retail Sale Id 1263303',6003.20,0.00,0.00,0.00,544.04,'2021-12-02 12:50:20','',''),(2127476,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 12:50:20','',''),(2127493,'1','176','920',409,'Retail Sale Id 1263311',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 12:52:20','',''),(2127494,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:52:20','',''),(2127754,'1','176','920',409,'Retail Sale Id 1263441',45000.00,0.00,0.00,0.00,1350.00,'2021-12-02 13:11:48','',''),(2127755,'1','176','920',409,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-02 13:11:48','',''),(2128027,'1','176','920',409,'Retail Sale Id 1263548',57000.00,0.00,0.00,0.00,1710.00,'2021-12-02 13:28:10','',''),(2128028,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-02 13:28:10','',''),(2128105,'1','176','920',409,'Retail Sale Id 1263583',6400.00,0.00,0.00,0.00,580.00,'2021-12-02 13:35:05','',''),(2128106,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:35:05','',''),(2128140,'1','176','920',409,'Retail Sale Id 1263599',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 13:37:41','',''),(2128141,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:37:41','',''),(2128260,'1','176','920',409,'Retail Sale Id 1263645',22002.00,0.00,0.00,0.00,660.06,'2021-12-02 13:44:52','',''),(2128261,'1','176','920',409,'Retail sales',0.00,0.00,0.00,36.67,0.00,'2021-12-02 13:44:52','',''),(2128336,'1','176','920',409,'Retail Sale Id 1263684',90000.00,0.00,0.00,0.00,2700.00,'2021-12-02 13:48:24','',''),(2128337,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 13:48:24','',''),(2128830,'1','176','920',409,'Retail Sale Id 1263905',998.40,0.00,0.00,0.00,90.48,'2021-12-02 14:17:21','',''),(2128831,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:17:21','',''),(2128929,'1','176','920',409,'Retail Sale Id 1263954',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 14:22:23','',''),(2128930,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 14:22:23','',''),(2129102,'1','176','920',409,'Retail Sale Id 1264005',18000.00,0.00,0.00,0.00,540.00,'2021-12-02 14:28:15','',''),(2129103,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 14:28:15','',''),(2129278,'1','176','920',409,'Retail Sale Id 1264073',34200.00,0.00,0.00,0.00,1026.00,'2021-12-02 14:37:13','',''),(2129279,'1','176','920',409,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-02 14:37:13','',''),(2129345,'1','176','920',409,'Retail Sale Id 1264104',51000.00,0.00,0.00,0.00,1530.00,'2021-12-02 14:39:21','',''),(2129346,'1','176','920',409,'Retail sales',0.00,0.00,0.00,85.00,0.00,'2021-12-02 14:39:21','',''),(2129515,'1','176','920',409,'Retail Sale Id 1264180',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 14:48:25','',''),(2129516,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:48:25','',''),(2130030,'1','176','920',409,'Retail Sale Id 1264445',15000.00,0.00,0.00,0.00,450.00,'2021-12-02 15:19:52','',''),(2130031,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 15:19:52','',''),(2130178,'1','176','920',409,'Retail Sale Id 1264517',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 15:27:04','',''),(2130179,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:27:04','',''),(2130217,'1','176','920',409,'Retail Sale Id 1264534',1952.00,0.00,0.00,0.00,176.90,'2021-12-02 15:28:18','',''),(2130218,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:28:18','',''),(2130478,'1','176','920',409,'Retail Sale Id 1264659',15000.00,0.00,0.00,0.00,450.00,'2021-12-02 15:40:25','',''),(2130479,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 15:40:25','',''),(2130742,'1','176','920',409,'Retail Sale Id 1264809',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 15:52:21','',''),(2130743,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:52:21','',''),(2130774,'1','176','920',409,'Retail Sale Id 1264825',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 15:53:41','',''),(2130775,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 15:53:41','',''),(2130866,'1','176','920',409,'Retail Sale Id 1264871',6000.00,0.00,0.00,0.00,180.00,'2021-12-02 15:57:19','',''),(2130867,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 15:57:19','',''),(2131150,'1','176','920',409,'Retail Sale Id 1265001',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 16:09:16','',''),(2131151,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 16:09:16','',''),(2131230,'1','176','920',409,'Retail Sale Id 1265044',1952.00,0.00,0.00,0.00,176.90,'2021-12-02 16:13:39','',''),(2131231,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:13:39','',''),(2131686,'1','176','920',409,'Retail Sale Id 1265267',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 16:33:23','',''),(2131687,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:33:23','',''),(2131823,'1','176','920',409,'Retail Sale Id 1265329',3852.80,0.00,0.00,0.00,349.16,'2021-12-02 16:41:15','',''),(2131824,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:41:15','',''),(2131851,'1','176','920',409,'Retail Sale Id 1265345',15000.00,0.00,0.00,0.00,450.00,'2021-12-02 16:42:34','',''),(2131852,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 16:42:34','',''),(2131960,'1','176','920',409,'Retail Sale Id 1265400',6003.20,0.00,0.00,0.00,544.04,'2021-12-02 16:47:04','',''),(2131961,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 16:47:04','',''),(2132980,'1','176','920',409,'Retail Sale Id 1265867',73068.00,0.00,0.00,0.00,2192.04,'2021-12-02 18:03:59','',''),(2132981,'1','176','920',409,'Retail sales',0.00,0.00,0.00,121.78,0.00,'2021-12-02 18:03:59','',''),(2133786,'1','176','920',409,'Retail Sale Id 1266060',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 05:28:48','',''),(2133787,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 05:28:48','',''),(2133802,'1','176','920',409,'Retail Sale Id 1266061',11852.80,0.00,0.00,0.00,1074.16,'2021-12-03 05:31:14','',''),(2133803,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.52,0.00,'2021-12-03 05:31:14','',''),(2133824,'1','176','920',409,'Retail Sale Id 1266068',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 05:47:36','',''),(2133825,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 05:47:36','',''),(2133920,'1','176','920',409,'Retail Sale Id 1266087',3852.80,0.00,0.00,0.00,349.16,'2021-12-03 06:05:32','',''),(2133921,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 06:05:32','',''),(2133932,'1','176','920',409,'Retail Sale Id 1266096',120000.00,0.00,0.00,0.00,3600.00,'2021-12-03 06:06:57','',''),(2133933,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 06:06:57','',''),(2134180,'1','176','920',409,'Retail Sale Id 1266188',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 06:30:21','',''),(2134181,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 06:30:21','',''),(2134315,'1','176','920',409,'Retail Sale Id 1266244',120000.00,0.00,0.00,0.00,3600.00,'2021-12-03 06:37:47','',''),(2134316,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 06:37:47','',''),(2134447,'1','176','920',409,'Retail Sale Id 1266313',998.40,0.00,0.00,0.00,90.48,'2021-12-03 06:44:55','',''),(2134448,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:44:55','',''),(2134524,'1','176','920',409,'Retail Sale Id 1266326',120000.00,0.00,0.00,0.00,3600.00,'2021-12-03 06:48:43','',''),(2134525,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 06:48:43','',''),(2135564,'1','176','920',409,'Retail Sale Id 1266834',96000.00,0.00,0.00,0.00,2880.00,'2021-12-03 07:47:26','',''),(2135565,'1','176','920',409,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-03 07:47:26','',''),(2135608,'1','176','920',409,'Retail Sale Id 1266876',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 07:49:36','',''),(2135609,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:49:36','',''),(2135641,'1','176','920',409,'Retail Sale Id 1266891',32700.00,0.00,0.00,0.00,981.00,'2021-12-03 07:50:49','',''),(2135642,'1','176','920',409,'Retail sales',0.00,0.00,0.00,54.50,0.00,'2021-12-03 07:50:49','',''),(2135673,'1','176','920',409,'Retail Sale Id 1266903',60000.00,0.00,0.00,0.00,1800.00,'2021-12-03 07:52:25','',''),(2135674,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 07:52:25','',''),(2135705,'1','176','920',409,'Retail Sale Id 1266915',18000.00,0.00,0.00,0.00,540.00,'2021-12-03 07:54:16','',''),(2135706,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 07:54:16','',''),(2136234,'1','176','920',409,'Retail Sale Id 1267158',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 08:18:37','',''),(2136235,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 08:18:37','',''),(2136271,'1','176','920',409,'Retail Sale Id 1267178',94800.00,0.00,0.00,0.00,2844.00,'2021-12-03 08:21:12','',''),(2136272,'1','176','920',409,'Retail sales',0.00,0.00,0.00,158.00,0.00,'2021-12-03 08:21:12','',''),(2136356,'1','176','920',409,'Retail Sale Id 1267214',60000.00,0.00,0.00,0.00,1800.00,'2021-12-03 08:25:25','',''),(2136357,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 08:25:25','',''),(2136406,'1','176','920',409,'Retail Sale Id 1267232',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 08:28:53','',''),(2136407,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 08:28:53','',''),(2136436,'1','176','920',409,'Retail Sale Id 1267256',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:31:36','',''),(2136437,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:31:36','',''),(2136447,'1','176','920',409,'Retail Sale Id 1267259',4200.00,0.00,0.00,0.00,126.00,'2021-12-03 08:32:43','',''),(2136448,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 08:32:43','',''),(2137976,'1','176','920',409,'Retail Sale Id 1267999',60000.00,0.00,0.00,0.00,1800.00,'2021-12-03 09:51:49','',''),(2137977,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 09:51:49','',''),(2138110,'1','176','920',409,'Retail Sale Id 1268064',34800.00,0.00,0.00,0.00,1044.00,'2021-12-03 10:00:49','',''),(2138111,'1','176','920',409,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-03 10:00:49','',''),(2138379,'1','176','920',409,'Retail Sale Id 1268202',4800.00,0.00,0.00,0.00,144.00,'2021-12-03 10:15:13','',''),(2138380,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 10:15:13','',''),(2138701,'1','176','920',409,'Retail Sale Id 1268360',15000.00,0.00,0.00,0.00,450.00,'2021-12-03 10:35:01','',''),(2138702,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 10:35:01','',''),(2139449,'1','176','920',409,'Retail Sale Id 1268742',39000.00,0.00,0.00,0.00,1170.00,'2021-12-03 11:30:43','',''),(2139450,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-03 11:30:43','',''),(2139715,'1','176','920',409,'Retail Sale Id 1268902',118800.00,0.00,0.00,0.00,3564.00,'2021-12-03 11:51:36','',''),(2139716,'1','176','920',409,'Retail sales',0.00,0.00,0.00,198.00,0.00,'2021-12-03 11:51:36','',''),(2139835,'1','176','920',409,'Retail Sale Id 1268958',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 12:00:48','',''),(2139836,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 12:00:48','',''),(2139889,'1','176','920',409,'Retail Sale Id 1268994',1574.40,0.00,0.00,0.00,142.68,'2021-12-03 12:03:46','',''),(2139890,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.46,0.00,'2021-12-03 12:03:46','',''),(2139959,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2910000.00,5000.00,0.00,0.00,'2021-12-03 12:08:28','',''),(2140004,'1','176',NULL,409,'Reception corrector for bridging 126065',0.00,0.00,0.00,5000.00,0.00,'2021-12-03 12:11:29','',''),(2140005,'1','176','920',409,'Received from bridging 126065',0.00,0.00,5000.00,0.00,0.00,'2021-12-03 12:11:29','',''),(2140246,'1','176','920',409,'Retail Sale Id 1269201',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 12:33:42','',''),(2140247,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 12:33:42','',''),(2140272,'1','176','920',409,'Retail Sale Id 1269222',60000.00,0.00,0.00,0.00,1800.00,'2021-12-03 12:36:21','',''),(2140273,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 12:36:21','',''),(2140555,'1','176','920',409,'Retail Sale Id 1269353',15000.00,0.00,0.00,0.00,450.00,'2021-12-03 12:55:32','',''),(2140556,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 12:55:32','',''),(2140586,'1','176','920',409,'Retail Sale Id 1269372',10002.00,0.00,0.00,0.00,300.06,'2021-12-03 12:58:15','',''),(2140587,'1','176','920',409,'Retail sales',0.00,0.00,0.00,16.67,0.00,'2021-12-03 12:58:15','',''),(2140620,'1','176','920',409,'Retail Sale Id 1269383',31800.00,0.00,0.00,0.00,954.00,'2021-12-03 13:01:16','',''),(2140621,'1','176','920',409,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-03 13:01:16','',''),(2140783,'1','176','920',409,'Retail Sale Id 1269464',27000.00,0.00,0.00,0.00,810.00,'2021-12-03 13:15:43','',''),(2140784,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-03 13:15:43','',''),(2140820,'1','176','920',409,'Retail Sale Id 1269477',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 13:18:13','',''),(2140821,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:18:13','',''),(2140879,'1','176','920',409,'Retail Sale Id 1269495',3852.80,0.00,0.00,0.00,349.16,'2021-12-03 13:22:06','',''),(2140880,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 13:22:06','',''),(2140887,'1','176','920',409,'Retail Sale Id 1269503',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 13:23:47','',''),(2140888,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:23:47','',''),(2140909,'1','176','920',409,'Retail Sale Id 1269512',6080.00,0.00,0.00,0.00,551.00,'2021-12-03 13:25:13','',''),(2140910,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-03 13:25:13','',''),(2140942,'1','176','920',409,'Retail Sale Id 1269529',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 13:27:54','',''),(2140943,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:27:54','',''),(2140974,'1','176','920',409,'Retail Sale Id 1269545',1952.00,0.00,0.00,0.00,176.90,'2021-12-03 13:29:43','',''),(2140975,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:29:43','',''),(2141051,'1','176','920',409,'Retail Sale Id 1269582',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 13:34:47','',''),(2141052,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:34:47','',''),(2141065,'1','176','920',409,'Retail Sale Id 1269594',1952.00,0.00,0.00,0.00,176.90,'2021-12-03 13:36:05','',''),(2141066,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:36:05','',''),(2141215,'1','176','920',409,'Retail Sale Id 1269657',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 13:44:12','',''),(2141216,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:44:12','',''),(2141330,'1','176','920',409,'Retail Sale Id 1269700',15000.00,0.00,0.00,0.00,450.00,'2021-12-03 13:47:37','',''),(2141331,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 13:47:37','',''),(2141403,'1','176','920',409,'Retail Sale Id 1269715',1900.80,0.00,0.00,0.00,172.26,'2021-12-03 13:49:56','',''),(2141404,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 13:49:56','',''),(2141421,'1','176','920',409,'Retail Sale Id 1269727',19200.00,0.00,0.00,0.00,576.00,'2021-12-03 13:51:16','',''),(2141422,'1','176','920',409,'Retail sales',0.00,0.00,0.00,32.00,0.00,'2021-12-03 13:51:16','',''),(2141505,'1','176','920',409,'Retail Sale Id 1269709',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 13:55:33','',''),(2141506,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:55:33','',''),(2141546,'1','176','920',409,'Retail Sale Id 1269781',12000.00,0.00,0.00,0.00,360.00,'2021-12-03 13:59:23','',''),(2141547,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 13:59:23','',''),(2142040,'1','176','920',409,'Retail Sale Id 1269981',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 14:28:30','',''),(2142041,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:28:30','',''),(2142447,'1','176','920',409,'Retail Sale Id 1270140',24000.00,0.00,0.00,0.00,2175.00,'2021-12-03 14:47:51','',''),(2142448,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-03 14:47:51','',''),(2142541,'1','176','920',409,'Retail Sale Id 1270190',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 14:51:57','',''),(2142542,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 14:51:57','',''),(2142732,'1','176','920',409,'Retail Sale Id 1270266',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 15:01:48','',''),(2142733,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 15:01:48','',''),(2142938,'1','176','920',409,'Retail Sale Id 1270378',3001.60,0.00,0.00,0.00,272.02,'2021-12-03 15:13:44','',''),(2142939,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:13:44','',''),(2143265,'1','176','920',409,'Retail Sale Id 1270558',14502.00,0.00,0.00,0.00,435.06,'2021-12-03 15:29:57','',''),(2143266,'1','176','920',409,'Retail sales',0.00,0.00,0.00,24.17,0.00,'2021-12-03 15:29:57','',''),(2143309,'1','176','920',409,'Retail Sale Id 1270574',6003.20,0.00,0.00,0.00,544.04,'2021-12-03 15:32:03','',''),(2143310,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 15:32:03','',''),(2143341,'1','176','920',409,'Retail Sale Id 1270600',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 15:33:47','',''),(2143342,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:33:47','',''),(2144093,'1','176','920',409,'Retail Sale Id 1270968',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 16:05:47','',''),(2144094,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:05:47','',''),(2144354,'1','176','920',409,'Retail Sale Id 1271094',60000.00,0.00,0.00,0.00,1800.00,'2021-12-03 16:18:56','',''),(2144355,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 16:18:56','',''),(2144494,'1','176','920',409,'Retail Sale Id 1271169',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 16:25:51','',''),(2144495,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:25:51','',''),(2145013,'1','176','920',409,'Retail Sale Id 1271421',93804.00,0.00,0.00,0.00,2814.12,'2021-12-03 16:51:42','',''),(2145014,'1','176','920',409,'Retail sales',0.00,0.00,0.00,156.34,0.00,'2021-12-03 16:51:42','',''),(2145184,'1','176','920',409,'Retail Sale Id 1271483',31200.00,0.00,0.00,0.00,936.00,'2021-12-03 16:58:36','',''),(2145185,'1','176','920',409,'Retail sales',0.00,0.00,0.00,52.00,0.00,'2021-12-03 16:58:36','',''),(2145209,'1','176','920',409,'Retail Sale Id 1271493',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 17:00:35','',''),(2145210,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 17:00:35','',''),(2145232,'1','176','920',409,'Retail Sale Id 1271505',3852.80,0.00,0.00,0.00,349.16,'2021-12-03 17:02:05','',''),(2145233,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 17:02:05','',''),(2145365,'1','176','920',409,'Retail Sale Id 1271577',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 17:12:43','',''),(2145366,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:12:43','',''),(2146552,'1','176','920',409,'Retail Sale Id 1271968',15000.00,0.00,0.00,0.00,450.00,'2021-12-04 05:53:27','',''),(2146553,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 05:53:27','',''),(2146624,'1','176','920',409,'Retail Sale Id 1271988',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 06:04:17','',''),(2146625,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:04:17','',''),(2146861,'1','176','920',409,'Retail Sale Id 1272062',90000.00,0.00,0.00,0.00,2700.00,'2021-12-04 06:24:10','',''),(2146862,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 06:24:10','',''),(2147223,'1','176','920',409,'Retail Sale Id 1272213',22002.00,0.00,0.00,0.00,660.06,'2021-12-04 06:42:22','',''),(2147224,'1','176','920',409,'Retail sales',0.00,0.00,0.00,36.67,0.00,'2021-12-04 06:42:22','',''),(2147752,'1','176','920',409,'Retail Sale Id 1272468',60000.00,0.00,0.00,0.00,1800.00,'2021-12-04 07:11:01','',''),(2147753,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 07:11:01','',''),(2147764,'1','176','920',409,'Retail Sale Id 1272475',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 07:11:48','',''),(2147765,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:11:48','',''),(2147910,'1','176','920',409,'Retail Sale Id 1272554',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 07:18:54','',''),(2147911,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:18:54','',''),(2148541,'1','176','920',409,'Retail Sale Id 1272947',176400.00,0.00,0.00,0.00,5292.00,'2021-12-04 07:51:46','',''),(2148542,'1','176','920',409,'Retail sales',0.00,0.00,0.00,294.00,0.00,'2021-12-04 07:51:46','',''),(2148624,'1','176','920',409,'Retail Sale Id 1272974',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 07:57:09','',''),(2148625,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:57:09','',''),(2149436,'1','176','920',409,'Retail Sale Id 1273497',4800.00,0.00,0.00,0.00,144.00,'2021-12-04 08:31:10','',''),(2149437,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 08:31:10','',''),(2149684,'1','176','920',409,'Retail Sale Id 1273615',5760.00,0.00,0.00,0.00,522.00,'2021-12-04 08:40:06','',''),(2149685,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 08:40:06','',''),(2149838,'1','176','920',409,'Retail Sale Id 1273695',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 08:46:21','',''),(2149839,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:46:21','',''),(2149984,'1','176','920',409,'Retail Sale Id 1273779',7500.00,0.00,0.00,0.00,225.00,'2021-12-04 08:53:14','',''),(2149985,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:53:14','',''),(2150131,'1','176','920',409,'Retail Sale Id 1273853',182400.00,0.00,0.00,0.00,5472.00,'2021-12-04 08:59:40','',''),(2150132,'1','176','920',409,'Retail sales',0.00,0.00,0.00,304.00,0.00,'2021-12-04 08:59:40','',''),(2150149,'1','176','920',409,'Retail Sale Id 1273859',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:00:33','',''),(2150150,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:00:33','',''),(2150730,'1','176','920',409,'Retail Sale Id 1274169',18000.00,0.00,0.00,0.00,540.00,'2021-12-04 09:29:36','',''),(2150731,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 09:29:36','',''),(2152533,'1','176','920',409,'Retail Sale Id 1274423',57000.00,0.00,0.00,0.00,1710.00,'2021-12-04 10:40:04','',''),(2152534,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-04 10:40:04','',''),(2152600,'1','176','920',409,'Retail Sale Id 1274442',22200.00,0.00,0.00,0.00,666.00,'2021-12-04 10:44:13','',''),(2152601,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-04 10:44:13','',''),(2152644,'1','176','920',409,'Retail Sale Id 1274456',60000.00,0.00,0.00,0.00,1800.00,'2021-12-04 10:46:40','',''),(2152645,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 10:46:40','',''),(2152734,'1','176','920',409,'Retail Sale Id 1274499',180000.00,0.00,0.00,0.00,5400.00,'2021-12-04 10:51:58','',''),(2152735,'1','176','920',409,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-04 10:51:58','',''),(2152769,'1','176','920',409,'Retail Sale Id 1274509',16000.00,0.00,0.00,0.00,1450.00,'2021-12-04 10:53:13','',''),(2152770,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 10:53:13','',''),(2152825,'1','176','920',409,'Retail Sale Id 1274535',64000.00,0.00,0.00,0.00,5800.00,'2021-12-04 10:56:38','',''),(2152826,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 10:56:38','',''),(2152837,'1','176','920',409,'Retail Sale Id 1274541',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 10:57:40','',''),(2152838,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 10:57:40','',''),(2153564,'1','176','920',409,'Retail Sale Id 1274906',54000.00,0.00,0.00,0.00,1620.00,'2021-12-04 11:35:08','',''),(2153565,'1','176','920',409,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-04 11:35:08','',''),(2153895,'1','176','920',409,'Retail Sale Id 1275042',178200.00,0.00,0.00,0.00,5346.00,'2021-12-04 11:52:54','',''),(2153896,'1','176','920',409,'Retail sales',0.00,0.00,0.00,297.00,0.00,'2021-12-04 11:52:54','',''),(2153926,'1','176','920',409,'Retail Sale Id 1275056',10800.00,0.00,0.00,0.00,324.00,'2021-12-04 11:54:34','',''),(2153927,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-04 11:54:34','',''),(2153952,'1','176','920',409,'Retail Sale Id 1275067',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 11:55:45','',''),(2153953,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 11:55:45','',''),(2154467,'1','176','920',409,'Retail Sale Id 1275271',4800.00,0.00,0.00,0.00,144.00,'2021-12-04 12:23:50','',''),(2154468,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 12:23:50','',''),(2155003,'1','176','920',409,'Retail Sale Id 1275735',90000.00,0.00,0.00,0.00,2700.00,'2021-12-04 13:04:36','',''),(2155004,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 13:04:36','',''),(2155127,'1','176','920',409,'Retail Sale Id 1275797',147426.00,0.00,0.00,0.00,4422.78,'2021-12-04 13:11:46','',''),(2155128,'1','176','920',409,'Retail sales',0.00,0.00,0.00,245.71,0.00,'2021-12-04 13:11:46','',''),(2155231,'1','176','920',409,'Retail Sale Id 1275841',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 13:18:44','',''),(2155232,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:18:44','',''),(2155390,'1','176','920',409,'Retail Sale Id 1275891',67200.00,0.00,0.00,0.00,2016.00,'2021-12-04 13:26:13','',''),(2155391,'1','176','920',409,'Retail sales',0.00,0.00,0.00,112.00,0.00,'2021-12-04 13:26:13','',''),(2155442,'1','176','920',409,'Retail Sale Id 1275908',3600.00,0.00,0.00,0.00,108.00,'2021-12-04 13:27:27','',''),(2155443,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:27:27','',''),(2155726,'1','176','920',409,'Retail Sale Id 1276046',90000.00,0.00,0.00,0.00,2700.00,'2021-12-04 13:43:46','',''),(2155727,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 13:43:46','',''),(2156231,'1','176','920',409,'Retail Sale Id 1276258',998.40,0.00,0.00,0.00,90.48,'2021-12-04 14:06:06','',''),(2156232,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:06:06','',''),(2156277,'1','176','920',409,'Retail Sale Id 1276285',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 14:08:11','',''),(2156278,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:08:11','',''),(2156490,'1','176','920',409,'Retail Sale Id 1276388',19998.00,0.00,0.00,0.00,599.94,'2021-12-04 14:17:57','',''),(2156491,'1','176','920',409,'Retail sales',0.00,0.00,0.00,33.33,0.00,'2021-12-04 14:17:57','',''),(2157034,'1','176','920',409,'Retail Sale Id 1276626',640.00,0.00,0.00,0.00,58.00,'2021-12-04 14:46:33','',''),(2157035,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 14:46:33','',''),(2157078,'1','176','920',409,'Retail Sale Id 1276640',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 14:48:33','',''),(2157079,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:48:33','',''),(2157510,'1','176','920',409,'Retail Sale Id 1276830',15360.00,0.00,0.00,0.00,1392.00,'2021-12-04 15:12:34','',''),(2157511,'1','176','920',409,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-04 15:12:34','',''),(2157544,'1','176','920',409,'Retail Sale Id 1276844',4480.00,0.00,0.00,0.00,406.00,'2021-12-04 15:13:37','',''),(2157545,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 15:13:37','',''),(2157572,'1','176','920',409,'Retail Sale Id 1276855',15000.00,0.00,0.00,0.00,450.00,'2021-12-04 15:14:50','',''),(2157573,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 15:14:50','',''),(2157842,'1','176','920',409,'Retail Sale Id 1276967',3500.80,0.00,0.00,0.00,317.26,'2021-12-04 15:26:51','',''),(2157843,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 15:26:51','',''),(2157913,'1','176','920',409,'Retail Sale Id 1277001',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:29:47','',''),(2157914,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:29:47','',''),(2157959,'1','176','920',409,'Retail Sale Id 1277024',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 15:32:11','',''),(2157960,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:32:11','',''),(2158132,'1','176','920',409,'Retail Sale Id 1277071',90000.00,0.00,0.00,0.00,2700.00,'2021-12-04 15:40:41','',''),(2158133,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 15:40:41','',''),(2158350,'1','176','920',409,'Retail Sale Id 1277204',1952.00,0.00,0.00,0.00,176.90,'2021-12-04 15:50:52','',''),(2158351,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:50:52','',''),(2158585,'1','176','920',409,'Retail Sale Id 1277341',54000.00,0.00,0.00,0.00,1620.00,'2021-12-04 16:02:07','',''),(2158586,'1','176','920',409,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-04 16:02:07','',''),(2158634,'1','176','920',409,'Retail Sale Id 1277362',168858.00,0.00,0.00,0.00,5065.74,'2021-12-04 16:04:50','',''),(2158635,'1','176','920',409,'Retail sales',0.00,0.00,0.00,281.43,0.00,'2021-12-04 16:04:51','',''),(2159139,'1','176','920',409,'Retail Sale Id 1277630',15600.00,0.00,0.00,0.00,468.00,'2021-12-04 16:27:48','',''),(2159140,'1','176','920',409,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-04 16:27:48','',''),(2159664,'1','176','920',409,'Retail Sale Id 1277902',24000.00,0.00,0.00,0.00,720.00,'2021-12-04 16:51:44','',''),(2159665,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 16:51:44','',''),(2160694,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2875080.00,4940.00,0.00,0.00,'2021-12-04 17:52:18','',''),(2160723,'1','176',NULL,409,'Reception corrector for bridging 126236',0.00,0.00,0.00,4940.00,0.00,'2021-12-04 17:54:10','',''),(2160724,'1','176','920',409,'Received from bridging 126236',0.00,0.00,4940.00,0.00,0.00,'2021-12-04 17:54:10','',''),(2160741,'1','176','920',409,'Retail Sale Id 1278360',225900.00,0.00,0.00,0.00,6777.00,'2021-12-04 17:56:04','',''),(2160742,'1','176','920',409,'Retail sales',0.00,0.00,0.00,376.50,0.00,'2021-12-04 17:56:04','',''),(2162046,'1','176','920',409,'Retail Sale Id 1278660',25002.00,0.00,0.00,0.00,750.06,'2021-12-05 06:10:39','',''),(2162047,'1','176','920',409,'Retail sales',0.00,0.00,0.00,41.67,0.00,'2021-12-05 06:10:39','',''),(2162119,'1','176','920',409,'Retail Sale Id 1278697',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 06:20:15','',''),(2162120,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 06:20:15','',''),(2162156,'1','176','920',409,'Retail Sale Id 1278712',90000.00,0.00,0.00,0.00,2700.00,'2021-12-05 06:23:38','',''),(2162157,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 06:23:38','',''),(2162278,'1','176','920',409,'Retail Sale Id 1278769',8400.00,0.00,0.00,0.00,252.00,'2021-12-05 06:35:45','',''),(2162279,'1','176','920',409,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-05 06:35:45','',''),(2162780,'1','176','920',409,'Retail Sale Id 1279009',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 07:03:50','',''),(2162781,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 07:03:50','',''),(2162805,'1','176','920',409,'Retail Sale Id 1279017',90000.00,0.00,0.00,0.00,2700.00,'2021-12-05 07:05:15','',''),(2162806,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 07:05:15','',''),(2163207,'1','176','920',409,'Retail Sale Id 1279264',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:28:11','',''),(2163208,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:28:11','',''),(2163232,'1','176','920',409,'Retail Sale Id 1279282',8960.00,0.00,0.00,0.00,812.00,'2021-12-05 07:29:27','',''),(2163233,'1','176','920',409,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-05 07:29:27','',''),(2163332,'1','176','920',409,'Retail Sale Id 1279338',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 07:36:42','',''),(2163333,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:36:42','',''),(2163393,'1','176','920',409,'Retail Sale Id 1279384',12000.00,0.00,0.00,0.00,360.00,'2021-12-05 07:39:29','',''),(2163394,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-05 07:39:29','',''),(2163431,'1','176','920',409,'Retail Sale Id 1279400',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:41:31','',''),(2163432,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:41:31','',''),(2163465,'1','176','920',409,'Retail Sale Id 1279417',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 07:43:38','',''),(2163466,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 07:43:38','',''),(2163485,'1','176','920',409,'Retail Sale Id 1279427',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 07:44:48','',''),(2163486,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:44:48','',''),(2163499,'1','176','920',409,'Retail Sale Id 1279436',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:46:10','',''),(2163500,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:46:10','',''),(2163663,'1','176','920',409,'Retail Sale Id 1279514',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 07:54:08','',''),(2163664,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:54:08','',''),(2163691,'1','176','920',409,'Retail Sale Id 1279531',6400.00,0.00,0.00,0.00,580.00,'2021-12-05 07:55:57','',''),(2163692,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 07:55:57','',''),(2163726,'1','176','920',409,'Retail Sale Id 1279541',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 07:58:05','',''),(2163727,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 07:58:05','',''),(2163772,'1','176','920',409,'Retail Sale Id 1279570',36600.00,0.00,0.00,0.00,1098.00,'2021-12-05 08:00:36','',''),(2163773,'1','176','920',409,'Retail sales',0.00,0.00,0.00,61.00,0.00,'2021-12-05 08:00:36','',''),(2163898,'1','176','920',409,'Retail Sale Id 1279646',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 08:07:22','',''),(2163899,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 08:07:22','',''),(2163962,'1','176','920',409,'Retail Sale Id 1279683',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 08:09:55','',''),(2163963,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:09:55','',''),(2164021,'1','176','920',409,'Retail Sale Id 1279718',1952.00,0.00,0.00,0.00,176.90,'2021-12-05 08:13:21','',''),(2164023,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:13:21','',''),(2164046,'1','176','920',409,'Retail Sale Id 1279741',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:14:59','',''),(2164047,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:14:59','',''),(2164322,'1','176','920',409,'Retail Sale Id 1279882',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 08:27:23','',''),(2164323,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:27:23','',''),(2164388,'1','176','920',409,'Retail Sale Id 1279919',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 08:30:41','',''),(2164389,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 08:30:41','',''),(2164494,'1','176','920',409,'Retail Sale Id 1279970',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 08:36:02','',''),(2164495,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 08:36:02','',''),(2164526,'1','176','920',409,'Retail Sale Id 1279995',31200.00,0.00,0.00,0.00,936.00,'2021-12-05 08:37:42','',''),(2164527,'1','176','920',409,'Retail sales',0.00,0.00,0.00,52.00,0.00,'2021-12-05 08:37:42','',''),(2164829,'1','176','920',409,'Retail Sale Id 1280133',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 08:54:16','',''),(2164830,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:54:16','',''),(2165069,'1','176','920',409,'Retail Sale Id 1280260',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 09:07:26','',''),(2165070,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 09:07:26','',''),(2165181,'1','176','920',409,'Retail Sale Id 1280324',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 09:12:28','',''),(2165182,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 09:12:28','',''),(2165328,'1','176','920',409,'Retail Sale Id 1280432',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 09:21:49','',''),(2165329,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:21:49','',''),(2165486,'1','176','920',409,'Retail Sale Id 1280521',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 09:30:14','',''),(2165487,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:30:14','',''),(2165828,'1','176','920',409,'Retail Sale Id 1280683',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 09:46:01','',''),(2165829,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:46:01','',''),(2165999,'1','176','920',409,'Retail Sale Id 1280755',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 09:53:22','',''),(2166000,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 09:53:22','',''),(2166118,'1','176','920',409,'Retail Sale Id 1280817',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 10:00:26','',''),(2166119,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 10:00:26','',''),(2166167,'1','176','920',409,'Retail Sale Id 1280846',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 10:03:46','',''),(2166168,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:03:46','',''),(2166419,'1','176','920',409,'Retail Sale Id 1280974',1280.00,0.00,0.00,0.00,116.00,'2021-12-05 10:20:40','',''),(2166420,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:20:40','',''),(2166542,'1','176','920',409,'Retail Sale Id 1281034',27000.00,0.00,0.00,0.00,810.00,'2021-12-05 10:28:20','',''),(2166543,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 10:28:20','',''),(2166959,'1','176','920',409,'Retail Sale Id 1281254',1952.00,0.00,0.00,0.00,176.90,'2021-12-05 10:52:00','',''),(2166960,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 10:52:00','',''),(2167164,'1','176','920',409,'Retail Sale Id 1281358',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 11:04:51','',''),(2167165,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 11:04:51','',''),(2167376,'1','176','920',409,'Retail Sale Id 1281484',1952.00,0.00,0.00,0.00,176.90,'2021-12-05 11:17:26','',''),(2167377,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 11:17:26','',''),(2167524,'1','176','920',409,'Retail Sale Id 1281548',15000.00,0.00,0.00,0.00,450.00,'2021-12-05 11:25:43','',''),(2167525,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 11:25:43','',''),(2167563,'1','176','920',409,'Retail Sale Id 1281567',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 11:27:54','',''),(2167564,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:27:54','',''),(2167671,'1','176','920',409,'Retail Sale Id 1281614',19998.00,0.00,0.00,0.00,599.94,'2021-12-05 11:32:27','',''),(2167672,'1','176','920',409,'Retail sales',0.00,0.00,0.00,33.33,0.00,'2021-12-05 11:32:27','',''),(2168059,'1','176','920',409,'Retail Sale Id 1281866',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 11:56:18','',''),(2168060,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 11:56:18','',''),(2168172,'1','176','920',409,'Retail Sale Id 1281923',1401.60,0.00,0.00,0.00,127.02,'2021-12-05 12:02:51','',''),(2168173,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-05 12:02:51','',''),(2168220,'1','176','920',409,'Retail Sale Id 1281947',36000.00,0.00,0.00,0.00,1080.00,'2021-12-05 12:05:25','',''),(2168221,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 12:05:25','',''),(2168490,'1','176','920',409,'Retail Sale Id 1282082',36000.00,0.00,0.00,0.00,1080.00,'2021-12-05 12:17:53','',''),(2168491,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 12:17:53','',''),(2168935,'1','176','920',409,'Retail Sale Id 1282306',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 12:37:51','',''),(2168936,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:37:51','',''),(2169019,'1','176','920',409,'Retail Sale Id 1282324',214500.00,0.00,0.00,0.00,6435.00,'2021-12-05 12:42:14','',''),(2169020,'1','176','920',409,'Retail sales',0.00,0.00,0.00,357.50,0.00,'2021-12-05 12:42:14','',''),(2169608,'1','176','920',409,'Retail Sale Id 1282692',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 13:15:57','',''),(2169609,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 13:15:57','',''),(2169648,'1','176','920',409,'Retail Sale Id 1282703',4998.40,0.00,0.00,0.00,452.98,'2021-12-05 13:17:42','',''),(2169649,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 13:17:42','',''),(2169666,'1','176','920',409,'Retail Sale Id 1282713',1280.00,0.00,0.00,0.00,116.00,'2021-12-05 13:18:53','',''),(2169667,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:18:53','',''),(2169696,'1','176','920',409,'Retail Sale Id 1282730',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 13:20:40','',''),(2169697,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:20:40','',''),(2170182,'1','176','920',409,'Retail Sale Id 1282931',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 13:45:13','',''),(2170183,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:45:13','',''),(2170802,'1','176','920',409,'Retail Sale Id 1283198',69000.00,0.00,0.00,0.00,2070.00,'2021-12-05 14:17:42','',''),(2170803,'1','176','920',409,'Retail sales',0.00,0.00,0.00,115.00,0.00,'2021-12-05 14:17:42','',''),(2170931,'1','176','920',409,'Retail Sale Id 1283254',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 14:24:42','',''),(2170932,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:24:42','',''),(2170995,'1','176','920',409,'Retail Sale Id 1283287',53874.00,0.00,0.00,0.00,1616.22,'2021-12-05 14:29:14','',''),(2170996,'1','176','920',409,'Retail sales',0.00,0.00,0.00,89.79,0.00,'2021-12-05 14:29:14','',''),(2171025,'1','176','920',409,'Retail Sale Id 1283296',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:30:27','',''),(2171026,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:30:27','',''),(2171201,'1','176','920',409,'Retail Sale Id 1283343',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 14:37:10','',''),(2171202,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 14:37:10','',''),(2171261,'1','176','920',409,'Retail Sale Id 1283372',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:42:09','',''),(2171262,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:42:09','',''),(2171399,'1','176','920',409,'Retail Sale Id 1283425',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:49:57','',''),(2171400,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:49:57','',''),(2171413,'1','176','920',409,'Retail Sale Id 1283431',6400.00,0.00,0.00,0.00,580.00,'2021-12-05 14:50:54','',''),(2171414,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:50:54','',''),(2171441,'1','176','920',409,'Retail Sale Id 1283445',35400.00,0.00,0.00,0.00,1062.00,'2021-12-05 14:52:09','',''),(2171442,'1','176','920',409,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-05 14:52:09','',''),(2171605,'1','176','920',409,'Retail Sale Id 1283529',90000.00,0.00,0.00,0.00,2700.00,'2021-12-05 15:05:24','',''),(2171606,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 15:05:24','',''),(2171737,'1','176','920',409,'Retail Sale Id 1283601',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 15:16:15','',''),(2171738,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:16:15','',''),(2171782,'1','176','920',409,'Retail Sale Id 1283618',13800.00,0.00,0.00,0.00,414.00,'2021-12-05 15:18:35','',''),(2171783,'1','176','920',409,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-05 15:18:35','',''),(2171972,'1','176','920',409,'Retail Sale Id 1283705',122100.00,0.00,0.00,0.00,3663.00,'2021-12-05 15:30:51','',''),(2171973,'1','176','920',409,'Retail sales',0.00,0.00,0.00,203.50,0.00,'2021-12-05 15:30:51','',''),(2172082,'1','176','920',409,'Retail Sale Id 1283762',2502.40,0.00,0.00,0.00,226.78,'2021-12-05 15:36:37','',''),(2172083,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 15:36:37','',''),(2172094,'1','176','920',409,'Retail Sale Id 1283769',998.40,0.00,0.00,0.00,90.48,'2021-12-05 15:37:32','',''),(2172095,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:37:32','',''),(2172159,'1','176','920',409,'Retail Sale Id 1283802',2560.00,0.00,0.00,0.00,232.00,'2021-12-05 15:40:35','',''),(2172160,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 15:40:35','',''),(2172201,'1','176','920',409,'Retail Sale Id 1283823',33300.00,0.00,0.00,0.00,999.00,'2021-12-05 15:42:13','',''),(2172202,'1','176','920',409,'Retail sales',0.00,0.00,0.00,55.50,0.00,'2021-12-05 15:42:13','',''),(2172455,'1','176','920',409,'Retail Sale Id 1283962',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 15:55:26','',''),(2172456,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:55:26','',''),(2172466,'1','176','920',409,'Retail Sale Id 1283969',32400.00,0.00,0.00,0.00,972.00,'2021-12-05 15:56:17','',''),(2172467,'1','176','920',409,'Retail sales',0.00,0.00,0.00,54.00,0.00,'2021-12-05 15:56:17','',''),(2172542,'1','176','920',409,'Retail Sale Id 1284000',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 16:00:28','',''),(2172543,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:00:28','',''),(2172576,'1','176','920',409,'Retail Sale Id 1284022',17400.00,0.00,0.00,0.00,522.00,'2021-12-05 16:03:09','',''),(2172577,'1','176','920',409,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-05 16:03:09','',''),(2172610,'1','176','920',409,'Retail Sale Id 1284040',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 16:04:42','',''),(2172611,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:04:42','',''),(2172822,'1','176','920',409,'Retail Sale Id 1284148',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 16:18:53','',''),(2172823,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:18:53','',''),(2173099,'1','176','920',409,'Retail Sale Id 1284300',1952.00,0.00,0.00,0.00,176.90,'2021-12-05 16:35:48','',''),(2173100,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:35:48','',''),(2173123,'1','176','920',409,'Retail Sale Id 1284313',15000.00,0.00,0.00,0.00,450.00,'2021-12-05 16:37:07','',''),(2173124,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 16:37:07','',''),(2173289,'1','176','920',409,'Retail Sale Id 1284399',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 16:46:48','',''),(2173290,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:46:48','',''),(2173305,'1','176','920',409,'Retail Sale Id 1284408',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 16:47:59','',''),(2173306,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 16:47:59','',''),(2173319,'1','176','920',409,'Retail Sale Id 1284417',2502.40,0.00,0.00,0.00,226.78,'2021-12-05 16:49:21','',''),(2173320,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 16:49:21','',''),(2173353,'1','176','920',409,'Retail Sale Id 1284431',2560.00,0.00,0.00,0.00,232.00,'2021-12-05 16:50:46','',''),(2173354,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 16:50:46','',''),(2173411,'1','176','920',409,'Retail Sale Id 1284463',998.40,0.00,0.00,0.00,90.48,'2021-12-05 16:54:45','',''),(2173412,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:54:45','',''),(2173433,'1','176','920',409,'Retail Sale Id 1284473',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 16:56:15','',''),(2173434,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:56:15','',''),(2173471,'1','176','920',409,'Retail Sale Id 1284496',27000.00,0.00,0.00,0.00,810.00,'2021-12-05 16:58:30','',''),(2173472,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 16:58:30','',''),(2173533,'1','176','920',409,'Retail Sale Id 1284525',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 17:02:57','',''),(2173534,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 17:02:57','',''),(2173562,'1','176','920',409,'Retail Sale Id 1284537',1952.00,0.00,0.00,0.00,176.90,'2021-12-05 17:04:55','',''),(2173563,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 17:04:55','',''),(2173606,'1','176','920',409,'Retail Sale Id 1284552',27600.00,0.00,0.00,0.00,828.00,'2021-12-05 17:06:51','',''),(2173607,'1','176','920',409,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-05 17:06:51','',''),(2173618,'1','176','920',409,'Retail Sale Id 1284559',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 17:07:53','',''),(2173619,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 17:07:53','',''),(2173688,'1','176','920',409,'Retail Sale Id 1284588',39600.00,0.00,0.00,0.00,1188.00,'2021-12-05 17:13:57','',''),(2173689,'1','176','920',409,'Retail sales',0.00,0.00,0.00,66.00,0.00,'2021-12-05 17:13:57','',''),(2173912,'1','176','920',409,'Retail Sale Id 1284698',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 17:32:20','',''),(2173913,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 17:32:20','',''),(2173924,'1','176','920',409,'Retail Sale Id 1284703',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 17:33:17','',''),(2173925,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:33:17','',''),(2174010,'1','176','920',409,'Retail Sale Id 1284749',15000.00,0.00,0.00,0.00,450.00,'2021-12-05 17:43:47','',''),(2174011,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 17:43:47','',''),(2174054,'1','176','920',409,'Retail Sale Id 1284771',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 17:50:20','',''),(2174055,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 17:50:20','',''),(2174913,'1','176','920',409,'Retail Sale Id 1284967',237000.00,0.00,0.00,0.00,7110.00,'2021-12-06 06:25:38','',''),(2174914,'1','176','920',409,'Retail sales',0.00,0.00,0.00,395.00,0.00,'2021-12-06 06:25:38','',''),(2175077,'1','176','920',409,'Retail Sale Id 1285014',90000.00,0.00,0.00,0.00,2700.00,'2021-12-06 06:38:34','',''),(2175078,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 06:38:34','',''),(2175089,'1','176','920',409,'Retail Sale Id 1285020',27000.00,0.00,0.00,0.00,810.00,'2021-12-06 06:39:53','',''),(2175090,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 06:39:53','',''),(2175270,'1','176','920',409,'Retail Sale Id 1285115',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 06:55:26','',''),(2175271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:55:26','',''),(2175927,'1','176','920',409,'Retail Sale Id 1285419',82698.00,0.00,0.00,0.00,2480.94,'2021-12-06 07:35:14','',''),(2175928,'1','176','920',409,'Retail sales',0.00,0.00,0.00,137.83,0.00,'2021-12-06 07:35:14','',''),(2176426,'1','176','920',409,'Distributed to operational loss for sales id:337418',170758.80,0.00,0.00,293.40,0.00,'2021-12-06 07:57:33','',''),(2176842,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2368000.00,4000.00,0.00,0.00,'2021-12-06 08:25:28','',''),(2176855,'1','176',NULL,409,'Reception corrector for bridging 126357',0.00,0.00,0.00,4000.00,0.00,'2021-12-06 08:26:29','',''),(2176856,'1','176','920',409,'Received from bridging 126357',0.00,0.00,4000.00,0.00,0.00,'2021-12-06 08:26:29','',''),(2177247,'1','176','920',409,'Retail Sale Id 1286068',18000.00,0.00,0.00,0.00,240.00,'2021-12-06 08:56:02','',''),(2177248,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 08:56:02','',''),(2177270,'1','176','920',409,'Retail Sale Id 1286077',42000.00,0.00,0.00,0.00,560.00,'2021-12-06 08:57:46','',''),(2177271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-06 08:57:46','',''),(2177369,'1','176','920',409,'Retail Sale Id 1286121',11520.00,0.00,0.00,0.00,864.00,'2021-12-06 09:05:15','',''),(2177370,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-06 09:05:15','',''),(2177415,'1','176','920',409,'Retail Sale Id 1286142',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 09:07:28','',''),(2177416,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:07:28','',''),(2177461,'1','176','920',409,'Retail Sale Id 1286166',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 09:11:00','',''),(2177462,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 09:11:00','',''),(2177473,'1','176','920',409,'Retail Sale Id 1286171',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:12:05','',''),(2177474,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:12:05','',''),(2177516,'1','176','920',409,'Retail Sale Id 1286186',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 09:14:56','',''),(2177517,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:14:56','',''),(2177562,'1','176','920',409,'Retail Sale Id 1286208',90000.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:18:06','',''),(2177563,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 09:18:06','',''),(2177608,'1','176','920',409,'Retail Sale Id 1286232',28800.00,0.00,0.00,0.00,384.00,'2021-12-06 09:21:12','',''),(2177609,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-06 09:21:12','',''),(2177670,'1','176','920',409,'Retail Sale Id 1286262',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:25:14','',''),(2177671,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:25:14','',''),(2177723,'1','176','920',409,'Retail Sale Id 1286290',120000.00,0.00,0.00,0.00,1600.00,'2021-12-06 09:28:05','',''),(2177724,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-06 09:28:05','',''),(2178198,'1','176','920',409,'Retail Sale Id 1286491',33000.00,0.00,0.00,0.00,440.00,'2021-12-06 09:56:08','',''),(2178199,'1','176','920',409,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 09:56:08','',''),(2178234,'1','176','920',409,'Retail Sale Id 1286517',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 09:59:38','',''),(2178235,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:59:38','',''),(2178366,'1','176','920',409,'Retail Sale Id 1286572',25600.00,0.00,0.00,0.00,1920.00,'2021-12-06 10:06:43','',''),(2178367,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 10:06:43','',''),(2178441,'1','176','920',409,'Retail Sale Id 1286601',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 10:09:58','',''),(2178442,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:09:58','',''),(2178529,'1','176','920',409,'Retail Sale Id 1286653',90000.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:15:44','',''),(2178530,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 10:15:44','',''),(2178547,'1','176','920',409,'Retail Sale Id 1286660',57000.00,0.00,0.00,0.00,760.00,'2021-12-06 10:16:48','',''),(2178548,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-06 10:16:48','',''),(2178585,'1','176','920',409,'Retail Sale Id 1286681',34998.00,0.00,0.00,0.00,466.64,'2021-12-06 10:20:01','',''),(2178586,'1','176','920',409,'Retail sales',0.00,0.00,0.00,58.33,0.00,'2021-12-06 10:20:01','',''),(2178705,'1','176','920',409,'Retail Sale Id 1286737',18000.00,0.00,0.00,0.00,240.00,'2021-12-06 10:28:17','',''),(2178706,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 10:28:17','',''),(2178790,'1','176','920',409,'Retail Sale Id 1286782',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:33:44','',''),(2178791,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:33:44','',''),(2178838,'1','176','920',409,'Retail Sale Id 1286817',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:37:31','',''),(2178839,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 10:37:31','',''),(2178980,'1','176','920',409,'Retail Sale Id 1286892',78000.00,0.00,0.00,0.00,1040.00,'2021-12-06 10:46:32','',''),(2178981,'1','176','920',409,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-06 10:46:32','',''),(2179000,'1','176','920',409,'Retail Sale Id 1286904',24000.00,0.00,0.00,0.00,1800.00,'2021-12-06 10:47:45','',''),(2179001,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-06 10:47:45','',''),(2179040,'1','176','920',409,'Retail Sale Id 1286930',60000.00,0.00,0.00,0.00,800.00,'2021-12-06 10:50:06','',''),(2179041,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 10:50:06','',''),(2179066,'1','176','920',409,'Retail Sale Id 1286946',90000.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:51:29','',''),(2179067,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 10:51:29','',''),(2179251,'1','176','920',409,'Retail Sale Id 1287055',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 11:03:24','',''),(2179252,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:03:24','',''),(2179283,'1','176','920',409,'Retail Sale Id 1287074',24000.00,0.00,0.00,0.00,320.00,'2021-12-06 11:05:07','',''),(2179284,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 11:05:07','',''),(2179423,'1','176','920',409,'Retail Sale Id 1287144',60600.00,0.00,0.00,0.00,808.00,'2021-12-06 11:13:17','',''),(2179424,'1','176','920',409,'Retail sales',0.00,0.00,0.00,101.00,0.00,'2021-12-06 11:13:17','',''),(2179683,'1','176','920',409,'Retail Sale Id 1287292',5760.00,0.00,0.00,0.00,432.00,'2021-12-06 11:30:26','',''),(2179684,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 11:30:26','',''),(2179900,'1','176','920',409,'Retail Sale Id 1287465',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 11:47:41','',''),(2179901,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 11:47:41','',''),(2179914,'1','176','920',409,'Retail Sale Id 1287473',120000.00,0.00,0.00,0.00,1600.00,'2021-12-06 11:48:49','',''),(2179915,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-06 11:48:49','',''),(2179934,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,828800.00,1400.00,0.00,0.00,'2021-12-06 11:50:03','',''),(2179944,'1','176',NULL,409,'Reception corrector for bridging 126370',0.00,0.00,0.00,1400.00,0.00,'2021-12-06 11:50:59','',''),(2179945,'1','176','920',409,'Received from bridging 126370',0.00,0.00,1400.00,0.00,0.00,'2021-12-06 11:50:59','',''),(2180108,'1','176','920',409,'Retail Sale Id 1287572',13200.00,0.00,0.00,0.00,176.00,'2021-12-06 12:01:43','',''),(2180109,'1','176','920',409,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-06 12:01:43','',''),(2180128,'1','176','920',409,'Retail Sale Id 1287582',132000.00,0.00,0.00,0.00,1760.00,'2021-12-06 12:03:03','',''),(2180129,'1','176','920',409,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-06 12:03:03','',''),(2180246,'1','176','920',409,'Retail Sale Id 1287640',10002.00,0.00,0.00,0.00,133.36,'2021-12-06 12:09:51','',''),(2180247,'1','176','920',409,'Retail sales',0.00,0.00,0.00,16.67,0.00,'2021-12-06 12:09:51','',''),(2180736,'1','176','920',409,'Retail Sale Id 1287912',39000.00,0.00,0.00,0.00,520.00,'2021-12-06 12:39:28','',''),(2180737,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-06 12:39:28','',''),(2181114,'1','176','920',409,'Retail Sale Id 1288100',21000.00,0.00,0.00,0.00,280.00,'2021-12-06 13:01:33','',''),(2181115,'1','176','920',409,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-06 13:01:33','',''),(2181158,'1','176','920',409,'Retail Sale Id 1288124',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:04:39','',''),(2181159,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:04:39','',''),(2181264,'1','176','920',409,'Retail Sale Id 1288187',60000.00,0.00,0.00,0.00,800.00,'2021-12-06 13:10:37','',''),(2181265,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 13:10:37','',''),(2181294,'1','176','920',409,'Retail Sale Id 1288202',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:12:26','',''),(2181295,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:12:26','',''),(2181326,'1','176','920',409,'Retail Sale Id 1288216',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 13:14:23','',''),(2181327,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 13:14:23','',''),(2181369,'1','176','920',409,'Retail Sale Id 1288233',58800.00,0.00,0.00,0.00,784.00,'2021-12-06 13:15:49','',''),(2181370,'1','176','920',409,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-06 13:15:49','',''),(2181712,'1','176','920',409,'Retail Sale Id 1288367',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 13:36:14','',''),(2181713,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 13:36:14','',''),(2182200,'1','176','920',409,'Retail Sale Id 1288600',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:59:54','',''),(2182201,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:59:54','',''),(2182393,'1','176','920',409,'Retail Sale Id 1288686',5760.00,0.00,0.00,0.00,432.00,'2021-12-06 14:08:56','',''),(2182394,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 14:08:56','',''),(2182654,'1','176','920',409,'Retail Sale Id 1288796',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 14:20:18','',''),(2182655,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:20:18','',''),(2182934,'1','176','920',409,'Retail Sale Id 1288938',181200.00,0.00,0.00,0.00,2416.00,'2021-12-06 14:35:43','',''),(2182935,'1','176','920',409,'Retail sales',0.00,0.00,0.00,302.00,0.00,'2021-12-06 14:35:43','',''),(2182978,'1','176','920',409,'Retail Sale Id 1288959',15000.00,0.00,0.00,0.00,200.00,'2021-12-06 14:38:27','',''),(2182979,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 14:38:27','',''),(2182996,'1','176','920',409,'Retail Sale Id 1288969',7998.00,0.00,0.00,0.00,106.64,'2021-12-06 14:39:44','',''),(2182997,'1','176','920',409,'Retail sales',0.00,0.00,0.00,13.33,0.00,'2021-12-06 14:39:44','',''),(2183224,'1','176','920',409,'Retail Sale Id 1289052',120000.00,0.00,0.00,0.00,1600.00,'2021-12-06 14:49:55','',''),(2183225,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-06 14:49:55','',''),(2183266,'1','176','920',409,'Retail Sale Id 1289072',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:51:58','',''),(2183267,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:51:58','',''),(2183584,'1','176','920',409,'Retail Sale Id 1289232',15000.00,0.00,0.00,0.00,200.00,'2021-12-06 15:09:14','',''),(2183585,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 15:09:14','',''),(2183758,'1','176','920',409,'Retail Sale Id 1289309',60000.00,0.00,0.00,0.00,800.00,'2021-12-06 15:18:59','',''),(2183759,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 15:18:59','',''),(2184520,'1','176','920',409,'Retail Sale Id 1289624',109062.00,0.00,0.00,0.00,1454.16,'2021-12-06 15:51:03','',''),(2184521,'1','176','920',409,'Retail sales',0.00,0.00,0.00,181.77,0.00,'2021-12-06 15:51:03','',''),(2185033,'1','176','920',409,'Retail Sale Id 1289865',19002.00,0.00,0.00,0.00,253.36,'2021-12-06 16:20:58','',''),(2185034,'1','176','920',409,'Retail sales',0.00,0.00,0.00,31.67,0.00,'2021-12-06 16:20:58','',''),(2185077,'1','176','920',409,'Retail Sale Id 1289885',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:23:02','',''),(2185078,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:23:02','',''),(2185116,'1','176','920',409,'Retail Sale Id 1289902',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:24:42','',''),(2185117,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:24:42','',''),(2185409,'1','176','920',409,'Retail Sale Id 1290042',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:40:02','',''),(2185410,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:40:02','',''),(2185440,'1','176','920',409,'Retail Sale Id 1290058',60000.00,0.00,0.00,0.00,800.00,'2021-12-06 16:41:50','',''),(2185441,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 16:41:50','',''),(2185470,'1','176','920',409,'Retail Sale Id 1290074',28800.00,0.00,0.00,0.00,384.00,'2021-12-06 16:44:03','',''),(2185471,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-06 16:44:03','',''),(2185492,'1','176','920',409,'Retail Sale Id 1290086',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:45:42','',''),(2185493,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:45:42','',''),(2185533,'1','176','920',409,'Retail Sale Id 1290105',26400.00,0.00,0.00,0.00,352.00,'2021-12-06 16:47:26','',''),(2185534,'1','176','920',409,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-06 16:47:26','',''),(2185648,'1','176','920',409,'Retail Sale Id 1290153',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 16:52:28','',''),(2185649,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:52:28','',''),(2185690,'1','176','920',409,'Retail Sale Id 1290184',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 16:55:24','',''),(2185691,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 16:55:24','',''),(2185828,'1','176','920',409,'Retail Sale Id 1290262',34200.00,0.00,0.00,0.00,456.00,'2021-12-06 17:04:25','',''),(2185829,'1','176','920',409,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-06 17:04:25','',''),(2187086,'1','176','920',409,'Retail Sale Id 1290628',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 05:47:23','',''),(2187087,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 05:47:23','',''),(2187102,'1','176','920',409,'Retail Sale Id 1290636',19500.00,0.00,0.00,0.00,260.00,'2021-12-07 05:53:44','',''),(2187103,'1','176','920',409,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-07 05:53:44','',''),(2187236,'1','176','920',409,'Retail Sale Id 1290705',148200.00,0.00,0.00,0.00,1976.00,'2021-12-07 06:09:05','',''),(2187237,'1','176','920',409,'Retail sales',0.00,0.00,0.00,247.00,0.00,'2021-12-07 06:09:05','',''),(2187289,'1','176','920',409,'Retail Sale Id 1290728',28998.00,0.00,0.00,0.00,386.64,'2021-12-07 06:13:38','',''),(2187290,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.33,0.00,'2021-12-07 06:13:38','',''),(2187301,'1','176','920',409,'Retail Sale Id 1290734',28800.00,0.00,0.00,0.00,2160.00,'2021-12-07 06:14:59','',''),(2187302,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 06:14:59','',''),(2187348,'1','176','920',409,'Retail Sale Id 1290758',105000.00,0.00,0.00,0.00,1400.00,'2021-12-07 06:19:47','',''),(2187349,'1','176','920',409,'Retail sales',0.00,0.00,0.00,175.00,0.00,'2021-12-07 06:19:47','',''),(2187430,'1','176','920',409,'Retail Sale Id 1290798',90000.00,0.00,0.00,0.00,1200.00,'2021-12-07 06:26:08','',''),(2187431,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 06:26:08','',''),(2187924,'1','176','920',409,'Retail Sale Id 1291035',57000.00,0.00,0.00,0.00,760.00,'2021-12-07 06:59:50','',''),(2187925,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-07 06:59:50','',''),(2187956,'1','176','920',409,'Retail Sale Id 1291051',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:01:09','',''),(2187957,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:01:09','',''),(2188002,'1','176','920',409,'Retail Sale Id 1291077',28002.00,0.00,0.00,0.00,373.36,'2021-12-07 07:03:43','',''),(2188003,'1','176','920',409,'Retail sales',0.00,0.00,0.00,46.67,0.00,'2021-12-07 07:03:43','',''),(2188036,'1','176','920',409,'Retail Sale Id 1291093',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 07:05:14','',''),(2188037,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:05:14','',''),(2188062,'1','176','920',409,'Retail Sale Id 1291106',23400.00,0.00,0.00,0.00,312.00,'2021-12-07 07:06:22','',''),(2188063,'1','176','920',409,'Retail sales',0.00,0.00,0.00,39.00,0.00,'2021-12-07 07:06:22','',''),(2188100,'1','176','920',409,'Retail Sale Id 1291120',60000.00,0.00,0.00,0.00,800.00,'2021-12-07 07:07:55','',''),(2188101,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 07:07:55','',''),(2188754,'1','176','920',409,'Retail Sale Id 1291453',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:39:03','',''),(2188755,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:39:03','',''),(2190172,'1','176','920',409,'Retail Sale Id 1292129',166200.00,0.00,0.00,0.00,2216.00,'2021-12-07 08:55:35','',''),(2190173,'1','176','920',409,'Retail sales',0.00,0.00,0.00,277.00,0.00,'2021-12-07 08:55:35','',''),(2190264,'1','176','920',409,'Distributed to operational loss for sales id:337675',49064.96,0.00,0.00,82.88,0.00,'2021-12-07 09:02:29','',''),(2192122,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2960000.00,5000.00,0.00,0.00,'2021-12-07 10:54:23','',''),(2192173,'1','176',NULL,409,'Reception corrector for bridging 126459',0.00,0.00,0.00,5000.00,0.00,'2021-12-07 10:57:27','',''),(2192174,'1','176','920',409,'Received from bridging 126459',0.00,0.00,5000.00,0.00,0.00,'2021-12-07 10:57:27','',''),(2192207,'1','176','920',409,'Retail Sale Id 1293143',27000.00,0.00,0.00,0.00,360.00,'2021-12-07 10:59:10','',''),(2192208,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 10:59:10','',''),(2192233,'1','176','920',409,'Retail Sale Id 1293153',145200.00,0.00,0.00,0.00,1936.00,'2021-12-07 11:00:46','',''),(2192234,'1','176','920',409,'Retail sales',0.00,0.00,0.00,242.00,0.00,'2021-12-07 11:00:46','',''),(2192310,'1','176','920',409,'Retail Sale Id 1293181',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:03:50','',''),(2192311,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:03:50','',''),(2192330,'1','176','920',409,'Retail Sale Id 1293192',25200.00,0.00,0.00,0.00,336.00,'2021-12-07 11:05:02','',''),(2192331,'1','176','920',409,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-07 11:05:02','',''),(2192382,'1','176','920',409,'Retail Sale Id 1293212',120000.00,0.00,0.00,0.00,1600.00,'2021-12-07 11:07:47','',''),(2192383,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-07 11:07:47','',''),(2192460,'1','176','920',409,'Retail Sale Id 1293253',120000.00,0.00,0.00,0.00,1600.00,'2021-12-07 11:11:14','',''),(2192461,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-07 11:11:14','',''),(2192498,'1','176','920',409,'Retail Sale Id 1293281',9000.00,0.00,0.00,0.00,120.00,'2021-12-07 11:13:29','',''),(2192499,'1','176','920',409,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 11:13:29','',''),(2192530,'1','176','920',409,'Retail Sale Id 1293301',60000.00,0.00,0.00,0.00,800.00,'2021-12-07 11:16:06','',''),(2192531,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 11:16:06','',''),(2192570,'1','176','920',409,'Retail Sale Id 1293321',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 11:18:44','',''),(2192571,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 11:18:44','',''),(2192696,'1','176','920',409,'Retail Sale Id 1293412',28800.00,0.00,0.00,0.00,384.00,'2021-12-07 11:28:46','',''),(2192697,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-07 11:28:46','',''),(2193231,'1','176','920',409,'Retail Sale Id 1293685',39000.00,0.00,0.00,0.00,520.00,'2021-12-07 12:11:15','',''),(2193232,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-07 12:11:15','',''),(2193419,'1','176','920',409,'Retail Sale Id 1293795',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 12:28:51','',''),(2193420,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 12:28:51','',''),(2193505,'1','176','920',409,'Retail Sale Id 1293826',90000.00,0.00,0.00,0.00,1200.00,'2021-12-07 12:34:46','',''),(2193506,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 12:34:46','',''),(2193545,'1','176','920',409,'Retail Sale Id 1293855',10002.00,0.00,0.00,0.00,133.36,'2021-12-07 12:37:44','',''),(2193546,'1','176','920',409,'Retail sales',0.00,0.00,0.00,16.67,0.00,'2021-12-07 12:37:44','',''),(2193573,'1','176','920',409,'Retail Sale Id 1293868',88800.00,0.00,0.00,0.00,1184.00,'2021-12-07 12:40:05','',''),(2193574,'1','176','920',409,'Retail sales',0.00,0.00,0.00,148.00,0.00,'2021-12-07 12:40:05','',''),(2193723,'1','176','920',409,'Retail Sale Id 1293963',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 12:51:13','',''),(2193724,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 12:51:13','',''),(2193861,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,124320.00,210.00,0.00,0.00,'2021-12-07 12:59:41','',''),(2193889,'1','176',NULL,409,'Reception corrector for bridging 126468',0.00,0.00,0.00,210.00,0.00,'2021-12-07 13:00:40','',''),(2193890,'1','176','920',409,'Received from bridging 126468',0.00,0.00,210.00,0.00,0.00,'2021-12-07 13:00:40','',''),(2194003,'1','176','920',409,'Retail Sale Id 1294098',120000.00,0.00,0.00,0.00,1600.00,'2021-12-07 13:09:45','',''),(2194004,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-07 13:09:45','',''),(2194157,'1','176','920',409,'Retail Sale Id 1294177',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:19:13','',''),(2194158,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:19:13','',''),(2194235,'1','176','920',409,'Retail Sale Id 1294277',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 13:24:47','',''),(2194236,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 13:24:47','',''),(2194776,'1','176','920',409,'Retail Sale Id 1294520',90000.00,0.00,0.00,0.00,1200.00,'2021-12-07 13:53:43','',''),(2194777,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 13:53:43','',''),(2194929,'1','176','920',409,'Retail Sale Id 1294603',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:04:22','',''),(2194930,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:04:22','',''),(2195043,'1','176','920',409,'Retail Sale Id 1294656',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 14:10:54','',''),(2195044,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 14:10:54','',''),(2195216,'1','176','920',409,'Retail Sale Id 1294710',9000.00,0.00,0.00,0.00,120.00,'2021-12-07 14:19:06','',''),(2195217,'1','176','920',409,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 14:19:06','',''),(2195442,'1','176','920',409,'Retail Sale Id 1294819',998.40,0.00,0.00,0.00,74.88,'2021-12-07 14:31:32','',''),(2195443,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 14:31:32','',''),(2195452,'1','176','920',409,'Retail Sale Id 1294824',5760.00,0.00,0.00,0.00,432.00,'2021-12-07 14:32:32','',''),(2195453,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 14:32:32','',''),(2195651,'1','176','920',409,'Retail Sale Id 1294941',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 14:43:35','',''),(2195652,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 14:43:35','',''),(2195784,'1','176','920',409,'Retail Sale Id 1295004',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 14:50:06','',''),(2195785,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 14:50:06','',''),(2195846,'1','176','920',409,'Retail Sale Id 1295041',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 14:52:38','',''),(2195847,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 14:52:38','',''),(2195882,'1','176','920',409,'Retail Sale Id 1295064',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 14:55:04','',''),(2195883,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:55:04','',''),(2196228,'1','176','920',409,'Retail Sale Id 1295226',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 15:14:25','',''),(2196229,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:14:25','',''),(2196250,'1','176','920',409,'Retail Sale Id 1295236',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 15:15:35','',''),(2196251,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:15:35','',''),(2196270,'1','176','920',409,'Retail Sale Id 1295246',998.40,0.00,0.00,0.00,74.88,'2021-12-07 15:16:35','',''),(2196271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:16:35','',''),(2196326,'1','176','920',409,'Retail Sale Id 1295275',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 15:20:02','',''),(2196327,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:20:02','',''),(2196630,'1','176','920',409,'Retail Sale Id 1295434',16002.00,0.00,0.00,0.00,213.36,'2021-12-07 15:35:14','',''),(2196631,'1','176','920',409,'Retail sales',0.00,0.00,0.00,26.67,0.00,'2021-12-07 15:35:14','',''),(2196841,'1','176','920',409,'Retail Sale Id 1295531',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 15:44:42','',''),(2196842,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 15:44:42','',''),(2196947,'1','176','920',409,'Retail Sale Id 1295587',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 15:50:01','',''),(2196948,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 15:50:01','',''),(2197117,'1','176','920',409,'Retail Sale Id 1295673',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 15:57:17','',''),(2197118,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:57:17','',''),(2197135,'1','176','920',409,'Retail Sale Id 1295683',39000.00,0.00,0.00,0.00,520.00,'2021-12-07 15:58:18','',''),(2197136,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-07 15:58:18','',''),(2197474,'1','176','920',409,'Retail Sale Id 1295863',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 16:15:25','',''),(2197475,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 16:15:25','',''),(2197619,'1','176','920',409,'Retail Sale Id 1295941',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 16:21:11','',''),(2197620,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 16:21:11','',''),(2197823,'1','176','920',409,'Retail Sale Id 1296046',25200.00,0.00,0.00,0.00,336.00,'2021-12-07 16:30:55','',''),(2197824,'1','176','920',409,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-07 16:30:55','',''),(2198053,'1','176','920',409,'Retail Sale Id 1296173',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:45:01','',''),(2198054,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:45:01','',''),(2198100,'1','176','920',409,'Retail Sale Id 1296195',1798.40,0.00,0.00,0.00,134.88,'2021-12-07 16:47:51','',''),(2198101,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 16:47:51','',''),(2198166,'1','176','920',409,'Retail Sale Id 1296226',998.40,0.00,0.00,0.00,74.88,'2021-12-07 16:51:27','',''),(2198167,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:51:27','',''),(2198296,'1','176','920',409,'Retail Sale Id 1296296',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 16:58:01','',''),(2198297,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 16:58:01','',''),(2198797,'1','176','920',409,'Retail Sale Id 1296558',80400.00,0.00,0.00,0.00,1072.00,'2021-12-07 17:36:47','',''),(2198798,'1','176','920',409,'Retail sales',0.00,0.00,0.00,134.00,0.00,'2021-12-07 17:36:47','',''),(2198954,'1','176','920',409,'Retail Sale Id 1296623',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 17:50:20','',''),(2198955,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 17:50:20','',''),(2199663,'1','176','920',409,'Retail Sale Id 1296764',210000.00,0.00,0.00,0.00,2800.00,'2021-12-08 05:37:37','',''),(2199664,'1','176','920',409,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-08 05:37:37','',''),(2199686,'1','176','920',409,'Retail Sale Id 1296769',27000.00,0.00,0.00,0.00,360.00,'2021-12-08 05:42:21','',''),(2199687,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-08 05:42:21','',''),(2200802,'1','176','920',409,'Retail Sale Id 1297243',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 07:21:29','',''),(2200803,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 07:21:29','',''),(2200840,'1','176','920',409,'Retail Sale Id 1297262',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 07:23:26','',''),(2200841,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 07:23:26','',''),(2201112,'1','176','920',409,'Retail Sale Id 1297378',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:37:21','',''),(2201113,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:37:21','',''),(2201150,'1','176','920',409,'Retail Sale Id 1297402',46200.00,0.00,0.00,0.00,616.00,'2021-12-08 07:39:48','',''),(2201151,'1','176','920',409,'Retail sales',0.00,0.00,0.00,77.00,0.00,'2021-12-08 07:39:48','',''),(2202106,'1','176','920',409,'Retail Sale Id 1297858',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 08:35:22','',''),(2202107,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:35:22','',''),(2202246,'1','176','920',409,'Retail Sale Id 1297912',58800.00,0.00,0.00,0.00,784.00,'2021-12-08 08:42:14','',''),(2202247,'1','176','920',409,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-08 08:42:14','',''),(2202356,'1','176','920',409,'Retail Sale Id 1297940',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:46:08','',''),(2202357,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:46:08','',''),(2202606,'1','176','920',409,'Retail Sale Id 1298028',150000.00,0.00,0.00,0.00,2000.00,'2021-12-08 08:58:24','',''),(2202607,'1','176','920',409,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 08:58:24','',''),(2203059,'1','176','920',409,'Retail Sale Id 1298266',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 09:28:18','',''),(2203060,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:28:18','',''),(2203107,'1','176','920',409,'Retail Sale Id 1298290',12000.00,0.00,0.00,0.00,900.00,'2021-12-08 09:32:43','',''),(2203108,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-08 09:32:43','',''),(2203139,'1','176','920',409,'Retail Sale Id 1298305',48600.00,0.00,0.00,0.00,648.00,'2021-12-08 09:35:31','',''),(2203140,'1','176','920',409,'Retail sales',0.00,0.00,0.00,81.00,0.00,'2021-12-08 09:35:31','',''),(2203225,'1','176','920',409,'Retail Sale Id 1298348',5203.20,0.00,0.00,0.00,390.24,'2021-12-08 09:41:56','',''),(2203226,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-08 09:41:56','',''),(2203418,'1','176','920',409,'Retail Sale Id 1298439',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 09:55:59','',''),(2203419,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 09:55:59','',''),(2203476,'1','176','920',409,'Retail Sale Id 1298467',150000.00,0.00,0.00,0.00,2000.00,'2021-12-08 10:00:46','',''),(2203477,'1','176','920',409,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 10:00:46','',''),(2203523,'1','176','920',409,'Retail Sale Id 1298483',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 10:02:58','',''),(2203524,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 10:02:58','',''),(2203596,'1','176','920',409,'Retail Sale Id 1298516',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 10:08:57','',''),(2203597,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 10:08:57','',''),(2203627,'1','176','920',409,'Retail Sale Id 1298531',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 10:10:24','',''),(2203628,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 10:10:24','',''),(2204091,'1','176','920',409,'Retail Sale Id 1298751',24000.00,0.00,0.00,0.00,320.00,'2021-12-08 10:40:10','',''),(2204092,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 10:40:10','',''),(2204234,'1','176','920',409,'Retail Sale Id 1298822',37500.00,0.00,0.00,0.00,500.00,'2021-12-08 10:53:17','',''),(2204235,'1','176','920',409,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-08 10:53:17','',''),(2204268,'1','176','920',409,'Retail Sale Id 1298838',8960.00,0.00,0.00,0.00,672.00,'2021-12-08 10:55:54','',''),(2204269,'1','176','920',409,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 10:55:54','',''),(2204304,'1','176','920',409,'Retail Sale Id 1298854',29400.00,0.00,0.00,0.00,392.00,'2021-12-08 10:58:23','',''),(2204305,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-08 10:58:23','',''),(2204380,'1','176','920',409,'Retail Sale Id 1298894',2700.00,0.00,0.00,0.00,36.00,'2021-12-08 11:04:49','',''),(2204381,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 11:04:49','',''),(2204546,'1','176','920',409,'Retail Sale Id 1298983',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:15:06','',''),(2204547,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:15:06','',''),(2204616,'1','176','920',409,'Retail Sale Id 1299018',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 11:20:28','',''),(2204617,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 11:20:28','',''),(2204776,'1','176','920',409,'Retail Sale Id 1299102',33000.00,0.00,0.00,0.00,440.00,'2021-12-08 11:32:45','',''),(2204777,'1','176','920',409,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 11:32:45','',''),(2205068,'1','176','920',409,'Retail Sale Id 1299247',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:50:29','',''),(2205069,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:50:29','',''),(2205297,'1','176','920',409,'Retail Sale Id 1299350',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 12:07:59','',''),(2205298,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 12:07:59','',''),(2205345,'1','176','920',409,'Retail Sale Id 1299370',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 12:10:42','',''),(2205346,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 12:10:42','',''),(2205359,'1','176','920',409,'Retail Sale Id 1299377',60000.00,0.00,0.00,0.00,800.00,'2021-12-08 12:11:52','',''),(2205360,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 12:11:52','',''),(2205509,'1','176','920',409,'Retail Sale Id 1299450',18000.00,0.00,0.00,0.00,240.00,'2021-12-08 12:24:52','',''),(2205510,'1','176','920',409,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 12:24:52','',''),(2205576,'1','176','920',409,'Retail Sale Id 1299485',165600.00,0.00,0.00,0.00,2208.00,'2021-12-08 12:30:16','',''),(2205577,'1','176','920',409,'Retail sales',0.00,0.00,0.00,276.00,0.00,'2021-12-08 12:30:17','',''),(2205623,'1','176','920',409,'Retail Sale Id 1299505',24000.00,0.00,0.00,0.00,320.00,'2021-12-08 12:33:54','',''),(2205624,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 12:33:54','',''),(2205690,'1','176','920',409,'Retail Sale Id 1299537',60000.00,0.00,0.00,0.00,800.00,'2021-12-08 12:38:36','',''),(2205691,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 12:38:36','',''),(2205870,'1','176','920',409,'Retail Sale Id 1299617',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 12:49:02','',''),(2205871,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 12:49:02','',''),(2206013,'1','176','920',409,'Retail Sale Id 1299672',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 12:57:28','',''),(2206014,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 12:57:28','',''),(2206103,'1','176','920',409,'Retail Sale Id 1299709',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 13:04:33','',''),(2206105,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:04:33','',''),(2206435,'1','176','920',409,'Retail Sale Id 1299873',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 13:27:18','',''),(2206436,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:27:18','',''),(2207676,'1','176','920',409,'Retail Sale Id 1300399',90000.00,0.00,0.00,0.00,1200.00,'2021-12-08 14:35:37','',''),(2207677,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 14:35:37','',''),(2207704,'1','176','920',409,'Retail Sale Id 1300415',29400.00,0.00,0.00,0.00,392.00,'2021-12-08 14:36:48','',''),(2207705,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-08 14:36:48','',''),(2207790,'1','176','920',409,'Retail Sale Id 1300466',9600.00,0.00,0.00,0.00,720.00,'2021-12-08 14:42:38','',''),(2207791,'1','176','920',409,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 14:42:38','',''),(2208454,'1','176','920',409,'Retail Sale Id 1300775',210000.00,0.00,0.00,0.00,2800.00,'2021-12-08 15:22:11','',''),(2208455,'1','176','920',409,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-08 15:22:11','',''),(2208616,'1','176','920',409,'Distributed to operational loss for sales id:338092',44299.36,0.00,0.00,74.83,0.00,'2021-12-08 15:30:22','',''),(2209518,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2368000.00,4000.00,0.00,0.00,'2021-12-08 16:15:03','',''),(2209576,'1','176',NULL,409,'Reception corrector for bridging 126622',0.00,0.00,0.00,4000.00,0.00,'2021-12-08 16:16:35','',''),(2209577,'1','176','920',409,'Received from bridging 126622',0.00,0.00,4000.00,0.00,0.00,'2021-12-08 16:16:35','',''),(2209616,'1','176','920',409,'Retail Sale Id 1301343',5400.00,0.00,0.00,0.00,72.00,'2021-12-08 16:18:18','',''),(2209617,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 16:18:18','',''),(2209745,'1','176','920',409,'Retail Sale Id 1301402',28998.00,0.00,0.00,0.00,386.64,'2021-12-08 16:24:34','',''),(2209746,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.33,0.00,'2021-12-08 16:24:34','',''),(2209792,'1','176','920',409,'Retail Sale Id 1301473',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:28:38','',''),(2209793,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:28:38','',''),(2209821,'1','176','920',409,'Retail Sale Id 1301571',7680.00,0.00,0.00,0.00,576.00,'2021-12-08 16:29:54','',''),(2209822,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 16:29:54','',''),(2209951,'1','176','920',409,'Retail Sale Id 1301625',6003.20,0.00,0.00,0.00,450.24,'2021-12-08 16:35:57','',''),(2209952,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 16:35:57','',''),(2210575,'1','176','920',409,'Retail Sale Id 1301951',640.00,0.00,0.00,0.00,48.00,'2021-12-08 17:15:03','',''),(2210576,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 17:15:03','',''),(2210647,'1','176','920',409,'Retail Sale Id 1301999',28800.00,0.00,0.00,0.00,384.00,'2021-12-08 17:21:53','',''),(2210648,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-08 17:21:53','',''),(2210906,'1','176','920',409,'Retail Sale Id 1302110',27000.00,0.00,0.00,0.00,360.00,'2021-12-08 17:47:51','',''),(2210907,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-08 17:47:51','',''),(2211009,'1','176','920',409,'Retail Sale Id 1302150',247608.00,0.00,0.00,0.00,3301.44,'2021-12-08 18:08:32','',''),(2211010,'1','176','920',409,'Retail sales',0.00,0.00,0.00,412.68,0.00,'2021-12-08 18:08:32','',''),(2211061,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,828800.00,1400.00,0.00,0.00,'2021-12-08 18:22:27','',''),(2211070,'1','176',NULL,409,'Reception corrector for bridging 126632',0.00,0.00,0.00,1400.00,0.00,'2021-12-08 18:25:53','',''),(2211071,'1','176','920',409,'Received from bridging 126632',0.00,0.00,1400.00,0.00,0.00,'2021-12-08 18:25:53','',''),(2211734,'1','176','920',409,'Retail Sale Id 1302261',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 05:20:17','',''),(2211735,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 05:20:17','',''),(2211776,'1','176','920',409,'Retail Sale Id 1302271',27000.00,0.00,0.00,0.00,360.00,'2021-12-09 05:41:33','',''),(2211777,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-09 05:41:33','',''),(2211842,'1','176','920',409,'Retail Sale Id 1302297',90000.00,0.00,0.00,0.00,1200.00,'2021-12-09 05:55:02','',''),(2211843,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 05:55:02','',''),(2211867,'1','176','920',409,'Retail Sale Id 1302308',90000.00,0.00,0.00,0.00,1200.00,'2021-12-09 05:57:23','',''),(2211868,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 05:57:23','',''),(2211902,'1','176','920',409,'Retail Sale Id 1302328',27000.00,0.00,0.00,0.00,360.00,'2021-12-09 06:01:29','',''),(2211903,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-09 06:01:29','',''),(2212434,'1','176','920',409,'Retail Sale Id 1302559',22002.00,0.00,0.00,0.00,293.36,'2021-12-09 06:38:12','',''),(2212435,'1','176','920',409,'Retail sales',0.00,0.00,0.00,36.67,0.00,'2021-12-09 06:38:12','',''),(2212450,'1','176','920',409,'Retail Sale Id 1302566',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 06:39:25','',''),(2212451,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 06:39:25','',''),(2212468,'1','176','920',409,'Retail Sale Id 1302576',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 06:40:26','',''),(2212469,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 06:40:26','',''),(2212492,'1','176','920',409,'Retail Sale Id 1302586',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:41:33','',''),(2212493,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:41:33','',''),(2212621,'1','176','920',409,'Retail Sale Id 1302647',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:48:23','',''),(2212622,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:48:23','',''),(2212792,'1','176','920',409,'Retail Sale Id 1302718',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 06:57:58','',''),(2212793,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 06:57:58','',''),(2212828,'1','176','920',409,'Retail Sale Id 1302738',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 06:59:50','',''),(2212829,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 06:59:50','',''),(2212844,'1','176','920',409,'Retail Sale Id 1302747',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 07:00:44','',''),(2212845,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 07:00:44','',''),(2212953,'1','176','920',409,'Retail Sale Id 1302799',60000.00,0.00,0.00,0.00,800.00,'2021-12-09 07:06:53','',''),(2212954,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 07:06:53','',''),(2213270,'1','176','920',409,'Retail Sale Id 1302937',24998.40,0.00,0.00,0.00,1874.88,'2021-12-09 07:20:50','',''),(2213271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,39.06,0.00,'2021-12-09 07:20:50','',''),(2213504,'1','176','920',409,'Retail Sale Id 1303058',24000.00,0.00,0.00,0.00,320.00,'2021-12-09 07:31:42','',''),(2213505,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 07:31:42','',''),(2214162,'1','176','920',409,'Retail Sale Id 1303385',132000.00,0.00,0.00,0.00,1760.00,'2021-12-09 08:06:57','',''),(2214163,'1','176','920',409,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-09 08:06:57','',''),(2214234,'1','176','920',409,'Retail Sale Id 1303419',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:10:08','',''),(2214235,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:10:08','',''),(2214344,'1','176','920',409,'Retail Sale Id 1303479',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:16:08','',''),(2214345,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:16:08','',''),(2214877,'1','176','920',409,'Retail Sale Id 1303703',24998.40,0.00,0.00,0.00,1874.88,'2021-12-09 08:40:13','',''),(2214878,'1','176','920',409,'Retail sales',0.00,0.00,0.00,39.06,0.00,'2021-12-09 08:40:13','',''),(2215018,'1','176','920',409,'Retail Sale Id 1303769',17400.00,0.00,0.00,0.00,232.00,'2021-12-09 08:46:50','',''),(2215019,'1','176','920',409,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-09 08:46:50','',''),(2215222,'1','176','920',409,'Retail Sale Id 1303870',57000.00,0.00,0.00,0.00,760.00,'2021-12-09 08:59:54','',''),(2215223,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-09 08:59:54','',''),(2215275,'1','176','920',409,'Retail Sale Id 1303900',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 09:02:03','',''),(2215276,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 09:02:03','',''),(2215309,'1','176','920',409,'Retail Sale Id 1303919',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:04:22','',''),(2215310,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:04:22','',''),(2215382,'1','176','920',409,'Retail Sale Id 1303957',90000.00,0.00,0.00,0.00,1200.00,'2021-12-09 09:09:10','',''),(2215383,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 09:09:10','',''),(2215436,'1','176','920',409,'Retail Sale Id 1303979',56400.00,0.00,0.00,0.00,752.00,'2021-12-09 09:12:16','',''),(2215437,'1','176','920',409,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-09 09:12:16','',''),(2216057,'1','176','920',409,'Retail Sale Id 1304263',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:44:15','',''),(2216058,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:44:15','',''),(2216155,'1','176','920',409,'Retail Sale Id 1304294',90000.00,0.00,0.00,0.00,1200.00,'2021-12-09 09:48:32','',''),(2216156,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 09:48:32','',''),(2216312,'1','176','920',409,'Retail Sale Id 1304370',12000.00,0.00,0.00,0.00,900.00,'2021-12-09 09:56:13','',''),(2216313,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-09 09:56:13','',''),(2216459,'1','176','920',409,'Retail Sale Id 1304435',60000.00,0.00,0.00,0.00,800.00,'2021-12-09 10:03:19','',''),(2216460,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 10:03:19','',''),(2216587,'1','176','920',409,'Retail Sale Id 1304506',24000.00,0.00,0.00,0.00,320.00,'2021-12-09 10:11:30','',''),(2216588,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 10:11:30','',''),(2216711,'1','176','920',409,'Retail Sale Id 1304571',998.40,0.00,0.00,0.00,74.88,'2021-12-09 10:20:28','',''),(2216712,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 10:20:28','',''),(2216749,'1','176','920',409,'Retail Sale Id 1304594',7500.80,0.00,0.00,0.00,562.56,'2021-12-09 10:22:52','',''),(2216750,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-09 10:22:52','',''),(2216833,'1','176','920',409,'Retail Sale Id 1304638',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:27:26','',''),(2216834,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:27:26','',''),(2216937,'1','176','920',409,'Retail Sale Id 1304693',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 10:35:06','',''),(2216938,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:35:06','',''),(2217192,'1','176','920',409,'Retail Sale Id 1304821',74400.00,0.00,0.00,0.00,992.00,'2021-12-09 10:51:02','',''),(2217193,'1','176','920',409,'Retail sales',0.00,0.00,0.00,124.00,0.00,'2021-12-09 10:51:02','',''),(2218409,'1','176','920',409,'Retail Sale Id 1305418',2880.00,0.00,0.00,0.00,216.00,'2021-12-09 12:10:33','',''),(2218410,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-09 12:10:33','',''),(2218449,'1','176','920',409,'Retail Sale Id 1305440',68400.00,0.00,0.00,0.00,912.00,'2021-12-09 12:12:08','',''),(2218450,'1','176','920',409,'Retail sales',0.00,0.00,0.00,114.00,0.00,'2021-12-09 12:12:08','',''),(2218477,'1','176','920',409,'Retail Sale Id 1305455',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 12:13:37','',''),(2218478,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 12:13:37','',''),(2218662,'1','176','920',409,'Retail Sale Id 1305560',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 12:26:27','',''),(2218663,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 12:26:27','',''),(2219317,'1','176','920',409,'Retail Sale Id 1305887',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:03:37','',''),(2219318,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:03:37','',''),(2219420,'1','176','920',409,'Retail Sale Id 1305948',174600.00,0.00,0.00,0.00,2328.00,'2021-12-09 13:11:17','',''),(2219421,'1','176','920',409,'Retail sales',0.00,0.00,0.00,291.00,0.00,'2021-12-09 13:11:17','',''),(2219464,'1','176','920',409,'Retail Sale Id 1305960',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 13:13:11','',''),(2219465,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 13:13:11','',''),(2219579,'1','176','920',409,'Retail Sale Id 1306013',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 13:22:56','',''),(2219580,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:22:56','',''),(2220706,'1','176','920',409,'Retail Sale Id 1306525',25002.00,0.00,0.00,0.00,333.36,'2021-12-09 14:26:47','',''),(2220707,'1','176','920',409,'Retail sales',0.00,0.00,0.00,41.67,0.00,'2021-12-09 14:26:47','',''),(2220736,'1','176','920',409,'Retail Sale Id 1306545',28002.00,0.00,0.00,0.00,373.36,'2021-12-09 14:28:35','',''),(2220737,'1','176','920',409,'Retail sales',0.00,0.00,0.00,46.67,0.00,'2021-12-09 14:28:35','',''),(2220753,'1','176','920',409,'Retail Sale Id 1306554',36000.00,0.00,0.00,0.00,480.00,'2021-12-09 14:29:26','',''),(2220754,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 14:29:26','',''),(2220837,'1','176','920',409,'Retail Sale Id 1306588',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 14:33:33','',''),(2220838,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 14:33:33','',''),(2220941,'1','176','920',409,'Retail Sale Id 1306624',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 14:36:51','',''),(2220942,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 14:36:51','',''),(2221171,'1','176','920',409,'Retail Sale Id 1306739',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 14:46:48','',''),(2221172,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 14:46:48','',''),(2221540,'1','176','920',409,'Retail Sale Id 1306878',15000.00,0.00,0.00,0.00,200.00,'2021-12-09 15:03:20','',''),(2221541,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 15:03:20','',''),(2221678,'1','176','920',409,'Retail Sale Id 1306951',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:09:35','',''),(2221679,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:09:35','',''),(2221801,'1','176','920',409,'Retail Sale Id 1307019',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 15:16:02','',''),(2221802,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 15:16:02','',''),(2221855,'1','176','920',409,'Retail Sale Id 1307049',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:18:54','',''),(2221856,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:18:54','',''),(2222051,'1','176','920',409,'Retail Sale Id 1307149',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:28:17','',''),(2222052,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:28:17','',''),(2222134,'1','176','920',409,'Retail Sale Id 1307184',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 15:31:59','',''),(2222135,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 15:31:59','',''),(2222332,'1','176','920',409,'Retail Sale Id 1307284',16640.00,0.00,0.00,0.00,1248.00,'2021-12-09 15:42:45','',''),(2222333,'1','176','920',409,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-09 15:42:45','',''),(2222395,'1','176','920',409,'Retail Sale Id 1307311',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 15:46:19','',''),(2222396,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 15:46:19','',''),(2222411,'1','176','920',409,'Retail Sale Id 1307321',36000.00,0.00,0.00,0.00,480.00,'2021-12-09 15:47:33','',''),(2222412,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 15:47:33','',''),(2222672,'1','176','920',409,'Retail Sale Id 1307451',28800.00,0.00,0.00,0.00,384.00,'2021-12-09 16:01:35','',''),(2222673,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-09 16:01:35','',''),(2222704,'1','176','920',409,'Retail Sale Id 1307466',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 16:03:23','',''),(2222705,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 16:03:23','',''),(2222731,'1','176','920',409,'Retail Sale Id 1307478',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 16:04:31','',''),(2222732,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:04:31','',''),(2223310,'1','176','920',409,'Retail Sale Id 1307759',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 16:35:13','',''),(2223311,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:35:13','',''),(2223474,'1','176','920',409,'Retail Sale Id 1307819',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 16:43:03','',''),(2223475,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:43:03','',''),(2223502,'1','176','920',409,'Retail Sale Id 1307830',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 16:44:29','',''),(2223503,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:44:29','',''),(2224054,'1','176','920',409,'Retail Sale Id 1308095',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 17:24:09','',''),(2224055,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 17:24:09','',''),(2224180,'1','176','920',409,'Retail Sale Id 1308157',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 17:42:52','',''),(2224181,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 17:42:52','',''),(2224190,'1','176','920',409,'Retail Sale Id 1308162',102000.00,0.00,0.00,0.00,1360.00,'2021-12-09 17:47:11','',''),(2224191,'1','176','920',409,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-09 17:47:11','',''),(2224273,'1','176','920',409,'Retail Sale Id 1308201',13590.00,0.00,0.00,0.00,181.20,'2021-12-09 17:59:42','',''),(2224274,'1','176','920',409,'Retail sales',0.00,0.00,0.00,22.65,0.00,'2021-12-09 17:59:42','',''),(2224327,'1','176','920',409,'Retail Sale Id 1308223',13200.00,0.00,0.00,0.00,176.00,'2021-12-09 18:08:20','',''),(2224328,'1','176','920',409,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-09 18:08:20','',''),(2224347,'1','176','920',409,'Retail Sale Id 1308233',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 18:12:26','',''),(2224348,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 18:12:26','',''),(2224983,'1','176','920',409,'Retail Sale Id 1308318',25001.76,0.00,0.00,0.00,0.00,'2021-12-10 05:34:06','',''),(2224984,'1','176','920',409,'Retail sales',0.00,0.00,0.00,42.52,0.00,'2021-12-10 05:34:06','',''),(2225061,'1','176','920',409,'Retail Sale Id 1308349',88200.00,0.00,0.00,0.00,0.00,'2021-12-10 06:00:12','',''),(2225062,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 06:00:12','',''),(2225301,'1','176','920',409,'Retail Sale Id 1308449',78792.00,0.00,0.00,0.00,0.00,'2021-12-10 06:26:12','',''),(2225302,'1','176','920',409,'Retail sales',0.00,0.00,0.00,134.00,0.00,'2021-12-10 06:26:12','',''),(2225379,'1','176','920',409,'Retail Sale Id 1308492',15800.00,0.00,0.00,0.00,1100.00,'2021-12-10 06:33:16','',''),(2225380,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 06:33:16','',''),(2225535,'1','176','920',409,'Retail Sale Id 1308557',14700.00,0.00,0.00,0.00,0.00,'2021-12-10 06:44:18','',''),(2225536,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 06:44:18','',''),(2225946,'1','176','920',409,'Retail Sale Id 1308769',3798.32,0.00,0.00,0.00,264.44,'2021-12-10 07:11:57','',''),(2225947,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:11:57','',''),(2226008,'1','176','920',409,'Retail Sale Id 1308796',7900.00,0.00,0.00,0.00,550.00,'2021-12-10 07:15:44','',''),(2226009,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:15:44','',''),(2226358,'1','176','920',409,'Retail Sale Id 1308970',58800.00,0.00,0.00,0.00,0.00,'2021-12-10 07:34:06','',''),(2226359,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 07:34:06','',''),(2226589,'1','176','920',409,'Retail Sale Id 1309086',48804.00,0.00,0.00,0.00,0.00,'2021-12-10 07:47:47','',''),(2226590,'1','176','920',409,'Retail sales',0.00,0.00,0.00,83.00,0.00,'2021-12-10 07:47:47','',''),(2226643,'1','176','920',409,'Retail Sale Id 1309112',8232.00,0.00,0.00,0.00,0.00,'2021-12-10 07:50:25','',''),(2226644,'1','176','920',409,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-10 07:50:25','',''),(2227449,'1','176','920',409,'Retail Sale Id 1309423',4000.56,0.00,0.00,0.00,278.52,'2021-12-10 08:26:08','',''),(2227450,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 08:26:08','',''),(2228033,'1','176','920',409,'Retail Sale Id 1309707',29400.00,0.00,0.00,0.00,0.00,'2021-12-10 08:53:48','',''),(2228034,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:53:48','',''),(2228116,'1','176','920',409,'Retail Sale Id 1309752',29400.00,0.00,0.00,0.00,0.00,'2021-12-10 08:58:17','',''),(2228117,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:58:17','',''),(2228192,'1','176','920',409,'Retail Sale Id 1309788',58800.00,0.00,0.00,0.00,0.00,'2021-12-10 09:01:02','',''),(2228193,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 09:01:02','',''),(2228256,'1','176','920',409,'Retail Sale Id 1309817',52920.00,0.00,0.00,0.00,0.00,'2021-12-10 09:03:42','',''),(2228257,'1','176','920',409,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-10 09:03:42','',''),(2229208,'1','176','920',409,'Retail Sale Id 1310277',1952.88,0.00,0.00,0.00,135.96,'2021-12-10 10:00:04','',''),(2229209,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.09,0.00,'2021-12-10 10:00:04','',''),(2230196,'1','176','920',409,'Retail Sale Id 1310717',29400.00,0.00,0.00,0.00,0.00,'2021-12-10 10:54:11','',''),(2230197,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 10:54:11','',''),(2230739,'1','176','920',409,'Retail Sale Id 1310949',104193.60,0.00,0.00,0.00,0.00,'2021-12-10 11:25:52','',''),(2230740,'1','176','920',409,'Retail sales',0.00,0.00,0.00,177.20,0.00,'2021-12-10 11:25:52','',''),(2230856,'1','176','920',409,'Distributed to operational loss for sales id:338522',39331.32,0.00,0.00,66.89,0.00,'2021-12-10 11:34:04','',''),(2232445,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2860000.00,5000.00,0.00,0.00,'2021-12-10 13:31:26','',''),(2232469,'1','176',NULL,409,'Reception corrector for bridging 126884',0.00,0.00,0.00,5000.00,0.00,'2021-12-10 13:32:43','',''),(2232470,'1','176','920',409,'Received from bridging 126884',0.00,0.00,5000.00,0.00,0.00,'2021-12-10 13:32:43','',''),(2232509,'1','176','920',409,'Retail Sale Id 1311842',58800.00,0.00,0.00,0.00,1600.00,'2021-12-10 13:34:53','',''),(2232510,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 13:34:53','',''),(2232755,'1','176','920',409,'Retail Sale Id 1311943',29400.00,0.00,0.00,0.00,800.00,'2021-12-10 13:45:39','',''),(2232756,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 13:45:39','',''),(2232805,'1','176','920',409,'Retail Sale Id 1311961',23520.00,0.00,0.00,0.00,640.00,'2021-12-10 13:47:15','',''),(2232806,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-10 13:47:15','',''),(2233213,'1','176','920',409,'Retail Sale Id 1312127',7900.00,0.00,0.00,0.00,750.00,'2021-12-10 14:06:07','',''),(2233214,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:06:07','',''),(2233279,'1','176','920',409,'Retail Sale Id 1312154',57624.00,0.00,0.00,0.00,1568.00,'2021-12-10 14:11:02','',''),(2233280,'1','176','920',409,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-10 14:11:02','',''),(2233498,'1','176','920',409,'Retail Sale Id 1312264',2597.52,0.00,0.00,0.00,246.60,'2021-12-10 14:22:11','',''),(2233499,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-10 14:22:11','',''),(2233575,'1','176','920',409,'Retail Sale Id 1312287',6320.00,0.00,0.00,0.00,600.00,'2021-12-10 14:24:42','',''),(2233576,'1','176','920',409,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 14:24:42','',''),(2233741,'1','176','920',409,'Retail Sale Id 1312355',19598.32,0.00,0.00,0.00,1860.60,'2021-12-10 14:31:56','',''),(2233742,'1','176','920',409,'Retail sales',0.00,0.00,0.00,31.01,0.00,'2021-12-10 14:31:56','',''),(2233769,'1','176','920',409,'Retail Sale Id 1312374',1997.12,0.00,0.00,0.00,189.60,'2021-12-10 14:33:08','',''),(2233770,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:33:08','',''),(2234041,'1','176','920',409,'Retail Sale Id 1312486',5688.00,0.00,0.00,0.00,540.00,'2021-12-10 14:44:02','',''),(2234042,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 14:44:02','',''),(2234071,'1','176','920',409,'Retail Sale Id 1312505',998.56,0.00,0.00,0.00,94.80,'2021-12-10 14:45:31','',''),(2234072,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:45:31','',''),(2234223,'1','176','920',409,'Retail Sale Id 1312570',109956.00,0.00,0.00,0.00,2992.00,'2021-12-10 14:50:57','',''),(2234224,'1','176','920',409,'Retail sales',0.00,0.00,0.00,187.00,0.00,'2021-12-10 14:50:57','',''),(2234288,'1','176','920',409,'Retail Sale Id 1312599',1497.84,0.00,0.00,0.00,142.20,'2021-12-10 14:54:22','',''),(2234289,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 14:54:22','',''),(2234773,'1','176','920',409,'Retail Sale Id 1312842',29400.00,0.00,0.00,0.00,800.00,'2021-12-10 15:18:45','',''),(2234774,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 15:18:45','',''),(2234916,'1','176','920',409,'Retail Sale Id 1312919',88200.00,0.00,0.00,0.00,2400.00,'2021-12-10 15:24:15','',''),(2234917,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 15:24:15','',''),(2234956,'1','176','920',409,'Retail Sale Id 1312942',998.56,0.00,0.00,0.00,94.80,'2021-12-10 15:25:25','',''),(2234957,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:25:25','',''),(2235171,'1','176','920',409,'Retail Sale Id 1313027',28224.00,0.00,0.00,0.00,768.00,'2021-12-10 15:33:04','',''),(2235172,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-10 15:33:04','',''),(2235263,'1','176','920',409,'Retail Sale Id 1313070',1301.92,0.00,0.00,0.00,123.60,'2021-12-10 15:37:15','',''),(2235264,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:37:15','',''),(2235389,'1','176','920',409,'Retail Sale Id 1313127',1403.04,0.00,0.00,0.00,133.20,'2021-12-10 15:42:27','',''),(2235390,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-10 15:42:27','',''),(2235538,'1','176','920',409,'Retail Sale Id 1313219',1497.84,0.00,0.00,0.00,142.20,'2021-12-10 15:49:37','',''),(2235539,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:49:37','',''),(2235964,'1','176','920',409,'Retail Sale Id 1313420',141120.00,0.00,0.00,0.00,3840.00,'2021-12-10 16:09:06','',''),(2235965,'1','176','920',409,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-10 16:09:06','',''),(2235999,'1','176','920',409,'Retail Sale Id 1313435',7602.96,0.00,0.00,0.00,721.80,'2021-12-10 16:10:37','',''),(2236000,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.03,0.00,'2021-12-10 16:10:37','',''),(2236071,'1','176','920',409,'Retail Sale Id 1313472',29400.00,0.00,0.00,0.00,800.00,'2021-12-10 16:14:20','',''),(2236072,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:14:20','',''),(2236495,'1','176','920',409,'Retail Sale Id 1313702',3798.32,0.00,0.00,0.00,360.60,'2021-12-10 16:33:03','',''),(2236496,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:33:03','',''),(2236657,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,286000.00,500.00,0.00,0.00,'2021-12-10 16:40:55','',''),(2236676,'1','176',NULL,409,'Reception corrector for bridging 126919',0.00,0.00,0.00,500.00,0.00,'2021-12-10 16:41:53','',''),(2236677,'1','176','920',409,'Received from bridging 126919',0.00,0.00,500.00,0.00,0.00,'2021-12-10 16:41:53','',''),(2236774,'1','176','920',409,'Retail Sale Id 1313827',28812.00,0.00,0.00,0.00,784.00,'2021-12-10 16:47:31','',''),(2236775,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-10 16:47:31','',''),(2236988,'1','176','920',409,'Retail Sale Id 1313935',29400.00,0.00,0.00,0.00,800.00,'2021-12-10 17:00:43','',''),(2236989,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 17:00:43','',''),(2237019,'1','176','920',409,'Retail Sale Id 1313954',24696.00,0.00,0.00,0.00,672.00,'2021-12-10 17:02:25','',''),(2237020,'1','176','920',409,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-10 17:02:25','',''),(2237090,'1','176','920',409,'Retail Sale Id 1313982',14112.00,0.00,0.00,0.00,384.00,'2021-12-10 17:06:56','',''),(2237091,'1','176','920',409,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-10 17:06:56','',''),(2237655,'1','176','920',409,'Retail Sale Id 1314267',307429.92,0.00,0.00,0.00,8365.44,'2021-12-10 18:07:53','',''),(2237656,'1','176','920',409,'Retail sales',0.00,0.00,0.00,522.84,0.00,'2021-12-10 18:07:53','',''),(2238544,'1','176','920',409,'Retail Sale Id 1314463',88200.00,0.00,0.00,0.00,2400.00,'2021-12-11 06:11:11','',''),(2238545,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 06:11:11','',''),(2238743,'1','176','920',409,'Retail Sale Id 1314559',294000.00,0.00,0.00,0.00,8000.00,'2021-12-11 06:28:33','',''),(2238744,'1','176','920',409,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-11 06:28:33','',''),(2238850,'1','176','920',409,'Retail Sale Id 1314596',29400.00,0.00,0.00,0.00,800.00,'2021-12-11 06:35:28','',''),(2238851,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 06:35:28','',''),(2239024,'1','176','920',409,'Retail Sale Id 1314694',31499.16,0.00,0.00,0.00,857.12,'2021-12-11 06:48:52','',''),(2239025,'1','176','920',409,'Retail sales',0.00,0.00,0.00,53.57,0.00,'2021-12-11 06:48:52','',''),(2239070,'1','176','920',409,'Retail Sale Id 1314708',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 06:51:50','',''),(2239071,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:51:50','',''),(2239136,'1','176','920',409,'Retail Sale Id 1314746',20002.80,0.00,0.00,0.00,1899.00,'2021-12-11 06:55:27','',''),(2239137,'1','176','920',409,'Retail sales',0.00,0.00,0.00,31.65,0.00,'2021-12-11 06:55:27','',''),(2239178,'1','176','920',409,'Retail Sale Id 1314761',70560.00,0.00,0.00,0.00,1920.00,'2021-12-11 06:58:05','',''),(2239179,'1','176','920',409,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-11 06:58:05','',''),(2239270,'1','176','920',409,'Retail Sale Id 1314810',29400.00,0.00,0.00,0.00,800.00,'2021-12-11 07:03:15','',''),(2239271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 07:03:15','',''),(2239318,'1','176','920',409,'Retail Sale Id 1314840',22050.00,0.00,0.00,0.00,600.00,'2021-12-11 07:06:28','',''),(2239319,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-11 07:06:28','',''),(2239364,'1','176','920',409,'Retail Sale Id 1314863',6468.00,0.00,0.00,0.00,176.00,'2021-12-11 07:08:39','',''),(2239365,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 07:08:39','',''),(2239606,'1','176','920',409,'Retail Sale Id 1314993',6952.00,0.00,0.00,0.00,660.00,'2021-12-11 07:24:11','',''),(2239607,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 07:24:11','',''),(2239760,'1','176','920',409,'Retail Sale Id 1315081',58800.00,0.00,0.00,0.00,1600.00,'2021-12-11 07:32:13','',''),(2239761,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 07:32:13','',''),(2239881,'1','176','920',409,'Retail Sale Id 1315155',19997.88,0.00,0.00,0.00,544.16,'2021-12-11 07:37:54','',''),(2239882,'1','176','920',409,'Retail sales',0.00,0.00,0.00,34.01,0.00,'2021-12-11 07:37:54','',''),(2240119,'1','176','920',409,'Retail Sale Id 1315265',5062.32,0.00,0.00,0.00,480.60,'2021-12-11 07:49:16','',''),(2240120,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-11 07:49:16','',''),(2240607,'1','176','920',409,'Retail Sale Id 1315470',40278.00,0.00,0.00,0.00,1096.00,'2021-12-11 08:09:02','',''),(2240608,'1','176','920',409,'Retail sales',0.00,0.00,0.00,68.50,0.00,'2021-12-11 08:09:02','',''),(2242390,'1','176','920',409,'Retail Sale Id 1316316',205800.00,0.00,0.00,0.00,5600.00,'2021-12-11 09:33:19','',''),(2242391,'1','176','920',409,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-11 09:33:19','',''),(2242628,'1','176','920',409,'Retail Sale Id 1316443',14700.00,0.00,0.00,0.00,400.00,'2021-12-11 09:44:05','',''),(2242629,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 09:44:05','',''),(2242658,'1','176','920',409,'Retail Sale Id 1316455',58800.00,0.00,0.00,0.00,1600.00,'2021-12-11 09:45:13','',''),(2242659,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 09:45:13','',''),(2242766,'1','176','920',409,'Retail Sale Id 1316510',1301.92,0.00,0.00,0.00,123.60,'2021-12-11 09:50:08','',''),(2242767,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 09:50:08','',''),(2242794,'1','176','920',409,'Retail Sale Id 1316525',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 09:51:28','',''),(2242795,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:51:28','',''),(2242818,'1','176','920',409,'Retail Sale Id 1316538',1902.32,0.00,0.00,0.00,180.60,'2021-12-11 09:52:49','',''),(2242820,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:52:49','',''),(2243309,'1','176','920',409,'Retail Sale Id 1316744',58800.00,0.00,0.00,0.00,1600.00,'2021-12-11 10:15:55','',''),(2243310,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 10:15:55','',''),(2243499,'1','176','920',409,'Retail Sale Id 1316834',998.56,0.00,0.00,0.00,94.80,'2021-12-11 10:25:43','',''),(2243500,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:25:43','',''),(2243653,'1','176','920',409,'Retail Sale Id 1316906',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 10:33:27','',''),(2243654,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:33:27','',''),(2243994,'1','176','920',409,'Retail Sale Id 1317077',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 10:52:40','',''),(2243995,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:52:40','',''),(2244343,'1','176','920',409,'Retail Sale Id 1317230',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 11:09:27','',''),(2244344,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:09:27','',''),(2244517,'1','176','920',409,'Retail Sale Id 1317322',33810.00,0.00,0.00,0.00,920.00,'2021-12-11 11:18:58','',''),(2244518,'1','176','920',409,'Retail sales',0.00,0.00,0.00,57.50,0.00,'2021-12-11 11:18:58','',''),(2244941,'1','176','920',409,'Retail Sale Id 1317541',29400.00,0.00,0.00,0.00,800.00,'2021-12-11 11:41:38','',''),(2244942,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:41:38','',''),(2245095,'1','176','920',409,'Retail Sale Id 1317613',152880.00,0.00,0.00,0.00,4160.00,'2021-12-11 11:50:59','',''),(2245096,'1','176','920',409,'Retail sales',0.00,0.00,0.00,260.00,0.00,'2021-12-11 11:50:59','',''),(2245203,'1','176','920',409,'Retail Sale Id 1317672',16748.00,0.00,0.00,0.00,1590.00,'2021-12-11 11:57:11','',''),(2245204,'1','176','920',409,'Retail sales',0.00,0.00,0.00,26.50,0.00,'2021-12-11 11:57:11','',''),(2245261,'1','176','920',409,'Retail Sale Id 1317699',29400.00,0.00,0.00,0.00,800.00,'2021-12-11 12:00:33','',''),(2245262,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 12:00:33','',''),(2245323,'1','176','920',409,'Retail Sale Id 1317732',116600.40,0.00,0.00,0.00,3172.80,'2021-12-11 12:05:27','',''),(2245324,'1','176','920',409,'Retail sales',0.00,0.00,0.00,198.30,0.00,'2021-12-11 12:05:27','',''),(2245515,'1','176','920',409,'Retail Sale Id 1317884',28224.00,0.00,0.00,0.00,768.00,'2021-12-11 12:17:58','',''),(2245516,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-11 12:17:58','',''),(2245585,'1','176','920',409,'Retail Sale Id 1317897',117600.00,0.00,0.00,0.00,3200.00,'2021-12-11 12:21:33','',''),(2245586,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-11 12:21:33','',''),(2245629,'1','176','920',409,'Retail Sale Id 1317936',117600.00,0.00,0.00,0.00,3200.00,'2021-12-11 12:24:16','',''),(2245630,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-11 12:24:16','',''),(2245698,'1','176','920',409,'Retail Sale Id 1317965',26460.00,0.00,0.00,0.00,720.00,'2021-12-11 12:27:49','',''),(2245699,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-11 12:27:49','',''),(2245734,'1','176','920',409,'Retail Sale Id 1317976',15800.00,0.00,0.00,0.00,1500.00,'2021-12-11 12:29:38','',''),(2245735,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 12:29:38','',''),(2245872,'1','176','920',409,'Retail Sale Id 1318057',28500.36,0.00,0.00,0.00,775.52,'2021-12-11 12:38:40','',''),(2245873,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.47,0.00,'2021-12-11 12:38:40','',''),(2246037,'1','176','920',409,'Retail Sale Id 1318138',4796.88,0.00,0.00,0.00,455.40,'2021-12-11 12:50:38','',''),(2246038,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.59,0.00,'2021-12-11 12:50:38','',''),(2246828,'1','176','920',409,'Retail Sale Id 1318504',7900.00,0.00,0.00,0.00,750.00,'2021-12-11 13:44:19','',''),(2246829,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:44:19','',''),(2247054,'1','176','920',409,'Retail Sale Id 1318616',38220.00,0.00,0.00,0.00,1040.00,'2021-12-11 13:59:11','',''),(2247055,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-11 13:59:11','',''),(2247452,'1','176','920',409,'Retail Sale Id 1318810',35280.00,0.00,0.00,0.00,960.00,'2021-12-11 14:23:41','',''),(2247453,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 14:23:41','',''),(2247588,'1','176','920',409,'Retail Sale Id 1318890',55860.00,0.00,0.00,0.00,1520.00,'2021-12-11 14:34:14','',''),(2247589,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-11 14:34:14','',''),(2247820,'1','176','920',409,'Retail Sale Id 1319013',62328.00,0.00,0.00,0.00,1696.00,'2021-12-11 14:48:03','',''),(2247821,'1','176','920',409,'Retail sales',0.00,0.00,0.00,106.00,0.00,'2021-12-11 14:48:03','',''),(2247986,'1','176','920',409,'Retail Sale Id 1319100',7002.56,0.00,0.00,0.00,664.80,'2021-12-11 14:57:00','',''),(2247987,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-11 14:57:00','',''),(2248027,'1','176','920',409,'Retail Sale Id 1319120',88200.00,0.00,0.00,0.00,2400.00,'2021-12-11 14:59:10','',''),(2248028,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 14:59:10','',''),(2248766,'1','176','920',409,'Retail Sale Id 1319472',1301.92,0.00,0.00,0.00,123.60,'2021-12-11 15:36:46','',''),(2248767,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 15:36:46','',''),(2249542,'1','176','920',409,'Retail Sale Id 1319825',28423.92,0.00,0.00,0.00,773.44,'2021-12-11 16:10:15','',''),(2249543,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.34,0.00,'2021-12-11 16:10:15','',''),(2249911,'1','176','920',409,'Distributed to operational loss for sales id:338929',36281.96,0.00,0.00,63.43,0.00,'2021-12-11 16:31:50','',''),(2252083,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2904180.00,4990.00,0.00,0.00,'2021-12-12 06:11:04','',''),(2252094,'1','176',NULL,409,'Reception corrector for bridging 127084',0.00,0.00,0.00,4990.00,0.00,'2021-12-12 06:13:09','',''),(2252095,'1','176','920',409,'Received from bridging 127084',0.00,0.00,4990.00,0.00,0.00,'2021-12-12 06:13:09','',''),(2252122,'1','176','920',409,'Retail Sale Id 1320850',88200.00,0.00,0.00,0.00,900.00,'2021-12-12 06:17:33','',''),(2252123,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 06:17:33','',''),(2252172,'1','176','920',409,'Retail Sale Id 1320874',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 06:25:28','',''),(2252173,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:25:28','',''),(2252404,'1','176','920',409,'Retail Sale Id 1320972',3798.32,0.00,0.00,0.00,300.50,'2021-12-12 06:39:49','',''),(2252405,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:39:49','',''),(2252460,'1','176','920',409,'Retail Sale Id 1320999',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 06:45:03','',''),(2252461,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 06:45:03','',''),(2252490,'1','176','920',409,'Retail Sale Id 1321008',21997.08,0.00,0.00,0.00,224.46,'2021-12-12 06:46:08','',''),(2252491,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.41,0.00,'2021-12-12 06:46:08','',''),(2252699,'1','176','920',409,'Retail Sale Id 1321081',23520.00,0.00,0.00,0.00,240.00,'2021-12-12 06:58:17','',''),(2252700,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 06:58:17','',''),(2252916,'1','176','920',409,'Retail Sale Id 1321196',145236.00,0.00,0.00,0.00,1482.00,'2021-12-12 07:15:44','',''),(2252917,'1','176','920',409,'Retail sales',0.00,0.00,0.00,247.00,0.00,'2021-12-12 07:15:44','',''),(2253006,'1','176','920',409,'Retail Sale Id 1321240',38220.00,0.00,0.00,0.00,390.00,'2021-12-12 07:21:58','',''),(2253007,'1','176','920',409,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-12 07:21:58','',''),(2253062,'1','176','920',409,'Retail Sale Id 1321264',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 07:25:07','',''),(2253063,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:25:07','',''),(2253334,'1','176','920',409,'Retail Sale Id 1321422',79380.00,0.00,0.00,0.00,810.00,'2021-12-12 07:44:41','',''),(2253335,'1','176','920',409,'Retail sales',0.00,0.00,0.00,135.00,0.00,'2021-12-12 07:44:41','',''),(2253343,'1','176','920',409,'Retail Sale Id 1321426',48510.00,0.00,0.00,0.00,495.00,'2021-12-12 07:45:30','',''),(2253344,'1','176','920',409,'Retail sales',0.00,0.00,0.00,82.50,0.00,'2021-12-12 07:45:30','',''),(2253414,'1','176','920',409,'Retail Sale Id 1321450',4000.56,0.00,0.00,0.00,316.50,'2021-12-12 07:48:25','',''),(2253415,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 07:48:25','',''),(2253428,'1','176','920',409,'Retail Sale Id 1321480',5056.00,0.00,0.00,0.00,400.00,'2021-12-12 07:49:12','',''),(2253429,'1','176','920',409,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 07:49:12','',''),(2253591,'1','176','920',409,'Retail Sale Id 1321557',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 07:59:27','',''),(2253592,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:59:27','',''),(2255514,'1','176','920',409,'Retail Sale Id 1321634',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 09:53:43','',''),(2255515,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:53:43','',''),(2255583,'1','176','920',409,'Retail Sale Id 1322533',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 09:56:24','',''),(2255584,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:56:24','',''),(2255777,'1','176','920',409,'Retail Sale Id 1322618',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 10:05:02','',''),(2255778,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 10:05:02','',''),(2255815,'1','176','920',409,'Retail Sale Id 1322643',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 10:06:38','',''),(2255816,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:06:38','',''),(2255932,'1','176','920',409,'Retail Sale Id 1322699',28812.00,0.00,0.00,0.00,294.00,'2021-12-12 10:12:28','',''),(2255933,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-12 10:12:28','',''),(2255980,'1','176','920',409,'Retail Sale Id 1322722',998.56,0.00,0.00,0.00,79.00,'2021-12-12 10:14:29','',''),(2255981,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:14:29','',''),(2256095,'1','176','920',409,'Retail Sale Id 1322792',24696.00,0.00,0.00,0.00,252.00,'2021-12-12 10:22:06','',''),(2256096,'1','176','920',409,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-12 10:22:06','',''),(2256391,'1','176','920',409,'Retail Sale Id 1322950',1497.84,0.00,0.00,0.00,118.50,'2021-12-12 10:37:35','',''),(2256392,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 10:37:35','',''),(2256592,'1','176','920',409,'Retail Sale Id 1323044',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 10:46:50','',''),(2256593,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:46:50','',''),(2257199,'1','176','920',409,'Retail Sale Id 1323353',3160.00,0.00,0.00,0.00,250.00,'2021-12-12 11:12:43','',''),(2257200,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:12:43','',''),(2257217,'1','176','920',409,'Retail Sale Id 1323363',3197.92,0.00,0.00,0.00,253.00,'2021-12-12 11:13:30','',''),(2257218,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 11:13:30','',''),(2257415,'1','176','920',409,'Retail Sale Id 1323455',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 11:21:13','',''),(2257416,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:21:13','',''),(2257528,'1','176','920',409,'Retail Sale Id 1323512',4000.56,0.00,0.00,0.00,316.50,'2021-12-12 11:26:33','',''),(2257529,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 11:26:33','',''),(2257562,'1','176','920',409,'Retail Sale Id 1323531',58800.00,0.00,0.00,0.00,600.00,'2021-12-12 11:27:55','',''),(2257563,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 11:27:55','',''),(2257600,'1','176','920',409,'Retail Sale Id 1323566',14999.88,0.00,0.00,0.00,153.06,'2021-12-12 11:29:57','',''),(2257601,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.51,0.00,'2021-12-12 11:29:57','',''),(2257927,'1','176','920',409,'Retail Sale Id 1323722',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 11:45:18','',''),(2257928,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:45:18','',''),(2257979,'1','176','920',409,'Retail Sale Id 1323741',55860.00,0.00,0.00,0.00,570.00,'2021-12-12 11:48:02','',''),(2257980,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-12 11:48:02','',''),(2258492,'1','176','920',409,'Retail Sale Id 1323985',26460.00,0.00,0.00,0.00,270.00,'2021-12-12 12:14:41','',''),(2258493,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-12 12:14:41','',''),(2258534,'1','176','920',409,'Retail Sale Id 1324009',28224.00,0.00,0.00,0.00,288.00,'2021-12-12 12:16:28','',''),(2258535,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-12 12:16:28','',''),(2258788,'1','176','920',409,'Retail Sale Id 1324129',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 12:27:52','',''),(2258789,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:27:52','',''),(2258840,'1','176','920',409,'Retail Sale Id 1324154',11698.32,0.00,0.00,0.00,925.50,'2021-12-12 12:30:14','',''),(2258841,'1','176','920',409,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-12 12:30:14','',''),(2259012,'1','176','920',409,'Retail Sale Id 1324240',24501.96,0.00,0.00,0.00,250.02,'2021-12-12 12:37:41','',''),(2259013,'1','176','920',409,'Retail sales',0.00,0.00,0.00,41.67,0.00,'2021-12-12 12:37:41','',''),(2259202,'1','176','920',409,'Retail Sale Id 1324323',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 12:46:21','',''),(2259203,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:46:21','',''),(2259334,'1','176','920',409,'Retail Sale Id 1324392',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 12:52:40','',''),(2259335,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:52:40','',''),(2259449,'1','176','920',409,'Retail Sale Id 1324446',23520.00,0.00,0.00,0.00,240.00,'2021-12-12 12:58:11','',''),(2259450,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 12:58:11','',''),(2259473,'1','176','920',409,'Retail Sale Id 1324458',242844.00,0.00,0.00,0.00,2478.00,'2021-12-12 12:59:28','',''),(2259474,'1','176','920',409,'Retail sales',0.00,0.00,0.00,413.00,0.00,'2021-12-12 12:59:28','',''),(2259609,'1','176','920',409,'Retail Sale Id 1324530',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 13:07:49','',''),(2259610,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:07:49','',''),(2259815,'1','176','920',409,'Retail Sale Id 1324634',632.00,0.00,0.00,0.00,50.00,'2021-12-12 13:18:44','',''),(2259816,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 13:18:44','',''),(2260147,'1','176','920',409,'Retail Sale Id 1324766',802.64,0.00,0.00,0.00,63.50,'2021-12-12 13:33:30','',''),(2260148,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 13:33:30','',''),(2260717,'1','176','920',409,'Retail Sale Id 1325006',701.52,0.00,0.00,0.00,55.50,'2021-12-12 13:59:54','',''),(2260718,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 13:59:54','',''),(2260803,'1','176','920',409,'Retail Sale Id 1325034',7900.00,0.00,0.00,0.00,625.00,'2021-12-12 14:03:22','',''),(2260804,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:03:22','',''),(2260918,'1','176','920',409,'Retail Sale Id 1325087',88200.00,0.00,0.00,0.00,900.00,'2021-12-12 14:09:29','',''),(2260919,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 14:09:29','',''),(2261065,'1','176','920',409,'Retail Sale Id 1325151',3501.28,0.00,0.00,0.00,277.00,'2021-12-12 14:16:53','',''),(2261066,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-12 14:16:53','',''),(2261909,'1','176','920',409,'Retail Sale Id 1325488',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 14:59:05','',''),(2261910,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 14:59:05','',''),(2261931,'1','176','920',409,'Retail Sale Id 1325498',13998.80,0.00,0.00,0.00,1107.50,'2021-12-12 15:00:24','',''),(2261932,'1','176','920',409,'Retail sales',0.00,0.00,0.00,22.15,0.00,'2021-12-12 15:00:24','',''),(2262165,'1','176','920',409,'Retail Sale Id 1325592',117600.00,0.00,0.00,0.00,1200.00,'2021-12-12 15:12:55','',''),(2262166,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-12 15:12:55','',''),(2262189,'1','176','920',409,'Retail Sale Id 1325603',998.56,0.00,0.00,0.00,79.00,'2021-12-12 15:14:04','',''),(2262190,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:14:04','',''),(2262222,'1','176','920',409,'Retail Sale Id 1325621',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 15:15:40','',''),(2262223,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 15:15:40','',''),(2262508,'1','176','920',409,'Retail Sale Id 1325755',58800.00,0.00,0.00,0.00,600.00,'2021-12-12 15:32:26','',''),(2262509,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 15:32:26','',''),(2262674,'1','176','920',409,'Retail Sale Id 1325832',176400.00,0.00,0.00,0.00,1800.00,'2021-12-12 15:41:28','',''),(2262675,'1','176','920',409,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 15:41:28','',''),(2262746,'1','176','920',409,'Retail Sale Id 1325860',1301.92,0.00,0.00,0.00,103.00,'2021-12-12 15:44:16','',''),(2262747,'1','176','920',409,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 15:44:16','',''),(2262979,'1','176','920',409,'Retail Sale Id 1325975',3798.32,0.00,0.00,0.00,300.50,'2021-12-12 16:00:39','',''),(2262980,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:00:39','',''),(2263091,'1','176','920',409,'Retail Sale Id 1326038',58800.00,0.00,0.00,0.00,600.00,'2021-12-12 16:09:07','',''),(2263092,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 16:09:07','',''),(2263186,'1','176','920',409,'Retail Sale Id 1326081',14700.00,0.00,0.00,0.00,150.00,'2021-12-12 16:15:42','',''),(2263187,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 16:15:42','',''),(2263220,'1','176','920',409,'Retail Sale Id 1326097',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 16:17:36','',''),(2263221,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 16:17:36','',''),(2263326,'1','176','920',409,'Retail Sale Id 1326138',88788.00,0.00,0.00,0.00,906.00,'2021-12-12 16:23:54','',''),(2263327,'1','176','920',409,'Retail sales',0.00,0.00,0.00,151.00,0.00,'2021-12-12 16:23:54','',''),(2263594,'1','176','920',409,'Retail Sale Id 1326257',44688.00,0.00,0.00,0.00,456.00,'2021-12-12 16:39:07','',''),(2263595,'1','176','920',409,'Retail sales',0.00,0.00,0.00,76.00,0.00,'2021-12-12 16:39:07','',''),(2263622,'1','176','920',409,'Retail Sale Id 1326275',29400.00,0.00,0.00,0.00,300.00,'2021-12-12 16:41:13','',''),(2263623,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 16:41:13','',''),(2264172,'1','176','920',409,'Retail Sale Id 1326517',998.56,0.00,0.00,0.00,79.00,'2021-12-12 17:18:52','',''),(2264173,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:18:52','',''),(2264192,'1','176','920',409,'Retail Sale Id 1326522',10428.00,0.00,0.00,0.00,825.00,'2021-12-12 17:20:44','',''),(2264193,'1','176','920',409,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-12 17:20:44','',''),(2264566,'1','176','920',409,'Retail Sale Id 1326686',73400.04,0.00,0.00,0.00,748.98,'2021-12-12 18:18:33','',''),(2264567,'1','176','920',409,'Retail sales',0.00,0.00,0.00,124.83,0.00,'2021-12-12 18:18:33','',''),(2265325,'1','176','920',409,'Retail Sale Id 1326791',3798.32,0.00,0.00,0.00,300.50,'2021-12-13 06:06:30','',''),(2265326,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:06:30','',''),(2265391,'1','176','920',409,'Retail Sale Id 1326822',7900.00,0.00,0.00,0.00,625.00,'2021-12-13 06:19:09','',''),(2265392,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:19:09','',''),(2265486,'1','176','920',409,'Retail Sale Id 1326864',88200.00,0.00,0.00,0.00,900.00,'2021-12-13 06:32:13','',''),(2265487,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 06:32:13','',''),(2265529,'1','176','920',409,'Retail Sale Id 1326883',1902.32,0.00,0.00,0.00,150.50,'2021-12-13 06:36:39','',''),(2265530,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 06:36:39','',''),(2265803,'1','176','920',409,'Retail Sale Id 1327021',6468.00,0.00,0.00,0.00,66.00,'2021-12-13 07:01:32','',''),(2265804,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-13 07:01:32','',''),(2265825,'1','176','920',409,'Retail Sale Id 1327038',7900.00,0.00,0.00,0.00,625.00,'2021-12-13 07:03:29','',''),(2265826,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:03:29','',''),(2266059,'1','176','920',409,'Retail Sale Id 1327159',56330.40,0.00,0.00,0.00,574.80,'2021-12-13 07:18:19','',''),(2266060,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.80,0.00,'2021-12-13 07:18:19','',''),(2266223,'1','176','920',409,'Retail Sale Id 1327240',58800.00,0.00,0.00,0.00,600.00,'2021-12-13 07:29:22','',''),(2266224,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 07:29:22','',''),(2266540,'1','176','920',409,'Retail Sale Id 1327304',23990.40,0.00,0.00,0.00,244.80,'2021-12-13 07:47:57','',''),(2266541,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.80,0.00,'2021-12-13 07:47:57','',''),(2266576,'1','176','920',409,'Retail Sale Id 1327407',1997.12,0.00,0.00,0.00,158.00,'2021-12-13 07:49:40','',''),(2266577,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 07:49:40','',''),(2266678,'1','176','920',409,'Retail Sale Id 1327455',36750.00,0.00,0.00,0.00,375.00,'2021-12-13 07:55:58','',''),(2266679,'1','176','920',409,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-13 07:55:58','',''),(2266876,'1','176','920',409,'Retail Sale Id 1327528',24002.16,0.00,0.00,0.00,244.92,'2021-12-13 08:04:14','',''),(2266877,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.82,0.00,'2021-12-13 08:04:14','',''),(2266909,'1','176','920',409,'Retail Sale Id 1327545',57624.00,0.00,0.00,0.00,588.00,'2021-12-13 08:05:58','',''),(2266910,'1','176','920',409,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-13 08:05:58','',''),(2266980,'1','176','920',409,'Retail Sale Id 1327574',67996.32,0.00,0.00,0.00,693.84,'2021-12-13 08:08:48','',''),(2266981,'1','176','920',409,'Retail sales',0.00,0.00,0.00,115.64,0.00,'2021-12-13 08:08:48','',''),(2267011,'1','176','920',409,'Retail Sale Id 1327589',1997.12,0.00,0.00,0.00,158.00,'2021-12-13 08:10:55','',''),(2267012,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:10:55','',''),(2267048,'1','176','920',409,'Retail Sale Id 1327601',11760.00,0.00,0.00,0.00,120.00,'2021-12-13 08:12:31','',''),(2267049,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 08:12:31','',''),(2267270,'1','176','920',409,'Retail Sale Id 1327672',29400.00,0.00,0.00,0.00,300.00,'2021-12-13 08:22:05','',''),(2267271,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 08:22:05','',''),(2267841,'1','176','920',409,'Retail Sale Id 1327917',29400.00,0.00,0.00,0.00,300.00,'2021-12-13 08:50:53','',''),(2267842,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 08:50:53','',''),(2268039,'1','176','920',409,'Retail Sale Id 1328003',29400.00,0.00,0.00,0.00,300.00,'2021-12-13 09:02:41','',''),(2268040,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:02:41','',''),(2268362,'1','176','920',409,'Retail Sale Id 1328149',117600.00,0.00,0.00,0.00,1200.00,'2021-12-13 09:20:35','',''),(2268363,'1','176','920',409,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-13 09:20:35','',''),(2270131,'1','176','920',409,'Retail Sale Id 1329036',47040.00,0.00,0.00,0.00,480.00,'2021-12-13 11:16:12','',''),(2270132,'1','176','920',409,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-13 11:16:12','',''),(2270211,'1','176','920',409,'Distributed to operational loss for sales id:339219',48998.58,0.00,0.00,84.19,0.00,'2021-12-13 11:21:23','',''),(2270285,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2288000.00,4000.00,0.00,0.00,'2021-12-13 11:26:37','',''),(2270292,'1','176',NULL,409,'Reception corrector for bridging 127242',0.00,0.00,0.00,4000.00,0.00,'2021-12-13 11:27:30','',''),(2270293,'1','176','920',409,'Received from bridging 127242',0.00,0.00,4000.00,0.00,0.00,'2021-12-13 11:27:30','',''),(2270306,'1','176','920',409,'Retail Sale Id 1329114',112308.00,0.00,0.00,0.00,3056.00,'2021-12-13 11:28:47','',''),(2270307,'1','176','920',409,'Retail sales',0.00,0.00,0.00,191.00,0.00,'2021-12-13 11:28:47','',''),(2270358,'1','176','920',409,'Retail Sale Id 1329141',28224.00,0.00,0.00,0.00,768.00,'2021-12-13 11:32:04','',''),(2270359,'1','176','920',409,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-13 11:32:04','',''),(2270374,'1','176','920',409,'Retail Sale Id 1329149',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 11:33:55','',''),(2270375,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:33:55','',''),(2270390,'1','176','920',409,'Retail Sale Id 1329159',226086.00,0.00,0.00,0.00,6152.00,'2021-12-13 11:35:50','',''),(2270391,'1','176','920',409,'Retail sales',0.00,0.00,0.00,384.50,0.00,'2021-12-13 11:35:50','',''),(2270429,'1','176','920',409,'Retail Sale Id 1329171',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 11:38:31','',''),(2270430,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:38:31','',''),(2270443,'1','176','920',409,'Retail Sale Id 1329178',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 11:39:38','',''),(2270444,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:39:38','',''),(2270463,'1','176','920',409,'Retail Sale Id 1329194',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 11:40:58','',''),(2270464,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:40:58','',''),(2270482,'1','176','920',409,'Retail Sale Id 1329204',135240.00,0.00,0.00,0.00,3680.00,'2021-12-13 11:42:12','',''),(2270483,'1','176','920',409,'Retail sales',0.00,0.00,0.00,230.00,0.00,'2021-12-13 11:42:12','',''),(2270526,'1','176','920',409,'Retail Sale Id 1329223',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 11:47:04','',''),(2270527,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:47:04','',''),(2270546,'1','176','920',409,'Retail Sale Id 1329237',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 11:48:56','',''),(2270547,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:48:56','',''),(2270574,'1','176','920',409,'Retail Sale Id 1329251',14999.88,0.00,0.00,0.00,408.16,'2021-12-13 11:51:06','',''),(2270575,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.51,0.00,'2021-12-13 11:51:06','',''),(2270596,'1','176','920',409,'Retail Sale Id 1329262',4000.56,0.00,0.00,0.00,379.80,'2021-12-13 11:53:34','',''),(2270597,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 11:53:34','',''),(2270613,'1','176','920',409,'Retail Sale Id 1329270',37926.00,0.00,0.00,0.00,1032.00,'2021-12-13 11:56:04','',''),(2270614,'1','176','920',409,'Retail sales',0.00,0.00,0.00,64.50,0.00,'2021-12-13 11:56:04','',''),(2270923,'1','176','920',409,'Retail Sale Id 1329438',1902.32,0.00,0.00,0.00,180.60,'2021-12-13 12:20:23','',''),(2270924,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 12:20:23','',''),(2270980,'1','176','920',409,'Retail Sale Id 1329469',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 12:25:02','',''),(2270981,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:25:02','',''),(2271024,'1','176','920',409,'Retail Sale Id 1329494',55860.00,0.00,0.00,0.00,1520.00,'2021-12-13 12:28:35','',''),(2271025,'1','176','920',409,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-13 12:28:35','',''),(2271136,'1','176','920',409,'Retail Sale Id 1329566',232848.00,0.00,0.00,0.00,6336.00,'2021-12-13 12:37:22','',''),(2271137,'1','176','920',409,'Retail sales',0.00,0.00,0.00,396.00,0.00,'2021-12-13 12:37:22','',''),(2271176,'1','176','920',409,'Retail Sale Id 1329588',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 12:40:30','',''),(2271177,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:40:30','',''),(2271376,'1','176','920',409,'Retail Sale Id 1329688',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 12:53:08','',''),(2271377,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:53:08','',''),(2271481,'1','176','920',409,'Retail Sale Id 1329742',28440.00,0.00,0.00,0.00,2700.00,'2021-12-13 12:58:50','',''),(2271482,'1','176','920',409,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-13 12:58:50','',''),(2271697,'1','176','920',409,'Retail Sale Id 1329842',23700.00,0.00,0.00,0.00,2250.00,'2021-12-13 13:13:26','',''),(2271698,'1','176','920',409,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-13 13:13:26','',''),(2272035,'1','176','920',409,'Retail Sale Id 1329963',12640.00,0.00,0.00,0.00,1200.00,'2021-12-13 13:29:53','',''),(2272036,'1','176','920',409,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 13:29:53','',''),(2272087,'1','176','920',409,'Retail Sale Id 1329997',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 13:33:32','',''),(2272088,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:33:32','',''),(2272248,'1','176','920',409,'Retail Sale Id 1330060',4999.12,0.00,0.00,0.00,474.60,'2021-12-13 13:43:10','',''),(2272249,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 13:43:10','',''),(2272402,'1','176','920',409,'Retail Sale Id 1330119',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 13:51:15','',''),(2272403,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:51:15','',''),(2272572,'1','176','920',409,'Retail Sale Id 1330197',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 13:59:30','',''),(2272573,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:59:30','',''),(2272738,'1','176','920',409,'Retail Sale Id 1330277',9996.00,0.00,0.00,0.00,272.00,'2021-12-13 14:11:00','',''),(2272739,'1','176','920',409,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-13 14:11:00','',''),(2272832,'1','176','920',409,'Retail Sale Id 1330399',35497.56,0.00,0.00,0.00,965.92,'2021-12-13 14:15:36','',''),(2272833,'1','176','920',409,'Retail sales',0.00,0.00,0.00,60.37,0.00,'2021-12-13 14:15:36','',''),(2273026,'1','176','920',409,'Retail Sale Id 1330483',58800.00,0.00,0.00,0.00,1600.00,'2021-12-13 14:27:55','',''),(2273027,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 14:27:55','',''),(2273168,'1','176','920',409,'Retail Sale Id 1330539',22151.60,0.00,0.00,0.00,2103.00,'2021-12-13 14:34:35','',''),(2273169,'1','176','920',409,'Retail sales',0.00,0.00,0.00,35.05,0.00,'2021-12-13 14:34:35','',''),(2273433,'1','176','920',409,'Retail Sale Id 1330670',5700.64,0.00,0.00,0.00,541.20,'2021-12-13 14:52:11','',''),(2273434,'1','176','920',409,'Retail sales',0.00,0.00,0.00,9.02,0.00,'2021-12-13 14:52:11','',''),(2273786,'1','176','920',409,'Retail Sale Id 1330848',88200.00,0.00,0.00,0.00,2400.00,'2021-12-13 15:15:18','',''),(2273787,'1','176','920',409,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 15:15:18','',''),(2273822,'1','176','920',409,'Retail Sale Id 1330871',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 15:17:25','',''),(2273823,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 15:17:25','',''),(2273872,'1','176','920',409,'Retail Sale Id 1330891',58800.00,0.00,0.00,0.00,1600.00,'2021-12-13 15:20:29','',''),(2273873,'1','176','920',409,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 15:20:29','',''),(2273905,'1','176','920',409,'Retail Sale Id 1330905',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 15:21:58','',''),(2273906,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 15:21:58','',''),(2274127,'1','176','920',409,'Retail Sale Id 1330995',3002.00,0.00,0.00,0.00,285.00,'2021-12-13 15:30:50','',''),(2274128,'1','176','920',409,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 15:30:50','',''),(2274248,'1','176','920',409,'Retail Sale Id 1331050',28812.00,0.00,0.00,0.00,784.00,'2021-12-13 15:36:00','',''),(2274249,'1','176','920',409,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-13 15:36:00','',''),(2274517,'1','176','920',409,'Retail Sale Id 1331180',32928.00,0.00,0.00,0.00,896.00,'2021-12-13 15:47:22','',''),(2274518,'1','176','920',409,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-13 15:47:22','',''),(2274595,'1','176','920',409,'Retail Sale Id 1331223',211680.00,0.00,0.00,0.00,5760.00,'2021-12-13 15:51:29','',''),(2274596,'1','176','920',409,'Retail sales',0.00,0.00,0.00,360.00,0.00,'2021-12-13 15:51:29','',''),(2274609,'1','176','920',409,'Retail Sale Id 1331234',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 15:52:30','',''),(2274610,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:52:30','',''),(2274639,'1','176','920',409,'Retail Sale Id 1331251',1902.32,0.00,0.00,0.00,180.60,'2021-12-13 15:54:32','',''),(2274640,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:54:32','',''),(2274770,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,783640.00,1370.00,0.00,0.00,'2021-12-13 16:02:00','',''),(2274795,'1','176',NULL,409,'Reception corrector for bridging 127264',0.00,0.00,0.00,1370.00,0.00,'2021-12-13 16:03:00','',''),(2274796,'1','176','920',409,'Received from bridging 127264',0.00,0.00,1370.00,0.00,0.00,'2021-12-13 16:03:00','',''),(2274827,'1','176','920',409,'Retail Sale Id 1331345',7002.56,0.00,0.00,0.00,664.80,'2021-12-13 16:04:33','',''),(2274828,'1','176','920',409,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-13 16:04:33','',''),(2274855,'1','176','920',409,'Retail Sale Id 1331358',4999.12,0.00,0.00,0.00,474.60,'2021-12-13 16:06:48','',''),(2274856,'1','176','920',409,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 16:06:48','',''),(2274984,'1','176','920',409,'Retail Sale Id 1331425',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 16:13:30','',''),(2274985,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 16:13:30','',''),(2275030,'1','176','920',409,'Retail Sale Id 1331447',29400.00,0.00,0.00,0.00,800.00,'2021-12-13 16:15:35','',''),(2275031,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 16:15:35','',''),(2275050,'1','176','920',409,'Retail Sale Id 1331456',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 16:16:35','',''),(2275051,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:16:35','',''),(2275091,'1','176','920',409,'Retail Sale Id 1331476',11060.00,0.00,0.00,0.00,1050.00,'2021-12-13 16:18:49','',''),(2275092,'1','176','920',409,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-13 16:18:50','',''),(2275532,'1','176','920',409,'Retail Sale Id 1331706',57624.00,0.00,0.00,0.00,1568.00,'2021-12-13 16:43:14','',''),(2275534,'1','176','920',409,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-13 16:43:14','',''),(2275574,'1','176','920',409,'Retail Sale Id 1331725',14700.00,0.00,0.00,0.00,400.00,'2021-12-13 16:46:20','',''),(2275575,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 16:46:20','',''),(2275697,'1','176','920',409,'Retail Sale Id 1331790',14112.00,0.00,0.00,0.00,384.00,'2021-12-13 16:54:49','',''),(2275698,'1','176','920',409,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-13 16:54:49','',''),(2275721,'1','176','920',409,'Retail Sale Id 1331801',1997.12,0.00,0.00,0.00,189.60,'2021-12-13 16:55:56','',''),(2275722,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 16:55:56','',''),(2276145,'1','176','920',409,'Retail Sale Id 1332019',25877.88,0.00,0.00,0.00,704.16,'2021-12-13 17:39:10','',''),(2276146,'1','176','920',409,'Retail sales',0.00,0.00,0.00,44.01,0.00,'2021-12-13 17:39:10','',''),(2276936,'1','176','920',409,'Retail Sale Id 1332121',132300.00,0.00,0.00,0.00,3600.00,'2021-12-14 06:03:33','',''),(2276937,'1','176','920',409,'Retail sales',0.00,0.00,0.00,225.00,0.00,'2021-12-14 06:03:33','',''),(2277125,'1','176','920',409,'Retail Sale Id 1332202',7900.00,0.00,0.00,0.00,750.00,'2021-12-14 06:22:48','',''),(2277126,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:22:48','',''),(2277169,'1','176','920',409,'Retail Sale Id 1332210',76440.00,0.00,0.00,0.00,2080.00,'2021-12-14 06:24:34','',''),(2277170,'1','176','920',409,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-14 06:24:34','',''),(2278592,'1','176','920',409,'Retail Sale Id 1332994',1902.32,0.00,0.00,0.00,180.60,'2021-12-14 07:53:34','',''),(2278593,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-14 07:53:34','',''),(2278878,'1','176','920',409,'Retail Sale Id 1333133',3798.32,0.00,0.00,0.00,360.60,'2021-12-14 08:08:03','',''),(2278879,'1','176','920',409,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:08:03','',''),(2278916,'1','176','920',409,'Retail Sale Id 1333155',29400.00,0.00,0.00,0.00,800.00,'2021-12-14 08:10:14','',''),(2278917,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 08:10:14','',''),(2278932,'1','176','920',409,'Retail Sale Id 1333163',32340.00,0.00,0.00,0.00,880.00,'2021-12-14 08:11:21','',''),(2278933,'1','176','920',409,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-14 08:11:21','',''),(2278974,'1','176','920',409,'Retail Sale Id 1333181',91728.00,0.00,0.00,0.00,2496.00,'2021-12-14 08:13:04','',''),(2278975,'1','176','920',409,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-14 08:13:04','',''),(2279061,'1','176','920',409,'Retail Sale Id 1333227',998.56,0.00,0.00,0.00,94.80,'2021-12-14 08:17:25','',''),(2279062,'1','176','920',409,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 08:17:25','',''),(2279085,'1','176','920',409,'Retail Sale Id 1333260',7900.00,0.00,0.00,0.00,750.00,'2021-12-14 08:18:43','',''),(2279086,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:18:43','',''),(2279492,'1','176','920',409,'Retail Sale Id 1333471',29400.00,0.00,0.00,0.00,800.00,'2021-12-14 08:41:14','',''),(2279493,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 08:41:14','',''),(2279506,'1','176','920',409,'Retail Sale Id 1333480',29400.00,0.00,0.00,0.00,800.00,'2021-12-14 08:42:07','',''),(2279507,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 08:42:07','',''),(2279890,'1','176','920',409,'Retail Sale Id 1333642',1902.32,0.00,0.00,0.00,180.60,'2021-12-14 09:00:14','',''),(2279891,'1','176','920',409,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-14 09:00:14','',''),(2280466,'1','176','920',409,'Retail Sale Id 1333892',29400.00,0.00,0.00,0.00,800.00,'2021-12-14 09:26:48','',''),(2280467,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 09:26:48','',''),(2280650,'1','176','920',409,'Retail Sale Id 1333988',14700.00,0.00,0.00,0.00,400.00,'2021-12-14 09:37:14','',''),(2280651,'1','176','920',409,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 09:37:14','',''),(2280872,'1','176','920',409,'Retail Sale Id 1334093',145824.00,0.00,0.00,0.00,3968.00,'2021-12-14 09:50:21','',''),(2280873,'1','176','920',409,'Retail sales',0.00,0.00,0.00,248.00,0.00,'2021-12-14 09:50:21','',''),(2280989,'1','176','920',409,'Retail Sale Id 1334153',3197.92,0.00,0.00,0.00,303.60,'2021-12-14 09:58:10','',''),(2280990,'1','176','920',409,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-14 09:58:10','',''),(2281184,'1','176','920',409,'Retail Sale Id 1334256',29400.00,0.00,0.00,0.00,800.00,'2021-12-14 10:09:55','',''),(2281185,'1','176','920',409,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 10:09:55','',''),(2281475,'1','176','920',409,'Retail Sale Id 1334393',7900.00,0.00,0.00,0.00,750.00,'2021-12-14 10:21:47','',''),(2281476,'1','176','920',409,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:21:47','',''),(2281595,'1','176','920',409,'Retail Sale Id 1334455',24002.16,0.00,0.00,0.00,653.12,'2021-12-14 10:28:57','',''),(2281596,'1','176','920',409,'Retail sales',0.00,0.00,0.00,40.82,0.00,'2021-12-14 10:28:57','',''),(2282048,'1','176','920',409,'Retail Sale Id 1334752',147000.00,0.00,0.00,0.00,4000.00,'2021-12-14 10:55:05','',''),(2282049,'1','176','920',409,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-14 10:55:05','',''),(2282505,'1','176','920',409,'Retail Sale Id 1335395',7900.00,0.00,0.00,12.50,750.00,'2021-12-14 12:32:32','',''),(2282795,'1','176','920',409,'Retail Sale Id 1335634',205800.00,0.00,0.00,350.00,5600.00,'2021-12-14 13:06:50','',''),(2282815,'1','176','920',409,'Retail Sale Id 1335657',130536.00,0.00,0.00,222.00,3552.00,'2021-12-14 13:10:33','',''),(2282876,'1','176','920',409,'Distributed to operational loss for sales id:339553',36825.36,0.00,0.00,64.38,0.00,'2021-12-14 13:20:08','',''),(2282993,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2232000.00,4000.00,0.00,0.00,'2021-12-14 13:32:39','',''),(2283001,'1','176',NULL,409,'Reception corrector for bridging 127352',0.00,0.00,0.00,4000.00,0.00,'2021-12-14 13:33:31','',''),(2283002,'1','176','920',409,'Received from bridging 127352',0.00,0.00,4000.00,0.00,0.00,'2021-12-14 13:33:31','',''),(2283139,'1','176','920',409,'Retail Sale Id 1335901',197400.00,0.00,0.00,350.00,2100.00,'2021-12-14 13:48:50','',''),(2283151,'1','176','920',409,'Retail Sale Id 1335913',28200.00,0.00,0.00,50.00,300.00,'2021-12-14 13:50:51','',''),(2283395,'1','176','920',409,'Retail Sale Id 1336055',84600.00,0.00,0.00,150.00,900.00,'2021-12-14 14:12:20','',''),(2283436,'1','176','920',409,'Retail Sale Id 1336092',15400.00,0.00,0.00,25.00,1450.00,'2021-12-14 14:17:56','',''),(2283536,'1','176','920',409,'Retail Sale Id 1336178',56400.00,0.00,0.00,100.00,600.00,'2021-12-14 14:28:26','',''),(2283571,'1','176','920',409,'Retail Sale Id 1336197',22560.00,0.00,0.00,40.00,240.00,'2021-12-14 14:31:20','',''),(2283878,'1','176','920',409,'Retail Sale Id 1336444',9997.68,0.00,0.00,16.23,941.34,'2021-12-14 15:12:14','',''),(2284062,'1','176','920',409,'Retail Sale Id 1336586',28200.00,0.00,0.00,50.00,300.00,'2021-12-14 15:34:31','',''),(2284109,'1','176','920',409,'Retail Sale Id 1336612',19096.00,0.00,0.00,31.00,1798.00,'2021-12-14 15:38:47','',''),(2284628,'1','176','920',409,'Retail Sale Id 1337008',84600.00,0.00,0.00,150.00,900.00,'2021-12-14 16:25:17','',''),(2284737,'1','176','920',409,'Retail Sale Id 1337102',29999.16,0.00,0.00,53.19,319.14,'2021-12-14 16:33:35','',''),(2284750,'1','176','920',409,'Retail Sale Id 1337117',38500.00,0.00,0.00,62.50,3625.00,'2021-12-14 16:35:08','',''),(2284933,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,318060.00,570.00,0.00,0.00,'2021-12-14 16:49:21','',''),(2284941,'1','176',NULL,409,'Reception corrector for bridging 127379',0.00,0.00,0.00,570.00,0.00,'2021-12-14 16:50:25','',''),(2284942,'1','176','920',409,'Received from bridging 127379',0.00,0.00,570.00,0.00,0.00,'2021-12-14 16:50:25','',''),(2285058,'1','176','920',409,'Retail Sale Id 1337333',14100.00,0.00,0.00,25.00,150.00,'2021-12-14 17:02:58','',''),(2285106,'1','176','920',409,'Retail Sale Id 1337390',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 17:09:03','',''),(2285196,'1','176','920',409,'Retail Sale Id 1337463',1848.00,0.00,0.00,3.00,174.00,'2021-12-14 17:24:35','',''),(2285203,'1','176','920',409,'Retail Sale Id 1337469',3696.00,0.00,0.00,6.00,348.00,'2021-12-14 17:27:06','',''),(2285212,'1','176','920',409,'Retail Sale Id 1337481',56400.00,0.00,0.00,100.00,600.00,'2021-12-14 17:28:44','',''),(2285217,'1','176','920',409,'Retail Sale Id 1337486',28200.00,0.00,0.00,50.00,300.00,'2021-12-14 17:30:14','',''),(2286065,'1','176','920',409,'Retail Sale Id 1337762',59784.00,0.00,0.00,106.00,636.00,'2021-12-15 06:26:46','',''),(2286091,'1','176','920',409,'Retail Sale Id 1337791',112800.00,0.00,0.00,200.00,1200.00,'2021-12-15 06:31:14','',''),(2286123,'1','176','920',409,'Retail Sale Id 1337796',282000.00,0.00,0.00,500.00,3000.00,'2021-12-15 06:36:00','',''),(2286249,'1','176','920',409,'Retail Sale Id 1337904',5001.92,0.00,0.00,8.12,470.96,'2021-12-15 06:50:51','',''),(2286276,'1','176','920',409,'Retail Sale Id 1337950',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 06:56:15','',''),(2286302,'1','176','920',409,'Retail Sale Id 1337971',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 06:59:37','',''),(2286327,'1','176','920',409,'Retail Sale Id 1337989',3080.00,0.00,0.00,5.00,290.00,'2021-12-15 07:01:31','',''),(2286503,'1','176','920',409,'Retail Sale Id 1338156',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 07:22:58','',''),(2286534,'1','176','920',409,'Retail Sale Id 1338199',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 07:27:25','',''),(2286550,'1','176','920',409,'Retail Sale Id 1338213',25380.00,0.00,0.00,45.00,270.00,'2021-12-15 07:28:58','',''),(2286573,'1','176','920',409,'Retail Sale Id 1338226',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 07:30:20','',''),(2286620,'1','176','920',409,'Retail Sale Id 1338266',165816.00,0.00,0.00,294.00,1764.00,'2021-12-15 07:35:14','',''),(2286662,'1','176','920',409,'Retail Sale Id 1338301',48504.00,0.00,0.00,86.00,516.00,'2021-12-15 07:39:03','',''),(2286684,'1','176','920',409,'Retail Sale Id 1338334',56400.00,0.00,0.00,100.00,600.00,'2021-12-15 07:42:15','',''),(2286760,'1','176','920',409,'Retail Sale Id 1338387',42300.00,0.00,0.00,75.00,450.00,'2021-12-15 07:49:12','',''),(2286893,'1','176','920',409,'Retail Sale Id 1338479',3498.88,0.00,0.00,5.68,329.44,'2021-12-15 08:00:45','',''),(2287119,'1','176','920',409,'Retail Sale Id 1338636',141000.00,0.00,0.00,250.00,1500.00,'2021-12-15 08:18:57','',''),(2287173,'1','176','920',409,'Retail Sale Id 1338682',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 08:24:23','',''),(2287189,'1','176','920',409,'Retail Sale Id 1338700',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 08:27:05','',''),(2287306,'1','176','920',409,'Retail Sale Id 1338792',1848.00,0.00,0.00,3.00,174.00,'2021-12-15 08:38:33','',''),(2287420,'1','176','920',409,'Retail Sale Id 1338901',29892.00,0.00,0.00,53.00,318.00,'2021-12-15 08:51:19','',''),(2287435,'1','176','920',409,'Retail Sale Id 1338918',84600.00,0.00,0.00,150.00,900.00,'2021-12-15 08:53:25','',''),(2287756,'1','176','920',409,'Retail Sale Id 1339171',13502.72,0.00,0.00,21.92,1271.36,'2021-12-15 09:28:32','',''),(2287768,'1','176','920',409,'Retail Sale Id 1339180',1250.48,0.00,0.00,2.03,117.74,'2021-12-15 09:30:06','',''),(2287807,'1','176','920',409,'Retail Sale Id 1339214',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 09:34:42','',''),(2287832,'1','176','920',409,'Retail Sale Id 1339231',3098.48,0.00,0.00,5.03,291.74,'2021-12-15 09:36:26','',''),(2287934,'1','176','920',409,'Retail Sale Id 1339323',166944.00,0.00,0.00,296.00,1776.00,'2021-12-15 09:49:01','',''),(2287953,'1','176','920',409,'Retail Sale Id 1339342',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 09:51:27','',''),(2287966,'1','176','920',409,'Retail Sale Id 1339348',84600.00,0.00,0.00,150.00,900.00,'2021-12-15 09:53:47','',''),(2288005,'1','176','920',409,'Retail Sale Id 1339375',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 09:57:03','',''),(2288104,'1','176','920',409,'Retail Sale Id 1339458',143256.00,0.00,0.00,254.00,1524.00,'2021-12-15 10:09:02','',''),(2288138,'1','176','920',409,'Retail Sale Id 1339494',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 10:15:11','',''),(2288148,'1','176','920',409,'Retail Sale Id 1339503',56400.00,0.00,0.00,100.00,600.00,'2021-12-15 10:16:24','',''),(2290394,'1','176','920',409,'Retail Sale Id 1341345',68176.32,0.00,0.00,120.88,725.28,'2021-12-15 14:38:32','',''),(2290514,'1','176','920',409,'Distributed to operational loss for sales id:339880',36225.36,0.00,0.00,64.92,0.00,'2021-12-15 14:50:36','',''),(2291104,'1','176','920',409,'Retail Sale Id 1341845',11280.00,0.00,0.00,20.00,120.00,'2021-12-15 15:34:35','',''),(2291113,'1','176','920',409,'Retail Sale Id 1341854',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 15:35:31','',''),(2291133,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2232000.00,4000.00,0.00,0.00,'2021-12-15 15:37:17','',''),(2291137,'1','176',NULL,409,'Reception corrector for bridging 127512',0.00,0.00,0.00,4000.00,0.00,'2021-12-15 15:38:03','',''),(2291138,'1','176','920',409,'Received from bridging 127512',0.00,0.00,4000.00,0.00,0.00,'2021-12-15 15:38:03','',''),(2291236,'1','176','920',409,'Retail Sale Id 1341963',33997.92,0.00,0.00,60.28,361.68,'2021-12-15 15:47:46','',''),(2291255,'1','176','920',409,'Retail Sale Id 1341983',34968.00,0.00,0.00,62.00,372.00,'2021-12-15 15:49:49','',''),(2291409,'1','176','920',409,'Retail Sale Id 1342104',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 16:01:32','',''),(2291534,'1','176','920',409,'Retail Sale Id 1342231',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 16:14:21','',''),(2291567,'1','176','920',409,'Retail Sale Id 1342250',48222.00,0.00,0.00,85.50,513.00,'2021-12-15 16:16:59','',''),(2291585,'1','176','920',409,'Retail Sale Id 1342272',997.92,0.00,0.00,1.62,93.96,'2021-12-15 16:18:04','',''),(2291636,'1','176','920',409,'Retail Sale Id 1342320',98700.00,0.00,0.00,175.00,1050.00,'2021-12-15 16:22:37','',''),(2291655,'1','176','920',409,'Retail Sale Id 1342330',18612.00,0.00,0.00,33.00,198.00,'2021-12-15 16:24:37','',''),(2291798,'1','176','920',409,'Retail Sale Id 1342473',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 16:37:55','',''),(2291914,'1','176','920',409,'Retail Sale Id 1342561',15002.40,0.00,0.00,26.60,159.60,'2021-12-15 16:46:33','',''),(2291981,'1','176','920',409,'Retail Sale Id 1342631',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 16:52:48','',''),(2291997,'1','176','920',409,'Retail Sale Id 1342647',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 16:54:36','',''),(2292018,'1','176','920',409,'Retail Sale Id 1342667',26998.68,0.00,0.00,47.87,287.22,'2021-12-15 16:57:46','',''),(2292083,'1','176','920',409,'Retail Sale Id 1342725',28200.00,0.00,0.00,50.00,300.00,'2021-12-15 17:04:20','',''),(2292094,'1','176','920',409,'Retail Sale Id 1342731',13998.48,0.00,0.00,24.82,148.92,'2021-12-15 17:05:11','',''),(2292115,'1','176','920',409,'Retail Sale Id 1342746',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 17:07:10','',''),(2292131,'1','176','920',409,'Retail Sale Id 1342762',14500.44,0.00,0.00,25.71,154.26,'2021-12-15 17:09:09','',''),(2292219,'1','176','920',409,'Retail Sale Id 1342835',69050.52,0.00,0.00,122.43,734.58,'2021-12-15 17:20:11','',''),(2292249,'1','176','920',409,'Retail Sale Id 1342863',55272.00,0.00,0.00,98.00,588.00,'2021-12-15 17:25:46','',''),(2292379,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,669600.00,1200.00,0.00,0.00,'2021-12-15 17:47:06','',''),(2292383,'1','176',NULL,409,'Reception corrector for bridging 127529',0.00,0.00,0.00,1200.00,0.00,'2021-12-15 17:47:51','',''),(2292384,'1','176','920',409,'Received from bridging 127529',0.00,0.00,1200.00,0.00,0.00,'2021-12-15 17:47:51','',''),(2292954,'1','176','920',409,'Retail Sale Id 1343193',50760.00,0.00,0.00,90.00,540.00,'2021-12-16 05:43:48','',''),(2292957,'1','176','920',409,'Retail Sale Id 1343197',22001.64,0.00,0.00,39.01,234.06,'2021-12-16 05:49:02','',''),(2292985,'1','176','920',409,'Retail Sale Id 1343220',119850.00,0.00,0.00,212.50,1275.00,'2021-12-16 06:04:06','',''),(2293071,'1','176','920',409,'Retail Sale Id 1343276',84600.00,0.00,0.00,150.00,900.00,'2021-12-16 06:18:01','',''),(2293238,'1','176','920',409,'Retail Sale Id 1343401',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 06:39:27','',''),(2293254,'1','176','920',409,'Retail Sale Id 1343406',2999.92,0.00,0.00,4.87,282.46,'2021-12-16 06:40:43','',''),(2293269,'1','176','920',409,'Retail Sale Id 1343422',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 06:42:04','',''),(2293325,'1','176','920',409,'Retail Sale Id 1343476',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 06:47:01','',''),(2293368,'1','176','920',409,'Retail Sale Id 1343511',14100.00,0.00,0.00,25.00,150.00,'2021-12-16 06:50:32','',''),(2293703,'1','176','920',409,'Retail Sale Id 1343772',54708.00,0.00,0.00,97.00,582.00,'2021-12-16 07:21:30','',''),(2293793,'1','176','920',409,'Retail Sale Id 1343851',1201.20,0.00,0.00,1.95,113.10,'2021-12-16 07:29:19','',''),(2293995,'1','176','920',409,'Retail Sale Id 1343961',63168.00,0.00,0.00,112.00,672.00,'2021-12-16 07:42:05','',''),(2294044,'1','176','920',409,'Retail Sale Id 1343997',6160.00,0.00,0.00,10.00,580.00,'2021-12-16 07:44:12','',''),(2294083,'1','176','920',409,'Retail Sale Id 1344014',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 07:45:40','',''),(2294172,'1','176','920',409,'Retail Sale Id 1344039',93624.00,0.00,0.00,166.00,996.00,'2021-12-16 07:48:55','',''),(2294204,'1','176','920',409,'Retail Sale Id 1344072',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 07:52:20','',''),(2294236,'1','176','920',409,'Retail Sale Id 1344102',6204.00,0.00,0.00,11.00,66.00,'2021-12-16 07:56:48','',''),(2294248,'1','176','920',409,'Retail Sale Id 1344109',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 07:57:52','',''),(2294291,'1','176','920',409,'Retail Sale Id 1344154',3384.00,0.00,0.00,6.00,36.00,'2021-12-16 08:03:14','',''),(2294303,'1','176','920',409,'Retail Sale Id 1344166',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 08:04:16','',''),(2294344,'1','176','920',409,'Retail Sale Id 1344175',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 08:05:19','',''),(2294352,'1','176','920',409,'Retail Sale Id 1344183',21499.68,0.00,0.00,38.12,228.72,'2021-12-16 08:06:25','',''),(2294372,'1','176','920',409,'Retail Sale Id 1344194',27636.00,0.00,0.00,49.00,294.00,'2021-12-16 08:07:32','',''),(2294384,'1','176','920',409,'Retail Sale Id 1344211',84600.00,0.00,0.00,150.00,900.00,'2021-12-16 08:08:39','',''),(2294424,'1','176','920',409,'Retail Sale Id 1344237',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 08:11:03','',''),(2294443,'1','176','920',409,'Retail Sale Id 1344255',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 08:12:34','',''),(2294477,'1','176','920',409,'Retail Sale Id 1344286',3997.84,0.00,0.00,6.49,376.42,'2021-12-16 08:14:42','',''),(2294528,'1','176','920',409,'Retail Sale Id 1344314',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 08:17:38','',''),(2294539,'1','176','920',409,'Retail Sale Id 1344327',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 08:18:57','',''),(2294554,'1','176','920',409,'Retail Sale Id 1344342',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 08:20:00','',''),(2294573,'1','176','920',409,'Retail Sale Id 1344357',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 08:21:14','',''),(2294600,'1','176','920',409,'Retail Sale Id 1344377',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 08:23:13','',''),(2294660,'1','176','920',409,'Retail Sale Id 1344419',1848.00,0.00,0.00,3.00,174.00,'2021-12-16 08:27:59','',''),(2294684,'1','176','920',409,'Retail Sale Id 1344440',6160.00,0.00,0.00,10.00,580.00,'2021-12-16 08:30:00','',''),(2294699,'1','176','920',409,'Retail Sale Id 1344456',3997.84,0.00,0.00,6.49,376.42,'2021-12-16 08:32:01','',''),(2294719,'1','176','920',409,'Retail Sale Id 1344471',1848.00,0.00,0.00,3.00,174.00,'2021-12-16 08:33:28','',''),(2294757,'1','176','920',409,'Retail Sale Id 1344500',5999.84,0.00,0.00,9.74,564.92,'2021-12-16 08:36:20','',''),(2294887,'1','176','920',409,'Retail Sale Id 1344570',997.92,0.00,0.00,1.62,93.96,'2021-12-16 08:43:31','',''),(2295138,'1','176','920',409,'Retail Sale Id 1344779',1299.76,0.00,0.00,2.11,122.38,'2021-12-16 09:06:11','',''),(2295152,'1','176','920',409,'Retail Sale Id 1344794',702.24,0.00,0.00,1.14,66.12,'2021-12-16 09:07:33','',''),(2295246,'1','176','920',409,'Retail Sale Id 1344875',17997.24,0.00,0.00,31.91,191.46,'2021-12-16 09:15:31','',''),(2295427,'1','176','920',409,'Retail Sale Id 1345030',34939.80,0.00,0.00,61.95,371.70,'2021-12-16 09:32:26','',''),(2295441,'1','176','920',409,'Retail Sale Id 1345042',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 09:33:43','',''),(2295530,'1','176','920',409,'Retail Sale Id 1345120',2002.00,0.00,0.00,3.25,188.50,'2021-12-16 09:42:09','',''),(2295591,'1','176','920',409,'Retail Sale Id 1345174',62040.00,0.00,0.00,110.00,660.00,'2021-12-16 09:48:13','',''),(2295805,'1','176','920',409,'Retail Sale Id 1345299',112800.00,0.00,0.00,200.00,1200.00,'2021-12-16 10:03:54','',''),(2295951,'1','176','920',409,'Retail Sale Id 1345436',33840.00,0.00,0.00,60.00,360.00,'2021-12-16 10:19:23','',''),(2295981,'1','176','920',409,'Retail Sale Id 1345460',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 10:22:07','',''),(2295994,'1','176','920',409,'Retail Sale Id 1345472',27636.00,0.00,0.00,49.00,294.00,'2021-12-16 10:23:20','',''),(2296140,'1','176','920',409,'Retail Sale Id 1345617',56400.00,0.00,0.00,100.00,600.00,'2021-12-16 10:41:50','',''),(2296404,'1','176','920',409,'Retail Sale Id 1345872',43992.00,0.00,0.00,78.00,468.00,'2021-12-16 11:11:00','',''),(2296447,'1','176','920',409,'Retail Sale Id 1345910',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 11:15:22','',''),(2296455,'1','176','920',409,'Retail Sale Id 1345917',62040.00,0.00,0.00,110.00,660.00,'2021-12-16 11:16:34','',''),(2296573,'1','176','920',409,'Retail Sale Id 1346014',52677.60,0.00,0.00,93.40,560.40,'2021-12-16 11:30:59','',''),(2296639,'1','176','920',409,'Retail Sale Id 1346080',28200.00,0.00,0.00,50.00,300.00,'2021-12-16 11:38:30','',''),(2296673,'1','176','920',409,'Retail Sale Id 1346116',23101.44,0.00,0.00,40.96,245.76,'2021-12-16 11:42:33','',''),(2296993,'1','176','920',409,'Retail Sale Id 1346384',11402.16,0.00,0.00,18.51,1073.58,'2021-12-16 12:18:35','',''),(2297077,'1','176','920',409,'Retail Sale Id 1346465',82908.00,0.00,0.00,147.00,882.00,'2021-12-16 12:29:58','',''),(2297389,'1','176','920',409,'Retail Sale Id 1346720',6702.08,0.00,0.00,10.88,631.04,'2021-12-16 13:04:36','',''),(2297402,'1','176','920',409,'Retail Sale Id 1346731',1848.00,0.00,0.00,3.00,174.00,'2021-12-16 13:06:10','',''),(2297417,'1','176','920',409,'Retail Sale Id 1346745',27636.00,0.00,0.00,49.00,294.00,'2021-12-16 13:08:11','',''),(2297757,'1','176','920',409,'Retail Sale Id 1347051',1503.04,0.00,0.00,2.44,141.52,'2021-12-16 13:42:48','',''),(2298173,'1','176','920',409,'Retail Sale Id 1347364',3997.84,0.00,0.00,6.49,376.42,'2021-12-16 14:19:29','',''),(2298572,'1','176','920',409,'Retail Sale Id 1347637',16000.68,0.00,0.00,28.37,170.22,'2021-12-16 14:50:39','',''),(2298598,'1','176','920',409,'Retail Sale Id 1347655',17997.24,0.00,0.00,31.91,191.46,'2021-12-16 14:52:09','',''),(2298745,'1','176','920',409,'Retail Sale Id 1347796',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 15:11:57','',''),(2298992,'1','176','920',409,'Retail Sale Id 1347948',2500.96,0.00,0.00,4.06,235.48,'2021-12-16 15:28:53','',''),(2299106,'1','176','920',409,'Retail Sale Id 1348040',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 15:37:26','',''),(2299190,'1','176','920',409,'Retail Sale Id 1348113',15400.00,0.00,0.00,25.00,1450.00,'2021-12-16 15:43:18','',''),(2299391,'1','176','920',409,'Retail Sale Id 1348265',17484.00,0.00,0.00,31.00,186.00,'2021-12-16 15:57:37','',''),(2299424,'1','176','920',409,'Retail Sale Id 1348278',2999.92,0.00,0.00,4.87,282.46,'2021-12-16 15:59:21','',''),(2299572,'1','176','920',409,'Retail Sale Id 1348402',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 16:09:49','',''),(2299759,'1','176','920',409,'Retail Sale Id 1348516',84600.00,0.00,0.00,150.00,900.00,'2021-12-16 16:20:47','',''),(2299864,'1','176','920',409,'Retail Sale Id 1348625',9548.00,0.00,0.00,15.50,899.00,'2021-12-16 16:29:55','',''),(2299954,'1','176','920',409,'Retail Sale Id 1348712',142692.00,0.00,0.00,253.00,1518.00,'2021-12-16 16:39:12','',''),(2300012,'1','176','920',409,'Retail Sale Id 1348769',22999.92,0.00,0.00,40.78,244.68,'2021-12-16 16:45:00','',''),(2300028,'1','176','920',409,'Retail Sale Id 1348782',27072.00,0.00,0.00,48.00,288.00,'2021-12-16 16:46:23','',''),(2300038,'1','176','920',409,'Retail Sale Id 1348790',14100.00,0.00,0.00,25.00,150.00,'2021-12-16 16:47:06','',''),(2300046,'1','176','920',409,'Retail Sale Id 1348802',169200.00,0.00,0.00,300.00,1800.00,'2021-12-16 16:47:53','',''),(2300516,'1','176','920',409,'Retail Sale Id 1349166',130566.00,0.00,0.00,231.50,1389.00,'2021-12-16 17:48:08','',''),(2300526,'1','176','920',409,'Retail Sale Id 1349175',8460.00,0.00,0.00,15.00,90.00,'2021-12-16 17:50:03','',''),(2300597,'1','176','920',409,'Distributed to operational loss for sales id:340241',38959.56,0.00,0.00,69.82,0.00,'2021-12-16 18:06:45','',''),(2301890,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2232000.00,4000.00,0.00,0.00,'2021-12-17 07:16:37','',''),(2301898,'1','176',NULL,409,'Reception corrector for bridging 127682',0.00,0.00,0.00,4000.00,0.00,'2021-12-17 07:17:25','',''),(2301899,'1','176','920',409,'Received from bridging 127682',0.00,0.00,4000.00,0.00,0.00,'2021-12-17 07:17:25','',''),(2301922,'1','176','920',409,'Retail Sale Id 1349895',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 07:19:33','',''),(2301936,'1','176','920',409,'Retail Sale Id 1349910',3098.48,0.00,0.00,5.03,291.74,'2021-12-17 07:20:46','',''),(2301943,'1','176','920',409,'Retail Sale Id 1349917',126900.00,0.00,0.00,225.00,1350.00,'2021-12-17 07:21:55','',''),(2301976,'1','176','920',409,'Retail Sale Id 1349951',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 07:26:19','',''),(2301987,'1','176','920',409,'Retail Sale Id 1349966',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 07:27:52','',''),(2302018,'1','176','920',409,'Retail Sale Id 1349993',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 07:30:05','',''),(2302179,'1','176','920',409,'Retail Sale Id 1350100',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 07:44:28','',''),(2302352,'1','176','920',409,'Retail Sale Id 1350244',6997.76,0.00,0.00,11.36,658.88,'2021-12-17 08:01:04','',''),(2302380,'1','176','920',409,'Retail Sale Id 1350274',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 08:03:37','',''),(2302443,'1','176','920',409,'Retail Sale Id 1350337',2500.96,0.00,0.00,4.06,235.48,'2021-12-17 08:10:39','',''),(2302576,'1','176','920',409,'Retail Sale Id 1350472',89676.00,0.00,0.00,159.00,954.00,'2021-12-17 08:23:09','',''),(2302589,'1','176','920',409,'Retail Sale Id 1350487',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:25:03','',''),(2302637,'1','176','920',409,'Retail Sale Id 1350507',20997.72,0.00,0.00,37.23,223.38,'2021-12-17 08:26:47','',''),(2302681,'1','176','920',409,'Retail Sale Id 1350556',76140.00,0.00,0.00,135.00,810.00,'2021-12-17 08:31:43','',''),(2302714,'1','176','920',409,'Retail Sale Id 1350571',23999.36,0.00,0.00,38.96,2259.68,'2021-12-17 08:34:05','',''),(2302727,'1','176','920',409,'Retail Sale Id 1350595',1848.00,0.00,0.00,3.00,174.00,'2021-12-17 08:35:37','',''),(2302866,'1','176','920',409,'Retail Sale Id 1350684',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 08:47:01','',''),(2302895,'1','176','920',409,'Retail Sale Id 1350708',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 08:50:01','',''),(2302932,'1','176','920',409,'Retail Sale Id 1350731',25662.00,0.00,0.00,45.50,273.00,'2021-12-17 08:51:43','',''),(2302984,'1','176','920',409,'Retail Sale Id 1350767',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 08:56:01','',''),(2302993,'1','176','920',409,'Retail Sale Id 1350776',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:57:21','',''),(2303055,'1','176','920',409,'Retail Sale Id 1350813',56400.00,0.00,0.00,100.00,600.00,'2021-12-17 09:01:42','',''),(2303261,'1','176','920',409,'Retail Sale Id 1350943',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 09:19:09','',''),(2303283,'1','176','920',409,'Retail Sale Id 1350961',22999.92,0.00,0.00,40.78,244.68,'2021-12-17 09:20:48','',''),(2303297,'1','176','920',409,'Retail Sale Id 1350977',16801.56,0.00,0.00,29.79,178.74,'2021-12-17 09:22:34','',''),(2303328,'1','176','920',409,'Retail Sale Id 1350997',112800.00,0.00,0.00,200.00,1200.00,'2021-12-17 09:24:43','',''),(2303363,'1','176','920',409,'Retail Sale Id 1351014',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 09:26:58','',''),(2303388,'1','176','920',409,'Retail Sale Id 1351045',169200.00,0.00,0.00,300.00,1800.00,'2021-12-17 09:30:37','',''),(2303414,'1','176','920',409,'Retail Sale Id 1351064',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 09:32:32','',''),(2303487,'1','176','920',409,'Retail Sale Id 1351113',56400.00,0.00,0.00,100.00,600.00,'2021-12-17 09:36:30','',''),(2303605,'1','176','920',409,'Retail Sale Id 1351200',8001.84,0.00,0.00,12.99,753.42,'2021-12-17 09:46:54','',''),(2303613,'1','176','920',409,'Retail Sale Id 1351210',997.92,0.00,0.00,1.62,93.96,'2021-12-17 09:48:00','',''),(2303634,'1','176','920',409,'Retail Sale Id 1351224',1848.00,0.00,0.00,3.00,174.00,'2021-12-17 09:49:48','',''),(2303784,'1','176','920',409,'Retail Sale Id 1351383',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 10:05:57','',''),(2303833,'1','176','920',409,'Retail Sale Id 1351429',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 10:09:52','',''),(2303991,'1','176','920',409,'Retail Sale Id 1351581',36660.00,0.00,0.00,65.00,390.00,'2021-12-17 10:28:37','',''),(2304130,'1','176','920',409,'Retail Sale Id 1351645',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 10:44:52','',''),(2304179,'1','176','920',409,'Retail Sale Id 1351766',56400.00,0.00,0.00,100.00,600.00,'2021-12-17 10:50:56','',''),(2304354,'1','176','920',409,'Retail Sale Id 1351926',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 11:10:10','',''),(2304426,'1','176','920',409,'Retail Sale Id 1351996',29999.16,0.00,0.00,53.19,319.14,'2021-12-17 11:16:47','',''),(2304443,'1','176','920',409,'Retail Sale Id 1352008',6160.00,0.00,0.00,10.00,580.00,'2021-12-17 11:18:14','',''),(2304475,'1','176','920',409,'Retail Sale Id 1352025',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 11:19:42','',''),(2304564,'1','176','920',409,'Retail Sale Id 1352109',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 11:27:21','',''),(2304574,'1','176','920',409,'Retail Sale Id 1352117',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 11:28:07','',''),(2304588,'1','176','920',409,'Retail Sale Id 1352130',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 11:29:09','',''),(2304626,'1','176','920',409,'Retail Sale Id 1352169',1503.04,0.00,0.00,2.44,141.52,'2021-12-17 11:33:21','',''),(2304714,'1','176','920',409,'Retail Sale Id 1352254',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 11:44:10','',''),(2304730,'1','176','920',409,'Retail Sale Id 1352267',16920.00,0.00,0.00,30.00,180.00,'2021-12-17 11:45:45','',''),(2304832,'1','176','920',409,'Retail Sale Id 1352363',13536.00,0.00,0.00,24.00,144.00,'2021-12-17 11:58:21','',''),(2304845,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,697500.00,1250.00,0.00,0.00,'2021-12-17 12:00:06','',''),(2304864,'1','176',NULL,409,'Reception corrector for bridging 127727',0.00,0.00,0.00,1250.00,0.00,'2021-12-17 12:01:20','',''),(2304865,'1','176','920',409,'Received from bridging 127727',0.00,0.00,1250.00,0.00,0.00,'2021-12-17 12:01:20','',''),(2304926,'1','176','920',409,'Retail Sale Id 1352442',56400.00,0.00,0.00,100.00,600.00,'2021-12-17 12:09:21','',''),(2304934,'1','176','920',409,'Retail Sale Id 1352450',30174.00,0.00,0.00,53.50,321.00,'2021-12-17 12:10:51','',''),(2304941,'1','176','920',409,'Retail Sale Id 1352456',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 12:12:10','',''),(2304960,'1','176','920',409,'Retail Sale Id 1352476',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 12:14:22','',''),(2305105,'1','176','920',409,'Retail Sale Id 1352611',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 12:36:38','',''),(2305143,'1','176','920',409,'Retail Sale Id 1352648',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 12:42:15','',''),(2305383,'1','176','920',409,'Retail Sale Id 1352888',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 13:19:30','',''),(2305415,'1','176','920',409,'Retail Sale Id 1352935',13970.28,0.00,0.00,24.77,148.62,'2021-12-17 13:25:20','',''),(2305492,'1','176','920',409,'Retail Sale Id 1353006',4312.00,0.00,0.00,7.00,406.00,'2021-12-17 13:34:01','',''),(2305625,'1','176','920',409,'Retail Sale Id 1353096',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 13:46:00','',''),(2305657,'1','176','920',409,'Retail Sale Id 1353122',17484.00,0.00,0.00,31.00,186.00,'2021-12-17 13:51:37','',''),(2305828,'1','176','920',409,'Retail Sale Id 1353240',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 14:05:49','',''),(2305899,'1','176','920',409,'Retail Sale Id 1353301',3498.88,0.00,0.00,5.68,329.44,'2021-12-17 14:12:55','',''),(2305952,'1','176','920',409,'Retail Sale Id 1353347',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 14:21:22','',''),(2305966,'1','176','920',409,'Retail Sale Id 1353363',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 14:22:48','',''),(2305975,'1','176','920',409,'Retail Sale Id 1353372',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 14:24:24','',''),(2306065,'1','176','920',409,'Retail Sale Id 1353450',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 14:33:55','',''),(2306238,'1','176','920',409,'Retail Sale Id 1353562',11550.00,0.00,0.00,18.75,1087.50,'2021-12-17 14:45:26','',''),(2306264,'1','176','920',409,'Retail Sale Id 1353596',56400.00,0.00,0.00,100.00,600.00,'2021-12-17 14:47:34','',''),(2306276,'1','176','920',409,'Retail Sale Id 1353606',997.92,0.00,0.00,1.62,93.96,'2021-12-17 14:48:41','',''),(2306516,'1','176','920',409,'Retail Sale Id 1353789',46812.00,0.00,0.00,83.00,498.00,'2021-12-17 15:10:00','',''),(2306700,'1','176','920',409,'Retail Sale Id 1353936',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 15:25:19','',''),(2306723,'1','176','920',409,'Retail Sale Id 1353954',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 15:26:40','',''),(2306983,'1','176','920',409,'Retail Sale Id 1354132',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 15:43:26','',''),(2306992,'1','176','920',409,'Retail Sale Id 1354142',1503.04,0.00,0.00,2.44,141.52,'2021-12-17 15:44:28','',''),(2307006,'1','176','920',409,'Retail Sale Id 1354156',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 15:45:23','',''),(2307138,'1','176','920',409,'Retail Sale Id 1354289',84600.00,0.00,0.00,150.00,900.00,'2021-12-17 15:56:11','',''),(2307161,'1','176','920',409,'Retail Sale Id 1354317',26998.68,0.00,0.00,47.87,287.22,'2021-12-17 15:57:42','',''),(2307185,'1','176','920',409,'Retail Sale Id 1354340',55836.00,0.00,0.00,99.00,594.00,'2021-12-17 16:00:07','',''),(2307283,'1','176','920',409,'Retail Sale Id 1354438',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 16:09:36','',''),(2307301,'1','176','920',409,'Retail Sale Id 1354462',22560.00,0.00,0.00,40.00,240.00,'2021-12-17 16:11:28','',''),(2307318,'1','176','920',409,'Retail Sale Id 1354478',27072.00,0.00,0.00,48.00,288.00,'2021-12-17 16:12:40','',''),(2307331,'1','176','920',409,'Retail Sale Id 1354493',27072.00,0.00,0.00,48.00,288.00,'2021-12-17 16:14:05','',''),(2307361,'1','176','920',409,'Retail Sale Id 1354521',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 16:16:34','',''),(2307478,'1','176','920',409,'Retail Sale Id 1354647',28200.00,0.00,0.00,50.00,300.00,'2021-12-17 16:26:51','',''),(2307540,'1','176','920',409,'Retail Sale Id 1354706',997.92,0.00,0.00,1.62,93.96,'2021-12-17 16:32:22','',''),(2307745,'1','176','920',409,'Retail Sale Id 1354885',14100.00,0.00,0.00,25.00,150.00,'2021-12-17 16:52:21','',''),(2307852,'1','176','920',409,'Retail Sale Id 1354981',45193.32,0.00,0.00,80.13,480.78,'2021-12-17 17:07:25','',''),(2307877,'1','176','920',409,'Retail Sale Id 1355010',27072.00,0.00,0.00,48.00,288.00,'2021-12-17 17:10:41','',''),(2309037,'1','176','920',409,'Retail Sale Id 1355437',69090.00,0.00,0.00,122.50,735.00,'2021-12-18 05:39:37','',''),(2309101,'1','176','920',409,'Retail Sale Id 1355507',69372.00,0.00,0.00,123.00,738.00,'2021-12-18 06:18:07','',''),(2309610,'1','176','920',409,'Retail Sale Id 1355937',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 07:11:01','',''),(2309946,'1','176','920',409,'Retail Sale Id 1356189',16502.64,0.00,0.00,29.26,175.56,'2021-12-18 07:40:29','',''),(2310145,'1','176','920',409,'Retail Sale Id 1356352',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 07:54:39','',''),(2310586,'1','176','920',409,'Retail Sale Id 1356693',7050.00,0.00,0.00,12.50,75.00,'2021-12-18 08:29:27','',''),(2310989,'1','176','920',409,'Retail Sale Id 1357060',105637.20,0.00,0.00,187.30,1123.80,'2021-12-18 09:02:49','',''),(2311104,'1','176','920',409,'Distributed to operational loss for sales id:340590',24384.60,0.00,0.00,43.70,0.00,'2021-12-18 09:11:42','',''),(2311289,'1','176','920',409,'Retail Sale Id 1357303',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 09:28:22','',''),(2311304,'1','176','920',409,'Retail Sale Id 1357318',14100.00,0.00,0.00,25.00,150.00,'2021-12-18 09:29:42','',''),(2311842,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2232000.00,4000.00,0.00,0.00,'2021-12-18 10:18:28','',''),(2311876,'1','176',NULL,409,'Reception corrector for bridging 127847',0.00,0.00,0.00,4000.00,0.00,'2021-12-18 10:20:10','',''),(2311877,'1','176','920',409,'Received from bridging 127847',0.00,0.00,4000.00,0.00,0.00,'2021-12-18 10:20:10','',''),(2311907,'1','176','920',409,'Retail Sale Id 1357815',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 10:22:13','',''),(2311943,'1','176','920',409,'Retail Sale Id 1357850',63450.00,0.00,0.00,112.50,675.00,'2021-12-18 10:24:39','',''),(2311960,'1','176','920',409,'Retail Sale Id 1357866',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 10:25:58','',''),(2311978,'1','176','920',409,'Retail Sale Id 1357884',36660.00,0.00,0.00,65.00,390.00,'2021-12-18 10:27:52','',''),(2312007,'1','176','920',409,'Retail Sale Id 1357915',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 10:30:35','',''),(2312069,'1','176','920',409,'Retail Sale Id 1357961',15400.00,0.00,0.00,25.00,1450.00,'2021-12-18 10:35:04','',''),(2312132,'1','176','920',409,'Retail Sale Id 1358026',3098.48,0.00,0.00,5.03,291.74,'2021-12-18 10:39:43','',''),(2312179,'1','176','920',409,'Retail Sale Id 1358080',27636.00,0.00,0.00,49.00,294.00,'2021-12-18 10:43:47','',''),(2312208,'1','176','920',409,'Retail Sale Id 1358105',84600.00,0.00,0.00,150.00,900.00,'2021-12-18 10:46:38','',''),(2312333,'1','176','920',409,'Retail Sale Id 1358220',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 10:56:41','',''),(2312361,'1','176','920',409,'Retail Sale Id 1358241',112800.00,0.00,0.00,200.00,1200.00,'2021-12-18 10:58:27','',''),(2312534,'1','176','920',409,'Retail Sale Id 1358388',33840.00,0.00,0.00,60.00,360.00,'2021-12-18 11:11:54','',''),(2312739,'1','176','920',409,'Retail Sale Id 1358545',10798.48,0.00,0.00,17.53,1016.74,'2021-12-18 11:26:47','',''),(2312920,'1','176','920',409,'Retail Sale Id 1358729',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 11:42:04','',''),(2312928,'1','176','920',409,'Retail Sale Id 1358739',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 11:43:17','',''),(2313104,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,680760.00,1220.00,0.00,0.00,'2021-12-18 12:04:42','',''),(2313120,'1','176',NULL,409,'Reception corrector for bridging 127865',0.00,0.00,0.00,1220.00,0.00,'2021-12-18 12:06:16','',''),(2313121,'1','176','920',409,'Received from bridging 127865',0.00,0.00,1220.00,0.00,0.00,'2021-12-18 12:06:16','',''),(2313134,'1','176','920',409,'Retail Sale Id 1358932',27072.00,0.00,0.00,48.00,288.00,'2021-12-18 12:07:58','',''),(2313144,'1','176','920',409,'Retail Sale Id 1358943',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 12:08:59','',''),(2313179,'1','176','920',409,'Retail Sale Id 1358967',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 12:11:33','',''),(2313235,'1','176','920',409,'Retail Sale Id 1359030',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 12:17:28','',''),(2313258,'1','176','920',409,'Retail Sale Id 1359049',6160.00,0.00,0.00,10.00,580.00,'2021-12-18 12:19:33','',''),(2313287,'1','176','920',409,'Retail Sale Id 1359086',19999.44,0.00,0.00,35.46,212.76,'2021-12-18 12:23:22','',''),(2313298,'1','176','920',409,'Retail Sale Id 1359092',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 12:24:31','',''),(2313365,'1','176','920',409,'Retail Sale Id 1359158',40608.00,0.00,0.00,72.00,432.00,'2021-12-18 12:32:20','',''),(2313614,'1','176','920',409,'Retail Sale Id 1359388',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 12:54:29','',''),(2313648,'1','176','920',409,'Retail Sale Id 1359416',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 12:57:23','',''),(2313708,'1','176','920',409,'Retail Sale Id 1359459',27636.00,0.00,0.00,49.00,294.00,'2021-12-18 13:03:04','',''),(2313830,'1','176','920',409,'Retail Sale Id 1359569',2500.96,0.00,0.00,4.06,235.48,'2021-12-18 13:14:02','',''),(2313857,'1','176','920',409,'Retail Sale Id 1359591',56400.00,0.00,0.00,100.00,600.00,'2021-12-18 13:16:32','',''),(2313872,'1','176','920',409,'Retail Sale Id 1359612',3702.16,0.00,0.00,6.01,348.58,'2021-12-18 13:18:08','',''),(2313891,'1','176','920',409,'Retail Sale Id 1359631',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 13:19:56','',''),(2314510,'1','176','920',409,'Retail Sale Id 1360103',73320.00,0.00,0.00,130.00,780.00,'2021-12-18 14:07:22','',''),(2314703,'1','176','920',409,'Retail Sale Id 1360259',997.92,0.00,0.00,1.62,93.96,'2021-12-18 14:23:15','',''),(2314733,'1','176','920',409,'Retail Sale Id 1360286',2500.96,0.00,0.00,4.06,235.48,'2021-12-18 14:25:50','',''),(2314748,'1','176','920',409,'Retail Sale Id 1360303',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 14:27:14','',''),(2314870,'1','176','920',409,'Retail Sale Id 1360402',28002.60,0.00,0.00,49.65,297.90,'2021-12-18 14:35:48','',''),(2314986,'1','176','920',409,'Retail Sale Id 1360483',6997.76,0.00,0.00,11.36,658.88,'2021-12-18 14:45:29','',''),(2315010,'1','176','920',409,'Retail Sale Id 1360508',11499.96,0.00,0.00,20.39,122.34,'2021-12-18 14:47:26','',''),(2315027,'1','176','920',409,'Retail Sale Id 1360523',7501.20,0.00,0.00,13.30,79.80,'2021-12-18 14:48:59','',''),(2315053,'1','176','920',409,'Retail Sale Id 1360544',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 14:51:06','',''),(2315071,'1','176','920',409,'Retail Sale Id 1360558',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 14:52:26','',''),(2315386,'1','176','920',409,'Retail Sale Id 1360830',107442.00,0.00,0.00,190.50,1143.00,'2021-12-18 15:19:39','',''),(2315631,'1','176','920',409,'Retail Sale Id 1361060',65988.00,0.00,0.00,117.00,702.00,'2021-12-18 15:39:01','',''),(2315661,'1','176','920',409,'Retail Sale Id 1361089',1299.76,0.00,0.00,2.11,122.38,'2021-12-18 15:41:04','',''),(2315671,'1','176','920',409,'Retail Sale Id 1361099',1201.20,0.00,0.00,1.95,113.10,'2021-12-18 15:42:01','',''),(2315732,'1','176','920',409,'Retail Sale Id 1361154',112800.00,0.00,0.00,200.00,1200.00,'2021-12-18 15:46:38','',''),(2316085,'1','176','920',409,'Retail Sale Id 1361410',2999.92,0.00,0.00,4.87,282.46,'2021-12-18 16:04:52','',''),(2316279,'1','176','920',409,'Retail Sale Id 1361583',84036.00,0.00,0.00,149.00,894.00,'2021-12-18 16:17:54','',''),(2316335,'1','176','920',409,'Retail Sale Id 1361638',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 16:22:33','',''),(2316373,'1','176','920',409,'Retail Sale Id 1361674',19999.44,0.00,0.00,35.46,212.76,'2021-12-18 16:25:03','',''),(2316402,'1','176','920',409,'Retail Sale Id 1361696',84600.00,0.00,0.00,150.00,900.00,'2021-12-18 16:27:06','',''),(2316431,'1','176','920',409,'Retail Sale Id 1361734',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 16:29:21','',''),(2316508,'1','176','920',409,'Retail Sale Id 1361812',19999.44,0.00,0.00,35.46,212.76,'2021-12-18 16:35:26','',''),(2316661,'1','176','920',409,'Retail Sale Id 1361955',56400.00,0.00,0.00,100.00,600.00,'2021-12-18 16:47:01','',''),(2316808,'1','176','920',409,'Retail Sale Id 1362070',5640.00,0.00,0.00,10.00,60.00,'2021-12-18 16:58:14','',''),(2316959,'1','176','920',409,'Retail Sale Id 1362252',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 17:15:21','',''),(2316986,'1','176','920',409,'Retail Sale Id 1362276',91305.96,0.00,0.00,161.89,971.34,'2021-12-18 17:18:57','',''),(2317011,'1','176','920',409,'Retail Sale Id 1362297',155100.00,0.00,0.00,275.00,1650.00,'2021-12-18 17:21:39','',''),(2317083,'1','176','920',409,'Retail Sale Id 1362369',28200.00,0.00,0.00,50.00,300.00,'2021-12-18 17:32:54','',''),(2317105,'1','176','920',409,'Retail Sale Id 1362377',84600.00,0.00,0.00,150.00,900.00,'2021-12-18 17:36:11','',''),(2317195,'1','176','920',409,'Retail Sale Id 1362457',1700.16,0.00,0.00,2.76,160.08,'2021-12-18 17:49:00','',''),(2317844,'1','176','920',409,'Retail Sale Id 1362750',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 05:46:06','',''),(2317848,'1','176','920',409,'Retail Sale Id 1362756',28002.60,0.00,0.00,49.65,297.90,'2021-12-19 05:52:07','',''),(2317859,'1','176','920',409,'Retail Sale Id 1362764',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 05:59:49','',''),(2318096,'1','176','920',409,'Retail Sale Id 1362900',21996.00,0.00,0.00,39.00,234.00,'2021-12-19 06:40:26','',''),(2318154,'1','176','920',409,'Retail Sale Id 1362954',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 06:47:14','',''),(2318175,'1','176','920',409,'Retail Sale Id 1362975',997.92,0.00,0.00,1.62,93.96,'2021-12-19 06:49:38','',''),(2318182,'1','176','920',409,'Retail Sale Id 1362982',1848.00,0.00,0.00,3.00,174.00,'2021-12-19 06:50:47','',''),(2318199,'1','176','920',409,'Retail Sale Id 1362991',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 06:51:53','',''),(2318211,'1','176','920',409,'Retail Sale Id 1363002',84600.00,0.00,0.00,150.00,900.00,'2021-12-19 06:53:06','',''),(2318246,'1','176','920',409,'Retail Sale Id 1363035',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 06:56:28','',''),(2318265,'1','176','920',409,'Retail Sale Id 1363053',15397.20,0.00,0.00,27.30,163.80,'2021-12-19 06:58:41','',''),(2318303,'1','176','920',409,'Retail Sale Id 1363094',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 07:03:17','',''),(2318341,'1','176','920',409,'Retail Sale Id 1363136',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 07:07:35','',''),(2318351,'1','176','920',409,'Retail Sale Id 1363144',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 07:08:43','',''),(2318449,'1','176','920',409,'Retail Sale Id 1363213',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 07:16:02','',''),(2318522,'1','176','920',409,'Retail Sale Id 1363291',19999.44,0.00,0.00,35.46,212.76,'2021-12-19 07:23:14','',''),(2318684,'1','176','920',409,'Retail Sale Id 1363456',112800.00,0.00,0.00,200.00,1200.00,'2021-12-19 07:37:33','',''),(2318777,'1','176','920',409,'Retail Sale Id 1363532',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 07:45:06','',''),(2318792,'1','176','920',409,'Retail Sale Id 1363547',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 07:47:02','',''),(2318804,'1','176','920',409,'Retail Sale Id 1363561',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 07:48:20','',''),(2318814,'1','176','920',409,'Retail Sale Id 1363568',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 07:49:14','',''),(2318915,'1','176','920',409,'Retail Sale Id 1363616',17252.76,0.00,0.00,30.59,183.54,'2021-12-19 07:54:25','',''),(2318950,'1','176','920',409,'Retail Sale Id 1363645',5001.92,0.00,0.00,8.12,470.96,'2021-12-19 07:58:33','',''),(2318998,'1','176','920',409,'Retail Sale Id 1363684',5550.16,0.00,0.00,9.01,522.58,'2021-12-19 08:02:12','',''),(2319007,'1','176','920',409,'Retail Sale Id 1363694',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 08:03:12','',''),(2319123,'1','176','920',409,'Retail Sale Id 1363794',9252.32,0.00,0.00,15.02,871.16,'2021-12-19 08:15:01','',''),(2319133,'1','176','920',409,'Retail Sale Id 1363807',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 08:16:42','',''),(2319268,'1','176','920',409,'Retail Sale Id 1363898',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 08:26:04','',''),(2319347,'1','176','920',409,'Retail Sale Id 1363984',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 08:32:38','',''),(2319436,'1','176','920',409,'Retail Sale Id 1364015',112800.00,0.00,0.00,200.00,1200.00,'2021-12-19 08:35:47','',''),(2319563,'1','176','920',409,'Retail Sale Id 1364104',14100.00,0.00,0.00,25.00,150.00,'2021-12-19 08:46:12','',''),(2319634,'1','176','920',409,'Retail Sale Id 1364162',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 08:54:07','',''),(2319653,'1','176','920',409,'Retail Sale Id 1364176',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 08:55:58','',''),(2319691,'1','176','920',409,'Retail Sale Id 1364220',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 09:02:19','',''),(2319756,'1','176','920',409,'Retail Sale Id 1364274',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 09:09:53','',''),(2319882,'1','176','920',409,'Retail Sale Id 1364344',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 09:17:46','',''),(2319987,'1','176','920',409,'Retail Sale Id 1364381',59220.00,0.00,0.00,105.00,630.00,'2021-12-19 09:21:42','',''),(2320157,'1','176','920',409,'Retail Sale Id 1364492',1848.00,0.00,0.00,3.00,174.00,'2021-12-19 09:29:40','',''),(2320272,'1','176','920',409,'Retail Sale Id 1364594',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 09:37:32','',''),(2320285,'1','176','920',409,'Retail Sale Id 1364609',16920.00,0.00,0.00,30.00,180.00,'2021-12-19 09:38:44','',''),(2320311,'1','176','920',409,'Retail Sale Id 1364635',1848.00,0.00,0.00,3.00,174.00,'2021-12-19 09:40:24','',''),(2321708,'1','176','920',409,'Retail Sale Id 1365992',70359.00,0.00,0.00,124.75,748.50,'2021-12-19 11:36:31','',''),(2321759,'1','176','920',409,'Distributed to operational loss for sales id:340806',26237.16,0.00,0.00,47.02,0.00,'2021-12-19 11:39:52','',''),(2321779,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2232000.00,4000.00,0.00,0.00,'2021-12-19 11:42:01','',''),(2321794,'1','176',NULL,409,'Reception corrector for bridging 127966',0.00,0.00,0.00,4000.00,0.00,'2021-12-19 11:43:01','',''),(2321795,'1','176','920',409,'Received from bridging 127966',0.00,0.00,4000.00,0.00,0.00,'2021-12-19 11:43:01','',''),(2321825,'1','176','920',409,'Retail Sale Id 1366084',16016.00,0.00,0.00,26.00,1508.00,'2021-12-19 11:45:24','',''),(2322279,'1','176','920',409,'Retail Sale Id 1366536',43428.00,0.00,0.00,77.00,462.00,'2021-12-19 12:25:32','',''),(2322300,'1','176','920',409,'Retail Sale Id 1366558',13536.00,0.00,0.00,24.00,144.00,'2021-12-19 12:28:06','',''),(2322385,'1','176','920',409,'Retail Sale Id 1366641',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 12:37:26','',''),(2322445,'1','176','920',409,'Retail Sale Id 1366689',1848.00,0.00,0.00,3.00,174.00,'2021-12-19 12:43:10','',''),(2322484,'1','176','920',409,'Retail Sale Id 1366721',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 12:46:02','',''),(2322519,'1','176','920',409,'Retail Sale Id 1366745',27072.00,0.00,0.00,48.00,288.00,'2021-12-19 12:47:57','',''),(2322540,'1','176','920',409,'Retail Sale Id 1366763',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 12:49:22','',''),(2322567,'1','176','920',409,'Retail Sale Id 1366785',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 12:51:17','',''),(2322694,'1','176','920',409,'Retail Sale Id 1366913',14500.64,0.00,0.00,23.54,1365.32,'2021-12-19 13:02:43','',''),(2322704,'1','176','920',409,'Retail Sale Id 1366925',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 13:04:09','',''),(2322840,'1','176','920',409,'Retail Sale Id 1367057',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:17:07','',''),(2322931,'1','176','920',409,'Retail Sale Id 1367139',78396.00,0.00,0.00,139.00,834.00,'2021-12-19 13:24:46','',''),(2322954,'1','176','920',409,'Retail Sale Id 1367162',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:26:35','',''),(2323006,'1','176','920',409,'Retail Sale Id 1367179',62040.00,0.00,0.00,110.00,660.00,'2021-12-19 13:30:22','',''),(2323293,'1','176','920',409,'Retail Sale Id 1367396',997.92,0.00,0.00,1.62,93.96,'2021-12-19 13:50:44','',''),(2323486,'1','176','920',409,'Retail Sale Id 1367570',23998.20,0.00,0.00,42.55,255.30,'2021-12-19 14:03:43','',''),(2323505,'1','176','920',409,'Retail Sale Id 1367586',22560.00,0.00,0.00,40.00,240.00,'2021-12-19 14:05:09','',''),(2323626,'1','176','920',409,'Retail Sale Id 1367677',6160.00,0.00,0.00,10.00,580.00,'2021-12-19 14:12:32','',''),(2323652,'1','176','920',409,'Retail Sale Id 1367706',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 14:14:59','',''),(2323698,'1','176','920',409,'Retail Sale Id 1367748',27636.00,0.00,0.00,49.00,294.00,'2021-12-19 14:19:22','',''),(2323749,'1','176','920',409,'Retail Sale Id 1367785',17997.24,0.00,0.00,31.91,191.46,'2021-12-19 14:23:15','',''),(2323767,'1','176','920',409,'Retail Sale Id 1367805',164124.00,0.00,0.00,291.00,1746.00,'2021-12-19 14:25:35','',''),(2323823,'1','176','920',409,'Retail Sale Id 1367843',24816.00,0.00,0.00,44.00,264.00,'2021-12-19 14:30:19','',''),(2323843,'1','176','920',409,'Retail Sale Id 1367867',13000.20,0.00,0.00,23.05,138.30,'2021-12-19 14:32:14','',''),(2323921,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,669600.00,1200.00,0.00,0.00,'2021-12-19 14:38:53','',''),(2323932,'1','176',NULL,409,'Reception corrector for bridging 127995',0.00,0.00,0.00,1200.00,0.00,'2021-12-19 14:39:54','',''),(2323933,'1','176','920',409,'Received from bridging 127995',0.00,0.00,1200.00,0.00,0.00,'2021-12-19 14:39:54','',''),(2323942,'1','176','920',409,'Retail Sale Id 1367951',3850.00,0.00,0.00,6.25,362.50,'2021-12-19 14:40:58','',''),(2324087,'1','176','920',409,'Retail Sale Id 1368098',135360.00,0.00,0.00,240.00,1440.00,'2021-12-19 14:55:18','',''),(2324103,'1','176','920',409,'Retail Sale Id 1368114',20020.00,0.00,0.00,32.50,1885.00,'2021-12-19 14:58:07','',''),(2324114,'1','176','920',409,'Retail Sale Id 1368124',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 14:59:19','',''),(2324366,'1','176','920',409,'Retail Sale Id 1368347',3498.88,0.00,0.00,5.68,329.44,'2021-12-19 15:25:30','',''),(2324549,'1','176','920',409,'Retail Sale Id 1368512',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 15:43:36','',''),(2324639,'1','176','920',409,'Retail Sale Id 1368609',28200.00,0.00,0.00,50.00,300.00,'2021-12-19 15:51:50','',''),(2324655,'1','176','920',409,'Retail Sale Id 1368625',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 15:53:41','',''),(2324721,'1','176','920',409,'Retail Sale Id 1368667',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 15:57:52','',''),(2325227,'1','176','920',409,'Retail Sale Id 1369053',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 16:42:25','',''),(2325395,'1','176','920',409,'Retail Sale Id 1369188',56400.00,0.00,0.00,100.00,600.00,'2021-12-19 17:01:30','',''),(2325489,'1','176','920',409,'Retail Sale Id 1369285',1299.76,0.00,0.00,2.11,122.38,'2021-12-19 17:14:34','',''),(2325657,'1','176','920',409,'Retail Sale Id 1369408',61594.44,0.00,0.00,109.21,655.26,'2021-12-19 17:44:57','',''),(2326324,'1','176','920',409,'Retail Sale Id 1369690',28200.00,0.00,0.00,50.00,300.00,'2021-12-20 06:40:26','',''),(2326350,'1','176','920',409,'Retail Sale Id 1369714',11402.16,0.00,0.00,18.51,1073.58,'2021-12-20 06:45:05','',''),(2326425,'1','176','920',409,'Retail Sale Id 1369770',84600.00,0.00,0.00,150.00,900.00,'2021-12-20 06:54:16','',''),(2326794,'1','176','920',409,'Retail Sale Id 1370044',15400.00,0.00,0.00,25.00,1450.00,'2021-12-20 07:34:29','',''),(2326804,'1','176','920',409,'Retail Sale Id 1370054',84600.00,0.00,0.00,150.00,900.00,'2021-12-20 07:35:25','',''),(2326829,'1','176','920',409,'Retail Sale Id 1370077',3098.48,0.00,0.00,5.03,291.74,'2021-12-20 07:39:04','',''),(2326874,'1','176','920',409,'Retail Sale Id 1370105',100392.00,0.00,0.00,178.00,1068.00,'2021-12-20 07:42:34','',''),(2326927,'1','176','920',409,'Retail Sale Id 1370122',67680.00,0.00,0.00,120.00,720.00,'2021-12-20 07:45:48','',''),(2327080,'1','176','920',409,'Retail Sale Id 1370216',84600.00,0.00,0.00,150.00,900.00,'2021-12-20 07:58:22','',''),(2327096,'1','176','920',409,'Retail Sale Id 1370233',2500.96,0.00,0.00,4.06,235.48,'2021-12-20 08:00:49','',''),(2327132,'1','176','920',409,'Retail Sale Id 1370275',25278.48,0.00,0.00,44.82,268.92,'2021-12-20 08:06:27','',''),(2327154,'1','176','920',409,'Retail Sale Id 1370294',1503.04,0.00,0.00,2.44,141.52,'2021-12-20 08:09:00','',''),(2327239,'1','176','920',409,'Retail Sale Id 1370385',141000.00,0.00,0.00,250.00,1500.00,'2021-12-20 08:22:11','',''),(2327364,'1','176','920',409,'Retail Sale Id 1370509',26998.68,0.00,0.00,47.87,287.22,'2021-12-20 08:37:14','',''),(2327380,'1','176','920',409,'Retail Sale Id 1370523',28200.00,0.00,0.00,50.00,300.00,'2021-12-20 08:39:30','',''),(2327410,'1','176','920',409,'Retail Sale Id 1370553',141000.00,0.00,0.00,250.00,1500.00,'2021-12-20 08:43:19','',''),(2327804,'1','176','920',409,'Retail Sale Id 1370860',32148.00,0.00,0.00,57.00,342.00,'2021-12-20 09:31:21','',''),(2328032,'1','176','920',409,'Retail Sale Id 1371033',28200.00,0.00,0.00,50.00,300.00,'2021-12-20 09:58:53','',''),(2328056,'1','176','920',409,'Retail Sale Id 1371049',9548.00,0.00,0.00,15.50,899.00,'2021-12-20 10:00:49','',''),(2328530,'1','176','920',409,'Retail Sale Id 1371477',28200.00,0.00,0.00,50.00,300.00,'2021-12-20 10:55:49','',''),(2329347,'1','176','920',409,'Retail Sale Id 1372244',310200.00,0.00,0.00,550.00,3300.00,'2021-12-20 12:22:40','',''),(2329453,'1','176','920',409,'Retail Sale Id 1372348',160458.00,0.00,0.00,284.50,1707.00,'2021-12-20 12:35:13','',''),(2331827,'1','176','920',409,'Retail Sale Id 1374073',323386.32,0.00,0.00,573.38,3440.28,'2021-12-20 16:05:46','',''),(2331884,'1','176','920',409,'Distributed to operational loss for sales id:341094',43200.36,0.00,0.00,77.42,0.00,'2021-12-20 16:11:36','',''),(2331897,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2974140.00,5330.00,0.00,0.00,'2021-12-20 16:12:48','',''),(2331909,'1','176',NULL,409,'Reception corrector for bridging 128095',0.00,0.00,0.00,5330.00,0.00,'2021-12-20 16:14:01','',''),(2331910,'1','176','920',409,'Received from bridging 128095',0.00,0.00,5330.00,0.00,0.00,'2021-12-20 16:14:01','',''),(2331926,'1','176','920',409,'Retail Sale Id 1374169',118440.00,0.00,0.00,210.00,1260.00,'2021-12-20 16:16:18','',''),(2332791,'1','176','920',409,'Retail Sale Id 1374843',510651.24,0.00,0.00,905.41,5432.46,'2021-12-20 17:59:40','',''),(2332833,'1','176','920',409,'Retail Sale Id 1374861',144699.84,0.00,0.00,256.56,1539.36,'2021-12-20 18:03:55','',''),(2333328,'1','176','920',409,'Retail Sale Id 1374952',28200.00,0.00,0.00,50.00,300.00,'2021-12-21 05:59:03','',''),(2333376,'1','176','920',409,'Retail Sale Id 1374998',84600.00,0.00,0.00,150.00,900.00,'2021-12-21 06:17:51','',''),(2333557,'1','176','920',409,'Retail Sale Id 1375121',7700.00,0.00,0.00,12.50,725.00,'2021-12-21 06:47:27','',''),(2333652,'1','176','920',409,'Retail Sale Id 1375266',7700.00,0.00,0.00,12.50,725.00,'2021-12-21 07:00:38','',''),(2333801,'1','176','920',409,'Retail Sale Id 1375338',7700.00,0.00,0.00,12.50,725.00,'2021-12-21 07:12:12','',''),(2333867,'1','176','920',409,'Retail Sale Id 1375395',2002.00,0.00,0.00,3.25,188.50,'2021-12-21 07:19:23','',''),(2334057,'1','176','920',409,'Retail Sale Id 1375561',11396.00,0.00,0.00,18.50,1073.00,'2021-12-21 07:39:02','',''),(2334437,'1','176','920',409,'Retail Sale Id 1375867',7700.00,0.00,0.00,12.50,725.00,'2021-12-21 08:09:10','',''),(2334509,'1','176','920',409,'Retail Sale Id 1375937',2999.92,0.00,0.00,4.87,282.46,'2021-12-21 08:19:51','',''),(2335842,'1','176','920',409,'Retail Sale Id 1377026',84600.00,0.00,0.00,150.00,900.00,'2021-12-21 10:51:37','',''),(2335851,'1','176','920',409,'Retail Sale Id 1377035',62604.00,0.00,0.00,111.00,666.00,'2021-12-21 10:52:55','',''),(2335944,'1','176','920',409,'Retail Sale Id 1377103',17236.00,0.00,0.00,31.00,248.00,'2021-12-21 11:00:46','',''),(2335988,'1','176','920',409,'Retail Sale Id 1377138',7104.00,0.00,0.00,12.00,528.00,'2021-12-21 11:05:01','',''),(2336011,'1','176','920',409,'Retail Sale Id 1377162',111200.00,0.00,0.00,200.00,1600.00,'2021-12-21 11:08:06','',''),(2336240,'1','176','920',409,'Retail Sale Id 1377359',4001.92,0.00,0.00,6.76,297.44,'2021-12-21 11:32:09','',''),(2336258,'1','176','920',409,'Retail Sale Id 1377375',17.76,0.00,0.00,0.03,1.32,'2021-12-21 11:35:20','',''),(2336283,'1','176','920',409,'Retail Sale Id 1377398',10952.00,0.00,0.00,18.50,814.00,'2021-12-21 11:38:17','',''),(2336337,'1','176','920',409,'Retail Sale Id 1377449',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 11:45:45','',''),(2336344,'1','176','920',409,'Retail Sale Id 1377458',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 11:47:19','',''),(2336375,'1','176','920',409,'Retail Sale Id 1377482',2486.40,0.00,0.00,4.20,184.80,'2021-12-21 11:51:05','',''),(2336705,'1','176','920',409,'Retail Sale Id 1377772',9400.96,0.00,0.00,15.88,698.72,'2021-12-21 12:31:01','',''),(2336729,'1','176','920',409,'Retail Sale Id 1377784',20720.00,0.00,0.00,35.00,1540.00,'2021-12-21 12:33:21','',''),(2336741,'1','176','920',409,'Retail Sale Id 1377794',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 12:34:27','',''),(2336760,'1','176','920',409,'Retail Sale Id 1377820',33916.00,0.00,0.00,61.00,488.00,'2021-12-21 12:35:55','',''),(2336857,'1','176','920',409,'Retail Sale Id 1377908',26688.00,0.00,0.00,48.00,384.00,'2021-12-21 12:46:56','',''),(2336963,'1','176','920',409,'Retail Sale Id 1378011',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 12:59:18','',''),(2336975,'1','176','920',409,'Retail Sale Id 1378023',278000.00,0.00,0.00,500.00,4000.00,'2021-12-21 13:00:33','',''),(2336988,'1','176','920',409,'Retail Sale Id 1378029',375856.00,0.00,0.00,676.00,5408.00,'2021-12-21 13:01:42','',''),(2337006,'1','176','920',409,'Retail Sale Id 1378043',556000.00,0.00,0.00,1000.00,8000.00,'2021-12-21 13:03:00','',''),(2337021,'1','176','920',409,'Retail Sale Id 1378056',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:04:57','',''),(2337196,'1','176','920',409,'Retail Sale Id 1378205',55600.00,0.00,0.00,100.00,800.00,'2021-12-21 13:19:57','',''),(2337203,'1','176','920',409,'Retail Sale Id 1378212',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:21:10','',''),(2337216,'1','176','920',409,'Retail Sale Id 1378225',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 13:22:18','',''),(2337254,'1','176','920',409,'Retail Sale Id 1378262',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 13:26:56','',''),(2337336,'1','176','920',409,'Retail Sale Id 1378342',2498.24,0.00,0.00,4.22,185.68,'2021-12-21 13:35:52','',''),(2337344,'1','176','920',409,'Retail Sale Id 1378350',20016.00,0.00,0.00,36.00,288.00,'2021-12-21 13:37:25','',''),(2337531,'1','176','920',409,'Retail Sale Id 1378427',3001.44,0.00,0.00,5.07,223.08,'2021-12-21 13:47:25','',''),(2337640,'1','176','920',409,'Retail Sale Id 1378531',61160.00,0.00,0.00,110.00,880.00,'2021-12-21 13:56:53','',''),(2337730,'1','176','920',409,'Retail Sale Id 1378617',83400.00,0.00,0.00,150.00,1200.00,'2021-12-21 14:06:59','',''),(2337894,'1','176','920',409,'Retail Sale Id 1378728',3001.44,0.00,0.00,5.07,223.08,'2021-12-21 14:19:20','',''),(2338015,'1','176','920',409,'Retail Sale Id 1378833',1184.00,0.00,0.00,2.00,88.00,'2021-12-21 14:28:55','',''),(2338683,'1','176','920',409,'Retail Sale Id 1379431',100825.04,0.00,0.00,181.34,1450.72,'2021-12-21 15:26:59','',''),(2338735,'1','176','920',409,'Distributed to operational loss for sales id:341326',27268.48,0.00,0.00,49.76,0.00,'2021-12-21 15:30:56','',''),(2339194,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2192000.00,4000.00,0.00,0.00,'2021-12-21 15:58:55','',''),(2339213,'1','176',NULL,409,'Reception corrector for bridging 128236',0.00,0.00,0.00,4000.00,0.00,'2021-12-21 15:59:43','',''),(2339214,'1','176','920',409,'Received from bridging 128236',0.00,0.00,4000.00,0.00,0.00,'2021-12-21 15:59:43','',''),(2339237,'1','176','920',409,'Retail Sale Id 1379876',6002.88,0.00,0.00,10.14,446.16,'2021-12-21 16:01:22','',''),(2339304,'1','176','920',409,'Retail Sale Id 1379938',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:06:04','',''),(2339400,'1','176','920',409,'Retail Sale Id 1380011',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 16:11:44','',''),(2339421,'1','176','920',409,'Retail Sale Id 1380039',40588.00,0.00,0.00,73.00,584.00,'2021-12-21 16:13:51','',''),(2339441,'1','176','920',409,'Retail Sale Id 1380056',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 16:15:27','',''),(2339466,'1','176','920',409,'Retail Sale Id 1380083',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 16:17:23','',''),(2339490,'1','176','920',409,'Retail Sale Id 1380107',15000.88,0.00,0.00,26.98,215.84,'2021-12-21 16:19:15','',''),(2339514,'1','176','920',409,'Retail Sale Id 1380128',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 16:21:06','',''),(2339528,'1','176','920',409,'Retail Sale Id 1380144',2000.96,0.00,0.00,3.38,148.72,'2021-12-21 16:21:59','',''),(2339616,'1','176','920',409,'Retail Sale Id 1380222',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:29:57','',''),(2339705,'1','176','920',409,'Retail Sale Id 1380304',25020.00,0.00,0.00,45.00,360.00,'2021-12-21 16:36:23','',''),(2339819,'1','176','920',409,'Retail Sale Id 1380417',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:46:14','',''),(2339832,'1','176','920',409,'Retail Sale Id 1380432',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:47:33','',''),(2339900,'1','176','920',409,'Retail Sale Id 1380492',83400.00,0.00,0.00,150.00,1200.00,'2021-12-21 16:53:53','',''),(2339917,'1','176','920',409,'Retail Sale Id 1380513',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 16:55:07','',''),(2340081,'1','176','920',409,'Retail Sale Id 1380665',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 17:11:05','',''),(2340156,'1','176','920',409,'Retail Sale Id 1380732',16001.68,0.00,0.00,28.78,230.24,'2021-12-21 17:19:34','',''),(2340168,'1','176','920',409,'Retail Sale Id 1380746',27800.00,0.00,0.00,50.00,400.00,'2021-12-21 17:20:48','',''),(2340339,'1','176','920',409,'Retail Sale Id 1380895',105134.04,0.00,0.00,189.09,1512.72,'2021-12-21 17:47:57','',''),(2341136,'1','176','920',409,'Retail Sale Id 1381159',83400.00,0.00,0.00,150.00,1200.00,'2021-12-22 06:02:52','',''),(2341153,'1','176','920',409,'Retail Sale Id 1381172',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 06:07:35','',''),(2341172,'1','176','920',409,'Retail Sale Id 1381192',45997.88,0.00,0.00,82.73,661.84,'2021-12-22 06:10:39','',''),(2341247,'1','176','920',409,'Retail Sale Id 1381253',12136.00,0.00,0.00,20.50,902.00,'2021-12-22 06:24:42','',''),(2341267,'1','176','920',409,'Retail Sale Id 1381269',3498.72,0.00,0.00,5.91,260.04,'2021-12-22 06:28:14','',''),(2341311,'1','176','920',409,'Retail Sale Id 1381282',1776.00,0.00,0.00,3.00,132.00,'2021-12-22 06:30:32','',''),(2341342,'1','176','920',409,'Retail Sale Id 1381303',133440.00,0.00,0.00,240.00,1920.00,'2021-12-22 06:34:18','',''),(2341577,'1','176','920',409,'Retail Sale Id 1381475',6002.88,0.00,0.00,10.14,446.16,'2021-12-22 06:54:41','',''),(2341614,'1','176','920',409,'Retail Sale Id 1381509',111200.00,0.00,0.00,200.00,1600.00,'2021-12-22 06:57:58','',''),(2341637,'1','176','920',409,'Retail Sale Id 1381537',24997.76,0.00,0.00,44.96,359.68,'2021-12-22 07:00:16','',''),(2341651,'1','176','920',409,'Retail Sale Id 1381549',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 07:01:34','',''),(2341754,'1','176','920',409,'Retail Sale Id 1381649',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 07:11:19','',''),(2341770,'1','176','920',409,'Retail Sale Id 1381667',31136.00,0.00,0.00,56.00,448.00,'2021-12-22 07:12:37','',''),(2341834,'1','176','920',409,'Retail Sale Id 1381711',83400.00,0.00,0.00,150.00,1200.00,'2021-12-22 07:16:44','',''),(2341860,'1','176','920',409,'Retail Sale Id 1381740',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 07:19:12','',''),(2341867,'1','176','920',409,'Retail Sale Id 1381747',16297.76,0.00,0.00,27.53,1211.32,'2021-12-22 07:20:09','',''),(2342386,'1','176','920',409,'Retail Sale Id 1382141',4001.92,0.00,0.00,6.76,297.44,'2021-12-22 07:56:42','',''),(2342501,'1','176','920',409,'Retail Sale Id 1382237',42800.88,0.00,0.00,76.98,615.84,'2021-12-22 08:03:38','',''),(2342520,'1','176','920',409,'Retail Sale Id 1382256',1799.68,0.00,0.00,3.04,133.76,'2021-12-22 08:05:29','',''),(2342590,'1','176','920',409,'Retail Sale Id 1382303',25020.00,0.00,0.00,45.00,360.00,'2021-12-22 08:08:56','',''),(2343112,'1','176','920',409,'Retail Sale Id 1382719',1497.76,0.00,0.00,2.53,111.32,'2021-12-22 08:45:22','',''),(2343186,'1','176','920',409,'Retail Sale Id 1382795',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 08:53:21','',''),(2343222,'1','176','920',409,'Retail Sale Id 1382830',147062.00,0.00,0.00,264.50,2116.00,'2021-12-22 08:56:55','',''),(2343273,'1','176','920',409,'Retail Sale Id 1382877',13900.00,0.00,0.00,25.00,200.00,'2021-12-22 09:01:52','',''),(2343295,'1','176','920',409,'Retail Sale Id 1382894',19999.32,0.00,0.00,35.97,287.76,'2021-12-22 09:03:32','',''),(2343391,'1','176','920',409,'Retail Sale Id 1383033',5002.40,0.00,0.00,8.45,371.80,'2021-12-22 09:12:04','',''),(2343452,'1','176','920',409,'Retail Sale Id 1383092',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 09:17:57','',''),(2343512,'1','176','920',409,'Retail Sale Id 1383145',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 09:24:25','',''),(2343532,'1','176','920',409,'Retail Sale Id 1383165',68944.00,0.00,0.00,124.00,992.00,'2021-12-22 09:26:59','',''),(2343549,'1','176','920',409,'Retail Sale Id 1383179',6002.88,0.00,0.00,10.14,446.16,'2021-12-22 09:28:13','',''),(2343603,'1','176','920',409,'Retail Sale Id 1383219',33999.40,0.00,0.00,61.15,489.20,'2021-12-22 09:31:36','',''),(2343620,'1','176','920',409,'Retail Sale Id 1383234',8000.84,0.00,0.00,14.39,115.12,'2021-12-22 09:32:47','',''),(2343700,'1','176','920',409,'Retail Sale Id 1383260',139000.00,0.00,0.00,250.00,2000.00,'2021-12-22 09:37:59','',''),(2343825,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,432920.00,790.00,0.00,0.00,'2021-12-22 09:50:44','',''),(2343839,'1','176',NULL,409,'Reception corrector for bridging 128316',0.00,0.00,0.00,790.00,0.00,'2021-12-22 09:51:41','',''),(2343840,'1','176','920',409,'Received from bridging 128316',0.00,0.00,790.00,0.00,0.00,'2021-12-22 09:51:41','',''),(2343917,'1','176','920',409,'Retail Sale Id 1383417',83400.00,0.00,0.00,150.00,1200.00,'2021-12-22 09:56:40','',''),(2343935,'1','176','920',409,'Retail Sale Id 1383490',6808.00,0.00,0.00,11.50,506.00,'2021-12-22 09:58:12','',''),(2344005,'1','176','920',409,'Retail Sale Id 1383571',6997.44,0.00,0.00,11.82,520.08,'2021-12-22 10:05:23','',''),(2344092,'1','176','920',409,'Retail Sale Id 1383655',2699.52,0.00,0.00,4.56,200.64,'2021-12-22 10:13:25','',''),(2344139,'1','176','920',409,'Retail Sale Id 1383694',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 10:18:22','',''),(2344188,'1','176','920',409,'Retail Sale Id 1383748',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 10:23:52','',''),(2344233,'1','176','920',409,'Retail Sale Id 1383797',1799.68,0.00,0.00,3.04,133.76,'2021-12-22 10:28:37','',''),(2344378,'1','176','920',409,'Retail Sale Id 1383939',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 10:42:54','',''),(2344466,'1','176','920',409,'Retail Sale Id 1384026',10952.00,0.00,0.00,18.50,814.00,'2021-12-22 10:51:42','',''),(2344622,'1','176','920',409,'Retail Sale Id 1384170',2397.60,0.00,0.00,4.05,178.20,'2021-12-22 11:05:54','',''),(2344822,'1','176','920',409,'Retail Sale Id 1384369',16680.00,0.00,0.00,30.00,240.00,'2021-12-22 11:25:05','',''),(2344843,'1','176','920',409,'Retail Sale Id 1384389',31497.40,0.00,0.00,56.65,453.20,'2021-12-22 11:27:11','',''),(2344973,'1','176','920',409,'Retail Sale Id 1384493',26999.36,0.00,0.00,48.56,388.48,'2021-12-22 11:38:42','',''),(2344983,'1','176','920',409,'Retail Sale Id 1384515',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 11:39:35','',''),(2345172,'1','176','920',409,'Retail Sale Id 1384705',33360.00,0.00,0.00,60.00,480.00,'2021-12-22 11:59:58','',''),(2345315,'1','176','920',409,'Retail Sale Id 1384839',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 12:15:17','',''),(2345558,'1','176','920',409,'Retail Sale Id 1385038',11840.00,0.00,0.00,20.00,880.00,'2021-12-22 12:41:14','',''),(2345709,'1','176','920',409,'Retail Sale Id 1385166',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 12:54:51','',''),(2345761,'1','176','920',409,'Retail Sale Id 1385206',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 13:00:09','',''),(2345880,'1','176','920',409,'Retail Sale Id 1385326',54488.00,0.00,0.00,98.00,784.00,'2021-12-22 13:13:42','',''),(2345921,'1','176','920',409,'Retail Sale Id 1385358',22000.92,0.00,0.00,39.57,316.56,'2021-12-22 13:18:11','',''),(2346006,'1','176','920',409,'Retail Sale Id 1385437',55600.00,0.00,0.00,100.00,800.00,'2021-12-22 13:28:14','',''),(2346356,'1','176','920',409,'Retail Sale Id 1385646',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 13:53:48','',''),(2346673,'1','176','920',409,'Retail Sale Id 1385863',55600.00,0.00,0.00,100.00,800.00,'2021-12-22 14:22:52','',''),(2346727,'1','176','920',409,'Retail Sale Id 1385909',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 14:28:44','',''),(2346755,'1','176','920',409,'Retail Sale Id 1385929',30502.16,0.00,0.00,54.86,438.88,'2021-12-22 14:32:00','',''),(2346795,'1','176','920',409,'Retail Sale Id 1385970',106752.00,0.00,0.00,192.00,1536.00,'2021-12-22 14:36:39','',''),(2346874,'1','176','920',409,'Retail Sale Id 1386010',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 14:42:26','',''),(2346942,'1','176','920',409,'Retail Sale Id 1386070',55600.00,0.00,0.00,100.00,800.00,'2021-12-22 14:49:44','',''),(2347022,'1','176','920',409,'Retail Sale Id 1386136',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 14:57:45','',''),(2347086,'1','176','920',409,'Retail Sale Id 1386193',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 15:05:21','',''),(2347256,'1','176','920',409,'Retail Sale Id 1386338',26688.00,0.00,0.00,48.00,384.00,'2021-12-22 15:20:55','',''),(2347284,'1','176','920',409,'Retail Sale Id 1386351',2000.96,0.00,0.00,3.38,148.72,'2021-12-22 15:22:27','',''),(2347305,'1','176','920',409,'Retail Sale Id 1386363',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 15:24:01','',''),(2348411,'1','176','920',409,'Retail Sale Id 1386895',123854.56,0.00,0.00,222.76,1782.08,'2021-12-22 17:02:12','',''),(2348516,'1','176','920',409,'Distributed to operational loss for sales id:341677',25991.64,0.00,0.00,47.43,0.00,'2021-12-22 17:13:36','',''),(2349501,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,2192000.00,4000.00,0.00,0.00,'2021-12-23 06:01:56','',''),(2349505,'1','176',NULL,409,'Reception corrector for bridging 128455',0.00,0.00,0.00,4000.00,0.00,'2021-12-23 06:02:51','',''),(2349506,'1','176','920',409,'Received from bridging 128455',0.00,0.00,4000.00,0.00,0.00,'2021-12-23 06:02:51','',''),(2349513,'1','176','920',409,'Retail Sale Id 1387818',113146.00,0.00,0.00,203.50,1628.00,'2021-12-23 06:04:29','',''),(2349539,'1','176','920',409,'Retail Sale Id 1387842',278000.00,0.00,0.00,500.00,4000.00,'2021-12-23 06:11:53','',''),(2349548,'1','176','920',409,'Retail Sale Id 1387849',13900.00,0.00,0.00,25.00,200.00,'2021-12-23 06:13:46','',''),(2349554,'1','176','920',409,'Retail Sale Id 1387858',4001.92,0.00,0.00,6.76,297.44,'2021-12-23 06:15:11','',''),(2349561,'1','176','920',409,'Retail Sale Id 1387865',24997.76,0.00,0.00,44.96,359.68,'2021-12-23 06:16:40','',''),(2349614,'1','176','920',409,'Retail Sale Id 1387910',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 06:26:26','',''),(2349639,'1','176','920',409,'Retail Sale Id 1387915',5560.00,0.00,0.00,10.00,80.00,'2021-12-23 06:27:47','',''),(2349666,'1','176','920',409,'Retail Sale Id 1387931',83400.00,0.00,0.00,150.00,1200.00,'2021-12-23 06:30:57','',''),(2349763,'1','176','920',409,'Retail Sale Id 1388013',55600.00,0.00,0.00,100.00,800.00,'2021-12-23 06:46:18','',''),(2349774,'1','176','920',409,'Retail Sale Id 1388027',2000.96,0.00,0.00,3.38,148.72,'2021-12-23 06:49:12','',''),(2349787,'1','176','920',409,'Retail Sale Id 1388033',18904.00,0.00,0.00,34.00,272.00,'2021-12-23 06:51:07','',''),(2349804,'1','176','920',409,'Retail Sale Id 1388055',1000.48,0.00,0.00,1.69,74.36,'2021-12-23 06:53:35','',''),(2349842,'1','176','920',409,'Retail Sale Id 1388084',9199.68,0.00,0.00,15.54,683.76,'2021-12-23 06:58:09','',''),(2350244,'1','176','920',409,'Retail Sale Id 1388357',11840.00,0.00,0.00,20.00,880.00,'2021-12-23 07:26:30','',''),(2350309,'1','176','920',409,'Retail Sale Id 1388410',138444.00,0.00,0.00,249.00,1992.00,'2021-12-23 07:31:43','',''),(2350368,'1','176','920',409,'Retail Sale Id 1388435',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 07:34:30','',''),(2350534,'1','176','920',409,'Retail Sale Id 1388532',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 07:43:07','',''),(2350638,'1','176','920',409,'Retail Sale Id 1388617',6116.00,0.00,0.00,11.00,88.00,'2021-12-23 07:51:48','',''),(2350725,'1','176','920',409,'Retail Sale Id 1388708',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 08:01:53','',''),(2350823,'1','176','920',409,'Retail Sale Id 1388810',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 08:12:42','',''),(2350904,'1','176','920',409,'Retail Sale Id 1388863',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 08:18:58','',''),(2350942,'1','176','920',409,'Retail Sale Id 1388896',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 08:22:04','',''),(2350997,'1','176','920',409,'Retail Sale Id 1388947',33999.40,0.00,0.00,61.15,489.20,'2021-12-23 08:27:10','',''),(2351010,'1','176','920',409,'Retail Sale Id 1388961',29190.00,0.00,0.00,52.50,420.00,'2021-12-23 08:28:53','',''),(2351017,'1','176','920',409,'Retail Sale Id 1388968',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 08:29:48','',''),(2351145,'1','176',NULL,409,'Purchased from AA RANO NIG LTD',0.00,739800.00,1350.00,0.00,0.00,'2021-12-23 08:41:15','',''),(2351152,'1','176',NULL,409,'Reception corrector for bridging 128466',0.00,0.00,0.00,1350.00,0.00,'2021-12-23 08:42:06','',''),(2351153,'1','176','920',409,'Received from bridging 128466',0.00,0.00,1350.00,0.00,0.00,'2021-12-23 08:42:06','',''),(2351275,'1','176','920',409,'Retail Sale Id 1389202',14800.00,0.00,0.00,25.00,1100.00,'2021-12-23 08:53:31','',''),(2351290,'1','176','920',409,'Retail Sale Id 1389213',65608.00,0.00,0.00,118.00,944.00,'2021-12-23 08:55:03','',''),(2351606,'1','176','920',409,'Retail Sale Id 1389522',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 09:27:21','',''),(2351626,'1','176','920',409,'Retail Sale Id 1389534',44480.00,0.00,0.00,80.00,640.00,'2021-12-23 09:28:22','',''),(2351663,'1','176','920',409,'Retail Sale Id 1389559',3001.44,0.00,0.00,5.07,223.08,'2021-12-23 09:31:16','',''),(2351756,'1','176','920',409,'Retail Sale Id 1389647',111200.00,0.00,0.00,200.00,1600.00,'2021-12-23 09:37:34','',''),(2351786,'1','176','920',409,'Retail Sale Id 1389666',25576.00,0.00,0.00,46.00,368.00,'2021-12-23 09:38:51','',''),(2351808,'1','176','920',409,'Retail Sale Id 1389684',23908.00,0.00,0.00,43.00,344.00,'2021-12-23 09:40:15','',''),(2352477,'1','176','920',409,'Retail Sale Id 1390228',16124.00,0.00,0.00,29.00,232.00,'2021-12-23 10:29:53','',''),(2352492,'1','176','920',409,'Retail Sale Id 1390242',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 10:31:21','',''),(2352502,'1','176','920',409,'Retail Sale Id 1390255',27800.00,0.00,0.00,50.00,400.00,'2021-12-23 10:32:36','',''),(2352523,'1','176','920',409,'Retail Sale Id 1390273',10401.44,0.00,0.00,17.57,773.08,'2021-12-23 10:34:22','',''),(2352537,'1','176','920',409,'Retail Sale Id 1390293',2000.96,0.00,0.00,3.38,148.72,'2021-12-23 10:35:35','',''),(2352597,'1','176','920',409,'Retail Sale Id 1390358',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 10:40:36','',''),(2352652,'1','176','920',409,'Retail Sale Id 1390411',111200.00,0.00,0.00,200.00,1600.00,'2021-12-23 10:45:13','',''),(2352803,'1','176','920',409,'Retail Sale Id 1390554',597.92,0.00,0.00,1.01,44.44,'2021-12-23 10:59:03','',''),(2352850,'1','176','920',409,'Retail Sale Id 1390603',70056.00,0.00,0.00,126.00,1008.00,'2021-12-23 11:03:24','',''),(2352880,'1','176','920',409,'Retail Sale Id 1390635',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 11:06:14','',''),(2352938,'1','176','920',409,'Retail Sale Id 1390694',111200.00,0.00,0.00,200.00,1600.00,'2021-12-23 11:11:58','',''),(2353054,'1','176','920',409,'Retail Sale Id 1390800',55600.00,0.00,0.00,100.00,800.00,'2021-12-23 11:22:15','',''),(2353081,'1','176',