-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_171
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_171`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_171` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_171`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3619 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3131,40044,'',0,'6.1','1','171','CASH','','2021-02-05 10:17:51',5,0.00,0.00,'','178','2021-02-05 10:17:51','178',0,1),(3132,400281,'',0,'24','1','171','PURCHASES','','2021-02-05 10:19:01',5,0.00,0.00,'','178','2021-02-05 10:19:01','178',0,1),(3133,400282,'',0,'24','1','171','SALARIES ','','2021-02-05 10:19:26',5,0.00,0.00,'','178','2021-02-05 10:19:26','178',0,1),(3134,20044,'',0,'20','1','171','SALES','','2021-02-05 10:19:36',5,0.00,0.00,'','178','2021-02-05 10:19:36','178',0,1),(3300,400538,'',0,'2','1','171','E-BILLS COLLECTION','','2021-04-22 11:24:34',5,0.00,0.00,'','426','2021-04-22 11:24:34','426',0,1),(3301,400539,'',0,'2','1','171','POS','','2021-04-22 11:24:47',5,0.00,0.00,'','426','2021-04-22 11:24:47','426',0,1),(3353,400579,'',0,'2','1','171','FEDELITY POS','','2021-05-08 14:52:20',5,0.00,0.00,'','426','2021-05-08 14:52:20','426',0,1),(3355,400580,'',0,'2','1','171','ECO POS','','2021-05-24 08:40:03',5,0.00,0.00,'','426','2021-05-24 08:40:03','426',0,1),(3618,400646,'',0,'2','1','171','ZENITH EBILLS 1014717261','','2021-09-08 13:06:49',5,0.00,0.00,'','426','2021-09-08 13:06:49','426',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79635 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (79633,'1','171','0000-00-00','2021-05-31 10:40:41',10,'426','','0000-00-00 00:00:00','426','2021-05-31 10:42:00'),(79634,'1','171','0000-00-00','2021-05-31 10:45:27',10,'426','','0000-00-00 00:00:00','426','2021-05-31 10:46:02');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=167594 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (167590,'1','171','79633','3134','20',194150.00,'Credit Sales for 1,110 Litres of Diesel from shift 20030 on 2021-05-30 13:47:17',0.00,'2021-05-30'),(167591,'1','171','79633','2708','customer',0.00,'Credit Sales for 1,110 Litres of Diesel from shift 20030 on 2021-05-30 13:47:17',194150.00,'2021-05-30'),(167592,'1','171','79634','3134','20',100000.00,'Credit Sales for 377.4 Litres of Diesel from shift 20054 on 2021-05-30 09:51:33',0.00,'2021-05-30'),(167593,'1','171','79634','2708','customer',0.00,'Credit Sales for 377.4 Litres of Diesel from shift 20054 on 2021-05-30 09:51:33',100000.00,'2021-05-30');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46555 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (46513,'1','171','2021-11-01','','3134',0.00,'2021-11-16 15:42:16',0,'571','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46514,'1','171','2021-11-05','','3134',0.00,'2021-11-16 15:42:55',0,'571','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46515,'1','171','2021-11-09','','3134',0.00,'2021-11-16 15:44:16',0,'571','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46516,'1','171','2021-11-13','','3134',0.00,'2021-11-16 15:45:29',0,'571','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46554,'1','171','2021-11-19','','3132',0.00,'2021-11-21 20:11:24',0,'571','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84737 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (84628,'1','171',46513,3134,'AGO CONSUPTION 200 LITERS @ 340',68000.00),(84629,'1','171',46514,3134,'AGO CONSUPTION 200 LITERS @ 340',68000.00),(84630,'1','171',46515,3134,'AGO CONSUPTION 200 LITERS @ 340',68000.00),(84631,'1','171',46516,3134,'AGO CONSUPTION 200 LITERS @ 340',68000.00),(84736,'1','171',46554,3134,'AGO CONSUMPTION 200 LITERS @340',68000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2869 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2708,'','1','171','BISWAL','ABDULATEEF','080********','b.swalng@gmail.com','KAURE','AKURE','LAGOS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-29 10:16:32',5,'426','2021-05-29 10:16:32','426'),(2867,'','1','171','DRIVER SHORT','MANAGER','080********','driver@gmail.com','AKURE','AKURE','STATION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 15:48:38',5,'426','2021-06-29 15:48:38','426'),(2868,'','1','171','NIGERIA POLICE FORCE (ELECTION','ANEKE C. FRANCIS','08063961379','dopstransport@gmail.com','AKURE','ONDO','ONDO STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:09:49',5,'975','2023-02-21 17:09:49','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18646 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','171',14582,'932',0.00,35600.00,'2021-04-23','','2021-04-23 09:06:41','426','426',2021,'426','2021-04-23 09:06:41',5),('1','171',14583,'877',0.00,35800.00,'2021-04-23','','2021-04-23 09:07:05','426','426',2021,'426','2021-04-23 09:07:05',5),('1','171',14584,'878',0.00,29000.00,'2021-04-23','','2021-04-23 09:07:31','426','426',2021,'426','2021-04-23 09:07:31',5),('1','171',14585,'879',0.00,31600.00,'2021-04-23','','2021-04-23 09:07:58','426','426',2021,'426','2021-04-23 09:07:58',5),('1','171',14752,'879',1340.00,500.00,'2021-04-30','','2021-04-30 16:57:22','571','571',2021,'571','2021-04-30 16:57:22',5),('1','171',14753,'879',500.00,1800.00,'2021-04-30','','2021-04-30 16:58:36','571','571',2021,'571','2021-04-30 16:58:36',5),('1','171',14754,'879',35.00,200.00,'2021-04-30','','2021-04-30 17:05:56','571','571',2021,'571','2021-04-30 17:05:56',5),('1','171',14755,'879',200.00,250.00,'2021-04-30','','2021-04-30 17:21:12','571','571',2021,'571','2021-04-30 17:21:12',5),('1','171',14756,'879',250.00,1250.00,'2021-04-30','','2021-04-30 17:23:52','571','571',2021,'571','2021-04-30 17:23:52',5),('1','171',14766,'879',48.00,2100.00,'2021-05-01','','2021-05-01 19:25:38','571','571',2021,'571','2021-05-01 19:25:38',5),('1','171',14767,'879',2100.00,1100.00,'2021-05-01','','2021-05-01 19:27:20','571','571',2021,'571','2021-05-01 19:27:20',5),('1','171',14770,'879',-943.00,1500.00,'2021-05-02','','2021-05-02 14:26:37','571','571',2021,'571','2021-05-02 14:26:37',5),('1','171',14774,'879',486.00,1600.00,'2021-05-02','','2021-05-02 16:26:07','571','571',2021,'571','2021-05-02 16:26:07',5),('1','171',14793,'879',92.00,1000.00,'2021-05-04','','2021-05-04 13:36:18','571','571',2021,'571','2021-05-04 13:36:18',5),('1','171',14804,'879',297.00,2200.00,'2021-05-04','','2021-05-04 16:58:25','571','571',2021,'571','2021-05-04 16:58:25',5),('1','171',14843,'879',91.00,500.00,'2021-05-08','','2021-05-08 11:24:40','571','571',2021,'571','2021-05-08 11:24:40',5),('1','171',14861,'879',109.00,1700.00,'2021-05-08','','2021-05-08 12:32:46','571','571',2021,'571','2021-05-08 12:32:46',5),('1','171',14873,'879',24.00,4100.00,'2021-05-08','','2021-05-08 14:28:14','571','571',2021,'571','2021-05-08 14:28:14',5),('1','171',14890,'879',83.00,2100.00,'2021-05-09','','2021-05-09 13:04:47','571','571',2021,'571','2021-05-09 13:04:47',5),('1','171',14893,'879',2100.00,2600.00,'2021-05-09','','2021-05-09 13:31:53','571','571',2021,'571','2021-05-09 13:31:53',5),('1','171',14895,'879',41.00,400.00,'2021-05-09','','2021-05-09 14:44:59','571','571',2021,'571','2021-05-09 14:44:59',5),('1','171',14897,'879',44.00,250.00,'2021-05-09','','2021-05-09 15:33:29','571','571',2021,'571','2021-05-09 15:33:29',5),('1','171',14899,'879',4.00,1700.00,'2021-05-09','','2021-05-09 17:56:46','571','571',2021,'571','2021-05-09 17:56:46',5),('1','171',15164,'877',2023.00,2500.00,'2021-06-03','','2021-06-04 07:41:26','571','571',2021,'571','2021-06-04 07:41:26',5),('1','171',15165,'877',2500.00,2660.00,'2021-06-04','','2021-06-04 07:47:21','571','571',2021,'571','2021-06-04 07:47:21',5),('1','171',15182,'932',30.00,410.00,'2021-06-06','','2021-06-06 13:31:53','571','571',2021,'571','2021-06-06 13:31:53',5),('1','171',15219,'932',2.00,302.00,'2021-06-09','','2021-06-10 06:29:20','571','571',2021,'571','2021-06-10 06:29:20',5),('1','171',15297,'877',3616.00,3737.00,'2021-06-16','','2021-06-17 07:39:15','571','571',2021,'571','2021-06-17 07:39:15',5),('1','171',15497,'877',1078.46,1202.00,'2021-06-25','','2021-06-25 13:55:33','571','571',2021,'571','2021-06-25 13:55:33',5),('1','171',15546,'877',2583.49,2712.00,'2021-06-30','','2021-06-30 13:49:30','571','571',2021,'571','2021-06-30 13:49:30',5),('1','171',15556,'877',2.18,273.00,'2021-07-01','','2021-07-01 07:15:20','571','571',2021,'571','2021-07-01 07:15:20',5),('1','171',15557,'877',273.00,275.00,'2021-07-01','','2021-07-01 07:35:41','571','571',2021,'571','2021-07-01 07:35:41',5),('1','171',15608,'932',117.21,445.00,'2021-07-02','','2021-07-02 07:26:23','571','571',2021,'571','2021-07-02 07:26:23',5),('1','171',15724,'877',731.43,870.00,'2021-07-15','','2021-07-15 06:42:56','571','571',2021,'571','2021-07-15 06:42:56',5),('1','171',15867,'877',72.02,75.00,'2021-07-28','','2021-07-28 12:46:31','571','571',2021,'571','2021-07-28 12:46:31',5),('1','171',16063,'877',854.62,860.00,'2021-08-15','','2021-08-15 18:20:37','571','571',2021,'571','2021-08-15 18:20:37',5),('1','171',16195,'877',2896.71,3146.00,'2021-08-28','','2021-08-28 07:53:25','571','571',2021,'571','2021-08-28 07:53:25',5),('1','171',16783,'877',3337.07,3700.00,'2021-10-13','','2021-10-13 07:18:10','571','571',2021,'571','2021-10-13 07:18:10',5),('1','171',16896,'877',125.08,1110.00,'2021-10-24','','2021-10-24 07:05:42','571','571',2021,'571','2021-10-24 07:05:42',5),('1','171',17345,'877',1536.80,800.00,'2021-10-31','','2021-10-31 06:00:11','426','426',2021,'426','2021-10-31 06:00:11',5),('1','171',17346,'878',37985.94,450.00,'2021-10-31','','2021-10-31 06:00:34','426','426',2021,'426','2021-10-31 06:00:34',5),('1','171',17347,'879',6658.38,400.00,'2021-10-31','','2021-10-31 06:00:52','426','426',2021,'426','2021-10-31 06:00:52',5),('1','171',17348,'932',24736.46,21700.00,'2021-10-31','','2021-10-31 06:01:13','426','426',2021,'426','2021-10-31 06:01:13',5),('1','171',17361,'877',700.62,800.00,'2021-10-31','','2021-10-31 08:41:53','426','426',2021,'426','2021-10-31 08:41:53',5),('1','171',17362,'878',450.00,450.00,'2021-10-31','','2021-10-31 08:42:10','426','426',2021,'426','2021-10-31 08:42:10',5),('1','171',17363,'879',400.00,400.00,'2021-10-31','','2021-10-31 08:42:23','426','426',2021,'426','2021-10-31 08:42:23',5),('1','171',17364,'932',20876.19,21700.00,'2021-10-31','','2021-10-31 08:42:39','426','426',2021,'426','2021-10-31 08:42:39',5),('1','171',17812,'879',245.06,708.00,'2021-11-28','','2021-11-28 21:34:22','614','614',2021,'614','2021-11-28 21:34:22',5),('1','171',17817,'879',0.15,64.00,'2021-11-29','','2021-11-29 10:35:50','614','614',2021,'614','2021-11-29 10:35:50',5),('1','171',18122,'877',1020.59,1132.00,'2021-12-19','','2021-12-19 13:31:10','614','614',2021,'614','2021-12-19 13:31:10',5),('1','171',18132,'879',756.13,1116.00,'2021-12-20','','2021-12-20 13:47:30','614','614',2021,'614','2021-12-20 13:47:30',5),('1','171',18149,'878',2013.18,2020.00,'2021-12-21','','2021-12-21 13:35:45','614','614',2021,'614','2021-12-21 13:35:45',5),('1','171',18164,'877',417.83,619.00,'2021-12-23','','2021-12-23 13:09:03','614','614',2021,'614','2021-12-23 13:09:03',5),('1','171',18179,'877',0.48,259.00,'2021-12-23','','2021-12-23 19:40:15','614','614',2021,'614','2021-12-23 19:40:15',5),('1','171',18289,'879',204.88,552.00,'2022-01-01','','2022-01-01 17:10:02','614','614',2022,'614','2022-01-01 17:10:02',5),('1','171',18350,'877',4.29,29.00,'2022-01-04','','2022-01-04 14:10:57','614','614',2022,'614','2022-01-04 14:10:57',5),('1','171',18351,'877',29.00,33.00,'2022-01-04','','2022-01-04 14:22:06','614','614',2022,'614','2022-01-04 14:22:06',5),('1','171',18376,'877',1487.98,1543.00,'2022-01-07','','2022-01-07 20:14:28','614','614',2022,'614','2022-01-07 20:14:28',5),('1','171',18407,'879',1162.09,1327.00,'2022-01-10','','2022-01-10 17:11:41','614','614',2022,'614','2022-01-10 17:11:41',5),('1','171',18418,'879',0.81,92.00,'2022-01-11','','2022-01-11 14:20:09','614','614',2022,'614','2022-01-11 14:20:09',5),('1','171',18582,'879',2306.94,2592.00,'2022-01-28','','2022-01-28 18:44:41','614','614',2022,'614','2022-01-28 18:44:41',5),('1','171',18583,'877',3079.15,3772.00,'2022-02-06','','2022-02-06 20:44:38','614','614',2022,'614','2022-02-06 20:44:38',5),('1','171',18584,'879',3434.36,3635.00,'2022-02-08','','2022-02-08 14:28:02','614','614',2022,'614','2022-02-08 14:28:02',5),('1','171',18585,'879',0.48,163.00,'2022-02-08','','2022-02-08 20:12:27','614','614',2022,'614','2022-02-08 20:12:27',5),('1','171',18586,'877',2256.30,2363.00,'2022-02-13','','2022-02-13 19:35:29','614','614',2022,'614','2022-02-13 19:35:29',5),('1','171',18587,'879',4466.00,4667.00,'2022-02-13','','2022-02-13 19:38:52','614','614',2022,'614','2022-02-13 19:38:52',5),('1','171',18588,'932',688.49,744.00,'2022-02-17','','2022-02-17 13:05:29','614','614',2022,'614','2022-02-17 13:05:29',5),('1','171',18589,'932',0.02,57.00,'2022-02-17','','2022-02-17 19:11:53','614','614',2022,'614','2022-02-17 19:11:53',5),('1','171',18590,'877',0.61,24000.00,'2022-02-20','','2022-02-20 10:38:31','426','426',2022,'426','2022-02-20 10:38:31',5),('1','171',18591,'877',24000.00,24500.00,'2022-02-20','','2022-02-20 10:40:53','426','426',2022,'426','2022-02-20 10:40:53',5),('1','171',18592,'877',24500.00,100.00,'2022-02-20','','2022-02-20 10:44:18','426','426',2022,'426','2022-02-20 10:44:18',5),('1','171',18593,'932',0.21,200.00,'2022-02-20','','2022-02-20 17:45:05','614','614',2022,'614','2022-02-20 17:45:05',5),('1','171',18594,'879',3451.45,3567.00,'2022-02-25','','2022-02-26 15:41:09','614','614',2022,'614','2022-02-26 15:41:09',5),('1','171',18595,'932',735.19,790.00,'2022-03-09','','2022-03-09 22:04:57','614','614',2022,'614','2022-03-09 22:04:57',5),('1','171',18596,'932',0.52,204.00,'2022-03-14','','2022-03-14 19:30:33','614','614',2022,'614','2022-03-14 19:30:33',5),('1','171',18597,'879',567.58,1332.00,'2022-03-20','','2022-03-20 21:00:38','614','614',2022,'614','2022-03-20 21:00:38',5),('1','171',18598,'879',3.39,689.00,'2022-04-05','','2022-04-05 16:26:38','614','614',2022,'614','2022-04-05 16:26:38',5),('1','171',18599,'932',70.00,550.00,'2022-04-09','','2022-04-09 20:27:01','614','614',2022,'614','2022-04-09 20:27:01',5),('1','171',18600,'879',0.22,248.00,'2022-04-14','','2022-04-14 20:25:59','614','614',2022,'614','2022-04-14 20:25:59',5),('1','171',18601,'879',1859.67,2271.00,'2022-04-29','','2022-04-29 19:11:43','614','614',2022,'614','2022-04-29 19:11:43',5),('1','171',18602,'932',53.75,100.00,'2022-05-06','','2022-05-06 21:39:29','614','614',2022,'614','2022-05-06 21:39:29',5),('1','171',18603,'879',1815.71,2438.00,'2022-05-14','','2022-05-14 15:14:47','614','614',2022,'614','2022-05-14 15:14:47',5),('1','171',18604,'879',2281.68,2479.00,'2022-05-21','','2022-05-21 17:15:38','614','614',2022,'614','2022-05-21 17:15:38',5),('1','171',18605,'879',0.62,250.00,'2022-06-02','','2022-06-02 12:38:25','614','614',2022,'614','2022-06-02 12:38:25',5),('1','171',18606,'932',11591.94,11900.00,'2022-06-09','','2022-06-09 10:16:45','426','426',2022,'426','2022-06-09 10:16:45',5),('1','171',18607,'878',4.30,400.00,'2022-06-09','','2022-06-09 10:17:05','426','426',2022,'426','2022-06-09 10:17:05',5),('1','171',18608,'877',11468.74,11900.00,'2022-06-09','','2022-06-09 10:17:24','426','426',2022,'426','2022-06-09 10:17:24',5),('1','171',18609,'879',15540.23,16400.00,'2022-06-09','','2022-06-09 10:17:55','426','426',2022,'426','2022-06-09 10:17:55',5),('1','171',18610,'932',11900.00,12700.00,'2022-06-09','','2022-06-09 10:18:16','426','426',2022,'426','2022-06-09 10:18:16',5),('1','171',18611,'878',6042.76,6187.00,'2022-07-14','','2022-07-14 21:28:03','614','614',2022,'614','2022-07-14 21:28:03',5),('1','171',18612,'879',3510.13,4277.00,'2022-07-16','','2022-07-16 23:38:33','614','614',2022,'614','2022-07-16 23:38:33',5),('1','171',18613,'879',2852.99,3172.00,'2022-07-30','','2022-07-30 20:40:02','614','614',2022,'614','2022-07-30 20:40:02',5),('1','171',18614,'879',3172.00,3173.00,'2022-07-30','','2022-07-30 21:53:07','614','614',2022,'614','2022-07-30 21:53:07',5),('1','171',18615,'932',15.20,192.00,'2022-08-03','','2022-08-03 12:44:52','614','614',2022,'614','2022-08-03 12:44:52',5),('1','171',18616,'878',0.27,330.00,'2022-08-04','','2022-08-04 19:49:04','614','614',2022,'614','2022-08-04 19:49:04',5),('1','171',18617,'879',0.21,141.00,'2022-08-09','','2022-08-09 18:55:38','614','614',2022,'614','2022-08-09 18:55:38',5),('1','171',18618,'878',0.43,309.00,'2022-08-13','','2022-08-13 19:37:21','614','614',2022,'614','2022-08-13 19:37:21',5),('1','171',18619,'879',0.77,203.00,'2022-08-19','','2022-08-19 21:02:39','614','614',2022,'614','2022-08-19 21:02:39',5),('1','171',18620,'879',1788.87,2139.00,'2022-09-09','','2022-09-09 20:09:31','614','614',2022,'614','2022-09-09 20:09:31',5),('1','171',18621,'878',2232.88,47100.00,'2022-09-12','','2022-09-12 13:24:21','426','426',2022,'426','2022-09-12 13:24:21',5),('1','171',18622,'879',804.12,1057.00,'2022-09-21','','2022-09-21 22:54:16','614','614',2022,'614','2022-09-21 22:54:16',5),('1','171',18623,'932',28.82,1250.00,'2022-09-23','','2022-09-23 20:15:52','614','614',2022,'614','2022-09-23 20:15:52',5),('1','171',18624,'932',0.69,150.00,'2022-09-27','','2022-09-27 17:52:27','614','614',2022,'614','2022-09-27 17:52:27',5),('1','171',18625,'932',0.00,50.00,'2022-09-30','','2022-09-30 20:51:34','614','614',2022,'614','2022-09-30 20:51:34',5),('1','171',18626,'879',0.06,206.00,'2022-09-30','','2022-09-30 20:52:43','614','614',2022,'614','2022-09-30 20:52:43',5),('1','171',18627,'932',0.00,98.00,'2022-10-01','','2022-10-01 21:24:44','614','614',2022,'614','2022-10-01 21:24:44',5),('1','171',18628,'878',1.16,113.00,'2022-10-10','','2022-10-10 19:10:42','614','614',2022,'614','2022-10-10 19:10:42',5),('1','171',18629,'879',0.76,192.00,'2022-10-15','','2022-10-15 12:55:28','614','614',2022,'614','2022-10-15 12:55:28',5),('1','171',18630,'879',44.18,206.00,'2022-10-24','','2022-10-24 15:00:43','614','614',2022,'614','2022-10-24 15:00:43',5),('1','171',18631,'932',26.23,281.00,'2022-11-10','','2022-11-10 13:32:14','614','614',2022,'614','2022-11-10 13:32:14',5),('1','171',18632,'932',0.21,779.00,'2022-12-12','','2022-12-12 13:11:03','975','975',2022,'975','2022-12-12 13:11:03',5),('1','171',18633,'932',2013.67,2500.00,'2022-12-26','','2022-12-26 12:53:39','975','975',2022,'975','2022-12-26 12:53:39',5),('1','171',18634,'877',2221.29,2250.00,'2022-12-28','','2022-12-28 16:10:28','975','975',2022,'975','2022-12-28 16:10:28',5),('1','171',18635,'879',1576.96,1700.00,'2022-12-28','','2022-12-28 16:10:46','975','975',2022,'975','2022-12-28 16:10:46',5),('1','171',18636,'932',1505.32,2500.00,'2023-01-23','','2023-01-23 23:08:23','734','734',2023,'734','2023-01-23 23:08:23',5),('1','171',18637,'879',7466.03,7700.00,'2023-01-30','','2023-01-30 17:56:13','734','734',2023,'734','2023-01-30 17:56:13',5),('1','171',18638,'879',8413.76,8500.00,'2023-02-01','','2023-02-01 17:31:58','734','734',2023,'734','2023-02-01 17:31:58',5),('1','171',18639,'879',12630.42,13000.00,'2023-02-09','','2023-02-09 14:03:38','734','734',2023,'734','2023-02-09 14:03:38',5),('1','171',18640,'879',2368.41,2500.00,'2023-02-28','','2023-02-28 22:39:25','734','734',2023,'734','2023-02-28 22:39:25',5),('1','171',18641,'878',1843.25,11900.00,'2023-03-04','','2023-03-04 20:20:08','734','734',2023,'734','2023-03-04 20:20:08',5),('1','171',18642,'877',15365.37,5400.00,'2023-03-04','','2023-03-04 20:20:31','734','734',2023,'734','2023-03-04 20:20:31',5),('1','171',18643,'878',156.88,350.00,'2023-03-08','','2023-03-08 21:29:34','734','734',2023,'734','2023-03-08 21:29:34',5),('1','171',18644,'932',3.81,500.00,'2023-03-11','','2023-03-11 20:40:52','734','734',2023,'734','2023-03-11 20:40:52',5),('1','171',18645,'879',2819.72,3200.00,'2023-03-15','','2023-03-15 14:35:39','734','734',2023,'734','2023-03-15 14:35:39',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2742 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','171','877',2593,'5','PUMP 1',630925.56,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:25:02','426'),('1','171','877',2594,'5','PUMP 2',517634.94,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:25:29','426'),('1','171','877',2595,'5','PUMP 3',493338.74,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:25:52','426'),('1','171','877',2596,'5','PUMP 4',586693.03,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:26:20','426'),('1','171','878',2597,'5','PUMP 5',697080.54,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:26:48','426'),('1','171','878',2598,'5','PUMP 6',731885.49,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:27:18','426'),('1','171','878',2599,'5','PUMP 7',678287.22,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:27:50','426'),('1','171','878',2600,'5','PUMP 8',615711.38,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:28:14','426'),('1','171','879',2601,'5','PUMP 9',846103.73,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:28:44','426'),('1','171','879',2602,'5','PUMP 10',843461.52,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:29:10','426'),('1','171','879',2603,'5','PUMP 11',691316.00,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:30:11','426'),('1','171','879',2604,'5','PUMP 12',700817.78,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 10:30:46','426'),('1','171','932',2740,'5','AGO 1',237999.16,'DESPENSE AGO','',NULL,NULL,'',5,'2021-04-21 10:35:39','426'),('1','171','932',2741,'5','AGO 2',1052648.19,'DESPENSE AGO','',NULL,NULL,'',5,'2021-04-21 10:36:46','426');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258321 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','171',192616,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'571',1788535.85,1771214.07,'571','2021-04-23 09:51:47','614','2021-04-23 10:36:14',10,0),('1','171',192644,'AFTERNO0N SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'571',1956900.90,1936149.90,'571','2021-04-23 11:24:30','614','2021-04-23 11:33:03',10,0),('1','171',192652,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'571',1680994.90,1665518.14,'571','2021-04-23 14:27:39','614','2021-04-23 14:46:09',10,0),('1','171',192687,'AFTERNO0N SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'571',1884585.10,1864707.22,'571','2021-04-23 15:03:47','614','2021-04-23 16:11:10',10,0),('1','171',192724,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'571',1623777.65,1607843.31,'571','2021-04-23 17:33:06','614','2021-04-23 18:37:57',10,0),('1','171',192836,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'571',1586670.60,1568587.24,'571','2021-04-24 11:48:25','614','2021-04-24 20:30:42',10,0),('1','171',193115,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'571',1147561.15,1134543.89,'571','2021-04-25 16:02:44','614','2021-04-25 21:15:07',10,0),('1','171',193235,'AFTERNOON SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'571',1220946.40,1207747.20,'571','2021-04-26 10:05:17','614','2021-04-26 11:48:11',10,0),('1','171',193294,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'571',1704016.05,1685691.95,'571','2021-04-26 13:50:43','614','2021-04-26 14:07:17',10,0),('1','171',193328,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'571',1615729.10,1599759.86,'571','2021-04-26 14:28:40','614','2021-04-26 14:33:08',10,0),('1','171',193339,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'571',2079736.05,2062346.51,'571','2021-04-26 16:01:09','614','2021-04-26 16:16:32',10,0),('1','171',193363,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'571',2145193.20,2124763.84,'571','2021-04-26 17:08:41','614','2021-04-26 18:53:03',10,0),('1','171',193487,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'571',1544779.15,1530167.25,'571','2021-04-27 11:05:37','614','2021-04-27 11:35:36',10,0),('1','171',193504,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'571',1710577.50,1693074.98,'571','2021-04-27 12:17:25','614','2021-04-27 13:54:09',10,0),('1','171',193570,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'571',1827659.05,1810165.91,'571','2021-04-27 15:31:48','614','2021-04-27 19:20:44',10,0),('1','171',193708,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'571',2504965.70,2480613.90,'571','2021-04-28 11:14:47','614','2021-04-28 11:43:32',10,0),('1','171',193754,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'571',1668901.20,1651212.72,'571','2021-04-28 14:03:16','614','2021-04-28 14:04:10',10,0),('1','171',193762,'AFTERNOON SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'571',2266771.70,2243994.62,'571','2021-04-28 14:50:36','614','2021-04-28 14:53:58',10,0),('1','171',193788,'MORNING SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'571',2074865.35,2055959.69,'571','2021-04-28 15:27:57','614','2021-04-28 16:07:07',10,0),('1','171',193812,'AFTERNOON SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'571',1070826.75,1059154.69,'571','2021-04-28 17:18:49','614','2021-04-29 09:31:56',10,0),('1','171',193952,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'571',1210307.60,1210307.60,'571','2021-04-29 11:05:00','614','2021-04-29 11:49:51',10,0),('1','171',193997,'AFTERNOON SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'571',1211265.50,1211265.50,'571','2021-04-29 13:52:54','614','2021-04-29 14:27:36',10,0),('1','171',194013,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'571',1459450.55,1459450.55,'571','2021-04-29 14:45:56','614','2021-04-30 12:27:00',10,0),('1','171',194240,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'571',1590642.90,1590642.90,'571','2021-04-30 16:59:19','614','2021-04-30 17:00:01',10,0),('1','171',194252,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'571',1467928.15,1467928.15,'571','2021-04-30 17:24:08','614','2021-05-01 13:50:42',10,0),('1','171',194458,'AFTERNOON SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'571',1528158.43,1544154.85,'571','2021-05-01 19:26:08','614','2021-05-01 23:16:53',10,0),('1','171',194589,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'571',1085267.67,1095397.45,'571','2021-05-02 14:37:45','614','2021-05-02 15:52:48',10,0),('1','171',194622,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'571',1625702.79,1644845.85,'571','2021-05-02 16:30:25','614','2021-05-02 20:28:40',10,0),('1','171',194773,'MORNING SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'571',616016.91,623140.45,'571','2021-05-03 11:44:43','614','2021-05-03 16:12:36',10,0),('1','171',194856,'AFTERNOON SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'571',1546404.29,1561869.15,'571','2021-05-03 19:16:42','614','2021-05-03 22:08:08',10,0),('1','171',194964,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'571',1487501.97,1498975.95,'571','2021-05-04 13:36:27','614','2021-05-04 16:49:34',10,0),('1','171',195039,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'571',2018877.04,2039398.00,'571','2021-05-04 17:02:29','614','2021-05-05 09:53:35',10,0),('1','171',195179,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'571',1176100.84,1183781.00,'571','2021-05-05 11:23:04','614','2021-05-05 21:19:34',10,0),('1','171',195379,'AFTERNOON SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'571',1780133.12,1799311.60,'571','2021-05-06 10:23:10','426','2021-05-06 10:53:53',10,0),('1','171',195393,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'571',1649089.64,1660490.60,'571','2021-05-06 11:15:14','614','2021-05-06 13:35:09',10,0),('1','171',195447,'AFTERNOON SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'571',1956669.74,1976326.10,'571','2021-05-06 13:52:44','614','2021-05-06 19:08:14',10,0),('1','171',195638,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'571',896825.74,902121.70,'571','2021-05-07 11:14:58','426','2021-05-07 11:30:25',10,0),('1','171',195685,'AFTERNOON SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'571',2140338.07,2161838.25,'571','2021-05-07 14:13:49','426','2021-05-07 14:47:25',10,0),('1','171',195720,'MORNING SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'571',873613.68,878005.20,'571','2021-05-07 16:24:58','614','2021-05-07 16:46:06',10,0),('1','171',195741,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'571',1977533.83,1997941.85,'571','2021-05-07 17:25:57','614','2021-05-08 05:41:10',10,0),('1','171',195851,'MORNING SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'571',723279.23,729796.85,'571','2021-05-08 10:16:17','426','2021-05-08 10:29:13',10,0),('1','171',195857,'AFTERNOON SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'571',1566447.63,1580770.85,'571','2021-05-08 11:48:42','614','2021-05-08 12:03:49',10,0),('1','171',195882,'MORNING SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'571',1068582.07,1076974.65,'571','2021-05-08 12:33:09','426','2021-05-08 12:36:36',10,0),('1','171',195917,'AFTERNOON SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'571',1040898.44,1049962.60,'571','2021-05-08 14:28:32','426','2021-05-08 14:31:55',10,0),('1','171',195920,'MORNING SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'571',306228.00,306228.00,'571','2021-05-08 14:46:15','614','2021-05-08 15:37:42',10,0),('1','171',195945,'AFTERNOON SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'571',350638.60,350638.60,'571','2021-05-08 16:23:35','426','2021-05-08 16:28:23',10,0),('1','171',195948,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'571',380130.40,380130.40,'571','2021-05-08 16:39:14','614','2021-05-08 17:08:26',10,0),('1','171',195955,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'571',289549.00,289549.00,'571','2021-05-08 17:13:48','614','2021-05-08 17:41:44',10,0),('1','171',195965,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'571',305554.60,305554.60,'571','2021-05-08 17:46:22','614','2021-05-08 18:05:01',10,0),('1','171',195970,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'571',571438.40,571438.40,'571','2021-05-08 19:07:30','614','2021-05-08 20:34:10',10,0),('1','171',196091,'MORNING SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'571',165300.20,165300.20,'571','2021-05-09 11:17:51','614','2021-05-09 11:22:36',10,0),('1','171',196093,'AFTERNOON SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'571',452579.40,452579.40,'571','2021-05-09 11:29:43','614','2021-05-09 11:51:41',10,0),('1','171',196106,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'571',124875.40,124875.40,'571','2021-05-09 12:12:46','426','2021-05-09 12:58:58',10,0),('1','171',196118,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'571',1827520.76,1827520.76,'571','2021-05-09 13:32:42','426','2021-05-09 13:35:31',10,0),('1','171',196129,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'571',1160933.47,1160933.47,'571','2021-05-09 13:47:36','426','2021-05-09 14:05:58',10,0),('1','171',196136,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'571',1236163.09,1236163.09,'571','2021-05-09 14:15:21','426','2021-05-09 14:22:57',10,0),('1','171',196143,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'571',1183017.79,1183017.79,'571','2021-05-09 14:32:20','426','2021-05-09 14:39:24',10,0),('1','171',196148,'AFTERNOON SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'571',1272392.03,1272392.03,'571','2021-05-09 14:48:55','426','2021-05-09 14:50:49',10,0),('1','171',196149,'MORNING SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'571',1179857.23,1179857.23,'571','2021-05-09 14:55:47','426','2021-05-09 14:57:08',10,0),('1','171',196153,'AFTERNOON SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'571',1471518.45,1471518.45,'571','2021-05-09 15:00:43','426','2021-05-09 15:05:14',10,0),('1','171',196155,'MORNING SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'571',1105555.72,1105555.72,'571','2021-05-09 15:36:23','426','2021-05-09 15:39:25',10,0),('1','171',196160,'AFTERNOON SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'571',244355.80,244355.80,'571','2021-05-09 15:44:03','426','2021-05-09 15:45:10',10,0),('1','171',196161,'MORNING SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'571',301844.40,301844.40,'571','2021-05-09 15:50:11','426','2021-05-09 15:52:36',10,0),('1','171',196166,'AFTERNOON SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'571',217323.60,217323.60,'571','2021-05-09 15:56:10','426','2021-05-09 15:58:03',10,0),('1','171',196167,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'571',274822.60,274822.60,'571','2021-05-09 16:01:04','614','2021-05-09 16:06:40',10,0),('1','171',196170,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'571',410802.60,410802.60,'571','2021-05-09 16:16:39','614','2021-05-09 16:37:02',10,0),('1','171',196177,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'571',37702.60,37702.60,'571','2021-05-09 17:24:17','614','2021-05-09 17:30:05',10,0),('1','171',196180,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'571',1235964.71,1235964.71,'571','2021-05-09 17:56:55','426','2021-05-10 07:43:01',10,0),('1','171',196267,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'571',716217.53,716217.53,'571','2021-05-10 07:50:07','426','2021-05-10 07:51:42',10,0),('1','171',196269,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'571',1553071.00,1553071.00,'571','2021-05-10 07:56:00','426','2021-05-10 07:57:33',10,0),('1','171',196278,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'571',710810.79,710810.79,'571','2021-05-10 08:28:34','426','2021-05-10 08:30:35',10,0),('1','171',196283,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',196286,'MORNING SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'571',1392095.85,1392095.85,'571','2021-05-10 09:07:28','426','2021-05-10 09:23:15',10,0),('1','171',196362,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'571',987956.94,987956.94,'571','2021-05-10 14:05:24','614','2021-05-11 10:56:57',10,0),('1','171',196549,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'571',1360750.08,1360750.08,'571','2021-05-11 11:54:09','426','2021-05-11 13:42:48',10,0),('1','171',196572,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'571',999382.34,999382.34,'571','2021-05-11 13:53:36','614','2021-05-11 15:10:31',10,0),('1','171',196688,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'571',1140758.76,1140758.76,'571','2021-05-12 07:47:43','614','2021-05-12 09:35:01',10,0),('1','171',196780,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'571',710944.06,710944.06,'571','2021-05-12 13:40:06','614','2021-05-12 15:36:36',10,0),('1','171',196897,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'571',1221590.46,1221590.46,'571','2021-05-13 09:51:54','614','2021-05-13 09:53:25',10,0),('1','171',196945,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'571',748898.61,748898.61,'571','2021-05-13 14:05:02','614','2021-05-13 15:23:49',10,0),('1','171',197087,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'571',1080505.81,1080505.81,'571','2021-05-14 09:05:01','614','2021-05-14 12:29:28',10,0),('1','171',197148,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'571',791746.42,791746.42,'571','2021-05-14 14:30:11','614','2021-05-14 14:40:14',10,0),('1','171',197465,'AFTERNOON ','2021-05-14','2021-05-14 00:00:00',NULL,'571',1465958.24,1465958.24,'571','2021-05-16 18:32:42','614','2021-05-16 21:53:41',10,0),('1','171',197546,'MORNING ','2021-05-15','2021-05-15 00:00:00',NULL,'571',1198103.11,1198103.11,'571','2021-05-17 08:05:56','614','2021-05-17 10:38:13',10,0),('1','171',197729,'AFTERNO0N SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'571',1433673.85,1433673.85,'571','2021-05-17 14:12:50','614','2021-05-17 14:13:59',10,0),('1','171',197732,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'571',940794.38,940794.38,'571','2021-05-17 14:21:54','614','2021-05-17 14:34:20',10,0),('1','171',197742,'AFTERNO0N SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'571',1311067.77,1311067.77,'571','2021-05-17 14:44:40','614','2021-05-17 15:47:29',10,0),('1','171',197774,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'571',1451939.54,1451939.54,'571','2021-05-17 15:52:08','614','2021-05-17 16:14:34',10,0),('1','171',197864,'AFTERNO0N SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'571',1599869.94,1599869.94,'571','2021-05-18 06:07:45','614','2021-05-18 09:25:07',10,0),('1','171',198034,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'571',1309453.37,1309453.37,'571','2021-05-18 14:18:01','614','2021-05-18 14:20:15',10,0),('1','171',198140,'AFTERNO0N SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'571',1854091.37,1854091.37,'571','2021-05-19 07:52:24','614','2021-05-19 08:55:49',10,0),('1','171',198238,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'571',1222554.47,1222554.47,'571','2021-05-19 13:06:46','614','2021-05-19 14:38:54',10,0),('1','171',198394,'AFTERNO0N SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'571',2012325.86,2012325.86,'571','2021-05-20 08:33:44','614','2021-05-20 12:26:51',10,0),('1','171',198473,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'571',1407876.35,1407876.35,'571','2021-05-20 13:50:38','614','2021-05-20 22:14:10',10,0),('1','171',198643,'AFTERNO0N SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'571',2542241.18,2542241.18,'571','2021-05-21 09:49:24','614','2021-05-21 10:32:27',10,0),('1','171',198687,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'571',1631514.39,1631514.39,'571','2021-05-21 14:01:05','614','2021-05-21 14:26:41',10,0),('1','171',198845,'AFTERNO0N SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'571',1391658.67,1391658.67,'571','2021-05-22 09:49:46','614','2021-05-22 11:18:36',10,0),('1','171',198907,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'571',1303494.15,1303494.15,'571','2021-05-22 13:40:03','614','2021-05-22 16:10:29',10,0),('1','171',199048,'AFTERNO0N SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'571',1284913.87,1284913.87,'571','2021-05-23 10:13:43','614','2021-05-23 13:14:02',10,0),('1','171',199116,'MORNING SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'571',1276688.69,1276688.69,'571','2021-05-23 13:58:29','614','2021-05-23 14:24:14',10,0),('1','171',199257,'AFTERNO0N SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'571',1214611.26,1214611.26,'571','2021-05-24 08:40:22','614','2021-05-24 10:36:18',10,0),('1','171',199358,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'571',1531094.36,1531094.36,'571','2021-05-24 13:55:19','614','2021-05-24 14:01:56',10,0),('1','171',199493,'AFTERNO0N SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'571',1731267.80,1731267.80,'571','2021-05-25 08:53:41','614','2021-05-25 12:12:45',10,0),('1','171',199566,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'571',1458198.75,1458198.75,'571','2021-05-25 13:35:40','614','2021-05-25 14:32:38',10,0),('1','171',199721,'AFTERNO0N SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'571',1662137.05,1662137.05,'571','2021-05-26 08:53:59','614','2021-05-26 09:08:18',10,0),('1','171',199797,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'571',1432123.56,1432123.56,'571','2021-05-26 13:55:47','614','2021-05-26 14:17:57',10,0),('1','171',199915,'AFTERNO0N SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'571',1304326.84,1304326.84,'571','2021-05-27 08:25:02','614','2021-05-27 10:02:01',10,0),('1','171',200027,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',200028,'CHANGE OF PRICE SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'571',437340.80,437340.80,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',200036,'MORNING SHIFT  1','2021-05-27','2021-05-27 00:00:00',NULL,'571',437340.80,437340.80,'571','2021-05-27 14:40:41','614','2021-05-27 14:41:37',10,0),('1','171',200037,'MORNING SHIFT  2','2021-05-27','2021-05-27 00:00:00',NULL,'571',1021783.31,1021783.31,'571','2021-05-27 14:46:56','614','2021-05-27 15:24:34',10,0),('1','171',200145,'AFTERNO0N SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'571',1290472.63,1290472.63,'571','2021-05-28 08:52:04','614','2021-05-28 13:10:02',10,0),('1','171',200223,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'571',1560904.49,1560904.49,'571','2021-05-28 14:04:08','614','2021-05-28 16:22:30',10,0),('1','171',200348,'AFTERNO0N SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'571',1730385.83,1730385.83,'571','2021-05-29 10:35:32','614','2021-05-29 11:33:53',10,0),('1','171',200414,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'571',844283.66,844283.66,'571','2021-05-29 14:28:27','614','2021-05-29 14:38:57',10,0),('1','171',200540,'AFTERNO0N SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'571',1265831.48,1265831.48,'571','2021-05-30 09:46:46','614','2021-05-30 09:53:09',10,0),('1','171',200606,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'571',837952.64,837952.64,'571','2021-05-30 13:47:21','614','2021-05-30 14:05:19',10,0),('1','171',200735,'AFTERNO0N SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'571',1440693.35,1440693.35,'571','2021-05-31 08:13:45','614','2021-05-31 09:15:07',10,0),('1','171',200816,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'571',1145575.25,1145575.25,'571','2021-05-31 13:32:44','614','2021-05-31 13:50:21',10,0),('1','171',200952,'AFTERNO0N SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'571',1406758.59,1406758.59,'571','2021-06-01 07:55:48','614','2021-06-01 11:24:57',10,0),('1','171',201035,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'571',679467.93,679467.93,'571','2021-06-01 13:56:17','614','2021-06-01 15:28:22',10,0),('1','171',201141,'AFTERNO0N SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'571',1753706.19,1753706.19,'571','2021-06-02 07:38:29','614','2021-06-02 11:25:19',10,0),('1','171',201225,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'571',1089851.51,1089851.51,'571','2021-06-02 13:19:57','614','2021-06-02 16:36:25',10,0),('1','171',201339,'AFTERNO0N SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'571',2032815.20,2032815.20,'571','2021-06-03 07:41:55','614','2021-06-03 12:36:49',10,0),('1','171',201429,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'571',1303817.00,1303817.00,'571','2021-06-03 14:02:25','614','2021-06-03 18:52:11',10,0),('1','171',201519,'AFTERNO0N SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'571',1172462.26,1172462.26,'571','2021-06-04 07:54:40','614','2021-06-04 08:48:31',10,0),('1','171',201615,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'571',911934.47,911934.47,'571','2021-06-04 14:29:32','614','2021-06-04 16:08:41',10,0),('1','171',201781,'AFTERNO0N SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'571',1213104.68,1213104.68,'571','2021-06-05 07:33:54','614','2021-06-05 08:33:15',10,0),('1','171',201903,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'571',834615.42,834615.42,'571','2021-06-05 13:30:43','614','2021-06-05 14:37:36',10,0),('1','171',202033,'AFTERNO0N SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'571',1056160.13,1056160.13,'571','2021-06-06 06:28:18','614','2021-06-06 07:15:05',10,0),('1','171',202122,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'571',857654.59,857654.59,'571','2021-06-06 13:35:37','614','2021-06-06 18:22:49',10,0),('1','171',202260,'AFTERNO0N SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'571',958296.56,958296.56,'571','2021-06-07 08:00:10','614','2021-06-07 11:48:17',10,0),('1','171',202339,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'571',1005188.40,1005188.40,'571','2021-06-07 13:06:33','614','2021-06-07 14:45:23',10,0),('1','171',202450,'AFTERNO0N SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'571',1168833.88,1168833.88,'571','2021-06-08 07:31:11','614','2021-06-08 10:37:53',10,0),('1','171',202540,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'571',897541.57,897541.57,'571','2021-06-08 13:29:24','614','2021-06-08 13:39:56',10,0),('1','171',202670,'AFTERNO0N SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'571',967310.46,967310.46,'571','2021-06-09 07:39:45','614','2021-06-09 12:29:22',10,0),('1','171',202759,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'571',781335.61,781335.61,'571','2021-06-09 13:10:44','614','2021-06-09 18:10:14',10,0),('1','171',202895,'AFTERNO0N SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'571',1028868.32,1028868.32,'571','2021-06-10 08:01:55','614','2021-06-10 09:32:42',10,0),('1','171',202990,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'571',952180.80,952180.80,'571','2021-06-10 13:14:59','614','2021-06-10 14:27:39',10,0),('1','171',203134,'AFTERNO0N SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'571',1252092.65,1252092.65,'571','2021-06-11 07:44:25','614','2021-06-11 10:24:48',10,0),('1','171',203220,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'571',1019706.81,1019706.81,'571','2021-06-11 13:52:14','614','2021-06-11 14:14:53',10,0),('1','171',203328,'AFTERNO0N SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'571',1668513.64,1668513.64,'571','2021-06-12 07:21:46','614','2021-06-12 09:34:09',10,0),('1','171',203428,'MORNING SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'571',361651.36,361651.36,'571','2021-06-12 13:34:02','614','2021-06-12 18:30:04',10,0),('1','171',203536,'AFTERNO0N SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'571',492889.18,492889.18,'571','2021-06-13 07:29:09','614','2021-06-13 12:49:28',10,0),('1','171',203635,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'571',820568.08,820568.08,'571','2021-06-13 13:47:21','614','2021-06-13 14:00:15',10,0),('1','171',203757,'AFTERNO0N SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'571',790131.09,790131.09,'571','2021-06-14 07:59:12','614','2021-06-14 08:25:32',10,0),('1','171',203857,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'571',873010.07,873010.07,'571','2021-06-14 13:19:27','614','2021-06-14 14:26:44',10,0),('1','171',204013,'AFTERNO0N SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'571',1124836.92,1124836.92,'571','2021-06-15 08:46:23','614','2021-06-15 11:26:10',10,0),('1','171',204089,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'571',932798.47,932798.47,'571','2021-06-15 13:39:39','614','2021-06-15 14:29:28',10,0),('1','171',204213,'AFTERNO0N SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'571',1138401.78,1138401.78,'571','2021-06-16 07:37:16','614','2021-06-16 08:54:10',10,0),('1','171',204312,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'571',915543.29,915543.29,'571','2021-06-16 13:35:20','614','2021-06-16 20:57:46',10,0),('1','171',204426,'AFTERNO0N SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'571',1246177.38,1246177.38,'571','2021-06-17 07:42:50','614','2021-06-17 08:01:12',10,0),('1','171',204525,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'571',740204.19,740204.19,'571','2021-06-17 13:17:34','614','2021-06-17 13:51:29',10,0),('1','171',204649,'AFTERNO0N SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'571',1118043.08,1118043.08,'571','2021-06-18 07:37:44','614','2021-06-18 10:37:05',10,0),('1','171',204734,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'571',966795.38,966795.38,'571','2021-06-18 13:48:49','614','2021-06-18 14:22:15',10,0),('1','171',204863,'AFTERNO0N SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'571',904227.83,904227.83,'571','2021-06-19 07:53:46','614','2021-06-19 09:32:51',10,0),('1','171',204954,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'571',143696.70,143696.70,'571','2021-06-19 12:58:48','614','2021-06-19 13:04:20',10,0),('1','171',205066,'AFTERNO0N SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'571',97043.40,97043.40,'571','2021-06-20 07:44:36','614','2021-06-20 08:42:59',10,0),('1','171',205131,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'571',53848.80,53848.80,'571','2021-06-20 12:36:10','614','2021-06-20 14:35:18',10,0),('1','171',205307,'AFTERNO0N SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'571',981444.52,981444.52,'571','2021-06-21 09:50:19','614','2021-06-21 10:36:34',10,0),('1','171',205352,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'571',1014310.59,1014310.59,'571','2021-06-21 13:22:16','426','2021-06-21 14:23:55',10,0),('1','171',205425,'AFTERNOON  1','2021-06-21','2021-06-21 00:00:00',NULL,'571',941535.90,941535.90,'571','2021-06-21 16:58:22','614','2021-06-22 05:18:43',10,0),('1','171',205502,'AFTERNO0N SHIFT 2','2021-06-21','2021-06-21 00:00:00',NULL,'571',1325546.02,1325546.02,'571','2021-06-22 07:40:32','614','2021-06-22 10:08:22',10,0),('1','171',205608,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'571',1118883.26,1118883.26,'571','2021-06-22 13:21:32','614','2021-06-22 14:57:24',10,0),('1','171',205697,'AFTERNO0N SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'571',1088203.45,1088203.45,'571','2021-06-23 07:56:22','614','2021-06-23 08:12:42',10,0),('1','171',205772,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'571',967821.54,967821.54,'571','2021-06-23 13:24:04','614','2021-06-23 14:45:53',10,0),('1','171',205905,'AFTERNO0N SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'571',1345612.08,1345612.08,'571','2021-06-24 07:41:58','614','2021-06-24 13:49:57',10,0),('1','171',206067,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'571',1064765.08,1064765.08,'571','2021-06-24 14:07:09','614','2021-06-24 14:38:31',10,0),('1','171',206139,'AFTERNOON ','2021-06-24','2021-06-24 00:00:00',NULL,'571',1482628.03,1482628.03,'571','2021-06-25 07:24:14','614','2021-06-25 09:33:26',10,0),('1','171',206274,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'571',1244245.11,1244245.11,'571','2021-06-25 13:59:34','614','2021-06-25 14:10:39',10,0),('1','171',206383,'AFTERNO0N SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'571',1511373.21,1511373.21,'571','2021-06-26 08:11:08','614','2021-06-26 08:58:01',10,0),('1','171',206485,'MORNING SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'571',910786.39,910786.39,'571','2021-06-26 13:37:25','614','2021-06-26 14:38:10',10,0),('1','171',206591,'AFTERNO0N SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'571',1220811.43,1220811.43,'571','2021-06-27 07:37:20','614','2021-06-27 07:39:51',10,0),('1','171',206600,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'571',1035193.35,1035193.35,'571','2021-06-27 13:26:10','614','2021-06-27 15:11:41',10,0),('1','171',206817,'AFTERNO0N SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'571',1092633.73,1092633.73,'571','2021-06-28 07:08:05','614','2021-06-28 09:29:18',10,0),('1','171',206940,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'571',1054936.85,1054936.85,'571','2021-06-28 13:31:12','614','2021-06-28 14:08:47',10,0),('1','171',207030,'AFTERNO0N SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'571',1331400.36,1331400.36,'571','2021-06-29 06:52:48','614','2021-06-29 09:03:07',10,0),('1','171',207151,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'571',874554.93,874554.93,'571','2021-06-29 13:19:59','614','2021-06-29 13:25:46',10,0),('1','171',207158,'AFTERNO0N SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',207243,'AFTERNO0N SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'571',1156173.67,1156173.67,'571','2021-06-30 06:12:00','614','2021-06-30 07:57:30',10,0),('1','171',207379,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'571',755961.40,755961.40,'571','2021-06-30 13:53:02','614','2021-06-30 14:02:17',10,0),('1','171',207496,'AFTERNO0N SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'571',1166688.80,1166688.80,'571','2021-07-01 07:40:57','614','2021-07-01 08:56:51',10,0),('1','171',207600,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'571',713688.98,713688.98,'571','2021-07-01 13:29:45','614','2021-07-01 14:20:15',10,0),('1','171',207730,'AFTERNO0N SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'571',1293735.10,1293735.10,'571','2021-07-02 07:34:27','614','2021-07-02 09:02:59',10,0),('1','171',207816,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'571',696844.56,696844.56,'571','2021-07-02 13:29:02','614','2021-07-02 20:11:21',10,0),('1','171',207930,'AFTERNO0N SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'571',1300048.88,1300048.88,'571','2021-07-03 07:39:49','614','2021-07-03 09:22:40',10,0),('1','171',208037,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'571',772954.15,772954.15,'571','2021-07-03 13:54:03','614','2021-07-03 13:55:24',10,0),('1','171',208124,'AFTERNO0N SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'571',1031780.22,1031780.22,'571','2021-07-04 07:27:24','614','2021-07-04 13:14:23',10,0),('1','171',208238,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'571',704911.43,704911.43,'571','2021-07-04 13:30:38','614','2021-07-04 18:36:08',10,0),('1','171',208321,'AFTERNO0N SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'571',865564.23,865564.23,'571','2021-07-05 06:18:38','614','2021-07-05 07:39:34',10,0),('1','171',208459,'MORNING SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'571',760337.95,760337.95,'571','2021-07-05 13:13:28','614','2021-07-05 13:46:19',10,0),('1','171',208559,'AFTERNO0N SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'571',1302585.16,1302585.16,'571','2021-07-06 08:02:55','614','2021-07-06 10:37:49',10,0),('1','171',208672,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'571',724401.34,724401.34,'571','2021-07-06 16:56:11','614','2021-07-06 21:02:51',10,0),('1','171',208779,'AFTERNO0N SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'571',1158665.94,1158665.94,'571','2021-07-07 07:27:55','426','2021-07-07 12:43:36',10,0),('1','171',208904,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'571',878547.18,878547.18,'571','2021-07-07 13:36:14','614','2021-07-07 14:41:49',10,0),('1','171',209012,'AFTERNO0N SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'571',1364658.82,1364658.82,'571','2021-07-08 07:22:21','614','2021-07-08 09:12:39',10,0),('1','171',209124,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'571',739695.63,739695.63,'571','2021-07-08 13:48:57','614','2021-07-08 14:50:17',10,0),('1','171',209236,'AFTERNO0N SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'571',1184361.26,1184361.26,'571','2021-07-09 07:37:57','614','2021-07-09 11:02:03',10,0),('1','171',209358,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'571',785736.61,785736.61,'571','2021-07-09 14:53:56','614','2021-07-09 15:25:36',10,0),('1','171',209458,'AFTERNO0N SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'571',1293342.86,1293342.86,'571','2021-07-10 07:39:18','426','2021-07-10 13:47:09',10,0),('1','171',209587,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'571',853997.93,853997.93,'571','2021-07-10 16:01:49','614','2021-07-10 17:10:38',10,0),('1','171',209659,'AFTERNO0N SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'571',1362419.18,1362419.18,'571','2021-07-11 07:31:53','614','2021-07-11 11:03:06',10,0),('1','171',209765,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'571',542866.84,542866.84,'571','2021-07-11 13:42:28','614','2021-07-11 14:29:36',10,0),('1','171',209868,'AFTERNO0N SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'571',1060558.54,1060558.54,'571','2021-07-12 06:30:45','614','2021-07-12 09:33:00',10,0),('1','171',210002,'MORNING SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'571',1435771.71,1435771.71,'571','2021-07-12 13:34:24','614','2021-07-12 14:20:28',10,0),('1','171',210122,'AFTERNO0N SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'571',1279438.46,1279438.46,'571','2021-07-13 07:28:58','614','2021-07-13 08:51:07',10,0),('1','171',210231,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'571',903798.42,903798.42,'571','2021-07-13 14:13:48','614','2021-07-13 14:48:29',10,0),('1','171',210327,'AFTERNO0N SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'571',1262386.99,1262386.99,'571','2021-07-14 07:22:09','614','2021-07-14 09:00:19',10,0),('1','171',210430,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'571',991310.91,991310.91,'571','2021-07-14 14:10:51','614','2021-07-14 14:25:04',10,0),('1','171',210517,'AFTERNO0N SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'571',1365669.00,1365669.00,'571','2021-07-15 06:50:42','614','2021-07-15 09:45:31',10,0),('1','171',210677,'MORNING SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'571',844302.02,844302.02,'571','2021-07-15 16:15:19','614','2021-07-15 23:01:07',10,0),('1','171',210734,'AFTERNO0N SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'571',1361416.33,1361416.33,'571','2021-07-16 06:53:59','614','2021-07-16 07:46:35',10,0),('1','171',210856,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'571',789102.51,789102.51,'571','2021-07-16 13:38:21','614','2021-07-16 17:32:05',10,0),('1','171',210955,'AFTERNO0N SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'571',1506780.76,1506780.76,'571','2021-07-17 06:51:54','426','2021-07-17 13:35:13',10,0),('1','171',211060,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'571',704432.61,704432.61,'571','2021-07-17 13:42:41','614','2021-07-17 17:40:55',10,0),('1','171',211177,'AFTERNO0N SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'571',1334777.61,1334777.61,'571','2021-07-18 06:52:32','614','2021-07-18 10:21:52',10,0),('1','171',211262,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'571',754802.97,754802.97,'571','2021-07-18 13:25:35','614','2021-07-18 20:53:58',10,0),('1','171',211373,'AFTERNO0N SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'571',1105799.14,1105799.14,'571','2021-07-19 06:20:27','614','2021-07-19 08:20:51',10,0),('1','171',211492,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'571',999842.92,999842.92,'571','2021-07-19 13:04:03','614','2021-07-19 13:22:29',10,0),('1','171',211598,'AFTERNO0N SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'571',1676690.04,1676690.04,'571','2021-07-20 06:00:54','614','2021-07-20 10:27:14',10,0),('1','171',211645,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'571',662194.96,662194.96,'571','2021-07-20 13:20:26','614','2021-07-20 13:57:47',10,0),('1','171',211786,'AFTERNO0N SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'571',974429.14,974429.14,'571','2021-07-21 07:01:33','614','2021-07-21 12:23:05',10,0),('1','171',211879,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'571',429799.41,429799.41,'571','2021-07-21 13:02:32','614','2021-07-21 13:11:16',10,0),('1','171',211977,'AFTERNO0N SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'571',945487.93,945487.93,'571','2021-07-22 05:30:12','614','2021-07-22 07:42:48',10,0),('1','171',212086,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'571',814212.65,814212.65,'571','2021-07-22 13:09:25','614','2021-07-22 16:25:49',10,0),('1','171',212236,'AFTERNO0N SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'571',1518298.57,1518298.57,'571','2021-07-23 07:01:07','614','2021-07-23 07:24:04',10,0),('1','171',212335,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'571',668407.07,668407.07,'571','2021-07-23 13:56:07','614','2021-07-23 14:08:24',10,0),('1','171',212461,'AFTERNO0N SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'571',1344233.87,1344233.87,'571','2021-07-24 07:02:19','614','2021-07-24 09:38:38',10,0),('1','171',212550,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'571',769885.17,769885.17,'571','2021-07-24 13:29:17','614','2021-07-24 22:24:45',10,0),('1','171',212680,'AFTERNO0N SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'571',1455472.43,1455472.43,'571','2021-07-25 07:12:58','614','2021-07-25 10:53:17',10,0),('1','171',212766,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'571',617343.98,617343.98,'571','2021-07-25 13:18:17','614','2021-07-25 21:00:21',10,0),('1','171',212872,'AFTERNO0N SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'571',1060609.91,1060609.91,'571','2021-07-26 06:26:47','614','2021-07-26 10:18:56',10,0),('1','171',213004,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'571',472953.92,472953.92,'571','2021-07-26 13:22:35','614','2021-07-26 15:58:26',10,0),('1','171',213145,'AFTERNO0N SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'571',68796.70,68796.70,'571','2021-07-27 07:21:57','614','2021-07-27 07:45:19',10,0),('1','171',213269,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'571',325699.00,325699.00,'571','2021-07-27 12:32:26','614','2021-07-27 15:33:07',10,0),('1','171',213408,'AFTERNO0N SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'571',259834.20,259834.20,'571','2021-07-28 07:28:20','614','2021-07-28 14:51:09',10,0),('1','171',213557,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'571',119039.20,119039.20,'571','2021-07-28 15:12:17','614','2021-07-28 16:26:41',10,0),('1','171',213637,'AFTERNO0N SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'571',1519473.14,1519473.14,'571','2021-07-29 08:56:23','614','2021-07-29 09:05:38',10,0),('1','171',213760,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'571',872975.58,872975.58,'571','2021-07-29 13:27:15','614','2021-07-29 16:35:25',10,0),('1','171',213893,'AFTERNO0N SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'571',1468495.01,1468495.01,'571','2021-07-30 06:45:23','614','2021-07-30 10:07:28',10,0),('1','171',214070,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'571',1260567.10,1260567.10,'571','2021-07-30 20:05:02','614','2021-07-30 20:07:29',10,0),('1','171',214099,'AFTERNO0N SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'571',1358279.79,1358279.79,'571','2021-07-31 06:48:22','614','2021-07-31 12:03:44',10,0),('1','171',214213,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'571',766744.78,766744.78,'571','2021-07-31 13:23:04','614','2021-07-31 17:14:26',10,0),('1','171',214343,'AFTERNO0N SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'571',1169799.58,1169799.58,'571','2021-08-01 07:03:59','614','2021-08-01 11:23:30',10,0),('1','171',214449,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'571',885640.46,885640.46,'571','2021-08-01 15:15:30','614','2021-08-01 15:33:25',10,0),('1','171',214537,'AFTERNO0N SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'571',1117395.67,1117395.67,'571','2021-08-02 06:46:50','614','2021-08-02 11:06:42',10,0),('1','171',214680,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'571',1168504.50,1168504.50,'571','2021-08-02 13:30:45','614','2021-08-02 15:44:10',10,0),('1','171',214788,'AFTERNO0N SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'571',1229080.17,1229080.17,'571','2021-08-03 07:01:36','614','2021-08-03 08:17:32',10,0),('1','171',214908,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'571',1503088.93,1503088.93,'571','2021-08-03 13:30:42','614','2021-08-03 21:51:01',10,0),('1','171',215015,'AFTERNO0N SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'571',1159834.66,1159834.66,'571','2021-08-04 07:02:57','614','2021-08-04 12:22:39',10,0),('1','171',215136,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'571',1020116.20,1020116.20,'571','2021-08-04 14:02:18','614','2021-08-05 02:52:11',10,0),('1','171',215234,'AFTERNO0N SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'571',1337765.63,1337765.63,'571','2021-08-05 06:58:26','614','2021-08-05 10:40:51',10,0),('1','171',215352,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'571',966227.93,966227.93,'571','2021-08-05 13:24:34','614','2021-08-05 15:12:57',10,0),('1','171',215451,'AFTERNO0N SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'571',1437252.25,1437252.25,'571','2021-08-06 06:58:44','614','2021-08-06 10:30:51',10,0),('1','171',215588,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'571',1025410.46,1025410.46,'571','2021-08-06 14:31:36','614','2021-08-06 14:37:19',10,0),('1','171',215683,'AFTERNO0N SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'571',1516186.45,1516186.45,'571','2021-08-07 07:04:45','614','2021-08-07 07:40:24',10,0),('1','171',215797,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'571',1010349.91,1010349.91,'571','2021-08-07 13:35:11','614','2021-08-07 15:55:47',10,0),('1','171',215914,'AFTERNO0N SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'571',1172632.13,1172632.13,'571','2021-08-08 07:07:10','614','2021-08-08 13:40:12',10,0),('1','171',216042,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'571',812280.71,812280.71,'571','2021-08-08 16:33:00','614','2021-08-08 19:25:55',10,0),('1','171',216100,'AFTERNO0N SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'571',1266101.23,1266101.23,'571','2021-08-09 06:23:55','614','2021-08-09 08:49:14',10,0),('1','171',216243,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'571',922334.84,922334.84,'571','2021-08-09 13:43:17','614','2021-08-09 17:20:10',10,0),('1','171',216338,'AFTERNO0N SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'571',1235353.42,1235353.42,'571','2021-08-10 07:03:29','614','2021-08-10 09:59:20',10,0),('1','171',216451,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'571',761250.18,761250.18,'571','2021-08-10 12:59:48','426','2021-08-10 14:44:13',10,0),('1','171',216567,'AFTERNO0N SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'571',1288987.47,1288987.47,'571','2021-08-11 07:03:58','614','2021-08-11 13:02:36',10,0),('1','171',216679,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'571',761740.52,761740.52,'571','2021-08-11 13:37:15','614','2021-08-11 15:22:13',10,0),('1','171',216798,'AFTERNO0N SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'571',1058533.41,1058533.41,'571','2021-08-12 07:02:38','614','2021-08-12 07:22:06',10,0),('1','171',216913,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'571',777648.55,777648.55,'571','2021-08-12 13:21:44','614','2021-08-12 15:08:53',10,0),('1','171',217027,'AFTERNO0N SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'571',1235341.14,1235341.14,'571','2021-08-13 07:07:49','614','2021-08-13 10:54:47',10,0),('1','171',217141,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'571',1034539.23,1034539.23,'571','2021-08-13 14:45:41','614','2021-08-13 16:12:09',10,0),('1','171',217302,'AFTERNO0N SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'571',1474730.29,1474730.29,'571','2021-08-14 07:39:31','614','2021-08-14 18:33:06',10,0),('1','171',217513,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'571',541255.70,541255.70,'571','2021-08-15 07:01:24','614','2021-08-15 15:08:03',10,0),('1','171',217644,'AFTERNO0N SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'571',170275.90,170275.90,'571','2021-08-15 18:25:09','614','2021-08-15 21:27:44',10,0),('1','171',217721,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'571',125328.70,125328.70,'571','2021-08-16 07:00:49','614','2021-08-16 08:10:36',10,0),('1','171',217814,'AFTERNO0N SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'571',165156.22,165156.22,'571','2021-08-16 10:27:26','614','2021-08-16 11:34:55',10,0),('1','171',217927,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'571',108892.10,108892.10,'571','2021-08-16 16:19:21','614','2021-08-16 21:23:40',10,0),('1','171',217970,'AFTERNO0N SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'571',7000.60,7000.60,'571','2021-08-17 05:26:08','614','2021-08-17 07:04:04',10,0),('1','171',218138,'MORNING SHIFT  1','2021-08-17','2021-08-17 00:00:00',NULL,'571',62289.10,62289.10,'571','2021-08-17 14:36:16','614','2021-08-17 17:33:33',10,0),('1','171',218177,'MORNING SHIFT  2','2021-08-17','2021-08-17 00:00:00',NULL,'571',619875.00,619875.00,'571','2021-08-17 18:34:18','614','2021-08-17 22:32:32',10,0),('1','171',218236,'AFTERNO0N SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'571',213789.90,213789.90,'571','2021-08-18 07:05:36','614','2021-08-18 14:44:51',10,0),('1','171',218383,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'571',371138.46,371138.46,'571','2021-08-18 14:58:47','614','2021-08-18 23:11:56',10,0),('1','171',218465,'AFTERNO0N SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'571',1051691.13,1051691.13,'571','2021-08-19 07:12:43','614','2021-08-19 10:52:33',10,0),('1','171',218575,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'571',824701.95,824701.95,'571','2021-08-19 14:33:08','614','2021-08-19 14:54:49',10,0),('1','171',218701,'AFTERNO0N SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'571',1272513.54,1272513.54,'571','2021-08-20 07:18:45','614','2021-08-20 13:38:50',10,0),('1','171',218816,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'571',686464.98,686464.98,'571','2021-08-20 13:46:17','614','2021-08-20 15:04:07',10,0),('1','171',218923,'AFTERNO0N SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'571',1137152.70,1137152.70,'571','2021-08-21 07:32:02','614','2021-08-21 11:12:16',10,0),('1','171',219018,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'571',835701.75,835701.75,'571','2021-08-21 13:11:43','614','2021-08-21 13:56:26',10,0),('1','171',219137,'AFTERNO0N SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'571',1190640.90,1190640.90,'571','2021-08-22 07:25:13','614','2021-08-22 13:10:51',10,0),('1','171',219239,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'571',491554.26,491554.26,'571','2021-08-22 13:44:41','614','2021-08-22 17:26:48',10,0),('1','171',219348,'AFTERNO0N SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'571',1349299.65,1349299.65,'571','2021-08-23 07:02:54','614','2021-08-23 12:48:03',10,0),('1','171',219489,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'571',942238.20,942238.20,'571','2021-08-23 13:21:41','614','2021-08-23 15:46:35',10,0),('1','171',219616,'AFTERNO0N SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'571',1644947.94,1644947.94,'571','2021-08-24 07:15:24','614','2021-08-24 14:31:11',10,0),('1','171',219755,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'571',739380.06,739380.06,'571','2021-08-24 15:49:11','614','2021-08-24 16:18:16',10,0),('1','171',219833,'AFTERNO0N SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'571',1239461.46,1239461.46,'571','2021-08-25 07:28:14','614','2021-08-25 08:02:10',10,0),('1','171',219952,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'571',890631.93,890631.93,'571','2021-08-25 13:32:25','614','2021-08-25 14:19:19',10,0),('1','171',220059,'AFTERNO0N SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'571',1332945.84,1332945.84,'571','2021-08-26 07:28:35','614','2021-08-26 09:11:10',10,0),('1','171',220155,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'571',727873.68,727873.68,'571','2021-08-26 13:24:42','614','2021-08-26 15:16:09',10,0),('1','171',220268,'AFTERNO0N SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'571',1675208.88,1675208.88,'571','2021-08-27 07:26:44','614','2021-08-27 08:13:40',10,0),('1','171',220384,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'571',784365.36,784365.36,'571','2021-08-27 14:47:36','614','2021-08-27 17:04:47',10,0),('1','171',220486,'AFTERNO0N SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'571',1514814.48,1514814.48,'571','2021-08-28 07:56:45','614','2021-08-28 12:40:34',10,0),('1','171',220594,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'571',670916.58,670916.58,'571','2021-08-28 13:37:04','614','2021-08-28 15:13:51',10,0),('1','171',220703,'AFTERNO0N SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'571',1490928.54,1490928.54,'571','2021-08-29 07:38:54','614','2021-08-29 10:04:40',10,0),('1','171',220800,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'571',584888.52,584888.52,'571','2021-08-29 13:19:55','614','2021-08-29 14:21:55',10,0),('1','171',220879,'AFTERNO0N SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'571',1459873.38,1459873.38,'571','2021-08-30 06:24:45','614','2021-08-30 09:34:36',10,0),('1','171',221054,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'571',1715038.41,1715038.41,'571','2021-08-30 13:30:22','614','2021-08-31 05:39:50',10,0),('1','171',221164,'AFTERNO0N SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'571',1267358.82,1267358.82,'571','2021-08-31 07:13:45','614','2021-08-31 12:10:14',10,0),('1','171',221284,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'571',946409.76,946409.76,'571','2021-08-31 13:33:33','614','2021-08-31 14:51:47',10,0),('1','171',221414,'AFTERNO0N SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'571',1469721.60,1469721.60,'571','2021-09-01 07:23:55','614','2021-09-01 13:52:32',10,0),('1','171',221556,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'571',477868.77,477868.77,'571','2021-09-01 16:24:57','614','2021-09-01 16:27:14',10,0),('1','171',221633,'AFTERNO0N SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'571',1452575.25,1452575.25,'571','2021-09-02 07:18:19','614','2021-09-02 13:36:45',10,0),('1','171',221762,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'571',814387.62,814387.62,'571','2021-09-02 14:59:31','614','2021-09-02 20:20:28',10,0),('1','171',221849,'AFTERNO0N SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'571',1654058.40,1654058.40,'571','2021-09-03 07:25:31','614','2021-09-03 14:24:26',10,0),('1','171',221983,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'571',750141.42,750141.42,'571','2021-09-03 15:00:20','614','2021-09-03 15:28:08',10,0),('1','171',222076,'AFTERNO0N SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'571',1756613.52,1756613.52,'571','2021-09-04 07:35:03','614','2021-09-04 09:51:17',10,0),('1','171',222173,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'571',761562.45,761562.45,'571','2021-09-04 13:42:42','614','2021-09-04 19:46:21',10,0),('1','171',222268,'AFTERNO0N SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'571',1214516.07,1214516.07,'571','2021-09-05 06:35:49','614','2021-09-05 07:08:48',10,0),('1','171',222384,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'571',535354.23,535354.23,'571','2021-09-05 13:25:14','614','2021-09-05 14:52:42',10,0),('1','171',222483,'AFTERNO0N SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'571',1216138.95,1216138.95,'571','2021-09-06 06:14:25','614','2021-09-06 06:51:35',10,0),('1','171',222644,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'571',866307.51,866307.51,'571','2021-09-06 14:24:32','614','2021-09-06 15:05:16',10,0),('1','171',222740,'AFTERNO0N SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'571',1477411.74,1477411.74,'571','2021-09-07 07:23:16','614','2021-09-07 08:49:30',10,0),('1','171',222839,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'571',879850.17,879850.17,'571','2021-09-07 13:00:50','614','2021-09-07 15:13:43',10,0),('1','171',222939,'AFTERNO0N SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'571',1447107.27,1447107.27,'571','2021-09-08 06:37:47','614','2021-09-08 10:08:23',10,0),('1','171',223080,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'571',684619.20,684619.20,'571','2021-09-08 14:09:28','614','2021-09-08 14:23:12',10,0),('1','171',223185,'AFTERNO0N SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'571',1830786.39,1830786.39,'571','2021-09-09 06:50:21','614','2021-09-09 08:02:07',10,0),('1','171',223307,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'571',763228.11,763228.11,'571','2021-09-09 13:21:23','614','2021-09-09 18:54:21',10,0),('1','171',223422,'AFTERNO0N SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'571',1538364.06,1538364.06,'571','2021-09-10 06:57:58','614','2021-09-10 13:10:40',10,0),('1','171',223537,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'571',960818.04,960818.04,'571','2021-09-10 13:47:30','614','2021-09-11 06:41:17',10,0),('1','171',223650,'AFTERNO0N SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'571',1036642.59,1036642.59,'571','2021-09-11 07:02:19','614','2021-09-11 07:36:11',10,0),('1','171',223761,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'571',296993.43,296993.43,'571','2021-09-11 12:19:29','614','2021-09-11 14:17:20',10,0),('1','171',223885,'AFTERNO0N SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'571',913484.37,913484.37,'571','2021-09-12 07:26:34','614','2021-09-12 10:40:47',10,0),('1','171',223961,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'571',581381.76,581381.76,'571','2021-09-12 13:18:01','614','2021-09-12 15:52:08',10,0),('1','171',224072,'AFTERNO0N SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'571',1460121.09,1460121.09,'571','2021-09-13 05:58:28','614','2021-09-13 08:39:22',10,0),('1','171',224228,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'571',900852.33,900852.33,'571','2021-09-13 13:19:07','614','2021-09-13 17:18:33',10,0),('1','171',224315,'AFTERNO0N SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'571',1297631.49,1297631.49,'571','2021-09-14 06:58:43','614','2021-09-14 07:46:38',10,0),('1','171',224438,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'571',767482.89,767482.89,'571','2021-09-14 13:16:22','614','2021-09-14 14:56:28',10,0),('1','171',224536,'AFTERNO0N SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'571',1354734.18,1354734.18,'571','2021-09-15 07:00:31','614','2021-09-15 08:53:15',10,0),('1','171',224677,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'571',871189.50,871189.50,'571','2021-09-15 13:25:43','614','2021-09-15 16:31:01',10,0),('1','171',224793,'AFTERNO0N SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'571',1775847.96,1775847.96,'571','2021-09-16 07:07:02','614','2021-09-16 10:28:01',10,0),('1','171',224914,'MORNING SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'571',918326.13,918326.13,'571','2021-09-16 13:14:46','614','2021-09-16 15:02:30',10,0),('1','171',225028,'AFTERNO0N SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'571',1593835.29,1593835.29,'571','2021-09-17 06:58:45','614','2021-09-17 10:04:30',10,0),('1','171',225175,'MORNING SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'571',602226.69,602226.69,'571','2021-09-17 14:45:58','614','2021-09-17 15:24:40',10,0),('1','171',225277,'AFTERNO0N SHIFT 1','2021-09-17','2021-09-17 00:00:00',NULL,'571',16250.70,16250.70,'571','2021-09-18 07:00:31','614','2021-09-18 08:07:54',10,0),('1','171',225355,'AFTERNO0N SHIFT 2','2021-09-17','2021-09-17 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',225362,'AFTERNO0N SHIFT 2','2021-09-17','2021-09-17 00:00:00',NULL,'571',1493117.98,1493117.98,'571','2021-09-18 11:07:11','614','2021-09-18 11:14:24',10,0),('1','171',225371,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'571',708568.08,708568.08,'571','2021-09-18 12:46:42','614','2021-09-18 16:20:34',10,0),('1','171',225492,'AFTERNO0N SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'571',1162711.38,1162711.38,'571','2021-09-19 07:10:56','614','2021-09-19 10:21:21',10,0),('1','171',225591,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'571',506549.70,506549.70,'571','2021-09-19 13:20:52','614','2021-09-19 14:56:54',10,0),('1','171',225691,'AFTERNO0N SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'571',1291101.12,1291101.12,'571','2021-09-20 06:06:45','614','2021-09-20 09:18:30',10,0),('1','171',225857,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'571',632786.58,632786.58,'571','2021-09-20 13:02:15','614','2021-09-20 15:54:29',10,0),('1','171',225961,'AFTERNO0N SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'571',1300582.98,1300582.98,'571','2021-09-21 05:03:38','614','2021-09-21 06:33:18',10,0),('1','171',226088,'MORNING SHIFT  1','2021-09-21','2021-09-21 00:00:00',NULL,'571',104400.00,104400.00,'571','2021-09-21 11:10:44','614','2021-09-21 11:56:36',10,0),('1','171',226120,'MORNING SHIFT  2','2021-09-21','2021-09-21 00:00:00',NULL,'571',576016.92,576016.92,'571','2021-09-21 13:08:30','614','2021-09-21 13:34:18',10,0),('1','171',226299,'AFTERNOON ','2021-09-22','2021-09-22 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',226304,'AFTERNO0N SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'571',1304704.26,1304704.26,'571','2021-09-22 10:16:49','614','2021-09-22 11:00:12',10,0),('1','171',226369,'MORNING SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'571',546611.90,546611.90,'571','2021-09-22 13:17:29','614','2021-09-22 14:59:55',10,0),('1','171',226488,'AFTERNO0N SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'571',1254396.78,1254396.78,'571','2021-09-23 07:02:36','614','2021-09-23 07:28:30',10,0),('1','171',226609,'MORNING SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'571',547419.06,547419.06,'571','2021-09-23 12:51:33','614','2021-09-23 15:53:06',10,0),('1','171',226740,'AFTERNO0N SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'571',1103432.22,1103432.22,'571','2021-09-24 06:39:37','614','2021-09-24 10:25:05',10,0),('1','171',226867,'MORNING SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'571',522163.26,522163.26,'571','2021-09-24 13:43:48','614','2021-09-24 14:27:19',10,0),('1','171',226973,'AFTERNO0N SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'571',1389837.05,1389837.05,'571','2021-09-25 07:11:08','614','2021-09-25 15:23:31',10,0),('1','171',227129,'MORNING SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'571',580196.87,580196.87,'571','2021-09-25 15:39:44','614','2021-09-25 15:45:51',10,0),('1','171',227195,'AFTERNO0N SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'571',1512150.52,1512150.52,'571','2021-09-26 07:13:09','614','2021-09-26 07:46:38',10,0),('1','171',227315,'MORNING SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'571',831865.46,831865.46,'571','2021-09-26 15:19:02','614','2021-09-26 18:13:11',10,0),('1','171',227374,'AFTERNO0N SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'571',1149186.25,1149186.25,'571','2021-09-27 06:14:06','614','2021-09-27 09:53:35',10,0),('1','171',227517,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'571',763222.34,763222.34,'571','2021-09-27 13:15:44','614','2021-09-27 14:22:21',10,0),('1','171',227609,'AFTERNO0N SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'571',1792085.91,1792085.91,'571','2021-09-28 06:23:03','614','2021-09-28 11:53:42',10,0),('1','171',227742,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'571',715387.85,715387.85,'571','2021-09-28 13:11:30','614','2021-09-28 13:47:13',10,0),('1','171',227780,'AFTERNO0N SHIFT 1','2021-09-28','2021-09-28 00:00:00',NULL,'571',133298.70,133298.70,'571','2021-09-28 14:31:03','614','2021-09-28 15:37:14',10,0),('1','171',227862,'AFTERNO0N SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'571',1293013.02,1293013.02,'571','2021-09-29 07:02:08','614','2021-09-29 10:31:45',10,0),('1','171',227995,'MORNING SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'571',754225.26,754225.26,'571','2021-09-29 13:24:02','614','2021-09-29 18:13:27',10,0),('1','171',228128,'AFTERNO0N SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'571',1413306.66,1413306.66,'571','2021-09-30 07:06:45','614','2021-09-30 07:19:10',10,0),('1','171',228237,'MORNING SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'571',703929.06,703929.06,'571','2021-09-30 13:20:30','614','2021-09-30 15:16:55',10,0),('1','171',228360,'AFTERNO0N SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'571',1417638.72,1417638.72,'571','2021-10-01 07:08:34','614','2021-10-01 10:04:14',10,0),('1','171',228458,'MORNING SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'571',647491.44,647491.44,'571','2021-10-01 13:56:39','614','2021-10-01 20:46:30',10,0),('1','171',228546,'AFTERNO0N SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'571',1309158.18,1309158.18,'571','2021-10-02 07:21:33','614','2021-10-02 08:45:59',10,0),('1','171',228622,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'571',596414.04,596414.04,'571','2021-10-02 13:09:50','614','2021-10-02 18:51:52',10,0),('1','171',228763,'AFTERNO0N SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'571',1579707.30,1579707.30,'571','2021-10-03 07:16:07','614','2021-10-03 12:21:13',10,0),('1','171',228851,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'571',696536.10,696536.10,'571','2021-10-03 13:13:51','614','2021-10-03 16:00:10',10,0),('1','171',228973,'AFTERNO0N SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'571',1202049.72,1202049.72,'571','2021-10-04 07:55:18','614','2021-10-04 08:25:35',10,0),('1','171',229054,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'571',1097750.10,1097750.10,'571','2021-10-04 13:29:34','614','2021-10-04 18:21:26',10,0),('1','171',229188,'AFTERNO0N SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'571',1168545.96,1168545.96,'571','2021-10-05 07:16:35','614','2021-10-05 13:52:04',10,0),('1','171',229314,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'571',484204.62,484204.62,'571','2021-10-05 13:57:15','614','2021-10-05 15:42:44',10,0),('1','171',229361,'AFTERNO0N SHIFT 1','2021-10-05','2021-10-05 00:00:00',NULL,'571',30000.00,30000.00,'571','2021-10-05 15:58:36','614','2021-10-05 19:48:55',10,0),('1','171',229430,'AFTERNO0N SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'571',1653279.00,1653279.00,'571','2021-10-06 07:26:19','614','2021-10-06 09:39:28',10,0),('1','171',229572,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'571',761889.92,761889.92,'571','2021-10-06 13:20:23','614','2021-10-06 14:13:26',10,0),('1','171',229673,'AFTERNO0N SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'571',1928903.80,1928903.80,'571','2021-10-07 07:13:38','614','2021-10-07 08:49:15',10,0),('1','171',229779,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'571',650828.96,650828.96,'571','2021-10-07 13:26:45','614','2021-10-07 16:28:54',10,0),('1','171',229900,'AFTERNO0N SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'571',1790427.80,1790427.80,'571','2021-10-08 07:05:33','614','2021-10-08 09:40:27',10,0),('1','171',229999,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'571',1214089.92,1214089.92,'571','2021-10-08 13:54:40','614','2021-10-08 15:53:17',10,0),('1','171',230090,'AFTERNO0N SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'571',1444767.16,1444767.16,'571','2021-10-09 06:19:52','614','2021-10-09 16:20:32',10,0),('1','171',230238,'MORNING SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'571',776367.94,776367.94,'571','2021-10-09 16:50:25','614','2021-10-09 17:04:15',10,0),('1','171',230251,'AFTERNO0N SHIFT 1','2021-10-09','2021-10-09 00:00:00',NULL,'571',179108.70,179108.70,'571','2021-10-09 18:29:19','614','2021-10-09 22:17:36',10,0),('1','171',230302,'AFTERNO0N SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'571',1266113.96,1266113.96,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',230342,'AFTERNO0N SHIFT 2','2021-10-09','2021-10-09 00:00:00',NULL,'571',1266113.96,1266113.96,'571','2021-10-10 09:17:36','614','2021-10-10 09:55:10',10,0),('1','171',230415,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'571',726069.34,726069.34,'571','2021-10-10 13:28:14','614','2021-10-10 14:21:41',10,0),('1','171',230521,'AFTERNO0N SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'571',1265939.10,1265939.10,'571','2021-10-11 06:05:55','614','2021-10-11 07:34:23',10,0),('1','171',230652,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'571',708421.24,708421.24,'571','2021-10-11 13:28:28','614','2021-10-11 14:18:51',10,0),('1','171',230801,'AFTERNO0N SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'571',1524121.88,1524121.88,'571','2021-10-12 07:13:08','614','2021-10-12 08:33:50',10,0),('1','171',230940,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'571',713867.98,713867.98,'571','2021-10-12 13:30:04','614','2021-10-12 13:54:19',10,0),('1','171',231079,'AFTERNO0N SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'571',1245610.36,1245610.36,'571','2021-10-13 07:21:56','614','2021-10-13 08:26:33',10,0),('1','171',231210,'MORNING SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'571',804277.32,804277.32,'571','2021-10-13 13:22:37','614','2021-10-13 14:23:54',10,0),('1','171',231397,'AFTERNO0N SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'571',1638166.40,1638166.40,'571','2021-10-14 07:12:28','614','2021-10-14 14:10:35',10,0),('1','171',231544,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'571',1107694.70,1107694.70,'571','2021-10-14 14:51:27','614','2021-10-15 00:21:50',10,0),('1','171',231660,'AFTERNO0N SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'571',1417609.48,1417609.48,'571','2021-10-15 07:20:47','614','2021-10-15 13:39:53',10,0),('1','171',231793,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'571',882242.26,882242.26,'571','2021-10-15 13:50:45','614','2021-10-15 14:28:42',10,0),('1','171',231912,'AFTERNO0N SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'571',1607283.46,1607283.46,'571','2021-10-16 07:10:40','614','2021-10-16 13:35:59',10,0),('1','171',232015,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'571',839548.66,839548.66,'571','2021-10-16 14:01:42','614','2021-10-16 21:03:16',10,0),('1','171',232117,'AFTERNO0N SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'571',2605305.82,2605305.82,'571','2021-10-17 07:11:16','614','2021-10-17 09:49:15',10,0),('1','171',232215,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'571',773758.54,773758.54,'571','2021-10-17 13:14:05','614','2021-10-17 17:11:43',10,0),('1','171',232334,'AFTERNO0N SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'571',1105066.12,1105066.12,'571','2021-10-18 06:05:37','614','2021-10-18 12:03:25',10,0),('1','171',232475,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'571',1060181.24,1060181.24,'571','2021-10-18 13:40:09','614','2021-10-18 15:59:45',10,0),('1','171',232610,'AFTERNO0N SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',232615,'AFTERNO0N SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'571',999691.27,999691.27,'571','2021-10-19 07:21:55','614','2021-10-19 11:46:55',10,0),('1','171',232721,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'571',635026.74,635026.74,'571','2021-10-19 13:17:20','614','2021-10-19 17:36:09',10,0),('1','171',232867,'AFTERNO0N SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'571',880799.52,880799.52,'571','2021-10-20 07:08:09','614','2021-10-20 11:06:43',10,0),('1','171',232971,'MORNING SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'571',414298.08,414298.08,'571','2021-10-20 12:29:43','614','2021-10-20 13:25:33',10,0),('1','171',233136,'AFTERNO0N SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'571',849478.96,849478.96,'571','2021-10-21 07:12:56','614','2021-10-21 07:25:40',10,0),('1','171',233241,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'571',777658.33,777658.33,'571','2021-10-21 13:14:02','614','2021-10-21 14:22:16',10,0),('1','171',233404,'AFTERNO0N SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'571',1174253.63,1174253.63,'571','2021-10-22 07:12:46','614','2021-10-22 12:33:18',10,0),('1','171',233499,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'571',809609.59,809609.59,'571','2021-10-22 13:49:20','614','2021-10-22 13:56:05',10,0),('1','171',233637,'AFTERNO0N SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'571',1327362.79,1327362.79,'571','2021-10-23 07:33:26','614','2021-10-23 08:08:18',10,0),('1','171',233737,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'571',797275.38,797275.38,'571','2021-10-23 13:23:00','614','2021-10-23 15:09:41',10,0),('1','171',233861,'AFTERNO0N SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'571',1003467.12,1003467.12,'571','2021-10-24 07:09:00','614','2021-10-24 07:18:26',10,0),('1','171',233950,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'571',726536.08,726536.08,'571','2021-10-24 17:37:46','614','2021-10-25 08:27:07',10,0),('1','171',234126,'AFTERNO0N SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'571',970909.24,970909.24,'571','2021-10-25 09:04:02','614','2021-10-25 16:21:57',10,0),('1','171',234244,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'571',989755.13,989755.13,'571','2021-10-25 16:33:23','614','2021-10-25 19:28:54',10,0),('1','171',234334,'AFTERNO0N SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'571',1194075.89,1194075.89,'571','2021-10-26 07:19:35','614','2021-10-26 07:51:02',10,0),('1','171',234459,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'571',848612.81,848612.81,'571','2021-10-26 13:15:42','614','2021-10-26 17:06:35',10,0),('1','171',234599,'AFTERNO0N SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'571',1367591.51,1367591.51,'571','2021-10-27 07:16:26','614','2021-10-27 11:45:21',10,0),('1','171',234747,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'571',1077377.18,1077377.18,'571','2021-10-27 14:52:35','614','2021-10-27 20:34:59',10,0),('1','171',234858,'AFTERNO0N SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'571',2401544.21,2401544.21,'571','2021-10-28 07:14:54','614','2021-10-28 12:01:32',10,0),('1','171',234953,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'571',365882.29,365882.29,'571','2021-10-28 12:43:12','614','2021-10-28 13:25:24',10,0),('1','171',235108,'AFTERNO0N SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'571',612954.92,612954.92,'571','2021-10-29 07:13:40','614','2021-10-29 07:53:54',10,0),('1','171',235193,'MORNING SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'571',137149.20,137149.20,'571','2021-10-29 12:20:23','614','2021-10-29 16:30:04',10,0),('1','171',235343,'AFTERNO0N SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'571',221234.99,221234.99,'571','2021-10-30 07:35:58','614','2021-10-30 11:53:12',10,0),('1','171',235428,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'571',213418.00,213418.00,'571','2021-10-30 15:04:21','614','2021-10-30 19:21:36',10,0),('1','171',235545,'AFTERNO0N SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'571',296294.34,296294.34,'571','2021-10-31 06:45:18','614','2021-10-31 07:19:22',10,0),('1','171',235793,'AFTERNO0N SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'571',287663.30,287663.30,'571','2021-11-01 07:18:58','614','2021-11-01 10:25:00',10,0),('1','171',235910,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'571',1041019.35,1041019.35,'571','2021-11-01 13:17:26','614','2021-11-01 20:45:27',10,0),('1','171',236045,'AFTERNO0N SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'571',1303687.85,1303687.85,'571','2021-11-02 06:44:28','614','2021-11-02 06:46:03',10,0),('1','171',236083,'MORNING SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'571',799123.90,799123.90,'571','2021-11-02 14:07:33','614','2021-11-02 20:08:32',10,0),('1','171',236320,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'571',1434580.70,1434580.70,'571','2021-11-03 09:25:07','614','2021-11-03 09:46:50',10,0),('1','171',236401,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'571',926630.85,926630.85,'571','2021-11-03 13:36:08','614','2021-11-03 16:35:41',10,0),('1','171',236522,'AFTERNO0N SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'571',1207154.35,1207154.35,'571','2021-11-04 06:21:47','614','2021-11-04 08:52:27',10,0),('1','171',236633,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'571',799093.00,799093.00,'571','2021-11-04 13:15:00','614','2021-11-04 18:55:58',10,0),('1','171',236743,'AFTERNO0N SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'571',1808045.40,1808045.40,'571','2021-11-05 06:26:53','614','2021-11-05 09:05:28',10,0),('1','171',236837,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'571',0.00,0.00,'571','2021-11-05 11:48:24','614','2021-11-05 11:50:09',10,0),('1','171',236863,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'571',1220741.15,1220741.15,'571','2021-11-05 13:47:44','614','2021-11-05 15:50:54',10,0),('1','171',236969,'AFTERNO0N SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'571',1350946.80,1350946.80,'571','2021-11-06 06:27:46','614','2021-11-06 09:24:25',10,0),('1','171',237069,'MORNING SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'571',1303684.55,1303684.55,'571','2021-11-06 13:13:42','614','2021-11-06 14:01:58',10,0),('1','171',237122,'AFTERNOON SHIFT ','2021-11-06','2021-11-06 00:00:00',NULL,'571',0.00,0.00,'571','2021-11-06 18:33:35','614','2021-11-06 18:46:57',10,0),('1','171',237181,'AFTERNO0N SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'571',1468586.25,1468586.25,'571','2021-11-07 06:42:35','614','2021-11-07 11:29:21',10,0),('1','171',237279,'MORNING SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'571',1021667.10,1021667.10,'571','2021-11-07 13:31:36','614','2021-11-07 15:40:57',10,0),('1','171',237385,'AFTERNO0N SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'571',1278041.70,1278041.70,'571','2021-11-08 06:04:29','614','2021-11-08 21:49:27',10,0),('1','171',237621,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'571',1300792.20,1300792.20,'571','2021-11-09 06:26:14','614','2021-11-09 07:33:31',10,0),('1','171',237683,'AFTERNO0N SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'571',1571049.35,1571049.35,'571','2021-11-09 09:11:17','614','2021-11-09 10:17:57',10,0),('1','171',237756,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'571',1082247.60,1082247.60,'571','2021-11-09 14:12:40','614','2021-11-09 15:29:48',10,0),('1','171',237881,'AFTERNO0N SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'571',2256096.50,2256096.50,'571','2021-11-10 06:24:36','614','2021-11-10 10:11:32',10,0),('1','171',237995,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'571',1208949.55,1208949.55,'571','2021-11-10 12:56:25','614','2021-11-10 13:36:51',10,0),('1','171',238130,'AFTERNO0N SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'571',2155420.60,2155420.60,'571','2021-11-11 06:30:34','614','2021-11-11 08:40:10',10,0),('1','171',238202,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'571',1717967.55,1717967.55,'571','2021-11-11 13:09:00','614','2021-11-11 13:28:58',10,0),('1','171',238361,'AFTERNO0N SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'571',1435130.45,1435130.45,'571','2021-11-12 06:26:01','614','2021-11-12 07:31:49',10,0),('1','171',238480,'MORNING SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'571',1300862.90,1300862.90,'571','2021-11-12 13:58:01','614','2021-11-12 16:53:27',10,0),('1','171',238615,'AFTERNO0N SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'571',1673721.35,1673721.35,'571','2021-11-13 06:29:53','614','2021-11-13 06:32:35',10,0),('1','171',238630,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'571',1202948.90,1202948.90,'571','2021-11-13 13:19:50','614','2021-11-13 18:10:26',10,0),('1','171',238842,'AFTERNO0N SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'571',145392.80,145392.80,'571','2021-11-14 06:26:43','614','2021-11-14 08:25:01',10,0),('1','171',239449,'AFTERNO0N SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'571',846834.45,846834.45,'571','2021-11-17 06:26:10','614','2021-11-17 06:51:37',10,0),('1','171',239656,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'571',1780968.75,1780968.75,'571','2021-11-17 13:13:04','614','2021-11-17 13:50:16',10,0),('1','171',239788,'AFTERNO0N SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'571',1328030.55,1328030.55,'571','2021-11-18 06:33:27','614','2021-11-18 08:16:32',10,0),('1','171',239863,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'571',813202.50,813202.50,'571','2021-11-18 13:06:39','614','2021-11-18 13:48:28',10,0),('1','171',240004,'AFTERNO0N SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'571',1201963.95,1201963.95,'571','2021-11-19 06:30:05','614','2021-11-19 06:45:02',10,0),('1','171',240104,'MORNING SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'571',1006957.05,1006957.05,'571','2021-11-19 13:45:26','614','2021-11-19 13:51:53',10,0),('1','171',240209,'AFTERNO0N SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'571',1223793.45,1223793.45,'571','2021-11-20 06:36:18','614','2021-11-20 10:49:41',10,0),('1','171',240304,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'571',935172.15,935172.15,'571','2021-11-20 13:12:39','614','2021-11-20 13:53:34',10,0),('1','171',240466,'AFTERNO0N SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'571',1112316.15,1112316.15,'571','2021-11-21 06:36:57','614','2021-11-21 06:46:16',10,0),('1','171',240560,'MORNING SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'571',865014.15,865014.15,'571','2021-11-21 13:14:44','614','2021-11-21 14:33:42',10,0),('1','171',240690,'AFTERNO0N SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'571',896629.10,896629.10,'571','2021-11-22 06:05:09','614','2021-11-22 10:04:01',10,0),('1','171',240811,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'571',1037447.35,1037447.35,'571','2021-11-22 13:11:27','614','2021-11-22 14:28:44',10,0),('1','171',240980,'AFTERNO0N SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'571',2344276.45,2344276.45,'571','2021-11-23 06:35:34','614','2021-11-23 08:12:08',10,0),('1','171',241117,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'571',1312165.90,1312165.90,'571','2021-11-23 13:32:51','614','2021-11-23 14:55:27',10,0),('1','171',241231,'AFTERNO0N SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'571',1399514.80,1399514.80,'571','2021-11-24 06:34:58','614','2021-11-24 08:52:42',10,0),('1','171',241369,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'571',1031863.30,1031863.30,'571','2021-11-24 13:22:44','614','2021-11-24 16:12:42',10,0),('1','171',241502,'AFTERNO0N SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'571',1186155.30,1186155.30,'571','2021-11-25 06:36:06','614','2021-11-25 09:04:46',10,0),('1','171',241621,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'571',1092809.45,1092809.45,'571','2021-11-25 13:12:25','614','2021-11-25 14:25:24',10,0),('1','171',241703,'AFTERNO0N SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'571',1381738.35,1381738.35,'571','2021-11-25 21:55:53','614','2021-11-25 21:57:36',10,0),('1','171',241855,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'571',1117324.65,1117324.65,'571','2021-11-26 12:37:18','614','2021-11-26 14:41:24',10,0),('1','171',241943,'AFTERNO0N SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'571',1119946.95,1119946.95,'571','2021-11-26 21:53:58','614','2021-11-27 07:12:30',10,0),('1','171',242059,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'571',951057.15,951057.15,'571','2021-11-27 13:13:47','614','2021-11-27 17:09:29',10,0),('1','171',242154,'AFTERNOON','2021-11-27','2021-11-27 00:00:00',NULL,'571',1247757.80,1247757.80,'571','2021-11-27 19:53:01','614','2021-11-28 06:14:42',10,0),('1','171',242302,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'571',133735.60,133735.60,'571','2021-11-28 14:30:19','614','2021-11-28 17:09:44',10,0),('1','171',242379,'AFTERNOO','2021-11-28','2021-11-28 00:00:00',NULL,'571',857921.40,857921.40,'571','2021-11-28 21:45:23','614','2021-11-29 06:24:18',10,0),('1','171',242574,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'571',1782294.25,1782294.25,'571','2021-11-29 13:56:47','614','2021-11-29 19:13:36',10,0),('1','171',242621,'AFTERNO0N SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'571',1468055.90,1468055.90,'571','2021-11-29 21:57:58','614','2021-11-30 08:56:47',10,0),('1','171',242779,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'571',1315313.60,1315313.60,'571','2021-11-30 13:26:08','614','2021-11-30 14:28:46',10,0),('1','171',242888,'AFTERNO0N SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'571',767636.05,767636.05,'571','2021-11-30 21:23:20','614','2021-11-30 21:23:57',10,0),('1','171',243006,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'571',1039605.65,1039605.65,'571','2021-12-01 13:43:16','614','2021-12-01 16:08:31',10,0),('1','171',243104,'AFTERNO0N SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'571',1538895.45,1538895.45,'571','2021-12-01 21:39:01','614','2021-12-02 06:40:50',10,0),('1','171',243234,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'571',1209443.15,1209443.15,'571','2021-12-02 13:48:15','614','2021-12-03 06:13:28',10,0),('1','171',243375,'AFTERNO0N SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'571',928805.50,928805.50,'571','2021-12-03 06:21:19','614','2021-12-03 08:41:16',10,0),('1','171',243461,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'571',141175.85,141175.85,'571','2021-12-03 14:30:00','614','2021-12-03 16:41:33',10,0),('1','171',243552,'AFTERNO0N SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'571',92545.15,92545.15,'571','2021-12-03 19:29:44','614','2021-12-04 06:18:03',10,0),('1','171',243652,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'571',869874.00,869874.00,'571','2021-12-04 13:41:55','614','2021-12-04 14:45:13',10,0),('1','171',243758,'AFTERNO0N SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'571',2030870.50,2030870.50,'571','2021-12-04 21:11:35','614','2021-12-04 23:22:01',10,0),('1','171',243938,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'571',856315.15,856315.15,'571','2021-12-05 14:01:46','614','2021-12-05 14:34:02',10,0),('1','171',244009,'AFTERNO0N SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'571',1118534.50,1118534.50,'571','2021-12-05 20:42:21','614','2021-12-06 05:36:31',10,0),('1','171',244145,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'571',1362299.50,1362299.50,'571','2021-12-06 13:24:05','614','2021-12-06 13:34:07',10,0),('1','171',244211,'AFTERNO0N SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'571',1616436.80,1616436.80,'571','2021-12-06 21:15:15','614','2021-12-06 21:58:49',10,0),('1','171',244325,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'571',1050364.85,1050364.85,'571','2021-12-07 13:31:56','614','2021-12-07 13:50:42',10,0),('1','171',244433,'AFTERNO0N SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'571',1605219.60,1605219.60,'571','2021-12-07 20:32:33','614','2021-12-08 06:48:37',10,0),('1','171',244612,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'571',1276437.35,1276437.35,'571','2021-12-08 13:33:09','614','2021-12-08 13:43:04',10,0),('1','171',244666,'AFTERNO0N SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'571',1590226.95,1590226.95,'571','2021-12-08 21:05:36','614','2021-12-09 06:21:36',10,0),('1','171',244841,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'571',1107690.40,1107690.40,'571','2021-12-09 13:29:05','614','2021-12-09 13:35:31',10,0),('1','171',244916,'AFTERNO0N SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'571',1093115.10,1093115.10,'571','2021-12-09 20:11:17','614','2021-12-10 11:21:55',10,0),('1','171',245094,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'571',835408.20,835408.20,'571','2021-12-10 13:04:35','614','2021-12-10 14:25:50',10,0),('1','171',245177,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'571',1108210.95,1108210.95,'571','2021-12-10 20:17:18','614','2021-12-11 06:08:51',10,0),('1','171',245302,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'571',968652.35,968652.35,'571','2021-12-11 13:48:06','614','2021-12-11 15:55:19',10,0),('1','171',245405,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'571',1094376.00,1094376.00,'571','2021-12-11 20:47:04','614','2021-12-12 06:50:00',10,0),('1','171',245517,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'571',534901.95,534901.95,'571','2021-12-12 13:42:01','614','2021-12-12 14:27:37',10,0),('1','171',245636,'AFTERNO0N SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'571',845247.15,845247.15,'571','2021-12-12 20:21:49','614','2021-12-13 00:23:10',10,0),('1','171',245763,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'571',1012773.30,1012773.30,'571','2021-12-13 13:29:23','614','2021-12-13 13:49:51',10,0),('1','171',245829,'AFTERNO0N SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'571',1006707.90,1006707.90,'571','2021-12-13 20:35:45','614','2021-12-13 20:54:28',10,0),('1','171',246021,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'571',754304.10,754304.10,'571','2021-12-14 13:27:25','614','2021-12-14 14:07:28',10,0),('1','171',246149,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'571',1070355.45,1070355.45,'571','2021-12-14 20:24:07','614','2021-12-14 22:36:17',10,0),('1','171',246264,'MORNING','2021-12-15','2021-12-15 00:00:00',NULL,'571',890554.50,890554.50,'571','2021-12-15 13:32:38','614','2021-12-15 15:25:24',10,0),('1','171',246406,'AFTERNO0N SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'571',1150460.85,1150460.85,'571','2021-12-15 20:23:34','614','2021-12-16 07:44:47',10,0),('1','171',246514,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'571',866349.00,866349.00,'571','2021-12-16 13:46:13','614','2021-12-16 14:46:23',10,0),('1','171',246662,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'571',1194911.85,1194911.85,'571','2021-12-16 20:23:59','614','2021-12-16 23:29:04',10,0),('1','171',246769,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'571',1052233.05,1052233.05,'571','2021-12-17 13:57:08','614','2021-12-17 17:19:36',10,0),('1','171',246901,'AFTERNOO SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'571',1096324.35,1096324.35,'571','2021-12-17 20:57:57','614','2021-12-18 05:11:05',10,0),('1','171',246996,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'571',1056049.50,1056049.50,'571','2021-12-18 13:47:58','614','2021-12-18 15:58:24',10,0),('1','171',247137,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'571',1269270.25,1269270.25,'571','2021-12-18 20:24:56','614','2021-12-19 09:22:00',10,0),('1','171',247254,'MORNING SHIFT  ','2021-12-19','2021-12-19 00:00:00',NULL,'571',795976.50,795976.50,'571','2021-12-19 13:57:57','614','2021-12-19 13:59:24',10,0),('1','171',247366,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'571',825282.15,825282.15,'571','2021-12-19 20:20:56','614','2021-12-20 06:56:30',10,0),('1','171',247465,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'571',915819.30,915819.30,'571','2021-12-20 13:51:32','614','2021-12-20 13:53:10',10,0),('1','171',247622,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'571',1368396.40,1368396.40,'571','2021-12-20 20:26:11','614','2021-12-21 07:07:42',10,0),('1','171',247733,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'571',1189874.30,1189874.30,'571','2021-12-21 13:42:29','614','2021-12-21 13:43:24',10,0),('1','171',247806,'AFTERNO0N SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'571',762325.65,762325.65,'571','2021-12-21 19:04:23','614','2021-12-22 06:31:00',10,0),('1','171',247989,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'571',96910.20,96910.20,'571','2021-12-22 12:41:42','614','2021-12-22 14:03:28',10,0),('1','171',248086,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'571',205530.00,205530.00,'571','2021-12-22 18:01:15','614','2021-12-22 20:25:06',10,0),('1','171',248176,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'571',252476.65,252476.65,'571','2021-12-23 13:12:16','614','2021-12-23 14:16:23',10,0),('1','171',248314,'AFTERNO0N SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'571',1619652.10,1619652.10,'571','2021-12-23 20:33:48','614','2021-12-24 05:55:42',10,0),('1','171',248458,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'571',1013323.25,1013323.25,'571','2021-12-24 13:45:17','614','2021-12-24 13:48:30',10,0),('1','171',248606,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'571',1734922.40,1734922.40,'571','2021-12-24 20:49:17','614','2021-12-25 06:04:01',10,0),('1','171',248672,'AFTERNOO SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'571',747083.70,747083.70,'571','2021-12-25 13:21:29','614','2021-12-25 13:48:57',10,0),('1','171',248826,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'571',1199465.20,1199465.20,'571','2021-12-25 20:36:17','614','2021-12-25 23:32:34',10,0),('1','171',248915,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'571',739307.90,739307.90,'571','2021-12-26 13:35:43','614','2021-12-26 14:02:33',10,0),('1','171',249066,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'571',889389.15,889389.15,'571','2021-12-26 20:28:00','614','2021-12-26 21:42:16',10,0),('1','171',249129,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'571',816394.00,816394.00,'571','2021-12-27 13:24:15','614','2021-12-27 14:11:10',10,0),('1','171',249312,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'571',1389818.35,1389818.35,'571','2021-12-27 20:22:20','614','2021-12-27 20:51:29',10,0),('1','171',249357,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'571',1054253.75,1054253.75,'571','2021-12-28 13:41:12','614','2021-12-28 16:07:01',10,0),('1','171',249543,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'571',1403436.25,1403436.25,'571','2021-12-28 20:23:52','614','2021-12-28 23:53:05',10,0),('1','171',249566,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'571',932627.30,932627.30,'571','2021-12-29 12:39:11','614','2021-12-29 15:30:41',10,0),('1','171',249811,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'571',1658566.80,1658566.80,'571','2021-12-29 20:27:00','614','2021-12-29 22:42:46',10,0),('1','171',249848,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'571',1021205.90,1021205.90,'571','2021-12-30 13:23:48','614','2021-12-30 13:44:56',10,0),('1','171',250038,'AFTERNO0N SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'571',1353615.05,1353615.05,'571','2021-12-30 18:50:20','614','2021-12-30 19:49:26',10,0),('1','171',250196,'MORNING SHIFT  1','2021-12-31','2021-12-31 00:00:00',NULL,'571',106392.65,106392.65,'571','2021-12-31 12:42:20','614','2021-12-31 15:32:34',10,0),('1','171',250267,'AFTERNO0N SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'571',110875.35,110875.35,'571','2021-12-31 18:43:34','614','2022-01-01 01:48:12',10,0),('1','171',250339,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'571',243742.65,243742.65,'571','2022-01-01 13:44:48','614','2022-01-01 20:25:29',10,0),('1','171',250532,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'571',583447.10,583447.10,'571','2022-01-01 21:13:13','614','2022-01-02 06:45:03',10,0),('1','171',250595,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'571',429546.45,429546.45,'571','2022-01-02 13:21:36','614','2022-01-02 19:05:56',10,0),('1','171',250765,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'571',1131795.20,1131795.20,'571','2022-01-02 20:39:25','614','2022-01-03 06:21:55',10,0),('1','171',250826,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'571',705240.30,705240.30,'571','2022-01-03 13:17:28','614','2022-01-03 14:44:47',10,0),('1','171',250949,'AFTERNOO SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'571',1564855.65,1564855.65,'571','2022-01-03 20:16:11','614','2022-01-03 20:40:13',10,0),('1','171',251152,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'571',924856.15,924856.15,'571','2022-01-04 14:26:44','614','2022-01-04 15:03:17',10,0),('1','171',251235,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'571',1563386.65,1563386.65,'571','2022-01-04 20:23:26','614','2022-01-04 21:16:35',10,0),('1','171',251312,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'571',1082308.60,1082308.60,'571','2022-01-05 14:59:45','614','2022-01-05 17:38:28',10,0),('1','171',251479,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'571',1557227.15,1557227.15,'571','2022-01-05 21:30:09','614','2022-01-05 22:14:05',10,0),('1','171',251549,'MORNING SHIFTa','2022-01-06','2022-01-06 00:00:00',NULL,'571',867556.45,867556.45,'571','2022-01-06 15:04:04','614','2022-01-06 15:58:04',10,0),('1','171',251724,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'571',1601667.00,1601667.00,'571','2022-01-06 21:36:53','614','2022-01-06 23:56:49',10,0),('1','171',251788,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'571',1001544.20,1001544.20,'571','2022-01-07 14:52:09','614','2022-01-07 19:56:11',10,0),('1','171',251948,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'571',1443598.55,1443598.55,'571','2022-01-07 21:23:13','614','2022-01-07 22:27:45',10,0),('1','171',252032,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'571',937351.20,937351.20,'571','2022-01-08 14:29:55','614','2022-01-08 15:52:48',10,0),('1','171',252191,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'571',1288080.45,1288080.45,'571','2022-01-08 20:51:49','614','2022-01-08 23:43:19',10,0),('1','171',252256,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'571',1040590.50,1040590.50,'571','2022-01-09 13:54:31','614','2022-01-09 14:47:48',10,0),('1','171',252422,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'571',1181922.50,1181922.50,'571','2022-01-09 20:32:07','614','2022-01-09 22:27:10',10,0),('1','171',252551,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'571',300132.55,300132.55,'571','2022-01-10 17:29:40','614','2022-01-10 17:30:46',10,0),('1','171',252655,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'571',458012.00,458012.00,'571','2022-01-10 20:19:24','614','2022-01-10 22:26:46',10,0),('1','171',252796,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'571',78917.50,78917.50,'571','2022-01-11 14:41:47','614','2022-01-11 14:57:10',10,0),('1','171',252915,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'571',221652.75,221652.75,'571','2022-01-11 19:42:36','614','2022-01-11 22:29:39',10,0),('1','171',253030,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'571',49399.10,49399.10,'571','2022-01-12 13:57:39','614','2022-01-12 14:30:32',10,0),('1','171',253156,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'571',144220.85,144220.85,'571','2022-01-12 20:14:32','614','2022-01-12 23:29:18',10,0),('1','171',253329,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'571',156548.85,156548.85,'571','2022-01-13 14:09:11','614','2022-01-13 15:28:24',10,0),('1','171',253426,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'571',150009.65,150009.65,'571','2022-01-13 19:36:30','614','2022-01-14 07:41:40',10,0),('1','171',253618,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'571',195234.65,195234.65,'571','2022-01-14 15:06:19','614','2022-01-14 16:59:21',10,0),('1','171',253660,'AFTERNO0N SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'571',1192294.55,1192294.55,'571','2022-01-14 21:17:13','614','2022-01-15 07:17:55',10,0),('1','171',253766,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'571',1540785.90,1540785.90,'571','2022-01-15 14:45:19','614','2022-01-15 15:04:13',10,0),('1','171',253861,'AFTERNO0N SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'571',1151437.10,1151437.10,'571','2022-01-15 21:10:51','614','2022-01-16 08:26:17',10,0),('1','171',254012,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'571',726564.25,726564.25,'571','2022-01-16 14:54:54','614','2022-01-16 15:14:59',10,0),('1','171',254153,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'571',933919.30,933919.30,'571','2022-01-16 21:01:47','614','2022-01-16 22:37:53',10,0),('1','171',254232,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'571',1050650.55,1050650.55,'571','2022-01-17 14:08:36','614','2022-01-17 15:11:16',10,0),('1','171',254407,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'571',1148377.30,1148377.30,'571','2022-01-17 21:18:35','614','2022-01-18 10:03:50',10,0),('1','171',254547,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'571',1098173.25,1098173.25,'571','2022-01-18 15:20:43','614','2022-01-18 16:00:20',10,0),('1','171',254671,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'571',1309004.10,1309004.10,'571','2022-01-18 21:25:00','614','2022-01-19 03:16:07',10,0),('1','171',254697,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'571',717191.10,717191.10,'571','2022-01-19 14:01:59','614','2022-01-19 15:49:34',10,0),('1','171',254913,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'571',1163085.15,1163085.15,'571','2022-01-19 21:25:56','614','2022-01-20 10:34:13',10,0),('1','171',255052,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'571',832140.60,832140.60,'571','2022-01-20 13:50:00','614','2022-01-20 16:42:41',10,0),('1','171',255155,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'571',1302709.50,1302709.50,'571','2022-01-20 21:41:02','614','2022-01-20 22:34:47',10,0),('1','171',255208,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'571',814151.95,814151.95,'571','2022-01-21 14:55:28','614','2022-01-21 15:11:37',10,0),('1','171',255427,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'571',1357882.90,1357882.90,'571','2022-01-21 21:23:19','614','2022-01-22 00:47:08',10,0),('1','171',255480,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'571',836454.65,836454.65,'571','2022-01-22 13:54:47','614','2022-01-22 15:05:12',10,0),('1','171',255672,'AFTERNO0N SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'571',994238.05,994238.05,'571','2022-01-22 21:25:00','614','2022-01-22 23:26:20',10,0),('1','171',255752,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'571',690862.55,690862.55,'571','2022-01-23 14:43:37','614','2022-01-23 15:56:12',10,0),('1','171',255912,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'571',1090512.70,1090512.70,'571','2022-01-23 21:17:21','614','2022-01-23 23:55:08',10,0),('1','171',255992,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'571',990250.90,990250.90,'571','2022-01-24 15:50:25','614','2022-01-24 18:40:23',10,0),('1','171',256165,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'571',1385891.50,1385891.50,'571','2022-01-24 21:32:38','614','2022-01-24 23:17:29',10,0),('1','171',256235,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'571',113001.00,113001.00,'571','2022-01-25 10:59:11','614','2022-01-25 11:31:15',10,0),('1','171',256355,'MORNING SHIFT2','2022-01-25','2022-01-25 00:00:00',NULL,'571',824598.25,824598.25,'571','2022-01-25 15:32:16','614','2022-01-25 15:47:48',10,0),('1','171',256446,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'571',1287776.70,1287776.70,'571','2022-01-25 21:14:05','614','2022-01-25 23:30:29',10,0),('1','171',256526,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'571',1274534.30,1274534.30,'571','2022-01-26 15:29:51','614','2022-01-26 23:39:45',10,0),('1','171',256701,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'571',1110303.55,1110303.55,'571','2022-01-27 00:01:48','614','2022-01-27 00:45:41',10,0),('1','171',256706,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'571',1872246.35,1872246.35,'571','2022-01-27 14:01:49','614','2022-01-27 21:06:32',10,0),('1','171',256920,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'571',1595792.40,1595792.40,'571','2022-01-27 21:19:11','614','2022-01-27 22:15:18',10,0),('1','171',256975,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'571',34896.50,34896.50,'571','2022-01-28 07:59:43','614','2022-01-28 10:09:45',10,0),('1','171',257048,'AFTERNO0N SHIFT 2','2022-01-28','2022-01-28 00:00:00',NULL,'571',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','171',257111,'MORNING SHIFT  2','2022-01-28','2022-01-28 00:00:00',NULL,'571',1180172.10,1180172.10,'571','2022-01-28 19:47:49','614','2022-01-28 19:50:12',10,0),('1','171',257195,'AFTERNO0N SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'571',1457533.20,1457533.20,'571','2022-01-28 21:30:39','614','2022-01-29 00:39:50',10,0),('1','171',257258,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'571',606386.70,606386.70,'571','2022-01-29 14:58:41','614','2022-01-29 16:49:13',10,0),('1','171',257445,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'571',1366504.20,1366504.20,'571','2022-01-29 21:18:20','614','2022-01-29 22:51:27',10,0),('1','171',257515,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'571',870877.50,870877.50,'571','2022-01-30 14:22:13','614','2022-01-30 15:38:31',10,0),('1','171',257516,'AFTERNOO SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'571',977258.70,977258.70,'571','2022-01-31 10:46:23','614','2022-01-31 11:56:01',10,0),('1','171',257517,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'571',1252229.10,1252229.10,'571','2022-01-31 14:44:53','614','2022-01-31 18:19:48',10,0),('1','171',257518,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'571',1190902.35,1190902.35,'571','2022-01-31 21:18:32','614','2022-01-31 22:59:08',10,0),('1','171',257519,'AFTERNOO SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'571',898680.15,898680.15,'571','2022-02-01 14:27:02','614','2022-02-01 15:54:16',10,0),('1','171',257520,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'571',1151632.05,1151632.05,'571','2022-02-01 21:17:35','614','2022-02-02 05:31:40',10,0),('1','171',257521,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'571',1044900.60,1044900.60,'571','2022-02-02 14:36:03','614','2022-02-02 16:24:32',10,0),('1','171',257522,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'571',1221938.85,1221938.85,'571','2022-02-02 21:21:32','614','2022-02-03 07:05:34',10,0),('1','171',257523,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'571',1257133.80,1257133.80,'571','2022-02-03 14:04:56','614','2022-02-03 15:03:31',10,0),('1','171',257524,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'571',1491316.20,1491316.20,'571','2022-02-03 21:14:33','614','2022-02-03 23:04:33',10,0),('1','171',257525,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'571',1063185.45,1063185.45,'571','2022-02-04 14:46:26','614','2022-02-04 19:16:32',10,0),('1','171',257526,'AFTERNO0N SHIFT 1','2022-02-04','2022-02-04 00:00:00',NULL,'571',77497.20,77497.20,'571','2022-02-04 19:34:53','614','2022-02-04 19:36:16',10,0),('1','171',257527,'AFTERNO0N SHIFT 2','2022-02-04','2022-02-04 00:00:00',NULL,'571',1373094.70,1373094.70,'571','2022-02-04 21:13:26','614','2022-02-05 01:40:12',10,0),('1','171',257528,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'571',1040335.00,1040335.00,'571','2022-02-05 14:19:47','614','2022-02-05 15:11:36',10,0),('1','171',257529,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'571',1360709.50,1360709.50,'571','2022-02-05 21:08:34','614','2022-02-05 23:35:02',10,0),('1','171',257530,'MORNING SHIFT  1','2022-02-06','2022-02-06 00:00:00',NULL,'571',806172.75,806172.75,'571','2022-02-06 14:29:32','614','2022-02-06 15:37:05',10,0),('1','171',257531,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'571',1193394.30,1193394.30,'571','2022-02-06 21:12:23','614','2022-02-07 01:05:42',10,0),('1','171',257532,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'571',930240.30,930240.30,'571','2022-02-07 14:36:00','614','2022-02-07 14:53:45',10,0),('1','171',257533,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'571',1177833.75,1177833.75,'571','2022-02-07 21:06:29','614','2022-02-07 22:36:46',10,0),('1','171',257534,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'571',813905.60,813905.60,'571','2022-02-08 14:43:56','614','2022-02-08 19:50:27',10,0),('1','171',257535,'AFTERNO0N SHIFT 1','2022-02-08','2022-02-08 00:00:00',NULL,'571',669541.00,669541.00,'571','2022-02-08 19:58:09','614','2022-02-08 20:11:31',10,0),('1','171',257536,'AFTERNOON SHIFT 2','2022-02-08','2022-02-08 00:00:00',NULL,'571',1491520.80,1491520.80,'571','2022-02-08 21:28:31','614','2022-02-08 22:43:33',10,0),('1','171',257537,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'571',1704843.25,1704843.25,'571','2022-02-09 14:37:09','614','2022-02-09 16:21:23',10,0),('1','171',257538,'AFTERNO0N SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'571',2885361.05,2885361.05,'571','2022-02-09 21:58:14','614','2022-02-09 23:37:59',10,0),('1','171',257539,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'571',1325281.10,1325281.10,'571','2022-02-10 14:35:46','614','2022-02-10 15:12:18',10,0),('1','171',257540,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'571',2002207.35,2002207.35,'571','2022-02-10 21:05:37','614','2022-02-10 22:36:47',10,0),('1','171',257541,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'571',1505632.70,1505632.70,'571','2022-02-11 15:16:37','614','2022-02-11 15:34:47',10,0),('1','171',257542,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'571',2125011.35,2125011.35,'571','2022-02-11 20:59:00','614','2022-02-11 21:32:49',10,0),('1','171',257543,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'571',2245599.95,2245599.95,'571','2022-02-12 14:47:38','614','2022-02-12 17:20:41',10,0),('1','171',257544,'AFTERNO0N SHIFT 1','2022-02-12','2022-02-12 00:00:00',NULL,'571',199892.00,199892.00,'571','2022-02-12 17:30:30','614','2022-02-12 19:47:25',10,0),('1','171',257545,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'571',645736.70,645736.70,'571','2022-02-12 20:16:21','614','2022-02-12 21:38:09',10,0),('1','171',257546,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'571',937684.70,937684.70,'571','2022-02-13 14:29:20','614','2022-02-13 15:18:09',10,0),('1','171',257547,'AFTERNO0N SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'571',1829502.55,1829502.55,'571','2022-02-13 20:53:42','614','2022-02-13 21:55:52',10,0),('1','171',257548,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'571',1006864.10,1006864.10,'571','2022-02-14 14:20:37','614','2022-02-14 15:45:51',10,0),('1','171',257549,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'571',1719747.70,1719747.70,'571','2022-02-14 21:12:55','614','2022-02-14 22:48:55',10,0),('1','171',257550,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'571',1339257.15,1339257.15,'571','2022-02-15 14:24:08','614','2022-02-15 19:18:09',10,0),('1','171',257551,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'571',2338043.05,2338043.05,'571','2022-02-15 20:53:47','614','2022-02-15 22:42:39',10,0),('1','171',257552,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'571',704234.85,704234.85,'571','2022-02-16 15:54:53','614','2022-02-16 19:27:45',10,0),('1','171',257553,'AFTERNOON SHIFT ','2022-02-16','2022-02-16 00:00:00',NULL,'571',1647562.15,1647562.15,'571','2022-02-16 20:51:51','614','2022-02-16 20:55:36',10,0),('1','171',257554,'MORNING SHIFT  1','2022-02-17','2022-02-17 00:00:00',NULL,'571',297592.00,297592.00,'571','2022-02-17 13:49:37','614','2022-02-17 17:00:31',10,0),('1','171',257555,'MORNING SHIFT  2','2022-02-17','2022-02-17 00:00:00',NULL,'571',1269594.75,1269594.75,'571','2022-02-17 20:24:55','614','2022-02-17 23:07:04',10,0),('1','171',257556,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'571',289400.10,289400.10,'571','2022-02-18 11:31:55','614','2022-02-18 15:16:58',10,0),('1','171',257557,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'571',861182.70,861182.70,'571','2022-02-20 17:47:59','614','2022-02-20 23:45:01',10,0),('1','171',257558,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'571',811039.35,811039.35,'571','2022-02-21 05:51:43','614','2022-02-21 11:37:55',10,0),('1','171',257559,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'571',360103.50,360103.50,'571','2022-02-21 14:41:08','614','2022-02-21 19:48:11',10,0),('1','171',257560,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'571',855214.50,855214.50,'571','2022-02-21 21:01:52','614','2022-02-22 02:24:55',10,0),('1','171',257561,'MORNING SHIFT','2022-02-22','2022-02-22 10:01:26','2022-02-23 10:01:26','571',1178698.50,1178698.50,'571','2022-02-22 15:17:10','614','2022-02-22 20:45:49',10,0),('1','171',257562,'AFTERNOON SHIFT','2022-02-22','2022-02-22 22:10:06','2022-02-23 22:10:06','571',745372.80,745372.80,'571','2022-02-22 22:13:03','614','2022-02-22 22:23:11',10,0),('1','171',257563,'MORNING SHIFT','2022-02-23','2022-02-23 11:28:46','2022-02-24 11:28:46','571',134365.20,134365.20,'571','2022-02-23 13:49:12','614','2022-02-23 16:37:10',10,0),('1','171',257564,'AFTERNOON SHIFT','2022-02-23','2022-02-23 20:46:28','2022-02-24 20:46:28','571',556200.10,556200.10,'571','2022-02-23 20:51:12','614','2022-02-24 08:26:31',10,0),('1','171',257565,'MORNING SHIFT','2022-02-24','2022-02-24 08:52:58','2022-02-25 08:52:58','571',578669.90,578669.90,'571','2022-02-24 15:34:06','614','2022-02-24 15:45:30',10,0),('1','171',257566,'AFTERNOON SHIFT','2022-02-24','2022-02-24 20:04:58','2022-02-25 20:04:58','571',1660875.65,1660875.65,'571','2022-02-24 20:07:47','614','2022-02-24 23:35:12',10,0),('1','171',257567,'MORNING SHIFT','2022-02-25','2022-02-25 12:20:42','2022-02-26 12:20:42','571',1389262.65,1389262.65,'571','2022-02-25 14:43:18','614','2022-02-25 18:26:29',10,0),('1','171',257568,'AFTERNO0N SHIFT 1','2022-02-25','2022-02-25 18:34:47','2022-02-26 18:34:47','571',174340.20,174340.20,'571','2022-02-25 18:36:03','614','2022-02-25 21:22:33',10,0),('1','171',257569,'AFTERNOON SHIFT 2','2022-02-25','2022-02-26 01:10:59','2022-02-27 01:10:59','571',633051.40,633051.40,'571','2022-02-26 16:16:50','614','2022-02-26 19:09:38',10,0),('1','171',257570,'MORNING SHIFT','2022-02-27','2022-02-27 14:28:35','2022-02-28 14:28:35','571',58303.35,58303.35,'571','2022-02-27 14:31:08','614','2022-02-27 15:14:41',10,0),('1','171',257571,'AFTERNOON SHIFT','2022-02-27','2022-02-27 20:05:15','2022-02-28 20:05:15','571',303423.10,303423.10,'571','2022-02-27 20:06:50','614','2022-02-27 22:59:44',10,0),('1','171',257572,'MORNING SHIFT','2022-02-28','2022-02-28 07:00:28','2022-03-01 07:00:28','571',757428.95,757428.95,'571','2022-02-28 13:12:53','614','2022-02-28 16:00:37',10,0),('1','171',257573,'AFTERNOON SHIFT','2022-02-28','2022-02-28 19:38:46','2022-03-01 19:38:46','571',332937.90,332937.90,'571','2022-02-28 19:41:18','614','2022-02-28 22:07:57',10,0),('1','171',257574,'MORNING SHIFT','2022-03-01','2022-03-01 07:45:23','2022-03-02 07:45:23','571',171204.10,171204.10,'571','2022-03-01 09:52:20','614','2022-03-01 10:56:41',10,0),('1','171',257575,'MORNING SHIFT 2','2022-03-01','2022-03-01 12:31:34','2022-03-02 12:31:34','571',513878.40,513878.40,'571','2022-03-01 15:37:31','614','2022-03-01 15:54:23',10,0),('1','171',257576,'AFTERNOON SHIFT','2022-03-01','2022-03-01 20:37:33','2022-03-02 20:37:33','571',995978.10,995978.10,'571','2022-03-01 20:56:27','614','2022-03-01 23:57:10',10,0),('1','171',257577,'MORNING SHIFT','2022-03-02','2022-03-02 12:28:19','2022-03-03 12:28:19','571',67897.20,67897.20,'571','2022-03-02 12:29:45','614','2022-03-02 12:42:13',10,0),('1','171',257578,'MORNING SHIFT  2','2022-03-02','2022-03-02 15:33:42','2022-03-03 15:33:42','571',1199213.40,1199213.40,'571','2022-03-02 15:35:03','614','2022-03-02 17:09:49',10,0),('1','171',257579,'AFTERNOON SHIFT','2022-03-02','2022-03-02 21:10:20','2022-03-03 21:10:20','571',1200829.45,1200829.45,'571','2022-03-02 21:14:43','614','2022-03-02 23:28:11',10,0),('1','171',257580,'MORNING SHIFT','2022-03-03','2022-03-03 14:54:08','2022-03-04 14:54:08','571',1263638.55,1263638.55,'571','2022-03-03 15:43:16','614','2022-03-03 15:47:33',10,0),('1','171',257581,'AFTERNO0N SHIFT','2022-03-03','2022-03-03 18:45:27','2022-03-04 18:45:27','571',1733212.55,1733212.55,'571','2022-03-03 20:25:54','614','2022-03-04 13:07:37',10,0),('1','171',257582,'MORNING SHIFT','2022-03-04','2022-03-04 13:47:13','2022-03-05 13:47:13','571',3130716.50,3130716.50,'571','2022-03-04 13:49:34','614','2022-03-04 14:51:17',10,0),('1','171',257583,'AFTERNO0N SHIFT','2022-03-04','2022-03-04 17:33:16','2022-03-05 17:33:16','571',294644.60,294644.60,'571','2022-03-04 19:25:20','614','2022-03-04 20:43:40',10,0),('1','171',257584,'AFTERNOON SHIFT 2','2022-03-04','2022-03-04 21:00:40','2022-03-05 21:00:40','571',437938.05,437938.05,'571','2022-03-04 21:03:24','614','2022-03-05 11:56:58',10,0),('1','171',257585,'MORNING SHIFT','2022-03-05','2022-03-05 14:50:54','2022-03-06 14:50:54','571',1328046.05,1328046.05,'571','2022-03-05 14:54:10','614','2022-03-05 15:37:01',10,0),('1','171',257586,'AFTERNO0N SHIFT','2022-03-05','2022-03-05 15:40:29','2022-03-06 15:40:29','571',150558.00,150558.00,'571','2022-03-05 15:44:10','614','2022-03-05 18:56:33',10,0),('1','171',257587,'AFTERNO0N SHIFT 2','2022-03-05','2022-03-05 19:52:13','2022-03-06 19:52:13','571',991191.40,991191.40,'571','2022-03-05 19:55:37','614','2022-03-05 22:24:09',10,0),('1','171',257588,'MORNING SHIFT','2022-03-06','2022-03-06 13:12:36','2022-03-07 13:12:36','571',923926.85,923926.85,'571','2022-03-06 13:16:46','614','2022-03-06 20:07:42',10,0),('1','171',257589,'AFTERNOON SHIFT','2022-03-06','2022-03-06 20:45:49','2022-03-07 20:45:49','571',1811857.20,1811857.20,'571','2022-03-06 20:49:47','614','2022-03-06 23:13:15',10,0),('1','171',257590,'MORNING SHIFT','2022-03-07','2022-03-07 14:54:04','2022-03-08 14:54:04','571',1536356.65,1536356.65,'571','2022-03-07 14:59:21','614','2022-03-07 15:26:40',10,0),('1','171',257591,'MORNING SHIFT','2022-03-07','2022-03-07 20:19:24','2022-03-08 20:19:24','571',1551080.70,1551080.70,'571','2022-03-07 21:11:59','614','2022-03-07 22:00:27',10,0),('1','171',257592,'MORNING SHIFT','2022-03-08','2022-03-08 12:31:22','2022-03-09 12:31:22','571',1925965.70,1925965.70,'571','2022-03-08 14:34:52','614','2022-03-08 15:20:36',10,0),('1','171',257593,'AFTERNO0N SHIFT','2022-03-08','2022-03-08 15:38:56','2022-03-09 15:38:56','571',1701610.20,1701610.20,'571','2022-03-08 20:33:51','614','2022-03-08 23:39:39',10,0),('1','171',257594,'MORNING SHIFT','2022-03-09','2022-03-09 11:00:53','2022-03-10 11:00:53','571',2503868.10,2503868.10,'571','2022-03-09 15:18:49','614','2022-03-09 16:06:36',10,0),('1','171',257595,'AFTERNO0N SHIFT','2022-03-09','2022-03-09 17:39:38','2022-03-10 17:39:38','571',602198.25,602198.25,'571','2022-03-09 23:21:57','614','2022-03-10 09:16:11',10,0),('1','171',257596,'MORNING SHIFT','2022-03-10','2022-03-10 16:37:37','2022-03-11 16:37:37','571',201960.00,201960.00,'571','2022-03-10 19:29:50','614','2022-03-10 22:26:39',10,0),('1','171',257597,'AFTERNO0N SHIFT','2022-03-11','2022-03-11 18:41:28','2022-03-12 18:41:28','571',406810.80,406810.80,'571','2022-03-11 19:59:30','614','2022-03-11 20:18:00',10,0),('1','171',257598,'MORNING SHIFT','2022-03-12','2022-03-12 11:56:31','2022-03-13 11:56:31','571',687614.40,687614.40,'571','2022-03-12 13:04:10','614','2022-03-12 15:55:31',10,0),('1','171',257599,'AFTERNOON SHIFT','2022-03-12','2022-03-12 18:36:24','2022-03-13 18:36:24','571',414046.05,414046.05,'571','2022-03-12 18:37:54','614','2022-03-12 20:54:28',10,0),('1','171',257600,'MORNING SHIFT','2022-03-13','2022-03-13 14:16:19','2022-03-14 14:16:19','571',553741.65,553741.65,'571','2022-03-13 14:41:27','614','2022-03-13 15:11:49',10,0),('1','171',257601,'AFTERNOON SHIFT','2022-03-13','2022-03-13 17:51:26','2022-03-14 17:51:26','571',193200.15,193200.15,'571','2022-03-13 17:53:02','614','2022-03-13 21:23:32',10,0),('1','171',257602,'MORNING SHIFT','2022-03-14','2022-03-14 14:34:21','2022-03-15 14:34:21','571',353883.75,353883.75,'571','2022-03-14 14:37:49','614','2022-03-14 19:27:08',10,0),('1','171',257603,'AFTERNOON SHIFT','2022-03-14','2022-03-14 19:50:09','2022-03-15 19:50:09','571',1025087.55,1025087.55,'571','2022-03-14 20:14:30','614','2022-03-14 22:25:24',10,0),('1','171',257604,'MORNING SHIFT','2022-03-15','2022-03-15 08:42:18','2022-03-16 08:42:18','571',694608.75,694608.75,'571','2022-03-15 14:32:26','614','2022-03-15 17:02:17',10,0),('1','171',257605,'AFTERNO0N SHIFT','2022-03-15','2022-03-15 18:38:24','2022-03-16 18:38:24','571',625241.10,625241.10,'571','2022-03-15 18:41:08','614','2022-03-15 23:32:34',10,0),('1','171',257606,'MORNING SHIFT','2022-03-16','2022-03-16 10:08:24','2022-03-17 10:08:24','571',679521.15,679521.15,'571','2022-03-16 14:28:51','614','2022-03-16 18:46:39',10,0),('1','171',257607,'AFTERNOON SHIFT','2022-03-16','2022-03-16 19:29:19','2022-03-17 19:29:19','571',540482.25,540482.25,'571','2022-03-16 19:40:41','614','2022-03-16 21:45:26',10,0),('1','171',257608,'MORNING SHIFT','2022-03-17','2022-03-17 14:32:38','2022-03-18 14:32:38','571',795050.85,795050.85,'571','2022-03-17 19:21:19','614','2022-03-17 19:45:47',10,0),('1','171',257609,'AFTERNOON SHIFT','2022-03-17','2022-03-17 21:21:16','2022-03-18 21:21:16','571',504860.40,504860.40,'571','2022-03-17 21:26:14','614','2022-03-17 22:39:36',10,0),('1','171',257610,'MORNING SHIFT','2022-03-18','2022-03-18 14:50:27','2022-03-19 14:50:27','571',957536.25,957536.25,'571','2022-03-18 15:23:00','614','2022-03-18 20:12:45',10,0),('1','171',257611,'AFTERNOON SHIFT','2022-03-18','2022-03-18 21:33:17','2022-03-19 21:33:17','571',386779.80,386779.80,'571','2022-03-18 21:47:59','614','2022-03-18 23:16:50',10,0),('1','171',257612,'MORNING SHIFT','2022-03-19','2022-03-19 15:13:33','2022-03-20 15:13:33','571',475204.95,475204.95,'571','2022-03-19 15:15:50','614','2022-03-19 15:31:47',10,0),('1','171',257613,'AFTERNOON SHIFT','2022-03-19','2022-03-19 20:41:13','2022-03-20 20:41:13','571',630601.95,630601.95,'571','2022-03-19 20:44:29','614','2022-03-19 22:18:41',10,0),('1','171',257614,'MORNING SHIFT','2022-03-20','2022-03-20 10:14:58','2022-03-21 10:14:58','571',548242.60,548242.60,'571','2022-03-20 14:52:25','614','2022-03-20 15:44:04',10,0),('1','171',257615,'Afternoon shift ','2022-03-20','2022-03-20 20:33:25','2022-03-21 20:33:25','571',431603.40,431603.40,'571','2022-03-20 21:14:51','614','2022-03-20 23:34:00',10,0),('1','171',257616,'MORNING SHIFT','2022-03-21','2022-03-21 14:26:29','2022-03-22 14:26:29','571',702089.35,702089.35,'571','2022-03-21 14:27:50','614','2022-03-21 14:58:08',10,0),('1','171',257617,'AFTERNOON SHIFT','2022-03-21','2022-03-21 21:00:17','2022-03-22 21:00:17','571',1206501.95,1206501.95,'571','2022-03-21 21:03:12','614','2022-03-22 06:11:00',10,0),('1','171',257618,'MORNING SHIFT','2022-03-22','2022-03-22 13:56:31','2022-03-23 13:56:31','571',1104576.95,1104576.95,'571','2022-03-22 13:59:18','614','2022-03-22 15:16:47',10,0),('1','171',257619,'AFTERNO0N SHIFT','2022-03-22','2022-03-22 18:20:43','2022-03-23 18:20:43','571',864415.00,864415.00,'571','2022-03-22 19:54:40','614','2022-03-22 20:46:54',10,0),('1','171',257620,'MORNING SHIFT','2022-03-23','2022-03-23 09:29:02','2022-03-24 09:29:02','571',541580.80,541580.80,'571','2022-03-23 14:42:42','614','2022-03-23 18:36:19',10,0),('1','171',257621,'AFTERNOON SHIFT','2022-03-23','2022-03-23 19:34:43','2022-03-24 19:34:43','571',819507.10,819507.10,'571','2022-03-23 19:39:20','614','2022-03-23 21:55:21',10,0),('1','171',257622,'MORNING SHIFT','2022-03-24','2022-03-24 17:08:29','2022-03-25 17:08:29','571',916405.45,916405.45,'571','2022-03-24 17:11:06','614','2022-03-24 17:18:02',10,0),('1','171',257623,'AFTERNOON SHIFT','2022-03-24','2022-03-24 20:11:26','2022-03-25 20:11:26','571',1271006.85,1271006.85,'571','2022-03-24 20:14:14','614','2022-03-25 07:23:01',10,0),('1','171',257624,'MORNING SHIFT','2022-03-25','2022-03-25 14:50:52','2022-03-26 14:50:52','571',1250703.10,1250703.10,'571','2022-03-25 14:55:20','614','2022-03-25 17:12:58',10,0),('1','171',257625,'AFTERNOON SHIFT','2022-03-25','2022-03-25 19:43:08','2022-03-26 19:43:08','571',958259.05,958259.05,'571','2022-03-25 19:46:02','614','2022-03-25 23:42:06',10,0),('1','171',257626,'MORNING SHIFT','2022-03-26','2022-03-26 14:50:05','2022-03-27 14:50:05','571',917051.60,917051.60,'571','2022-03-26 14:52:24','614','2022-03-26 15:00:07',10,0),('1','171',257627,'AFTERNOON SHIFT','2022-03-26','2022-03-26 19:17:23','2022-03-27 19:17:23','571',960709.40,960709.40,'571','2022-03-26 19:20:52','614','2022-03-26 23:34:18',10,0),('1','171',257628,'MORNING SHIFT','2022-03-27','2022-03-27 14:36:43','2022-03-28 14:36:43','571',1145392.85,1145392.85,'571','2022-03-27 14:38:36','614','2022-03-27 16:08:00',10,0),('1','171',257629,'AFTERNO0N SHIFT','2022-03-27','2022-03-27 18:25:15','2022-03-28 18:25:15','571',717094.90,717094.90,'571','2022-03-27 18:27:04','614','2022-03-27 23:00:34',10,0),('1','171',257630,'MORNING SHIFT','2022-03-28','2022-03-28 14:37:17','2022-03-29 14:37:17','571',1555672.20,1555672.20,'571','2022-03-28 14:40:59','614','2022-03-28 15:50:46',10,0),('1','171',257631,'AFTERNOON SHIFT','2022-03-28','2022-03-28 19:03:58','2022-03-29 19:03:58','571',1157165.90,1157165.90,'571','2022-03-28 19:06:31','614','2022-03-28 23:36:19',10,0),('1','171',257632,'MORNING SHIFT','2022-03-29','2022-03-29 11:10:35','2022-03-30 11:10:35','571',1534839.40,1534839.40,'571','2022-03-29 14:38:28','614','2022-03-29 17:13:38',10,0),('1','171',257633,'AFTERNOON SHIFT','2022-03-29','2022-03-29 19:07:21','2022-03-30 19:07:21','571',973674.70,973674.70,'571','2022-03-29 19:10:42','614','2022-03-29 21:49:35',10,0),('1','171',257634,'MORNING SHIFT','2022-03-30','2022-03-30 14:38:25','2022-03-31 14:38:25','571',719881.80,719881.80,'571','2022-03-30 14:42:24','614','2022-03-30 15:02:21',10,0),('1','171',257635,'AFTERNOON SHIFT','2022-03-30','2022-03-30 19:07:04','2022-03-31 19:07:04','571',2280941.40,2280941.40,'571','2022-03-30 19:11:17','614','2022-03-31 13:20:04',10,0),('1','171',257636,'MORNING SHIFT ','2022-03-31','2022-03-31 13:29:04','2022-04-01 13:29:04','571',3060433.00,3060433.00,'571','2022-03-31 13:36:39','614','2022-03-31 15:09:51',10,0),('1','171',257637,'AFTERNOON SHIFT','2022-03-31','2022-03-31 18:09:41','2022-04-01 18:09:41','571',994934.80,994934.80,'571','2022-03-31 18:11:33','614','2022-03-31 23:46:09',10,0),('1','171',257638,'MORNING SHIFT','2022-04-01','2022-04-01 11:23:37','2022-04-02 11:23:37','571',1136235.55,1136235.55,'571','2022-04-01 15:21:31','614','2022-04-01 17:30:49',10,0),('1','171',257639,'AFTERNOON SHIFT','2022-04-01','2022-04-01 18:07:16','2022-04-02 18:07:16','571',750531.90,750531.90,'571','2022-04-01 18:41:23','614','2022-04-01 22:35:50',10,0),('1','171',257640,'MORNING SHIFT','2022-04-02','2022-04-02 13:28:30','2022-04-03 13:28:30','571',629453.30,629453.30,'571','2022-04-02 14:50:27','614','2022-04-02 20:20:38',10,0),('1','171',257641,'AFTERNOON SHIFT','2022-04-02','2022-04-02 20:32:18','2022-04-03 20:32:18','571',1702597.30,1702597.30,'571','2022-04-02 20:35:17','614','2022-04-02 21:20:39',10,0),('1','171',257642,'MORNING SHIFT','2022-04-03','2022-04-03 13:36:35','2022-04-04 13:36:35','571',276619.90,276619.90,'571','2022-04-03 13:39:38','614','2022-04-03 14:58:50',10,0),('1','171',257643,'AFTERNOON SHIFT','2022-04-03','2022-04-03 21:08:09','2022-04-04 21:08:09','571',299309.85,299309.85,'571','2022-04-03 21:10:17','614','2022-04-03 23:19:08',10,0),('1','171',257644,'MORNING SHIFT','2022-04-04','2022-04-04 14:33:45','2022-04-05 14:33:45','571',369280.95,369280.95,'571','2022-04-04 14:35:52','614','2022-04-04 16:41:48',10,0),('1','171',257645,'AFTERNO0N SHIFT','2022-04-04','2022-04-04 18:02:40','2022-04-05 18:02:40','571',929551.30,929551.30,'571','2022-04-04 19:35:27','614','2022-04-05 13:47:54',10,0),('1','171',257646,'MORNING SHIFT','2022-04-05','2022-04-05 15:34:31','2022-04-06 15:34:31','571',504234.55,504234.55,'571','2022-04-05 16:47:46','614','2022-04-05 23:47:54',10,0),('1','171',257647,'AFTERNOON SHIFT','2022-04-05','2022-04-06 04:44:42','2022-04-07 04:44:42','571',1693728.00,1693728.00,'571','2022-04-06 04:48:27','614','2022-04-06 15:09:22',10,0),('1','171',257648,'MORNING SHIFT','2022-04-06','2022-04-06 15:42:10','2022-04-07 15:42:10','571',1504530.00,1504530.00,'571','2022-04-06 15:45:29','614','2022-04-06 20:42:03',10,0),('1','171',257649,'AFTERNOON SHIFT','2022-04-06','2022-04-06 23:27:01','2022-04-07 23:27:01','571',1364654.30,1364654.30,'571','2022-04-06 23:36:29','614','2022-04-07 06:16:42',10,0),('1','171',257650,'MORNING SHIFT','2022-04-07','2022-04-07 12:53:30','2022-04-08 12:53:30','571',1323765.35,1323765.35,'571','2022-04-07 14:47:41','614','2022-04-07 17:47:25',10,0),('1','171',257651,'AFTERNOON SHIFT','2022-04-07','2022-04-07 18:21:43','2022-04-08 18:21:43','571',740472.85,740472.85,'571','2022-04-07 18:30:37','614','2022-04-08 10:03:11',10,0),('1','171',257652,'MORNING SHIFT','2022-04-08','2022-04-08 10:45:51','2022-04-09 10:45:51','571',863608.00,863608.00,'571','2022-04-08 14:45:49','614','2022-04-08 17:10:41',10,0),('1','171',257653,'AFTERNOON SHIFT','2022-04-08','2022-04-08 18:13:50','2022-04-09 18:13:50','571',551282.90,551282.90,'571','2022-04-08 18:18:24','614','2022-04-08 23:47:25',10,0),('1','171',257654,'MORNING SHIFT','2022-04-09','2022-04-09 11:40:53','2022-04-10 11:40:53','571',1137890.10,1137890.10,'571','2022-04-09 14:49:38','614','2022-04-09 15:12:28',10,0),('1','171',257655,'AFTERNOON SHIFT','2022-04-09','2022-04-09 20:38:52','2022-04-10 20:38:52','571',1025113.20,1025113.20,'571','2022-04-09 20:41:40','614','2022-04-09 22:04:44',10,0),('1','171',257656,'MORNING SHIFT','2022-04-10','2022-04-10 14:00:54','2022-04-11 14:00:54','571',339444.60,339444.60,'571','2022-04-10 15:06:44','614','2022-04-10 16:24:49',10,0),('1','171',257657,'AFTERNOON SHIFT','2022-04-10','2022-04-10 17:29:26','2022-04-11 17:29:26','571',604563.30,604563.30,'571','2022-04-10 17:31:18','614','2022-04-10 22:25:25',10,0),('1','171',257658,'MORNING SHIFT','2022-04-11','2022-04-11 11:51:55','2022-04-12 11:51:55','571',501925.05,501925.05,'571','2022-04-11 13:42:30','614','2022-04-11 15:09:57',10,0),('1','171',257659,'AFTERNOON SHIFT','2022-04-11','2022-04-11 18:25:24','2022-04-12 18:25:24','571',989780.55,989780.55,'571','2022-04-11 18:26:46','614','2022-04-11 18:57:12',10,0),('1','171',257660,'MORNING SHIFT','2022-04-12','2022-04-12 12:46:31','2022-04-13 12:46:31','571',570543.60,570543.60,'571','2022-04-12 13:54:24','614','2022-04-12 16:38:09',10,0),('1','171',257661,'AFTERNOON SHIFT','2022-04-12','2022-04-12 17:41:56','2022-04-13 17:41:56','571',696898.95,696898.95,'571','2022-04-12 17:43:46','614','2022-04-13 12:49:01',10,0),('1','171',257662,'AFTERNOON SHIFT','2022-04-13','2022-04-13 16:41:40','2022-04-14 16:41:40','571',74357.25,74357.25,'571','2022-04-13 16:43:34','614','2022-04-13 21:37:07',10,0),('1','171',257663,'MORNING SHIFT','2022-04-14','2022-04-14 13:51:29','2022-04-15 13:51:29','571',16823.40,16823.40,'571','2022-04-14 13:53:39','614','2022-04-14 14:36:49',10,0),('1','171',257664,'AFTERNOON SHIFT','2022-04-14','2022-04-14 20:53:09','2022-04-15 20:53:09','571',40880.40,40880.40,'571','2022-04-14 20:55:34','614','2022-04-14 21:10:14',10,0),('1','171',257665,'MORNING SHIFT','2022-04-15','2022-04-15 14:42:02','2022-04-16 14:42:02','571',659158.50,659158.50,'571','2022-04-15 14:49:06','614','2022-04-15 14:52:35',10,0),('1','171',257666,'AFTERNO0N SHIFT','2022-04-15','2022-04-15 16:44:23','2022-04-16 16:44:23','571',506634.15,506634.15,'571','2022-04-15 16:53:30','614','2022-04-15 22:00:38',10,0),('1','171',257667,'MORNING SHIFT','2022-04-16','2022-04-16 12:12:19','2022-04-17 12:12:19','571',437056.95,437056.95,'571','2022-04-16 14:18:23','614','2022-04-16 15:00:19',10,0),('1','171',257668,'AFTERNOON SHIFT','2022-04-16','2022-04-16 17:42:23','2022-04-17 17:42:23','571',90136.20,90136.20,'571','2022-04-16 17:45:09','614','2022-04-17 05:40:10',10,0),('1','171',257669,'MORNING SHIFT','2022-04-17','2022-04-17 07:42:26','2022-04-18 07:42:26','571',220776.60,220776.60,'571','2022-04-17 14:56:40','614','2022-04-17 17:08:14',10,0),('1','171',257670,'AFTERNOON SHIFT','2022-04-17','2022-04-17 17:58:36','2022-04-18 17:58:36','571',318139.80,318139.80,'571','2022-04-17 18:01:06','614','2022-04-17 21:32:48',10,0),('1','171',257671,'MORNING SHIFT','2022-04-18','2022-04-18 08:18:40','2022-04-19 08:18:40','571',71344.35,71344.35,'571','2022-04-18 13:21:37','614','2022-04-18 14:48:54',10,0),('1','171',257672,'AFTERNOON SHIFT','2022-04-18','2022-04-18 17:19:21','2022-04-19 17:19:21','571',93657.30,93657.30,'571','2022-04-18 17:21:51','614','2022-04-18 21:56:06',10,0),('1','171',257673,'MORNING SHIFT','2022-04-20','2022-04-20 10:28:43','2022-04-21 10:28:43','571',66123.75,66123.75,'571','2022-04-20 15:13:16','614','2022-04-20 16:48:59',10,0),('1','171',257674,'AFTERNOON SHIFT','2022-04-20','2022-04-20 20:46:25','2022-04-21 20:46:25','571',713258.70,713258.70,'571','2022-04-20 21:03:41','614','2022-04-20 22:06:38',10,0),('1','171',257675,'MORNING SHIFT','2022-04-21','2022-04-21 15:23:59','2022-04-22 15:23:59','571',569820.90,569820.90,'571','2022-04-21 15:25:43','614','2022-04-21 16:47:32',10,0),('1','171',257676,'AFTERNOON SHIFT','2022-04-21','2022-04-21 20:01:31','2022-04-22 20:01:31','571',919003.80,919003.80,'571','2022-04-21 20:03:32','614','2022-04-21 20:56:40',10,0),('1','171',257677,'MORNING SHIFT','2022-04-22','2022-04-22 14:23:14','2022-04-23 14:23:14','571',761674.65,761674.65,'571','2022-04-22 14:31:14','614','2022-04-22 15:08:00',10,0),('1','171',257678,'AFTERNO0N SHIFT','2022-04-22','2022-04-22 16:36:20','2022-04-23 16:36:20','571',723226.35,723226.35,'571','2022-04-22 18:35:04','614','2022-04-22 22:44:59',10,0),('1','171',257679,'MORNING SHIFT','2022-04-23','2022-04-23 14:22:46','2022-04-24 14:22:46','571',1166032.80,1166032.80,'571','2022-04-23 14:25:20','614','2022-04-23 14:54:50',10,0),('1','171',257680,'AFTERNOON SHIFT','2022-04-23','2022-04-23 17:17:03','2022-04-24 17:17:03','571',1022684.15,1022684.15,'571','2022-04-23 20:55:55','614','2022-04-23 23:32:38',10,0),('1','171',257681,'MORNING SHIFT','2022-04-24','2022-04-24 14:14:00','2022-04-25 14:14:00','571',632239.80,632239.80,'571','2022-04-24 14:17:51','614','2022-04-24 15:29:05',10,0),('1','171',257682,'AFTERNOON SHIFT','2022-04-24','2022-04-24 21:03:45','2022-04-25 21:03:45','571',1197072.00,1197072.00,'571','2022-04-24 21:07:10','614','2022-04-24 23:17:07',10,0),('1','171',257683,'MORNING SHIFT','2022-04-25','2022-04-25 11:34:14','2022-04-26 11:34:14','571',948081.40,948081.40,'571','2022-04-25 14:29:23','614','2022-04-25 16:10:44',10,0),('1','171',257684,'AFTERNOON SHIFT','2022-04-25','2022-04-25 21:55:36','2022-04-26 21:55:36','571',1151530.85,1151530.85,'571','2022-04-25 21:59:08','614','2022-04-25 23:45:15',10,0),('1','171',257685,'MORNING SHIFT','2022-04-26','2022-04-26 13:51:46','2022-04-27 13:51:46','571',1122222.70,1122222.70,'571','2022-04-26 13:53:52','614','2022-04-26 21:22:22',10,0),('1','171',257686,'AFTERNOON SHIFT','2022-04-26','2022-04-26 23:40:42','2022-04-27 23:40:42','571',1383473.85,1383473.85,'571','2022-04-26 23:45:46','614','2022-04-27 04:31:53',10,0),('1','171',257687,'MORNING SHIFT','2022-04-27','2022-04-27 13:46:54','2022-04-28 13:46:54','571',1839142.65,1839142.65,'571','2022-04-27 13:49:11','614','2022-04-27 16:00:07',10,0),('1','171',257688,'AFTERNOON SHIFT','2022-04-27','2022-04-27 21:50:01','2022-04-28 21:50:01','571',3249141.30,3249141.30,'571','2022-04-27 21:57:11','614','2022-04-28 10:31:40',10,0),('1','171',257689,'MORNING SHIFT','2022-04-28','2022-04-28 13:59:02','2022-04-29 13:59:02','571',956706.90,956706.90,'571','2022-04-28 14:00:53','614','2022-04-28 14:35:30',10,0),('1','171',257690,'AFTERNOO SHIFT','2022-04-28','2022-04-28 17:44:36','2022-04-29 17:44:36','571',2509628.00,2509628.00,'571','2022-04-28 21:43:48','614','2022-04-28 22:08:14',10,0),('1','171',257691,'MORNING SHIFT','2022-04-29','2022-04-29 07:19:51','2022-04-30 07:19:51','571',1651560.60,1651560.60,'571','2022-04-29 13:38:30','614','2022-04-29 14:56:49',10,0),('1','171',257692,'AFTERNOON. SHIFT','2022-04-29','2022-04-29 18:24:04','2022-04-30 18:24:04','571',1643892.15,1643892.15,'571','2022-04-29 21:01:05','614','2022-04-29 22:10:43',10,0),('1','171',257693,'MORNING SHIFT','2022-04-30','2022-04-30 05:08:19','2022-05-01 05:08:19','571',1404033.35,1404033.35,'571','2022-04-30 14:21:54','614','2022-04-30 18:18:27',10,0),('1','171',257694,'AFTERNO0N SHIFT','2022-04-30','2022-04-30 18:25:59','2022-05-01 18:25:59','571',650366.40,650366.40,'571','2022-05-01 10:12:53','614','2022-05-01 15:05:24',10,0),('1','171',257695,'MORNING SHIFT','2022-05-01','2022-05-01 15:14:38','2022-05-02 15:14:38','571',73008.00,73008.00,'571','2022-05-01 16:40:21','614','2022-05-02 00:31:15',10,0),('1','171',257696,'AFTERNOON SHIFT','2022-05-01','2022-05-02 05:31:55','2022-05-03 05:31:55','571',689611.00,689611.00,'571','2022-05-02 05:34:24','614','2022-05-02 14:44:22',10,0),('1','171',257697,'MORNING SHIFT','2022-05-02','2022-05-02 16:52:20','2022-05-03 16:52:20','571',1197739.70,1197739.70,'571','2022-05-02 16:59:33','614','2022-05-03 10:11:13',10,0),('1','171',257698,'AFTERNOON SHIFT','2022-05-02','2022-05-03 10:19:32','2022-05-04 10:19:32','571',1209295.90,1209295.90,'571','2022-05-03 10:47:38','614','2022-05-03 15:26:37',10,0),('1','171',257699,'MORNING SHIFT','2022-05-03','2022-05-03 15:38:32','2022-05-04 15:38:32','571',1222190.00,1222190.00,'571','2022-05-03 15:40:59','614','2022-05-03 23:44:11',10,0),('1','171',257700,'AFTERNOON SHIFT','2022-05-03','2022-05-04 05:22:16','2022-05-05 05:22:16','571',1906664.50,1906664.50,'571','2022-05-04 05:42:40','614','2022-05-04 15:46:35',10,0),('1','171',257701,'MORNING SHIFT','2022-05-04','2022-05-04 17:34:52','2022-05-05 17:34:52','571',1069060.05,1069060.05,'571','2022-05-04 17:57:24','614','2022-05-04 22:36:58',10,0),('1','171',257702,'AFTERNOO SHIFT','2022-05-04','2022-05-04 23:16:34','2022-05-05 23:16:34','571',1473488.70,1473488.70,'571','2022-05-05 06:00:47','614','2022-05-05 19:14:08',10,0),('1','171',257703,'MORNING SHIFT','2022-05-05','2022-05-05 20:18:24','2022-05-06 20:18:24','571',775465.35,775465.35,'571','2022-05-05 20:27:27','614','2022-05-06 01:00:01',10,0),('1','171',257704,'AFTERNOON SHIFT','2022-05-05','2022-05-06 04:13:47','2022-05-07 04:13:47','571',1638852.30,1638852.30,'571','2022-05-06 04:26:04','614','2022-05-06 15:04:35',10,0),('1','171',257705,'MORNING SHIFT','2022-05-06','2022-05-06 17:17:53','2022-05-07 17:17:53','571',837485.55,837485.55,'571','2022-05-06 17:42:43','614','2022-05-06 23:18:57',10,0),('1','171',257706,'AFTERNOON SHIFT','2022-05-07','2022-05-07 06:33:47','2022-05-08 06:33:47','571',1581660.70,1581660.70,'571','2022-05-07 06:39:34','614','2022-05-07 06:41:45',10,0),('1','171',257707,'MORNING SHIFT','2022-05-07','2022-05-07 10:55:52','2022-05-08 10:55:52','571',526302.15,526302.15,'571','2022-05-07 14:41:22','614','2022-05-07 17:57:29',10,0),('1','171',257708,'AFTERNOON SHIFT','2022-05-07','2022-05-07 23:18:43','2022-05-08 23:18:43','571',1126895.55,1126895.55,'571','2022-05-07 23:22:33','614','2022-05-07 23:26:11',10,0),('1','171',257709,'MORNING SHIFT','2022-05-08','2022-05-08 07:49:44','2022-05-09 07:49:44','571',851845.50,851845.50,'571','2022-05-08 14:21:30','614','2022-05-08 15:56:53',10,0),('1','171',257710,'AFTERNOON SHIFT','2022-05-08','2022-05-08 20:07:42','2022-05-09 20:07:42','571',1042545.90,1042545.90,'571','2022-05-08 20:14:16','614','2022-05-08 21:09:31',10,0),('1','171',257711,'MORNING SHIFT','2022-05-09','2022-05-09 07:26:29','2022-05-10 07:26:29','571',760778.70,760778.70,'571','2022-05-09 13:51:56','614','2022-05-09 14:18:42',10,0),('1','171',257712,'AFTERNOON SHIFT','2022-05-09','2022-05-09 18:15:20','2022-05-10 18:15:20','571',980436.60,980436.60,'571','2022-05-09 21:19:11','614','2022-05-09 22:04:59',10,0),('1','171',257713,'MORNING SHIFT','2022-05-10','2022-05-10 06:45:37','2022-05-11 06:45:37','571',1076306.55,1076306.55,'571','2022-05-10 14:49:39','614','2022-05-10 15:53:28',10,0),('1','171',257714,'AFTERNOON SHIFT','2022-05-10','2022-05-10 21:01:47','2022-05-11 21:01:47','571',1284406.20,1284406.20,'571','2022-05-10 21:12:33','614','2022-05-10 21:21:24',10,0),('1','171',257715,'MORNING SHIFT','2022-05-11','2022-05-11 07:31:56','2022-05-12 07:31:56','571',900446.25,900446.25,'571','2022-05-11 14:12:59','614','2022-05-11 15:26:27',10,0),('1','171',257716,'AFTERNOON SHIFT','2022-05-11','2022-05-11 21:13:45','2022-05-12 21:13:45','571',1210534.05,1210534.05,'571','2022-05-11 21:16:10','614','2022-05-12 02:02:10',10,0),('1','171',257717,'MORNING SHIFT','2022-05-12','2022-05-12 07:49:56','2022-05-13 07:49:56','571',1334595.90,1334595.90,'571','2022-05-12 14:28:53','614','2022-05-12 17:00:43',10,0),('1','171',257718,'AFTERNOON SHIFT','2022-05-12','2022-05-12 20:40:51','2022-05-13 20:40:51','571',1739002.65,1739002.65,'571','2022-05-12 20:44:12','614','2022-05-12 23:43:29',10,0),('1','171',257719,'MORNING SHIFT','2022-05-13','2022-05-13 06:24:00','2022-05-14 06:24:00','571',676009.95,676009.95,'571','2022-05-13 14:55:29','614','2022-05-13 15:51:18',10,0),('1','171',257720,'AFTERNO0N SHIFT','2022-05-13','2022-05-13 17:22:37','2022-05-14 17:22:37','571',1849176.45,1849176.45,'571','2022-05-13 20:53:01','614','2022-05-13 21:45:50',10,0),('1','171',257721,'MORNING SHIFT','2022-05-14','2022-05-14 06:43:43','2022-05-15 06:43:43','571',1455130.05,1455130.05,'571','2022-05-14 15:18:05','614','2022-05-14 17:03:53',10,0),('1','171',257722,'AFTERNOON SHIFT','2022-05-14','2022-05-14 21:25:27','2022-05-15 21:25:27','571',1356783.45,1356783.45,'571','2022-05-14 21:29:26','614','2022-05-14 23:38:05',10,0),('1','171',257723,'MORNING SHIFT','2022-05-15','2022-05-15 07:07:02','2022-05-16 07:07:02','571',642483.60,642483.60,'571','2022-05-15 14:15:19','614','2022-05-15 16:36:48',10,0),('1','171',257724,'AFTERNOON SHIFT','2022-05-15','2022-05-15 20:26:09','2022-05-16 20:26:09','571',824460.45,824460.45,'571','2022-05-15 20:29:08','614','2022-05-15 21:58:53',10,0),('1','171',257725,'MORNING SHIFT','2022-05-16','2022-05-16 07:24:58','2022-05-17 07:24:58','571',385859.10,385859.10,'571','2022-05-16 14:26:31','614','2022-05-16 15:24:21',10,0),('1','171',257726,'AFTERNOON SHIFT','2022-05-16','2022-05-16 21:03:01','2022-05-17 21:03:01','571',1337813.40,1337813.40,'571','2022-05-16 21:05:26','614','2022-05-16 21:47:51',10,0),('1','171',257727,'MORNING SHIFT','2022-05-17','2022-05-17 06:55:25','2022-05-18 06:55:25','571',758166.75,758166.75,'571','2022-05-17 14:20:19','614','2022-05-17 15:29:54',10,0),('1','171',257728,'AFTERNOON SHIFT','2022-05-17','2022-05-17 21:04:01','2022-05-18 21:04:01','571',1347196.95,1347196.95,'571','2022-05-17 21:10:40','614','2022-05-17 23:28:10',10,0),('1','171',257729,'MORNING SHIFT','2022-05-18','2022-05-18 07:06:39','2022-05-19 07:06:39','571',973531.35,973531.35,'571','2022-05-18 14:19:41','614','2022-05-18 18:42:51',10,0),('1','171',257730,'AFTERNOON SHIFT','2022-05-18','2022-05-18 20:29:39','2022-05-19 20:29:39','571',1639898.70,1639898.70,'571','2022-05-18 20:33:15','614','2022-05-18 23:30:45',10,0),('1','171',257731,'MORNING SHIFT','2022-05-19','2022-05-19 07:05:08','2022-05-20 07:05:08','571',946327.80,946327.80,'571','2022-05-19 15:27:45','614','2022-05-19 21:48:36',10,0),('1','171',257732,'AFTERNOON SHIFT','2022-05-19','2022-05-19 22:17:46','2022-05-20 22:17:46','571',1057331.55,1057331.55,'571','2022-05-19 22:21:26','614','2022-05-19 22:57:30',10,0),('1','171',257733,'MORNING SHIFT','2022-05-20','2022-05-20 06:38:13','2022-05-21 06:38:13','571',1054990.20,1054990.20,'571','2022-05-20 15:20:02','614','2022-05-20 17:23:05',10,0),('1','171',257734,'AFTERNOON SHIFT','2022-05-20','2022-05-20 18:46:02','2022-05-21 18:46:02','571',758209.65,758209.65,'571','2022-05-20 18:48:21','614','2022-05-20 22:04:24',10,0),('1','171',257735,'MORNING SHIFT','2022-05-21','2022-05-21 06:47:14','2022-05-22 06:47:14','571',140680.65,140680.65,'571','2022-05-21 14:05:09','614','2022-05-21 14:53:55',10,0),('1','171',257736,'AFTERNOON SHIFT','2022-05-21','2022-05-21 20:41:32','2022-05-22 20:41:32','571',1725000.75,1725000.75,'571','2022-05-21 20:46:03','614','2022-05-21 21:19:07',10,0),('1','171',257737,'MORNING SHIFT','2022-05-22','2022-05-22 06:50:25','2022-05-23 06:50:25','571',485382.15,485382.15,'571','2022-05-22 13:51:58','614','2022-05-22 14:47:30',10,0),('1','171',257738,'AFTERNOON SHIFT','2022-05-22','2022-05-22 20:25:24','2022-05-23 20:25:24','571',493292.25,493292.25,'571','2022-05-22 20:33:02','614','2022-05-22 22:56:25',10,0),('1','171',257739,'MORNING SHIFT','2022-05-23','2022-05-23 08:16:41','2022-05-24 08:16:41','571',80506.80,80506.80,'571','2022-05-23 15:12:46','614','2022-05-23 15:34:52',10,0),('1','171',257740,'MORNING SHIFT','2022-05-25','2022-05-25 16:15:56','2022-05-26 16:15:56','571',509935.80,509935.80,'571','2022-05-25 20:20:08','614','2022-05-25 21:55:29',10,0),('1','171',257741,'AFTERNOON SHIFT','2022-05-25','2022-05-25 22:10:48','2022-05-26 22:10:48','571',900260.35,900260.35,'571','2022-05-25 22:16:13','614','2022-05-26 08:07:50',10,0),('1','171',257742,'MORNING SHIFT','2022-05-26','2022-05-26 13:24:38','2022-05-27 13:24:38','571',1810693.85,1810693.85,'571','2022-05-26 13:29:30','614','2022-05-26 14:34:51',10,0),('1','171',257743,'AFTERNOON SHIFT','2022-05-26','2022-05-26 20:09:50','2022-05-27 20:09:50','571',1343763.55,1343763.55,'571','2022-05-26 20:20:09','614','2022-05-26 21:17:27',10,0),('1','171',257744,'MORNING SHIFT','2022-05-27','2022-05-27 07:02:02','2022-05-28 07:02:02','571',1028338.15,1028338.15,'571','2022-05-27 14:08:49','614','2022-05-27 15:03:27',10,0),('1','171',257745,'AFTERNOON SHIFT','2022-05-27','2022-05-27 19:36:13','2022-05-28 19:36:13','571',211998.15,211998.15,'571','2022-05-27 19:37:43','614','2022-05-28 06:34:11',10,0),('1','171',257746,'MORNING SHIFT','2022-05-28','2022-05-28 07:11:27','2022-05-29 07:11:27','571',335562.45,335562.45,'571','2022-05-28 13:52:39','614','2022-05-28 15:21:41',10,0),('1','171',257747,'AFTERNOON SHIFT','2022-05-28','2022-05-28 20:03:06','2022-05-29 20:03:06','571',106880.10,106880.10,'571','2022-05-28 20:05:28','614','2022-05-28 23:36:04',10,0),('1','171',257748,'AFTERNOO SHIFT','2022-05-29','2022-05-29 08:09:14','2022-05-30 08:09:14','571',421256.30,421256.30,'571','2022-05-29 13:31:47','614','2022-05-29 15:53:11',10,0),('1','171',257749,'AFTERNOON SHIFT','2022-05-29','2022-05-29 19:21:29','2022-05-30 19:21:29','571',94706.15,94706.15,'571','2022-05-29 19:23:46','614','2022-05-30 10:28:48',10,0),('1','171',257750,'MORNING SHIFT','2022-05-30','2022-05-30 13:00:13','2022-05-31 13:00:13','571',171958.45,171958.45,'571','2022-05-30 13:11:57','614','2022-05-30 15:29:57',10,0),('1','171',257751,'AFTERNOON SHIFT','2022-05-30','2022-05-30 19:46:35','2022-05-31 19:46:35','571',142935.85,142935.85,'571','2022-05-30 19:48:38','614','2022-05-30 22:21:14',10,0),('1','171',257752,'MORNING SHIFT','2022-05-31','2022-05-31 13:02:36','2022-06-01 13:02:36','571',424085.45,424085.45,'571','2022-05-31 13:47:50','614','2022-05-31 13:49:19',10,0),('1','171',257753,'AFTERNOON SHIFT','2022-05-31','2022-05-31 19:44:00','2022-06-01 19:44:00','571',467726.95,467726.95,'571','2022-05-31 19:45:56','614','2022-05-31 20:48:17',10,0),('1','171',257754,'AFTERNOON SHIFT','2022-06-01','2022-06-01 08:09:32','2022-06-02 08:09:32','571',401737.55,401737.55,'571','2022-06-01 13:33:34','614','2022-06-01 19:52:35',10,0),('1','171',257755,'AFTERNOON SHIFT','2022-06-01','2022-06-01 20:29:06','2022-06-02 20:29:06','571',861363.20,861363.20,'571','2022-06-01 22:00:28','614','2022-06-01 22:51:22',10,0),('1','171',257756,'AFTERNOO SHIFT','2022-06-02','2022-06-02 08:06:48','2022-06-03 08:06:48','571',1806237.10,1806237.10,'571','2022-06-02 13:40:08','614','2022-06-02 18:21:40',10,0),('1','171',257757,'AFTERNO0N SHIFT','2022-06-02','2022-06-02 19:47:15','2022-06-03 19:47:15','571',2016513.55,2016513.55,'571','2022-06-02 21:47:07','614','2022-06-03 06:35:43',10,0),('1','171',257758,'MORNING SHIFT','2022-06-03','2022-06-03 07:04:14','2022-06-04 07:04:14','571',1331368.45,1331368.45,'571','2022-06-03 13:22:21','614','2022-06-03 15:18:14',10,0),('1','171',257759,'AFTERNOON SHIFT','2022-06-03','2022-06-03 21:02:17','2022-06-04 21:02:17','571',1346995.60,1346995.60,'571','2022-06-03 21:06:49','614','2022-06-03 22:16:08',10,0),('1','171',257760,'MORNING SHIFTq','2022-06-04','2022-06-04 06:39:22','2022-06-05 06:39:22','571',1181946.65,1181946.65,'571','2022-06-04 14:34:10','614','2022-06-04 15:16:45',10,0),('1','171',257761,'AFTERNOON SHIFT','2022-06-04','2022-06-04 21:13:01','2022-06-05 21:13:01','571',1701552.10,1701552.10,'571','2022-06-04 21:23:00','614','2022-06-04 21:54:26',10,0),('1','171',257762,'MORNING SHIFT','2022-06-05','2022-06-05 07:11:42','2022-06-06 07:11:42','571',719512.45,719512.45,'571','2022-06-05 13:27:53','614','2022-06-05 13:53:59',10,0),('1','171',257763,'AFTERNOON SHIFT','2022-06-05','2022-06-05 20:49:04','2022-06-06 20:49:04','571',1024368.05,1024368.05,'571','2022-06-05 20:54:06','614','2022-06-05 20:56:54',10,0),('1','171',257764,'MORNING SHIFT','2022-06-06','2022-06-06 06:19:43','2022-06-07 06:19:43','571',1008611.25,1008611.25,'571','2022-06-06 13:53:19','614','2022-06-06 14:48:55',10,0),('1','171',257765,'AFTERNOON SHIFT','2022-06-06','2022-06-06 21:45:18','2022-06-07 21:45:18','571',2574375.00,2574375.00,'571','2022-06-06 21:48:45','614','2022-06-06 22:42:40',10,0),('1','171',257766,'AFTERNOO SHIFT','2022-06-07','2022-06-07 10:34:24','2022-06-08 10:34:24','571',0.00,0.00,'426','2022-06-07 10:55:02','426','2022-06-07 10:55:23',10,0),('1','171',257767,'MORNING SHIFT','2022-06-07','2022-06-07 10:57:04','2022-06-08 10:57:04','571',855056.20,855056.20,'571','2022-06-07 14:12:27','614','2022-06-07 16:00:25',10,0),('1','171',257768,'AFTERNOON SHIFT','2022-06-07','2022-06-07 21:18:31','2022-06-08 21:18:31','571',1968184.05,1968184.05,'571','2022-06-07 21:23:08','614','2022-06-07 23:09:11',10,0),('1','171',257769,'MORNING SHIFT','2022-06-08','2022-06-08 07:37:16','2022-06-09 07:37:16','571',1467217.05,1467217.05,'571','2022-06-08 15:02:29','614','2022-06-08 15:25:35',10,0),('1','171',257770,'AFTERNOON SHIFT','2022-06-08','2022-06-08 16:27:57','2022-06-09 16:27:57','571',3226945.70,3226945.70,'571','2022-06-08 21:43:01','614','2022-06-08 23:38:16',10,0),('1','171',257771,'MORNING SHIFT','2022-06-09','2022-06-09 08:13:02','2022-06-10 08:13:02','571',1225787.10,1225787.10,'571','2022-06-09 14:28:58','614','2022-06-09 15:07:48',10,0),('1','171',257772,'AFTERNOON SHIFT','2022-06-09','2022-06-09 20:24:30','2022-06-10 20:24:30','571',2037590.80,2037590.80,'571','2022-06-09 20:28:00','614','2022-06-09 22:38:59',10,0),('1','171',257773,'MORNING SHIFT','2022-06-10','2022-06-10 06:48:08','2022-06-11 06:48:08','571',1862604.95,1862604.95,'571','2022-06-10 13:44:09','614','2022-06-10 14:58:32',10,0),('1','171',257774,'AFTERNOON SHIFT','2022-06-10','2022-06-10 16:02:31','2022-06-11 16:02:31','571',903413.05,903413.05,'571','2022-06-10 21:09:54','614','2022-06-10 22:38:46',10,0),('1','171',257775,'MORNING SHIFT','2022-06-11','2022-06-11 00:55:22','2022-06-12 00:55:22','571',267791.20,267791.20,'571','2022-06-11 09:27:37','614','2022-06-11 11:33:59',10,0),('1','171',257776,'MORNING SHIFT','2022-06-11','2022-06-11 14:16:36','2022-06-12 14:16:36','571',1111970.40,1111970.40,'571','2022-06-11 14:22:01','614','2022-06-11 14:41:58',10,0),('1','171',257777,'AFTERNOON SHIFT','2022-06-11','2022-06-11 20:44:41','2022-06-12 20:44:41','571',1697115.60,1697115.60,'571','2022-06-11 20:47:21','614','2022-06-11 21:08:03',10,0),('1','171',257778,'MORNING SHIFT','2022-06-12','2022-06-12 07:33:22','2022-06-13 07:33:22','571',982707.90,982707.90,'571','2022-06-12 14:17:11','614','2022-06-12 16:29:56',10,0),('1','171',257779,'AFTERNOON SHIFT','2022-06-12','2022-06-12 21:04:46','2022-06-13 21:04:46','571',1305858.60,1305858.60,'571','2022-06-12 21:08:04','614','2022-06-12 23:06:14',10,0),('1','171',257780,'MORNING SHIFT','2022-06-13','2022-06-13 06:38:05','2022-06-14 06:38:05','571',1352086.05,1352086.05,'571','2022-06-13 14:15:04','614','2022-06-13 14:37:05',10,0),('1','171',257781,'AFTERNOON SHIFT','2022-06-13','2022-06-13 20:37:02','2022-06-14 20:37:02','571',1456668.30,1456668.30,'571','2022-06-13 20:39:36','614','2022-06-13 22:06:27',10,0),('1','171',257782,'MORNING SHIFT','2022-06-14','2022-06-14 07:16:59','2022-06-15 07:16:59','571',1966877.25,1966877.25,'571','2022-06-14 13:56:34','614','2022-06-14 14:34:43',10,0),('1','171',257783,'AFTERNOON SHIFT','2022-06-14','2022-06-14 18:48:10','2022-06-15 18:48:10','571',1198277.25,1198277.25,'571','2022-06-14 22:39:55','614','2022-06-14 22:41:05',10,0),('1','171',257784,'MORNING SHIFT','2022-06-15','2022-06-15 06:27:43','2022-06-16 06:27:43','571',1621813.05,1621813.05,'571','2022-06-15 14:30:04','614','2022-06-15 15:07:24',10,0),('1','171',257785,'AFTERNOON SHIFT','2022-06-15','2022-06-15 19:01:18','2022-06-16 19:01:18','571',639973.35,639973.35,'571','2022-06-15 19:22:22','614','2022-06-15 23:29:06',10,0),('1','171',257786,'MORNING SHIFT','2022-06-16','2022-06-16 08:17:34','2022-06-17 08:17:34','571',715742.70,715742.70,'571','2022-06-16 14:15:07','614','2022-06-16 15:48:45',10,0),('1','171',257787,'AFTERNOON SHIFT','2022-06-16','2022-06-16 21:17:33','2022-06-17 21:17:33','571',2249153.85,2249153.85,'571','2022-06-16 21:21:53','614','2022-06-16 22:26:32',10,0),('1','171',257788,'MORNING SHIFT','2022-06-17','2022-06-17 07:26:32','2022-06-18 07:26:32','571',1688857.50,1688857.50,'571','2022-06-17 14:53:52','614','2022-06-17 15:16:26',10,0),('1','171',257789,'AFTERNOON SHIFT','2022-06-17','2022-06-17 17:49:19','2022-06-18 17:49:19','571',980883.75,980883.75,'571','2022-06-17 17:52:07','614','2022-06-18 12:36:11',10,0),('1','171',257790,'MORNING SHIFT','2022-06-18','2022-06-18 13:08:10','2022-06-19 13:08:10','571',1112503.20,1112503.20,'571','2022-06-18 13:33:16','614','2022-06-18 14:47:40',10,0),('1','171',257791,'AFTERNOON SHIFT','2022-06-18','2022-06-18 18:30:08','2022-06-19 18:30:08','571',1277142.30,1277142.30,'571','2022-06-18 18:33:06','614','2022-06-18 20:34:06',10,0),('1','171',257792,'MORNING SHIFT','2022-06-19','2022-06-19 06:31:19','2022-06-20 06:31:19','571',33386.10,33386.10,'571','2022-06-19 13:36:16','614','2022-06-19 15:49:57',10,0),('1','171',257793,'AFTERNOON SHIFT','2022-06-19','2022-06-19 17:49:48','2022-06-20 17:49:48','571',55027.50,55027.50,'571','2022-06-19 17:57:47','614','2022-06-20 10:55:17',10,0),('1','171',257794,'MORNING SHIFT','2022-06-20','2022-06-20 11:37:52','2022-06-21 11:37:52','571',68923.80,68923.80,'571','2022-06-20 12:59:42','614','2022-06-20 13:58:24',10,0),('1','171',257795,'AFTERNOON SHIFT','2022-06-20','2022-06-20 20:12:57','2022-06-21 20:12:57','571',404200.50,404200.50,'571','2022-06-20 20:15:19','614','2022-06-20 23:04:21',10,0),('1','171',257796,'MORNING SHIFT','2022-06-21','2022-06-21 06:53:22','2022-06-22 06:53:22','571',545563.20,545563.20,'571','2022-06-21 13:49:05','614','2022-06-21 18:56:29',10,0),('1','171',257797,'AFTERNOO SHIFT','2022-06-21','2022-06-21 19:19:07','2022-06-22 19:19:07','571',2409115.80,2409115.80,'571','2022-06-21 20:17:06','614','2022-06-22 06:54:57',10,0),('1','171',257798,'MORNING SHIFT','2022-06-22','2022-06-22 14:18:03','2022-06-23 14:18:03','571',1969687.35,1969687.35,'571','2022-06-22 14:20:02','614','2022-06-22 18:55:55',10,0),('1','171',257799,'AFTERNOON SHIFT','2022-06-22','2022-06-22 20:25:24','2022-06-23 20:25:24','571',1583560.95,1583560.95,'571','2022-06-22 20:28:55','614','2022-06-22 23:50:21',10,0),('1','171',257800,'MORNING SHIFT','2022-06-23','2022-06-23 06:32:07','2022-06-24 06:32:07','571',1825049.55,1825049.55,'571','2022-06-23 13:27:40','614','2022-06-23 14:20:49',10,0),('1','171',257801,'AFTERNOON SHIFT','2022-06-23','2022-06-23 20:42:28','2022-06-24 20:42:28','571',2622685.65,2622685.65,'571','2022-06-23 20:47:16','614','2022-06-23 21:08:37',10,0),('1','171',257802,'MORNING SHIFT','2022-06-24','2022-06-24 07:17:34','2022-06-25 07:17:34','571',2128961.10,2128961.10,'571','2022-06-24 15:00:15','614','2022-06-24 15:13:36',10,0),('1','171',257803,'AFTERNOON SHIFT','2022-06-24','2022-06-24 19:43:12','2022-06-25 19:43:12','571',1681912.05,1681912.05,'571','2022-06-24 19:49:38','614','2022-06-24 23:32:24',10,0),('1','171',257804,'MORNING SHIFT','2022-06-25','2022-06-25 07:09:37','2022-06-26 07:09:37','571',638657.55,638657.55,'571','2022-06-25 13:40:42','614','2022-06-25 14:35:40',10,0),('1','171',257805,'AFTERNOON SHIFT','2022-06-25','2022-06-25 19:32:31','2022-06-26 19:32:31','571',617061.60,617061.60,'571','2022-06-25 19:34:41','614','2022-06-26 11:57:33',10,0),('1','171',257806,'MORNING SHIFT','2022-06-26','2022-06-26 12:36:40','2022-06-27 12:36:40','571',474307.65,474307.65,'571','2022-06-26 13:34:11','614','2022-06-26 15:17:24',10,0),('1','171',257807,'AFTERNOON SHIFT','2022-06-26','2022-06-26 19:44:54','2022-06-27 19:44:54','571',831689.55,831689.55,'571','2022-06-26 20:38:28','614','2022-06-27 05:20:47',10,0),('1','171',257808,'MORNING SHIFT','2022-06-27','2022-06-27 06:42:38','2022-06-28 06:42:38','571',1218984.00,1218984.00,'571','2022-06-27 13:16:59','614','2022-06-27 19:54:22',10,0),('1','171',257809,'AFTERNOON SHIFT','2022-06-27','2022-06-27 20:46:44','2022-06-28 20:46:44','571',799874.40,799874.40,'571','2022-06-27 20:48:11','614','2022-06-27 23:55:41',10,0),('1','171',257810,'MORNING SHIFT','2022-06-28','2022-06-28 07:30:29','2022-06-29 07:30:29','571',1105384.80,1105384.80,'571','2022-06-28 13:34:12','614','2022-06-28 15:17:02',10,0),('1','171',257811,'AFTERNOON SHIFT','2022-06-28','2022-06-28 17:34:29','2022-06-29 17:34:29','571',540961.20,540961.20,'571','2022-06-28 19:53:50','614','2022-06-28 21:56:52',10,0),('1','171',257812,'MORNING SHIFT','2022-06-29','2022-06-29 08:32:47','2022-06-30 08:32:47','571',913099.20,913099.20,'571','2022-06-29 13:29:21','614','2022-06-29 14:50:49',10,0),('1','171',257813,'AFTERNOON SHIFT','2022-06-29','2022-06-29 20:24:12','2022-06-30 20:24:12','571',956007.00,956007.00,'571','2022-06-29 20:25:24','614','2022-06-29 22:13:49',10,0),('1','171',257814,'MORNING SHIFT','2022-06-30','2022-06-30 06:15:10','2022-07-01 06:15:10','571',1224444.00,1224444.00,'571','2022-06-30 13:42:19','614','2022-06-30 17:37:32',10,0),('1','171',257815,'AFTERNOON SHIFT','2022-06-30','2022-06-30 21:11:28','2022-07-01 21:11:28','571',3214356.60,3214356.60,'571','2022-06-30 21:13:37','614','2022-06-30 23:08:16',10,0),('1','171',257816,'MORNING SHIFT','2022-07-01','2022-07-01 06:55:40','2022-07-02 06:55:40','571',1258873.20,1258873.20,'571','2022-07-01 16:29:21','614','2022-07-01 20:22:45',10,0),('1','171',257817,'AFTERNOON SHIFT','2022-07-01','2022-07-01 22:17:45','2022-07-02 22:17:45','571',501696.00,501696.00,'571','2022-07-01 22:19:35','614','2022-07-01 22:23:25',10,0),('1','171',257818,'MORNING SHIFT','2022-07-02','2022-07-02 04:44:46','2022-07-03 04:44:46','571',1214007.60,1214007.60,'571','2022-07-02 14:21:13','614','2022-07-02 15:29:37',10,0),('1','171',257819,'AFTERNOON SHIFT','2022-07-02','2022-07-02 18:15:48','2022-07-03 18:15:48','571',989898.00,989898.00,'571','2022-07-02 19:26:14','614','2022-07-02 21:58:54',10,0),('1','171',257820,'MORNING SHIFT','2022-07-03','2022-07-03 09:11:03','2022-07-04 09:11:03','571',48102.60,48102.60,'571','2022-07-03 13:54:11','614','2022-07-03 15:02:57',10,0),('1','171',257821,'AFTERNOON SHIFT','2022-07-03','2022-07-03 18:33:21','2022-07-04 18:33:21','571',187441.80,187441.80,'571','2022-07-03 18:35:04','614','2022-07-03 22:18:43',10,0),('1','171',257822,'MORNING SHIFT','2022-07-04','2022-07-04 20:16:36','2022-07-05 20:16:36','571',864848.40,864848.40,'571','2022-07-04 20:54:41','614','2022-07-04 22:45:07',10,0),('1','171',257823,'MORNING SHIFT','2022-07-05','2022-07-05 00:26:32','2022-07-06 00:26:32','571',668210.40,668210.40,'571','2022-07-05 15:27:19','614','2022-07-05 18:36:08',10,0),('1','171',257824,'AFTERNO0N SHIFT ','2022-07-05','2022-07-05 21:14:03','2022-07-06 21:14:03','571',652555.80,652555.80,'571','2022-07-05 21:42:53','614','2022-07-06 02:15:34',10,0),('1','171',257825,'MORNING SHIFT','2022-07-06','2022-07-06 06:14:44','2022-07-07 06:14:44','571',3452093.40,3452093.40,'571','2022-07-06 17:34:06','614','2022-07-06 18:09:15',10,0),('1','171',257826,'AFTERNOON','2022-07-06','2022-07-06 19:34:45','2022-07-07 19:34:45','571',1840548.75,1840548.75,'571','2022-07-06 20:22:39','614','2022-07-06 21:18:38',10,0),('1','171',257827,'MORNING SHIFT','2022-07-07','2022-07-07 06:48:36','2022-07-08 06:48:36','571',2506658.70,2506658.70,'571','2022-07-07 14:24:55','614','2022-07-07 16:34:53',10,0),('1','171',257828,'AFTERNOON SHIFT','2022-07-07','2022-07-07 20:48:43','2022-07-08 20:48:43','571',1451626.80,1451626.80,'571','2022-07-07 20:50:56','614','2022-07-07 23:46:02',10,0),('1','171',257829,'MORNING SHIFT','2022-07-08','2022-07-08 06:45:10','2022-07-09 06:45:10','571',100145.10,100145.10,'571','2022-07-08 07:35:04','614','2022-07-08 10:30:33',10,0),('1','171',257830,'MORNING SHIFT  2','2022-07-08','2022-07-08 10:57:34','2022-07-09 10:57:34','571',365338.00,365338.00,'571','2022-07-08 11:01:54','614','2022-07-08 11:11:19',10,0),('1','171',257831,'MORNING SHIFT3','2022-07-08','2022-07-08 15:25:59','2022-07-09 15:25:59','571',1379424.95,1379424.95,'571','2022-07-08 15:29:49','614','2022-07-08 16:13:51',10,0),('1','171',257832,'AFTERNOON SHIFT','2022-07-08','2022-07-08 21:19:35','2022-07-09 21:19:35','571',1424363.65,1424363.65,'571','2022-07-08 21:22:51','614','2022-07-08 23:22:51',10,0),('1','171',257833,'MORNING SHIFT','2022-07-09','2022-07-09 09:04:46','2022-07-10 09:04:46','571',900110.30,900110.30,'571','2022-07-09 14:12:23','614','2022-07-09 17:17:00',10,0),('1','171',257834,'AFTERNOON SHIFT ','2022-07-09','2022-07-09 20:51:54','2022-07-10 20:51:54','571',717944.65,717944.65,'571','2022-07-09 20:54:03','614','2022-07-09 23:10:17',10,0),('1','171',257835,'MORNING SHIFT','2022-07-10','2022-07-10 06:39:19','2022-07-11 06:39:19','571',121492.45,121492.45,'571','2022-07-10 14:18:42','614','2022-07-10 17:20:38',10,0),('1','171',257836,'AFTERNOON SHIFT ','2022-07-10','2022-07-10 20:23:10','2022-07-11 20:23:10','571',252055.90,252055.90,'571','2022-07-10 20:25:30','614','2022-07-10 23:22:35',10,0),('1','171',257837,'MORNING SHIFT','2022-07-11','2022-07-11 06:27:31','2022-07-12 06:27:31','571',969653.35,969653.35,'571','2022-07-11 15:36:35','614','2022-07-11 17:52:43',10,0),('1','171',257838,'AFTERNO0N SHIFT','2022-07-11','2022-07-11 20:16:04','2022-07-12 20:16:04','571',1578915.60,1578915.60,'571','2022-07-11 21:44:41','614','2022-07-11 23:22:12',10,0),('1','171',257839,'Morning shift','2022-07-12','2022-07-12 07:20:52','2022-07-13 07:20:52','571',2993582.70,2993582.70,'571','2022-07-12 14:41:43','614','2022-07-12 14:49:49',10,0),('1','171',257840,'AFTERNOON SHIFT','2022-07-12','2022-07-12 21:45:29','2022-07-13 21:45:29','571',5763164.20,5763164.20,'571','2022-07-12 21:50:13','614','2022-07-12 23:57:44',10,0),('1','171',257841,'Morning shift','2022-07-13','2022-07-13 02:17:37','2022-07-14 02:17:37','571',3601412.65,3601412.65,'571','2022-07-13 14:49:29','614','2022-07-13 15:16:44',10,0),('1','171',257842,'AFTERNOON SHIFT','2022-07-13','2022-07-13 20:27:05','2022-07-14 20:27:05','571',3029134.30,3029134.30,'571','2022-07-13 20:30:15','614','2022-07-13 23:39:54',10,0),('1','171',257843,'Morning shift','2022-07-14','2022-07-14 05:38:43','2022-07-15 05:38:43','571',3831448.35,3831448.35,'571','2022-07-14 17:12:00','614','2022-07-14 21:18:04',10,0),('1','171',257844,'AFTERNOON SHIFT ','2022-07-14','2022-07-14 21:25:59','2022-07-15 21:25:59','571',3657669.45,3657669.45,'571','2022-07-14 21:32:36','614','2022-07-15 06:54:05',10,0),('1','171',257845,'Morning shift','2022-07-15','2022-07-15 08:21:14','2022-07-16 08:21:14','571',1776775.00,1776775.00,'571','2022-07-15 15:25:05','614','2022-07-15 21:58:27',10,0),('1','171',257846,'Afternoon Shift','2022-07-15','2022-07-15 22:12:13','2022-07-16 22:12:13','571',1461860.50,1461860.50,'571','2022-07-15 22:17:08','614','2022-07-16 07:16:42',10,0),('1','171',257847,'MORNING SHIFT','2022-07-16','2022-07-16 08:15:49','2022-07-17 08:15:49','571',855984.50,855984.50,'571','2022-07-16 14:19:50','614','2022-07-16 16:14:02',10,0),('1','171',257848,'AFTERNO0N SHIFT ','2022-07-16','2022-07-16 18:04:56','2022-07-17 18:04:56','571',748223.00,748223.00,'571','2022-07-17 06:11:58','614','2022-07-17 12:26:48',10,0),('1','171',257849,'AFTERNO0N SHIFT','2022-07-19','2022-07-19 18:47:46','2022-07-20 18:47:46','571',188042.40,188042.40,'571','2022-07-19 20:45:49','614','2022-07-19 21:23:25',10,0),('1','171',257850,'Morning shift','2022-07-20','2022-07-20 11:03:54','2022-07-21 11:03:54','571',915985.20,915985.20,'571','2022-07-20 14:43:17','614','2022-07-20 14:50:08',10,0),('1','171',257851,'AFTERNOON SHIFT','2022-07-20','2022-07-20 17:27:56','2022-07-21 17:27:56','571',2706288.00,2706288.00,'571','2022-07-21 06:16:45','614','2022-07-21 13:21:06',10,0),('1','171',257852,'Morning shift','2022-07-21','2022-07-21 13:54:58','2022-07-22 13:54:58','571',1434724.20,1434724.20,'571','2022-07-21 14:05:42','614','2022-07-21 14:54:07',10,0),('1','171',257853,'AFTERNOON SHIFT','2022-07-21','2022-07-21 20:56:53','2022-07-22 20:56:53','571',708481.80,708481.80,'571','2022-07-21 20:57:45','614','2022-07-21 22:54:31',10,0),('1','171',257854,'Morning shift','2022-07-22','2022-07-22 07:30:27','2022-07-23 07:30:27','571',1438093.80,1438093.80,'571','2022-07-22 13:40:52','614','2022-07-22 14:37:41',10,0),('1','171',257855,'Afternoon Shift 1','2022-07-22','2022-07-22 17:04:05','2022-07-23 17:04:05','571',194118.60,194118.60,'571','2022-07-22 17:05:50','614','2022-07-22 18:54:54',10,0),('1','171',257856,'AFTERNOON SHIFT 2','2022-07-22','2022-07-22 19:55:27','2022-07-23 19:55:27','571',473664.45,473664.45,'571','2022-07-22 20:42:35','614','2022-07-22 22:57:03',10,0),('1','171',257857,'MORNING SHIFT','2022-07-23','2022-07-23 10:35:11','2022-07-24 10:35:11','571',2919121.80,2919121.80,'571','2022-07-23 14:18:49','614','2022-07-23 14:53:04',10,0),('1','171',257858,'AFTERNOON SHIFT ','2022-07-23','2022-07-23 20:17:10','2022-07-24 20:17:10','571',2002135.80,2002135.80,'571','2022-07-23 20:21:05','614','2022-07-24 11:33:48',10,0),('1','171',257859,'Morning shift','2022-07-24','2022-07-24 11:36:36','2022-07-25 11:36:36','571',1175840.75,1175840.75,'571','2022-07-24 13:51:31','614','2022-07-24 20:37:06',10,0),('1','171',257860,'AFTERNOON SHIFT','2022-07-24','2022-07-24 20:56:20','2022-07-25 20:56:20','571',1555380.05,1555380.05,'571','2022-07-24 20:58:33','614','2022-07-25 15:41:07',10,0),('1','171',257861,'MORNING SHIFT','2022-07-25','2022-07-25 17:46:24','2022-07-26 17:46:24','571',1113659.40,1113659.40,'571','2022-07-25 17:53:07','614','2022-07-25 19:50:32',10,0),('1','171',257862,'AFTERNOON SHIFT ','2022-07-25','2022-07-25 21:56:39','2022-07-26 21:56:39','571',2290869.00,2290869.00,'571','2022-07-25 22:00:42','614','2022-07-26 07:57:31',10,0),('1','171',257863,'Morning shift','2022-07-26','2022-07-26 10:14:42','2022-07-27 10:14:42','571',2283486.80,2283486.80,'571','2022-07-26 14:25:30','614','2022-07-26 14:51:18',10,0),('1','171',257864,'AFTERNOON SHIFT','2022-07-26','2022-07-26 20:15:41','2022-07-27 20:15:41','571',2297481.90,2297481.90,'571','2022-07-26 20:19:52','614','2022-07-26 22:13:31',10,0),('1','171',257865,'Morning shift','2022-07-27','2022-07-27 06:29:57','2022-07-28 06:29:57','571',217952.00,217952.00,'571','2022-07-27 10:11:44','614','2022-07-27 10:40:40',10,0),('1','171',257866,'MORNING SHIFT2','2022-07-27','2022-07-27 11:37:06','2022-07-28 11:37:06','571',907123.60,907123.60,'571','2022-07-27 14:02:42','614','2022-07-27 14:25:27',10,0),('1','171',257867,'AFTERNOON SHIFT ','2022-07-27','2022-07-27 20:23:48','2022-07-28 20:23:48','571',1400469.80,1400469.80,'571','2022-07-27 20:26:37','614','2022-07-27 21:07:01',10,0),('1','171',257868,'MORNING SHIFT','2022-07-28','2022-07-28 05:55:31','2022-07-29 05:55:31','571',680760.00,680760.00,'571','2022-07-28 15:11:13','614','2022-07-28 15:17:55',10,0),('1','171',257869,'AFTERNOON SHIFT ','2022-07-28','2022-07-28 20:12:57','2022-07-29 20:12:57','571',1370955.60,1370955.60,'571','2022-07-28 20:33:12','614','2022-07-28 22:35:40',10,0),('1','171',257870,'MORNING SHIFT','2022-07-29','2022-07-29 07:26:10','2022-07-30 07:26:10','571',815556.60,815556.60,'571','2022-07-29 13:12:50','614','2022-07-29 17:08:29',10,0),('1','171',257871,'AFTERNOON SHIFT','2022-07-29','2022-07-29 21:35:51','2022-07-30 21:35:51','571',1432963.80,1432963.80,'571','2022-07-29 21:37:18','614','2022-07-30 06:52:20',10,0),('1','171',257872,'MORNING SHIFT','2022-07-30','2022-07-30 08:36:09','2022-07-31 08:36:09','571',666191.00,666191.00,'571','2022-07-30 14:14:33','614','2022-07-30 15:11:53',10,0),('1','171',257873,'AFTERNOON SHIFT ','2022-07-30','2022-07-30 21:25:28','2022-07-31 21:25:28','571',571003.20,571003.20,'571','2022-07-30 22:04:41','614','2022-07-30 23:20:49',10,0),('1','171',257874,'MORNING SHIFT','2022-07-31','2022-07-31 10:13:01','2022-08-01 10:13:01','571',652336.20,652336.20,'571','2022-07-31 14:33:40','614','2022-07-31 14:59:54',10,0),('1','171',257875,'AFTERNOON SHIFT ','2022-07-31','2022-07-31 20:43:15','2022-08-01 20:43:15','571',1409571.00,1409571.00,'571','2022-07-31 20:45:32','614','2022-07-31 21:43:05',10,0),('1','171',257876,'MORNING SHIFT','2022-08-01','2022-08-01 07:20:39','2022-08-02 07:20:39','571',742514.40,742514.40,'571','2022-08-01 13:49:55','614','2022-08-01 18:05:40',10,0),('1','171',257877,'AFTERNOON SHIFT ','2022-08-01','2022-08-01 19:43:46','2022-08-02 19:43:46','571',911759.40,911759.40,'571','2022-08-01 19:49:09','614','2022-08-01 21:58:00',10,0),('1','171',257878,'MORNING SHIFT','2022-08-02','2022-08-02 08:01:21','2022-08-03 08:01:21','571',601623.00,601623.00,'571','2022-08-02 14:23:53','614','2022-08-02 14:27:12',10,0),('1','171',257879,'AFTERNOON SHIFT ','2022-08-02','2022-08-02 19:41:29','2022-08-03 19:41:29','571',1309741.20,1309741.20,'571','2022-08-02 22:17:35','614','2022-08-02 22:32:49',10,0),('1','171',257880,'MORNING SHIFT','2022-08-03','2022-08-03 07:07:15','2022-08-04 07:07:15','571',994941.70,994941.70,'571','2022-08-03 13:58:41','614','2022-08-03 15:01:39',10,0),('1','171',257881,'AFTERNOON SHIFT','2022-08-03','2022-08-03 21:15:40','2022-08-04 21:15:40','571',1672840.80,1672840.80,'571','2022-08-03 21:38:17','614','2022-08-03 22:15:09',10,0),('1','171',257882,'MORNING SHIFT','2022-08-04','2022-08-04 07:46:07','2022-08-05 07:46:07','571',1452812.40,1452812.40,'571','2022-08-04 14:51:01','614','2022-08-04 16:04:58',10,0),('1','171',257883,'AFTERNOON SHIFT','2022-08-04','2022-08-04 17:30:10','2022-08-05 17:30:10','571',1085482.80,1085482.80,'571','2022-08-04 20:22:49','614','2022-08-04 22:13:34',10,0),('1','171',257884,'Morning shift','2022-08-05','2022-08-05 08:12:30','2022-08-06 08:12:30','571',852762.60,852762.60,'571','2022-08-05 13:34:57','614','2022-08-05 15:32:45',10,0),('1','171',257885,'AFTERNOON SHIFT','2022-08-05','2022-08-05 20:42:49','2022-08-06 20:42:49','571',1694649.60,1694649.60,'571','2022-08-05 20:48:43','614','2022-08-05 22:35:04',10,0),('1','171',257886,'MORNING SHIFT','2022-08-06','2022-08-06 07:05:50','2022-08-07 07:05:50','571',1201302.00,1201302.00,'571','2022-08-06 14:31:59','614','2022-08-06 14:38:31',10,0),('1','171',257887,'AFTERNOON SHIFT','2022-08-06','2022-08-06 21:02:18','2022-08-07 21:02:18','571',2348748.40,2348748.40,'571','2022-08-06 21:09:28','614','2022-08-06 22:09:53',10,0),('1','171',257888,'MORNING SHIFT','2022-08-07','2022-08-07 07:06:05','2022-08-08 07:06:05','571',1281019.00,1281019.00,'571','2022-08-07 14:27:33','614','2022-08-07 14:43:54',10,0),('1','171',257889,'AFTERNOON SHIFT','2022-08-07','2022-08-07 20:23:06','2022-08-08 20:23:06','571',1886422.00,1886422.00,'571','2022-08-07 20:27:19','614','2022-08-07 23:11:31',10,0),('1','171',257890,'MORNING SHIFT','2022-08-08','2022-08-08 07:23:42','2022-08-09 07:23:42','571',1707057.10,1707057.10,'571','2022-08-08 14:14:02','614','2022-08-08 14:25:46',10,0),('1','171',257891,'AFTERNOON SHIFT','2022-08-08','2022-08-08 21:04:43','2022-08-09 21:04:43','571',2239935.30,2239935.30,'571','2022-08-08 21:08:44','614','2022-08-08 22:39:50',10,0),('1','171',257892,'MORNING SHIFT','2022-08-09','2022-08-09 08:40:30','2022-08-10 08:40:30','571',2959280.30,2959280.30,'571','2022-08-09 15:04:15','614','2022-08-09 15:49:55',10,0),('1','171',257893,'AFTERNOON SHIFT','2022-08-09','2022-08-09 20:57:15','2022-08-10 20:57:15','571',3101875.60,3101875.60,'571','2022-08-09 21:01:38','614','2022-08-10 09:40:25',10,0),('1','171',257894,'MORNING SHIFT','2022-08-10','2022-08-10 11:26:00','2022-08-11 11:26:00','571',3208767.30,3208767.30,'571','2022-08-10 14:32:01','614','2022-08-10 16:07:50',10,0),('1','171',257895,'AFTERNOON SHIFT','2022-08-10','2022-08-10 20:11:25','2022-08-11 20:11:25','571',1158100.00,1158100.00,'571','2022-08-10 20:14:27','614','2022-08-11 07:30:37',10,0),('1','171',257896,'MORNING SHIFT','2022-08-11','2022-08-11 08:59:12','2022-08-12 08:59:12','571',1170286.50,1170286.50,'571','2022-08-11 14:30:15','614','2022-08-11 15:08:06',10,0),('1','171',257897,'AFTERNOON SHIFT','2022-08-11','2022-08-11 19:40:40','2022-08-12 19:40:40','571',804192.00,804192.00,'571','2022-08-11 19:43:11','614','2022-08-11 21:10:46',10,0),('1','171',257898,'MORNING SHIFT','2022-08-12','2022-08-12 06:36:41','2022-08-13 06:36:41','571',939681.80,939681.80,'571','2022-08-12 13:41:52','614','2022-08-12 19:12:23',10,0),('1','171',257899,'AFTERNOON SHIFT','2022-08-12','2022-08-12 20:11:14','2022-08-13 20:11:14','571',552432.90,552432.90,'571','2022-08-12 20:13:52','614','2022-08-12 22:49:04',10,0),('1','171',257900,'Morning shift','2022-08-13','2022-08-13 07:14:06','2022-08-14 07:14:06','571',949790.20,949790.20,'571','2022-08-13 13:23:00','614','2022-08-13 17:58:17',10,0),('1','171',257901,'AFTERNO0N SHIFT','2022-08-13','2022-08-13 19:24:53','2022-08-14 19:24:53','571',1115281.30,1115281.30,'571','2022-08-13 21:59:50','614','2022-08-13 22:17:21',10,0),('1','171',257902,'Morning shift','2022-08-14','2022-08-14 06:54:25','2022-08-15 06:54:25','571',943908.40,943908.40,'571','2022-08-14 13:33:38','614','2022-08-14 20:30:41',10,0),('1','171',257903,'AFTERNOON SHIFT','2022-08-14','2022-08-14 20:46:58','2022-08-15 20:46:58','571',1758523.20,1758523.20,'571','2022-08-14 20:50:51','614','2022-08-14 22:43:49',10,0),('1','171',257904,'MORNING SHIFT','2022-08-15','2022-08-15 07:06:14','2022-08-16 07:06:14','571',1517360.20,1517360.20,'571','2022-08-15 13:47:08','614','2022-08-15 14:56:30',10,0),('1','171',257905,'AFTERNOON SHIFT','2022-08-15','2022-08-15 20:31:46','2022-08-16 20:31:46','571',2579401.80,2579401.80,'571','2022-08-15 20:34:40','614','2022-08-15 22:13:43',10,0),('1','171',257906,'Morning shift','2022-08-16','2022-08-16 07:17:54','2022-08-17 07:17:54','571',2532072.00,2532072.00,'571','2022-08-16 14:20:58','614','2022-08-16 15:51:36',10,0),('1','171',257907,'AFTERNOON SHIFT','2022-08-16','2022-08-16 18:23:39','2022-08-17 18:23:39','571',1708553.30,1708553.30,'571','2022-08-16 20:10:46','614','2022-08-16 21:52:11',10,0),('1','171',257908,'MORNING SHIFT','2022-08-17','2022-08-17 07:56:31','2022-08-18 07:56:31','571',2189444.60,2189444.60,'571','2022-08-17 14:32:51','614','2022-08-17 20:02:12',10,0),('1','171',257909,'AFTERNOON SHIFT','2022-08-17','2022-08-17 20:17:17','2022-08-18 20:17:17','571',945022.10,945022.10,'571','2022-08-17 20:24:45','614','2022-08-17 22:54:52',10,0),('1','171',257910,'Morning shift','2022-08-18','2022-08-18 06:51:04','2022-08-19 06:51:04','571',1289448.60,1289448.60,'571','2022-08-18 14:07:43','614','2022-08-18 16:55:49',10,0),('1','171',257911,'AFTERNOON SHIFT','2022-08-18','2022-08-18 19:22:52','2022-08-19 19:22:52','571',1105375.00,1105375.00,'571','2022-08-18 19:25:39','614','2022-08-18 23:58:22',10,0),('1','171',257912,'MORNING SHIFT','2022-08-19','2022-08-19 04:38:09','2022-08-20 04:38:09','571',1469183.40,1469183.40,'571','2022-08-19 13:59:43','614','2022-08-19 14:31:47',10,0),('1','171',257913,'AFTERNOON SHIFT','2022-08-19','2022-08-19 18:05:49','2022-08-20 18:05:49','571',1929357.40,1929357.40,'571','2022-08-19 20:55:42','614','2022-08-19 22:05:55',10,0),('1','171',257914,'MORNING SHIFT','2022-08-20','2022-08-20 07:45:00','2022-08-21 07:45:00','571',1932681.60,1932681.60,'571','2022-08-20 14:32:27','614','2022-08-20 15:33:39',10,0),('1','171',257915,'AFTERNOON SHIFT','2022-08-20','2022-08-20 21:04:56','2022-08-21 21:04:56','571',1706842.80,1706842.80,'571','2022-08-20 21:08:21','614','2022-08-21 06:51:48',10,0),('1','171',257916,'Morning shift','2022-08-21','2022-08-21 08:54:49','2022-08-22 08:54:49','571',868500.00,868500.00,'571','2022-08-21 14:13:17','614','2022-08-21 18:41:32',10,0),('1','171',257917,'AFTERNOON SHIFT','2022-08-21','2022-08-21 20:14:17','2022-08-22 20:14:17','571',1487017.80,1487017.80,'571','2022-08-21 20:23:35','614','2022-08-21 21:14:17',10,0),('1','171',257918,'Morning shift','2022-08-22','2022-08-22 06:56:39','2022-08-23 06:56:39','571',951071.80,951071.80,'571','2022-08-22 13:55:38','614','2022-08-22 15:54:50',10,0),('1','171',257919,'AFTERNOON SHIFT ','2022-08-22','2022-08-22 20:20:10','2022-08-23 20:20:10','571',1619313.80,1619313.80,'571','2022-08-22 20:37:15','614','2022-08-22 22:00:25',10,0),('1','171',257920,'MORNING SHIFT','2022-08-23','2022-08-23 07:29:42','2022-08-24 07:29:42','571',685148.40,685148.40,'571','2022-08-23 13:16:22','614','2022-08-23 14:36:53',10,0),('1','171',257921,'AFTERNO0N SHIFT','2022-08-23','2022-08-23 18:08:27','2022-08-24 18:08:27','571',866396.80,866396.80,'571','2022-08-23 19:41:04','614','2022-08-23 20:57:51',10,0),('1','171',257922,'MORNING SHIFT','2022-08-24','2022-08-24 00:09:05','2022-08-25 00:09:05','571',1363795.80,1363795.80,'571','2022-08-24 14:11:19','614','2022-08-24 14:55:24',10,0),('1','171',257923,'AFTERNOON SHIFT','2022-08-24','2022-08-24 18:44:43','2022-08-25 18:44:43','571',1731480.20,1731480.20,'571','2022-08-24 20:00:15','614','2022-08-24 22:35:18',10,0),('1','171',257924,'Morning shift','2022-08-25','2022-08-25 07:31:25','2022-08-26 07:31:25','571',1559086.20,1559086.20,'571','2022-08-25 13:23:08','614','2022-08-25 14:48:47',10,0),('1','171',257925,'AFTERNOON SHIFT','2022-08-25','2022-08-25 18:16:00','2022-08-26 18:16:00','571',2853548.20,2853548.20,'571','2022-08-25 20:38:12','614','2022-08-25 22:42:31',10,0),('1','171',257926,'Morning shift','2022-08-26','2022-08-26 06:30:03','2022-08-27 06:30:03','571',1827836.40,1827836.40,'571','2022-08-26 13:18:26','614','2022-08-26 19:52:19',10,0),('1','171',257927,'AFTERNOON SHIFT','2022-08-26','2022-08-26 20:47:34','2022-08-27 20:47:34','571',2856938.00,2856938.00,'571','2022-08-26 20:51:04','614','2022-08-26 22:21:55',10,0),('1','171',257928,'MORNING SHIFT','2022-08-27','2022-08-27 00:14:59','2022-08-28 00:14:59','571',1085016.00,1085016.00,'571','2022-08-27 13:22:27','614','2022-08-27 19:12:07',10,0),('1','171',257929,'AFTERNOON SHIFT','2022-08-27','2022-08-27 20:53:49','2022-08-28 20:53:49','571',1999467.60,1999467.60,'571','2022-08-27 20:57:15','614','2022-08-27 22:15:14',10,0),('1','171',257930,'MORNING SHIFT','2022-08-28','2022-08-28 06:57:52','2022-08-29 06:57:52','571',463591.00,463591.00,'571','2022-08-28 13:48:10','614','2022-08-28 14:52:11',10,0),('1','171',257931,'AFTERNOON SHIFT','2022-08-28','2022-08-28 19:58:15','2022-08-29 19:58:15','571',720979.40,720979.40,'571','2022-08-28 20:03:04','614','2022-08-29 07:25:40',10,0),('1','171',257932,'MORNING SHIFT','2022-08-29','2022-08-29 08:00:56','2022-08-30 08:00:56','571',1092350.80,1092350.80,'571','2022-08-29 13:39:17','614','2022-08-29 15:35:49',10,0),('1','171',257933,'AFTERNOON SHIFT','2022-08-29','2022-08-29 20:26:38','2022-08-30 20:26:38','571',820861.60,820861.60,'571','2022-08-29 20:30:52','614','2022-08-29 20:54:33',10,0),('1','171',257934,'Morning shift','2022-08-30','2022-08-30 07:28:22','2022-08-31 07:28:22','571',1363440.20,1363440.20,'571','2022-08-30 13:36:17','614','2022-08-30 14:24:32',10,0),('1','171',257935,'AFTERNOON SHIFT','2022-08-30','2022-08-30 20:44:30','2022-08-31 20:44:30','571',819659.20,819659.20,'571','2022-08-30 20:46:42','614','2022-08-30 23:39:38',10,0),('1','171',257936,'Morning shift','2022-08-31','2022-08-31 07:25:49','2022-09-01 07:25:49','571',848910.00,848910.00,'571','2022-08-31 14:32:16','614','2022-08-31 14:38:25',10,0),('1','171',257937,'AFTERNOON SHIFT','2022-08-31','2022-08-31 17:06:41','2022-09-01 17:06:41','571',1878568.20,1878568.20,'571','2022-08-31 21:03:10','614','2022-08-31 22:52:33',10,0),('1','171',257938,'Morning shift','2022-09-01','2022-09-01 08:03:11','2022-09-02 08:03:11','571',3514673.20,3514673.20,'571','2022-09-01 14:14:51','614','2022-09-01 14:28:59',10,0),('1','171',257939,'AFTERNOON SHIFT','2022-09-01','2022-09-01 15:55:22','2022-09-02 15:55:22','571',2557435.40,2557435.40,'571','2022-09-01 20:26:22','614','2022-09-02 11:14:41',10,0),('1','171',257940,'MORNING SHIFT','2022-09-02','2022-09-02 13:22:43','2022-09-03 13:22:43','571',1792915.60,1792915.60,'571','2022-09-02 13:26:33','614','2022-09-02 15:19:38',10,0),('1','171',257941,'AFTERNOON SHIFT','2022-09-02','2022-09-02 20:51:46','2022-09-03 20:51:46','571',1785776.40,1785776.40,'571','2022-09-02 21:05:59','614','2022-09-02 21:07:22',10,0),('1','171',257942,'MORNING SHIFT','2022-09-03','2022-09-03 05:11:40','2022-09-04 05:11:40','571',1926212.40,1926212.40,'571','2022-09-03 14:23:47','614','2022-09-03 20:48:31',10,0),('1','171',257943,'AFTERNOON SHIFT','2022-09-03','2022-09-03 21:16:26','2022-09-04 21:16:26','571',2056104.20,2056104.20,'571','2022-09-03 21:22:04','614','2022-09-04 00:07:13',10,0),('1','171',257944,'MORNING SHIFT','2022-09-04','2022-09-04 06:33:21','2022-09-05 06:33:21','571',1321379.00,1321379.00,'571','2022-09-04 14:33:03','614','2022-09-04 14:37:04',10,0),('1','171',257945,'AFTERNOON SHIFT','2022-09-04','2022-09-04 20:53:49','2022-09-05 20:53:49','571',1540137.00,1540137.00,'571','2022-09-04 20:57:06','614','2022-09-04 22:31:38',10,0),('1','171',257946,'Morning shift','2022-09-05','2022-09-05 00:22:29','2022-09-06 00:22:29','571',2684931.40,2684931.40,'571','2022-09-05 14:18:31','614','2022-09-05 14:44:51',10,0),('1','171',257947,'AFTERNOON SHIFT','2022-09-05','2022-09-05 20:20:39','2022-09-06 20:20:39','571',2496144.20,2496144.20,'571','2022-09-05 20:39:59','614','2022-09-05 21:32:48',10,0),('1','171',257948,'Morning shift','2022-09-06','2022-09-06 08:08:56','2022-09-07 08:08:56','571',2139743.60,2139743.60,'571','2022-09-06 14:13:37','614','2022-09-06 15:33:35',10,0),('1','171',257949,'AFTERNOON SHIFT','2022-09-06','2022-09-06 17:55:12','2022-09-07 17:55:12','571',2322367.80,2322367.80,'571','2022-09-06 20:56:40','614','2022-09-06 22:36:51',10,0),('1','171',257950,'MORNING SHIFT','2022-09-07','2022-09-07 07:48:23','2022-09-08 07:48:23','571',1966349.20,1966349.20,'571','2022-09-07 13:36:08','614','2022-09-07 16:05:58',10,0),('1','171',257951,'AFTERNOON SHIFT','2022-09-07','2022-09-07 19:07:56','2022-09-08 19:07:56','571',2074357.20,2074357.20,'571','2022-09-07 21:08:57','614','2022-09-07 23:28:11',10,0),('1','171',257952,'Morning shift','2022-09-08','2022-09-08 03:14:13','2022-09-09 03:14:13','571',2298896.40,2298896.40,'571','2022-09-08 13:39:07','614','2022-09-08 15:04:54',10,0),('1','171',257953,'AFTERNOON SHIFT','2022-09-08','2022-09-08 17:19:12','2022-09-09 17:19:12','571',2030432.20,2030432.20,'571','2022-09-08 21:27:41','614','2022-09-08 22:56:55',10,0),('1','171',257954,'MORNING SHIFTp','2022-09-09','2022-09-09 05:25:58','2022-09-10 05:25:58','571',1778537.40,1778537.40,'571','2022-09-09 20:20:30','614','2022-09-09 21:33:29',10,0),('1','171',257955,'Afternoon Shift 1','2022-09-09','2022-09-09 21:34:54','2022-09-10 21:34:54','571',2140995.40,2140995.40,'571','2022-09-09 22:04:19','614','2022-09-09 22:27:39',10,0),('1','171',257956,'MORNING SHIFT','2022-09-10','2022-09-10 07:48:09','2022-09-11 07:48:09','571',2116255.60,2116255.60,'571','2022-09-10 13:37:09','614','2022-09-10 14:55:22',10,0),('1','171',257957,'AFTERNOON SHIFT','2022-09-10','2022-09-10 17:00:53','2022-09-11 17:00:53','571',2022755.80,2022755.80,'571','2022-09-10 20:45:33','614','2022-09-10 21:57:07',10,0),('1','171',257958,'MORNING SHIFT','2022-09-11','2022-09-11 07:33:27','2022-09-12 07:33:27','571',1230973.60,1230973.60,'571','2022-09-11 13:36:27','614','2022-09-11 14:37:22',10,0),('1','171',257959,'AFTERNOON SHIFT','2022-09-11','2022-09-11 19:56:24','2022-09-12 19:56:24','571',1787387.20,1787387.20,'571','2022-09-11 20:43:13','614','2022-09-11 21:48:31',10,0),('1','171',257960,'MORNING SHIFT','2022-09-12','2022-09-12 06:45:42','2022-09-13 06:45:42','571',2584748.80,2584748.80,'571','2022-09-12 14:18:01','614','2022-09-12 17:34:48',10,0),('1','171',257961,'AFTERNOON SHIFT','2022-09-12','2022-09-12 20:05:05','2022-09-13 20:05:05','571',2105498.60,2105498.60,'571','2022-09-12 20:44:31','614','2022-09-12 22:29:45',10,0),('1','171',257962,'MORNING SHIFT','2022-09-13','2022-09-13 07:25:09','2022-09-14 07:25:09','571',1442338.80,1442338.80,'571','2022-09-13 13:26:28','614','2022-09-13 14:27:19',10,0),('1','171',257963,'AFTERNO0N SHIFT','2022-09-13','2022-09-13 19:10:57','2022-09-14 19:10:57','571',2398073.60,2398073.60,'571','2022-09-13 20:43:04','614','2022-09-13 23:43:11',10,0),('1','171',257964,'Morning shift','2022-09-14','2022-09-14 07:03:32','2022-09-15 07:03:32','571',2180235.20,2180235.20,'571','2022-09-14 13:32:48','614','2022-09-14 15:53:33',10,0),('1','171',257965,'AFTERNOON SHIFT','2022-09-14','2022-09-14 20:25:53','2022-09-15 20:25:53','571',2197487.00,2197487.00,'571','2022-09-14 20:47:05','614','2022-09-15 07:03:17',10,0),('1','171',257966,'MORNING SHIFT','2022-09-15','2022-09-15 07:15:16','2022-09-16 07:15:16','571',2141082.60,2141082.60,'571','2022-09-15 15:55:59','614','2022-09-15 16:12:49',10,0),('1','171',257967,'AFTERNOON SHIFT','2022-09-15','2022-09-15 17:08:07','2022-09-16 17:08:07','571',2199070.80,2199070.80,'571','2022-09-15 20:38:55','614','2022-09-15 20:41:31',10,0),('1','171',257968,'MORNING SHIFT','2022-09-16','2022-09-16 05:04:50','2022-09-17 05:04:50','571',2074136.40,2074136.40,'571','2022-09-16 13:42:46','614','2022-09-16 14:24:03',10,0),('1','171',257969,'AFTERNOON SHIFT','2022-09-16','2022-09-16 19:06:46','2022-09-17 19:06:46','571',2198528.20,2198528.20,'571','2022-09-16 20:49:40','614','2022-09-16 21:42:57',10,0),('1','171',257970,'MORNING SHIFT','2022-09-17','2022-09-17 06:33:21','2022-09-18 06:33:21','571',2070097.20,2070097.20,'571','2022-09-17 14:06:16','614','2022-09-17 14:23:15',10,0),('1','171',257971,'AFTERNOON SHIFT','2022-09-17','2022-09-17 18:18:41','2022-09-18 18:18:41','571',1953861.80,1953861.80,'571','2022-09-17 20:41:39','614','2022-09-17 23:03:57',10,0),('1','171',257972,'Morning shift','2022-09-18','2022-09-18 06:58:02','2022-09-19 06:58:02','571',1085740.80,1085740.80,'571','2022-09-18 13:24:21','614','2022-09-18 14:40:42',10,0),('1','171',257973,'Afternoon Shift','2022-09-18','2022-09-18 21:05:15','2022-09-19 21:05:15','571',2116418.00,2116418.00,'571','2022-09-18 21:23:27','614','2022-09-18 23:24:38',10,0),('1','171',257974,'MORNING SHIFT','2022-09-19','2022-09-19 07:08:17','2022-09-20 07:08:17','571',4432331.20,4432331.20,'571','2022-09-19 13:49:06','614','2022-09-19 20:13:26',10,0),('1','171',257975,'AFTERNOON SHIFT','2022-09-19','2022-09-19 21:14:08','2022-09-20 21:14:08','571',2064642.80,2064642.80,'571','2022-09-19 21:20:10','614','2022-09-20 07:47:04',10,0),('1','171',257976,'MORNING SHIFT','2022-09-20','2022-09-20 08:45:42','2022-09-21 08:45:42','571',1728758.00,1728758.00,'571','2022-09-20 13:18:49','614','2022-09-20 14:44:09',10,0),('1','171',257977,'Afternoon Shift 1','2022-09-20','2022-09-20 19:32:59','2022-09-21 19:32:59','571',1633059.00,1633059.00,'571','2022-09-20 20:30:47','614','2022-09-20 21:40:38',10,0),('1','171',257978,'MORNING SHIFT','2022-09-21','2022-09-21 00:14:39','2022-09-22 00:14:39','571',1172302.80,1172302.80,'571','2022-09-21 15:49:51','614','2022-09-21 18:11:53',10,0),('1','171',257979,'AFTERNOON SHIFT','2022-09-21','2022-09-21 19:24:12','2022-09-22 19:24:12','571',658009.00,658009.00,'571','2022-09-22 10:15:34','614','2022-09-22 13:52:59',10,0),('1','171',257980,'Morning shift','2022-09-22','2022-09-22 14:11:12','2022-09-23 14:11:12','571',1522333.40,1522333.40,'571','2022-09-22 14:13:42','614','2022-09-22 17:07:45',10,0),('1','171',257981,'AFTERNOON SHIFT','2022-09-22','2022-09-22 20:16:49','2022-09-23 20:16:49','571',2467884.20,2467884.20,'571','2022-09-22 20:36:49','614','2022-09-22 22:22:37',10,0),('1','171',257982,'Morning shift','2022-09-23','2022-09-23 01:27:01','2022-09-24 01:27:01','571',1996704.00,1996704.00,'571','2022-09-23 13:40:22','614','2022-09-23 14:48:50',10,0),('1','171',257983,'Afternoon Shift','2022-09-23','2022-09-23 17:47:05','2022-09-24 17:47:05','571',2054625.20,2054625.20,'571','2022-09-23 20:40:25','614','2022-09-24 07:04:32',10,0),('1','171',257984,'Morning shift','2022-09-24','2022-09-24 07:20:43','2022-09-25 07:20:43','571',604666.80,604666.80,'571','2022-09-24 13:20:18','614','2022-09-24 14:50:46',10,0),('1','171',257985,'AFTERNOON SHIFT','2022-09-24','2022-09-24 20:27:41','2022-09-25 20:27:41','571',1268980.20,1268980.20,'571','2022-09-24 20:39:55','614','2022-09-24 21:59:26',10,0),('1','171',257986,'Morning shift','2022-09-25','2022-09-25 02:31:54','2022-09-26 02:31:54','571',824958.00,824958.00,'571','2022-09-25 13:27:36','614','2022-09-25 14:09:50',10,0),('1','171',257987,'AFTERNOON SHIFT','2022-09-25','2022-09-25 18:23:30','2022-09-26 18:23:30','571',986562.00,986562.00,'571','2022-09-25 20:30:32','614','2022-09-25 21:00:28',10,0),('1','171',257988,'MORNING SHIFT','2022-09-26','2022-09-26 07:21:59','2022-09-27 07:21:59','571',971269.20,971269.20,'571','2022-09-26 13:26:35','614','2022-09-26 16:18:20',10,0),('1','171',257989,'Afternoon Shift','2022-09-26','2022-09-26 17:17:06','2022-09-27 17:17:06','571',1297755.00,1297755.00,'571','2022-09-26 20:38:11','614','2022-09-27 06:54:22',10,0),('1','171',257990,'Morning shift','2022-09-27','2022-09-27 08:46:39','2022-09-28 08:46:39','571',862160.40,862160.40,'571','2022-09-27 13:09:11','614','2022-09-27 13:57:12',10,0),('1','171',257991,'Afternoon Shift','2022-09-27','2022-09-27 14:20:36','2022-09-28 14:20:36','571',1218933.60,1218933.60,'571','2022-09-27 20:36:45','614','2022-09-27 21:58:08',10,0),('1','171',257992,'Morning shift','2022-09-28','2022-09-28 06:09:36','2022-09-29 06:09:36','571',963685.80,963685.80,'571','2022-09-28 13:14:08','614','2022-09-28 13:53:03',10,0),('1','171',257993,'AFTERNOON SHIFT','2022-09-28','2022-09-28 19:01:04','2022-09-29 19:01:04','571',1314597.60,1314597.60,'571','2022-09-28 20:47:41','614','2022-09-28 21:12:45',10,0),('1','171',257994,'MORNING SHIFT','2022-09-29','2022-09-29 06:38:44','2022-09-30 06:38:44','571',1015083.00,1015083.00,'571','2022-09-29 13:16:27','614','2022-09-29 14:36:23',10,0),('1','171',257995,'AFTERNOON SHIFT','2022-09-29','2022-09-29 20:46:13','2022-09-30 20:46:13','571',1357518.60,1357518.60,'571','2022-09-29 20:53:04','614','2022-09-29 21:51:37',10,0),('1','171',257996,'MORNING SHIFT','2022-09-30','2022-09-30 08:43:50','2022-10-01 08:43:50','571',1081296.00,1081296.00,'571','2022-09-30 13:17:06','614','2022-09-30 15:00:25',10,0),('1','171',257997,'AFTERNOON SHIFT','2022-09-30','2022-09-30 18:36:38','2022-10-01 18:36:38','571',1423260.00,1423260.00,'571','2022-09-30 20:46:36','614','2022-09-30 22:20:34',10,0),('1','171',257998,'Morning shift','2022-10-01','2022-10-01 04:56:16','2022-10-02 04:56:16','571',959297.20,959297.20,'571','2022-10-01 13:23:58','614','2022-10-01 15:45:50',10,0),('1','171',257999,'AFTERNOON SHIFT','2022-10-01','2022-10-01 17:36:11','2022-10-02 17:36:11','571',1251189.00,1251189.00,'571','2022-10-01 20:24:12','614','2022-10-01 22:34:37',10,0),('1','171',258000,'MORNING SHIFT2','2022-10-02','2022-10-02 07:30:42','2022-10-03 07:30:42','571',909356.80,909356.80,'571','2022-10-02 13:19:02','614','2022-10-02 18:36:51',10,0),('1','171',258001,'AFTERNOON SHIFT','2022-10-02','2022-10-02 19:14:41','2022-10-03 19:14:41','571',1075141.80,1075141.80,'571','2022-10-03 09:43:13','614','2022-10-03 15:00:52',10,0),('1','171',258002,'Morning shift','2022-10-03','2022-10-03 17:34:02','2022-10-04 17:34:02','571',867069.00,867069.00,'571','2022-10-03 17:39:06','614','2022-10-03 22:28:30',10,0),('1','171',258003,'AFTERNOON SHIFT','2022-10-03','2022-10-03 22:35:53','2022-10-04 22:35:53','571',690987.60,690987.60,'571','2022-10-03 22:38:54','614','2022-10-04 12:09:47',10,0),('1','171',258004,'Morning shift','2022-10-04','2022-10-04 13:12:31','2022-10-05 13:12:31','571',445772.10,445772.10,'571','2022-10-04 13:28:06','614','2022-10-04 14:25:50',10,0),('1','171',258005,'AFTERNOON SHIFT','2022-10-04','2022-10-04 21:17:04','2022-10-05 21:17:04','571',661824.90,661824.90,'571','2022-10-04 21:21:53','614','2022-10-04 23:08:29',10,0),('1','171',258006,'MORNING SHIFT','2022-10-05','2022-10-05 07:59:15','2022-10-06 07:59:15','571',262623.90,262623.90,'571','2022-10-05 09:32:14','614','2022-10-05 14:04:26',10,0),('1','171',258007,'MORNING SHIFT 2','2022-10-05','2022-10-05 14:45:47','2022-10-06 14:45:47','571',550904.40,550904.40,'571','2022-10-05 14:47:52','614','2022-10-05 15:27:04',10,0),('1','171',258008,'AFTERNOON SHIFT','2022-10-05','2022-10-05 18:04:35','2022-10-06 18:04:35','571',1031181.00,1031181.00,'571','2022-10-05 20:41:04','614','2022-10-05 22:38:06',10,0),('1','171',258009,'MORNING SHIFT','2022-10-06','2022-10-06 07:46:45','2022-10-07 07:46:45','571',1079502.00,1079502.00,'571','2022-10-06 13:37:33','614','2022-10-06 16:50:23',10,0),('1','171',258010,'AFTERNOON SHIFT','2022-10-06','2022-10-06 17:43:09','2022-10-07 17:43:09','571',411789.00,411789.00,'571','2022-10-06 20:35:03','614','2022-10-06 22:37:10',10,0),('1','171',258011,'MORNING SHIFT','2022-10-07','2022-10-07 07:48:49','2022-10-08 07:48:49','571',792298.20,792298.20,'571','2022-10-07 15:00:41','614','2022-10-07 15:56:58',10,0),('1','171',258012,'AFTERNOON SHIFT','2022-10-07','2022-10-07 17:32:31','2022-10-08 17:32:31','571',996274.80,996274.80,'571','2022-10-07 20:41:43','614','2022-10-07 21:17:20',10,0),('1','171',258013,'MORNING SHIFT','2022-10-08','2022-10-08 08:40:17','2022-10-09 08:40:17','571',235439.40,235439.40,'571','2022-10-08 13:54:52','614','2022-10-08 14:54:20',10,0),('1','171',258014,'AFTERNOON SHIFT','2022-10-08','2022-10-08 20:44:41','2022-10-09 20:44:41','571',697606.20,697606.20,'571','2022-10-08 20:46:08','614','2022-10-08 23:34:16',10,0),('1','171',258015,'MORNING SHIFT','2022-10-09','2022-10-09 08:01:04','2022-10-10 08:01:04','571',183378.00,183378.00,'571','2022-10-09 13:19:53','614','2022-10-09 14:11:12',10,0),('1','171',258016,'AFTERNO0N SHIFT','2022-10-09','2022-10-09 15:19:07','2022-10-10 15:19:07','571',949098.60,949098.60,'571','2022-10-09 20:29:55','614','2022-10-09 22:13:13',10,0),('1','171',258017,'Morning shift','2022-10-10','2022-10-10 06:30:21','2022-10-11 06:30:21','571',4217542.20,4217542.20,'571','2022-10-10 13:24:59','614','2022-10-10 14:51:12',10,0),('1','171',258018,'AFTERNOON SHIFT','2022-10-10','2022-10-10 18:19:45','2022-10-11 18:19:45','571',2243741.40,2243741.40,'571','2022-10-10 20:43:49','614','2022-10-10 22:26:17',10,0),('1','171',258019,'Morning shift','2022-10-11','2022-10-11 01:47:28','2022-10-12 01:47:28','571',1010734.20,1010734.20,'571','2022-10-11 13:19:11','614','2022-10-11 16:03:30',10,0),('1','171',258020,'AFTERNOON SHIFT','2022-10-11','2022-10-11 19:12:24','2022-10-12 19:12:24','571',1292349.60,1292349.60,'571','2022-10-11 20:40:18','614','2022-10-11 21:51:40',10,0),('1','171',258021,'Morning shift','2022-10-12','2022-10-12 06:46:14','2022-10-13 06:46:14','571',19339.20,19339.20,'571','2022-10-12 14:05:22','614','2022-10-12 17:06:07',10,0),('1','171',258022,'AFTERNO0N SHIFT','2022-10-12','2022-10-12 19:23:08','2022-10-13 19:23:08','571',78928.20,78928.20,'571','2022-10-12 20:51:27','614','2022-10-12 21:13:24',10,0),('1','171',258023,'Morning shift','2022-10-13','2022-10-13 07:18:29','2022-10-14 07:18:29','571',1128322.80,1128322.80,'571','2022-10-13 13:35:26','614','2022-10-13 14:24:55',10,0),('1','171',258024,'AFTERNOON SHIFT','2022-10-13','2022-10-13 18:10:12','2022-10-14 18:10:12','571',1194483.60,1194483.60,'571','2022-10-13 20:45:16','614','2022-10-13 21:57:22',10,0),('1','171',258025,'MORNING SHIFT','2022-10-14','2022-10-14 06:47:49','2022-10-15 06:47:49','571',874441.80,874441.80,'571','2022-10-14 13:19:37','614','2022-10-14 16:02:11',10,0),('1','171',258026,'AFTERNOON SHIFT','2022-10-14','2022-10-14 17:44:53','2022-10-15 17:44:53','571',1324166.40,1324166.40,'571','2022-10-14 20:42:09','614','2022-10-14 22:35:20',10,0),('1','171',258027,'MORNING SHIFT','2022-10-15','2022-10-15 06:50:56','2022-10-16 06:50:56','571',1052461.80,1052461.80,'571','2022-10-15 14:02:18','614','2022-10-15 16:32:43',10,0),('1','171',258028,'AFTERNO0N SHIFT','2022-10-15','2022-10-15 17:01:44','2022-10-16 17:01:44','571',902415.60,902415.60,'571','2022-10-15 20:53:58','614','2022-10-15 22:43:40',10,0),('1','171',258029,'Morning shift','2022-10-16','2022-10-16 07:02:22','2022-10-17 07:02:22','571',347166.00,347166.00,'571','2022-10-16 14:02:03','614','2022-10-16 17:14:48',10,0),('1','171',258030,'AFTERNOON SHIFT','2022-10-16','2022-10-16 20:05:36','2022-10-17 20:05:36','571',517215.60,517215.60,'571','2022-10-16 20:09:04','614','2022-10-16 21:24:00',10,0),('1','171',258031,'AFTERNOON SHIFT','2022-10-17','2022-10-17 14:19:54','2022-10-18 14:19:54','571',104000.40,104000.40,'571','2022-10-17 15:31:36','614','2022-10-17 17:00:10',10,0),('1','171',258032,'AFTERNOON SHIFT','2022-10-17','2022-10-17 18:48:36','2022-10-18 18:48:36','571',155091.60,155091.60,'571','2022-10-17 18:52:31','614','2022-10-17 23:08:17',10,0),('1','171',258033,'Morning shift','2022-10-18','2022-10-18 06:19:27','2022-10-19 06:19:27','571',760952.00,760952.00,'571','2022-10-18 13:50:33','614','2022-10-18 16:03:42',10,0),('1','171',258034,'AFTERNOON SHIFT','2022-10-18','2022-10-18 20:47:47','2022-10-19 20:47:47','571',266008.00,266008.00,'571','2022-10-18 20:49:10','614','2022-10-18 23:37:47',10,0),('1','171',258035,'MORNING SHIFT','2022-10-19','2022-10-19 06:34:00','2022-10-20 06:34:00','571',1211503.80,1211503.80,'571','2022-10-19 13:16:08','614','2022-10-19 14:35:54',10,0),('1','171',258036,'AFTERNOON SHIFT','2022-10-19','2022-10-19 15:47:49','2022-10-20 15:47:49','571',951545.40,951545.40,'571','2022-10-19 20:06:36','614','2022-10-19 21:56:39',10,0),('1','171',258037,'Morning shift','2022-10-20','2022-10-20 07:45:37','2022-10-21 07:45:37','571',1516140.20,1516140.20,'571','2022-10-20 13:22:13','614','2022-10-20 15:57:26',10,0),('1','171',258038,'AFTERNOON SHIFT','2022-10-20','2022-10-20 20:06:18','2022-10-21 20:06:18','571',1397135.60,1397135.60,'571','2022-10-20 20:21:54','614','2022-10-20 22:38:50',10,0),('1','171',258039,'Morning shift','2022-10-21','2022-10-21 06:22:15','2022-10-22 06:22:15','571',323135.80,323135.80,'571','2022-10-21 13:32:50','614','2022-10-21 14:25:04',10,0),('1','171',258040,'AFTERNOON SHIFT','2022-10-21','2022-10-21 20:41:40','2022-10-22 20:41:40','571',476239.80,476239.80,'571','2022-10-21 20:46:09','614','2022-10-21 23:17:40',10,0),('1','171',258041,'Morning shift ','2022-10-22','2022-10-22 07:08:50','2022-10-23 07:08:50','571',340299.00,340299.00,'571','2022-10-22 13:21:38','614','2022-10-22 14:36:01',10,0),('1','171',258042,'AFTERNOON SHIFT','2022-10-22','2022-10-22 20:53:05','2022-10-23 20:53:05','571',132704.00,132704.00,'571','2022-10-22 20:54:48','614','2022-10-22 22:19:53',10,0),('1','171',258043,'MORNING SHIFT','2022-10-23','2022-10-23 12:16:11','2022-10-24 12:16:11','571',338728.00,338728.00,'571','2022-10-23 13:58:10','614','2022-10-23 14:15:15',10,0),('1','171',258044,'AFTERNOON SHIFT','2022-10-23','2022-10-23 20:26:34','2022-10-24 20:26:34','571',872448.00,872448.00,'571','2022-10-23 20:29:07','614','2022-10-23 21:39:04',10,0),('1','171',258045,'MORNING SHIFT','2022-10-24','2022-10-24 06:22:46','2022-10-25 06:22:46','571',47304.00,47304.00,'571','2022-10-24 15:00:12','614','2022-10-24 15:11:16',10,0),('1','171',258046,'AFTERNOON SHIFT','2022-10-24','2022-10-24 20:25:57','2022-10-25 20:25:57','571',271893.00,271893.00,'571','2022-10-24 20:35:18','614','2022-10-24 20:48:39',10,0),('1','171',258047,'Morning shift','2022-10-25','2022-10-25 06:19:50','2022-10-26 06:19:50','571',495544.00,495544.00,'571','2022-10-25 13:20:12','614','2022-10-25 14:33:20',10,0),('1','171',258048,'AFTERNOON SHIFT','2022-10-25','2022-10-25 20:40:40','2022-10-26 20:40:40','571',1630280.00,1630280.00,'571','2022-10-25 20:49:21','614','2022-10-25 21:32:24',10,0),('1','171',258049,'MORNING SHIFT','2022-10-26','2022-10-26 06:37:41','2022-10-27 06:37:41','571',612016.00,612016.00,'571','2022-10-26 13:55:40','614','2022-10-26 14:50:41',10,0),('1','171',258050,'AFTERNOON SHIFT','2022-10-26','2022-10-26 20:40:55','2022-10-27 20:40:55','571',351200.00,351200.00,'571','2022-10-26 20:42:28','614','2022-10-27 01:58:29',10,0),('1','171',258051,'Morning shift','2022-10-27','2022-10-27 07:11:15','2022-10-28 07:11:15','571',640512.00,640512.00,'571','2022-10-27 13:16:29','614','2022-10-27 14:48:39',10,0),('1','171',258052,'AFTERNOON SHIFT','2022-10-27','2022-10-27 20:25:04','2022-10-28 20:25:04','571',279112.00,279112.00,'571','2022-10-27 20:27:57','614','2022-10-27 21:58:39',10,0),('1','171',258053,'Morning shift','2022-10-28','2022-10-28 06:50:23','2022-10-29 06:50:23','571',590264.00,590264.00,'571','2022-10-28 13:26:43','614','2022-10-28 16:53:48',10,0),('1','171',258054,'AFTERNOON SHIFT','2022-10-28','2022-10-28 20:16:22','2022-10-29 20:16:22','571',436464.00,436464.00,'571','2022-10-28 20:36:51','614','2022-10-28 20:43:24',10,0),('1','171',258055,'MORNING SHIFT','2022-10-29','2022-10-29 06:21:22','2022-10-30 06:21:22','571',728656.00,728656.00,'571','2022-10-29 13:52:00','614','2022-10-29 14:49:47',10,0),('1','171',258056,'AFTERNOON SHIFT','2022-10-29','2022-10-29 20:27:51','2022-10-30 20:27:51','571',353424.00,353424.00,'571','2022-10-29 20:29:37','614','2022-10-29 22:08:57',10,0),('1','171',258057,'MORNING SHIFT','2022-10-30','2022-10-30 05:40:59','2022-10-31 05:40:59','571',212104.00,212104.00,'571','2022-10-30 14:14:40','614','2022-10-30 14:26:18',10,0),('1','171',258058,'AFTERNO0N SHIFT','2022-10-30','2022-10-30 16:29:11','2022-10-31 16:29:11','571',488544.00,488544.00,'571','2022-10-30 20:39:22','614','2022-10-30 21:10:01',10,0),('1','171',258059,'Morning shift','2022-10-31','2022-10-31 06:47:08','2022-11-01 06:47:08','571',562080.00,562080.00,'571','2022-10-31 12:53:42','614','2022-10-31 14:38:59',10,0),('1','171',258060,'AFTERNOON SHIFT','2022-10-31','2022-10-31 20:33:28','2022-11-01 20:33:28','571',426000.00,426000.00,'571','2022-10-31 20:34:28','614','2022-10-31 22:25:40',10,0),('1','171',258061,'MORNING SHIFT','2022-11-01','2022-11-01 05:53:45','2022-11-02 05:53:45','571',807312.00,807312.00,'571','2022-11-01 13:51:25','614','2022-11-01 14:36:18',10,0),('1','171',258062,'AFTERNOON SHIFT','2022-11-01','2022-11-01 17:01:44','2022-11-02 17:01:44','571',949512.00,949512.00,'571','2022-11-01 20:41:31','614','2022-11-01 21:29:01',10,0),('1','171',258063,'MORNING SHIFT','2022-11-02','2022-11-02 07:08:25','2022-11-03 07:08:25','571',2395920.00,2395920.00,'571','2022-11-02 13:55:22','614','2022-11-02 15:23:36',10,0),('1','171',258064,'AFTERNOON SHIFT','2022-11-02','2022-11-02 20:38:36','2022-11-03 20:38:36','571',333032.00,333032.00,'571','2022-11-02 20:40:02','614','2022-11-03 07:09:45',10,0),('1','171',258065,'Morning shift','2022-11-03','2022-11-03 07:38:50','2022-11-04 07:38:50','571',3867320.00,3867320.00,'571','2022-11-03 13:42:53','614','2022-11-03 14:56:59',10,0),('1','171',258066,'MORNING SHIFT','2022-11-03','2022-11-03 19:36:22','2022-11-04 19:36:22','571',595192.00,595192.00,'571','2022-11-03 19:53:17','614','2022-11-04 01:26:45',10,0),('1','171',258067,'Morning shift','2022-11-04','2022-11-04 06:06:52','2022-11-05 06:06:52','571',714384.00,714384.00,'571','2022-11-04 13:19:01','614','2022-11-04 16:38:26',10,0),('1','171',258068,'AFTERNOON SHIFT','2022-11-04','2022-11-04 20:18:10','2022-11-05 20:18:10','571',780272.00,780272.00,'571','2022-11-04 20:20:09','614','2022-11-04 23:52:19',10,0),('1','171',258069,'MORNING SHIFT','2022-11-05','2022-11-05 10:38:10','2022-11-06 10:38:10','571',378920.00,378920.00,'571','2022-11-05 13:18:47','614','2022-11-05 15:31:49',10,0),('1','171',258070,'AFTERNOON SHIFT','2022-11-05','2022-11-05 20:18:05','2022-11-06 20:18:05','571',528160.00,528160.00,'571','2022-11-05 20:19:59','614','2022-11-05 23:23:35',10,0),('1','171',258071,'MORNING SHIFT','2022-11-06','2022-11-06 11:20:10','2022-11-07 11:20:10','571',412392.00,412392.00,'571','2022-11-06 13:43:41','614','2022-11-06 17:22:02',10,0),('1','171',258072,'AFTERNOON SHIFT','2022-11-06','2022-11-06 20:42:55','2022-11-07 20:42:55','571',711376.00,711376.00,'571','2022-11-06 20:44:41','614','2022-11-06 23:45:26',10,0),('1','171',258073,'MORNING SHIFT','2022-11-07','2022-11-07 00:47:01','2022-11-08 00:47:01','571',895120.00,895120.00,'571','2022-11-07 13:14:46','614','2022-11-07 17:23:07',10,0),('1','171',258074,'AFTERNOO SHIFT','2022-11-07','2022-11-07 18:52:31','2022-11-08 18:52:31','571',1296248.00,1296248.00,'571','2022-11-07 20:57:54','614','2022-11-07 23:10:36',10,0),('1','171',258075,'MORNING SHIFT','2022-11-08','2022-11-08 06:27:05','2022-11-09 06:27:05','571',802424.55,802424.55,'571','2022-11-08 14:56:59','614','2022-11-08 16:28:20',10,0),('1','171',258076,'Afternoon Shift','2022-11-08','2022-11-08 19:50:24','2022-11-09 19:50:24','571',541149.05,541149.05,'571','2022-11-08 20:38:08','614','2022-11-08 20:44:54',10,0),('1','171',258077,'MORNING SHIFT','2022-11-09','2022-11-09 06:48:33','2022-11-10 06:48:33','571',1371577.60,1371577.60,'571','2022-11-09 12:51:29','614','2022-11-09 17:44:46',10,0),('1','171',258078,'MORNING SHIFT','2022-11-09','2022-11-09 18:38:33','2022-11-10 18:38:33','571',576661.65,576661.65,'571','2022-11-09 20:29:37','614','2022-11-09 20:36:56',10,0),('1','171',258079,'MORNING SHIFT','2022-11-10','2022-11-10 06:12:41','2022-11-11 06:12:41','571',1184493.45,1184493.45,'571','2022-11-10 14:13:55','614','2022-11-10 14:49:52',10,0),('1','171',258080,'AFTERNOON SHIFT','2022-11-10','2022-11-10 20:07:51','2022-11-11 20:07:51','571',850467.20,850467.20,'571','2022-11-10 20:10:48','614','2022-11-11 00:39:43',10,0),('1','171',258081,'MORNING SHIFT','2022-11-11','2022-11-11 07:37:44','2022-11-12 07:37:44','571',1135759.40,1135759.40,'571','2022-11-11 15:02:10','614','2022-11-11 15:35:15',10,0),('1','171',258082,'AFTERNOO SHIFT','2022-11-11','2022-11-11 18:12:23','2022-11-12 18:12:23','571',850987.05,850987.05,'571','2022-11-11 20:16:15','614','2022-11-11 23:50:48',10,0),('1','171',258083,'MORNING SHIFT','2022-11-12','2022-11-12 07:42:17','2022-11-13 07:42:17','571',1938614.60,1938614.60,'571','2022-11-12 13:35:10','614','2022-11-12 14:30:10',10,0),('1','171',258084,'AFTERNOO SHIFT','2022-11-12','2022-11-12 20:25:42','2022-11-13 20:25:42','571',836979.05,836979.05,'571','2022-11-12 20:40:26','614','2022-11-13 07:47:41',10,0),('1','171',258085,'MORNING SHIFT','2022-11-13','2022-11-13 07:59:34','2022-11-14 07:59:34','571',450717.40,450717.40,'571','2022-11-13 14:04:05','614','2022-11-13 14:59:57',10,0),('1','171',258086,'AFTERNOON SHIFT','2022-11-13','2022-11-13 20:45:23','2022-11-14 20:45:23','571',579597.00,579597.00,'571','2022-11-13 20:46:43','614','2022-11-13 23:25:17',10,0),('1','171',258087,'MORNING SHIFT','2022-11-14','2022-11-14 06:51:16','2022-11-15 06:51:16','571',552185.15,552185.15,'571','2022-11-14 17:07:50','614','2022-11-14 20:09:17',10,0),('1','171',258088,'AFTERNOO SHIFT','2022-11-14','2022-11-14 20:11:19','2022-11-15 20:11:19','571',435238.50,435238.50,'571','2022-11-14 20:18:20','614','2022-11-15 06:22:01',10,0),('1','171',258089,'MORNING SHIFT','2022-11-15','2022-11-15 07:03:49','2022-11-16 07:03:49','571',682883.00,682883.00,'571','2022-11-15 13:08:15','614','2022-11-15 18:33:03',10,0),('1','171',258090,'AFTERNOO SHIFT','2022-11-15','2022-11-15 18:52:26','2022-11-16 18:52:26','571',741861.80,741861.80,'571','2022-11-15 20:30:12','614','2022-11-15 20:48:36',10,0),('1','171',258091,'MORNING SHIFT','2022-11-16','2022-11-16 06:44:55','2022-11-17 06:44:55','571',477138.75,477138.75,'571','2022-11-16 13:22:17','614','2022-11-16 17:03:20',10,0),('1','171',258092,'AFTERNOO SHIFT','2022-11-16','2022-11-16 20:22:47','2022-11-17 20:22:47','571',382189.50,382189.50,'571','2022-11-16 20:49:55','614','2022-11-17 06:03:07',10,0),('1','171',258093,'MORNING SHIFT','2022-11-17','2022-11-17 08:15:58','2022-11-18 08:15:58','571',842011.50,842011.50,'571','2022-11-17 13:21:12','975','2022-11-17 17:31:12',10,0),('1','171',258094,'AFTERNOO SHIFT','2022-11-17','2022-11-17 18:35:13','2022-11-18 18:35:13','571',940112.25,940112.25,'571','2022-11-17 20:36:45','614','2022-11-17 20:42:44',10,0),('1','171',258095,'MORNING SHIFT','2022-11-18','2022-11-18 07:30:37','2022-11-19 07:30:37','571',1129348.55,1129348.55,'571','2022-11-18 13:22:09','614','2022-11-18 15:48:05',10,0),('1','171',258096,'AFTERNOON SHIFT','2022-11-18','2022-11-18 19:35:04','2022-11-19 19:35:04','571',832194.00,832194.00,'571','2022-11-18 20:29:36','614','2022-11-18 21:29:54',10,0),('1','171',258097,'MORNING SHIFT','2022-11-19','2022-11-19 07:12:11','2022-11-20 07:12:11','571',772455.75,772455.75,'571','2022-11-19 13:17:06','975','2022-11-19 13:24:59',10,0),('1','171',258098,'AFTERNOO SHIFT','2022-11-19','2022-11-19 15:40:56','2022-11-20 15:40:56','571',166395.60,166395.60,'571','2022-11-19 20:19:31','614','2022-11-19 23:36:46',10,0),('1','171',258099,'MORNING SHIFT','2022-11-20','2022-11-20 06:56:09','2022-11-21 06:56:09','571',102606.00,102606.00,'571','2022-11-20 13:11:13','614','2022-11-20 15:41:12',10,0),('1','171',258100,'AFTERNOON SHIFT','2022-11-20','2022-11-20 19:24:52','2022-11-21 19:24:52','571',179701.20,179701.20,'571','2022-11-20 20:37:56','614','2022-11-20 23:01:36',10,0),('1','171',258101,'MORNING SHIFT','2022-11-21','2022-11-21 07:51:31','2022-11-22 07:51:31','571',321862.80,321862.80,'571','2022-11-21 13:15:39','614','2022-11-21 15:39:31',10,0),('1','171',258102,'AFTERNOON SHIFT','2022-11-21','2022-11-21 20:23:14','2022-11-22 20:23:14','571',282920.40,282920.40,'571','2022-11-21 20:25:07','614','2022-11-21 21:41:32',10,0),('1','171',258103,'MORNING SHIFT','2022-11-22','2022-11-22 07:25:36','2022-11-23 07:25:36','571',385652.40,385652.40,'571','2022-11-22 13:30:16','614','2022-11-22 15:58:35',10,0),('1','171',258104,'AFTERNOO SHIFT','2022-11-22','2022-11-22 18:13:24','2022-11-23 18:13:24','571',227329.20,227329.20,'571','2022-11-22 21:09:58','614','2022-11-22 23:35:22',10,0),('1','171',258105,'MORNING SHIFT','2022-11-23','2022-11-23 09:55:40','2022-11-24 09:55:40','571',313345.20,313345.20,'571','2022-11-23 13:23:57','614','2022-11-23 14:34:36',10,0),('1','171',258106,'AFTERNOO SHIFT','2022-11-23','2022-11-23 20:14:33','2022-11-24 20:14:33','571',780427.20,780427.20,'571','2022-11-23 20:31:03','614','2022-11-23 23:31:23',10,0),('1','171',258107,'MORNING SHIFT','2022-11-24','2022-11-24 07:57:51','2022-11-25 07:57:51','571',527679.60,527679.60,'571','2022-11-24 13:29:21','614','2022-11-24 14:43:17',10,0),('1','171',258108,'AFTERNOO SHIFT','2022-11-24','2022-11-24 20:14:33','2022-11-25 20:14:33','571',1352352.20,1352352.20,'571','2022-11-24 20:19:55','614','2022-11-24 23:24:21',10,0),('1','171',258109,'MORNING SHIFT','2022-11-25','2022-11-25 06:59:47','2022-11-26 06:59:47','571',445112.40,445112.40,'571','2022-11-25 13:17:10','614','2022-11-25 15:06:27',10,0),('1','171',258110,'AFTERNOO SHIFT','2022-11-25','2022-11-25 17:35:59','2022-11-26 17:35:59','571',429317.50,429317.50,'571','2022-11-25 20:38:05','614','2022-11-26 11:08:30',10,0),('1','171',258111,'MORNING SHIFT','2022-11-26','2022-11-26 11:42:05','2022-11-27 11:42:05','571',1170640.30,1170640.30,'571','2022-11-26 14:03:54','614','2022-11-26 16:24:15',10,0),('1','171',258112,'MORNING SHIFT','2022-11-26','2022-11-26 19:23:50','2022-11-27 19:23:50','571',1306785.20,1306785.20,'571','2022-11-26 20:37:16','614','2022-11-27 13:17:57',10,0),('1','171',258113,'MORNING SHIFT','2022-11-27','2022-11-27 13:24:11','2022-11-28 13:24:11','571',91880.10,91880.10,'571','2022-11-27 13:27:18','614','2022-11-27 21:53:51',10,0),('1','171',258114,'AFTERNOON SHIFT','2022-11-27','2022-11-27 21:56:57','2022-11-28 21:56:57','571',108754.90,108754.90,'571','2022-11-27 21:59:07','614','2022-11-28 07:05:34',10,0),('1','171',258115,'MORNING SHIFT','2022-11-28','2022-11-28 10:26:13','2022-11-29 10:26:13','571',473473.50,473473.50,'571','2022-11-28 13:47:34','614','2022-11-28 17:56:17',10,0),('1','171',258116,'AFTERNOO SHIFT','2022-11-28','2022-11-28 19:08:14','2022-11-29 19:08:14','571',1117030.60,1117030.60,'571','2022-11-28 20:41:06','614','2022-11-29 12:12:48',10,0),('1','171',258117,'MORNING SHIFT','2022-11-29','2022-11-29 12:15:21','2022-11-30 12:15:21','571',806511.00,806511.00,'571','2022-11-29 12:49:15','975','2022-11-29 13:04:52',10,0),('1','171',258118,'AFTERNOON SHIFT','2022-11-29','2022-11-29 21:07:45','2022-11-30 21:07:45','571',496431.60,496431.60,'571','2022-11-29 21:09:19','614','2022-11-29 22:29:33',10,0),('1','171',258119,'MORNING SHIFT','2022-11-30','2022-11-30 07:21:31','2022-12-01 07:21:31','571',564849.60,564849.60,'571','2022-11-30 13:22:18','614','2022-11-30 15:34:59',10,0),('1','171',258120,'AFTERNOO SHIFT','2022-11-30','2022-11-30 15:49:28','2022-12-01 15:49:28','571',1028941.20,1028941.20,'571','2022-11-30 20:27:09','975','2022-12-01 13:40:55',10,0),('1','171',258121,'MORNING SHIFT','2022-12-01','2022-12-01 13:46:11','2022-12-02 13:46:11','571',866149.20,866149.20,'571','2022-12-01 16:18:44','975','2022-12-02 10:35:46',10,0),('1','171',258122,'AFTERNOO SHIFT','2022-12-01','2022-12-02 11:09:51','2022-12-03 11:09:51','571',496944.00,496944.00,'571','2022-12-02 11:16:55','975','2022-12-02 15:36:48',10,0),('1','171',258123,'MORNING SHIFT','2022-12-02','2022-12-02 16:10:54','2022-12-03 16:10:54','571',1128699.60,1128699.60,'571','2022-12-02 16:17:27','975','2022-12-03 13:40:53',10,0),('1','171',258124,'AFTERNOO SHIFT','2022-12-02','2022-12-03 14:04:50','2022-12-04 14:04:50','571',602019.60,602019.60,'571','2022-12-03 14:10:43','975','2022-12-03 14:32:14',10,0),('1','171',258125,'MORNING SHIFT','2022-12-03','2022-12-03 15:06:58','2022-12-04 15:06:58','571',1278549.20,1278549.20,'571','2022-12-03 15:20:20','975','2022-12-03 21:11:11',10,0),('1','171',258126,'AFTERNOON SHIFT','2022-12-03','2022-12-03 21:13:10','2022-12-04 21:13:10','571',864286.20,864286.20,'571','2022-12-03 21:16:37','975','2022-12-04 08:40:21',10,0),('1','171',258127,'MORNING SHIFT','2022-12-04','2022-12-04 09:31:50','2022-12-05 09:31:50','571',1213247.20,1213247.20,'571','2022-12-04 15:00:00','975','2022-12-05 05:50:18',10,0),('1','171',258128,'AFTERNOO SHIFT','2022-12-04','2022-12-05 07:15:07','2022-12-06 07:15:07','571',1593438.00,1593438.00,'571','2022-12-05 12:29:04','975','2022-12-05 17:51:01',10,0),('1','171',258129,'MORNING SHIFT','2022-12-05','2022-12-05 18:23:21','2022-12-06 18:23:21','571',1183083.00,1183083.00,'571','2022-12-05 18:25:33','975','2022-12-06 10:10:06',10,0),('1','171',258130,'AFTERNOO SHIFT','2022-12-06','2022-12-06 10:30:44','2022-12-07 10:30:44','571',1594025.40,1594025.40,'571','2022-12-06 10:34:41','975','2022-12-06 11:18:16',10,0),('1','171',258131,'MORNING SHIFT','2022-12-06','2022-12-06 11:23:07','2022-12-07 11:23:07','571',1378225.20,1378225.20,'571','2022-12-06 13:39:07','975','2022-12-06 15:19:22',10,0),('1','171',258132,'AFTERNOO SHIFT','2022-12-06','2022-12-06 18:03:54','2022-12-07 18:03:54','571',1211489.40,1211489.40,'571','2022-12-06 20:19:10','975','2022-12-06 20:23:50',10,0),('1','171',258133,'MORNING SHIFT','2022-12-07','2022-12-07 05:00:07','2022-12-08 05:00:07','571',1378666.20,1378666.20,'571','2022-12-07 14:00:52','975','2022-12-07 14:02:42',10,0),('1','171',258134,'AFTERNOON SHIFT','2022-12-07','2022-12-07 20:30:31','2022-12-08 20:30:31','571',1919460.60,1919460.60,'571','2022-12-07 20:33:23','975','2022-12-08 10:22:13',10,0),('1','171',258135,'MORNING SHIFT','2022-12-08','2022-12-08 10:26:26','2022-12-09 10:26:26','571',1615107.00,1615107.00,'571','2022-12-08 14:03:43','975','2022-12-08 15:34:27',10,0),('1','171',258136,'AFTERNOON SHIFT','2022-12-08','2022-12-08 20:40:22','2022-12-09 20:40:22','571',952191.20,952191.20,'571','2022-12-08 20:42:29','975','2022-12-09 09:09:04',10,0),('1','171',258137,'MORNING SHIFT','2022-12-09','2022-12-09 10:33:13','2022-12-10 10:33:13','571',2262712.00,2262712.00,'571','2022-12-09 13:21:57','975','2022-12-09 17:58:29',10,0),('1','171',258138,'AFTERNOON SHIFT','2022-12-09','2022-12-09 20:48:38','2022-12-10 20:48:38','571',1426505.40,1426505.40,'571','2022-12-09 20:52:07','975','2022-12-10 11:47:30',10,0),('1','171',258139,'MORNING SHIFT','2022-12-10','2022-12-10 12:46:52','2022-12-11 12:46:52','571',962714.40,962714.40,'571','2022-12-10 13:22:25','975','2022-12-10 14:02:11',10,0),('1','171',258140,'AFTERNOON SHIFT','2022-12-10','2022-12-10 20:02:36','2022-12-11 20:02:36','571',1090261.20,1090261.20,'571','2022-12-10 20:04:42','975','2022-12-11 07:58:14',10,0),('1','171',258141,'MORNING SHIFT','2022-12-11','2022-12-11 08:34:33','2022-12-12 08:34:33','571',129379.40,129379.40,'571','2022-12-11 12:49:58','975','2022-12-11 15:38:55',10,0),('1','171',258142,'AFTERNOO SHIFT','2022-12-11','2022-12-11 18:49:07','2022-12-12 18:49:07','571',128748.40,128748.40,'571','2022-12-11 18:50:17','975','2022-12-12 08:32:13',10,0),('1','171',258143,'MORNING SHIFT','2022-12-12','2022-12-12 09:32:05','2022-12-13 09:32:05','571',117867.20,117867.20,'571','2022-12-12 13:13:43','975','2022-12-12 20:13:02',10,0),('1','171',258144,'AFTERNOON SHIFT','2022-12-12','2022-12-12 21:29:05','2022-12-13 21:29:05','571',303360.20,303360.20,'571','2022-12-12 21:30:32','975','2022-12-13 10:22:10',10,0),('1','171',258145,'MORNING SHIFT','2022-12-13','2022-12-13 11:27:40','2022-12-14 11:27:40','571',721306.00,721306.00,'571','2022-12-13 13:50:51','975','2022-12-13 15:33:22',10,0),('1','171',258146,'AFTERNOON SHIFT','2022-12-13','2022-12-13 18:49:27','2022-12-14 18:49:27','571',61316.20,61316.20,'571','2022-12-13 18:50:37','975','2022-12-14 12:46:01',10,0),('1','171',258147,'MORNING SHIFT','2022-12-14','2022-12-14 13:15:45','2022-12-15 13:15:45','571',62277.60,62277.60,'571','2022-12-14 13:16:37','975','2022-12-14 16:34:43',10,0),('1','171',258148,'AFTERNOON SHIFT','2022-12-14','2022-12-14 19:04:03','2022-12-15 19:04:03','571',212520.00,212520.00,'571','2022-12-14 19:05:28','975','2022-12-14 19:16:14',10,0),('1','171',258149,'MORNING SHIFT','2022-12-15','2022-12-15 09:18:04','2022-12-16 09:18:04','571',760295.00,760295.00,'571','2022-12-15 13:28:53','975','2022-12-15 15:22:07',10,0),('1','171',258150,'AFTERNOON SHIFT','2022-12-15','2022-12-15 20:21:15','2022-12-16 20:21:15','571',566234.80,566234.80,'571','2022-12-15 20:26:50','975','2022-12-16 14:03:29',10,0),('1','171',258151,'MORNING SHIFT','2022-12-16','2022-12-16 14:39:34','2022-12-17 14:39:34','571',1109542.00,1109542.00,'571','2022-12-16 14:42:32','975','2022-12-16 20:19:04',10,0),('1','171',258152,'AFTERNOON SHIFT','2022-12-16','2022-12-16 20:22:05','2022-12-17 20:22:05','571',1174180.80,1174180.80,'571','2022-12-16 20:24:22','975','2022-12-17 13:10:16',10,0),('1','171',258153,'MORNING SHIFT','2022-12-17','2022-12-17 13:28:04','2022-12-18 13:28:04','571',716860.40,716860.40,'571','2022-12-17 14:24:33','975','2022-12-17 19:15:42',10,0),('1','171',258154,'AFTERNOON SHIFT','2022-12-17','2022-12-17 20:16:09','2022-12-18 20:16:09','571',198759.80,198759.80,'571','2022-12-17 20:17:39','975','2022-12-19 07:24:33',10,0),('1','171',258155,'MORNING SHIFT','2022-12-18','2022-12-19 08:46:30','2022-12-20 08:46:30','571',235807.40,235807.40,'571','2022-12-19 09:07:08','975','2022-12-19 11:02:11',10,0),('1','171',258156,'AFTERNOO SHIFT','2022-12-18','2022-12-19 11:21:02','2022-12-20 11:21:02','571',260456.00,260456.00,'571','2022-12-19 11:25:27','975','2022-12-19 18:32:29',10,0),('1','171',258157,'MORNING SHIFT','2022-12-19','2022-12-19 19:49:17','2022-12-20 19:49:17','571',821517.00,821517.00,'571','2022-12-19 20:35:37','975','2022-12-20 10:38:00',10,0),('1','171',258158,'AFTERNOO SHIFT','2022-12-19','2022-12-20 10:53:56','2022-12-21 10:53:56','571',847423.00,847423.00,'571','2022-12-20 11:01:25','975','2022-12-20 17:27:50',10,0),('1','171',258159,'MORNING SHIFT','2022-12-20','2022-12-20 17:43:33','2022-12-21 17:43:33','571',1108131.60,1108131.60,'571','2022-12-20 18:02:40','975','2022-12-20 20:03:41',10,0),('1','171',258160,'AFTERNO0N SHIFT','2022-12-20','2022-12-20 20:19:51','2022-12-21 20:19:51','571',3601145.80,3601145.80,'571','2022-12-20 21:07:51','975','2022-12-21 06:13:52',10,0),('1','171',258161,'MORNING SHIFT','2022-12-21','2022-12-21 08:44:01','2022-12-22 08:44:01','571',3285460.60,3285460.60,'571','2022-12-21 13:49:30','975','2022-12-21 19:06:10',10,0),('1','171',258162,'AFTERNOON SHIFT','2022-12-21','2022-12-21 19:17:38','2022-12-22 19:17:38','571',1288836.70,1288836.70,'571','2022-12-21 19:19:40','975','2022-12-22 15:17:02',10,0),('1','171',258163,'MORNING SHIFT','2022-12-22','2022-12-22 16:06:03','2022-12-23 16:06:03','571',2184457.20,2184457.20,'571','2022-12-22 16:18:03','975','2022-12-22 19:49:04',10,0),('1','171',258164,'AFTERNOON SHIFT','2022-12-22','2022-12-22 20:02:11','2022-12-23 20:02:11','571',400285.30,400285.30,'571','2022-12-22 20:06:08','975','2022-12-23 11:49:46',10,0),('1','171',258165,'Morning shift','2022-12-23','2022-12-23 12:34:33','2022-12-24 12:34:33','571',2662164.40,2662164.40,'571','2022-12-23 13:04:48','975','2022-12-23 16:34:20',10,0),('1','171',258166,'AFTERNOO SHIFT','2022-12-23','2022-12-23 16:43:45','2022-12-24 16:43:45','571',5665657.30,5665657.30,'571','2022-12-23 21:41:55','975','2022-12-24 09:55:04',10,0),('1','171',258167,'AFTERNOON SHIFT','2022-12-24','2022-12-24 12:21:13','2022-12-25 12:21:13','571',5386667.30,5386667.30,'571','2022-12-24 14:19:37','975','2022-12-24 15:39:12',10,0),('1','171',258168,'AFTERNOON SHIFT','2022-12-24','2022-12-24 18:42:04','2022-12-25 18:42:04','571',885738.50,885738.50,'571','2022-12-24 19:17:32','975','2022-12-25 06:57:38',10,0),('1','171',258169,'AFTERNOON SHIFT','2022-12-25','2022-12-25 14:01:31','2022-12-26 14:01:31','571',4415938.30,4415938.30,'571','2022-12-25 14:06:06','975','2022-12-26 08:24:22',10,0),('1','171',258170,'AFTERNOO SHIFT','2022-12-25','2022-12-26 11:18:11','2022-12-27 11:18:11','571',1119669.25,1119669.25,'571','2022-12-26 11:20:20','975','2022-12-26 18:54:25',10,0),('1','171',258171,'MORNING SHIFT ','2022-12-26','2022-12-26 19:12:14','2022-12-27 19:12:14','571',3232456.10,3232456.10,'571','2022-12-26 19:14:49','975','2022-12-27 10:17:24',10,0),('1','171',258172,'AFTERNOO SHIFT','2022-12-26','2022-12-27 11:15:16','2022-12-28 11:15:16','571',72683.15,72683.15,'571','2022-12-27 11:16:28','975','2022-12-27 13:09:49',10,0),('1','171',258173,'MORNING SHIFT','2022-12-27','2022-12-27 17:05:37','2022-12-28 17:05:37','571',923338.50,923338.50,'571','2022-12-28 17:16:16','975','2022-12-29 12:26:34',10,0),('1','171',258174,'MORNING SHIFT','2022-12-28','2022-12-29 12:51:46','2022-12-30 12:51:46','571',524308.00,524308.00,'571','2022-12-29 12:53:13','975','2022-12-29 15:05:17',10,0),('1','171',258175,'AFTERNOO SHIFT','2022-12-28','2022-12-29 15:38:37','2022-12-30 15:38:37','571',792505.40,792505.40,'571','2022-12-29 15:41:49','975','2022-12-29 16:29:00',10,0),('1','171',258176,'MORNING SHIFT','2022-12-29','2022-12-29 17:59:32','2022-12-30 17:59:32','571',1310663.40,1310663.40,'571','2022-12-29 18:02:36','975','2022-12-30 11:38:34',10,0),('1','171',258177,'AFTERNOO SHIFT','2022-12-29','2022-12-30 11:47:19','2022-12-31 11:47:19','571',3930645.40,3930645.40,'571','2022-12-30 13:03:53','975','2022-12-30 19:32:39',10,0),('1','171',258178,'Morning shift','2022-12-30','2022-12-30 20:29:21','2022-12-31 20:29:21','571',2559459.45,2559459.45,'571','2022-12-31 10:02:34','975','2022-12-31 10:47:01',10,0),('1','171',258179,'AFTERNOON SHIFT','2022-12-30','2022-12-31 12:47:44','2023-01-01 12:47:44','571',1414204.20,1414204.20,'571','2022-12-31 12:50:54','975','2022-12-31 16:56:06',10,0),('1','171',258180,'MORNING SHIFT','2022-12-31','2022-12-31 17:43:07','2023-01-01 17:43:07','571',2857107.80,2857107.80,'571','2023-01-01 12:48:24','975','2023-01-02 10:46:46',10,0),('1','171',258181,'AFTERNOO SHIFT','2022-12-31','2023-01-02 11:35:21','2023-01-03 11:35:21','571',2994181.15,2994181.15,'571','2023-01-02 12:41:03','975','2023-01-02 12:58:55',10,0),('1','171',258182,'MORNING SHIFT','2023-01-01','2023-01-02 13:30:31','2023-01-03 13:30:31','571',2952035.25,2952035.25,'571','2023-01-02 13:35:29','975','2023-01-02 16:35:37',10,0),('1','171',258183,'AFTERNOO SHIFT','2023-01-01','2023-01-02 16:56:21','2023-01-03 16:56:21','571',1868231.70,1868231.70,'571','2023-01-02 17:03:46','975','2023-01-03 13:15:54',10,0),('1','171',258184,'Morning shift','2023-01-02','2023-01-03 13:43:36','2023-01-04 13:43:36','571',2648111.90,2648111.90,'571','2023-01-03 13:50:01','975','2023-01-03 14:41:27',10,0),('1','171',258185,'AFTERNOO SHIFT','2023-01-02','2023-01-03 15:39:24','2023-01-04 15:39:24','571',1726315.00,1726315.00,'571','2023-01-03 15:44:54','975','2023-01-04 10:31:26',10,0),('1','171',258186,'MORNING SHIFT','2023-01-03','2023-01-04 11:37:04','2023-01-05 11:37:04','571',3531465.65,3531465.65,'571','2023-01-04 11:44:44','975','2023-01-05 09:09:39',10,0),('1','171',258187,'AFTERNOO SHIFT','2023-01-03','2023-01-05 12:20:53','2023-01-06 12:20:53','571',2795183.45,2795183.45,'571','2023-01-05 12:24:44','975','2023-01-05 20:21:36',10,0),('1','171',258188,'MORNING SHIFT','2023-01-04','2023-01-07 18:09:01','2023-01-08 18:09:01','571',2954648.60,2954648.60,'571','2023-01-07 18:11:34','975','2023-01-08 09:58:14',10,0),('1','171',258189,'AFTERNOO SHIFT','2023-01-07','2023-01-08 11:56:46','2023-01-09 11:56:46','571',633400.80,633400.80,'571','2023-01-08 11:57:37','975','2023-01-09 09:35:54',10,0),('1','171',258190,'MORNING SHIFT','2023-01-08','2023-01-09 10:08:01','2023-01-10 10:08:01','571',109609.40,109609.40,'571','2023-01-09 10:25:26','975','2023-01-09 11:32:35',10,0),('1','171',258191,'AFTERNOO SHIFT','2023-01-08','2023-01-09 12:07:35','2023-01-10 12:07:35','571',814333.80,814333.80,'571','2023-01-09 12:09:07','975','2023-01-09 17:01:14',10,0),('1','171',258192,'MORNING SHIFT','2023-01-09','2023-01-09 17:22:53','2023-01-10 17:22:53','571',1890485.40,1890485.40,'571','2023-01-09 17:24:39','975','2023-01-10 09:51:23',10,0),('1','171',258193,'AFTERNOO SHIFT','2023-01-09','2023-01-10 09:54:16','2023-01-11 09:54:16','571',862861.40,862861.40,'571','2023-01-10 10:04:32','975','2023-01-10 14:36:59',10,0),('1','171',258194,'Morning shift','2023-01-10','2023-01-10 15:37:10','2023-01-11 15:37:10','571',5304817.10,5304817.10,'571','2023-01-10 16:54:51','975','2023-01-10 17:13:43',10,0),('1','171',258195,'AFTERNOO SHIFT','2023-01-10','2023-01-10 18:09:35','2023-01-11 18:09:35','571',3605275.55,3605275.55,'571','2023-01-10 20:23:05','975','2023-01-11 10:15:10',10,0),('1','171',258196,'MORNING SHIFT','2023-01-11','2023-01-11 12:13:42','2023-01-12 12:13:42','571',3899824.45,3899824.45,'571','2023-01-11 14:45:42','975','2023-01-11 18:27:40',10,0),('1','171',258197,'AFTERNOO SHIFT','2023-01-11','2023-01-11 18:43:57','2023-01-12 18:43:57','571',2982772.10,2982772.10,'571','2023-01-11 20:43:55','975','2023-01-12 12:25:17',10,0),('1','171',258198,'MORNING SHIFT','2023-01-12','2023-01-12 12:25:50','2023-01-13 12:25:50','571',3890470.40,3890470.40,'571','2023-01-12 15:16:57','975','2023-01-12 15:19:45',10,0),('1','171',258199,'AFTERNOON SHIFT','2023-01-12','2023-01-12 20:25:30','2023-01-13 20:25:30','571',4338954.25,4338954.25,'571','2023-01-12 20:33:47','975','2023-01-13 10:37:30',10,0),('1','171',258200,'Morning shift','2023-01-13','2023-01-13 11:16:09','2023-01-14 11:16:09','571',3558818.15,3558818.15,'571','2023-01-13 14:44:40','975','2023-01-13 21:50:27',10,0),('1','171',258201,'AFTERNOO SHIFT','2023-01-13','2023-01-13 23:20:28','2023-01-14 23:20:28','571',2456783.90,2456783.90,'571','2023-01-14 09:42:49','975','2023-01-14 10:54:57',10,0),('1','171',258202,'Morning shift','2023-01-14','2023-01-14 13:30:27','2023-01-15 13:30:27','571',1039382.80,1039382.80,'571','2023-01-14 13:35:17','975','2023-01-14 13:42:17',10,0),('1','171',258203,'Afternoon Shift','2023-01-14','2023-01-14 19:17:32','2023-01-15 19:17:32','571',1596677.15,1596677.15,'571','2023-01-14 19:19:25','975','2023-01-15 12:28:53',10,0),('1','171',258204,'Morning shift','2023-01-15','2023-01-15 12:35:34','2023-01-16 12:35:34','571',315101.40,315101.40,'571','2023-01-15 14:23:12','975','2023-01-16 09:18:03',10,0),('1','171',258205,'AFTERNOO SHIFT','2023-01-15','2023-01-16 09:26:34','2023-01-17 09:26:34','571',2077336.05,2077336.05,'571','2023-01-16 09:29:13','734','2023-01-16 12:54:10',10,0),('1','171',258206,'MORNING SHIFT','2023-01-16','2023-01-16 13:07:28','2023-01-17 13:07:28','571',1437591.20,1437591.20,'571','2023-01-16 13:16:30','734','2023-01-16 14:58:36',10,0),('1','171',258207,'AFTERNOO SHIFT','2023-01-16','2023-01-16 19:58:16','2023-01-17 19:58:16','571',1100333.40,1100333.40,'571','2023-01-17 08:22:12','734','2023-01-17 11:52:18',10,0),('1','171',258208,'Morning shift','2023-01-17','2023-01-17 13:41:02','2023-01-18 13:41:02','571',1082845.90,1082845.90,'571','2023-01-17 13:46:54','734','2023-01-17 14:47:11',10,0),('1','171',258209,'AFTERNOO SHIFT','2023-01-17','2023-01-17 18:17:36','2023-01-18 18:17:36','571',2785083.20,2785083.20,'571','2023-01-17 19:13:45','734','2023-01-17 20:42:52',10,0),('1','171',258210,'AFTERNOO SHIFT 2','2023-01-17','2023-01-17 21:34:34','2023-01-18 21:34:34','571',534405.60,534405.60,'571','2023-01-18 10:48:37','734','2023-01-18 12:33:33',10,0),('1','171',258211,'Morning shift','2023-01-18','2023-01-18 13:24:44','2023-01-19 13:24:44','571',1740555.80,1740555.80,'571','2023-01-18 13:27:40','734','2023-01-18 14:22:56',10,0),('1','171',258212,'AFTERNOON SHIFT','2023-01-18','2023-01-18 20:58:37','2023-01-19 20:58:37','571',1454020.40,1454020.40,'571','2023-01-18 21:00:45','734','2023-01-18 21:49:20',10,0),('1','171',258213,'MORNING SHIFT','2023-01-19','2023-01-19 07:48:15','2023-01-20 07:48:15','571',5100022.65,5100022.65,'571','2023-01-19 15:41:57','734','2023-01-19 16:47:09',10,0),('1','171',258214,'AFTERNOON SHIFT','2023-01-19','2023-01-19 19:09:18','2023-01-20 19:09:18','571',497923.20,497923.20,'571','2023-01-19 19:10:46','734','2023-01-19 19:11:25',10,0),('1','171',258215,'Morning shift','2023-01-20','2023-01-20 06:31:09','2023-01-21 06:31:09','571',3456901.80,3456901.80,'571','2023-01-20 13:27:33','734','2023-01-20 14:01:44',10,0),('1','171',258216,'AFTERNOON SHIFT','2023-01-20','2023-01-20 20:15:23','2023-01-21 20:15:23','571',1410671.70,1410671.70,'571','2023-01-20 20:17:39','734','2023-01-21 03:42:49',10,0),('1','171',258217,'MORNING SHIFT','2023-01-21','2023-01-21 07:33:20','2023-01-22 07:33:20','571',1705865.20,1705865.20,'571','2023-01-21 15:17:14','734','2023-01-21 16:41:47',10,0),('1','171',258218,'AFTERNOO SHIFT','2023-01-21','2023-01-21 21:56:13','2023-01-22 21:56:13','571',7707831.20,7707831.20,'571','2023-01-21 22:01:01','734','2023-01-22 10:09:54',10,0),('1','171',258219,'MORNING SHIFT1 ','2023-01-22','2023-01-22 10:27:11','2023-01-23 10:27:11','571',1178210.10,1178210.10,'571','2023-01-22 11:25:11','734','2023-01-22 16:40:44',10,0),('1','171',258220,'MORNING SHIFT 2','2023-01-22','2023-01-22 17:00:21','2023-01-23 17:00:21','571',0.00,0.00,'571','2023-01-22 17:57:48','734','2023-01-22 17:58:36',10,0),('1','171',258221,'Morning shift 2','2023-01-22','2023-01-22 18:07:16','2023-01-23 18:07:16','571',4915052.00,4915052.00,'571','2023-01-22 19:31:07','734','2023-01-22 19:45:05',10,0),('1','171',258222,'AFTERNOO SHIFT','2023-01-22','2023-01-22 21:22:55','2023-01-23 21:22:55','571',2152931.40,2152931.40,'571','2023-01-23 09:20:09','734','2023-01-23 10:14:40',10,0),('1','171',258223,'Morning shift','2023-01-23','2023-01-23 10:55:15','2023-01-24 10:55:15','571',0.00,0.00,'571','2023-01-23 14:50:17','734','2023-01-23 15:49:49',10,0),('1','171',258224,'MORNING SHIFT','2023-01-23','2023-01-23 17:53:49','2023-01-24 17:53:49','571',0.00,0.00,'571','2023-01-23 17:55:19','734','2023-01-23 22:16:47',10,0),('1','171',258225,'MORNING SHIFT','2023-01-23','2023-01-23 22:23:27','2023-01-24 22:23:27','571',1427896.10,1427896.10,'571','2023-01-23 22:25:41','734','2023-01-24 08:37:21',10,0),('1','171',258226,'AFTERNOO SHIFT','2023-01-23','2023-01-24 09:01:55','2023-01-25 09:01:55','571',605191.50,605191.50,'571','2023-01-24 14:15:19','734','2023-01-24 14:51:35',10,0),('1','171',258227,'AFTERNOO SHIFT','2023-01-28','2023-01-28 19:27:47','2023-01-29 19:27:47','571',889050.20,889050.20,'571','2023-01-28 20:33:07','734','2023-01-28 20:34:50',10,0),('1','171',258228,'Morning shift','2023-01-29','2023-01-29 13:29:57','2023-01-30 13:29:57','571',2713367.50,2713367.50,'571','2023-01-29 13:37:10','734','2023-01-29 14:33:04',10,0),('1','171',258229,'AFTERNOON SHIFT','2023-01-29','2023-01-30 07:42:44','2023-01-31 07:42:44','571',1034725.40,1034725.40,'571','2023-01-30 09:54:35','734','2023-01-30 10:52:37',10,0),('1','171',258230,'Morning shift','2023-01-30','2023-01-30 18:00:26','2023-01-31 18:00:26','571',2496657.30,2496657.30,'571','2023-01-30 18:39:46','734','2023-01-30 19:10:56',10,0),('1','171',258231,'AFTERNOO SHIFT 1','2023-01-30','2023-01-30 19:34:24','2023-01-31 19:34:24','571',920000.00,920000.00,'571','2023-01-30 19:48:00','734','2023-01-30 21:23:13',10,0),('1','171',258232,'AFTERNOO SHIFT 2','2023-01-30','2023-01-30 21:44:51','2023-01-31 21:44:51','571',1113439.00,1113439.00,'571','2023-01-30 21:48:13','734','2023-01-31 05:55:20',10,0),('1','171',258233,'MORNING SHIFT','2023-01-31','2023-01-31 09:27:24','2023-02-01 09:27:24','571',3420223.00,3420223.00,'571','2023-01-31 16:05:37','734','2023-01-31 17:12:33',10,0),('1','171',258234,'AFTERNOON SHIFT','2023-01-31','2023-01-31 20:33:34','2023-02-01 20:33:34','571',2038333.50,2038333.50,'571','2023-01-31 20:40:58','734','2023-01-31 22:30:24',10,0),('1','171',258235,'Morning shift','2023-02-01','2023-02-01 09:50:53','2023-02-02 09:50:53','571',3276924.10,3276924.10,'571','2023-02-01 17:55:19','734','2023-02-01 19:30:44',10,0),('1','171',258236,'AFTERNOON SHIFT','2023-02-01','2023-02-01 20:34:18','2023-02-02 20:34:18','571',902930.50,902930.50,'571','2023-02-01 20:35:57','734','2023-02-01 21:23:45',10,0),('1','171',258237,'MORNING SHIFT','2023-02-02','2023-02-02 07:31:10','2023-02-03 07:31:10','571',3105774.40,3105774.40,'571','2023-02-02 13:42:24','734','2023-02-02 14:10:34',10,0),('1','171',258238,'AFTERNOO SHIFT','2023-02-02','2023-02-02 18:43:14','2023-02-03 18:43:14','571',1891797.20,1891797.20,'571','2023-02-02 21:15:17','734','2023-02-03 04:34:35',10,0),('1','171',258239,'Morning shift','2023-02-03','2023-02-03 10:01:45','2023-02-04 10:01:45','571',516794.30,516794.30,'571','2023-02-03 15:08:59','734','2023-02-03 17:06:11',10,0),('1','171',258240,'AFTERNOO SHIFT','2023-02-06','2023-02-06 20:39:35','2023-02-07 20:39:35','571',1146488.00,1146488.00,'571','2023-02-06 22:35:34','734','2023-02-07 09:57:51',10,0),('1','171',258241,'  Morning shift','2023-02-07','2023-02-07 14:18:21','2023-02-08 14:18:21','571',1668102.00,1668102.00,'571','2023-02-07 14:20:00','734','2023-02-07 17:10:13',10,0),('1','171',258242,'MORNING SHIFT','2023-02-07','2023-02-07 20:45:49','2023-02-08 20:45:49','571',1841202.00,1841202.00,'571','2023-02-07 20:55:12','734','2023-02-07 21:19:24',10,0),('1','171',258243,'MORNING SHIFT','2023-02-08','2023-02-08 14:25:54','2023-02-09 14:25:54','571',1605248.00,1605248.00,'571','2023-02-08 14:28:30','734','2023-02-08 14:50:26',10,0),('1','171',258244,'AFTERNOON SHIFT','2023-02-08','2023-02-08 17:16:01','2023-02-09 17:16:01','571',1269092.00,1269092.00,'571','2023-02-08 20:10:50','734','2023-02-08 21:10:16',10,0),('1','171',258245,'MORNING SHIFT','2023-02-09','2023-02-09 06:35:03','2023-02-10 06:35:03','571',2569258.00,2569258.00,'571','2023-02-09 14:26:57','734','2023-02-09 14:39:07',10,0),('1','171',258246,'AFTERNOON SHIFT','2023-02-09','2023-02-09 16:39:35','2023-02-10 16:39:35','571',942880.00,942880.00,'571','2023-02-09 20:57:27','734','2023-02-10 06:39:36',10,0),('1','171',258247,'MORNING SHIFT','2023-02-10','2023-02-10 13:31:16','2023-02-11 13:31:16','571',1029024.00,1029024.00,'571','2023-02-10 13:45:37','734','2023-02-10 15:21:26',10,0),('1','171',258248,'Afternoon','2023-02-10','2023-02-10 20:56:40','2023-02-11 20:56:40','571',1413632.00,1413632.00,'571','2023-02-10 21:08:32','734','2023-02-10 21:32:56',10,0),('1','171',258249,'MORNING SHIFT','2023-02-11','2023-02-11 13:38:16','2023-02-12 13:38:16','571',2304744.00,2304744.00,'571','2023-02-11 13:39:39','734','2023-02-11 13:48:16',10,0),('1','171',258250,'AFTERNOON shift','2023-02-11','2023-02-11 15:11:22','2023-02-12 15:11:22','571',1277568.00,1277568.00,'571','2023-02-11 21:05:20','734','2023-02-11 21:35:35',10,0),('1','171',258251,'MORNING SHIFT','2023-02-12','2023-02-12 04:42:36','2023-02-13 04:42:36','571',966496.00,966496.00,'571','2023-02-12 13:25:57','734','2023-02-12 14:01:14',10,0),('1','171',258252,'AFTERNOON SHIFT','2023-02-12','2023-02-12 21:15:15','2023-02-13 21:15:15','571',1174416.00,1174416.00,'571','2023-02-12 21:16:13','734','2023-02-12 21:45:03',10,0),('1','171',258253,'MORNING SHIFT','2023-02-13','2023-02-13 07:55:30','2023-02-14 07:55:30','571',2272227.20,2272227.20,'571','2023-02-13 13:48:27','734','2023-02-13 14:43:36',10,0),('1','171',258254,'AFTERNOON SHIFT','2023-02-13','2023-02-13 15:24:33','2023-02-14 15:24:33','571',906792.00,906792.00,'571','2023-02-13 21:28:06','734','2023-02-14 07:36:56',10,0),('1','171',258255,'Morning shift','2023-02-14','2023-02-14 08:25:15','2023-02-15 08:25:15','571',1420232.00,1420232.00,'571','2023-02-14 13:45:02','734','2023-02-14 15:29:08',10,0),('1','171',258256,'AFTERNOON SHIFT','2023-02-14','2023-02-14 22:00:06','2023-02-15 22:00:06','571',341072.00,341072.00,'571','2023-02-14 22:01:16','734','2023-02-14 23:19:24',10,0),('1','171',258257,'Morning shift','2023-02-15','2023-02-15 08:59:45','2023-02-16 08:59:45','571',1067408.00,1067408.00,'571','2023-02-15 13:27:11','734','2023-02-15 14:35:18',10,0),('1','171',258258,'AFTERNOON SHIFT','2023-02-15','2023-02-15 20:55:42','2023-02-16 20:55:42','571',995640.00,995640.00,'571','2023-02-15 21:17:55','734','2023-02-15 22:33:51',10,0),('1','171',258259,'MORNING SHIFT','2023-02-16','2023-02-16 07:26:41','2023-02-17 07:26:41','571',3506480.00,3506480.00,'571','2023-02-16 15:06:10','734','2023-02-16 15:26:28',10,0),('1','171',258260,'AFTERNOON SHIFT','2023-02-16','2023-02-16 21:58:53','2023-02-17 21:58:53','571',2598716.00,2598716.00,'571','2023-02-16 22:03:34','734','2023-02-17 08:17:57',10,0),('1','171',258261,'MORNING SHIFT','2023-02-17','2023-02-17 09:17:40','2023-02-18 09:17:40','571',2801442.00,2801442.00,'571','2023-02-17 14:57:59','734','2023-02-17 15:29:27',10,0),('1','171',258262,'AFTERNOON SHIFT','2023-02-17','2023-02-17 18:44:39','2023-02-18 18:44:39','571',2156326.00,2156326.00,'571','2023-02-17 21:17:45','734','2023-02-17 21:20:22',10,0),('1','171',258263,'MORNING SHIFT','2023-02-18','2023-02-18 10:35:51','2023-02-19 10:35:51','571',1263278.00,1263278.00,'571','2023-02-18 14:33:32','734','2023-02-18 14:34:37',10,0),('1','171',258264,'AFTERNOON SHIFT','2023-02-18','2023-02-18 20:40:22','2023-02-19 20:40:22','571',900172.00,900172.00,'571','2023-02-18 21:34:58','734','2023-02-18 21:39:44',10,0),('1','171',258265,'morning shift','2023-02-19','2023-02-19 14:01:04','2023-02-20 14:01:04','571',1869142.00,1869142.00,'571','2023-02-19 14:06:40','734','2023-02-19 15:21:50',10,0),('1','171',258266,'AFTERNOON SHIFT','2023-02-19','2023-02-19 21:56:18','2023-02-20 21:56:18','571',1595460.00,1595460.00,'571','2023-02-19 21:59:07','734','2023-02-20 15:46:00',10,0),('1','171',258267,'MORNING SHIFT','2023-02-20','2023-02-20 15:49:03','2023-02-21 15:49:03','571',2260080.00,2260080.00,'571','2023-02-20 15:56:31','734','2023-02-20 16:25:47',10,0),('1','171',258268,'AFTERNOON SHIFT','2023-02-20','2023-02-20 21:35:38','2023-02-21 21:35:38','571',2244486.00,2244486.00,'571','2023-02-20 21:39:12','734','2023-02-21 06:47:41',10,0),('1','171',258269,'MORNING SHIFT','2023-02-21','2023-02-21 10:43:57','2023-02-22 10:43:57','571',2565840.00,2565840.00,'571','2023-02-21 18:59:55','734','2023-02-21 20:52:16',10,0),('1','171',258270,'AFTERNOON SHIFT','2023-02-21','2023-02-21 21:09:50','2023-02-22 21:09:50','571',1129262.00,1129262.00,'571','2023-02-21 21:15:57','734','2023-02-21 22:52:20',10,0),('1','171',258271,'MORNING SHIFT','2023-02-22','2023-02-22 13:37:12','2023-02-23 13:37:12','571',2717176.00,2717176.00,'571','2023-02-22 13:39:54','734','2023-02-22 13:44:28',10,0),('1','171',258272,'AFTERNOON SHIFT','2023-02-22','2023-02-22 21:46:33','2023-02-23 21:46:33','571',1283248.00,1283248.00,'571','2023-02-22 21:57:39','734','2023-02-22 22:46:05',10,0),('1','171',258273,'Morning shift','2023-02-23','2023-02-23 06:57:28','2023-02-24 06:57:28','571',2579142.00,2579142.00,'571','2023-02-23 16:36:59','734','2023-02-23 18:37:35',10,0),('1','171',258274,'AFTERNOON SHIFT','2023-02-23','2023-02-23 20:24:01','2023-02-24 20:24:01','571',1204728.00,1204728.00,'571','2023-02-23 20:35:43','734','2023-02-23 22:02:40',10,0),('1','171',258275,'Morning shift','2023-02-24','2023-02-24 15:18:39','2023-02-25 15:18:39','571',1949094.00,1949094.00,'571','2023-02-24 15:20:39','734','2023-02-24 15:27:13',10,0),('1','171',258276,'AFTERNOON SHIFT','2023-02-24','2023-02-24 20:40:03','2023-02-25 20:40:03','571',893690.00,893690.00,'571','2023-02-24 22:15:45','734','2023-02-24 22:18:52',10,0),('1','171',258277,'MORNING SHIFT','2023-02-26','2023-02-26 14:21:53','2023-02-27 14:21:53','571',1791430.00,1791430.00,'571','2023-02-26 14:25:09','734','2023-02-26 21:31:51',10,0),('1','171',258278,'AFTERNOON SHIFT','2023-02-26','2023-02-26 21:47:46','2023-02-27 21:47:46','571',1252182.00,1252182.00,'571','2023-02-26 21:50:39','734','2023-02-26 23:31:18',10,0),('1','171',258279,'MORNING SHIFT','2023-02-27','2023-02-27 08:46:15','2023-02-28 08:46:15','571',2286656.00,2286656.00,'571','2023-02-27 14:11:28','734','2023-02-27 15:45:00',10,0),('1','171',258280,'AFTERNOON SHIFT','2023-02-27','2023-02-27 22:43:56','2023-02-28 22:43:56','571',1227408.00,1227408.00,'571','2023-02-27 22:48:17','734','2023-02-27 23:30:48',10,0),('1','171',258281,'MORNING SHIFT','2023-02-28','2023-02-28 14:12:52','2023-03-01 14:12:52','571',2988244.00,2988244.00,'571','2023-02-28 14:16:15','734','2023-02-28 15:34:40',10,0),('1','171',258282,'AFTERNOON SHIFT','2023-02-28','2023-02-28 21:18:24','2023-03-01 21:18:24','571',1950938.00,1950938.00,'571','2023-02-28 23:32:50','734','2023-03-01 14:47:36',10,0),('1','171',258283,'MORNING SHIFT','2023-03-01','2023-03-01 15:32:01','2023-03-02 15:32:01','571',2634758.00,2634758.00,'571','2023-03-01 15:34:52','734','2023-03-01 15:58:50',10,0),('1','171',258284,'AFTERNOON SHIFT','2023-03-01','2023-03-01 19:35:13','2023-03-02 19:35:13','571',3624836.00,3624836.00,'571','2023-03-01 21:13:58','734','2023-03-01 21:15:39',10,0),('1','171',258285,'Morning shift','2023-03-02','2023-03-02 14:44:57','2023-03-03 14:44:57','571',2933004.00,2933004.00,'571','2023-03-02 14:52:22','734','2023-03-02 15:13:24',10,0),('1','171',258286,'AFTERNOON SHIFT','2023-03-02','2023-03-02 20:23:41','2023-03-03 20:23:41','571',1887806.00,1887806.00,'571','2023-03-02 20:25:57','734','2023-03-02 20:54:49',10,0),('1','171',258287,'Morning shift','2023-03-03','2023-03-03 15:40:16','2023-03-04 15:40:16','571',2858804.00,2858804.00,'571','2023-03-03 15:46:08','734','2023-03-03 16:39:25',10,0),('1','171',258288,'AFTERNOON SHIFT','2023-03-03','2023-03-03 20:34:47','2023-03-04 20:34:47','571',1661312.00,1661312.00,'571','2023-03-03 20:38:09','734','2023-03-03 20:54:09',10,0),('1','171',258289,'Morning shift','2023-03-04','2023-03-04 13:35:01','2023-03-05 13:35:01','571',2489930.00,2489930.00,'571','2023-03-04 14:41:07','734','2023-03-04 14:41:56',10,0),('1','171',258290,'AFTERNOON SHIFT','2023-03-04','2023-03-04 19:25:44','2023-03-05 19:25:44','571',1957768.00,1957768.00,'571','2023-03-04 21:22:57','734','2023-03-04 21:31:54',10,0),('1','171',258291,'MORNING SHIFT','2023-03-05','2023-03-05 06:56:57','2023-03-06 06:56:57','571',653722.00,653722.00,'571','2023-03-05 14:54:12','734','2023-03-05 15:27:43',10,0),('1','171',258292,'Afternoon shift','2023-03-05','2023-03-05 19:55:31','2023-03-06 10:55:31','571',1539242.00,1539242.00,'571','2023-03-05 19:58:21','734','2023-03-05 21:48:26',10,0),('1','171',258293,'MORNING SHIFT','2023-03-06','2023-03-06 13:26:04','2023-03-07 13:26:04','571',659200.00,659200.00,'571','2023-03-06 13:27:23','734','2023-03-06 13:59:38',10,0),('1','171',258294,'AFTERNOON SHIFT','2023-03-06','2023-03-06 20:15:33','2023-03-07 20:15:33','571',194510.00,194510.00,'571','2023-03-06 20:19:22','734','2023-03-06 21:02:38',10,0),('1','171',258295,'morning shift ','2023-03-07','2023-03-07 15:09:21','2023-03-08 15:09:21','571',369664.00,369664.00,'571','2023-03-07 15:15:20','734','2023-03-07 18:17:23',10,0),('1','171',258296,'AFTERNOON SHIRT ','2023-03-07','2023-03-07 20:31:03','2023-03-08 20:31:03','571',161904.00,161904.00,'571','2023-03-07 20:34:47','734','2023-03-07 21:38:18',10,0),('1','171',258297,'Morning shift ','2023-03-08','2023-03-08 13:16:47','2023-03-09 13:16:47','571',979664.00,979664.00,'571','2023-03-08 13:17:39','734','2023-03-08 17:49:04',10,0),('1','171',258298,'AFTERNOON SHIFT','2023-03-08','2023-03-08 21:44:07','2023-03-09 21:44:07','571',1043180.00,1043180.00,'571','2023-03-09 06:44:56','734','2023-03-09 07:58:10',10,0),('1','171',258299,'Morning shift ','2023-03-09','2023-03-09 14:53:37','2023-03-10 14:53:37','571',1705674.00,1705674.00,'571','2023-03-09 15:19:03','734','2023-03-09 15:50:23',10,0),('1','171',258300,'AFTERNOON SHIRT ','2023-03-09','2023-03-09 17:41:00','2023-03-10 17:41:00','571',1843510.00,1843510.00,'571','2023-03-09 20:29:25','734','2023-03-09 23:23:32',10,0),('1','171',258301,'Morning  shift','2023-03-10','2023-03-10 07:08:19','2023-03-11 07:08:19','571',1217210.00,1217210.00,'571','2023-03-10 13:35:33','734','2023-03-10 14:15:06',10,0),('1','171',258302,'AFTERNOON SHIRT ','2023-03-10','2023-03-10 18:46:39','2023-03-11 18:46:39','571',1702960.00,1702960.00,'571','2023-03-10 20:56:20','734','2023-03-10 21:49:18',10,0),('1','171',258303,'Morning shift ','2023-03-11','2023-03-11 13:29:10','2023-03-12 13:29:10','571',1363200.00,1363200.00,'571','2023-03-11 13:34:00','734','2023-03-11 15:36:37',10,0),('1','171',258304,'AFTERNOON SHIRT ','2023-03-11','2023-03-11 17:19:35','2023-03-12 17:19:35','571',659802.00,659802.00,'571','2023-03-11 22:30:06','734','2023-03-12 12:08:47',10,0),('1','171',258305,'Morning shift ','2023-03-12','2023-03-12 12:52:15','2023-03-13 12:52:15','571',1493850.00,1493850.00,'571','2023-03-12 13:50:11','734','2023-03-12 15:12:09',10,0),('1','171',258306,'AFTERNOON SHIRT 21','2023-03-12','2023-03-12 20:24:02','2023-03-13 20:24:02','571',764914.00,764914.00,'571','2023-03-12 20:27:42','734','2023-03-12 22:47:46',10,0),('1','171',258307,'Morning shift','2023-03-13','2023-03-13 08:27:34','2023-03-14 08:27:34','571',1467238.00,1467238.00,'571','2023-03-13 14:44:17','734','2023-03-13 15:19:32',10,0),('1','171',258308,'AFTERNOON SHIRT ','2023-03-13','2023-03-13 20:54:02','2023-03-14 20:54:02','571',716564.00,716564.00,'571','2023-03-13 20:56:17','734','2023-03-13 21:19:10',10,0),('1','171',258309,'Morning  shift','2023-03-14','2023-03-14 06:40:36','2023-03-15 06:40:36','571',3193214.00,3193214.00,'571','2023-03-14 15:45:32','734','2023-03-14 19:05:39',10,0),('1','171',258310,'AFTERNOON SHIRT ','2023-03-14','2023-03-15 07:02:26','2023-03-16 07:02:26','571',1009974.00,1009974.00,'571','2023-03-15 07:04:40','734','2023-03-15 10:02:54',10,0),('1','171',258311,'Morning shift ','2023-03-15','2023-03-15 14:13:34','2023-03-16 14:13:34','571',1565626.00,1565626.00,'571','2023-03-15 15:33:24','734','2023-03-15 16:27:43',10,0),('1','171',258312,'AFTERNOON SHIRT 21','2023-03-15','2023-03-15 18:07:35','2023-03-16 18:07:35','571',2366482.00,2366482.00,'571','2023-03-15 20:48:55','734','2023-03-15 21:00:58',10,0),('1','171',258313,'Morning  shift','2023-03-16','2023-03-16 06:53:37','2023-03-17 06:53:37','571',3595570.00,3595570.00,'571','2023-03-16 14:18:37','734','2023-03-16 15:00:22',10,0),('1','171',258314,'AFTERNOON SHIRT ','2023-03-16','2023-03-16 21:07:39','2023-03-17 21:07:39','571',1906612.00,1906612.00,'571','2023-03-16 21:11:52','734','2023-03-17 12:57:08',10,0),('1','171',258315,'Morning shift ','2023-03-17','2023-03-17 15:07:18','2023-03-18 15:07:18','571',2565840.00,2565840.00,'571','2023-03-17 15:09:14','734','2023-03-17 15:26:45',10,0),('1','171',258316,'AFTERNOON SHIRT ','2023-03-17','2023-03-17 22:11:31','2023-03-18 22:11:31','571',2268720.00,2268720.00,'571','2023-03-17 22:15:18','734','2023-03-18 08:43:33',10,0),('1','171',258317,'Morning  shift','2023-03-19','2023-03-19 09:01:42','2023-03-20 09:01:42','571',2392448.00,2392448.00,'571','2023-03-19 14:18:07','734','2023-03-19 18:20:07',10,0),('1','171',258318,'AFTERNOON SHIRT ','2023-03-19','2023-03-19 20:37:58','2023-03-20 20:37:58','571',2932098.00,2932098.00,'571','2023-03-19 20:40:09','734','2023-03-19 23:23:33',10,0),('1','171',258319,'Morning shift ','2023-03-20','2023-03-20 11:06:05','2023-03-21 11:06:05','571',2241402.00,2241402.00,'571','2023-03-20 13:49:53','734','2023-03-20 15:17:42',10,0),('1','171',258320,'AFTERNOON SHIRT ','2023-03-20','2023-03-20 21:06:50','2023-03-21 21:06:50','571',2580885.60,2580885.60,'571','2023-03-20 21:09:51','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4915038 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','171','877','192616',3763574,'2593','388',160178.28,160178.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192616',3763575,'2594','388',144033.67,144033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192616',3763576,'2595','388',118664.18,118664.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192616',3763577,'2596','388',168852.90,168857.20,4.30,700.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','192616',3763578,'2597','388',136724.98,138294.71,1569.73,255865.99,0.00,0.00,0.00,0.00,0.00),('1','171','878','192616',3763579,'2598','388',131381.34,132815.35,1434.01,233743.63,0.00,0.00,0.00,0.00,0.00),('1','171','878','192616',3763580,'2599','388',100832.94,102625.28,1792.34,292151.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','192616',3763581,'2600','388',122958.54,124147.11,1188.57,193736.91,0.00,0.00,0.00,0.00,0.00),('1','171','879','192616',3763582,'2601','388',170868.98,170868.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192616',3763583,'2602','388',181094.44,182467.53,1373.09,223813.67,0.00,0.00,0.00,0.00,0.00),('1','171','879','192616',3763584,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192616',3763585,'2604','388',164211.06,165509.91,1298.85,211712.55,0.00,0.00,0.00,0.00,0.00),('1','171','932','192616',3763586,'2740','412',36207.98,36859.10,651.12,169291.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','192616',3763587,'2741','412',204317.77,205049.30,731.53,190197.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','192644',3764163,'2593','388',160178.28,160178.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192644',3764164,'2594','388',144033.67,144033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192644',3764165,'2595','388',118664.18,118664.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192644',3764166,'2596','388',168857.20,168857.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192644',3764167,'2597','388',138294.71,140324.27,2029.56,330818.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','192644',3764168,'2598','388',132815.35,134402.81,1587.46,258755.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','192644',3764169,'2599','388',102625.28,104330.46,1705.18,277944.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','192644',3764170,'2600','388',124147.11,125520.81,1373.70,223913.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','192644',3764171,'2601','388',170868.98,172779.07,1910.09,311344.67,0.00,0.00,0.00,0.00,0.00),('1','171','879','192644',3764172,'2602','388',182467.53,182467.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192644',3764173,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192644',3764174,'2604','388',165509.91,167279.42,1769.51,288430.13,0.00,0.00,0.00,0.00,0.00),('1','171','932','192644',3764175,'2740','412',36859.10,37272.07,412.97,107372.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','192644',3764176,'2741','412',205049.30,205578.42,529.12,137571.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','192652',3764230,'2593','388',160178.28,161626.62,1428.34,232819.42,0.00,0.00,20.00,0.00,0.00),('1','171','877','192652',3764231,'2594','388',144033.67,145921.50,1887.83,307716.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','192652',3764232,'2595','388',118664.18,119622.31,958.13,156175.19,0.00,0.00,0.00,0.00,0.00),('1','171','877','192652',3764233,'2596','388',168857.20,170371.49,1514.29,246829.27,0.00,0.00,0.00,0.00,0.00),('1','171','878','192652',3764234,'2597','388',140324.27,140324.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192652',3764235,'2598','388',134402.81,134402.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192652',3764236,'2599','388',104330.46,104330.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192652',3764237,'2600','388',125520.81,125520.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192652',3764238,'2601','388',172779.07,173841.00,1041.93,169834.59,0.00,0.00,20.00,0.00,0.00),('1','171','879','192652',3764239,'2602','388',182467.53,183282.02,814.49,132761.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','192652',3764240,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192652',3764241,'2604','388',167279.42,167372.79,93.37,15219.31,0.00,0.00,0.00,0.00,0.00),('1','171','932','192652',3764242,'2740','412',37272.07,37272.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','192652',3764243,'2741','412',205578.42,207132.89,1554.47,404162.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','192687',3765063,'2593','388',161626.62,162983.03,1356.41,221094.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','192687',3765064,'2594','388',145921.50,147159.07,1237.57,201723.91,0.00,0.00,0.00,0.00,0.00),('1','171','877','192687',3765065,'2595','388',119622.31,119622.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192687',3765066,'2596','388',170371.49,172433.75,2062.26,336148.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','192687',3765067,'2597','388',140324.27,140324.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192687',3765068,'2598','388',134402.81,136214.36,1811.55,295282.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','192687',3765069,'2599','388',104330.46,106117.03,1786.57,291210.91,0.00,0.00,0.00,0.00,0.00),('1','171','878','192687',3765070,'2600','388',125520.81,125520.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192687',3765071,'2601','388',173841.00,175525.58,1684.58,274586.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','192687',3765072,'2602','388',183282.02,183282.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192687',3765073,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192687',3765074,'2604','388',167372.79,167372.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','192687',3765075,'2740','412',37272.07,37514.38,242.31,63000.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','192687',3765076,'2741','412',207132.89,207831.58,698.69,181659.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','192724',3765777,'2593','388',162983.03,163852.12,869.09,141661.67,0.00,0.00,0.00,0.00,0.00),('1','171','877','192724',3765778,'2594','388',147159.07,148234.54,1075.47,175301.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','192724',3765779,'2595','388',119622.31,120588.21,965.90,157441.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','192724',3765780,'2596','388',172433.75,173688.29,1254.54,204490.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','192724',3765781,'2597','388',140324.27,141131.07,806.80,131508.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','192724',3765782,'2598','388',136214.36,137261.46,1047.10,170677.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','192724',3765783,'2599','388',106117.03,106117.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192724',3765784,'2600','388',125520.81,126534.55,1013.74,165239.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','192724',3765785,'2601','388',175525.58,175525.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192724',3765786,'2602','388',183282.02,184216.55,934.53,152328.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','192724',3765787,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192724',3765788,'2604','388',167372.79,167372.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','192724',3765789,'2740','412',37514.38,38195.20,680.82,177013.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','192724',3765790,'2741','412',207831.58,208339.97,508.39,132181.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','192836',3767678,'2593','388',163852.12,165059.51,1207.39,196804.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','192836',3767679,'2594','388',148234.54,149912.25,1677.71,273466.73,0.00,0.00,0.00,0.00,0.00),('1','171','877','192836',3767680,'2595','388',120588.21,120588.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','192836',3767681,'2596','388',173688.29,175350.51,1662.22,270941.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','192836',3767682,'2597','388',141131.07,141131.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','192836',3767683,'2598','388',137261.46,139023.36,1761.90,287189.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','192836',3767684,'2599','388',106117.03,107665.69,1548.66,252431.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','192836',3767685,'2600','388',126534.55,126534.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192836',3767686,'2601','388',175525.58,176225.71,700.13,114121.19,0.00,0.00,0.00,0.00,0.00),('1','171','879','192836',3767687,'2602','388',184216.55,184700.22,483.67,78838.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','192836',3767688,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','192836',3767689,'2604','388',167372.79,167372.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','192836',3767690,'2740','412',38195.20,38220.58,25.38,6598.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','192836',3767691,'2741','412',208339.97,208679.18,339.21,88194.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','193115',3773059,'2593','388',165059.51,166079.08,1019.57,166189.91,0.00,0.00,0.00,0.00,0.00),('1','171','877','193115',3773060,'2594','388',149912.25,150978.95,1066.70,173872.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','193115',3773061,'2595','388',120588.21,121213.10,624.89,101857.07,0.00,0.00,0.00,0.00,0.00),('1','171','877','193115',3773062,'2596','388',175350.51,175994.47,643.96,104965.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','193115',3773063,'2597','388',141131.07,141304.13,173.06,28208.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','193115',3773064,'2598','388',139023.36,139988.55,965.19,157325.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','193115',3773065,'2599','388',107665.69,107665.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193115',3773066,'2600','388',126534.55,127510.82,976.27,159132.01,0.00,0.00,0.00,0.00,0.00),('1','171','879','193115',3773067,'2601','388',176225.71,176225.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193115',3773068,'2602','388',184700.22,185555.27,855.05,139373.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','193115',3773069,'2603','388',124999.61,124999.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193115',3773070,'2604','388',167372.79,167556.73,183.94,29982.22,0.00,0.00,0.00,0.00,0.00),('1','171','932','193115',3773071,'2740','412',38220.58,38220.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193115',3773072,'2741','412',208679.18,208962.40,283.22,73637.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193235',3775076,'2593','388',166079.08,167524.19,1445.11,235552.93,0.00,0.00,0.00,0.00,0.00),('1','171','877','193235',3775077,'2594','388',150978.95,150978.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193235',3775078,'2595','388',121213.10,121213.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193235',3775079,'2596','388',175994.47,177569.26,1574.79,256690.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','193235',3775080,'2597','388',141304.13,142340.35,1036.22,168903.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','193235',3775081,'2598','388',139988.55,139988.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193235',3775082,'2599','388',107665.69,108370.80,705.11,114932.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','193235',3775083,'2600','388',127510.82,127510.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193235',3775084,'2601','388',176225.71,177082.38,856.67,139637.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','193235',3775085,'2602','388',185555.27,185555.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193235',3775086,'2603','388',124999.61,125981.31,981.70,160017.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','193235',3775087,'2604','388',167556.73,167556.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193235',3775088,'2740','412',38220.58,38296.72,76.14,19796.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','193235',3775089,'2741','412',208962.40,209394.00,431.60,112216.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193294',3776282,'2593','388',167524.19,169294.38,1770.19,288540.97,0.00,0.00,0.00,0.00,0.00),('1','171','877','193294',3776283,'2594','388',150978.95,150978.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193294',3776284,'2595','388',121213.10,121213.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193294',3776285,'2596','388',177569.26,179065.12,1495.86,243825.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','193294',3776286,'2597','388',142340.35,144689.55,2349.20,382919.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','193294',3776287,'2598','388',139988.55,140988.55,1000.00,163000.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193294',3776288,'2599','388',108370.80,108370.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193294',3776289,'2600','388',127510.82,128821.58,1310.76,213653.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','193294',3776290,'2601','388',177082.38,178249.71,1167.33,190274.79,0.00,0.00,0.00,0.00,0.00),('1','171','879','193294',3776291,'2602','388',185555.27,185555.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193294',3776292,'2603','388',125981.31,125981.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193294',3776293,'2604','388',167556.73,167625.44,68.71,11199.73,0.00,0.00,0.00,0.00,0.00),('1','171','932','193294',3776294,'2740','412',38296.72,38346.72,30.00,7800.00,0.00,0.00,20.00,0.00,0.00),('1','171','932','193294',3776295,'2741','412',209394.00,210123.53,709.53,184477.80,0.00,0.00,20.00,0.00,0.00),('1','171','877','193328',3777062,'2593','388',169294.38,170556.77,1262.39,205769.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','193328',3777063,'2594','388',150978.95,151793.39,814.44,132753.72,0.00,0.00,0.00,0.00,0.00),('1','171','877','193328',3777064,'2595','388',121213.10,122619.85,1406.75,229300.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','193328',3777065,'2596','388',179065.12,179403.03,337.91,55079.33,0.00,0.00,0.00,0.00,0.00),('1','171','878','193328',3777066,'2597','388',144689.55,145791.05,1101.50,179544.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','193328',3777067,'2598','388',140988.55,141968.36,979.81,159709.03,0.00,0.00,0.00,0.00,0.00),('1','171','878','193328',3777068,'2599','388',108370.80,109544.24,1173.44,191270.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','193328',3777069,'2600','388',128821.58,128821.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193328',3777070,'2601','388',178249.71,178249.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193328',3777071,'2602','388',185555.27,186456.29,901.02,146866.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','193328',3777072,'2603','388',125981.31,125981.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193328',3777073,'2604','388',167625.44,167632.80,7.36,1199.68,0.00,0.00,0.00,0.00,0.00),('1','171','932','193328',3777074,'2740','412',38346.72,38378.26,31.54,8200.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','193328',3777075,'2741','412',210123.53,211239.17,1115.64,290066.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','193339',3777282,'2593','388',170556.77,170556.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193339',3777283,'2594','388',151793.39,153341.41,1528.02,249067.26,0.00,0.00,20.00,0.00,0.00),('1','171','877','193339',3777284,'2595','388',122619.85,124333.03,1713.18,279248.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','193339',3777285,'2596','388',179403.03,179403.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193339',3777286,'2597','388',145791.05,147045.54,1244.49,202851.87,0.00,0.00,10.00,0.00,0.00),('1','171','878','193339',3777287,'2598','388',141968.36,143107.17,1138.81,185626.03,0.00,0.00,0.00,0.00,0.00),('1','171','878','193339',3777288,'2599','388',109544.24,109883.19,328.95,53618.85,0.00,0.00,10.00,0.00,0.00),('1','171','878','193339',3777289,'2600','388',128821.58,130535.45,1713.87,279360.81,0.00,0.00,0.00,0.00,0.00),('1','171','879','193339',3777290,'2601','388',178249.71,179277.16,1027.45,167474.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','193339',3777291,'2602','388',186456.29,186456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193339',3777292,'2603','388',125981.31,125981.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193339',3777293,'2604','388',167632.80,167632.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193339',3777294,'2740','412',38378.26,39935.37,1557.11,404848.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','193339',3777295,'2741','412',211239.17,212163.21,924.04,240250.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','193363',3778027,'2593','388',170556.77,170556.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193363',3778028,'2594','388',153341.41,153638.89,297.48,48489.24,0.00,0.00,0.00,0.00,0.00),('1','171','877','193363',3778029,'2595','388',124333.03,125575.85,1242.82,202579.66,0.00,0.00,0.00,0.00,0.00),('1','171','877','193363',3778030,'2596','388',179403.03,180403.03,1000.00,163000.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193363',3778031,'2597','388',147045.54,148351.04,1305.50,212796.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','193363',3778032,'2598','388',143107.17,144749.92,1642.75,267768.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','193363',3778033,'2599','388',109883.19,110752.55,869.36,141705.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','193363',3778034,'2600','388',130535.45,132506.85,1971.40,321338.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','193363',3778035,'2601','388',179277.16,180130.38,853.22,139074.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','193363',3778036,'2602','388',186456.29,187488.44,1032.15,168240.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','193363',3778037,'2603','388',125981.31,125981.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193363',3778038,'2604','388',167632.80,167632.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193363',3778039,'2740','412',39935.37,39935.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193363',3778040,'2741','412',212163.21,213931.56,1768.35,459771.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193487',3780228,'2593','388',170556.77,170556.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193487',3780229,'2594','388',153638.89,155512.50,1873.61,305398.43,0.00,0.00,0.00,0.00,0.00),('1','171','877','193487',3780230,'2595','388',125575.85,127091.24,1515.39,247008.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','193487',3780231,'2596','388',180403.03,180403.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193487',3780232,'2597','388',148351.04,150005.67,1654.63,269704.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','193487',3780233,'2598','388',144749.92,145899.60,1149.68,187397.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','193487',3780234,'2599','388',110752.55,111865.19,1112.64,181360.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','193487',3780235,'2600','388',132506.85,132506.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193487',3780236,'2601','388',180130.38,180130.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193487',3780237,'2602','388',187488.44,187488.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193487',3780238,'2603','388',125981.31,125981.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193487',3780239,'2604','388',167632.80,167632.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193487',3780240,'2740','412',39935.37,39958.64,23.27,6050.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','193487',3780241,'2741','412',213931.56,215213.28,1281.72,333247.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193504',3780508,'2593','388',170556.77,171481.22,924.45,150685.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','193504',3780509,'2594','388',155512.50,156704.82,1192.32,194348.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','193504',3780510,'2595','388',127091.24,128656.30,1565.06,255104.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','193504',3780511,'2596','388',180403.03,182012.26,1609.23,262304.49,0.00,0.00,0.00,0.00,0.00),('1','171','878','193504',3780512,'2597','388',150005.67,150234.47,228.80,37294.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','193504',3780513,'2598','388',145899.60,146304.75,405.15,66039.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','193504',3780514,'2599','388',111865.19,112901.73,1036.54,168956.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','193504',3780515,'2600','388',132506.85,132928.71,421.86,68763.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','193504',3780516,'2601','388',180130.38,181244.78,1114.40,181647.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','193504',3780517,'2602','388',187488.44,187488.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193504',3780518,'2603','388',125981.31,126031.45,50.14,8172.82,0.00,0.00,0.00,0.00,0.00),('1','171','879','193504',3780519,'2604','388',167632.80,167836.11,203.31,33139.53,0.00,0.00,0.00,0.00,0.00),('1','171','932','193504',3780520,'2740','412',39958.64,39958.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193504',3780521,'2741','412',215213.28,216238.74,1025.46,266619.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','193570',3781907,'2593','388',171481.22,171839.92,358.70,58468.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','193570',3781908,'2594','388',156704.82,158566.39,1861.57,303435.91,0.00,0.00,0.00,0.00,0.00),('1','171','877','193570',3781909,'2595','388',128656.30,130169.01,1512.71,246571.73,0.00,0.00,0.00,0.00,0.00),('1','171','877','193570',3781910,'2596','388',182012.26,182400.28,388.02,63247.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','193570',3781911,'2597','388',150234.47,151696.96,1462.49,238385.87,0.00,0.00,0.00,0.00,0.00),('1','171','878','193570',3781912,'2598','388',146304.75,147312.78,1008.03,164308.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','193570',3781913,'2599','388',112901.73,114333.24,1431.51,233336.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','193570',3781914,'2600','388',132928.71,132928.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193570',3781915,'2601','388',181244.78,181244.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193570',3781916,'2602','388',187488.44,188211.98,723.54,117937.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','193570',3781917,'2603','388',126031.45,126031.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193570',3781918,'2604','388',167836.11,167836.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193570',3781919,'2740','412',39958.64,40549.69,591.05,153673.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193570',3781920,'2741','412',216238.74,217126.44,887.70,230802.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193708',3784312,'2593','388',171839.92,172940.27,1100.35,179357.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','193708',3784313,'2594','388',158566.39,159354.00,787.61,128380.43,0.00,0.00,0.00,0.00,0.00),('1','171','877','193708',3784314,'2595','388',130169.01,130590.36,421.35,68680.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','193708',3784315,'2596','388',182400.28,183295.27,894.99,145883.37,0.00,0.00,0.00,0.00,0.00),('1','171','878','193708',3784316,'2597','388',151696.96,152740.86,1043.90,170155.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','193708',3784317,'2598','388',147312.78,149729.83,2417.05,393979.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','193708',3784318,'2599','388',114333.24,117111.32,2778.08,452827.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','193708',3784319,'2600','388',132928.71,134417.45,1488.74,242664.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','193708',3784320,'2601','388',181244.78,181881.67,636.89,103813.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','193708',3784321,'2602','388',188211.98,188211.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193708',3784322,'2603','388',126031.45,126638.39,606.94,98931.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','193708',3784323,'2604','388',167836.11,167836.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193708',3784324,'2740','412',40549.69,40874.19,324.50,84370.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193708',3784325,'2741','412',217126.44,218709.41,1582.97,411572.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193754',3785037,'2593','388',172940.27,174188.18,1247.91,203409.33,0.00,0.00,0.00,0.00,0.00),('1','171','877','193754',3785038,'2594','388',159354.00,160257.99,903.99,147350.37,0.00,0.00,0.00,0.00,0.00),('1','171','877','193754',3785039,'2595','388',130590.36,131416.26,825.90,134621.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','193754',3785040,'2596','388',183295.27,184428.08,1132.81,184648.03,0.00,0.00,0.00,0.00,0.00),('1','171','878','193754',3785041,'2597','388',152740.86,152740.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193754',3785042,'2598','388',149729.83,151409.57,1679.74,273797.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','193754',3785043,'2599','388',117111.32,117934.37,823.05,134157.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','193754',3785044,'2600','388',134417.45,134750.72,333.27,54323.01,0.00,0.00,0.00,0.00,0.00),('1','171','879','193754',3785045,'2601','388',181881.67,181881.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193754',3785046,'2602','388',188211.98,189712.21,1500.23,244537.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','193754',3785047,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193754',3785048,'2604','388',167836.11,168233.45,397.34,64766.42,0.00,0.00,0.00,0.00,0.00),('1','171','932','193754',3785049,'2740','412',40874.19,41369.50,495.31,128780.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','193754',3785050,'2741','412',218709.41,219020.26,310.85,80821.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193762',3785175,'2593','388',174188.18,175718.50,1530.32,249442.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','193762',3785176,'2594','388',160257.99,160257.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193762',3785177,'2595','388',131416.26,132510.48,1094.22,178357.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','193762',3785178,'2596','388',184428.08,186823.34,2395.26,390427.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','193762',3785179,'2597','388',152740.86,155319.24,2558.38,417015.94,0.00,0.00,20.00,0.00,0.00),('1','171','878','193762',3785180,'2598','388',151409.57,151409.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193762',3785181,'2599','388',117934.37,117934.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193762',3785182,'2600','388',134750.72,136647.09,1896.37,309108.31,0.00,0.00,0.00,0.00,0.00),('1','171','879','193762',3785183,'2601','388',181881.67,183815.66,1913.99,311980.37,0.00,0.00,20.00,0.00,0.00),('1','171','879','193762',3785184,'2602','388',189712.21,189712.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193762',3785185,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193762',3785186,'2604','388',168233.45,168233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193762',3785187,'2740','412',41369.50,41514.88,145.38,37798.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','193762',3785188,'2741','412',219020.26,220365.89,1345.63,349863.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','193788',3785676,'2593','388',175718.50,176625.49,906.99,147839.37,0.00,0.00,0.00,0.00,0.00),('1','171','877','193788',3785677,'2594','388',160257.99,161995.73,1737.74,283251.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','193788',3785678,'2595','388',132510.48,133446.36,935.88,152548.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','193788',3785679,'2596','388',186823.34,187897.96,1074.62,175163.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','193788',3785680,'2597','388',155319.24,156592.04,1272.80,207466.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','193788',3785681,'2598','388',151409.57,152648.83,1239.26,201999.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','193788',3785682,'2599','388',117934.37,119069.75,1135.38,185066.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','193788',3785683,'2600','388',136647.09,137797.25,1150.16,187476.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','193788',3785684,'2601','388',183815.66,183815.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193788',3785685,'2602','388',189712.21,189712.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193788',3785686,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193788',3785687,'2604','388',168233.45,168233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193788',3785688,'2740','412',41514.88,41568.95,54.07,14058.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','193788',3785689,'2741','412',220365.89,222293.16,1927.27,501090.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193812',3786268,'2593','388',176625.49,176658.45,32.96,5372.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','193812',3786269,'2594','388',161995.73,162970.23,974.50,158843.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','193812',3786270,'2595','388',133446.36,133446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193812',3786271,'2596','388',187897.96,189499.23,1601.27,261007.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','193812',3786272,'2597','388',156592.04,158003.01,1410.97,229988.11,0.00,0.00,0.00,0.00,0.00),('1','171','878','193812',3786273,'2598','388',152648.83,154094.01,1445.18,235564.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','193812',3786274,'2599','388',119069.75,119069.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193812',3786275,'2600','388',137797.25,138168.40,371.15,60497.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','193812',3786276,'2601','388',183815.66,183815.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193812',3786277,'2602','388',189712.21,189712.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193812',3786278,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193812',3786279,'2604','388',168233.45,168233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193812',3786280,'2740','412',41568.95,41568.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193812',3786281,'2741','412',222293.16,222708.09,414.93,107881.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','193952',3788650,'2593','388',176658.45,177464.31,805.86,132966.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','193952',3788651,'2594','388',162970.23,163671.56,701.33,115719.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','193952',3788652,'2595','388',133446.36,134258.12,811.76,133940.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','193952',3788653,'2596','388',189499.23,190288.76,789.53,130272.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','193952',3788654,'2597','388',158003.01,158524.72,521.71,86082.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','193952',3788655,'2598','388',154094.01,154919.66,825.65,136232.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','193952',3788656,'2599','388',119069.75,119638.50,568.75,93843.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','193952',3788657,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193952',3788658,'2601','388',183815.66,184208.35,392.69,64793.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','193952',3788659,'2602','388',189712.21,189712.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193952',3788660,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193952',3788661,'2604','388',168233.45,168233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193952',3788662,'2740','412',41568.95,41571.87,2.92,759.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','193952',3788663,'2741','412',222708.09,223922.31,1214.22,315697.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193997',3789350,'2593','388',177464.31,177464.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','193997',3789351,'2594','388',163671.56,165350.81,1679.25,277076.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','193997',3789352,'2595','388',134258.12,135409.00,1150.88,189895.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','193997',3789353,'2596','388',190288.76,191273.07,984.31,162411.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','193997',3789354,'2597','388',158524.72,158524.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','193997',3789355,'2598','388',154919.66,156017.79,1098.13,181191.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','193997',3789356,'2599','388',119638.50,120058.76,420.26,69342.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','193997',3789357,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193997',3789358,'2601','388',184208.35,185330.82,1097.47,181082.55,0.00,0.00,25.00,0.00,0.00),('1','171','879','193997',3789359,'2602','388',189712.21,190033.69,321.48,53044.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','193997',3789360,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','193997',3789361,'2604','388',168233.45,168233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193997',3789362,'2740','412',41571.87,41571.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','193997',3789363,'2741','412',223922.31,224296.24,373.93,97221.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','194013',3789748,'2593','388',177464.31,177668.55,204.24,33699.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','194013',3789749,'2594','388',165350.81,166486.48,1135.67,187385.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','194013',3789750,'2595','388',135409.00,135409.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194013',3789751,'2596','388',191273.07,193140.27,1867.20,308088.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','194013',3789752,'2597','388',158524.72,159293.20,768.48,126799.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','194013',3789753,'2598','388',156017.79,156987.83,970.04,160056.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','194013',3789754,'2599','388',120058.76,120839.40,780.64,128805.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','194013',3789755,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194013',3789756,'2601','388',185330.82,186181.74,850.92,140401.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','194013',3789757,'2602','388',190033.69,190063.69,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','171','879','194013',3789758,'2603','388',126638.39,126638.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194013',3789759,'2604','388',168233.45,168646.37,412.92,68131.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','194013',3789760,'2740','412',41571.87,42048.47,476.60,123916.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194013',3789761,'2741','412',224296.24,225008.81,700.64,182166.40,0.00,0.00,11.93,0.00,0.00),('1','171','877','194240',3793930,'2593','388',177668.55,179573.16,1904.61,314260.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','194240',3793931,'2594','388',166486.48,166486.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194240',3793932,'2595','388',135409.00,137162.29,1753.29,289292.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','194240',3793933,'2596','388',193140.27,193140.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','194240',3793934,'2597','388',159293.20,159293.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','194240',3793935,'2598','388',156987.83,158378.70,1390.87,229493.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','194240',3793936,'2599','388',120839.40,122058.81,1199.41,197902.65,0.00,0.00,20.00,0.00,0.00),('1','171','878','194240',3793937,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194240',3793938,'2601','388',186181.74,186181.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194240',3793939,'2602','388',190063.69,191058.02,994.33,164064.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','194240',3793940,'2603','388',126638.39,127414.98,771.19,127246.35,0.00,0.00,5.40,0.00,0.00),('1','171','879','194240',3793941,'2604','388',168646.37,168646.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194240',3793942,'2740','412',42048.47,42048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194240',3793943,'2741','412',225008.81,226041.05,1032.24,268382.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','194252',3794251,'2593','388',179573.16,180605.49,1032.33,170334.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','194252',3794252,'2594','388',166486.48,166557.10,70.62,11652.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','194252',3794253,'2595','388',137162.29,137959.60,797.31,131556.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','194252',3794254,'2596','388',193140.27,194099.15,958.88,158215.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','194252',3794255,'2597','388',159293.20,160095.94,802.74,132452.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','194252',3794256,'2598','388',158378.70,159179.61,800.91,132150.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','194252',3794257,'2599','388',122058.81,122951.43,892.62,147282.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','194252',3794258,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194252',3794259,'2601','388',186181.74,187193.48,1011.74,166937.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','194252',3794260,'2602','388',191058.02,191058.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194252',3794261,'2603','388',127414.98,127540.35,111.05,18323.25,0.00,0.00,14.32,0.00,0.00),('1','171','879','194252',3794262,'2604','388',168646.37,168734.02,79.39,13099.35,0.00,0.00,8.26,0.00,0.00),('1','171','932','194252',3794263,'2740','412',42048.47,42100.02,51.55,13403.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194252',3794264,'2741','412',226041.05,227473.83,1432.78,372522.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','194458',3797926,'2593','388',180605.49,180605.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194458',3797927,'2594','388',166557.10,168033.84,1476.74,243662.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','194458',3797928,'2595','388',137959.60,137959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194458',3797929,'2596','388',194099.15,194099.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','194458',3797930,'2597','388',160095.94,162252.62,2156.68,355852.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','194458',3797931,'2598','388',159179.61,160307.60,1127.99,186118.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','194458',3797932,'2599','388',122951.43,124145.37,1193.94,197000.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','194458',3797933,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194458',3797934,'2601','388',187193.48,188017.71,824.23,135997.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','194458',3797935,'2602','388',191058.02,191863.73,805.71,132942.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','194458',3797936,'2603','388',127540.35,127540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194458',3797937,'2604','388',168734.02,169146.94,412.92,68131.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','194458',3797938,'2740','412',42100.02,42100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194458',3797939,'2741','412',227473.83,228337.10,863.27,224450.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','194589',3799928,'2593','388',180605.49,181040.65,435.16,71801.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','194589',3799929,'2594','388',168033.84,168033.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194589',3799930,'2595','388',137959.60,138308.93,349.33,57639.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','194589',3799931,'2596','388',194099.15,194989.14,889.99,146848.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','194589',3799932,'2597','388',162252.62,162912.87,660.25,108941.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','194589',3799933,'2598','388',160307.60,160924.12,616.52,101725.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','194589',3799934,'2599','388',124145.37,125245.13,1099.76,181460.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','194589',3799935,'2600','388',138168.40,138168.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194589',3799936,'2601','388',188017.71,188712.29,694.58,114605.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','194589',3799937,'2602','388',191863.73,191863.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194589',3799938,'2603','388',127540.35,127540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194589',3799939,'2604','388',169146.94,169466.24,319.30,52684.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','194589',3799940,'2740','412',42100.02,42100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194589',3799941,'2741','412',228337.10,229335.91,998.81,259690.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','194622',3800702,'2593','388',181040.65,182109.65,1069.00,176385.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194622',3800703,'2594','388',168033.84,168033.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194622',3800704,'2595','388',138308.93,138308.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194622',3800705,'2596','388',194989.14,196918.53,1929.39,318349.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','194622',3800706,'2597','388',162912.87,163956.90,1044.03,172264.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','194622',3800707,'2598','388',160924.12,162824.26,1900.14,313523.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','194622',3800708,'2599','388',125245.13,126185.39,940.26,155142.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','194622',3800709,'2600','388',138168.40,139353.97,1181.17,194893.05,0.00,0.00,4.40,0.00,0.00),('1','171','879','194622',3800710,'2601','388',188712.29,188712.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194622',3800711,'2602','388',191863.73,193371.27,1507.54,248744.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','194622',3800712,'2603','388',127540.35,127540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194622',3800713,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194622',3800714,'2740','412',42100.02,42100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194622',3800715,'2741','412',229335.91,229588.00,252.09,65543.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','194773',3803606,'2593','388',182109.65,182336.86,227.21,37489.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','194773',3803607,'2594','388',168033.84,168794.97,761.13,125586.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','194773',3803608,'2595','388',138308.93,139038.89,729.96,120443.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','194773',3803609,'2596','388',196918.53,197347.89,429.36,70844.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','194773',3803610,'2597','388',163956.90,164693.24,736.34,121496.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','194773',3803611,'2598','388',162824.26,163102.68,278.42,45939.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','194773',3803612,'2599','388',126185.39,126185.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','194773',3803613,'2600','388',139353.97,139753.32,399.35,65892.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','194773',3803614,'2601','388',188712.29,188712.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194773',3803615,'2602','388',193371.27,193371.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194773',3803616,'2603','388',127540.35,127540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194773',3803617,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194773',3803618,'2740','412',42100.02,42100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194773',3803619,'2741','412',229588.00,229724.34,136.34,35448.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','194856',3805479,'2593','388',182336.86,182836.86,500.00,82500.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194856',3805480,'2594','388',168794.97,170552.04,1757.07,289916.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','194856',3805481,'2595','388',139038.89,139038.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','194856',3805482,'2596','388',197347.89,198923.78,1575.89,260021.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','194856',3805483,'2597','388',164693.24,165514.09,820.85,135440.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','194856',3805484,'2598','388',163102.68,164669.54,1566.86,258531.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','194856',3805485,'2599','388',126185.39,127108.64,923.25,152336.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','194856',3805486,'2600','388',139753.32,140341.83,588.51,97104.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','194856',3805487,'2601','388',188712.29,188712.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194856',3805488,'2602','388',193371.27,193371.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194856',3805489,'2603','388',127540.35,127540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194856',3805490,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194856',3805491,'2740','412',42100.02,42107.72,7.70,2002.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194856',3805492,'2741','412',229724.34,230816.71,1092.37,284016.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','194964',3807395,'2593','388',182836.86,183591.77,744.91,122910.15,0.00,0.00,10.00,0.00,0.00),('1','171','877','194964',3807396,'2594','388',170552.04,170804.05,242.01,39931.65,0.00,0.00,10.00,0.00,0.00),('1','171','877','194964',3807397,'2595','388',139038.89,139095.39,46.50,7672.50,0.00,0.00,10.00,0.00,0.00),('1','171','877','194964',3807398,'2596','388',198923.78,199445.87,512.09,84494.85,0.00,0.00,10.00,0.00,0.00),('1','171','878','194964',3807399,'2597','388',165514.09,166727.53,1203.44,198567.60,0.00,0.00,10.00,0.00,0.00),('1','171','878','194964',3807400,'2598','388',164669.54,165422.24,742.70,122545.50,0.00,0.00,10.00,0.00,0.00),('1','171','878','194964',3807401,'2599','388',127108.64,127560.27,441.63,72868.95,0.00,0.00,10.00,0.00,0.00),('1','171','878','194964',3807402,'2600','388',140341.83,141452.60,1100.77,181627.05,0.00,0.00,10.00,0.00,0.00),('1','171','879','194964',3807403,'2601','388',188712.29,189404.93,682.64,112635.60,0.00,0.00,10.00,0.00,0.00),('1','171','879','194964',3807404,'2602','388',193371.27,193371.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','194964',3807405,'2603','388',127540.35,127570.65,20.30,3349.50,0.00,0.00,10.00,0.00,0.00),('1','171','879','194964',3807406,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','194964',3807407,'2740','412',42107.72,42337.74,210.02,54605.20,0.00,0.00,20.00,0.00,0.00),('1','171','932','194964',3807408,'2741','412',230816.71,232751.20,1914.49,497767.40,0.00,0.00,20.00,0.00,0.00),('1','171','877','195039',3808661,'2593','388',183591.77,183591.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195039',3808662,'2594','388',170804.05,171804.05,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195039',3808663,'2595','388',139095.39,140236.83,1141.44,188337.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195039',3808664,'2596','388',199445.87,199694.87,249.00,41085.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195039',3808665,'2597','388',166727.53,167993.07,1265.54,208814.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','195039',3808666,'2598','388',165422.24,166569.94,1147.70,189370.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','195039',3808667,'2599','388',127560.27,128614.79,1054.52,173995.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','195039',3808668,'2600','388',141452.60,143746.35,2293.75,378468.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','195039',3808669,'2601','388',189404.93,190565.58,1160.65,191507.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','195039',3808670,'2602','388',193371.27,194319.15,947.88,156400.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','195039',3808671,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195039',3808672,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195039',3808673,'2740','412',42337.74,42337.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195039',3808674,'2741','412',232751.20,234083.58,1332.38,346418.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','195179',3811160,'2593','388',183591.77,183591.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195179',3811161,'2594','388',171804.05,171804.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195179',3811162,'2595','388',140236.83,140236.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195179',3811163,'2596','388',199694.87,199694.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195179',3811164,'2597','388',167993.07,168073.12,80.05,13208.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','195179',3811165,'2598','388',166569.94,168175.74,1605.80,264957.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195179',3811166,'2599','388',128614.79,129014.56,399.77,65962.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','195179',3811167,'2600','388',143746.35,145500.81,1754.46,289485.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','195179',3811168,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195179',3811169,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195179',3811170,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195179',3811171,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195179',3811172,'2740','412',42337.74,42892.57,554.83,144255.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','195179',3811173,'2741','412',234083.58,235644.78,1561.20,405912.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195379',3814587,'2593','388',183591.77,183591.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195379',3814588,'2594','388',171804.05,171804.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195379',3814589,'2595','388',140236.83,140236.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195379',3814590,'2596','388',199694.87,199694.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195379',3814591,'2597','388',168073.12,171516.12,3443.00,568095.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195379',3814592,'2598','388',168175.74,170016.40,1840.66,303708.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','195379',3814593,'2599','388',129014.56,131620.14,2605.58,429920.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','195379',3814594,'2600','388',145500.81,147200.81,1700.00,280500.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195379',3814595,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195379',3814596,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195379',3814597,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195379',3814598,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195379',3814599,'2740','412',42892.57,42892.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195379',3814600,'2741','412',235644.78,236479.73,834.95,217087.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195393',3814872,'2593','388',183591.77,184636.66,1044.89,172406.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','195393',3814873,'2594','388',171804.05,173033.57,1229.52,202870.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','195393',3814874,'2595','388',140236.83,142005.65,1768.82,291855.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','195393',3814875,'2596','388',199694.87,200196.70,501.83,82801.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','195393',3814876,'2597','388',171516.12,171516.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195393',3814877,'2598','388',170016.40,170295.62,279.22,46071.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','195393',3814878,'2599','388',131620.14,131630.14,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195393',3814879,'2600','388',147200.81,148067.01,866.20,142923.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195393',3814880,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195393',3814881,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195393',3814882,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195393',3814883,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195393',3814884,'2740','412',42892.57,44923.76,2031.19,528109.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195393',3814885,'2741','412',236479.73,237217.43,737.70,191802.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195447',3815762,'2593','388',184636.66,185780.50,1143.84,188733.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195447',3815763,'2594','388',173033.57,174110.84,1077.27,177749.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','195447',3815764,'2595','388',142005.65,143166.39,1160.74,191522.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','195447',3815765,'2596','388',200196.70,202669.69,2472.99,408043.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','195447',3815766,'2597','388',171516.12,172206.53,690.41,113917.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','195447',3815767,'2598','388',170295.62,172551.72,2256.10,372256.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','195447',3815768,'2599','388',131630.14,132656.97,1026.83,169426.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','195447',3815769,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195447',3815770,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195447',3815771,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195447',3815772,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195447',3815773,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195447',3815774,'2740','412',44923.76,45150.75,226.99,59017.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195447',3815775,'2741','412',237217.43,238354.58,1137.15,295659.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195638',3818891,'2593','388',185780.50,187530.87,1750.37,288811.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','195638',3818892,'2594','388',174110.84,174114.97,4.13,681.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','195638',3818893,'2595','388',143166.39,143637.82,471.43,77785.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','195638',3818894,'2596','388',202669.69,203091.74,422.05,69638.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','195638',3818895,'2597','388',172206.53,172206.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195638',3818896,'2598','388',172551.72,172551.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195638',3818897,'2599','388',132656.97,132656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195638',3818898,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195638',3818899,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195638',3818900,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195638',3818901,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195638',3818902,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195638',3818903,'2740','412',45150.75,45150.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195638',3818904,'2741','412',238354.58,240143.83,1789.25,465205.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195685',3819764,'2593','388',187530.87,189593.21,2062.34,340286.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','195685',3819765,'2594','388',174114.97,177876.31,3761.34,620621.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','195685',3819766,'2595','388',143637.82,145986.00,2348.18,387449.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','195685',3819767,'2596','388',203091.74,205669.97,2578.23,425407.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','195685',3819768,'2597','388',172206.53,172206.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195685',3819769,'2598','388',172551.72,172551.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195685',3819770,'2599','388',132656.97,132656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195685',3819771,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195685',3819772,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195685',3819773,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195685',3819774,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195685',3819775,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195685',3819776,'2740','412',45150.75,45336.74,185.99,48357.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195685',3819777,'2741','412',240143.83,241450.43,1306.60,339716.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195720',3820527,'2593','388',189593.21,189640.26,47.05,7763.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','195720',3820528,'2594','388',177876.31,179692.28,1815.97,299635.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','195720',3820529,'2595','388',145986.00,146245.24,259.24,42774.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195720',3820530,'2596','388',205669.97,205743.47,73.50,12127.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','195720',3820531,'2597','388',172206.53,172206.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195720',3820532,'2598','388',172551.72,172551.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195720',3820533,'2599','388',132656.97,132656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195720',3820534,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195720',3820535,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195720',3820536,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195720',3820537,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195720',3820538,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195720',3820539,'2740','412',45336.74,45779.58,442.84,115138.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195720',3820540,'2741','412',241450.43,242991.07,1540.64,400566.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','195741',3820874,'2593','388',189640.26,192893.76,3253.50,536827.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','195741',3820875,'2594','388',179692.28,180975.35,1283.07,211706.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','195741',3820876,'2595','388',146245.24,148876.72,2631.48,434194.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195741',3820877,'2596','388',205743.47,208779.43,3035.96,500933.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','195741',3820878,'2597','388',172206.53,172206.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195741',3820879,'2598','388',172551.72,172551.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195741',3820880,'2599','388',132656.97,132656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195741',3820881,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195741',3820882,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195741',3820883,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195741',3820884,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195741',3820885,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195741',3820886,'2740','412',45779.58,45779.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195741',3820887,'2741','412',242991.07,244199.84,1208.77,314280.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195851',3822607,'2593','388',192893.76,193827.05,933.29,153992.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','195851',3822608,'2594','388',180975.35,181949.49,974.14,160733.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','195851',3822609,'2595','388',148876.72,149806.85,930.13,153471.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','195851',3822610,'2596','388',208779.43,209200.68,421.25,69506.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','195851',3822611,'2597','388',172206.53,172206.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195851',3822612,'2598','388',172551.72,172551.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195851',3822613,'2599','388',132656.97,132656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195851',3822614,'2600','388',148067.01,148067.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195851',3822615,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195851',3822616,'2602','388',194319.15,194319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195851',3822617,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195851',3822618,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195851',3822619,'2740','412',45779.58,45783.04,3.46,899.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','195851',3822620,'2741','412',244199.84,244935.20,735.36,191193.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195857',3822732,'2593','388',193827.05,194910.95,1071.90,176863.50,0.00,0.00,12.00,0.00,0.00),('1','171','877','195857',3822733,'2594','388',181949.49,183312.56,1353.07,223256.55,0.00,0.00,10.00,0.00,0.00),('1','171','877','195857',3822734,'2595','388',149806.85,150977.54,1160.69,191513.85,0.00,0.00,10.00,0.00,0.00),('1','171','877','195857',3822735,'2596','388',209200.68,210660.59,1449.91,239235.15,0.00,0.00,10.00,0.00,0.00),('1','171','878','195857',3822736,'2597','388',172206.53,172612.11,395.58,65270.70,0.00,0.00,10.00,0.00,0.00),('1','171','878','195857',3822737,'2598','388',172551.72,172962.89,401.17,66193.05,0.00,0.00,10.00,0.00,0.00),('1','171','878','195857',3822738,'2599','388',132656.97,133254.58,587.61,96955.65,0.00,0.00,10.00,0.00,0.00),('1','171','878','195857',3822739,'2600','388',148067.01,148427.28,350.27,57794.55,0.00,0.00,10.00,0.00,0.00),('1','171','879','195857',3822740,'2601','388',190565.58,190565.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195857',3822741,'2602','388',194319.15,194730.56,391.41,64582.65,0.00,0.00,20.00,0.00,0.00),('1','171','879','195857',3822742,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195857',3822743,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195857',3822744,'2740','412',45783.04,45783.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195857',3822745,'2741','412',244935.20,246470.22,1535.02,399105.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195882',3823240,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195882',3823241,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195882',3823242,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195882',3823243,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195882',3823244,'2597','388',172612.11,172867.88,255.77,42202.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','195882',3823245,'2598','388',172962.89,173823.66,860.77,142027.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','195882',3823246,'2599','388',133254.58,133930.49,675.91,111525.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','195882',3823247,'2600','388',148427.28,149154.84,727.56,120047.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','195882',3823248,'2601','388',190565.58,191566.63,1001.05,165173.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','195882',3823249,'2602','388',194730.56,195405.79,675.23,111412.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','195882',3823250,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195882',3823251,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195882',3823252,'2740','412',45783.04,45783.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195882',3823253,'2741','412',246470.22,247949.40,1479.18,384586.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','195917',3823932,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195917',3823933,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195917',3823934,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195917',3823935,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195917',3823936,'2597','388',172867.88,173382.88,515.00,84975.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195917',3823937,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195917',3823938,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195917',3823939,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195917',3823940,'2601','388',191566.63,193421.45,1854.82,306045.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','195917',3823941,'2602','388',195405.79,197568.05,2162.26,356772.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','195917',3823942,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195917',3823943,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195917',3823944,'2740','412',45783.04,45994.11,211.07,54878.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','195917',3823945,'2741','412',247949.40,248900.52,951.12,247291.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195920',3823988,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195920',3823989,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195920',3823990,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195920',3823991,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195920',3823992,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195920',3823993,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195920',3823994,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195920',3823995,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195920',3823996,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195920',3823997,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195920',3823998,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195920',3823999,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195920',3824000,'2740','412',45994.11,46446.49,452.38,117618.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','195920',3824001,'2741','412',248900.52,249625.94,725.42,188609.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195945',3824568,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195945',3824569,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195945',3824570,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195945',3824571,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195945',3824572,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195945',3824573,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195945',3824574,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195945',3824575,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195945',3824576,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195945',3824577,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195945',3824578,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195945',3824579,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195945',3824580,'2740','412',46446.49,46479.18,32.69,8499.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195945',3824581,'2741','412',249625.94,250941.86,1315.92,342139.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','195948',3824664,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195948',3824665,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195948',3824666,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195948',3824667,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195948',3824668,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195948',3824669,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195948',3824670,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195948',3824671,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195948',3824672,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195948',3824673,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195948',3824674,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195948',3824675,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195948',3824676,'2740','412',46479.18,46878.66,399.48,103864.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','195948',3824677,'2741','412',250941.86,252004.42,1062.56,276265.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195955',3824834,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195955',3824835,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195955',3824836,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195955',3824837,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195955',3824838,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195955',3824839,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195955',3824840,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195955',3824841,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195955',3824842,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195955',3824843,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195955',3824844,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195955',3824845,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195955',3824846,'2740','412',46878.66,47173.95,295.29,76775.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','195955',3824847,'2741','412',252004.42,252822.78,818.36,212773.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','195965',3825036,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195965',3825037,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195965',3825038,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195965',3825039,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195965',3825040,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195965',3825041,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195965',3825042,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195965',3825043,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195965',3825044,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195965',3825045,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195965',3825046,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195965',3825047,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195965',3825048,'2740','412',47173.95,47280.57,106.62,27721.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','195965',3825049,'2741','412',252822.78,253891.37,1068.59,277833.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','195970',3825123,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195970',3825124,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195970',3825125,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','195970',3825126,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195970',3825127,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195970',3825128,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195970',3825129,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','195970',3825130,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195970',3825131,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195970',3825132,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195970',3825133,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','195970',3825134,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195970',3825135,'2740','412',47280.57,47280.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','195970',3825136,'2741','412',253891.37,256089.21,2197.84,571438.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','196091',3827018,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196091',3827019,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196091',3827020,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196091',3827021,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196091',3827022,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196091',3827023,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196091',3827024,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196091',3827025,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196091',3827026,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196091',3827027,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196091',3827028,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196091',3827029,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196091',3827030,'2740','412',47280.57,47280.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196091',3827031,'2741','412',256089.21,256724.98,635.77,165300.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196093',3827038,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196093',3827039,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196093',3827040,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196093',3827041,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196093',3827042,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196093',3827043,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196093',3827044,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196093',3827045,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196093',3827046,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196093',3827047,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196093',3827048,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196093',3827049,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196093',3827050,'2740','412',47280.57,48797.31,1516.74,394352.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','196093',3827051,'2741','412',256724.98,256948.93,223.95,58227.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196106',3827399,'2593','388',194910.95,194910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196106',3827400,'2594','388',183312.56,183312.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196106',3827401,'2595','388',150977.54,150977.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196106',3827402,'2596','388',210660.59,210660.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196106',3827403,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196106',3827404,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196106',3827405,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196106',3827406,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196106',3827407,'2601','388',193421.45,193421.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196106',3827408,'2602','388',197568.05,197568.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196106',3827409,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196106',3827410,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196106',3827411,'2740','412',48797.31,48797.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196106',3827412,'2741','412',256948.93,257429.22,480.29,124875.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','196118',3827668,'2593','388',194910.95,196429.26,1518.31,247484.53,0.00,0.00,0.00,0.00,0.00),('1','171','877','196118',3827669,'2594','388',183312.56,184844.14,1531.58,249647.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','196118',3827670,'2595','388',150977.54,152149.13,1171.59,190969.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','196118',3827671,'2596','388',210660.59,212559.85,1899.26,309579.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','196118',3827672,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196118',3827673,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196118',3827674,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196118',3827675,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196118',3827676,'2601','388',193421.45,194492.44,1070.99,174571.37,0.00,0.00,0.00,0.00,0.00),('1','171','879','196118',3827677,'2602','388',197568.05,199055.64,1487.59,242477.17,0.00,0.00,0.00,0.00,0.00),('1','171','879','196118',3827678,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196118',3827679,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196118',3827680,'2740','412',48797.31,49035.11,237.80,61828.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196118',3827681,'2741','412',257429.22,258779.08,1349.86,350963.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','196129',3827920,'2593','388',196429.26,198159.22,1729.96,281983.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','196129',3827921,'2594','388',184844.14,186615.43,1771.29,288720.27,0.00,0.00,0.00,0.00,0.00),('1','171','877','196129',3827922,'2595','388',152149.13,153099.44,950.31,154900.53,0.00,0.00,0.00,0.00,0.00),('1','171','877','196129',3827923,'2596','388',212559.85,214076.58,1516.73,247226.99,0.00,0.00,0.00,0.00,0.00),('1','171','878','196129',3827924,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196129',3827925,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196129',3827926,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196129',3827927,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196129',3827928,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196129',3827929,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196129',3827930,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196129',3827931,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196129',3827932,'2740','412',49035.11,49035.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196129',3827933,'2741','412',258779.08,259502.55,723.47,188102.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196136',3828063,'2593','388',198159.22,199771.90,1612.68,262866.84,0.00,0.00,0.00,0.00,0.00),('1','171','877','196136',3828064,'2594','388',186615.43,188433.95,1818.52,296418.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','196136',3828065,'2595','388',153099.44,155488.50,2389.06,389416.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','196136',3828066,'2596','388',214076.58,215166.95,1090.37,177730.31,0.00,0.00,0.00,0.00,0.00),('1','171','878','196136',3828067,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196136',3828068,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196136',3828069,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196136',3828070,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196136',3828071,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196136',3828072,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196136',3828073,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196136',3828074,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196136',3828075,'2740','412',49035.11,49055.11,20.00,5200.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196136',3828076,'2741','412',259502.55,259904.59,402.04,104530.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','196143',3828239,'2593','388',199771.90,200416.75,644.85,105110.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','196143',3828240,'2594','388',188433.95,189897.87,1463.92,238618.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','196143',3828241,'2595','388',155488.50,156572.32,1083.82,176662.66,0.00,0.00,0.00,0.00,0.00),('1','171','877','196143',3828242,'2596','388',215166.95,216574.89,1407.94,229494.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','196143',3828243,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196143',3828244,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196143',3828245,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196143',3828246,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196143',3828247,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196143',3828248,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196143',3828249,'2603','388',127570.65,127570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196143',3828250,'2604','388',169466.24,169466.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196143',3828251,'2740','412',49055.11,49158.58,103.47,26902.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','196143',3828252,'2741','412',259904.59,261467.01,1562.42,406229.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196148',3828351,'2593','388',200416.75,202211.57,1784.82,290925.66,0.00,0.00,10.00,0.00,0.00),('1','171','877','196148',3828352,'2594','388',189897.87,191178.57,1270.70,207124.10,0.00,0.00,10.00,0.00,0.00),('1','171','877','196148',3828353,'2595','388',156572.32,158214.64,1632.32,266068.16,0.00,0.00,10.00,0.00,0.00),('1','171','877','196148',3828354,'2596','388',216574.89,218030.43,1445.54,235623.02,0.00,0.00,10.00,0.00,0.00),('1','171','878','196148',3828355,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196148',3828356,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196148',3828357,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196148',3828358,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196148',3828359,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196148',3828360,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196148',3828361,'2603','388',127570.65,127788.62,207.97,33899.11,0.00,0.00,10.00,0.00,0.00),('1','171','879','196148',3828362,'2604','388',169466.24,169624.10,147.86,24101.18,0.00,0.00,10.00,0.00,0.00),('1','171','932','196148',3828363,'2740','412',49158.58,49158.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196148',3828364,'2741','412',261467.01,262292.59,825.58,214650.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','196149',3828365,'2593','388',202211.57,203814.76,1603.19,261319.97,0.00,0.00,0.00,0.00,0.00),('1','171','877','196149',3828366,'2594','388',191178.57,192667.98,1489.41,242773.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','196149',3828367,'2595','388',158214.64,159242.17,1027.53,167487.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','196149',3828368,'2596','388',218030.43,219188.91,1158.48,188832.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','196149',3828369,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196149',3828370,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196149',3828371,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196149',3828372,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196149',3828373,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196149',3828374,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196149',3828375,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196149',3828376,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196149',3828377,'2740','412',49158.58,49227.04,68.46,17799.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','196149',3828378,'2741','412',262292.59,263452.76,1160.17,301644.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196153',3828464,'2593','388',203814.76,205018.14,1203.38,196150.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','196153',3828465,'2594','388',192667.98,194613.70,1945.72,317152.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','196153',3828466,'2595','388',159242.17,160703.86,1461.69,238255.47,0.00,0.00,0.00,0.00,0.00),('1','171','877','196153',3828467,'2596','388',219188.91,220931.27,1742.36,284004.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','196153',3828468,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196153',3828469,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196153',3828470,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196153',3828471,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196153',3828472,'2601','388',194492.44,194492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196153',3828473,'2602','388',199055.64,199055.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196153',3828474,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196153',3828475,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196153',3828476,'2740','412',49227.04,49327.04,100.00,26000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196153',3828477,'2741','412',263452.76,265029.51,1576.75,409955.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196155',3828490,'2593','388',205018.14,205675.77,657.63,107193.69,0.00,0.00,0.00,0.00,0.00),('1','171','877','196155',3828491,'2594','388',194613.70,195494.19,880.49,143519.87,0.00,0.00,0.00,0.00,0.00),('1','171','877','196155',3828492,'2595','388',160703.86,161617.60,913.74,148939.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','196155',3828493,'2596','388',220931.27,221749.75,818.48,133412.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','196155',3828494,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196155',3828495,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196155',3828496,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196155',3828497,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196155',3828498,'2601','388',194492.44,194608.93,116.49,18987.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','196155',3828499,'2602','388',199055.64,199185.25,129.61,21126.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','196155',3828500,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196155',3828501,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196155',3828502,'2740','412',49327.04,49635.51,308.47,80202.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','196155',3828503,'2741','412',265029.51,266768.64,1739.13,452173.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','196160',3828589,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196160',3828590,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196160',3828591,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196160',3828592,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196160',3828593,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196160',3828594,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196160',3828595,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196160',3828596,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196160',3828597,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196160',3828598,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196160',3828599,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196160',3828600,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196160',3828601,'2740','412',49635.51,49736.29,100.78,26202.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','196160',3828602,'2741','412',266768.64,267607.69,839.05,218153.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196161',3828603,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196161',3828604,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196161',3828605,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196161',3828606,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196161',3828607,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196161',3828608,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196161',3828609,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196161',3828610,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196161',3828611,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196161',3828612,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196161',3828613,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196161',3828614,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196161',3828615,'2740','412',49736.29,49886.69,150.40,39104.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196161',3828616,'2741','412',267607.69,268618.23,1010.54,262740.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','196166',3828704,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196166',3828705,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196166',3828706,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196166',3828707,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196166',3828708,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196166',3828709,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196166',3828710,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196166',3828711,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196166',3828712,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196166',3828713,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196166',3828714,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196166',3828715,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196166',3828716,'2740','412',49886.69,49886.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196166',3828717,'2741','412',268618.23,269454.09,835.86,217323.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','196167',3828718,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196167',3828719,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196167',3828720,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196167',3828721,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196167',3828722,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196167',3828723,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196167',3828724,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196167',3828725,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196167',3828726,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196167',3828727,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196167',3828728,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196167',3828729,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196167',3828730,'2740','412',49886.69,50218.23,331.54,86200.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','196167',3828731,'2741','412',269454.09,270179.56,725.47,188622.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196170',3828790,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196170',3828791,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196170',3828792,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196170',3828793,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196170',3828794,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196170',3828795,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196170',3828796,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196170',3828797,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196170',3828798,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196170',3828799,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196170',3828800,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196170',3828801,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196170',3828802,'2740','412',50218.23,50395.93,177.70,46202.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196170',3828803,'2741','412',270179.56,271581.87,1402.31,364600.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','196177',3829014,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196177',3829015,'2594','388',195494.19,195494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196177',3829016,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196177',3829017,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196177',3829018,'2597','388',173382.88,173382.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196177',3829019,'2598','388',173823.66,173823.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196177',3829020,'2599','388',133930.49,133930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196177',3829021,'2600','388',149154.84,149154.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196177',3829022,'2601','388',194608.93,194608.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196177',3829023,'2602','388',199185.25,199185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196177',3829024,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196177',3829025,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196177',3829026,'2740','412',50395.93,50395.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196177',3829027,'2741','412',271581.87,271726.88,145.01,37702.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','196180',3829085,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196180',3829086,'2594','388',195494.19,195884.19,390.00,63570.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196180',3829087,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196180',3829088,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196180',3829089,'2597','388',173382.88,174271.88,876.18,142817.34,0.00,0.00,12.82,0.00,0.00),('1','171','878','196180',3829090,'2598','388',173823.66,175464.17,1630.51,265773.13,0.00,0.00,10.00,0.00,0.00),('1','171','878','196180',3829091,'2599','388',133930.49,134992.00,1051.51,171396.13,0.00,0.00,10.00,0.00,0.00),('1','171','878','196180',3829092,'2600','388',149154.84,149891.50,726.66,118445.58,0.00,0.00,10.00,0.00,0.00),('1','171','879','196180',3829093,'2601','388',194608.93,195629.11,1010.18,164659.34,0.00,0.00,10.00,0.00,0.00),('1','171','879','196180',3829094,'2602','388',199185.25,199843.78,658.53,107340.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','196180',3829095,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196180',3829096,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196180',3829097,'2740','412',50395.93,50395.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196180',3829098,'2741','412',271726.88,272503.66,776.78,201962.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','196267',3830420,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196267',3830421,'2594','388',195884.19,195884.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196267',3830422,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196267',3830423,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196267',3830424,'2597','388',174271.88,174680.04,408.16,66530.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','196267',3830425,'2598','388',175464.17,176820.05,1355.88,221008.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','196267',3830426,'2599','388',134992.00,135991.86,999.86,162977.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','196267',3830427,'2600','388',149891.50,151027.11,1135.61,185104.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','196267',3830428,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196267',3830429,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196267',3830430,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196267',3830431,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196267',3830432,'2740','412',50395.93,50395.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196267',3830433,'2741','412',272503.66,272813.65,309.99,80597.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','196269',3830447,'2593','388',205675.77,205675.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196269',3830448,'2594','388',195884.19,195884.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196269',3830449,'2595','388',161617.60,161617.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196269',3830450,'2596','388',221749.75,221749.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196269',3830451,'2597','388',174680.04,177687.09,3007.05,490149.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','196269',3830452,'2598','388',176820.05,179045.13,2225.08,362688.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','196269',3830453,'2599','388',135991.86,137246.15,1254.29,204449.27,0.00,0.00,0.00,0.00,0.00),('1','171','878','196269',3830454,'2600','388',151027.11,153287.09,2259.98,368376.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','196269',3830455,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196269',3830456,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196269',3830457,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196269',3830458,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196269',3830459,'2740','412',50395.93,50395.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196269',3830460,'2741','412',272813.65,273303.68,490.03,127407.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','196278',3830625,'2593','388',205675.77,205900.00,224.23,36549.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','196278',3830626,'2594','388',195884.19,195884.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196278',3830627,'2595','388',161617.60,161874.17,256.57,41820.91,0.00,0.00,0.00,0.00,0.00),('1','171','877','196278',3830628,'2596','388',221749.75,222009.02,259.27,42261.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','196278',3830629,'2597','388',177687.09,178399.09,712.00,116056.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196278',3830630,'2598','388',179045.13,179216.91,171.78,28000.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','196278',3830631,'2599','388',137246.15,138053.26,807.11,131558.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','196278',3830632,'2600','388',153287.09,154286.26,999.17,162864.71,0.00,0.00,0.00,0.00,0.00),('1','171','879','196278',3830633,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196278',3830634,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196278',3830635,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196278',3830636,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196278',3830637,'2740','412',50395.93,50485.93,90.00,23400.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196278',3830638,'2741','412',273303.68,273797.14,493.46,128299.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','196283',3830713,'2593','388',205900.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196283',3830714,'2594','388',195884.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196283',3830715,'2595','388',161874.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196283',3830716,'2596','388',222009.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196283',3830717,'2597','388',178399.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196283',3830718,'2598','388',179216.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196283',3830719,'2599','388',138053.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196283',3830720,'2600','388',154286.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196283',3830721,'2601','388',195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196283',3830722,'2602','388',199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196283',3830723,'2603','388',127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196283',3830724,'2604','388',169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196283',3830725,'2740','412',50485.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196283',3830726,'2741','412',273797.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196286',3830778,'2593','388',205900.00,207056.64,1156.64,188532.32,0.00,0.00,0.00,0.00,0.00),('1','171','877','196286',3830779,'2594','388',195884.19,197038.11,1153.92,188088.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','196286',3830780,'2595','388',161874.17,162493.57,619.40,100962.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196286',3830781,'2596','388',222009.02,222772.97,763.95,124523.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','196286',3830782,'2597','388',178399.09,178454.61,55.52,9049.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','196286',3830783,'2598','388',179216.91,181311.43,2094.52,341406.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','196286',3830784,'2599','388',138053.26,138056.94,3.68,599.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','196286',3830785,'2600','388',154286.26,155695.78,1409.52,229751.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','196286',3830786,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196286',3830787,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196286',3830788,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196286',3830789,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196286',3830790,'2740','412',50485.93,50722.40,236.47,61482.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','196286',3830791,'2741','412',273797.14,274365.21,568.07,147698.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','196362',3832272,'2593','388',207056.64,207532.01,475.37,77485.31,0.00,0.00,0.00,0.00,0.00),('1','171','877','196362',3832273,'2594','388',197038.11,198238.22,1200.11,195617.93,0.00,0.00,0.00,0.00,0.00),('1','171','877','196362',3832274,'2595','388',162493.57,162511.02,17.45,2844.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','196362',3832275,'2596','388',222772.97,224112.18,1339.21,218291.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','196362',3832276,'2597','388',178454.61,178856.43,401.82,65496.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','196362',3832277,'2598','388',181311.43,181364.14,52.71,8591.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','196362',3832278,'2599','388',138056.94,138520.98,464.04,75638.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','196362',3832279,'2600','388',155695.78,156192.05,496.27,80892.01,0.00,0.00,0.00,0.00,0.00),('1','171','879','196362',3832280,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196362',3832281,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196362',3832282,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196362',3832283,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196362',3832284,'2740','412',50722.40,51193.17,470.77,122400.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','196362',3832285,'2741','412',274365.21,274906.36,541.15,140699.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196549',3835564,'2593','388',207532.01,208894.02,1362.01,222007.63,0.00,0.00,0.00,0.00,0.00),('1','171','877','196549',3835565,'2594','388',198238.22,199613.20,1374.98,224121.74,0.00,0.00,0.00,0.00,0.00),('1','171','877','196549',3835566,'2595','388',162511.02,164402.41,1891.39,308296.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','196549',3835567,'2596','388',224112.18,224572.03,459.85,74955.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','196549',3835568,'2597','388',178856.43,179439.37,582.94,95019.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','196549',3835569,'2598','388',181364.14,183259.06,1894.92,308871.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','196549',3835570,'2599','388',138520.98,139323.05,782.07,127477.41,0.00,0.00,20.00,0.00,0.00),('1','171','878','196549',3835571,'2600','388',156192.05,156192.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196549',3835572,'2601','388',195629.11,195629.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196549',3835573,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196549',3835574,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196549',3835575,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196549',3835576,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196549',3835577,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196572',3835998,'2593','388',208894.02,209560.09,666.07,108569.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','196572',3835999,'2594','388',199613.20,200546.65,933.45,152152.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','196572',3836000,'2595','388',164402.41,165106.78,704.37,114812.31,0.00,0.00,0.00,0.00,0.00),('1','171','877','196572',3836001,'2596','388',224572.03,225920.33,1348.30,219772.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','196572',3836002,'2597','388',179439.37,180082.88,643.51,104892.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','196572',3836003,'2598','388',183259.06,183990.25,731.19,119183.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','196572',3836004,'2599','388',139323.05,139458.99,135.94,22158.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','196572',3836005,'2600','388',156192.05,156608.08,416.03,67812.89,0.00,0.00,0.00,0.00,0.00),('1','171','879','196572',3836006,'2601','388',195629.11,196181.43,552.32,90028.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','196572',3836007,'2602','388',199843.78,199843.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196572',3836008,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196572',3836009,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196572',3836010,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196572',3836011,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196688',3837957,'2593','388',209560.09,210686.09,1126.00,183538.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196688',3837958,'2594','388',200546.65,201488.06,941.41,153449.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','196688',3837959,'2595','388',165106.78,165963.68,856.90,139674.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','196688',3837960,'2596','388',225920.33,227015.05,1094.72,178439.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','196688',3837961,'2597','388',180082.88,180895.24,812.36,132414.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','196688',3837962,'2598','388',183990.25,184126.38,136.13,22189.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','196688',3837963,'2599','388',139458.99,139458.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196688',3837964,'2600','388',156608.08,157737.10,1129.02,184030.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','196688',3837965,'2601','388',196181.43,196181.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196688',3837966,'2602','388',199843.78,200745.76,901.98,147022.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','196688',3837967,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196688',3837968,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196688',3837969,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196688',3837970,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196780',3839634,'2593','388',210686.09,211376.44,690.35,112527.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','196780',3839635,'2594','388',201488.06,201734.51,246.45,40171.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','196780',3839636,'2595','388',165963.68,166455.42,491.74,80153.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','196780',3839637,'2596','388',227015.05,227666.07,651.02,106116.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','196780',3839638,'2597','388',180895.24,181113.33,218.09,35548.67,0.00,0.00,0.00,0.00,0.00),('1','171','878','196780',3839639,'2598','388',184126.38,184936.09,809.71,131982.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','196780',3839640,'2599','388',139458.99,139824.31,365.32,59547.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','196780',3839641,'2600','388',157737.10,158191.12,454.02,74005.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','196780',3839642,'2601','388',196181.43,196616.35,434.92,70891.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','196780',3839643,'2602','388',200745.76,200745.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196780',3839644,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196780',3839645,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196780',3839646,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196780',3839647,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196897',3841718,'2593','388',211376.44,212385.27,1008.83,164439.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','196897',3841719,'2594','388',201734.51,203786.77,2052.26,334518.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','196897',3841720,'2595','388',166455.42,167195.92,740.50,120701.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','196897',3841721,'2596','388',227666.07,228582.06,915.99,149306.37,0.00,0.00,0.00,0.00,0.00),('1','171','878','196897',3841722,'2597','388',181113.33,181512.84,399.51,65120.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','196897',3841723,'2598','388',184936.09,185988.41,1052.32,171528.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','196897',3841724,'2599','388',139824.31,139824.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','196897',3841725,'2600','388',158191.12,158673.85,482.73,78684.99,0.00,0.00,0.00,0.00,0.00),('1','171','879','196897',3841726,'2601','388',196616.35,197458.63,842.28,137291.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','196897',3841727,'2602','388',200745.76,200745.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196897',3841728,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196897',3841729,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196897',3841730,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196897',3841731,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196945',3842587,'2593','388',212385.27,213744.52,1359.25,221557.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','196945',3842588,'2594','388',203786.77,203786.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196945',3842589,'2595','388',167195.92,167195.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','196945',3842590,'2596','388',228582.06,229091.40,509.34,83022.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','196945',3842591,'2597','388',181512.84,182003.20,490.36,79928.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','196945',3842592,'2598','388',185988.41,186695.71,707.30,115289.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','196945',3842593,'2599','388',139824.31,140160.21,335.90,54751.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','196945',3842594,'2600','388',158673.85,159115.47,441.62,71984.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','196945',3842595,'2601','388',197458.63,197458.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196945',3842596,'2602','388',200745.76,201496.46,750.70,122364.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','196945',3842597,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','196945',3842598,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196945',3842599,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','196945',3842600,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197087',3845084,'2593','388',213744.52,214817.36,1072.84,174872.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','197087',3845085,'2594','388',203786.77,204730.80,944.03,153876.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','197087',3845086,'2595','388',167195.92,167855.42,659.50,107498.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','197087',3845087,'2596','388',229091.40,230675.05,1583.65,258134.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','197087',3845088,'2597','388',182003.20,182003.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197087',3845089,'2598','388',186695.71,187749.05,1053.34,171694.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','197087',3845090,'2599','388',140160.21,140894.63,734.42,119710.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','197087',3845091,'2600','388',159115.47,159115.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197087',3845092,'2601','388',197458.63,198039.72,581.09,94717.67,0.00,0.00,0.00,0.00,0.00),('1','171','879','197087',3845093,'2602','388',201496.46,201496.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197087',3845094,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197087',3845095,'2604','388',169624.10,169624.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197087',3845096,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197087',3845097,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197148',3846283,'2593','388',214817.36,215548.11,730.75,119112.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','197148',3846284,'2594','388',204730.80,205461.38,730.58,119084.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','197148',3846285,'2595','388',167855.42,168508.64,653.22,106474.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','197148',3846286,'2596','388',230675.05,231100.84,425.79,69403.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','197148',3846287,'2597','388',182003.20,182003.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197148',3846288,'2598','388',187749.05,188705.11,956.06,155837.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','197148',3846289,'2599','388',140894.63,140894.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197148',3846290,'2600','388',159115.47,159482.99,357.52,58275.76,0.00,0.00,10.00,0.00,0.00),('1','171','879','197148',3846291,'2601','388',198039.72,198039.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197148',3846292,'2602','388',201496.46,202377.61,881.15,143627.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','197148',3846293,'2603','388',127788.62,127788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197148',3846294,'2604','388',169624.10,169746.37,122.27,19930.01,0.00,0.00,0.00,0.00,0.00),('1','171','932','197148',3846295,'2740','412',51193.17,51193.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197148',3846296,'2741','412',274906.36,274906.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197465',3851583,'2593','388',215548.11,215548.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197465',3851584,'2594','388',205461.38,207467.85,2006.47,327054.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','197465',3851585,'2595','388',168508.64,169967.03,1458.39,237717.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','197465',3851586,'2596','388',231100.84,231866.33,765.49,124774.87,0.00,0.00,0.00,0.00,0.00),('1','171','878','197465',3851587,'2597','388',182003.20,183310.93,1307.73,213159.99,0.00,0.00,0.00,0.00,0.00),('1','171','878','197465',3851588,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197465',3851589,'2599','388',140894.63,141786.04,891.41,145299.83,0.00,0.00,0.00,0.00,0.00),('1','171','878','197465',3851590,'2600','388',159482.99,159482.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197465',3851591,'2601','388',198039.72,198620.84,581.12,94722.56,0.00,0.00,0.00,0.00,0.00),('1','171','879','197465',3851592,'2602','388',202377.61,202377.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197465',3851593,'2603','388',127788.62,128360.09,571.47,93149.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','197465',3851594,'2604','388',169746.37,169746.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197465',3851595,'2740','412',51193.17,51295.25,102.08,26540.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','197465',3851596,'2741','412',274906.36,275689.20,782.84,203538.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','197546',3852870,'2593','388',215548.11,216949.96,1401.85,228501.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','197546',3852871,'2594','388',207467.85,207512.55,44.70,7286.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','197546',3852872,'2595','388',169967.03,171394.11,1427.08,232614.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','197546',3852873,'2596','388',231866.33,232030.73,164.40,26797.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','197546',3852874,'2597','388',183310.93,183807.49,496.56,80939.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','197546',3852875,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197546',3852876,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197546',3852877,'2600','388',159482.99,160424.91,941.92,153532.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','197546',3852878,'2601','388',198620.84,199533.92,913.08,148832.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','197546',3852879,'2602','388',202377.61,202377.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197546',3852880,'2603','388',128360.09,128701.43,341.34,55638.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','197546',3852881,'2604','388',169746.37,169840.81,94.44,15393.72,0.00,0.00,0.00,0.00,0.00),('1','171','932','197546',3852882,'2740','412',51295.25,51548.46,253.21,65834.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','197546',3852883,'2741','412',275689.20,276392.02,702.82,182733.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','197729',3856142,'2593','388',216949.96,217795.35,845.39,137798.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','197729',3856143,'2594','388',207512.55,208945.72,1433.17,233606.71,0.00,0.00,0.00,0.00,0.00),('1','171','877','197729',3856144,'2595','388',171394.11,172387.71,993.60,161956.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','197729',3856145,'2596','388',232030.73,233273.96,1243.23,202646.49,0.00,0.00,0.00,0.00,0.00),('1','171','878','197729',3856146,'2597','388',183807.49,184613.99,806.50,131459.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','197729',3856147,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197729',3856148,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197729',3856149,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197729',3856150,'2601','388',199533.92,199533.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197729',3856151,'2602','388',202377.61,203551.46,1173.85,191337.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','197729',3856152,'2603','388',128701.43,128701.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197729',3856153,'2604','388',169840.81,171249.82,1409.01,229668.63,0.00,0.00,0.00,0.00,0.00),('1','171','932','197729',3856154,'2740','412',51548.46,51759.99,211.53,54997.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','197729',3856155,'2741','412',276392.02,276738.95,346.93,90201.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','197732',3856195,'2593','388',217795.35,218883.27,1087.92,177330.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','197732',3856196,'2594','388',208945.72,210597.90,1652.18,269305.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','197732',3856197,'2595','388',172387.71,172926.04,538.33,87747.79,0.00,0.00,0.00,0.00,0.00),('1','171','877','197732',3856198,'2596','388',233273.96,233552.37,278.41,45380.83,0.00,0.00,0.00,0.00,0.00),('1','171','878','197732',3856199,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197732',3856200,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197732',3856201,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197732',3856202,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197732',3856203,'2601','388',199533.92,200220.39,686.47,111894.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','197732',3856204,'2602','388',203551.46,204098.59,547.13,89182.19,0.00,0.00,0.00,0.00,0.00),('1','171','879','197732',3856205,'2603','388',128701.43,128701.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197732',3856206,'2604','388',171249.82,171790.64,540.82,88153.66,0.00,0.00,0.00,0.00,0.00),('1','171','932','197732',3856207,'2740','412',51759.99,51759.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197732',3856208,'2741','412',276738.95,277015.10,276.15,71799.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197742',3856357,'2593','388',218883.27,220183.87,1300.60,211997.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','197742',3856358,'2594','388',210597.90,211566.91,969.01,157948.63,0.00,0.00,0.00,0.00,0.00),('1','171','877','197742',3856359,'2595','388',172926.04,174064.15,1138.11,185511.93,0.00,0.00,0.00,0.00,0.00),('1','171','877','197742',3856360,'2596','388',233552.37,235482.51,1930.14,314612.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','197742',3856361,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197742',3856362,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197742',3856363,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197742',3856364,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197742',3856365,'2601','388',200220.39,200760.84,540.45,88093.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','197742',3856366,'2602','388',204098.59,204998.49,899.90,146683.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','197742',3856367,'2603','388',128701.43,128911.81,210.38,34291.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','197742',3856368,'2604','388',171790.64,171790.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197742',3856369,'2740','412',51759.99,51759.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197742',3856370,'2741','412',277015.10,277676.36,661.26,171927.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','197774',3857031,'2593','388',220183.87,220398.79,214.92,35031.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','197774',3857032,'2594','388',211566.91,213734.50,2167.59,353317.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','197774',3857033,'2595','388',174064.15,174882.58,818.43,133404.09,0.00,0.00,0.00,0.00,0.00),('1','171','877','197774',3857034,'2596','388',235482.51,235482.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197774',3857035,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197774',3857036,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197774',3857037,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197774',3857038,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197774',3857039,'2601','388',200760.84,201648.05,887.21,144615.23,0.00,0.00,0.00,0.00,0.00),('1','171','879','197774',3857040,'2602','388',204998.49,205700.03,701.54,114351.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','197774',3857041,'2603','388',128911.81,129680.91,769.10,125363.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','197774',3857042,'2604','388',171790.64,172310.83,520.19,84790.97,0.00,0.00,0.00,0.00,0.00),('1','171','932','197774',3857043,'2740','412',51759.99,52226.08,466.09,121183.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','197774',3857044,'2741','412',277676.36,278983.60,1307.24,339882.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','197864',3858695,'2593','388',220398.79,220398.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','197864',3858696,'2594','388',213734.50,213807.14,72.64,11840.32,0.00,0.00,0.00,0.00,0.00),('1','171','877','197864',3858697,'2595','388',174882.58,175987.77,1105.19,180145.97,0.00,0.00,0.00,0.00,0.00),('1','171','877','197864',3858698,'2596','388',235482.51,235482.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197864',3858699,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197864',3858700,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197864',3858701,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','197864',3858702,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','197864',3858703,'2601','388',201648.05,203159.39,1511.34,246348.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','197864',3858704,'2602','388',205700.03,207564.54,1864.51,303915.13,0.00,0.00,0.00,0.00,0.00),('1','171','879','197864',3858705,'2603','388',129680.91,131059.34,1378.43,224684.09,0.00,0.00,0.00,0.00,0.00),('1','171','879','197864',3858706,'2604','388',172310.83,174383.30,2072.47,337812.61,0.00,0.00,0.00,0.00,0.00),('1','171','932','197864',3858707,'2740','412',52226.08,52226.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','197864',3858708,'2741','412',278983.60,280118.69,1135.09,295123.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','198034',3861733,'2593','388',220398.79,220398.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198034',3861734,'2594','388',213807.14,213807.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198034',3861735,'2595','388',175987.77,175987.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198034',3861736,'2596','388',235482.51,235482.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198034',3861737,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198034',3861738,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198034',3861739,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198034',3861740,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198034',3861741,'2601','388',203159.39,204689.93,1530.54,249478.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','198034',3861742,'2602','388',207564.54,208394.63,830.09,135304.67,0.00,0.00,0.00,0.00,0.00),('1','171','879','198034',3861743,'2603','388',131059.34,132675.89,1616.55,263497.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','198034',3861744,'2604','388',174383.30,176006.71,1623.41,264615.83,0.00,0.00,0.00,0.00,0.00),('1','171','932','198034',3861745,'2740','412',52226.08,52452.23,226.15,58799.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198034',3861746,'2741','412',280118.69,281417.76,1299.07,337758.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','198140',3863334,'2593','388',220398.79,221564.99,1166.20,190090.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','198140',3863335,'2594','388',213807.14,215084.69,1277.55,208240.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','198140',3863336,'2595','388',175987.77,175987.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198140',3863337,'2596','388',235482.51,236823.50,1340.99,218581.37,0.00,0.00,0.00,0.00,0.00),('1','171','878','198140',3863338,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198140',3863339,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198140',3863340,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198140',3863341,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198140',3863342,'2601','388',204689.93,204689.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198140',3863343,'2602','388',208394.63,211097.51,2702.88,440569.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','198140',3863344,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198140',3863345,'2604','388',176006.71,177665.88,1659.17,270444.71,0.00,0.00,0.00,0.00,0.00),('1','171','932','198140',3863346,'2740','412',52452.23,53031.76,579.53,150677.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','198140',3863347,'2741','412',281417.76,282861.94,1444.18,375486.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','198238',3864996,'2593','388',221564.99,222557.30,992.31,161746.53,0.00,0.00,0.00,0.00,0.00),('1','171','877','198238',3864997,'2594','388',215084.69,215158.86,74.17,12089.71,0.00,0.00,0.00,0.00,0.00),('1','171','877','198238',3864998,'2595','388',175987.77,177158.45,1170.68,190820.84,0.00,0.00,0.00,0.00,0.00),('1','171','877','198238',3864999,'2596','388',236823.50,237800.61,977.11,159268.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','198238',3865000,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198238',3865001,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198238',3865002,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198238',3865003,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198238',3865004,'2601','388',204689.93,204689.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198238',3865005,'2602','388',211097.51,212779.73,1682.22,274201.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','198238',3865006,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198238',3865007,'2604','388',177665.88,177665.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198238',3865008,'2740','412',53031.76,53274.76,243.00,63180.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198238',3865009,'2741','412',282861.94,284251.35,1389.41,361246.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','198394',3867681,'2593','388',222557.30,223830.12,1272.82,207469.66,0.00,0.00,0.00,0.00,0.00),('1','171','877','198394',3867682,'2594','388',215158.86,218173.37,3014.51,491365.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','198394',3867683,'2595','388',177158.45,178349.86,1191.41,194199.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','198394',3867684,'2596','388',237800.61,239134.31,1333.70,217393.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','198394',3867685,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198394',3867686,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198394',3867687,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198394',3867688,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198394',3867689,'2601','388',204689.93,206266.31,1576.38,256949.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','198394',3867690,'2602','388',212779.73,212779.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198394',3867691,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198394',3867692,'2604','388',177665.88,177665.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198394',3867693,'2740','412',53274.76,53615.65,340.89,88631.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','198394',3867694,'2741','412',284251.35,286391.03,2139.68,556316.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','198473',3869181,'2593','388',223830.12,224854.60,1024.48,166990.24,0.00,0.00,0.00,0.00,0.00),('1','171','877','198473',3869182,'2594','388',218173.37,219726.92,1553.55,253228.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','198473',3869183,'2595','388',178349.86,179429.92,1080.06,176049.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','198473',3869184,'2596','388',239134.31,240355.61,1221.30,199071.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','198473',3869185,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198473',3869186,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198473',3869187,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198473',3869188,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198473',3869189,'2601','388',206266.31,207329.37,1063.06,173278.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','198473',3869190,'2602','388',212779.73,212779.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198473',3869191,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198473',3869192,'2604','388',177665.88,177665.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198473',3869193,'2740','412',53615.65,53615.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198473',3869194,'2741','412',286391.03,288080.48,1689.45,439257.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198643',3872070,'2593','388',224854.60,225869.25,1014.65,165387.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','198643',3872071,'2594','388',219726.92,221486.95,1760.03,286884.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','198643',3872072,'2595','388',179429.92,180343.35,913.43,148889.09,0.00,0.00,0.00,0.00,0.00),('1','171','877','198643',3872073,'2596','388',240355.61,241903.56,1547.95,252315.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','198643',3872074,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198643',3872075,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198643',3872076,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198643',3872077,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198643',3872078,'2601','388',207329.37,208691.33,1361.96,221999.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','198643',3872079,'2602','388',212779.73,214534.57,1754.84,286038.92,0.00,0.00,0.00,0.00,0.00),('1','171','879','198643',3872080,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198643',3872081,'2604','388',177665.88,177665.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198643',3872082,'2740','412',53615.65,55729.25,2113.60,549536.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198643',3872083,'2741','412',288080.48,290508.13,2427.65,631189.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198687',3872957,'2593','388',225869.25,226905.32,1036.07,168879.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','198687',3872958,'2594','388',221486.95,222905.17,1418.22,231169.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','198687',3872959,'2595','388',180343.35,181398.88,1055.53,172051.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','198687',3872960,'2596','388',241903.56,242998.55,1094.99,178483.37,0.00,0.00,0.00,0.00,0.00),('1','171','878','198687',3872961,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198687',3872962,'2598','388',188705.11,188705.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198687',3872963,'2599','388',141786.04,141786.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198687',3872964,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198687',3872965,'2601','388',208691.33,209288.92,597.59,97407.17,0.00,0.00,0.00,0.00,0.00),('1','171','879','198687',3872966,'2602','388',214534.57,214971.10,436.53,71154.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','198687',3872967,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198687',3872968,'2604','388',177665.88,177665.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198687',3872969,'2740','412',55729.25,56491.02,761.77,198060.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','198687',3872970,'2741','412',290508.13,292486.24,1978.11,514308.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','198845',3875298,'2593','388',226905.32,226905.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198845',3875299,'2594','388',222905.17,223687.62,762.45,124279.35,0.00,0.00,20.00,0.00,0.00),('1','171','877','198845',3875300,'2595','388',181398.88,181398.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198845',3875301,'2596','388',242998.55,244446.20,1447.65,235966.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','198845',3875302,'2597','388',184613.99,184613.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198845',3875303,'2598','388',188705.11,189674.09,968.98,157943.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','198845',3875304,'2599','388',141786.04,142667.74,881.70,143717.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','198845',3875305,'2600','388',160424.91,160424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198845',3875306,'2601','388',209288.92,210186.68,897.76,146334.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','198845',3875307,'2602','388',214971.10,215657.69,686.59,111914.17,0.00,0.00,0.00,0.00,0.00),('1','171','879','198845',3875308,'2603','388',132675.89,132675.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198845',3875309,'2604','388',177665.88,178061.64,395.76,64508.88,0.00,0.00,0.00,0.00,0.00),('1','171','932','198845',3875310,'2740','412',56491.02,56539.87,48.85,12701.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','198845',3875311,'2741','412',292486.24,294002.75,1516.51,394292.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','198907',3876545,'2593','388',226905.32,226905.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','198907',3876546,'2594','388',223687.62,224879.13,1191.51,194216.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','198907',3876547,'2595','388',181398.88,181400.41,1.53,249.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','198907',3876548,'2596','388',244446.20,245212.62,766.42,124926.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','198907',3876549,'2597','388',184613.99,185927.28,1313.29,214066.27,0.00,0.00,0.00,0.00,0.00),('1','171','878','198907',3876550,'2598','388',189674.09,189674.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198907',3876551,'2599','388',142667.74,142667.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','198907',3876552,'2600','388',160424.91,161324.98,900.07,146711.41,0.00,0.00,0.00,0.00,0.00),('1','171','879','198907',3876553,'2601','388',210186.68,210186.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','198907',3876554,'2602','388',215657.69,216638.08,980.39,159803.57,0.00,0.00,0.00,0.00,0.00),('1','171','879','198907',3876555,'2603','388',132675.89,132808.60,132.71,21631.73,0.00,0.00,0.00,0.00,0.00),('1','171','879','198907',3876556,'2604','388',178061.64,178754.57,692.93,112947.59,0.00,0.00,0.00,0.00,0.00),('1','171','932','198907',3876557,'2740','412',56539.87,56760.64,220.77,57400.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','198907',3876558,'2741','412',294002.75,295047.14,1044.39,271541.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','199048',3878948,'2593','388',226905.32,227900.21,994.89,162167.07,0.00,0.00,0.00,0.00,0.00),('1','171','877','199048',3878949,'2594','388',224879.13,224879.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','199048',3878950,'2595','388',181400.41,182606.64,1206.23,196615.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','199048',3878951,'2596','388',245212.62,246009.95,797.33,129964.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','199048',3878952,'2597','388',185927.28,185927.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199048',3878953,'2598','388',189674.09,191099.88,1425.79,232403.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','199048',3878954,'2599','388',142667.74,142667.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199048',3878955,'2600','388',161324.98,162053.89,728.91,118812.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','199048',3878956,'2601','388',210186.68,210924.87,738.19,120324.97,0.00,0.00,0.00,0.00,0.00),('1','171','879','199048',3878957,'2602','388',216638.08,216638.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199048',3878958,'2603','388',132808.60,132808.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199048',3878959,'2604','388',178754.57,179308.72,554.15,90326.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','199048',3878960,'2740','412',56760.64,56829.86,69.22,17997.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','199048',3878961,'2741','412',295047.14,295879.07,831.93,216301.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','199116',3880341,'2593','388',227900.21,228550.15,649.94,105940.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','199116',3880342,'2594','388',224879.13,224879.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','199116',3880343,'2595','388',182606.64,183799.87,1193.23,194496.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','199116',3880344,'2596','388',246009.95,246009.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199116',3880345,'2597','388',185927.28,185927.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199116',3880346,'2598','388',191099.88,192249.44,1149.56,187378.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','199116',3880347,'2599','388',142667.74,142667.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199116',3880348,'2600','388',162053.89,163345.84,1291.95,210587.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','199116',3880349,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199116',3880350,'2602','388',216638.08,217451.70,807.34,131596.42,0.00,0.00,6.28,0.00,0.00),('1','171','879','199116',3880351,'2603','388',132808.60,132833.14,24.54,4000.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','199116',3880352,'2604','388',179308.72,179376.28,61.27,9987.01,0.00,0.00,6.29,0.00,0.00),('1','171','932','199116',3880353,'2740','412',56829.86,56849.09,19.23,4999.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','199116',3880354,'2741','412',295879.07,297524.08,1645.01,427702.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','199257',3882599,'2593','388',228550.15,230491.34,1941.19,316413.97,0.00,0.00,0.00,0.00,0.00),('1','171','877','199257',3882600,'2594','388',224879.13,225862.80,983.67,160338.21,0.00,0.00,0.00,0.00,0.00),('1','171','877','199257',3882601,'2595','388',183799.87,184625.62,825.75,134597.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','199257',3882602,'2596','388',246009.95,246651.90,641.95,104637.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','199257',3882603,'2597','388',185927.28,186751.93,824.65,134417.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','199257',3882604,'2598','388',192249.44,192249.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199257',3882605,'2599','388',142667.74,143666.75,999.01,162838.63,0.00,0.00,0.00,0.00,0.00),('1','171','878','199257',3882606,'2600','388',163345.84,163345.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199257',3882607,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199257',3882608,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199257',3882609,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199257',3882610,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199257',3882611,'2740','412',56849.09,56849.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199257',3882612,'2741','412',297524.08,298298.57,774.49,201367.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','199358',3884212,'2593','388',230491.34,231410.34,919.00,149797.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','199358',3884213,'2594','388',225862.80,227174.23,1311.43,213763.09,0.00,0.00,0.00,0.00,0.00),('1','171','877','199358',3884214,'2595','388',184625.62,185635.04,1009.42,164535.46,0.00,0.00,0.00,0.00,0.00),('1','171','877','199358',3884215,'2596','388',246651.90,247698.46,1046.56,170589.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','199358',3884216,'2597','388',186751.93,188195.64,1443.71,235324.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','199358',3884217,'2598','388',192249.44,192249.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199358',3884218,'2599','388',143666.75,143666.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199358',3884219,'2600','388',163345.84,163345.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199358',3884220,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199358',3884221,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199358',3884222,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199358',3884223,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199358',3884224,'2740','412',56849.09,57965.56,1116.47,290282.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','199358',3884225,'2741','412',298298.57,299478.58,1180.01,306802.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','199493',3886277,'2593','388',231410.34,232760.86,1350.52,220134.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','199493',3886278,'2594','388',227174.23,228349.49,1175.26,191567.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','199493',3886279,'2595','388',185635.04,186464.25,829.21,135161.23,0.00,0.00,0.00,0.00,0.00),('1','171','877','199493',3886280,'2596','388',247698.46,248481.01,782.55,127555.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','199493',3886281,'2597','388',188195.64,188195.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199493',3886282,'2598','388',192249.44,193525.62,1276.18,208017.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','199493',3886283,'2599','388',143666.75,144684.13,1017.38,165832.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','199493',3886284,'2600','388',163345.84,164533.94,1188.10,193660.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','199493',3886285,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199493',3886286,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199493',3886287,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199493',3886288,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199493',3886289,'2740','412',57965.56,58088.29,122.73,31909.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','199493',3886290,'2741','412',299478.58,301237.92,1759.34,457428.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','199566',3887766,'2593','388',232760.86,233065.46,304.60,49649.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','199566',3887767,'2594','388',228349.49,229618.49,1269.00,206847.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','199566',3887768,'2595','388',186464.25,187260.65,796.40,129813.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','199566',3887769,'2596','388',248481.01,249736.12,1255.11,204582.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','199566',3887770,'2597','388',188195.64,188195.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199566',3887771,'2598','388',193525.62,195389.87,1864.25,303872.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','199566',3887772,'2599','388',144684.13,144684.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199566',3887773,'2600','388',164533.94,165232.83,698.89,113919.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','199566',3887774,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199566',3887775,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199566',3887776,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199566',3887777,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199566',3887778,'2740','412',58088.29,58789.03,700.74,182192.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','199566',3887779,'2741','412',301237.92,302266.08,1028.16,267321.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','199721',3890043,'2593','388',233065.46,235855.40,2789.94,454760.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','199721',3890044,'2594','388',229618.49,230718.29,1099.80,179267.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','199721',3890045,'2595','388',187260.65,188413.31,1152.66,187883.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','199721',3890046,'2596','388',249736.12,250882.10,1145.98,186794.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','199721',3890047,'2597','388',188195.64,189301.70,1106.06,180287.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','199721',3890048,'2598','388',195389.87,195389.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','199721',3890049,'2599','388',144684.13,145822.04,1137.91,185479.33,0.00,0.00,0.00,0.00,0.00),('1','171','878','199721',3890050,'2600','388',165232.83,165232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199721',3890051,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199721',3890052,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199721',3890053,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199721',3890054,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199721',3890055,'2740','412',58789.03,58877.34,88.31,22960.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','199721',3890056,'2741','412',302266.08,303284.17,1018.09,264703.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','199797',3891325,'2593','388',235855.40,236278.58,423.18,68978.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','199797',3891326,'2594','388',230718.29,231679.14,960.85,156618.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','199797',3891327,'2595','388',188413.31,188916.92,503.61,82088.43,0.00,0.00,0.00,0.00,0.00),('1','171','877','199797',3891328,'2596','388',250882.10,251418.59,536.49,87447.87,0.00,0.00,0.00,0.00,0.00),('1','171','878','199797',3891329,'2597','388',189301.70,189900.62,598.92,97623.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','199797',3891330,'2598','388',195389.87,196433.28,1043.41,170075.83,0.00,0.00,0.00,0.00,0.00),('1','171','878','199797',3891331,'2599','388',145822.04,146416.16,594.12,96841.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','199797',3891332,'2600','388',165232.83,166506.77,1273.94,207652.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','199797',3891333,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199797',3891334,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199797',3891335,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199797',3891336,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199797',3891337,'2740','412',58877.34,58932.34,55.00,14300.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199797',3891338,'2741','412',303284.17,305016.85,1732.68,450496.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','199915',3893149,'2593','388',236278.58,237212.57,933.99,152240.37,0.00,0.00,0.00,0.00,0.00),('1','171','877','199915',3893150,'2594','388',231679.14,232717.59,1038.45,169267.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','199915',3893151,'2595','388',188916.92,189555.09,638.17,104021.71,0.00,0.00,0.00,0.00,0.00),('1','171','877','199915',3893152,'2596','388',251418.59,252202.54,783.95,127783.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','199915',3893153,'2597','388',189900.62,190177.52,276.90,45134.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','199915',3893154,'2598','388',196433.28,197728.74,1295.46,211159.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','199915',3893155,'2599','388',146416.16,147248.12,831.96,135609.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','199915',3893156,'2600','388',166506.77,166506.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199915',3893157,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199915',3893158,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199915',3893159,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','199915',3893160,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','199915',3893161,'2740','412',58932.34,58955.42,23.08,6000.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','199915',3893162,'2741','412',305016.85,306374.96,1358.11,353108.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','200027',3895638,'2593','388',237212.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200027',3895639,'2594','388',232717.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200027',3895640,'2595','388',189555.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200027',3895641,'2596','388',252202.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200027',3895642,'2597','388',190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200027',3895643,'2598','388',197728.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200027',3895644,'2599','388',147248.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200027',3895645,'2600','388',166506.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200027',3895646,'2601','388',210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200027',3895647,'2602','388',217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200027',3895648,'2603','388',132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200027',3895649,'2604','388',179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200027',3895650,'2740','412',58955.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200027',3895651,'2741','412',306374.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200028',3895652,'2593','388',237212.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200028',3895653,'2594','388',232717.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200028',3895654,'2595','388',189555.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200028',3895655,'2596','388',252202.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200028',3895656,'2597','388',190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200028',3895657,'2598','388',197728.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200028',3895658,'2599','388',147248.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200028',3895659,'2600','388',166506.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200028',3895660,'2601','388',210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200028',3895661,'2602','388',217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200028',3895662,'2603','388',132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200028',3895663,'2604','388',179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200028',3895664,'2740','412',58955.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200028',3895665,'2741','412',306374.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200036',3895799,'2593','388',237212.57,237212.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200036',3895800,'2594','388',232717.59,232717.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200036',3895801,'2595','388',189555.09,189555.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200036',3895802,'2596','388',252202.54,252202.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200036',3895803,'2597','388',190177.52,190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200036',3895804,'2598','388',197728.74,197728.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200036',3895805,'2599','388',147248.12,147248.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200036',3895806,'2600','388',166506.77,166506.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200036',3895807,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200036',3895808,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200036',3895809,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200036',3895810,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200036',3895811,'2740','412',58955.42,59298.26,342.84,89138.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','200036',3895812,'2741','412',306374.96,307714.20,1339.24,348202.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','200037',3895813,'2593','388',237212.57,238380.97,1168.40,190449.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','200037',3895814,'2594','388',232717.59,234147.52,1429.93,233078.59,0.00,0.00,0.00,0.00,0.00),('1','171','877','200037',3895815,'2595','388',189555.09,190212.37,657.28,107136.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','200037',3895816,'2596','388',252202.54,253074.53,871.99,142134.37,0.00,0.00,0.00,0.00,0.00),('1','171','878','200037',3895817,'2597','388',190177.52,190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200037',3895818,'2598','388',197728.74,198826.63,1097.89,178956.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','200037',3895819,'2599','388',147248.12,147248.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200037',3895820,'2600','388',166506.77,167424.25,917.48,149549.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','200037',3895821,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200037',3895822,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200037',3895823,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200037',3895824,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200037',3895825,'2740','412',59298.26,59358.64,60.38,16000.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','200037',3895826,'2741','412',307714.20,307731.10,16.90,4478.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','200145',3897519,'2593','388',238380.97,239291.25,910.28,148375.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','200145',3897520,'2594','388',234147.52,235367.74,1220.22,198895.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','200145',3897521,'2595','388',190212.37,190946.40,734.03,119646.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','200145',3897522,'2596','388',253074.53,253992.80,918.27,149678.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','200145',3897523,'2597','388',190177.52,190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200145',3897524,'2598','388',198826.63,200167.00,1340.37,218480.31,0.00,0.00,0.00,0.00,0.00),('1','171','878','200145',3897525,'2599','388',147248.12,148104.81,856.69,139640.47,0.00,0.00,0.00,0.00,0.00),('1','171','878','200145',3897526,'2600','388',167424.25,167424.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200145',3897527,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200145',3897528,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200145',3897529,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200145',3897530,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200145',3897531,'2740','412',59358.64,59358.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200145',3897532,'2741','412',307731.10,308922.63,1191.53,315755.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','200223',3899125,'2593','388',239291.25,240348.19,1056.94,172281.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','200223',3899126,'2594','388',235367.74,236381.34,1013.60,165216.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','200223',3899127,'2595','388',190946.40,192167.21,1220.81,198992.03,0.00,0.00,0.00,0.00,0.00),('1','171','877','200223',3899128,'2596','388',253992.80,254876.49,883.69,144041.47,0.00,0.00,0.00,0.00,0.00),('1','171','878','200223',3899129,'2597','388',190177.52,190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200223',3899130,'2598','388',200167.00,201666.95,1499.95,244491.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','200223',3899131,'2599','388',148104.81,148942.70,837.89,136576.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','200223',3899132,'2600','388',167424.25,167424.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200223',3899133,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200223',3899134,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200223',3899135,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200223',3899136,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200223',3899137,'2740','412',59358.64,59549.98,191.34,50705.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','200223',3899138,'2741','412',308922.63,310615.46,1692.83,448599.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','200348',3901028,'2593','388',240348.19,241393.98,1045.79,170463.77,0.00,0.00,0.00,0.00,0.00),('1','171','877','200348',3901029,'2594','388',236381.34,237667.66,1286.32,209670.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','200348',3901030,'2595','388',192167.21,192866.75,699.54,114025.02,0.00,0.00,0.00,0.00,0.00),('1','171','877','200348',3901031,'2596','388',254876.49,256459.87,1583.38,258090.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','200348',3901032,'2597','388',190177.52,190177.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200348',3901033,'2598','388',201666.95,203130.61,1463.66,238576.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','200348',3901034,'2599','388',148942.70,150129.77,1187.07,193492.41,0.00,0.00,0.00,0.00,0.00),('1','171','878','200348',3901035,'2600','388',167424.25,167424.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200348',3901036,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200348',3901037,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200348',3901038,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200348',3901039,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200348',3901040,'2740','412',59549.98,59712.28,162.30,43009.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','200348',3901041,'2741','412',310615.46,312513.79,1898.33,503057.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','200414',3902450,'2593','388',241393.98,241975.22,581.24,94742.12,0.00,0.00,0.00,0.00,0.00),('1','171','877','200414',3902451,'2594','388',237667.66,238562.73,895.07,145896.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','200414',3902452,'2595','388',192866.75,193622.46,755.71,123180.73,0.00,0.00,0.00,0.00,0.00),('1','171','877','200414',3902453,'2596','388',256459.87,257321.45,861.58,140437.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','200414',3902454,'2597','388',190177.52,191023.09,845.57,137827.91,0.00,0.00,0.00,0.00,0.00),('1','171','878','200414',3902455,'2598','388',203130.61,203130.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200414',3902456,'2599','388',150129.77,150129.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200414',3902457,'2600','388',167424.25,168117.55,693.30,113007.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','200414',3902458,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200414',3902459,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200414',3902460,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200414',3902461,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200414',3902462,'2740','412',59712.28,59712.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200414',3902463,'2741','412',312513.79,312850.36,336.57,89191.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','200540',3904620,'2593','388',241975.22,242983.47,1008.25,164344.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','200540',3904621,'2594','388',238562.73,239900.72,1337.99,218092.37,0.00,0.00,0.00,0.00,0.00),('1','171','877','200540',3904622,'2595','388',193622.46,194844.86,1222.40,199251.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','200540',3904623,'2596','388',257321.45,258291.01,969.56,158038.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','200540',3904624,'2597','388',191023.09,191023.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200540',3904625,'2598','388',203130.61,204681.64,1551.03,252817.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','200540',3904626,'2599','388',150129.77,150998.55,868.78,141611.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','200540',3904627,'2600','388',168117.55,168117.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200540',3904628,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200540',3904629,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200540',3904630,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200540',3904631,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200540',3904632,'2740','412',59712.28,59732.28,20.00,5300.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200540',3904633,'2741','412',312850.36,313327.25,476.89,126375.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','200606',3905893,'2593','388',242983.47,243890.22,906.75,147800.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','200606',3905894,'2594','388',239900.72,240413.49,512.77,83581.51,0.00,0.00,0.00,0.00,0.00),('1','171','877','200606',3905895,'2595','388',194844.86,195494.22,649.36,105845.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','200606',3905896,'2596','388',258291.01,258859.91,568.90,92730.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','200606',3905897,'2597','388',191023.09,192060.70,1037.61,169130.43,0.00,0.00,0.00,0.00,0.00),('1','171','878','200606',3905898,'2598','388',204681.64,204681.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200606',3905899,'2599','388',150998.55,150998.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200606',3905900,'2600','388',168117.55,168920.49,802.94,130879.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','200606',3905901,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200606',3905902,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200606',3905903,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200606',3905904,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200606',3905905,'2740','412',59732.28,59732.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200606',3905906,'2741','412',313327.25,313734.74,407.49,107984.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','200735',3908086,'2593','388',243890.22,244861.96,971.74,158393.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','200735',3908087,'2594','388',240413.49,241810.76,1397.27,227755.01,0.00,0.00,0.00,0.00,0.00),('1','171','877','200735',3908088,'2595','388',195494.22,196368.29,874.07,142473.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','200735',3908089,'2596','388',258859.91,259584.57,724.66,118119.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','200735',3908090,'2597','388',192060.70,192060.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200735',3908091,'2598','388',204681.64,205784.41,1102.77,179751.51,0.00,0.00,0.00,0.00,0.00),('1','171','878','200735',3908092,'2599','388',150998.55,150998.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200735',3908093,'2600','388',168920.49,169522.88,602.39,98189.57,0.00,0.00,0.00,0.00,0.00),('1','171','879','200735',3908094,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200735',3908095,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200735',3908096,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200735',3908097,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200735',3908098,'2740','412',59732.28,60278.00,545.72,144615.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','200735',3908099,'2741','412',313734.74,315136.23,1401.49,371394.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','200816',3909640,'2593','388',244861.96,245502.99,621.03,101227.89,0.00,0.00,20.00,0.00,0.00),('1','171','877','200816',3909641,'2594','388',241810.76,242598.61,787.85,128419.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','200816',3909642,'2595','388',196368.29,196672.10,303.81,49521.03,0.00,0.00,0.00,0.00,0.00),('1','171','877','200816',3909643,'2596','388',259584.57,260012.76,428.19,69794.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','200816',3909644,'2597','388',192060.70,192060.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200816',3909645,'2598','388',205784.41,206707.69,923.28,150494.64,0.00,0.00,0.00,0.00,0.00),('1','171','878','200816',3909646,'2599','388',150998.55,151469.76,471.21,76807.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','200816',3909647,'2600','388',169522.88,170113.26,590.38,96231.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','200816',3909648,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200816',3909649,'2602','388',217451.70,217451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200816',3909650,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200816',3909651,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200816',3909652,'2740','412',60278.00,60636.54,358.54,95013.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','200816',3909653,'2741','412',315136.23,316562.89,1426.66,378064.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','200952',3911812,'2593','388',245502.99,245795.94,292.95,47750.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','200952',3911813,'2594','388',242598.61,243900.00,1301.39,212126.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','200952',3911814,'2595','388',196672.10,196672.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','200952',3911815,'2596','388',260012.76,261682.74,1669.98,272206.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','200952',3911816,'2597','388',192060.70,193775.40,1714.70,279496.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','200952',3911817,'2598','388',206707.69,206707.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200952',3911818,'2599','388',151469.76,151469.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','200952',3911819,'2600','388',170113.26,171101.27,988.01,161045.63,0.00,0.00,0.00,0.00,0.00),('1','171','879','200952',3911820,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200952',3911821,'2602','388',217451.70,217733.70,282.00,45966.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200952',3911822,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','200952',3911823,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','200952',3911824,'2740','412',60636.54,60747.86,111.32,29499.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','200952',3911825,'2741','412',316562.89,317916.35,1353.46,358666.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','201035',3913239,'2593','388',245795.94,246303.56,507.62,82742.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','201035',3913240,'2594','388',243900.00,244794.14,894.14,145744.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','201035',3913241,'2595','388',196672.10,197117.61,445.51,72618.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','201035',3913242,'2596','388',261682.74,262352.84,670.10,109226.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','201035',3913243,'2597','388',193775.40,194427.33,651.93,106264.59,0.00,0.00,0.00,0.00,0.00),('1','171','878','201035',3913244,'2598','388',206707.69,206707.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201035',3913245,'2599','388',151469.76,151469.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201035',3913246,'2600','388',171101.27,171448.78,347.51,56644.13,0.00,0.00,0.00,0.00,0.00),('1','171','879','201035',3913247,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201035',3913248,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201035',3913249,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201035',3913250,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201035',3913251,'2740','412',60747.86,60747.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201035',3913252,'2741','412',317916.35,318317.21,400.86,106227.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','201141',3914943,'2593','388',246303.56,247207.45,883.89,144074.07,0.00,0.00,20.00,0.00,0.00),('1','171','877','201141',3914944,'2594','388',244794.14,246087.17,1293.03,210763.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','201141',3914945,'2595','388',197117.61,197914.20,796.59,129844.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','201141',3914946,'2596','388',262352.84,263380.55,1027.71,167516.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','201141',3914947,'2597','388',194427.33,194427.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201141',3914948,'2598','388',206707.69,208291.82,1584.13,258213.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','201141',3914949,'2599','388',151469.76,151469.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201141',3914950,'2600','388',171448.78,172406.36,957.58,156085.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','201141',3914951,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201141',3914952,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201141',3914953,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201141',3914954,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201141',3914955,'2740','412',60747.86,61284.81,536.95,142291.75,0.00,0.00,0.00,0.00,0.00),('1','171','932','201141',3914956,'2741','412',318317.21,320373.50,2056.29,544916.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','201225',3916514,'2593','388',247207.45,248244.06,1036.61,168967.43,0.00,0.00,0.00,0.00,0.00),('1','171','877','201225',3916515,'2594','388',246087.17,247150.19,1063.02,173272.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','201225',3916516,'2595','388',197914.20,197914.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201225',3916517,'2596','388',263380.55,264604.06,1223.51,199432.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','201225',3916518,'2597','388',194427.33,194427.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201225',3916519,'2598','388',208291.82,209592.15,1300.33,211953.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','201225',3916520,'2599','388',151469.76,151469.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201225',3916521,'2600','388',172406.36,173338.96,932.60,152013.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','201225',3916522,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201225',3916523,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201225',3916524,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201225',3916525,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201225',3916526,'2740','412',61284.81,61358.39,73.58,19498.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','201225',3916527,'2741','412',320373.50,320995.06,621.56,164713.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','201339',3918349,'2593','388',248244.06,249253.72,1009.66,164574.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','201339',3918350,'2594','388',247150.19,248379.49,1229.30,200375.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','201339',3918351,'2595','388',197914.20,198818.36,904.16,147378.08,0.00,0.00,0.00,0.00,0.00),('1','171','877','201339',3918352,'2596','388',264604.06,265673.83,1069.77,174372.51,0.00,0.00,0.00,0.00,0.00),('1','171','878','201339',3918353,'2597','388',194427.33,195464.76,1037.43,169101.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','201339',3918354,'2598','388',209592.15,209592.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201339',3918355,'2599','388',151469.76,152558.29,1088.53,177430.39,0.00,0.00,0.00,0.00,0.00),('1','171','878','201339',3918356,'2600','388',173338.96,173338.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201339',3918357,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201339',3918358,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201339',3918359,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201339',3918360,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201339',3918361,'2740','412',61358.39,63605.55,2247.16,595497.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','201339',3918362,'2741','412',320995.06,322519.91,1524.85,404085.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','201429',3920107,'2593','388',249253.72,250001.41,747.69,121873.47,0.00,0.00,0.00,0.00,0.00),('1','171','877','201429',3920108,'2594','388',248379.49,248558.03,178.54,29102.02,0.00,0.00,0.00,0.00,0.00),('1','171','877','201429',3920109,'2595','388',198818.36,199462.94,644.58,105066.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','201429',3920110,'2596','388',265673.83,266534.89,861.06,140352.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','201429',3920111,'2597','388',195464.76,195592.97,128.21,20898.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','201429',3920112,'2598','388',209592.15,210919.89,1327.74,216421.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','201429',3920113,'2599','388',152558.29,152675.76,117.47,19147.61,0.00,0.00,0.00,0.00,0.00),('1','171','878','201429',3920114,'2600','388',173338.96,174245.72,906.76,147801.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','201429',3920115,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201429',3920116,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201429',3920117,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201429',3920118,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201429',3920119,'2740','412',63605.55,63902.99,297.44,78821.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','201429',3920120,'2741','412',322519.91,324121.16,1601.25,424331.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','201519',3921668,'2593','388',250001.41,250153.25,151.84,24749.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','201519',3921669,'2594','388',248558.03,250370.30,1812.27,295400.01,0.00,0.00,0.00,0.00,0.00),('1','171','877','201519',3921670,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201519',3921671,'2596','388',266534.89,267230.72,695.83,113420.29,0.00,0.00,0.00,0.00,0.00),('1','171','878','201519',3921672,'2597','388',195592.97,197186.53,1593.56,259750.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','201519',3921673,'2598','388',210919.89,212107.48,1187.59,193577.17,0.00,0.00,0.00,0.00,0.00),('1','171','878','201519',3921674,'2599','388',152675.76,153495.30,819.54,133585.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','201519',3921675,'2600','388',174245.72,175178.11,932.39,151979.57,0.00,0.00,0.00,0.00,0.00),('1','171','879','201519',3921676,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201519',3921677,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201519',3921678,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201519',3921679,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201519',3921680,'2740','412',63902.99,63902.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201519',3921681,'2741','412',324121.16,324121.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201615',3923536,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201615',3923537,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201615',3923538,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201615',3923539,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201615',3923540,'2597','388',197186.53,198868.23,1681.70,274117.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','201615',3923541,'2598','388',212107.48,213699.51,1592.03,259500.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','201615',3923542,'2599','388',153495.30,154957.30,1462.00,238306.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201615',3923543,'2600','388',175178.11,176037.07,858.96,140010.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','201615',3923544,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201615',3923545,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201615',3923546,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201615',3923547,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201615',3923548,'2740','412',63902.99,63902.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201615',3923549,'2741','412',324121.16,324121.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201781',3926829,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201781',3926830,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201781',3926831,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201781',3926832,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201781',3926833,'2597','388',198868.23,199988.45,1120.22,182595.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','201781',3926834,'2598','388',213699.51,215969.83,2270.32,370062.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','201781',3926835,'2599','388',154957.30,156450.21,1492.91,243344.33,0.00,0.00,0.00,0.00,0.00),('1','171','878','201781',3926836,'2600','388',176037.07,178595.98,2558.91,417102.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','201781',3926837,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201781',3926838,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201781',3926839,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201781',3926840,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201781',3926841,'2740','412',63902.99,63902.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201781',3926842,'2741','412',324121.16,324121.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201903',3929136,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201903',3929137,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201903',3929138,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','201903',3929139,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','201903',3929140,'2597','388',199988.45,201272.04,1283.59,209225.17,0.00,0.00,0.00,0.00,0.00),('1','171','878','201903',3929141,'2598','388',215969.83,217538.45,1568.62,255685.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','201903',3929142,'2599','388',156450.21,157332.99,882.78,143893.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','201903',3929143,'2600','388',178595.98,179981.33,1385.35,225812.05,0.00,0.00,0.00,0.00,0.00),('1','171','879','201903',3929144,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201903',3929145,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201903',3929146,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','201903',3929147,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201903',3929148,'2740','412',63902.99,63902.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','201903',3929149,'2741','412',324121.16,324121.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202033',3931654,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202033',3931655,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202033',3931656,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202033',3931657,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202033',3931658,'2597','388',201272.04,203267.28,1995.24,325224.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','202033',3931659,'2598','388',217538.45,219221.31,1682.86,274306.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','202033',3931660,'2599','388',157332.99,158516.23,1183.24,192868.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','202033',3931661,'2600','388',179981.33,181599.50,1618.17,263761.71,0.00,0.00,0.00,0.00,0.00),('1','171','879','202033',3931662,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202033',3931663,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202033',3931664,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202033',3931665,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202033',3931666,'2740','412',63902.99,63902.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202033',3931667,'2741','412',324121.16,324121.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202122',3933141,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202122',3933142,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202122',3933143,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202122',3933144,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202122',3933145,'2597','388',203267.28,204318.55,1051.27,171357.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','202122',3933146,'2598','388',219221.31,220644.83,1423.52,232033.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','202122',3933147,'2599','388',158516.23,159710.68,1194.45,194695.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','202122',3933148,'2600','388',181599.50,182514.99,915.49,149224.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','202122',3933149,'2601','388',210924.87,210924.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202122',3933150,'2602','388',217733.70,217733.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202122',3933151,'2603','388',132833.14,132833.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202122',3933152,'2604','388',179376.28,179376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202122',3933153,'2740','412',63902.99,64111.67,208.68,56343.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','202122',3933154,'2741','412',324121.16,324321.16,200.00,54000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202260',3935320,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202260',3935321,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202260',3935322,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202260',3935323,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202260',3935324,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202260',3935325,'2598','388',220644.83,220765.69,120.86,19700.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','202260',3935326,'2599','388',159710.68,161498.80,1788.12,291463.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','202260',3935327,'2600','388',182514.99,183014.99,500.00,81500.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202260',3935328,'2601','388',210924.87,211870.37,924.50,150693.50,0.00,0.00,21.00,0.00,0.00),('1','171','879','202260',3935329,'2602','388',217733.70,219052.70,1299.00,211737.00,0.00,0.00,20.00,0.00,0.00),('1','171','879','202260',3935330,'2603','388',132833.14,133462.32,607.68,99051.84,0.00,0.00,21.50,0.00,0.00),('1','171','879','202260',3935331,'2604','388',179376.28,180036.24,638.96,104150.48,0.00,0.00,21.00,0.00,0.00),('1','171','932','202260',3935332,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202260',3935333,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202339',3936757,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202339',3936758,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202339',3936759,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202339',3936760,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202339',3936761,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202339',3936762,'2598','388',220765.69,220765.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202339',3936763,'2599','388',161498.80,162550.15,1051.35,171370.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','202339',3936764,'2600','388',183014.99,183014.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202339',3936765,'2601','388',211870.37,212533.62,663.25,108109.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','202339',3936766,'2602','388',219052.70,220675.66,1622.96,264542.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','202339',3936767,'2603','388',133462.32,134805.98,1343.66,219016.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','202339',3936768,'2604','388',180036.24,181521.82,1485.58,242149.54,0.00,0.00,0.00,0.00,0.00),('1','171','932','202339',3936769,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202339',3936770,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202450',3938682,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202450',3938683,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202450',3938684,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202450',3938685,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202450',3938686,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202450',3938687,'2598','388',220765.69,220765.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202450',3938688,'2599','388',162550.15,162550.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202450',3938689,'2600','388',183014.99,183014.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202450',3938690,'2601','388',212533.62,215180.10,2646.48,431376.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','202450',3938691,'2602','388',220675.66,222329.47,1653.81,269571.03,0.00,0.00,0.00,0.00,0.00),('1','171','879','202450',3938692,'2603','388',134805.98,136052.98,1237.00,201631.00,0.00,0.00,10.00,0.00,0.00),('1','171','879','202450',3938693,'2604','388',181521.82,183155.29,1633.47,266255.61,0.00,0.00,0.00,0.00,0.00),('1','171','932','202450',3938694,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202450',3938695,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202540',3940343,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202540',3940344,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202540',3940345,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202540',3940346,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202540',3940347,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202540',3940348,'2598','388',220765.69,220765.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202540',3940349,'2599','388',162550.15,162550.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202540',3940350,'2600','388',183014.99,183014.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202540',3940351,'2601','388',215180.10,216682.29,1502.19,244856.97,0.00,0.00,0.00,0.00,0.00),('1','171','879','202540',3940352,'2602','388',222329.47,223828.36,1498.89,244319.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','202540',3940353,'2603','388',136052.98,137346.52,1293.54,210847.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','202540',3940354,'2604','388',183155.29,184367.06,1211.77,197518.51,0.00,0.00,0.00,0.00,0.00),('1','171','932','202540',3940355,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202540',3940356,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202670',3942491,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202670',3942492,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202670',3942493,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202670',3942494,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202670',3942495,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202670',3942496,'2598','388',220765.69,220765.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202670',3942497,'2599','388',162550.15,162550.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202670',3942498,'2600','388',183014.99,183014.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202670',3942499,'2601','388',216682.29,218002.01,1319.72,215114.36,0.00,0.00,0.00,0.00,0.00),('1','171','879','202670',3942500,'2602','388',223828.36,225668.25,1839.89,299902.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','202670',3942501,'2603','388',137346.52,138379.18,1032.66,168323.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','202670',3942502,'2604','388',184367.06,186109.21,1742.15,283970.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','202670',3942503,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202670',3942504,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202759',3944135,'2593','388',250153.25,250153.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202759',3944136,'2594','388',250370.30,250370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202759',3944137,'2595','388',199462.94,199462.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202759',3944138,'2596','388',267230.72,267230.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202759',3944139,'2597','388',204318.55,204318.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202759',3944140,'2598','388',220765.69,220765.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202759',3944141,'2599','388',162550.15,162550.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202759',3944142,'2600','388',183014.99,183014.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','202759',3944143,'2601','388',218002.01,219431.80,1429.79,233055.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','202759',3944144,'2602','388',225668.25,226722.78,1054.53,171888.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','202759',3944145,'2603','388',138379.18,139537.71,1158.53,188840.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','202759',3944146,'2604','388',186109.21,187259.83,1150.62,187551.06,0.00,0.00,0.00,0.00,0.00),('1','171','932','202759',3944147,'2740','412',64111.67,64111.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202759',3944148,'2741','412',324321.16,324321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202895',3946519,'2593','388',250153.25,250163.38,0.00,0.00,0.00,0.00,10.13,0.00,0.00),('1','171','877','202895',3946520,'2594','388',250370.30,251065.39,685.09,111669.67,0.00,0.00,10.00,0.00,0.00),('1','171','877','202895',3946521,'2595','388',199462.94,199473.17,0.00,0.00,0.00,0.00,10.23,0.00,0.00),('1','171','877','202895',3946522,'2596','388',267230.72,267693.79,453.07,73850.41,0.00,0.00,10.00,0.00,0.00),('1','171','878','202895',3946523,'2597','388',204318.55,204328.66,0.00,0.00,0.00,0.00,10.11,0.00,0.00),('1','171','878','202895',3946524,'2598','388',220765.69,221094.70,319.01,51998.63,0.00,0.00,10.00,0.00,0.00),('1','171','878','202895',3946525,'2599','388',162550.15,162565.06,0.72,117.36,0.00,0.00,14.19,0.00,0.00),('1','171','878','202895',3946526,'2600','388',183014.99,183499.06,454.07,74013.41,0.00,0.00,30.00,0.00,0.00),('1','171','879','202895',3946527,'2601','388',219431.80,220334.81,893.01,145560.63,0.00,0.00,10.00,0.00,0.00),('1','171','879','202895',3946528,'2602','388',226722.78,228324.98,1592.20,259528.60,0.00,0.00,10.00,0.00,0.00),('1','171','879','202895',3946529,'2603','388',139537.71,140291.42,743.71,121224.73,0.00,0.00,10.00,0.00,0.00),('1','171','879','202895',3946530,'2604','388',187259.83,187941.89,672.06,109545.78,0.00,0.00,10.00,0.00,0.00),('1','171','932','202895',3946531,'2740','412',64111.67,64313.47,201.80,54486.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202895',3946532,'2741','412',324321.16,324420.69,99.53,26873.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','202990',3948480,'2593','388',250163.38,250429.97,266.59,43454.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','202990',3948481,'2594','388',251065.39,251805.22,739.83,120592.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','202990',3948482,'2595','388',199473.17,199473.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','202990',3948483,'2596','388',267693.79,268260.42,566.63,92360.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','202990',3948484,'2597','388',204328.66,204876.97,548.31,89374.53,0.00,0.00,0.00,0.00,0.00),('1','171','878','202990',3948485,'2598','388',221094.70,221094.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202990',3948486,'2599','388',162565.06,162565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','202990',3948487,'2600','388',183499.06,184629.10,1130.04,184196.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','202990',3948488,'2601','388',220334.81,221015.48,680.67,110949.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','202990',3948489,'2602','388',228324.98,228915.99,591.01,96334.63,0.00,0.00,0.00,0.00,0.00),('1','171','879','202990',3948490,'2603','388',140291.42,140680.79,389.37,63467.31,0.00,0.00,0.00,0.00,0.00),('1','171','879','202990',3948491,'2604','388',187941.89,188871.04,929.15,151451.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','202990',3948492,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','202990',3948493,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203134',3951128,'2593','388',250429.97,250429.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203134',3951129,'2594','388',251805.22,253661.83,1856.61,302627.43,0.00,0.00,0.00,0.00,0.00),('1','171','877','203134',3951130,'2595','388',199473.17,200828.01,1354.84,220838.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','203134',3951131,'2596','388',268260.42,268260.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203134',3951132,'2597','388',204876.97,204876.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203134',3951133,'2598','388',221094.70,222519.50,1424.80,232242.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','203134',3951134,'2599','388',162565.06,163547.24,982.18,160095.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','203134',3951135,'2600','388',184629.10,184629.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203134',3951136,'2601','388',221015.48,221887.21,871.73,142091.99,0.00,0.00,0.00,0.00,0.00),('1','171','879','203134',3951137,'2602','388',228915.99,229374.27,458.28,74699.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','203134',3951138,'2603','388',140680.79,140680.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203134',3951139,'2604','388',188871.04,189614.15,733.11,119496.93,0.00,0.00,10.00,0.00,0.00),('1','171','932','203134',3951140,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203134',3951141,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203220',3952798,'2593','388',250429.97,251167.38,737.41,120197.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','203220',3952799,'2594','388',253661.83,254285.74,623.91,101697.33,0.00,0.00,0.00,0.00,0.00),('1','171','877','203220',3952800,'2595','388',200828.01,201567.16,739.15,120481.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','203220',3952801,'2596','388',268260.42,269242.72,982.30,160114.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','203220',3952802,'2597','388',204876.97,204876.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203220',3952803,'2598','388',222519.50,223736.61,1217.11,198388.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','203220',3952804,'2599','388',163547.24,164174.13,626.89,102183.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','203220',3952805,'2600','388',184629.10,184629.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203220',3952806,'2601','388',221887.21,222543.66,656.45,107001.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','203220',3952807,'2602','388',229374.27,229374.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203220',3952808,'2603','388',140680.79,140680.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203220',3952809,'2604','388',189614.15,190286.80,672.65,109641.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','203220',3952810,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203220',3952811,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203328',3954661,'2593','388',251167.38,253390.90,2223.52,362433.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','203328',3954662,'2594','388',254285.74,254752.00,466.26,76000.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','203328',3954663,'2595','388',201567.16,201567.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203328',3954664,'2596','388',269242.72,271281.46,2038.74,332314.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','203328',3954665,'2597','388',204876.97,206267.79,1390.82,226703.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','203328',3954666,'2598','388',223736.61,223736.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203328',3954667,'2599','388',164174.13,164174.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203328',3954668,'2600','388',184629.10,186011.75,1382.65,225371.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','203328',3954669,'2601','388',222543.66,222543.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203328',3954670,'2602','388',229374.27,231047.59,1673.32,272751.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','203328',3954671,'2603','388',140680.79,141741.76,1060.97,172938.11,0.00,0.00,0.00,0.00,0.00),('1','171','879','203328',3954672,'2604','388',190286.80,190286.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203328',3954673,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203328',3954674,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203428',3956578,'2593','388',253390.90,253390.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203428',3956579,'2594','388',254752.00,255224.10,472.10,76952.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','203428',3956580,'2595','388',201567.16,201994.36,427.20,69633.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','203428',3956581,'2596','388',271281.46,271823.40,541.94,88336.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','203428',3956582,'2597','388',206267.79,206516.55,248.76,40547.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','203428',3956583,'2598','388',223736.61,223894.88,158.27,25798.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','203428',3956584,'2599','388',164174.13,164174.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203428',3956585,'2600','388',186011.75,186250.00,238.25,38834.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','203428',3956586,'2601','388',222543.66,222596.71,53.05,8647.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','203428',3956587,'2602','388',231047.59,231047.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203428',3956588,'2603','388',141741.76,141741.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203428',3956589,'2604','388',190286.80,190365.95,79.15,12901.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','203428',3956590,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203428',3956591,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203536',3958444,'2593','388',253390.90,253611.31,220.41,35926.83,0.00,0.00,0.00,0.00,0.00),('1','171','877','203536',3958445,'2594','388',255224.10,255684.98,460.88,75123.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','203536',3958446,'2595','388',201994.36,202396.36,402.00,65526.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203536',3958447,'2596','388',271823.40,272574.47,751.07,122424.41,0.00,0.00,0.00,0.00,0.00),('1','171','878','203536',3958448,'2597','388',206516.55,206614.88,98.33,16027.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','203536',3958449,'2598','388',223894.88,224349.03,454.15,74026.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','203536',3958450,'2599','388',164174.13,164215.23,41.10,6699.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','203536',3958451,'2600','388',186250.00,186327.30,77.30,12599.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','203536',3958452,'2601','388',222596.71,222707.74,111.03,18097.89,0.00,0.00,0.00,0.00,0.00),('1','171','879','203536',3958453,'2602','388',231047.59,231308.99,261.40,42608.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','203536',3958454,'2603','388',141741.76,141887.95,146.19,23828.97,0.00,0.00,0.00,0.00,0.00),('1','171','879','203536',3958455,'2604','388',190365.95,190365.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203536',3958456,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203536',3958457,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203635',3960391,'2593','388',253611.31,254341.73,730.42,119058.46,0.00,0.00,0.00,0.00,0.00),('1','171','877','203635',3960392,'2594','388',255684.98,256882.04,1197.06,195120.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','203635',3960393,'2595','388',202396.36,202396.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203635',3960394,'2596','388',272574.47,273419.10,844.63,137674.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','203635',3960395,'2597','388',206614.88,206614.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203635',3960396,'2598','388',224349.03,225117.73,768.70,125298.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','203635',3960397,'2599','388',164215.23,164739.46,524.23,85449.49,0.00,0.00,0.00,0.00,0.00),('1','171','878','203635',3960398,'2600','388',186327.30,186327.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203635',3960399,'2601','388',222707.74,222707.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203635',3960400,'2602','388',231308.99,231967.37,658.38,107315.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','203635',3960401,'2603','388',141887.95,141887.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203635',3960402,'2604','388',190365.95,190676.69,310.74,50650.62,0.00,0.00,0.00,0.00,0.00),('1','171','932','203635',3960403,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203635',3960404,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203757',3962379,'2593','388',254341.73,255230.47,888.74,144864.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','203757',3962380,'2594','388',256882.04,257744.71,862.67,140615.21,0.00,0.00,0.00,0.00,0.00),('1','171','877','203757',3962381,'2595','388',202396.36,202396.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203757',3962382,'2596','388',273419.10,274562.90,1143.80,186439.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','203757',3962383,'2597','388',206614.88,207491.41,876.53,142874.39,0.00,0.00,0.00,0.00,0.00),('1','171','878','203757',3962384,'2598','388',225117.73,225117.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203757',3962385,'2599','388',164739.46,164739.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203757',3962386,'2600','388',186327.30,186759.68,432.38,70477.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','203757',3962387,'2601','388',222707.74,223092.48,384.74,62712.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','203757',3962388,'2602','388',231967.37,231967.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203757',3962389,'2603','388',141887.95,142146.52,258.57,42146.91,0.00,0.00,0.00,0.00,0.00),('1','171','879','203757',3962390,'2604','388',190676.69,190676.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203757',3962391,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203757',3962392,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203857',3964199,'2593','388',255230.47,255665.76,435.29,70952.27,0.00,0.00,0.00,0.00,0.00),('1','171','877','203857',3964200,'2594','388',257744.71,259241.37,1485.62,242156.06,0.00,0.00,11.04,0.00,0.00),('1','171','877','203857',3964201,'2595','388',202396.36,202396.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','203857',3964202,'2596','388',274562.90,275556.35,993.45,161932.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','203857',3964203,'2597','388',207491.41,208717.56,1226.15,199862.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','203857',3964204,'2598','388',225117.73,225117.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203857',3964205,'2599','388',164739.46,164739.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','203857',3964206,'2600','388',186759.68,187341.81,582.13,94887.19,0.00,0.00,0.00,0.00,0.00),('1','171','879','203857',3964207,'2601','388',223092.48,223092.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','203857',3964208,'2602','388',231967.37,232435.60,468.23,76321.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','203857',3964209,'2603','388',142146.52,142311.54,165.02,26898.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','203857',3964210,'2604','388',190676.69,190676.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203857',3964211,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','203857',3964212,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204013',3966826,'2593','388',255665.76,256792.44,1126.68,183648.84,0.00,0.00,0.00,0.00,0.00),('1','171','877','204013',3966827,'2594','388',259241.37,260504.20,1262.83,205841.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','204013',3966828,'2595','388',202396.36,203682.13,1285.77,209580.51,0.00,0.00,0.00,0.00,0.00),('1','171','877','204013',3966829,'2596','388',275556.35,275556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204013',3966830,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204013',3966831,'2598','388',225117.73,226298.62,1180.89,192485.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','204013',3966832,'2599','388',164739.46,165309.62,570.16,92936.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','204013',3966833,'2600','388',187341.81,187341.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204013',3966834,'2601','388',223092.48,223092.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204013',3966835,'2602','388',232435.60,233355.84,920.24,149999.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','204013',3966836,'2603','388',142311.54,142311.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204013',3966837,'2604','388',190676.69,191230.96,554.27,90346.01,0.00,0.00,0.00,0.00,0.00),('1','171','932','204013',3966838,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204013',3966839,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204089',3968388,'2593','388',256792.44,257843.99,1051.55,171402.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','204089',3968389,'2594','388',260504.20,260504.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204089',3968390,'2595','388',203682.13,203682.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204089',3968391,'2596','388',275556.35,277412.76,1856.41,302594.83,0.00,0.00,0.00,0.00,0.00),('1','171','878','204089',3968392,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204089',3968393,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204089',3968394,'2599','388',165309.62,165309.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204089',3968395,'2600','388',187341.81,188445.99,1104.18,179981.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','204089',3968396,'2601','388',223092.48,223723.91,631.43,102923.09,0.00,0.00,0.00,0.00,0.00),('1','171','879','204089',3968397,'2602','388',233355.84,233768.34,412.50,67237.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','204089',3968398,'2603','388',142311.54,142311.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204089',3968399,'2604','388',191230.96,191897.58,666.62,108659.06,0.00,0.00,0.00,0.00,0.00),('1','171','932','204089',3968400,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204089',3968401,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204213',3970550,'2593','388',257843.99,258547.55,703.56,114680.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','204213',3970551,'2594','388',260504.20,260504.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204213',3970552,'2595','388',203682.13,205480.78,1798.65,293179.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','204213',3970553,'2596','388',277412.76,277412.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204213',3970554,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204213',3970555,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204213',3970556,'2599','388',165309.62,166669.66,1360.04,221686.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','204213',3970557,'2600','388',188445.99,188445.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204213',3970558,'2601','388',223723.91,224688.78,964.87,157273.81,0.00,0.00,0.00,0.00,0.00),('1','171','879','204213',3970559,'2602','388',233768.34,234699.02,930.68,151700.84,0.00,0.00,0.00,0.00,0.00),('1','171','879','204213',3970560,'2603','388',142311.54,142783.65,472.11,76953.93,0.00,0.00,0.00,0.00,0.00),('1','171','879','204213',3970561,'2604','388',191897.58,192651.73,754.15,122926.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','204213',3970562,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204213',3970563,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204312',3972410,'2593','388',258547.55,259048.87,501.32,81715.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','204312',3972411,'2594','388',260504.20,260504.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204312',3972412,'2595','388',205480.78,205480.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204312',3972413,'2596','388',277412.76,278639.85,1227.09,200015.67,0.00,0.00,0.00,0.00,0.00),('1','171','878','204312',3972414,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204312',3972415,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204312',3972416,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204312',3972417,'2600','388',188445.99,189159.69,713.70,116333.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','204312',3972418,'2601','388',224688.78,225516.16,827.38,134862.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','204312',3972419,'2602','388',234699.02,235863.44,1164.42,189800.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','204312',3972420,'2603','388',142783.65,143180.76,397.11,64728.93,0.00,0.00,0.00,0.00,0.00),('1','171','879','204312',3972421,'2604','388',192651.73,193437.54,785.81,128087.03,0.00,0.00,0.00,0.00,0.00),('1','171','932','204312',3972422,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204312',3972423,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204426',3974365,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204426',3974366,'2594','388',260504.20,262149.06,1634.86,266482.18,0.00,0.00,10.00,0.00,0.00),('1','171','877','204426',3974367,'2595','388',205480.78,205788.40,307.62,50142.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','204426',3974368,'2596','388',278639.85,280423.16,1783.31,290679.53,0.00,0.00,0.00,0.00,0.00),('1','171','878','204426',3974369,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204426',3974370,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204426',3974371,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204426',3974372,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204426',3974373,'2601','388',225516.16,226677.29,1141.13,186004.19,0.00,0.00,20.00,0.00,0.00),('1','171','879','204426',3974374,'2602','388',235863.44,236905.36,1041.92,169832.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','204426',3974375,'2603','388',143180.76,144035.29,854.53,139288.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','204426',3974376,'2604','388',193437.54,194319.43,881.89,143748.07,0.00,0.00,0.00,0.00,0.00),('1','171','932','204426',3974377,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204426',3974378,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204525',3976256,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204525',3976257,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204525',3976258,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204525',3976259,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204525',3976260,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204525',3976261,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204525',3976262,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204525',3976263,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204525',3976264,'2601','388',226677.29,227635.10,957.81,156123.03,0.00,0.00,0.00,0.00,0.00),('1','171','879','204525',3976265,'2602','388',236905.36,238175.22,1269.86,206987.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','204525',3976266,'2603','388',144035.29,144917.99,882.70,143880.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','204525',3976267,'2604','388',194319.43,195750.19,1430.76,233213.88,0.00,0.00,0.00,0.00,0.00),('1','171','932','204525',3976268,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204525',3976269,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204649',3978366,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204649',3978367,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204649',3978368,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204649',3978369,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204649',3978370,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204649',3978371,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204649',3978372,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204649',3978373,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204649',3978374,'2601','388',227635.10,230170.78,2535.68,413315.84,0.00,0.00,0.00,0.00,0.00),('1','171','879','204649',3978375,'2602','388',238175.22,239830.22,1655.00,269765.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204649',3978376,'2603','388',144917.99,146326.87,1408.88,229647.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','204649',3978377,'2604','388',195750.19,197009.79,1259.60,205314.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','204649',3978378,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204649',3978379,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204734',3980096,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204734',3980097,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204734',3980098,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204734',3980099,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204734',3980100,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204734',3980101,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204734',3980102,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204734',3980103,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204734',3980104,'2601','388',230170.78,231968.01,1797.23,292948.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','204734',3980105,'2602','388',239830.22,240938.72,1108.50,180685.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','204734',3980106,'2603','388',146326.87,148224.92,1898.05,309382.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','204734',3980107,'2604','388',197009.79,198137.27,1127.48,183779.24,0.00,0.00,0.00,0.00,0.00),('1','171','932','204734',3980108,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204734',3980109,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204863',3981893,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204863',3981894,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204863',3981895,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204863',3981896,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204863',3981897,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204863',3981898,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204863',3981899,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204863',3981900,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204863',3981901,'2601','388',231968.01,232743.68,775.67,126434.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','204863',3981902,'2602','388',240938.72,243104.88,2166.16,353084.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','204863',3981903,'2603','388',148224.92,149640.16,1415.24,230684.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','204863',3981904,'2604','388',198137.27,199327.61,1190.34,194025.42,0.00,0.00,0.00,0.00,0.00),('1','171','932','204863',3981905,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204863',3981906,'2741','412',324420.69,324420.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204954',3983506,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204954',3983507,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204954',3983508,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','204954',3983509,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204954',3983510,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204954',3983511,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204954',3983512,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','204954',3983513,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204954',3983514,'2601','388',232743.68,232743.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204954',3983515,'2602','388',243104.88,243104.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204954',3983516,'2603','388',149640.16,149640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','204954',3983517,'2604','388',199327.61,199327.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204954',3983518,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','204954',3983519,'2741','412',324420.69,324952.90,532.21,143696.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','205066',3985463,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205066',3985464,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205066',3985465,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205066',3985466,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205066',3985467,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205066',3985468,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205066',3985469,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205066',3985470,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205066',3985471,'2601','388',232743.68,232743.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205066',3985472,'2602','388',243104.88,243104.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205066',3985473,'2603','388',149640.16,149640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205066',3985474,'2604','388',199327.61,199327.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205066',3985475,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205066',3985476,'2741','412',324952.90,325312.32,359.42,97043.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','205131',3986860,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205131',3986861,'2594','388',262149.06,262149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205131',3986862,'2595','388',205788.40,205788.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205131',3986863,'2596','388',280423.16,280423.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205131',3986864,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205131',3986865,'2598','388',226298.62,226298.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205131',3986866,'2599','388',166669.66,166669.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205131',3986867,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205131',3986868,'2601','388',232743.68,232743.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205131',3986869,'2602','388',243104.88,243104.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205131',3986870,'2603','388',149640.16,149640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205131',3986871,'2604','388',199327.61,199327.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205131',3986872,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205131',3986873,'2741','412',325312.32,325511.76,199.44,53848.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','205307',3989899,'2593','388',259048.87,259048.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205307',3989900,'2594','388',262149.06,263166.14,1017.08,165784.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','205307',3989901,'2595','388',205788.40,206275.10,486.70,79332.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','205307',3989902,'2596','388',280423.16,280956.70,533.54,86967.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','205307',3989903,'2597','388',208717.56,208717.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205307',3989904,'2598','388',226298.62,226804.40,505.78,82442.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','205307',3989905,'2599','388',166669.66,167217.24,547.58,89255.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','205307',3989906,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205307',3989907,'2601','388',232743.68,233622.15,878.47,143190.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','205307',3989908,'2602','388',243104.88,243194.78,89.90,14653.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','205307',3989909,'2603','388',149640.16,149640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205307',3989910,'2604','388',199327.61,199444.30,116.69,19020.47,0.00,0.00,0.00,0.00,0.00),('1','171','932','205307',3989911,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205307',3989912,'2741','412',325511.76,326625.83,1114.07,300798.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','205352',3990786,'2593','388',259048.87,259685.42,636.55,103757.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','205352',3990787,'2594','388',263166.14,263166.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205352',3990788,'2595','388',206275.10,206719.40,444.30,72420.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','205352',3990789,'2596','388',280956.70,281030.92,60.72,9897.36,0.00,0.00,13.50,0.00,0.00),('1','171','878','205352',3990790,'2597','388',208717.56,210146.60,1429.04,232933.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','205352',3990791,'2598','388',226804.40,226804.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205352',3990792,'2599','388',167217.24,168436.38,1219.14,198719.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','205352',3990793,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205352',3990794,'2601','388',233622.15,233967.62,345.47,56311.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','205352',3990795,'2602','388',243194.78,243481.47,286.69,46730.47,0.00,0.00,0.00,0.00,0.00),('1','171','879','205352',3990796,'2603','388',149640.16,149835.86,195.70,31899.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','205352',3990797,'2604','388',199444.30,199999.32,555.02,90468.26,0.00,0.00,0.00,0.00,0.00),('1','171','932','205352',3990798,'2740','412',64313.47,64313.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205352',3990799,'2741','412',326625.83,327259.80,633.97,171171.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','205425',3992300,'2593','388',259685.42,259685.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205425',3992301,'2594','388',263166.14,263166.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205425',3992302,'2595','388',206719.40,206719.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205425',3992303,'2596','388',281030.92,281030.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205425',3992304,'2597','388',210146.60,210146.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205425',3992305,'2598','388',226804.40,226804.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205425',3992306,'2599','388',168436.38,168436.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205425',3992307,'2600','388',189159.69,189159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205425',3992308,'2601','388',233967.62,233967.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205425',3992309,'2602','388',243481.47,243481.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205425',3992310,'2603','388',149835.86,149835.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205425',3992311,'2604','388',199999.32,199999.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205425',3992312,'2740','412',64313.47,67170.01,2856.54,771265.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','205425',3992313,'2741','412',327259.80,327890.43,630.63,170270.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','205502',3993387,'2593','388',259685.42,259685.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205502',3993388,'2594','388',263166.14,265027.90,1861.76,303466.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','205502',3993389,'2595','388',206719.40,207693.49,974.09,158776.67,0.00,0.00,0.00,0.00,0.00),('1','171','877','205502',3993390,'2596','388',281030.92,281041.35,10.43,1700.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','205502',3993391,'2597','388',210146.60,210146.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205502',3993392,'2598','388',226804.40,228180.89,1376.49,224367.87,0.00,0.00,0.00,0.00,0.00),('1','171','878','205502',3993393,'2599','388',168436.38,168436.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205502',3993394,'2600','388',189159.69,189747.19,587.50,95762.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','205502',3993395,'2601','388',233967.62,233967.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205502',3993396,'2602','388',243481.47,245191.20,1709.73,278685.99,0.00,0.00,0.00,0.00,0.00),('1','171','879','205502',3993397,'2603','388',149835.86,149835.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205502',3993398,'2604','388',199999.32,200425.06,425.74,69395.62,0.00,0.00,0.00,0.00,0.00),('1','171','932','205502',3993399,'2740','412',67170.01,67170.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205502',3993400,'2741','412',327890.43,328581.11,690.68,193390.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','205608',3995520,'2593','388',259685.42,261076.73,1391.31,226783.53,0.00,0.00,0.00,0.00,0.00),('1','171','877','205608',3995521,'2594','388',265027.90,265027.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205608',3995522,'2595','388',207693.49,207693.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205608',3995523,'2596','388',281041.35,281530.58,489.23,79744.49,0.00,0.00,0.00,0.00,0.00),('1','171','878','205608',3995524,'2597','388',210146.60,210146.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205608',3995525,'2598','388',228180.89,229144.22,963.33,157022.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','205608',3995526,'2599','388',168436.38,168436.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205608',3995527,'2600','388',189747.19,190362.55,615.36,100303.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','205608',3995528,'2601','388',233967.62,233967.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205608',3995529,'2602','388',245191.20,245934.92,743.72,121226.36,0.00,0.00,0.00,0.00,0.00),('1','171','879','205608',3995530,'2603','388',149835.86,150258.53,422.67,68895.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','205608',3995531,'2604','388',200425.06,200425.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205608',3995532,'2740','412',67170.01,67859.66,689.65,193102.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205608',3995533,'2741','412',328581.11,329194.70,613.59,171805.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','205697',3997336,'2593','388',261076.73,261076.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205697',3997337,'2594','388',265027.90,266474.96,1447.06,235870.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','205697',3997338,'2595','388',207693.49,208837.94,1144.45,186545.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','205697',3997339,'2596','388',281530.58,282401.75,871.17,142000.71,0.00,0.00,0.00,0.00,0.00),('1','171','878','205697',3997340,'2597','388',210146.60,211027.73,881.13,143624.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','205697',3997341,'2598','388',229144.22,229144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205697',3997342,'2599','388',168436.38,169289.71,853.33,139092.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','205697',3997343,'2600','388',190362.55,190362.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205697',3997344,'2601','388',233967.62,234526.61,558.99,91115.37,0.00,0.00,0.00,0.00,0.00),('1','171','879','205697',3997345,'2602','388',245934.92,245934.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205697',3997346,'2603','388',150258.53,150258.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205697',3997347,'2604','388',200425.06,200840.08,415.02,67648.26,0.00,0.00,0.00,0.00,0.00),('1','171','932','205697',3997348,'2740','412',67859.66,67859.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205697',3997349,'2741','412',329194.70,329488.65,293.95,82306.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205772',3998347,'2593','388',261076.73,261076.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205772',3998348,'2594','388',266474.96,267751.26,1276.30,208036.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','205772',3998349,'2595','388',208837.94,208929.31,91.37,14893.31,0.00,0.00,0.00,0.00,0.00),('1','171','877','205772',3998350,'2596','388',282401.75,282401.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205772',3998351,'2597','388',211027.73,211027.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205772',3998352,'2598','388',229144.22,230423.41,1279.19,208507.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','205772',3998353,'2599','388',169289.71,169289.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','205772',3998354,'2600','388',190362.55,191531.25,1168.70,190498.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','205772',3998355,'2601','388',234526.61,234975.59,448.98,73183.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','205772',3998356,'2602','388',245934.92,245934.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205772',3998357,'2603','388',150258.53,150308.10,49.57,8079.91,0.00,0.00,0.00,0.00,0.00),('1','171','879','205772',3998358,'2604','388',200840.08,200843.15,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','171','932','205772',3998359,'2740','412',67859.66,67859.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205772',3998360,'2741','412',329488.65,330431.94,943.29,264121.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','205905',4000908,'2593','388',261076.73,262492.77,1416.04,230814.52,0.00,0.00,0.00,0.00,0.00),('1','171','877','205905',4000909,'2594','388',267751.26,267751.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205905',4000910,'2595','388',208929.31,208929.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','205905',4000911,'2596','388',282401.75,283730.27,1328.52,216548.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','205905',4000912,'2597','388',211027.73,211877.87,850.14,138572.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','205905',4000913,'2598','388',230423.41,231124.15,700.74,114220.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','205905',4000914,'2599','388',169289.71,169945.92,656.21,106962.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','205905',4000915,'2600','388',191531.25,191718.62,187.37,30541.31,0.00,0.00,0.00,0.00,0.00),('1','171','879','205905',4000916,'2601','388',234975.59,235922.89,947.30,154409.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','205905',4000917,'2602','388',245934.92,246125.28,190.36,31028.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','205905',4000918,'2603','388',150308.10,150308.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','205905',4000919,'2604','388',200843.15,200958.23,115.08,18758.04,0.00,0.00,0.00,0.00,0.00),('1','171','932','205905',4000920,'2740','412',67859.66,67859.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','205905',4000921,'2741','412',330431.94,331516.78,1084.84,303755.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','206067',4003730,'2593','388',262492.77,262492.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206067',4003731,'2594','388',267751.26,268876.77,1125.51,183458.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','206067',4003732,'2595','388',208929.31,208929.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206067',4003733,'2596','388',283730.27,283730.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206067',4003734,'2597','388',211877.87,211877.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206067',4003735,'2598','388',231124.15,231294.99,170.84,27846.92,0.00,0.00,0.00,0.00,0.00),('1','171','878','206067',4003736,'2599','388',169945.92,169945.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206067',4003737,'2600','388',191718.62,192955.79,1237.17,201658.71,0.00,0.00,0.00,0.00,0.00),('1','171','879','206067',4003738,'2601','388',235922.89,235922.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206067',4003739,'2602','388',246125.28,247604.95,1479.67,241186.21,0.00,0.00,0.00,0.00,0.00),('1','171','879','206067',4003740,'2603','388',150308.10,150308.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206067',4003741,'2604','388',200958.23,201675.00,716.77,116833.51,0.00,0.00,0.00,0.00,0.00),('1','171','932','206067',4003742,'2740','412',67859.66,68528.53,668.87,187283.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','206067',4003743,'2741','412',331516.78,331897.13,380.35,106498.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206139',4005118,'2593','388',262492.77,263783.63,1290.86,210410.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','206139',4005119,'2594','388',268876.77,270979.47,2102.70,342740.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','206139',4005120,'2595','388',208929.31,210368.87,1439.56,234648.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','206139',4005121,'2596','388',283730.27,283730.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206139',4005122,'2597','388',211877.87,213482.04,1604.17,261479.71,0.00,0.00,0.00,0.00,0.00),('1','171','878','206139',4005123,'2598','388',231294.99,231325.67,30.68,5000.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','206139',4005124,'2599','388',169945.92,171124.89,1178.97,192172.11,0.00,0.00,0.00,0.00,0.00),('1','171','878','206139',4005125,'2600','388',192955.79,192955.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206139',4005126,'2601','388',235922.89,235922.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206139',4005127,'2602','388',247604.95,247608.02,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','171','879','206139',4005128,'2603','388',150308.10,150326.50,18.40,2999.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','206139',4005129,'2604','388',201675.00,201675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206139',4005130,'2740','412',68528.53,68528.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206139',4005131,'2741','412',331897.13,332728.12,830.99,232677.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','206274',4007344,'2593','388',263783.63,263783.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206274',4007345,'2594','388',270979.47,271506.05,526.58,85832.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','206274',4007346,'2595','388',210368.87,211042.38,673.51,109782.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','206274',4007347,'2596','388',283730.27,283730.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206274',4007348,'2597','388',213482.04,213482.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206274',4007349,'2598','388',231325.67,232420.57,1094.90,178468.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','206274',4007350,'2599','388',171124.89,171124.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206274',4007351,'2600','388',192955.79,194654.54,1698.75,276896.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','206274',4007352,'2601','388',235922.89,236682.27,739.38,120518.94,0.00,0.00,20.00,0.00,0.00),('1','171','879','206274',4007353,'2602','388',247608.02,247608.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206274',4007354,'2603','388',150326.50,150920.88,581.25,94743.75,0.00,0.00,13.13,0.00,0.00),('1','171','879','206274',4007355,'2604','388',201675.00,201675.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206274',4007356,'2740','412',68528.53,68578.53,50.00,14000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206274',4007357,'2741','412',332728.12,334028.13,1300.01,364002.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','206383',4009121,'2593','388',263783.63,264570.57,786.94,128271.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','206383',4009122,'2594','388',271506.05,273081.18,1575.13,256746.19,0.00,0.00,0.00,0.00,0.00),('1','171','877','206383',4009123,'2595','388',211042.38,212484.56,1442.18,235075.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','206383',4009124,'2596','388',283730.27,284491.55,761.28,124088.64,0.00,0.00,0.00,0.00,0.00),('1','171','878','206383',4009125,'2597','388',213482.04,213904.12,422.08,68799.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','206383',4009126,'2598','388',232420.57,233529.77,1109.20,180799.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','206383',4009127,'2599','388',171124.89,171421.71,296.82,48381.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','206383',4009128,'2600','388',194654.54,194654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206383',4009129,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206383',4009130,'2602','388',247608.02,248051.81,443.79,72337.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','206383',4009131,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206383',4009132,'2604','388',201675.00,202153.45,478.45,77987.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','206383',4009133,'2740','412',68578.53,68980.38,401.85,112518.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206383',4009134,'2741','412',334028.13,334765.16,737.03,206368.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','206485',4010989,'2593','388',264570.57,265626.10,1055.53,172051.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','206485',4010990,'2594','388',273081.18,274352.76,1271.58,207267.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','206485',4010991,'2595','388',212484.56,213699.33,1214.77,198007.51,0.00,0.00,0.00,0.00,0.00),('1','171','877','206485',4010992,'2596','388',284491.55,285122.20,630.65,102795.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','206485',4010993,'2597','388',213904.12,213904.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206485',4010994,'2598','388',233529.77,233529.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206485',4010995,'2599','388',171421.71,171421.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206485',4010996,'2600','388',194654.54,194654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206485',4010997,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206485',4010998,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206485',4010999,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206485',4011000,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206485',4011001,'2740','412',68980.38,69017.17,36.79,10301.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','206485',4011002,'2741','412',334765.16,335552.17,787.01,220362.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','206591',4012770,'2593','388',265626.10,265626.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206591',4012771,'2594','388',274352.76,276188.00,1835.24,299144.12,0.00,0.00,0.00,0.00,0.00),('1','171','877','206591',4012772,'2595','388',213699.33,215107.17,1407.84,229477.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','206591',4012773,'2596','388',285122.20,285122.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206591',4012774,'2597','388',213904.12,214826.48,922.36,150344.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','206591',4012775,'2598','388',233529.77,234443.11,913.34,148874.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','206591',4012776,'2599','388',171421.71,172196.74,775.03,126329.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','206591',4012777,'2600','388',194654.54,195121.74,467.20,76153.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','206591',4012778,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206591',4012779,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206591',4012780,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206591',4012781,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206591',4012782,'2740','412',69017.17,69033.24,16.07,4499.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','206591',4012783,'2741','412',335552.17,336216.41,664.24,185987.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','206600',4012958,'2593','388',265626.10,265626.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206600',4012959,'2594','388',276188.00,277936.36,1748.36,284982.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','206600',4012960,'2595','388',215107.17,216080.64,973.47,158675.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','206600',4012961,'2596','388',285122.20,285134.47,12.27,2000.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','206600',4012962,'2597','388',214826.48,214826.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206600',4012963,'2598','388',234443.11,235458.37,1015.26,165487.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','206600',4012964,'2599','388',172196.74,172924.37,727.63,118603.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','206600',4012965,'2600','388',195121.74,195735.20,613.46,99993.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','206600',4012966,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206600',4012967,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206600',4012968,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206600',4012969,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206600',4012970,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206600',4012971,'2741','412',336216.41,336950.16,733.75,205450.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206817',4016760,'2593','388',265626.10,266913.43,1287.33,209834.79,0.00,0.00,0.00,0.00,0.00),('1','171','877','206817',4016761,'2594','388',277936.36,277936.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206817',4016762,'2595','388',216080.64,217680.17,1599.53,260723.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','206817',4016763,'2596','388',285134.47,285172.19,37.72,6148.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','206817',4016764,'2597','388',214826.48,215794.52,968.04,157790.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','206817',4016765,'2598','388',235458.37,236653.50,1195.13,194806.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','206817',4016766,'2599','388',172924.37,172924.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206817',4016767,'2600','388',195735.20,196780.16,1044.96,170328.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','206817',4016768,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206817',4016769,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206817',4016770,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206817',4016771,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206817',4016772,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206817',4016773,'2741','412',336950.16,337282.31,332.15,93002.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206940',4019135,'2593','388',266913.43,266913.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','206940',4019136,'2594','388',277936.36,278281.82,345.46,56309.98,0.00,0.00,0.00,0.00,0.00),('1','171','877','206940',4019137,'2595','388',217680.17,218765.98,1085.81,176987.03,0.00,0.00,0.00,0.00,0.00),('1','171','877','206940',4019138,'2596','388',285172.19,285172.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','206940',4019139,'2597','388',215794.52,216483.15,688.63,112246.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','206940',4019140,'2598','388',236653.50,237748.59,1095.09,178499.67,0.00,0.00,0.00,0.00,0.00),('1','171','878','206940',4019141,'2599','388',172924.37,173348.92,424.55,69201.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','206940',4019142,'2600','388',196780.16,197555.42,764.21,124566.23,0.00,0.00,11.05,0.00,0.00),('1','171','879','206940',4019143,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206940',4019144,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206940',4019145,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','206940',4019146,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206940',4019147,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','206940',4019148,'2741','412',337282.31,338486.33,1204.02,337125.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','207030',4020700,'2593','388',266913.43,267150.60,237.17,38658.71,0.00,0.00,0.00,0.00,0.00),('1','171','877','207030',4020701,'2594','388',278281.82,280623.99,2342.17,381773.71,0.00,0.00,0.00,0.00,0.00),('1','171','877','207030',4020702,'2595','388',218765.98,220300.92,1534.94,250195.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','207030',4020703,'2596','388',285172.19,285409.62,237.43,38701.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','207030',4020704,'2597','388',216483.15,217484.53,1001.38,163224.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','207030',4020705,'2598','388',237748.59,238481.35,732.76,119439.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','207030',4020706,'2599','388',173348.92,173895.44,546.52,89082.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','207030',4020707,'2600','388',197555.42,198257.97,702.55,114515.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','207030',4020708,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207030',4020709,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207030',4020710,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207030',4020711,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207030',4020712,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207030',4020713,'2741','412',338486.33,338971.36,485.03,135808.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','207151',4022766,'2593','388',267150.60,268456.39,1305.79,212843.77,0.00,0.00,0.00,0.00,0.00),('1','171','877','207151',4022767,'2594','388',280623.99,280623.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207151',4022768,'2595','388',220300.92,220300.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207151',4022769,'2596','388',285409.62,285650.42,240.80,39250.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','207151',4022770,'2597','388',217484.53,218388.09,903.56,147280.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','207151',4022771,'2598','388',238481.35,239329.20,847.85,138199.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','207151',4022772,'2599','388',173895.44,174346.05,450.61,73449.43,0.00,0.00,0.00,0.00,0.00),('1','171','878','207151',4022773,'2600','388',198257.97,198810.47,552.50,90057.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','207151',4022774,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207151',4022775,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207151',4022776,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207151',4022777,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207151',4022778,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207151',4022779,'2741','412',338971.36,339590.91,619.55,173474.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207158',4022917,'2593','388',268456.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207158',4022918,'2594','388',280623.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207158',4022919,'2595','388',220300.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207158',4022920,'2596','388',285650.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207158',4022921,'2597','388',218388.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207158',4022922,'2598','388',239329.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207158',4022923,'2599','388',174346.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207158',4022924,'2600','388',198810.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207158',4022925,'2601','388',236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207158',4022926,'2602','388',248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207158',4022927,'2603','388',150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207158',4022928,'2604','388',202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207158',4022929,'2740','412',69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207158',4022930,'2741','412',339590.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207243',4024668,'2593','388',268456.39,268456.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207243',4024669,'2594','388',280623.99,281869.75,1245.76,203058.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','207243',4024670,'2595','388',220300.92,222469.39,2168.47,353460.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','207243',4024671,'2596','388',285650.42,286705.22,1034.80,168672.40,0.00,0.00,20.00,0.00,0.00),('1','171','878','207243',4024672,'2597','388',218388.09,218981.16,593.07,96670.41,0.00,0.00,0.00,0.00,0.00),('1','171','878','207243',4024673,'2598','388',239329.20,240263.28,934.08,152255.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','207243',4024674,'2599','388',174346.05,174890.19,544.14,88694.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','207243',4024675,'2600','388',198810.47,199383.24,572.77,93361.51,0.00,0.00,0.00,0.00,0.00),('1','171','879','207243',4024676,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207243',4024677,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207243',4024678,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207243',4024679,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207243',4024680,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207243',4024681,'2741','412',339590.91,339590.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207379',4026845,'2593','388',268456.39,269343.04,886.65,144523.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','207379',4026846,'2594','388',281869.75,282564.14,694.39,113185.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','207379',4026847,'2595','388',222469.39,223470.48,1001.09,163177.67,0.00,0.00,0.00,0.00,0.00),('1','171','877','207379',4026848,'2596','388',286705.22,286832.91,127.69,20813.47,0.00,0.00,0.00,0.00,0.00),('1','171','878','207379',4026849,'2597','388',218981.16,219657.41,676.25,110228.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','207379',4026850,'2598','388',240263.28,240684.30,421.02,68626.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','207379',4026851,'2599','388',174890.19,175269.09,378.90,61760.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','207379',4026852,'2600','388',199383.24,199835.05,451.81,73645.03,0.00,0.00,0.00,0.00,0.00),('1','171','879','207379',4026853,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207379',4026854,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207379',4026855,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207379',4026856,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207379',4026857,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207379',4026858,'2741','412',339590.91,339590.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207496',4028975,'2593','388',269343.04,269363.91,20.87,3401.81,0.00,0.00,0.00,0.00,0.00),('1','171','877','207496',4028976,'2594','388',282564.14,282782.22,218.08,35547.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','207496',4028977,'2595','388',223470.48,223485.82,15.34,2500.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','207496',4028978,'2596','388',286832.91,286851.63,18.72,3051.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','207496',4028979,'2597','388',219657.41,221314.87,1657.46,270165.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','207496',4028980,'2598','388',240684.30,242810.03,2125.73,346493.99,0.00,0.00,0.00,0.00,0.00),('1','171','878','207496',4028981,'2599','388',175269.09,176853.49,1584.40,258257.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','207496',4028982,'2600','388',199835.05,201352.05,1517.00,247271.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207496',4028983,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207496',4028984,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207496',4028985,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207496',4028986,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207496',4028987,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207496',4028988,'2741','412',339590.91,339590.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207600',4030862,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207600',4030863,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207600',4030864,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207600',4030865,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207600',4030866,'2597','388',221314.87,222602.99,1288.12,209963.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','207600',4030867,'2598','388',242810.03,243546.67,736.64,120072.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','207600',4030868,'2599','388',176853.49,177828.39,974.90,158908.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','207600',4030869,'2600','388',201352.05,202730.85,1378.80,224744.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','207600',4030870,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207600',4030871,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207600',4030872,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207600',4030873,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207600',4030874,'2740','412',69033.24,69033.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207600',4030875,'2741','412',339590.91,339590.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207730',4032904,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207730',4032905,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207730',4032906,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207730',4032907,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207730',4032908,'2597','388',222602.99,223823.25,1220.26,198902.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','207730',4032909,'2598','388',243546.67,246455.39,2908.72,474121.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','207730',4032910,'2599','388',177828.39,179312.24,1483.85,241867.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','207730',4032911,'2600','388',202730.85,204285.72,1554.87,253443.81,0.00,0.00,0.00,0.00,0.00),('1','171','879','207730',4032912,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207730',4032913,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207730',4032914,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207730',4032915,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207730',4032916,'2740','412',69033.24,69063.24,30.00,8550.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207730',4032917,'2741','412',339590.91,340000.91,410.00,116850.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207816',4034465,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207816',4034466,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207816',4034467,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207816',4034468,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207816',4034469,'2597','388',223823.25,225109.87,1286.62,209719.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','207816',4034470,'2598','388',246455.39,247432.14,976.75,159210.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','207816',4034471,'2599','388',179312.24,180133.14,820.90,133806.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','207816',4034472,'2600','388',204285.72,205476.57,1190.85,194108.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','207816',4034473,'2601','388',236682.27,236682.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207816',4034474,'2602','388',248051.81,248051.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207816',4034475,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207816',4034476,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207816',4034477,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207816',4034478,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207930',4036354,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207930',4036355,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207930',4036356,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','207930',4036357,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','207930',4036358,'2597','388',225109.87,225491.73,381.86,62243.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','207930',4036359,'2598','388',247432.14,250016.15,2584.01,421193.63,0.00,0.00,0.00,0.00,0.00),('1','171','878','207930',4036360,'2599','388',180133.14,182514.89,2381.75,388225.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','207930',4036361,'2600','388',205476.57,206656.53,1179.96,192333.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','207930',4036362,'2601','388',236682.27,237374.85,692.58,112890.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','207930',4036363,'2602','388',248051.81,248807.41,755.60,123162.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','207930',4036364,'2603','388',150920.88,150920.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','207930',4036365,'2604','388',202153.45,202153.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207930',4036366,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','207930',4036367,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208037',4038244,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208037',4038245,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208037',4038246,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208037',4038247,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208037',4038248,'2597','388',225491.73,225767.12,275.39,44888.57,0.00,0.00,0.00,0.00,0.00),('1','171','878','208037',4038249,'2598','388',250016.15,250370.05,353.90,57685.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','208037',4038250,'2599','388',182514.89,183506.14,991.25,161573.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','208037',4038251,'2600','388',206656.53,207108.58,452.05,73684.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','208037',4038252,'2601','388',237374.85,238373.76,998.91,162822.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','208037',4038253,'2602','388',248807.41,249642.27,834.86,136082.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','208037',4038254,'2603','388',150920.88,151328.82,407.94,66494.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','208037',4038255,'2604','388',202153.45,202581.20,427.75,69723.25,0.00,0.00,0.00,0.00,0.00),('1','171','932','208037',4038256,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208037',4038257,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208124',4039784,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208124',4039785,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208124',4039786,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208124',4039787,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208124',4039788,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208124',4039789,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208124',4039790,'2599','388',183506.14,183506.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208124',4039791,'2600','388',207108.58,209076.81,1968.23,320821.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','208124',4039792,'2601','388',238373.76,239555.52,1181.76,192626.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','208124',4039793,'2602','388',249642.27,250980.50,1338.23,218131.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','208124',4039794,'2603','388',151328.82,152276.43,947.61,154460.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','208124',4039795,'2604','388',202581.20,203475.31,894.11,145739.93,0.00,0.00,0.00,0.00,0.00),('1','171','932','208124',4039796,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208124',4039797,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208238',4041991,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208238',4041992,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208238',4041993,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208238',4041994,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208238',4041995,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208238',4041996,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208238',4041997,'2599','388',183506.14,184134.44,628.30,102412.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','208238',4041998,'2600','388',209076.81,209948.37,871.56,142064.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','208238',4041999,'2601','388',239555.52,240355.89,800.37,130460.31,0.00,0.00,0.00,0.00,0.00),('1','171','879','208238',4042000,'2602','388',250980.50,251776.33,795.83,129720.29,0.00,0.00,0.00,0.00,0.00),('1','171','879','208238',4042001,'2603','388',152276.43,152763.47,487.04,79387.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','208238',4042002,'2604','388',203475.31,204216.82,741.51,120866.13,0.00,0.00,0.00,0.00,0.00),('1','171','932','208238',4042003,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208238',4042004,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208321',4043447,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208321',4043448,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208321',4043449,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208321',4043450,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208321',4043451,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208321',4043452,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208321',4043453,'2599','388',184134.44,184134.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208321',4043454,'2600','388',209948.37,211951.46,2003.09,326503.67,0.00,0.00,0.00,0.00,0.00),('1','171','879','208321',4043455,'2601','388',240355.89,241110.72,754.83,123037.29,0.00,0.00,0.00,0.00,0.00),('1','171','879','208321',4043456,'2602','388',251776.33,252862.65,1086.32,177070.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','208321',4043457,'2603','388',152763.47,153274.35,510.88,83273.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','208321',4043458,'2604','388',204216.82,205171.91,955.09,155679.67,0.00,0.00,0.00,0.00,0.00),('1','171','932','208321',4043459,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208321',4043460,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208459',4045671,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208459',4045672,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208459',4045673,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208459',4045674,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208459',4045675,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208459',4045676,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208459',4045677,'2599','388',184134.44,185604.63,1450.19,236380.97,0.00,0.00,20.00,0.00,0.00),('1','171','878','208459',4045678,'2600','388',211951.46,211951.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208459',4045679,'2601','388',241110.72,241567.87,457.15,74515.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','208459',4045680,'2602','388',252862.65,253730.18,867.53,141407.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','208459',4045681,'2603','388',153274.35,154192.56,918.21,149668.23,0.00,0.00,0.00,0.00,0.00),('1','171','879','208459',4045682,'2604','388',205171.91,206154.53,971.57,158365.91,0.00,0.00,11.05,0.00,0.00),('1','171','932','208459',4045683,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208459',4045684,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208559',4047548,'2593','388',269363.91,269363.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208559',4047549,'2594','388',282782.22,282782.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208559',4047550,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208559',4047551,'2596','388',286851.63,286851.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208559',4047552,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208559',4047553,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208559',4047554,'2599','388',185604.63,185654.33,49.70,8101.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','208559',4047555,'2600','388',211951.46,212012.80,61.34,9998.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','208559',4047556,'2601','388',241567.87,244355.70,2787.83,454416.29,0.00,0.00,0.00,0.00,0.00),('1','171','879','208559',4047557,'2602','388',253730.18,255721.07,1990.89,324515.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','208559',4047558,'2603','388',154192.56,155534.64,1342.08,218759.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','208559',4047559,'2604','388',206154.53,207914.01,1759.48,286795.24,0.00,0.00,0.00,0.00,0.00),('1','171','932','208559',4047560,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208559',4047561,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208672',4049468,'2593','388',269363.91,269627.50,263.59,42965.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','208672',4049469,'2594','388',282782.22,283402.66,620.44,101131.72,0.00,0.00,0.00,0.00,0.00),('1','171','877','208672',4049470,'2595','388',223485.82,223485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208672',4049471,'2596','388',286851.63,287186.61,334.98,54601.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','208672',4049472,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208672',4049473,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208672',4049474,'2599','388',185654.33,185654.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208672',4049475,'2600','388',212012.80,212012.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208672',4049476,'2601','388',244355.70,245174.72,819.02,133500.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','208672',4049477,'2602','388',255721.07,256087.98,366.91,59806.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','208672',4049478,'2603','388',155534.64,156612.89,1078.25,175754.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','208672',4049479,'2604','388',207914.01,208875.00,960.99,156641.37,0.00,0.00,0.00,0.00,0.00),('1','171','932','208672',4049480,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208672',4049481,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208779',4051293,'2593','388',269627.50,270641.52,1014.02,165285.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','208779',4051294,'2594','388',283402.66,284578.03,1175.37,191585.31,0.00,0.00,0.00,0.00,0.00),('1','171','877','208779',4051295,'2595','388',223485.82,224531.54,1045.72,170452.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','208779',4051296,'2596','388',287186.61,287875.26,678.65,110619.95,0.00,0.00,10.00,0.00,0.00),('1','171','878','208779',4051297,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208779',4051298,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208779',4051299,'2599','388',185654.33,185654.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208779',4051300,'2600','388',212012.80,212012.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208779',4051301,'2601','388',245174.72,246325.09,1130.37,184250.31,0.00,0.00,20.00,0.00,0.00),('1','171','879','208779',4051302,'2602','388',256087.98,257133.56,1025.58,167169.54,0.00,0.00,20.00,0.00,0.00),('1','171','879','208779',4051303,'2603','388',156612.89,156653.39,20.50,3341.50,0.00,0.00,20.00,0.00,0.00),('1','171','879','208779',4051304,'2604','388',208875.00,209913.17,1018.17,165961.71,0.00,0.00,20.00,0.00,0.00),('1','171','932','208779',4051305,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208779',4051306,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','208904',4053541,'2593','388',270641.52,271074.94,433.42,70647.46,0.00,0.00,0.00,0.00,0.00),('1','171','877','208904',4053542,'2594','388',284578.03,285746.87,1168.84,190520.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','208904',4053543,'2595','388',224531.54,226140.61,1609.07,262278.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','208904',4053544,'2596','388',287875.26,287875.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208904',4053545,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208904',4053546,'2598','388',250370.05,250370.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208904',4053547,'2599','388',185654.33,185654.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','208904',4053548,'2600','388',212012.80,212012.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208904',4053549,'2601','388',246325.09,247743.24,1418.15,231158.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','208904',4053550,'2602','388',257133.56,257133.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208904',4053551,'2603','388',156653.39,156653.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','208904',4053552,'2604','388',209913.17,210673.55,760.38,123941.94,0.00,0.00,0.00,0.00,0.00),('1','171','932','208904',4053553,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','208904',4053554,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209012',4055259,'2593','388',271074.94,272104.14,1029.20,167759.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','209012',4055260,'2594','388',285746.87,287327.77,1580.90,257686.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','209012',4055261,'2595','388',226140.61,227963.00,1822.39,297049.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','209012',4055262,'2596','388',287875.26,287875.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209012',4055263,'2597','388',225767.12,225767.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209012',4055264,'2598','388',250370.05,251795.77,1425.72,232392.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','209012',4055265,'2599','388',185654.33,185654.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209012',4055266,'2600','388',212012.80,212959.84,947.04,154367.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','209012',4055267,'2601','388',247743.24,247743.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209012',4055268,'2602','388',257133.56,258007.11,873.55,142388.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','209012',4055269,'2603','388',156653.39,157346.73,693.34,113014.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','209012',4055270,'2604','388',210673.55,210673.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209012',4055271,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209012',4055272,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209124',4057248,'2593','388',272104.14,272854.39,750.25,122290.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','209124',4057249,'2594','388',287327.77,288577.17,1249.40,203652.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','209124',4057250,'2595','388',227963.00,227963.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209124',4057251,'2596','388',287875.26,288498.61,623.35,101606.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','209124',4057252,'2597','388',225767.12,226576.47,809.35,131924.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','209124',4057253,'2598','388',251795.77,251795.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209124',4057254,'2599','388',185654.33,186097.78,443.45,72282.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','209124',4057255,'2600','388',212959.84,212959.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209124',4057256,'2601','388',247743.24,247743.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209124',4057257,'2602','388',258007.11,258474.46,467.35,76178.05,0.00,0.00,0.00,0.00,0.00),('1','171','879','209124',4057258,'2603','388',157346.73,157346.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209124',4057259,'2604','388',210673.55,210868.41,194.86,31762.18,0.00,0.00,0.00,0.00,0.00),('1','171','932','209124',4057260,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209124',4057261,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209236',4059227,'2593','388',272854.39,272854.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209236',4059228,'2594','388',288577.17,290050.62,1473.45,240172.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','209236',4059229,'2595','388',227963.00,228908.11,925.11,150792.93,0.00,0.00,20.00,0.00,0.00),('1','171','877','209236',4059230,'2596','388',288498.61,289498.61,1000.00,163000.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209236',4059231,'2597','388',226576.47,227337.43,760.96,124036.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','209236',4059232,'2598','388',251795.77,252859.37,1063.60,173366.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','209236',4059233,'2599','388',186097.78,186097.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209236',4059234,'2600','388',212959.84,213833.46,873.62,142400.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','209236',4059235,'2601','388',247743.24,248398.19,654.95,106756.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','209236',4059236,'2602','388',258474.46,258474.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209236',4059237,'2603','388',157346.73,157861.06,514.33,83835.79,0.00,0.00,0.00,0.00,0.00),('1','171','879','209236',4059238,'2604','388',210868.41,210868.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209236',4059239,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209236',4059240,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209358',4061453,'2593','388',272854.39,273574.52,720.13,117381.19,0.00,0.00,0.00,0.00,0.00),('1','171','877','209358',4061454,'2594','388',290050.62,291203.72,1153.10,187955.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','209358',4061455,'2595','388',228908.11,230078.70,1170.59,190806.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','209358',4061456,'2596','388',289498.61,289498.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209358',4061457,'2597','388',227337.43,227337.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209358',4061458,'2598','388',252859.37,253282.40,423.03,68953.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','209358',4061459,'2599','388',186097.78,186097.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209358',4061460,'2600','388',213833.46,214160.06,326.60,53235.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','209358',4061461,'2601','388',248398.19,248398.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209358',4061462,'2602','388',258474.46,259183.76,709.30,115615.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','209358',4061463,'2603','388',157861.06,157861.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209358',4061464,'2604','388',210868.41,211186.13,317.72,51788.36,0.00,0.00,0.00,0.00,0.00),('1','171','932','209358',4061465,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209358',4061466,'2741','412',340000.91,340000.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209458',4063110,'2593','388',273574.52,273574.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209458',4063111,'2594','388',291203.72,292916.82,1713.10,279235.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','209458',4063112,'2595','388',230078.70,231209.04,1130.34,184245.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','209458',4063113,'2596','388',289498.61,289498.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209458',4063114,'2597','388',227337.43,228032.17,694.74,113242.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','209458',4063115,'2598','388',253282.40,254755.98,1473.58,240193.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','209458',4063116,'2599','388',186097.78,186097.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209458',4063117,'2600','388',214160.06,215003.96,843.90,137555.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','209458',4063118,'2601','388',248398.19,249390.65,982.46,160140.98,0.00,0.00,10.00,0.00,0.00),('1','171','879','209458',4063119,'2602','388',259183.76,259183.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209458',4063120,'2603','388',157861.06,158298.46,437.40,71296.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','209458',4063121,'2604','388',211186.13,211186.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209458',4063122,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209458',4063123,'2741','412',340000.91,340365.09,364.18,107433.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','209587',4065607,'2593','388',273574.52,274885.79,1311.27,213737.01,0.00,0.00,0.00,0.00,0.00),('1','171','877','209587',4065608,'2594','388',292916.82,292916.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209587',4065609,'2595','388',231209.04,232063.27,854.23,139239.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','209587',4065610,'2596','388',289498.61,289498.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209587',4065611,'2597','388',228032.17,228032.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209587',4065612,'2598','388',254755.98,256051.50,1295.52,211169.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','209587',4065613,'2599','388',186097.78,186097.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209587',4065614,'2600','388',215003.96,215003.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209587',4065615,'2601','388',249390.65,249980.48,589.83,96142.29,0.00,0.00,0.00,0.00,0.00),('1','171','879','209587',4065616,'2602','388',259183.76,259183.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209587',4065617,'2603','388',158298.46,158298.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209587',4065618,'2604','388',211186.13,211671.49,485.36,79113.68,0.00,0.00,0.00,0.00,0.00),('1','171','932','209587',4065619,'2740','412',69063.24,69063.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209587',4065620,'2741','412',340365.09,340753.55,388.46,114595.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','209659',4066769,'2593','388',274885.79,274885.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209659',4066770,'2594','388',292916.82,294647.48,1730.66,282097.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','209659',4066771,'2595','388',232063.27,232308.67,245.40,40000.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','209659',4066772,'2596','388',289498.61,290967.72,1469.11,239464.93,0.00,0.00,0.00,0.00,0.00),('1','171','878','209659',4066773,'2597','388',228032.17,229355.83,1323.66,215756.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','209659',4066774,'2598','388',256051.50,256051.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209659',4066775,'2599','388',186097.78,186689.12,571.34,93128.42,0.00,0.00,20.00,0.00,0.00),('1','171','878','209659',4066776,'2600','388',215003.96,216170.73,1166.77,190183.51,0.00,0.00,0.00,0.00,0.00),('1','171','879','209659',4066777,'2601','388',249980.48,249980.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209659',4066778,'2602','388',259183.76,259964.28,780.52,127224.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','209659',4066779,'2603','388',158298.46,158780.16,481.70,78517.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','209659',4066780,'2604','388',211671.49,211671.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209659',4066781,'2740','412',69063.24,69115.77,52.53,15496.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','209659',4066782,'2741','412',340753.55,341026.60,273.05,80549.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','209765',4068760,'2593','388',274885.79,274885.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209765',4068761,'2594','388',294647.48,294647.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','209765',4068762,'2595','388',232308.67,233073.53,764.86,124672.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','209765',4068763,'2596','388',290967.72,290967.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209765',4068764,'2597','388',229355.83,230163.58,807.75,131663.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','209765',4068765,'2598','388',256051.50,256051.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209765',4068766,'2599','388',186689.12,187349.33,660.21,107614.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','209765',4068767,'2600','388',216170.73,216170.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209765',4068768,'2601','388',249980.48,250459.50,479.02,78080.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','209765',4068769,'2602','388',259964.28,260332.77,368.49,60063.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','209765',4068770,'2603','388',158780.16,158780.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209765',4068771,'2604','388',211671.49,211812.59,141.10,22999.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','209765',4068772,'2740','412',69115.77,69115.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209765',4068773,'2741','412',341026.60,341086.85,60.25,17773.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','209868',4070502,'2593','388',274885.79,276036.37,1150.58,187544.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','209868',4070503,'2594','388',294647.48,295913.98,1266.50,206439.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','209868',4070504,'2595','388',233073.53,233927.50,853.97,139197.11,0.00,0.00,0.00,0.00,0.00),('1','171','877','209868',4070505,'2596','388',290967.72,290967.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209868',4070506,'2597','388',230163.58,230163.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209868',4070507,'2598','388',256051.50,257220.60,1169.10,190563.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','209868',4070508,'2599','388',187349.33,187349.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','209868',4070509,'2600','388',216170.73,216944.88,774.15,126186.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','209868',4070510,'2601','388',250459.50,250459.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','209868',4070511,'2602','388',260332.77,261006.43,673.66,109806.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','209868',4070512,'2603','388',158780.16,159172.63,392.47,63972.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','209868',4070513,'2604','388',211812.59,211812.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209868',4070514,'2740','412',69115.77,69115.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','209868',4070515,'2741','412',341086.85,341211.76,124.91,36848.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','210002',4072952,'2593','388',276036.37,276863.56,827.19,134831.97,0.00,0.00,0.00,0.00,0.00),('1','171','877','210002',4072953,'2594','388',295913.98,296024.51,110.53,18016.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','210002',4072954,'2595','388',233927.50,235289.10,1361.60,221940.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','210002',4072955,'2596','388',290967.72,290967.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210002',4072956,'2597','388',230163.58,231557.18,1382.55,225355.65,0.00,0.00,11.05,0.00,0.00),('1','171','878','210002',4072957,'2598','388',257220.60,257220.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210002',4072958,'2599','388',187349.33,188123.97,774.64,126266.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','210002',4072959,'2600','388',216944.88,217515.35,570.47,92986.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','210002',4072960,'2601','388',250459.50,250824.14,364.64,59436.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','210002',4072961,'2602','388',261006.43,261503.61,497.18,81040.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','210002',4072962,'2603','388',159172.63,159172.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210002',4072963,'2604','388',211812.59,211911.01,98.42,16042.46,0.00,0.00,0.00,0.00,0.00),('1','171','932','210002',4072964,'2740','412',69115.77,69336.53,220.76,65124.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','210002',4072965,'2741','412',341211.76,342549.83,1338.07,394730.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','210122',4074963,'2593','388',276863.56,278322.27,1458.71,237769.73,0.00,0.00,0.00,0.00,0.00),('1','171','877','210122',4074964,'2594','388',296024.51,297117.62,1093.11,178176.93,0.00,0.00,0.00,0.00,0.00),('1','171','877','210122',4074965,'2595','388',235289.10,235289.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210122',4074966,'2596','388',290967.72,292364.93,1397.21,227745.23,0.00,0.00,0.00,0.00,0.00),('1','171','878','210122',4074967,'2597','388',231557.18,231557.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210122',4074968,'2598','388',257220.60,258432.26,1211.66,197500.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','210122',4074969,'2599','388',188123.97,188123.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210122',4074970,'2600','388',217515.35,218156.41,641.06,104492.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','210122',4074971,'2601','388',250824.14,251526.37,702.23,114463.49,0.00,0.00,0.00,0.00,0.00),('1','171','879','210122',4074972,'2602','388',261503.61,261503.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210122',4074973,'2603','388',159172.63,159810.02,637.39,103894.57,0.00,0.00,0.00,0.00,0.00),('1','171','879','210122',4074974,'2604','388',211911.01,211911.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210122',4074975,'2740','412',69336.53,69336.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210122',4074976,'2741','412',342549.83,342941.00,391.17,115395.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','210231',4076826,'2593','388',278322.27,278791.86,469.59,76543.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','210231',4076827,'2594','388',297117.62,297345.19,227.57,37093.91,0.00,0.00,0.00,0.00,0.00),('1','171','877','210231',4076828,'2595','388',235289.10,236535.75,1246.65,203203.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','210231',4076829,'2596','388',292364.93,292364.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210231',4076830,'2597','388',231557.18,232402.83,845.65,137840.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','210231',4076831,'2598','388',258432.26,259255.94,823.68,134259.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','210231',4076832,'2599','388',188123.97,188448.65,324.68,52922.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','210231',4076833,'2600','388',218156.41,218787.90,631.49,102932.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','210231',4076834,'2601','388',251526.37,251526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210231',4076835,'2602','388',261503.61,261592.47,88.86,14484.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','210231',4076836,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210231',4076837,'2604','388',211911.01,211966.53,55.52,9049.76,0.00,0.00,0.00,0.00,0.00),('1','171','932','210231',4076838,'2740','412',69336.53,69386.53,50.00,14750.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210231',4076839,'2741','412',342941.00,343350.21,409.21,120716.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','210327',4078611,'2593','388',278791.86,278791.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210327',4078612,'2594','388',297345.19,299974.62,2629.43,428597.09,0.00,0.00,0.00,0.00,0.00),('1','171','877','210327',4078613,'2595','388',236535.75,238093.87,1558.12,253973.56,0.00,0.00,0.00,0.00,0.00),('1','171','877','210327',4078614,'2596','388',292364.93,292364.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210327',4078615,'2597','388',232402.83,233418.17,1015.34,165500.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','210327',4078616,'2598','388',259255.94,260233.45,977.51,159334.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','210327',4078617,'2599','388',188448.65,188512.44,63.79,10397.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','210327',4078618,'2600','388',218787.90,219947.79,1159.89,189062.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','210327',4078619,'2601','388',251526.37,251526.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210327',4078620,'2602','388',261592.47,261592.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210327',4078621,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210327',4078622,'2604','388',211966.53,211966.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210327',4078623,'2740','412',69386.53,69386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210327',4078624,'2741','412',343350.21,343538.42,188.21,55521.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','210430',4080549,'2593','388',278791.86,278791.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210430',4080550,'2594','388',299974.62,300906.46,931.84,151889.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','210430',4080551,'2595','388',238093.87,238343.84,249.97,40745.11,0.00,0.00,0.00,0.00,0.00),('1','171','877','210430',4080552,'2596','388',292364.93,293741.98,1377.05,224459.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','210430',4080553,'2597','388',233418.17,233645.10,226.93,36989.59,0.00,0.00,0.00,0.00,0.00),('1','171','878','210430',4080554,'2598','388',260233.45,260233.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210430',4080555,'2599','388',188512.44,189241.46,729.02,118830.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','210430',4080556,'2600','388',219947.79,220413.75,465.96,75951.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','210430',4080557,'2601','388',251526.37,251934.30,407.93,66492.59,0.00,0.00,0.00,0.00,0.00),('1','171','879','210430',4080558,'2602','388',261592.47,261592.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210430',4080559,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210430',4080560,'2604','388',211966.53,212232.75,246.72,40215.36,0.00,0.00,19.50,0.00,0.00),('1','171','932','210430',4080561,'2740','412',69386.53,69386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210430',4080562,'2741','412',343538.42,344337.53,799.11,235737.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','210517',4082228,'2593','388',278791.86,279381.41,589.55,96096.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','210517',4082229,'2594','388',300906.46,300906.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210517',4082230,'2595','388',238343.84,238343.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210517',4082231,'2596','388',293741.98,294019.96,277.98,45310.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','210517',4082232,'2597','388',233645.10,233943.53,298.43,48644.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','210517',4082233,'2598','388',260233.45,263146.13,2912.68,474766.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','210517',4082234,'2599','388',189241.46,190093.71,852.25,138916.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','210517',4082235,'2600','388',220413.75,221175.99,762.24,124245.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','210517',4082236,'2601','388',251934.30,251934.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210517',4082237,'2602','388',261592.47,262966.83,1374.36,224020.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','210517',4082238,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210517',4082239,'2604','388',212232.75,213117.06,884.31,144142.53,0.00,0.00,0.00,0.00,0.00),('1','171','932','210517',4082240,'2740','412',69386.53,69386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210517',4082241,'2741','412',344337.53,344573.21,235.68,69525.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','210677',4085129,'2593','388',279381.41,279381.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210677',4085130,'2594','388',300906.46,301472.74,566.28,92303.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','210677',4085131,'2595','388',238343.84,238620.87,277.03,45155.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','210677',4085132,'2596','388',294019.96,294512.20,492.24,80235.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','210677',4085133,'2597','388',233943.53,234455.61,512.08,83469.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','210677',4085134,'2598','388',263146.13,263146.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210677',4085135,'2599','388',190093.71,190514.13,420.42,68528.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','210677',4085136,'2600','388',221175.99,221952.94,776.95,126642.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','210677',4085137,'2601','388',251934.30,252745.58,811.28,132238.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','210677',4085138,'2602','388',262966.83,262966.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210677',4085139,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210677',4085140,'2604','388',213117.06,213414.87,297.81,48543.03,0.00,0.00,0.00,0.00,0.00),('1','171','932','210677',4085141,'2740','412',69386.53,69410.26,23.73,7000.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','210677',4085142,'2741','412',344573.21,345116.21,543.00,160185.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210734',4086010,'2593','388',279381.41,281067.43,1686.02,274821.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','210734',4086011,'2594','388',301472.74,301472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210734',4086012,'2595','388',238620.87,240060.70,1439.83,234692.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','210734',4086013,'2596','388',294512.20,294512.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210734',4086014,'2597','388',234455.61,235471.53,1015.92,165594.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','210734',4086015,'2598','388',263146.13,264237.56,1091.43,177903.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','210734',4086016,'2599','388',190514.13,190514.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210734',4086017,'2600','388',221952.94,222621.34,668.40,108949.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','210734',4086018,'2601','388',252745.58,252745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210734',4086019,'2602','388',262966.83,263953.89,987.06,160890.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','210734',4086020,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210734',4086021,'2604','388',213414.87,213850.12,435.25,70945.75,0.00,0.00,0.00,0.00,0.00),('1','171','932','210734',4086022,'2740','412',69410.26,69415.01,4.75,1401.25,0.00,0.00,0.00,0.00,0.00),('1','171','932','210734',4086023,'2741','412',345116.21,345679.66,563.45,166217.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','210856',4087986,'2593','388',281067.43,281157.23,89.80,14637.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','210856',4087987,'2594','388',301472.74,301472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210856',4087988,'2595','388',240060.70,240060.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','210856',4087989,'2596','388',294512.20,295576.23,1064.03,173436.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','210856',4087990,'2597','388',235471.53,235471.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210856',4087991,'2598','388',264237.56,265274.31,1036.75,168990.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','210856',4087992,'2599','388',190514.13,190514.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210856',4087993,'2600','388',222621.34,223384.86,763.52,124453.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','210856',4087994,'2601','388',252745.58,253392.26,646.68,105408.84,0.00,0.00,0.00,0.00,0.00),('1','171','879','210856',4087995,'2602','388',263953.89,263953.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210856',4087996,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210856',4087997,'2604','388',213850.12,214230.96,380.84,62076.92,0.00,0.00,0.00,0.00,0.00),('1','171','932','210856',4087998,'2740','412',69415.01,69415.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','210856',4087999,'2741','412',345679.66,346154.57,474.91,140098.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','210955',4089702,'2593','388',281157.23,282339.79,1182.56,192757.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','210955',4089703,'2594','388',301472.74,303397.02,1924.28,313657.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','210955',4089704,'2595','388',240060.70,241703.23,1642.53,267732.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','210955',4089705,'2596','388',295576.23,295576.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210955',4089706,'2597','388',235471.53,236952.66,1481.13,241424.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','210955',4089707,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210955',4089708,'2599','388',190514.13,190514.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','210955',4089709,'2600','388',223384.86,224320.26,935.40,152470.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','210955',4089710,'2601','388',253392.26,253392.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210955',4089711,'2602','388',263953.89,264742.77,788.88,128587.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','210955',4089712,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','210955',4089713,'2604','388',214230.96,214647.45,416.49,67887.87,0.00,0.00,0.00,0.00,0.00),('1','171','932','210955',4089714,'2740','412',69415.01,69443.79,28.78,8490.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','210955',4089715,'2741','412',346154.57,346608.04,453.47,133773.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','211060',4091519,'2593','388',282339.79,282390.80,51.01,8314.63,0.00,0.00,0.00,0.00,0.00),('1','171','877','211060',4091520,'2594','388',303397.02,303397.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','211060',4091521,'2595','388',241703.23,241703.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','211060',4091522,'2596','388',295576.23,296930.21,1353.98,220698.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','211060',4091523,'2597','388',236952.66,238145.95,1193.29,194506.27,0.00,0.00,0.00,0.00,0.00),('1','171','878','211060',4091524,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211060',4091525,'2599','388',190514.13,191055.80,541.67,88292.21,0.00,0.00,0.00,0.00,0.00),('1','171','878','211060',4091526,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211060',4091527,'2601','388',253392.26,254310.98,918.72,149751.36,0.00,0.00,0.00,0.00,0.00),('1','171','879','211060',4091528,'2602','388',264742.77,264742.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211060',4091529,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211060',4091530,'2604','388',214647.45,214647.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211060',4091531,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211060',4091532,'2741','412',346608.04,346753.36,145.32,42869.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','211177',4093629,'2593','388',282390.80,283642.11,1251.31,203963.53,0.00,0.00,0.00,0.00,0.00),('1','171','877','211177',4093630,'2594','388',303397.02,304806.85,1409.83,229802.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','211177',4093631,'2595','388',241703.23,242922.31,1219.08,198710.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','211177',4093632,'2596','388',296930.21,298186.07,1255.86,204705.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','211177',4093633,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211177',4093634,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211177',4093635,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211177',4093636,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211177',4093637,'2601','388',254310.98,254823.61,512.63,83558.69,0.00,0.00,0.00,0.00,0.00),('1','171','879','211177',4093638,'2602','388',264742.77,265623.79,881.02,143606.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','211177',4093639,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211177',4093640,'2604','388',214647.45,215324.29,666.84,108694.92,0.00,0.00,10.00,0.00,0.00),('1','171','932','211177',4093641,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211177',4093642,'2741','412',346753.36,347301.62,548.26,161736.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','211262',4095293,'2593','388',283642.11,284703.24,1061.13,172964.19,0.00,0.00,0.00,0.00,0.00),('1','171','877','211262',4095294,'2594','388',304806.85,305150.69,343.84,56045.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','211262',4095295,'2595','388',242922.31,244005.98,1083.67,176638.21,0.00,0.00,0.00,0.00,0.00),('1','171','877','211262',4095296,'2596','388',298186.07,298419.78,233.71,38094.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','211262',4095297,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211262',4095298,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211262',4095299,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211262',4095300,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211262',4095301,'2601','388',254823.61,254823.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211262',4095302,'2602','388',265623.79,266296.22,672.43,109606.09,0.00,0.00,0.00,0.00,0.00),('1','171','879','211262',4095303,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211262',4095304,'2604','388',215324.29,216125.25,800.96,130556.48,0.00,0.00,0.00,0.00,0.00),('1','171','932','211262',4095305,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211262',4095306,'2741','412',347301.62,347541.95,240.33,70897.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','211373',4097284,'2593','388',284703.24,284703.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','211373',4097285,'2594','388',305150.69,307004.11,1853.42,302107.46,0.00,0.00,0.00,0.00,0.00),('1','171','877','211373',4097286,'2595','388',244005.98,245185.86,1179.88,192320.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','211373',4097287,'2596','388',298419.78,299876.23,1456.45,237401.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','211373',4097288,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211373',4097289,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211373',4097290,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211373',4097291,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211373',4097292,'2601','388',254823.61,256179.57,1355.96,221021.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','211373',4097293,'2602','388',266296.22,266296.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211373',4097294,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211373',4097295,'2604','388',216125.25,216871.87,746.62,121699.06,0.00,0.00,0.00,0.00,0.00),('1','171','932','211373',4097296,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211373',4097297,'2741','412',347541.95,347647.88,105.93,31249.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','211492',4099287,'2593','388',284703.24,285771.34,1065.04,173601.52,0.00,0.00,3.06,0.00,0.00),('1','171','877','211492',4099288,'2594','388',307004.11,307531.71,527.60,85998.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','211492',4099289,'2595','388',245185.86,246050.70,864.84,140968.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','211492',4099290,'2596','388',299876.23,301303.02,1426.79,232566.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','211492',4099291,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211492',4099292,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211492',4099293,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211492',4099294,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211492',4099295,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211492',4099296,'2602','388',266296.22,266669.76,362.49,59085.87,0.00,0.00,11.05,0.00,0.00),('1','171','879','211492',4099297,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211492',4099298,'2604','388',216871.87,217163.60,291.73,47551.99,0.00,0.00,0.00,0.00,0.00),('1','171','932','211492',4099299,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211492',4099300,'2741','412',347647.88,348529.47,881.59,260069.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','211598',4101222,'2593','388',285771.34,287798.47,2027.13,330422.19,0.00,0.00,0.00,0.00,0.00),('1','171','877','211598',4101223,'2594','388',307531.71,310348.97,2817.26,459213.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','211598',4101224,'2595','388',246050.70,247924.05,1873.35,305356.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','211598',4101225,'2596','388',301303.02,303228.21,1925.19,313805.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','211598',4101226,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211598',4101227,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211598',4101228,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211598',4101229,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211598',4101230,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211598',4101231,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211598',4101232,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211598',4101233,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211598',4101234,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211598',4101235,'2741','412',348529.47,349437.58,908.11,267892.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','211645',4101930,'2593','388',287798.47,288665.57,867.10,141337.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','211645',4101931,'2594','388',310348.97,310949.00,580.03,94544.89,0.00,0.00,20.00,0.00,0.00),('1','171','877','211645',4101932,'2595','388',247924.05,249234.93,1310.88,213673.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','211645',4101933,'2596','388',303228.21,303773.62,525.41,85641.83,0.00,0.00,20.00,0.00,0.00),('1','171','878','211645',4101934,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211645',4101935,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211645',4101936,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211645',4101937,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211645',4101938,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211645',4101939,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211645',4101940,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211645',4101941,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211645',4101942,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211645',4101943,'2741','412',349437.58,349868.08,430.50,126997.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','211786',4104141,'2593','388',288665.57,289632.87,967.30,157669.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','211786',4104142,'2594','388',310949.00,313127.29,2178.29,355061.27,0.00,0.00,0.00,0.00,0.00),('1','171','877','211786',4104143,'2595','388',249234.93,250400.51,1165.58,189989.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','211786',4104144,'2596','388',303773.62,305112.93,1339.31,218307.53,0.00,0.00,0.00,0.00,0.00),('1','171','878','211786',4104145,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211786',4104146,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211786',4104147,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211786',4104148,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211786',4104149,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211786',4104150,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211786',4104151,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211786',4104152,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211786',4104153,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211786',4104154,'2741','412',349868.08,350049.10,181.02,53400.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','211879',4105877,'2593','388',289632.87,289857.78,224.91,36660.33,0.00,0.00,0.00,0.00,0.00),('1','171','877','211879',4105878,'2594','388',313127.29,313340.76,213.47,34795.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','211879',4105879,'2595','388',250400.51,250885.11,484.60,78989.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','211879',4105880,'2596','388',305112.93,306053.82,940.89,153365.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','211879',4105881,'2597','388',238145.95,238145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211879',4105882,'2598','388',265274.31,265274.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211879',4105883,'2599','388',191055.80,191055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211879',4105884,'2600','388',224320.26,224320.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211879',4105885,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211879',4105886,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211879',4105887,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211879',4105888,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211879',4105889,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211879',4105890,'2741','412',350049.10,350476.18,427.08,125988.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','211977',4107744,'2593','388',289857.78,290745.80,888.02,144747.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','211977',4107745,'2594','388',313340.76,314776.69,1435.93,234056.59,0.00,0.00,0.00,0.00,0.00),('1','171','877','211977',4107746,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','211977',4107747,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','211977',4107748,'2597','388',238145.95,238795.45,649.50,105868.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','211977',4107749,'2598','388',265274.31,265908.34,634.03,103346.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','211977',4107750,'2599','388',191055.80,191502.85,447.05,72869.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','211977',4107751,'2600','388',224320.26,224892.64,572.38,93297.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','211977',4107752,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211977',4107753,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211977',4107754,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','211977',4107755,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211977',4107756,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','211977',4107757,'2741','412',350476.18,351124.66,648.48,191301.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','212086',4109645,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212086',4109646,'2594','388',314776.69,314940.45,163.76,26692.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','212086',4109647,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212086',4109648,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212086',4109649,'2597','388',238795.45,240010.99,1215.54,198133.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','212086',4109650,'2598','388',265908.34,266051.25,142.91,23294.33,0.00,0.00,0.00,0.00,0.00),('1','171','878','212086',4109651,'2599','388',191502.85,192674.62,1171.77,190998.51,0.00,0.00,0.00,0.00,0.00),('1','171','878','212086',4109652,'2600','388',224892.64,226376.01,1483.37,241789.31,0.00,0.00,0.00,0.00,0.00),('1','171','879','212086',4109653,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212086',4109654,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212086',4109655,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212086',4109656,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212086',4109657,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212086',4109658,'2741','412',351124.66,351576.54,451.88,133304.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','212236',4112200,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212236',4112201,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212236',4112202,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212236',4112203,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212236',4112204,'2597','388',240010.99,241490.91,1479.92,241226.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','212236',4112205,'2598','388',266051.25,269312.18,3260.93,531531.59,0.00,0.00,0.00,0.00,0.00),('1','171','878','212236',4112206,'2599','388',192674.62,194121.04,1446.42,235766.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','212236',4112207,'2600','388',226376.01,227822.48,1446.47,235774.61,0.00,0.00,0.00,0.00,0.00),('1','171','879','212236',4112208,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212236',4112209,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212236',4112210,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212236',4112211,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212236',4112212,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212236',4112213,'2741','412',351576.54,352505.35,928.81,273998.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','212335',4114016,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212335',4114017,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212335',4114018,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212335',4114019,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212335',4114020,'2597','388',241490.91,242578.61,1087.70,177295.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','212335',4114021,'2598','388',269312.18,269529.87,217.69,35483.47,0.00,0.00,0.00,0.00,0.00),('1','171','878','212335',4114022,'2599','388',194121.04,195338.00,1216.96,198364.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','212335',4114023,'2600','388',227822.48,229051.42,1228.94,200317.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','212335',4114024,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212335',4114025,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212335',4114026,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212335',4114027,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212335',4114028,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212335',4114029,'2741','412',352505.35,352698.39,193.04,56946.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','212461',4116349,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212461',4116350,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212461',4116351,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212461',4116352,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212461',4116353,'2597','388',242578.61,244563.91,1985.30,323603.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','212461',4116354,'2598','388',269529.87,272421.01,2891.14,471255.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','212461',4116355,'2599','388',195338.00,196523.60,1185.60,193252.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','212461',4116356,'2600','388',229051.42,230768.72,1717.30,279919.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','212461',4116357,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212461',4116358,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212461',4116359,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212461',4116360,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212461',4116361,'2740','412',69443.79,69443.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212461',4116362,'2741','412',352698.39,352956.70,258.31,76201.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','212550',4117945,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212550',4117946,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212550',4117947,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212550',4117948,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212550',4117949,'2597','388',244563.91,245302.96,739.05,120465.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','212550',4117950,'2598','388',272421.01,272716.28,295.27,48129.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','212550',4117951,'2599','388',196523.60,197338.24,814.64,132786.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','212550',4117952,'2600','388',230768.72,232081.75,1313.03,214023.89,0.00,0.00,0.00,0.00,0.00),('1','171','879','212550',4117953,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212550',4117954,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212550',4117955,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212550',4117956,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212550',4117957,'2740','412',69443.79,69727.93,284.14,82400.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','212550',4117958,'2741','412',352956.70,353550.08,593.38,172080.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','212680',4120229,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212680',4120230,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212680',4120231,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212680',4120232,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212680',4120233,'2597','388',245302.96,247583.30,2280.34,371695.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','212680',4120234,'2598','388',272716.28,275802.72,3086.44,503089.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','212680',4120235,'2599','388',197338.24,198891.12,1552.88,253119.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','212680',4120236,'2600','388',232081.75,233268.00,1186.25,193358.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','212680',4120237,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212680',4120238,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212680',4120239,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212680',4120240,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212680',4120241,'2740','412',69727.93,69727.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212680',4120242,'2741','412',353550.08,354012.87,462.79,134209.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','212766',4121729,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212766',4121730,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212766',4121731,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212766',4121732,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212766',4121733,'2597','388',247583.30,248827.94,1244.64,202876.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','212766',4121734,'2598','388',275802.72,275858.42,55.70,9079.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','212766',4121735,'2599','388',198891.12,200052.15,1161.03,189247.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','212766',4121736,'2600','388',233268.00,234165.19,897.19,146241.97,0.00,0.00,0.00,0.00,0.00),('1','171','879','212766',4121737,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212766',4121738,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212766',4121739,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212766',4121740,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212766',4121741,'2740','412',69727.93,69727.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212766',4121742,'2741','412',354012.87,354253.90,241.03,69898.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','212872',4123636,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212872',4123637,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212872',4123638,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','212872',4123639,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','212872',4123640,'2597','388',248827.94,249803.50,975.56,159016.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','212872',4123641,'2598','388',275858.42,278660.39,2801.97,456721.11,0.00,0.00,0.00,0.00,0.00),('1','171','878','212872',4123642,'2599','388',200052.15,200677.76,625.61,101974.43,0.00,0.00,0.00,0.00,0.00),('1','171','878','212872',4123643,'2600','388',234165.19,235840.62,1675.43,273095.09,0.00,0.00,0.00,0.00,0.00),('1','171','879','212872',4123644,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212872',4123645,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212872',4123646,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','212872',4123647,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212872',4123648,'2740','412',69727.93,69727.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','212872',4123649,'2741','412',354253.90,354494.60,240.70,69803.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213004',4126077,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213004',4126078,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213004',4126079,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213004',4126080,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213004',4126081,'2597','388',249803.50,250106.07,302.57,49318.91,0.00,0.00,0.00,0.00,0.00),('1','171','878','213004',4126082,'2598','388',278660.39,279167.84,507.45,82714.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','213004',4126083,'2599','388',200677.76,201274.74,581.61,94802.43,0.00,0.00,15.37,0.00,0.00),('1','171','878','213004',4126084,'2600','388',235840.62,236648.73,808.11,131721.93,0.00,0.00,0.00,0.00,0.00),('1','171','879','213004',4126085,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213004',4126086,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213004',4126087,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213004',4126088,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213004',4126089,'2740','412',69727.93,69727.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213004',4126090,'2741','412',354494.60,354889.07,394.47,114396.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','213145',4128308,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213145',4128309,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213145',4128310,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213145',4128311,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213145',4128312,'2597','388',250106.07,250106.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213145',4128313,'2598','388',279167.84,279167.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213145',4128314,'2599','388',201274.74,201274.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213145',4128315,'2600','388',236648.73,236648.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213145',4128316,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213145',4128317,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213145',4128318,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213145',4128319,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213145',4128320,'2740','412',69727.93,69727.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213145',4128321,'2741','412',354889.07,355126.30,237.23,68796.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','213269',4130353,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213269',4130354,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213269',4130355,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213269',4130356,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213269',4130357,'2597','388',250106.07,250106.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213269',4130358,'2598','388',279167.84,279167.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213269',4130359,'2599','388',201274.74,201274.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213269',4130360,'2600','388',236648.73,236648.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213269',4130361,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213269',4130362,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213269',4130363,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213269',4130364,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213269',4130365,'2740','412',69727.93,69937.97,210.04,60911.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','213269',4130366,'2741','412',355126.30,356039.36,913.06,264787.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','213408',4132563,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213408',4132564,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213408',4132565,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213408',4132566,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213408',4132567,'2597','388',250106.07,250106.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213408',4132568,'2598','388',279167.84,279167.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213408',4132569,'2599','388',201274.74,201274.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213408',4132570,'2600','388',236648.73,236648.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213408',4132571,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213408',4132572,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213408',4132573,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213408',4132574,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213408',4132575,'2740','412',69937.97,69937.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213408',4132576,'2741','412',356039.36,356935.34,895.98,259834.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','213557',4135116,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213557',4135117,'2594','388',314940.45,314940.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213557',4135118,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213557',4135119,'2596','388',306053.82,306053.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213557',4135120,'2597','388',250106.07,250106.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213557',4135121,'2598','388',279167.84,279167.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213557',4135122,'2599','388',201274.74,201274.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213557',4135123,'2600','388',236648.73,236648.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213557',4135124,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213557',4135125,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213557',4135126,'2603','388',159810.02,159810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213557',4135127,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213557',4135128,'2740','412',69937.97,69937.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213557',4135129,'2741','412',356935.34,357345.82,410.48,119039.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','213637',4136479,'2593','388',290745.80,290745.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213637',4136480,'2594','388',314940.45,316365.79,1425.34,232330.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','213637',4136481,'2595','388',250885.11,250885.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','213637',4136482,'2596','388',306053.82,307008.67,954.85,155640.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','213637',4136483,'2597','388',250106.07,251811.81,1705.74,278035.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','213637',4136484,'2598','388',279167.84,281075.04,1907.20,310873.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','213637',4136485,'2599','388',201274.74,201938.24,663.50,108150.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','213637',4136486,'2600','388',236648.73,237211.52,562.79,91734.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','213637',4136487,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213637',4136488,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213637',4136489,'2603','388',159810.02,159820.18,10.16,1656.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','213637',4136490,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213637',4136491,'2740','412',69937.97,69993.14,55.17,15999.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','213637',4136492,'2741','412',357345.82,358466.69,1120.87,325052.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','213760',4138541,'2593','388',290745.80,291107.20,361.40,58908.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','213760',4138542,'2594','388',316365.79,316849.01,483.22,78764.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','213760',4138543,'2595','388',250885.11,251043.93,158.82,25887.66,0.00,0.00,0.00,0.00,0.00),('1','171','877','213760',4138544,'2596','388',307008.67,307048.27,39.60,6454.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','213760',4138545,'2597','388',251811.81,251811.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213760',4138546,'2598','388',281075.04,282235.66,1160.62,189181.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','213760',4138547,'2599','388',201938.24,201938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213760',4138548,'2600','388',237211.52,238161.62,950.10,154866.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','213760',4138549,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213760',4138550,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213760',4138551,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213760',4138552,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213760',4138553,'2740','412',69993.14,69993.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213760',4138554,'2741','412',358466.69,359704.32,1237.63,358912.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','213893',4140695,'2593','388',291107.20,292796.35,1689.15,275331.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','213893',4140696,'2594','388',316849.01,318380.07,1531.06,249562.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','213893',4140697,'2595','388',251043.93,252279.83,1235.90,201451.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','213893',4140698,'2596','388',307048.27,308261.95,1213.68,197829.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','213893',4140699,'2597','388',251811.81,252730.24,918.43,149704.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','213893',4140700,'2598','388',282235.66,282235.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','213893',4140701,'2599','388',201938.24,202805.29,867.05,141329.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','213893',4140702,'2600','388',238161.62,238161.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213893',4140703,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213893',4140704,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213893',4140705,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','213893',4140706,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','213893',4140707,'2740','412',69993.14,70133.47,140.33,40695.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','213893',4140708,'2741','412',359704.32,360437.39,733.07,212590.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','214070',4143748,'2593','388',292796.35,293666.75,870.40,141875.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','214070',4143749,'2594','388',318380.07,319604.03,1223.96,199505.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','214070',4143750,'2595','388',252279.83,253109.46,829.63,135229.69,0.00,0.00,0.00,0.00,0.00),('1','171','877','214070',4143751,'2596','388',308261.95,308953.42,691.47,112709.61,0.00,0.00,0.00,0.00,0.00),('1','171','878','214070',4143752,'2597','388',252730.24,252730.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214070',4143753,'2598','388',282235.66,283095.06,859.40,140082.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','214070',4143754,'2599','388',202805.29,202805.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214070',4143755,'2600','388',238161.62,238621.16,459.54,74905.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','214070',4143756,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214070',4143757,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214070',4143758,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214070',4143759,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214070',4143760,'2740','412',70133.47,71058.84,925.37,268357.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','214070',4143761,'2741','412',360437.39,361085.33,647.94,187902.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','214099',4144152,'2593','388',293666.75,294586.98,920.23,149997.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','214099',4144153,'2594','388',319604.03,320557.24,953.21,155373.23,0.00,0.00,0.00,0.00,0.00),('1','171','877','214099',4144154,'2595','388',253109.46,253968.18,838.72,136711.36,0.00,0.00,20.00,0.00,0.00),('1','171','877','214099',4144155,'2596','388',308953.42,309984.37,1030.95,168044.85,0.00,0.00,0.00,0.00,0.00),('1','171','878','214099',4144156,'2597','388',252730.24,253417.51,687.27,112025.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','214099',4144157,'2598','388',283095.06,284172.49,1077.43,175621.09,0.00,0.00,0.00,0.00,0.00),('1','171','878','214099',4144158,'2599','388',202805.29,203482.82,677.53,110437.39,0.00,0.00,0.00,0.00,0.00),('1','171','878','214099',4144159,'2600','388',238621.16,239528.55,907.39,147904.57,0.00,0.00,0.00,0.00,0.00),('1','171','879','214099',4144160,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214099',4144161,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214099',4144162,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214099',4144163,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214099',4144164,'2740','412',71058.84,71058.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214099',4144165,'2741','412',361085.33,361782.45,697.12,202164.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','214213',4146058,'2593','388',294586.98,295374.36,787.38,128342.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','214213',4146059,'2594','388',320557.24,321428.20,870.96,141966.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','214213',4146060,'2595','388',253968.18,254313.12,344.94,56225.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','214213',4146061,'2596','388',309984.37,310641.19,656.82,107061.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','214213',4146062,'2597','388',253417.51,253417.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214213',4146063,'2598','388',284172.49,285009.12,836.63,136370.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','214213',4146064,'2599','388',203482.82,203482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214213',4146065,'2600','388',239528.55,239903.28,374.73,61080.99,0.00,0.00,0.00,0.00,0.00),('1','171','879','214213',4146066,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214213',4146067,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214213',4146068,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214213',4146069,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214213',4146070,'2740','412',71058.84,71058.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214213',4146071,'2741','412',361782.45,362250.37,467.92,135696.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','214343',4148408,'2593','388',295374.36,296397.82,1013.46,165193.98,0.00,0.00,10.00,0.00,0.00),('1','171','877','214343',4148409,'2594','388',321428.20,322442.70,1014.50,165363.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','214343',4148410,'2595','388',254313.12,255132.82,809.70,131981.10,0.00,0.00,10.00,0.00,0.00),('1','171','877','214343',4148411,'2596','388',310641.19,311591.63,950.44,154921.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','214343',4148412,'2597','388',253417.51,254186.67,759.16,123743.08,0.00,0.00,10.00,0.00,0.00),('1','171','878','214343',4148413,'2598','388',285009.12,285942.10,932.98,152075.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','214343',4148414,'2599','388',203482.82,204458.34,965.52,157379.76,0.00,0.00,10.00,0.00,0.00),('1','171','878','214343',4148415,'2600','388',239903.28,239903.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214343',4148416,'2601','388',256179.57,256179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214343',4148417,'2602','388',266669.76,266669.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214343',4148418,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214343',4148419,'2604','388',217163.60,217163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214343',4148420,'2740','412',71058.84,71058.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214343',4148421,'2741','412',362250.37,362671.20,410.83,119140.70,0.00,0.00,10.00,0.00,0.00),('1','171','877','214449',4150188,'2593','388',296397.82,296397.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214449',4150189,'2594','388',322442.70,322786.88,344.18,56101.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','214449',4150190,'2595','388',255132.82,256728.04,1595.22,260020.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','214449',4150191,'2596','388',311591.63,311603.90,12.27,2000.01,0.00,0.00,0.00,0.00,0.00),('1','171','878','214449',4150192,'2597','388',254186.67,254381.36,194.69,31734.47,0.00,0.00,0.00,0.00,0.00),('1','171','878','214449',4150193,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214449',4150194,'2599','388',204458.34,204458.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214449',4150195,'2600','388',239903.28,241009.17,1105.89,180260.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','214449',4150196,'2601','388',256179.57,256631.20,451.63,73615.69,0.00,0.00,0.00,0.00,0.00),('1','171','879','214449',4150197,'2602','388',266669.76,266934.87,265.11,43212.93,0.00,0.00,0.00,0.00,0.00),('1','171','879','214449',4150198,'2603','388',159820.18,159820.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214449',4150199,'2604','388',217163.60,217573.33,409.73,66785.99,0.00,0.00,0.00,0.00,0.00),('1','171','932','214449',4150200,'2740','412',71058.84,71058.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214449',4150201,'2741','412',362671.20,363263.99,592.79,171909.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','214537',4151634,'2593','388',296397.82,296397.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214537',4151635,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214537',4151636,'2595','388',256728.04,258223.54,1495.50,243766.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','214537',4151637,'2596','388',311603.90,311603.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214537',4151638,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214537',4151639,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214537',4151640,'2599','388',204458.34,205727.67,1269.33,206900.79,0.00,0.00,0.00,0.00,0.00),('1','171','878','214537',4151641,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214537',4151642,'2601','388',256631.20,257200.98,569.78,92874.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','214537',4151643,'2602','388',266934.87,268095.38,1160.51,189163.13,0.00,0.00,0.00,0.00,0.00),('1','171','879','214537',4151644,'2603','388',159820.18,160573.15,752.97,122734.11,0.00,0.00,0.00,0.00,0.00),('1','171','879','214537',4151645,'2604','388',217573.33,217573.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214537',4151646,'2740','412',71058.84,71058.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214537',4151647,'2741','412',363263.99,364167.29,903.30,261957.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214680',4154082,'2593','388',296397.82,296397.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214680',4154083,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214680',4154084,'2595','388',258223.54,259123.13,899.59,146633.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','214680',4154085,'2596','388',311603.90,311603.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214680',4154086,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214680',4154087,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214680',4154088,'2599','388',205727.67,206726.22,998.55,162763.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','214680',4154089,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214680',4154090,'2601','388',257200.98,257756.20,555.22,90500.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','214680',4154091,'2602','388',268095.38,269369.17,1273.79,207627.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','214680',4154092,'2603','388',160573.15,160573.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214680',4154093,'2604','388',217573.33,218855.38,1282.05,208974.15,0.00,0.00,0.00,0.00,0.00),('1','171','932','214680',4154094,'2740','412',71058.84,71168.48,109.64,31795.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','214680',4154095,'2741','412',364167.29,365271.46,1104.17,320209.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','214788',4156012,'2593','388',296397.82,296397.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214788',4156013,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214788',4156014,'2595','388',259123.13,259736.63,613.50,100000.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','214788',4156015,'2596','388',311603.90,313281.26,1677.36,273409.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','214788',4156016,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214788',4156017,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214788',4156018,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214788',4156019,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214788',4156020,'2601','388',257756.20,258631.81,875.61,142724.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','214788',4156021,'2602','388',269369.17,270786.14,1416.97,230966.11,0.00,0.00,0.00,0.00,0.00),('1','171','879','214788',4156022,'2603','388',160573.15,161594.05,1020.90,166406.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','214788',4156023,'2604','388',218855.38,219707.93,852.55,138965.65,0.00,0.00,0.00,0.00,0.00),('1','171','932','214788',4156024,'2740','412',71168.48,71168.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','214788',4156025,'2741','412',365271.46,365880.45,608.99,176607.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','214908',4158028,'2593','388',296397.82,297882.26,1484.44,241963.72,0.00,0.00,0.00,0.00,0.00),('1','171','877','214908',4158029,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','214908',4158030,'2595','388',259736.63,259754.73,18.10,2950.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','214908',4158031,'2596','388',313281.26,313281.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214908',4158032,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214908',4158033,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214908',4158034,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','214908',4158035,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','214908',4158036,'2601','388',258631.81,259233.43,601.62,98064.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','214908',4158037,'2602','388',270786.14,271663.00,876.86,142928.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','214908',4158038,'2603','388',161594.05,161622.75,28.70,4678.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','214908',4158039,'2604','388',219707.93,220590.82,882.89,143911.07,0.00,0.00,0.00,0.00,0.00),('1','171','932','214908',4158040,'2740','412',71168.48,73446.39,2277.91,660593.90,0.00,0.00,0.00,0.00,0.00),('1','171','932','214908',4158041,'2741','412',365880.45,366597.69,717.24,207999.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','215015',4159782,'2593','388',297882.26,297882.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215015',4159783,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215015',4159784,'2595','388',259754.73,259754.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215015',4159785,'2596','388',313281.26,313281.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215015',4159786,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215015',4159787,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215015',4159788,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215015',4159789,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215015',4159790,'2601','388',259233.43,260468.26,1234.83,201277.29,0.00,0.00,0.00,0.00,0.00),('1','171','879','215015',4159791,'2602','388',271663.00,273756.60,2093.60,341256.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','215015',4159792,'2603','388',161622.75,162839.55,1216.80,198338.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','215015',4159793,'2604','388',220590.82,222530.31,1939.49,316136.87,0.00,0.00,0.00,0.00,0.00),('1','171','932','215015',4159794,'2740','412',73446.39,73446.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215015',4159795,'2741','412',366597.69,366952.26,354.57,102825.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','215136',4161894,'2593','388',297882.26,299065.97,1183.71,192944.73,0.00,0.00,0.00,0.00,0.00),('1','171','877','215136',4161895,'2594','388',322786.88,322786.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215136',4161896,'2595','388',259754.73,260595.84,841.11,137100.93,0.00,0.00,0.00,0.00,0.00),('1','171','877','215136',4161897,'2596','388',313281.26,313281.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215136',4161898,'2597','388',254381.36,254381.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215136',4161899,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215136',4161900,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215136',4161901,'2600','388',241009.17,241009.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215136',4161902,'2601','388',260468.26,260468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215136',4161903,'2602','388',273756.60,275095.68,1339.08,218270.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','215136',4161904,'2603','388',162839.55,163464.15,624.60,101809.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','215136',4161905,'2604','388',222530.31,222530.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215136',4161906,'2740','412',73446.39,73460.18,13.79,3999.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','215136',4161907,'2741','412',366952.26,368214.30,1262.04,365991.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','215234',4163572,'2593','388',299065.97,299065.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215234',4163573,'2594','388',322786.88,324490.57,1703.69,277701.47,0.00,0.00,0.00,0.00,0.00),('1','171','877','215234',4163574,'2595','388',260595.84,260595.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215234',4163575,'2596','388',313281.26,314638.64,1357.38,221252.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','215234',4163576,'2597','388',254381.36,255846.53,1465.17,238822.71,0.00,0.00,0.00,0.00,0.00),('1','171','878','215234',4163577,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215234',4163578,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215234',4163579,'2600','388',241009.17,241799.06,789.89,128752.07,0.00,0.00,0.00,0.00,0.00),('1','171','879','215234',4163580,'2601','388',260468.26,261504.66,1036.40,168933.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','215234',4163581,'2602','388',275095.68,275095.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215234',4163582,'2603','388',163464.15,163464.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215234',4163583,'2604','388',222530.31,223032.09,501.78,81790.14,0.00,0.00,0.00,0.00,0.00),('1','171','932','215234',4163584,'2740','412',73460.18,73497.41,37.23,10796.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','215234',4163585,'2741','412',368214.30,368937.46,723.16,209716.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','215352',4165563,'2593','388',299065.97,299065.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215352',4165564,'2594','388',324490.57,324490.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215352',4165565,'2595','388',260595.84,260595.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215352',4165566,'2596','388',314638.64,314638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215352',4165567,'2597','388',255846.53,255846.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215352',4165568,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215352',4165569,'2599','388',206726.22,206726.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215352',4165570,'2600','388',241799.06,242370.88,571.82,93206.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','215352',4165571,'2601','388',261504.66,262376.66,872.00,142136.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215352',4165572,'2602','388',275095.68,276150.34,1054.66,171909.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','215352',4165573,'2603','388',163464.15,164111.43,647.28,105506.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','215352',4165574,'2604','388',223032.09,223874.24,842.15,137270.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','215352',4165575,'2740','412',73497.41,73607.41,110.00,31900.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215352',4165576,'2741','412',368937.46,369917.80,980.34,284298.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','215451',4167122,'2593','388',299065.97,300951.35,1885.38,307316.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','215451',4167123,'2594','388',324490.57,324490.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215451',4167124,'2595','388',260595.84,261780.49,1184.65,193097.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','215451',4167125,'2596','388',314638.64,314638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215451',4167126,'2597','388',255846.53,257369.78,1523.25,248289.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','215451',4167127,'2598','388',285942.10,285942.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215451',4167128,'2599','388',206726.22,207635.41,909.19,148197.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','215451',4167129,'2600','388',242370.88,243088.67,717.79,116999.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','215451',4167130,'2601','388',262376.66,262376.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215451',4167131,'2602','388',276150.34,276958.83,808.49,131783.87,0.00,0.00,0.00,0.00,0.00),('1','171','879','215451',4167132,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215451',4167133,'2604','388',223874.24,223874.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215451',4167134,'2740','412',73607.41,73637.76,30.35,8801.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','215451',4167135,'2741','412',369917.80,370892.85,975.05,282764.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','215588',4169501,'2593','388',300951.35,300951.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215588',4169502,'2594','388',324490.57,325903.09,1412.52,230240.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','215588',4169503,'2595','388',261780.49,261780.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215588',4169504,'2596','388',314638.64,314638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215588',4169505,'2597','388',257369.78,257369.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215588',4169506,'2598','388',285942.10,286956.61,1014.51,165365.13,0.00,0.00,0.00,0.00,0.00),('1','171','878','215588',4169507,'2599','388',207635.41,207635.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215588',4169508,'2600','388',243088.67,244339.85,1251.18,203942.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','215588',4169509,'2601','388',262376.66,263615.37,1238.71,201909.73,0.00,0.00,0.00,0.00,0.00),('1','171','879','215588',4169510,'2602','388',276958.83,276958.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215588',4169511,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215588',4169512,'2604','388',223874.24,223874.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215588',4169513,'2740','412',73637.76,73637.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215588',4169514,'2741','412',370892.85,371665.10,772.25,223952.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','215683',4171167,'2593','388',300951.35,302265.42,1314.07,214193.41,0.00,0.00,0.00,0.00,0.00),('1','171','877','215683',4171168,'2594','388',325903.09,325903.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215683',4171169,'2595','388',261780.49,261780.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215683',4171170,'2596','388',314638.64,316328.38,1689.74,275427.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','215683',4171171,'2597','388',257369.78,259240.33,1870.55,304899.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','215683',4171172,'2598','388',286956.61,287662.74,706.13,115099.19,0.00,0.00,0.00,0.00,0.00),('1','171','878','215683',4171173,'2599','388',207635.41,208510.61,875.20,142657.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','215683',4171174,'2600','388',244339.85,244339.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215683',4171175,'2601','388',263615.37,264520.43,905.06,147524.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','215683',4171176,'2602','388',276958.83,276958.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215683',4171177,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215683',4171178,'2604','388',223874.24,223874.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215683',4171179,'2740','412',73637.76,73831.55,193.79,56199.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','215683',4171180,'2741','412',371665.10,372562.29,897.19,260185.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','215797',4173251,'2593','388',302265.42,302265.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215797',4173252,'2594','388',325903.09,326402.01,498.92,81323.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','215797',4173253,'2595','388',261780.49,261780.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','215797',4173254,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215797',4173255,'2597','388',259240.33,260450.55,1210.22,197265.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','215797',4173256,'2598','388',287662.74,287662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215797',4173257,'2599','388',208510.61,208510.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215797',4173258,'2600','388',244339.85,245778.19,1438.34,234449.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','215797',4173259,'2601','388',264520.43,264533.62,13.19,2149.97,0.00,0.00,0.00,0.00,0.00),('1','171','879','215797',4173260,'2602','388',276958.83,276958.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215797',4173261,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215797',4173262,'2604','388',223874.24,224635.34,761.10,124059.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','215797',4173263,'2740','412',73831.55,74003.62,172.07,49900.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','215797',4173264,'2741','412',372562.29,373669.88,1107.59,321201.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','215914',4175190,'2593','388',302265.42,303768.26,1502.84,244962.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','215914',4175191,'2594','388',326402.01,327452.04,1050.03,171154.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','215914',4175192,'2595','388',261780.49,262808.67,1028.18,167593.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','215914',4175193,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215914',4175194,'2597','388',260450.55,260450.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','215914',4175195,'2598','388',287662.74,288921.56,1258.82,205187.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','215914',4175196,'2599','388',208510.61,209778.91,1268.30,206732.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','215914',4175197,'2600','388',245778.19,245778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215914',4175198,'2601','388',264533.62,265339.76,806.14,131400.82,0.00,0.00,0.00,0.00,0.00),('1','171','879','215914',4175199,'2602','388',276958.83,276958.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215914',4175200,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','215914',4175201,'2604','388',224635.34,224635.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','215914',4175202,'2740','412',74003.62,74046.38,42.76,12400.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','215914',4175203,'2741','412',373669.88,373784.36,114.48,33199.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','216042',4177451,'2593','388',303768.26,303768.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216042',4177452,'2594','388',327452.04,328824.47,1372.43,223706.09,0.00,0.00,0.00,0.00,0.00),('1','171','877','216042',4177453,'2595','388',262808.67,262808.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216042',4177454,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216042',4177455,'2597','388',260450.55,261067.77,617.22,100606.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','216042',4177456,'2598','388',288921.56,288921.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216042',4177457,'2599','388',209778.91,209778.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216042',4177458,'2600','388',245778.19,246521.35,743.16,121135.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','216042',4177459,'2601','388',265339.76,265869.82,530.06,86399.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','216042',4177460,'2602','388',276958.83,276958.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216042',4177461,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216042',4177462,'2604','388',224635.34,224635.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216042',4177463,'2740','412',74046.38,74101.55,55.17,15999.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','216042',4177464,'2741','412',373784.36,374696.20,911.84,264433.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','216100',4178464,'2593','388',303768.26,305260.98,1472.72,240053.36,0.00,0.00,20.00,0.00,0.00),('1','171','877','216100',4178465,'2594','388',328824.47,328824.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216100',4178466,'2595','388',262808.67,263969.85,1161.18,189272.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','216100',4178467,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216100',4178468,'2597','388',261067.77,263011.22,1943.45,316782.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','216100',4178469,'2598','388',288921.56,288921.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216100',4178470,'2599','388',209778.91,209778.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216100',4178471,'2600','388',246521.35,247436.26,914.91,149130.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','216100',4178472,'2601','388',265869.82,265869.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216100',4178473,'2602','388',276958.83,277592.68,633.85,103317.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','216100',4178474,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216100',4178475,'2604','388',224635.34,224635.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216100',4178476,'2740','412',74101.55,74208.79,107.24,31099.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','216100',4178477,'2741','412',374696.20,375511.53,815.33,236445.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','216243',4180769,'2593','388',305260.98,305260.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216243',4180770,'2594','388',328824.47,328824.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216243',4180771,'2595','388',263969.85,264920.14,950.29,154897.27,0.00,0.00,0.00,0.00,0.00),('1','171','877','216243',4180772,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216243',4180773,'2597','388',263011.22,263011.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216243',4180774,'2598','388',288921.56,290095.33,1173.77,191324.51,0.00,0.00,0.00,0.00,0.00),('1','171','878','216243',4180775,'2599','388',209778.91,209778.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216243',4180776,'2600','388',247436.26,248468.17,1031.91,168201.33,0.00,0.00,0.00,0.00,0.00),('1','171','879','216243',4180777,'2601','388',265869.82,266636.51,766.69,124970.47,0.00,0.00,0.00,0.00,0.00),('1','171','879','216243',4180778,'2602','388',277592.68,277592.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216243',4180779,'2603','388',164111.43,164111.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216243',4180780,'2604','388',224635.34,224845.26,209.92,34216.96,0.00,0.00,0.00,0.00,0.00),('1','171','932','216243',4180781,'2740','412',74208.79,74290.51,81.72,23698.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','216243',4180782,'2741','412',375511.53,376287.48,775.95,225025.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','216338',4182426,'2593','388',305260.98,306359.60,1098.62,179075.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','216338',4182427,'2594','388',328824.47,328824.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216338',4182428,'2595','388',264920.14,264920.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216338',4182429,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216338',4182430,'2597','388',263011.22,265220.68,2209.46,360141.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','216338',4182431,'2598','388',290095.33,290095.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216338',4182432,'2599','388',209778.91,210819.80,1040.89,169665.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','216338',4182433,'2600','388',248468.17,248468.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216338',4182434,'2601','388',266636.51,267144.04,507.53,82727.39,0.00,0.00,0.00,0.00,0.00),('1','171','879','216338',4182435,'2602','388',277592.68,278748.31,1155.63,188367.69,0.00,0.00,0.00,0.00,0.00),('1','171','879','216338',4182436,'2603','388',164111.43,165156.44,1045.01,170336.63,0.00,0.00,0.00,0.00,0.00),('1','171','879','216338',4182437,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216338',4182438,'2740','412',74290.51,74290.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216338',4182439,'2741','412',376287.48,376580.72,293.24,85039.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','216451',4184419,'2593','388',306359.60,306359.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216451',4184420,'2594','388',328824.47,328824.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216451',4184421,'2595','388',264920.14,264920.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216451',4184422,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216451',4184423,'2597','388',265220.68,265220.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216451',4184424,'2598','388',290095.33,290467.81,372.48,60714.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','216451',4184425,'2599','388',210819.80,210819.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216451',4184426,'2600','388',248468.17,249799.86,1331.69,217065.47,0.00,0.00,0.00,0.00,0.00),('1','171','879','216451',4184427,'2601','388',267144.04,268122.60,978.56,159505.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','216451',4184428,'2602','388',278748.31,279162.59,414.28,67527.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','216451',4184429,'2603','388',165156.44,165880.19,723.75,117971.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','216451',4184430,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216451',4184431,'2740','412',74290.51,74290.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216451',4184432,'2741','412',376580.72,377058.19,477.47,138466.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','216567',4186367,'2593','388',306359.60,306359.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216567',4186368,'2594','388',328824.47,330119.50,1295.03,211089.89,0.00,0.00,0.00,0.00,0.00),('1','171','877','216567',4186369,'2595','388',264920.14,266376.59,1456.45,237401.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','216567',4186370,'2596','388',316328.38,316328.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216567',4186371,'2597','388',265220.68,266194.47,973.79,158727.77,0.00,0.00,0.00,0.00,0.00),('1','171','878','216567',4186372,'2598','388',290467.81,291368.11,900.30,146748.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','216567',4186373,'2599','388',210819.80,211593.24,773.44,126070.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','216567',4186374,'2600','388',249799.86,249799.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216567',4186375,'2601','388',268122.60,268122.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216567',4186376,'2602','388',279162.59,280082.67,920.08,149973.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','216567',4186377,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216567',4186378,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216567',4186379,'2740','412',74290.51,74495.33,204.82,59397.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','216567',4186380,'2741','412',377058.19,377746.39,688.20,199578.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216679',4188389,'2593','388',306359.60,307858.83,1499.23,244374.49,0.00,0.00,0.00,0.00,0.00),('1','171','877','216679',4188390,'2594','388',330119.50,330119.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216679',4188391,'2595','388',266376.59,266376.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216679',4188392,'2596','388',316328.38,317012.16,683.78,111456.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','216679',4188393,'2597','388',266194.47,266823.36,628.89,102509.07,0.00,0.00,0.00,0.00,0.00),('1','171','878','216679',4188394,'2598','388',291368.11,291368.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216679',4188395,'2599','388',211593.24,211593.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216679',4188396,'2600','388',249799.86,250416.80,616.94,100561.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','216679',4188397,'2601','388',268122.60,268994.00,871.40,142038.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','216679',4188398,'2602','388',280082.67,280082.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216679',4188399,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216679',4188400,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216679',4188401,'2740','412',74495.33,74495.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216679',4188402,'2741','412',377746.39,377956.05,209.66,60801.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','216798',4190565,'2593','388',307858.83,307858.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216798',4190566,'2594','388',330119.50,331490.82,1371.32,223525.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','216798',4190567,'2595','388',266376.59,266376.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216798',4190568,'2596','388',317012.16,318608.65,1596.49,260227.87,0.00,0.00,0.00,0.00,0.00),('1','171','878','216798',4190569,'2597','388',266823.36,267361.36,538.00,87694.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216798',4190570,'2598','388',291368.11,292639.48,1271.37,207233.31,0.00,0.00,0.00,0.00,0.00),('1','171','878','216798',4190571,'2599','388',211593.24,212553.65,960.41,156546.83,0.00,0.00,0.00,0.00,0.00),('1','171','878','216798',4190572,'2600','388',250416.80,250416.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216798',4190573,'2601','388',268994.00,268994.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216798',4190574,'2602','388',280082.67,280839.15,756.48,123306.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','216798',4190575,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216798',4190576,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216798',4190577,'2740','412',74495.33,74495.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216798',4190578,'2741','412',377956.05,377956.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216913',4192640,'2593','388',307858.83,307858.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','216913',4192641,'2594','388',331490.82,332636.40,1145.58,186729.54,0.00,0.00,0.00,0.00,0.00),('1','171','877','216913',4192642,'2595','388',266376.59,267158.69,782.10,127482.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','216913',4192643,'2596','388',318608.65,318608.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216913',4192644,'2597','388',267361.36,267361.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216913',4192645,'2598','388',292639.48,293659.45,1019.97,166255.11,0.00,0.00,0.00,0.00,0.00),('1','171','878','216913',4192646,'2599','388',212553.65,212553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','216913',4192647,'2600','388',250416.80,251273.35,856.55,139617.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','216913',4192648,'2601','388',268994.00,269960.65,966.65,157563.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','216913',4192649,'2602','388',280839.15,280839.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216913',4192650,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','216913',4192651,'2604','388',224845.26,224845.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216913',4192652,'2740','412',74495.33,74495.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','216913',4192653,'2741','412',377956.05,377956.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217027',4194529,'2593','388',307858.83,307858.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217027',4194530,'2594','388',332636.40,334387.14,1750.74,285370.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','217027',4194531,'2595','388',267158.69,267988.69,830.00,135290.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217027',4194532,'2596','388',318608.65,320413.47,1804.82,294185.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','217027',4194533,'2597','388',267361.36,268640.98,1279.62,208578.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','217027',4194534,'2598','388',293659.45,293659.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217027',4194535,'2599','388',212553.65,213448.55,894.90,145868.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','217027',4194536,'2600','388',251273.35,251273.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217027',4194537,'2601','388',269960.65,269960.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217027',4194538,'2602','388',280839.15,280839.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217027',4194539,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217027',4194540,'2604','388',224845.26,225863.96,1018.70,166048.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','217027',4194541,'2740','412',74495.33,74495.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217027',4194542,'2741','412',377956.05,377956.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217141',4196539,'2593','388',307858.83,307858.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217141',4196540,'2594','388',334387.14,335158.97,771.83,125808.29,0.00,0.00,0.00,0.00,0.00),('1','171','877','217141',4196541,'2595','388',267988.69,267988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217141',4196542,'2596','388',320413.47,321394.83,981.36,159961.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','217141',4196543,'2597','388',268640.98,268640.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217141',4196544,'2598','388',293659.45,294721.16,1061.71,173058.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','217141',4196545,'2599','388',213448.55,214328.94,880.39,143503.57,0.00,0.00,0.00,0.00,0.00),('1','171','878','217141',4196546,'2600','388',251273.35,251273.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217141',4196547,'2601','388',269960.65,270673.87,713.22,116254.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','217141',4196548,'2602','388',280839.15,280839.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217141',4196549,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217141',4196550,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217141',4196551,'2740','412',74495.33,74814.13,318.80,92452.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217141',4196552,'2741','412',377956.05,378726.74,770.69,223500.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','217302',4199681,'2593','388',307858.83,309202.64,1343.81,219041.03,0.00,0.00,0.00,0.00,0.00),('1','171','877','217302',4199682,'2594','388',335158.97,335863.97,705.00,114915.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217302',4199683,'2595','388',267988.69,269971.28,1982.59,323162.17,0.00,0.00,0.00,0.00,0.00),('1','171','877','217302',4199684,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217302',4199685,'2597','388',268640.98,270778.45,2120.47,345636.61,0.00,0.00,17.00,0.00,0.00),('1','171','878','217302',4199686,'2598','388',294721.16,294721.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217302',4199687,'2599','388',214328.94,214328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217302',4199688,'2600','388',251273.35,251402.17,128.82,20997.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','217302',4199689,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217302',4199690,'2602','388',280839.15,281933.19,1094.04,178328.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','217302',4199691,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217302',4199692,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217302',4199693,'2740','412',74814.13,74930.91,116.78,33866.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','217302',4199694,'2741','412',378726.74,379550.13,823.39,238783.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','217513',4203325,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217513',4203326,'2594','388',335863.97,336688.67,824.70,134426.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','217513',4203327,'2595','388',269971.28,270619.42,648.14,105646.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','217513',4203328,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217513',4203329,'2597','388',270778.45,271507.63,729.18,118856.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','217513',4203330,'2598','388',294721.16,294721.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217513',4203331,'2599','388',214328.94,214328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217513',4203332,'2600','388',251402.17,251743.37,341.20,55615.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','217513',4203333,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217513',4203334,'2602','388',281933.19,282419.97,486.78,79345.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','217513',4203335,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217513',4203336,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217513',4203337,'2740','412',74930.91,74930.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217513',4203338,'2741','412',379550.13,379713.46,163.33,47365.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','217644',4205837,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217644',4205838,'2594','388',336688.67,337118.06,429.39,69990.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','217644',4205839,'2595','388',270619.42,271048.81,429.39,69990.57,0.00,0.00,0.00,0.00,0.00),('1','171','877','217644',4205840,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217644',4205841,'2597','388',271507.63,271507.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217644',4205842,'2598','388',294721.16,294721.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217644',4205843,'2599','388',214328.94,214352.86,23.92,3898.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','217644',4205844,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217644',4205845,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217644',4205846,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217644',4205847,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217644',4205848,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217644',4205849,'2740','412',74930.91,74930.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217644',4205850,'2741','412',379713.46,379804.48,91.02,26395.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','217721',4206818,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217721',4206819,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217721',4206820,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217721',4206821,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217721',4206822,'2597','388',271507.63,271507.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217721',4206823,'2598','388',294721.16,294815.86,94.70,15436.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','217721',4206824,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217721',4206825,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217721',4206826,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217721',4206827,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217721',4206828,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217721',4206829,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217721',4206830,'2740','412',74930.91,74930.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217721',4206831,'2741','412',379804.48,380183.42,378.94,109892.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','217814',4208637,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217814',4208638,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217814',4208639,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217814',4208640,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217814',4208641,'2597','388',271507.63,271573.27,65.64,10699.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','217814',4208642,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217814',4208643,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217814',4208644,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217814',4208645,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217814',4208646,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217814',4208647,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217814',4208648,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217814',4208649,'2740','412',74930.91,74958.52,27.61,8006.90,0.00,0.00,0.00,0.00,0.00),('1','171','932','217814',4208650,'2741','412',380183.42,380688.42,505.00,146450.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217927',4210928,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217927',4210929,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217927',4210930,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217927',4210931,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217927',4210932,'2597','388',271573.27,271573.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217927',4210933,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217927',4210934,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217927',4210935,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217927',4210936,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217927',4210937,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217927',4210938,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217927',4210939,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217927',4210940,'2740','412',74958.52,74958.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217927',4210941,'2741','412',380688.42,381063.91,375.49,108892.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','217970',4211629,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217970',4211630,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217970',4211631,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','217970',4211632,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217970',4211633,'2597','388',271573.27,271573.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217970',4211634,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217970',4211635,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','217970',4211636,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217970',4211637,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217970',4211638,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217970',4211639,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','217970',4211640,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217970',4211641,'2740','412',74958.52,74958.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','217970',4211642,'2741','412',381063.91,381088.05,24.14,7000.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','218138',4214329,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218138',4214330,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218138',4214331,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218138',4214332,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218138',4214333,'2597','388',271573.27,271573.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218138',4214334,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218138',4214335,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218138',4214336,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218138',4214337,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218138',4214338,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218138',4214339,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218138',4214340,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218138',4214341,'2740','412',74958.52,74959.55,1.03,298.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','218138',4214342,'2741','412',381088.05,381301.81,213.76,61990.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','218177',4215100,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218177',4215101,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218177',4215102,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218177',4215103,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218177',4215104,'2597','388',271573.27,271573.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218177',4215105,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218177',4215106,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218177',4215107,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218177',4215108,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218177',4215109,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218177',4215110,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218177',4215111,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218177',4215112,'2740','412',74959.55,76836.65,1877.10,534973.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','218177',4215113,'2741','412',381301.81,381599.71,297.90,84901.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','218236',4215978,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218236',4215979,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218236',4215980,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218236',4215981,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218236',4215982,'2597','388',271573.27,271573.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218236',4215983,'2598','388',294815.86,294815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218236',4215984,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218236',4215985,'2600','388',251743.37,251743.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218236',4215986,'2601','388',270673.87,270673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218236',4215987,'2602','388',282419.97,282419.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218236',4215988,'2603','388',165880.19,165880.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218236',4215989,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218236',4215990,'2740','412',76836.65,76876.65,40.00,11400.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218236',4215991,'2741','412',381599.71,382309.85,710.14,202389.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','218383',4218695,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218383',4218696,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218383',4218697,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218383',4218698,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218383',4218699,'2597','388',271573.27,271668.66,95.39,15453.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','218383',4218700,'2598','388',294815.86,295241.64,425.78,68976.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','218383',4218701,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218383',4218702,'2600','388',251743.37,252001.99,258.62,41896.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','218383',4218703,'2601','388',270673.87,270913.35,239.48,38795.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','218383',4218704,'2602','388',282419.97,282589.14,169.17,27405.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','218383',4218705,'2603','388',165880.19,166182.23,302.04,48930.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','218383',4218706,'2604','388',225863.96,225863.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218383',4218707,'2740','412',76876.65,76971.56,94.91,27049.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','218383',4218708,'2741','412',382309.85,382669.96,360.11,102631.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','218465',4219967,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218465',4219968,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218465',4219969,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218465',4219970,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218465',4219971,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218465',4219972,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218465',4219973,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218465',4219974,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218465',4219975,'2601','388',270913.35,272470.43,1557.08,252246.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','218465',4219976,'2602','388',282589.14,284092.76,1503.62,243586.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','218465',4219977,'2603','388',166182.23,167160.65,978.42,158504.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','218465',4219978,'2604','388',225863.96,227502.03,1638.07,265367.34,0.00,0.00,0.00,0.00,0.00),('1','171','932','218465',4219979,'2740','412',76971.56,76971.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218465',4219980,'2741','412',382669.96,383133.07,463.11,131986.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','218575',4222172,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218575',4222173,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218575',4222174,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218575',4222175,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218575',4222176,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218575',4222177,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218575',4222178,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218575',4222179,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218575',4222180,'2601','388',272470.43,273303.09,832.66,134890.92,0.00,0.00,0.00,0.00,0.00),('1','171','879','218575',4222181,'2602','388',284092.76,285074.36,981.60,159019.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','218575',4222182,'2603','388',167160.65,167970.94,810.29,131266.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','218575',4222183,'2604','388',227502.03,228470.03,968.00,156816.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218575',4222184,'2740','412',76971.56,77186.56,215.00,61275.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218575',4222185,'2741','412',383133.07,383769.68,636.61,181433.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','218701',4224221,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218701',4224222,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218701',4224223,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218701',4224224,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218701',4224225,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218701',4224226,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218701',4224227,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218701',4224228,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218701',4224229,'2601','388',273303.09,275103.69,1800.60,291697.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','218701',4224230,'2602','388',285074.36,286364.33,1289.97,208975.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','218701',4224231,'2603','388',167970.94,169063.59,1072.65,173769.30,0.00,0.00,20.00,0.00,0.00),('1','171','879','218701',4224232,'2604','388',228470.03,230164.58,1694.55,274517.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','218701',4224233,'2740','412',77186.56,77263.76,77.20,22002.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218701',4224234,'2741','412',383769.68,384827.76,1058.08,301552.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','218816',4226370,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218816',4226371,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218816',4226372,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218816',4226373,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218816',4226374,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218816',4226375,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218816',4226376,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218816',4226377,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218816',4226378,'2601','388',275103.69,276080.31,976.62,158212.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','218816',4226379,'2602','388',286364.33,287539.12,1174.79,190315.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','218816',4226380,'2603','388',169063.59,169836.61,773.02,125229.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','218816',4226381,'2604','388',230164.58,230922.19,757.61,122732.82,0.00,0.00,0.00,0.00,0.00),('1','171','932','218816',4226382,'2740','412',77263.76,77363.76,100.00,28500.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218816',4226383,'2741','412',384827.76,385043.46,215.70,61474.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','218923',4228163,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218923',4228164,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218923',4228165,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','218923',4228166,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218923',4228167,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218923',4228168,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218923',4228169,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','218923',4228170,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','218923',4228171,'2601','388',276080.31,277528.20,1447.89,234558.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','218923',4228172,'2602','388',287539.12,289243.46,1704.34,276103.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','218923',4228173,'2603','388',169836.61,171573.05,1736.44,281303.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','218923',4228174,'2604','388',230922.19,232481.82,1559.63,252660.06,0.00,0.00,0.00,0.00,0.00),('1','171','932','218923',4228175,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','218923',4228176,'2741','412',385043.46,385368.12,324.66,92528.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','219018',4229721,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219018',4229722,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219018',4229723,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219018',4229724,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219018',4229725,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219018',4229726,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219018',4229727,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219018',4229728,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219018',4229729,'2601','388',277528.20,278184.71,656.51,106354.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','219018',4229730,'2602','388',289243.46,290600.43,1356.97,219829.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','219018',4229731,'2603','388',171573.05,172502.19,929.14,150520.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','219018',4229732,'2604','388',232481.82,233682.25,1200.43,194469.66,0.00,0.00,0.00,0.00,0.00),('1','171','932','219018',4229733,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219018',4229734,'2741','412',385368.12,385945.41,577.29,164527.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','219137',4231764,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219137',4231765,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219137',4231766,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219137',4231767,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219137',4231768,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219137',4231769,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219137',4231770,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219137',4231771,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219137',4231772,'2601','388',278184.71,280082.65,1897.94,307466.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','219137',4231773,'2602','388',290600.43,292452.88,1852.45,300096.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','219137',4231774,'2603','388',172502.19,173777.41,1275.22,206585.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','219137',4231775,'2604','388',233682.25,235325.09,1642.84,266140.08,0.00,0.00,0.00,0.00,0.00),('1','171','932','219137',4231776,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219137',4231777,'2741','412',385945.41,386332.61,387.20,110352.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219239',4233561,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219239',4233562,'2594','388',337118.06,337118.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219239',4233563,'2595','388',271048.81,271048.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219239',4233564,'2596','388',321394.83,321394.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219239',4233565,'2597','388',271668.66,271668.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219239',4233566,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219239',4233567,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219239',4233568,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219239',4233569,'2601','388',280082.65,280945.32,862.67,139752.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','219239',4233570,'2602','388',292452.88,293222.64,769.76,124701.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','219239',4233571,'2603','388',173777.41,174083.49,306.08,49584.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','219239',4233572,'2604','388',235325.09,236169.01,843.92,136715.04,0.00,0.00,0.00,0.00,0.00),('1','171','932','219239',4233573,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219239',4233574,'2741','412',386332.61,386475.77,143.16,40800.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','219348',4235433,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219348',4235434,'2594','388',337118.06,337896.97,778.91,126183.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','219348',4235435,'2595','388',271048.81,271805.49,756.68,122582.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','219348',4235436,'2596','388',321394.83,321404.24,9.41,1524.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','219348',4235437,'2597','388',271668.66,272261.37,592.71,96019.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','219348',4235438,'2598','388',295241.64,295241.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219348',4235439,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219348',4235440,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219348',4235441,'2601','388',280945.32,282205.22,1259.90,204103.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','219348',4235442,'2602','388',293222.64,294096.38,873.74,141545.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','219348',4235443,'2603','388',174083.49,174591.90,508.41,82362.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','219348',4235444,'2604','388',236169.01,237296.20,1127.19,182604.78,0.00,0.00,0.00,0.00,0.00),('1','171','932','219348',4235445,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219348',4235446,'2741','412',386475.77,387852.52,1376.75,392373.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','219489',4237931,'2593','388',309202.64,309202.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219489',4237932,'2594','388',337896.97,338312.96,415.99,67390.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','219489',4237933,'2595','388',271805.49,273254.65,1449.16,234763.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','219489',4237934,'2596','388',321404.24,321404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219489',4237935,'2597','388',272261.37,272261.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219489',4237936,'2598','388',295241.64,296635.96,1394.32,225879.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','219489',4237937,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219489',4237938,'2600','388',252001.99,252001.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219489',4237939,'2601','388',282205.22,283186.67,981.45,158994.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','219489',4237940,'2602','388',294096.38,294099.46,3.08,498.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','219489',4237941,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219489',4237942,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219489',4237943,'2740','412',77363.76,77363.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219489',4237944,'2741','412',387852.52,388746.24,893.72,254710.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','219616',4239942,'2593','388',309202.64,310730.12,1527.48,247451.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','219616',4239943,'2594','388',338312.96,339320.55,1007.59,163229.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','219616',4239944,'2595','388',273254.65,273254.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219616',4239945,'2596','388',321404.24,323093.32,1689.08,273630.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','219616',4239946,'2597','388',272261.37,273468.78,1207.41,195600.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','219616',4239947,'2598','388',296635.96,296635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219616',4239948,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219616',4239949,'2600','388',252001.99,253016.76,1014.77,164392.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','219616',4239950,'2601','388',283186.67,283186.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219616',4239951,'2602','388',294099.46,295167.15,1067.69,172965.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','219616',4239952,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219616',4239953,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219616',4239954,'2740','412',77363.76,77527.71,163.95,46725.75,0.00,0.00,0.00,0.00,0.00),('1','171','932','219616',4239955,'2741','412',388746.24,390082.91,1336.67,380950.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','219755',4242820,'2593','388',310730.12,310730.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219755',4242821,'2594','388',339320.55,340076.39,755.84,122446.08,0.00,0.00,0.00,0.00,0.00),('1','171','877','219755',4242822,'2595','388',273254.65,274518.24,1263.59,204701.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','219755',4242823,'2596','388',323093.32,323093.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219755',4242824,'2597','388',273468.78,274527.55,1058.77,171520.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','219755',4242825,'2598','388',296635.96,296635.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219755',4242826,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219755',4242827,'2600','388',253016.76,253016.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219755',4242828,'2601','388',283186.67,283186.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219755',4242829,'2602','388',295167.15,295734.48,567.33,91907.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','219755',4242830,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219755',4242831,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219755',4242832,'2740','412',77527.71,77527.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219755',4242833,'2741','412',390082.91,390605.03,522.12,148804.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','219833',4243961,'2593','388',310730.12,311757.00,1026.88,166354.56,0.00,0.00,0.00,0.00,0.00),('1','171','877','219833',4243962,'2594','388',340076.39,341091.51,1015.12,164449.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','219833',4243963,'2595','388',274518.24,274518.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219833',4243964,'2596','388',323093.32,324263.14,1169.82,189510.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','219833',4243965,'2597','388',274527.55,274527.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219833',4243966,'2598','388',296635.96,297622.46,986.50,159813.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219833',4243967,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219833',4243968,'2600','388',253016.76,254049.75,1032.99,167344.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','219833',4243969,'2601','388',283186.67,284005.29,818.62,132616.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','219833',4243970,'2602','388',295734.48,295734.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219833',4243971,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219833',4243972,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219833',4243973,'2740','412',77527.71,77527.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219833',4243974,'2741','412',390605.03,391515.11,910.08,259372.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','219952',4246341,'2593','388',311757.00,311757.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','219952',4246342,'2594','388',341091.51,342245.40,1153.89,186930.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','219952',4246343,'2595','388',274518.24,274849.46,331.22,53657.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','219952',4246344,'2596','388',324263.14,324263.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219952',4246345,'2597','388',274527.55,274527.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219952',4246346,'2598','388',297622.46,299111.66,1489.20,241250.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','219952',4246347,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','219952',4246348,'2600','388',254049.75,254049.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219952',4246349,'2601','388',284005.29,284665.67,660.38,106981.56,0.00,0.00,0.00,0.00,0.00),('1','171','879','219952',4246350,'2602','388',295734.48,295734.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219952',4246351,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','219952',4246352,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219952',4246353,'2740','412',77527.71,77527.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','219952',4246354,'2741','412',391515.11,392574.10,1058.99,301812.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','220059',4248066,'2593','388',311757.00,313623.35,1866.35,302348.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','220059',4248067,'2594','388',342245.40,342245.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220059',4248068,'2595','388',274849.46,276013.66,1164.20,188600.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','220059',4248069,'2596','388',324263.14,325765.09,1501.95,243315.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','220059',4248070,'2597','388',274527.55,275632.92,1105.37,179069.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','220059',4248071,'2598','388',299111.66,299111.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220059',4248072,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220059',4248073,'2600','388',254049.75,254991.68,941.93,152592.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','220059',4248074,'2601','388',284665.67,284665.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220059',4248075,'2602','388',295734.48,296355.65,621.17,100629.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','220059',4248076,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220059',4248077,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220059',4248078,'2740','412',77527.71,77666.71,139.00,39615.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220059',4248079,'2741','412',392574.10,393018.92,444.82,126773.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','220155',4249828,'2593','388',313623.35,313623.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220155',4249829,'2594','388',342245.40,342685.87,440.47,71356.14,0.00,0.00,0.00,0.00,0.00),('1','171','877','220155',4249830,'2595','388',276013.66,276893.81,880.15,142584.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','220155',4249831,'2596','388',325765.09,325765.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220155',4249832,'2597','388',275632.92,275632.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220155',4249833,'2598','388',299111.66,300520.74,1409.08,228270.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','220155',4249834,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220155',4249835,'2600','388',254991.68,254991.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220155',4249836,'2601','388',284665.67,284665.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220155',4249837,'2602','388',296355.65,297236.94,881.29,142768.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','220155',4249838,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220155',4249839,'2604','388',237296.20,237296.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220155',4249840,'2740','412',77666.71,77666.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220155',4249841,'2741','412',393018.92,393520.30,501.38,142893.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','220268',4251681,'2593','388',313623.35,315478.07,1854.72,300464.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','220268',4251682,'2594','388',342685.87,343755.62,1069.75,173299.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','220268',4251683,'2595','388',276893.81,276893.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220268',4251684,'2596','388',325765.09,327487.89,1722.80,279093.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','220268',4251685,'2597','388',275632.92,277472.21,1839.29,297964.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','220268',4251686,'2598','388',300520.74,300520.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220268',4251687,'2599','388',214352.86,214352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220268',4251688,'2600','388',254991.68,254991.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220268',4251689,'2601','388',284665.67,285619.71,954.04,154554.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','220268',4251690,'2602','388',297236.94,297236.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220268',4251691,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220268',4251692,'2604','388',237296.20,237342.49,46.29,7498.98,0.00,0.00,0.00,0.00,0.00),('1','171','932','220268',4251693,'2740','412',77666.71,77985.05,318.34,90726.90,0.00,0.00,0.00,0.00,0.00),('1','171','932','220268',4251694,'2741','412',393520.30,394824.18,1303.88,371605.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','220384',4253992,'2593','388',315478.07,315478.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220384',4253993,'2594','388',343755.62,344945.88,1190.26,192822.12,0.00,0.00,0.00,0.00,0.00),('1','171','877','220384',4253994,'2595','388',276893.81,277957.01,1063.20,172238.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','220384',4253995,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220384',4253996,'2597','388',277472.21,277472.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220384',4253997,'2598','388',300520.74,301495.46,974.72,157904.64,0.00,0.00,0.00,0.00,0.00),('1','171','878','220384',4253998,'2599','388',214352.86,215219.46,866.60,140389.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','220384',4253999,'2600','388',254991.68,254991.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220384',4254000,'2601','388',285619.71,285619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220384',4254001,'2602','388',297236.94,297261.64,24.70,4001.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','220384',4254002,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220384',4254003,'2604','388',237342.49,237342.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220384',4254004,'2740','412',77985.05,78056.98,71.93,20500.05,0.00,0.00,0.00,0.00,0.00),('1','171','932','220384',4254005,'2741','412',394824.18,395162.81,338.63,96509.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','220486',4255733,'2593','388',315478.07,316976.79,1498.72,242792.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','220486',4255734,'2594','388',344945.88,344945.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220486',4255735,'2595','388',277957.01,279603.31,1646.30,266700.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','220486',4255736,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220486',4255737,'2597','388',277472.21,279740.84,2268.63,367518.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','220486',4255738,'2598','388',301495.46,301495.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220486',4255739,'2599','388',215219.46,215219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220486',4255740,'2600','388',254991.68,256529.67,1537.99,249154.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','220486',4255741,'2601','388',285619.71,285619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220486',4255742,'2602','388',297261.64,297261.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220486',4255743,'2603','388',174591.90,174591.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220486',4255744,'2604','388',237342.49,237342.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220486',4255745,'2740','412',78056.98,78240.58,183.60,52326.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220486',4255746,'2741','412',395162.81,396342.89,1180.08,336322.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','220594',4257698,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220594',4257699,'2594','388',344945.88,344945.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220594',4257700,'2595','388',279603.31,279603.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220594',4257701,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220594',4257702,'2597','388',279740.84,279740.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220594',4257703,'2598','388',301495.46,302235.66,740.20,119912.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','220594',4257704,'2599','388',215219.46,215219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220594',4257705,'2600','388',256529.67,256996.80,467.13,75675.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','220594',4257706,'2601','388',285619.71,285619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220594',4257707,'2602','388',297261.64,298197.05,935.41,151536.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','220594',4257708,'2603','388',174591.90,175052.50,460.60,74617.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','220594',4257709,'2604','388',237342.49,237342.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220594',4257710,'2740','412',78240.58,78299.96,59.38,16923.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','220594',4257711,'2741','412',396342.89,397157.81,814.92,232252.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','220703',4259446,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220703',4259447,'2594','388',344945.88,344945.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220703',4259448,'2595','388',279603.31,279603.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220703',4259449,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220703',4259450,'2597','388',279740.84,281638.93,1898.09,307490.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','220703',4259451,'2598','388',302235.66,303131.39,895.73,145108.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','220703',4259452,'2599','388',215219.46,217259.30,2039.84,330454.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','220703',4259453,'2600','388',256996.80,257662.57,665.77,107854.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','220703',4259454,'2601','388',285619.71,286992.25,1372.54,222351.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','220703',4259455,'2602','388',298197.05,298197.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220703',4259456,'2603','388',175052.50,176239.50,1187.00,192294.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220703',4259457,'2604','388',237342.49,237342.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220703',4259458,'2740','412',78299.96,78299.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220703',4259459,'2741','412',397157.81,397808.25,650.44,185375.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','220800',4261081,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220800',4261082,'2594','388',344945.88,344945.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220800',4261083,'2595','388',279603.31,279603.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220800',4261084,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220800',4261085,'2597','388',281638.93,281638.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220800',4261086,'2598','388',303131.39,303151.15,19.76,3201.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','220800',4261087,'2599','388',217259.30,218496.12,1236.82,200364.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','220800',4261088,'2600','388',257662.57,257662.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220800',4261089,'2601','388',286992.25,286992.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220800',4261090,'2602','388',298197.05,299509.42,1312.37,212603.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','220800',4261091,'2603','388',176239.50,176239.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220800',4261092,'2604','388',237342.49,238103.15,760.66,123226.92,0.00,0.00,0.00,0.00,0.00),('1','171','932','220800',4261093,'2740','412',78299.96,78299.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220800',4261094,'2741','412',397808.25,397967.87,159.62,45491.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','220879',4262897,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220879',4262898,'2594','388',344945.88,344945.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220879',4262899,'2595','388',279603.31,279603.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','220879',4262900,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220879',4262901,'2597','388',281638.93,281638.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220879',4262902,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220879',4262903,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','220879',4262904,'2600','388',257662.57,259811.50,2148.93,348126.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','220879',4262905,'2601','388',286992.25,288459.34,1467.09,237668.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','220879',4262906,'2602','388',299509.42,299509.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','220879',4262907,'2603','388',176239.50,178247.75,2008.25,325336.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','220879',4262908,'2604','388',238103.15,239149.82,1046.67,169560.54,0.00,0.00,0.00,0.00,0.00),('1','171','932','220879',4262909,'2740','412',78299.96,78424.96,125.00,35625.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','220879',4262910,'2741','412',397967.87,399173.33,1205.46,343556.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','221054',4265740,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221054',4265741,'2594','388',344945.88,347331.62,2385.74,386489.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','221054',4265742,'2595','388',279603.31,281262.53,1639.22,265553.64,0.00,0.00,20.00,0.00,0.00),('1','171','877','221054',4265743,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221054',4265744,'2597','388',281638.93,281902.14,263.21,42640.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','221054',4265745,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221054',4265746,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221054',4265747,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221054',4265748,'2601','388',288459.34,289008.55,549.21,88972.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','221054',4265749,'2602','388',299509.42,299509.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221054',4265750,'2603','388',178247.75,178247.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221054',4265751,'2604','388',239149.82,239149.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221054',4265752,'2740','412',78424.96,80026.16,1601.20,456342.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221054',4265753,'2741','412',399173.33,400840.14,1666.81,475040.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','221164',4267585,'2593','388',316976.79,316976.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221164',4267586,'2594','388',347331.62,349309.74,1978.12,320455.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','221164',4267587,'2595','388',281262.53,282736.92,1474.39,238851.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','221164',4267588,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221164',4267589,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221164',4267590,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221164',4267591,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221164',4267592,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221164',4267593,'2601','388',289008.55,289008.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221164',4267594,'2602','388',299509.42,300638.38,1128.96,182891.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','221164',4267595,'2603','388',178247.75,178247.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221164',4267596,'2604','388',239149.82,240474.91,1325.09,214664.58,0.00,0.00,0.00,0.00,0.00),('1','171','932','221164',4267597,'2740','412',80026.16,80691.35,665.19,189579.15,0.00,0.00,0.00,0.00,0.00),('1','171','932','221164',4267598,'2741','412',400840.14,401264.41,424.27,120916.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','221284',4269749,'2593','388',316976.79,318815.48,1838.69,297867.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','221284',4269750,'2594','388',349309.74,349309.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221284',4269751,'2595','388',282736.92,282736.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221284',4269752,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221284',4269753,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221284',4269754,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221284',4269755,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221284',4269756,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221284',4269757,'2601','388',289008.55,290305.88,1297.33,210167.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','221284',4269758,'2602','388',300638.38,300638.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221284',4269759,'2603','388',178247.75,178247.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221284',4269760,'2604','388',240474.91,241167.77,692.86,112243.32,0.00,0.00,0.00,0.00,0.00),('1','171','932','221284',4269761,'2740','412',80691.35,81288.21,596.86,170105.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','221284',4269762,'2741','412',401264.41,401811.87,547.46,156026.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','221414',4272122,'2593','388',318815.48,318815.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221414',4272123,'2594','388',349309.74,350882.88,1573.14,254848.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','221414',4272124,'2595','388',282736.92,286434.48,3697.56,599004.72,0.00,0.00,0.00,0.00,0.00),('1','171','877','221414',4272125,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221414',4272126,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221414',4272127,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221414',4272128,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221414',4272129,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221414',4272130,'2601','388',290305.88,290305.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221414',4272131,'2602','388',300638.38,301782.79,1144.41,185394.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','221414',4272132,'2603','388',178247.75,179435.24,1187.49,192373.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','221414',4272133,'2604','388',241167.77,241167.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221414',4272134,'2740','412',81288.21,81288.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221414',4272135,'2741','412',401811.87,402647.31,835.44,238100.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','221556',4274923,'2593','388',318815.48,319480.02,664.54,107655.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','221556',4274924,'2594','388',350882.88,350882.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221556',4274925,'2595','388',286434.48,286909.35,474.87,76928.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','221556',4274926,'2596','388',327487.89,327487.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221556',4274927,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221556',4274928,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221556',4274929,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221556',4274930,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221556',4274931,'2601','388',290305.88,290305.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221556',4274932,'2602','388',301782.79,302399.64,616.85,99929.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','221556',4274933,'2603','388',179435.24,179435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221556',4274934,'2604','388',241167.77,241629.87,462.10,74860.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','221556',4274935,'2740','412',81288.21,81587.89,299.68,85408.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','221556',4274936,'2741','412',402647.31,402763.40,116.09,33085.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','221633',4276193,'2593','388',319480.02,319856.43,376.41,60978.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','221633',4276194,'2594','388',350882.88,352740.78,1857.90,300979.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','221633',4276195,'2595','388',286909.35,287216.94,307.59,49829.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','221633',4276196,'2596','388',327487.89,329028.75,1540.86,249619.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','221633',4276197,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221633',4276198,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221633',4276199,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221633',4276200,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221633',4276201,'2601','388',290305.88,291990.23,1684.35,272864.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','221633',4276202,'2602','388',302399.64,302399.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221633',4276203,'2603','388',179435.24,180114.98,679.74,110117.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','221633',4276204,'2604','388',241629.87,241629.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221633',4276205,'2740','412',81587.89,81647.89,60.00,17100.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221633',4276206,'2741','412',402763.40,404135.63,1372.23,391085.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','221762',4278631,'2593','388',319856.43,320342.48,486.05,78740.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','221762',4278632,'2594','388',352740.78,352740.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221762',4278633,'2595','388',287216.94,288689.38,1472.44,238535.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','221762',4278634,'2596','388',329028.75,329028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221762',4278635,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221762',4278636,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221762',4278637,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221762',4278638,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221762',4278639,'2601','388',291990.23,293192.00,1201.77,194686.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','221762',4278640,'2602','388',302399.64,302399.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221762',4278641,'2603','388',180114.98,180114.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221762',4278642,'2604','388',241629.87,242371.12,741.25,120082.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','221762',4278643,'2740','412',81647.89,81859.57,211.68,60328.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','221762',4278644,'2741','412',404135.63,404563.75,428.12,122014.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','221849',4279974,'2593','388',320342.48,321437.48,1095.00,177390.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221849',4279975,'2594','388',352740.78,354442.43,1701.65,275667.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','221849',4279976,'2595','388',288689.38,288689.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221849',4279977,'2596','388',329028.75,331600.27,2571.52,416586.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','221849',4279978,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221849',4279979,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221849',4279980,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221849',4279981,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221849',4279982,'2601','388',293192.00,293192.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221849',4279983,'2602','388',302399.64,303958.85,1559.21,252592.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','221849',4279984,'2603','388',180114.98,181668.45,1553.47,251662.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','221849',4279985,'2604','388',242371.12,242371.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221849',4279986,'2740','412',81859.57,82006.95,147.38,42003.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','221849',4279987,'2741','412',404563.75,405399.39,835.64,238157.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','221983',4282505,'2593','388',321437.48,321437.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221983',4282506,'2594','388',354442.43,355093.32,650.89,105444.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','221983',4282507,'2595','388',288689.38,288689.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','221983',4282508,'2596','388',331600.27,332945.19,1344.92,217877.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','221983',4282509,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221983',4282510,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221983',4282511,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','221983',4282512,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221983',4282513,'2601','388',293192.00,294579.63,1387.63,224796.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','221983',4282514,'2602','388',303958.85,303958.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221983',4282515,'2603','388',181668.45,181668.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','221983',4282516,'2604','388',242371.12,243173.09,801.97,129919.14,0.00,0.00,0.00,0.00,0.00),('1','171','932','221983',4282517,'2740','412',82006.95,82006.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','221983',4282518,'2741','412',405399.39,405652.39,253.00,72105.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222076',4284186,'2593','388',321437.48,323988.60,2551.12,413281.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','222076',4284187,'2594','388',355093.32,356214.30,1120.98,181598.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','222076',4284188,'2595','388',288689.38,290633.88,1944.50,315009.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222076',4284189,'2596','388',332945.19,332945.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222076',4284190,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222076',4284191,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222076',4284192,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222076',4284193,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222076',4284194,'2601','388',294579.63,294579.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222076',4284195,'2602','388',303958.85,306325.43,2366.58,383385.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','222076',4284196,'2603','388',181668.45,182761.88,1093.43,177135.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','222076',4284197,'2604','388',243173.09,243173.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222076',4284198,'2740','412',82006.95,82147.11,140.16,39945.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','222076',4284199,'2741','412',405652.39,406516.45,864.06,246257.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','222173',4285817,'2593','388',323988.60,324347.50,358.90,58141.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','222173',4285818,'2594','388',356214.30,356214.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222173',4285819,'2595','388',290633.88,290633.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222173',4285820,'2596','388',332945.19,334882.16,1936.97,313789.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','222173',4285821,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222173',4285822,'2598','388',303151.15,303151.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222173',4285823,'2599','388',218496.12,218496.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222173',4285824,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222173',4285825,'2601','388',294579.63,295209.65,630.02,102063.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','222173',4285826,'2602','388',306325.43,306325.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222173',4285827,'2603','388',182761.88,182761.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222173',4285828,'2604','388',243173.09,243834.75,661.66,107188.92,0.00,0.00,0.00,0.00,0.00),('1','171','932','222173',4285829,'2740','412',82147.11,82241.32,94.21,26849.85,0.00,0.00,0.00,0.00,0.00),('1','171','932','222173',4285830,'2741','412',406516.45,407055.15,538.70,153529.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','222268',4287479,'2593','388',324347.50,325347.50,1000.00,162000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222268',4287480,'2594','388',356214.30,356438.02,223.72,36242.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','222268',4287481,'2595','388',290633.88,292257.49,1623.61,263024.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','222268',4287482,'2596','388',334882.16,334882.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222268',4287483,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222268',4287484,'2598','388',303151.15,304458.63,1307.48,211811.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','222268',4287485,'2599','388',218496.12,219388.29,892.17,144531.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','222268',4287486,'2600','388',259811.50,259811.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222268',4287487,'2601','388',295209.65,295612.26,402.61,65222.82,0.00,0.00,0.00,0.00,0.00),('1','171','879','222268',4287488,'2602','388',306325.43,306325.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222268',4287489,'2603','388',182761.88,184402.65,1640.77,265804.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','222268',4287490,'2604','388',243834.75,243834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222268',4287491,'2740','412',82241.32,82241.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222268',4287492,'2741','412',407055.15,407286.30,231.15,65877.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','222384',4289279,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222384',4289280,'2594','388',356438.02,357213.65,775.63,125652.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','222384',4289281,'2595','388',292257.49,292257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222384',4289282,'2596','388',334882.16,335393.01,510.85,82757.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','222384',4289283,'2597','388',281902.14,281902.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222384',4289284,'2598','388',304458.63,305736.90,1278.27,207079.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','222384',4289285,'2599','388',219388.29,219388.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222384',4289286,'2600','388',259811.50,260409.24,597.74,96833.88,0.00,0.00,0.00,0.00,0.00),('1','171','879','222384',4289287,'2601','388',295612.26,295612.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222384',4289288,'2602','388',306325.43,306325.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222384',4289289,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222384',4289290,'2604','388',243834.75,243834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222384',4289291,'2740','412',82241.32,82241.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222384',4289292,'2741','412',407286.30,407367.11,80.81,23030.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','222483',4291227,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222483',4291228,'2594','388',357213.65,357923.81,710.16,115045.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','222483',4291229,'2595','388',292257.49,295121.71,2864.22,464003.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','222483',4291230,'2596','388',335393.01,335393.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222483',4291231,'2597','388',281902.14,283264.42,1362.28,220689.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','222483',4291232,'2598','388',305736.90,305736.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222483',4291233,'2599','388',219388.29,219388.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222483',4291234,'2600','388',260409.24,261630.03,1220.79,197767.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','222483',4291235,'2601','388',295612.26,295612.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222483',4291236,'2602','388',306325.43,306325.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222483',4291237,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222483',4291238,'2604','388',243834.75,243834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222483',4291239,'2740','412',82241.32,82285.53,44.21,12599.85,0.00,0.00,0.00,0.00,0.00),('1','171','932','222483',4291240,'2741','412',407367.11,408090.03,722.92,206032.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','222644',4293990,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222644',4293991,'2594','388',357923.81,358071.54,147.73,23932.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','222644',4293992,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222644',4293993,'2596','388',335393.01,335393.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222644',4293994,'2597','388',283264.42,283950.42,686.00,111132.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222644',4293995,'2598','388',305736.90,307282.68,1545.78,250416.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','222644',4293996,'2599','388',219388.29,219675.67,287.38,46555.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','222644',4293997,'2600','388',261630.03,262691.02,1060.99,171880.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','222644',4293998,'2601','388',295612.26,295612.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222644',4293999,'2602','388',306325.43,306325.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222644',4294000,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222644',4294001,'2604','388',243834.75,243834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222644',4294002,'2740','412',82285.53,82738.95,453.42,129224.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','222644',4294003,'2741','412',408090.03,408557.28,467.25,133166.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','222740',4295883,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222740',4295884,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222740',4295885,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222740',4295886,'2596','388',335393.01,335558.82,165.81,26861.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','222740',4295887,'2597','388',283950.42,283950.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222740',4295888,'2598','388',307282.68,309031.42,1748.74,283295.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','222740',4295889,'2599','388',219675.67,221041.93,1361.61,220580.82,0.00,0.00,4.65,0.00,0.00),('1','171','878','222740',4295890,'2600','388',262691.02,265066.37,2375.35,384806.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','222740',4295891,'2601','388',295612.26,295612.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222740',4295892,'2602','388',306325.43,307792.59,1447.16,234439.92,0.00,0.00,20.00,0.00,0.00),('1','171','879','222740',4295893,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222740',4295894,'2604','388',243834.75,244631.25,796.50,129033.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222740',4295895,'2740','412',82738.95,82805.62,66.67,19000.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','222740',4295896,'2741','412',408557.28,409186.73,629.45,179393.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','222839',4297634,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222839',4297635,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222839',4297636,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222839',4297637,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222839',4297638,'2597','388',283950.42,284696.63,746.21,120886.02,0.00,0.00,0.00,0.00,0.00),('1','171','878','222839',4297639,'2598','388',309031.42,309031.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222839',4297640,'2599','388',221041.93,221041.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222839',4297641,'2600','388',265066.37,267055.39,1989.02,322221.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','222839',4297642,'2601','388',295612.26,295612.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222839',4297643,'2602','388',307792.59,308736.54,943.95,152919.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','222839',4297644,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222839',4297645,'2604','388',244631.25,245152.73,521.48,84479.76,0.00,0.00,0.00,0.00,0.00),('1','171','932','222839',4297646,'2740','412',82805.62,82805.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222839',4297647,'2741','412',409186.73,409886.18,699.45,199343.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','222939',4299665,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222939',4299666,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222939',4299667,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','222939',4299668,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','222939',4299669,'2597','388',284696.63,285890.83,1194.20,193460.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','222939',4299670,'2598','388',309031.42,310961.72,1930.30,312708.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','222939',4299671,'2599','388',221041.93,222795.52,1753.59,284081.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','222939',4299672,'2600','388',267055.39,267055.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222939',4299673,'2601','388',295612.26,297047.56,1435.30,232518.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','222939',4299674,'2602','388',308736.54,308736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222939',4299675,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','222939',4299676,'2604','388',245152.73,246039.60,886.87,143672.94,0.00,0.00,0.00,0.00,0.00),('1','171','932','222939',4299677,'2740','412',82805.62,82805.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','222939',4299678,'2741','412',409886.18,410870.97,984.79,280665.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','223080',4302255,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223080',4302256,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223080',4302257,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223080',4302258,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223080',4302259,'2597','388',285890.83,285890.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223080',4302260,'2598','388',310961.72,312400.63,1438.91,233103.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','223080',4302261,'2599','388',222795.52,222795.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223080',4302262,'2600','388',267055.39,267590.37,534.98,86666.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','223080',4302263,'2601','388',297047.56,297403.87,356.31,57722.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','223080',4302264,'2602','388',308736.54,308736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223080',4302265,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223080',4302266,'2604','388',246039.60,246726.20,686.60,111229.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','223080',4302267,'2740','412',82805.62,82805.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223080',4302268,'2741','412',410870.97,411558.33,687.36,195897.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','223185',4303805,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223185',4303806,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223185',4303807,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223185',4303808,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223185',4303809,'2597','388',285890.83,285890.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223185',4303810,'2598','388',312400.63,312400.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223185',4303811,'2599','388',222795.52,225037.41,2241.89,363186.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','223185',4303812,'2600','388',267590.37,268289.44,699.07,113249.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','223185',4303813,'2601','388',297403.87,298102.94,699.07,113249.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','223185',4303814,'2602','388',308736.54,311023.01,2286.47,370408.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','223185',4303815,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223185',4303816,'2604','388',246726.20,247622.92,896.72,145268.64,0.00,0.00,0.00,0.00,0.00),('1','171','932','223185',4303817,'2740','412',82805.62,84627.82,1822.20,519327.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223185',4303818,'2741','412',411558.33,412281.48,723.15,206097.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','223307',4305608,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223307',4305609,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223307',4305610,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223307',4305611,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223307',4305612,'2597','388',285890.83,287055.88,1165.05,188738.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','223307',4305613,'2598','388',312400.63,312879.03,478.40,77500.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','223307',4305614,'2599','388',225037.41,225037.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223307',4305615,'2600','388',268289.44,269753.15,1463.71,237121.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','223307',4305616,'2601','388',298102.94,298102.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223307',4305617,'2602','388',311023.01,311023.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223307',4305618,'2603','388',184402.65,184402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223307',4305619,'2604','388',247622.92,248017.29,394.37,63887.94,0.00,0.00,0.00,0.00,0.00),('1','171','932','223307',4305620,'2740','412',84627.82,84627.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223307',4305621,'2741','412',412281.48,412969.13,687.65,195980.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','223422',4307979,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223422',4307980,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223422',4307981,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223422',4307982,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223422',4307983,'2597','388',287055.88,287225.33,169.45,27450.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','223422',4307984,'2598','388',312879.03,314460.65,1581.62,256222.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','223422',4307985,'2599','388',225037.41,225168.27,130.86,21199.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','223422',4307986,'2600','388',269753.15,271673.41,1920.26,311082.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','223422',4307987,'2601','388',298102.94,299368.06,1265.12,204949.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','223422',4307988,'2602','388',311023.01,312081.47,1058.46,171470.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','223422',4307989,'2603','388',184402.65,185313.51,910.86,147559.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','223422',4307990,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223422',4307991,'2740','412',84627.82,84958.70,330.88,94300.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','223422',4307992,'2741','412',412969.13,414036.25,1067.12,304129.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','223537',4309904,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223537',4309905,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223537',4309906,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223537',4309907,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223537',4309908,'2597','388',287225.33,288129.43,904.10,146464.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','223537',4309909,'2598','388',314460.65,315594.88,1134.23,183745.26,0.00,0.00,0.00,0.00,0.00),('1','171','878','223537',4309910,'2599','388',225168.27,226280.81,1112.54,180231.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','223537',4309911,'2600','388',271673.41,272373.86,700.45,113472.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','223537',4309912,'2601','388',299368.06,299368.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223537',4309913,'2602','388',312081.47,312081.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223537',4309914,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223537',4309915,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223537',4309916,'2740','412',84958.70,85142.91,184.21,52499.85,0.00,0.00,0.00,0.00,0.00),('1','171','932','223537',4309917,'2741','412',414036.25,415034.16,997.91,284404.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','223650',4312115,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223650',4312116,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223650',4312117,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223650',4312118,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223650',4312119,'2597','388',288129.43,289069.78,940.35,152336.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','223650',4312120,'2598','388',315594.88,316955.94,1361.06,220491.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','223650',4312121,'2599','388',226280.81,227161.53,880.72,142676.64,0.00,0.00,0.00,0.00,0.00),('1','171','878','223650',4312122,'2600','388',272373.86,274020.25,1646.39,266715.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','223650',4312123,'2601','388',299368.06,299368.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223650',4312124,'2602','388',312081.47,312081.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223650',4312125,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223650',4312126,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223650',4312127,'2740','412',85142.91,85142.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223650',4312128,'2741','412',415034.16,415926.87,892.71,254422.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','223761',4314243,'2593','388',325347.50,325347.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223761',4314244,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223761',4314245,'2595','388',295121.71,295121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223761',4314246,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223761',4314247,'2597','388',289069.78,289420.19,350.41,56766.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','223761',4314248,'2598','388',316955.94,317256.18,300.24,48638.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','223761',4314249,'2599','388',227161.53,227482.36,320.83,51974.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','223761',4314250,'2600','388',274020.25,274221.76,201.51,32644.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','223761',4314251,'2601','388',299368.06,299368.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223761',4314252,'2602','388',312081.47,312081.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223761',4314253,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223761',4314254,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223761',4314255,'2740','412',85142.91,85142.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223761',4314256,'2741','412',415926.87,416302.20,375.33,106969.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','223885',4316476,'2593','388',325347.50,326180.50,833.00,134946.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223885',4316477,'2594','388',358071.54,358071.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223885',4316478,'2595','388',295121.71,295792.25,670.54,108627.48,0.00,0.00,0.00,0.00,0.00),('1','171','877','223885',4316479,'2596','388',335558.82,335558.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223885',4316480,'2597','388',289420.19,289539.07,118.88,19258.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','223885',4316481,'2598','388',317256.18,318506.37,1250.19,202530.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','223885',4316482,'2599','388',227482.36,227635.43,153.07,24797.34,0.00,0.00,0.00,0.00,0.00),('1','171','878','223885',4316483,'2600','388',274221.76,274836.09,614.33,99521.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','223885',4316484,'2601','388',299368.06,299368.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223885',4316485,'2602','388',312081.47,312081.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223885',4316486,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223885',4316487,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223885',4316488,'2740','412',85142.91,85182.91,40.00,11400.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223885',4316489,'2741','412',416302.20,417398.35,1096.15,312402.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','223961',4317759,'2593','388',326180.50,326180.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223961',4317760,'2594','388',358071.54,359015.82,944.28,152973.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','223961',4317761,'2595','388',295792.25,295792.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','223961',4317762,'2596','388',335558.82,335904.13,345.31,55940.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','223961',4317763,'2597','388',289539.07,289539.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223961',4317764,'2598','388',318506.37,319194.92,688.55,111545.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','223961',4317765,'2599','388',227635.43,227635.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','223961',4317766,'2600','388',274836.09,275562.98,726.89,117756.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','223961',4317767,'2601','388',299368.06,299368.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223961',4317768,'2602','388',312081.47,312081.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223961',4317769,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','223961',4317770,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','223961',4317771,'2740','412',85182.91,85186.07,3.16,900.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','223961',4317772,'2741','412',417398.35,417897.53,499.18,142266.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','224072',4319854,'2593','388',326180.50,327980.61,1800.11,291617.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','224072',4319855,'2594','388',359015.82,359015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224072',4319856,'2595','388',295792.25,296156.22,363.97,58963.14,0.00,0.00,0.00,0.00,0.00),('1','171','877','224072',4319857,'2596','388',335904.13,335904.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224072',4319858,'2597','388',289539.07,291619.67,2080.60,337057.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','224072',4319859,'2598','388',319194.92,319194.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224072',4319860,'2599','388',227635.43,228444.41,808.98,131054.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','224072',4319861,'2600','388',275562.98,275562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224072',4319862,'2601','388',299368.06,300206.40,838.34,135811.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','224072',4319863,'2602','388',312081.47,312577.59,496.12,80371.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','224072',4319864,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224072',4319865,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224072',4319866,'2740','412',85186.07,85551.78,365.71,104227.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','224072',4319867,'2741','412',417897.53,419023.91,1126.38,321018.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','224228',4322626,'2593','388',327980.61,328335.95,355.34,57565.08,0.00,0.00,0.00,0.00,0.00),('1','171','877','224228',4322627,'2594','388',359015.82,359015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224228',4322628,'2595','388',296156.22,296156.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224228',4322629,'2596','388',335904.13,335904.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224228',4322630,'2597','388',291619.67,292955.41,1335.74,216389.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','224228',4322631,'2598','388',319194.92,319194.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224228',4322632,'2599','388',228444.41,228444.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224228',4322633,'2600','388',275562.98,276908.40,1345.42,217958.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','224228',4322634,'2601','388',300206.40,300658.89,452.49,73303.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','224228',4322635,'2602','388',312577.59,312577.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224228',4322636,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224228',4322637,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224228',4322638,'2740','412',85551.78,85755.63,203.85,58097.25,0.00,0.00,0.00,0.00,0.00),('1','171','932','224228',4322639,'2741','412',419023.91,419997.73,973.82,277538.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','224315',4324167,'2593','388',328335.95,330628.03,2292.08,371316.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','224315',4324168,'2594','388',359015.82,359985.18,969.36,157036.32,0.00,0.00,0.00,0.00,0.00),('1','171','877','224315',4324169,'2595','388',296156.22,296156.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224315',4324170,'2596','388',335904.13,335904.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224315',4324171,'2597','388',292955.41,292955.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224315',4324172,'2598','388',319194.92,320535.96,1341.04,217248.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','224315',4324173,'2599','388',228444.41,230158.41,1714.00,277668.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224315',4324174,'2600','388',276908.40,276908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224315',4324175,'2601','388',300658.89,300658.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224315',4324176,'2602','388',312577.59,313235.03,657.44,106505.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','224315',4324177,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224315',4324178,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224315',4324179,'2740','412',85755.63,85755.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224315',4324180,'2741','412',419997.73,420586.70,588.97,167856.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','224438',4326278,'2593','388',330628.03,330628.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224438',4326279,'2594','388',359985.18,359993.82,8.64,1399.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','224438',4326280,'2595','388',296156.22,296156.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224438',4326281,'2596','388',335904.13,335904.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224438',4326282,'2597','388',292955.41,293612.93,657.52,106518.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','224438',4326283,'2598','388',320535.96,321388.08,852.12,138043.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','224438',4326284,'2599','388',230158.41,230158.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224438',4326285,'2600','388',276908.40,278087.08,1178.68,190946.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','224438',4326286,'2601','388',300658.89,300658.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224438',4326287,'2602','388',313235.03,314549.59,1314.56,212958.72,0.00,0.00,0.00,0.00,0.00),('1','171','879','224438',4326288,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224438',4326289,'2604','388',248017.29,248017.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224438',4326290,'2740','412',85755.63,85755.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224438',4326291,'2741','412',420586.70,420999.39,412.69,117616.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','224536',4327951,'2593','388',330628.03,330628.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224536',4327952,'2594','388',359993.82,359993.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224536',4327953,'2595','388',296156.22,296156.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224536',4327954,'2596','388',335904.13,335904.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224536',4327955,'2597','388',293612.93,294600.58,987.65,159999.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','224536',4327956,'2598','388',321388.08,321508.74,120.66,19546.92,0.00,0.00,0.00,0.00,0.00),('1','171','878','224536',4327957,'2599','388',230158.41,232325.17,2166.76,351015.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','224536',4327958,'2600','388',278087.08,278087.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224536',4327959,'2601','388',300658.89,301758.03,1099.14,178060.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','224536',4327960,'2602','388',314549.59,315874.67,1325.08,214662.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','224536',4327961,'2603','388',185313.51,185313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224536',4327962,'2604','388',248017.29,249511.74,1494.45,242100.90,0.00,0.00,0.00,0.00,0.00),('1','171','932','224536',4327963,'2740','412',85755.63,86004.17,248.54,70833.90,0.00,0.00,0.00,0.00,0.00),('1','171','932','224536',4327964,'2741','412',420999.39,421415.23,415.84,118514.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','224677',4330353,'2593','388',330628.03,331477.02,848.99,137536.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','224677',4330354,'2594','388',359993.82,359993.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224677',4330355,'2595','388',296156.22,296156.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224677',4330356,'2596','388',335904.13,336223.42,319.29,51724.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','224677',4330357,'2597','388',294600.58,295272.14,671.56,108792.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','224677',4330358,'2598','388',321508.74,321508.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224677',4330359,'2599','388',232325.17,232325.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224677',4330360,'2600','388',278087.08,278325.30,238.22,38591.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','224677',4330361,'2601','388',301758.03,302263.89,505.86,81949.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','224677',4330362,'2602','388',315874.67,316148.05,273.38,44287.56,0.00,0.00,0.00,0.00,0.00),('1','171','879','224677',4330363,'2603','388',185313.51,185692.38,378.87,61376.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','224677',4330364,'2604','388',249511.74,249836.32,324.58,52581.96,0.00,0.00,0.00,0.00,0.00),('1','171','932','224677',4330365,'2740','412',86004.17,86004.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224677',4330366,'2741','412',421415.23,422448.03,1032.80,294348.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224793',4332356,'2593','388',331477.02,331477.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224793',4332357,'2594','388',359993.82,360062.47,68.65,11121.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','224793',4332358,'2595','388',296156.22,297974.85,1818.63,294618.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','224793',4332359,'2596','388',336223.42,337364.16,1140.74,184799.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','224793',4332360,'2597','388',295272.14,295541.91,269.77,43702.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','224793',4332361,'2598','388',321508.74,323681.48,2165.80,350859.60,0.00,0.00,6.94,0.00,0.00),('1','171','878','224793',4332362,'2599','388',232325.17,233867.20,1542.03,249808.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','224793',4332363,'2600','388',278325.30,278645.29,319.99,51838.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','224793',4332364,'2601','388',302263.89,302848.06,584.17,94635.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','224793',4332365,'2602','388',316148.05,316148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224793',4332366,'2603','388',185692.38,185692.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224793',4332367,'2604','388',249836.32,249836.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','224793',4332368,'2740','412',86004.17,86305.28,301.11,85816.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','224793',4332369,'2741','412',422448.03,423881.88,1433.85,408647.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','224914',4334559,'2593','388',331477.02,331477.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224914',4334560,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','224914',4334561,'2595','388',297974.85,298626.12,651.27,105505.74,0.00,0.00,0.00,0.00,0.00),('1','171','877','224914',4334562,'2596','388',337364.16,337364.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224914',4334563,'2597','388',295541.91,295541.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224914',4334564,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224914',4334565,'2599','388',233867.20,233867.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','224914',4334566,'2600','388',278645.29,279883.86,1238.57,200648.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','224914',4334567,'2601','388',302848.06,304196.37,1348.31,218426.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','224914',4334568,'2602','388',316148.05,316148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224914',4334569,'2603','388',185692.38,185692.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','224914',4334570,'2604','388',249836.32,250464.26,627.94,101726.28,0.00,0.00,0.00,0.00,0.00),('1','171','932','224914',4334571,'2740','412',86305.28,86373.35,68.07,19399.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','224914',4334572,'2741','412',423881.88,424838.44,956.56,272619.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','225028',4336620,'2593','388',331477.02,333622.78,2145.76,347613.12,0.00,0.00,0.00,0.00,0.00),('1','171','877','225028',4336621,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225028',4336622,'2595','388',298626.12,299942.78,1316.66,213298.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','225028',4336623,'2596','388',337364.16,337364.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225028',4336624,'2597','388',295541.91,297216.66,1674.75,271309.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','225028',4336625,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225028',4336626,'2599','388',233867.20,233867.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225028',4336627,'2600','388',279883.86,279883.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225028',4336628,'2601','388',304196.37,304196.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225028',4336629,'2602','388',316148.05,317224.24,1076.19,174342.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','225028',4336630,'2603','388',185692.38,187213.84,1521.46,246476.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','225028',4336631,'2604','388',250464.26,250464.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225028',4336632,'2740','412',86373.35,86373.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225028',4336633,'2741','412',424838.44,426034.21,1195.77,340794.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','225175',4339406,'2593','388',333622.78,333622.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225175',4339407,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225175',4339408,'2595','388',299942.78,299942.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225175',4339409,'2596','388',337364.16,338210.00,845.84,137026.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','225175',4339410,'2597','388',297216.66,297216.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225175',4339411,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225175',4339412,'2599','388',233867.20,235185.54,1318.34,213571.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','225175',4339413,'2600','388',279883.86,279883.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225175',4339414,'2601','388',304196.37,304786.55,590.18,95609.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','225175',4339415,'2602','388',317224.24,317224.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225175',4339416,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225175',4339417,'2604','388',250464.26,251052.82,588.56,95346.72,0.00,0.00,0.00,0.00,0.00),('1','171','932','225175',4339418,'2740','412',86373.35,86373.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225175',4339419,'2741','412',426034.21,426247.10,212.89,60673.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','225277',4341195,'2593','388',333622.78,333622.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225277',4341196,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225277',4341197,'2595','388',299942.78,299942.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225277',4341198,'2596','388',338210.00,338210.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225277',4341199,'2597','388',297216.66,297216.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225277',4341200,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225277',4341201,'2599','388',235185.54,235185.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225277',4341202,'2600','388',279883.86,279883.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225277',4341203,'2601','388',304786.55,304786.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225277',4341204,'2602','388',317224.24,317224.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225277',4341205,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225277',4341206,'2604','388',251052.82,251052.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225277',4341207,'2740','412',86373.35,86373.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225277',4341208,'2741','412',426247.10,426304.12,57.02,16250.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','225355',4342544,'2593','388',333622.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225355',4342545,'2594','388',360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225355',4342546,'2595','388',299942.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225355',4342547,'2596','388',338210.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225355',4342548,'2597','388',297216.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225355',4342549,'2598','388',323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225355',4342550,'2599','388',235185.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225355',4342551,'2600','388',279883.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225355',4342552,'2601','388',304786.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225355',4342553,'2602','388',317224.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225355',4342554,'2603','388',187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225355',4342555,'2604','388',251052.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225355',4342556,'2740','412',86373.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225355',4342557,'2741','412',426304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225362',4342718,'2593','388',333622.78,335511.27,1888.49,305935.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','225362',4342719,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225362',4342720,'2595','388',299942.78,300536.94,594.16,96253.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','225362',4342721,'2596','388',338210.00,339005.06,795.06,128799.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','225362',4342722,'2597','388',297216.66,298652.95,1436.29,232678.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','225362',4342723,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225362',4342724,'2599','388',235185.54,235185.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225362',4342725,'2600','388',279883.86,281567.71,1683.85,272783.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','225362',4342726,'2601','388',304786.55,304786.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225362',4342727,'2602','388',317224.24,318486.53,1262.29,204490.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','225362',4342728,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225362',4342729,'2604','388',251052.82,251052.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225362',4342730,'2740','412',86373.35,86373.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225362',4342731,'2741','412',426304.12,427173.69,869.57,252175.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','225371',4342912,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225371',4342913,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225371',4342914,'2595','388',300536.94,300536.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225371',4342915,'2596','388',339005.06,339005.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225371',4342916,'2597','388',298652.95,300144.47,1491.52,241626.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','225371',4342917,'2598','388',323681.48,323681.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225371',4342918,'2599','388',235185.54,235185.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225371',4342919,'2600','388',281567.71,282768.75,1201.04,194568.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','225371',4342920,'2601','388',304786.55,304786.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225371',4342921,'2602','388',318486.53,318486.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225371',4342922,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225371',4342923,'2604','388',251052.82,252197.10,1144.28,185373.36,0.00,0.00,0.00,0.00,0.00),('1','171','932','225371',4342924,'2740','412',86373.35,86573.35,200.00,58000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225371',4342925,'2741','412',427173.69,427273.69,100.00,29000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225492',4345156,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225492',4345157,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225492',4345158,'2595','388',300536.94,302159.27,1602.33,259577.46,0.00,0.00,20.00,0.00,0.00),('1','171','877','225492',4345159,'2596','388',339005.06,340454.02,1448.96,234731.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','225492',4345160,'2597','388',300144.47,300144.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225492',4345161,'2598','388',323681.48,325205.45,1523.97,246883.14,0.00,0.00,0.00,0.00,0.00),('1','171','878','225492',4345162,'2599','388',235185.54,236415.18,1229.64,199201.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','225492',4345163,'2600','388',282768.75,282768.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225492',4345164,'2601','388',304786.55,306062.59,1276.04,206718.48,0.00,0.00,0.00,0.00,0.00),('1','171','879','225492',4345165,'2602','388',318486.53,318486.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225492',4345166,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225492',4345167,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225492',4345168,'2740','412',86573.35,86627.14,53.79,15599.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','225492',4345169,'2741','412',427273.69,427273.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225591',4347028,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225591',4347029,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225591',4347030,'2595','388',302159.27,302159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225591',4347031,'2596','388',340454.02,340985.44,531.42,86090.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','225591',4347032,'2597','388',300144.47,300948.13,803.66,130192.92,0.00,0.00,0.00,0.00,0.00),('1','171','878','225591',4347033,'2598','388',325205.45,325205.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225591',4347034,'2599','388',236415.18,236415.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225591',4347035,'2600','388',282768.75,283721.87,953.12,154405.44,0.00,0.00,0.00,0.00,0.00),('1','171','879','225591',4347036,'2601','388',306062.59,306901.24,838.65,135861.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','225591',4347037,'2602','388',318486.53,318486.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225591',4347038,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225591',4347039,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225591',4347040,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225591',4347041,'2741','412',427273.69,427273.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225691',4348671,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225691',4348672,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225691',4348673,'2595','388',302159.27,302159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225691',4348674,'2596','388',340985.44,343969.44,2984.00,483408.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225691',4348675,'2597','388',300948.13,301638.68,690.55,111869.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','225691',4348676,'2598','388',325205.45,326489.27,1283.82,207978.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','225691',4348677,'2599','388',236415.18,238285.09,1869.91,302925.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','225691',4348678,'2600','388',283721.87,283721.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225691',4348679,'2601','388',306901.24,306901.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225691',4348680,'2602','388',318486.53,319628.01,1141.48,184919.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','225691',4348681,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225691',4348682,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225691',4348683,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225691',4348684,'2741','412',427273.69,427273.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225857',4351412,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225857',4351413,'2594','388',360062.47,360062.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225857',4351414,'2595','388',302159.27,303750.77,1591.50,257823.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225857',4351415,'2596','388',343969.44,343969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225857',4351416,'2597','388',301638.68,301905.08,266.40,43156.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','225857',4351417,'2598','388',326489.27,326489.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225857',4351418,'2599','388',238285.09,238285.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225857',4351419,'2600','388',283721.87,284722.64,990.77,160504.74,0.00,0.00,10.00,0.00,0.00),('1','171','879','225857',4351420,'2601','388',306901.24,306901.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225857',4351421,'2602','388',319628.01,320685.43,1057.42,171302.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','225857',4351422,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225857',4351423,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225857',4351424,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225857',4351425,'2741','412',427273.69,427273.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225961',4353300,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','225961',4353301,'2594','388',360062.47,361579.44,1516.97,245749.14,0.00,0.00,0.00,0.00,0.00),('1','171','877','225961',4353302,'2595','388',303750.77,304274.90,524.13,84909.06,0.00,0.00,0.00,0.00,0.00),('1','171','877','225961',4353303,'2596','388',343969.44,343969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','225961',4353304,'2597','388',301905.08,303153.60,1248.52,202260.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','225961',4353305,'2598','388',326489.27,328366.32,1877.05,304082.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','225961',4353306,'2599','388',238285.09,239400.91,1115.82,180762.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','225961',4353307,'2600','388',284722.64,285129.41,406.77,65896.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','225961',4353308,'2601','388',306901.24,307634.00,732.76,118707.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','225961',4353309,'2602','388',320685.43,321291.70,606.27,98215.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','225961',4353310,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','225961',4353311,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225961',4353312,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','225961',4353313,'2741','412',427273.69,427273.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226088',4355441,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226088',4355442,'2594','388',361579.44,361579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226088',4355443,'2595','388',304274.90,304274.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226088',4355444,'2596','388',343969.44,343969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226088',4355445,'2597','388',303153.60,303153.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226088',4355446,'2598','388',328366.32,328366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226088',4355447,'2599','388',239400.91,239400.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226088',4355448,'2600','388',285129.41,285129.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226088',4355449,'2601','388',307634.00,307634.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226088',4355450,'2602','388',321291.70,321291.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226088',4355451,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226088',4355452,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226088',4355453,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226088',4355454,'2741','412',427273.69,427633.69,360.00,104400.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226120',4356102,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226120',4356103,'2594','388',361579.44,361579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226120',4356104,'2595','388',304274.90,304761.31,486.41,78798.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','226120',4356105,'2596','388',343969.44,343969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226120',4356106,'2597','388',303153.60,304335.94,1182.34,191539.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','226120',4356107,'2598','388',328366.32,328366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226120',4356108,'2599','388',239400.91,239400.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226120',4356109,'2600','388',285129.41,286252.81,1123.40,181990.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','226120',4356110,'2601','388',307634.00,307634.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226120',4356111,'2602','388',321291.70,322055.21,763.51,123688.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','226120',4356112,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226120',4356113,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226120',4356114,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226120',4356115,'2741','412',427633.69,427633.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226299',4359267,'2593','388',335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226299',4359268,'2594','388',361579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226299',4359269,'2595','388',304761.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226299',4359270,'2596','388',343969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226299',4359271,'2597','388',304335.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226299',4359272,'2598','388',328366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226299',4359273,'2599','388',239400.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226299',4359274,'2600','388',286252.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226299',4359275,'2601','388',307634.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226299',4359276,'2602','388',322055.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226299',4359277,'2603','388',187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226299',4359278,'2604','388',252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226299',4359279,'2740','412',86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226299',4359280,'2741','412',427633.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226304',4359313,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226304',4359314,'2594','388',361579.44,361606.63,27.19,4404.78,0.00,0.00,0.00,0.00,0.00),('1','171','877','226304',4359315,'2595','388',304761.31,306176.53,1415.22,229265.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','226304',4359316,'2596','388',343969.44,345995.33,2025.89,328194.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','226304',4359317,'2597','388',304335.94,304335.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226304',4359318,'2598','388',328366.32,329806.09,1439.77,233242.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','226304',4359319,'2599','388',239400.91,239400.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226304',4359320,'2600','388',286252.81,288064.45,1811.64,293485.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','226304',4359321,'2601','388',307634.00,308968.02,1334.02,216111.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','226304',4359322,'2602','388',322055.21,322055.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226304',4359323,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226304',4359324,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226304',4359325,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226304',4359326,'2741','412',427633.69,427633.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226369',4360638,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226369',4360639,'2594','388',361606.63,361606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226369',4360640,'2595','388',306176.53,306176.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226369',4360641,'2596','388',345995.33,347174.92,1179.59,191093.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','226369',4360642,'2597','388',304335.94,304335.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226369',4360643,'2598','388',329806.09,329966.26,160.17,25947.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','226369',4360644,'2599','388',239400.91,239400.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226369',4360645,'2600','388',288064.45,289326.34,1261.89,204426.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','226369',4360646,'2601','388',308968.02,309376.32,408.30,66144.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','226369',4360647,'2602','388',322055.21,322055.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226369',4360648,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226369',4360649,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226369',4360650,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226369',4360651,'2741','412',427633.69,427833.69,200.00,59000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226488',4362672,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226488',4362673,'2594','388',361606.63,361606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226488',4362674,'2595','388',306176.53,308043.90,1867.37,302513.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','226488',4362675,'2596','388',347174.92,347174.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226488',4362676,'2597','388',304335.94,305777.32,1441.38,233503.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','226488',4362677,'2598','388',329966.26,331559.16,1592.90,258049.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','226488',4362678,'2599','388',239400.91,240594.56,1193.65,193371.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','226488',4362679,'2600','388',289326.34,289326.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226488',4362680,'2601','388',309376.32,309376.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226488',4362681,'2602','388',322055.21,323703.10,1647.89,266958.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','226488',4362682,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226488',4362683,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226488',4362684,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226488',4362685,'2741','412',427833.69,427833.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226609',4364966,'2593','388',335511.27,335511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226609',4364967,'2594','388',361606.63,361606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226609',4364968,'2595','388',308043.90,308043.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226609',4364969,'2596','388',347174.92,348374.60,1199.68,194348.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','226609',4364970,'2597','388',305777.32,306596.11,818.79,132643.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','226609',4364971,'2598','388',331559.16,331559.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226609',4364972,'2599','388',240594.56,240594.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226609',4364973,'2600','388',289326.34,289706.78,380.44,61631.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','226609',4364974,'2601','388',309376.32,310356.54,980.22,158795.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','226609',4364975,'2602','388',323703.10,323703.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226609',4364976,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226609',4364977,'2604','388',252197.10,252197.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226609',4364978,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226609',4364979,'2741','412',427833.69,427833.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226740',4367339,'2593','388',335511.27,337399.17,1887.90,305839.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','226740',4367340,'2594','388',361606.63,361606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226740',4367341,'2595','388',308043.90,308043.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226740',4367342,'2596','388',348374.60,349165.65,791.05,128150.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','226740',4367343,'2597','388',306596.11,306596.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226740',4367344,'2598','388',331559.16,331559.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226740',4367345,'2599','388',240594.56,240594.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226740',4367346,'2600','388',289706.78,292277.70,2570.92,416489.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','226740',4367347,'2601','388',310356.54,310356.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226740',4367348,'2602','388',323703.10,325057.57,1354.47,219424.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','226740',4367349,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226740',4367350,'2604','388',252197.10,252404.07,206.97,33529.14,0.00,0.00,0.00,0.00,0.00),('1','171','932','226740',4367351,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226740',4367352,'2741','412',427833.69,427833.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226867',4369645,'2593','388',337399.17,337399.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226867',4369646,'2594','388',361606.63,361606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226867',4369647,'2595','388',308043.90,308216.56,172.66,27970.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','226867',4369648,'2596','388',349165.65,349165.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226867',4369649,'2597','388',306596.11,308368.80,1772.69,287175.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','226867',4369650,'2598','388',331559.16,331559.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226867',4369651,'2599','388',240594.56,240594.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226867',4369652,'2600','388',292277.70,292277.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226867',4369653,'2601','388',310356.54,311634.42,1277.88,207016.56,0.00,0.00,0.00,0.00,0.00),('1','171','879','226867',4369654,'2602','388',325057.57,325057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226867',4369655,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226867',4369656,'2604','388',252404.07,252404.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226867',4369657,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226867',4369658,'2741','412',427833.69,427833.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226973',4371437,'2593','388',337399.17,338577.65,1178.48,190913.76,0.00,0.00,0.00,0.00,0.00),('1','171','877','226973',4371438,'2594','388',361606.63,362663.15,1056.52,171156.24,0.00,0.00,0.00,0.00,0.00),('1','171','877','226973',4371439,'2595','388',308216.56,309998.56,1782.00,288684.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','226973',4371440,'2596','388',349165.65,349165.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','226973',4371441,'2597','388',308368.80,308424.98,56.18,9101.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','226973',4371442,'2598','388',331559.16,331676.93,117.77,19078.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','226973',4371443,'2599','388',240594.56,240788.38,193.82,31398.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','226973',4371444,'2600','388',292277.70,294162.83,1885.13,305391.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','226973',4371445,'2601','388',311634.42,311634.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226973',4371446,'2602','388',325057.57,326682.91,1625.34,263305.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','226973',4371447,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','226973',4371448,'2604','388',252404.07,252459.63,55.56,9000.72,0.00,0.00,0.00,0.00,0.00),('1','171','932','226973',4371449,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','226973',4371450,'2741','412',427833.69,428178.80,345.11,101807.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','227129',4374278,'2593','388',338577.65,338577.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227129',4374279,'2594','388',362663.15,362663.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227129',4374280,'2595','388',309998.56,310021.64,23.08,3738.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','227129',4374281,'2596','388',349165.65,350125.90,960.25,155560.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','227129',4374282,'2597','388',308424.98,309444.22,1019.24,165116.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','227129',4374283,'2598','388',331676.93,331676.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227129',4374284,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227129',4374285,'2600','388',294162.83,294162.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227129',4374286,'2601','388',311634.42,313114.56,1480.14,239782.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','227129',4374287,'2602','388',326682.91,326682.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227129',4374288,'2603','388',187213.84,187213.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227129',4374289,'2604','388',252459.63,252459.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227129',4374290,'2740','412',86627.14,86627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227129',4374291,'2741','412',428178.80,428233.03,54.23,15997.85,0.00,0.00,0.00,0.00,0.00),('1','171','877','227195',4375350,'2593','388',338577.65,340371.31,1793.66,290572.92,0.00,0.00,0.00,0.00,0.00),('1','171','877','227195',4375351,'2594','388',362663.15,362663.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227195',4375352,'2595','388',310021.64,310934.37,912.73,147862.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','227195',4375353,'2596','388',350125.90,351114.76,988.86,160195.32,0.00,0.00,0.00,0.00,0.00),('1','171','878','227195',4375354,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227195',4375355,'2598','388',331676.93,331862.48,185.55,30059.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','227195',4375356,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227195',4375357,'2600','388',294162.83,294401.99,239.16,38743.92,0.00,0.00,0.00,0.00,0.00),('1','171','879','227195',4375358,'2601','388',313114.56,313114.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227195',4375359,'2602','388',326682.91,328658.27,1975.36,320008.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','227195',4375360,'2603','388',187213.84,187352.41,138.57,22448.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','227195',4375361,'2604','388',252459.63,253667.45,1207.82,195666.84,0.00,0.00,0.00,0.00,0.00),('1','171','932','227195',4375362,'2740','412',86627.14,86777.13,149.99,44247.05,0.00,0.00,0.00,0.00,0.00),('1','171','932','227195',4375363,'2741','412',428233.03,429122.34,889.31,262346.45,0.00,0.00,0.00,0.00,0.00),('1','171','877','227315',4377495,'2593','388',340371.31,341214.30,842.99,136564.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','227315',4377496,'2594','388',362663.15,364230.87,1567.72,253970.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','227315',4377497,'2595','388',310934.37,310934.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227315',4377498,'2596','388',351114.76,351114.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227315',4377499,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227315',4377500,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227315',4377501,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227315',4377502,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227315',4377503,'2601','388',313114.56,314217.23,1102.67,178632.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','227315',4377504,'2602','388',328658.27,328658.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227315',4377505,'2603','388',187352.41,187645.12,292.71,47419.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','227315',4377506,'2604','388',253667.45,254373.19,705.74,114329.88,0.00,0.00,0.00,0.00,0.00),('1','171','932','227315',4377507,'2740','412',86777.13,86777.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227315',4377508,'2741','412',429122.34,429464.54,342.20,100949.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227374',4378556,'2593','388',341214.30,341294.31,80.01,12961.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','227374',4378557,'2594','388',364230.87,364712.08,481.21,77956.02,0.00,0.00,0.00,0.00,0.00),('1','171','877','227374',4378558,'2595','388',310934.37,311967.88,1033.51,167428.62,0.00,0.00,0.00,0.00,0.00),('1','171','877','227374',4378559,'2596','388',351114.76,352120.86,1006.10,162988.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','227374',4378560,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227374',4378561,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227374',4378562,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227374',4378563,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227374',4378564,'2601','388',314217.23,315130.56,913.33,147959.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','227374',4378565,'2602','388',328658.27,329162.87,504.60,81745.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','227374',4378566,'2603','388',187645.12,187645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227374',4378567,'2604','388',254373.19,254954.53,581.34,94177.08,0.00,0.00,0.00,0.00,0.00),('1','171','932','227374',4378568,'2740','412',86777.13,86927.13,150.00,44250.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227374',4378569,'2741','412',429464.54,430683.93,1219.39,359720.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','227517',4381070,'2593','388',341294.31,341714.54,420.23,68077.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','227517',4381071,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227517',4381072,'2595','388',311967.88,311967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227517',4381073,'2596','388',352120.86,352831.65,710.79,115147.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','227517',4381074,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227517',4381075,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227517',4381076,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227517',4381077,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227517',4381078,'2601','388',315130.56,315723.04,592.48,95981.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','227517',4381079,'2602','388',329162.87,330103.05,940.18,152309.16,0.00,0.00,0.00,0.00,0.00),('1','171','879','227517',4381080,'2603','388',187645.12,187645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227517',4381081,'2604','388',254954.53,255794.42,839.89,136062.18,0.00,0.00,0.00,0.00,0.00),('1','171','932','227517',4381082,'2740','412',86927.13,86927.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227517',4381083,'2741','412',430683.93,431347.13,663.20,195644.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227609',4382576,'2593','388',341714.54,344390.35,2675.81,433481.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','227609',4382577,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227609',4382578,'2595','388',311967.88,312288.32,320.44,51911.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','227609',4382579,'2596','388',352831.65,354949.07,2117.42,343022.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','227609',4382580,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227609',4382581,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227609',4382582,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227609',4382583,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227609',4382584,'2601','388',315723.04,317383.40,1660.36,268978.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','227609',4382585,'2602','388',330103.05,330210.77,107.72,17450.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','227609',4382586,'2603','388',187645.12,187932.10,286.98,46490.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','227609',4382587,'2604','388',255794.42,256309.27,514.85,83405.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','227609',4382588,'2740','412',86927.13,88468.46,1541.33,454692.35,0.00,0.00,0.00,0.00,0.00),('1','171','932','227609',4382589,'2741','412',431347.13,431661.21,314.08,92653.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','227742',4384966,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227742',4384967,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227742',4384968,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227742',4384969,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227742',4384970,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227742',4384971,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227742',4384972,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227742',4384973,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227742',4384974,'2601','388',317383.40,318378.87,995.47,161266.14,0.00,0.00,0.00,0.00,0.00),('1','171','879','227742',4384975,'2602','388',330210.77,331137.54,926.77,150136.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','227742',4384976,'2603','388',187932.10,188900.96,968.86,156955.32,0.00,0.00,0.00,0.00,0.00),('1','171','879','227742',4384977,'2604','388',256309.27,256921.52,612.25,99184.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','227742',4384978,'2740','412',88468.46,88593.46,125.00,36875.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227742',4384979,'2741','412',431661.21,432037.38,376.17,110970.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','227780',4385766,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227780',4385767,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227780',4385768,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227780',4385769,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227780',4385770,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227780',4385771,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227780',4385772,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227780',4385773,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227780',4385774,'2601','388',318378.87,318378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227780',4385775,'2602','388',331137.54,331137.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227780',4385776,'2603','388',188900.96,188900.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227780',4385777,'2604','388',256921.52,256921.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227780',4385778,'2740','412',88593.46,88593.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227780',4385779,'2741','412',432037.38,432489.24,451.86,133298.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','227862',4387067,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227862',4387068,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227862',4387069,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227862',4387070,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227862',4387071,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227862',4387072,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227862',4387073,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227862',4387074,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227862',4387075,'2601','388',318378.87,319257.09,878.22,142271.64,0.00,0.00,0.00,0.00,0.00),('1','171','879','227862',4387076,'2602','388',331137.54,333986.05,2848.51,461458.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','227862',4387077,'2603','388',188900.96,190613.01,1692.05,274112.10,0.00,0.00,20.00,0.00,0.00),('1','171','879','227862',4387078,'2604','388',256921.52,258507.45,1585.93,256920.66,0.00,0.00,0.00,0.00,0.00),('1','171','932','227862',4387079,'2740','412',88593.46,88593.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227862',4387080,'2741','412',432489.24,433016.74,527.50,158250.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227995',4389655,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227995',4389656,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227995',4389657,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','227995',4389658,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227995',4389659,'2597','388',309444.22,309444.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227995',4389660,'2598','388',331862.48,331862.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227995',4389661,'2599','388',240788.38,240788.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','227995',4389662,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','227995',4389663,'2601','388',319257.09,320187.67,930.58,150753.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','227995',4389664,'2602','388',333986.05,334660.40,674.35,109244.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','227995',4389665,'2603','388',190613.01,191391.93,778.92,126185.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','227995',4389666,'2604','388',258507.45,258823.83,316.38,51253.56,0.00,0.00,0.00,0.00,0.00),('1','171','932','227995',4389667,'2740','412',88593.46,88642.13,48.67,14601.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','227995',4389668,'2741','412',433016.74,434024.03,1007.29,302187.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228128',4392140,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228128',4392141,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228128',4392142,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228128',4392143,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228128',4392144,'2597','388',309444.22,310663.52,1219.30,197526.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','228128',4392145,'2598','388',331862.48,333035.38,1172.90,190009.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','228128',4392146,'2599','388',240788.38,241892.15,1103.77,178810.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','228128',4392147,'2600','388',294401.99,294401.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228128',4392148,'2601','388',320187.67,321905.45,1717.78,278280.36,0.00,0.00,0.00,0.00,0.00),('1','171','879','228128',4392149,'2602','388',334660.40,335760.40,1100.00,178200.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228128',4392150,'2603','388',191391.93,191886.99,495.06,80199.72,0.00,0.00,0.00,0.00,0.00),('1','171','879','228128',4392151,'2604','388',258823.83,260003.95,1180.12,191179.44,0.00,0.00,0.00,0.00,0.00),('1','171','932','228128',4392152,'2740','412',88642.13,88642.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228128',4392153,'2741','412',434024.03,434421.03,397.00,119100.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228237',4394577,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228237',4394578,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228237',4394579,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228237',4394580,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228237',4394581,'2597','388',310663.52,311112.86,449.34,72793.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','228237',4394582,'2598','388',333035.38,333349.90,314.52,50952.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','228237',4394583,'2599','388',241892.15,241892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228237',4394584,'2600','388',294401.99,294888.26,486.27,78775.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','228237',4394585,'2601','388',321905.45,322927.02,1021.57,165494.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','228237',4394586,'2602','388',335760.40,335760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228237',4394587,'2603','388',191886.99,191886.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228237',4394588,'2604','388',260003.95,260834.88,830.93,134610.66,0.00,0.00,0.00,0.00,0.00),('1','171','932','228237',4394589,'2740','412',88642.13,88642.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228237',4394590,'2741','412',434421.03,435092.04,671.01,201303.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228360',4396608,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228360',4396609,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228360',4396610,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228360',4396611,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228360',4396612,'2597','388',311112.86,312801.94,1689.08,273630.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','228360',4396613,'2598','388',333349.90,334349.90,1000.00,162000.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228360',4396614,'2599','388',241892.15,241892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228360',4396615,'2600','388',294888.26,297290.29,2402.03,389128.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','228360',4396616,'2601','388',322927.02,323261.28,334.26,54150.12,0.00,0.00,0.00,0.00,0.00),('1','171','879','228360',4396617,'2602','388',335760.40,337038.84,1278.44,207107.28,0.00,0.00,0.00,0.00,0.00),('1','171','879','228360',4396618,'2603','388',191886.99,192938.24,1051.25,170302.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','228360',4396619,'2604','388',260834.88,260834.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228360',4396620,'2740','412',88642.13,88662.13,20.00,6000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228360',4396621,'2741','412',435092.04,435609.77,517.73,155319.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228458',4398683,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228458',4398684,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228458',4398685,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228458',4398686,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228458',4398687,'2597','388',312801.94,313361.29,559.35,90614.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','228458',4398688,'2598','388',334349.90,334867.41,517.51,83836.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','228458',4398689,'2599','388',241892.15,242756.78,864.63,140070.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','228458',4398690,'2600','388',297290.29,297850.16,559.87,90698.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','228458',4398691,'2601','388',323261.28,323611.15,349.87,56678.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','228458',4398692,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228458',4398693,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228458',4398694,'2604','388',260834.88,261368.27,533.39,86409.18,0.00,0.00,0.00,0.00,0.00),('1','171','932','228458',4398695,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228458',4398696,'2741','412',435609.77,435940.38,330.61,99183.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228546',4399979,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228546',4399980,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228546',4399981,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228546',4399982,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228546',4399983,'2597','388',313361.29,316010.46,2649.17,429165.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','228546',4399984,'2598','388',334867.41,336830.37,1962.96,317999.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','228546',4399985,'2599','388',242756.78,243737.46,980.68,158870.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','228546',4399986,'2600','388',297850.16,299836.74,1986.58,321825.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','228546',4399987,'2601','388',323611.15,323611.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228546',4399988,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228546',4399989,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228546',4399990,'2604','388',261368.27,261368.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228546',4399991,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228546',4399992,'2741','412',435940.38,436211.37,270.99,81297.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228622',4401455,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228622',4401456,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228622',4401457,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228622',4401458,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228622',4401459,'2597','388',316010.46,316362.48,352.02,57027.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','228622',4401460,'2598','388',336830.37,337851.00,1020.63,165342.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','228622',4401461,'2599','388',243737.46,244609.70,872.24,141302.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','228622',4401462,'2600','388',299836.74,300324.77,488.03,79060.86,0.00,0.00,0.00,0.00,0.00),('1','171','879','228622',4401463,'2601','388',323611.15,323611.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228622',4401464,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228622',4401465,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228622',4401466,'2604','388',261368.27,261368.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228622',4401467,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228622',4401468,'2741','412',436211.37,436723.64,512.27,153681.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228763',4404170,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228763',4404171,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228763',4404172,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228763',4404173,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228763',4404174,'2597','388',316362.48,318608.39,2245.91,363837.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','228763',4404175,'2598','388',337851.00,340168.00,2317.00,375354.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228763',4404176,'2599','388',244609.70,246654.63,2044.93,331278.66,0.00,0.00,0.00,0.00,0.00),('1','171','878','228763',4404177,'2600','388',300324.77,302478.08,2153.31,348836.22,0.00,0.00,0.00,0.00,0.00),('1','171','879','228763',4404178,'2601','388',323611.15,323611.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228763',4404179,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228763',4404180,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228763',4404181,'2604','388',261368.27,261368.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228763',4404182,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228763',4404183,'2741','412',436723.64,437258.31,534.67,160401.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228851',4405817,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228851',4405818,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228851',4405819,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228851',4405820,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228851',4405821,'2597','388',318608.39,319692.29,1083.90,175591.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','228851',4405822,'2598','388',340168.00,341354.41,1186.41,192198.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','228851',4405823,'2599','388',246654.63,246949.82,295.19,47820.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','228851',4405824,'2600','388',302478.08,303735.63,1257.55,203723.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','228851',4405825,'2601','388',323611.15,323611.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228851',4405826,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228851',4405827,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228851',4405828,'2604','388',261368.27,261368.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228851',4405829,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228851',4405830,'2741','412',437258.31,437515.65,257.34,77202.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228973',4407870,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228973',4407871,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228973',4407872,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','228973',4407873,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','228973',4407874,'2597','388',319692.29,321360.42,1668.13,270237.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','228973',4407875,'2598','388',341354.41,342432.83,1078.42,174704.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','228973',4407876,'2599','388',246949.82,247966.63,1016.81,164723.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','228973',4407877,'2600','388',303735.63,304844.82,1109.19,179688.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','228973',4407878,'2601','388',323611.15,323954.82,343.67,55674.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','228973',4407879,'2602','388',337038.84,337038.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228973',4407880,'2603','388',192938.24,192938.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','228973',4407881,'2604','388',261368.27,261634.61,266.34,43147.08,0.00,0.00,0.00,0.00,0.00),('1','171','932','228973',4407882,'2740','412',88662.13,88662.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','228973',4407883,'2741','412',437515.65,438561.90,1046.25,313875.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229054',4409810,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229054',4409811,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229054',4409812,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229054',4409813,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229054',4409814,'2597','388',321360.42,322489.34,1128.92,182885.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','229054',4409815,'2598','388',342432.83,342432.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229054',4409816,'2599','388',247966.63,247966.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229054',4409817,'2600','388',304844.82,306124.97,1280.15,207384.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','229054',4409818,'2601','388',323954.82,324581.78,626.96,101567.52,0.00,0.00,0.00,0.00,0.00),('1','171','879','229054',4409819,'2602','388',337038.84,338232.67,1193.83,193400.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','229054',4409820,'2603','388',192938.24,193481.91,543.67,88074.54,0.00,0.00,0.00,0.00,0.00),('1','171','879','229054',4409821,'2604','388',261634.61,262331.63,697.02,112917.24,0.00,0.00,0.00,0.00,0.00),('1','171','932','229054',4409822,'2740','412',88662.13,88860.17,198.04,59412.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229054',4409823,'2741','412',438561.90,439068.93,507.03,152109.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229188',4412182,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229188',4412183,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229188',4412184,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229188',4412185,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229188',4412186,'2597','388',322489.34,323528.53,1039.19,168348.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','229188',4412187,'2598','388',342432.83,343718.79,1285.96,208325.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','229188',4412188,'2599','388',247966.63,248719.75,753.12,122005.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','229188',4412189,'2600','388',306124.97,306124.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229188',4412190,'2601','388',324581.78,326146.45,1544.67,250236.54,0.00,0.00,20.00,0.00,0.00),('1','171','879','229188',4412191,'2602','388',338232.67,338252.67,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','171','879','229188',4412192,'2603','388',193481.91,193979.86,487.95,79047.90,0.00,0.00,10.00,0.00,0.00),('1','171','879','229188',4412193,'2604','388',262331.63,263562.82,1231.19,199452.78,0.00,0.00,0.00,0.00,0.00),('1','171','932','229188',4412194,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229188',4412195,'2741','412',439068.93,439539.36,470.43,141129.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229314',4414598,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229314',4414599,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229314',4414600,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229314',4414601,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229314',4414602,'2597','388',323528.53,324118.93,590.40,95644.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','229314',4414603,'2598','388',343718.79,343951.80,233.01,37747.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','229314',4414604,'2599','388',248719.75,249507.71,787.96,127649.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','229314',4414605,'2600','388',306124.97,306124.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229314',4414606,'2601','388',326146.45,326146.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229314',4414607,'2602','388',338252.67,338698.76,446.09,72266.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','229314',4414608,'2603','388',193979.86,193979.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229314',4414609,'2604','388',263562.82,263936.87,374.05,60596.10,0.00,0.00,0.00,0.00,0.00),('1','171','932','229314',4414610,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229314',4414611,'2741','412',439539.36,439840.36,301.00,90300.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229361',4415502,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229361',4415503,'2594','388',364712.08,364712.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229361',4415504,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229361',4415505,'2596','388',354949.07,354949.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229361',4415506,'2597','388',324118.93,324118.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229361',4415507,'2598','388',343951.80,343951.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229361',4415508,'2599','388',249507.71,249507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229361',4415509,'2600','388',306124.97,306124.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229361',4415510,'2601','388',326146.45,326146.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229361',4415511,'2602','388',338698.76,338698.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229361',4415512,'2603','388',193979.86,193979.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229361',4415513,'2604','388',263936.87,263936.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229361',4415514,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229361',4415515,'2741','412',439840.36,439940.36,100.00,30000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229430',4416478,'2593','388',344390.35,344390.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229430',4416479,'2594','388',364712.08,365183.18,471.10,76318.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','229430',4416480,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229430',4416481,'2596','388',354949.07,355540.61,591.54,95829.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','229430',4416482,'2597','388',324118.93,325137.46,1018.53,165001.86,0.00,0.00,0.00,0.00,0.00),('1','171','878','229430',4416483,'2598','388',343951.80,345090.85,1139.05,184526.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','229430',4416484,'2599','388',249507.71,249990.62,482.91,78231.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','229430',4416485,'2600','388',306124.97,306233.57,108.60,17593.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','229430',4416486,'2601','388',326146.45,327918.37,1771.92,287051.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','229430',4416487,'2602','388',338698.76,339964.41,1265.65,205035.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','229430',4416488,'2603','388',193979.86,194852.85,872.99,141424.38,0.00,0.00,0.00,0.00,0.00),('1','171','879','229430',4416489,'2604','388',263936.87,265467.33,1530.46,247934.52,0.00,0.00,0.00,0.00,0.00),('1','171','932','229430',4416490,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229430',4416491,'2741','412',439940.36,440438.21,497.85,154333.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','229572',4419378,'2593','388',344390.35,344997.46,607.11,98351.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','229572',4419379,'2594','388',365183.18,365959.57,776.39,125775.18,0.00,0.00,0.00,0.00,0.00),('1','171','877','229572',4419380,'2595','388',312288.32,312288.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229572',4419381,'2596','388',355540.61,356084.09,543.48,88043.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','229572',4419382,'2597','388',325137.46,325137.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229572',4419383,'2598','388',345090.85,345090.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229572',4419384,'2599','388',249990.62,249990.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229572',4419385,'2600','388',306233.57,306233.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229572',4419386,'2601','388',327918.37,328934.08,1015.71,164545.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','229572',4419387,'2602','388',339964.41,339964.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229572',4419388,'2603','388',194852.85,194852.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229572',4419389,'2604','388',265467.33,265901.40,434.07,70319.34,0.00,0.00,0.00,0.00,0.00),('1','171','932','229572',4419390,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229572',4419391,'2741','412',440438.21,441131.29,693.08,214854.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','229673',4421302,'2593','388',344997.46,346867.37,1869.91,302925.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','229673',4421303,'2594','388',365959.57,367266.30,1306.73,211690.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','229673',4421304,'2595','388',312288.32,314532.41,2244.09,363542.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','229673',4421305,'2596','388',356084.09,356790.88,706.79,114499.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','229673',4421306,'2597','388',325137.46,325137.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229673',4421307,'2598','388',345090.85,345090.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229673',4421308,'2599','388',249990.62,249990.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229673',4421309,'2600','388',306233.57,306233.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229673',4421310,'2601','388',328934.08,328934.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229673',4421311,'2602','388',339964.41,341719.34,1754.93,284298.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','229673',4421312,'2603','388',194852.85,194852.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229673',4421313,'2604','388',265901.40,268054.40,2133.00,345546.00,0.00,0.00,20.00,0.00,0.00),('1','171','932','229673',4421314,'2740','412',88860.17,88860.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229673',4421315,'2741','412',441131.29,442119.68,988.39,306400.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','229779',4423279,'2593','388',346867.37,347110.18,242.81,39335.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','229779',4423280,'2594','388',367266.30,367834.71,568.41,92082.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','229779',4423281,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229779',4423282,'2596','388',356790.88,357688.12,897.24,145352.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','229779',4423283,'2597','388',325137.46,325137.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229779',4423284,'2598','388',345090.85,345090.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229779',4423285,'2599','388',249990.62,249990.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229779',4423286,'2600','388',306233.57,306233.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229779',4423287,'2601','388',328934.08,329262.78,328.70,53249.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','229779',4423288,'2602','388',341719.34,341719.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229779',4423289,'2603','388',194852.85,194852.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229779',4423290,'2604','388',268054.40,268848.57,794.17,128655.54,0.00,0.00,0.00,0.00,0.00),('1','171','932','229779',4423291,'2740','412',88860.17,88960.17,100.00,31000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229779',4423292,'2741','412',442119.68,442639.53,519.85,161153.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','229900',4425749,'2593','388',347110.18,348905.15,1794.97,290785.14,0.00,0.00,0.00,0.00,0.00),('1','171','877','229900',4425750,'2594','388',367834.71,369630.65,1795.94,290942.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','229900',4425751,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229900',4425752,'2596','388',357688.12,360118.21,2430.09,393674.58,0.00,0.00,0.00,0.00,0.00),('1','171','878','229900',4425753,'2597','388',325137.46,325137.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229900',4425754,'2598','388',345090.85,345090.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229900',4425755,'2599','388',249990.62,249990.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229900',4425756,'2600','388',306233.57,306233.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229900',4425757,'2601','388',329262.78,329846.11,583.33,94499.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','229900',4425758,'2602','388',341719.34,343544.47,1825.13,295671.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','229900',4425759,'2603','388',194852.85,195930.14,1077.29,174520.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','229900',4425760,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229900',4425761,'2740','412',88960.17,88960.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229900',4425762,'2741','412',442639.53,443447.06,807.53,250334.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','229999',4427695,'2593','388',348905.15,348905.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229999',4427696,'2594','388',369630.65,370324.51,693.86,112405.32,0.00,0.00,0.00,0.00,0.00),('1','171','877','229999',4427697,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','229999',4427698,'2596','388',360118.21,360958.21,840.00,136080.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229999',4427699,'2597','388',325137.46,326520.65,1383.19,224076.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','229999',4427700,'2598','388',345090.85,345090.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','229999',4427701,'2599','388',249990.62,250229.40,238.78,38682.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','229999',4427702,'2600','388',306233.57,307347.86,1114.29,180514.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','229999',4427703,'2601','388',329846.11,330803.68,957.57,155126.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','229999',4427704,'2602','388',343544.47,343602.24,57.77,9358.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','229999',4427705,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','229999',4427706,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','229999',4427707,'2740','412',88960.17,89446.95,486.78,150901.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','229999',4427708,'2741','412',443447.06,444114.62,667.56,206943.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','230090',4429348,'2593','388',348905.15,350808.24,1903.09,308300.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','230090',4429349,'2594','388',370324.51,370376.31,51.80,8391.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','230090',4429350,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230090',4429351,'2596','388',360958.21,363145.29,2187.08,354306.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','230090',4429352,'2597','388',326520.65,326520.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230090',4429353,'2598','388',345090.85,346140.22,1049.37,169997.94,0.00,0.00,0.00,0.00,0.00),('1','171','878','230090',4429354,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230090',4429355,'2600','388',307347.86,309242.37,1894.51,306910.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','230090',4429356,'2601','388',330803.68,330803.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230090',4429357,'2602','388',343602.24,344942.82,1340.58,217173.96,0.00,0.00,0.00,0.00,0.00),('1','171','879','230090',4429358,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230090',4429359,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230090',4429360,'2740','412',89446.95,89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230090',4429361,'2741','412',444114.62,444371.67,257.05,79685.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','230238',4432097,'2593','388',350808.24,351324.98,516.74,83711.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','230238',4432098,'2594','388',370376.31,370376.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230238',4432099,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230238',4432100,'2596','388',363145.29,363996.96,851.67,137970.54,0.00,0.00,0.00,0.00,0.00),('1','171','878','230238',4432101,'2597','388',326520.65,326520.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230238',4432102,'2598','388',346140.22,347412.33,1272.11,206081.82,0.00,0.00,0.00,0.00,0.00),('1','171','878','230238',4432103,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230238',4432104,'2600','388',309242.37,310133.42,891.05,144350.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','230238',4432105,'2601','388',330803.68,331765.06,961.38,155743.56,0.00,0.00,0.00,0.00,0.00),('1','171','879','230238',4432106,'2602','388',344942.82,345013.19,70.37,11399.94,0.00,0.00,0.00,0.00,0.00),('1','171','879','230238',4432107,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230238',4432108,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230238',4432109,'2740','412',89446.95,89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230238',4432110,'2741','412',444371.67,444491.38,119.71,37110.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','230251',4432519,'2593','388',351324.98,351324.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230251',4432520,'2594','388',370376.31,370376.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230251',4432521,'2595','388',314532.41,314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230251',4432522,'2596','388',363996.96,363996.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230251',4432523,'2597','388',326520.65,326520.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230251',4432524,'2598','388',347412.33,347412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230251',4432525,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230251',4432526,'2600','388',310133.42,310133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230251',4432527,'2601','388',331765.06,331765.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230251',4432528,'2602','388',345013.19,345013.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230251',4432529,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230251',4432530,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230251',4432531,'2740','412',89446.95,89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230251',4432532,'2741','412',444491.38,445069.15,577.77,179108.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','230302',4433288,'2593','388',351324.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230302',4433289,'2594','388',370376.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230302',4433290,'2595','388',314532.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230302',4433291,'2596','388',363996.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230302',4433292,'2597','388',326520.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230302',4433293,'2598','388',347412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230302',4433294,'2599','388',250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230302',4433295,'2600','388',310133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230302',4433296,'2601','388',331765.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230302',4433297,'2602','388',345013.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230302',4433298,'2603','388',195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230302',4433299,'2604','388',268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230302',4433300,'2740','412',89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230302',4433301,'2741','412',445069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230342',4433865,'2593','388',351324.98,352514.12,1189.14,192640.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','230342',4433866,'2594','388',370376.31,371537.17,1160.86,188059.32,0.00,0.00,0.00,0.00,0.00),('1','171','877','230342',4433867,'2595','388',314532.41,316198.22,1665.81,269861.22,0.00,0.00,0.00,0.00,0.00),('1','171','877','230342',4433868,'2596','388',363996.96,363996.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230342',4433869,'2597','388',326520.65,327706.14,1185.49,192049.38,0.00,0.00,0.00,0.00,0.00),('1','171','878','230342',4433870,'2598','388',347412.33,347412.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230342',4433871,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230342',4433872,'2600','388',310133.42,310957.99,824.57,133580.34,0.00,0.00,0.00,0.00,0.00),('1','171','879','230342',4433873,'2601','388',331765.06,331765.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230342',4433874,'2602','388',345013.19,346316.30,1303.11,211103.82,0.00,0.00,0.00,0.00,0.00),('1','171','879','230342',4433875,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230342',4433876,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230342',4433877,'2740','412',89446.95,89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230342',4433878,'2741','412',445069.15,445315.46,246.31,78819.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','230415',4435646,'2593','388',352514.12,354045.76,1531.64,248125.68,0.00,0.00,0.00,0.00,0.00),('1','171','877','230415',4435647,'2594','388',371537.17,371537.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230415',4435648,'2595','388',316198.22,316198.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230415',4435649,'2596','388',363996.96,364535.81,538.85,87293.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','230415',4435650,'2597','388',327706.14,327706.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230415',4435651,'2598','388',347412.33,348248.72,836.39,135495.18,0.00,0.00,0.00,0.00,0.00),('1','171','878','230415',4435652,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230415',4435653,'2600','388',310957.99,310957.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230415',4435654,'2601','388',331765.06,333210.45,1445.39,234153.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','230415',4435655,'2602','388',346316.30,346316.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230415',4435656,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230415',4435657,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230415',4435658,'2740','412',89446.95,89446.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230415',4435659,'2741','412',445315.46,445381.09,65.63,21001.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','230521',4437529,'2593','388',354045.76,354045.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230521',4437530,'2594','388',371537.17,372611.89,1074.72,174104.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','230521',4437531,'2595','388',316198.22,317508.43,1310.21,212254.02,0.00,0.00,0.00,0.00,0.00),('1','171','877','230521',4437532,'2596','388',364535.81,365575.62,1039.81,168449.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','230521',4437533,'2597','388',327706.14,328923.18,1217.04,197160.48,0.00,0.00,0.00,0.00,0.00),('1','171','878','230521',4437534,'2598','388',348248.72,348248.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230521',4437535,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230521',4437536,'2600','388',310957.99,312115.97,1157.98,187592.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','230521',4437537,'2601','388',333210.45,333210.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230521',4437538,'2602','388',346316.30,347456.49,1140.19,184710.78,0.00,0.00,0.00,0.00,0.00),('1','171','879','230521',4437539,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230521',4437540,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230521',4437541,'2740','412',89446.95,89476.95,30.00,9600.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230521',4437542,'2741','412',445381.09,445793.80,412.71,132067.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','230652',4440047,'2593','388',354045.76,354916.51,870.75,141061.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','230652',4440048,'2594','388',372611.89,372611.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230652',4440049,'2595','388',317508.43,317508.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230652',4440050,'2596','388',365575.62,365939.95,364.33,59021.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','230652',4440051,'2597','388',328923.18,328925.03,1.85,299.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','230652',4440052,'2598','388',348248.72,349172.62,923.90,149671.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','230652',4440053,'2599','388',250229.40,250229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230652',4440054,'2600','388',312115.97,312865.24,749.27,121381.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','230652',4440055,'2601','388',333210.45,334197.37,986.92,159881.04,0.00,0.00,0.00,0.00,0.00),('1','171','879','230652',4440056,'2602','388',347456.49,347456.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230652',4440057,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230652',4440058,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230652',4440059,'2740','412',89476.95,89476.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230652',4440060,'2741','412',445793.80,446034.75,240.95,77104.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230801',4442252,'2593','388',354916.51,354916.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230801',4442253,'2594','388',372611.89,374124.17,1512.28,244989.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','230801',4442254,'2595','388',317508.43,317536.81,28.38,4597.56,0.00,0.00,0.00,0.00,0.00),('1','171','877','230801',4442255,'2596','388',365939.95,369242.23,3302.28,534969.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','230801',4442256,'2597','388',328925.03,328925.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230801',4442257,'2598','388',349172.62,349172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230801',4442258,'2599','388',250229.40,251548.86,1319.46,213752.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','230801',4442259,'2600','388',312865.24,312865.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230801',4442260,'2601','388',334197.37,335897.51,1700.14,275422.68,0.00,0.00,0.00,0.00,0.00),('1','171','879','230801',4442261,'2602','388',347456.49,347456.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230801',4442262,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230801',4442263,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230801',4442264,'2740','412',89476.95,89476.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230801',4442265,'2741','412',446034.75,446817.22,782.47,250390.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','230940',4444697,'2593','388',354916.51,355161.79,245.28,39735.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','230940',4444698,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230940',4444699,'2595','388',317536.81,317536.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','230940',4444700,'2596','388',369242.23,370208.55,966.32,156543.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','230940',4444701,'2597','388',328925.03,328925.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','230940',4444702,'2598','388',349172.62,350287.87,1115.25,180670.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','230940',4444703,'2599','388',251548.86,252290.74,741.88,120184.56,0.00,0.00,0.00,0.00,0.00),('1','171','878','230940',4444704,'2600','388',312865.24,312865.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230940',4444705,'2601','388',335897.51,336315.57,418.06,67725.72,0.00,0.00,0.00,0.00,0.00),('1','171','879','230940',4444706,'2602','388',347456.49,347456.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230940',4444707,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','230940',4444708,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230940',4444709,'2740','412',89476.95,89611.95,135.00,43200.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','230940',4444710,'2741','412',446817.22,447147.87,330.65,105808.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231079',4447084,'2593','388',355161.79,357737.24,2575.45,417222.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','231079',4447085,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231079',4447086,'2595','388',317536.81,318506.04,969.23,157015.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','231079',4447087,'2596','388',370208.55,370208.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231079',4447088,'2597','388',328925.03,330395.79,1470.76,238263.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','231079',4447089,'2598','388',350287.87,350287.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231079',4447090,'2599','388',252290.74,252290.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231079',4447091,'2600','388',312865.24,314001.25,1136.01,184033.62,0.00,0.00,0.00,0.00,0.00),('1','171','879','231079',4447092,'2601','388',336315.57,336315.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231079',4447093,'2602','388',347456.49,348462.22,1005.73,162928.26,0.00,0.00,0.00,0.00,0.00),('1','171','879','231079',4447094,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231079',4447095,'2604','388',268848.57,268848.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231079',4447096,'2740','412',89611.95,89611.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231079',4447097,'2741','412',447147.87,447417.08,269.21,86147.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','231210',4449408,'2593','388',357737.24,357737.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231210',4449409,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231210',4449410,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231210',4449411,'2596','388',370208.55,370208.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231210',4449412,'2597','388',330395.79,331617.79,1222.00,197964.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231210',4449413,'2598','388',350287.87,351002.20,714.33,115721.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','231210',4449414,'2599','388',252290.74,252290.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231210',4449415,'2600','388',314001.25,314495.54,494.29,80074.98,0.00,0.00,0.00,0.00,0.00),('1','171','879','231210',4449416,'2601','388',336315.57,336315.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231210',4449417,'2602','388',348462.22,349480.20,1017.98,164912.76,0.00,0.00,0.00,0.00,0.00),('1','171','879','231210',4449418,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231210',4449419,'2604','388',268848.57,269877.83,1029.26,166740.12,0.00,0.00,0.00,0.00,0.00),('1','171','932','231210',4449420,'2740','412',89611.95,89611.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231210',4449421,'2741','412',447417.08,447663.53,246.45,78864.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231397',4452111,'2593','388',357737.24,357737.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231397',4452112,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231397',4452113,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231397',4452114,'2596','388',370208.55,370208.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231397',4452115,'2597','388',331617.79,333039.47,1421.68,230312.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','231397',4452116,'2598','388',351002.20,351605.25,603.05,97694.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','231397',4452117,'2599','388',252290.74,253744.01,1453.27,235429.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','231397',4452118,'2600','388',314495.54,315410.47,914.93,148218.66,0.00,0.00,0.00,0.00,0.00),('1','171','879','231397',4452119,'2601','388',336315.57,337749.47,1433.90,232291.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','231397',4452120,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231397',4452121,'2603','388',195930.14,195930.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231397',4452122,'2604','388',269877.83,271054.20,1176.37,190571.94,0.00,0.00,0.00,0.00,0.00),('1','171','932','231397',4452123,'2740','412',89611.95,90752.40,1140.45,364944.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231397',4452124,'2741','412',447663.53,448096.98,433.45,138704.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231544',4454808,'2593','388',357737.24,357737.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231544',4454809,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231544',4454810,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231544',4454811,'2596','388',370208.55,370208.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231544',4454812,'2597','388',333039.47,334229.57,1190.10,192796.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','231544',4454813,'2598','388',351605.25,352536.19,930.94,150812.28,0.00,0.00,0.00,0.00,0.00),('1','171','878','231544',4454814,'2599','388',253744.01,253744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231544',4454815,'2600','388',315410.47,316432.74,1022.27,165607.74,0.00,0.00,0.00,0.00,0.00),('1','171','879','231544',4454816,'2601','388',337749.47,338891.88,1142.41,185070.42,0.00,0.00,0.00,0.00,0.00),('1','171','879','231544',4454817,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231544',4454818,'2603','388',195930.14,196930.14,1000.00,162000.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231544',4454819,'2604','388',271054.20,271752.63,698.43,113145.66,0.00,0.00,0.00,0.00,0.00),('1','171','932','231544',4454820,'2740','412',90752.40,90752.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231544',4454821,'2741','412',448096.98,448529.05,432.07,138262.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','231660',4456679,'2593','388',357737.24,357737.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231660',4456680,'2594','388',374124.17,374124.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231660',4456681,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231660',4456682,'2596','388',370208.55,370208.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231660',4456683,'2597','388',334229.57,335536.48,1306.91,211719.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','231660',4456684,'2598','388',352536.19,353696.67,1160.48,187997.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','231660',4456685,'2599','388',253744.01,255318.14,1574.13,255009.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','231660',4456686,'2600','388',316432.74,316432.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231660',4456687,'2601','388',338891.88,340521.09,1629.21,263932.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','231660',4456688,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231660',4456689,'2603','388',196930.14,197673.09,742.95,120357.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','231660',4456690,'2604','388',271752.63,272689.29,936.66,151738.92,0.00,0.00,0.00,0.00,0.00),('1','171','932','231660',4456691,'2740','412',90752.40,90752.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231660',4456692,'2741','412',448529.05,449237.97,708.92,226854.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','231793',4459378,'2593','388',357737.24,358288.50,551.26,89304.12,0.00,0.00,0.00,0.00,0.00),('1','171','877','231793',4459379,'2594','388',374124.17,374377.45,253.28,41031.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','231793',4459380,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231793',4459381,'2596','388',370208.55,371711.01,1502.46,243398.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','231793',4459382,'2597','388',335536.48,336473.62,937.14,151816.68,0.00,0.00,0.00,0.00,0.00),('1','171','878','231793',4459383,'2598','388',353696.67,353696.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231793',4459384,'2599','388',255318.14,255318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231793',4459385,'2600','388',316432.74,317824.13,1391.39,225405.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','231793',4459386,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231793',4459387,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231793',4459388,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231793',4459389,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231793',4459390,'2740','412',90752.40,90752.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231793',4459391,'2741','412',449237.97,449648.24,410.27,131286.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','231912',4461262,'2593','388',358288.50,360893.09,2604.59,421943.58,0.00,0.00,0.00,0.00,0.00),('1','171','877','231912',4461263,'2594','388',374377.45,376147.37,1769.92,286727.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','231912',4461264,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','231912',4461265,'2596','388',371711.01,373226.29,1515.28,245475.36,0.00,0.00,0.00,0.00,0.00),('1','171','878','231912',4461266,'2597','388',336473.62,338411.31,1937.69,313905.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','231912',4461267,'2598','388',353696.67,353696.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','231912',4461268,'2599','388',255318.14,256350.79,1032.65,167289.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','231912',4461269,'2600','388',317824.13,317824.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231912',4461270,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231912',4461271,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231912',4461272,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','231912',4461273,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231912',4461274,'2740','412',90752.40,90752.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','231912',4461275,'2741','412',449648.24,450185.56,537.32,171942.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','232015',4463282,'2593','388',360893.09,361901.05,1007.96,163289.52,0.00,0.00,0.00,0.00,0.00),('1','171','877','232015',4463283,'2594','388',376147.37,377221.79,1074.42,174056.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','232015',4463284,'2595','388',318506.04,318506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232015',4463285,'2596','388',373226.29,373531.81,305.52,49494.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','232015',4463286,'2597','388',338411.31,339531.99,1120.68,181550.16,0.00,0.00,0.00,0.00,0.00),('1','171','878','232015',4463287,'2598','388',353696.67,353696.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232015',4463288,'2599','388',256350.79,256350.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232015',4463289,'2600','388',317824.13,318981.88,1157.75,187555.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','232015',4463290,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232015',4463291,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232015',4463292,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232015',4463293,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232015',4463294,'2740','412',90752.40,90752.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232015',4463295,'2741','412',450185.56,450446.82,261.26,83603.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','232117',4465043,'2593','388',361901.05,362766.50,865.45,140202.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','232117',4465044,'2594','388',377221.79,378554.73,1332.94,215936.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','232117',4465045,'2595','388',318506.04,320103.76,1597.72,258830.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','232117',4465046,'2596','388',373531.81,374756.10,1224.29,198334.98,0.00,0.00,0.00,0.00,0.00),('1','171','878','232117',4465047,'2597','388',339531.99,340680.74,1148.75,186097.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','232117',4465048,'2598','388',353696.67,353696.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232117',4465049,'2599','388',256350.79,256688.13,337.34,54649.08,0.00,0.00,0.00,0.00,0.00),('1','171','878','232117',4465050,'2600','388',318981.88,319757.90,776.02,125715.24,0.00,0.00,0.00,0.00,0.00),('1','171','879','232117',4465051,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232117',4465052,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232117',4465053,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232117',4465054,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232117',4465055,'2740','412',90752.40,92760.22,2007.82,642502.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','232117',4465056,'2741','412',450446.82,452893.81,2446.99,783036.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','232215',4466922,'2593','388',362766.50,363640.28,873.78,141552.36,0.00,0.00,0.00,0.00,0.00),('1','171','877','232215',4466923,'2594','388',378554.73,379511.55,956.82,155004.84,0.00,0.00,0.00,0.00,0.00),('1','171','877','232215',4466924,'2595','388',320103.76,320359.75,255.99,41470.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','232215',4466925,'2596','388',374756.10,375739.51,983.41,159312.42,0.00,0.00,0.00,0.00,0.00),('1','171','878','232215',4466926,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232215',4466927,'2598','388',353696.67,354251.69,555.02,89913.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','232215',4466928,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232215',4466929,'2600','388',319757.90,320084.95,327.05,52982.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','232215',4466930,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232215',4466931,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232215',4466932,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232215',4466933,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232215',4466934,'2740','412',92760.22,92760.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232215',4466935,'2741','412',452893.81,453311.07,417.26,133523.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','232334',4468925,'2593','388',363640.28,365449.16,1808.88,293038.56,0.00,0.00,0.00,0.00,0.00),('1','171','877','232334',4468926,'2594','388',379511.55,380392.52,880.97,142717.14,0.00,0.00,0.00,0.00,0.00),('1','171','877','232334',4468927,'2595','388',320359.75,321493.99,1134.24,183746.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','232334',4468928,'2596','388',375739.51,376973.28,1233.77,199870.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','232334',4468929,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232334',4468930,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232334',4468931,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232334',4468932,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232334',4468933,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232334',4468934,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232334',4468935,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232334',4468936,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232334',4468937,'2740','412',92760.22,92984.55,224.33,71785.60,0.00,0.00,0.00,0.00,0.00),('1','171','932','232334',4468938,'2741','412',453311.07,453979.53,668.46,213907.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','232475',4471525,'2593','388',365449.16,367285.88,1836.72,297548.64,0.00,0.00,0.00,0.00,0.00),('1','171','877','232475',4471526,'2594','388',380392.52,381838.10,1445.58,234183.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','232475',4471527,'2595','388',321493.99,323003.55,1509.56,244548.72,0.00,0.00,0.00,0.00,0.00),('1','171','877','232475',4471528,'2596','388',376973.28,378288.04,1314.76,212991.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','232475',4471529,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232475',4471530,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232475',4471531,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232475',4471532,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232475',4471533,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232475',4471534,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232475',4471535,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232475',4471536,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232475',4471537,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232475',4471538,'2741','412',453979.53,454201.12,221.59,70908.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','232610',4473892,'2593','388',367285.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232610',4473893,'2594','388',381838.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232610',4473894,'2595','388',323003.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232610',4473895,'2596','388',378288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232610',4473896,'2597','388',340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232610',4473897,'2598','388',354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232610',4473898,'2599','388',256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232610',4473899,'2600','388',320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232610',4473900,'2601','388',340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232610',4473901,'2602','388',349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232610',4473902,'2603','388',197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232610',4473903,'2604','388',272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232610',4473904,'2740','412',92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232610',4473905,'2741','412',454201.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232615',4473938,'2593','388',367285.88,368585.96,1300.08,211913.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','232615',4473939,'2594','388',381838.10,383429.98,1571.88,256216.44,0.00,0.00,20.00,0.00,0.00),('1','171','877','232615',4473940,'2595','388',323003.55,324732.30,1728.75,281786.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','232615',4473941,'2596','388',378288.04,379477.02,1188.98,193803.74,0.00,0.00,0.00,0.00,0.00),('1','171','878','232615',4473942,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232615',4473943,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232615',4473944,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232615',4473945,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232615',4473946,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232615',4473947,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232615',4473948,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232615',4473949,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232615',4473950,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232615',4473951,'2741','412',454201.12,454368.20,167.08,55971.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','232721',4476050,'2593','388',368585.96,369424.38,838.42,136662.46,0.00,0.00,0.00,0.00,0.00),('1','171','877','232721',4476051,'2594','388',383429.98,384228.51,798.53,130160.39,0.00,0.00,0.00,0.00,0.00),('1','171','877','232721',4476052,'2595','388',324732.30,325539.79,807.49,131620.87,0.00,0.00,0.00,0.00,0.00),('1','171','877','232721',4476053,'2596','388',379477.02,380108.46,631.44,102924.72,0.00,0.00,0.00,0.00,0.00),('1','171','878','232721',4476054,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232721',4476055,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232721',4476056,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232721',4476057,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232721',4476058,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232721',4476059,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232721',4476060,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232721',4476061,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232721',4476062,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232721',4476063,'2741','412',454368.20,454767.18,398.98,133658.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','232867',4478446,'2593','388',369424.38,371039.78,1615.40,263310.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','232867',4478447,'2594','388',384228.51,385268.44,1039.93,169508.59,0.00,0.00,0.00,0.00,0.00),('1','171','877','232867',4478448,'2595','388',325539.79,326711.97,1172.18,191065.34,0.00,0.00,0.00,0.00,0.00),('1','171','877','232867',4478449,'2596','388',380108.46,380573.99,465.53,75881.39,0.00,0.00,0.00,0.00,0.00),('1','171','878','232867',4478450,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232867',4478451,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232867',4478452,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232867',4478453,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232867',4478454,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232867',4478455,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232867',4478456,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232867',4478457,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232867',4478458,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232867',4478459,'2741','412',454767.18,455307.58,540.40,181034.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232971',4480507,'2593','388',371039.78,371306.92,267.14,43543.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','232971',4480508,'2594','388',385268.44,385768.44,500.00,81500.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','232971',4480509,'2595','388',326711.97,326940.17,228.20,37196.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','232971',4480510,'2596','388',380573.99,380977.41,403.42,65757.46,0.00,0.00,0.00,0.00,0.00),('1','171','878','232971',4480511,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232971',4480512,'2598','388',354251.69,354251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232971',4480513,'2599','388',256688.13,256688.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','232971',4480514,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232971',4480515,'2601','388',340521.09,340521.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232971',4480516,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232971',4480517,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','232971',4480518,'2604','388',272689.29,272689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232971',4480519,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','232971',4480520,'2741','412',455307.58,455863.70,556.12,186300.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','233136',4483304,'2593','388',371306.92,371833.81,526.89,85883.07,0.00,0.00,0.00,0.00,0.00),('1','171','877','233136',4483305,'2594','388',385768.44,385868.71,100.27,16344.01,0.00,0.00,0.00,0.00,0.00),('1','171','877','233136',4483306,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233136',4483307,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233136',4483308,'2597','388',340680.74,340680.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233136',4483309,'2598','388',354251.69,355380.88,1129.19,184057.97,0.00,0.00,0.00,0.00,0.00),('1','171','878','233136',4483310,'2599','388',256688.13,257506.17,818.04,133340.52,0.00,0.00,0.00,0.00,0.00),('1','171','878','233136',4483311,'2600','388',320084.95,320084.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233136',4483312,'2601','388',340521.09,341382.40,861.31,140393.53,0.00,0.00,0.00,0.00,0.00),('1','171','879','233136',4483313,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233136',4483314,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233136',4483315,'2604','388',272689.29,273400.66,711.37,115953.31,0.00,0.00,0.00,0.00,0.00),('1','171','932','233136',4483316,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233136',4483317,'2741','412',455863.70,456381.63,517.93,173506.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','233241',4485259,'2593','388',371833.81,371833.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233241',4485260,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233241',4485261,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233241',4485262,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233241',4485263,'2597','388',340680.74,341775.98,1095.24,178524.12,0.00,0.00,0.00,0.00,0.00),('1','171','878','233241',4485264,'2598','388',355380.88,356030.95,650.07,105961.41,0.00,0.00,0.00,0.00,0.00),('1','171','878','233241',4485265,'2599','388',257506.17,257506.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233241',4485266,'2600','388',320084.95,321253.37,1168.42,190452.46,0.00,0.00,0.00,0.00,0.00),('1','171','879','233241',4485267,'2601','388',341382.40,342627.02,1244.62,202873.06,0.00,0.00,0.00,0.00,0.00),('1','171','879','233241',4485268,'2602','388',349480.20,349480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233241',4485269,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233241',4485270,'2604','388',273400.66,274013.22,612.56,99847.28,0.00,0.00,0.00,0.00,0.00),('1','171','932','233241',4485271,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233241',4485272,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233404',4488181,'2593','388',371833.81,371839.95,6.14,1000.82,0.00,0.00,0.00,0.00,0.00),('1','171','877','233404',4488182,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233404',4488183,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233404',4488184,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233404',4488185,'2597','388',341775.98,343691.79,1915.81,312277.03,0.00,0.00,0.00,0.00,0.00),('1','171','878','233404',4488186,'2598','388',356030.95,357159.80,1128.85,184002.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','233404',4488187,'2599','388',257506.17,257506.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233404',4488188,'2600','388',321253.37,322674.37,1421.00,231623.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233404',4488189,'2601','388',342627.02,342627.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233404',4488190,'2602','388',349480.20,351343.81,1863.61,303768.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','233404',4488191,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233404',4488192,'2604','388',274013.22,274881.82,868.60,141581.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','233404',4488193,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233404',4488194,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233499',4489885,'2593','388',371839.95,371839.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233499',4489886,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233499',4489887,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233499',4489888,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233499',4489889,'2597','388',343691.79,344655.53,963.74,157089.62,0.00,0.00,0.00,0.00,0.00),('1','171','878','233499',4489890,'2598','388',357159.80,358147.95,988.15,161068.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','233499',4489891,'2599','388',257506.17,257506.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233499',4489892,'2600','388',322674.37,323457.94,783.57,127721.91,0.00,0.00,0.00,0.00,0.00),('1','171','879','233499',4489893,'2601','388',342627.02,343853.56,1226.54,199926.02,0.00,0.00,0.00,0.00,0.00),('1','171','879','233499',4489894,'2602','388',351343.81,351343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233499',4489895,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233499',4489896,'2604','388',274881.82,275886.75,1004.93,163803.59,0.00,0.00,0.00,0.00,0.00),('1','171','932','233499',4489897,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233499',4489898,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233637',4492376,'2593','388',371839.95,371839.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233637',4492377,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233637',4492378,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233637',4492379,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233637',4492380,'2597','388',344655.53,346130.92,1475.39,240488.57,0.00,0.00,0.00,0.00,0.00),('1','171','878','233637',4492381,'2598','388',358147.95,359450.52,1302.57,212318.91,0.00,0.00,0.00,0.00,0.00),('1','171','878','233637',4492382,'2599','388',257506.17,258884.05,1377.88,224594.44,0.00,0.00,0.00,0.00,0.00),('1','171','878','233637',4492383,'2600','388',323457.94,324493.73,1035.79,168833.77,0.00,0.00,0.00,0.00,0.00),('1','171','879','233637',4492384,'2601','388',343853.56,343853.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233637',4492385,'2602','388',351343.81,352807.71,1463.90,238615.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','233637',4492386,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233637',4492387,'2604','388',275886.75,277374.55,1487.80,242511.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','233637',4492388,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233637',4492389,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233737',4494251,'2593','388',371839.95,371839.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233737',4494252,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233737',4494253,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233737',4494254,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233737',4494255,'2597','388',346130.92,347046.73,915.81,149277.03,0.00,0.00,0.00,0.00,0.00),('1','171','878','233737',4494256,'2598','388',359450.52,360355.46,904.94,147505.22,0.00,0.00,0.00,0.00,0.00),('1','171','878','233737',4494257,'2599','388',258884.05,258884.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233737',4494258,'2600','388',324493.73,325506.66,1012.93,165107.59,0.00,0.00,0.00,0.00,0.00),('1','171','879','233737',4494259,'2601','388',343853.56,344978.42,1124.86,183352.18,0.00,0.00,0.00,0.00,0.00),('1','171','879','233737',4494260,'2602','388',352807.71,352807.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233737',4494261,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233737',4494262,'2604','388',277374.55,278307.27,932.72,152033.36,0.00,0.00,0.00,0.00,0.00),('1','171','932','233737',4494263,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233737',4494264,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233861',4496391,'2593','388',371839.95,371839.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233861',4496392,'2594','388',385868.71,385868.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233861',4496393,'2595','388',326940.17,326940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233861',4496394,'2596','388',380977.41,380977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233861',4496395,'2597','388',347046.73,348434.41,1387.68,226191.84,0.00,0.00,0.00,0.00,0.00),('1','171','878','233861',4496396,'2598','388',360355.46,361146.49,791.03,128937.89,0.00,0.00,0.00,0.00,0.00),('1','171','878','233861',4496397,'2599','388',258884.05,260298.81,1414.76,230605.88,0.00,0.00,0.00,0.00,0.00),('1','171','878','233861',4496398,'2600','388',325506.66,326956.27,1449.61,236286.43,0.00,0.00,0.00,0.00,0.00),('1','171','879','233861',4496399,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233861',4496400,'2602','388',352807.71,353920.87,1113.16,181445.08,0.00,0.00,0.00,0.00,0.00),('1','171','879','233861',4496401,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233861',4496402,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233861',4496403,'2740','412',92984.55,92984.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233861',4496404,'2741','412',456381.63,456381.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','233950',4498229,'2593','388',371839.95,372814.71,974.76,158885.88,0.00,0.00,0.00,0.00,0.00),('1','171','877','233950',4498230,'2594','388',385868.71,386696.59,827.88,134944.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','233950',4498231,'2595','388',326940.17,327578.51,638.34,104049.42,0.00,0.00,0.00,0.00,0.00),('1','171','877','233950',4498232,'2596','388',380977.41,381570.33,592.92,96645.96,0.00,0.00,0.00,0.00,0.00),('1','171','878','233950',4498233,'2597','388',348434.41,348434.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233950',4498234,'2598','388',361146.49,361146.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233950',4498235,'2599','388',260298.81,260298.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','233950',4498236,'2600','388',326956.27,327964.93,1008.66,164411.58,0.00,0.00,0.00,0.00,0.00),('1','171','879','233950',4498237,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233950',4498238,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233950',4498239,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','233950',4498240,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','233950',4498241,'2740','412',92984.55,93153.37,168.82,57398.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','233950',4498242,'2741','412',456381.63,456411.63,30.00,10200.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','234126',4501404,'2593','388',372814.71,374096.03,1281.32,208855.16,0.00,0.00,0.00,0.00,0.00),('1','171','877','234126',4501405,'2594','388',386696.59,387982.50,1285.91,209603.33,0.00,0.00,0.00,0.00,0.00),('1','171','877','234126',4501406,'2595','388',327578.51,328309.02,730.51,119073.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','234126',4501407,'2596','388',381570.33,382682.04,1111.71,181208.73,0.00,0.00,0.00,0.00,0.00),('1','171','878','234126',4501408,'2597','388',348434.41,348434.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234126',4501409,'2598','388',361146.49,361146.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234126',4501410,'2599','388',260298.81,261181.44,882.63,143868.69,0.00,0.00,0.00,0.00,0.00),('1','171','878','234126',4501411,'2600','388',327964.93,327964.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234126',4501412,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234126',4501413,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234126',4501414,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234126',4501415,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234126',4501416,'2740','412',93153.37,93153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234126',4501417,'2741','412',456411.63,456730.16,318.53,108300.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','234244',4503485,'2593','388',374096.03,375187.50,1091.47,177909.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','234244',4503486,'2594','388',387982.50,388553.42,570.92,93059.96,0.00,0.00,0.00,0.00,0.00),('1','171','877','234244',4503487,'2595','388',328309.02,329188.58,879.56,143368.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','234244',4503488,'2596','388',382682.04,383690.91,1008.87,164445.81,0.00,0.00,0.00,0.00,0.00),('1','171','878','234244',4503489,'2597','388',348434.41,348507.49,73.08,11912.04,0.00,0.00,0.00,0.00,0.00),('1','171','878','234244',4503490,'2598','388',361146.49,361146.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234244',4503491,'2599','388',261181.44,261181.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234244',4503492,'2600','388',327964.93,329210.34,1245.41,203001.83,0.00,0.00,0.00,0.00,0.00),('1','171','879','234244',4503493,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234244',4503494,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234244',4503495,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234244',4503496,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234244',4503497,'2740','412',93153.37,93153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234244',4503498,'2741','412',456730.16,457306.80,576.64,196057.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','234334',4504983,'2593','388',375187.50,376151.49,943.50,153790.50,0.00,0.00,20.49,0.00,0.00),('1','171','877','234334',4504984,'2594','388',388553.42,390254.12,1700.70,277214.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','234334',4504985,'2595','388',329188.58,330156.78,947.64,154465.32,0.00,0.00,20.56,0.00,0.00),('1','171','877','234334',4504986,'2596','388',383690.91,384880.53,1189.62,193908.06,0.00,0.00,0.00,0.00,0.00),('1','171','878','234334',4504987,'2597','388',348507.49,349254.00,725.94,118328.22,0.00,0.00,20.57,0.00,0.00),('1','171','878','234334',4504988,'2598','388',361146.49,361667.01,520.52,84844.76,0.00,0.00,0.00,0.00,0.00),('1','171','878','234334',4504989,'2599','388',261181.44,261367.98,165.94,27048.22,0.00,0.00,20.60,0.00,0.00),('1','171','878','234334',4504990,'2600','388',329210.34,329892.11,681.77,111128.51,0.00,0.00,0.00,0.00,0.00),('1','171','879','234334',4504991,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234334',4504992,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234334',4504993,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234334',4504994,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234334',4504995,'2740','412',93153.37,93173.37,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','171','932','234334',4504996,'2741','412',457306.80,457543.09,215.73,73348.20,0.00,0.00,20.56,0.00,0.00),('1','171','877','234459',4507345,'2593','388',376151.49,376997.96,846.47,137974.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','234459',4507346,'2594','388',390254.12,391616.22,1362.10,222022.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','234459',4507347,'2595','388',330156.78,331294.00,1137.22,185366.86,0.00,0.00,0.00,0.00,0.00),('1','171','877','234459',4507348,'2596','388',384880.53,386022.01,1141.48,186061.24,0.00,0.00,0.00,0.00,0.00),('1','171','878','234459',4507349,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234459',4507350,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234459',4507351,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234459',4507352,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234459',4507353,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234459',4507354,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234459',4507355,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234459',4507356,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234459',4507357,'2740','412',93173.37,93173.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234459',4507358,'2741','412',457543.09,457887.76,344.67,117187.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','234599',4509701,'2593','388',376997.96,379555.50,2557.54,416879.02,0.00,0.00,0.00,0.00,0.00),('1','171','877','234599',4509702,'2594','388',391616.22,393084.87,1468.65,239389.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','234599',4509703,'2595','388',331294.00,333312.08,2018.08,328947.04,0.00,0.00,0.00,0.00,0.00),('1','171','877','234599',4509704,'2596','388',386022.01,387450.31,1428.30,232812.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','234599',4509705,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234599',4509706,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234599',4509707,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234599',4509708,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234599',4509709,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234599',4509710,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234599',4509711,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234599',4509712,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234599',4509713,'2740','412',93173.37,93173.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234599',4509714,'2741','412',457887.76,458327.65,439.89,149562.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','234747',4512469,'2593','388',379555.50,380837.19,1281.69,208915.47,0.00,0.00,0.00,0.00,0.00),('1','171','877','234747',4512470,'2594','388',393084.87,394664.03,1579.16,257403.08,0.00,0.00,0.00,0.00,0.00),('1','171','877','234747',4512471,'2595','388',333312.08,334574.64,1262.56,205797.28,0.00,0.00,0.00,0.00,0.00),('1','171','877','234747',4512472,'2596','388',387450.31,388621.36,1171.05,190881.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','234747',4512473,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234747',4512474,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234747',4512475,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234747',4512476,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234747',4512477,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234747',4512478,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234747',4512479,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234747',4512480,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234747',4512481,'2740','412',93173.37,93173.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234747',4512482,'2741','412',458327.65,458958.18,630.53,214380.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','234858',4514337,'2593','388',380837.19,383067.45,2230.26,363532.38,0.00,0.00,0.00,0.00,0.00),('1','171','877','234858',4514338,'2594','388',394664.03,397211.50,2547.47,415237.61,0.00,0.00,0.00,0.00,0.00),('1','171','877','234858',4514339,'2595','388',334574.64,336490.52,1915.88,312288.44,0.00,0.00,0.00,0.00,0.00),('1','171','877','234858',4514340,'2596','388',388621.36,390438.42,1817.06,296180.78,0.00,0.00,0.00,0.00,0.00),('1','171','878','234858',4514341,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234858',4514342,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234858',4514343,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234858',4514344,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234858',4514345,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234858',4514346,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234858',4514347,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234858',4514348,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234858',4514349,'2740','412',93173.37,95245.63,2072.26,704568.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','234858',4514350,'2741','412',458958.18,459869.17,910.99,309736.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','234953',4516209,'2593','388',383067.45,383589.00,521.55,85012.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','234953',4516210,'2594','388',397211.50,397667.01,455.51,74248.13,0.00,0.00,0.00,0.00,0.00),('1','171','877','234953',4516211,'2595','388',336490.52,336871.49,380.97,62098.11,0.00,0.00,0.00,0.00,0.00),('1','171','877','234953',4516212,'2596','388',390438.42,390885.82,447.40,72926.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','234953',4516213,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234953',4516214,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234953',4516215,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','234953',4516216,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234953',4516217,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234953',4516218,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234953',4516219,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','234953',4516220,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234953',4516221,'2740','412',95245.63,95245.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','234953',4516222,'2741','412',459869.17,460079.75,210.58,71597.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','235108',4518757,'2593','388',383589.00,384001.82,412.82,67289.66,0.00,0.00,0.00,0.00,0.00),('1','171','877','235108',4518758,'2594','388',397667.01,397867.03,200.02,32603.26,0.00,0.00,0.00,0.00,0.00),('1','171','877','235108',4518759,'2595','388',336871.49,337221.49,350.00,57050.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235108',4518760,'2596','388',390885.82,391035.82,150.00,24450.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235108',4518761,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235108',4518762,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235108',4518763,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235108',4518764,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235108',4518765,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235108',4518766,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235108',4518767,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235108',4518768,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235108',4518769,'2740','412',95245.63,95286.81,41.18,14001.20,0.00,0.00,0.00,0.00,0.00),('1','171','932','235108',4518770,'2741','412',460079.75,461307.87,1228.12,417560.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','235193',4520282,'2593','388',384001.82,384001.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235193',4520283,'2594','388',397867.03,397867.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235193',4520284,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235193',4520285,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235193',4520286,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235193',4520287,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235193',4520288,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235193',4520289,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235193',4520290,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235193',4520291,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235193',4520292,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235193',4520293,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235193',4520294,'2740','412',95286.81,95286.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235193',4520295,'2741','412',461307.87,461711.25,403.38,137149.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','235343',4522816,'2593','388',384001.82,384112.95,81.13,13224.19,0.00,0.00,30.00,0.00,0.00),('1','171','877','235343',4522817,'2594','388',397867.03,397900.23,33.20,5411.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','235343',4522818,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235343',4522819,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235343',4522820,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235343',4522821,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235343',4522822,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235343',4522823,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235343',4522824,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235343',4522825,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235343',4522826,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235343',4522827,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235343',4522828,'2740','412',95286.81,95286.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235343',4522829,'2741','412',461711.25,462307.13,595.88,202599.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','235428',4524539,'2593','388',384112.95,384112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235428',4524540,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235428',4524541,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235428',4524542,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235428',4524543,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235428',4524544,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235428',4524545,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235428',4524546,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235428',4524547,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235428',4524548,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235428',4524549,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235428',4524550,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235428',4524551,'2740','412',95286.81,95433.88,147.07,50003.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','235428',4524552,'2741','412',462307.13,462787.76,480.63,163414.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','235545',4526390,'2593','388',384112.95,384212.33,99.38,16198.94,0.00,0.00,0.00,0.00,0.00),('1','171','877','235545',4526391,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235545',4526392,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235545',4526393,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235545',4526394,'2597','388',349254.00,349254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235545',4526395,'2598','388',361667.01,361667.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235545',4526396,'2599','388',261367.98,261367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235545',4526397,'2600','388',329892.11,329892.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235545',4526398,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235545',4526399,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235545',4526400,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235545',4526401,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235545',4526402,'2740','412',95433.88,95433.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235545',4526403,'2741','412',462787.76,463611.57,823.81,280095.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','235793',4530726,'2593','388',384212.33,384459.77,247.44,40827.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','235793',4530727,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235793',4530728,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235793',4530729,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235793',4530730,'2597','388',349254.00,349432.79,178.79,29500.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','235793',4530731,'2598','388',361667.01,361862.41,195.40,32241.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235793',4530732,'2599','388',261367.98,261434.03,66.05,10898.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','235793',4530733,'2600','388',329892.11,330099.41,207.30,34204.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','235793',4530734,'2601','388',344978.42,344978.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235793',4530735,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235793',4530736,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235793',4530737,'2604','388',278307.27,278307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235793',4530738,'2740','412',95433.88,95493.88,60.00,20400.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235793',4530739,'2741','412',463611.57,463963.31,351.74,119591.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','235910',4532754,'2593','388',384459.77,384606.74,146.97,24250.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','235910',4532755,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235910',4532756,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','235910',4532757,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235910',4532758,'2597','388',349432.79,350328.39,895.60,147774.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235910',4532759,'2598','388',361862.41,362597.45,735.04,121281.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','235910',4532760,'2599','388',261434.03,261434.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','235910',4532761,'2600','388',330099.41,331623.88,1524.47,251537.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','235910',4532762,'2601','388',344978.42,346180.40,1201.98,198326.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','235910',4532763,'2602','388',353920.87,353920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235910',4532764,'2603','388',197673.09,197673.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','235910',4532765,'2604','388',278307.27,279125.80,818.53,135057.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','235910',4532766,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','235910',4532767,'2741','412',463963.31,464442.11,478.80,162792.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236045',4535068,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236045',4535069,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236045',4535070,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236045',4535071,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236045',4535072,'2597','388',350328.39,351924.97,1576.58,260135.70,0.00,0.00,20.00,0.00,0.00),('1','171','878','236045',4535073,'2598','388',362597.45,364132.42,1534.97,253270.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','236045',4535074,'2599','388',261434.03,262781.91,1347.88,222400.20,0.00,0.00,0.00,0.00,0.00),('1','171','878','236045',4535075,'2600','388',331623.88,331623.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236045',4535076,'2601','388',346180.40,346180.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236045',4535077,'2602','388',353920.87,355387.16,1466.29,241937.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','236045',4535078,'2603','388',197673.09,198887.30,1214.21,200344.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','236045',4535079,'2604','388',279125.80,279125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236045',4535080,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236045',4535081,'2741','412',464442.11,464811.52,369.41,125599.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','236083',4535851,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236083',4535852,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236083',4535853,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236083',4535854,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236083',4535855,'2597','388',351924.97,352388.82,463.85,76535.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','236083',4535856,'2598','388',364132.42,364909.29,776.87,128183.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','236083',4535857,'2599','388',262781.91,262781.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236083',4535858,'2600','388',331623.88,332864.08,1240.20,204633.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236083',4535859,'2601','388',346180.40,346867.35,686.95,113346.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','236083',4535860,'2602','388',355387.16,355387.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236083',4535861,'2603','388',198887.30,198887.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236083',4535862,'2604','388',279125.80,280228.03,1102.23,181867.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','236083',4535863,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236083',4535864,'2741','412',464811.52,465089.63,278.11,94557.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','236320',4540182,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236320',4540183,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236320',4540184,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236320',4540185,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236320',4540186,'2597','388',352388.82,354345.05,1956.23,322777.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','236320',4540187,'2598','388',364909.29,366107.42,1198.13,197691.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','236320',4540188,'2599','388',262781.91,264104.69,1322.78,218258.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','236320',4540189,'2600','388',332864.08,332864.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236320',4540190,'2601','388',346867.35,346867.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236320',4540191,'2602','388',355387.16,356670.64,1283.48,211774.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','236320',4540192,'2603','388',198887.30,200268.38,1381.08,227878.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','236320',4540193,'2604','388',280228.03,280228.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236320',4540194,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236320',4540195,'2741','412',465089.63,465843.16,753.53,256200.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','236401',4541644,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236401',4541645,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236401',4541646,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236401',4541647,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236401',4541648,'2597','388',354345.05,355378.05,1033.00,170445.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236401',4541649,'2598','388',366107.42,367172.20,1064.78,175688.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','236401',4541650,'2599','388',264104.69,264104.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236401',4541651,'2600','388',332864.08,333866.57,1002.49,165410.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','236401',4541652,'2601','388',346867.35,348447.26,1579.91,260685.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','236401',4541653,'2602','388',356670.64,356670.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236401',4541654,'2603','388',200268.38,200268.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236401',4541655,'2604','388',280228.03,280814.46,586.43,96760.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','236401',4541656,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236401',4541657,'2741','412',465843.16,466012.69,169.53,57640.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','236522',4543653,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236522',4543654,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236522',4543655,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236522',4543656,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236522',4543657,'2597','388',355378.05,356761.90,1383.85,228335.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','236522',4543658,'2598','388',367172.20,368620.72,1448.52,239005.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','236522',4543659,'2599','388',264104.69,265425.30,1320.61,217900.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','236522',4543660,'2600','388',333866.57,333866.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236522',4543661,'2601','388',348447.26,348447.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236522',4543662,'2602','388',356670.64,357886.82,1216.18,200669.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','236522',4543663,'2603','388',200268.38,200268.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236522',4543664,'2604','388',280814.46,281718.37,903.91,149145.15,0.00,0.00,0.00,0.00,0.00),('1','171','932','236522',4543665,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236522',4543666,'2741','412',466012.69,466518.86,506.17,172097.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','236633',4545547,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236633',4545548,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236633',4545549,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236633',4545550,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236633',4545551,'2597','388',356761.90,357236.46,474.56,78302.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','236633',4545552,'2598','388',368620.72,369614.35,993.63,163948.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','236633',4545553,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236633',4545554,'2600','388',333866.57,334695.56,828.99,136783.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','236633',4545555,'2601','388',348447.26,349378.06,930.80,153582.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236633',4545556,'2602','388',357886.82,357886.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236633',4545557,'2603','388',200268.38,200268.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236633',4545558,'2604','388',281718.37,282763.95,1045.58,172520.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','236633',4545559,'2740','412',95493.88,95493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236633',4545560,'2741','412',466518.86,466795.20,276.34,93955.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','236743',4547273,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236743',4547274,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236743',4547275,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236743',4547276,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236743',4547277,'2597','388',357236.46,359502.18,2265.72,373843.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','236743',4547278,'2598','388',369614.35,370325.15,710.80,117282.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236743',4547279,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236743',4547280,'2600','388',334695.56,336405.95,1710.39,282214.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','236743',4547281,'2601','388',349378.06,349378.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236743',4547282,'2602','388',357886.82,359341.00,1454.18,239939.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','236743',4547283,'2603','388',200268.38,201515.45,1247.07,205766.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','236743',4547284,'2604','388',282763.95,282763.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236743',4547285,'2740','412',95493.88,95622.19,128.31,43625.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','236743',4547286,'2741','412',466795.20,468399.24,1604.04,545373.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','236837',4549094,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236837',4549095,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236837',4549096,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236837',4549097,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236837',4549098,'2597','388',359502.18,359502.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236837',4549099,'2598','388',370325.15,370325.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236837',4549100,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236837',4549101,'2600','388',336405.95,336405.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236837',4549102,'2601','388',349378.06,349378.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236837',4549103,'2602','388',359341.00,359341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236837',4549104,'2603','388',201515.45,201515.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236837',4549105,'2604','388',282763.95,282763.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236837',4549106,'2740','412',95622.19,95622.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236837',4549107,'2741','412',468399.24,468399.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236863',4549538,'2593','388',384606.74,384606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236863',4549539,'2594','388',397900.23,397900.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236863',4549540,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236863',4549541,'2596','388',391035.82,391035.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236863',4549542,'2597','388',359502.18,360533.59,1031.41,170182.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','236863',4549543,'2598','388',370325.15,371652.05,1326.90,218938.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','236863',4549544,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236863',4549545,'2600','388',336405.95,337952.47,1546.52,255175.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','236863',4549546,'2601','388',349378.06,350622.21,1244.15,205284.75,0.00,0.00,0.00,0.00,0.00),('1','171','879','236863',4549547,'2602','388',359341.00,359341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236863',4549548,'2603','388',201515.45,201515.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236863',4549549,'2604','388',282763.95,283563.60,799.65,131942.25,0.00,0.00,0.00,0.00,0.00),('1','171','932','236863',4549550,'2740','412',95622.19,95622.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236863',4549551,'2741','412',468399.24,469102.82,703.58,239217.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','236969',4551351,'2593','388',384606.74,385903.10,1296.36,213899.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','236969',4551352,'2594','388',397900.23,399130.53,1230.30,202999.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','236969',4551353,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','236969',4551354,'2596','388',391035.82,392444.69,1408.87,232463.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','236969',4551355,'2597','388',360533.59,362370.51,1836.92,303091.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','236969',4551356,'2598','388',371652.05,371652.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236969',4551357,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','236969',4551358,'2600','388',337952.47,339422.12,1469.65,242492.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','236969',4551359,'2601','388',350622.21,350622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236969',4551360,'2602','388',359341.00,359341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','236969',4551361,'2603','388',201515.45,201540.31,24.86,4101.90,0.00,0.00,0.00,0.00,0.00),('1','171','879','236969',4551362,'2604','388',283563.60,283563.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236969',4551363,'2740','412',95622.19,95747.19,125.00,42500.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','236969',4551364,'2741','412',469102.82,469424.58,321.76,109398.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','237069',4553093,'2593','388',385903.10,386844.54,941.44,155337.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','237069',4553094,'2594','388',399130.53,400128.53,998.00,164670.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237069',4553095,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237069',4553096,'2596','388',392444.69,393824.55,1379.86,227676.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','237069',4553097,'2597','388',362370.51,363866.88,1496.37,246901.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','237069',4553098,'2598','388',371652.05,371652.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237069',4553099,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237069',4553100,'2600','388',339422.12,340438.76,1001.64,165270.60,0.00,0.00,15.00,0.00,0.00),('1','171','879','237069',4553101,'2601','388',350622.21,350622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237069',4553102,'2602','388',359341.00,359341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237069',4553103,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237069',4553104,'2604','388',283563.60,283563.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237069',4553105,'2740','412',95747.19,95747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237069',4553106,'2741','412',469424.58,470435.84,1011.26,343828.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','237122',4554229,'2593','388',386844.54,386844.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237122',4554230,'2594','388',400128.53,400128.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237122',4554231,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237122',4554232,'2596','388',393824.55,393824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237122',4554233,'2597','388',363866.88,363866.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237122',4554234,'2598','388',371652.05,371652.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237122',4554235,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237122',4554236,'2600','388',340438.76,340438.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237122',4554237,'2601','388',350622.21,350622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237122',4554238,'2602','388',359341.00,359341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237122',4554239,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237122',4554240,'2604','388',283563.60,283563.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237122',4554241,'2740','412',95747.19,95747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237122',4554242,'2741','412',470435.84,470435.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237181',4555058,'2593','388',386844.54,387885.62,1041.08,171778.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','237181',4555059,'2594','388',400128.53,400710.08,581.55,95955.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','237181',4555060,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237181',4555061,'2596','388',393824.55,395381.72,1557.17,256933.05,0.00,0.00,0.00,0.00,0.00),('1','171','878','237181',4555062,'2597','388',363866.88,363866.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237181',4555063,'2598','388',371652.05,371705.99,53.94,8900.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','237181',4555064,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237181',4555065,'2600','388',340438.76,341176.10,737.34,121661.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','237181',4555066,'2601','388',350622.21,350622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237181',4555067,'2602','388',359341.00,361024.33,1683.33,277749.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','237181',4555068,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237181',4555069,'2604','388',283563.60,285048.76,1485.16,245051.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','237181',4555070,'2740','412',95747.19,95747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237181',4555071,'2741','412',470435.84,471290.42,854.58,290557.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','237279',4556868,'2593','388',387885.62,389205.83,1320.21,217834.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','237279',4556869,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237279',4556870,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237279',4556871,'2596','388',395381.72,396549.78,1168.06,192729.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','237279',4556872,'2597','388',363866.88,364830.87,963.99,159058.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','237279',4556873,'2598','388',371705.99,371705.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237279',4556874,'2599','388',265425.30,265425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237279',4556875,'2600','388',341176.10,342066.30,890.20,146883.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237279',4556876,'2601','388',350622.21,351474.05,851.84,140553.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','237279',4556877,'2602','388',361024.33,361024.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237279',4556878,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237279',4556879,'2604','388',285048.76,285048.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237279',4556880,'2740','412',95747.19,95747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237279',4556881,'2741','412',471290.42,471774.56,484.14,164607.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','237385',4558849,'2593','388',389205.83,390329.05,1123.22,185331.30,0.00,0.00,0.00,0.00,0.00),('1','171','877','237385',4558850,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237385',4558851,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237385',4558852,'2596','388',396549.78,396549.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237385',4558853,'2597','388',364830.87,364830.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237385',4558854,'2598','388',371705.99,373795.00,2089.01,344686.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','237385',4558855,'2599','388',265425.30,266367.64,942.34,155486.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','237385',4558856,'2600','388',342066.30,342066.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237385',4558857,'2601','388',351474.05,351474.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237385',4558858,'2602','388',361024.33,361024.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237385',4558859,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237385',4558860,'2604','388',285048.76,286436.45,1387.69,228968.85,0.00,0.00,0.00,0.00,0.00),('1','171','932','237385',4558861,'2740','412',95747.19,95747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237385',4558862,'2741','412',471774.56,472843.88,1069.32,363568.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','237621',4562987,'2593','388',390329.05,391870.76,1541.71,254382.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','237621',4562988,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237621',4562989,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237621',4562990,'2596','388',396549.78,396549.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237621',4562991,'2597','388',364830.87,364830.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237621',4562992,'2598','388',373795.00,375455.33,1660.33,273954.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','237621',4562993,'2599','388',266367.64,266367.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237621',4562994,'2600','388',342066.30,343469.24,1402.94,231485.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','237621',4562995,'2601','388',351474.05,352681.75,1207.70,199270.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','237621',4562996,'2602','388',361024.33,361024.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237621',4562997,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237621',4562998,'2604','388',286436.45,286436.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237621',4562999,'2740','412',95747.19,95981.60,234.41,79699.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','237621',4563000,'2741','412',472843.88,473614.47,770.59,262000.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','237683',4564014,'2593','388',391870.76,393649.62,1778.86,293511.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','237683',4564015,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237683',4564016,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237683',4564017,'2596','388',396549.78,398374.68,1824.90,301108.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','237683',4564018,'2597','388',364830.87,366498.52,1667.65,275162.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','237683',4564019,'2598','388',375455.33,375455.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237683',4564020,'2599','388',266367.64,267929.22,1561.58,257660.70,0.00,0.00,0.00,0.00,0.00),('1','171','878','237683',4564021,'2600','388',343469.24,343469.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237683',4564022,'2601','388',352681.75,352681.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237683',4564023,'2602','388',361024.33,362284.13,1259.80,207867.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237683',4564024,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237683',4564025,'2604','388',286436.45,286436.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237683',4564026,'2740','412',95981.60,95981.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237683',4564027,'2741','412',473614.47,474307.82,693.35,235739.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237756',4565248,'2593','388',393649.62,395271.92,1622.30,267679.50,0.00,0.00,0.00,0.00,0.00),('1','171','877','237756',4565249,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237756',4565250,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237756',4565251,'2596','388',398374.68,398374.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237756',4565252,'2597','388',366498.52,366498.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237756',4565253,'2598','388',375455.33,377142.05,1686.72,278308.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','237756',4565254,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237756',4565255,'2600','388',343469.24,344746.57,1277.33,210759.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','237756',4565256,'2601','388',352681.75,353929.04,1247.29,205802.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','237756',4565257,'2602','388',362284.13,362284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237756',4565258,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237756',4565259,'2604','388',286436.45,286436.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237756',4565260,'2740','412',95981.60,95981.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237756',4565261,'2741','412',474307.82,474659.87,352.05,119697.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237881',4567251,'2593','388',395271.92,396805.12,1533.20,252978.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237881',4567252,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237881',4567253,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237881',4567254,'2596','388',398374.68,400029.67,1654.99,273073.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','237881',4567255,'2597','388',366498.52,367870.05,1371.53,226302.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','237881',4567256,'2598','388',377142.05,377448.30,306.25,50531.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','237881',4567257,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237881',4567258,'2600','388',344746.57,346573.41,1826.84,301428.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','237881',4567259,'2601','388',353929.04,355622.81,1693.77,279472.05,0.00,0.00,0.00,0.00,0.00),('1','171','879','237881',4567260,'2602','388',362284.13,362284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237881',4567261,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237881',4567262,'2604','388',286436.45,286436.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237881',4567263,'2740','412',95981.60,97986.10,2004.50,681530.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237881',4567264,'2741','412',474659.87,475220.99,561.12,190780.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','237995',4569094,'2593','388',396805.12,397797.78,992.66,163788.90,0.00,0.00,0.00,0.00,0.00),('1','171','877','237995',4569095,'2594','388',400710.08,400710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237995',4569096,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','237995',4569097,'2596','388',400029.67,401350.28,1320.61,217900.65,0.00,0.00,0.00,0.00,0.00),('1','171','878','237995',4569098,'2597','388',367870.05,369336.88,1466.83,242026.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','237995',4569099,'2598','388',377448.30,377448.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237995',4569100,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','237995',4569101,'2600','388',346573.41,347852.51,1279.10,211051.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','237995',4569102,'2601','388',355622.81,356845.52,1222.71,201747.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','237995',4569103,'2602','388',362284.13,362284.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237995',4569104,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','237995',4569105,'2604','388',286436.45,286436.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237995',4569106,'2740','412',97986.10,97986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','237995',4569107,'2741','412',475220.99,475728.15,507.16,172434.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','238130',4571195,'2593','388',397797.78,398797.78,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238130',4571196,'2594','388',400710.08,401710.08,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238130',4571197,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238130',4571198,'2596','388',401350.28,402680.34,1330.06,219459.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','238130',4571199,'2597','388',369336.88,371131.84,1794.96,296168.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','238130',4571200,'2598','388',377448.30,377448.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238130',4571201,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238130',4571202,'2600','388',347852.51,349481.27,1628.76,268745.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','238130',4571203,'2601','388',356845.52,356845.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238130',4571204,'2602','388',362284.13,363785.04,1500.91,247650.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','238130',4571205,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238130',4571206,'2604','388',286436.45,287651.96,1215.51,200559.15,0.00,0.00,0.00,0.00,0.00),('1','171','932','238130',4571207,'2740','412',97986.10,98222.21,236.11,80277.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','238130',4571208,'2741','412',475728.15,477235.68,1507.53,512560.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','238202',4572562,'2593','388',398797.78,399255.76,457.98,75566.70,0.00,0.00,0.00,0.00,0.00),('1','171','877','238202',4572563,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238202',4572564,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238202',4572565,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238202',4572566,'2597','388',371131.84,373013.68,1881.84,310503.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','238202',4572567,'2598','388',377448.30,377448.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238202',4572568,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238202',4572569,'2600','388',349481.27,351091.58,1610.31,265701.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','238202',4572570,'2601','388',356845.52,359358.09,2512.57,414574.05,0.00,0.00,0.00,0.00,0.00),('1','171','879','238202',4572571,'2602','388',363785.04,364988.91,1183.87,195338.55,0.00,0.00,20.00,0.00,0.00),('1','171','879','238202',4572572,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238202',4572573,'2604','388',287651.96,288123.86,471.90,77863.50,0.00,0.00,0.00,0.00,0.00),('1','171','932','238202',4572574,'2740','412',98222.21,98222.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238202',4572575,'2741','412',477235.68,478348.68,1113.00,378420.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238361',4575342,'2593','388',399255.76,399255.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238361',4575343,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238361',4575344,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238361',4575345,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238361',4575346,'2597','388',373013.68,374834.14,1820.46,300375.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','238361',4575347,'2598','388',377448.30,377448.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238361',4575348,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238361',4575349,'2600','388',351091.58,352971.17,1879.59,310132.35,0.00,0.00,0.00,0.00,0.00),('1','171','879','238361',4575350,'2601','388',359358.09,361315.91,1957.82,323040.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','238361',4575351,'2602','388',364988.91,364988.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238361',4575352,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238361',4575353,'2604','388',288123.86,289574.24,1450.38,239312.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','238361',4575354,'2740','412',98222.21,98222.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238361',4575355,'2741','412',478348.68,479120.06,771.38,262269.20,0.00,0.00,0.00,0.00,0.00),('1','171','877','238480',4577263,'2593','388',399255.76,399255.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238480',4577264,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238480',4577265,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238480',4577266,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238480',4577267,'2597','388',374834.14,376959.99,2125.85,350765.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','238480',4577268,'2598','388',377448.30,377448.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238480',4577269,'2599','388',267929.22,267929.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238480',4577270,'2600','388',352971.17,354991.45,2020.28,333346.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','238480',4577271,'2601','388',361315.91,362715.85,1399.94,230990.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','238480',4577272,'2602','388',364988.91,364988.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238480',4577273,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238480',4577274,'2604','388',289574.24,290963.67,1389.43,229255.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','238480',4577275,'2740','412',98222.21,98222.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238480',4577276,'2741','412',479120.06,479580.37,460.31,156505.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','238615',4579437,'2593','388',399255.76,399255.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238615',4579438,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238615',4579439,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238615',4579440,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238615',4579441,'2597','388',376959.99,378269.12,1309.13,216006.45,0.00,0.00,0.00,0.00,0.00),('1','171','878','238615',4579442,'2598','388',377448.30,378936.40,1488.10,245536.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','238615',4579443,'2599','388',267929.22,269562.42,1633.20,269478.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238615',4579444,'2600','388',354991.45,354991.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238615',4579445,'2601','388',362715.85,362715.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238615',4579446,'2602','388',364988.91,366413.14,1404.23,231697.95,0.00,0.00,20.00,0.00,0.00),('1','171','879','238615',4579447,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238615',4579448,'2604','388',290963.67,292823.56,1859.89,306881.85,0.00,0.00,0.00,0.00,0.00),('1','171','932','238615',4579449,'2740','412',98222.21,98372.21,150.00,51000.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238615',4579450,'2741','412',479580.37,480618.96,1038.59,353120.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','238630',4579732,'2593','388',399255.76,399255.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238630',4579733,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238630',4579734,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238630',4579735,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238630',4579736,'2597','388',378269.12,378762.99,493.87,81488.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','238630',4579737,'2598','388',378936.40,380223.15,1286.75,212313.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','238630',4579738,'2599','388',269562.42,270103.67,541.25,89306.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','238630',4579739,'2600','388',354991.45,356911.75,1900.30,313549.50,0.00,0.00,20.00,0.00,0.00),('1','171','879','238630',4579740,'2601','388',362715.85,363530.27,814.42,134379.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','238630',4579741,'2602','388',366413.14,366413.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238630',4579742,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238630',4579743,'2604','388',292823.56,293635.99,812.43,134050.95,0.00,0.00,0.00,0.00,0.00),('1','171','932','238630',4579744,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238630',4579745,'2741','412',480618.96,481318.55,699.59,237860.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','238842',4583519,'2593','388',399255.76,399255.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238842',4583520,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238842',4583521,'2595','388',337221.49,337221.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','238842',4583522,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','238842',4583523,'2597','388',378762.99,378800.55,37.56,6197.40,0.00,0.00,0.00,0.00,0.00),('1','171','878','238842',4583524,'2598','388',380223.15,380349.22,126.07,20801.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','238842',4583525,'2599','388',270103.67,270144.89,41.22,6801.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','238842',4583526,'2600','388',356911.75,356955.08,43.33,7149.45,0.00,0.00,0.00,0.00,0.00),('1','171','879','238842',4583527,'2601','388',363530.27,363592.45,62.18,10259.70,0.00,0.00,0.00,0.00,0.00),('1','171','879','238842',4583528,'2602','388',366413.14,366413.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238842',4583529,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','238842',4583530,'2604','388',293635.99,293635.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238842',4583531,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','238842',4583532,'2741','412',481318.55,481595.56,277.01,94183.40,0.00,0.00,0.00,0.00,0.00),('1','171','877','239449',4594197,'2593','388',399255.76,400918.51,1662.75,274353.75,0.00,0.00,0.00,0.00,0.00),('1','171','877','239449',4594198,'2594','388',401710.08,401710.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239449',4594199,'2595','388',337221.49,337595.10,373.61,61645.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','239449',4594200,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239449',4594201,'2597','388',378800.55,380218.01,1417.46,233880.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','239449',4594202,'2598','388',380349.22,380349.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239449',4594203,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239449',4594204,'2600','388',356955.08,358542.68,1587.60,261954.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239449',4594205,'2601','388',363592.45,363683.36,90.91,15000.15,0.00,0.00,0.00,0.00,0.00),('1','171','879','239449',4594206,'2602','388',366413.14,366413.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239449',4594207,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239449',4594208,'2604','388',293635.99,293635.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239449',4594209,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239449',4594210,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239656',4597799,'2593','388',400918.51,404624.30,3705.79,611455.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','239656',4597800,'2594','388',401710.08,403710.35,2000.27,330044.55,0.00,0.00,0.00,0.00,0.00),('1','171','877','239656',4597801,'2595','388',337595.10,337595.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239656',4597802,'2596','388',402680.34,402680.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239656',4597803,'2597','388',380218.01,381911.80,1693.79,279475.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','239656',4597804,'2598','388',380349.22,380349.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239656',4597805,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239656',4597806,'2600','388',358542.68,360078.02,1535.34,253331.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','239656',4597807,'2601','388',363683.36,363683.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239656',4597808,'2602','388',366413.14,367345.18,932.04,153786.60,0.00,0.00,0.00,0.00,0.00),('1','171','879','239656',4597809,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239656',4597810,'2604','388',293635.99,294562.51,926.52,152875.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','239656',4597811,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239656',4597812,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239788',4599989,'2593','388',404624.30,406661.73,2037.43,336175.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','239788',4599990,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239788',4599991,'2595','388',337595.10,337595.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239788',4599992,'2596','388',402680.34,404395.17,1714.83,282946.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','239788',4599993,'2597','388',381911.80,381911.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239788',4599994,'2598','388',380349.22,382613.76,2264.54,373649.10,0.00,0.00,0.00,0.00,0.00),('1','171','878','239788',4599995,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239788',4599996,'2600','388',360078.02,360420.38,342.36,56489.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','239788',4599997,'2601','388',363683.36,365392.87,1689.51,278769.15,0.00,0.00,20.00,0.00,0.00),('1','171','879','239788',4599998,'2602','388',367345.18,367345.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239788',4599999,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239788',4600000,'2604','388',294562.51,294562.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239788',4600001,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239788',4600002,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239863',4601423,'2593','388',406661.73,407984.57,1322.84,218268.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','239863',4601424,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239863',4601425,'2595','388',337595.10,337595.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','239863',4601426,'2596','388',404395.17,404395.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239863',4601427,'2597','388',381911.80,381911.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239863',4601428,'2598','388',382613.76,384157.06,1543.30,254644.50,0.00,0.00,0.00,0.00,0.00),('1','171','878','239863',4601429,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','239863',4601430,'2600','388',360420.38,361523.32,1102.94,181985.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','239863',4601431,'2601','388',365392.87,366042.69,649.82,107220.30,0.00,0.00,0.00,0.00,0.00),('1','171','879','239863',4601432,'2602','388',367345.18,367345.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239863',4601433,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','239863',4601434,'2604','388',294562.51,294872.11,309.60,51084.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239863',4601435,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','239863',4601436,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240004',4603677,'2593','388',407984.57,409901.76,1917.19,316336.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','240004',4603678,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240004',4603679,'2595','388',337595.10,337595.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240004',4603680,'2596','388',404395.17,406522.29,2127.12,350974.80,0.00,0.00,0.00,0.00,0.00),('1','171','878','240004',4603681,'2597','388',381911.80,383696.64,1784.84,294498.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','240004',4603682,'2598','388',384157.06,384157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240004',4603683,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240004',4603684,'2600','388',361523.32,361523.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240004',4603685,'2601','388',366042.69,367498.17,1455.48,240154.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','240004',4603686,'2602','388',367345.18,367345.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240004',4603687,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240004',4603688,'2604','388',294872.11,294872.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240004',4603689,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240004',4603690,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240104',4605653,'2593','388',409901.76,411240.01,1338.25,220811.25,0.00,0.00,0.00,0.00,0.00),('1','171','877','240104',4605654,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240104',4605655,'2595','388',337595.10,337595.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240104',4605656,'2596','388',406522.29,406522.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240104',4605657,'2597','388',383696.64,384968.27,1271.63,209818.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','240104',4605658,'2598','388',384157.06,384157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240104',4605659,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240104',4605660,'2600','388',361523.32,363049.39,1526.07,251801.55,0.00,0.00,0.00,0.00,0.00),('1','171','879','240104',4605661,'2601','388',367498.17,368786.66,1288.49,212600.85,0.00,0.00,0.00,0.00,0.00),('1','171','879','240104',4605662,'2602','388',367345.18,367345.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240104',4605663,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240104',4605664,'2604','388',294872.11,295550.44,678.33,111924.45,0.00,0.00,0.00,0.00,0.00),('1','171','932','240104',4605665,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240104',4605666,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240209',4607356,'2593','388',411240.01,411271.52,31.51,5199.15,0.00,0.00,0.00,0.00,0.00),('1','171','877','240209',4607357,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240209',4607358,'2595','388',337595.10,340153.67,2558.57,422164.05,0.00,0.00,0.00,0.00,0.00),('1','171','877','240209',4607359,'2596','388',406522.29,406522.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240209',4607360,'2597','388',384968.27,387392.13,2423.86,399936.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','240209',4607361,'2598','388',384157.06,384157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240209',4607362,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240209',4607363,'2600','388',363049.39,363049.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240209',4607364,'2601','388',368786.66,368786.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240209',4607365,'2602','388',367345.18,368575.81,1230.63,203053.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','240209',4607366,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240209',4607367,'2604','388',295550.44,296722.80,1172.36,193439.40,0.00,0.00,0.00,0.00,0.00),('1','171','932','240209',4607368,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240209',4607369,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240304',4609064,'2593','388',411271.52,412896.55,1625.03,268129.95,0.00,0.00,0.00,0.00,0.00),('1','171','877','240304',4609065,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240304',4609066,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240304',4609067,'2596','388',406522.29,406522.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240304',4609068,'2597','388',387392.13,388640.35,1248.22,205956.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','240304',4609069,'2598','388',384157.06,384157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240304',4609070,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240304',4609071,'2600','388',363049.39,363899.71,850.32,140302.80,0.00,0.00,0.00,0.00,0.00),('1','171','879','240304',4609072,'2601','388',368786.66,369918.02,1131.36,186674.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','240304',4609073,'2602','388',368575.81,368575.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240304',4609074,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240304',4609075,'2604','388',296722.80,297535.58,812.78,134108.70,0.00,0.00,0.00,0.00,0.00),('1','171','932','240304',4609076,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240304',4609077,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240466',4611424,'2593','388',412896.55,412896.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240466',4611425,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240466',4611426,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240466',4611427,'2596','388',406522.29,408245.90,1703.61,281095.65,0.00,0.00,20.00,0.00,0.00),('1','171','878','240466',4611428,'2597','388',388640.35,389023.26,382.91,63180.15,0.00,0.00,0.00,0.00,0.00),('1','171','878','240466',4611429,'2598','388',384157.06,386298.53,2141.47,353342.55,0.00,0.00,0.00,0.00,0.00),('1','171','878','240466',4611430,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240466',4611431,'2600','388',363899.71,363899.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240466',4611432,'2601','388',369918.02,370987.02,1069.00,176385.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240466',4611433,'2602','388',368575.81,368575.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240466',4611434,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240466',4611435,'2604','388',297535.58,298979.90,1444.32,238312.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','240466',4611436,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240466',4611437,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240560',4613091,'2593','388',412896.55,414467.39,1570.84,259188.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','240560',4613092,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240560',4613093,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240560',4613094,'2596','388',408245.90,409119.75,873.85,144185.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','240560',4613095,'2597','388',389023.26,389795.71,772.45,127454.25,0.00,0.00,0.00,0.00,0.00),('1','171','878','240560',4613096,'2598','388',386298.53,386298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240560',4613097,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240560',4613098,'2600','388',363899.71,364812.32,912.61,150580.65,0.00,0.00,0.00,0.00,0.00),('1','171','879','240560',4613099,'2601','388',370987.02,371555.76,568.74,93842.10,0.00,0.00,0.00,0.00,0.00),('1','171','879','240560',4613100,'2602','388',368575.81,368575.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240560',4613101,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240560',4613102,'2604','388',298979.90,299523.92,544.02,89763.30,0.00,0.00,0.00,0.00,0.00),('1','171','932','240560',4613103,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240560',4613104,'2741','412',481595.56,481595.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240690',4614950,'2593','388',414467.39,415568.93,1101.54,181754.10,0.00,0.00,0.00,0.00,0.00),('1','171','877','240690',4614951,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240690',4614952,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240690',4614953,'2596','388',409119.75,410043.30,923.55,152385.75,0.00,0.00,0.00,0.00,0.00),('1','171','878','240690',4614954,'2597','388',389795.71,390730.53,934.82,154245.30,0.00,0.00,0.00,0.00,0.00),('1','171','878','240690',4614955,'2598','388',386298.53,386298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240690',4614956,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240690',4614957,'2600','388',364812.32,364812.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240690',4614958,'2601','388',371555.76,371555.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240690',4614959,'2602','388',368575.81,369838.48,1242.67,205040.55,0.00,0.00,20.00,0.00,0.00),('1','171','879','240690',4614960,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240690',4614961,'2604','388',299523.92,300196.64,672.72,110998.80,0.00,0.00,0.00,0.00,0.00),('1','171','932','240690',4614962,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240690',4614963,'2741','412',481595.56,481866.75,271.19,92204.60,0.00,0.00,0.00,0.00,0.00),('1','171','877','240811',4616951,'2593','388',415568.93,416824.54,1255.61,207175.65,0.00,0.00,0.00,0.00,0.00),('1','171','877','240811',4616952,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240811',4616953,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240811',4616954,'2596','388',410043.30,410043.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240811',4616955,'2597','388',390730.53,392210.36,1479.83,244171.95,0.00,0.00,0.00,0.00,0.00),('1','171','878','240811',4616956,'2598','388',386298.53,386298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240811',4616957,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240811',4616958,'2600','388',364812.32,365794.62,982.30,162079.50,0.00,0.00,0.00,0.00,0.00),('1','171','879','240811',4616959,'2601','388',371555.76,372342.92,787.16,129881.40,0.00,0.00,0.00,0.00,0.00),('1','171','879','240811',4616960,'2602','388',369838.48,369838.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240811',4616961,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240811',4616962,'2604','388',300196.64,300991.61,794.97,131170.05,0.00,0.00,0.00,0.00,0.00),('1','171','932','240811',4616963,'2740','412',98372.21,98372.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','932','240811',4616964,'2741','412',481866.75,482346.07,479.32,162968.80,0.00,0.00,0.00,0.00,0.00),('1','171','877','240980',4620040,'2593','388',416824.54,417455.93,631.39,104179.35,0.00,0.00,0.00,0.00,0.00),('1','171','877','240980',4620041,'2594','388',403710.35,403710.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240980',4620042,'2595','388',340153.67,340153.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','877','240980',4620043,'2596','388',410043.30,410791.94,748.64,123525.60,0.00,0.00,0.00,0.00,0.00),('1','171','878','240980',4620044,'2597','388',392210.36,392639.95,429.59,70882.35,0.00,0.00,0.00,0.00,0.00),('1','171','878','240980',4620045,'2598','388',386298.53,387090.79,792.26,130722.90,0.00,0.00,0.00,0.00,0.00),('1','171','878','240980',4620046,'2599','388',270144.89,270144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','878','240980',4620047,'2600','388',365794.62,366399.70,605.08,99838.20,0.00,0.00,0.00,0.00,0.00),('1','171','879','240980',4620048,'2601','388',372342.92,372711.57,368.65,60827.25,0.00,0.00,0.00,0.00,0.00),('1','171','879','240980',4620049,'2602','388',369838.48,371204.91,1366.43,225460.95,0.00,0.00,0.00,0.00,0.00),('1','171','879','240980',4620050,'2603','388',201540.31,201540.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','171','879','240980',4620051,'2604','388',300991.61,302365.70,1374.09,226724.85,0.00,0.00,0.00,0.00,0.00),('1','171','932