-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_167
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_167`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_167` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_167`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3304 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3136,400283,'',0,'24','1','167','SALARIES ','','2021-02-08 14:02:51',5,0.00,0.00,'','178','2021-02-08 14:02:51','178',0,1),(3137,20045,'',0,'20','1','167','SALES','','2021-02-08 14:02:58',5,0.00,0.00,'','178','2021-02-08 14:02:58','178',0,1),(3138,400284,'',0,'24','1','167','PURCHASES','','2021-02-08 14:03:08',5,0.00,0.00,'','178','2021-02-08 14:03:08','178',0,1),(3139,40045,'',0,'6.1','1','167','CASH','','2021-02-08 14:03:16',5,0.00,0.00,'','178','2021-02-08 14:03:16','178',0,1),(3298,400536,'',0,'2','1','167','E-BILLS COLLECTION ','','2021-04-22 11:23:19',5,0.00,0.00,'','426','2021-04-22 11:23:19','426',0,1),(3299,400537,'',0,'2','1','167','POS','','2021-04-22 11:23:43',5,0.00,0.00,'','426','2021-04-22 11:23:43','426',0,1),(3300,400538,'',0,'2','1','167','POS FIDELITY','','2022-02-25 14:37:25',5,0.00,0.00,'','426','2022-02-25 14:37:25','426',0,0),(3301,400539,'',0,'2','1','167','POS ECO','','2022-02-25 14:38:30',5,0.00,0.00,'','426','2022-02-25 14:38:30','426',0,0),(3302,400540,'',0,'2','1','167','POS UBA','','2022-02-25 14:38:42',5,0.00,0.00,'','426','2022-02-25 14:38:42','426',0,0),(3303,400541,'',0,'2','1','167','Surplus account ','','2022-12-26 08:19:15',5,0.00,0.00,'','975','2022-12-26 08:19:15','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4023 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2594,'','1','167','MAROOFU NIG LTD','MAROOFU','08060256800','maroofung@gmail.com','ILORIN','KWARA ','KWARA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 08:59:18',5,'426','2021-04-23 08:59:18','426'),(2595,'','1','167','PROTADECH NIG TLD','PROTADECH','08034029005','protadech@gmail.com','ILORIN','KWARA','KWARA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 09:00:54',5,'426','2021-04-23 09:00:54','426'),(2596,'','1','167','ABULATEEF OIL COMPANY','ABDULATEEF','08068314458','abdulateef@gmail.com','ILORIN','KWARA','KWARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 09:02:14',5,'426','2021-04-23 09:02:14','426'),(2737,'','1','167','D.S EXECUTIVE FARM','ABDUL','07069399128','dsexecutivefarm@gmail.com','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-10 13:22:35',5,'426','2021-06-10 13:22:35','426'),(2917,'','1','167','DRIVER SHORT','DRIVER','080********','driver@gmail.com','ILORIN','ILORIN','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 11:13:17',5,'426','2021-07-08 11:13:17','426'),(4021,'','1','167','EFCC','EFCC','080******123','efcc@gmail.com','ILORIN','KWARA','EFCC','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-13 15:38:12',5,'426','2021-12-13 15:38:12','426'),(4022,'','1','167','NIGERIA POLICE FORCE (ELECTION','JAMIU O. AHMED','08150816478','dopstransport@gmail.com','ILORIN','KWARA STATE','ILIRIN, KWARA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:12:54',5,'975','2023-02-21 17:12:54','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18694 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','167',14557,'880',0.00,27100.00,'2021-03-31','','2021-04-21 14:18:08','426','426',2021,'426','2021-04-21 14:18:08',5),('1','167',14558,'881',0.00,1150.00,'2021-03-31','','2021-04-21 14:18:44','426','426',2021,'426','2021-04-21 14:18:44',5),('1','167',14559,'882',0.00,600.00,'2021-03-31','','2021-04-21 14:19:08','426','426',2021,'426','2021-04-21 14:19:08',5),('1','167',14560,'883',0.00,750.00,'2021-03-31','','2021-04-21 14:19:31','426','426',2021,'426','2021-04-21 14:19:31',5),('1','167',14561,'884',0.00,600.00,'2021-03-31','','2021-04-21 14:19:53','426','426',2021,'426','2021-04-21 14:19:53',5),('1','167',14562,'887',0.00,28150.00,'2021-03-31','','2021-04-21 14:20:26','426','426',2021,'426','2021-04-21 14:20:26',5),('1','167',14563,'886',0.00,500.00,'2021-04-21','','2021-04-21 14:20:48','426','426',2021,'426','2021-04-21 14:20:48',5),('1','167',14564,'885',0.00,250.00,'2021-03-31','','2021-04-21 14:21:27','426','426',2021,'426','2021-04-21 14:21:27',5),('1','167',14565,'888',0.00,23600.00,'2021-03-31','','2021-04-21 14:22:03','426','426',2021,'426','2021-04-21 14:22:03',5),('1','167',14566,'889',0.00,39400.00,'2021-03-31','','2021-04-21 14:22:38','426','426',2021,'426','2021-04-21 14:22:38',5),('1','167',14775,'885',177.00,52.00,'2021-04-19','','2021-05-02 17:26:25','570','570',2021,'570','2021-05-02 17:26:25',5),('1','167',14776,'885',52.00,230.00,'2021-04-19','','2021-05-02 17:27:55','570','570',2021,'570','2021-05-02 17:27:55',5),('1','167',14784,'884',1705.00,2460.00,'2021-04-21','','2021-05-03 10:34:24','570','570',2021,'570','2021-05-03 10:34:24',5),('1','167',14842,'884',649.00,887.00,'2021-04-29','','2021-05-08 10:34:39','570','570',2021,'570','2021-05-08 10:34:39',5),('1','167',15033,'884',2333.00,2512.00,'2021-05-21','','2021-05-22 11:26:54','570','570',2021,'570','2021-05-22 11:26:54',5),('1','167',15034,'884',2512.00,2515.00,'2021-05-21','','2021-05-22 11:31:02','570','570',2021,'570','2021-05-22 11:31:02',5),('1','167',15035,'884',2515.00,2515.00,'2021-05-21','','2021-05-22 11:31:02','570','570',2021,'570','2021-05-22 11:31:02',5),('1','167',15036,'884',2515.00,2515.00,'2021-05-21','','2021-05-22 11:31:15','570','570',2021,'570','2021-05-22 11:31:15',5),('1','167',15062,'885',856.00,1502.00,'2021-05-24','','2021-05-24 14:40:46','570','570',2021,'570','2021-05-24 14:40:46',5),('1','167',15072,'888',481.00,4540.00,'2021-05-25','','2021-05-25 16:38:48','570','570',2021,'570','2021-05-25 16:38:48',5),('1','167',15074,'889',433.00,4540.00,'2021-05-25','','2021-05-25 17:05:46','570','570',2021,'570','2021-05-25 17:05:46',5),('1','167',15075,'889',4540.00,50.00,'2021-05-25','','2021-05-25 17:25:22','570','570',2021,'570','2021-05-25 17:25:22',5),('1','167',15076,'889',50.00,4600.00,'2021-05-25','','2021-05-25 17:27:06','570','570',2021,'570','2021-05-25 17:27:06',5),('1','167',15082,'889',4600.00,500.00,'2021-05-26','','2021-05-26 10:37:48','570','570',2021,'570','2021-05-26 10:37:48',5),('1','167',15083,'889',500.00,500.00,'2021-05-26','','2021-05-26 10:37:48','570','570',2021,'570','2021-05-26 10:37:48',5),('1','167',15084,'889',500.00,500.00,'2021-05-26','','2021-05-26 10:38:19','570','570',2021,'570','2021-05-26 10:38:19',5),('1','167',15085,'889',500.00,500.00,'2021-05-26','','2021-05-26 10:39:24','570','570',2021,'570','2021-05-26 10:39:24',5),('1','167',15086,'889',500.00,500.00,'2021-05-26','','2021-05-26 10:39:57','570','570',2021,'570','2021-05-26 10:39:57',5),('1','167',15087,'881',3749.00,500.00,'2021-05-26','','2021-05-26 10:40:40','570','570',2021,'570','2021-05-26 10:40:40',5),('1','167',15088,'881',500.00,3674.00,'2021-05-26','','2021-05-26 10:42:19','570','570',2021,'570','2021-05-26 10:42:19',5),('1','167',15161,'888',1415.00,13000.00,'2021-06-03','','2021-06-03 16:40:34','570','570',2021,'570','2021-06-03 16:40:34',5),('1','167',15255,'884',609.00,1819.00,'2021-06-14','','2021-06-14 14:02:25','570','570',2021,'570','2021-06-14 14:02:25',5),('1','167',15287,'889',-1748.00,1749.00,'2021-06-16','','2021-06-16 14:41:43','570','570',2021,'570','2021-06-16 14:41:43',5),('1','167',15305,'889',1749.00,1842.00,'2021-06-17','','2021-06-17 10:55:13','570','570',2021,'570','2021-06-17 10:55:13',5),('1','167',15308,'889',1842.00,2594.00,'2021-06-17','','2021-06-17 10:59:25','570','570',2021,'570','2021-06-17 10:59:25',5),('1','167',15333,'885',970.00,988.00,'2021-06-18','','2021-06-18 10:31:32','570','570',2021,'570','2021-06-18 10:31:32',5),('1','167',15375,'883',313.00,620.00,'2021-06-21','','2021-06-21 11:33:51','570','570',2021,'570','2021-06-21 11:33:51',5),('1','167',15378,'883',8.00,1221.00,'2021-06-21','','2021-06-21 16:18:52','570','570',2021,'570','2021-06-21 16:18:52',5),('1','167',15389,'883',1.00,130.00,'2021-06-22','','2021-06-22 09:43:56','570','570',2021,'570','2021-06-22 09:43:56',5),('1','167',15397,'888',17952.00,5000.00,'2021-06-22','','2021-06-22 16:49:51','426','426',2021,'426','2021-06-22 16:49:51',5),('1','167',15398,'889',23098.00,20950.00,'2021-06-22','','2021-06-22 16:51:15','426','426',2021,'426','2021-06-22 16:51:15',5),('1','167',15547,'883',159.30,225.00,'2021-06-30','','2021-06-30 13:50:02','570','570',2021,'570','2021-06-30 13:50:02',5),('1','167',15548,'883',225.00,265.00,'2021-06-30','','2021-06-30 13:51:49','570','570',2021,'570','2021-06-30 13:51:49',5),('1','167',15668,'885',244.88,755.00,'2021-07-07','','2021-07-07 13:44:00','570','570',2021,'570','2021-07-07 13:44:00',5),('1','167',15988,'885',1156.42,1004.00,'2021-08-09','','2021-08-09 17:50:21','570','570',2021,'570','2021-08-09 17:50:21',5),('1','167',15989,'885',1004.00,2160.00,'2021-08-09','','2021-08-09 17:53:30','570','570',2021,'570','2021-08-09 17:53:30',5),('1','167',15990,'885',2160.00,2200.00,'2021-08-09','','2021-08-09 17:55:57','570','570',2021,'570','2021-08-09 17:55:57',5),('1','167',15991,'888',2508.56,2590.00,'2021-08-09','','2021-08-09 18:31:36','570','570',2021,'570','2021-08-09 18:31:36',5),('1','167',15992,'888',2590.00,2700.00,'2021-08-09','','2021-08-09 18:34:22','570','570',2021,'570','2021-08-09 18:34:22',5),('1','167',15997,'888',109.38,258.00,'2021-08-10','','2021-08-10 10:14:47','570','570',2021,'570','2021-08-10 10:14:47',5),('1','167',15998,'888',258.00,300.00,'2021-08-10','','2021-08-10 10:16:20','570','570',2021,'570','2021-08-10 10:16:20',5),('1','167',16012,'883',659.77,1500.00,'2021-08-11','','2021-08-11 09:21:17','570','570',2021,'570','2021-08-11 09:21:17',5),('1','167',16028,'883',2.59,1260.00,'2021-08-12','','2021-08-12 09:20:43','570','570',2021,'570','2021-08-12 09:20:43',5),('1','167',16029,'883',1260.00,1280.00,'2021-08-12','','2021-08-12 09:23:35','570','570',2021,'570','2021-08-12 09:23:35',5),('1','167',16033,'883',9.01,3000.00,'2021-08-12','','2021-08-12 13:02:26','570','570',2021,'570','2021-08-12 13:02:26',5),('1','167',16039,'883',13.41,2955.00,'2021-08-12','','2021-08-12 15:02:11','570','570',2021,'570','2021-08-12 15:02:11',5),('1','167',16042,'883',2.42,3140.00,'2021-08-13','','2021-08-13 10:00:27','570','570',2021,'570','2021-08-13 10:00:27',5),('1','167',16043,'889',3046.21,75.00,'2021-08-13','','2021-08-13 10:03:01','570','570',2021,'570','2021-08-13 10:03:01',5),('1','167',16044,'889',75.00,3120.00,'2021-08-13','','2021-08-13 10:04:03','570','570',2021,'570','2021-08-13 10:04:03',5),('1','167',16048,'883',2.89,2065.00,'2021-08-13','','2021-08-13 14:15:25','570','570',2021,'570','2021-08-13 14:15:25',5),('1','167',16049,'889',3.93,1345.00,'2021-08-13','','2021-08-13 14:15:59','570','570',2021,'570','2021-08-13 14:15:59',5),('1','167',16050,'889',1345.00,1350.00,'2021-08-13','','2021-08-13 14:18:45','570','570',2021,'570','2021-08-13 14:18:45',5),('1','167',16051,'883',2065.00,2070.00,'2021-08-13','','2021-08-13 14:20:10','570','570',2021,'570','2021-08-13 14:20:10',5),('1','167',16052,'886',432.02,2400.00,'2021-08-13','','2021-08-13 14:27:12','570','570',2021,'570','2021-08-13 14:27:12',5),('1','167',16060,'883',9.85,2000.00,'2021-08-14','PURCHASE PMS','2021-08-14 14:51:03','570','570',2021,'570','2021-08-14 14:51:03',5),('1','167',16061,'883',2000.00,3050.00,'2021-08-14','PURCHASE PMS','2021-08-14 16:58:50','570','570',2021,'570','2021-08-14 16:58:50',5),('1','167',16066,'883',10.86,14000.00,'2021-08-13','','2021-08-16 08:19:48','570','570',2021,'570','2021-08-16 08:19:48',5),('1','167',16117,'887',1915.98,4250.00,'2021-08-19','','2021-08-19 14:51:27','570','570',2021,'570','2021-08-19 14:51:27',5),('1','167',16118,'887',2.62,5570.00,'2021-08-19','','2021-08-19 15:03:24','570','570',2021,'570','2021-08-19 15:03:24',5),('1','167',16119,'887',16.67,4525.00,'2021-08-19','','2021-08-19 15:28:48','570','570',2021,'570','2021-08-19 15:28:48',5),('1','167',16127,'887',3.95,9205.00,'2021-08-19','','2021-08-20 09:53:06','570','570',2021,'570','2021-08-20 09:53:06',5),('1','167',16137,'886',2796.19,3767.00,'2021-08-21','','2021-08-21 13:08:13','570','570',2021,'570','2021-08-21 13:08:13',5),('1','167',16216,'888',2597.06,2606.00,'2021-08-31','','2021-08-31 14:46:36','570','570',2021,'570','2021-08-31 14:46:36',5),('1','167',16218,'889',28998.27,250.00,'2021-09-01','','2021-09-01 09:02:08','570','570',2021,'570','2021-09-01 09:02:08',5),('1','167',16219,'889',250.00,26500.00,'2021-09-01','','2021-09-01 09:04:05','570','570',2021,'570','2021-09-01 09:04:05',5),('1','167',16220,'888',1.35,250.00,'2021-09-01','','2021-09-01 09:04:51','570','570',2021,'570','2021-09-01 09:04:51',5),('1','167',16278,'886',2045.02,2580.00,'2021-09-02','','2021-09-03 14:43:40','570','570',2021,'570','2021-09-03 14:43:40',5),('1','167',16318,'885',2390.03,2807.00,'2021-09-06','','2021-09-07 15:12:37','570','570',2021,'570','2021-09-07 15:12:37',5),('1','167',16319,'885',2390.03,2807.00,'2021-09-06','','2021-09-07 15:13:04','570','570',2021,'570','2021-09-07 15:13:04',5),('1','167',16320,'885',2390.03,2810.00,'2021-09-06','','2021-09-07 15:15:54','570','570',2021,'570','2021-09-07 15:15:54',5),('1','167',16321,'885',2390.03,2900.00,'2021-09-07','','2021-09-07 16:36:12','570','570',2021,'570','2021-09-07 16:36:12',5),('1','167',16322,'885',2390.03,50.00,'2021-09-07','','2021-09-07 16:36:46','570','570',2021,'570','2021-09-07 16:36:46',5),('1','167',16323,'885',2390.03,500.00,'2021-09-07','','2021-09-07 16:44:02','570','570',2021,'570','2021-09-07 16:44:02',5),('1','167',16324,'885',2390.03,500.00,'2021-09-07','PMS PURCHASE','2021-09-07 16:44:58','570','570',2021,'570','2021-09-07 16:44:58',5),('1','167',16791,'885',23062.11,200.00,'2021-10-13','','2021-10-13 19:45:22','570','570',2021,'570','2021-10-13 19:45:22',5),('1','167',16858,'888',3345.80,3810.00,'2021-10-17','','2021-10-18 15:09:18','570','570',2021,'570','2021-10-18 15:09:18',5),('1','167',16859,'886',3670.89,4315.00,'2021-10-18','','2021-10-18 16:30:58','570','570',2021,'570','2021-10-18 16:30:58',5),('1','167',17322,'888',27295.57,30000.00,'2021-10-31','','2021-10-31 05:43:51','426','426',2021,'426','2021-10-31 05:43:51',5),('1','167',17323,'888',30000.00,30000.00,'2021-10-31','','2021-10-31 05:44:35','426','426',2021,'426','2021-10-31 05:44:35',5),('1','167',17324,'888',30000.00,11600.00,'2021-10-31','','2021-10-31 05:45:49','426','426',2021,'426','2021-10-31 05:45:49',5),('1','167',17325,'889',9140.06,6000.00,'2021-10-31','','2021-10-31 05:46:12','426','426',2021,'426','2021-10-31 05:46:12',5),('1','167',17326,'880',7475.88,30000.00,'2021-10-31','','2021-10-31 05:46:49','426','426',2021,'426','2021-10-31 05:46:49',5),('1','167',17327,'881',40072.46,15200.00,'2021-10-31','','2021-10-31 05:47:07','426','426',2021,'426','2021-10-31 05:47:07',5),('1','167',17328,'882',32429.50,8300.00,'2021-10-31','','2021-10-31 05:47:28','426','426',2021,'426','2021-10-31 05:47:28',5),('1','167',17329,'883',3643.42,37200.00,'2021-10-31','','2021-10-31 05:47:47','426','426',2021,'426','2021-10-31 05:47:47',5),('1','167',17330,'884',37859.76,5000.00,'2021-10-31','','2021-10-31 05:48:08','426','426',2021,'426','2021-10-31 05:48:08',5),('1','167',17331,'887',3646.82,20050.00,'2021-10-31','','2021-10-31 05:48:30','426','426',2021,'426','2021-10-31 05:48:30',5),('1','167',17332,'886',16500.40,41450.00,'2021-10-31','','2021-10-31 05:48:55','426','426',2021,'426','2021-10-31 05:48:55',5),('1','167',17333,'885',15938.05,13600.00,'2021-10-31','','2021-10-31 05:49:18','426','426',2021,'426','2021-10-31 05:49:18',5),('1','167',17444,'888',161.74,3100.00,'2021-11-03','','2021-11-03 09:16:42','426','426',2021,'426','2021-11-03 09:16:42',5),('1','167',17482,'885',1562.85,3520.00,'2021-11-05','','2021-11-05 14:42:13','426','426',2021,'426','2021-11-05 14:42:13',5),('1','167',17484,'888',30123.34,900.00,'2021-11-05','','2021-11-05 19:47:33','426','426',2021,'426','2021-11-05 19:47:33',5),('1','167',17485,'889',20809.25,1100.00,'2021-11-05','','2021-11-05 19:47:51','426','426',2021,'426','2021-11-05 19:47:51',5),('1','167',17486,'889',1100.00,4700.00,'2021-11-05','','2021-11-05 19:48:44','426','426',2021,'426','2021-11-05 19:48:44',5),('1','167',17487,'880',23330.53,25550.00,'2021-11-05','','2021-11-05 19:49:04','426','426',2021,'426','2021-11-05 19:49:04',5),('1','167',17488,'881',41274.24,41700.00,'2021-11-05','','2021-11-05 19:49:25','426','426',2021,'426','2021-11-05 19:49:25',5),('1','167',17489,'882',23028.30,24400.00,'2021-11-05','','2021-11-05 19:49:43','426','426',2021,'426','2021-11-05 19:49:43',5),('1','167',17490,'883',28702.60,31000.00,'2021-11-05','','2021-11-05 19:50:00','426','426',2021,'426','2021-11-05 19:50:00',5),('1','167',17491,'884',15540.56,40650.00,'2021-11-05','','2021-11-05 19:50:20','426','426',2021,'426','2021-11-05 19:50:20',5),('1','167',17492,'887',30945.89,30900.00,'2021-11-05','','2021-11-05 19:50:39','426','426',2021,'426','2021-11-05 19:50:39',5),('1','167',17493,'886',35179.34,37200.00,'2021-11-05','','2021-11-05 19:51:08','426','426',2021,'426','2021-11-05 19:51:08',5),('1','167',17494,'885',1776.50,1950.00,'2021-11-05','','2021-11-05 19:51:35','426','426',2021,'426','2021-11-05 19:51:35',5),('1','167',17499,'880',16596.13,13300.00,'2021-11-06','','2021-11-06 11:12:39','426','426',2021,'426','2021-11-06 11:12:39',5),('1','167',17500,'881',31022.88,30150.00,'2021-11-06','','2021-11-06 11:12:54','426','426',2021,'426','2021-11-06 11:12:54',5),('1','167',17501,'882',14840.86,12500.00,'2021-11-06','','2021-11-06 11:13:46','426','426',2021,'426','2021-11-06 11:13:46',5),('1','167',17502,'883',25701.72,23800.00,'2021-11-06','','2021-11-06 11:14:04','426','426',2021,'426','2021-11-06 11:14:04',5),('1','167',17503,'884',33031.64,32850.00,'2021-11-06','','2021-11-06 11:14:30','426','426',2021,'426','2021-11-06 11:14:30',5),('1','167',17504,'887',21918.85,20250.00,'2021-11-06','','2021-11-06 11:14:57','426','426',2021,'426','2021-11-06 11:14:57',5),('1','167',17505,'886',23681.72,21600.00,'2021-11-06','','2021-11-06 11:15:34','426','426',2021,'426','2021-11-06 11:15:34',5),('1','167',17506,'885',173.31,200.00,'2021-11-06','','2021-11-06 11:15:50','426','426',2021,'426','2021-11-06 11:15:50',5),('1','167',17507,'888',900.00,28850.00,'2021-11-06','','2021-11-06 11:16:32','426','426',2021,'426','2021-11-06 11:16:32',5),('1','167',17508,'889',3825.45,18400.00,'2021-11-06','','2021-11-06 11:16:52','426','426',2021,'426','2021-11-06 11:16:52',5),('1','167',17635,'888',32248.17,34350.00,'2021-11-15','','2021-11-15 12:24:16','426','426',2021,'426','2021-11-15 12:24:16',5),('1','167',17636,'889',13124.88,15100.00,'2021-11-15','','2021-11-15 12:24:39','426','426',2021,'426','2021-11-15 12:24:39',5),('1','167',17637,'880',42650.86,750.00,'2021-11-15','','2021-11-15 12:24:55','426','426',2021,'426','2021-11-15 12:24:55',5),('1','167',17638,'881',40403.33,1150.00,'2021-11-15','','2021-11-15 12:25:18','426','426',2021,'426','2021-11-15 12:25:18',5),('1','167',17639,'882',11744.23,13700.00,'2021-11-15','','2021-11-15 12:25:40','426','426',2021,'426','2021-11-15 12:25:40',5),('1','167',17640,'883',575.02,2600.00,'2021-11-15','','2021-11-15 12:25:57','426','426',2021,'426','2021-11-15 12:25:57',5),('1','167',17641,'884',4432.77,4300.00,'2021-11-15','','2021-11-15 12:26:18','426','426',2021,'426','2021-11-15 12:26:18',5),('1','167',17642,'887',22812.30,4500.00,'2021-11-15','','2021-11-15 12:26:36','426','426',2021,'426','2021-11-15 12:26:36',5),('1','167',17643,'886',44008.81,2500.00,'2021-11-15','','2021-11-15 12:28:50','426','426',2021,'426','2021-11-15 12:28:50',5),('1','167',17644,'885',26946.15,26750.00,'2021-11-15','','2021-11-15 12:29:15','426','426',2021,'426','2021-11-15 12:29:15',5),('1','167',17906,'888',1580.07,2027.00,'2021-12-03','','2021-12-03 21:56:07','614','614',2021,'614','2021-12-03 21:56:07',5),('1','167',17959,'889',405.73,414.00,'2021-12-09','','2021-12-09 15:31:16','614','614',2021,'614','2021-12-09 15:31:16',5),('1','167',18036,'888',1204.30,1559.00,'2021-12-14','','2021-12-14 14:38:14','614','614',2021,'614','2021-12-14 14:38:14',5),('1','167',18105,'889',649.24,952.00,'2021-12-18','','2021-12-18 13:21:52','614','614',2021,'614','2021-12-18 13:21:52',5),('1','167',18197,'888',953.87,1635.00,'2021-12-25','','2021-12-25 23:31:59','614','614',2021,'614','2021-12-25 23:31:59',5),('1','167',18203,'889',1505.69,1639.00,'2021-12-26','','2021-12-26 14:02:04','614','614',2021,'614','2021-12-26 14:02:04',5),('1','167',18212,'889',0.11,200.00,'2021-12-26','','2021-12-26 20:09:55','614','614',2021,'614','2021-12-26 20:09:55',5),('1','167',18221,'889',0.00,229.00,'2021-12-27','','2021-12-27 14:05:19','614','614',2021,'614','2021-12-27 14:05:19',5),('1','167',18251,'885',2239.49,2312.00,'2021-12-29','','2021-12-29 15:29:35','614','614',2021,'614','2021-12-29 15:29:35',5),('1','167',18379,'888',3151.23,4242.00,'2022-01-07','','2022-01-07 22:17:16','614','614',2022,'614','2022-01-07 22:17:16',5),('1','167',18478,'888',1363.67,1861.00,'2022-01-17','','2022-01-17 15:19:25','614','614',2022,'614','2022-01-17 15:19:25',5),('1','167',18572,'888',373.63,754.00,'2022-01-27','','2022-01-27 14:48:21','614','614',2022,'614','2022-01-27 14:48:21',5),('1','167',18573,'888',1521.01,2004.00,'2022-02-03','','2022-02-03 15:06:17','614','614',2022,'614','2022-02-03 15:06:17',5),('1','167',18574,'889',161.23,1234.00,'2022-02-04','','2022-02-04 19:46:22','614','614',2022,'614','2022-02-04 19:46:22',5),('1','167',18575,'888',896.09,1250.00,'2022-02-15','','2022-02-15 19:20:33','614','614',2022,'614','2022-02-15 19:20:33',5),('1','167',18576,'889',1845.42,2133.00,'2022-02-18','','2022-02-18 19:21:59','614','614',2022,'614','2022-02-18 19:21:59',5),('1','167',18577,'885',698.52,14600.00,'2022-02-18','','2022-02-19 16:18:15','614','614',2022,'614','2022-02-19 16:18:15',5),('1','167',18578,'881',15650.41,200.00,'2022-02-18','','2022-02-19 16:20:54','614','614',2022,'614','2022-02-19 16:20:54',5),('1','167',18579,'885',956.60,978.00,'2022-02-27','','2022-02-27 21:16:17','614','614',2022,'614','2022-02-27 21:16:17',5),('1','167',18580,'885',9220.31,9688.00,'2022-03-02','','2022-03-02 20:31:50','614','614',2022,'614','2022-03-02 20:31:50',5),('1','167',18581,'888',816.60,1741.00,'2022-03-04','','2022-03-04 14:40:34','614','614',2022,'614','2022-03-04 14:40:34',5),('1','167',18582,'880',493.76,611.00,'2022-03-10','','2022-03-10 14:37:41','614','614',2022,'614','2022-03-10 14:37:41',5),('1','167',18583,'880',160.33,344.00,'2022-03-18','','2022-03-18 21:00:32','614','614',2022,'614','2022-03-18 21:00:32',5),('1','167',18584,'882',1544.60,5513.00,'2022-03-20','','2022-03-20 21:23:03','614','614',2022,'614','2022-03-20 21:23:03',5),('1','167',18585,'885',5222.50,1647.00,'2022-03-20','','2022-03-20 21:24:11','614','614',2022,'614','2022-03-20 21:24:11',5),('1','167',18586,'882',5513.00,1647.00,'2022-03-20','','2022-03-20 21:32:44','614','614',2022,'614','2022-03-20 21:32:44',5),('1','167',18587,'885',1647.00,5513.00,'2022-03-20','','2022-03-20 21:34:46','614','614',2022,'614','2022-03-20 21:34:46',5),('1','167',18588,'883',4122.82,4210.00,'2022-03-21','','2022-03-21 14:21:28','614','614',2022,'614','2022-03-21 14:21:28',5),('1','167',18589,'880',8320.45,8408.00,'2022-03-21','','2022-03-21 20:28:03','614','614',2022,'614','2022-03-21 20:28:03',5),('1','167',18590,'882',6330.30,6699.00,'2022-03-22','','2022-03-22 20:44:00','614','614',2022,'614','2022-03-22 20:44:00',5),('1','167',18591,'883',6787.47,7096.00,'2022-03-22','','2022-03-22 20:44:40','614','614',2022,'614','2022-03-22 20:44:40',5),('1','167',18592,'882',6478.65,6799.00,'2022-03-28','','2022-03-28 14:34:44','614','614',2022,'614','2022-03-28 14:34:44',5),('1','167',18593,'888',1806.46,2294.00,'2022-03-30','','2022-03-30 21:42:53','614','614',2022,'614','2022-03-30 21:42:53',5),('1','167',18594,'885',11191.82,11238.00,'2022-03-31','','2022-03-31 14:42:49','614','614',2022,'614','2022-03-31 14:42:49',5),('1','167',18595,'882',9346.54,10001.00,'2022-04-01','','2022-04-01 17:29:48','614','614',2022,'614','2022-04-01 17:29:48',5),('1','167',18596,'885',8741.85,9078.00,'2022-04-02','','2022-04-02 15:47:50','614','614',2022,'614','2022-04-02 15:47:50',5),('1','167',18597,'882',5038.88,5334.00,'2022-04-03','','2022-04-03 14:57:02','614','614',2022,'614','2022-04-03 14:57:02',5),('1','167',18598,'882',833.45,1292.00,'2022-04-06','','2022-04-06 20:38:29','614','614',2022,'614','2022-04-06 20:38:29',5),('1','167',18599,'883',3801.34,4027.00,'2022-04-06','','2022-04-06 20:39:28','614','614',2022,'614','2022-04-06 20:39:28',5),('1','167',18600,'881',33.05,105.00,'2022-04-12','','2022-04-12 21:49:29','614','614',2022,'614','2022-04-12 21:49:29',5),('1','167',18601,'880',316.51,608.00,'2022-04-14','','2022-04-14 14:33:41','614','614',2022,'614','2022-04-14 14:33:41',5),('1','167',18602,'881',20.98,105.00,'2022-04-14','','2022-04-14 14:35:16','614','614',2022,'614','2022-04-14 14:35:16',5),('1','167',18603,'882',7997.03,8456.00,'2022-04-15','','2022-04-15 14:51:22','614','614',2022,'614','2022-04-15 14:51:22',5),('1','167',18604,'880',706.45,1057.00,'2022-04-17','','2022-04-17 20:08:14','614','614',2022,'614','2022-04-17 20:08:14',5),('1','167',18605,'882',6517.96,6878.00,'2022-04-18','','2022-04-18 14:53:14','614','614',2022,'614','2022-04-18 14:53:14',5),('1','167',18606,'888',525.08,1134.00,'2022-04-19','','2022-04-19 14:45:57','614','614',2022,'614','2022-04-19 14:45:57',5),('1','167',18607,'888',445.64,10.00,'2022-04-21','','2022-04-21 22:10:44','614','614',2022,'614','2022-04-21 22:10:44',5),('1','167',18608,'882',6496.43,6577.00,'2022-04-26','','2022-04-26 21:54:52','614','614',2022,'614','2022-04-26 21:54:52',5),('1','167',18609,'889',368.53,923.00,'2022-04-28','','2022-04-28 13:54:02','614','614',2022,'614','2022-04-28 13:54:02',5),('1','167',18610,'882',5511.15,5699.00,'2022-04-28','','2022-04-28 20:26:54','614','614',2022,'614','2022-04-28 20:26:54',5),('1','167',18611,'881',20.82,105.00,'2022-05-01','','2022-05-01 13:34:01','614','614',2022,'614','2022-05-01 13:34:01',5),('1','167',18612,'885',979.24,1192.00,'2022-05-01','','2022-05-01 13:35:12','614','614',2022,'614','2022-05-01 13:35:12',5),('1','167',18613,'880',2884.91,3336.00,'2022-05-02','','2022-05-02 14:47:47','614','614',2022,'614','2022-05-02 14:47:47',5),('1','167',18614,'880',11184.21,11385.00,'2022-05-06','','2022-05-06 21:38:01','614','614',2022,'614','2022-05-06 21:38:01',5),('1','167',18615,'883',6160.57,6721.00,'2022-05-07','','2022-05-07 19:48:21','614','614',2022,'614','2022-05-07 19:48:21',5),('1','167',18616,'883',6680.53,6947.00,'2022-05-09','','2022-05-09 21:13:55','614','614',2022,'614','2022-05-09 21:13:55',5),('1','167',18617,'880',5675.27,6399.00,'2022-05-15','','2022-05-15 19:38:58','614','614',2022,'614','2022-05-15 19:38:58',5),('1','167',18618,'889',389.80,1164.00,'2022-05-15','','2022-05-15 20:00:52','614','614',2022,'614','2022-05-15 20:00:52',5),('1','167',18619,'882',4387.62,4460.00,'2022-05-19','','2022-05-19 14:02:53','614','614',2022,'614','2022-05-19 14:02:53',5),('1','167',18620,'888',373.80,798.00,'2022-05-25','','2022-05-25 13:41:43','614','614',2022,'614','2022-05-25 13:41:43',5),('1','167',18621,'883',3545.12,3704.00,'2022-05-27','','2022-05-27 15:02:11','614','614',2022,'614','2022-05-27 15:02:11',5),('1','167',18622,'880',2408.03,2654.00,'2022-05-31','','2022-05-31 20:44:15','614','614',2022,'614','2022-05-31 20:44:15',5),('1','167',18623,'882',8443.17,8885.00,'2022-05-31','','2022-05-31 20:45:01','614','614',2022,'614','2022-05-31 20:45:01',5),('1','167',18624,'888',92.61,562.00,'2022-06-04','','2022-06-04 20:52:00','614','614',2022,'614','2022-06-04 20:52:00',5),('1','167',18625,'888',0.23,900.00,'2022-06-09','','2022-06-09 10:35:14','426','426',2022,'426','2022-06-09 10:35:14',5),('1','167',18626,'889',2259.66,2950.00,'2022-06-09','','2022-06-09 10:35:35','426','426',2022,'426','2022-06-09 10:35:35',5),('1','167',18627,'880',490.42,1400.00,'2022-06-09','','2022-06-09 10:35:54','426','426',2022,'426','2022-06-09 10:35:54',5),('1','167',18628,'881',0.18,700.00,'2022-06-09','','2022-06-09 10:36:08','426','426',2022,'426','2022-06-09 10:36:08',5),('1','167',18629,'882',0.21,600.00,'2022-06-09','','2022-06-09 10:36:22','426','426',2022,'426','2022-06-09 10:36:22',5),('1','167',18630,'883',0.98,350.00,'2022-06-09','','2022-06-09 10:37:27','426','426',2022,'426','2022-06-09 10:37:27',5),('1','167',18631,'884',1535.21,600.00,'2022-06-09','','2022-06-09 10:37:42','426','426',2022,'426','2022-06-09 10:37:42',5),('1','167',18632,'887',1785.81,1150.00,'2022-06-09','','2022-06-09 10:37:58','426','426',2022,'426','2022-06-09 10:37:58',5),('1','167',18633,'886',2500.00,550.00,'2022-06-09','','2022-06-09 10:38:16','426','426',2022,'426','2022-06-09 10:38:16',5),('1','167',18634,'885',0.52,200.00,'2022-06-09','','2022-06-09 10:38:34','426','426',2022,'426','2022-06-09 10:38:34',5),('1','167',18635,'883',4309.34,4501.00,'2022-07-14','','2022-07-14 20:57:17','614','614',2022,'614','2022-07-14 20:57:17',5),('1','167',18636,'882',3306.73,3725.00,'2022-07-15','','2022-07-15 13:47:56','614','614',2022,'614','2022-07-15 13:47:56',5),('1','167',18637,'889',199.85,632.00,'2022-07-17','','2022-07-17 08:33:11','614','614',2022,'614','2022-07-17 08:33:11',5),('1','167',18638,'883',2791.52,2956.00,'2022-07-28','','2022-07-28 22:40:55','614','614',2022,'614','2022-07-28 22:40:55',5),('1','167',18639,'880',98.83,721.00,'2022-07-30','','2022-07-30 13:57:53','614','614',2022,'614','2022-07-30 13:57:53',5),('1','167',18640,'888',594.83,721.00,'2022-07-30','','2022-07-30 15:09:52','614','614',2022,'614','2022-07-30 15:09:52',5),('1','167',18641,'882',1.07,337.00,'2022-08-03','','2022-08-03 16:37:07','614','614',2022,'614','2022-08-03 16:37:07',5),('1','167',18642,'889',972.15,1266.00,'2022-08-04','','2022-08-04 14:25:15','614','614',2022,'614','2022-08-04 14:25:15',5),('1','167',18643,'883',2217.49,2543.00,'2022-08-08','','2022-08-08 21:07:50','614','614',2022,'614','2022-08-08 21:07:50',5),('1','167',18644,'889',2121.52,2498.00,'2022-08-09','','2022-08-09 13:01:59','614','614',2022,'614','2022-08-09 13:01:59',5),('1','167',18645,'883',3472.99,3562.00,'2022-08-13','','2022-08-13 19:42:15','614','614',2022,'614','2022-08-13 19:42:15',5),('1','167',18646,'880',200.53,400.00,'2022-08-14','','2022-08-14 21:34:45','614','614',2022,'614','2022-08-14 21:34:45',5),('1','167',18647,'882',2019.95,2442.00,'2022-08-17','','2022-08-17 20:09:13','614','614',2022,'614','2022-08-17 20:09:13',5),('1','167',18648,'888',237.61,771.00,'2022-08-19','','2022-08-19 00:06:22','614','614',2022,'614','2022-08-19 00:06:22',5),('1','167',18649,'880',8062.40,8500.00,'2022-08-20','','2022-08-20 13:35:17','614','614',2022,'614','2022-08-20 13:35:17',5),('1','167',18650,'888',1113.86,1667.00,'2022-09-01','','2022-09-01 14:10:02','614','614',2022,'614','2022-09-01 14:10:02',5),('1','167',18651,'883',3636.75,3747.00,'2022-09-03','','2022-09-03 20:50:57','614','614',2022,'614','2022-09-03 20:50:57',5),('1','167',18652,'883',1362.80,1705.00,'2022-09-09','','2022-09-09 22:03:21','614','614',2022,'614','2022-09-09 22:03:21',5),('1','167',18653,'882',6383.57,6605.00,'2022-09-10','','2022-09-10 16:07:39','614','614',2022,'614','2022-09-10 16:07:39',5),('1','167',18654,'883',6204.85,6376.00,'2022-09-12','','2022-09-12 20:16:43','614','614',2022,'614','2022-09-12 20:16:43',5),('1','167',18655,'885',2063.72,2437.00,'2022-09-13','','2022-09-13 20:12:22','614','614',2022,'614','2022-09-13 20:12:22',5),('1','167',18656,'883',3759.89,3889.00,'2022-09-16','','2022-09-16 20:32:15','614','614',2022,'614','2022-09-16 20:32:15',5),('1','167',18657,'882',4058.58,4188.00,'2022-09-19','','2022-09-19 20:58:42','614','614',2022,'614','2022-09-19 20:58:42',5),('1','167',18658,'884',2759.54,3068.00,'2022-09-20','','2022-09-20 14:46:30','614','614',2022,'614','2022-09-20 14:46:30',5),('1','167',18659,'885',5322.80,5504.00,'2022-09-20','','2022-09-20 14:53:21','614','614',2022,'614','2022-09-20 14:53:21',5),('1','167',18660,'882',2996.85,3214.00,'2022-09-23','','2022-09-23 13:21:49','614','614',2022,'614','2022-09-23 13:21:49',5),('1','167',18661,'883',2547.82,2733.00,'2022-09-25','','2022-09-25 12:36:50','614','614',2022,'614','2022-09-25 12:36:50',5),('1','167',18662,'888',69.12,200.00,'2022-09-29','','2022-09-29 09:29:54','614','614',2022,'614','2022-09-29 09:29:54',5),('1','167',18663,'888',200.00,220.00,'2022-09-29','','2022-09-29 09:33:12','614','614',2022,'614','2022-09-29 09:33:12',5),('1','167',18664,'888',0.39,587.00,'2022-09-29','','2022-09-29 21:35:01','614','614',2022,'614','2022-09-29 21:35:01',5),('1','167',18665,'888',0.11,30.00,'2022-09-30','','2022-09-30 20:54:08','614','614',2022,'614','2022-09-30 20:54:08',5),('1','167',18666,'885',6143.66,6511.00,'2022-10-01','','2022-10-01 21:23:46','614','614',2022,'614','2022-10-01 21:23:46',5),('1','167',18667,'880',35.65,178.00,'2022-10-07','','2022-10-07 21:39:30','614','614',2022,'614','2022-10-07 21:39:30',5),('1','167',18668,'888',3265.56,3582.00,'2022-10-11','','2022-10-11 16:11:37','614','614',2022,'614','2022-10-11 16:11:37',5),('1','167',18669,'880',20.40,112.00,'2022-10-19','','2022-10-19 13:26:58','614','614',2022,'614','2022-10-19 13:26:58',5),('1','167',18670,'888',772.41,31050.00,'2022-11-05','','2022-11-05 18:19:32','975','975',2022,'975','2022-11-05 18:19:32',5),('1','167',18671,'883',2808.99,2867.00,'2022-11-10','','2022-11-10 14:48:42','614','614',2022,'614','2022-11-10 14:48:42',5),('1','167',18672,'888',938.04,2888.00,'2022-11-13','','2022-11-13 15:03:13','614','614',2022,'614','2022-11-13 15:03:13',5),('1','167',18673,'888',1849.02,2300.00,'2022-12-17','','2022-12-17 14:49:15','975','975',2022,'975','2022-12-17 14:49:15',5),('1','167',18674,'888',101.17,2000.00,'2022-12-17','','2022-12-17 20:07:09','975','975',2022,'975','2022-12-17 20:07:09',5),('1','167',18675,'880',5962.04,6424.00,'2022-12-21','','2022-12-21 19:56:13','975','975',2022,'975','2022-12-21 19:56:13',5),('1','167',18676,'880',368.46,500.00,'2023-01-10','','2023-01-10 18:20:23','975','975',2023,'975','2023-01-10 18:20:23',5),('1','167',18677,'880',13176.03,13800.00,'2023-01-21','','2023-01-21 20:01:50','734','734',2023,'734','2023-01-21 20:01:50',5),('1','167',18678,'888',689.85,2400.00,'2023-01-24','','2023-01-24 14:26:31','734','734',2023,'734','2023-01-24 14:26:31',5),('1','167',18679,'880',491.71,800.00,'2023-01-29','','2023-01-29 14:31:46','734','734',2023,'734','2023-01-29 14:31:46',5),('1','167',18680,'881',3323.17,3600.00,'2023-01-31','','2023-01-31 20:28:58','734','734',2023,'734','2023-01-31 20:28:58',5),('1','167',18681,'881',2864.07,3500.00,'2023-02-08','','2023-02-08 16:46:00','734','734',2023,'734','2023-02-08 16:46:00',5),('1','167',18682,'880',604.54,900.00,'2023-02-15','','2023-02-15 14:21:23','734','734',2023,'734','2023-02-15 14:21:23',5),('1','167',18683,'880',171.29,500.00,'2023-02-21','','2023-02-21 21:15:43','734','734',2023,'734','2023-02-21 21:15:43',5),('1','167',18684,'880',500.00,500.00,'2023-02-21','','2023-02-21 21:15:48','734','734',2023,'734','2023-02-21 21:15:48',5),('1','167',18685,'880',500.00,500.00,'2023-02-21','','2023-02-21 21:15:50','734','734',2023,'734','2023-02-21 21:15:50',5),('1','167',18686,'888',171.22,700.00,'2023-02-24','','2023-02-24 16:01:39','734','734',2023,'734','2023-02-24 16:01:39',5),('1','167',18687,'880',1776.57,2400.00,'2023-02-27','','2023-02-27 20:15:00','734','734',2023,'734','2023-02-27 20:15:00',5),('1','167',18688,'884',2592.18,2700.00,'2023-03-03','','2023-03-03 16:25:32','734','734',2023,'734','2023-03-03 16:25:32',5),('1','167',18689,'885',4644.93,5000.00,'2023-03-04','','2023-03-04 08:56:51','734','734',2023,'734','2023-03-04 08:56:51',5),('1','167',18690,'882',7595.77,7800.00,'2023-03-04','','2023-03-04 10:03:31','734','734',2023,'734','2023-03-04 10:03:31',5),('1','167',18691,'885',2990.63,3100.00,'2023-03-09','','2023-03-09 15:07:40','734','734',2023,'734','2023-03-09 15:07:40',5),('1','167',18692,'880',7247.98,7600.00,'2023-03-12','','2023-03-12 18:54:57','734','734',2023,'734','2023-03-12 18:54:57',5),('1','167',18693,'881',12391.02,12600.00,'2023-03-13','','2023-03-13 21:04:28','734','734',2023,'734','2023-03-13 21:04:28',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2647 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','167','880',2605,'5','PUMP 31',764153.91,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:32:27','426'),('1','167','880',2606,'5','PUMP 32',503119.36,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:32:53','426'),('1','167','880',2607,'5','PUMP 33',290339.68,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:33:22','426'),('1','167','880',2608,'5','PUMP 34',504501.38,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:34:01','426'),('1','167','880',2609,'5','PUMP 35',665749.00,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:35:40','426'),('1','167','880',2610,'5','PUMP 36',116814.14,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:36:15','426'),('1','167','881',2611,'5','PUMP 25',327372.28,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:28:24','426'),('1','167','881',2612,'5','PUMP 26',485479.72,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:28:51','426'),('1','167','881',2613,'5','PUMP 27',290100.12,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:30:32','426'),('1','167','881',2614,'5','PUMP 28',329134.52,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:31:02','426'),('1','167','881',2615,'5','PUMP 29',205037.80,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:31:32','426'),('1','167','881',2616,'5','PUMP 30',299780.34,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:32:03','426'),('1','167','882',2617,'5','PUMP 21',585437.58,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:25:26','426'),('1','167','882',2618,'5','PUMP 22',459509.12,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:25:55','426'),('1','167','882',2619,'5','PUMP 23',600373.46,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:26:22','426'),('1','167','882',2620,'5','PUMP 24',405273.72,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:27:27','426'),('1','167','883',2621,'5','PUMP 17',374487.90,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:50:52','426'),('1','167','883',2622,'5','PUMP 18',467556.36,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:51:38','426'),('1','167','883',2623,'5','PUMP 19',362865.06,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:52:12','426'),('1','167','883',2624,'5','PUMP 20',321541.42,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 09:24:53','426'),('1','167','884',2625,'5','PUMP 13',468006.73,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:15:39','426'),('1','167','884',2626,'5','PUMP 14',462146.50,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:16:08','426'),('1','167','884',2627,'5','PUMP 15',337968.96,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:17:08','426'),('1','167','884',2628,'5','PUMP 16',442819.64,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:50:25','426'),('1','167','885',2629,'5','PUMP 9',355159.25,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:13:34','426'),('1','167','885',2630,'5','PUMP 10',473314.43,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:14:06','426'),('1','167','885',2631,'5','PUMP 11',580559.67,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:14:32','426'),('1','167','885',2632,'5','PUMP 12',358953.66,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:15:05','426'),('1','167','886',2633,'5','PUMP 5',210275.99,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:11:43','426'),('1','167','886',2634,'5','PUMP 6',179383.62,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:12:11','426'),('1','167','886',2635,'5','PUMP 7',192295.16,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:12:36','426'),('1','167','886',2636,'5','PUMP 8',127833.43,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:13:01','426'),('1','167','887',2637,'5','PUMP 1',259867.62,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-23 15:33:39','426'),('1','167','887',2638,'5','PUMP 2',483743.73,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:09:19','426'),('1','167','887',2639,'5','PUMP 3',328298.27,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:09:52','426'),('1','167','887',2640,'5','PUMP 4',305131.98,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 08:11:14','426'),('1','167','888',2641,'5','AGO PUMP 1',1982458.78,'DISPENSING AGO','',NULL,NULL,'',5,'2021-04-21 09:36:52','426'),('1','167','888',2642,'5','AGO PUMP 2',1058318.12,'DISPENSING AGO','',NULL,NULL,'',5,'2021-04-21 09:37:32','426'),('1','167','889',2643,'5','AGO PUMP 3',1343891.59,'DISPENSING AGO','',NULL,NULL,'',5,'2021-04-21 09:38:02','426'),('1','167','889',2644,'5','AGO PUMP 4',157799.26,'DISPENSING AGO','',NULL,NULL,'',5,'2021-06-08 10:48:50','426'),('1','167','890',2645,'5','DPK PUMP 1',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','167','890',2646,'5','DPK PUMP 2',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258381 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','167',192501,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'570',4337200.90,4304955.82,'570','2021-04-22 15:58:53','614','2021-04-22 17:10:41',10,0),('1','167',192684,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',192698,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'570',6275793.83,0.00,'570','2021-04-23 15:53:31','614','2021-04-23 16:12:55',10,0),('1','167',192881,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'570',4763748.22,4763748.22,'570','2021-04-26 12:18:58','614','2021-04-26 12:56:59',10,0),('1','167',193289,'AFTERNOON','2021-04-02','2021-04-02 00:00:00',NULL,'570',5023865.41,5023865.41,'570','2021-04-26 13:12:11','614','2021-04-26 13:53:33',10,0),('1','167',193316,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'570',4803544.04,4803544.04,'570','2021-04-26 14:12:29','614','2021-04-26 14:14:03',10,0),('1','167',193325,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'570',1165624.54,1165624.54,'570','2021-04-26 14:22:09','614','2021-04-26 14:26:36',10,0),('1','167',193342,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'570',1262931.80,1262931.80,'570','2021-04-26 15:22:54','614','2021-04-26 15:28:38',10,0),('1','167',193346,'AFTERNOON SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'570',1722773.00,1722773.00,'570','2021-04-26 15:32:32','614','2021-04-26 15:40:58',10,0),('1','167',193348,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'570',896968.80,896968.80,'570','2021-04-26 15:47:05','614','2021-04-26 16:18:17',10,0),('1','167',193356,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'570',766877.80,766877.80,'570','2021-04-26 16:36:13','614','2021-04-26 16:38:18',10,0),('1','167',193360,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'570',4170569.14,4170569.14,'570','2021-04-26 20:03:14','614','2021-04-26 20:31:32',10,0),('1','167',193385,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'570',4943411.40,4943411.40,'570','2021-04-26 20:51:10','614','2021-04-27 06:03:31',10,0),('1','167',193509,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'570',4597089.40,4597089.40,'570','2021-04-27 13:00:57','614','2021-04-27 13:54:58',10,0),('1','167',193552,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'570',4805499.57,4805499.57,'570','2021-04-27 14:21:27','614','2021-04-27 19:19:50',10,0),('1','167',193668,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'570',5529357.71,5529357.71,'570','2021-04-28 09:42:55','614','2021-04-28 09:58:26',10,0),('1','167',193695,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'570',5139928.50,5139928.50,'570','2021-04-28 10:31:15','614','2021-04-28 10:32:23',10,0),('1','167',193703,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'570',5313333.23,5313333.23,'570','2021-04-28 11:11:33','614','2021-04-28 11:15:35',10,0),('1','167',193727,'AFTERNOON SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'570',5563460.96,5563460.96,'570','2021-04-28 12:29:42','614','2021-04-28 14:52:58',10,0),('1','167',193779,'MORNING SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'570',4151484.64,4151484.64,'570','2021-04-28 16:01:42','614','2021-04-28 16:06:13',10,0),('1','167',193803,'AFTERNOON SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'570',4919620.47,4919620.47,'570','2021-04-28 16:25:31','614','2021-04-28 16:27:44',10,0),('1','167',193809,'MORNING SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'570',3667393.13,3667393.13,'570','2021-04-28 16:57:35','614','2021-04-28 16:58:38',10,0),('1','167',193811,'AFTERNOON SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'570',4787169.94,4787169.94,'570','2021-04-28 17:19:33','614','2021-04-28 17:21:48',10,0),('1','167',193814,'MORNING SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'570',4030467.75,4030467.75,'570','2021-04-28 19:48:36','614','2021-04-29 09:29:31',10,0),('1','167',193912,'AFTERNOON SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'570',4830435.01,4830435.01,'570','2021-04-29 09:46:38','614','2021-04-29 09:53:42',10,0),('1','167',193919,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',193925,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'570',3766714.32,3799353.71,'570','2021-04-29 10:32:39','614','2021-04-29 10:42:29',10,0),('1','167',193947,'AFTERNOON SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'570',4104293.00,4104293.00,'570','2021-04-29 11:20:22','614','2021-04-29 11:44:53',10,0),('1','167',193970,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'570',4057557.75,4025226.73,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',193975,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'570',4057392.75,4057392.75,'570','2021-04-29 13:01:49','614','2021-04-29 13:30:50',10,0),('1','167',193999,'AFTERNOON SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'570',3460531.85,3460531.85,'570','2021-04-29 13:51:06','614','2021-04-29 14:23:36',10,0),('1','167',194014,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'570',5023994.90,5023994.90,'570','2021-04-29 14:59:35','614','2021-04-29 22:37:49',10,0),('1','167',194130,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'570',4462756.85,4462756.85,'570','2021-04-30 09:04:34','614','2021-04-30 12:25:02',10,0),('1','167',194183,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'570',3094437.25,3094437.25,'570','2021-04-30 12:46:00','614','2021-04-30 12:50:14',10,0),('1','167',194186,'AFTERNOON SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'570',3792624.60,3792624.60,'570','2021-04-30 14:24:16','614','2021-04-30 14:35:14',10,0),('1','167',194233,'MORNING SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'570',4397756.40,4397756.40,'570','2021-04-30 16:17:10','614','2021-04-30 16:22:39',10,0),('1','167',194351,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'570',2887384.40,2887384.40,'570','2021-05-01 09:17:48','614','2021-05-01 13:52:27',10,0),('1','167',194412,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',194427,'MORNING SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'570',2463325.55,2463325.55,'570','2021-05-01 15:39:18','426','2021-05-01 15:48:04',10,0),('1','167',194437,'AFTERNOON SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'570',3229580.80,3229580.80,'570','2021-05-01 16:31:23','614','2021-05-01 23:18:08',10,0),('1','167',194539,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'570',3546816.50,3546816.50,'570','2021-05-02 10:00:53','614','2021-05-02 12:52:10',10,0),('1','167',194630,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'570',3355174.00,3355174.00,'570','2021-05-02 17:29:06','614','2021-05-02 20:27:37',10,0),('1','167',194711,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'570',3678490.55,3678490.55,'570','2021-05-03 08:28:59','614','2021-05-03 08:39:07',10,0),('1','167',194725,'AFTERNOON SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'570',3243322.55,3243322.55,'570','2021-05-03 08:51:36','614','2021-05-03 08:55:48',10,0),('1','167',194739,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'570',3836342.25,3836342.25,'570','2021-05-03 09:34:40','614','2021-05-03 09:47:47',10,0),('1','167',194757,'AFTERNOON SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'570',3088206.20,3088206.20,'570','2021-05-03 10:36:58','614','2021-05-03 10:57:34',10,0),('1','167',194770,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'570',2988949.45,2988949.45,'570','2021-05-03 11:05:22','614','2021-05-03 11:07:44',10,0),('1','167',194775,'AFTERNOON SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'570',3335178.80,3335178.80,'570','2021-05-03 11:16:41','614','2021-05-03 11:17:50',10,0),('1','167',194777,'MORNING SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'570',2798354.50,2798354.50,'570','2021-05-03 11:28:30','614','2021-05-03 11:37:33',10,0),('1','167',194782,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',194836,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'570',3221007.40,3221007.40,'570','2021-05-03 16:06:51','614','2021-05-03 16:11:44',10,0),('1','167',194842,'MORNING SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'570',3238414.75,3238414.75,'570','2021-05-03 16:39:43','614','2021-05-03 16:57:58',10,0),('1','167',194849,'AFTERNOON SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'570',3391114.10,3391114.10,'570','2021-05-03 17:26:35','614','2021-05-03 19:59:22',10,0),('1','167',194884,'MORNING SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'570',3570326.50,3570326.50,'570','2021-05-04 10:14:21','614','2021-05-04 12:28:46',10,0),('1','167',195021,'AFTERNOON SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'570',3002969.15,3002969.15,'570','2021-05-04 16:14:23','614','2021-05-04 16:21:55',10,0),('1','167',195036,'MORNING SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'570',3356563.90,3356563.90,'570','2021-05-04 16:58:03','614','2021-05-04 17:15:11',10,0),('1','167',195045,'AFTERNOON SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'570',3650064.55,3650064.55,'570','2021-05-04 17:30:08','614','2021-05-04 17:37:16',10,0),('1','167',195082,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'570',3730093.54,3757072.30,'570','2021-05-05 06:50:31','614','2021-05-05 09:46:44',10,0),('1','167',195154,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'570',3986961.52,4012033.20,'570','2021-05-05 11:23:31','614','2021-05-05 11:37:07',10,0),('1','167',195255,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',195263,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'570',3313438.02,3336354.30,'570','2021-05-05 16:14:54','614','2021-05-05 21:04:10',10,0),('1','167',195371,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'570',2916267.35,2938088.25,'570','2021-05-06 10:10:12','614','2021-05-06 12:33:49',10,0),('1','167',195598,'MORNING SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'570',3096127.74,3119820.10,'570','2021-05-07 09:59:18','614','2021-05-07 11:33:19',10,0),('1','167',195662,'AFTERNOON SHIFT 1','2021-04-29','2021-04-29 00:00:00',NULL,'570',2210239.62,2224070.70,'570','2021-05-07 14:09:47','614','2021-05-07 14:43:54',10,0),('1','167',195700,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',195708,'AFTERNOON SHIFT 2','2021-04-29','2021-04-29 00:00:00',NULL,'570',749288.18,749288.18,'570','2021-05-08 10:35:46','614','2021-05-08 12:00:03',10,0),('1','167',195926,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'570',3234212.40,3234212.40,'570','2021-05-08 15:29:29','614','2021-05-08 15:40:13',10,0),('1','167',195933,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'570',3187312.67,3187312.67,'570','2021-05-08 15:53:54','426','2021-05-08 16:26:32',10,0),('1','167',195946,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'570',2564243.85,2564243.85,'570','2021-05-08 16:36:31','614','2021-05-08 17:07:35',10,0),('1','167',195963,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'570',3177998.26,3177998.26,'570','2021-05-08 17:50:15','614','2021-05-08 20:35:08',10,0),('1','167',196085,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'570',3051759.99,3051759.99,'570','2021-05-09 11:07:00','614','2021-05-09 11:21:20',10,0),('1','167',196094,'AFTERNOON SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'570',2602682.53,2602682.53,'570','2021-05-09 11:35:10','614','2021-05-09 11:39:34',10,0),('1','167',196097,'MORNING SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'570',2391295.12,2391295.12,'570','2021-05-09 11:48:07','614','2021-05-09 11:50:19',10,0),('1','167',196098,'AFTERNOON SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'570',1458995.77,1458995.77,'570','2021-05-09 11:56:43','614','2021-05-09 12:02:13',10,0),('1','167',196101,'MORNING SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'570',1286617.80,1286617.80,'570','2021-05-09 12:07:26','614','2021-05-09 12:08:48',10,0),('1','167',196109,'AFTERNOON SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'570',2078912.69,2078912.69,'570','2021-05-09 12:25:59','614','2021-05-09 12:29:13',10,0),('1','167',196120,'MORNING SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'570',2649283.43,2649283.43,'570','2021-05-09 13:12:01','426','2021-05-09 13:13:46',10,0),('1','167',196126,'AFTERNOON SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'570',2436909.17,2436909.17,'570','2021-05-09 13:32:44','614','2021-05-09 13:37:58',10,0),('1','167',196139,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'570',3013870.67,3013870.67,'570','2021-05-09 14:21:08','614','2021-05-09 14:25:36',10,0),('1','167',196144,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'570',2871140.65,2871140.65,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',196150,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'570',2871140.65,2871140.65,'570','2021-05-09 15:35:20','426','2021-05-09 15:49:32',10,0),('1','167',196163,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'570',3371147.56,3371147.56,'570','2021-05-09 15:58:40','426','2021-05-09 16:00:59',10,0),('1','167',196169,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'570',3332801.96,3332801.96,'570','2021-05-09 16:23:49','614','2021-05-09 16:36:15',10,0),('1','167',196173,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'570',3175759.79,3175759.79,'570','2021-05-09 16:54:13','614','2021-05-09 16:58:24',10,0),('1','167',196175,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'570',3142781.03,3142781.03,'570','2021-05-09 17:16:14','426','2021-05-09 17:20:36',10,0),('1','167',196178,'MORNING SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'570',3448093.13,3448093.13,'570','2021-05-09 17:40:04','614','2021-05-09 17:43:07',10,0),('1','167',196182,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'570',3463098.97,3463098.97,'570','2021-05-09 21:47:15','614','2021-05-10 03:38:55',10,0),('1','167',196299,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'570',3135732.05,3135732.05,'570','2021-05-10 16:23:35','614','2021-05-11 03:51:36',10,0),('1','167',196495,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'570',3234264.64,3234264.64,'570','2021-05-11 08:55:08','614','2021-05-11 10:55:16',10,0),('1','167',196608,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'570',3326525.60,3326525.60,'570','2021-05-11 17:05:55','614','2021-05-11 21:24:53',10,0),('1','167',196724,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'570',2894296.65,2894296.65,'570','2021-05-12 09:38:23','614','2021-05-12 09:44:37',10,0),('1','167',196822,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'570',4092764.95,4092764.95,'570','2021-05-12 16:56:52','614','2021-05-12 22:56:53',10,0),('1','167',196875,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'570',2475711.08,2475711.08,'570','2021-05-13 19:39:41','614','2021-05-14 07:39:52',10,0),('1','167',197095,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'570',1195576.96,1195576.96,'570','2021-05-14 09:26:28','614','2021-05-14 12:28:12',10,0),('1','167',197185,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'570',1345156.53,1345156.53,'570','2021-05-14 18:37:40','614','2021-05-14 19:25:06',10,0),('1','167',197469,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'570',2000419.31,2000419.31,'570','2021-05-16 19:06:29','614','2021-05-16 21:52:52',10,0),('1','167',197581,'AFTERNOON SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'570',2811998.85,2811998.85,'570','2021-05-17 10:02:59','426','2021-05-17 10:04:51',10,0),('1','167',197599,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'570',2481417.25,2481417.25,'570','2021-05-17 10:30:12','614','2021-05-17 10:37:16',10,0),('1','167',197628,'AFTERNOON SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'570',2765600.49,2765600.49,'570','2021-05-17 10:55:13','426','2021-05-17 11:03:14',10,0),('1','167',197639,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'570',2840629.85,2840629.85,'570','2021-05-17 11:17:51','426','2021-05-17 11:27:30',10,0),('1','167',197673,'AFTERNOON SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'570',2706322.74,2706322.74,'570','2021-05-17 12:10:22','614','2021-05-17 13:05:42',10,0),('1','167',197744,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'570',3040788.61,3040788.61,'570','2021-05-17 15:20:02','614','2021-05-17 15:46:08',10,0),('1','167',197911,'AFTERNOON SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'570',2864158.17,2864158.17,'570','2021-05-18 08:55:20','614','2021-05-18 09:24:09',10,0),('1','167',198023,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'570',2778616.89,2778616.89,'570','2021-05-18 13:53:53','614','2021-05-18 14:19:14',10,0),('1','167',198170,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'570',2836832.36,2836832.36,'570','2021-05-19 09:26:03','614','2021-05-19 10:15:20',10,0),('1','167',198324,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'570',3315607.65,3315607.65,'570','2021-05-19 21:19:52','426','2021-05-20 11:14:32',10,0),('1','167',198440,'AFTERNOON SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'570',3031202.98,3031202.98,'570','2021-05-20 11:34:05','614','2021-05-20 12:26:01',10,0),('1','167',198479,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'570',3120690.58,3120690.58,'570','2021-05-20 14:06:38','614','2021-05-20 22:11:51',10,0),('1','167',198628,'AFTERNOON SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'570',3453711.01,3453711.01,'570','2021-05-21 09:09:02','614','2021-05-21 10:36:35',10,0),('1','167',198686,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'570',3516251.83,3516251.83,'570','2021-05-21 14:58:20','614','2021-05-21 15:40:59',10,0),('1','167',198870,'AFTERNOON SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'570',2924143.83,2924143.83,'570','2021-05-22 11:32:19','614','2021-05-22 16:17:53',10,0),('1','167',199082,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'570',2845664.50,2845664.50,'570','2021-05-23 11:35:36','614','2021-05-23 13:14:54',10,0),('1','167',199132,'AFTERNOON SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'570',3335065.95,3335065.95,'570','2021-05-23 14:32:04','614','2021-05-23 15:00:43',10,0),('1','167',199155,'MORNING SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'570',2530762.97,2530762.97,'570','2021-05-23 19:36:48','426','2021-05-24 09:13:02',10,0),('1','167',199299,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'570',2839388.34,2839388.34,'570','2021-05-24 09:43:57','614','2021-05-24 10:35:27',10,0),('1','167',199370,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'570',2912181.09,2912181.09,'570','2021-05-24 14:41:41','614','2021-05-25 06:31:33',10,0),('1','167',199518,'AFTERNOON SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'570',3027164.38,3027164.38,'570','2021-05-25 10:00:26','614','2021-05-25 12:11:47',10,0),('1','167',199598,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'570',3153380.16,3153380.16,'570','2021-05-26 18:53:58','614','2021-05-26 23:59:18',10,0),('1','167',199936,'AFTERNOON SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'570',2198126.72,2198126.72,'570','2021-05-27 09:19:13','178','2021-05-27 09:30:30',10,0),('1','167',199942,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'570',2924025.19,2924025.19,'570','2021-05-27 10:32:40','614','2021-05-27 10:53:02',10,0),('1','167',199977,'AFTERNOON SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'570',3591999.69,3591999.69,'570','2021-05-27 11:33:21','614','2021-05-27 14:01:08',10,0),('1','167',200020,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'570',3317782.49,3317782.49,'570','2021-05-27 14:14:44','614','2021-05-27 14:40:34',10,0),('1','167',200054,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',200058,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'570',3333728.72,3333728.72,'570','2021-05-28 10:46:35','614','2021-05-28 13:08:45',10,0),('1','167',200216,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'570',2895600.97,2895600.97,'570','2021-05-28 14:04:45','614','2021-05-28 16:21:39',10,0),('1','167',200362,'AFTERNOON SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'570',3154901.23,3154901.23,'570','2021-05-29 11:08:49','614','2021-05-29 11:32:42',10,0),('1','167',200401,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'570',3300319.91,3300319.91,'570','2021-05-29 14:05:45','614','2021-05-29 14:37:55',10,0),('1','167',200581,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'570',2645098.60,2645098.60,'570','2021-05-30 16:35:33','614','2021-05-30 16:46:36',10,0),('1','167',200658,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'570',3417652.49,3417652.49,'570','2021-05-30 17:06:07','614','2021-05-31 05:20:19',10,0),('1','167',200857,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'570',3804464.88,3804464.88,'570','2021-05-31 15:54:39','614','2021-05-31 16:10:46',10,0),('1','167',200867,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'570',3192469.55,3192469.55,'570','2021-05-31 16:33:34','614','2021-05-31 17:05:42',10,0),('1','167',201048,'AFTERNOON SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'570',3237877.07,3237877.07,'570','2021-06-01 15:12:07','614','2021-06-01 15:23:20',10,0),('1','167',201059,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'570',2835864.80,2835864.80,'570','2021-06-01 15:58:47','614','2021-06-02 11:24:05',10,0),('1','167',201268,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'570',3944766.45,3944766.45,'570','2021-06-02 16:57:50','614','2021-06-03 07:13:45',10,0),('1','167',201456,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'570',3936205.30,3936205.30,'570','2021-06-03 16:50:34','426','2021-06-03 17:38:50',10,0),('1','167',201470,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'570',2957469.39,2957469.39,'570','2021-06-03 17:52:42','426','2021-06-03 18:38:01',10,0),('1','167',201474,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'570',3129559.54,3129559.54,'570','2021-06-03 18:48:58','614','2021-06-03 18:51:15',10,0),('1','167',201476,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'570',2659714.81,2659714.81,'570','2021-06-04 16:47:05','614','2021-06-05 08:31:53',10,0),('1','167',201935,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'570',2081136.83,2074307.43,'570','2021-06-05 15:55:28','614','2021-06-05 16:35:15',10,0),('1','167',201960,'AFTERNOON SHIFT2','2021-06-04','2021-06-04 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',201966,'MORNING SHIFT1','2021-06-05','2021-06-05 00:00:00',NULL,'570',253528.15,258311.70,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',201970,'MORNING SHIFT1','2021-06-04','2021-06-04 00:00:00',NULL,'570',253525.50,258309.00,'570','2021-06-05 17:22:53','614','2021-06-05 17:25:05',10,0),('1','167',201973,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'570',3100255.40,3119704.75,'570','2021-06-05 17:38:58','614','2021-06-05 17:40:21',10,0),('1','167',201976,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'570',2601284.54,2620051.44,'570','2021-06-05 18:51:15','614','2021-06-05 19:05:54',10,0),('1','167',201990,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',202572,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'570',3962214.46,3994915.01,'570','2021-06-08 15:28:00','614','2021-06-08 15:53:53',10,0),('1','167',202592,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'570',3123654.67,3150577.92,'570','2021-06-08 16:09:00','614','2021-06-08 16:38:31',10,0),('1','167',202599,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'570',3358326.81,3387842.61,'570','2021-06-08 16:53:04','614','2021-06-08 17:43:15',10,0),('1','167',202611,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'570',2575912.60,2590369.30,'570','2021-06-08 18:11:54','614','2021-06-08 18:40:20',10,0),('1','167',202738,'AFTERNOON SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'570',3272816.86,3293443.16,'570','2021-06-09 11:21:39','426','2021-06-09 11:25:14',10,0),('1','167',202747,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'570',2588402.65,2613819.95,'570','2021-06-09 17:51:40','426','2021-06-09 17:55:28',10,0),('1','167',202817,'AFTERNOON SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'570',3473582.06,3473582.06,'570','2021-06-09 19:43:54','614','2021-06-09 20:35:08',10,0),('1','167',202951,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'570',3223670.38,3223670.38,'570','2021-06-10 11:07:56','426','2021-06-10 11:43:37',10,0),('1','167',202963,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'570',4195553.48,4195553.48,'570','2021-06-10 17:09:32','614','2021-06-11 10:23:35',10,0),('1','167',203189,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'570',4394176.00,4394176.00,'570','2021-06-11 10:55:39','614','2021-06-11 12:49:58',10,0),('1','167',203227,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'570',4179883.51,4179883.51,'570','2021-06-11 14:26:48','614','2021-06-11 14:31:26',10,0),('1','167',203239,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'570',3412569.78,3412569.78,'570','2021-06-11 14:46:30','614','2021-06-11 14:47:52',10,0),('1','167',203388,'AFTERNOON SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'570',3332321.70,3332321.70,'570','2021-06-12 11:30:27','426','2021-06-12 13:09:34',10,0),('1','167',203431,'MORNING SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'570',1151238.07,1151238.07,'570','2021-06-12 13:40:52','614','2021-06-12 18:18:13',10,0),('1','167',203611,'AFTERNOON SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'570',2544509.82,2544509.82,'570','2021-06-13 11:54:06','614','2021-06-13 12:47:42',10,0),('1','167',203665,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'570',2298764.42,2298764.42,'570','2021-06-13 15:51:22','614','2021-06-13 16:35:05',10,0),('1','167',203787,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'570',3259359.59,3259359.59,'570','2021-06-14 09:28:09','614','2021-06-14 11:11:43',10,0),('1','167',203869,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'570',2879553.96,2879553.96,'570','2021-06-14 14:03:17','614','2021-06-14 14:25:29',10,0),('1','167',204017,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'570',3187027.43,3187027.43,'570','2021-06-15 09:02:12','614','2021-06-15 11:22:06',10,0),('1','167',204093,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'570',3268624.13,3268624.13,'570','2021-06-15 13:48:07','614','2021-06-15 14:30:28',10,0),('1','167',204255,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'570',4265319.54,4265319.54,'570','2021-06-16 10:23:51','614','2021-06-16 11:10:53',10,0),('1','167',204313,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'570',3777966.06,3777966.06,'570','2021-06-16 14:02:09','614','2021-06-16 20:56:53',10,0),('1','167',204487,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'570',3241163.03,3241163.03,'570','2021-06-17 11:00:22','426','2021-06-17 13:35:30',10,0),('1','167',204533,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'570',3609650.51,3609650.51,'570','2021-06-17 14:03:20','614','2021-06-17 14:05:38',10,0),('1','167',204693,'AFTERNOON SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'570',4393135.49,4393135.49,'570','2021-06-18 10:32:44','614','2021-06-18 10:38:30',10,0),('1','167',204747,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'570',3113263.62,3113263.62,'570','2021-06-18 14:34:16','614','2021-06-18 16:13:56',10,0),('1','167',204934,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'570',3110459.23,3110459.23,'570','2021-06-19 11:46:34','614','2021-06-19 12:26:52',10,0),('1','167',204963,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'570',1445801.85,1445801.85,'570','2021-06-19 13:26:02','614','2021-06-19 13:37:55',10,0),('1','167',205123,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'570',1773805.12,1773805.12,'570','2021-06-20 11:52:01','614','2021-06-20 12:28:26',10,0),('1','167',205145,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'570',1888409.21,1888409.21,'570','2021-06-20 13:32:08','614','2021-06-20 14:34:01',10,0),('1','167',205325,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'570',3697338.65,3697338.65,'570','2021-06-21 11:34:39','426','2021-06-21 14:22:44',10,0),('1','167',205407,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'570',2777927.17,2777927.17,'570','2021-06-21 16:19:47','614','2021-06-21 16:37:18',10,0),('1','167',205421,'AFTERNOON SHIFT 1','2021-06-21','2021-06-21 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',205423,'AFTERNOON SHIFT 1','2021-06-21','2021-06-21 00:00:00',NULL,'570',667447.20,643609.80,'570','2021-06-21 16:43:58','614','2021-06-21 16:49:46',10,0),('1','167',205536,'AFTERNOON SHIFT 2','2021-06-21','2021-06-21 00:00:00',NULL,'570',2748604.91,2748604.91,'570','2021-06-22 09:45:25','614','2021-06-22 10:07:06',10,0),('1','167',205618,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'570',3050649.65,3050649.65,'570','2021-06-22 13:59:41','614','2021-06-22 14:42:44',10,0),('1','167',205708,'AFTERNOON','2021-06-22','2021-06-22 00:00:00',NULL,'570',2578899.19,2578899.19,'570','2021-06-22 22:38:45','614','2021-06-23 08:08:10',10,0),('1','167',205858,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'570',2881504.09,2881504.09,'570','2021-06-23 14:05:48','614','2021-06-23 14:44:38',10,0),('1','167',205919,'AFTERNOON SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'570',3048087.75,3048087.75,'570','2021-06-23 22:00:53','426','2021-06-24 09:42:45',10,0),('1','167',206009,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'570',2946029.77,2946029.77,'570','2021-06-24 14:06:20','614','2021-06-24 14:36:35',10,0),('1','167',206125,'AFTERNOON SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'570',3550148.48,3550148.48,'570','2021-06-24 23:08:01','614','2021-06-24 23:42:14',10,0),('1','167',206161,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'570',1882832.28,1882832.28,'570','2021-06-25 14:20:46','614','2021-06-25 20:33:30',10,0),('1','167',206336,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'570',1711077.83,1711077.83,'570','2021-06-25 20:55:36','614','2021-06-26 00:26:24',10,0),('1','167',206366,'MORNING SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'570',1144789.75,1144789.75,'570','2021-06-26 13:53:53','614','2021-06-26 14:36:55',10,0),('1','167',206544,'AFTERNOON SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'570',1694145.39,1694145.39,'570','2021-06-26 21:10:53','614','2021-06-26 23:25:31',10,0),('1','167',206594,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'570',1342754.88,1342754.88,'570','2021-06-27 18:53:39','614','2021-06-27 19:41:27',10,0),('1','167',206770,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'570',1582791.94,1582791.94,'570','2021-06-27 21:05:07','614','2021-06-27 23:13:49',10,0),('1','167',206825,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'570',1550477.19,1550477.19,'570','2021-06-28 13:32:58','614','2021-06-28 13:59:57',10,0),('1','167',206960,'AFTERNOON SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'570',3086375.30,3086375.30,'570','2021-06-28 20:56:48','614','2021-06-28 22:57:46',10,0),('1','167',207039,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'570',2638049.70,2638049.70,'570','2021-06-29 14:03:02','614','2021-06-29 14:04:18',10,0),('1','167',207173,'AFTERNOON SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'570',472096.80,472096.80,'570','2021-06-29 19:30:56','614','2021-06-29 19:34:35',10,0),('1','167',207220,'AFTERNOON SHIFT 2','2021-06-29','2021-06-29 00:00:00',NULL,'570',3352472.22,3352472.22,'570','2021-06-29 21:37:18','614','2021-06-29 21:45:48',10,0),('1','167',207297,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'570',2708545.21,2708545.21,'570','2021-06-30 13:53:16','614','2021-06-30 14:00:16',10,0),('1','167',207458,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'570',2242747.20,2242747.20,'570','2021-06-30 20:39:50','614','2021-06-30 22:46:03',10,0),('1','167',207504,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'570',2312726.56,2312726.56,'570','2021-07-01 13:42:11','614','2021-07-01 14:18:57',10,0),('1','167',207682,'AFTERNOON SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'570',3431868.68,3431868.68,'570','2021-07-01 20:58:15','614','2021-07-01 22:43:26',10,0),('1','167',207743,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'570',2022089.90,2022089.90,'570','2021-07-02 14:23:40','614','2021-07-02 19:58:58',10,0),('1','167',207886,'AFTERNOON SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'570',2436218.50,2436218.50,'570','2021-07-02 21:38:41','614','2021-07-03 06:34:15',10,0),('1','167',207936,'MORNING SHIFT ','2021-07-03','2021-07-03 00:00:00',NULL,'570',769066.80,769066.80,'570','2021-07-03 14:23:25','614','2021-07-03 21:43:02',10,0),('1','167',208099,'AFTERNOON SHIFT ','2021-07-03','2021-07-03 00:00:00',NULL,'570',590172.30,590172.30,'570','2021-07-04 04:57:59','614','2021-07-04 07:19:55',10,0),('1','167',208184,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'570',1034168.10,1034168.10,'570','2021-07-04 13:49:07','614','2021-07-04 18:35:12',10,0),('1','167',208295,'AFTERNOON SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'570',441678.75,441678.75,'570','2021-07-04 19:31:09','614','2021-07-04 21:11:15',10,0),('1','167',208356,'MORNING SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'570',564623.85,564623.85,'570','2021-07-05 14:16:51','614','2021-07-05 16:56:50',10,0),('1','167',208532,'AFTERNOON SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'570',2459079.51,2459079.51,'570','2021-07-06 09:45:42','614','2021-07-06 10:36:36',10,0),('1','167',208666,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'570',1390505.73,1390505.73,'570','2021-07-06 13:28:37','614','2021-07-06 21:01:11',10,0),('1','167',208740,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'570',1605598.90,1605598.90,'570','2021-07-06 21:09:59','614','2021-07-07 05:24:53',10,0),('1','167',208868,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'570',1093777.27,1093777.27,'570','2021-07-07 13:45:12','614','2021-07-07 14:25:43',10,0),('1','167',208968,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'570',1817216.91,1817216.91,'570','2021-07-08 10:52:58','614','2021-07-08 11:20:07',10,0),('1','167',209103,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'570',1095731.64,1095731.64,'570','2021-07-08 13:58:54','614','2021-07-08 14:49:14',10,0),('1','167',209301,'AFTERNOON SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'570',2004194.21,2004194.21,'570','2021-07-09 10:51:41','614','2021-07-09 11:00:21',10,0),('1','167',209320,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'570',1318780.84,1318780.84,'570','2021-07-09 16:23:57','426','2021-07-10 13:42:21',10,0),('1','167',209564,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'570',2135564.06,2135564.06,'570','2021-07-10 14:24:21','614','2021-07-10 14:25:22',10,0),('1','167',209572,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'570',1566596.26,1566596.26,'570','2021-07-10 14:52:34','614','2021-07-10 15:00:04',10,0),('1','167',209625,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'570',2314165.73,2314165.73,'570','2021-07-10 21:56:00','614','2021-07-11 10:56:59',10,0),('1','167',209721,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'570',2656776.26,2656776.26,'570','2021-07-11 18:24:53','614','2021-07-12 05:05:32',10,0),('1','167',209915,'AFTERNOON SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'570',3005442.19,3005442.19,'570','2021-07-12 08:55:46','426','2021-07-12 09:09:37',10,0),('1','167',209929,'MORNING SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'570',3325636.63,3325636.63,'570','2021-07-12 13:38:47','614','2021-07-12 14:17:24',10,0),('1','167',210079,'AFTERNOON SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'570',3244716.62,3244716.62,'570','2021-07-12 21:17:58','614','2021-07-13 08:49:29',10,0),('1','167',210185,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'570',3101240.44,3101240.44,'570','2021-07-13 13:53:56','614','2021-07-13 14:47:21',10,0),('1','167',210289,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'570',4053060.02,4053060.02,'570','2021-07-13 21:59:21','614','2021-07-14 05:58:59',10,0),('1','167',210370,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'570',3057973.89,3057973.89,'570','2021-07-14 14:05:42','614','2021-07-14 14:22:42',10,0),('1','167',210495,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'570',2052074.15,2052074.15,'570','2021-07-14 21:13:34','614','2021-07-15 09:44:28',10,0),('1','167',210604,'MORNING SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'570',1872224.10,1872224.10,'570','2021-07-15 13:30:15','614','2021-07-15 15:50:57',10,0),('1','167',210707,'AFTERNOON SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'570',2090186.52,2090186.52,'570','2021-07-15 20:49:16','614','2021-07-15 22:57:34',10,0),('1','167',210764,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'570',2672569.12,2672569.12,'570','2021-07-16 18:08:08','614','2021-07-16 22:14:36',10,0),('1','167',210975,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'570',1530763.97,1530763.97,'570','2021-07-17 07:56:39','426','2021-07-17 13:34:34',10,0),('1','167',211150,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'570',1843631.06,1843631.06,'570','2021-07-17 20:22:04','614','2021-07-18 05:08:02',10,0),('1','167',211227,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'570',2521541.54,2521541.54,'570','2021-07-18 09:54:01','614','2021-07-18 10:20:44',10,0),('1','167',211246,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'570',2083019.38,2083019.38,'570','2021-07-18 13:36:22','614','2021-07-18 20:51:48',10,0),('1','167',211425,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'570',3132546.12,3132546.12,'570','2021-07-19 09:06:34','614','2021-07-19 13:16:59',10,0),('1','167',211519,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'570',3483142.49,3483142.49,'570','2021-07-19 15:58:07','614','2021-07-20 10:26:02',10,0),('1','167',211637,'AFTERNOON SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'570',3691704.07,3691704.07,'570','2021-07-20 10:58:10','614','2021-07-20 12:23:37',10,0),('1','167',211676,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'570',1914857.40,1914857.40,'570','2021-07-20 13:57:00','614','2021-07-20 14:01:23',10,0),('1','167',211741,'AFTERNOON SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'570',1129276.38,1129276.38,'570','2021-07-20 19:31:59','614','2021-07-21 12:21:57',10,0),('1','167',211889,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'570',932984.29,932984.29,'570','2021-07-21 13:33:14','614','2021-07-21 22:15:14',10,0),('1','167',212051,'AFTERNOON SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'570',1476992.71,1476992.71,'570','2021-07-22 10:32:18','614','2021-07-22 16:27:18',10,0),('1','167',212182,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'570',1587704.29,1587704.29,'570','2021-07-22 17:14:08','614','2021-07-23 07:22:09',10,0),('1','167',212253,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'570',1842406.66,1842406.66,'570','2021-07-23 07:41:05','614','2021-07-23 11:35:12',10,0),('1','167',212339,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'570',2461713.42,2461713.42,'570','2021-07-23 13:41:52','614','2021-07-24 09:36:58',10,0),('1','167',212536,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'570',3084240.80,3084240.80,'570','2021-07-24 11:06:49','614','2021-07-24 12:58:28',10,0),('1','167',212589,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'570',2631140.04,2631140.04,'570','2021-07-24 14:15:14','614','2021-07-24 15:30:45',10,0),('1','167',212735,'AFTERNOON SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'570',2732850.05,2732850.05,'570','2021-07-25 11:10:32','614','2021-07-25 20:59:15',10,0),('1','167',212936,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'570',3538897.06,3538897.06,'570','2021-07-26 09:20:06','426','2021-07-26 09:38:38',10,0),('1','167',212946,'AFTERNOON SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'570',2454779.13,2454779.13,'570','2021-07-26 09:47:46','614','2021-07-26 10:17:16',10,0),('1','167',212970,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'570',2765720.21,2765720.21,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',213060,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'570',2765720.21,2765720.21,'570','2021-07-26 16:05:54','614','2021-07-26 21:30:27',10,0),('1','167',213204,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'570',2575631.36,2575631.36,'570','2021-07-27 09:41:10','614','2021-07-27 09:43:45',10,0),('1','167',213219,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'570',2548185.53,2548185.53,'570','2021-07-27 13:40:46','614','2021-07-27 15:30:53',10,0),('1','167',213473,'AFTERNOON SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'570',2709446.98,2709446.98,'570','2021-07-28 10:28:01','614','2021-07-28 14:47:49',10,0),('1','167',213579,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'570',2606120.98,2606120.98,'570','2021-07-28 16:30:46','614','2021-07-28 17:04:19',10,0),('1','167',213656,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'570',2863458.82,2863458.82,'570','2021-07-29 07:54:27','614','2021-07-29 09:04:31',10,0),('1','167',213694,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'570',2529568.50,2529568.50,'570','2021-07-29 19:58:04','614','2021-07-30 06:21:18',10,0),('1','167',213967,'AFTERNOON SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'570',2944570.53,2944570.53,'570','2021-07-30 10:44:52','614','2021-07-30 20:10:04',10,0),('1','167',214285,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'570',2646622.55,2646622.55,'570','2021-07-31 18:07:47','614','2021-07-31 18:37:01',10,0),('1','167',214291,'AFTERNOON SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'570',2613613.34,2613613.34,'570','2021-07-31 19:10:07','614','2021-07-31 22:10:50',10,0),('1','167',214455,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'570',2936184.76,2936184.76,'570','2021-08-01 14:18:08','614','2021-08-01 15:02:39',10,0),('1','167',214474,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'570',3454312.81,3454312.81,'570','2021-08-01 15:20:29','614','2021-08-01 15:35:09',10,0),('1','167',214486,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'570',2138268.47,2138268.47,'570','2021-08-01 16:54:29','614','2021-08-01 20:50:41',10,0),('1','167',214621,'AFTERNOON SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'570',1885438.49,1885438.49,'570','2021-08-02 10:27:51','614','2021-08-02 10:58:44',10,0),('1','167',214642,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'570',1944694.67,1944694.67,'570','2021-08-02 15:15:38','614','2021-08-02 15:41:13',10,0),('1','167',214843,'AFTERNOON SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'570',2775527.53,2775527.53,'570','2021-08-03 09:56:25','614','2021-08-03 13:49:33',10,0),('1','167',214922,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'570',2635207.04,2635207.04,'570','2021-08-03 13:59:22','614','2021-08-03 21:47:15',10,0),('1','167',215099,'AFTERNOON SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'570',3107232.41,3107232.41,'570','2021-08-04 12:32:58','614','2021-08-04 13:46:11',10,0),('1','167',215135,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'570',2068475.43,2068475.43,'570','2021-08-04 13:57:40','614','2021-08-04 14:02:58',10,0),('1','167',215138,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'570',3257513.67,3257513.67,'570','2021-08-05 10:56:29','614','2021-08-07 07:54:03',10,0),('1','167',215785,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'570',2940946.86,2940946.86,'570','2021-08-07 13:42:08','614','2021-08-07 15:54:25',10,0),('1','167',215845,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'570',3157898.94,3157898.94,'570','2021-08-07 17:00:49','614','2021-08-08 14:53:49',10,0),('1','167',216028,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'570',2481897.96,2481897.96,'570','2021-08-08 15:18:19','614','2021-08-08 15:26:08',10,0),('1','167',216033,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'570',2358415.89,2358415.89,'570','2021-08-08 16:02:43','614','2021-08-08 17:22:38',10,0),('1','167',216062,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'570',2075331.09,2075331.09,'570','2021-08-08 18:22:01','614','2021-08-08 18:25:50',10,0),('1','167',216064,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'570',3525761.32,3525761.32,'570','2021-08-08 18:36:21','614','2021-08-08 18:53:26',10,0),('1','167',216132,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'570',2075777.06,2075777.06,'570','2021-08-09 10:00:21','614','2021-08-09 12:52:21',10,0),('1','167',216275,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'570',2168920.42,2168920.42,'570','2021-08-09 16:36:42','614','2021-08-09 17:15:36',10,0),('1','167',216292,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'570',2627584.61,2627584.61,'570','2021-08-09 18:36:47','614','2021-08-09 23:11:28',10,0),('1','167',216409,'AFTERNOON SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'570',2208945.14,2208945.14,'570','2021-08-10 10:19:33','426','2021-08-10 14:17:40',10,0),('1','167',216477,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'570',1967327.01,1967327.01,'570','2021-08-10 14:23:35','426','2021-08-10 14:42:56',10,0),('1','167',216611,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'570',2833946.13,2833946.13,'570','2021-08-11 09:22:32','614','2021-08-11 12:33:12',10,0),('1','167',216847,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'570',1453806.78,1453806.78,'570','2021-08-12 09:24:26','614','2021-08-12 09:52:04',10,0),('1','167',216889,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'570',2237418.37,2237418.37,'570','2021-08-12 13:36:12','426','2021-08-12 14:13:54',10,0),('1','167',216933,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'570',2064847.50,2064847.50,'570','2021-08-12 15:02:55','614','2021-08-12 15:03:58',10,0),('1','167',216946,'AFTERNOON SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'570',2450034.78,2450034.78,'570','2021-08-13 10:04:59','614','2021-08-13 10:52:07',10,0),('1','167',217163,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'570',1685367.04,1685367.04,'570','2021-08-13 14:27:52','614','2021-08-13 16:10:26',10,0),('1','167',217423,'AFTERNOON SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'570',3161766.15,3161766.15,'570','2021-08-14 17:05:48','614','2021-08-14 18:31:38',10,0),('1','167',217474,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'570',2752977.13,2752977.13,'570','2021-08-16 08:44:14','614','2021-08-16 09:33:34',10,0),('1','167',217795,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'570',2856972.14,2856972.14,'570','2021-08-16 09:46:30','614','2021-08-16 09:58:30',10,0),('1','167',217823,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'570',2227071.34,2227071.34,'570','2021-08-16 10:57:50','614','2021-08-16 11:24:31',10,0),('1','167',217841,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',217842,'AFTERNOON SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'570',2248807.01,2248807.01,'570','2021-08-16 11:43:19','614','2021-08-17 17:40:06',10,0),('1','167',218304,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'570',2526985.10,2526985.10,'570','2021-08-18 10:23:16','614','2021-08-18 13:52:22',10,0),('1','167',218531,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'570',2706093.18,2717532.67,'570','2021-08-19 10:10:58','614','2021-08-19 10:41:25',10,0),('1','167',218545,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'570',1878012.80,1885597.60,'570','2021-08-19 10:45:05','614','2021-08-19 10:49:59',10,0),('1','167',218553,'AFTERNOON SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'570',1466187.48,1475238.02,'570','2021-08-19 11:38:52','614','2021-08-19 13:05:28',10,0),('1','167',218573,'AFTERNOON SHIFT 2','2021-08-17','2021-08-17 00:00:00',NULL,'570',1141890.08,1141890.08,'570','2021-08-19 13:31:23','614','2021-08-19 14:07:37',10,0),('1','167',218593,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'570',2140070.92,2140070.92,'570','2021-08-19 14:52:50','614','2021-08-19 14:56:57',10,0),('1','167',218596,'AFTERNOON SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'570',2932165.40,2932165.40,'570','2021-08-19 15:03:56','614','2021-08-19 15:22:50',10,0),('1','167',218605,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'570',2029560.56,2029560.56,'570','2021-08-19 15:29:52','614','2021-08-19 23:12:47',10,0),('1','167',218750,'AFTERNOON SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'570',2955974.92,2955974.92,'570','2021-08-20 09:54:00','614','2021-08-20 13:37:25',10,0),('1','167',218814,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'570',1899611.62,1899611.62,'570','2021-08-21 13:14:41','614','2021-08-21 13:53:56',10,0),('1','167',219044,'AFTERNOON SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'570',3252109.44,3252109.44,'570','2021-08-21 14:11:05','614','2021-08-21 14:13:11',10,0),('1','167',219048,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'570',3043010.12,3043010.12,'570','2021-08-21 14:21:38','614','2021-08-22 13:09:10',10,0),('1','167',219232,'AFTERNOON SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'570',2978783.60,2978783.60,'570','2021-08-22 13:18:38','614','2021-08-22 13:46:10',10,0),('1','167',219241,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'570',2683042.44,2683042.44,'570','2021-08-22 15:34:32','614','2021-08-22 17:25:33',10,0),('1','167',219441,'AFTERNOON SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'570',2358200.54,2358200.54,'570','2021-08-23 10:41:18','614','2021-08-23 12:32:47',10,0),('1','167',219541,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'570',2634667.66,2634667.66,'570','2021-08-23 17:28:31','614','2021-08-24 14:29:40',10,0),('1','167',219753,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'570',2208117.12,2208117.12,'570','2021-08-24 15:50:40','614','2021-08-24 15:58:55',10,0),('1','167',219758,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'570',2156116.00,2156116.00,'570','2021-08-24 16:14:06','614','2021-08-24 16:15:16',10,0),('1','167',219762,'AFTERNOON SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'570',2300788.12,2300788.12,'570','2021-08-25 18:17:59','614','2021-08-25 19:37:15',10,0),('1','167',220009,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'570',2605474.64,2605474.64,'570','2021-08-25 19:52:01','614','2021-08-25 19:52:44',10,0),('1','167',220010,'AFTERNOON SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'570',3265171.74,3265171.74,'570','2021-08-26 15:57:59','614','2021-08-26 16:18:50',10,0),('1','167',220190,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'570',2954954.98,2954954.98,'570','2021-08-26 16:28:03','614','2021-08-26 22:07:33',10,0),('1','167',220351,'AFTERNOON SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'570',4128777.18,4128777.18,'570','2021-08-27 11:59:22','614','2021-08-27 17:03:15',10,0),('1','167',220424,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'570',1995932.14,1995932.14,'570','2021-08-27 17:23:40','614','2021-08-27 17:54:44',10,0),('1','167',220439,'AFTERNOON SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'570',3163945.60,3163945.60,'570','2021-08-28 14:02:28','614','2021-08-28 15:12:35',10,0),('1','167',220649,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'570',1790293.26,1790293.26,'570','2021-08-28 18:05:05','614','2021-08-28 20:38:00',10,0),('1','167',220825,'AFTERNOON SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'570',2555642.26,2555642.26,'570','2021-08-29 14:58:50','614','2021-08-29 15:11:05',10,0),('1','167',220866,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'570',2148411.22,2148411.22,'570','2021-08-29 18:04:24','614','2021-08-29 23:36:11',10,0),('1','167',221027,'AFTERNOON SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'570',2526962.70,2526962.70,'570','2021-08-30 11:18:01','614','2021-08-30 13:19:22',10,0),('1','167',221186,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'570',2146567.60,2146567.60,'570','2021-08-31 09:13:16','614','2021-08-31 12:08:38',10,0),('1','167',221282,'AFTERNOON SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'570',2866556.46,2866556.46,'570','2021-08-31 13:28:36','614','2021-08-31 14:02:50',10,0),('1','167',221313,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'570',2162480.24,2162480.24,'570','2021-08-31 14:47:06','614','2021-08-31 14:49:56',10,0),('1','167',221316,'AFTERNOON SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'570',2378629.00,2378629.00,'570','2021-09-01 09:47:12','614','2021-09-01 13:51:29',10,0),('1','167',221520,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'570',2578616.06,2578616.06,'570','2021-09-01 13:58:41','614','2021-09-01 16:25:29',10,0),('1','167',221694,'AFTERNOON SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'570',2567826.22,2567826.22,'570','2021-09-02 10:05:53','614','2021-09-02 13:35:38',10,0),('1','167',221940,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'570',2330174.02,2330174.02,'570','2021-09-03 13:04:56','614','2021-09-03 14:22:46',10,0),('1','167',221972,'AFTERNOON SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'570',3200494.52,3200494.52,'570','2021-09-03 14:44:09','614','2021-09-03 15:24:12',10,0),('1','167',222001,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'570',2189661.98,2189661.98,'570','2021-09-03 16:01:09','614','2021-09-03 20:56:43',10,0),('1','167',222115,'AFTERNOON SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'570',2443140.00,2443140.00,'570','2021-09-04 09:46:57','614','2021-09-04 09:48:44',10,0),('1','167',222122,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'570',2859187.30,2859187.30,'570','2021-09-05 16:03:00','614','2021-09-05 16:28:39',10,0),('1','167',222441,'AFTERNOON SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'570',2823191.00,2823191.00,'570','2021-09-05 16:42:27','614','2021-09-05 23:39:19',10,0),('1','167',222595,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'570',1797176.56,1797176.56,'570','2021-09-06 11:37:27','614','2021-09-06 11:44:21',10,0),('1','167',222664,'AFTERNOON SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'570',2645569.72,2645569.72,'570','2021-09-06 15:23:17','614','2021-09-07 07:00:31',10,0),('1','167',222822,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'570',2203062.64,2203062.64,'570','2021-09-07 11:42:13','614','2021-09-07 12:54:53',10,0),('1','167',222884,'AFTERNOON SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'570',2512671.80,2512671.80,'570','2021-09-07 16:54:31','614','2021-09-07 17:03:41',10,0),('1','167',222903,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'570',2032319.28,2032319.28,'570','2021-09-07 17:25:02','614','2021-09-08 06:36:38',10,0),('1','167',223062,'AFTERNOON SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'570',3622177.26,3622177.26,'570','2021-09-08 14:01:37','614','2021-09-08 14:21:28',10,0),('1','167',223091,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'570',2100414.76,2100414.76,'570','2021-09-08 14:34:30','614','2021-09-09 08:00:51',10,0),('1','167',223308,'AFTERNOON SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'570',3076728.80,3076728.80,'570','2021-09-09 13:23:43','614','2021-09-09 18:53:24',10,0),('1','167',223498,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'570',2472028.62,2472028.62,'570','2021-09-10 11:19:29','614','2021-09-10 13:08:22',10,0),('1','167',223590,'AFTERNOON SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'570',3866044.16,3866044.16,'570','2021-09-10 17:46:39','614','2021-09-11 06:40:04',10,0),('1','167',223757,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'570',1318065.52,1318065.52,'570','2021-09-11 12:11:16','614','2021-09-11 12:15:19',10,0),('1','167',223762,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'570',3198818.70,3198818.70,'570','2021-09-11 12:23:59','614','2021-09-11 12:42:17',10,0),('1','167',223801,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'570',1934908.54,1934908.54,'570','2021-09-11 14:13:13','614','2021-09-11 14:15:34',10,0),('1','167',223805,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'570',3555694.86,3555694.86,'570','2021-09-12 15:40:45','614','2021-09-12 15:50:28',10,0),('1','167',224025,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'570',1839422.58,1839422.58,'570','2021-09-12 16:38:28','614','2021-09-12 17:42:51',10,0),('1','167',224177,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'570',2748311.86,2748311.86,'570','2021-09-13 11:22:25','614','2021-09-13 13:05:08',10,0),('1','167',224224,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'570',1578647.06,1578647.06,'570','2021-09-13 13:15:48','614','2021-09-13 17:12:58',10,0),('1','167',224394,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'570',2898012.68,2898012.68,'570','2021-09-14 10:10:33','614','2021-09-14 14:55:19',10,0),('1','167',224591,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'570',1542614.18,1542614.18,'570','2021-09-15 09:03:10','614','2021-09-15 16:18:00',10,0),('1','167',224757,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',224758,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'570',2910130.90,2910130.90,'570','2021-09-15 20:03:02','614','2021-09-16 10:22:34',10,0),('1','167',224884,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'570',2304596.24,2304596.24,'570','2021-09-16 11:34:02','614','2021-09-16 12:28:06',10,0),('1','167',224898,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'570',3552801.26,3552801.26,'570','2021-09-16 12:52:48','614','2021-09-16 13:14:53',10,0),('1','167',224929,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'570',1546410.00,1546410.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',225088,'MORNING SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'570',1546410.00,1546410.00,'570','2021-09-17 09:41:55','614','2021-09-17 09:59:23',10,0),('1','167',225101,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'570',2883787.30,2883787.30,'570','2021-09-17 10:07:45','614','2021-09-17 13:41:26',10,0),('1','167',225211,'MORNING SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'570',1523535.88,1523535.88,'570','2021-09-17 17:22:05','614','2021-09-17 20:56:43',10,0),('1','167',225390,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',225394,'AFTERNOON SHIFT 1','2021-09-17','2021-09-17 00:00:00',NULL,'570',552476.00,543112.00,'570','2021-09-18 13:14:16','614','2021-09-18 16:33:10',10,0),('1','167',225562,'AFTERNOON SHIFT 2','2021-09-17','2021-09-17 00:00:00',NULL,'570',3215971.12,3215971.12,'570','2021-09-19 11:29:51','614','2021-09-19 12:31:11',10,0),('1','167',225589,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'570',1874488.26,1874488.26,'570','2021-09-19 13:19:01','614','2021-09-19 14:55:13',10,0),('1','167',225830,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'570',2361019.55,2361019.55,'570','2021-09-20 11:37:38','614','2021-09-20 12:22:27',10,0),('1','167',225884,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'570',2285309.22,2285309.22,'570','2021-09-20 14:40:01','614','2021-09-20 14:53:32',10,0),('1','167',225895,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'570',2268550.81,2268550.81,'570','2021-09-20 15:00:03','614','2021-09-20 15:00:57',10,0),('1','167',225900,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'570',1865109.96,1865109.96,'570','2021-09-20 15:12:17','614','2021-09-20 15:33:35',10,0),('1','167',226091,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'570',3297558.97,3297558.97,'570','2021-09-21 13:42:11','614','2021-09-21 14:02:07',10,0),('1','167',226151,'MORNING SHIFT1','2021-09-21','2021-09-21 00:00:00',NULL,'570',515143.75,515143.75,'570','2021-09-21 15:03:29','614','2021-09-21 17:16:21',10,0),('1','167',226188,'MORNING SHIFT 2','2021-09-21','2021-09-21 00:00:00',NULL,'570',1463341.68,1463341.68,'570','2021-09-21 17:31:38','614','2021-09-21 17:41:25',10,0),('1','167',226193,'AFTERNOON SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'570',3353949.72,3353949.72,'570','2021-09-22 11:38:41','614','2021-09-22 14:57:38',10,0),('1','167',226438,'MORNING SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'570',1414331.95,1419416.40,'570','2021-09-22 17:17:54','614','2021-09-23 07:27:04',10,0),('1','167',226588,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'570',2605324.68,2621925.18,'570','2021-09-23 11:45:58','614','2021-09-23 15:49:55',10,0),('1','167',226686,'MORNING SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'570',1715874.77,1723125.12,'570','2021-09-23 17:39:32','614','2021-09-23 21:27:29',10,0),('1','167',226883,'AFTERNOON SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'570',2632228.57,2644752.72,'570','2021-09-24 14:43:48','614','2021-09-24 14:52:41',10,0),('1','167',226888,'MORNING SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'570',2142477.49,2157777.84,'570','2021-09-24 15:15:03','614','2021-09-25 15:22:24',10,0),('1','167',227127,'AFTERNOON SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'570',2481034.24,2487063.54,'570','2021-09-25 15:36:28','614','2021-09-25 15:44:27',10,0),('1','167',227132,'MORNING SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'570',1923524.04,1933363.44,'570','2021-09-25 15:52:00','614','2021-09-25 17:09:09',10,0),('1','167',227306,'AFTERNOON SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'570',2367007.09,2380717.74,'570','2021-09-26 14:15:50','614','2021-09-26 18:12:09',10,0),('1','167',227337,'MORNING SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'570',1542602.59,1547891.94,'570','2021-09-26 18:25:42','614','2021-09-26 18:43:06',10,0),('1','167',227442,'AFTERNOON SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'570',1707185.60,1713011.10,'570','2021-09-27 10:28:28','614','2021-09-27 10:31:51',10,0),('1','167',227474,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'570',1492328.34,1496186.64,'570','2021-09-27 13:38:24','614','2021-09-27 14:21:20',10,0),('1','167',227689,'AFTERNOON SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'570',2074038.56,2084009.46,'570','2021-09-28 10:49:56','614','2021-09-28 11:45:35',10,0),('1','167',227743,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'570',1703587.51,1711892.46,'570','2021-09-28 13:44:14','614','2021-09-28 14:21:16',10,0),('1','167',227917,'AFTERNOON SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'570',1606556.06,1609101.06,'570','2021-09-29 10:33:38','614','2021-09-29 10:37:31',10,0),('1','167',227938,'AFTERNOON SHIFT 2','2021-09-28','2021-09-28 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',227940,'AFTERNOON SHIFT 2','2021-09-28','2021-09-28 00:00:00',NULL,'570',178321.60,187388.80,'570','2021-09-29 10:47:23','614','2021-09-29 10:48:04',10,0),('1','167',227945,'MORNING SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'570',1694552.70,1694552.70,'570','2021-09-29 19:43:02','614','2021-09-30 05:18:26',10,0),('1','167',228120,'AFTERNOON SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'570',1937327.78,1937327.78,'570','2021-09-30 06:55:23','614','2021-09-30 07:18:15',10,0),('1','167',228192,'MORNING SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'570',1803612.22,1803612.22,'570','2021-09-30 16:42:30','614','2021-10-01 01:42:12',10,0),('1','167',228441,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'570',2621054.74,2621054.74,'570','2021-10-01 12:56:19','614','2021-10-01 13:44:29',10,0),('1','167',228456,'MORNING SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'570',1633115.58,1633115.58,'570','2021-10-01 13:50:58','614','2021-10-01 20:44:49',10,0),('1','167',228560,'AFTERNOON SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'570',2623457.50,2623457.50,'570','2021-10-02 08:45:02','614','2021-10-02 18:53:21',10,0),('1','167',228718,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'570',1722810.26,1722810.26,'570','2021-10-02 19:51:44','614','2021-10-02 21:51:31',10,0),('1','167',228792,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'570',2363972.12,2363972.12,'570','2021-10-03 09:45:30','614','2021-10-03 12:20:32',10,0),('1','167',228838,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'570',2377062.96,2377062.96,'570','2021-10-03 13:07:30','614','2021-10-03 15:59:13',10,0),('1','167',229029,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'570',2592938.56,2592938.56,'570','2021-10-04 11:39:39','614','2021-10-04 18:20:21',10,0),('1','167',229265,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'570',1956030.88,1956030.88,'570','2021-10-05 11:48:55','614','2021-10-05 13:50:27',10,0),('1','167',229312,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'570',2190931.92,2190931.92,'570','2021-10-05 13:57:11','614','2021-10-05 15:40:25',10,0),('1','167',229375,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'570',1958624.78,1958624.78,'570','2021-10-05 18:17:34','614','2021-10-05 19:47:47',10,0),('1','167',229395,'AFTERNOON SHIFT 1','2021-10-05','2021-10-05 00:00:00',NULL,'570',76002.70,76002.70,'570','2021-10-05 20:16:24','614','2021-10-06 09:38:33',10,0),('1','167',229600,'AFTERNOON SHIFT 2','2021-10-05','2021-10-05 00:00:00',NULL,'570',2251670.46,2251670.46,'570','2021-10-06 15:21:20','614','2021-10-06 16:37:15',10,0),('1','167',229616,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'570',2197444.26,2197444.26,'570','2021-10-06 16:42:05','614','2021-10-06 21:06:02',10,0),('1','167',229759,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'570',2219770.46,2219770.46,'570','2021-10-07 11:57:10','614','2021-10-07 16:19:41',10,0),('1','167',229838,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'570',1946799.98,1946799.98,'570','2021-10-07 17:50:49','614','2021-10-08 09:18:11',10,0),('1','167',229964,'AFTERNOON SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'570',2177687.22,2177687.22,'570','2021-10-08 11:21:00','614','2021-10-08 15:52:08',10,0),('1','167',230038,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'570',2430328.16,2430328.16,'570','2021-10-08 16:41:06','614','2021-10-09 00:10:45',10,0),('1','167',230216,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'570',2605152.30,2605152.30,'570','2021-10-09 14:07:27','614','2021-10-09 16:19:36',10,0),('1','167',230243,'MORNING SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'570',2487774.18,2487774.18,'570','2021-10-09 17:32:18','614','2021-10-09 18:09:41',10,0),('1','167',230247,'AFTERNOON SHIFT 1','2021-10-09','2021-10-09 00:00:00',NULL,'570',441084.80,441084.80,'570','2021-10-09 18:14:04','614','2021-10-09 22:16:36',10,0),('1','167',230422,'AFTERNOON SHIFT 2','2021-10-09','2021-10-09 00:00:00',NULL,'570',1966300.01,1966300.01,'570','2021-10-10 14:18:07','614','2021-10-10 14:20:28',10,0),('1','167',230440,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'570',2014735.87,2014735.87,'570','2021-10-10 14:30:12','614','2021-10-10 20:25:40',10,0),('1','167',230567,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'570',3037518.00,3037518.00,'570','2021-10-11 08:32:04','614','2021-10-11 10:41:23',10,0),('1','167',230647,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'570',1863619.55,1863619.55,'570','2021-10-11 13:22:13','614','2021-10-11 14:17:47',10,0),('1','167',230867,'AFTERNOON SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'570',2225205.19,2225205.19,'570','2021-10-12 10:42:16','614','2021-10-12 13:52:32',10,0),('1','167',230957,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'570',2382103.47,2382103.47,'570','2021-10-12 14:00:54','614','2021-10-12 15:41:51',10,0),('1','167',231144,'AFTERNOON SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'570',2690094.06,2690094.06,'570','2021-10-13 11:19:08','614','2021-10-13 14:22:51',10,0),('1','167',231340,'MORNING SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'570',1979078.42,1979078.42,'570','2021-10-13 18:47:00','614','2021-10-13 22:41:32',10,0),('1','167',231387,'AFTERNOON SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'570',3326654.98,3326654.98,'570','2021-10-14 10:16:28','614','2021-10-14 14:12:14',10,0),('1','167',231600,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'570',2219055.58,2219055.58,'570','2021-10-14 18:54:34','614','2021-10-15 00:20:08',10,0),('1','167',231702,'AFTERNOON SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'570',3123877.50,3123877.50,'570','2021-10-15 09:53:13','614','2021-10-15 13:38:31',10,0),('1','167',231858,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'570',2520087.17,2520087.17,'570','2021-10-15 19:59:24','614','2021-10-15 20:28:51',10,0),('1','167',231965,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'570',2796681.55,2796681.55,'570','2021-10-16 10:50:46','614','2021-10-16 12:59:37',10,0),('1','167',232259,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'570',3562038.87,3562038.87,'570','2021-10-17 15:48:56','614','2021-10-17 17:10:47',10,0),('1','167',232277,'AFTERNOON SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',232279,'AFTERNOON SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'570',3176512.35,3176512.35,'570','2021-10-17 18:46:44','614','2021-10-18 12:00:40',10,0),('1','167',232503,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'570',2751955.99,2751955.99,'570','2021-10-18 15:11:28','614','2021-10-18 15:47:45',10,0),('1','167',232518,'AFTERNOON SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'570',2149470.94,2149470.94,'570','2021-10-18 15:59:45','614','2021-10-18 16:07:58',10,0),('1','167',232525,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'570',3049532.40,3049532.40,'570','2021-10-18 16:31:50','614','2021-10-18 21:24:07',10,0),('1','167',232754,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'570',2328886.86,2369155.99,'570','2021-10-19 16:58:14','614','2021-10-19 17:35:19',10,0),('1','167',232768,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'570',2653147.04,2653147.04,'570','2021-10-19 18:38:44','614','2021-10-20 11:05:44',10,0),('1','167',232972,'AFTERNOON SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'570',2670158.76,2670158.76,'570','2021-10-20 11:45:24','614','2021-10-20 13:23:15',10,0),('1','167',233001,'MORNING SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'570',2147895.39,2147895.39,'570','2021-10-20 13:30:02','614','2021-10-20 15:11:27',10,0),('1','167',233267,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'570',2104532.18,2104532.18,'570','2021-10-21 13:53:55','614','2021-10-21 14:19:02',10,0),('1','167',233280,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'570',2537585.01,2537585.01,'570','2021-10-21 14:45:31','614','2021-10-21 17:55:09',10,0),('1','167',233534,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'570',731603.15,731603.15,'570','2021-10-22 15:03:12','614','2021-10-22 15:17:42',10,0),('1','167',233545,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'570',1920171.42,1920171.42,'570','2021-10-22 15:32:17','614','2021-10-22 16:10:09',10,0),('1','167',233550,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'570',511931.20,511931.20,'570','2021-10-22 16:13:22','614','2021-10-22 16:27:24',10,0),('1','167',233740,'AFTERNOON SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'570',412518.60,412518.60,'570','2021-10-24 17:46:13','614','2021-10-24 19:06:45',10,0),('1','167',234160,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'570',382462.60,382462.60,'570','2021-10-25 10:45:55','614','2021-10-25 10:56:35',10,0),('1','167',234168,'AFTERNOON SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'570',767896.80,767896.80,'570','2021-10-25 11:03:01','614','2021-10-25 11:41:24',10,0),('1','167',234181,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'570',852655.40,852655.40,'570','2021-10-25 11:48:46','614','2021-10-25 13:00:53',10,0),('1','167',234245,'AFTERNOON SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'570',1120619.60,1120619.60,'570','2021-10-25 18:40:41','614','2021-10-25 19:20:42',10,0),('1','167',234271,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'570',841088.60,841088.60,'570','2021-10-25 19:36:13','614','2021-10-26 07:49:41',10,0),('1','167',234425,'AFTERNOON SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'570',1466013.39,1466013.39,'570','2021-10-26 11:32:37','614','2021-10-26 17:04:19',10,0),('1','167',234513,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'570',1870878.19,1870878.19,'570','2021-10-26 17:29:46','614','2021-10-26 20:35:20',10,0),('1','167',234674,'AFTERNOON SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'570',2910101.06,2910101.06,'570','2021-10-27 10:20:12','614','2021-10-27 11:42:53',10,0),('1','167',234736,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'570',1842337.37,1842337.37,'570','2021-10-27 14:18:56','614','2021-10-27 20:34:05',10,0),('1','167',234944,'AFTERNOON SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'570',2918110.83,2918110.83,'570','2021-10-28 15:44:38','614','2021-10-28 16:10:11',10,0),('1','167',235006,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'570',2237133.75,2237133.75,'570','2021-10-28 16:53:08','614','2021-10-28 17:15:43',10,0),('1','167',235156,'AFTERNOON SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'570',3219123.42,3219123.42,'570','2021-10-29 09:58:35','614','2021-10-29 11:30:31',10,0),('1','167',235199,'MORNING SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'570',2237356.02,2237356.02,'570','2021-10-29 12:52:00','614','2021-10-29 16:29:16',10,0),('1','167',235390,'AFTERNOON SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'570',2828937.14,2828937.14,'570','2021-10-30 10:31:26','614','2021-10-30 11:52:11',10,0),('1','167',235439,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'570',2218203.27,2218203.27,'570','2021-10-30 15:26:40','614','2021-10-30 19:20:42',10,0),('1','167',235572,'AFTERNOON SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'570',3094348.79,3094348.79,'570','2021-10-31 08:24:17','614','2021-10-31 09:39:04',10,0),('1','167',235651,'MORNING SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'570',2668225.40,2668225.40,'570','2021-10-31 13:49:21','614','2021-10-31 14:15:31',10,0),('1','167',235894,'AFTERNOON SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'570',2908013.75,2908013.75,'570','2021-11-01 12:21:01','614','2021-11-01 14:48:22',10,0),('1','167',235938,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'570',2163399.10,2180519.70,'570','2021-11-01 14:54:47','614','2021-11-01 20:37:25',10,0),('1','167',235980,'AFTERNOON SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'570',2871255.63,2893734.05,'570','2021-11-03 09:42:08','614','2021-11-03 09:45:45',10,0),('1','167',236339,'MORNING SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'570',2549478.16,2567465.60,'570','2021-11-03 10:04:05','614','2021-11-03 13:54:05',10,0),('1','167',236410,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'570',1513353.72,1530050.60,'570','2021-11-05 14:58:13','614','2021-11-05 18:03:10',10,0),('1','167',236905,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'570',1749578.25,1749578.25,'570','2021-11-05 19:52:56','614','2021-11-05 19:58:10',10,0),('1','167',236913,'AFTERNOON SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'570',1861475.55,1861475.55,'570','2021-11-05 20:07:09','614','2021-11-05 20:40:50',10,0),('1','167',236918,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'570',2232938.40,2232938.40,'570','2021-11-05 20:55:06','614','2021-11-05 20:59:24',10,0),('1','167',236920,'AFTERNOON SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'570',3234473.55,3234473.55,'570','2021-11-05 21:09:03','614','2021-11-05 21:13:32',10,0),('1','167',236922,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'570',2167685.35,2167685.35,'570','2021-11-05 21:27:00','614','2021-11-05 21:29:15',10,0),('1','167',236927,'AFTERNOON SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'570',3092824.25,3092824.25,'570','2021-11-06 11:31:44','614','2021-11-06 14:00:58',10,0),('1','167',237091,'MORNING SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'570',2804548.90,2804548.90,'570','2021-11-06 14:20:16','614','2021-11-06 15:20:31',10,0),('1','167',237105,'AFTERNOON SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'570',2893237.80,2893237.80,'570','2021-11-06 20:55:09','614','2021-11-06 21:46:35',10,0),('1','167',237309,'MORNING SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'570',3017682.35,3017682.35,'570','2021-11-07 14:37:25','614','2021-11-07 15:39:10',10,0),('1','167',237343,'AFTERNOON SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'570',2990477.75,2990477.75,'570','2021-11-07 21:06:12','614','2021-11-08 21:41:48',10,0),('1','167',237695,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'570',2854830.70,2854830.70,'570','2021-11-09 10:12:04','614','2021-11-09 10:16:16',10,0),('1','167',237708,'AFTERNOON SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'570',3306146.95,3306146.95,'570','2021-11-09 11:34:27','614','2021-11-09 15:26:29',10,0),('1','167',237800,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'570',2698327.55,2698327.55,'570','2021-11-09 17:36:07','614','2021-11-09 20:48:22',10,0),('1','167',237944,'AFTERNOON SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'570',3307542.40,3307542.40,'570','2021-11-10 08:53:33','614','2021-11-10 10:10:46',10,0),('1','167',238014,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'570',2612793.25,2612793.25,'570','2021-11-10 13:04:37','614','2021-11-10 13:35:17',10,0),('1','167',238075,'AFTERNOON SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'570',2562622.85,2562622.85,'570','2021-11-11 14:20:49','614','2021-11-11 16:15:57',10,0),('1','167',238530,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'570',3533352.70,3533352.70,'570','2021-11-12 14:54:30','614','2021-11-12 16:12:16',10,0),('1','167',238543,'AFTERNOON SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'570',3544654.75,3544654.75,'570','2021-11-12 17:06:35','614','2021-11-12 17:38:18',10,0),('1','167',238552,'MORNING SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'570',3867783.00,3867783.00,'570','2021-11-12 18:08:37','614','2021-11-12 20:13:31',10,0),('1','167',238566,'AFTERNOON SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'570',2990060.10,2990060.10,'570','2021-11-13 11:45:03','614','2021-11-13 13:09:40',10,0),('1','167',238742,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'570',2800958.65,2800958.65,'570','2021-11-13 13:51:27','614','2021-11-13 18:09:39',10,0),('1','167',238786,'AFTERNOON SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'570',2462763.40,2462763.40,'570','2021-11-13 19:51:23','614','2021-11-14 00:43:17',10,0),('1','167',238933,'MORNING SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'570',2972232.15,2972232.15,'570','2021-11-14 12:55:34','614','2021-11-14 13:58:34',10,0),('1','167',239014,'AFTERNOON SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'570',2893566.20,2893566.20,'570','2021-11-14 20:31:08','614','2021-11-15 05:43:06',10,0),('1','167',239228,'MORNING SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'570',2146462.45,2146462.45,'570','2021-11-15 16:56:37','614','2021-11-15 19:59:37',10,0),('1','167',239257,'AFTERNOON SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'570',3412480.55,3412480.55,'570','2021-11-15 20:17:09','614','2021-11-16 06:15:20',10,0),('1','167',239393,'MORNING SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'570',2576489.95,2576489.95,'570','2021-11-16 13:52:06','614','2021-11-16 17:13:28',10,0),('1','167',239477,'AFTERNOON SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'570',3431307.55,3431307.55,'570','2021-11-16 20:29:24','614','2021-11-17 06:46:24',10,0),('1','167',239637,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'570',3109628.50,3109628.50,'570','2021-11-17 13:43:15','614','2021-11-17 13:48:51',10,0),('1','167',239668,'AFTERNOON SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'570',3563871.85,3563871.85,'570','2021-11-17 20:21:52','614','2021-11-17 20:31:23',10,0),('1','167',239818,'MORNING  SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'570',2925498.45,2925498.45,'570','2021-11-18 14:35:48','614','2021-11-18 15:39:47',10,0),('1','167',239948,'AFTERNOON SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'570',3324493.90,3324493.90,'570','2021-11-18 20:07:08','614','2021-11-18 21:05:03',10,0),('1','167',240008,'MORNING  SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'570',3435441.35,3435441.35,'570','2021-11-19 13:07:43','614','2021-11-19 13:50:31',10,0),('1','167',240138,'AFTERNOON SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'570',2739409.20,2739409.20,'570','2021-11-19 19:53:00','614','2021-11-20 05:56:58',10,0),('1','167',240213,'MORNING  SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'570',2811891.95,2811891.95,'570','2021-11-20 14:41:43','614','2021-11-20 18:29:57',10,0),('1','167',240388,'AFTERNOON SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'570',2973689.05,2973689.05,'570','2021-11-20 20:05:20','614','2021-11-21 06:40:52',10,0),('1','167',240491,'MORNING  SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'570',2368303.25,2368303.25,'570','2021-11-21 12:43:27','614','2021-11-21 14:32:26',10,0),('1','167',240598,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'570',2860919.10,2860919.10,'570','2021-11-21 20:13:23','614','2021-11-22 10:01:50',10,0),('1','167',240789,'MORNING  SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'570',2665660.35,2665660.35,'570','2021-11-22 13:07:30','614','2021-11-22 14:25:52',10,0),('1','167',240881,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'570',3252402.65,3252402.65,'570','2021-11-22 20:42:09','614','2021-11-22 21:01:24',10,0),('1','167',240965,'MORNING  SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'570',2753418.65,2753418.65,'570','2021-11-23 13:11:39','614','2021-11-23 14:52:26',10,0),('1','167',241169,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'570',0.00,0.00,'570','2021-11-23 20:44:54','614','2021-11-23 22:30:47',10,0),('1','167',241274,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'570',3066663.10,3066663.10,'570','2021-11-24 08:26:37','614','2021-11-24 08:51:44',10,0),('1','167',241346,'MORNING  SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'570',2517835.75,2517835.75,'570','2021-11-24 13:53:26','614','2021-11-24 16:08:57',10,0),('1','167',241458,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'570',3002546.50,3002546.50,'570','2021-11-25 06:56:31','614','2021-11-25 09:03:45',10,0),('1','167',241584,'MORNING  SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'570',2832043.35,2832043.35,'570','2021-11-25 13:32:45','614','2021-11-25 14:24:30',10,0),('1','167',241688,'AFTERNOON SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'570',1776913.05,1776913.05,'570','2021-11-26 07:42:30','614','2021-11-26 09:45:38',10,0),('1','167',241831,'MORNING  SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'570',1418756.65,1418756.65,'570','2021-11-26 13:42:53','614','2021-11-26 14:38:51',10,0),('1','167',241906,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'570',0.00,0.00,'570','2021-11-26 21:09:23','614','2021-11-27 07:11:25',10,0),('1','167',242051,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'570',3032913.00,3032913.00,'570','2021-11-27 09:50:14','614','2021-11-27 13:54:05',10,0),('1','167',242108,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'570',2578881.95,2578881.95,'570','2021-11-27 14:04:12','614','2021-11-27 17:07:57',10,0),('1','167',242141,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'570',0.00,0.00,'570','2021-11-28 15:22:02','614','2021-11-28 15:27:15',10,0),('1','167',242344,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'570',2888591.45,2888591.45,'570','2021-11-28 15:39:18','614','2021-11-28 15:41:56',10,0),('1','167',242346,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'570',2344588.05,2344588.05,'570','2021-11-28 15:51:50','614','2021-11-28 17:04:42',10,0),('1','167',242363,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'570',2850405.25,2850405.25,'570','2021-11-29 10:28:47','614','2021-11-29 13:04:05',10,0),('1','167',242569,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'570',3008198.55,3008198.55,'570','2021-11-29 13:20:27','614','2021-11-29 19:08:22',10,0),('1','167',242627,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'570',3130314.10,3130314.10,'570','2021-11-29 20:24:13','614','2021-11-29 20:43:04',10,0),('1','167',242647,'MORNING  SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'570',3137468.70,3137468.70,'570','2021-11-30 13:41:57','614','2021-11-30 14:28:06',10,0),('1','167',242873,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'570',0.00,0.00,'570','2021-11-30 20:11:00','614','2021-11-30 20:12:19',10,0),('1','167',242876,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'570',3807825.25,3807825.25,'570','2021-11-30 20:39:54','614','2021-11-30 21:20:17',10,0),('1','167',242955,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'570',2597661.75,2597661.75,'570','2021-12-01 15:03:05','614','2021-12-01 16:07:26',10,0),('1','167',243157,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'570',3057385.85,3057385.85,'570','2021-12-02 07:01:42','614','2021-12-02 08:38:58',10,0),('1','167',243271,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'570',3525451.35,3525451.35,'570','2021-12-02 14:13:54','614','2021-12-03 06:12:43',10,0),('1','167',243409,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'570',3227202.80,3227202.80,'570','2021-12-03 07:55:06','614','2021-12-03 08:39:41',10,0),('1','167',243437,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'570',2286583.15,2286583.15,'570','2021-12-03 13:06:54','614','2021-12-03 14:20:04',10,0),('1','167',243553,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'570',2628711.50,2628711.50,'570','2021-12-03 22:25:02','614','2021-12-04 06:17:03',10,0),('1','167',243712,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'570',2523212.60,2523212.60,'570','2021-12-04 14:02:16','614','2021-12-04 14:44:26',10,0),('1','167',243796,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'570',3017374.05,3017374.05,'570','2021-12-04 21:21:24','614','2021-12-04 23:20:01',10,0),('1','167',243947,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'570',2575393.05,2575393.05,'570','2021-12-05 13:14:17','614','2021-12-05 14:32:51',10,0),('1','167',244033,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'570',2550645.70,2550645.70,'570','2021-12-06 05:14:44','614','2021-12-06 05:35:27',10,0),('1','167',244180,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'570',2343322.30,2343322.30,'570','2021-12-06 13:22:35','614','2021-12-06 15:42:41',10,0),('1','167',244333,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'570',3424709.60,3424709.60,'570','2021-12-07 07:32:48','614','2021-12-07 10:46:14',10,0),('1','167',244396,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'570',2817170.05,2817170.05,'570','2021-12-07 13:08:36','614','2021-12-07 13:29:02',10,0),('1','167',244487,'AFTERNOON SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'570',2935881.00,2935881.00,'570','2021-12-08 05:14:23','614','2021-12-08 06:47:56',10,0),('1','167',244623,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'570',1342164.45,1342164.45,'570','2021-12-08 12:40:09','614','2021-12-08 13:41:48',10,0),('1','167',244675,'AFTERNOON SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'570',0.00,0.00,'570','2021-12-08 16:24:06','614','2021-12-09 06:20:48',10,0),('1','167',244775,'AFTERNOON SHIFT  2','2021-12-09','2021-12-09 00:00:00',NULL,'570',2269890.80,2269890.80,'570','2021-12-09 07:14:23','614','2021-12-09 13:34:55',10,0),('1','167',244890,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'570',1537256.90,1537256.90,'570','2021-12-09 15:34:44','614','2021-12-09 16:20:58',10,0),('1','167',244934,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'570',2693632.10,2693632.10,'570','2021-12-09 20:41:38','614','2021-12-10 11:20:34',10,0),('1','167',245086,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'570',3626623.20,3626623.20,'570','2021-12-10 12:29:55','614','2021-12-10 14:24:25',10,0),('1','167',245147,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'570',0.00,0.00,'570','2021-12-10 16:38:56','614','2021-12-10 18:34:18',10,0),('1','167',245179,'AFTERNOON SHIFT  2','2021-12-10','2021-12-10 00:00:00',NULL,'570',2949192.45,2949192.45,'570','2021-12-10 20:25:35','614','2021-12-11 06:08:08',10,0),('1','167',245318,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'570',2082757.80,2082757.80,'570','2021-12-11 13:04:39','614','2021-12-11 15:54:37',10,0),('1','167',245382,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'570',3905179.75,3905179.75,'570','2021-12-11 21:15:16','614','2021-12-12 06:48:59',10,0),('1','167',245544,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'570',2316629.10,2316629.10,'570','2021-12-12 12:54:14','614','2021-12-12 13:40:18',10,0),('1','167',245584,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'570',3593119.85,3593119.85,'570','2021-12-12 21:43:38','614','2021-12-13 00:22:01',10,0),('1','167',245756,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'570',2907035.90,2907035.90,'570','2021-12-13 16:11:32','614','2021-12-13 20:59:52',10,0),('1','167',245910,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'570',3987330.10,3987330.10,'570','2021-12-14 05:55:06','614','2021-12-14 13:21:21',10,0),('1','167',246081,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'570',2216395.85,2216395.85,'570','2021-12-14 14:42:38','614','2021-12-14 15:25:22',10,0),('1','167',246109,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'570',3445303.55,3445303.55,'570','2021-12-14 21:32:38','614','2021-12-14 22:34:07',10,0),('1','167',246321,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'570',2484179.45,2484179.45,'570','2021-12-15 13:05:53','614','2021-12-15 15:24:21',10,0),('1','167',246429,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'570',3139692.05,3139692.05,'570','2021-12-15 22:33:21','614','2021-12-16 07:43:52',10,0),('1','167',246558,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'570',3141389.25,3141389.25,'570','2021-12-16 13:05:56','614','2021-12-16 14:45:26',10,0),('1','167',246677,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'570',4346754.25,4346754.25,'570','2021-12-16 21:31:54','614','2021-12-16 23:28:09',10,0),('1','167',246819,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'570',2454202.25,2454202.25,'570','2021-12-17 12:47:04','614','2021-12-17 17:18:24',10,0),('1','167',246894,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'570',3072870.25,3072870.25,'570','2021-12-17 20:23:08','614','2021-12-18 05:10:07',10,0),('1','167',247062,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'570',2246636.30,2246636.30,'570','2021-12-18 13:25:20','614','2021-12-18 15:56:32',10,0),('1','167',247133,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'570',971729.55,971729.55,'570','2021-12-18 19:47:51','614','2021-12-19 09:20:56',10,0),('1','167',247297,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'570',187341.00,187341.00,'570','2021-12-19 15:01:02','614','2021-12-19 15:28:32',10,0),('1','167',247331,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'570',0.00,0.00,'570','2021-12-19 17:00:53','614','2021-12-19 17:59:15',10,0),('1','167',247344,'AFTERNOON SHIFT 2','2021-12-19','2021-12-19 00:00:00',NULL,'570',0.00,0.00,'570','2021-12-19 18:16:29','614','2021-12-19 19:52:47',10,0),('1','167',247371,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'570',4454863.75,4454863.75,'570','2021-12-19 21:30:37','614','2021-12-20 06:55:57',10,0),('1','167',247547,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'570',3490658.85,3490658.85,'570','2021-12-20 13:48:35','614','2021-12-20 13:51:27',10,0),('1','167',247615,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'570',3850734.85,3850734.85,'570','2021-12-20 21:17:50','614','2021-12-21 07:06:57',10,0),('1','167',247783,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'570',2531601.30,2531601.30,'570','2021-12-21 13:35:38','614','2021-12-21 13:40:24',10,0),('1','167',247876,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'570',3408693.50,3408693.50,'570','2021-12-21 21:20:38','614','2021-12-22 07:42:34',10,0),('1','167',248032,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'570',3629296.30,3629296.30,'570','2021-12-22 13:47:36','614','2021-12-22 14:02:40',10,0),('1','167',248119,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'570',4259822.55,4259822.55,'570','2021-12-22 21:53:25','614','2021-12-23 07:26:40',10,0),('1','167',248264,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'570',2583787.10,2583787.10,'570','2021-12-23 13:21:03','614','2021-12-23 14:19:28',10,0),('1','167',248367,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'570',3600065.40,3600065.40,'570','2021-12-23 21:50:02','614','2021-12-24 05:54:49',10,0),('1','167',248511,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'570',2473171.35,2473171.35,'570','2021-12-24 12:49:46','614','2021-12-24 13:45:52',10,0),('1','167',248609,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'570',3352119.40,3352119.40,'570','2021-12-24 21:23:05','614','2021-12-25 06:01:40',10,0),('1','167',248736,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'570',2903025.50,2903025.50,'570','2021-12-25 13:40:06','614','2021-12-25 13:48:05',10,0),('1','167',248845,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'570',4015182.85,4015182.85,'570','2021-12-26 06:46:43','614','2021-12-26 06:49:00',10,0),('1','167',248995,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'570',1799625.85,1799625.85,'570','2021-12-26 14:30:17','614','2021-12-26 14:37:23',10,0),('1','167',249073,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'570',1926546.70,1926546.70,'570','2021-12-26 21:18:46','614','2021-12-26 21:41:44',10,0),('1','167',249221,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'570',1437303.35,1437303.35,'570','2021-12-27 14:22:51','614','2021-12-27 20:49:26',10,0),('1','167',249321,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'570',2195376.65,2195376.65,'570','2021-12-27 21:05:24','614','2021-12-27 21:51:37',10,0),('1','167',249470,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'570',2164110.10,2164110.10,'570','2021-12-28 12:57:49','614','2021-12-28 16:06:29',10,0),('1','167',249523,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'570',1319601.55,1319601.55,'570','2021-12-28 20:53:20','614','2021-12-28 23:50:34',10,0),('1','167',249727,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'570',1572720.65,1572720.65,'570','2021-12-29 15:30:14','614','2021-12-29 15:35:21',10,0),('1','167',249791,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'570',667916.30,667916.30,'570','2021-12-29 18:40:49','614','2021-12-29 22:41:47',10,0),('1','167',249969,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'570',658449.20,658449.20,'570','2021-12-30 12:31:16','614','2021-12-30 13:44:00',10,0),('1','167',250056,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'570',1159739.85,1159739.85,'570','2021-12-30 20:15:19','614','2021-12-30 21:04:59',10,0),('1','167',250220,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'570',2290868.45,2290868.45,'570','2021-12-31 13:05:32','614','2021-12-31 15:31:26',10,0),('1','167',250301,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'570',2532160.70,2532160.70,'570','2021-12-31 21:01:57','614','2022-01-01 01:47:33',10,0),('1','167',250467,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'570',1976125.10,1976125.10,'570','2022-01-01 13:48:38','614','2022-01-01 20:24:00',10,0),('1','167',250539,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'570',1968941.15,1968941.15,'570','2022-01-01 22:11:01','614','2022-01-02 06:44:03',10,0),('1','167',250701,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'570',1747926.75,1747926.75,'570','2022-01-02 14:42:16','614','2022-01-02 19:03:04',10,0),('1','167',250771,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'570',2549287.10,2549287.10,'570','2022-01-02 21:21:10','614','2022-01-03 06:19:20',10,0),('1','167',250887,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'570',2573038.00,2573038.00,'570','2022-01-03 13:37:31','614','2022-01-03 14:44:05',10,0),('1','167',250989,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'570',2671183.10,2671183.10,'570','2022-01-03 21:15:28','614','2022-01-04 01:15:24',10,0),('1','167',251147,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',251149,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'570',2304420.10,2304420.10,'570','2022-01-04 13:32:11','614','2022-01-04 15:02:38',10,0),('1','167',251249,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'570',2797282.85,2797282.85,'570','2022-01-04 22:07:27','614','2022-01-04 22:18:57',10,0),('1','167',251412,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'570',3373924.75,3373924.75,'570','2022-01-05 15:13:00','614','2022-01-05 17:37:44',10,0),('1','167',251492,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'570',3336475.35,3336475.35,'570','2022-01-05 22:35:25','614','2022-01-06 14:20:25',10,0),('1','167',251652,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'570',2097244.85,2097244.85,'570','2022-01-06 14:30:49','614','2022-01-06 14:56:21',10,0),('1','167',251719,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'570',4253983.40,4253983.40,'570','2022-01-06 21:19:38','614','2022-01-06 23:56:11',10,0),('1','167',251869,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'570',2651106.90,2651106.90,'570','2022-01-07 13:49:56','614','2022-01-07 19:55:08',10,0),('1','167',251953,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'570',3390448.80,3390448.80,'570','2022-01-07 22:18:02','614','2022-01-07 22:26:47',10,0),('1','167',252136,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'570',1904819.00,1904819.00,'570','2022-01-08 14:30:23','614','2022-01-08 15:52:13',10,0),('1','167',252164,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'570',1398156.10,1398156.10,'570','2022-01-08 20:06:19','614','2022-01-08 23:42:45',10,0),('1','167',252361,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'570',817627.80,817627.80,'570','2022-01-09 14:56:34','614','2022-01-09 18:26:57',10,0),('1','167',252427,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'570',1771165.10,1771165.10,'570','2022-01-09 21:10:51','614','2022-01-09 22:26:05',10,0),('1','167',252520,'MORNING SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'570',0.00,0.00,'570','2022-01-10 11:16:38','614','2022-01-10 12:43:20',10,0),('1','167',252609,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'570',776034.20,776034.20,'570','2022-01-10 14:16:03','614','2022-01-10 17:04:16',10,0),('1','167',252673,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'570',1254802.80,1254802.80,'570','2022-01-10 21:26:27','614','2022-01-10 22:24:48',10,0),('1','167',252854,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'570',1159981.05,1159981.05,'570','2022-01-11 14:37:15','614','2022-01-11 14:56:37',10,0),('1','167',252893,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'570',3989939.25,3989939.25,'570','2022-01-11 22:04:20','614','2022-01-11 22:28:06',10,0),('1','167',253077,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'570',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',253112,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'570',2997778.10,2997778.10,'570','2022-01-12 15:17:30','614','2022-01-12 19:33:22',10,0),('1','167',253168,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'570',3919067.00,3919067.00,'570','2022-01-12 21:55:59','614','2022-01-12 23:28:45',10,0),('1','167',253362,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'570',2221312.55,2221312.55,'570','2022-01-13 14:13:49','614','2022-01-13 15:27:01',10,0),('1','167',253443,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'570',4094117.75,4094117.75,'570','2022-01-13 22:01:43','614','2022-01-14 07:39:10',10,0),('1','167',253597,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'570',2596342.05,2596342.05,'570','2022-01-14 13:43:39','614','2022-01-14 13:56:21',10,0),('1','167',253673,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'570',2558138.30,2558138.30,'570','2022-01-14 21:30:14','614','2022-01-15 07:15:28',10,0),('1','167',253818,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'570',2272148.05,2272148.05,'570','2022-01-15 13:44:21','614','2022-01-15 15:03:01',10,0),('1','167',253914,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'570',3116845.60,3116845.60,'570','2022-01-15 21:43:49','614','2022-01-16 08:24:03',10,0),('1','167',254076,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'570',2144695.45,2144695.45,'570','2022-01-16 14:21:35','614','2022-01-16 15:14:08',10,0),('1','167',254154,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'570',3480340.10,3480340.10,'570','2022-01-16 21:38:09','614','2022-01-16 22:35:53',10,0),('1','167',254345,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'570',2882928.70,2882928.70,'570','2022-01-17 15:33:11','614','2022-01-17 15:40:48',10,0),('1','167',254412,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'570',2923068.65,2923068.65,'570','2022-01-17 21:36:50','614','2022-01-18 10:03:05',10,0),('1','167',254578,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'570',2573542.20,2573542.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','167',254618,'MORNING','2022-01-18','2022-01-18 00:00:00',NULL,'570',2608824.30,2608824.30,'570','2022-01-18 16:11:14','614','2022-01-18 17:48:27',10,0),('1','167',254675,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'570',2601020.55,2601020.55,'570','2022-01-18 21:57:07','614','2022-01-19 03:15:21',10,0),('1','167',254821,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'570',1751100.60,1751100.60,'570','2022-01-19 14:09:42','614','2022-01-19 15:47:44',10,0),('1','167',254909,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'570',2763589.05,2763589.05,'570','2022-01-19 22:54:52','614','2022-01-20 10:33:41',10,0),('1','167',255059,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'570',1754179.65,1754179.65,'570','2022-01-20 13:48:52','614','2022-01-20 16:41:41',10,0),('1','167',255151,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'570',2396895.60,2396895.60,'570','2022-01-20 21:54:52','614','2022-01-20 22:19:33',10,0),('1','167',255277,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'570',2268316.60,2268316.60,'570','2022-01-21 14:03:34','614','2022-01-21 15:11:04',10,0),('1','167',255430,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'570',3223516.25,3223516.25,'570','2022-01-21 21:33:33','614','2022-01-22 00:46:33',10,0),('1','167',255584,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'570',2041293.85,2041293.85,'570','2022-01-22 13:46:25','614','2022-01-22 15:04:29',10,0),('1','167',255679,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'570',2268044.70,2268044.70,'570','2022-01-22 21:27:18','614','2022-01-22 23:29:57',10,0),('1','167',255813,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'570',2852768.35,2852768.35,'570','2022-01-23 13:37:33','614','2022-01-23 15:55:25',10,0),('1','167',255916,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'570',2930100.25,2930100.25,'570','2022-01-23 21:43:06','614','2022-01-23 23:52:51',10,0),('1','167',256092,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'570',2909963.75,2909963.75,'570','2022-01-24 14:49:13','614','2022-01-24 18:04:09',10,0),('1','167',256167,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'570',2922337.95,2922337.95,'570','2022-01-24 21:44:13','614','2022-01-24 23:15:21',10,0),('1','167',256297,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'570',630532.00,630532.00,'570','2022-01-25 10:41:17','614','2022-01-25 10:51:17',10,0),('1','167',256330,'MORNING SHIFT 2','2022-01-25','2022-01-25 00:00:00',NULL,'570',1973969.70,1973969.70,'570','2022-01-25 14:16:13','614','2022-01-25 15:47:08',10,0),('1','167',256418,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'570',3245431.00,3245431.00,'570','2022-01-25 22:04:54','614','2022-01-25 23:34:10',10,0),('1','167',256610,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'570',2327662.75,2327662.75,'570','2022-01-26 14:34:06','614','2022-01-26 15:22:13',10,0),('1','167',256656,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'570',3300449.30,3300449.30,'570','2022-01-26 21:57:45','614','2022-01-26 23:38:29',10,0),('1','167',256845,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'570',2115036.00,2115036.00,'570','2022-01-27 15:10:49','614','2022-01-27 17:45:15',10,0),('1','167',256928,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'570',4211312.15,4211312.15,'570','2022-01-27 22:37:31','614','2022-01-28 08:07:31',10,0),('1','167',256995,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'570',131282.55,131282.55,'570','2022-01-28 08:14:12','614','2022-01-28 10:09:03',10,0),('1','167',257092,'MORNING SHIFT 2','2022-01-28','2022-01-28 00:00:00',NULL,'570',2024528.40,2024528.40,'570','2022-01-28 14:00:30','614','2022-01-28 18:00:02',10,0),('1','167',257190,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'570',2369781.75,2369781.75,'570','2022-01-28 21:49:21','614','2022-01-29 00:38:55',10,0),('1','167',257348,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'570',2166530.10,2166530.10,'570','2022-01-29 14:02:36','614','2022-01-29 16:48:28',10,0),('1','167',257448,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'570',2767975.35,2767975.35,'570','2022-01-29 21:37:02','614','2022-01-29 22:50:52',10,0),('1','167',257611,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'570',2673350.85,2673350.85,'570','2022-01-30 14:04:53','614','2022-01-30 15:37:35',10,0),('1','167',257612,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'570',2834924.10,2834924.10,'570','2022-01-31 07:51:14','614','2022-01-31 10:14:46',10,0),('1','167',257613,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'570',2371002.30,2371002.30,'570','2022-01-31 14:33:54','614','2022-01-31 18:21:45',10,0),('1','167',257614,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'570',3355448.85,3355448.85,'570','2022-01-31 21:49:47','614','2022-02-01 11:55:40',10,0),('1','167',257615,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'570',2491829.40,2491829.40,'570','2022-02-01 14:12:40','614','2022-02-01 15:56:44',10,0),('1','167',257616,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'570',3090747.90,3090747.90,'570','2022-02-01 21:40:02','614','2022-02-02 05:35:21',10,0),('1','167',257617,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'570',2394191.55,2394191.55,'570','2022-02-02 15:37:01','614','2022-02-02 16:26:40',10,0),('1','167',257618,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'570',2925709.80,2925709.80,'570','2022-02-02 21:54:57','614','2022-02-03 07:08:02',10,0),('1','167',257619,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'570',2895557.10,2895557.10,'570','2022-02-03 15:13:12','614','2022-02-03 16:25:16',10,0),('1','167',257620,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'570',3347936.70,3347936.70,'570','2022-02-03 21:39:00','614','2022-02-03 23:09:09',10,0),('1','167',257621,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'570',2945057.70,2945057.70,'570','2022-02-04 13:54:02','614','2022-02-04 19:18:23',10,0),('1','167',257622,'AFTERNOON SHIFT ','2022-02-04','2022-02-04 00:00:00',NULL,'570',444178.80,444178.80,'570','2022-02-04 19:48:55','614','2022-02-04 19:53:20',10,0),('1','167',257623,'AFTERNOON SHIFT  2','2022-02-04','2022-02-04 00:00:00',NULL,'570',1647645.45,1647645.45,'570','2022-02-04 21:53:30','614','2022-02-05 01:48:40',10,0),('1','167',257624,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'570',1616161.80,1616161.80,'570','2022-02-05 14:03:47','614','2022-02-05 15:28:07',10,0),('1','167',257625,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'570',3256019.65,3256019.65,'570','2022-02-05 22:23:14','614','2022-02-05 23:38:00',10,0),('1','167',257626,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'570',2821830.35,2821830.35,'570','2022-02-06 15:07:14','614','2022-02-06 15:38:55',10,0),('1','167',257627,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'570',3570751.70,3570751.70,'570','2022-02-06 21:56:50','614','2022-02-07 01:07:32',10,0),('1','167',257628,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'570',2835465.00,2835465.00,'570','2022-02-07 14:26:22','614','2022-02-07 14:56:10',10,0),('1','167',257629,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'570',4204914.85,4204914.85,'570','2022-02-07 21:40:54','614','2022-02-07 22:39:02',10,0),('1','167',257630,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'570',3143588.65,3143588.65,'570','2022-02-08 14:03:16','614','2022-02-08 14:34:20',10,0),('1','167',257631,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'570',5514609.40,5514609.40,'570','2022-02-08 19:35:50','614','2022-02-08 19:56:06',10,0),('1','167',257632,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'570',3685995.50,3685995.50,'570','2022-02-08 22:26:00','614','2022-02-08 22:46:02',10,0),('1','167',257633,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'570',2043067.95,2043067.95,'570','2022-02-09 14:02:20','614','2022-02-09 16:37:26',10,0),('1','167',257634,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'570',2105935.15,2105935.15,'570','2022-02-09 22:21:50','614','2022-02-09 23:39:55',10,0),('1','167',257635,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'570',2487662.10,2487662.10,'570','2022-02-10 14:37:02','614','2022-02-10 15:14:20',10,0),('1','167',257636,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'570',5458825.35,5458825.35,'570','2022-02-10 22:49:16','614','2022-02-10 23:37:09',10,0),('1','167',257637,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'570',1900329.20,1900329.20,'570','2022-02-11 13:35:01','614','2022-02-11 15:37:44',10,0),('1','167',257638,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'570',2599126.20,2599126.20,'570','2022-02-11 21:50:14','614','2022-02-11 22:21:27',10,0),('1','167',257639,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'570',2668311.80,2668311.80,'570','2022-02-12 13:43:40','614','2022-02-12 17:40:12',10,0),('1','167',257640,'AFTERNOON SHIFT ','2022-02-12','2022-02-12 00:00:00',NULL,'570',1727325.60,1727325.60,'570','2022-02-12 19:19:31','614','2022-02-12 19:50:11',10,0),('1','167',257641,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'570',3141121.25,3141121.25,'570','2022-02-12 23:17:22','614','2022-02-12 23:45:32',10,0),('1','167',257642,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'570',6310931.45,6310931.45,'570','2022-02-13 14:18:55','614','2022-02-13 15:14:19',10,0),('1','167',257643,'AFTERNOON SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'570',6489878.45,6489878.45,'570','2022-02-13 21:58:36','614','2022-02-13 22:09:57',10,0),('1','167',257644,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'570',5108199.55,5108199.55,'570','2022-02-14 13:58:16','614','2022-02-14 15:59:30',10,0),('1','167',257645,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'570',2588051.30,2588051.30,'570','2022-02-14 22:45:58','614','2022-02-14 23:17:45',10,0),('1','167',257646,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'570',2720216.50,2720216.50,'570','2022-02-15 19:31:35','614','2022-02-15 20:46:12',10,0),('1','167',257647,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'570',3552557.35,3552557.35,'570','2022-02-15 21:39:29','614','2022-02-15 22:45:47',10,0),('1','167',257648,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'570',4685535.50,4685535.50,'570','2022-02-16 16:40:12','614','2022-02-16 19:31:10',10,0),('1','167',257649,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'570',6459644.70,6459644.70,'570','2022-02-16 22:23:59','614','2022-02-16 22:30:22',10,0),('1','167',257650,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'570',1575484.00,1575484.00,'570','2022-02-17 11:45:33','614','2022-02-17 11:58:27',10,0),('1','167',257651,'MORNING SHIFT 2','2022-02-17','2022-02-17 00:00:00',NULL,'570',3594911.10,3594911.10,'570','2022-02-17 16:22:07','614','2022-02-17 17:05:35',10,0),('1','167',257652,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'570',5928628.95,5928628.95,'570','2022-02-17 22:05:38','614','2022-02-17 23:09:01',10,0),('1','167',257653,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'570',5944909.95,5944909.95,'570','2022-02-18 20:20:16','614','2022-02-18 23:15:20',10,0),('1','167',257654,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'570',6454941.90,6454941.90,'570','2022-02-19 17:40:28','614','2022-02-19 17:45:58',10,0),('1','167',257655,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'570',3566927.40,3566927.40,'570','2022-02-19 21:08:54','614','2022-02-19 22:21:08',10,0),('1','167',257656,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'570',1569630.15,1569630.15,'570','2022-02-19 23:32:51','614','2022-02-20 00:13:04',10,0),('1','167',257657,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'570',2293428.00,2293428.00,'570','2022-02-20 14:12:13','614','2022-02-20 17:49:39',10,0),('1','167',257658,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'570',2593035.15,2593035.15,'570','2022-02-20 21:28:05','614','2022-02-20 23:50:52',10,0),('1','167',257659,'MORNING SHIFT','2022-02-22','2022-02-22 14:28:43','2022-02-23 14:28:43','570',3149413.80,3149413.80,'570','2022-02-22 15:12:25','614','2022-02-22 20:49:18',10,0),('1','167',257660,'AFTERNOON SHIFT','2022-02-22','2022-02-22 22:29:01','2022-02-23 22:29:01','570',2334870.90,2334870.90,'570','2022-02-22 22:34:25','614','2022-02-22 22:44:01',10,0),('1','167',257661,'MORNING SHIFT','2022-02-23','2022-02-23 14:31:46','2022-02-24 14:31:46','570',1440784.30,1440784.30,'570','2022-02-23 14:35:32','614','2022-02-23 16:38:35',10,0),('1','167',257662,'AFTERNOON SHIFT','2022-02-23','2022-02-23 21:51:51','2022-02-24 21:51:51','570',2557756.30,2557756.30,'570','2022-02-23 21:54:05','614','2022-02-24 08:28:30',10,0),('1','167',257663,'MORNING SHIFT','2022-02-24','2022-02-24 13:30:31','2022-02-25 13:30:31','570',1872613.50,1872613.50,'570','2022-02-24 13:32:42','614','2022-02-24 15:52:52',10,0),('1','167',257664,'AFTERNOON SHIFT','2022-02-24','2022-02-24 21:19:37','2022-02-25 21:19:37','570',5714372.00,5714372.00,'570','2022-02-24 22:15:03','614','2022-02-24 23:37:36',10,0),('1','167',257665,'MORNING SHIFT','2022-02-25','2022-02-25 14:53:10','2022-02-26 14:53:10','570',4865467.20,4865467.20,'570','2022-02-25 15:22:04','614','2022-02-25 18:31:24',10,0),('1','167',257666,'AFTERNOON SHIFT','2022-02-25','2022-02-25 18:33:09','2022-02-26 18:33:09','570',2220785.50,2220785.50,'570','2022-02-25 18:38:00','614','2022-02-25 21:25:17',10,0),('1','167',257667,'AFTERNOON SHIFT 2','2022-02-25','2022-02-25 21:33:05','2022-02-26 21:33:05','570',4987651.65,4987651.65,'570','2022-02-25 21:47:29','614','2022-02-26 11:08:50',10,0),('1','167',257668,'MORNING SHIFT','2022-02-26','2022-02-26 14:06:26','2022-02-27 14:06:26','570',3127418.30,3127418.30,'570','2022-02-26 14:09:50','614','2022-02-26 15:49:33',10,0),('1','167',257669,'AFTERNOON SHIFT','2022-02-26','2022-02-26 20:30:59','2022-02-27 20:30:59','570',2936719.75,2936719.75,'570','2022-02-26 20:36:10','614','2022-02-26 20:41:32',10,0),('1','167',257670,'MORNING SHIFT','2022-02-27','2022-02-27 14:29:42','2022-02-28 14:29:42','570',1198824.25,1198824.25,'570','2022-02-27 14:33:15','614','2022-02-27 15:17:07',10,0),('1','167',257671,'AFTERNOON SHIFT','2022-02-27','2022-02-27 20:42:48','2022-02-28 20:42:48','570',2915613.80,2915613.80,'570','2022-02-27 21:17:18','614','2022-02-27 23:01:41',10,0),('1','167',257672,'MORNING SHIFT','2022-02-28','2022-02-28 14:58:17','2022-03-01 14:58:17','570',2731084.15,2731084.15,'570','2022-02-28 15:02:30','614','2022-02-28 16:02:47',10,0),('1','167',257673,'AFTERNOON SHIFT','2022-02-28','2022-02-28 21:36:48','2022-03-01 21:36:48','570',5079778.15,5079778.15,'570','2022-02-28 21:47:48','614','2022-02-28 22:11:19',10,0),('1','167',257674,'MORNING SHIFT','2022-03-01','2022-03-01 10:18:44','2022-03-02 10:18:44','570',454254.85,454254.85,'570','2022-03-01 10:21:35','614','2022-03-01 10:58:41',10,0),('1','167',257675,'MORNING SHIFT 2','2022-03-01','2022-03-01 15:04:24','2022-03-02 15:04:24','570',5308975.35,5308975.35,'570','2022-03-01 15:11:16','614','2022-03-01 15:56:21',10,0),('1','167',257676,'AFTERNOON SHIFT ','2022-03-01','2022-03-01 21:43:01','2022-03-02 21:43:01','570',6536501.10,6536501.10,'570','2022-03-01 22:08:28','614','2022-03-01 23:55:47',10,0),('1','167',257677,'MORNING SHIFT','2022-03-02','2022-03-02 12:00:14','2022-03-03 12:00:14','570',698678.40,698678.40,'570','2022-03-02 12:02:58','614','2022-03-02 12:11:18',10,0),('1','167',257678,'MORNING SHIFT 2','2022-03-02','2022-03-02 14:12:17','2022-03-03 14:12:17','570',4131953.05,4131953.05,'570','2022-03-02 14:23:04','614','2022-03-02 17:14:47',10,0),('1','167',257679,'AFTERNOON SHIFT','2022-03-02','2022-03-02 20:00:35','2022-03-03 20:00:35','570',3073496.40,3073496.40,'570','2022-03-02 21:22:17','614','2022-03-02 23:24:51',10,0),('1','167',257680,'MORNING SHIFT','2022-03-03','2022-03-03 13:31:14','2022-03-04 13:31:14','570',517125.95,517125.95,'570','2022-03-03 13:35:40','614','2022-03-03 14:56:18',10,0),('1','167',257681,'AFTERNOON SHIFT ','2022-03-03','2022-03-03 20:31:00','2022-03-04 20:31:00','570',1884220.00,1884220.00,'570','2022-03-03 20:34:36','614','2022-03-04 13:09:11',10,0),('1','167',257682,'MORNING SHIFT','2022-03-04','2022-03-04 13:41:58','2022-03-05 13:41:58','570',2033551.70,2033551.70,'570','2022-03-04 16:12:17','614','2022-03-04 17:22:47',10,0),('1','167',257683,'AFTERNOON SHIFT','2022-03-04','2022-03-04 18:02:26','2022-03-05 18:02:26','570',5141368.10,5141368.10,'570','2022-03-04 18:14:55','614','2022-03-04 20:46:06',10,0),('1','167',257684,'AFTERNOON SHIFT  2','2022-03-04','2022-03-04 21:19:56','2022-03-05 21:19:56','570',3907896.35,3907896.35,'570','2022-03-04 21:25:12','614','2022-03-05 11:58:47',10,0),('1','167',257685,'MORNING SHIFT','2022-03-05','2022-03-05 13:52:43','2022-03-06 13:52:43','570',1144061.40,1144061.40,'570','2022-03-05 13:54:34','614','2022-03-05 15:40:14',10,0),('1','167',257686,'AFTERNOON SHIFT ','2022-03-05','2022-03-05 19:44:19','2022-03-06 19:44:19','570',1482915.00,1482915.00,'570','2022-03-05 22:55:18','614','2022-03-05 22:57:10',10,0),('1','167',257687,'MORNING SHIFT ','2022-03-07','2022-03-07 14:41:46','2022-03-08 14:41:46','570',2912035.00,2912035.00,'570','2022-03-07 15:04:21','614','2022-03-07 15:28:01',10,0),('1','167',257688,'AFTERNOON SHIFT','2022-03-07','2022-03-07 19:33:45','2022-03-08 19:33:45','570',1984156.35,1984156.35,'570','2022-03-07 20:04:20','614','2022-03-07 22:01:27',10,0),('1','167',257689,'MORNING SHIFT','2022-03-08','2022-03-08 13:54:54','2022-03-09 13:54:54','570',2196268.80,2196268.80,'570','2022-03-08 14:00:00','614','2022-03-08 15:21:54',10,0),('1','167',257690,'AFTERNOON SHIFT','2022-03-08','2022-03-08 20:21:03','2022-03-09 20:21:03','570',1663003.65,1663003.65,'570','2022-03-08 20:24:15','614','2022-03-08 23:41:06',10,0),('1','167',257691,'MORNING SHIFT','2022-03-10','2022-03-10 14:05:11','2022-03-11 14:05:11','570',122685.75,122685.75,'570','2022-03-10 14:50:00','614','2022-03-10 14:57:07',10,0),('1','167',257692,'MORNING SHIFT','2022-03-13','2022-03-13 14:02:52','2022-03-14 14:02:52','570',621664.65,621664.65,'570','2022-03-13 14:07:09','614','2022-03-13 15:14:10',10,0),('1','167',257693,'AFTERNOON SHIFT','2022-03-13','2022-03-13 18:40:48','2022-03-14 18:40:48','570',1893579.60,1893579.60,'570','2022-03-13 18:49:50','614','2022-03-13 21:21:42',10,0),('1','167',257694,'MORNING SHIFT','2022-03-14','2022-03-14 13:10:02','2022-03-15 13:10:02','570',1448535.00,1448535.00,'570','2022-03-14 13:13:42','614','2022-03-14 19:38:46',10,0),('1','167',257695,'AFTERNOON SHIFT','2022-03-14','2022-03-14 20:47:08','2022-03-15 20:47:08','570',1793894.85,1793894.85,'570','2022-03-14 20:49:58','614','2022-03-14 22:27:22',10,0),('1','167',257696,'MORNING SHIFT','2022-03-15','2022-03-15 12:56:58','2022-03-16 12:56:58','570',871051.50,871051.50,'570','2022-03-15 13:10:34','614','2022-03-15 17:06:34',10,0),('1','167',257697,'AFTERNOON SHIFT','2022-03-15','2022-03-15 20:15:53','2022-03-16 20:15:53','570',783984.30,783984.30,'570','2022-03-15 20:18:11','614','2022-03-15 23:35:18',10,0),('1','167',257698,'AFTERNOON SHIFT','2022-03-16','2022-03-16 18:57:14','2022-03-17 18:57:14','570',36276.90,36276.90,'570','2022-03-16 19:03:52','614','2022-03-16 21:47:16',10,0),('1','167',257699,'AFTERNOON SHIFT I\'ll III','2022-03-17','2022-03-17 20:05:47','2022-03-18 20:05:47','570',292500.00,292500.00,'570','2022-03-17 20:10:22','614','2022-03-17 22:44:46',10,0),('1','167',257700,'AFTERNOON SHIFT','2022-03-18','2022-03-18 17:10:26','2022-03-19 17:10:26','570',6063800.75,6063800.75,'570','2022-03-18 21:24:45','614','2022-03-18 23:15:15',10,0),('1','167',257701,'MORNING SHIFT','2022-03-19','2022-03-19 08:25:29','2022-03-20 08:25:29','570',239304.00,239304.00,'570','2022-03-19 08:26:39','614','2022-03-19 08:43:38',10,0),('1','167',257702,'MORNING SHIFT 2','2022-03-19','2022-03-19 14:26:40','2022-03-20 14:26:40','570',4675268.90,4675268.90,'570','2022-03-19 14:59:53','614','2022-03-19 15:07:48',10,0),('1','167',257703,'AFTERNOON SHIFT','2022-03-19','2022-03-19 20:35:14','2022-03-20 20:35:14','570',5132956.55,5132956.55,'570','2022-03-19 20:40:34','614','2022-03-19 22:17:40',10,0),('1','167',257704,'MORNING SHIFT','2022-03-20','2022-03-20 13:33:00','2022-03-21 13:33:00','570',6779759.60,6779759.60,'570','2022-03-20 14:26:26','614','2022-03-20 14:46:24',10,0),('1','167',257705,'AFTERNOON SHIFT','2022-03-20','2022-03-20 21:01:35','2022-03-21 21:01:35','570',7168486.45,7168486.45,'570','2022-03-20 21:35:14','614','2022-03-20 23:35:44',10,0),('1','167',257706,'MORNING SHIFT','2022-03-21','2022-03-21 13:58:37','2022-03-22 13:58:37','570',4472314.60,4472314.60,'570','2022-03-21 14:32:09','614','2022-03-21 14:59:47',10,0),('1','167',257707,'AFTERNOON SHIFT','2022-03-21','2022-03-21 19:31:15','2022-03-22 19:31:15','570',5396503.35,5396503.35,'570','2022-03-21 20:32:21','614','2022-03-22 06:12:56',10,0),('1','167',257708,'MORNING SHIFT','2022-03-22','2022-03-22 13:56:26','2022-03-23 13:56:26','570',5618106.10,5618106.10,'570','2022-03-22 14:15:56','614','2022-03-22 15:18:20',10,0),('1','167',257709,'AFTERNOON SHIFT','2022-03-22','2022-03-22 19:40:57','2022-03-23 19:40:57','570',4660715.25,4660715.25,'570','2022-03-22 20:57:09','614','2022-03-22 20:59:57',10,0),('1','167',257710,'MORNING SHIFT','2022-03-23','2022-03-23 14:11:06','2022-03-24 14:11:06','570',1336020.20,1336020.20,'570','2022-03-23 14:12:42','614','2022-03-23 18:38:48',10,0),('1','167',257711,'AFTERNOON SHIFT','2022-03-23','2022-03-23 19:51:58','2022-03-24 19:51:58','570',996618.30,996618.30,'570','2022-03-23 19:54:05','614','2022-03-23 22:00:59',10,0),('1','167',257712,'MORNING SHIFT','2022-03-24','2022-03-24 14:28:46','2022-03-25 14:28:46','570',1702805.00,1702805.00,'570','2022-03-24 14:32:21','614','2022-03-24 15:01:18',10,0),('1','167',257713,'AFTERNOON SHIFT','2022-03-24','2022-03-24 20:12:02','2022-03-25 20:12:02','570',1854720.80,1854720.80,'570','2022-03-24 20:13:47','614','2022-03-25 07:24:39',10,0),('1','167',257714,'MORNING SHIFT','2022-03-25','2022-03-25 13:13:34','2022-03-26 13:13:34','570',2011755.40,2011755.40,'570','2022-03-25 13:20:06','614','2022-03-25 17:15:14',10,0),('1','167',257715,'AFTERNOON SHIFT','2022-03-25','2022-03-25 21:08:43','2022-03-26 21:08:43','570',672999.95,672999.95,'570','2022-03-25 21:11:37','614','2022-03-25 23:43:25',10,0),('1','167',257716,'MORNING SHIFT','2022-03-26','2022-03-26 14:28:38','2022-03-27 14:28:38','570',1527352.10,1527352.10,'570','2022-03-26 14:30:48','614','2022-03-26 15:01:32',10,0),('1','167',257717,'AFTERNOON SHIFT','2022-03-26','2022-03-26 21:03:20','2022-03-27 21:03:20','570',3351621.40,3351621.40,'570','2022-03-26 21:05:40','614','2022-03-26 23:36:03',10,0),('1','167',257718,'MORNING SHIFT','2022-03-27','2022-03-27 13:53:08','2022-03-28 13:53:08','570',3223798.30,3223798.30,'570','2022-03-27 14:19:44','614','2022-03-27 16:09:23',10,0),('1','167',257719,'AFTERNOON SHIFT','2022-03-27','2022-03-27 20:47:48','2022-03-28 20:47:48','570',3945305.55,3945305.55,'570','2022-03-27 20:56:54','614','2022-03-27 23:04:15',10,0),('1','167',257720,'MORNING SHIFT','2022-03-28','2022-03-28 14:03:14','2022-03-29 14:03:14','570',4203063.45,4203063.45,'570','2022-03-28 14:40:37','614','2022-03-28 15:38:00',10,0),('1','167',257721,'AFTERNOON SHIFT','2022-03-28','2022-03-28 20:07:19','2022-03-29 20:07:19','570',4082312.85,4082312.85,'570','2022-03-28 20:12:07','614','2022-03-28 23:38:29',10,0),('1','167',257722,'MORNING SHIFT','2022-03-29','2022-03-29 13:30:21','2022-03-30 13:30:21','570',1759902.40,1759902.40,'570','2022-03-29 13:33:03','614','2022-03-29 17:15:38',10,0),('1','167',257723,'AFTERNOON SHIFT','2022-03-29','2022-03-29 20:37:44','2022-03-30 20:37:44','570',2313268.80,2313268.80,'570','2022-03-29 20:39:29','614','2022-03-29 21:47:54',10,0),('1','167',257724,'MORNING SHIFT','2022-03-30','2022-03-30 15:25:14','2022-03-31 15:25:14','570',1605567.90,1605567.90,'570','2022-03-30 15:26:35','614','2022-03-30 21:25:08',10,0),('1','167',257725,'AFTERNOON SHIFT','2022-03-30','2022-03-30 21:29:23','2022-03-31 21:29:23','570',4740191.35,4740191.35,'570','2022-03-30 21:59:49','614','2022-03-31 13:21:36',10,0),('1','167',257726,'MORNING SHIFT','2022-03-31','2022-03-31 14:19:58','2022-04-01 14:19:58','570',5313366.20,5313366.20,'570','2022-03-31 14:52:27','614','2022-03-31 15:11:50',10,0),('1','167',257727,'AFTERNOON SHIFT','2022-03-31','2022-03-31 19:25:48','2022-04-01 19:25:48','570',3517400.55,3517400.55,'570','2022-03-31 19:33:50','614','2022-03-31 23:54:35',10,0),('1','167',257728,'MORNING SHIFT','2022-04-01','2022-04-01 14:59:55','2022-04-02 14:59:55','570',3615231.85,3615231.85,'570','2022-04-01 17:36:06','614','2022-04-01 18:23:40',10,0),('1','167',257729,'AFTERNOON SHIFT ','2022-04-01','2022-04-01 20:19:07','2022-04-02 20:19:07','570',3242326.00,3242326.00,'570','2022-04-01 20:25:45','614','2022-04-01 22:37:47',10,0),('1','167',257730,'MORNING SHIFT','2022-04-02','2022-04-02 13:46:55','2022-04-03 13:46:55','570',5513151.65,5513151.65,'570','2022-04-02 16:30:41','614','2022-04-02 20:21:58',10,0),('1','167',257731,'AFTERNOON SHIFT','2022-04-02','2022-04-02 20:28:31','2022-04-03 20:28:31','570',4105136.25,4105136.25,'570','2022-04-02 20:43:39','614','2022-04-02 21:16:58',10,0),('1','167',257732,'MORNING SHIFT','2022-04-03','2022-04-03 14:00:42','2022-04-04 14:00:42','570',2429617.95,2429617.95,'570','2022-04-03 15:08:45','614','2022-04-03 16:30:01',10,0),('1','167',257733,'AFTERNOON SHIFT','2022-04-03','2022-04-03 20:35:24','2022-04-04 20:35:24','570',1814500.70,1814500.70,'570','2022-04-03 20:37:37','614','2022-04-03 23:21:00',10,0),('1','167',257734,'MORNING SHIFT','2022-04-04','2022-04-04 13:17:29','2022-04-05 13:17:29','570',1929981.90,1929981.90,'570','2022-04-04 13:22:45','614','2022-04-04 16:45:17',10,0),('1','167',257735,'AFTERNOON SHIFT','2022-04-04','2022-04-04 20:15:36','2022-04-05 20:15:36','570',859811.00,859811.00,'570','2022-04-04 20:17:26','614','2022-04-05 13:52:50',10,0),('1','167',257736,'MORNING SHIFT','2022-04-05','2022-04-05 14:04:24','2022-04-06 14:04:24','570',1291277.60,1291277.60,'570','2022-04-05 14:05:36','614','2022-04-05 15:12:40',10,0),('1','167',257737,'AFTERNOON SHIFT','2022-04-05','2022-04-05 21:25:37','2022-04-06 21:25:37','570',5369334.20,5369334.20,'570','2022-04-05 21:33:10','614','2022-04-05 23:50:27',10,0),('1','167',257738,'MORNING SHIFT','2022-04-06','2022-04-06 13:53:16','2022-04-07 13:53:16','570',4023239.85,4023239.85,'570','2022-04-06 14:57:24','614','2022-04-06 15:13:08',10,0),('1','167',257739,'AFTERNOON SHIFT','2022-04-06','2022-04-06 20:14:03','2022-04-07 20:14:03','570',6923199.10,6923199.10,'570','2022-04-06 20:56:21','614','2022-04-06 23:30:08',10,0),('1','167',257740,'MORNING SHIFT','2022-04-07','2022-04-07 14:13:58','2022-04-08 14:13:58','570',1467663.30,1467663.30,'570','2022-04-07 14:19:05','614','2022-04-07 17:49:19',10,0),('1','167',257741,'AFTERNOON SHIFT','2022-04-07','2022-04-07 19:56:23','2022-04-08 19:56:23','570',1096398.45,1096398.45,'570','2022-04-07 19:59:47','614','2022-04-08 10:15:35',10,0),('1','167',257742,'MORNING SHIFT','2022-04-08','2022-04-08 13:12:52','2022-04-09 13:12:52','570',1145304.70,1145304.70,'570','2022-04-08 13:16:48','614','2022-04-08 17:14:37',10,0),('1','167',257743,'AFTERNOON SHIFT','2022-04-08','2022-04-08 20:23:52','2022-04-09 20:23:52','570',571027.60,571027.60,'570','2022-04-08 20:31:18','614','2022-04-08 23:49:09',10,0),('1','167',257744,'MORNING SHIFT','2022-04-09','2022-04-09 13:58:12','2022-04-10 13:58:12','570',1029327.70,1029327.70,'570','2022-04-09 13:59:54','614','2022-04-09 15:16:21',10,0),('1','167',257745,'AFTERNOON SHIFT','2022-04-09','2022-04-09 19:37:58','2022-04-10 19:37:58','570',936197.70,936197.70,'570','2022-04-09 19:39:29','614','2022-04-09 20:32:00',10,0),('1','167',257746,'MORNING SHIFT','2022-04-10','2022-04-10 13:27:30','2022-04-11 13:27:30','570',848427.70,848427.70,'570','2022-04-10 13:37:27','614','2022-04-10 16:27:42',10,0),('1','167',257747,'AFTERNOON SHIFT','2022-04-10','2022-04-10 21:04:33','2022-04-11 21:04:33','570',649792.80,649792.80,'570','2022-04-10 21:06:06','614','2022-04-10 22:26:50',10,0),('1','167',257748,'MORNING SHIFT','2022-04-11','2022-04-11 13:41:22','2022-04-12 13:41:22','570',658315.20,658315.20,'570','2022-04-11 13:42:32','614','2022-04-11 15:12:44',10,0),('1','167',257749,'AFTERNOON SHIFT','2022-04-11','2022-04-11 20:18:38','2022-04-12 20:18:38','570',786178.00,786178.00,'570','2022-04-11 20:20:57','614','2022-04-11 21:49:14',10,0),('1','167',257750,'MORNING SHIFT','2022-04-12','2022-04-12 13:19:02','2022-04-13 13:19:02','570',909297.20,909297.20,'570','2022-04-12 13:22:09','614','2022-04-12 16:40:35',10,0),('1','167',257751,'AFTERNOON SHIFT','2022-04-12','2022-04-12 21:16:31','2022-04-13 21:16:31','570',1027740.80,1027740.80,'570','2022-04-12 22:14:14','614','2022-04-13 12:51:04',10,0),('1','167',257752,'MORNING SHIFT','2022-04-13','2022-04-13 13:23:09','2022-04-14 13:23:09','570',489763.30,489763.30,'570','2022-04-13 13:24:52','614','2022-04-13 15:30:35',10,0),('1','167',257753,'AFTERNOON SHIFT','2022-04-13','2022-04-13 21:07:50','2022-04-14 21:07:50','570',1882277.90,1882277.90,'570','2022-04-13 21:09:30','614','2022-04-13 21:44:41',10,0),('1','167',257754,'MORNING SHIFT','2022-04-14','2022-04-14 14:16:21','2022-04-15 14:16:21','570',3705075.60,3705075.60,'570','2022-04-14 14:50:37','614','2022-04-14 14:55:15',10,0),('1','167',257755,'AFTERNOON SHIFT','2022-04-14','2022-04-14 20:47:39','2022-04-15 20:47:39','570',4862001.40,4862001.40,'570','2022-04-14 21:06:47','614','2022-04-14 21:13:35',10,0),('1','167',257756,'MORNING SHIFT','2022-04-15','2022-04-15 13:49:07','2022-04-16 13:49:07','570',4872542.05,4872542.05,'570','2022-04-15 14:52:49','614','2022-04-15 14:55:21',10,0),('1','167',257757,'AFTERNOON SHIFT','2022-04-15','2022-04-15 17:26:23','2022-04-16 17:26:23','570',1832041.30,1832041.30,'570','2022-04-15 21:09:42','614','2022-04-15 22:06:18',10,0),('1','167',257758,'MORNING SHIFT','2022-04-16','2022-04-16 08:11:09','2022-04-17 08:11:09','570',2944875.85,2944875.85,'570','2022-04-16 14:21:52','614','2022-04-16 15:02:08',10,0),('1','167',257759,'AFTERNOON SHIFT','2022-04-16','2022-04-16 21:00:04','2022-04-17 21:00:04','570',514379.05,514379.05,'570','2022-04-16 21:04:23','614','2022-04-17 05:42:46',10,0),('1','167',257760,'MORNING SHIFT','2022-04-17','2022-04-17 12:09:08','2022-04-18 12:09:08','570',1661191.75,1661191.75,'570','2022-04-17 14:09:43','614','2022-04-17 17:07:08',10,0),('1','167',257761,'AFTERNOON SHIFT','2022-04-17','2022-04-17 20:06:21','2022-04-18 20:06:21','570',2971005.50,2971005.50,'570','2022-04-17 20:25:55','614','2022-04-17 21:42:05',10,0),('1','167',257762,'MORNING SHIFT','2022-04-18','2022-04-18 09:41:27','2022-04-19 09:41:27','570',3081329.80,3081329.80,'570','2022-04-18 15:00:19','614','2022-04-18 15:36:12',10,0),('1','167',257763,'AFTERNOON SHIFT','2022-04-18','2022-04-18 21:08:54','2022-04-19 21:08:54','570',3001031.90,3001031.90,'570','2022-04-18 21:12:00','614','2022-04-18 22:03:54',10,0),('1','167',257764,'MORNING SHIFT','2022-04-19','2022-04-19 13:20:29','2022-04-20 13:20:29','570',3332776.70,3332776.70,'570','2022-04-19 14:51:44','614','2022-04-19 15:20:38',10,0),('1','167',257765,'AFTERNOON SHIFT','2022-04-19','2022-04-19 20:16:33','2022-04-20 20:16:33','570',2074976.60,2074976.60,'570','2022-04-19 20:17:44','614','2022-04-19 22:02:12',10,0),('1','167',257766,'MORNING SHIFT','2022-04-20','2022-04-20 08:06:06','2022-04-21 08:06:06','570',1367825.10,1367825.10,'570','2022-04-20 13:04:46','614','2022-04-20 14:35:48',10,0),('1','167',257767,'AFTERNOON SHIFT','2022-04-20','2022-04-20 20:35:10','2022-04-21 20:35:10','570',835887.00,835887.00,'570','2022-04-20 20:36:24','614','2022-04-20 22:10:30',10,0),('1','167',257768,'MORNING SHIFT','2022-04-21','2022-04-21 12:04:42','2022-04-22 12:04:42','570',1167699.00,1167699.00,'570','2022-04-21 13:25:10','614','2022-04-21 16:51:45',10,0),('1','167',257769,'AFTERNOON SHIFT','2022-04-21','2022-04-21 20:28:48','2022-04-22 20:28:48','570',1571986.00,1571986.00,'570','2022-04-21 20:30:04','614','2022-04-21 20:57:29',10,0),('1','167',257770,'MORNING SHIFT','2022-04-22','2022-04-22 09:39:05','2022-04-23 09:39:05','570',2205223.30,2205223.30,'570','2022-04-22 14:40:13','614','2022-04-22 15:09:30',10,0),('1','167',257771,'AFTERNOON SHIFT','2022-04-22','2022-04-22 20:43:17','2022-04-23 20:43:17','570',5628541.00,5628541.00,'570','2022-04-22 21:26:54','614','2022-04-22 22:46:02',10,0),('1','167',257772,'MORNING SHIFT','2022-04-23','2022-04-23 14:18:47','2022-04-24 14:18:47','570',3539123.00,3539123.00,'570','2022-04-23 14:29:15','614','2022-04-23 14:56:08',10,0),('1','167',257773,'AFTERNOON SHIFT','2022-04-23','2022-04-23 21:42:44','2022-04-24 21:42:44','570',6126448.80,6126448.80,'570','2022-04-23 21:54:39','614','2022-04-23 23:33:52',10,0),('1','167',257774,'MORNING SHIFT','2022-04-24','2022-04-24 08:12:39','2022-04-25 08:12:39','570',4271395.40,4271395.40,'570','2022-04-24 14:04:54','614','2022-04-24 15:30:02',10,0),('1','167',257775,'AFTERNOON SHIFT','2022-04-24','2022-04-24 20:43:02','2022-04-25 20:43:02','570',5034210.45,5034210.45,'570','2022-04-24 20:51:33','614','2022-04-24 23:18:51',10,0),('1','167',257776,'MORNING SHIFT','2022-04-25','2022-04-25 10:29:51','2022-04-26 10:29:51','570',4476072.35,4476072.35,'570','2022-04-25 13:59:08','614','2022-04-25 16:14:12',10,0),('1','167',257777,'AFTERNOON SHIFT','2022-04-25','2022-04-25 21:53:00','2022-04-26 21:53:00','570',1674863.10,1674863.10,'570','2022-04-25 22:15:24','614','2022-04-25 23:46:54',10,0),('1','167',257778,'MORNING SHIFT','2022-04-26','2022-04-26 11:08:19','2022-04-27 11:08:19','570',1745433.60,1745433.60,'570','2022-04-26 15:43:27','614','2022-04-26 21:13:20',10,0),('1','167',257779,'AFTERNOON SHIFT','2022-04-26','2022-04-26 21:34:56','2022-04-27 21:34:56','570',2975038.45,2975038.45,'570','2022-04-26 22:02:28','614','2022-04-26 22:48:48',10,0),('1','167',257780,'MORNING SHIFT','2022-04-27','2022-04-27 11:57:08','2022-04-28 11:57:08','570',1971132.90,1971132.90,'570','2022-04-27 13:22:35','614','2022-04-27 16:09:38',10,0),('1','167',257781,'AFTERNOON SHIFT','2022-04-27','2022-04-27 16:32:29','2022-04-28 16:32:29','570',2488353.45,2488353.45,'570','2022-04-27 21:54:17','614','2022-04-28 10:37:04',10,0),('1','167',257782,'MORNING SHIFT','2022-04-28','2022-04-28 13:45:59','2022-04-29 13:45:59','570',4131204.45,4131204.45,'570','2022-04-28 14:57:33','614','2022-04-28 15:25:06',10,0),('1','167',257783,'AFTERNOON SHIFT','2022-04-28','2022-04-28 18:49:39','2022-04-29 18:49:39','570',4249175.70,4249175.70,'570','2022-04-28 21:49:51','614','2022-04-28 22:10:15',10,0),('1','167',257784,'MORNING SHIFT','2022-04-29','2022-04-29 14:03:27','2022-04-30 14:03:27','570',3666083.85,3666083.85,'570','2022-04-29 14:10:16','614','2022-04-29 14:58:10',10,0),('1','167',257785,'AFTERNOON SHIFT','2022-04-29','2022-04-29 21:23:52','2022-04-30 21:23:52','570',7300148.25,7300148.25,'570','2022-04-29 22:05:25','614','2022-04-29 22:15:33',10,0),('1','167',257786,'MORNING SHIFT','2022-04-30','2022-04-30 07:37:12','2022-05-01 07:37:12','570',4970152.85,4970152.85,'570','2022-04-30 14:57:02','614','2022-04-30 18:20:17',10,0),('1','167',257787,'AFTERNOON SHIFT','2022-04-30','2022-04-30 21:12:45','2022-05-01 21:12:45','570',4395424.20,4395424.20,'570','2022-04-30 21:38:56','614','2022-04-30 23:37:32',10,0),('1','167',257788,'MORNING SHIFT','2022-05-01','2022-05-01 13:58:14','2022-05-02 13:58:14','570',3129059.30,3129059.30,'570','2022-05-01 14:33:05','614','2022-05-01 15:08:02',10,0),('1','167',257789,'AFTERNOON SHIFT','2022-05-01','2022-05-01 21:05:35','2022-05-02 21:05:35','570',3398877.80,3398877.80,'570','2022-05-01 21:12:58','614','2022-05-02 00:33:12',10,0),('1','167',257790,'MORNING SHIFT','2022-05-02','2022-05-02 11:36:13','2022-05-03 11:36:13','570',2613631.50,2613631.50,'570','2022-05-02 15:03:06','614','2022-05-02 16:45:30',10,0),('1','167',257791,'AFTERNOON SHIFT','2022-05-02','2022-05-02 19:28:32','2022-05-03 19:28:32','570',1512473.50,1512473.50,'570','2022-05-02 19:34:49','614','2022-05-03 10:13:31',10,0),('1','167',257792,'MORNING SHIFT','2022-05-03','2022-05-03 12:14:13','2022-05-04 12:14:13','570',1026824.50,1026824.50,'570','2022-05-03 13:15:54','614','2022-05-03 15:30:23',10,0),('1','167',257793,'AFTERNOON SHIFT','2022-05-03','2022-05-03 19:57:59','2022-05-04 19:57:59','570',478848.50,478848.50,'570','2022-05-03 19:59:34','614','2022-05-03 23:45:52',10,0),('1','167',257794,'MORNING SHIFT','2022-05-04','2022-05-04 08:57:53','2022-05-05 08:57:53','570',1057517.50,1057517.50,'570','2022-05-04 13:12:19','614','2022-05-04 15:48:54',10,0),('1','167',257795,'AFTERNOON SHIFT','2022-05-04','2022-05-04 20:18:11','2022-05-05 20:18:11','570',1274598.00,1274598.00,'570','2022-05-04 20:19:57','614','2022-05-04 22:43:21',10,0),('1','167',257796,'MORNING SHIFT','2022-05-05','2022-05-05 12:16:48','2022-05-06 12:16:48','570',984737.00,984737.00,'570','2022-05-05 13:11:58','614','2022-05-05 19:17:14',10,0),('1','167',257797,'AFTERNOON SHIFT','2022-05-05','2022-05-05 21:16:26','2022-05-06 21:16:26','570',4436937.00,4436937.00,'570','2022-05-05 21:27:42','614','2022-05-06 01:01:49',10,0),('1','167',257798,'MORNING SHIFT','2022-05-06','2022-05-06 11:21:42','2022-05-07 11:21:42','570',3738193.05,3738193.05,'570','2022-05-06 15:17:54','614','2022-05-06 20:46:34',10,0),('1','167',257799,'AFTERNOON SHIFT','2022-05-06','2022-05-06 21:30:31','2022-05-07 21:30:31','570',4892063.45,4892063.45,'570','2022-05-06 21:45:30','614','2022-05-06 23:23:29',10,0),('1','167',257800,'MORNING SHIFT','2022-05-07','2022-05-07 11:47:13','2022-05-08 11:47:13','570',3895073.80,3895073.80,'570','2022-05-07 14:13:22','614','2022-05-07 18:09:40',10,0),('1','167',257801,'AFTERNOON SHIFT','2022-05-07','2022-05-07 20:43:20','2022-05-08 20:43:20','570',3754824.45,3754824.45,'570','2022-05-07 21:09:15','614','2022-05-07 23:28:29',10,0),('1','167',257802,'MORNING SHIFT','2022-05-08','2022-05-08 12:06:16','2022-05-09 12:06:16','570',3180542.90,3180542.90,'570','2022-05-08 14:07:06','614','2022-05-08 15:58:27',10,0),('1','167',257803,'AFTERNOON SHIFT','2022-05-08','2022-05-08 18:43:32','2022-05-09 18:43:32','570',5308482.90,5308482.90,'570','2022-05-08 22:45:48','614','2022-05-08 23:24:27',10,0),('1','167',257804,'MORNING SHIFT','2022-05-09','2022-05-09 10:32:03','2022-05-10 10:32:03','570',3355302.15,3355302.15,'570','2022-05-09 14:12:21','614','2022-05-09 14:20:59',10,0),('1','167',257805,'AFTERNOON SHIFT','2022-05-09','2022-05-09 21:56:03','2022-05-10 21:56:03','570',5298154.60,5298154.60,'570','2022-05-09 22:24:12','614','2022-05-09 23:34:13',10,0),('1','167',257806,'MORNING SHIFT','2022-05-10','2022-05-10 08:37:29','2022-05-11 08:37:29','570',4373030.50,4373030.50,'570','2022-05-10 13:59:49','614','2022-05-10 15:56:45',10,0),('1','167',257807,'AFTERNOON SHIFT','2022-05-10','2022-05-10 19:51:48','2022-05-11 19:51:48','570',311356.50,311356.50,'570','2022-05-10 19:55:54','614','2022-05-10 21:29:06',10,0),('1','167',257808,'AFTERNOON SHIFT 2','2022-05-10','2022-05-10 22:03:14','2022-05-11 22:03:14','570',3070082.40,3070082.40,'570','2022-05-10 22:12:09','614','2022-05-10 22:37:21',10,0),('1','167',257809,'MORNING SHIFT','2022-05-11','2022-05-11 10:10:59','2022-05-12 10:10:59','570',1946366.40,1946366.40,'570','2022-05-11 13:08:54','614','2022-05-11 15:31:42',10,0),('1','167',257810,'AFTERNOON SHIFT','2022-05-11','2022-05-11 20:35:17','2022-05-12 20:35:17','570',1366543.20,1366543.20,'570','2022-05-11 20:37:53','614','2022-05-12 02:05:22',10,0),('1','167',257811,'MORNING SHIFT','2022-05-12','2022-05-12 09:54:46','2022-05-13 09:54:46','570',2074947.60,2074947.60,'570','2022-05-12 14:36:40','614','2022-05-12 16:56:46',10,0),('1','167',257812,'AFTERNOON SHIFT','2022-05-12','2022-05-12 21:47:11','2022-05-13 21:47:11','570',5326039.95,5326039.95,'570','2022-05-12 22:03:03','614','2022-05-12 23:46:00',10,0),('1','167',257813,'MORNING SHIFT','2022-05-13','2022-05-13 11:22:22','2022-05-14 11:22:22','570',4064666.10,4064666.10,'570','2022-05-13 14:16:26','614','2022-05-13 15:53:03',10,0),('1','167',257814,'AFTERNOON SHIFT','2022-05-13','2022-05-13 16:59:12','2022-05-14 16:59:12','570',1384647.00,1384647.00,'570','2022-05-13 17:00:51','614','2022-05-13 20:14:08',10,0),('1','167',257815,'AFTERNOON SHIFT 2','2022-05-13','2022-05-13 20:37:34','2022-05-14 20:37:34','570',3809718.00,3809718.00,'570','2022-05-13 21:14:33','614','2022-05-13 22:09:10',10,0),('1','167',257816,'MORNING SHIFT','2022-05-14','2022-05-14 10:55:41','2022-05-15 10:55:41','570',1530038.80,1530038.80,'570','2022-05-14 11:07:09','614','2022-05-14 13:34:10',10,0),('1','167',257817,'MORNING SHIFT 2','2022-05-14','2022-05-14 13:51:42','2022-05-15 13:51:42','570',190084.05,190084.05,'570','2022-05-14 13:53:12','614','2022-05-14 15:17:41',10,0),('1','167',257818,'AFTERNOON SHIFT','2022-05-14','2022-05-14 20:00:01','2022-05-15 20:00:01','570',4057375.05,4057375.05,'570','2022-05-14 22:08:06','614','2022-05-14 23:40:20',10,0),('1','167',257819,'MORNING SHIFT','2022-05-15','2022-05-15 12:06:25','2022-05-16 12:06:25','570',2033872.50,2033872.50,'570','2022-05-15 14:25:59','614','2022-05-15 16:39:27',10,0),('1','167',257820,'AFTERNOON SHIFT','2022-05-15','2022-05-15 20:42:01','2022-05-16 20:42:01','570',3269427.60,3269427.60,'570','2022-05-15 20:54:09','614','2022-05-15 22:00:48',10,0),('1','167',257821,'MORNING SHIFT','2022-05-16','2022-05-16 14:00:27','2022-05-17 14:00:27','570',2552260.65,2552260.65,'570','2022-05-16 14:14:14','614','2022-05-16 15:26:14',10,0),('1','167',257822,'AFTERNOON SHIFT','2022-05-16','2022-05-16 20:28:00','2022-05-17 20:28:00','570',646426.50,646426.50,'570','2022-05-16 20:33:55','614','2022-05-16 21:49:48',10,0),('1','167',257823,'MORNING SHIFT','2022-05-17','2022-05-17 09:12:09','2022-05-18 09:12:09','570',1188497.40,1188497.40,'570','2022-05-17 13:44:52','614','2022-05-17 15:32:08',10,0),('1','167',257824,'AFTERNOON SHIFT','2022-05-17','2022-05-17 20:48:11','2022-05-18 20:48:11','570',2578488.60,2578488.60,'570','2022-05-17 20:49:19','614','2022-05-17 23:30:15',10,0),('1','167',257825,'MORNING SHIFT','2022-05-18','2022-05-18 09:00:35','2022-05-19 09:00:35','570',3053087.25,3053087.25,'570','2022-05-18 14:38:43','614','2022-05-18 18:46:27',10,0),('1','167',257826,'AFTERNOON SHIFT','2022-05-18','2022-05-18 21:17:08','2022-05-19 21:17:08','570',6707482.05,6707482.05,'570','2022-05-18 21:43:30','614','2022-05-18 23:32:23',10,0),('1','167',257827,'MORNING SHIFT','2022-05-19','2022-05-19 09:30:38','2022-05-20 09:30:38','570',5031194.40,5031194.40,'570','2022-05-19 14:05:52','614','2022-05-19 14:33:24',10,0),('1','167',257828,'MORNING SHIFT','2022-05-19','2022-05-19 19:57:15','2022-05-20 19:57:15','570',3520138.35,3520138.35,'570','2022-05-19 20:04:40','614','2022-05-19 23:00:07',10,0),('1','167',257829,'MORNING SHIFT','2022-05-20','2022-05-20 07:36:23','2022-05-21 07:36:23','570',1262996.70,1262996.70,'570','2022-05-20 13:11:12','614','2022-05-20 17:26:25',10,0),('1','167',257830,'AFTERNOON SHIFT','2022-05-20','2022-05-20 19:12:33','2022-05-21 19:12:33','570',2461000.80,2461000.80,'570','2022-05-20 19:15:01','614','2022-05-20 22:10:08',10,0),('1','167',257831,'MORNING SHIFT','2022-05-21','2022-05-21 08:52:42','2022-05-22 08:52:42','570',718207.20,718207.20,'570','2022-05-21 13:23:30','614','2022-05-21 14:55:53',10,0),('1','167',257832,'AFTERNOON SHIFT','2022-05-21','2022-05-21 19:05:30','2022-05-22 19:05:30','570',1485818.40,1485818.40,'570','2022-05-21 19:06:56','614','2022-05-21 22:09:40',10,0),('1','167',257833,'MORNING SHIFT','2022-05-22','2022-05-22 10:09:32','2022-05-23 10:09:32','570',548149.80,548149.80,'570','2022-05-22 13:44:09','614','2022-05-22 15:11:22',10,0),('1','167',257834,'AFTERNOON SHIFT','2022-05-22','2022-05-22 19:12:20','2022-05-23 19:12:20','570',2068399.20,2068399.20,'570','2022-05-22 19:14:53','614','2022-05-22 22:58:48',10,0),('1','167',257835,'MORNING SHIFT','2022-05-23','2022-05-23 12:53:00','2022-05-24 12:53:00','570',0.00,0.00,'570','2022-05-25 15:21:52','614','2022-05-25 15:33:20',10,0),('1','167',257836,'MORNING SHIFT','2022-05-25','2022-05-25 15:34:13','2022-05-26 15:34:13','570',2463455.40,2463455.40,'570','2022-05-25 15:38:13','614','2022-05-25 15:39:32',10,0),('1','167',257837,'AFTERNOON SHIFT','2022-05-25','2022-05-25 15:46:22','2022-05-26 15:46:22','570',632196.00,632196.00,'570','2022-05-25 15:48:01','614','2022-05-25 21:58:20',10,0),('1','167',257838,'AFTERNOON SHIFT','2022-05-25','2022-05-25 22:11:18','2022-05-26 22:11:18','570',3078364.10,3078364.10,'570','2022-05-25 22:19:00','614','2022-05-26 14:16:34',10,0),('1','167',257839,'MORNING SHIFT','2022-05-26','2022-05-26 15:37:43','2022-05-27 15:37:43','570',2101119.05,2101119.05,'570','2022-05-26 15:43:51','614','2022-05-26 17:59:16',10,0),('1','167',257840,'AFTERNOON SHIFT','2022-05-26','2022-05-26 18:32:49','2022-05-27 18:32:49','570',5530643.70,5530643.70,'570','2022-05-26 21:41:07','614','2022-05-26 22:56:30',10,0),('1','167',257841,'MORNING SHIFT','2022-05-27','2022-05-27 10:06:52','2022-05-28 10:06:52','570',1313665.00,1313665.00,'570','2022-05-27 15:29:09','614','2022-05-27 15:50:54',10,0),('1','167',257842,'AFTERNOON SHIFT','2022-05-27','2022-05-27 20:31:56','2022-05-28 20:31:56','570',1109366.40,1109366.40,'570','2022-05-27 20:33:41','614','2022-05-28 06:36:24',10,0),('1','167',257843,'MORNING SHIFT','2022-05-28','2022-05-28 11:49:55','2022-05-29 11:49:55','570',2306760.95,2306760.95,'570','2022-05-28 13:39:03','614','2022-05-28 15:24:16',10,0),('1','167',257844,'AFTERNOON SHIFT','2022-05-28','2022-05-28 20:09:43','2022-05-29 20:09:43','570',2152718.35,2152718.35,'570','2022-05-28 20:12:48','614','2022-05-28 23:38:11',10,0),('1','167',257845,'MORNING SHIFT','2022-05-29','2022-05-29 12:25:47','2022-05-30 12:25:47','570',2893508.45,2893508.45,'570','2022-05-29 13:51:18','614','2022-05-29 15:54:49',10,0),('1','167',257846,'AFTERNOON SHIFT','2022-05-29','2022-05-29 20:17:01','2022-05-30 20:17:01','570',3525816.60,3525816.60,'570','2022-05-29 20:34:35','614','2022-05-30 10:31:05',10,0),('1','167',257847,'MORNING SHIFT','2022-05-30','2022-05-30 11:11:44','2022-05-31 11:11:44','570',3853755.80,3853755.80,'570','2022-05-30 14:22:50','614','2022-05-30 15:31:39',10,0),('1','167',257848,'AFTERNOON SHIFT','2022-05-30','2022-05-30 20:17:35','2022-05-31 20:17:35','570',4312861.75,4312861.75,'570','2022-05-30 20:43:10','614','2022-05-30 22:24:28',10,0),('1','167',257849,'MORNING SHIFT','2022-05-31','2022-05-31 09:56:14','2022-06-01 09:56:14','570',4102086.50,4102086.50,'570','2022-05-31 14:33:04','614','2022-05-31 15:01:44',10,0),('1','167',257850,'AFTERNOON SHIFT','2022-05-31','2022-05-31 21:30:36','2022-06-01 21:30:36','570',2836264.55,2836264.55,'570','2022-05-31 21:35:20','614','2022-05-31 22:21:15',10,0),('1','167',257851,'MORNING SHIFT','2022-06-01','2022-06-01 09:56:19','2022-06-02 09:56:19','570',2136206.30,2136206.30,'570','2022-06-01 13:54:13','614','2022-06-01 19:54:41',10,0),('1','167',257852,'AFTERNOON SHIFT','2022-06-01','2022-06-01 20:12:07','2022-06-02 20:12:07','570',1166693.30,1166693.30,'570','2022-06-01 20:13:48','614','2022-06-01 22:55:45',10,0),('1','167',257853,'MORNING SHIFT','2022-06-02','2022-06-02 12:50:17','2022-06-03 12:50:17','570',1549644.00,1549644.00,'570','2022-06-02 14:00:10','614','2022-06-02 18:25:02',10,0),('1','167',257854,'AFTERNOON SHIFT','2022-06-02','2022-06-02 19:59:54','2022-06-03 19:59:54','570',2109743.80,2109743.80,'570','2022-06-02 20:01:27','614','2022-06-03 06:37:08',10,0),('1','167',257855,'MORNING SHIFT','2022-06-03','2022-06-03 10:46:09','2022-06-04 10:46:09','570',329755.60,329755.60,'570','2022-06-03 12:42:21','614','2022-06-03 15:19:48',10,0),('1','167',257856,'MORNING SHIFT 2','2022-06-03','2022-06-03 15:30:24','2022-06-04 15:30:24','570',337802.60,337802.60,'570','2022-06-03 15:31:51','614','2022-06-03 18:58:56',10,0),('1','167',257857,'AFTERNOON SHIFT','2022-06-03','2022-06-03 20:16:48','2022-06-04 20:16:48','570',1661159.40,1661159.40,'570','2022-06-03 20:18:27','614','2022-06-03 22:19:53',10,0),('1','167',257858,'MORNING SHIFT','2022-06-04','2022-06-04 12:09:58','2022-06-05 12:09:58','570',1262033.00,1262033.00,'570','2022-06-04 13:59:18','614','2022-06-04 15:18:55',10,0),('1','167',257859,'AFTERNOON SHIFT','2022-06-04','2022-06-04 20:53:33','2022-06-05 20:53:33','570',860893.80,860893.80,'570','2022-06-04 20:55:04','614','2022-06-04 21:47:56',10,0),('1','167',257860,'MORNING SHIFT','2022-06-05','2022-06-05 12:09:57','2022-06-06 12:09:57','570',3073142.70,3073142.70,'570','2022-06-05 13:30:14','614','2022-06-05 13:55:55',10,0),('1','167',257861,'AFTERNOON SHIFT','2022-06-05','2022-06-05 14:29:40','2022-06-06 14:29:40','570',2505053.25,2505053.25,'570','2022-06-05 20:34:54','614','2022-06-05 20:55:53',10,0),('1','167',257862,'MORNING SHIFT','2022-06-06','2022-06-06 13:21:54','2022-06-07 13:21:54','570',2836141.15,2836141.15,'570','2022-06-06 13:48:59','614','2022-06-06 14:51:10',10,0),('1','167',257863,'AFTERNOON SHIFT','2022-06-06','2022-06-06 21:00:25','2022-06-07 21:00:25','570',2419830.30,2419830.30,'570','2022-06-06 21:06:45','614','2022-06-06 22:44:06',10,0),('1','167',257864,'MORNING SHIFT','2022-06-07','2022-06-07 10:12:55','2022-06-08 10:12:55','570',939052.60,939052.60,'570','2022-06-07 13:44:19','614','2022-06-07 16:02:43',10,0),('1','167',257865,'AFTERNOON SHIFT','2022-06-07','2022-06-07 20:03:19','2022-06-08 20:03:19','570',2711434.00,2711434.00,'570','2022-06-07 20:04:21','614','2022-06-07 23:10:05',10,0),('1','167',257866,'MORNING SHIFT','2022-06-08','2022-06-08 14:00:10','2022-06-09 14:00:10','570',712375.80,712375.80,'570','2022-06-08 14:02:54','614','2022-06-08 14:40:57',10,0),('1','167',257867,'AFTERNOON SHIFT','2022-06-08','2022-06-09 10:39:10','2022-06-10 10:39:10','426',0.00,0.00,'570','2022-06-09 13:58:26','426','2022-06-09 13:59:35',10,0),('1','167',257868,'MORNING SHIFT','2022-06-09','2022-06-09 14:00:54','2022-06-10 14:00:54','570',624731.25,624731.25,'570','2022-06-09 14:13:24','614','2022-06-09 15:09:36',10,0),('1','167',257869,'AFTERNOON SHIFT','2022-06-09','2022-06-09 20:27:21','2022-06-10 20:27:21','570',3291840.15,3291840.15,'570','2022-06-09 20:38:07','614','2022-06-09 22:41:40',10,0),('1','167',257870,'MORNING SHIFT','2022-06-10','2022-06-10 10:13:17','2022-06-11 10:13:17','570',1429127.70,1429127.70,'570','2022-06-10 14:02:47','614','2022-06-10 14:59:38',10,0),('1','167',257871,'AFTERNOON SHIFT','2022-06-10','2022-06-10 20:30:41','2022-06-11 20:30:41','570',2186504.90,2186504.90,'570','2022-06-10 21:03:20','614','2022-06-10 22:40:11',10,0),('1','167',257872,'MORNING SHIFT','2022-06-11','2022-06-11 12:14:16','2022-06-12 12:14:16','570',1517346.60,1517346.60,'570','2022-06-11 13:51:33','614','2022-06-11 14:43:40',10,0),('1','167',257873,'AFTERNOON SHIFT','2022-06-11','2022-06-11 20:30:24','2022-06-12 20:30:24','570',1780041.45,1780041.45,'570','2022-06-11 20:37:10','614','2022-06-11 21:09:02',10,0),('1','167',257874,'MORNING SHIFT','2022-06-12','2022-06-12 09:36:21','2022-06-13 09:36:21','570',2046234.30,2046234.30,'570','2022-06-12 13:37:43','614','2022-06-12 16:28:16',10,0),('1','167',257875,'AFTERNOON SHIFT','2022-06-12','2022-06-12 20:37:15','2022-06-13 20:37:15','570',2777039.10,2777039.10,'570','2022-06-12 21:19:11','614','2022-06-12 23:10:50',10,0),('1','167',257876,'MORNING SHIFT','2022-06-13','2022-06-13 10:18:28','2022-06-14 10:18:28','570',2388855.15,2388855.15,'570','2022-06-13 14:01:59','614','2022-06-13 14:40:18',10,0),('1','167',257877,'AFTERNOON SHIFT','2022-06-13','2022-06-13 21:26:46','2022-06-14 21:26:46','570',2457865.95,2457865.95,'570','2022-06-13 21:38:19','614','2022-06-13 22:08:31',10,0),('1','167',257878,'MORNING SHIFT','2022-06-14','2022-06-14 09:11:37','2022-06-15 09:11:37','570',2529997.05,2529997.05,'570','2022-06-14 14:28:26','614','2022-06-14 14:38:01',10,0),('1','167',257879,'AFTERNOON SHIFT','2022-06-14','2022-06-14 17:17:14','2022-06-15 17:17:14','570',5427294.30,5427294.30,'570','2022-06-14 20:34:38','614','2022-06-14 22:11:30',10,0),('1','167',257880,'MORNING SHIFT','2022-06-15','2022-06-15 10:10:14','2022-06-16 10:10:14','570',3880266.00,3880266.00,'570','2022-06-15 13:50:45','614','2022-06-15 15:09:49',10,0),('1','167',257881,'AFTERNOON SHIFT','2022-06-15','2022-06-15 20:54:57','2022-06-16 20:54:57','570',7783815.00,7783815.00,'570','2022-06-15 21:14:24','614','2022-06-15 23:30:52',10,0),('1','167',257882,'MORNING SHIFT','2022-06-16','2022-06-16 10:39:02','2022-06-17 10:39:02','570',2338626.00,2338626.00,'570','2022-06-16 14:05:42','614','2022-06-16 15:51:48',10,0),('1','167',257883,'AFTERNOON SHIFT','2022-06-16','2022-06-16 19:47:32','2022-06-17 19:47:32','570',2799697.35,2799697.35,'570','2022-06-16 20:01:13','614','2022-06-16 22:31:26',10,0),('1','167',257884,'MORNING SHIFT','2022-06-17','2022-06-17 10:10:01','2022-06-18 10:10:01','570',3024801.00,3024801.00,'570','2022-06-17 13:26:24','614','2022-06-17 14:50:53',10,0),('1','167',257885,'AFTERNOON SHIFT','2022-06-17','2022-06-17 19:21:22','2022-06-18 19:21:22','570',2371067.40,2371067.40,'570','2022-06-17 19:23:23','614','2022-06-18 12:37:50',10,0),('1','167',257886,'MORNING SHIFT','2022-06-18','2022-06-18 13:17:02','2022-06-19 13:17:02','570',1472998.80,1472998.80,'570','2022-06-18 13:22:40','614','2022-06-18 14:49:59',10,0),('1','167',257887,'AFTERNOON SHIFT','2022-06-18','2022-06-18 20:03:59','2022-06-19 20:03:59','570',1730859.00,1730859.00,'570','2022-06-18 20:06:16','614','2022-06-18 20:35:55',10,0),('1','167',257888,'MORNING SHIFT','2022-06-19','2022-06-19 12:39:43','2022-06-20 12:39:43','570',1216137.00,1216137.00,'570','2022-06-19 13:38:05','614','2022-06-19 15:51:41',10,0),('1','167',257889,'AFTERNOON SHIFT','2022-06-19','2022-06-19 20:02:50','2022-06-20 20:02:50','570',5509592.40,5509592.40,'570','2022-06-19 20:05:23','614','2022-06-20 11:04:45',10,0),('1','167',257890,'MORNING SHIFT','2022-06-20','2022-06-20 13:20:30','2022-06-21 13:20:30','570',1018079.40,1018079.40,'570','2022-06-20 13:22:55','614','2022-06-20 14:00:16',10,0),('1','167',257891,'AFTERNOON SHIFT','2022-06-20','2022-06-20 14:48:24','2022-06-21 14:48:24','570',3120460.20,3120460.20,'570','2022-06-20 19:56:56','614','2022-06-20 23:06:44',10,0),('1','167',257892,'MORNING SHIFT','2022-06-21','2022-06-21 12:12:09','2022-06-22 12:12:09','570',2502422.85,2502422.85,'570','2022-06-21 14:49:22','614','2022-06-21 18:57:48',10,0),('1','167',257893,'AFTERNOON SHIFT','2022-06-21','2022-06-21 20:26:42','2022-06-22 20:26:42','570',4494946.20,4494946.20,'570','2022-06-21 20:42:18','614','2022-06-22 06:56:37',10,0),('1','167',257894,'MORNING SHIFT','2022-06-22','2022-06-22 10:59:22','2022-06-23 10:59:22','570',2730955.65,2730955.65,'570','2022-06-22 13:51:48','614','2022-06-22 18:58:16',10,0),('1','167',257895,'AFTERNOON SHIFT','2022-06-22','2022-06-22 20:07:06','2022-06-23 20:07:06','570',1488936.90,1488936.90,'570','2022-06-22 20:11:04','614','2022-06-22 23:51:49',10,0),('1','167',257896,'MORNING SHIFT','2022-06-23','2022-06-23 13:07:24','2022-06-24 13:07:24','570',278733.00,278733.00,'570','2022-06-23 13:42:50','614','2022-06-23 14:28:07',10,0),('1','167',257897,'MORNING SHIFT','2022-06-23','2022-06-23 19:42:26','2022-06-24 19:42:26','570',316001.40,316001.40,'570','2022-06-23 19:43:36','614','2022-06-23 21:10:20',10,0),('1','167',257898,'MORNING SHIFT','2022-06-24','2022-06-24 13:26:04','2022-06-25 13:26:04','570',1000100.40,1000100.40,'570','2022-06-24 13:30:44','614','2022-06-24 15:15:43',10,0),('1','167',257899,'AFTERNOON SHIFT','2022-06-24','2022-06-24 19:30:16','2022-06-25 19:30:16','570',0.00,0.00,'570','2022-06-24 19:33:15','614','2022-06-24 23:35:48',10,0),('1','167',257900,'MORNING SHIFT','2022-06-26','2022-06-28 11:41:13','2022-06-29 11:41:13','570',477001.20,477001.20,'570','2022-06-28 11:45:46','614','2022-06-28 12:23:42',10,0),('1','167',257901,'MORNING SHIFT 2','2022-06-28','2022-06-28 14:12:38','2022-06-29 14:12:38','570',2557682.40,2557682.40,'570','2022-06-28 14:24:32','614','2022-06-28 15:18:25',10,0),('1','167',257902,'AFTERNOON SHIFT','2022-06-28','2022-06-28 21:03:33','2022-06-29 21:03:33','570',2192427.30,2192427.30,'570','2022-06-28 21:08:42','614','2022-06-28 21:58:34',10,0),('1','167',257903,'MORNING SHIFT','2022-06-29','2022-06-29 13:46:28','2022-06-30 13:46:28','570',1740655.80,1740655.80,'570','2022-06-29 14:15:30','614','2022-06-29 14:52:31',10,0),('1','167',257904,'AFTERNOON SHIFT','2022-06-29','2022-06-29 20:23:50','2022-06-30 20:23:50','570',2001464.40,2001464.40,'570','2022-06-29 20:31:21','614','2022-06-29 22:15:48',10,0),('1','167',257905,'MORNING SHIFT','2022-06-30','2022-06-30 13:09:54','2022-07-01 13:09:54','570',1601433.60,1601433.60,'570','2022-06-30 13:13:40','614','2022-06-30 17:48:42',10,0),('1','167',257906,'AFTERNOON SHIFT','2022-06-30','2022-06-30 19:33:17','2022-07-01 19:33:17','570',1873583.40,1873583.40,'570','2022-06-30 20:09:45','614','2022-06-30 23:12:52',10,0),('1','167',257907,'MORNING SHIFT','2022-07-01','2022-07-01 13:24:46','2022-07-02 13:24:46','570',1441159.20,1441159.20,'570','2022-07-01 13:27:54','614','2022-07-01 20:24:01',10,0),('1','167',257908,'AFTERNOON SHIFT','2022-07-01','2022-07-01 20:27:04','2022-07-02 20:27:04','570',2565513.60,2565513.60,'570','2022-07-01 20:31:13','614','2022-07-01 21:23:48',10,0),('1','167',257909,'MORNING SHIFT','2022-07-02','2022-07-02 13:20:51','2022-07-03 13:20:51','570',1186044.60,1186044.60,'570','2022-07-02 13:21:53','614','2022-07-02 15:31:56',10,0),('1','167',257910,'AFTERNOON SHIFT','2022-07-02','2022-07-02 19:46:32','2022-07-03 19:46:32','570',901196.40,901196.40,'570','2022-07-02 19:49:42','614','2022-07-02 22:01:57',10,0),('1','167',257911,'MORNING SHIFT','2022-07-03','2022-07-03 14:07:34','2022-07-04 14:07:34','570',589383.60,589383.60,'570','2022-07-03 14:14:10','614','2022-07-03 15:04:56',10,0),('1','167',257912,'AFTERNOON SHIFT','2022-07-03','2022-07-03 19:32:24','2022-07-04 19:32:24','570',4796911.35,4796911.35,'570','2022-07-03 20:06:31','614','2022-07-03 22:20:43',10,0),('1','167',257913,'MORNING SHIFT','2022-07-04','2022-07-04 13:50:21','2022-07-05 13:50:21','570',3020213.10,3020213.10,'570','2022-07-04 13:52:42','614','2022-07-04 14:21:47',10,0),('1','167',257914,'AFTERNOON SHIFT','2022-07-04','2022-07-04 20:09:41','2022-07-05 20:09:41','570',4780455.90,4780455.90,'570','2022-07-04 20:13:11','614','2022-07-04 22:47:00',10,0),('1','167',257915,'MORNING SHIFT','2022-07-05','2022-07-05 14:17:47','2022-07-06 14:17:47','570',3106468.35,3106468.35,'570','2022-07-05 14:35:23','614','2022-07-05 18:57:24',10,0),('1','167',257916,'AFTERNOON SHIFT','2022-07-05','2022-07-05 20:13:33','2022-07-06 20:13:33','570',1266197.40,1266197.40,'570','2022-07-05 20:15:33','614','2022-07-06 02:18:49',10,0),('1','167',257917,'MORNING SHIFT','2022-07-06','2022-07-06 13:25:59','2022-07-07 13:25:59','570',1117857.00,1117857.00,'570','2022-07-06 13:26:45','614','2022-07-06 18:11:42',10,0),('1','167',257918,'AFTERNOON SHIFT','2022-07-06','2022-07-06 20:19:55','2022-07-07 20:19:55','570',1436323.20,1436323.20,'570','2022-07-06 20:27:32','614','2022-07-06 21:20:47',10,0),('1','167',257919,'MORNING SHIFT','2022-07-07','2022-07-07 13:53:31','2022-07-08 13:53:31','570',2531786.40,2531786.40,'570','2022-07-07 13:55:06','614','2022-07-07 16:36:33',10,0),('1','167',257920,'AFTERNOON SHIFT','2022-07-07','2022-07-07 19:30:57','2022-07-08 19:30:57','570',2024552.40,2024552.40,'570','2022-07-07 19:33:00','614','2022-07-07 23:48:46',10,0),('1','167',257921,'MORNING SHIFT','2022-07-08','2022-07-08 13:40:15','2022-07-09 13:40:15','570',1047820.80,1047820.80,'570','2022-07-08 13:41:44','614','2022-07-08 16:16:27',10,0),('1','167',257922,'AFTERNOON SHIFT','2022-07-08','2022-07-08 19:38:55','2022-07-09 19:38:55','570',2011698.00,2011698.00,'570','2022-07-08 19:40:11','614','2022-07-08 19:55:38',10,0),('1','167',257923,'MORNING SHIFT','2022-07-09','2022-07-09 13:37:11','2022-07-10 13:37:11','570',0.00,0.00,'570','2022-07-09 13:37:36','614','2022-07-09 13:41:28',10,0),('1','167',257924,'MORNING SHIFT','2022-07-09','2022-07-09 13:47:10','2022-07-10 13:47:10','570',1109651.40,1109651.40,'570','2022-07-09 13:50:24','614','2022-07-09 17:19:06',10,0),('1','167',257925,'AFTERNOON SHIFT','2022-07-09','2022-07-09 19:31:19','2022-07-10 19:31:19','570',1203602.40,1203602.40,'570','2022-07-09 19:37:25','614','2022-07-09 23:08:38',10,0),('1','167',257926,'MORNING SHIFT','2022-07-10','2022-07-10 13:29:52','2022-07-11 13:29:52','570',876509.40,876509.40,'570','2022-07-10 13:48:42','614','2022-07-10 17:22:05',10,0),('1','167',257927,'AFTERNOON SHIFT','2022-07-10','2022-07-10 20:30:34','2022-07-11 20:30:34','570',286494.00,286494.00,'570','2022-07-10 20:36:16','614','2022-07-10 23:24:47',10,0),('1','167',257928,'MORNING SHIFT','2022-07-11','2022-07-11 14:10:32','2022-07-12 14:10:32','570',791144.00,791144.00,'570','2022-07-11 14:12:44','614','2022-07-11 15:16:14',10,0),('1','167',257929,'AFTERNOON SHIFT','2022-07-11','2022-07-11 19:34:55','2022-07-12 19:34:55','570',933285.60,933285.60,'570','2022-07-11 19:50:56','614','2022-07-11 23:29:22',10,0),('1','167',257930,'MORNING SHIFT','2022-07-12','2022-07-12 13:04:31','2022-07-13 13:04:31','570',2308293.00,2308293.00,'570','2022-07-12 13:26:11','614','2022-07-12 14:52:57',10,0),('1','167',257931,'AFTERNOON SHIFT','2022-07-12','2022-07-12 19:29:03','2022-07-13 19:29:03','570',472867.20,472867.20,'570','2022-07-12 19:30:33','614','2022-07-12 23:59:05',10,0),('1','167',257932,'MORNING SHIFT','2022-07-13','2022-07-13 14:00:33','2022-07-14 14:00:33','570',1846102.90,1846102.90,'570','2022-07-13 14:03:28','614','2022-07-13 15:15:13',10,0),('1','167',257933,'AFTERNOON SHIFT','2022-07-13','2022-07-13 20:43:48','2022-07-14 20:43:48','570',4519067.35,4519067.35,'570','2022-07-13 21:14:11','614','2022-07-13 23:42:20',10,0),('1','167',257934,'MORNING SHIFT','2022-07-14','2022-07-14 13:28:43','2022-07-15 13:28:43','570',4578294.05,4578294.05,'570','2022-07-14 14:11:23','614','2022-07-14 19:56:58',10,0),('1','167',257935,'AFTERNOON SHIFT','2022-07-14','2022-07-14 21:13:41','2022-07-15 21:13:41','570',4417364.25,4417364.25,'570','2022-07-14 21:42:32','614','2022-07-15 06:55:40',10,0),('1','167',257936,'MORNING SHIFT','2022-07-15','2022-07-15 13:49:25','2022-07-16 13:49:25','570',3195682.00,3195682.00,'570','2022-07-15 13:54:46','614','2022-07-15 15:17:40',10,0),('1','167',257937,'AFTERNOON SHIFT','2022-07-16','2022-07-16 20:41:17','2022-07-17 20:41:17','570',544736.40,544736.40,'570','2022-07-17 08:45:54','614','2022-07-17 12:28:11',10,0),('1','167',257938,'MORNING SHIFT','2022-07-17','2022-07-17 13:50:31','2022-07-18 13:50:31','570',1922879.40,1922879.40,'570','2022-07-17 14:01:00','614','2022-07-17 18:49:22',10,0),('1','167',257939,'AFTERNOON SHIFT','2022-07-17','2022-07-17 19:27:59','2022-07-18 19:27:59','570',2015309.40,2015309.40,'570','2022-07-17 19:34:56','614','2022-07-17 22:59:38',10,0),('1','167',257940,'MORNING SHIFT','2022-07-18','2022-07-18 13:44:36','2022-07-19 13:44:36','570',1085112.60,1085112.60,'570','2022-07-18 13:45:45','614','2022-07-18 15:09:37',10,0),('1','167',257941,'AFTERNOON SHIFT','2022-07-18','2022-07-18 20:31:58','2022-07-19 20:31:58','570',1840573.80,1840573.80,'570','2022-07-18 20:33:27','614','2022-07-18 22:59:15',10,0),('1','167',257942,'MORNING SHIFT','2022-07-19','2022-07-19 13:23:06','2022-07-20 13:23:06','570',1998531.60,1998531.60,'570','2022-07-19 13:24:53','614','2022-07-19 14:44:53',10,0),('1','167',257943,'AFTERNOON SHIFT','2022-07-19','2022-07-19 19:45:38','2022-07-20 19:45:38','570',1728792.00,1728792.00,'570','2022-07-19 19:48:12','614','2022-07-19 21:24:24',10,0),('1','167',257944,'MORNING SHIFT','2022-07-20','2022-07-20 13:20:24','2022-07-21 13:20:24','570',1958712.60,1958712.60,'570','2022-07-20 13:22:10','614','2022-07-20 14:51:28',10,0),('1','167',257945,'AFTERNOON SHIFT','2022-07-20','2022-07-20 19:46:50','2022-07-21 19:46:50','570',1405755.00,1405755.00,'570','2022-07-20 19:48:08','614','2022-07-20 22:40:56',10,0),('1','167',257946,'MORNING SHIFT','2022-07-21','2022-07-21 13:44:35','2022-07-22 13:44:35','570',585616.20,585616.20,'570','2022-07-21 13:48:06','614','2022-07-21 14:55:20',10,0),('1','167',257947,'AFTERNOON SHIFT','2022-07-21','2022-07-21 19:38:07','2022-07-22 19:38:07','570',2226354.00,2226354.00,'570','2022-07-21 19:46:01','614','2022-07-21 22:56:01',10,0),('1','167',257948,'MORNING SHIFT','2022-07-22','2022-07-22 13:14:03','2022-07-23 13:14:03','570',2139056.40,2139056.40,'570','2022-07-22 13:17:17','614','2022-07-22 14:39:19',10,0),('1','167',257949,'AFTERNOON SHIFT','2022-07-22','2022-07-22 16:26:17','2022-07-23 16:26:17','570',521999.40,521999.40,'570','2022-07-22 16:27:30','614','2022-07-22 18:58:25',10,0),('1','167',257950,'AFTERNOON SHIFT ll','2022-07-22','2022-07-22 20:46:31','2022-07-23 20:46:31','570',515764.55,515764.55,'570','2022-07-22 20:48:49','614','2022-07-22 23:02:23',10,0),('1','167',257951,'MORNING SHIFT','2022-07-23','2022-07-23 13:09:12','2022-07-24 13:09:12','570',1470222.60,1470222.60,'570','2022-07-23 13:15:09','614','2022-07-23 14:54:43',10,0),('1','167',257952,'AFTERNOON SHIFT','2022-07-23','2022-07-23 20:58:07','2022-07-24 20:58:07','570',2213942.50,2213942.50,'570','2022-07-23 20:59:18','614','2022-07-24 11:42:59',10,0),('1','167',257953,'MORNING SHIFT','2022-07-24','2022-07-24 13:23:05','2022-07-25 13:23:05','570',1921612.00,1921612.00,'570','2022-07-24 13:24:50','614','2022-07-24 20:47:25',10,0),('1','167',257954,'AFTERNOON SHIFT','2022-07-24','2022-07-24 20:52:18','2022-07-25 20:52:18','570',2121935.20,2121935.20,'570','2022-07-24 20:54:10','614','2022-07-25 15:43:43',10,0),('1','167',257955,'MORNING SHIFT','2022-07-25','2022-07-25 16:04:40','2022-07-26 16:04:40','570',709947.70,709947.70,'570','2022-07-25 16:06:05','614','2022-07-25 16:25:53',10,0),('1','167',257956,'AFTERNOON SHIFT','2022-07-25','2022-07-25 21:18:45','2022-07-26 21:18:45','570',2197426.00,2197426.00,'570','2022-07-25 21:19:37','614','2022-07-26 08:00:04',10,0),('1','167',257957,'MORNING SHIFT','2022-07-26','2022-07-26 13:24:25','2022-07-27 13:24:25','570',2133569.90,2133569.90,'570','2022-07-26 13:27:41','614','2022-07-26 17:05:07',10,0),('1','167',257958,'AFTERNOON SHIFT','2022-07-26','2022-07-26 20:02:35','2022-07-27 20:02:35','570',4128555.90,4128555.90,'570','2022-07-26 21:21:42','614','2022-07-26 22:17:27',10,0),('1','167',257959,'MORNING SHIFT','2022-07-27','2022-07-27 09:21:20','2022-07-28 09:21:20','570',715261.75,715261.75,'570','2022-07-27 10:01:50','614','2022-07-27 10:42:18',10,0),('1','167',257960,'MORNING SHIFT 2','2022-07-27','2022-07-27 14:00:57','2022-07-28 14:00:57','570',1214127.25,1214127.25,'570','2022-07-27 14:10:56','614','2022-07-27 14:28:08',10,0),('1','167',257961,'AFTERNOON SHIFT','2022-07-27','2022-07-27 21:25:34','2022-07-28 21:25:34','570',2218237.20,2218237.20,'570','2022-07-27 21:29:37','614','2022-07-27 21:50:49',10,0),('1','167',257962,'MORNING SHIFT','2022-07-28','2022-07-28 10:51:29','2022-07-29 10:51:29','570',2347353.00,2347353.00,'570','2022-07-28 13:50:42','614','2022-07-28 15:13:13',10,0),('1','167',257963,'AFTERNOON SHIFT','2022-07-28','2022-07-29 07:13:26','2022-07-30 07:13:26','570',2121720.40,2121720.40,'570','2022-07-29 07:18:47','614','2022-07-29 17:15:33',10,0),('1','167',257964,'MORNING SHIFT','2022-07-29','2022-07-29 17:26:12','2022-07-30 17:26:12','570',46200.00,46200.00,'570','2022-07-29 17:27:23','614','2022-07-29 17:49:55',10,0),('1','167',257965,'MORNING SHIFT','2022-07-30','2022-07-30 13:32:36','2022-07-31 13:32:36','570',897334.90,897334.90,'570','2022-07-30 15:18:23','614','2022-07-30 22:06:41',10,0),('1','167',257966,'AFTERNOON SHIFT','2022-07-30','2022-07-30 22:10:25','2022-07-31 22:10:25','570',2977474.50,2977474.50,'570','2022-07-30 22:12:00','614','2022-07-30 23:05:41',10,0),('1','167',257967,'MORNING SHIFT','2022-07-31','2022-07-31 11:43:52','2022-08-01 11:43:52','570',882281.40,882281.40,'570','2022-07-31 13:19:01','614','2022-07-31 14:57:43',10,0),('1','167',257968,'AFTERNOON SHIFT','2022-07-31','2022-07-31 21:03:01','2022-08-01 21:03:01','570',2194746.40,2194746.40,'570','2022-07-31 21:03:57','614','2022-07-31 21:44:15',10,0),('1','167',257969,'MORNING SHIFT','2022-08-01','2022-08-01 10:15:56','2022-08-02 10:15:56','570',731269.00,731269.00,'570','2022-08-01 14:09:41','614','2022-08-01 18:07:32',10,0),('1','167',257970,'AFTERNOON SHIFT','2022-08-01','2022-08-01 20:46:45','2022-08-02 20:46:45','570',1862791.70,1862791.70,'570','2022-08-01 20:48:56','614','2022-08-01 21:59:41',10,0),('1','167',257971,'MORNING SHIFT','2022-08-02','2022-08-02 11:52:18','2022-08-03 11:52:18','570',3907534.40,3907534.40,'570','2022-08-02 13:17:06','614','2022-08-02 14:29:06',10,0),('1','167',257972,'AFTERNOON SHIFT','2022-08-02','2022-08-02 19:29:12','2022-08-03 19:29:12','570',952636.30,952636.30,'570','2022-08-02 19:30:55','614','2022-08-02 20:45:34',10,0),('1','167',257973,'MORNING SHIFT','2022-08-03','2022-08-03 09:31:42','2022-08-04 09:31:42','570',761730.20,761730.20,'570','2022-08-03 13:54:20','614','2022-08-03 15:03:32',10,0),('1','167',257974,'AFTERNOON SHIFT','2022-08-03','2022-08-03 20:36:51','2022-08-04 20:36:51','570',1858368.60,1858368.60,'570','2022-08-03 20:50:58','614','2022-08-03 22:16:42',10,0),('1','167',257975,'MORNING SHIFT','2022-08-04','2022-08-04 15:00:08','2022-08-05 15:00:08','570',3206633.10,3206633.10,'570','2022-08-04 15:17:35','614','2022-08-04 16:06:55',10,0),('1','167',257976,'AFTERNOON SHIFT','2022-08-04','2022-08-04 20:45:37','2022-08-05 20:45:37','570',0.00,0.00,'426','2022-08-05 11:28:39','614','2022-08-05 11:48:14',10,0),('1','167',257977,'AFTERNOON SHIFT','2022-08-04','2022-08-05 12:14:58','2022-08-06 12:14:58','570',3764547.10,3764547.10,'570','2022-08-05 12:24:55','614','2022-08-05 12:28:59',10,0),('1','167',257978,'MORNING SHIFT','2022-08-05','2022-08-05 13:45:52','2022-08-06 13:45:52','570',6308209.60,6308209.60,'570','2022-08-05 13:55:48','614','2022-08-05 15:41:00',10,0),('1','167',257979,'AFTERNOON SHIFT','2022-08-05','2022-08-05 17:29:59','2022-08-06 17:29:59','570',4583767.90,4583767.90,'570','2022-08-05 21:18:32','614','2022-08-05 22:38:14',10,0),('1','167',257980,'MORNING SHIFT','2022-08-06','2022-08-06 10:17:29','2022-08-07 10:17:29','570',4105451.50,4105451.50,'570','2022-08-06 13:28:49','614','2022-08-06 14:40:34',10,0),('1','167',257981,'AFTERNOON SHIFT','2022-08-06','2022-08-06 20:41:55','2022-08-07 20:41:55','570',3726999.10,3726999.10,'570','2022-08-06 20:45:15','614','2022-08-06 22:12:29',10,0),('1','167',257982,'MORNING SHIFT','2022-08-07','2022-08-07 12:05:42','2022-08-08 12:05:42','570',3461821.80,3461821.80,'570','2022-08-07 13:22:07','614','2022-08-07 14:46:48',10,0),('1','167',257983,'AFTERNOON SHIFT','2022-08-07','2022-08-07 17:12:09','2022-08-08 17:12:09','570',6056607.50,6056607.50,'570','2022-08-07 21:21:00','614','2022-08-07 23:13:46',10,0),('1','167',257984,'MORNING SHIFT','2022-08-08','2022-08-08 13:30:26','2022-08-09 13:30:26','570',3511576.60,3511576.60,'570','2022-08-08 13:39:10','614','2022-08-08 14:01:47',10,0),('1','167',257985,'AFTERNOON SHIFT','2022-08-08','2022-08-08 15:04:19','2022-08-09 15:04:19','570',5068081.70,5068081.70,'570','2022-08-08 21:16:40','614','2022-08-08 22:47:31',10,0),('1','167',257986,'MORNING SHIFT','2022-08-09','2022-08-09 12:04:54','2022-08-10 12:04:54','570',3362282.10,3362282.10,'570','2022-08-09 13:08:25','614','2022-08-09 14:58:18',10,0),('1','167',257987,'AFTERNOON SHIFT','2022-08-09','2022-08-09 20:41:08','2022-08-10 20:41:08','570',1283751.70,1283751.70,'570','2022-08-09 20:43:19','614','2022-08-10 09:43:03',10,0),('1','167',257988,'MORNING SHIFT','2022-08-10','2022-08-10 13:51:08','2022-08-11 13:51:08','570',8482647.40,8482647.40,'570','2022-08-10 14:45:42','614','2022-08-10 16:09:31',10,0),('1','167',257989,'AFTERNOON SHIFT','2022-08-10','2022-08-10 20:58:31','2022-08-11 20:58:31','570',5670774.70,5670774.70,'570','2022-08-10 21:09:02','614','2022-08-11 07:32:13',10,0),('1','167',257990,'MORNING SHIFT','2022-08-11','2022-08-11 13:51:47','2022-08-12 13:51:47','570',2154632.10,2154632.10,'570','2022-08-11 15:29:41','614','2022-08-11 15:52:24',10,0),('1','167',257991,'AFTERNOON SHIFT','2022-08-11','2022-08-11 21:26:11','2022-08-12 21:26:11','570',3523898.20,3523898.20,'570','2022-08-11 21:37:08','614','2022-08-11 22:29:13',10,0),('1','167',257992,'MORNING SHIFT','2022-08-12','2022-08-12 14:06:20','2022-08-13 14:06:20','570',1915817.40,1915817.40,'570','2022-08-12 14:37:00','614','2022-08-12 19:14:01',10,0),('1','167',257993,'AFTERNOON SHIFT','2022-08-12','2022-08-12 21:07:49','2022-08-13 21:07:49','570',2995552.80,2995552.80,'570','2022-08-12 21:16:20','614','2022-08-12 22:51:28',10,0),('1','167',257994,'MORNING SHIFT','2022-08-13','2022-08-13 12:13:14','2022-08-14 12:13:14','570',3353268.10,3353268.10,'570','2022-08-13 14:04:38','614','2022-08-13 18:01:01',10,0),('1','167',257995,'AFTERNOON SHIFT','2022-08-13','2022-08-13 19:51:15','2022-08-14 19:51:15','570',3724018.10,3724018.10,'570','2022-08-13 21:30:49','614','2022-08-13 22:01:01',10,0),('1','167',257996,'MORNING SHIFT','2022-08-14','2022-08-14 12:21:00','2022-08-15 12:21:00','570',3349762.30,3349762.30,'570','2022-08-14 14:15:52','614','2022-08-14 20:31:58',10,0),('1','167',257997,'AFTERNOON SHIFT','2022-08-14','2022-08-14 21:22:33','2022-08-15 21:22:33','570',3816581.40,3816581.40,'570','2022-08-14 21:42:58','614','2022-08-14 22:47:42',10,0),('1','167',257998,'MORNING SHIFT','2022-08-15','2022-08-15 10:56:36','2022-08-16 10:56:36','570',3104471.60,3104471.60,'570','2022-08-15 14:14:44','614','2022-08-15 14:58:17',10,0),('1','167',257999,'AFTERNOON SHIFT','2022-08-15','2022-08-15 21:14:33','2022-08-16 21:14:33','570',5333035.10,5333035.10,'570','2022-08-15 21:20:17','614','2022-08-15 22:16:36',10,0),('1','167',258000,'MORNING SHIFT','2022-08-16','2022-08-16 14:02:17','2022-08-17 14:02:17','570',3862037.30,3862037.30,'570','2022-08-16 14:12:32','614','2022-08-16 15:53:52',10,0),('1','167',258001,'AFTERNOON SHIFT','2022-08-16','2022-08-16 21:11:59','2022-08-17 21:11:59','570',3560547.20,3560547.20,'570','2022-08-16 21:17:15','614','2022-08-16 21:55:05',10,0),('1','167',258002,'MORNING SHIFT','2022-08-17','2022-08-17 09:34:13','2022-08-18 09:34:13','570',3413051.00,3413051.00,'570','2022-08-17 14:03:22','614','2022-08-17 20:04:06',10,0),('1','167',258003,'AFTERNOON SHIFT','2022-08-17','2022-08-17 20:27:17','2022-08-18 20:27:17','570',1797066.20,1797066.20,'570','2022-08-17 20:30:25','614','2022-08-17 22:57:40',10,0),('1','167',258004,'MORNING SHIFT','2022-08-18','2022-08-18 09:56:27','2022-08-19 09:56:27','570',2227203.20,2227203.20,'570','2022-08-18 13:50:20','614','2022-08-18 17:30:32',10,0),('1','167',258005,'AFTERNOON SHIFT','2022-08-18','2022-08-18 21:43:23','2022-08-19 21:43:23','570',4505379.20,4505379.20,'570','2022-08-19 08:37:48','614','2022-08-19 09:29:33',10,0),('1','167',258006,'MORNING SHIFT','2022-08-19','2022-08-19 10:21:39','2022-08-20 10:21:39','570',2966848.80,2966848.80,'570','2022-08-19 14:38:35','614','2022-08-19 22:01:49',10,0),('1','167',258007,'AFTERNOON SHIFT','2022-08-19','2022-08-19 22:05:48','2022-08-20 22:05:48','570',3010175.80,3010175.80,'570','2022-08-19 22:08:56','614','2022-08-19 22:14:50',10,0),('1','167',258008,'MORNING SHIFT','2022-08-20','2022-08-20 11:59:25','2022-08-21 11:59:25','570',3104018.40,3104018.40,'570','2022-08-20 13:51:25','614','2022-08-20 14:23:48',10,0),('1','167',258009,'AFTERNOON SHIFT','2022-08-20','2022-08-20 21:25:28','2022-08-21 21:25:28','570',1396203.60,1396203.60,'570','2022-08-20 21:27:27','614','2022-08-21 06:53:01',10,0),('1','167',258010,'MORNING SHIFT','2022-08-21','2022-08-21 11:10:04','2022-08-22 11:10:04','570',893372.40,893372.40,'570','2022-08-21 13:39:52','614','2022-08-21 18:44:54',10,0),('1','167',258011,'AFTERNOON SHIFT','2022-08-21','2022-08-21 20:06:52','2022-08-22 20:06:52','570',1018795.20,1018795.20,'570','2022-08-21 20:08:06','614','2022-08-21 22:43:42',10,0),('1','167',258012,'MORNING SHIFT','2022-08-22','2022-08-22 10:59:29','2022-08-23 10:59:29','570',2145662.40,2145662.40,'570','2022-08-22 14:27:30','614','2022-08-22 16:18:09',10,0),('1','167',258013,'AFTERNOON SHIFT','2022-08-22','2022-08-22 18:32:07','2022-08-23 18:32:07','570',874463.60,874463.60,'570','2022-08-22 20:02:34','614','2022-08-22 22:02:10',10,0),('1','167',258014,'MORNING SHIFT','2022-08-23','2022-08-23 10:44:45','2022-08-24 10:44:45','570',1639494.80,1639494.80,'570','2022-08-23 13:56:38','614','2022-08-23 14:38:39',10,0),('1','167',258015,'AFTERNOON SHIFT','2022-08-23','2022-08-23 20:46:11','2022-08-24 20:46:11','570',1401812.40,1401812.40,'570','2022-08-23 20:47:24','614','2022-08-23 20:58:55',10,0),('1','167',258016,'MORNING SHIFT','2022-08-24','2022-08-24 10:31:57','2022-08-25 10:31:57','570',1998230.00,1998230.00,'570','2022-08-24 14:02:41','614','2022-08-24 14:57:16',10,0),('1','167',258017,'AFTERNOON SHIFT','2022-08-24','2022-08-24 20:53:51','2022-08-25 20:53:51','570',1434028.80,1434028.80,'570','2022-08-24 20:55:23','614','2022-08-24 22:36:47',10,0),('1','167',258018,'MORNING SHIFT','2022-08-25','2022-08-25 12:30:31','2022-08-26 12:30:31','570',1124366.80,1124366.80,'570','2022-08-25 13:26:55','614','2022-08-25 15:24:35',10,0),('1','167',258019,'AFTERNOON SHIFT','2022-08-25','2022-08-25 20:47:11','2022-08-26 20:47:11','570',1090159.20,1090159.20,'570','2022-08-25 20:49:31','614','2022-08-25 22:44:40',10,0),('1','167',258020,'MORNING SHIFT','2022-08-26','2022-08-26 12:10:04','2022-08-27 12:10:04','570',778019.60,778019.60,'570','2022-08-26 13:36:01','614','2022-08-26 20:06:32',10,0),('1','167',258021,'AFTERNOON SHIFT','2022-08-26','2022-08-26 20:25:38','2022-08-27 20:25:38','570',4090806.40,4090806.40,'570','2022-08-26 21:08:19','614','2022-08-26 22:23:48',10,0),('1','167',258022,'MORNING SHIFT','2022-08-27','2022-08-27 11:28:25','2022-08-28 11:28:25','570',1908306.80,1908306.80,'570','2022-08-27 13:29:11','614','2022-08-27 19:14:01',10,0),('1','167',258023,'AFTERNOON SHIFT','2022-08-27','2022-08-27 20:56:41','2022-08-28 20:56:41','570',943236.00,943236.00,'570','2022-08-27 20:58:39','614','2022-08-27 22:13:33',10,0),('1','167',258024,'MORNING SHIFT','2022-08-28','2022-08-28 12:41:02','2022-08-29 12:41:02','570',494220.40,494220.40,'570','2022-08-28 13:10:39','614','2022-08-28 14:53:51',10,0),('1','167',258025,'AFTERNOON SHIFT','2022-08-28','2022-08-28 20:24:45','2022-08-29 20:24:45','570',1427872.80,1427872.80,'570','2022-08-28 20:36:27','614','2022-08-29 07:27:30',10,0),('1','167',258026,'MORNING SHIFT','2022-08-29','2022-08-29 13:58:12','2022-08-30 13:58:12','570',1310072.80,1310072.80,'570','2022-08-29 14:01:11','614','2022-08-29 15:38:20',10,0),('1','167',258027,'MORNING SHIFT','2022-08-29','2022-08-29 21:29:53','2022-08-30 21:29:53','570',3354086.60,3354086.60,'570','2022-08-29 21:33:38','614','2022-08-30 08:40:39',10,0),('1','167',258028,'MORNING SHIFT','2022-08-30','2022-08-30 09:45:58','2022-08-31 09:45:58','570',3459086.80,3459086.80,'570','2022-08-30 14:03:13','614','2022-08-30 14:27:21',10,0),('1','167',258029,'AFTERNOON SHIFT','2022-08-30','2022-08-30 21:13:30','2022-08-31 21:13:30','570',5947552.40,5947552.40,'570','2022-08-30 21:20:50','614','2022-08-30 23:41:38',10,0),('1','167',258030,'MORNING SHIFT','2022-08-31','2022-08-31 11:42:06','2022-09-01 11:42:06','570',3949774.20,3949774.20,'570','2022-08-31 14:25:10','614','2022-08-31 14:40:08',10,0),('1','167',258031,'AFTERNOON SHIFT','2022-08-31','2022-08-31 20:29:33','2022-09-01 20:29:33','570',3714505.20,3714505.20,'570','2022-08-31 21:43:19','614','2022-08-31 22:54:59',10,0),('1','167',258032,'MORNING SHIFT','2022-09-01','2022-09-01 13:40:19','2022-09-02 13:40:19','570',3046490.80,3046490.80,'570','2022-09-01 14:25:24','614','2022-09-01 14:30:20',10,0),('1','167',258033,'AFTERNOON SHIFT','2022-09-01','2022-09-01 20:48:48','2022-09-02 20:48:48','570',3685926.60,3685926.60,'570','2022-09-01 21:01:14','614','2022-09-01 22:29:17',10,0),('1','167',258034,'MORNING SHIFT','2022-09-02','2022-09-02 12:49:58','2022-09-03 12:49:58','570',1296578.60,1296578.60,'570','2022-09-02 13:30:32','614','2022-09-02 15:22:22',10,0),('1','167',258035,'AFTERNOON SHIFT','2022-09-02','2022-09-02 20:51:03','2022-09-03 20:51:03','570',1810162.80,1810162.80,'570','2022-09-02 21:01:55','614','2022-09-02 21:09:12',10,0),('1','167',258036,'MORNING SHIFT','2022-09-03','2022-09-03 11:38:58','2022-09-04 11:38:58','570',1402740.80,1402740.80,'570','2022-09-03 13:44:28','614','2022-09-03 14:29:44',10,0),('1','167',258037,'AFTERNOON SHIFT','2022-09-03','2022-09-03 21:02:56','2022-09-04 21:02:56','570',689640.20,689640.20,'570','2022-09-03 21:13:34','614','2022-09-04 00:08:50',10,0),('1','167',258038,'MORNING SHIFT','2022-09-04','2022-09-04 14:09:38','2022-09-05 14:09:38','570',1222655.00,1222655.00,'570','2022-09-04 14:24:34','614','2022-09-04 14:38:17',10,0),('1','167',258039,'AFTERNOON SHIFT','2022-09-04','2022-09-04 21:16:57','2022-09-05 21:16:57','570',1829289.60,1829289.60,'570','2022-09-04 21:40:58','614','2022-09-04 22:33:37',10,0),('1','167',258040,'MORNING SHIFT','2022-09-05','2022-09-05 08:10:46','2022-09-06 08:10:46','570',1451594.60,1451594.60,'570','2022-09-05 13:49:23','614','2022-09-05 14:46:51',10,0),('1','167',258041,'AFTERNOON SHIFT','2022-09-05','2022-09-05 20:57:54','2022-09-06 20:57:54','570',2111081.40,2111081.40,'570','2022-09-05 21:17:49','614','2022-09-05 21:35:37',10,0),('1','167',258042,'MORNING SHIFT','2022-09-06','2022-09-06 11:02:24','2022-09-07 11:02:24','570',1230125.40,1230125.40,'570','2022-09-06 14:45:26','614','2022-09-06 15:36:04',10,0),('1','167',258043,'AFTERNOON SHIFT','2022-09-06','2022-09-06 19:25:08','2022-09-07 19:25:08','570',2728564.80,2728564.80,'570','2022-09-06 21:38:46','614','2022-09-06 22:47:58',10,0),('1','167',258044,'MORNING SHIFT','2022-09-07','2022-09-07 12:11:50','2022-09-08 12:11:50','570',1466623.80,1466623.80,'570','2022-09-07 14:07:09','614','2022-09-07 16:17:57',10,0),('1','167',258045,'AFTERNOON SHIFT','2022-09-07','2022-09-07 21:06:20','2022-09-08 21:06:20','570',1912030.20,1912030.20,'570','2022-09-07 21:23:18','614','2022-09-07 23:31:05',10,0),('1','167',258046,'MORNING SHIFT','2022-09-08','2022-09-08 09:45:08','2022-09-09 09:45:08','570',1667541.60,1667541.60,'570','2022-09-08 14:02:17','614','2022-09-08 17:59:13',10,0),('1','167',258047,'AFTERNOON SHIFT','2022-09-08','2022-09-08 21:16:16','2022-09-09 21:16:16','570',2201266.80,2201266.80,'570','2022-09-08 21:40:35','614','2022-09-08 23:06:52',10,0),('1','167',258048,'MORNING SHIFT','2022-09-09','2022-09-09 09:37:46','2022-09-10 09:37:46','570',2269971.00,2269971.00,'570','2022-09-09 13:55:51','614','2022-09-09 15:51:38',10,0),('1','167',258049,'AFTERNOON SHIFT','2022-09-09','2022-09-09 20:50:11','2022-09-10 20:50:11','570',2002874.40,2002874.40,'570','2022-09-09 22:12:55','614','2022-09-10 15:25:09',10,0),('1','167',258050,'MORNING SHIFT','2022-09-10','2022-09-10 16:06:56','2022-09-11 16:06:56','570',1541883.60,1541883.60,'570','2022-09-10 16:29:25','614','2022-09-10 19:05:30',10,0),('1','167',258051,'AFTERNOON SHIFT','2022-09-10','2022-09-10 21:46:41','2022-09-11 21:46:41','570',2088138.60,2088138.60,'570','2022-09-10 21:55:11','614','2022-09-10 21:58:54',10,0),('1','167',258052,'MORNING SHIFT','2022-09-11','2022-09-11 10:33:29','2022-09-12 10:33:29','570',2168716.40,2168716.40,'570','2022-09-11 14:38:08','614','2022-09-11 14:41:29',10,0),('1','167',258053,'AFTERNOON SHIFT','2022-09-11','2022-09-11 21:04:56','2022-09-12 21:04:56','570',3828564.60,3828564.60,'570','2022-09-11 21:23:35','614','2022-09-11 21:52:32',10,0),('1','167',258054,'MORNING SHIFT','2022-09-12','2022-09-12 12:23:40','2022-09-13 12:23:40','570',2215548.80,2215548.80,'570','2022-09-12 14:02:14','614','2022-09-12 17:35:56',10,0),('1','167',258055,'AFTERNOON SHIFT','2022-09-12','2022-09-12 20:41:40','2022-09-13 20:41:40','570',2531870.20,2531870.20,'570','2022-09-12 20:56:16','614','2022-09-12 22:42:44',10,0),('1','167',258056,'MORNING SHIFT','2022-09-13','2022-09-13 10:10:43','2022-09-14 10:10:43','570',2447967.20,2447967.20,'570','2022-09-13 13:44:46','614','2022-09-13 14:41:18',10,0),('1','167',258057,'AFTERNOON SHIFT','2022-09-13','2022-09-13 20:16:10','2022-09-14 20:16:10','570',1372608.80,1372608.80,'570','2022-09-13 20:42:41','614','2022-09-13 23:45:59',10,0),('1','167',258058,'MORNING SHIFT','2022-09-14','2022-09-14 12:24:32','2022-09-15 12:24:32','570',2010184.80,2010184.80,'570','2022-09-14 13:14:34','614','2022-09-14 15:55:17',10,0),('1','167',258059,'AFTERNOON SHIFT','2022-09-14','2022-09-14 21:06:36','2022-09-15 21:06:36','570',2119070.00,2119070.00,'570','2022-09-14 21:07:54','614','2022-09-15 07:04:56',10,0),('1','167',258060,'MORNING SHIFT','2022-09-15','2022-09-15 14:05:07','2022-09-16 14:05:07','570',2227960.60,2227960.60,'570','2022-09-15 14:14:19','614','2022-09-15 14:57:47',10,0),('1','167',258061,'AFTERNOON SHIFT','2022-09-15','2022-09-15 21:15:49','2022-09-16 21:15:49','570',3462369.20,3462369.20,'570','2022-09-15 21:23:18','614','2022-09-15 23:26:33',10,0),('1','167',258062,'MORNING SHIFT','2022-09-16','2022-09-16 09:38:54','2022-09-17 09:38:54','570',3226430.40,3226430.40,'570','2022-09-16 13:55:21','614','2022-09-16 14:26:58',10,0),('1','167',258063,'AFTERNOON SHIFT','2022-09-16','2022-09-16 19:20:03','2022-09-17 19:20:03','570',3482562.40,3482562.40,'570','2022-09-16 22:19:53','614','2022-09-16 22:29:15',10,0),('1','167',258064,'MORNING SHIFT','2022-09-17','2022-09-17 06:46:47','2022-09-18 06:46:47','570',2878670.60,2878670.60,'570','2022-09-17 14:10:00','614','2022-09-17 14:24:52',10,0),('1','167',258065,'AFTERNOON SHIFT','2022-09-17','2022-09-17 20:53:51','2022-09-18 20:53:51','570',3097199.60,3097199.60,'570','2022-09-17 21:16:10','614','2022-09-17 23:05:44',10,0),('1','167',258066,'MORNING SHIFT','2022-09-18','2022-09-18 14:30:53','2022-09-19 14:30:53','570',5443672.00,5443672.00,'570','2022-09-18 14:40:29','614','2022-09-18 15:06:00',10,0),('1','167',258067,'AFTERNOON SHIFT','2022-09-18','2022-09-18 21:36:41','2022-09-19 21:36:41','570',3253176.20,3253176.20,'570','2022-09-18 21:44:02','614','2022-09-18 23:26:24',10,0),('1','167',258068,'MORNING SHIFT','2022-09-19','2022-09-19 13:59:51','2022-09-20 13:59:51','570',4654990.40,4654990.40,'570','2022-09-19 14:09:23','614','2022-09-19 20:15:48',10,0),('1','167',258069,'AFTERNOON SHIFT','2022-09-19','2022-09-19 21:03:32','2022-09-20 21:03:32','570',3838278.20,3838278.20,'570','2022-09-19 21:29:51','614','2022-09-20 07:48:28',10,0),('1','167',258070,'MORNING SHIFT','2022-09-20','2022-09-20 14:35:41','2022-09-21 14:35:41','570',2698366.20,2698366.20,'570','2022-09-20 15:16:52','614','2022-09-20 15:25:07',10,0),('1','167',258071,'AFTERNOON SHIFT','2022-09-20','2022-09-20 20:09:43','2022-09-21 20:09:43','570',1869676.00,1869676.00,'570','2022-09-20 20:11:10','614','2022-09-20 21:41:51',10,0),('1','167',258072,'MORNING SHIFT','2022-09-21','2022-09-21 12:54:31','2022-09-22 12:54:31','570',2409367.40,2409367.40,'570','2022-09-21 13:52:41','614','2022-09-21 14:52:17',10,0),('1','167',258073,'AFTERNOON SHIFT','2022-09-21','2022-09-21 21:20:15','2022-09-22 21:20:15','570',3622142.80,3622142.80,'570','2022-09-21 21:31:19','614','2022-09-21 22:49:05',10,0),('1','167',258074,'MORNING SHIFT','2022-09-22','2022-09-22 10:49:37','2022-09-23 10:49:37','570',3848996.60,3848996.60,'570','2022-09-22 13:54:21','614','2022-09-22 13:54:46',10,0),('1','167',258075,'AFTERNOON SHIFT','2022-09-22','2022-09-22 20:54:36','2022-09-23 20:54:36','570',3765549.20,3765549.20,'570','2022-09-22 21:03:18','614','2022-09-22 22:28:53',10,0),('1','167',258076,'MORNING SHIFT','2022-09-23','2022-09-23 13:26:27','2022-09-24 13:26:27','570',3500237.60,3500237.60,'570','2022-09-23 13:51:55','614','2022-09-23 14:55:48',10,0),('1','167',258077,'AFTERNOON SHIFT','2022-09-23','2022-09-23 21:15:06','2022-09-24 21:15:06','570',808719.00,808719.00,'570','2022-09-23 21:18:49','614','2022-09-24 07:08:15',10,0),('1','167',258078,'AFTERNOON SHIFT','2022-09-24','2022-09-24 21:04:17','2022-09-25 21:04:17','570',3951735.60,3951735.60,'570','2022-09-24 21:18:40','614','2022-09-24 22:03:06',10,0),('1','167',258079,'MORNING SHIFT','2022-09-25','2022-09-25 13:48:44','2022-09-26 13:48:44','570',507134.60,507134.60,'570','2022-09-25 13:51:14','614','2022-09-25 14:11:38',10,0),('1','167',258080,'AFTERNOON SHIFT','2022-09-27','2022-09-27 18:45:44','2022-09-28 18:45:44','570',578762.80,578762.80,'570','2022-09-27 18:46:46','614','2022-09-27 22:02:55',10,0),('1','167',258081,'MORNING SHIFT','2022-09-29','2022-09-29 08:57:31','2022-09-30 08:57:31','570',166903.60,166903.60,'570','2022-09-29 09:38:38','614','2022-09-29 12:56:07',10,0),('1','167',258082,'AFTERNOON SHIFT','2022-09-29','2022-09-29 21:47:58','2022-09-30 21:47:58','570',2651323.50,2651323.50,'570','2022-09-29 21:55:38','614','2022-09-30 12:34:04',10,0),('1','167',258083,'MORNING SHIFT','2022-09-30','2022-09-30 13:06:29','2022-10-01 13:06:29','570',1559142.00,1559142.00,'570','2022-09-30 13:45:20','614','2022-09-30 15:03:47',10,0),('1','167',258084,'AFTERNOON SHIFT','2022-09-30','2022-09-30 21:02:07','2022-10-01 21:02:07','570',1847427.00,1847427.00,'570','2022-09-30 21:04:19','614','2022-09-30 22:30:06',10,0),('1','167',258085,'MORNING SHIFT','2022-10-01','2022-10-01 14:06:50','2022-10-02 14:06:50','570',1411365.60,1411365.60,'570','2022-10-01 14:08:33','614','2022-10-01 15:48:34',10,0),('1','167',258086,'AFTERNOON SHIFT','2022-10-01','2022-10-01 20:19:16','2022-10-02 20:19:16','570',1171803.60,1171803.60,'570','2022-10-01 21:36:49','614','2022-10-01 22:36:47',10,0),('1','167',258087,'AFTERNOON SHIFT','2022-10-02','2022-10-02 21:03:09','2022-10-03 21:03:09','570',2308751.90,2308751.90,'570','2022-10-02 21:17:46','614','2022-10-02 22:19:35',10,0),('1','167',258088,'MORNING SHIFT','2022-10-03','2022-10-03 13:22:19','2022-10-04 13:22:19','570',1455366.20,1455366.20,'570','2022-10-03 13:50:18','614','2022-10-03 15:02:31',10,0),('1','167',258089,'AFTERNOON SHIFT','2022-10-03','2022-10-03 20:48:59','2022-10-04 20:48:59','570',1685614.70,1685614.70,'570','2022-10-03 20:50:32','614','2022-10-03 22:34:18',10,0),('1','167',258090,'MORNING SHIFT','2022-10-04','2022-10-04 12:45:35','2022-10-05 12:45:35','570',1447022.50,1447022.50,'570','2022-10-04 13:56:21','614','2022-10-04 14:29:25',10,0),('1','167',258091,'AFTERNOON SHIFT','2022-10-04','2022-10-04 20:03:54','2022-10-05 20:03:54','570',2105857.60,2105857.60,'570','2022-10-04 20:54:02','614','2022-10-04 23:11:09',10,0),('1','167',258092,'MORNING SHIFT','2022-10-05','2022-10-05 08:40:58','2022-10-06 08:40:58','570',265881.00,265881.00,'570','2022-10-05 08:43:43','614','2022-10-05 14:07:58',10,0),('1','167',258093,'MORNING SHIFT ll','2022-10-05','2022-10-05 14:14:27','2022-10-06 14:14:27','570',1533043.20,1533043.20,'570','2022-10-05 14:23:32','614','2022-10-05 15:30:02',10,0),('1','167',258094,'AFTERNOON SHIFT','2022-10-05','2022-10-05 20:08:59','2022-10-06 20:08:59','570',821496.00,821496.00,'570','2022-10-05 20:13:16','614','2022-10-05 22:39:47',10,0),('1','167',258095,'MORNING SHIFT','2022-10-06','2022-10-06 09:23:20','2022-10-07 09:23:20','570',1214928.00,1214928.00,'570','2022-10-06 13:44:43','614','2022-10-06 16:52:02',10,0),('1','167',258096,'AFTERNOON SHIFT','2022-10-06','2022-10-06 20:42:14','2022-10-07 20:42:14','570',1013781.60,1013781.60,'570','2022-10-06 20:43:15','614','2022-10-06 22:45:27',10,0),('1','167',258097,'MORNING SHIFT','2022-10-07','2022-10-07 13:32:26','2022-10-08 13:32:26','570',1860635.40,1860635.40,'570','2022-10-07 13:42:26','614','2022-10-07 16:01:20',10,0),('1','167',258098,'AFTERNOON SHIFT15','2022-10-07','2022-10-07 20:08:37','2022-10-08 20:08:37','570',1476461.40,1476461.40,'570','2022-10-07 21:49:31','614','2022-10-07 22:53:19',10,0),('1','167',258099,'MORNING SHIFT','2022-10-08','2022-10-08 11:26:18','2022-10-09 11:26:18','570',2756325.00,2756325.00,'570','2022-10-08 13:41:50','614','2022-10-08 14:58:25',10,0),('1','167',258100,'AFTERNOON SHIFT','2022-10-08','2022-10-08 20:31:00','2022-10-09 20:31:00','570',2088465.60,2088465.60,'570','2022-10-08 20:32:57','614','2022-10-08 23:52:40',10,0),('1','167',258101,'MORNING SHIFT','2022-10-09','2022-10-09 09:36:03','2022-10-10 09:36:03','570',2123316.00,2123316.00,'570','2022-10-09 13:53:29','614','2022-10-09 14:02:41',10,0),('1','167',258102,'AFTERNOON SHIFT','2022-10-09','2022-10-09 20:49:09','2022-10-10 20:49:09','570',2031915.60,2031915.60,'570','2022-10-09 20:50:34','614','2022-10-09 22:14:52',10,0),('1','167',258103,'MORNING SHIFT','2022-10-10','2022-10-10 09:31:05','2022-10-11 09:31:05','570',941600.40,941600.40,'570','2022-10-10 13:21:48','614','2022-10-10 14:37:52',10,0),('1','167',258104,'AFTERNOON SHIFT','2022-10-10','2022-10-10 21:03:34','2022-10-11 21:03:34','570',3541324.80,3541324.80,'570','2022-10-10 21:05:22','614','2022-10-10 22:23:33',10,0),('1','167',258105,'MORNING SHIFT','2022-10-11','2022-10-11 13:28:41','2022-10-12 13:28:41','570',2793476.40,2793476.40,'570','2022-10-11 17:55:29','614','2022-10-11 21:49:22',10,0),('1','167',258106,'AFTERNOON SHIFT','2022-10-18','2022-10-18 20:35:31','2022-10-19 20:35:31','570',457200.00,457200.00,'570','2022-10-18 22:24:00','614','2022-10-18 23:41:45',10,0),('1','167',258107,'MORNING SHIFT','2022-10-19','2022-10-19 13:46:07','2022-10-20 13:46:07','570',3622150.00,3622150.00,'570','2022-10-19 14:30:45','614','2022-10-19 14:37:40',10,0),('1','167',258108,'AFTERNOON SHIFT','2022-10-19','2022-10-19 14:55:38','2022-10-20 14:55:38','570',2477904.60,2477904.60,'570','2022-10-19 20:41:38','614','2022-10-19 21:59:04',10,0),('1','167',258109,'MORNING SHIFT','2022-10-20','2022-10-20 12:20:19','2022-10-21 12:20:19','570',3113590.60,3113590.60,'570','2022-10-20 13:56:29','614','2022-10-20 16:01:42',10,0),('1','167',258110,'AFTERNOON SHIFT','2022-10-20','2022-10-20 16:17:20','2022-10-21 16:17:20','570',2966262.00,2966262.00,'570','2022-10-20 21:38:56','614','2022-10-20 22:43:23',10,0),('1','167',258111,'MORNING SHIFT','2022-10-21','2022-10-21 09:57:01','2022-10-22 09:57:01','570',2815380.60,2815380.60,'570','2022-10-21 15:11:56','614','2022-10-21 16:25:55',10,0),('1','167',258112,'AFTERNOON SHIFT','2022-10-21','2022-10-21 20:02:15','2022-10-22 20:02:15','570',2065741.60,2065741.60,'570','2022-10-21 20:06:59','614','2022-10-21 23:21:06',10,0),('1','167',258113,'MORNING SHIFT','2022-10-22','2022-10-22 11:57:48','2022-10-23 11:57:48','570',2140203.60,2140203.60,'570','2022-10-22 13:57:10','614','2022-10-22 14:38:47',10,0),('1','167',258114,'MORNING SHIFT','2022-10-22','2022-10-22 20:36:57','2022-10-23 20:36:57','570',2495864.60,2495864.60,'570','2022-10-22 20:41:47','614','2022-10-22 22:25:38',10,0),('1','167',258115,'MORNING SHIFT','2022-10-23','2022-10-23 13:47:37','2022-10-24 13:47:37','570',3240237.80,3240237.80,'570','2022-10-23 13:51:07','614','2022-10-23 14:16:49',10,0),('1','167',258116,'AFTERNOON SHIFT','2022-10-23','2022-10-23 21:25:58','2022-10-24 21:25:58','570',879344.00,879344.00,'570','2022-10-23 21:27:14','614','2022-10-23 21:43:37',10,0),('1','167',258117,'MORNING SHIFT','2022-10-24','2022-10-24 10:38:20','2022-10-25 10:38:20','570',1663984.00,1663984.00,'570','2022-10-24 15:34:09','614','2022-10-24 20:47:51',10,0),('1','167',258118,'AFTERNOON SHIFT','2022-10-24','2022-10-24 21:18:54','2022-10-25 21:18:54','570',985832.00,985832.00,'570','2022-10-24 21:21:13','614','2022-10-24 21:42:21',10,0),('1','167',258119,'MORNING SHIFT','2022-10-25','2022-10-25 09:17:31','2022-10-26 09:17:31','570',862176.00,862176.00,'570','2022-10-25 13:44:01','614','2022-10-25 14:34:43',10,0),('1','167',258120,'AFTERNOON SHIFT','2022-10-25','2022-10-25 20:42:29','2022-10-26 20:42:29','570',1808408.00,1808408.00,'570','2022-10-25 20:44:25','614','2022-10-25 21:36:47',10,0),('1','167',258121,'MORNING SHIFT','2022-10-26','2022-10-26 11:20:58','2022-10-27 11:20:58','570',1421088.00,1421088.00,'570','2022-10-26 13:25:52','614','2022-10-26 14:52:44',10,0),('1','167',258122,'AFTERNOON SHIFT','2022-10-26','2022-10-26 20:21:25','2022-10-27 20:21:25','570',1232144.00,1232144.00,'570','2022-10-26 20:29:21','614','2022-10-27 02:00:24',10,0),('1','167',258123,'MORNING SHIFT','2022-10-27','2022-10-27 12:12:46','2022-10-28 12:12:46','570',1101656.00,1101656.00,'570','2022-10-27 13:53:15','614','2022-10-27 14:50:43',10,0),('1','167',258124,'AFTERNOON SHIFT','2022-10-27','2022-10-27 18:25:19','2022-10-28 18:25:19','570',1564344.00,1564344.00,'570','2022-10-27 21:05:10','614','2022-10-27 22:02:17',10,0),('1','167',258125,'MORNING SHIFT','2022-10-28','2022-10-28 13:24:14','2022-10-29 13:24:14','570',1115112.00,1115112.00,'570','2022-10-28 13:25:34','614','2022-10-28 16:55:39',10,0),('1','167',258126,'AFTERNOON SHIFT','2022-10-28','2022-10-28 19:05:48','2022-10-29 19:05:48','570',1219800.00,1219800.00,'570','2022-10-28 20:44:07','614','2022-10-28 20:45:06',10,0),('1','167',258127,'MORNING SHIFT','2022-10-29','2022-10-29 09:30:43','2022-10-30 09:30:43','570',873128.00,873128.00,'570','2022-10-29 13:15:00','614','2022-10-29 14:52:00',10,0),('1','167',258128,'AFTERNOON SHIFT','2022-10-29','2022-10-29 20:28:36','2022-10-30 20:28:36','570',1143712.00,1143712.00,'570','2022-10-29 20:30:01','614','2022-10-29 22:14:04',10,0),('1','167',258129,'MORNING SHIFT','2022-10-30','2022-10-30 10:20:36','2022-10-31 10:20:36','570',2175336.00,2175336.00,'570','2022-10-30 13:17:31','614','2022-10-30 14:28:34',10,0),('1','167',258130,'MORNING SHIFT','2022-10-31','2022-10-31 10:34:59','2022-11-01 10:34:59','570',2175280.00,2175280.00,'570','2022-10-31 12:54:21','614','2022-10-31 15:00:29',10,0),('1','167',258131,'AFTERNOON SHIFT','2022-10-31','2022-10-31 20:02:22','2022-11-01 20:02:22','570',353393.20,353393.20,'570','2022-10-31 20:15:58','614','2022-10-31 22:33:09',10,0),('1','167',258132,'MORNING SHIFT','2022-11-05','2022-11-05 12:14:30','2022-11-06 12:14:30','570',1795760.00,1795760.00,'570','2022-11-05 18:23:27','614','2022-11-05 23:26:46',10,0),('1','167',258133,'AFTERNOON SHIFT','2022-11-06','2022-11-06 08:00:46','2022-11-07 08:00:46','570',908208.00,908208.00,'570','2022-11-06 08:02:44','614','2022-11-06 17:29:16',10,0),('1','167',258134,'MORNING SHIFT','2022-11-06','2022-11-06 17:34:51','2022-11-07 17:34:51','570',2118720.00,2118720.00,'570','2022-11-06 17:36:40','614','2022-11-06 19:50:39',10,0),('1','167',258135,'AFTERNOON SHIFT','2022-11-06','2022-11-06 20:30:35','2022-11-07 20:30:35','570',952031.20,952031.20,'570','2022-11-06 20:40:49','614','2022-11-06 23:49:30',10,0),('1','167',258136,'MORNING SHIFT','2022-11-07','2022-11-07 13:13:12','2022-11-08 13:13:12','570',781752.00,781752.00,'570','2022-11-07 13:19:07','614','2022-11-07 17:26:36',10,0),('1','167',258137,'AFTERNOON SHIFT','2022-11-07','2022-11-07 20:07:32','2022-11-08 20:07:32','570',1367304.00,1367304.00,'570','2022-11-07 20:08:44','614','2022-11-07 23:13:30',10,0),('1','167',258138,'MORNING SHIFT','2022-11-08','2022-11-08 10:14:00','2022-11-09 10:14:00','570',1895008.00,1895008.00,'570','2022-11-08 13:30:04','614','2022-11-08 16:30:18',10,0),('1','167',258139,'AFTERNOON SHIFT','2022-11-08','2022-11-08 20:16:34','2022-11-09 20:16:34','570',722384.00,722384.00,'570','2022-11-08 20:17:39','614','2022-11-08 20:47:45',10,0),('1','167',258140,'MORNING SHIFT','2022-11-09','2022-11-09 08:43:03','2022-11-10 08:43:03','570',2754431.05,2754431.05,'570','2022-11-09 14:23:46','614','2022-11-09 17:51:09',10,0),('1','167',258141,'AFTERNOON SHIFT','2022-11-09','2022-11-09 21:01:09','2022-11-10 21:01:09','570',5904849.30,5904849.30,'570','2022-11-09 21:06:52','614','2022-11-09 23:27:44',10,0),('1','167',258142,'MORNING SHIFT','2022-11-10','2022-11-10 10:47:02','2022-11-11 10:47:02','570',2921808.00,2921808.00,'570','2022-11-10 12:16:45','614','2022-11-10 13:37:01',10,0),('1','167',258143,'MORNING SHIFT 2','2022-11-10','2022-11-10 14:31:44','2022-11-11 14:31:44','570',3274865.70,3274865.70,'570','2022-11-10 14:50:10','614','2022-11-10 14:52:18',10,0),('1','167',258144,'AFTERNOON SHIFT','2022-11-10','2022-11-10 21:13:39','2022-11-11 21:13:39','570',1434369.75,1434369.75,'570','2022-11-10 21:25:20','614','2022-11-11 00:44:47',10,0),('1','167',258145,'MORNING SHIFT','2022-11-11','2022-11-11 11:23:32','2022-11-12 11:23:32','570',3425629.95,3425629.95,'570','2022-11-11 13:42:21','614','2022-11-11 16:32:58',10,0),('1','167',258146,'AFTERNOON SHIFT','2022-11-11','2022-11-11 20:23:59','2022-11-12 20:23:59','570',1160922.60,1160922.60,'570','2022-11-11 20:27:05','614','2022-11-11 23:52:46',10,0),('1','167',258147,'MORNING SHIFT','2022-11-12','2022-11-12 12:31:39','2022-11-13 12:31:39','570',480654.00,480654.00,'570','2022-11-12 13:21:19','614','2022-11-12 14:27:06',10,0),('1','167',258148,'AFTERNOON SHIFT','2022-11-12','2022-11-12 20:00:59','2022-11-13 20:00:59','570',1445548.20,1445548.20,'570','2022-11-12 20:17:18','614','2022-11-13 07:50:00',10,0),('1','167',258149,'MORNING SHIFT','2022-11-13','2022-11-13 11:47:53','2022-11-14 11:47:53','570',2483594.00,2483594.00,'570','2022-11-13 15:29:44','614','2022-11-13 23:28:03',10,0),('1','167',258150,'AFTERNOON SHIFT','2022-11-14','2022-11-14 20:12:05','2022-11-15 20:12:05','570',1825642.40,1825642.40,'570','2022-11-14 20:37:57','614','2022-11-15 06:24:23',10,0),('1','167',258151,'MORNING SHIFT','2022-11-15','2022-11-15 13:10:39','2022-11-16 13:10:39','570',1258945.40,1258945.40,'570','2022-11-15 13:43:39','614','2022-11-15 18:54:30',10,0),('1','167',258152,'AFTERNOON SHIFT','2022-11-15','2022-11-15 20:19:03','2022-11-16 20:19:03','570',1295203.00,1295203.00,'570','2022-11-15 20:20:09','614','2022-11-15 20:50:34',10,0),('1','167',258153,'MORNING SHIFT','2022-11-16','2022-11-16 12:54:03','2022-11-17 12:54:03','570',1631235.25,1631235.25,'570','2022-11-16 13:24:59','614','2022-11-16 17:06:20',10,0),('1','167',258154,'AFTERNOON SHIFT','2022-11-16','2022-11-16 20:17:11','2022-11-17 20:17:11','570',1425342.10,1425342.10,'570','2022-11-16 20:20:06','614','2022-11-17 06:05:11',10,0),('1','167',258155,'MORNING SHIFT','2022-11-17','2022-11-17 12:58:22','2022-11-18 12:58:22','570',1209210.75,1209210.75,'570','2022-11-17 13:47:30','975','2022-11-17 17:32:55',10,0),('1','167',258156,'AFTERNOON SHIFT','2022-11-17','2022-11-17 19:48:03','2022-11-18 19:48:03','570',2057005.50,2057005.50,'570','2022-11-17 19:49:38','614','2022-11-17 20:44:59',10,0),('1','167',258157,'MORNING SHIFT','2022-11-18','2022-11-18 12:41:28','2022-11-19 12:41:28','570',1026093.75,1026093.75,'570','2022-11-18 13:32:03','614','2022-11-18 15:50:08',10,0),('1','167',258158,'AFTERNOON SHIFT','2022-11-18','2022-11-18 18:07:18','2022-11-19 18:07:18','570',1407474.75,1407474.75,'570','2022-11-18 18:08:49','614','2022-11-18 21:33:13',10,0),('1','167',258159,'AFTERNOON SHIFT ll','2022-11-19','2022-11-19 09:24:31','2022-11-20 09:24:31','570',601498.80,601498.80,'570','2022-11-19 09:25:52','614','2022-11-19 12:34:15',10,0),('1','167',258160,'MORNING SHIFT','2022-11-19','2022-11-19 13:16:24','2022-11-20 13:16:24','570',910316.40,910316.40,'570','2022-11-19 13:25:29','975','2022-11-19 13:27:07',10,0),('1','167',258161,'AFTERNOON SHIFT','2022-11-19','2022-11-19 17:55:45','2022-11-20 17:55:45','570',1510126.80,1510126.80,'570','2022-11-19 21:18:15','614','2022-11-19 23:40:30',10,0),('1','167',258162,'MORNING SHIFT','2022-11-20','2022-11-20 10:33:42','2022-11-21 10:33:42','570',2441812.80,2441812.80,'570','2022-11-20 13:57:43','614','2022-11-20 15:45:05',10,0),('1','167',258163,'AFTERNOON SHIFT','2022-11-20','2022-11-20 20:17:41','2022-11-21 20:17:41','570',1276447.20,1276447.20,'570','2022-11-20 20:18:39','614','2022-11-20 23:04:39',10,0),('1','167',258164,'MORNING SHIFT','2022-11-21','2022-11-21 09:24:30','2022-11-22 09:24:30','570',1855350.00,1855350.00,'570','2022-11-21 13:19:05','614','2022-11-21 15:51:55',10,0),('1','167',258165,'AFTERNOON SHIFT','2022-11-21','2022-11-21 21:02:27','2022-11-22 21:02:27','570',3604792.80,3604792.80,'570','2022-11-21 21:04:37','614','2022-11-21 21:44:29',10,0),('1','167',258166,'MORNING SHIFT','2022-11-22','2022-11-22 12:57:34','2022-11-23 12:57:34','570',1530253.20,1530253.20,'570','2022-11-22 14:02:06','614','2022-11-22 16:37:46',10,0),('1','167',258167,'MORNING SHIFT','2022-11-23','2022-11-23 12:47:32','2022-11-24 12:47:32','570',2958832.80,2958832.80,'570','2022-11-23 13:14:39','614','2022-11-23 14:37:58',10,0),('1','167',258168,'MORNING SHIFT','2022-11-24','2022-11-24 14:18:38','2022-11-25 14:18:38','570',515894.40,515894.40,'570','2022-11-24 14:21:27','614','2022-11-24 14:54:24',10,0),('1','167',258169,'AFTERNOON SHIFT','2022-11-24','2022-11-24 20:01:20','2022-11-25 20:01:20','570',1221677.00,1221677.00,'570','2022-11-24 20:02:24','614','2022-11-24 23:26:57',10,0),('1','167',258170,'MORNING SHIFT','2022-11-26','2022-11-26 13:20:50','2022-11-27 13:20:50','570',4108267.60,4108267.60,'570','2022-11-26 13:23:58','614','2022-11-26 16:29:00',10,0),('1','167',258171,'MORNING SHIFT','2022-11-27','2022-11-27 12:36:59','2022-11-28 12:36:59','570',2297398.50,2297398.50,'570','2022-11-27 13:53:28','614','2022-11-27 14:18:04',10,0),('1','167',258172,'AFTERNOON SHIFT','2022-11-27','2022-11-27 19:19:19','2022-11-28 19:19:19','570',2318870.60,2318870.60,'570','2022-11-27 19:21:48','614','2022-11-27 21:56:30',10,0),('1','167',258173,'MORNING SHIFT','2022-11-28','2022-11-28 14:10:06','2022-11-29 14:10:06','570',304933.70,304933.70,'570','2022-11-28 14:17:06','614','2022-11-28 17:59:34',10,0),('1','167',258174,'AFTERNOON SHIFT','2022-11-28','2022-11-28 20:28:32','2022-11-29 20:28:32','570',1799274.00,1799274.00,'570','2022-11-28 20:30:12','614','2022-11-29 12:15:03',10,0),('1','167',258175,'MORNING SHIFT','2022-11-29','2022-11-29 12:43:55','2022-11-30 12:43:55','570',1067977.60,1067977.60,'570','2022-11-29 14:13:46','614','2022-11-29 16:33:47',10,0),('1','167',258176,'AFTERNOON SHIFT','2022-11-29','2022-11-29 20:07:42','2022-11-30 20:07:42','570',0.00,0.00,'570','2022-11-29 20:16:38','614','2022-11-29 20:17:22',10,0),('1','167',258177,'AFTERNOON SHIFT','2022-11-29','2022-11-29 20:27:56','2022-11-30 20:27:56','570',1753012.80,1753012.80,'570','2022-11-29 20:29:49','614','2022-11-29 22:32:37',10,0),('1','167',258178,'MORNING SHIFT','2022-11-30','2022-11-30 13:12:01','2022-12-01 13:12:01','570',418513.20,418513.20,'570','2022-11-30 13:44:50','614','2022-11-30 15:36:59',10,0),('1','167',258179,'AFTERNOON SHIFT','2022-11-30','2022-11-30 20:24:37','2022-12-01 20:24:37','570',1300807.20,1300807.20,'570','2022-11-30 20:39:52','975','2022-12-01 13:44:17',10,0),('1','167',258180,'MORNING SHIFT','2022-12-01','2022-12-01 13:50:18','2022-12-02 13:50:18','570',1389200.40,1389200.40,'570','2022-12-01 13:53:49','975','2022-12-02 10:37:38',10,0),('1','167',258181,'MORNING SHIFT','2022-12-02','2022-12-02 11:43:16','2022-12-03 11:43:16','570',1347813.60,1347813.60,'570','2022-12-02 11:45:34','975','2022-12-02 15:39:16',10,0),('1','167',258182,'AFTERNOON SHIFT','2022-12-03','2022-12-03 21:57:14','2022-12-04 21:57:14','570',1979751.70,1979751.70,'570','2022-12-03 22:04:23','975','2022-12-04 08:41:43',10,0),('1','167',258183,'MORNING SHIFT','2022-12-04','2022-12-04 14:39:03','2022-12-05 14:39:03','570',859689.60,859689.60,'570','2022-12-04 14:41:50','975','2022-12-05 05:54:04',10,0),('1','167',258184,'MORNING SHIFT','2022-12-05','2022-12-05 12:09:23','2022-12-06 12:09:23','570',795009.60,795009.60,'570','2022-12-05 14:32:24','975','2022-12-05 17:55:10',10,0),('1','167',258185,'AFTERNOON SHIFT','2022-12-05','2022-12-05 20:24:40','2022-12-06 20:24:40','570',1925308.00,1925308.00,'570','2022-12-05 20:25:44','975','2022-12-06 11:52:21',10,0),('1','167',258186,'MORNING SHIFT','2022-12-06','2022-12-06 13:51:00','2022-12-07 13:51:00','570',437333.60,437333.60,'570','2022-12-06 13:52:40','975','2022-12-06 15:21:42',10,0),('1','167',258187,'MORNING SHIFT ll','2022-12-06','2022-12-06 15:26:29','2022-12-07 15:26:29','570',757020.00,757020.00,'570','2022-12-06 15:27:52','975','2022-12-06 20:27:36',10,0),('1','167',258188,'AFTERNOON SHIFT','2022-12-06','2022-12-06 22:37:37','2022-12-07 22:37:37','570',0.00,0.00,'975','2022-12-06 22:45:10','975','2022-12-06 22:45:31',10,0),('1','167',258189,'AFTERNOON SHIFT','2022-12-06','2022-12-06 22:50:47','2022-12-07 22:50:47','570',1083272.40,1083272.40,'570','2022-12-06 22:52:32','975','2022-12-07 11:11:18',10,0),('1','167',258190,'MORNING SHIFT','2022-12-07','2022-12-07 15:29:35','2022-12-08 15:29:35','570',1351534.80,1351534.80,'570','2022-12-07 15:32:18','975','2022-12-08 10:24:10',10,0),('1','167',258191,'AFTERNOON SHIFT','2022-12-07','2022-12-08 12:28:52','2022-12-09 12:28:52','570',2633072.40,2633072.40,'570','2022-12-08 12:32:41','975','2022-12-08 15:30:30',10,0),('1','167',258192,'MORNING SHIFT','2022-12-08','2022-12-08 15:36:58','2022-12-09 15:36:58','570',1567608.00,1567608.00,'570','2022-12-08 15:38:51','975','2022-12-09 09:12:15',10,0),('1','167',258193,'AFTERNOON SHIFT','2022-12-08','2022-12-09 09:38:22','2022-12-10 09:38:22','570',851844.00,851844.00,'570','2022-12-09 09:41:33','975','2022-12-09 18:01:32',10,0),('1','167',258194,'MORNING SHIFT','2022-12-09','2022-12-09 18:14:40','2022-12-10 18:14:40','570',2528416.80,2528416.80,'570','2022-12-09 18:16:21','975','2022-12-10 14:04:26',10,0),('1','167',258195,'AFTERNOON SHIFT','2022-12-09','2022-12-10 15:13:38','2022-12-11 15:13:38','570',1088488.80,1088488.80,'570','2022-12-10 15:15:35','975','2022-12-11 07:55:50',10,0),('1','167',258196,'MORNING SHIFT','2022-12-10','2022-12-11 10:12:02','2022-12-12 10:12:02','570',804199.20,804199.20,'570','2022-12-11 10:13:09','975','2022-12-11 12:10:57',10,0),('1','167',258197,'AFTERNOON SHIFT','2022-12-10','2022-12-11 16:25:57','2022-12-12 16:25:57','570',3162684.00,3162684.00,'570','2022-12-11 16:27:19','975','2022-12-12 08:34:00',10,0),('1','167',258198,'MORNING SHIFT','2022-12-11','2022-12-12 11:36:35','2022-12-13 11:36:35','570',3288213.60,3288213.60,'570','2022-12-12 11:38:12','975','2022-12-12 13:16:19',10,0),('1','167',258199,'AFTERNOON SHIFT','2022-12-11','2022-12-12 13:56:42','2022-12-13 13:56:42','570',2460133.20,2460133.20,'570','2022-12-12 14:02:50','975','2022-12-12 20:16:57',10,0),('1','167',258200,'MORNING SHIFT','2022-12-12','2022-12-12 20:28:27','2022-12-13 20:28:27','570',1413064.80,1413064.80,'570','2022-12-12 20:31:08','975','2022-12-13 10:24:00',10,0),('1','167',258201,'AFTERNOON SHIFT','2022-12-12','2022-12-13 11:10:34','2022-12-14 11:10:34','570',3352969.20,3352969.20,'570','2022-12-13 11:11:52','975','2022-12-13 15:35:01',10,0),('1','167',258202,'MORNING SHIFT','2022-12-13','2022-12-13 17:46:09','2022-12-14 17:46:09','570',1819246.80,1819246.80,'570','2022-12-13 17:48:18','975','2022-12-14 12:49:25',10,0),('1','167',258203,'AFTERNOON SHIFT','2022-12-13','2022-12-14 12:59:11','2022-12-15 12:59:11','570',5839453.20,5839453.20,'570','2022-12-14 13:00:24','975','2022-12-14 16:37:07',10,0),('1','167',258204,'MORNING SHIFT','2022-12-14','2022-12-14 19:25:23','2022-12-15 19:25:23','570',653478.00,653478.00,'570','2022-12-14 19:28:47','975','2022-12-14 20:49:58',10,0),('1','167',258205,'AFTERNOON SHIFT','2022-12-14','2022-12-14 20:58:52','2022-12-15 20:58:52','570',1565216.00,1565216.00,'570','2022-12-14 21:00:53','975','2022-12-15 10:59:30',10,0),('1','167',258206,'MORNING SHIFT','2022-12-15','2022-12-15 13:46:12','2022-12-16 13:46:12','570',1148401.80,1148401.80,'570','2022-12-15 13:55:19','975','2022-12-15 17:29:52',10,0),('1','167',258207,'AFTERNOON SHIFT','2022-12-15','2022-12-15 20:38:51','2022-12-16 20:38:51','570',1931764.20,1931764.20,'570','2022-12-15 20:42:56','975','2022-12-16 14:07:51',10,0),('1','167',258208,'MORNING SHIFT','2022-12-16','2022-12-16 14:56:42','2022-12-17 14:56:42','570',1939119.60,1939119.60,'570','2022-12-16 14:59:40','975','2022-12-16 20:21:40',10,0),('1','167',258209,'AFTERNOON SHIFT','2022-12-16','2022-12-16 20:37:46','2022-12-17 20:37:46','570',2577760.20,2577760.20,'570','2022-12-16 20:54:57','975','2022-12-17 13:42:33',10,0),('1','167',258210,'MORNING SHIFT','2022-12-17','2022-12-17 14:08:14','2022-12-18 14:08:14','570',1803040.60,1803040.60,'570','2022-12-17 15:10:17','975','2022-12-17 19:17:16',10,0),('1','167',258211,'AFTERNOON SHIFT','2022-12-17','2022-12-17 20:38:41','2022-12-18 20:38:41','570',641002.20,641002.20,'570','2022-12-17 20:39:56','975','2022-12-19 07:27:38',10,0),('1','167',258212,'AFTERNOON SHIFT','2022-12-18','2022-12-19 16:41:06','2022-12-20 16:41:06','570',263400.40,263400.40,'570','2022-12-19 16:42:10','975','2022-12-19 18:33:47',10,0),('1','167',258213,'AFTERNOON SHIFT','2022-12-19','2022-12-19 22:41:14','2022-12-20 22:41:14','570',989953.20,989953.20,'570','2022-12-19 22:42:59','975','2022-12-20 10:44:45',10,0),('1','167',258214,'MORNING SHIFT','2022-12-20','2022-12-20 13:27:51','2022-12-21 13:27:51','570',3201632.60,3201632.60,'570','2022-12-20 13:29:37','975','2022-12-20 17:29:06',10,0),('1','167',258215,'AFTERNOON SHIFT','2022-12-20','2022-12-20 22:13:52','2022-12-21 22:13:52','570',4786668.00,4786668.00,'570','2022-12-20 22:16:06','975','2022-12-21 06:16:08',10,0),('1','167',258216,'MORNING SHIFT','2022-12-21','2022-12-21 13:33:54','2022-12-22 13:33:54','570',5069851.00,5069851.00,'570','2022-12-21 13:38:58','975','2022-12-21 19:09:21',10,0),('1','167',258217,'AFTERNOON SHIFT','2022-12-21','2022-12-21 22:06:23','2022-12-22 22:06:23','570',5876865.20,5876865.20,'570','2022-12-21 22:15:46','975','2022-12-22 15:19:11',10,0),('1','167',258218,'MORNING SHIFT','2022-12-22','2022-12-22 15:39:09','2022-12-23 15:39:09','570',6958259.20,6958259.20,'570','2022-12-22 15:48:44','975','2022-12-22 19:52:28',10,0),('1','167',258219,'AFTERNOON SHIFT','2022-12-22','2022-12-22 21:00:44','2022-12-23 21:00:44','570',4163177.30,4163177.30,'570','2022-12-22 21:04:54','975','2022-12-23 11:53:37',10,0),('1','167',258220,'AFTERNOON SHIFT','2022-12-23','2022-12-23 18:16:19','2022-12-24 18:16:19','570',6222004.20,6222004.20,'570','2022-12-23 18:17:47','975','2022-12-24 09:57:18',10,0),('1','167',258221,'MORNING SHIFT','2022-12-26','2022-12-26 14:13:02','2022-12-27 14:13:02','570',268025.20,268025.20,'570','2022-12-26 17:05:57','975','2022-12-26 18:51:45',10,0),('1','167',258222,'AFTERNOON SHIFT','2022-12-26','2022-12-26 21:03:47','2022-12-27 21:03:47','570',4570081.65,4570081.65,'570','2022-12-26 21:06:18','975','2022-12-27 10:13:29',10,0),('1','167',258223,'MORNING SHIFT','2022-12-27','2022-12-27 13:45:06','2022-12-28 13:45:06','570',2359878.00,2359878.00,'570','2022-12-27 13:50:23','975','2022-12-27 14:03:23',10,0),('1','167',258224,'AFTERNOON SHIFT','2022-12-27','2022-12-27 22:13:33','2022-12-28 22:13:33','570',3475004.20,3475004.20,'570','2022-12-27 22:14:44','975','2022-12-28 11:34:58',10,0),('1','167',258225,'MORNING SHIFT','2022-12-28','2022-12-28 13:58:18','2022-12-29 13:58:18','570',1118480.00,1118480.00,'570','2022-12-28 14:00:59','975','2022-12-28 15:46:02',10,0),('1','167',258226,'AFTERNOON SHIFT','2022-12-28','2022-12-28 20:49:20','2022-12-29 20:49:20','570',4361539.00,4361539.00,'570','2022-12-28 20:51:34','975','2022-12-29 12:29:03',10,0),('1','167',258227,'MORNING SHIFT','2022-12-29','2022-12-29 13:03:26','2022-12-30 13:03:26','570',2444936.60,2444936.60,'570','2022-12-29 13:05:39','975','2022-12-29 16:32:17',10,0),('1','167',258228,'AFTERNOON SHIFT','2022-12-29','2022-12-29 21:08:15','2022-12-30 21:08:15','570',2900208.80,2900208.80,'570','2022-12-29 21:10:28','975','2022-12-30 11:42:37',10,0),('1','167',258229,'MORNING SHIFT','2022-12-30','2022-12-30 13:28:06','2022-12-31 13:28:06','570',3053991.60,3053991.60,'570','2022-12-30 13:31:36','975','2022-12-30 19:35:39',10,0),('1','167',258230,'AFTERNOON SHIFT','2022-12-30','2022-12-30 21:02:05','2022-12-31 21:02:05','570',1735128.20,1735128.20,'570','2022-12-30 21:03:17','975','2022-12-31 10:48:23',10,0),('1','167',258231,'MORNING SHIFT','2022-12-31','2022-12-31 13:21:19','2023-01-01 13:21:19','570',1422708.20,1422708.20,'570','2022-12-31 13:26:13','975','2022-12-31 16:57:13',10,0),('1','167',258232,'AFTERNOON SHIFT','2022-12-31','2022-12-31 20:33:33','2023-01-01 20:33:33','570',2181044.20,2181044.20,'570','2022-12-31 20:35:17','975','2023-01-01 12:34:43',10,0),('1','167',258233,'MORNING SHIFT','2023-01-01','2023-01-01 13:32:04','2023-01-02 13:32:04','570',1193280.40,1193280.40,'570','2023-01-01 13:35:22','975','2023-01-02 10:49:05',10,0),('1','167',258234,'AFTERNOON','2023-01-01','2023-01-02 11:39:59','2023-01-03 11:39:59','570',2982946.80,2982946.80,'570','2023-01-02 11:42:01','975','2023-01-02 13:00:12',10,0),('1','167',258235,'MORNING SHIFT','2023-01-02','2023-01-02 14:01:33','2023-01-03 14:01:33','570',3297375.80,3297375.80,'570','2023-01-02 14:14:34','975','2023-01-02 16:37:21',10,0),('1','167',258236,'AFTERNOON SHIFT','2023-01-02','2023-01-02 21:30:43','2023-01-03 21:30:43','570',1556863.95,1556863.95,'570','2023-01-02 21:33:28','975','2023-01-03 13:17:52',10,0),('1','167',258237,'MORNING SHIFT','2023-01-03','2023-01-03 13:28:20','2023-01-04 13:28:20','570',4939745.60,4939745.60,'570','2023-01-03 13:29:28','975','2023-01-03 14:40:37',10,0),('1','167',258238,'AFTERNOON SHIFT','2023-01-03','2023-01-03 20:59:14','2023-01-04 20:59:14','570',2954911.00,2954911.00,'570','2023-01-03 21:03:09','975','2023-01-04 10:33:02',10,0),('1','167',258239,'MORNING SHIFT','2023-01-04','2023-01-04 14:20:16','2023-01-05 14:20:16','570',2254791.10,2254791.10,'570','2023-01-04 15:14:14','975','2023-01-05 09:07:56',10,0),('1','167',258240,'AFTERNOON SHIFT','2023-01-04','2023-01-05 12:02:27','2023-01-06 12:02:27','570',5345611.80,5345611.80,'570','2023-01-05 12:06:56','975','2023-01-05 12:25:40',10,0),('1','167',258241,'MORNING SHIFT','2023-01-05','2023-01-05 14:16:02','2023-01-06 14:16:02','570',3865283.90,3865283.90,'570','2023-01-05 14:21:44','975','2023-01-05 20:24:39',10,0),('1','167',258242,'AFTERNOON SHIFT','2023-01-05','2023-01-05 20:30:19','2023-01-06 20:30:19','570',3037626.45,3037626.45,'570','2023-01-05 21:26:10','975','2023-01-06 10:37:43',10,0),('1','167',258243,'MORNING SHIFT','2023-01-06','2023-01-06 13:20:19','2023-01-07 13:20:19','570',5505284.80,5505284.80,'570','2023-01-06 15:17:34','975','2023-01-07 10:34:18',10,0),('1','167',258244,'AFTERNOON SHIFT','2023-01-06','2023-01-07 11:54:37','2023-01-08 11:54:37','570',895973.00,895973.00,'570','2023-01-07 11:57:30','975','2023-01-07 14:42:31',10,0),('1','167',258245,'MORNING SHIFT','2023-01-07','2023-01-07 14:57:19','2023-01-08 14:57:19','570',1247876.00,1247876.00,'570','2023-01-07 15:00:00','975','2023-01-08 10:01:21',10,0),('1','167',258246,'AFTERNOON SHIFT','2023-01-07','2023-01-08 10:22:56','2023-01-09 10:22:56','570',1998192.40,1998192.40,'570','2023-01-08 10:25:17','975','2023-01-09 09:37:54',10,0),('1','167',258247,'MORNING SHIFT','2023-01-08','2023-01-09 09:43:30','2023-01-10 09:43:30','570',1835242.00,1835242.00,'570','2023-01-09 09:47:50','975','2023-01-09 11:34:22',10,0),('1','167',258248,'AFTERNOON SHIFT','2023-01-08','2023-01-09 13:52:09','2023-01-10 13:52:09','570',702502.20,702502.20,'570','2023-01-09 13:53:03','975','2023-01-09 17:06:05',10,0),('1','167',258249,'MORNING SHIFT','2023-01-09','2023-01-09 18:49:11','2023-01-10 18:49:11','570',851217.40,851217.40,'570','2023-01-09 18:51:59','975','2023-01-10 09:49:16',10,0),('1','167',258250,'AFTERNOON SHIFT','2023-01-09','2023-01-10 11:41:37','2023-01-11 11:41:37','570',2055756.40,2055756.40,'570','2023-01-10 11:44:43','975','2023-01-10 14:38:21',10,0),('1','167',258251,'MORNING SHIFT','2023-01-10','2023-01-10 18:04:34','2023-01-11 18:04:34','570',2666270.70,2666270.70,'570','2023-01-10 19:22:47','975','2023-01-11 10:13:04',10,0),('1','167',258252,'AFTERNOON SHIFT','2023-01-10','2023-01-11 12:13:14','2023-01-12 12:13:14','570',3171071.20,3171071.20,'570','2023-01-11 12:15:36','975','2023-01-11 15:50:18',10,0),('1','167',258253,'MORNING SHIFT','2023-01-11','2023-01-11 20:20:27','2023-01-12 20:20:27','570',3514692.20,3514692.20,'570','2023-01-11 20:22:00','975','2023-01-12 12:26:51',10,0),('1','167',258254,'AFTERNOON SHIFT','2023-01-11','2023-01-12 13:09:46','2023-01-13 13:09:46','570',2733880.00,2733880.00,'570','2023-01-12 13:11:10','975','2023-01-12 15:22:34',10,0),('1','167',258255,'AFTERNOON SHIFT','2023-01-12','2023-01-12 15:50:49','2023-01-13 15:50:49','570',0.00,0.00,'570','2023-01-12 15:54:01','975','2023-01-13 11:21:08',10,0),('1','167',258256,'MORNING SHIFT','2023-01-12','2023-01-13 13:19:22','2023-01-14 13:19:22','570',2006400.60,2006400.60,'570','2023-01-13 13:22:58','975','2023-01-13 23:04:25',10,0),('1','167',258257,'AFTERNOON SHIFT','2023-01-12','2023-01-14 07:38:25','2023-01-15 07:38:25','570',3524360.00,3524360.00,'570','2023-01-14 07:41:52','975','2023-01-14 10:56:56',10,0),('1','167',258258,'MORNING SHIFT','2023-01-13','2023-01-14 14:21:40','2023-01-15 14:21:40','570',5907866.75,5907866.75,'570','2023-01-14 14:32:19','975','2023-01-14 17:40:06',10,0),('1','167',258259,'AFTERNOON SHIFT','2023-01-13','2023-01-14 20:40:57','2023-01-15 20:40:57','570',6462227.15,6462227.15,'570','2023-01-14 20:46:00','975','2023-01-15 12:33:43',10,0),('1','167',258260,'MORNING SHIFT','2023-01-14','2023-01-15 14:21:27','2023-01-16 14:21:27','570',5123761.30,5123761.30,'570','2023-01-15 14:24:02','975','2023-01-16 09:21:13',10,0),('1','167',258261,'AFTERNOON SHIFT','2023-01-14','2023-01-16 09:53:41','2023-01-17 09:53:41','570',5165525.50,5165525.50,'570','2023-01-16 09:56:44','734','2023-01-16 12:56:44',10,0),('1','167',258262,'MORNING SHIFT','2023-01-15','2023-01-16 13:13:48','2023-01-17 13:13:48','570',2865490.00,2865490.00,'570','2023-01-16 13:21:50','734','2023-01-16 15:02:00',10,0),('1','167',258263,'AFTERNOON SHIFT','2023-01-15','2023-01-16 21:22:07','2023-01-17 21:22:07','570',1502125.20,1502125.20,'570','2023-01-16 21:23:35','734','2023-01-16 21:56:29',10,0),('1','167',258264,'MORNING SHIFT','2023-01-16','2023-01-17 10:26:33','2023-01-18 10:26:33','570',2123037.40,2123037.40,'570','2023-01-17 10:29:22','734','2023-01-17 11:54:47',10,0),('1','167',258265,'AFTERNOON SHIFT','2023-01-16','2023-01-17 13:11:45','2023-01-18 13:11:45','570',1116700.60,1116700.60,'570','2023-01-17 13:13:01','734','2023-01-17 14:45:38',10,0),('1','167',258266,'MORNING SHIFT','2023-01-17','2023-01-17 17:04:22','2023-01-18 17:04:22','570',1653505.40,1653505.40,'570','2023-01-17 17:08:11','734','2023-01-17 19:38:33',10,0),('1','167',258267,'AFTERNOON SHIFT','2023-01-17','2023-01-17 19:50:30','2023-01-18 19:50:30','570',611400.20,611400.20,'570','2023-01-17 19:51:44','734','2023-01-17 20:02:12',10,0),('1','167',258268,'MORNING SHIFT','2023-01-18','2023-01-18 13:57:57','2023-01-19 13:57:57','570',1199998.80,1199998.80,'570','2023-01-18 14:01:00','734','2023-01-18 14:25:04',10,0),('1','167',258269,'AFTERNOON SHIFT','2023-01-18','2023-01-18 20:23:53','2023-01-19 20:23:53','570',2161217.70,2161217.70,'570','2023-01-18 20:25:14','734','2023-01-18 21:03:52',10,0),('1','167',258270,'MORNING SHIFT','2023-01-19','2023-01-19 15:29:59','2023-01-20 15:29:59','570',603822.60,603822.60,'570','2023-01-19 15:33:24','734','2023-01-19 16:49:23',10,0),('1','167',258271,'AFTERNOON SHIFT','2023-01-19','2023-01-19 21:59:52','2023-01-20 21:59:52','570',3569601.85,3569601.85,'570','2023-01-19 22:04:55','734','2023-01-20 05:57:20',10,0),('1','167',258272,'MORNING SHIFT','2023-01-20','2023-01-20 14:57:01','2023-01-21 14:57:01','570',5662285.80,5662285.80,'570','2023-01-20 15:05:04','734','2023-01-20 18:21:11',10,0),('1','167',258273,'AFTERNOON SHIFT','2023-01-20','2023-01-20 20:35:36','2023-01-21 20:35:36','570',6732958.65,6732958.65,'570','2023-01-20 20:40:03','734','2023-01-21 03:44:34',10,0),('1','167',258274,'MORNING SHIFT','2023-01-21','2023-01-21 14:16:43','2023-01-22 14:16:43','570',3728432.50,3728432.50,'570','2023-01-21 14:22:41','734','2023-01-21 16:43:53',10,0),('1','167',258275,'AFTERNOON SHIFT','2023-01-21','2023-01-21 20:11:54','2023-01-22 20:11:54','570',5118737.10,5118737.10,'570','2023-01-21 20:19:30','734','2023-01-22 15:13:58',10,0),('1','167',258276,'MORNING SHIFT','2023-01-22','2023-01-22 15:27:37','2023-01-23 15:27:37','570',566975.70,566975.70,'570','2023-01-22 15:33:51','734','2023-01-22 16:42:38',10,0),('1','167',258277,'AFTERNOON SHIFT','2023-01-22','2023-01-22 20:28:08','2023-01-23 20:28:08','570',2034865.80,2034865.80,'570','2023-01-22 20:29:33','734','2023-01-22 21:35:47',10,0),('1','167',258278,'MORNING SHIFT','2023-01-23','2023-01-23 13:31:49','2023-01-24 13:31:49','570',973101.60,973101.60,'570','2023-01-23 13:45:09','734','2023-01-23 15:51:20',10,0),('1','167',258279,'AFTERNOON SHIFT','2023-01-23','2023-01-23 20:11:42','2023-01-24 20:11:42','570',1214459.10,1214459.10,'570','2023-01-23 20:14:09','734','2023-01-23 22:18:41',10,0),('1','167',258280,'MORNING SHIFT','2023-01-24','2023-01-24 13:16:20','2023-01-25 13:16:20','570',1396269.90,1396269.90,'570','2023-01-24 14:31:55','734','2023-01-24 14:53:49',10,0),('1','167',258281,'AFTERNOON SHIFT','2023-01-24','2023-01-24 20:27:11','2023-01-25 20:27:11','570',1279800.00,1279800.00,'570','2023-01-24 20:32:37','734','2023-01-24 21:41:31',10,0),('1','167',258282,'AFTERNOON SHIFT','2023-01-25','2023-01-25 19:41:45','2023-01-26 19:41:45','570',2236345.20,2236345.20,'570','2023-01-25 20:24:05','734','2023-01-25 21:50:39',10,0),('1','167',258283,'MORNING SHIFT','2023-01-26','2023-01-26 13:39:53','2023-01-27 13:39:53','570',4610760.90,4610760.90,'570','2023-01-26 13:49:22','734','2023-01-26 14:21:59',10,0),('1','167',258284,'AFTERNOON SHIFT','2023-01-26','2023-01-26 16:01:00','2023-01-27 16:01:00','570',525681.90,525681.90,'570','2023-01-26 16:02:13','734','2023-01-26 18:39:14',10,0),('1','167',258285,'AFTERNOON SHIFT ll','2023-01-26','2023-01-26 20:44:37','2023-01-27 20:44:37','570',5700307.40,5700307.40,'570','2023-01-26 21:52:34','734','2023-01-26 21:57:57',10,0),('1','167',258286,'MORNING SHIFT','2023-01-27','2023-01-27 11:39:21','2023-01-28 11:39:21','570',7026987.60,7026987.60,'570','2023-01-27 15:23:23','734','2023-01-27 16:05:36',10,0),('1','167',258287,'AFTERNOON SHIFT','2023-01-27','2023-01-27 20:56:19','2023-01-28 20:56:19','570',4012829.70,4012829.70,'570','2023-01-27 20:59:33','734','2023-01-28 06:38:48',10,0),('1','167',258288,'MORNING SHIFT','2023-01-28','2023-01-28 14:48:18','2023-01-29 14:48:18','570',3634445.20,3634445.20,'570','2023-01-28 14:52:46','734','2023-01-28 14:59:36',10,0),('1','167',258289,'AFTERNOON SHIFT','2023-01-28','2023-01-28 19:51:57','2023-01-29 19:51:57','570',1240410.60,1240410.60,'570','2023-01-28 19:53:37','734','2023-01-28 21:02:01',10,0),('1','167',258290,'MORNING SHIFT','2023-01-29','2023-01-29 13:40:16','2023-01-30 13:40:16','570',1341910.10,1341910.10,'570','2023-01-29 14:39:54','734','2023-01-29 15:28:28',10,0),('1','167',258291,'AFTERNOON SHIFT','2023-01-29','2023-01-29 20:39:15','2023-01-30 20:39:15','570',1393054.40,1393054.40,'570','2023-01-29 20:40:23','734','2023-01-29 22:19:00',10,0),('1','167',258292,'MORNING SHIFT','2023-01-31','2023-01-31 14:52:31','2023-02-01 14:52:31','570',5273969.80,5273969.80,'570','2023-01-31 15:47:45','734','2023-01-31 16:05:04',10,0),('1','167',258293,'AFTERNOON SHIFT','2023-01-31','2023-01-31 20:31:42','2023-02-01 20:31:42','570',3454248.60,3454248.60,'570','2023-01-31 20:48:59','734','2023-01-31 21:38:20',10,0),('1','167',258294,'MORNING SHIFT','2023-02-01','2023-02-01 16:18:19','2023-02-02 16:18:19','570',2772756.80,2772756.80,'570','2023-02-01 16:21:11','734','2023-02-01 18:23:49',10,0),('1','167',258295,'AFTERNOON SHIFT','2023-02-01','2023-02-01 19:13:36','2023-02-02 19:13:36','570',518966.80,518966.80,'570','2023-02-01 19:14:36','734','2023-02-01 19:32:39',10,0),('1','167',258296,'AFTERNOON SHIFT','2023-02-02','2023-02-02 21:34:24','2023-02-03 21:34:24','570',1687724.40,1687724.40,'570','2023-02-02 22:19:02','734','2023-02-03 04:32:23',10,0),('1','167',258297,'MORNING SHIFT','2023-02-03','2023-02-03 13:32:41','2023-02-04 13:32:41','570',987484.20,987484.20,'570','2023-02-03 13:34:49','734','2023-02-03 15:01:55',10,0),('1','167',258298,'AFTERNOON SHIFT','2023-02-03','2023-02-03 21:09:19','2023-02-04 21:09:19','570',2446495.70,2446495.70,'570','2023-02-03 21:10:24','734','2023-02-03 23:05:15',10,0),('1','167',258299,'MORNING SHIFT','2023-02-04','2023-02-04 13:30:29','2023-02-05 13:30:29','570',2760023.00,2760023.00,'570','2023-02-04 13:31:43','734','2023-02-04 13:53:54',10,0),('1','167',258300,'AFTERNOON SHIFT','2023-02-04','2023-02-04 20:56:55','2023-02-05 20:56:55','570',2128323.20,2128323.20,'570','2023-02-04 21:15:11','734','2023-02-04 21:36:07',10,0),('1','167',258301,'MORNING SHIFT','2023-02-05','2023-02-05 11:21:13','2023-02-06 11:21:13','570',2328485.50,2328485.50,'570','2023-02-05 11:36:16','734','2023-02-05 13:30:37',10,0),('1','167',258302,'MORNING SHIFT 2','2023-02-05','2023-02-05 13:38:57','2023-02-06 13:38:57','570',349808.00,349808.00,'570','2023-02-05 13:39:40','734','2023-02-05 16:33:14',10,0),('1','167',258303,'AFTERNOON SHIFT','2023-02-05','2023-02-05 19:47:23','2023-02-06 19:47:23','570',1353872.00,1353872.00,'570','2023-02-05 19:51:52','734','2023-02-05 22:50:49',10,0),('1','167',258304,'MORNING SHIFT','2023-02-06','2023-02-06 14:46:09','2023-02-07 14:46:09','570',2831846.00,2831846.00,'570','2023-02-06 16:27:35','734','2023-02-06 18:44:51',10,0),('1','167',258305,'AFTERNOON SHIFT','2023-02-06','2023-02-06 20:46:03','2023-02-07 20:46:03','570',7247764.00,7247764.00,'570','2023-02-06 20:54:26','734','2023-02-06 21:24:15',10,0),('1','167',258306,'MORNING SHIFT','2023-02-07','2023-02-07 14:44:26','2023-02-08 14:44:26','570',5350718.00,5350718.00,'570','2023-02-07 15:32:45','734','2023-02-07 17:08:14',10,0),('1','167',258307,'AFTERNOON SHIFT','2023-02-07','2023-02-07 21:11:55','2023-02-08 21:11:55','570',7485050.00,7485050.00,'570','2023-02-07 21:26:41','734','2023-02-07 23:07:41',10,0),('1','167',258308,'MORNING SHIFT','2023-02-08','2023-02-08 15:05:26','2023-02-09 15:05:26','570',6171992.00,6171992.00,'570','2023-02-08 16:49:40','734','2023-02-08 17:13:42',10,0),('1','167',258309,'AFTERNOON SHIFT','2023-02-08','2023-02-08 21:23:49','2023-02-09 21:23:49','570',6821494.00,6821494.00,'570','2023-02-08 21:30:09','734','2023-02-08 21:39:31',10,0),('1','167',258310,'MORNING SHIFT','2023-02-09','2023-02-09 16:03:08','2023-02-10 16:03:08','570',6022494.00,6022494.00,'570','2023-02-09 16:07:15','734','2023-02-09 18:18:05',10,0),('1','167',258311,'AFTERNOON SHIFT','2023-02-09','2023-02-09 20:23:32','2023-02-10 20:23:32','570',6091832.00,6091832.00,'570','2023-02-09 20:29:13','734','2023-02-10 06:41:41',10,0),('1','167',258312,'MORNING SHIFT','2023-02-10','2023-02-10 14:01:33','2023-02-11 14:01:33','570',2576662.00,2576662.00,'570','2023-02-10 14:05:07','734','2023-02-10 15:23:01',10,0),('1','167',258313,'AFTERNOON SHIFT','2023-02-10','2023-02-10 20:05:02','2023-02-11 20:05:02','570',687736.00,687736.00,'570','2023-02-10 20:06:28','734','2023-02-10 20:20:03',10,0),('1','167',258314,'MORNING SHIFT ','2023-02-11','2023-02-11 12:09:58','2023-02-12 12:09:58','570',2274168.00,2274168.00,'570','2023-02-11 14:13:59','734','2023-02-11 15:28:33',10,0),('1','167',258315,'AFTERNOON SHIFT','2023-02-11','2023-02-11 20:38:17','2023-02-12 20:38:17','570',2202792.00,2202792.00,'570','2023-02-11 20:40:18','734','2023-02-11 21:38:06',10,0),('1','167',258316,'MORNING SHIFT','2023-02-12','2023-02-12 14:32:04','2023-02-13 14:32:04','570',4269630.00,4269630.00,'570','2023-02-12 15:02:39','734','2023-02-12 16:29:34',10,0),('1','167',258317,'AFTERNOON SHIFT','2023-02-12','2023-02-12 20:29:10','2023-02-13 20:29:10','570',3473866.00,3473866.00,'570','2023-02-12 20:37:10','734','2023-02-12 21:42:43',10,0),('1','167',258318,'MORNING SHIFT ','2023-02-13','2023-02-13 15:11:12','2023-02-14 15:11:12','570',1808642.00,1808642.00,'570','2023-02-13 15:14:19','734','2023-02-13 16:24:56',10,0),('1','167',258319,'AFTERNOON SHIFT','2023-02-13','2023-02-13 18:38:39','2023-02-14 18:38:39','570',2810138.00,2810138.00,'570','2023-02-13 20:23:14','734','2023-02-14 07:38:56',10,0),('1','167',258320,'MORNING SHIFT','2023-02-14','2023-02-14 12:51:08','2023-02-15 12:51:08','570',1085168.00,1085168.00,'570','2023-02-14 13:59:29','734','2023-02-14 15:31:22',10,0),('1','167',258321,'AFTERNOON SHIFT ','2023-02-14','2023-02-14 19:54:29','2023-02-15 19:54:29','570',691384.00,691384.00,'570','2023-02-14 19:55:21','734','2023-02-14 21:15:48',10,0),('1','167',258322,'MORNING SHIFT','2023-02-15','2023-02-15 14:06:27','2023-02-16 14:06:27','570',3096316.00,3096316.00,'570','2023-02-15 14:28:13','734','2023-02-15 14:33:40',10,0),('1','167',258323,'AFTERNOON SHIFT','2023-02-15','2023-02-15 20:22:10','2023-02-16 20:22:10','570',3826594.00,3826594.00,'570','2023-02-15 20:23:57','734','2023-02-15 20:24:26',10,0),('1','167',258324,'MORNING SHIFT ','2023-02-16','2023-02-16 13:24:38','2023-02-17 13:24:38','570',2780000.00,2780000.00,'570','2023-02-16 13:25:36','734','2023-02-16 15:31:10',10,0),('1','167',258325,'AFTERNOON SHIFT ','2023-02-16','2023-02-16 19:27:46','2023-02-17 19:27:46','570',2002152.00,2002152.00,'570','2023-02-16 19:31:21','734','2023-02-17 08:20:33',10,0),('1','167',258326,'MORNING SHIFT ','2023-02-17','2023-02-17 13:20:08','2023-02-18 13:20:08','570',991008.00,991008.00,'570','2023-02-17 13:21:11','734','2023-02-17 15:30:56',10,0),('1','167',258327,'AFTERNOON SHIFT ','2023-02-17','2023-02-17 20:13:04','2023-02-18 20:13:04','570',428416.00,428416.00,'570','2023-02-17 20:19:37','734','2023-02-17 21:51:40',10,0),('1','167',258328,'MORNING SHIFT ','2023-02-18','2023-02-18 14:53:34','2023-02-19 14:53:34','570',1722672.00,1722672.00,'570','2023-02-18 14:55:42','734','2023-02-18 15:27:58',10,0),('1','167',258329,'AFTERNOON SHIFT','2023-02-18','2023-02-18 21:11:48','2023-02-19 21:11:48','570',1315552.00,1315552.00,'570','2023-02-18 21:13:43','734','2023-02-18 21:44:23',10,0),('1','167',258330,'MORNING SHIFT ','2023-02-19','2023-02-19 13:24:47','2023-02-20 13:24:47','570',1648504.00,1648504.00,'570','2023-02-19 13:28:31','734','2023-02-19 15:23:24',10,0),('1','167',258331,'AFTERNOON SHIFT ','2023-02-19','2023-02-19 18:34:34','2023-02-20 18:34:34','570',1405504.00,1405504.00,'570','2023-02-19 20:00:46','734','2023-02-19 21:29:37',10,0),('1','167',258332,'MORNING SHIFT ','2023-02-20','2023-02-20 13:20:12','2023-02-21 13:20:12','570',1128936.00,1128936.00,'570','2023-02-20 13:37:42','734','2023-02-20 15:51:21',10,0),('1','167',258333,'AFTERNOON SHIFT ','2023-02-20','2023-02-20 19:31:07','2023-02-21 19:31:07','570',2258760.00,2258760.00,'570','2023-02-20 19:31:49','734','2023-02-20 21:30:19',10,0),('1','167',258334,'MORNING SHIFT ','2023-02-21','2023-02-21 14:01:38','2023-02-22 14:01:38','570',832592.00,832592.00,'570','2023-02-21 14:10:36','734','2023-02-21 15:38:40',10,0),('1','167',258335,'AFTERNOON SHIFT ','2023-02-21','2023-02-21 19:37:05','2023-02-22 19:37:05','570',3148128.00,3148128.00,'570','2023-02-21 21:45:05','734','2023-02-21 22:55:09',10,0),('1','167',258336,'MORNING SHIFT ','2023-02-22','2023-02-22 16:27:33','2023-02-23 16:27:33','570',1437644.00,1437644.00,'570','2023-02-22 16:32:58','734','2023-02-22 17:24:14',10,0),('1','167',258337,'AFTERNOON SHIFT ','2023-02-22','2023-02-22 19:12:16','2023-02-23 19:12:16','570',12127980.00,12127980.00,'570','2023-02-22 21:12:33','734','2023-02-22 21:30:09',10,0),('1','167',258338,'MORNING SHIFT ','2023-02-23','2023-02-23 13:40:04','2023-02-24 13:40:04','570',2114402.00,2114402.00,'570','2023-02-23 14:16:07','734','2023-02-23 16:13:50',10,0),('1','167',258339,'AFTERNOON SHIFT ','2023-02-23','2023-02-23 19:20:07','2023-02-24 19:20:07','570',2205530.00,2205530.00,'570','2023-02-23 20:23:39','734','2023-02-23 22:04:45',10,0),('1','167',258340,'MORNING SHIFT ','2023-02-24','2023-02-24 13:07:54','2023-02-25 13:07:54','570',334072.00,334072.00,'570','2023-02-24 16:19:52','734','2023-02-24 18:53:14',10,0),('1','167',258341,'AFTERNOON SHIFT ','2023-02-24','2023-02-24 20:56:58','2023-02-25 20:56:58','570',2066532.00,2066532.00,'570','2023-02-25 10:47:02','734','2023-02-25 15:37:53',10,0),('1','167',258342,'MORNING SHIFT ','2023-02-26','2023-02-26 13:48:57','2023-02-27 13:48:57','570',1135322.00,1135322.00,'570','2023-02-26 14:21:11','734','2023-02-26 16:24:14',10,0),('1','167',258343,'AFTERNOON SHIFT ','2023-02-26','2023-02-26 19:52:21','2023-02-27 19:52:21','570',2902734.00,2902734.00,'570','2023-02-26 21:45:15','734','2023-02-26 23:32:42',10,0),('1','167',258344,'MORNING SHIFT','2023-02-27','2023-02-27 13:04:22','2023-02-28 13:04:22','570',2494948.00,2494948.00,'570','2023-02-27 14:49:25','734','2023-02-27 15:52:50',10,0),('1','167',258345,'AFTERNOON SHIFT ','2023-02-27','2023-02-27 19:34:51','2023-02-28 19:34:51','570',4346688.00,4346688.00,'570','2023-02-27 20:24:59','734','2023-02-27 21:05:47',10,0),('1','167',258346,'MORNING SHIFT ','2023-02-28','2023-02-28 13:33:43','2023-03-01 13:33:43','570',3662462.00,3662462.00,'570','2023-02-28 15:13:12','734','2023-02-28 15:23:53',10,0),('1','167',258347,'AFTERNOON SHIFT ','2023-02-28','2023-02-28 19:40:02','2023-03-01 19:40:02','570',3874484.00,3874484.00,'570','2023-02-28 21:32:37','734','2023-02-28 21:34:55',10,0),('1','167',258348,'MORNING SHIFT ','2023-03-01','2023-03-01 13:37:00','2023-03-02 13:37:00','570',4939088.00,4939088.00,'570','2023-03-01 15:22:39','734','2023-03-01 15:56:37',10,0),('1','167',258349,'AFTERNOON SHIFT ','2023-03-01','2023-03-01 20:27:06','2023-03-02 20:27:06','570',3718262.00,3718262.00,'570','2023-03-01 20:37:30','734','2023-03-01 21:17:21',10,0),('1','167',258350,'MORNING SHIFT ','2023-03-02','2023-03-02 13:56:38','2023-03-03 13:56:38','570',4015080.00,4015080.00,'570','2023-03-02 15:54:16','734','2023-03-02 20:57:45',10,0),('1','167',258351,'AFTERNOON SHIFT ','2023-03-02','2023-03-03 09:53:45','2023-03-04 09:53:45','570',3845970.00,3845970.00,'570','2023-03-03 10:00:53','734','2023-03-03 10:37:24',10,0),('1','167',258352,'MORNING SHIFT','2023-03-03','2023-03-03 15:15:27','2023-03-04 15:15:27','570',4080616.00,4080616.00,'570','2023-03-03 18:18:44','734','2023-03-03 20:52:43',10,0),('1','167',258353,'AFTERNOON SHIFT ','2023-03-03','2023-03-04 08:12:59','2023-03-05 08:12:59','570',3744270.00,3744270.00,'570','2023-03-04 10:11:08','734','2023-03-04 12:28:31',10,0),('1','167',258354,'MORNING SHIFT ','2023-03-04','2023-03-04 14:23:54','2023-03-05 14:23:54','570',3457694.00,3457694.00,'570','2023-03-04 20:19:04','734','2023-03-04 20:44:41',10,0),('1','167',258355,'AFTERNOON SHIFT ','2023-03-04','2023-03-04 21:53:55','2023-03-05 21:53:55','570',4991034.00,4991034.00,'570','2023-03-04 22:18:42','734','2023-03-05 07:25:19',10,0),('1','167',258356,'MORNING SHIFT ','2023-03-05','2023-03-05 16:04:19','2023-03-06 16:04:19','570',5853862.00,5853862.00,'570','2023-03-05 16:08:49','734','2023-03-05 16:12:03',10,0),('1','167',258357,'AFTERNOON SHIFT ','2023-03-05','2023-03-05 21:21:24','2023-03-06 21:21:24','570',5623616.00,5623616.00,'570','2023-03-05 22:23:45','734','2023-03-06 08:53:43',10,0),('1','167',258358,'MORNING SHIFT','2023-03-06','2023-03-06 18:19:50','2023-03-07 18:19:50','570',3987740.00,3987740.00,'570','2023-03-06 18:28:30','734','2023-03-06 21:10:41',10,0),('1','167',258359,'AFTERNOON SHIFT','2023-03-06','2023-03-06 21:58:20','2023-03-07 21:58:20','570',4741356.00,4741356.00,'570','2023-03-06 22:19:27','734','2023-03-06 22:26:13',10,0),('1','167',258360,'MORNING SHIFT','2023-03-07','2023-03-07 14:01:51','2023-03-08 14:01:51','570',5934914.00,5934914.00,'570','2023-03-07 15:33:40','734','2023-03-07 18:19:38',10,0),('1','167',258361,'AFTERNOON SHIFT','2023-03-07','2023-03-07 20:48:47','2023-03-08 20:48:47','570',5251018.00,5251018.00,'570','2023-03-07 21:03:53','734','2023-03-07 21:39:59',10,0),('1','167',258362,'MORNING SHIFT','2023-03-08','2023-03-08 14:23:17','2023-03-09 14:23:17','570',2719612.00,2719612.00,'570','2023-03-08 15:42:43','734','2023-03-08 15:57:38',10,0),('1','167',258363,'AFTERNOON SHIFT','2023-03-08','2023-03-08 20:46:06','2023-03-09 20:46:06','570',4809370.00,4809370.00,'570','2023-03-08 21:02:48','734','2023-03-09 02:12:37',10,0),('1','167',258364,'MORNING SHIFT','2023-03-09','2023-03-09 08:08:53','2023-03-10 08:08:53','570',5103326.50,4941122.00,'570','2023-03-09 15:32:40','734','2023-03-09 15:53:45',10,0),('1','167',258365,'AFTERNOON SHIFT','2023-03-09','2023-03-09 19:12:08','2023-03-10 19:12:08','570',5696292.10,5567898.00,'570','2023-03-09 20:52:57','734','2023-03-09 23:19:16',10,0),('1','167',258366,'MORNING SHIFT ','2023-03-10','2023-03-10 15:09:08','2023-03-11 15:09:08','570',2951281.00,2909244.00,'570','2023-03-10 15:11:40','734','2023-03-10 17:56:15',10,0),('1','167',258367,'AFTERNOON SHIFT ','2023-03-10','2023-03-10 19:56:01','2023-03-11 19:56:01','570',1539112.00,1539112.00,'570','2023-03-10 19:56:47','734','2023-03-10 20:29:12',10,0),('1','167',258368,'MORNING SHIFT','2023-03-11','2023-03-11 14:14:49','2023-03-12 14:14:49','570',1779720.00,1779720.00,'570','2023-03-11 14:16:32','734','2023-03-11 15:38:26',10,0),('1','167',258369,'AFTERNOON SHIFT ','2023-03-11','2023-03-11 21:58:40','2023-03-12 21:58:40','570',2817728.00,2817728.00,'570','2023-03-11 22:01:56','734','2023-03-12 12:10:36',10,0),('1','167',258370,'MORNING SHIFT','2023-03-12','2023-03-12 14:13:47','2023-03-13 14:13:47','570',2145368.00,2145368.00,'570','2023-03-12 14:15:47','734','2023-03-12 15:10:38',10,0),('1','167',258371,'AFTERNOON SHIFT','2023-03-12','2023-03-12 20:57:13','2023-03-13 20:57:13','570',5641200.00,5641200.00,'570','2023-03-12 21:27:18','734','2023-03-12 22:50:23',10,0),('1','167',258372,'MORNING SHIFT','2023-03-13','2023-03-13 13:46:17','2023-03-14 13:46:17','570',3967726.00,3967726.00,'570','2023-03-13 16:24:40','734','2023-03-13 17:25:38',10,0),('1','167',258373,'AFTERNOON SHIFT','2023-03-13','2023-03-13 21:51:18','2023-03-14 21:51:18','570',2513468.00,2513468.00,'570','2023-03-13 21:55:12','734','2023-03-13 22:57:29',10,0),('1','167',258374,'AFTERNOON SHIFT ','2023-03-16','2023-03-16 19:43:14','2023-03-17 19:43:14','570',1269840.00,1269840.00,'570','2023-03-16 19:48:27','734','2023-03-16 21:06:54',10,0),('1','167',258375,'MORNING SHIFT','2023-03-17','2023-03-17 15:20:24','2023-03-18 15:20:24','570',1761304.00,1761304.00,'570','2023-03-17 15:23:01','734','2023-03-17 15:24:17',10,0),('1','167',258376,'AFTERNOON SHIFT ','2023-03-17','2023-03-17 19:42:21','2023-03-18 19:42:21','570',1363584.00,1363584.00,'570','2023-03-17 19:50:40','734','2023-03-18 08:45:28',10,0),('1','167',258377,'MORNING SHIFT','2023-03-19','2023-03-19 14:28:50','2023-03-20 14:28:50','570',705408.00,705408.00,'570','2023-03-19 14:29:34','734','2023-03-19 18:21:19',10,0),('1','167',258378,'AFTERNOON SHIFT','2023-03-19','2023-03-19 20:08:30','2023-03-20 20:08:30','570',922408.00,922408.00,'570','2023-03-19 20:10:33','734','2023-03-19 23:25:08',10,0),('1','167',258379,'MORNING SHIFT ','2023-03-20','2023-03-20 15:13:58','2023-03-21 15:13:58','570',4900688.00,4900688.00,'570','2023-03-20 15:25:48','734','2023-03-20 19:21:15',10,0),('1','167',258380,'AFTERNOON SHIFT','2023-03-20','2023-03-20 21:46:02','2023-03-21 21:46:02','570',4272604.10,4272604.10,'570','2023-03-20 21:49:46','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4938069 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','167','880','192501',3761693,'2605','389',38123.86,40454.50,2310.64,376634.32,0.00,0.00,20.00,0.00,0.00),('1','167','880','192501',3761694,'2606','389',49685.95,52429.45,2733.50,445560.50,0.00,0.00,10.00,0.00,0.00),('1','167','880','192501',3761695,'2607','389',95427.06,97045.70,1608.64,262208.32,0.00,0.00,10.00,0.00,0.00),('1','167','880','192501',3761696,'2608','389',33067.79,34789.16,1711.37,278953.31,0.00,0.00,10.00,0.00,0.00),('1','167','880','192501',3761697,'2609','389',43598.23,45244.31,1633.08,266192.04,0.00,0.00,13.00,0.00,0.00),('1','167','880','192501',3761698,'2610','389',96811.17,98465.55,1654.38,269663.94,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761699,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761700,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761701,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761702,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761703,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192501',3761704,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192501',3761705,'2617','389',135717.10,135717.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192501',3761706,'2618','389',75684.02,75684.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192501',3761707,'2619','389',130630.35,130630.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192501',3761708,'2620','389',97358.48,97358.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192501',3761709,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192501',3761710,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192501',3761711,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192501',3761712,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192501',3761713,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192501',3761714,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192501',3761715,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192501',3761716,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192501',3761717,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192501',3761718,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192501',3761719,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192501',3761720,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192501',3761721,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192501',3761722,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192501',3761723,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192501',3761724,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192501',3761725,'2637','389',15444.77,15444.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192501',3761726,'2638','389',147996.60,150611.74,2615.14,426267.82,0.00,0.00,0.00,0.00,0.00),('1','167','887','192501',3761727,'2639','389',119691.64,119691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192501',3761728,'2640','389',117319.32,119175.11,1855.79,302493.77,0.00,0.00,0.00,0.00,0.00),('1','167','888','192501',3761729,'2641','390',319405.42,320720.42,1315.00,341900.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','192501',3761730,'2642','390',218642.42,219927.19,1284.77,334040.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','192501',3761731,'2643','390',361362.27,363072.60,1710.33,444685.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','192501',3761732,'2644','390',294394.92,296534.75,2139.83,556355.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','192501',3761733,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192501',3761734,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764986,'2605','389',40454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764987,'2606','389',52429.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764988,'2607','389',97045.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764989,'2608','389',34789.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764990,'2609','389',45244.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192684',3764991,'2610','389',98465.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764992,'2611','389',142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764993,'2612','389',201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764994,'2613','389',82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764995,'2614','389',122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764996,'2615','389',68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192684',3764997,'2616','389',101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192684',3764998,'2617','389',135717.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192684',3764999,'2618','389',75684.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192684',3765000,'2619','389',130630.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192684',3765001,'2620','389',97358.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192684',3765002,'2621','389',9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192684',3765003,'2622','389',98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192684',3765004,'2623','389',106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192684',3765005,'2624','389',45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192684',3765006,'2625','389',127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192684',3765007,'2626','389',87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192684',3765008,'2627','389',62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192684',3765009,'2628','389',109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192684',3765010,'2629','389',67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192684',3765011,'2630','389',26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192684',3765012,'2631','389',77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192684',3765013,'2632','389',38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192684',3765014,'2633','389',60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192684',3765015,'2634','389',59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192684',3765016,'2635','389',64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192684',3765017,'2636','389',28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192684',3765018,'2637','389',15444.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192684',3765019,'2638','389',150611.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192684',3765020,'2639','389',119691.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192684',3765021,'2640','389',119175.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','192684',3765022,'2641','390',320720.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','192684',3765023,'2642','390',219927.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','192684',3765024,'2643','390',363072.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','192684',3765025,'2644','390',296534.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192684',3765026,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192684',3765027,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765237,'2605','389',40454.50,43036.12,2581.62,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765238,'2606','389',52429.45,54502.11,2072.66,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765239,'2607','389',97045.70,99255.67,2209.97,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765240,'2608','389',34789.16,36308.69,1519.53,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765241,'2609','389',45244.31,47343.16,2098.85,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192698',3765242,'2610','389',98465.55,100168.62,1703.07,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765243,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765244,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765245,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765246,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765247,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192698',3765248,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192698',3765249,'2617','389',135717.10,135717.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192698',3765250,'2618','389',75684.02,75684.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192698',3765251,'2619','389',130630.35,130630.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192698',3765252,'2620','389',97358.48,97358.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192698',3765253,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192698',3765254,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192698',3765255,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192698',3765256,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192698',3765257,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192698',3765258,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192698',3765259,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192698',3765260,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192698',3765261,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192698',3765262,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192698',3765263,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192698',3765264,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192698',3765265,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192698',3765266,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192698',3765267,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192698',3765268,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192698',3765269,'2637','389',154440.77,157860.26,3419.49,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192698',3765270,'2638','389',150611.74,153297.82,2686.08,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192698',3765271,'2639','389',119691.64,126273.39,6581.75,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192698',3765272,'2640','389',119175.11,120875.30,1700.19,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','192698',3765273,'2641','390',320720.42,323323.80,2603.38,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','192698',3765274,'2642','390',219927.19,222073.32,2146.13,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','192698',3765275,'2643','390',363072.60,364771.27,1698.67,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','192698',3765276,'2644','390',296534.75,297564.88,1030.13,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192698',3765277,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192698',3765278,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768568,'2605','389',43036.12,45591.18,2555.06,416474.78,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768569,'2606','389',54502.11,55598.07,1095.96,178641.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768570,'2607','389',99255.67,100612.35,1356.68,221138.84,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768571,'2608','389',36308.69,36979.55,670.86,109350.18,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768572,'2609','389',47343.16,48419.65,1076.49,175467.87,0.00,0.00,0.00,0.00,0.00),('1','167','880','192881',3768573,'2610','389',100168.62,101469.29,1300.67,212009.21,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768574,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768575,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768576,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768577,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768578,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','192881',3768579,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192881',3768580,'2617','389',135717.10,136650.20,933.10,152095.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','192881',3768581,'2618','389',75684.02,75684.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','192881',3768582,'2619','389',130630.35,131079.69,449.34,73242.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','192881',3768583,'2620','389',97358.48,97789.51,431.03,70257.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','192881',3768584,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192881',3768585,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192881',3768586,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','192881',3768587,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192881',3768588,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192881',3768589,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192881',3768590,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','192881',3768591,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192881',3768592,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192881',3768593,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192881',3768594,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','192881',3768595,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192881',3768596,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192881',3768597,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192881',3768598,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','192881',3768599,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','192881',3768600,'2637','389',157860.26,159077.04,1216.78,198335.14,0.00,0.00,0.00,0.00,0.00),('1','167','887','192881',3768601,'2638','389',153297.82,156394.95,3097.13,504832.19,0.00,0.00,0.00,0.00,0.00),('1','167','887','192881',3768602,'2639','389',126273.39,128989.17,2715.78,442672.14,0.00,0.00,0.00,0.00,0.00),('1','167','887','192881',3768603,'2640','389',120875.30,122189.96,1314.66,214289.58,0.00,0.00,0.00,0.00,0.00),('1','167','888','192881',3768604,'2641','390',323323.80,326701.52,3377.72,878207.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','192881',3768605,'2642','390',222073.32,224557.37,2484.05,645853.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','192881',3768606,'2643','390',364771.27,365123.66,352.39,91621.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','192881',3768607,'2644','390',297564.88,298254.34,689.46,179259.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','192881',3768608,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','192881',3768609,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776215,'2605','389',45591.18,48384.28,2793.10,455275.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776216,'2606','389',55598.07,57529.81,1931.74,314873.62,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776217,'2607','389',100612.35,103218.23,2605.88,424758.44,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776218,'2608','389',36979.55,38294.98,1315.43,214415.09,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776219,'2609','389',48419.65,50302.01,1882.36,306824.68,0.00,0.00,0.00,0.00,0.00),('1','167','880','193289',3776220,'2610','389',101469.29,102528.19,1058.90,172600.70,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776221,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776222,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776223,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776224,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776225,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193289',3776226,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193289',3776227,'2617','389',136650.20,139282.39,2632.19,429046.97,0.00,0.00,0.00,0.00,0.00),('1','167','882','193289',3776228,'2618','389',75684.02,77962.80,2278.78,371441.14,0.00,0.00,0.00,0.00,0.00),('1','167','882','193289',3776229,'2619','389',131079.69,133308.31,2228.62,363265.06,0.00,0.00,0.00,0.00,0.00),('1','167','882','193289',3776230,'2620','389',97789.51,100348.98,2559.47,417193.61,0.00,0.00,0.00,0.00,0.00),('1','167','883','193289',3776231,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193289',3776232,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193289',3776233,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193289',3776234,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193289',3776235,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193289',3776236,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193289',3776237,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193289',3776238,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193289',3776239,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193289',3776240,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193289',3776241,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193289',3776242,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193289',3776243,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193289',3776244,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193289',3776245,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193289',3776246,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193289',3776247,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193289',3776248,'2638','389',156394.95,156394.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193289',3776249,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193289',3776250,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193289',3776251,'2641','390',326701.52,328170.11,1468.59,381833.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193289',3776252,'2642','390',224557.37,225809.49,1252.12,325551.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193289',3776253,'2643','390',365123.66,366740.34,1616.68,420336.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193289',3776254,'2644','390',298254.34,299894.53,1640.19,426449.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','193289',3776255,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193289',3776256,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776752,'2605','389',48384.28,52880.68,4496.40,732913.20,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776753,'2606','389',57529.81,60302.41,2772.60,451933.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776754,'2607','389',103218.23,105308.72,2090.49,340749.87,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776755,'2608','389',38294.98,40213.09,1918.11,312651.93,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776756,'2609','389',50302.01,52130.45,1828.44,298035.72,0.00,0.00,0.00,0.00,0.00),('1','167','880','193316',3776757,'2610','389',102528.19,105181.39,2653.20,432471.60,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776758,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776759,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776760,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776761,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776762,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193316',3776763,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193316',3776764,'2617','389',139282.39,140668.54,1386.15,225942.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','193316',3776765,'2618','389',77962.80,79058.18,1095.38,178546.94,0.00,0.00,0.00,0.00,0.00),('1','167','882','193316',3776766,'2619','389',133308.31,134466.22,1157.91,188739.33,0.00,0.00,0.00,0.00,0.00),('1','167','882','193316',3776767,'2620','389',100348.98,101336.84,987.86,161021.18,0.00,0.00,0.00,0.00,0.00),('1','167','883','193316',3776768,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193316',3776769,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193316',3776770,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193316',3776771,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193316',3776772,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193316',3776773,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193316',3776774,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193316',3776775,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193316',3776776,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193316',3776777,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193316',3776778,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193316',3776779,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193316',3776780,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193316',3776781,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193316',3776782,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193316',3776783,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193316',3776784,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193316',3776785,'2638','389',156394.95,156410.29,15.34,2500.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','193316',3776786,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193316',3776787,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193316',3776788,'2641','390',328170.11,329605.85,1435.74,373292.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193316',3776789,'2642','390',225809.49,226613.65,804.16,209081.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193316',3776790,'2643','390',366740.34,368160.33,1419.99,369197.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193316',3776791,'2644','390',299894.53,301919.40,2024.87,526466.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','193316',3776792,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193316',3776793,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776960,'2605','389',52880.68,53381.02,500.34,81555.42,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776961,'2606','389',60302.41,60302.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776962,'2607','389',105308.72,105658.23,349.51,56970.13,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776963,'2608','389',40213.09,40213.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776964,'2609','389',52130.45,52130.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193325',3776965,'2610','389',105181.39,105547.72,366.33,59711.79,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776966,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776967,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776968,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776969,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776970,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193325',3776971,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193325',3776972,'2617','389',140668.54,140668.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193325',3776973,'2618','389',79058.18,79058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193325',3776974,'2619','389',134466.22,134466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193325',3776975,'2620','389',101336.84,101336.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193325',3776976,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193325',3776977,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193325',3776978,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193325',3776979,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193325',3776980,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193325',3776981,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193325',3776982,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193325',3776983,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193325',3776984,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193325',3776985,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193325',3776986,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193325',3776987,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193325',3776988,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193325',3776989,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193325',3776990,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193325',3776991,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193325',3776992,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193325',3776993,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193325',3776994,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193325',3776995,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193325',3776996,'2641','390',329605.85,330375.40,769.55,200083.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193325',3776997,'2642','390',226613.65,227602.41,988.76,257077.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193325',3776998,'2643','390',368160.33,369229.41,1069.08,277960.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193325',3776999,'2644','390',301919.40,302812.73,893.33,232265.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','193325',3777000,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193325',3777001,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777346,'2605','389',53381.02,53381.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777347,'2606','389',60302.41,60302.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777348,'2607','389',105658.23,105658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777349,'2608','389',40213.09,40213.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777350,'2609','389',52130.45,52130.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193342',3777351,'2610','389',105547.72,105547.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777352,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777353,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777354,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777355,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777356,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193342',3777357,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193342',3777358,'2617','389',140668.54,140668.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193342',3777359,'2618','389',79058.18,79058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193342',3777360,'2619','389',134466.22,134466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193342',3777361,'2620','389',101336.84,101336.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193342',3777362,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193342',3777363,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193342',3777364,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193342',3777365,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193342',3777366,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193342',3777367,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193342',3777368,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193342',3777369,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193342',3777370,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193342',3777371,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193342',3777372,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193342',3777373,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193342',3777374,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193342',3777375,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193342',3777376,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193342',3777377,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193342',3777378,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193342',3777379,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193342',3777380,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193342',3777381,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193342',3777382,'2641','390',330375.40,332056.68,1681.28,437132.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','193342',3777383,'2642','390',227602.41,228409.65,807.24,209882.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193342',3777384,'2643','390',369229.41,370017.26,787.85,204841.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193342',3777385,'2644','390',302812.73,304393.79,1581.06,411075.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193342',3777386,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193342',3777387,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777488,'2605','389',53381.02,53381.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777489,'2606','389',60302.41,60302.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777490,'2607','389',105658.23,105658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777491,'2608','389',40213.09,40213.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777492,'2609','389',52130.45,52130.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193346',3777493,'2610','389',105547.72,105547.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777494,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777495,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777496,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777497,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777498,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193346',3777499,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193346',3777500,'2617','389',140668.54,140668.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193346',3777501,'2618','389',79058.18,79058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193346',3777502,'2619','389',134466.22,134466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193346',3777503,'2620','389',101336.84,101336.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193346',3777504,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193346',3777505,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193346',3777506,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193346',3777507,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193346',3777508,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193346',3777509,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193346',3777510,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193346',3777511,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193346',3777512,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193346',3777513,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193346',3777514,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193346',3777515,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193346',3777516,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193346',3777517,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193346',3777518,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193346',3777519,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193346',3777520,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193346',3777521,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193346',3777522,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193346',3777523,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193346',3777524,'2641','390',332056.68,334464.52,2407.84,626038.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193346',3777525,'2642','390',228409.65,228861.20,451.55,117403.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193346',3777526,'2643','390',370017.26,372275.28,2258.02,587085.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193346',3777527,'2644','390',304393.79,305902.43,1508.64,392246.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','193346',3777528,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193346',3777529,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777554,'2605','389',53381.02,53381.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777555,'2606','389',60302.41,60302.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777556,'2607','389',105658.23,105658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777557,'2608','389',40213.09,40213.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777558,'2609','389',52130.45,52130.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193348',3777559,'2610','389',105547.72,105547.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777560,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777561,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777562,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777563,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777564,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193348',3777565,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193348',3777566,'2617','389',140668.54,140668.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193348',3777567,'2618','389',79058.18,79058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193348',3777568,'2619','389',134466.22,134466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193348',3777569,'2620','389',101336.84,101336.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193348',3777570,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193348',3777571,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193348',3777572,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193348',3777573,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193348',3777574,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193348',3777575,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193348',3777576,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193348',3777577,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193348',3777578,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193348',3777579,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193348',3777580,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193348',3777581,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193348',3777582,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193348',3777583,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193348',3777584,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193348',3777585,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193348',3777586,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193348',3777587,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193348',3777588,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193348',3777589,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193348',3777590,'2641','390',334464.52,335279.99,815.47,212022.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','193348',3777591,'2642','390',228861.20,229933.53,1072.33,278805.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193348',3777592,'2643','390',372275.28,373237.20,961.92,250099.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193348',3777593,'2644','390',305902.43,306502.59,600.16,156041.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193348',3777594,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193348',3777595,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777787,'2605','389',53381.02,53381.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777788,'2606','389',60302.41,60302.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777789,'2607','389',105658.23,105658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777790,'2608','389',40213.09,40213.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777791,'2609','389',52130.45,52130.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193356',3777792,'2610','389',105547.72,105547.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777793,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777794,'2612','389',201176.84,201176.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777795,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777796,'2614','389',122875.34,122875.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777797,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193356',3777798,'2616','389',101931.20,101931.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193356',3777799,'2617','389',140668.54,140668.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193356',3777800,'2618','389',79058.18,79058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193356',3777801,'2619','389',134466.22,134466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193356',3777802,'2620','389',101336.84,101336.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193356',3777803,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193356',3777804,'2622','389',98028.97,98028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193356',3777805,'2623','389',106562.50,106562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193356',3777806,'2624','389',45157.06,45157.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193356',3777807,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193356',3777808,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193356',3777809,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193356',3777810,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193356',3777811,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193356',3777812,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193356',3777813,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193356',3777814,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193356',3777815,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193356',3777816,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193356',3777817,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193356',3777818,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193356',3777819,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193356',3777820,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193356',3777821,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193356',3777822,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193356',3777823,'2641','390',335279.99,336092.24,812.25,211185.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193356',3777824,'2642','390',229933.53,230299.51,365.98,95154.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193356',3777825,'2643','390',373237.20,374193.76,956.56,248705.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193356',3777826,'2644','390',306502.59,307317.33,814.74,211832.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','193356',3777827,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193356',3777828,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777924,'2605','389',53381.02,54991.61,1610.59,262526.17,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777925,'2606','389',60302.41,61584.94,1282.53,209052.39,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777926,'2607','389',105658.23,107388.20,1729.97,281985.11,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777927,'2608','389',40213.09,41278.90,1065.81,173727.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777928,'2609','389',52130.45,52852.81,722.36,117744.68,0.00,0.00,0.00,0.00,0.00),('1','167','880','193360',3777929,'2610','389',105547.72,106624.64,1076.92,175537.96,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777930,'2611','389',142862.23,142862.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777931,'2612','389',201176.84,202127.20,950.36,154908.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777932,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777933,'2614','389',122875.34,123750.63,875.29,142672.27,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777934,'2615','389',68776.83,68776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193360',3777935,'2616','389',101931.20,102905.27,974.07,158773.41,0.00,0.00,0.00,0.00,0.00),('1','167','882','193360',3777936,'2617','389',140668.54,141586.59,918.05,149642.15,0.00,0.00,0.00,0.00,0.00),('1','167','882','193360',3777937,'2618','389',79058.18,79957.36,899.18,146566.34,0.00,0.00,0.00,0.00,0.00),('1','167','882','193360',3777938,'2619','389',134466.22,135333.99,867.77,141446.51,0.00,0.00,0.00,0.00,0.00),('1','167','882','193360',3777939,'2620','389',101336.84,101951.77,614.93,100233.59,0.00,0.00,0.00,0.00,0.00),('1','167','883','193360',3777940,'2621','389',9814.62,9814.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193360',3777941,'2622','389',98028.97,98580.43,551.46,89887.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','193360',3777942,'2623','389',106562.50,106789.47,226.97,36996.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','193360',3777943,'2624','389',45157.06,45388.78,231.72,37770.36,0.00,0.00,0.00,0.00,0.00),('1','167','884','193360',3777944,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193360',3777945,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193360',3777946,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193360',3777947,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193360',3777948,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193360',3777949,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193360',3777950,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193360',3777951,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193360',3777952,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193360',3777953,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193360',3777954,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193360',3777955,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193360',3777956,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193360',3777957,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193360',3777958,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193360',3777959,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193360',3777960,'2641','390',336092.24,339070.55,2978.31,774360.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193360',3777961,'2642','390',230299.51,231249.34,949.83,246955.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193360',3777962,'2643','390',374193.76,375070.30,876.54,227900.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193360',3777963,'2644','390',307317.33,309401.49,2084.16,541881.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193360',3777964,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193360',3777965,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778518,'2605','389',54991.61,56063.69,1072.08,174749.04,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778519,'2606','389',61584.94,62104.61,519.67,84706.21,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778520,'2607','389',107388.20,108187.02,798.82,130207.66,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778521,'2608','389',41278.90,41951.57,672.67,109645.21,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778522,'2609','389',52852.81,52852.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193385',3778523,'2610','389',106624.64,109216.53,2591.89,422478.07,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778524,'2611','389',142862.23,144294.09,1431.86,233393.18,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778525,'2612','389',202127.20,203961.94,1834.74,299062.62,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778526,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778527,'2614','389',123750.63,125018.80,1268.17,206711.71,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778528,'2615','389',68776.83,70353.54,1576.71,257003.73,0.00,0.00,0.00,0.00,0.00),('1','167','881','193385',3778529,'2616','389',102905.27,104382.15,1476.88,240731.44,0.00,0.00,0.00,0.00,0.00),('1','167','882','193385',3778530,'2617','389',141586.59,143052.11,1465.52,238879.76,0.00,0.00,0.00,0.00,0.00),('1','167','882','193385',3778531,'2618','389',79957.36,80853.26,895.90,146031.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','193385',3778532,'2619','389',135333.99,136226.97,892.98,145555.74,0.00,0.00,0.00,0.00,0.00),('1','167','882','193385',3778533,'2620','389',101951.77,102802.12,850.35,138607.05,0.00,0.00,0.00,0.00,0.00),('1','167','883','193385',3778534,'2621','389',9814.62,11142.45,1327.83,216436.29,0.00,0.00,0.00,0.00,0.00),('1','167','883','193385',3778535,'2622','389',98580.43,99864.23,1283.80,209259.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','193385',3778536,'2623','389',106789.47,107702.61,913.14,148841.82,0.00,0.00,0.00,0.00,0.00),('1','167','883','193385',3778537,'2624','389',45388.78,46116.97,728.19,118694.97,0.00,0.00,0.00,0.00,0.00),('1','167','884','193385',3778538,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193385',3778539,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193385',3778540,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193385',3778541,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193385',3778542,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193385',3778543,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193385',3778544,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193385',3778545,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193385',3778546,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193385',3778547,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193385',3778548,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193385',3778549,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193385',3778550,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193385',3778551,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193385',3778552,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193385',3778553,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193385',3778554,'2641','390',339070.55,340637.09,1566.54,407300.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193385',3778555,'2642','390',231249.34,232309.62,1060.28,275672.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193385',3778556,'2643','390',375070.30,376595.60,1525.30,396578.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193385',3778557,'2644','390',309401.49,310720.20,1318.71,342864.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193385',3778558,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193385',3778559,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780624,'2605','389',56063.69,56063.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780625,'2606','389',62104.61,63688.79,1584.18,258221.34,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780626,'2607','389',108187.02,110145.05,1958.03,319158.89,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780627,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780628,'2609','389',52852.81,52852.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193509',3780629,'2610','389',109216.53,110633.66,1417.13,230992.19,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780630,'2611','389',144294.09,144294.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780631,'2612','389',203961.94,207351.21,3389.27,552451.01,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780632,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780633,'2614','389',125018.80,127530.16,2511.36,409351.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780634,'2615','389',70353.54,70353.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193509',3780635,'2616','389',104382.15,106401.02,1982.24,323105.12,0.00,0.00,36.63,0.00,0.00),('1','167','882','193509',3780636,'2617','389',143052.11,144344.92,1292.81,210728.03,0.00,0.00,0.00,0.00,0.00),('1','167','882','193509',3780637,'2618','389',80853.26,82046.61,1193.35,194516.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','193509',3780638,'2619','389',136226.97,136226.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193509',3780639,'2620','389',102802.12,104925.00,2122.88,346029.44,0.00,0.00,0.00,0.00,0.00),('1','167','883','193509',3780640,'2621','389',11142.45,11142.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193509',3780641,'2622','389',99864.23,102614.43,2750.20,448282.60,0.00,0.00,0.00,0.00,0.00),('1','167','883','193509',3780642,'2623','389',107702.61,109379.42,1676.81,273320.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','193509',3780643,'2624','389',46116.97,46116.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193509',3780644,'2625','389',127573.24,127573.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193509',3780645,'2626','389',87554.48,87554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193509',3780646,'2627','389',62681.94,62681.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193509',3780647,'2628','389',109436.20,109436.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193509',3780648,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193509',3780649,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193509',3780650,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193509',3780651,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193509',3780652,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193509',3780653,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193509',3780654,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193509',3780655,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193509',3780656,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193509',3780657,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193509',3780658,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193509',3780659,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193509',3780660,'2641','390',340637.09,342199.90,1562.81,406330.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193509',3780661,'2642','390',232309.62,232420.99,111.37,28955.42,0.00,0.00,0.00,0.00,0.00),('1','167','889','193509',3780662,'2643','390',376595.60,377534.17,938.57,244028.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193509',3780663,'2644','390',310720.20,312072.58,1352.38,351618.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','193509',3780664,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193509',3780665,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193552',3781445,'2605','389',56063.69,56063.69,-5.00,-815.00,0.00,0.00,5.00,0.00,0.00),('1','167','880','193552',3781446,'2606','389',63688.79,64970.94,1230.00,200490.00,0.00,0.00,52.15,0.00,0.00),('1','167','880','193552',3781447,'2607','389',110145.05,110939.13,794.08,129435.04,0.00,0.00,0.00,0.00,0.00),('1','167','880','193552',3781448,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193552',3781449,'2609','389',52852.81,53224.86,372.05,60644.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','193552',3781450,'2610','389',110633.66,111440.97,807.31,131591.53,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781451,'2611','389',144294.09,146983.22,2689.13,438328.19,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781452,'2612','389',207351.21,208422.08,1070.87,174551.81,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781453,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781454,'2614','389',127530.16,128357.69,827.53,134887.39,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781455,'2615','389',70353.54,71746.65,1393.11,227076.93,0.00,0.00,0.00,0.00,0.00),('1','167','881','193552',3781456,'2616','389',106401.02,107041.07,640.05,104328.15,0.00,0.00,0.00,0.00,0.00),('1','167','882','193552',3781457,'2617','389',144344.92,145744.81,1399.89,228182.07,0.00,0.00,0.00,0.00,0.00),('1','167','882','193552',3781458,'2618','389',82046.61,82046.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193552',3781459,'2619','389',136226.97,137334.65,1107.68,180551.84,0.00,0.00,0.00,0.00,0.00),('1','167','882','193552',3781460,'2620','389',104925.00,106523.89,1598.89,260619.07,0.00,0.00,0.00,0.00,0.00),('1','167','883','193552',3781461,'2621','389',11142.45,11142.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193552',3781462,'2622','389',102614.43,104292.33,1677.90,273497.70,0.00,0.00,0.00,0.00,0.00),('1','167','883','193552',3781463,'2623','389',109379.42,110874.62,1495.20,243717.60,0.00,0.00,0.00,0.00,0.00),('1','167','883','193552',3781464,'2624','389',46116.97,46116.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193552',3781465,'2625','389',127573.24,127595.32,22.08,3599.04,0.00,0.00,0.00,0.00,0.00),('1','167','884','193552',3781466,'2626','389',87554.48,89454.94,1900.46,309774.98,0.00,0.00,0.00,0.00,0.00),('1','167','884','193552',3781467,'2627','389',62681.94,63894.51,1212.57,197648.91,0.00,0.00,0.00,0.00,0.00),('1','167','884','193552',3781468,'2628','389',109436.20,110736.59,1300.39,211963.57,0.00,0.00,0.00,0.00,0.00),('1','167','885','193552',3781469,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193552',3781470,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193552',3781471,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193552',3781472,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193552',3781473,'2633','389',60703.48,60703.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193552',3781474,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193552',3781475,'2635','389',64635.24,64635.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193552',3781476,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193552',3781477,'2637','389',159077.04,159077.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193552',3781478,'2638','389',156410.29,156410.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193552',3781479,'2639','389',128989.17,128989.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193552',3781480,'2640','389',122189.96,122189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193552',3781481,'2641','390',342199.90,343092.75,892.85,232141.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193552',3781482,'2642','390',232420.99,232800.15,379.16,98581.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193552',3781483,'2643','390',377534.17,379717.85,2183.68,567756.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193552',3781484,'2644','390',312072.58,313599.30,1526.72,396947.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','193552',3781485,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193552',3781486,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783352,'2605','389',56063.69,56063.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783353,'2606','389',64970.94,65575.11,604.17,98479.71,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783354,'2607','389',110939.13,111824.82,885.69,144367.47,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783355,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783356,'2609','389',53224.86,55171.74,1946.88,317341.44,0.00,0.00,0.00,0.00,0.00),('1','167','880','193668',3783357,'2610','389',111440.97,113388.22,1947.25,317401.75,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783358,'2611','389',146983.22,146983.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783359,'2612','389',208422.08,210614.82,2192.74,357416.62,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783360,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783361,'2614','389',128357.69,129708.22,1350.53,220136.39,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783362,'2615','389',71746.65,71746.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193668',3783363,'2616','389',107041.07,108131.71,1090.64,177774.32,0.00,0.00,0.00,0.00,0.00),('1','167','882','193668',3783364,'2617','389',145744.81,145744.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193668',3783365,'2618','389',82046.61,83285.55,1238.94,201947.22,0.00,0.00,0.00,0.00,0.00),('1','167','882','193668',3783366,'2619','389',137334.65,137334.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193668',3783367,'2620','389',106523.89,107849.77,1325.88,216118.44,0.00,0.00,0.00,0.00,0.00),('1','167','883','193668',3783368,'2621','389',11142.45,11142.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193668',3783369,'2622','389',104292.33,105264.19,971.86,158413.18,0.00,0.00,0.00,0.00,0.00),('1','167','883','193668',3783370,'2623','389',110874.62,111590.65,716.03,116712.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','193668',3783371,'2624','389',46116.97,46116.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193668',3783372,'2625','389',127595.32,127595.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193668',3783373,'2626','389',89454.94,91209.57,1754.63,286004.69,0.00,0.00,0.00,0.00,0.00),('1','167','884','193668',3783374,'2627','389',63894.51,63894.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193668',3783375,'2628','389',110736.59,112621.28,1884.69,307204.47,0.00,0.00,0.00,0.00,0.00),('1','167','885','193668',3783376,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193668',3783377,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193668',3783378,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193668',3783379,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193668',3783380,'2633','389',60703.48,61753.17,1049.69,171099.47,0.00,0.00,0.00,0.00,0.00),('1','167','886','193668',3783381,'2634','389',59241.17,59241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193668',3783382,'2635','389',64635.24,66153.80,1518.56,247525.28,0.00,0.00,0.00,0.00,0.00),('1','167','886','193668',3783383,'2636','389',28179.95,28179.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193668',3783384,'2637','389',159077.04,159753.76,676.72,110305.36,0.00,0.00,0.00,0.00,0.00),('1','167','887','193668',3783385,'2638','389',156410.29,157933.98,1523.69,248361.47,0.00,0.00,0.00,0.00,0.00),('1','167','887','193668',3783386,'2639','389',128989.17,129866.60,877.43,143021.09,0.00,0.00,0.00,0.00,0.00),('1','167','887','193668',3783387,'2640','389',122189.96,123115.11,925.15,150799.45,0.00,0.00,0.00,0.00,0.00),('1','167','888','193668',3783388,'2641','390',343092.75,345406.10,2313.35,601471.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193668',3783389,'2642','390',232800.15,235315.14,2514.99,653897.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193668',3783390,'2643','390',379717.85,380409.74,691.89,179891.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193668',3783391,'2644','390',313599.30,313998.02,398.72,103667.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','193668',3783392,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193668',3783393,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783950,'2605','389',56063.69,56063.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783951,'2606','389',65575.11,65575.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783952,'2607','389',111824.82,111824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783953,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783954,'2609','389',55171.74,55171.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193695',3783955,'2610','389',113388.22,113388.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783956,'2611','389',146983.22,147478.38,495.16,80711.08,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783957,'2612','389',210614.82,211872.40,1257.58,204985.54,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783958,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783959,'2614','389',129708.22,130786.63,1078.41,175780.83,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783960,'2615','389',71746.65,71976.58,229.93,37478.59,0.00,0.00,0.00,0.00,0.00),('1','167','881','193695',3783961,'2616','389',108131.71,108710.43,578.72,94331.36,0.00,0.00,0.00,0.00,0.00),('1','167','882','193695',3783962,'2617','389',145744.81,146768.86,1009.23,164504.49,0.00,0.00,14.82,0.00,0.00),('1','167','882','193695',3783963,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193695',3783964,'2619','389',137334.65,137903.57,568.92,92733.96,0.00,0.00,0.00,0.00,0.00),('1','167','882','193695',3783965,'2620','389',107849.77,108068.98,219.21,35731.23,0.00,0.00,0.00,0.00,0.00),('1','167','883','193695',3783966,'2621','389',11142.45,11737.23,594.78,96949.14,0.00,0.00,0.00,0.00,0.00),('1','167','883','193695',3783967,'2622','389',105264.19,106274.47,1010.28,164675.64,0.00,0.00,0.00,0.00,0.00),('1','167','883','193695',3783968,'2623','389',111590.65,112827.55,1236.90,201614.70,0.00,0.00,0.00,0.00,0.00),('1','167','883','193695',3783969,'2624','389',46116.97,46116.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193695',3783970,'2625','389',127595.32,129250.10,1654.78,269729.14,0.00,0.00,0.00,0.00,0.00),('1','167','884','193695',3783971,'2626','389',91209.57,92544.45,1334.88,217585.44,0.00,0.00,0.00,0.00,0.00),('1','167','884','193695',3783972,'2627','389',63894.51,64839.60,945.09,154049.67,0.00,0.00,0.00,0.00,0.00),('1','167','884','193695',3783973,'2628','389',112621.28,113552.69,931.41,151819.83,0.00,0.00,0.00,0.00,0.00),('1','167','885','193695',3783974,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193695',3783975,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193695',3783976,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193695',3783977,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193695',3783978,'2633','389',61753.17,62533.64,780.47,127216.61,0.00,0.00,0.00,0.00,0.00),('1','167','886','193695',3783979,'2634','389',59241.17,60163.44,922.27,150330.01,0.00,0.00,0.00,0.00,0.00),('1','167','886','193695',3783980,'2635','389',66153.80,67553.94,1400.14,228222.82,0.00,0.00,0.00,0.00,0.00),('1','167','886','193695',3783981,'2636','389',28179.95,29658.45,1478.50,240995.50,0.00,0.00,0.00,0.00,0.00),('1','167','887','193695',3783982,'2637','389',159753.76,161663.10,1909.34,311222.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','193695',3783983,'2638','389',157933.98,157933.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193695',3783984,'2639','389',129866.60,130878.90,1012.30,165004.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','193695',3783985,'2640','389',123115.11,123115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193695',3783986,'2641','390',345406.10,346727.48,1321.38,343558.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','193695',3783987,'2642','390',235315.14,236707.66,1392.52,362055.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193695',3783988,'2643','390',380409.74,382482.32,2072.58,538870.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193695',3783989,'2644','390',313998.02,316035.60,2037.58,529770.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','193695',3783990,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193695',3783991,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784152,'2605','389',56063.69,56063.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784153,'2606','389',65575.11,65575.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784154,'2607','389',111824.82,111824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784155,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784156,'2609','389',55171.74,55171.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193703',3784157,'2610','389',113388.22,113388.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784158,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784159,'2612','389',211872.40,211872.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784160,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784161,'2614','389',130786.63,130786.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784162,'2615','389',71976.58,71976.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193703',3784163,'2616','389',108710.43,108710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193703',3784164,'2617','389',146768.86,146768.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193703',3784165,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193703',3784166,'2619','389',137903.57,137903.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193703',3784167,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193703',3784168,'2621','389',11737.23,12595.92,858.69,139966.47,0.00,0.00,0.00,0.00,0.00),('1','167','883','193703',3784169,'2622','389',106274.47,107476.82,1202.35,195983.05,0.00,0.00,0.00,0.00,0.00),('1','167','883','193703',3784170,'2623','389',112827.55,113745.82,918.27,149678.01,0.00,0.00,0.00,0.00,0.00),('1','167','883','193703',3784171,'2624','389',46116.97,47145.35,1028.38,167625.94,0.00,0.00,0.00,0.00,0.00),('1','167','884','193703',3784172,'2625','389',129250.10,131813.06,2562.96,417762.48,0.00,0.00,0.00,0.00,0.00),('1','167','884','193703',3784173,'2626','389',92544.45,94152.94,1608.49,262183.87,0.00,0.00,0.00,0.00,0.00),('1','167','884','193703',3784174,'2627','389',64839.60,65949.53,1109.93,180918.59,0.00,0.00,0.00,0.00,0.00),('1','167','884','193703',3784175,'2628','389',113552.69,115238.99,1686.30,274866.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','193703',3784176,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193703',3784177,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193703',3784178,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193703',3784179,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193703',3784180,'2633','389',62533.64,63350.90,817.26,133213.38,0.00,0.00,0.00,0.00,0.00),('1','167','886','193703',3784181,'2634','389',60163.44,61277.80,1114.36,181640.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','193703',3784182,'2635','389',67553.94,68559.93,1005.99,163976.37,0.00,0.00,0.00,0.00,0.00),('1','167','886','193703',3784183,'2636','389',29658.45,30603.26,944.81,154004.03,0.00,0.00,0.00,0.00,0.00),('1','167','887','193703',3784184,'2637','389',161663.10,163156.09,1492.99,243357.37,0.00,0.00,0.00,0.00,0.00),('1','167','887','193703',3784185,'2638','389',157933.98,159140.99,1207.01,196742.63,0.00,0.00,0.00,0.00,0.00),('1','167','887','193703',3784186,'2639','389',130878.90,131936.36,1057.46,172365.98,0.00,0.00,0.00,0.00,0.00),('1','167','887','193703',3784187,'2640','389',123115.11,125144.27,2029.16,330753.08,0.00,0.00,0.00,0.00,0.00),('1','167','888','193703',3784188,'2641','390',346727.48,349693.29,2965.81,771110.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193703',3784189,'2642','390',236707.66,238112.97,1405.31,365380.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193703',3784190,'2643','390',382482.32,383116.62,634.30,164918.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193703',3784191,'2644','390',316035.60,318523.62,2488.02,646885.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','193703',3784192,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193703',3784193,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784667,'2605','389',56063.69,56073.00,9.31,1517.53,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784668,'2606','389',65575.11,65599.65,24.54,4000.02,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784669,'2607','389',111824.82,111824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784670,'2608','389',41951.57,41951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784671,'2609','389',55171.74,55171.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193727',3784672,'2610','389',113388.22,113388.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784673,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784674,'2612','389',211872.40,211872.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784675,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784676,'2614','389',130786.63,130786.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784677,'2615','389',71976.58,71976.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193727',3784678,'2616','389',108710.43,108710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193727',3784679,'2617','389',146768.86,146768.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193727',3784680,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193727',3784681,'2619','389',137903.57,137903.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193727',3784682,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193727',3784683,'2621','389',12595.92,13435.00,839.08,136770.04,0.00,0.00,0.00,0.00,0.00),('1','167','883','193727',3784684,'2622','389',107476.82,108346.89,870.07,141821.41,0.00,0.00,0.00,0.00,0.00),('1','167','883','193727',3784685,'2623','389',113745.82,114878.02,1132.20,184548.60,0.00,0.00,0.00,0.00,0.00),('1','167','883','193727',3784686,'2624','389',47145.35,48449.30,1303.95,212543.85,0.00,0.00,0.00,0.00,0.00),('1','167','884','193727',3784687,'2625','389',131813.06,132349.74,536.68,87478.84,0.00,0.00,0.00,0.00,0.00),('1','167','884','193727',3784688,'2626','389',94152.94,95260.20,1107.26,180483.38,0.00,0.00,0.00,0.00,0.00),('1','167','884','193727',3784689,'2627','389',65949.53,67370.41,1420.88,231603.44,0.00,0.00,0.00,0.00,0.00),('1','167','884','193727',3784690,'2628','389',115238.99,116814.11,1575.12,256744.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','193727',3784691,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193727',3784692,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193727',3784693,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193727',3784694,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193727',3784695,'2633','389',63350.90,63962.84,611.94,99746.22,0.00,0.00,0.00,0.00,0.00),('1','167','886','193727',3784696,'2634','389',61277.80,61953.72,675.92,110174.96,0.00,0.00,0.00,0.00,0.00),('1','167','886','193727',3784697,'2635','389',68559.93,69759.25,1199.32,195489.16,0.00,0.00,0.00,0.00,0.00),('1','167','886','193727',3784698,'2636','389',30603.26,31827.61,1224.35,199569.05,0.00,0.00,0.00,0.00,0.00),('1','167','887','193727',3784699,'2637','389',163156.09,165919.03,2580.13,420561.19,0.00,0.00,182.81,0.00,0.00),('1','167','887','193727',3784700,'2638','389',159140.99,160574.68,1433.69,233691.14,0.00,0.00,0.00,0.00,0.00),('1','167','887','193727',3784701,'2639','389',131936.36,133719.70,1783.34,290684.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','193727',3784702,'2640','389',125144.27,126867.32,1723.05,280857.15,0.00,0.00,0.00,0.00,0.00),('1','167','888','193727',3784703,'2641','390',349693.29,352501.92,2808.63,730243.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','193727',3784704,'2642','390',238112.97,240545.89,2432.92,632559.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193727',3784705,'2643','390',383116.62,385531.32,2414.70,627822.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193727',3784706,'2644','390',318523.62,319694.97,1171.35,304551.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193727',3784707,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193727',3784708,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785474,'2605','389',56073.00,56433.77,360.77,58805.51,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785475,'2606','389',65599.65,66769.47,1169.82,190680.66,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785476,'2607','389',111824.82,112497.73,672.91,109684.33,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785477,'2608','389',41951.57,42778.53,826.96,134794.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785478,'2609','389',55171.74,55171.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193779',3785479,'2610','389',113388.22,113388.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785480,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785481,'2612','389',211872.40,211872.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785482,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785483,'2614','389',130786.63,130786.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785484,'2615','389',71976.58,71976.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193779',3785485,'2616','389',108710.43,108710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193779',3785486,'2617','389',146768.86,146768.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193779',3785487,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193779',3785488,'2619','389',137903.57,137903.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193779',3785489,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193779',3785490,'2621','389',13435.00,14117.28,682.28,111211.64,0.00,0.00,0.00,0.00,0.00),('1','167','883','193779',3785491,'2622','389',108346.89,109168.59,821.70,133937.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','193779',3785492,'2623','389',114878.02,115809.71,931.69,151865.47,0.00,0.00,0.00,0.00,0.00),('1','167','883','193779',3785493,'2624','389',48449.30,48923.46,474.16,77288.08,0.00,0.00,0.00,0.00,0.00),('1','167','884','193779',3785494,'2625','389',132349.74,133758.63,1408.89,229649.07,0.00,0.00,0.00,0.00,0.00),('1','167','884','193779',3785495,'2626','389',95260.20,96335.45,1075.25,175265.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','193779',3785496,'2627','389',67370.41,67370.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193779',3785497,'2628','389',116814.11,118829.22,2015.11,328462.93,0.00,0.00,0.00,0.00,0.00),('1','167','885','193779',3785498,'2629','389',67942.48,67942.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193779',3785499,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193779',3785500,'2631','389',77286.62,77286.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193779',3785501,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193779',3785502,'2633','389',63962.84,64483.79,515.41,84011.83,0.00,0.00,5.54,0.00,0.00),('1','167','886','193779',3785503,'2634','389',61953.72,62485.72,532.00,86716.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193779',3785504,'2635','389',69759.25,70466.80,707.55,115330.65,0.00,0.00,0.00,0.00,0.00),('1','167','886','193779',3785505,'2636','389',31827.61,32606.23,778.62,126915.06,0.00,0.00,0.00,0.00,0.00),('1','167','887','193779',3785506,'2637','389',165919.03,167095.62,1176.59,191784.17,0.00,0.00,0.00,0.00,0.00),('1','167','887','193779',3785507,'2638','389',160574.68,161462.46,887.78,144708.14,0.00,0.00,0.00,0.00,0.00),('1','167','887','193779',3785508,'2639','389',133719.70,134779.07,1059.37,172677.31,0.00,0.00,0.00,0.00,0.00),('1','167','887','193779',3785509,'2640','389',126867.32,127677.54,810.22,132065.86,0.00,0.00,0.00,0.00,0.00),('1','167','888','193779',3785510,'2641','390',352501.92,353907.29,1405.37,365396.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','193779',3785511,'2642','390',240545.89,241220.74,674.85,175461.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193779',3785512,'2643','390',385531.32,387139.93,1608.61,418238.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193779',3785513,'2644','390',319694.97,321373.95,1678.98,436534.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','193779',3785514,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193779',3785515,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786005,'2605','389',56433.77,56433.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786006,'2606','389',66769.47,67674.67,905.20,147547.60,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786007,'2607','389',112497.73,113249.20,751.47,122489.61,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786008,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786009,'2609','389',55171.74,55171.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193803',3786010,'2610','389',113388.22,114034.87,646.65,105403.95,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786011,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786012,'2612','389',211872.40,213928.11,2055.71,335080.73,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786013,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786014,'2614','389',130786.63,131790.22,1003.59,163585.17,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786015,'2615','389',71976.58,73092.66,1116.08,181921.04,0.00,0.00,0.00,0.00,0.00),('1','167','881','193803',3786016,'2616','389',108710.43,109129.00,418.57,68226.91,0.00,0.00,0.00,0.00,0.00),('1','167','882','193803',3786017,'2617','389',146768.86,146825.30,56.44,9199.72,0.00,0.00,0.00,0.00,0.00),('1','167','882','193803',3786018,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193803',3786019,'2619','389',137903.57,138018.12,114.55,18671.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','193803',3786020,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193803',3786021,'2621','389',14117.28,14117.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193803',3786022,'2622','389',109168.59,110114.69,946.10,154214.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','193803',3786023,'2623','389',115809.71,116436.47,626.76,102161.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','193803',3786024,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193803',3786025,'2625','389',133758.63,134315.20,556.57,90720.91,0.00,0.00,0.00,0.00,0.00),('1','167','884','193803',3786026,'2626','389',96335.45,96335.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193803',3786027,'2627','389',67370.41,67370.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193803',3786028,'2628','389',118829.22,119671.19,841.97,137241.11,0.00,0.00,0.00,0.00,0.00),('1','167','885','193803',3786029,'2629','389',67942.48,68353.86,411.38,67054.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','193803',3786030,'2630','389',26582.84,26582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193803',3786031,'2631','389',77286.62,78234.70,948.08,154537.04,0.00,0.00,0.00,0.00,0.00),('1','167','885','193803',3786032,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193803',3786033,'2633','389',64483.79,66340.15,1856.36,302586.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','193803',3786034,'2634','389',62485.72,62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193803',3786035,'2635','389',70466.80,70742.87,276.07,44999.41,0.00,0.00,0.00,0.00,0.00),('1','167','886','193803',3786036,'2636','389',32606.23,33646.90,1040.67,169629.21,0.00,0.00,0.00,0.00,0.00),('1','167','887','193803',3786037,'2637','389',167095.62,168849.34,1753.72,285856.36,0.00,0.00,0.00,0.00,0.00),('1','167','887','193803',3786038,'2638','389',161462.46,162894.37,1431.91,233401.33,0.00,0.00,0.00,0.00,0.00),('1','167','887','193803',3786039,'2639','389',134779.07,137721.31,2902.24,473065.12,0.00,0.00,40.00,0.00,0.00),('1','167','887','193803',3786040,'2640','389',127677.54,127677.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193803',3786041,'2641','390',353907.29,355299.87,1392.58,362070.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','193803',3786042,'2642','390',241220.74,242405.31,1184.57,307988.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193803',3786043,'2643','390',387139.93,388207.96,1068.03,277687.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193803',3786044,'2644','390',321373.95,323698.10,2324.15,604279.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193803',3786045,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193803',3786046,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193809',3786165,'2605','389',56433.77,56433.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193809',3786166,'2606','389',67674.67,68205.04,530.37,86450.31,0.00,0.00,0.00,0.00,0.00),('1','167','880','193809',3786167,'2607','389',113249.20,113819.35,570.15,92934.45,0.00,0.00,0.00,0.00,0.00),('1','167','880','193809',3786168,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193809',3786169,'2609','389',55171.74,55896.53,714.79,116510.77,0.00,0.00,10.00,0.00,0.00),('1','167','880','193809',3786170,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786171,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786172,'2612','389',213928.11,215815.59,1887.48,307659.24,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786173,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786174,'2614','389',131790.22,133497.92,1707.70,278355.10,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786175,'2615','389',73092.66,73092.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193809',3786176,'2616','389',109129.00,110288.74,1159.74,189037.62,0.00,0.00,0.00,0.00,0.00),('1','167','882','193809',3786177,'2617','389',146825.30,146825.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193809',3786178,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193809',3786179,'2619','389',138018.12,138018.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193809',3786180,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193809',3786181,'2621','389',14117.28,14117.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193809',3786182,'2622','389',110114.69,111728.27,1613.58,263013.54,0.00,0.00,0.00,0.00,0.00),('1','167','883','193809',3786183,'2623','389',116436.47,117864.59,1428.12,232783.56,0.00,0.00,0.00,0.00,0.00),('1','167','883','193809',3786184,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193809',3786185,'2625','389',134315.20,134464.79,149.59,24383.17,0.00,0.00,0.00,0.00,0.00),('1','167','884','193809',3786186,'2626','389',96335.45,96335.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193809',3786187,'2627','389',67370.41,67370.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193809',3786188,'2628','389',119671.19,119917.99,246.80,40228.40,0.00,0.00,0.00,0.00,0.00),('1','167','885','193809',3786189,'2629','389',68353.86,68878.50,524.64,85516.32,0.00,0.00,0.00,0.00,0.00),('1','167','885','193809',3786190,'2630','389',26582.84,27545.20,962.36,156864.68,0.00,0.00,0.00,0.00,0.00),('1','167','885','193809',3786191,'2631','389',78234.70,79179.08,944.38,153933.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','193809',3786192,'2632','389',38792.02,38792.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193809',3786193,'2633','389',66340.15,67241.29,901.14,146885.82,0.00,0.00,0.00,0.00,0.00),('1','167','886','193809',3786194,'2634','389',62485.72,62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193809',3786195,'2635','389',70742.87,70742.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193809',3786196,'2636','389',33646.90,34526.71,879.81,143409.03,0.00,0.00,0.00,0.00,0.00),('1','167','887','193809',3786197,'2637','389',168849.34,168849.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193809',3786198,'2638','389',162894.37,163904.95,1010.58,164724.54,0.00,0.00,0.00,0.00,0.00),('1','167','887','193809',3786199,'2639','389',137721.31,138578.77,857.46,139765.98,0.00,0.00,0.00,0.00,0.00),('1','167','887','193809',3786200,'2640','389',127677.54,128332.56,655.02,106768.26,0.00,0.00,0.00,0.00,0.00),('1','167','888','193809',3786201,'2641','390',355299.87,355872.76,572.89,148951.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193809',3786202,'2642','390',242405.31,243284.90,879.59,228693.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193809',3786203,'2643','390',388207.96,389733.09,1525.13,396533.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193809',3786204,'2644','390',323698.10,324328.83,630.73,163989.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','193809',3786205,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193809',3786206,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193811',3786226,'2605','389',56433.77,57501.70,1059.62,172718.06,0.00,0.00,8.31,0.00,0.00),('1','167','880','193811',3786227,'2606','389',68205.04,69184.45,979.41,159643.83,0.00,0.00,0.00,0.00,0.00),('1','167','880','193811',3786228,'2607','389',113819.35,114556.67,737.32,120183.16,0.00,0.00,0.00,0.00,0.00),('1','167','880','193811',3786229,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193811',3786230,'2609','389',55896.53,56514.48,617.95,100725.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','193811',3786231,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786232,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786233,'2612','389',215815.59,217433.49,1617.90,263717.70,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786234,'2613','389',82025.16,82025.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786235,'2614','389',133497.92,134890.27,1392.35,226953.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786236,'2615','389',73092.66,73092.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193811',3786237,'2616','389',110288.74,111192.11,903.37,147249.31,0.00,0.00,0.00,0.00,0.00),('1','167','882','193811',3786238,'2617','389',146825.30,147538.22,712.92,116205.96,0.00,0.00,0.00,0.00,0.00),('1','167','882','193811',3786239,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193811',3786240,'2619','389',138018.12,138467.65,449.53,73273.39,0.00,0.00,0.00,0.00,0.00),('1','167','882','193811',3786241,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193811',3786242,'2621','389',14117.28,14117.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193811',3786243,'2622','389',111728.27,111728.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193811',3786244,'2623','389',117864.59,118692.73,828.14,134986.82,0.00,0.00,0.00,0.00,0.00),('1','167','883','193811',3786245,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193811',3786246,'2625','389',134464.79,135689.93,1225.14,199697.82,0.00,0.00,0.00,0.00,0.00),('1','167','884','193811',3786247,'2626','389',96335.45,97561.07,1225.62,199776.06,0.00,0.00,0.00,0.00,0.00),('1','167','884','193811',3786248,'2627','389',67370.41,67370.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193811',3786249,'2628','389',119917.99,121112.23,1194.24,194661.12,0.00,0.00,0.00,0.00,0.00),('1','167','885','193811',3786250,'2629','389',68878.50,68878.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193811',3786251,'2630','389',27545.20,28400.35,855.15,139389.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','193811',3786252,'2631','389',79179.08,79870.35,691.27,112677.01,0.00,0.00,0.00,0.00,0.00),('1','167','885','193811',3786253,'2632','389',38792.02,39615.88,823.86,134289.18,0.00,0.00,0.00,0.00,0.00),('1','167','886','193811',3786254,'2633','389',67241.29,69820.45,2579.16,420403.08,0.00,0.00,0.00,0.00,0.00),('1','167','886','193811',3786255,'2634','389',62485.72,62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193811',3786256,'2635','389',70742.87,70742.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193811',3786257,'2636','389',34526.71,34816.29,289.58,47201.54,0.00,0.00,0.00,0.00,0.00),('1','167','887','193811',3786258,'2637','389',168849.34,170111.76,1262.42,205774.46,0.00,0.00,0.00,0.00,0.00),('1','167','887','193811',3786259,'2638','389',163904.95,163904.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193811',3786260,'2639','389',138578.77,139897.20,1318.43,214904.09,0.00,0.00,0.00,0.00,0.00),('1','167','887','193811',3786261,'2640','389',128332.56,128332.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193811',3786262,'2641','390',355872.76,356993.98,1121.22,291517.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','193811',3786263,'2642','390',243284.90,244643.34,1358.44,353194.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193811',3786264,'2643','390',389733.09,391033.21,1300.12,338031.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193811',3786265,'2644','390',324328.83,325944.20,1615.37,419996.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','193811',3786266,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193811',3786267,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786308,'2605','389',57501.70,57891.37,389.67,63516.21,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786309,'2606','389',69184.45,69723.20,538.75,87816.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786310,'2607','389',114556.67,115190.83,634.16,103368.08,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786311,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786312,'2609','389',56514.48,56914.10,399.62,65138.06,0.00,0.00,0.00,0.00,0.00),('1','167','880','193814',3786313,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193814',3786314,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193814',3786315,'2612','389',217433.49,218976.51,1543.02,251512.26,0.00,0.00,0.00,0.00,0.00),('1','167','881','193814',3786316,'2613','389',82025.16,83291.10,1264.04,206038.52,0.00,0.00,1.90,0.00,0.00),('1','167','881','193814',3786317,'2614','389',134890.27,134890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193814',3786318,'2615','389',73092.66,73092.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193814',3786319,'2616','389',111192.11,112151.92,959.81,156449.03,0.00,0.00,0.00,0.00,0.00),('1','167','882','193814',3786320,'2617','389',147538.22,147937.88,399.66,65144.58,0.00,0.00,0.00,0.00,0.00),('1','167','882','193814',3786321,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193814',3786322,'2619','389',138467.65,138846.75,379.10,61793.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','193814',3786323,'2620','389',108068.98,108068.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193814',3786324,'2621','389',14117.28,14117.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193814',3786325,'2622','389',111728.27,112621.90,893.63,145661.69,0.00,0.00,0.00,0.00,0.00),('1','167','883','193814',3786326,'2623','389',118692.73,119717.64,1024.91,167060.33,0.00,0.00,0.00,0.00,0.00),('1','167','883','193814',3786327,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193814',3786328,'2625','389',135689.93,136820.67,1130.74,184310.62,0.00,0.00,0.00,0.00,0.00),('1','167','884','193814',3786329,'2626','389',97561.07,98733.25,1172.18,191065.34,0.00,0.00,0.00,0.00,0.00),('1','167','884','193814',3786330,'2627','389',67370.41,67413.35,42.94,6999.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','193814',3786331,'2628','389',121112.23,122245.77,1133.54,184767.02,0.00,0.00,0.00,0.00,0.00),('1','167','885','193814',3786332,'2629','389',68878.50,70142.31,1263.81,206001.03,0.00,0.00,0.00,0.00,0.00),('1','167','885','193814',3786333,'2630','389',28400.35,28400.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193814',3786334,'2631','389',79870.35,80654.39,784.04,127798.52,0.00,0.00,0.00,0.00,0.00),('1','167','885','193814',3786335,'2632','389',39615.88,39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193814',3786336,'2633','389',69820.45,70653.60,833.15,135803.45,0.00,0.00,0.00,0.00,0.00),('1','167','886','193814',3786337,'2634','389',62485.72,62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193814',3786338,'2635','389',70742.87,70742.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193814',3786339,'2636','389',34816.29,35503.78,687.49,112060.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','193814',3786340,'2637','389',170111.76,170913.90,802.14,130748.82,0.00,0.00,0.00,0.00,0.00),('1','167','887','193814',3786341,'2638','389',163904.95,164839.35,934.40,152307.20,0.00,0.00,0.00,0.00,0.00),('1','167','887','193814',3786342,'2639','389',139897.20,139897.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193814',3786343,'2640','389',128332.56,129351.81,1019.25,166137.75,0.00,0.00,0.00,0.00,0.00),('1','167','888','193814',3786344,'2641','390',356993.98,358552.44,1558.46,405199.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193814',3786345,'2642','390',244643.34,245559.67,916.33,238245.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193814',3786346,'2643','390',391033.21,391672.22,639.01,166142.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193814',3786347,'2644','390',325944.20,326903.36,959.16,249381.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193814',3786348,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193814',3786349,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787690,'2605','389',57891.37,58599.65,708.28,115449.64,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787691,'2606','389',69723.20,69723.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787692,'2607','389',115190.83,115968.79,777.96,126807.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787693,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787694,'2609','389',56914.10,57659.99,745.89,121580.07,0.00,0.00,0.00,0.00,0.00),('1','167','880','193912',3787695,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787696,'2611','389',147478.38,147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787697,'2612','389',218976.51,222517.29,3540.78,577147.14,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787698,'2613','389',83291.10,84538.74,1247.64,203365.32,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787699,'2614','389',134890.27,134890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787700,'2615','389',73092.66,73100.02,7.36,1199.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','193912',3787701,'2616','389',112151.92,113369.24,1217.32,198423.16,0.00,0.00,0.00,0.00,0.00),('1','167','882','193912',3787702,'2617','389',147937.88,149101.58,1163.70,189683.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','193912',3787703,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193912',3787704,'2619','389',138846.75,138846.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193912',3787705,'2620','389',108068.98,109100.40,1031.42,168121.46,0.00,0.00,0.00,0.00,0.00),('1','167','883','193912',3787706,'2621','389',14117.28,15203.99,1086.71,177133.73,0.00,0.00,0.00,0.00,0.00),('1','167','883','193912',3787707,'2622','389',112621.90,112621.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193912',3787708,'2623','389',119717.64,120233.15,515.51,84028.13,0.00,0.00,0.00,0.00,0.00),('1','167','883','193912',3787709,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193912',3787710,'2625','389',136820.67,138680.26,1859.59,303113.17,0.00,0.00,0.00,0.00,0.00),('1','167','884','193912',3787711,'2626','389',98733.25,98733.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193912',3787712,'2627','389',67413.35,67413.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193912',3787713,'2628','389',122245.77,124245.29,1999.52,325921.76,0.00,0.00,0.00,0.00,0.00),('1','167','885','193912',3787714,'2629','389',70142.31,70946.42,804.11,131069.93,0.00,0.00,0.00,0.00,0.00),('1','167','885','193912',3787715,'2630','389',28400.35,28400.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193912',3787716,'2631','389',80654.39,81700.15,1045.76,170458.88,0.00,0.00,0.00,0.00,0.00),('1','167','885','193912',3787717,'2632','389',39615.88,39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193912',3787718,'2633','389',70653.60,71980.96,1327.36,216359.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','193912',3787719,'2634','389',62485.72,62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193912',3787720,'2635','389',70742.87,71710.48,922.41,150352.83,0.00,0.00,45.20,0.00,0.00),('1','167','886','193912',3787721,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193912',3787722,'2637','389',170913.90,170923.24,9.34,1522.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','193912',3787723,'2638','389',164839.35,165861.36,1022.01,166587.63,0.00,0.00,0.00,0.00,0.00),('1','167','887','193912',3787724,'2639','389',139897.20,139897.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193912',3787725,'2640','389',129351.81,129351.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193912',3787726,'2641','390',358552.44,359559.40,1006.96,261809.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193912',3787727,'2642','390',245559.67,247692.22,2132.55,554463.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193912',3787728,'2643','390',391672.22,393106.43,1434.21,372894.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193912',3787729,'2644','390',326903.36,327722.37,819.01,212942.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193912',3787730,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193912',3787731,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787848,'2605','389',58599.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787849,'2606','389',69723.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787850,'2607','389',115968.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787851,'2608','389',42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787852,'2609','389',57659.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193919',3787853,'2610','389',114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787854,'2611','389',147478.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787855,'2612','389',222517.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787856,'2613','389',84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787857,'2614','389',134890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787858,'2615','389',73100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193919',3787859,'2616','389',113369.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193919',3787860,'2617','389',149101.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193919',3787861,'2618','389',83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193919',3787862,'2619','389',138846.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193919',3787863,'2620','389',109100.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193919',3787864,'2621','389',15203.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193919',3787865,'2622','389',112621.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193919',3787866,'2623','389',120233.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193919',3787867,'2624','389',48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193919',3787868,'2625','389',138680.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193919',3787869,'2626','389',98733.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193919',3787870,'2627','389',67413.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193919',3787871,'2628','389',124245.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193919',3787872,'2629','389',70946.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193919',3787873,'2630','389',28400.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193919',3787874,'2631','389',81700.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193919',3787875,'2632','389',39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193919',3787876,'2633','389',71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193919',3787877,'2634','389',62485.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193919',3787878,'2635','389',71710.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193919',3787879,'2636','389',35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193919',3787880,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193919',3787881,'2638','389',165861.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193919',3787882,'2639','389',139897.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193919',3787883,'2640','389',129351.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193919',3787884,'2641','390',359559.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193919',3787885,'2642','390',247692.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193919',3787886,'2643','390',393106.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193919',3787887,'2644','390',327722.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193919',3787888,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193919',3787889,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788010,'2605','389',58599.65,59581.16,981.51,161949.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788011,'2606','389',69723.20,69723.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788012,'2607','389',115968.79,116501.75,532.96,87938.40,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788013,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788014,'2609','389',57659.99,58138.31,478.32,78922.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','193925',3788015,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193925',3788016,'2611','389',147478.38,148043.31,564.93,93213.45,0.00,0.00,0.00,0.00,0.00),('1','167','881','193925',3788017,'2612','389',222517.29,223891.36,1374.07,226721.55,0.00,0.00,0.00,0.00,0.00),('1','167','881','193925',3788018,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193925',3788019,'2614','389',134890.27,135879.21,988.94,163175.10,0.00,0.00,0.00,0.00,0.00),('1','167','881','193925',3788020,'2615','389',73100.02,73682.44,580.43,95770.95,0.00,0.00,1.99,0.00,0.00),('1','167','881','193925',3788021,'2616','389',113369.24,114004.65,635.41,104842.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','193925',3788022,'2617','389',149101.58,149484.80,383.22,63231.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','193925',3788023,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193925',3788024,'2619','389',138846.75,139675.66,828.91,136770.15,0.00,0.00,0.00,0.00,0.00),('1','167','882','193925',3788025,'2620','389',109100.40,109100.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193925',3788026,'2621','389',15203.99,15944.53,740.54,122189.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','193925',3788027,'2622','389',112621.90,112621.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193925',3788028,'2623','389',120233.15,121788.89,1555.74,256697.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','193925',3788029,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193925',3788030,'2625','389',138680.26,139059.60,379.34,62591.10,0.00,0.00,0.00,0.00,0.00),('1','167','884','193925',3788031,'2626','389',98733.25,98733.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193925',3788032,'2627','389',67413.35,68714.50,1301.15,214689.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','193925',3788033,'2628','389',124245.29,124321.95,76.66,12648.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','193925',3788034,'2629','389',70946.42,70946.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193925',3788035,'2630','389',28400.35,28955.83,555.48,91654.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','193925',3788036,'2631','389',81700.15,82752.44,1052.29,173627.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','193925',3788037,'2632','389',39615.88,39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193925',3788038,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193925',3788039,'2634','389',62485.72,63156.39,670.67,110660.55,0.00,0.00,0.00,0.00,0.00),('1','167','886','193925',3788040,'2635','389',71710.48,71710.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193925',3788041,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193925',3788042,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193925',3788043,'2638','389',165861.36,167161.35,1299.99,214499.01,0.00,0.00,0.00,0.00,0.00),('1','167','887','193925',3788044,'2639','389',139897.20,141236.33,1339.13,220956.45,0.00,0.00,0.00,0.00,0.00),('1','167','887','193925',3788045,'2640','389',129351.81,129351.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193925',3788046,'2641','390',359559.40,361141.91,1582.51,411452.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193925',3788047,'2642','390',247692.22,248196.81,504.59,131193.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','193925',3788048,'2643','390',393106.43,394514.15,1407.72,366007.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','193925',3788049,'2644','390',327722.37,328483.72,761.35,197951.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193925',3788050,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193925',3788051,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193947',3788519,'2605','389',59581.16,60732.35,1151.19,189946.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','193947',3788520,'2606','389',69723.20,70775.77,1052.57,173674.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','193947',3788521,'2607','389',116501.75,117508.12,963.55,158985.75,0.00,0.00,42.82,0.00,0.00),('1','167','880','193947',3788522,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193947',3788523,'2609','389',58138.31,58450.69,312.38,51542.70,0.00,0.00,0.00,0.00,0.00),('1','167','880','193947',3788524,'2610','389',114034.87,114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788525,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788526,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788527,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788528,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788529,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193947',3788530,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193947',3788531,'2617','389',149484.80,150481.64,996.84,164478.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','193947',3788532,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193947',3788533,'2619','389',139675.66,140304.08,628.42,103689.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','193947',3788534,'2620','389',109100.40,109495.26,394.86,65151.90,0.00,0.00,0.00,0.00,0.00),('1','167','883','193947',3788535,'2621','389',15944.53,16724.44,779.91,128685.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','193947',3788536,'2622','389',112621.90,113495.59,873.69,144158.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','193947',3788537,'2623','389',121788.89,122362.00,573.11,94563.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','193947',3788538,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193947',3788539,'2625','389',139059.60,140060.62,1001.02,165168.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','193947',3788540,'2626','389',98733.25,99993.98,1260.73,208020.45,0.00,0.00,0.00,0.00,0.00),('1','167','884','193947',3788541,'2627','389',68714.50,69668.46,953.96,157403.40,0.00,0.00,0.00,0.00,0.00),('1','167','884','193947',3788542,'2628','389',124321.95,124931.74,609.79,100615.35,0.00,0.00,0.00,0.00,0.00),('1','167','885','193947',3788543,'2629','389',70946.42,71549.13,602.71,99447.15,0.00,0.00,0.00,0.00,0.00),('1','167','885','193947',3788544,'2630','389',28955.83,28955.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193947',3788545,'2631','389',82752.44,83738.04,985.60,162624.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193947',3788546,'2632','389',39615.88,39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193947',3788547,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193947',3788548,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193947',3788549,'2635','389',71710.48,72222.25,511.77,84442.05,0.00,0.00,0.00,0.00,0.00),('1','167','886','193947',3788550,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193947',3788551,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193947',3788552,'2638','389',167161.35,168484.43,1323.08,218308.20,0.00,0.00,0.00,0.00,0.00),('1','167','887','193947',3788553,'2639','389',141236.33,142173.44,937.11,154623.15,0.00,0.00,0.00,0.00,0.00),('1','167','887','193947',3788554,'2640','389',129351.81,130192.60,840.79,138730.35,0.00,0.00,0.00,0.00,0.00),('1','167','888','193947',3788555,'2641','390',361141.91,362074.90,932.99,242577.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','193947',3788556,'2642','390',248196.81,248730.09,533.28,138652.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193947',3788557,'2643','390',394514.15,396871.51,2357.36,612913.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','193947',3788558,'2644','390',328483.72,329814.07,1330.35,345891.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193947',3788559,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193947',3788560,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788982,'2605','389',60732.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788983,'2606','389',70775.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788984,'2607','389',117508.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788985,'2608','389',42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788986,'2609','389',58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193970',3788987,'2610','389',114034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788988,'2611','389',148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788989,'2612','389',223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788990,'2613','389',84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788991,'2614','389',135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788992,'2615','389',73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193970',3788993,'2616','389',114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193970',3788994,'2617','389',150481.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193970',3788995,'2618','389',83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193970',3788996,'2619','389',140304.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193970',3788997,'2620','389',109495.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193970',3788998,'2621','389',16724.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193970',3788999,'2622','389',113495.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193970',3789000,'2623','389',122362.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','193970',3789001,'2624','389',48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193970',3789002,'2625','389',140060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193970',3789003,'2626','389',99993.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193970',3789004,'2627','389',69668.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193970',3789005,'2628','389',124931.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193970',3789006,'2629','389',71549.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193970',3789007,'2630','389',28955.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193970',3789008,'2631','389',83738.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193970',3789009,'2632','389',39615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193970',3789010,'2633','389',71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193970',3789011,'2634','389',63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193970',3789012,'2635','389',72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193970',3789013,'2636','389',35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193970',3789014,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193970',3789015,'2638','389',168484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193970',3789016,'2639','389',142173.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193970',3789017,'2640','389',130192.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193970',3789018,'2641','390',362074.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','193970',3789019,'2642','390',248730.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193970',3789020,'2643','390',396871.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193970',3789021,'2644','390',329814.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193970',3789022,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193970',3789023,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789066,'2605','389',60732.35,61867.16,1134.81,187243.65,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789067,'2606','389',70775.77,71621.58,845.81,139558.65,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789068,'2607','389',117508.12,118102.91,594.79,98140.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789069,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789070,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193975',3789071,'2610','389',114034.87,114500.01,465.14,76748.10,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789072,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789073,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789074,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789075,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789076,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193975',3789077,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193975',3789078,'2617','389',150481.64,151461.44,979.80,161667.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193975',3789079,'2618','389',83285.55,83285.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193975',3789080,'2619','389',140304.08,140780.84,476.76,78665.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','193975',3789081,'2620','389',109495.26,109709.33,214.07,35321.55,0.00,0.00,0.00,0.00,0.00),('1','167','883','193975',3789082,'2621','389',16724.44,17623.86,899.42,148404.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','193975',3789083,'2622','389',113495.59,114031.88,536.29,88487.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','193975',3789084,'2623','389',122362.00,122813.65,451.65,74522.25,0.00,0.00,0.00,0.00,0.00),('1','167','883','193975',3789085,'2624','389',48923.46,48923.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','193975',3789086,'2625','389',140060.62,141216.38,1155.76,190700.40,0.00,0.00,0.00,0.00,0.00),('1','167','884','193975',3789087,'2626','389',99993.98,100942.94,948.96,156578.40,0.00,0.00,0.00,0.00,0.00),('1','167','884','193975',3789088,'2627','389',69668.46,70205.43,536.97,88600.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','193975',3789089,'2628','389',124931.74,125640.48,708.74,116942.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','193975',3789090,'2629','389',71549.13,72181.37,632.24,104319.60,0.00,0.00,0.00,0.00,0.00),('1','167','885','193975',3789091,'2630','389',28955.83,28955.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193975',3789092,'2631','389',83738.04,84520.01,781.97,129025.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','193975',3789093,'2632','389',39615.88,41473.96,1858.08,306583.20,0.00,0.00,0.00,0.00,0.00),('1','167','886','193975',3789094,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193975',3789095,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193975',3789096,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193975',3789097,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193975',3789098,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193975',3789099,'2638','389',168484.43,169859.07,1374.64,226815.60,0.00,0.00,0.00,0.00,0.00),('1','167','887','193975',3789100,'2639','389',142173.44,142962.41,788.97,130180.05,0.00,0.00,0.00,0.00,0.00),('1','167','887','193975',3789101,'2640','389',130192.60,130972.24,779.64,128640.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','193975',3789102,'2641','390',362074.90,365107.43,3032.53,788457.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','193975',3789103,'2642','390',248730.09,248822.39,92.30,23998.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193975',3789104,'2643','390',396871.51,398302.79,1431.28,372132.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193975',3789105,'2644','390',329814.07,330605.07,791.00,205660.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193975',3789106,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193975',3789107,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789387,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789388,'2606','389',71621.58,72317.45,695.87,114818.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789389,'2607','389',118102.91,118707.91,605.00,99825.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789390,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789391,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','193999',3789392,'2610','389',114500.01,114762.83,262.82,43365.30,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789393,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789394,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789395,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789396,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789397,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','193999',3789398,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','193999',3789399,'2617','389',151461.44,151840.87,379.43,62605.95,0.00,0.00,0.00,0.00,0.00),('1','167','882','193999',3789400,'2618','389',83285.55,83725.80,440.25,72641.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','193999',3789401,'2619','389',140780.84,141353.35,572.51,94464.15,0.00,0.00,0.00,0.00,0.00),('1','167','882','193999',3789402,'2620','389',109709.33,110157.19,447.86,73896.90,0.00,0.00,0.00,0.00,0.00),('1','167','883','193999',3789403,'2621','389',17623.86,18012.28,388.42,64089.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','193999',3789404,'2622','389',114031.88,114687.62,655.74,108197.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','193999',3789405,'2623','389',122813.65,123437.59,623.94,102950.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','193999',3789406,'2624','389',48923.46,49611.51,688.05,113528.25,0.00,0.00,0.00,0.00,0.00),('1','167','884','193999',3789407,'2625','389',141216.38,142377.77,1161.39,191629.35,0.00,0.00,0.00,0.00,0.00),('1','167','884','193999',3789408,'2626','389',100942.94,101810.44,867.50,143137.50,0.00,0.00,0.00,0.00,0.00),('1','167','884','193999',3789409,'2627','389',70205.43,71576.27,1370.84,226188.60,0.00,0.00,0.00,0.00,0.00),('1','167','884','193999',3789410,'2628','389',125640.48,126460.58,820.10,135316.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','193999',3789411,'2629','389',72181.37,73045.66,864.29,142607.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','193999',3789412,'2630','389',28955.83,28955.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','193999',3789413,'2631','389',84520.01,84887.04,367.03,60559.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','193999',3789414,'2632','389',41473.96,41493.96,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193999',3789415,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193999',3789416,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193999',3789417,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','193999',3789418,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193999',3789419,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','193999',3789420,'2638','389',169859.07,171041.51,1182.44,195102.60,0.00,0.00,0.00,0.00,0.00),('1','167','887','193999',3789421,'2639','389',142962.41,143843.44,881.03,145369.95,0.00,0.00,0.00,0.00,0.00),('1','167','887','193999',3789422,'2640','389',130972.24,131662.78,690.54,113939.10,0.00,0.00,0.00,0.00,0.00),('1','167','888','193999',3789423,'2641','390',365107.43,366815.20,1707.77,444020.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','193999',3789424,'2642','390',248822.39,249867.27,1044.88,271668.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','193999',3789425,'2643','390',398302.79,399335.34,1032.55,268463.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','193999',3789426,'2644','390',330605.07,331254.48,649.41,168846.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','193999',3789427,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','193999',3789428,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789762,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789763,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789764,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789765,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789766,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194014',3789767,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789768,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789769,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789770,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789771,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789772,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194014',3789773,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194014',3789774,'2617','389',151840.87,152265.37,424.50,70042.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','194014',3789775,'2618','389',83725.80,84059.20,333.40,55011.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194014',3789776,'2619','389',141353.35,141972.61,619.26,102177.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','194014',3789777,'2620','389',110157.19,110631.53,474.34,78266.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','194014',3789778,'2621','389',18012.28,18687.98,675.70,111490.50,0.00,0.00,0.00,0.00,0.00),('1','167','883','194014',3789779,'2622','389',114687.62,115600.07,912.45,150554.25,0.00,0.00,0.00,0.00,0.00),('1','167','883','194014',3789780,'2623','389',123437.59,124408.61,971.02,160218.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','194014',3789781,'2624','389',49611.51,49611.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194014',3789782,'2625','389',142377.77,144585.29,2207.52,364240.80,0.00,0.00,0.00,0.00,0.00),('1','167','884','194014',3789783,'2626','389',101810.44,103509.31,1698.87,280313.55,0.00,0.00,0.00,0.00,0.00),('1','167','884','194014',3789784,'2627','389',71576.27,72584.56,1008.29,166367.85,0.00,0.00,0.00,0.00,0.00),('1','167','884','194014',3789785,'2628','389',126460.58,127710.38,1249.80,206217.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194014',3789786,'2629','389',73045.66,73828.45,782.79,129160.35,0.00,0.00,0.00,0.00,0.00),('1','167','885','194014',3789787,'2630','389',28955.83,29533.93,578.10,95386.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194014',3789788,'2631','389',84887.04,85466.71,579.67,95645.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','194014',3789789,'2632','389',41493.96,42000.11,506.15,83514.75,0.00,0.00,0.00,0.00,0.00),('1','167','886','194014',3789790,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194014',3789791,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194014',3789792,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194014',3789793,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194014',3789794,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194014',3789795,'2638','389',171041.51,172477.15,1435.64,236880.60,0.00,0.00,0.00,0.00,0.00),('1','167','887','194014',3789796,'2639','389',143843.44,144560.29,716.85,118280.25,0.00,0.00,0.00,0.00,0.00),('1','167','887','194014',3789797,'2640','389',131662.78,132680.97,1002.83,165466.95,0.00,0.00,15.36,0.00,0.00),('1','167','888','194014',3789798,'2641','390',366815.20,369123.49,2308.29,600155.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194014',3789799,'2642','390',249867.27,251979.47,2112.20,549172.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194014',3789800,'2643','390',399335.34,402441.62,3106.28,807632.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194014',3789801,'2644','390',331254.48,332784.48,1530.00,397800.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194014',3789802,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194014',3789803,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791553,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791554,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791555,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791556,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791557,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194130',3791558,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791559,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791560,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791561,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791562,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791563,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194130',3791564,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194130',3791565,'2617','389',152265.37,153071.71,806.34,133046.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','194130',3791566,'2618','389',84059.20,84648.98,589.78,97313.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','194130',3791567,'2619','389',141972.61,142753.63,781.02,128868.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','194130',3791568,'2620','389',110631.53,110631.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194130',3791569,'2621','389',18687.98,19341.01,653.03,107749.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','194130',3791570,'2622','389',115600.07,116965.51,1365.44,225297.60,0.00,0.00,0.00,0.00,0.00),('1','167','883','194130',3791571,'2623','389',124408.61,125132.97,724.36,119519.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','194130',3791572,'2624','389',49611.51,49951.71,340.20,56133.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194130',3791573,'2625','389',144585.29,144585.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194130',3791574,'2626','389',103509.31,104604.05,1094.74,180632.10,0.00,0.00,0.00,0.00,0.00),('1','167','884','194130',3791575,'2627','389',72584.56,73936.27,1351.71,223032.15,0.00,0.00,0.00,0.00,0.00),('1','167','884','194130',3791576,'2628','389',127710.38,128540.11,829.73,136905.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','194130',3791577,'2629','389',73828.45,74438.67,610.22,100686.30,0.00,0.00,0.00,0.00,0.00),('1','167','885','194130',3791578,'2630','389',29533.93,29925.14,391.21,64549.65,0.00,0.00,0.00,0.00,0.00),('1','167','885','194130',3791579,'2631','389',85466.71,86251.08,784.37,129421.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','194130',3791580,'2632','389',42000.11,42403.36,403.25,66536.25,0.00,0.00,0.00,0.00,0.00),('1','167','886','194130',3791581,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194130',3791582,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194130',3791583,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194130',3791584,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194130',3791585,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194130',3791586,'2638','389',172477.15,173603.07,1125.92,185776.80,0.00,0.00,0.00,0.00,0.00),('1','167','887','194130',3791587,'2639','389',144560.29,145410.88,850.59,140347.35,0.00,0.00,0.00,0.00,0.00),('1','167','887','194130',3791588,'2640','389',132680.97,133591.95,910.98,150311.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','194130',3791589,'2641','390',369123.49,372256.69,3133.20,814632.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194130',3791590,'2642','390',251979.47,254570.74,2591.27,673730.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194130',3791591,'2643','390',402441.62,404058.10,1616.48,420284.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194130',3791592,'2644','390',332784.48,333969.03,1184.55,307983.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194130',3791593,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194130',3791594,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792688,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792689,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792690,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792691,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792692,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194183',3792693,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792694,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792695,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792696,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792697,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792698,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194183',3792699,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194183',3792700,'2617','389',153071.71,154261.31,1189.60,196284.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194183',3792701,'2618','389',84648.98,84648.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194183',3792702,'2619','389',142753.63,143548.79,795.16,131201.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','194183',3792703,'2620','389',110631.53,111248.63,617.10,101821.50,0.00,0.00,0.00,0.00,0.00),('1','167','883','194183',3792704,'2621','389',19341.01,20517.80,1176.79,194170.35,0.00,0.00,0.00,0.00,0.00),('1','167','883','194183',3792705,'2622','389',116965.51,118180.74,1215.23,200512.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','194183',3792706,'2623','389',125132.97,126085.99,953.02,157248.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','194183',3792707,'2624','389',49951.71,50619.93,668.22,110256.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','194183',3792708,'2625','389',144585.29,144921.93,336.64,55545.60,0.00,0.00,0.00,0.00,0.00),('1','167','884','194183',3792709,'2626','389',104604.05,104952.42,348.37,57481.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','194183',3792710,'2627','389',73936.27,74318.20,381.93,63018.45,0.00,0.00,0.00,0.00,0.00),('1','167','884','194183',3792711,'2628','389',128540.11,128750.84,210.73,34770.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','194183',3792712,'2629','389',74438.67,75464.37,1025.70,169240.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194183',3792713,'2630','389',29925.14,30539.84,614.70,101425.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194183',3792714,'2631','389',86251.08,86839.67,588.59,97117.35,0.00,0.00,0.00,0.00,0.00),('1','167','885','194183',3792715,'2632','389',42403.36,43051.73,648.37,106981.05,0.00,0.00,0.00,0.00,0.00),('1','167','886','194183',3792716,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194183',3792717,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194183',3792718,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194183',3792719,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194183',3792720,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194183',3792721,'2638','389',173603.07,175153.39,1550.32,255802.80,0.00,0.00,0.00,0.00,0.00),('1','167','887','194183',3792722,'2639','389',145410.88,145410.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194183',3792723,'2640','389',133591.95,135127.45,1535.50,253357.50,0.00,0.00,0.00,0.00,0.00),('1','167','888','194183',3792724,'2641','390',372256.69,373481.84,1225.15,318539.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194183',3792725,'2642','390',254570.74,255474.44,903.70,234962.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194183',3792726,'2643','390',404058.10,405037.72,979.62,254701.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194183',3792727,'2644','390',333969.03,333969.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194183',3792728,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194183',3792729,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792741,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792742,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792743,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792744,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792745,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194186',3792746,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792747,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792748,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792749,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792750,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792751,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194186',3792752,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194186',3792753,'2617','389',154261.31,154927.25,655.94,108230.10,0.00,0.00,10.00,0.00,0.00),('1','167','882','194186',3792754,'2618','389',84648.98,85338.30,679.32,112087.80,0.00,0.00,10.00,0.00,0.00),('1','167','882','194186',3792755,'2619','389',143548.79,144145.62,586.83,96826.95,0.00,0.00,10.00,0.00,0.00),('1','167','882','194186',3792756,'2620','389',111248.63,111915.69,658.76,108695.40,0.00,0.00,8.30,0.00,0.00),('1','167','883','194186',3792757,'2621','389',20517.80,21138.93,601.13,99186.45,0.00,0.00,20.00,0.00,0.00),('1','167','883','194186',3792758,'2622','389',118180.74,119135.13,944.39,155824.35,0.00,0.00,10.00,0.00,0.00),('1','167','883','194186',3792759,'2623','389',126085.99,127121.23,1025.24,169164.60,0.00,0.00,10.00,0.00,0.00),('1','167','883','194186',3792760,'2624','389',50619.93,52159.03,1529.10,252301.50,0.00,0.00,10.00,0.00,0.00),('1','167','884','194186',3792761,'2625','389',144921.93,144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194186',3792762,'2626','389',104952.42,104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194186',3792763,'2627','389',74318.20,74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194186',3792764,'2628','389',128750.84,128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194186',3792765,'2629','389',75464.37,76113.17,638.80,105402.00,0.00,0.00,10.00,0.00,0.00),('1','167','885','194186',3792766,'2630','389',30539.84,31503.57,953.73,157365.45,0.00,0.00,10.00,0.00,0.00),('1','167','885','194186',3792767,'2631','389',86839.67,87333.17,473.50,78127.50,0.00,0.00,20.00,0.00,0.00),('1','167','885','194186',3792768,'2632','389',43051.73,43534.87,473.14,78068.10,0.00,0.00,10.00,0.00,0.00),('1','167','886','194186',3792769,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194186',3792770,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194186',3792771,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194186',3792772,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194186',3792773,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194186',3792774,'2638','389',175153.39,176296.59,1133.20,186978.00,0.00,0.00,10.00,0.00,0.00),('1','167','887','194186',3792775,'2639','389',145410.88,146431.18,1010.30,166699.50,0.00,0.00,10.00,0.00,0.00),('1','167','887','194186',3792776,'2640','389',135127.45,136071.31,933.86,154086.90,0.00,0.00,10.00,0.00,0.00),('1','167','888','194186',3792777,'2641','390',373481.84,374810.09,1328.25,345345.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194186',3792778,'2642','390',255474.44,257106.92,1632.48,424444.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194186',3792779,'2643','390',405037.72,406573.94,1536.22,399417.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194186',3792780,'2644','390',333969.03,336255.08,2286.05,594373.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194186',3792781,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194186',3792782,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793747,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793748,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793749,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793750,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793751,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194233',3793752,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793753,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793754,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793755,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793756,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793757,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194233',3793758,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194233',3793759,'2617','389',154927.25,156222.44,1295.19,213706.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','194233',3793760,'2618','389',85338.30,85961.91,623.61,102895.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','194233',3793761,'2619','389',144145.62,144856.63,711.01,117316.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','194233',3793762,'2620','389',111915.69,112497.56,581.87,96008.55,0.00,0.00,0.00,0.00,0.00),('1','167','883','194233',3793763,'2621','389',21138.93,21961.63,822.70,135745.50,0.00,0.00,0.00,0.00,0.00),('1','167','883','194233',3793764,'2622','389',119135.13,120355.71,1220.58,201395.70,0.00,0.00,0.00,0.00,0.00),('1','167','883','194233',3793765,'2623','389',127121.23,128094.25,973.02,160548.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','194233',3793766,'2624','389',52159.03,52769.83,610.80,100782.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194233',3793767,'2625','389',144921.93,144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194233',3793768,'2626','389',104952.42,104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194233',3793769,'2627','389',74318.20,74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194233',3793770,'2628','389',128750.84,128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194233',3793771,'2629','389',76113.17,77171.95,1058.78,174698.70,0.00,0.00,0.00,0.00,0.00),('1','167','885','194233',3793772,'2630','389',31503.57,32470.51,966.94,159545.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','194233',3793773,'2631','389',87333.17,88391.12,1057.95,174561.75,0.00,0.00,0.00,0.00,0.00),('1','167','885','194233',3793774,'2632','389',43534.87,44393.25,858.38,141632.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','194233',3793775,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194233',3793776,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194233',3793777,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194233',3793778,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194233',3793779,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194233',3793780,'2638','389',176296.59,177881.96,1585.37,261586.05,0.00,0.00,0.00,0.00,0.00),('1','167','887','194233',3793781,'2639','389',146431.18,148201.64,1770.46,292125.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','194233',3793782,'2640','389',136071.31,137187.57,1116.26,184182.90,0.00,0.00,0.00,0.00,0.00),('1','167','888','194233',3793783,'2641','390',374810.09,376549.66,1739.57,452288.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194233',3793784,'2642','390',257106.92,258111.96,1005.04,261310.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194233',3793785,'2643','390',406573.94,408597.08,2023.14,526016.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194233',3793786,'2644','390',336255.08,338722.04,2466.96,641409.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','194233',3793787,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194233',3793788,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795743,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795744,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795745,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795746,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795747,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194351',3795748,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795749,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795750,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795751,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795752,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795753,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194351',3795754,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194351',3795755,'2617','389',156222.44,157816.97,1594.53,263097.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','194351',3795756,'2618','389',85961.91,87785.86,1823.95,300951.75,0.00,0.00,0.00,0.00,0.00),('1','167','882','194351',3795757,'2619','389',144856.63,146184.97,1328.34,219176.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','194351',3795758,'2620','389',112497.56,113141.55,643.99,106258.35,0.00,0.00,0.00,0.00,0.00),('1','167','883','194351',3795759,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194351',3795760,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194351',3795761,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194351',3795762,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194351',3795763,'2625','389',144921.93,144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194351',3795764,'2626','389',104952.42,104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194351',3795765,'2627','389',74318.20,74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194351',3795766,'2628','389',128750.84,128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194351',3795767,'2629','389',77171.95,78508.31,1336.36,220499.40,0.00,0.00,0.00,0.00,0.00),('1','167','885','194351',3795768,'2630','389',32470.51,33999.85,1529.34,252341.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','194351',3795769,'2631','389',88391.12,89882.58,1491.46,246090.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','194351',3795770,'2632','389',44393.25,45422.12,1028.87,169763.55,0.00,0.00,0.00,0.00,0.00),('1','167','886','194351',3795771,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194351',3795772,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194351',3795773,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194351',3795774,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194351',3795775,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194351',3795776,'2638','389',177881.96,178609.97,728.01,120121.65,0.00,0.00,0.00,0.00,0.00),('1','167','887','194351',3795777,'2639','389',148201.64,148718.18,516.54,85229.10,0.00,0.00,0.00,0.00,0.00),('1','167','887','194351',3795778,'2640','389',137187.57,137509.38,321.81,53098.65,0.00,0.00,0.00,0.00,0.00),('1','167','888','194351',3795779,'2641','390',376549.66,377966.67,1417.01,368422.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','194351',3795780,'2642','390',258111.96,258111.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194351',3795781,'2643','390',408597.08,409652.86,1055.78,274502.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194351',3795782,'2644','390',338722.04,339521.39,799.35,207831.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194351',3795783,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194351',3795784,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796953,'2605','389',61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796954,'2606','389',72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796955,'2607','389',118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796956,'2608','389',42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796957,'2609','389',58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194412',3796958,'2610','389',114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796959,'2611','389',148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796960,'2612','389',223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796961,'2613','389',84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796962,'2614','389',135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796963,'2615','389',73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194412',3796964,'2616','389',114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194412',3796965,'2617','389',157816.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194412',3796966,'2618','389',87785.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194412',3796967,'2619','389',146184.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194412',3796968,'2620','389',113141.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194412',3796969,'2621','389',21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194412',3796970,'2622','389',120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194412',3796971,'2623','389',128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194412',3796972,'2624','389',52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194412',3796973,'2625','389',144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194412',3796974,'2626','389',104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194412',3796975,'2627','389',74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194412',3796976,'2628','389',128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194412',3796977,'2629','389',78508.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194412',3796978,'2630','389',33999.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194412',3796979,'2631','389',89882.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194412',3796980,'2632','389',45422.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194412',3796981,'2633','389',71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194412',3796982,'2634','389',63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194412',3796983,'2635','389',72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194412',3796984,'2636','389',35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194412',3796985,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194412',3796986,'2638','389',178609.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194412',3796987,'2639','389',148718.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194412',3796988,'2640','389',137509.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194412',3796989,'2641','390',377966.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194412',3796990,'2642','390',258111.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194412',3796991,'2643','390',409652.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194412',3796992,'2644','390',339521.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194412',3796993,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194412',3796994,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797234,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797235,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797236,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797237,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797238,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194427',3797239,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797240,'2611','389',148043.31,148043.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797241,'2612','389',223891.36,223891.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797242,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797243,'2614','389',135879.21,135879.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797244,'2615','389',73682.44,73682.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194427',3797245,'2616','389',114004.65,114004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194427',3797246,'2617','389',157816.97,158789.03,972.06,160389.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','194427',3797247,'2618','389',87785.86,89275.16,1489.30,245734.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','194427',3797248,'2619','389',146184.97,147647.62,1462.65,241337.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','194427',3797249,'2620','389',113141.55,113837.68,696.13,114861.45,0.00,0.00,0.00,0.00,0.00),('1','167','883','194427',3797250,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194427',3797251,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194427',3797252,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194427',3797253,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194427',3797254,'2625','389',144921.93,144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194427',3797255,'2626','389',104952.42,104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194427',3797256,'2627','389',74318.20,74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194427',3797257,'2628','389',128750.84,128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194427',3797258,'2629','389',78508.31,80636.61,2128.30,351169.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194427',3797259,'2630','389',33999.85,34760.12,760.27,125444.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','194427',3797260,'2631','389',89882.58,90893.62,1006.04,165996.60,0.00,0.00,5.00,0.00,0.00),('1','167','885','194427',3797261,'2632','389',45422.12,45422.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194427',3797262,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194427',3797263,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194427',3797264,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194427',3797265,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194427',3797266,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194427',3797267,'2638','389',178609.97,178978.37,368.40,60786.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194427',3797268,'2639','389',148718.18,149115.50,397.32,65557.80,0.00,0.00,0.00,0.00,0.00),('1','167','887','194427',3797269,'2640','389',137509.38,137509.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194427',3797270,'2641','390',377966.67,379347.44,1380.77,359000.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194427',3797271,'2642','390',258111.96,258821.17,709.21,184394.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194427',3797272,'2643','390',409652.86,410357.46,704.60,183196.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194427',3797273,'2644','390',339521.39,340311.61,790.22,205457.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','194427',3797274,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194427',3797275,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797451,'2605','389',61867.16,61867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797452,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797453,'2607','389',118707.91,118707.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797454,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797455,'2609','389',58450.69,58450.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194437',3797456,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194437',3797457,'2611','389',148043.31,148706.74,663.43,109465.95,0.00,0.00,0.00,0.00,0.00),('1','167','881','194437',3797458,'2612','389',223891.36,225148.66,1247.30,205804.50,0.00,0.00,10.00,0.00,0.00),('1','167','881','194437',3797459,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194437',3797460,'2614','389',135879.21,136801.22,922.01,152131.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','194437',3797461,'2615','389',73682.44,74646.61,964.17,159088.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194437',3797462,'2616','389',114004.65,114905.91,901.26,148707.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','194437',3797463,'2617','389',158789.03,159175.70,376.67,62150.55,0.00,0.00,10.00,0.00,0.00),('1','167','882','194437',3797464,'2618','389',89275.16,90027.93,752.77,124207.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','194437',3797465,'2619','389',147647.62,148191.70,544.08,89773.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','194437',3797466,'2620','389',113837.68,114283.34,442.42,72999.30,0.00,0.00,3.24,0.00,0.00),('1','167','883','194437',3797467,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194437',3797468,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194437',3797469,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194437',3797470,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194437',3797471,'2625','389',144921.93,144921.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194437',3797472,'2626','389',104952.42,104952.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194437',3797473,'2627','389',74318.20,74318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194437',3797474,'2628','389',128750.84,128750.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194437',3797475,'2629','389',80636.61,81288.02,641.41,105832.65,0.00,0.00,10.00,0.00,0.00),('1','167','885','194437',3797476,'2630','389',34760.12,35254.65,494.53,81597.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','194437',3797477,'2631','389',90893.62,91540.67,647.05,106763.25,0.00,0.00,0.00,0.00,0.00),('1','167','885','194437',3797478,'2632','389',45422.12,45901.30,469.18,77414.70,0.00,0.00,10.00,0.00,0.00),('1','167','886','194437',3797479,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194437',3797480,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194437',3797481,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194437',3797482,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194437',3797483,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194437',3797484,'2638','389',178978.37,180946.20,1957.83,323041.95,0.00,0.00,10.00,0.00,0.00),('1','167','887','194437',3797485,'2639','389',149115.50,150120.65,1005.15,165849.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','194437',3797486,'2640','389',137509.38,138392.84,873.46,144120.90,0.00,0.00,10.00,0.00,0.00),('1','167','888','194437',3797487,'2641','390',379347.44,380914.78,1567.34,407508.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194437',3797488,'2642','390',258821.17,259760.94,939.77,244340.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194437',3797489,'2643','390',410357.46,411513.95,1156.49,300687.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194437',3797490,'2644','390',340311.61,340881.21,569.60,148096.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194437',3797491,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194437',3797492,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799066,'2605','389',61867.16,62356.47,489.31,80736.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799067,'2606','389',72317.45,72317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799068,'2607','389',118707.91,119329.53,621.62,102567.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799069,'2608','389',42778.53,42778.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799070,'2609','389',58450.69,58587.66,136.97,22600.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','194539',3799071,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799072,'2611','389',148706.74,149703.94,997.20,164538.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799073,'2612','389',225148.66,226105.57,956.91,157890.15,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799074,'2613','389',84538.74,84538.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799075,'2614','389',136801.22,137866.99,1065.77,175852.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799076,'2615','389',74646.61,74646.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194539',3799077,'2616','389',114905.91,115366.65,460.74,76022.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','194539',3799078,'2617','389',159175.70,159645.85,470.15,77574.75,0.00,0.00,0.00,0.00,0.00),('1','167','882','194539',3799079,'2618','389',90027.93,90027.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194539',3799080,'2619','389',148191.70,148644.52,452.82,74715.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','194539',3799081,'2620','389',114283.34,114705.20,421.86,69606.90,0.00,0.00,0.00,0.00,0.00),('1','167','883','194539',3799082,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194539',3799083,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194539',3799084,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194539',3799085,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194539',3799086,'2625','389',144921.93,145924.94,1003.01,165496.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','194539',3799087,'2626','389',104952.42,106031.16,1078.74,177992.10,0.00,0.00,0.00,0.00,0.00),('1','167','884','194539',3799088,'2627','389',74318.20,74927.91,609.71,100602.15,0.00,0.00,0.00,0.00,0.00),('1','167','884','194539',3799089,'2628','389',128750.84,129786.92,1036.08,170953.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','194539',3799090,'2629','389',81288.02,81305.59,17.57,2899.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','194539',3799091,'2630','389',35254.65,35707.18,452.53,74667.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','194539',3799092,'2631','389',91540.67,92160.97,620.30,102349.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194539',3799093,'2632','389',45901.30,46580.88,679.58,112130.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','194539',3799094,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194539',3799095,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194539',3799096,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194539',3799097,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194539',3799098,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194539',3799099,'2638','389',180946.20,181537.49,591.29,97562.85,0.00,0.00,0.00,0.00,0.00),('1','167','887','194539',3799100,'2639','389',150120.65,150120.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194539',3799101,'2640','389',138392.84,140012.70,1619.86,267276.90,0.00,0.00,0.00,0.00,0.00),('1','167','888','194539',3799102,'2641','390',380914.78,383284.16,2369.38,616038.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','194539',3799103,'2642','390',259760.94,259760.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194539',3799104,'2643','390',411513.95,412623.18,1109.23,288399.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194539',3799105,'2644','390',340881.21,342297.92,1416.71,368344.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','194539',3799106,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194539',3799107,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800840,'2605','389',62356.47,63267.19,910.72,150268.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800841,'2606','389',72317.45,72509.72,192.27,31724.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800842,'2607','389',119329.53,119329.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800843,'2608','389',42778.53,43309.47,530.94,87605.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800844,'2609','389',58587.66,59043.41,455.75,75198.75,0.00,0.00,0.00,0.00,0.00),('1','167','880','194630',3800845,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800846,'2611','389',149703.94,150455.39,751.45,123989.25,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800847,'2612','389',226105.57,227269.38,1163.81,192028.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800848,'2613','389',84538.74,85449.80,911.06,150324.90,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800849,'2614','389',137866.99,138337.48,470.49,77630.85,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800850,'2615','389',74646.61,75069.02,422.41,69697.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','194630',3800851,'2616','389',115366.65,116045.84,669.19,110416.35,0.00,0.00,10.00,0.00,0.00),('1','167','882','194630',3800852,'2617','389',159645.85,160181.39,535.54,88364.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','194630',3800853,'2618','389',90027.93,90344.96,312.58,51575.70,0.00,0.00,4.45,0.00,0.00),('1','167','882','194630',3800854,'2619','389',148644.52,149645.82,1001.30,165214.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','194630',3800855,'2620','389',114705.20,114705.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194630',3800856,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194630',3800857,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194630',3800858,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194630',3800859,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194630',3800860,'2625','389',145924.94,147165.12,1240.18,204629.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','194630',3800861,'2626','389',106031.16,106715.13,683.97,112855.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','194630',3800862,'2627','389',74927.91,75572.99,645.08,106438.20,0.00,0.00,0.00,0.00,0.00),('1','167','884','194630',3800863,'2628','389',129786.92,130559.00,772.08,127393.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','194630',3800864,'2629','389',81305.59,81385.62,80.03,13204.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','194630',3800865,'2630','389',35707.18,35737.48,30.30,4999.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','194630',3800866,'2631','389',92160.97,92278.66,117.69,19418.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','194630',3800867,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194630',3800868,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194630',3800869,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194630',3800870,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194630',3800871,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194630',3800872,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194630',3800873,'2638','389',181537.49,182700.81,1163.32,191947.80,0.00,0.00,0.00,0.00,0.00),('1','167','887','194630',3800874,'2639','389',150120.65,150517.40,396.75,65463.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','194630',3800875,'2640','389',140012.70,141290.03,1277.33,210759.45,0.00,0.00,0.00,0.00,0.00),('1','167','888','194630',3800876,'2641','390',383284.16,384476.20,1192.04,309930.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194630',3800877,'2642','390',259760.94,259760.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194630',3800878,'2643','390',412623.18,413398.56,775.38,201598.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194630',3800879,'2644','390',342297.92,343884.44,1586.52,412495.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','194630',3800880,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194630',3800881,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802187,'2605','389',63267.19,63747.14,479.95,79191.75,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802188,'2606','389',72509.72,72509.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802189,'2607','389',119329.53,119931.01,601.48,99244.20,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802190,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802191,'2609','389',59043.41,59341.21,297.80,49137.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194711',3802192,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802193,'2611','389',150455.39,151408.25,952.86,157221.90,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802194,'2612','389',227269.38,228320.55,1051.17,173443.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802195,'2613','389',85449.80,85449.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802196,'2614','389',138337.48,139502.45,1164.97,192220.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802197,'2615','389',75069.02,75069.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194711',3802198,'2616','389',116045.84,117009.23,963.39,158959.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','194711',3802199,'2617','389',160181.39,160986.26,804.87,132803.55,0.00,0.00,0.00,0.00,0.00),('1','167','882','194711',3802200,'2618','389',90344.96,90902.48,557.52,91990.80,0.00,0.00,0.00,0.00,0.00),('1','167','882','194711',3802201,'2619','389',149645.82,150114.97,463.60,76494.00,0.00,0.00,5.55,0.00,0.00),('1','167','882','194711',3802202,'2620','389',114705.20,115306.11,600.91,99150.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','194711',3802203,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194711',3802204,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194711',3802205,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194711',3802206,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194711',3802207,'2625','389',147165.12,148336.50,1161.38,191627.70,0.00,0.00,10.00,0.00,0.00),('1','167','884','194711',3802208,'2626','389',106715.13,107789.11,1063.98,175556.70,0.00,0.00,10.00,0.00,0.00),('1','167','884','194711',3802209,'2627','389',75572.99,75572.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194711',3802210,'2628','389',130559.00,131400.34,841.34,138821.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','194711',3802211,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194711',3802212,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194711',3802213,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194711',3802214,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194711',3802215,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194711',3802216,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194711',3802217,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194711',3802218,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194711',3802219,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194711',3802220,'2638','389',182700.81,184418.54,1717.73,283425.45,0.00,0.00,0.00,0.00,0.00),('1','167','887','194711',3802221,'2639','389',150517.40,150517.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194711',3802222,'2640','389',141290.03,142823.59,1533.56,253037.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194711',3802223,'2641','390',384476.20,385347.74,871.54,226600.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194711',3802224,'2642','390',259760.94,260239.84,478.90,124514.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194711',3802225,'2643','390',413398.56,415289.85,1891.29,491735.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194711',3802226,'2644','390',343884.44,345743.35,1858.91,483316.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','194711',3802227,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194711',3802228,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194725',3802463,'2605','389',63747.14,64260.53,513.39,84709.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','194725',3802464,'2606','389',72509.72,72950.99,441.27,72809.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','194725',3802465,'2607','389',119931.01,120568.48,637.47,105182.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','194725',3802466,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194725',3802467,'2609','389',59341.21,59901.96,550.75,90873.75,0.00,0.00,10.00,0.00,0.00),('1','167','880','194725',3802468,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194725',3802469,'2611','389',151408.25,151408.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194725',3802470,'2612','389',228320.55,229849.95,1519.40,250701.00,0.00,0.00,10.00,0.00,0.00),('1','167','881','194725',3802471,'2613','389',85449.80,85449.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194725',3802472,'2614','389',139502.45,140367.89,855.44,141147.60,0.00,0.00,10.00,0.00,0.00),('1','167','881','194725',3802473,'2615','389',75069.02,75837.52,768.50,126802.50,0.00,0.00,0.00,0.00,0.00),('1','167','881','194725',3802474,'2616','389',117009.23,117552.93,543.70,89710.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','194725',3802475,'2617','389',160986.26,160986.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194725',3802476,'2618','389',90902.48,91478.32,575.84,95013.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','194725',3802477,'2619','389',150114.97,150663.60,548.63,90523.95,0.00,0.00,0.00,0.00,0.00),('1','167','882','194725',3802478,'2620','389',115306.11,115669.71,363.60,59994.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194725',3802479,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194725',3802480,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194725',3802481,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194725',3802482,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194725',3802483,'2625','389',148336.50,149274.11,927.61,153055.65,0.00,0.00,10.00,0.00,0.00),('1','167','884','194725',3802484,'2626','389',107789.11,107814.56,21.30,3514.50,0.00,0.00,4.15,0.00,0.00),('1','167','884','194725',3802485,'2627','389',75572.99,76382.42,809.43,133555.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','194725',3802486,'2628','389',131400.34,131844.36,444.02,73263.30,0.00,0.00,0.00,0.00,0.00),('1','167','885','194725',3802487,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194725',3802488,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194725',3802489,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194725',3802490,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194725',3802491,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194725',3802492,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194725',3802493,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194725',3802494,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194725',3802495,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194725',3802496,'2638','389',184418.54,185707.76,1289.22,212721.30,0.00,0.00,0.00,0.00,0.00),('1','167','887','194725',3802497,'2639','389',150517.40,151547.23,1029.83,169921.95,0.00,0.00,0.00,0.00,0.00),('1','167','887','194725',3802498,'2640','389',142823.59,143708.46,884.87,146003.55,0.00,0.00,0.00,0.00,0.00),('1','167','888','194725',3802499,'2641','390',385347.74,386555.80,1208.06,314095.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','194725',3802500,'2642','390',260239.84,261336.35,1096.51,285092.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194725',3802501,'2643','390',415289.85,416438.36,1148.51,298612.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194725',3802502,'2644','390',345743.35,346689.57,946.22,246017.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','194725',3802503,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194725',3802504,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802791,'2605','389',64260.53,64260.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802792,'2606','389',72950.99,73213.73,262.74,43352.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802793,'2607','389',120568.48,120739.25,170.77,28177.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802794,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802795,'2609','389',59901.96,60048.90,146.94,24245.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','194739',3802796,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802797,'2611','389',151408.25,152862.17,1453.92,239896.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802798,'2612','389',229849.95,230442.30,592.35,97737.75,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802799,'2613','389',85449.80,86773.68,1323.88,218440.20,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802800,'2614','389',140367.89,140793.31,425.42,70194.30,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802801,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194739',3802802,'2616','389',117552.93,118607.34,1054.41,173977.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','194739',3802803,'2617','389',160986.26,161675.14,688.88,113665.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','194739',3802804,'2618','389',91478.32,91831.81,353.49,58325.85,0.00,0.00,0.00,0.00,0.00),('1','167','882','194739',3802805,'2619','389',150663.60,151490.64,827.04,136461.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','194739',3802806,'2620','389',115669.71,116019.71,350.00,57750.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194739',3802807,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194739',3802808,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194739',3802809,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194739',3802810,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194739',3802811,'2625','389',149274.11,149744.67,465.75,76848.75,0.00,0.00,4.81,0.00,0.00),('1','167','884','194739',3802812,'2626','389',107814.56,109026.95,1202.39,198394.35,0.00,0.00,10.00,0.00,0.00),('1','167','884','194739',3802813,'2627','389',76382.42,76784.18,401.76,66290.40,0.00,0.00,0.00,0.00,0.00),('1','167','884','194739',3802814,'2628','389',131844.36,133106.85,1262.49,208310.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','194739',3802815,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194739',3802816,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194739',3802817,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194739',3802818,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194739',3802819,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194739',3802820,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194739',3802821,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194739',3802822,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194739',3802823,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194739',3802824,'2638','389',185707.76,187115.56,1397.80,230637.00,0.00,0.00,10.00,0.00,0.00),('1','167','887','194739',3802825,'2639','389',151547.23,152658.69,1101.46,181740.90,0.00,0.00,10.00,0.00,0.00),('1','167','887','194739',3802826,'2640','389',143708.46,144421.54,713.08,117658.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194739',3802827,'2641','390',386555.80,388375.14,1819.34,473028.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194739',3802828,'2642','390',261336.35,262704.24,1367.89,355651.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194739',3802829,'2643','390',416438.36,417319.89,881.53,229197.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194739',3802830,'2644','390',346689.57,348367.88,1678.31,436360.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','194739',3802831,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194739',3802832,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803210,'2605','389',64260.53,64260.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803211,'2606','389',73213.73,73213.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803212,'2607','389',120739.25,120835.58,96.33,15894.45,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803213,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803214,'2609','389',60048.90,60048.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194757',3803215,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194757',3803216,'2611','389',152862.17,152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194757',3803217,'2612','389',230442.30,232516.88,2072.73,342000.45,0.00,0.00,1.85,0.00,0.00),('1','167','881','194757',3803218,'2613','389',86773.68,88351.00,1567.32,258607.80,0.00,0.00,10.00,0.00,0.00),('1','167','881','194757',3803219,'2614','389',140793.31,140793.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194757',3803220,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194757',3803221,'2616','389',118607.34,119814.48,1197.14,197528.10,0.00,0.00,10.00,0.00,0.00),('1','167','882','194757',3803222,'2617','389',161675.14,161675.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194757',3803223,'2618','389',91831.81,91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194757',3803224,'2619','389',151490.64,151490.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194757',3803225,'2620','389',116019.71,116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194757',3803226,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194757',3803227,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194757',3803228,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194757',3803229,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194757',3803230,'2625','389',149744.67,149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194757',3803231,'2626','389',109026.95,110372.00,1335.05,220283.25,0.00,0.00,10.00,0.00,0.00),('1','167','884','194757',3803232,'2627','389',76784.18,76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194757',3803233,'2628','389',133106.85,134221.00,1104.15,182184.75,0.00,0.00,10.00,0.00,0.00),('1','167','885','194757',3803234,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194757',3803235,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194757',3803236,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194757',3803237,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194757',3803238,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194757',3803239,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194757',3803240,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194757',3803241,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194757',3803242,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194757',3803243,'2638','389',187115.56,189576.74,2451.18,404444.70,0.00,0.00,10.00,0.00,0.00),('1','167','887','194757',3803244,'2639','389',152658.69,153727.08,1058.39,174634.35,0.00,0.00,10.00,0.00,0.00),('1','167','887','194757',3803245,'2640','389',144421.54,145799.01,1367.47,225632.55,0.00,0.00,10.00,0.00,0.00),('1','167','888','194757',3803246,'2641','390',388375.14,389600.97,1225.83,318715.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','194757',3803247,'2642','390',262704.24,263619.21,914.97,237892.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194757',3803248,'2643','390',417319.89,418435.79,1115.90,290134.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194757',3803249,'2644','390',348367.88,349215.01,847.13,220253.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','194757',3803250,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194757',3803251,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194770',3803531,'2605','389',64260.53,67735.53,3465.00,571725.00,0.00,0.00,10.00,0.00,0.00),('1','167','880','194770',3803532,'2606','389',73213.73,73213.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194770',3803533,'2607','389',120835.58,120835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194770',3803534,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194770',3803535,'2609','389',60048.90,63205.92,3139.14,517958.10,0.00,0.00,17.88,0.00,0.00),('1','167','880','194770',3803536,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803537,'2611','389',152862.17,152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803538,'2612','389',232516.88,232516.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803539,'2613','389',88351.00,88351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803540,'2614','389',140793.31,140793.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803541,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194770',3803542,'2616','389',119814.48,119814.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194770',3803543,'2617','389',161675.14,161675.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194770',3803544,'2618','389',91831.81,91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194770',3803545,'2619','389',151490.64,151490.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194770',3803546,'2620','389',116019.71,116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194770',3803547,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194770',3803548,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194770',3803549,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194770',3803550,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194770',3803551,'2625','389',149744.67,149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194770',3803552,'2626','389',110372.00,110372.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194770',3803553,'2627','389',76784.18,76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194770',3803554,'2628','389',134221.00,134221.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194770',3803555,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194770',3803556,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194770',3803557,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194770',3803558,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194770',3803559,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194770',3803560,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194770',3803561,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194770',3803562,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194770',3803563,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194770',3803564,'2638','389',189576.74,192195.27,2608.53,430407.45,0.00,0.00,10.00,0.00,0.00),('1','167','887','194770',3803565,'2639','389',153727.08,156352.66,2615.58,431570.70,0.00,0.00,10.00,0.00,0.00),('1','167','887','194770',3803566,'2640','389',145799.01,145799.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194770',3803567,'2641','390',389600.97,390160.65,559.68,145516.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','194770',3803568,'2642','390',263619.21,264784.48,1165.27,302970.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','194770',3803569,'2643','390',418435.79,419762.38,1326.59,344913.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194770',3803570,'2644','390',349215.01,350153.04,938.03,243887.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','194770',3803571,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194770',3803572,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803630,'2605','389',67735.53,72623.79,4888.26,806562.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803631,'2606','389',73213.73,73213.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803632,'2607','389',120835.58,120835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803633,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803634,'2609','389',63205.92,68010.58,4804.66,792768.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','194775',3803635,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803636,'2611','389',152862.17,152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803637,'2612','389',232516.88,232516.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803638,'2613','389',88351.00,88351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803639,'2614','389',140793.31,140793.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803640,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194775',3803641,'2616','389',119814.48,119814.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194775',3803642,'2617','389',161675.14,161675.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194775',3803643,'2618','389',91831.81,91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194775',3803644,'2619','389',151490.64,151490.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194775',3803645,'2620','389',116019.71,116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194775',3803646,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194775',3803647,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194775',3803648,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194775',3803649,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194775',3803650,'2625','389',149744.67,149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194775',3803651,'2626','389',110372.00,110372.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194775',3803652,'2627','389',76784.18,76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194775',3803653,'2628','389',134221.00,134221.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194775',3803654,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194775',3803655,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194775',3803656,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194775',3803657,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194775',3803658,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194775',3803659,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194775',3803660,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194775',3803661,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194775',3803662,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194775',3803663,'2638','389',192195.27,192465.55,270.28,44596.20,0.00,0.00,0.00,0.00,0.00),('1','167','887','194775',3803664,'2639','389',156352.66,156645.43,292.77,48307.05,0.00,0.00,0.00,0.00,0.00),('1','167','887','194775',3803665,'2640','389',145799.01,145920.76,121.75,20088.75,0.00,0.00,0.00,0.00,0.00),('1','167','888','194775',3803666,'2641','390',390160.65,391789.87,1629.22,423597.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194775',3803667,'2642','390',264784.48,266579.12,1794.64,466606.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194775',3803668,'2643','390',419762.38,420517.91,755.53,196437.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194775',3803669,'2644','390',350153.04,352215.40,2062.36,536213.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','194775',3803670,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194775',3803671,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803689,'2605','389',72623.79,78014.80,5391.01,889516.65,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803690,'2606','389',73213.73,73213.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803691,'2607','389',120835.58,120835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803692,'2608','389',43309.47,43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803693,'2609','389',68010.58,73147.43,5136.85,847580.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','194777',3803694,'2610','389',114762.83,114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803695,'2611','389',152862.17,152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803696,'2612','389',232516.88,232516.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803697,'2613','389',88351.00,88351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803698,'2614','389',140793.31,140793.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803699,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194777',3803700,'2616','389',119814.48,119814.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194777',3803701,'2617','389',161675.14,161675.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194777',3803702,'2618','389',91831.81,91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194777',3803703,'2619','389',151490.64,151490.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194777',3803704,'2620','389',116019.71,116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194777',3803705,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194777',3803706,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194777',3803707,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194777',3803708,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194777',3803709,'2625','389',149744.67,149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194777',3803710,'2626','389',110372.00,110372.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194777',3803711,'2627','389',76784.18,76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194777',3803712,'2628','389',134221.00,134221.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194777',3803713,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194777',3803714,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194777',3803715,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194777',3803716,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194777',3803717,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194777',3803718,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194777',3803719,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194777',3803720,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194777',3803721,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194777',3803722,'2638','389',192465.55,192465.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194777',3803723,'2639','389',156645.43,156645.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194777',3803724,'2640','389',145920.76,145920.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194777',3803725,'2641','390',391789.87,392371.41,581.54,151200.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','194777',3803726,'2642','390',266579.12,267299.13,720.01,187202.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194777',3803727,'2643','390',420517.91,421702.97,1185.06,308115.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194777',3803728,'2644','390',352215.40,353810.55,1595.15,414739.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194777',3803729,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194777',3803730,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803781,'2605','389',78014.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803782,'2606','389',73213.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803783,'2607','389',120835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803784,'2608','389',43309.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803785,'2609','389',73147.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194782',3803786,'2610','389',114762.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803787,'2611','389',152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803788,'2612','389',232516.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803789,'2613','389',88351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803790,'2614','389',140793.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803791,'2615','389',75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194782',3803792,'2616','389',119814.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194782',3803793,'2617','389',161675.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194782',3803794,'2618','389',91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194782',3803795,'2619','389',151490.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194782',3803796,'2620','389',116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194782',3803797,'2621','389',21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194782',3803798,'2622','389',120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194782',3803799,'2623','389',128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194782',3803800,'2624','389',52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194782',3803801,'2625','389',149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194782',3803802,'2626','389',110372.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194782',3803803,'2627','389',76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194782',3803804,'2628','389',134221.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194782',3803805,'2629','389',81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194782',3803806,'2630','389',35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194782',3803807,'2631','389',92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194782',3803808,'2632','389',46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194782',3803809,'2633','389',71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194782',3803810,'2634','389',63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194782',3803811,'2635','389',72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194782',3803812,'2636','389',35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194782',3803813,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194782',3803814,'2638','389',192465.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194782',3803815,'2639','389',156645.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194782',3803816,'2640','389',145920.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194782',3803817,'2641','390',392371.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194782',3803818,'2642','390',267299.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194782',3803819,'2643','390',421702.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194782',3803820,'2644','390',353810.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194782',3803821,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194782',3803822,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194836',3804973,'2605','389',78014.80,80637.32,2622.52,432715.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','194836',3804974,'2606','389',73213.73,74325.38,1111.65,183422.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','194836',3804975,'2607','389',120835.58,121671.57,835.99,137938.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','194836',3804976,'2608','389',43309.47,44082.38,762.91,125880.15,0.00,0.00,10.00,0.00,0.00),('1','167','880','194836',3804977,'2609','389',73147.43,74338.74,1191.31,196566.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','194836',3804978,'2610','389',114762.83,115971.19,1208.36,199379.40,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804979,'2611','389',152862.17,152862.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804980,'2612','389',232516.88,233225.45,708.57,116914.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804981,'2613','389',88351.00,88351.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804982,'2614','389',140793.31,141407.39,614.08,101323.20,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804983,'2615','389',75837.52,75837.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194836',3804984,'2616','389',119814.48,120505.92,691.44,114087.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','194836',3804985,'2617','389',161675.14,162359.95,684.81,112993.65,0.00,0.00,0.00,0.00,0.00),('1','167','882','194836',3804986,'2618','389',91831.81,91831.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194836',3804987,'2619','389',151490.64,152104.32,613.68,101257.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','194836',3804988,'2620','389',116019.71,116019.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194836',3804989,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194836',3804990,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194836',3804991,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194836',3804992,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194836',3804993,'2625','389',149744.67,149744.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194836',3804994,'2626','389',110372.00,110372.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194836',3804995,'2627','389',76784.18,76784.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194836',3804996,'2628','389',134221.00,134221.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194836',3804997,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194836',3804998,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194836',3804999,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194836',3805000,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194836',3805001,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194836',3805002,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194836',3805003,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194836',3805004,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194836',3805005,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194836',3805006,'2638','389',192465.55,192465.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194836',3805007,'2639','389',156645.43,156645.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194836',3805008,'2640','389',145920.76,145920.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194836',3805009,'2641','390',392371.41,393273.36,901.95,234507.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194836',3805010,'2642','390',267299.13,268027.41,728.28,189352.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194836',3805011,'2643','390',421702.97,424052.61,2349.64,610906.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194836',3805012,'2644','390',353810.55,355209.64,1399.09,363763.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','194836',3805013,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194836',3805014,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805113,'2605','389',80637.32,80637.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805114,'2606','389',74325.38,74325.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805115,'2607','389',121671.57,121671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805116,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805117,'2609','389',74338.74,74338.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194842',3805118,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805119,'2611','389',152862.17,153649.12,786.95,129846.75,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805120,'2612','389',233225.45,234441.82,1216.37,200701.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805121,'2613','389',88351.00,89094.52,743.52,122680.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805122,'2614','389',141407.39,142056.04,648.65,107027.25,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805123,'2615','389',75837.52,76354.64,517.12,85324.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','194842',3805124,'2616','389',120505.92,121304.69,798.77,131797.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','194842',3805125,'2617','389',162359.95,163151.73,791.78,130643.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','194842',3805126,'2618','389',91831.81,92374.21,542.40,89496.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194842',3805127,'2619','389',152104.32,152691.89,587.57,96949.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','194842',3805128,'2620','389',116019.71,116466.71,447.00,73755.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194842',3805129,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194842',3805130,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194842',3805131,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194842',3805132,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194842',3805133,'2625','389',149744.67,150325.50,580.83,95836.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','194842',3805134,'2626','389',110372.00,111085.38,713.38,117707.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','194842',3805135,'2627','389',76784.18,77434.32,650.14,107273.10,0.00,0.00,0.00,0.00,0.00),('1','167','884','194842',3805136,'2628','389',134221.00,134970.03,749.03,123589.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','194842',3805137,'2629','389',81385.62,81385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194842',3805138,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194842',3805139,'2631','389',92278.66,92278.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194842',3805140,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194842',3805141,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194842',3805142,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194842',3805143,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194842',3805144,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194842',3805145,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194842',3805146,'2638','389',192465.55,193605.85,1140.30,188149.50,0.00,0.00,0.00,0.00,0.00),('1','167','887','194842',3805147,'2639','389',156645.43,157397.03,751.60,124014.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194842',3805148,'2640','389',145920.76,146738.74,817.98,134966.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','194842',3805149,'2641','390',393273.36,394908.14,1634.78,425042.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','194842',3805150,'2642','390',268027.41,268848.92,821.51,213592.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194842',3805151,'2643','390',424052.61,424793.97,741.36,192753.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194842',3805152,'2644','390',355209.64,356545.28,1335.64,347266.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','194842',3805153,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194842',3805154,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805305,'2605','389',80637.32,80643.38,6.06,999.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805306,'2606','389',74325.38,74713.52,388.14,64043.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805307,'2607','389',121671.57,122227.57,556.00,91740.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805308,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805309,'2609','389',74338.74,74338.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194849',3805310,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805311,'2611','389',153649.12,154793.04,1143.92,188746.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805312,'2612','389',234441.82,235584.94,1143.12,188614.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805313,'2613','389',89094.52,89735.61,641.09,105779.85,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805314,'2614','389',142056.04,142573.54,517.50,85387.50,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805315,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194849',3805316,'2616','389',121304.69,121740.88,436.19,71971.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','194849',3805317,'2617','389',163151.73,163580.57,428.84,70758.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','194849',3805318,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194849',3805319,'2619','389',152691.89,153061.13,369.24,60924.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','194849',3805320,'2620','389',116466.71,116466.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194849',3805321,'2621','389',21961.63,21961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194849',3805322,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194849',3805323,'2623','389',128094.25,128094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194849',3805324,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194849',3805325,'2625','389',150325.50,151400.73,1075.23,177412.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','194849',3805326,'2626','389',111085.38,111602.13,516.75,85263.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','194849',3805327,'2627','389',77434.32,77768.23,333.91,55095.15,0.00,0.00,0.00,0.00,0.00),('1','167','884','194849',3805328,'2628','389',134970.03,135466.26,496.23,81877.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','194849',3805329,'2629','389',81385.62,81865.77,480.15,79224.75,0.00,0.00,0.00,0.00,0.00),('1','167','885','194849',3805330,'2630','389',35737.48,35737.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194849',3805331,'2631','389',92278.66,93370.31,1091.65,180122.25,0.00,0.00,0.00,0.00,0.00),('1','167','885','194849',3805332,'2632','389',46580.88,46580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194849',3805333,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194849',3805334,'2634','389',63156.39,63156.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194849',3805335,'2635','389',72222.25,72222.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194849',3805336,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194849',3805337,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194849',3805338,'2638','389',193605.85,195429.63,1823.78,300923.70,0.00,0.00,0.00,0.00,0.00),('1','167','887','194849',3805339,'2639','389',157397.03,158191.69,794.66,131118.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','194849',3805340,'2640','389',146738.74,147286.62,547.88,90400.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194849',3805341,'2641','390',394908.14,396107.14,1199.00,311740.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','194849',3805342,'2642','390',268848.92,269983.61,1134.69,295019.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','194849',3805343,'2643','390',424793.97,425883.38,1089.41,283246.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','194849',3805344,'2644','390',356545.28,358047.98,1502.70,390702.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194849',3805345,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194849',3805346,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194884',3805916,'2605','389',80643.38,81258.17,604.79,99790.35,0.00,0.00,10.00,0.00,0.00),('1','167','880','194884',3805917,'2606','389',74713.52,74713.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194884',3805918,'2607','389',122227.57,122457.94,230.37,38011.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','194884',3805919,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','194884',3805920,'2609','389',74338.74,74686.84,338.10,55786.50,0.00,0.00,10.00,0.00,0.00),('1','167','880','194884',3805921,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805922,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805923,'2612','389',235584.94,237019.64,1434.70,236725.50,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805924,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805925,'2614','389',142573.54,143670.63,1097.09,181019.85,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805926,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','194884',3805927,'2616','389',121740.88,122396.59,645.71,106542.15,0.00,0.00,10.00,0.00,0.00),('1','167','882','194884',3805928,'2617','389',163580.57,163959.96,379.39,62599.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','194884',3805929,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','194884',3805930,'2619','389',153061.13,153480.19,419.06,69144.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','194884',3805931,'2620','389',116466.71,116515.13,48.42,7989.30,0.00,0.00,0.00,0.00,0.00),('1','167','883','194884',3805932,'2621','389',21961.63,22522.81,561.18,92594.70,0.00,0.00,0.00,0.00,0.00),('1','167','883','194884',3805933,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','194884',3805934,'2623','389',128094.25,128442.54,348.29,57467.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','194884',3805935,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194884',3805936,'2625','389',151400.73,152750.89,1350.16,222776.40,0.00,0.00,0.00,0.00,0.00),('1','167','884','194884',3805937,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194884',3805938,'2627','389',77768.23,77768.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','194884',3805939,'2628','389',135466.26,136450.43,984.17,162388.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','194884',3805940,'2629','389',81865.77,81865.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194884',3805941,'2630','389',35737.48,36110.89,353.41,58312.65,0.00,0.00,20.00,0.00,0.00),('1','167','885','194884',3805942,'2631','389',93370.31,93370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','194884',3805943,'2632','389',46580.88,47217.58,636.70,105055.50,0.00,0.00,0.00,0.00,0.00),('1','167','886','194884',3805944,'2633','389',71980.96,71980.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','194884',3805945,'2634','389',63156.39,64004.11,847.72,139873.80,0.00,0.00,0.00,0.00,0.00),('1','167','886','194884',3805946,'2635','389',72222.25,72624.87,401.02,66168.30,0.00,0.00,1.60,0.00,0.00),('1','167','886','194884',3805947,'2636','389',35503.78,35503.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194884',3805948,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194884',3805949,'2638','389',195429.63,196684.78,1255.15,207099.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','194884',3805950,'2639','389',158191.69,158191.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','194884',3805951,'2640','389',147286.62,148038.53,741.91,122415.15,0.00,0.00,10.00,0.00,0.00),('1','167','888','194884',3805952,'2641','390',396107.14,398176.76,2069.62,538101.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','194884',3805953,'2642','390',269983.61,270566.19,582.58,151470.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','194884',3805954,'2643','390',425883.38,426863.73,980.35,254891.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','194884',3805955,'2644','390',358047.98,360102.22,2054.24,534102.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','194884',3805956,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','194884',3805957,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808291,'2605','389',81258.17,81258.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808292,'2606','389',74713.52,75231.75,518.23,85507.95,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808293,'2607','389',122457.94,122769.63,311.69,51428.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808294,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808295,'2609','389',74686.84,75006.36,319.52,52720.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','195021',3808296,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808297,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808298,'2612','389',237019.64,238032.65,1013.01,167146.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808299,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808300,'2614','389',143670.63,144390.98,720.35,118857.75,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808301,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195021',3808302,'2616','389',122396.59,122858.39,461.80,76197.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195021',3808303,'2617','389',163959.96,164286.81,326.85,53930.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','195021',3808304,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195021',3808305,'2619','389',153480.19,153940.46,460.27,75944.55,0.00,0.00,0.00,0.00,0.00),('1','167','882','195021',3808306,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195021',3808307,'2621','389',22522.81,22901.30,378.49,62450.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','195021',3808308,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195021',3808309,'2623','389',128442.54,128813.91,371.37,61276.05,0.00,0.00,0.00,0.00,0.00),('1','167','883','195021',3808310,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195021',3808311,'2625','389',152750.89,153511.70,760.81,125533.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','195021',3808312,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195021',3808313,'2627','389',77768.23,77768.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195021',3808314,'2628','389',136450.43,137193.62,743.19,122626.35,0.00,0.00,0.00,0.00,0.00),('1','167','885','195021',3808315,'2629','389',81865.77,82312.34,446.57,73684.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','195021',3808316,'2630','389',36110.89,36110.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195021',3808317,'2631','389',93370.31,93370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195021',3808318,'2632','389',47217.58,47217.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195021',3808319,'2633','389',71980.96,72504.68,523.72,86413.80,0.00,0.00,0.00,0.00,0.00),('1','167','886','195021',3808320,'2634','389',64004.11,64348.23,344.12,56779.80,0.00,0.00,0.00,0.00,0.00),('1','167','886','195021',3808321,'2635','389',72624.87,73066.18,441.31,72816.15,0.00,0.00,0.00,0.00,0.00),('1','167','886','195021',3808322,'2636','389',35503.78,35509.08,5.30,874.50,0.00,0.00,0.00,0.00,0.00),('1','167','887','195021',3808323,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195021',3808324,'2638','389',196684.78,197912.49,1227.71,202572.15,0.00,0.00,0.00,0.00,0.00),('1','167','887','195021',3808325,'2639','389',158191.69,159325.29,1133.60,187044.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195021',3808326,'2640','389',148038.53,148038.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195021',3808327,'2641','390',398176.76,399954.86,1778.10,462306.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195021',3808328,'2642','390',270566.19,270566.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195021',3808329,'2643','390',426863.73,428066.12,1202.39,312621.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195021',3808330,'2644','390',360102.22,362003.13,1900.91,494236.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','195021',3808331,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195021',3808332,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808594,'2605','389',81258.17,81868.08,609.91,100635.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808595,'2606','389',75231.75,75231.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808596,'2607','389',122769.63,122807.51,37.88,6250.20,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808597,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808598,'2609','389',75006.36,75742.83,736.47,121517.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','195036',3808599,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808600,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808601,'2612','389',238032.65,239314.66,1282.01,211531.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808602,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808603,'2614','389',144390.98,145512.79,1121.81,185098.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808604,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195036',3808605,'2616','389',122858.39,123514.50,656.11,108258.15,0.00,0.00,0.00,0.00,0.00),('1','167','882','195036',3808606,'2617','389',164286.81,164604.66,317.85,52445.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','195036',3808607,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195036',3808608,'2619','389',153940.46,154273.21,332.75,54903.75,0.00,0.00,0.00,0.00,0.00),('1','167','882','195036',3808609,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195036',3808610,'2621','389',22901.30,23404.33,503.03,82999.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','195036',3808611,'2622','389',120355.71,120355.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195036',3808612,'2623','389',128813.91,129297.02,483.11,79713.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','195036',3808613,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195036',3808614,'2625','389',153511.70,154618.73,1107.03,182659.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','195036',3808615,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195036',3808616,'2627','389',77768.23,77768.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195036',3808617,'2628','389',137193.62,137964.23,770.61,127150.65,0.00,0.00,0.00,0.00,0.00),('1','167','885','195036',3808618,'2629','389',82312.34,82732.22,419.88,69280.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','195036',3808619,'2630','389',36110.89,36538.70,427.81,70588.65,0.00,0.00,0.00,0.00,0.00),('1','167','885','195036',3808620,'2631','389',93370.31,93972.38,602.07,99341.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','195036',3808621,'2632','389',47217.58,47217.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195036',3808622,'2633','389',72504.68,73231.87,727.19,119986.35,0.00,0.00,0.00,0.00,0.00),('1','167','886','195036',3808623,'2634','389',64348.23,64348.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195036',3808624,'2635','389',73066.18,73066.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195036',3808625,'2636','389',35509.08,35990.22,481.14,79388.10,0.00,0.00,0.00,0.00,0.00),('1','167','887','195036',3808626,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195036',3808627,'2638','389',197912.49,199129.23,1216.74,200762.10,0.00,0.00,0.00,0.00,0.00),('1','167','887','195036',3808628,'2639','389',159325.29,159325.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195036',3808629,'2640','389',148038.53,148877.91,839.38,138497.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','195036',3808630,'2641','390',399954.86,401480.83,1525.97,396752.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','195036',3808631,'2642','390',270566.19,272115.89,1549.70,402922.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195036',3808632,'2643','390',428066.12,429857.97,1791.85,465881.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195036',3808633,'2644','390',362003.13,362003.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195036',3808634,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195036',3808635,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808768,'2605','389',81868.08,82533.87,665.79,109855.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808769,'2606','389',75231.75,75596.63,364.88,60205.20,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808770,'2607','389',122807.51,123527.62,720.11,118818.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808771,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808772,'2609','389',75742.83,76232.83,490.00,80850.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195045',3808773,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808774,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808775,'2612','389',239314.66,239877.92,563.26,92937.90,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808776,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808777,'2614','389',145512.79,145868.55,355.76,58700.40,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808778,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195045',3808779,'2616','389',123514.50,123922.93,408.43,67390.95,0.00,0.00,0.00,0.00,0.00),('1','167','882','195045',3808780,'2617','389',164604.66,165134.18,529.52,87370.80,0.00,0.00,0.00,0.00,0.00),('1','167','882','195045',3808781,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195045',3808782,'2619','389',154273.21,154627.75,354.54,58499.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','195045',3808783,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195045',3808784,'2621','389',23404.33,23599.00,194.67,32120.55,0.00,0.00,0.00,0.00,0.00),('1','167','883','195045',3808785,'2622','389',120355.71,120795.99,440.28,72646.20,0.00,0.00,0.00,0.00,0.00),('1','167','883','195045',3808786,'2623','389',129297.02,129978.89,671.87,110858.55,0.00,0.00,10.00,0.00,0.00),('1','167','883','195045',3808787,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195045',3808788,'2625','389',154618.73,156519.11,1900.38,313562.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','195045',3808789,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195045',3808790,'2627','389',77768.23,78290.16,521.93,86118.45,0.00,0.00,0.00,0.00,0.00),('1','167','884','195045',3808791,'2628','389',137964.23,138888.00,923.77,152422.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','195045',3808792,'2629','389',82732.22,83571.25,839.03,138439.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','195045',3808793,'2630','389',36538.70,36538.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195045',3808794,'2631','389',93972.38,93972.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195045',3808795,'2632','389',47217.58,47672.83,455.25,75116.25,0.00,0.00,0.00,0.00,0.00),('1','167','886','195045',3808796,'2633','389',73231.87,73231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195045',3808797,'2634','389',64348.23,64841.71,493.48,81424.20,0.00,0.00,0.00,0.00,0.00),('1','167','886','195045',3808798,'2635','389',73066.18,73066.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195045',3808799,'2636','389',35990.22,36560.98,570.76,94175.40,0.00,0.00,0.00,0.00,0.00),('1','167','887','195045',3808800,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195045',3808801,'2638','389',199129.23,199837.21,707.98,116816.70,0.00,0.00,0.00,0.00,0.00),('1','167','887','195045',3808802,'2639','389',159325.29,159325.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195045',3808803,'2640','389',148877.91,149766.65,888.74,146642.10,0.00,0.00,0.00,0.00,0.00),('1','167','888','195045',3808804,'2641','390',401480.83,403168.43,1687.60,438776.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195045',3808805,'2642','390',272115.89,273252.93,1137.04,295630.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195045',3808806,'2643','390',429857.97,431505.33,1647.36,428313.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','195045',3808807,'2644','390',362003.13,363281.49,1278.36,332373.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','195045',3808808,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195045',3808809,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809394,'2605','389',82533.87,82592.05,58.18,9599.70,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809395,'2606','389',75596.63,76593.66,997.03,164509.95,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809396,'2607','389',123527.62,124120.74,593.12,97864.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809397,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809398,'2609','389',76232.83,76699.88,467.05,77063.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','195082',3809399,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809400,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809401,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809402,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809403,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809404,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195082',3809405,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195082',3809406,'2617','389',165134.18,165692.86,558.68,92182.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','195082',3809407,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195082',3809408,'2619','389',154627.75,155034.32,406.57,67084.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','195082',3809409,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195082',3809410,'2621','389',23599.00,24537.68,938.68,154882.20,0.00,0.00,0.00,0.00,0.00),('1','167','883','195082',3809411,'2622','389',120795.99,120795.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195082',3809412,'2623','389',129978.89,130715.84,736.95,121596.75,0.00,0.00,0.00,0.00,0.00),('1','167','883','195082',3809413,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195082',3809414,'2625','389',156519.11,157816.09,1296.98,214001.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','195082',3809415,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195082',3809416,'2627','389',78290.16,78757.93,467.77,77182.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','195082',3809417,'2628','389',138888.00,139622.26,734.26,121152.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','195082',3809418,'2629','389',83571.25,83571.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195082',3809419,'2630','389',36538.70,37182.87,644.17,106288.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','195082',3809420,'2631','389',93972.38,94601.32,628.94,103775.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','195082',3809421,'2632','389',47672.83,48285.69,612.86,101121.90,0.00,0.00,0.00,0.00,0.00),('1','167','886','195082',3809422,'2633','389',73231.87,73231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195082',3809423,'2634','389',64841.71,65423.58,581.87,96008.55,0.00,0.00,0.00,0.00,0.00),('1','167','886','195082',3809424,'2635','389',73066.18,73066.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195082',3809425,'2636','389',36560.98,37363.56,802.58,132425.70,0.00,0.00,0.00,0.00,0.00),('1','167','887','195082',3809426,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195082',3809427,'2638','389',199837.21,201337.16,1499.95,247491.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','195082',3809428,'2639','389',159325.29,160228.79,903.50,149077.50,0.00,0.00,0.00,0.00,0.00),('1','167','887','195082',3809429,'2640','389',149766.65,150326.89,560.24,92439.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','195082',3809430,'2641','390',403168.43,404794.62,1626.19,422809.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','195082',3809431,'2642','390',273252.93,274452.01,1199.08,311760.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195082',3809432,'2643','390',431505.33,433795.22,2289.89,595371.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195082',3809433,'2644','390',363281.49,364056.04,774.55,201383.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195082',3809434,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195082',3809435,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810662,'2605','389',82592.05,83523.77,931.72,153733.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810663,'2606','389',76593.66,77610.66,1017.00,167805.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810664,'2607','389',124120.74,124424.76,304.02,50163.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810665,'2608','389',44082.38,44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810666,'2609','389',76699.88,77439.17,739.29,121982.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','195154',3810667,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810668,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810669,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810670,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810671,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810672,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195154',3810673,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195154',3810674,'2617','389',165692.86,166321.20,628.34,103676.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','195154',3810675,'2618','389',92374.21,92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195154',3810676,'2619','389',155034.32,155613.69,579.37,95596.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','195154',3810677,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195154',3810678,'2621','389',24537.68,25321.20,783.52,129280.80,0.00,0.00,0.00,0.00,0.00),('1','167','883','195154',3810679,'2622','389',120795.99,120795.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195154',3810680,'2623','389',130715.84,131256.87,541.03,89269.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','195154',3810681,'2624','389',52769.83,52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195154',3810682,'2625','389',157816.09,158648.28,832.19,137311.35,0.00,0.00,0.00,0.00,0.00),('1','167','884','195154',3810683,'2626','389',111602.13,111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195154',3810684,'2627','389',78757.93,80047.35,1289.42,212754.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','195154',3810685,'2628','389',139622.26,140442.99,820.73,135420.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','195154',3810686,'2629','389',83571.25,83571.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195154',3810687,'2630','389',37182.87,37803.14,609.67,100595.55,0.00,0.00,10.60,0.00,0.00),('1','167','885','195154',3810688,'2631','389',94601.32,95274.10,662.78,109358.70,0.00,0.00,10.00,0.00,0.00),('1','167','885','195154',3810689,'2632','389',48285.69,48285.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195154',3810690,'2633','389',73231.87,73231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195154',3810691,'2634','389',65423.58,66196.76,763.18,125924.70,0.00,0.00,10.00,0.00,0.00),('1','167','886','195154',3810692,'2635','389',73066.18,73066.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195154',3810693,'2636','389',37363.56,37985.59,612.03,100984.95,0.00,0.00,10.00,0.00,0.00),('1','167','887','195154',3810694,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195154',3810695,'2638','389',201337.16,202279.10,931.94,153770.10,0.00,0.00,10.00,0.00,0.00),('1','167','887','195154',3810696,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195154',3810697,'2640','389',150326.89,150826.50,489.61,80785.65,0.00,0.00,10.00,0.00,0.00),('1','167','888','195154',3810698,'2641','390',404794.62,407179.96,2385.34,620188.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','195154',3810699,'2642','390',274452.01,276232.59,1780.58,462950.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195154',3810700,'2643','390',433795.22,436394.90,2599.68,675916.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195154',3810701,'2644','390',364056.04,364765.90,709.86,184563.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','195154',3810702,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195154',3810703,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812457,'2605','389',83523.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812458,'2606','389',77610.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812459,'2607','389',124424.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812460,'2608','389',44082.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812461,'2609','389',77439.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195255',3812462,'2610','389',115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812463,'2611','389',154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812464,'2612','389',239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812465,'2613','389',89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812466,'2614','389',145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812467,'2615','389',76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195255',3812468,'2616','389',123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195255',3812469,'2617','389',166321.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195255',3812470,'2618','389',92374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195255',3812471,'2619','389',155613.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195255',3812472,'2620','389',116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195255',3812473,'2621','389',25321.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195255',3812474,'2622','389',120795.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195255',3812475,'2623','389',131256.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195255',3812476,'2624','389',52769.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195255',3812477,'2625','389',158648.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195255',3812478,'2626','389',111602.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195255',3812479,'2627','389',80047.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195255',3812480,'2628','389',140442.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195255',3812481,'2629','389',83571.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195255',3812482,'2630','389',37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195255',3812483,'2631','389',95274.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195255',3812484,'2632','389',48285.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195255',3812485,'2633','389',73231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195255',3812486,'2634','389',66196.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195255',3812487,'2635','389',73066.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195255',3812488,'2636','389',37985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195255',3812489,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195255',3812490,'2638','389',202279.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195255',3812491,'2639','389',160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195255',3812492,'2640','389',150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195255',3812493,'2641','390',407179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195255',3812494,'2642','390',276232.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195255',3812495,'2643','390',436394.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195255',3812496,'2644','390',364765.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195255',3812497,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195255',3812498,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812605,'2605','389',83523.77,83523.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812606,'2606','389',77610.66,78524.98,914.32,150862.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812607,'2607','389',124424.76,124424.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812608,'2608','389',44082.38,44829.89,747.51,123339.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812609,'2609','389',77439.17,77744.43,305.26,50367.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','195263',3812610,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812611,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812612,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812613,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812614,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812615,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195263',3812616,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195263',3812617,'2617','389',166321.20,166599.65,278.45,45944.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','195263',3812618,'2618','389',92374.21,92793.50,419.29,69182.85,0.00,0.00,0.00,0.00,0.00),('1','167','882','195263',3812619,'2619','389',155613.69,155987.51,373.82,61680.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','195263',3812620,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195263',3812621,'2621','389',25321.20,25745.19,423.99,69958.35,0.00,0.00,0.00,0.00,0.00),('1','167','883','195263',3812622,'2622','389',120795.99,121322.30,526.31,86841.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','195263',3812623,'2623','389',131256.87,131684.37,427.50,70537.50,0.00,0.00,0.00,0.00,0.00),('1','167','883','195263',3812624,'2624','389',52769.83,53411.23,641.40,105831.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195263',3812625,'2625','389',158648.28,159614.63,966.35,159447.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','195263',3812626,'2626','389',111602.13,112844.10,1241.97,204925.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','195263',3812627,'2627','389',80047.35,80747.56,700.21,115534.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','195263',3812628,'2628','389',140442.99,140931.13,488.14,80543.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','195263',3812629,'2629','389',83571.25,84439.78,868.53,143307.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','195263',3812630,'2630','389',37803.14,37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195263',3812631,'2631','389',95274.10,95274.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195263',3812632,'2632','389',48285.69,48824.72,539.03,88939.95,0.00,0.00,0.00,0.00,0.00),('1','167','886','195263',3812633,'2633','389',73231.87,73858.07,626.20,103323.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195263',3812634,'2634','389',66196.76,66742.19,545.43,89995.95,0.00,0.00,0.00,0.00,0.00),('1','167','886','195263',3812635,'2635','389',73066.18,73487.58,421.40,69531.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195263',3812636,'2636','389',37985.59,37985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195263',3812637,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195263',3812638,'2638','389',202279.10,202282.13,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','167','887','195263',3812639,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195263',3812640,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195263',3812641,'2641','390',407179.96,409132.02,1952.06,507535.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','195263',3812642,'2642','390',276232.59,276924.66,692.07,179938.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','195263',3812643,'2643','390',436394.90,439211.38,2816.48,732284.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195263',3812644,'2644','390',364765.90,364865.91,100.01,26002.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','195263',3812645,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195263',3812646,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195371',3814403,'2605','389',83523.77,83924.40,380.63,62803.95,0.00,0.00,20.00,0.00,0.00),('1','167','880','195371',3814404,'2606','389',78524.98,79227.75,692.77,114307.05,0.00,0.00,10.00,0.00,0.00),('1','167','880','195371',3814405,'2607','389',124424.76,125008.60,568.84,93858.60,0.00,0.00,15.00,0.00,0.00),('1','167','880','195371',3814406,'2608','389',44829.89,44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195371',3814407,'2609','389',77744.43,78040.97,266.54,43979.10,0.00,0.00,30.00,0.00,0.00),('1','167','880','195371',3814408,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814409,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814410,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814411,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814412,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814413,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195371',3814414,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195371',3814415,'2617','389',166599.65,167192.25,582.60,96129.00,0.00,0.00,10.00,0.00,0.00),('1','167','882','195371',3814416,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195371',3814417,'2619','389',155987.51,156584.95,577.44,95277.60,0.00,0.00,20.00,0.00,0.00),('1','167','882','195371',3814418,'2620','389',116515.13,116515.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195371',3814419,'2621','389',25745.19,26689.73,924.54,152549.10,0.00,0.00,20.00,0.00,0.00),('1','167','883','195371',3814420,'2622','389',121322.30,122279.76,947.46,156330.90,0.00,0.00,10.00,0.00,0.00),('1','167','883','195371',3814421,'2623','389',131684.37,132145.95,461.58,76160.70,0.00,0.00,0.00,0.00,0.00),('1','167','883','195371',3814422,'2624','389',53411.23,53411.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195371',3814423,'2625','389',159614.63,160634.81,1010.18,166679.70,0.00,0.00,10.00,0.00,0.00),('1','167','884','195371',3814424,'2626','389',112844.10,113961.89,1107.79,182785.35,0.00,0.00,10.00,0.00,0.00),('1','167','884','195371',3814425,'2627','389',80747.56,80747.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195371',3814426,'2628','389',140931.13,141708.93,777.80,128337.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195371',3814427,'2629','389',84439.78,84871.58,411.80,67947.00,0.00,0.00,20.00,0.00,0.00),('1','167','885','195371',3814428,'2630','389',37803.14,37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195371',3814429,'2631','389',95274.10,95360.47,86.37,14251.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','195371',3814430,'2632','389',48824.72,49337.34,502.62,82932.30,0.00,0.00,10.00,0.00,0.00),('1','167','886','195371',3814431,'2633','389',73858.07,74319.04,440.97,72760.05,0.00,0.00,20.00,0.00,0.00),('1','167','886','195371',3814432,'2634','389',66742.19,67592.03,839.84,138573.60,0.00,0.00,10.00,0.00,0.00),('1','167','886','195371',3814433,'2635','389',73487.58,73838.26,330.68,54562.20,0.00,0.00,20.00,0.00,0.00),('1','167','886','195371',3814434,'2636','389',37985.59,37985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195371',3814435,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195371',3814436,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195371',3814437,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195371',3814438,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195371',3814439,'2641','390',409132.02,410149.87,1017.85,264641.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195371',3814440,'2642','390',276924.66,278305.30,1380.64,358966.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195371',3814441,'2643','390',439211.38,441189.29,1977.91,514256.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','195371',3814442,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195371',3814443,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195371',3814444,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818365,'2605','389',83924.40,84880.14,955.74,157697.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818366,'2606','389',79227.75,79744.94,517.19,85336.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818367,'2607','389',125008.60,125566.26,557.66,92013.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818368,'2608','389',44829.89,44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818369,'2609','389',78040.97,78451.19,410.22,67686.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','195598',3818370,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818371,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818372,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818373,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818374,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818375,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195598',3818376,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195598',3818377,'2617','389',167192.25,167641.95,449.70,74200.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','195598',3818378,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195598',3818379,'2619','389',156584.95,156940.14,355.19,58606.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','195598',3818380,'2620','389',116515.13,116737.58,222.45,36704.25,0.00,0.00,0.00,0.00,0.00),('1','167','883','195598',3818381,'2621','389',26689.73,27203.72,513.99,84808.35,0.00,0.00,0.00,0.00,0.00),('1','167','883','195598',3818382,'2622','389',122279.76,122732.40,440.64,72705.60,0.00,0.00,12.00,0.00,0.00),('1','167','883','195598',3818383,'2623','389',132145.95,132506.23,360.28,59446.20,0.00,0.00,0.00,0.00,0.00),('1','167','883','195598',3818384,'2624','389',53411.23,53733.20,321.97,53125.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','195598',3818385,'2625','389',160634.81,161978.28,1343.47,221672.55,0.00,0.00,0.00,0.00,0.00),('1','167','884','195598',3818386,'2626','389',113961.89,114672.13,710.24,117189.60,0.00,0.00,0.00,0.00,0.00),('1','167','884','195598',3818387,'2627','389',80747.56,81613.81,856.25,141281.25,0.00,0.00,10.00,0.00,0.00),('1','167','884','195598',3818388,'2628','389',141708.93,142405.28,686.35,113247.75,0.00,0.00,10.00,0.00,0.00),('1','167','885','195598',3818389,'2629','389',84871.58,85221.33,349.75,57708.75,0.00,0.00,0.00,0.00,0.00),('1','167','885','195598',3818390,'2630','389',37803.14,37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195598',3818391,'2631','389',95360.47,96611.19,1250.72,206368.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','195598',3818392,'2632','389',49337.34,49337.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195598',3818393,'2633','389',74319.04,75013.04,674.00,111210.00,0.00,0.00,20.00,0.00,0.00),('1','167','886','195598',3818394,'2634','389',67592.03,67592.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195598',3818395,'2635','389',73838.26,74239.61,391.35,64572.75,0.00,0.00,10.00,0.00,0.00),('1','167','886','195598',3818396,'2636','389',37985.59,38474.61,479.02,79038.30,0.00,0.00,10.00,0.00,0.00),('1','167','887','195598',3818397,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195598',3818398,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195598',3818399,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195598',3818400,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195598',3818401,'2641','390',410149.87,412452.23,2302.36,598613.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','195598',3818402,'2642','390',278305.30,278763.88,458.58,119230.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195598',3818403,'2643','390',441189.29,442909.89,1720.60,447356.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195598',3818404,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195598',3818405,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195598',3818406,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819252,'2605','389',84880.14,85474.99,594.85,98150.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819253,'2606','389',79744.94,80253.58,508.64,83925.60,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819254,'2607','389',125566.26,126000.43,434.17,71638.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819255,'2608','389',44829.89,44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819256,'2609','389',78451.19,78838.96,387.77,63982.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','195662',3819257,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819258,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819259,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819260,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819261,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819262,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195662',3819263,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195662',3819264,'2617','389',167641.95,167901.05,259.10,42751.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','195662',3819265,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195662',3819266,'2619','389',156940.14,157299.87,359.73,59355.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','195662',3819267,'2620','389',116737.58,116737.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195662',3819268,'2621','389',27203.72,27649.77,436.05,71948.25,0.00,0.00,10.00,0.00,0.00),('1','167','883','195662',3819269,'2622','389',122732.40,122732.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195662',3819270,'2623','389',132506.23,133057.58,551.35,90972.75,0.00,0.00,0.00,0.00,0.00),('1','167','883','195662',3819271,'2624','389',53733.20,53733.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195662',3819272,'2625','389',161978.28,162928.45,950.17,156778.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','195662',3819273,'2626','389',114672.13,115070.34,398.21,65704.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','195662',3819274,'2627','389',81613.81,82132.63,518.82,85605.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','195662',3819275,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195662',3819276,'2629','389',85221.33,85547.21,325.88,53770.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','195662',3819277,'2630','389',37803.14,37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195662',3819278,'2631','389',96611.19,96883.90,272.71,44997.15,0.00,0.00,0.00,0.00,0.00),('1','167','885','195662',3819279,'2632','389',49337.34,49337.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195662',3819280,'2633','389',75013.04,75013.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195662',3819281,'2634','389',67592.03,68124.41,532.38,87842.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','195662',3819282,'2635','389',74239.61,74478.87,239.26,39477.90,0.00,0.00,0.00,0.00,0.00),('1','167','886','195662',3819283,'2636','389',38474.61,38621.06,146.45,24164.25,0.00,0.00,0.00,0.00,0.00),('1','167','887','195662',3819284,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195662',3819285,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195662',3819286,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195662',3819287,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195662',3819288,'2641','390',412452.23,414203.31,1751.08,455280.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','195662',3819289,'2642','390',278763.88,278791.98,28.10,7306.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195662',3819290,'2643','390',442909.89,445296.12,2386.23,620419.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195662',3819291,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195662',3819292,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195662',3819293,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820033,'2605','389',85474.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820034,'2606','389',80253.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820035,'2607','389',126000.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820036,'2608','389',44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820037,'2609','389',78838.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195700',3820038,'2610','389',115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820039,'2611','389',154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820040,'2612','389',239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820041,'2613','389',89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820042,'2614','389',145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820043,'2615','389',76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195700',3820044,'2616','389',123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195700',3820045,'2617','389',167901.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195700',3820046,'2618','389',92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195700',3820047,'2619','389',157299.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195700',3820048,'2620','389',116737.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195700',3820049,'2621','389',27649.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195700',3820050,'2622','389',122732.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195700',3820051,'2623','389',133057.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195700',3820052,'2624','389',53733.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195700',3820053,'2625','389',162928.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195700',3820054,'2626','389',115070.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195700',3820055,'2627','389',82132.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195700',3820056,'2628','389',142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195700',3820057,'2629','389',85547.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195700',3820058,'2630','389',37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195700',3820059,'2631','389',96883.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195700',3820060,'2632','389',49337.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195700',3820061,'2633','389',75013.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195700',3820062,'2634','389',68124.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195700',3820063,'2635','389',74478.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195700',3820064,'2636','389',38621.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195700',3820065,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195700',3820066,'2638','389',202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195700',3820067,'2639','389',160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195700',3820068,'2640','389',150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195700',3820069,'2641','390',414203.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195700',3820070,'2642','390',278791.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195700',3820071,'2643','390',445296.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195700',3820072,'2644','390',364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195700',3820073,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195700',3820074,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820217,'2605','389',85474.99,85778.49,303.50,49470.50,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820218,'2606','389',80253.58,80499.27,245.69,40047.47,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820219,'2607','389',126000.43,126211.28,210.85,34368.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820220,'2608','389',44829.89,44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820221,'2609','389',78838.96,79117.37,278.41,45380.83,0.00,0.00,0.00,0.00,0.00),('1','167','880','195708',3820222,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820223,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820224,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820225,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820226,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820227,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195708',3820228,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195708',3820229,'2617','389',167901.05,168320.97,419.92,68446.96,0.00,0.00,0.00,0.00,0.00),('1','167','882','195708',3820230,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195708',3820231,'2619','389',157299.87,157602.40,302.53,49312.39,0.00,0.00,0.00,0.00,0.00),('1','167','882','195708',3820232,'2620','389',116737.58,116737.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195708',3820233,'2621','389',27649.77,27935.36,285.59,46551.17,0.00,0.00,0.00,0.00,0.00),('1','167','883','195708',3820234,'2622','389',122732.40,122732.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195708',3820235,'2623','389',133057.58,133545.43,484.85,79030.55,0.00,0.00,3.00,0.00,0.00),('1','167','883','195708',3820236,'2624','389',53733.20,53733.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195708',3820237,'2625','389',162928.45,163153.23,224.78,36639.14,0.00,0.00,0.00,0.00,0.00),('1','167','884','195708',3820238,'2626','389',115070.34,115483.66,413.32,67371.16,0.00,0.00,0.00,0.00,0.00),('1','167','884','195708',3820239,'2627','389',82132.63,82360.90,228.27,37208.01,0.00,0.00,0.00,0.00,0.00),('1','167','884','195708',3820240,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195708',3820241,'2629','389',85547.21,85734.08,186.87,30459.81,0.00,0.00,0.00,0.00,0.00),('1','167','885','195708',3820242,'2630','389',37803.14,37803.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195708',3820243,'2631','389',96883.90,97181.93,298.03,48578.89,0.00,0.00,0.00,0.00,0.00),('1','167','885','195708',3820244,'2632','389',49337.34,49337.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195708',3820245,'2633','389',75013.04,75013.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195708',3820246,'2634','389',68124.41,68294.08,169.67,27656.21,0.00,0.00,0.00,0.00,0.00),('1','167','886','195708',3820247,'2635','389',74478.87,74830.34,351.47,57289.61,0.00,0.00,0.00,0.00,0.00),('1','167','886','195708',3820248,'2636','389',38621.06,38814.17,193.11,31476.93,0.00,0.00,0.00,0.00,0.00),('1','167','887','195708',3820249,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195708',3820250,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195708',3820251,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195708',3820252,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195708',3820253,'2641','390',414203.31,414203.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195708',3820254,'2642','390',278791.98,278791.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195708',3820255,'2643','390',445296.12,445296.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195708',3820256,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195708',3820257,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195708',3820258,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824082,'2605','389',85778.49,86617.36,838.87,136735.81,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824083,'2606','389',80499.27,80770.97,271.70,44287.10,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824084,'2607','389',126211.28,126873.18,661.90,107889.70,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824085,'2608','389',44829.89,44829.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824086,'2609','389',79117.37,79642.71,525.34,85630.42,0.00,0.00,0.00,0.00,0.00),('1','167','880','195926',3824087,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824088,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824089,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824090,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824091,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824092,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195926',3824093,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195926',3824094,'2617','389',168320.97,168901.26,580.29,94587.27,0.00,0.00,0.00,0.00,0.00),('1','167','882','195926',3824095,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195926',3824096,'2619','389',157602.40,158202.85,600.45,97873.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','195926',3824097,'2620','389',116737.58,116737.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195926',3824098,'2621','389',27935.36,28734.58,799.22,130272.86,0.00,0.00,0.00,0.00,0.00),('1','167','883','195926',3824099,'2622','389',122732.40,123557.37,824.97,134470.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','195926',3824100,'2623','389',133545.43,134303.15,757.72,123508.36,0.00,0.00,0.00,0.00,0.00),('1','167','883','195926',3824101,'2624','389',53733.20,54031.12,297.92,48560.96,0.00,0.00,0.00,0.00,0.00),('1','167','884','195926',3824102,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195926',3824103,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195926',3824104,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195926',3824105,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195926',3824106,'2629','389',85734.08,86053.96,319.88,52140.44,0.00,0.00,0.00,0.00,0.00),('1','167','885','195926',3824107,'2630','389',37803.14,38138.91,335.77,54730.51,0.00,0.00,0.00,0.00,0.00),('1','167','885','195926',3824108,'2631','389',97181.93,97644.63,462.70,75420.10,0.00,0.00,0.00,0.00,0.00),('1','167','885','195926',3824109,'2632','389',49337.34,49743.84,406.50,66259.50,0.00,0.00,0.00,0.00,0.00),('1','167','886','195926',3824110,'2633','389',75013.04,75891.83,878.79,143242.77,0.00,0.00,0.00,0.00,0.00),('1','167','886','195926',3824111,'2634','389',68294.08,69043.98,749.90,122233.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','195926',3824112,'2635','389',74830.34,75316.98,486.64,79322.32,0.00,0.00,0.00,0.00,0.00),('1','167','886','195926',3824113,'2636','389',38814.17,39352.41,538.24,87733.12,0.00,0.00,0.00,0.00,0.00),('1','167','887','195926',3824114,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195926',3824115,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195926',3824116,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195926',3824117,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195926',3824118,'2641','390',414203.31,417538.85,3335.54,867240.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','195926',3824119,'2642','390',278791.98,278798.97,6.99,1817.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195926',3824120,'2643','390',445296.12,447912.49,2616.37,680256.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','195926',3824121,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195926',3824122,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195926',3824123,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824230,'2605','389',86617.36,87492.83,875.47,142701.61,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824231,'2606','389',80770.97,81235.79,464.82,75765.66,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824232,'2607','389',126873.18,127456.13,582.95,95020.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824233,'2608','389',44829.89,45440.28,610.39,99493.57,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824234,'2609','389',79642.71,80393.19,750.48,122328.24,0.00,0.00,0.00,0.00,0.00),('1','167','880','195933',3824235,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824236,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824237,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824238,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824239,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824240,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195933',3824241,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195933',3824242,'2617','389',168901.26,169714.94,813.68,132629.84,0.00,0.00,0.00,0.00,0.00),('1','167','882','195933',3824243,'2618','389',92793.50,92793.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195933',3824244,'2619','389',158202.85,158802.74,599.89,97782.07,0.00,0.00,0.00,0.00,0.00),('1','167','882','195933',3824245,'2620','389',116737.58,117209.93,472.35,76993.05,0.00,0.00,0.00,0.00,0.00),('1','167','883','195933',3824246,'2621','389',28734.58,29910.76,1176.18,191717.34,0.00,0.00,0.00,0.00,0.00),('1','167','883','195933',3824247,'2622','389',123557.37,124322.76,765.39,124758.57,0.00,0.00,0.00,0.00,0.00),('1','167','883','195933',3824248,'2623','389',134303.15,134921.14,617.99,100732.37,0.00,0.00,0.00,0.00,0.00),('1','167','883','195933',3824249,'2624','389',54031.12,54734.95,703.83,114724.29,0.00,0.00,0.00,0.00,0.00),('1','167','884','195933',3824250,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195933',3824251,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195933',3824252,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195933',3824253,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195933',3824254,'2629','389',86053.96,86656.86,602.90,98272.70,0.00,0.00,0.00,0.00,0.00),('1','167','885','195933',3824255,'2630','389',38138.91,38313.46,174.55,28451.65,0.00,0.00,0.00,0.00,0.00),('1','167','885','195933',3824256,'2631','389',97644.63,98080.91,436.28,71113.64,0.00,0.00,0.00,0.00,0.00),('1','167','885','195933',3824257,'2632','389',49743.84,50230.22,486.38,79279.94,0.00,0.00,0.00,0.00,0.00),('1','167','886','195933',3824258,'2633','389',75891.83,76828.61,936.78,152695.14,0.00,0.00,0.00,0.00,0.00),('1','167','886','195933',3824259,'2634','389',69043.98,69043.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195933',3824260,'2635','389',75316.98,75948.56,631.58,102947.54,0.00,0.00,0.00,0.00,0.00),('1','167','886','195933',3824261,'2636','389',39352.41,39352.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195933',3824262,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195933',3824263,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195933',3824264,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195933',3824265,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195933',3824266,'2641','390',417538.85,421191.62,3652.77,949720.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','195933',3824267,'2642','390',278798.97,278925.96,126.99,33017.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','195933',3824268,'2643','390',447912.49,449055.44,1142.95,297167.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195933',3824269,'2644','390',364865.91,364865.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195933',3824270,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195933',3824271,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824582,'2605','389',87492.83,88127.04,634.21,103376.23,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824583,'2606','389',81235.79,82100.91,865.12,141014.56,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824584,'2607','389',127456.13,128259.90,803.77,131014.51,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824585,'2608','389',45440.28,45918.75,478.47,77990.61,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824586,'2609','389',80393.19,80719.56,326.37,53198.31,0.00,0.00,0.00,0.00,0.00),('1','167','880','195946',3824587,'2610','389',115971.19,115971.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824588,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824589,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824590,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824591,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824592,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195946',3824593,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195946',3824594,'2617','389',169714.94,169997.06,282.12,45985.56,0.00,0.00,0.00,0.00,0.00),('1','167','882','195946',3824595,'2618','389',92793.50,93051.72,258.22,42089.86,0.00,0.00,0.00,0.00,0.00),('1','167','882','195946',3824596,'2619','389',158802.74,159170.66,367.92,59970.96,0.00,0.00,0.00,0.00,0.00),('1','167','882','195946',3824597,'2620','389',117209.93,117650.31,440.38,71781.94,0.00,0.00,0.00,0.00,0.00),('1','167','883','195946',3824598,'2621','389',29910.76,30787.03,876.27,142832.01,0.00,0.00,0.00,0.00,0.00),('1','167','883','195946',3824599,'2622','389',124322.76,125598.42,1275.66,207932.58,0.00,0.00,0.00,0.00,0.00),('1','167','883','195946',3824600,'2623','389',134921.14,135376.19,455.05,74173.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','195946',3824601,'2624','389',54734.95,55196.29,461.34,75198.42,0.00,0.00,0.00,0.00,0.00),('1','167','884','195946',3824602,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195946',3824603,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195946',3824604,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195946',3824605,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195946',3824606,'2629','389',86656.86,87049.21,392.35,63953.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','195946',3824607,'2630','389',38313.46,38640.97,327.51,53384.13,0.00,0.00,0.00,0.00,0.00),('1','167','885','195946',3824608,'2631','389',98080.91,98554.51,473.60,77196.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','195946',3824609,'2632','389',50230.22,50689.58,459.36,74875.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','195946',3824610,'2633','389',76828.61,78834.72,2000.11,326017.93,0.00,0.00,6.00,0.00,0.00),('1','167','886','195946',3824611,'2634','389',69043.98,69043.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','195946',3824612,'2635','389',75948.56,76465.46,516.90,84254.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','195946',3824613,'2636','389',39352.41,39918.03,565.62,92196.06,0.00,0.00,0.00,0.00,0.00),('1','167','887','195946',3824614,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195946',3824615,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195946',3824616,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195946',3824617,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195946',3824618,'2641','390',421191.62,421961.52,769.90,200174.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195946',3824619,'2642','390',278925.96,278984.47,58.51,15212.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','195946',3824620,'2643','390',449055.44,449825.67,770.23,200259.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','195946',3824621,'2644','390',364865.91,365443.45,577.54,150160.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','195946',3824622,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195946',3824623,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824977,'2605','389',88127.04,89193.57,1066.53,173844.39,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824978,'2606','389',82100.91,82836.12,735.21,119839.23,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824979,'2607','389',128259.90,128809.54,549.64,89591.32,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824980,'2608','389',45918.75,46674.40,755.65,123170.95,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824981,'2609','389',80719.56,81094.47,374.91,61110.33,0.00,0.00,0.00,0.00,0.00),('1','167','880','195963',3824982,'2610','389',115971.19,116458.60,487.41,79447.83,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824983,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824984,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824985,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824986,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824987,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','195963',3824988,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195963',3824989,'2617','389',169997.06,170601.84,604.78,98579.14,0.00,0.00,0.00,0.00,0.00),('1','167','882','195963',3824990,'2618','389',93051.72,93051.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','195963',3824991,'2619','389',159170.66,159855.03,684.37,111552.31,0.00,0.00,0.00,0.00,0.00),('1','167','882','195963',3824992,'2620','389',117650.31,117650.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','195963',3824993,'2621','389',30787.03,31567.80,780.77,127265.51,0.00,0.00,0.00,0.00,0.00),('1','167','883','195963',3824994,'2622','389',125598.42,126434.23,835.81,136237.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','195963',3824995,'2623','389',135376.19,136119.70,743.51,121192.13,0.00,0.00,0.00,0.00,0.00),('1','167','883','195963',3824996,'2624','389',55196.29,56096.52,900.23,146737.49,0.00,0.00,0.00,0.00,0.00),('1','167','884','195963',3824997,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195963',3824998,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195963',3824999,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','195963',3825000,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','195963',3825001,'2629','389',87049.21,87668.18,618.97,100892.11,0.00,0.00,0.00,0.00,0.00),('1','167','885','195963',3825002,'2630','389',38640.97,39051.03,410.06,66839.78,0.00,0.00,0.00,0.00,0.00),('1','167','885','195963',3825003,'2631','389',98554.51,98804.13,249.62,40688.06,0.00,0.00,0.00,0.00,0.00),('1','167','885','195963',3825004,'2632','389',50689.58,50980.92,291.34,47488.42,0.00,0.00,0.00,0.00,0.00),('1','167','886','195963',3825005,'2633','389',78834.72,79657.99,823.27,134193.01,0.00,0.00,0.00,0.00,0.00),('1','167','886','195963',3825006,'2634','389',69043.98,69681.39,637.41,103897.83,0.00,0.00,0.00,0.00,0.00),('1','167','886','195963',3825007,'2635','389',76465.46,77276.40,810.94,132183.22,0.00,0.00,0.00,0.00,0.00),('1','167','886','195963',3825008,'2636','389',39918.03,40473.22,555.19,90495.97,0.00,0.00,0.00,0.00,0.00),('1','167','887','195963',3825009,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195963',3825010,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195963',3825011,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','195963',3825012,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','195963',3825013,'2641','390',421961.52,423462.21,1500.69,390179.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','195963',3825014,'2642','390',278984.47,278985.47,1.00,260.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195963',3825015,'2643','390',449825.67,450936.87,1111.20,288912.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','195963',3825016,'2644','390',365443.45,366956.53,1513.08,393400.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','195963',3825017,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','195963',3825018,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826905,'2605','389',89193.57,90019.15,825.58,134569.54,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826906,'2606','389',82836.12,83850.05,1013.93,165270.59,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826907,'2607','389',128809.54,129346.89,537.35,87588.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826908,'2608','389',46674.40,47157.21,482.81,78698.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826909,'2609','389',81094.47,81541.88,447.41,72927.83,0.00,0.00,0.00,0.00,0.00),('1','167','880','196085',3826910,'2610','389',116458.60,116619.55,160.95,26234.85,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826911,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826912,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826913,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826914,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826915,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196085',3826916,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196085',3826917,'2617','389',170601.84,171228.64,626.80,102168.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','196085',3826918,'2618','389',93051.72,93655.80,604.08,98465.04,0.00,0.00,0.00,0.00,0.00),('1','167','882','196085',3826919,'2619','389',159855.03,160269.40,414.37,67542.31,0.00,0.00,0.00,0.00,0.00),('1','167','882','196085',3826920,'2620','389',117650.31,118205.85,555.54,90553.02,0.00,0.00,0.00,0.00,0.00),('1','167','883','196085',3826921,'2621','389',31567.80,32828.35,1260.55,205469.65,0.00,0.00,0.00,0.00,0.00),('1','167','883','196085',3826922,'2622','389',126434.23,127275.20,840.97,137078.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','196085',3826923,'2623','389',136119.70,136726.32,606.62,98879.06,0.00,0.00,0.00,0.00,0.00),('1','167','883','196085',3826924,'2624','389',56096.52,56597.17,500.65,81605.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','196085',3826925,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196085',3826926,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196085',3826927,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196085',3826928,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196085',3826929,'2629','389',87668.18,87668.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196085',3826930,'2630','389',39051.03,39051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196085',3826931,'2631','389',98804.13,98804.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196085',3826932,'2632','389',50980.92,50980.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196085',3826933,'2633','389',79657.99,80967.47,1309.48,213445.24,0.00,0.00,0.00,0.00,0.00),('1','167','886','196085',3826934,'2634','389',69681.39,70787.92,1106.53,180364.39,0.00,0.00,0.00,0.00,0.00),('1','167','886','196085',3826935,'2635','389',77276.40,78201.96,925.56,150866.28,0.00,0.00,0.00,0.00,0.00),('1','167','886','196085',3826936,'2636','389',40473.22,40857.37,384.15,62616.45,0.00,0.00,0.00,0.00,0.00),('1','167','887','196085',3826937,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196085',3826938,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196085',3826939,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196085',3826940,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196085',3826941,'2641','390',423462.21,424924.06,1461.85,380081.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196085',3826942,'2642','390',278985.47,279010.05,24.58,6390.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196085',3826943,'2643','390',450936.87,452319.95,1383.08,359600.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196085',3826944,'2644','390',366956.53,367923.24,966.71,251344.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','196085',3826945,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196085',3826946,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827052,'2605','389',90019.15,91305.83,1286.68,209728.84,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827053,'2606','389',83850.05,83907.42,57.37,9351.31,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827054,'2607','389',129346.89,130031.57,684.68,111602.84,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827055,'2608','389',47157.21,47174.94,17.73,2889.99,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827056,'2609','389',81541.88,82036.26,494.38,80583.94,0.00,0.00,0.00,0.00,0.00),('1','167','880','196094',3827057,'2610','389',116619.55,116772.99,153.44,25010.72,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827058,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827059,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827060,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827061,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827062,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196094',3827063,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196094',3827064,'2617','389',171228.64,173144.68,1916.04,312314.52,0.00,0.00,0.00,0.00,0.00),('1','167','882','196094',3827065,'2618','389',93655.80,95116.00,1460.20,238012.60,0.00,0.00,0.00,0.00,0.00),('1','167','882','196094',3827066,'2619','389',160269.40,161642.74,1373.34,223854.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','196094',3827067,'2620','389',118205.85,118602.08,396.23,64585.49,0.00,0.00,0.00,0.00,0.00),('1','167','883','196094',3827068,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196094',3827069,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196094',3827070,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196094',3827071,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196094',3827072,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196094',3827073,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196094',3827074,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196094',3827075,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196094',3827076,'2629','389',87668.18,87668.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196094',3827077,'2630','389',39051.03,39051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196094',3827078,'2631','389',98804.13,98804.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196094',3827079,'2632','389',50980.92,50980.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196094',3827080,'2633','389',80967.47,81179.57,212.10,34572.30,0.00,0.00,0.00,0.00,0.00),('1','167','886','196094',3827081,'2634','389',70787.92,71983.49,1195.57,194877.91,0.00,0.00,0.00,0.00,0.00),('1','167','886','196094',3827082,'2635','389',78201.96,79027.44,825.48,134553.24,0.00,0.00,0.00,0.00,0.00),('1','167','886','196094',3827083,'2636','389',40857.37,40915.64,58.27,9498.01,0.00,0.00,0.00,0.00,0.00),('1','167','887','196094',3827084,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196094',3827085,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196094',3827086,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196094',3827087,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196094',3827088,'2641','390',424924.06,426181.50,1257.44,326934.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','196094',3827089,'2642','390',279010.05,279010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196094',3827090,'2643','390',452319.95,453638.69,1318.74,342872.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','196094',3827091,'2644','390',367923.24,369005.70,1082.46,281439.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','196094',3827092,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196094',3827093,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827154,'2605','389',91305.83,91305.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827155,'2606','389',83907.42,83907.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827156,'2607','389',130031.57,130031.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827157,'2608','389',47174.94,47174.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827158,'2609','389',82036.26,82036.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196097',3827159,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827160,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827161,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827162,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827163,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827164,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196097',3827165,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196097',3827166,'2617','389',173144.68,173144.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196097',3827167,'2618','389',95116.00,99501.61,4375.61,713224.43,0.00,0.00,10.00,0.00,0.00),('1','167','882','196097',3827168,'2619','389',161642.74,164742.47,3089.73,503625.99,0.00,0.00,10.00,0.00,0.00),('1','167','882','196097',3827169,'2620','389',118602.08,121299.18,2687.10,437997.30,0.00,0.00,10.00,0.00,0.00),('1','167','883','196097',3827170,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196097',3827171,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196097',3827172,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196097',3827173,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196097',3827174,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196097',3827175,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196097',3827176,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196097',3827177,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196097',3827178,'2629','389',87668.18,87668.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196097',3827179,'2630','389',39051.03,39051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196097',3827180,'2631','389',98804.13,98804.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196097',3827181,'2632','389',50980.92,50980.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196097',3827182,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196097',3827183,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196097',3827184,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196097',3827185,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196097',3827186,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196097',3827187,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196097',3827188,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196097',3827189,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196097',3827190,'2641','390',426181.50,427372.73,1191.23,309719.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196097',3827191,'2642','390',279010.05,279010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196097',3827192,'2643','390',453638.69,454730.71,1092.02,283925.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196097',3827193,'2644','390',369005.70,369554.94,549.24,142802.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','196097',3827194,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196097',3827195,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827196,'2605','389',91305.83,91305.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827197,'2606','389',83907.42,83907.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827198,'2607','389',130031.57,130031.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827199,'2608','389',47174.94,47174.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827200,'2609','389',82036.26,82036.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196098',3827201,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827202,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827203,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827204,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827205,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827206,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196098',3827207,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196098',3827208,'2617','389',173144.68,174298.53,1153.85,188077.55,0.00,0.00,0.00,0.00,0.00),('1','167','882','196098',3827209,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196098',3827210,'2619','389',164742.47,165569.23,826.76,134761.88,0.00,0.00,0.00,0.00,0.00),('1','167','882','196098',3827211,'2620','389',121299.18,121857.96,558.78,91081.14,0.00,0.00,0.00,0.00,0.00),('1','167','883','196098',3827212,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196098',3827213,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196098',3827214,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196098',3827215,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196098',3827216,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196098',3827217,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196098',3827218,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196098',3827219,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196098',3827220,'2629','389',87668.18,87668.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196098',3827221,'2630','389',39051.03,39051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196098',3827222,'2631','389',98804.13,98804.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196098',3827223,'2632','389',50980.92,50980.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196098',3827224,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196098',3827225,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196098',3827226,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196098',3827227,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196098',3827228,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196098',3827229,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196098',3827230,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196098',3827231,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196098',3827232,'2641','390',427372.73,428930.33,1557.60,404976.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196098',3827233,'2642','390',279010.05,279840.27,830.22,215857.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196098',3827234,'2643','390',454730.71,456362.41,1631.70,424242.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196098',3827235,'2644','390',369554.94,369554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196098',3827236,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196098',3827237,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827270,'2605','389',91305.83,91305.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827271,'2606','389',83907.42,83907.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827272,'2607','389',130031.57,130031.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827273,'2608','389',47174.94,47174.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827274,'2609','389',82036.26,82036.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196101',3827275,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827276,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827277,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827278,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827279,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827280,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196101',3827281,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196101',3827282,'2617','389',174298.53,174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196101',3827283,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196101',3827284,'2619','389',165569.23,165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196101',3827285,'2620','389',121857.96,121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196101',3827286,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196101',3827287,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196101',3827288,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196101',3827289,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196101',3827290,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196101',3827291,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196101',3827292,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196101',3827293,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196101',3827294,'2629','389',87668.18,87668.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196101',3827295,'2630','389',39051.03,39051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196101',3827296,'2631','389',98804.13,98804.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196101',3827297,'2632','389',50980.92,50980.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196101',3827298,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196101',3827299,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196101',3827300,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196101',3827301,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196101',3827302,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196101',3827303,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196101',3827304,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196101',3827305,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196101',3827306,'2641','390',428930.33,431626.84,2696.51,701092.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','196101',3827307,'2642','390',279840.27,279871.02,30.75,7995.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196101',3827308,'2643','390',456362.41,458583.68,2221.27,577530.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196101',3827309,'2644','390',369554.94,369554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196101',3827310,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196101',3827311,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827438,'2605','389',91305.83,92668.68,1362.85,222144.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827439,'2606','389',83907.42,84777.48,870.06,141819.78,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827440,'2607','389',130031.57,130762.60,731.03,119157.89,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827441,'2608','389',47174.94,47675.36,500.42,81568.46,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827442,'2609','389',82036.26,82814.75,778.49,126893.87,0.00,0.00,0.00,0.00,0.00),('1','167','880','196109',3827443,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827444,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827445,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827446,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827447,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827448,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196109',3827449,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196109',3827450,'2617','389',174298.53,174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196109',3827451,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196109',3827452,'2619','389',165569.23,165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196109',3827453,'2620','389',121857.96,121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196109',3827454,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196109',3827455,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196109',3827456,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196109',3827457,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196109',3827458,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196109',3827459,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196109',3827460,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196109',3827461,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196109',3827462,'2629','389',87668.18,88521.00,852.82,139009.66,0.00,0.00,0.00,0.00,0.00),('1','167','885','196109',3827463,'2630','389',39051.03,39757.51,706.48,115156.24,0.00,0.00,0.00,0.00,0.00),('1','167','885','196109',3827464,'2631','389',98804.13,99288.63,484.50,78973.50,0.00,0.00,0.00,0.00,0.00),('1','167','885','196109',3827465,'2632','389',50980.92,51706.10,725.18,118204.34,0.00,0.00,0.00,0.00,0.00),('1','167','886','196109',3827466,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196109',3827467,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196109',3827468,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196109',3827469,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196109',3827470,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196109',3827471,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196109',3827472,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196109',3827473,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196109',3827474,'2641','390',431626.84,433137.34,1510.50,392730.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196109',3827475,'2642','390',279871.02,279871.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196109',3827476,'2643','390',458583.68,460408.94,1825.26,474567.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196109',3827477,'2644','390',369554.94,369819.12,264.18,68686.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','196109',3827478,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196109',3827479,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196120',3827698,'2605','389',92668.68,94389.05,1710.37,278790.31,0.00,0.00,10.00,0.00,0.00),('1','167','880','196120',3827699,'2606','389',84777.48,86612.24,1824.76,297435.88,0.00,0.00,10.00,0.00,0.00),('1','167','880','196120',3827700,'2607','389',130762.60,131628.54,855.94,139518.22,0.00,0.00,10.00,0.00,0.00),('1','167','880','196120',3827701,'2608','389',47675.36,48274.36,589.00,96007.00,0.00,0.00,10.00,0.00,0.00),('1','167','880','196120',3827702,'2609','389',82814.75,84397.53,1572.78,256363.14,0.00,0.00,10.00,0.00,0.00),('1','167','880','196120',3827703,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827704,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827705,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827706,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827707,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827708,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196120',3827709,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196120',3827710,'2617','389',174298.53,174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196120',3827711,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196120',3827712,'2619','389',165569.23,165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196120',3827713,'2620','389',121857.96,121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196120',3827714,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196120',3827715,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196120',3827716,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196120',3827717,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196120',3827718,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196120',3827719,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196120',3827720,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196120',3827721,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196120',3827722,'2629','389',88521.00,89847.62,1316.62,214609.06,0.00,0.00,10.00,0.00,0.00),('1','167','885','196120',3827723,'2630','389',39757.51,40684.90,917.39,149534.57,0.00,0.00,10.00,0.00,0.00),('1','167','885','196120',3827724,'2631','389',99288.63,100467.12,1168.49,190463.87,0.00,0.00,10.00,0.00,0.00),('1','167','885','196120',3827725,'2632','389',51706.10,52644.36,936.26,152610.38,0.00,0.00,2.00,0.00,0.00),('1','167','886','196120',3827726,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196120',3827727,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196120',3827728,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196120',3827729,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196120',3827730,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196120',3827731,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196120',3827732,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196120',3827733,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196120',3827734,'2641','390',433137.34,434351.05,1213.71,315564.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','196120',3827735,'2642','390',279871.02,280189.72,318.70,82862.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196120',3827736,'2643','390',460408.94,461587.56,1178.62,306441.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196120',3827737,'2644','390',369819.12,370469.44,650.32,169083.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','196120',3827738,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196120',3827739,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827827,'2605','389',94389.05,95813.10,1424.05,232120.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827828,'2606','389',86612.24,87659.76,1047.52,170745.76,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827829,'2607','389',131628.54,133596.26,1967.72,320738.36,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827830,'2608','389',48274.36,49110.61,836.25,136308.75,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827831,'2609','389',84397.53,85972.91,1575.38,256786.94,0.00,0.00,0.00,0.00,0.00),('1','167','880','196126',3827832,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827833,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827834,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827835,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827836,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827837,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196126',3827838,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196126',3827839,'2617','389',174298.53,174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196126',3827840,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196126',3827841,'2619','389',165569.23,165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196126',3827842,'2620','389',121857.96,121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196126',3827843,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196126',3827844,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196126',3827845,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196126',3827846,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196126',3827847,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196126',3827848,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196126',3827849,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196126',3827850,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196126',3827851,'2629','389',89847.62,91212.65,1365.03,222499.89,0.00,0.00,0.00,0.00,0.00),('1','167','885','196126',3827852,'2630','389',40684.90,41758.50,1073.60,174996.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','196126',3827853,'2631','389',100467.12,101390.35,923.23,150486.49,0.00,0.00,0.00,0.00,0.00),('1','167','885','196126',3827854,'2632','389',52644.36,53584.97,940.61,153319.43,0.00,0.00,0.00,0.00,0.00),('1','167','886','196126',3827855,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196126',3827856,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196126',3827857,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196126',3827858,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196126',3827859,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196126',3827860,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196126',3827861,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196126',3827862,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196126',3827863,'2641','390',434351.05,435949.60,1598.55,415623.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196126',3827864,'2642','390',280189.72,280189.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196126',3827865,'2643','390',461587.56,462369.42,781.86,203283.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196126',3827866,'2644','390',370469.44,370469.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196126',3827867,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196126',3827868,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828131,'2605','389',95813.10,95813.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828132,'2606','389',87659.76,89890.61,2230.85,363628.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828133,'2607','389',133596.26,136291.28,2695.02,439288.26,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828134,'2608','389',49110.61,50430.89,1320.28,215205.64,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828135,'2609','389',85972.91,87877.51,1904.60,310449.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','196139',3828136,'2610','389',116772.99,116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828137,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828138,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828139,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828140,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828141,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196139',3828142,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196139',3828143,'2617','389',174298.53,174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196139',3828144,'2618','389',99501.61,99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196139',3828145,'2619','389',165569.23,165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196139',3828146,'2620','389',121857.96,121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196139',3828147,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196139',3828148,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196139',3828149,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196139',3828150,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196139',3828151,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196139',3828152,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196139',3828153,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196139',3828154,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196139',3828155,'2629','389',91212.65,92256.99,1044.34,170227.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','196139',3828156,'2630','389',41758.50,42766.82,1008.32,164356.16,0.00,0.00,0.00,0.00,0.00),('1','167','885','196139',3828157,'2631','389',101390.35,102401.56,1011.21,164827.23,0.00,0.00,0.00,0.00,0.00),('1','167','885','196139',3828158,'2632','389',53584.97,54158.24,573.27,93443.01,0.00,0.00,0.00,0.00,0.00),('1','167','886','196139',3828159,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196139',3828160,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196139',3828161,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196139',3828162,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196139',3828163,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196139',3828164,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196139',3828165,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196139',3828166,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196139',3828167,'2641','390',435949.60,437179.14,1229.54,319680.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','196139',3828168,'2642','390',280189.72,281012.89,823.17,214024.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196139',3828169,'2643','390',462369.42,463535.28,1165.86,303123.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196139',3828170,'2644','390',370469.44,371452.58,983.14,255616.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','196139',3828171,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196139',3828172,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828253,'2605','389',95813.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828254,'2606','389',89890.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828255,'2607','389',136291.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828256,'2608','389',50430.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828257,'2609','389',87877.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196144',3828258,'2610','389',116772.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828259,'2611','389',154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828260,'2612','389',239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828261,'2613','389',89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828262,'2614','389',145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828263,'2615','389',76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196144',3828264,'2616','389',123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196144',3828265,'2617','389',174298.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196144',3828266,'2618','389',99501.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196144',3828267,'2619','389',165569.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196144',3828268,'2620','389',121857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196144',3828269,'2621','389',32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196144',3828270,'2622','389',127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196144',3828271,'2623','389',136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196144',3828272,'2624','389',56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196144',3828273,'2625','389',163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196144',3828274,'2626','389',115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196144',3828275,'2627','389',82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196144',3828276,'2628','389',142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196144',3828277,'2629','389',92256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196144',3828278,'2630','389',42766.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196144',3828279,'2631','389',102401.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196144',3828280,'2632','389',54158.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196144',3828281,'2633','389',81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196144',3828282,'2634','389',71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196144',3828283,'2635','389',79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196144',3828284,'2636','389',40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196144',3828285,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196144',3828286,'2638','389',202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196144',3828287,'2639','389',160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196144',3828288,'2640','389',150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196144',3828289,'2641','390',437179.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196144',3828290,'2642','390',281012.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196144',3828291,'2643','390',463535.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196144',3828292,'2644','390',371452.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196144',3828293,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196144',3828294,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828379,'2605','389',95813.10,96488.99,675.89,110170.07,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828380,'2606','389',89890.61,90797.79,907.18,147870.34,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828381,'2607','389',136291.28,136994.15,702.87,114567.81,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828382,'2608','389',50430.89,51136.31,705.42,114983.46,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828383,'2609','389',87877.51,89252.16,1374.65,224067.95,0.00,0.00,0.00,0.00,0.00),('1','167','880','196150',3828384,'2610','389',116772.99,116788.51,15.52,2529.76,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828385,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828386,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828387,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828388,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828389,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196150',3828390,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196150',3828391,'2617','389',174298.53,175475.06,1176.53,191774.39,0.00,0.00,0.00,0.00,0.00),('1','167','882','196150',3828392,'2618','389',99501.61,100121.51,619.90,101043.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','196150',3828393,'2619','389',165569.23,166367.05,797.82,130044.66,0.00,0.00,0.00,0.00,0.00),('1','167','882','196150',3828394,'2620','389',121857.96,122819.93,961.97,156801.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','196150',3828395,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196150',3828396,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196150',3828397,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196150',3828398,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196150',3828399,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196150',3828400,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196150',3828401,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196150',3828402,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196150',3828403,'2629','389',92256.99,92256.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196150',3828404,'2630','389',42766.82,42766.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196150',3828405,'2631','389',102401.56,102401.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196150',3828406,'2632','389',54158.24,54158.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196150',3828407,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196150',3828408,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196150',3828409,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196150',3828410,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196150',3828411,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196150',3828412,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196150',3828413,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196150',3828414,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196150',3828415,'2641','390',437179.14,438685.16,1506.02,391565.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','196150',3828416,'2642','390',281012.89,281932.02,919.13,238973.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196150',3828417,'2643','390',463535.28,467176.62,3641.34,946748.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','196150',3828418,'2644','390',371452.58,371452.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196150',3828419,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196150',3828420,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828645,'2605','389',96488.99,96488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828646,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828647,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828648,'2608','389',51136.31,51136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828649,'2609','389',89252.16,89252.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196163',3828650,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828651,'2611','389',154793.04,154793.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828652,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828653,'2613','389',89735.61,89735.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828654,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828655,'2615','389',76354.64,76354.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196163',3828656,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196163',3828657,'2617','389',175475.06,179637.62,4162.56,678497.28,0.00,0.00,0.00,0.00,0.00),('1','167','882','196163',3828658,'2618','389',100121.51,100121.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196163',3828659,'2619','389',166367.05,169302.59,2935.54,478493.02,0.00,0.00,0.00,0.00,0.00),('1','167','882','196163',3828660,'2620','389',122819.93,124285.29,1465.36,238853.68,0.00,0.00,0.00,0.00,0.00),('1','167','883','196163',3828661,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196163',3828662,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196163',3828663,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196163',3828664,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196163',3828665,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196163',3828666,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196163',3828667,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196163',3828668,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196163',3828669,'2629','389',92256.99,92794.61,537.62,87632.06,0.00,0.00,0.00,0.00,0.00),('1','167','885','196163',3828670,'2630','389',42766.82,43217.93,451.11,73530.93,0.00,0.00,0.00,0.00,0.00),('1','167','885','196163',3828671,'2631','389',102401.56,103004.52,602.96,98282.48,0.00,0.00,0.00,0.00,0.00),('1','167','885','196163',3828672,'2632','389',54158.24,54542.01,383.77,62554.51,0.00,0.00,0.00,0.00,0.00),('1','167','886','196163',3828673,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196163',3828674,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196163',3828675,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196163',3828676,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196163',3828677,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196163',3828678,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196163',3828679,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196163',3828680,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196163',3828681,'2641','390',438685.16,440692.64,2007.48,521944.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196163',3828682,'2642','390',281932.02,282964.71,1032.69,268499.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','196163',3828683,'2643','390',467176.62,470495.31,3318.69,862859.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','196163',3828684,'2644','390',371452.58,371452.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196163',3828685,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196163',3828686,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828748,'2605','389',96488.99,96488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828749,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828750,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828751,'2608','389',51136.31,51136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828752,'2609','389',89252.16,89252.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196169',3828753,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828754,'2611','389',154793.04,156644.58,1851.54,301801.02,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828755,'2612','389',239877.92,239877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828756,'2613','389',89735.61,92497.47,2761.86,450183.18,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828757,'2614','389',145868.55,145868.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828758,'2615','389',76354.64,78295.79,1941.15,316407.45,0.00,0.00,0.00,0.00,0.00),('1','167','881','196169',3828759,'2616','389',123922.93,123922.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196169',3828760,'2617','389',179637.62,180857.82,1210.20,197262.60,0.00,0.00,10.00,0.00,0.00),('1','167','882','196169',3828761,'2618','389',100121.51,100121.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196169',3828762,'2619','389',169302.59,170049.29,746.70,121712.10,0.00,0.00,0.00,0.00,0.00),('1','167','882','196169',3828763,'2620','389',124285.29,125556.52,1271.23,207210.49,0.00,0.00,0.00,0.00,0.00),('1','167','883','196169',3828764,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196169',3828765,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196169',3828766,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196169',3828767,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196169',3828768,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196169',3828769,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196169',3828770,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196169',3828771,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196169',3828772,'2629','389',92794.61,93879.65,1075.04,175231.52,0.00,0.00,10.00,0.00,0.00),('1','167','885','196169',3828773,'2630','389',43217.93,44085.78,857.85,139829.55,0.00,0.00,10.00,0.00,0.00),('1','167','885','196169',3828774,'2631','389',103004.52,104218.07,1198.55,195363.65,0.00,0.00,15.00,0.00,0.00),('1','167','885','196169',3828775,'2632','389',54542.01,55472.01,920.00,149960.00,0.00,0.00,10.00,0.00,0.00),('1','167','886','196169',3828776,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196169',3828777,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196169',3828778,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196169',3828779,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196169',3828780,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196169',3828781,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196169',3828782,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196169',3828783,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196169',3828784,'2641','390',440692.64,443022.49,2329.85,605761.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196169',3828785,'2642','390',282964.71,284402.31,1437.60,373776.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196169',3828786,'2643','390',470495.31,470873.40,378.09,98303.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','196169',3828787,'2644','390',371452.58,371452.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196169',3828788,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196169',3828789,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828884,'2605','389',96488.99,96488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828885,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828886,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828887,'2608','389',51136.31,51136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828888,'2609','389',89252.16,89252.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196173',3828889,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828890,'2611','389',156644.58,158252.85,1608.27,262148.01,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828891,'2612','389',239877.92,241496.04,1618.12,263753.56,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828892,'2613','389',92497.47,92497.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828893,'2614','389',145868.55,147439.55,1571.00,256073.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828894,'2615','389',78295.79,79132.21,836.42,136336.46,0.00,0.00,0.00,0.00,0.00),('1','167','881','196173',3828895,'2616','389',123922.93,125255.22,1332.29,217163.27,0.00,0.00,0.00,0.00,0.00),('1','167','882','196173',3828896,'2617','389',180857.82,181726.27,868.45,141557.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','196173',3828897,'2618','389',100121.51,101276.25,1154.74,188222.62,0.00,0.00,0.00,0.00,0.00),('1','167','882','196173',3828898,'2619','389',170049.29,170978.06,928.77,151389.51,0.00,0.00,0.00,0.00,0.00),('1','167','882','196173',3828899,'2620','389',125556.52,125556.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196173',3828900,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196173',3828901,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196173',3828902,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196173',3828903,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196173',3828904,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196173',3828905,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196173',3828906,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196173',3828907,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196173',3828908,'2629','389',93879.65,95160.18,1280.53,208726.39,0.00,0.00,0.00,0.00,0.00),('1','167','885','196173',3828909,'2630','389',44085.78,45062.97,977.19,159281.97,0.00,0.00,0.00,0.00,0.00),('1','167','885','196173',3828910,'2631','389',104218.07,105426.45,1207.85,196879.55,0.00,0.00,0.53,0.00,0.00),('1','167','885','196173',3828911,'2632','389',55472.01,56193.11,721.10,117539.30,0.00,0.00,0.00,0.00,0.00),('1','167','886','196173',3828912,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196173',3828913,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196173',3828914,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196173',3828915,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196173',3828916,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196173',3828917,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196173',3828918,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196173',3828919,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196173',3828920,'2641','390',443022.49,443780.16,757.67,196994.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','196173',3828921,'2642','390',284402.31,285499.84,1097.53,285357.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196173',3828922,'2643','390',470873.40,472021.61,1148.21,298534.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196173',3828923,'2644','390',371452.58,371821.05,368.47,95802.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','196173',3828924,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196173',3828925,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828956,'2605','389',96488.99,96488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828957,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828958,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828959,'2608','389',51136.31,51136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828960,'2609','389',89252.16,89252.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196175',3828961,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196175',3828962,'2611','389',158252.85,158252.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196175',3828963,'2612','389',241496.04,243390.65,1884.61,307191.43,0.00,0.00,10.00,0.00,0.00),('1','167','881','196175',3828964,'2613','389',92497.47,93841.18,1333.71,217394.73,0.00,0.00,10.00,0.00,0.00),('1','167','881','196175',3828965,'2614','389',147439.55,148388.19,938.64,152998.32,0.00,0.00,10.00,0.00,0.00),('1','167','881','196175',3828966,'2615','389',79132.21,81251.83,2109.62,343868.06,0.00,0.00,10.00,0.00,0.00),('1','167','881','196175',3828967,'2616','389',125255.22,126215.80,950.58,154944.54,0.00,0.00,10.00,0.00,0.00),('1','167','882','196175',3828968,'2617','389',181726.27,182620.05,883.78,144056.14,0.00,0.00,10.00,0.00,0.00),('1','167','882','196175',3828969,'2618','389',101276.25,102144.39,858.14,139876.82,0.00,0.00,10.00,0.00,0.00),('1','167','882','196175',3828970,'2619','389',170978.06,172398.51,1410.45,229903.35,0.00,0.00,10.00,0.00,0.00),('1','167','882','196175',3828971,'2620','389',125556.52,125556.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196175',3828972,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196175',3828973,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196175',3828974,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196175',3828975,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196175',3828976,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196175',3828977,'2626','389',115483.66,115483.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196175',3828978,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196175',3828979,'2628','389',142405.28,142405.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196175',3828980,'2629','389',95160.18,95980.27,810.09,132044.67,0.00,0.00,10.00,0.00,0.00),('1','167','885','196175',3828981,'2630','389',45062.97,45890.41,817.44,133242.72,0.00,0.00,10.00,0.00,0.00),('1','167','885','196175',3828982,'2631','389',105426.45,106367.60,934.48,152320.24,0.00,0.00,6.67,0.00,0.00),('1','167','885','196175',3828983,'2632','389',56193.11,56868.98,675.87,110166.81,0.00,0.00,0.00,0.00,0.00),('1','167','886','196175',3828984,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196175',3828985,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196175',3828986,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196175',3828987,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196175',3828988,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196175',3828989,'2638','389',202282.13,202282.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196175',3828990,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196175',3828991,'2640','389',150826.50,150826.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196175',3828992,'2641','390',443780.16,444774.39,994.23,258499.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196175',3828993,'2642','390',285499.84,285750.61,250.77,65200.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196175',3828994,'2643','390',472021.61,473526.19,1504.58,391190.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196175',3828995,'2644','390',371821.05,372628.29,807.24,209882.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','196175',3828996,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196175',3828997,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829028,'2605','389',96488.99,96488.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829029,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829030,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829031,'2608','389',51136.31,51136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829032,'2609','389',89252.16,89252.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196178',3829033,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829034,'2611','389',158252.85,159809.29,1556.44,253699.72,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829035,'2612','389',243390.65,244655.24,1264.59,206128.17,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829036,'2613','389',93841.18,95245.52,1404.34,228907.42,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829037,'2614','389',148388.19,149556.57,1168.38,190445.94,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829038,'2615','389',81251.83,82160.90,909.07,148178.41,0.00,0.00,0.00,0.00,0.00),('1','167','881','196178',3829039,'2616','389',126215.80,126922.44,706.64,115182.32,0.00,0.00,0.00,0.00,0.00),('1','167','882','196178',3829040,'2617','389',182620.05,183255.36,635.31,103555.53,0.00,0.00,0.00,0.00,0.00),('1','167','882','196178',3829041,'2618','389',102144.39,102625.72,481.33,78456.79,0.00,0.00,0.00,0.00,0.00),('1','167','882','196178',3829042,'2619','389',172398.51,172842.81,444.30,72420.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','196178',3829043,'2620','389',125556.52,126212.33,655.81,106897.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','196178',3829044,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196178',3829045,'2622','389',127275.20,127275.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196178',3829046,'2623','389',136726.32,136726.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196178',3829047,'2624','389',56597.17,56597.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196178',3829048,'2625','389',163153.23,163153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196178',3829049,'2626','389',115483.66,115840.87,357.21,58225.23,0.00,0.00,0.00,0.00,0.00),('1','167','884','196178',3829050,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196178',3829051,'2628','389',142405.28,142575.21,169.93,27698.59,0.00,0.00,0.00,0.00,0.00),('1','167','885','196178',3829052,'2629','389',95980.27,97089.91,1109.64,180871.32,0.00,0.00,0.00,0.00,0.00),('1','167','885','196178',3829053,'2630','389',45890.41,46758.35,867.94,141474.22,0.00,0.00,0.00,0.00,0.00),('1','167','885','196178',3829054,'2631','389',106367.60,107019.07,651.47,106189.61,0.00,0.00,0.00,0.00,0.00),('1','167','885','196178',3829055,'2632','389',56868.98,57486.51,617.53,100657.39,0.00,0.00,0.00,0.00,0.00),('1','167','886','196178',3829056,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196178',3829057,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196178',3829058,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196178',3829059,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196178',3829060,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196178',3829061,'2638','389',202282.13,203102.65,820.30,133708.90,0.00,0.00,0.22,0.00,0.00),('1','167','887','196178',3829062,'2639','389',160228.79,160228.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196178',3829063,'2640','389',150826.50,151515.78,689.28,112352.64,0.00,0.00,0.00,0.00,0.00),('1','167','888','196178',3829064,'2641','390',444774.39,445772.10,997.71,259404.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','196178',3829065,'2642','390',285750.61,286197.89,447.28,116292.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196178',3829066,'2643','390',473526.19,476048.17,2521.98,655714.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196178',3829067,'2644','390',372628.29,372826.87,198.58,51630.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','196178',3829068,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196178',3829069,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829115,'2605','389',96488.99,97214.93,725.94,118328.22,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829116,'2606','389',90797.79,90797.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829117,'2607','389',136994.15,136994.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829118,'2608','389',51136.31,51487.80,351.49,57292.87,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829119,'2609','389',89252.16,89561.69,309.53,50453.39,0.00,0.00,0.00,0.00,0.00),('1','167','880','196182',3829120,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829121,'2611','389',159809.29,160560.49,751.20,122445.60,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829122,'2612','389',244655.24,245452.87,797.63,130013.69,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829123,'2613','389',95245.52,95245.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829124,'2614','389',149556.57,150028.60,472.03,76940.89,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829125,'2615','389',82160.90,82772.42,611.52,99677.76,0.00,0.00,0.00,0.00,0.00),('1','167','881','196182',3829126,'2616','389',126922.44,126922.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196182',3829127,'2617','389',183255.36,184790.97,1535.61,250304.43,0.00,0.00,0.00,0.00,0.00),('1','167','882','196182',3829128,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196182',3829129,'2619','389',172842.81,172842.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196182',3829130,'2620','389',126212.33,126728.62,516.29,84155.27,0.00,0.00,0.00,0.00,0.00),('1','167','883','196182',3829131,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196182',3829132,'2622','389',127275.20,127770.49,495.29,80732.27,0.00,0.00,0.00,0.00,0.00),('1','167','883','196182',3829133,'2623','389',136726.32,137054.53,328.21,53498.23,0.00,0.00,0.00,0.00,0.00),('1','167','883','196182',3829134,'2624','389',56597.17,56867.11,269.94,44000.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','196182',3829135,'2625','389',163153.23,164272.98,1119.75,182519.25,0.00,0.00,0.00,0.00,0.00),('1','167','884','196182',3829136,'2626','389',115840.87,116722.32,881.45,143676.35,0.00,0.00,0.00,0.00,0.00),('1','167','884','196182',3829137,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196182',3829138,'2628','389',142575.21,143187.29,612.08,99769.04,0.00,0.00,0.00,0.00,0.00),('1','167','885','196182',3829139,'2629','389',97089.91,97477.16,387.25,63121.75,0.00,0.00,0.00,0.00,0.00),('1','167','885','196182',3829140,'2630','389',46758.35,47290.98,532.63,86818.69,0.00,0.00,0.00,0.00,0.00),('1','167','885','196182',3829141,'2631','389',107019.07,107490.97,471.90,76919.70,0.00,0.00,0.00,0.00,0.00),('1','167','885','196182',3829142,'2632','389',57486.51,58008.46,521.95,85077.85,0.00,0.00,0.00,0.00,0.00),('1','167','886','196182',3829143,'2633','389',81179.57,81179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196182',3829144,'2634','389',71983.49,71983.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196182',3829145,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196182',3829146,'2636','389',40915.64,40915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196182',3829147,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196182',3829148,'2638','389',203102.65,203971.98,869.33,141700.79,0.00,0.00,0.00,0.00,0.00),('1','167','887','196182',3829149,'2639','389',160228.79,161050.37,821.58,133917.54,0.00,0.00,0.00,0.00,0.00),('1','167','887','196182',3829150,'2640','389',151515.78,151945.77,429.99,70088.37,0.00,0.00,0.00,0.00,0.00),('1','167','888','196182',3829151,'2641','390',445772.10,446471.33,699.23,181799.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196182',3829152,'2642','390',286197.89,288097.40,1899.51,493872.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196182',3829153,'2643','390',476048.17,477277.99,1229.82,319753.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196182',3829154,'2644','390',372826.87,373658.49,831.62,216221.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','196182',3829155,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196182',3829156,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831092,'2605','389',97214.93,97214.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831093,'2606','389',90797.79,91322.73,524.94,85565.22,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831094,'2607','389',136994.15,137751.21,757.06,123400.78,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831095,'2608','389',51487.80,51487.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831096,'2609','389',89561.69,89787.66,225.97,36833.11,0.00,0.00,0.00,0.00,0.00),('1','167','880','196299',3831097,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831098,'2611','389',160560.49,161613.92,1053.43,171709.09,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831099,'2612','389',245452.87,246290.88,838.01,136595.63,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831100,'2613','389',95245.52,95245.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831101,'2614','389',150028.60,150938.37,909.77,148292.51,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831102,'2615','389',82772.42,82796.66,24.24,3951.12,0.00,0.00,0.00,0.00,0.00),('1','167','881','196299',3831103,'2616','389',126922.44,127431.87,509.43,83037.09,0.00,0.00,0.00,0.00,0.00),('1','167','882','196299',3831104,'2617','389',184790.97,185187.99,397.02,64714.26,0.00,0.00,0.00,0.00,0.00),('1','167','882','196299',3831105,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196299',3831106,'2619','389',172842.81,173193.59,350.78,57177.14,0.00,0.00,0.00,0.00,0.00),('1','167','882','196299',3831107,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196299',3831108,'2621','389',32828.35,32828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196299',3831109,'2622','389',127770.49,128378.86,608.37,99164.31,0.00,0.00,0.00,0.00,0.00),('1','167','883','196299',3831110,'2623','389',137054.53,137507.11,452.58,73770.54,0.00,0.00,0.00,0.00,0.00),('1','167','883','196299',3831111,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196299',3831112,'2625','389',164272.98,164809.46,536.48,87446.24,0.00,0.00,0.00,0.00,0.00),('1','167','884','196299',3831113,'2626','389',116722.32,117337.77,615.45,100318.35,0.00,0.00,0.00,0.00,0.00),('1','167','884','196299',3831114,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196299',3831115,'2628','389',143187.29,143855.77,668.48,108962.24,0.00,0.00,0.00,0.00,0.00),('1','167','885','196299',3831116,'2629','389',97477.16,97905.28,428.12,69783.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','196299',3831117,'2630','389',47290.98,47566.86,275.88,44968.44,0.00,0.00,0.00,0.00,0.00),('1','167','885','196299',3831118,'2631','389',107490.97,107792.79,301.82,49196.66,0.00,0.00,0.00,0.00,0.00),('1','167','885','196299',3831119,'2632','389',58008.46,58494.71,486.25,79258.75,0.00,0.00,0.00,0.00,0.00),('1','167','886','196299',3831120,'2633','389',81179.57,81224.28,44.71,7287.73,0.00,0.00,0.00,0.00,0.00),('1','167','886','196299',3831121,'2634','389',71983.49,72024.22,40.73,6638.99,0.00,0.00,0.00,0.00,0.00),('1','167','886','196299',3831122,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196299',3831123,'2636','389',40915.64,41092.26,176.62,28789.06,0.00,0.00,0.00,0.00,0.00),('1','167','887','196299',3831124,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196299',3831125,'2638','389',203971.98,205162.74,1190.76,194093.88,0.00,0.00,0.00,0.00,0.00),('1','167','887','196299',3831126,'2639','389',161050.37,162135.38,1085.01,176856.63,0.00,0.00,0.00,0.00,0.00),('1','167','887','196299',3831127,'2640','389',151945.77,152752.81,807.04,131547.52,0.00,0.00,0.00,0.00,0.00),('1','167','888','196299',3831128,'2641','390',446471.33,448234.22,1762.89,458351.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','196299',3831129,'2642','390',288097.40,290051.33,1953.93,508021.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196299',3831130,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196299',3831131,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196299',3831132,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196299',3831133,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834572,'2605','389',97214.93,97214.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834573,'2606','389',91322.73,91872.16,549.43,89557.09,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834574,'2607','389',137751.21,138431.26,680.05,110848.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834575,'2608','389',51487.80,51487.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834576,'2609','389',89787.66,90306.10,518.44,84505.72,0.00,0.00,0.00,0.00,0.00),('1','167','880','196495',3834577,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834578,'2611','389',161613.92,162705.22,1091.30,177881.90,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834579,'2612','389',246290.88,246290.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834580,'2613','389',95245.52,95245.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834581,'2614','389',150938.37,151575.85,637.48,103909.24,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834582,'2615','389',82796.66,82796.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196495',3834583,'2616','389',127431.87,128129.44,697.57,113703.91,0.00,0.00,0.00,0.00,0.00),('1','167','882','196495',3834584,'2617','389',185187.99,185673.79,485.80,79185.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','196495',3834585,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196495',3834586,'2619','389',173193.59,173467.62,274.03,44666.89,0.00,0.00,0.00,0.00,0.00),('1','167','882','196495',3834587,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196495',3834588,'2621','389',32828.35,33663.48,835.13,136126.19,0.00,0.00,0.00,0.00,0.00),('1','167','883','196495',3834589,'2622','389',128378.86,129077.75,698.89,113919.07,0.00,0.00,0.00,0.00,0.00),('1','167','883','196495',3834590,'2623','389',137507.11,138121.51,614.40,100147.20,0.00,0.00,0.00,0.00,0.00),('1','167','883','196495',3834591,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196495',3834592,'2625','389',164809.46,165987.75,1178.29,192061.27,0.00,0.00,0.00,0.00,0.00),('1','167','884','196495',3834593,'2626','389',117337.77,117337.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196495',3834594,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196495',3834595,'2628','389',143855.77,144671.36,815.59,132941.17,0.00,0.00,0.00,0.00,0.00),('1','167','885','196495',3834596,'2629','389',97905.28,98460.37,555.09,90479.67,0.00,0.00,0.00,0.00,0.00),('1','167','885','196495',3834597,'2630','389',47566.86,47566.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196495',3834598,'2631','389',107792.79,108360.09,567.30,92469.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','196495',3834599,'2632','389',58494.71,58494.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196495',3834600,'2633','389',81224.28,81224.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196495',3834601,'2634','389',72024.22,72974.93,950.71,154965.73,0.00,0.00,0.00,0.00,0.00),('1','167','886','196495',3834602,'2635','389',79027.44,79027.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196495',3834603,'2636','389',41092.26,41903.64,811.38,132254.94,0.00,0.00,0.00,0.00,0.00),('1','167','887','196495',3834604,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196495',3834605,'2638','389',205162.74,206414.04,1251.30,203961.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','196495',3834606,'2639','389',162135.38,162910.88,775.50,126406.50,0.00,0.00,0.00,0.00,0.00),('1','167','887','196495',3834607,'2640','389',152752.81,152752.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196495',3834608,'2641','390',448234.22,449496.47,1262.25,328185.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','196495',3834609,'2642','390',290051.33,292459.36,2408.03,626087.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','196495',3834610,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196495',3834611,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196495',3834612,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196495',3834613,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836735,'2605','389',97214.93,97552.31,337.38,54992.94,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836736,'2606','389',91872.16,91872.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836737,'2607','389',138431.26,138431.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836738,'2608','389',51487.80,51879.27,391.47,63809.61,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836739,'2609','389',90306.10,90919.06,612.96,99912.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','196608',3836740,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836741,'2611','389',162705.22,162705.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836742,'2612','389',246290.88,248431.92,2141.04,348989.52,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836743,'2613','389',95245.52,95898.84,653.32,106491.16,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836744,'2614','389',151575.85,152604.16,1028.31,167614.53,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836745,'2615','389',82796.66,82796.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196608',3836746,'2616','389',128129.44,128426.56,297.12,48430.56,0.00,0.00,0.00,0.00,0.00),('1','167','882','196608',3836747,'2617','389',185673.79,185903.22,229.43,37397.09,0.00,0.00,0.00,0.00,0.00),('1','167','882','196608',3836748,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196608',3836749,'2619','389',173467.62,173835.42,367.80,59951.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','196608',3836750,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196608',3836751,'2621','389',33663.48,33663.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196608',3836752,'2622','389',129077.75,129615.54,537.79,87659.77,0.00,0.00,0.00,0.00,0.00),('1','167','883','196608',3836753,'2623','389',138121.51,138653.36,531.85,86691.55,0.00,0.00,0.00,0.00,0.00),('1','167','883','196608',3836754,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196608',3836755,'2625','389',165987.75,166841.15,853.40,139104.20,0.00,0.00,0.00,0.00,0.00),('1','167','884','196608',3836756,'2626','389',117337.77,118045.14,707.37,115301.31,0.00,0.00,0.00,0.00,0.00),('1','167','884','196608',3836757,'2627','389',82360.90,82360.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196608',3836758,'2628','389',144671.36,145154.53,483.17,78756.71,0.00,0.00,0.00,0.00,0.00),('1','167','885','196608',3836759,'2629','389',98460.37,98848.97,388.60,63341.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','196608',3836760,'2630','389',47566.86,47983.64,416.78,67935.14,0.00,0.00,0.00,0.00,0.00),('1','167','885','196608',3836761,'2631','389',108360.09,108850.68,490.59,79966.17,0.00,0.00,0.00,0.00,0.00),('1','167','885','196608',3836762,'2632','389',58494.71,58991.47,496.76,80971.88,0.00,0.00,0.00,0.00,0.00),('1','167','886','196608',3836763,'2633','389',81224.28,81707.71,483.43,78799.09,0.00,0.00,0.00,0.00,0.00),('1','167','886','196608',3836764,'2634','389',72974.93,73387.52,412.59,67252.17,0.00,0.00,0.00,0.00,0.00),('1','167','886','196608',3836765,'2635','389',79027.44,79527.01,499.57,81429.91,0.00,0.00,0.00,0.00,0.00),('1','167','886','196608',3836766,'2636','389',41903.64,41903.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196608',3836767,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196608',3836768,'2638','389',206414.04,207652.49,1238.45,201867.35,0.00,0.00,0.00,0.00,0.00),('1','167','887','196608',3836769,'2639','389',162910.88,162910.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196608',3836770,'2640','389',152752.81,153591.03,838.22,136629.86,0.00,0.00,0.00,0.00,0.00),('1','167','888','196608',3836771,'2641','390',449496.47,451292.70,1796.23,467019.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196608',3836772,'2642','390',292459.36,294406.32,1946.96,506209.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196608',3836773,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196608',3836774,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196608',3836775,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196608',3836776,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838590,'2605','389',97552.31,98319.15,766.84,124994.92,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838591,'2606','389',91872.16,91872.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838592,'2607','389',138431.26,139003.30,572.04,93242.52,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838593,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838594,'2609','389',90919.06,91252.23,333.17,54306.71,0.00,0.00,0.00,0.00,0.00),('1','167','880','196724',3838595,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838596,'2611','389',162705.22,163833.96,1128.74,183984.62,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838597,'2612','389',248431.92,249755.90,1323.98,215808.74,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838598,'2613','389',95898.84,95898.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838599,'2614','389',152604.16,152604.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838600,'2615','389',82796.66,82796.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196724',3838601,'2616','389',128426.56,129164.97,738.41,120360.83,0.00,0.00,0.00,0.00,0.00),('1','167','882','196724',3838602,'2617','389',185903.22,186521.01,617.79,100699.77,0.00,0.00,0.00,0.00,0.00),('1','167','882','196724',3838603,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196724',3838604,'2619','389',173835.42,173835.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196724',3838605,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196724',3838606,'2621','389',33663.48,33663.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196724',3838607,'2622','389',129615.54,130256.92,641.38,104544.94,0.00,0.00,0.00,0.00,0.00),('1','167','883','196724',3838608,'2623','389',138653.36,139524.54,871.18,142002.34,0.00,0.00,0.00,0.00,0.00),('1','167','883','196724',3838609,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196724',3838610,'2625','389',166841.15,167636.61,795.46,129659.98,0.00,0.00,0.00,0.00,0.00),('1','167','884','196724',3838611,'2626','389',118045.14,118045.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196724',3838612,'2627','389',82360.90,82759.94,399.04,65043.52,0.00,0.00,0.00,0.00,0.00),('1','167','884','196724',3838613,'2628','389',145154.53,145659.56,505.03,82319.89,0.00,0.00,0.00,0.00,0.00),('1','167','885','196724',3838614,'2629','389',98848.97,98848.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196724',3838615,'2630','389',47983.64,47983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196724',3838616,'2631','389',108850.68,109421.36,570.68,93020.84,0.00,0.00,0.00,0.00,0.00),('1','167','885','196724',3838617,'2632','389',58991.47,58991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196724',3838618,'2633','389',81707.71,81707.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196724',3838619,'2634','389',73387.52,74194.55,807.03,131545.89,0.00,0.00,0.00,0.00,0.00),('1','167','886','196724',3838620,'2635','389',79527.01,80436.46,903.45,147262.35,0.00,0.00,6.00,0.00,0.00),('1','167','886','196724',3838621,'2636','389',41903.64,41903.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196724',3838622,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196724',3838623,'2638','389',207652.49,208500.74,848.25,138264.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','196724',3838624,'2639','389',162910.88,163910.75,999.87,162978.81,0.00,0.00,0.00,0.00,0.00),('1','167','887','196724',3838625,'2640','389',153591.03,154331.04,740.01,120621.63,0.00,0.00,0.00,0.00,0.00),('1','167','888','196724',3838626,'2641','390',451292.70,453231.26,1938.56,504025.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','196724',3838627,'2642','390',294406.32,295097.12,690.80,179608.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196724',3838628,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196724',3838629,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196724',3838630,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196724',3838631,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840492,'2605','389',98319.15,98621.60,302.45,49299.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840493,'2606','389',91872.16,91872.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840494,'2607','389',139003.30,139346.53,343.23,55946.49,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840495,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840496,'2609','389',91252.23,91529.02,276.79,45116.77,0.00,0.00,0.00,0.00,0.00),('1','167','880','196822',3840497,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840498,'2611','389',163833.96,164820.34,986.38,160779.94,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840499,'2612','389',249755.90,250580.63,824.73,134430.99,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840500,'2613','389',95898.84,95898.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840501,'2614','389',152604.16,153071.14,466.98,76117.74,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840502,'2615','389',82796.66,83106.76,310.10,50546.30,0.00,0.00,0.00,0.00,0.00),('1','167','881','196822',3840503,'2616','389',129164.97,129583.64,418.67,68243.21,0.00,0.00,0.00,0.00,0.00),('1','167','882','196822',3840504,'2617','389',186521.01,186947.61,426.60,69535.80,0.00,0.00,0.00,0.00,0.00),('1','167','882','196822',3840505,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196822',3840506,'2619','389',173835.42,174096.58,261.16,42569.08,0.00,0.00,0.00,0.00,0.00),('1','167','882','196822',3840507,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196822',3840508,'2621','389',33663.48,33663.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196822',3840509,'2622','389',130256.92,130533.66,276.74,45108.62,0.00,0.00,0.00,0.00,0.00),('1','167','883','196822',3840510,'2623','389',139524.54,139637.21,112.67,18365.21,0.00,0.00,0.00,0.00,0.00),('1','167','883','196822',3840511,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196822',3840512,'2625','389',167636.61,167636.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196822',3840513,'2626','389',118045.14,118840.88,795.74,129705.62,0.00,0.00,0.00,0.00,0.00),('1','167','884','196822',3840514,'2627','389',82759.94,83056.97,297.03,48415.89,0.00,0.00,0.00,0.00,0.00),('1','167','884','196822',3840515,'2628','389',145659.56,145940.71,281.15,45827.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','196822',3840516,'2629','389',98848.97,99120.11,271.14,44195.82,0.00,0.00,0.00,0.00,0.00),('1','167','885','196822',3840517,'2630','389',47983.64,48221.24,237.60,38728.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','196822',3840518,'2631','389',109421.36,109928.74,507.38,82702.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','196822',3840519,'2632','389',58991.47,58991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196822',3840520,'2633','389',81707.71,81707.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196822',3840521,'2634','389',74194.55,74335.23,140.68,22930.84,0.00,0.00,0.00,0.00,0.00),('1','167','886','196822',3840522,'2635','389',80436.46,80716.16,279.70,45591.10,0.00,0.00,0.00,0.00,0.00),('1','167','886','196822',3840523,'2636','389',41903.64,42145.39,241.75,39405.25,0.00,0.00,0.00,0.00,0.00),('1','167','887','196822',3840524,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196822',3840525,'2638','389',208500.74,209172.41,671.67,109482.21,0.00,0.00,0.00,0.00,0.00),('1','167','887','196822',3840526,'2639','389',163910.75,163910.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196822',3840527,'2640','389',154331.04,154795.55,464.51,75715.13,0.00,0.00,0.00,0.00,0.00),('1','167','888','196822',3840528,'2641','390',453231.26,458883.64,5652.38,1469618.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','196822',3840529,'2642','390',295097.12,299421.68,4324.56,1124385.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','196822',3840530,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196822',3840531,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196822',3840532,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196822',3840533,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196875',3841415,'2605','389',98621.60,98907.68,276.08,45001.04,0.00,0.00,10.00,0.00,0.00),('1','167','880','196875',3841416,'2606','389',91872.16,91872.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196875',3841417,'2607','389',139346.53,139678.75,332.22,54151.86,0.00,0.00,0.00,0.00,0.00),('1','167','880','196875',3841418,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','196875',3841419,'2609','389',91529.02,91710.25,171.23,27910.49,0.00,0.00,10.00,0.00,0.00),('1','167','880','196875',3841420,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196875',3841421,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196875',3841422,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196875',3841423,'2613','389',95898.84,95898.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196875',3841424,'2614','389',153071.14,153907.02,825.88,134618.44,0.00,0.00,10.00,0.00,0.00),('1','167','881','196875',3841425,'2615','389',83106.76,83106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','196875',3841426,'2616','389',129583.64,130594.91,1011.27,164837.01,0.00,0.00,0.00,0.00,0.00),('1','167','882','196875',3841427,'2617','389',186947.61,187391.76,444.15,72396.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','196875',3841428,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','196875',3841429,'2619','389',174096.58,174388.24,281.66,45910.58,0.00,0.00,10.00,0.00,0.00),('1','167','882','196875',3841430,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196875',3841431,'2621','389',33663.48,33663.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','196875',3841432,'2622','389',130533.66,131142.65,598.99,97635.37,0.00,0.00,10.00,0.00,0.00),('1','167','883','196875',3841433,'2623','389',139637.21,140092.32,445.11,72553.09,0.00,0.00,10.00,0.00,0.00),('1','167','883','196875',3841434,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196875',3841435,'2625','389',167636.61,168559.72,923.11,150466.93,0.00,0.00,0.00,0.00,0.00),('1','167','884','196875',3841436,'2626','389',118840.88,118840.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196875',3841437,'2627','389',83056.97,83056.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','196875',3841438,'2628','389',145940.71,146745.78,795.07,129596.41,0.00,0.00,10.00,0.00,0.00),('1','167','885','196875',3841439,'2629','389',99120.11,99541.83,421.72,68740.36,0.00,0.00,0.00,0.00,0.00),('1','167','885','196875',3841440,'2630','389',48221.24,48221.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','196875',3841441,'2631','389',109928.74,110341.69,412.95,67310.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','196875',3841442,'2632','389',58991.47,58991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196875',3841443,'2633','389',81707.71,81707.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','196875',3841444,'2634','389',74335.23,75246.16,900.93,146851.59,0.00,0.00,10.00,0.00,0.00),('1','167','886','196875',3841445,'2635','389',80716.16,81042.05,325.89,53120.07,0.00,0.00,0.00,0.00,0.00),('1','167','886','196875',3841446,'2636','389',42145.39,42145.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196875',3841447,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196875',3841448,'2638','389',209172.41,210334.50,1152.09,187790.67,0.00,0.00,10.00,0.00,0.00),('1','167','887','196875',3841449,'2639','389',163910.75,163910.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','196875',3841450,'2640','389',154795.55,155323.44,527.89,86046.07,0.00,0.00,0.00,0.00,0.00),('1','167','888','196875',3841451,'2641','390',458883.64,459741.00,857.36,222913.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','196875',3841452,'2642','390',299421.68,301913.45,2491.77,647860.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','196875',3841453,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','196875',3841454,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196875',3841455,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','196875',3841456,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845228,'2605','389',98907.68,99147.10,239.42,39025.46,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845229,'2606','389',91872.16,91935.48,63.32,10321.16,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845230,'2607','389',139678.75,139812.78,134.03,21846.89,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845231,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845232,'2609','389',91710.25,91754.92,44.67,7281.21,0.00,0.00,0.00,0.00,0.00),('1','167','880','197095',3845233,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845234,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845235,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845236,'2613','389',95898.84,96391.28,492.44,80267.72,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845237,'2614','389',153907.02,154267.14,360.12,58699.56,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845238,'2615','389',83106.76,83106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197095',3845239,'2616','389',130594.91,130766.95,172.04,28042.52,0.00,0.00,0.00,0.00,0.00),('1','167','882','197095',3845240,'2617','389',187391.76,187566.02,174.26,28404.38,0.00,0.00,0.00,0.00,0.00),('1','167','882','197095',3845241,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197095',3845242,'2619','389',174388.24,174558.27,170.03,27714.89,0.00,0.00,0.00,0.00,0.00),('1','167','882','197095',3845243,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197095',3845244,'2621','389',33663.48,33755.35,91.87,14974.81,0.00,0.00,0.00,0.00,0.00),('1','167','883','197095',3845245,'2622','389',131142.65,131277.26,134.61,21941.43,0.00,0.00,0.00,0.00,0.00),('1','167','883','197095',3845246,'2623','389',140092.32,140162.83,70.51,11493.13,0.00,0.00,0.00,0.00,0.00),('1','167','883','197095',3845247,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197095',3845248,'2625','389',168559.72,168820.90,261.18,42572.34,0.00,0.00,0.00,0.00,0.00),('1','167','884','197095',3845249,'2626','389',118840.88,119162.01,321.13,52344.19,0.00,0.00,0.00,0.00,0.00),('1','167','884','197095',3845250,'2627','389',83056.97,83056.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197095',3845251,'2628','389',146745.78,147202.84,457.06,74500.78,0.00,0.00,0.00,0.00,0.00),('1','167','885','197095',3845252,'2629','389',99541.83,99742.74,200.91,32748.33,0.00,0.00,0.00,0.00,0.00),('1','167','885','197095',3845253,'2630','389',48221.24,48393.44,172.20,28068.60,0.00,0.00,0.00,0.00,0.00),('1','167','885','197095',3845254,'2631','389',110341.69,110626.44,284.75,46414.25,0.00,0.00,0.00,0.00,0.00),('1','167','885','197095',3845255,'2632','389',58991.47,58991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197095',3845256,'2633','389',81707.71,81707.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197095',3845257,'2634','389',75246.16,75246.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197095',3845258,'2635','389',81042.05,81221.81,179.76,29300.88,0.00,0.00,0.00,0.00,0.00),('1','167','886','197095',3845259,'2636','389',42145.39,42145.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197095',3845260,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197095',3845261,'2638','389',210334.50,210737.23,402.73,65644.99,0.00,0.00,0.00,0.00,0.00),('1','167','887','197095',3845262,'2639','389',163910.75,164338.51,427.76,69724.88,0.00,0.00,0.00,0.00,0.00),('1','167','887','197095',3845263,'2640','389',155323.44,155607.76,284.32,46344.16,0.00,0.00,0.00,0.00,0.00),('1','167','888','197095',3845264,'2641','390',459741.00,460417.54,676.54,175900.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','197095',3845265,'2642','390',301913.45,302613.45,700.00,182000.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197095',3845266,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197095',3845267,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197095',3845268,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197095',3845269,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846912,'2605','389',99147.10,99147.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846913,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846914,'2607','389',139812.78,140158.91,346.13,56419.19,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846915,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846916,'2609','389',91754.92,91985.61,230.69,37602.47,0.00,0.00,0.00,0.00,0.00),('1','167','880','197185',3846917,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846918,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846919,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846920,'2613','389',96391.28,96635.45,244.17,39799.71,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846921,'2614','389',154267.14,154824.96,557.82,90924.66,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846922,'2615','389',83106.76,83106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197185',3846923,'2616','389',130766.95,131144.45,377.50,61532.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','197185',3846924,'2617','389',187566.02,187837.52,271.50,44254.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','197185',3846925,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197185',3846926,'2619','389',174558.27,174924.04,365.77,59620.51,0.00,0.00,0.00,0.00,0.00),('1','167','882','197185',3846927,'2620','389',126728.62,126728.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197185',3846928,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197185',3846929,'2622','389',131277.26,131708.29,431.03,70257.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','197185',3846930,'2623','389',140162.83,140385.17,222.34,36241.42,0.00,0.00,0.00,0.00,0.00),('1','167','883','197185',3846931,'2624','389',56867.11,56867.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197185',3846932,'2625','389',168820.90,168820.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197185',3846933,'2626','389',119162.01,119162.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197185',3846934,'2627','389',83056.97,83056.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197185',3846935,'2628','389',147202.84,147734.13,531.29,86600.27,0.00,0.00,0.00,0.00,0.00),('1','167','885','197185',3846936,'2629','389',99742.74,99742.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197185',3846937,'2630','389',48393.44,48393.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197185',3846938,'2631','389',110626.44,110855.78,229.34,37382.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','197185',3846939,'2632','389',58991.47,58991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197185',3846940,'2633','389',81707.71,81837.58,129.87,21168.81,0.00,0.00,0.00,0.00,0.00),('1','167','886','197185',3846941,'2634','389',75246.16,75583.52,337.36,54989.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','197185',3846942,'2635','389',81221.81,81807.12,585.31,95405.53,0.00,0.00,0.00,0.00,0.00),('1','167','886','197185',3846943,'2636','389',42145.39,42145.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197185',3846944,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197185',3846945,'2638','389',210737.23,211469.39,732.16,119342.08,0.00,0.00,0.00,0.00,0.00),('1','167','887','197185',3846946,'2639','389',164338.51,164338.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197185',3846947,'2640','389',155607.76,156278.99,671.23,109410.49,0.00,0.00,0.00,0.00,0.00),('1','167','888','197185',3846948,'2641','390',460417.54,461462.55,1045.01,271702.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','197185',3846949,'2642','390',302613.45,302815.38,201.93,52501.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','197185',3846950,'2643','390',477277.99,477277.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197185',3846951,'2644','390',373658.49,373658.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197185',3846952,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197185',3846953,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851655,'2605','389',99147.10,99269.78,122.68,19996.84,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851656,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851657,'2607','389',140158.91,140316.10,157.19,25621.97,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851658,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851659,'2609','389',91985.61,92048.50,62.89,10251.07,0.00,0.00,0.00,0.00,0.00),('1','167','880','197469',3851660,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851661,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851662,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851663,'2613','389',96635.45,97224.67,589.22,96042.86,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851664,'2614','389',154824.96,155439.27,614.31,100132.53,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851665,'2615','389',83106.76,83508.15,401.39,65426.57,0.00,0.00,0.00,0.00,0.00),('1','167','881','197469',3851666,'2616','389',131144.45,131416.41,271.96,44329.48,0.00,0.00,0.00,0.00,0.00),('1','167','882','197469',3851667,'2617','389',187837.52,187952.34,114.82,18715.66,0.00,0.00,0.00,0.00,0.00),('1','167','882','197469',3851668,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197469',3851669,'2619','389',174924.04,174924.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197469',3851670,'2620','389',126728.62,126831.10,102.48,16704.24,0.00,0.00,0.00,0.00,0.00),('1','167','883','197469',3851671,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197469',3851672,'2622','389',131708.29,131976.43,268.14,43706.82,0.00,0.00,0.00,0.00,0.00),('1','167','883','197469',3851673,'2623','389',140385.17,140523.11,137.94,22484.22,0.00,0.00,0.00,0.00,0.00),('1','167','883','197469',3851674,'2624','389',56867.11,57010.05,142.94,23299.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','197469',3851675,'2625','389',168820.90,169423.58,602.68,98236.84,0.00,0.00,0.00,0.00,0.00),('1','167','884','197469',3851676,'2626','389',119162.01,119631.93,469.92,76596.96,0.00,0.00,0.00,0.00,0.00),('1','167','884','197469',3851677,'2627','389',83056.97,83056.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197469',3851678,'2628','389',147734.13,148319.43,585.30,95403.90,0.00,0.00,0.00,0.00,0.00),('1','167','885','197469',3851679,'2629','389',99742.74,100122.51,379.77,61902.51,0.00,0.00,0.00,0.00,0.00),('1','167','885','197469',3851680,'2630','389',48393.44,48393.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197469',3851681,'2631','389',110855.78,111336.00,480.22,78275.86,0.00,0.00,0.00,0.00,0.00),('1','167','885','197469',3851682,'2632','389',58991.47,59249.02,257.55,41980.65,0.00,0.00,0.00,0.00,0.00),('1','167','886','197469',3851683,'2633','389',81837.58,82159.42,321.84,52459.92,0.00,0.00,0.00,0.00,0.00),('1','167','886','197469',3851684,'2634','389',75583.52,75883.00,299.48,48815.24,0.00,0.00,0.00,0.00,0.00),('1','167','886','197469',3851685,'2635','389',81807.12,82054.03,246.91,40246.33,0.00,0.00,0.00,0.00,0.00),('1','167','886','197469',3851686,'2636','389',42145.39,42145.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197469',3851687,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197469',3851688,'2638','389',211469.39,212299.44,830.05,135298.15,0.00,0.00,0.00,0.00,0.00),('1','167','887','197469',3851689,'2639','389',164338.51,164338.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197469',3851690,'2640','389',156278.99,156777.48,498.49,81253.87,0.00,0.00,0.00,0.00,0.00),('1','167','888','197469',3851691,'2641','390',461462.55,461763.56,301.01,78262.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','197469',3851692,'2642','390',302815.38,303849.18,1033.80,268788.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197469',3851693,'2643','390',477277.99,478377.48,1099.49,285867.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','197469',3851694,'2644','390',373658.49,373928.95,270.46,70319.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','197469',3851695,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197469',3851696,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853497,'2605','389',99269.78,99697.44,427.66,69708.58,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853498,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853499,'2607','389',140316.10,140593.82,277.72,45268.36,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853500,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853501,'2609','389',92048.50,92405.59,357.09,58205.67,0.00,0.00,0.00,0.00,0.00),('1','167','880','197581',3853502,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853503,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853504,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853505,'2613','389',97224.67,97224.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853506,'2614','389',155439.27,156575.66,1136.39,185231.57,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853507,'2615','389',83508.15,83508.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197581',3853508,'2616','389',131416.41,131983.93,567.52,92505.76,0.00,0.00,0.00,0.00,0.00),('1','167','882','197581',3853509,'2617','389',187952.34,188215.82,263.48,42947.24,0.00,0.00,0.00,0.00,0.00),('1','167','882','197581',3853510,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197581',3853511,'2619','389',174924.04,175123.72,199.68,32547.84,0.00,0.00,0.00,0.00,0.00),('1','167','882','197581',3853512,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197581',3853513,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197581',3853514,'2622','389',131976.43,132508.44,532.01,86717.63,0.00,0.00,0.00,0.00,0.00),('1','167','883','197581',3853515,'2623','389',140523.11,140880.88,357.77,58316.51,0.00,0.00,0.00,0.00,0.00),('1','167','883','197581',3853516,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197581',3853517,'2625','389',169423.58,169423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197581',3853518,'2626','389',119631.93,120820.13,1188.20,193676.60,0.00,0.00,0.00,0.00,0.00),('1','167','884','197581',3853519,'2627','389',83056.97,83056.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197581',3853520,'2628','389',148319.43,148319.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197581',3853521,'2629','389',100122.51,100579.26,456.75,74450.25,0.00,0.00,0.00,0.00,0.00),('1','167','885','197581',3853522,'2630','389',48393.44,48393.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197581',3853523,'2631','389',111336.00,112056.57,720.57,117452.91,0.00,0.00,0.00,0.00,0.00),('1','167','885','197581',3853524,'2632','389',59249.02,59249.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197581',3853525,'2633','389',82159.42,82159.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197581',3853526,'2634','389',75883.00,76518.86,635.86,103645.18,0.00,0.00,0.00,0.00,0.00),('1','167','886','197581',3853527,'2635','389',82054.03,82225.04,171.01,27874.63,0.00,0.00,0.00,0.00,0.00),('1','167','886','197581',3853528,'2636','389',42145.39,42145.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197581',3853529,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197581',3853530,'2638','389',212299.44,212859.21,559.77,91242.51,0.00,0.00,0.00,0.00,0.00),('1','167','887','197581',3853531,'2639','389',164338.51,164714.28,375.77,61250.51,0.00,0.00,0.00,0.00,0.00),('1','167','887','197581',3853532,'2640','389',156777.48,157128.38,350.90,57196.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','197581',3853533,'2641','390',461763.56,464490.17,2726.61,708918.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','197581',3853534,'2642','390',303849.18,303849.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197581',3853535,'2643','390',478377.48,480966.49,2589.01,673142.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','197581',3853536,'2644','390',373928.95,374050.87,121.92,31699.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','197581',3853537,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197581',3853538,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853830,'2605','389',99697.44,100010.37,312.93,51007.59,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853831,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853832,'2607','389',140593.82,140593.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853833,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853834,'2609','389',92405.59,92610.68,205.09,33429.67,0.00,0.00,0.00,0.00,0.00),('1','167','880','197599',3853835,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853836,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853837,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853838,'2613','389',97224.67,97661.95,437.28,71276.64,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853839,'2614','389',156575.66,157097.37,521.71,85038.73,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853840,'2615','389',83508.15,83827.65,319.50,52078.50,0.00,0.00,0.00,0.00,0.00),('1','167','881','197599',3853841,'2616','389',131983.93,132334.39,350.46,57124.98,0.00,0.00,0.00,0.00,0.00),('1','167','882','197599',3853842,'2617','389',188215.82,188369.21,153.39,25002.57,0.00,0.00,0.00,0.00,0.00),('1','167','882','197599',3853843,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197599',3853844,'2619','389',175123.72,175309.99,186.27,30362.01,0.00,0.00,0.00,0.00,0.00),('1','167','882','197599',3853845,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197599',3853846,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197599',3853847,'2622','389',132508.44,132802.57,294.13,47943.19,0.00,0.00,0.00,0.00,0.00),('1','167','883','197599',3853848,'2623','389',140880.88,141060.43,179.55,29266.65,0.00,0.00,0.00,0.00,0.00),('1','167','883','197599',3853849,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197599',3853850,'2625','389',169423.58,170557.88,1134.30,184890.90,0.00,0.00,0.00,0.00,0.00),('1','167','884','197599',3853851,'2626','389',120820.13,121795.21,975.08,158938.04,0.00,0.00,0.00,0.00,0.00),('1','167','884','197599',3853852,'2627','389',83056.97,83488.22,431.25,70293.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','197599',3853853,'2628','389',148319.43,148626.47,307.04,50047.52,0.00,0.00,0.00,0.00,0.00),('1','167','885','197599',3853854,'2629','389',100579.26,100909.27,330.01,53791.63,0.00,0.00,0.00,0.00,0.00),('1','167','885','197599',3853855,'2630','389',48393.44,48397.73,4.29,699.27,0.00,0.00,0.00,0.00,0.00),('1','167','885','197599',3853856,'2631','389',112056.57,112415.40,358.83,58489.29,0.00,0.00,0.00,0.00,0.00),('1','167','885','197599',3853857,'2632','389',59249.02,59569.43,320.41,52226.83,0.00,0.00,0.00,0.00,0.00),('1','167','886','197599',3853858,'2633','389',82159.42,82392.71,233.29,38026.27,0.00,0.00,0.00,0.00,0.00),('1','167','886','197599',3853859,'2634','389',76518.86,76671.29,152.43,24846.09,0.00,0.00,0.00,0.00,0.00),('1','167','886','197599',3853860,'2635','389',82225.04,82482.10,257.06,41900.78,0.00,0.00,0.00,0.00,0.00),('1','167','886','197599',3853861,'2636','389',42145.39,42381.88,236.49,38547.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','197599',3853862,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197599',3853863,'2638','389',212859.21,213616.72,757.51,123474.13,0.00,0.00,0.00,0.00,0.00),('1','167','887','197599',3853864,'2639','389',164714.28,165654.33,940.05,153228.15,0.00,0.00,0.00,0.00,0.00),('1','167','887','197599',3853865,'2640','389',157128.38,157128.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','197599',3853866,'2641','390',464490.17,466526.56,2036.39,529461.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','197599',3853867,'2642','390',303849.18,303988.33,139.15,36179.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197599',3853868,'2643','390',480966.49,482327.84,1361.35,353951.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197599',3853869,'2644','390',374050.87,374165.85,114.98,29894.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','197599',3853870,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197599',3853871,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854414,'2605','389',100010.37,100010.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854415,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854416,'2607','389',140593.82,142521.30,1927.48,314179.24,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854417,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854418,'2609','389',92610.68,92884.34,273.66,44606.58,0.00,0.00,0.00,0.00,0.00),('1','167','880','197628',3854419,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854420,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854421,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854422,'2613','389',97661.95,97661.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854423,'2614','389',157097.37,158105.84,1008.47,164380.61,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854424,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197628',3854425,'2616','389',132334.39,132902.23,567.84,92557.92,0.00,0.00,0.00,0.00,0.00),('1','167','882','197628',3854426,'2617','389',188369.21,188718.04,348.83,56859.29,0.00,0.00,0.00,0.00,0.00),('1','167','882','197628',3854427,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197628',3854428,'2619','389',175309.99,175597.79,287.80,46911.40,0.00,0.00,0.00,0.00,0.00),('1','167','882','197628',3854429,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197628',3854430,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197628',3854431,'2622','389',132802.57,132802.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197628',3854432,'2623','389',141060.43,141374.81,314.38,51243.94,0.00,0.00,0.00,0.00,0.00),('1','167','883','197628',3854433,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197628',3854434,'2625','389',170557.88,170557.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197628',3854435,'2626','389',121795.21,122784.38,989.17,161234.71,0.00,0.00,0.00,0.00,0.00),('1','167','884','197628',3854436,'2627','389',83488.22,83488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197628',3854437,'2628','389',148626.47,149692.35,1065.88,173738.44,0.00,0.00,0.00,0.00,0.00),('1','167','885','197628',3854438,'2629','389',100909.27,101269.63,360.36,58738.68,0.00,0.00,0.00,0.00,0.00),('1','167','885','197628',3854439,'2630','389',48397.73,48397.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197628',3854440,'2631','389',112415.40,113433.32,1017.92,165920.96,0.00,0.00,0.00,0.00,0.00),('1','167','885','197628',3854441,'2632','389',59569.43,59569.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197628',3854442,'2633','389',82392.71,82859.26,466.55,76047.65,0.00,0.00,0.00,0.00,0.00),('1','167','886','197628',3854443,'2634','389',76671.29,76671.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197628',3854444,'2635','389',82482.10,82970.30,488.20,79576.60,0.00,0.00,0.00,0.00,0.00),('1','167','886','197628',3854445,'2636','389',42381.88,42381.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197628',3854446,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197628',3854447,'2638','389',213616.72,214637.55,1020.83,166395.29,0.00,0.00,0.00,0.00,0.00),('1','167','887','197628',3854448,'2639','389',165654.33,166412.62,758.29,123601.27,0.00,0.00,0.00,0.00,0.00),('1','167','887','197628',3854449,'2640','389',157128.38,157452.35,323.97,52807.11,0.00,0.00,0.00,0.00,0.00),('1','167','888','197628',3854450,'2641','390',466526.56,467166.21,639.65,166309.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','197628',3854451,'2642','390',303988.33,305181.93,1193.60,310336.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197628',3854452,'2643','390',482327.84,484097.67,1769.83,460155.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','197628',3854453,'2644','390',374165.85,374165.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197628',3854454,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197628',3854455,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854646,'2605','389',100010.37,100432.87,422.50,68867.50,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854647,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854648,'2607','389',142521.30,142926.10,404.80,65982.40,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854649,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854650,'2609','389',92884.34,93431.09,546.75,89120.25,0.00,0.00,0.00,0.00,0.00),('1','167','880','197639',3854651,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854652,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854653,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854654,'2613','389',97661.95,98815.94,1153.99,188100.37,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854655,'2614','389',158105.84,158105.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854656,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197639',3854657,'2616','389',132902.23,133594.86,692.63,112898.69,0.00,0.00,0.00,0.00,0.00),('1','167','882','197639',3854658,'2617','389',188718.04,188718.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197639',3854659,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197639',3854660,'2619','389',175597.79,175998.97,401.18,65392.34,0.00,0.00,0.00,0.00,0.00),('1','167','882','197639',3854661,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197639',3854662,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197639',3854663,'2622','389',132802.57,133256.52,453.95,73993.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','197639',3854664,'2623','389',141374.81,141810.27,435.46,70979.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','197639',3854665,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197639',3854666,'2625','389',170557.88,171378.91,821.03,133827.89,0.00,0.00,0.00,0.00,0.00),('1','167','884','197639',3854667,'2626','389',122784.38,122784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197639',3854668,'2627','389',83488.22,84085.26,597.04,97317.52,0.00,0.00,0.00,0.00,0.00),('1','167','884','197639',3854669,'2628','389',149692.35,150437.63,745.28,121480.64,0.00,0.00,0.00,0.00,0.00),('1','167','885','197639',3854670,'2629','389',101269.63,101619.17,349.54,56975.02,0.00,0.00,0.00,0.00,0.00),('1','167','885','197639',3854671,'2630','389',48397.73,48834.85,437.12,71250.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','197639',3854672,'2631','389',113433.32,113893.70,460.38,75041.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','197639',3854673,'2632','389',59569.43,60031.75,462.32,75358.16,0.00,0.00,0.00,0.00,0.00),('1','167','886','197639',3854674,'2633','389',82859.26,83484.64,625.38,101936.94,0.00,0.00,0.00,0.00,0.00),('1','167','886','197639',3854675,'2634','389',76671.29,76881.23,209.94,34220.22,0.00,0.00,0.00,0.00,0.00),('1','167','886','197639',3854676,'2635','389',82970.30,83195.20,224.90,36658.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','197639',3854677,'2636','389',42381.88,42578.42,196.54,32036.02,0.00,0.00,0.00,0.00,0.00),('1','167','887','197639',3854678,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197639',3854679,'2638','389',214637.55,215596.89,959.34,156372.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','197639',3854680,'2639','389',166412.62,166412.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197639',3854681,'2640','389',157452.35,158139.23,686.88,111961.44,0.00,0.00,0.00,0.00,0.00),('1','167','888','197639',3854682,'2641','390',467166.21,467856.22,690.01,179402.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','197639',3854683,'2642','390',305181.93,306169.25,987.32,256703.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','197639',3854684,'2643','390',484097.67,485994.99,1897.32,493303.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','197639',3854685,'2644','390',374165.85,374440.65,274.80,71448.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197639',3854686,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197639',3854687,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855295,'2605','389',100432.87,101090.30,657.43,107161.09,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855296,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855297,'2607','389',142926.10,142926.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855298,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855299,'2609','389',93431.09,93431.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197673',3855300,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855301,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855302,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855303,'2613','389',98815.94,98953.06,137.12,22350.56,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855304,'2614','389',158105.84,159111.84,1006.00,163978.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855305,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197673',3855306,'2616','389',133594.86,134584.85,989.99,161368.37,0.00,0.00,0.00,0.00,0.00),('1','167','882','197673',3855307,'2617','389',188718.04,189149.32,431.28,70298.64,0.00,0.00,0.00,0.00,0.00),('1','167','882','197673',3855308,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197673',3855309,'2619','389',175998.97,176936.11,937.14,152753.82,0.00,0.00,0.00,0.00,0.00),('1','167','882','197673',3855310,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197673',3855311,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197673',3855312,'2622','389',133256.52,134011.24,754.72,123019.36,0.00,0.00,0.00,0.00,0.00),('1','167','883','197673',3855313,'2623','389',141810.27,141810.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197673',3855314,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197673',3855315,'2625','389',171378.91,172817.94,1439.03,234561.89,0.00,0.00,0.00,0.00,0.00),('1','167','884','197673',3855316,'2626','389',122784.38,122784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197673',3855317,'2627','389',84085.26,84085.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197673',3855318,'2628','389',150437.63,151325.97,888.34,144799.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','197673',3855319,'2629','389',101619.17,102223.22,604.05,98460.15,0.00,0.00,0.00,0.00,0.00),('1','167','885','197673',3855320,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197673',3855321,'2631','389',113893.70,114490.46,596.76,97271.88,0.00,0.00,0.00,0.00,0.00),('1','167','885','197673',3855322,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197673',3855323,'2633','389',83484.64,83484.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197673',3855324,'2634','389',76881.23,77433.76,552.53,90062.39,0.00,0.00,0.00,0.00,0.00),('1','167','886','197673',3855325,'2635','389',83195.20,83195.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197673',3855326,'2636','389',42578.42,43070.73,492.31,80246.53,0.00,0.00,0.00,0.00,0.00),('1','167','887','197673',3855327,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197673',3855328,'2638','389',215596.89,216472.22,875.33,142678.63,0.00,0.00,0.00,0.00,0.00),('1','167','887','197673',3855329,'2639','389',166412.62,166412.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197673',3855330,'2640','389',158139.23,158976.30,837.07,136442.41,0.00,0.00,0.00,0.00,0.00),('1','167','888','197673',3855331,'2641','390',467856.22,469755.21,1898.99,493737.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','197673',3855332,'2642','390',306169.25,306169.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','197673',3855333,'2643','390',485994.99,487483.96,1488.97,387132.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','197673',3855334,'2644','390',374440.65,374440.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197673',3855335,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197673',3855336,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856389,'2605','389',101090.30,101090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856390,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856391,'2607','389',142926.10,143424.55,498.45,81247.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856392,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856393,'2609','389',93431.09,93431.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197744',3856394,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856395,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856396,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856397,'2613','389',98953.06,98953.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856398,'2614','389',159111.84,160243.33,1131.49,184432.87,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856399,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197744',3856400,'2616','389',134584.85,135312.28,727.43,118571.09,0.00,0.00,0.00,0.00,0.00),('1','167','882','197744',3856401,'2617','389',189149.32,189149.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197744',3856402,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197744',3856403,'2619','389',176936.11,177129.67,193.56,31550.28,0.00,0.00,0.00,0.00,0.00),('1','167','882','197744',3856404,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197744',3856405,'2621','389',33755.35,33755.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197744',3856406,'2622','389',134011.24,134595.29,584.05,95200.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','197744',3856407,'2623','389',141810.27,141810.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197744',3856408,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197744',3856409,'2625','389',172817.94,174665.78,1847.84,301197.92,0.00,0.00,0.00,0.00,0.00),('1','167','884','197744',3856410,'2626','389',122784.38,122784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197744',3856411,'2627','389',84085.26,85857.72,1771.94,288826.22,0.00,0.00,0.52,0.00,0.00),('1','167','884','197744',3856412,'2628','389',151325.97,151325.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197744',3856413,'2629','389',102223.22,103293.21,1069.99,174408.37,0.00,0.00,0.00,0.00,0.00),('1','167','885','197744',3856414,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197744',3856415,'2631','389',114490.46,115472.23,981.77,160028.51,0.00,0.00,0.00,0.00,0.00),('1','167','885','197744',3856416,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197744',3856417,'2633','389',83484.64,83484.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197744',3856418,'2634','389',77433.76,78155.49,721.73,117641.99,0.00,0.00,0.00,0.00,0.00),('1','167','886','197744',3856419,'2635','389',83195.20,83810.63,615.43,100315.09,0.00,0.00,0.00,0.00,0.00),('1','167','886','197744',3856420,'2636','389',43070.73,43070.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197744',3856421,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197744',3856422,'2638','389',216472.22,217411.30,939.08,153070.04,0.00,0.00,0.00,0.00,0.00),('1','167','887','197744',3856423,'2639','389',166412.62,167162.07,749.45,122160.35,0.00,0.00,0.00,0.00,0.00),('1','167','887','197744',3856424,'2640','389',158976.30,159723.96,747.66,121868.58,0.00,0.00,0.00,0.00,0.00),('1','167','888','197744',3856425,'2641','390',469755.21,471370.43,1615.22,419957.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','197744',3856426,'2642','390',306169.25,307065.77,896.52,233095.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','197744',3856427,'2643','390',487483.96,488728.64,1244.68,323616.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','197744',3856428,'2644','390',374440.65,374492.96,52.31,13600.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','197744',3856429,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197744',3856430,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859393,'2605','389',101090.30,101968.15,877.85,143089.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859394,'2606','389',91935.48,91935.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859395,'2607','389',143424.55,144080.87,656.32,106980.16,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859396,'2608','389',51879.27,51879.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859397,'2609','389',93431.09,93831.61,400.52,65284.76,0.00,0.00,0.00,0.00,0.00),('1','167','880','197911',3859398,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859399,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859400,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859401,'2613','389',98953.06,98953.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859402,'2614','389',160243.33,161069.02,825.69,134587.47,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859403,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','197911',3859404,'2616','389',135312.28,135597.10,284.82,46425.66,0.00,0.00,0.00,0.00,0.00),('1','167','882','197911',3859405,'2617','389',189149.32,189448.32,299.00,48737.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197911',3859406,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','197911',3859407,'2619','389',177129.67,177721.82,592.15,96520.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','197911',3859408,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','197911',3859409,'2621','389',33755.35,34360.21,604.86,98592.18,0.00,0.00,0.00,0.00,0.00),('1','167','883','197911',3859410,'2622','389',134595.29,135242.21,646.92,105447.96,0.00,0.00,0.00,0.00,0.00),('1','167','883','197911',3859411,'2623','389',141810.27,142197.73,387.46,63155.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','197911',3859412,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197911',3859413,'2625','389',174665.78,175183.33,517.55,84360.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','197911',3859414,'2626','389',122784.38,123575.33,790.95,128924.85,0.00,0.00,0.00,0.00,0.00),('1','167','884','197911',3859415,'2627','389',85857.72,85857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','197911',3859416,'2628','389',151325.97,151888.79,562.82,91739.66,0.00,0.00,0.00,0.00,0.00),('1','167','885','197911',3859417,'2629','389',103293.21,103808.58,515.37,84005.31,0.00,0.00,0.00,0.00,0.00),('1','167','885','197911',3859418,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','197911',3859419,'2631','389',115472.23,116122.61,650.38,106011.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','197911',3859420,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','197911',3859421,'2633','389',83484.64,83821.15,336.51,54851.13,0.00,0.00,0.00,0.00,0.00),('1','167','886','197911',3859422,'2634','389',78155.49,78562.39,406.90,66324.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','197911',3859423,'2635','389',83810.63,84369.51,558.88,91097.44,0.00,0.00,0.00,0.00,0.00),('1','167','886','197911',3859424,'2636','389',43070.73,43070.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197911',3859425,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197911',3859426,'2638','389',217411.30,218337.86,926.56,151029.28,0.00,0.00,0.00,0.00,0.00),('1','167','887','197911',3859427,'2639','389',167162.07,167162.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','197911',3859428,'2640','389',159723.96,160433.84,709.88,115710.44,0.00,0.00,0.00,0.00,0.00),('1','167','888','197911',3859429,'2641','390',471370.43,472738.22,1367.79,355625.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','197911',3859430,'2642','390',307065.77,307316.33,250.56,65145.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','197911',3859431,'2643','390',488728.64,490884.45,2155.81,560510.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','197911',3859432,'2644','390',374492.96,374492.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197911',3859433,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','197911',3859434,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861555,'2605','389',101968.15,101968.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861556,'2606','389',91935.48,92605.79,670.31,109260.53,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861557,'2607','389',144080.87,144080.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861558,'2608','389',51879.27,52379.08,499.81,81469.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861559,'2609','389',93831.61,94222.52,390.91,63718.33,0.00,0.00,0.00,0.00,0.00),('1','167','880','198023',3861560,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861561,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861562,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861563,'2613','389',98953.06,98953.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861564,'2614','389',161069.02,162330.30,1261.28,205588.64,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861565,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198023',3861566,'2616','389',135597.10,136427.77,830.67,135399.21,0.00,0.00,0.00,0.00,0.00),('1','167','882','198023',3861567,'2617','389',189448.32,189448.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198023',3861568,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198023',3861569,'2619','389',177721.82,177721.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198023',3861570,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198023',3861571,'2621','389',34360.21,35549.42,1189.21,193841.23,0.00,0.00,0.00,0.00,0.00),('1','167','883','198023',3861572,'2622','389',135242.21,135242.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198023',3861573,'2623','389',142197.73,142731.56,533.83,87014.29,0.00,0.00,0.00,0.00,0.00),('1','167','883','198023',3861574,'2624','389',57010.05,57010.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198023',3861575,'2625','389',175183.33,176295.74,1112.41,181322.83,0.00,0.00,0.00,0.00,0.00),('1','167','884','198023',3861576,'2626','389',123575.33,123575.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198023',3861577,'2627','389',85857.72,86615.66,757.94,123544.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','198023',3861578,'2628','389',151888.79,151888.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198023',3861579,'2629','389',103808.58,104488.12,679.54,110765.02,0.00,0.00,0.00,0.00,0.00),('1','167','885','198023',3861580,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198023',3861581,'2631','389',116122.61,117124.18,1001.57,163255.91,0.00,0.00,0.00,0.00,0.00),('1','167','885','198023',3861582,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198023',3861583,'2633','389',83821.15,83821.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198023',3861584,'2634','389',78562.39,79045.43,483.04,78735.52,0.00,0.00,0.00,0.00,0.00),('1','167','886','198023',3861585,'2635','389',84369.51,84806.95,437.44,71302.72,0.00,0.00,0.00,0.00,0.00),('1','167','886','198023',3861586,'2636','389',43070.73,43070.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198023',3861587,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198023',3861588,'2638','389',218337.86,219596.02,1258.16,205080.08,0.00,0.00,0.00,0.00,0.00),('1','167','887','198023',3861589,'2639','389',167162.07,167162.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198023',3861590,'2640','389',160433.84,161370.55,936.71,152683.73,0.00,0.00,0.00,0.00,0.00),('1','167','888','198023',3861591,'2641','390',472738.22,474063.12,1324.90,344474.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','198023',3861592,'2642','390',307316.33,307785.34,469.01,121942.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198023',3861593,'2643','390',490884.45,492227.60,1343.15,349219.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','198023',3861594,'2644','390',374492.96,374492.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198023',3861595,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198023',3861596,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863883,'2605','389',101968.15,101968.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863884,'2606','389',92605.79,93048.74,442.95,72200.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863885,'2607','389',144080.87,144671.44,590.57,96262.91,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863886,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863887,'2609','389',94222.52,94527.46,304.94,49705.22,0.00,0.00,0.00,0.00,0.00),('1','167','880','198170',3863888,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863889,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863890,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863891,'2613','389',98953.06,99444.90,491.84,80169.92,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863892,'2614','389',162330.30,163022.98,692.68,112906.84,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863893,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198170',3863894,'2616','389',136427.77,136927.46,499.69,81449.47,0.00,0.00,0.00,0.00,0.00),('1','167','882','198170',3863895,'2617','389',189448.32,189910.61,462.29,75353.27,0.00,0.00,0.00,0.00,0.00),('1','167','882','198170',3863896,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198170',3863897,'2619','389',177721.82,178059.72,337.90,55077.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','198170',3863898,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198170',3863899,'2621','389',35549.42,35549.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198170',3863900,'2622','389',135242.21,135794.02,551.81,89945.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','198170',3863901,'2623','389',142731.56,142859.75,128.19,20894.97,0.00,0.00,0.00,0.00,0.00),('1','167','883','198170',3863902,'2624','389',57010.05,57509.35,499.30,81385.90,0.00,0.00,0.00,0.00,0.00),('1','167','884','198170',3863903,'2625','389',176295.74,177241.68,945.94,154188.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','198170',3863904,'2626','389',123575.33,124447.68,872.35,142193.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','198170',3863905,'2627','389',86615.66,86615.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198170',3863906,'2628','389',151888.79,152778.42,889.63,145009.69,0.00,0.00,0.00,0.00,0.00),('1','167','885','198170',3863907,'2629','389',104488.12,105191.08,702.96,114582.48,0.00,0.00,0.00,0.00,0.00),('1','167','885','198170',3863908,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198170',3863909,'2631','389',117124.18,117685.40,561.22,91478.86,0.00,0.00,0.00,0.00,0.00),('1','167','885','198170',3863910,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198170',3863911,'2633','389',83821.15,83821.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198170',3863912,'2634','389',79045.43,79546.39,500.96,81656.48,0.00,0.00,0.00,0.00,0.00),('1','167','886','198170',3863913,'2635','389',84806.95,84806.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198170',3863914,'2636','389',43070.73,43660.60,589.87,96148.81,0.00,0.00,0.00,0.00,0.00),('1','167','887','198170',3863915,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198170',3863916,'2638','389',219596.02,220896.61,1300.59,211996.17,0.00,0.00,0.00,0.00,0.00),('1','167','887','198170',3863917,'2639','389',167162.07,167162.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198170',3863918,'2640','389',161370.55,162073.39,702.84,114562.92,0.00,0.00,0.00,0.00,0.00),('1','167','888','198170',3863919,'2641','390',474063.12,474975.31,912.19,237169.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','198170',3863920,'2642','390',307785.34,308802.25,1016.91,264396.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198170',3863921,'2643','390',492227.60,493132.76,905.16,235341.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198170',3863922,'2644','390',374492.96,375003.56,510.60,132756.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198170',3863923,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198170',3863924,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866692,'2605','389',101968.15,101968.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866693,'2606','389',93048.74,93699.54,650.80,106080.40,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866694,'2607','389',144671.44,145155.71,484.27,78936.01,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866695,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866696,'2609','389',94527.46,94970.65,443.19,72239.97,0.00,0.00,0.00,0.00,0.00),('1','167','880','198324',3866697,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866698,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866699,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866700,'2613','389',99444.90,99444.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866701,'2614','389',163022.98,163022.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866702,'2615','389',83827.65,83827.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198324',3866703,'2616','389',136927.46,137628.02,679.95,110831.85,0.00,0.00,20.61,0.00,0.00),('1','167','882','198324',3866704,'2617','389',189910.61,190357.15,446.54,72786.02,0.00,0.00,0.00,0.00,0.00),('1','167','882','198324',3866705,'2618','389',102625.72,102625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198324',3866706,'2619','389',178059.72,178409.98,350.26,57092.38,0.00,0.00,0.00,0.00,0.00),('1','167','882','198324',3866707,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198324',3866708,'2621','389',35549.42,36354.72,805.30,131263.90,0.00,0.00,0.00,0.00,0.00),('1','167','883','198324',3866709,'2622','389',135794.02,135794.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198324',3866710,'2623','389',142859.75,143858.94,999.19,162867.97,0.00,0.00,0.00,0.00,0.00),('1','167','883','198324',3866711,'2624','389',57509.35,57509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198324',3866712,'2625','389',177241.68,178530.01,1288.33,209997.79,0.00,0.00,0.00,0.00,0.00),('1','167','884','198324',3866713,'2626','389',124447.68,124447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198324',3866714,'2627','389',86615.66,86615.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198324',3866715,'2628','389',152778.42,153542.23,763.81,124501.03,0.00,0.00,0.00,0.00,0.00),('1','167','885','198324',3866716,'2629','389',105191.08,105979.05,787.97,128439.11,0.00,0.00,0.00,0.00,0.00),('1','167','885','198324',3866717,'2630','389',48834.85,48834.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198324',3866718,'2631','389',117685.40,118383.28,697.88,113754.44,0.00,0.00,0.00,0.00,0.00),('1','167','885','198324',3866719,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198324',3866720,'2633','389',83821.15,83821.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198324',3866721,'2634','389',79546.39,80044.36,497.97,81169.11,0.00,0.00,0.00,0.00,0.00),('1','167','886','198324',3866722,'2635','389',84806.95,85223.66,416.71,67923.73,0.00,0.00,0.00,0.00,0.00),('1','167','886','198324',3866723,'2636','389',43660.60,43660.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198324',3866724,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198324',3866725,'2638','389',220896.61,222135.46,1238.85,201932.55,0.00,0.00,0.00,0.00,0.00),('1','167','887','198324',3866726,'2639','389',167162.07,168286.24,1124.17,183239.71,0.00,0.00,0.00,0.00,0.00),('1','167','887','198324',3866727,'2640','389',162073.39,162172.75,99.36,16195.68,0.00,0.00,0.00,0.00,0.00),('1','167','888','198324',3866728,'2641','390',474975.31,475674.58,699.27,181810.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','198324',3866729,'2642','390',308802.25,310441.88,1639.63,426303.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198324',3866730,'2643','390',493132.76,494980.62,1847.86,480443.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198324',3866731,'2644','390',375003.56,376187.40,1183.84,307798.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','198324',3866732,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198324',3866733,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868629,'2605','389',101968.15,101968.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868630,'2606','389',93699.54,94020.97,321.43,52393.09,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868631,'2607','389',145155.71,145415.91,260.20,42412.60,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868632,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868633,'2609','389',94970.65,95545.87,575.22,93760.86,0.00,0.00,0.00,0.00,0.00),('1','167','880','198440',3868634,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868635,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868636,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868637,'2613','389',99444.90,99444.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868638,'2614','389',163022.98,163904.48,881.50,143684.50,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868639,'2615','389',83827.65,84203.63,375.98,61284.74,0.00,0.00,0.00,0.00,0.00),('1','167','881','198440',3868640,'2616','389',137628.02,138016.28,388.26,63286.38,0.00,0.00,0.00,0.00,0.00),('1','167','882','198440',3868641,'2617','389',190357.15,190357.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198440',3868642,'2618','389',102625.72,103144.30,518.58,84528.54,0.00,0.00,0.00,0.00,0.00),('1','167','882','198440',3868643,'2619','389',178409.98,178816.91,406.93,66329.59,0.00,0.00,0.00,0.00,0.00),('1','167','882','198440',3868644,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198440',3868645,'2621','389',36354.72,36354.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198440',3868646,'2622','389',135794.02,136393.78,599.76,97760.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','198440',3868647,'2623','389',143858.94,144226.73,367.79,59949.77,0.00,0.00,0.00,0.00,0.00),('1','167','883','198440',3868648,'2624','389',57509.35,57509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198440',3868649,'2625','389',178530.01,179465.42,935.41,152471.83,0.00,0.00,0.00,0.00,0.00),('1','167','884','198440',3868650,'2626','389',124447.68,124447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198440',3868651,'2627','389',86615.66,87183.55,567.89,92566.07,0.00,0.00,0.00,0.00,0.00),('1','167','884','198440',3868652,'2628','389',153542.23,154235.18,692.95,112950.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','198440',3868653,'2629','389',105979.05,105979.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198440',3868654,'2630','389',48834.85,49221.05,386.20,62950.60,0.00,0.00,0.00,0.00,0.00),('1','167','885','198440',3868655,'2631','389',118383.28,119219.95,836.67,136377.21,0.00,0.00,0.00,0.00,0.00),('1','167','885','198440',3868656,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198440',3868657,'2633','389',83821.15,83821.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198440',3868658,'2634','389',80044.36,80388.18,343.82,56042.66,0.00,0.00,0.00,0.00,0.00),('1','167','886','198440',3868659,'2635','389',85223.66,85638.74,415.08,67658.04,0.00,0.00,0.00,0.00,0.00),('1','167','886','198440',3868660,'2636','389',43660.60,43660.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198440',3868661,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198440',3868662,'2638','389',222135.46,223347.76,1212.30,197604.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','198440',3868663,'2639','389',168286.24,168995.73,709.49,115646.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','198440',3868664,'2640','389',162172.75,162172.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','198440',3868665,'2641','390',475674.58,476519.09,844.51,219572.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','198440',3868666,'2642','390',310441.88,311451.21,1009.33,262425.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198440',3868667,'2643','390',494980.62,496918.70,1938.08,503900.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198440',3868668,'2644','390',376187.40,377286.03,1098.63,285643.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','198440',3868669,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198440',3868670,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869258,'2605','389',101968.15,102741.87,773.72,126116.36,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869259,'2606','389',94020.97,94020.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869260,'2607','389',145415.91,146027.95,612.04,99762.52,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869261,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869262,'2609','389',95545.87,96154.18,608.31,99154.53,0.00,0.00,0.00,0.00,0.00),('1','167','880','198479',3869263,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869264,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869265,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869266,'2613','389',99444.90,99444.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869267,'2614','389',163904.48,164942.08,1037.60,169128.80,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869268,'2615','389',84203.63,84203.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198479',3869269,'2616','389',138016.28,138016.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198479',3869270,'2617','389',190357.15,190357.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198479',3869271,'2618','389',103144.30,103870.17,725.87,118316.81,0.00,0.00,0.00,0.00,0.00),('1','167','882','198479',3869272,'2619','389',178816.91,179493.25,676.34,110243.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','198479',3869273,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198479',3869274,'2621','389',36354.72,36354.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198479',3869275,'2622','389',136393.78,136938.17,544.39,88735.57,0.00,0.00,0.00,0.00,0.00),('1','167','883','198479',3869276,'2623','389',144226.73,144226.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198479',3869277,'2624','389',57509.35,57509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198479',3869278,'2625','389',179465.42,180756.52,1291.10,210449.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','198479',3869279,'2626','389',124447.68,124447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198479',3869280,'2627','389',87183.55,87183.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198479',3869281,'2628','389',154235.18,155223.40,988.22,161079.86,0.00,0.00,0.00,0.00,0.00),('1','167','885','198479',3869282,'2629','389',105979.05,106664.45,685.40,111720.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','198479',3869283,'2630','389',49221.05,49221.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198479',3869284,'2631','389',119219.95,119219.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198479',3869285,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198479',3869286,'2633','389',83821.15,84266.59,445.44,72606.72,0.00,0.00,0.00,0.00,0.00),('1','167','886','198479',3869287,'2634','389',80388.18,80388.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198479',3869288,'2635','389',85638.74,86236.58,597.84,97447.92,0.00,0.00,0.00,0.00,0.00),('1','167','886','198479',3869289,'2636','389',43660.60,43660.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198479',3869290,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198479',3869291,'2638','389',223347.76,225179.25,1831.49,298532.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','198479',3869292,'2639','389',168995.73,168995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198479',3869293,'2640','389',162172.75,162948.69,775.94,126478.22,0.00,0.00,0.00,0.00,0.00),('1','167','888','198479',3869294,'2641','390',476519.09,477964.98,1445.89,375930.88,0.00,0.00,0.00,0.00,0.00),('1','167','888','198479',3869295,'2642','390',311451.21,312238.49,787.28,204692.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198479',3869296,'2643','390',496918.70,498468.14,1549.44,402854.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','198479',3869297,'2644','390',377286.03,378237.72,951.69,247439.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','198479',3869298,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198479',3869299,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871800,'2605','389',102741.87,102741.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871801,'2606','389',94020.97,94321.92,300.95,49054.85,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871802,'2607','389',146027.95,146317.55,289.60,47204.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871803,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871804,'2609','389',96154.18,96437.52,283.34,46184.42,0.00,0.00,0.00,0.00,0.00),('1','167','880','198628',3871805,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871806,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871807,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871808,'2613','389',99444.90,100172.43,727.53,118587.39,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871809,'2614','389',164942.08,165733.12,791.04,128939.52,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871810,'2615','389',84203.63,84203.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198628',3871811,'2616','389',138016.28,138755.45,739.17,120484.71,0.00,0.00,0.00,0.00,0.00),('1','167','882','198628',3871812,'2617','389',190357.15,190792.41,435.26,70947.38,0.00,0.00,0.00,0.00,0.00),('1','167','882','198628',3871813,'2618','389',103870.17,103870.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198628',3871814,'2619','389',179493.25,180106.96,613.71,100034.73,0.00,0.00,0.00,0.00,0.00),('1','167','882','198628',3871815,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198628',3871816,'2621','389',36354.72,36354.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198628',3871817,'2622','389',136938.17,137540.38,602.21,98160.23,0.00,0.00,0.00,0.00,0.00),('1','167','883','198628',3871818,'2623','389',144226.73,144737.13,510.40,83195.20,0.00,0.00,0.00,0.00,0.00),('1','167','883','198628',3871819,'2624','389',57509.35,57509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198628',3871820,'2625','389',180756.52,182394.06,1637.54,266919.02,0.00,0.00,0.00,0.00,0.00),('1','167','884','198628',3871821,'2626','389',124447.68,124447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198628',3871822,'2627','389',87183.55,87729.02,545.47,88911.61,0.00,0.00,0.00,0.00,0.00),('1','167','884','198628',3871823,'2628','389',155223.40,155968.25,744.85,121410.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','198628',3871824,'2629','389',106664.45,107277.22,612.77,99881.51,0.00,0.00,0.00,0.00,0.00),('1','167','885','198628',3871825,'2630','389',49221.05,49221.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198628',3871826,'2631','389',119219.95,120052.56,832.61,135715.43,0.00,0.00,0.00,0.00,0.00),('1','167','885','198628',3871827,'2632','389',60031.75,60031.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198628',3871828,'2633','389',84266.59,84759.25,492.66,80303.58,0.00,0.00,0.00,0.00,0.00),('1','167','886','198628',3871829,'2634','389',80388.18,80549.55,161.37,26303.31,0.00,0.00,0.00,0.00,0.00),('1','167','886','198628',3871830,'2635','389',86236.58,86576.64,340.06,55429.78,0.00,0.00,0.00,0.00,0.00),('1','167','886','198628',3871831,'2636','389',43660.60,43660.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198628',3871832,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198628',3871833,'2638','389',225179.25,226078.51,899.26,146579.38,0.00,0.00,0.00,0.00,0.00),('1','167','887','198628',3871834,'2639','389',168995.73,168995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198628',3871835,'2640','389',162948.69,164160.16,1211.47,197469.61,0.00,0.00,0.00,0.00,0.00),('1','167','888','198628',3871836,'2641','390',477964.98,479690.18,1725.20,448552.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','198628',3871837,'2642','390',312238.49,312863.42,624.93,162481.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198628',3871838,'2643','390',498468.14,499689.90,1221.76,317657.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198628',3871839,'2644','390',378237.72,379942.73,1705.01,443302.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','198628',3871840,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198628',3871841,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872915,'2605','389',102741.87,103491.37,749.50,122168.50,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872916,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872917,'2607','389',146317.55,146915.56,598.01,97475.63,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872918,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872919,'2609','389',96437.52,96791.46,353.94,57692.22,0.00,0.00,0.00,0.00,0.00),('1','167','880','198686',3872920,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872921,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872922,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872923,'2613','389',100172.43,100172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872924,'2614','389',165733.12,166887.68,1154.56,188193.28,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872925,'2615','389',84203.63,84203.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198686',3872926,'2616','389',138755.45,139704.57,949.12,154706.56,0.00,0.00,0.00,0.00,0.00),('1','167','882','198686',3872927,'2617','389',190792.41,191171.39,378.98,61773.74,0.00,0.00,0.00,0.00,0.00),('1','167','882','198686',3872928,'2618','389',103870.17,103870.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198686',3872929,'2619','389',180106.96,180613.60,506.64,82582.32,0.00,0.00,0.00,0.00,0.00),('1','167','882','198686',3872930,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198686',3872931,'2621','389',36354.72,36354.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198686',3872932,'2622','389',137540.38,138277.94,737.56,120222.28,0.00,0.00,0.00,0.00,0.00),('1','167','883','198686',3872933,'2623','389',144737.13,145099.96,362.83,59141.29,0.00,0.00,0.00,0.00,0.00),('1','167','883','198686',3872934,'2624','389',57509.35,57509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198686',3872935,'2625','389',182394.06,183737.67,1343.61,219008.43,0.00,0.00,0.00,0.00,0.00),('1','167','884','198686',3872936,'2626','389',124447.68,124447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198686',3872937,'2627','389',87729.02,87729.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','198686',3872938,'2628','389',155968.25,156710.14,741.89,120928.07,0.00,0.00,0.00,0.00,0.00),('1','167','885','198686',3872939,'2629','389',107277.22,107957.33,680.11,110857.93,0.00,0.00,0.00,0.00,0.00),('1','167','885','198686',3872940,'2630','389',49221.05,49221.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198686',3872941,'2631','389',120052.56,120825.27,772.71,125951.73,0.00,0.00,0.00,0.00,0.00),('1','167','885','198686',3872942,'2632','389',60031.75,60095.54,63.79,10397.77,0.00,0.00,0.00,0.00,0.00),('1','167','886','198686',3872943,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198686',3872944,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198686',3872945,'2635','389',86576.64,86576.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198686',3872946,'2636','389',43660.60,44201.85,541.25,88223.75,0.00,0.00,0.00,0.00,0.00),('1','167','887','198686',3872947,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198686',3872948,'2638','389',226078.51,226078.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198686',3872949,'2639','389',168995.73,170545.04,1549.31,252537.53,0.00,0.00,0.00,0.00,0.00),('1','167','887','198686',3872950,'2640','389',164160.16,164160.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','198686',3872951,'2641','390',479690.18,482221.79,2531.61,658218.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','198686',3872952,'2642','390',312863.42,313467.50,604.08,157060.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','198686',3872953,'2643','390',499689.90,500967.76,1277.86,332243.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','198686',3872954,'2644','390',379942.73,381853.76,1911.03,496867.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','198686',3872955,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198686',3872956,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875725,'2605','389',103491.37,103991.36,499.99,81498.37,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875726,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875727,'2607','389',146915.56,147450.02,534.46,87116.98,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875728,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875729,'2609','389',96791.46,97126.08,334.62,54543.06,0.00,0.00,0.00,0.00,0.00),('1','167','880','198870',3875730,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875731,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875732,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875733,'2613','389',100172.43,100172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875734,'2614','389',166887.68,168014.94,1127.26,183743.38,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875735,'2615','389',84203.63,84203.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','198870',3875736,'2616','389',139704.57,140243.97,539.40,87922.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','198870',3875737,'2617','389',191171.39,191780.10,608.71,99219.73,0.00,0.00,0.00,0.00,0.00),('1','167','882','198870',3875738,'2618','389',103870.17,103870.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','198870',3875739,'2619','389',180613.60,181089.48,475.88,77568.44,0.00,0.00,0.00,0.00,0.00),('1','167','882','198870',3875740,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198870',3875741,'2621','389',36354.72,37143.89,789.17,128634.71,0.00,0.00,0.00,0.00,0.00),('1','167','883','198870',3875742,'2622','389',138277.94,138277.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','198870',3875743,'2623','389',145099.96,145747.76,647.80,105591.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','198870',3875744,'2624','389',57509.35,57512.42,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','167','884','198870',3875745,'2625','389',183737.67,184557.61,819.94,133650.22,0.00,0.00,0.00,0.00,0.00),('1','167','884','198870',3875746,'2626','389',124447.68,125245.58,797.90,130057.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','198870',3875747,'2627','389',87729.02,88625.36,896.34,146103.42,0.00,0.00,0.00,0.00,0.00),('1','167','884','198870',3875748,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','198870',3875749,'2629','389',107957.33,108455.71,498.38,81235.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','198870',3875750,'2630','389',49221.05,49650.45,429.40,69992.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','198870',3875751,'2631','389',120825.27,121298.68,473.41,77165.83,0.00,0.00,0.00,0.00,0.00),('1','167','885','198870',3875752,'2632','389',60095.54,60498.86,403.32,65741.16,0.00,0.00,0.00,0.00,0.00),('1','167','886','198870',3875753,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198870',3875754,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','198870',3875755,'2635','389',86576.64,86589.05,12.41,2022.83,0.00,0.00,0.00,0.00,0.00),('1','167','886','198870',3875756,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198870',3875757,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','198870',3875758,'2638','389',226078.51,227080.77,1002.26,163368.38,0.00,0.00,0.00,0.00,0.00),('1','167','887','198870',3875759,'2639','389',170545.04,171286.26,741.22,120818.86,0.00,0.00,0.00,0.00,0.00),('1','167','887','198870',3875760,'2640','389',164160.16,164795.03,634.87,103483.81,0.00,0.00,0.00,0.00,0.00),('1','167','888','198870',3875761,'2641','390',482221.79,483061.22,839.43,218251.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','198870',3875762,'2642','390',313467.50,314144.60,677.10,176046.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','198870',3875763,'2643','390',500967.76,501992.00,1024.24,266302.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','198870',3875764,'2644','390',381853.76,382867.47,1013.71,263564.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','198870',3875765,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','198870',3875766,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879623,'2605','389',103991.36,104953.17,961.81,156775.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879624,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879625,'2607','389',147450.02,147874.81,424.79,69240.77,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879626,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879627,'2609','389',97126.08,97568.35,442.27,72090.01,0.00,0.00,0.00,0.00,0.00),('1','167','880','199082',3879628,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879629,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879630,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879631,'2613','389',100172.43,100172.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879632,'2614','389',168014.94,169093.73,1078.79,175842.77,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879633,'2615','389',84203.63,84203.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199082',3879634,'2616','389',140243.97,141120.05,876.08,142801.04,0.00,0.00,0.00,0.00,0.00),('1','167','882','199082',3879635,'2617','389',191780.10,191780.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199082',3879636,'2618','389',103870.17,104363.21,493.04,80365.52,0.00,0.00,0.00,0.00,0.00),('1','167','882','199082',3879637,'2619','389',181089.48,181613.34,523.86,85389.18,0.00,0.00,0.00,0.00,0.00),('1','167','882','199082',3879638,'2620','389',126831.10,126831.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199082',3879639,'2621','389',37143.89,37143.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199082',3879640,'2622','389',138277.94,139034.23,756.29,123275.27,0.00,0.00,0.00,0.00,0.00),('1','167','883','199082',3879641,'2623','389',145747.76,146635.03,887.27,144625.01,0.00,0.00,0.00,0.00,0.00),('1','167','883','199082',3879642,'2624','389',57512.42,57512.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199082',3879643,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199082',3879644,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199082',3879645,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199082',3879646,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199082',3879647,'2629','389',108455.71,108954.41,488.70,79658.10,0.00,0.00,10.00,0.00,0.00),('1','167','885','199082',3879648,'2630','389',49650.45,49650.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199082',3879649,'2631','389',121298.68,122272.31,973.63,158701.69,0.00,0.00,0.00,0.00,0.00),('1','167','885','199082',3879650,'2632','389',60498.86,60498.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199082',3879651,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199082',3879652,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199082',3879653,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199082',3879654,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199082',3879655,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199082',3879656,'2638','389',227080.77,228450.74,1359.97,221675.11,0.00,0.00,10.00,0.00,0.00),('1','167','887','199082',3879657,'2639','389',171286.26,172692.86,1396.60,227645.80,0.00,0.00,10.00,0.00,0.00),('1','167','887','199082',3879658,'2640','389',164795.03,164795.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199082',3879659,'2641','390',483061.22,484322.37,1261.15,327899.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199082',3879660,'2642','390',314144.60,315329.57,1184.97,308092.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','199082',3879661,'2643','390',501992.00,502686.35,694.35,180531.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199082',3879662,'2644','390',382867.47,383986.92,1119.45,291057.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199082',3879663,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199082',3879664,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880722,'2605','389',104953.17,105384.81,431.64,70357.32,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880723,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880724,'2607','389',147874.81,148408.27,533.46,86953.98,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880725,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880726,'2609','389',97568.35,98148.96,580.61,94639.43,0.00,0.00,0.00,0.00,0.00),('1','167','880','199132',3880727,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880728,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880729,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880730,'2613','389',100172.43,101062.04,889.61,145006.43,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880731,'2614','389',169093.73,169983.78,890.05,145078.15,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880732,'2615','389',84203.63,84834.48,630.85,102828.55,0.00,0.00,0.00,0.00,0.00),('1','167','881','199132',3880733,'2616','389',141120.05,141610.29,490.24,79909.12,0.00,0.00,0.00,0.00,0.00),('1','167','882','199132',3880734,'2617','389',191780.10,192230.41,450.31,73400.53,0.00,0.00,0.00,0.00,0.00),('1','167','882','199132',3880735,'2618','389',104363.21,104363.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199132',3880736,'2619','389',181613.34,181974.44,361.10,58859.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','199132',3880737,'2620','389',126831.10,127143.70,312.60,50953.80,0.00,0.00,0.00,0.00,0.00),('1','167','883','199132',3880738,'2621','389',37143.89,38412.65,1268.76,206807.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','199132',3880739,'2622','389',139034.23,139840.06,805.83,131350.29,0.00,0.00,0.00,0.00,0.00),('1','167','883','199132',3880740,'2623','389',146635.03,147177.06,542.03,88350.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','199132',3880741,'2624','389',57512.42,57512.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199132',3880742,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199132',3880743,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199132',3880744,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199132',3880745,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199132',3880746,'2629','389',108954.41,109602.03,647.62,105562.06,0.00,0.00,0.00,0.00,0.00),('1','167','885','199132',3880747,'2630','389',49650.45,50187.62,537.17,87558.71,0.00,0.00,0.00,0.00,0.00),('1','167','885','199132',3880748,'2631','389',122272.31,122709.39,437.08,71244.04,0.00,0.00,0.00,0.00,0.00),('1','167','885','199132',3880749,'2632','389',60498.86,60975.74,476.88,77731.44,0.00,0.00,0.00,0.00,0.00),('1','167','886','199132',3880750,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199132',3880751,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199132',3880752,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199132',3880753,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199132',3880754,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199132',3880755,'2638','389',228450.74,229569.88,1119.14,182419.82,0.00,0.00,0.00,0.00,0.00),('1','167','887','199132',3880756,'2639','389',172692.86,173462.72,769.86,125487.18,0.00,0.00,0.00,0.00,0.00),('1','167','887','199132',3880757,'2640','389',164795.03,165493.04,698.01,113775.63,0.00,0.00,0.00,0.00,0.00),('1','167','888','199132',3880758,'2641','390',484322.37,485539.52,1217.15,316459.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199132',3880759,'2642','390',315329.57,316237.18,907.61,235978.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199132',3880760,'2643','390',502686.35,503733.51,1047.16,272261.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199132',3880761,'2644','390',383986.92,385571.89,1584.97,412092.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','199132',3880762,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199132',3880763,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881227,'2605','389',105384.81,106169.27,784.46,127866.98,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881228,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881229,'2607','389',148408.27,149000.06,591.79,96461.77,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881230,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881231,'2609','389',98148.96,98612.26,463.30,75517.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','199155',3881232,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881233,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881234,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881235,'2613','389',101062.04,102398.40,1336.36,217826.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881236,'2614','389',169983.78,169983.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881237,'2615','389',84834.48,84834.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199155',3881238,'2616','389',141610.29,142577.10,966.81,157590.03,0.00,0.00,0.00,0.00,0.00),('1','167','882','199155',3881239,'2617','389',192230.41,192738.64,508.23,82841.49,0.00,0.00,0.00,0.00,0.00),('1','167','882','199155',3881240,'2618','389',104363.21,104363.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199155',3881241,'2619','389',181974.44,182571.79,597.35,97368.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','199155',3881242,'2620','389',127143.70,127143.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199155',3881243,'2621','389',38412.65,38412.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199155',3881244,'2622','389',139840.06,139840.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199155',3881245,'2623','389',147177.06,147951.34,774.28,126207.64,0.00,0.00,0.00,0.00,0.00),('1','167','883','199155',3881246,'2624','389',57512.42,57512.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199155',3881247,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199155',3881248,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199155',3881249,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199155',3881250,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199155',3881251,'2629','389',109602.03,110537.49,935.46,152479.98,0.00,0.00,0.00,0.00,0.00),('1','167','885','199155',3881252,'2630','389',50187.62,50187.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199155',3881253,'2631','389',122709.39,123582.54,873.15,142323.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','199155',3881254,'2632','389',60975.74,60975.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199155',3881255,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199155',3881256,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199155',3881257,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199155',3881258,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199155',3881259,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199155',3881260,'2638','389',229569.88,230949.17,1379.29,224824.27,0.00,0.00,0.00,0.00,0.00),('1','167','887','199155',3881261,'2639','389',173462.72,174701.63,1238.91,201942.33,0.00,0.00,0.00,0.00,0.00),('1','167','887','199155',3881262,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199155',3881263,'2641','390',485539.52,486400.39,860.87,223826.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','199155',3881264,'2642','390',316237.18,316665.26,428.08,111300.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','199155',3881265,'2643','390',503733.51,504790.35,1056.84,274778.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','199155',3881266,'2644','390',385571.89,386408.84,836.95,217607.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199155',3881267,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199155',3881268,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883025,'2605','389',106169.27,106823.16,653.89,106584.07,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883026,'2606','389',94321.92,94321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883027,'2607','389',149000.06,149413.17,413.11,67336.93,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883028,'2608','389',52379.08,52379.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883029,'2609','389',98612.26,98832.38,220.12,35879.56,0.00,0.00,0.00,0.00,0.00),('1','167','880','199299',3883030,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883031,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883032,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883033,'2613','389',102398.40,103270.37,871.97,142131.11,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883034,'2614','389',169983.78,170547.36,563.58,91863.54,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883035,'2615','389',84834.48,85814.49,980.01,159741.63,0.00,0.00,0.00,0.00,0.00),('1','167','881','199299',3883036,'2616','389',142577.10,143339.44,762.34,124261.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','199299',3883037,'2617','389',192738.64,193028.37,289.73,47225.99,0.00,0.00,0.00,0.00,0.00),('1','167','882','199299',3883038,'2618','389',104363.21,104857.45,494.24,80561.12,0.00,0.00,0.00,0.00,0.00),('1','167','882','199299',3883039,'2619','389',182571.79,182818.76,246.97,40256.11,0.00,0.00,0.00,0.00,0.00),('1','167','882','199299',3883040,'2620','389',127143.70,127405.66,261.96,42699.48,0.00,0.00,0.00,0.00,0.00),('1','167','883','199299',3883041,'2621','389',38412.65,39117.97,705.32,114967.16,0.00,0.00,0.00,0.00,0.00),('1','167','883','199299',3883042,'2622','389',139840.06,141712.05,1871.99,305134.37,0.00,0.00,0.00,0.00,0.00),('1','167','883','199299',3883043,'2623','389',147951.34,148584.88,633.54,103267.02,0.00,0.00,0.00,0.00,0.00),('1','167','883','199299',3883044,'2624','389',57512.42,57885.69,373.27,60843.01,0.00,0.00,0.00,0.00,0.00),('1','167','884','199299',3883045,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199299',3883046,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199299',3883047,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199299',3883048,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199299',3883049,'2629','389',110537.49,111046.34,508.85,82942.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','199299',3883050,'2630','389',50187.62,51064.63,877.01,142952.63,0.00,0.00,0.00,0.00,0.00),('1','167','885','199299',3883051,'2631','389',123582.54,124102.28,519.74,84717.62,0.00,0.00,0.00,0.00,0.00),('1','167','885','199299',3883052,'2632','389',60975.74,61522.68,546.94,89151.22,0.00,0.00,0.00,0.00,0.00),('1','167','886','199299',3883053,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199299',3883054,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199299',3883055,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199299',3883056,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199299',3883057,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199299',3883058,'2638','389',230949.17,230949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199299',3883059,'2639','389',174701.63,174701.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199299',3883060,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199299',3883061,'2641','390',486400.39,486897.23,496.84,129178.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','199299',3883062,'2642','390',316665.26,317081.86,416.60,108316.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199299',3883063,'2643','390',504790.35,505715.39,925.04,240510.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','199299',3883064,'2644','390',386408.84,388096.79,1687.95,438867.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199299',3883065,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199299',3883066,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199370',3884487,'2605','389',106823.16,107771.20,928.04,151270.52,0.00,0.00,20.00,0.00,0.00),('1','167','880','199370',3884488,'2606','389',94321.92,94356.12,14.20,2314.60,0.00,0.00,20.00,0.00,0.00),('1','167','880','199370',3884489,'2607','389',149413.17,149997.89,564.72,92049.36,0.00,0.00,20.00,0.00,0.00),('1','167','880','199370',3884490,'2608','389',52379.08,52399.59,0.51,83.13,0.00,0.00,20.00,0.00,0.00),('1','167','880','199370',3884491,'2609','389',98832.38,99204.45,352.07,57387.41,0.00,0.00,20.00,0.00,0.00),('1','167','880','199370',3884492,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199370',3884493,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199370',3884494,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199370',3884495,'2613','389',103270.37,104192.90,902.53,147112.39,0.00,0.00,20.00,0.00,0.00),('1','167','881','199370',3884496,'2614','389',170547.36,171773.87,1206.51,196661.13,0.00,0.00,20.00,0.00,0.00),('1','167','881','199370',3884497,'2615','389',85814.49,86536.58,702.09,114440.67,0.00,0.00,20.00,0.00,0.00),('1','167','881','199370',3884498,'2616','389',143339.44,143940.22,580.78,94667.14,0.00,0.00,20.00,0.00,0.00),('1','167','882','199370',3884499,'2617','389',193028.37,193772.67,724.30,118060.90,0.00,0.00,20.00,0.00,0.00),('1','167','882','199370',3884500,'2618','389',104857.45,105053.37,175.92,28674.96,0.00,0.00,20.00,0.00,0.00),('1','167','882','199370',3884501,'2619','389',182818.76,183285.27,446.51,72781.13,0.00,0.00,20.00,0.00,0.00),('1','167','882','199370',3884502,'2620','389',127405.66,127823.85,398.19,64904.97,0.00,0.00,20.00,0.00,0.00),('1','167','883','199370',3884503,'2621','389',39117.97,40013.96,875.99,142786.37,0.00,0.00,20.00,0.00,0.00),('1','167','883','199370',3884504,'2622','389',141712.05,142577.77,845.72,137852.36,0.00,0.00,20.00,0.00,0.00),('1','167','883','199370',3884505,'2623','389',148584.88,149071.42,466.54,76046.02,0.00,0.00,20.00,0.00,0.00),('1','167','883','199370',3884506,'2624','389',57885.69,58289.42,383.73,62547.99,0.00,0.00,20.00,0.00,0.00),('1','167','884','199370',3884507,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199370',3884508,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199370',3884509,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199370',3884510,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199370',3884511,'2629','389',111046.34,111636.72,570.38,92971.94,0.00,0.00,20.00,0.00,0.00),('1','167','885','199370',3884512,'2630','389',51064.63,51566.84,482.21,78600.23,0.00,0.00,20.00,0.00,0.00),('1','167','885','199370',3884513,'2631','389',124102.28,124256.21,143.93,23460.59,0.00,0.00,10.00,0.00,0.00),('1','167','885','199370',3884514,'2632','389',61522.68,61777.64,244.96,39928.48,0.00,0.00,10.00,0.00,0.00),('1','167','886','199370',3884515,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199370',3884516,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199370',3884517,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199370',3884518,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199370',3884519,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199370',3884520,'2638','389',230949.17,230949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199370',3884521,'2639','389',174701.63,174701.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199370',3884522,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199370',3884523,'2641','390',486897.23,489030.95,2133.72,554767.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','199370',3884524,'2642','390',317081.86,317817.44,735.58,191250.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','199370',3884525,'2643','390',505715.39,506638.70,923.31,240060.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199370',3884526,'2644','390',388096.79,388602.56,505.77,131500.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','199370',3884527,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199370',3884528,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886776,'2605','389',107771.20,108964.16,1192.96,194452.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886777,'2606','389',94356.12,94356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886778,'2607','389',149997.89,150871.90,874.01,142463.63,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886779,'2608','389',52399.59,52399.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886780,'2609','389',99204.45,100142.64,938.19,152924.97,0.00,0.00,0.00,0.00,0.00),('1','167','880','199518',3886781,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886782,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886783,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886784,'2613','389',104192.90,105648.01,1455.11,237182.93,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886785,'2614','389',171773.87,172489.54,715.67,116654.21,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886786,'2615','389',86536.58,88157.64,1621.06,264232.78,0.00,0.00,0.00,0.00,0.00),('1','167','881','199518',3886787,'2616','389',143940.22,144158.93,218.71,35649.73,0.00,0.00,0.00,0.00,0.00),('1','167','882','199518',3886788,'2617','389',193772.67,194426.01,653.34,106494.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','199518',3886789,'2618','389',105053.37,105053.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199518',3886790,'2619','389',183285.27,184252.23,966.96,157614.48,0.00,0.00,0.00,0.00,0.00),('1','167','882','199518',3886791,'2620','389',127823.85,128545.22,721.37,117583.31,0.00,0.00,0.00,0.00,0.00),('1','167','883','199518',3886792,'2621','389',40013.96,40906.77,892.81,145528.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','199518',3886793,'2622','389',142577.77,143662.57,1084.80,176822.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','199518',3886794,'2623','389',149071.42,149846.70,775.28,126370.64,0.00,0.00,0.00,0.00,0.00),('1','167','883','199518',3886795,'2624','389',58289.42,58634.41,344.99,56233.37,0.00,0.00,0.00,0.00,0.00),('1','167','884','199518',3886796,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199518',3886797,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199518',3886798,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199518',3886799,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199518',3886800,'2629','389',111636.72,111636.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199518',3886801,'2630','389',51566.84,51566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199518',3886802,'2631','389',124256.21,124256.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199518',3886803,'2632','389',61777.64,61777.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199518',3886804,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199518',3886805,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199518',3886806,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199518',3886807,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199518',3886808,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199518',3886809,'2638','389',230949.17,230949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199518',3886810,'2639','389',174701.63,174701.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199518',3886811,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199518',3886812,'2641','390',489030.95,492078.44,3047.49,792347.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','199518',3886813,'2642','390',317817.44,318299.95,482.51,125452.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199518',3886814,'2643','390',506638.70,506914.77,276.07,71778.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','199518',3886815,'2644','390',388602.56,388630.94,28.38,7378.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','199518',3886816,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199518',3886817,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888466,'2605','389',108964.16,109782.51,818.35,133391.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888467,'2606','389',94356.12,95274.22,918.10,149650.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888468,'2607','389',150871.90,151855.73,983.83,160364.29,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888469,'2608','389',52399.59,53359.98,960.39,156543.57,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888470,'2609','389',100142.64,100901.72,759.08,123730.04,0.00,0.00,0.00,0.00,0.00),('1','167','880','199598',3888471,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888472,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888473,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888474,'2613','389',105648.01,105974.85,326.84,53274.92,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888475,'2614','389',172489.54,172674.52,184.98,30151.74,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888476,'2615','389',88157.64,88280.69,123.05,20057.15,0.00,0.00,0.00,0.00,0.00),('1','167','881','199598',3888477,'2616','389',144158.93,144498.18,339.25,55297.75,0.00,0.00,0.00,0.00,0.00),('1','167','882','199598',3888478,'2617','389',194426.01,195087.01,661.00,107743.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199598',3888479,'2618','389',105053.37,105626.83,573.46,93473.98,0.00,0.00,0.00,0.00,0.00),('1','167','882','199598',3888480,'2619','389',184252.23,185609.16,1356.93,221179.59,0.00,0.00,0.00,0.00,0.00),('1','167','882','199598',3888481,'2620','389',128545.22,128545.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199598',3888482,'2621','389',40906.77,42110.76,1203.99,196250.37,0.00,0.00,0.00,0.00,0.00),('1','167','883','199598',3888483,'2622','389',143662.57,144947.22,1284.65,209397.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','199598',3888484,'2623','389',149846.70,150691.28,844.58,137666.54,0.00,0.00,0.00,0.00,0.00),('1','167','883','199598',3888485,'2624','389',58634.41,59399.05,764.64,124636.32,0.00,0.00,0.00,0.00,0.00),('1','167','884','199598',3888486,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199598',3888487,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199598',3888488,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199598',3888489,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199598',3888490,'2629','389',111636.72,111636.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199598',3888491,'2630','389',51566.84,51566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199598',3888492,'2631','389',124256.21,124256.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199598',3888493,'2632','389',61777.64,61777.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199598',3888494,'2633','389',84759.25,84759.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199598',3888495,'2634','389',80549.55,80549.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199598',3888496,'2635','389',86589.05,86589.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199598',3888497,'2636','389',44201.85,44201.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199598',3888498,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199598',3888499,'2638','389',230949.17,230949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199598',3888500,'2639','389',174701.63,174701.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199598',3888501,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199598',3888502,'2641','390',492078.44,493955.34,1876.90,487994.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199598',3888503,'2642','390',318299.95,320963.71,2663.76,692577.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199598',3888504,'2643','390',506914.77,506914.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199598',3888505,'2644','390',388630.94,388630.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199598',3888506,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199598',3888507,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893565,'2605','389',109782.51,111077.05,1294.54,211010.02,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893566,'2606','389',95274.22,96543.49,1269.27,206891.01,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893567,'2607','389',151855.73,152578.65,722.92,117835.96,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893568,'2608','389',53359.98,53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893569,'2609','389',100901.72,101657.69,755.97,123223.11,0.00,0.00,0.00,0.00,0.00),('1','167','880','199936',3893570,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893571,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893572,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893573,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893574,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893575,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199936',3893576,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199936',3893577,'2617','389',195087.01,195716.31,629.30,102575.90,0.00,0.00,0.00,0.00,0.00),('1','167','882','199936',3893578,'2618','389',105626.83,106346.98,720.15,117384.45,0.00,0.00,0.00,0.00,0.00),('1','167','882','199936',3893579,'2619','389',185609.16,186001.40,392.24,63935.12,0.00,0.00,0.00,0.00,0.00),('1','167','882','199936',3893580,'2620','389',128545.22,129403.06,857.84,139827.92,0.00,0.00,0.00,0.00,0.00),('1','167','883','199936',3893581,'2621','389',42110.76,42110.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199936',3893582,'2622','389',144947.22,146212.22,1265.00,206195.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199936',3893583,'2623','389',150691.28,151484.20,792.92,129245.96,0.00,0.00,0.00,0.00,0.00),('1','167','883','199936',3893584,'2624','389',59399.05,59744.01,344.96,56228.48,0.00,0.00,0.00,0.00,0.00),('1','167','884','199936',3893585,'2625','389',184557.61,184557.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199936',3893586,'2626','389',125245.58,125245.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199936',3893587,'2627','389',88625.36,88625.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199936',3893588,'2628','389',156710.14,156710.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199936',3893589,'2629','389',111636.72,111636.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199936',3893590,'2630','389',51566.84,51566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199936',3893591,'2631','389',124256.21,124256.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199936',3893592,'2632','389',61777.64,61777.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199936',3893593,'2633','389',84759.25,85896.66,1137.41,185397.83,0.00,0.00,0.00,0.00,0.00),('1','167','886','199936',3893594,'2634','389',80549.55,81846.95,1297.40,211476.20,0.00,0.00,0.00,0.00,0.00),('1','167','886','199936',3893595,'2635','389',86589.05,87361.70,772.65,125941.95,0.00,0.00,0.00,0.00,0.00),('1','167','886','199936',3893596,'2636','389',44201.85,45434.72,1232.87,200957.81,0.00,0.00,0.00,0.00,0.00),('1','167','887','199936',3893597,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199936',3893598,'2638','389',230949.17,230949.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199936',3893599,'2639','389',174701.63,174701.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199936',3893600,'2640','389',165493.04,165493.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199936',3893601,'2641','390',493955.34,493955.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199936',3893602,'2642','390',320963.71,320963.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199936',3893603,'2643','390',506914.77,506914.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199936',3893604,'2644','390',388630.94,388630.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199936',3893605,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199936',3893606,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893703,'2605','389',111077.05,111874.14,797.09,129925.67,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893704,'2606','389',96543.49,96543.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893705,'2607','389',152578.65,152981.53,402.88,65669.44,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893706,'2608','389',53359.98,53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893707,'2609','389',101657.69,102082.99,425.30,69323.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','199942',3893708,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893709,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893710,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893711,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893712,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893713,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199942',3893714,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199942',3893715,'2617','389',195716.31,196127.49,411.18,67022.34,0.00,0.00,0.00,0.00,0.00),('1','167','882','199942',3893716,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199942',3893717,'2619','389',186001.40,186367.80,366.40,59723.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','199942',3893718,'2620','389',129403.06,129732.66,329.60,53724.80,0.00,0.00,0.00,0.00,0.00),('1','167','883','199942',3893719,'2621','389',42110.76,42653.79,543.03,88513.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','199942',3893720,'2622','389',146212.22,146676.83,464.61,75731.43,0.00,0.00,0.00,0.00,0.00),('1','167','883','199942',3893721,'2623','389',151484.20,151744.23,260.03,42384.89,0.00,0.00,0.00,0.00,0.00),('1','167','883','199942',3893722,'2624','389',59744.01,59934.52,190.51,31053.13,0.00,0.00,0.00,0.00,0.00),('1','167','884','199942',3893723,'2625','389',184557.61,186124.57,1546.96,252154.48,0.00,0.00,20.00,0.00,0.00),('1','167','884','199942',3893724,'2626','389',125245.58,125979.87,714.29,116429.27,0.00,0.00,20.00,0.00,0.00),('1','167','884','199942',3893725,'2627','389',88625.36,89277.17,641.81,104615.03,0.00,0.00,10.00,0.00,0.00),('1','167','884','199942',3893726,'2628','389',156710.14,156990.51,270.37,44070.31,0.00,0.00,10.00,0.00,0.00),('1','167','885','199942',3893727,'2629','389',111636.72,112280.85,634.13,103363.19,0.00,0.00,10.00,0.00,0.00),('1','167','885','199942',3893728,'2630','389',51566.84,51977.27,390.43,63640.09,0.00,0.00,20.00,0.00,0.00),('1','167','885','199942',3893729,'2631','389',124256.21,124821.17,554.96,90458.48,0.00,0.00,10.00,0.00,0.00),('1','167','885','199942',3893730,'2632','389',61777.64,62394.78,587.14,95703.82,0.00,0.00,30.00,0.00,0.00),('1','167','886','199942',3893731,'2633','389',85896.66,85896.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199942',3893732,'2634','389',81846.95,81846.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199942',3893733,'2635','389',87361.70,87458.62,92.92,15145.96,0.00,0.00,4.00,0.00,0.00),('1','167','886','199942',3893734,'2636','389',45434.72,45434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199942',3893735,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199942',3893736,'2638','389',230949.17,231935.39,966.22,157493.86,0.00,0.00,20.00,0.00,0.00),('1','167','887','199942',3893737,'2639','389',174701.63,175301.31,579.68,94487.84,0.00,0.00,20.00,0.00,0.00),('1','167','887','199942',3893738,'2640','389',165493.04,166040.63,527.59,85997.17,0.00,0.00,20.00,0.00,0.00),('1','167','888','199942',3893739,'2641','390',493955.34,496077.41,2122.07,551738.20,0.00,0.00,0.00,0.00,0.00),('1','167','888','199942',3893740,'2642','390',320963.71,321934.21,970.50,252330.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','199942',3893741,'2643','390',506914.77,507562.41,647.64,168386.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','199942',3893742,'2644','390',388630.94,388803.78,172.84,44938.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','199942',3893743,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199942',3893744,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894521,'2605','389',111874.14,112578.21,704.07,114763.41,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894522,'2606','389',96543.49,96888.53,345.04,56241.52,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894523,'2607','389',152981.53,153321.54,340.01,55421.63,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894524,'2608','389',53359.98,53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894525,'2609','389',102082.99,102536.75,453.76,73962.88,0.00,0.00,0.00,0.00,0.00),('1','167','880','199977',3894526,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894527,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894528,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894529,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894530,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894531,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','199977',3894532,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199977',3894533,'2617','389',196127.49,196964.90,837.41,136497.83,0.00,0.00,0.00,0.00,0.00),('1','167','882','199977',3894534,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','199977',3894535,'2619','389',186367.80,186946.13,578.33,94267.79,0.00,0.00,0.00,0.00,0.00),('1','167','882','199977',3894536,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199977',3894537,'2621','389',42653.79,43824.94,1171.15,190897.45,0.00,0.00,0.00,0.00,0.00),('1','167','883','199977',3894538,'2622','389',146676.83,146676.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','199977',3894539,'2623','389',151744.23,152431.29,687.06,111990.78,0.00,0.00,0.00,0.00,0.00),('1','167','883','199977',3894540,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199977',3894541,'2625','389',186124.57,186643.83,519.26,84639.38,0.00,0.00,0.00,0.00,0.00),('1','167','884','199977',3894542,'2626','389',125979.87,127666.73,1686.86,274958.18,0.00,0.00,0.00,0.00,0.00),('1','167','884','199977',3894543,'2627','389',89277.17,89277.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','199977',3894544,'2628','389',156990.51,158304.43,1313.92,214168.96,0.00,0.00,0.00,0.00,0.00),('1','167','885','199977',3894545,'2629','389',112280.85,113284.06,1003.21,163523.23,0.00,0.00,0.00,0.00,0.00),('1','167','885','199977',3894546,'2630','389',51977.27,52001.80,24.53,3998.39,0.00,0.00,0.00,0.00,0.00),('1','167','885','199977',3894547,'2631','389',124821.17,124821.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','199977',3894548,'2632','389',62394.78,63286.80,892.02,145399.26,0.00,0.00,0.00,0.00,0.00),('1','167','886','199977',3894549,'2633','389',85896.66,85896.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','199977',3894550,'2634','389',81846.95,82344.48,497.53,81097.39,0.00,0.00,0.00,0.00,0.00),('1','167','886','199977',3894551,'2635','389',87458.62,87907.17,448.55,73113.65,0.00,0.00,0.00,0.00,0.00),('1','167','886','199977',3894552,'2636','389',45434.72,45434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199977',3894553,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','199977',3894554,'2638','389',231935.39,233218.00,1282.61,209065.43,0.00,0.00,0.00,0.00,0.00),('1','167','887','199977',3894555,'2639','389',175301.31,175791.65,490.34,79925.42,0.00,0.00,0.00,0.00,0.00),('1','167','887','199977',3894556,'2640','389',166040.63,166347.20,306.57,49970.91,0.00,0.00,0.00,0.00,0.00),('1','167','888','199977',3894557,'2641','390',496077.41,496970.66,893.25,232245.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','199977',3894558,'2642','390',321934.21,323189.42,1255.21,326354.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199977',3894559,'2643','390',507562.41,509363.72,1801.31,468340.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','199977',3894560,'2644','390',388803.78,390154.38,1350.60,351156.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199977',3894561,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','199977',3894562,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895464,'2605','389',112578.21,113542.29,964.08,157145.04,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895465,'2606','389',96888.53,96888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895466,'2607','389',153321.54,153935.76,614.22,100117.86,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895467,'2608','389',53359.98,53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895468,'2609','389',102536.75,102944.62,407.87,66482.81,0.00,0.00,0.00,0.00,0.00),('1','167','880','200020',3895469,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895470,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895471,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895472,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895473,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895474,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200020',3895475,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200020',3895476,'2617','389',196964.90,197335.65,370.75,60432.25,0.00,0.00,0.00,0.00,0.00),('1','167','882','200020',3895477,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200020',3895478,'2619','389',186946.13,187249.99,303.86,49529.18,0.00,0.00,0.00,0.00,0.00),('1','167','882','200020',3895479,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200020',3895480,'2621','389',43824.94,44518.31,693.37,113019.31,0.00,0.00,0.00,0.00,0.00),('1','167','883','200020',3895481,'2622','389',146676.83,147398.48,721.65,117628.95,0.00,0.00,0.00,0.00,0.00),('1','167','883','200020',3895482,'2623','389',152431.29,152931.78,500.49,81579.87,0.00,0.00,0.00,0.00,0.00),('1','167','883','200020',3895483,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200020',3895484,'2625','389',186643.83,187494.57,850.74,138670.62,0.00,0.00,0.00,0.00,0.00),('1','167','884','200020',3895485,'2626','389',127666.73,128358.06,691.33,112686.79,0.00,0.00,0.00,0.00,0.00),('1','167','884','200020',3895486,'2627','389',89277.17,90393.59,1115.62,181846.06,0.00,0.00,0.80,0.00,0.00),('1','167','884','200020',3895487,'2628','389',158304.43,159136.45,832.02,135619.26,0.00,0.00,0.00,0.00,0.00),('1','167','885','200020',3895488,'2629','389',113284.06,113918.67,634.61,103441.43,0.00,0.00,0.00,0.00,0.00),('1','167','885','200020',3895489,'2630','389',52001.80,52001.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200020',3895490,'2631','389',124821.17,125444.46,623.29,101596.27,0.00,0.00,0.00,0.00,0.00),('1','167','885','200020',3895491,'2632','389',63286.80,63824.01,537.21,87565.23,0.00,0.00,0.00,0.00,0.00),('1','167','886','200020',3895492,'2633','389',85896.66,86233.74,337.08,54944.04,0.00,0.00,0.00,0.00,0.00),('1','167','886','200020',3895493,'2634','389',82344.48,82636.00,291.52,47517.76,0.00,0.00,0.00,0.00,0.00),('1','167','886','200020',3895494,'2635','389',87907.17,88248.16,340.99,55581.37,0.00,0.00,0.00,0.00,0.00),('1','167','886','200020',3895495,'2636','389',45434.72,45434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200020',3895496,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200020',3895497,'2638','389',233218.00,234145.21,927.21,151135.23,0.00,0.00,0.00,0.00,0.00),('1','167','887','200020',3895498,'2639','389',175791.65,176438.00,646.35,105355.05,0.00,0.00,0.00,0.00,0.00),('1','167','887','200020',3895499,'2640','389',166347.20,166830.17,482.97,78724.11,0.00,0.00,0.00,0.00,0.00),('1','167','888','200020',3895500,'2641','390',496970.66,498561.47,1590.81,413610.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','200020',3895501,'2642','390',323189.42,324434.34,1244.92,323679.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','200020',3895502,'2643','390',509363.72,511209.39,1845.67,479874.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','200020',3895503,'2644','390',390154.38,390154.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200020',3895504,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200020',3895505,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896089,'2605','389',113542.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896090,'2606','389',96888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896091,'2607','389',153935.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896092,'2608','389',53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896093,'2609','389',102944.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200054',3896094,'2610','389',116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896095,'2611','389',164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896096,'2612','389',250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896097,'2613','389',105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896098,'2614','389',172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896099,'2615','389',88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200054',3896100,'2616','389',144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200054',3896101,'2617','389',197335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200054',3896102,'2618','389',106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200054',3896103,'2619','389',187249.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200054',3896104,'2620','389',129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200054',3896105,'2621','389',44518.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200054',3896106,'2622','389',147398.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200054',3896107,'2623','389',152931.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200054',3896108,'2624','389',59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200054',3896109,'2625','389',187494.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200054',3896110,'2626','389',128358.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200054',3896111,'2627','389',90393.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200054',3896112,'2628','389',159136.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200054',3896113,'2629','389',113918.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200054',3896114,'2630','389',52001.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200054',3896115,'2631','389',125444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200054',3896116,'2632','389',63824.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200054',3896117,'2633','389',86233.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200054',3896118,'2634','389',82636.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200054',3896119,'2635','389',88248.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200054',3896120,'2636','389',45434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200054',3896121,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200054',3896122,'2638','389',234145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200054',3896123,'2639','389',176438.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200054',3896124,'2640','389',166830.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','200054',3896125,'2641','390',498561.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','200054',3896126,'2642','390',324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200054',3896127,'2643','390',511209.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200054',3896128,'2644','390',390154.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200054',3896129,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200054',3896130,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896183,'2605','389',113542.29,114731.73,1189.44,193878.72,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896184,'2606','389',96888.53,96888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896185,'2607','389',153935.76,154676.56,740.80,120750.40,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896186,'2608','389',53359.98,53359.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896187,'2609','389',102944.62,102944.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200058',3896188,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896189,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896190,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896191,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896192,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896193,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200058',3896194,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200058',3896195,'2617','389',197335.65,197720.79,385.14,62777.82,0.00,0.00,0.00,0.00,0.00),('1','167','882','200058',3896196,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200058',3896197,'2619','389',187249.99,187975.33,725.34,118230.42,0.00,0.00,0.00,0.00,0.00),('1','167','882','200058',3896198,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200058',3896199,'2621','389',44518.31,44518.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200058',3896200,'2622','389',147398.48,148226.82,828.34,135019.42,0.00,0.00,0.00,0.00,0.00),('1','167','883','200058',3896201,'2623','389',152931.78,153893.89,962.11,156823.93,0.00,0.00,0.00,0.00,0.00),('1','167','883','200058',3896202,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200058',3896203,'2625','389',187494.57,187494.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200058',3896204,'2626','389',128358.06,130658.26,2300.20,374932.60,0.00,0.00,0.00,0.00,0.00),('1','167','884','200058',3896205,'2627','389',90393.59,90393.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200058',3896206,'2628','389',159136.45,160512.57,1376.12,224307.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','200058',3896207,'2629','389',113918.67,114693.01,774.34,126217.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','200058',3896208,'2630','389',52001.80,52001.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200058',3896209,'2631','389',125444.46,126488.84,1044.38,170233.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','200058',3896210,'2632','389',63824.01,63824.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200058',3896211,'2633','389',86233.74,86233.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200058',3896212,'2634','389',82636.00,83500.15,864.15,140856.45,0.00,0.00,0.00,0.00,0.00),('1','167','886','200058',3896213,'2635','389',88248.16,88818.22,570.06,92919.78,0.00,0.00,0.00,0.00,0.00),('1','167','886','200058',3896214,'2636','389',45434.72,45434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200058',3896215,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200058',3896216,'2638','389',234145.21,235722.44,1577.23,257088.49,0.00,0.00,0.00,0.00,0.00),('1','167','887','200058',3896217,'2639','389',176438.00,176438.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200058',3896218,'2640','389',166830.17,168062.51,1232.34,200871.42,0.00,0.00,0.00,0.00,0.00),('1','167','888','200058',3896219,'2641','390',498561.47,500774.11,2212.64,586349.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','200058',3896220,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200058',3896221,'2643','390',511209.39,512453.96,1244.57,329811.05,0.00,0.00,0.00,0.00,0.00),('1','167','889','200058',3896222,'2644','390',390154.38,390315.36,160.98,42659.70,0.00,0.00,0.00,0.00,0.00),('1','167','890','200058',3896223,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200058',3896224,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898922,'2605','389',114731.73,115571.18,839.45,136830.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898923,'2606','389',96888.53,96888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898924,'2607','389',154676.56,155440.74,764.18,124561.34,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898925,'2608','389',53359.98,53390.76,30.78,5017.14,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898926,'2609','389',102944.62,103533.43,588.81,95976.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','200216',3898927,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898928,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898929,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898930,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898931,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898932,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200216',3898933,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200216',3898934,'2617','389',197720.79,198214.27,493.48,80437.24,0.00,0.00,0.00,0.00,0.00),('1','167','882','200216',3898935,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200216',3898936,'2619','389',187975.33,188378.10,402.77,65651.51,0.00,0.00,0.00,0.00,0.00),('1','167','882','200216',3898937,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200216',3898938,'2621','389',44518.31,44725.07,206.76,33701.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','200216',3898939,'2622','389',148226.82,148548.54,321.72,52440.36,0.00,0.00,0.00,0.00,0.00),('1','167','883','200216',3898940,'2623','389',153893.89,154148.90,255.01,41566.63,0.00,0.00,0.00,0.00,0.00),('1','167','883','200216',3898941,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200216',3898942,'2625','389',187494.57,188305.47,810.90,132176.70,0.00,0.00,0.00,0.00,0.00),('1','167','884','200216',3898943,'2626','389',130658.26,131463.09,804.83,131187.29,0.00,0.00,0.00,0.00,0.00),('1','167','884','200216',3898944,'2627','389',90393.59,90969.94,576.35,93945.05,0.00,0.00,0.00,0.00,0.00),('1','167','884','200216',3898945,'2628','389',160512.57,161124.57,612.00,99756.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200216',3898946,'2629','389',114693.01,115092.16,399.15,65061.45,0.00,0.00,0.00,0.00,0.00),('1','167','885','200216',3898947,'2630','389',52001.80,52284.21,282.41,46032.83,0.00,0.00,0.00,0.00,0.00),('1','167','885','200216',3898948,'2631','389',126488.84,127049.98,561.14,91465.82,0.00,0.00,0.00,0.00,0.00),('1','167','885','200216',3898949,'2632','389',63824.01,63824.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200216',3898950,'2633','389',86233.74,86233.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200216',3898951,'2634','389',83500.15,83840.53,340.38,55481.94,0.00,0.00,0.00,0.00,0.00),('1','167','886','200216',3898952,'2635','389',88818.22,89102.89,284.67,46401.21,0.00,0.00,0.00,0.00,0.00),('1','167','886','200216',3898953,'2636','389',45434.72,45754.28,319.56,52088.28,0.00,0.00,0.00,0.00,0.00),('1','167','887','200216',3898954,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200216',3898955,'2638','389',235722.44,236616.24,893.80,145689.40,0.00,0.00,0.00,0.00,0.00),('1','167','887','200216',3898956,'2639','389',176438.00,176970.26,532.26,86758.38,0.00,0.00,0.00,0.00,0.00),('1','167','887','200216',3898957,'2640','389',168062.51,168445.59,383.08,62442.04,0.00,0.00,0.00,0.00,0.00),('1','167','888','200216',3898958,'2641','390',500774.11,503717.92,2943.81,780109.65,0.00,0.00,0.00,0.00,0.00),('1','167','888','200216',3898959,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200216',3898960,'2643','390',512453.96,513087.53,633.57,167896.05,0.00,0.00,0.00,0.00,0.00),('1','167','889','200216',3898961,'2644','390',390315.36,391081.12,765.76,202926.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','200216',3898962,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200216',3898963,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901336,'2605','389',115571.18,116680.01,1108.83,180739.29,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901337,'2606','389',96888.53,96888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901338,'2607','389',155440.74,156462.46,1021.72,166540.36,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901339,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901340,'2609','389',103533.43,103985.71,452.28,73721.64,0.00,0.00,0.00,0.00,0.00),('1','167','880','200362',3901341,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901342,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901343,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901344,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901345,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901346,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200362',3901347,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200362',3901348,'2617','389',198214.27,198214.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200362',3901349,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200362',3901350,'2619','389',188378.10,188938.99,560.89,91425.07,0.00,0.00,0.00,0.00,0.00),('1','167','882','200362',3901351,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200362',3901352,'2621','389',44725.07,45917.62,1192.55,194385.65,0.00,0.00,0.00,0.00,0.00),('1','167','883','200362',3901353,'2622','389',148548.54,148548.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200362',3901354,'2623','389',154148.90,154819.06,670.16,109236.08,0.00,0.00,0.00,0.00,0.00),('1','167','883','200362',3901355,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200362',3901356,'2625','389',188305.47,188305.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200362',3901357,'2626','389',131463.09,133066.74,1603.65,261394.95,0.00,0.00,0.00,0.00,0.00),('1','167','884','200362',3901358,'2627','389',90969.94,90969.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200362',3901359,'2628','389',161124.57,162141.92,1017.35,165828.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','200362',3901360,'2629','389',115092.16,115092.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200362',3901361,'2630','389',52284.21,52937.96,653.75,106561.25,0.00,0.00,0.00,0.00,0.00),('1','167','885','200362',3901362,'2631','389',127049.98,128035.51,985.53,160641.39,0.00,0.00,0.00,0.00,0.00),('1','167','885','200362',3901363,'2632','389',63824.01,63824.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200362',3901364,'2633','389',86233.74,86233.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200362',3901365,'2634','389',83840.53,84547.02,706.49,115157.87,0.00,0.00,0.00,0.00,0.00),('1','167','886','200362',3901366,'2635','389',89102.89,89774.20,671.31,109423.53,0.00,0.00,0.00,0.00,0.00),('1','167','886','200362',3901367,'2636','389',45754.28,45754.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200362',3901368,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200362',3901369,'2638','389',236616.24,238468.42,1852.18,301905.34,0.00,0.00,0.00,0.00,0.00),('1','167','887','200362',3901370,'2639','389',176970.26,177872.08,901.82,146996.66,0.00,0.00,0.00,0.00,0.00),('1','167','887','200362',3901371,'2640','389',168445.59,168445.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','200362',3901372,'2641','390',503717.92,505488.11,1770.19,469100.35,0.00,0.00,0.00,0.00,0.00),('1','167','888','200362',3901373,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200362',3901374,'2643','390',513087.53,514981.28,1893.75,501843.75,0.00,0.00,0.00,0.00,0.00),('1','167','889','200362',3901375,'2644','390',391081.12,391081.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200362',3901376,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200362',3901377,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902108,'2605','389',116680.01,117638.12,958.11,156171.93,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902109,'2606','389',96888.53,97303.69,415.16,67671.08,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902110,'2607','389',156462.46,156821.15,358.69,58466.47,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902111,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902112,'2609','389',103985.71,104263.25,277.54,45239.02,0.00,0.00,0.00,0.00,0.00),('1','167','880','200401',3902113,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902114,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902115,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902116,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902117,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902118,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200401',3902119,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200401',3902120,'2617','389',198214.27,198870.01,655.74,106885.62,0.00,0.00,0.00,0.00,0.00),('1','167','882','200401',3902121,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200401',3902122,'2619','389',188938.99,189294.12,355.13,57886.19,0.00,0.00,0.00,0.00,0.00),('1','167','882','200401',3902123,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200401',3902124,'2621','389',45917.62,46374.60,456.98,74487.74,0.00,0.00,0.00,0.00,0.00),('1','167','883','200401',3902125,'2622','389',148548.54,148994.69,446.15,72722.45,0.00,0.00,0.00,0.00,0.00),('1','167','883','200401',3902126,'2623','389',154819.06,155229.92,410.86,66970.18,0.00,0.00,0.00,0.00,0.00),('1','167','883','200401',3902127,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200401',3902128,'2625','389',188305.47,188991.35,685.88,111798.44,0.00,0.00,0.00,0.00,0.00),('1','167','884','200401',3902129,'2626','389',133066.74,133481.41,414.67,67591.21,0.00,0.00,0.00,0.00,0.00),('1','167','884','200401',3902130,'2627','389',90969.94,91379.30,409.36,66725.68,0.00,0.00,0.00,0.00,0.00),('1','167','884','200401',3902131,'2628','389',162141.92,162698.06,556.14,90650.82,0.00,0.00,0.00,0.00,0.00),('1','167','885','200401',3902132,'2629','389',115092.16,115358.56,266.40,43423.20,0.00,0.00,0.00,0.00,0.00),('1','167','885','200401',3902133,'2630','389',52937.96,53198.67,260.71,42495.73,0.00,0.00,0.00,0.00,0.00),('1','167','885','200401',3902134,'2631','389',128035.51,128389.33,353.82,57672.66,0.00,0.00,0.00,0.00,0.00),('1','167','885','200401',3902135,'2632','389',63824.01,64263.79,439.78,71684.14,0.00,0.00,0.00,0.00,0.00),('1','167','886','200401',3902136,'2633','389',86233.74,86645.03,411.29,67040.27,0.00,0.00,0.00,0.00,0.00),('1','167','886','200401',3902137,'2634','389',84547.02,84547.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200401',3902138,'2635','389',89774.20,90056.88,282.68,46076.84,0.00,0.00,0.00,0.00,0.00),('1','167','886','200401',3902139,'2636','389',45754.28,45754.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200401',3902140,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200401',3902141,'2638','389',238468.42,239873.97,1405.55,229104.65,0.00,0.00,0.00,0.00,0.00),('1','167','887','200401',3902142,'2639','389',177872.08,178666.26,794.18,129451.34,0.00,0.00,0.00,0.00,0.00),('1','167','887','200401',3902143,'2640','389',168445.59,168980.34,534.75,87164.25,0.00,0.00,0.00,0.00,0.00),('1','167','888','200401',3902144,'2641','390',505488.11,508447.13,2959.02,784140.30,0.00,0.00,0.00,0.00,0.00),('1','167','888','200401',3902145,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200401',3902146,'2643','390',514981.28,516447.06,1465.78,388431.70,0.00,0.00,0.00,0.00,0.00),('1','167','889','200401',3902147,'2644','390',391081.12,392252.32,1171.20,310368.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200401',3902148,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200401',3902149,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905394,'2605','389',117638.12,117638.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905395,'2606','389',97303.69,98226.58,922.89,150431.07,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905396,'2607','389',156821.15,157445.60,624.45,101785.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905397,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905398,'2609','389',104263.25,105075.32,812.07,132367.41,0.00,0.00,0.00,0.00,0.00),('1','167','880','200581',3905399,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905400,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905401,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905402,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905403,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905404,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200581',3905405,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200581',3905406,'2617','389',198870.01,198870.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200581',3905407,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200581',3905408,'2619','389',189294.12,189294.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200581',3905409,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200581',3905410,'2621','389',46374.60,46374.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200581',3905411,'2622','389',148994.69,149849.36,854.67,139311.21,0.00,0.00,0.00,0.00,0.00),('1','167','883','200581',3905412,'2623','389',155229.92,155936.30,706.38,115139.94,0.00,0.00,0.00,0.00,0.00),('1','167','883','200581',3905413,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200581',3905414,'2625','389',188991.35,188991.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200581',3905415,'2626','389',133481.41,134681.28,1199.87,195578.81,0.00,0.00,0.00,0.00,0.00),('1','167','884','200581',3905416,'2627','389',91379.30,91379.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200581',3905417,'2628','389',162698.06,163830.08,1132.02,184519.26,0.00,0.00,0.00,0.00,0.00),('1','167','885','200581',3905418,'2629','389',115358.56,115358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200581',3905419,'2630','389',53198.67,53718.79,520.12,84779.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','200581',3905420,'2631','389',128389.33,129267.58,878.25,143154.75,0.00,0.00,0.00,0.00,0.00),('1','167','885','200581',3905421,'2632','389',64263.79,64263.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200581',3905422,'2633','389',86645.03,86645.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200581',3905423,'2634','389',84547.02,85237.94,690.92,112619.96,0.00,0.00,0.00,0.00,0.00),('1','167','886','200581',3905424,'2635','389',90056.88,90801.12,744.24,121311.12,0.00,0.00,0.00,0.00,0.00),('1','167','886','200581',3905425,'2636','389',45754.28,45754.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200581',3905426,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200581',3905427,'2638','389',239873.97,240891.59,1017.62,165872.06,0.00,0.00,0.00,0.00,0.00),('1','167','887','200581',3905428,'2639','389',178666.26,178666.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200581',3905429,'2640','389',168980.34,169883.89,903.55,147278.65,0.00,0.00,0.00,0.00,0.00),('1','167','888','200581',3905430,'2641','390',508447.13,510272.79,1825.66,483799.90,0.00,0.00,0.00,0.00,0.00),('1','167','888','200581',3905431,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200581',3905432,'2643','390',516447.06,517832.53,1385.47,367149.55,0.00,0.00,0.00,0.00,0.00),('1','167','889','200581',3905433,'2644','390',392252.32,392252.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200581',3905434,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200581',3905435,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907037,'2605','389',117638.12,118119.54,481.42,78471.46,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907038,'2606','389',98226.58,98786.75,560.17,91307.71,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907039,'2607','389',157445.60,158222.70,777.10,126667.30,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907040,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907041,'2609','389',105075.32,105363.70,288.38,47005.94,0.00,0.00,0.00,0.00,0.00),('1','167','880','200658',3907042,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907043,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907044,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907045,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907046,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907047,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200658',3907048,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200658',3907049,'2617','389',198870.01,199371.19,501.18,81692.34,0.00,0.00,0.00,0.00,0.00),('1','167','882','200658',3907050,'2618','389',106346.98,106346.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200658',3907051,'2619','389',189294.12,189663.21,369.09,60161.67,0.00,0.00,0.00,0.00,0.00),('1','167','882','200658',3907052,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200658',3907053,'2621','389',46374.60,46688.92,314.32,51234.16,0.00,0.00,0.00,0.00,0.00),('1','167','883','200658',3907054,'2622','389',149849.36,150312.94,463.58,75563.54,0.00,0.00,0.00,0.00,0.00),('1','167','883','200658',3907055,'2623','389',155936.30,156405.62,469.32,76499.16,0.00,0.00,0.00,0.00,0.00),('1','167','883','200658',3907056,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200658',3907057,'2625','389',188991.35,189945.60,954.25,155542.75,0.00,0.00,0.00,0.00,0.00),('1','167','884','200658',3907058,'2626','389',134681.28,135447.97,766.69,124970.47,0.00,0.00,0.00,0.00,0.00),('1','167','884','200658',3907059,'2627','389',91379.30,91995.92,616.62,100509.06,0.00,0.00,0.00,0.00,0.00),('1','167','884','200658',3907060,'2628','389',163830.08,164443.30,613.22,99954.86,0.00,0.00,0.00,0.00,0.00),('1','167','885','200658',3907061,'2629','389',115358.56,115726.97,368.41,60050.83,0.00,0.00,0.00,0.00,0.00),('1','167','885','200658',3907062,'2630','389',53718.79,53718.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200658',3907063,'2631','389',129267.58,129707.96,440.38,71781.94,0.00,0.00,0.00,0.00,0.00),('1','167','885','200658',3907064,'2632','389',64263.79,64701.80,438.01,71395.63,0.00,0.00,0.00,0.00,0.00),('1','167','886','200658',3907065,'2633','389',86645.03,87195.04,550.01,89651.63,0.00,0.00,0.00,0.00,0.00),('1','167','886','200658',3907066,'2634','389',85237.94,85237.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200658',3907067,'2635','389',90801.12,90801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200658',3907068,'2636','389',45754.28,46201.68,447.40,72926.20,0.00,0.00,0.00,0.00,0.00),('1','167','887','200658',3907069,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200658',3907070,'2638','389',240891.59,241897.61,1006.02,163981.26,0.00,0.00,0.00,0.00,0.00),('1','167','887','200658',3907071,'2639','389',178666.26,179136.65,470.39,76673.57,0.00,0.00,0.00,0.00,0.00),('1','167','887','200658',3907072,'2640','389',169883.89,170689.26,805.37,131275.31,0.00,0.00,0.00,0.00,0.00),('1','167','888','200658',3907073,'2641','390',510272.79,511848.36,1575.57,417526.05,0.00,0.00,0.00,0.00,0.00),('1','167','888','200658',3907074,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200658',3907075,'2643','390',517832.53,519792.00,1959.47,519259.55,0.00,0.00,0.00,0.00,0.00),('1','167','889','200658',3907076,'2644','390',392252.32,394416.66,2164.34,573550.10,0.00,0.00,0.00,0.00,0.00),('1','167','890','200658',3907077,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200658',3907078,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910505,'2605','389',118119.54,118119.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910506,'2606','389',98786.75,99482.07,695.32,113337.16,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910507,'2607','389',158222.70,158753.87,531.17,86580.71,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910508,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910509,'2609','389',105363.70,105784.58,420.88,68603.44,0.00,0.00,0.00,0.00,0.00),('1','167','880','200857',3910510,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910511,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910512,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910513,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910514,'2614','389',172674.52,172674.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910515,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200857',3910516,'2616','389',144498.18,144498.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200857',3910517,'2617','389',199371.19,199371.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200857',3910518,'2618','389',106346.98,106843.01,496.03,80852.89,0.00,0.00,0.00,0.00,0.00),('1','167','882','200857',3910519,'2619','389',189663.21,190123.80,460.59,75076.17,0.00,0.00,0.00,0.00,0.00),('1','167','882','200857',3910520,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200857',3910521,'2621','389',46688.92,46688.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200857',3910522,'2622','389',150312.94,150865.70,552.76,90099.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','200857',3910523,'2623','389',156405.62,157406.85,1001.23,163200.49,0.00,0.00,0.00,0.00,0.00),('1','167','883','200857',3910524,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200857',3910525,'2625','389',189945.60,190653.28,707.68,115351.84,0.00,0.00,0.00,0.00,0.00),('1','167','884','200857',3910526,'2626','389',135447.97,136708.58,1260.61,205479.43,0.00,0.00,0.00,0.00,0.00),('1','167','884','200857',3910527,'2627','389',91995.92,92380.25,384.33,62645.79,0.00,0.00,0.00,0.00,0.00),('1','167','884','200857',3910528,'2628','389',164443.30,165045.03,601.73,98081.99,0.00,0.00,0.00,0.00,0.00),('1','167','885','200857',3910529,'2629','389',115726.97,116496.87,769.90,125493.70,0.00,0.00,0.00,0.00,0.00),('1','167','885','200857',3910530,'2630','389',53718.79,53718.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200857',3910531,'2631','389',129707.96,130209.67,501.71,81778.73,0.00,0.00,0.00,0.00,0.00),('1','167','885','200857',3910532,'2632','389',64701.80,64701.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200857',3910533,'2633','389',87195.04,87764.03,568.99,92745.37,0.00,0.00,0.00,0.00,0.00),('1','167','886','200857',3910534,'2634','389',85237.94,85237.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200857',3910535,'2635','389',90801.12,90801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200857',3910536,'2636','389',46201.68,46901.73,700.05,114108.15,0.00,0.00,0.00,0.00,0.00),('1','167','887','200857',3910537,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200857',3910538,'2638','389',241897.61,243087.35,1189.74,193927.62,0.00,0.00,0.00,0.00,0.00),('1','167','887','200857',3910539,'2639','389',179136.65,179136.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200857',3910540,'2640','389',170689.26,171353.85,664.59,108328.17,0.00,0.00,0.00,0.00,0.00),('1','167','888','200857',3910541,'2641','390',511848.36,515646.39,3798.03,1006477.95,0.00,0.00,0.00,0.00,0.00),('1','167','888','200857',3910542,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200857',3910543,'2643','390',519792.00,522505.13,2713.13,718979.45,0.00,0.00,0.00,0.00,0.00),('1','167','889','200857',3910544,'2644','390',394416.66,395183.89,767.23,203315.95,0.00,0.00,0.00,0.00,0.00),('1','167','890','200857',3910545,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200857',3910546,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910706,'2605','389',118119.54,118119.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910707,'2606','389',99482.07,100716.55,1234.48,201220.24,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910708,'2607','389',158753.87,159353.17,599.30,97685.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910709,'2608','389',53390.76,53390.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910710,'2609','389',105784.58,106048.23,263.65,42974.95,0.00,0.00,0.00,0.00,0.00),('1','167','880','200867',3910711,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910712,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910713,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910714,'2613','389',105974.85,105974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910715,'2614','389',172674.52,172683.13,8.61,1403.43,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910716,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','200867',3910717,'2616','389',144498.18,144549.86,51.68,8423.84,0.00,0.00,0.00,0.00,0.00),('1','167','882','200867',3910718,'2617','389',199371.19,199711.31,340.12,55439.56,0.00,0.00,0.00,0.00,0.00),('1','167','882','200867',3910719,'2618','389',106843.01,106843.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','200867',3910720,'2619','389',190123.80,190426.82,303.02,49392.26,0.00,0.00,0.00,0.00,0.00),('1','167','882','200867',3910721,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200867',3910722,'2621','389',46688.92,46688.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','200867',3910723,'2622','389',150865.70,151454.03,588.33,95897.79,0.00,0.00,0.00,0.00,0.00),('1','167','883','200867',3910724,'2623','389',157406.85,158107.65,700.80,114230.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','200867',3910725,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','200867',3910726,'2625','389',190653.28,191316.37,663.09,108083.67,0.00,0.00,0.00,0.00,0.00),('1','167','884','200867',3910727,'2626','389',136708.58,137706.98,998.40,162739.20,0.00,0.00,0.00,0.00,0.00),('1','167','884','200867',3910728,'2627','389',92380.25,93071.86,691.61,112732.43,0.00,0.00,0.00,0.00,0.00),('1','167','884','200867',3910729,'2628','389',165045.03,165361.32,316.29,51555.27,0.00,0.00,0.00,0.00,0.00),('1','167','885','200867',3910730,'2629','389',116496.87,116496.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','200867',3910731,'2630','389',53718.79,54725.36,1006.57,164070.91,0.00,0.00,0.00,0.00,0.00),('1','167','885','200867',3910732,'2631','389',130209.67,130853.93,644.26,105014.38,0.00,0.00,0.00,0.00,0.00),('1','167','885','200867',3910733,'2632','389',64701.80,64701.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200867',3910734,'2633','389',87764.03,87764.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','200867',3910735,'2634','389',85237.94,85717.85,479.91,78225.33,0.00,0.00,0.00,0.00,0.00),('1','167','886','200867',3910736,'2635','389',90801.12,91284.60,483.48,78807.24,0.00,0.00,0.00,0.00,0.00),('1','167','886','200867',3910737,'2636','389',46901.73,46901.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200867',3910738,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200867',3910739,'2638','389',243087.35,244139.64,1052.29,171523.27,0.00,0.00,0.00,0.00,0.00),('1','167','887','200867',3910740,'2639','389',179136.65,179136.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','200867',3910741,'2640','389',171353.85,172314.01,960.16,156506.08,0.00,0.00,0.00,0.00,0.00),('1','167','888','200867',3910742,'2641','390',515646.39,518159.37,2512.98,665939.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','200867',3910743,'2642','390',324434.34,324434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200867',3910744,'2643','390',522505.13,523961.73,1456.60,385999.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','200867',3910745,'2644','390',395183.89,396257.87,1073.98,284604.70,0.00,0.00,0.00,0.00,0.00),('1','167','890','200867',3910746,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','200867',3910747,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913585,'2605','389',118119.54,120017.77,1898.23,309411.49,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913586,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913587,'2607','389',159353.17,159353.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913588,'2608','389',53390.76,53780.33,389.57,63499.91,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913589,'2609','389',106048.23,106497.53,449.30,73235.90,0.00,0.00,0.00,0.00,0.00),('1','167','880','201048',3913590,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913591,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913592,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913593,'2613','389',105974.85,106431.25,456.40,74393.20,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913594,'2614','389',172683.13,173512.03,828.90,135110.70,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913595,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201048',3913596,'2616','389',144549.86,145334.58,784.72,127909.36,0.00,0.00,0.00,0.00,0.00),('1','167','882','201048',3913597,'2617','389',199711.31,200086.64,375.33,61178.79,0.00,0.00,0.00,0.00,0.00),('1','167','882','201048',3913598,'2618','389',106843.01,106843.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201048',3913599,'2619','389',190426.82,191018.25,591.43,96403.09,0.00,0.00,0.00,0.00,0.00),('1','167','882','201048',3913600,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201048',3913601,'2621','389',46688.92,46688.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201048',3913602,'2622','389',151454.03,151964.96,510.93,83281.59,0.00,0.00,0.00,0.00,0.00),('1','167','883','201048',3913603,'2623','389',158107.65,158683.17,575.52,93809.76,0.00,0.00,0.00,0.00,0.00),('1','167','883','201048',3913604,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201048',3913605,'2625','389',191316.37,192100.37,784.00,127792.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201048',3913606,'2626','389',137706.98,138568.37,861.39,140406.57,0.00,0.00,0.00,0.00,0.00),('1','167','884','201048',3913607,'2627','389',93071.86,93728.98,657.12,107110.56,0.00,0.00,0.00,0.00,0.00),('1','167','884','201048',3913608,'2628','389',165361.32,166220.91,859.59,140113.17,0.00,0.00,0.00,0.00,0.00),('1','167','885','201048',3913609,'2629','389',116496.87,116496.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201048',3913610,'2630','389',54725.36,54798.17,72.81,11868.03,0.00,0.00,0.00,0.00,0.00),('1','167','885','201048',3913611,'2631','389',130853.93,131431.69,577.76,94174.88,0.00,0.00,0.00,0.00,0.00),('1','167','885','201048',3913612,'2632','389',64701.80,64701.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201048',3913613,'2633','389',87764.03,88492.76,728.73,118782.99,0.00,0.00,0.00,0.00,0.00),('1','167','886','201048',3913614,'2634','389',85717.85,86288.73,570.88,93053.44,0.00,0.00,0.00,0.00,0.00),('1','167','886','201048',3913615,'2635','389',91284.60,91807.92,523.32,85301.16,0.00,0.00,0.00,0.00,0.00),('1','167','886','201048',3913616,'2636','389',46901.73,46901.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201048',3913617,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201048',3913618,'2638','389',244139.64,244990.06,850.42,138618.46,0.00,0.00,0.00,0.00,0.00),('1','167','887','201048',3913619,'2639','389',179136.65,179289.10,152.45,24849.35,0.00,0.00,0.00,0.00,0.00),('1','167','887','201048',3913620,'2640','389',172314.01,173005.30,691.29,112680.27,0.00,0.00,0.00,0.00,0.00),('1','167','888','201048',3913621,'2641','390',518159.37,518744.46,585.09,155048.85,0.00,0.00,0.00,0.00,0.00),('1','167','888','201048',3913622,'2642','390',324434.34,325251.39,817.05,216518.25,0.00,0.00,0.00,0.00,0.00),('1','167','889','201048',3913623,'2643','390',523961.73,525141.92,1180.19,312750.35,0.00,0.00,0.00,0.00,0.00),('1','167','889','201048',3913624,'2644','390',396257.87,397165.70,907.83,240574.95,0.00,0.00,0.00,0.00,0.00),('1','167','890','201048',3913625,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201048',3913626,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913770,'2605','389',120017.77,120546.39,528.62,86165.06,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913771,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913772,'2607','389',159353.17,159812.52,459.35,74874.05,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913773,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913774,'2609','389',106497.53,106825.34,327.81,53433.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','201059',3913775,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913776,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913777,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913778,'2613','389',106431.25,107242.02,810.77,132155.51,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913779,'2614','389',173512.03,173512.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913780,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201059',3913781,'2616','389',145334.58,145971.11,636.53,103754.39,0.00,0.00,0.00,0.00,0.00),('1','167','882','201059',3913782,'2617','389',200086.64,200195.46,108.82,17737.66,0.00,0.00,0.00,0.00,0.00),('1','167','882','201059',3913783,'2618','389',106843.01,106843.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201059',3913784,'2619','389',191018.25,191205.08,186.83,30453.29,0.00,0.00,0.00,0.00,0.00),('1','167','882','201059',3913785,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201059',3913786,'2621','389',46688.92,46976.69,287.77,46906.51,0.00,0.00,0.00,0.00,0.00),('1','167','883','201059',3913787,'2622','389',151964.96,152357.42,392.46,63970.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','201059',3913788,'2623','389',158683.17,158919.91,236.74,38588.62,0.00,0.00,0.00,0.00,0.00),('1','167','883','201059',3913789,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201059',3913790,'2625','389',192100.37,192759.15,658.78,107381.14,0.00,0.00,0.00,0.00,0.00),('1','167','884','201059',3913791,'2626','389',138568.37,139464.88,896.51,146131.13,0.00,0.00,0.00,0.00,0.00),('1','167','884','201059',3913792,'2627','389',93728.98,93728.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201059',3913793,'2628','389',166220.91,167066.19,845.28,137780.64,0.00,0.00,0.00,0.00,0.00),('1','167','885','201059',3913794,'2629','389',116496.87,116911.87,415.00,67645.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201059',3913795,'2630','389',54798.17,54798.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201059',3913796,'2631','389',131431.69,131999.62,567.93,92572.59,0.00,0.00,0.00,0.00,0.00),('1','167','885','201059',3913797,'2632','389',64701.80,64701.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201059',3913798,'2633','389',88492.76,89056.24,563.48,91847.24,0.00,0.00,0.00,0.00,0.00),('1','167','886','201059',3913799,'2634','389',86288.73,86726.12,437.39,71294.57,0.00,0.00,0.00,0.00,0.00),('1','167','886','201059',3913800,'2635','389',91807.92,92054.35,246.43,40168.09,0.00,0.00,0.00,0.00,0.00),('1','167','886','201059',3913801,'2636','389',46901.73,46901.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201059',3913802,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201059',3913803,'2638','389',244990.06,246005.55,1015.49,165524.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','201059',3913804,'2639','389',179289.10,179289.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201059',3913805,'2640','389',173005.30,173716.76,711.46,115967.98,0.00,0.00,0.00,0.00,0.00),('1','167','888','201059',3913806,'2641','390',518744.46,520458.62,1714.16,454252.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','201059',3913807,'2642','390',325251.39,325506.90,255.51,67710.15,0.00,0.00,0.00,0.00,0.00),('1','167','889','201059',3913808,'2643','390',525141.92,527175.50,2033.58,538898.70,0.00,0.00,0.00,0.00,0.00),('1','167','889','201059',3913809,'2644','390',397165.70,397507.78,342.08,90651.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','201059',3913810,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201059',3913811,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917350,'2605','389',120546.39,121031.87,485.48,79133.24,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917351,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917352,'2607','389',159812.52,160528.54,716.02,116711.26,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917353,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917354,'2609','389',106825.34,107294.92,469.58,76541.54,0.00,0.00,0.00,0.00,0.00),('1','167','880','201268',3917355,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917356,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917357,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917358,'2613','389',107242.02,109013.77,1771.75,288795.25,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917359,'2614','389',173512.03,173512.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917360,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201268',3917361,'2616','389',145971.11,146785.87,814.76,132805.88,0.00,0.00,0.00,0.00,0.00),('1','167','882','201268',3917362,'2617','389',200195.46,200195.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201268',3917363,'2618','389',106843.01,107576.22,733.21,119513.23,0.00,0.00,0.00,0.00,0.00),('1','167','882','201268',3917364,'2619','389',191205.08,191592.66,387.58,63175.54,0.00,0.00,0.00,0.00,0.00),('1','167','882','201268',3917365,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201268',3917366,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201268',3917367,'2622','389',152357.42,152720.47,363.05,59177.15,0.00,0.00,0.00,0.00,0.00),('1','167','883','201268',3917368,'2623','389',158919.91,159236.04,316.13,51529.19,0.00,0.00,0.00,0.00,0.00),('1','167','883','201268',3917369,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201268',3917370,'2625','389',192759.15,194087.07,1327.92,216450.96,0.00,0.00,0.00,0.00,0.00),('1','167','884','201268',3917371,'2626','389',139464.88,140300.42,835.54,136193.02,0.00,0.00,0.00,0.00,0.00),('1','167','884','201268',3917372,'2627','389',93728.98,94333.64,604.66,98559.58,0.00,0.00,0.00,0.00,0.00),('1','167','884','201268',3917373,'2628','389',167066.19,167689.55,623.36,101607.68,0.00,0.00,0.00,0.00,0.00),('1','167','885','201268',3917374,'2629','389',116911.87,117328.53,416.66,67915.58,0.00,0.00,0.00,0.00,0.00),('1','167','885','201268',3917375,'2630','389',54798.17,55273.05,474.88,77405.44,0.00,0.00,0.00,0.00,0.00),('1','167','885','201268',3917376,'2631','389',131999.62,132477.72,478.10,77930.30,0.00,0.00,0.00,0.00,0.00),('1','167','885','201268',3917377,'2632','389',64701.80,65127.11,425.31,69325.53,0.00,0.00,0.00,0.00,0.00),('1','167','886','201268',3917378,'2633','389',89056.24,89600.12,543.88,88652.44,0.00,0.00,0.00,0.00,0.00),('1','167','886','201268',3917379,'2634','389',86726.12,87248.61,522.49,85165.87,0.00,0.00,0.00,0.00,0.00),('1','167','886','201268',3917380,'2635','389',92054.35,92545.53,491.18,80062.34,0.00,0.00,0.00,0.00,0.00),('1','167','886','201268',3917381,'2636','389',46901.73,47378.09,476.36,77646.68,0.00,0.00,0.00,0.00,0.00),('1','167','887','201268',3917382,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201268',3917383,'2638','389',246005.55,246005.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201268',3917384,'2639','389',179289.10,179289.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201268',3917385,'2640','389',173716.76,173716.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201268',3917386,'2641','390',520458.62,522580.81,2122.19,562380.35,0.00,0.00,0.00,0.00,0.00),('1','167','888','201268',3917387,'2642','390',325506.90,326932.10,1425.20,377678.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201268',3917388,'2643','390',527175.50,527960.24,784.74,207956.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','201268',3917389,'2644','390',397507.78,399894.40,2386.62,632454.30,0.00,0.00,0.00,0.00,0.00),('1','167','890','201268',3917390,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201268',3917391,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920697,'2605','389',121031.87,121555.73,523.86,85389.18,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920698,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920699,'2607','389',160528.54,160897.03,368.49,60063.87,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920700,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920701,'2609','389',107294.92,107591.15,296.23,48285.49,0.00,0.00,0.00,0.00,0.00),('1','167','880','201456',3920702,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920703,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920704,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920705,'2613','389',109013.77,110313.81,1300.04,211906.52,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920706,'2614','389',173512.03,173512.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920707,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201456',3920708,'2616','389',146785.87,147500.05,714.18,116411.34,0.00,0.00,0.00,0.00,0.00),('1','167','882','201456',3920709,'2617','389',200195.46,200195.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201456',3920710,'2618','389',107576.22,107820.30,244.08,39785.04,0.00,0.00,0.00,0.00,0.00),('1','167','882','201456',3920711,'2619','389',191592.66,191939.19,346.53,56484.39,0.00,0.00,0.00,0.00,0.00),('1','167','882','201456',3920712,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201456',3920713,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201456',3920714,'2622','389',152720.47,153402.27,681.80,111133.40,0.00,0.00,0.00,0.00,0.00),('1','167','883','201456',3920715,'2623','389',159236.04,159708.85,472.81,77068.03,0.00,0.00,0.00,0.00,0.00),('1','167','883','201456',3920716,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201456',3920717,'2625','389',194087.07,195228.43,1141.36,186041.68,0.00,0.00,0.00,0.00,0.00),('1','167','884','201456',3920718,'2626','389',140300.42,140300.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201456',3920719,'2627','389',94333.64,94844.27,510.63,83232.69,0.00,0.00,0.00,0.00,0.00),('1','167','884','201456',3920720,'2628','389',167689.55,168305.56,616.01,100409.63,0.00,0.00,0.00,0.00,0.00),('1','167','885','201456',3920721,'2629','389',117328.53,117733.92,405.39,66078.57,0.00,0.00,0.00,0.00,0.00),('1','167','885','201456',3920722,'2630','389',55273.05,55273.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201456',3920723,'2631','389',132477.72,133091.16,613.44,99990.72,0.00,0.00,0.00,0.00,0.00),('1','167','885','201456',3920724,'2632','389',65127.11,65127.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201456',3920725,'2633','389',89600.12,90021.95,421.83,68758.29,0.00,0.00,0.00,0.00,0.00),('1','167','886','201456',3920726,'2634','389',87248.61,87248.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201456',3920727,'2635','389',92545.53,93309.43,763.90,124515.70,0.00,0.00,0.00,0.00,0.00),('1','167','886','201456',3920728,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201456',3920729,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201456',3920730,'2638','389',246005.55,247095.02,1089.47,177583.61,0.00,0.00,0.00,0.00,0.00),('1','167','887','201456',3920731,'2639','389',179289.10,179289.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201456',3920732,'2640','389',173716.76,174354.26,637.50,103912.50,0.00,0.00,0.00,0.00,0.00),('1','167','888','201456',3920733,'2641','390',522580.81,525789.99,3209.18,850432.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','201456',3920734,'2642','390',326932.10,326932.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201456',3920735,'2643','390',527960.24,529769.91,1809.67,479562.55,0.00,0.00,0.00,0.00,0.00),('1','167','889','201456',3920736,'2644','390',399894.40,402872.36,2977.96,789159.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','201456',3920737,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201456',3920738,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921051,'2605','389',121555.73,122071.05,515.32,83997.16,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921052,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921053,'2607','389',160897.03,161124.83,227.80,37131.40,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921054,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921055,'2609','389',107591.15,107845.02,253.87,41380.81,0.00,0.00,0.00,0.00,0.00),('1','167','880','201470',3921056,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921057,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921058,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921059,'2613','389',110313.81,111448.83,1135.02,185008.26,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921060,'2614','389',173512.03,174545.43,1033.40,168444.20,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921061,'2615','389',88280.69,88280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201470',3921062,'2616','389',147500.05,148070.44,570.39,92973.57,0.00,0.00,0.00,0.00,0.00),('1','167','882','201470',3921063,'2617','389',200195.46,200417.15,221.69,36135.47,0.00,0.00,0.00,0.00,0.00),('1','167','882','201470',3921064,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201470',3921065,'2619','389',191939.19,192395.54,456.35,74385.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','201470',3921066,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201470',3921067,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201470',3921068,'2622','389',153402.27,153799.81,397.54,64799.02,0.00,0.00,0.00,0.00,0.00),('1','167','883','201470',3921069,'2623','389',159708.85,159988.55,279.70,45591.10,0.00,0.00,0.00,0.00,0.00),('1','167','883','201470',3921070,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201470',3921071,'2625','389',195228.43,195808.73,580.30,94588.90,0.00,0.00,0.00,0.00,0.00),('1','167','884','201470',3921072,'2626','389',140300.42,140909.52,609.10,99283.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','201470',3921073,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201470',3921074,'2628','389',168305.56,168775.65,470.09,76624.67,0.00,0.00,0.00,0.00,0.00),('1','167','885','201470',3921075,'2629','389',117733.92,118186.06,452.14,73698.82,0.00,0.00,0.00,0.00,0.00),('1','167','885','201470',3921076,'2630','389',55273.05,55647.95,374.90,61108.70,0.00,0.00,0.00,0.00,0.00),('1','167','885','201470',3921077,'2631','389',133091.16,133858.33,767.17,125048.71,0.00,0.00,0.00,0.00,0.00),('1','167','885','201470',3921078,'2632','389',65127.11,65127.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201470',3921079,'2633','389',90021.95,90021.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201470',3921080,'2634','389',87248.61,87995.55,746.94,121751.22,0.00,0.00,0.00,0.00,0.00),('1','167','886','201470',3921081,'2635','389',93309.43,93626.38,316.95,51662.85,0.00,0.00,0.00,0.00,0.00),('1','167','886','201470',3921082,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201470',3921083,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201470',3921084,'2638','389',247095.02,248359.90,1264.88,206175.44,0.00,0.00,0.00,0.00,0.00),('1','167','887','201470',3921085,'2639','389',179289.10,179842.42,553.32,90191.16,0.00,0.00,0.00,0.00,0.00),('1','167','887','201470',3921086,'2640','389',174354.26,174942.67,588.41,95910.83,0.00,0.00,0.00,0.00,0.00),('1','167','888','201470',3921087,'2641','390',525789.99,526298.30,508.31,134702.15,0.00,0.00,0.00,0.00,0.00),('1','167','888','201470',3921088,'2642','390',326932.10,328236.83,1304.73,345753.45,0.00,0.00,0.00,0.00,0.00),('1','167','889','201470',3921089,'2643','390',529769.91,530879.15,1109.24,293948.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','201470',3921090,'2644','390',402872.36,403842.83,970.47,257174.55,0.00,0.00,0.00,0.00,0.00),('1','167','890','201470',3921091,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201470',3921092,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921148,'2605','389',122071.05,122604.07,533.02,86882.26,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921149,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921150,'2607','389',161124.83,161332.60,207.77,33866.51,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921151,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921152,'2609','389',107845.02,108123.07,278.05,45322.15,0.00,0.00,0.00,0.00,0.00),('1','167','880','201474',3921153,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921154,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921155,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921156,'2613','389',111448.83,112587.68,1138.85,185632.55,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921157,'2614','389',174545.43,174545.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921158,'2615','389',88280.69,89095.20,814.51,132765.13,0.00,0.00,0.00,0.00,0.00),('1','167','881','201474',3921159,'2616','389',148070.44,148070.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201474',3921160,'2617','389',200417.15,200755.25,338.10,55110.30,0.00,0.00,0.00,0.00,0.00),('1','167','882','201474',3921161,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201474',3921162,'2619','389',192395.54,192670.53,274.99,44823.37,0.00,0.00,0.00,0.00,0.00),('1','167','882','201474',3921163,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201474',3921164,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201474',3921165,'2622','389',153799.81,154198.27,398.46,64948.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','201474',3921166,'2623','389',159988.55,160378.02,389.47,63483.61,0.00,0.00,0.00,0.00,0.00),('1','167','883','201474',3921167,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201474',3921168,'2625','389',195808.73,195808.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201474',3921169,'2626','389',140909.52,142522.98,1613.46,262993.98,0.00,0.00,0.00,0.00,0.00),('1','167','884','201474',3921170,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201474',3921171,'2628','389',168775.65,169677.57,901.92,147012.96,0.00,0.00,0.00,0.00,0.00),('1','167','885','201474',3921172,'2629','389',118186.06,118930.18,744.12,121291.56,0.00,0.00,0.00,0.00,0.00),('1','167','885','201474',3921173,'2630','389',55647.95,55647.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201474',3921174,'2631','389',133858.33,134511.99,653.66,106546.58,0.00,0.00,0.00,0.00,0.00),('1','167','885','201474',3921175,'2632','389',65127.11,65127.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201474',3921176,'2633','389',90021.95,90021.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201474',3921177,'2634','389',87995.55,88670.11,674.56,109953.28,0.00,0.00,0.00,0.00,0.00),('1','167','886','201474',3921178,'2635','389',93626.38,94044.95,418.57,68226.91,0.00,0.00,0.00,0.00,0.00),('1','167','886','201474',3921179,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201474',3921180,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201474',3921181,'2638','389',248359.90,249589.22,1229.32,200379.16,0.00,0.00,0.00,0.00,0.00),('1','167','887','201474',3921182,'2639','389',179842.42,179842.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201474',3921183,'2640','389',174942.67,175635.47,692.80,112926.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','201474',3921184,'2641','390',526298.30,528450.93,2152.63,570446.95,0.00,0.00,0.00,0.00,0.00),('1','167','888','201474',3921185,'2642','390',328236.83,328533.24,296.41,78548.65,0.00,0.00,0.00,0.00,0.00),('1','167','889','201474',3921186,'2643','390',530879.15,531957.60,1078.45,285789.25,0.00,0.00,0.00,0.00,0.00),('1','167','889','201474',3921187,'2644','390',403842.83,405173.43,1330.60,352609.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201474',3921188,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201474',3921189,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921202,'2605','389',122604.07,123268.92,664.85,108370.55,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921203,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921204,'2607','389',161332.60,161817.14,484.54,78980.02,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921205,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921206,'2609','389',108123.07,108399.76,276.69,45100.47,0.00,0.00,0.00,0.00,0.00),('1','167','880','201476',3921207,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921208,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921209,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921210,'2613','389',112587.68,113578.72,991.04,161539.52,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921211,'2614','389',174545.43,175270.67,725.24,118214.12,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921212,'2615','389',89095.20,89095.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201476',3921213,'2616','389',148070.44,148739.39,668.95,109038.85,0.00,0.00,0.00,0.00,0.00),('1','167','882','201476',3921214,'2617','389',200755.25,200969.31,214.06,34891.78,0.00,0.00,0.00,0.00,0.00),('1','167','882','201476',3921215,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201476',3921216,'2619','389',192670.53,193025.15,354.62,57803.06,0.00,0.00,0.00,0.00,0.00),('1','167','882','201476',3921217,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201476',3921218,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201476',3921219,'2622','389',154198.27,154646.22,447.95,73015.85,0.00,0.00,0.00,0.00,0.00),('1','167','883','201476',3921220,'2623','389',160378.02,160928.99,550.97,89808.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','201476',3921221,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201476',3921222,'2625','389',195808.73,196886.55,1077.82,175684.66,0.00,0.00,0.00,0.00,0.00),('1','167','884','201476',3921223,'2626','389',142522.98,142522.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201476',3921224,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201476',3921225,'2628','389',169677.57,170357.22,679.65,110782.95,0.00,0.00,0.00,0.00,0.00),('1','167','885','201476',3921226,'2629','389',118930.18,119242.29,312.11,50873.93,0.00,0.00,0.00,0.00,0.00),('1','167','885','201476',3921227,'2630','389',55647.95,56019.26,371.31,60523.53,0.00,0.00,0.00,0.00,0.00),('1','167','885','201476',3921228,'2631','389',134511.99,134702.41,190.42,31038.46,0.00,0.00,0.00,0.00,0.00),('1','167','885','201476',3921229,'2632','389',65127.11,65775.20,648.09,105638.67,0.00,0.00,0.00,0.00,0.00),('1','167','886','201476',3921230,'2633','389',90021.95,90553.68,531.73,86671.99,0.00,0.00,0.00,0.00,0.00),('1','167','886','201476',3921231,'2634','389',88670.11,88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201476',3921232,'2635','389',94044.95,94044.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201476',3921233,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201476',3921234,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201476',3921235,'2638','389',249589.22,251244.75,1655.53,269851.39,0.00,0.00,0.00,0.00,0.00),('1','167','887','201476',3921236,'2639','389',179842.42,180397.78,555.36,90523.68,0.00,0.00,0.00,0.00,0.00),('1','167','887','201476',3921237,'2640','389',175635.47,176113.01,477.54,77839.02,0.00,0.00,0.00,0.00,0.00),('1','167','888','201476',3921238,'2641','390',528450.93,529032.68,581.75,154163.75,0.00,0.00,0.00,0.00,0.00),('1','167','888','201476',3921239,'2642','390',328533.24,329062.68,529.44,140301.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','201476',3921240,'2643','390',531957.60,532845.93,888.33,235407.45,0.00,0.00,0.00,0.00,0.00),('1','167','889','201476',3921241,'2644','390',405173.43,405904.19,730.76,193651.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','201476',3921242,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201476',3921243,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929793,'2605','389',123268.92,123788.11,519.19,84627.97,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929794,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929795,'2607','389',161817.14,162106.78,289.64,47211.32,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929796,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929797,'2609','389',108399.76,108610.02,210.26,34272.38,0.00,0.00,0.00,0.00,0.00),('1','167','880','201935',3929798,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929799,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929800,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929801,'2613','389',113578.72,114357.27,778.55,126903.65,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929802,'2614','389',175270.67,176044.92,774.25,126202.75,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929803,'2615','389',89095.20,89817.96,722.76,117809.88,0.00,0.00,0.00,0.00,0.00),('1','167','881','201935',3929804,'2616','389',148739.39,148757.79,18.40,2999.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','201935',3929805,'2617','389',200969.31,201192.50,223.19,36379.97,0.00,0.00,0.00,0.00,0.00),('1','167','882','201935',3929806,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201935',3929807,'2619','389',193025.15,193280.26,255.11,41582.93,0.00,0.00,0.00,0.00,0.00),('1','167','882','201935',3929808,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201935',3929809,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201935',3929810,'2622','389',154646.22,155240.19,593.97,96817.11,0.00,0.00,0.00,0.00,0.00),('1','167','883','201935',3929811,'2623','389',160928.99,161250.78,321.79,52451.77,0.00,0.00,0.00,0.00,0.00),('1','167','883','201935',3929812,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201935',3929813,'2625','389',196886.55,196886.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201935',3929814,'2626','389',142522.98,143572.32,1049.34,171042.42,0.00,0.00,0.00,0.00,0.00),('1','167','884','201935',3929815,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201935',3929816,'2628','389',170357.22,171408.06,1050.84,171286.92,0.00,0.00,0.00,0.00,0.00),('1','167','885','201935',3929817,'2629','389',119242.29,119637.36,395.07,64396.41,0.00,0.00,0.00,0.00,0.00),('1','167','885','201935',3929818,'2630','389',56019.26,56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201935',3929819,'2631','389',134702.41,135336.43,634.02,103345.26,0.00,0.00,0.00,0.00,0.00),('1','167','885','201935',3929820,'2632','389',65775.20,65775.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201935',3929821,'2633','389',90553.68,91134.06,580.38,94601.94,0.00,0.00,0.00,0.00,0.00),('1','167','886','201935',3929822,'2634','389',88670.11,88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201935',3929823,'2635','389',94044.95,94377.56,332.61,54215.43,0.00,0.00,0.00,0.00,0.00),('1','167','886','201935',3929824,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201935',3929825,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201935',3929826,'2638','389',251244.75,252250.86,1006.11,163995.93,0.00,0.00,0.00,0.00,0.00),('1','167','887','201935',3929827,'2639','389',180397.78,181147.51,749.73,122205.99,0.00,0.00,0.00,0.00,0.00),('1','167','887','201935',3929828,'2640','389',176113.01,176113.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201935',3929829,'2641','390',529032.68,529486.62,453.94,120294.10,0.00,0.00,0.00,0.00,0.00),('1','167','888','201935',3929830,'2642','390',329062.68,329299.21,236.53,62680.45,0.00,0.00,0.00,0.00,0.00),('1','167','889','201935',3929831,'2643','390',532845.93,533102.41,256.48,67967.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','201935',3929832,'2644','390',405904.19,406323.12,418.93,111016.45,0.00,0.00,0.00,0.00,0.00),('1','167','890','201935',3929833,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201935',3929834,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930269,'2605','389',123788.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930270,'2606','389',100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930271,'2607','389',162106.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930272,'2608','389',53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930273,'2609','389',108610.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201960',3930274,'2610','389',116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930275,'2611','389',164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930276,'2612','389',250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930277,'2613','389',114357.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930278,'2614','389',176044.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930279,'2615','389',89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201960',3930280,'2616','389',148757.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201960',3930281,'2617','389',201192.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201960',3930282,'2618','389',107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201960',3930283,'2619','389',193280.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201960',3930284,'2620','389',129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201960',3930285,'2621','389',46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201960',3930286,'2622','389',155240.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201960',3930287,'2623','389',161250.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201960',3930288,'2624','389',59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201960',3930289,'2625','389',196886.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201960',3930290,'2626','389',143572.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201960',3930291,'2627','389',94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201960',3930292,'2628','389',171408.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201960',3930293,'2629','389',119637.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201960',3930294,'2630','389',56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201960',3930295,'2631','389',135336.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201960',3930296,'2632','389',65775.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201960',3930297,'2633','389',91134.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201960',3930298,'2634','389',88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201960',3930299,'2635','389',94377.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201960',3930300,'2636','389',47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201960',3930301,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201960',3930302,'2638','389',252250.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201960',3930303,'2639','389',181147.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201960',3930304,'2640','389',176113.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201960',3930305,'2641','390',529486.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201960',3930306,'2642','390',329299.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201960',3930307,'2643','390',533102.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201960',3930308,'2644','390',406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201960',3930309,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201960',3930310,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930413,'2605','389',123788.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930414,'2606','389',100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930415,'2607','389',162106.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930416,'2608','389',53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930417,'2609','389',108610.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201966',3930418,'2610','389',116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930419,'2611','389',164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930420,'2612','389',250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930421,'2613','389',114357.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930422,'2614','389',176044.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930423,'2615','389',89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201966',3930424,'2616','389',148757.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201966',3930425,'2617','389',201192.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201966',3930426,'2618','389',107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201966',3930427,'2619','389',193280.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201966',3930428,'2620','389',129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201966',3930429,'2621','389',46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201966',3930430,'2622','389',155240.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201966',3930431,'2623','389',161250.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201966',3930432,'2624','389',59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201966',3930433,'2625','389',196886.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201966',3930434,'2626','389',143572.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201966',3930435,'2627','389',94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201966',3930436,'2628','389',171408.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201966',3930437,'2629','389',119637.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201966',3930438,'2630','389',56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201966',3930439,'2631','389',135336.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201966',3930440,'2632','389',65775.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201966',3930441,'2633','389',91134.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201966',3930442,'2634','389',88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201966',3930443,'2635','389',94377.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201966',3930444,'2636','389',47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201966',3930445,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201966',3930446,'2638','389',252250.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201966',3930447,'2639','389',181147.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201966',3930448,'2640','389',176113.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201966',3930449,'2641','390',529486.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201966',3930450,'2642','390',329299.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201966',3930451,'2643','390',533102.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201966',3930452,'2644','390',406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201966',3930453,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201966',3930454,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930529,'2605','389',123788.11,123788.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930530,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930531,'2607','389',162106.78,162106.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930532,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930533,'2609','389',108610.02,108610.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201970',3930534,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930535,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930536,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930537,'2613','389',114357.27,114357.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930538,'2614','389',176044.92,176044.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930539,'2615','389',89817.96,89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201970',3930540,'2616','389',148757.79,148757.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201970',3930541,'2617','389',201192.50,201192.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201970',3930542,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201970',3930543,'2619','389',193280.26,193280.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201970',3930544,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201970',3930545,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201970',3930546,'2622','389',155240.19,155240.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201970',3930547,'2623','389',161250.78,161250.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201970',3930548,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201970',3930549,'2625','389',196886.55,196886.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201970',3930550,'2626','389',143572.32,143572.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201970',3930551,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201970',3930552,'2628','389',171408.06,171408.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201970',3930553,'2629','389',119637.36,119637.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201970',3930554,'2630','389',56019.26,56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201970',3930555,'2631','389',135336.43,135336.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201970',3930556,'2632','389',65775.20,65775.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201970',3930557,'2633','389',91134.06,91134.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201970',3930558,'2634','389',88670.11,88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201970',3930559,'2635','389',94377.56,94377.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201970',3930560,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201970',3930561,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201970',3930562,'2638','389',252250.86,252250.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201970',3930563,'2639','389',181147.51,181147.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201970',3930564,'2640','389',176113.01,176113.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201970',3930565,'2641','390',529486.62,529780.36,293.74,79309.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','201970',3930566,'2642','390',329299.21,329537.72,238.51,64397.70,0.00,0.00,0.00,0.00,0.00),('1','167','889','201970',3930567,'2643','390',533102.41,533526.86,424.45,114601.50,0.00,0.00,0.00,0.00,0.00),('1','167','889','201970',3930568,'2644','390',406323.12,406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201970',3930569,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201970',3930570,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930608,'2605','389',123788.11,124184.34,396.23,64585.49,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930609,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930610,'2607','389',162106.78,162357.59,250.81,40882.03,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930611,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930612,'2609','389',108610.02,109851.50,1241.48,202361.24,0.00,0.00,0.00,0.00,0.00),('1','167','880','201973',3930613,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930614,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930615,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930616,'2613','389',114357.27,115114.93,757.66,123498.58,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930617,'2614','389',176044.92,176906.28,861.36,140401.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930618,'2615','389',89817.96,89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201973',3930619,'2616','389',148757.79,149296.14,538.35,87751.05,0.00,0.00,0.00,0.00,0.00),('1','167','882','201973',3930620,'2617','389',201192.50,201497.73,305.23,49752.49,0.00,0.00,0.00,0.00,0.00),('1','167','882','201973',3930621,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201973',3930622,'2619','389',193280.26,193765.12,484.86,79032.18,0.00,0.00,0.00,0.00,0.00),('1','167','882','201973',3930623,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201973',3930624,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201973',3930625,'2622','389',155240.19,155703.21,463.02,75472.26,0.00,0.00,0.00,0.00,0.00),('1','167','883','201973',3930626,'2623','389',161250.78,161627.37,376.59,61384.17,0.00,0.00,0.00,0.00,0.00),('1','167','883','201973',3930627,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201973',3930628,'2625','389',196886.55,197628.65,742.10,120962.30,0.00,0.00,0.00,0.00,0.00),('1','167','884','201973',3930629,'2626','389',143572.32,144582.05,1009.73,164585.99,0.00,0.00,0.00,0.00,0.00),('1','167','884','201973',3930630,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201973',3930631,'2628','389',171408.06,172114.25,706.19,115108.97,0.00,0.00,0.00,0.00,0.00),('1','167','885','201973',3930632,'2629','389',119637.36,120050.14,412.78,67283.14,0.00,0.00,0.00,0.00,0.00),('1','167','885','201973',3930633,'2630','389',56019.26,56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201973',3930634,'2631','389',135336.43,135650.19,313.76,51142.88,0.00,0.00,0.00,0.00,0.00),('1','167','885','201973',3930635,'2632','389',65775.20,66247.59,472.39,76999.57,0.00,0.00,0.00,0.00,0.00),('1','167','886','201973',3930636,'2633','389',91134.06,91633.20,499.14,81359.82,0.00,0.00,0.00,0.00,0.00),('1','167','886','201973',3930637,'2634','389',88670.11,88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201973',3930638,'2635','389',94377.56,94851.79,474.23,77299.49,0.00,0.00,0.00,0.00,0.00),('1','167','886','201973',3930639,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201973',3930640,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201973',3930641,'2638','389',252250.86,253298.94,1048.08,170837.04,0.00,0.00,0.00,0.00,0.00),('1','167','887','201973',3930642,'2639','389',181147.51,182489.47,1341.96,218739.48,0.00,0.00,0.00,0.00,0.00),('1','167','887','201973',3930643,'2640','389',176113.01,176113.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201973',3930644,'2641','390',529780.36,531269.43,1489.07,402048.90,0.00,0.00,0.00,0.00,0.00),('1','167','888','201973',3930645,'2642','390',329537.72,330202.91,665.19,179601.30,0.00,0.00,0.00,0.00,0.00),('1','167','889','201973',3930646,'2643','390',533526.86,535262.47,1735.61,468614.70,0.00,0.00,0.00,0.00,0.00),('1','167','889','201973',3930647,'2644','390',406323.12,406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201973',3930648,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201973',3930649,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930674,'2605','389',124184.34,124967.80,783.46,127703.98,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930675,'2606','389',100716.55,100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930676,'2607','389',162357.59,162592.19,234.60,38239.80,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930677,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930678,'2609','389',109851.50,110046.12,194.62,31723.06,0.00,0.00,0.00,0.00,0.00),('1','167','880','201976',3930679,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930680,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930681,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930682,'2613','389',115114.93,115776.16,661.23,107780.49,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930683,'2614','389',176906.28,177659.90,753.62,122840.06,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930684,'2615','389',89817.96,89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201976',3930685,'2616','389',149296.14,149827.25,531.11,86570.93,0.00,0.00,0.00,0.00,0.00),('1','167','882','201976',3930686,'2617','389',201497.73,201780.09,282.36,46024.68,0.00,0.00,0.00,0.00,0.00),('1','167','882','201976',3930687,'2618','389',107820.30,107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201976',3930688,'2619','389',193765.12,193916.76,151.64,24717.32,0.00,0.00,0.00,0.00,0.00),('1','167','882','201976',3930689,'2620','389',129732.66,129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201976',3930690,'2621','389',46976.69,46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201976',3930691,'2622','389',155703.21,156231.75,528.54,86152.02,0.00,0.00,0.00,0.00,0.00),('1','167','883','201976',3930692,'2623','389',161627.37,161981.08,353.71,57654.73,0.00,0.00,0.00,0.00,0.00),('1','167','883','201976',3930693,'2624','389',59934.52,59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201976',3930694,'2625','389',197628.65,198999.20,1370.55,223399.65,0.00,0.00,0.00,0.00,0.00),('1','167','884','201976',3930695,'2626','389',144582.05,144582.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201976',3930696,'2627','389',94844.27,94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201976',3930697,'2628','389',172114.25,172731.58,617.33,100624.79,0.00,0.00,0.00,0.00,0.00),('1','167','885','201976',3930698,'2629','389',120050.14,120423.88,373.74,60919.62,0.00,0.00,0.00,0.00,0.00),('1','167','885','201976',3930699,'2630','389',56019.26,56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201976',3930700,'2631','389',135650.19,136329.04,678.85,110652.55,0.00,0.00,0.00,0.00,0.00),('1','167','885','201976',3930701,'2632','389',66247.59,66247.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201976',3930702,'2633','389',91633.20,92041.77,408.57,66596.91,0.00,0.00,0.00,0.00,0.00),('1','167','886','201976',3930703,'2634','389',88670.11,88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201976',3930704,'2635','389',94851.79,95260.92,409.13,66688.19,0.00,0.00,0.00,0.00,0.00),('1','167','886','201976',3930705,'2636','389',47378.09,47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201976',3930706,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201976',3930707,'2638','389',253298.94,254130.42,831.48,135531.24,0.00,0.00,0.00,0.00,0.00),('1','167','887','201976',3930708,'2639','389',182489.47,182489.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201976',3930709,'2640','389',176113.01,176805.15,692.14,112818.82,0.00,0.00,0.00,0.00,0.00),('1','167','888','201976',3930710,'2641','390',531269.43,532448.32,1178.89,318300.30,0.00,0.00,0.00,0.00,0.00),('1','167','888','201976',3930711,'2642','390',330202.91,331306.84,1103.93,298061.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','201976',3930712,'2643','390',535262.47,536733.03,1470.56,397051.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','201976',3930713,'2644','390',406323.12,406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201976',3930714,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201976',3930715,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930964,'2605','389',124967.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930965,'2606','389',100716.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930966,'2607','389',162592.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930967,'2608','389',53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930968,'2609','389',110046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','201990',3930969,'2610','389',116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930970,'2611','389',164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930971,'2612','389',250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930972,'2613','389',115776.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930973,'2614','389',177659.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930974,'2615','389',89817.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','201990',3930975,'2616','389',149827.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201990',3930976,'2617','389',201780.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201990',3930977,'2618','389',107820.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201990',3930978,'2619','389',193916.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','201990',3930979,'2620','389',129732.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201990',3930980,'2621','389',46976.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201990',3930981,'2622','389',156231.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201990',3930982,'2623','389',161981.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','201990',3930983,'2624','389',59934.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201990',3930984,'2625','389',198999.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201990',3930985,'2626','389',144582.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201990',3930986,'2627','389',94844.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','201990',3930987,'2628','389',172731.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201990',3930988,'2629','389',120423.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201990',3930989,'2630','389',56019.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201990',3930990,'2631','389',136329.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','201990',3930991,'2632','389',66247.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201990',3930992,'2633','389',92041.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201990',3930993,'2634','389',88670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201990',3930994,'2635','389',95260.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','201990',3930995,'2636','389',47378.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201990',3930996,'2637','389',170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201990',3930997,'2638','389',254130.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201990',3930998,'2639','389',182489.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','201990',3930999,'2640','389',176805.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201990',3931000,'2641','390',532448.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','201990',3931001,'2642','390',331306.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201990',3931002,'2643','390',536733.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','201990',3931003,'2644','390',406323.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201990',3931004,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','201990',3931005,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202572',3940891,'2605','389',124967.80,125538.10,560.30,91328.90,0.00,0.00,10.00,0.00,0.00),('1','167','880','202572',3940892,'2606','389',100716.55,100736.80,0.00,0.00,0.00,0.00,20.25,0.00,0.00),('1','167','880','202572',3940893,'2607','389',162592.19,163141.48,539.29,87904.27,0.00,0.00,10.00,0.00,0.00),('1','167','880','202572',3940894,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202572',3940895,'2609','389',110046.12,110046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202572',3940896,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202572',3940897,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202572',3940898,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202572',3940899,'2613','389',115776.16,116628.89,842.73,137364.99,0.00,0.00,10.00,0.00,0.00),('1','167','881','202572',3940900,'2614','389',177659.90,178416.36,736.46,120042.98,0.00,0.00,20.00,0.00,0.00),('1','167','881','202572',3940901,'2615','389',89817.96,89827.96,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','167','881','202572',3940902,'2616','389',149827.25,150708.96,871.71,142088.73,0.00,0.00,10.00,0.00,0.00),('1','167','882','202572',3940903,'2617','389',201780.09,202042.84,252.75,41198.25,0.00,0.00,10.00,0.00,0.00),('1','167','882','202572',3940904,'2618','389',107820.30,107944.18,113.88,18562.44,0.00,0.00,10.00,0.00,0.00),('1','167','882','202572',3940905,'2619','389',193916.76,194228.31,291.38,47494.94,0.00,0.00,20.17,0.00,0.00),('1','167','882','202572',3940906,'2620','389',129732.66,130040.37,297.71,48526.73,0.00,0.00,10.00,0.00,0.00),('1','167','883','202572',3940907,'2621','389',46976.69,46986.86,0.00,0.00,0.00,0.00,10.17,0.00,0.00),('1','167','883','202572',3940908,'2622','389',156231.75,156773.58,521.83,85058.29,0.00,0.00,20.00,0.00,0.00),('1','167','883','202572',3940909,'2623','389',161981.08,162411.57,420.49,68539.87,0.00,0.00,10.00,0.00,0.00),('1','167','883','202572',3940910,'2624','389',59934.52,59954.99,0.00,0.00,0.00,0.00,20.47,0.00,0.00),('1','167','884','202572',3940911,'2625','389',198999.20,200166.59,1157.39,188654.57,0.00,0.00,10.00,0.00,0.00),('1','167','884','202572',3940912,'2626','389',144582.05,144602.05,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','167','884','202572',3940913,'2627','389',94844.27,95496.48,642.21,104680.23,0.00,0.00,10.00,0.00,0.00),('1','167','884','202572',3940914,'2628','389',172731.58,173765.15,1013.57,165211.91,0.00,0.00,20.00,0.00,0.00),('1','167','885','202572',3940915,'2629','389',120423.88,120900.56,456.68,74438.84,0.00,0.00,20.00,0.00,0.00),('1','167','885','202572',3940916,'2630','389',56019.26,56464.29,425.03,69279.89,0.00,0.00,20.00,0.00,0.00),('1','167','885','202572',3940917,'2631','389',136329.04,137288.87,949.83,154822.29,0.00,0.00,10.00,0.00,0.00),('1','167','885','202572',3940918,'2632','389',66247.59,66267.59,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','167','886','202572',3940919,'2633','389',92041.77,92874.94,823.17,134176.71,0.00,0.00,10.00,0.00,0.00),('1','167','886','202572',3940920,'2634','389',88670.11,88700.29,0.00,0.00,0.00,0.00,30.18,0.00,0.00),('1','167','886','202572',3940921,'2635','389',95260.92,95693.49,402.57,65618.91,0.00,0.00,30.00,0.00,0.00),('1','167','886','202572',3940922,'2636','389',47378.09,47627.89,229.80,37457.40,0.00,0.00,20.00,0.00,0.00),('1','167','887','202572',3940923,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202572',3940924,'2638','389',254130.42,255050.57,880.15,143464.45,0.00,0.00,40.00,0.00,0.00),('1','167','887','202572',3940925,'2639','389',182489.47,183775.91,1246.44,203169.72,0.00,0.00,40.00,0.00,0.00),('1','167','887','202572',3940926,'2640','389',176805.15,176825.15,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','167','888','202572',3940927,'2641','390',532448.32,533157.06,708.74,191359.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','202572',3940928,'2642','390',331306.84,332586.79,1279.95,345586.50,0.00,0.00,0.00,0.00,0.00),('1','167','889','202572',3940929,'2643','390',536733.03,539396.22,2663.19,719061.30,0.00,0.00,0.00,0.00,0.00),('1','167','889','202572',3940930,'2644','390',1265.91,3154.14,1888.23,509822.10,0.00,0.00,0.00,0.00,0.00),('1','167','890','202572',3940931,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202572',3940932,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941356,'2605','389',125538.10,125538.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941357,'2606','389',100736.80,101166.42,429.62,70028.06,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941358,'2607','389',163141.48,163335.87,194.39,31685.57,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941359,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941360,'2609','389',110046.12,110243.80,197.68,32221.84,0.00,0.00,0.00,0.00,0.00),('1','167','880','202592',3941361,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941362,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941363,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941364,'2613','389',116628.89,117206.22,577.33,94104.79,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941365,'2614','389',178416.36,179136.06,719.70,117311.10,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941366,'2615','389',89827.96,90450.71,622.75,101508.25,0.00,0.00,0.00,0.00,0.00),('1','167','881','202592',3941367,'2616','389',150708.96,150708.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202592',3941368,'2617','389',202042.84,202202.21,159.37,25977.31,0.00,0.00,0.00,0.00,0.00),('1','167','882','202592',3941369,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202592',3941370,'2619','389',194228.31,194580.91,352.60,57473.80,0.00,0.00,0.00,0.00,0.00),('1','167','882','202592',3941371,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202592',3941372,'2621','389',46986.86,46986.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202592',3941373,'2622','389',156773.58,157013.57,239.99,39118.37,0.00,0.00,0.00,0.00,0.00),('1','167','883','202592',3941374,'2623','389',162411.57,162637.45,225.88,36818.44,0.00,0.00,0.00,0.00,0.00),('1','167','883','202592',3941375,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202592',3941376,'2625','389',200166.59,201482.15,1315.56,214436.28,0.00,0.00,0.00,0.00,0.00),('1','167','884','202592',3941377,'2626','389',144602.05,144602.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202592',3941378,'2627','389',95496.48,96640.06,1143.58,186403.54,0.00,0.00,0.00,0.00,0.00),('1','167','884','202592',3941379,'2628','389',173765.15,173765.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202592',3941380,'2629','389',120900.56,120900.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202592',3941381,'2630','389',56464.29,56960.27,495.98,80844.74,0.00,0.00,0.00,0.00,0.00),('1','167','885','202592',3941382,'2631','389',137288.87,137288.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202592',3941383,'2632','389',66267.59,66711.31,443.72,72326.36,0.00,0.00,0.00,0.00,0.00),('1','167','886','202592',3941384,'2633','389',92874.94,93636.55,761.61,124142.43,0.00,0.00,0.00,0.00,0.00),('1','167','886','202592',3941385,'2634','389',88700.29,88700.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202592',3941386,'2635','389',95693.49,96207.54,514.05,83790.15,0.00,0.00,0.00,0.00,0.00),('1','167','886','202592',3941387,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202592',3941388,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202592',3941389,'2638','389',255050.57,256071.06,1020.49,166339.87,0.00,0.00,0.00,0.00,0.00),('1','167','887','202592',3941390,'2639','389',183775.91,184770.95,995.04,162191.52,0.00,0.00,0.00,0.00,0.00),('1','167','887','202592',3941391,'2640','389',176825.15,176825.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','202592',3941392,'2641','390',533157.06,534128.05,970.99,262167.30,0.00,0.00,0.00,0.00,0.00),('1','167','888','202592',3941393,'2642','390',332586.79,333749.38,1162.59,313899.30,0.00,0.00,0.00,0.00,0.00),('1','167','889','202592',3941394,'2643','390',539396.22,540562.42,1166.20,314874.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202592',3941395,'2644','390',3154.14,5239.01,2084.87,562914.90,0.00,0.00,0.00,0.00,0.00),('1','167','890','202592',3941396,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202592',3941397,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941531,'2605','389',125538.10,126094.27,556.17,90655.71,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941532,'2606','389',101166.42,101166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941533,'2607','389',163335.87,163471.50,135.63,22107.69,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941534,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941535,'2609','389',110243.80,110243.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202599',3941536,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941537,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941538,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941539,'2613','389',117206.22,117742.09,535.87,87346.81,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941540,'2614','389',179136.06,179782.02,645.96,105291.48,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941541,'2615','389',90450.71,90450.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202599',3941542,'2616','389',150708.96,151392.40,683.44,111400.72,0.00,0.00,0.00,0.00,0.00),('1','167','882','202599',3941543,'2617','389',202202.21,202583.43,381.22,62138.86,0.00,0.00,0.00,0.00,0.00),('1','167','882','202599',3941544,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202599',3941545,'2619','389',194580.91,195069.24,488.33,79597.79,0.00,0.00,0.00,0.00,0.00),('1','167','882','202599',3941546,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202599',3941547,'2621','389',46986.86,47697.45,710.59,115826.17,0.00,0.00,0.00,0.00,0.00),('1','167','883','202599',3941548,'2622','389',157013.57,157560.90,547.33,89214.79,0.00,0.00,0.00,0.00,0.00),('1','167','883','202599',3941549,'2623','389',162637.45,163132.22,494.77,80647.51,0.00,0.00,0.00,0.00,0.00),('1','167','883','202599',3941550,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202599',3941551,'2625','389',201482.15,201951.97,469.82,76580.66,0.00,0.00,0.00,0.00,0.00),('1','167','884','202599',3941552,'2626','389',144602.05,145205.55,603.50,98370.50,0.00,0.00,0.00,0.00,0.00),('1','167','884','202599',3941553,'2627','389',96640.06,96640.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202599',3941554,'2628','389',173765.15,174516.95,751.80,122543.40,0.00,0.00,0.00,0.00,0.00),('1','167','885','202599',3941555,'2629','389',120900.56,121323.97,423.41,69015.83,0.00,0.00,0.00,0.00,0.00),('1','167','885','202599',3941556,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202599',3941557,'2631','389',137288.87,138007.20,718.33,117087.79,0.00,0.00,0.00,0.00,0.00),('1','167','885','202599',3941558,'2632','389',66711.31,66711.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202599',3941559,'2633','389',93636.55,94343.37,706.82,115211.66,0.00,0.00,0.00,0.00,0.00),('1','167','886','202599',3941560,'2634','389',88700.29,88700.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202599',3941561,'2635','389',96207.54,96723.69,516.15,84132.45,0.00,0.00,0.00,0.00,0.00),('1','167','886','202599',3941562,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202599',3941563,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202599',3941564,'2638','389',256071.06,256956.58,885.52,144339.76,0.00,0.00,0.00,0.00,0.00),('1','167','887','202599',3941565,'2639','389',184770.95,185522.36,751.41,122479.83,0.00,0.00,0.00,0.00,0.00),('1','167','887','202599',3941566,'2640','389',176825.15,176825.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','202599',3941567,'2641','390',534128.05,535669.75,1541.70,416259.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','202599',3941568,'2642','390',333749.38,333749.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202599',3941569,'2643','390',540562.42,544322.22,3759.80,1015146.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202599',3941570,'2644','390',5239.01,5840.67,601.66,162448.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','202599',3941571,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202599',3941572,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941782,'2605','389',126094.27,126649.98,555.71,90580.73,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941783,'2606','389',101166.42,101166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941784,'2607','389',163471.50,164042.87,571.37,93133.31,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941785,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941786,'2609','389',110243.80,110407.25,163.45,26642.35,0.00,0.00,0.00,0.00,0.00),('1','167','880','202611',3941787,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941788,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941789,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941790,'2613','389',117742.09,118405.45,663.36,108127.68,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941791,'2614','389',179782.02,180275.60,493.58,80453.54,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941792,'2615','389',90450.71,90450.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202611',3941793,'2616','389',151392.40,151923.73,531.33,86606.79,0.00,0.00,0.00,0.00,0.00),('1','167','882','202611',3941794,'2617','389',202583.43,202929.01,345.58,56329.54,0.00,0.00,0.00,0.00,0.00),('1','167','882','202611',3941795,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202611',3941796,'2619','389',195069.24,195371.40,302.16,49252.08,0.00,0.00,0.00,0.00,0.00),('1','167','882','202611',3941797,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202611',3941798,'2621','389',47697.45,47697.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202611',3941799,'2622','389',157560.90,158020.38,459.48,74895.24,0.00,0.00,0.00,0.00,0.00),('1','167','883','202611',3941800,'2623','389',163132.22,163920.00,787.78,128408.14,0.00,0.00,0.00,0.00,0.00),('1','167','883','202611',3941801,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202611',3941802,'2625','389',201951.97,202509.15,557.18,90820.34,0.00,0.00,0.00,0.00,0.00),('1','167','884','202611',3941803,'2626','389',145205.55,146104.12,898.57,146466.91,0.00,0.00,0.00,0.00,0.00),('1','167','884','202611',3941804,'2627','389',96640.06,96640.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202611',3941805,'2628','389',174516.95,174864.02,347.07,56572.41,0.00,0.00,0.00,0.00,0.00),('1','167','885','202611',3941806,'2629','389',121323.97,122292.74,968.77,157909.51,0.00,0.00,0.00,0.00,0.00),('1','167','885','202611',3941807,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202611',3941808,'2631','389',138007.20,138182.12,174.92,28511.96,0.00,0.00,0.00,0.00,0.00),('1','167','885','202611',3941809,'2632','389',66711.31,67082.92,371.61,60572.43,0.00,0.00,0.00,0.00,0.00),('1','167','886','202611',3941810,'2633','389',94343.37,94343.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202611',3941811,'2634','389',88700.29,89179.88,479.59,78173.17,0.00,0.00,0.00,0.00,0.00),('1','167','886','202611',3941812,'2635','389',96723.69,97118.79,395.10,64401.30,0.00,0.00,0.00,0.00,0.00),('1','167','886','202611',3941813,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202611',3941814,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202611',3941815,'2638','389',256956.58,258040.69,1084.11,176709.93,0.00,0.00,0.00,0.00,0.00),('1','167','887','202611',3941816,'2639','389',185522.36,186068.26,545.90,88981.70,0.00,0.00,0.00,0.00,0.00),('1','167','887','202611',3941817,'2640','389',176825.15,177231.03,405.88,66158.44,0.00,0.00,0.00,0.00,0.00),('1','167','888','202611',3941818,'2641','390',535669.75,536348.26,678.51,183197.70,0.00,0.00,0.00,0.00,0.00),('1','167','888','202611',3941819,'2642','390',333749.38,334303.08,553.70,149499.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202611',3941820,'2643','390',544322.22,545047.55,725.33,195839.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','202611',3941821,'2644','390',5840.67,6774.47,933.80,252126.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202611',3941822,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202611',3941823,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943737,'2605','389',126649.98,127417.85,767.87,125162.81,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943738,'2606','389',101166.42,101166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943739,'2607','389',164042.87,164812.02,769.15,125371.45,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943740,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943741,'2609','389',110407.25,110744.96,337.71,55046.73,0.00,0.00,0.00,0.00,0.00),('1','167','880','202738',3943742,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943743,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943744,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943745,'2613','389',118405.45,119806.88,1401.43,228433.09,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943746,'2614','389',180275.60,180275.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943747,'2615','389',90450.71,90450.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202738',3943748,'2616','389',151923.73,152740.63,816.90,133154.70,0.00,0.00,0.00,0.00,0.00),('1','167','882','202738',3943749,'2617','389',202929.01,203354.05,425.04,69281.52,0.00,0.00,0.00,0.00,0.00),('1','167','882','202738',3943750,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202738',3943751,'2619','389',195371.40,195844.84,473.44,77170.72,0.00,0.00,0.00,0.00,0.00),('1','167','882','202738',3943752,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202738',3943753,'2621','389',47697.45,48768.77,1071.32,174625.16,0.00,0.00,0.00,0.00,0.00),('1','167','883','202738',3943754,'2622','389',158020.38,158020.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202738',3943755,'2623','389',163920.00,164447.83,527.83,86036.29,0.00,0.00,0.00,0.00,0.00),('1','167','883','202738',3943756,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202738',3943757,'2625','389',202509.15,202509.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202738',3943758,'2626','389',146104.12,147493.72,1389.60,226504.80,0.00,0.00,0.00,0.00,0.00),('1','167','884','202738',3943759,'2627','389',96640.06,96640.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202738',3943760,'2628','389',174864.02,175732.37,868.35,141541.05,0.00,0.00,0.00,0.00,0.00),('1','167','885','202738',3943761,'2629','389',122292.74,122772.80,480.06,78249.78,0.00,0.00,0.00,0.00,0.00),('1','167','885','202738',3943762,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202738',3943763,'2631','389',138182.12,138942.70,760.58,123974.54,0.00,0.00,0.00,0.00,0.00),('1','167','885','202738',3943764,'2632','389',67082.92,67082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202738',3943765,'2633','389',94343.37,94937.06,593.69,96771.47,0.00,0.00,0.00,0.00,0.00),('1','167','886','202738',3943766,'2634','389',89179.88,89179.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202738',3943767,'2635','389',97118.79,97783.98,665.19,108425.97,0.00,0.00,0.00,0.00,0.00),('1','167','886','202738',3943768,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202738',3943769,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202738',3943770,'2638','389',258040.69,259156.67,1115.98,181904.74,0.00,0.00,0.00,0.00,0.00),('1','167','887','202738',3943771,'2639','389',186068.26,186068.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202738',3943772,'2640','389',177231.03,178138.81,907.78,147968.14,0.00,0.00,0.00,0.00,0.00),('1','167','888','202738',3943773,'2641','390',536348.26,537312.56,964.30,260361.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','202738',3943774,'2642','390',334303.08,335751.60,1448.52,391100.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','202738',3943775,'2643','390',545047.55,545979.85,932.30,251721.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202738',3943776,'2644','390',6774.47,7554.61,780.14,210637.80,0.00,0.00,0.00,0.00,0.00),('1','167','890','202738',3943777,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202738',3943778,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202747',3943884,'2605','389',127417.85,127609.17,181.32,29555.16,0.00,0.00,10.00,0.00,0.00),('1','167','880','202747',3943885,'2606','389',101166.42,101166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202747',3943886,'2607','389',164812.02,165102.17,280.15,45664.45,0.00,0.00,10.00,0.00,0.00),('1','167','880','202747',3943887,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202747',3943888,'2609','389',110744.96,110974.78,224.82,36645.66,0.00,0.00,5.00,0.00,0.00),('1','167','880','202747',3943889,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202747',3943890,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202747',3943891,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202747',3943892,'2613','389',119806.88,119806.88,-10.00,-1630.00,0.00,0.00,10.00,0.00,0.00),('1','167','881','202747',3943893,'2614','389',180275.60,180881.37,605.77,98740.51,0.00,0.00,0.00,0.00,0.00),('1','167','881','202747',3943894,'2615','389',90450.71,90680.56,229.85,37465.55,0.00,0.00,0.00,0.00,0.00),('1','167','881','202747',3943895,'2616','389',152740.63,152950.83,200.20,32632.60,0.00,0.00,10.00,0.00,0.00),('1','167','882','202747',3943896,'2617','389',203354.05,203676.67,292.62,47697.06,0.00,0.00,30.00,0.00,0.00),('1','167','882','202747',3943897,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202747',3943898,'2619','389',195844.84,196075.53,210.69,34342.47,0.00,0.00,20.00,0.00,0.00),('1','167','882','202747',3943899,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202747',3943900,'2621','389',48768.77,48768.77,-30.00,-4890.00,0.00,0.00,30.00,0.00,0.00),('1','167','883','202747',3943901,'2622','389',158020.38,158395.79,375.41,61191.83,0.00,0.00,0.00,0.00,0.00),('1','167','883','202747',3943902,'2623','389',164447.83,164681.66,213.83,34854.29,0.00,0.00,20.00,0.00,0.00),('1','167','883','202747',3943903,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202747',3943904,'2625','389',202509.15,203158.14,648.99,105785.37,0.00,0.00,0.00,0.00,0.00),('1','167','884','202747',3943905,'2626','389',147493.72,148152.22,638.50,104075.50,0.00,0.00,20.00,0.00,0.00),('1','167','884','202747',3943906,'2627','389',96640.06,96992.10,352.04,57382.52,0.00,0.00,0.00,0.00,0.00),('1','167','884','202747',3943907,'2628','389',175732.37,176109.32,366.95,59812.85,0.00,0.00,10.00,0.00,0.00),('1','167','885','202747',3943908,'2629','389',122772.80,123255.21,472.41,77002.83,0.00,0.00,10.00,0.00,0.00),('1','167','885','202747',3943909,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202747',3943910,'2631','389',138942.70,138942.70,-30.00,-4890.00,0.00,0.00,30.00,0.00,0.00),('1','167','885','202747',3943911,'2632','389',67082.92,67626.68,543.76,88632.88,0.00,0.00,0.00,0.00,0.00),('1','167','886','202747',3943912,'2633','389',94937.06,94937.06,-20.00,-3260.00,0.00,0.00,20.00,0.00,0.00),('1','167','886','202747',3943913,'2634','389',89179.88,89483.22,303.34,49444.42,0.00,0.00,0.00,0.00,0.00),('1','167','886','202747',3943914,'2635','389',97783.98,97945.99,152.01,24777.63,0.00,0.00,10.00,0.00,0.00),('1','167','886','202747',3943915,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202747',3943916,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202747',3943917,'2638','389',259156.67,259912.56,745.89,121580.07,0.00,0.00,10.00,0.00,0.00),('1','167','887','202747',3943918,'2639','389',186068.26,186754.96,686.70,111932.10,0.00,0.00,0.00,0.00,0.00),('1','167','887','202747',3943919,'2640','389',178138.81,178138.81,-20.00,-3260.00,0.00,0.00,20.00,0.00,0.00),('1','167','888','202747',3943920,'2641','390',537312.56,538715.34,1402.78,378750.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','202747',3943921,'2642','390',335751.60,336574.93,823.33,222299.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','202747',3943922,'2643','390',545979.85,548247.93,2268.08,612381.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','202747',3943923,'2644','390',7554.61,8143.88,589.27,159102.90,0.00,0.00,0.00,0.00,0.00),('1','167','890','202747',3943924,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202747',3943925,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945442,'2605','389',127609.17,128101.46,492.29,80243.27,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945443,'2606','389',101166.42,101166.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945444,'2607','389',165102.17,165570.26,468.09,76298.67,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945445,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945446,'2609','389',110974.78,111437.51,462.73,75424.99,0.00,0.00,0.00,0.00,0.00),('1','167','880','202817',3945447,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945448,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945449,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945450,'2613','389',119806.88,119956.55,149.67,24396.21,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945451,'2614','389',180881.37,181811.64,930.27,151634.01,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945452,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202817',3945453,'2616','389',152950.83,153719.81,768.98,125343.74,0.00,0.00,0.00,0.00,0.00),('1','167','882','202817',3945454,'2617','389',203676.67,203953.17,276.50,45069.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','202817',3945455,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202817',3945456,'2619','389',196075.53,196408.03,332.50,54197.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','202817',3945457,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202817',3945458,'2621','389',48768.77,49411.36,642.59,104742.17,0.00,0.00,0.00,0.00,0.00),('1','167','883','202817',3945459,'2622','389',158395.79,158395.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202817',3945460,'2623','389',164681.66,165439.12,757.46,123465.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','202817',3945461,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202817',3945462,'2625','389',203158.14,204566.28,1408.14,229526.82,0.00,0.00,0.00,0.00,0.00),('1','167','884','202817',3945463,'2626','389',148152.22,148152.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202817',3945464,'2627','389',96992.10,96992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202817',3945465,'2628','389',176109.32,176911.30,801.98,130722.74,0.00,0.00,0.00,0.00,0.00),('1','167','885','202817',3945466,'2629','389',123255.21,124176.45,921.24,150162.12,0.00,0.00,0.00,0.00,0.00),('1','167','885','202817',3945467,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202817',3945468,'2631','389',138942.70,139763.50,820.80,133790.40,0.00,0.00,0.00,0.00,0.00),('1','167','885','202817',3945469,'2632','389',67626.68,67626.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202817',3945470,'2633','389',94937.06,94937.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202817',3945471,'2634','389',89483.22,89868.94,385.72,62872.36,0.00,0.00,0.00,0.00,0.00),('1','167','886','202817',3945472,'2635','389',97945.99,98436.73,490.74,79990.62,0.00,0.00,0.00,0.00,0.00),('1','167','886','202817',3945473,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202817',3945474,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202817',3945475,'2638','389',259912.56,261317.29,1404.73,228970.99,0.00,0.00,0.00,0.00,0.00),('1','167','887','202817',3945476,'2639','389',186754.96,186754.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202817',3945477,'2640','389',178138.81,179154.20,1015.39,165508.57,0.00,0.00,0.00,0.00,0.00),('1','167','888','202817',3945478,'2641','390',538715.34,539987.88,1272.54,343585.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','202817',3945479,'2642','390',336574.93,337375.89,800.96,216259.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','202817',3945480,'2643','390',548247.93,549690.43,1442.50,389475.00,0.00,0.00,0.00,0.00,0.00),('1','167','889','202817',3945481,'2644','390',8143.88,9928.70,1784.82,481901.40,0.00,0.00,0.00,0.00,0.00),('1','167','890','202817',3945482,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202817',3945483,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947617,'2605','389',128101.46,128249.60,148.14,24146.82,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947618,'2606','389',101166.42,101336.18,169.76,27670.88,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947619,'2607','389',165570.26,165880.08,309.82,50500.66,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947620,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947621,'2609','389',111437.51,111564.14,126.63,20640.69,0.00,0.00,0.00,0.00,0.00),('1','167','880','202951',3947622,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947623,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947624,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947625,'2613','389',119956.55,120648.84,692.29,112843.27,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947626,'2614','389',181811.64,182420.93,609.29,99314.27,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947627,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202951',3947628,'2616','389',153719.81,154159.69,439.88,71700.44,0.00,0.00,0.00,0.00,0.00),('1','167','882','202951',3947629,'2617','389',203953.17,204189.67,236.50,38549.50,0.00,0.00,0.00,0.00,0.00),('1','167','882','202951',3947630,'2618','389',107944.18,107944.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202951',3947631,'2619','389',196408.03,196879.95,471.92,76922.96,0.00,0.00,0.00,0.00,0.00),('1','167','882','202951',3947632,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202951',3947633,'2621','389',49411.36,49890.04,478.68,78024.84,0.00,0.00,0.00,0.00,0.00),('1','167','883','202951',3947634,'2622','389',158395.79,158395.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202951',3947635,'2623','389',165439.12,165852.58,413.46,67393.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','202951',3947636,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202951',3947637,'2625','389',204566.28,205817.30,1251.02,203916.26,0.00,0.00,0.00,0.00,0.00),('1','167','884','202951',3947638,'2626','389',148152.22,148152.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202951',3947639,'2627','389',96992.10,97362.77,370.67,60419.21,0.00,0.00,0.00,0.00,0.00),('1','167','884','202951',3947640,'2628','389',176911.30,177454.43,543.13,88530.19,0.00,0.00,0.00,0.00,0.00),('1','167','885','202951',3947641,'2629','389',124176.45,124512.28,335.83,54740.29,0.00,0.00,0.00,0.00,0.00),('1','167','885','202951',3947642,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202951',3947643,'2631','389',139763.50,140148.45,384.95,62746.85,0.00,0.00,0.00,0.00,0.00),('1','167','885','202951',3947644,'2632','389',67626.68,67899.43,272.75,44458.25,0.00,0.00,0.00,0.00,0.00),('1','167','886','202951',3947645,'2633','389',94937.06,95370.93,433.87,70720.81,0.00,0.00,0.00,0.00,0.00),('1','167','886','202951',3947646,'2634','389',89868.94,89868.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202951',3947647,'2635','389',98436.73,98816.24,379.51,61860.13,0.00,0.00,0.00,0.00,0.00),('1','167','886','202951',3947648,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202951',3947649,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202951',3947650,'2638','389',261317.29,262184.59,867.30,141369.90,0.00,0.00,0.00,0.00,0.00),('1','167','887','202951',3947651,'2639','389',186754.96,187370.52,615.56,100336.28,0.00,0.00,0.00,0.00,0.00),('1','167','887','202951',3947652,'2640','389',179154.20,179154.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','202951',3947653,'2641','390',539987.88,541609.11,1621.23,437732.10,0.00,0.00,0.00,0.00,0.00),('1','167','888','202951',3947654,'2642','390',337375.89,338187.66,811.77,219177.90,0.00,0.00,0.00,0.00,0.00),('1','167','889','202951',3947655,'2643','390',549690.43,552023.10,2332.67,629820.90,0.00,0.00,0.00,0.00,0.00),('1','167','889','202951',3947656,'2644','390',9928.70,11336.60,1407.90,380133.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202951',3947657,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202951',3947658,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947907,'2605','389',128249.60,128666.24,416.64,67912.32,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947908,'2606','389',101336.18,101336.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947909,'2607','389',165880.08,166490.52,610.44,99501.72,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947910,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947911,'2609','389',111564.14,111567.21,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','167','880','202963',3947912,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947913,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947914,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947915,'2613','389',120648.84,120648.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947916,'2614','389',182420.93,183683.28,1262.35,205763.05,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947917,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','202963',3947918,'2616','389',154159.69,154820.86,661.17,107770.71,0.00,0.00,0.00,0.00,0.00),('1','167','882','202963',3947919,'2617','389',204189.67,204189.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','202963',3947920,'2618','389',107944.18,108452.47,508.29,82851.27,0.00,0.00,0.00,0.00,0.00),('1','167','882','202963',3947921,'2619','389',196879.95,197318.08,438.13,71415.19,0.00,0.00,0.00,0.00,0.00),('1','167','882','202963',3947922,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202963',3947923,'2621','389',49890.04,49890.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','202963',3947924,'2622','389',158395.79,158923.10,527.31,85951.53,0.00,0.00,0.00,0.00,0.00),('1','167','883','202963',3947925,'2623','389',165852.58,166296.34,443.76,72332.88,0.00,0.00,0.00,0.00,0.00),('1','167','883','202963',3947926,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202963',3947927,'2625','389',205817.30,205817.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','202963',3947928,'2626','389',148152.22,149300.99,1148.77,187249.51,0.00,0.00,0.00,0.00,0.00),('1','167','884','202963',3947929,'2627','389',97362.77,97365.22,2.45,399.35,0.00,0.00,0.00,0.00,0.00),('1','167','884','202963',3947930,'2628','389',177454.43,178894.47,1440.04,234726.52,0.00,0.00,0.00,0.00,0.00),('1','167','885','202963',3947931,'2629','389',124512.28,125159.62,647.34,105516.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','202963',3947932,'2630','389',56960.27,56960.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','202963',3947933,'2631','389',140148.45,140799.88,651.43,106183.09,0.00,0.00,0.00,0.00,0.00),('1','167','885','202963',3947934,'2632','389',67899.43,67899.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202963',3947935,'2633','389',95370.93,96007.50,636.57,103760.91,0.00,0.00,0.00,0.00,0.00),('1','167','886','202963',3947936,'2634','389',89868.94,89868.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','202963',3947937,'2635','389',98816.24,99222.97,406.73,66296.99,0.00,0.00,0.00,0.00,0.00),('1','167','886','202963',3947938,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202963',3947939,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202963',3947940,'2638','389',262184.59,263694.66,1510.07,246141.41,0.00,0.00,0.00,0.00,0.00),('1','167','887','202963',3947941,'2639','389',187370.52,187370.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','202963',3947942,'2640','389',179154.20,180008.80,854.60,139299.80,0.00,0.00,0.00,0.00,0.00),('1','167','888','202963',3947943,'2641','390',541609.11,543687.63,2078.52,561200.40,0.00,0.00,0.00,0.00,0.00),('1','167','888','202963',3947944,'2642','390',338187.66,338989.72,802.06,216556.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','202963',3947945,'2643','390',552023.10,554895.58,2872.48,775569.60,0.00,0.00,0.00,0.00,0.00),('1','167','889','202963',3947946,'2644','390',11336.60,13776.06,2439.46,658654.20,0.00,0.00,0.00,0.00,0.00),('1','167','890','202963',3947947,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','202963',3947948,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952153,'2605','389',128666.24,129014.65,348.41,56790.83,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952154,'2606','389',101336.18,101336.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952155,'2607','389',166490.52,166816.52,326.00,53138.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952156,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952157,'2609','389',111567.21,111874.79,307.58,50135.54,0.00,0.00,0.00,0.00,0.00),('1','167','880','203189',3952158,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952159,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952160,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952161,'2613','389',120648.84,121417.33,768.49,125263.87,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952162,'2614','389',183683.28,184326.89,643.61,104908.43,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952163,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203189',3952164,'2616','389',154820.86,155221.67,400.81,65332.03,0.00,0.00,0.00,0.00,0.00),('1','167','882','203189',3952165,'2617','389',204189.67,204389.21,199.54,32525.02,0.00,0.00,0.00,0.00,0.00),('1','167','882','203189',3952166,'2618','389',108452.47,108452.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','203189',3952167,'2619','389',197318.08,197554.48,236.40,38533.20,0.00,0.00,0.00,0.00,0.00),('1','167','882','203189',3952168,'2620','389',130040.37,130040.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','203189',3952169,'2621','389',49890.04,50205.50,315.46,51419.98,0.00,0.00,0.00,0.00,0.00),('1','167','883','203189',3952170,'2622','389',158923.10,159177.62,254.52,41486.76,0.00,0.00,0.00,0.00,0.00),('1','167','883','203189',3952171,'2623','389',166296.34,166557.21,260.87,42521.81,0.00,0.00,0.00,0.00,0.00),('1','167','883','203189',3952172,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203189',3952173,'2625','389',205817.30,206812.09,994.79,162150.77,0.00,0.00,0.00,0.00,0.00),('1','167','884','203189',3952174,'2626','389',149300.99,149903.16,602.17,98153.71,0.00,0.00,0.00,0.00,0.00),('1','167','884','203189',3952175,'2627','389',97365.22,98227.25,862.03,140510.89,0.00,0.00,0.00,0.00,0.00),('1','167','884','203189',3952176,'2628','389',178894.47,178894.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','203189',3952177,'2629','389',125159.62,125454.96,295.34,48140.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','203189',3952178,'2630','389',56960.27,57188.81,228.54,37252.02,0.00,0.00,0.00,0.00,0.00),('1','167','885','203189',3952179,'2631','389',140799.88,141062.43,262.55,42795.65,0.00,0.00,0.00,0.00,0.00),('1','167','885','203189',3952180,'2632','389',67899.43,68122.53,223.10,36365.30,0.00,0.00,0.00,0.00,0.00),('1','167','886','203189',3952181,'2633','389',96007.50,96007.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','203189',3952182,'2634','389',89868.94,90159.53,290.59,47366.17,0.00,0.00,0.00,0.00,0.00),('1','167','886','203189',3952183,'2635','389',99222.97,99404.36,181.39,29566.57,0.00,0.00,0.00,0.00,0.00),('1','167','886','203189',3952184,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203189',3952185,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203189',3952186,'2638','389',263694.66,264484.25,789.59,128703.17,0.00,0.00,0.00,0.00,0.00),('1','167','887','203189',3952187,'2639','389',187370.52,187878.25,507.73,82759.99,0.00,0.00,0.00,0.00,0.00),('1','167','887','203189',3952188,'2640','389',180008.80,180544.29,535.49,87284.87,0.00,0.00,0.00,0.00,0.00),('1','167','888','203189',3952189,'2641','390',543687.63,546223.68,2536.05,684733.50,0.00,0.00,0.00,0.00,0.00),('1','167','888','203189',3952190,'2642','390',338989.72,340550.06,1560.34,421291.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','203189',3952191,'2643','390',554895.58,557581.01,2685.43,725066.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','203189',3952192,'2644','390',13776.06,17331.54,3555.48,959979.60,0.00,0.00,0.00,0.00,0.00),('1','167','890','203189',3952193,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','203189',3952194,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952972,'2605','389',129014.65,129627.73,613.08,99932.04,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952973,'2606','389',101336.18,101336.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952974,'2607','389',166816.52,167199.76,383.24,62468.12,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952975,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952976,'2609','389',111874.79,112529.62,654.83,106737.29,0.00,0.00,0.00,0.00,0.00),('1','167','880','203227',3952977,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952978,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952979,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952980,'2613','389',121417.33,121417.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952981,'2614','389',184326.89,185951.51,1624.62,264813.06,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952982,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203227',3952983,'2616','389',155221.67,155945.12,723.45,117922.35,0.00,0.00,0.00,0.00,0.00),('1','167','882','203227',3952984,'2617','389',204389.21,204708.49,319.28,52042.64,0.00,0.00,0.00,0.00,0.00),('1','167','882','203227',3952985,'2618','389',108452.47,108452.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','203227',3952986,'2619','389',197554.48,197554.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','203227',3952987,'2620','389',130040.37,130688.29,647.92,105610.96,0.00,0.00,0.00,0.00,0.00),('1','167','883','203227',3952988,'2621','389',50205.50,50205.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','203227',3952989,'2622','389',159177.62,159753.89,576.27,93932.01,0.00,0.00,0.00,0.00,0.00),('1','167','883','203227',3952990,'2623','389',166557.21,167098.64,541.43,88253.09,0.00,0.00,0.00,0.00,0.00),('1','167','883','203227',3952991,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203227',3952992,'2625','389',206812.09,208020.53,1208.44,196975.72,0.00,0.00,0.00,0.00,0.00),('1','167','884','203227',3952993,'2626','389',149903.16,149903.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203227',3952994,'2627','389',98227.25,98227.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203227',3952995,'2628','389',178894.47,179635.73,741.26,120825.38,0.00,0.00,0.00,0.00,0.00),('1','167','885','203227',3952996,'2629','389',125454.96,126001.30,546.34,89053.42,0.00,0.00,0.00,0.00,0.00),('1','167','885','203227',3952997,'2630','389',57188.81,57188.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','203227',3952998,'2631','389',141062.43,141772.16,709.73,115685.99,0.00,0.00,0.00,0.00,0.00),('1','167','885','203227',3952999,'2632','389',68122.53,68122.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','203227',3953000,'2633','389',96007.50,96007.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','203227',3953001,'2634','389',90159.53,90658.89,499.36,81395.68,0.00,0.00,0.00,0.00,0.00),('1','167','886','203227',3953002,'2635','389',99404.36,99960.11,555.75,90587.25,0.00,0.00,0.00,0.00,0.00),('1','167','886','203227',3953003,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203227',3953004,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203227',3953005,'2638','389',264484.25,265723.91,1239.66,202064.58,0.00,0.00,0.00,0.00,0.00),('1','167','887','203227',3953006,'2639','389',187878.25,187878.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203227',3953007,'2640','389',180544.29,181603.20,1058.91,172602.33,0.00,0.00,0.00,0.00,0.00),('1','167','888','203227',3953008,'2641','390',546223.68,548033.16,1809.48,488559.60,0.00,0.00,0.00,0.00,0.00),('1','167','888','203227',3953009,'2642','390',340550.06,342778.99,2228.93,601811.10,0.00,0.00,0.00,0.00,0.00),('1','167','889','203227',3953010,'2643','390',557581.01,560407.03,2826.02,763025.40,0.00,0.00,0.00,0.00,0.00),('1','167','889','203227',3953011,'2644','390',17331.54,18315.19,983.65,265585.50,0.00,0.00,0.00,0.00,0.00),('1','167','890','203227',3953012,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','203227',3953013,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953228,'2605','389',129627.73,130152.66,524.93,85563.59,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953229,'2606','389',101336.18,101336.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953230,'2607','389',167199.76,167199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953231,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953232,'2609','389',112529.62,112910.58,380.96,62096.48,0.00,0.00,0.00,0.00,0.00),('1','167','880','203239',3953233,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953234,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953235,'2612','389',250580.63,250580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953236,'2613','389',121417.33,122107.87,690.54,112558.02,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953237,'2614','389',185951.51,186722.52,771.01,125674.63,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953238,'2615','389',90680.56,90680.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203239',3953239,'2616','389',155945.12,156541.05,595.93,97136.59,0.00,0.00,0.00,0.00,0.00),('1','167','882','203239',3953240,'2617','389',204708.49,204927.31,218.82,35667.66,0.00,0.00,0.00,0.00,0.00),('1','167','882','203239',3953241,'2618','389',108452.47,108452.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','882','203239',3953242,'2619','389',197554.48,197917.71,363.23,59206.49,0.00,0.00,0.00,0.00,0.00),('1','167','882','203239',3953243,'2620','389',130688.29,130688.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','203239',3953244,'2621','389',50205.50,50926.97,721.47,117599.61,0.00,0.00,0.00,0.00,0.00),('1','167','883','203239',3953245,'2622','389',159753.89,159753.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','883','203239',3953246,'2623','389',167098.64,167490.55,391.91,63881.33,0.00,0.00,0.00,0.00,0.00),('1','167','883','203239',3953247,'2624','389',59954.99,59954.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203239',3953248,'2625','389',208020.53,209139.85,1119.32,182449.16,0.00,0.00,0.00,0.00,0.00),('1','167','884','203239',3953249,'2626','389',149903.16,149903.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203239',3953250,'2627','389',98227.25,98227.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','884','203239',3953251,'2628','389',179635.73,180634.69,998.96,162830.48,0.00,0.00,0.00,0.00,0.00),('1','167','885','203239',3953252,'2629','389',126001.30,126596.90,595.60,97082.80,0.00,0.00,0.00,0.00,0.00),('1','167','885','203239',3953253,'2630','389',57188.81,57188.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','885','203239',3953254,'2631','389',141772.16,142179.97,407.81,66473.03,0.00,0.00,0.00,0.00,0.00),('1','167','885','203239',3953255,'2632','389',68122.53,68503.83,381.30,62151.90,0.00,0.00,0.00,0.00,0.00),('1','167','886','203239',3953256,'2633','389',96007.50,96007.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','203239',3953257,'2634','389',90658.89,91122.75,463.86,75609.18,0.00,0.00,0.00,0.00,0.00),('1','167','886','203239',3953258,'2635','389',99960.11,99960.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','886','203239',3953259,'2636','389',47627.89,47627.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203239',3953260,'2637','389',170923.24,170923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','887','203239',3953261,'2638','389',265723.91,266527.98,804.07,131063.41,0.00,0.00,0.00,0.00,0.00),('1','167','887','203239',3953262,'2639','389',187878.25,188266.71,388.46,63318.98,0.00,0.00,0.00,0.00,0.00),('1','167','887','203239',3953263,'2640','389',181603.20,182048.08,444.88,72515.44,0.00,0.00,0.00,0.00,0.00),('1','167','888','203239',3953264,'2641','390',548033.16,551015.66,2982.50,805275.00,0.00,0.00,0.00,0.00,0.00),('1','167','888','203239',3953265,'2642','390',342778.99,343357.05,578.06,156076.20,0.00,0.00,0.00,0.00,0.00),('1','167','889','203239',3953266,'2643','390',560407.03,563289.77,2882.74,778339.80,0.00,0.00,0.00,0.00,0.00),('1','167','889','203239',3953267,'2644','390',18315.19,18315.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','203239',3953268,'2645','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','890','203239',3953269,'2646','390',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955822,'2605','389',130152.66,130643.02,490.36,79928.68,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955823,'2606','389',101336.18,101336.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955824,'2607','389',167199.76,167735.79,536.03,87372.89,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955825,'2608','389',53780.33,53780.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955826,'2609','389',112910.58,112910.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','880','203388',3955827,'2610','389',116788.51,116788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203388',3955828,'2611','389',164820.34,164820.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','167','881','203388',3955829,'2612','389',250580.63,250580.63,0.00,0.00,0.0