-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_161
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_161`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_161` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_161`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3131 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3048,400253,'',0,'24','1','161','SALARIES','','2020-12-11 14:12:36',5,0.00,0.00,'','178','2020-12-11 14:12:36','178',0,1),(3049,20040,'',0,'20','1','161','SALES','','2020-12-11 14:12:46',5,0.00,0.00,'','178','2020-12-11 14:12:46','178',0,1),(3050,400254,'',0,'24','1','161','PURCHASES','','2020-12-11 14:12:56',5,0.00,0.00,'','178','2020-12-11 14:12:56','178',0,1),(3051,40040,'',0,'6.1','1','161','CASH','','2020-12-11 14:13:03',5,0.00,0.00,'','178','2020-12-11 14:13:03','178',0,1),(3119,400452,'',0,'2','1','161','E-BILL COLLECTION ACCOUNT','','2021-02-03 15:57:05',5,0.00,0.00,'','426','2021-02-03 15:57:05','426',0,1),(3120,400453,'',0,'2','1','161','ZENITH BANK 1014717261','','2021-02-03 15:57:49',5,0.00,0.00,'','426','2021-02-03 15:57:49','426',0,1),(3121,400454,'',0,'2','1','161','TRSP ACCT  1017823415','','2021-02-03 16:00:24',5,0.00,0.00,'2021-02-20','426','2021-02-21 10:54:59','426',0,1),(3122,400455,'',0,'2','1','161','POS FIDELITY BANK','','2021-02-03 16:00:55',5,0.00,0.00,'','426','2021-02-03 16:00:55','426',0,1),(3123,400456,'',0,'2','1','161','POS UBA BANK','','2021-02-03 16:01:08',5,0.00,0.00,'','426','2021-02-03 16:01:08','426',0,1),(3124,400457,'',0,'2','1','161','POS ZENITH  BANK','','2021-02-03 16:01:17',5,0.00,0.00,'','426','2021-02-03 16:01:17','426',0,1),(3129,400462,'',0,'2','1','161','KEYSTONE SANI LIMAN','','2021-02-05 10:04:46',5,0.00,0.00,'','426','2021-02-05 10:04:46','426',0,1),(3130,400463,'',0,'2','1','161','ZENITH BANK SUPLUS 1011595101','','2021-02-05 10:05:14',5,0.00,0.00,'','426','2021-02-05 10:05:14','426',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2918 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2915,'','1','161','DRIVER SHORT','DRIVER','080********','driver@gmail.com','YENAGOA','BAYELSA','YENAGOA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 11:10:25',5,'426','2021-07-08 11:10:25','426'),(2916,'','1','161','Yahya Kobison','Yahya Kobison',' 09032447949','yahayakb@gmail.com','Yenagoa','Bayelsa','Bayelsa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 16:05:14',5,'426','2022-03-02 16:05:14','426'),(2917,'','1','161','NIGERIA POLICE FORCE (ELECTION','SP UZEBU A. AYANYO','08066436021','dopstransport@gmail.com','YENAGOA ','BAYELSA STATE','YENAGOA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:32:36',5,'975','2023-02-21 17:32:36','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18438 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','161',15103,'863',1020.00,1500.00,'2021-05-24','','2021-05-27 15:38:47','569','569',2021,'569','2021-05-27 15:38:47',5),('1','161',15859,'862',39881.04,31200.00,'2021-07-26','','2021-07-27 13:55:44','569','569',2021,'569','2021-07-27 13:55:44',5),('1','161',16588,'861',30599.79,16900.00,'2021-09-23','','2021-09-23 13:21:39','426','426',2021,'426','2021-09-23 13:21:39',5),('1','161',16589,'862',32522.59,41700.00,'2021-09-23','','2021-09-23 13:23:27','426','426',2021,'426','2021-09-23 13:23:27',5),('1','161',16590,'863',15692.65,15900.00,'2021-09-23','','2021-09-23 13:23:50','426','426',2021,'426','2021-09-23 13:23:50',5),('1','161',16620,'863',44134.74,43150.00,'2021-09-25','','2021-09-25 14:16:05','426','426',2021,'426','2021-09-25 14:16:05',5),('1','161',16621,'862',41994.56,73000.00,'2021-09-25','','2021-09-25 14:16:50','426','426',2021,'426','2021-09-25 14:16:50',5),('1','161',17349,'861',84.60,800.00,'2021-10-31','','2021-10-31 06:08:38','426','426',2021,'426','2021-10-31 06:08:38',5),('1','161',17350,'862',2376.05,1200.00,'2021-10-31','','2021-10-31 06:09:04','426','426',2021,'426','2021-10-31 06:09:04',5),('1','161',17351,'863',15971.61,15300.00,'2021-10-31','','2021-10-31 06:09:32','426','426',2021,'426','2021-10-31 06:09:32',5),('1','161',18424,'861',1504.46,800.00,'2022-01-12','','2022-01-12 11:10:28','426','426',2022,'426','2022-01-12 11:10:28',5),('1','161',18425,'862',1121.91,1200.00,'2022-01-12','','2022-01-12 11:11:01','426','426',2022,'426','2022-01-12 11:11:01',5),('1','161',18426,'861',2485.48,800.00,'2022-02-06','','2022-02-06 18:21:11','426','426',2022,'426','2022-02-06 18:21:11',5),('1','161',18427,'862',1476.11,1200.00,'2022-02-06','','2022-02-06 18:21:36','426','426',2022,'426','2022-02-06 18:21:36',5),('1','161',18428,'863',757.09,1906.00,'2022-04-01','','2022-04-01 11:34:38','648','648',2022,'648','2022-04-01 11:34:38',5),('1','161',18429,'861',1724.21,800.00,'2022-04-26','','2022-04-26 07:17:35','648','648',2022,'648','2022-04-26 07:17:35',5),('1','161',18430,'862',2863.94,1200.00,'2022-04-26','','2022-04-26 07:18:22','648','648',2022,'648','2022-04-26 07:18:22',5),('1','161',18431,'861',4581.62,20000.00,'2022-06-09','','2022-06-09 11:42:09','426','426',2022,'426','2022-06-09 11:42:09',5),('1','161',18432,'862',862.89,58700.00,'2022-06-09','','2022-06-09 11:42:55','426','426',2022,'426','2022-06-09 11:42:55',5),('1','161',18433,'863',350.56,350.00,'2022-06-09','','2022-06-09 11:43:16','426','426',2022,'426','2022-06-09 11:43:16',5),('1','161',18434,'861',694.78,800.00,'2022-07-08','','2022-07-08 13:51:45','426','426',2022,'426','2022-07-08 13:51:45',5),('1','161',18435,'862',75878.79,1200.00,'2022-07-08','','2022-07-08 13:52:14','426','426',2022,'426','2022-07-08 13:52:14',5),('1','161',18436,'861',10356.62,16180.00,'2022-10-06','','2022-10-06 10:32:46','426','426',2022,'426','2022-10-06 10:32:46',5),('1','161',18437,'862',15387.88,5445.00,'2022-10-06','','2022-10-06 10:33:07','426','426',2022,'426','2022-10-06 10:33:07',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2516 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','161','861',2496,'5','PUMP 9',606320.80,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:58:51','178'),('1','161','861',2497,'5','PUMP 10',1119530.69,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:59:12','178'),('1','161','861',2498,'5','PUMP 11',1294007.77,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:59:33','178'),('1','161','861',2499,'5','PUMP 12',1678540.87,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:59:58','178'),('1','161','861',2500,'5','PUMP 14',1551613.85,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 12:01:03','178'),('1','161','861',2501,'5','PUMP 15',352953.72,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 12:01:29','178'),('1','161','861',2502,'5','PUMP 16',1032493.31,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 12:01:54','178'),('1','161','861',2503,'5','PUMP 17',243567.81,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 12:02:20','178'),('1','161','861',2504,'5','PUMP 18',244348.90,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-01 15:31:52','426'),('1','161','861',2505,'5','PUMP 13',992233.57,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 12:00:34','178'),('1','161','862',2506,'5','PUMP 1',1953506.99,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:54:40','178'),('1','161','862',2507,'5','PUMP 2',1663200.32,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:55:18','178'),('1','161','862',2508,'5','PUMP 3',1533248.98,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:55:51','178'),('1','161','862',2509,'5','PUMP 4',934359.63,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:56:12','178'),('1','161','862',2510,'5','PUMP 5',1376833.56,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:56:35','178'),('1','161','862',2511,'5','PUMP 6',862538.52,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:56:59','178'),('1','161','862',2512,'5','PUMP 7',1057489.69,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:57:25','178'),('1','161','862',2513,'5','PUMP 8',597578.59,'DISPENSING PMS','',NULL,NULL,'',5,'2021-02-02 11:57:50','178'),('1','161','863',2514,'5','AGO PUMP 1',274241.56,'DISPENSING AGO','',NULL,NULL,'',5,'2021-02-02 11:53:38','178'),('1','161','863',2515,'5','AGO PUMP 2',238698.23,'DISPENSING AGO','',NULL,NULL,'',5,'2021-02-02 11:54:10','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258114 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','161',176130,'MORNING SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176464,'MORNING SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'569',3647110.46,0.00,'569','2021-02-03 14:13:41','569','2021-02-03 14:14:53',10,0),('1','161',176535,'MORNING SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176537,'MORNING SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'569',2311670.89,2311670.89,'569','2021-02-03 20:06:53','569','2021-02-03 20:07:35',10,0),('1','161',176543,'AFTERNOON SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'569',2619387.18,2619387.18,'569','2021-02-03 20:16:37','569','2021-02-03 20:17:33',10,0),('1','161',176545,'MORNING SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176548,'MORNING SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'569',2617816.00,2617816.00,'569','2021-02-03 20:58:36','569','2021-02-03 21:00:03',10,0),('1','161',176549,'AFTERNOON SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'569',1936013.79,1936013.79,'569','2021-02-04 11:44:18','569','2021-02-04 11:45:08',10,0),('1','161',176620,'MORNING SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'569',2465964.53,2465964.53,'569','2021-02-04 11:51:05','569','2021-02-04 11:51:48',10,0),('1','161',176624,'AFTERNOON SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'569',1896416.31,1896416.31,'569','2021-02-04 12:24:49','569','2021-02-04 12:25:23',10,0),('1','161',176632,'MORNING SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'569',2102320.00,2102320.00,'569','2021-02-04 12:33:10','569','2021-02-04 12:33:47',10,0),('1','161',176634,'AFTERNOON SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'569',1557723.21,1557723.21,'569','2021-02-04 14:35:11','569','2021-02-04 14:36:06',10,0),('1','161',176675,'MORNING SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'569',2970007.08,2970007.08,'569','2021-02-04 14:45:32','569','2021-02-04 14:46:33',10,0),('1','161',176683,'AFTERNOON SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'569',2346239.97,2346239.97,'569','2021-02-04 14:52:42','569','2021-02-04 14:53:11',10,0),('1','161',176721,'MORNING SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'569',2239217.87,2239217.87,'569','2021-02-04 16:43:08','569','2021-02-04 16:43:37',10,0),('1','161',176724,'AFTERNOON SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'569',2196522.13,2196522.13,'569','2021-02-04 16:48:44','569','2021-02-04 16:49:45',10,0),('1','161',176727,'MORNING SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'569',2205266.51,2205266.51,'569','2021-02-04 16:55:46','569','2021-02-04 16:56:16',10,0),('1','161',176731,'AFTERNOON SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'569',2408876.69,2408876.69,'569','2021-02-04 17:12:05','569','2021-02-04 17:12:33',10,0),('1','161',176734,'MORNING SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'569',2559895.44,2559895.44,'569','2021-02-04 17:19:08','569','2021-02-04 17:20:22',10,0),('1','161',176735,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176736,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176740,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'569',2696568.01,2696568.01,'569','2021-02-04 19:26:19','569','2021-02-04 19:27:03',10,0),('1','161',176759,'MORNING SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'569',2344230.11,2344230.11,'569','2021-02-04 19:51:18','569','2021-02-04 19:51:42',10,0),('1','161',176766,'AFTERNOON SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'569',2844458.87,2844458.87,'569','2021-02-04 19:56:58','569','2021-02-04 19:57:47',10,0),('1','161',176767,'MORNING SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'569',1781120.33,1781120.33,'569','2021-02-04 20:03:25','569','2021-02-04 20:03:56',10,0),('1','161',176768,'AFTERNOON SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'569',2748250.93,2748250.93,'569','2021-02-04 20:19:16','569','2021-02-04 20:19:42',10,0),('1','161',176770,'MORNING SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'569',2044101.00,2044101.00,'569','2021-02-04 20:36:45','569','2021-02-04 20:37:16',10,0),('1','161',176771,'AFTERNOON SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'569',2637417.95,2637417.95,'569','2021-02-04 20:44:14','569','2021-02-04 20:44:52',10,0),('1','161',176772,'MORNING SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'569',2846936.14,2846936.14,'569','2021-02-04 20:51:03','569','2021-02-04 20:51:31',10,0),('1','161',176773,'AFTERNOON SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'569',2711062.22,2711062.22,'569','2021-02-04 20:58:20','569','2021-02-04 20:58:48',10,0),('1','161',176888,'MORNING SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'569',2346097.67,2346097.67,'569','2021-02-05 14:33:39','569','2021-02-05 14:34:13',10,0),('1','161',176891,'AFTERNOON SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'569',3457042.67,3457042.67,'569','2021-02-05 14:37:56','569','2021-02-05 14:38:28',10,0),('1','161',176892,'MORNING SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'569',2696142.09,2696142.09,'569','2021-02-05 15:01:18','569','2021-02-05 15:01:44',10,0),('1','161',176898,'AFTERNOON SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'569',2863852.14,2863852.14,'569','2021-02-05 16:17:55','569','2021-02-05 16:18:24',10,0),('1','161',176927,'MORNING SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'569',2243163.61,2243163.61,'569','2021-02-05 16:32:33','569','2021-02-05 16:33:15',10,0),('1','161',176932,'AFTERNOON SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'569',3433243.22,3433243.22,'569','2021-02-05 16:48:54','569','2021-02-05 16:58:36',10,0),('1','161',176939,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176943,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'569',2959046.05,2959046.05,'569','2021-02-05 17:22:46','569','2021-02-05 17:23:26',10,0),('1','161',176950,'AFTERNOON SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'569',4051581.11,4051581.11,'569','2021-02-05 17:40:14','569','2021-02-05 17:40:46',10,0),('1','161',176951,'MORNING SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'569',2377546.16,2377546.16,'569','2021-02-05 17:47:22','569','2021-02-05 17:47:43',10,0),('1','161',176952,'AFTERNOON SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'569',2736968.86,2736968.86,'569','2021-02-05 18:29:31','569','2021-02-05 18:29:56',10,0),('1','161',176957,'MORNING SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'569',2764708.03,2764708.03,'569','2021-02-05 18:35:07','569','2021-02-05 18:35:31',10,0),('1','161',176959,'AFTERNOON SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'569',3195456.36,3195456.36,'569','2021-02-05 18:41:38','569','2021-02-05 18:42:04',10,0),('1','161',176962,'MORNING SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'569',8243191.59,8243191.59,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176971,'AFTERNOON SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',176972,'MORNING SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'569',2539471.14,2539471.14,'569','2021-02-05 19:54:11','569','2021-02-05 19:54:40',10,0),('1','161',176973,'AFTERNOON SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'569',3262368.93,3262368.93,'569','2021-02-05 19:59:46','569','2021-02-05 20:00:32',10,0),('1','161',177047,'MORNING SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'569',2802238.59,2802238.59,'569','2021-02-06 10:44:39','569','2021-02-06 10:45:13',10,0),('1','161',177053,'AFTERNOON SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'569',2748133.82,2748133.82,'569','2021-02-06 10:50:58','569','2021-02-06 10:51:37',10,0),('1','161',177055,'MORNING SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'569',2576967.22,2576967.22,'569','2021-02-06 11:01:54','569','2021-02-06 11:03:42',10,0),('1','161',177060,'AFTERNOON SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'569',2966268.22,2966268.22,'569','2021-02-06 11:09:11','569','2021-02-06 11:09:36',10,0),('1','161',177062,'MORNING SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'569',2667973.23,2667973.23,'569','2021-02-06 11:15:00','569','2021-02-06 11:15:29',10,0),('1','161',177065,'AFTERNOON SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'569',3537528.45,3537528.45,'569','2021-02-06 11:28:20','569','2021-02-06 11:28:57',10,0),('1','161',177072,'MORNING SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'569',2703778.99,2703778.99,'569','2021-02-06 11:34:04','569','2021-02-06 11:34:31',10,0),('1','161',177076,'AFTERNOON SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'569',3539630.53,3539630.53,'569','2021-02-06 11:39:47','569','2021-02-06 11:40:14',10,0),('1','161',177079,'MORNING SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'569',2349503.99,2349503.99,'569','2021-02-06 11:44:51','569','2021-02-06 11:45:26',10,0),('1','161',177083,'AFTERNOON SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'569',3563740.00,3563740.00,'569','2021-02-06 11:51:43','569','2021-02-06 11:52:13',10,0),('1','161',177085,'MORNING SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'569',3016445.45,3016445.45,'569','2021-02-06 14:14:52','569','2021-02-06 14:15:18',10,0),('1','161',177126,'AFTERNOON SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'569',2731989.81,2731989.81,'569','2021-02-06 14:27:50','569','2021-02-06 14:28:16',10,0),('1','161',177129,'MORNING SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'569',2582908.03,2582908.03,'569','2021-02-06 14:43:05','569','2021-02-06 14:43:33',10,0),('1','161',177135,'AFTERNOON SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'569',3067845.72,3067845.72,'569','2021-02-07 14:52:37','569','2021-02-07 14:53:03',10,0),('1','161',177350,'MORNING SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'569',2605295.78,2605295.78,'569','2021-02-07 15:10:31','569','2021-02-07 15:10:58',10,0),('1','161',177353,'AFTERNOON SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'569',3093144.51,3093144.51,'569','2021-02-07 16:53:37','569','2021-02-07 16:54:09',10,0),('1','161',177381,'MORNING SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'569',2846024.11,2846024.11,'569','2021-02-07 17:02:35','569','2021-02-07 17:03:05',10,0),('1','161',177384,'AFTERNOON SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'569',3456016.79,3456016.79,'569','2021-02-07 17:07:49','569','2021-02-07 17:08:18',10,0),('1','161',177385,'MORNING SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'569',2521714.24,2521714.24,'569','2021-02-07 17:14:21','569','2021-02-07 17:14:52',10,0),('1','161',177387,'AFTERNOON SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'569',3056754.28,3056754.28,'569','2021-02-07 17:21:39','569','2021-02-07 17:22:31',10,0),('1','161',177392,'MORNING SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'569',2554779.18,2554779.18,'569','2021-02-07 17:31:14','569','2021-02-07 17:31:42',10,0),('1','161',177395,'AFTERNOON SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'569',3556914.78,3556914.78,'569','2021-02-07 17:38:40','569','2021-02-07 17:39:52',10,0),('1','161',177422,'MORNING SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'569',1742235.54,1742235.54,'569','2021-02-07 21:49:41','569','2021-02-07 21:50:07',10,0),('1','161',177423,'AFTERNOON SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'569',2497313.08,2497313.08,'569','2021-02-09 12:07:31','569','2021-02-09 12:08:01',10,0),('1','161',177741,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',177744,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'569',2393980.24,2393980.24,'569','2021-02-09 12:24:51','569','2021-02-09 12:25:19',10,0),('1','161',177746,'AFTERNOON SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'569',3131591.26,3131591.26,'569','2021-02-09 12:31:25','569','2021-02-09 12:33:40',10,0),('1','161',177752,'MORNING SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'569',3057597.22,3057597.22,'569','2021-02-09 12:43:21','569','2021-02-09 12:43:47',10,0),('1','161',177753,'AFTERNOON SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'569',3678699.80,3678699.80,'569','2021-02-09 12:50:42','569','2021-02-09 12:51:20',10,0),('1','161',177759,'MORNING SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'569',3139667.32,3139667.32,'569','2021-02-09 14:20:39','569','2021-02-09 14:21:08',10,0),('1','161',177784,'AFTERNOON SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'569',3131963.20,3131963.20,'569','2021-02-09 14:24:32','569','2021-02-09 14:25:01',10,0),('1','161',177787,'MORNING SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'569',1392641.74,1392641.74,'569','2021-02-09 14:35:02','569','2021-02-09 14:35:30',10,0),('1','161',177790,'AFTERNOON SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'569',3413704.40,3413704.40,'569','2021-02-09 15:51:06','569','2021-02-09 15:51:31',10,0),('1','161',177814,'MORNING SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'569',2353812.19,2353812.19,'569','2021-02-09 16:00:39','569','2021-02-09 16:01:02',10,0),('1','161',177821,'AFTERNOON SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'569',3224932.88,3224932.88,'569','2021-02-09 16:11:45','569','2021-02-09 16:12:11',10,0),('1','161',177825,'MORNING SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'569',2407757.42,2407757.42,'569','2021-02-09 16:17:50','569','2021-02-09 16:18:19',10,0),('1','161',177828,'AFTERNOON SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'569',2574175.88,2574175.88,'569','2021-02-09 16:25:43','569','2021-02-09 16:26:09',10,0),('1','161',177830,'MORNING SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'569',2240476.13,2240476.13,'569','2021-02-09 16:36:18','569','2021-02-09 16:38:06',10,0),('1','161',177832,'AFTERNOON SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'569',2809242.22,2809242.22,'569','2021-02-09 16:44:56','569','2021-02-09 16:45:23',10,0),('1','161',177840,'MORNING SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'569',2862502.10,2862502.10,'569','2021-02-09 17:18:51','569','2021-02-09 17:19:24',10,0),('1','161',177845,'AFTERNOON SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'569',3587574.30,3587574.30,'569','2021-02-09 17:24:42','569','2021-02-09 17:25:10',10,0),('1','161',177847,'MORNING SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'569',2570134.36,2570134.36,'569','2021-02-09 17:33:11','569','2021-02-09 17:33:43',10,0),('1','161',177849,'AFTERNOON SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'569',3378412.73,3378412.73,'569','2021-02-09 17:38:49','569','2021-02-09 17:39:21',10,0),('1','161',177850,'MORNING SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'569',2701521.20,2701521.20,'569','2021-02-09 17:44:06','569','2021-02-09 17:44:36',10,0),('1','161',177851,'AFTERNOON SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'569',4121836.97,4121836.97,'569','2021-02-09 17:50:12','569','2021-02-09 17:50:38',10,0),('1','161',178112,'MORNING SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'569',1626279.89,1646472.21,'569','2021-02-11 10:09:25','569','2021-02-11 10:09:54',10,0),('1','161',178117,'AFTERNOON SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'569',2593435.81,2621662.99,'569','2021-02-11 10:20:48','569','2021-02-11 10:21:22',10,0),('1','161',178123,'MORNING SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'569',1711992.51,1732472.29,'569','2021-02-11 10:37:26','569','2021-02-11 10:37:57',10,0),('1','161',178126,'AFTERNOON SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'569',2627673.75,2660726.25,'569','2021-02-11 10:43:13','569','2021-02-11 10:43:38',10,0),('1','161',178130,'MORNING SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'569',1844141.69,1866459.51,'569','2021-02-11 10:50:14','569','2021-02-11 10:50:52',10,0),('1','161',178133,'AFTERNOON SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'569',2515594.65,2547237.35,'569','2021-02-11 10:58:06','569','2021-02-11 10:58:48',10,0),('1','161',178138,'MORNING SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'569',2025796.45,2044879.55,'569','2021-02-11 11:10:36','569','2021-02-11 11:12:34',10,0),('1','161',178143,'AFTERNOON SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'569',2633532.90,2666659.10,'569','2021-02-11 11:28:30','569','2021-02-11 11:29:04',10,0),('1','161',178145,'MORNING SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'569',2034104.60,2049171.25,'569','2021-02-11 11:36:01','569','2021-02-11 11:36:36',10,0),('1','161',178149,'AFTERNOON SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'569',2383836.13,2400999.12,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',178156,'AFTERNOON SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'569',2397888.35,2386946.90,'569','2021-02-11 11:55:09','569','2021-02-11 11:55:40',10,0),('1','161',178161,'MORNING SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'569',1983290.50,1975106.20,'569','2021-02-11 12:02:07','569','2021-02-11 12:02:33',10,0),('1','161',178167,'AFTERNOON SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'569',2957048.90,2941971.80,'569','2021-02-11 12:26:01','569','2021-02-11 12:26:33',10,0),('1','161',178176,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'569',958574.40,958574.40,'569','2021-02-11 12:34:56','569','2021-02-11 12:35:26',10,0),('1','161',178178,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',178182,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'569',1367522.01,1340379.81,'569','2021-02-11 12:44:13','569','2021-02-11 12:44:38',10,0),('1','161',178184,'AFTERNOON SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'569',3377700.23,3338518.43,'569','2021-02-11 17:26:23','569','2021-02-11 17:27:00',10,0),('1','161',178260,'MORNING SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'569',2183016.27,2160594.57,'569','2021-02-11 17:35:33','569','2021-02-11 17:36:05',10,0),('1','161',178263,'AFTERNOON SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'569',3264020.23,3226591.33,'569','2021-02-11 17:44:57','569','2021-02-11 17:45:33',10,0),('1','161',178266,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'569',3225997.92,3129819.42,'569','2021-02-11 18:00:58','569','2021-02-11 18:01:33',10,0),('1','161',178267,'AFTERNOON SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'569',3201686.99,3192514.79,'569','2021-02-12 16:35:21','569','2021-02-12 16:35:46',10,0),('1','161',178442,'MORNING SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'569',2159559.78,2150175.48,'569','2021-02-12 16:43:03','569','2021-02-12 16:44:55',10,0),('1','161',178443,'AFTERNOON SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'569',3346558.90,3288626.20,'569','2021-02-12 16:54:03','569','2021-02-12 16:54:29',10,0),('1','161',178447,'MORNING SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'569',3697877.67,3614369.37,'569','2021-02-12 16:59:33','569','2021-02-12 17:00:01',10,0),('1','161',178451,'AFTERNOON SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'569',3490423.96,3427469.71,'569','2021-02-12 17:04:29','569','2021-02-12 17:08:04',10,0),('1','161',178473,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',178476,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'569',2665337.80,2665337.80,'569','2021-02-12 19:22:26','569','2021-02-12 19:22:52',10,0),('1','161',178477,'AFTERNOON SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'569',3378358.28,3378358.28,'569','2021-02-12 19:28:02','569','2021-02-12 19:28:28',10,0),('1','161',178480,'MORNING SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'569',2563970.85,2563970.85,'569','2021-02-12 19:37:43','569','2021-02-12 19:38:04',10,0),('1','161',178481,'AFTERNOON SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'569',3364957.52,3364957.52,'569','2021-02-12 19:44:11','569','2021-02-12 19:44:36',10,0),('1','161',178484,'MORNING SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'569',2659903.45,2659903.45,'569','2021-02-12 19:50:45','569','2021-02-12 19:51:18',10,0),('1','161',178485,'AFTERNOON SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'569',3965057.53,3965057.53,'569','2021-02-12 19:58:22','569','2021-02-12 19:58:56',10,0),('1','161',178486,'MORNING SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'569',2498545.38,2498545.38,'569','2021-02-12 20:13:31','569','2021-02-12 20:14:01',10,0),('1','161',178487,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'569',3342680.13,3342680.13,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',178497,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'569',3350584.08,3350584.08,'569','2021-02-13 07:32:35','569','2021-02-13 07:33:03',10,0),('1','161',178500,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'569',2895376.14,2895376.14,'569','2021-02-13 07:38:23','569','2021-02-13 07:38:57',10,0),('1','161',178501,'AFTERNOON SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'569',3602461.14,3602461.14,'569','2021-02-13 07:44:08','569','2021-02-13 07:45:02',10,0),('1','161',178506,'MORNING SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'569',2083520.40,2083520.40,'569','2021-02-13 07:55:04','569','2021-02-13 07:55:27',10,0),('1','161',178511,'AFTERNOON SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'569',2973632.46,2973632.46,'569','2021-02-13 08:01:50','569','2021-02-13 08:02:25',10,0),('1','161',178515,'MORNING SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'569',2700690.48,2700690.48,'569','2021-02-13 08:07:47','569','2021-02-13 08:08:18',10,0),('1','161',178516,'AFTERNOON SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'569',3746075.19,3746075.19,'569','2021-02-13 08:13:47','569','2021-02-13 08:14:12',10,0),('1','161',178523,'MORNING SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'569',2544406.08,2544406.08,'569','2021-02-13 08:31:21','569','2021-02-13 08:31:47',10,0),('1','161',178524,'AFTERNOON SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'569',3453132.96,3453132.96,'569','2021-02-13 08:37:43','569','2021-02-13 08:38:09',10,0),('1','161',178527,'MORNING SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'569',2487302.58,2487302.58,'569','2021-02-13 08:54:22','569','2021-02-13 08:54:48',10,0),('1','161',178532,'AFTERNOON SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'569',2985804.69,2985804.69,'569','2021-02-13 09:16:32','569','2021-02-13 09:17:31',10,0),('1','161',178538,'MORNING SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'569',1995682.80,1995682.80,'569','2021-02-13 09:38:40','569','2021-02-13 09:39:17',10,0),('1','161',178544,'AFTERNOON SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'569',3457260.00,3457260.00,'569','2021-02-13 09:46:46','569','2021-02-13 09:47:13',10,0),('1','161',178545,'MORNING SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'569',2384898.66,2384898.66,'569','2021-02-13 09:51:41','569','2021-02-13 09:52:09',10,0),('1','161',178548,'AFTERNOON SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'569',3098141.49,3098141.49,'569','2021-02-13 10:02:41','569','2021-02-13 10:03:25',10,0),('1','161',178557,'MORNING SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'569',2455109.94,2455109.94,'569','2021-02-13 10:19:33','569','2021-02-13 10:20:13',10,0),('1','161',178563,'AFTERNOON SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'569',4256327.52,4256327.52,'569','2021-02-13 10:25:32','569','2021-02-13 10:26:06',10,0),('1','161',178570,'MORNING SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'569',2219570.94,2219570.94,'569','2021-02-13 10:34:42','569','2021-02-13 10:35:21',10,0),('1','161',178573,'AFTERNOON SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'569',3954494.91,3954494.91,'569','2021-02-13 10:40:54','569','2021-02-13 10:41:18',10,0),('1','161',178575,'MORNING SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'569',2808903.90,2808903.90,'569','2021-02-13 10:48:27','569','2021-02-13 10:49:01',10,0),('1','161',178577,'AFTERNOON SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'569',3910299.03,3910299.03,'569','2021-02-13 10:57:56','569','2021-02-13 10:58:37',10,0),('1','161',178579,'MORNING SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'569',2610126.93,2610126.93,'569','2021-02-13 11:21:14','569','2021-02-13 11:26:01',10,0),('1','161',178584,'AFTERNOON SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'569',3293292.48,3293292.48,'569','2021-02-13 11:31:56','569','2021-02-13 11:32:34',10,0),('1','161',178586,'MORNING SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'569',2563997.31,2563997.31,'569','2021-02-13 11:46:04','569','2021-02-13 11:46:31',10,0),('1','161',178589,'AFTERNOON SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'569',3121109.58,3121109.58,'569','2021-02-13 11:51:36','569','2021-02-13 11:54:15',10,0),('1','161',178591,'MORNING SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'569',2654327.40,2654327.40,'569','2021-02-13 12:06:32','569','2021-02-13 12:07:11',10,0),('1','161',178596,'AFTERNOON SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'569',3183804.87,3183804.87,'569','2021-02-13 12:13:25','569','2021-02-13 12:13:51',10,0),('1','161',178598,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'569',2498906.01,2498906.01,'569','2021-02-14 06:30:42','569','2021-02-14 06:31:11',10,0),('1','161',178724,'AFTERNOON SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'569',3293834.46,3293834.46,'569','2021-02-14 06:37:57','569','2021-02-14 06:38:32',10,0),('1','161',178726,'MORNING SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'569',2371623.33,2371623.33,'569','2021-02-14 06:48:49','569','2021-02-14 06:49:19',10,0),('1','161',178727,'AFTERNOON SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'569',3360431.61,3360431.61,'569','2021-02-14 06:55:37','569','2021-02-14 06:56:04',10,0),('1','161',178730,'MORNING SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'569',2383820.22,2383820.22,'569','2021-02-14 07:04:12','569','2021-02-14 07:04:52',10,0),('1','161',178733,'AFTERNOON SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'569',3341146.50,3341146.50,'569','2021-02-14 07:11:17','569','2021-02-14 07:11:45',10,0),('1','161',178734,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'569',2785307.94,2785307.94,'569','2021-02-14 07:17:39','569','2021-02-14 07:18:05',10,0),('1','161',178736,'AFTERNOON SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'569',4330930.83,4330930.83,'569','2021-02-15 17:43:05','569','2021-02-15 17:43:32',10,0),('1','161',179098,'MORNING SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'569',3855093.82,3757712.76,'569','2021-02-15 17:49:51','569','2021-02-15 17:50:26',10,0),('1','161',179100,'AFTERNOON SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'569',5338725.06,5202650.58,'569','2021-02-15 18:27:07','569','2021-02-15 18:27:31',10,0),('1','161',179103,'MORNING SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'569',3108532.87,3027851.91,'569','2021-02-15 18:36:20','569','2021-02-15 18:36:45',10,0),('1','161',179104,'AFTERNOON SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'569',4850551.26,4718254.68,'569','2021-02-15 18:44:24','569','2021-02-15 18:44:50',10,0),('1','161',179105,'MORNING SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'569',3972810.19,3871652.67,'569','2021-02-15 18:51:18','569','2021-02-15 18:51:59',10,0),('1','161',179108,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',179110,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'569',5769128.87,5635806.91,'569','2021-02-15 19:38:20','569','2021-02-15 19:38:47',10,0),('1','161',179115,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'569',3917141.99,3831110.27,'569','2021-02-15 19:44:26','569','2021-02-15 19:44:50',10,0),('1','161',179116,'AFTERNOON SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'569',3943898.94,3850389.42,'569','2021-02-15 19:55:13','569','2021-02-15 19:55:36',10,0),('1','161',179118,'MORNING SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'569',4151005.77,4060069.01,'569','2021-02-15 21:55:48','569','2021-02-15 21:56:11',10,0),('1','161',179124,'AFTERNOON SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'569',4645207.98,4539593.34,'569','2021-02-15 22:02:09','569','2021-02-15 22:02:39',10,0),('1','161',179125,'MORNING SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'569',3613539.36,3526823.68,'569','2021-02-15 22:07:26','569','2021-02-15 22:07:53',10,0),('1','161',179126,'AFTERNOON SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'569',2370470.34,2314440.82,'569','2021-02-15 22:12:37','569','2021-02-15 22:13:09',10,0),('1','161',179127,'MORNING SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'569',2945373.93,2877658.29,'569','2021-02-15 22:23:44','569','2021-02-15 22:24:17',10,0),('1','161',179128,'AFTERNOON SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',179129,'AFTERNOON SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'569',2326636.55,2326636.55,'569','2021-02-15 22:31:21','569','2021-02-15 22:31:47',10,0),('1','161',179130,'MORNING SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'569',3768143.54,3768143.54,'569','2021-02-15 22:36:34','569','2021-02-15 22:37:00',10,0),('1','161',179131,'AFTERNOON SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'569',4443663.35,4443663.35,'569','2021-02-15 22:41:43','569','2021-02-15 22:42:11',10,0),('1','161',179132,'MORNING SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'569',3365816.76,3365816.76,'569','2021-02-15 22:47:09','569','2021-02-15 22:47:39',10,0),('1','161',179133,'AFTERNOON SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'569',3584070.82,3584070.82,'569','2021-02-15 22:53:08','569','2021-02-15 22:53:38',10,0),('1','161',179134,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',179135,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'569',3816317.29,3816317.29,'569','2021-02-15 23:07:08','569','2021-02-15 23:07:37',10,0),('1','161',179136,'AFTERNOON SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'569',3057070.04,3057070.04,'569','2021-02-15 23:16:45','569','2021-02-15 23:17:12',10,0),('1','161',179137,'MORNING SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'569',2539187.52,2539187.52,'569','2021-02-16 12:14:49','569','2021-02-16 12:18:42',10,0),('1','161',179255,'AFTERNOON SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'569',3683038.69,3683038.69,'569','2021-02-16 12:23:35','569','2021-02-16 12:24:01',10,0),('1','161',179257,'MORNING SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'569',3048146.84,3048146.84,'569','2021-02-16 12:29:37','569','2021-02-16 12:30:02',10,0),('1','161',179259,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',179262,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'569',3020552.33,3020552.33,'569','2021-02-16 12:39:45','569','2021-02-16 12:40:09',10,0),('1','161',179263,'MORNING SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'569',2901811.35,2901811.35,'569','2021-02-19 10:36:13','569','2021-02-19 10:36:42',10,0),('1','161',179831,'AFTERNOON SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'569',3931650.91,3931650.91,'569','2021-02-19 10:41:47','569','2021-02-19 10:42:11',10,0),('1','161',179844,'MORNING SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'569',2816315.20,2816315.20,'569','2021-02-19 11:17:44','569','2021-02-19 11:18:14',10,0),('1','161',179849,'AFTERNOON SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'569',3285640.57,3285640.57,'569','2021-02-19 11:23:31','569','2021-02-19 11:23:59',10,0),('1','161',179852,'MORNING SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'569',3804860.95,3804860.95,'569','2021-02-19 11:43:07','569','2021-02-19 11:43:35',10,0),('1','161',179861,'AFTERNOON SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',179862,'AFTERNOON SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'569',3360822.97,3360822.97,'569','2021-02-19 11:55:50','569','2021-02-19 11:56:22',10,0),('1','161',179865,'MORNING SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'569',3453456.54,3453456.54,'569','2021-02-20 14:03:32','569','2021-02-20 14:04:45',10,0),('1','161',180099,'AFTERNOON SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'569',2044590.96,2044590.96,'569','2021-02-20 14:38:44','569','2021-02-20 14:39:10',10,0),('1','161',180112,'MORNING SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'569',4096378.06,4096378.06,'569','2021-02-23 11:07:09','569','2021-02-23 11:07:33',10,0),('1','161',180628,'AFTERNOON SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'569',1883013.93,1883013.93,'569','2021-02-23 14:27:44','569','2021-02-23 14:32:21',10,0),('1','161',180661,'MORNING SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'569',2602449.30,2602449.30,'569','2021-02-23 14:41:12','569','2021-02-23 14:42:33',10,0),('1','161',180792,'AFTERNOON SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'569',2941552.75,2941552.75,'569','2021-02-24 10:07:29','569','2021-02-24 10:08:00',10,0),('1','161',180794,'MORNING SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'569',3322249.44,3322249.44,'569','2021-02-24 10:13:24','569','2021-02-24 10:13:58',10,0),('1','161',180797,'AFTERNOON SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'569',4022410.17,4022410.17,'569','2021-02-24 10:20:21','569','2021-02-24 10:20:59',10,0),('1','161',180800,'MORNING SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'569',3734712.38,3734712.38,'569','2021-02-24 10:26:01','569','2021-02-24 10:26:30',10,0),('1','161',180803,'AFTERNOON SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',180807,'AFTERNOON SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'569',2974178.05,2974178.05,'569','2021-02-24 10:35:34','569','2021-02-24 10:36:00',10,0),('1','161',180810,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'569',2558646.26,2558646.26,'569','2021-02-24 15:58:15','569','2021-02-24 15:58:46',10,0),('1','161',180915,'AFTERNOON SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'569',3842647.27,3842647.27,'569','2021-03-07 06:14:07','569','2021-03-07 06:14:51',10,0),('1','161',182833,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'569',3916594.95,3870590.89,'569','2021-03-07 06:27:13','569','2021-03-07 06:28:09',10,0),('1','161',182836,'AFTERNOON SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'569',4017556.35,3970788.53,'569','2021-03-07 06:35:33','569','2021-03-07 06:36:14',10,0),('1','161',182838,'MORNING SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',182839,'MORNING SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'569',3343823.35,3304955.99,'569','2021-03-07 06:44:36','569','2021-03-07 06:45:05',10,0),('1','161',182841,'AFTERNOON SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'569',1218352.05,1203986.57,'569','2021-03-07 06:48:18','569','2021-03-07 06:48:52',10,0),('1','161',182842,'MORNING SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'569',2595653.15,2565566.37,'569','2021-03-07 06:52:11','569','2021-03-07 06:52:40',10,0),('1','161',182843,'MORNING SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'569',2481758.15,2453816.85,'569','2021-03-07 06:56:36','569','2021-03-07 06:57:07',10,0),('1','161',182846,'AFTERNOON SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'569',4060278.85,4011303.33,'569','2021-03-07 07:08:34','569','2021-03-07 07:09:04',10,0),('1','161',182849,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'569',1314335.55,1298404.21,'569','2021-03-07 10:30:25','569','2021-03-07 10:32:15',10,0),('1','161',182876,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',182877,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'569',3468031.45,3468031.45,'569','2021-03-07 10:50:21','569','2021-03-07 10:54:52',10,0),('1','161',182879,'AFTERNOON SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'569',7114567.00,7114567.00,'569','2021-03-07 11:03:25','569','2021-03-07 11:03:51',10,0),('1','161',182883,'MORNING SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'569',5296387.15,5296387.15,'569','2021-03-07 11:12:40','569','2021-03-07 11:13:08',10,0),('1','161',182885,'AFTERNOON SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'569',6684559.40,6684559.40,'569','2021-03-07 15:54:37','569','2021-03-07 15:56:43',10,0),('1','161',182945,'MORNING SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'569',3278790.35,3278790.35,'569','2021-03-07 16:03:59','569','2021-03-07 16:06:13',10,0),('1','161',182946,'AFTERNOON SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'569',1736000.70,1736000.70,'569','2021-03-07 16:11:06','569','2021-03-07 16:11:43',10,0),('1','161',182948,'MORNING SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'569',2808545.75,2808545.75,'569','2021-03-07 16:15:31','569','2021-03-07 16:16:03',10,0),('1','161',182950,'AFTERNOON SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'569',2966690.40,2966690.40,'569','2021-03-07 16:19:37','569','2021-03-07 16:20:11',10,0),('1','161',182952,'MORNING SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'569',3297065.95,3297065.95,'569','2021-03-07 16:25:58','569','2021-03-07 16:26:33',10,0),('1','161',182953,'AFTERNOON SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'569',2707970.60,2707970.60,'569','2021-03-11 13:49:09','569','2021-03-11 13:51:28',10,0),('1','161',183779,'MORNING SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'569',1478738.25,1478738.25,'569','2021-03-11 14:06:02','569','2021-03-11 14:06:36',10,0),('1','161',183789,'MORNING SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'569',243292.55,243292.55,'569','2021-03-11 14:08:55','569','2021-03-11 14:09:19',10,0),('1','161',183791,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',183793,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'569',1978617.10,1978617.10,'569','2021-03-11 14:18:41','569','2021-03-11 14:20:13',10,0),('1','161',183837,'MORNING SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'569',2626444.70,2626444.70,'569','2021-03-11 18:38:05','569','2021-03-11 18:38:51',10,0),('1','161',183842,'AFTERNOON SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'569',3244520.00,3244520.00,'569','2021-03-11 18:44:54','569','2021-03-11 18:45:28',10,0),('1','161',183844,'MORNING SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'569',3366917.75,3366917.75,'569','2021-03-14 11:12:12','569','2021-03-14 11:13:21',10,0),('1','161',184343,'AFTERNOON SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',184346,'AFTERNOON SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'569',3931388.54,3909280.45,'569','2021-03-14 11:28:12','569','2021-03-14 11:35:20',10,0),('1','161',184347,'MORNING SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'569',3515926.94,3496395.95,'569','2021-03-14 11:40:19','569','2021-03-14 11:42:51',10,0),('1','161',184350,'AFTERNOON SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'569',129625.60,129625.60,'569','2021-03-14 11:46:25','569','2021-03-14 11:47:05',10,0),('1','161',184352,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',184356,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'569',3605287.38,3605287.38,'569','2021-03-14 12:01:17','569','2021-03-14 12:03:46',10,0),('1','161',185239,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'569',2339997.80,2339997.80,'569','2021-03-18 18:43:56','612','2021-03-19 09:50:39',10,0),('1','161',185533,'AFTERNOON SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'569',1767050.04,1767050.04,'569','2021-03-20 11:17:42','612','2021-03-20 12:55:58',10,0),('1','161',185557,'MORNING SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'569',2889410.74,2889410.74,'569','2021-03-20 13:25:24','612','2021-03-20 13:50:50',10,0),('1','161',186056,'AFTERNOON SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'569',570545.16,570545.16,'569','2021-03-22 19:40:41','612','2021-03-23 11:22:39',10,0),('1','161',186199,'MORNING SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'569',2721663.92,2786865.36,'569','2021-03-23 12:02:58','612','2021-03-23 12:12:23',10,0),('1','161',186202,'AFTERNOON SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'569',3621531.00,3693352.60,'569','2021-03-23 12:19:34','612','2021-03-23 12:33:27',10,0),('1','161',186210,'MORNING SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'569',2919944.10,2991656.30,'569','2021-03-23 12:48:33','612','2021-03-23 13:10:58',10,0),('1','161',186216,'AFTERNOON SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'569',3674386.80,3765112.40,'569','2021-03-23 13:17:51','612','2021-03-23 13:23:54',10,0),('1','161',186219,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'569',3849724.64,3944394.32,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',186221,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'569',3920726.90,3920726.90,'569','2021-03-23 13:41:00','612','2021-03-23 14:25:24',10,0),('1','161',186244,'AFTERNOON SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'569',3268834.80,3268834.80,'569','2021-03-23 15:24:13','612','2021-03-23 19:52:54',10,0),('1','161',186296,'MORNING SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'569',2488147.20,2488147.20,'569','2021-03-23 20:24:50','612','2021-03-24 07:09:54',10,0),('1','161',186455,'AFTERNOON SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'569',2946934.55,2946934.55,'569','2021-03-24 14:47:02','612','2021-03-24 14:55:48',10,0),('1','161',186461,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'569',2350753.35,2350753.35,'569','2021-03-24 15:03:02','612','2021-03-24 15:21:03',10,0),('1','161',186468,'AFTERNOON SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'569',1025220.20,1025220.20,'569','2021-03-24 15:43:40','612','2021-03-24 20:33:59',10,0),('1','161',186716,'MORNING SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'569',2257464.38,2298961.85,'569','2021-03-25 20:18:52','612','2021-03-25 23:21:07',10,0),('1','161',186805,'AFTERNOON SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'569',3496891.00,3554652.70,'569','2021-03-26 09:44:05','612','2021-03-26 09:47:24',10,0),('1','161',186808,'MORNING SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'569',2823310.74,2872175.85,'569','2021-03-26 09:59:29','612','2021-03-26 10:06:47',10,0),('1','161',186816,'AFTERNOON SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'569',3786151.38,3854359.35,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',186818,'AFTERNOON SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'569',3786151.38,3786151.38,'569','2021-03-26 10:25:44','612','2021-03-26 11:18:08',10,0),('1','161',186840,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'569',3439828.34,3439828.34,'569','2021-03-26 11:31:18','612','2021-03-26 13:12:13',10,0),('1','161',186854,'AFTERNOON SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'569',3410647.76,3410647.76,'569','2021-03-26 13:32:56','612','2021-03-26 13:41:13',10,0),('1','161',186869,'MORNING SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'569',2358335.06,2358335.06,'569','2021-03-26 14:11:59','612','2021-03-26 14:37:32',10,0),('1','161',186891,'AFTERNOON SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'569',4506670.18,4506670.18,'569','2021-03-26 15:02:22','612','2021-03-26 15:08:21',10,0),('1','161',186900,'MORNING SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'569',4000045.50,4000045.50,'569','2021-03-26 19:38:41','612','2021-03-27 06:12:42',10,0),('1','161',187035,'AFTERNOON SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'569',4120021.88,4120021.88,'569','2021-03-27 10:49:29','612','2021-03-27 11:57:09',10,0),('1','161',187049,'MORNING SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'569',3123939.50,3123939.50,'569','2021-03-27 12:17:43','612','2021-03-27 12:30:21',10,0),('1','161',187053,'AFTERNOON SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'569',4214003.16,4214003.16,'569','2021-03-29 11:39:03','612','2021-03-29 11:48:52',10,0),('1','161',187515,'MORNING SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'569',2154761.42,2154761.42,'569','2021-03-29 16:08:29','612','2021-03-29 20:55:19',10,0),('1','161',187626,'AFTERNOON SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'569',2192237.79,2192237.79,'569','2021-03-30 08:52:51','612','2021-03-30 08:58:15',10,0),('1','161',187636,'MORNING SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'569',727016.70,727016.70,'569','2021-03-30 09:16:44','612','2021-03-30 09:23:42',10,0),('1','161',187645,'AFTERNOON SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'569',3510097.25,3510097.25,'569','2021-03-30 09:42:17','612','2021-03-30 09:52:09',10,0),('1','161',187659,'MORNING SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'569',4022514.73,4022514.73,'569','2021-03-30 10:44:49','612','2021-03-30 11:36:34',10,0),('1','161',187684,'AFTERNOON SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'569',3794709.45,3794709.45,'569','2021-03-30 12:00:27','612','2021-03-30 12:31:52',10,0),('1','161',187743,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'569',2855765.85,2855765.85,'569','2021-03-30 15:49:48','612','2021-03-30 16:56:12',10,0),('1','161',187848,'AFTERNOON SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'569',3705672.25,3705672.25,'569','2021-03-31 10:21:58','612','2021-03-31 15:13:42',10,0),('1','161',188085,'MORNING SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'569',2531517.30,2531517.30,'569','2021-04-01 10:01:54','612','2021-04-01 11:37:36',10,0),('1','161',188116,'AFTERNOON SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'569',4231897.10,4231897.10,'569','2021-04-01 12:13:35','426','2021-04-01 12:46:15',10,0),('1','161',188121,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'569',3040684.65,3040684.65,'569','2021-04-01 13:47:33','612','2021-04-01 17:44:38',10,0),('1','161',188187,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'569',3876113.20,3876113.20,'569','2021-04-02 10:53:46','612','2021-04-02 13:33:02',10,0),('1','161',188332,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'569',2784495.00,2784495.00,'569','2021-04-02 15:00:54','612','2021-04-02 16:22:23',10,0),('1','161',188392,'AFTERNOON SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'569',3997117.20,3997117.20,'569','2021-04-03 12:21:55','612','2021-04-03 13:19:50',10,0),('1','161',188519,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'569',2368355.85,2368355.85,'569','2021-04-03 14:04:23','612','2021-04-03 15:34:16',10,0),('1','161',188581,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'569',2827861.05,2827861.05,'569','2021-04-04 08:42:22','612','2021-04-04 13:45:12',10,0),('1','161',188705,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'569',2198678.45,2198678.45,'569','2021-04-04 14:09:19','612','2021-04-04 15:40:07',10,0),('1','161',188839,'AFTERNOON SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'569',4135303.55,4135303.55,'569','2021-04-05 09:21:30','612','2021-04-05 13:33:41',10,0),('1','161',188911,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'569',2804172.35,2804172.35,'569','2021-04-05 14:03:47','612','2021-04-05 17:36:20',10,0),('1','161',188975,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'569',3797073.95,3797073.95,'569','2021-04-06 14:53:27','612','2021-04-07 08:21:31',10,0),('1','161',189246,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'569',3549288.60,3549288.60,'569','2021-04-07 08:52:58','612','2021-04-07 13:04:55',10,0),('1','161',189337,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'569',4100831.55,4100831.55,'569','2021-04-07 14:38:45','612','2021-04-07 15:01:03',10,0),('1','161',189343,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'569',2890097.70,2890097.70,'569','2021-04-07 15:25:05','426','2021-04-07 16:15:05',10,0),('1','161',189393,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'569',3940419.25,3940419.25,'569','2021-04-08 09:05:48','612','2021-04-08 12:46:02',10,0),('1','161',189545,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'569',2858626.55,2858626.55,'569','2021-04-08 14:13:08','612','2021-04-09 00:07:32',10,0),('1','161',189665,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'569',2883797.75,2883797.75,'569','2021-04-09 09:24:06','612','2021-04-09 11:14:05',10,0),('1','161',189712,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'569',2635433.05,2635433.05,'569','2021-04-09 14:04:12','612','2021-04-09 15:56:35',10,0),('1','161',189843,'AFTERNOON SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'569',4492842.15,4492842.15,'569','2021-04-10 08:47:57','612','2021-04-10 10:37:05',10,0),('1','161',189899,'MORNING SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'569',2448565.95,2448565.95,'569','2021-04-10 18:37:09','612','2021-04-11 09:47:11',10,0),('1','161',190125,'AFTERNOON SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'569',2949801.20,2949801.20,'569','2021-04-11 13:50:58','612','2021-04-11 22:26:28',10,0),('1','161',190307,'MORNING SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'569',1945835.60,1945835.60,'569','2021-04-12 12:16:27','426','2021-04-12 13:38:26',10,0),('1','161',190343,'AFTERNOON SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'569',4324074.20,4324074.20,'569','2021-04-13 10:37:43','426','2021-04-13 10:45:53',10,0),('1','161',190522,'AFTERNOON SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'569',1647214.00,1647214.00,'569','2021-04-13 10:59:50','426','2021-04-13 11:02:25',10,0),('1','161',190523,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'569',653077.52,653077.52,'569','2021-04-13 11:08:01','612','2021-04-13 11:38:26',10,0),('1','161',190541,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'569',1878496.30,1878496.30,'569','2021-04-13 15:51:47','612','2021-04-14 07:30:07',10,0),('1','161',190741,'AFTERNOON SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'569',2867233.05,2867233.05,'569','2021-04-16 14:05:43','612','2021-04-16 17:00:56',10,0),('1','161',191258,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'569',2809394.15,2809394.15,'569','2021-04-16 17:30:01','612','2021-04-17 07:34:11',10,0),('1','161',191371,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'569',2914873.30,2914873.30,'569','2021-04-17 11:34:26','612','2021-04-17 12:58:19',10,0),('1','161',191421,'AFTERNOON SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'569',3403094.90,3403094.90,'569','2021-04-17 14:27:16','612','2021-04-17 17:11:25',10,0),('1','161',191479,'MORNING SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'569',2144602.70,2144602.70,'569','2021-04-18 10:47:31','612','2021-04-18 11:44:52',10,0),('1','161',191590,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'569',3246743.15,3246743.15,'569','2021-04-18 12:34:04','612','2021-04-18 17:23:17',10,0),('1','161',191685,'MORNING SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'569',2164783.40,2164783.40,'569','2021-04-18 20:44:02','612','2021-04-19 07:08:41',10,0),('1','161',191792,'AFTERNOON SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'569',2515800.60,2515800.60,'569','2021-04-19 10:51:56','426','2021-04-19 10:54:26',10,0),('1','161',191800,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'569',2138656.95,2138656.95,'569','2021-04-19 15:21:03','612','2021-04-19 19:49:32',10,0),('1','161',191916,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'569',3232453.29,3232453.29,'569','2021-04-20 10:13:14','612','2021-04-20 12:39:59',10,0),('1','161',192037,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'569',3435680.75,3435680.75,'569','2021-04-20 13:36:36','612','2021-04-20 14:28:33',10,0),('1','161',192093,'AFTERNOON SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'569',4439049.21,4439049.21,'569','2021-04-21 10:44:22','612','2021-04-21 14:45:54',10,0),('1','161',192292,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'569',2663607.21,2663607.21,'569','2021-04-21 16:40:31','612','2021-04-21 18:53:44',10,0),('1','161',192425,'AFTERNOON SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'569',3167913.20,3167913.20,'569','2021-04-22 11:06:01','612','2021-04-22 11:21:00',10,0),('1','161',192471,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'569',2384672.82,2384672.82,'569','2021-04-23 14:40:21','612','2021-04-23 16:15:30',10,0),('1','161',192723,'AFTERNOON SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'569',2560516.47,2560516.47,'569','2021-04-23 17:23:00','612','2021-04-23 17:28:30',10,0),('1','161',192726,'MORNING SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'569',2484992.92,2484992.92,'569','2021-04-23 17:44:46','612','2021-04-24 09:49:14',10,0),('1','161',192860,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'569',2753774.19,2753774.19,'569','2021-04-24 17:10:56','612','2021-04-25 09:02:25',10,0),('1','161',193013,'MORNING SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'569',913992.89,913992.89,'569','2021-04-25 10:37:40','612','2021-04-25 16:59:35',10,0),('1','161',193139,'AFTERNOON SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'569',2841527.81,2841527.81,'569','2021-04-26 11:34:53','612','2021-04-26 12:44:12',10,0),('1','161',193305,'MORNING SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'569',2362721.33,2362721.33,'569','2021-04-26 13:37:36','612','2021-04-26 13:40:58',10,0),('1','161',193307,'AFTERNOON SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'569',2760959.51,2760959.51,'569','2021-04-26 13:56:11','612','2021-04-26 20:01:15',10,0),('1','161',193386,'MORNING SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'569',2804450.43,2804450.43,'569','2021-04-26 20:52:04','612','2021-04-27 08:54:30',10,0),('1','161',193482,'AFTERNOON SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'569',2755887.69,2755887.69,'569','2021-04-27 11:03:07','612','2021-04-27 14:50:56',10,0),('1','161',193607,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'569',2481157.02,2481157.02,'569','2021-04-27 20:26:52','612','2021-04-28 08:21:15',10,0),('1','161',193676,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'569',3429285.56,3429285.56,'569','2021-04-28 13:57:12','612','2021-04-28 14:21:43',10,0),('1','161',193830,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'569',2110999.37,2110999.37,'569','2021-04-28 20:27:54','612','2021-04-29 07:56:41',10,0),('1','161',193921,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'569',3166337.87,3166337.87,'569','2021-04-29 10:21:03','612','2021-04-29 11:52:29',10,0),('1','161',194001,'MORNING SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'569',2639050.76,2639050.76,'569','2021-04-29 14:00:38','612','2021-04-29 20:49:09',10,0),('1','161',194256,'AFTERNOON SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'569',2708231.06,2708231.06,'569','2021-04-30 17:39:26','612','2021-05-01 07:25:17',10,0),('1','161',194441,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'569',2646737.24,2646737.24,'569','2021-05-01 16:57:26','612','2021-05-02 05:45:23',10,0),('1','161',194609,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'569',3599081.62,3599081.62,'569','2021-05-02 15:50:00','612','2021-05-02 16:56:33',10,0),('1','161',194649,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'569',2876664.39,2876664.39,'569','2021-05-03 14:24:10','612','2021-05-03 14:29:29',10,0),('1','161',194818,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'569',671586.62,671586.62,'569','2021-05-03 14:34:40','612','2021-05-03 14:40:25',10,0),('1','161',194821,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'569',1840746.47,1840746.47,'569','2021-05-03 14:50:29','612','2021-05-03 16:17:53',10,0),('1','161',194844,'MORNING SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'569',2547498.77,2547498.77,'569','2021-05-03 16:43:44','612','2021-05-03 16:46:27',10,0),('1','161',194848,'AFTERNOON SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'569',3326119.91,3326119.91,'569','2021-05-04 16:17:55','612','2021-05-04 17:39:38',10,0),('1','161',195059,'MORNING SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'569',929235.29,929235.29,'569','2021-05-04 20:29:01','612','2021-05-04 21:00:08',10,0),('1','161',195203,'AFTERNOON SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'569',2764406.14,2764406.14,'569','2021-05-05 12:36:23','612','2021-05-05 13:49:29',10,0),('1','161',195237,'MORNING SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'569',2493122.22,2493122.22,'569','2021-05-05 13:58:02','612','2021-05-05 17:00:03',10,0),('1','161',195286,'AFTERNOON SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'569',3430063.67,3430063.67,'569','2021-05-06 12:31:32','612','2021-05-06 13:03:41',10,0),('1','161',195476,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'569',2612850.92,2612850.92,'569','2021-05-06 17:00:49','612','2021-05-06 17:27:48',10,0),('1','161',195498,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'569',3653257.16,3653257.16,'569','2021-05-07 11:46:44','612','2021-05-07 13:16:47',10,0),('1','161',195854,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'569',2823003.19,2823003.19,'569','2021-05-08 10:40:05','612','2021-05-08 10:49:21',10,0),('1','161',195861,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'569',3511894.08,3511894.08,'569','2021-05-08 11:03:17','426','2021-05-08 11:32:12',10,0),('1','161',195870,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'569',2553481.52,2553481.52,'569','2021-05-08 13:23:43','612','2021-05-08 20:54:05',10,0),('1','161',195977,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'569',3578135.80,3578135.80,'569','2021-05-08 21:20:09','612','2021-05-09 09:56:59',10,0),('1','161',196127,'MORNING SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'569',1972632.05,1972632.05,'569','2021-05-09 13:41:02','426','2021-05-09 17:24:56',10,0),('1','161',196205,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'569',3068922.19,3068922.19,'569','2021-05-09 21:50:56','612','2021-05-10 06:41:02',10,0),('1','161',196369,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'569',2714611.50,2714611.50,'569','2021-05-10 14:28:55','612','2021-05-10 20:48:37',10,0),('1','161',196425,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'569',3311376.08,3311376.08,'569','2021-05-10 21:12:16','612','2021-05-11 09:16:57',10,0),('1','161',196587,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'569',2441147.39,2441147.39,'569','2021-05-11 14:17:46','612','2021-05-11 16:28:04',10,0),('1','161',196637,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'569',3332227.02,3332227.02,'569','2021-05-11 21:19:19','612','2021-05-12 05:57:40',10,0),('1','161',196753,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'569',2348649.27,2348649.27,'569','2021-05-12 14:02:11','612','2021-05-12 18:27:30',10,0),('1','161',196851,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'569',3165065.91,3165065.91,'569','2021-05-12 22:11:26','612','2021-05-13 08:27:54',10,0),('1','161',196951,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'569',2085833.11,2085833.11,'569','2021-05-13 14:23:57','612','2021-05-13 15:43:19',10,0),('1','161',197008,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'569',2773286.40,2773286.40,'569','2021-05-13 21:23:51','612','2021-05-14 07:18:45',10,0),('1','161',197190,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'569',2435136.12,2435136.12,'569','2021-05-14 18:31:50','612','2021-05-14 20:37:50',10,0),('1','161',197207,'AFTERNOON SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'569',3663045.02,3663045.02,'569','2021-05-14 21:13:05','612','2021-05-16 11:56:48',10,0),('1','161',197356,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',197360,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'569',2394114.94,2394114.94,'569','2021-05-16 13:20:58','426','2021-05-16 13:24:04',10,0),('1','161',197411,'AFTERNOON SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'569',3107453.46,3107453.46,'569','2021-05-16 13:37:40','426','2021-05-16 13:43:15',10,0),('1','161',197419,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'569',2257082.53,2257082.53,'569','2021-05-16 14:19:21','612','2021-05-16 18:32:29',10,0),('1','161',197589,'AFTERNOON SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'569',2691370.00,2691370.00,'569','2021-05-17 10:13:28','612','2021-05-17 11:42:09',10,0),('1','161',197741,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'569',2624211.51,2624211.51,'569','2021-05-17 14:46:04','612','2021-05-17 15:35:00',10,0),('1','161',197943,'AFTERNOON SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'569',3123940.59,3123940.59,'569','2021-05-18 09:45:53','612','2021-05-18 11:32:36',10,0),('1','161',198069,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'569',2498598.30,2498598.30,'569','2021-05-18 16:57:53','612','2021-05-18 19:53:45',10,0),('1','161',198254,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'569',2840153.92,2840153.92,'569','2021-05-19 14:05:26','612','2021-05-19 14:10:21',10,0),('1','161',198259,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'569',2777626.86,2777626.86,'569','2021-05-19 14:20:02','612','2021-05-19 16:05:20',10,0),('1','161',198419,'AFTERNOON SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'569',3687304.62,3687304.62,'569','2021-05-20 09:47:17','612','2021-05-20 10:40:16',10,0),('1','161',198483,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'569',2659584.01,2659584.01,'569','2021-05-20 14:10:34','612','2021-05-20 16:58:49',10,0),('1','161',198638,'AFTERNOON SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'569',3184368.84,3184368.84,'569','2021-05-21 09:56:16','612','2021-05-21 10:21:24',10,0),('1','161',198672,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'569',2840751.88,2840751.88,'569','2021-05-21 14:51:39','612','2021-05-21 16:21:10',10,0),('1','161',198874,'AFTERNOON SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'569',2912527.14,2912527.14,'569','2021-05-22 11:54:22','612','2021-05-22 13:12:55',10,0),('1','161',198902,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'569',3214250.64,3214250.64,'569','2021-05-22 13:34:24','612','2021-05-23 08:23:20',10,0),('1','161',199088,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'569',2993923.17,2993923.17,'569','2021-05-23 12:00:35','612','2021-05-23 13:48:31',10,0),('1','161',199142,'MORNING SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'569',2033441.04,2033441.04,'569','2021-05-23 15:15:09','612','2021-05-23 16:01:53',10,0),('1','161',199315,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'569',2626060.08,2626060.08,'569','2021-05-24 10:51:26','612','2021-05-24 11:20:57',10,0),('1','161',199349,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'569',2917955.02,2917955.02,'569','2021-05-25 19:24:38','612','2021-05-26 08:29:07',10,0),('1','161',199769,'AFTERNOON SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'569',2197281.59,2197281.59,'569','2021-05-27 16:36:30','612','2021-05-27 16:42:04',10,0),('1','161',200064,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'569',2190103.86,2190103.86,'569','2021-05-27 17:33:28','612','2021-05-27 18:05:26',10,0),('1','161',200165,'AFTERNOON SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'569',2173922.85,2173922.85,'569','2021-05-28 10:18:11','426','2021-05-28 10:40:07',10,0),('1','161',200196,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'569',2173929.37,2173929.37,'569','2021-05-28 11:59:36','612','2021-05-28 13:16:34',10,0),('1','161',200275,'AFTERNOON SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'569',2513645.82,2513645.82,'569','2021-05-28 20:14:04','612','2021-05-29 05:34:42',10,0),('1','161',200320,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'569',1962425.46,1962425.46,'569','2021-05-29 08:18:50','612','2021-05-29 11:00:18',10,0),('1','161',200380,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'569',2272976.32,2272976.32,'569','2021-05-29 11:51:40','612','2021-05-29 13:57:33',10,0),('1','161',200402,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'569',2138031.88,2138031.88,'569','2021-05-29 14:08:25','612','2021-05-29 14:12:40',10,0),('1','161',200410,'AFTERNOON SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'569',2701738.04,2701738.04,'569','2021-05-29 14:24:33','612','2021-05-29 14:28:02',10,0),('1','161',200421,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'569',1549370.42,1549370.42,'569','2021-05-29 14:46:49','612','2021-05-29 14:55:27',10,0),('1','161',200573,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'569',2799761.35,2799761.35,'569','2021-05-30 11:39:07','612','2021-05-30 12:12:52',10,0),('1','161',200585,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'569',1738623.20,1738623.20,'569','2021-05-30 13:28:21','612','2021-05-30 14:20:25',10,0),('1','161',200774,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'569',2728944.37,2728944.37,'569','2021-05-31 10:26:09','612','2021-05-31 13:22:40',10,0),('1','161',200835,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'569',1923450.53,1923450.53,'569','2021-05-31 14:21:44','612','2021-05-31 16:26:35',10,0),('1','161',200959,'AFTERNOON SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'569',2642816.80,2642816.80,'569','2021-06-01 08:16:50','612','2021-06-01 09:13:02',10,0),('1','161',201033,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',201168,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'569',2536462.95,2536462.95,'569','2021-06-02 14:42:04','612','2021-06-02 16:23:58',10,0),('1','161',201285,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'569',2550977.12,2550977.12,'569','2021-06-02 19:51:45','612','2021-06-03 08:00:00',10,0),('1','161',201362,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'569',2262105.20,2262105.20,'569','2021-06-03 09:05:26','612','2021-06-03 10:34:44',10,0),('1','161',201393,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'569',2850073.39,2850073.39,'569','2021-06-03 10:57:49','612','2021-06-03 14:12:01',10,0),('1','161',201443,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'569',2477836.39,2477836.39,'569','2021-06-03 16:09:52','612','2021-06-04 06:37:43',10,0),('1','161',201583,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'569',2967036.86,2967036.86,'569','2021-06-04 10:17:55','612','2021-06-04 12:21:18',10,0),('1','161',201718,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'569',2467835.22,2467835.22,'569','2021-06-04 18:31:51','612','2021-06-05 06:31:31',10,0),('1','161',201827,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',201829,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'569',3518144.94,3518144.94,'569','2021-06-05 11:08:57','612','2021-06-05 13:34:57',10,0),('1','161',201965,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'569',2628687.65,2628687.65,'569','2021-06-06 19:38:00','612','2021-06-07 06:30:18',10,0),('1','161',202276,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'569',3176760.17,3176760.17,'569','2021-06-07 09:40:50','612','2021-06-07 13:48:49',10,0),('1','161',202388,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'569',1977274.47,1977274.47,'569','2021-06-07 17:39:29','612','2021-06-07 18:56:18',10,0),('1','161',202480,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'569',2548630.94,2548630.94,'569','2021-06-08 10:07:57','612','2021-06-08 14:06:54',10,0),('1','161',202558,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'569',514130.79,514130.79,'569','2021-06-08 14:26:29','612','2021-06-09 07:57:29',10,0),('1','161',202685,'AFTERNOON SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'569',607615.72,607615.72,'569','2021-06-09 10:28:18','612','2021-06-09 12:44:06',10,0),('1','161',202773,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'569',2689168.67,2689168.67,'569','2021-06-09 14:06:17','612','2021-06-09 18:16:19',10,0),('1','161',202812,'AFTERNOON SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'569',2762954.88,2762954.88,'569','2021-06-09 18:37:45','612','2021-06-10 07:47:09',10,0),('1','161',203004,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'569',1974128.82,1974128.82,'569','2021-06-10 13:52:32','612','2021-06-10 14:01:35',10,0),('1','161',203049,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'569',2915470.58,2915470.58,'569','2021-06-10 16:01:22','612','2021-06-10 16:12:32',10,0),('1','161',203063,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'569',1995452.96,1995452.96,'569','2021-06-10 16:48:32','612','2021-06-10 17:13:22',10,0),('1','161',203094,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'569',2815812.61,2815812.61,'569','2021-06-11 10:43:11','612','2021-06-11 11:52:31',10,0),('1','161',203273,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'569',2371371.59,2371371.59,'569','2021-06-11 18:33:40','612','2021-06-11 19:00:18',10,0),('1','161',203279,'AFTERNOON SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'569',3363014.13,3363014.13,'569','2021-06-12 11:49:35','612','2021-06-12 15:01:12',10,0),('1','161',203598,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'569',2104881.17,2104881.17,'569','2021-06-13 16:19:17','612','2021-06-13 18:24:23',10,0),('1','161',203695,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'569',2636694.62,2636694.62,'569','2021-06-15 09:28:04','612','2021-06-15 10:00:13',10,0),('1','161',204046,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'569',2147872.31,2147872.31,'569','2021-06-15 10:35:18','612','2021-06-15 11:37:00',10,0),('1','161',204066,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'569',3331866.28,3331866.28,'569','2021-06-15 11:53:28','612','2021-06-15 17:14:43',10,0),('1','161',204161,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'569',2558127.03,2558127.03,'569','2021-06-16 08:19:12','612','2021-06-16 15:21:04',10,0),('1','161',204348,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'569',2659434.82,2659434.82,'569','2021-06-16 16:55:48','612','2021-06-16 21:15:12',10,0),('1','161',204397,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'569',1719950.33,1719950.33,'569','2021-06-17 14:16:44','612','2021-06-17 15:52:19',10,0),('1','161',204564,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'569',2597036.10,2597036.10,'569','2021-06-17 16:02:58','612','2021-06-17 21:00:27',10,0),('1','161',204664,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'569',1960260.26,1960260.26,'569','2021-06-18 08:32:55','612','2021-06-18 10:42:35',10,0),('1','161',204720,'AFTERNOON SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'569',2622096.53,2622096.53,'569','2021-06-18 12:32:44','612','2021-06-18 13:52:02',10,0),('1','161',204783,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'569',1816365.84,1816365.84,'569','2021-06-18 17:32:39','612','2021-06-19 09:51:06',10,0),('1','161',204907,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'569',2996484.67,2996484.67,'569','2021-06-19 10:11:10','612','2021-06-19 13:20:00',10,0),('1','161',205002,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'569',2174465.11,2174465.11,'569','2021-06-19 18:32:46','612','2021-06-20 09:06:33',10,0),('1','161',205089,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'569',2872639.17,2872639.17,'569','2021-06-20 11:13:38','612','2021-06-21 06:34:49',10,0),('1','161',205535,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'569',1917686.67,1917686.67,'569','2021-06-22 22:07:45','612','2021-06-24 08:43:12',10,0),('1','161',206337,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'569',2507486.08,2507486.08,'569','2021-06-25 21:14:45','612','2021-06-26 09:17:16',10,0),('1','161',206418,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'569',2581151.73,2581151.73,'569','2021-06-26 09:36:42','612','2021-06-26 09:56:02',10,0),('1','161',206426,'AFTERNOON SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'569',1539270.74,1539270.74,'569','2021-06-26 10:05:36','612','2021-06-26 10:07:23',10,0),('1','161',206429,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'569',4169638.32,4169638.32,'569','2021-06-26 10:29:46','612','2021-06-26 10:31:35',10,0),('1','161',206434,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'569',1864382.28,1864382.28,'569','2021-06-26 10:41:49','612','2021-06-26 10:45:43',10,0),('1','161',206442,'AFTERNOON SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'569',2614721.52,2614721.52,'569','2021-06-26 11:03:59','612','2021-06-26 11:08:33',10,0),('1','161',206445,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'569',2526707.74,2526707.74,'569','2021-06-26 11:17:54','612','2021-06-26 11:19:10',10,0),('1','161',206450,'AFTERNOON SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'569',2705242.29,2705242.29,'569','2021-06-26 11:31:31','612','2021-06-26 11:34:13',10,0),('1','161',206456,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'569',2161855.36,2161855.36,'569','2021-06-26 11:44:15','612','2021-06-26 11:46:44',10,0),('1','161',206464,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'569',3111023.01,3111023.01,'569','2021-06-26 12:10:56','612','2021-06-26 12:14:34',10,0),('1','161',206496,'MORNING SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'569',2102575.58,2102575.58,'569','2021-06-26 14:32:38','612','2021-06-26 15:46:02',10,0),('1','161',206688,'AFTERNOON SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'569',3121028.15,3121028.15,'569','2021-06-27 13:18:36','612','2021-06-27 14:26:09',10,0),('1','161',206707,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'569',1700825.15,1700825.15,'569','2021-06-27 14:41:48','612','2021-06-27 15:22:30',10,0),('1','161',206886,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'569',3115363.07,3115363.07,'569','2021-06-28 09:53:58','612','2021-06-28 10:23:14',10,0),('1','161',206949,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'569',2184035.09,2184035.09,'569','2021-06-28 14:06:20','612','2021-06-28 15:19:13',10,0),('1','161',206997,'AFTERNOON SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'569',3007333.35,3007333.35,'569','2021-06-29 10:18:26','612','2021-06-29 12:13:02',10,0),('1','161',207161,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'569',2135896.55,2135896.55,'569','2021-06-29 13:51:19','612','2021-06-29 15:12:21',10,0),('1','161',207218,'AFTERNOON SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'569',3267652.94,3267652.94,'569','2021-06-30 09:27:33','612','2021-06-30 10:41:11',10,0),('1','161',207369,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'569',2040096.63,2040096.63,'569','2021-06-30 12:31:35','612','2021-06-30 13:45:53',10,0),('1','161',207410,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'569',3371551.90,3371551.90,'569','2021-07-01 09:36:27','612','2021-07-01 10:41:02',10,0),('1','161',207582,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'569',2018720.75,2018720.75,'569','2021-07-01 13:23:51','612','2021-07-01 15:10:16',10,0),('1','161',207656,'AFTERNOON SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'569',2791447.28,2791447.28,'569','2021-07-02 20:15:30','612','2021-07-03 08:43:02',10,0),('1','161',207970,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'569',2140030.44,2140030.44,'569','2021-07-03 09:52:39','612','2021-07-03 11:03:26',10,0),('1','161',207994,'AFTERNOON SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'569',3140118.88,3140118.88,'569','2021-07-03 11:27:59','612','2021-07-03 16:25:20',10,0),('1','161',208258,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'569',2412635.65,2412635.65,'569','2021-07-04 14:31:32','612','2021-07-04 14:43:51',10,0),('1','161',208395,'AFTERNOON SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'569',3278467.04,3278467.04,'569','2021-07-06 10:08:05','612','2021-07-06 11:56:51',10,0),('1','161',208662,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'569',2069856.08,2069856.08,'569','2021-07-06 13:24:08','612','2021-07-06 13:35:05',10,0),('1','161',208676,'AFTERNOON SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'569',2380666.65,2380666.65,'569','2021-07-06 13:46:32','612','2021-07-06 13:58:10',10,0),('1','161',208686,'MORNING SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'569',2710300.36,2710300.36,'569','2021-07-06 14:08:29','612','2021-07-06 14:12:01',10,0),('1','161',208694,'AFTERNOON SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'569',3158790.76,3158790.76,'569','2021-07-06 14:34:20','426','2021-07-06 15:00:16',10,0),('1','161',208706,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'569',2168472.80,2168472.80,'569','2021-07-06 16:16:56','612','2021-07-06 16:39:05',10,0),('1','161',208723,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'569',2985336.41,2985336.41,'569','2021-07-06 20:32:24','612','2021-07-07 07:20:41',10,0),('1','161',208820,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'569',2186634.22,2186634.22,'569','2021-07-07 13:18:10','612','2021-07-07 14:28:21',10,0),('1','161',209078,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'569',3233389.82,3233389.82,'569','2021-07-08 10:33:21','612','2021-07-08 12:08:37',10,0),('1','161',209114,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'569',2571024.15,2571024.15,'569','2021-07-08 14:49:55','612','2021-07-08 14:52:54',10,0),('1','161',209143,'AFTERNOON SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'569',3114209.07,3114209.07,'569','2021-07-09 10:20:58','612','2021-07-09 11:58:55',10,0),('1','161',209327,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'569',2122801.22,2122801.22,'569','2021-07-09 13:18:21','612','2021-07-09 14:57:44',10,0),('1','161',209515,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'569',2722610.81,2722610.81,'569','2021-07-10 10:43:55','612','2021-07-10 12:49:10',10,0),('1','161',209563,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'569',1955283.76,1955283.76,'569','2021-07-10 13:58:29','612','2021-07-10 14:15:53',10,0),('1','161',209607,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'569',3072816.53,3072816.53,'569','2021-07-10 20:50:45','612','2021-07-11 08:08:10',10,0),('1','161',209747,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'569',2231449.25,2231449.25,'569','2021-07-11 13:04:19','612','2021-07-11 17:25:16',10,0),('1','161',209934,'AFTERNOON SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'569',2986967.75,2986967.75,'569','2021-07-12 09:36:47','612','2021-07-12 09:40:29',10,0),('1','161',209956,'MORNING SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'569',2055604.26,2055604.26,'569','2021-07-12 12:57:11','612','2021-07-12 13:20:13',10,0),('1','161',210068,'AFTERNOON SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'569',2919479.07,2919479.07,'569','2021-07-13 09:53:03','612','2021-07-13 13:21:00',10,0),('1','161',210219,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'569',2193748.02,2193748.02,'569','2021-07-13 13:32:04','612','2021-07-14 09:43:51',10,0),('1','161',210451,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'569',2624788.99,2624788.99,'569','2021-07-14 15:14:55','612','2021-07-14 15:18:19',10,0),('1','161',210469,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'569',2375301.16,2375301.16,'569','2021-07-14 16:42:25','612','2021-07-15 07:08:10',10,0),('1','161',210625,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'569',2796416.38,2796416.38,'569','2021-07-15 13:54:42','612','2021-07-15 14:32:43',10,0),('1','161',210682,'MORNING SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'569',1874732.57,1874732.57,'569','2021-07-15 16:30:42','612','2021-07-15 20:02:25',10,0),('1','161',210705,'AFTERNOON SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'569',2806753.54,2806753.54,'569','2021-07-16 08:53:25','612','2021-07-16 09:27:12',10,0),('1','161',210821,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'569',1773058.17,1773058.17,'569','2021-07-16 12:51:35','612','2021-07-16 12:52:21',10,0),('1','161',210925,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'569',2733383.45,2733383.45,'569','2021-07-17 13:06:11','612','2021-07-17 13:14:16',10,0),('1','161',211066,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'569',2138093.95,2138093.95,'569','2021-07-17 13:53:26','612','2021-07-17 14:16:56',10,0),('1','161',211235,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'569',2942141.17,2942141.17,'569','2021-07-18 10:18:56','612','2021-07-18 14:44:50',10,0),('1','161',211306,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'569',2435329.64,2435329.64,'569','2021-07-19 13:36:03','612','2021-07-19 13:55:25',10,0),('1','161',211521,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'569',2284979.61,2284979.61,'569','2021-07-19 14:11:49','612','2021-07-19 14:51:40',10,0),('1','161',211535,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'569',1643589.74,1643589.74,'569','2021-07-19 15:15:08','612','2021-07-19 17:18:32',10,0),('1','161',211579,'AFTERNOON SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'569',2472344.88,2472344.88,'569','2021-07-19 21:01:47','612','2021-07-20 09:03:46',10,0),('1','161',211736,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'569',1667831.10,1667831.10,'569','2021-07-20 18:42:16','612','2021-07-21 10:38:57',10,0),('1','161',211871,'AFTERNOON SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'569',2460522.49,2460522.49,'569','2021-07-21 11:59:16','612','2021-07-21 12:45:13',10,0),('1','161',211893,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'569',1665607.48,1665607.48,'569','2021-07-21 13:45:51','612','2021-07-21 15:23:25',10,0),('1','161',211967,'AFTERNOON SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'569',2490525.90,2490525.90,'569','2021-07-22 09:47:12','612','2021-07-22 10:45:09',10,0),('1','161',212099,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'569',2211331.48,2211331.48,'569','2021-07-22 12:49:13','612','2021-07-22 14:32:44',10,0),('1','161',212209,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'569',2793189.12,2793189.12,'569','2021-07-23 09:19:55','612','2021-07-23 10:33:20',10,0),('1','161',212375,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'569',2273374.47,2273374.47,'569','2021-07-23 14:28:12','612','2021-07-23 15:30:14',10,0),('1','161',212434,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'569',3195184.00,3195184.00,'569','2021-07-25 12:41:19','612','2021-07-25 12:43:43',10,0),('1','161',212762,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'569',1999339.04,1999339.04,'569','2021-07-25 12:57:44','612','2021-07-25 12:59:41',10,0),('1','161',212767,'AFTERNOON SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'569',2332054.73,2332054.73,'569','2021-07-25 13:23:15','612','2021-07-25 13:42:32',10,0),('1','161',212779,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'569',1544121.02,1544121.02,'569','2021-07-25 13:50:25','612','2021-07-25 14:48:29',10,0),('1','161',212960,'AFTERNOON SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'569',488502.07,488502.07,'569','2021-07-26 10:15:15','612','2021-07-26 13:16:05',10,0),('1','161',213207,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'569',1408581.41,1408581.41,'569','2021-07-27 18:20:06','612','2021-07-27 19:12:04',10,0),('1','161',213362,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'569',2687478.17,2687478.17,'569','2021-07-27 19:58:39','612','2021-07-27 22:03:28',10,0),('1','161',213494,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'569',2968007.92,2968007.92,'569','2021-07-28 11:16:58','612','2021-07-28 11:57:52',10,0),('1','161',213526,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'569',1835988.94,1835988.94,'569','2021-07-28 13:36:01','612','2021-07-28 18:41:52',10,0),('1','161',213703,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'569',2888260.89,2888260.89,'569','2021-07-29 11:26:15','612','2021-07-29 11:29:28',10,0),('1','161',213725,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'569',2128649.05,2128649.05,'569','2021-07-29 18:56:54','612','2021-07-30 08:17:23',10,0),('1','161',213933,'AFTERNOON SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'569',2929016.72,2929016.72,'569','2021-07-30 08:56:25','612','2021-07-30 09:11:56',10,0),('1','161',213973,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'569',1953023.41,1941308.24,'569','2021-07-30 14:38:38','612','2021-07-30 20:37:27',10,0),('1','161',214145,'AFTERNOON SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'569',2624442.89,2608585.56,'569','2021-07-31 11:41:46','612','2021-07-31 11:45:34',10,0),('1','161',214232,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'569',1552115.13,1543587.42,'569','2021-07-31 14:20:14','612','2021-07-31 15:07:42',10,0),('1','161',214304,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'569',2492947.37,2477883.88,'569','2021-08-01 12:57:14','612','2021-08-01 13:18:34',10,0),('1','161',214445,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'569',1816081.05,1805618.60,'569','2021-08-01 13:46:14','612','2021-08-01 14:32:42',10,0),('1','161',214504,'AFTERNOON SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'569',3012253.18,2994038.12,'569','2021-08-02 13:45:10','612','2021-08-02 14:02:33',10,0),('1','161',214693,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'569',2211864.84,2211864.84,'569','2021-08-02 14:14:23','612','2021-08-02 15:46:37',10,0),('1','161',214755,'AFTERNOON SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'569',2632623.02,2632623.02,'569','2021-08-02 21:17:10','612','2021-08-03 09:20:39',10,0),('1','161',214905,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'569',1895658.08,1895658.08,'569','2021-08-03 13:24:21','612','2021-08-03 20:47:21',10,0),('1','161',215139,'AFTERNOON SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'569',2538598.84,2538598.84,'569','2021-08-04 14:15:01','612','2021-08-04 14:27:01',10,0),('1','161',215144,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'569',2703263.30,2703263.30,'569','2021-08-04 14:38:50','612','2021-08-05 10:45:03',10,0),('1','161',215311,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'569',3200149.22,3200149.22,'569','2021-08-05 11:07:07','612','2021-08-05 12:55:47',10,0),('1','161',215346,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'569',1799053.20,1799053.20,'569','2021-08-05 13:14:01','612','2021-08-05 19:26:05',10,0),('1','161',215424,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'569',2748182.56,2748182.56,'569','2021-08-06 09:45:36','612','2021-08-06 14:12:22',10,0),('1','161',215720,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'569',2283045.36,2283045.36,'569','2021-08-07 09:24:07','612','2021-08-07 11:53:06',10,0),('1','161',215773,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'569',2697845.34,2697845.34,'569','2021-08-07 12:21:07','612','2021-08-07 18:08:57',10,0),('1','161',215864,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'569',2075315.32,2075315.32,'569','2021-08-07 18:48:15','612','2021-08-08 13:07:14',10,0),('1','161',216021,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'569',2766429.38,2766429.38,'569','2021-08-08 18:32:39','426','2021-08-08 18:52:21',10,0),('1','161',216068,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'569',1512827.82,1512827.82,'569','2021-08-08 19:18:37','612','2021-08-09 09:06:20',10,0),('1','161',216161,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'569',2054298.72,2054298.72,'569','2021-08-09 09:38:39','612','2021-08-10 12:15:15',10,0),('1','161',216469,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'569',2264088.70,2264088.70,'569','2021-08-10 14:11:09','426','2021-08-10 14:17:02',10,0),('1','161',216519,'AFTERNOON SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'569',2480937.50,2480937.50,'569','2021-08-10 18:41:22','612','2021-08-11 11:28:08',10,0),('1','161',216665,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'569',2047968.14,2047968.14,'569','2021-08-11 13:12:53','612','2021-08-11 15:29:17',10,0),('1','161',216726,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'569',2736396.16,2736396.16,'569','2021-08-11 15:41:18','612','2021-08-12 07:03:50',10,0),('1','161',216834,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'569',2071704.00,2071704.00,'569','2021-08-12 09:32:56','612','2021-08-12 12:49:35',10,0),('1','161',216899,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'569',2914409.74,2914409.74,'569','2021-08-12 13:00:01','612','2021-08-12 18:48:18',10,0),('1','161',216991,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'569',2139064.10,2139064.10,'569','2021-08-12 19:06:30','612','2021-08-13 08:14:22',10,0),('1','161',217090,'AFTERNOON SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'569',2634968.30,2634968.30,'569','2021-08-13 10:13:12','648','2021-08-13 10:52:03',10,0),('1','161',217134,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'569',2258005.62,2258005.62,'569','2021-08-13 13:51:23','648','2021-08-13 14:29:14',10,0),('1','161',217321,'AFTERNOON SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'569',2771084.36,2771084.36,'569','2021-08-14 08:53:29','648','2021-08-14 10:21:59',10,0),('1','161',217409,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'569',2178934.84,2178934.84,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',217429,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'569',2178934.84,2178934.84,'569','2021-08-14 14:48:44','648','2021-08-14 14:50:21',10,0),('1','161',217430,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'569',2969655.12,2969655.12,'569','2021-08-14 20:49:08','648','2021-08-15 06:19:15',10,0),('1','161',217601,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'569',2322902.44,2322902.44,'569','2021-08-15 19:26:25','648','2021-08-15 20:25:52',10,0),('1','161',217773,'AFTERNOON SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'569',2944829.62,2944829.62,'569','2021-08-16 09:07:41','648','2021-08-16 10:16:45',10,0),('1','161',217889,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'569',2189740.46,2189740.46,'569','2021-08-16 14:06:18','648','2021-08-16 14:48:40',10,0),('1','161',217913,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'569',2721051.08,2721051.08,'569','2021-08-17 10:55:19','648','2021-08-17 11:11:03',10,0),('1','161',218123,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'569',2027561.32,2027561.32,'569','2021-08-17 13:45:00','648','2021-08-17 14:17:54',10,0),('1','161',218194,'AFTERNOON SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'569',2828882.30,2828882.30,'569','2021-08-17 20:27:29','648','2021-08-18 07:22:15',10,0),('1','161',218338,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'569',1559242.28,1559242.28,'569','2021-08-18 12:38:03','648','2021-08-18 12:44:05',10,0),('1','161',218427,'AFTERNOON SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'569',1539192.74,1539192.74,'569','2021-08-19 12:20:42','648','2021-08-19 14:48:28',10,0),('1','161',218598,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'569',2006810.46,2006810.46,'569','2021-08-19 15:13:45','648','2021-08-20 08:39:42',10,0),('1','161',218739,'AFTERNOON SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'569',2787758.24,2787758.24,'569','2021-08-20 09:25:37','648','2021-08-20 14:32:41',10,0),('1','161',218834,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'569',2779803.60,2779803.60,'569','2021-08-20 14:49:25','648','2021-08-21 08:02:31',10,0),('1','161',218940,'AFTERNOON SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'569',2967864.24,2967864.24,'569','2021-08-21 08:33:31','648','2021-08-21 12:55:18',10,0),('1','161',219027,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'569',2294851.90,2294851.90,'569','2021-08-21 14:02:03','648','2021-08-22 08:39:12',10,0),('1','161',219205,'AFTERNOON SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'569',3030639.28,3030639.28,'569','2021-08-22 11:34:41','648','2021-08-22 14:10:39',10,0),('1','161',219257,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'569',1741707.86,1741707.86,'569','2021-08-22 14:47:33','648','2021-08-23 06:52:23',10,0),('1','161',219417,'AFTERNOON SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'569',3221061.02,3221061.02,'569','2021-08-23 09:42:20','648','2021-08-23 10:11:20',10,0),('1','161',219450,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'569',2306233.96,2306233.96,'569','2021-08-23 12:58:58','648','2021-08-23 13:44:49',10,0),('1','161',219564,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'569',3012322.80,3012322.80,'569','2021-08-24 09:53:29','648','2021-08-24 09:56:36',10,0),('1','161',219684,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'569',2387025.64,2387025.64,'569','2021-08-24 13:59:16','648','2021-08-24 14:46:55',10,0),('1','161',219793,'AFTERNOON SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'569',2884353.26,2884353.26,'569','2021-08-25 06:16:23','648','2021-08-25 07:15:38',10,0),('1','161',219968,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'569',1927222.86,1927222.86,'569','2021-08-25 15:01:41','648','2021-08-26 06:06:52',10,0),('1','161',220115,'AFTERNOON SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'569',3018268.92,3018268.92,'569','2021-08-26 09:54:49','648','2021-08-26 13:37:37',10,0),('1','161',220156,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'569',3058155.76,3058155.76,'569','2021-08-26 13:47:54','648','2021-08-27 07:36:55',10,0),('1','161',220330,'AFTERNOON SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'569',3156916.40,3156916.40,'569','2021-08-27 10:27:11','648','2021-08-27 14:00:01',10,0),('1','161',220387,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'569',2504025.02,2504025.02,'569','2021-08-27 14:15:53','648','2021-08-28 07:42:39',10,0),('1','161',220547,'AFTERNOON SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'569',3186281.78,3186281.78,'569','2021-08-28 11:10:48','648','2021-08-28 11:56:32',10,0),('1','161',220633,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'569',1513675.44,1513675.44,'569','2021-08-28 15:53:06','648','2021-08-28 17:14:24',10,0),('1','161',220783,'AFTERNOON SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'569',3094364.22,3094364.22,'569','2021-08-29 12:52:31','648','2021-08-29 13:06:46',10,0),('1','161',220812,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'569',1840799.98,1840799.98,'569','2021-08-29 14:11:23','648','2021-08-29 14:47:17',10,0),('1','161',220972,'AFTERNOON SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'569',2677114.88,2677114.88,'569','2021-08-30 09:10:50','648','2021-08-30 10:23:45',10,0),('1','161',221014,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'569',2062474.42,2062474.42,'569','2021-08-30 12:53:25','648','2021-08-30 14:02:19',10,0),('1','161',221112,'AFTERNOON SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'569',3286663.76,3286663.76,'569','2021-08-30 20:59:47','648','2021-08-31 07:44:21',10,0),('1','161',221270,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'569',1987414.64,1987414.64,'569','2021-08-31 12:42:37','648','2021-08-31 13:57:10',10,0),('1','161',221365,'AFTERNOON SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'569',3278724.60,3278724.60,'569','2021-08-31 21:19:18','648','2021-09-01 07:25:18',10,0),('1','161',221509,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'569',2272366.32,2272366.32,'569','2021-09-01 13:27:54','648','2021-09-01 13:29:24',10,0),('1','161',221597,'AFTERNOON SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'569',2927197.80,2927197.80,'569','2021-09-01 21:07:48','648','2021-09-02 09:17:54',10,0),('1','161',221745,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'569',1578630.40,1578630.40,'569','2021-09-02 14:16:02','648','2021-09-03 07:04:53',10,0),('1','161',221864,'AFTERNOON SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'569',2719907.30,2719907.30,'569','2021-09-03 09:21:50','648','2021-09-03 14:27:40',10,0),('1','161',221976,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'569',2265258.02,2265258.02,'569','2021-09-03 14:53:47','648','2021-09-03 16:43:28',10,0),('1','161',222040,'AFTERNOON SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'569',3435261.24,3435261.24,'569','2021-09-03 21:12:00','648','2021-09-04 06:59:47',10,0),('1','161',222185,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'569',2991114.70,2991114.70,'569','2021-09-04 14:23:41','648','2021-09-05 06:05:20',10,0),('1','161',222331,'AFTERNOON SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'569',3045654.42,3045654.42,'569','2021-09-05 10:42:15','648','2021-09-05 11:41:01',10,0),('1','161',222400,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'569',1754597.34,1754597.34,'569','2021-09-05 13:46:08','648','2021-09-05 13:53:52',10,0),('1','161',222460,'AFTERNOON SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'569',2554539.96,2554539.96,'569','2021-09-05 21:22:55','648','2021-09-06 07:27:55',10,0),('1','161',222583,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'569',2281309.50,2281309.50,'569','2021-09-06 13:28:36','648','2021-09-06 18:07:51',10,0),('1','161',222708,'AFTERNOON SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'569',2956114.10,2956114.10,'569','2021-09-06 21:21:28','648','2021-09-07 08:22:29',10,0),('1','161',222760,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'569',2796438.54,2796438.54,'569','2021-09-08 11:10:42','648','2021-09-08 11:18:46',10,0),('1','161',223038,'AFTERNOON SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'569',2278412.74,2278412.74,'569','2021-09-08 11:30:18','648','2021-09-08 11:39:38',10,0),('1','161',223096,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'569',2243490.16,2243490.16,'569','2021-09-08 14:56:30','648','2021-09-09 05:33:48',10,0),('1','161',223258,'AFTERNOON SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'569',3483348.12,3483348.12,'569','2021-09-09 10:15:33','648','2021-09-09 10:30:10',10,0),('1','161',223317,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'569',2143306.28,2143306.28,'569','2021-09-10 09:13:52','648','2021-09-10 09:18:24',10,0),('1','161',223465,'AFTERNOON SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'569',3340658.70,3340658.70,'569','2021-09-10 09:29:08','648','2021-09-10 09:35:17',10,0),('1','161',223544,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'569',2465441.78,2465441.78,'569','2021-09-10 14:19:48','648','2021-09-10 14:32:45',10,0),('1','161',223733,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'569',2829574.18,2829574.18,'569','2021-09-11 20:24:29','648','2021-09-11 20:42:34',10,0),('1','161',223852,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'569',2704944.00,2704944.00,'569','2021-09-11 20:57:13','648','2021-09-11 20:59:52',10,0),('1','161',223868,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'569',2946140.10,2946140.10,'569','2021-09-12 06:16:30','648','2021-09-12 09:57:56',10,0),('1','161',224021,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'569',2041927.20,2041927.20,'569','2021-09-12 18:04:39','648','2021-09-13 09:02:44',10,0),('1','161',224133,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'569',2248020.02,2248020.02,'569','2021-09-14 19:46:58','648','2021-09-14 19:52:18',10,0),('1','161',224499,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'569',1557702.96,1557702.96,'569','2021-09-14 19:59:01','648','2021-09-14 20:01:17',10,0),('1','161',224500,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'569',2807948.18,2807948.18,'569','2021-09-14 20:07:58','648','2021-09-14 20:09:57',10,0),('1','161',224501,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'569',2531337.54,2531337.54,'569','2021-09-14 20:15:28','648','2021-09-14 20:18:00',10,0),('1','161',224504,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'569',3221673.56,3221673.56,'569','2021-09-14 21:39:52','648','2021-09-15 07:52:37',10,0),('1','161',224651,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'569',2256663.26,2256663.26,'569','2021-09-15 18:35:55','648','2021-09-15 19:31:38',10,0),('1','161',224827,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'569',2572045.90,2572045.90,'569','2021-09-16 09:29:08','648','2021-09-16 12:58:51',10,0),('1','161',224940,'MORNING SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'569',2271755.18,2271755.18,'569','2021-09-16 14:26:24','648','2021-09-16 14:43:52',10,0),('1','161',224989,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'569',3237220.16,3237220.16,'569','2021-09-17 06:57:57','648','2021-09-17 07:33:29',10,0),('1','161',225155,'MORNING SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'569',2187669.04,2187669.04,'569','2021-09-17 13:55:31','648','2021-09-17 14:46:34',10,0),('1','161',225240,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',225247,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'569',2800206.89,2800206.89,'569','2021-09-18 05:35:12','648','2021-09-18 08:02:57',10,0),('1','161',225384,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'569',2137461.93,2137461.93,'569','2021-09-18 13:20:56','648','2021-09-18 14:35:51',10,0),('1','161',225463,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'569',2483803.87,2483803.87,'569','2021-09-19 10:23:12','648','2021-09-19 11:32:28',10,0),('1','161',225612,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'569',1671952.09,1671952.09,'569','2021-09-19 14:40:35','648','2021-09-19 22:13:36',10,0),('1','161',225732,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'569',2049606.40,2049606.40,'569','2021-09-20 08:46:46','648','2021-09-20 09:01:51',10,0),('1','161',225828,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'569',1920239.11,1920239.11,'569','2021-09-20 14:12:33','648','2021-09-20 14:51:04',10,0),('1','161',225945,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'569',2548266.33,2548266.33,'569','2021-09-21 07:21:01','648','2021-09-21 08:28:06',10,0),('1','161',226099,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'569',290300.65,290300.65,'569','2021-09-21 15:35:40','648','2021-09-21 15:41:54',10,0),('1','161',226173,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'569',1880878.32,1880878.32,'569','2021-09-21 17:51:50','648','2021-09-22 08:30:31',10,0),('1','161',226250,'AFTERNOON SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'569',2818054.02,2818054.02,'569','2021-09-22 08:46:14','648','2021-09-22 08:49:12',10,0),('1','161',226263,'MORNING SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'569',2167738.56,2167738.56,'569','2021-09-22 14:02:08','648','2021-09-23 14:43:48',10,0),('1','161',226713,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'569',3581811.60,3581811.60,'569','2021-09-25 09:57:54','648','2021-09-25 10:31:50',10,0),('1','161',227038,'MORNING SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'569',2323662.66,2323662.66,'569','2021-09-25 10:37:12','648','2021-09-25 10:43:42',10,0),('1','161',227040,'AFTERNOON SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'569',2539949.34,2539949.34,'569','2021-09-25 10:51:23','648','2021-09-25 11:03:23',10,0),('1','161',227044,'MORNING SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'569',2128337.76,2128337.76,'569','2021-09-25 11:12:46','648','2021-09-25 11:17:50',10,0),('1','161',227049,'AFTERNOON SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'569',2806335.06,2806335.06,'569','2021-09-25 11:25:19','648','2021-09-25 11:31:12',10,0),('1','161',227120,'MORNING SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'569',1175457.72,1175457.72,'569','2021-09-25 15:12:05','648','2021-09-25 15:15:48',10,0),('1','161',227125,'AFTERNOON SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'569',1498220.52,1498220.52,'569','2021-09-26 12:33:27','648','2021-09-26 14:47:05',10,0),('1','161',227342,'MORNING SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'569',2420666.04,2420666.04,'569','2021-09-26 18:29:07','648','2021-09-26 20:21:25',10,0),('1','161',227349,'AFTERNOON SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'569',2516378.52,2516378.52,'569','2021-09-26 20:28:17','648','2021-09-27 07:08:09',10,0),('1','161',227483,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'569',2263055.04,2263055.04,'569','2021-09-27 15:23:01','648','2021-09-27 16:18:28',10,0),('1','161',227589,'AFTERNOON SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'569',3021868.86,3021868.86,'569','2021-09-27 21:12:28','648','2021-09-28 07:55:49',10,0),('1','161',227770,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'569',2252958.36,2252958.36,'569','2021-09-28 14:00:32','648','2021-09-28 14:50:25',10,0),('1','161',227816,'AFTERNOON SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'569',123000.00,123000.00,'569','2021-09-28 19:19:37','648','2021-09-28 19:51:30',10,0),('1','161',227825,'AFTERNOON SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'569',3208586.38,3208586.38,'569','2021-09-28 21:08:17','648','2021-09-29 08:04:30',10,0),('1','161',227893,'MORNING SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'569',1998484.36,1998484.36,'569','2021-09-29 16:37:43','648','2021-09-30 05:47:18',10,0),('1','161',228119,'AFTERNOON SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'569',3416980.96,3416980.96,'569','2021-09-30 06:52:12','648','2021-09-30 08:17:42',10,0),('1','161',228245,'MORNING SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'569',2574784.75,2574784.75,'569','2021-09-30 14:26:25','648','2021-09-30 16:48:20',10,0),('1','161',228326,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'569',3088142.57,3088142.57,'569','2021-09-30 20:25:28','648','2021-10-01 10:27:24',10,0),('1','161',228449,'MORNING SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'569',2113777.24,2113777.24,'569','2021-10-01 13:39:17','648','2021-10-02 07:28:58',10,0),('1','161',228612,'AFTERNOON SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'569',2703858.67,2703858.67,'569','2021-10-02 12:22:00','648','2021-10-02 15:30:50',10,0),('1','161',228696,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'569',2385574.07,2385574.07,'569','2021-10-02 18:01:20','648','2021-10-02 20:32:36',10,0),('1','161',228732,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'569',2835728.06,2835728.06,'569','2021-10-02 21:01:24','648','2021-10-03 13:22:44',10,0),('1','161',228885,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'569',1987297.55,1987297.55,'569','2021-10-03 15:08:21','648','2021-10-03 20:04:45',10,0),('1','161',228916,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'569',2865102.84,2865102.84,'569','2021-10-03 20:13:36','648','2021-10-04 16:53:50',10,0),('1','161',229143,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'569',2036512.66,2036512.66,'569','2021-10-04 19:43:05','648','2021-10-04 19:44:38',10,0),('1','161',229147,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'569',2586844.27,2586844.27,'569','2021-10-04 20:31:00','648','2021-10-05 10:15:07',10,0),('1','161',229242,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'569',2390412.24,2390412.24,'569','2021-10-05 14:16:42','648','2021-10-05 14:52:51',10,0),('1','161',229398,'AFTERNOON SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'569',160567.25,160567.25,'569','2021-10-05 20:43:30','648','2021-10-06 08:20:43',10,0),('1','161',229528,'AFTERNOON SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'569',3004425.98,3004425.98,'569','2021-10-06 11:40:11','648','2021-10-06 13:06:09',10,0),('1','161',229593,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'569',2080102.34,2080102.34,'569','2021-10-06 14:34:15','648','2021-10-06 19:11:27',10,0),('1','161',229634,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'569',2965287.86,2965287.86,'569','2021-10-06 20:23:49','648','2021-10-07 10:52:34',10,0),('1','161',229784,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'569',2289720.70,2289720.70,'569','2021-10-07 13:52:22','648','2021-10-07 17:21:38',10,0),('1','161',229849,'AFTERNOON SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'569',3209128.86,3209128.86,'569','2021-10-08 10:15:23','648','2021-10-08 12:55:07',10,0),('1','161',229989,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'569',2295283.78,2295283.78,'569','2021-10-08 14:04:44','648','2021-10-08 16:41:34',10,0),('1','161',230066,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'569',3795175.38,3795175.38,'569','2021-10-08 20:48:28','648','2021-10-08 21:21:29',10,0),('1','161',230194,'MORNING SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'569',2330229.68,2330229.68,'569','2021-10-09 14:59:46','648','2021-10-09 20:36:41',10,0),('1','161',230313,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'569',2441832.04,2441832.04,'569','2021-10-10 08:00:15','648','2021-10-10 13:00:21',10,0),('1','161',230457,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'569',1882684.71,1882684.71,'569','2021-10-10 15:36:36','648','2021-10-10 20:03:59',10,0),('1','161',230495,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'569',2357970.62,2357970.62,'569','2021-10-10 20:37:28','648','2021-10-11 07:31:05',10,0),('1','161',230600,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'569',2527900.57,2527900.57,'569','2021-10-11 15:02:03','648','2021-10-11 15:10:39',10,0),('1','161',230752,'AFTERNOON SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'569',2427064.32,2427064.32,'569','2021-10-11 20:17:51','648','2021-10-12 10:43:55',10,0),('1','161',230877,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'569',2570758.95,2570758.95,'569','2021-10-12 16:15:51','648','2021-10-12 22:08:14',10,0),('1','161',231052,'AFTERNOON SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'569',2813707.96,2813707.96,'569','2021-10-13 10:13:54','648','2021-10-13 13:34:47',10,0),('1','161',231238,'MORNING SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'569',2664640.26,2664640.26,'569','2021-10-13 14:10:58','648','2021-10-14 07:08:45',10,0),('1','161',231466,'AFTERNOON SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'569',2854543.20,2854543.20,'569','2021-10-14 10:47:59','648','2021-10-14 12:53:39',10,0),('1','161',231528,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'569',3118605.26,3118605.26,'569','2021-10-14 13:53:01','648','2021-10-14 14:33:58',10,0),('1','161',231651,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'569',3649155.75,3649155.75,'569','2021-10-15 07:17:35','648','2021-10-15 09:33:40',10,0),('1','161',231733,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'569',2264460.17,2264460.17,'569','2021-10-15 19:23:12','648','2021-10-16 08:00:36',10,0),('1','161',231949,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'569',2849438.62,2849438.62,'569','2021-10-16 09:59:14','648','2021-10-16 17:13:09',10,0),('1','161',232068,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'569',2486475.16,2486475.16,'569','2021-10-16 19:57:20','648','2021-10-17 07:11:31',10,0),('1','161',232144,'AFTERNOON SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'569',2921414.87,2921414.87,'569','2021-10-17 09:07:29','648','2021-10-17 10:20:57',10,0),('1','161',232271,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'569',2008997.00,2008997.00,'569','2021-10-17 18:59:33','648','2021-10-18 07:11:37',10,0),('1','161',232425,'AFTERNOON SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'569',2308407.31,2308407.31,'569','2021-10-18 13:56:46','648','2021-10-18 14:01:14',10,0),('1','161',232528,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'569',4241658.48,4241658.48,'569','2021-10-18 16:50:45','648','2021-10-18 17:12:31',10,0),('1','161',232545,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',232565,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'569',2602405.59,2602405.59,'569','2021-10-19 08:14:54','648','2021-10-19 09:13:05',10,0),('1','161',232670,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'569',2362210.08,2362210.08,'569','2021-10-19 13:52:18','648','2021-10-19 20:43:03',10,0),('1','161',232928,'AFTERNOON SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'569',3190164.51,3190164.51,'569','2021-10-20 12:32:06','648','2021-10-20 13:09:24',10,0),('1','161',233045,'MORNING SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'569',2191688.69,2191688.69,'569','2021-10-20 15:58:11','648','2021-10-20 16:31:50',10,0),('1','161',233074,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'569',3009041.06,3009041.06,'569','2021-10-20 20:22:11','648','2021-10-21 08:06:07',10,0),('1','161',233205,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'569',2322916.16,2322916.16,'569','2021-10-21 16:43:08','648','2021-10-21 21:55:20',10,0),('1','161',233471,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'569',3035197.79,3035197.79,'569','2021-10-22 11:03:12','648','2021-10-22 14:39:54',10,0),('1','161',233563,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'569',2313865.63,2313865.63,'569','2021-10-22 19:10:53','648','2021-10-23 07:28:39',10,0),('1','161',233691,'AFTERNOON SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'569',3430066.71,3430066.71,'569','2021-10-23 10:31:14','648','2021-10-23 11:22:40',10,0),('1','161',233744,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'569',2271735.85,2271735.85,'569','2021-10-23 13:41:05','648','2021-10-23 15:35:17',10,0),('1','161',233800,'AFTERNOON SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'569',3128091.48,3128091.48,'569','2021-10-23 20:44:18','648','2021-10-24 08:50:08',10,0),('1','161',233985,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'569',2078741.65,2078741.65,'569','2021-10-24 16:47:45','648','2021-10-25 07:56:01',10,0),('1','161',234138,'AFTERNOON SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'569',2950800.16,2950800.16,'569','2021-10-25 09:42:10','648','2021-10-25 11:18:36',10,0),('1','161',234180,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'569',2271896.60,2271896.60,'569','2021-10-25 14:24:18','648','2021-10-25 16:58:09',10,0),('1','161',234261,'AFTERNOON SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'569',3708631.07,3708631.07,'569','2021-10-25 20:33:11','648','2021-10-26 09:15:25',10,0),('1','161',234501,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'569',718930.39,718930.39,'569','2021-10-26 15:58:36','648','2021-10-26 22:50:29',10,0),('1','161',234618,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',234620,'AFTERNOON SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'569',3601179.40,3601179.40,'569','2021-10-28 09:16:53','648','2021-10-28 09:30:35',10,0),('1','161',234918,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'569',2444536.87,2444536.87,'569','2021-10-28 09:36:10','648','2021-10-28 09:37:36',10,0),('1','161',234921,'AFTERNOON SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'569',4657715.54,4657715.54,'569','2021-10-28 09:46:51','648','2021-10-28 09:56:53',10,0),('1','161',234932,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'569',3270710.86,3270710.86,'569','2021-10-28 19:42:24','648','2021-10-29 06:17:32',10,0),('1','161',235164,'AFTERNOON SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'569',3621972.89,3621972.89,'569','2021-10-29 10:44:30','648','2021-10-29 11:02:05',10,0),('1','161',235219,'MORNING SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'569',2619385.70,2619385.70,'569','2021-10-29 14:18:54','648','2021-10-29 14:57:49',10,0),('1','161',235440,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'569',904502.53,904502.53,'569','2021-10-31 14:16:55','648','2021-10-31 14:19:08',10,0),('1','161',235664,'AFTERNOON SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'569',3473001.23,3473001.23,'569','2021-10-31 14:27:55','648','2021-10-31 14:29:31',10,0),('1','161',235668,'MORNING SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'569',1943627.46,1943627.46,'569','2021-10-31 14:45:59','648','2021-10-31 14:52:25',10,0),('1','161',235670,'AFTERNOON SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'569',2985381.13,2985381.13,'569','2021-10-31 20:23:40','648','2021-11-01 06:57:19',10,0),('1','161',235912,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'569',2777117.88,2777117.88,'569','2021-11-01 13:17:52','648','2021-11-01 13:27:00',10,0),('1','161',235955,'AFTERNOON SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'569',3415253.85,3415253.85,'569','2021-11-01 20:22:57','648','2021-11-02 08:38:43',10,0),('1','161',236114,'MORNING SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'569',2771398.35,2771398.35,'569','2021-11-02 12:56:54','648','2021-11-02 14:27:07',10,0),('1','161',236165,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'569',3283130.85,3283130.85,'569','2021-11-02 20:15:53','648','2021-11-03 09:03:54',10,0),('1','161',236380,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'569',2206117.50,2206117.50,'569','2021-11-03 12:55:28','648','2021-11-03 14:27:40',10,0),('1','161',236469,'AFTERNOON SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'569',3444032.10,3444032.10,'569','2021-11-03 21:54:10','648','2021-11-04 09:50:05',10,0),('1','161',236619,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'569',2825329.35,2825329.35,'569','2021-11-04 13:52:37','648','2021-11-04 19:24:26',10,0),('1','161',236740,'AFTERNOON SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'569',3270978.00,3270978.00,'569','2021-11-05 08:41:01','648','2021-11-05 14:28:41',10,0),('1','161',236873,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'569',2582194.80,2582194.80,'569','2021-11-05 15:10:41','648','2021-11-06 07:35:57',10,0),('1','161',237003,'AFTERNOON SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'569',3749961.60,3749961.60,'569','2021-11-06 08:31:08','648','2021-11-06 12:21:25',10,0),('1','161',237070,'MORNING SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'569',2749914.45,2749914.45,'569','2021-11-06 13:48:02','648','2021-11-06 13:58:44',10,0),('1','161',237096,'AFTERNOON SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'569',3214658.85,3214658.85,'569','2021-11-06 21:10:12','648','2021-11-07 07:11:47',10,0),('1','161',237237,'MORNING SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'569',1716878.85,1716878.85,'569','2021-11-07 13:32:46','648','2021-11-07 13:46:45',10,0),('1','161',237330,'AFTERNOON SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'569',706020.15,706020.15,'569','2021-11-07 18:24:27','648','2021-11-08 07:46:37',10,0),('1','161',237514,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'569',1246860.15,1246860.15,'569','2021-11-08 13:51:16','648','2021-11-09 06:24:15',10,0),('1','161',237749,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'569',2764728.75,2764728.75,'569','2021-11-09 13:59:33','648','2021-11-09 14:24:24',10,0),('1','161',237832,'AFTERNOON SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'569',3388533.75,3388533.75,'569','2021-11-09 20:50:25','648','2021-11-10 07:38:43',10,0),('1','161',237994,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'569',2240864.85,2240864.85,'569','2021-11-10 12:22:07','648','2021-11-10 13:39:42',10,0),('1','161',238050,'AFTERNOON SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'569',3554214.30,3554214.30,'569','2021-11-10 20:55:18','648','2021-11-11 08:20:42',10,0),('1','161',238194,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'569',2031480.45,2031480.45,'569','2021-11-11 13:19:50','648','2021-11-11 14:23:06',10,0),('1','161',238306,'AFTERNOON SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'569',2990979.45,2990979.45,'569','2021-11-11 22:06:58','648','2021-11-12 07:37:19',10,0),('1','161',238414,'MORNING SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'569',2336858.25,2336858.25,'569','2021-11-12 13:57:32','648','2021-11-12 15:04:28',10,0),('1','161',238553,'AFTERNOON SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'569',3679288.50,3679288.50,'569','2021-11-12 21:30:50','648','2021-11-12 21:36:11',10,0),('1','161',238707,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'569',2691364.50,2691364.50,'569','2021-11-13 12:25:42','648','2021-11-13 14:23:29',10,0),('1','161',238795,'AFTERNOON SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'569',2197792.35,2197792.35,'569','2021-11-13 20:45:19','648','2021-11-14 06:50:01',10,0),('1','161',238940,'AFTERNOON SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'569',3888331.95,3888331.95,'569','2021-11-14 21:15:08','648','2021-11-15 06:50:30',10,0),('1','161',239119,'MORNING SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'569',3841371.45,3841371.45,'569','2021-11-15 13:49:57','648','2021-11-15 14:15:39',10,0),('1','161',239256,'AFTERNOON SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'569',5598031.80,5598031.80,'569','2021-11-15 20:59:30','648','2021-11-16 07:16:31',10,0),('1','161',239414,'MORNING SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'569',3524717.10,3524717.10,'569','2021-11-16 13:59:38','648','2021-11-16 14:28:20',10,0),('1','161',239489,'AFTERNOON SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'569',3745498.80,3745498.80,'569','2021-11-16 20:41:49','648','2021-11-17 05:17:20',10,0),('1','161',239612,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'569',2740891.05,2740891.05,'569','2021-11-17 12:22:00','648','2021-11-17 13:20:26',10,0),('1','161',239716,'AFTERNOON SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'569',3870482.10,3870482.10,'569','2021-11-17 19:34:27','648','2021-11-17 21:15:33',10,0),('1','161',239875,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'569',1962570.60,1962570.60,'569','2021-11-18 12:11:38','648','2021-11-18 14:15:54',10,0),('1','161',240043,'MORNING SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',240276,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'569',2272840.75,2272840.75,'569','2021-11-20 13:37:29','648','2021-11-20 13:39:25',10,0),('1','161',240402,'AFTERNOON SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'569',2617654.30,2617654.30,'569','2021-11-20 20:34:03','648','2021-11-21 06:19:22',10,0),('1','161',240505,'MORNING SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'569',1820644.90,1820644.90,'569','2021-11-21 13:43:44','648','2021-11-21 21:09:45',10,0),('1','161',240632,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'569',2507097.25,2507097.25,'569','2021-11-21 21:41:42','648','2021-11-22 07:37:11',10,0),('1','161',240770,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'569',2287897.40,2287897.40,'569','2021-11-22 12:42:51','648','2021-11-22 14:10:00',10,0),('1','161',240910,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'569',3061310.15,3061310.15,'569','2021-11-22 20:21:32','648','2021-11-22 20:53:28',10,0),('1','161',240994,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'569',2087725.30,2087725.30,'569','2021-11-23 13:46:32','648','2021-11-23 20:51:11',10,0),('1','161',241185,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'569',2672104.70,2672104.70,'569','2021-11-23 20:58:40','648','2021-11-24 04:30:51',10,0),('1','161',241251,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'569',2160370.10,2160370.10,'569','2021-11-24 13:09:03','648','2021-11-24 14:21:23',10,0),('1','161',241433,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'569',2670164.25,2670164.25,'569','2021-11-24 20:04:09','648','2021-11-25 05:45:13',10,0),('1','161',241553,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'569',2304474.25,2304474.25,'569','2021-11-25 14:18:31','648','2021-11-26 02:49:08',10,0),('1','161',241729,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',241730,'AFTERNOON SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'569',2710697.85,2710697.85,'569','2021-11-26 06:29:29','648','2021-11-26 08:06:06',10,0),('1','161',241872,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'569',2717452.90,2717452.90,'569','2021-11-26 14:13:18','648','2021-11-26 14:14:00',10,0),('1','161',241914,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'569',2791549.75,2791549.75,'569','2021-11-26 19:27:44','648','2021-11-26 22:55:02',10,0),('1','161',242104,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'569',1717705.50,1717705.50,'569','2021-11-27 13:47:15','648','2021-11-27 13:55:37',10,0),('1','161',242113,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'569',984732.60,984732.60,'569','2021-11-27 17:47:08','648','2021-11-28 05:43:50',10,0),('1','161',242211,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'569',2046270.15,2046270.15,'569','2021-11-28 13:48:54','648','2021-11-28 14:33:28',10,0),('1','161',242347,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'569',2673362.75,2673362.75,'569','2021-11-28 20:10:09','648','2021-11-28 20:47:52',10,0),('1','161',242405,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'569',2288735.85,2288735.85,'569','2021-11-29 13:15:59','648','2021-11-29 21:05:05',10,0),('1','161',242639,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'569',3447701.75,3447701.75,'569','2021-11-29 21:11:18','648','2021-11-29 21:32:54',10,0),('1','161',242656,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'569',2233106.80,2233106.80,'569','2021-11-30 12:40:53','648','2021-11-30 13:58:18',10,0),('1','161',242863,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'569',3075243.85,3075243.85,'569','2021-11-30 20:22:57','648','2021-12-01 04:01:39',10,0),('1','161',242926,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'569',2383841.50,2383841.50,'569','2021-12-01 12:26:04','648','2021-12-01 13:40:50',10,0),('1','161',243093,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'569',2773711.65,2773711.65,'569','2021-12-01 20:22:02','648','2021-12-02 05:14:55',10,0),('1','161',243214,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'569',2275621.10,2275621.10,'569','2021-12-02 13:07:14','648','2021-12-02 13:55:46',10,0),('1','161',243309,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'569',3232404.10,3232404.10,'569','2021-12-02 20:00:04','648','2021-12-02 22:35:25',10,0),('1','161',243348,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'569',2192303.30,2192303.30,'569','2021-12-03 13:39:14','648','2021-12-03 14:40:08',10,0),('1','161',243546,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'569',1964826.65,1964826.65,'569','2021-12-03 18:30:00','648','2021-12-04 05:02:43',10,0),('1','161',243678,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'569',1022900.15,1022900.15,'569','2021-12-04 13:14:59','648','2021-12-04 14:13:55',10,0),('1','161',243790,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'569',3473727.95,3473727.95,'569','2021-12-04 20:35:52','648','2021-12-04 22:49:20',10,0),('1','161',243912,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'569',2440440.35,2440440.35,'569','2021-12-05 13:42:33','648','2021-12-05 13:51:11',10,0),('1','161',243991,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'569',4443677.00,4443677.00,'569','2021-12-05 20:23:36','648','2021-12-05 21:27:56',10,0),('1','161',244024,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'569',2735667.10,2735667.10,'569','2021-12-06 12:44:25','648','2021-12-06 13:17:50',10,0),('1','161',244245,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'569',3270058.20,3270058.20,'569','2021-12-06 20:01:00','648','2021-12-07 02:33:18',10,0),('1','161',244311,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'569',1021142.10,1021142.10,'569','2021-12-07 14:45:46','648','2021-12-07 15:02:20',10,0),('1','161',244475,'AFTERNOON SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'569',2483371.00,2483371.00,'569','2021-12-07 20:05:55','648','2021-12-08 03:44:58',10,0),('1','161',244584,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'569',2845290.35,2845290.35,'569','2021-12-08 13:59:17','648','2021-12-08 14:30:19',10,0),('1','161',244704,'AFTERNOON SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'569',4086195.45,4086195.45,'569','2021-12-08 20:32:35','648','2021-12-09 07:19:39',10,0),('1','161',244837,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'569',2592188.90,2592188.90,'569','2021-12-09 12:57:14','648','2021-12-09 14:34:26',10,0),('1','161',244926,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'569',3210590.45,3210590.45,'569','2021-12-09 21:37:04','648','2021-12-10 04:13:42',10,0),('1','161',245099,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'569',2442433.65,2442433.65,'569','2021-12-10 13:31:15','648','2021-12-10 14:01:32',10,0),('1','161',245182,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'569',3171033.55,3171033.55,'569','2021-12-10 20:32:18','648','2021-12-11 08:09:27',10,0),('1','161',245301,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'569',2380184.25,2380184.25,'569','2021-12-11 13:05:00','648','2021-12-11 16:33:24',10,0),('1','161',245414,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'569',3232240.10,3232240.10,'569','2021-12-11 21:37:40','648','2021-12-12 06:01:03',10,0),('1','161',245558,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'569',2747753.85,2747753.85,'569','2021-12-12 13:26:09','648','2021-12-12 14:26:13',10,0),('1','161',245629,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'569',3015657.15,3015657.15,'569','2021-12-12 20:50:15','648','2021-12-13 04:07:19',10,0),('1','161',245787,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'569',2177583.35,2177583.35,'569','2021-12-13 12:52:42','648','2021-12-13 14:34:20',10,0),('1','161',245911,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'569',2546263.25,2546263.25,'569','2021-12-13 22:10:02','648','2021-12-14 06:25:41',10,0),('1','161',246117,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'569',2295965.90,2295965.90,'569','2021-12-14 16:09:53','648','2021-12-14 16:37:28',10,0),('1','161',246158,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'569',2940218.15,2940218.15,'569','2021-12-14 21:16:45','648','2021-12-14 23:26:41',10,0),('1','161',246173,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'569',2525560.25,2525560.25,'569','2021-12-15 13:16:42','648','2021-12-15 14:04:28',10,0),('1','161',246414,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'569',2989075.15,2989075.15,'569','2021-12-15 20:19:10','648','2021-12-16 06:18:01',10,0),('1','161',246556,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'569',2255486.30,2255486.30,'569','2021-12-16 13:10:17','648','2021-12-16 14:47:29',10,0),('1','161',246661,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'569',3089448.40,3089448.40,'569','2021-12-16 20:24:57','648','2021-12-16 21:11:03',10,0),('1','161',246836,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'569',2419338.15,2419338.15,'569','2021-12-17 13:49:06','648','2021-12-17 13:58:17',10,0),('1','161',246848,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'569',3608545.45,3608545.45,'569','2021-12-17 21:45:40','648','2021-12-18 05:19:54',10,0),('1','161',247043,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'569',2249969.10,2249969.10,'569','2021-12-18 13:24:36','648','2021-12-18 13:52:12',10,0),('1','161',247092,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'569',3223605.50,3223605.50,'569','2021-12-18 22:24:54','648','2021-12-19 05:28:47',10,0),('1','161',247294,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'569',2198470.10,2198470.10,'569','2021-12-19 13:22:13','648','2021-12-19 13:34:38',10,0),('1','161',247336,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'569',2877971.05,2877971.05,'569','2021-12-19 21:43:38','648','2021-12-20 05:15:34',10,0),('1','161',247488,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'569',2475025.65,2475025.65,'569','2021-12-20 13:35:22','648','2021-12-20 14:28:08',10,0),('1','161',247582,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'569',3677472.20,3677472.20,'569','2021-12-20 20:55:15','648','2021-12-20 23:01:37',10,0),('1','161',247655,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'569',2598730.20,2598730.20,'569','2021-12-21 13:09:22','648','2021-12-21 14:54:26',10,0),('1','161',247877,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'569',3293884.70,3293884.70,'569','2021-12-21 21:49:41','648','2021-12-22 05:57:46',10,0),('1','161',247915,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'569',2552434.30,2552434.30,'569','2021-12-22 15:17:14','648','2021-12-22 20:03:25',10,0),('1','161',248106,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'569',3625047.35,3625047.35,'569','2021-12-22 20:25:17','648','2021-12-23 07:21:36',10,0),('1','161',248265,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'569',2396462.35,2396462.35,'569','2021-12-23 12:23:20','648','2021-12-23 12:39:19',10,0),('1','161',248322,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'569',70998.80,70998.80,'569','2021-12-24 05:36:47','648','2021-12-24 06:27:35',10,0),('1','161',248436,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'569',2694343.00,2694343.00,'569','2021-12-24 14:19:53','648','2021-12-24 14:51:39',10,0),('1','161',248614,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'569',3880544.95,3880544.95,'569','2021-12-24 22:08:05','648','2021-12-25 05:12:48',10,0),('1','161',248767,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'569',2180885.50,2180885.50,'569','2021-12-25 13:51:54','648','2021-12-25 14:06:42',10,0),('1','161',248806,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'569',1237032.70,1237032.70,'569','2021-12-25 16:55:07','648','2021-12-25 21:50:42',10,0),('1','161',249000,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'569',1866105.20,1866105.20,'569','2021-12-26 13:41:51','648','2021-12-26 14:35:38',10,0),('1','161',249063,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'569',2188772.25,2188772.25,'569','2021-12-26 19:58:51','648','2021-12-26 23:32:42',10,0),('1','161',249223,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'569',2278018.40,2278018.40,'569','2021-12-27 12:29:17','648','2021-12-27 13:23:33',10,0),('1','161',249301,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'569',3471384.00,3471384.00,'569','2021-12-27 20:34:45','648','2021-12-28 06:35:21',10,0),('1','161',249457,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'569',2412924.85,2412924.85,'569','2021-12-28 12:39:19','648','2021-12-28 14:12:39',10,0),('1','161',249536,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'569',3193781.60,3193781.60,'569','2021-12-28 21:39:37','648','2021-12-28 22:00:15',10,0),('1','161',249587,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'569',2205672.75,2205672.75,'569','2021-12-29 13:40:19','648','2021-12-29 14:27:01',10,0),('1','161',249798,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'569',3050388.55,3050388.55,'569','2021-12-29 20:18:00','648','2021-12-29 23:40:57',10,0),('1','161',249837,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'569',2559008.70,2559008.70,'569','2021-12-30 13:12:00','648','2021-12-30 13:41:08',10,0),('1','161',250060,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'569',3703959.10,3703959.10,'569','2021-12-30 20:32:50','648','2021-12-31 05:18:52',10,0),('1','161',250209,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'569',2872853.45,2872853.45,'569','2021-12-31 13:46:40','648','2021-12-31 14:04:18',10,0),('1','161',250302,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'569',5301484.90,5301484.90,'569','2021-12-31 21:14:04','648','2021-12-31 22:56:24',10,0),('1','161',250436,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'569',2581103.25,2581103.25,'569','2022-01-01 14:23:05','648','2022-01-01 14:41:23',10,0),('1','161',250524,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'569',653491.20,653491.20,'569','2022-01-01 19:59:35','648','2022-01-01 23:45:16',10,0),('1','161',250585,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'569',2931634.90,2931634.90,'569','2022-01-02 14:55:48','648','2022-01-02 20:00:31',10,0),('1','161',250761,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'569',693145.20,693145.20,'569','2022-01-02 20:16:00','648','2022-01-02 22:16:38',10,0),('1','161',250920,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'569',1995481.50,1995481.50,'569','2022-01-03 14:02:17','648','2022-01-03 14:13:05',10,0),('1','161',250995,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'569',3086668.90,3086668.90,'569','2022-01-03 22:12:36','648','2022-01-03 23:06:11',10,0),('1','161',251134,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'569',2076599.30,2076599.30,'569','2022-01-04 12:41:27','648','2022-01-04 14:24:20',10,0),('1','161',251248,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'569',2345903.05,2345903.05,'569','2022-01-04 21:46:16','648','2022-01-05 07:50:37',10,0),('1','161',251353,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'569',1835663.05,1835663.05,'569','2022-01-05 14:35:15','648','2022-01-05 15:12:53',10,0),('1','161',251463,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'569',1682261.65,1682261.65,'569','2022-01-05 20:33:33','648','2022-01-06 07:54:14',10,0),('1','161',251874,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'569',533102.30,533102.30,'569','2022-01-07 15:32:18','648','2022-01-07 15:40:54',10,0),('1','161',251919,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'569',4932559.40,4932559.40,'569','2022-01-07 21:56:15','648','2022-01-08 09:56:26',10,0),('1','161',252087,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'569',1897209.85,1897209.85,'569','2022-01-08 15:13:25','648','2022-01-08 15:43:15',10,0),('1','161',252202,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'569',2914231.95,2914231.95,'569','2022-01-08 22:11:09','648','2022-01-09 10:29:26',10,0),('1','161',252322,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'569',1622238.85,1622238.85,'569','2022-01-09 13:49:01','648','2022-01-09 17:25:35',10,0),('1','161',252396,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'569',2349207.35,2349207.35,'569','2022-01-09 21:27:44','648','2022-01-10 08:50:37',10,0),('1','161',252548,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'569',1757215.75,1757215.75,'569','2022-01-10 15:21:14','648','2022-01-10 21:19:08',10,0),('1','161',252689,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'569',3442172.55,3442172.55,'569','2022-01-10 23:11:17','648','2022-01-11 08:40:16',10,0),('1','161',252845,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'569',1862130.95,1862130.95,'569','2022-01-11 15:34:04','648','2022-01-11 17:00:51',10,0),('1','161',252931,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'569',1309856.65,1309856.65,'569','2022-01-11 21:22:46','648','2022-01-11 23:04:58',10,0),('1','161',253162,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'569',1956491.80,1956491.80,'569','2022-01-12 23:58:25','648','2022-01-13 00:41:57',10,0),('1','161',253313,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'569',1847455.20,1847455.20,'569','2022-01-13 15:35:00','648','2022-01-13 20:38:39',10,0),('1','161',253453,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'569',2610103.25,2610103.25,'569','2022-01-13 23:21:53','648','2022-01-14 07:12:07',10,0),('1','161',253571,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'569',1780137.35,1780137.35,'569','2022-01-14 15:35:40','648','2022-01-14 19:24:52',10,0),('1','161',253675,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'569',2691213.85,2691213.85,'569','2022-01-14 21:23:03','648','2022-01-15 06:55:58',10,0),('1','161',253726,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'569',1763944.05,1763944.05,'569','2022-01-15 15:08:26','648','2022-01-15 17:53:26',10,0),('1','161',253915,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'569',2911931.20,2911931.20,'569','2022-01-15 21:42:47','648','2022-01-15 22:16:59',10,0),('1','161',254065,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'569',1883940.10,1883940.10,'569','2022-01-16 13:59:30','648','2022-01-16 16:29:57',10,0),('1','161',254156,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'569',2271887.50,2271887.50,'569','2022-01-16 21:17:10','648','2022-01-17 04:40:54',10,0),('1','161',254195,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'569',1697338.45,1697338.45,'569','2022-01-17 13:50:49','648','2022-01-17 15:01:49',10,0),('1','161',254406,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'569',2097890.30,2097890.30,'569','2022-01-17 21:15:30','648','2022-01-18 10:40:44',10,0),('1','161',254563,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'569',1432793.55,1432793.55,'569','2022-01-18 14:20:18','648','2022-01-18 14:53:31',10,0),('1','161',254657,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'569',2211159.10,2211159.10,'569','2022-01-18 21:16:23','648','2022-01-19 06:47:48',10,0),('1','161',254804,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'569',1789408.65,1789408.65,'569','2022-01-19 14:24:09','648','2022-01-19 16:20:24',10,0),('1','161',255061,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'569',74001.00,74001.00,'569','2022-01-20 20:38:48','648','2022-01-20 22:09:08',10,0),('1','161',255338,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'569',1989079.17,1989079.17,'569','2022-01-21 15:50:54','648','2022-01-21 16:34:53',10,0),('1','161',255431,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'569',2955773.07,2955773.07,'569','2022-01-21 21:32:36','648','2022-01-21 21:42:37',10,0),('1','161',255601,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'569',1534879.74,1534879.74,'569','2022-01-22 14:46:52','648','2022-01-22 21:48:49',10,0),('1','161',255684,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'569',2824690.33,2824690.33,'569','2022-01-22 22:18:46','648','2022-01-23 08:16:53',10,0),('1','161',255806,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'569',1658017.61,1658017.61,'569','2022-01-23 14:32:04','648','2022-01-23 14:37:18',10,0),('1','161',255922,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'569',2625698.74,2625698.74,'569','2022-01-23 23:37:47','648','2022-01-24 09:38:21',10,0),('1','161',256086,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'569',1729259.53,1729259.53,'569','2022-01-24 14:11:13','648','2022-01-24 14:50:58',10,0),('1','161',256191,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'569',2346557.80,2346557.80,'569','2022-01-24 23:07:03','648','2022-01-25 11:46:04',10,0),('1','161',256339,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'569',1870392.40,1870392.40,'569','2022-01-25 13:35:52','648','2022-01-25 15:44:32',10,0),('1','161',256448,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'569',2564630.59,2564630.59,'569','2022-01-25 21:36:56','648','2022-01-25 23:52:04',10,0),('1','161',256505,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'569',1635520.50,1635520.50,'569','2022-01-26 14:19:44','648','2022-01-26 20:51:23',10,0),('1','161',256685,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'569',2757112.21,2757112.21,'569','2022-01-26 21:35:08','648','2022-01-27 06:49:55',10,0),('1','161',256814,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'569',1905813.47,1905813.47,'569','2022-01-27 17:56:49','648','2022-01-27 21:41:33',10,0),('1','161',256924,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'569',2763669.21,2763669.21,'569','2022-01-27 21:46:15','648','2022-01-28 09:13:02',10,0),('1','161',257069,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'569',81004.00,81004.00,'569','2022-01-28 11:57:49','648','2022-01-28 15:19:00',10,0),('1','161',257126,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'569',1607118.85,1607118.85,'569','2022-01-28 15:27:36','648','2022-01-28 22:16:48',10,0),('1','161',257215,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'569',3306214.55,3306214.55,'569','2022-01-28 23:40:56','648','2022-01-29 07:17:00',10,0),('1','161',257337,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'569',1485872.53,1485872.53,'569','2022-01-29 14:42:00','648','2022-01-29 15:11:57',10,0),('1','161',257446,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'569',2624384.96,2624384.96,'569','2022-01-29 21:19:20','648','2022-01-30 11:20:44',10,0),('1','161',257625,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'569',1324196.98,1324196.98,'569','2022-01-30 14:29:21','648','2022-01-30 15:10:28',10,0),('1','161',257626,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'569',3912352.08,3912352.08,'569','2022-01-31 10:50:25','648','2022-01-31 10:55:23',10,0),('1','161',257627,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'569',2267618.52,2267618.52,'569','2022-01-31 14:02:02','648','2022-01-31 14:45:00',10,0),('1','161',257628,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'569',3331855.30,3331855.30,'569','2022-01-31 21:40:57','648','2022-02-01 10:01:35',10,0),('1','161',257629,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'569',2333728.97,2333728.97,'569','2022-02-01 14:53:42','648','2022-02-01 15:05:33',10,0),('1','161',257630,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'569',3152355.30,3152355.30,'569','2022-02-01 21:34:33','648','2022-02-01 23:45:05',10,0),('1','161',257631,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'569',2321620.00,2321620.00,'569','2022-02-02 16:01:52','648','2022-02-02 21:17:05',10,0),('1','161',257632,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'569',3991705.71,3991705.71,'569','2022-02-02 21:43:00','648','2022-02-03 06:42:36',10,0),('1','161',257633,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'569',1609038.18,1609038.18,'569','2022-02-03 14:46:40','648','2022-02-03 16:08:34',10,0),('1','161',257634,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'569',2702970.69,2702970.69,'569','2022-02-03 21:23:34','648','2022-02-04 09:27:39',10,0),('1','161',257635,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'569',2080368.54,2080368.54,'569','2022-02-04 14:14:21','648','2022-02-04 15:41:48',10,0),('1','161',257636,'AFTERNOON SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'569',2791887.90,2791887.90,'569','2022-02-04 21:33:12','648','2022-02-04 23:00:07',10,0),('1','161',257637,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'569',1865295.39,1865295.39,'569','2022-02-05 15:23:38','648','2022-02-05 19:29:33',10,0),('1','161',257638,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'569',2792117.06,2792117.06,'569','2022-02-05 21:23:09','648','2022-02-06 12:28:01',10,0),('1','161',257639,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'569',1683873.13,1683873.13,'569','2022-02-06 15:02:32','648','2022-02-06 17:45:11',10,0),('1','161',257640,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',257641,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'569',1613974.36,1613974.36,'569','2022-02-08 14:53:54','648','2022-02-08 15:39:08',10,0),('1','161',257642,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'569',2658860.10,2658860.10,'569','2022-02-08 21:18:53','648','2022-02-09 08:59:33',10,0),('1','161',257643,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'569',1648040.14,1648040.14,'569','2022-02-09 15:25:43','648','2022-02-09 18:28:33',10,0),('1','161',257644,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'569',2222138.12,2222138.12,'569','2022-02-09 22:27:41','648','2022-02-10 08:59:55',10,0),('1','161',257645,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'569',1876361.49,1876361.49,'569','2022-02-10 14:31:17','648','2022-02-10 16:15:17',10,0),('1','161',257646,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'569',2784843.42,2784843.42,'569','2022-02-10 21:24:43','648','2022-02-10 21:47:36',10,0),('1','161',257647,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'569',2118830.82,2118830.82,'569','2022-02-11 14:21:32','648','2022-02-11 15:34:12',10,0),('1','161',257648,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'569',3537203.19,3537203.19,'569','2022-02-11 21:33:31','648','2022-02-11 21:50:14',10,0),('1','161',257649,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'569',2279999.72,2279999.72,'569','2022-02-12 15:34:21','648','2022-02-12 16:02:08',10,0),('1','161',257650,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'569',1530867.71,1530867.71,'569','2022-02-12 18:39:05','648','2022-02-12 19:57:58',10,0),('1','161',257651,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'569',867805.75,867805.75,'569','2022-02-14 14:07:53','648','2022-02-14 17:56:39',10,0),('1','161',257652,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'569',5064566.75,5064566.75,'569','2022-02-14 22:35:17','648','2022-02-14 22:55:34',10,0),('1','161',257653,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'569',4065739.60,4065739.60,'569','2022-02-15 15:04:25','648','2022-02-15 15:45:20',10,0),('1','161',257654,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'569',3559532.25,3559532.25,'569','2022-02-15 21:00:06','648','2022-02-16 08:52:56',10,0),('1','161',257655,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'569',305926.85,305926.85,'569','2022-02-16 16:37:22','648','2022-02-16 23:28:41',10,0),('1','161',257656,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',257657,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'569',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','161',257658,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'569',2230177.05,2230177.05,'569','2022-02-19 05:20:13','648','2022-02-19 10:10:21',10,0),('1','161',257659,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'569',3636552.75,3636552.75,'569','2022-02-20 06:39:26','648','2022-02-20 09:49:08',10,0),('1','161',257660,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'569',2946084.90,2946084.90,'569','2022-02-20 16:11:18','648','2022-02-20 18:46:38',10,0),('1','161',257661,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'569',5691612.15,5691612.15,'569','2022-02-20 23:40:26','648','2022-02-21 10:07:53',10,0),('1','161',257662,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'569',2357062.95,2357062.95,'569','2022-02-21 19:16:12','648','2022-02-21 19:34:27',10,0),('1','161',257663,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'569',1344087.90,1344087.90,'569','2022-02-21 19:41:48','648','2022-02-22 09:19:53',10,0),('1','161',257664,'MORNING SHIFT','2022-02-22','2022-02-22 16:54:13','2022-02-23 16:54:13','569',84053.70,84053.70,'569','2022-02-22 16:57:08','648','2022-02-23 00:24:56',10,0),('1','161',257665,'MORNING SHIFT','2022-02-23','2022-02-23 10:39:00','2022-02-24 10:39:00','569',193716.80,193716.80,'569','2022-02-23 20:20:28','648','2022-02-24 00:36:30',10,0),('1','161',257666,'AFTERNOON SHIFT','2022-02-24','2022-02-24 20:39:11','2022-02-25 20:39:11','569',2426615.80,2426615.80,'569','2022-02-24 20:47:56','648','2022-02-24 22:48:43',10,0),('1','161',257667,'MORNING SHIFT','2022-02-25','2022-02-25 15:18:42','2022-02-26 15:18:42','569',1643705.95,1643705.95,'569','2022-02-25 15:27:58','648','2022-02-25 15:34:25',10,0),('1','161',257668,'AFTERNOON SHIFT','2022-02-25','2022-02-25 15:41:37','2022-02-26 15:41:37','569',1564087.80,1564087.80,'569','2022-02-25 21:37:12','648','2022-02-26 10:25:42',10,0),('1','161',257669,'AFTERNOON SHIFT','2022-02-26','2022-02-26 22:28:12','2022-02-27 22:28:12','569',701092.20,701092.20,'569','2022-02-26 22:35:56','648','2022-02-27 06:45:51',10,0),('1','161',257670,'AFTERNOON SHIFT','2022-02-27','2022-02-27 18:31:05','2022-02-28 18:31:05','569',357120.40,357120.40,'569','2022-02-27 18:35:39','648','2022-02-28 09:52:00',10,0),('1','161',257671,'AFTERNOON SHIFT','2022-03-01','2022-03-01 14:05:55','2022-03-02 14:05:55','569',0.00,0.00,'569','2022-03-02 06:13:53','648','2022-03-02 08:59:41',10,0),('1','161',257672,'MORNING SHIFT','2022-03-02','2022-03-02 12:09:32','2022-03-03 12:09:32','569',246834.00,246834.00,'569','2022-03-02 12:16:25','648','2022-03-02 15:20:41',10,0),('1','161',257673,'AFTERNOON SHIFT','2022-03-03','2022-03-03 23:12:35','2022-03-04 23:12:35','569',60101.10,60101.10,'569','2022-03-03 23:17:44','648','2022-03-04 10:44:56',10,0),('1','161',257674,'AFTERNOON SHIFT','2022-03-04','2022-03-04 19:21:50','2022-03-05 19:21:50','569',48005.20,48005.20,'569','2022-03-04 19:23:18','648','2022-03-05 08:48:56',10,0),('1','161',257675,'AFTERNOON SHIFT','2022-03-05','2022-03-06 04:45:00','2022-03-07 04:45:00','569',0.00,0.00,'569','2022-03-06 04:49:01','648','2022-03-06 09:06:57',10,0),('1','161',257676,'AFTERNOON SHIFT','2022-03-05','2022-03-06 09:07:33','2022-03-07 09:07:33','569',0.00,0.00,'569','2022-03-06 09:36:06','648','2022-03-08 13:55:32',10,0),('1','161',257677,'AFTERNOON SHIFT','2022-03-06','2022-03-08 16:59:52','2022-03-09 16:59:52','569',22498.60,22498.60,'569','2022-03-08 17:00:38','648','2022-03-08 17:39:47',10,0),('1','161',257678,'AFTERNOON SHIFT','2022-03-07','2022-03-08 18:02:42','2022-03-09 18:02:42','569',144005.00,144005.00,'569','2022-03-08 18:05:57','648','2022-03-08 19:09:11',10,0),('1','161',257679,'AFTERNOON SHIFT','2022-03-08','2022-03-08 19:24:39','2022-03-09 19:24:39','569',1335000.00,1335000.00,'569','2022-03-08 19:39:31','648','2022-03-09 07:21:42',10,0),('1','161',257680,'MORNING SHIFT','2022-03-09','2022-03-09 12:48:14','2022-03-10 12:48:14','569',1249671.45,1249671.45,'569','2022-03-09 14:28:46','648','2022-03-09 15:37:47',10,0),('1','161',257681,'AFTERNOON SHIFT','2022-03-09','2022-03-09 21:16:30','2022-03-10 21:16:30','569',3018820.65,3018820.65,'569','2022-03-09 21:58:21','648','2022-03-10 08:23:30',10,0),('1','161',257682,'MORNING SHIFT','2022-03-10','2022-03-10 12:05:37','2022-03-11 12:05:37','569',1121802.75,1121802.75,'569','2022-03-10 13:58:28','648','2022-03-10 16:15:32',10,0),('1','161',257683,'AFTERNOON SHIFT','2022-03-10','2022-03-10 23:21:49','2022-03-11 23:21:49','569',1920209.70,1920209.70,'569','2022-03-10 23:26:54','648','2022-03-11 08:38:52',10,0),('1','161',257684,'MORNING SHIFT','2022-03-11','2022-03-11 21:13:42','2022-03-12 21:13:42','569',3374851.65,3374851.65,'569','2022-03-11 21:17:39','648','2022-03-11 21:34:06',10,0),('1','161',257685,'AFTERNOON SHIFT','2022-03-11','2022-03-11 21:36:43','2022-03-12 21:36:43','569',3170324.55,3170324.55,'569','2022-03-11 21:49:16','648','2022-03-11 22:22:10',10,0),('1','161',257686,'AFTERNOON SHIFT','2022-03-12','2022-03-12 19:28:18','2022-03-13 19:28:18','569',3553101.90,3553101.90,'569','2022-03-12 19:40:09','648','2022-03-13 12:44:29',10,0),('1','161',257687,'MORNING SHIFT','2022-03-13','2022-03-13 16:06:07','2022-03-14 16:06:07','569',4564716.45,4564716.45,'569','2022-03-13 16:10:35','648','2022-03-13 20:38:17',10,0),('1','161',257688,'AFTERNOON SHIFT','2022-03-13','2022-03-13 20:40:04','2022-03-14 20:40:04','569',1201202.10,1201202.10,'569','2022-03-13 20:44:34','648','2022-03-14 06:57:12',10,0),('1','161',257689,'AFTERNOON SHIFT','2022-03-14','2022-03-14 20:18:35','2022-03-15 20:18:35','569',4485762.90,4485762.90,'569','2022-03-14 20:25:24','648','2022-03-15 09:55:17',10,0),('1','161',257690,'AFTERNOON SHIFT','2022-03-15','2022-03-15 20:20:56','2022-03-16 20:20:56','569',5308473.35,5308473.35,'569','2022-03-15 20:53:31','648','2022-03-16 09:34:50',10,0),('1','161',257691,'AFTERNOON SHIFT','2022-03-15','2022-03-16 12:02:37','2022-03-17 12:02:37','569',0.00,0.00,'569','2022-03-16 12:08:04','648','2022-03-16 14:30:28',10,0),('1','161',257692,'AFTERNOON SHIFT','2022-03-16','2022-03-16 18:53:38','2022-03-17 18:53:38','569',5693581.10,5693581.10,'569','2022-03-17 06:38:09','648','2022-03-17 09:12:37',10,0),('1','161',257693,'AFTERNOON SHIFT','2022-03-17','2022-03-17 19:32:50','2022-03-18 19:32:50','569',553262.60,553262.60,'569','2022-03-17 19:36:10','648','2022-03-18 07:06:51',10,0),('1','161',257694,'AFTERNOON SHIFT','2022-03-18','2022-03-18 18:20:44','2022-03-19 18:20:44','569',432891.55,432891.55,'569','2022-03-18 18:22:04','648','2022-03-19 07:24:35',10,0),('1','161',257695,'MORNING SHIFT','2022-03-17','2022-03-22 12:58:06','2022-03-23 12:58:06','569',0.00,0.00,'569','2022-03-22 15:18:57','648','2022-03-23 08:19:25',10,0),('1','161',257696,'AFTERNOON SHIFT','2022-03-23','2022-03-23 20:35:24','2022-03-24 20:35:24','569',7141599.05,6924907.15,'569','2022-03-23 20:42:00','648','2022-03-23 23:10:04',10,0),('1','161',257697,'MORNING SHIFT','2022-03-24','2022-03-24 13:22:45','2022-03-25 13:22:45','569',3206731.50,3023489.70,'569','2022-03-24 13:34:07','648','2022-03-24 15:06:36',10,0),('1','161',257698,'AFTERNOON SHIFT','2022-03-24','2022-03-24 15:22:47','2022-03-25 15:22:47','569',603771.00,569269.80,'569','2022-03-24 15:27:54','648','2022-03-24 18:17:51',10,0),('1','161',257699,'AFTERNOON SHIFT','2022-03-23','2022-03-24 18:22:54','2022-03-25 18:22:54','569',0.00,0.00,'569','2022-03-24 18:32:38','648','2022-03-25 09:06:06',10,0),('1','161',257700,'MORNING SHIFT','2022-03-25','2022-03-25 15:08:53','2022-03-26 15:08:53','569',2740131.90,2740131.90,'569','2022-03-25 15:19:15','648','2022-03-25 19:03:18',10,0),('1','161',257701,'AFTERNOON SHIFT','2022-03-25','2022-03-25 20:50:00','2022-03-26 20:50:00','569',0.00,0.00,'569','2022-03-25 21:34:38','648','2022-03-26 06:22:54',10,0),('1','161',257702,'AFTERNOON SHIFT','2022-03-26','2022-03-26 20:12:04','2022-03-27 20:12:04','569',0.00,0.00,'569','2022-03-26 20:36:16','648','2022-03-26 20:38:56',10,0),('1','161',257703,'MORNING SHIFT','2022-03-26','2022-03-26 20:39:37','2022-03-27 20:39:37','569',3584028.00,3584028.00,'569','2022-03-26 20:42:31','648','2022-03-26 20:49:55',10,0),('1','161',257704,'MORNING SHIFT','2022-03-27','2022-03-27 20:14:13','2022-03-28 20:14:13','569',384695.85,384695.85,'569','2022-03-27 20:17:09','648','2022-03-28 10:55:00',10,0),('1','161',257705,'MORNING SHIFT','2022-03-31','2022-03-31 14:27:25','2022-04-01 14:27:25','569',1157989.65,1157989.65,'569','2022-04-01 12:41:43','648','2022-04-01 15:52:16',10,0),('1','161',257706,'MORNING SHIFT','2022-04-01','2022-04-01 19:20:50','2022-04-02 19:20:50','569',3330252.75,3330252.75,'569','2022-04-01 19:31:18','648','2022-04-02 07:02:27',10,0),('1','161',257707,'AFTERNOON SHIFT','2022-04-02','2022-04-02 08:45:42','2022-04-03 08:45:42','569',0.00,0.00,'569','2022-04-02 08:59:12','648','2022-04-02 20:21:13',10,0),('1','161',257708,'MORNING SHIFT','2022-04-02','2022-04-03 04:34:27','2022-04-04 04:34:27','569',3144814.20,3144814.20,'569','2022-04-03 05:25:29','648','2022-04-04 00:33:16',10,0),('1','161',257709,'MORNING SHIFT','2022-04-03','2022-04-04 05:57:20','2022-04-05 05:57:20','569',3092532.30,3092532.30,'569','2022-04-04 06:03:24','648','2022-04-04 06:52:55',10,0),('1','161',257710,'MORNING SHIFT','2022-04-04','2022-04-05 06:05:22','2022-04-06 06:05:22','569',2404241.40,2404241.40,'569','2022-04-05 06:10:23','648','2022-04-05 06:22:41',10,0),('1','161',257711,'MORNING SHIFT','2022-04-05','2022-04-05 14:41:50','2022-04-06 14:41:50','569',818033.70,818033.70,'569','2022-04-05 15:20:22','648','2022-04-05 22:25:23',10,0),('1','161',257712,'AFTERNOON SHIFT','2022-04-06','2022-04-06 00:02:28','2022-04-07 00:02:28','569',2619749.30,2542697.85,'569','2022-04-06 06:36:51','648','2022-04-06 09:29:01',10,0),('1','161',257713,'MORNING SHIFT','2022-04-06','2022-04-06 12:22:52','2022-04-07 12:22:52','569',3038576.60,2949206.70,'569','2022-04-06 13:48:32','648','2022-04-07 06:45:34',10,0),('1','161',257714,'AFTERNOON SHIFT','2022-04-06','2022-04-07 07:40:25','2022-04-08 07:40:25','569',675119.30,655262.85,'569','2022-04-07 07:47:01','648','2022-04-07 13:50:30',10,0),('1','161',257715,'MORNING SHIFT','2022-04-07','2022-04-07 14:18:35','2022-04-08 14:18:35','569',1350307.20,1350307.20,'569','2022-04-07 14:29:39','648','2022-04-07 16:39:17',10,0),('1','161',257716,'AFTERNOON SHIFT','2022-04-07','2022-04-08 05:32:33','2022-04-09 05:32:33','569',1948123.65,1948123.65,'569','2022-04-08 06:21:08','648','2022-04-08 12:42:52',10,0),('1','161',257717,'AFTERNOON SHIFT','2022-04-05','2022-04-08 17:54:56','2022-04-09 17:54:56','569',0.00,0.00,'569','2022-04-08 17:57:42','648','2022-04-09 16:29:54',10,0),('1','161',257718,'MORNING SHIFT','2022-04-08','2022-04-09 16:45:30','2022-04-10 16:45:30','569',3275066.85,3275066.85,'569','2022-04-09 16:52:38','648','2022-04-09 17:30:13',10,0),('1','161',257719,'MORNING SHIFT','2022-04-09','2022-04-09 17:34:26','2022-04-10 17:34:26','569',2672480.25,2672480.25,'569','2022-04-09 17:41:13','648','2022-04-09 17:43:08',10,0),('1','161',257720,'AFTERNOON SHIFT','2022-04-09','2022-04-09 18:03:26','2022-04-10 18:03:26','569',867502.35,867502.35,'569','2022-04-09 19:39:05','648','2022-04-10 10:28:46',10,0),('1','161',257721,'MORNING SHIFT','2022-04-10','2022-04-10 14:20:17','2022-04-11 14:20:17','569',2369218.50,2369218.50,'569','2022-04-10 14:28:10','648','2022-04-11 06:23:33',10,0),('1','161',257722,'AFTERNOON SHIFT','2022-04-10','2022-04-11 06:43:05','2022-04-12 06:43:05','569',1739139.60,1739139.60,'569','2022-04-11 06:49:47','648','2022-04-11 08:30:44',10,0),('1','161',257723,'MORNING SHIFT','2022-04-11','2022-04-11 14:47:01','2022-04-12 14:47:01','569',3562628.85,3562628.85,'569','2022-04-11 15:00:50','648','2022-04-11 17:57:13',10,0),('1','161',257724,'AFTERNOON SHIFT','2022-04-11','2022-04-11 18:52:10','2022-04-12 18:52:10','569',2432949.75,2432949.75,'569','2022-04-11 18:57:27','648','2022-04-12 14:54:12',10,0),('1','161',257725,'MORNING SHIFT','2022-04-12','2022-04-12 16:48:57','2022-04-13 16:48:57','569',3087740.70,3087740.70,'569','2022-04-12 16:55:42','648','2022-04-12 17:10:58',10,0),('1','161',257726,'AFTERNOON SHIFT','2022-04-09','2022-04-12 17:34:32','2022-04-13 17:34:32','569',0.00,0.00,'569','2022-04-12 17:38:08','648','2022-04-12 20:41:57',10,0),('1','161',257727,'AFTERNOON SHIFT','2022-04-12','2022-04-12 20:42:39','2022-04-13 20:42:39','569',2790669.75,2790669.75,'569','2022-04-12 20:48:43','648','2022-04-13 10:30:14',10,0),('1','161',257728,'MORNING SHIFT','2022-04-13','2022-04-13 15:00:58','2022-04-14 15:00:58','569',3028070.10,3028070.10,'569','2022-04-13 15:06:14','648','2022-04-13 17:26:59',10,0),('1','161',257729,'AFTERNOON SHIFT','2022-04-13','2022-04-13 18:24:57','2022-04-14 18:24:57','569',1703732.25,1703732.25,'569','2022-04-13 18:34:20','648','2022-04-14 08:15:48',10,0),('1','161',257730,'MORNING SHIFT','2022-04-14','2022-04-14 15:51:32','2022-04-15 15:51:32','569',473327.25,473327.25,'569','2022-04-14 15:54:01','648','2022-04-14 16:23:57',10,0),('1','161',257731,'MORNING SHIFT','2022-04-17','2022-04-17 14:47:04','2022-04-18 14:47:04','569',249648.30,249648.30,'569','2022-04-17 15:01:06','648','2022-04-17 15:07:20',10,0),('1','161',257732,'AFTERNOON SHIFT','2022-04-17','2022-04-17 18:06:04','2022-04-18 18:06:04','569',1816668.15,1816668.15,'569','2022-04-17 21:09:31','648','2022-04-18 10:48:22',10,0),('1','161',257733,'MORNING SHIFT','2022-04-18','2022-04-18 14:42:51','2022-04-19 14:42:51','569',2701307.40,2701307.40,'569','2022-04-18 15:00:12','648','2022-04-18 16:19:44',10,0),('1','161',257734,'AFTERNOON SHIFT','2022-04-18','2022-04-18 20:58:52','2022-04-19 20:58:52','569',3032747.85,3032747.85,'569','2022-04-18 21:06:07','648','2022-04-18 23:04:12',10,0),('1','161',257735,'MORNING SHIFT','2022-04-19','2022-04-19 17:48:21','2022-04-20 17:48:21','569',717840.75,717840.75,'569','2022-04-19 17:57:24','648','2022-04-19 20:10:32',10,0),('1','161',257736,'AFTERNOON SHIFT','2022-04-19','2022-04-19 21:22:31','2022-04-20 21:22:31','569',1640984.40,1640984.40,'569','2022-04-19 21:27:57','648','2022-04-20 08:35:34',10,0),('1','161',257737,'MORNING SHIFT','2022-04-20','2022-04-20 13:47:01','2022-04-21 13:47:01','569',3115122.45,3115122.45,'569','2022-04-20 14:21:33','648','2022-04-20 21:43:54',10,0),('1','161',257738,'AFTERNOON SHIFT','2022-04-20','2022-04-20 21:54:22','2022-04-21 21:54:22','569',3451861.05,3451861.05,'569','2022-04-20 21:59:58','648','2022-04-21 05:05:35',10,0),('1','161',257739,'MORNING SHIFT','2022-04-21','2022-04-21 13:23:00','2022-04-22 13:23:00','569',3013566.60,3013566.60,'569','2022-04-21 13:36:30','648','2022-04-21 16:49:26',10,0),('1','161',257740,'AFTERNOON SHIFT','2022-04-21','2022-04-21 18:07:49','2022-04-22 18:07:49','569',1173046.05,1173046.05,'569','2022-04-21 18:10:27','648','2022-04-22 09:13:56',10,0),('1','161',257741,'MORNING SHIFT','2022-04-22','2022-04-22 14:44:11','2022-04-23 14:44:11','569',2359580.85,2359580.85,'569','2022-04-22 14:52:59','648','2022-04-22 20:53:20',10,0),('1','161',257742,'MORNING SHIFT','2022-04-23','2022-04-23 17:09:13','2022-04-24 17:09:13','569',377538.15,377538.15,'569','2022-04-23 17:14:19','648','2022-04-24 14:20:56',10,0),('1','161',257743,'AFTERNOON SHIFT','2022-04-23','2022-04-24 15:47:24','2022-04-25 15:47:24','569',2431969.65,2431969.65,'569','2022-04-24 15:56:01','648','2022-04-25 05:57:50',10,0),('1','161',257744,'MORNING SHIFT','2022-04-24','2022-04-25 14:09:45','2022-04-26 14:09:45','569',1476971.10,1476971.10,'569','2022-04-25 14:14:32','648','2022-04-25 15:23:01',10,0),('1','161',257745,'AFTERNOON SHIFT','2022-04-24','2022-04-25 15:51:03','2022-04-26 15:51:03','569',2405360.10,2405360.10,'569','2022-04-25 15:54:51','648','2022-04-25 16:18:22',10,0),('1','161',257746,'MORNING SHIFT','2022-04-25','2022-04-25 16:33:17','2022-04-26 16:33:17','569',1066858.65,1066858.65,'569','2022-04-25 16:37:47','648','2022-04-25 17:49:31',10,0),('1','161',257747,'MORNING SHIFT','2022-04-26','2022-04-26 13:29:00','2022-04-27 13:29:00','569',2068461.45,2068461.45,'569','2022-04-26 13:34:56','648','2022-04-26 22:35:41',10,0),('1','161',257748,'AFTERNOON SHIFT','2022-04-26','2022-04-27 04:57:33','2022-04-28 04:57:33','569',2291785.65,2291785.65,'569','2022-04-27 05:06:31','648','2022-04-27 10:54:12',10,0),('1','161',257749,'MORNING SHIFT','2022-04-27','2022-04-27 14:21:29','2022-04-28 14:21:29','569',920670.30,920670.30,'569','2022-04-27 14:33:15','648','2022-04-27 18:44:19',10,0),('1','161',257750,'AFTERNOON SHIFT','2022-04-27','2022-04-28 05:03:33','2022-04-29 05:03:33','569',2681362.20,2681362.20,'569','2022-04-28 05:13:25','648','2022-04-28 09:50:42',10,0),('1','161',257751,'MORNING SHIFT','2022-04-28','2022-04-28 15:13:33','2022-04-29 15:13:33','569',1858959.30,1858959.30,'569','2022-04-28 15:18:54','648','2022-04-28 17:28:50',10,0),('1','161',257752,'AFTERNOON SHIFT','2022-04-28','2022-04-28 21:01:38','2022-04-29 21:01:38','569',3077314.35,3077314.35,'569','2022-04-28 21:05:39','648','2022-04-29 09:14:32',10,0),('1','161',257753,'MORNING SHIFT','2022-04-29','2022-04-29 13:01:24','2022-04-30 13:01:24','569',2428128.45,2428128.45,'569','2022-04-29 14:46:22','648','2022-04-29 15:37:57',10,0),('1','161',257754,'AFTERNOON SHIFT','2022-04-29','2022-04-29 22:55:41','2022-04-30 22:55:41','569',3308870.40,3308870.40,'569','2022-04-29 23:05:12','648','2022-04-30 08:35:09',10,0),('1','161',257755,'MORNING SHIFT','2022-04-30','2022-04-30 15:30:14','2022-05-01 15:30:14','569',2254208.55,2254208.55,'569','2022-04-30 15:42:06','648','2022-04-30 21:26:59',10,0),('1','161',257756,'AFTERNOON SHIFT','2022-04-30','2022-04-30 21:28:56','2022-05-01 21:28:56','569',3080023.65,3080023.65,'569','2022-04-30 21:34:57','648','2022-05-01 09:42:27',10,0),('1','161',257757,'MORNING SHIFT','2022-05-01','2022-05-01 15:04:44','2022-05-02 15:04:44','569',1815453.75,1815453.75,'569','2022-05-01 15:12:51','648','2022-05-02 06:24:45',10,0),('1','161',257758,'AFTERNOON SHIFT','2022-05-01','2022-05-02 07:19:19','2022-05-03 07:19:19','569',2710626.60,2710626.60,'569','2022-05-02 07:27:26','648','2022-05-02 14:08:47',10,0),('1','161',257759,'MORNING SHIFT','2022-05-02','2022-05-02 14:32:01','2022-05-03 14:32:01','569',1910157.15,1910157.15,'569','2022-05-02 15:16:30','648','2022-05-02 17:54:30',10,0),('1','161',257760,'AFTERNOON SHIFT','2022-05-02','2022-05-03 00:32:47','2022-05-04 00:32:47','569',2327697.90,2327697.90,'569','2022-05-03 00:40:34','648','2022-05-03 08:26:52',10,0),('1','161',257761,'MORNING SHIFT','2022-05-03','2022-05-03 13:45:51','2022-05-04 13:45:51','569',2054089.95,2054089.95,'569','2022-05-03 13:54:54','648','2022-05-04 03:17:49',10,0),('1','161',257762,'AFTERNOON SHIFT','2022-05-03','2022-05-04 07:11:56','2022-05-05 07:11:56','569',3117576.00,3117576.00,'569','2022-05-04 07:27:04','648','2022-05-04 08:46:33',10,0),('1','161',257763,'MORNING SHIFT','2022-05-04','2022-05-04 17:14:42','2022-05-05 17:14:42','569',2329616.85,2329616.85,'569','2022-05-04 17:19:45','648','2022-05-04 21:16:25',10,0),('1','161',257764,'AFTERNOON SHIFT','2022-05-04','2022-05-04 22:35:20','2022-05-05 22:35:20','569',3262259.55,3262259.55,'569','2022-05-04 22:43:51','648','2022-05-05 10:12:48',10,0),('1','161',257765,'MORNING SHIFT','2022-05-05','2022-05-05 13:36:48','2022-05-06 13:36:48','569',2569274.40,2569274.40,'569','2022-05-05 13:41:27','648','2022-05-05 14:17:26',10,0),('1','161',257766,'AFTERNOON SHIFT','2022-05-05','2022-05-05 21:10:56','2022-05-06 21:10:56','569',2894443.20,2894443.20,'569','2022-05-05 21:15:13','648','2022-05-06 10:25:54',10,0),('1','161',257767,'MORNING SHIFT','2022-05-06','2022-05-06 14:26:07','2022-05-07 14:26:07','569',2493366.15,2493366.15,'569','2022-05-06 15:02:47','648','2022-05-06 17:09:22',10,0),('1','161',257768,'AFTERNOON SHIFT','2022-05-06','2022-05-06 19:39:04','2022-05-07 19:39:04','569',2336253.15,2336253.15,'569','2022-05-06 20:38:54','648','2022-05-07 09:02:16',10,0),('1','161',257769,'MORNING SHIFT','2022-05-07','2022-05-07 15:26:17','2022-05-08 15:26:17','569',62594.40,62594.40,'569','2022-05-07 15:28:36','648','2022-05-07 21:50:10',10,0),('1','161',257770,'AFTERNOON SHIFT','2022-05-07','2022-05-08 06:11:01','2022-05-09 06:11:01','569',2844400.35,2844400.35,'569','2022-05-08 06:30:33','648','2022-05-08 10:15:21',10,0),('1','161',257771,'MORNING SHIFT','2022-05-08','2022-05-08 15:17:20','2022-05-09 15:17:20','569',1871151.15,1871151.15,'569','2022-05-08 15:20:59','648','2022-05-08 15:48:31',10,0),('1','161',257772,'AFTERNOON SHIFT','2022-05-08','2022-05-08 21:07:24','2022-05-09 21:07:24','569',2349166.05,2349166.05,'569','2022-05-08 21:13:54','648','2022-05-09 07:17:15',10,0),('1','161',257773,'MORNING SHIFT','2022-05-09','2022-05-09 13:55:07','2022-05-10 13:55:07','569',2730019.05,2730019.05,'569','2022-05-09 13:59:56','648','2022-05-09 14:57:37',10,0),('1','161',257774,'AFTERNOON SHIFT','2022-05-09','2022-05-09 21:08:45','2022-05-10 21:08:45','569',3401072.40,3401072.40,'569','2022-05-09 21:15:31','648','2022-05-10 07:55:45',10,0),('1','161',257775,'MORNING SHIFT','2022-05-10','2022-05-10 11:49:16','2022-05-11 11:49:16','569',1707405.15,1707405.15,'569','2022-05-10 11:58:12','648','2022-05-10 17:58:57',10,0),('1','161',257776,'MORNING SHIFT','2022-05-15','2022-05-15 16:35:33','2022-05-16 16:35:33','569',1476530.55,1476530.55,'569','2022-05-15 16:39:09','648','2022-05-15 18:19:56',10,0),('1','161',257777,'AFTERNOON SHIFT','2022-05-15','2022-05-15 21:09:11','2022-05-16 21:09:11','569',2245131.90,2245131.90,'569','2022-05-15 21:11:48','648','2022-05-16 08:31:07',10,0),('1','161',257778,'AFTERNOON SHIFT','2022-05-16','2022-05-17 00:05:52','2022-05-18 00:05:52','569',1281109.50,1281109.50,'569','2022-05-17 00:10:04','648','2022-05-17 09:29:40',10,0),('1','161',257779,'MORNING SHIFT','2022-05-17','2022-05-17 13:50:24','2022-05-18 13:50:24','569',1715092.50,1715092.50,'569','2022-05-17 13:59:58','648','2022-05-17 16:33:58',10,0),('1','161',257780,'AFTERNOON SHIFT','2022-05-17','2022-05-17 20:52:10','2022-05-18 20:52:10','569',2257675.20,2257675.20,'569','2022-05-17 21:09:51','648','2022-05-18 12:34:20',10,0),('1','161',257781,'MORNING SHIFT','2022-05-18','2022-05-18 15:03:38','2022-05-19 15:03:38','569',1736539.20,1736539.20,'569','2022-05-18 15:23:30','648','2022-05-18 16:28:23',10,0),('1','161',257782,'AFTERNOON SHIFT','2022-05-18','2022-05-18 21:08:09','2022-05-19 21:08:09','569',2363285.10,2363285.10,'569','2022-05-18 21:14:24','648','2022-05-19 09:05:36',10,0),('1','161',257783,'MORNING SHIFT','2022-05-19','2022-05-19 13:51:46','2022-05-20 13:51:46','569',1882191.30,1882191.30,'569','2022-05-19 14:05:06','648','2022-05-19 15:02:47',10,0),('1','161',257784,'AFTERNOON SHIFT','2022-05-19','2022-05-19 20:52:45','2022-05-20 20:52:45','569',2456825.25,2456825.25,'569','2022-05-19 21:18:31','648','2022-05-20 09:31:23',10,0),('1','161',257785,'MORNING SHIFT','2022-05-20','2022-05-20 14:21:45','2022-05-21 14:21:45','569',1979104.05,1979104.05,'569','2022-05-20 15:12:38','648','2022-05-20 21:00:57',10,0),('1','161',257786,'AFTERNOON SHIFT','2022-05-20','2022-05-20 21:03:14','2022-05-21 21:03:14','569',2510064.15,2510064.15,'569','2022-05-20 21:12:41','648','2022-05-21 10:11:20',10,0),('1','161',257787,'MORNING SHIFT','2022-05-21','2022-05-21 13:20:20','2022-05-22 13:20:20','569',1480408.05,1480408.05,'569','2022-05-21 13:25:04','648','2022-05-21 17:21:03',10,0),('1','161',257788,'AFTERNOON SHIFT','2022-05-21','2022-05-21 17:49:40','2022-05-22 17:49:40','569',2519416.35,2519416.35,'569','2022-05-21 21:11:22','648','2022-05-22 09:54:28',10,0),('1','161',257789,'MORNING SHIFT','2022-05-22','2022-05-22 12:37:57','2022-05-23 12:37:57','569',1531629.00,1531629.00,'569','2022-05-22 15:09:28','648','2022-05-22 16:31:40',10,0),('1','161',257790,'AFTERNOON SHIFT','2022-05-22','2022-05-22 21:21:26','2022-05-23 21:21:26','569',2141520.15,2141520.15,'569','2022-05-22 21:25:31','648','2022-05-23 06:45:08',10,0),('1','161',257791,'MORNING SHIFT','2022-05-23','2022-05-23 13:58:49','2022-05-24 13:58:49','569',2174906.25,2174906.25,'569','2022-05-23 14:03:10','648','2022-05-23 19:30:13',10,0),('1','161',257792,'AFTERNOON SHIFT','2022-05-23','2022-05-23 20:55:13','2022-05-24 20:55:13','569',2466028.95,2466028.95,'569','2022-05-23 21:06:14','648','2022-05-24 09:44:58',10,0),('1','161',257793,'AFTERNOON SHIFT','2022-05-24','2022-05-24 13:47:52','2022-05-25 13:47:52','569',1915376.10,1915376.10,'569','2022-05-24 13:53:47','648','2022-05-24 15:19:07',10,0),('1','161',257794,'MORNING SHIFT','2022-05-24','2022-05-24 21:40:35','2022-05-25 21:40:35','569',2211316.80,2211316.80,'569','2022-05-24 21:42:43','648','2022-05-25 13:28:33',10,0),('1','161',257795,'MORNING SHIFT','2022-05-25','2022-05-25 14:26:11','2022-05-26 14:26:11','569',2036632.95,2036632.95,'569','2022-05-25 14:30:54','648','2022-05-25 16:26:52',10,0),('1','161',257796,'AFTERNOON SHIFT','2022-05-25','2022-05-25 20:00:01','2022-05-26 20:00:01','569',2504142.30,2504142.30,'569','2022-05-25 21:13:16','648','2022-05-26 06:21:18',10,0),('1','161',257797,'MORNING SHIFT','2022-05-26','2022-05-26 11:10:36','2022-05-27 11:10:36','569',2257363.35,2257363.35,'569','2022-05-26 13:34:33','648','2022-05-26 14:23:28',10,0),('1','161',257798,'AFTERNOON SHIFT','2022-05-26','2022-05-26 18:44:45','2022-05-27 18:44:45','569',2898340.50,2898340.50,'569','2022-05-26 21:07:58','648','2022-05-27 07:30:42',10,0),('1','161',257799,'MORNING SHIFT','2022-05-27','2022-05-27 11:50:22','2022-05-28 11:50:22','569',2165461.65,2165461.65,'569','2022-05-27 14:23:11','648','2022-05-27 17:50:57',10,0),('1','161',257800,'MORNING SHIFT','2022-05-28','2022-05-28 21:33:15','2022-05-29 21:33:15','569',3171491.40,3171491.40,'569','2022-05-28 22:04:49','648','2022-05-29 13:16:19',10,0),('1','161',257801,'MORNING SHIFT','2022-05-29','2022-05-29 15:15:10','2022-05-30 15:15:10','569',1774278.00,1774278.00,'569','2022-05-29 15:22:23','648','2022-05-29 23:40:55',10,0),('1','161',257802,'AFTERNOON SHIFT','2022-05-29','2022-05-30 05:41:54','2022-05-31 05:41:54','569',2705808.60,2705808.60,'569','2022-05-30 05:55:25','648','2022-05-30 07:55:36',10,0),('1','161',257803,'MORNING SHIFT','2022-05-30','2022-05-30 13:26:49','2022-05-31 13:26:49','569',2493176.40,2493176.40,'569','2022-05-30 14:02:57','648','2022-05-30 17:33:53',10,0),('1','161',257804,'AFTERNOON SHIFT','2022-05-30','2022-05-30 21:16:21','2022-05-31 21:16:21','569',3146487.30,3146487.30,'569','2022-05-30 21:22:50','648','2022-05-31 10:42:28',10,0),('1','161',257805,'MORNING SHIFT','2022-05-31','2022-05-31 13:08:30','2022-06-01 13:08:30','569',1957084.80,1957084.80,'569','2022-05-31 14:27:31','648','2022-05-31 14:45:48',10,0),('1','161',257806,'MORNING SHIFT','2022-06-03','2022-06-03 16:51:04','2022-06-04 16:51:04','569',943075.65,943075.65,'569','2022-06-03 16:58:19','648','2022-06-04 09:45:41',10,0),('1','161',257807,'AFTERNOON SHIFT','2022-06-03','2022-06-04 10:24:16','2022-06-05 10:24:16','569',2654232.90,2654232.90,'569','2022-06-04 10:27:52','648','2022-06-04 11:07:33',10,0),('1','161',257808,'MORNING SHIFT','2022-06-04','2022-06-04 13:31:13','2022-06-05 13:31:13','569',2193547.95,2193547.95,'569','2022-06-04 13:41:38','648','2022-06-04 15:42:30',10,0),('1','161',257809,'AFTERNOON SHIFT','2022-06-04','2022-06-04 21:13:05','2022-06-05 21:13:05','569',2614632.90,2614632.90,'569','2022-06-04 22:24:53','648','2022-06-04 22:32:51',10,0),('1','161',257810,'MORNING SHIFT','2022-06-05','2022-06-05 15:56:12','2022-06-06 15:56:12','569',1123204.50,1123204.50,'569','2022-06-05 16:13:40','648','2022-06-05 19:46:23',10,0),('1','161',257811,'AFTERNOON SHIFT','2022-06-05','2022-06-05 20:37:17','2022-06-06 20:37:17','569',2135570.25,2135570.25,'569','2022-06-05 21:38:12','648','2022-06-06 06:28:32',10,0),('1','161',257812,'MORNING SHIFT','2022-06-06','2022-06-06 14:21:08','2022-06-07 14:21:08','569',1849951.95,1849951.95,'569','2022-06-06 14:28:20','648','2022-06-06 16:23:32',10,0),('1','161',257813,'AFTERNOON SHIFT','2022-06-06','2022-06-06 22:23:43','2022-06-07 22:23:43','569',2807168.10,2807168.10,'569','2022-06-06 22:32:02','648','2022-06-07 05:50:24',10,0),('1','161',257814,'MORNING SHIFT','2022-06-07','2022-06-07 14:50:56','2022-06-08 14:50:56','569',2119552.05,2119552.05,'569','2022-06-07 14:55:50','648','2022-06-07 16:15:44',10,0),('1','161',257815,'AFTERNOON SHIFT','2022-06-07','2022-06-07 21:09:46','2022-06-08 21:09:46','569',2475589.05,2475589.05,'569','2022-06-07 21:29:00','648','2022-06-08 09:36:13',10,0),('1','161',257816,'MORNING SHIFT','2022-06-08','2022-06-08 15:07:54','2022-06-09 15:07:54','569',1879305.45,1879305.45,'569','2022-06-08 15:14:40','648','2022-06-09 08:59:00',10,0),('1','161',257817,'AFTERNOON SHIFT','2022-06-08','2022-06-09 10:53:58','2022-06-10 10:53:58','569',2690559.30,2690559.30,'569','2022-06-09 12:36:45','648','2022-06-09 14:10:37',10,0),('1','161',257818,'MORNING SHIFT','2022-06-09','2022-06-09 15:07:09','2022-06-10 15:07:09','569',2392929.00,2392929.00,'569','2022-06-09 15:23:08','648','2022-06-09 21:29:14',10,0),('1','161',257819,'AFTERNOON SHIFT','2022-06-09','2022-06-09 22:13:36','2022-06-10 22:13:36','569',2807428.80,2807428.80,'569','2022-06-09 22:24:27','648','2022-06-10 15:09:25',10,0),('1','161',257820,'MORNING SHIFT','2022-06-10','2022-06-10 19:08:13','2022-06-11 19:08:13','569',1757573.40,1757573.40,'569','2022-06-10 19:13:29','648','2022-06-11 09:45:22',10,0),('1','161',257821,'AFTERNOON SHIFT','2022-06-10','2022-06-11 11:24:53','2022-06-12 11:24:53','569',2558851.35,2558851.35,'569','2022-06-11 12:49:04','648','2022-06-11 13:51:35',10,0),('1','161',257822,'MORNING SHIFT','2022-06-11','2022-06-11 15:27:35','2022-06-12 15:27:35','569',0.00,0.00,'569','2022-06-11 18:43:56','648','2022-06-11 18:45:34',10,0),('1','161',257823,'MORNING SHIFT','2022-06-11','2022-06-11 19:35:37','2022-06-12 19:35:37','569',1858946.10,1858946.10,'569','2022-06-11 19:48:52','648','2022-06-11 23:22:18',10,0),('1','161',257824,'AFTERNOON SHIFT','2022-06-11','2022-06-12 10:23:40','2022-06-13 10:23:40','569',2654736.15,2654736.15,'569','2022-06-12 10:29:52','648','2022-06-12 10:31:42',10,0),('1','161',257825,'MORNING SHIFT','2022-06-12','2022-06-12 13:02:56','2022-06-13 13:02:56','569',1798153.50,1798153.50,'569','2022-06-12 13:46:23','648','2022-06-12 16:44:11',10,0),('1','161',257826,'AFTERNOON SHIFT','2022-06-12','2022-06-12 21:55:39','2022-06-13 21:55:39','569',2804505.00,2804505.00,'569','2022-06-12 22:02:32','648','2022-06-13 07:03:10',10,0),('1','161',257827,'MORNING SHIFT','2022-06-13','2022-06-13 12:14:22','2022-06-14 12:14:22','569',2422044.90,2422044.90,'569','2022-06-13 14:11:47','648','2022-06-13 15:51:26',10,0),('1','161',257828,'AFTERNOON SHIFT','2022-06-13','2022-06-13 21:32:13','2022-06-14 21:32:13','569',3759978.75,3759978.75,'569','2022-06-13 21:36:12','648','2022-06-14 09:32:24',10,0),('1','161',257829,'MORNING SHIFT','2022-06-14','2022-06-14 13:38:48','2022-06-15 13:38:48','569',2577166.35,2577166.35,'569','2022-06-14 13:45:44','648','2022-06-14 15:04:44',10,0),('1','161',257830,'AFTERNOON SHIFT','2022-06-14','2022-06-14 20:40:48','2022-06-15 20:40:48','569',3327414.75,3327414.75,'569','2022-06-14 21:27:20','648','2022-06-15 07:02:34',10,0),('1','161',257831,'MORNING SHIFT','2022-06-15','2022-06-15 13:25:51','2022-06-16 13:25:51','569',2249626.50,2249626.50,'569','2022-06-15 13:30:21','648','2022-06-15 14:59:15',10,0),('1','161',257832,'AFTERNOON SHIFT','2022-06-15','2022-06-15 20:51:44','2022-06-16 20:51:44','569',3217176.60,3217176.60,'569','2022-06-15 21:19:34','648','2022-06-16 09:34:30',10,0),('1','161',257833,'MORNING SHIFT','2022-06-16','2022-06-16 12:52:26','2022-06-17 12:52:26','569',2115667.95,2115667.95,'569','2022-06-16 15:11:56','648','2022-06-16 16:01:55',10,0),('1','161',257834,'AFTERNOON SHIFT','2022-06-16','2022-06-16 21:19:45','2022-06-17 21:19:45','569',2859662.85,2859662.85,'569','2022-06-16 21:24:46','648','2022-06-17 09:35:36',10,0),('1','161',257835,'MORNING SHIFT','2022-06-17','2022-06-17 15:19:42','2022-06-18 15:19:42','569',2224434.30,2224434.30,'569','2022-06-17 15:27:04','648','2022-06-17 22:18:46',10,0),('1','161',257836,'AFTERNOON SHIFT','2022-06-17','2022-06-18 06:09:31','2022-06-19 06:09:31','569',3221799.90,3221799.90,'569','2022-06-18 06:19:00','648','2022-06-18 10:30:42',10,0),('1','161',257837,'MORNING SHIFT','2022-06-18','2022-06-18 15:04:18','2022-06-19 15:04:18','569',2538503.55,2538503.55,'569','2022-06-18 15:15:29','648','2022-06-18 17:42:43',10,0),('1','161',257838,'AFTERNOON SHIFT','2022-06-18','2022-06-18 21:19:59','2022-06-19 21:19:59','569',2748513.90,2748513.90,'569','2022-06-18 21:29:02','648','2022-06-19 11:22:07',10,0),('1','161',257839,'MORNING SHIFT','2022-06-19','2022-06-19 14:12:26','2022-06-20 14:12:26','569',1889355.60,1889355.60,'569','2022-06-19 14:20:24','648','2022-06-19 15:53:45',10,0),('1','161',257840,'AFTERNOON SHIFT','2022-06-19','2022-06-19 21:19:11','2022-06-20 21:19:11','569',3020465.25,3020465.25,'569','2022-06-19 21:24:39','648','2022-06-20 08:18:25',10,0),('1','161',257841,'MORNING SHIFT','2022-06-20','2022-06-20 13:18:46','2022-06-21 13:18:46','569',2716528.65,2716528.65,'569','2022-06-20 13:37:55','648','2022-06-20 15:42:21',10,0),('1','161',257842,'AFTERNOON SHIFT','2022-06-20','2022-06-20 21:27:16','2022-06-21 21:27:16','569',4010394.30,4010394.30,'569','2022-06-20 21:32:10','648','2022-06-21 08:56:52',10,0),('1','161',257843,'MORNING SHIFT','2022-06-21','2022-06-21 12:32:12','2022-06-22 12:32:12','569',2333063.70,2333063.70,'569','2022-06-21 15:40:37','648','2022-06-21 17:01:18',10,0),('1','161',257844,'AFTERNOON SHIFT','2022-06-21','2022-06-21 19:43:06','2022-06-22 19:43:06','569',855571.20,855571.20,'569','2022-06-21 19:47:26','648','2022-06-21 22:05:44',10,0),('1','161',257845,'MORNING SHIFT','2022-06-22','2022-06-22 14:07:15','2022-06-23 14:07:15','569',3990003.60,3990003.60,'569','2022-06-22 14:15:08','648','2022-06-22 17:20:58',10,0),('1','161',257846,'AFTERNOON SHIFT','2022-06-22','2022-06-22 19:28:51','2022-06-23 19:28:51','569',2574534.60,2574534.60,'569','2022-06-22 19:35:58','648','2022-06-23 08:17:30',10,0),('1','161',257847,'MORNING SHIFT','2022-06-23','2022-06-23 14:30:44','2022-06-24 14:30:44','569',3431696.40,3431696.40,'569','2022-06-23 14:38:11','648','2022-06-23 15:53:35',10,0),('1','161',257848,'AFTERNOON SHIFT','2022-06-23','2022-06-23 21:29:46','2022-06-24 21:29:46','569',3061946.25,3061946.25,'569','2022-06-23 21:32:40','648','2022-06-24 10:39:47',10,0),('1','161',257849,'MORNING SHIFT','2022-06-24','2022-06-24 15:33:04','2022-06-25 15:33:04','569',3190072.05,3190072.05,'569','2022-06-24 15:37:48','648','2022-06-24 17:33:37',10,0),('1','161',257850,'AFTERNOON SHIFT','2022-06-24','2022-06-24 19:26:12','2022-06-25 19:26:12','569',1118404.65,1118404.65,'569','2022-06-24 19:31:10','648','2022-06-25 09:07:40',10,0),('1','161',257851,'MORNING SHIFT','2022-06-25','2022-06-25 15:21:19','2022-06-26 15:21:19','569',694806.75,694806.75,'569','2022-06-25 15:25:30','648','2022-06-25 18:24:53',10,0),('1','161',257852,'MORNING SHIFT','2022-06-28','2022-06-29 05:15:11','2022-06-30 05:15:11','569',278158.65,278158.65,'569','2022-06-29 05:17:51','648','2022-06-29 08:38:35',10,0),('1','161',257853,'MORNING SHIFT','2022-06-29','2022-06-29 14:17:00','2022-06-30 14:17:00','569',3346798.95,3346798.95,'569','2022-06-29 14:23:33','648','2022-06-29 17:15:27',10,0),('1','161',257854,'AFTERNOON SHIFT','2022-06-29','2022-06-29 17:46:14','2022-06-30 17:46:14','569',1939146.00,1939146.00,'569','2022-06-29 20:20:07','648','2022-06-30 12:26:27',10,0),('1','161',257855,'MORNING SHIFT','2022-06-30','2022-06-30 15:39:00','2022-07-01 15:39:00','569',5247922.35,5247922.35,'569','2022-06-30 22:22:20','648','2022-07-01 07:57:06',10,0),('1','161',257856,'MORNING SHIFT','2022-07-01','2022-07-01 14:42:55','2022-07-02 14:42:55','569',3281046.45,3281046.45,'569','2022-07-01 14:47:32','648','2022-07-01 15:40:02',10,0),('1','161',257857,'MORNING SHIFT','2022-07-02','2022-07-02 12:33:49','2022-07-03 12:33:49','569',2521521.75,2521521.75,'569','2022-07-02 14:36:07','648','2022-07-03 05:55:39',10,0),('1','161',257858,'MORNING SHIFT','2022-07-06','2022-07-06 12:22:18','2022-07-07 12:22:18','569',279750.90,279750.90,'569','2022-07-06 12:27:28','648','2022-07-06 14:59:20',10,0),('1','161',257859,'MORNING SHIFT','2022-07-05','2022-07-08 13:54:05','2022-07-09 13:54:05','426',0.00,0.00,'426','2022-07-08 13:55:48','426','2022-07-08 13:56:05',10,0),('1','161',257860,'MORNING SHIFT','2022-07-19','2022-07-19 10:49:39','2022-07-20 10:49:39','569',3171208.25,3171208.25,'569','2022-07-20 18:49:03','648','2022-07-20 19:20:06',10,0),('1','161',257861,'AFTERNOON SHIFT','2022-07-19','2022-07-20 19:49:02','2022-07-21 19:49:02','569',2037393.32,2060947.00,'569','2022-07-20 19:51:57','648','2022-07-21 07:23:28',10,0),('1','161',257862,'MORNING SHIFT','2022-07-20','2022-07-21 10:58:14','2022-07-22 10:58:14','569',486391.50,486391.50,'569','2022-07-21 11:03:59','648','2022-07-21 14:37:05',10,0),('1','161',257863,'AFTERNOON SHIFT','2022-07-20','2022-07-21 14:45:34','2022-07-22 14:45:34','569',1197505.75,1197505.75,'569','2022-07-21 14:48:45','648','2022-07-21 14:51:41',10,0),('1','161',257864,'MORNING SHIFT','2022-07-21','2022-07-21 19:04:48','2022-07-22 19:04:48','569',3019117.50,3019117.50,'569','2022-07-21 19:07:55','648','2022-07-22 08:14:55',10,0),('1','161',257865,'AFTERNOON SHIFT','2022-07-21','2022-07-22 09:29:18','2022-07-23 09:29:18','569',3153510.50,3153510.50,'569','2022-07-22 10:03:49','648','2022-07-22 10:04:46',10,0),('1','161',257866,'MORNING SHIFT','2022-07-22','2022-07-22 10:34:17','2022-07-23 10:34:17','569',2968780.50,2968780.50,'569','2022-07-22 15:34:13','648','2022-07-22 15:55:07',10,0),('1','161',257867,'AFTERNOON SHIFT','2022-07-22','2022-07-22 21:26:44','2022-07-23 21:26:44','569',3096089.50,3096089.50,'569','2022-07-22 21:30:04','648','2022-07-23 06:59:58',10,0),('1','161',257868,'MORNING SHIFT','2022-07-19','2022-07-23 08:30:30','2022-07-24 08:30:30','569',0.00,0.00,'569','2022-07-23 08:46:51','648','2022-07-23 11:02:54',10,0),('1','161',257869,'MORNING SHIFT','2022-07-23','2022-07-23 14:41:22','2022-07-24 14:41:22','569',3109372.00,3109372.00,'569','2022-07-23 14:46:54','648','2022-07-23 16:06:52',10,0),('1','161',257870,'AFTERNOON SHIFT','2022-07-23','2022-07-23 19:42:59','2022-07-24 19:42:59','569',1650069.75,1650069.75,'569','2022-07-23 19:49:23','648','2022-07-24 08:13:47',10,0),('1','161',257871,'MORNING SHIFT','2022-07-24','2022-07-24 14:37:05','2022-07-25 14:37:05','569',137135.25,137135.25,'569','2022-07-24 15:11:11','648','2022-07-24 21:29:58',10,0),('1','161',257872,'AFTERNOON SHIFT','2022-07-24','2022-07-24 21:34:43','2022-07-25 21:34:43','569',2596450.50,2596450.50,'569','2022-07-24 21:38:21','648','2022-07-25 08:08:26',10,0),('1','161',257873,'MORNING SHIFT','2022-07-25','2022-07-25 15:25:17','2022-07-26 15:25:17','569',2930718.00,2930718.00,'569','2022-07-25 15:38:17','648','2022-07-25 20:26:17',10,0),('1','161',257874,'AFTERNOON SHIFT','2022-07-25','2022-07-25 20:44:04','2022-07-26 20:44:04','569',3244249.75,3244249.75,'569','2022-07-25 20:48:51','648','2022-07-26 10:18:59',10,0),('1','161',257875,'MORNING SHIFT','2022-07-26','2022-07-26 14:56:19','2022-07-27 14:56:19','569',3249510.25,3249510.25,'569','2022-07-26 15:11:12','648','2022-07-26 15:32:02',10,0),('1','161',257876,'AFTERNOON SHIFT','2022-07-26','2022-07-26 20:52:39','2022-07-27 20:52:39','569',3064416.25,3064416.25,'569','2022-07-26 20:56:29','648','2022-07-27 09:08:48',10,0),('1','161',257877,'MORNING SHIFT','2022-07-27','2022-07-27 10:18:10','2022-07-28 10:18:10','569',1317020.25,1317020.25,'569','2022-07-27 10:26:44','648','2022-07-27 11:48:54',10,0),('1','161',257878,'AFTERNOON SHIFT','2022-07-27','2022-07-27 14:25:34','2022-07-28 14:25:34','569',1997987.40,1997987.40,'569','2022-07-27 17:18:40','648','2022-07-28 07:57:43',10,0),('1','161',257879,'MORNING SHIFT','2022-07-28','2022-07-28 13:58:15','2022-07-29 13:58:15','569',701026.20,701026.20,'569','2022-07-28 15:09:49','648','2022-07-28 15:42:42',10,0),('1','161',257880,'AFTERNOON SHIFT','2022-07-28','2022-07-28 21:06:23','2022-07-29 21:06:23','569',4180095.00,4180095.00,'569','2022-07-28 21:11:02','648','2022-07-29 08:14:08',10,0),('1','161',257881,'MORNING SHIFT','2022-07-29','2022-07-29 14:32:39','2022-07-30 14:32:39','569',2889010.80,2889010.80,'569','2022-07-29 14:36:21','648','2022-07-29 15:05:37',10,0),('1','161',257882,'AFTERNOON SHIFT','2022-07-29','2022-07-29 20:35:15','2022-07-30 20:35:15','569',3881881.80,3881881.80,'569','2022-07-29 21:21:39','648','2022-07-30 06:06:08',10,0),('1','161',257883,'MORNING SHIFT','2022-07-30','2022-07-30 14:41:11','2022-07-31 14:41:11','569',2898558.00,2898558.00,'569','2022-07-30 15:04:53','648','2022-07-30 18:55:51',10,0),('1','161',257884,'AFTERNOON SHIFT','2022-07-30','2022-07-30 21:09:19','2022-07-31 21:09:19','569',3660256.80,3660256.80,'569','2022-07-30 21:20:58','648','2022-07-31 10:02:28',10,0),('1','161',257885,'MORNING SHIFT','2022-07-31','2022-07-31 14:40:19','2022-08-01 14:40:19','569',2286878.40,2286878.40,'569','2022-07-31 14:44:17','648','2022-07-31 20:54:41',10,0),('1','161',257886,'AFTERNOON SHIFT','2022-07-31','2022-07-31 21:08:42','2022-08-01 21:08:42','569',2355334.20,2355334.20,'569','2022-07-31 21:12:45','648','2022-07-31 21:14:08',10,0),('1','161',257887,'MORNING SHIFT','2022-08-01','2022-08-01 14:00:54','2022-08-02 14:00:54','569',3353911.20,3353911.20,'569','2022-08-01 14:05:10','648','2022-08-01 14:45:38',10,0),('1','161',257888,'AFTERNOON SHIFT','2022-08-01','2022-08-01 21:05:53','2022-08-02 21:05:53','569',3608362.80,3608362.80,'569','2022-08-01 21:15:45','648','2022-08-02 05:51:41',10,0),('1','161',257889,'MORNING SHIFT','2022-08-02','2022-08-02 11:59:20','2022-08-03 11:59:20','569',2936458.80,2936458.80,'569','2022-08-02 15:03:37','648','2022-08-02 21:59:08',10,0),('1','161',257890,'AFTERNOON SHIFT','2022-08-02','2022-08-02 22:00:12','2022-08-03 22:00:12','569',3645585.00,3645585.00,'569','2022-08-02 22:06:39','648','2022-08-03 06:43:23',10,0),('1','161',257891,'MORNING SHIFT','2022-08-03','2022-08-03 14:52:43','2022-08-04 14:52:43','569',3112975.80,3112975.80,'569','2022-08-03 14:58:16','648','2022-08-03 16:22:59',10,0),('1','161',257892,'MORNING SHIFT','2022-08-04','2022-08-04 13:45:03','2022-08-05 13:45:03','569',1123389.00,1123389.00,'569','2022-08-04 15:32:28','648','2022-08-04 15:38:42',10,0),('1','161',257893,'DRIVER SHORTAGE SHIFT','2022-08-04','2022-08-04 15:44:34','2022-08-05 15:44:34','569',0.00,0.00,'569','2022-08-04 21:15:31','648','2022-08-04 21:19:42',10,0),('1','161',257894,'AFTERNOON SHIFT','2022-08-04','2022-08-04 21:24:54','2022-08-05 21:24:54','569',2923335.00,2923335.00,'569','2022-08-04 21:27:03','648','2022-08-04 21:34:52',10,0),('1','161',257895,'MORNING SHIFT','2022-08-05','2022-08-05 15:17:43','2022-08-06 15:17:43','569',2676927.60,2676927.60,'569','2022-08-05 15:21:11','648','2022-08-06 08:13:16',10,0),('1','161',257896,'MORNING SHIFT','2022-08-10','2022-08-10 13:31:13','2022-08-11 13:31:13','569',472222.80,472222.80,'569','2022-08-10 14:47:51','648','2022-08-10 19:43:26',10,0),('1','161',257897,'AFTERNOON SHIFT','2022-08-10','2022-08-10 21:04:59','2022-08-11 21:04:59','569',2367622.80,2367622.80,'569','2022-08-10 21:10:31','648','2022-08-11 06:46:42',10,0),('1','161',257898,'MORNING SHIFT','2022-08-11','2022-08-11 14:00:35','2022-08-12 14:00:35','569',2306894.40,2306894.40,'569','2022-08-11 14:03:10','648','2022-08-11 19:54:30',10,0),('1','161',257899,'AFTERNOON SHIFT','2022-08-11','2022-08-11 21:54:11','2022-08-12 21:54:11','569',2542330.80,2542330.80,'569','2022-08-11 21:58:15','648','2022-08-12 08:31:37',10,0),('1','161',257900,'MORNING SHIFT','2022-08-12','2022-08-12 11:57:30','2022-08-13 11:57:30','569',2201182.20,2201182.20,'569','2022-08-12 14:04:20','648','2022-08-12 14:55:03',10,0),('1','161',257901,'AFTERNOON SHIFT','2022-08-12','2022-08-12 21:39:45','2022-08-13 21:39:45','569',2576394.00,2576394.00,'569','2022-08-12 21:44:01','648','2022-08-13 06:20:42',10,0),('1','161',257902,'MORNING SHIFT','2022-08-13','2022-08-13 10:56:00','2022-08-14 10:56:00','569',2221959.60,2221959.60,'569','2022-08-13 13:51:14','648','2022-08-13 18:13:35',10,0),('1','161',257903,'AFTERNOON SHIFT','2022-08-13','2022-08-13 21:08:54','2022-08-14 21:08:54','569',2550367.80,2550367.80,'569','2022-08-13 21:15:07','648','2022-08-14 11:46:32',10,0),('1','161',257904,'MORNING SHIFT','2022-08-14','2022-08-14 16:16:11','2022-08-15 16:16:11','569',1761089.40,1761089.40,'569','2022-08-14 16:40:00','648','2022-08-14 17:24:20',10,0),('1','161',257905,'AFTERNOON SHIFT','2022-08-14','2022-08-14 20:58:31','2022-08-15 20:58:31','569',2122083.00,2122083.00,'569','2022-08-14 21:24:28','648','2022-08-15 10:07:30',10,0),('1','161',257906,'MORNING SHIFT','2022-08-15','2022-08-15 13:13:11','2022-08-16 13:13:11','569',2110620.60,2110620.60,'569','2022-08-15 14:02:00','648','2022-08-15 18:35:47',10,0),('1','161',257907,'AFTERNOON SHIFT','2022-08-15','2022-08-15 20:22:24','2022-08-16 20:22:24','569',2642084.26,2642084.26,'569','2022-08-15 21:33:46','648','2022-08-16 10:19:48',10,0),('1','161',257908,'MORNING SHIFT','2022-08-16','2022-08-16 13:59:27','2022-08-17 13:59:27','569',2176122.98,2176122.98,'569','2022-08-16 14:07:54','648','2022-08-16 21:39:21',10,0),('1','161',257909,'AFTERNOON SHIFT','2022-08-16','2022-08-16 21:42:13','2022-08-17 21:42:13','569',2670523.32,2670523.32,'569','2022-08-16 21:45:46','648','2022-08-17 05:52:21',10,0),('1','161',257910,'MORNING SHIFT','2022-08-17','2022-08-17 13:02:00','2022-08-18 13:02:00','569',1919842.14,1919842.14,'569','2022-08-17 13:30:47','648','2022-08-17 15:50:16',10,0),('1','161',257911,'AFTERNOON SHIFT','2022-08-17','2022-08-17 19:21:57','2022-08-18 19:21:57','569',1697676.78,1697676.78,'569','2022-08-17 19:25:48','648','2022-08-18 13:37:32',10,0),('1','161',257912,'AFTERNOON SHIFT','2022-08-18','2022-08-18 21:11:47','2022-08-19 21:11:47','569',2690014.32,2690014.32,'569','2022-08-18 21:14:03','648','2022-08-18 22:55:40',10,0),('1','161',257913,'MORNING SHIFT','2022-08-19','2022-08-19 15:32:43','2022-08-20 15:32:43','569',2129374.84,2129374.84,'569','2022-08-19 15:46:59','648','2022-08-19 16:35:44',10,0),('1','161',257914,'AFTERNOON SHIFT','2022-08-19','2022-08-19 21:29:29','2022-08-20 21:29:29','569',2657673.50,2657673.50,'569','2022-08-19 21:34:06','648','2022-08-20 06:22:51',10,0),('1','161',257915,'MORNING SHIFT','2022-08-20','2022-08-20 14:10:28','2022-08-21 14:10:28','569',2185772.36,2185772.36,'569','2022-08-20 14:15:52','648','2022-08-20 17:03:56',10,0),('1','161',257916,'AFTERNOON SHIFT','2022-08-20','2022-08-20 21:10:56','2022-08-21 21:10:56','569',2313868.28,2313868.28,'569','2022-08-20 21:17:27','648','2022-08-20 23:19:39',10,0),('1','161',257917,'MORNING SHIFT','2022-08-21','2022-08-21 14:32:56','2022-08-22 14:32:56','569',1489760.32,1489760.32,'569','2022-08-21 14:38:22','648','2022-08-21 15:17:57',10,0),('1','161',257918,'AFTERNOON SHIFT','2022-08-21','2022-08-21 21:20:35','2022-08-22 21:20:35','569',2273665.20,2273665.20,'569','2022-08-21 21:30:10','648','2022-08-22 03:25:38',10,0),('1','161',257919,'MORNING SHIFT','2022-08-22','2022-08-22 13:16:22','2022-08-23 13:16:22','569',2836659.62,2836659.62,'569','2022-08-22 13:21:48','648','2022-08-22 14:23:32',10,0),('1','161',257920,'AFTERNOON SHIFT','2022-08-22','2022-08-22 21:12:44','2022-08-23 21:12:44','569',3321679.36,3321679.36,'569','2022-08-22 21:17:25','648','2022-08-23 06:13:58',10,0),('1','161',257921,'MORNING SHIFT','2022-08-23','2022-08-23 14:28:32','2022-08-24 14:28:32','569',2302061.54,2302061.54,'569','2022-08-23 14:33:13','648','2022-08-23 18:14:19',10,0),('1','161',257922,'AFTERNOON SHIFT','2022-08-23','2022-08-23 20:58:51','2022-08-24 20:58:51','569',2571656.78,2571656.78,'569','2022-08-23 21:09:41','648','2022-08-24 08:37:14',10,0),('1','161',257923,'MORNING SHIFT','2022-08-24','2022-08-24 14:00:01','2022-08-25 14:00:01','569',2196432.78,2196432.78,'569','2022-08-24 14:03:56','648','2022-08-24 15:10:23',10,0),('1','161',257924,'AFTERNOON SHIFT','2022-08-24','2022-08-24 21:15:46','2022-08-25 21:15:46','569',2650177.92,2650177.92,'569','2022-08-24 21:22:04','648','2022-08-25 09:16:42',10,0),('1','161',257925,'MORNING SHIFT','2022-08-25','2022-08-25 09:25:26','2022-08-26 09:25:26','569',2671961.56,2671961.56,'569','2022-08-25 13:50:04','648','2022-08-25 15:17:36',10,0),('1','161',257926,'AFTERNOON SHIFT','2022-08-25','2022-08-25 21:25:22','2022-08-26 21:25:22','569',2749213.56,2749213.56,'569','2022-08-25 21:32:44','648','2022-08-26 08:11:51',10,0),('1','161',257927,'MORNING SHIFT','2022-08-26','2022-08-26 14:27:47','2022-08-27 14:27:47','569',2392588.78,2392588.78,'569','2022-08-26 14:32:32','648','2022-08-26 15:54:29',10,0),('1','161',257928,'AFTERNOON SHIFT','2022-08-26','2022-08-26 19:31:39','2022-08-27 19:31:39','569',2859646.54,2859646.54,'569','2022-08-26 21:17:58','648','2022-08-27 06:26:38',10,0),('1','161',257929,'MORNING SHIFT','2022-08-27','2022-08-27 14:58:01','2022-08-28 14:58:01','569',1136627.90,1136627.90,'569','2022-08-27 15:21:10','648','2022-08-27 16:03:03',10,0),('1','161',257930,'MORNING SHIFT','2022-08-28','2022-08-28 13:04:07','2022-08-29 13:04:07','569',912945.98,912945.98,'569','2022-08-28 14:50:15','648','2022-08-28 16:39:02',10,0),('1','161',257931,'AFTERNOON SHIFT','2022-08-28','2022-08-28 16:59:14','2022-08-29 16:59:14','569',3025919.90,3025919.90,'569','2022-08-28 21:51:23','648','2022-08-29 08:28:55',10,0),('1','161',257932,'MORNING SHIFT','2022-08-29','2022-08-29 13:58:05','2022-08-30 13:58:05','569',2859671.46,2859671.46,'569','2022-08-29 14:05:10','648','2022-08-29 15:51:18',10,0),('1','161',257933,'AFTERNOON SHIFT','2022-08-29','2022-08-29 21:34:14','2022-08-30 21:34:14','569',3801738.24,3801738.24,'569','2022-08-29 21:39:22','648','2022-08-30 06:23:59',10,0),('1','161',257934,'MORNING SHIFT','2022-08-30','2022-08-30 14:40:15','2022-08-31 14:40:15','569',2618216.24,2618216.24,'569','2022-08-30 14:45:24','648','2022-08-30 16:42:23',10,0),('1','161',257935,'AFTERNOON SHIFT','2022-08-30','2022-08-30 21:40:27','2022-08-31 21:40:27','569',3484287.70,3484287.70,'569','2022-08-30 21:43:22','648','2022-08-31 09:50:27',10,0),('1','161',257936,'MORNING SHIFT','2022-08-31','2022-08-31 14:08:34','2022-09-01 14:08:34','569',1892901.84,1892901.84,'569','2022-08-31 14:11:29','648','2022-08-31 16:49:07',10,0),('1','161',257937,'AFTERNOON SHIFT','2022-08-31','2022-08-31 21:43:41','2022-09-01 21:43:41','569',3927794.28,3927794.28,'569','2022-08-31 21:48:26','648','2022-09-01 09:03:35',10,0),('1','161',257938,'MORNING SHIFT','2022-09-01','2022-09-01 14:05:47','2022-09-02 14:05:47','569',3573506.64,3573506.64,'569','2022-09-01 14:11:31','648','2022-09-01 18:55:39',10,0),('1','161',257939,'AFTERNOON SHIFT','2022-09-01','2022-09-01 21:51:45','2022-09-02 21:51:45','569',3422790.48,3422790.48,'569','2022-09-01 22:01:10','648','2022-09-01 22:56:42',10,0),('1','161',257940,'MORNING SHIFT','2022-09-02','2022-09-02 11:45:28','2022-09-03 11:45:28','569',2597203.34,2597203.34,'569','2022-09-02 15:06:11','648','2022-09-02 16:08:03',10,0),('1','161',257941,'AFTERNOON SHIFT','2022-09-02','2022-09-02 21:44:50','2022-09-03 21:44:50','569',2995942.36,2995942.36,'569','2022-09-02 21:49:27','648','2022-09-03 10:59:13',10,0),('1','161',257942,'MORNING SHIFT','2022-09-03','2022-09-03 13:29:46','2022-09-04 13:29:46','569',2502968.58,2502968.58,'569','2022-09-03 13:35:18','648','2022-09-03 16:02:04',10,0),('1','161',257943,'AFTERNOON SHIFT','2022-09-03','2022-09-03 21:10:28','2022-09-04 21:10:28','569',2850105.74,2850105.74,'569','2022-09-03 21:16:45','648','2022-09-03 23:28:55',10,0),('1','161',257944,'MORNING SHIFT','2022-09-04','2022-09-04 14:00:59','2022-09-05 14:00:59','569',1792383.46,1792383.46,'569','2022-09-04 14:07:25','648','2022-09-04 18:21:30',10,0),('1','161',257945,'AFTERNOON SHIFT','2022-09-04','2022-09-04 20:58:30','2022-09-05 20:58:30','569',2417380.62,2417380.62,'569','2022-09-04 21:10:37','648','2022-09-05 08:54:58',10,0),('1','161',257946,'MORNING SHIFT','2022-09-05','2022-09-05 14:44:44','2022-09-06 14:44:44','569',2716037.92,2716037.92,'569','2022-09-05 14:51:44','648','2022-09-05 18:49:23',10,0),('1','161',257947,'AFTERNOON SHIFT','2022-09-05','2022-09-05 20:32:27','2022-09-06 20:32:27','569',3210456.06,3210456.06,'569','2022-09-05 21:05:03','648','2022-09-06 11:27:35',10,0),('1','161',257948,'MORNING SHIFT','2022-09-06','2022-09-06 14:17:28','2022-09-07 14:17:28','569',2552463.18,2552463.18,'569','2022-09-06 14:31:08','648','2022-09-06 16:07:04',10,0),('1','161',257949,'AFTERNOON SHIFT','2022-09-06','2022-09-07 04:36:25','2022-09-08 04:36:25','569',368805.32,368805.32,'569','2022-09-07 04:44:47','648','2022-09-07 19:33:51',10,0),('1','161',257950,'MORNING SHIFT','2022-09-07','2022-09-07 20:20:41','2022-09-08 20:20:41','569',2826293.96,2826293.96,'569','2022-09-07 20:38:58','648','2022-09-07 20:42:07',10,0),('1','161',257951,'AFTERNOON SHIFT','2022-09-07','2022-09-07 22:18:03','2022-09-08 22:18:03','569',2693857.34,2693857.34,'569','2022-09-08 00:09:10','648','2022-09-08 09:04:19',10,0),('1','161',257952,'MORNING SHIFT','2022-09-08','2022-09-08 14:56:49','2022-09-09 14:56:49','569',2589761.02,2589761.02,'569','2022-09-08 15:32:53','648','2022-09-08 23:10:44',10,0),('1','161',257953,'AFTERNOON SHIFT','2022-09-08','2022-09-08 23:16:08','2022-09-09 23:16:08','569',3000535.32,3000535.32,'569','2022-09-08 23:22:26','648','2022-09-09 05:10:21',10,0),('1','161',257954,'MORNING SHIFT','2022-09-09','2022-09-09 18:34:52','2022-09-10 18:34:52','569',2176066.10,2176066.10,'569','2022-09-09 18:43:42','648','2022-09-09 19:51:43',10,0),('1','161',257955,'AFTERNOON SHIFT','2022-09-09','2022-09-09 21:31:52','2022-09-10 21:31:52','569',2927225.88,2927225.88,'569','2022-09-09 21:37:19','648','2022-09-10 07:28:07',10,0),('1','161',257956,'MORNING SHIFT','2022-09-10','2022-09-10 13:28:56','2022-09-11 13:28:56','569',2954089.96,2954089.96,'569','2022-09-10 13:33:38','648','2022-09-10 15:25:27',10,0),('1','161',257957,'AFTERNOON SHIFT','2022-09-10','2022-09-10 21:17:52','2022-09-11 21:17:52','569',3693434.60,3693434.60,'569','2022-09-10 21:22:08','648','2022-09-11 11:16:00',10,0),('1','161',257958,'MORNING SHIFT','2022-09-11','2022-09-11 14:24:42','2022-09-12 14:24:42','569',2290975.72,2290975.72,'569','2022-09-11 14:32:57','648','2022-09-11 16:23:30',10,0),('1','161',257959,'AFTERNOON SHIFT','2022-09-11','2022-09-11 21:08:52','2022-09-12 21:08:52','569',2903309.94,2903309.94,'569','2022-09-11 21:34:24','648','2022-09-12 07:20:38',10,0),('1','161',257960,'MORNING SHIFT','2022-09-12','2022-09-12 13:36:23','2022-09-13 13:36:23','569',3617636.34,3617636.34,'569','2022-09-12 13:43:39','648','2022-09-12 14:24:03',10,0),('1','161',257961,'AFTERNOON SHIFT','2022-09-12','2022-09-12 21:14:24','2022-09-13 21:14:24','569',3499402.74,3499402.74,'569','2022-09-12 21:20:57','648','2022-09-13 08:43:07',10,0),('1','161',257962,'MORNING SHIFT','2022-09-13','2022-09-13 13:25:37','2022-09-14 13:25:37','569',3135574.46,3135574.46,'569','2022-09-13 13:34:30','648','2022-09-13 15:12:11',10,0),('1','161',257963,'AFTERNOON SHIFT','2022-09-13','2022-09-13 21:08:45','2022-09-14 21:08:45','569',4024586.84,4024586.84,'569','2022-09-13 21:14:04','648','2022-09-14 08:35:20',10,0),('1','161',257964,'MORNING SHIFT','2022-09-14','2022-09-14 13:27:34','2022-09-15 13:27:34','569',2955501.02,2955501.02,'569','2022-09-14 13:33:25','648','2022-09-14 21:53:02',10,0),('1','161',257965,'AFTERNOON SHIFT','2022-09-14','2022-09-14 21:57:36','2022-09-15 21:57:36','569',3840315.84,3840315.84,'569','2022-09-14 22:04:50','648','2022-09-14 22:17:10',10,0),('1','161',257966,'MORNING SHIFT','2022-09-15','2022-09-15 13:55:09','2022-09-16 13:55:09','569',3968467.54,3968467.54,'569','2022-09-15 14:00:37','648','2022-09-15 22:16:53',10,0),('1','161',257967,'AFTERNOON SHIFT','2022-09-15','2022-09-15 23:15:23','2022-09-16 23:15:23','569',4027600.64,4027600.64,'569','2022-09-16 06:21:08','648','2022-09-16 08:45:13',10,0),('1','161',257968,'MORNING SHIFT','2022-09-16','2022-09-16 14:35:23','2022-09-17 14:35:23','569',3877513.96,3877513.96,'569','2022-09-16 14:43:11','648','2022-09-16 16:50:10',10,0),('1','161',257969,'AFTERNOON SHIFT','2022-09-16','2022-09-16 19:43:57','2022-09-17 19:43:57','569',4314276.78,4314276.78,'569','2022-09-16 21:17:58','648','2022-09-17 06:29:44',10,0),('1','161',257970,'MORNING SHIFT','2022-09-17','2022-09-17 16:20:43','2022-09-18 16:20:43','569',2162428.06,2162428.06,'569','2022-09-17 16:24:55','648','2022-09-17 18:41:45',10,0),('1','161',257971,'AFTERNOON SHIFT','2022-09-17','2022-09-17 21:41:44','2022-09-18 21:41:44','569',1570383.68,1570383.68,'569','2022-09-17 22:06:20','648','2022-09-18 06:48:49',10,0),('1','161',257972,'MORNING SHIFT','2022-09-18','2022-09-18 14:08:10','2022-09-19 14:08:10','569',2057523.34,2057523.34,'569','2022-09-18 14:34:00','648','2022-09-18 15:33:10',10,0),('1','161',257973,'AFTERNOON SHIFT','2022-09-18','2022-09-18 21:45:50','2022-09-19 21:45:50','569',3120155.76,3120155.76,'569','2022-09-18 21:51:19','648','2022-09-19 06:11:17',10,0),('1','161',257974,'MORNING SHIFT','2022-09-19','2022-09-19 14:30:37','2022-09-20 14:30:37','569',2931013.68,2931013.68,'569','2022-09-19 14:36:45','648','2022-09-19 15:56:01',10,0),('1','161',257975,'AFTERNOON SHIFT','2022-09-19','2022-09-19 21:06:12','2022-09-20 21:06:12','569',3519914.62,3519914.62,'569','2022-09-19 21:18:31','648','2022-09-20 12:46:40',10,0),('1','161',257976,'MORNING SHIFT','2022-09-20','2022-09-20 14:21:34','2022-09-21 14:21:34','569',3801593.80,3801593.80,'569','2022-09-20 14:48:22','648','2022-09-20 15:32:27',10,0),('1','161',257977,'AFTERNOON SHIFT','2022-09-20','2022-09-20 21:01:49','2022-09-21 21:01:49','569',3309306.84,3309306.84,'569','2022-09-20 21:30:41','648','2022-09-21 08:52:00',10,0),('1','161',257978,'MORNING SHIFT','2022-09-21','2022-09-21 14:41:17','2022-09-22 14:41:17','569',2871083.02,2871083.02,'569','2022-09-21 14:53:21','648','2022-09-21 20:32:29',10,0),('1','161',257979,'AFTERNOON SHIFT','2022-09-21','2022-09-21 21:27:18','2022-09-22 21:27:18','569',3911046.94,3911046.94,'569','2022-09-21 21:34:23','648','2022-09-22 09:05:27',10,0),('1','161',257980,'MORNING SHIFT','2022-09-22','2022-09-22 14:43:41','2022-09-23 14:43:41','569',2965519.76,2965519.76,'569','2022-09-22 14:51:00','648','2022-09-22 18:06:13',10,0),('1','161',257981,'AFTERNOON SHIFT','2022-09-22','2022-09-22 21:54:02','2022-09-23 21:54:02','569',3821781.78,3821781.78,'569','2022-09-22 21:57:16','648','2022-09-23 09:12:21',10,0),('1','161',257982,'MORNING SHIFT','2022-09-23','2022-09-23 14:25:18','2022-09-24 14:25:18','569',2620587.20,2620587.20,'569','2022-09-23 14:27:57','648','2022-09-23 17:02:21',10,0),('1','161',257983,'AFTERNOON SHIFT','2022-09-23','2022-09-23 20:51:20','2022-09-24 20:51:20','569',3025157.76,3025157.76,'569','2022-09-23 20:57:17','648','2022-09-23 22:31:55',10,0),('1','161',257984,'AFTERNOON SHIFT','2022-09-24','2022-09-24 21:09:27','2022-09-25 21:09:27','569',3428397.72,3428397.72,'569','2022-09-24 21:16:39','648','2022-09-24 21:17:42',10,0),('1','161',257985,'MORNING SHIFT','2022-09-25','2022-09-25 14:36:03','2022-09-26 14:36:03','569',2047056.96,2047056.96,'569','2022-09-25 14:42:42','648','2022-09-25 21:12:17',10,0),('1','161',257986,'AFTERNOON SHIFT','2022-09-25','2022-09-25 21:12:37','2022-09-26 21:12:37','569',2609449.70,2609449.70,'569','2022-09-25 21:20:17','648','2022-09-26 09:17:11',10,0),('1','161',257987,'MORNING SHIFT','2022-09-26','2022-09-26 14:13:27','2022-09-27 14:13:27','569',3445018.82,3445018.82,'569','2022-09-26 14:18:24','648','2022-09-26 20:57:04',10,0),('1','161',257988,'AFTERNOON SHIFT','2022-09-26','2022-09-26 21:02:33','2022-09-27 21:02:33','569',4543831.34,4543831.34,'569','2022-09-26 21:26:08','648','2022-09-26 23:39:03',10,0),('1','161',257989,'MORNING SHIFT','2022-09-27','2022-09-27 14:57:32','2022-09-28 14:57:32','569',3028269.48,3028269.48,'569','2022-09-27 16:03:46','648','2022-09-27 21:30:57',10,0),('1','161',257990,'AFTERNOON SHIFT','2022-09-27','2022-09-27 21:31:44','2022-09-28 21:31:44','569',3498717.78,3498717.78,'569','2022-09-27 21:38:19','648','2022-09-28 10:50:26',10,0),('1','161',257991,'MORNING SHIFT','2022-09-28','2022-09-28 14:05:01','2022-09-29 14:05:01','569',2582661.16,2582661.16,'569','2022-09-28 14:44:46','648','2022-09-28 21:14:37',10,0),('1','161',257992,'AFTERNOON SHIFT','2022-09-28','2022-09-28 22:16:12','2022-09-29 22:16:12','569',3354931.98,3354931.98,'569','2022-09-29 00:16:07','648','2022-09-29 07:10:11',10,0),('1','161',257993,'MORNING SHIFT','2022-09-29','2022-09-29 15:06:16','2022-09-30 15:06:16','569',2759856.78,2759856.78,'569','2022-09-29 15:13:25','648','2022-09-29 20:36:52',10,0),('1','161',257994,'AFTERNOON SHIFT','2022-09-29','2022-09-29 21:17:27','2022-09-30 21:17:27','569',3373051.22,3373051.22,'569','2022-09-29 21:24:29','648','2022-09-30 10:08:12',10,0),('1','161',257995,'MORNING SHIFT','2022-09-30','2022-09-30 16:07:22','2022-10-01 16:07:22','569',2818365.36,2818365.36,'569','2022-09-30 16:12:23','648','2022-09-30 16:43:53',10,0),('1','161',257996,'AFTERNOON SHIFT','2022-09-30','2022-09-30 21:19:38','2022-10-01 21:19:38','569',3981774.28,3981774.28,'569','2022-09-30 21:26:12','648','2022-10-01 07:27:28',10,0),('1','161',257997,'MORNING SHIFT','2022-10-01','2022-10-01 13:48:18','2022-10-02 13:48:18','569',3712145.16,3712145.16,'569','2022-10-01 14:15:19','648','2022-10-01 21:07:37',10,0),('1','161',257998,'AFTERNOON SHIFT','2022-10-01','2022-10-01 21:20:12','2022-10-02 21:20:12','569',3513246.88,3513246.88,'569','2022-10-01 21:26:14','648','2022-10-02 13:01:00',10,0),('1','161',257999,'MORNING SHIFT','2022-10-02','2022-10-02 14:29:23','2022-10-03 14:29:23','569',2486749.00,2486749.00,'569','2022-10-02 14:39:03','648','2022-10-02 20:55:34',10,0),('1','161',258000,'AFTERNOON SHIFT','2022-10-02','2022-10-02 21:33:09','2022-10-03 21:33:09','569',3221098.50,3221098.50,'569','2022-10-02 21:37:22','648','2022-10-03 09:00:15',10,0),('1','161',258001,'MORNING SHIFT','2022-10-03','2022-10-03 13:11:29','2022-10-04 13:11:29','569',2857583.34,2857583.34,'569','2022-10-03 13:23:44','648','2022-10-03 17:49:36',10,0),('1','161',258002,'AFTERNOON SHIFT','2022-10-03','2022-10-03 21:40:56','2022-10-04 21:40:56','569',2651857.86,2651857.86,'569','2022-10-03 21:45:54','648','2022-10-04 09:33:25',10,0),('1','161',258003,'MORNING SHIFT','2022-10-04','2022-10-04 13:21:37','2022-10-05 13:21:37','569',2729107.94,2729107.94,'569','2022-10-04 13:27:48','648','2022-10-04 20:28:35',10,0),('1','161',258004,'AFTERNOON SHIFT','2022-10-04','2022-10-04 21:28:42','2022-10-05 21:28:42','569',0.00,0.00,'569','2022-10-06 10:25:26','426','2022-10-06 10:48:48',10,0),('1','161',258005,'AFTERNOON SHIFT','2022-10-04','2022-10-06 10:59:39','2022-10-07 10:59:39','569',3733083.60,3733083.60,'569','2022-10-06 11:09:42','648','2022-10-06 21:01:52',10,0),('1','161',258006,'MORNING SHIFT','2022-10-05','2022-10-06 21:28:56','2022-10-07 21:28:56','569',1380018.50,1380018.50,'569','2022-10-06 21:30:26','648','2022-10-06 21:48:27',10,0),('1','161',258007,'AFTERNOON SHIFT','2022-10-06','2022-10-06 22:28:58','2022-10-07 22:28:58','569',0.00,0.00,'569','2022-10-07 09:51:07','648','2022-10-07 09:54:46',10,0),('1','161',258008,'AFTERNOON SHIFT','2022-10-06','2022-10-07 10:01:22','2022-10-08 10:01:22','569',2452948.40,2452948.40,'569','2022-10-07 10:06:31','648','2022-10-07 15:15:56',10,0),('1','161',258009,'MORNING SHIFT','2022-10-07','2022-10-07 18:13:29','2022-10-08 18:13:29','569',2991356.96,2991356.96,'569','2022-10-07 18:22:29','648','2022-10-07 22:15:22',10,0),('1','161',258010,'AFTERNOON SHIFT','2022-10-07','2022-10-08 04:47:54','2022-10-09 04:47:54','569',3434395.44,3434395.44,'569','2022-10-08 05:12:17','648','2022-10-08 07:19:46',10,0),('1','161',258011,'MORNING SHIFT','2022-10-08','2022-10-08 12:16:57','2022-10-09 12:16:57','569',3006948.74,3006948.74,'569','2022-10-08 13:31:22','648','2022-10-08 17:21:00',10,0),('1','161',258012,'AFTERNOON SHIFT','2022-10-08','2022-10-08 21:23:48','2022-10-09 21:23:48','569',3542946.48,3542946.48,'569','2022-10-09 09:40:19','648','2022-10-09 13:40:09',10,0),('1','161',258013,'MORNING SHIFT','2022-10-09','2022-10-09 14:04:32','2022-10-10 14:04:32','569',2102986.34,2102986.34,'569','2022-10-09 14:14:54','648','2022-10-09 16:57:10',10,0),('1','161',258014,'AFTERNOON SHIFT','2022-10-09','2022-10-09 21:32:10','2022-10-10 21:32:10','569',3030279.94,3030279.94,'569','2022-10-09 21:38:13','648','2022-10-10 08:13:06',10,0),('1','161',258015,'MORNING SHIFT','2022-10-10','2022-10-10 10:49:08','2022-10-11 10:49:08','569',2618732.88,2618732.88,'569','2022-10-10 14:20:24','648','2022-10-10 15:31:22',10,0),('1','161',258016,'AFTERNOON SHIFT','2022-10-10','2022-10-10 20:45:04','2022-10-11 20:45:04','569',2490446.38,2490446.38,'569','2022-10-10 20:51:56','648','2022-10-11 09:16:21',10,0),('1','161',258017,'MORNING SHIFT','2022-10-11','2022-10-11 16:07:11','2022-10-12 16:07:11','569',2603466.78,2603466.78,'569','2022-10-11 16:14:13','648','2022-10-11 20:22:13',10,0),('1','161',258018,'AFTERNOON SHIFT','2022-10-11','2022-10-12 10:05:51','2022-10-13 10:05:51','569',548731.28,548731.28,'569','2022-10-12 10:12:20','648','2022-10-13 07:55:44',10,0),('1','161',258019,'MORNING SHIFT','2022-10-15','2022-10-16 06:11:14','2022-10-17 06:11:14','569',2224096.00,2224096.00,'569','2022-10-16 06:13:07','648','2022-10-18 10:16:58',10,0),('1','161',258020,'MORNING SHIFT','2022-10-18','2022-10-18 10:29:23','2022-10-19 10:29:23','569',2657840.00,2657840.00,'569','2022-10-18 10:30:36','648','2022-10-19 20:47:29',10,0),('1','161',258021,'MORNING SHIFT','2022-11-02','2022-11-10 13:18:18','2022-11-11 13:18:18','569',280480.00,280480.00,'569','2022-11-10 13:19:30','648','2022-11-17 06:40:29',10,0),('1','161',258022,'AFTERNOON SHIFT','2022-11-16','2022-11-17 06:48:29','2022-11-18 06:48:29','569',3008995.50,3008995.50,'569','2022-11-17 23:23:28','648','2022-11-18 06:30:49',10,0),('1','161',258023,'MORNING SHIFT','2022-11-17','2022-11-19 06:00:12','2022-11-20 06:00:12','569',3333974.70,3333974.70,'569','2022-11-19 06:05:53','648','2022-11-19 08:42:05',10,0),('1','161',258024,'AFTERNOON SHIFT','2022-11-17','2022-11-19 09:00:36','2022-11-20 09:00:36','569',4299985.20,4299985.20,'569','2022-11-19 09:11:45','648','2022-11-19 13:08:14',10,0),('1','161',258025,'MORNING SHIFT','2022-11-18','2022-11-19 14:53:55','2022-11-20 14:53:55','569',1053780.00,1053780.00,'569','2022-11-19 14:56:47','648','2022-11-19 17:55:52',10,0),('1','161',258026,'MORNING SHIFT','2022-11-23','2022-11-24 13:54:24','2022-11-25 13:54:24','569',2480171.40,2480171.40,'569','2022-11-24 14:00:19','648','2022-11-24 16:17:03',10,0),('1','161',258027,'AFTERNOON SHIFT','2022-11-23','2022-11-24 16:37:55','2022-11-25 16:37:55','569',5419782.90,5419782.90,'569','2022-11-24 16:44:39','648','2022-11-24 17:12:46',10,0),('1','161',258028,'MORNING SHIFT','2022-11-24','2022-11-24 20:17:34','2022-11-25 20:17:34','569',5120064.60,5120064.60,'569','2022-11-24 20:27:48','648','2022-11-24 21:43:59',10,0),('1','161',258029,'AFTERNOON SHIFT','2022-11-24','2022-11-24 23:19:12','2022-11-25 23:19:12','569',6246966.60,6246966.60,'569','2022-11-25 11:20:39','648','2022-11-25 15:43:26',10,0),('1','161',258030,'MORNING SHIFT','2022-11-25','2022-11-25 15:49:18','2022-11-26 15:49:18','569',6494907.30,6494907.30,'569','2022-11-25 15:59:56','648','2022-11-25 17:16:58',10,0),('1','161',258031,'AFTERNOON SHIFT','2022-11-25','2022-11-26 13:26:46','2022-11-27 13:26:46','569',3746622.60,3746622.60,'569','2022-11-26 13:31:16','648','2022-11-26 15:11:40',10,0),('1','161',258032,'MORNING SHIFT','2022-11-26','2022-11-26 15:33:35','2022-11-27 15:33:35','569',5266174.20,5266174.20,'569','2022-11-26 16:02:10','648','2022-11-27 09:20:34',10,0),('1','161',258033,'AFTERNOON SHIFT','2022-11-26','2022-11-27 13:16:14','2022-11-28 13:16:14','569',4117827.00,4117827.00,'569','2022-11-27 14:23:38','648','2022-11-27 14:45:54',10,0),('1','161',258034,'MORNING SHIFT','2022-11-27','2022-11-27 14:48:30','2022-11-28 14:48:30','569',5269187.70,5269187.70,'569','2022-11-27 14:52:50','648','2022-11-27 14:58:48',10,0),('1','161',258035,'AFTERNOON SHIFT','2022-11-27','2022-11-27 17:09:38','2022-11-28 17:09:38','569',2178514.80,2178514.80,'569','2022-11-27 18:25:48','648','2022-11-28 13:26:06',10,0),('1','161',258036,'MORNING SHIFT','2022-11-28','2022-11-28 15:07:47','2022-11-29 15:07:47','569',2380631.40,2380631.40,'569','2022-11-28 15:12:45','648','2022-11-29 11:13:46',10,0),('1','161',258037,'AFTERNOON SHIFT','2022-11-29','2022-11-29 17:25:56','2022-11-30 17:25:56','569',638347.50,638347.50,'569','2022-11-29 17:28:47','648','2022-11-29 23:02:38',10,0),('1','161',258038,'MORNING SHIFT','2022-12-12','2022-12-12 20:15:53','2022-12-13 20:15:53','569',317383.50,317383.50,'569','2022-12-12 20:21:07','648','2022-12-14 09:34:52',10,0),('1','161',258039,'MORNING SHIFT','2022-12-15','2022-12-15 20:54:19','2022-12-16 20:54:19','569',4569840.10,4569840.10,'569','2022-12-15 21:34:28','648','2022-12-15 21:46:49',10,0),('1','161',258040,'MORNING SHIFT','2022-12-16','2022-12-16 12:52:30','2022-12-17 12:52:30','569',5771424.50,5771424.50,'569','2022-12-16 14:36:22','648','2022-12-16 15:04:58',10,0),('1','161',258041,'MORNING SHIFT','2022-12-17','2022-12-17 11:43:36','2022-12-18 11:43:36','569',115933.80,115933.80,'569','2022-12-17 12:09:10','648','2022-12-17 15:01:04',10,0),('1','161',258042,'MORNING SHIFT','2022-12-18','2022-12-18 20:36:35','2022-12-19 20:36:35','569',4022591.90,4022591.90,'569','2022-12-18 20:56:36','648','2022-12-18 21:04:15',10,0),('1','161',258043,'MORNING SHIFT','2022-12-19','2022-12-19 14:18:00','2022-12-20 14:18:00','569',3087736.20,3087736.20,'569','2022-12-19 14:21:10','648','2022-12-20 05:27:49',10,0),('1','161',258044,'AFTERNOON SHIFT','2022-12-20','2022-12-21 06:02:50','2022-12-22 06:02:50','569',428009.30,428009.30,'569','2022-12-21 06:17:45','648','2022-12-21 07:57:43',10,0),('1','161',258045,'MORNING SHIFT','2022-12-21','2022-12-21 19:39:25','2022-12-22 19:39:25','569',814662.30,814662.30,'569','2022-12-21 19:41:49','648','2022-12-21 22:14:22',10,0),('1','161',258046,'MORNING SHIFT','2022-12-23','2022-12-23 15:46:24','2022-12-24 15:46:24','569',3733564.70,3733564.70,'569','2022-12-23 16:49:44','648','2022-12-24 06:58:13',10,0),('1','161',258047,'MORNING SHIFT','2022-12-24','2022-12-24 12:31:05','2022-12-25 12:31:05','569',1532568.00,1532568.00,'569','2022-12-24 12:53:59','648','2022-12-24 23:12:13',10,0),('1','161',258048,'AFTERNOON SHIFT','2022-12-25','2022-12-25 22:17:42','2022-12-26 22:17:42','569',1525300.80,1525300.80,'569','2022-12-25 22:21:54','648','2022-12-26 05:56:43',10,0),('1','161',258049,'AFTERNOON SHIFT','2022-12-26','2022-12-27 08:31:53','2022-12-28 08:31:53','569',730507.20,730507.20,'569','2022-12-27 08:35:34','648','2022-12-28 04:49:29',10,0),('1','161',258050,'MORNING SHIFT','2023-01-07','2023-01-07 14:20:31','2023-01-08 14:20:31','569',1609552.80,1609552.80,'569','2023-01-07 16:46:37','648','2023-01-07 16:50:17',10,0),('1','161',258051,'AFTERNOON SHIFT','2023-01-07','2023-01-07 16:58:10','2023-01-08 16:58:10','569',0.00,0.00,'569','2023-01-07 17:05:47','648','2023-01-07 17:09:21',10,0),('1','161',258052,'AFTERNOON SHIFT','2023-01-07','2023-01-07 17:12:12','2023-01-08 17:12:12','569',617798.40,617798.40,'569','2023-01-07 17:13:16','648','2023-01-08 14:19:57',10,0),('1','161',258053,'MORNING SHIFT','2023-01-08','2023-01-08 14:46:40','2023-01-09 14:46:40','569',1872823.20,1872823.20,'569','2023-01-08 14:54:13','648','2023-01-09 06:14:19',10,0),('1','161',258054,'MORNING SHIFT','2023-01-11','2023-01-11 14:37:00','2023-01-12 14:37:00','569',3188208.00,3188208.00,'569','2023-01-11 14:44:27','648','2023-01-11 14:49:56',10,0),('1','161',258055,'AFTERNOON SHIFT','2023-01-11','2023-01-11 17:41:25','2023-01-12 17:41:25','569',966760.80,966760.80,'569','2023-01-11 17:56:10','648','2023-01-12 07:02:12',10,0),('1','161',258056,'MORNING SHIFT','2023-01-12','2023-01-12 10:02:35','2023-01-13 10:02:35','569',2104910.40,2104910.40,'569','2023-01-12 10:11:50','648','2023-01-12 13:15:02',10,0),('1','161',258057,'AFTERNOON SHIFT','2023-01-12','2023-01-13 00:05:49','2023-01-14 00:05:49','569',495321.60,495321.60,'569','2023-01-13 00:13:07','648','2023-01-13 09:11:05',10,0),('1','161',258058,'MORNING SHIFT','2023-01-13','2023-01-13 15:40:52','2023-01-14 15:40:52','569',2807443.20,2807443.20,'569','2023-01-13 15:53:08','648','2023-01-14 00:00:47',10,0),('1','161',258059,'AFTERNOON SHIFT','2023-01-13','2023-01-14 04:51:55','2023-01-15 04:51:55','569',0.00,0.00,'569','2023-01-14 04:55:25','648','2023-01-14 09:48:28',10,0),('1','161',258060,'MORNING SHIFT','2023-01-14','2023-01-14 13:14:19','2023-01-15 13:14:19','569',2168049.60,2168049.60,'569','2023-01-14 13:47:19','648','2023-01-14 15:00:59',10,0),('1','161',258061,'AFTERNOON SHIFT','2023-01-14','2023-01-14 15:46:54','2023-01-15 15:46:54','569',1087600.80,1087600.80,'569','2023-01-14 16:25:11','648','2023-01-15 13:38:18',10,0),('1','161',258062,'MORNING SHIFT','2023-01-15','2023-01-15 14:07:36','2023-01-16 14:07:36','569',2014370.40,2014370.40,'569','2023-01-15 14:10:24','648','2023-01-15 21:35:32',10,0),('1','161',258063,'AFTERNOON SHIFT','2023-01-15','2023-01-15 21:38:59','2023-01-16 21:38:59','569',2208199.20,2208199.20,'569','2023-01-15 21:41:57','648','2023-01-16 08:01:03',10,0),('1','161',258064,'MORNING SHIFT','2023-01-16','2023-01-16 09:51:39','2023-01-17 09:51:39','569',483460.80,483460.80,'569','2023-01-16 09:53:21','648','2023-01-16 13:48:16',10,0),('1','161',258065,'MORNING SHIFT','2023-01-19','2023-01-19 13:34:21','2023-01-20 13:34:21','569',2755593.60,2755593.60,'569','2023-01-19 13:37:52','648','2023-01-19 18:14:09',10,0),('1','161',258066,'AFTERNOON SHIFT','2023-01-19','2023-01-19 19:13:22','2023-01-20 19:13:22','569',1403220.00,1403220.00,'569','2023-01-19 19:18:29','648','2023-01-20 09:17:15',10,0),('1','161',258067,'MORNING SHIFT','2023-01-20','2023-01-20 15:17:34','2023-01-21 15:17:34','569',3510220.80,3510220.80,'569','2023-01-20 15:28:54','648','2023-01-20 15:32:17',10,0),('1','161',258068,'MORNING SHIFT','2023-01-21','2023-01-21 13:58:08','2023-01-22 13:58:08','569',559017.60,559017.60,'569','2023-01-21 14:00:01','648','2023-01-21 22:02:26',10,0),('1','161',258069,'MORNING SHIFT','2023-01-22','2023-01-23 05:24:40','2023-01-24 05:24:40','569',2172816.00,2172816.00,'569','2023-01-23 05:33:21','648','2023-01-23 16:56:33',10,0),('1','161',258070,'MORNING SHIFT','2023-01-24','2023-01-24 16:41:19','2023-01-25 16:41:19','569',433351.20,433351.20,'569','2023-01-24 16:46:27','648','2023-01-26 07:04:42',10,0),('1','161',258071,'MORNING SHIFT','2023-02-05','2023-02-06 17:12:49','2023-02-07 17:12:49','569',0.00,0.00,'569','2023-02-06 17:16:43','648','2023-02-06 17:53:16',10,0),('1','161',258072,'MORNING SHIFT','2023-02-06','2023-02-06 20:18:49','2023-02-07 20:18:49','569',2848349.95,2848349.95,'569','2023-02-06 21:30:13','648','2023-02-07 14:04:53',10,0),('1','161',258073,'MORNING SHIFT','2023-02-07','2023-02-07 15:29:22','2023-02-08 15:29:22','569',3119157.00,3119157.00,'569','2023-02-07 15:49:18','648','2023-02-08 08:06:15',10,0),('1','161',258074,'AFTERNOON SHIFT','2023-02-07','2023-02-08 09:41:14','2023-02-09 09:41:14','569',4795755.65,4795755.65,'569','2023-02-08 09:54:13','648','2023-02-08 10:23:38',10,0),('1','161',258075,'MORNING SHIFT','2023-02-08','2023-02-08 20:29:15','2023-02-09 20:29:15','569',2263802.70,2263802.70,'569','2023-02-08 20:36:08','648','2023-02-08 21:07:08',10,0),('1','161',258076,'AFTERNOON SHIFT','2023-02-08','2023-02-08 21:12:01','2023-02-09 21:12:01','569',3297513.15,3297513.15,'569','2023-02-08 21:16:04','648','2023-02-08 21:32:02',10,0),('1','161',258077,'MORNING SHIFT','2023-02-09','2023-02-09 13:52:51','2023-02-10 13:52:51','569',5274883.70,5274883.70,'569','2023-02-09 14:07:05','648','2023-02-09 15:34:37',10,0),('1','161',258078,'AFTERNOON SHIFT','2023-02-09','2023-02-09 17:29:31','2023-02-10 17:29:31','569',1883121.80,1883121.80,'569','2023-02-09 17:36:18','648','2023-02-09 23:33:27',10,0),('1','161',258079,'MORNING SHIFT','2023-02-10','2023-02-10 14:59:36','2023-02-11 14:59:36','569',2305138.90,2305138.90,'569','2023-02-10 15:12:57','648','2023-02-11 06:36:34',10,0),('1','161',258080,'MORNING SHIFT','2023-02-15','2023-02-15 16:39:51','2023-02-16 16:39:51','569',259948.20,259948.20,'569','2023-02-15 16:41:06','648','2023-02-19 06:41:12',10,0),('1','161',258081,'MORNING SHIFT','2023-02-27','2023-02-28 00:39:37','2023-03-01 00:39:37','569',5225343.90,5225343.90,'569','2023-02-28 00:51:58','648','2023-03-01 07:35:49',10,0),('1','161',258082,'MORNING SHIFT','2023-02-28','2023-03-01 13:19:15','2023-03-02 13:19:15','569',2295239.10,2295239.10,'569','2023-03-01 14:20:20','648','2023-03-01 14:43:36',10,0),('1','161',258083,'MORNING SHIFT','2023-03-01','2023-03-02 05:35:49','2023-03-03 05:35:49','569',2626211.95,2626211.95,'569','2023-03-02 06:56:37','648','2023-03-02 10:05:36',10,0),('1','161',258084,'MORNING SHIFT','2023-03-02','2023-03-02 11:12:55','2023-03-03 11:12:55','569',4513722.55,4513722.55,'569','2023-03-02 13:46:14','648','2023-03-02 23:11:48',10,0),('1','161',258085,'AFTERNOON SHIFT','2023-03-02','2023-03-03 19:50:32','2023-03-04 19:50:32','569',1815339.75,1815339.75,'569','2023-03-03 20:07:19','648','2023-03-03 21:04:03',10,0),('1','161',258086,'MORNING SHIFT','2023-03-03','2023-03-03 21:04:32','2023-03-04 21:04:32','569',4703327.60,4703327.60,'569','2023-03-03 21:11:05','648','2023-03-04 06:36:13',10,0),('1','161',258087,'MORNING SHIFT','2023-03-04','2023-03-04 14:26:18','2023-03-05 14:26:18','569',6016387.75,6016387.75,'569','2023-03-05 13:55:38','648','2023-03-05 14:26:05',10,0),('1','161',258088,'MORNING SHIFT','2023-03-05','2023-03-05 14:30:28','2023-03-06 14:30:28','569',0.00,0.00,'569','2023-03-05 14:39:20','648','2023-03-05 14:42:13',10,0),('1','161',258089,'MORNING SHIFT','2023-03-05','2023-03-05 14:45:08','2023-03-06 14:45:08','569',0.00,0.00,'569','2023-03-05 14:49:31','648','2023-03-05 14:55:59',10,0),('1','161',258090,'MORNING SHIFT','2023-03-05','2023-03-05 14:57:20','2023-03-06 14:57:20','569',0.00,0.00,'569','2023-03-05 15:01:06','648','2023-03-05 15:18:53',10,0),('1','161',258091,'AFTERNOON SHIFT','2023-03-05','2023-03-05 15:30:01','2023-03-06 15:30:01','569',3462513.50,3462513.50,'569','2023-03-05 16:56:54','648','2023-03-05 17:02:58',10,0),('1','161',258092,'MORNING SHIFT','2023-03-06','2023-03-06 21:00:40','2023-03-07 21:00:40','569',6184549.05,6184549.05,'569','2023-03-06 21:07:10','648','2023-03-06 23:03:02',10,0),('1','161',258093,'MORNING SHIFT','2023-03-07','2023-03-07 14:31:57','2023-03-08 14:31:57','569',2633776.60,2633776.60,'569','2023-03-07 15:18:30','648','2023-03-08 10:15:16',10,0),('1','161',258094,'AFTERNOON SHIFT','2023-03-07','2023-03-08 10:28:37','2023-03-09 10:28:37','569',1585817.60,1585817.60,'569','2023-03-08 11:35:38','648','2023-03-08 15:00:27',10,0),('1','161',258095,'AFTERNOON SHIFT','2023-03-07','2023-03-08 15:06:28','2023-03-09 15:06:28','569',0.00,0.00,'569','2023-03-08 15:10:49','648','2023-03-08 15:16:08',10,0),('1','161',258096,'AFTERNOON SHIFT','2023-03-07','2023-03-08 15:36:44','2023-03-09 15:36:44','569',0.00,0.00,'569','2023-03-08 15:39:27','648','2023-03-08 15:50:40',10,0),('1','161',258097,'AFTERNOON SHIFT','2023-03-07','2023-03-08 16:03:03','2023-03-09 16:03:03','569',0.00,0.00,'569','2023-03-08 16:09:16','648','2023-03-08 16:17:28',10,0),('1','161',258098,'MORNING SHIFT','2023-03-08','2023-03-08 16:50:26','2023-03-09 16:50:26','569',3723716.00,3723716.00,'569','2023-03-08 18:32:49','648','2023-03-08 21:18:51',10,0),('1','161',258099,'AFTERNOON SHIFT','2023-03-08','2023-03-08 21:31:16','2023-03-09 21:31:16','569',3929256.40,3929256.40,'569','2023-03-08 21:37:29','648','2023-03-09 12:02:08',10,0),('1','161',258100,'MORNING SHIFT','2023-03-09','2023-03-09 14:11:06','2023-03-10 14:11:06','569',8238317.45,8238317.45,'569','2023-03-09 21:12:32','648','2023-03-10 09:21:23',10,0),('1','161',258101,'MORNING SHIFT','2023-03-10','2023-03-10 22:19:06','2023-03-11 22:19:06','569',9014865.55,9014865.55,'569','2023-03-11 10:18:11','648','2023-03-11 10:20:06',10,0),('1','161',258102,'MORNING SHIFT','2023-03-11','2023-03-11 21:55:51','2023-03-12 21:55:51','569',7190473.60,7190473.60,'569','2023-03-11 22:02:43','648','2023-03-12 06:45:42',10,0),('1','161',258103,'MORNING SHIFT','2023-03-12','2023-03-12 18:24:33','2023-03-13 18:24:33','569',3385177.35,3385177.35,'569','2023-03-12 22:19:08','648','2023-03-13 06:56:50',10,0),('1','161',258104,'AFTERNOON SHIFT','2023-03-12','2023-03-13 07:13:16','2023-03-14 07:13:16','569',0.00,0.00,'569','2023-03-13 07:17:10','648','2023-03-13 07:19:45',10,0),('1','161',258105,'AFTERNOON SHIFT','2023-03-12','2023-03-13 07:22:04','2023-03-14 07:22:04','569',0.00,0.00,'569','2023-03-13 07:25:49','648','2023-03-13 07:27:47',10,0),('1','161',258106,'AFTERNOON SHIFT','2023-03-12','2023-03-13 07:30:12','2023-03-14 07:30:12','569',0.00,0.00,'569','2023-03-13 07:34:55','648','2023-03-13 07:36:02',10,0),('1','161',258107,'MORNING SHIFT','2023-03-13','2023-03-13 22:16:50','2023-03-14 22:16:50','569',9601897.90,9601897.90,'569','2023-03-13 22:21:10','648','2023-03-14 08:25:59',10,0),('1','161',258108,'MORNING SHIFT','2023-03-14','2023-03-14 21:32:43','2023-03-15 21:32:43','569',8023616.75,8023616.75,'569','2023-03-14 21:39:08','648','2023-03-15 06:55:19',10,0),('1','161',258109,'AFTERNOON SHIFT','2023-03-14','2023-03-15 09:31:18','2023-03-16 09:31:18','569',0.00,0.00,'569','2023-03-15 09:33:20','648','2023-03-15 12:09:28',10,0),('1','161',258110,'MORNING SHIFT','2023-03-15','2023-03-16 06:04:08','2023-03-17 06:04:08','569',10336768.75,10336768.75,'569','2023-03-16 06:13:08','648','2023-03-16 09:06:17',10,0),('1','161',258111,'MORNING SHIFT','2023-03-16','2023-03-16 23:23:51','2023-03-17 23:23:51','569',9281181.65,9281181.65,'569','2023-03-17 11:37:56','648','2023-03-17 21:29:15',10,0),('1','161',258112,'MORNING SHIFT','2023-03-17','2023-03-17 21:38:54','2023-03-18 21:38:54','569',6034891.65,6034891.65,'569','2023-03-17 21:46:07','648','2023-03-17 22:05:54',10,0),('1','161',258113,'MORNING SHIFT','2023-03-20','2023-03-20 17:48:13','2023-03-21 17:48:13','569',4729070.25,4729070.25,'569','2023-03-20 20:02:05','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4915760 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','161','861','176130',3463729,'2496','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463730,'2497','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463731,'2498','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463732,'2499','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463733,'2500','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463734,'2501','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463735,'2502','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463736,'2503','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463737,'2504','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176130',3463738,'2505','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463739,'2506','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463740,'2507','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463741,'2508','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463742,'2509','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463743,'2510','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463744,'2511','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463745,'2512','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176130',3463746,'2513','379',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176130',3463747,'2514','380',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176130',3463748,'2515','380',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469776,'2496','379',785.01,3027.09,2242.08,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469777,'2497','379',634.87,634.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469778,'2498','379',594.41,2652.88,2058.47,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469779,'2499','379',650.05,2462.28,1812.23,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469780,'2500','379',571.59,1676.93,1105.34,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469781,'2501','379',714.02,1536.65,822.63,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469782,'2502','379',618.03,1207.59,589.56,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469783,'2503','379',804.67,876.19,71.52,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469784,'2504','379',738.19,1405.00,666.81,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176464',3469785,'2505','379',642.13,2108.70,1466.57,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469786,'2506','379',650.94,3037.22,2386.28,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469787,'2507','379',716.07,2275.54,1559.47,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469788,'2508','379',659.04,2460.45,1801.41,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469789,'2509','379',612.80,1516.73,903.93,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469790,'2510','379',622.63,3575.11,2952.48,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469791,'2511','379',668.17,668.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469792,'2512','379',631.48,1523.49,892.01,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176464',3469793,'2513','379',571.83,1893.90,1322.07,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176464',3469794,'2514','380',663.27,663.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176464',3469795,'2515','380',648.91,648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471335,'2496','379',3027.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471336,'2497','379',634.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471337,'2498','379',2652.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471338,'2499','379',2462.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471339,'2500','379',1676.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471340,'2501','379',1536.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471341,'2502','379',1207.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471342,'2503','379',876.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471343,'2504','379',1405.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176535',3471344,'2505','379',2108.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471345,'2506','379',3037.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471346,'2507','379',2275.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471347,'2508','379',2460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471348,'2509','379',1516.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471349,'2510','379',3575.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471350,'2511','379',668.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471351,'2512','379',1523.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176535',3471352,'2513','379',1893.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176535',3471353,'2514','380',663.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176535',3471354,'2515','380',648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176537',3471357,'2496','379',3027.09,3525.49,478.40,77979.20,0.00,0.00,20.00,0.00,0.00),('1','161','861','176537',3471358,'2497','379',634.87,1161.30,516.43,84178.09,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471359,'2498','379',2652.88,4262.35,1589.47,259083.61,0.00,0.00,20.00,0.00,0.00),('1','161','861','176537',3471360,'2499','379',2462.28,3610.97,1138.69,185606.47,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471361,'2500','379',1676.93,2551.84,864.91,140980.33,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471362,'2501','379',1536.65,1750.02,203.37,33149.31,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471363,'2502','379',1207.59,1647.00,429.41,69993.83,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471364,'2503','379',876.19,1403.43,517.24,84310.12,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471365,'2504','379',1405.00,1646.81,231.81,37785.03,0.00,0.00,10.00,0.00,0.00),('1','161','861','176537',3471366,'2505','379',2108.70,3086.20,967.50,157702.50,0.00,0.00,10.00,0.00,0.00),('1','161','862','176537',3471367,'2506','379',3037.22,4832.05,1784.83,290927.29,0.00,0.00,10.00,0.00,0.00),('1','161','862','176537',3471368,'2507','379',2275.54,3460.95,1175.41,191591.83,0.00,0.00,10.00,0.00,0.00),('1','161','862','176537',3471369,'2508','379',2460.45,3596.44,1105.99,180276.37,0.00,0.00,30.00,0.00,0.00),('1','161','862','176537',3471370,'2509','379',1516.73,2412.97,866.24,141197.12,0.00,0.00,30.00,0.00,0.00),('1','161','862','176537',3471371,'2510','379',3575.11,4325.03,719.92,117346.96,0.00,0.00,30.00,0.00,0.00),('1','161','862','176537',3471372,'2511','379',668.17,1197.45,509.28,83012.64,0.00,0.00,20.00,0.00,0.00),('1','161','862','176537',3471373,'2512','379',1523.49,2097.90,544.41,88738.83,0.00,0.00,30.00,0.00,0.00),('1','161','862','176537',3471374,'2513','379',1893.90,2442.62,538.72,87811.36,0.00,0.00,10.00,0.00,0.00),('1','161','863','176537',3471375,'2514','380',663.27,663.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176537',3471376,'2515','380',648.91,648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471470,'2496','379',3525.49,4058.12,532.63,86818.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471471,'2497','379',1161.30,1872.16,710.86,115870.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471472,'2498','379',4262.35,6406.22,2143.87,349450.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471473,'2499','379',3610.97,4966.24,1355.27,220909.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471474,'2500','379',2551.84,3514.16,962.32,156858.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471475,'2501','379',1750.02,2042.20,292.18,47625.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471476,'2502','379',1647.00,2394.91,747.91,121909.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471477,'2503','379',1403.43,1690.90,287.47,46857.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471478,'2504','379',1646.81,1859.41,212.60,34653.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176543',3471479,'2505','379',3086.20,4121.20,1035.00,168705.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471480,'2506','379',4832.05,6652.17,1820.12,296679.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471481,'2507','379',3460.95,4298.55,837.60,136528.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471482,'2508','379',3596.44,4594.59,998.15,162698.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471483,'2509','379',2412.97,3341.88,928.91,151412.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471484,'2510','379',4325.03,5367.28,1042.25,169886.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471485,'2511','379',1197.45,1772.27,574.82,93695.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471486,'2512','379',2097.90,3054.45,956.55,155917.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','176543',3471487,'2513','379',2442.62,3203.97,631.35,102910.05,0.00,0.00,130.00,0.00,0.00),('1','161','863','176543',3471488,'2514','380',663.27,663.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176543',3471489,'2515','380',648.91,648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471524,'2496','379',4058.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471525,'2497','379',1872.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471526,'2498','379',6406.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471527,'2499','379',4966.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471528,'2500','379',3514.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471529,'2501','379',2042.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471530,'2502','379',2394.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471531,'2503','379',1690.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471532,'2504','379',1859.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176545',3471533,'2505','379',4121.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471534,'2506','379',6652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471535,'2507','379',4298.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471536,'2508','379',4594.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471537,'2509','379',3341.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471538,'2510','379',5367.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471539,'2511','379',1772.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471540,'2512','379',3054.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176545',3471541,'2513','379',3203.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176545',3471542,'2514','380',663.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176545',3471543,'2515','380',648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471561,'2496','379',4058.12,4950.79,892.67,145505.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471562,'2497','379',1872.16,2580.63,635.23,103542.49,0.00,0.00,73.24,0.00,0.00),('1','161','861','176548',3471563,'2498','379',6406.22,7461.42,1055.20,171997.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471564,'2499','379',4966.24,6327.68,1361.44,221914.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471565,'2500','379',3514.16,5395.32,1881.16,306629.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471566,'2501','379',2042.20,2516.43,474.23,77299.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471567,'2502','379',2394.91,2864.79,469.88,76590.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471568,'2503','379',1690.90,1902.63,211.73,34511.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471569,'2504','379',1859.41,2141.80,282.39,46029.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','176548',3471570,'2505','379',4121.20,5127.54,1006.34,164033.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471571,'2506','379',6652.17,8173.58,1521.41,247989.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471572,'2507','379',4298.55,5845.95,1547.40,252226.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471573,'2508','379',4594.59,5195.80,601.21,97997.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471574,'2509','379',3341.88,4084.81,742.93,121097.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471575,'2510','379',5367.28,6531.48,1164.20,189764.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471576,'2511','379',1772.27,2595.56,823.29,134196.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471577,'2512','379',3054.45,3661.77,607.32,98993.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','176548',3471578,'2513','379',3203.97,3697.94,493.97,80517.11,0.00,0.00,0.00,0.00,0.00),('1','161','863','176548',3471579,'2514','380',663.27,914.27,251.00,45180.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176548',3471580,'2515','380',648.91,658.91,10.00,1800.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471581,'2496','379',4950.79,5577.93,627.14,102223.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471582,'2497','379',2580.63,2982.92,402.29,65573.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471583,'2498','379',7461.42,7926.04,464.62,75733.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471584,'2499','379',6327.68,7353.48,1025.80,167205.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471585,'2500','379',5395.32,6276.82,881.50,143684.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471586,'2501','379',2516.43,2760.96,244.53,39858.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471587,'2502','379',2864.79,3227.59,362.80,59136.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471588,'2503','379',1902.63,2005.07,102.44,16697.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471589,'2504','379',2141.80,2326.39,184.59,30088.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','176549',3471590,'2505','379',5127.54,5878.74,751.20,122445.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471591,'2506','379',8173.58,9241.94,1068.36,174142.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471592,'2507','379',5845.95,6988.04,1142.09,186160.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471593,'2508','379',5195.80,5406.25,210.45,34303.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471594,'2509','379',4084.81,4775.50,690.69,112582.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471595,'2510','379',6531.48,8192.96,1661.48,270821.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471596,'2511','379',2595.56,3910.03,1314.47,214258.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471597,'2512','379',3661.77,4113.12,451.35,73570.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','176549',3471598,'2513','379',3697.94,3987.67,289.73,47225.99,0.00,0.00,0.00,0.00,0.00),('1','161','863','176549',3471599,'2514','380',914.27,915.95,1.68,302.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','176549',3471600,'2515','380',658.91,658.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472827,'2496','379',5577.93,6020.58,442.65,72151.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472828,'2497','379',2982.92,3391.34,408.42,66572.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472829,'2498','379',7926.04,9222.61,1296.57,211340.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472830,'2499','379',7353.48,9239.58,1886.10,307434.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472831,'2500','379',6276.82,7458.66,1181.84,192639.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472832,'2501','379',2760.96,3505.33,744.37,121332.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472833,'2502','379',3227.59,3587.11,359.52,58601.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472834,'2503','379',2005.07,2118.67,113.60,18516.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472835,'2504','379',2326.39,2806.24,479.85,78215.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','176620',3472836,'2505','379',5878.74,6625.61,746.87,121739.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472837,'2506','379',9241.94,10349.37,1107.43,180511.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472838,'2507','379',6988.04,8106.03,1087.99,177342.37,0.00,0.00,30.00,0.00,0.00),('1','161','862','176620',3472839,'2508','379',5406.25,6186.19,779.94,127130.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472840,'2509','379',4775.50,6236.82,1461.32,238195.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472841,'2510','379',8192.96,9461.58,1268.62,206785.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472842,'2511','379',3910.03,4330.42,420.39,68523.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472843,'2512','379',4113.12,4987.27,874.15,142486.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','176620',3472844,'2513','379',3987.67,4315.55,327.88,53444.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','176620',3472845,'2514','380',915.95,1033.73,117.78,21200.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','176620',3472846,'2515','380',658.91,668.91,10.00,1800.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472916,'2496','379',6020.58,6571.04,550.46,89724.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472917,'2497','379',3391.34,3905.29,513.95,83773.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472918,'2498','379',9222.61,9919.96,697.35,113668.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472919,'2499','379',9239.58,10416.71,1177.13,191872.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472920,'2500','379',7458.66,8077.54,618.88,100877.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472921,'2501','379',3505.33,3954.57,449.24,73226.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472922,'2502','379',3587.11,4067.34,480.23,78277.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472923,'2503','379',2118.67,2664.61,515.94,84098.22,0.00,0.00,30.00,0.00,0.00),('1','161','861','176624',3472924,'2504','379',2806.24,3030.75,224.51,36595.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','176624',3472925,'2505','379',6625.61,7311.66,686.05,111826.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472926,'2506','379',10349.37,11526.25,1176.88,191831.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472927,'2507','379',8106.03,9162.43,1056.40,172193.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472928,'2508','379',6186.19,6876.42,690.23,112507.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472929,'2509','379',6236.82,6860.35,623.53,101635.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472930,'2510','379',9461.58,10363.76,902.18,147055.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472931,'2511','379',4330.42,4736.21,405.79,66143.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472932,'2512','379',4987.27,5358.20,370.93,60461.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','176624',3472933,'2513','379',4315.55,4761.24,445.69,72647.47,0.00,0.00,0.00,0.00,0.00),('1','161','863','176624',3472934,'2514','380',1033.73,1078.18,44.45,8001.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176624',3472935,'2515','380',668.91,668.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473100,'2496','379',6571.04,7112.84,541.80,88313.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473101,'2497','379',3905.29,4882.85,977.56,159342.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473102,'2498','379',9919.96,10898.94,978.98,159573.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473103,'2499','379',10416.71,11423.15,1006.44,164049.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473104,'2500','379',8077.54,9085.93,1008.39,164367.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473105,'2501','379',3954.57,4588.73,634.16,103368.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473106,'2502','379',4067.34,4239.15,171.81,28005.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','176632',3473107,'2503','379',2664.61,2825.56,150.95,24604.85,0.00,0.00,10.00,0.00,0.00),('1','161','861','176632',3473108,'2504','379',3030.75,3204.49,163.74,26689.62,0.00,0.00,10.00,0.00,0.00),('1','161','861','176632',3473109,'2505','379',7311.66,8079.49,767.83,125156.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176632',3473110,'2506','379',11526.25,12950.48,1424.23,232149.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','176632',3473111,'2507','379',9162.43,10365.83,1203.40,196154.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','176632',3473112,'2508','379',6876.42,7968.61,1092.19,178026.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','176632',3473113,'2509','379',6860.35,7467.60,607.25,98981.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176632',3473114,'2510','379',10363.76,10813.99,440.23,71757.49,0.00,0.00,10.00,0.00,0.00),('1','161','862','176632',3473115,'2511','379',4736.21,5517.34,751.13,122434.19,0.00,0.00,30.00,0.00,0.00),('1','161','862','176632',3473116,'2512','379',5358.20,5844.96,476.76,77711.88,0.00,0.00,10.00,0.00,0.00),('1','161','862','176632',3473117,'2513','379',4761.24,5222.79,461.55,75232.65,0.00,0.00,0.00,0.00,0.00),('1','161','863','176632',3473118,'2514','380',1078.18,1113.74,35.56,6400.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','176632',3473119,'2515','380',668.91,668.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473144,'2496','379',7112.84,7474.82,361.98,59002.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473145,'2497','379',4882.85,5835.40,952.55,155265.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473146,'2498','379',10898.94,11573.06,674.12,109881.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473147,'2499','379',11423.15,12454.69,1031.54,168141.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473148,'2500','379',9085.93,9515.78,429.85,70065.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473149,'2501','379',4588.73,4994.61,405.88,66158.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473150,'2502','379',4239.15,4239.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473151,'2503','379',2825.56,2977.48,151.92,24762.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473152,'2504','379',3204.49,3330.56,126.07,20549.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','176634',3473153,'2505','379',8079.49,8659.88,580.39,94603.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473154,'2506','379',12950.48,14086.15,1135.67,185114.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473155,'2507','379',10365.83,10808.84,443.01,72210.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473156,'2508','379',7968.61,8825.14,856.53,139614.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473157,'2509','379',7467.60,7980.09,512.49,83535.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473158,'2510','379',10813.99,11347.09,533.10,86895.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473159,'2511','379',5517.34,6140.86,623.52,101633.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473160,'2512','379',5844.96,6051.00,206.04,33584.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','176634',3473161,'2513','379',5222.79,5688.60,465.81,75927.03,0.00,0.00,0.00,0.00,0.00),('1','161','863','176634',3473162,'2514','380',1113.74,1173.61,59.87,10776.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','176634',3473163,'2515','380',668.91,668.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176675',3473784,'2496','379',7474.82,7474.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176675',3473785,'2497','379',5835.40,7012.89,1147.49,187040.87,0.00,0.00,30.00,0.00,0.00),('1','161','861','176675',3473786,'2498','379',11573.06,12923.49,1330.43,216860.09,0.00,0.00,20.00,0.00,0.00),('1','161','861','176675',3473787,'2499','379',12454.69,13695.21,1230.52,200574.76,0.00,0.00,10.00,0.00,0.00),('1','161','861','176675',3473788,'2500','379',9515.78,11002.81,1477.03,240755.89,0.00,0.00,10.00,0.00,0.00),('1','161','861','176675',3473789,'2501','379',4994.61,5014.61,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','176675',3473790,'2502','379',4239.15,5942.34,1673.19,272729.97,0.00,0.00,30.00,0.00,0.00),('1','161','861','176675',3473791,'2503','379',2977.48,3639.25,641.77,104608.51,0.00,0.00,20.00,0.00,0.00),('1','161','861','176675',3473792,'2504','379',3330.56,3340.56,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','161','861','176675',3473793,'2505','379',8659.88,8669.88,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','161','862','176675',3473794,'2506','379',14086.15,15304.79,1208.64,197008.32,0.00,0.00,10.00,0.00,0.00),('1','161','862','176675',3473795,'2507','379',10808.84,11832.43,1013.59,165215.17,0.00,0.00,10.00,0.00,0.00),('1','161','862','176675',3473796,'2508','379',8825.14,9929.15,1064.01,173433.63,0.00,0.00,40.00,0.00,0.00),('1','161','862','176675',3473797,'2509','379',7980.09,8877.31,887.22,144616.86,0.00,0.00,10.00,0.00,0.00),('1','161','862','176675',3473798,'2510','379',11347.09,14382.80,3015.71,491560.73,0.00,0.00,20.00,0.00,0.00),('1','161','862','176675',3473799,'2511','379',6140.86,8648.17,2497.31,407061.53,0.00,0.00,10.00,0.00,0.00),('1','161','862','176675',3473800,'2512','379',6051.00,6081.00,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','161','862','176675',3473801,'2513','379',5688.60,6608.05,909.45,148240.35,0.00,0.00,10.00,0.00,0.00),('1','161','863','176675',3473802,'2514','380',1173.61,1286.39,112.78,20300.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','176675',3473803,'2515','380',668.91,698.91,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','161','861','176683',3473961,'2496','379',7474.82,7474.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473962,'2497','379',7012.89,7842.81,759.92,123866.96,0.00,0.00,70.00,0.00,0.00),('1','161','861','176683',3473963,'2498','379',12923.49,14977.44,2053.95,334793.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473964,'2499','379',13695.21,13706.23,11.02,1796.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473965,'2500','379',11002.81,12184.38,1181.57,192595.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473966,'2501','379',5014.61,5014.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473967,'2502','379',5942.34,6960.79,1018.45,166007.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473968,'2503','379',3639.25,4223.85,584.60,95289.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473969,'2504','379',3340.56,3347.31,6.75,1100.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','176683',3473970,'2505','379',8669.88,9055.89,386.01,62919.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473971,'2506','379',15304.79,17179.91,1875.12,305644.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473972,'2507','379',11832.43,12929.16,1096.73,178766.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473973,'2508','379',9929.15,11456.40,1527.25,248941.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473974,'2509','379',8877.31,9762.50,885.19,144285.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473975,'2510','379',14382.80,15399.00,1016.20,165640.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473976,'2511','379',8648.17,9556.80,908.63,148106.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473977,'2512','379',6081.00,6081.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176683',3473978,'2513','379',6608.05,7568.05,960.00,156480.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176683',3473979,'2514','380',1286.39,1286.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176683',3473980,'2515','380',698.91,810.04,111.13,20003.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474631,'2496','379',7474.82,7474.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474632,'2497','379',7842.81,8851.67,1008.86,164444.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474633,'2498','379',14977.44,15011.79,34.35,5599.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474634,'2499','379',13706.23,15503.54,1797.31,292961.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474635,'2500','379',12184.38,13869.90,1685.52,274739.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474636,'2501','379',5014.61,5014.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474637,'2502','379',6960.79,7943.78,982.99,160227.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474638,'2503','379',4223.85,4223.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474639,'2504','379',3347.31,4066.59,719.28,117242.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','176721',3474640,'2505','379',9055.89,9055.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474641,'2506','379',17179.91,19308.24,2128.33,346917.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474642,'2507','379',12929.16,14262.90,1333.74,217399.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474643,'2508','379',11456.40,12304.32,847.92,138210.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474644,'2509','379',9762.50,10444.12,681.62,111104.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474645,'2510','379',15399.00,16303.50,904.50,147433.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474646,'2511','379',9556.80,10359.23,802.43,130796.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474647,'2512','379',6081.00,6081.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176721',3474648,'2513','379',7568.05,8367.69,799.64,130341.32,0.00,0.00,0.00,0.00,0.00),('1','161','863','176721',3474649,'2514','380',1286.39,1286.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176721',3474650,'2515','380',810.04,820.04,10.00,1800.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474679,'2496','379',7474.82,7474.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474680,'2497','379',8851.67,10053.65,1201.98,195922.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474681,'2498','379',15011.79,16275.91,1264.12,206051.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474682,'2499','379',15503.54,16887.38,1383.84,225565.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474683,'2500','379',13869.90,15535.95,1666.05,271566.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474684,'2501','379',5014.61,5014.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474685,'2502','379',7943.78,8835.57,891.79,145361.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474686,'2503','379',4223.85,4223.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474687,'2504','379',4066.59,4755.55,688.96,112300.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','176724',3474688,'2505','379',9055.89,9055.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474689,'2506','379',19308.24,20373.05,1064.81,173564.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474690,'2507','379',14262.90,15523.01,1260.11,205397.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474691,'2508','379',12304.32,13443.05,1138.73,185612.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474692,'2509','379',10444.12,11344.01,899.89,146682.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474693,'2510','379',16303.50,16303.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474694,'2511','379',10359.23,11703.58,1344.35,219129.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474695,'2512','379',6081.00,6081.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176724',3474696,'2513','379',8367.69,9016.57,648.88,105767.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','176724',3474697,'2514','380',1286.39,1306.39,20.00,3600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176724',3474698,'2515','380',820.04,820.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474730,'2496','379',7474.82,8085.02,610.20,99462.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474731,'2497','379',10053.65,10672.70,619.05,100905.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474732,'2498','379',16275.91,17312.18,1036.27,168912.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474733,'2499','379',16887.38,18037.10,1149.72,187404.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474734,'2500','379',15535.95,16679.88,1143.93,186460.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474735,'2501','379',5014.61,5883.61,869.00,141647.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474736,'2502','379',8835.57,8843.55,7.98,1300.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474737,'2503','379',4223.85,4616.41,392.56,63987.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474738,'2504','379',4755.55,4755.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176727',3474739,'2505','379',9055.89,9918.78,862.89,140651.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474740,'2506','379',20373.05,21452.22,1079.17,175904.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474741,'2507','379',15523.01,16289.17,766.16,124884.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474742,'2508','379',13443.05,15096.64,1653.59,269535.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474743,'2509','379',11344.01,12156.28,812.27,132400.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474744,'2510','379',16303.50,17424.23,1110.73,181048.99,0.00,0.00,10.00,0.00,0.00),('1','161','862','176727',3474745,'2511','379',11703.58,11703.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474746,'2512','379',6081.00,6574.39,493.39,80422.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176727',3474747,'2513','379',9016.57,9817.43,800.86,130540.18,0.00,0.00,0.00,0.00,0.00),('1','161','863','176727',3474748,'2514','380',1306.39,1416.39,110.00,19800.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176727',3474749,'2515','380',820.04,820.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474814,'2496','379',8085.02,9061.48,976.46,159162.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474815,'2497','379',10672.70,11336.38,663.68,108179.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474816,'2498','379',17312.18,18357.77,1045.59,170431.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474817,'2499','379',18037.10,19412.18,1375.08,224138.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474818,'2500','379',16679.88,17485.72,805.84,131351.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474819,'2501','379',5883.61,5883.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474820,'2502','379',8843.55,9762.04,918.49,149713.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474821,'2503','379',4616.41,4616.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474822,'2504','379',4755.55,5484.07,728.52,118748.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','176731',3474823,'2505','379',9918.78,10461.09,542.31,88396.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474824,'2506','379',21452.22,23216.14,1763.92,287518.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474825,'2507','379',16289.17,16292.87,3.70,603.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474826,'2508','379',15096.64,16493.00,1396.36,227606.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474827,'2509','379',12156.28,13115.11,958.83,156289.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474828,'2510','379',17424.23,18465.10,1040.87,169661.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474829,'2511','379',11703.58,12595.34,891.76,145356.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474830,'2512','379',6574.39,8153.01,1578.62,257315.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','176731',3474831,'2513','379',9817.43,9817.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176731',3474832,'2514','380',1416.39,1416.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176731',3474833,'2515','380',820.04,900.05,80.01,14401.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474865,'2496','379',9061.48,9061.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474866,'2497','379',11336.38,12432.52,1096.14,178670.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474867,'2498','379',18357.77,19354.82,997.05,162519.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474868,'2499','379',19412.18,21180.47,1768.29,288231.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474869,'2500','379',17485.72,18847.82,1362.10,222022.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474870,'2501','379',5883.61,5883.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474871,'2502','379',9762.04,10262.77,500.73,81618.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474872,'2503','379',4616.41,5028.02,411.61,67092.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474873,'2504','379',5484.07,5484.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176734',3474874,'2505','379',10461.09,11377.27,916.18,149337.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474875,'2506','379',23216.14,24250.57,1034.43,168612.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474876,'2507','379',16292.87,19124.70,2831.83,461588.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474877,'2508','379',16493.00,17468.35,975.35,158982.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474878,'2509','379',13115.11,13943.38,828.27,135008.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474879,'2510','379',18465.10,19239.63,774.53,126248.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474880,'2511','379',12595.34,13418.93,823.59,134245.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474881,'2512','379',8153.01,8731.60,578.59,94310.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','176734',3474882,'2513','379',9817.43,10623.62,806.19,131408.97,0.00,0.00,0.00,0.00,0.00),('1','161','863','176734',3474883,'2514','380',1416.39,1416.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176734',3474884,'2515','380',900.05,900.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474885,'2496','379',9061.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474886,'2497','379',12432.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474887,'2498','379',19354.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474888,'2499','379',21180.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474889,'2500','379',18847.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474890,'2501','379',5883.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474891,'2502','379',10262.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474892,'2503','379',5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474893,'2504','379',5484.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176735',3474894,'2505','379',11377.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474895,'2506','379',24250.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474896,'2507','379',19124.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474897,'2508','379',17468.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474898,'2509','379',13943.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474899,'2510','379',19239.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474900,'2511','379',13418.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474901,'2512','379',8731.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176735',3474902,'2513','379',10623.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176735',3474903,'2514','380',1416.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176735',3474904,'2515','380',900.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474905,'2496','379',9061.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474906,'2497','379',12432.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474907,'2498','379',19354.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474908,'2499','379',21180.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474909,'2500','379',18847.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474910,'2501','379',5883.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474911,'2502','379',10262.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474912,'2503','379',5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474913,'2504','379',5484.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176736',3474914,'2505','379',11377.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474915,'2506','379',24250.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474916,'2507','379',19124.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474917,'2508','379',17468.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474918,'2509','379',13943.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474919,'2510','379',19239.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474920,'2511','379',13418.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474921,'2512','379',8731.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176736',3474922,'2513','379',10623.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176736',3474923,'2514','380',1416.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176736',3474924,'2515','380',900.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475001,'2496','379',9061.48,9904.04,842.56,137337.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475002,'2497','379',12432.52,12890.18,457.66,74598.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475003,'2498','379',19354.82,20687.31,1332.49,217195.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475004,'2499','379',21180.47,22598.24,1417.77,231096.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475005,'2500','379',18847.82,18872.96,25.14,4097.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475006,'2501','379',5883.61,6312.10,428.49,69843.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475007,'2502','379',10262.77,10788.14,525.37,85635.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475008,'2503','379',5028.02,5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475009,'2504','379',5484.07,6213.68,729.61,118926.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','176740',3475010,'2505','379',11377.27,13184.53,1807.26,294583.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475011,'2506','379',24250.57,25750.28,1499.71,244452.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475012,'2507','379',19124.70,20391.52,1266.82,206491.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475013,'2508','379',17468.35,18904.60,1436.25,234108.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475014,'2509','379',13943.38,15112.66,1169.28,190592.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475015,'2510','379',19239.63,20531.13,1291.50,210514.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475016,'2511','379',13418.93,14608.94,1190.01,193971.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','176740',3475017,'2512','379',8731.60,8801.55,49.95,8141.85,0.00,0.00,20.00,0.00,0.00),('1','161','862','176740',3475018,'2513','379',10623.62,11352.07,728.45,118737.35,0.00,0.00,0.00,0.00,0.00),('1','161','863','176740',3475019,'2514','380',1416.39,1720.40,304.01,56241.85,0.00,0.00,0.00,0.00,0.00),('1','161','863','176740',3475020,'2515','380',900.05,900.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475391,'2496','379',9904.04,11345.82,1441.78,235010.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475392,'2497','379',12890.18,12915.04,24.86,4052.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475393,'2498','379',20687.31,21734.85,1047.54,170749.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475394,'2499','379',22598.24,23763.14,1164.90,189878.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475395,'2500','379',18872.96,19899.09,1026.13,167259.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475396,'2501','379',6312.10,6807.52,495.42,80753.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475397,'2502','379',10788.14,11424.09,635.95,103659.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475398,'2503','379',5028.02,5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475399,'2504','379',6213.68,6888.16,674.48,109940.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','176759',3475400,'2505','379',13184.53,14191.28,1006.75,164100.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475401,'2506','379',25750.28,26896.16,1145.88,186778.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475402,'2507','379',20391.52,21972.65,1581.13,257724.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475403,'2508','379',18904.60,19761.50,856.90,139674.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475404,'2509','379',15112.66,15903.37,790.71,128885.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475405,'2510','379',20531.13,21517.31,986.18,160747.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475406,'2511','379',14608.94,15286.77,677.83,110486.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475407,'2512','379',8801.55,8801.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176759',3475408,'2513','379',11352.07,12002.25,650.18,105979.34,0.00,0.00,0.00,0.00,0.00),('1','161','863','176759',3475409,'2514','380',1720.40,1720.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176759',3475410,'2515','380',900.05,1054.38,154.33,28551.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475464,'2496','379',11345.82,11345.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475465,'2497','379',12915.04,14366.83,1451.79,236641.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475466,'2498','379',21734.85,22946.83,1211.98,197552.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475467,'2499','379',23763.14,25417.18,1654.04,269608.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475468,'2500','379',19899.09,20950.17,1051.08,171326.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475469,'2501','379',6807.52,6807.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475470,'2502','379',11424.09,12438.97,1014.88,165425.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475471,'2503','379',5028.02,5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176766',3475472,'2504','379',6888.16,7481.18,573.02,93402.26,0.00,0.00,20.00,0.00,0.00),('1','161','861','176766',3475473,'2505','379',14191.28,15409.98,1218.70,198648.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475474,'2506','379',26896.16,28624.84,1728.68,281774.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475475,'2507','379',21972.65,23463.10,1490.45,242943.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475476,'2508','379',19761.50,21025.02,1263.52,205953.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475477,'2509','379',15903.37,16487.46,584.09,95206.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475478,'2510','379',21517.31,22943.56,1426.25,232478.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475479,'2511','379',15286.77,16223.99,937.22,152766.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475480,'2512','379',8801.55,9308.75,507.20,82673.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176766',3475481,'2513','379',12002.25,12522.84,520.59,84856.17,0.00,0.00,0.00,0.00,0.00),('1','161','863','176766',3475482,'2514','380',1720.40,2440.40,720.00,133200.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176766',3475483,'2515','380',1054.38,1054.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475484,'2496','379',11345.82,11714.09,368.27,60028.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475485,'2497','379',14366.83,14849.99,483.16,78755.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475486,'2498','379',22946.83,23982.07,1035.24,168743.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475487,'2499','379',25417.18,26198.49,781.31,127353.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475488,'2500','379',20950.17,21531.03,580.86,94680.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475489,'2501','379',6807.52,7440.28,632.76,103139.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475490,'2502','379',12438.97,12438.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475491,'2503','379',5028.02,5028.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475492,'2504','379',7481.18,7707.99,226.81,36970.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','176767',3475493,'2505','379',15409.98,16080.80,670.82,109343.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475494,'2506','379',28624.84,29844.85,1220.01,198861.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475495,'2507','379',23463.10,24151.83,688.73,112262.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475496,'2508','379',21025.02,21774.94,749.92,122236.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475497,'2509','379',16487.46,17581.50,1094.04,178328.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475498,'2510','379',22943.56,24027.05,1083.49,176608.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475499,'2511','379',16223.99,16693.38,469.39,76510.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475500,'2512','379',9308.75,9308.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176767',3475501,'2513','379',12522.84,13216.06,693.22,112994.86,0.00,0.00,0.00,0.00,0.00),('1','161','863','176767',3475502,'2514','380',2440.40,2440.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176767',3475503,'2515','380',1054.38,1185.74,131.36,24301.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475504,'2496','379',11714.09,12179.33,465.24,75834.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475505,'2497','379',14849.99,15483.22,633.23,103216.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475506,'2498','379',23982.07,25255.95,1273.88,207642.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475507,'2499','379',26198.49,27875.25,1676.76,273311.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475508,'2500','379',21531.03,22813.40,1282.37,209026.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475509,'2501','379',7440.28,7440.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475510,'2502','379',12438.97,13226.86,787.89,128426.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475511,'2503','379',5028.02,5504.88,476.86,77728.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475512,'2504','379',7707.99,7708.09,0.10,16.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','176768',3475513,'2505','379',16080.80,17438.88,1358.08,221367.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475514,'2506','379',29844.85,31160.28,1315.43,214415.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475515,'2507','379',24151.83,25579.77,1427.94,232754.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475516,'2508','379',21774.94,23090.80,1315.86,214485.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475517,'2509','379',17581.50,18618.20,1036.70,168982.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475518,'2510','379',24027.05,25271.84,1244.79,202900.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475519,'2511','379',16693.38,17230.67,537.29,87578.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475520,'2512','379',9308.75,10358.24,1049.49,171066.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176768',3475521,'2513','379',13216.06,13216.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176768',3475522,'2514','380',2440.40,3302.56,862.16,159499.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','176768',3475523,'2515','380',1185.74,1185.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475550,'2496','379',12179.33,12884.84,705.51,114998.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475551,'2497','379',15483.22,16179.54,696.32,113500.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475552,'2498','379',25255.95,26241.78,985.83,160690.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475553,'2499','379',27875.25,28763.67,888.42,144812.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475554,'2500','379',22813.40,23522.48,709.08,115580.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475555,'2501','379',7440.28,7440.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475556,'2502','379',13226.86,13747.19,520.33,84813.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475557,'2503','379',5504.88,5859.44,354.56,57793.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475558,'2504','379',7708.09,7708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176770',3475559,'2505','379',17438.88,19120.51,1681.63,274105.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475560,'2506','379',31160.28,32355.43,1176.15,191712.45,0.00,0.00,19.00,0.00,0.00),('1','161','862','176770',3475561,'2507','379',25579.77,26822.05,1242.28,202491.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475562,'2508','379',23090.80,23750.83,660.03,107584.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475563,'2509','379',18618.20,19317.29,699.09,113951.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475564,'2510','379',25271.84,25933.84,662.00,107906.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475565,'2511','379',17230.67,17814.34,583.67,95138.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475566,'2512','379',10358.24,10358.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176770',3475567,'2513','379',13216.06,13904.26,688.20,112176.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','176770',3475568,'2514','380',3302.56,3302.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176770',3475569,'2515','380',1185.74,1438.96,253.22,46845.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475570,'2496','379',12884.84,12884.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475571,'2497','379',16179.54,17477.17,1297.63,211513.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475572,'2498','379',26241.78,27415.16,1173.38,191260.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475573,'2499','379',28763.67,30034.10,1270.43,207080.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475574,'2500','379',23522.48,25034.49,1512.01,246457.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475575,'2501','379',7440.28,8087.54,647.26,105503.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475576,'2502','379',13747.19,14140.00,392.81,64028.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475577,'2503','379',5859.44,5859.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475578,'2504','379',7708.09,8466.04,757.95,123545.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','176771',3475579,'2505','379',19120.51,19963.84,843.33,137462.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475580,'2506','379',32355.43,33994.53,1639.10,267173.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475581,'2507','379',26822.05,28117.70,1295.65,211190.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475582,'2508','379',23750.83,24948.33,1197.50,195192.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475583,'2509','379',19317.29,20242.43,925.14,150797.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475584,'2510','379',25933.84,27097.58,1163.74,189689.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475585,'2511','379',17814.34,18749.58,935.24,152444.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475586,'2512','379',10358.24,11456.87,1098.63,179076.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','176771',3475587,'2513','379',13904.26,13904.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176771',3475588,'2514','380',3302.56,3329.59,27.03,5000.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','176771',3475589,'2515','380',1438.96,1438.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475590,'2496','379',12884.84,13762.37,877.53,143037.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475591,'2497','379',17477.17,18217.43,740.26,120662.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475592,'2498','379',27415.16,28626.43,1211.27,197437.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475593,'2499','379',30034.10,31410.40,1376.30,224336.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475594,'2500','379',25034.49,26051.85,1017.36,165829.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475595,'2501','379',8087.54,8653.62,566.08,92271.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475596,'2502','379',14140.00,15204.29,1064.29,173479.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475597,'2503','379',5859.44,5859.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475598,'2504','379',8466.04,9025.02,558.98,91113.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176772',3475599,'2505','379',19963.84,20935.06,971.22,158308.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475600,'2506','379',33994.53,35368.58,1374.05,223970.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475601,'2507','379',28117.70,29273.07,1155.37,188325.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475602,'2508','379',24948.33,25478.53,530.20,86422.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475603,'2509','379',20242.43,20474.67,232.24,37855.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475604,'2510','379',27097.58,28372.87,1275.29,207872.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475605,'2511','379',18749.58,19871.71,1102.13,179647.19,0.00,0.00,20.00,0.00,0.00),('1','161','862','176772',3475606,'2512','379',11456.87,13164.20,1707.33,278294.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','176772',3475607,'2513','379',13904.26,14699.64,795.38,129646.94,0.00,0.00,0.00,0.00,0.00),('1','161','863','176772',3475608,'2514','380',3329.59,4131.89,802.30,148425.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','176772',3475609,'2515','380',1438.96,1438.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475610,'2496','379',13762.37,14645.87,883.50,144010.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475611,'2497','379',18217.43,19154.88,937.45,152804.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475612,'2498','379',28626.43,29975.66,1349.23,219924.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475613,'2499','379',31410.40,32750.59,1340.19,218450.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475614,'2500','379',26051.85,27309.71,1257.86,205031.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475615,'2501','379',8653.62,9508.45,854.83,139337.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475616,'2502','379',15204.29,16412.42,1208.13,196925.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475617,'2503','379',5859.44,6299.52,440.08,71733.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475618,'2504','379',9025.02,9025.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176773',3475619,'2505','379',20935.06,21940.69,1005.63,163917.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475620,'2506','379',35368.58,37005.13,1636.55,266757.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475621,'2507','379',29273.07,30793.92,1520.85,247898.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475622,'2508','379',25478.53,25478.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475623,'2509','379',20474.67,20474.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475624,'2510','379',28372.87,29423.91,1051.04,171319.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475625,'2511','379',19871.71,21117.82,1246.11,203115.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475626,'2512','379',13164.20,14049.36,885.16,144281.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','176773',3475627,'2513','379',14699.64,15610.17,910.53,148416.39,0.00,0.00,0.00,0.00,0.00),('1','161','863','176773',3475628,'2514','380',4131.89,4131.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176773',3475629,'2515','380',1438.96,1531.60,92.64,17138.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477799,'2496','379',14645.87,15544.42,898.55,146463.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477800,'2497','379',19154.88,19980.17,825.29,134522.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477801,'2498','379',29975.66,31090.25,1114.59,181678.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477802,'2499','379',32750.59,33616.54,865.95,141149.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477803,'2500','379',27309.71,28184.85,875.14,142647.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477804,'2501','379',9508.45,9974.99,466.54,76046.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477805,'2502','379',16412.42,16994.40,581.98,94862.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477806,'2503','379',6299.52,6319.52,20.00,3260.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477807,'2504','379',9025.02,9550.86,525.84,85711.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','176888',3477808,'2505','379',21940.69,22552.49,611.80,99723.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477809,'2506','379',37005.13,39069.65,2064.52,336516.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477810,'2507','379',30793.92,31620.87,826.95,134792.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477811,'2508','379',25478.53,25618.72,140.19,22850.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477812,'2509','379',20474.67,20881.50,406.83,66313.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477813,'2510','379',29423.91,30552.49,1128.58,183958.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477814,'2511','379',21117.82,22531.61,1413.79,230447.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477815,'2512','379',14049.36,14345.49,296.13,48269.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','176888',3477816,'2513','379',15610.17,16897.79,1287.62,209882.06,0.00,0.00,0.00,0.00,0.00),('1','161','863','176888',3477817,'2514','380',4131.89,4169.73,37.84,7000.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','176888',3477818,'2515','380',1531.60,1531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477872,'2496','379',15544.42,15544.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477873,'2497','379',19980.17,19980.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477874,'2498','379',31090.25,31090.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477875,'2499','379',33616.54,33616.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477876,'2500','379',28184.85,28184.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477877,'2501','379',9974.99,9974.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477878,'2502','379',16994.40,16994.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477879,'2503','379',6319.52,6319.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477880,'2504','379',9550.86,9550.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176891',3477881,'2505','379',22552.49,22552.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477882,'2506','379',39069.65,41996.14,2926.49,477017.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477883,'2507','379',31620.87,34740.93,3120.06,508569.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477884,'2508','379',25618.72,28682.57,3063.85,499407.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477885,'2509','379',20881.50,24147.93,3266.43,532428.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477886,'2510','379',30552.49,33094.31,2541.82,414316.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477887,'2511','379',22531.61,24289.21,1757.60,286488.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477888,'2512','379',14345.49,16253.60,1908.11,311021.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','176891',3477889,'2513','379',16897.79,18761.42,1863.63,303771.69,0.00,0.00,0.00,0.00,0.00),('1','161','863','176891',3477890,'2514','380',4169.73,4840.11,670.38,124020.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','176891',3477891,'2515','380',1531.60,1531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477892,'2496','379',15544.42,16277.67,733.25,119519.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477893,'2497','379',19980.17,21351.35,1371.18,223502.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477894,'2498','379',31090.25,32137.97,1047.72,170778.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477895,'2499','379',33616.54,34637.02,1020.48,166338.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477896,'2500','379',28184.85,29362.99,1178.14,192036.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477897,'2501','379',9974.99,10942.21,967.22,157656.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477898,'2502','379',16994.40,16994.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477899,'2503','379',6319.52,6319.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477900,'2504','379',9550.86,10166.92,616.06,100417.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','176892',3477901,'2505','379',22552.49,23863.69,1311.20,213725.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477902,'2506','379',41996.14,43691.49,1695.35,276342.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477903,'2507','379',34740.93,36338.90,1597.97,260469.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477904,'2508','379',28682.57,28682.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477905,'2509','379',24147.93,24147.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477906,'2510','379',33094.31,33525.28,430.97,70248.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477907,'2511','379',24289.21,25840.98,1551.77,252938.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477908,'2512','379',16253.60,17186.59,932.99,152077.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','176892',3477909,'2513','379',18761.42,19646.05,884.63,144194.69,0.00,0.00,0.00,0.00,0.00),('1','161','863','176892',3477910,'2514','380',4840.11,5140.11,300.00,55500.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176892',3477911,'2515','380',1531.60,2290.50,758.90,140396.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478004,'2496','379',16277.67,17500.83,1223.16,199375.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478005,'2497','379',21351.35,22564.53,1213.18,197748.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478006,'2498','379',32137.97,33824.22,1686.25,274858.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478007,'2499','379',34637.02,35869.91,1232.89,200961.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478008,'2500','379',29362.99,29367.59,4.60,749.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478009,'2501','379',10942.21,11847.89,905.68,147625.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478010,'2502','379',16994.40,17768.32,773.92,126148.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478011,'2503','379',6319.52,7692.98,1373.46,223873.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478012,'2504','379',10166.92,10166.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176898',3478013,'2505','379',23863.69,25369.08,1505.39,245378.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478014,'2506','379',43691.49,45484.19,1792.70,292210.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478015,'2507','379',36338.90,37844.70,1505.80,245445.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478016,'2508','379',28682.57,28785.90,103.33,16842.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478017,'2509','379',24147.93,24162.13,14.20,2314.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478018,'2510','379',33525.28,35038.18,1512.90,246602.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478019,'2511','379',25840.98,26816.28,975.30,158973.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478020,'2512','379',17186.59,17186.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176898',3478021,'2513','379',19646.05,21229.42,1583.37,258089.31,0.00,0.00,0.00,0.00,0.00),('1','161','863','176898',3478022,'2514','380',5140.11,5264.72,124.61,23052.85,0.00,0.00,0.00,0.00,0.00),('1','161','863','176898',3478023,'2515','380',2290.50,2309.96,19.46,3600.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478508,'2496','379',17500.83,17845.61,344.78,56199.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478509,'2497','379',22564.53,24114.22,1549.69,252599.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478510,'2498','379',33824.22,34180.33,356.11,58045.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478511,'2499','379',35869.91,37524.53,1654.62,269703.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478512,'2500','379',29367.59,30580.14,1212.55,197645.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478513,'2501','379',11847.89,11847.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478514,'2502','379',17768.32,18720.66,952.34,155231.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478515,'2503','379',7692.98,7692.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478516,'2504','379',10166.92,10614.05,447.13,72882.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176927',3478517,'2505','379',25369.08,26364.40,995.32,162237.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478518,'2506','379',45484.19,46865.87,1381.68,225213.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478519,'2507','379',37844.70,38497.04,652.34,106331.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478520,'2508','379',28785.90,28785.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478521,'2509','379',24162.13,24162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478522,'2510','379',35038.18,36374.73,1336.55,217857.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478523,'2511','379',26816.28,28438.61,1622.33,264439.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478524,'2512','379',17186.59,17871.11,684.52,111576.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','176927',3478525,'2513','379',21229.42,21671.28,441.86,72023.18,0.00,0.00,0.00,0.00,0.00),('1','161','863','176927',3478526,'2514','380',5264.72,5316.50,41.78,7729.30,0.00,0.00,10.00,0.00,0.00),('1','161','863','176927',3478527,'2515','380',2309.96,2382.65,72.69,13447.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478581,'2496','379',17845.61,19018.23,1172.62,191137.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478582,'2497','379',24114.22,25058.58,944.36,153930.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478583,'2498','379',34180.33,35472.04,1291.71,210548.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478584,'2499','379',37524.53,38733.10,1208.57,196996.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478585,'2500','379',30580.14,31733.57,1153.43,188009.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478586,'2501','379',11847.89,12605.29,757.40,123456.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478587,'2502','379',18720.66,18720.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478588,'2503','379',7692.98,8295.21,602.23,98163.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478589,'2504','379',10614.05,10614.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176932',3478590,'2505','379',26364.40,27267.97,903.57,147281.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478591,'2506','379',46865.87,49759.91,2894.04,471728.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478592,'2507','379',38497.04,40954.66,2457.62,400592.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478593,'2508','379',28785.90,29673.12,887.22,144616.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478594,'2509','379',24162.13,24906.82,744.69,121384.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478595,'2510','379',36374.73,38199.59,1824.86,297452.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478596,'2511','379',28438.61,29840.59,1401.98,228522.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','176932',3478597,'2512','379',17871.11,19002.87,1121.76,182846.88,0.00,0.00,10.00,0.00,0.00),('1','161','862','176932',3478598,'2513','379',21671.28,23177.16,1505.88,245458.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','176932',3478599,'2514','380',5316.50,5484.70,168.20,31117.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176932',3478600,'2515','380',2382.65,2382.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478760,'2496','379',19018.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478761,'2497','379',25058.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478762,'2498','379',35472.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478763,'2499','379',38733.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478764,'2500','379',31733.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478765,'2501','379',12605.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478766,'2502','379',18720.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478767,'2503','379',8295.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478768,'2504','379',10614.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176939',3478769,'2505','379',27267.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478770,'2506','379',49759.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478771,'2507','379',40954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478772,'2508','379',29673.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478773,'2509','379',24906.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478774,'2510','379',38199.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478775,'2511','379',29840.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478776,'2512','379',19002.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176939',3478777,'2513','379',23177.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176939',3478778,'2514','380',5484.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176939',3478779,'2515','380',2382.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478838,'2496','379',19018.23,19039.70,21.47,3499.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478839,'2497','379',25058.58,25276.26,217.68,35481.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478840,'2498','379',35472.04,35533.06,61.02,9946.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478841,'2499','379',38733.10,39138.00,404.90,65998.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478842,'2500','379',31733.57,31818.96,85.39,13918.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478843,'2501','379',12605.29,12605.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478844,'2502','379',18720.66,18978.26,257.60,41988.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478845,'2503','379',8295.21,8295.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478846,'2504','379',10614.05,10696.34,82.29,13413.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','176943',3478847,'2505','379',27267.97,27467.87,199.90,32583.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478848,'2506','379',49759.91,52094.94,2335.03,380609.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478849,'2507','379',40954.66,43144.85,2190.19,357000.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478850,'2508','379',29673.12,31779.71,2106.59,343374.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478851,'2509','379',24906.82,26828.65,1921.83,313258.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478852,'2510','379',38199.59,40176.86,1977.27,322295.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478853,'2511','379',29840.59,32058.57,2217.98,361530.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478854,'2512','379',19002.87,20367.62,1364.75,222454.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','176943',3478855,'2513','379',23177.16,25159.32,1982.16,323092.08,0.00,0.00,0.00,0.00,0.00),('1','161','863','176943',3478856,'2514','380',5484.70,6024.70,540.00,102600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176943',3478857,'2515','380',2382.65,2466.86,84.21,15999.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478941,'2496','379',19039.70,19039.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478942,'2497','379',25276.26,25468.84,162.58,26500.54,0.00,0.00,30.00,0.00,0.00),('1','161','861','176950',3478943,'2498','379',35533.06,35533.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478944,'2499','379',39138.00,39449.87,311.87,50834.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478945,'2500','379',31818.96,32117.23,298.27,48618.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478946,'2501','379',12605.29,12605.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478947,'2502','379',18978.26,18978.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478948,'2503','379',8295.21,8354.31,59.10,9633.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478949,'2504','379',10696.34,10696.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176950',3478950,'2505','379',27467.87,27467.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478951,'2506','379',52094.94,55973.45,3878.51,632197.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478952,'2507','379',43144.85,46192.93,3048.08,496837.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478953,'2508','379',31779.71,35463.17,3683.46,600403.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478954,'2509','379',26828.65,29185.92,2357.27,384235.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478955,'2510','379',40176.86,42857.21,2680.35,436897.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478956,'2511','379',32058.57,34374.41,2315.84,377481.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478957,'2512','379',20367.62,23187.85,2820.23,459697.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','176950',3478958,'2513','379',25159.32,27466.23,2306.91,376026.33,0.00,0.00,0.00,0.00,0.00),('1','161','863','176950',3478959,'2514','380',6024.70,6415.32,390.62,74217.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','176950',3478960,'2515','380',2466.86,2877.39,410.53,78000.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478961,'2496','379',19039.70,19039.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478962,'2497','379',25468.84,25993.38,524.54,85500.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478963,'2498','379',35533.06,36439.81,906.75,147800.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478964,'2499','379',39449.87,40156.28,706.41,115144.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478965,'2500','379',32117.23,33214.60,1097.37,178871.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478966,'2501','379',12605.29,12605.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478967,'2502','379',18978.26,19573.61,595.35,97042.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478968,'2503','379',8354.31,8354.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478969,'2504','379',10696.34,10700.34,4.00,652.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176951',3478970,'2505','379',27467.87,27467.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478971,'2506','379',55973.45,57867.97,1894.52,308806.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478972,'2507','379',46192.93,47380.96,1188.03,193648.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478973,'2508','379',35463.17,37260.93,1797.76,293034.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478974,'2509','379',29185.92,30493.01,1307.09,213055.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478975,'2510','379',42857.21,43980.74,1123.53,183135.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478976,'2511','379',34374.41,35471.15,1096.74,178768.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478977,'2512','379',23187.85,24287.43,1099.58,179231.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','176951',3478978,'2513','379',27466.23,28495.38,1029.15,167751.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','176951',3478979,'2514','380',6415.32,6600.07,184.75,35102.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','176951',3478980,'2515','380',2877.39,2877.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478981,'2496','379',19039.70,20354.83,1315.13,214366.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478982,'2497','379',25993.38,25993.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478983,'2498','379',36439.81,37695.65,1255.84,204701.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478984,'2499','379',40156.28,41890.62,1734.34,282697.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478985,'2500','379',33214.60,33214.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478986,'2501','379',12605.29,13796.49,1191.20,194165.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478987,'2502','379',19573.61,19573.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478988,'2503','379',8354.31,8354.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478989,'2504','379',10700.34,11512.25,811.91,132341.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','176952',3478990,'2505','379',27467.87,28914.24,1446.37,235758.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478991,'2506','379',57867.97,59435.37,1567.40,255486.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478992,'2507','379',47380.96,48929.62,1548.66,252431.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478993,'2508','379',37260.93,38287.82,1026.89,167383.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478994,'2509','379',30493.01,31667.37,1174.36,191420.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478995,'2510','379',43980.74,45289.04,1308.30,213252.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478996,'2511','379',35471.15,37120.35,1649.20,268819.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478997,'2512','379',24287.43,25049.05,761.62,124144.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','176952',3478998,'2513','379',28495.38,28495.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176952',3478999,'2514','380',6600.07,6600.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176952',3479000,'2515','380',2877.39,2877.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479051,'2496','379',20354.83,20450.47,95.64,15589.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479052,'2497','379',25993.38,27153.94,1160.56,189171.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479053,'2498','379',37695.65,37695.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479054,'2499','379',41890.62,43835.39,1944.77,316997.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479055,'2500','379',33214.60,35206.12,1991.52,324617.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479056,'2501','379',13796.49,13796.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479057,'2502','379',19573.61,20903.87,1330.26,216832.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479058,'2503','379',8354.31,8354.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479059,'2504','379',11512.25,12007.08,494.83,80657.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','176957',3479060,'2505','379',28914.24,28914.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479061,'2506','379',59435.37,61387.11,1951.74,318133.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479062,'2507','379',48929.62,50492.15,1562.53,254692.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479063,'2508','379',38287.82,39171.31,883.49,144008.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479064,'2509','379',31667.37,33583.41,1916.04,312314.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479065,'2510','379',45289.04,47050.77,1761.73,287161.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479066,'2511','379',37120.35,37810.64,690.29,112517.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479067,'2512','379',25049.05,25804.39,755.34,123120.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','176957',3479068,'2513','379',28495.38,28829.45,334.07,54453.41,0.00,0.00,0.00,0.00,0.00),('1','161','863','176957',3479069,'2514','380',6600.07,6676.07,76.00,14440.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176957',3479070,'2515','380',2877.39,2877.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479083,'2496','379',20450.47,21766.66,1316.19,214538.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479084,'2497','379',27153.94,27978.33,824.39,134375.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479085,'2498','379',37695.65,39610.88,1915.23,312182.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479086,'2499','379',43835.39,45316.03,1480.64,241344.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479087,'2500','379',35206.12,36694.29,1488.17,242571.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479088,'2501','379',13796.49,14910.69,1114.20,181614.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479089,'2502','379',20903.87,20903.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479090,'2503','379',8354.31,8663.47,309.16,50393.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479091,'2504','379',12007.08,12201.91,194.83,31757.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','176959',3479092,'2505','379',28914.24,29442.60,528.36,86122.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479093,'2506','379',61387.11,63665.36,2278.25,371354.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479094,'2507','379',50492.15,51848.14,1355.99,221026.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479095,'2508','379',39171.31,41072.29,1900.98,309859.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479096,'2509','379',33583.41,34653.32,1069.91,174395.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479097,'2510','379',47050.77,48402.01,1351.24,220252.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479098,'2511','379',37810.64,38633.78,823.14,134171.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479099,'2512','379',25804.39,26585.53,781.14,127325.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','176959',3479100,'2513','379',28829.45,29640.05,790.60,128867.80,0.00,0.00,20.00,0.00,0.00),('1','161','863','176959',3479101,'2514','380',6676.07,6676.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176959',3479102,'2515','380',2877.39,2947.40,70.01,13301.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479106,'2496','379',21766.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479107,'2497','379',27978.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479108,'2498','379',39610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479109,'2499','379',45316.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479110,'2500','379',36694.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479111,'2501','379',14910.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479112,'2502','379',20903.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479113,'2503','379',8663.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479114,'2504','379',12201.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176962',3479115,'2505','379',29442.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479116,'2506','379',63665.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479117,'2507','379',51848.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479118,'2508','379',41072.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479119,'2509','379',34653.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479120,'2510','379',48402.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479121,'2511','379',38633.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479122,'2512','379',26585.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176962',3479123,'2513','379',29640.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176962',3479124,'2514','380',6676.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176962',3479125,'2515','380',2947.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479190,'2496','379',21766.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479191,'2497','379',27978.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479192,'2498','379',39610.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479193,'2499','379',45316.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479194,'2500','379',36694.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479195,'2501','379',14910.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479196,'2502','379',20903.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479197,'2503','379',8663.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479198,'2504','379',12201.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176971',3479199,'2505','379',29442.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479200,'2506','379',63665.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479201,'2507','379',51848.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479202,'2508','379',41072.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479203,'2509','379',34653.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479204,'2510','379',48402.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479205,'2511','379',38633.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479206,'2512','379',26585.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176971',3479207,'2513','379',29640.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176971',3479208,'2514','380',6676.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','176971',3479209,'2515','380',2947.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479210,'2496','379',21766.66,21766.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479211,'2497','379',27978.33,29301.15,1322.82,215619.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479212,'2498','379',39610.88,40695.44,1084.56,176783.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479213,'2499','379',45316.03,46807.82,1491.79,243161.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479214,'2500','379',36694.29,38350.69,1656.40,269993.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479215,'2501','379',14910.69,14916.82,6.13,999.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479216,'2502','379',20903.87,22193.48,1289.61,210206.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479217,'2503','379',8663.47,9374.41,710.94,115883.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479218,'2504','379',12201.91,12201.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176972',3479219,'2505','379',29442.60,29442.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479220,'2506','379',63665.36,64434.75,769.39,125410.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479221,'2507','379',51848.14,53773.63,1925.49,313854.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479222,'2508','379',41072.29,42347.01,1274.72,207779.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479223,'2509','379',34653.32,35665.97,1012.65,165061.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479224,'2510','379',48402.01,48578.65,176.64,28792.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479225,'2511','379',38633.78,40056.31,1422.53,231872.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479226,'2512','379',26585.53,27903.65,1318.12,214853.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','176972',3479227,'2513','379',29640.05,29646.74,6.69,1090.47,0.00,0.00,0.00,0.00,0.00),('1','161','863','176972',3479228,'2514','380',6676.07,6771.38,95.31,18108.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','176972',3479229,'2515','380',2947.40,2947.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479230,'2496','379',21766.66,22946.72,1180.06,192349.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479231,'2497','379',29301.15,29917.83,616.68,100518.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479232,'2498','379',40695.44,42532.95,1837.51,299514.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479233,'2499','379',46807.82,47311.93,504.11,82169.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479234,'2500','379',38350.69,40079.94,1729.25,281867.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479235,'2501','379',14916.82,14916.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479236,'2502','379',22193.48,23485.88,1292.40,210661.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479237,'2503','379',9374.41,9374.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479238,'2504','379',12201.91,12871.09,669.18,109076.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','176973',3479239,'2505','379',29442.60,29929.48,473.02,77102.26,0.00,0.00,13.86,0.00,0.00),('1','161','862','176973',3479240,'2506','379',64434.75,66242.78,1808.03,294708.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479241,'2507','379',53773.63,55410.48,1636.85,266806.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479242,'2508','379',42347.01,44210.08,1863.07,303680.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479243,'2509','379',35665.97,36646.18,980.21,159774.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479244,'2510','379',48578.65,50750.58,2171.93,354024.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479245,'2511','379',40056.31,41246.14,1189.83,193942.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479246,'2512','379',27903.65,27910.02,6.37,1038.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','176973',3479247,'2513','379',29646.74,30821.15,1174.41,191428.83,0.00,0.00,0.00,0.00,0.00),('1','161','863','176973',3479248,'2514','380',6771.38,6877.71,106.33,20202.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','176973',3479249,'2515','380',2947.40,3597.41,650.01,123501.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480506,'2496','379',22946.72,23785.95,839.23,136794.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480507,'2497','379',29917.83,29917.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480508,'2498','379',42532.95,44020.53,1487.58,242475.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480509,'2499','379',47311.93,48678.72,1366.79,222786.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480510,'2500','379',40079.94,41772.32,1692.38,275857.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480511,'2501','379',14916.82,14916.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480512,'2502','379',23485.88,24634.86,1148.98,187283.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480513,'2503','379',9374.41,9791.40,416.99,67969.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480514,'2504','379',12871.09,12871.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177047',3480515,'2505','379',29929.48,29929.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480516,'2506','379',66242.78,68385.09,2142.31,349196.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480517,'2507','379',55410.48,57346.00,1935.52,315489.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480518,'2508','379',44210.08,45792.00,1581.92,257852.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480519,'2509','379',36646.18,36678.87,32.69,5328.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480520,'2510','379',50750.58,52114.06,1363.48,222247.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480521,'2511','379',41246.14,42303.49,1057.35,172348.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480522,'2512','379',27910.02,27910.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177047',3480523,'2513','379',30821.15,32692.36,1871.21,305007.23,0.00,0.00,0.00,0.00,0.00),('1','161','863','177047',3480524,'2514','380',6877.71,7096.66,218.95,41600.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','177047',3480525,'2515','380',3597.41,3597.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480654,'2496','379',23785.95,24568.42,782.47,127542.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480655,'2497','379',29917.83,30713.71,795.88,129728.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480656,'2498','379',44020.53,45280.64,1260.11,205397.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480657,'2499','379',48678.72,50207.00,1528.28,249109.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480658,'2500','379',41772.32,41772.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480659,'2501','379',14916.82,15537.38,620.56,101151.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480660,'2502','379',24634.86,24634.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480661,'2503','379',9791.40,9791.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480662,'2504','379',12871.09,13346.86,475.77,77550.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','177053',3480663,'2505','379',29929.48,31349.86,1420.38,231521.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480664,'2506','379',68385.09,70242.84,1857.75,302813.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480665,'2507','379',57346.00,58695.27,1349.27,219931.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480666,'2508','379',45792.00,47252.26,1460.26,238022.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480667,'2509','379',36678.87,37710.66,1021.79,166551.77,0.00,0.00,10.00,0.00,0.00),('1','161','862','177053',3480668,'2510','379',52114.06,53341.73,1227.67,200110.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480669,'2511','379',42303.49,43108.25,804.76,131175.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480670,'2512','379',27910.02,28438.65,528.63,86166.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','177053',3480671,'2513','379',32692.36,33329.82,637.46,103905.98,0.00,0.00,0.00,0.00,0.00),('1','161','863','177053',3480672,'2514','380',7096.66,7400.63,303.97,57754.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177053',3480673,'2515','380',3597.41,4227.41,630.00,119700.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177055',3480704,'2496','379',24568.42,24608.42,0.00,0.00,0.00,0.00,40.00,0.00,0.00),('1','161','861','177055',3480705,'2497','379',30713.71,31794.77,1061.06,172952.78,0.00,0.00,20.00,0.00,0.00),('1','161','861','177055',3480706,'2498','379',45280.64,46574.91,1274.27,207706.01,0.00,0.00,20.00,0.00,0.00),('1','161','861','177055',3480707,'2499','379',50207.00,52124.46,1877.46,306025.98,0.00,0.00,40.00,0.00,0.00),('1','161','861','177055',3480708,'2500','379',41772.32,43208.79,1426.47,232514.61,0.00,0.00,10.00,0.00,0.00),('1','161','861','177055',3480709,'2501','379',15537.38,15557.38,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','177055',3480710,'2502','379',24634.86,25582.84,917.98,149630.74,0.00,0.00,30.00,0.00,0.00),('1','161','861','177055',3480711,'2503','379',9791.40,9821.40,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','161','861','177055',3480712,'2504','379',13346.86,13911.65,544.79,88800.77,0.00,0.00,20.00,0.00,0.00),('1','161','861','177055',3480713,'2505','379',31349.86,31369.86,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','862','177055',3480714,'2506','379',70242.84,71994.62,1731.78,282280.14,0.00,0.00,20.00,0.00,0.00),('1','161','862','177055',3480715,'2507','379',58695.27,60300.75,1585.48,258433.24,0.00,0.00,20.00,0.00,0.00),('1','161','862','177055',3480716,'2508','379',47252.26,48565.00,1292.74,210716.62,0.00,0.00,20.00,0.00,0.00),('1','161','862','177055',3480717,'2509','379',37710.66,38673.60,952.94,155329.22,0.00,0.00,10.00,0.00,0.00),('1','161','862','177055',3480718,'2510','379',53341.73,54683.32,1321.59,215419.17,0.00,0.00,20.00,0.00,0.00),('1','161','862','177055',3480719,'2511','379',43108.25,43441.18,302.93,49377.59,0.00,0.00,30.00,0.00,0.00),('1','161','862','177055',3480720,'2512','379',28438.65,28473.09,4.44,723.72,0.00,0.00,30.00,0.00,0.00),('1','161','862','177055',3480721,'2513','379',33329.82,34439.23,1099.41,179203.83,0.00,0.00,10.00,0.00,0.00),('1','161','863','177055',3480722,'2514','380',7400.63,7777.75,357.12,67852.80,0.00,0.00,20.00,0.00,0.00),('1','161','863','177055',3480723,'2515','380',4227.41,4247.41,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','177060',3480825,'2496','379',24608.42,24797.73,189.31,30857.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480826,'2497','379',31794.77,33660.11,1865.34,304050.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480827,'2498','379',46574.91,47666.11,1091.20,177865.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480828,'2499','379',52124.46,54053.14,1928.68,314374.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480829,'2500','379',43208.79,45191.55,1982.76,323189.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480830,'2501','379',15557.38,16837.63,1280.25,208680.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480831,'2502','379',25582.84,25582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480832,'2503','379',9821.40,9821.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480833,'2504','379',13911.65,14521.34,609.69,99379.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','177060',3480834,'2505','379',31369.86,31369.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480835,'2506','379',71994.62,73353.65,1359.03,221521.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480836,'2507','379',60300.75,61634.62,1333.87,217420.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480837,'2508','379',48565.00,49876.31,1311.31,213743.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480838,'2509','379',38673.60,39671.17,997.57,162603.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480839,'2510','379',54683.32,56415.02,1731.70,282267.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480840,'2511','379',43441.18,44497.41,1056.23,172165.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480841,'2512','379',28473.09,29486.44,1013.35,165176.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','177060',3480842,'2513','379',34439.23,34673.58,234.35,38199.05,0.00,0.00,0.00,0.00,0.00),('1','161','863','177060',3480843,'2514','380',7777.75,7777.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177060',3480844,'2515','380',4247.41,4430.42,183.01,34771.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480870,'2496','379',24797.73,24797.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480871,'2497','379',33660.11,34693.03,1032.92,168365.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480872,'2498','379',47666.11,48909.32,1243.21,202643.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480873,'2499','379',54053.14,55763.78,1710.64,278834.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480874,'2500','379',45191.55,46931.64,1740.09,283634.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480875,'2501','379',16837.63,18026.31,1188.68,193754.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480876,'2502','379',25582.84,25582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480877,'2503','379',9821.40,10244.55,423.15,68973.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480878,'2504','379',14521.34,14521.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177062',3480879,'2505','379',31369.86,31369.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480880,'2506','379',73353.65,74810.65,1457.00,237491.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480881,'2507','379',61634.62,63192.69,1558.07,253965.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480882,'2508','379',49876.31,51055.01,1178.70,192128.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480883,'2509','379',39671.17,40882.43,1211.26,197435.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480884,'2510','379',56415.02,57528.33,1113.31,181469.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480885,'2511','379',44497.41,45809.85,1312.44,213927.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480886,'2512','379',29486.44,29486.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177062',3480887,'2513','379',34673.58,35686.52,1012.94,165109.22,0.00,0.00,0.00,0.00,0.00),('1','161','863','177062',3480888,'2514','380',7777.75,7936.91,159.16,30240.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','177062',3480889,'2515','380',4430.42,4430.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480930,'2496','379',24797.73,26206.87,1409.14,229689.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480931,'2497','379',34693.03,35435.73,742.70,121060.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480932,'2498','379',48909.32,50906.76,1997.44,325582.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480933,'2499','379',55763.78,57615.93,1852.15,301900.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480934,'2500','379',46931.64,48462.01,1530.37,249450.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480935,'2501','379',18026.31,18026.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480936,'2502','379',25582.84,26898.21,1315.37,214405.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480937,'2503','379',10244.55,10244.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480938,'2504','379',14521.34,15216.19,694.85,113260.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','177065',3480939,'2505','379',31369.86,32656.77,1286.91,209766.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480940,'2506','379',74810.65,77062.14,2251.49,366992.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480941,'2507','379',63192.69,65476.07,2283.38,372190.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480942,'2508','379',51055.01,52418.33,1363.32,222221.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480943,'2509','379',40882.43,41872.62,990.19,161400.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480944,'2510','379',57528.33,58831.49,1303.16,212415.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480945,'2511','379',45809.85,46910.63,1020.78,166387.14,0.00,0.00,80.00,0.00,0.00),('1','161','862','177065',3480946,'2512','379',29486.44,30500.14,1013.70,165233.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','177065',3480947,'2513','379',35686.52,35686.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177065',3480948,'2514','380',7936.91,7936.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177065',3480949,'2515','380',4430.42,4986.06,555.64,105571.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481112,'2496','379',26206.87,26885.52,678.65,110619.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481113,'2497','379',35435.73,36142.55,706.82,115211.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481114,'2498','379',50906.76,52395.74,1488.98,242703.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481115,'2499','379',57615.93,59037.00,1421.07,231634.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481116,'2500','379',48462.01,50695.51,2233.50,364060.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481117,'2501','379',18026.31,19157.08,1130.77,184315.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481118,'2502','379',26898.21,26898.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481119,'2503','379',10244.55,10244.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481120,'2504','379',15216.19,15760.24,544.05,88680.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','177072',3481121,'2505','379',32656.77,32656.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481122,'2506','379',77062.14,78702.14,1640.00,267320.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481123,'2507','379',65476.07,66776.66,1300.59,211996.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481124,'2508','379',52418.33,53586.18,1167.85,190359.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481125,'2509','379',41872.62,42977.71,1105.09,180129.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481126,'2510','379',58831.49,59785.60,954.11,155519.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481127,'2511','379',46910.63,48087.31,1176.68,191798.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481128,'2512','379',30500.14,31191.31,691.17,112660.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','177072',3481129,'2513','379',35686.52,35686.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177072',3481130,'2514','380',7936.91,8035.69,98.78,18768.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','177072',3481131,'2515','380',4986.06,5186.06,200.00,38000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481210,'2496','379',26885.52,28120.13,1234.61,201241.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481211,'2497','379',36142.55,37309.73,1167.18,190250.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481212,'2498','379',52395.74,54063.94,1668.20,271916.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481213,'2499','379',59037.00,61392.83,2355.83,384000.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481214,'2500','379',50695.51,53171.00,2475.49,403504.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481215,'2501','379',19157.08,19157.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481216,'2502','379',26898.21,28350.12,1451.91,236661.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481217,'2503','379',10244.55,11180.54,935.99,152566.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481218,'2504','379',15760.24,15760.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177076',3481219,'2505','379',32656.77,32656.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481220,'2506','379',78702.14,80496.41,1794.27,292466.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481221,'2507','379',66776.66,68632.32,1855.66,302472.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481222,'2508','379',53586.18,55422.12,1835.94,299258.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481223,'2509','379',42977.71,44057.10,1079.39,175940.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481224,'2510','379',59785.60,60889.88,1104.28,179997.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481225,'2511','379',48087.31,49243.80,1156.49,188507.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481226,'2512','379',31191.31,31191.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177076',3481227,'2513','379',35686.52,36826.69,1140.17,185847.71,0.00,0.00,0.00,0.00,0.00),('1','161','863','177076',3481228,'2514','380',8035.69,8035.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177076',3481229,'2515','380',5186.06,5580.79,394.73,74998.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481295,'2496','379',28120.13,28120.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481296,'2497','379',37309.73,39004.99,1695.26,276327.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481297,'2498','379',54063.94,55007.00,943.06,153718.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481298,'2499','379',61392.83,62852.98,1460.15,238004.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481299,'2500','379',53171.00,54750.81,1579.81,257509.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481300,'2501','379',19157.08,19157.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481301,'2502','379',28350.12,29233.05,882.93,143917.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481302,'2503','379',11180.54,11180.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481303,'2504','379',15760.24,15945.44,185.20,30187.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','177079',3481304,'2505','379',32656.77,32656.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481305,'2506','379',80496.41,82050.78,1554.37,253362.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481306,'2507','379',68632.32,69969.65,1337.33,217984.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481307,'2508','379',55422.12,56600.53,1178.41,192080.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481308,'2509','379',44057.10,44730.59,673.49,109778.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481309,'2510','379',60889.88,61788.88,899.00,146537.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481310,'2511','379',49243.80,50049.61,805.81,131347.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481311,'2512','379',31191.31,32100.82,909.51,148250.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','177079',3481312,'2513','379',36826.69,36826.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177079',3481313,'2514','380',8035.69,8035.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177079',3481314,'2515','380',5580.79,5846.57,265.78,50498.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481409,'2496','379',28120.13,28726.71,606.58,98872.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481410,'2497','379',39004.99,39777.66,772.67,125945.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481411,'2498','379',55007.00,56767.69,1760.69,286992.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481412,'2499','379',62852.98,64522.01,1669.03,272051.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481413,'2500','379',54750.81,54750.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481414,'2501','379',19157.08,19157.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177083',3481415,'2502','379',29233.05,30737.05,1484.00,241892.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','177083',3481416,'2503','379',11180.54,12577.90,1387.36,226139.68,0.00,0.00,10.00,0.00,0.00),('1','161','861','177083',3481417,'2504','379',15945.44,17839.40,1883.96,307085.48,0.00,0.00,10.00,0.00,0.00),('1','161','861','177083',3481418,'2505','379',32656.77,34320.97,1664.20,271264.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481419,'2506','379',82050.78,84262.68,2211.90,360539.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481420,'2507','379',69969.65,71849.12,1879.47,306353.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481421,'2508','379',56600.53,57798.66,1198.13,195295.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481422,'2509','379',44730.59,46065.25,1334.66,217549.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481423,'2510','379',61788.88,63166.16,1377.28,224496.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481424,'2511','379',50049.61,51233.89,1184.28,193037.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481425,'2512','379',32100.82,32100.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177083',3481426,'2513','379',36826.69,38196.78,1370.09,223324.67,0.00,0.00,0.00,0.00,0.00),('1','161','863','177083',3481427,'2514','380',8035.69,8103.58,67.89,12899.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177083',3481428,'2515','380',5846.57,5846.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481454,'2496','379',28726.71,30283.73,1557.02,253794.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481455,'2497','379',39777.66,39777.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481456,'2498','379',56767.69,58022.28,1254.59,204498.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481457,'2499','379',64522.01,66570.99,2028.98,330723.74,0.00,0.00,20.00,0.00,0.00),('1','161','861','177085',3481458,'2500','379',54750.81,56158.33,1407.52,229425.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481459,'2501','379',19157.08,20260.57,1103.49,179868.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481460,'2502','379',30737.05,30737.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481461,'2503','379',12577.90,12577.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481462,'2504','379',17839.40,18322.22,482.82,78699.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','177085',3481463,'2505','379',34320.97,35046.71,725.74,118295.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481464,'2506','379',84262.68,86057.13,1794.45,292495.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481465,'2507','379',71849.12,73345.37,1496.25,243888.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481466,'2508','379',57798.66,59218.83,1420.17,231487.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481467,'2509','379',46065.25,47357.51,1292.26,210638.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481468,'2510','379',63166.16,64273.70,1107.54,180529.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481469,'2511','379',51233.89,52272.38,1038.49,169273.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481470,'2512','379',32100.82,33462.55,1361.73,221961.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','177085',3481471,'2513','379',38196.78,38196.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177085',3481472,'2514','380',8103.58,8476.55,372.97,70864.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177085',3481473,'2515','380',5846.57,5846.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482223,'2496','379',30283.73,30283.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482224,'2497','379',39777.66,41031.30,1253.64,204343.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482225,'2498','379',58022.28,59266.00,1243.72,202726.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482226,'2499','379',66570.99,68060.59,1489.60,242804.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482227,'2500','379',56158.33,56158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482228,'2501','379',20260.57,20260.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482229,'2502','379',30737.05,31880.56,1143.51,186392.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482230,'2503','379',12577.90,13251.72,673.82,109832.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482231,'2504','379',18322.22,18322.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177126',3482232,'2505','379',35046.71,36657.22,1610.51,262513.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482233,'2506','379',86057.13,87347.66,1290.53,210356.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482234,'2507','379',73345.37,75108.22,1762.85,287344.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482235,'2508','379',59218.83,60636.86,1418.03,231138.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482236,'2509','379',47357.51,48394.59,1037.08,169044.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482237,'2510','379',64273.70,65435.20,1161.50,189324.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482238,'2511','379',52272.38,52866.94,594.56,96913.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482239,'2512','379',33462.55,33462.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177126',3482240,'2513','379',38196.78,39944.10,1747.32,284813.16,0.00,0.00,0.00,0.00,0.00),('1','161','863','177126',3482241,'2514','380',8476.55,8476.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177126',3482242,'2515','380',5846.57,6133.11,286.54,54442.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482267,'2496','379',30283.73,31028.57,744.84,121408.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482268,'2497','379',41031.30,41945.98,914.68,149092.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482269,'2498','379',59266.00,60410.36,1144.36,186530.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482270,'2499','379',68060.59,69348.22,1287.63,209883.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482271,'2500','379',56158.33,57774.42,1616.09,263422.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482272,'2501','379',20260.57,20260.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482273,'2502','379',31880.56,32612.16,731.60,119250.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482274,'2503','379',13251.72,13869.52,617.80,100701.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482275,'2504','379',18322.22,18322.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177129',3482276,'2505','379',36657.22,36657.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482277,'2506','379',87347.66,88815.85,1468.19,239314.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482278,'2507','379',75108.22,76784.60,1676.38,273249.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482279,'2508','379',60636.86,62335.78,1698.92,276923.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482280,'2509','379',48394.59,49638.07,1243.48,202687.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482281,'2510','379',65435.20,66359.78,924.58,150706.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482282,'2511','379',52866.94,53411.79,544.85,88810.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482283,'2512','379',33462.55,33462.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177129',3482284,'2513','379',39944.10,40766.21,822.11,134003.93,0.00,0.00,0.00,0.00,0.00),('1','161','863','177129',3482285,'2514','380',8476.55,8476.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177129',3482286,'2515','380',6133.11,6485.32,352.21,66919.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482400,'2496','379',31028.57,31028.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482401,'2497','379',41945.98,43578.17,1632.19,266046.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482402,'2498','379',60410.36,61872.63,1462.27,238350.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482403,'2499','379',69348.22,71145.60,1797.38,292972.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482404,'2500','379',57774.42,57774.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482405,'2501','379',20260.57,21142.30,881.73,143721.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482406,'2502','379',32612.16,32612.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482407,'2503','379',13869.52,13869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482408,'2504','379',18322.22,19187.41,865.19,141025.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','177135',3482409,'2505','379',36657.22,38105.82,1448.60,236121.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482410,'2506','379',88815.85,90612.67,1796.82,292881.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482411,'2507','379',76784.60,78399.07,1614.47,263158.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482412,'2508','379',62335.78,64201.36,1865.58,304089.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482413,'2509','379',49638.07,51085.89,1447.82,235994.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482414,'2510','379',66359.78,67534.07,1174.29,191409.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482415,'2511','379',53411.79,54471.48,1059.69,172729.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482416,'2512','379',33462.55,34965.26,1502.71,244941.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','177135',3482417,'2513','379',40766.21,40766.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177135',3482418,'2514','380',8476.55,8476.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177135',3482419,'2515','380',6485.32,6719.01,233.69,44401.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486577,'2496','379',31028.57,31158.31,99.74,16257.62,0.00,0.00,30.00,0.00,0.00),('1','161','861','177350',3486578,'2497','379',43578.17,44589.67,992.92,161845.96,0.00,0.00,18.58,0.00,0.00),('1','161','861','177350',3486579,'2498','379',61872.63,63323.89,1431.26,233295.38,0.00,0.00,20.00,0.00,0.00),('1','161','861','177350',3486580,'2499','379',71145.60,72409.21,1243.61,202708.43,0.00,0.00,20.00,0.00,0.00),('1','161','861','177350',3486581,'2500','379',57774.42,59242.10,1467.68,239231.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486582,'2501','379',21142.30,22088.42,946.12,154217.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486583,'2502','379',32612.16,32612.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486584,'2503','379',13869.52,14306.99,437.47,71307.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486585,'2504','379',19187.41,19187.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177350',3486586,'2505','379',38105.82,39166.10,1060.28,172825.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','177350',3486587,'2506','379',90612.67,92330.94,1708.27,278448.01,0.00,0.00,10.00,0.00,0.00),('1','161','862','177350',3486588,'2507','379',78399.07,79651.06,1231.99,200814.37,0.00,0.00,20.00,0.00,0.00),('1','161','862','177350',3486589,'2508','379',64201.36,66060.36,1839.00,299757.00,0.00,0.00,20.00,0.00,0.00),('1','161','862','177350',3486590,'2509','379',51085.89,51139.79,43.90,7155.70,0.00,0.00,10.00,0.00,0.00),('1','161','862','177350',3486591,'2510','379',67534.07,69149.60,1595.53,260071.39,0.00,0.00,20.00,0.00,0.00),('1','161','862','177350',3486592,'2511','379',54471.48,55288.79,787.31,128331.53,0.00,0.00,30.00,0.00,0.00),('1','161','862','177350',3486593,'2512','379',34965.26,34965.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177350',3486594,'2513','379',40766.21,41777.79,991.58,161627.54,0.00,0.00,20.00,0.00,0.00),('1','161','863','177350',3486595,'2514','380',8476.55,8568.13,91.58,17400.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','177350',3486596,'2515','380',6719.01,6719.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486638,'2496','379',31158.31,31158.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486639,'2497','379',44589.67,45985.10,1395.43,227455.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486640,'2498','379',63323.89,65064.44,1719.94,280350.22,0.00,0.00,20.61,0.00,0.00),('1','161','861','177353',3486641,'2499','379',72409.21,74014.44,1605.23,261652.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486642,'2500','379',59242.10,59242.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486643,'2501','379',22088.42,22088.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486644,'2502','379',32612.16,34121.19,1509.03,245971.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486645,'2503','379',14306.99,14306.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177353',3486646,'2504','379',19187.41,20612.61,1404.63,228954.69,0.00,0.00,20.57,0.00,0.00),('1','161','861','177353',3486647,'2505','379',39166.10,40878.53,1712.43,279126.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486648,'2506','379',92330.94,94224.52,1893.58,308653.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486649,'2507','379',79651.06,81634.06,1983.00,323229.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486650,'2508','379',66060.36,67243.63,1183.27,192873.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486651,'2509','379',51139.79,52158.07,1018.28,165979.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486652,'2510','379',69149.60,70459.09,1309.49,213446.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486653,'2511','379',55288.79,56344.36,1035.00,168705.00,0.00,0.00,20.57,0.00,0.00),('1','161','862','177353',3486654,'2512','379',34965.26,36166.62,1201.36,195821.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','177353',3486655,'2513','379',41777.79,41777.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177353',3486656,'2514','380',8568.13,8573.00,4.87,925.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177353',3486657,'2515','380',6719.01,6739.58,0.00,0.00,0.00,0.00,20.57,0.00,0.00),('1','161','861','177381',3487281,'2496','379',31158.31,31158.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487282,'2497','379',45985.10,47368.65,1383.55,225518.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487283,'2498','379',65064.44,67501.54,2437.10,397247.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487284,'2499','379',74014.44,75542.83,1528.39,249127.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487285,'2500','379',59242.10,59864.28,622.18,101415.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487286,'2501','379',22088.42,22088.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487287,'2502','379',34121.19,34872.48,751.29,122460.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487288,'2503','379',14306.99,14825.07,518.08,84447.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487289,'2504','379',20612.61,20612.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177381',3487290,'2505','379',40878.53,42102.69,1224.16,199538.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487291,'2506','379',94224.52,95733.53,1509.01,245968.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487292,'2507','379',81634.06,83187.16,1553.10,253155.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487293,'2508','379',67243.63,68175.28,931.65,151858.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487294,'2509','379',52158.07,53528.80,1370.73,223428.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487295,'2510','379',70459.09,71523.13,1064.04,173438.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487296,'2511','379',56344.36,57367.66,1023.30,166797.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487297,'2512','379',36166.62,36166.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177381',3487298,'2513','379',41777.79,42678.08,900.29,146747.27,0.00,0.00,0.00,0.00,0.00),('1','161','863','177381',3487299,'2514','380',8573.00,8653.39,80.39,15274.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177381',3487300,'2515','380',6739.58,7211.16,471.58,89600.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487361,'2496','379',31158.31,32805.81,1647.50,268542.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487362,'2497','379',47368.65,47368.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487363,'2498','379',67501.54,69310.79,1809.25,294907.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487364,'2499','379',75542.83,77529.25,1986.42,323786.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487365,'2500','379',59864.28,59864.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487366,'2501','379',22088.42,23388.63,1300.21,211934.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487367,'2502','379',34872.48,34872.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487368,'2503','379',14825.07,14825.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487369,'2504','379',20612.61,21363.08,750.47,122326.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','177384',3487370,'2505','379',42102.69,44354.48,2251.79,367041.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487371,'2506','379',95733.53,97480.73,1747.20,284793.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487372,'2507','379',83187.16,84898.24,1711.08,278906.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487373,'2508','379',68175.28,70259.31,2084.03,339696.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487374,'2509','379',53528.80,53528.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487375,'2510','379',71523.13,73660.74,2137.61,348430.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487376,'2511','379',57367.66,58977.60,1609.94,262420.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487377,'2512','379',36166.62,37581.65,1415.03,230649.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','177384',3487378,'2513','379',42678.08,42678.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177384',3487379,'2514','380',8653.39,9298.55,645.16,122580.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','177384',3487380,'2515','380',7211.16,7211.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487381,'2496','379',32805.81,33312.87,507.06,82650.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487382,'2497','379',47368.65,48088.13,719.48,117275.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487383,'2498','379',69310.79,70466.76,1155.97,188423.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487384,'2499','379',77529.25,78708.88,1179.63,192279.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487385,'2500','379',59864.28,61176.03,1311.75,213815.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487386,'2501','379',23388.63,23388.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487387,'2502','379',34872.48,35659.51,787.03,128285.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487388,'2503','379',14825.07,14825.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487389,'2504','379',21363.08,21837.11,474.03,77266.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','177385',3487390,'2505','379',44354.48,45360.99,1006.51,164061.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487391,'2506','379',97480.73,99185.64,1704.91,277900.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487392,'2507','379',84898.24,86292.94,1394.70,227336.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487393,'2508','379',70259.31,71056.53,797.22,129946.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487394,'2509','379',53528.80,55062.24,1533.44,249950.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487395,'2510','379',73660.74,74715.98,1055.24,172004.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487396,'2511','379',58977.60,59844.64,867.04,141327.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487397,'2512','379',37581.65,37581.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177385',3487398,'2513','379',42678.08,43310.25,632.17,103043.71,0.00,0.00,0.00,0.00,0.00),('1','161','863','177385',3487399,'2514','380',9298.55,9393.81,95.26,18099.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','177385',3487400,'2515','380',7211.16,7411.41,200.25,38047.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487444,'2496','379',33312.87,33312.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487445,'2497','379',48088.13,49385.14,1297.01,211412.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487446,'2498','379',70466.76,72182.17,1715.41,279611.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487447,'2499','379',78708.88,80203.76,1494.88,243665.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487448,'2500','379',61176.03,63197.74,2021.71,329538.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487449,'2501','379',23388.63,23805.29,416.66,67915.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487450,'2502','379',35659.51,36422.82,763.31,124419.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487451,'2503','379',14825.07,15488.84,663.77,108194.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487452,'2504','379',21837.11,21837.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177387',3487453,'2505','379',45360.99,45360.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487454,'2506','379',99185.64,101685.52,2479.88,404220.44,0.00,0.00,20.00,0.00,0.00),('1','161','862','177387',3487455,'2507','379',86292.94,88299.62,2006.68,327088.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487456,'2508','379',71056.53,71056.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487457,'2509','379',55062.24,56757.64,1695.40,276350.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487458,'2510','379',74715.98,75996.94,1280.96,208796.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487459,'2511','379',59844.64,60899.81,1055.17,171992.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487460,'2512','379',37581.65,37581.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177387',3487461,'2513','379',43310.25,44162.17,851.92,138862.96,0.00,0.00,0.00,0.00,0.00),('1','161','863','177387',3487462,'2514','380',9393.81,10213.20,819.39,155684.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177387',3487463,'2515','380',7411.41,7458.78,47.37,9000.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487588,'2496','379',33312.87,33337.49,24.62,4013.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487589,'2497','379',49385.14,50174.56,789.42,128675.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487590,'2498','379',72182.17,73576.09,1393.92,227208.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487591,'2499','379',80203.76,81965.41,1761.65,287148.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487592,'2500','379',63197.74,63262.25,64.51,10515.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487593,'2501','379',23805.29,23899.16,93.87,15300.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487594,'2502','379',36422.82,37759.41,1336.59,217864.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487595,'2503','379',15488.84,15488.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487596,'2504','379',21837.11,22136.87,299.76,48860.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','177392',3487597,'2505','379',45360.99,46488.48,1127.49,183780.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487598,'2506','379',101685.52,103293.13,1607.61,262040.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487599,'2507','379',88299.62,90023.70,1724.08,281025.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487600,'2508','379',71056.53,72394.05,1337.52,218015.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487601,'2509','379',56757.64,57627.49,869.85,141785.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487602,'2510','379',75996.94,77075.25,1078.31,175764.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487603,'2511','379',60899.81,62071.78,1171.97,191031.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487604,'2512','379',37581.65,37581.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177392',3487605,'2513','379',44162.17,44919.16,756.99,123389.37,0.00,0.00,0.00,0.00,0.00),('1','161','863','177392',3487606,'2514','380',10213.20,10354.92,141.72,26926.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','177392',3487607,'2515','380',7458.78,7518.95,60.17,11432.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487676,'2496','379',33337.49,35126.16,1788.67,291553.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487677,'2497','379',50174.56,50174.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487678,'2498','379',73576.09,75294.92,1718.83,280169.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487679,'2499','379',81965.41,83926.19,1960.78,319607.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487680,'2500','379',63262.25,64599.54,1337.29,217978.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487681,'2501','379',23899.16,24970.31,1071.15,174597.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487682,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487683,'2503','379',15488.84,16085.27,596.43,97218.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487684,'2504','379',22136.87,22136.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177395',3487685,'2505','379',46488.48,48141.68,1653.20,269471.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487686,'2506','379',103293.13,105129.94,1836.81,299400.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487687,'2507','379',90023.70,91852.77,1809.07,294878.41,0.00,0.00,20.00,0.00,0.00),('1','161','862','177395',3487688,'2508','379',72394.05,73681.88,1287.83,209916.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487689,'2509','379',57627.49,58353.85,726.36,118396.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487690,'2510','379',77075.25,77876.36,801.11,130580.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487691,'2511','379',62071.78,63213.63,1141.85,186121.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487692,'2512','379',37581.65,38836.83,1255.18,204594.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','177395',3487693,'2513','379',44919.16,44919.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177395',3487694,'2514','380',10354.92,10497.56,142.64,27101.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','177395',3487695,'2515','380',7518.95,9830.16,2291.21,435329.90,0.00,0.00,20.00,0.00,0.00),('1','161','861','177422',3488142,'2496','379',35126.16,35137.20,11.04,1799.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488143,'2497','379',50174.56,50200.87,26.31,4288.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488144,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488145,'2499','379',83926.19,83987.00,60.81,9912.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488146,'2500','379',64599.54,64615.67,16.13,2629.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488147,'2501','379',24970.31,24972.14,1.83,298.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488148,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488149,'2503','379',16085.27,16115.33,30.06,4899.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488150,'2504','379',22136.87,22140.48,3.61,588.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','177422',3488151,'2505','379',48141.68,48172.62,30.94,5043.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488152,'2506','379',105129.94,107009.19,1879.25,306317.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488153,'2507','379',91852.77,93654.57,1801.80,293693.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488154,'2508','379',73681.88,75113.72,1431.84,233389.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488155,'2509','379',58353.85,59543.34,1189.49,193886.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488156,'2510','379',77876.36,78963.58,1087.22,177216.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488157,'2511','379',63213.63,64069.39,855.76,139488.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488158,'2512','379',38836.83,39756.74,919.91,149945.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','177422',3488159,'2513','379',44919.16,45665.04,745.88,121578.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','177422',3488160,'2514','380',10497.56,10557.56,60.00,11400.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177422',3488161,'2515','380',9830.16,10282.05,451.89,85859.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488162,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488163,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488164,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488165,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488166,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488167,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488168,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488169,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488170,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177423',3488171,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488172,'2506','379',107009.19,109194.03,2184.84,356128.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488173,'2507','379',93654.57,96120.09,2465.52,401879.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488174,'2508','379',75113.72,76856.07,1742.35,284003.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488175,'2509','379',59543.34,61506.97,1963.63,320071.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488176,'2510','379',78963.58,80705.09,1741.51,283866.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488177,'2511','379',64069.39,65997.20,1927.81,314233.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488178,'2512','379',39756.74,41048.17,1291.43,210503.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','177423',3488179,'2513','379',45665.04,47001.01,1335.97,217763.11,0.00,0.00,0.00,0.00,0.00),('1','161','863','177423',3488180,'2514','380',10557.56,10557.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177423',3488181,'2515','380',10282.05,10855.02,572.97,108864.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494364,'2496','379',35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494365,'2497','379',50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494366,'2498','379',75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494367,'2499','379',83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494368,'2500','379',64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494369,'2501','379',24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494370,'2502','379',37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494371,'2503','379',16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494372,'2504','379',22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177741',3494373,'2505','379',48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494374,'2506','379',109194.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494375,'2507','379',96120.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494376,'2508','379',76856.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494377,'2509','379',61506.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494378,'2510','379',80705.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494379,'2511','379',65997.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494380,'2512','379',41048.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177741',3494381,'2513','379',47001.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177741',3494382,'2514','380',10557.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177741',3494383,'2515','380',10855.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494430,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494431,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494432,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494433,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494434,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494435,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494436,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494437,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494438,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177744',3494439,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494440,'2506','379',109194.03,111732.21,2538.18,408646.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494441,'2507','379',96120.09,97926.45,1806.36,290823.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494442,'2508','379',76856.07,78955.51,2099.44,338009.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494443,'2509','379',61506.97,63229.65,1722.68,277351.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494444,'2510','379',80705.09,82315.14,1610.05,259218.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494445,'2511','379',65997.20,67165.79,1168.59,188142.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494446,'2512','379',41048.17,42077.14,1028.97,165664.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','177744',3494447,'2513','379',47001.01,48612.88,1611.87,259511.07,0.00,0.00,0.00,0.00,0.00),('1','161','863','177744',3494448,'2514','380',10557.56,10702.56,145.00,27550.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177744',3494449,'2515','380',10855.02,11797.45,942.43,179061.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494461,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494462,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494463,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494464,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494465,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494466,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494467,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494468,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494469,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177746',3494470,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494471,'2506','379',111732.21,114144.53,2412.32,388383.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494472,'2507','379',97926.45,100417.83,2491.38,401112.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494473,'2508','379',78955.51,80876.03,1920.52,309203.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494474,'2509','379',63229.65,66147.92,2918.27,469841.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494475,'2510','379',82315.14,84114.17,1799.03,289643.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494476,'2511','379',67165.79,69595.78,2429.99,391228.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494477,'2512','379',42077.14,43803.03,1725.89,277868.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','177746',3494478,'2513','379',48612.88,50846.44,2233.56,359603.16,0.00,0.00,0.00,0.00,0.00),('1','161','863','177746',3494479,'2514','380',10702.56,11990.49,1287.93,244706.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','177746',3494480,'2515','380',11797.45,11797.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494540,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494541,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494542,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494543,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494544,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494545,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494546,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494547,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494548,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177752',3494549,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494550,'2506','379',114144.53,116446.67,2302.14,370644.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494551,'2507','379',100417.83,103059.23,2641.40,425265.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494552,'2508','379',80876.03,83973.77,3097.74,498736.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494553,'2509','379',66147.92,68232.15,2084.23,335561.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494554,'2510','379',84114.17,86043.40,1929.23,310606.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494555,'2511','379',69595.78,71366.05,1770.27,285013.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494556,'2512','379',43803.03,44690.17,887.14,142829.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177752',3494557,'2513','379',50846.44,52949.31,2102.87,338562.07,0.00,0.00,0.00,0.00,0.00),('1','161','863','177752',3494558,'2514','380',11990.49,12309.22,318.73,60558.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','177752',3494559,'2515','380',11797.45,13322.82,1525.37,289820.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494560,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494561,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494562,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494563,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494564,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494565,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494566,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494567,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494568,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177753',3494569,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494570,'2506','379',116446.67,119520.20,3073.53,494838.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494571,'2507','379',103059.23,106442.99,3383.76,544785.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494572,'2508','379',83973.77,86499.07,2525.30,406573.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494573,'2509','379',68232.15,70511.90,2279.75,367039.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494574,'2510','379',86043.40,88670.25,2626.85,422922.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494575,'2511','379',71366.05,72916.60,1550.55,249638.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494576,'2512','379',44690.17,46693.51,2003.34,322537.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','177753',3494577,'2513','379',52949.31,54820.53,1871.22,301266.42,0.00,0.00,0.00,0.00,0.00),('1','161','863','177753',3494578,'2514','380',12309.22,13140.80,811.58,154200.20,0.00,0.00,20.00,0.00,0.00),('1','161','863','177753',3494579,'2515','380',13322.82,15506.49,2183.67,414897.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494665,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494666,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494667,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494668,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494669,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494670,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494671,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494672,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494673,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177759',3494674,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494675,'2506','379',119520.20,121836.34,2316.14,372898.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494676,'2507','379',106442.99,109824.03,3381.04,544347.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494677,'2508','379',86499.07,88654.30,2155.23,346992.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494678,'2509','379',70511.90,73016.32,2504.42,403211.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494679,'2510','379',88670.25,90153.73,1483.48,238840.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494680,'2511','379',72916.60,74910.03,1993.43,320942.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494681,'2512','379',46693.51,48225.58,1532.07,246663.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','177759',3494682,'2513','379',54820.53,56530.84,1710.31,275359.91,0.00,0.00,0.00,0.00,0.00),('1','161','863','177759',3494683,'2514','380',13140.80,15011.39,1870.59,355412.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177759',3494684,'2515','380',15506.49,15690.70,184.21,34999.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495121,'2496','379',35137.20,35137.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495122,'2497','379',50200.87,50200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495123,'2498','379',75294.92,75294.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495124,'2499','379',83987.00,83987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495125,'2500','379',64615.67,64615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495126,'2501','379',24972.14,24972.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495127,'2502','379',37759.41,37759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495128,'2503','379',16115.33,16115.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495129,'2504','379',22140.48,22140.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177784',3495130,'2505','379',48172.62,48172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495131,'2506','379',121836.34,124557.47,2721.13,438101.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495132,'2507','379',109824.03,112234.17,2410.14,388032.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495133,'2508','379',88654.30,91378.27,2723.97,438559.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495134,'2509','379',73016.32,75563.70,2547.38,410128.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495135,'2510','379',90153.73,92359.40,2205.67,355112.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495136,'2511','379',74910.03,76860.88,1950.85,314086.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495137,'2512','379',48225.58,50282.32,2056.74,331135.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','177784',3495138,'2513','379',56530.84,58106.76,1575.92,253723.12,0.00,0.00,0.00,0.00,0.00),('1','161','863','177784',3495139,'2514','380',15011.39,15011.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177784',3495140,'2515','380',15690.70,16759.56,1068.86,203083.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495180,'2496','379',35137.20,35883.73,746.53,120191.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495181,'2497','379',50200.87,51040.85,839.98,135236.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495182,'2498','379',75294.92,76300.58,1005.66,161911.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495183,'2499','379',83987.00,85166.16,1179.16,189844.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495184,'2500','379',64615.67,65556.01,940.34,151394.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495185,'2501','379',24972.14,25503.47,531.33,85544.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495186,'2502','379',37759.41,38254.05,494.64,79637.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','177787',3495187,'2503','379',16115.33,16585.22,459.89,74042.29,0.00,0.00,10.00,0.00,0.00),('1','161','861','177787',3495188,'2504','379',22140.48,22674.64,524.16,84389.76,0.00,0.00,10.00,0.00,0.00),('1','161','861','177787',3495189,'2505','379',48172.62,48726.27,553.65,89137.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495190,'2506','379',124557.47,124557.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495191,'2507','379',112234.17,112234.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495192,'2508','379',91378.27,91378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495193,'2509','379',75563.70,75563.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495194,'2510','379',92359.40,92359.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495195,'2511','379',76860.88,76860.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495196,'2512','379',50282.32,50282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177787',3495197,'2513','379',58106.76,58106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177787',3495198,'2514','380',15011.39,15358.76,347.37,66000.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177787',3495199,'2515','380',16759.56,17576.99,817.43,155311.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495204,'2496','379',35883.73,38283.52,2399.79,386366.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495205,'2497','379',51040.85,52892.71,1851.86,298149.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495206,'2498','379',76300.58,79250.47,2949.89,474932.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495207,'2499','379',85166.16,87232.89,2066.73,332743.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495208,'2500','379',65556.01,67739.12,2183.11,351480.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495209,'2501','379',25503.47,26956.57,1453.10,233949.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495210,'2502','379',38254.05,40504.41,2250.36,362307.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495211,'2503','379',16585.22,18168.14,1582.92,254850.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495212,'2504','379',22674.64,23920.09,1245.45,200517.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','177790',3495213,'2505','379',48726.27,50138.16,1411.89,227314.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495214,'2506','379',124557.47,124557.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495215,'2507','379',112234.17,112234.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495216,'2508','379',91378.27,91378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495217,'2509','379',75563.70,75563.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495218,'2510','379',92359.40,92359.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495219,'2511','379',76860.88,76860.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495220,'2512','379',50282.32,50282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177790',3495221,'2513','379',58106.76,58106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177790',3495222,'2514','380',15358.76,16890.83,1532.07,291093.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177790',3495223,'2515','380',17576.99,17576.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495673,'2496','379',38283.52,39350.26,1066.74,171745.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495674,'2497','379',52892.71,55289.78,2397.07,385928.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495675,'2498','379',79250.47,80783.25,1532.78,246777.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495676,'2499','379',87232.89,88924.21,1691.32,272302.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495677,'2500','379',67739.12,69251.26,1512.14,243454.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495678,'2501','379',26956.57,28044.46,1087.89,175150.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495679,'2502','379',40504.41,41520.90,1016.49,163654.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495680,'2503','379',18168.14,19003.32,835.18,134463.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495681,'2504','379',23920.09,25650.68,1730.59,278624.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','177814',3495682,'2505','379',50138.16,51641.95,1503.79,242110.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495683,'2506','379',124557.47,124557.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495684,'2507','379',112234.17,112234.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495685,'2508','379',91378.27,91378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495686,'2509','379',75563.70,75563.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495687,'2510','379',92359.40,92359.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495688,'2511','379',76860.88,76860.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495689,'2512','379',50282.32,50282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177814',3495690,'2513','379',58106.76,58106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177814',3495691,'2514','380',16890.83,17099.25,208.42,39599.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','177814',3495692,'2515','380',17576.99,17576.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495818,'2496','379',39350.26,41898.25,2547.99,410226.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495819,'2497','379',55289.78,57031.24,1741.46,280375.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495820,'2498','379',80783.25,82920.89,2137.64,344160.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495821,'2499','379',88924.21,91730.76,2806.55,451854.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495822,'2500','379',69251.26,71114.33,1863.07,299954.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495823,'2501','379',28044.46,29707.80,1663.34,267797.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495824,'2502','379',41520.90,43014.14,1493.24,240411.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495825,'2503','379',19003.32,20253.09,1249.77,201212.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495826,'2504','379',25650.68,27303.14,1652.46,266046.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','177821',3495827,'2505','379',51641.95,53618.31,1976.36,318193.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495828,'2506','379',124557.47,124557.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495829,'2507','379',112234.17,112234.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495830,'2508','379',91378.27,91378.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495831,'2509','379',75563.70,75563.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495832,'2510','379',92359.40,92359.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495833,'2511','379',76860.88,76860.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495834,'2512','379',50282.32,50282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177821',3495835,'2513','379',58106.76,58106.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177821',3495836,'2514','380',17099.25,17860.83,761.58,144700.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','177821',3495837,'2515','380',17576.99,17576.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495902,'2496','379',41898.25,41898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495903,'2497','379',57031.24,58423.05,1391.81,224081.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495904,'2498','379',82920.89,83853.12,932.23,150089.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495905,'2499','379',91730.76,92812.43,1081.67,174148.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495906,'2500','379',71114.33,72065.54,951.21,153144.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495907,'2501','379',29707.80,30510.90,803.10,129299.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495908,'2502','379',43014.14,43014.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495909,'2503','379',20253.09,20253.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495910,'2504','379',27303.14,27722.54,419.40,67523.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','177825',3495911,'2505','379',53618.31,54378.11,759.80,122327.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495912,'2506','379',124557.47,125961.48,1404.01,226045.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495913,'2507','379',112234.17,113468.49,1234.32,198725.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495914,'2508','379',91378.27,92874.09,1495.82,240827.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495915,'2509','379',75563.70,75563.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495916,'2510','379',92359.40,93161.14,801.74,129080.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495917,'2511','379',76860.88,77907.65,1046.77,168529.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495918,'2512','379',50282.32,50282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177825',3495919,'2513','379',58106.76,58909.90,803.14,129305.54,0.00,0.00,0.00,0.00,0.00),('1','161','863','177825',3495920,'2514','380',17860.83,18034.52,173.69,33001.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177825',3495921,'2515','380',17576.99,18953.98,1376.99,261628.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495938,'2496','379',41898.25,42897.86,999.61,160937.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495939,'2497','379',58423.05,58423.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495940,'2498','379',83853.12,84971.54,1118.42,180065.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495941,'2499','379',92812.43,94051.81,1239.38,199540.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495942,'2500','379',72065.54,73430.79,1365.25,219805.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495943,'2501','379',30510.90,31256.55,745.65,120049.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495944,'2502','379',43014.14,43014.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495945,'2503','379',20253.09,20469.09,216.00,34776.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495946,'2504','379',27722.54,27722.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177828',3495947,'2505','379',54378.11,55376.49,998.38,160739.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495948,'2506','379',125961.48,127769.17,1807.69,291038.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495949,'2507','379',113468.49,115072.09,1603.60,258179.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495950,'2508','379',92874.09,93855.02,980.93,157929.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495951,'2509','379',75563.70,76744.21,1180.51,190062.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495952,'2510','379',93161.14,94107.90,946.76,152428.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495953,'2511','379',77907.65,78473.87,566.22,91161.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495954,'2512','379',50282.32,51310.70,1028.38,165569.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','177828',3495955,'2513','379',58909.90,58909.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177828',3495956,'2514','380',18034.52,18844.49,809.97,153894.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','177828',3495957,'2515','380',18953.98,19153.98,200.00,38000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495990,'2496','379',42897.86,42987.04,89.18,14357.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495991,'2497','379',58423.05,59397.77,974.72,156929.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495992,'2498','379',84971.54,86123.69,1152.15,185496.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495993,'2499','379',94051.81,95474.52,1422.71,229056.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495994,'2500','379',73430.79,74578.74,1147.95,184819.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495995,'2501','379',31256.55,31909.47,652.92,105120.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495996,'2502','379',43014.14,43014.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495997,'2503','379',20469.09,20469.33,0.24,38.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495998,'2504','379',27722.54,27901.86,179.32,28870.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','177830',3495999,'2505','379',55376.49,56114.40,737.91,118803.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496000,'2506','379',127769.17,129194.80,1409.63,226950.43,0.00,0.00,16.00,0.00,0.00),('1','161','862','177830',3496001,'2507','379',115072.09,115485.98,413.89,66636.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496002,'2508','379',93855.02,94900.14,1045.12,168264.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496003,'2509','379',76744.21,77805.30,1061.09,170835.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496004,'2510','379',94107.90,94860.15,752.25,121112.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496005,'2511','379',78473.87,79162.37,688.50,110848.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496006,'2512','379',51310.70,52136.75,826.05,132994.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','177830',3496007,'2513','379',58909.90,58909.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177830',3496008,'2514','380',18844.49,18844.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177830',3496009,'2515','380',19153.98,20308.41,1154.43,219341.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496044,'2496','379',42987.04,43133.58,146.54,23592.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496045,'2497','379',59397.77,60423.63,1025.86,165163.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496046,'2498','379',86123.69,87246.52,1122.83,180775.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496047,'2499','379',95474.52,97036.91,1562.39,251544.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496048,'2500','379',74578.74,74754.42,175.68,28284.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496049,'2501','379',31909.47,32158.09,248.62,40027.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496050,'2502','379',43014.14,43889.49,875.35,140931.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496051,'2503','379',20469.33,20986.03,516.70,83188.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496052,'2504','379',27901.86,27901.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177832',3496053,'2505','379',56114.40,58147.87,2033.47,327388.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496054,'2506','379',129194.80,130797.03,1602.23,257959.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496055,'2507','379',115485.98,117253.68,1767.70,284599.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496056,'2508','379',94900.14,96164.46,1264.32,203555.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496057,'2509','379',77805.30,78870.85,1065.55,171553.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496058,'2510','379',94860.15,95773.88,913.73,147110.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496059,'2511','379',79162.37,79937.16,774.79,124741.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496060,'2512','379',52136.75,52136.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177832',3496061,'2513','379',58909.90,60510.06,1600.16,257625.76,0.00,0.00,0.00,0.00,0.00),('1','161','863','177832',3496062,'2514','380',18844.49,19482.38,637.89,121199.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','177832',3496063,'2515','380',20308.41,20308.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177840',3496164,'2496','379',43133.58,43888.86,715.28,115160.08,0.00,0.00,40.00,0.00,0.00),('1','161','861','177840',3496165,'2497','379',60423.63,60423.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177840',3496166,'2498','379',87246.52,88672.03,1395.51,224677.11,0.00,0.00,30.00,0.00,0.00),('1','161','861','177840',3496167,'2499','379',97036.91,98093.20,1016.29,163622.69,0.00,0.00,40.00,0.00,0.00),('1','161','861','177840',3496168,'2500','379',74754.42,76138.84,1354.42,218061.62,0.00,0.00,30.00,0.00,0.00),('1','161','861','177840',3496169,'2501','379',32158.09,32158.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177840',3496170,'2502','379',43889.49,44709.27,779.78,125544.58,0.00,0.00,40.00,0.00,0.00),('1','161','861','177840',3496171,'2503','379',20986.03,21228.02,201.99,32520.39,0.00,0.00,40.00,0.00,0.00),('1','161','861','177840',3496172,'2504','379',27901.86,27901.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177840',3496173,'2505','379',58147.87,59231.65,1053.78,169658.58,0.00,0.00,30.00,0.00,0.00),('1','161','862','177840',3496174,'2506','379',130797.03,132218.06,1391.03,223955.83,0.00,0.00,30.00,0.00,0.00),('1','161','862','177840',3496175,'2507','379',117253.68,118507.52,1223.84,197038.24,0.00,0.00,30.00,0.00,0.00),('1','161','862','177840',3496176,'2508','379',96164.46,97459.68,1270.57,204561.77,0.00,0.00,24.65,0.00,0.00),('1','161','862','177840',3496177,'2509','379',78870.85,79537.26,636.41,102462.01,0.00,0.00,30.00,0.00,0.00),('1','161','862','177840',3496178,'2510','379',95773.88,96784.97,971.09,156345.49,0.00,0.00,40.00,0.00,0.00),('1','161','862','177840',3496179,'2511','379',79937.16,80665.80,698.64,112481.04,0.00,0.00,30.00,0.00,0.00),('1','161','862','177840',3496180,'2512','379',52136.75,52142.96,0.00,0.00,0.00,0.00,6.21,0.00,0.00),('1','161','862','177840',3496181,'2513','379',60510.06,61366.83,826.77,133109.97,0.00,0.00,30.00,0.00,0.00),('1','161','863','177840',3496182,'2514','380',19482.38,20775.80,1223.42,232449.80,0.00,0.00,70.00,0.00,0.00),('1','161','863','177840',3496183,'2515','380',20308.41,22761.32,2372.91,450852.90,0.00,0.00,80.00,0.00,0.00),('1','161','861','177845',3496246,'2496','379',43888.86,43888.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496247,'2497','379',60423.63,61996.84,1573.21,253286.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496248,'2498','379',88672.03,90628.29,1956.26,314957.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496249,'2499','379',98093.20,100081.04,1987.84,320042.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496250,'2500','379',76138.84,78259.40,2120.56,341410.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496251,'2501','379',32158.09,33394.14,1236.05,199004.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496252,'2502','379',44709.27,44709.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496253,'2503','379',21228.02,21228.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496254,'2504','379',27901.86,28386.91,485.05,78093.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','177845',3496255,'2505','379',59231.65,59231.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496256,'2506','379',132218.06,134130.87,1912.81,307962.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496257,'2507','379',118507.52,120513.46,2005.94,322956.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496258,'2508','379',97459.68,99720.64,2260.96,364014.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496259,'2509','379',79537.26,80864.61,1327.35,213703.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496260,'2510','379',96784.97,98080.29,1295.32,208546.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496261,'2511','379',80665.80,81805.24,1098.30,176826.30,0.00,0.00,41.14,0.00,0.00),('1','161','862','177845',3496262,'2512','379',52142.96,53437.51,1294.55,208422.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','177845',3496263,'2513','379',61366.83,61366.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177845',3496264,'2514','380',20775.80,22260.79,1464.99,278348.10,0.00,0.00,20.00,0.00,0.00),('1','161','863','177845',3496265,'2515','380',22761.32,22761.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496268,'2496','379',43888.86,43888.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496269,'2497','379',61996.84,62758.86,762.02,122685.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496270,'2498','379',90628.29,91959.64,1331.35,214347.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496271,'2499','379',100081.04,101536.79,1455.75,234375.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496272,'2500','379',78259.40,79601.64,1342.24,216100.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496273,'2501','379',33394.14,33394.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496274,'2502','379',44709.27,45744.13,1034.86,166612.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496275,'2503','379',21228.02,21228.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496276,'2504','379',28386.91,29043.33,656.42,105683.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','177847',3496277,'2505','379',59231.65,60445.99,1214.34,195508.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496278,'2506','379',134130.87,135610.68,1479.81,238249.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496279,'2507','379',120513.46,121962.08,1448.62,233227.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496280,'2508','379',99720.64,101204.11,1483.47,238838.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496281,'2509','379',80864.61,81884.99,1020.38,164281.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496282,'2510','379',98080.29,99069.07,988.78,159193.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496283,'2511','379',81805.24,82630.96,825.72,132940.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496284,'2512','379',53437.51,53437.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177847',3496285,'2513','379',61366.83,62215.83,849.00,136689.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177847',3496286,'2514','380',22260.79,22320.79,60.00,11400.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177847',3496287,'2515','380',22761.32,22761.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496322,'2496','379',43888.86,45485.63,1596.77,257079.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496323,'2497','379',62758.86,62758.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496324,'2498','379',91959.64,94356.86,2397.22,385952.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496325,'2499','379',101536.79,101867.62,330.83,53263.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496326,'2500','379',79601.64,79601.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496327,'2501','379',33394.14,35011.26,1617.12,260356.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496328,'2502','379',45744.13,45744.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496329,'2503','379',21228.02,22857.71,1629.69,262380.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496330,'2504','379',29043.33,29047.68,4.35,700.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','177849',3496331,'2505','379',60445.99,62478.08,2032.09,327166.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496332,'2506','379',135610.68,137378.43,1767.75,284607.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496333,'2507','379',121962.08,124225.42,2263.34,364397.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496334,'2508','379',101204.11,102475.26,1271.15,204655.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496335,'2509','379',81884.99,83304.58,1419.59,228553.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496336,'2510','379',99069.07,100459.85,1390.78,223915.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496337,'2511','379',82630.96,84198.53,1567.57,252378.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496338,'2512','379',53437.51,54980.67,1543.16,248448.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','177849',3496339,'2513','379',62215.83,62368.35,152.52,24555.72,0.00,0.00,0.00,0.00,0.00),('1','161','863','177849',3496340,'2514','380',22320.79,22320.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177849',3496341,'2515','380',22761.32,22761.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496342,'2496','379',45485.63,45485.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496343,'2497','379',62758.86,64233.40,1474.54,237400.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496344,'2498','379',94356.86,96061.95,1705.09,274519.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496345,'2499','379',101867.62,103569.67,1702.05,274030.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496346,'2500','379',79601.64,80782.87,1181.23,190178.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496347,'2501','379',35011.26,35011.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496348,'2502','379',45744.13,46433.59,689.46,111003.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496349,'2503','379',22857.71,23274.43,416.72,67091.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496350,'2504','379',29047.68,29047.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177850',3496351,'2505','379',62478.08,63494.88,1016.80,163704.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496352,'2506','379',137378.43,138905.46,1527.03,245851.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496353,'2507','379',124225.42,126138.92,1913.50,308073.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496354,'2508','379',102475.26,103444.29,969.03,156013.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496355,'2509','379',83304.58,84376.57,1071.99,172590.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496356,'2510','379',100459.85,101354.67,894.82,144066.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496357,'2511','379',84198.53,85182.23,983.70,158375.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496358,'2512','379',54980.67,54980.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177850',3496359,'2513','379',62368.35,63271.59,903.24,145421.64,0.00,0.00,0.00,0.00,0.00),('1','161','863','177850',3496360,'2514','380',22320.79,22340.79,20.00,3800.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177850',3496361,'2515','380',22761.32,23021.32,260.00,49400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496362,'2496','379',45485.63,47061.31,1575.68,253684.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496363,'2497','379',64233.40,64233.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496364,'2498','379',96061.95,98183.68,2121.73,341598.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496365,'2499','379',103569.67,105509.34,1939.67,312286.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496366,'2500','379',80782.87,83799.71,3016.84,485711.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496367,'2501','379',35011.26,36327.76,1316.50,211956.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496368,'2502','379',46433.59,46433.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496369,'2503','379',23274.43,23274.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496370,'2504','379',29047.68,30173.36,1125.68,181234.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','177851',3496371,'2505','379',63494.88,63494.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496372,'2506','379',138905.46,141036.47,2131.01,343092.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496373,'2507','379',126138.92,129413.60,3274.68,527223.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496374,'2508','379',103444.29,105469.16,2024.87,326004.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496375,'2509','379',84376.57,86444.61,2068.04,332954.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496376,'2510','379',101354.67,102676.41,1321.74,212800.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496377,'2511','379',85182.23,86812.85,1630.62,262529.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496378,'2512','379',54980.67,56446.33,1465.66,235971.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','177851',3496379,'2513','379',63271.59,63842.64,571.05,91939.05,0.00,0.00,0.00,0.00,0.00),('1','161','863','177851',3496380,'2514','380',22340.79,22355.79,15.00,2850.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','177851',3496381,'2515','380',23021.32,23021.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501293,'2496','379',47061.31,47531.31,470.00,75670.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501294,'2497','379',64233.40,64342.34,108.94,17539.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501295,'2498','379',98183.68,98739.33,555.65,89459.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501296,'2499','379',105509.34,107046.59,1537.25,247497.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501297,'2500','379',83799.71,85113.68,1313.97,211549.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501298,'2501','379',36327.76,36327.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501299,'2502','379',46433.59,46732.11,298.52,48061.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501300,'2503','379',23274.43,23541.42,266.99,42985.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501301,'2504','379',30173.36,30173.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178112',3501302,'2505','379',63494.88,63824.51,329.63,53070.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501303,'2506','379',141036.47,142556.19,1519.72,244674.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501304,'2507','379',129413.60,130053.21,639.61,102977.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501305,'2508','379',105469.16,106183.51,714.35,115010.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501306,'2509','379',86444.61,86913.08,468.47,75423.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501307,'2510','379',102676.41,103164.77,488.36,78625.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501308,'2511','379',86812.85,88019.08,1206.23,194203.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501309,'2512','379',56446.33,56446.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178112',3501310,'2513','379',63842.64,64133.76,291.12,46870.32,0.00,0.00,0.00,0.00,0.00),('1','161','863','178112',3501311,'2514','380',22355.79,22360.79,5.00,950.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178112',3501312,'2515','380',23021.32,23031.34,10.02,1903.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501406,'2496','379',47531.31,48850.64,1319.33,212412.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501407,'2497','379',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501408,'2498','379',98739.33,101228.13,2488.80,400696.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501409,'2499','379',107046.59,107055.87,9.28,1494.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501410,'2500','379',85113.68,87785.87,2672.19,430222.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501411,'2501','379',36327.76,36327.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501412,'2502','379',46732.11,47103.78,371.67,59838.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501413,'2503','379',23541.42,23541.53,0.11,17.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501414,'2504','379',30173.36,30173.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178117',3501415,'2505','379',63824.51,63824.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501416,'2506','379',142556.19,145503.90,2947.71,474581.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501417,'2507','379',130053.21,130460.26,407.05,65535.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501418,'2508','379',106183.51,107645.49,1461.98,235378.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501419,'2509','379',86913.08,87727.94,814.86,131192.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501420,'2510','379',103164.77,103164.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501421,'2511','379',88019.08,90446.88,2427.80,390875.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501422,'2512','379',56446.33,56928.78,482.45,77674.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','178117',3501423,'2513','379',64133.76,64719.12,585.36,94242.96,0.00,0.00,0.00,0.00,0.00),('1','161','863','178117',3501424,'2514','380',22360.79,22360.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178117',3501425,'2515','380',23031.34,23281.34,250.00,47500.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501521,'2496','379',48850.64,49323.27,472.63,76093.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501522,'2497','379',64342.34,64342.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501523,'2498','379',101228.13,102075.66,847.53,136452.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501524,'2499','379',107055.87,108034.21,978.34,157512.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501525,'2500','379',87785.87,88660.94,875.07,140886.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501526,'2501','379',36327.76,36327.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501527,'2502','379',47103.78,47757.17,653.39,105195.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501528,'2503','379',23541.53,23541.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501529,'2504','379',30173.36,30173.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178123',3501530,'2505','379',63824.51,64703.15,878.64,141461.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501531,'2506','379',145503.90,147085.09,1541.19,248131.59,0.00,0.00,40.00,0.00,0.00),('1','161','862','178123',3501532,'2507','379',130460.26,131195.16,734.90,118318.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501533,'2508','379',107645.49,108688.87,1043.38,167984.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501534,'2509','379',87727.94,88482.73,754.79,121521.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501535,'2510','379',103164.77,103719.30,554.53,89279.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501536,'2511','379',90446.88,91268.38,821.50,132261.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501537,'2512','379',56928.78,56928.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178123',3501538,'2513','379',64719.12,65253.12,534.00,85974.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178123',3501539,'2514','380',22360.79,22420.79,60.00,11400.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178123',3501540,'2515','380',23281.34,23281.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501575,'2496','379',49323.27,49444.68,121.41,19547.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501576,'2497','379',64342.34,66377.25,2034.91,327620.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501577,'2498','379',102075.66,103629.09,1553.43,250102.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501578,'2499','379',108034.21,109346.58,1312.37,211291.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501579,'2500','379',88660.94,89978.27,1317.33,212090.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501580,'2501','379',36327.76,37083.89,756.13,121736.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501581,'2502','379',47757.17,47757.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501582,'2503','379',23541.53,23541.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501583,'2504','379',30173.36,30905.39,732.03,117856.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','178126',3501584,'2505','379',64703.15,65944.46,1241.31,199850.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501585,'2506','379',147085.09,148648.01,1562.92,251630.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501586,'2507','379',131195.16,132757.88,1562.72,251597.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501587,'2508','379',108688.87,109002.49,313.62,50492.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501588,'2509','379',88482.73,89892.80,1410.07,227021.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501589,'2510','379',103719.30,103719.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501590,'2511','379',91268.38,92871.41,1603.03,258087.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501591,'2512','379',56928.78,57933.75,1004.97,161800.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178126',3501592,'2513','379',65253.12,65253.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178126',3501593,'2514','380',22420.79,22420.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178126',3501594,'2515','380',23281.34,23281.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501705,'2496','379',49444.68,49444.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501706,'2497','379',66377.25,67446.40,1069.15,172133.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501707,'2498','379',103629.09,104416.83,787.74,126826.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501708,'2499','379',109346.58,110679.09,1332.51,214534.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501709,'2500','379',89978.27,90854.77,876.50,141116.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501710,'2501','379',37083.89,37083.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501711,'2502','379',47757.17,48700.56,943.39,151885.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501712,'2503','379',23541.53,23541.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501713,'2504','379',30905.39,31343.27,437.88,70498.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178130',3501714,'2505','379',65944.46,66771.19,826.73,133103.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501715,'2506','379',148648.01,150100.92,1452.91,233918.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501716,'2507','379',132757.88,133584.81,826.93,133135.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501717,'2508','379',109002.49,109860.45,857.96,138131.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501718,'2509','379',89892.80,89892.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501719,'2510','379',103719.30,104574.25,854.95,137646.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501720,'2511','379',92871.41,93454.74,583.33,93916.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501721,'2512','379',57933.75,58617.68,683.93,110112.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','178130',3501722,'2513','379',65253.12,65253.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178130',3501723,'2514','380',22420.79,22460.79,40.00,7600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178130',3501724,'2515','380',23281.34,23291.34,10.00,1900.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501761,'2496','379',49444.68,50594.66,1149.98,185146.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501762,'2497','379',67446.40,67446.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501763,'2498','379',104416.83,105714.24,1297.41,208883.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501764,'2499','379',110679.09,112264.32,1585.23,255222.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501765,'2500','379',90854.77,92845.79,1991.02,320554.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501766,'2501','379',37083.89,37901.70,797.81,128447.41,0.00,0.00,20.00,0.00,0.00),('1','161','861','178133',3501767,'2502','379',48700.56,48700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501768,'2503','379',23541.53,24165.95,624.42,100531.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501769,'2504','379',31343.27,31343.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178133',3501770,'2505','379',66771.19,66789.28,18.09,2912.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501771,'2506','379',150100.92,152241.91,2140.99,344699.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501772,'2507','379',133584.81,134967.56,1382.75,222622.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501773,'2508','379',109860.45,111021.19,1160.74,186879.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501774,'2509','379',89892.80,91082.96,1190.16,191615.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501775,'2510','379',104574.25,105458.19,883.94,142314.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501776,'2511','379',93454.74,94079.44,624.70,100576.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501777,'2512','379',58617.68,58617.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178133',3501778,'2513','379',65253.12,66258.86,974.11,156831.71,0.00,0.00,31.63,0.00,0.00),('1','161','863','178133',3501779,'2514','380',22460.79,22460.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178133',3501780,'2515','380',23291.34,23291.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501845,'2496','379',50594.66,50594.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501846,'2497','379',67446.40,68576.80,1130.40,181994.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501847,'2498','379',105714.24,107595.59,1881.35,302897.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501848,'2499','379',112264.32,112264.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501849,'2500','379',92845.79,94065.24,1219.45,196331.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501850,'2501','379',37901.70,38578.58,676.88,108977.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501851,'2502','379',48700.56,48700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501852,'2503','379',24165.95,24165.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501853,'2504','379',31343.27,31677.05,333.78,53738.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','178138',3501854,'2505','379',66789.28,66796.73,7.45,1199.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501855,'2506','379',152241.91,154083.99,1842.08,296574.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501856,'2507','379',134967.56,136242.04,1274.48,205191.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501857,'2508','379',111021.19,111832.06,810.87,130550.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501858,'2509','379',91082.96,92041.60,958.64,154341.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501859,'2510','379',105458.19,106250.17,791.98,127508.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501860,'2511','379',94079.44,94868.98,789.54,127115.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501861,'2512','379',58617.68,58617.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178138',3501862,'2513','379',66258.86,66813.51,554.65,89298.65,0.00,0.00,0.00,0.00,0.00),('1','161','863','178138',3501863,'2514','380',22460.79,22460.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178138',3501864,'2515','380',23291.34,23655.34,364.00,69160.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501917,'2496','379',50594.66,51571.99,977.33,157350.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501918,'2497','379',68576.80,68576.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501919,'2498','379',107595.59,109386.96,1791.37,288410.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501920,'2499','379',112264.32,113866.25,1601.93,257910.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501921,'2500','379',94065.24,95624.28,1559.04,251005.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501922,'2501','379',38578.58,38578.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501923,'2502','379',48700.56,49813.74,1113.18,179221.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501924,'2503','379',24165.95,24165.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501925,'2504','379',31677.05,32205.26,528.21,85041.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','178143',3501926,'2505','379',66796.73,67306.44,509.71,82063.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501927,'2506','379',154083.99,155630.64,1546.65,249010.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501928,'2507','379',136242.04,137838.87,1596.83,257089.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501929,'2508','379',111832.06,112890.41,1058.35,170394.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501930,'2509','379',92041.60,93175.69,1134.09,182588.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501931,'2510','379',106250.17,107385.74,1135.57,182826.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501932,'2511','379',94868.98,95890.95,1021.97,164537.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178143',3501933,'2512','379',58617.68,59672.10,988.87,159208.07,0.00,0.00,65.55,0.00,0.00),('1','161','862','178143',3501934,'2513','379',66813.51,66813.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178143',3501935,'2514','380',22460.79,22460.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178143',3501936,'2515','380',23655.34,23655.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501971,'2496','379',51571.99,52406.48,834.49,134352.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501972,'2497','379',68576.80,68581.15,4.35,700.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501973,'2498','379',109386.96,110748.09,1361.13,219141.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501974,'2499','379',113866.25,115511.50,1645.25,264885.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501975,'2500','379',95624.28,96727.68,1103.40,177647.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501976,'2501','379',38578.58,39175.54,596.96,96110.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501977,'2502','379',49813.74,49813.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501978,'2503','379',24165.95,24165.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501979,'2504','379',32205.26,32706.68,501.42,80728.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','178145',3501980,'2505','379',67306.44,67956.74,650.30,104698.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501981,'2506','379',155630.64,157278.52,1627.88,262088.68,0.00,0.00,20.00,0.00,0.00),('1','161','862','178145',3501982,'2507','379',137838.87,137838.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501983,'2508','379',112890.41,113940.90,1050.49,169128.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501984,'2509','379',93175.69,94031.68,855.99,137814.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501985,'2510','379',107385.74,107991.71,605.97,97561.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501986,'2511','379',95890.95,96564.99,674.04,108520.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501987,'2512','379',59672.10,60181.98,509.88,82090.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','178145',3501988,'2513','379',66813.51,66813.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178145',3501989,'2514','380',22460.79,22460.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178145',3501990,'2515','380',23655.34,24253.77,598.43,113701.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502046,'2496','379',52406.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502047,'2497','379',68581.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502048,'2498','379',110748.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502049,'2499','379',115511.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502050,'2500','379',96727.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502051,'2501','379',39175.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502052,'2502','379',49813.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502053,'2503','379',24165.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502054,'2504','379',32706.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178149',3502055,'2505','379',67956.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502056,'2506','379',157278.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502057,'2507','379',137838.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502058,'2508','379',113940.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502059,'2509','379',94031.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502060,'2510','379',107991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502061,'2511','379',96564.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502062,'2512','379',60181.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178149',3502063,'2513','379',66813.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178149',3502064,'2514','380',22460.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178149',3502065,'2515','380',24253.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502210,'2496','379',52406.48,52406.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502211,'2497','379',68581.15,69443.02,861.87,137899.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502212,'2498','379',110748.09,111980.73,1232.64,197222.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502213,'2499','379',115511.50,116577.27,1065.77,170523.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502214,'2500','379',96727.68,98193.14,1465.46,234473.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502215,'2501','379',39175.54,39175.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502216,'2502','379',49813.74,50861.44,1047.70,167632.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502217,'2503','379',24165.95,24664.11,498.16,79705.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502218,'2504','379',32706.68,32706.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178156',3502219,'2505','379',67956.74,68693.44,736.70,117872.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502220,'2506','379',157278.52,158344.55,1046.03,167364.80,0.00,0.00,20.00,0.00,0.00),('1','161','862','178156',3502221,'2507','379',137838.87,139633.12,1794.25,287080.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502222,'2508','379',113940.90,114982.92,1042.02,166723.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502223,'2509','379',94031.68,94866.06,834.38,133500.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502224,'2510','379',107991.71,108785.31,793.60,126976.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502225,'2511','379',96564.99,97390.56,825.57,132091.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502226,'2512','379',60181.98,60197.29,15.31,2449.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178156',3502227,'2513','379',66813.51,67606.27,792.76,126841.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','178156',3502228,'2514','380',22460.79,23008.17,547.38,104002.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','178156',3502229,'2515','380',24253.77,24435.82,182.05,34589.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502332,'2496','379',52406.48,53224.03,817.55,130808.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502333,'2497','379',69443.02,69443.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502334,'2498','379',111980.73,113095.27,1114.54,178326.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502335,'2499','379',116577.27,117632.61,1055.34,168854.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502336,'2500','379',98193.14,99172.10,978.96,156633.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502337,'2501','379',39175.54,39175.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502338,'2502','379',50861.44,51310.34,448.90,71824.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502339,'2503','379',24664.11,24664.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502340,'2504','379',32706.68,32895.38,188.70,30192.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178161',3502341,'2505','379',68693.44,69338.41,644.97,103195.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502342,'2506','379',158344.55,159567.11,1222.56,195609.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502343,'2507','379',139633.12,141106.36,1473.24,235718.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502344,'2508','379',114982.92,115663.38,680.46,108873.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502345,'2509','379',94866.06,95793.33,927.27,148363.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502346,'2510','379',108785.31,109578.19,792.88,126860.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502347,'2511','379',97390.56,98180.77,790.21,126433.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502348,'2512','379',60197.29,60197.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178161',3502349,'2513','379',67606.27,68167.18,560.91,89745.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','178161',3502350,'2514','380',23008.17,23553.79,545.62,103667.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','178161',3502351,'2515','380',24435.82,24435.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178167',3502418,'2496','379',53224.03,53224.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178167',3502419,'2497','379',69443.02,71113.58,1660.56,265689.60,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502420,'2498','379',113095.27,114456.27,1351.00,216160.00,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502421,'2499','379',117632.61,119097.55,1454.94,232790.40,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502422,'2500','379',99172.10,100297.52,1115.42,178467.20,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502423,'2501','379',39175.54,40247.67,1062.13,169940.80,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502424,'2502','379',51310.34,51310.45,0.00,0.00,0.00,0.00,0.11,0.00,0.00),('1','161','861','178167',3502425,'2503','379',24664.11,25157.57,483.46,77353.60,0.00,0.00,10.00,0.00,0.00),('1','161','861','178167',3502426,'2504','379',32895.38,32895.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178167',3502427,'2505','379',69338.41,70547.15,1198.74,191798.40,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502428,'2506','379',159567.11,161628.16,2051.05,328168.00,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502429,'2507','379',141106.36,143067.68,1951.32,312211.20,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502430,'2508','379',115663.38,116952.39,1279.01,204641.60,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502431,'2509','379',95793.33,97083.40,1280.07,204811.20,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502432,'2510','379',109578.19,110620.98,1032.79,165246.40,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502433,'2511','379',98180.77,98771.14,580.37,92859.20,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502434,'2512','379',60197.29,60655.53,448.24,71718.40,0.00,0.00,10.00,0.00,0.00),('1','161','862','178167',3502435,'2513','379',68167.18,68421.80,244.62,39139.20,0.00,0.00,10.00,0.00,0.00),('1','161','863','178167',3502436,'2514','380',23553.79,23733.79,180.00,34200.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178167',3502437,'2515','380',24435.82,25260.96,825.14,156776.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502577,'2496','379',53224.03,53643.40,419.37,67099.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502578,'2497','379',71113.58,71113.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502579,'2498','379',114456.27,114947.78,491.51,78641.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502580,'2499','379',119097.55,119638.51,540.96,86553.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502581,'2500','379',100297.52,100755.60,458.08,73292.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502582,'2501','379',40247.67,40693.17,445.50,71280.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502583,'2502','379',51310.45,51310.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502584,'2503','379',25157.57,25157.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502585,'2504','379',32895.38,32967.01,71.63,11460.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178176',3502586,'2505','379',70547.15,70996.57,449.42,71907.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502587,'2506','379',161628.16,162314.86,686.70,109872.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502588,'2507','379',143067.68,143434.74,367.06,58729.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502589,'2508','379',116952.39,117251.27,298.88,47820.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502590,'2509','379',97083.40,97599.19,515.79,82526.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502591,'2510','379',110620.98,110673.63,52.65,8424.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502592,'2511','379',98771.14,99451.75,680.61,108897.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502593,'2512','379',60655.53,61168.46,512.93,82068.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178176',3502594,'2513','379',68421.80,68421.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178176',3502595,'2514','380',23733.79,23733.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178176',3502596,'2515','380',25260.96,25260.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502615,'2496','379',53643.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502616,'2497','379',71113.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502617,'2498','379',114947.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502618,'2499','379',119638.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502619,'2500','379',100755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502620,'2501','379',40693.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502621,'2502','379',51310.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502622,'2503','379',25157.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502623,'2504','379',32967.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178178',3502624,'2505','379',70996.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502625,'2506','379',162314.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502626,'2507','379',143434.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502627,'2508','379',117251.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502628,'2509','379',97599.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502629,'2510','379',110673.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502630,'2511','379',99451.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502631,'2512','379',61168.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178178',3502632,'2513','379',68421.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178178',3502633,'2514','380',23733.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178178',3502634,'2515','380',25260.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502683,'2496','379',53643.40,54185.33,541.93,86166.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502684,'2497','379',71113.58,71113.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502685,'2498','379',114947.78,115447.09,499.31,79390.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502686,'2499','379',119638.51,120218.42,579.91,92205.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502687,'2500','379',100755.60,101244.62,489.02,77754.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502688,'2501','379',40693.17,41145.69,452.52,71950.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502689,'2502','379',51310.45,51310.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502690,'2503','379',25157.57,25157.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502691,'2504','379',32967.01,32993.10,26.09,4148.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','178182',3502692,'2505','379',70996.57,71419.71,423.14,67279.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502693,'2506','379',162314.86,163006.85,691.99,110026.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502694,'2507','379',143434.74,143875.59,440.85,70095.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502695,'2508','379',117251.27,117654.89,403.62,64175.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502696,'2509','379',97599.19,97969.15,369.96,58823.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502697,'2510','379',110673.63,110940.79,267.16,42478.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502698,'2511','379',99451.75,100103.29,651.54,103594.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502699,'2512','379',61168.46,61599.21,430.75,68489.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','178182',3502700,'2513','379',68421.80,68421.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178182',3502701,'2514','380',23733.79,24806.95,1073.16,203900.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','178182',3502702,'2515','380',25260.96,25997.28,736.32,139900.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502712,'2496','379',54185.33,54185.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502713,'2497','379',71113.58,72344.43,1230.85,195705.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502714,'2498','379',115447.09,116651.38,1204.29,191482.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502715,'2499','379',120218.42,122443.00,2224.58,353708.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502716,'2500','379',101244.62,102493.44,1248.82,198562.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502717,'2501','379',41145.69,41145.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502718,'2502','379',51310.45,52534.30,1223.85,194592.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502719,'2503','379',25157.57,25189.01,31.44,4998.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502720,'2504','379',32993.10,33751.45,758.35,120577.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','178184',3502721,'2505','379',71419.71,72599.05,1179.34,187515.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502722,'2506','379',163006.85,164111.68,1104.83,175667.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502723,'2507','379',143875.59,145655.86,1780.27,283062.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502724,'2508','379',117654.89,118867.22,1212.33,192760.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502725,'2509','379',97969.15,99423.59,1454.44,231255.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502726,'2510','379',110940.79,112320.46,1379.67,219367.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502727,'2511','379',100103.29,100859.52,756.23,120240.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502728,'2512','379',61599.21,61599.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178184',3502729,'2513','379',68421.80,69508.08,1086.28,172718.52,0.00,0.00,0.00,0.00,0.00),('1','161','863','178184',3502730,'2514','380',24806.95,26367.40,1560.45,296485.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','178184',3502731,'2515','380',25997.28,27048.95,1051.67,199817.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504174,'2496','379',54185.33,54185.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504175,'2497','379',72344.43,73725.98,1381.55,219666.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504176,'2498','379',116651.38,117821.29,1169.91,186015.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504177,'2499','379',122443.00,123548.47,1105.47,175769.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504178,'2500','379',102493.44,103287.81,794.37,126304.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504179,'2501','379',41145.69,41145.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504180,'2502','379',52534.30,53178.84,644.54,102481.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504181,'2503','379',25189.01,25559.77,370.76,58950.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504182,'2504','379',33751.45,33751.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178260',3504183,'2505','379',72599.05,73640.11,1041.06,165528.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178260',3504184,'2506','379',164111.68,165229.81,1108.13,176192.67,0.00,0.00,10.00,0.00,0.00),('1','161','862','178260',3504185,'2507','379',145655.86,146760.41,1094.55,174033.45,0.00,0.00,10.00,0.00,0.00),('1','161','862','178260',3504186,'2508','379',118867.22,119812.76,935.54,148750.86,0.00,0.00,10.00,0.00,0.00),('1','161','862','178260',3504187,'2509','379',99423.59,99997.05,563.46,89590.14,0.00,0.00,10.00,0.00,0.00),('1','161','862','178260',3504188,'2510','379',112320.46,113032.87,702.41,111683.19,0.00,0.00,10.00,0.00,0.00),('1','161','862','178260',3504189,'2511','379',100859.52,101506.32,646.80,102841.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178260',3504190,'2512','379',61599.21,61599.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178260',3504191,'2513','379',69508.08,69751.96,243.88,38776.92,0.00,0.00,0.00,0.00,0.00),('1','161','863','178260',3504192,'2514','380',26367.40,26833.38,465.98,88536.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','178260',3504193,'2515','380',27048.95,28077.75,1028.80,195472.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504228,'2496','379',54185.33,54279.62,94.29,14992.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504229,'2497','379',73725.98,73725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504230,'2498','379',117821.29,119334.52,1513.23,240603.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504231,'2499','379',123548.47,125269.11,1720.64,273581.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504232,'2500','379',103287.81,104579.66,1291.85,205404.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504233,'2501','379',41145.69,42379.42,1233.73,196163.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504234,'2502','379',53178.84,53178.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504235,'2503','379',25559.77,25559.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504236,'2504','379',33751.45,34306.94,555.49,88322.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','178263',3504237,'2505','379',73640.11,75208.97,1568.86,249448.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504238,'2506','379',165229.81,166668.97,1439.16,228826.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504239,'2507','379',146760.41,148603.36,1842.95,293029.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504240,'2508','379',119812.76,121326.96,1514.20,240757.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504241,'2509','379',99997.05,101436.25,1439.20,228832.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504242,'2510','379',113032.87,114218.22,1185.35,188470.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504243,'2511','379',101506.32,102180.52,674.20,107197.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504244,'2512','379',61599.21,61669.91,70.70,11241.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','178263',3504245,'2513','379',69751.96,70919.38,1167.42,185619.78,0.00,0.00,0.00,0.00,0.00),('1','161','863','178263',3504246,'2514','380',26833.38,29183.64,2350.26,446549.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','178263',3504247,'2515','380',28077.75,28222.75,145.00,27550.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178266',3504256,'2496','379',54279.62,54872.91,583.29,92743.11,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504257,'2497','379',73725.98,74350.32,614.34,97680.06,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504258,'2498','379',119334.52,120133.76,789.24,125489.16,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504259,'2499','379',125269.11,126333.89,1054.78,167710.02,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504260,'2500','379',104579.66,105662.57,1072.91,170592.69,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504261,'2501','379',42379.42,42938.40,548.98,87287.82,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504262,'2502','379',53178.84,53184.72,-4.12,-655.08,0.00,0.00,10.00,0.00,0.00),('1','161','861','178266',3504263,'2503','379',25559.77,25672.72,92.95,14779.05,0.00,0.00,20.00,0.00,0.00),('1','161','861','178266',3504264,'2504','379',34306.94,34306.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178266',3504265,'2505','379',75208.97,75876.74,657.77,104585.43,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504266,'2506','379',166668.97,167964.66,1285.69,204424.71,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504267,'2507','379',148603.36,150341.59,1728.23,274788.57,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504268,'2508','379',121326.96,122462.73,1125.77,178997.43,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504269,'2509','379',101436.25,102275.77,829.52,131893.68,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504270,'2510','379',114218.22,114683.63,455.41,72410.19,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504271,'2511','379',102180.52,102934.40,743.88,118276.92,0.00,0.00,10.00,0.00,0.00),('1','161','862','178266',3504272,'2512','379',61669.91,61669.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178266',3504273,'2513','379',70919.38,71373.12,443.74,70554.66,0.00,0.00,10.00,0.00,0.00),('1','161','863','178266',3504274,'2514','380',29183.64,32296.57,3062.93,581956.70,0.00,0.00,50.00,0.00,0.00),('1','161','863','178266',3504275,'2515','380',28222.75,31591.72,3348.97,636304.30,0.00,0.00,20.00,0.00,0.00),('1','161','861','178267',3504276,'2496','379',54872.91,56233.82,1360.91,216384.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504277,'2497','379',74350.32,74350.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504278,'2498','379',120133.76,121909.06,1775.30,282272.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504279,'2499','379',126333.89,127802.76,1468.87,233550.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504280,'2500','379',105662.57,107683.68,2021.11,321356.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504281,'2501','379',42938.40,42938.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504282,'2502','379',53184.72,54387.44,1202.72,191232.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504283,'2503','379',25672.72,25672.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504284,'2504','379',34306.94,35021.89,714.95,113677.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','178267',3504285,'2505','379',75876.74,77238.88,1362.14,216580.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504286,'2506','379',167964.66,169800.00,1835.34,291819.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504287,'2507','379',150341.59,152298.52,1956.93,311151.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504288,'2508','379',122462.73,124093.52,1630.79,259295.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504289,'2509','379',102275.77,103584.35,1308.58,208064.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504290,'2510','379',114683.63,115231.62,547.99,87130.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504291,'2511','379',102934.40,104106.80,1172.40,186411.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504292,'2512','379',61669.91,62659.89,989.98,157406.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','178267',3504293,'2513','379',71373.12,71373.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178267',3504294,'2514','380',32296.57,32908.05,611.48,116181.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','178267',3504295,'2515','380',31591.72,31591.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507522,'2496','379',56233.82,56233.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507523,'2497','379',74350.32,75475.70,1125.38,178935.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507524,'2498','379',121909.06,122884.13,975.07,155036.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507525,'2499','379',127802.76,129549.84,1747.08,277785.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507526,'2500','379',107683.68,108478.08,794.40,126309.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507527,'2501','379',42938.40,43397.98,459.58,73073.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507528,'2502','379',54387.44,54622.50,235.06,37374.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507529,'2503','379',25672.72,25672.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507530,'2504','379',35021.89,35042.65,20.76,3300.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','178442',3507531,'2505','379',77238.88,78343.56,1104.68,175644.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507532,'2506','379',169800.00,170804.26,1004.26,159677.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507533,'2507','379',152298.52,153579.76,1281.24,203717.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507534,'2508','379',124093.52,125087.97,994.45,158117.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507535,'2509','379',103584.35,104484.61,900.26,143141.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507536,'2510','379',115231.62,115686.34,454.72,72300.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507537,'2511','379',104106.80,105102.05,995.25,158244.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507538,'2512','379',62659.89,62809.82,149.93,23838.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178442',3507539,'2513','379',71373.12,71906.52,533.40,84810.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','178442',3507540,'2514','380',32908.05,33443.15,535.10,101669.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178442',3507541,'2515','380',31591.72,31682.24,90.52,17198.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507542,'2496','379',56233.82,56233.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507543,'2497','379',75475.70,76556.93,1081.23,171915.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507544,'2498','379',122884.13,124367.27,1483.14,235819.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507545,'2499','379',129549.84,130970.36,1420.52,225862.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507546,'2500','379',108478.08,108478.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507547,'2501','379',43397.98,43397.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507548,'2502','379',54622.50,55592.43,969.93,154218.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507549,'2503','379',25672.72,25672.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507550,'2504','379',35042.65,35371.90,329.25,52350.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','178443',3507551,'2505','379',78343.56,80066.75,1723.19,273987.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507552,'2506','379',170804.26,172726.45,1922.19,305628.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507553,'2507','379',153579.76,155547.11,1967.35,312808.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507554,'2508','379',125087.97,126152.47,1064.50,169255.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507555,'2509','379',104484.61,105508.53,1023.92,162803.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507556,'2510','379',115686.34,116780.88,1094.54,174031.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507557,'2511','379',105102.05,106440.51,1338.46,212815.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507558,'2512','379',62809.82,62991.32,181.50,28858.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178443',3507559,'2513','379',71906.52,72374.80,468.28,74456.52,0.00,0.00,0.00,0.00,0.00),('1','161','863','178443',3507560,'2514','380',33443.15,35590.16,2147.01,407931.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','178443',3507561,'2515','380',31682.24,33397.41,1715.17,325882.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507627,'2496','379',56233.82,56233.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507628,'2497','379',76556.93,78118.82,1561.89,248340.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507629,'2498','379',124367.27,124367.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507630,'2499','379',130970.36,133685.61,2715.25,431724.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507631,'2500','379',108478.08,108478.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507632,'2501','379',43397.98,44643.49,1245.51,198036.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507633,'2502','379',55592.43,55592.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507634,'2503','379',25672.72,25685.30,12.58,2000.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507635,'2504','379',35371.90,35540.37,168.47,26786.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','178447',3507636,'2505','379',80066.75,81720.42,1653.67,262933.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507637,'2506','379',172726.45,174367.86,1641.41,260984.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507638,'2507','379',155547.11,157026.60,1479.49,235238.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507639,'2508','379',126152.47,127553.10,1400.63,222700.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507640,'2509','379',105508.53,106725.59,1217.06,193512.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507641,'2510','379',116780.88,118211.67,1430.79,227495.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507642,'2511','379',106440.51,106440.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507643,'2512','379',62991.32,62991.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178447',3507644,'2513','379',72374.80,73927.28,1552.48,246844.32,0.00,0.00,0.00,0.00,0.00),('1','161','863','178447',3507645,'2514','380',35590.16,39173.37,3583.21,680809.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','178447',3507646,'2515','380',33397.41,35381.42,1984.01,376961.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507705,'2496','379',56233.82,56233.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507706,'2497','379',78118.82,79313.68,1194.86,189982.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507707,'2498','379',124367.27,125730.12,1362.85,216693.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507708,'2499','379',133685.61,134803.07,1117.46,177676.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507709,'2500','379',108478.08,108780.47,302.39,48080.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507710,'2501','379',44643.49,45828.54,1185.05,188422.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507711,'2502','379',55592.43,55592.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507712,'2503','379',25685.30,26015.92,330.62,52568.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507713,'2504','379',35540.37,35540.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178451',3507714,'2505','379',81720.42,83390.67,1670.25,265569.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507715,'2506','379',174367.86,175989.39,1621.53,257823.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507716,'2507','379',157026.60,159182.63,2156.03,342808.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507717,'2508','379',127553.10,128847.42,1294.32,205796.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507718,'2509','379',106725.59,107515.56,789.97,125605.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507719,'2510','379',118211.67,119299.61,1087.94,172982.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507720,'2511','379',106440.51,107196.36,755.85,120180.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507721,'2512','379',62991.32,62991.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178451',3507722,'2513','379',73927.28,75599.35,1672.07,265859.13,0.00,0.00,0.00,0.00,0.00),('1','161','863','178451',3507723,'2514','380',39173.37,41378.20,2204.83,418917.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','178451',3507724,'2515','380',35381.42,37373.54,1992.12,378502.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508061,'2496','379',56233.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508062,'2497','379',79313.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508063,'2498','379',125730.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508064,'2499','379',134803.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508065,'2500','379',108780.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508066,'2501','379',45828.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508067,'2502','379',55592.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508068,'2503','379',26015.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508069,'2504','379',35540.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178473',3508070,'2505','379',83390.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508071,'2506','379',175989.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508072,'2507','379',159182.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508073,'2508','379',128847.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508074,'2509','379',107515.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508075,'2510','379',119299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508076,'2511','379',107196.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508077,'2512','379',62991.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178473',3508078,'2513','379',75599.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178473',3508079,'2514','380',41378.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178473',3508080,'2515','380',37373.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508096,'2496','379',56233.82,57340.88,1107.06,176022.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508097,'2497','379',79313.68,79313.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508098,'2498','379',125730.12,127350.60,1620.48,257656.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508099,'2499','379',134803.07,135837.63,1034.56,164495.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508100,'2500','379',108780.47,110314.53,1534.06,243915.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508101,'2501','379',45828.54,45828.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508102,'2502','379',55592.43,56651.29,1058.86,168358.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508103,'2503','379',26015.92,26015.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508104,'2504','379',35540.37,35821.26,280.89,44661.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','178476',3508105,'2505','379',83390.67,83390.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508106,'2506','379',175989.39,177878.01,1888.62,300290.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508107,'2507','379',159182.63,159182.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508108,'2508','379',128847.42,130344.06,1496.64,237965.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508109,'2509','379',107515.56,108773.52,1257.96,200015.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508110,'2510','379',119299.61,119354.72,55.11,8762.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508111,'2511','379',107196.36,108463.12,1266.76,201414.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508112,'2512','379',62991.32,64111.47,1120.15,178103.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','178476',3508113,'2513','379',75599.35,75599.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178476',3508114,'2514','380',41378.20,42652.21,1274.01,261172.05,0.00,0.00,0.00,0.00,0.00),('1','161','863','178476',3508115,'2515','380',37373.54,38458.92,1085.38,222502.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508116,'2496','379',57340.88,57385.54,44.66,7100.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508117,'2497','379',79313.68,80618.51,1304.83,207467.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508118,'2498','379',127350.60,128933.47,1582.87,251676.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508119,'2499','379',135837.63,137945.35,2107.72,335127.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508120,'2500','379',110314.53,112095.98,1781.45,283250.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508121,'2501','379',45828.54,45828.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508122,'2502','379',56651.29,57921.15,1269.86,201907.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508123,'2503','379',26015.92,26015.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508124,'2504','379',35821.26,36205.65,384.39,61118.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','178477',3508125,'2505','379',83390.67,83438.89,48.22,7666.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508126,'2506','379',177878.01,179664.66,1786.65,284077.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508127,'2507','379',159182.63,161081.39,1898.76,301902.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508128,'2508','379',130344.06,132247.76,1903.70,302688.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508129,'2509','379',108773.52,110073.96,1300.44,206769.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508130,'2510','379',119354.72,121302.53,1947.81,309701.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508131,'2511','379',108463.12,108583.90,120.78,19204.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508132,'2512','379',64111.47,64111.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178477',3508133,'2513','379',75599.35,77224.83,1625.48,258451.32,0.00,0.00,0.00,0.00,0.00),('1','161','863','178477',3508134,'2514','380',42652.21,44294.63,1632.42,334646.10,0.00,0.00,10.00,0.00,0.00),('1','161','863','178477',3508135,'2515','380',38458.92,38486.24,27.32,5600.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508151,'2496','379',57385.54,57385.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508152,'2497','379',80618.51,81893.77,1275.26,202766.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508153,'2498','379',128933.47,130720.58,1787.11,284150.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508154,'2499','379',137945.35,137945.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508155,'2500','379',112095.98,113760.42,1664.44,264645.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508156,'2501','379',45828.54,45828.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508157,'2502','379',57921.15,58993.36,1072.21,170481.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508158,'2503','379',26015.92,26295.41,279.49,44438.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508159,'2504','379',36205.65,36205.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178480',3508160,'2505','379',83438.89,83438.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508161,'2506','379',179664.66,181240.37,1575.71,250537.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508162,'2507','379',161081.39,162813.34,1731.95,275380.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508163,'2508','379',132247.76,132247.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508164,'2509','379',110073.96,111239.86,1165.90,185378.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508165,'2510','379',121302.53,122097.07,794.54,126331.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508166,'2511','379',108583.90,109691.86,1107.96,176165.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508167,'2512','379',64111.47,65114.95,1003.48,159553.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178480',3508168,'2513','379',77224.83,77224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178480',3508169,'2514','380',44294.63,45953.86,1659.23,340142.15,0.00,0.00,0.00,0.00,0.00),('1','161','863','178480',3508170,'2515','380',38486.24,38895.99,409.75,83998.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508171,'2496','379',57385.54,58844.75,1459.21,232014.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508172,'2497','379',81893.77,81893.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508173,'2498','379',130720.58,132666.36,1945.78,309379.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508174,'2499','379',137945.35,139836.53,1891.18,300697.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508175,'2500','379',113760.42,113760.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508176,'2501','379',45828.54,47621.16,1792.62,285026.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508177,'2502','379',58993.36,58993.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508178,'2503','379',26295.41,26295.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508179,'2504','379',36205.65,37007.49,801.84,127492.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','178481',3508180,'2505','379',83438.89,85258.63,1819.74,289338.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508181,'2506','379',181240.37,182696.62,1456.25,231543.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508182,'2507','379',162813.34,164851.10,2037.76,324003.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508183,'2508','379',132247.76,134189.04,1941.28,308663.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508184,'2509','379',111239.86,111239.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508185,'2510','379',122097.07,123352.03,1254.96,199538.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508186,'2511','379',109691.86,110693.49,1001.63,159259.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508187,'2512','379',65114.95,65114.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178481',3508188,'2513','379',77224.83,79272.86,2048.03,325636.77,0.00,0.00,0.00,0.00,0.00),('1','161','863','178481',3508189,'2514','380',45953.86,47282.46,1328.60,272363.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178481',3508190,'2515','380',38895.99,38895.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508241,'2496','379',58844.75,59851.41,1006.66,160058.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508242,'2497','379',81893.77,81893.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508243,'2498','379',132666.36,134673.74,2007.38,319173.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508244,'2499','379',139836.53,139836.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508245,'2500','379',113760.42,114659.49,899.07,142952.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508246,'2501','379',47621.16,47621.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508247,'2502','379',58993.36,59818.57,825.21,131208.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508248,'2503','379',26295.41,26295.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508249,'2504','379',37007.49,37559.30,551.81,87737.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','178484',3508250,'2505','379',85258.63,85976.48,717.85,114138.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508251,'2506','379',182696.62,184492.71,1776.22,282418.98,0.00,0.00,19.87,0.00,0.00),('1','161','862','178484',3508252,'2507','379',164851.10,166297.15,1446.05,229921.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508253,'2508','379',134189.04,135338.93,1149.89,182832.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508254,'2509','379',111239.86,112583.77,1343.91,213681.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508255,'2510','379',123352.03,124899.82,1547.79,246098.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508256,'2511','379',110693.49,110693.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508257,'2512','379',65114.95,65114.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178484',3508258,'2513','379',79272.86,80371.57,1098.71,174694.89,0.00,0.00,0.00,0.00,0.00),('1','161','863','178484',3508259,'2514','380',47282.46,48440.52,1158.06,237402.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','178484',3508260,'2515','380',38895.99,39567.13,671.14,137583.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508261,'2496','379',59851.41,59851.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508262,'2497','379',81893.77,83092.15,1198.38,190542.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508263,'2498','379',134673.74,136488.47,1814.73,288542.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508264,'2499','379',139836.53,141843.45,2006.92,319100.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508265,'2500','379',114659.49,116404.74,1745.25,277494.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508266,'2501','379',47621.16,49047.75,1426.59,226827.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508267,'2502','379',59818.57,59818.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508268,'2503','379',26295.41,26846.42,551.01,87610.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508269,'2504','379',37559.30,37559.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178485',3508270,'2505','379',85976.48,87649.20,1672.72,265962.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508271,'2506','379',184492.71,185020.44,527.73,83909.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508272,'2507','379',166297.15,169347.65,3050.50,485029.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508273,'2508','379',135338.93,136957.71,1618.78,257386.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508274,'2509','379',112583.77,112583.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508275,'2510','379',124899.82,127030.00,2130.18,338698.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508276,'2511','379',110693.49,112076.01,1382.52,219820.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508277,'2512','379',65114.95,66611.59,1496.64,237965.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','178485',3508278,'2513','379',80371.57,80567.04,195.47,31079.73,0.00,0.00,0.00,0.00,0.00),('1','161','863','178485',3508279,'2514','380',48440.52,50166.38,1725.86,353801.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','178485',3508280,'2515','380',39567.13,41036.82,1469.69,301286.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508281,'2496','379',59851.41,59851.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508282,'2497','379',83092.15,83971.24,879.09,139775.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508283,'2498','379',136488.47,138116.05,1627.58,258785.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508284,'2499','379',141843.45,143246.01,1402.56,223007.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508285,'2500','379',116404.74,117913.38,1508.64,239873.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508286,'2501','379',49047.75,49408.50,360.75,57359.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508287,'2502','379',59818.57,61509.60,1691.03,268873.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508288,'2503','379',26846.42,26846.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508289,'2504','379',37559.30,38024.40,465.10,73950.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178486',3508290,'2505','379',87649.20,87649.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508291,'2506','379',185020.44,186699.56,1679.12,266980.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508292,'2507','379',169347.65,170726.40,1378.75,219221.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508293,'2508','379',136957.71,138003.72,1046.01,166315.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508294,'2509','379',112583.77,113379.89,796.12,126583.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508295,'2510','379',127030.00,128199.34,1149.34,182745.06,0.00,0.00,20.00,0.00,0.00),('1','161','862','178486',3508296,'2511','379',112076.01,112796.57,720.56,114569.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508297,'2512','379',66611.59,66611.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178486',3508298,'2513','379',80567.04,81129.96,562.92,89504.28,0.00,0.00,0.00,0.00,0.00),('1','161','863','178486',3508299,'2514','380',50166.38,50512.73,346.35,71001.75,0.00,0.00,0.00,0.00,0.00),('1','161','863','178486',3508300,'2515','380',41036.82,41036.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508301,'2496','379',59851.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508302,'2497','379',83971.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508303,'2498','379',138116.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508304,'2499','379',143246.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508305,'2500','379',117913.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508306,'2501','379',49408.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508307,'2502','379',61509.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508308,'2503','379',26846.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508309,'2504','379',38024.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178487',3508310,'2505','379',87649.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508311,'2506','379',186699.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508312,'2507','379',170726.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508313,'2508','379',138003.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508314,'2509','379',113379.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508315,'2510','379',128199.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508316,'2511','379',112796.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508317,'2512','379',66611.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178487',3508318,'2513','379',81129.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178487',3508319,'2514','380',50512.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178487',3508320,'2515','380',41036.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508390,'2496','379',59851.41,59976.82,125.41,19940.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508391,'2497','379',83971.24,85335.04,1363.80,216844.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508392,'2498','379',138116.05,139914.88,1798.83,286013.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508393,'2499','379',143246.01,144964.84,1718.83,273293.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508394,'2500','379',117913.38,119271.64,1358.26,215963.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508395,'2501','379',49408.50,50458.49,1049.99,166948.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508396,'2502','379',61509.60,61509.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508397,'2503','379',26846.42,27413.95,567.53,90237.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508398,'2504','379',38024.40,38024.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178497',3508399,'2505','379',87649.20,88928.42,1279.22,203395.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508400,'2506','379',186699.56,188588.16,1888.60,300287.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508401,'2507','379',170726.40,173119.11,2392.71,380440.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508402,'2508','379',138003.72,138975.12,971.40,154452.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508403,'2509','379',113379.89,114637.56,1257.67,199969.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508404,'2510','379',128199.34,129450.06,1250.72,198864.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508405,'2511','379',112796.57,113969.90,1173.33,186559.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508406,'2512','379',66611.59,67400.31,788.72,125406.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178497',3508407,'2513','379',81129.96,81129.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178497',3508408,'2514','380',50512.73,51481.51,968.78,203443.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','178497',3508409,'2515','380',41036.82,41648.83,612.01,128522.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508452,'2496','379',59976.82,60804.90,828.08,131664.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508453,'2497','379',85335.04,85335.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508454,'2498','379',139914.88,141487.14,1572.26,249989.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508455,'2499','379',144964.84,145060.97,96.13,15284.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508456,'2500','379',119271.64,120524.51,1252.87,199206.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508457,'2501','379',50458.49,50458.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508458,'2502','379',61509.60,62537.87,1028.27,163494.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508459,'2503','379',27413.95,27429.04,15.09,2399.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508460,'2504','379',38024.40,38024.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178500',3508461,'2505','379',88928.42,90036.34,1107.92,176159.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508462,'2506','379',188588.16,190704.64,2116.48,336520.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508463,'2507','379',173119.11,174360.91,1241.80,197446.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508464,'2508','379',138975.12,140297.35,1322.23,210234.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508465,'2509','379',114637.56,115957.80,1320.24,209918.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508466,'2510','379',129450.06,130472.11,1022.05,162505.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508467,'2511','379',113969.90,114758.53,788.63,125392.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508468,'2512','379',67400.31,67400.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178500',3508469,'2513','379',81129.96,81910.77,780.81,124148.79,0.00,0.00,0.00,0.00,0.00),('1','161','863','178500',3508470,'2514','380',51481.51,52949.19,1457.68,306112.80,0.00,0.00,10.00,0.00,0.00),('1','161','863','178500',3508471,'2515','380',41648.83,43005.49,1356.66,284898.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508472,'2496','379',60804.90,60804.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508473,'2497','379',85335.04,87075.15,1740.11,276677.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508474,'2498','379',141487.14,141504.33,17.19,2733.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508475,'2499','379',145060.97,147393.49,2332.52,370870.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508476,'2500','379',120524.51,122504.52,1980.01,314821.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508477,'2501','379',50458.49,52259.22,1800.73,286316.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508478,'2502','379',62537.87,62537.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508479,'2503','379',27429.04,27429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508480,'2504','379',38024.40,38024.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178501',3508481,'2505','379',90036.34,91306.08,1269.74,201888.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508482,'2506','379',190704.64,192581.86,1877.22,298477.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508483,'2507','379',174360.91,176278.30,1917.39,304865.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508484,'2508','379',140297.35,142063.60,1766.25,280833.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508485,'2509','379',115957.80,116969.79,1011.99,160906.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508486,'2510','379',130472.11,131835.07,1362.96,216710.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508487,'2511','379',114758.53,115968.87,1210.34,192444.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508488,'2512','379',67400.31,69017.22,1616.91,257088.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','178501',3508489,'2513','379',81910.77,81910.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178501',3508490,'2514','380',52949.19,53883.55,934.36,196215.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','178501',3508491,'2515','380',43005.49,44156.02,1150.53,241611.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508586,'2496','379',60804.90,60804.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508587,'2497','379',87075.15,88154.52,1049.37,166849.83,0.00,0.00,30.00,0.00,0.00),('1','161','861','178506',3508588,'2498','379',141504.33,142241.01,736.68,117132.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508589,'2499','379',147393.49,148717.27,1323.78,210481.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508590,'2500','379',122504.52,123808.96,1304.44,207405.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508591,'2501','379',52259.22,52259.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508592,'2502','379',62537.87,63352.24,814.37,129484.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508593,'2503','379',27429.04,27429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508594,'2504','379',38024.40,38024.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178506',3508595,'2505','379',91306.08,91306.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508596,'2506','379',192581.86,193865.18,1283.32,204047.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508597,'2507','379',176278.30,177602.50,1324.20,210547.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508598,'2508','379',142063.60,143168.66,1105.06,175704.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508599,'2509','379',116969.79,117926.51,956.72,152118.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508600,'2510','379',131835.07,132800.31,965.24,153473.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508601,'2511','379',115968.87,116684.99,716.12,113863.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508602,'2512','379',69017.22,69835.72,818.50,130141.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178506',3508603,'2513','379',81910.77,81910.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178506',3508604,'2514','380',53883.55,54378.17,494.62,103870.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','178506',3508605,'2515','380',44156.02,44196.02,40.00,8400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508704,'2496','379',60804.90,62645.49,1840.59,292653.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508705,'2497','379',88154.52,88455.69,301.17,47886.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508706,'2498','379',142241.01,144010.69,1769.68,281379.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508707,'2499','379',148717.27,150200.64,1483.37,235855.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508708,'2500','379',123808.96,125250.95,1441.99,229276.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508709,'2501','379',52259.22,53087.53,828.31,131701.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508710,'2502','379',63352.24,63996.91,644.67,102502.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508711,'2503','379',27429.04,27795.50,366.46,58267.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508712,'2504','379',38024.40,38093.41,69.01,10972.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','178511',3508713,'2505','379',91306.08,93478.87,2122.79,337523.61,0.00,0.00,50.00,0.00,0.00),('1','161','862','178511',3508714,'2506','379',193865.18,194002.72,137.54,21868.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508715,'2507','379',177602.50,178194.90,592.40,94191.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508716,'2508','379',143168.66,143254.49,85.83,13646.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508717,'2509','379',117926.51,118407.55,481.04,76485.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508718,'2510','379',132800.31,134174.72,1374.41,218531.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508719,'2511','379',116684.99,117383.48,698.49,111059.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508720,'2512','379',69835.72,70922.62,1086.90,172817.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','178511',3508721,'2513','379',81910.77,83170.46,1259.69,200290.71,0.00,0.00,0.00,0.00,0.00),('1','161','863','178511',3508722,'2514','380',54378.17,55435.27,1057.10,221991.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178511',3508723,'2515','380',44196.02,44742.36,546.34,114731.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508796,'2496','379',62645.49,62645.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508797,'2497','379',88455.69,89469.59,1013.90,161210.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508798,'2498','379',144010.69,145918.37,1907.68,303321.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508799,'2499','379',150200.64,151563.91,1363.27,216759.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508800,'2500','379',125250.95,126528.29,1277.34,203097.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508801,'2501','379',53087.53,54165.31,1077.78,171367.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508802,'2502','379',63996.91,63996.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508803,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508804,'2504','379',38093.41,38093.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178515',3508805,'2505','379',93478.87,94432.80,953.93,151674.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508806,'2506','379',194002.72,196177.04,2174.32,345716.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508807,'2507','379',178194.90,179423.09,1228.19,195282.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508808,'2508','379',143254.49,143937.29,682.80,108565.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508809,'2509','379',118407.55,119636.82,1229.27,195453.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508810,'2510','379',134174.72,135411.27,1236.55,196611.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508811,'2511','379',117383.48,118152.07,768.59,122205.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508812,'2512','379',70922.62,70922.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178515',3508813,'2513','379',83170.46,84022.36,851.90,135452.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','178515',3508814,'2514','380',55435.27,56358.95,923.68,193972.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','178515',3508815,'2515','380',44742.36,44742.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508816,'2496','379',62645.49,63952.55,1307.06,207822.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508817,'2497','379',89469.59,89469.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508818,'2498','379',145918.37,147345.19,1426.82,226864.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508819,'2499','379',151563.91,152184.26,620.35,98635.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508820,'2500','379',126528.29,128035.72,1507.43,239681.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508821,'2501','379',54165.31,54165.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508822,'2502','379',63996.91,65294.38,1297.47,206297.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508823,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508824,'2504','379',38093.41,38093.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178516',3508825,'2505','379',94432.80,96175.21,1742.41,277043.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508826,'2506','379',196177.04,198028.71,1851.67,294415.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508827,'2507','379',179423.09,181176.10,1753.01,278728.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508828,'2508','379',143937.29,145075.80,1138.51,181023.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508829,'2509','379',119636.82,120950.03,1313.21,208800.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508830,'2510','379',135411.27,136546.55,1135.28,180509.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508831,'2511','379',118152.07,119398.21,1246.14,198136.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508832,'2512','379',70922.62,70922.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178516',3508833,'2513','379',84022.36,85713.01,1690.65,268813.35,0.00,0.00,0.00,0.00,0.00),('1','161','863','178516',3508834,'2514','380',56358.95,58389.35,2030.40,426384.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178516',3508835,'2515','380',44742.36,46899.12,2156.76,452919.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508902,'2496','379',63952.55,64546.80,594.25,94485.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508903,'2497','379',89469.59,89469.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508904,'2498','379',147345.19,148589.35,1244.16,197821.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508905,'2499','379',152184.26,153526.54,1342.28,213422.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508906,'2500','379',128035.72,129274.10,1238.38,196902.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508907,'2501','379',54165.31,55342.55,1177.24,187181.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508908,'2502','379',65294.38,65294.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508909,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508910,'2504','379',38093.41,38564.11,470.70,74841.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178523',3508911,'2505','379',96175.21,96943.02,767.81,122081.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508912,'2506','379',198028.71,199275.16,1246.45,198185.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508913,'2507','379',181176.10,182225.11,1049.01,166792.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508914,'2508','379',145075.80,146541.90,1466.10,233109.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508915,'2509','379',120950.03,121985.95,1035.92,164711.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508916,'2510','379',136546.55,137230.69,684.14,108778.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508917,'2511','379',119398.21,120121.99,723.78,115081.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508918,'2512','379',70922.62,71901.92,979.30,155708.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','178523',3508919,'2513','379',85713.01,85713.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178523',3508920,'2514','380',58389.35,59046.98,657.63,138102.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','178523',3508921,'2515','380',46899.12,47742.93,843.81,177200.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508922,'2496','379',64546.80,64546.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508923,'2497','379',89469.59,90275.03,805.44,128064.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508924,'2498','379',148589.35,150166.05,1576.70,250695.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508925,'2499','379',153526.54,155113.89,1587.35,252388.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508926,'2500','379',129274.10,131534.40,2260.30,359387.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508927,'2501','379',55342.55,55342.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508928,'2502','379',65294.38,66608.00,1313.62,208865.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508929,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508930,'2504','379',38564.11,38564.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178524',3508931,'2505','379',96943.02,96943.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508932,'2506','379',199275.16,201437.37,2162.21,343791.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508933,'2507','379',182225.11,184639.28,2414.17,383853.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508934,'2508','379',146541.90,147948.44,1406.54,223639.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508935,'2509','379',121985.95,123084.78,1098.83,174713.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508936,'2510','379',137230.69,138319.86,1089.17,173178.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508937,'2511','379',120121.99,121567.12,1445.13,229775.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508938,'2512','379',71901.92,71901.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178524',3508939,'2513','379',85713.01,87188.99,1475.98,234680.82,0.00,0.00,0.00,0.00,0.00),('1','161','863','178524',3508940,'2514','380',59046.98,59919.42,872.44,183212.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','178524',3508941,'2515','380',47742.93,49204.29,1461.36,306885.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508975,'2496','379',64546.80,65430.89,874.09,138980.31,0.00,0.00,10.00,0.00,0.00),('1','161','861','178527',3508976,'2497','379',90275.03,90275.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508977,'2498','379',150166.05,151304.08,1128.03,179356.77,0.00,0.00,10.00,0.00,0.00),('1','161','861','178527',3508978,'2499','379',155113.89,156500.99,1387.10,220548.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508979,'2500','379',131534.40,133011.81,1477.41,234908.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508980,'2501','379',55342.55,55342.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508981,'2502','379',66608.00,67199.50,561.50,89278.50,0.00,0.00,30.00,0.00,0.00),('1','161','861','178527',3508982,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508983,'2504','379',38564.11,38564.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178527',3508984,'2505','379',96943.02,97728.87,775.85,123360.15,0.00,0.00,10.00,0.00,0.00),('1','161','862','178527',3508985,'2506','379',201437.37,203146.01,1698.64,270083.76,0.00,0.00,10.00,0.00,0.00),('1','161','862','178527',3508986,'2507','379',184639.28,186483.78,1844.50,293275.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178527',3508987,'2508','379',147948.44,148950.83,992.39,157790.01,0.00,0.00,10.00,0.00,0.00),('1','161','862','178527',3508988,'2509','379',123084.78,123989.87,905.09,143909.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','178527',3508989,'2510','379',138319.86,139706.59,1376.73,218900.07,0.00,0.00,10.00,0.00,0.00),('1','161','862','178527',3508990,'2511','379',121567.12,121995.06,427.94,68042.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178527',3508991,'2512','379',71901.92,71901.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178527',3508992,'2513','379',87188.99,87850.24,651.25,103548.75,0.00,0.00,10.00,0.00,0.00),('1','161','863','178527',3508993,'2514','380',59919.42,60727.61,808.19,169719.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','178527',3508994,'2515','380',49204.29,49564.29,360.00,75600.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509114,'2496','379',65430.89,65430.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509115,'2497','379',90275.03,92019.95,1724.92,274262.28,0.00,0.00,20.00,0.00,0.00),('1','161','861','178532',3509116,'2498','379',151304.08,152868.27,1564.19,248706.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509117,'2499','379',156500.99,158001.17,1480.18,235348.62,0.00,0.00,20.00,0.00,0.00),('1','161','861','178532',3509118,'2500','379',133011.81,134194.53,1162.72,184872.48,0.00,0.00,20.00,0.00,0.00),('1','161','861','178532',3509119,'2501','379',55342.55,56609.92,1247.37,198331.83,0.00,0.00,20.00,0.00,0.00),('1','161','861','178532',3509120,'2502','379',67199.50,67323.26,123.76,19677.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509121,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509122,'2504','379',38564.11,38564.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178532',3509123,'2505','379',97728.87,99042.71,1313.84,208900.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509124,'2506','379',203146.01,205225.14,2079.13,330581.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509125,'2507','379',186483.78,187137.82,644.04,102402.36,0.00,0.00,10.00,0.00,0.00),('1','161','862','178532',3509126,'2508','379',148950.83,150660.59,1709.76,271851.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509127,'2509','379',123989.87,125505.29,1505.42,239361.78,0.00,0.00,10.00,0.00,0.00),('1','161','862','178532',3509128,'2510','379',139706.59,141293.95,1587.36,252390.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509129,'2511','379',121995.06,121995.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509130,'2512','379',71901.92,71901.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178532',3509131,'2513','379',87850.24,88801.56,951.32,151259.88,0.00,0.00,0.00,0.00,0.00),('1','161','863','178532',3509132,'2514','380',60727.61,61798.36,1070.75,224857.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','178532',3509133,'2515','380',49564.29,49769.05,204.76,42999.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509252,'2496','379',65430.89,66255.43,824.54,131101.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509253,'2497','379',92019.95,92019.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509254,'2498','379',152868.27,153891.21,1022.94,162647.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509255,'2499','379',158001.17,158888.59,887.42,141099.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509256,'2500','379',134194.53,135095.69,901.16,143284.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509257,'2501','379',56609.92,56609.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509258,'2502','379',67323.26,68220.07,896.81,142592.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509259,'2503','379',27795.50,27795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509260,'2504','379',38564.11,38564.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178538',3509261,'2505','379',99042.71,99847.43,804.72,127950.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509262,'2506','379',205225.14,206492.33,1246.68,198222.12,0.00,0.00,20.51,0.00,0.00),('1','161','862','178538',3509263,'2507','379',187137.82,188025.82,888.00,141192.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509264,'2508','379',150660.59,151716.61,1056.02,167907.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509265,'2509','379',125505.29,126526.92,1001.12,159178.08,0.00,0.00,20.51,0.00,0.00),('1','161','862','178538',3509266,'2510','379',141293.95,141909.31,615.36,97842.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509267,'2511','379',121995.06,122864.30,869.24,138209.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509268,'2512','379',71901.92,73111.51,1209.59,192324.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','178538',3509269,'2513','379',88801.56,88801.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178538',3509270,'2514','380',61798.36,62046.60,248.24,52130.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','178538',3509271,'2515','380',49769.05,49769.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509349,'2496','379',66255.43,66819.72,564.29,89722.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509350,'2497','379',92019.95,93646.33,1626.38,258594.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509351,'2498','379',153891.21,155897.52,2006.31,319003.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509352,'2499','379',158888.59,161070.69,2182.10,346953.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509353,'2500','379',135095.69,136554.88,1459.19,232011.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509354,'2501','379',56609.92,58140.57,1530.65,243373.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509355,'2502','379',68220.07,68594.95,374.88,59605.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509356,'2503','379',27795.50,28046.12,250.62,39848.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509357,'2504','379',38564.11,38712.49,148.38,23592.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178544',3509358,'2505','379',99847.43,101430.47,1583.04,251703.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509359,'2506','379',206492.33,207602.43,1110.10,176505.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509360,'2507','379',188025.82,189339.31,1313.49,208844.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509361,'2508','379',151716.61,152493.92,777.31,123592.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509362,'2509','379',126526.92,127561.22,1034.30,164453.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509363,'2510','379',141909.31,141918.20,8.89,1413.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509364,'2511','379',122864.30,124774.24,1909.94,303680.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509365,'2512','379',73111.51,73111.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178544',3509366,'2513','379',88801.56,90637.59,1836.03,291928.77,0.00,0.00,0.00,0.00,0.00),('1','161','863','178544',3509367,'2514','380',62046.60,62502.39,455.79,95715.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','178544',3509368,'2515','380',49769.05,50848.65,1079.60,226716.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509369,'2496','379',66819.72,66819.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509370,'2497','379',93646.33,95216.39,1570.06,249639.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509371,'2498','379',155897.52,157121.51,1223.99,194614.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509372,'2499','379',161070.69,162557.48,1486.79,236399.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509373,'2500','379',136554.88,137646.19,1091.31,173518.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509374,'2501','379',58140.57,58140.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509375,'2502','379',68594.95,69443.45,848.50,134911.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509376,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509377,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178545',3509378,'2505','379',101430.47,102491.18,1060.71,168652.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509379,'2506','379',207602.43,208979.82,1377.39,219005.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509380,'2507','379',189339.31,190656.35,1317.04,209409.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509381,'2508','379',152493.92,153679.11,1185.19,188445.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509382,'2509','379',127561.22,128119.28,558.06,88731.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509383,'2510','379',141918.20,142985.37,1067.17,169680.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509384,'2511','379',124774.24,125555.74,781.50,124258.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509385,'2512','379',73111.51,73111.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178545',3509386,'2513','379',90637.59,91373.02,735.43,116933.37,0.00,0.00,0.00,0.00,0.00),('1','161','863','178545',3509387,'2514','380',62502.39,62562.39,60.00,12600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178545',3509388,'2515','380',50848.65,51315.79,467.14,98099.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509415,'2496','379',66819.72,67619.77,800.05,127207.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509416,'2497','379',95216.39,95467.25,250.86,39886.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509417,'2498','379',157121.51,159078.22,1956.71,311116.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509418,'2499','379',162557.48,164552.07,1994.59,317139.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509419,'2500','379',137646.19,139760.22,2114.03,336130.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509420,'2501','379',58140.57,59664.35,1523.78,242281.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509421,'2502','379',69443.45,69443.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509422,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509423,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178548',3509424,'2505','379',102491.18,102491.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509425,'2506','379',208979.82,210947.26,1967.44,312822.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509426,'2507','379',190656.35,192116.36,1460.01,232141.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509427,'2508','379',153679.11,155836.35,2157.24,343001.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509428,'2509','379',128119.28,128369.35,250.07,39761.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509429,'2510','379',142985.37,143983.20,997.83,158654.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509430,'2511','379',125555.74,126497.68,941.94,149768.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509431,'2512','379',73111.51,73111.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178548',3509432,'2513','379',91373.02,92843.08,1470.06,233739.54,0.00,0.00,0.00,0.00,0.00),('1','161','863','178548',3509433,'2514','380',62562.39,63774.24,1211.85,254488.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','178548',3509434,'2515','380',51315.79,51315.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509550,'2496','379',67619.77,68338.06,718.29,114208.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509551,'2497','379',95467.25,95467.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509552,'2498','379',159078.22,160521.10,1442.88,229417.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509553,'2499','379',164552.07,164552.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509554,'2500','379',139760.22,141062.37,1302.15,207041.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509555,'2501','379',59664.35,60554.51,890.16,141535.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509556,'2502','379',69443.45,69443.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509557,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509558,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178557',3509559,'2505','379',102491.18,103435.54,937.36,149040.24,0.00,0.00,7.00,0.00,0.00),('1','161','862','178557',3509560,'2506','379',210947.26,212524.94,1577.68,250851.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509561,'2507','379',192116.36,194017.10,1900.74,302217.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509562,'2508','379',155836.35,156879.35,1043.00,165837.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509563,'2509','379',128369.35,129240.30,870.95,138481.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509564,'2510','379',143983.20,145028.51,1045.31,166204.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509565,'2511','379',126497.68,127630.44,1132.76,180108.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509566,'2512','379',73111.51,73111.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178557',3509567,'2513','379',92843.08,93785.06,941.98,149774.82,0.00,0.00,0.00,0.00,0.00),('1','161','863','178557',3509568,'2514','380',63774.24,64689.46,895.22,187996.20,0.00,0.00,20.00,0.00,0.00),('1','161','863','178557',3509569,'2515','380',51315.79,51660.53,344.74,72395.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509642,'2496','379',68338.06,68338.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509643,'2497','379',95467.25,97280.17,1812.92,288254.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509644,'2498','379',160521.10,162628.24,2107.14,335035.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509645,'2499','379',164552.07,164552.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509646,'2500','379',141062.37,141163.31,100.94,16049.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509647,'2501','379',60554.51,60554.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509648,'2502','379',69443.45,71484.89,2041.44,324588.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509649,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509650,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178563',3509651,'2505','379',103435.54,105582.96,2147.42,341439.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509652,'2506','379',212524.94,214901.59,2376.65,377887.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509653,'2507','379',194017.10,196187.34,2170.24,345068.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509654,'2508','379',156879.35,158827.80,1948.45,309803.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509655,'2509','379',129240.30,130829.38,1589.08,252663.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509656,'2510','379',145028.51,146709.23,1680.72,267234.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509657,'2511','379',127630.44,128711.75,1081.31,171928.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509658,'2512','379',73111.51,74723.58,1612.07,256319.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','178563',3509659,'2513','379',93785.06,93785.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178563',3509660,'2514','380',64689.46,67166.11,2476.65,520096.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','178563',3509661,'2515','380',51660.53,53803.19,2142.66,449958.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509817,'2496','379',68338.06,68338.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509818,'2497','379',97280.17,98912.15,1631.98,259484.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509819,'2498','379',162628.24,163800.58,1172.34,186402.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509820,'2499','379',164552.07,165940.97,1368.90,217655.10,0.00,0.00,20.00,0.00,0.00),('1','161','861','178570',3509821,'2500','379',141163.31,142866.79,1703.48,270853.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509822,'2501','379',60554.51,61395.63,841.12,133738.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509823,'2502','379',71484.89,71484.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509824,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509825,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178570',3509826,'2505','379',105582.96,105582.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509827,'2506','379',214901.59,214901.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509828,'2507','379',196187.34,197782.30,1594.96,253598.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509829,'2508','379',158827.80,160088.04,1260.24,200378.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509830,'2509','379',130829.38,131643.42,814.04,129432.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509831,'2510','379',146709.23,148325.63,1616.40,257007.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509832,'2511','379',128711.75,128711.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509833,'2512','379',74723.58,74723.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178570',3509834,'2513','379',93785.06,95073.26,1288.20,204823.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','178570',3509835,'2514','380',67166.11,67611.09,444.98,93445.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','178570',3509836,'2515','380',53803.19,53863.91,60.72,12751.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509876,'2496','379',68338.06,69510.54,1172.48,186424.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509877,'2497','379',98912.15,98912.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509878,'2498','379',163800.58,165444.50,1643.92,261383.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509879,'2499','379',165940.97,167397.07,1456.10,231519.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509880,'2500','379',142866.79,143784.57,917.78,145927.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509881,'2501','379',61395.63,61395.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509882,'2502','379',71484.89,72712.56,1227.67,195199.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509883,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509884,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178573',3509885,'2505','379',105582.96,106425.31,842.35,133933.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509886,'2506','379',214901.59,216541.01,1639.42,260667.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509887,'2507','379',197782.30,199710.23,1927.93,306540.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509888,'2508','379',160088.04,161518.51,1430.47,227444.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509889,'2509','379',131643.42,133008.90,1365.48,217111.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509890,'2510','379',148325.63,149921.16,1595.53,253689.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509891,'2511','379',128711.75,129970.79,1259.04,200187.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509892,'2512','379',74723.58,76011.50,1287.92,204779.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','178573',3509893,'2513','379',95073.26,95073.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178573',3509894,'2514','380',67611.09,70199.48,2588.39,543561.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','178573',3509895,'2515','380',53863.91,56654.98,2791.07,586124.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509950,'2496','379',69510.54,69510.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509951,'2497','379',98912.15,99971.64,1059.49,168458.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509952,'2498','379',165444.50,166636.63,1192.13,189548.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509953,'2499','379',167397.07,168916.12,1519.05,241528.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509954,'2500','379',143784.57,145174.95,1390.38,221070.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509955,'2501','379',61395.63,62456.52,1060.89,168681.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509956,'2502','379',72712.56,72712.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509957,'2503','379',28046.12,28046.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509958,'2504','379',38712.49,38712.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178575',3509959,'2505','379',106425.31,107383.21,957.90,152306.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509960,'2506','379',216541.01,218163.86,1622.85,258033.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509961,'2507','379',199710.23,200764.21,1053.98,167582.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509962,'2508','379',161518.51,162867.47,1348.96,214484.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509963,'2509','379',133008.90,134386.58,1377.68,219051.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509964,'2510','379',149921.16,151122.05,1200.89,190941.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509965,'2511','379',129970.79,130844.44,873.65,138910.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509966,'2512','379',76011.50,76011.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178575',3509967,'2513','379',95073.26,96135.01,1061.75,168818.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','178575',3509968,'2514','380',70199.48,71672.14,1472.66,309258.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','178575',3509969,'2515','380',56654.98,56656.07,1.09,228.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509986,'2496','379',69510.54,71533.17,2022.63,321598.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509987,'2497','379',99971.64,100214.15,242.51,38559.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509988,'2498','379',166636.63,166882.45,245.82,39085.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509989,'2499','379',168916.12,171449.95,2533.83,402878.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509990,'2500','379',145174.95,147914.91,2739.96,435653.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509991,'2501','379',62456.52,62826.44,369.92,58817.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509992,'2502','379',72712.56,73046.55,333.99,53104.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509993,'2503','379',28046.12,28334.89,288.77,45914.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509994,'2504','379',38712.49,38971.00,258.51,41103.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','178577',3509995,'2505','379',107383.21,107862.66,479.45,76232.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3509996,'2506','379',218163.86,219964.98,1801.12,286378.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3509997,'2507','379',200764.21,203061.05,2296.84,365197.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3509998,'2508','379',162867.47,164414.95,1547.48,246049.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3509999,'2509','379',134386.58,136071.22,1684.64,267857.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3510000,'2510','379',151122.05,153013.40,1891.35,300724.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3510001,'2511','379',130844.44,131361.50,517.06,82212.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178577',3510002,'2512','379',76011.50,78473.22,2391.72,380283.48,0.00,0.00,70.00,0.00,0.00),('1','161','862','178577',3510003,'2513','379',96135.01,96294.98,159.97,25435.23,0.00,0.00,0.00,0.00,0.00),('1','161','863','178577',3510004,'2514','380',71672.14,73802.68,2110.54,443213.40,0.00,0.00,20.00,0.00,0.00),('1','161','863','178577',3510005,'2515','380',56656.07,56656.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510028,'2496','379',71533.17,72557.88,1024.71,162928.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510029,'2497','379',100214.15,100214.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510030,'2498','379',166882.45,168354.50,1472.05,234055.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510031,'2499','379',171449.95,172341.36,891.41,141734.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510032,'2500','379',147914.91,149283.93,1369.02,217674.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510033,'2501','379',62826.44,62826.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510034,'2502','379',73046.55,73749.96,703.41,111842.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510035,'2503','379',28334.89,28334.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510036,'2504','379',38971.00,38971.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178579',3510037,'2505','379',107862.66,108967.37,1104.71,175648.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510038,'2506','379',219964.98,221245.29,1280.31,203569.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510039,'2507','379',203061.05,204874.80,1813.75,288386.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510040,'2508','379',164414.95,165442.16,1027.21,163326.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510041,'2509','379',136071.22,137386.08,1314.86,209062.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510042,'2510','379',153013.40,153858.31,844.91,134340.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510043,'2511','379',131361.50,132216.98,855.48,136021.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510044,'2512','379',78473.22,78473.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178579',3510045,'2513','379',96294.98,97271.22,976.24,155222.16,0.00,0.00,0.00,0.00,0.00),('1','161','863','178579',3510046,'2514','380',73802.68,75112.68,1310.00,275100.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178579',3510047,'2515','380',56656.07,56661.85,5.78,1213.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510136,'2496','379',72557.88,72557.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510137,'2497','379',100214.15,101791.56,1577.41,250808.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510138,'2498','379',168354.50,169574.02,1219.52,193903.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510139,'2499','379',172341.36,173659.09,1317.73,209519.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510140,'2500','379',149283.93,151365.30,2081.37,330937.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510141,'2501','379',62826.44,64145.77,1319.33,209773.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510142,'2502','379',73749.96,73749.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510143,'2503','379',28334.89,28334.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510144,'2504','379',38971.00,39038.51,67.51,10734.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','178584',3510145,'2505','379',108967.37,108967.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510146,'2506','379',221245.29,222707.10,1461.81,232427.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510147,'2507','379',204874.80,206452.55,1577.75,250862.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510148,'2508','379',165442.16,167293.58,1851.42,294375.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510149,'2509','379',137386.08,138883.16,1497.08,238035.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510150,'2510','379',153858.31,155422.79,1564.48,248752.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510151,'2511','379',132216.98,132681.00,464.02,73779.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510152,'2512','379',78473.22,80033.31,1560.09,248054.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','178584',3510153,'2513','379',97271.22,97271.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178584',3510154,'2514','380',75112.68,76688.02,1575.34,330821.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','178584',3510155,'2515','380',56661.85,57473.79,811.94,170507.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510168,'2496','379',72557.88,72557.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510169,'2497','379',101791.56,103134.02,1342.46,213451.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510170,'2498','379',169574.02,171005.28,1431.26,227570.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510171,'2499','379',173659.09,175075.65,1416.56,225233.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510172,'2500','379',151365.30,152556.84,1191.54,189454.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510173,'2501','379',64145.77,64145.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510174,'2502','379',73749.96,74644.80,894.84,142279.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510175,'2503','379',28334.89,28334.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510176,'2504','379',39038.51,39248.29,209.78,33355.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','178586',3510177,'2505','379',108967.37,109909.03,941.66,149723.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510178,'2506','379',222707.10,224145.69,1438.59,228735.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510179,'2507','379',206452.55,208028.96,1576.41,250649.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510180,'2508','379',167293.58,168558.98,1265.40,201198.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510181,'2509','379',138883.16,139939.30,1056.14,167926.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510182,'2510','379',155422.79,156568.89,1146.10,182229.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510183,'2511','379',132681.00,132681.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510184,'2512','379',80033.31,81307.46,1274.15,202589.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','178586',3510185,'2513','379',97271.22,97271.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178586',3510186,'2514','380',76688.02,76697.54,9.52,1999.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','178586',3510187,'2515','380',57473.79,58176.65,702.86,147600.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510241,'2496','379',72557.88,74589.70,2031.82,323059.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510242,'2497','379',103134.02,103782.77,648.75,103151.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510243,'2498','379',171005.28,172987.28,1982.00,315138.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510244,'2499','379',175075.65,176679.34,1603.69,254986.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510245,'2500','379',152556.84,154384.54,1827.70,290604.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510246,'2501','379',64145.77,65738.77,1593.00,253287.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510247,'2502','379',74644.80,74644.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510248,'2503','379',28334.89,28334.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510249,'2504','379',39248.29,39248.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178589',3510250,'2505','379',109909.03,109909.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510251,'2506','379',224145.69,224145.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510252,'2507','379',208028.96,210952.38,2923.42,464823.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510253,'2508','379',168558.98,170082.91,1523.93,242304.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510254,'2509','379',139939.30,141237.21,1297.91,206367.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510255,'2510','379',156568.89,157889.83,1320.94,210029.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510256,'2511','379',132681.00,133991.56,1310.56,208379.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510257,'2512','379',81307.46,81307.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178589',3510258,'2513','379',97271.22,98837.12,1565.90,248978.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','178589',3510259,'2514','380',76697.54,76697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178589',3510260,'2515','380',58176.65,58176.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178591',3510289,'2496','379',74589.70,74915.67,305.97,48649.23,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510290,'2497','379',103782.77,104602.03,799.26,127082.34,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510291,'2498','379',172987.28,174071.14,1063.86,169153.74,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510292,'2499','379',176679.34,178081.49,1382.15,219761.85,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510293,'2500','379',154384.54,155939.50,1534.96,244058.64,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510294,'2501','379',65738.77,66469.83,701.06,111468.54,0.00,0.00,30.00,0.00,0.00),('1','161','861','178591',3510295,'2502','379',74644.80,75499.15,834.35,132661.65,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510296,'2503','379',28334.89,28354.89,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510297,'2504','379',39248.29,39268.29,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','178591',3510298,'2505','379',109909.03,111010.60,1081.57,171969.63,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510299,'2506','379',224145.69,225764.16,1598.47,254156.73,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510300,'2507','379',210952.38,212708.16,1735.78,275989.02,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510301,'2508','379',170082.91,171241.88,1138.97,181096.23,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510302,'2509','379',141237.21,142539.33,1282.12,203857.08,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510303,'2510','379',157889.83,158947.84,1035.82,164695.38,0.00,0.00,22.19,0.00,0.00),('1','161','862','178591',3510304,'2511','379',133991.56,135030.46,988.90,157235.10,0.00,0.00,50.00,0.00,0.00),('1','161','862','178591',3510305,'2512','379',81307.46,81395.57,68.11,10829.49,0.00,0.00,20.00,0.00,0.00),('1','161','862','178591',3510306,'2513','379',98837.12,99894.97,1037.85,165018.15,0.00,0.00,20.00,0.00,0.00),('1','161','863','178591',3510307,'2514','380',76697.54,76711.94,14.40,3024.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178591',3510308,'2515','380',58176.65,58241.51,64.86,13620.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510362,'2496','379',74915.67,74915.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510363,'2497','379',104602.03,106487.32,1885.29,299761.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510364,'2498','379',174071.14,176342.75,2271.61,361185.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510365,'2499','379',178081.49,178769.37,687.88,109372.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510366,'2500','379',155939.50,158502.54,2563.04,407523.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510367,'2501','379',66469.83,66469.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510368,'2502','379',75499.15,77457.51,1958.36,311379.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510369,'2503','379',28354.89,28354.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510370,'2504','379',39268.29,40371.32,1103.03,175381.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','178596',3510371,'2505','379',111010.60,111010.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510372,'2506','379',225764.16,226066.30,302.14,48040.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510373,'2507','379',212708.16,214526.02,1817.86,289039.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510374,'2508','379',171241.88,171241.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510375,'2509','379',142539.33,144869.06,2329.73,370427.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510376,'2510','379',158947.84,160107.85,1160.01,184441.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510377,'2511','379',135030.46,137010.80,1980.34,314874.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510378,'2512','379',81395.57,83029.48,1633.91,259791.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','178596',3510379,'2513','379',99894.97,100225.70,330.73,52586.07,0.00,0.00,0.00,0.00,0.00),('1','161','863','178596',3510380,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178596',3510381,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510406,'2496','379',74915.67,74915.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510407,'2497','379',106487.32,107687.04,1199.72,190755.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510408,'2498','379',176342.75,177789.06,1446.31,229963.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510409,'2499','379',178769.37,180319.72,1550.35,246505.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510410,'2500','379',158502.54,159782.57,1280.03,203524.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510411,'2501','379',66469.83,66469.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510412,'2502','379',77457.51,78521.85,1064.34,169230.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510413,'2503','379',28354.89,28364.89,10.00,1590.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510414,'2504','379',40371.32,40371.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178598',3510415,'2505','379',111010.60,112103.04,1092.44,173697.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510416,'2506','379',226066.30,227613.17,1546.87,245952.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510417,'2507','379',214526.02,215950.35,1424.33,226468.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510418,'2508','379',171241.88,172531.12,1289.24,204989.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510419,'2509','379',144869.06,145894.59,1025.53,163059.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510420,'2510','379',160107.85,161598.78,1490.93,237057.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510421,'2511','379',137010.80,137664.60,653.80,103954.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510422,'2512','379',83029.48,83029.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178598',3510423,'2513','379',100225.70,100868.20,642.50,102157.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','178598',3510424,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178598',3510425,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512584,'2496','379',74915.67,74915.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512585,'2497','379',107687.04,109572.34,1885.30,299762.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512586,'2498','379',177789.06,180668.21,2879.15,457784.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512587,'2499','379',180319.72,180450.52,130.80,20797.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512588,'2500','379',159782.57,162112.77,2330.20,370501.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512589,'2501','379',66469.83,66469.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512590,'2502','379',78521.85,79998.38,1476.53,234768.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512591,'2503','379',28364.89,28364.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512592,'2504','379',40371.32,40904.07,532.75,84707.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','178724',3512593,'2505','379',112103.04,112542.38,439.34,69855.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512594,'2506','379',227613.17,230294.30,2681.13,426299.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512595,'2507','379',215950.35,218289.88,2339.53,371985.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512596,'2508','379',172531.12,173549.20,1018.08,161874.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512597,'2509','379',145894.59,147333.65,1439.06,228810.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512598,'2510','379',161598.78,163459.56,1860.78,295864.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512599,'2511','379',137664.60,137664.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512600,'2512','379',83029.48,83029.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178724',3512601,'2513','379',100868.20,102571.49,1703.29,270823.11,0.00,0.00,0.00,0.00,0.00),('1','161','863','178724',3512602,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178724',3512603,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512606,'2496','379',74915.67,74915.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512607,'2497','379',109572.34,110622.11,1049.77,166913.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512608,'2498','379',180668.21,181961.04,1292.83,205559.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512609,'2499','379',180450.52,181793.62,1343.10,213552.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512610,'2500','379',162112.77,163160.82,1048.05,166639.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512611,'2501','379',66469.83,66469.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512612,'2502','379',79998.38,80862.32,863.94,137366.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512613,'2503','379',28364.89,28364.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512614,'2504','379',40904.07,40904.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178726',3512615,'2505','379',112542.38,113531.23,988.85,157227.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512616,'2506','379',230294.30,231995.06,1700.76,270420.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512617,'2507','379',218289.88,219917.14,1627.26,258734.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512618,'2508','379',173549.20,174727.36,1178.16,187327.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512619,'2509','379',147333.65,148139.77,806.12,128173.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512620,'2510','379',163459.56,164469.78,1010.22,160624.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512621,'2511','379',137664.60,138719.72,1055.12,167764.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512622,'2512','379',83029.48,83029.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178726',3512623,'2513','379',102571.49,103523.18,951.69,151318.71,0.00,0.00,0.00,0.00,0.00),('1','161','863','178726',3512624,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178726',3512625,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512626,'2496','379',74915.67,76266.14,1350.47,214724.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512627,'2497','379',110622.11,112103.30,1481.19,235509.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512628,'2498','379',181961.04,182023.45,62.41,9923.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512629,'2499','379',181793.62,184343.68,2550.06,405459.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512630,'2500','379',163160.82,165532.23,2371.41,377054.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512631,'2501','379',66469.83,68332.15,1862.32,296108.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512632,'2502','379',80862.32,80953.43,91.11,14486.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512633,'2503','379',28364.89,28364.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512634,'2504','379',40904.07,41085.35,181.28,28823.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','178727',3512635,'2505','379',113531.23,113658.78,127.55,20280.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512636,'2506','379',231995.06,234085.85,2090.79,332435.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512637,'2507','379',219917.14,222195.75,2278.61,362298.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512638,'2508','379',174727.36,176700.03,1972.67,313654.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512639,'2509','379',148139.77,148197.33,57.56,9152.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512640,'2510','379',164469.78,165925.87,1456.09,231518.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512641,'2511','379',138719.72,140223.22,1503.50,239056.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512642,'2512','379',83029.48,84727.25,1697.77,269945.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','178727',3512643,'2513','379',103523.18,103523.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178727',3512644,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178727',3512645,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512670,'2496','379',76266.14,76266.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512671,'2497','379',112103.30,113172.99,1069.69,170080.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512672,'2498','379',182023.45,183653.95,1630.50,259249.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512673,'2499','379',184343.68,185885.86,1542.18,245206.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512674,'2500','379',165532.23,166744.30,1212.07,192719.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512675,'2501','379',68332.15,68332.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512676,'2502','379',80953.43,81518.77,565.34,89889.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512677,'2503','379',28364.89,28364.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178730',3512678,'2504','379',41085.35,41085.94,0.00,0.00,0.00,0.00,0.59,0.00,0.00),('1','161','861','178730',3512679,'2505','379',113658.78,114572.37,913.59,145260.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512680,'2506','379',234085.85,235627.54,1541.69,245128.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512681,'2507','379',222195.75,223540.92,1345.17,213882.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512682,'2508','379',176700.03,177930.20,1230.17,195597.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512683,'2509','379',148197.33,149065.27,867.94,138002.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512684,'2510','379',165925.87,167117.17,1191.30,189416.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512685,'2511','379',140223.22,140964.18,740.96,117812.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512686,'2512','379',84727.25,85869.23,1141.98,181574.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','178730',3512687,'2513','379',103523.18,103523.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178730',3512688,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178730',3512689,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512714,'2496','379',76266.14,78042.69,1776.55,282471.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512715,'2497','379',113172.99,113172.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512716,'2498','379',183653.95,185081.92,1407.97,223867.23,0.00,0.00,20.00,0.00,0.00),('1','161','861','178733',3512717,'2499','379',185885.86,188043.84,2157.98,343118.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512718,'2500','379',166744.30,168562.49,1818.19,289092.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512719,'2501','379',68332.15,69630.80,1298.65,206485.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512720,'2502','379',81518.77,82338.58,819.81,130349.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512721,'2503','379',28364.89,28364.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512722,'2504','379',41085.94,41085.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178733',3512723,'2505','379',114572.37,116257.70,1685.33,267967.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512724,'2506','379',235627.54,237126.48,1498.94,238331.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512725,'2507','379',223540.92,225503.16,1962.24,311996.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512726,'2508','379',177930.20,180345.00,2414.80,383953.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512727,'2509','379',149065.27,149150.81,85.54,13600.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512728,'2510','379',167117.17,168691.64,1574.47,250340.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512729,'2511','379',140964.18,141707.42,743.24,118175.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512730,'2512','379',85869.23,85869.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','178733',3512731,'2513','379',103523.18,105292.97,1769.79,281396.61,0.00,0.00,0.00,0.00,0.00),('1','161','863','178733',3512732,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178733',3512733,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512734,'2496','379',78042.69,78655.17,612.48,97384.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512735,'2497','379',113172.99,113952.51,779.52,123943.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512736,'2498','379',185081.92,187374.61,2292.69,364537.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512737,'2499','379',188043.84,189539.51,1495.67,237811.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512738,'2500','379',168562.49,169885.89,1323.40,210420.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512739,'2501','379',69630.80,70135.29,504.49,80213.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512740,'2502','379',82338.58,82939.68,601.10,95574.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512741,'2503','379',28364.89,28671.73,306.84,48787.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512742,'2504','379',41085.94,41085.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178734',3512743,'2505','379',116257.70,117302.02,1044.32,166046.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512744,'2506','379',237126.48,238841.44,1714.96,272678.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512745,'2507','379',225503.16,226690.86,1187.70,188844.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512746,'2508','379',180345.00,181410.86,1065.86,169471.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512747,'2509','379',149150.81,150131.17,980.36,155877.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512748,'2510','379',168691.64,169773.40,1081.76,171999.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512749,'2511','379',141707.42,142869.76,1162.34,184812.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512750,'2512','379',85869.23,86460.28,591.05,93976.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','178734',3512751,'2513','379',105292.97,106066.09,773.12,122926.08,0.00,0.00,0.00,0.00,0.00),('1','161','863','178734',3512752,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178734',3512753,'2515','380',58241.51,58241.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512766,'2496','379',78655.17,79372.51,717.34,114057.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512767,'2497','379',113952.51,114841.83,889.32,141401.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512768,'2498','379',187374.61,189316.76,1942.15,308801.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512769,'2499','379',189539.51,191226.33,1686.82,268204.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512770,'2500','379',169885.89,171768.28,1882.39,299300.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512771,'2501','379',70135.29,70843.34,708.05,112579.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512772,'2502','379',82939.68,84150.47,1210.79,192515.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512773,'2503','379',28671.73,28951.30,279.57,44451.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512774,'2504','379',41085.94,41351.82,265.88,42274.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','178736',3512775,'2505','379',117302.02,119422.75,2120.73,337196.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512776,'2506','379',238841.44,240808.14,1966.70,312705.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512777,'2507','379',226690.86,229299.69,2608.83,414803.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512778,'2508','379',181410.86,182818.06,1407.20,223744.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512779,'2509','379',150131.17,151685.79,1554.62,247184.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512780,'2510','379',169773.40,172042.14,2268.74,360729.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512781,'2511','379',142869.76,146050.31,3180.55,505707.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512782,'2512','379',86460.28,86865.42,405.14,64417.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','178736',3512783,'2513','379',106066.09,107353.24,1287.15,204656.85,0.00,0.00,0.00,0.00,0.00),('1','161','863','178736',3512784,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','178736',3512785,'2515','380',58241.51,58890.07,648.56,136197.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519480,'2496','379',79372.51,80303.56,931.05,148036.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519481,'2497','379',114841.83,115632.07,790.24,125648.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519482,'2498','379',189316.76,191177.88,1861.12,295918.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519483,'2499','379',191226.33,193173.83,1947.50,309652.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519484,'2500','379',171768.28,173436.90,1668.62,265310.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519485,'2501','379',70843.34,72100.74,1257.40,199926.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519486,'2502','379',84150.47,84904.93,754.46,119959.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519487,'2503','379',28951.30,29424.23,472.93,75195.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519488,'2504','379',41351.82,41760.28,408.46,64945.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','179098',3519489,'2505','379',119422.75,120593.45,1170.70,186141.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519490,'2506','379',240808.14,242237.78,1429.64,227312.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519491,'2507','379',229299.69,231054.67,1754.98,279041.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519492,'2508','379',182818.06,184822.27,2004.21,318669.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519493,'2509','379',151685.79,153230.90,1545.11,245672.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519494,'2510','379',172042.14,173639.82,1597.68,254031.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519495,'2511','379',146050.31,147314.67,1264.36,201033.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519496,'2512','379',86865.42,87854.38,988.96,157244.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','179098',3519497,'2513','379',107353.24,108341.96,988.72,157206.48,0.00,0.00,0.00,0.00,0.00),('1','161','863','179098',3519498,'2514','380',76711.94,76711.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179098',3519499,'2515','380',58890.07,59493.72,603.65,126766.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519502,'2496','379',80303.56,81290.53,986.97,156928.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519503,'2497','379',115632.07,117919.42,2287.35,363688.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519504,'2498','379',191177.88,193833.92,2656.04,422310.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519505,'2499','379',193173.83,196281.07,3107.24,494051.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519506,'2500','379',173436.90,176766.14,3329.24,529349.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519507,'2501','379',72100.74,73248.46,1147.72,182487.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519508,'2502','379',84904.93,86856.04,1951.11,310226.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519509,'2503','379',29424.23,29958.01,533.78,84871.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519510,'2504','379',41760.28,43249.26,1488.98,236747.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179100',3519511,'2505','379',120593.45,122049.62,1456.17,231531.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519512,'2506','379',242237.78,244449.00,2211.22,351583.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519513,'2507','379',231054.67,233538.45,2483.78,394921.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519514,'2508','379',184822.27,186400.59,1578.32,250952.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519515,'2509','379',153230.90,154360.05,1129.15,179534.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519516,'2510','379',173639.82,174989.24,1349.42,214557.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519517,'2511','379',147314.67,148891.96,1577.29,250789.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519518,'2512','379',87854.38,88434.54,580.16,92245.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','179100',3519519,'2513','379',108341.96,109755.84,1413.88,224806.92,0.00,0.00,0.00,0.00,0.00),('1','161','863','179100',3519520,'2514','380',76711.94,76881.94,170.00,35700.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179100',3519521,'2515','380',59493.72,60424.04,930.32,195367.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519533,'2496','379',81290.53,81903.36,612.83,97439.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519534,'2497','379',117919.42,118606.36,686.94,109223.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519535,'2498','379',193833.92,194946.03,1112.11,176825.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519536,'2499','379',196281.07,198001.36,1720.29,273526.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519537,'2500','379',176766.14,178719.97,1953.83,310658.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519538,'2501','379',73248.46,73816.78,568.32,90362.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519539,'2502','379',86856.04,87538.27,682.23,108474.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519540,'2503','379',29958.01,30319.88,361.87,57537.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519541,'2504','379',43249.26,43671.24,421.98,67094.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179103',3519542,'2505','379',122049.62,123282.88,1233.26,196088.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519543,'2506','379',244449.00,246283.96,1834.96,291758.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519544,'2507','379',233538.45,234673.12,1134.67,180412.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519545,'2508','379',186400.59,187539.61,1139.02,181104.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519546,'2509','379',154360.05,155729.64,1369.59,217764.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519547,'2510','379',174989.24,176234.84,1245.60,198050.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519548,'2511','379',148891.96,149564.35,672.39,106910.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519549,'2512','379',88434.54,88900.48,465.94,74084.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','179103',3519550,'2513','379',109755.84,110320.70,564.86,89812.74,0.00,0.00,0.00,0.00,0.00),('1','161','863','179103',3519551,'2514','380',76881.94,77937.76,955.82,200722.20,0.00,0.00,100.00,0.00,0.00),('1','161','863','179103',3519552,'2515','380',60424.04,60424.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519553,'2496','379',81903.36,82811.18,907.82,144343.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519554,'2497','379',118606.36,120244.45,1638.09,260456.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519555,'2498','379',194946.03,196902.01,1955.98,311000.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519556,'2499','379',198001.36,200130.03,2128.67,338458.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519557,'2500','379',178719.97,180870.18,2150.21,341883.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519558,'2501','379',73816.78,74971.84,1155.06,183654.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519559,'2502','379',87538.27,88240.86,702.59,111711.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519560,'2503','379',30319.88,30677.17,357.29,56809.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519561,'2504','379',43671.24,44173.23,501.99,79816.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','179104',3519562,'2505','379',123282.88,124989.78,1706.90,271397.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519563,'2506','379',246283.96,249255.27,2971.31,472438.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519564,'2507','379',234673.12,237639.80,2966.68,471702.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519565,'2508','379',187539.61,189326.26,1786.65,284077.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519566,'2509','379',155729.64,157115.65,1386.01,220375.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519567,'2510','379',176234.84,177681.96,1447.12,230092.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519568,'2511','379',149564.35,150598.77,1034.42,164472.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519569,'2512','379',88900.48,88900.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179104',3519570,'2513','379',110320.70,111390.93,1070.23,170166.57,0.00,0.00,0.00,0.00,0.00),('1','161','863','179104',3519571,'2514','380',77937.76,79984.47,2046.71,429809.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','179104',3519572,'2515','380',60424.04,61260.18,836.14,175589.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519573,'2496','379',82811.18,82811.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519574,'2497','379',120244.45,121648.20,1403.75,223196.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519575,'2498','379',196902.01,198394.64,1492.63,237328.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519576,'2499','379',200130.03,201726.23,1596.20,253795.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519577,'2500','379',180870.18,182423.52,1553.34,246981.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519578,'2501','379',74971.84,75009.57,37.73,5999.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519579,'2502','379',88240.86,89659.46,1418.60,225557.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519580,'2503','379',30677.17,31538.70,861.53,136983.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519581,'2504','379',44173.23,44173.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179105',3519582,'2505','379',124989.78,126990.25,2000.47,318074.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519583,'2506','379',249255.27,251016.72,1741.45,276890.55,0.00,0.00,20.00,0.00,0.00),('1','161','862','179105',3519584,'2507','379',237639.80,240708.77,3068.97,487966.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519585,'2508','379',189326.26,191144.50,1818.24,289100.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519586,'2509','379',157115.65,158622.52,1506.87,239592.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519587,'2510','379',177681.96,179238.71,1556.75,247523.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519588,'2511','379',150598.77,152076.45,1477.68,234951.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519589,'2512','379',88900.48,89591.63,691.15,109892.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','179105',3519590,'2513','379',111390.93,112463.50,1072.57,170538.63,0.00,0.00,0.00,0.00,0.00),('1','161','863','179105',3519591,'2514','380',79984.47,80781.05,796.58,167281.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','179105',3519592,'2515','380',61260.18,61260.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519647,'2496','379',82811.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519648,'2497','379',121648.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519649,'2498','379',198394.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519650,'2499','379',201726.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519651,'2500','379',182423.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519652,'2501','379',75009.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519653,'2502','379',89659.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519654,'2503','379',31538.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519655,'2504','379',44173.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179108',3519656,'2505','379',126990.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519657,'2506','379',251016.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519658,'2507','379',240708.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519659,'2508','379',191144.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519660,'2509','379',158622.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519661,'2510','379',179238.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519662,'2511','379',152076.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519663,'2512','379',89591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179108',3519664,'2513','379',112463.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179108',3519665,'2514','380',80781.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179108',3519666,'2515','380',61260.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519689,'2496','379',82811.18,84579.16,1767.98,281108.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519690,'2497','379',121648.20,122324.99,676.79,107609.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519691,'2498','379',198394.64,201533.72,3139.08,499113.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519692,'2499','379',201726.23,204987.95,3261.72,518613.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519693,'2500','379',182423.52,185164.73,2741.21,435852.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519694,'2501','379',75009.57,77242.63,2233.06,355056.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519695,'2502','379',89659.46,90169.39,509.93,81078.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519696,'2503','379',31538.70,31690.73,152.03,24172.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','179110',3519697,'2504','379',44173.23,44707.66,514.43,81794.37,0.00,0.00,20.00,0.00,0.00),('1','161','861','179110',3519698,'2505','379',126990.25,129288.63,2298.38,365442.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519699,'2506','379',251016.72,253744.40,2727.68,433701.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519700,'2507','379',240708.77,243728.00,3019.23,480057.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519701,'2508','379',191144.50,193398.12,2253.62,358325.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519702,'2509','379',158622.52,160612.26,1989.74,316368.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519703,'2510','379',179238.71,181435.51,2196.80,349291.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519704,'2511','379',152076.45,153708.38,1631.93,259476.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519705,'2512','379',89591.63,89772.74,181.11,28796.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','179110',3519706,'2513','379',112463.50,114499.27,2035.77,323687.43,0.00,0.00,0.00,0.00,0.00),('1','161','863','179110',3519707,'2514','380',80781.05,81189.93,408.88,89953.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','179110',3519708,'2515','380',61260.18,62379.75,1119.57,246305.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519767,'2496','379',84579.16,85139.00,559.84,89014.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519768,'2497','379',122324.99,123744.56,1419.57,225711.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519769,'2498','379',201533.72,203061.29,1527.57,242883.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519770,'2499','379',204987.95,206976.27,1988.32,316142.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519771,'2500','379',185164.73,186799.78,1635.05,259972.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519772,'2501','379',77242.63,77242.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519773,'2502','379',90169.39,91429.99,1260.60,200435.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519774,'2503','379',31690.73,32354.28,663.55,105504.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519775,'2504','379',44707.66,44707.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179115',3519776,'2505','379',129288.63,130881.83,1593.20,253318.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519777,'2506','379',253744.40,255667.36,1922.96,305750.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519778,'2507','379',243728.00,245630.44,1902.44,302487.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519779,'2508','379',193398.12,194896.59,1498.47,238256.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519780,'2509','379',160612.26,161438.39,826.13,131354.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519781,'2510','379',181435.51,183024.57,1589.06,252660.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519782,'2511','379',153708.38,154970.41,1262.03,200662.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519783,'2512','379',89772.74,90552.26,779.52,123943.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','179115',3519784,'2513','379',114499.27,115578.89,1079.62,171659.58,0.00,0.00,0.00,0.00,0.00),('1','161','863','179115',3519785,'2514','380',81189.93,82465.14,1275.21,280546.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','179115',3519786,'2515','380',62379.75,62974.31,594.56,130803.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','179116',3519787,'2496','379',85139.00,85139.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179116',3519788,'2497','379',123744.56,125046.97,1292.41,205493.19,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519789,'2498','379',203061.29,203752.44,681.15,108302.85,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519790,'2499','379',206976.27,209816.56,2830.29,450016.11,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519791,'2500','379',186799.78,188541.30,1731.52,275311.68,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519792,'2501','379',77242.63,79499.22,2246.59,357207.81,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519793,'2502','379',91429.99,91778.02,338.03,53746.77,0.00,0.00,10.00,0.00,0.00),('1','161','861','179116',3519794,'2503','379',32354.28,32354.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179116',3519795,'2504','379',44707.66,44707.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179116',3519796,'2505','379',130881.83,133110.00,2218.17,352689.03,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519797,'2506','379',255667.36,257980.99,2303.63,366277.17,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519798,'2507','379',245630.44,248140.97,2500.53,397584.27,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519799,'2508','379',194896.59,197098.54,2191.95,348520.05,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519800,'2509','379',161438.39,162328.75,880.36,139977.24,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519801,'2510','379',183024.57,185439.06,2404.49,382313.91,0.00,0.00,10.00,0.00,0.00),('1','161','862','179116',3519802,'2511','379',154970.41,154970.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179116',3519803,'2512','379',90552.26,90552.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179116',3519804,'2513','379',115578.89,117347.15,1758.26,279563.34,0.00,0.00,10.00,0.00,0.00),('1','161','863','179116',3519805,'2514','380',82465.14,82995.51,520.37,114481.40,0.00,0.00,10.00,0.00,0.00),('1','161','863','179116',3519806,'2515','380',62974.31,63070.24,85.93,18904.60,0.00,0.00,10.00,0.00,0.00),('1','161','861','179118',3519833,'2496','379',85139.00,85139.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519834,'2497','379',125046.97,126734.92,1687.95,268384.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519835,'2498','379',203752.44,205410.92,1658.48,263698.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519836,'2499','379',209816.56,211340.69,1524.13,242336.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519837,'2500','379',188541.30,190718.42,2177.12,346162.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519838,'2501','379',79499.22,81470.48,1971.26,313430.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519839,'2502','379',91778.02,91778.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519840,'2503','379',32354.28,32841.08,486.80,77401.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519841,'2504','379',44707.66,44707.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179118',3519842,'2505','379',133110.00,134561.28,1451.28,230753.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519843,'2506','379',257980.99,259442.95,1461.96,232451.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519844,'2507','379',248140.97,250396.98,2256.01,358705.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519845,'2508','379',197098.54,199052.56,1954.02,310689.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519846,'2509','379',162328.75,164384.53,2055.78,326869.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519847,'2510','379',185439.06,186052.25,613.19,97497.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519848,'2511','379',154970.41,156857.99,1887.58,300125.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519849,'2512','379',90552.26,90552.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179118',3519850,'2513','379',117347.15,118895.78,1548.63,246232.17,0.00,0.00,0.00,0.00,0.00),('1','161','863','179118',3519851,'2514','380',82995.51,83186.32,190.81,41978.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','179118',3519852,'2515','380',63070.24,64903.67,1833.43,403354.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519954,'2496','379',85139.00,87575.54,2436.54,387409.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519955,'2497','379',126734.92,128968.08,2233.16,355072.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519956,'2498','379',205410.92,208041.18,2630.26,418211.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519957,'2499','379',211340.69,213915.83,2575.14,409447.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519958,'2500','379',190718.42,193087.75,2369.33,376723.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519959,'2501','379',81470.48,83721.53,2251.05,357916.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519960,'2502','379',91778.02,93776.70,1998.68,317790.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519961,'2503','379',32841.08,33907.64,1066.56,169583.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519962,'2504','379',44707.66,46608.01,1900.35,302155.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','179124',3519963,'2505','379',134561.28,136923.27,2361.99,375556.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519964,'2506','379',259442.95,260052.12,609.17,96858.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519965,'2507','379',250396.98,251049.02,652.04,103674.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519966,'2508','379',199052.56,199915.72,863.16,137242.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519967,'2509','379',164384.53,164890.22,505.69,80404.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519968,'2510','379',186052.25,186232.11,179.86,28597.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519969,'2511','379',156857.99,157948.11,1090.12,173329.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519970,'2512','379',90552.26,90610.74,58.48,9298.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','179124',3519971,'2513','379',118895.78,119517.86,622.08,98910.72,0.00,0.00,0.00,0.00,0.00),('1','161','863','179124',3519972,'2514','380',83186.32,83896.37,710.05,156211.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179124',3519973,'2515','380',64903.67,65745.49,841.82,185200.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519974,'2496','379',87575.54,87575.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519975,'2497','379',128968.08,130757.45,1789.37,284509.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519976,'2498','379',208041.18,209431.92,1390.74,221127.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519977,'2499','379',213915.83,215490.75,1574.92,250412.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519978,'2500','379',193087.75,194577.80,1490.05,236917.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519979,'2501','379',83721.53,83729.00,7.47,1187.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519980,'2502','379',93776.70,95119.76,1343.06,213546.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519981,'2503','379',33907.64,33907.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519982,'2504','379',46608.01,46608.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179125',3519983,'2505','379',136923.27,139199.49,2276.22,361918.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519984,'2506','379',260052.12,261863.71,1811.59,288042.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519985,'2507','379',251049.02,252951.34,1902.32,302468.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519986,'2508','379',199915.72,201267.58,1351.86,214945.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519987,'2509','379',164890.22,166082.66,1192.44,189597.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519988,'2510','379',186232.11,188204.22,1972.11,313565.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519989,'2511','379',157948.11,159191.48,1243.37,197695.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519990,'2512','379',90610.74,92031.28,1420.54,225865.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','179125',3519991,'2513','379',119517.86,120430.72,912.86,145144.74,0.00,0.00,0.00,0.00,0.00),('1','161','863','179125',3519992,'2514','380',83896.37,84259.44,363.07,79875.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','179125',3519993,'2515','380',65745.49,65745.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519994,'2496','379',87575.54,88589.24,1013.70,161178.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519995,'2497','379',130757.45,130757.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519996,'2498','379',209431.92,210351.95,920.03,146284.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519997,'2499','379',215490.75,216361.60,870.85,138465.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519998,'2500','379',194577.80,195799.27,1221.47,194213.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3519999,'2501','379',83729.00,83927.68,198.68,31590.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3520000,'2502','379',95119.76,95904.11,784.35,124711.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3520001,'2503','379',33907.64,33907.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3520002,'2504','379',46608.01,46608.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179126',3520003,'2505','379',139199.49,140041.01,841.52,133801.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520004,'2506','379',261863.71,262736.35,872.64,138749.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520005,'2507','379',252951.34,254088.12,1136.78,180748.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520006,'2508','379',201267.58,202600.84,1333.26,211988.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520007,'2509','379',166082.66,166915.95,833.29,132493.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520008,'2510','379',188204.22,189742.58,1538.36,244599.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520009,'2511','379',159191.48,160218.80,1027.32,163343.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520010,'2512','379',92031.28,92031.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179126',3520011,'2513','379',120430.72,121845.85,1415.13,225005.67,0.00,0.00,0.00,0.00,0.00),('1','161','863','179126',3520012,'2514','380',84259.44,84631.79,372.35,81917.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179126',3520013,'2515','380',65745.49,65769.81,24.32,5350.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520014,'2496','379',88589.24,88589.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520015,'2497','379',130757.45,132789.14,2031.69,323038.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520016,'2498','379',210351.95,210414.04,62.09,9872.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520017,'2499','379',216361.60,218972.65,2611.05,415156.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520018,'2500','379',195799.27,195909.34,110.07,17501.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520019,'2501','379',83927.68,85414.23,1486.55,236361.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520020,'2502','379',95904.11,96694.66,790.55,125697.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520021,'2503','379',33907.64,34190.63,282.99,44995.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520022,'2504','379',46608.01,48283.24,1675.23,266361.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','179127',3520023,'2505','379',140041.01,142482.87,2441.86,388255.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520024,'2506','379',262736.35,264148.25,1411.90,224492.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520025,'2507','379',254088.12,254088.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520026,'2508','379',202600.84,203894.88,1294.04,205752.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520027,'2509','379',166915.95,166959.98,44.03,7000.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520028,'2510','379',189742.58,191394.80,1652.22,262702.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520029,'2511','379',160218.80,160271.66,52.86,8404.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520030,'2512','379',92031.28,92031.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179127',3520031,'2513','379',121845.85,122827.63,981.78,156103.02,0.00,0.00,0.00,0.00,0.00),('1','161','863','179127',3520032,'2514','380',84631.79,84803.60,171.81,37798.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','179127',3520033,'2515','380',65769.81,66443.28,673.47,148163.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520034,'2496','379',88589.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520035,'2497','379',132789.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520036,'2498','379',210414.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520037,'2499','379',218972.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520038,'2500','379',195909.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520039,'2501','379',85414.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520040,'2502','379',96694.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520041,'2503','379',34190.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520042,'2504','379',48283.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179128',3520043,'2505','379',142482.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520044,'2506','379',264148.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520045,'2507','379',254088.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520046,'2508','379',203894.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520047,'2509','379',166959.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520048,'2510','379',191394.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520049,'2511','379',160271.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520050,'2512','379',92031.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179128',3520051,'2513','379',122827.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179128',3520052,'2514','380',84803.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179128',3520053,'2515','380',66443.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520054,'2496','379',88589.24,89795.73,1206.49,196657.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520055,'2497','379',132789.14,132789.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520056,'2498','379',210414.04,211600.71,1186.67,193427.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520057,'2499','379',218972.65,220280.08,1307.43,213111.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520058,'2500','379',195909.34,197080.73,1171.39,190936.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520059,'2501','379',85414.23,85414.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520060,'2502','379',96694.66,97806.90,1112.24,181295.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520061,'2503','379',34190.63,34464.54,273.91,44647.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520062,'2504','379',48283.24,49118.24,835.00,136105.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179129',3520063,'2505','379',142482.87,143508.83,1025.96,167231.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520064,'2506','379',264148.25,264786.03,637.78,103958.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520065,'2507','379',254088.12,255006.51,918.39,149697.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520066,'2508','379',203894.88,204524.15,629.27,102571.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520067,'2509','379',166959.98,167647.91,687.93,112132.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520068,'2510','379',191394.80,192010.53,615.73,100363.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520069,'2511','379',160271.66,160714.43,442.77,72171.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520070,'2512','379',92031.28,92442.05,410.77,66955.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','179129',3520071,'2513','379',122827.63,123338.95,511.32,83345.16,0.00,0.00,0.00,0.00,0.00),('1','161','863','179129',3520072,'2514','380',84803.60,85228.60,425.00,93500.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179129',3520073,'2515','380',66443.28,66982.05,538.77,118529.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520074,'2496','379',89795.73,90531.55,735.82,119938.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520075,'2497','379',132789.14,133849.52,1060.38,172841.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520076,'2498','379',211600.71,213278.71,1678.00,273514.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520077,'2499','379',220280.08,221928.20,1648.12,268643.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520078,'2500','379',197080.73,200002.65,2921.92,476272.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520079,'2501','379',85414.23,85414.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520080,'2502','379',97806.90,99540.44,1733.54,282567.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520081,'2503','379',34464.54,34464.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520082,'2504','379',49118.24,49118.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179130',3520083,'2505','379',143508.83,143508.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520084,'2506','379',264786.03,266558.11,1772.08,288849.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520085,'2507','379',255006.51,256363.18,1356.67,221137.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520086,'2508','379',204524.15,206712.63,2188.48,356722.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520087,'2509','379',167647.91,169398.89,1750.98,285409.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520088,'2510','379',192010.53,193860.98,1850.45,301623.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520089,'2511','379',160714.43,161763.59,1049.16,171013.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520090,'2512','379',92442.05,92442.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179130',3520091,'2513','379',123338.95,125406.33,2067.38,336982.94,0.00,0.00,0.00,0.00,0.00),('1','161','863','179130',3520092,'2514','380',85228.60,85372.82,144.22,31728.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','179130',3520093,'2515','380',66982.05,67804.32,822.27,180899.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520094,'2496','379',90531.55,92003.79,1472.24,239975.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520095,'2497','379',133849.52,133849.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520096,'2498','379',213278.71,215396.74,2118.03,345238.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520097,'2499','379',221928.20,223439.47,1511.27,246337.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520098,'2500','379',200002.65,201530.93,1528.28,249109.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520099,'2501','379',85414.23,86734.55,1320.32,215212.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520100,'2502','379',99540.44,99540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520101,'2503','379',34464.54,35492.76,1028.22,167599.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520102,'2504','379',49118.24,50884.74,1766.50,287939.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','179131',3520103,'2505','379',143508.83,145006.43,1497.60,244108.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520104,'2506','379',266558.11,268846.41,2288.30,372992.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520105,'2507','379',256363.18,258531.08,2167.90,353367.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520106,'2508','379',206712.63,209217.57,2504.94,408305.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520107,'2509','379',169398.89,171056.12,1657.23,270128.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520108,'2510','379',193860.98,195605.54,1744.56,284363.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520109,'2511','379',161763.59,162969.68,1206.09,196592.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520110,'2512','379',92442.05,94105.22,1663.17,271096.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','179131',3520111,'2513','379',125406.33,125406.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179131',3520112,'2514','380',85372.82,86205.72,832.90,183238.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179131',3520113,'2515','380',67804.32,68295.49,491.17,108057.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520114,'2496','379',92003.79,92003.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520115,'2497','379',133849.52,136638.86,2789.34,454662.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520116,'2498','379',215396.74,215396.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520117,'2499','379',223439.47,225638.99,2189.52,356891.76,0.00,0.00,10.00,0.00,0.00),('1','161','861','179132',3520118,'2500','379',201530.93,203486.13,1955.20,318697.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520119,'2501','379',86734.55,86734.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520120,'2502','379',99540.44,101553.70,2013.26,328161.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520121,'2503','379',35492.76,35492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520122,'2504','379',50884.74,51750.71,865.97,141153.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','179132',3520123,'2505','379',145006.43,146681.71,1675.28,273070.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520124,'2506','379',268846.41,270465.01,1618.60,263831.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520125,'2507','379',258531.08,258531.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520126,'2508','379',209217.57,209323.58,106.01,17279.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520127,'2509','379',171056.12,172690.14,1634.02,266345.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520128,'2510','379',195605.54,195605.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520129,'2511','379',162969.68,164996.93,2027.25,330441.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520130,'2512','379',94105.22,94105.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179132',3520131,'2513','379',125406.33,126866.89,1460.56,238071.28,0.00,0.00,0.00,0.00,0.00),('1','161','863','179132',3520132,'2514','380',86205.72,87210.17,1004.45,220979.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179132',3520133,'2515','380',68295.49,69005.63,710.14,156230.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520134,'2496','379',92003.79,92606.99,603.20,98321.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520135,'2497','379',136638.86,137176.53,537.67,87640.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520136,'2498','379',215396.74,216848.76,1452.02,236679.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520137,'2499','379',225638.99,226900.13,1261.14,205565.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520138,'2500','379',203486.13,205011.64,1525.51,248658.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520139,'2501','379',86734.55,87457.38,722.83,117821.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520140,'2502','379',101553.70,102189.18,635.48,103583.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520141,'2503','379',35492.76,35492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520142,'2504','379',51750.71,52362.87,612.16,99782.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','179133',3520143,'2505','379',146681.71,147686.02,1004.31,163702.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520144,'2506','379',270465.01,272249.53,1784.52,290876.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520145,'2507','379',258531.08,260232.25,1701.17,277290.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520146,'2508','379',209323.58,210907.13,1583.55,258118.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520147,'2509','379',172690.14,174087.91,1397.77,227836.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520148,'2510','379',195605.54,197815.90,2210.36,360288.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520149,'2511','379',164996.93,166686.36,1689.43,275377.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520150,'2512','379',94105.22,95019.69,914.47,149058.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','179133',3520151,'2513','379',126866.89,127866.64,999.75,162959.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','179133',3520152,'2514','380',87210.17,88147.12,936.95,206129.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179133',3520153,'2515','380',69005.63,69071.00,65.37,14381.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520154,'2496','379',92606.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520155,'2497','379',137176.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520156,'2498','379',216848.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520157,'2499','379',226900.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520158,'2500','379',205011.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520159,'2501','379',87457.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520160,'2502','379',102189.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520161,'2503','379',35492.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520162,'2504','379',52362.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179134',3520163,'2505','379',147686.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520164,'2506','379',272249.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520165,'2507','379',260232.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520166,'2508','379',210907.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520167,'2509','379',174087.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520168,'2510','379',197815.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520169,'2511','379',166686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520170,'2512','379',95019.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179134',3520171,'2513','379',127866.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179134',3520172,'2514','380',88147.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179134',3520173,'2515','380',69071.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520174,'2496','379',92606.99,94099.73,1492.74,243316.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520175,'2497','379',137176.53,137176.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520176,'2498','379',216848.76,216848.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520177,'2499','379',226900.13,228979.35,2079.22,338912.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520178,'2500','379',205011.64,205023.97,12.33,2009.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520179,'2501','379',87457.38,87457.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520180,'2502','379',102189.18,103345.57,1156.39,188491.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520181,'2503','379',35492.76,37348.61,1855.85,302503.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520182,'2504','379',52362.87,55008.84,2645.97,431293.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','179135',3520183,'2505','379',147686.02,149651.56,1965.54,320383.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520184,'2506','379',272249.53,273917.52,1667.99,271882.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520185,'2507','379',260232.25,261876.92,1644.67,268081.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520186,'2508','379',210907.13,213512.93,2605.80,424745.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520187,'2509','379',174087.91,174087.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520188,'2510','379',197815.90,199331.92,1516.02,247111.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520189,'2511','379',166686.36,168434.69,1748.33,284977.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520190,'2512','379',95019.69,95019.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179135',3520191,'2513','379',127866.64,129537.62,1670.98,272369.74,0.00,0.00,0.00,0.00,0.00),('1','161','863','179135',3520192,'2514','380',88147.12,88187.12,40.00,9000.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179135',3520193,'2515','380',69071.00,70009.84,938.84,211239.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520194,'2496','379',94099.73,94099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520195,'2497','379',137176.53,137176.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520196,'2498','379',216848.76,216848.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520197,'2499','379',228979.35,228979.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520198,'2500','379',205023.97,205023.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520199,'2501','379',87457.38,87457.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520200,'2502','379',103345.57,103345.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520201,'2503','379',37348.61,37348.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520202,'2504','379',55008.84,55008.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179136',3520203,'2505','379',149651.56,149651.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520204,'2506','379',273917.52,276563.59,2646.07,431309.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520205,'2507','379',261876.92,264927.04,3050.12,497169.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520206,'2508','379',213512.93,215207.76,1694.83,276257.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520207,'2509','379',174087.91,176365.29,2277.38,371212.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520208,'2510','379',199331.92,201686.81,2354.89,383847.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520209,'2511','379',168434.69,170633.42,2198.73,358392.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520210,'2512','379',95019.69,96736.40,1716.71,279823.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','179136',3520211,'2513','379',129537.62,130894.72,1357.10,221207.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','179136',3520212,'2514','380',88187.12,88757.56,570.44,128349.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179136',3520213,'2515','380',70009.84,70496.51,486.67,109500.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520214,'2496','379',94099.73,95887.79,1780.06,290149.78,0.00,0.00,8.00,0.00,0.00),('1','161','861','179137',3520215,'2497','379',137176.53,138931.76,1755.23,286102.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520216,'2498','379',216848.76,218772.32,1923.56,313540.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520217,'2499','379',228979.35,230872.06,1892.71,308511.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520218,'2500','379',205023.97,206283.27,1259.30,205265.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520219,'2501','379',87457.38,88739.53,1282.15,208990.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520220,'2502','379',103345.57,104706.44,1360.87,221821.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520221,'2503','379',37348.61,38314.49,965.88,157438.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520222,'2504','379',55008.84,56020.01,1011.17,164820.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','179137',3520223,'2505','379',149651.56,151277.17,1625.61,264974.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520224,'2506','379',276563.59,276563.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520225,'2507','379',264927.04,264927.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520226,'2508','379',215207.76,215207.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520227,'2509','379',176365.29,176365.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520228,'2510','379',201686.81,201686.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520229,'2511','379',170633.42,170633.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520230,'2512','379',96736.40,96736.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179137',3520231,'2513','379',130894.72,130894.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179137',3520232,'2514','380',88757.56,89219.10,461.54,103846.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','179137',3520233,'2515','380',70496.51,70557.51,61.00,13725.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522449,'2496','379',95887.79,97264.15,1376.36,224346.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522450,'2497','379',138931.76,140232.22,1300.46,211974.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522451,'2498','379',218772.32,220522.90,1750.58,285344.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522452,'2499','379',230872.06,232873.40,2001.34,326218.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522453,'2500','379',206283.27,207907.66,1624.39,264775.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522454,'2501','379',88739.53,89779.35,1039.82,169490.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522455,'2502','379',104706.44,105712.40,1005.96,163971.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522456,'2503','379',38314.49,39378.84,1064.35,173489.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522457,'2504','379',56020.01,57107.73,1087.72,177298.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','179255',3522458,'2505','379',151277.17,153869.29,2592.12,422515.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522459,'2506','379',276563.59,277871.97,1308.38,213265.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522460,'2507','379',264927.04,265761.79,834.75,136064.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522461,'2508','379',215207.76,215783.25,575.49,93804.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522462,'2509','379',176365.29,177034.62,669.33,109100.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522463,'2510','379',201686.81,202845.61,1158.80,188884.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522464,'2511','379',170633.42,171886.24,1252.82,204209.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522465,'2512','379',96736.40,97031.61,295.21,48119.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','179255',3522466,'2513','379',130894.72,131488.72,594.00,96822.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179255',3522467,'2514','380',89219.10,89769.12,550.02,123754.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','179255',3522468,'2515','380',70557.51,70777.90,220.39,49587.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522509,'2496','379',97264.15,97923.43,659.28,107462.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522510,'2497','379',140232.22,141141.32,909.10,148183.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522511,'2498','379',220522.90,221777.77,1254.87,204543.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522512,'2499','379',232873.40,234979.09,2105.69,343227.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522513,'2500','379',207907.66,209162.26,1254.60,204499.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522514,'2501','379',89779.35,90609.60,830.25,135330.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522515,'2502','379',105712.40,106051.90,339.50,55338.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522516,'2503','379',39378.84,39378.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522517,'2504','379',57107.73,57984.61,876.88,142931.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','179257',3522518,'2505','379',153869.29,154777.78,908.49,148083.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522519,'2506','379',277871.97,279622.37,1750.40,285315.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522520,'2507','379',265761.79,266912.54,1150.75,187572.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522521,'2508','379',215783.25,216643.09,859.84,140153.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522522,'2509','379',177034.62,178163.62,1129.00,184027.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522523,'2510','379',202845.61,204155.77,1310.16,213556.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522524,'2511','379',171886.24,172703.55,817.31,133221.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522525,'2512','379',97031.61,97031.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179257',3522526,'2513','379',131488.72,132405.53,916.81,149440.03,0.00,0.00,0.00,0.00,0.00),('1','161','863','179257',3522527,'2514','380',89769.12,90548.05,778.93,175259.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','179257',3522528,'2515','380',70777.90,71177.90,400.00,90000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522542,'2496','379',97923.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522543,'2497','379',141141.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522544,'2498','379',221777.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522545,'2499','379',234979.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522546,'2500','379',209162.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522547,'2501','379',90609.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522548,'2502','379',106051.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522549,'2503','379',39378.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522550,'2504','379',57984.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179259',3522551,'2505','379',154777.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522552,'2506','379',279622.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522553,'2507','379',266912.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522554,'2508','379',216643.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522555,'2509','379',178163.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522556,'2510','379',204155.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522557,'2511','379',172703.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522558,'2512','379',97031.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179259',3522559,'2513','379',132405.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179259',3522560,'2514','380',90548.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179259',3522561,'2515','380',71177.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522591,'2496','379',97923.43,97923.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522592,'2497','379',141141.32,142237.95,1096.63,178750.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522593,'2498','379',221777.77,223181.62,1403.85,228827.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522594,'2499','379',234979.09,236424.65,1445.56,235626.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522595,'2500','379',209162.26,210656.28,1494.02,243525.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522596,'2501','379',90609.60,91130.93,521.33,84976.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522597,'2502','379',106051.90,106907.10,855.20,139397.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522598,'2503','379',39378.84,39400.56,21.72,3540.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522599,'2504','379',57984.61,58031.87,47.26,7703.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','179262',3522600,'2505','379',154777.78,156409.29,1631.51,265936.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522601,'2506','379',279622.37,281104.48,1482.11,241583.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522602,'2507','379',266912.54,268914.80,2002.26,326368.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522603,'2508','379',216643.09,217840.99,1197.90,195257.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522604,'2509','379',178163.62,179370.71,1207.09,196755.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522605,'2510','379',204155.77,205430.36,1274.59,207758.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522606,'2511','379',172703.55,173996.79,1293.24,210798.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522607,'2512','379',97031.61,97031.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179262',3522608,'2513','379',132405.53,133145.77,740.24,120659.12,0.00,0.00,0.00,0.00,0.00),('1','161','863','179262',3522609,'2514','380',90548.05,91126.69,578.64,133087.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','179262',3522610,'2515','380',71177.90,71177.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522611,'2496','379',97923.43,98922.36,998.93,162825.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522612,'2497','379',142237.95,143680.90,1442.95,235200.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522613,'2498','379',223181.62,225013.26,1831.64,298557.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522614,'2499','379',236424.65,238340.93,1916.28,312353.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522615,'2500','379',210656.28,212024.38,1368.10,223000.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522616,'2501','379',91130.93,92430.77,1299.84,211873.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522617,'2502','379',106907.10,107562.04,654.94,106755.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522618,'2503','379',39400.56,40275.27,874.71,142577.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522619,'2504','379',58031.87,58031.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179263',3522620,'2505','379',156409.29,157691.46,1282.17,208993.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522621,'2506','379',281104.48,281962.89,858.41,139920.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522622,'2507','379',268914.80,269726.24,811.44,132264.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522623,'2508','379',217840.99,218406.35,565.36,92153.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522624,'2509','379',179370.71,179914.84,544.13,88693.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522625,'2510','379',205430.36,206175.18,744.82,121405.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522626,'2511','379',173996.79,174482.41,485.62,79156.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522627,'2512','379',97031.61,97571.42,539.81,87989.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','179263',3522628,'2513','379',133145.77,133145.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179263',3522629,'2514','380',91126.69,91676.90,550.21,126548.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','179263',3522630,'2515','380',71177.90,71749.82,571.92,131541.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533416,'2496','379',98922.36,98922.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533417,'2497','379',143680.90,145215.20,1534.30,250090.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533418,'2498','379',225013.26,226454.62,1441.36,234941.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533419,'2499','379',238340.93,240016.40,1675.47,273101.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533420,'2500','379',212024.38,213979.36,1954.98,318661.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533421,'2501','379',92430.77,92430.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533422,'2502','379',107562.04,108643.74,1081.70,176317.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533423,'2503','379',40275.27,42281.40,2006.13,326999.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533424,'2504','379',58031.87,60031.87,2000.00,326000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179831',3533425,'2505','379',157691.46,159354.31,1662.85,271044.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533426,'2506','379',281962.89,284326.42,2363.53,385255.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533427,'2507','379',269726.24,271186.70,1460.46,238054.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533428,'2508','379',218406.35,219777.56,1371.21,223507.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533429,'2509','379',179914.84,181058.28,1143.44,186380.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533430,'2510','379',206175.18,207517.91,1342.73,218864.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533431,'2511','379',174482.41,175621.74,1139.33,185710.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533432,'2512','379',97571.42,97571.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179831',3533433,'2513','379',133145.77,134710.65,1564.88,255075.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','179831',3533434,'2514','380',91676.90,91676.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179831',3533435,'2515','380',71749.82,72017.84,268.02,61644.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533675,'2496','379',98922.36,99471.09,548.73,89442.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533676,'2497','379',145215.20,145858.65,643.45,104882.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533677,'2498','379',226454.62,227636.52,1181.90,192649.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533678,'2499','379',240016.40,241284.31,1267.91,206669.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533679,'2500','379',213979.36,215633.66,1654.30,269650.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533680,'2501','379',92430.77,92441.21,10.44,1701.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533681,'2502','379',108643.74,109390.73,746.99,121759.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533682,'2503','379',42281.40,42281.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533683,'2504','379',60031.87,60580.49,548.62,89425.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','179844',3533684,'2505','379',159354.31,160255.98,901.67,146972.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533685,'2506','379',284326.42,286077.96,1751.54,285501.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533686,'2507','379',271186.70,273294.38,2107.68,343551.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533687,'2508','379',219777.56,220700.27,900.71,146815.73,0.00,0.00,22.00,0.00,0.00),('1','161','862','179844',3533688,'2509','379',181058.28,182289.47,1231.19,200683.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533689,'2510','379',207517.91,208567.70,1049.79,171115.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533690,'2511','379',175621.74,176358.42,736.68,120078.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533691,'2512','379',97571.42,97571.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179844',3533692,'2513','379',134710.65,135419.65,709.00,115567.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179844',3533693,'2514','380',91676.90,92589.28,912.38,209847.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','179844',3533694,'2515','380',72017.84,72037.84,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','179849',3533782,'2496','379',99471.09,99471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533783,'2497','379',145858.65,147385.26,1526.61,248837.43,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533784,'2498','379',227636.52,229030.85,1394.33,227275.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533785,'2499','379',241284.31,243077.46,1793.15,292283.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533786,'2500','379',215633.66,216597.12,963.46,157043.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533787,'2501','379',92441.21,93854.89,1413.68,230429.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533788,'2502','379',109390.73,109390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533789,'2503','379',42281.40,42281.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533790,'2504','379',60580.49,60580.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179849',3533791,'2505','379',160255.98,161246.10,990.12,161389.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533792,'2506','379',286077.96,287934.67,1856.71,302643.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533793,'2507','379',273294.38,275440.92,2146.54,349886.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533794,'2508','379',220700.27,222251.57,1551.30,252861.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533795,'2509','379',182289.47,183565.94,1276.47,208064.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533796,'2510','379',208567.70,209564.35,996.65,162453.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533797,'2511','379',176358.42,177539.25,1180.83,192475.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533798,'2512','379',97571.42,98720.66,1149.24,187326.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','179849',3533799,'2513','379',135419.65,135419.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179849',3533800,'2514','380',92589.28,93559.28,970.00,223100.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179849',3533801,'2515','380',72037.84,72427.27,389.43,89568.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','179852',3533828,'2496','379',99471.09,100492.44,981.35,159960.05,0.00,0.00,40.00,0.00,0.00),('1','161','861','179852',3533829,'2497','379',147385.26,148926.07,1520.81,247892.03,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533830,'2498','379',229030.85,231011.25,1960.40,319545.20,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533831,'2499','379',243077.46,245018.43,1910.97,311488.11,0.00,0.00,30.00,0.00,0.00),('1','161','861','179852',3533832,'2500','379',216597.12,218747.05,2129.93,347178.59,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533833,'2501','379',93854.89,93874.89,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533834,'2502','379',109390.73,110902.18,1491.45,243106.35,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533835,'2503','379',42281.40,42301.40,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533836,'2504','379',60580.49,61560.59,960.10,156496.30,0.00,0.00,20.00,0.00,0.00),('1','161','861','179852',3533837,'2505','379',161246.10,162618.18,1352.08,220389.04,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533838,'2506','379',287934.67,290331.54,2376.87,387429.81,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533839,'2507','379',275440.92,275462.52,0.00,0.00,0.00,0.00,21.60,0.00,0.00),('1','161','862','179852',3533840,'2508','379',222251.57,223906.21,1634.64,266446.32,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533841,'2509','379',183565.94,184800.84,1214.90,198028.70,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533842,'2510','379',209564.35,211202.21,1617.86,263711.18,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533843,'2511','379',177539.25,178875.19,1315.94,214498.22,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533844,'2512','379',98720.66,99952.85,1212.19,197586.97,0.00,0.00,20.00,0.00,0.00),('1','161','862','179852',3533845,'2513','379',135419.65,136539.21,1099.56,179228.28,0.00,0.00,20.00,0.00,0.00),('1','161','863','179852',3533846,'2514','380',93559.28,93579.28,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','863','179852',3533847,'2515','380',72427.27,72846.73,399.46,91875.80,0.00,0.00,20.00,0.00,0.00),('1','161','861','179861',3533972,'2496','379',100492.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533973,'2497','379',148926.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533974,'2498','379',231011.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533975,'2499','379',245018.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533976,'2500','379',218747.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533977,'2501','379',93874.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533978,'2502','379',110902.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533979,'2503','379',42301.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533980,'2504','379',61560.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179861',3533981,'2505','379',162618.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533982,'2506','379',290331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533983,'2507','379',275462.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533984,'2508','379',223906.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533985,'2509','379',184800.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533986,'2510','379',211202.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533987,'2511','379',178875.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533988,'2512','379',99952.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179861',3533989,'2513','379',136539.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179861',3533990,'2514','380',93579.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','179861',3533991,'2515','380',72846.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533992,'2496','379',100492.44,101622.80,1130.36,184248.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533993,'2497','379',148926.07,149211.40,285.33,46508.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533994,'2498','379',231011.25,233004.87,1993.62,324960.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533995,'2499','379',245018.43,246910.34,1891.91,308381.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533996,'2500','379',218747.05,220153.34,1406.29,229225.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533997,'2501','379',93874.89,93874.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533998,'2502','379',110902.18,112395.93,1493.75,243481.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3533999,'2503','379',42301.40,42301.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3534000,'2504','379',61560.59,61560.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179862',3534001,'2505','379',162618.18,164609.21,1991.03,324537.89,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534002,'2506','379',290331.54,292113.15,1781.61,290402.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534003,'2507','379',275462.52,277402.32,1939.80,316187.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534004,'2508','379',223906.21,225108.68,1202.47,196002.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534005,'2509','379',184800.84,186195.61,1394.77,227347.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534006,'2510','379',211202.21,212627.68,1425.47,232351.61,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534007,'2511','379',178875.19,179973.51,1098.32,179026.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534008,'2512','379',99952.85,100137.81,184.96,30148.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','179862',3534009,'2513','379',136539.21,137778.41,1239.20,201989.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','179862',3534010,'2514','380',93579.28,93690.02,110.74,26023.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','179862',3534011,'2515','380',72846.73,72846.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534046,'2496','379',101622.80,102426.73,803.93,131040.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534047,'2497','379',149211.40,150461.34,1249.94,203740.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534048,'2498','379',233004.87,234477.01,1472.14,239958.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534049,'2499','379',246910.34,248809.97,1899.63,309639.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534050,'2500','379',220153.34,221370.22,1216.88,198351.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534051,'2501','379',93874.89,94687.53,812.64,132460.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534052,'2502','379',112395.93,113241.51,845.58,137829.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534053,'2503','379',42301.40,43408.93,1107.53,180527.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534054,'2504','379',61560.59,63106.50,1545.91,251983.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','179865',3534055,'2505','379',164609.21,165891.12,1281.91,208951.33,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534056,'2506','379',292113.15,293660.33,1547.18,252190.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534057,'2507','379',277402.32,278884.00,1481.68,241513.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534058,'2508','379',225108.68,226289.07,1180.39,192403.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534059,'2509','379',186195.61,186953.26,757.65,123496.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534060,'2510','379',212627.68,213628.51,1000.83,163135.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534061,'2511','379',179973.51,181195.35,1221.84,199159.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534062,'2512','379',100137.81,100137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','179865',3534063,'2513','379',137778.41,138784.63,1006.22,164013.86,0.00,0.00,0.00,0.00,0.00),('1','161','863','179865',3534064,'2514','380',93690.02,94213.68,523.66,123060.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','179865',3534065,'2515','380',72846.73,72846.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538334,'2496','379',102426.73,102574.47,147.74,24081.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538335,'2497','379',150461.34,151396.66,935.32,152457.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538336,'2498','379',234477.01,235575.80,1098.79,179102.77,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538337,'2499','379',248809.97,249985.66,1175.69,191637.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538338,'2500','379',221370.22,222299.05,928.83,151399.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538339,'2501','379',94687.53,95594.85,907.32,147893.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538340,'2502','379',113241.51,113446.62,205.11,33432.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538341,'2503','379',43408.93,43408.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538342,'2504','379',63106.50,63295.10,188.60,30741.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','180099',3538343,'2505','379',165891.12,167076.29,1185.17,193182.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538344,'2506','379',293660.33,294754.38,1094.05,178330.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538345,'2507','379',278884.00,280151.73,1267.73,206639.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538346,'2508','379',226289.07,226289.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538347,'2509','379',186953.26,187758.26,805.00,131215.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538348,'2510','379',213628.51,214992.71,1364.20,222364.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538349,'2511','379',181195.35,181413.54,218.19,35564.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538350,'2512','379',100137.81,100137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180099',3538351,'2513','379',138784.63,139125.21,340.58,55514.54,0.00,0.00,0.00,0.00,0.00),('1','161','863','180099',3538352,'2514','380',94213.68,94677.65,463.97,109032.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','180099',3538353,'2515','380',72846.73,72855.24,8.51,1999.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538586,'2496','379',102574.47,102574.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538587,'2497','379',151396.66,152358.98,962.32,156858.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538588,'2498','379',235575.80,236967.76,1391.96,226889.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538589,'2499','379',249985.66,251354.54,1368.88,223127.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538590,'2500','379',222299.05,223622.03,1322.98,215645.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538591,'2501','379',95594.85,96602.71,1007.86,164281.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538592,'2502','379',113446.62,113446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538593,'2503','379',43408.93,47154.26,3745.33,610488.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538594,'2504','379',63295.10,66918.03,3622.93,590537.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','180112',3538595,'2505','379',167076.29,168222.92,1146.63,186900.69,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538596,'2506','379',294754.38,296202.83,1448.45,236097.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538597,'2507','379',280151.73,282422.80,2271.07,370184.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538598,'2508','379',226289.07,227596.77,1307.70,213155.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538599,'2509','379',187758.26,189062.69,1304.43,212622.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538600,'2510','379',214992.71,216227.03,1234.32,201194.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538601,'2511','379',181413.54,182701.02,1287.48,209859.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538602,'2512','379',100137.81,100137.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180112',3538603,'2513','379',139125.21,140434.74,1309.53,213453.39,0.00,0.00,0.00,0.00,0.00),('1','161','863','180112',3538604,'2514','380',94677.65,94690.42,12.77,3000.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','180112',3538605,'2515','380',72855.24,73119.42,264.18,62082.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547984,'2496','379',102574.47,102917.30,342.83,55881.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547985,'2497','379',152358.98,153487.19,1128.21,183898.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547986,'2498','379',236967.76,237966.07,998.31,162724.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547987,'2499','379',251354.54,252429.94,1075.40,175290.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547988,'2500','379',223622.03,224478.60,856.57,139620.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547989,'2501','379',96602.71,96602.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547990,'2502','379',113446.62,114075.26,628.64,102468.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547991,'2503','379',47154.26,47325.51,171.25,27913.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547992,'2504','379',66918.03,66918.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180628',3547993,'2505','379',168222.92,168839.72,616.80,100538.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547994,'2506','379',296202.83,297210.51,1007.68,164251.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547995,'2507','379',282422.80,283838.03,1415.23,230682.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547996,'2508','379',227596.77,228464.90,868.13,141505.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547997,'2509','379',189062.69,189062.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547998,'2510','379',216227.03,217134.84,907.81,147973.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3547999,'2511','379',182701.02,182701.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3548000,'2512','379',100137.81,100892.06,754.25,122942.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','180628',3548001,'2513','379',140434.74,140434.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180628',3548002,'2514','380',94690.42,95232.22,541.80,127323.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180628',3548003,'2515','380',73119.42,73119.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548586,'2496','379',102917.30,102917.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548587,'2497','379',153487.19,154424.02,936.83,152703.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548588,'2498','379',237966.07,239510.76,1544.69,251784.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548589,'2499','379',252429.94,253645.06,1215.12,198064.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548590,'2500','379',224478.60,225358.04,879.44,143348.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548591,'2501','379',96602.71,96602.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548592,'2502','379',114075.26,114700.49,625.23,101912.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548593,'2503','379',47325.51,48195.51,870.00,141810.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548594,'2504','379',66918.03,68273.53,1355.50,220946.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','180661',3548595,'2505','379',168839.72,170126.51,1286.79,209746.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548596,'2506','379',297210.51,298433.58,1223.07,199360.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548597,'2507','379',283838.03,284724.88,886.85,144556.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548598,'2508','379',228464.90,229441.44,976.54,159176.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548599,'2509','379',189062.69,189845.33,782.64,127570.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548600,'2510','379',217134.84,218103.55,968.71,157899.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548601,'2511','379',182701.02,183289.98,588.96,96000.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548602,'2512','379',100892.06,100892.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180661',3548603,'2513','379',140434.74,141370.82,936.08,152581.04,0.00,0.00,0.00,0.00,0.00),('1','161','863','180661',3548604,'2514','380',95232.22,95564.51,332.29,78088.15,0.00,0.00,0.00,0.00,0.00),('1','161','863','180661',3548605,'2515','380',73119.42,73404.10,284.68,66899.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551037,'2496','379',102917.30,103772.13,854.83,139337.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551038,'2497','379',154424.02,154424.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551039,'2498','379',239510.76,241529.19,2018.43,329004.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551040,'2499','379',253645.06,255260.36,1615.30,263293.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551041,'2500','379',225358.04,225358.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551042,'2501','379',96602.71,97693.56,1090.85,177808.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551043,'2502','379',114700.49,114700.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551044,'2503','379',48195.51,48195.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551045,'2504','379',68273.53,68273.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180792',3551046,'2505','379',170126.51,171379.33,1252.82,204209.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551047,'2506','379',298433.58,301212.77,2779.19,453007.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551048,'2507','379',284724.88,285270.63,545.75,88957.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551049,'2508','379',229441.44,231076.42,1634.98,266501.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551050,'2509','379',189845.33,191306.64,1461.31,238193.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551051,'2510','379',218103.55,219502.63,1399.08,228050.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551052,'2511','379',183289.98,184372.30,1082.32,176418.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551053,'2512','379',100892.06,102550.18,1658.12,270273.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','180792',3551054,'2513','379',141370.82,141827.54,456.72,74445.36,0.00,0.00,0.00,0.00,0.00),('1','161','863','180792',3551055,'2514','380',95564.51,95564.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180792',3551056,'2515','380',73404.10,73540.49,136.39,32051.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551075,'2496','379',103772.13,103772.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551076,'2497','379',154424.02,155768.09,1344.07,219083.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551077,'2498','379',241529.19,242672.24,1143.05,186317.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551078,'2499','379',255260.36,256961.29,1700.93,277251.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551079,'2500','379',225358.04,226946.86,1588.82,258977.66,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551080,'2501','379',97693.56,98636.47,942.91,153694.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551081,'2502','379',114700.49,114710.92,10.43,1700.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551082,'2503','379',48195.51,50104.71,1909.20,311199.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551083,'2504','379',68273.53,70173.53,1900.00,309700.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180794',3551084,'2505','379',171379.33,171379.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551085,'2506','379',301212.77,302531.79,1319.02,215000.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551086,'2507','379',285270.63,286721.08,1450.45,236423.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551087,'2508','379',231076.42,232320.96,1244.54,202860.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551088,'2509','379',191306.64,192323.96,1017.32,165823.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551089,'2510','379',219502.63,220563.23,1060.60,172877.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551090,'2511','379',184372.30,185282.74,910.44,148401.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551091,'2512','379',102550.18,102550.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180794',3551092,'2513','379',141827.54,142973.64,1146.10,186814.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','180794',3551093,'2514','380',95564.51,96371.74,807.23,189699.05,0.00,0.00,0.00,0.00,0.00),('1','161','863','180794',3551094,'2515','380',73540.49,73908.26,367.77,86425.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551144,'2496','379',103772.13,105367.22,1595.09,259999.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551145,'2497','379',155768.09,155768.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551146,'2498','379',242672.24,244215.39,1543.15,251533.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551147,'2499','379',256961.29,258566.78,1605.49,261694.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551148,'2500','379',226946.86,228589.50,1642.64,267750.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551149,'2501','379',98636.47,99595.43,958.96,156310.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551150,'2502','379',114710.92,115897.87,1186.95,193472.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551151,'2503','379',50104.71,50104.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551152,'2504','379',70173.53,70628.82,455.29,74212.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','180797',3551153,'2505','379',171379.33,173285.14,1905.81,310647.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551154,'2506','379',302531.79,304709.93,2178.14,355036.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551155,'2507','379',286721.08,289162.23,2441.15,397907.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551156,'2508','379',232320.96,233967.74,1646.78,268425.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551157,'2509','379',192323.96,193720.38,1396.42,227616.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551158,'2510','379',220563.23,221717.08,1153.85,188077.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551159,'2511','379',185282.74,186569.49,1286.75,209740.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551160,'2512','379',102550.18,103480.76,930.58,151684.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','180797',3551161,'2513','379',142973.64,144444.23,1450.59,236446.17,0.00,0.00,20.00,0.00,0.00),('1','161','863','180797',3551162,'2514','380',96371.74,97209.42,837.68,196854.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','180797',3551163,'2515','380',73908.26,73972.09,63.83,15000.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551200,'2496','379',105367.22,106315.28,948.06,154533.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551201,'2497','379',155768.09,155768.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551202,'2498','379',244215.39,245620.12,1404.73,228970.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551203,'2499','379',258566.78,260222.55,1655.77,269890.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551204,'2500','379',228589.50,230210.28,1620.78,264187.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551205,'2501','379',99595.43,100204.84,609.41,99333.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551206,'2502','379',115897.87,116568.79,670.92,109359.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551207,'2503','379',50104.71,53034.62,2929.91,477575.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551208,'2504','379',70628.82,73898.27,3269.45,532920.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','180800',3551209,'2505','379',173285.14,174474.35,1189.21,193841.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551210,'2506','379',304709.93,306262.18,1552.25,253016.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551211,'2507','379',289162.23,290621.57,1459.34,237872.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551212,'2508','379',233967.74,235404.02,1436.28,234113.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551213,'2509','379',193720.38,194760.20,1039.82,169490.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551214,'2510','379',221717.08,222574.66,857.58,139785.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551215,'2511','379',186569.49,187559.28,989.79,161335.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551216,'2512','379',103480.76,103480.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180800',3551217,'2513','379',144444.23,145512.54,1068.31,174134.53,0.00,0.00,0.00,0.00,0.00),('1','161','863','180800',3551218,'2514','380',97209.42,97209.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180800',3551219,'2515','380',73972.09,74118.26,146.17,34349.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551254,'2496','379',106315.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551255,'2497','379',155768.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551256,'2498','379',245620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551257,'2499','379',260222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551258,'2500','379',230210.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551259,'2501','379',100204.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551260,'2502','379',116568.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551261,'2503','379',53034.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551262,'2504','379',73898.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180803',3551263,'2505','379',174474.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551264,'2506','379',306262.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551265,'2507','379',290621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551266,'2508','379',235404.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551267,'2509','379',194760.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551268,'2510','379',222574.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551269,'2511','379',187559.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551270,'2512','379',103480.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180803',3551271,'2513','379',145512.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180803',3551272,'2514','380',97209.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180803',3551273,'2515','380',74118.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551335,'2496','379',106315.28,106845.38,530.10,86406.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551336,'2497','379',155768.09,157116.81,1348.72,219841.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551337,'2498','379',245620.12,247156.68,1536.56,250459.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551338,'2499','379',260222.55,261761.96,1539.41,250923.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551339,'2500','379',230210.28,231306.45,1096.17,178675.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551340,'2501','379',100204.84,101821.46,1616.62,263509.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551341,'2502','379',116568.79,116568.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551342,'2503','379',53034.62,53160.72,126.10,20554.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551343,'2504','379',73898.27,74810.17,911.90,148639.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','180807',3551344,'2505','379',174474.35,175621.25,1146.90,186944.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551345,'2506','379',306262.18,307588.96,1326.78,216265.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551346,'2507','379',290621.57,291607.05,985.48,160633.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551347,'2508','379',235404.02,236914.12,1510.10,246146.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551348,'2509','379',194760.20,195651.21,891.01,145234.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551349,'2510','379',222574.66,223579.75,1005.09,163829.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551350,'2511','379',187559.28,188193.83,634.55,103431.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551351,'2512','379',103480.76,104186.43,705.67,115024.21,0.00,0.00,0.00,0.00,0.00),('1','161','862','180807',3551352,'2513','379',145512.54,145962.33,449.79,73315.77,0.00,0.00,0.00,0.00,0.00),('1','161','863','180807',3551353,'2514','380',97209.42,97810.85,601.43,144343.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','180807',3551354,'2515','380',74118.26,74118.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551389,'2496','379',106845.38,108210.91,1365.53,222581.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551390,'2497','379',157116.81,158660.34,1543.53,251595.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551391,'2498','379',247156.68,248900.02,1743.34,284164.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551392,'2499','379',261761.96,263639.77,1877.81,306083.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551393,'2500','379',231306.45,233019.52,1713.07,279230.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551394,'2501','379',101821.46,103117.85,1296.39,211311.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551395,'2502','379',116568.79,117918.55,1349.76,220010.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551396,'2503','379',53160.72,55000.82,1840.10,299936.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551397,'2504','379',74810.17,76085.67,1275.50,207906.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','180810',3551398,'2505','379',175621.25,176963.64,1342.39,218809.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551399,'2506','379',307588.96,307588.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551400,'2507','379',291607.05,291607.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551401,'2508','379',236914.12,236914.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551402,'2509','379',195651.21,195651.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551403,'2510','379',223579.75,223579.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551404,'2511','379',188193.83,188193.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551405,'2512','379',104186.43,104186.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180810',3551406,'2513','379',145962.33,145962.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180810',3551407,'2514','380',97810.85,97988.42,177.57,42616.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','180810',3551408,'2515','380',74118.26,74178.26,60.00,14400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553510,'2496','379',108210.91,109963.23,1752.32,285628.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553511,'2497','379',158660.34,161549.71,2889.37,470967.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553512,'2498','379',248900.02,252170.12,3270.10,533026.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553513,'2499','379',263639.77,266330.43,2690.66,438577.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553514,'2500','379',233019.52,235344.73,2325.21,379009.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553515,'2501','379',103117.85,105536.19,2418.34,394189.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553516,'2502','379',117918.55,119669.19,1750.64,285354.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553517,'2503','379',55000.82,57136.04,2135.22,348040.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553518,'2504','379',76085.67,78291.25,2205.58,359509.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','180915',3553519,'2505','379',176963.64,178934.49,1970.85,321248.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553520,'2506','379',307588.96,307588.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553521,'2507','379',291607.05,291607.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553522,'2508','379',236914.12,236914.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553523,'2509','379',195651.21,195651.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553524,'2510','379',223579.75,223579.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553525,'2511','379',188193.83,188193.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553526,'2512','379',104186.43,104186.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','180915',3553527,'2513','379',145962.33,145962.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','180915',3553528,'2514','380',97988.42,98097.15,108.73,26095.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','180915',3553529,'2515','380',74178.26,74182.43,4.17,1000.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588653,'2496','379',109963.23,109963.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588654,'2497','379',161549.71,161549.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588655,'2498','379',252170.12,252170.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588656,'2499','379',266330.43,266330.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588657,'2500','379',235344.73,235344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588658,'2501','379',105536.19,105536.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588659,'2502','379',119669.19,119669.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588660,'2503','379',57136.04,57136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588661,'2504','379',78291.25,78291.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182833',3588662,'2505','379',178934.49,178934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588663,'2506','379',307588.96,310215.39,2626.43,428108.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588664,'2507','379',291607.05,295762.60,4155.55,677354.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588665,'2508','379',236914.12,239511.81,2597.69,423423.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588666,'2509','379',195651.21,199039.30,3388.09,552258.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588667,'2510','379',223579.75,226377.23,2797.48,455989.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588668,'2511','379',188193.83,191152.88,2959.05,482325.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588669,'2512','379',104186.43,106590.28,2403.85,391827.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','182833',3588670,'2513','379',145962.33,148036.22,2073.89,338044.07,0.00,0.00,0.00,0.00,0.00),('1','161','863','182833',3588671,'2514','380',98097.15,98542.40,445.25,106860.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182833',3588672,'2515','380',74182.43,74242.43,60.00,14400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588704,'2496','379',109963.23,109963.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588705,'2497','379',161549.71,162040.54,490.83,80005.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588706,'2498','379',252170.12,252587.83,417.71,68086.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588707,'2499','379',266330.43,266915.77,585.34,95410.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588708,'2500','379',235344.73,235611.33,266.60,43455.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588709,'2501','379',105536.19,105830.20,294.01,47923.63,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588710,'2502','379',119669.19,119993.60,324.41,52878.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588711,'2503','379',57136.04,57488.34,352.30,57424.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588712,'2504','379',78291.25,78377.03,85.78,13982.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','182836',3588713,'2505','379',178934.49,179408.14,473.65,77204.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588714,'2506','379',310215.39,312736.83,2500.93,407651.59,0.00,0.00,20.51,0.00,0.00),('1','161','862','182836',3588715,'2507','379',295762.60,299386.81,3624.21,590746.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588716,'2508','379',239511.81,241692.88,2181.07,355514.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588717,'2509','379',199039.30,201594.30,2555.00,416465.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588718,'2510','379',226377.23,229570.41,3193.18,520488.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588719,'2511','379',191152.88,193294.65,2141.77,349108.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588720,'2512','379',106590.28,108810.74,2220.46,361934.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','182836',3588721,'2513','379',148036.22,149733.39,1676.66,273295.58,0.00,0.00,20.51,0.00,0.00),('1','161','863','182836',3588722,'2514','380',98542.40,99205.78,663.38,159211.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','182836',3588723,'2515','380',74242.43,74242.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588725,'2496','379',109963.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588726,'2497','379',162040.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588727,'2498','379',252587.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588728,'2499','379',266915.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588729,'2500','379',235611.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588730,'2501','379',105830.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588731,'2502','379',119993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588732,'2503','379',57488.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588733,'2504','379',78377.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182838',3588734,'2505','379',179408.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588735,'2506','379',312736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588736,'2507','379',299386.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588737,'2508','379',241692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588738,'2509','379',201594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588739,'2510','379',229570.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588740,'2511','379',193294.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588741,'2512','379',108810.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182838',3588742,'2513','379',149733.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182838',3588743,'2514','380',99205.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182838',3588744,'2515','380',74242.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588745,'2496','379',109963.23,112154.13,2190.90,357116.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588746,'2497','379',162040.54,164938.77,2898.23,472411.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588747,'2498','379',252587.83,253595.94,1008.11,164321.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588748,'2499','379',266915.77,269260.13,2344.36,382130.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588749,'2500','379',235611.33,237711.36,2100.03,342304.89,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588750,'2501','379',105830.20,106017.09,186.89,30463.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588751,'2502','379',119993.60,120239.47,245.87,40076.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588752,'2503','379',57488.34,59670.44,2182.10,355682.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588753,'2504','379',78377.03,81908.42,3531.39,575616.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','182839',3588754,'2505','379',179408.14,182153.94,2745.80,447565.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588755,'2506','379',312736.83,312736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588756,'2507','379',299386.81,299386.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588757,'2508','379',241692.88,241692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588758,'2509','379',201594.30,201594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588759,'2510','379',229570.41,229570.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588760,'2511','379',193294.65,193294.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588761,'2512','379',108810.74,108810.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182839',3588762,'2513','379',149733.39,149733.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182839',3588763,'2514','380',99205.78,99654.98,449.20,110054.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182839',3588764,'2515','380',74242.43,74353.50,111.07,27212.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588774,'2496','379',112154.13,113682.53,1528.40,249129.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588775,'2497','379',164938.77,165710.74,771.97,125831.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588776,'2498','379',253595.94,253595.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588777,'2499','379',269260.13,269260.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588778,'2500','379',237711.36,238975.77,1264.41,206098.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588779,'2501','379',106017.09,106017.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588780,'2502','379',120239.47,120239.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588781,'2503','379',59670.44,61376.58,1706.14,278100.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588782,'2504','379',81908.42,82622.36,713.94,116372.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','182841',3588783,'2505','379',182153.94,183351.82,1197.88,195254.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588784,'2506','379',312736.83,312736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588785,'2507','379',299386.81,299386.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588786,'2508','379',241692.88,241692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588787,'2509','379',201594.30,201594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588788,'2510','379',229570.41,229570.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588789,'2511','379',193294.65,193294.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588790,'2512','379',108810.74,108810.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182841',3588791,'2513','379',149733.39,149733.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182841',3588792,'2514','380',99654.98,99654.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182841',3588793,'2515','380',74353.50,74489.01,135.51,33199.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588794,'2496','379',113682.53,113682.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588795,'2497','379',165710.74,165710.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588796,'2498','379',253595.94,255876.37,2280.43,371710.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588797,'2499','379',269260.13,271266.18,2006.05,326986.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588798,'2500','379',238975.77,238975.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588799,'2501','379',106017.09,107564.16,1547.07,252172.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588800,'2502','379',120239.47,122775.20,2535.73,413323.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588801,'2503','379',61376.58,64748.99,3372.41,549702.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588802,'2504','379',82622.36,85924.06,3301.70,538177.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','182842',3588803,'2505','379',183351.82,183351.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588804,'2506','379',312736.83,312736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588805,'2507','379',299386.81,299386.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588806,'2508','379',241692.88,241692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588807,'2509','379',201594.30,201594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588808,'2510','379',229570.41,229570.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588809,'2511','379',193294.65,193294.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588810,'2512','379',108810.74,108810.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182842',3588811,'2513','379',149733.39,149733.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182842',3588812,'2514','380',99654.98,100118.22,463.24,113493.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','182842',3588813,'2515','380',74489.01,74489.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588814,'2496','379',113682.53,116742.97,3060.44,498851.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588815,'2497','379',165710.74,167862.25,2151.51,350696.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588816,'2498','379',255876.37,255876.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588817,'2499','379',271266.18,271266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588818,'2500','379',238975.77,241440.65,2464.88,401775.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588819,'2501','379',107564.16,107564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588820,'2502','379',122775.20,122775.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588821,'2503','379',64748.99,66267.28,1518.29,247481.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588822,'2504','379',85924.06,87544.47,1620.41,264126.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','182843',3588823,'2505','379',183351.82,186506.94,3155.12,514284.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588824,'2506','379',312736.83,312736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588825,'2507','379',299386.81,299386.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588826,'2508','379',241692.88,241692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588827,'2509','379',201594.30,201594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588828,'2510','379',229570.41,229570.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588829,'2511','379',193294.65,193294.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588830,'2512','379',108810.74,108810.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182843',3588831,'2513','379',149733.39,149733.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182843',3588832,'2514','380',100118.22,100718.22,600.00,147000.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182843',3588833,'2515','380',74489.01,74609.83,120.82,29600.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588855,'2496','379',116742.97,117035.41,292.44,47667.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588856,'2497','379',167862.25,170385.95,2523.70,411363.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588857,'2498','379',255876.37,257018.93,1142.56,186237.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588858,'2499','379',271266.18,271446.99,180.81,29472.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588859,'2500','379',241440.65,243614.27,2173.62,354300.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588860,'2501','379',107564.16,110313.73,2749.57,448179.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588861,'2502','379',122775.20,123033.27,258.07,42065.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588862,'2503','379',66267.28,68588.53,2321.25,378363.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588863,'2504','379',87544.47,89574.64,2030.17,330917.71,0.00,0.00,0.00,0.00,0.00),('1','161','861','182846',3588864,'2505','379',186506.94,189061.42,2554.48,416380.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588865,'2506','379',312736.83,313394.73,657.90,107237.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588866,'2507','379',299386.81,299937.32,550.51,89733.13,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588867,'2508','379',241692.88,242221.95,529.07,86238.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588868,'2509','379',201594.30,202405.76,811.46,132267.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588869,'2510','379',229570.41,230333.47,763.06,124378.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588870,'2511','379',193294.65,194236.76,942.11,153563.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588871,'2512','379',108810.74,110823.14,2012.40,328021.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','182846',3588872,'2513','379',149733.39,151727.97,1994.58,325116.54,0.00,0.00,0.00,0.00,0.00),('1','161','863','182846',3588873,'2514','380',100718.22,100799.03,80.81,19798.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','182846',3588874,'2515','380',74609.83,74609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588878,'2496','379',117035.41,117035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588879,'2497','379',170385.95,171048.19,662.24,107945.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588880,'2498','379',257018.93,257018.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588881,'2499','379',271446.99,272715.41,1268.42,206752.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588882,'2500','379',243614.27,244937.25,1322.98,215645.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588883,'2501','379',110313.73,111120.15,806.42,131446.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588884,'2502','379',123033.27,123033.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588885,'2503','379',68588.53,69048.96,460.43,75050.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588886,'2504','379',89574.64,89574.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182849',3588887,'2505','379',189061.42,189061.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588888,'2506','379',313394.73,314650.58,1255.85,204703.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588889,'2507','379',299937.32,299937.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588890,'2508','379',242221.95,242221.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588891,'2509','379',202405.76,203284.74,878.98,143273.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588892,'2510','379',230333.47,230333.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588893,'2511','379',194236.76,194849.85,613.09,99933.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588894,'2512','379',110823.14,110942.85,119.71,19512.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','182849',3588895,'2513','379',151727.97,152305.52,577.55,94140.65,0.00,0.00,0.00,0.00,0.00),('1','161','863','182849',3588896,'2514','380',100799.03,100799.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182849',3588897,'2515','380',74609.83,74609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589353,'2496','379',117035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589354,'2497','379',171048.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589355,'2498','379',257018.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589356,'2499','379',272715.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589357,'2500','379',244937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589358,'2501','379',111120.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589359,'2502','379',123033.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589360,'2503','379',69048.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589361,'2504','379',89574.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182876',3589362,'2505','379',189061.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589363,'2506','379',314650.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589364,'2507','379',299937.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589365,'2508','379',242221.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589366,'2509','379',203284.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589367,'2510','379',230333.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589368,'2511','379',194849.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589369,'2512','379',110942.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182876',3589370,'2513','379',152305.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182876',3589371,'2514','380',100799.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182876',3589372,'2515','380',74609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589373,'2496','379',117035.41,117035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589374,'2497','379',171048.19,171681.67,633.48,104524.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589375,'2498','379',257018.93,257018.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589376,'2499','379',272715.41,273998.59,1283.18,211724.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589377,'2500','379',244937.25,246063.25,1126.00,185790.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589378,'2501','379',111120.15,112345.10,1224.95,202116.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589379,'2502','379',123033.27,123033.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589380,'2503','379',69048.96,70378.86,1329.90,219433.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589381,'2504','379',89574.64,90734.64,1160.00,191400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182877',3589382,'2505','379',189061.42,189779.29,717.87,118448.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589383,'2506','379',314650.58,317045.11,2394.53,395097.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589384,'2507','379',299937.32,302006.83,2069.51,341469.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589385,'2508','379',242221.95,243363.76,1141.81,188398.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589386,'2509','379',203284.74,205135.38,1850.64,305355.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589387,'2510','379',230333.47,231310.65,977.18,161234.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589388,'2511','379',194849.85,196019.05,1169.20,192918.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589389,'2512','379',110942.85,111534.03,591.18,97544.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','182877',3589390,'2513','379',152305.52,153880.41,1574.89,259856.85,0.00,0.00,0.00,0.00,0.00),('1','161','863','182877',3589391,'2514','380',100799.03,101977.47,1178.44,288717.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','182877',3589392,'2515','380',74609.83,74626.16,16.33,4000.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589399,'2496','379',117035.41,117035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589400,'2497','379',171681.67,174049.19,2367.52,390640.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589401,'2498','379',257018.93,260360.98,3342.05,551438.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589402,'2499','379',273998.59,276713.15,2714.56,447902.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589403,'2500','379',246063.25,248749.47,2686.22,443226.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589404,'2501','379',112345.10,112345.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589405,'2502','379',123033.27,125660.46,2627.19,433486.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589406,'2503','379',70378.86,72967.29,2588.43,427090.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589407,'2504','379',90734.64,94478.96,3744.32,617812.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182879',3589408,'2505','379',189779.29,192963.01,3183.72,525313.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589409,'2506','379',317045.11,319505.88,2460.77,406027.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589410,'2507','379',302006.83,305092.72,3085.89,509171.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589411,'2508','379',243363.76,245564.89,2201.13,363186.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589412,'2509','379',205135.38,207264.60,2129.22,351321.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589413,'2510','379',231310.65,233894.40,2583.75,426318.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589414,'2511','379',196019.05,198595.37,2576.32,425092.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589415,'2512','379',111534.03,111534.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182879',3589416,'2513','379',153880.41,156758.48,2878.07,474881.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','182879',3589417,'2514','380',101977.47,103072.37,1094.90,268250.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','182879',3589418,'2515','380',74626.16,74844.14,217.98,53405.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589533,'2496','379',117035.41,118643.10,1607.69,265268.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589534,'2497','379',174049.19,174049.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589535,'2498','379',260360.98,261955.80,1594.82,263145.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589536,'2499','379',276713.15,278581.90,1868.75,308343.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589537,'2500','379',248749.47,250657.01,1907.54,314744.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589538,'2501','379',112345.10,113784.01,1438.91,237420.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589539,'2502','379',125660.46,126518.54,858.08,141583.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589540,'2503','379',72967.29,72967.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589541,'2504','379',94478.96,94478.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182883',3589542,'2505','379',192963.01,194320.86,1357.85,224045.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589543,'2506','379',319505.88,322870.47,3364.59,555157.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589544,'2507','379',305092.72,308211.86,3119.14,514658.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589545,'2508','379',245564.89,248507.85,2942.96,485588.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589546,'2509','379',207264.60,209637.55,2372.95,391536.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589547,'2510','379',233894.40,236841.48,2947.08,486268.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589548,'2511','379',198595.37,200909.18,2313.81,381778.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589549,'2512','379',111534.03,113827.52,2293.49,378425.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','182883',3589550,'2513','379',156758.48,157473.74,715.26,118017.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','182883',3589551,'2514','380',103072.37,103875.43,803.06,196749.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','182883',3589552,'2515','380',74844.14,74981.51,137.37,33655.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589558,'2496','379',118643.10,118643.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589559,'2497','379',174049.19,175795.24,1746.05,288098.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589560,'2498','379',261955.80,264085.44,2129.64,351390.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589561,'2499','379',278581.90,281221.22,2639.32,435487.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589562,'2500','379',250657.01,253198.54,2541.53,419352.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589563,'2501','379',113784.01,113784.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589564,'2502','379',126518.54,128207.88,1689.34,278741.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589565,'2503','379',72967.29,74956.35,1989.06,328194.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589566,'2504','379',94478.96,96481.01,2002.05,330338.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','182885',3589567,'2505','379',194320.86,196423.95,2103.09,347009.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589568,'2506','379',322870.47,326119.30,3248.83,536056.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589569,'2507','379',308211.86,312351.08,4139.22,682971.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589570,'2508','379',248507.85,251572.90,3065.05,505733.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589571,'2509','379',209637.55,211890.82,2253.27,371789.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589572,'2510','379',236841.48,239929.09,3087.61,509455.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589573,'2511','379',200909.18,203508.57,2599.39,428899.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589574,'2512','379',113827.52,114736.77,909.25,150026.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','182885',3589575,'2513','379',157473.74,160783.77,3310.03,546154.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','182885',3589576,'2514','380',103875.43,104580.67,705.24,172783.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','182885',3589577,'2515','380',74981.51,74989.98,8.47,2075.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590754,'2496','379',118643.10,118643.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590755,'2497','379',175795.24,180348.56,4553.32,751297.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590756,'2498','379',264085.44,267175.34,3089.90,509833.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590757,'2499','379',281221.22,283611.30,2390.08,394363.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590758,'2500','379',253198.54,256334.14,3135.60,517374.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590759,'2501','379',113784.01,113784.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590760,'2502','379',128207.88,131628.24,3420.36,564359.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590761,'2503','379',74956.35,74956.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590762,'2504','379',96481.01,96481.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182945',3590763,'2505','379',196423.95,198770.39,2346.44,387162.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590764,'2506','379',326119.30,326254.54,135.24,22314.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590765,'2507','379',312351.08,312460.63,109.55,18075.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590766,'2508','379',251572.90,251675.66,102.76,16955.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590767,'2509','379',211890.82,211976.60,85.78,14153.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590768,'2510','379',239929.09,239974.47,45.38,7487.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590769,'2511','379',203508.57,203515.24,6.67,1100.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590770,'2512','379',114736.77,114736.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182945',3590771,'2513','379',160783.77,160821.73,37.96,6263.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','182945',3590772,'2514','380',104580.67,104796.38,215.71,52848.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','182945',3590773,'2515','380',74989.98,75052.02,62.04,15199.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590774,'2496','379',118643.10,118643.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590775,'2497','379',180348.56,180348.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590776,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590777,'2499','379',283611.30,283611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590778,'2500','379',256334.14,258042.60,1708.46,281895.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590779,'2501','379',113784.01,116546.74,2762.73,455850.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590780,'2502','379',131628.24,133431.22,1802.98,297491.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590781,'2503','379',74956.35,74968.47,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590782,'2504','379',96481.01,97028.27,547.26,90297.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','182946',3590783,'2505','379',198770.39,201525.49,2755.10,454591.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590784,'2506','379',326254.54,326254.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590785,'2507','379',312460.63,312460.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590786,'2508','379',251675.66,251675.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590787,'2509','379',211976.60,211976.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590788,'2510','379',239974.47,239974.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590789,'2511','379',203515.24,203515.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590790,'2512','379',114736.77,114806.58,69.81,11518.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182946',3590791,'2513','379',160821.73,160821.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182946',3590792,'2514','380',104796.38,104796.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182946',3590793,'2515','380',75052.02,75633.06,581.04,142354.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590800,'2496','379',118643.10,118643.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590801,'2497','379',180348.56,180348.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590802,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590803,'2499','379',283611.30,283611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590804,'2500','379',258042.60,258042.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590805,'2501','379',116546.74,116546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590806,'2502','379',133431.22,133431.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590807,'2503','379',74968.47,74968.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590808,'2504','379',97028.27,97028.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182948',3590809,'2505','379',201525.49,201525.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590810,'2506','379',326254.54,326403.93,149.39,24649.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590811,'2507','379',312460.63,312802.79,342.16,56456.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590812,'2508','379',251675.66,253653.56,1977.90,326353.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590813,'2509','379',211976.60,215010.13,3033.53,500532.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590814,'2510','379',239974.47,242626.80,2652.33,437634.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590815,'2511','379',203515.24,205919.39,2404.15,396684.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590816,'2512','379',114806.58,118356.61,3550.03,585754.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','182948',3590817,'2513','379',160821.73,163143.71,2321.98,383126.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','182948',3590818,'2514','380',104796.38,105193.74,397.36,97353.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','182948',3590819,'2515','380',75633.06,75633.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590843,'2496','379',118643.10,118643.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590844,'2497','379',180348.56,180348.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590845,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590846,'2499','379',283611.30,283611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590847,'2500','379',258042.60,258042.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590848,'2501','379',116546.74,116546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590849,'2502','379',133431.22,133431.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590850,'2503','379',74968.47,74968.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590851,'2504','379',97028.27,97028.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182950',3590852,'2505','379',201525.49,201525.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590853,'2506','379',326403.93,326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590854,'2507','379',312802.79,312941.43,138.64,22875.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590855,'2508','379',253653.56,256652.77,2999.21,494869.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590856,'2509','379',215010.13,217810.49,2800.36,462059.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590857,'2510','379',242626.80,245685.45,3058.65,504677.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590858,'2511','379',205919.39,207487.23,1567.84,258693.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590859,'2512','379',118356.61,121097.80,2741.19,452296.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','182950',3590860,'2513','379',163143.71,166255.82,3112.11,513498.15,0.00,0.00,0.00,0.00,0.00),('1','161','863','182950',3590861,'2514','380',105193.74,105772.32,578.58,141752.10,0.00,0.00,0.00,0.00,0.00),('1','161','863','182950',3590862,'2515','380',75633.06,76106.40,473.34,115968.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590886,'2496','379',118643.10,120390.08,1746.98,288251.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590887,'2497','379',180348.56,181626.63,1278.07,210881.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590888,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590889,'2499','379',283611.30,283611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590890,'2500','379',258042.60,259913.32,1870.72,308668.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590891,'2501','379',116546.74,120159.95,3613.21,596179.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590892,'2502','379',133431.22,133431.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590893,'2503','379',74968.47,76430.77,1462.30,241279.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590894,'2504','379',97028.27,101177.06,4148.79,684550.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','182952',3590895,'2505','379',201525.49,204424.46,2898.97,478330.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590896,'2506','379',326403.93,326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590897,'2507','379',312941.43,312941.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590898,'2508','379',256652.77,256652.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590899,'2509','379',217810.49,219534.25,1723.76,284420.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590900,'2510','379',245685.45,245685.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590901,'2511','379',207487.23,207487.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590902,'2512','379',121097.80,121097.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182952',3590903,'2513','379',166255.82,166255.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182952',3590904,'2514','380',105772.32,106339.26,566.94,138900.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','182952',3590905,'2515','380',76106.40,76374.17,267.77,65603.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590906,'2496','379',120390.08,121395.09,1005.01,165826.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590907,'2497','379',181626.63,184935.92,3309.29,546032.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590908,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590909,'2499','379',283611.30,283611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590910,'2500','379',259913.32,261028.77,1115.45,184049.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590911,'2501','379',120159.95,121122.04,962.09,158744.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590912,'2502','379',133431.22,136013.47,2582.25,426071.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590913,'2503','379',76430.77,76912.65,481.88,79510.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590914,'2504','379',101177.06,104401.29,3224.23,531997.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','182953',3590915,'2505','379',204424.46,206283.23,1858.77,306697.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590916,'2506','379',326403.93,326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590917,'2507','379',312941.43,312941.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590918,'2508','379',256652.77,256652.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590919,'2509','379',219534.25,219534.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590920,'2510','379',245685.45,245685.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590921,'2511','379',207487.23,207487.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590922,'2512','379',121097.80,121097.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','182953',3590923,'2513','379',166255.82,166255.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','182953',3590924,'2514','380',106339.26,107078.21,738.95,181042.75,0.00,0.00,0.00,0.00,0.00),('1','161','863','182953',3590925,'2515','380',76374.17,76896.61,522.44,127997.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605754,'2496','379',121395.09,121784.28,389.19,64216.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605755,'2497','379',184935.92,185050.58,114.66,18918.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605756,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605757,'2499','379',283611.30,283775.59,164.29,27107.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605758,'2500','379',261028.77,261802.85,774.08,127723.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605759,'2501','379',121122.04,123817.20,2695.16,444701.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605760,'2502','379',136013.47,137031.53,1018.06,167979.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605761,'2503','379',76912.65,77921.36,1008.71,166437.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605762,'2504','379',104401.29,104401.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183779',3605763,'2505','379',206283.23,208618.57,2335.34,385331.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605764,'2506','379',326403.93,326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605765,'2507','379',312941.43,312941.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605766,'2508','379',256652.77,256652.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605767,'2509','379',219534.25,219534.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605768,'2510','379',245685.45,245685.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605769,'2511','379',207487.23,207487.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605770,'2512','379',121097.80,121097.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183779',3605771,'2513','379',166255.82,166255.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183779',3605772,'2514','380',107078.21,107131.28,53.07,13002.15,0.00,0.00,0.00,0.00,0.00),('1','161','863','183779',3605773,'2515','380',76896.61,77155.06,258.45,63320.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605938,'2496','379',121784.28,121784.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605939,'2497','379',185050.58,185050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605940,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605941,'2499','379',283775.59,283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605942,'2500','379',261802.85,261802.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605943,'2501','379',123817.20,123817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605944,'2502','379',137031.53,137031.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605945,'2503','379',77921.36,77921.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605946,'2504','379',104401.29,104661.60,260.31,42951.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','183789',3605947,'2505','379',208618.57,208618.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605948,'2506','379',326403.93,326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605949,'2507','379',312941.43,312941.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605950,'2508','379',256652.77,256652.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605951,'2509','379',219534.25,219534.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605952,'2510','379',245685.45,245685.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605953,'2511','379',207487.23,207487.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605954,'2512','379',121097.80,121097.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183789',3605955,'2513','379',166255.82,166255.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183789',3605956,'2514','380',107131.28,107398.62,267.34,65498.30,0.00,0.00,0.00,0.00,0.00),('1','161','863','183789',3605957,'2515','380',77155.06,77705.44,550.38,134843.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605960,'2496','379',121784.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605961,'2497','379',185050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605962,'2498','379',267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605963,'2499','379',283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605964,'2500','379',261802.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605965,'2501','379',123817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605966,'2502','379',137031.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605967,'2503','379',77921.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605968,'2504','379',104661.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183791',3605969,'2505','379',208618.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605970,'2506','379',326403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605971,'2507','379',312941.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605972,'2508','379',256652.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605973,'2509','379',219534.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605974,'2510','379',245685.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605975,'2511','379',207487.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605976,'2512','379',121097.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183791',3605977,'2513','379',166255.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183791',3605978,'2514','380',107398.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183791',3605979,'2515','380',77705.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606021,'2496','379',121784.28,121784.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606022,'2497','379',185050.58,185050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606023,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606024,'2499','379',283775.59,283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606025,'2500','379',261802.85,261802.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606026,'2501','379',123817.20,123817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606027,'2502','379',137031.53,137031.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606028,'2503','379',77921.36,79754.20,1832.84,302418.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606029,'2504','379',104661.60,106161.60,1500.00,247500.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183793',3606030,'2505','379',208618.57,208618.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606031,'2506','379',326403.93,328208.54,1804.61,297760.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606032,'2507','379',312941.43,314253.36,1311.93,216468.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606033,'2508','379',256652.77,257438.01,785.24,129564.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606034,'2509','379',219534.25,220436.37,902.12,148849.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606035,'2510','379',245685.45,246400.58,715.13,117996.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606036,'2511','379',207487.23,208405.70,918.47,151547.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606037,'2512','379',121097.80,122098.92,1001.12,165184.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','183793',3606038,'2513','379',166255.82,166656.10,400.28,66046.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','183793',3606039,'2514','380',107398.62,107899.74,501.12,125280.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183793',3606040,'2515','380',77705.44,77745.44,40.00,10000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606926,'2496','379',121784.28,123769.06,1984.78,327488.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606927,'2497','379',185050.58,187508.97,2458.39,405634.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606928,'2498','379',267175.34,267175.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606929,'2499','379',283775.59,283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606930,'2500','379',261802.85,264127.99,2325.14,383648.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606931,'2501','379',123817.20,125011.16,1193.96,197003.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606932,'2502','379',137031.53,139265.79,2234.26,368652.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606933,'2503','379',79754.20,81412.58,1658.38,273632.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606934,'2504','379',106161.60,107871.62,1710.02,282153.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','183837',3606935,'2505','379',208618.57,210404.82,1786.25,294731.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606936,'2506','379',328208.54,328208.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606937,'2507','379',314253.36,314253.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606938,'2508','379',257438.01,257438.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606939,'2509','379',220436.37,220436.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606940,'2510','379',246400.58,246400.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606941,'2511','379',208405.70,208405.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606942,'2512','379',122098.92,122098.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183837',3606943,'2513','379',166656.10,166656.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183837',3606944,'2514','380',107899.74,108213.74,314.00,78500.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183837',3606945,'2515','380',77745.44,77805.44,60.00,15000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607047,'2496','379',123769.06,125299.17,1530.11,252468.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607048,'2497','379',187508.97,189317.33,1808.36,298379.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607049,'2498','379',267175.34,267480.89,305.55,50415.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607050,'2499','379',283775.59,283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607051,'2500','379',264127.99,266403.11,2275.12,375394.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607052,'2501','379',125011.16,126241.23,1230.07,202961.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607053,'2502','379',139265.79,140803.72,1537.93,253758.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607054,'2503','379',81412.58,82329.04,916.46,151215.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607055,'2504','379',107871.62,109284.51,1412.89,233126.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','183842',3607056,'2505','379',210404.82,210404.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607057,'2506','379',328208.54,329009.15,800.61,132100.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607058,'2507','379',314253.36,315380.33,1126.97,185950.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607059,'2508','379',257438.01,258162.80,724.79,119590.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607060,'2509','379',220436.37,221186.22,749.85,123725.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607061,'2510','379',246400.58,246966.54,565.96,93383.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607062,'2511','379',208405.70,208840.51,434.81,71743.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607063,'2512','379',122098.92,122672.16,573.24,94584.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','183842',3607064,'2513','379',166656.10,167054.38,398.28,65716.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','183842',3607065,'2514','380',108213.74,109800.76,1587.02,396755.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183842',3607066,'2515','380',77805.44,78378.44,573.00,143250.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607090,'2496','379',125299.17,126280.36,981.19,161896.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607091,'2497','379',189317.33,190660.70,1343.37,221656.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607092,'2498','379',267480.89,270208.90,2698.01,445171.65,0.00,0.00,30.00,0.00,0.00),('1','161','861','183844',3607093,'2499','379',283775.59,283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607094,'2500','379',266403.11,269930.76,3527.65,582062.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607095,'2501','379',126241.23,127076.58,835.35,137832.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607096,'2502','379',140803.72,142591.87,1788.15,295044.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607097,'2503','379',82329.04,82329.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607098,'2504','379',109284.51,110333.12,1048.61,173020.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','183844',3607099,'2505','379',210404.82,210404.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607100,'2506','379',329009.15,330562.53,1553.38,256307.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607101,'2507','379',315380.33,316415.28,1034.95,170766.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607102,'2508','379',258162.80,259287.95,1125.15,185649.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607103,'2509','379',221186.22,222206.41,1020.19,168331.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607104,'2510','379',246966.54,248038.88,1072.34,176936.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607105,'2511','379',208840.51,209699.48,858.97,141730.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607106,'2512','379',122672.16,123868.20,1196.04,197346.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','183844',3607107,'2513','379',167054.38,167054.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183844',3607108,'2514','380',109800.76,109953.42,152.66,38165.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','183844',3607109,'2515','380',78378.44,78438.44,60.00,15000.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615808,'2496','379',126280.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615809,'2497','379',190660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615810,'2498','379',270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615811,'2499','379',283775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615812,'2500','379',269930.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615813,'2501','379',127076.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615814,'2502','379',142591.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615815,'2503','379',82329.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615816,'2504','379',110333.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184343',3615817,'2505','379',210404.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615818,'2506','379',330562.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615819,'2507','379',316415.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615820,'2508','379',259287.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615821,'2509','379',222206.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615822,'2510','379',248038.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615823,'2511','379',209699.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615824,'2512','379',123868.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184343',3615825,'2513','379',167054.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184343',3615826,'2514','380',109953.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184343',3615827,'2515','380',78438.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615857,'2496','379',126280.36,126280.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615858,'2497','379',190660.70,192116.23,1455.53,240162.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615859,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615860,'2499','379',283775.59,285626.76,1851.17,305443.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615861,'2500','379',269930.76,269930.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615862,'2501','379',127076.58,127076.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615863,'2502','379',142591.87,143673.14,1081.27,178409.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615864,'2503','379',82329.04,83849.49,1520.45,250874.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615865,'2504','379',110333.12,110333.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184346',3615866,'2505','379',210404.82,212263.83,1859.01,306736.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615867,'2506','379',330562.53,333346.91,2784.38,459422.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615868,'2507','379',316415.28,317811.53,1396.25,230381.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615869,'2508','379',259287.95,260217.36,929.41,153352.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615870,'2509','379',222206.41,224920.34,2713.93,447798.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615871,'2510','379',248038.88,251337.72,3298.84,544308.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615872,'2511','379',209699.48,210730.19,1030.71,170067.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615873,'2512','379',123868.20,125006.47,1138.27,187814.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','184346',3615874,'2513','379',167054.38,168103.25,1048.87,173063.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','184346',3615875,'2514','380',109953.42,110827.42,874.00,227240.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184346',3615876,'2515','380',78438.44,78570.00,131.56,34205.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615877,'2496','379',126280.36,129250.34,2969.98,490046.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615878,'2497','379',192116.23,194314.31,2198.08,362683.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615879,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615880,'2499','379',285626.76,285626.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615881,'2500','379',269930.76,272209.40,2258.64,372675.60,0.00,0.00,20.00,0.00,0.00),('1','161','861','184347',3615882,'2501','379',127076.58,131842.08,4765.50,786307.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615883,'2502','379',143673.14,143816.52,143.38,23657.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615884,'2503','379',83849.49,83849.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615885,'2504','379',110333.12,114832.59,4499.47,742412.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','184347',3615886,'2505','379',212263.83,214959.77,2695.94,444830.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615887,'2506','379',333346.91,333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615888,'2507','379',317811.53,317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615889,'2508','379',260217.36,260217.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615890,'2509','379',224920.34,224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615891,'2510','379',251337.72,251337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615892,'2511','379',210730.19,210730.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615893,'2512','379',125006.47,125006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184347',3615894,'2513','379',168103.25,168103.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184347',3615895,'2514','380',110827.42,111413.89,586.47,152482.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','184347',3615896,'2515','380',78570.00,79036.54,466.54,121300.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615931,'2496','379',129250.34,129250.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615932,'2497','379',194314.31,194314.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615933,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615934,'2499','379',285626.76,285626.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615935,'2500','379',272209.40,272209.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615936,'2501','379',131842.08,131842.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615937,'2502','379',143816.52,143816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615938,'2503','379',83849.49,83849.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615939,'2504','379',114832.59,114832.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184350',3615940,'2505','379',214959.77,214959.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615941,'2506','379',333346.91,333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615942,'2507','379',317811.53,317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615943,'2508','379',260217.36,260217.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615944,'2509','379',224920.34,224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615945,'2510','379',251337.72,251337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615946,'2511','379',210730.19,210730.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615947,'2512','379',125006.47,125006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184350',3615948,'2513','379',168103.25,168103.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184350',3615949,'2514','380',111413.89,111413.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184350',3615950,'2515','380',79036.54,79535.10,498.56,129625.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615973,'2496','379',129250.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615974,'2497','379',194314.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615975,'2498','379',270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615976,'2499','379',285626.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615977,'2500','379',272209.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615978,'2501','379',131842.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615979,'2502','379',143816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615980,'2503','379',83849.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615981,'2504','379',114832.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184352',3615982,'2505','379',214959.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615983,'2506','379',333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615984,'2507','379',317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615985,'2508','379',260217.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615986,'2509','379',224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615987,'2510','379',251337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615988,'2511','379',210730.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615989,'2512','379',125006.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184352',3615990,'2513','379',168103.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184352',3615991,'2514','380',111413.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','184352',3615992,'2515','380',79535.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616025,'2496','379',129250.34,132624.17,3373.83,560055.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616026,'2497','379',194314.31,196205.21,1890.90,313889.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616027,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616028,'2499','379',285626.76,286042.07,415.31,68941.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616029,'2500','379',272209.40,273058.53,849.13,140955.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616030,'2501','379',131842.08,134505.91,2663.83,442195.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616031,'2502','379',143816.52,144733.01,916.49,152137.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616032,'2503','379',83849.49,85019.78,1170.29,194268.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616033,'2504','379',114832.59,116587.88,1755.29,291378.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','184356',3616034,'2505','379',214959.77,217472.24,2512.47,417070.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616035,'2506','379',333346.91,333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616036,'2507','379',317811.53,317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616037,'2508','379',260217.36,260217.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616038,'2509','379',224920.34,224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616039,'2510','379',251337.72,251337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616040,'2511','379',210730.19,210730.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616041,'2512','379',125006.47,126786.04,1779.57,295408.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','184356',3616042,'2513','379',168103.25,169158.97,1055.72,175249.52,0.00,0.00,0.00,0.00,0.00),('1','161','863','184356',3616043,'2514','380',111413.89,112691.22,1277.33,332105.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','184356',3616044,'2515','380',79535.10,80387.53,852.43,221631.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631654,'2496','379',132624.17,134448.56,1824.39,302848.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631655,'2497','379',196205.21,198483.50,2278.29,378196.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631656,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631657,'2499','379',286042.07,286042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631658,'2500','379',273058.53,274506.52,1447.99,240366.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631659,'2501','379',134505.91,135607.19,1101.28,182812.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631660,'2502','379',144733.01,146494.15,1761.14,292349.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631661,'2503','379',85019.78,85019.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631662,'2504','379',116587.88,116587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185239',3631663,'2505','379',217472.24,219533.66,2061.42,342195.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631664,'2506','379',333346.91,333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631665,'2507','379',317811.53,317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631666,'2508','379',260217.36,260217.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631667,'2509','379',224920.34,224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631668,'2510','379',251337.72,251337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631669,'2511','379',210730.19,210730.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631670,'2512','379',126786.04,128940.88,2154.84,357703.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','185239',3631671,'2513','379',169158.97,170504.92,1345.95,223427.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','185239',3631672,'2514','380',112691.22,112691.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','185239',3631673,'2515','380',80387.53,80464.83,77.30,20098.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636944,'2496','379',134448.56,134448.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636945,'2497','379',198483.50,200470.07,1986.57,329770.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636946,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636947,'2499','379',286042.07,286042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636948,'2500','379',274506.52,274506.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636949,'2501','379',135607.19,135607.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636950,'2502','379',146494.15,147760.09,1265.94,210146.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636951,'2503','379',85019.78,85024.00,4.22,700.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636952,'2504','379',116587.88,116587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185533',3636953,'2505','379',219533.66,220931.46,1397.80,232034.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636954,'2506','379',333346.91,333346.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636955,'2507','379',317811.53,317811.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636956,'2508','379',260217.36,260602.69,385.33,63964.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636957,'2509','379',224920.34,224920.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636958,'2510','379',251337.72,251940.40,602.68,100044.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636959,'2511','379',210730.19,211554.56,824.37,136845.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636960,'2512','379',128940.88,130788.18,1847.30,306651.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','185533',3636961,'2513','379',170504.92,172127.45,1622.53,269339.98,0.00,0.00,0.00,0.00,0.00),('1','161','863','185533',3636962,'2514','380',112691.22,113143.34,452.12,117551.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','185533',3636963,'2515','380',80464.83,80464.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637376,'2496','379',134448.56,134448.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637377,'2497','379',200470.07,200470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637378,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637379,'2499','379',286042.07,286042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637380,'2500','379',274506.52,274506.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637381,'2501','379',135607.19,135607.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637382,'2502','379',147760.09,147760.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637383,'2503','379',85024.00,85024.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637384,'2504','379',116587.88,116587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','185557',3637385,'2505','379',220931.46,220931.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637386,'2506','379',333346.91,335699.16,2352.25,390473.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637387,'2507','379',317811.53,319284.74,1473.21,244552.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637388,'2508','379',260602.69,262082.65,1479.96,245673.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637389,'2509','379',224920.34,227117.49,2197.15,364726.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637390,'2510','379',251940.40,253957.16,2016.76,334782.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637391,'2511','379',211554.56,212839.79,1285.23,213348.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637392,'2512','379',130788.18,133936.92,3148.74,522690.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','185557',3637393,'2513','379',172127.45,174800.74,2673.29,443766.14,0.00,0.00,0.00,0.00,0.00),('1','161','863','185557',3637394,'2514','380',113143.34,113641.02,497.68,129396.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','185557',3637395,'2515','380',80464.83,80464.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646429,'2496','379',134448.56,134448.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646430,'2497','379',200470.07,200470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646431,'2498','379',270208.90,270208.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646432,'2499','379',286042.07,286042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646433,'2500','379',274506.52,274506.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646434,'2501','379',135607.19,135607.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646435,'2502','379',147760.09,147760.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646436,'2503','379',85024.00,85024.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646437,'2504','379',116587.88,116587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186056',3646438,'2505','379',220931.46,220931.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646439,'2506','379',335699.16,335699.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646440,'2507','379',319284.74,319597.84,313.10,51974.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646441,'2508','379',262082.65,262082.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646442,'2509','379',227117.49,227380.75,263.26,43701.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646443,'2510','379',253957.16,254230.06,272.90,45301.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646444,'2511','379',212839.79,212839.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646445,'2512','379',133936.92,133936.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186056',3646446,'2513','379',174800.74,175228.04,427.30,70931.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','186056',3646447,'2514','380',113641.02,115020.39,1379.37,358636.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','186056',3646448,'2515','380',80464.83,80464.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648684,'2496','379',134448.56,135056.32,607.76,100888.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648685,'2497','379',200470.07,200986.74,516.67,85767.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648686,'2498','379',270208.90,271125.62,916.72,152175.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648687,'2499','379',286042.07,287771.75,1729.68,287126.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648688,'2500','379',274506.52,275688.35,1181.83,196183.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648689,'2501','379',135607.19,136849.56,1242.37,206233.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648690,'2502','379',147760.09,147760.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648691,'2503','379',85024.00,85024.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648692,'2504','379',116587.88,117567.96,980.08,162693.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','186199',3648693,'2505','379',220931.46,222199.06,1267.60,210421.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648694,'2506','379',335699.16,337017.97,1318.81,218922.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648695,'2507','379',319597.84,320938.94,1341.10,222622.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648696,'2508','379',262082.65,263261.47,1178.82,195684.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648697,'2509','379',227380.75,228383.55,1002.80,166464.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648698,'2510','379',254230.06,255556.84,1326.78,220245.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648699,'2511','379',212839.79,213754.40,914.61,151825.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648700,'2512','379',133936.92,134711.65,774.73,128605.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','186199',3648701,'2513','379',175228.04,175228.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186199',3648702,'2514','380',115020.39,115080.39,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186199',3648703,'2515','380',80464.83,80716.39,251.56,65405.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648744,'2496','379',135056.32,135056.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648745,'2497','379',200986.74,202403.53,1416.79,235187.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648746,'2498','379',271125.62,272571.48,1445.86,240012.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648747,'2499','379',287771.75,288768.89,977.14,162205.24,0.00,0.00,20.00,0.00,0.00),('1','161','861','186202',3648748,'2500','379',275688.35,277290.94,1602.59,266029.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648749,'2501','379',136849.56,137109.56,260.00,43160.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648750,'2502','379',147760.09,149092.14,1332.05,221120.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648751,'2503','379',85024.00,85024.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648752,'2504','379',117567.96,117587.34,19.38,3217.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','186202',3648753,'2505','379',222199.06,223678.48,1479.42,245583.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648754,'2506','379',337017.97,339356.67,2338.70,388224.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648755,'2507','379',320938.94,322556.36,1617.42,268491.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648756,'2508','379',263261.47,264675.30,1413.83,234695.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648757,'2509','379',228383.55,229266.48,882.93,146566.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648758,'2510','379',255556.84,256460.71,903.87,150042.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648759,'2511','379',213754.40,214731.66,977.26,162225.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648760,'2512','379',134711.65,134711.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186202',3648761,'2513','379',175228.04,176516.20,1288.16,213834.56,0.00,0.00,0.00,0.00,0.00),('1','161','863','186202',3648762,'2514','380',115080.39,115896.78,816.39,212261.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','186202',3648763,'2515','380',80716.39,82641.37,1924.98,500494.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186210',3648873,'2496','379',135056.32,135368.82,302.50,50215.00,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648874,'2497','379',202403.53,204233.33,1809.80,300426.80,0.00,0.00,20.00,0.00,0.00),('1','161','861','186210',3648875,'2498','379',272571.48,274822.73,2241.25,372047.50,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648876,'2499','379',288768.89,290252.67,1473.78,244647.48,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648877,'2500','379',277290.94,278867.12,1556.18,258325.88,0.00,0.00,20.00,0.00,0.00),('1','161','861','186210',3648878,'2501','379',137109.56,137723.90,604.34,100320.44,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648879,'2502','379',149092.14,150356.59,1254.45,208238.70,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648880,'2503','379',85024.00,86062.65,1018.65,169095.90,0.00,0.00,20.00,0.00,0.00),('1','161','861','186210',3648881,'2504','379',117587.34,117856.50,259.16,43020.56,0.00,0.00,10.00,0.00,0.00),('1','161','861','186210',3648882,'2505','379',223678.48,224876.40,1187.92,197194.72,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648883,'2506','379',339356.67,340656.17,1289.50,214057.00,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648884,'2507','379',322556.36,323610.25,1043.89,173285.74,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648885,'2508','379',264675.30,265389.58,704.28,116910.48,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648886,'2509','379',229266.48,230187.89,901.41,149634.06,0.00,0.00,20.00,0.00,0.00),('1','161','862','186210',3648887,'2510','379',256460.71,257290.93,820.22,136156.52,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648888,'2511','379',214731.66,215325.23,583.57,96872.62,0.00,0.00,10.00,0.00,0.00),('1','161','862','186210',3648889,'2512','379',134711.65,134711.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186210',3648890,'2513','379',176516.20,177413.35,877.15,145606.90,0.00,0.00,20.00,0.00,0.00),('1','161','863','186210',3648891,'2514','380',115896.78,115956.78,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186210',3648892,'2515','380',82641.37,82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649004,'2496','379',135368.82,137031.34,1662.52,275978.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649005,'2497','379',204233.33,204233.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649006,'2498','379',274822.73,276466.84,1644.11,272922.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649007,'2499','379',290252.67,291497.24,1244.57,206598.62,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649008,'2500','379',278867.12,280324.48,1457.36,241921.76,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649009,'2501','379',137723.90,138944.35,1220.45,202594.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649010,'2502','379',150356.59,150356.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649011,'2503','379',86062.65,86062.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649012,'2504','379',117856.50,117856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186216',3649013,'2505','379',224876.40,226213.19,1336.79,221907.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649014,'2506','379',340656.17,343136.11,2479.94,411670.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649015,'2507','379',323610.25,326161.43,2551.18,423495.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649016,'2508','379',265389.58,267797.91,2408.33,399782.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649017,'2509','379',230187.89,231988.36,1800.47,298878.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649018,'2510','379',257290.93,257730.55,439.62,72976.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649019,'2511','379',215325.23,217255.14,1929.91,320365.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649020,'2512','379',134711.65,137005.99,2294.34,380860.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','186216',3649021,'2513','379',177413.35,177625.16,211.81,35160.46,0.00,0.00,0.00,0.00,0.00),('1','161','863','186216',3649022,'2514','380',115956.78,115956.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186216',3649023,'2515','380',82641.37,82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649080,'2496','379',137031.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649081,'2497','379',204233.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649082,'2498','379',276466.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649083,'2499','379',291497.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649084,'2500','379',280324.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649085,'2501','379',138944.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649086,'2502','379',150356.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649087,'2503','379',86062.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649088,'2504','379',117856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186219',3649089,'2505','379',226213.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649090,'2506','379',343136.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649091,'2507','379',326161.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649092,'2508','379',267797.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649093,'2509','379',231988.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649094,'2510','379',257730.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649095,'2511','379',217255.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649096,'2512','379',137005.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186219',3649097,'2513','379',177625.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186219',3649098,'2514','380',115956.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186219',3649099,'2515','380',82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649130,'2496','379',137031.34,137332.65,301.31,49716.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649131,'2497','379',204233.33,205625.28,1391.95,229671.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649132,'2498','379',276466.84,278405.65,1938.81,319903.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649133,'2499','379',291497.24,293124.19,1626.95,268446.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649134,'2500','379',280324.48,282562.92,2238.44,369342.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649135,'2501','379',138944.35,139525.82,581.47,95942.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649136,'2502','379',150356.59,151780.86,1424.27,235004.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649137,'2503','379',86062.65,86837.89,775.24,127914.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649138,'2504','379',117856.50,119230.41,1373.91,226695.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','186221',3649139,'2505','379',226213.19,227826.55,1613.36,266204.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649140,'2506','379',343136.11,345035.83,1899.72,313453.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649141,'2507','379',326161.43,327915.58,1754.15,289434.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649142,'2508','379',267797.91,268853.85,1055.94,174230.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649143,'2509','379',231988.36,233317.78,1329.42,219354.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649144,'2510','379',257730.55,259336.96,1606.41,265057.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649145,'2511','379',217255.14,218608.12,1352.98,223241.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649146,'2512','379',137005.99,138012.40,1006.41,166057.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','186221',3649147,'2513','379',177625.16,178021.84,396.68,65452.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','186221',3649148,'2514','380',115956.78,116016.79,60.01,15602.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','186221',3649149,'2515','380',82641.37,82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649533,'2496','379',137332.65,137332.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649534,'2497','379',205625.28,206979.71,1354.43,223480.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649535,'2498','379',278405.65,279652.50,1246.85,205730.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649536,'2499','379',293124.19,295215.80,2091.61,345115.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649537,'2500','379',282562.92,283883.36,1320.44,217872.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649538,'2501','379',139525.82,139525.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649539,'2502','379',151780.86,153110.21,1329.35,219342.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649540,'2503','379',86837.89,87505.93,668.04,110226.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649541,'2504','379',119230.41,119315.98,85.57,14119.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','186244',3649542,'2505','379',227826.55,228670.89,844.34,139316.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649543,'2506','379',345035.83,347069.60,2033.77,335572.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649544,'2507','379',327915.58,330093.34,2177.76,359330.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649545,'2508','379',268853.85,270466.75,1612.90,266128.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649546,'2509','379',233317.78,234737.23,1419.45,234209.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649547,'2510','379',259336.96,260874.52,1537.56,253697.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649548,'2511','379',218608.12,219397.28,789.16,130211.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649549,'2512','379',138012.40,138012.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186244',3649550,'2513','379',178021.84,179321.73,1299.89,214481.85,0.00,0.00,0.00,0.00,0.00),('1','161','863','186244',3649551,'2514','380',116016.79,116016.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186244',3649552,'2515','380',82641.37,82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650442,'2496','379',137332.65,138208.22,855.57,141169.05,0.00,0.00,20.00,0.00,0.00),('1','161','861','186296',3650443,'2497','379',206979.71,206979.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650444,'2498','379',279652.50,281243.85,1591.35,262572.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650445,'2499','379',295215.80,297223.40,2007.60,331254.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650446,'2500','379',283883.36,284639.96,756.60,124839.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650447,'2501','379',139525.82,139525.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650448,'2502','379',153110.21,153829.39,719.18,118664.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650449,'2503','379',87505.93,88031.45,525.52,86710.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650450,'2504','379',119315.98,119315.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186296',3650451,'2505','379',228670.89,229796.88,1125.99,185788.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650452,'2506','379',347069.60,348362.57,1292.97,213340.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650453,'2507','379',330093.34,331164.60,1071.26,176757.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650454,'2508','379',270466.75,272302.76,1836.01,302941.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650455,'2509','379',234737.23,235032.23,295.00,48675.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650456,'2510','379',260874.52,261854.07,979.55,161625.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650457,'2511','379',219397.28,220367.42,970.14,160073.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650458,'2512','379',138012.40,138534.49,522.09,86144.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','186296',3650459,'2513','379',179321.73,179852.58,530.85,87590.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','186296',3650460,'2514','380',116016.79,116016.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186296',3650461,'2515','380',82641.37,82641.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652992,'2496','379',138208.22,138208.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652993,'2497','379',206979.71,208020.72,1041.01,171766.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652994,'2498','379',281243.85,282983.68,1739.83,287071.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652995,'2499','379',297223.40,299398.64,2175.24,358914.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652996,'2500','379',284639.96,285837.28,1197.32,197557.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652997,'2501','379',139525.82,140833.66,1307.84,215793.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652998,'2502','379',153829.39,153872.09,42.70,7045.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3652999,'2503','379',88031.45,88031.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3653000,'2504','379',119315.98,119645.41,329.43,54355.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','186455',3653001,'2505','379',229796.88,230918.24,1121.36,185024.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653002,'2506','379',348362.57,350242.04,1829.47,301862.55,0.00,0.00,50.00,0.00,0.00),('1','161','862','186455',3653003,'2507','379',331164.60,333049.44,1884.84,310998.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653004,'2508','379',272302.76,273734.86,1432.10,236296.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653005,'2509','379',235032.23,235830.78,798.55,131760.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653006,'2510','379',261854.07,263067.80,1213.73,200265.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653007,'2511','379',220367.42,221327.44,960.02,158403.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653008,'2512','379',138534.49,138534.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186455',3653009,'2513','379',179852.58,180621.89,769.31,126936.15,0.00,0.00,0.00,0.00,0.00),('1','161','863','186455',3653010,'2514','380',116016.79,116024.79,8.00,2080.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186455',3653011,'2515','380',82641.37,82644.45,3.08,800.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653140,'2496','379',138208.22,139461.30,1253.08,206758.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653141,'2497','379',208020.72,208049.20,28.48,4699.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653142,'2498','379',282983.68,284249.58,1265.90,208873.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653143,'2499','379',299398.64,300514.78,1116.14,184163.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653144,'2500','379',285837.28,287308.32,1471.04,242721.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653145,'2501','379',140833.66,141733.09,899.43,148405.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653146,'2502','379',153872.09,153938.95,66.86,11031.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653147,'2503','379',88031.45,88252.04,220.59,36397.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653148,'2504','379',119645.41,119645.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186461',3653149,'2505','379',230918.24,231631.03,712.79,117610.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653150,'2506','379',350242.04,351712.56,1470.52,242635.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653151,'2507','379',333049.44,334317.86,1268.42,209289.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653152,'2508','379',273734.86,274632.88,898.02,148173.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653153,'2509','379',235830.78,236937.45,1106.67,182600.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653154,'2510','379',263067.80,263872.35,804.55,132750.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653155,'2511','379',221327.44,222455.50,1128.06,186129.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653156,'2512','379',138534.49,138534.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186461',3653157,'2513','379',180621.89,181158.33,536.44,88512.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','186461',3653158,'2514','380',116024.79,116024.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186461',3653159,'2515','380',82644.45,82644.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653309,'2496','379',139461.30,139503.71,42.41,6997.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653310,'2497','379',208049.20,208150.46,101.26,16707.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653311,'2498','379',284249.58,284405.26,155.68,25687.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653312,'2499','379',300514.78,300645.30,130.52,21535.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653313,'2500','379',287308.32,287512.12,203.80,33627.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653314,'2501','379',141733.09,141733.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653315,'2502','379',153938.95,154371.97,433.02,71448.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653316,'2503','379',88252.04,88252.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653317,'2504','379',119645.41,119645.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186468',3653318,'2505','379',231631.03,231681.27,50.24,8289.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653319,'2506','379',351712.56,352625.65,893.09,147359.85,0.00,0.00,20.00,0.00,0.00),('1','161','862','186468',3653320,'2507','379',334317.86,335079.66,761.80,125697.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653321,'2508','379',274632.88,275068.45,435.57,71869.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653322,'2509','379',236937.45,237329.25,391.80,64647.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653323,'2510','379',263872.35,264269.56,397.21,65539.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653324,'2511','379',222455.50,222794.59,339.09,55949.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653325,'2512','379',138534.49,139067.72,533.23,87982.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','186468',3653326,'2513','379',181158.33,181158.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186468',3653327,'2514','380',116024.79,116364.79,340.00,88400.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186468',3653328,'2515','380',82644.45,83157.84,513.39,133481.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657593,'2496','379',139503.71,139503.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657594,'2497','379',208150.46,209640.25,1489.79,245815.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657595,'2498','379',284405.26,285252.85,847.59,139852.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657596,'2499','379',300645.30,302527.35,1882.05,310538.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657597,'2500','379',287512.12,288706.03,1193.91,196995.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657598,'2501','379',141733.09,142530.60,797.51,131589.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657599,'2502','379',154371.97,154371.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657600,'2503','379',88252.04,88252.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657601,'2504','379',119645.41,119645.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186716',3657602,'2505','379',231681.27,233374.70,1693.43,279415.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657603,'2506','379',352625.65,353793.58,1167.93,192708.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657604,'2507','379',335079.66,336382.78,1303.12,215014.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657605,'2508','379',275068.45,275068.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657606,'2509','379',237329.25,238334.91,1005.66,165933.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657607,'2510','379',264269.56,265000.12,730.56,120542.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657608,'2511','379',222794.59,223903.35,1108.76,182945.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657609,'2512','379',139067.72,139067.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186716',3657610,'2513','379',181158.33,181770.51,612.18,101009.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','186716',3657611,'2514','380',116364.79,116428.64,63.85,16601.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186716',3657612,'2515','380',83157.84,83157.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659002,'2496','379',139503.71,141803.87,2300.16,379526.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659003,'2497','379',209640.25,209640.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659004,'2498','379',285252.85,286826.45,1573.60,259644.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659005,'2499','379',302527.35,304525.74,1998.39,329734.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659006,'2500','379',288706.03,289859.43,1153.40,190311.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659007,'2501','379',142530.60,142530.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659008,'2502','379',154371.97,155682.66,1310.69,216263.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659009,'2503','379',88252.04,88252.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659010,'2504','379',119645.41,119645.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186805',3659011,'2505','379',233374.70,235168.31,1793.61,295945.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659012,'2506','379',353793.58,355411.08,1617.50,266887.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659013,'2507','379',336382.78,338229.76,1846.98,304751.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659014,'2508','379',275068.45,276398.82,1330.37,219511.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659015,'2509','379',238334.91,239329.71,994.80,164142.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659016,'2510','379',265000.12,266346.41,1346.29,222137.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659017,'2511','379',223903.35,224875.70,972.35,160437.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659018,'2512','379',139067.72,140083.48,1015.76,167600.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186805',3659019,'2513','379',181770.51,181770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186805',3659020,'2514','380',116428.64,116486.33,57.69,14999.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','186805',3659021,'2515','380',83157.84,84553.07,1395.23,362759.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186808',3659047,'2496','379',141803.87,141823.87,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659048,'2497','379',209640.25,210544.98,874.73,144330.45,0.00,0.00,30.00,0.00,0.00),('1','161','861','186808',3659049,'2498','379',286826.45,288024.20,1177.75,194328.75,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659050,'2499','379',304525.74,305788.90,1253.16,206771.40,0.00,0.00,10.00,0.00,0.00),('1','161','861','186808',3659051,'2500','379',289859.43,290768.35,888.92,146671.80,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659052,'2501','379',142530.60,143000.53,449.93,74238.45,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659053,'2502','379',155682.66,155986.42,293.76,48470.40,0.00,0.00,10.00,0.00,0.00),('1','161','861','186808',3659054,'2503','379',88252.04,88708.42,436.38,72002.70,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659055,'2504','379',119645.41,120100.25,434.84,71748.60,0.00,0.00,20.00,0.00,0.00),('1','161','861','186808',3659056,'2505','379',235168.31,236304.93,1116.62,184242.30,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659057,'2506','379',355411.08,356863.16,1432.08,236293.20,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659058,'2507','379',338229.76,339900.33,1650.57,272344.05,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659059,'2508','379',276398.82,277770.03,1351.21,222949.65,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659060,'2509','379',239329.71,240838.72,1489.01,245686.65,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659061,'2510','379',266346.41,267676.08,1309.67,216095.55,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659062,'2511','379',224875.70,225822.01,936.31,154491.15,0.00,0.00,10.00,0.00,0.00),('1','161','862','186808',3659063,'2512','379',140083.48,140103.48,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','862','186808',3659064,'2513','379',181770.51,182983.94,1193.43,196915.95,0.00,0.00,20.00,0.00,0.00),('1','161','863','186808',3659065,'2514','380',116486.33,116496.33,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','161','863','186808',3659066,'2515','380',84553.07,85293.05,709.98,184594.80,0.00,0.00,30.00,0.00,0.00),('1','161','861','186816',3659190,'2496','379',141823.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659191,'2497','379',210544.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659192,'2498','379',288024.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659193,'2499','379',305788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659194,'2500','379',290768.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659195,'2501','379',143000.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659196,'2502','379',155986.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659197,'2503','379',88708.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659198,'2504','379',120100.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186816',3659199,'2505','379',236304.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659200,'2506','379',356863.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659201,'2507','379',339900.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659202,'2508','379',277770.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659203,'2509','379',240838.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659204,'2510','379',267676.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659205,'2511','379',225822.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659206,'2512','379',140103.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186816',3659207,'2513','379',182983.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186816',3659208,'2514','380',116496.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186816',3659209,'2515','380',85293.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659232,'2496','379',141823.87,143943.07,2119.20,343310.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659233,'2497','379',210544.98,210834.98,290.00,46980.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659234,'2498','379',288024.20,289989.49,1965.29,318376.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659235,'2499','379',305788.90,306068.14,279.24,45236.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659236,'2500','379',290768.35,292192.72,1424.37,230747.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659237,'2501','379',143000.53,144505.48,1504.95,243801.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659238,'2502','379',155986.42,156276.42,290.00,46980.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659239,'2503','379',88708.42,89088.32,379.90,61543.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659240,'2504','379',120100.25,120765.86,665.61,107828.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','186818',3659241,'2505','379',236304.93,238050.56,1745.63,282792.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659242,'2506','379',356863.16,359040.73,2177.57,352766.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659243,'2507','379',339900.33,341876.55,1976.22,320147.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659244,'2508','379',277770.03,279953.87,2183.84,353782.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659245,'2509','379',240838.72,240977.14,138.42,22424.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659246,'2510','379',267676.08,268894.05,1217.97,197311.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659247,'2511','379',225822.01,226883.80,1061.79,172009.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659248,'2512','379',140103.48,142134.67,2031.19,329052.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','186818',3659249,'2513','379',182983.94,184268.74,1284.80,208137.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','186818',3659250,'2514','380',116496.33,116892.18,395.85,102921.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186818',3659251,'2515','380',85293.05,85293.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659670,'2496','379',143943.07,144809.21,866.14,140314.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659671,'2497','379',210834.98,211858.62,1023.64,165829.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659672,'2498','379',289989.49,291357.20,1367.71,221569.02,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659673,'2499','379',306068.14,308097.14,2029.00,328698.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659674,'2500','379',292192.72,293700.30,1467.58,237747.96,0.00,0.00,40.00,0.00,0.00),('1','161','861','186840',3659675,'2501','379',144505.48,145276.74,771.26,124944.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659676,'2502','379',156276.42,157006.25,729.83,118232.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659677,'2503','379',89088.32,89928.32,840.00,136080.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659678,'2504','379',120765.86,122279.83,1513.97,245263.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','186840',3659679,'2505','379',238050.56,239102.97,1052.41,170490.42,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659680,'2506','379',359040.73,360764.39,1723.66,279232.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659681,'2507','379',341876.55,343120.43,1243.88,201508.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659682,'2508','379',279953.87,281582.22,1628.35,263792.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659683,'2509','379',240977.14,241815.77,838.63,135858.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659684,'2510','379',268894.05,270118.92,1224.87,198428.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659685,'2511','379',226883.80,227802.48,918.68,148826.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659686,'2512','379',142134.67,142860.25,725.58,117543.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','186840',3659687,'2513','379',184268.74,184942.22,673.48,109103.76,0.00,0.00,0.00,0.00,0.00),('1','161','863','186840',3659688,'2514','380',116892.18,117262.81,370.63,96363.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','186840',3659689,'2515','380',85293.05,85293.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659968,'2496','379',144809.21,144987.46,178.25,28876.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659969,'2497','379',211858.62,213235.42,1376.80,223041.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659970,'2498','379',291357.20,293318.62,1961.42,317750.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659971,'2499','379',308097.14,308907.45,810.31,131270.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659972,'2500','379',293700.30,295462.84,1762.54,285531.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659973,'2501','379',145276.74,146601.74,1325.00,214650.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659974,'2502','379',157006.25,157006.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659975,'2503','379',89928.32,90295.73,367.41,59520.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659976,'2504','379',122279.83,122507.59,227.76,36897.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','186854',3659977,'2505','379',239102.97,240672.75,1569.78,254304.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659978,'2506','379',360764.39,362586.05,1821.66,295108.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659979,'2507','379',343120.43,345022.85,1902.42,308192.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659980,'2508','379',281582.22,284037.26,2455.04,397716.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659981,'2509','379',241815.77,243318.81,1503.04,243492.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659982,'2510','379',270118.92,270318.17,199.25,32278.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659983,'2511','379',227802.48,228882.18,1079.70,174911.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659984,'2512','379',142860.25,142860.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186854',3659985,'2513','379',184942.22,186630.62,1688.40,273520.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','186854',3659986,'2514','380',117262.81,117776.60,513.79,133585.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','186854',3659987,'2515','380',85293.05,85293.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660272,'2496','379',144987.46,144987.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660273,'2497','379',213235.42,214161.81,926.39,150075.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660274,'2498','379',293318.62,293886.06,567.44,91925.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660275,'2499','379',308907.45,309699.81,792.36,128362.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660276,'2500','379',295462.84,296178.61,715.77,115954.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660277,'2501','379',146601.74,146601.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660278,'2502','379',157006.25,157843.81,837.56,135684.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660279,'2503','379',90295.73,90295.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660280,'2504','379',122507.59,122906.43,398.84,64612.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','186869',3660281,'2505','379',240672.75,241247.69,574.94,93140.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660282,'2506','379',362586.05,364086.16,1500.11,243017.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660283,'2507','379',345022.85,346224.57,1201.72,194678.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660284,'2508','379',284037.26,285212.14,1174.88,190330.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660285,'2509','379',243318.81,244626.76,1307.95,211887.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660286,'2510','379',270318.17,271527.55,1209.38,195919.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660287,'2511','379',228882.18,229815.97,933.79,151273.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660288,'2512','379',142860.25,143786.70,926.45,150084.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','186869',3660289,'2513','379',186630.62,187395.97,765.35,123986.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','186869',3660290,'2514','380',117776.60,117776.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186869',3660291,'2515','380',85293.05,85744.59,451.54,117400.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660537,'2496','379',144987.46,145956.79,969.33,157031.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660538,'2497','379',214161.81,215073.75,911.94,147734.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660539,'2498','379',293886.06,295968.85,2082.79,337411.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660540,'2499','379',309699.81,311520.65,1820.84,294976.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660541,'2500','379',296178.61,297828.95,1650.34,267355.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660542,'2501','379',146601.74,147901.84,1300.10,210616.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660543,'2502','379',157843.81,158138.84,295.03,47794.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660544,'2503','379',90295.73,91544.13,1248.40,202240.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660545,'2504','379',122906.43,124141.79,1235.36,200128.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','186891',3660546,'2505','379',241247.69,242369.19,1121.50,181683.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660547,'2506','379',364086.16,365448.39,1362.23,220681.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660548,'2507','379',346224.57,348252.00,2027.43,328443.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660549,'2508','379',285212.14,286558.82,1346.68,218162.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660550,'2509','379',244626.76,246953.98,2327.22,377009.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660551,'2510','379',271527.55,272413.42,885.87,143510.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660552,'2511','379',229815.97,230974.35,1158.38,187657.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660553,'2512','379',143786.70,144944.43,1157.73,187552.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','186891',3660554,'2513','379',187395.97,188393.69,997.72,161630.64,0.00,0.00,0.00,0.00,0.00),('1','161','863','186891',3660555,'2514','380',117776.60,118668.91,892.31,232000.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','186891',3660556,'2515','380',85744.59,87294.78,1550.19,403049.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660724,'2496','379',145956.79,145956.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660725,'2497','379',215073.75,216373.71,1299.96,210593.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660726,'2498','379',295968.85,297990.15,2021.30,327450.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660727,'2499','379',311520.65,314030.15,2509.50,406539.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660728,'2500','379',297828.95,299418.74,1589.79,257545.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660729,'2501','379',147901.84,148191.75,289.91,46965.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660730,'2502','379',158138.84,159935.43,1796.59,291047.58,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660731,'2503','379',91544.13,92296.76,752.63,121926.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660732,'2504','379',124141.79,125707.11,1565.32,253581.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','186900',3660733,'2505','379',242369.19,243585.52,1216.33,197045.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660734,'2506','379',365448.39,367624.48,2176.09,352526.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660735,'2507','379',348252.00,350690.36,2438.36,395014.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660736,'2508','379',286558.82,287592.88,1034.06,167517.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660737,'2509','379',246953.98,248148.77,1194.79,193555.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660738,'2510','379',272413.42,273831.75,1418.33,229769.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660739,'2511','379',230974.35,232251.05,1276.70,206825.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660740,'2512','379',144944.43,144944.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','186900',3660741,'2513','379',188393.69,189469.28,1075.59,174245.58,0.00,0.00,0.00,0.00,0.00),('1','161','863','186900',3660742,'2514','380',118668.91,119314.66,645.75,167895.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','186900',3660743,'2515','380',87294.78,87294.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662745,'2496','379',145956.79,147503.83,1547.04,250620.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662746,'2497','379',216373.71,216373.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662747,'2498','379',297990.15,300269.32,2279.17,369225.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662748,'2499','379',314030.15,315704.26,1674.11,271205.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662749,'2500','379',299418.74,301010.00,1591.26,257784.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662750,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662751,'2502','379',159935.43,161340.54,1405.11,227627.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662752,'2503','379',92296.76,92993.09,696.33,112805.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662753,'2504','379',125707.11,126435.88,728.77,118060.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','187035',3662754,'2505','379',243585.52,245577.32,1991.80,322671.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662755,'2506','379',367624.48,369455.86,1831.38,296683.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662756,'2507','379',350690.36,353009.79,2319.43,375747.66,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662757,'2508','379',287592.88,289201.95,1609.07,260669.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662758,'2509','379',248148.77,249806.43,1657.66,268540.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662759,'2510','379',273831.75,275814.30,1982.55,321173.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662760,'2511','379',232251.05,234000.52,1749.47,283414.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662761,'2512','379',144944.43,146259.92,1315.49,213109.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','187035',3662762,'2513','379',189469.28,189469.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','187035',3662763,'2514','380',119314.66,119971.13,656.47,170682.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','187035',3662764,'2515','380',87294.78,87294.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662993,'2496','379',147503.83,147503.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662994,'2497','379',216373.71,216609.07,235.36,38128.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662995,'2498','379',300269.32,300559.52,290.20,47012.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662996,'2499','379',315704.26,316048.42,344.16,55753.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662997,'2500','379',301010.00,301289.40,279.40,45262.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662998,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3662999,'2502','379',161340.54,161547.15,206.61,33470.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3663000,'2503','379',92993.09,92993.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3663001,'2504','379',126435.88,126435.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187049',3663002,'2505','379',245577.32,245813.01,235.69,38181.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663003,'2506','379',369455.86,371846.42,2390.56,387270.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663004,'2507','379',353009.79,355574.55,2564.76,415491.12,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663005,'2508','379',289201.95,291583.45,2381.50,385803.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663006,'2509','379',249806.43,252156.41,2349.98,380696.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663007,'2510','379',275814.30,278346.24,2521.69,408513.78,0.00,0.00,10.25,0.00,0.00),('1','161','862','187049',3663008,'2511','379',234000.52,235920.94,1920.42,311108.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663009,'2512','379',146259.92,147489.36,1229.44,199169.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','187049',3663010,'2513','379',189469.28,191449.61,1970.08,319152.96,0.00,0.00,10.25,0.00,0.00),('1','161','863','187049',3663011,'2514','380',119971.13,120137.76,166.63,43323.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','187049',3663012,'2515','380',87294.78,87354.78,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663064,'2496','379',147503.83,147503.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663065,'2497','379',216609.07,216609.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663066,'2498','379',300559.52,300559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663067,'2499','379',316048.42,316048.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663068,'2500','379',301289.40,301289.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663069,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663070,'2502','379',161547.15,161547.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663071,'2503','379',92993.09,92993.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663072,'2504','379',126435.88,126435.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187053',3663073,'2505','379',245813.01,245813.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663074,'2506','379',371846.42,374724.60,2878.18,469143.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663075,'2507','379',355574.55,359464.35,3889.80,634037.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663076,'2508','379',291583.45,293430.20,1846.75,301020.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663077,'2509','379',252156.41,255380.91,3224.50,525593.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663078,'2510','379',278346.24,281397.41,3051.17,497340.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663079,'2511','379',235920.94,238992.37,3071.43,500643.09,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663080,'2512','379',147489.36,150955.90,3466.54,565046.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','187053',3663081,'2513','379',191449.61,194234.76,2785.15,453979.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','187053',3663082,'2514','380',120137.76,120432.38,294.62,76601.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','187053',3663083,'2515','380',87354.78,88087.85,733.07,190598.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671423,'2496','379',147503.83,147503.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671424,'2497','379',216609.07,216609.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671425,'2498','379',300559.52,300559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671426,'2499','379',316048.42,316048.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671427,'2500','379',301289.40,301289.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671428,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671429,'2502','379',161547.15,161547.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671430,'2503','379',92993.09,92993.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671431,'2504','379',126435.88,126435.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187515',3671432,'2505','379',245813.01,245813.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671433,'2506','379',374724.60,376263.53,1538.93,250845.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671434,'2507','379',359464.35,361252.40,1788.05,291452.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671435,'2508','379',293430.20,295063.56,1633.36,266237.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671436,'2509','379',255380.91,256940.56,1559.65,254222.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671437,'2510','379',281397.41,283033.06,1635.65,266610.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671438,'2511','379',238992.37,240030.99,1038.62,169295.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671439,'2512','379',150955.90,152712.82,1756.92,286377.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','187515',3671440,'2513','379',194234.76,195621.00,1386.24,225957.28,0.00,0.00,0.00,0.00,0.00),('1','161','863','187515',3671441,'2514','380',120432.38,120985.31,552.93,143761.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','187515',3671442,'2515','380',88087.85,88087.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673265,'2496','379',147503.83,147503.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673266,'2497','379',216609.07,216609.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673267,'2498','379',300559.52,300559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673268,'2499','379',316048.42,316048.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673269,'2500','379',301289.40,301289.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673270,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673271,'2502','379',161547.15,161547.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673272,'2503','379',92993.09,92993.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673273,'2504','379',126435.88,126435.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187626',3673274,'2505','379',245813.01,245813.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673275,'2506','379',376263.53,377745.92,1482.39,241629.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673276,'2507','379',361252.40,363159.57,1907.17,310868.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673277,'2508','379',295063.56,296284.50,1220.94,199013.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673278,'2509','379',256940.56,257978.33,1037.77,169156.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673279,'2510','379',283033.06,283840.96,807.90,131687.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673280,'2511','379',240030.99,241077.89,1046.90,170644.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673281,'2512','379',152712.82,154231.74,1518.92,247583.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','187626',3673282,'2513','379',195621.00,196423.14,802.14,130748.82,0.00,0.00,0.00,0.00,0.00),('1','161','863','187626',3673283,'2514','380',120985.31,122258.00,1272.69,330899.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','187626',3673284,'2515','380',88087.85,89087.87,1000.02,260005.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673446,'2496','379',147503.83,147503.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673447,'2497','379',216609.07,216826.31,217.24,35410.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673448,'2498','379',300559.52,300837.70,278.18,45343.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673449,'2499','379',316048.42,316437.76,389.34,63462.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673450,'2500','379',301289.40,301590.29,300.89,49045.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673451,'2501','379',148191.75,148191.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673452,'2502','379',161547.15,161854.79,307.64,50145.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673453,'2503','379',92993.09,92993.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673454,'2504','379',126435.88,126435.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187636',3673455,'2505','379',245813.01,246010.50,197.49,32190.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673456,'2506','379',377745.92,378113.38,367.46,59895.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673457,'2507','379',363159.57,363804.47,644.90,105118.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673458,'2508','379',296284.50,296536.90,252.40,41141.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673459,'2509','379',257978.33,258220.50,242.17,39473.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673460,'2510','379',283840.96,284312.62,471.66,76880.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673461,'2511','379',241077.89,241077.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673462,'2512','379',154231.74,154231.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187636',3673463,'2513','379',196423.14,196557.87,134.73,21960.99,0.00,0.00,0.00,0.00,0.00),('1','161','863','187636',3673464,'2514','380',122258.00,122669.34,411.34,106948.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','187636',3673465,'2515','380',89087.87,89087.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673602,'2496','379',147503.83,148772.22,1268.39,206747.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673603,'2497','379',216826.31,216826.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673604,'2498','379',300837.70,302067.86,1230.16,200516.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673605,'2499','379',316437.76,318333.12,1895.36,308943.68,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673606,'2500','379',301590.29,303246.24,1655.95,269919.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673607,'2501','379',148191.75,148951.94,760.19,123910.97,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673608,'2502','379',161854.79,162322.39,467.60,76218.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673609,'2503','379',92993.09,93732.96,739.87,120598.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673610,'2504','379',126435.88,126725.88,290.00,47270.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187645',3673611,'2505','379',246010.50,247560.44,1549.94,252640.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673612,'2506','379',378113.38,379011.93,898.55,146463.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673613,'2507','379',363804.47,365531.32,1726.85,281476.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673614,'2508','379',296536.90,299189.55,2652.65,432381.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673615,'2509','379',258220.50,259280.68,1060.18,172809.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673616,'2510','379',284312.62,285548.68,1236.06,201477.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673617,'2511','379',241077.89,242394.75,1316.86,214648.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673618,'2512','379',154231.74,155665.44,1433.70,233693.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','187645',3673619,'2513','379',196557.87,197521.51,963.64,157073.32,0.00,0.00,0.00,0.00,0.00),('1','161','863','187645',3673620,'2514','380',122669.34,122669.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','187645',3673621,'2515','380',89087.87,89331.36,243.49,63307.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673901,'2496','379',148772.22,149495.38,723.16,117875.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673902,'2497','379',216826.31,217660.60,834.29,135989.27,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673903,'2498','379',302067.86,304374.13,2306.27,375922.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673904,'2499','379',318333.12,319811.88,1478.76,241037.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673905,'2500','379',303246.24,305487.02,2240.78,365247.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673906,'2501','379',148951.94,149985.64,1033.70,168493.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673907,'2502','379',162322.39,162322.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673908,'2503','379',93732.96,94862.42,1129.46,184101.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673909,'2504','379',126725.88,127122.02,396.14,64570.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','187659',3673910,'2505','379',247560.44,249188.79,1628.35,265421.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673911,'2506','379',379011.93,381226.57,2214.64,360986.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673912,'2507','379',365531.32,367348.18,1816.86,296148.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673913,'2508','379',299189.55,299964.14,774.59,126258.17,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673914,'2509','379',259280.68,260320.94,1040.26,169562.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673915,'2510','379',285548.68,287396.43,1847.75,301183.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673916,'2511','379',242394.75,243554.89,1160.14,189102.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673917,'2512','379',155665.44,156481.32,815.88,132988.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','187659',3673918,'2513','379',197521.51,199827.19,2305.68,375825.84,0.00,0.00,0.00,0.00,0.00),('1','161','863','187659',3673919,'2514','380',122669.34,122669.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','187659',3673920,'2515','380',89331.36,89915.21,583.85,151801.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674384,'2496','379',149495.38,149495.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674385,'2497','379',217660.60,218838.82,1178.22,192049.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674386,'2498','379',304374.13,305803.26,1429.13,232948.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674387,'2499','379',319811.88,321519.02,1707.14,278263.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674388,'2500','379',305487.02,306853.39,1366.37,222718.31,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674389,'2501','379',149985.64,149985.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674390,'2502','379',162322.39,163492.22,1169.83,190682.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674391,'2503','379',94862.42,96022.42,1160.00,189080.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674392,'2504','379',127122.02,128236.24,1114.22,181617.86,0.00,0.00,0.00,0.00,0.00),('1','161','861','187684',3674393,'2505','379',249188.79,250856.80,1668.01,271885.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674394,'2506','379',381226.57,383063.63,1837.06,299440.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674395,'2507','379',367348.18,369616.30,2268.12,369703.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674396,'2508','379',299964.14,301575.03,1610.89,262575.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674397,'2509','379',260320.94,261762.91,1441.97,235041.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674398,'2510','379',287396.43,288967.75,1571.32,256125.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674399,'2511','379',243554.89,245083.03,1528.14,249086.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674400,'2512','379',156481.32,156481.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187684',3674401,'2513','379',199827.19,201390.32,1563.13,254790.19,0.00,0.00,0.00,0.00,0.00),('1','161','863','187684',3674402,'2514','380',122669.34,122669.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','187684',3674403,'2515','380',89915.21,90333.29,418.08,108700.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675497,'2496','379',149495.38,149495.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675498,'2497','379',218838.82,218838.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675499,'2498','379',305803.26,305803.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675500,'2499','379',321519.02,321519.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675501,'2500','379',306853.39,306853.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675502,'2501','379',149985.64,149985.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675503,'2502','379',163492.22,163492.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675504,'2503','379',96022.42,96022.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675505,'2504','379',128236.24,128236.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187743',3675506,'2505','379',250856.80,250856.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675507,'2506','379',383063.63,385448.76,2385.13,393546.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675508,'2507','379',369616.30,372054.52,2438.22,402306.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675509,'2508','379',301575.03,303134.67,1559.64,257340.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675510,'2509','379',261762.91,264086.83,2323.92,383446.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675511,'2510','379',288967.75,291292.20,2324.45,383534.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675512,'2511','379',245083.03,247074.37,1991.34,328571.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675513,'2512','379',156481.32,158213.00,1731.68,285727.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','187743',3675514,'2513','379',201390.32,203660.59,2270.27,374594.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','187743',3675515,'2514','380',122669.34,122846.95,177.61,46178.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','187743',3675516,'2515','380',90333.29,90335.29,2.00,520.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677149,'2496','379',149495.38,149495.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677150,'2497','379',218838.82,218838.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677151,'2498','379',305803.26,305803.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677152,'2499','379',321519.02,321519.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677153,'2500','379',306853.39,306853.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677154,'2501','379',149985.64,149985.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677155,'2502','379',163492.22,163492.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677156,'2503','379',96022.42,96022.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677157,'2504','379',128236.24,128236.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','187848',3677158,'2505','379',250856.80,250856.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677159,'2506','379',385448.76,388590.35,3121.08,514978.20,0.00,0.00,20.51,0.00,0.00),('1','161','862','187848',3677160,'2507','379',372054.52,375074.73,3020.21,498334.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677161,'2508','379',303134.67,305479.58,2344.91,386910.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677162,'2509','379',264086.83,267240.00,3132.66,516888.90,0.00,0.00,20.51,0.00,0.00),('1','161','862','187848',3677163,'2510','379',291292.20,294263.62,2971.42,490284.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677164,'2511','379',247074.37,249289.09,2214.72,365428.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677165,'2512','379',158213.00,160619.40,2406.40,397056.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','187848',3677166,'2513','379',203660.59,205684.36,2023.77,333922.05,0.00,0.00,0.00,0.00,0.00),('1','161','863','187848',3677167,'2514','380',122846.95,122846.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','187848',3677168,'2515','380',90335.29,91111.71,776.42,201869.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681319,'2496','379',149495.38,149495.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681320,'2497','379',218838.82,219718.34,879.52,145120.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681321,'2498','379',305803.26,306503.59,700.33,115554.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681322,'2499','379',321519.02,322494.86,975.84,161013.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681323,'2500','379',306853.39,307737.08,883.69,145808.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681324,'2501','379',149985.64,149985.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681325,'2502','379',163492.22,164038.44,546.22,90126.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681326,'2503','379',96022.42,96025.14,2.72,448.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681327,'2504','379',128236.24,128236.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188085',3681328,'2505','379',250856.80,251594.12,737.32,121657.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681329,'2506','379',388590.35,390775.90,2185.55,360615.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681330,'2507','379',375074.73,376464.53,1389.80,229317.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681331,'2508','379',305479.58,306773.64,1294.06,213519.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681332,'2509','379',267240.00,268142.39,902.39,148894.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681333,'2510','379',294263.62,295673.89,1410.27,232694.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681334,'2511','379',249289.09,250427.47,1138.38,187832.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681335,'2512','379',160619.40,161692.53,1073.13,177066.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','188085',3681336,'2513','379',205684.36,206752.52,1068.16,176246.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','188085',3681337,'2514','380',122846.95,122945.41,98.46,25599.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','188085',3681338,'2515','380',91111.71,91111.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681888,'2496','379',149495.38,151301.73,1806.35,298047.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681889,'2497','379',219718.34,220431.53,713.19,117676.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681890,'2498','379',306503.59,308107.96,1604.37,264721.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681891,'2499','379',322494.86,324564.30,2069.44,341457.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681892,'2500','379',307737.08,310236.25,2499.17,412363.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681893,'2501','379',149985.64,151613.06,1627.42,268524.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681894,'2502','379',164038.44,164673.06,634.62,104712.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681895,'2503','379',96025.14,98676.47,2651.33,437469.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681896,'2504','379',128236.24,131038.59,2802.35,462387.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','188116',3681897,'2505','379',251594.12,252949.16,1355.04,223581.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681898,'2506','379',390775.90,391939.11,1163.21,191929.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681899,'2507','379',376464.53,378027.75,1563.22,257931.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681900,'2508','379',306773.64,308274.37,1500.73,247620.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681901,'2509','379',268142.39,268142.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681902,'2510','379',295673.89,296559.19,885.30,146074.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681903,'2511','379',250427.47,251263.55,836.08,137953.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681904,'2512','379',161692.53,161692.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188116',3681905,'2513','379',206752.52,207794.76,1042.24,171969.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','188116',3681906,'2514','380',122945.41,123183.87,238.46,61999.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','188116',3681907,'2515','380',91111.71,91440.47,328.76,85477.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681964,'2496','379',151301.73,152694.35,1392.62,229782.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681965,'2497','379',220431.53,220431.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681966,'2498','379',308107.96,309054.20,946.24,156129.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681967,'2499','379',324564.30,325951.49,1387.19,228886.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681968,'2500','379',310236.25,311505.50,1269.25,209426.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681969,'2501','379',151613.06,152701.05,1087.99,179518.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681970,'2502','379',164673.06,164673.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681971,'2503','379',98676.47,98676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681972,'2504','379',131038.59,132138.37,1099.78,181463.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','188121',3681973,'2505','379',252949.16,253998.38,1049.22,173121.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681974,'2506','379',391939.11,392352.91,413.80,68277.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681975,'2507','379',378027.75,380973.28,2945.53,486012.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681976,'2508','379',308274.37,309949.74,1645.37,271486.05,0.00,0.00,30.00,0.00,0.00),('1','161','862','188121',3681977,'2509','379',268142.39,269196.19,1053.80,173877.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681978,'2510','379',296559.19,297763.77,1204.58,198755.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681979,'2511','379',251263.55,252261.47,997.92,164656.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681980,'2512','379',161692.53,162348.12,655.59,108172.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188121',3681981,'2513','379',207794.76,208622.77,828.01,136621.65,0.00,0.00,0.00,0.00,0.00),('1','161','863','188121',3681982,'2514','380',123183.87,123470.40,286.53,74497.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','188121',3681983,'2515','380',91440.47,91440.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683308,'2496','379',152694.35,152694.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683309,'2497','379',220431.53,222133.13,1701.60,280764.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683310,'2498','379',309054.20,311122.12,2067.92,341206.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683311,'2499','379',325951.49,328258.41,2306.92,380641.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683312,'2500','379',311505.50,313453.86,1948.36,321479.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683313,'2501','379',152701.05,152701.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683314,'2502','379',164673.06,165813.27,1140.21,188134.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683315,'2503','379',98676.47,98676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683316,'2504','379',132138.37,132138.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188187',3683317,'2505','379',253998.38,255768.09,1769.71,292002.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683318,'2506','379',392352.91,394715.74,2362.83,389866.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683319,'2507','379',380973.28,382994.57,2021.29,333512.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683320,'2508','379',309949.74,311630.66,1680.92,277351.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683321,'2509','379',269196.19,270654.41,1458.22,240606.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683322,'2510','379',297763.77,299370.84,1607.07,265166.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683323,'2511','379',252261.47,253778.26,1516.79,250270.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683324,'2512','379',162348.12,162348.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188187',3683325,'2513','379',208622.77,210076.69,1453.92,239896.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','188187',3683326,'2514','380',123470.40,123629.48,159.08,41360.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','188187',3683327,'2515','380',91440.47,91570.67,130.20,33852.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685554,'2496','379',152694.35,152694.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685555,'2497','379',222133.13,222371.19,238.06,39279.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685556,'2498','379',311122.12,311556.55,434.43,71680.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685557,'2499','379',328258.41,328464.86,206.45,34064.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685558,'2500','379',313453.86,313678.06,224.20,36993.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685559,'2501','379',152701.05,152701.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685560,'2502','379',165813.27,165964.34,151.07,24926.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685561,'2503','379',98676.47,98676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685562,'2504','379',132138.37,132160.90,22.53,3717.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','188332',3685563,'2505','379',255768.09,256127.03,358.94,59225.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685564,'2506','379',394715.74,397166.58,2450.84,404388.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685565,'2507','379',382994.57,385152.79,2158.22,356106.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685566,'2508','379',311630.66,312935.43,1304.77,215287.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685567,'2509','379',270654.41,272682.92,2028.51,334704.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685568,'2510','379',299370.84,301677.79,2306.95,380646.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685569,'2511','379',253778.26,255420.16,1641.90,270913.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685570,'2512','379',162348.12,163894.16,1546.04,255096.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','188332',3685571,'2513','379',210076.69,211618.42,1541.73,254385.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','188332',3685572,'2514','380',123629.48,123777.48,148.00,38480.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188332',3685573,'2515','380',91570.67,91588.36,17.69,4599.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686744,'2496','379',152694.35,152694.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686745,'2497','379',222371.19,222371.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686746,'2498','379',311556.55,311556.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686747,'2499','379',328464.86,328464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686748,'2500','379',313678.06,313678.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686749,'2501','379',152701.05,152701.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686750,'2502','379',165964.34,165964.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686751,'2503','379',98676.47,98676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686752,'2504','379',132160.90,132160.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188392',3686753,'2505','379',256127.03,256127.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686754,'2506','379',397166.58,400042.61,2876.03,474544.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686755,'2507','379',385152.79,388815.12,3662.33,604284.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686756,'2508','379',312935.43,315442.04,2506.61,413590.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686757,'2509','379',272682.92,274988.23,2305.31,380376.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686758,'2510','379',301677.79,303397.17,1719.38,283697.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686759,'2511','379',255420.16,257834.32,2414.16,398336.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686760,'2512','379',163894.16,167289.30,3395.14,560198.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','188392',3686761,'2513','379',211618.42,216096.58,4478.16,738896.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','188392',3686762,'2514','380',123777.48,123777.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188392',3686763,'2515','380',91588.36,92139.10,550.74,143192.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688862,'2496','379',152694.35,153380.41,686.06,113199.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688863,'2497','379',222371.19,222455.40,84.21,13894.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688864,'2498','379',311556.55,311556.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688865,'2499','379',328464.86,329941.20,1476.34,243596.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688866,'2500','379',313678.06,314441.25,763.19,125926.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688867,'2501','379',152701.05,152701.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688868,'2502','379',165964.34,166704.23,739.89,122081.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688869,'2503','379',98676.47,98676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688870,'2504','379',132160.90,132160.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188519',3688871,'2505','379',256127.03,257503.34,1376.31,227091.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688872,'2506','379',400042.61,400932.22,889.61,146785.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688873,'2507','379',388815.12,389874.90,1059.78,174863.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688874,'2508','379',315442.04,316110.74,668.70,110335.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688875,'2509','379',274988.23,275516.35,528.12,87139.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688876,'2510','379',303397.17,303871.10,473.93,78198.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688877,'2511','379',257834.32,258276.63,442.31,72981.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688878,'2512','379',167289.30,169644.10,2354.80,388542.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188519',3688879,'2513','379',216096.58,218451.86,2355.28,388621.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','188519',3688880,'2514','380',123777.48,123777.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188519',3688881,'2515','380',92139.10,92427.94,288.84,75098.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690087,'2496','379',153380.41,153972.98,592.57,97774.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690088,'2497','379',222455.40,222947.30,491.90,81163.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690089,'2498','379',311556.55,313394.13,1837.58,303200.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690090,'2499','379',329941.20,331637.83,1696.63,279943.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690091,'2500','379',314441.25,316244.39,1803.14,297518.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690092,'2501','379',152701.05,153736.89,1035.84,170913.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690093,'2502','379',166704.23,167124.27,420.04,69306.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690094,'2503','379',98676.47,99106.86,430.39,71014.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690095,'2504','379',132160.90,133170.56,1009.66,166593.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188581',3690096,'2505','379',257503.34,258578.32,1074.98,177371.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690097,'2506','379',400932.22,402037.61,1105.39,182389.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690098,'2507','379',389874.90,391430.86,1555.96,256733.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690099,'2508','379',316110.74,316981.36,870.62,143652.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690100,'2509','379',275516.35,276218.49,702.14,115853.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690101,'2510','379',303871.10,304666.58,795.48,131254.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690102,'2511','379',258276.63,258786.24,509.61,84085.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690103,'2512','379',169644.10,169644.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188581',3690104,'2513','379',218451.86,219056.18,604.32,99712.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','188581',3690105,'2514','380',123777.48,124159.71,382.23,99379.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','188581',3690106,'2515','380',92427.94,92427.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692091,'2496','379',153972.98,155427.57,1454.59,240007.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692092,'2497','379',222947.30,224913.76,1966.46,324465.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692093,'2498','379',313394.13,315371.98,1977.85,326345.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692094,'2499','379',331637.83,333264.24,1626.41,268357.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692095,'2500','379',316244.39,317693.91,1449.52,239170.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692096,'2501','379',153736.89,154919.09,1182.20,195063.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692097,'2502','379',167124.27,168094.13,969.86,160026.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692098,'2503','379',99106.86,100014.82,907.96,149813.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692099,'2504','379',133170.56,133707.60,537.04,88611.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188705',3692100,'2505','379',258578.32,259616.08,1037.76,171230.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692101,'2506','379',402037.61,402037.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692102,'2507','379',391430.86,391430.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692103,'2508','379',316981.36,316981.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692104,'2509','379',276218.49,276218.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692105,'2510','379',304666.58,304666.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692106,'2511','379',258786.24,258786.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692107,'2512','379',169644.10,169644.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','188705',3692108,'2513','379',219056.18,219056.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188705',3692109,'2514','380',124159.71,124296.58,136.87,35586.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','188705',3692110,'2515','380',92427.94,92427.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694383,'2496','379',155427.57,155941.63,514.06,84819.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694384,'2497','379',224913.76,225565.00,651.24,107454.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694385,'2498','379',315371.98,316343.62,971.64,160320.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694386,'2499','379',333264.24,334290.72,1026.48,169369.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694387,'2500','379',317693.91,318176.44,482.53,79617.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694388,'2501','379',154919.09,155362.72,443.63,73198.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694389,'2502','379',168094.13,168703.07,608.94,100475.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694390,'2503','379',100014.82,100343.30,328.48,54199.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694391,'2504','379',133707.60,134012.51,304.91,50310.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','188839',3694392,'2505','379',259616.08,260210.64,594.56,98102.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694393,'2506','379',402037.61,404786.71,2749.10,453601.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694394,'2507','379',391430.86,393542.63,2111.77,348442.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694395,'2508','379',316981.36,318660.54,1679.18,277064.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694396,'2509','379',276218.49,278153.44,1934.95,319266.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694397,'2510','379',304666.58,306819.19,2152.61,355180.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694398,'2511','379',258786.24,260845.12,2058.88,339715.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694399,'2512','379',169644.10,172488.78,2844.68,469372.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','188839',3694400,'2513','379',219056.18,222338.57,3282.39,541594.35,0.00,0.00,0.00,0.00,0.00),('1','161','863','188839',3694401,'2514','380',124296.58,124296.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188839',3694402,'2515','380',92427.94,92632.55,204.61,53198.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695828,'2496','379',155941.63,157515.48,1573.85,259685.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695829,'2497','379',225565.00,226313.31,748.31,123471.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695830,'2498','379',316343.62,318313.68,1970.06,325059.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695831,'2499','379',334290.72,335174.37,883.65,145802.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695832,'2500','379',318176.44,318829.04,652.60,107679.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695833,'2501','379',155362.72,156557.76,1195.04,197181.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695834,'2502','379',168703.07,169226.29,523.22,86331.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695835,'2503','379',100343.30,100850.34,507.04,83661.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695836,'2504','379',134012.51,135015.92,1003.41,165562.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','188911',3695837,'2505','379',260210.64,261573.61,1362.97,224890.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695838,'2506','379',404786.71,405836.42,1049.71,173202.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695839,'2507','379',393542.63,394023.54,480.91,79350.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695840,'2508','379',318660.54,319149.86,489.32,80737.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695841,'2509','379',278153.44,279045.41,891.97,147175.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695842,'2510','379',306819.19,307176.04,356.85,58880.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695843,'2511','379',260845.12,261376.88,531.76,87740.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695844,'2512','379',172488.78,173422.72,933.94,154100.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','188911',3695845,'2513','379',222338.57,223780.23,1441.66,237873.90,0.00,0.00,0.00,0.00,0.00),('1','161','863','188911',3695846,'2514','380',124296.58,124296.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','188911',3695847,'2515','380',92632.55,92885.58,253.03,65787.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697143,'2496','379',157515.48,158461.43,945.95,156081.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697144,'2497','379',226313.31,227878.91,1565.60,258324.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697145,'2498','379',318313.68,320057.36,1743.68,287707.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697146,'2499','379',335174.37,337173.42,1999.05,329843.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697147,'2500','379',318829.04,320469.13,1640.09,270614.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697148,'2501','379',156557.76,157287.18,729.42,120354.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697149,'2502','379',169226.29,170051.50,825.21,136159.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697150,'2503','379',100850.34,101689.36,839.02,138438.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697151,'2504','379',135015.92,135516.80,500.88,82645.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','188975',3697152,'2505','379',261573.61,262924.80,1351.19,222946.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697153,'2506','379',405836.42,406534.21,697.79,115135.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697154,'2507','379',394023.54,395258.43,1234.89,203756.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697155,'2508','379',319149.86,320193.69,1043.83,172231.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697156,'2509','379',279045.41,280056.57,1011.16,166841.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697157,'2510','379',307176.04,308294.40,1118.36,184529.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697158,'2511','379',261376.88,262102.06,725.18,119654.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697159,'2512','379',173422.72,175779.14,2356.42,388809.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','188975',3697160,'2513','379',223780.23,225064.42,1284.19,211891.35,0.00,0.00,0.00,0.00,0.00),('1','161','863','188975',3697161,'2514','380',124296.58,124993.15,696.57,181108.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','188975',3697162,'2515','380',92885.58,93077.89,192.31,50000.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701729,'2496','379',158461.43,158461.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701730,'2497','379',227878.91,228706.15,827.24,136494.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701731,'2498','379',320057.36,321879.37,1822.01,300631.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701732,'2499','379',337173.42,338991.79,1818.37,300031.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701733,'2500','379',320469.13,321962.84,1493.71,246462.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701734,'2501','379',157287.18,157860.90,573.72,94663.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701735,'2502','379',170051.50,171121.47,1069.97,176545.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701736,'2503','379',101689.36,101689.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701737,'2504','379',135516.80,136176.06,659.26,108777.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','189246',3701738,'2505','379',262924.80,264497.39,1572.59,259477.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701739,'2506','379',406534.21,408333.12,1798.91,296820.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701740,'2507','379',395258.43,397073.90,1815.47,299552.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701741,'2508','379',320193.69,321953.45,1759.76,290360.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701742,'2509','379',280056.57,281326.21,1269.64,209490.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701743,'2510','379',308294.40,309825.56,1531.16,252641.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701744,'2511','379',262102.06,262666.89,564.83,93196.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701745,'2512','379',175779.14,176617.27,838.13,138291.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','189246',3701746,'2513','379',225064.42,226296.25,1231.83,203251.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','189246',3701747,'2514','380',124993.15,125012.38,19.23,4999.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','189246',3701748,'2515','380',93077.89,93607.12,529.23,137599.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703680,'2496','379',158461.43,160043.80,1582.37,261091.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703681,'2497','379',228706.15,228706.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703682,'2498','379',321879.37,324043.07,2163.70,357010.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703683,'2499','379',338991.79,340928.40,1936.61,319540.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703684,'2500','379',321962.84,323544.92,1582.08,261043.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703685,'2501','379',157860.90,159229.24,1368.34,225776.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703686,'2502','379',171121.47,171121.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703687,'2503','379',101689.36,101689.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703688,'2504','379',136176.06,137210.50,1034.44,170682.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','189337',3703689,'2505','379',264497.39,266330.92,1833.53,302532.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703690,'2506','379',408333.12,410313.53,1980.41,326767.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703691,'2507','379',397073.90,399536.40,2462.50,406312.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703692,'2508','379',321953.45,322871.09,917.64,151410.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703693,'2509','379',281326.21,283117.32,1791.11,295533.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703694,'2510','379',309825.56,311294.34,1468.78,242348.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703695,'2511','379',262666.89,264372.17,1705.28,281371.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703696,'2512','379',176617.27,177683.44,1066.17,175918.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','189337',3703697,'2513','379',226296.25,227304.60,1008.35,166377.75,0.00,0.00,0.00,0.00,0.00),('1','161','863','189337',3703698,'2514','380',125012.38,125474.68,462.30,120198.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','189337',3703699,'2515','380',93607.12,93749.11,141.99,36917.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703806,'2496','379',160043.80,160336.83,293.03,48349.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703807,'2497','379',228706.15,229522.53,816.38,134702.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703808,'2498','379',324043.07,325021.06,977.99,161368.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703809,'2499','379',340928.40,342273.11,1344.71,221877.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703810,'2500','379',323544.92,324202.23,657.31,108456.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703811,'2501','379',159229.24,159605.21,375.97,62035.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703812,'2502','379',171121.47,171618.46,496.99,82003.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703813,'2503','379',101689.36,102213.32,523.96,86453.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703814,'2504','379',137210.50,137210.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189343',3703815,'2505','379',266330.92,267439.43,1108.51,182904.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703816,'2506','379',410313.53,412072.76,1759.23,290272.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703817,'2507','379',399536.40,401482.30,1945.90,321073.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703818,'2508','379',322871.09,324132.44,1261.35,208122.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703819,'2509','379',283117.32,284480.11,1362.79,224860.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703820,'2510','379',311294.34,312405.86,1111.52,183400.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703821,'2511','379',264372.17,265320.32,948.15,156444.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703822,'2512','379',177683.44,179078.74,1395.30,230224.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189343',3703823,'2513','379',227304.60,227743.13,438.53,72357.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','189343',3703824,'2514','380',125474.68,125917.72,443.04,115190.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','189343',3703825,'2515','380',93749.11,93749.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704747,'2496','379',160336.83,161941.95,1605.12,264844.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704748,'2497','379',229522.53,230606.89,1084.36,178919.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704749,'2498','379',325021.06,326393.45,1372.39,226444.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704750,'2499','379',342273.11,344314.93,2041.82,336900.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704751,'2500','379',324202.23,326125.18,1922.95,317286.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704752,'2501','379',159605.21,160620.11,1014.90,167458.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704753,'2502','379',171618.46,172613.37,994.91,164160.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704754,'2503','379',102213.32,104991.74,2778.42,458439.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704755,'2504','379',137210.50,139182.50,1972.00,325380.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189393',3704756,'2505','379',267439.43,269050.55,1611.12,265834.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704757,'2506','379',412072.76,412285.60,212.84,35118.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704758,'2507','379',401482.30,403475.66,1993.36,328904.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704759,'2508','379',324132.44,324923.49,791.05,130523.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704760,'2509','379',284480.11,285377.09,896.98,148001.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704761,'2510','379',312405.86,313122.86,717.00,118305.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704762,'2511','379',265320.32,266022.76,702.44,115902.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704763,'2512','379',179078.74,180042.45,963.71,159012.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189393',3704764,'2513','379',227743.13,227743.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','189393',3704765,'2514','380',125917.72,126683.04,765.32,198983.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','189393',3704766,'2515','380',93749.11,93749.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707187,'2496','379',161941.95,162725.46,783.51,129279.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707188,'2497','379',230606.89,230606.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707189,'2498','379',326393.45,327476.69,1083.24,178734.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707190,'2499','379',344314.93,345608.14,1293.21,213379.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707191,'2500','379',326125.18,327328.94,1203.76,198620.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707192,'2501','379',160620.11,160776.22,156.11,25758.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707193,'2502','379',172613.37,173298.25,684.88,113005.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707194,'2503','379',104991.74,104991.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707195,'2504','379',139182.50,139339.87,157.37,25966.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','189545',3707196,'2505','379',269050.55,269971.26,920.71,151917.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707197,'2506','379',412285.60,414223.55,1937.95,319761.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707198,'2507','379',403475.66,406292.69,2817.03,464809.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707199,'2508','379',324923.49,326151.89,1228.40,202686.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707200,'2509','379',285377.09,286446.11,1069.02,176388.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707201,'2510','379',313122.86,314069.87,947.01,156256.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707202,'2511','379',266022.76,267158.70,1135.94,187430.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707203,'2512','379',180042.45,180635.82,593.37,97906.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','189545',3707204,'2513','379',227743.13,228651.77,908.64,149925.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','189545',3707205,'2514','380',126683.04,126939.97,256.93,66801.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','189545',3707206,'2515','380',93749.11,93749.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709167,'2496','379',162725.46,162725.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709168,'2497','379',230606.89,231281.81,674.92,111361.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709169,'2498','379',327476.69,328601.59,1124.90,185608.50,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709170,'2499','379',345608.14,346975.10,1366.96,225548.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709171,'2500','379',327328.94,328455.09,1126.15,185814.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709172,'2501','379',160776.22,161278.76,502.54,82919.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709173,'2502','379',173298.25,173298.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709174,'2503','379',104991.74,105408.75,417.01,68806.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709175,'2504','379',139339.87,139339.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189665',3709176,'2505','379',269971.26,270961.49,990.23,163387.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709177,'2506','379',414223.55,416475.93,2252.38,371642.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709178,'2507','379',406292.69,407740.67,1447.98,238916.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709179,'2508','379',326151.89,327178.40,1026.51,169374.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709180,'2509','379',286446.11,287957.76,1511.65,249422.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709181,'2510','379',314069.87,315079.70,1009.83,166621.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709182,'2511','379',267158.70,268303.20,1144.50,188842.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709183,'2512','379',180635.82,181504.72,868.90,143368.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189665',3709184,'2513','379',228651.77,229395.30,743.53,122682.45,0.00,0.00,0.00,0.00,0.00),('1','161','863','189665',3709185,'2514','380',126939.97,127230.37,290.40,75504.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','189665',3709186,'2515','380',93749.11,94264.40,515.29,133975.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709893,'2496','379',162725.46,163076.68,351.22,57951.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709894,'2497','379',231281.81,232214.57,932.76,153905.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709895,'2498','379',328601.59,330125.15,1523.56,251387.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709896,'2499','379',346975.10,348323.12,1348.02,222423.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709897,'2500','379',328455.09,329614.84,1159.75,191358.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709898,'2501','379',161278.76,161421.01,142.25,23471.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709899,'2502','379',173298.25,174127.65,829.40,136851.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709900,'2503','379',105408.75,105408.78,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709901,'2504','379',139339.87,139663.56,323.69,53408.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','189712',3709902,'2505','379',270961.49,272012.00,1050.51,173334.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709903,'2506','379',416475.93,417906.04,1430.11,235968.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709904,'2507','379',407740.67,409332.14,1591.47,262592.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709905,'2508','379',327178.40,327739.80,561.40,92631.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709906,'2509','379',287957.76,289359.65,1401.89,231311.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709907,'2510','379',315079.70,316157.31,1077.61,177805.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709908,'2511','379',268303.20,269312.23,1009.03,166489.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709909,'2512','379',181504.72,181790.80,286.08,47203.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','189712',3709910,'2513','379',229395.30,230022.77,627.47,103532.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','189712',3709911,'2514','380',127230.37,127280.37,50.00,13000.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','189712',3709912,'2515','380',94264.40,94421.33,156.93,40801.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712310,'2496','379',163076.68,163326.06,249.38,41147.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712311,'2497','379',232214.57,233738.97,1524.40,251526.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712312,'2498','379',330125.15,331548.37,1423.22,234831.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712313,'2499','379',348323.12,349972.32,1649.20,272118.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712314,'2500','379',329614.84,331308.42,1693.58,279440.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712315,'2501','379',161421.01,162006.13,585.12,96544.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712316,'2502','379',174127.65,175148.88,1021.23,168502.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712317,'2503','379',105408.78,107185.97,1777.19,293236.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712318,'2504','379',139663.56,141410.17,1746.61,288190.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','189843',3712319,'2505','379',272012.00,273366.52,1354.52,223495.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712320,'2506','379',417906.04,420020.55,2114.51,348894.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712321,'2507','379',409332.14,411061.72,1729.58,285380.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712322,'2508','379',327739.80,329273.68,1533.88,253090.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712323,'2509','379',289359.65,291195.39,1835.74,302897.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712324,'2510','379',316157.31,319119.52,2962.21,488764.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712325,'2511','379',269312.23,271429.93,2117.70,349420.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712326,'2512','379',181790.80,181790.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','189843',3712327,'2513','379',230022.77,230407.09,384.32,63412.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','189843',3712328,'2514','380',127280.37,128249.40,969.03,251947.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','189843',3712329,'2515','380',94421.33,94421.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','189899',3713165,'2496','379',163326.06,163376.06,0.00,0.00,0.00,0.00,50.00,0.00,0.00),('1','161','861','189899',3713166,'2497','379',233738.97,234745.33,966.36,159449.40,0.00,0.00,40.00,0.00,0.00),('1','161','861','189899',3713167,'2498','379',331548.37,332278.41,700.04,115506.60,0.00,0.00,30.00,0.00,0.00),('1','161','861','189899',3713168,'2499','379',349972.32,351516.35,1524.03,251464.95,0.00,0.00,20.00,0.00,0.00),('1','161','861','189899',3713169,'2500','379',331308.42,332692.72,1354.30,223459.50,0.00,0.00,30.00,0.00,0.00),('1','161','861','189899',3713170,'2501','379',162006.13,162026.13,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','161','861','189899',3713171,'2502','379',175148.88,176027.06,848.18,139949.70,0.00,0.00,30.00,0.00,0.00),('1','161','861','189899',3713172,'2503','379',107185.97,107511.81,305.84,50463.60,0.00,0.00,20.00,0.00,0.00),('1','161','861','189899',3713173,'2504','379',141410.17,141708.16,267.99,44218.35,0.00,0.00,30.00,0.00,0.00),('1','161','861','189899',3713174,'2505','379',273366.52,274717.08,1330.56,219542.40,0.00,0.00,20.00,0.00,0.00),('1','161','862','189899',3713175,'2506','379',420020.55,421764.79,1724.24,284499.60,0.00,0.00,20.00,0.00,0.00),('1','161','862','189899',3713176,'2507','379',411061.72,412429.80,1338.08,220783.20,0.00,0.00,30.00,0.00,0.00),('1','161','862','189899',3713177,'2508','379',329273.68,330410.63,1106.95,182646.75,0.00,0.00,30.00,0.00,0.00),('1','161','862','189899',3713178,'2509','379',291195.39,292258.53,1043.14,172118.10,0.00,0.00,20.00,0.00,0.00),('1','161','862','189899',3713179,'2510','379',319119.52,319169.52,0.00,0.00,0.00,0.00,50.00,0.00,0.00),('1','161','862','189899',3713180,'2511','379',271429.93,272665.25,1215.32,200527.80,0.00,0.00,20.00,0.00,0.00),('1','161','862','189899',3713181,'2512','379',181790.80,181869.37,48.57,8014.05,0.00,0.00,30.00,0.00,0.00),('1','161','862','189899',3713182,'2513','379',230407.09,231175.40,738.31,121821.15,0.00,0.00,30.00,0.00,0.00),('1','161','863','189899',3713183,'2514','380',128249.40,128319.40,40.00,10400.00,0.00,0.00,30.00,0.00,0.00),('1','161','863','189899',3713184,'2515','380',94421.33,94609.41,168.08,43700.80,0.00,0.00,20.00,0.00,0.00),('1','161','861','190125',3718026,'2496','379',163376.06,164122.46,746.40,123156.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718027,'2497','379',234745.33,236121.39,1376.06,227049.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718028,'2498','379',332278.41,333643.26,1364.85,225200.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718029,'2499','379',351516.35,353097.29,1580.94,260855.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718030,'2500','379',332692.72,333664.51,971.79,160345.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718031,'2501','379',162026.13,162497.21,471.08,77728.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718032,'2502','379',176027.06,176512.90,485.84,80163.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718033,'2503','379',107511.81,107511.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718034,'2504','379',141708.16,141708.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190125',3718035,'2505','379',274717.08,275501.89,784.81,129493.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718036,'2506','379',421764.79,423208.97,1444.18,238289.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718037,'2507','379',412429.80,414537.36,2107.56,347747.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718038,'2508','379',330410.63,331674.03,1263.40,208461.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718039,'2509','379',292258.53,293448.21,1189.68,196297.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718040,'2510','379',319169.52,320381.68,1212.16,200006.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718041,'2511','379',272665.25,273831.79,1166.54,192479.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718042,'2512','379',181869.37,182428.73,559.36,92294.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190125',3718043,'2513','379',231175.40,231929.43,754.03,124414.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','190125',3718044,'2514','380',128319.40,128572.55,253.15,65819.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190125',3718045,'2515','380',94609.41,94609.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721238,'2496','379',164122.46,164122.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721239,'2497','379',236121.39,237097.48,976.09,161054.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721240,'2498','379',333643.26,334037.34,394.08,65023.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721241,'2499','379',353097.29,354806.67,1709.38,282047.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721242,'2500','379',333664.51,334513.06,848.55,140010.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721243,'2501','379',162497.21,163127.21,630.00,103950.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721244,'2502','379',176512.90,176512.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721245,'2503','379',107511.81,107511.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721246,'2504','379',141708.16,141920.25,212.09,34994.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','190307',3721247,'2505','379',275501.89,276277.53,775.64,127980.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721248,'2506','379',423208.97,424384.28,1175.31,193926.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721249,'2507','379',414537.36,415647.08,1109.72,183103.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721250,'2508','379',331674.03,332599.89,925.86,152766.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721251,'2509','379',293448.21,294037.89,589.68,97297.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721252,'2510','379',320381.68,320876.86,495.18,81704.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721253,'2511','379',273831.79,274814.15,982.36,162089.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721254,'2512','379',182428.73,182608.93,180.20,29733.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190307',3721255,'2513','379',231929.43,232428.53,499.10,82351.50,0.00,0.00,0.00,0.00,0.00),('1','161','863','190307',3721256,'2514','380',128572.55,128572.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190307',3721257,'2515','380',94609.41,94793.26,183.85,47801.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722035,'2496','379',164122.46,165008.45,885.99,146188.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722036,'2497','379',237097.48,237728.76,631.28,104161.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722037,'2498','379',334037.34,335399.58,1362.24,224769.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722038,'2499','379',354806.67,355866.15,1059.48,174814.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722039,'2500','379',334513.06,335398.49,885.43,146095.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722040,'2501','379',163127.21,163242.81,115.60,19074.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722041,'2502','379',176512.90,177523.32,1010.42,166719.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722042,'2503','379',107511.81,113083.27,5571.46,919290.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722043,'2504','379',141920.25,147821.00,5900.75,973623.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','190343',3722044,'2505','379',276277.53,277546.89,1269.36,209444.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722045,'2506','379',424384.28,425325.44,941.16,155291.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722046,'2507','379',415647.08,416905.42,1258.34,207626.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722047,'2508','379',332599.89,333535.66,935.77,154402.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722048,'2509','379',294037.89,295022.35,984.46,162435.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722049,'2510','379',320876.86,321795.16,918.30,151519.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722050,'2511','379',274814.15,275791.22,977.07,161216.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722051,'2512','379',182608.93,183285.28,676.35,111597.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','190343',3722052,'2513','379',232428.53,233031.51,602.98,99491.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','190343',3722053,'2514','380',128572.55,128572.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190343',3722054,'2515','380',94793.26,94932.92,139.66,36311.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725192,'2496','379',165008.45,165960.94,952.49,156208.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725193,'2497','379',237728.76,238641.47,912.71,149684.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725194,'2498','379',335399.58,336505.37,1105.79,181349.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725195,'2499','379',355866.15,356999.85,1133.70,185926.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725196,'2500','379',335398.49,336363.81,965.32,158312.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725197,'2501','379',163242.81,163827.36,584.55,95866.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725198,'2502','379',177523.32,178307.33,784.01,128577.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725199,'2503','379',113083.27,113560.15,476.88,78208.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725200,'2504','379',147821.00,148420.50,599.50,98318.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190522',3725201,'2505','379',277546.89,278604.09,1057.20,173380.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725202,'2506','379',425325.44,425325.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725203,'2507','379',416905.42,416905.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725204,'2508','379',333535.66,333535.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725205,'2509','379',295022.35,295022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725206,'2510','379',321795.16,321795.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725207,'2511','379',275791.22,275791.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725208,'2512','379',183285.28,183285.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190522',3725209,'2513','379',233031.51,233031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190522',3725210,'2514','380',128572.55,129500.94,928.39,241381.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','190522',3725211,'2515','380',94932.92,94932.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725212,'2496','379',165960.94,166327.43,366.49,60104.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725213,'2497','379',238641.47,239078.86,437.39,71731.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725214,'2498','379',336505.37,337019.52,514.15,84320.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725215,'2499','379',356999.85,357572.99,573.14,93994.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725216,'2500','379',336363.81,336743.55,379.74,62277.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725217,'2501','379',163827.36,164292.38,465.02,76263.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725218,'2502','379',178307.33,178699.11,391.78,64251.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725219,'2503','379',113560.15,113620.96,60.81,9972.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725220,'2504','379',148420.50,148860.19,439.69,72109.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','190523',3725221,'2505','379',278604.09,278958.06,353.97,58051.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725222,'2506','379',425325.44,425325.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725223,'2507','379',416905.42,416905.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725224,'2508','379',333535.66,333535.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725225,'2509','379',295022.35,295022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725226,'2510','379',321795.16,321795.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725227,'2511','379',275791.22,275791.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725228,'2512','379',183285.28,183285.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190523',3725229,'2513','379',233031.51,233031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190523',3725230,'2514','380',129500.94,129500.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190523',3725231,'2515','380',94932.92,94932.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725587,'2496','379',166327.43,167158.06,830.63,137053.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725588,'2497','379',239078.86,240165.78,1086.92,179341.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725589,'2498','379',337019.52,338114.16,1094.64,180615.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725590,'2499','379',357572.99,358457.95,884.96,146018.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725591,'2500','379',336743.55,337853.58,1110.03,183154.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725592,'2501','379',164292.38,165624.35,1331.97,219775.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725593,'2502','379',178699.11,179608.23,909.12,150004.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725594,'2503','379',113620.96,114162.74,541.78,89393.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725595,'2504','379',148860.19,149516.36,656.17,108268.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','190541',3725596,'2505','379',278958.06,280073.42,1115.36,184034.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725597,'2506','379',425325.44,425325.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725598,'2507','379',416905.42,416905.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725599,'2508','379',333535.66,333535.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725600,'2509','379',295022.35,295022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725601,'2510','379',321795.16,321795.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725602,'2511','379',275791.22,275791.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725603,'2512','379',183285.28,183285.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190541',3725604,'2513','379',233031.51,233031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190541',3725605,'2514','380',129500.94,130658.00,1157.06,300835.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','190541',3725606,'2515','380',94932.92,94932.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729479,'2496','379',167158.06,168976.59,1818.53,300057.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729480,'2497','379',240165.78,241802.82,1637.04,270111.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729481,'2498','379',338114.16,340591.56,2477.40,408771.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729482,'2499','379',358457.95,360985.15,2527.20,416988.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729483,'2500','379',337853.58,339730.07,1876.49,309620.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729484,'2501','379',165624.35,166911.89,1287.54,212444.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729485,'2502','379',179608.23,181070.68,1462.45,241304.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729486,'2503','379',114162.74,115515.09,1352.35,223137.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729487,'2504','379',149516.36,150878.22,1361.86,224706.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','190741',3729488,'2505','379',280073.42,281649.73,1576.31,260091.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729489,'2506','379',425325.44,425325.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729490,'2507','379',416905.42,416905.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729491,'2508','379',333535.66,333535.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729492,'2509','379',295022.35,295022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729493,'2510','379',321795.16,321795.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729494,'2511','379',275791.22,275791.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729495,'2512','379',183285.28,183285.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','190741',3729496,'2513','379',233031.51,233031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190741',3729497,'2514','380',130658.00,130658.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','190741',3729498,'2515','380',94932.92,94932.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738779,'2496','379',168976.59,168976.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738780,'2497','379',241802.82,242249.43,446.61,73690.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738781,'2498','379',340591.56,341493.04,901.48,148744.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738782,'2499','379',360985.15,361634.71,649.56,107177.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738783,'2500','379',339730.07,340461.12,731.05,120623.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738784,'2501','379',166911.89,167485.67,573.78,94673.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738785,'2502','379',181070.68,181070.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738786,'2503','379',115515.09,115515.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738787,'2504','379',150878.22,151196.74,318.52,52555.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','191258',3738788,'2505','379',281649.73,282255.84,606.11,100008.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738789,'2506','379',425325.44,426326.87,1001.43,165235.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738790,'2507','379',416905.42,418064.75,1159.33,191289.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738791,'2508','379',333535.66,334333.92,798.26,131712.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738792,'2509','379',295022.35,295727.78,705.43,116395.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738793,'2510','379',321795.16,322427.78,632.62,104382.30,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738794,'2511','379',275791.22,276237.89,446.67,73700.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738795,'2512','379',183285.28,183737.33,452.05,74588.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','191258',3738796,'2513','379',233031.51,233421.36,389.85,64325.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','191258',3738797,'2514','380',130658.00,133600.26,2942.26,764987.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','191258',3738798,'2515','380',94932.92,96568.70,1635.78,425302.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740526,'2496','379',168976.59,168976.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740527,'2497','379',242249.43,242896.76,647.33,106809.45,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740528,'2498','379',341493.04,342739.71,1246.67,205700.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740529,'2499','379',361634.71,362531.48,896.77,147967.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740530,'2500','379',340461.12,341529.95,1068.83,176356.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740531,'2501','379',167485.67,167829.59,343.92,56746.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740532,'2502','379',181070.68,181655.47,584.79,96490.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740533,'2503','379',115515.09,115515.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740534,'2504','379',151196.74,151440.93,244.19,40291.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','191371',3740535,'2505','379',282255.84,283620.33,1364.49,225140.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740536,'2506','379',426326.87,427760.12,1433.25,236486.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740537,'2507','379',418064.75,419306.47,1241.72,204883.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740538,'2508','379',334333.92,335587.79,1253.87,206888.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740539,'2509','379',295727.78,296590.38,862.60,142329.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740540,'2510','379',322427.78,323719.23,1291.45,213089.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740541,'2511','379',276237.89,276945.61,707.72,116773.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740542,'2512','379',183737.33,184110.61,373.28,61591.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','191371',3740543,'2513','379',233421.36,233689.74,268.38,44282.70,0.00,0.00,0.00,0.00,0.00),('1','161','863','191371',3740544,'2514','380',133600.26,133909.11,308.85,80301.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','191371',3740545,'2515','380',96568.70,98694.64,2125.94,552744.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741526,'2496','379',168976.59,168976.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741527,'2497','379',242896.76,243708.85,812.09,133994.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741528,'2498','379',342739.71,344494.56,1754.85,289550.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741529,'2499','379',362531.48,363883.16,1351.68,223027.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741530,'2500','379',341529.95,343213.82,1683.87,277838.55,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741531,'2501','379',167829.59,168123.15,293.56,48437.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741532,'2502','379',181655.47,182377.53,722.06,119139.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741533,'2503','379',115515.09,116686.55,1171.46,193290.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741534,'2504','379',151440.93,151440.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191421',3741535,'2505','379',283620.33,285159.17,1538.84,253908.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741536,'2506','379',427760.12,429701.59,1941.47,320342.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741537,'2507','379',419306.47,421346.14,2039.67,336545.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741538,'2508','379',335587.79,336759.87,1172.08,193393.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741539,'2509','379',296590.38,298114.48,1524.10,251476.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741540,'2510','379',323719.23,324502.96,783.73,129315.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741541,'2511','379',276945.61,278224.44,1278.83,211006.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741542,'2512','379',184110.61,185225.02,1114.41,183877.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','191421',3741543,'2513','379',233689.74,233689.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','191421',3741544,'2514','380',133909.11,134536.03,626.92,162999.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','191421',3741545,'2515','380',98694.64,98982.91,288.27,74950.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742750,'2496','379',168976.59,169443.75,467.16,77081.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742751,'2497','379',243708.85,243708.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742752,'2498','379',344494.56,345924.07,1409.51,232569.15,0.00,0.00,20.00,0.00,0.00),('1','161','861','191479',3742753,'2499','379',363883.16,364949.56,1066.40,175956.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742754,'2500','379',343213.82,344664.87,1451.05,239423.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742755,'2501','379',168123.15,168444.60,321.45,53039.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742756,'2502','379',182377.53,182846.47,468.94,77375.10,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742757,'2503','379',116686.55,116686.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742758,'2504','379',151440.93,151816.11,375.18,61904.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','191479',3742759,'2505','379',285159.17,286091.47,932.30,153829.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742760,'2506','379',429701.59,431005.38,1303.79,215125.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742761,'2507','379',421346.14,422329.26,983.12,162214.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742762,'2508','379',336759.87,337478.25,718.38,118532.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742763,'2509','379',298114.48,298844.16,729.68,120397.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742764,'2510','379',324502.96,325438.31,935.35,154332.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742765,'2511','379',278224.44,278628.07,403.63,66598.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742766,'2512','379',185225.02,185534.69,309.67,51095.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','191479',3742767,'2513','379',233689.74,233979.99,290.25,47891.25,0.00,0.00,0.00,0.00,0.00),('1','161','863','191479',3742768,'2514','380',134536.03,135053.86,517.83,134635.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','191479',3742769,'2515','380',98982.91,98992.91,10.00,2600.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744616,'2496','379',169443.75,169902.81,459.06,75744.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744617,'2497','379',243708.85,244531.90,823.05,135803.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744618,'2498','379',345924.07,347009.38,1085.31,179076.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744619,'2499','379',364949.56,366457.55,1507.99,248818.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744620,'2500','379',344664.87,346286.28,1621.41,267532.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744621,'2501','379',168444.60,169179.29,734.69,121223.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744622,'2502','379',182846.47,182922.76,76.29,12587.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744623,'2503','379',116686.55,117339.54,652.99,107743.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744624,'2504','379',151816.11,151816.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191590',3744625,'2505','379',286091.47,286976.27,884.80,145992.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744626,'2506','379',431005.38,432688.72,1683.34,277751.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744627,'2507','379',422329.26,424657.37,2328.11,384138.15,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744628,'2508','379',337478.25,338815.18,1336.93,220593.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744629,'2509','379',298844.16,300320.30,1476.14,243563.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744630,'2510','379',325438.31,326797.52,1359.21,224269.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744631,'2511','379',278628.07,279689.02,1060.95,175056.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744632,'2512','379',185534.69,186163.33,628.64,103725.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','191590',3744633,'2513','379',233979.99,234610.31,630.32,104002.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','191590',3744634,'2514','380',135053.86,135463.86,410.00,106600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','191590',3744635,'2515','380',98992.91,99425.68,432.77,112520.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','191685',3746825,'2496','379',169902.81,170783.04,860.23,141937.95,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746826,'2497','379',244531.90,244531.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191685',3746827,'2498','379',347009.38,348225.34,1195.96,197333.40,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746828,'2499','379',366457.55,367461.46,983.91,162345.15,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746829,'2500','379',346286.28,347745.77,1439.49,237515.85,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746830,'2501','379',169179.29,169179.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191685',3746831,'2502','379',182922.76,183362.26,419.50,69217.50,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746832,'2503','379',117339.54,117339.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191685',3746833,'2504','379',151816.11,152669.64,833.53,137532.45,0.00,0.00,20.00,0.00,0.00),('1','161','861','191685',3746834,'2505','379',286976.27,287795.51,799.24,131874.60,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746835,'2506','379',432688.72,433632.72,924.00,152460.00,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746836,'2507','379',424657.37,425914.73,1237.36,204164.40,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746837,'2508','379',338815.18,339617.53,782.35,129087.75,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746838,'2509','379',300320.30,301462.15,1121.85,185105.25,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746839,'2510','379',326797.52,327568.79,751.27,123959.55,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746840,'2511','379',279689.02,280503.79,794.77,131137.05,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746841,'2512','379',186163.33,186321.90,138.57,22864.05,0.00,0.00,20.00,0.00,0.00),('1','161','862','191685',3746842,'2513','379',234610.31,235014.44,384.13,63381.45,0.00,0.00,20.00,0.00,0.00),('1','161','863','191685',3746843,'2514','380',135463.86,135711.81,247.95,64467.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','191685',3746844,'2515','380',99425.68,99465.68,40.00,10400.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748680,'2496','379',170783.04,170783.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748681,'2497','379',244531.90,245420.53,888.63,146623.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748682,'2498','379',348225.34,349830.30,1604.96,264818.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748683,'2499','379',367461.46,368793.74,1332.28,219826.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748684,'2500','379',347745.77,348768.60,1022.83,168766.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748685,'2501','379',169179.29,169179.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748686,'2502','379',183362.26,183864.44,502.18,82859.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748687,'2503','379',117339.54,117339.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748688,'2504','379',152669.64,152809.99,140.35,23157.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','191792',3748689,'2505','379',287795.51,289374.35,1578.84,260508.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748690,'2506','379',433632.72,435231.01,1598.29,263717.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748691,'2507','379',425914.73,427713.65,1798.92,296821.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748692,'2508','379',339617.53,340527.98,910.45,150224.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748693,'2509','379',301462.15,302664.55,1202.40,198396.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748694,'2510','379',327568.79,328424.82,856.03,141244.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748695,'2511','379',280503.79,281290.63,786.84,129828.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748696,'2512','379',186321.90,186321.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','191792',3748697,'2513','379',235014.44,235738.44,724.00,119460.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','191792',3748698,'2514','380',135711.81,135902.37,190.56,49545.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','191792',3748699,'2515','380',99465.68,99465.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748840,'2496','379',170783.04,171643.18,860.14,140202.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748841,'2497','379',245420.53,245420.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748842,'2498','379',349830.30,350855.32,1025.02,167078.26,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748843,'2499','379',368793.74,369941.70,1147.96,187117.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748844,'2500','379',348768.60,350113.76,1345.16,219261.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748845,'2501','379',169179.29,169881.15,701.86,114403.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748846,'2502','379',183864.44,183864.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748847,'2503','379',117339.54,117339.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748848,'2504','379',152809.99,153251.54,441.55,71972.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','191800',3748849,'2505','379',289374.35,290338.73,964.38,157193.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748850,'2506','379',435231.01,436786.38,1555.37,253525.31,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748851,'2507','379',427713.65,428659.67,946.02,154201.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748852,'2508','379',340527.98,341511.81,983.83,160364.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748853,'2509','379',302664.55,303238.53,573.98,93558.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748854,'2510','379',328424.82,329203.17,778.35,126871.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748855,'2511','379',281290.63,282137.35,846.72,138015.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748856,'2512','379',186321.90,186321.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','191800',3748857,'2513','379',235738.44,236564.15,825.71,134590.73,0.00,0.00,0.00,0.00,0.00),('1','161','863','191800',3748858,'2514','380',135902.37,135980.45,78.08,20300.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','191800',3748859,'2515','380',99465.68,99465.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751310,'2496','379',171643.18,172433.15,789.97,128765.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751311,'2497','379',245420.53,245909.64,489.11,79724.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751312,'2498','379',350855.32,352204.18,1348.86,219864.18,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751313,'2499','379',369941.70,371401.17,1459.47,237893.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751314,'2500','379',350113.76,351277.60,1163.84,189705.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751315,'2501','379',169881.15,170276.24,395.09,64399.67,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751316,'2502','379',183864.44,184588.13,723.69,117961.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751317,'2503','379',117339.54,117552.02,212.48,34634.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751318,'2504','379',153251.54,153436.10,184.56,30083.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','191916',3751319,'2505','379',290338.73,291357.45,1018.72,166051.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751320,'2506','379',436786.38,438484.80,1698.42,276842.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751321,'2507','379',428659.67,429815.48,1155.81,188397.03,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751322,'2508','379',341511.81,343170.96,1659.15,270441.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751323,'2509','379',303238.53,304765.51,1526.98,248897.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751324,'2510','379',329203.17,330666.11,1462.94,238459.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751325,'2511','379',282137.35,282920.37,783.02,127632.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751326,'2512','379',186321.90,187777.43,1455.53,237251.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','191916',3751327,'2513','379',236564.15,237230.74,666.59,108654.17,0.00,0.00,0.00,0.00,0.00),('1','161','863','191916',3751328,'2514','380',135980.45,137006.58,1026.13,266793.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','191916',3751329,'2515','380',99465.68,99465.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753197,'2496','379',172433.15,173958.62,1525.47,248651.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753198,'2497','379',245909.64,245909.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753199,'2498','379',352204.18,353628.39,1424.21,232146.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753200,'2499','379',371401.17,373104.81,1703.64,277693.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753201,'2500','379',351277.60,352794.07,1516.47,247184.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753202,'2501','379',170276.24,170276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753203,'2502','379',184588.13,185445.34,857.21,139725.23,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753204,'2503','379',117552.02,118428.15,876.13,142809.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753205,'2504','379',153436.10,155256.37,1820.27,296704.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','192037',3753206,'2505','379',291357.45,292715.37,1357.92,221340.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753207,'2506','379',438484.80,439782.18,1297.38,211472.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753208,'2507','379',429815.48,431467.25,1651.77,269238.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753209,'2508','379',343170.96,344631.94,1460.98,238139.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753210,'2509','379',304765.51,305937.77,1172.26,191078.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753211,'2510','379',330666.11,331996.28,1330.17,216817.71,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753212,'2511','379',282920.37,284280.95,1360.58,221774.54,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753213,'2512','379',187777.43,187814.51,37.08,6044.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','192037',3753214,'2513','379',237230.74,238621.25,1390.51,226653.13,0.00,0.00,0.00,0.00,0.00),('1','161','863','192037',3753215,'2514','380',137006.58,137131.99,125.41,32606.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','192037',3753216,'2515','380',99465.68,99525.68,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754304,'2496','379',173958.62,173958.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754305,'2497','379',245909.64,246057.42,147.78,24088.14,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754306,'2498','379',353628.39,355588.70,1960.31,319530.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754307,'2499','379',373104.81,375185.45,2080.64,339144.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754308,'2500','379',352794.07,354283.94,1489.87,242848.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754309,'2501','379',170276.24,171660.58,1384.34,225647.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754310,'2502','379',185445.34,185445.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754311,'2503','379',118428.15,121309.55,2881.40,469668.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754312,'2504','379',155256.37,158851.28,3594.91,585970.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','192093',3754313,'2505','379',292715.37,294301.08,1585.71,258470.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754314,'2506','379',439782.18,441645.72,1863.54,303757.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754315,'2507','379',431467.25,433478.32,2011.07,327804.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754316,'2508','379',344631.94,346431.40,1799.46,293311.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754317,'2509','379',305937.77,307220.61,1282.84,209102.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754318,'2510','379',331996.28,333504.16,1507.88,245784.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754319,'2511','379',284280.95,286153.10,1872.15,305160.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754320,'2512','379',187814.51,189352.28,1537.77,250656.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','192093',3754321,'2513','379',238621.25,238621.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192093',3754322,'2514','380',137131.99,137278.54,146.55,38103.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192093',3754323,'2515','380',99525.68,99525.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192292',3758173,'2496','379',173958.62,174779.19,810.57,132122.91,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758174,'2497','379',246057.42,246067.42,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758175,'2498','379',355588.70,357061.35,1442.65,235151.95,0.00,0.00,30.00,0.00,0.00),('1','161','861','192292',3758176,'2499','379',375185.45,376945.47,1750.02,285253.26,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758177,'2500','379',354283.94,355433.05,1139.11,185674.93,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758178,'2501','379',171660.58,172145.94,475.36,77483.68,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758179,'2502','379',185445.34,185814.54,359.20,58549.60,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758180,'2503','379',121309.55,121347.78,28.23,4601.49,0.00,0.00,10.00,0.00,0.00),('1','161','861','192292',3758181,'2504','379',158851.28,159157.23,285.95,46609.85,0.00,0.00,20.00,0.00,0.00),('1','161','861','192292',3758182,'2505','379',294301.08,295253.16,932.08,151929.04,0.00,0.00,20.00,0.00,0.00),('1','161','862','192292',3758183,'2506','379',441645.72,443255.05,1589.33,259060.79,0.00,0.00,20.00,0.00,0.00),('1','161','862','192292',3758184,'2507','379',433478.32,435182.76,1694.44,276193.72,0.00,0.00,10.00,0.00,0.00),('1','161','862','192292',3758185,'2508','379',346431.40,347640.38,1188.98,193803.74,0.00,0.00,20.00,0.00,0.00),('1','161','862','192292',3758186,'2509','379',307220.61,308122.97,892.36,145454.68,0.00,0.00,10.00,0.00,0.00),('1','161','862','192292',3758187,'2510','379',333504.16,334291.44,777.28,126696.64,0.00,0.00,10.00,0.00,0.00),('1','161','862','192292',3758188,'2511','379',286153.10,286966.17,793.07,129270.41,0.00,0.00,20.00,0.00,0.00),('1','161','862','192292',3758189,'2512','379',189352.28,189943.23,580.95,94694.85,0.00,0.00,10.00,0.00,0.00),('1','161','862','192292',3758190,'2513','379',238621.25,239431.54,800.29,130447.27,0.00,0.00,10.00,0.00,0.00),('1','161','863','192292',3758191,'2514','380',137278.54,137535.11,246.57,64108.20,0.00,0.00,10.00,0.00,0.00),('1','161','863','192292',3758192,'2515','380',99525.68,99801.45,255.77,66500.20,0.00,0.00,20.00,0.00,0.00),('1','161','861','192425',3760068,'2496','379',174779.19,174822.15,42.96,7002.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760069,'2497','379',246067.42,247132.74,1065.32,173647.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760070,'2498','379',357061.35,358679.25,1617.90,263717.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760071,'2499','379',376945.47,378123.38,1177.91,191999.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760072,'2500','379',355433.05,356729.88,1296.83,211383.29,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760073,'2501','379',172145.94,172960.82,814.88,132825.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760074,'2502','379',185814.54,185903.19,88.65,14449.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760075,'2503','379',121347.78,121897.76,549.98,89646.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760076,'2504','379',159157.23,159219.21,61.98,10102.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','192425',3760077,'2505','379',295253.16,296609.09,1355.93,221016.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760078,'2506','379',443255.05,445370.69,2115.64,344849.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760079,'2507','379',435182.76,436810.84,1628.08,265377.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760080,'2508','379',347640.38,348823.63,1183.25,192869.75,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760081,'2509','379',308122.97,309496.80,1373.83,223934.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760082,'2510','379',334291.44,335631.16,1339.72,218374.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760083,'2511','379',286966.17,287862.21,896.04,146054.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760084,'2512','379',189943.23,190899.11,955.88,155808.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','192425',3760085,'2513','379',239431.54,240163.76,732.22,119351.86,0.00,0.00,0.00,0.00,0.00),('1','161','863','192425',3760086,'2514','380',137535.11,137960.11,425.00,110500.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192425',3760087,'2515','380',99801.45,100089.92,288.47,75002.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760961,'2496','379',174822.15,175521.38,678.72,110631.36,0.00,0.00,20.51,0.00,0.00),('1','161','861','192471',3760962,'2497','379',247132.74,247132.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760963,'2498','379',358679.25,360005.50,1326.25,216178.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760964,'2499','379',378123.38,379549.73,1426.35,232495.05,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760965,'2500','379',356729.88,357723.84,993.96,162015.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760966,'2501','379',172960.82,173399.98,439.16,71583.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760967,'2502','379',185903.19,186620.83,717.64,116975.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760968,'2503','379',121897.76,122384.84,487.08,79394.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760969,'2504','379',159219.21,159635.89,416.68,67918.84,0.00,0.00,0.00,0.00,0.00),('1','161','861','192471',3760970,'2505','379',296609.09,297513.74,904.65,147457.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760971,'2506','379',445370.69,446979.70,1588.50,258925.50,0.00,0.00,20.51,0.00,0.00),('1','161','862','192471',3760972,'2507','379',436810.84,438310.04,1499.20,244369.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760973,'2508','379',348823.63,349648.02,824.39,134375.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760974,'2509','379',309496.80,310462.13,965.33,157348.79,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760975,'2510','379',335631.16,336345.51,714.35,116439.05,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760976,'2511','379',287862.21,288508.43,646.22,105333.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760977,'2512','379',190899.11,191357.12,458.01,74655.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','192471',3760978,'2513','379',240163.76,240627.41,463.65,75574.95,0.00,0.00,0.00,0.00,0.00),('1','161','863','192471',3760979,'2514','380',137960.11,138010.11,50.00,13000.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192471',3760980,'2515','380',100089.92,100089.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765757,'2496','379',175521.38,175521.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765758,'2497','379',247132.74,248240.27,1107.53,180527.39,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765759,'2498','379',360005.50,361395.26,1389.76,226530.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765760,'2499','379',379549.73,380782.98,1233.25,201019.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765761,'2500','379',357723.84,358974.90,1251.06,203922.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765762,'2501','379',173399.98,174127.41,727.43,118571.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765763,'2502','379',186620.83,186620.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765764,'2503','379',122384.84,122384.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765765,'2504','379',159635.89,160586.02,950.13,154871.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','192723',3765766,'2505','379',297513.74,299018.36,1504.62,245253.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765767,'2506','379',446979.70,448620.38,1640.68,267430.84,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765768,'2507','379',438310.04,439541.12,1231.08,200666.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765769,'2508','379',349648.02,350312.04,664.02,108235.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765770,'2509','379',310462.13,311571.75,1109.62,180868.06,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765771,'2510','379',336345.51,337295.41,949.90,154833.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765772,'2511','379',288508.43,289289.38,780.95,127294.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765773,'2512','379',191357.12,191865.54,508.42,82872.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','192723',3765774,'2513','379',240627.41,241287.65,660.24,107619.12,0.00,0.00,0.00,0.00,0.00),('1','161','863','192723',3765775,'2514','380',138010.11,138010.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192723',3765776,'2515','380',100089.92,100089.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765798,'2496','379',175521.38,175521.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765799,'2497','379',248240.27,249226.83,986.56,160809.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765800,'2498','379',361395.26,362850.14,1454.88,237145.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765801,'2499','379',380782.98,382262.28,1479.30,241125.90,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765802,'2500','379',358974.90,360046.38,1071.48,174651.24,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765803,'2501','379',174127.41,174841.67,714.26,116424.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765804,'2502','379',186620.83,186620.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765805,'2503','379',122384.84,122384.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765806,'2504','379',160586.02,160965.26,379.24,61816.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','192726',3765807,'2505','379',299018.36,299692.02,673.66,109806.58,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765808,'2506','379',448620.38,450187.54,1567.16,255447.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765809,'2507','379',439541.12,440940.92,1399.80,228167.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765810,'2508','379',350312.04,351213.35,901.31,146913.53,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765811,'2509','379',311571.75,312631.65,1059.90,172763.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765812,'2510','379',337295.41,338288.48,993.07,161870.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765813,'2511','379',289289.38,290020.50,731.12,119172.56,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765814,'2512','379',191865.54,192431.69,566.15,92282.45,0.00,0.00,0.00,0.00,0.00),('1','161','862','192726',3765815,'2513','379',241287.65,242023.20,735.55,119894.65,0.00,0.00,0.00,0.00,0.00),('1','161','863','192726',3765816,'2514','380',138010.11,138070.11,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192726',3765817,'2515','380',100089.92,100363.39,273.47,71102.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768181,'2496','379',175521.38,175986.09,464.71,75747.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768182,'2497','379',249226.83,250155.39,928.56,151355.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768183,'2498','379',362850.14,364062.71,1212.57,197648.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768184,'2499','379',382262.28,383972.25,1709.97,278725.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768185,'2500','379',360046.38,361355.80,1309.42,213435.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768186,'2501','379',174841.67,175019.91,178.24,29053.12,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768187,'2502','379',186620.83,187964.73,1343.90,219055.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768188,'2503','379',122384.84,124017.22,1632.38,266077.94,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768189,'2504','379',160965.26,162150.99,1185.73,193273.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','192860',3768190,'2505','379',299692.02,300547.18,855.16,139391.08,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768191,'2506','379',450187.54,451063.76,876.22,142823.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768192,'2507','379',440940.92,442007.69,1066.77,173883.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768193,'2508','379',351213.35,352060.71,847.36,138119.68,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768194,'2509','379',312631.65,313211.55,579.90,94523.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768195,'2510','379',338288.48,338603.57,315.09,51359.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768196,'2511','379',290020.50,290640.51,620.01,101061.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768197,'2512','379',192431.69,193285.95,854.26,139244.38,0.00,0.00,0.00,0.00,0.00),('1','161','862','192860',3768198,'2513','379',242023.20,242102.08,78.88,12857.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','192860',3768199,'2514','380',138070.11,138593.71,523.60,136136.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','192860',3768200,'2515','380',100363.39,100363.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770927,'2496','379',175986.09,175986.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770928,'2497','379',250155.39,250422.72,267.33,43574.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770929,'2498','379',364062.71,364430.87,368.16,60010.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770930,'2499','379',383972.25,384282.70,310.45,50603.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770931,'2500','379',361355.80,361724.90,369.10,60163.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770932,'2501','379',175019.91,175019.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770933,'2502','379',187964.73,188208.53,243.80,39739.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770934,'2503','379',124017.22,124887.22,870.00,141810.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770935,'2504','379',162150.99,163031.42,880.43,143510.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','193013',3770936,'2505','379',300547.18,300717.17,169.99,27708.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770937,'2506','379',451063.76,451409.37,345.61,56334.43,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770938,'2507','379',442007.69,442333.66,325.97,53133.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770939,'2508','379',352060.71,352326.13,265.42,43263.46,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770940,'2509','379',313211.55,313432.11,220.56,35951.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770941,'2510','379',338603.57,338603.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770942,'2511','379',290640.51,291116.50,475.99,77586.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770943,'2512','379',193285.95,193434.60,148.65,24229.95,0.00,0.00,0.00,0.00,0.00),('1','161','862','193013',3770944,'2513','379',242102.08,242271.25,169.17,27574.71,0.00,0.00,0.00,0.00,0.00),('1','161','863','193013',3770945,'2514','380',138593.71,138593.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193013',3770946,'2515','380',100363.39,100474.16,110.77,28800.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773567,'2496','379',175986.09,175986.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773568,'2497','379',250422.72,251353.71,930.99,151751.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773569,'2498','379',364430.87,365968.71,1517.84,247407.92,0.00,0.00,20.00,0.00,0.00),('1','161','861','193139',3773570,'2499','379',384282.70,385689.58,1406.88,229321.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773571,'2500','379',361724.90,363572.80,1847.90,301207.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773572,'2501','379',175019.91,175941.14,921.23,150160.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773573,'2502','379',188208.53,188208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773574,'2503','379',124887.22,124887.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773575,'2504','379',163031.42,163707.87,676.45,110261.35,0.00,0.00,0.00,0.00,0.00),('1','161','861','193139',3773576,'2505','379',300717.17,300717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773577,'2506','379',451409.37,452920.75,1511.38,246354.94,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773578,'2507','379',442333.66,443769.51,1435.85,234043.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773579,'2508','379',352326.13,353430.21,1104.08,179965.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773580,'2509','379',313432.11,314522.34,1090.23,177707.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773581,'2510','379',338603.57,339558.11,954.54,155590.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773582,'2511','379',291116.50,292984.02,1867.52,304405.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773583,'2512','379',193434.60,193686.29,251.69,41025.47,0.00,0.00,0.00,0.00,0.00),('1','161','862','193139',3773584,'2513','379',242271.25,242866.54,595.29,97032.27,0.00,0.00,0.00,0.00,0.00),('1','161','863','193139',3773585,'2514','380',138593.71,139367.18,773.47,201102.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','193139',3773586,'2515','380',100474.16,100528.74,54.58,14190.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776463,'2496','379',175986.09,177433.78,1447.69,235973.47,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776464,'2497','379',251353.71,252642.46,1288.75,210066.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776465,'2498','379',365968.71,367362.29,1393.58,227153.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776466,'2499','379',385689.58,387202.31,1512.73,246574.99,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776467,'2500','379',363572.80,364573.22,1000.42,163068.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776468,'2501','379',175941.14,176655.85,714.71,116497.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776469,'2502','379',188208.53,189334.34,1125.81,183507.03,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776470,'2503','379',124887.22,126106.35,1219.13,198718.19,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776471,'2504','379',163707.87,164522.62,814.75,132804.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','193305',3776472,'2505','379',300717.17,301825.21,1108.04,180610.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776473,'2506','379',452920.75,452920.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776474,'2507','379',443769.51,443769.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776475,'2508','379',353430.21,353430.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776476,'2509','379',314522.34,314522.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776477,'2510','379',339558.11,340622.99,1064.88,173575.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776478,'2511','379',292984.02,294347.04,1363.02,222172.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776479,'2512','379',193686.29,193686.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193305',3776480,'2513','379',242866.54,242866.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193305',3776481,'2514','380',139367.18,139644.10,276.92,71999.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','193305',3776482,'2515','380',100528.74,100528.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776509,'2496','379',177433.78,177752.33,318.55,51923.65,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776510,'2497','379',252642.46,253610.87,968.41,157850.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776511,'2498','379',367362.29,368475.22,1112.93,181407.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776512,'2499','379',387202.31,388260.62,1058.31,172504.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776513,'2500','379',364573.22,365558.56,985.34,160610.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776514,'2501','379',176655.85,177420.74,764.89,124677.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776515,'2502','379',189334.34,189538.25,203.91,33237.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776516,'2503','379',126106.35,126223.27,116.92,19057.96,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776517,'2504','379',164522.62,164616.18,93.56,15250.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','193307',3776518,'2505','379',301825.21,303028.15,1202.94,196079.22,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776519,'2506','379',452920.75,454503.62,1582.87,258007.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776520,'2507','379',443769.51,445357.25,1587.74,258801.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776521,'2508','379',353430.21,354612.30,1182.09,192680.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776522,'2509','379',314522.34,315635.57,1113.23,181456.49,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776523,'2510','379',340622.99,340885.94,262.95,42860.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776524,'2511','379',294347.04,296370.44,2023.40,329814.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776525,'2512','379',193686.29,193686.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193307',3776526,'2513','379',242866.54,244163.47,1296.93,211399.59,0.00,0.00,0.00,0.00,0.00),('1','161','863','193307',3776527,'2514','380',139644.10,140310.79,666.69,173339.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','193307',3776528,'2515','380',100528.74,100528.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778560,'2496','379',177752.33,177752.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778561,'2497','379',253610.87,254607.98,997.11,162528.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778562,'2498','379',368475.22,370393.09,1917.87,312612.81,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778563,'2499','379',388260.62,389255.08,994.46,162096.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778564,'2500','379',365558.56,366655.07,1096.51,178731.13,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778565,'2501','379',177420.74,177420.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778566,'2502','379',189538.25,190502.20,963.95,157123.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778567,'2503','379',126223.27,127464.02,1240.75,202242.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778568,'2504','379',164616.18,164616.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193386',3778569,'2505','379',303028.15,304409.72,1381.57,225195.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778570,'2506','379',454503.62,456059.89,1556.27,253672.01,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778571,'2507','379',445357.25,446972.89,1615.64,263349.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778572,'2508','379',354612.30,355525.09,912.79,148784.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778573,'2509','379',315635.57,316767.85,1132.28,184561.64,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778574,'2510','379',340885.94,341703.86,817.92,133320.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778575,'2511','379',296370.44,297260.99,890.55,145159.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778576,'2512','379',193686.29,193686.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193386',3778577,'2513','379',244163.47,245559.61,1396.14,227570.82,0.00,0.00,0.00,0.00,0.00),('1','161','863','193386',3778578,'2514','380',140310.79,140310.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193386',3778579,'2515','380',100528.74,100711.43,182.69,47499.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780131,'2496','379',177752.33,177752.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780132,'2497','379',254607.98,255514.29,906.31,147728.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780133,'2498','379',370393.09,371959.05,1565.96,255251.48,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780134,'2499','379',389255.08,390889.06,1633.98,266338.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780135,'2500','379',366655.07,367912.46,1257.39,204954.57,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780136,'2501','379',177420.74,178652.00,1231.26,200695.38,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780137,'2502','379',190502.20,190502.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780138,'2503','379',127464.02,127482.42,18.40,2999.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780139,'2504','379',164616.18,165212.17,595.99,97146.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','193482',3780140,'2505','379',304409.72,305623.92,1214.20,197914.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780141,'2506','379',456059.89,457366.89,1307.00,213041.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780142,'2507','379',446972.89,448829.65,1856.76,302651.88,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780143,'2508','379',355525.09,356708.41,1183.32,192881.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780144,'2509','379',316767.85,317735.55,967.70,157735.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780145,'2510','379',341703.86,342582.81,878.95,143268.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780146,'2511','379',297260.99,297995.39,734.40,119707.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780147,'2512','379',193686.29,194438.70,752.41,122642.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','193482',3780148,'2513','379',245559.61,245559.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193482',3780149,'2514','380',140310.79,140598.76,287.97,74872.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','193482',3780150,'2515','380',100711.43,100927.04,215.61,56058.60,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782641,'2496','379',177752.33,178578.05,825.72,134592.36,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782642,'2497','379',255514.29,256664.06,1149.77,187412.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782643,'2498','379',371959.05,373424.23,1465.18,238824.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782644,'2499','379',390889.06,392931.63,2042.57,332938.91,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782645,'2500','379',367912.46,369137.89,1225.43,199745.09,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782646,'2501','379',178652.00,179437.97,785.97,128113.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782647,'2502','379',190502.20,191669.30,1167.10,190237.30,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782648,'2503','379',127482.42,127754.47,272.05,44344.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782649,'2504','379',165212.17,165868.94,656.77,107053.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','193607',3782650,'2505','379',305623.92,306980.33,1356.41,221094.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782651,'2506','379',457366.89,457855.87,488.98,79703.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782652,'2507','379',448829.65,449624.39,794.74,129542.62,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782653,'2508','379',356708.41,357119.73,411.32,67045.16,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782654,'2509','379',317735.55,318156.12,420.57,68552.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782655,'2510','379',342582.81,342753.31,170.50,27791.50,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782656,'2511','379',297995.39,298270.57,275.18,44854.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782657,'2512','379',194438.70,194499.91,61.21,9977.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','193607',3782658,'2513','379',245559.61,245670.88,111.27,18137.01,0.00,0.00,0.00,0.00,0.00),('1','161','863','193607',3782659,'2514','380',140598.76,141253.38,654.62,170201.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','193607',3782660,'2515','380',100927.04,101238.56,311.52,80995.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783561,'2496','379',178578.05,179961.39,1383.34,225484.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783562,'2497','379',256664.06,257243.03,578.97,94372.11,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783563,'2498','379',373424.23,374502.35,1078.12,175733.56,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783564,'2499','379',392931.63,394685.96,1754.33,285955.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783565,'2500','379',369137.89,369823.94,686.05,111826.15,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783566,'2501','379',179437.97,179816.91,378.94,61767.22,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783567,'2502','379',191669.30,192766.63,1097.33,178864.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783568,'2503','379',127754.47,128468.23,713.76,116342.88,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783569,'2504','379',165868.94,166178.58,309.64,50471.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','193676',3783570,'2505','379',306980.33,308177.21,1196.88,195091.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783571,'2506','379',457855.87,459636.47,1780.60,290237.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783572,'2507','379',449624.39,450816.79,1192.40,194361.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783573,'2508','379',357119.73,358311.91,1192.18,194325.34,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783574,'2509','379',318156.12,319322.52,1166.40,190123.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783575,'2510','379',342753.31,343941.70,1188.39,193707.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783576,'2511','379',298270.57,298842.36,571.79,93201.77,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783577,'2512','379',194499.91,195179.66,679.75,110799.25,0.00,0.00,0.00,0.00,0.00),('1','161','862','193676',3783578,'2513','379',245670.88,246487.73,816.85,133146.55,0.00,0.00,0.00,0.00,0.00),('1','161','863','193676',3783579,'2514','380',141253.38,142704.95,1451.57,377408.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','193676',3783580,'2515','380',101238.56,101838.81,600.25,156065.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193830',3786636,'2496','379',179961.39,179995.11,23.72,3866.36,0.00,0.00,10.00,0.00,0.00),('1','161','861','193830',3786637,'2497','379',257243.03,257849.64,576.61,93987.43,0.00,0.00,30.00,0.00,0.00),('1','161','861','193830',3786638,'2498','379',374502.35,375745.27,1222.92,199335.96,0.00,0.00,20.00,0.00,0.00),('1','161','861','193830',3786639,'2499','379',394685.96,396057.83,1351.87,220354.81,0.00,0.00,20.00,0.00,0.00),('1','161','861','193830',3786640,'2500','379',369823.94,370666.10,822.16,134012.08,0.00,0.00,20.00,0.00,0.00),('1','161','861','193830',3786641,'2501','379',179816.91,179816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193830',3786642,'2502','379',192766.63,194232.73,1446.10,235714.30,0.00,0.00,20.00,0.00,0.00),('1','161','861','193830',3786643,'2503','379',128468.23,128468.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193830',3786644,'2504','379',166178.58,166358.34,169.76,27670.88,0.00,0.00,10.00,0.00,0.00),('1','161','861','193830',3786645,'2505','379',308177.21,308980.36,773.15,126023.45,0.00,0.00,30.00,0.00,0.00),('1','161','862','193830',3786646,'2506','379',459636.47,460879.58,1223.11,199366.93,0.00,0.00,20.00,0.00,0.00),('1','161','862','193830',3786647,'2507','379',450816.79,452181.94,1335.15,217629.45,0.00,0.00,30.00,0.00,0.00),('1','161','862','193830',3786648,'2508','379',358311.91,359271.51,949.60,154784.80,0.00,0.00,10.00,0.00,0.00),('1','161','862','193830',3786649,'2509','379',319322.52,320097.62,755.10,123081.30,0.00,0.00,20.00,0.00,0.00),('1','161','862','193830',3786650,'2510','379',343941.70,344556.05,594.35,96879.05,0.00,0.00,20.00,0.00,0.00),('1','161','862','193830',3786651,'2511','379',298842.36,299518.38,656.02,106931.26,0.00,0.00,20.00,0.00,0.00),('1','161','862','193830',3786652,'2512','379',195179.66,195179.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','193830',3786653,'2513','379',246487.73,246885.50,387.77,63206.51,0.00,0.00,10.00,0.00,0.00),('1','161','863','193830',3786654,'2514','380',142704.95,142764.95,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193830',3786655,'2515','380',101838.81,102194.79,355.98,92554.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787930,'2496','379',179995.11,181246.67,1251.56,204004.28,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787931,'2497','379',257849.64,257849.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787932,'2498','379',375745.27,377402.92,1657.65,270196.95,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787933,'2499','379',396057.83,397554.82,1496.99,244009.37,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787934,'2500','379',370666.10,372077.98,1411.88,230136.44,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787935,'2501','379',179816.91,180719.35,902.44,147097.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787936,'2502','379',194232.73,194232.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787937,'2503','379',128468.23,128468.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787938,'2504','379',166358.34,166907.24,548.90,89470.70,0.00,0.00,0.00,0.00,0.00),('1','161','861','193921',3787939,'2505','379',308980.36,310124.66,1144.30,186520.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787940,'2506','379',460879.58,462634.04,1754.46,285976.98,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787941,'2507','379',452181.94,453998.16,1816.22,296043.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787942,'2508','379',359271.51,360859.38,1587.87,258822.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787943,'2509','379',320097.62,321221.71,1124.09,183226.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787944,'2510','379',344556.05,345941.75,1385.70,225869.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787945,'2511','379',299518.38,300793.67,1275.29,207872.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787946,'2512','379',195179.66,195887.39,707.73,115359.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','193921',3787947,'2513','379',246885.50,247483.91,598.41,97540.83,0.00,0.00,0.00,0.00,0.00),('1','161','863','193921',3787948,'2514','380',142764.95,142764.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','193921',3787949,'2515','380',102194.79,102672.44,477.65,124189.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789455,'2496','379',181246.67,182901.65,1634.98,266501.74,0.00,0.00,20.00,0.00,0.00),('1','161','861','194001',3789456,'2497','379',257849.64,257849.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789457,'2498','379',377402.92,378503.50,1100.58,179394.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789458,'2499','379',397554.82,398830.96,1276.14,208010.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789459,'2500','379',372077.98,373217.75,1139.77,185782.51,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789460,'2501','379',180719.35,181842.58,1123.23,183086.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789461,'2502','379',194232.73,194232.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789462,'2503','379',128468.23,128468.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789463,'2504','379',166907.24,167503.73,596.49,97227.87,0.00,0.00,0.00,0.00,0.00),('1','161','861','194001',3789464,'2505','379',310124.66,311064.68,940.02,153223.26,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789465,'2506','379',462634.04,463847.87,1213.83,197854.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789466,'2507','379',453998.16,455209.36,1211.20,197425.60,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789467,'2508','379',360859.38,362086.31,1226.93,199989.59,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789468,'2509','379',321221.71,322275.59,1053.88,171782.44,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789469,'2510','379',345941.75,347427.39,1485.64,242159.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789470,'2511','379',300793.67,300793.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789471,'2512','379',195887.39,196557.26,669.87,109188.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','194001',3789472,'2513','379',247483.91,247488.47,4.56,743.28,0.00,0.00,0.00,0.00,0.00),('1','161','863','194001',3789473,'2514','380',142764.95,143713.72,948.77,246680.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','194001',3789474,'2515','380',102672.44,102672.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794387,'2496','379',182901.65,183778.65,877.00,142951.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794388,'2497','379',257849.64,257881.28,31.64,5157.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794389,'2498','379',378503.50,379842.81,1339.31,218307.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794390,'2499','379',398830.96,400432.29,1601.33,261016.79,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794391,'2500','379',373217.75,374358.02,1140.27,185864.01,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794392,'2501','379',181842.58,181842.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794393,'2502','379',194232.73,195101.98,869.25,141687.75,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794394,'2503','379',128468.23,128844.94,376.71,61403.73,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794395,'2504','379',167503.73,167503.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194256',3794396,'2505','379',311064.68,312539.13,1474.45,240335.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794397,'2506','379',463847.87,465697.71,1849.84,301523.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794398,'2507','379',455209.36,456570.90,1361.54,221931.02,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794399,'2508','379',362086.31,363317.01,1230.70,200604.10,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794400,'2509','379',322275.59,323130.98,855.39,139428.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794401,'2510','379',347427.39,348628.26,1200.87,195741.81,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794402,'2511','379',300793.67,301724.38,930.71,151705.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794403,'2512','379',196557.26,197354.47,797.21,129945.23,0.00,0.00,0.00,0.00,0.00),('1','161','862','194256',3794404,'2513','379',247488.47,247498.47,10.00,1630.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','194256',3794405,'2514','380',143713.72,143713.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','194256',3794406,'2515','380',102672.44,103091.66,419.22,108997.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797561,'2496','379',183778.65,183795.83,17.18,2800.34,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797562,'2497','379',257881.28,258845.08,963.80,157099.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797563,'2498','379',379842.81,381718.85,1876.04,305794.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797564,'2499','379',400432.29,402088.24,1655.95,269919.85,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797565,'2500','379',374358.02,375871.13,1513.11,246636.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797566,'2501','379',181842.58,181842.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797567,'2502','379',195101.98,195941.09,839.11,136774.93,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797568,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797569,'2504','379',167503.73,168034.87,531.14,86575.82,0.00,0.00,0.00,0.00,0.00),('1','161','861','194441',3797570,'2505','379',312539.13,312539.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797571,'2506','379',465697.71,467175.70,1477.99,240912.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797572,'2507','379',456570.90,457731.94,1161.04,189249.52,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797573,'2508','379',363317.01,364307.78,990.77,161495.51,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797574,'2509','379',323130.98,324319.84,1188.86,193784.18,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797575,'2510','379',348628.26,349852.15,1223.89,199494.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797576,'2511','379',301724.38,302757.57,1033.19,168409.97,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797577,'2512','379',197354.47,197375.43,20.96,3416.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','194441',3797578,'2513','379',247498.47,248336.92,838.45,136667.35,0.00,0.00,0.00,0.00,0.00),('1','161','863','194441',3797579,'2514','380',143713.72,143773.72,60.00,15600.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','194441',3797580,'2515','380',103091.66,103599.76,508.10,132106.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800353,'2496','379',183795.83,183972.81,176.98,28847.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800354,'2497','379',258845.08,258845.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800355,'2498','379',381718.85,381893.89,175.04,28531.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800356,'2499','379',402088.24,402321.99,233.75,38101.25,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800357,'2500','379',375871.13,376003.45,132.32,21568.16,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800358,'2501','379',181842.58,181886.56,43.98,7168.74,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800359,'2502','379',195941.09,195985.50,44.41,7238.83,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800360,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800361,'2504','379',168034.87,168034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194609',3800362,'2505','379',312539.13,312787.02,247.89,40406.07,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800363,'2506','379',467175.70,469747.77,2572.07,419247.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800364,'2507','379',457731.94,460593.54,2861.60,466440.80,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800365,'2508','379',364307.78,366536.07,2228.29,363211.27,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800366,'2509','379',324319.84,326379.33,2059.49,335696.87,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800367,'2510','379',349852.15,351842.45,1990.30,324418.90,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800368,'2511','379',302757.57,304348.10,1590.53,259256.39,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800369,'2512','379',197375.43,198952.65,1577.22,257086.86,0.00,0.00,0.00,0.00,0.00),('1','161','862','194609',3800370,'2513','379',248336.92,249895.39,1558.47,254030.61,0.00,0.00,0.00,0.00,0.00),('1','161','863','194609',3800371,'2514','380',143773.72,145228.71,1454.99,378297.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','194609',3800372,'2515','380',103599.76,105021.04,1421.28,369532.80,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801264,'2496','379',183972.81,183972.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801265,'2497','379',258845.08,258845.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801266,'2498','379',381893.89,381893.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801267,'2499','379',402321.99,402321.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801268,'2500','379',376003.45,376003.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801269,'2501','379',181886.56,181886.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801270,'2502','379',195985.50,195985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801271,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801272,'2504','379',168034.87,168034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194649',3801273,'2505','379',312787.02,312787.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194649',3801274,'2506','379',469747.77,471789.31,2031.54,331141.02,0.00,0.00,10.00,0.00,0.00),('1','161','862','194649',3801275,'2507','379',460593.54,463106.37,2512.83,409591.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','194649',3801276,'2508','379',366536.07,368987.90,2431.83,396388.29,0.00,0.00,20.00,0.00,0.00),('1','161','862','194649',3801277,'2509','379',326379.33,328607.39,2228.06,363173.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','194649',3801278,'2510','379',351842.45,354089.37,2246.92,366247.96,0.00,0.00,0.00,0.00,0.00),('1','161','862','194649',3801279,'2511','379',304348.10,306072.09,1723.99,281010.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','194649',3801280,'2512','379',198952.65,200926.97,1964.32,320184.16,0.00,0.00,10.00,0.00,0.00),('1','161','862','194649',3801281,'2513','379',249895.39,251935.43,2040.04,332526.52,0.00,0.00,0.00,0.00,0.00),('1','161','863','194649',3801282,'2514','380',145228.71,145278.71,50.00,13000.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','194649',3801283,'2515','380',105021.04,105274.89,243.85,63401.00,0.00,0.00,10.00,0.00,0.00),('1','161','861','194818',3804521,'2496','379',183972.81,183972.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804522,'2497','379',258845.08,258845.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804523,'2498','379',381893.89,381893.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804524,'2499','379',402321.99,402321.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804525,'2500','379',376003.45,376003.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804526,'2501','379',181886.56,181886.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804527,'2502','379',195985.50,195985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804528,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804529,'2504','379',168034.87,168034.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194818',3804530,'2505','379',312787.02,312787.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804531,'2506','379',471789.31,472153.95,364.64,59436.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804532,'2507','379',463106.37,463575.01,468.64,76388.32,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804533,'2508','379',368987.90,369380.97,393.07,64070.41,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804534,'2509','379',328607.39,328927.52,320.13,52181.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804535,'2510','379',354089.37,354469.33,379.96,61933.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804536,'2511','379',306072.09,306310.10,238.01,38795.63,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804537,'2512','379',200926.97,201272.38,345.41,56301.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','194818',3804538,'2513','379',251935.43,252292.31,356.88,58171.44,0.00,0.00,0.00,0.00,0.00),('1','161','863','194818',3804539,'2514','380',145278.71,145807.97,529.26,137607.60,0.00,0.00,0.00,0.00,0.00),('1','161','863','194818',3804540,'2515','380',105274.89,105531.43,256.54,66700.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804622,'2496','379',183972.81,184887.39,914.58,149076.54,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804623,'2497','379',258845.08,258845.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804624,'2498','379',381893.89,382957.53,1063.64,173373.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804625,'2499','379',402321.99,403400.90,1078.91,175862.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804626,'2500','379',376003.45,376612.92,609.47,99343.61,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804627,'2501','379',181886.56,181886.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804628,'2502','379',195985.50,196815.56,830.06,135299.78,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804629,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804630,'2504','379',168034.87,168079.03,44.16,7198.08,0.00,0.00,0.00,0.00,0.00),('1','161','861','194821',3804631,'2505','379',312787.02,313639.13,852.11,138893.93,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804632,'2506','379',472153.95,473020.93,866.98,141317.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804633,'2507','379',463575.01,464800.86,1225.85,199813.55,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804634,'2508','379',369380.97,370119.80,738.83,120429.29,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804635,'2509','379',328927.52,328927.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804636,'2510','379',354469.33,355455.31,985.98,160714.74,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804637,'2511','379',306310.10,306310.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804638,'2512','379',201272.38,201272.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194821',3804639,'2513','379',252292.31,252776.03,483.72,78846.36,0.00,0.00,0.00,0.00,0.00),('1','161','863','194821',3804640,'2514','380',145807.97,146411.35,603.38,156878.80,0.00,0.00,0.00,0.00,0.00),('1','161','863','194821',3804641,'2515','380',105531.43,105930.27,398.84,103698.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805189,'2496','379',184887.39,184887.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805190,'2497','379',258845.08,260448.48,1603.40,261354.20,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805191,'2498','379',382957.53,384226.97,1269.44,206918.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805192,'2499','379',403400.90,404637.24,1236.34,201523.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805193,'2500','379',376612.92,377477.92,865.00,140995.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805194,'2501','379',181886.56,181886.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805195,'2502','379',196815.56,197369.98,554.42,90370.46,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805196,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805197,'2504','379',168079.03,168088.47,9.44,1538.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','194844',3805198,'2505','379',313639.13,314549.85,910.72,148447.36,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805199,'2506','379',473020.93,474405.83,1384.90,225738.70,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805200,'2507','379',464800.86,466133.57,1332.71,217231.73,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805201,'2508','379',370119.80,371056.35,936.55,152657.65,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805202,'2509','379',328927.52,329992.08,1064.56,173523.28,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805203,'2510','379',355455.31,356145.15,689.84,112443.92,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805204,'2511','379',306310.10,306795.90,485.80,79185.40,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805205,'2512','379',201272.38,201272.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194844',3805206,'2513','379',252776.03,253255.30,479.27,78121.01,0.00,0.00,0.00,0.00,0.00),('1','161','863','194844',3805207,'2514','380',146411.35,146957.12,545.77,141900.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','194844',3805208,'2515','380',105930.27,107143.92,1213.65,315549.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805285,'2496','379',184887.39,184887.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805286,'2497','379',260448.48,261730.07,1281.59,208899.17,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805287,'2498','379',384226.97,386180.90,1953.93,318490.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805288,'2499','379',404637.24,406514.70,1877.46,306025.98,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805289,'2500','379',377477.92,378979.23,1501.31,244713.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805290,'2501','379',181886.56,182843.18,956.62,155929.06,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805291,'2502','379',197369.98,197369.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805292,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805293,'2504','379',168088.47,168088.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','194848',3805294,'2505','379',314549.85,316018.29,1468.44,239355.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805295,'2506','379',474405.83,476569.28,2163.45,352642.35,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805296,'2507','379',466133.57,467643.98,1510.41,246196.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805297,'2508','379',371056.35,372517.49,1461.14,238165.82,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805298,'2509','379',329992.08,331504.48,1512.40,246521.20,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805299,'2510','379',356145.15,358044.10,1898.95,309528.85,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805300,'2511','379',306795.90,306797.90,2.00,326.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805301,'2512','379',201272.38,201272.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','862','194848',3805302,'2513','379',253255.30,253783.17,527.87,86042.81,0.00,0.00,0.00,0.00,0.00),('1','161','863','194848',3805303,'2514','380',146957.12,148392.82,1435.70,373282.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','194848',3805304,'2515','380',107143.92,107143.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809037,'2496','379',184887.39,185265.28,377.89,61596.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809038,'2497','379',261730.07,261730.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809039,'2498','379',386180.90,386581.70,400.80,65330.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809040,'2499','379',406514.70,407121.77,607.07,98952.41,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809041,'2500','379',378979.23,379252.87,273.64,44603.32,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809042,'2501','379',182843.18,182843.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809043,'2502','379',197369.98,197627.29,257.31,41941.53,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809044,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809045,'2504','379',168088.47,168088.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195059',3809046,'2505','379',316018.29,316365.28,346.99,56559.37,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809047,'2506','379',476569.28,477093.76,524.48,85490.24,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809048,'2507','379',467643.98,468190.76,546.78,89125.14,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809049,'2508','379',372517.49,372855.01,337.52,55015.76,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809050,'2509','379',331504.48,331696.92,192.44,31367.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809051,'2510','379',358044.10,358361.51,317.41,51737.83,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809052,'2511','379',306797.90,306802.03,4.13,673.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809053,'2512','379',201272.38,201528.35,255.97,41723.11,0.00,0.00,0.00,0.00,0.00),('1','161','862','195059',3809054,'2513','379',253783.17,253783.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','195059',3809055,'2514','380',148392.82,149181.74,788.92,205119.20,0.00,0.00,0.00,0.00,0.00),('1','161','863','195059',3809056,'2515','380',107143.92,107143.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811507,'2496','379',185265.28,186247.12,981.84,160039.92,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811508,'2497','379',261730.07,261730.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811509,'2498','379',386581.70,387774.74,1193.04,194465.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811510,'2499','379',407121.77,408469.40,1347.63,219663.69,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811511,'2500','379',379252.87,380299.95,1047.08,170674.04,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811512,'2501','379',182843.18,183857.41,1014.23,165319.49,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811513,'2502','379',197627.29,197627.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811514,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811515,'2504','379',168088.47,168620.51,532.04,86722.52,0.00,0.00,0.00,0.00,0.00),('1','161','861','195203',3811516,'2505','379',316365.28,317744.34,1379.06,224786.78,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811517,'2506','379',477093.76,478686.85,1593.09,259673.67,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811518,'2507','379',468190.76,469494.33,1303.57,212481.91,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811519,'2508','379',372855.01,374224.97,1369.96,223303.48,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811520,'2509','379',331696.92,332811.31,1114.39,181645.57,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811521,'2510','379',358361.51,359143.59,782.08,127479.04,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811522,'2511','379',306802.03,307965.47,1163.44,189640.72,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811523,'2512','379',201528.35,202795.08,1266.73,206476.99,0.00,0.00,0.00,0.00,0.00),('1','161','862','195203',3811524,'2513','379',253783.17,253783.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','863','195203',3811525,'2514','380',149181.74,149549.18,367.44,95534.40,0.00,0.00,0.00,0.00,0.00),('1','161','863','195203',3811526,'2515','380',107143.92,107322.76,178.84,46498.40,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812171,'2496','379',186247.12,186463.56,216.44,35279.72,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812172,'2497','379',261730.07,262941.00,1210.93,197381.59,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812173,'2498','379',387774.74,389675.65,1900.91,309848.33,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812174,'2499','379',408469.40,408839.74,370.34,60365.42,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812175,'2500','379',380299.95,381691.23,1391.28,226778.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812176,'2501','379',183857.41,184915.08,1057.67,172400.21,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812177,'2502','379',197627.29,197731.57,104.28,16997.64,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812178,'2503','379',128844.94,128844.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812179,'2504','379',168620.51,169029.40,408.89,66649.07,0.00,0.00,0.00,0.00,0.00),('1','161','861','195237',3812180,'2505','379',317744.34,318980.47,1236.13,201489.19,0.00,0.00,0.00,0.00,0.00),('1','161','862','195237',3812181,'2506','379',478686.85,479929.68,1242.83,20258