-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_158
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_158`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_158` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_158`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3217 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2643,20015,'',0,'22','1','158','PURCHASES','','2020-08-12 12:07:14',5,0.00,0.00,'','479','2020-08-12 12:07:14','479',0,1),(2644,20023,'',0,'20','1','158','SALES','','2020-08-12 12:07:34',5,0.00,0.00,'','479','2020-08-12 12:07:34','479',0,1),(2645,40022,'',0,'6.1','1','158','CASH','','2020-08-12 12:07:49',5,0.00,0.00,'','479','2020-08-12 12:07:49','479',0,1),(2646,400102,'',0,'24','1','158','SALARIES & WAGES','','2020-08-12 12:08:07',5,0.00,0.00,'','479','2020-08-12 12:08:07','479',0,1),(2647,400239,'',0,'2','1','158','ZBN(E-BILL):1015372548','','2020-08-12 12:08:26',5,0.00,0.00,'','479','2020-08-12 12:08:26','479',0,1),(2648,400240,'',0,'2','1','158','ZBN(POS):1015965368','','2020-08-12 12:08:54',5,0.00,0.00,'','479','2020-08-12 12:08:54','479',0,1),(2654,400105,'',0,'24','1','158','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION.','2020-08-13 12:30:33',5,0.00,0.00,'','479','2020-08-13 12:30:33','479',0,1),(2913,400330,'',0,'2','1','158','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:07:28',5,0.00,0.00,'','489','2020-10-29 14:07:28','489',0,1),(3216,400495,'',0,'2','1','158','FID POS COLLECTION-5620141491','','2021-02-26 16:07:20',5,0.00,0.00,'','489','2021-02-26 16:07:20','489',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4239 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1592,'','1','158','ASOKORO LPG','USMAN','08148063533','ussy090@gmail.com','ABUJA','ABUJA','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:20:11',5,'512','2020-08-13 10:20:11','512'),(1593,'','1','158','KUJE LPG SKID','JAMILU','07064768921','jamilusanih@gmail.com','ABUJA','ABUJA','KUJE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:23:07',5,'512','2022-02-22 12:41:07','512'),(1594,'','1','158','LIFE CAMP','ALEX','09030207031','kpojimealexanader@gmail.com','ABUJA','ABUJA','LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:25:46',5,'512','2020-08-13 10:25:46','512'),(1596,'','1','158','KATAMFE','BUHARI','08136784069','bigaya78@gmail.com','ABUJA','ABUJA','KATAMFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:32:18',5,'512','2020-08-13 10:32:18','512'),(1597,'','1','158','KEFFI LPG SKID','AUWAL','08037945787','aouwoulsheeik99@gmail.com','ABUJA','ABUJA','KEFFI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:34:42',5,'512','2022-02-22 12:42:32','512'),(1598,'','1','158','KARU PLANT','ALIYU','08065121622','aleepanda14@gmail.com','ABUJA','ABUJA','KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:36:40',5,'512','2020-09-17 13:04:06','512'),(1599,'','1','158','ONE MAN VILLAGE ','MUSA','08104018534','musashuaibu@gmail.com','ABUJA','ABUJA','ONE MAN VILLAGE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:39:03',5,'512','2020-08-13 10:39:03','512'),(1600,'','1','158','NYANYA LPG SKID','BASHIR','07033757423','bashirauwalpanda@gmail.com','ABUJA','ABUJA','NYANYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:44:01',5,'512','2022-02-22 12:42:58','512'),(1603,'','1','158','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 12:28:26',5,'479','2020-08-13 12:28:26','479'),(1611,'','1','158','ZEAL GAS','AHMED','07066325994','engrahmed@gmail.com','ABUJA','ABUJA','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 14:26:05',5,'512','2020-08-13 14:26:05','512'),(1612,'','1','158','UMAR GAS ','UMAR','09063806718','umar23@gmail,com','ABUJA','ABUJA','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:10:07',5,'512','2020-08-13 15:10:07','512'),(1613,'','1','158','GODS SON GAS','JOSUA','08151393631','joshua12@gmail.com','ABUJA','ABUJA','KAGINI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:24:20',5,'512','2020-08-13 15:24:20','512'),(1614,'','1','158','BECHA GAS','SIMON','08060913495','becha3@gmail.com','ABUJA','ABUJA','USHAFA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:26:06',5,'512','2020-08-13 15:26:06','512'),(1615,'','1','158','KEN GAS ','PAUL','07030150069','kens2@gmail.com','ABUJA','ABUJA','GUZABE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:27:27',5,'512','2020-08-13 15:27:27','512'),(1616,'','1','158','HOT GAS','PRINCE GAS','08132008895','hot2@gmail.com','ABUJA','ABUJA','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:28:34',5,'512','2020-08-13 15:28:34','512'),(1617,'','1','158','AMAZING GAS','GODWIN','08082499027','godwin4@gmail.com','ABUJA','ABUJA','JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:31:07',5,'512','2020-08-13 15:31:07','512'),(1618,'','1','158','JAMBEST GAS','GODWIN','09036137097','jamb6@gmail.com','ABUJA','ABUJA','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 15:32:56',5,'512','2020-08-13 15:32:56','512'),(1619,'','1','158','ELOFUSIM GAS','BEN','08030588379','ben3@gmail.com','ABUJA','ABUJA','GWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 16:03:58',5,'512','2020-08-13 16:03:58','512'),(1621,'','1','158','ADVANCE LINK OIL AND GAS','ELIZABETH','07066065756','eii33@gmail.com','ABUJA','ABUJA','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-19 11:47:11',5,'512','2020-08-19 11:47:11','512'),(1622,'','1','158','NAKU GAS','OFFICER','08168278134','nak21@gmail.com','ABUJA','ABUJA','MOPOL BARACK','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-19 12:18:56',5,'512','2020-08-19 12:18:56','512'),(1623,'','1','158','YAKUBU GAS','YAKUBU','08098765432','yaku34@gmail.com','ABUJA','ABUJA','MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-19 12:20:28',5,'512','2020-08-19 12:20:28','512'),(1624,'','1','158','FGC GAS','MUSA','09076554321','fg32@gmail.com','ABUJA','ABUJA','KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-19 12:21:41',5,'512','2020-08-19 12:21:41','512'),(1637,'','1','158','U I DANDADA','ABUBAKAR','08065392343','ui43@yahoo.com','ABUJA','ABUJA','KADUNA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-25 16:41:19',5,'512','2020-08-25 16:41:19','512'),(1638,'','1','158','DODOMA GAS','HAYATU','08034506780','dodoma23@gmail.com','ABUJA','ABUJA','LOKOGOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-25 16:42:34',5,'512','2020-08-25 16:42:34','512'),(1639,'','1','158','MACCO GAS','MACCO','08065403876','mac34@gmail.com','ABUJA','ABUJA','GWAGWA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-25 17:30:12',5,'512','2020-08-25 17:30:12','512'),(1640,'','1','158','EMMA GAS','EMMA','081324567','emma32@gmail.com','ABUJA','ABUJA','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-25 17:31:12',5,'512','2020-08-25 17:31:12','512'),(1650,'','1','158','SUNSHINE GAS','JAMES MARTINS','08052365598','james22@gmail.com','ABUJA','ABUJA','KADUNA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 07:26:52',5,'512','2020-09-03 07:26:52','512'),(1651,'','1','158','AMC GAS','ALI ZAMANI','07069626486','ali23@gmail.com','ABUJA','ABUJA','ZAMANI VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 07:40:29',5,'512','2020-09-03 07:40:29','512'),(1652,'','1','158','RAYMOND GAS','PAUL','07062683133','ray34@yahoo.com','ABUJA','ABUJA','USHAFA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 07:41:26',5,'512','2020-09-03 07:41:26','512'),(1653,'','1','158','SIMKEL GAS','SAMUEL ','08066325896','sim54@gmail.com','ABUJA','ABUJA','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 11:03:13',5,'512','2020-09-03 11:03:13','512'),(1654,'','1','158','KAGINI GAS','JOSHUA ','08056253022','josh23@gmail.com','ABUJA','ABUJA','KAGINI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 12:01:13',5,'512','2020-09-03 12:01:13','512'),(1655,'','1','158','ZUBA GAS','ALEXENDER','08060913495','alexis23@gmail.com','ABUJA','ABUJA','ZUBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 12:02:21',5,'512','2020-09-03 12:02:21','512'),(1684,'','1','158','SETRACO GAS','JOSEPH IDRIS','08052025033','josephsetracogas@gmail.com','ABUJA','ABUJA','GWARIMPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-30 15:47:36',5,'512','2020-09-30 15:47:36','512'),(1686,'','1','158','GOSONS GAS','MOSES','09061895115','gosonmoses@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-05 14:22:08',5,'512','2020-10-05 14:22:08','512'),(1758,'','1','158','CNN GAS','SAMUEL ','07030400530','sam24@gmail.com','ABUJA','ABUJA','KUJE ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-11-01 09:01:27',5,'512','2020-11-01 09:01:27','512'),(1783,'','1','158','BEEBLA GAS','SAMUEL ','07062683133','james22@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-11-09 13:20:36',5,'512','2020-11-09 13:20:36','512'),(1890,'','1','158','FINE GAS','MONDAY','07064544844','fineboy@gmail.com','ABUJA','ABUJA','LIFE CAMP, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-06 14:23:27',5,'512','2020-12-06 14:23:27','512'),(1904,'','1','158','EROVVO GAS','JAMES MARTINS','08064972800','errov@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-13 12:10:45',5,'512','2020-12-13 12:10:45','512'),(1905,'','1','158','BLESSED-UC','ALEXENDER','07062683133','bleesed@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-13 13:04:16',5,'512','2020-12-13 13:04:16','512'),(1923,'','1','158','SHIBA GAS','GARZALI','08038971097','shibagas@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-21 14:55:48',5,'512','2020-12-21 14:55:48','512'),(1929,'','1','158','JENEP GAS','ALAJE','08188124000','jenebgas@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-24 10:23:44',5,'512','2020-12-24 10:23:44','512'),(1930,'','1','158','ORANGE GAS','SANDRA','08168194388','orangegas@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-24 10:25:24',5,'512','2020-12-24 10:25:24','512'),(1942,'','1','158','OVERAGE','OVERAGE','000000000','overage@gmail.com','ABUJA','ABUJA','OVERAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-30 17:20:09',5,'512','2020-12-30 17:20:09','512'),(1960,'','1','158','AYM SHAFA','SAMUEL ','08037977107','aymshafa@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-01-07 15:09:44',5,'512','2021-01-07 15:09:44','512'),(1991,'','1','158','KM TRADE GAS','YUSUF INDABAWA','09039103300','yusuf@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-01-30 10:04:23',5,'512','2021-01-30 10:04:23','512'),(1992,'','1','158','TONY GAS','TONY','000000000','tontgas@gmail.com','ABUJA','ABUJA','abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-01-30 12:07:50',5,'512','2021-01-30 12:07:50','512'),(2005,'','1','158','GENEP GAS','IYEKE','000000000','genevgas@gmail.com','ABUJA','ABUJA','abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-09 17:06:27',5,'512','2022-04-27 14:31:31','512'),(2070,'','1','158','JUDA GAS','YUSUF','000000000','juda@gmail.com','ABUJA','ABUJA','ABUJA, GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 16:04:58',5,'512','2021-02-19 16:04:58','512'),(2353,'','1','158','RUSH WASH GLPBAL SERVICES','PAUL','000000000','james22@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-18 11:14:25',5,'512','2021-03-18 11:14:25','512'),(2354,'','1','158','GREEN ACCESS','MONDAY','000000000','ray34@yahoo.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-18 11:17:18',5,'512','2021-03-18 11:17:18','512'),(2355,'','1','158','SOLAR GAS','JAMES MARTINS','000000000','ray34@yahoo.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-18 14:11:30',5,'512','2021-03-18 14:11:30','512'),(2362,'','1','158','LUBE GAS','KEHINDE','000000000','ali23@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-19 10:56:56',5,'512','2021-03-19 10:56:56','512'),(2364,'','1','158','JABI LPG SKID','AUWAL','000000000','ali23@gmail.com','ABUJA','ABUJA','LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-20 09:54:15',5,'512','2022-02-22 12:42:00','512'),(2365,'','1','158','APO LPG SKID','SANI','000000000','ray34@yahoo.com','ABUJA','ABUJA','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-20 09:56:05',5,'512','2022-02-22 12:39:35','512'),(2375,'','1','158','BUY GAS','PAUL','000000000','josh23@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 09:39:03',5,'512','2021-03-22 09:39:03','512'),(2397,'','1','158','ALHUSZEE GAS','IMAM','000000000','ali23@gmail.com','ABUJA','ABUJA','MINNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 12:32:37',5,'512','2021-03-25 12:32:37','512'),(2545,'','1','158','NIP WEST GAS','KEHINDE','07062683133','orangegas@gmail.com','ABUJA','ABUJA','KUBWA, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-11 10:59:28',5,'512','2021-04-11 10:59:28','512'),(2590,'','1','158','MANSUR GAS','MANSUR','000000000','mansur@gmail.com','NASSARAWA','NASSARAWA','NASSARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 12:03:48',5,'512','2021-04-22 12:03:48','512'),(2691,'','1','158','NASIR GAS','NASIR','000000000','nasirgas@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-19 11:32:04',5,'512','2021-05-19 11:32:04','512'),(2800,'','1','158','AMITEX GAS','KEHINDE','000000000','ray34@yahoo.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 09:54:56',5,'512','2021-06-22 09:54:56','512'),(2848,'','1','158','AA RANO ILLORIN','ABDULLAHI','000000000','abdul@gmail.com','ILLORIN','KWARA','ILLORIN, KWARA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-27 09:03:36',5,'512','2021-06-27 09:03:36','512'),(2855,'','1','158','EDEMA GAS','EDEMA','000000000','edema@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 10:15:46',5,'512','2021-06-28 10:15:46','512'),(2864,'','1','158','HV ENERGY','SAMUEL ','000000000','sam@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 14:21:44',5,'512','2021-06-29 14:21:44','512'),(2865,'','1','158','MERI GAS','AYO','000000000','ray34@yahoo.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 14:24:02',5,'512','2021-06-29 14:24:02','512'),(2888,'','1','158','DON NAS GAS','NASIR','000000000','nasirdon@gmail.com','NASSARAWA','NASSARAWA','KEFFI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 20:28:12',5,'512','2021-07-01 20:28:12','512'),(2936,'','1','158','JEFF GAS','JEFF','000000000','jeff@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 10:48:22',5,'512','2021-07-12 10:48:22','512'),(3022,'','1','158','KARSHI GAS','SARKI','000000000','karshigas@gmail.com','NASSARAWA','NASSARAWA','KARSHI, NASSARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 10:09:06',5,'512','2021-08-06 10:09:06','512'),(3348,'','1','158','GANO GAS','MUHAMMAD BUHARI','000000000','muhammad@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-23 14:52:22',5,'512','2021-09-23 14:52:22','512'),(3516,'','1','158','GAS CONNECT','GAS CONNECT','000000000','gasconnect@gmail.com','ABUJA','ABUJA','GAS CONNECT','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-20 11:07:48',5,'512','2021-10-20 11:07:48','512'),(3589,'','1','158','CITY GATE LPG SKID','AA RANO','000000000','aarano2@gmail.com','ABUJA','ABUJA','ABUJA AIRPORT ROad','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-22 13:53:20',5,'512','2022-02-22 12:36:46','512'),(3856,'','1','158','HARIZ GAS','ALH YAU','08065320264','harizga@gmail.com','ABUJA','ABUJA','MASAKA, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-27 07:47:02',5,'512','2021-11-27 07:47:02','512'),(4224,'','1','158','MUNAH GAS','MURTAL ','000000000','murtala@gmail.com','ABUJA','ABUJA','masaka, Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-21 17:35:09',5,'512','2022-01-21 17:35:09','512'),(4228,'','1','158','MAXPRIME GAS','ALH. HAMZA','000000000','maxprime@gmail.com','ABUJA','ABUJA','GWAGWALADA, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-24 09:11:33',5,'512','2022-01-24 09:11:33','512'),(4229,'','1','158','LOKOJA PLANT','ABDULLAHI','000000000','aarano2@gmail.com','lokoja','lokoja','lokoja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-09 14:13:29',5,'512','2022-04-27 14:30:32','512'),(4230,'','1','158','ADO PLANT','INUSA','000000000','aarano2@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 16:39:42',5,'512','2022-04-04 16:39:42','512'),(4231,'','1','158','KADO LPG SKID','MUHAMMAD','000000000','aarano2@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 16:55:16',5,'512','2022-05-26 16:55:16','512'),(4232,'','1','158','THRESHOLD GAS','ABDULLAHI','000000000','orangegas@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 17:51:26',5,'512','2022-05-26 17:51:26','512'),(4233,'','1','158','VINEE GAS','SAMUEL ','000000000','james22@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 15:38:39',5,'512','2022-05-27 15:38:39','512'),(4234,'','1','158','GUDU LPG SKID','MUHD','000000000','aarano2@gmail.com','ABUJA','ABUJA','GUDU, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-02 11:26:12',5,'512','2022-06-02 11:26:12','512'),(4235,'','1','158','N.U SYNERGY LTD','MUHAMMAD','000000000','nusynergy@gmail.com','BAUCHI','BAUCHI','BAUCHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-27 12:46:38',5,'512','2022-06-27 12:46:38','512'),(4236,'','1','158','GWAGWALADA LPG SKID','MUHAMMAD','000000000','gwagwaladalpg@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-02 12:17:01',5,'512','2022-07-02 12:17:01','512'),(4237,'','1','158','SULEJA 1 LPG SKID','MUHAMMAD','000000000','aarano2@gmail.com','ABUJA','ABUJA','SULEJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-01 14:35:17',5,'512','2022-12-01 14:35:17','512'),(4238,'','1','158','SULEJA 2 LPG SKID','YUSUF','000000000','aarano2@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-23 09:54:30',5,'512','2022-12-23 09:54:30','512');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18526 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','158',16031,'780',23180.00,25120.00,'2021-08-12','new dipping','2021-08-12 11:58:06','483','483',2021,'483','2021-08-12 11:58:06',5),('1','158',16032,'781',6565.00,1.00,'2021-08-12','new dipping','2021-08-12 11:58:57','483','483',2021,'483','2021-08-12 11:58:57',5),('1','158',16057,'781',25061.00,25190.00,'2021-08-14','new dipping','2021-08-14 10:31:05','512','512',2021,'512','2021-08-14 10:31:05',5),('1','158',16058,'780',-130.00,1.00,'2021-08-09','new dipping','2021-08-14 10:32:18','512','512',2021,'512','2021-08-14 10:32:18',5),('1','158',16627,'780',-1709.00,1.00,'2021-09-27','new dipping','2021-09-27 10:52:47','483','483',2021,'483','2021-09-27 10:52:47',5),('1','158',16628,'781',24050.00,25000.00,'2021-09-27','new dipping','2021-09-27 10:55:29','483','483',2021,'483','2021-09-27 10:55:29',5),('1','158',18524,'780',22721.00,24940.00,'2022-01-22','new','2022-01-22 11:18:34','483','483',2022,'483','2022-01-22 11:18:34',5),('1','158',18525,'781',-2160.00,1.00,'2022-01-22','new','2022-01-22 11:18:58','483','483',2022,'483','2022-01-22 11:18:58',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2191 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','158','780',2189,'5','LPG NOZZLE 1',0.00,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','158','781',2190,'5','LPG NOZZLE 2',0.00,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257682 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','158',147201,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 12:03:34','512','2020-08-13 12:04:05',10,0),('1','158',147214,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 12:13:50','512','2020-08-13 12:14:33',10,0),('1','158',147217,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 12:20:27','512','2020-08-13 12:21:56',10,0),('1','158',147221,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 12:32:15','512','2020-08-13 12:34:22',10,0),('1','158',147226,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 12:41:24','512','2020-08-13 12:41:47',10,0),('1','158',147232,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 13:02:43','512','2020-08-13 13:03:03',10,0),('1','158',147234,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 13:22:32','512','2020-08-13 13:25:07',10,0),('1','158',147245,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 14:09:38','512','2020-08-13 14:43:00',10,0),('1','158',147273,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 15:34:02','512','2020-08-13 15:34:31',10,0),('1','158',147284,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 16:04:26','512','2020-08-13 16:04:54',10,0),('1','158',147287,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-13 16:12:20','512','2020-08-13 16:12:52',10,0),('1','158',147289,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-18 16:05:54','512','2020-08-18 16:06:18',10,0),('1','158',147969,'daily shift','2020-08-11','2020-08-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-18 16:14:15','512','2020-08-18 16:14:52',10,0),('1','158',148040,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-19 12:48:07','512','2020-08-19 12:48:35',10,0),('1','158',148927,'daily shift','2020-08-12','2020-08-12 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-25 16:36:29','512','2020-08-25 16:37:02',10,0),('1','158',148935,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-25 17:03:01','512','2020-08-25 17:03:53',10,0),('1','158',148941,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-25 17:52:37','512','2020-08-25 17:53:04',10,0),('1','158',148977,'daily shift','2020-08-15','2020-08-15 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-26 07:43:59','512','2020-08-26 07:44:17',10,0),('1','158',148980,'daily shift','2020-08-16','2020-08-16 00:00:00',NULL,'512',0.00,0.00,'512','2020-08-26 08:04:56','512','2020-08-26 08:05:22',10,0),('1','158',150174,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 07:33:43','512','2020-09-03 07:34:00',10,0),('1','158',150180,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 08:03:38','512','2020-09-03 08:04:01',10,0),('1','158',150187,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 08:17:07','512','2020-09-03 08:17:28',10,0),('1','158',150190,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 08:33:14','512','2020-09-03 08:33:35',10,0),('1','158',150194,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 08:44:51','512','2020-09-03 08:45:12',10,0),('1','158',150197,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 09:08:12','512','2020-09-03 09:08:38',10,0),('1','158',150203,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 09:41:37','512','2020-09-03 09:41:54',10,0),('1','158',150214,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 10:07:32','512','2020-09-03 10:07:47',10,0),('1','158',150215,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 10:17:47','512','2020-09-03 10:20:40',10,0),('1','158',150218,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 10:38:13','512','2020-09-03 10:38:29',10,0),('1','158',150220,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 10:53:17','512','2020-09-03 10:53:33',10,0),('1','158',150225,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 11:33:32','512','2020-09-03 11:35:03',10,0),('1','158',150237,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 11:45:06','512','2020-09-03 11:45:23',10,0),('1','158',150246,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 11:56:49','512','2020-09-03 11:57:08',10,0),('1','158',150247,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 12:12:14','512','2020-09-03 12:12:29',10,0),('1','158',150250,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 12:23:26','512','2020-09-03 12:23:40',10,0),('1','158',150253,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 13:15:36','512','2020-09-03 13:15:56',10,0),('1','158',150278,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 13:58:20','512','2020-09-03 13:58:47',10,0),('1','158',150283,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 14:03:58','512','2020-09-03 14:04:14',10,0),('1','158',150285,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 14:10:57','512','2020-09-03 14:11:12',10,0),('1','158',150288,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-03 14:33:31','512','2020-09-03 14:33:46',10,0),('1','158',150334,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-06 09:28:12','512','2020-09-06 09:28:42',10,0),('1','158',150733,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-06 09:37:24','512','2020-09-06 09:37:47',10,0),('1','158',150738,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-06 11:33:05','512','2020-09-06 11:33:28',10,0),('1','158',150754,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-06 12:19:28','512','2020-09-06 12:19:43',10,0),('1','158',150761,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-06 14:05:47','512','2020-09-06 14:06:06',10,0),('1','158',150788,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-07 13:08:37','512','2020-09-07 13:08:55',10,0),('1','158',151084,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-08 13:33:54','512','2020-09-08 13:34:15',10,0),('1','158',151088,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-11 09:37:52','512','2020-09-11 09:38:11',10,0),('1','158',151474,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-11 09:57:21','512','2020-09-11 09:57:39',10,0),('1','158',151477,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-11 10:04:05','512','2020-09-11 10:04:26',10,0),('1','158',151478,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-13 15:24:05','512','2020-09-13 15:24:32',10,0),('1','158',151791,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-13 16:15:22','512','2020-09-13 16:15:40',10,0),('1','158',151793,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-17 12:37:38','512','2020-09-17 12:37:59',10,0),('1','158',152387,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-17 13:51:45','512','2020-09-17 13:52:15',10,0),('1','158',152409,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-21 14:53:35','512','2020-09-21 14:54:06',10,0),('1','158',153028,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-21 15:10:29','512','2020-09-21 15:10:58',10,0),('1','158',153044,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-21 15:48:42','512','2020-09-21 15:49:23',10,0),('1','158',153048,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-21 16:18:47','512','2020-09-21 16:19:11',10,0),('1','158',153054,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-21 16:35:38','512','2020-09-21 16:36:01',10,0),('1','158',153057,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-22 11:32:57','512','2020-09-22 11:33:16',10,0),('1','158',153161,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-22 11:45:09','512','2020-09-22 11:45:36',10,0),('1','158',153165,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-23 10:29:53','512','2020-09-23 10:30:24',10,0),('1','158',153330,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-25 14:33:19','512','2020-09-25 14:34:21',10,0),('1','158',153753,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-25 14:52:29','512','2020-09-25 14:52:56',10,0),('1','158',154544,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-30 15:56:23','512','2020-09-30 15:57:02',10,0),('1','158',154547,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-30 16:04:32','512','2020-09-30 16:04:59',10,0),('1','158',154552,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-30 16:16:24','512','2020-09-30 16:16:43',10,0),('1','158',154554,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-30 16:20:16','512','2020-09-30 16:20:33',10,0),('1','158',154555,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-09-30 16:36:47','512','2020-09-30 16:37:28',10,0),('1','158',155188,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-05 10:48:03','512','2020-10-05 10:48:31',10,0),('1','158',155207,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-05 11:16:50','512','2020-10-05 11:17:12',10,0),('1','158',155211,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-05 11:29:31','512','2020-10-05 11:29:57',10,0),('1','158',155866,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-09 14:29:21','512','2020-10-09 14:29:52',10,0),('1','158',155868,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-09 14:39:41','512','2020-10-09 14:40:06',10,0),('1','158',155873,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-09 14:48:36','512','2020-10-09 14:49:15',10,0),('1','158',156015,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 13:36:35','512','2020-10-10 13:37:05',10,0),('1','158',156018,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 14:28:34','512','2020-10-10 14:29:05',10,0),('1','158',156032,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 14:36:30','512','2020-10-10 14:36:53',10,0),('1','158',156066,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 17:23:05','512','2020-10-10 17:23:29',10,0),('1','158',156068,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 17:34:52','512','2020-10-10 17:35:40',10,0),('1','158',156069,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-10 18:00:55','512','2020-10-10 18:01:30',10,0),('1','158',156284,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-12 11:19:13','512','2020-10-12 11:19:33',10,0),('1','158',156351,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-13 11:06:32','512','2020-10-13 11:06:58',10,0),('1','158',156521,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-18 13:42:54','512','2020-10-18 13:43:24',10,0),('1','158',157397,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-21 08:36:25','512','2020-10-21 08:36:48',10,0),('1','158',157839,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-21 09:00:59','512','2020-10-21 09:01:25',10,0),('1','158',157842,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-21 09:03:37','512','2020-10-21 09:04:30',10,0),('1','158',157844,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-21 09:09:03','512','2020-10-21 09:09:28',10,0),('1','158',157978,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-22 10:00:24','512','2020-10-22 10:00:58',10,0),('1','158',158044,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-22 15:20:48','512','2020-10-22 15:21:21',10,0),('1','158',158046,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-25 11:43:12','512','2020-10-25 11:43:42',10,0),('1','158',158478,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-25 11:55:18','512','2020-10-25 11:55:46',10,0),('1','158',158481,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-25 12:00:20','512','2020-10-25 12:00:57',10,0),('1','158',158482,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-26 13:31:30','512','2020-10-26 13:31:58',10,0),('1','158',158688,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-26 16:41:48','512','2020-10-26 16:42:15',10,0),('1','158',158848,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-28 14:27:57','512','2020-10-28 14:29:07',10,0),('1','158',159061,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-29 08:00:48','512','2020-10-29 08:01:19',10,0),('1','158',159135,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-29 08:17:54','512','2020-10-29 08:18:20',10,0),('1','158',159143,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'512',0.00,0.00,'512','2020-10-30 08:57:24','512','2020-10-30 08:57:47',10,0),('1','158',159356,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-01 09:15:53','512','2020-11-01 09:16:16',10,0),('1','158',159644,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-01 10:14:30','512','2020-11-01 10:14:59',10,0),('1','158',159645,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-01 16:18:33','512','2020-11-01 16:18:52',10,0),('1','158',159832,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-02 12:37:33','512','2020-11-02 12:38:08',10,0),('1','158',159957,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-03 05:57:09','512','2020-11-03 05:57:34',10,0),('1','158',160029,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-03 13:31:06','512','2020-11-03 13:31:49',10,0),('1','158',160173,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-04 13:46:55','512','2020-11-04 13:47:23',10,0),('1','158',160391,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-07 11:06:47','512','2020-11-07 11:07:10',10,0),('1','158',160667,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-09 13:41:05','512','2020-11-09 13:42:09',10,0),('1','158',161033,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-09 13:46:36','512','2020-11-09 13:47:01',10,0),('1','158',161036,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-09 13:54:58','512','2020-11-09 13:55:22',10,0),('1','158',161042,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-09 14:04:38','512','2020-11-09 14:05:33',10,0),('1','158',161043,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-10 09:21:37','512','2020-11-10 09:22:01',10,0),('1','158',161170,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-11 07:49:25','512','2020-11-11 07:49:49',10,0),('1','158',161312,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-11 16:56:57','512','2020-11-11 16:57:20',10,0),('1','158',161701,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-13 07:44:02','512','2020-11-13 07:44:56',10,0),('1','158',161752,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-16 08:26:39','512','2020-11-16 08:27:14',10,0),('1','158',162267,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-16 08:32:14','512','2020-11-16 08:32:39',10,0),('1','158',162269,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-16 09:03:00','512','2020-11-16 09:04:11',10,0),('1','158',162345,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-17 11:58:38','512','2020-11-17 11:59:04',10,0),('1','158',162561,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-18 10:24:27','512','2020-11-18 10:24:54',10,0),('1','158',163041,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-20 08:45:11','512','2020-11-20 08:45:24',10,0),('1','158',163043,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-20 08:52:28','512','2020-11-20 08:53:09',10,0),('1','158',163100,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-20 15:48:39','512','2020-11-20 15:49:03',10,0),('1','158',163311,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-21 13:08:57','512','2020-11-21 13:09:23',10,0),('1','158',163387,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-22 13:05:13','512','2020-11-22 13:05:38',10,0),('1','158',163716,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-23 16:18:51','512','2020-11-23 16:19:13',10,0),('1','158',163917,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-25 07:53:00','512','2020-11-25 07:53:23',10,0),('1','158',163919,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-25 13:54:07','512','2020-11-25 13:54:41',10,0),('1','158',164372,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-28 08:12:30','512','2020-11-28 08:12:54',10,0),('1','158',164939,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-11-30 16:48:22','512','2020-11-30 16:48:49',10,0),('1','158',164943,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-02 13:43:33','512','2020-12-02 13:43:57',10,0),('1','158',165211,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-02 13:47:35','512','2020-12-02 13:48:18',10,0),('1','158',165214,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-02 13:54:32','512','2020-12-02 13:55:08',10,0),('1','158',165217,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-06 14:09:33','512','2020-12-06 14:09:57',10,0),('1','158',165877,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-06 14:16:40','512','2020-12-06 14:17:09',10,0),('1','158',165881,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-06 14:55:09','512','2020-12-06 14:55:34',10,0),('1','158',165898,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-06 15:05:14','512','2020-12-06 15:05:39',10,0),('1','158',165901,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-13 11:54:41','512','2020-12-13 11:55:03',10,0),('1','158',167101,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-13 12:32:35','512','2020-12-13 12:33:22',10,0),('1','158',167110,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-13 12:49:53','512','2020-12-13 12:50:13',10,0),('1','158',167112,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-13 13:22:32','512','2020-12-13 13:23:00',10,0),('1','158',167120,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 10:40:54','512','2020-12-21 10:41:32',10,0),('1','158',168500,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 11:18:55','512','2020-12-21 11:19:20',10,0),('1','158',168515,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 11:26:10','512','2020-12-21 11:26:34',10,0),('1','158',168517,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 11:34:39','512','2020-12-21 11:35:04',10,0),('1','158',168520,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 12:53:17','512','2020-12-21 12:53:38',10,0),('1','158',168533,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 13:32:32','512','2020-12-21 13:32:56',10,0),('1','158',168539,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 13:39:27','512','2020-12-21 13:40:02',10,0),('1','158',168544,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-21 13:46:55','512','2020-12-21 13:47:17',10,0),('1','158',168561,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-22 08:49:07','512','2020-12-22 08:49:34',10,0),('1','158',168733,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-22 15:37:49','512','2020-12-22 15:38:18',10,0),('1','158',168986,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-24 10:36:36','512','2020-12-24 10:37:03',10,0),('1','158',169155,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-25 10:06:15','512','2020-12-25 10:06:41',10,0),('1','158',169159,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-30 16:24:21','512','2020-12-30 16:24:59',10,0),('1','158',170093,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-30 16:42:13','512','2020-12-30 16:42:38',10,0),('1','158',170097,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-30 16:52:45','512','2020-12-30 16:53:09',10,0),('1','158',170099,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-30 17:02:21','512','2020-12-30 17:02:52',10,0),('1','158',170105,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-30 17:07:01','512','2020-12-30 17:07:30',10,0),('1','158',170107,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-31 10:59:14','512','2020-12-31 10:59:39',10,0),('1','158',170220,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'512',0.00,0.00,'512','2020-12-31 14:02:25','512','2020-12-31 14:02:47',10,0),('1','158',170517,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-02 08:22:09','512','2021-01-02 08:23:08',10,0),('1','158',170579,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-03 09:37:22','512','2021-01-03 09:37:51',10,0),('1','158',170790,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-03 16:35:46','512','2021-01-03 16:36:11',10,0),('1','158',171527,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-07 14:55:31','512','2021-01-07 14:55:57',10,0),('1','158',171532,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-07 15:02:55','512','2021-01-07 15:03:33',10,0),('1','158',171534,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-07 15:17:49','512','2021-01-07 15:18:14',10,0),('1','158',171535,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-08 16:37:34','512','2021-01-08 16:37:59',10,0),('1','158',171739,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-13 09:07:53','512','2021-01-13 09:08:18',10,0),('1','158',172553,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-13 09:14:50','512','2021-01-13 09:15:17',10,0),('1','158',172558,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-13 09:27:56','512','2021-01-13 09:28:23',10,0),('1','158',172559,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-13 09:43:25','512','2021-01-13 09:44:23',10,0),('1','158',172567,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-18 19:51:19','512','2021-01-18 19:51:56',10,0),('1','158',173588,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-18 19:58:58','512','2021-01-18 19:59:32',10,0),('1','158',173590,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-18 20:22:47','512','2021-01-18 20:23:13',10,0),('1','158',173592,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-18 20:32:19','512','2021-01-18 20:32:51',10,0),('1','158',173594,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-21 11:59:38','512','2021-01-21 12:00:07',10,0),('1','158',174034,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-21 12:13:20','512','2021-01-21 12:13:56',10,0),('1','158',174038,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-25 10:26:35','512','2021-01-25 10:28:18',10,0),('1','158',174708,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-25 10:52:35','512','2021-01-25 10:54:40',10,0),('1','158',174713,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-25 11:59:25','512','2021-01-25 11:59:48',10,0),('1','158',174741,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-25 12:06:52','512','2021-01-25 12:07:37',10,0),('1','158',174745,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-29 19:41:08','512','2021-01-29 19:41:54',10,0),('1','158',175590,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-30 09:50:56','512','2021-01-30 09:55:37',10,0),('1','158',175630,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-30 10:12:54','512','2021-01-30 10:13:18',10,0),('1','158',175632,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-30 10:23:39','512','2021-01-30 10:24:04',10,0),('1','158',175635,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-01-30 12:15:56','512','2021-01-30 12:17:26',10,0),('1','158',175655,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-01 10:56:44','512','2021-02-01 10:57:23',10,0),('1','158',176002,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-02 15:45:46','512','2021-02-02 15:46:13',10,0),('1','158',176270,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-02 15:52:09','512','2021-02-02 15:52:37',10,0),('1','158',176273,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-02 15:58:35','512','2021-02-02 15:59:01',10,0),('1','158',176643,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-04 13:57:06','512','2021-02-04 13:57:49',10,0),('1','158',176657,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-05 12:15:56','512','2021-02-05 12:16:24',10,0),('1','158',176862,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-06 19:34:01','512','2021-02-06 19:34:44',10,0),('1','158',177212,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-09 16:54:14','512','2021-02-09 16:54:44',10,0),('1','158',177836,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-09 17:02:15','512','2021-02-09 17:02:50',10,0),('1','158',177838,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-09 17:12:44','512','2021-02-09 17:13:18',10,0),('1','158',177844,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-12 12:10:28','512','2021-02-12 12:10:54',10,0),('1','158',178370,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-12 13:19:52','512','2021-02-12 13:20:18',10,0),('1','158',178380,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-15 09:39:28','512','2021-02-15 09:39:54',10,0),('1','158',178968,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-15 09:58:06','512','2021-02-15 09:58:31',10,0),('1','158',178977,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-16 15:52:24','512','2021-02-16 15:52:50',10,0),('1','158',179321,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-16 16:06:47','512','2021-02-16 16:07:21',10,0),('1','158',179327,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-16 16:11:06','512','2021-02-16 16:11:27',10,0),('1','158',179330,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-17 14:39:32','512','2021-02-17 14:39:56',10,0),('1','158',179495,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-19 16:09:19','512','2021-02-19 16:10:19',10,0),('1','158',179949,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-19 16:17:46','512','2021-02-19 16:18:21',10,0),('1','158',179952,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-21 14:24:24','512','2021-02-21 14:24:49',10,0),('1','158',180269,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-21 14:30:30','512','2021-02-21 14:41:19',10,0),('1','158',180275,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-24 11:11:00','512','2021-02-24 11:11:23',10,0),('1','158',180831,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-24 11:18:41','512','2021-02-24 11:19:07',10,0),('1','158',180834,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-24 11:24:55','512','2021-02-24 11:25:17',10,0),('1','158',180835,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-24 11:43:53','512','2021-02-24 11:44:27',10,0),('1','158',180839,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-28 13:41:16','512','2021-02-28 13:41:41',10,0),('1','158',181623,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-28 13:50:13','512','2021-02-28 13:50:42',10,0),('1','158',181630,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-28 13:57:27','512','2021-02-28 13:58:00',10,0),('1','158',181633,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-02-28 14:06:32','512','2021-02-28 14:07:13',10,0),('1','158',181640,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-17 12:32:30','512','2021-03-17 12:33:11',10,0),('1','158',184998,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-17 15:01:15','512','2021-03-17 15:01:37',10,0),('1','158',185035,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-17 15:16:43','512','2021-03-17 15:17:06',10,0),('1','158',185037,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-17 16:30:31','512','2021-03-17 16:31:17',10,0),('1','158',185058,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-17 16:41:01','512','2021-03-17 16:41:36',10,0),('1','158',185064,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 10:01:58','512','2021-03-18 10:02:20',10,0),('1','158',185158,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 10:07:50','512','2021-03-18 10:08:11',10,0),('1','158',185159,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 10:13:48','512','2021-03-18 10:14:09',10,0),('1','158',185160,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 11:28:03','512','2021-03-18 11:28:25',10,0),('1','158',185181,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 13:25:27','512','2021-03-18 13:26:02',10,0),('1','158',185202,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 13:43:11','512','2021-03-18 13:43:51',10,0),('1','158',185207,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 14:03:19','512','2021-03-18 14:03:58',10,0),('1','158',185208,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 14:21:48','512','2021-03-18 14:22:09',10,0),('1','158',185214,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 14:30:19','512','2021-03-18 14:30:41',10,0),('1','158',185217,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-18 14:50:43','512','2021-03-18 14:51:03',10,0),('1','158',185218,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-19 10:42:08','512','2021-03-19 10:42:37',10,0),('1','158',185314,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-19 10:54:08','512','2021-03-19 10:54:32',10,0),('1','158',185316,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-19 11:07:28','512','2021-03-19 11:07:51',10,0),('1','158',185317,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-21 17:07:46','512','2021-03-21 17:08:07',10,0),('1','158',185828,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-21 17:24:49','512','2021-03-21 17:25:12',10,0),('1','158',185831,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-22 09:44:14','512','2021-03-22 09:44:39',10,0),('1','158',185931,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-23 10:04:08','512','2021-03-23 10:04:30',10,0),('1','158',186150,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-23 10:14:54','512','2021-03-23 10:15:24',10,0),('1','158',186155,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-24 11:31:25','512','2021-03-24 11:31:53',10,0),('1','158',186417,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-25 12:38:41','512','2021-03-25 12:39:08',10,0),('1','158',186628,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-26 15:40:57','512','2021-03-26 15:41:26',10,0),('1','158',186906,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-27 09:00:01','512','2021-03-27 09:00:51',10,0),('1','158',187210,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-28 09:50:31','512','2021-03-28 09:50:55',10,0),('1','158',187215,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-31 17:14:49','512','2021-03-31 17:15:14',10,0),('1','158',187969,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-31 17:24:24','512','2021-03-31 17:24:53',10,0),('1','158',187972,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-03-31 17:37:07','512','2021-03-31 17:37:34',10,0),('1','158',187975,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-01 12:29:32','512','2021-04-01 12:30:00',10,0),('1','158',188119,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-04 08:15:35','512','2021-04-04 08:16:28',10,0),('1','158',188636,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-04 08:39:18','512','2021-04-04 08:39:44',10,0),('1','158',188644,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-07 13:57:15','512','2021-04-07 13:58:18',10,0),('1','158',189329,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-08 10:34:14','512','2021-04-08 10:34:35',10,0),('1','158',189491,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-08 10:56:44','512','2021-04-08 10:57:06',10,0),('1','158',189500,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-08 11:08:21','512','2021-04-08 11:08:41',10,0),('1','158',189501,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-08 11:37:28','512','2021-04-08 11:37:52',10,0),('1','158',189506,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-09 16:39:40','512','2021-04-09 16:40:05',10,0),('1','158',189769,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-11 11:07:54','512','2021-04-11 11:08:24',10,0),('1','158',190094,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-11 11:26:56','512','2021-04-11 11:27:19',10,0),('1','158',190097,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-12 10:51:40','512','2021-04-12 10:52:04',10,0),('1','158',190781,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-14 13:11:02','512','2021-04-14 13:11:30',10,0),('1','158',190791,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-17 14:53:05','512','2021-04-17 14:53:29',10,0),('1','158',191437,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-17 15:58:34','512','2021-04-17 16:00:09',10,0),('1','158',191450,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-17 16:19:02','512','2021-04-17 16:19:28',10,0),('1','158',191456,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-19 10:48:29','512','2021-04-19 10:49:00',10,0),('1','158',191795,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-19 12:54:32','512','2021-04-19 12:55:04',10,0),('1','158',191843,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-20 13:14:28','512','2021-04-20 13:14:57',10,0),('1','158',192049,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-22 11:49:25','512','2021-04-22 11:49:55',10,0),('1','158',192450,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-22 12:00:10','512','2021-04-22 12:00:39',10,0),('1','158',192455,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-24 09:32:01','512','2021-04-24 09:32:32',10,0),('1','158',192795,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-24 09:41:13','512','2021-04-24 09:42:18',10,0),('1','158',192799,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-25 11:09:06','512','2021-04-25 11:10:06',10,0),('1','158',193029,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-25 11:15:08','512','2021-04-25 11:15:34',10,0),('1','158',193030,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-25 11:26:45','512','2021-04-25 11:27:15',10,0),('1','158',193035,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-27 11:45:14','512','2021-04-27 11:46:05',10,0),('1','158',193499,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-27 11:56:03','512','2021-04-27 11:56:50',10,0),('1','158',193503,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-04-28 10:42:00','512','2021-04-28 14:47:44',10,0),('1','158',193776,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-01 09:40:37','512','2021-05-01 09:41:19',10,0),('1','158',194356,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-01 09:48:36','512','2021-05-01 09:48:56',10,0),('1','158',194358,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-02 11:15:13','512','2021-05-02 11:15:42',10,0),('1','158',194558,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-02 11:21:11','512','2021-05-02 11:21:33',10,0),('1','158',194559,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-05 11:29:04','512','2021-05-05 11:29:37',10,0),('1','158',195187,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-07 11:27:50','512','2021-05-07 11:28:16',10,0),('1','158',195645,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-07 11:35:31','512','2021-05-07 11:37:05',10,0),('1','158',195648,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-07 11:53:05','512','2021-05-07 11:53:46',10,0),('1','158',195654,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-07 12:10:58','512','2021-05-07 12:11:28',10,0),('1','158',195657,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-18 15:51:32','512','2021-05-18 15:51:54',10,0),('1','158',198057,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-18 15:55:34','512','2021-05-18 15:55:55',10,0),('1','158',198059,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-18 16:04:13','512','2021-05-18 16:04:39',10,0),('1','158',198060,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-18 16:23:53','512','2021-05-18 16:24:19',10,0),('1','158',198065,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 10:14:24','512','2021-05-19 10:14:49',10,0),('1','158',198190,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 10:30:42','512','2021-05-19 10:31:05',10,0),('1','158',198199,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 10:44:47','512','2021-05-19 10:45:10',10,0),('1','158',198202,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 11:06:26','512','2021-05-19 11:07:15',10,0),('1','158',198211,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 11:21:54','512','2021-05-19 11:22:17',10,0),('1','158',198218,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-19 11:28:23','512','2021-05-19 11:28:44',10,0),('1','158',198221,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-25 07:54:42','512','2021-05-25 07:55:03',10,0),('1','158',199470,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-25 07:58:30','512','2021-05-25 07:58:55',10,0),('1','158',199472,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-25 08:04:20','512','2021-05-25 08:04:41',10,0),('1','158',199476,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-25 08:24:39','512','2021-05-25 08:25:01',10,0),('1','158',199483,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-26 10:37:16','512','2021-05-26 10:37:39',10,0),('1','158',199764,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-28 10:40:47','512','2021-05-28 10:41:09',10,0),('1','158',200181,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-05-28 10:51:17','512','2021-05-28 10:51:40',10,0),('1','158',200185,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-01 13:17:09','512','2021-06-01 13:17:32',10,0),('1','158',201027,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-01 13:24:04','512','2021-06-01 13:24:27',10,0),('1','158',201029,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-01 13:28:36','512','2021-06-01 13:29:15',10,0),('1','158',201031,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-04 16:25:39','512','2021-06-04 16:26:03',10,0),('1','158',201698,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-04 16:29:14','512','2021-06-04 16:29:33',10,0),('1','158',201700,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-04 16:46:04','512','2021-06-04 16:46:26',10,0),('1','158',201704,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-04 16:58:20','512','2021-06-04 16:58:42',10,0),('1','158',201708,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-05 16:32:27','512','2021-06-05 16:32:49',10,0),('1','158',201958,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-05 16:51:25','512','2021-06-05 16:51:48',10,0),('1','158',201963,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-06 10:13:34','512','2021-06-06 10:13:54',10,0),('1','158',202085,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-07 11:55:57','512','2021-06-07 11:56:21',10,0),('1','158',202323,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-08 14:36:23','512','2021-06-08 14:36:44',10,0),('1','158',202566,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-09 11:27:50','512','2021-06-09 11:28:24',10,0),('1','158',202743,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-10 13:33:04','512','2021-06-10 13:33:26',10,0),('1','158',203002,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-12 09:17:54','512','2021-06-12 09:18:19',10,0),('1','158',203353,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-12 15:41:35','512','2021-06-12 15:41:57',10,0),('1','158',203465,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-14 10:57:02','512','2021-06-14 10:57:23',10,0),('1','158',203821,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-15 11:41:21','512','2021-06-15 11:41:45',10,0),('1','158',204065,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-15 11:59:12','512','2021-06-15 11:59:33',10,0),('1','158',204068,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-21 20:39:45','512','2021-06-21 20:40:29',10,0),('1','158',205452,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-21 21:15:30','512','2021-06-21 21:16:11',10,0),('1','158',205456,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-21 21:36:40','512','2021-06-21 21:37:34',10,0),('1','158',205457,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-22 10:06:45','512','2021-06-22 10:07:07',10,0),('1','158',205550,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-22 10:32:57','512','2021-06-22 10:33:24',10,0),('1','158',205557,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-22 10:54:20','512','2021-06-22 10:54:42',10,0),('1','158',205564,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-23 11:45:58','512','2021-06-23 11:46:20',10,0),('1','158',205829,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-24 08:01:24','512','2021-06-24 08:01:59',10,0),('1','158',205980,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-25 15:31:07','512','2021-06-25 15:31:27',10,0),('1','158',206303,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-25 15:33:05','512','2021-06-25 15:33:29',10,0),('1','158',206305,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-25 15:40:43','512','2021-06-25 15:41:01',10,0),('1','158',206308,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-27 09:08:26','512','2021-06-27 09:08:49',10,0),('1','158',206619,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-28 10:20:34','512','2021-06-28 10:20:56',10,0),('1','158',206900,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-29 14:18:02','512','2021-06-29 14:18:38',10,0),('1','158',207178,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-06-29 14:30:17','512','2021-06-29 14:30:44',10,0),('1','158',207184,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-01 13:47:45','512','2021-07-01 13:48:13',10,0),('1','158',207605,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-01 13:54:05','512','2021-07-01 13:54:39',10,0),('1','158',207607,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-03 09:33:46','512','2021-07-03 09:34:08',10,0),('1','158',207966,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-03 09:51:01','512','2021-07-03 09:51:23',10,0),('1','158',207974,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-04 09:37:58','512','2021-07-04 09:38:34',10,0),('1','158',208175,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-05 12:52:11','512','2021-07-05 12:52:39',10,0),('1','158',208453,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-07 13:00:15','512','2021-07-07 13:00:46',10,0),('1','158',208891,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-07 13:08:25','512','2021-07-07 13:08:59',10,0),('1','158',208894,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-09 13:43:21','512','2021-07-09 13:43:51',10,0),('1','158',209341,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-09 14:03:53','512','2021-07-09 14:04:24',10,0),('1','158',209348,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-12 10:29:42','512','2021-07-12 10:30:13',10,0),('1','158',209953,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-12 11:02:54','512','2021-07-12 11:03:12',10,0),('1','158',209969,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-13 09:38:05','512','2021-07-13 09:38:30',10,0),('1','158',210172,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-13 11:34:07','512','2021-07-13 11:34:29',10,0),('1','158',210202,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-16 11:41:30','512','2021-07-16 11:41:49',10,0),('1','158',210837,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-16 11:57:28','512','2021-07-16 11:57:44',10,0),('1','158',210840,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-16 12:10:04','512','2021-07-16 12:10:22',10,0),('1','158',210843,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-19 15:18:29','512','2021-07-19 15:18:46',10,0),('1','158',211538,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-19 15:32:08','512','2021-07-19 15:32:23',10,0),('1','158',211546,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-21 09:12:11','512','2021-07-21 09:12:28',10,0),('1','158',211832,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-21 09:42:10','512','2021-07-21 09:42:26',10,0),('1','158',211837,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-21 09:47:15','512','2021-07-21 09:47:30',10,0),('1','158',211841,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-23 10:33:14','512','2021-07-23 10:33:34',10,0),('1','158',212317,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-27 10:25:06','512','2021-07-27 10:25:31',10,0),('1','158',213231,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-27 10:38:06','512','2021-07-27 10:39:04',10,0),('1','158',213236,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-27 10:52:16','512','2021-07-27 10:52:46',10,0),('1','158',213240,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-27 11:11:23','512','2021-07-27 11:11:38',10,0),('1','158',213251,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-27 11:21:31','512','2021-07-27 11:21:51',10,0),('1','158',213334,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-30 11:56:17','512','2021-07-30 11:56:33',10,0),('1','158',213992,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-30 12:17:17','512','2021-07-30 12:17:35',10,0),('1','158',213997,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-07-30 12:45:13','512','2021-07-30 12:45:39',10,0),('1','158',214002,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-02 12:27:45','512','2021-08-02 12:28:08',10,0),('1','158',214661,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-02 13:38:10','512','2021-08-02 13:38:29',10,0),('1','158',214683,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-06 10:47:29','512','2021-08-06 10:47:49',10,0),('1','158',215539,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-06 11:16:45','512','2021-08-06 11:17:11',10,0),('1','158',215554,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-06 11:31:24','512','2021-08-06 11:31:45',10,0),('1','158',215557,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-06 12:13:23','512','2021-08-06 12:13:46',10,0),('1','158',215562,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-06 12:59:59','512','2021-08-06 13:00:33',10,0),('1','158',215574,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-08 10:55:14','512','2021-08-08 10:55:42',10,0),('1','158',215977,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-11 11:18:22','512','2021-08-11 11:18:49',10,0),('1','158',216644,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-11 11:24:12','512','2021-08-11 11:24:32',10,0),('1','158',216645,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-11 11:41:59','512','2021-08-11 11:42:20',10,0),('1','158',216652,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-11 12:42:53','512','2021-08-11 12:43:18',10,0),('1','158',216664,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-12 06:45:01','512','2021-08-12 06:45:29',10,0),('1','158',216792,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-14 10:43:35','512','2021-08-14 10:43:54',10,0),('1','158',217369,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-16 12:46:01','512','2021-08-16 12:46:47',10,0),('1','158',217865,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-16 13:11:34','512','2021-08-16 13:12:00',10,0),('1','158',217877,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-16 13:38:51','512','2021-08-16 13:39:31',10,0),('1','158',217884,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-17 12:23:41','512','2021-08-17 12:24:41',10,0),('1','158',218100,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-18 14:16:47','512','2021-08-18 14:17:10',10,0),('1','158',218374,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-20 08:30:12','512','2021-08-20 08:30:29',10,0),('1','158',218722,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-21 10:36:01','512','2021-08-21 10:36:30',10,0),('1','158',218968,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-21 12:28:57','512','2021-08-21 12:29:15',10,0),('1','158',219005,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-22 17:12:06','512','2021-08-22 17:13:27',10,0),('1','158',219292,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 10:14:05','512','2021-08-30 10:14:35',10,0),('1','158',221006,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 10:26:52','512','2021-08-30 10:27:16',10,0),('1','158',221011,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 10:31:51','512','2021-08-30 10:32:11',10,0),('1','158',221015,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 10:36:57','512','2021-08-30 10:37:18',10,0),('1','158',221021,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 10:55:49','512','2021-08-30 10:56:41',10,0),('1','158',221024,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 11:22:36','512','2021-08-30 11:23:03',10,0),('1','158',221032,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-30 11:30:51','512','2021-08-30 11:32:12',10,0),('1','158',221033,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-08-31 11:08:42','512','2021-08-31 11:08:58',10,0),('1','158',221256,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-01 13:59:54','512','2021-09-01 14:00:27',10,0),('1','158',221524,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-01 14:11:03','512','2021-09-01 14:11:21',10,0),('1','158',221529,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-03 09:15:12','512','2021-09-03 09:15:39',10,0),('1','158',221881,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-03 09:30:46','512','2021-09-03 09:31:14',10,0),('1','158',221888,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-04 13:17:35','512','2021-09-04 13:17:54',10,0),('1','158',222169,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-05 16:58:37','512','2021-09-05 16:58:58',10,0),('1','158',222446,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-09 10:15:25','512','2021-09-09 10:15:46',10,0),('1','158',223259,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-09 10:23:55','512','2021-09-09 10:24:14',10,0),('1','158',223263,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-09 10:39:23','512','2021-09-09 10:39:44',10,0),('1','158',223269,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-10 06:53:17','512','2021-09-10 06:53:36',10,0),('1','158',223428,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-11 13:24:26','512','2021-09-11 13:24:47',10,0),('1','158',223789,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-11 13:33:04','512','2021-09-11 13:33:27',10,0),('1','158',223791,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-12 15:00:49','512','2021-09-12 15:01:07',10,0),('1','158',224013,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-13 10:11:55','512','2021-09-13 10:12:24',10,0),('1','158',224159,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-16 12:58:20','512','2021-09-16 12:58:41',10,0),('1','158',224909,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-16 14:15:19','512','2021-09-16 14:15:55',10,0),('1','158',224941,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-16 14:52:18','512','2021-09-16 14:52:38',10,0),('1','158',224947,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-18 11:06:28','512','2021-09-18 11:09:54',10,0),('1','158',225365,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-19 14:09:36','512','2021-09-19 14:10:12',10,0),('1','158',225607,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-20 14:34:32','512','2021-09-20 14:34:53',10,0),('1','158',225885,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-20 14:59:06','512','2021-09-20 15:01:14',10,0),('1','158',225897,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-22 10:07:31','512','2021-09-22 10:07:50',10,0),('1','158',226302,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-23 14:47:35','512','2021-09-23 14:47:53',10,0),('1','158',226653,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-24 07:07:02','512','2021-09-24 07:07:24',10,0),('1','158',226753,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-26 09:05:53','512','2021-09-26 09:06:20',10,0),('1','158',227226,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-26 09:14:27','512','2021-09-26 09:14:50',10,0),('1','158',227229,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-27 11:41:36','512','2021-09-27 11:42:02',10,0),('1','158',227489,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-27 12:58:01','512','2021-09-27 12:58:24',10,0),('1','158',227510,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-28 11:45:14','512','2021-09-28 11:45:42',10,0),('1','158',227716,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-29 13:14:16','512','2021-09-29 13:14:40',10,0),('1','158',227991,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-09-30 10:10:02','512','2021-09-30 10:10:19',10,0),('1','158',228178,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-01 15:58:11','512','2021-10-01 15:58:28',10,0),('1','158',228485,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-02 10:47:52','512','2021-10-02 10:48:10',10,0),('1','158',228593,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-04 10:27:32','512','2021-10-04 10:28:04',10,0),('1','158',229017,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-04 13:55:21','512','2021-10-04 13:55:42',10,0),('1','158',229064,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-05 11:10:29','512','2021-10-05 11:11:13',10,0),('1','158',229257,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 09:32:00','512','2021-10-13 09:32:21',10,0),('1','158',231133,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 09:48:54','512','2021-10-13 09:49:11',10,0),('1','158',231138,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 10:04:16','512','2021-10-13 10:04:35',10,0),('1','158',231145,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 10:25:30','512','2021-10-13 10:25:50',10,0),('1','158',231155,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 10:29:45','512','2021-10-13 10:30:01',10,0),('1','158',231157,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 11:10:33','512','2021-10-13 11:10:51',10,0),('1','158',231170,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 11:24:13','512','2021-10-13 11:24:31',10,0),('1','158',231174,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-13 14:16:38','512','2021-10-13 14:16:55',10,0),('1','158',231250,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-15 08:34:02','512','2021-10-15 08:34:20',10,0),('1','158',231686,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-15 15:09:06','512','2021-10-15 15:09:23',10,0),('1','158',231823,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-17 14:29:36','512','2021-10-17 14:29:57',10,0),('1','158',232245,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-17 14:41:45','512','2021-10-17 14:42:01',10,0),('1','158',232249,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-19 07:01:26','512','2021-10-19 07:01:53',10,0),('1','158',232611,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-19 10:00:35','512','2021-10-19 10:00:54',10,0),('1','158',232679,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-21 11:42:25','512','2021-10-21 11:42:43',10,0),('1','158',233235,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-21 11:48:27','512','2021-10-21 11:48:44',10,0),('1','158',233236,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-22 14:01:22','512','2021-10-22 14:01:43',10,0),('1','158',233510,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-23 10:40:40','512','2021-10-23 10:41:00',10,0),('1','158',233696,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-24 13:36:37','512','2021-10-24 13:36:53',10,0),('1','158',233944,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-26 09:27:09','512','2021-10-26 09:27:33',10,0),('1','158',234391,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-27 10:36:31','512','2021-10-27 10:37:09',10,0),('1','158',234685,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-27 10:48:10','512','2021-10-27 10:48:34',10,0),('1','158',234686,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-29 09:21:54','512','2021-10-29 09:22:13',10,0),('1','158',235153,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-10-29 13:42:19','512','2021-10-29 13:42:36',10,0),('1','158',235213,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-01 10:47:04','512','2021-11-01 10:47:27',10,0),('1','158',235868,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-01 11:21:18','512','2021-11-01 11:21:43',10,0),('1','158',235882,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-01 11:41:48','512','2021-11-01 11:42:03',10,0),('1','158',235886,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-03 10:15:49','512','2021-11-03 10:16:07',10,0),('1','158',236348,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-03 10:34:36','512','2021-11-03 10:34:57',10,0),('1','158',236354,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-04 13:51:48','512','2021-11-04 13:52:06',10,0),('1','158',236650,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-05 15:48:56','512','2021-11-05 15:49:17',10,0),('1','158',236880,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-07 10:13:13','512','2021-11-07 10:13:30',10,0),('1','158',237249,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-08 10:29:26','512','2021-11-08 10:29:40',10,0),('1','158',237483,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-09 09:47:45','512','2021-11-09 09:48:00',10,0),('1','158',237693,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-10 10:44:01','512','2021-11-10 10:44:16',10,0),('1','158',237980,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-10 13:13:59','512','2021-11-10 13:14:13',10,0),('1','158',238017,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-11 08:24:38','512','2021-11-11 08:25:25',10,0),('1','158',238187,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-22 16:47:13','512','2021-11-22 16:47:32',10,0),('1','158',240885,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-23 09:17:56','512','2021-11-23 09:18:14',10,0),('1','158',241050,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-23 12:32:10','512','2021-11-23 12:32:26',10,0),('1','158',241099,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-24 09:52:19','512','2021-11-24 09:52:37',10,0),('1','158',241330,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-24 10:25:36','512','2021-11-24 10:25:52',10,0),('1','158',241334,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-24 11:31:02','512','2021-11-24 11:31:19',10,0),('1','158',241344,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-24 11:49:35','512','2021-11-24 11:49:52',10,0),('1','158',241348,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-24 12:49:49','512','2021-11-24 12:50:07',10,0),('1','158',241360,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-25 09:19:59','512','2021-11-25 09:20:17',10,0),('1','158',241573,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-25 09:27:21','512','2021-11-25 09:27:39',10,0),('1','158',241578,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-25 10:09:44','512','2021-11-25 10:10:01',10,0),('1','158',241587,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-25 10:15:43','512','2021-11-25 10:16:02',10,0),('1','158',241589,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-25 10:31:17','512','2021-11-25 10:31:55',10,0),('1','158',241594,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-26 09:39:45','512','2021-11-26 09:40:01',10,0),('1','158',241826,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-27 07:50:49','512','2021-11-27 07:51:08',10,0),('1','158',242014,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-28 09:45:44','512','2021-11-28 09:45:58',10,0),('1','158',242273,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-28 10:28:36','512','2021-11-28 10:28:54',10,0),('1','158',242284,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-30 11:58:07','512','2021-11-30 11:58:27',10,0),('1','158',242790,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'512',0.00,0.00,'512','2021-11-30 12:05:01','512','2021-11-30 12:07:02',10,0),('1','158',242791,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-02 09:39:09','512','2021-12-02 09:39:25',10,0),('1','158',243225,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-02 09:46:01','512','2021-12-02 09:46:26',10,0),('1','158',243227,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-04 09:00:21','512','2021-12-04 09:00:37',10,0),('1','158',243666,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-05 11:46:24','512','2021-12-05 11:46:44',10,0),('1','158',243923,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-05 11:53:38','512','2021-12-05 11:53:55',10,0),('1','158',243927,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-07 13:16:29','512','2021-12-07 13:16:44',10,0),('1','158',244417,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-07 13:21:04','512','2021-12-07 13:21:18',10,0),('1','158',244419,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-09 14:33:25','512','2021-12-09 14:33:40',10,0),('1','158',244887,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-09 14:42:08','512','2021-12-09 14:42:22',10,0),('1','158',244893,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-10 15:59:33','512','2021-12-10 15:59:48',10,0),('1','158',245143,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-12 11:55:03','512','2021-12-12 11:55:16',10,0),('1','158',245534,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-12 12:38:18','512','2021-12-12 12:38:31',10,0),('1','158',245543,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-13 11:09:07','512','2021-12-13 11:09:52',10,0),('1','158',245767,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-14 14:36:28','512','2021-12-14 14:36:46',10,0),('1','158',246092,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-16 11:12:27','512','2021-12-16 11:12:42',10,0),('1','158',246561,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-17 08:53:02','512','2021-12-17 08:53:19',10,0),('1','158',246772,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-18 11:05:47','512','2021-12-18 11:11:48',10,0),('1','158',247033,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-18 11:52:50','512','2021-12-18 11:53:11',10,0),('1','158',247042,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-19 13:59:28','512','2021-12-19 13:59:40',10,0),('1','158',247305,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-20 12:54:47','512','2021-12-20 12:55:03',10,0),('1','158',247525,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-21 14:11:22','512','2021-12-21 14:11:36',10,0),('1','158',247808,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-28 12:33:58','512','2021-12-28 12:34:31',10,0),('1','158',249463,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-28 12:47:30','512','2021-12-28 12:47:57',10,0),('1','158',249468,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-28 13:08:12','512','2021-12-28 13:09:03',10,0),('1','158',249479,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-29 13:04:07','512','2021-12-29 13:04:20',10,0),('1','158',249734,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-29 13:22:41','512','2021-12-29 13:23:03',10,0),('1','158',249739,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-29 13:47:03','512','2021-12-29 13:47:17',10,0),('1','158',249741,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-29 14:10:43','512','2021-12-29 14:10:59',10,0),('1','158',249748,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'512',0.00,0.00,'512','2021-12-29 14:15:26','512','2021-12-29 14:15:40',10,0),('1','158',254556,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-18 12:27:41','512','2022-01-18 12:28:02',10,0),('1','158',254562,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-18 12:41:46','512','2022-01-18 12:42:05',10,0),('1','158',255294,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 15:59:06','512','2022-01-21 15:59:23',10,0),('1','158',255354,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 16:59:38','512','2022-01-21 16:59:51',10,0),('1','158',255371,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 17:03:52','512','2022-01-21 17:04:04',10,0),('1','158',255372,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 17:22:32','512','2022-01-21 17:22:46',10,0),('1','158',255378,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 17:38:29','512','2022-01-21 17:38:44',10,0),('1','158',255383,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 17:47:50','512','2022-01-21 17:48:02',10,0),('1','158',255385,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 20:17:51','512','2022-01-21 20:18:05',10,0),('1','158',255415,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 20:43:59','512','2022-01-21 20:44:15',10,0),('1','158',255419,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 21:11:21','512','2022-01-21 21:11:35',10,0),('1','158',255426,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 21:31:50','512','2022-01-21 21:32:05',10,0),('1','158',255432,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 22:14:28','512','2022-01-21 22:14:52',10,0),('1','158',255434,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 22:32:31','512','2022-01-21 22:32:54',10,0),('1','158',255438,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-21 22:50:27','512','2022-01-21 22:50:48',10,0),('1','158',255441,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 07:38:29','512','2022-01-22 07:39:07',10,0),('1','158',255475,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 07:49:28','512','2022-01-22 07:49:40',10,0),('1','158',255481,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 07:57:26','512','2022-01-22 07:58:00',10,0),('1','158',255485,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 09:05:58','512','2022-01-22 09:09:27',10,0),('1','158',255510,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 09:50:01','512','2022-01-22 09:50:27',10,0),('1','158',255522,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 10:18:36','512','2022-01-22 10:19:05',10,0),('1','158',255529,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 10:28:30','512','2022-01-22 10:28:49',10,0),('1','158',255533,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 11:55:36','512','2022-01-22 11:56:15',10,0),('1','158',255561,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-22 12:31:59','512','2022-01-22 12:32:18',10,0),('1','158',255570,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-24 09:26:40','512','2022-01-24 09:26:56',10,0),('1','158',256015,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-25 13:12:26','512','2022-01-25 13:12:49',10,0),('1','158',256333,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-26 14:54:46','512','2022-01-26 14:55:04',10,0),('1','158',256626,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-26 15:03:09','512','2022-01-26 15:03:29',10,0),('1','158',256630,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-27 18:04:42','512','2022-01-27 18:04:59',10,0),('1','158',256890,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-29 08:06:25','512','2022-01-29 08:06:39',10,0),('1','158',257262,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-31 14:07:01','512','2022-01-31 14:07:15',10,0),('1','158',257263,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'512',0.00,0.00,'512','2022-01-31 14:44:34','512','2022-01-31 14:44:49',10,0),('1','158',257264,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-01 13:01:24','512','2022-02-01 13:01:39',10,0),('1','158',257265,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-01 17:21:13','512','2022-02-01 17:21:25',10,0),('1','158',257266,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-03 14:10:14','512','2022-02-03 14:10:28',10,0),('1','158',257267,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-03 15:16:09','512','2022-02-03 15:16:23',10,0),('1','158',257268,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-04 11:50:23','512','2022-02-04 11:50:38',10,0),('1','158',257269,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-05 16:01:50','512','2022-02-05 16:02:03',10,0),('1','158',257270,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-07 18:15:12','512','2022-02-07 18:15:26',10,0),('1','158',257271,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-08 13:05:32','512','2022-02-08 13:05:57',10,0),('1','158',257272,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-09 08:28:00','512','2022-02-09 08:28:15',10,0),('1','158',257273,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-10 12:11:41','512','2022-02-10 12:11:55',10,0),('1','158',257274,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-10 14:34:53','512','2022-02-10 14:35:09',10,0),('1','158',257275,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-16 12:49:06','512','2022-02-16 12:49:20',10,0),('1','158',257276,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-16 13:08:01','512','2022-02-16 13:08:17',10,0),('1','158',257277,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-16 20:53:40','512','2022-02-16 20:53:57',10,0),('1','158',257278,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-17 15:34:32','512','2022-02-17 15:34:47',10,0),('1','158',257279,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-17 15:44:11','512','2022-02-17 15:44:25',10,0),('1','158',257280,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-17 22:07:27','512','2022-02-17 22:07:44',10,0),('1','158',257281,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-18 11:23:49','512','2022-02-18 11:24:04',10,0),('1','158',257282,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-21 14:11:02','512','2022-02-21 14:11:17',10,0),('1','158',257283,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-21 14:44:17','512','2022-02-21 14:44:32',10,0),('1','158',257284,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-21 15:10:33','512','2022-02-21 15:10:47',10,0),('1','158',257285,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-21 16:05:56','512','2022-02-21 16:06:10',10,0),('1','158',257286,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'512',0.00,0.00,'512','2022-02-22 13:00:36','512','2022-02-22 13:00:49',10,0),('1','158',257287,'DAILY SHIFT','2022-02-22','2022-02-22 13:01:05','2022-02-23 13:01:05','512',0.00,0.00,'512','2022-02-24 14:00:55','512','2022-02-24 14:01:11',10,0),('1','158',257288,'DAILY SHIFT','2022-02-22','2022-02-24 14:01:33','2022-02-25 14:01:33','512',0.00,0.00,'512','2022-02-24 14:15:56','512','2022-02-24 14:16:12',10,0),('1','158',257289,'DAILY SHIFT','2022-02-23','2022-02-24 14:16:48','2022-03-03 14:16:48','512',0.00,0.00,'512','2022-02-24 14:23:00','512','2022-02-24 14:23:17',10,0),('1','158',257290,'DAILY SHIFT','2022-02-24','2022-02-24 14:24:09','2022-02-25 14:24:09','512',0.00,0.00,'512','2022-02-25 17:40:15','512','2022-02-25 17:40:32',10,0),('1','158',257291,'DAILY SHIFT','2022-02-24','2022-02-25 17:40:53','2022-02-26 17:40:53','512',0.00,0.00,'512','2022-02-25 17:44:47','512','2022-02-25 17:45:02',10,0),('1','158',257292,'DAILY SHIFT','2022-02-25','2022-02-25 17:45:28','2022-02-28 17:45:28','512',0.00,0.00,'512','2022-02-26 14:39:24','512','2022-02-26 14:39:39',10,0),('1','158',257293,'DAILY SHIFT','2022-02-26','2022-02-26 14:40:02','2022-03-01 14:40:02','512',0.00,0.00,'512','2022-02-27 10:01:59','512','2022-02-27 10:02:15',10,0),('1','158',257294,'DAILY SHIFT','2022-02-27','2022-02-27 10:02:39','2022-03-02 10:02:39','512',0.00,0.00,'512','2022-03-01 08:16:05','512','2022-03-01 08:16:18',10,0),('1','158',257295,'DAILY SHIFT','2022-02-28','2022-03-01 08:16:39','2022-03-02 08:16:39','512',0.00,0.00,'512','2022-03-02 08:30:03','512','2022-03-02 08:30:18',10,0),('1','158',257296,'DAILY SHIFT','2022-02-28','2022-03-02 08:30:57','2022-03-05 08:30:57','512',0.00,0.00,'512','2022-03-02 08:37:16','512','2022-03-02 08:37:30',10,0),('1','158',257297,'DAILY SHIFT','2022-03-01','2022-03-02 08:38:00','2022-03-05 08:38:00','512',0.00,0.00,'512','2022-03-03 08:58:14','512','2022-03-03 08:58:38',10,0),('1','158',257298,'DAILY SHIFT','2022-03-02','2022-03-03 08:59:05','2022-03-04 08:59:05','512',0.00,0.00,'512','2022-03-03 09:54:43','512','2022-03-03 09:55:03',10,0),('1','158',257299,'DAILY SHIFT','2022-03-03','2022-03-03 09:55:25','2022-03-04 09:55:25','512',0.00,0.00,'512','2022-03-04 11:26:49','512','2022-03-04 11:27:04',10,0),('1','158',257300,'DAILY SHIFT','2022-03-03','2022-03-04 11:27:29','2022-03-07 11:27:29','512',0.00,0.00,'512','2022-03-04 11:34:04','512','2022-03-04 11:34:21',10,0),('1','158',257301,'DAILY SHIFT','2022-03-04','2022-03-04 11:34:43','2022-03-07 11:34:43','512',0.00,0.00,'512','2022-03-06 12:55:26','512','2022-03-06 12:55:50',10,0),('1','158',257302,'DAILY SHIFT','2022-03-05','2022-03-06 12:57:04','2022-03-09 12:57:04','512',0.00,0.00,'512','2022-03-07 11:42:37','512','2022-03-07 11:42:57',10,0),('1','158',257303,'DAILY SHIFT','2022-03-06','2022-03-07 11:43:43','2022-03-10 11:43:43','512',0.00,0.00,'512','2022-03-09 13:44:33','512','2022-03-09 13:44:47',10,0),('1','158',257304,'DAILY SHIFT','2022-03-07','2022-03-09 13:45:23','2022-03-10 13:45:23','512',0.00,0.00,'512','2022-03-09 15:01:29','512','2022-03-09 15:01:43',10,0),('1','158',257305,'DAILY SHIFT','2022-03-08','2022-03-09 15:02:47','2022-03-12 15:02:47','512',0.00,0.00,'512','2022-03-11 15:02:14','512','2022-03-11 15:02:32',10,0),('1','158',257306,'DAILY SHIFT','2022-03-09','2022-03-11 15:02:59','2022-03-14 15:02:59','512',0.00,0.00,'512','2022-03-11 15:23:07','512','2022-03-11 15:23:21',10,0),('1','158',257307,'DAILY SHIFT','2022-03-10','2022-03-11 15:23:49','2022-03-14 15:23:49','512',0.00,0.00,'512','2022-03-11 15:29:57','512','2022-03-11 15:30:14',10,0),('1','158',257308,'DAILY SHIFT','2022-03-11','2022-03-11 15:30:36','2022-03-14 15:30:36','512',0.00,0.00,'512','2022-03-14 12:36:25','512','2022-03-14 12:36:41',10,0),('1','158',257309,'DAILY SHIFT','2022-03-12','2022-03-14 12:37:09','2022-03-17 12:37:09','512',0.00,0.00,'512','2022-03-14 13:02:47','512','2022-03-14 13:03:00',10,0),('1','158',257310,'DAILY SHIFT','2022-03-13','2022-03-14 13:04:01','2022-03-17 13:04:01','512',0.00,0.00,'512','2022-03-16 12:12:48','512','2022-03-16 12:13:03',10,0),('1','158',257311,'DAILY SHIFT','2022-03-14','2022-03-16 12:13:30','2022-03-19 12:13:30','512',0.00,0.00,'512','2022-03-16 12:35:08','512','2022-03-16 12:35:26',10,0),('1','158',257312,'DAILY SHIFT','2022-03-15','2022-03-16 12:35:50','2022-03-19 12:35:50','512',0.00,0.00,'512','2022-03-18 12:53:42','512','2022-03-18 12:53:56',10,0),('1','158',257313,'DAILY SHIFT','2022-03-16','2022-03-18 12:54:17','2022-03-19 12:54:17','512',0.00,0.00,'512','2022-03-18 15:37:16','512','2022-03-18 15:37:33',10,0),('1','158',257314,'DAILY SHIFT','2022-03-17','2022-03-18 15:38:01','2022-03-21 15:38:01','512',0.00,0.00,'512','2022-03-19 15:55:02','512','2022-03-19 15:55:17',10,0),('1','158',257315,'DAILY SHIFT','2022-03-18','2022-03-19 15:55:52','2022-03-22 15:55:52','512',0.00,0.00,'512','2022-03-19 16:02:42','512','2022-03-19 16:02:56',10,0),('1','158',257316,'DAILY SHIFT','2022-03-19','2022-03-19 16:04:08','2022-03-22 16:04:08','512',0.00,0.00,'512','2022-03-21 11:16:22','512','2022-03-21 11:16:36',10,0),('1','158',257317,'DAILY SHIFT','2022-03-20','2022-03-21 11:17:03','2022-03-24 11:17:03','512',0.00,0.00,'512','2022-03-22 15:13:24','512','2022-03-22 15:13:38',10,0),('1','158',257318,'DAILY SHIFT','2022-03-21','2022-03-22 15:14:06','2022-03-25 15:14:06','512',0.00,0.00,'512','2022-03-22 15:16:29','512','2022-03-22 15:16:43',10,0),('1','158',257319,'DAILY SHIFT','2022-03-22','2022-03-22 15:17:09','2022-03-25 15:17:09','512',0.00,0.00,'512','2022-03-24 10:42:16','512','2022-03-24 10:42:32',10,0),('1','158',257320,'DAILY SHIFT','2022-03-23','2022-03-24 10:43:04','2022-03-27 10:43:04','512',0.00,0.00,'512','2022-03-26 13:05:53','512','2022-03-26 13:06:07',10,0),('1','158',257321,'DAILY SHIFT','2022-03-24','2022-03-26 13:06:31','2022-03-29 13:06:31','512',0.00,0.00,'512','2022-03-26 13:12:43','512','2022-03-26 13:12:56',10,0),('1','158',257322,'DAILY SHIFT','2022-03-25','2022-03-26 13:13:20','2022-03-29 13:13:20','512',0.00,0.00,'512','2022-03-28 12:02:37','512','2022-03-28 12:02:51',10,0),('1','158',257323,'DAILY SHIFT','2022-03-26','2022-03-28 12:03:18','2022-03-31 12:03:18','512',0.00,0.00,'512','2022-03-28 12:30:49','512','2022-03-28 12:31:10',10,0),('1','158',257324,'DAILY SHIFT','2022-03-27','2022-03-28 12:31:38','2022-03-31 12:31:38','512',0.00,0.00,'512','2022-03-28 12:41:06','512','2022-03-28 12:41:21',10,0),('1','158',257325,'DAILY SHIFT','2022-03-28','2022-03-28 12:41:47','2022-03-31 12:41:47','512',0.00,0.00,'512','2022-04-03 14:54:27','512','2022-04-03 14:54:41',10,0),('1','158',257326,'DAILY SHIFT','2022-03-29','2022-04-03 14:55:05','2022-04-06 14:55:05','512',0.00,0.00,'512','2022-04-03 15:10:22','512','2022-04-03 15:10:37',10,0),('1','158',257327,'DAILY SHIFT','2022-03-30','2022-04-03 15:11:04','2022-04-10 15:11:04','512',0.00,0.00,'512','2022-04-03 15:33:25','512','2022-04-03 15:33:43',10,0),('1','158',257328,'DAILY SHIFT','2022-03-31','2022-04-03 15:34:24','2022-04-10 15:34:24','512',0.00,0.00,'512','2022-04-04 15:23:37','512','2022-04-04 15:24:05',10,0),('1','158',257329,'DAILY SHIFT','2022-04-01','2022-04-04 15:24:30','2022-04-11 15:24:30','512',0.00,0.00,'512','2022-04-04 15:36:02','512','2022-04-04 15:36:20',10,0),('1','158',257330,'DAILY SHIFT','2022-04-02','2022-04-04 15:36:42','2022-04-11 15:36:42','512',0.00,0.00,'512','2022-04-04 16:35:02','512','2022-04-04 16:35:36',10,0),('1','158',257331,'DAILY SHIFT','2022-04-03','2022-04-04 16:36:10','2022-04-11 16:36:10','512',0.00,0.00,'512','2022-04-04 16:44:08','512','2022-04-04 16:44:24',10,0),('1','158',257332,'DAILY SHIFT','2022-04-04','2022-04-04 16:44:45','2022-04-11 16:44:45','512',0.00,0.00,'512','2022-04-08 17:16:39','512','2022-04-08 17:17:45',10,0),('1','158',257333,'DAILY SHIFT','2022-04-05','2022-04-08 17:18:15','2022-04-11 17:18:15','512',0.00,0.00,'512','2022-04-08 17:25:58','512','2022-04-08 17:26:14',10,0),('1','158',257334,'DAILY SHIFT','2022-04-06','2022-04-08 17:26:55','2022-04-11 17:26:55','512',0.00,0.00,'512','2022-04-09 13:43:10','512','2022-04-09 13:43:24',10,0),('1','158',257335,'DAILY SHIFT','2022-04-07','2022-04-09 13:43:55','2022-04-12 13:43:55','512',0.00,0.00,'512','2022-04-09 14:52:04','512','2022-04-09 14:52:24',10,0),('1','158',257336,'DAILY SHIFT','2022-04-08','2022-04-09 14:52:52','2022-04-16 14:52:52','512',0.00,0.00,'512','2022-04-10 12:12:05','512','2022-04-10 12:12:18',10,0),('1','158',257337,'DAILY SHIFT','2022-04-09','2022-04-10 12:13:37','2022-04-17 12:13:37','512',0.00,0.00,'512','2022-04-10 12:31:47','512','2022-04-10 12:32:01',10,0),('1','158',257338,'DAILY SHIFT','2022-04-10','2022-04-10 12:33:39','2022-04-17 12:33:39','512',0.00,0.00,'512','2022-04-12 09:31:52','512','2022-04-12 09:32:10',10,0),('1','158',257339,'DAILY SHIFT','2022-04-11','2022-04-12 09:32:35','2022-04-19 09:32:35','512',0.00,0.00,'512','2022-04-12 14:14:59','512','2022-04-12 14:15:13',10,0),('1','158',257340,'DAILY SHIFT','2022-04-12','2022-04-12 14:15:35','2022-04-19 14:15:35','512',0.00,0.00,'512','2022-04-13 14:12:08','512','2022-04-13 14:12:24',10,0),('1','158',257341,'DAILY SHIFT','2022-04-13','2022-04-13 14:12:50','2022-04-20 14:12:50','512',0.00,0.00,'512','2022-04-15 15:51:58','512','2022-04-15 15:52:11',10,0),('1','158',257342,'DAILY SHIFT','2022-04-14','2022-04-15 15:52:53','2022-04-22 15:52:53','512',0.00,0.00,'512','2022-04-16 11:21:56','512','2022-04-16 11:22:13',10,0),('1','158',257343,'DAILY SHIFT','2022-04-15','2022-04-16 11:22:43','2022-04-23 11:22:43','512',0.00,0.00,'512','2022-04-17 12:20:00','512','2022-04-17 12:20:38',10,0),('1','158',257344,'DAILY SHIFT','2022-04-16','2022-04-17 12:21:27','2022-04-24 12:21:27','512',0.00,0.00,'512','2022-04-18 13:33:26','512','2022-04-18 13:33:53',10,0),('1','158',257345,'DAILY SHIFT','2022-04-17','2022-04-18 13:34:18','2022-04-25 13:34:18','512',0.00,0.00,'512','2022-04-21 12:39:45','512','2022-04-21 12:40:00',10,0),('1','158',257346,'DAILY SHIFT','2022-04-18','2022-04-21 12:40:26','2022-04-24 12:40:26','512',0.00,0.00,'512','2022-04-21 12:53:31','512','2022-04-21 12:53:46',10,0),('1','158',257347,'DAILY SHIFT','2022-04-19','2022-04-21 12:54:17','2022-04-24 12:54:17','512',0.00,0.00,'512','2022-04-21 13:41:05','512','2022-04-21 13:41:22',10,0),('1','158',257348,'DAILY SHIFT','2022-04-20','2022-04-21 13:42:08','2022-04-28 13:42:08','512',0.00,0.00,'512','2022-04-22 12:21:24','512','2022-04-22 12:21:49',10,0),('1','158',257349,'DAILY SHIFT','2022-04-21','2022-04-22 12:22:27','2022-04-29 12:22:27','512',0.00,0.00,'512','2022-04-23 14:46:57','512','2022-04-23 14:47:13',10,0),('1','158',257350,'DAILY SHIFT','2022-04-22','2022-04-23 14:47:48','2022-04-24 14:47:48','512',0.00,0.00,'512','2022-04-23 14:55:51','512','2022-04-23 14:56:07',10,0),('1','158',257351,'DAILY SHIFT','2022-04-23','2022-04-23 14:56:35','2022-04-30 14:56:35','512',0.00,0.00,'512','2022-04-25 14:06:52','512','2022-04-25 14:07:07',10,0),('1','158',257352,'DAILY SHIFT','2022-04-24','2022-04-25 14:07:55','2022-04-28 14:07:55','512',0.00,0.00,'512','2022-04-26 12:50:41','512','2022-04-26 12:50:55',10,0),('1','158',257353,'DAILY SHIFT','2022-04-25','2022-04-26 12:51:18','2022-04-29 12:51:18','512',0.00,0.00,'512','2022-04-27 14:26:48','512','2022-04-27 14:27:03',10,0),('1','158',257354,'DAILY SHIFT','2022-04-26','2022-04-27 14:27:40','2022-04-30 14:27:40','512',0.00,0.00,'512','2022-04-28 12:39:26','512','2022-04-28 12:39:41',10,0),('1','158',257355,'DAILY SHIFT','2022-04-27','2022-04-28 12:40:10','2022-05-05 12:40:10','512',0.00,0.00,'512','2022-04-28 12:50:55','512','2022-04-28 12:51:09',10,0),('1','158',257356,'DAILY SHIFT','2022-04-28','2022-04-28 12:51:34','2022-05-05 12:51:34','512',0.00,0.00,'512','2022-05-01 11:40:12','512','2022-05-01 11:40:54',10,0),('1','158',257357,'DAILY SHIFT','2022-04-29','2022-05-01 11:41:31','2022-05-08 11:41:31','512',0.00,0.00,'512','2022-05-04 08:21:43','512','2022-05-04 08:22:01',10,0),('1','158',257358,'DAILY SHIFT','2022-04-30','2022-05-04 08:25:37','2022-05-11 08:25:37','512',0.00,0.00,'512','2022-05-04 08:59:57','512','2022-05-04 09:00:11',10,0),('1','158',257359,'DAILY SHIFT','2022-05-01','2022-05-04 09:00:46','2022-05-11 09:00:46','512',0.00,0.00,'512','2022-05-05 11:54:31','512','2022-05-05 11:55:10',10,0),('1','158',257360,'DAILY SHIFT','2022-05-02','2022-05-05 11:55:47','2022-05-12 11:55:47','512',0.00,0.00,'512','2022-05-05 12:05:37','512','2022-05-05 12:05:54',10,0),('1','158',257361,'DAILY SHIFT','2022-05-03','2022-05-05 12:06:19','2022-05-12 12:06:19','512',0.00,0.00,'512','2022-05-06 11:40:41','512','2022-05-06 11:40:55',10,0),('1','158',257362,'DAILY SHIFT','2022-05-04','2022-05-06 11:41:17','2022-05-09 11:41:17','512',0.00,0.00,'512','2022-05-06 11:49:06','512','2022-05-06 11:49:18',10,0),('1','158',257363,'DAILY SHIFT','2022-05-05','2022-05-06 11:49:41','2022-05-13 11:49:41','512',0.00,0.00,'512','2022-05-07 10:08:34','512','2022-05-07 10:08:52',10,0),('1','158',257364,'DAILY SHIFT','2022-05-06','2022-05-07 10:09:27','2022-05-14 10:09:27','512',0.00,0.00,'512','2022-05-07 11:01:08','512','2022-05-07 11:01:26',10,0),('1','158',257365,'DAILY SHIFT','2022-05-07','2022-05-07 11:02:20','2022-05-14 11:02:20','512',0.00,0.00,'512','2022-05-10 12:07:35','512','2022-05-10 12:07:50',10,0),('1','158',257366,'DAILY SHIFT','2022-05-08','2022-05-10 12:08:13','2022-05-17 12:08:13','512',0.00,0.00,'512','2022-05-12 16:36:49','512','2022-05-12 16:37:14',10,0),('1','158',257367,'DAILY SHIFT','2022-05-09','2022-05-12 16:37:57','2022-05-19 16:37:57','512',0.00,0.00,'512','2022-05-12 16:43:27','512','2022-05-12 16:44:52',10,0),('1','158',257368,'DAILY SHIFT','2022-05-10','2022-05-12 16:45:25','2022-05-13 04:45:25','512',0.00,0.00,'512','2022-05-12 16:48:04','512','2022-05-12 16:48:24',10,0),('1','158',257369,'DAILY SHIFT','2022-05-11','2022-05-12 16:48:59','2022-05-13 16:48:59','512',0.00,0.00,'512','2022-05-12 17:03:04','512','2022-05-12 17:03:22',10,0),('1','158',257370,'DAILY SHIFT','2022-05-12','2022-05-12 17:03:46','2022-05-19 17:03:46','512',0.00,0.00,'512','2022-05-13 12:41:44','512','2022-05-13 12:41:58',10,0),('1','158',257371,'DAILY SHIFT','2022-05-13','2022-05-13 12:42:17','2022-05-20 12:42:17','512',0.00,0.00,'512','2022-05-14 12:51:34','512','2022-05-14 12:51:51',10,0),('1','158',257372,'DAILY SHIFT','2022-05-14','2022-05-14 12:52:13','2022-05-21 12:52:13','512',0.00,0.00,'512','2022-05-17 08:57:04','512','2022-05-17 08:57:20',10,0),('1','158',257373,'DAILY SHIFT','2022-05-15','2022-05-17 08:57:47','2022-05-18 08:57:47','512',0.00,0.00,'512','2022-05-17 09:01:31','512','2022-05-17 09:01:46',10,0),('1','158',257374,'DAILY SHIFT','2022-05-16','2022-05-17 09:02:15','2022-05-24 09:02:15','512',0.00,0.00,'512','2022-05-18 11:00:02','512','2022-05-18 11:00:18',10,0),('1','158',257375,'DAILY SHIFT','2022-05-17','2022-05-18 11:00:41','2022-05-19 11:00:41','512',0.00,0.00,'512','2022-05-18 11:06:03','512','2022-05-18 11:06:19',10,0),('1','158',257376,'DAILY SHIFT','2022-05-18','2022-05-18 11:06:42','2022-05-25 11:06:42','512',0.00,0.00,'512','2022-05-20 10:43:45','512','2022-05-20 10:44:01',10,0),('1','158',257377,'DAILY SHIFT','2022-05-19','2022-05-20 10:44:28','2022-05-27 10:44:28','512',0.00,0.00,'512','2022-05-21 10:03:27','512','2022-05-21 10:03:46',10,0),('1','158',257378,'DAILY SHIFT','2022-05-20','2022-05-21 10:04:12','2022-05-24 10:04:12','512',0.00,0.00,'512','2022-05-22 15:22:00','512','2022-05-22 15:22:13',10,0),('1','158',257379,'DAILY SHIFT','2022-05-21','2022-05-22 15:22:48','2022-05-23 15:22:48','512',0.00,0.00,'512','2022-05-22 15:49:06','512','2022-05-22 15:49:20',10,0),('1','158',257380,'DAILY SHIFT','2022-05-22','2022-05-22 15:49:40','2022-05-29 15:49:40','512',0.00,0.00,'512','2022-05-24 16:22:41','512','2022-05-24 16:22:56',10,0),('1','158',257381,'DAILY SHIFT','2022-05-23','2022-05-24 16:23:31','2022-05-27 16:23:31','512',0.00,0.00,'512','2022-05-25 11:24:32','512','2022-05-25 11:24:46',10,0),('1','158',257382,'DAILY SHIFT','2022-05-24','2022-05-25 11:25:11','2022-05-28 11:25:11','512',0.00,0.00,'512','2022-05-26 16:30:13','512','2022-05-26 16:30:54',10,0),('1','158',257383,'DAILY SHIFT','2022-05-25','2022-05-26 16:31:25','2022-05-27 16:31:25','512',0.00,0.00,'512','2022-05-26 17:01:50','512','2022-05-26 17:02:04',10,0),('1','158',257384,'DAILY SHIFT','2022-05-26','2022-05-26 17:02:30','2022-06-02 17:02:30','512',0.00,0.00,'512','2022-05-27 15:35:26','512','2022-05-27 15:35:40',10,0),('1','158',257385,'DAILY SHIFT','2022-05-27','2022-05-27 15:36:03','2022-06-03 15:36:03','512',0.00,0.00,'512','2022-05-28 16:25:31','512','2022-05-28 16:25:45',10,0),('1','158',257386,'DAILY SHIFT','2022-05-28','2022-05-28 16:26:10','2022-06-04 16:26:10','512',0.00,0.00,'512','2022-05-29 18:15:44','512','2022-05-29 18:15:57',10,0),('1','158',257387,'DAILY SHIFT','2022-05-29','2022-05-29 18:16:26','2022-06-05 18:16:26','512',0.00,0.00,'512','2022-05-30 12:21:17','512','2022-05-30 12:21:30',10,0),('1','158',257388,'DAILY SHIFT','2022-05-30','2022-05-30 12:21:52','2022-06-06 12:21:52','512',0.00,0.00,'512','2022-05-31 13:54:54','512','2022-05-31 13:55:10',10,0),('1','158',257389,'DAILY SHIFT','2022-05-31','2022-05-31 13:55:33','2022-06-07 13:55:33','512',0.00,0.00,'512','2022-06-01 11:36:14','512','2022-06-01 11:36:31',10,0),('1','158',257390,'DAILY SHIFT','2022-06-01','2022-06-01 11:36:55','2022-06-08 11:36:55','512',0.00,0.00,'512','2022-06-02 11:35:57','512','2022-06-02 11:36:12',10,0),('1','158',257391,'DAILY SHIFT','2022-06-02','2022-06-02 11:36:33','2022-06-09 11:36:33','512',0.00,0.00,'512','2022-06-05 16:30:27','512','2022-06-05 16:30:44',10,0),('1','158',257392,'DAILY SHIFT','2022-06-03','2022-06-05 16:31:19','2022-06-12 16:31:19','512',0.00,0.00,'512','2022-06-05 16:51:09','512','2022-06-05 16:51:23',10,0),('1','158',257393,'DAILY SHIFT','2022-06-04','2022-06-05 16:51:49','2022-06-12 16:51:49','512',0.00,0.00,'512','2022-06-05 16:57:51','512','2022-06-05 16:58:07',10,0),('1','158',257394,'DAILY SHIFT','2022-06-05','2022-06-05 16:58:55','2022-06-12 16:58:55','512',0.00,0.00,'512','2022-06-07 17:09:06','512','2022-06-07 17:09:21',10,0),('1','158',257395,'DAILY SHIFT','2022-06-06','2022-06-07 17:09:57','2022-06-08 17:09:57','512',0.00,0.00,'512','2022-06-07 17:15:25','512','2022-06-07 17:15:39',10,0),('1','158',257396,'DAILY SHIFT','2022-06-07','2022-06-07 17:16:09','2022-06-14 17:16:09','512',0.00,0.00,'512','2022-06-14 10:30:20','512','2022-06-14 10:30:38',10,0),('1','158',257397,'DAILY SHIFT','2022-06-08','2022-06-14 10:31:21','2022-06-15 10:31:21','512',0.00,0.00,'512','2022-06-14 10:33:29','512','2022-06-14 10:33:47',10,0),('1','158',257398,'DAILY SHIFT','2022-06-09','2022-06-14 10:34:19','2022-06-17 10:34:19','512',0.00,0.00,'512','2022-06-14 10:57:55','512','2022-06-14 10:58:10',10,0),('1','158',257399,'DAILY SHIFT','2022-06-10','2022-06-14 10:59:19','2022-06-15 10:59:19','512',0.00,0.00,'512','2022-06-14 11:49:41','512','2022-06-14 11:49:57',10,0),('1','158',257400,'DAILY SHIFT','2022-06-11','2022-06-14 11:50:22','2022-06-15 11:50:22','512',0.00,0.00,'512','2022-06-14 12:07:34','512','2022-06-14 12:07:53',10,0),('1','158',257401,'DAILY SHIFT','2022-06-12','2022-06-14 12:08:22','2022-06-15 12:08:22','512',0.00,0.00,'512','2022-06-14 12:37:32','512','2022-06-14 12:37:47',10,0),('1','158',257402,'DAILY SHIFT','2022-06-13','2022-06-14 12:38:16','2022-06-21 12:38:16','512',0.00,0.00,'512','2022-06-15 11:49:36','512','2022-06-15 11:49:50',10,0),('1','158',257403,'DAILY SHIFT','2022-06-14','2022-06-15 11:50:13','2022-06-22 11:50:13','512',0.00,0.00,'512','2022-06-16 15:30:33','512','2022-06-16 15:30:53',10,0),('1','158',257404,'DAILY SHIFT','2022-06-15','2022-06-16 15:31:19','2022-06-17 15:31:19','512',0.00,0.00,'512','2022-06-16 15:38:19','512','2022-06-16 15:39:09',10,0),('1','158',257405,'DAILY SHIFT','2022-06-16','2022-06-16 15:39:38','2022-06-23 15:39:38','512',0.00,0.00,'512','2022-06-17 11:37:23','512','2022-06-17 11:37:37',10,0),('1','158',257406,'DAILY SHIFT','2022-06-17','2022-06-17 11:37:57','2022-06-24 11:37:57','512',0.00,0.00,'512','2022-06-18 17:31:50','512','2022-06-18 17:32:06',10,0),('1','158',257407,'DAILY SHIFT','2022-06-18','2022-06-18 17:32:27','2022-06-25 17:32:27','512',0.00,0.00,'512','2022-06-19 11:41:49','512','2022-06-19 11:42:10',10,0),('1','158',257408,'DAILY SHIFT','2022-06-19','2022-06-19 11:42:30','2022-06-26 11:42:30','512',0.00,0.00,'512','2022-06-22 09:49:30','512','2022-06-22 09:49:46',10,0),('1','158',257409,'DAILY SHIFT','2022-06-20','2022-06-22 09:50:16','2022-06-25 09:50:16','512',0.00,0.00,'512','2022-06-22 16:29:08','512','2022-06-22 16:29:23',10,0),('1','158',257410,'DAILY SHIFT','2022-06-21','2022-06-22 16:29:57','2022-06-23 16:29:57','512',0.00,0.00,'512','2022-06-22 16:37:53','512','2022-06-22 16:38:14',10,0),('1','158',257411,'DAILY SHIFT','2022-06-22','2022-06-22 16:38:58','2022-06-29 16:38:58','512',0.00,0.00,'512','2022-06-24 15:25:09','512','2022-06-24 15:25:23',10,0),('1','158',257412,'DAILY SHIFT','2022-06-23','2022-06-24 15:25:43','2022-06-25 15:25:43','512',0.00,0.00,'512','2022-06-24 15:31:36','512','2022-06-24 15:31:54',10,0),('1','158',257413,'DAILY SHIFT','2022-06-24','2022-06-24 15:32:44','2022-07-01 15:32:44','512',0.00,0.00,'512','2022-06-26 12:49:43','512','2022-06-26 12:49:57',10,0),('1','158',257414,'DAILY SHIFT','2022-06-25','2022-06-26 12:50:27','2022-07-03 12:50:27','512',0.00,0.00,'512','2022-06-27 12:21:34','512','2022-06-27 12:21:48',10,0),('1','158',257415,'DAILY SHIFT','2022-06-26','2022-06-27 12:22:41','2022-07-04 12:22:41','512',0.00,0.00,'512','2022-06-29 11:33:10','512','2022-06-29 11:33:26',10,0),('1','158',257416,'DAILY SHIFT','2022-06-27','2022-06-29 11:33:52','2022-06-30 11:33:52','512',0.00,0.00,'512','2022-06-29 11:36:01','512','2022-06-29 11:36:16',10,0),('1','158',257417,'DAILY SHIFT','2022-06-28','2022-06-29 11:36:46','2022-07-06 11:36:46','512',0.00,0.00,'512','2022-06-30 12:39:51','512','2022-06-30 12:40:08',10,0),('1','158',257418,'DAILY SHIFT','2022-06-29','2022-06-30 12:40:33','2022-07-07 12:40:33','512',0.00,0.00,'512','2022-07-01 11:42:31','512','2022-07-01 11:42:47',10,0),('1','158',257419,'DAILY SHIFT','2022-06-30','2022-07-01 11:43:17','2022-07-08 11:43:17','512',0.00,0.00,'512','2022-07-02 12:15:06','512','2022-07-02 12:15:20',10,0),('1','158',257420,'DAILY SHIFT','2022-07-01','2022-07-02 12:15:48','2022-07-09 12:15:48','512',0.00,0.00,'512','2022-07-03 13:30:35','512','2022-07-03 13:30:49',10,0),('1','158',257421,'DAILY SHIFT','2022-07-02','2022-07-03 13:31:12','2022-07-10 13:31:12','512',0.00,0.00,'512','2022-07-04 11:11:04','512','2022-07-04 11:11:23',10,0),('1','158',257422,'DAILY SHIFT','2022-07-03','2022-07-04 11:11:57','2022-07-11 11:11:57','512',0.00,0.00,'512','2022-07-05 15:04:27','512','2022-07-05 15:04:42',10,0),('1','158',257423,'DAILY SHIFT','2022-07-04','2022-07-05 15:05:08','2022-07-06 15:05:08','512',0.00,0.00,'512','2022-07-05 15:07:13','512','2022-07-05 15:07:27',10,0),('1','158',257424,'DAILY SHIFT','2022-07-05','2022-07-05 15:07:48','2022-07-12 15:07:48','512',0.00,0.00,'512','2022-07-11 10:06:18','512','2022-07-11 10:06:33',10,0),('1','158',257425,'DAILY SHIFT','2022-07-06','2022-07-11 10:06:57','2022-07-18 10:06:57','512',0.00,0.00,'512','2022-07-11 10:17:31','512','2022-07-11 10:17:45',10,0),('1','158',257426,'DAILY SHIFT','2022-07-07','2022-07-11 10:18:06','2022-07-18 10:18:06','512',0.00,0.00,'512','2022-07-11 10:23:23','512','2022-07-11 10:23:41',10,0),('1','158',257427,'DAILY SHIFT','2022-07-08','2022-07-11 10:24:11','2022-07-18 10:24:11','512',0.00,0.00,'512','2022-07-11 10:42:19','512','2022-07-11 10:42:38',10,0),('1','158',257428,'DAILY SHIFT','2022-07-09','2022-07-11 10:42:59','2022-07-18 10:42:59','512',0.00,0.00,'512','2022-07-11 10:50:06','512','2022-07-11 10:50:21',10,0),('1','158',257429,'DAILY SHIFT','2022-07-10','2022-07-11 10:50:43','2022-07-18 10:50:43','512',0.00,0.00,'512','2022-07-12 16:20:11','512','2022-07-12 16:20:26',10,0),('1','158',257430,'DAILY SHIFT','2022-07-11','2022-07-12 16:20:49','2022-07-19 16:20:49','512',0.00,0.00,'512','2022-07-15 11:06:50','512','2022-07-15 11:07:04',10,0),('1','158',257431,'DAILY SHIFT','2022-07-13','2022-07-15 11:07:30','2022-07-16 11:07:30','512',0.00,0.00,'512','2022-07-15 11:16:47','512','2022-07-15 11:17:02',10,0),('1','158',257432,'DAILY SHIFT','2022-07-14','2022-07-15 11:17:44','2022-07-22 11:17:44','512',0.00,0.00,'512','2022-07-16 15:40:18','512','2022-07-16 15:40:33',10,0),('1','158',257433,'DAILY SHIFT','2022-07-15','2022-07-16 15:41:04','2022-07-17 15:41:04','512',0.00,0.00,'512','2022-07-16 15:43:13','512','2022-07-16 15:43:28',10,0),('1','158',257434,'DAILY SHIFT','2022-07-16','2022-07-16 15:43:47','2022-07-23 15:43:47','512',0.00,0.00,'512','2022-07-18 11:15:49','512','2022-07-18 11:16:11',10,0),('1','158',257435,'DAILY SHIFT','2022-07-17','2022-07-18 11:16:52','2022-07-19 11:16:52','512',0.00,0.00,'512','2022-07-18 11:24:43','512','2022-07-18 11:25:06',10,0),('1','158',257436,'DAILY SHIFT','2022-07-18','2022-07-18 11:25:34','2022-07-25 11:25:34','512',0.00,0.00,'512','2022-07-20 10:04:27','512','2022-07-20 10:04:49',10,0),('1','158',257437,'DAILY SHIFT','2022-07-19','2022-07-20 10:05:33','2022-07-27 10:05:33','512',0.00,0.00,'512','2022-07-21 15:23:39','512','2022-07-21 15:23:53',10,0),('1','158',257438,'DAILY SHIFT','2022-07-20','2022-07-21 15:24:14','2022-07-22 15:24:14','512',0.00,0.00,'512','2022-07-21 15:30:49','512','2022-07-21 15:31:04',10,0),('1','158',257439,'DAILY SHIFT','2022-07-21','2022-07-21 15:31:34','2022-07-28 15:31:34','512',0.00,0.00,'512','2022-07-25 13:43:34','512','2022-07-25 13:43:48',10,0),('1','158',257440,'DAILY SHIFT','2022-07-22','2022-07-25 13:44:21','2022-07-26 13:44:21','512',0.00,0.00,'512','2022-07-25 13:50:01','512','2022-07-25 13:50:17',10,0),('1','158',257441,'DAILY SHIFT','2022-07-23','2022-07-25 13:50:36','2022-07-26 13:50:36','512',0.00,0.00,'512','2022-07-25 14:22:42','512','2022-07-25 14:22:59',10,0),('1','158',257442,'DAILY SHIFT','2022-07-24','2022-07-25 14:23:24','2022-07-26 14:23:24','512',0.00,0.00,'512','2022-07-25 14:30:34','512','2022-07-25 14:30:48',10,0),('1','158',257443,'DAILY SHIFT','2022-07-25','2022-07-25 14:31:26','2022-08-01 14:31:26','512',0.00,0.00,'512','2022-07-28 08:33:23','512','2022-07-28 08:33:38',10,0),('1','158',257444,'DAILY SHIFT','2022-07-26','2022-07-28 08:34:04','2022-07-29 08:34:04','512',0.00,0.00,'512','2022-07-28 08:36:10','512','2022-07-28 08:36:27',10,0),('1','158',257445,'DAILY SHIFT','2022-07-27','2022-07-28 08:37:06','2022-08-04 08:37:06','512',0.00,0.00,'512','2022-07-29 12:16:46','512','2022-07-29 12:17:03',10,0),('1','158',257446,'DAILY SHIFT','2022-07-28','2022-07-29 12:17:24','2022-07-30 12:17:24','512',0.00,0.00,'512','2022-07-29 12:25:17','512','2022-07-29 12:25:32',10,0),('1','158',257447,'DAILY SHIFT','2022-07-29','2022-07-29 12:26:03','2022-08-05 12:26:03','512',0.00,0.00,'512','2022-07-30 15:38:09','512','2022-07-30 15:38:26',10,0),('1','158',257448,'DAILY SHIFT','2022-07-30','2022-07-30 15:39:00','2022-08-06 15:39:00','512',0.00,0.00,'512','2022-08-01 10:54:08','512','2022-08-01 10:54:23',10,0),('1','158',257449,'DAILY SHIFT','2022-07-31','2022-08-01 10:55:11','2022-08-08 10:55:11','512',0.00,0.00,'512','2022-08-02 15:24:46','512','2022-08-02 15:25:13',10,0),('1','158',257450,'DAILY SHIFT','2022-08-01','2022-08-02 15:25:36','2022-08-03 15:25:36','512',0.00,0.00,'512','2022-08-02 15:29:49','512','2022-08-02 15:30:01',10,0),('1','158',257451,'DAILY SHIFT','2022-08-02','2022-08-02 15:30:24','2022-08-05 15:30:24','512',0.00,0.00,'512','2022-08-04 08:00:57','512','2022-08-04 08:01:12',10,0),('1','158',257452,'DAILY SHIFT','2022-08-03','2022-08-04 08:01:39','2022-08-07 08:01:39','512',0.00,0.00,'512','2022-08-05 11:09:33','512','2022-08-05 11:09:47',10,0),('1','158',257453,'DAILY SHIFT','2022-08-04','2022-08-05 11:10:08','2022-08-06 11:10:08','512',0.00,0.00,'512','2022-08-05 11:16:27','512','2022-08-05 11:16:41',10,0),('1','158',257454,'DAILY SHIFT','2022-08-05','2022-08-05 11:17:25','2022-08-08 11:17:25','512',0.00,0.00,'512','2022-08-06 17:43:43','512','2022-08-06 17:43:58',10,0),('1','158',257455,'DAILY SHIFT','2022-08-06','2022-08-06 17:44:24','2022-08-09 17:44:24','512',0.00,0.00,'512','2022-08-07 19:58:15','512','2022-08-07 19:58:30',10,0),('1','158',257456,'DAILY SHIFT','2022-08-07','2022-08-07 19:58:48','2022-08-14 19:58:48','512',0.00,0.00,'512','2022-08-09 12:13:56','512','2022-08-09 12:14:09',10,0),('1','158',257457,'DAILY SHIFT','2022-08-08','2022-08-09 12:14:31','2022-08-16 12:14:31','512',0.00,0.00,'512','2022-08-09 12:15:03','512','2022-08-09 12:15:30',10,0),('1','158',257458,'DAILY SHIFT','2022-08-08','2022-08-09 12:15:52','2022-08-16 12:15:52','512',0.00,0.00,'512','2022-08-15 15:40:10','512','2022-08-15 15:40:36',10,0),('1','158',257459,'DAILY SHIFT','2022-08-09','2022-08-15 15:41:04','2022-08-16 15:41:04','512',0.00,0.00,'512','2022-08-15 16:22:17','512','2022-08-15 16:22:35',10,0),('1','158',257460,'DAILY SHIFT','2022-08-10','2022-08-15 16:23:08','2022-08-16 16:23:08','512',0.00,0.00,'512','2022-08-15 16:45:14','512','2022-08-15 16:45:27',10,0),('1','158',257461,'DAILY SHIFT','2022-08-11','2022-08-15 16:46:09','2022-08-16 16:46:09','512',0.00,0.00,'512','2022-08-15 17:05:13','512','2022-08-15 17:05:30',10,0),('1','158',257462,'DAILY SHIFT','2022-08-12','2022-08-15 17:05:59','2022-08-22 17:05:59','512',0.00,0.00,'512','2022-08-15 22:19:46','512','2022-08-15 22:20:07',10,0),('1','158',257463,'DAILY SHIFT','2022-08-14','2022-08-15 22:21:21','2022-08-22 22:21:21','512',0.00,0.00,'512','2022-08-16 17:04:43','512','2022-08-16 17:05:24',10,0),('1','158',257464,'DAILY SHIFT','2022-08-15','2022-08-16 17:05:49','2022-08-19 17:05:49','512',0.00,0.00,'512','2022-08-17 12:03:31','512','2022-08-17 12:03:54',10,0),('1','158',257465,'DAILY SHIFT','2022-08-16','2022-08-17 12:04:18','2022-08-18 12:04:18','512',0.00,0.00,'512','2022-08-17 12:19:32','512','2022-08-17 12:19:49',10,0),('1','158',257466,'DAILY SHIFT','2022-08-17','2022-08-17 12:20:35','2022-08-20 12:20:35','512',0.00,0.00,'512','2022-08-19 16:35:05','512','2022-08-19 16:35:43',10,0),('1','158',257467,'DAILY SHIFT','2022-08-18','2022-08-19 16:36:54','2022-08-20 16:36:54','512',0.00,0.00,'512','2022-08-19 16:46:10','512','2022-08-19 16:48:39',10,0),('1','158',257468,'DAILY SHIFT','2022-08-19','2022-08-19 16:50:59','2022-08-22 16:50:59','512',0.00,0.00,'512','2022-08-20 15:07:43','512','2022-08-20 15:07:57',10,0),('1','158',257469,'DAILY SHIFT','2022-08-20','2022-08-20 15:08:19','2022-08-23 15:08:19','512',0.00,0.00,'512','2022-08-22 09:51:40','512','2022-08-22 09:51:57',10,0),('1','158',257470,'DAILY SHIFT','2022-08-21','2022-08-22 09:52:43','2022-08-25 09:52:43','512',0.00,0.00,'512','2022-08-23 19:42:46','512','2022-08-23 19:43:00',10,0),('1','158',257471,'DAILY SHIFT','2022-08-22','2022-08-23 19:43:32','2022-08-24 19:43:32','512',0.00,0.00,'512','2022-08-23 19:56:32','512','2022-08-23 19:56:49',10,0),('1','158',257472,'DAILY SHIFT','2022-08-23','2022-08-23 19:57:15','2022-08-26 19:57:15','512',0.00,0.00,'512','2022-08-25 15:10:21','512','2022-08-25 15:10:36',10,0),('1','158',257473,'DAILY SHIFT','2022-08-24','2022-08-25 15:10:57','2022-08-26 15:10:57','512',0.00,0.00,'512','2022-08-25 15:12:58','512','2022-08-25 15:13:17',10,0),('1','158',257474,'DAILY SHIFT','2022-08-25','2022-08-25 15:13:40','2022-08-28 15:13:40','512',0.00,0.00,'512','2022-08-28 11:27:03','512','2022-08-28 11:27:21',10,0),('1','158',257475,'DAILY SHIFT','2022-08-27','2022-08-28 11:27:56','2022-08-31 11:27:56','512',0.00,0.00,'512','2022-08-29 10:34:21','512','2022-08-29 10:34:38',10,0),('1','158',257476,'DAILY SHIFT','2022-08-28','2022-08-29 10:35:04','2022-09-01 10:35:04','512',0.00,0.00,'512','2022-08-30 09:10:37','512','2022-08-30 09:10:51',10,0),('1','158',257477,'DAILY SHIFT','2022-08-29','2022-08-30 09:11:29','2022-09-02 09:11:29','512',0.00,0.00,'512','2022-09-01 07:02:49','512','2022-09-01 07:03:04',10,0),('1','158',257478,'DAILY SHIFT','2022-08-30','2022-09-01 07:03:31','2022-09-02 07:03:31','512',0.00,0.00,'512','2022-09-01 07:05:28','512','2022-09-01 07:05:44',10,0),('1','158',257479,'DAILY SHIFT','2022-08-31','2022-09-01 07:06:22','2022-09-02 07:06:22','512',0.00,0.00,'512','2022-09-01 12:32:41','512','2022-09-01 12:32:54',10,0),('1','158',257480,'DAILY SHIFT','2022-09-01','2022-09-01 12:33:18','2022-09-04 12:33:18','512',0.00,0.00,'512','2022-09-03 09:07:31','512','2022-09-03 09:07:45',10,0),('1','158',257481,'DAILY SHIFT','2022-09-02','2022-09-03 09:08:11','2022-09-04 09:08:11','512',0.00,0.00,'512','2022-09-03 09:12:43','512','2022-09-03 09:12:57',10,0),('1','158',257482,'DAILY SHIFT','2022-09-03','2022-09-03 09:13:16','2022-09-06 09:13:16','512',0.00,0.00,'512','2022-09-04 16:06:18','512','2022-09-04 16:06:30',10,0),('1','158',257483,'DAILY SHIFT','2022-09-04','2022-09-04 16:06:51','2022-09-07 16:06:51','512',0.00,0.00,'512','2022-09-06 09:28:43','512','2022-09-06 09:28:58',10,0),('1','158',257484,'DAILY SHIFT','2022-09-05','2022-09-06 09:29:27','2022-09-09 09:29:27','512',0.00,0.00,'512','2022-09-06 16:44:16','512','2022-09-06 16:44:42',10,0),('1','158',257485,'DAILY SHIFT','2022-09-06','2022-09-06 16:45:01','2022-09-09 16:45:01','512',0.00,0.00,'512','2022-09-09 17:35:14','512','2022-09-09 17:36:10',10,0),('1','158',257486,'DAILY SHIFT','2022-09-06','2022-09-09 17:36:30','2022-09-10 17:36:30','512',0.00,0.00,'512','2022-09-09 17:41:37','512','2022-09-09 17:41:55',10,0),('1','158',257487,'DAILY SHIFT','2022-09-07','2022-09-09 17:42:17','2022-09-10 17:42:17','512',0.00,0.00,'512','2022-09-09 17:54:25','512','2022-09-09 17:54:40',10,0),('1','158',257488,'DAILY SHIFT','2022-09-08','2022-09-09 17:55:00','2022-09-10 17:55:00','512',0.00,0.00,'512','2022-09-09 18:09:25','512','2022-09-09 18:10:20',10,0),('1','158',257489,'DAILY SHIFT','2022-09-09','2022-09-09 18:10:49','2022-09-12 18:10:49','512',0.00,0.00,'512','2022-09-10 16:40:59','512','2022-09-10 16:41:15',10,0),('1','158',257490,'DAILY SHIFT','2022-09-10','2022-09-10 16:43:19','2022-09-13 16:43:19','512',0.00,0.00,'512','2022-09-12 14:37:53','512','2022-09-12 14:38:07',10,0),('1','158',257491,'DAILY SHIFT','2022-09-12','2022-09-12 14:38:34','2022-09-15 14:38:34','512',0.00,0.00,'512','2022-09-13 11:38:10','512','2022-09-13 11:38:22',10,0),('1','158',257492,'DAILY SHIFT','2022-09-13','2022-09-13 11:38:46','2022-09-16 11:38:46','512',0.00,0.00,'512','2022-09-20 11:10:42','512','2022-09-20 11:10:59',10,0),('1','158',257493,'DAILY SHIFT','2022-09-13','2022-09-20 11:11:35','2022-09-21 11:11:35','512',0.00,0.00,'512','2022-09-20 11:17:27','512','2022-09-20 11:17:43',10,0),('1','158',257494,'DAILY SHIFT','2022-09-14','2022-09-20 11:18:30','2022-09-23 11:18:30','512',0.00,0.00,'512','2022-09-21 11:43:45','512','2022-09-21 11:44:07',10,0),('1','158',257495,'DAILY SHIFT','2022-09-15','2022-09-21 11:44:38','2022-09-24 11:44:38','512',0.00,0.00,'512','2022-09-21 12:03:41','512','2022-09-21 12:03:59',10,0),('1','158',257496,'DAILY SHIFT','2022-09-17','2022-09-21 12:04:29','2022-09-24 12:04:29','512',0.00,0.00,'512','2022-09-21 12:30:32','512','2022-09-21 12:30:50',10,0),('1','158',257497,'DAILY SHIFT','2022-09-18','2022-09-21 12:31:26','2022-09-22 12:31:26','512',0.00,0.00,'512','2022-09-21 12:36:55','512','2022-09-21 12:37:11',10,0),('1','158',257498,'DAILY SHIFT','2022-09-19','2022-09-21 12:37:44','2022-09-24 12:37:44','512',0.00,0.00,'512','2022-09-22 12:55:23','512','2022-09-22 12:55:39',10,0),('1','158',257499,'DAILY SHIFT','2022-09-20','2022-09-22 12:56:06','2022-09-25 12:56:06','512',0.00,0.00,'512','2022-09-22 13:15:35','512','2022-09-22 13:15:59',10,0),('1','158',257500,'DAILY SHIFT','2022-09-21','2022-09-22 13:16:31','2022-09-25 13:16:31','512',0.00,0.00,'512','2022-09-24 11:53:04','512','2022-09-24 11:53:18',10,0),('1','158',257501,'DAILY SHIFT','2022-09-22','2022-09-24 11:53:46','2022-10-01 11:53:46','512',0.00,0.00,'512','2022-09-27 10:16:51','512','2022-09-27 10:17:07',10,0),('1','158',257502,'DAILY SHIFT','2022-09-23','2022-09-27 10:17:38','2022-09-28 10:17:38','512',0.00,0.00,'512','2022-09-27 10:37:01','512','2022-09-27 10:37:15',10,0),('1','158',257503,'DAILY SHIFT','2022-09-24','2022-09-27 10:37:41','2022-09-28 10:37:41','512',0.00,0.00,'512','2022-09-27 10:43:58','512','2022-09-27 10:44:11',10,0),('1','158',257504,'DAILY SHIFT','2022-09-25','2022-09-27 10:44:49','2022-09-28 10:44:49','512',0.00,0.00,'512','2022-09-27 10:55:47','512','2022-09-27 10:56:01',10,0),('1','158',257505,'DAILY SHIFT','2022-09-26','2022-09-27 10:56:24','2022-10-04 10:56:24','512',0.00,0.00,'512','2022-09-28 10:18:47','512','2022-09-28 10:19:00',10,0),('1','158',257506,'DAILY SHIFT','2022-09-27','2022-09-28 10:19:24','2022-10-01 10:19:24','512',0.00,0.00,'512','2022-09-29 11:07:08','512','2022-09-29 11:07:22',10,0),('1','158',257507,'DAILY SHIFT','2022-09-28','2022-09-29 11:07:57','2022-10-02 11:07:57','512',0.00,0.00,'512','2022-09-30 08:39:11','512','2022-09-30 08:39:24',10,0),('1','158',257508,'DAILY SHIFT','2022-09-29','2022-09-30 08:39:55','2022-10-03 08:39:55','512',0.00,0.00,'512','2022-10-01 14:28:34','512','2022-10-01 14:28:48',10,0),('1','158',257509,'DAILY SHIFT','2022-09-30','2022-10-01 14:29:13','2022-10-04 14:29:13','512',0.00,0.00,'512','2022-10-01 14:38:43','512','2022-10-01 14:38:55',10,0),('1','158',257510,'DAILY SHIFT','2022-10-01','2022-10-01 14:39:13','2022-10-04 14:39:13','512',0.00,0.00,'512','2022-10-03 11:28:36','512','2022-10-03 11:28:51',10,0),('1','158',257511,'DAILY SHIFT','2022-10-02','2022-10-03 11:29:19','2022-10-06 11:29:19','512',0.00,0.00,'512','2022-10-04 00:18:35','512','2022-10-04 00:18:50',10,0),('1','158',257512,'DAILY SHIFT','2022-10-03','2022-10-04 00:19:15','2022-10-07 00:19:15','512',0.00,0.00,'512','2022-10-05 11:19:43','512','2022-10-05 11:19:58',10,0),('1','158',257513,'DAILY SHIFT','2022-10-04','2022-10-05 11:20:40','2022-10-12 11:20:40','512',0.00,0.00,'512','2022-10-07 07:47:24','512','2022-10-07 07:47:39',10,0),('1','158',257514,'DAILY SHIFT','2022-10-06','2022-10-07 07:48:10','2022-10-10 07:48:10','512',0.00,0.00,'512','2022-10-07 14:40:46','512','2022-10-07 14:40:59',10,0),('1','158',257515,'DAILY SHIFT','2022-10-07','2022-10-07 14:41:22','2022-10-10 14:41:22','512',0.00,0.00,'512','2022-10-09 15:23:23','512','2022-10-09 15:23:37',10,0),('1','158',257516,'DAILY SHIFT','2022-10-08','2022-10-09 15:24:20','2022-10-12 15:24:20','512',0.00,0.00,'512','2022-10-09 15:36:17','512','2022-10-09 15:36:31',10,0),('1','158',257517,'DAILY SHIFT','2022-10-09','2022-10-09 15:36:58','2022-10-12 15:36:58','512',0.00,0.00,'512','2022-10-10 19:21:08','512','2022-10-10 19:21:22',10,0),('1','158',257518,'DAILY SHIFT','2022-10-10','2022-10-10 19:21:47','2022-10-13 19:21:47','512',0.00,0.00,'512','2022-10-11 10:20:42','512','2022-10-11 10:20:56',10,0),('1','158',257519,'DAILY SHIFT','2022-10-11','2022-10-11 10:21:14','2022-10-14 10:21:14','512',0.00,0.00,'512','2022-10-13 10:54:32','512','2022-10-13 10:54:51',10,0),('1','158',257520,'DAILY SHIFT','2022-10-12','2022-10-13 10:55:17','2022-10-16 10:55:17','512',0.00,0.00,'512','2022-10-14 09:02:46','512','2022-10-14 09:03:00',10,0),('1','158',257521,'DAILY SHIFT','2022-10-13','2022-10-14 09:03:24','2022-10-17 09:03:24','512',0.00,0.00,'512','2022-10-15 08:21:27','512','2022-10-15 08:21:42',10,0),('1','158',257522,'DAILY SHIFT','2022-10-14','2022-10-15 08:22:03','2022-10-18 08:22:03','512',0.00,0.00,'512','2022-10-15 20:27:33','512','2022-10-15 20:30:13',10,0),('1','158',257523,'DAILY SHIFT','2022-10-15','2022-10-15 20:30:42','2022-10-18 20:30:42','512',0.00,0.00,'512','2022-10-16 19:07:51','512','2022-10-16 19:08:10',10,0),('1','158',257524,'DAILY SHIFT','2022-10-16','2022-10-16 19:08:34','2022-10-19 19:08:34','512',0.00,0.00,'512','2022-10-17 16:24:54','512','2022-10-17 16:25:08',10,0),('1','158',257525,'DAILY SHIFT','2022-10-17','2022-10-17 16:25:32','2022-10-20 16:25:32','512',0.00,0.00,'512','2022-10-18 17:36:49','512','2022-10-18 17:37:03',10,0),('1','158',257526,'DAILY SHIFT','2022-10-18','2022-10-18 17:37:26','2022-10-21 17:37:26','512',0.00,0.00,'512','2022-10-19 16:50:59','512','2022-10-19 16:51:12',10,0),('1','158',257527,'DAILY SHIFT','2022-10-19','2022-10-19 16:51:33','2022-10-22 16:51:33','512',0.00,0.00,'512','2022-10-20 07:45:22','512','2022-10-20 07:45:38',10,0),('1','158',257528,'DAILY SHIFT','2022-10-20','2022-10-20 07:45:59','2022-10-23 07:45:59','512',0.00,0.00,'512','2022-10-22 12:13:50','512','2022-10-22 12:14:03',10,0),('1','158',257529,'DAILY SHIFT','2022-10-21','2022-10-22 12:14:34','2022-10-23 12:14:34','512',0.00,0.00,'512','2022-10-22 12:22:14','512','2022-10-22 12:22:27',10,0),('1','158',257530,'DAILY SHIFT','2022-10-22','2022-10-22 12:23:01','2022-10-25 12:23:01','512',0.00,0.00,'512','2022-10-24 09:14:09','512','2022-10-24 09:14:41',10,0),('1','158',257531,'DAILY SHIFT','2022-10-23','2022-10-24 09:15:17','2022-10-27 09:15:17','512',0.00,0.00,'512','2022-10-25 06:52:41','512','2022-10-25 06:52:54',10,0),('1','158',257532,'DAILY SHIFT','2022-10-24','2022-10-25 06:53:15','2022-10-28 06:53:15','512',0.00,0.00,'512','2022-10-25 16:57:22','512','2022-10-25 16:57:37',10,0),('1','158',257533,'DAILY SHIFT','2022-10-25','2022-10-25 16:58:07','2022-10-28 16:58:07','512',0.00,0.00,'512','2022-10-26 17:29:39','512','2022-10-26 17:29:53',10,0),('1','158',257534,'DAILY SHIFT','2022-10-26','2022-10-26 17:30:11','2022-11-02 17:30:11','512',0.00,0.00,'512','2022-10-30 06:01:55','512','2022-10-30 06:04:13',10,0),('1','158',257535,'DAILY SHIFT','2022-10-27','2022-10-30 06:04:42','2022-11-06 06:04:42','512',0.00,0.00,'512','2022-10-31 21:31:21','512','2022-10-31 21:31:50',10,0),('1','158',257536,'DAILY SHIFT','2022-10-28','2022-10-31 21:32:24','2022-11-01 21:32:24','512',0.00,0.00,'512','2022-10-31 21:41:10','512','2022-10-31 21:41:26',10,0),('1','158',257537,'DAILY SHIFT','2022-10-29','2022-10-31 21:42:11','2022-11-01 21:42:11','512',0.00,0.00,'512','2022-10-31 23:21:07','512','2022-10-31 23:21:23',10,0),('1','158',257538,'DAILY SHIFT','2022-10-30','2022-10-31 23:21:49','2022-11-07 23:21:49','512',0.00,0.00,'512','2022-11-07 16:11:36','512','2022-11-07 16:11:56',10,0),('1','158',257539,'DAILY SHIFT','2022-11-03','2022-11-07 16:13:53','2022-11-08 16:13:53','512',0.00,0.00,'512','2022-11-07 16:37:35','512','2022-11-07 16:37:51',10,0),('1','158',257540,'DAILY SHIFT','2022-11-04','2022-11-07 16:38:32','2022-11-08 16:38:32','512',0.00,0.00,'512','2022-11-07 17:21:17','512','2022-11-07 17:21:31',10,0),('1','158',257541,'DAILY SHIFT','2022-11-05','2022-11-07 17:21:55','2022-11-08 17:21:55','512',0.00,0.00,'512','2022-11-07 17:43:01','512','2022-11-07 17:43:15',10,0),('1','158',257542,'DAILY SHIFT','2022-11-06','2022-11-07 17:43:34','2022-11-08 17:43:34','512',0.00,0.00,'512','2022-11-07 17:55:02','512','2022-11-07 17:55:18',10,0),('1','158',257543,'DAILY SHIFT','2022-11-07','2022-11-07 17:55:41','2022-11-10 17:55:41','512',0.00,0.00,'512','2022-11-08 11:48:08','512','2022-11-08 11:48:23',10,0),('1','158',257544,'DAILY SHIFT','2022-11-08','2022-11-08 11:48:59','2022-11-11 11:48:59','512',0.00,0.00,'512','2022-11-09 13:55:22','512','2022-11-09 13:55:35',10,0),('1','158',257545,'DAILY SHIFT','2022-11-09','2022-11-09 13:56:00','2022-11-12 13:56:00','512',0.00,0.00,'512','2022-11-11 11:36:52','512','2022-11-11 11:37:05',10,0),('1','158',257546,'DAILY SHIFT','2022-11-10','2022-11-11 11:37:25','2022-11-12 11:37:25','512',0.00,0.00,'512','2022-11-11 11:42:05','512','2022-11-11 11:42:18',10,0),('1','158',257547,'DAILY SHIFT','2022-11-11','2022-11-11 11:42:36','2022-11-14 11:42:36','512',0.00,0.00,'512','2022-11-11 11:47:23','512','2022-11-11 11:47:36',10,0),('1','158',257548,'DAILY SHIFT','2022-11-11','2022-11-11 11:48:01','2022-11-14 11:48:01','512',0.00,0.00,'512','2022-11-13 11:14:36','512','2022-11-13 11:14:49',10,0),('1','158',257549,'DAILY SHIFT','2022-11-12','2022-11-13 11:15:10','2022-11-14 11:15:10','512',0.00,0.00,'512','2022-11-13 11:18:28','512','2022-11-13 11:18:42',10,0),('1','158',257550,'DAILY SHIFT','2022-11-13','2022-11-13 11:19:00','2022-11-16 11:19:00','512',0.00,0.00,'512','2022-11-14 17:07:02','512','2022-11-14 17:07:15',10,0),('1','158',257551,'DAILY SHIFT','2022-11-14','2022-11-14 17:07:33','2022-11-17 17:07:33','512',0.00,0.00,'512','2022-11-16 11:12:42','512','2022-11-16 11:12:56',10,0),('1','158',257552,'DAILY SHIFT','2022-11-15','2022-11-16 11:13:19','2022-11-17 11:13:19','512',0.00,0.00,'512','2022-11-16 11:16:57','512','2022-11-16 11:17:19',10,0),('1','158',257553,'DAILY SHIFT','2022-11-16','2022-11-16 11:17:41','2022-11-19 11:17:41','512',0.00,0.00,'512','2022-11-17 16:24:06','512','2022-11-17 16:24:19',10,0),('1','158',257554,'DAILY SHIFT','2022-11-17','2022-11-17 16:24:38','2022-11-20 16:24:38','512',0.00,0.00,'512','2022-11-20 14:37:51','512','2022-11-20 14:38:09',10,0),('1','158',257555,'DAILY SHIFT','2022-11-18','2022-11-20 14:40:40','2022-11-21 14:40:40','512',0.00,0.00,'512','2022-11-20 14:44:47','512','2022-11-20 14:45:04',10,0),('1','158',257556,'DAILY SHIFT','2022-11-19','2022-11-20 14:45:25','2022-11-21 14:45:25','512',0.00,0.00,'512','2022-11-20 14:56:10','512','2022-11-20 14:56:30',10,0),('1','158',257557,'DAILY SHIFT','2022-11-20','2022-11-20 14:56:54','2022-11-23 14:56:54','512',0.00,0.00,'512','2022-11-22 17:15:44','512','2022-11-22 17:15:59',10,0),('1','158',257558,'DAILY SHIFT','2022-11-21','2022-11-22 17:16:21','2022-11-23 17:16:21','512',0.00,0.00,'512','2022-11-22 17:21:08','512','2022-11-22 17:21:22',10,0),('1','158',257559,'DAILY SHIFT','2022-11-22','2022-11-22 17:21:56','2022-11-25 17:21:56','512',0.00,0.00,'512','2022-11-25 08:39:41','512','2022-11-25 08:39:57',10,0),('1','158',257560,'DAILY SHIFT','2022-11-23','2022-11-25 08:40:15','2022-11-26 08:40:15','512',0.00,0.00,'512','2022-11-25 08:42:21','512','2022-11-25 08:42:41',10,0),('1','158',257561,'DAILY SHIFT','2022-11-24','2022-11-25 08:43:06','2022-11-28 08:43:06','512',0.00,0.00,'512','2022-11-26 11:44:57','512','2022-11-26 11:45:11',10,0),('1','158',257562,'DAILY SHIFT','2022-11-25','2022-11-26 11:45:34','2022-11-29 11:45:34','512',0.00,0.00,'512','2022-11-28 08:11:13','512','2022-11-28 08:11:27',10,0),('1','158',257563,'DAILY SHIFT','2022-11-26','2022-11-28 08:11:48','2022-11-29 08:11:48','512',0.00,0.00,'512','2022-11-28 08:16:57','512','2022-11-28 08:17:11',10,0),('1','158',257564,'DAILY SHIFT','2022-11-27','2022-11-28 08:17:36','2022-12-01 08:17:36','512',0.00,0.00,'512','2022-11-28 12:51:27','512','2022-11-28 12:51:58',10,0),('1','158',257565,'DAILY SHIFT','2022-11-28','2022-11-28 12:52:23','2022-12-01 12:52:23','512',0.00,0.00,'512','2022-11-30 07:48:49','512','2022-11-30 07:49:01',10,0),('1','158',257566,'DAILY SHIFT','2022-11-29','2022-11-30 07:49:31','2022-12-03 07:49:31','512',0.00,0.00,'512','2022-12-01 14:23:48','512','2022-12-01 14:24:00',10,0),('1','158',257567,'DAILY SHIFT','2022-11-30','2022-12-01 14:24:21','2022-12-02 14:24:21','512',0.00,0.00,'512','2022-12-01 14:32:58','512','2022-12-01 14:33:11',10,0),('1','158',257568,'DAILY SHIFT','2022-12-01','2022-12-01 14:33:39','2022-12-04 14:33:39','512',0.00,0.00,'512','2022-12-03 09:38:48','512','2022-12-03 09:39:03',10,0),('1','158',257569,'DAILY SHIFT','2022-12-02','2022-12-03 09:39:33','2022-12-06 09:39:33','512',0.00,0.00,'512','2022-12-04 07:00:00','512','2022-12-04 07:00:14',10,0),('1','158',257570,'DAILY SHIFT','2022-12-03','2022-12-04 07:00:43','2022-12-07 07:00:43','512',0.00,0.00,'512','2022-12-05 14:58:34','512','2022-12-05 14:59:10',10,0),('1','158',257571,'DAILY SHIFT','2022-12-04','2022-12-05 14:59:46','2022-12-08 14:59:46','512',0.00,0.00,'512','2022-12-05 19:20:43','512','2022-12-05 19:20:57',10,0),('1','158',257572,'DAILY SHIFT','2022-12-05','2022-12-05 19:21:15','2022-12-08 19:21:15','512',0.00,0.00,'512','2022-12-07 14:04:00','512','2022-12-07 14:04:12',10,0),('1','158',257573,'DAILY SHIFT','2022-12-06','2022-12-07 14:04:36','2022-12-08 14:04:36','512',0.00,0.00,'512','2022-12-07 14:11:18','512','2022-12-07 14:11:30',10,0),('1','158',257574,'DAILY SHIFT','2022-12-07','2022-12-07 14:11:48','2022-12-10 14:11:48','512',0.00,0.00,'512','2022-12-08 17:24:24','512','2022-12-08 17:24:38',10,0),('1','158',257575,'DAILY SHIFT','2022-12-08','2022-12-08 17:25:08','2022-12-11 17:25:08','512',0.00,0.00,'512','2022-12-09 11:48:48','512','2022-12-09 11:48:59',10,0),('1','158',257576,'DAILY SHIFT','2022-12-09','2022-12-09 11:49:18','2022-12-12 11:49:18','512',0.00,0.00,'512','2022-12-10 10:55:19','512','2022-12-10 10:55:33',10,0),('1','158',257577,'DAILY SHIFT','2022-12-10','2022-12-10 10:55:56','2022-12-13 10:55:56','512',0.00,0.00,'512','2022-12-11 14:36:35','512','2022-12-11 14:36:51',10,0),('1','158',257578,'DAILY SHIFT','2022-12-11','2022-12-11 14:37:19','2022-12-14 14:37:19','512',0.00,0.00,'512','2022-12-12 18:53:58','512','2022-12-12 18:54:14',10,0),('1','158',257579,'DAILY SHIFT','2022-12-12','2022-12-12 18:54:38','2022-12-15 18:54:38','512',0.00,0.00,'512','2022-12-15 08:54:08','512','2022-12-15 08:54:20',10,0),('1','158',257580,'DAILY SHIFT','2022-12-13','2022-12-15 08:54:39','2022-12-16 08:54:39','512',0.00,0.00,'512','2022-12-15 08:56:21','512','2022-12-15 08:56:34',10,0),('1','158',257581,'DAILY SHIFT','2022-12-14','2022-12-15 08:56:50','2022-12-16 08:56:50','512',0.00,0.00,'512','2022-12-15 09:01:40','512','2022-12-15 09:01:54',10,0),('1','158',257582,'DAILY SHIFT','2022-12-15','2022-12-15 09:02:11','2022-12-18 09:02:11','512',0.00,0.00,'512','2022-12-16 15:56:46','512','2022-12-16 15:57:01',10,0),('1','158',257583,'DAILY SHIFT','2022-12-16','2022-12-16 15:57:20','2022-12-19 15:57:20','512',0.00,0.00,'512','2022-12-17 11:58:51','512','2022-12-17 11:59:09',10,0),('1','158',257584,'DAILY SHIFT','2022-12-17','2022-12-17 11:59:29','2022-12-20 11:59:29','512',0.00,0.00,'512','2022-12-18 12:06:35','512','2022-12-18 12:06:48',10,0),('1','158',257585,'DAILY SHIFT','2022-12-18','2022-12-18 12:07:06','2022-12-21 12:07:06','512',0.00,0.00,'512','2022-12-19 08:50:35','512','2022-12-19 08:50:50',10,0),('1','158',257586,'DAILY SHIFT','2022-12-19','2022-12-19 08:51:10','2022-12-22 08:51:10','512',0.00,0.00,'512','2022-12-21 08:41:42','512','2022-12-21 08:41:58',10,0),('1','158',257587,'DAILY SHIFT','2022-12-20','2022-12-21 08:42:29','2022-12-24 08:42:29','512',0.00,0.00,'512','2022-12-22 08:36:50','512','2022-12-22 08:37:03',10,0),('1','158',257588,'DAILY SHIFT','2022-12-21','2022-12-22 08:37:26','2022-12-25 08:37:26','512',0.00,0.00,'512','2022-12-23 09:53:06','512','2022-12-23 09:53:18',10,0),('1','158',257589,'DAILY SHIFT','2022-12-22','2022-12-23 09:53:42','2022-12-26 09:53:42','512',0.00,0.00,'512','2022-12-24 13:45:46','512','2022-12-24 13:45:59',10,0),('1','158',257590,'DAILY SHIFT','2022-12-23','2022-12-24 13:46:19','2022-12-25 13:46:19','512',0.00,0.00,'512','2022-12-24 14:02:46','512','2022-12-24 14:02:58',10,0),('1','158',257591,'DAILY SHIFT','2022-12-24','2022-12-24 14:03:16','2022-12-27 14:03:16','512',0.00,0.00,'512','2022-12-26 11:21:38','512','2022-12-26 11:21:51',10,0),('1','158',257592,'DAILY SHIFT','2022-12-25','2022-12-26 11:22:21','2022-12-29 11:22:21','512',0.00,0.00,'512','2022-12-26 18:05:51','512','2022-12-26 18:06:04',10,0),('1','158',257593,'DAILY SHIFT','2022-12-26','2022-12-26 18:06:27','2022-12-29 18:06:27','512',0.00,0.00,'512','2022-12-28 19:01:55','512','2022-12-28 19:02:12',10,0),('1','158',257594,'DAILY SHIFT','2022-12-27','2022-12-28 19:02:37','2022-12-29 19:02:37','512',0.00,0.00,'512','2022-12-28 19:09:01','512','2022-12-28 19:09:15',10,0),('1','158',257595,'DAILY SHIFT','2022-12-28','2022-12-28 19:09:41','2023-01-04 19:09:41','512',0.00,0.00,'512','2022-12-31 14:42:50','512','2022-12-31 14:43:16',10,0),('1','158',257596,'DAILY SHIFT','2022-12-29','2022-12-31 14:43:47','2023-01-07 14:43:47','512',0.00,0.00,'512','2023-01-03 20:53:32','512','2023-01-03 20:54:17',10,0),('1','158',257597,'DAILY SHIFT','2022-12-30','2023-01-03 20:56:33','2023-01-04 20:56:33','512',0.00,0.00,'512','2023-01-03 21:05:56','512','2023-01-03 21:06:15',10,0),('1','158',257598,'DAILY SHIFT','2022-12-31','2023-01-03 21:06:37','2023-01-04 21:06:37','512',0.00,0.00,'512','2023-01-03 21:16:34','512','2023-01-03 21:17:10',10,0),('1','158',257599,'DAILY SHIFT','2023-01-01','2023-01-03 21:17:50','2023-01-10 21:17:50','512',0.00,0.00,'512','2023-01-06 11:31:05','512','2023-01-06 11:31:19',10,0),('1','158',257600,'DAILY SHIFT','2023-01-02','2023-01-06 11:31:47','2023-01-07 11:31:47','512',0.00,0.00,'512','2023-01-07 11:44:46','512','2023-01-07 11:45:12',10,0),('1','158',257601,'DAILY SHIFT','2023-01-02','2023-01-07 11:45:58','2023-01-08 11:45:58','512',0.00,0.00,'512','2023-01-07 11:58:57','512','2023-01-07 11:59:24',10,0),('1','158',257602,'DAILY SHIFT','2023-01-03','2023-01-07 11:59:53','2023-01-14 11:59:53','512',0.00,0.00,'512','2023-01-07 12:36:57','512','2023-01-07 12:37:32',10,0),('1','158',257603,'DAILY SHIFT','2023-01-04','2023-01-07 12:38:26','2023-01-08 12:38:26','512',0.00,0.00,'512','2023-01-07 12:43:12','512','2023-01-07 12:43:26',10,0),('1','158',257604,'DAILY SHIFT','2023-01-05','2023-01-07 12:43:55','2023-01-14 12:43:55','512',0.00,0.00,'512','2023-01-09 11:32:03','512','2023-01-09 11:34:05',10,0),('1','158',257605,'DAILY SHIFT','2023-01-06','2023-01-09 11:34:52','2023-01-10 11:34:52','512',0.00,0.00,'512','2023-01-09 11:41:47','512','2023-01-09 11:42:00',10,0),('1','158',257606,'DAILY SHIFT','2023-01-07','2023-01-09 11:42:25','2023-01-16 11:42:25','512',0.00,0.00,'512','2023-01-09 12:12:49','512','2023-01-09 12:13:05',10,0),('1','158',257607,'DAILY SHIFT','2023-01-08','2023-01-09 12:13:29','2023-01-16 12:13:29','512',0.00,0.00,'512','2023-01-12 15:37:51','512','2023-01-12 15:38:05',10,0),('1','158',257608,'DAILY SHIFT','2023-01-09','2023-01-12 15:38:39','2023-01-13 15:38:39','512',0.00,0.00,'512','2023-01-12 15:52:06','512','2023-01-12 15:52:19',10,0),('1','158',257609,'DAILY SHIFT','2023-01-10','2023-01-12 15:54:06','2023-01-13 15:54:06','512',0.00,0.00,'512','2023-01-12 16:55:46','512','2023-01-12 16:55:59',10,0),('1','158',257610,'DAILY SHIFT','2023-01-11','2023-01-12 16:56:24','2023-01-19 16:56:24','512',0.00,0.00,'512','2023-01-13 11:42:29','512','2023-01-13 11:42:42',10,0),('1','158',257611,'DAILY SHIFT','2023-01-12','2023-01-13 11:43:04','2023-01-14 11:43:04','512',0.00,0.00,'512','2023-01-13 11:48:41','512','2023-01-13 11:49:01',10,0),('1','158',257612,'DAILY SHIFT','2023-01-13','2023-01-13 11:49:26','2023-01-16 11:49:26','512',0.00,0.00,'512','2023-01-15 14:13:02','512','2023-01-15 14:13:17',10,0),('1','158',257613,'DAILY SHIFT','2023-01-14','2023-01-15 14:13:39','2023-01-16 14:13:39','512',0.00,0.00,'512','2023-01-15 14:18:23','512','2023-01-15 14:18:36',10,0),('1','158',257614,'DAILY SHIFT','2023-01-15','2023-01-15 14:18:54','2023-01-18 14:18:54','512',0.00,0.00,'512','2023-01-17 10:02:59','512','2023-01-17 10:12:06',10,0),('1','158',257615,'DAILY SHIFT','2023-01-16','2023-01-17 10:12:38','2023-01-20 10:12:38','512',0.00,0.00,'512','2023-01-17 13:44:14','512','2023-01-17 13:44:27',10,0),('1','158',257616,'DAILY SHIFT','2023-01-17','2023-01-17 13:44:50','2023-01-20 13:44:50','512',0.00,0.00,'512','2023-01-18 13:41:55','512','2023-01-18 13:42:08',10,0),('1','158',257617,'DAILY SHIFT','2023-01-18','2023-01-18 13:42:31','2023-01-21 13:42:31','512',0.00,0.00,'512','2023-01-19 13:50:20','512','2023-01-19 13:50:35',10,0),('1','158',257618,'DAILY SHIFT','2023-01-19','2023-01-19 13:50:59','2023-01-22 13:50:59','512',0.00,0.00,'512','2023-01-21 12:10:16','512','2023-01-21 12:10:46',10,0),('1','158',257619,'DAILY SHIFT','2023-01-20','2023-01-21 12:24:24','2023-01-24 12:24:24','512',0.00,0.00,'512','2023-01-21 12:29:25','512','2023-01-21 12:29:38',10,0),('1','158',257620,'DAILY SHIFT','2023-01-21','2023-01-21 12:29:58','2023-01-24 12:29:58','512',0.00,0.00,'512','2023-01-22 16:59:13','512','2023-01-22 16:59:27',10,0),('1','158',257621,'DAILY SHIFT','2023-01-22','2023-01-22 16:59:47','2023-01-25 16:59:47','512',0.00,0.00,'512','2023-01-24 12:08:41','512','2023-01-24 12:08:57',10,0),('1','158',257622,'DAILY SHIFT','2023-01-23','2023-01-24 12:09:18','2023-01-27 12:09:18','512',0.00,0.00,'512','2023-01-25 15:10:37','512','2023-01-25 15:10:55',10,0),('1','158',257623,'DAILY SHIFT','2023-01-24','2023-01-25 15:11:31','2023-01-28 15:11:31','512',0.00,0.00,'512','2023-01-25 15:18:34','512','2023-01-25 15:18:48',10,0),('1','158',257624,'DAILY SHIFT','2023-01-25','2023-01-25 15:19:09','2023-01-28 15:19:09','512',0.00,0.00,'512','2023-01-26 12:09:02','512','2023-01-26 12:09:16',10,0),('1','158',257625,'DAILY SHIFT','2023-01-26','2023-01-26 12:09:33','2023-01-29 12:09:33','512',0.00,0.00,'512','2023-01-27 17:46:14','512','2023-01-27 17:46:26',10,0),('1','158',257626,'DAILY SHIFT','2023-01-27','2023-01-27 17:46:44','2023-01-30 17:46:44','512',0.00,0.00,'512','2023-01-28 15:35:30','512','2023-01-28 15:36:09',10,0),('1','158',257627,'DAILY SHIFT','2023-01-28','2023-01-28 15:36:31','2023-01-31 15:36:31','512',0.00,0.00,'512','2023-01-30 08:14:02','512','2023-01-30 08:14:24',10,0),('1','158',257628,'DAILY SHIFT','2023-01-29','2023-01-30 08:14:45','2023-02-02 08:14:45','512',0.00,0.00,'512','2023-01-30 14:59:16','512','2023-01-30 14:59:30',10,0),('1','158',257629,'DAILY SHIFT','2023-01-30','2023-01-30 14:59:49','2023-02-02 14:59:49','512',0.00,0.00,'512','2023-02-01 12:27:50','512','2023-02-01 12:28:04',10,0),('1','158',257630,'DAILY SHIFT','2023-01-31','2023-02-01 12:28:34','2023-02-04 12:28:34','512',0.00,0.00,'512','2023-02-02 10:36:49','512','2023-02-02 10:37:00',10,0),('1','158',257631,'DAILY SHIFT','2023-02-01','2023-02-02 10:37:24','2023-02-05 10:37:24','512',0.00,0.00,'512','2023-02-03 17:23:08','512','2023-02-03 17:23:22',10,0),('1','158',257632,'DAILY SHIFT','2023-02-02','2023-02-03 17:24:25','2023-02-06 17:24:25','512',0.00,0.00,'512','2023-02-03 17:33:52','512','2023-02-03 17:34:52',10,0),('1','158',257633,'DAILY SHIFT','2023-02-03','2023-02-03 17:35:18','2023-02-06 17:35:18','512',0.00,0.00,'512','2023-02-05 09:12:21','512','2023-02-05 09:12:34',10,0),('1','158',257634,'DAILY SHIFT','2023-02-04','2023-02-05 09:12:56','2023-02-08 09:12:56','512',0.00,0.00,'512','2023-02-06 13:52:00','512','2023-02-06 13:52:15',10,0),('1','158',257635,'DAILY SHIFT','2023-02-05','2023-02-06 13:52:35','2023-02-09 13:52:35','512',0.00,0.00,'512','2023-02-06 13:56:06','512','2023-02-06 13:56:20',10,0),('1','158',257636,'DAILY SHIFT','2023-02-06','2023-02-06 13:56:44','2023-02-09 13:56:44','512',0.00,0.00,'512','2023-02-08 14:38:00','512','2023-02-08 14:38:13',10,0),('1','158',257637,'DAILY SHIFT','2023-02-07','2023-02-08 14:38:37','2023-02-15 14:38:37','512',0.00,0.00,'512','2023-02-08 14:45:43','512','2023-02-08 14:45:55',10,0),('1','158',257638,'DAILY SHIFT','2023-02-08','2023-02-08 14:46:15','2023-02-15 14:46:15','512',0.00,0.00,'512','2023-02-16 12:29:31','512','2023-02-16 12:29:50',10,0),('1','158',257639,'DAILY SHIFT','2023-02-08','2023-02-16 12:30:30','2023-02-19 12:30:30','512',0.00,0.00,'512','2023-02-16 12:39:56','512','2023-02-16 12:40:19',10,0),('1','158',257640,'DAILY SHIFT','2023-02-09','2023-02-16 12:40:41','2023-02-17 12:40:41','512',0.00,0.00,'512','2023-02-16 12:43:34','512','2023-02-16 12:43:48',10,0),('1','158',257641,'DAILY SHIFT','2023-02-10','2023-02-16 12:44:34','2023-02-19 12:44:34','512',0.00,0.00,'512','2023-02-16 13:06:33','512','2023-02-16 13:07:43',10,0),('1','158',257642,'DAILY SHIFT','2023-02-11','2023-02-16 13:08:44','2023-02-19 13:08:44','512',0.00,0.00,'512','2023-02-16 13:29:13','512','2023-02-16 13:29:52',10,0),('1','158',257643,'DAILY SHIFT','2023-02-12','2023-02-16 13:31:07','2023-02-19 13:31:07','512',0.00,0.00,'512','2023-02-16 14:17:07','512','2023-02-16 14:17:23',10,0),('1','158',257644,'DAILY SHIFT','2023-02-13','2023-02-16 14:18:08','2023-02-23 14:18:08','512',0.00,0.00,'512','2023-02-23 16:40:35','512','2023-02-23 16:40:49',10,0),('1','158',257645,'DAILY SHIFT','2023-02-13','2023-02-23 16:41:37','2023-02-24 16:41:37','512',0.00,0.00,'512','2023-02-23 16:58:08','512','2023-02-23 16:58:46',10,0),('1','158',257646,'DAILY SHIFT','2023-02-14','2023-02-23 16:59:28','2023-02-24 16:59:28','512',0.00,0.00,'512','2023-02-23 17:04:40','512','2023-02-23 17:05:16',10,0),('1','158',257647,'DAILY SHIFT','2023-02-15','2023-02-23 17:06:14','2023-02-24 17:06:14','512',0.00,0.00,'512','2023-02-23 17:28:18','512','2023-02-23 17:28:43',10,0),('1','158',257648,'DAILY SHIFT','2023-02-16','2023-02-23 17:29:12','2023-02-24 17:29:12','512',0.00,0.00,'512','2023-02-23 17:33:20','512','2023-02-23 17:33:45',10,0),('1','158',257649,'DAILY SHIFT','2023-02-17','2023-02-23 17:34:20','2023-02-24 17:34:20','512',0.00,0.00,'512','2023-02-23 17:50:45','512','2023-02-23 17:50:59',10,0),('1','158',257650,'DAILY SHIFT','2023-02-18','2023-02-23 17:51:21','2023-02-24 17:51:21','512',0.00,0.00,'512','2023-02-23 17:56:11','512','2023-02-23 17:56:34',10,0),('1','158',257651,'DAILY SHIFT','2023-02-18','2023-02-23 17:56:51','2023-02-24 17:56:51','512',0.00,0.00,'512','2023-02-23 18:13:57','512','2023-02-23 18:14:13',10,0),('1','158',257652,'DAILY SHIFT','2023-02-19','2023-02-23 18:14:33','2023-02-24 18:14:33','512',0.00,0.00,'512','2023-02-23 18:26:49','512','2023-02-23 18:27:03',10,0),('1','158',257653,'DAILY SHIFT','2023-02-20','2023-02-23 18:27:23','2023-02-24 18:27:23','512',0.00,0.00,'512','2023-02-23 18:40:51','512','2023-02-23 18:41:23',10,0),('1','158',257654,'DAILY SHIFT','2023-02-21','2023-02-23 18:42:01','2023-02-24 18:42:01','512',0.00,0.00,'512','2023-02-23 19:11:01','512','2023-02-23 19:11:18',10,0),('1','158',257655,'DAILY SHIFT','2023-02-22','2023-02-23 19:12:36','2023-03-02 19:12:36','512',0.00,0.00,'512','2023-02-24 11:25:58','512','2023-02-24 11:26:14',10,0),('1','158',257656,'DAILY SHIFT','2023-02-23','2023-02-24 11:26:36','2023-03-03 11:26:36','512',0.00,0.00,'512','2023-02-24 19:21:51','512','2023-02-24 19:22:06',10,0),('1','158',257657,'DAILY SHIFT','2023-02-24','2023-02-24 19:22:25','2023-03-03 19:22:25','512',0.00,0.00,'512','2023-02-26 19:50:41','512','2023-02-26 19:50:56',10,0),('1','158',257658,'DAILY SHIFT','2023-02-24','2023-02-26 19:51:24','2023-02-27 19:51:24','512',0.00,0.00,'512','2023-02-26 19:55:47','512','2023-02-26 19:56:06',10,0),('1','158',257659,'DAILY SHIFT','2023-02-26','2023-02-26 19:56:29','2023-03-01 19:56:29','512',0.00,0.00,'512','2023-03-01 15:46:42','512','2023-03-01 15:46:54',10,0),('1','158',257660,'DAILY SHIFT','2023-02-27','2023-03-01 15:47:17','2023-03-02 15:47:17','512',0.00,0.00,'512','2023-03-01 15:52:07','512','2023-03-01 15:52:26',10,0),('1','158',257661,'DAILY SHIFT','2023-02-28','2023-03-01 15:52:53','2023-03-04 15:52:53','512',0.00,0.00,'512','2023-03-02 16:36:48','512','2023-03-02 16:37:02',10,0),('1','158',257662,'DAILY SHIFT','2023-03-01','2023-03-02 16:37:52','2023-03-09 16:37:52','512',0.00,0.00,'512','2023-03-02 16:45:21','512','2023-03-02 16:45:34',10,0),('1','158',257663,'DAILY SHIFT','2023-03-02','2023-03-02 16:45:55','2023-03-05 16:45:55','512',0.00,0.00,'512','2023-03-03 12:38:22','512','2023-03-03 12:38:36',10,0),('1','158',257664,'DAILY SHIFT','2023-03-03','2023-03-03 12:38:54','2023-03-06 12:38:54','512',0.00,0.00,'512','2023-03-05 20:39:27','512','2023-03-05 20:39:47',10,0),('1','158',257665,'DAILY SHIFT','2023-03-04','2023-03-05 20:40:11','2023-03-08 20:40:11','512',0.00,0.00,'512','2023-03-05 20:45:39','512','2023-03-05 20:45:51',10,0),('1','158',257666,'DAILY SHIFT','2023-03-05','2023-03-05 20:46:16','2023-03-08 20:46:16','512',0.00,0.00,'512','2023-03-06 16:42:56','512','2023-03-06 16:43:08',10,0),('1','158',257667,'DAILY SHIFT','2023-03-06','2023-03-06 16:43:26','2023-03-09 16:43:26','512',0.00,0.00,'512','2023-03-07 19:18:35','512','2023-03-07 19:18:48',10,0),('1','158',257668,'DAILY SHIFT','2023-03-07','2023-03-07 19:19:04','2023-03-10 19:19:04','512',0.00,0.00,'512','2023-03-09 14:16:02','512','2023-03-09 14:16:16',10,0),('1','158',257669,'DAILY SHIFT','2023-03-08','2023-03-09 14:16:37','2023-03-12 14:16:37','512',0.00,0.00,'512','2023-03-10 12:52:00','512','2023-03-10 12:52:13',10,0),('1','158',257670,'DAILY SHIFT','2023-03-09','2023-03-10 12:52:35','2023-03-13 12:52:35','512',0.00,0.00,'512','2023-03-10 12:58:40','512','2023-03-10 12:58:58',10,0),('1','158',257671,'DAILY SHIFT','2023-03-10','2023-03-10 12:59:18','2023-03-17 12:59:18','512',0.00,0.00,'512','2023-03-12 19:15:34','512','2023-03-12 19:15:47',10,0),('1','158',257672,'DAILY SHIFT','2023-03-11','2023-03-12 19:16:13','2023-03-15 19:16:13','512',0.00,0.00,'512','2023-03-14 14:40:18','512','2023-03-14 14:40:32',10,0),('1','158',257673,'DAILY SHIFT','2023-03-12','2023-03-14 14:40:56','2023-03-15 14:40:56','512',0.00,0.00,'512','2023-03-14 14:43:07','512','2023-03-14 14:43:32',10,0),('1','158',257674,'DAILY SHIFT','2023-03-13','2023-03-14 14:44:03','2023-03-21 14:44:03','512',0.00,0.00,'512','2023-03-14 15:15:46','512','2023-03-14 15:16:00',10,0),('1','158',257675,'DAILY SHIFT','2023-03-14','2023-03-14 15:16:19','2023-03-21 15:16:19','512',0.00,0.00,'512','2023-03-17 13:54:39','512','2023-03-17 13:54:56',10,0),('1','158',257676,'DAILY SHIFT','2023-03-15','2023-03-17 13:55:26','2023-03-24 13:55:26','512',0.00,0.00,'512','2023-03-17 15:06:52','512','2023-03-17 15:07:06',10,0),('1','158',257677,'DAILY SHIFT','2023-03-16','2023-03-17 15:07:27','2023-03-24 15:07:27','512',0.00,0.00,'512','2023-03-18 13:26:31','512','2023-03-18 13:26:59',10,0),('1','158',257678,'DAILY SHIFT','2023-03-17','2023-03-18 13:27:22','2023-03-25 13:27:22','512',0.00,0.00,'512','2023-03-19 15:50:52','512','2023-03-19 15:51:09',10,0),('1','158',257679,'DAILY SHIFT','2023-03-18','2023-03-19 15:51:39','2023-03-26 15:51:39','512',0.00,0.00,'512','2023-03-20 14:54:07','512','2023-03-20 14:54:24',10,0),('1','158',257680,'DAILY SHIFT','2023-03-19','2023-03-20 14:55:00','2023-03-27 14:55:00','512',0.00,0.00,'512','2023-03-20 17:56:43','512','2023-03-20 17:57:34',10,0),('1','158',257681,'DAILY SHIFT','2023-03-20','2023-03-20 17:58:49','2023-03-23 17:58:49','512',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4900250 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','158','780','147201',2942843,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147201',2942844,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147214',2942994,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147214',2942995,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147217',2943027,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147217',2943028,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147221',2943063,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147221',2943064,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147226',2943120,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147226',2943121,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147232',2943159,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147232',2943160,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147234',2943177,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147234',2943178,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147245',2943381,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147245',2943382,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147273',2943808,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147273',2943809,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147284',2943967,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147284',2943968,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147287',2943973,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147287',2943974,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147289',2943997,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147289',2943998,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','147969',2956100,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','147969',2956101,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148040',2957138,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148040',2957139,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148927',2972586,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148927',2972587,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148935',2972789,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148935',2972790,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148941',2972930,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148941',2972931,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148977',2973465,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148977',2973466,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','148980',2973551,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','148980',2973552,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150174',2995138,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150174',2995139,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150180',2995204,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150180',2995205,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150187',2995307,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150187',2995308,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150190',2995334,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150190',2995335,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150194',2995368,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150194',2995369,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150197',2995403,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150197',2995404,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150203',2995478,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150203',2995479,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150214',2995675,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150214',2995676,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150215',2995677,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150215',2995678,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150218',2995751,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150218',2995752,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150220',2995769,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150220',2995770,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150225',2995857,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150225',2995858,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150237',2996023,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150237',2996024,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150246',2996150,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150246',2996151,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150247',2996152,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150247',2996153,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150250',2996192,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150250',2996193,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150253',2996219,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150253',2996220,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150278',2996665,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150278',2996666,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150283',2996720,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150283',2996721,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150285',2996730,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150285',2996731,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150288',2996748,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150288',2996749,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150334',2997491,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150334',2997492,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150733',3005568,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150733',3005569,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150738',3005626,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150738',3005627,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150754',3005910,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150754',3005911,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150761',3006015,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150761',3006016,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','150788',3006508,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','150788',3006509,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151084',3011902,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151084',3011903,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151088',3011950,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151088',3011951,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151474',3019106,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151474',3019107,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151477',3019142,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151477',3019143,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151478',3019144,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151478',3019145,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151791',3024944,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151791',3024945,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','151793',3024974,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','151793',3024975,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','152387',3036140,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','152387',3036141,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','152409',3036576,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','152409',3036577,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153028',3047819,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153028',3047820,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153044',3048032,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153044',3048033,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153048',3048070,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153048',3048071,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153054',3048154,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153054',3048155,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153057',3048178,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153057',3048179,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153161',3050069,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153161',3050070,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153165',3050156,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153165',3050157,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153330',3052950,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153330',3052951,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','153753',3060820,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','153753',3060821,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','154544',3075222,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','154544',3075223,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','154547',3075265,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','154547',3075266,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','154552',3075346,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','154552',3075347,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','154554',3075376,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','154554',3075377,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','154555',3075378,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','154555',3075379,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155188',3087095,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155188',3087096,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155207',3087534,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155207',3087535,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155211',3087616,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155211',3087617,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155866',3099612,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155866',3099613,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155868',3099627,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155868',3099628,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','155873',3099689,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','155873',3099690,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156015',3102242,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156015',3102243,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156018',3102290,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156018',3102291,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156032',3102588,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156032',3102589,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156066',3103288,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156066',3103289,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156068',3103308,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156068',3103309,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156069',3103310,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156069',3103311,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156284',3107050,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156284',3107051,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156351',3108207,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156351',3108208,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','156521',3111442,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','156521',3111443,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','157397',3127069,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','157397',3127070,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','157839',3135034,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','157839',3135035,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','157842',3135080,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','157842',3135081,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','157844',3135105,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','157844',3135106,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','157978',3137755,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','157978',3137756,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158044',3139008,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158044',3139009,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158046',3139027,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158046',3139028,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158478',3147101,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158478',3147102,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158481',3147146,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158481',3147147,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158482',3147148,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158482',3147149,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158688',3150946,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158688',3150947,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','158848',3153549,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','158848',3153550,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159061',3157477,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159061',3157478,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159135',3158619,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159135',3158620,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159143',3158817,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159143',3158818,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159356',3162481,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159356',3162482,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159644',3167483,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159644',3167484,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159645',3167485,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159645',3167486,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159832',3170696,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159832',3170697,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','159957',3172884,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','159957',3172885,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','160029',3174244,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','160029',3174245,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','160173',3176995,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','160173',3176996,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','160391',3180952,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','160391',3180953,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','160667',3185806,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','160667',3185807,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161033',3192250,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161033',3192251,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161036',3192298,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161036',3192299,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161042',3192395,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161042',3192396,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161043',3192397,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161043',3192398,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161170',3194687,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161170',3194688,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161312',3196950,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161312',3196951,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161701',3203356,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161701',3203357,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','161752',3204281,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','161752',3204282,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','162267',3213532,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','162267',3213533,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','162269',3213550,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','162269',3213551,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','162345',3214785,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','162345',3214786,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','162561',3218248,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','162561',3218249,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163041',3226734,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163041',3226735,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163043',3226748,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163043',3226749,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163100',3227781,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163100',3227782,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163311',3231661,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163311',3231662,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163387',3232927,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163387',3232928,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163716',3239044,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163716',3239045,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163917',3242490,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163917',3242491,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','163919',3242511,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','163919',3242512,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','164372',3251022,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','164372',3251023,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','164939',3261126,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','164939',3261127,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','164943',3261201,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','164943',3261202,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165211',3265899,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165211',3265900,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165214',3265978,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165214',3265979,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165217',3266013,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165217',3266014,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165877',3277921,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165877',3277922,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165881',3277997,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165881',3277998,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165898',3278300,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165898',3278301,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','165901',3278332,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','165901',3278333,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','167101',3299481,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','167101',3299482,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','167110',3299626,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','167110',3299627,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','167112',3299652,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','167112',3299653,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','167120',3299777,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','167120',3299778,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168500',3324633,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168500',3324634,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168515',3324866,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168515',3324867,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168517',3324881,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168517',3324882,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168520',3324938,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168520',3324939,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168533',3325160,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168533',3325161,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168539',3325247,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168539',3325248,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168544',3325335,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168544',3325336,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168561',3325662,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168561',3325663,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168733',3328926,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168733',3328927,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','168986',3333375,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','168986',3333376,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','169155',3336249,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','169155',3336250,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','169159',3336307,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','169159',3336308,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170093',3354263,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170093',3354264,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170097',3354289,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170097',3354290,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170099',3354302,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170099',3354303,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170105',3354359,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170105',3354360,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170107',3354411,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170107',3354412,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170220',3356230,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170220',3356231,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170517',3361388,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170517',3361389,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170579',3362630,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170579',3362631,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','170790',3366480,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','170790',3366481,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','171527',3379896,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','171527',3379897,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','171532',3379973,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','171532',3379974,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','171534',3379998,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','171534',3379999,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','171535',3380000,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','171535',3380001,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','171739',3383673,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','171739',3383674,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','172553',3398344,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','172553',3398345,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','172558',3398425,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','172558',3398426,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','172559',3398427,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','172559',3398428,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','172567',3398565,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','172567',3398566,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','173588',3417716,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','173588',3417717,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','173590',3417758,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','173590',3417759,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','173592',3417761,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','173592',3417762,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','173594',3417781,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','173594',3417782,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174034',3425649,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174034',3425650,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174038',3425721,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174038',3425722,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174708',3437452,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174708',3437453,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174713',3437534,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174713',3437535,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174741',3438140,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174741',3438141,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','174745',3438202,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','174745',3438203,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','175590',3453946,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','175590',3453947,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','175630',3454599,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','175630',3454600,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','175632',3454615,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','175632',3454616,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','175635',3454636,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','175635',3454637,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','175655',3455027,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','175655',3455028,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176002',3461375,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176002',3461376,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176270',3466338,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176270',3466339,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176273',3466385,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176273',3466386,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176643',3473288,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176643',3473289,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176657',3473506,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176657',3473507,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','176862',3477267,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','176862',3477268,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','177212',3484030,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','177212',3484031,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','177836',3496139,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','177836',3496140,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','177838',3496147,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','177838',3496148,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','177844',3496244,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','177844',3496245,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','178370',3506151,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','178370',3506152,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','178380',3506365,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','178380',3506366,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','178968',3516970,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','178968',3516971,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','178977',3517156,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','178977',3517157,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179321',3523927,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179321',3523928,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179327',3524066,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179327',3524067,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179330',3524095,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179330',3524096,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179495',3527052,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179495',3527053,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179949',3535723,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179949',3535724,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','179952',3535769,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','179952',3535770,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180269',3541600,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180269',3541601,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180275',3541691,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180275',3541692,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180831',3551731,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180831',3551732,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180834',3551786,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180834',3551787,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180835',3551788,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180835',3551789,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','180839',3551837,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','180839',3551838,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','181623',3566651,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','181623',3566652,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','181630',3566777,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','181630',3566778,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','181633',3566808,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','181633',3566809,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','181640',3566920,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','181640',3566921,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','184998',3627566,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','184998',3627567,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185035',3628285,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185035',3628286,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185037',3628304,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185037',3628305,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185058',3628691,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185058',3628692,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185064',3628815,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185064',3628816,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185158',3630337,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185158',3630338,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185159',3630339,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185159',3630340,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185160',3630341,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185160',3630342,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185181',3630769,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185181',3630770,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185202',3631201,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185202',3631202,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185207',3631251,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185207',3631252,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185208',3631253,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185208',3631254,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185214',3631321,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185214',3631322,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185217',3631353,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185217',3631354,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185218',3631355,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185218',3631356,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185314',3632813,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185314',3632814,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185316',3632849,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185316',3632850,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185317',3632851,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185317',3632852,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185828',3642269,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185828',3642270,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185831',3642322,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185831',3642323,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','185931',3644193,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','185931',3644194,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','186150',3647905,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','186150',3647906,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','186155',3647965,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','186155',3647966,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','186417',3652242,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','186417',3652243,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','186628',3656087,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','186628',3656088,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','186906',3660829,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','186906',3660830,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','187210',3665883,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','187210',3665884,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','187215',3665960,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','187215',3665961,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','187969',3679478,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','187969',3679479,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','187972',3679537,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','187972',3679538,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','187975',3679575,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','187975',3679576,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','188119',3681949,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','188119',3681950,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','188636',3690856,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','188636',3690857,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','188644',3690966,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','188644',3690967,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189329',3703536,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189329',3703537,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189491',3706226,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189491',3706227,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189500',3706404,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189500',3706405,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189501',3706406,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189501',3706407,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189506',3706526,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189506',3706527,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','189769',3711155,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','189769',3711156,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','190094',3717378,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','190094',3717379,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','190097',3717475,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','190097',3717476,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','190781',3730241,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','190781',3730242,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','190791',3730426,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','190791',3730427,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','191437',3741932,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','191437',3741933,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','191450',3742178,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','191450',3742179,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','191456',3742282,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','191456',3742283,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','191795',3748742,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','191795',3748743,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','191843',3749700,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','191843',3749701,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','192049',3753439,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','192049',3753440,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','192450',3760574,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','192450',3760575,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','192455',3760624,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','192455',3760625,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','192795',3766731,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','192795',3766732,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','192799',3766816,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','192799',3766817,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193029',3771213,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193029',3771214,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193030',3771215,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193030',3771216,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193035',3771315,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193035',3771316,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193499',3780453,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193499',3780454,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193503',3780506,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193503',3780507,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','193776',3785444,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','193776',3785445,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','194356',3795846,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','194356',3795847,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','194358',3795864,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','194358',3795865,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','194558',3799442,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','194558',3799443,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','194559',3799444,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','194559',3799445,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','195187',3811306,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','195187',3811307,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','195645',3819032,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','195645',3819033,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','195648',3819067,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','195648',3819068,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','195654',3819155,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','195654',3819156,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','195657',3819175,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','195657',3819176,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198057',3862138,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198057',3862139,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198059',3862169,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198059',3862170,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198060',3862171,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198060',3862172,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198065',3862280,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198065',3862281,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198190',3864317,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198190',3864318,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198199',3864433,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198199',3864434,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198202',3864453,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198202',3864454,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198211',3864590,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198211',3864591,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198218',3864675,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198218',3864676,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','198221',3864687,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','198221',3864688,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','199470',3885928,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','199470',3885929,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','199472',3885941,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','199472',3885942,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','199476',3886000,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','199476',3886001,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','199483',3886096,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','199483',3886097,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','199764',3890776,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','199764',3890777,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','200181',3898244,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','200181',3898245,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','200185',3898321,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','200185',3898322,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201027',3913139,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201027',3913140,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201029',3913157,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201029',3913158,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201031',3913173,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201031',3913174,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201698',3925516,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201698',3925517,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201700',3925548,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201700',3925549,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201704',3925590,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201704',3925591,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201708',3925695,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201708',3925696,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201958',3930248,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201958',3930249,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','201963',3930363,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','201963',3930364,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','202085',3932495,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','202085',3932496,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','202323',3936541,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','202323',3936542,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','202566',3940812,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','202566',3940813,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','202743',3943833,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','202743',3943834,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','203002',3948800,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','203002',3948801,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','203353',3955132,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','203353',3955133,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','203465',3957385,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','203465',3957386,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','203821',3963589,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','203821',3963590,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','204065',3967935,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','204065',3967936,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','204068',3967967,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','204068',3967968,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205452',3992853,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205452',3992854,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205456',3992907,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205456',3992908,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205457',3992909,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205457',3992910,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205550',3994397,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205550',3994398,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205557',3994519,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205557',3994520,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205564',3994630,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205564',3994631,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205829',3999416,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205829',3999417,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','205980',4002104,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','205980',4002105,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','206303',4007976,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','206303',4007977,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','206305',4007999,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','206305',4008000,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','206308',4008064,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','206308',4008065,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','206619',4013274,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','206619',4013275,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','206900',4018280,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','206900',4018281,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207178',4023369,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207178',4023370,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207184',4023469,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207184',4023470,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207605',4030995,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207605',4030996,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207607',4031013,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207607',4031014,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207966',4037013,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207966',4037014,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','207974',4037169,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','207974',4037170,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','208175',4040676,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','208175',4040677,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','208453',4045577,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','208453',4045578,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','208891',4053310,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','208891',4053311,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','208894',4053361,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','208894',4053362,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','209341',4061142,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','209341',4061143,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','209348',4061255,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','209348',4061256,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','209953',4072097,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','209953',4072098,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','209969',4072380,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','209969',4072381,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','210172',4075842,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','210172',4075843,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','210202',4076339,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','210202',4076340,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','210837',4087737,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','210837',4087738,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','210840',4087742,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','210840',4087743,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','210843',4087778,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','210843',4087779,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','211538',4100139,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','211538',4100140,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','211546',4100284,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','211546',4100285,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','211832',4104964,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','211832',4104965,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','211837',4105035,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','211837',4105036,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','211841',4105082,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','211841',4105083,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','212317',4113713,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','212317',4113714,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213231',4129762,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213231',4129763,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213236',4129834,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213236',4129835,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213240',4129874,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213240',4129875,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213251',4130038,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213251',4130039,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213334',4131473,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213334',4131474,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213992',4142348,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213992',4142349,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','213997',4142416,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','213997',4142417,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','214002',4142476,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','214002',4142477,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','214661',4153774,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','214661',4153775,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','214683',4154148,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','214683',4154149,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215539',4168656,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215539',4168657,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215554',4168889,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215554',4168890,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215557',4168908,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215557',4168909,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215562',4168972,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215562',4168973,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215574',4169186,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215574',4169187,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','215977',4176226,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','215977',4176227,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','216644',4187747,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','216644',4187748,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','216645',4187749,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','216645',4187750,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','216652',4187882,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','216652',4187883,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','216664',4188071,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','216664',4188072,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','216792',4190533,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','216792',4190534,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','217369',4200748,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','217369',4200749,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','217865',4209644,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','217865',4209645,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','217877',4209864,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','217877',4209865,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','217884',4209977,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','217884',4209978,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','218100',4213592,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','218100',4213593,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','218374',4218513,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','218374',4218514,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','218722',4224591,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','218722',4224592,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','218968',4228824,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','218968',4228825,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','219005',4229503,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','219005',4229504,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','219292',4234713,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','219292',4234714,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221006',4264839,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221006',4264840,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221011',4264985,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221011',4264986,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221015',4265052,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221015',4265053,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221021',4265140,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221021',4265141,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221024',4265182,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221024',4265183,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221032',4265362,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221032',4265363,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221033',4265364,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221033',4265365,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221256',4269246,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221256',4269247,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221524',4274300,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221524',4274301,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221529',4274463,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221529',4274464,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221881',4280521,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221881',4280522,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','221888',4280653,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','221888',4280654,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','222169',4285757,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','222169',4285758,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','222446',4290676,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','222446',4290677,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223259',4304867,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223259',4304868,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223263',4304898,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223263',4304899,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223269',4304946,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223269',4304947,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223428',4308017,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223428',4308018,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223789',4314725,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223789',4314726,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','223791',4314739,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','223791',4314740,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','224013',4318765,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','224013',4318766,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','224159',4321131,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','224159',4321132,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','224909',4334478,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','224909',4334479,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','224941',4335161,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','224941',4335162,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','224947',4335250,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','224947',4335251,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','225365',4342808,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','225365',4342809,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','225607',4347407,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','225607',4347408,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','225885',4352055,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','225885',4352056,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','225897',4352256,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','225897',4352257,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','226302',4359303,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','226302',4359304,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','226653',4365919,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','226653',4365920,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','226753',4367503,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','226753',4367504,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227226',4375709,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227226',4375710,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227229',4375746,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227229',4375747,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227489',4380567,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227489',4380568,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227510',4380977,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227510',4380978,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227716',4384484,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227716',4384485,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','227991',4389597,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','227991',4389598,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','228178',4393269,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','228178',4393270,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','228485',4399159,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','228485',4399160,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','228593',4400824,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','228593',4400825,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','229017',4408925,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','229017',4408926,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','229064',4410069,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','229064',4410070,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','229257',4413497,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','229257',4413498,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231133',4448091,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231133',4448092,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231138',4448174,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231138',4448175,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231145',4448312,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231145',4448313,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231155',4448519,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231155',4448520,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231157',4448531,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231157',4448532,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231170',4448764,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231170',4448765,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231174',4448841,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231174',4448842,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231250',4449984,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231250',4449985,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231686',4457127,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231686',4457128,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','231823',4459952,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','231823',4459953,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','232245',4467445,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','232245',4467446,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','232249',4467490,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','232249',4467491,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','232611',4473906,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','232611',4473907,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','232679',4475317,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','232679',4475318,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','233235',4485147,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','233235',4485148,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','233236',4485149,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','233236',4485150,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','233510',4490108,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','233510',4490109,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','233696',4493428,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','233696',4493429,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','233944',4498107,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','233944',4498108,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','234391',4506072,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','234391',4506073,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','234685',4511376,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','234685',4511377,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','234686',4511378,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','234686',4511379,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','235153',4519674,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','235153',4519675,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','235213',4520641,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','235213',4520642,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','235868',4532150,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','235868',4532151,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','235882',4532293,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','235882',4532294,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','235886',4532358,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','235886',4532359,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','236348',4540684,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','236348',4540685,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','236354',4540761,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','236354',4540762,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','236650',4545837,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','236650',4545838,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','236880',4549822,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','236880',4549823,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','237249',4556246,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','237249',4556247,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','237483',4560713,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','237483',4560714,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','237693',4564287,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','237693',4564288,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','237980',4568922,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','237980',4568923,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','238017',4569500,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','238017',4569501,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','238187',4572223,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','238187',4572224,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','240885',4618440,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','240885',4618441,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241050',4621318,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241050',4621319,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241099',4622231,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241099',4622232,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241330',4626231,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241330',4626232,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241334',4626300,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241334',4626301,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241344',4626524,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241344',4626525,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241348',4626606,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241348',4626607,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241360',4626784,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241360',4626785,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241573',4630454,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241573',4630455,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241578',4630569,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241578',4630570,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241587',4630698,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241587',4630699,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241589',4630710,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241589',4630711,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241594',4630793,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241594',4630794,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','241826',4634740,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','241826',4634741,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','242014',4637940,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','242014',4637941,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','242273',4642673,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','242273',4642674,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','242284',4642892,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','242284',4642893,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','242790',4651685,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','242790',4651686,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','242791',4651687,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','242791',4651688,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','243225',4659279,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','243225',4659280,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','243227',4659291,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','243227',4659292,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','243666',4666878,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','243666',4666879,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','243923',4671457,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','243923',4671458,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','243927',4671530,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','243927',4671531,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','244417',4680052,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','244417',4680053,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','244419',4680076,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','244419',4680077,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','244887',4688151,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','244887',4688152,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','244893',4688287,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','244893',4688288,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','245143',4692724,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','245143',4692725,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','245534',4699305,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','245534',4699306,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','245543',4699478,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','245543',4699479,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','245767',4703480,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','245767',4703481,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','246092',4708538,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','246092',4708539,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','246561',4716458,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','246561',4716459,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','246772',4720071,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','246772',4720072,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','247033',4724544,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','247033',4724545,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','247042',4724654,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','247042',4724655,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','247305',4729493,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','247305',4729494,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','247525',4733073,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','247525',4733074,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','247808',4737907,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','247808',4737908,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249463',4765920,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249463',4765921,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249468',4766020,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249468',4766021,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249479',4766276,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249479',4766277,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249734',4770429,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249734',4770430,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249739',4770508,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249739',4770509,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249741',4770522,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249741',4770523,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','249748',4770650,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','249748',4770651,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','254556',4853470,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','254556',4853471,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','254562',4853546,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','254562',4853547,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255294',4866453,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255294',4866454,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255354',4867475,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255354',4867476,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255371',4867741,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255371',4867742,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255372',4867743,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255372',4867744,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255378',4867837,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255378',4867838,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255383',4867949,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255383',4867950,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255385',4867971,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255385',4867972,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255415',4868586,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255415',4868587,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255419',4868642,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255419',4868643,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255426',4868729,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255426',4868730,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255432',4868847,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255432',4868848,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255434',4868856,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255434',4868857,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255438',4868900,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255438',4868901,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255441',4868966,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255441',4868967,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255475',4869244,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255475',4869245,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255481',4869323,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255481',4869324,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255485',4869389,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255485',4869390,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255510',4869676,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255510',4869677,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255522',4869846,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255522',4869847,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255529',4870010,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255529',4870011,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255533',4870064,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255533',4870065,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255561',4870518,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255561',4870519,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','255570',4870687,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','255570',4870688,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','256015',4878100,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','256015',4878101,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','256333',4883297,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','256333',4883298,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','256626',4888455,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','256626',4888456,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','256630',4888500,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','256630',4888501,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','256890',4892952,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','256890',4892953,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257262',4899410,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257262',4899411,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257263',4899412,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257263',4899413,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257264',4899414,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257264',4899415,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257265',4899416,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257265',4899417,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257266',4899418,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257266',4899419,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257267',4899420,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257267',4899421,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257268',4899422,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257268',4899423,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257269',4899424,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257269',4899425,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257270',4899426,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257270',4899427,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257271',4899428,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257271',4899429,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257272',4899430,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257272',4899431,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257273',4899432,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257273',4899433,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257274',4899434,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257274',4899435,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257275',4899436,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257275',4899437,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257276',4899438,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257276',4899439,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257277',4899440,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257277',4899441,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257278',4899442,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257278',4899443,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257279',4899444,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257279',4899445,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257280',4899446,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257280',4899447,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257281',4899448,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257281',4899449,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257282',4899450,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257282',4899451,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257283',4899452,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257283',4899453,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257284',4899454,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257284',4899455,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257285',4899456,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257285',4899457,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257286',4899458,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257286',4899459,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257287',4899460,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257287',4899461,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257288',4899462,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257288',4899463,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257289',4899464,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257289',4899465,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257290',4899466,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257290',4899467,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257291',4899468,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257291',4899469,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257292',4899470,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257292',4899471,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257293',4899472,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257293',4899473,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257294',4899474,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257294',4899475,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257295',4899476,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257295',4899477,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257296',4899478,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257296',4899479,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257297',4899480,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257297',4899481,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257298',4899482,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257298',4899483,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257299',4899484,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257299',4899485,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257300',4899486,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257300',4899487,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257301',4899488,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257301',4899489,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257302',4899490,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257302',4899491,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257303',4899492,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257303',4899493,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257304',4899494,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257304',4899495,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257305',4899496,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257305',4899497,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257306',4899498,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257306',4899499,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257307',4899500,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257307',4899501,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257308',4899502,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257308',4899503,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257309',4899504,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257309',4899505,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257310',4899506,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257310',4899507,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257311',4899508,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257311',4899509,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257312',4899510,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257312',4899511,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257313',4899512,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257313',4899513,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257314',4899514,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257314',4899515,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257315',4899516,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257315',4899517,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257316',4899518,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257316',4899519,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257317',4899520,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257317',4899521,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257318',4899522,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257318',4899523,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257319',4899524,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257319',4899525,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257320',4899526,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257320',4899527,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257321',4899528,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257321',4899529,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257322',4899530,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257322',4899531,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257323',4899532,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257323',4899533,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257324',4899534,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257324',4899535,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257325',4899536,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257325',4899537,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257326',4899538,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257326',4899539,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257327',4899540,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257327',4899541,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257328',4899542,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257328',4899543,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257329',4899544,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257329',4899545,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257330',4899546,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257330',4899547,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257331',4899548,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257331',4899549,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257332',4899550,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257332',4899551,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257333',4899552,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257333',4899553,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257334',4899554,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257334',4899555,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257335',4899556,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257335',4899557,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257336',4899558,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257336',4899559,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257337',4899560,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257337',4899561,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257338',4899562,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257338',4899563,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257339',4899564,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257339',4899565,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257340',4899566,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257340',4899567,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257341',4899568,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257341',4899569,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257342',4899570,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257342',4899571,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257343',4899572,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257343',4899573,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257344',4899574,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257344',4899575,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257345',4899576,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257345',4899577,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257346',4899578,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257346',4899579,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257347',4899580,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257347',4899581,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257348',4899582,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257348',4899583,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257349',4899584,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257349',4899585,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257350',4899586,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257350',4899587,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257351',4899588,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257351',4899589,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257352',4899590,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257352',4899591,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257353',4899592,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257353',4899593,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257354',4899594,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257354',4899595,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257355',4899596,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257355',4899597,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257356',4899598,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257356',4899599,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257357',4899600,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257357',4899601,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257358',4899602,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257358',4899603,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257359',4899604,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257359',4899605,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257360',4899606,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257360',4899607,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257361',4899608,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257361',4899609,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257362',4899610,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257362',4899611,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257363',4899612,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257363',4899613,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257364',4899614,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257364',4899615,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257365',4899616,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257365',4899617,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257366',4899618,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257366',4899619,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257367',4899620,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257367',4899621,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257368',4899622,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257368',4899623,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257369',4899624,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257369',4899625,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257370',4899626,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257370',4899627,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257371',4899628,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257371',4899629,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257372',4899630,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257372',4899631,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257373',4899632,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257373',4899633,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257374',4899634,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257374',4899635,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257375',4899636,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257375',4899637,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257376',4899638,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257376',4899639,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257377',4899640,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257377',4899641,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257378',4899642,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257378',4899643,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257379',4899644,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257379',4899645,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257380',4899646,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257380',4899647,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257381',4899648,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257381',4899649,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257382',4899650,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257382',4899651,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257383',4899652,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257383',4899653,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257384',4899654,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257384',4899655,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257385',4899656,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257385',4899657,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257386',4899658,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257386',4899659,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257387',4899660,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257387',4899661,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257388',4899662,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257388',4899663,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257389',4899664,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257389',4899665,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257390',4899666,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257390',4899667,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257391',4899668,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257391',4899669,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257392',4899670,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257392',4899671,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257393',4899672,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257393',4899673,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257394',4899674,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257394',4899675,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257395',4899676,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257395',4899677,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257396',4899678,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257396',4899679,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257397',4899680,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257397',4899681,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257398',4899682,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257398',4899683,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257399',4899684,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257399',4899685,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257400',4899686,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257400',4899687,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257401',4899688,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257401',4899689,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257402',4899690,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257402',4899691,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257403',4899692,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257403',4899693,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257404',4899694,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257404',4899695,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257405',4899696,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257405',4899697,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257406',4899698,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257406',4899699,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257407',4899700,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257407',4899701,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257408',4899702,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257408',4899703,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257409',4899704,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257409',4899705,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257410',4899706,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257410',4899707,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257411',4899708,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257411',4899709,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257412',4899710,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257412',4899711,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257413',4899712,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257413',4899713,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257414',4899714,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257414',4899715,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257415',4899716,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257415',4899717,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257416',4899718,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257416',4899719,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257417',4899720,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257417',4899721,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257418',4899722,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257418',4899723,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257419',4899724,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257419',4899725,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257420',4899726,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257420',4899727,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257421',4899728,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257421',4899729,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257422',4899730,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257422',4899731,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257423',4899732,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257423',4899733,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257424',4899734,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257424',4899735,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257425',4899736,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257425',4899737,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257426',4899738,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257426',4899739,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257427',4899740,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257427',4899741,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257428',4899742,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257428',4899743,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257429',4899744,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257429',4899745,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257430',4899746,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257430',4899747,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257431',4899748,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257431',4899749,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257432',4899750,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257432',4899751,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257433',4899752,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257433',4899753,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257434',4899754,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257434',4899755,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257435',4899756,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257435',4899757,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257436',4899758,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257436',4899759,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257437',4899760,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257437',4899761,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257438',4899762,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257438',4899763,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257439',4899764,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257439',4899765,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257440',4899766,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257440',4899767,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257441',4899768,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257441',4899769,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257442',4899770,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257442',4899771,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257443',4899772,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257443',4899773,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257444',4899774,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257444',4899775,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257445',4899776,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257445',4899777,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257446',4899778,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257446',4899779,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257447',4899780,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257447',4899781,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257448',4899782,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257448',4899783,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257449',4899784,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257449',4899785,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257450',4899786,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257450',4899787,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257451',4899788,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257451',4899789,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257452',4899790,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257452',4899791,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257453',4899792,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257453',4899793,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257454',4899794,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257454',4899795,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257455',4899796,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257455',4899797,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257456',4899798,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257456',4899799,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257457',4899800,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257457',4899801,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257458',4899802,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257458',4899803,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257459',4899804,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257459',4899805,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257460',4899806,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257460',4899807,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257461',4899808,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257461',4899809,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257462',4899810,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257462',4899811,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257463',4899812,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257463',4899813,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257464',4899814,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257464',4899815,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257465',4899816,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257465',4899817,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257466',4899818,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257466',4899819,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257467',4899820,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257467',4899821,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257468',4899822,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257468',4899823,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257469',4899824,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257469',4899825,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257470',4899826,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257470',4899827,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257471',4899828,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257471',4899829,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257472',4899830,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257472',4899831,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257473',4899832,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257473',4899833,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257474',4899834,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257474',4899835,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257475',4899836,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257475',4899837,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257476',4899838,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257476',4899839,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257477',4899840,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257477',4899841,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257478',4899842,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257478',4899843,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257479',4899844,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257479',4899845,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257480',4899846,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257480',4899847,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257481',4899848,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257481',4899849,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257482',4899850,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257482',4899851,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257483',4899852,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257483',4899853,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257484',4899854,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257484',4899855,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257485',4899856,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257485',4899857,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257486',4899858,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257486',4899859,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257487',4899860,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257487',4899861,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257488',4899862,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257488',4899863,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257489',4899864,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257489',4899865,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257490',4899866,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257490',4899867,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257491',4899868,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257491',4899869,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257492',4899870,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257492',4899871,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257493',4899872,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257493',4899873,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257494',4899874,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257494',4899875,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257495',4899876,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257495',4899877,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257496',4899878,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257496',4899879,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257497',4899880,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257497',4899881,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257498',4899882,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257498',4899883,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257499',4899884,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257499',4899885,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257500',4899886,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257500',4899887,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257501',4899888,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257501',4899889,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257502',4899890,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257502',4899891,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257503',4899892,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257503',4899893,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257504',4899894,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257504',4899895,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257505',4899896,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257505',4899897,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257506',4899898,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257506',4899899,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257507',4899900,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257507',4899901,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257508',4899902,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257508',4899903,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257509',4899904,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257509',4899905,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257510',4899906,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257510',4899907,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257511',4899908,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257511',4899909,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257512',4899910,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257512',4899911,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257513',4899912,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257513',4899913,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257514',4899914,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257514',4899915,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257515',4899916,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257515',4899917,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257516',4899918,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257516',4899919,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257517',4899920,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257517',4899921,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257518',4899922,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257518',4899923,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257519',4899924,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257519',4899925,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257520',4899926,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257520',4899927,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257521',4899928,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257521',4899929,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257522',4899930,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257522',4899931,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257523',4899932,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257523',4899933,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257524',4899934,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257524',4899935,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257525',4899936,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257525',4899937,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257526',4899938,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257526',4899939,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257527',4899940,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257527',4899941,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257528',4899942,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257528',4899943,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257529',4899944,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257529',4899945,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257530',4899946,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257530',4899947,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257531',4899948,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257531',4899949,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257532',4899950,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257532',4899951,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257533',4899952,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257533',4899953,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257534',4899954,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257534',4899955,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257535',4899956,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257535',4899957,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257536',4899958,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257536',4899959,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257537',4899960,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257537',4899961,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257538',4899962,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257538',4899963,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257539',4899964,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257539',4899965,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257540',4899966,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257540',4899967,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257541',4899968,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257541',4899969,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257542',4899970,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257542',4899971,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257543',4899972,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257543',4899973,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257544',4899974,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257544',4899975,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257545',4899976,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257545',4899977,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257546',4899978,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257546',4899979,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257547',4899980,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257547',4899981,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257548',4899982,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257548',4899983,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257549',4899984,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257549',4899985,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257550',4899986,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257550',4899987,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257551',4899988,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257551',4899989,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257552',4899990,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257552',4899991,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257553',4899992,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257553',4899993,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257554',4899994,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257554',4899995,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257555',4899996,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257555',4899997,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257556',4899998,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257556',4899999,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257557',4900000,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257557',4900001,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257558',4900002,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257558',4900003,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257559',4900004,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257559',4900005,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257560',4900006,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257560',4900007,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257561',4900008,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257561',4900009,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257562',4900010,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257562',4900011,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257563',4900012,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257563',4900013,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257564',4900014,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257564',4900015,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257565',4900016,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257565',4900017,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257566',4900018,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257566',4900019,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257567',4900020,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257567',4900021,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257568',4900022,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257568',4900023,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257569',4900024,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257569',4900025,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257570',4900026,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257570',4900027,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257571',4900028,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257571',4900029,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257572',4900030,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257572',4900031,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257573',4900032,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257573',4900033,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257574',4900034,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257574',4900035,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257575',4900036,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257575',4900037,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257576',4900038,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257576',4900039,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257577',4900040,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257577',4900041,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257578',4900042,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257578',4900043,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257579',4900044,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257579',4900045,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257580',4900046,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257580',4900047,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257581',4900048,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257581',4900049,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257582',4900050,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257582',4900051,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257583',4900052,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257583',4900053,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257584',4900054,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257584',4900055,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257585',4900056,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257585',4900057,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257586',4900058,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257586',4900059,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257587',4900060,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257587',4900061,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257588',4900062,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257588',4900063,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257589',4900064,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257589',4900065,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257590',4900066,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257590',4900067,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257591',4900068,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257591',4900069,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257592',4900070,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257592',4900071,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257593',4900072,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257593',4900073,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257594',4900074,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257594',4900075,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257595',4900076,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257595',4900077,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257596',4900078,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257596',4900079,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257597',4900080,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257597',4900081,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257598',4900082,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257598',4900083,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257599',4900084,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257599',4900085,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257600',4900086,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257600',4900087,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257601',4900088,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257601',4900089,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257602',4900090,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257602',4900091,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257603',4900092,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257603',4900093,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257604',4900094,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257604',4900095,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257605',4900096,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257605',4900097,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257606',4900098,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257606',4900099,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257607',4900100,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257607',4900101,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257608',4900102,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257608',4900103,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257609',4900104,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257609',4900105,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257610',4900106,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257610',4900107,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257611',4900108,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257611',4900109,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257612',4900110,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257612',4900111,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257613',4900112,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257613',4900113,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257614',4900114,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257614',4900115,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257615',4900116,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257615',4900117,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257616',4900118,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257616',4900119,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257617',4900120,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257617',4900121,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257618',4900122,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257618',4900123,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257619',4900124,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257619',4900125,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257620',4900126,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257620',4900127,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257621',4900128,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257621',4900129,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257622',4900130,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257622',4900131,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257623',4900132,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257623',4900133,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257624',4900134,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257624',4900135,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257625',4900136,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257625',4900137,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257626',4900138,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257626',4900139,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257627',4900140,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257627',4900141,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257628',4900142,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257628',4900143,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257629',4900144,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257629',4900145,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257630',4900146,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257630',4900147,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257631',4900148,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257631',4900149,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257632',4900150,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257632',4900151,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257633',4900152,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257633',4900153,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257634',4900154,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257634',4900155,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257635',4900156,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257635',4900157,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257636',4900158,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257636',4900159,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257637',4900160,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257637',4900161,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257638',4900162,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257638',4900163,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257639',4900164,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257639',4900165,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257640',4900166,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257640',4900167,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257641',4900168,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257641',4900169,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257642',4900170,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257642',4900171,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257643',4900172,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257643',4900173,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257644',4900174,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257644',4900175,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257645',4900176,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257645',4900177,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257646',4900178,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257646',4900179,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257647',4900180,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257647',4900181,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257648',4900182,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257648',4900183,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257649',4900184,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257649',4900185,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257650',4900186,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257650',4900187,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257651',4900188,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257651',4900189,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257652',4900190,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257652',4900191,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257653',4900192,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257653',4900193,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257654',4900194,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257654',4900195,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257655',4900196,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257655',4900197,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257656',4900198,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257656',4900199,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257657',4900200,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257657',4900201,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257658',4900202,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257658',4900203,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257659',4900204,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257659',4900205,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257660',4900206,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257660',4900207,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257661',4900208,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257661',4900209,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257662',4900210,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257662',4900211,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257663',4900212,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257663',4900213,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257664',4900214,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257664',4900215,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257665',4900216,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257665',4900217,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257666',4900218,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257666',4900219,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257667',4900220,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257667',4900221,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257668',4900222,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257668',4900223,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257669',4900224,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257669',4900225,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257670',4900226,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257670',4900227,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257671',4900228,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257671',4900229,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257672',4900230,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257672',4900231,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257673',4900232,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257673',4900233,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257674',4900234,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257674',4900235,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257675',4900236,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257675',4900237,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257676',4900238,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257676',4900239,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257677',4900240,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257677',4900241,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257678',4900242,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257678',4900243,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257679',4900244,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257679',4900245,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257680',4900246,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257680',4900247,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','780','257681',4900248,'2189','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','158','781','257681',4900249,'2190','335',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=729434 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','158','147201','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,441961),('1','158','147214','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,441986),('1','158','147217','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,441991),('1','158','147221','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,441999),('1','158','147226','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,442010),('1','158','147232','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,442022),('1','158','147234','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,442026),('1','158','147245','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,442053),('1','158','147273','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,442123),('1','158','147284','335',217.00,0.00,0.00,0.00,0.00,0.00,0.00,442151),('1','158','147287','335',217.00,216.00,0.00,0.00,0.00,0.00,0.00,442154),('1','158','147289','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,442158),('1','158','147969','335',202.00,0.00,0.00,0.00,0.00,0.00,0.00,443994),('1','158','148040','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,444175),('1','158','148927','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,446494),('1','158','148935','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,446516),('1','158','148941','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,446528),('1','158','148977','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,446609),('1','158','148980','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,446615),('1','158','150174','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449810),('1','158','150180','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449826),('1','158','150187','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449845),('1','158','150190','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449852),('1','158','150194','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449860),('1','158','150197','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449867),('1','158','150203','335',202.00,217.00,0.00,0.00,0.00,0.00,0.00,449883),('1','158','150214','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,449913),('1','158','150215','335',217.00,217.00,0.00,0.00,0.00,0.00,0.00,449914),('1','158','150218','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449921),('1','158','150220','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449925),('1','158','150225','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449936),('1','158','150237','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449970),('1','158','150246','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449995),('1','158','150247','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,449996),('1','158','150250','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,450003),('1','158','150253','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,450010),('1','158','150278','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,450075),('1','158','150283','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,450086),('1','158','150285','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,450090),('1','158','150288','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,450096),('1','158','150334','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,450218),('1','158','150733','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,451272),('1','158','150738','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,451285),('1','158','150754','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,451331),('1','158','150761','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,451350),('1','158','150788','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,451427),('1','158','151084','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,452211),('1','158','151088','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,452221),('1','158','151474','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,453265),('1','158','151477','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,453272),('1','158','151478','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,453273),('1','158','151791','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,454130),('1','158','151793','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,454134),('1','158','152387','335',220.00,0.00,0.00,0.00,0.00,0.00,0.00,455707),('1','158','152409','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,455768),('1','158','153028','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,457450),('1','158','153044','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,457486),('1','158','153048','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,457494),('1','158','153054','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,457510),('1','158','153057','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,457517),('1','158','153161','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,457800),('1','158','153165','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,457810),('1','158','153330','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,458273),('1','158','153753','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,459408),('1','158','154544','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,461527),('1','158','154547','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,461534),('1','158','154552','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,461547),('1','158','154554','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,461551),('1','158','154555','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,461552),('1','158','155188','335',205.00,220.00,0.00,0.00,0.00,0.00,0.00,463268),('1','158','155207','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,463323),('1','158','155211','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,463333),('1','158','155866','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,465092),('1','158','155868','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,465096),('1','158','155873','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,465107),('1','158','156015','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,465479),('1','158','156018','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,465486),('1','158','156032','335',220.00,0.00,0.00,0.00,0.00,0.00,0.00,465526),('1','158','156066','335',220.00,0.00,0.00,0.00,0.00,0.00,0.00,465620),('1','158','156068','335',220.00,0.00,0.00,0.00,0.00,0.00,0.00,465624),('1','158','156069','335',220.00,0.00,0.00,0.00,0.00,0.00,0.00,465625),('1','158','156284','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,466187),('1','158','156351','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,466364),('1','158','156521','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,466822),('1','158','157397','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,469140),('1','158','157839','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470297),('1','158','157842','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470304),('1','158','157844','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470308),('1','158','157978','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470674),('1','158','158044','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470853),('1','158','158046','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,470857),('1','158','158478','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,471992),('1','158','158481','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,471998),('1','158','158482','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,471999),('1','158','158688','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,472552),('1','158','158848','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,472942),('1','158','159061','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,473530),('1','158','159135','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,473712),('1','158','159143','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,473731),('1','158','159356','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,474289),('1','158','159644','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,475032),('1','158','159645','335',205.00,0.00,0.00,0.00,0.00,0.00,0.00,475033),('1','158','159832','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,475521),('1','158','159957','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,475828),('1','158','160029','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,476020),('1','158','160173','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,476389),('1','158','160391','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,476971),('1','158','160667','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,477683),('1','158','161033','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,478636),('1','158','161036','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,478642),('1','158','161042','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,478658),('1','158','161043','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,478659),('1','158','161170','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,478983),('1','158','161312','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,479323),('1','158','161701','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,480315),('1','158','161752','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,480457),('1','158','162267','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,481792),('1','158','162269','335',215.00,0.00,0.00,0.00,0.00,0.00,0.00,481796),('1','158','162345','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,481995),('1','158','162561','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,482528),('1','158','163041','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,483783),('1','158','163043','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,483787),('1','158','163100','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,483939),('1','158','163311','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,484481),('1','158','163387','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,484670),('1','158','163716','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,485553),('1','158','163917','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,486052),('1','158','163919','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,486056),('1','158','164372','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,487268),('1','158','164939','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,488778),('1','158','164943','335',222.00,0.00,0.00,0.00,0.00,0.00,0.00,488788),('1','158','165211','335',235.00,0.00,0.00,0.00,0.00,0.00,0.00,489474),('1','158','165214','335',235.00,0.00,0.00,0.00,0.00,0.00,0.00,489480),('1','158','165217','335',235.00,0.00,0.00,0.00,0.00,0.00,0.00,489487),('1','158','165877','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,491236),('1','158','165881','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,491246),('1','158','165898','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,491291),('1','158','165901','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,491296),('1','158','167101','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,494509),('1','158','167110','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,494533),('1','158','167112','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,494537),('1','158','167120','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,494559),('1','158','168500','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498221),('1','158','168515','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498262),('1','158','168517','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498266),('1','158','168520','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498272),('1','158','168533','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498309),('1','158','168539','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498322),('1','158','168544','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498335),('1','158','168561','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498380),('1','158','168733','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,498844),('1','158','168986','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,499500),('1','158','169155','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,499920),('1','158','169159','335',237.00,0.00,0.00,0.00,0.00,0.00,0.00,499930),('1','158','170093','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502386),('1','158','170097','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502394),('1','158','170099','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502398),('1','158','170105','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502412),('1','158','170107','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502416),('1','158','170220','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,502707),('1','158','170517','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,503483),('1','158','170579','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,503651),('1','158','170790','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,504207),('1','158','171527','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,506179),('1','158','171532','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,506192),('1','158','171534','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,506196),('1','158','171535','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,506197),('1','158','171739','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,506742),('1','158','172553','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,508885),('1','158','172558','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,508898),('1','158','172559','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,508899),('1','158','172567','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,508921),('1','158','173588','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,511632),('1','158','173590','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,511636),('1','158','173592','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,511638),('1','158','173594','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,511641),('1','158','174034','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,512805),('1','158','174038','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,512813),('1','158','174708','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,514549),('1','158','174713','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,514562),('1','158','174741','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,514639),('1','158','174745','335',261.00,0.00,0.00,0.00,0.00,0.00,0.00,514649),('1','158','175590','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,516871),('1','158','175630','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,516972),('1','158','175632','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,516976),('1','158','175635','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,516981),('1','158','175655','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,517039),('1','158','176002','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,517938),('1','158','176270','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,518647),('1','158','176273','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,518654),('1','158','176643','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,519606),('1','158','176657','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,519643),('1','158','176862','335',293.00,0.00,0.00,0.00,0.00,0.00,0.00,520192),('1','158','177212','335',293.00,0.00,0.00,0.00,0.00,0.00,0.00,521113),('1','158','177836','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,522789),('1','158','177838','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,522793),('1','158','177844','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,522807),('1','158','178370','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,524175),('1','158','178380','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,524202),('1','158','178968','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,525731),('1','158','178977','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,525754),('1','158','179321','335',290.00,0.00,0.00,0.00,0.00,0.00,0.00,526687),('1','158','179327','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,526701),('1','158','179330','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,526705),('1','158','179495','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,527145),('1','158','179949','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,528351),('1','158','179952','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,528358),('1','158','180269','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,529169),('1','158','180275','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,529184),('1','158','180831','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,530650),('1','158','180834','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,530657),('1','158','180835','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,530658),('1','158','180839','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,530668),('1','158','181623','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,532743),('1','158','181630','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,532762),('1','158','181633','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,532769),('1','158','181640','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,532788),('1','158','184998','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,541690),('1','158','185035','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,541787),('1','158','185037','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,541791),('1','158','185058','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,541848),('1','158','185064','335',308.00,0.00,0.00,0.00,0.00,0.00,0.00,541861),('1','158','185158','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,542096),('1','158','185159','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,542097),('1','158','185160','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,542098),('1','158','185181','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,542153),('1','158','185202','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542210),('1','158','185207','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542221),('1','158','185208','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,542222),('1','158','185214','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,542238),('1','158','185217','335',288.00,0.00,0.00,0.00,0.00,0.00,0.00,542245),('1','158','185218','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542246),('1','158','185314','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542477),('1','158','185316','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542480),('1','158','185317','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,542481),('1','158','185828','335',313.00,0.00,0.00,0.00,0.00,0.00,0.00,543859),('1','158','185831','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,543865),('1','158','185931','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,544125),('1','158','186150','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,544701),('1','158','186155','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,544712),('1','158','186417','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,545407),('1','158','186628','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,545968),('1','158','186906','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,546670),('1','158','187210','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,547455),('1','158','187215','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,547467),('1','158','187969','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,549469),('1','158','187972','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,549475),('1','158','187975','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,549482),('1','158','188119','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,549848),('1','158','188636','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,551170),('1','158','188644','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,551192),('1','158','189329','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,553013),('1','158','189491','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,553426),('1','158','189500','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,553449),('1','158','189501','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,553450),('1','158','189506','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,553463),('1','158','189769','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,554145),('1','158','190094','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,554987),('1','158','190097','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,554994),('1','158','190781','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,556804),('1','158','190791','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,556829),('1','158','191437','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,558536),('1','158','191450','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,558569),('1','158','191456','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,558583),('1','158','191795','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,559474),('1','158','191843','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,559610),('1','158','192049','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,560155),('1','158','192450','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,561200),('1','158','192455','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,561209),('1','158','192795','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,562086),('1','158','192799','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,562096),('1','158','193029','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,562708),('1','158','193030','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,562709),('1','158','193035','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,562722),('1','158','193499','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,563957),('1','158','193503','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,563966),('1','158','193776','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,564661),('1','158','194356','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,566126),('1','158','194358','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,566130),('1','158','194558','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,566637),('1','158','194559','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,566638),('1','158','195187','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,568287),('1','158','195645','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,569434),('1','158','195648','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,569438),('1','158','195654','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,569454),('1','158','195657','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,569459),('1','158','198057','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575608),('1','158','198059','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575612),('1','158','198060','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575613),('1','158','198065','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575626),('1','158','198190','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575938),('1','158','198199','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575957),('1','158','198202','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575962),('1','158','198211','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575983),('1','158','198218','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,575999),('1','158','198221','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,576004),('1','158','199470','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,579173),('1','158','199472','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,579177),('1','158','199476','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,579187),('1','158','199483','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,579204),('1','158','199764','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,579895),('1','158','200181','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,580984),('1','158','200185','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,580992),('1','158','201027','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,583163),('1','158','201029','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,583167),('1','158','201031','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,583172),('1','158','201698','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,584927),('1','158','201700','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,584931),('1','158','201704','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,584939),('1','158','201708','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,584949),('1','158','201958','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,585609),('1','158','201963','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,585621),('1','158','202085','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,585925),('1','158','202323','335',309.00,0.00,0.00,0.00,0.00,0.00,0.00,586540),('1','158','202566','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,587158),('1','158','202743','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,587607),('1','158','203002','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,588275),('1','158','203353','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,589201),('1','158','203465','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,589496),('1','158','203821','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,590402),('1','158','204065','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,591033),('1','158','204068','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,591040),('1','158','205452','335',307.00,0.00,0.00,0.00,0.00,0.00,0.00,594583),('1','158','205456','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,594593),('1','158','205457','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,594594),('1','158','205550','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,594824),('1','158','205557','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,594840),('1','158','205564','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,594858),('1','158','205829','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,595545),('1','158','205980','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,595938),('1','158','206303','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,596772),('1','158','206305','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,596776),('1','158','206308','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,596782),('1','158','206619','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,597560),('1','158','206900','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,598298),('1','158','207178','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,599023),('1','158','207184','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,599039),('1','158','207605','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,600118),('1','158','207607','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,600122),('1','158','207966','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,601037),('1','158','207974','335',312.00,0.00,0.00,0.00,0.00,0.00,0.00,601056),('1','158','208175','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,601566),('1','158','208453','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,602284),('1','158','208891','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,603396),('1','158','208894','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,603402),('1','158','209341','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,604543),('1','158','209348','335',324.00,0.00,0.00,0.00,0.00,0.00,0.00,604562),('1','158','209953','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,606131),('1','158','209969','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,606169),('1','158','210172','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,606694),('1','158','210202','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,606762),('1','158','210837','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,608431),('1','158','210840','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,608434),('1','158','210843','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,608440),('1','158','211538','335',350.00,0.00,0.00,0.00,0.00,0.00,0.00,610250),('1','158','211546','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,610272),('1','158','211832','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,610989),('1','158','211837','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,611002),('1','158','211841','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,611012),('1','158','212317','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,612263),('1','158','213231','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,614658),('1','158','213236','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,614671),('1','158','213240','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,614681),('1','158','213251','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,614707),('1','158','213334','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,614926),('1','158','213992','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,616652),('1','158','213997','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,616662),('1','158','214002','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,616674),('1','158','214661','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,618378),('1','158','214683','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,618439),('1','158','215539','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,620656),('1','158','215554','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,620690),('1','158','215557','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,620695),('1','158','215562','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,620705),('1','158','215574','335',366.00,376.00,0.00,0.00,0.00,0.00,0.00,620736),('1','158','215977','335',366.00,0.00,0.00,0.00,0.00,0.00,0.00,621783),('1','158','216644','335',396.00,0.00,0.00,0.00,0.00,0.00,0.00,623532),('1','158','216645','335',396.00,0.00,0.00,0.00,0.00,0.00,0.00,623533),('1','158','216652','335',396.00,0.00,0.00,0.00,0.00,0.00,0.00,623551),('1','158','216664','335',396.00,0.00,0.00,0.00,0.00,0.00,0.00,623584),('1','158','216792','335',396.00,0.00,0.00,0.00,0.00,0.00,0.00,623920),('1','158','217369','335',421.00,431.00,0.00,0.00,0.00,0.00,0.00,625430),('1','158','217865','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,626732),('1','158','217877','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,626766),('1','158','217884','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,626782),('1','158','218100','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,627340),('1','158','218374','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,628074),('1','158','218722','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,628962),('1','158','218968','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,629613),('1','158','219005','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,629708),('1','158','219292','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,630476),('1','158','221006','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,634965),('1','158','221011','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,634978),('1','158','221015','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,634986),('1','158','221021','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,635000),('1','158','221024','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,635007),('1','158','221032','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,635027),('1','158','221033','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,635028),('1','158','221256','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,635613),('1','158','221524','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,636315),('1','158','221529','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,636328),('1','158','221881','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,637231),('1','158','221888','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,637250),('1','158','222169','335',421.00,0.00,0.00,0.00,0.00,0.00,0.00,637983),('1','158','222446','335',426.00,0.00,0.00,0.00,0.00,0.00,0.00,638705),('1','158','223259','335',426.00,0.00,0.00,0.00,0.00,0.00,0.00,640810),('1','158','223263','335',426.00,0.00,0.00,0.00,0.00,0.00,0.00,640815),('1','158','223269','335',426.00,0.00,0.00,0.00,0.00,0.00,0.00,640827),('1','158','223428','335',426.00,0.00,0.00,0.00,0.00,0.00,0.00,641229),('1','158','223789','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,642165),('1','158','223791','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,642169),('1','158','224013','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,642746),('1','158','224159','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,643112),('1','158','224909','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,645066),('1','158','224941','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,645152),('1','158','224947','335',459.00,0.00,0.00,0.00,0.00,0.00,0.00,645168),('1','158','225365','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,646233),('1','158','225607','335',449.00,0.00,0.00,0.00,0.00,0.00,0.00,646870),('1','158','225885','335',451.00,0.00,0.00,0.00,0.00,0.00,0.00,647605),('1','158','225897','335',465.00,0.00,0.00,0.00,0.00,0.00,0.00,647637),('1','158','226302','335',465.00,0.00,0.00,0.00,0.00,0.00,0.00,648670),('1','158','226653','335',465.00,0.00,0.00,0.00,0.00,0.00,0.00,649584),('1','158','226753','335',465.00,0.00,0.00,0.00,0.00,0.00,0.00,649822),('1','158','227226','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,651055),('1','158','227229','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,651063),('1','158','227489','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,651739),('1','158','227510','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,651793),('1','158','227716','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,652321),('1','158','227991','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,653046),('1','158','228178','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,653536),('1','158','228485','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,654337),('1','158','228593','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,654592),('1','158','229017','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,655681),('1','158','229064','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,655811),('1','158','229257','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,656312),('1','158','231133','335',476.00,0.00,0.00,0.00,0.00,0.00,0.00,661173),('1','158','231138','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661185),('1','158','231145','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661203),('1','158','231155','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661230),('1','158','231157','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661234),('1','158','231170','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661271),('1','158','231174','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661280),('1','158','231250','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,661499),('1','158','231686','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,662632),('1','158','231823','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,663028),('1','158','232245','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,664138),('1','158','232249','335',516.00,0.00,0.00,0.00,0.00,0.00,0.00,664146),('1','158','232611','335',536.00,0.00,0.00,0.00,0.00,0.00,0.00,665086),('1','158','232679','335',536.00,0.00,0.00,0.00,0.00,0.00,0.00,665273),('1','158','233235','335',536.00,0.00,0.00,0.00,0.00,0.00,0.00,666739),('1','158','233236','335',536.00,0.00,0.00,0.00,0.00,0.00,0.00,666740),('1','158','233510','335',536.00,0.00,0.00,0.00,0.00,0.00,0.00,667460),('1','158','233696','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,667935),('1','158','233944','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,668596),('1','158','234391','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,669775),('1','158','234685','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,670559),('1','158','234686','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,670560),('1','158','235153','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,671805),('1','158','235213','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,671964),('1','158','235868','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,673651),('1','158','235882','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,673692),('1','158','235886','335',560.00,0.00,0.00,0.00,0.00,0.00,0.00,673703),('1','158','236348','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,674927),('1','158','236354','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,674943),('1','158','236650','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,675720),('1','158','236880','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,676313),('1','158','237249','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,677250),('1','158','237483','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,677863),('1','158','237693','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,678403),('1','158','237980','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,679150),('1','158','238017','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,679250),('1','158','238187','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,679681),('1','158','240885','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,686679),('1','158','241050','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687104),('1','158','241099','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687237),('1','158','241330','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687842),('1','158','241334','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687852),('1','158','241344','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687880),('1','158','241348','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687889),('1','158','241360','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,687919),('1','158','241573','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,688490),('1','158','241578','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,688503),('1','158','241587','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,688524),('1','158','241589','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,688528),('1','158','241594','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,688541),('1','158','241826','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,689151),('1','158','242014','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,689639),('1','158','242273','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,690309),('1','158','242284','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,690339),('1','158','242790','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,691656),('1','158','242791','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,691657),('1','158','243225','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,692790),('1','158','243227','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,692794),('1','158','243666','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,693930),('1','158','243923','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,694599),('1','158','243927','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,694607),('1','158','244417','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,695895),('1','158','244419','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,695899),('1','158','244887','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,697122),('1','158','244893','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,697137),('1','158','245143','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,697779),('1','158','245534','335',562.00,0.00,0.00,0.00,0.00,0.00,0.00,698774),('1','158','245543','335',562.00,0.00,0.00,0.00,0.00,0.00,0.00,698799),('1','158','245767','335',562.00,0.00,0.00,0.00,0.00,0.00,0.00,699373),('1','158','246092','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,700234),('1','158','246561','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,701458),('1','158','246772','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,701997),('1','158','247033','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,702667),('1','158','247042','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,702692),('1','158','247305','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,703380),('1','158','247525','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,703944),('1','158','247808','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,704676),('1','158','249463','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,708933),('1','158','249468','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,708944),('1','158','249479','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,708974),('1','158','249734','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,709637),('1','158','249739','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,709649),('1','158','249741','335',548.00,0.00,0.00,0.00,0.00,0.00,0.00,709653),('1','158','249748','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,709671),('1','158','254556','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,722114),('1','158','254562','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,722125),('1','158','255294','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724000),('1','158','255354','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724165),('1','158','255371','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724208),('1','158','255372','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724209),('1','158','255378','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724220),('1','158','255383','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724232),('1','158','255385','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724235),('1','158','255415','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724315),('1','158','255419','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724325),('1','158','255426','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724345),('1','158','255432','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724359),('1','158','255434','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724364),('1','158','255438','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724374),('1','158','255441','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724381),('1','158','255475','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724447),('1','158','255481','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724458),('1','158','255485','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724466),('1','158','255510','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724520),('1','158','255522','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724549),('1','158','255529','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724567),('1','158','255533','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724576),('1','158','255561','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724639),('1','158','255570','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,724660),('1','158','256015','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,725800),('1','158','256333','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,726594),('1','158','256626','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,727367),('1','158','256630','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,727377),('1','158','256890','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,728059),('1','158','257262','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,729014),('1','158','257263','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,729015),('1','158','257264','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,729016),('1','158','257265','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,729017),('1','158','257266','335',500.00,0.00,0.00,0.00,0.00,0.00,0.00,729018),('1','158','257267','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729019),('1','158','257268','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729020),('1','158','257269','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729021),('1','158','257270','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729022),('1','158','257271','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729023),('1','158','257272','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729024),('1','158','257273','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729025),('1','158','257274','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729026),('1','158','257275','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729027),('1','158','257276','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729028),('1','158','257277','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729029),('1','158','257278','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729030),('1','158','257279','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729031),('1','158','257280','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729032),('1','158','257281','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729033),('1','158','257282','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729034),('1','158','257283','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729035),('1','158','257284','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729036),('1','158','257285','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729037),('1','158','257286','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729038),('1','158','257287','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729039),('1','158','257288','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729040),('1','158','257289','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729041),('1','158','257290','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729042),('1','158','257291','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729043),('1','158','257292','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729044),('1','158','257293','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729045),('1','158','257294','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729046),('1','158','257295','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729047),('1','158','257296','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729048),('1','158','257297','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729049),('1','158','257298','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729050),('1','158','257299','335',490.00,0.00,0.00,0.00,0.00,0.00,0.00,729051),('1','158','257300','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729052),('1','158','257301','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729053),('1','158','257302','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729054),('1','158','257303','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729055),('1','158','257304','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729056),('1','158','257305','335',522.00,0.00,0.00,0.00,0.00,0.00,0.00,729057),('1','158','257306','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729058),('1','158','257307','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729059),('1','158','257308','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729060),('1','158','257309','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729061),('1','158','257310','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729062),('1','158','257311','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729063),('1','158','257312','335',572.00,0.00,0.00,0.00,0.00,0.00,0.00,729064),('1','158','257313','335',569.00,0.00,0.00,0.00,0.00,0.00,0.00,729065),('1','158','257314','335',569.00,0.00,0.00,0.00,0.00,0.00,0.00,729066),('1','158','257315','335',569.00,0.00,0.00,0.00,0.00,0.00,0.00,729067),('1','158','257316','335',569.00,0.00,0.00,0.00,0.00,0.00,0.00,729068),('1','158','257317','335',596.00,0.00,0.00,0.00,0.00,0.00,0.00,729069),('1','158','257318','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729070),('1','158','257319','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729071),('1','158','257320','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729072),('1','158','257321','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729073),('1','158','257322','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729074),('1','158','257323','335',588.00,0.00,0.00,0.00,0.00,0.00,0.00,729075),('1','158','257324','335',607.00,0.00,0.00,0.00,0.00,0.00,0.00,729076),('1','158','257325','335',607.00,0.00,0.00,0.00,0.00,0.00,0.00,729077),('1','158','257326','335',607.00,0.00,0.00,0.00,0.00,0.00,0.00,729078),('1','158','257327','335',607.00,0.00,0.00,0.00,0.00,0.00,0.00,729079),('1','158','257328','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729080),('1','158','257329','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729081),('1','158','257330','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729082),('1','158','257331','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729083),('1','158','257332','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729084),('1','158','257333','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729085),('1','158','257334','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729086),('1','158','257335','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729087),('1','158','257336','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729088),('1','158','257337','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729089),('1','158','257338','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729090),('1','158','257339','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729091),('1','158','257340','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729092),('1','158','257341','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729093),('1','158','257342','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729094),('1','158','257343','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729095),('1','158','257344','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729096),('1','158','257345','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729097),('1','158','257346','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729098),('1','158','257347','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729099),('1','158','257348','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729100),('1','158','257349','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729101),('1','158','257350','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729102),('1','158','257351','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729103),('1','158','257352','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729104),('1','158','257353','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729105),('1','158','257354','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729106),('1','158','257355','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729107),('1','158','257356','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729108),('1','158','257357','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729109),('1','158','257358','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729110),('1','158','257359','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729111),('1','158','257360','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729112),('1','158','257361','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729113),('1','158','257362','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729114),('1','158','257363','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729115),('1','158','257364','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729116),('1','158','257365','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729117),('1','158','257366','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729118),('1','158','257367','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729119),('1','158','257368','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729120),('1','158','257369','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729121),('1','158','257370','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729122),('1','158','257371','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729123),('1','158','257372','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729124),('1','158','257373','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729125),('1','158','257374','335',582.00,0.00,0.00,0.00,0.00,0.00,0.00,729126),('1','158','257375','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729127),('1','158','257376','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729128),('1','158','257377','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729129),('1','158','257378','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729130),('1','158','257379','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729131),('1','158','257380','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729132),('1','158','257381','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729133),('1','158','257382','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729134),('1','158','257383','335',592.00,0.00,0.00,0.00,0.00,0.00,0.00,729135),('1','158','257384','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729136),('1','158','257385','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729137),('1','158','257386','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729138),('1','158','257387','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729139),('1','158','257388','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729140),('1','158','257389','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729141),('1','158','257390','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729142),('1','158','257391','335',652.00,0.00,0.00,0.00,0.00,0.00,0.00,729143),('1','158','257392','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729144),('1','158','257393','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729145),('1','158','257394','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729146),('1','158','257395','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729147),('1','158','257396','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729148),('1','158','257397','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729149),('1','158','257398','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729150),('1','158','257399','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729151),('1','158','257400','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729152),('1','158','257401','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729153),('1','158','257402','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729154),('1','158','257403','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729155),('1','158','257404','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729156),('1','158','257405','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729157),('1','158','257406','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729158),('1','158','257407','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729159),('1','158','257408','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729160),('1','158','257409','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729161),('1','158','257410','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729162),('1','158','257411','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729163),('1','158','257412','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729164),('1','158','257413','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729165),('1','158','257414','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729166),('1','158','257415','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729167),('1','158','257416','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729168),('1','158','257417','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729169),('1','158','257418','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729170),('1','158','257419','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729171),('1','158','257420','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729172),('1','158','257421','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729173),('1','158','257422','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729174),('1','158','257423','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729175),('1','158','257424','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729176),('1','158','257425','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729177),('1','158','257426','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729178),('1','158','257427','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729179),('1','158','257428','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729180),('1','158','257429','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729181),('1','158','257430','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729182),('1','158','257431','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729183),('1','158','257432','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729184),('1','158','257433','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729185),('1','158','257434','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729186),('1','158','257435','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729187),('1','158','257436','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729188),('1','158','257437','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729189),('1','158','257438','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729190),('1','158','257439','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729191),('1','158','257440','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729192),('1','158','257441','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729193),('1','158','257442','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729194),('1','158','257443','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729195),('1','158','257444','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729196),('1','158','257445','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729197),('1','158','257446','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729198),('1','158','257447','335',672.00,0.00,0.00,0.00,0.00,0.00,0.00,729199),('1','158','257448','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729200),('1','158','257449','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729201),('1','158','257450','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729202),('1','158','257451','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729203),('1','158','257452','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729204),('1','158','257453','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729205),('1','158','257454','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729206),('1','158','257455','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729207),('1','158','257456','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729208),('1','158','257457','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729209),('1','158','257458','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729210),('1','158','257459','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729211),('1','158','257460','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729212),('1','158','257461','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729213),('1','158','257462','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729214),('1','158','257463','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729215),('1','158','257464','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729216),('1','158','257465','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729217),('1','158','257466','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729218),('1','158','257467','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729219),('1','158','257468','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729220),('1','158','257469','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729221),('1','158','257470','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729222),('1','158','257471','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729223),('1','158','257472','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729224),('1','158','257473','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729225),('1','158','257474','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729226),('1','158','257475','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729227),('1','158','257476','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729228),('1','158','257477','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729229),('1','158','257478','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729230),('1','158','257479','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729231),('1','158','257480','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729232),('1','158','257481','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729233),('1','158','257482','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729234),('1','158','257483','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729235),('1','158','257484','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729236),('1','158','257485','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729237),('1','158','257486','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729238),('1','158','257487','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729239),('1','158','257488','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729240),('1','158','257489','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729241),('1','158','257490','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729242),('1','158','257491','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729243),('1','158','257492','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729244),('1','158','257493','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729245),('1','158','257494','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729246),('1','158','257495','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729247),('1','158','257496','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729248),('1','158','257497','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729249),('1','158','257498','335',665.00,0.00,0.00,0.00,0.00,0.00,0.00,729250),('1','158','257499','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729251),('1','158','257500','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729252),('1','158','257501','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729253),('1','158','257502','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729254),('1','158','257503','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729255),('1','158','257504','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729256),('1','158','257505','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729257),('1','158','257506','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729258),('1','158','257507','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729259),('1','158','257508','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729260),('1','158','257509','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729261),('1','158','257510','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729262),('1','158','257511','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729263),('1','158','257512','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729264),('1','158','257513','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729265),('1','158','257514','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729266),('1','158','257515','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729267),('1','158','257516','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729268),('1','158','257517','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729269),('1','158','257518','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729270),('1','158','257519','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729271),('1','158','257520','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729272),('1','158','257521','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729273),('1','158','257522','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729274),('1','158','257523','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729275),('1','158','257524','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729276),('1','158','257525','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729277),('1','158','257526','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729278),('1','158','257527','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729279),('1','158','257528','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729280),('1','158','257529','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729281),('1','158','257530','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729282),('1','158','257531','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729283),('1','158','257532','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729284),('1','158','257533','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729285),('1','158','257534','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729286),('1','158','257535','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729287),('1','158','257536','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729288),('1','158','257537','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729289),('1','158','257538','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729290),('1','158','257539','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729291),('1','158','257540','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729292),('1','158','257541','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729293),('1','158','257542','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729294),('1','158','257543','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729295),('1','158','257544','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729296),('1','158','257545','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729297),('1','158','257546','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729298),('1','158','257547','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729299),('1','158','257548','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729300),('1','158','257549','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729301),('1','158','257550','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729302),('1','158','257551','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729303),('1','158','257552','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729304),('1','158','257553','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729305),('1','158','257554','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729306),('1','158','257555','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729307),('1','158','257556','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729308),('1','158','257557','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729309),('1','158','257558','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729310),('1','158','257559','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729311),('1','158','257560','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729312),('1','158','257561','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729313),('1','158','257562','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729314),('1','158','257563','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729315),('1','158','257564','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729316),('1','158','257565','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729317),('1','158','257566','335',675.00,0.00,0.00,0.00,0.00,0.00,0.00,729318),('1','158','257567','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729319),('1','158','257568','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729320),('1','158','257569','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729321),('1','158','257570','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729322),('1','158','257571','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729323),('1','158','257572','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729324),('1','158','257573','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729325),('1','158','257574','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729326),('1','158','257575','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729327),('1','158','257576','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729328),('1','158','257577','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729329),('1','158','257578','335',660.00,0.00,0.00,0.00,0.00,0.00,0.00,729330),('1','158','257579','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729331),('1','158','257580','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729332),('1','158','257581','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729333),('1','158','257582','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729334),('1','158','257583','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729335),('1','158','257584','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729336),('1','158','257585','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729337),('1','158','257586','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729338),('1','158','257587','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729339),('1','158','257588','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729340),('1','158','257589','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729341),('1','158','257590','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729342),('1','158','257591','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729343),('1','158','257592','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729344),('1','158','257593','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729345),('1','158','257594','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729346),('1','158','257595','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729347),('1','158','257596','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729348),('1','158','257597','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729349),('1','158','257598','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729350),('1','158','257599','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729351),('1','158','257600','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729352),('1','158','257601','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729353),('1','158','257602','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729354),('1','158','257603','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729355),('1','158','257604','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729356),('1','158','257605','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729357),('1','158','257606','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729358),('1','158','257607','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729359),('1','158','257608','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729360),('1','158','257609','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729361),('1','158','257610','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729362),('1','158','257611','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729363),('1','158','257612','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729364),('1','158','257613','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729365),('1','158','257614','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729366),('1','158','257615','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729367),('1','158','257616','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729368),('1','158','257617','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729369),('1','158','257618','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729370),('1','158','257619','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729371),('1','158','257620','335',654.00,0.00,0.00,0.00,0.00,0.00,0.00,729372),('1','158','257621','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729373),('1','158','257622','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729374),('1','158','257623','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729375),('1','158','257624','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729376),('1','158','257625','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729377),('1','158','257626','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729378),('1','158','257627','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729379),('1','158','257628','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729380),('1','158','257629','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729381),('1','158','257630','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729382),('1','158','257631','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729383),('1','158','257632','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729384),('1','158','257633','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729385),('1','158','257634','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729386),('1','158','257635','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729387),('1','158','257636','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729388),('1','158','257637','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729389),('1','158','257638','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729390),('1','158','257639','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729391),('1','158','257640','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729392),('1','158','257641','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729393),('1','158','257642','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729394),('1','158','257643','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729395),('1','158','257644','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729396),('1','158','257645','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729397),('1','158','257646','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729398),('1','158','257647','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729399),('1','158','257648','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729400),('1','158','257649','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729401),('1','158','257650','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729402),('1','158','257651','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729403),('1','158','257652','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729404),('1','158','257653','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729405),('1','158','257654','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729406),('1','158','257655','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729407),('1','158','257656','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729408),('1','158','257657','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729409),('1','158','257658','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729410),('1','158','257659','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729411),('1','158','257660','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729412),('1','158','257661','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729413),('1','158','257662','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729414),('1','158','257663','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729415),('1','158','257664','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729416),('1','158','257665','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729417),('1','158','257666','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729418),('1','158','257667','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729419),('1','158','257668','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729420),('1','158','257669','335',630.00,0.00,0.00,0.00,0.00,0.00,0.00,729421),('1','158','257670','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729422),('1','158','257671','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729423),('1','158','257672','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729424),('1','158','257673','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729425),('1','158','257674','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729426),('1','158','257675','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729427),('1','158','257676','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729428),('1','158','257677','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729429),('1','158','257678','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729430),('1','158','257679','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729431),('1','158','257680','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729432),('1','158','257681','335',624.00,0.00,0.00,0.00,0.00,0.00,0.00,729433);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',311,'158','PRODUCT TANKS','TANKS CONTAINING LPG PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=782 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','158','311',780,1,'335','LPG TANK 1',70000.00,1.00,631.00,'TANK CONTAINING LPG PRODUCT.','479','2020-08-12 12:02:48','2020-08-12 12:19:06','479',5,1),('1','158','311',781,1,'335','LPG TANK 2',70000.00,1.00,0.00,'TANK CONTAINING LPG PRODUCT.','479','2020-08-12 12:05:03','2020-08-12 12:19:46','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','158',781,48481.00,'2023-03-20 17:58:49'),(2,'1','158',780,37370.00,'2023-03-20 18:00:38');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2635182 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2124384,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2021-12-02 09:33:34','',''),(2124401,'1','158',NULL,335,'Reception corrector for bridging 125927',0.00,0.00,0.00,25000.00,0.00,'2021-12-02 09:34:57','',''),(2124402,'1','158','781',335,'Received from bridging 125927',0.00,0.00,25000.00,0.00,0.00,'2021-12-02 09:34:57','',''),(2124441,'1','158','781',335,'Distributed to NYANYA for sales id:336657',2575200.00,0.00,0.00,4350.00,0.00,'2021-12-02 09:38:32','',''),(2124446,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:336661',3161280.00,0.00,0.00,5340.00,0.00,'2021-12-02 09:38:49','',''),(2124557,'1','158','781',335,'Distributed to KEFFI for sales id:336662',3119840.00,0.00,0.00,5270.00,0.00,'2021-12-02 09:44:53','',''),(2124566,'1','158','781',335,'Distributed to KUJE for sales id:336663',2125280.00,0.00,0.00,3590.00,0.00,'2021-12-02 09:45:12','',''),(2124569,'1','158','781',335,'Distributed to CITY GATE for sales id:336664',3102080.00,0.00,0.00,5240.00,0.00,'2021-12-02 09:45:28','',''),(2124620,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:336665',686720.00,0.00,0.00,1160.00,0.00,'2021-12-02 09:48:43','',''),(2124670,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:336666',59200.00,0.00,0.00,100.00,0.00,'2021-12-02 09:50:48','',''),(2150020,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14550000.00,25000.00,0.00,0.00,'2021-12-04 08:55:01','',''),(2150047,'1','158',NULL,335,'Reception corrector for bridging 126173',0.00,0.00,0.00,25000.00,0.00,'2021-12-04 08:56:16','',''),(2150048,'1','158','780',335,'Received from bridging 126173',0.00,0.00,25000.00,0.00,0.00,'2021-12-04 08:56:16','',''),(2150133,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:337119',2333820.00,0.00,0.00,4010.00,0.00,'2021-12-04 08:59:47','',''),(2150138,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:337120',3061320.00,0.00,0.00,5260.00,0.00,'2021-12-04 09:00:02','',''),(2150265,'1','158','780',335,'Distributed to NYANYA for sales id:337124',3323220.00,0.00,0.00,5710.00,0.00,'2021-12-04 09:06:07','',''),(2150270,'1','158','780',335,'Distributed to KUJE for sales id:337125',3061320.00,0.00,0.00,5260.00,0.00,'2021-12-04 09:06:22','',''),(2150271,'1','158','780',335,'Distributed to JABI for sales id:337126',2653920.00,0.00,0.00,4560.00,0.00,'2021-12-04 09:06:36','',''),(2150302,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:337127',116400.00,0.00,0.00,200.00,0.00,'2021-12-04 09:08:25','',''),(2167787,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14550000.00,25000.00,0.00,0.00,'2021-12-05 11:39:58','',''),(2167794,'1','158',NULL,335,'Reception corrector for bridging 126301',0.00,0.00,0.00,25000.00,0.00,'2021-12-05 11:41:28','',''),(2167795,'1','158','780',335,'Received from bridging 126301',0.00,0.00,25000.00,0.00,0.00,'2021-12-05 11:41:28','',''),(2167864,'1','158','780',335,'Distributed to JABI for sales id:337325',407400.00,0.00,0.00,700.00,0.00,'2021-12-05 11:45:41','',''),(2167871,'1','158','780',335,'Distributed to EDEMA GAS for sales id:337326',3235920.00,0.00,0.00,5560.00,0.00,'2021-12-05 11:45:58','',''),(2167983,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:337327',2968200.00,0.00,0.00,5100.00,0.00,'2021-12-05 11:52:12','',''),(2168000,'1','158','780',335,'Distributed to KARU PLANT for sales id:337328',3195180.00,0.00,0.00,5490.00,0.00,'2021-12-05 11:52:49','',''),(2168007,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:337329',3148620.00,0.00,0.00,5410.00,0.00,'2021-12-05 11:53:08','',''),(2168058,'1','158','780',335,'Distributed to KEFFI for sales id:337330',1530660.00,0.00,0.00,2630.00,0.00,'2021-12-05 11:56:08','',''),(2168089,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:337331',64020.00,0.00,0.00,110.00,0.00,'2021-12-05 11:57:45','',''),(2177475,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14520900.00,24950.00,0.00,0.00,'2021-12-06 09:12:08','',''),(2177490,'1','158',NULL,335,'Reception corrector for bridging 126358',0.00,0.00,0.00,24950.00,0.00,'2021-12-06 09:13:41','',''),(2177491,'1','158','781',335,'Received from bridging 126358',0.00,0.00,24950.00,0.00,0.00,'2021-12-06 09:13:41','',''),(2177640,'1','158','781',335,'Distributed to KEFFI for sales id:337439',1501560.00,0.00,0.00,2580.00,0.00,'2021-12-06 09:23:44','',''),(2177643,'1','158','781',335,'Distributed to KARU PLANT for sales id:337440',3107880.00,0.00,0.00,5340.00,0.00,'2021-12-06 09:24:00','',''),(2177650,'1','158','781',335,'Distributed to NYANYA for sales id:337441',3119520.00,0.00,0.00,5360.00,0.00,'2021-12-06 09:24:19','',''),(2177657,'1','158','781',335,'Distributed to CITY GATE for sales id:337442',3125340.00,0.00,0.00,5370.00,0.00,'2021-12-06 09:24:36','',''),(2177662,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:337443',2974020.00,0.00,0.00,5110.00,0.00,'2021-12-06 09:24:55','',''),(2177665,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:337444',750780.00,0.00,0.00,1290.00,0.00,'2021-12-06 09:25:10','',''),(2194008,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14474340.00,24870.00,0.00,0.00,'2021-12-07 13:10:24','',''),(2194035,'1','158',NULL,335,'Reception corrector for bridging 126471',0.00,0.00,0.00,24870.00,0.00,'2021-12-07 13:11:43','',''),(2194036,'1','158','781',335,'Received from bridging 126471',0.00,0.00,24870.00,0.00,0.00,'2021-12-07 13:11:43','',''),(2194106,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:337697',2141760.00,0.00,0.00,3680.00,0.00,'2021-12-07 13:16:10','',''),(2194179,'1','158','781',335,'Distributed to APO for sales id:337702',3142800.00,0.00,0.00,5400.00,0.00,'2021-12-07 13:20:29','',''),(2194184,'1','158','781',335,'Distributed to KARU PLANT for sales id:337703',2968200.00,0.00,0.00,5100.00,0.00,'2021-12-07 13:20:44','',''),(2194260,'1','158','781',335,'Distributed to JABI for sales id:337704',2950740.00,0.00,0.00,5070.00,0.00,'2021-12-07 13:25:31','',''),(2194293,'1','158','781',335,'Distributed to APO for sales id:337705',3032220.00,0.00,0.00,5210.00,0.00,'2021-12-07 13:26:47','',''),(2194310,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:337706',244440.00,0.00,0.00,420.00,0.00,'2021-12-07 13:27:25','',''),(2203303,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14538360.00,24980.00,0.00,0.00,'2021-12-08 09:48:01','',''),(2203334,'1','158',NULL,335,'Reception corrector for bridging 126567',0.00,0.00,0.00,24980.00,0.00,'2021-12-08 09:49:29','',''),(2203335,'1','158','780',335,'Received from bridging 126567',0.00,0.00,24980.00,0.00,0.00,'2021-12-08 09:49:29','',''),(2203452,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:337953',2857620.00,0.00,0.00,4910.00,0.00,'2021-12-08 09:58:57','',''),(2203459,'1','158','780',335,'Distributed to KARU PLANT for sales id:337954',3026400.00,0.00,0.00,5200.00,0.00,'2021-12-08 09:59:16','',''),(2203472,'1','158','780',335,'Distributed to KUJE for sales id:337955',3532740.00,0.00,0.00,6070.00,0.00,'2021-12-08 09:59:46','',''),(2203475,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:337956',2962380.00,0.00,0.00,5090.00,0.00,'2021-12-08 10:00:10','',''),(2203490,'1','158','780',335,'Distributed to KEFFI for sales id:337957',1967160.00,0.00,0.00,3380.00,0.00,'2021-12-08 10:00:59','',''),(2203527,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:337958',192060.00,0.00,0.00,330.00,0.00,'2021-12-08 10:03:17','',''),(2220677,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14538360.00,24980.00,0.00,0.00,'2021-12-09 14:26:01','',''),(2220734,'1','158',NULL,335,'Reception corrector for bridging 126739',0.00,0.00,0.00,24980.00,0.00,'2021-12-09 14:28:31','',''),(2220735,'1','158','780',335,'Received from bridging 126739',0.00,0.00,24980.00,0.00,0.00,'2021-12-09 14:28:31','',''),(2220822,'1','158','780',335,'Distributed to KEFFI for sales id:338302',337560.00,0.00,0.00,580.00,0.00,'2021-12-09 14:32:53','',''),(2221032,'1','158','780',335,'Distributed to NYANYA for sales id:338304',2962380.00,0.00,0.00,5090.00,0.00,'2021-12-09 14:40:55','',''),(2221035,'1','158','780',335,'Distributed to KARU PLANT for sales id:338305',3119520.00,0.00,0.00,5360.00,0.00,'2021-12-09 14:41:09','',''),(2221050,'1','158','780',335,'Distributed to LIFE CAMP for sales id:338306',3177720.00,0.00,0.00,5460.00,0.00,'2021-12-09 14:41:34','',''),(2221055,'1','158','780',335,'Distributed to APO for sales id:338307',3142800.00,0.00,0.00,5400.00,0.00,'2021-12-09 14:41:48','',''),(2221118,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:338311',1757640.00,0.00,0.00,3020.00,0.00,'2021-12-09 14:44:42','',''),(2221179,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:338313',40740.00,0.00,0.00,70.00,0.00,'2021-12-09 14:46:59','',''),(2235580,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13479120.00,23160.00,0.00,0.00,'2021-12-10 15:51:59','',''),(2235614,'1','158',NULL,335,'Reception corrector for bridging 126909',0.00,0.00,0.00,23160.00,0.00,'2021-12-10 15:53:41','',''),(2235615,'1','158','780',335,'Received from bridging 126909',0.00,0.00,23160.00,0.00,0.00,'2021-12-10 15:53:41','',''),(2235726,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:338617',1233840.00,0.00,0.00,2120.00,0.00,'2021-12-10 15:58:45','',''),(2235733,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:338618',3119520.00,0.00,0.00,5360.00,0.00,'2021-12-10 15:59:00','',''),(2235738,'1','158','780',335,'Distributed to DON NAS GAS for sales id:338619',2717940.00,0.00,0.00,4670.00,0.00,'2021-12-10 15:59:14','',''),(2235836,'1','158','780',335,'Distributed to KARU PLANT for sales id:338622',2892540.00,0.00,0.00,4970.00,0.00,'2021-12-10 16:04:02','',''),(2235841,'1','158','780',335,'Distributed to CITY GATE for sales id:338639',2892540.00,0.00,0.00,4970.00,0.00,'2021-12-10 16:04:16','',''),(2235848,'1','158','780',335,'Distributed to JABI for sales id:338640',419040.00,0.00,0.00,720.00,0.00,'2021-12-10 16:04:29','',''),(2235893,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:338641',203700.00,0.00,0.00,350.00,0.00,'2021-12-10 16:05:57','',''),(2258007,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12847320.00,22860.00,0.00,0.00,'2021-12-12 11:49:42','',''),(2258052,'1','158',NULL,335,'Reception corrector for bridging 127124',0.00,0.00,0.00,22860.00,0.00,'2021-12-12 11:51:29','',''),(2258053,'1','158','781',335,'Received from bridging 127124',0.00,0.00,22860.00,0.00,0.00,'2021-12-12 11:51:29','',''),(2258126,'1','158','781',335,'Distributed to JABI for sales id:339052',2495280.00,0.00,0.00,4440.00,0.00,'2021-12-12 11:54:33','',''),(2258131,'1','158','781',335,'Distributed to APO for sales id:339053',3091000.00,0.00,0.00,5500.00,0.00,'2021-12-12 11:54:47','',''),(2258238,'1','158','781',335,'Distributed to NYANYA for sales id:339054',2928020.00,0.00,0.00,5210.00,0.00,'2021-12-12 12:00:23','',''),(2258245,'1','158','781',335,'Distributed to KARU PLANT for sales id:339055',2810000.00,0.00,0.00,5000.00,0.00,'2021-12-12 12:00:37','',''),(2258246,'1','158','781',335,'Distributed to KEFFI for sales id:339056',1315080.00,0.00,0.00,2340.00,0.00,'2021-12-12 12:00:50','',''),(2258277,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:339057',207940.00,0.00,0.00,370.00,0.00,'2021-12-12 12:02:43','',''),(2258850,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14005040.00,24920.00,0.00,0.00,'2021-12-12 12:30:38','',''),(2258877,'1','158',NULL,335,'Reception corrector for bridging 127128',0.00,0.00,0.00,24920.00,0.00,'2021-12-12 12:31:56','',''),(2258878,'1','158','781',335,'Received from bridging 127128',0.00,0.00,24920.00,0.00,0.00,'2021-12-12 12:31:56','',''),(2259004,'1','158','781',335,'Distributed to KEFFI for sales id:339058',1843360.00,0.00,0.00,3280.00,0.00,'2021-12-12 12:37:17','',''),(2259009,'1','158','781',335,'Distributed to JEFF GAS for sales id:339059',5282800.00,0.00,0.00,9400.00,0.00,'2021-12-12 12:37:31','',''),(2259016,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:339060',2838100.00,0.00,0.00,5050.00,0.00,'2021-12-12 12:37:46','',''),(2259023,'1','158','781',335,'Distributed to APO for sales id:339061',2804380.00,0.00,0.00,4990.00,0.00,'2021-12-12 12:38:00','',''),(2259076,'1','158','781',335,'Distributed to KUJE for sales id:339063',1247640.00,0.00,0.00,2220.00,0.00,'2021-12-12 12:40:20','',''),(2269716,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14123060.00,25130.00,0.00,0.00,'2021-12-13 10:48:50','',''),(2269738,'1','158',NULL,335,'Reception corrector for bridging 127233',0.00,0.00,0.00,25130.00,0.00,'2021-12-13 10:50:03','',''),(2269739,'1','158','780',335,'Received from bridging 127233',0.00,0.00,25130.00,0.00,0.00,'2021-12-13 10:50:03','',''),(2270001,'1','158','780',335,'Distributed to KUJE for sales id:339211',1562360.00,0.00,0.00,2780.00,0.00,'2021-12-13 11:05:52','',''),(2270020,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:339212',3062900.00,0.00,0.00,5450.00,0.00,'2021-12-13 11:07:25','',''),(2270023,'1','158','780',335,'Distributed to KARU PLANT for sales id:339213',2922400.00,0.00,0.00,5200.00,0.00,'2021-12-13 11:08:05','',''),(2270032,'1','158','780',335,'Distributed to HARIZ GAS for sales id:339214',3135960.00,0.00,0.00,5580.00,0.00,'2021-12-13 11:08:22','',''),(2270041,'1','158','780',335,'Distributed to NYANYA for sales id:339215',3057280.00,0.00,0.00,5440.00,0.00,'2021-12-13 11:08:46','',''),(2270081,'1','158','780',335,'Distributed to KATAMFE for sales id:339216',297860.00,0.00,0.00,530.00,0.00,'2021-12-13 11:12:16','',''),(2270600,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:339217',84300.00,0.00,0.00,150.00,0.00,'2021-12-13 11:54:05','',''),(2282414,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14044380.00,24990.00,0.00,0.00,'2021-12-14 11:36:38','',''),(2282415,'1','158',NULL,335,'Reception corrector for bridging 127342',0.00,0.00,0.00,24990.00,0.00,'2021-12-14 11:38:15','',''),(2282416,'1','158','780',335,'Received from bridging 127342',0.00,0.00,24990.00,0.00,0.00,'2021-12-14 11:38:15','',''),(2282664,'1','158','780',335,'Distributed to KATAMFE for sales id:339536',2523380.00,0.00,0.00,4490.00,0.00,'2021-12-14 12:49:47','',''),(2282667,'1','158','780',335,'Distributed to APO for sales id:339537',3017940.00,0.00,0.00,5370.00,0.00,'2021-12-14 12:50:01','',''),(2282671,'1','158','780',335,'Distributed to KARU PLANT for sales id:339539',2972980.00,0.00,0.00,5290.00,0.00,'2021-12-14 12:50:14','',''),(2282673,'1','158','780',335,'Distributed to KATAMFE for sales id:339540',3074140.00,0.00,0.00,5470.00,0.00,'2021-12-14 12:50:29','',''),(2282675,'1','158','780',335,'Distributed to JABI for sales id:339541',2455940.00,0.00,0.00,4370.00,0.00,'2021-12-14 12:50:42','',''),(2283499,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13667120.00,24940.00,0.00,0.00,'2021-12-14 14:25:23','',''),(2283509,'1','158',NULL,335,'Reception corrector for bridging 127362',0.00,0.00,0.00,24940.00,0.00,'2021-12-14 14:26:40','',''),(2283510,'1','158','781',335,'Received from bridging 127362',0.00,0.00,24940.00,0.00,0.00,'2021-12-14 14:26:40','',''),(2283567,'1','158','781',335,'Distributed to JABI for sales id:339586',498680.00,0.00,0.00,910.00,0.00,'2021-12-14 14:31:02','',''),(2283570,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:339587',2756440.00,0.00,0.00,5030.00,0.00,'2021-12-14 14:31:17','',''),(2283671,'1','158','781',335,'Distributed to KUJE for sales id:339595',2992080.00,0.00,0.00,5460.00,0.00,'2021-12-14 14:43:38','',''),(2283678,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:339596',2866040.00,0.00,0.00,5230.00,0.00,'2021-12-14 14:44:04','',''),(2283684,'1','158','781',335,'Distributed to KATAMFE for sales id:339597',2816720.00,0.00,0.00,5140.00,0.00,'2021-12-14 14:44:28','',''),(2283696,'1','158','781',335,'Distributed to APO for sales id:339598',1709760.00,0.00,0.00,3120.00,0.00,'2021-12-14 14:45:31','',''),(2283709,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:339602',82200.00,0.00,0.00,150.00,0.00,'2021-12-14 14:47:03','',''),(2296010,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13875360.00,25320.00,0.00,0.00,'2021-12-16 10:24:49','',''),(2296029,'1','158',NULL,335,'Reception corrector for bridging 127608',0.00,0.00,0.00,25320.00,0.00,'2021-12-16 10:27:41','',''),(2296030,'1','158','781',335,'Received from bridging 127608',0.00,0.00,25320.00,0.00,0.00,'2021-12-16 10:27:41','',''),(2296407,'1','158','781',335,'Distributed to APO for sales id:340085',794600.00,0.00,0.00,1450.00,0.00,'2021-12-16 11:11:20','',''),(2296409,'1','158','781',335,'Distributed to KARU PLANT for sales id:340086',2887960.00,0.00,0.00,5270.00,0.00,'2021-12-16 11:11:35','',''),(2296414,'1','158','781',335,'Distributed to CITY GATE for sales id:340087',2767400.00,0.00,0.00,5050.00,0.00,'2021-12-16 11:11:51','',''),(2296469,'1','158','781',335,'Distributed to KATAMFE for sales id:340089',2800280.00,0.00,0.00,5110.00,0.00,'2021-12-16 11:18:50','',''),(2296471,'1','158','781',335,'Distributed to APO for sales id:340090',2849600.00,0.00,0.00,5200.00,0.00,'2021-12-16 11:19:11','',''),(2296475,'1','158','781',335,'Distributed to NYANYA for sales id:340091',1649480.00,0.00,0.00,3010.00,0.00,'2021-12-16 11:19:28','',''),(2296498,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:340092',126040.00,0.00,0.00,230.00,0.00,'2021-12-16 11:21:21','',''),(2302862,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13689040.00,24980.00,0.00,0.00,'2021-12-17 08:46:40','',''),(2302871,'1','158',NULL,335,'Reception corrector for bridging 127700',0.00,0.00,0.00,24980.00,0.00,'2021-12-17 08:47:59','',''),(2302872,'1','158','780',335,'Received from bridging 127700',0.00,0.00,24980.00,0.00,0.00,'2021-12-17 08:47:59','',''),(2302937,'1','158','780',335,'Distributed to NYANYA for sales id:340354',1178200.00,0.00,0.00,2150.00,0.00,'2021-12-17 08:52:21','',''),(2302942,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:340356',2887960.00,0.00,0.00,5270.00,0.00,'2021-12-17 08:52:36','',''),(2303040,'1','158','780',335,'Distributed to KEFFI for sales id:340357',2871520.00,0.00,0.00,5240.00,0.00,'2021-12-17 09:00:18','',''),(2303047,'1','158','780',335,'Distributed to KARU PLANT for sales id:340358',2789320.00,0.00,0.00,5090.00,0.00,'2021-12-17 09:00:57','',''),(2303050,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:340359',2920840.00,0.00,0.00,5330.00,0.00,'2021-12-17 09:01:13','',''),(2303054,'1','158','780',335,'Distributed to KUJE for sales id:340360',767200.00,0.00,0.00,1400.00,0.00,'2021-12-17 09:01:27','',''),(2303074,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:340363',274000.00,0.00,0.00,500.00,0.00,'2021-12-17 09:03:28','',''),(2312373,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13787680.00,25160.00,0.00,0.00,'2021-12-18 10:59:41','',''),(2312390,'1','158',NULL,335,'Reception corrector for bridging 127851',0.00,0.00,0.00,25160.00,0.00,'2021-12-18 11:01:34','',''),(2312391,'1','158','780',335,'Received from bridging 127851',0.00,0.00,25160.00,0.00,0.00,'2021-12-18 11:01:34','',''),(2312437,'1','158','780',335,'Distributed to KUJE for sales id:340629',2263240.00,0.00,0.00,4130.00,0.00,'2021-12-18 11:05:16','',''),(2312441,'1','158','780',335,'Distributed to KATAMFE for sales id:340630',2849600.00,0.00,0.00,5200.00,0.00,'2021-12-18 11:05:30','',''),(2312634,'1','158','780',335,'Distributed to APO for sales id:340632',2877000.00,0.00,0.00,5250.00,0.00,'2021-12-18 11:18:07','',''),(2312638,'1','158','780',335,'Distributed to JABI for sales id:340633',2613960.00,0.00,0.00,4770.00,0.00,'2021-12-18 11:18:22','',''),(2312641,'1','158','780',335,'Distributed to KARU PLANT for sales id:340634',2701640.00,0.00,0.00,4930.00,0.00,'2021-12-18 11:18:37','',''),(2312642,'1','158','780',335,'Distributed to NYANYA for sales id:340635',372640.00,0.00,0.00,680.00,0.00,'2021-12-18 11:18:51','',''),(2312666,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:340636',98640.00,0.00,0.00,180.00,0.00,'2021-12-18 11:20:49','',''),(2312947,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13700000.00,25000.00,0.00,0.00,'2021-12-18 11:44:55','',''),(2312956,'1','158',NULL,335,'Reception corrector for bridging 127861',0.00,0.00,0.00,25000.00,0.00,'2021-12-18 11:46:14','',''),(2312957,'1','158','781',335,'Received from bridging 127861',0.00,0.00,25000.00,0.00,0.00,'2021-12-18 11:46:14','',''),(2312998,'1','158','781',335,'Distributed to NYANYA for sales id:340638',2449560.00,0.00,0.00,4470.00,0.00,'2021-12-18 11:51:29','',''),(2313000,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:340639',3035920.00,0.00,0.00,5540.00,0.00,'2021-12-18 11:51:44','',''),(2313044,'1','158','781',335,'Distributed to KATAMFE for sales id:340640',2805760.00,0.00,0.00,5120.00,0.00,'2021-12-18 11:57:24','',''),(2313046,'1','158','781',335,'Distributed to APO for sales id:340641',2860560.00,0.00,0.00,5220.00,0.00,'2021-12-18 11:57:38','',''),(2313049,'1','158','781',335,'Distributed to KARU PLANT for sales id:340642',2383800.00,0.00,0.00,4350.00,0.00,'2021-12-18 11:57:51','',''),(2313059,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:340643',54800.00,0.00,0.00,100.00,0.00,'2021-12-18 11:59:34','',''),(2323314,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13765760.00,25120.00,0.00,0.00,'2021-12-19 13:52:38','',''),(2323331,'1','158',NULL,335,'Reception corrector for bridging 127988',0.00,0.00,0.00,25120.00,0.00,'2021-12-19 13:53:58','',''),(2323332,'1','158','781',335,'Received from bridging 127988',0.00,0.00,25120.00,0.00,0.00,'2021-12-19 13:53:58','',''),(2323398,'1','158','781',335,'Distributed to KARU PLANT for sales id:340835',361680.00,0.00,0.00,660.00,0.00,'2021-12-19 13:58:43','',''),(2323402,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:340836',2904400.00,0.00,0.00,5300.00,0.00,'2021-12-19 13:58:57','',''),(2323407,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:340837',328800.00,0.00,0.00,600.00,0.00,'2021-12-19 13:59:10','',''),(2323500,'1','158','781',335,'Distributed to KUJE for sales id:340841',2526280.00,0.00,0.00,4610.00,0.00,'2021-12-19 14:04:54','',''),(2323504,'1','158','781',335,'Distributed to KARU PLANT for sales id:340842',2871520.00,0.00,0.00,5240.00,0.00,'2021-12-19 14:05:08','',''),(2323510,'1','158','781',335,'Distributed to CITY GATE for sales id:340843',2860560.00,0.00,0.00,5220.00,0.00,'2021-12-19 14:05:22','',''),(2323518,'1','158','781',335,'Distributed to APO for sales id:340844',1912520.00,0.00,0.00,3490.00,0.00,'2021-12-19 14:06:02','',''),(2323541,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:340845',109600.00,0.00,0.00,200.00,0.00,'2021-12-19 14:07:23','',''),(2329651,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13820560.00,25220.00,0.00,0.00,'2021-12-20 12:46:33','',''),(2329664,'1','158',NULL,335,'Reception corrector for bridging 128059',0.00,0.00,0.00,25220.00,0.00,'2021-12-20 12:48:27','',''),(2329665,'1','158','780',335,'Received from bridging 128059',0.00,0.00,25220.00,0.00,0.00,'2021-12-20 12:48:27','',''),(2329722,'1','158','780',335,'Distributed to APO for sales id:340964',937080.00,0.00,0.00,1710.00,0.00,'2021-12-20 12:53:58','',''),(2329724,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:340965',2866040.00,0.00,0.00,5230.00,0.00,'2021-12-20 12:54:13','',''),(2329727,'1','158','780',335,'Distributed to NYANYA for sales id:340966',2931800.00,0.00,0.00,5350.00,0.00,'2021-12-20 12:54:27','',''),(2329772,'1','158','780',335,'Distributed to KARU PLANT for sales id:340970',2630400.00,0.00,0.00,4800.00,0.00,'2021-12-20 12:59:42','',''),(2329781,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:340967',2959200.00,0.00,0.00,5400.00,0.00,'2021-12-20 13:00:15','',''),(2329786,'1','158','780',335,'Distributed to JABI for sales id:340971',1413840.00,0.00,0.00,2580.00,0.00,'2021-12-20 13:00:32','',''),(2329801,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:340975',82200.00,0.00,0.00,150.00,0.00,'2021-12-20 13:02:06','',''),(2331192,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:341083',5480.00,0.00,0.00,10.00,0.00,'2021-12-20 15:03:46','',''),(2331206,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:341084',126040.00,0.00,0.00,230.00,0.00,'2021-12-20 15:05:28','',''),(2337691,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13776720.00,25140.00,0.00,0.00,'2021-12-21 14:02:57','',''),(2337709,'1','158',NULL,335,'Reception corrector for bridging 128217',0.00,0.00,0.00,25140.00,0.00,'2021-12-21 14:04:31','',''),(2337710,'1','158','780',335,'Received from bridging 128217',0.00,0.00,25140.00,0.00,0.00,'2021-12-21 14:04:31','',''),(2337761,'1','158','780',335,'Distributed to JABI for sales id:341251',1309720.00,0.00,0.00,2390.00,0.00,'2021-12-21 14:10:35','',''),(2337765,'1','158','780',335,'Distributed to KEFFI for sales id:341252',2805760.00,0.00,0.00,5120.00,0.00,'2021-12-21 14:10:54','',''),(2337768,'1','158','780',335,'Distributed to APO for sales id:341253',2920840.00,0.00,0.00,5330.00,0.00,'2021-12-21 14:11:08','',''),(2337817,'1','158','780',335,'Distributed to KUJE for sales id:341256',2498880.00,0.00,0.00,4560.00,0.00,'2021-12-21 14:15:48','',''),(2337820,'1','158','780',335,'Distributed to KARU PLANT for sales id:341257',2948240.00,0.00,0.00,5380.00,0.00,'2021-12-21 14:16:00','',''),(2337824,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:341258',1293280.00,0.00,0.00,2360.00,0.00,'2021-12-21 14:16:13','',''),(2389664,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13754800.00,25100.00,0.00,0.00,'2021-12-28 11:59:15','',''),(2389691,'1','158',NULL,335,'Reception corrector for bridging 128997',0.00,0.00,0.00,25100.00,0.00,'2021-12-28 12:01:18','',''),(2389692,'1','158','781',335,'Received from bridging 128997',0.00,0.00,25100.00,0.00,0.00,'2021-12-28 12:01:18','',''),(2389732,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13689040.00,24980.00,0.00,0.00,'2021-12-28 12:04:09','',''),(2389758,'1','158',NULL,335,'Reception corrector for bridging 128998',0.00,0.00,0.00,24980.00,0.00,'2021-12-28 12:05:44','',''),(2389759,'1','158','781',335,'Received from bridging 128998',0.00,0.00,24980.00,0.00,0.00,'2021-12-28 12:05:44','',''),(2390050,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:342661',1896080.00,0.00,0.00,3460.00,0.00,'2021-12-28 12:32:41','',''),(2390056,'1','158','781',335,'Distributed to APO for sales id:342662',2624920.00,0.00,0.00,4790.00,0.00,'2021-12-28 12:32:58','',''),(2390057,'1','158','781',335,'Distributed to EDEMA GAS for sales id:342663',2849600.00,0.00,0.00,5200.00,0.00,'2021-12-28 12:33:23','',''),(2390205,'1','158','781',335,'Distributed to NYANYA for sales id:342666',2920840.00,0.00,0.00,5330.00,0.00,'2021-12-28 12:45:21','',''),(2390207,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:342667',2877000.00,0.00,0.00,5250.00,0.00,'2021-12-28 12:45:40','',''),(2390212,'1','158','781',335,'Distributed to KARU PLANT for sales id:342668',2805760.00,0.00,0.00,5120.00,0.00,'2021-12-28 12:46:04','',''),(2390216,'1','158','781',335,'Distributed to AMITEX GAS for sales id:342669',2213920.00,0.00,0.00,4040.00,0.00,'2021-12-28 12:46:24','',''),(2390220,'1','158','781',335,'Distributed to APO for sales id:342670',2931800.00,0.00,0.00,5350.00,0.00,'2021-12-28 12:46:43','',''),(2390224,'1','158','781',335,'Distributed to JABI for sales id:342671',2871520.00,0.00,0.00,5240.00,0.00,'2021-12-28 12:47:04','',''),(2390251,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13667120.00,24940.00,0.00,0.00,'2021-12-28 12:50:51','',''),(2390265,'1','158',NULL,335,'Reception corrector for bridging 129005',0.00,0.00,0.00,24940.00,0.00,'2021-12-28 12:52:35','',''),(2390266,'1','158','780',335,'Received from bridging 129005',0.00,0.00,24940.00,0.00,0.00,'2021-12-28 12:52:35','',''),(2390421,'1','158','781',335,'Distributed to KARU PLANT for sales id:342679',2948240.00,0.00,0.00,5380.00,0.00,'2021-12-28 13:05:39','',''),(2390424,'1','158','781',335,'Distributed to KUJE for sales id:342680',356200.00,0.00,0.00,650.00,0.00,'2021-12-28 13:05:58','',''),(2390426,'1','158','780',335,'Distributed to KUJE for sales id:342681',2093360.00,0.00,0.00,3820.00,0.00,'2021-12-28 13:06:17','',''),(2390428,'1','158','780',335,'Distributed to CITY GATE for sales id:342682',2959200.00,0.00,0.00,5400.00,0.00,'2021-12-28 13:06:35','',''),(2390432,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:342683',2707120.00,0.00,0.00,4940.00,0.00,'2021-12-28 13:06:55','',''),(2390435,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:342684',2915360.00,0.00,0.00,5320.00,0.00,'2021-12-28 13:07:11','',''),(2390489,'1','158','780',335,'Distributed to APO for sales id:342685',2915360.00,0.00,0.00,5320.00,0.00,'2021-12-28 13:11:35','',''),(2390510,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:342686',147960.00,0.00,0.00,270.00,0.00,'2021-12-28 13:14:42','',''),(2390515,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:342686',76720.00,0.00,0.00,140.00,0.00,'2021-12-28 13:15:14','',''),(2390532,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13694520.00,24990.00,0.00,0.00,'2021-12-28 13:17:32','',''),(2390552,'1','158',NULL,335,'Reception corrector for bridging 129009',0.00,0.00,0.00,24990.00,0.00,'2021-12-28 13:19:30','',''),(2390553,'1','158','781',335,'Received from bridging 129009',0.00,0.00,24990.00,0.00,0.00,'2021-12-28 13:19:30','',''),(2390672,'1','158','781',335,'Distributed to APO for sales id:342689',54800.00,0.00,0.00,100.00,0.00,'2021-12-28 13:30:25','',''),(2390677,'1','158','781',335,'Distributed to NYANYA for sales id:342690',2959200.00,0.00,0.00,5400.00,0.00,'2021-12-28 13:30:44','',''),(2390678,'1','158','781',335,'Distributed to KARU PLANT for sales id:342691',2811240.00,0.00,0.00,5130.00,0.00,'2021-12-28 13:31:07','',''),(2390690,'1','158','781',335,'Distributed to KEFFI for sales id:342692',2422160.00,0.00,0.00,4420.00,0.00,'2021-12-28 13:31:32','',''),(2390698,'1','158','781',335,'Distributed to KM TRADE GAS for sales id:342693',4241520.00,0.00,0.00,7740.00,0.00,'2021-12-28 13:31:49','',''),(2390728,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:342694',2893440.00,0.00,0.00,5280.00,0.00,'2021-12-28 13:32:57','',''),(2396855,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13678080.00,24960.00,0.00,0.00,'2021-12-29 12:47:51','',''),(2396867,'1','158',NULL,335,'Reception corrector for bridging 129110',0.00,0.00,0.00,24960.00,0.00,'2021-12-29 12:49:25','',''),(2396868,'1','158','781',335,'Received from bridging 129110',0.00,0.00,24960.00,0.00,0.00,'2021-12-29 12:49:25','',''),(2396900,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13700000.00,25000.00,0.00,0.00,'2021-12-29 12:54:11','',''),(2396910,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13710960.00,25020.00,0.00,0.00,'2021-12-29 12:55:40','',''),(2396919,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13710960.00,25020.00,0.00,0.00,'2021-12-29 12:56:48','',''),(2396932,'1','158',NULL,335,'Reception corrector for bridging 129111',0.00,0.00,0.00,25000.00,0.00,'2021-12-29 12:58:25','',''),(2396933,'1','158','781',335,'Received from bridging 129111',0.00,0.00,25000.00,0.00,0.00,'2021-12-29 12:58:25','',''),(2396938,'1','158',NULL,335,'Reception corrector for bridging 129112',0.00,0.00,0.00,25020.00,0.00,'2021-12-29 12:58:43','',''),(2396939,'1','158','780',335,'Received from bridging 129112',0.00,0.00,25020.00,0.00,0.00,'2021-12-29 12:58:43','',''),(2396941,'1','158',NULL,335,'Reception corrector for bridging 129113',0.00,0.00,0.00,25020.00,0.00,'2021-12-29 12:58:58','',''),(2396942,'1','158','780',335,'Received from bridging 129113',0.00,0.00,25020.00,0.00,0.00,'2021-12-29 12:58:58','',''),(2396994,'1','158','781',335,'Distributed to KUJE for sales id:342823',2898920.00,0.00,0.00,5290.00,0.00,'2021-12-29 13:03:06','',''),(2396998,'1','158','781',335,'Distributed to KARU PLANT for sales id:342824',2789320.00,0.00,0.00,5090.00,0.00,'2021-12-29 13:03:28','',''),(2397124,'1','158','781',335,'Distributed to APO for sales id:342828',2844120.00,0.00,0.00,5190.00,0.00,'2021-12-29 13:19:49','',''),(2397127,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:342830',2729040.00,0.00,0.00,4980.00,0.00,'2021-12-29 13:20:17','',''),(2397132,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:342831',2504360.00,0.00,0.00,4570.00,0.00,'2021-12-29 13:20:49','',''),(2397135,'1','158','781',335,'Distributed to KARU PLANT for sales id:342832',3003040.00,0.00,0.00,5480.00,0.00,'2021-12-29 13:21:08','',''),(2397138,'1','158','781',335,'Distributed to NYANYA for sales id:342833',2931800.00,0.00,0.00,5350.00,0.00,'2021-12-29 13:21:23','',''),(2397141,'1','158','781',335,'Distributed to JABI for sales id:342834',2855080.00,0.00,0.00,5210.00,0.00,'2021-12-29 13:21:35','',''),(2397144,'1','158','781',335,'Distributed to APO for sales id:342835',2964680.00,0.00,0.00,5410.00,0.00,'2021-12-29 13:21:48','',''),(2397214,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:342839',169880.00,0.00,0.00,310.00,0.00,'2021-12-29 13:30:33','',''),(2397217,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:342839',2586560.00,0.00,0.00,4720.00,0.00,'2021-12-29 13:30:56','',''),(2397347,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:342841',4120960.00,0.00,0.00,7520.00,0.00,'2021-12-29 13:45:54','',''),(2397349,'1','158','780',335,'Distributed to KARU PLANT for sales id:342842',3145520.00,0.00,0.00,5740.00,0.00,'2021-12-29 13:46:11','',''),(2397354,'1','158','780',335,'Distributed to KUJE for sales id:342843',2745480.00,0.00,0.00,5010.00,0.00,'2021-12-29 13:46:27','',''),(2397450,'1','158','780',335,'Distributed to APO for sales id:342850',2805760.00,0.00,0.00,5120.00,0.00,'2021-12-29 13:58:16','',''),(2397452,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:342851',2948240.00,0.00,0.00,5380.00,0.00,'2021-12-29 13:58:38','',''),(2397454,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:342854',2915360.00,0.00,0.00,5320.00,0.00,'2021-12-29 13:58:57','',''),(2397456,'1','158','780',335,'Distributed to KARU PLANT for sales id:342855',2849600.00,0.00,0.00,5200.00,0.00,'2021-12-29 13:59:15','',''),(2397459,'1','158','780',335,'Distributed to CITY GATE for sales id:342858',2964680.00,0.00,0.00,5410.00,0.00,'2021-12-29 13:59:34','',''),(2397463,'1','158','780',335,'Distributed to NYANYA for sales id:342859',564440.00,0.00,0.00,1030.00,0.00,'2021-12-29 13:59:51','',''),(2397519,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12445000.00,24890.00,0.00,0.00,'2021-12-29 14:05:15','',''),(2397538,'1','158',NULL,335,'Reception corrector for bridging 129118',0.00,0.00,0.00,24890.00,0.00,'2021-12-29 14:06:18','',''),(2397539,'1','158','780',335,'Received from bridging 129118',0.00,0.00,24890.00,0.00,0.00,'2021-12-29 14:06:18','',''),(2397554,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:342862',82200.00,0.00,0.00,150.00,0.00,'2021-12-29 14:07:37','',''),(2397615,'1','158','780',335,'Distributed to APO for sales id:342872',2710000.00,0.00,0.00,5420.00,0.00,'2021-12-29 14:15:04','',''),(2543636,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12490000.00,24980.00,0.00,0.00,'2022-01-18 12:00:37','',''),(2543646,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12470000.00,24940.00,0.00,0.00,'2022-01-18 12:02:33','',''),(2543662,'1','158',NULL,335,'Reception corrector for bridging 131293',0.00,0.00,0.00,24980.00,0.00,'2022-01-18 12:06:00','',''),(2543663,'1','158','781',335,'Received from bridging 131293',0.00,0.00,24980.00,0.00,0.00,'2022-01-18 12:06:00','',''),(2543671,'1','158',NULL,335,'Reception corrector for bridging 131294',0.00,0.00,0.00,24940.00,0.00,'2022-01-18 12:06:38','',''),(2543672,'1','158','781',335,'Received from bridging 131294',0.00,0.00,24940.00,0.00,0.00,'2022-01-18 12:06:38','',''),(2543742,'1','158','780',335,'Distributed to NYANYA for sales id:347081',2295000.00,0.00,0.00,4590.00,0.00,'2022-01-18 12:15:00','',''),(2543755,'1','158','780',335,'Distributed to KEFFI for sales id:347082',2040000.00,0.00,0.00,4080.00,0.00,'2022-01-18 12:16:31','',''),(2543765,'1','158','780',335,'Distributed to KARU PLANT for sales id:347083',2715000.00,0.00,0.00,5430.00,0.00,'2022-01-18 12:17:41','',''),(2543793,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:347084',255000.00,0.00,0.00,510.00,0.00,'2022-01-18 12:21:02','',''),(2543795,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:347084',2460000.00,0.00,0.00,4920.00,0.00,'2022-01-18 12:21:29','',''),(2543807,'1','158','781',335,'Distributed to KUJE for sales id:347085',2615000.00,0.00,0.00,5230.00,0.00,'2022-01-18 12:23:25','',''),(2543825,'1','158','781',335,'Distributed to JABI for sales id:347086',2560000.00,0.00,0.00,5120.00,0.00,'2022-01-18 12:25:36','',''),(2543840,'1','158','781',335,'Distributed to APO for sales id:347088',2725000.00,0.00,0.00,5450.00,0.00,'2022-01-18 12:26:54','',''),(2543933,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:347090',2565000.00,0.00,0.00,5130.00,0.00,'2022-01-18 12:37:04','',''),(2543971,'1','158','781',335,'Distributed to KARU PLANT for sales id:347091',2710000.00,0.00,0.00,5420.00,0.00,'2022-01-18 12:40:48','',''),(2543975,'1','158','781',335,'Distributed to HARIZ GAS for sales id:347093',2710000.00,0.00,0.00,5420.00,0.00,'2022-01-18 12:41:10','',''),(2567864,'1','158','781',335,'Distributed to GAS CONNECT for sales id:347896',1755000.00,0.00,0.00,3510.00,0.00,'2022-01-21 12:26:52','',''),(2567867,'1','158','781',335,'Distributed to NIP WEST GAS for sales id:347897',2795000.00,0.00,0.00,5590.00,0.00,'2022-01-21 12:27:08','',''),(2567874,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:347898',2590000.00,0.00,0.00,5180.00,0.00,'2022-01-21 12:27:24','',''),(2567875,'1','158','781',335,'Distributed to KARU PLANT for sales id:347899',1645000.00,0.00,0.00,3290.00,0.00,'2022-01-21 12:27:37','',''),(2569891,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12480000.00,24960.00,0.00,0.00,'2022-01-21 15:52:34','',''),(2569905,'1','158',NULL,335,'Reception corrector for bridging 131627',0.00,0.00,0.00,24960.00,0.00,'2022-01-21 15:53:51','',''),(2569906,'1','158','780',335,'Received from bridging 131627',0.00,0.00,24960.00,0.00,0.00,'2022-01-21 15:53:51','',''),(2569972,'1','158','780',335,'Distributed to KARU PLANT for sales id:347973',1035000.00,0.00,0.00,2070.00,0.00,'2022-01-21 15:58:14','',''),(2569973,'1','158','780',335,'Distributed to KUJE for sales id:347974',2360000.00,0.00,0.00,4720.00,0.00,'2022-01-21 15:58:28','',''),(2569979,'1','158','780',335,'Distributed to GAS CONNECT for sales id:347975',4000000.00,0.00,0.00,8000.00,0.00,'2022-01-21 15:58:41','',''),(2570028,'1','158','780',335,'Distributed to KEFFI for sales id:347979',2590000.00,0.00,0.00,5180.00,0.00,'2022-01-21 16:03:42','',''),(2570031,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:347980',2455000.00,0.00,0.00,4910.00,0.00,'2022-01-21 16:03:58','',''),(2570051,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:347981',20000.00,0.00,0.00,40.00,0.00,'2022-01-21 16:05:43','',''),(2570789,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12465000.00,24930.00,0.00,0.00,'2022-01-21 16:53:01','',''),(2570802,'1','158',NULL,335,'Reception corrector for bridging 131637',0.00,0.00,0.00,24930.00,0.00,'2022-01-21 16:54:26','',''),(2570803,'1','158','780',335,'Received from bridging 131637',0.00,0.00,24930.00,0.00,0.00,'2022-01-21 16:54:26','',''),(2570872,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348005',100000.00,0.00,0.00,200.00,0.00,'2022-01-21 16:59:05','',''),(2570874,'1','158','780',335,'Distributed to LIFE CAMP for sales id:348006',2555000.00,0.00,0.00,5110.00,0.00,'2022-01-21 16:59:19','',''),(2570931,'1','158','780',335,'Distributed to CITY GATE for sales id:348007',2360000.00,0.00,0.00,4720.00,0.00,'2022-01-21 17:03:14','',''),(2570935,'1','158','780',335,'Distributed to JABI for sales id:348008',2600000.00,0.00,0.00,5200.00,0.00,'2022-01-21 17:03:28','',''),(2571073,'1','158','780',335,'Distributed to JEFF GAS for sales id:348023',4725000.00,0.00,0.00,9450.00,0.00,'2022-01-21 17:12:37','',''),(2571093,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348024',125000.00,0.00,0.00,250.00,0.00,'2022-01-21 17:14:10','',''),(2571120,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12495000.00,24990.00,0.00,0.00,'2022-01-21 17:15:47','',''),(2571146,'1','158',NULL,335,'Reception corrector for bridging 131641',0.00,0.00,0.00,24990.00,0.00,'2022-01-21 17:17:44','',''),(2571147,'1','158','780',335,'Received from bridging 131641',0.00,0.00,24990.00,0.00,0.00,'2022-01-21 17:17:44','',''),(2571216,'1','158','780',335,'Distributed to KUJE for sales id:348025',2465000.00,0.00,0.00,4930.00,0.00,'2022-01-21 17:21:54','',''),(2571219,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348026',2675000.00,0.00,0.00,5350.00,0.00,'2022-01-21 17:22:13','',''),(2571291,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348027',2625000.00,0.00,0.00,5250.00,0.00,'2022-01-21 17:27:25','',''),(2571294,'1','158','780',335,'Distributed to KEFFI for sales id:348028',2585000.00,0.00,0.00,5170.00,0.00,'2022-01-21 17:27:40','',''),(2571299,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:348029',2145000.00,0.00,0.00,4290.00,0.00,'2022-01-21 17:27:53','',''),(2571347,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12430000.00,24860.00,0.00,0.00,'2022-01-21 17:30:42','',''),(2571368,'1','158',NULL,335,'Reception corrector for bridging 131643',0.00,0.00,0.00,24860.00,0.00,'2022-01-21 17:32:01','',''),(2571369,'1','158','781',335,'Received from bridging 131643',0.00,0.00,24860.00,0.00,0.00,'2022-01-21 17:32:01','',''),(2571466,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:348030',530000.00,0.00,0.00,1060.00,0.00,'2022-01-21 17:37:52','',''),(2571470,'1','158','781',335,'Distributed to MUNAH GAS for sales id:348031',2025000.00,0.00,0.00,4050.00,0.00,'2022-01-21 17:38:08','',''),(2571569,'1','158','781',335,'Distributed to NYANYA for sales id:348048',2950000.00,0.00,0.00,5900.00,0.00,'2022-01-21 17:46:02','',''),(2571573,'1','158','781',335,'Distributed to GANO GAS for sales id:348049',2525000.00,0.00,0.00,5050.00,0.00,'2022-01-21 17:46:29','',''),(2571581,'1','158','781',335,'Distributed to DON NAS GAS for sales id:348050',3120000.00,0.00,0.00,6240.00,0.00,'2022-01-21 17:46:59','',''),(2571625,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:348051',1245000.00,0.00,0.00,2490.00,0.00,'2022-01-21 17:50:32','',''),(2571652,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348053',35000.00,0.00,0.00,70.00,0.00,'2022-01-21 17:53:16','',''),(2572540,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12470000.00,24940.00,0.00,0.00,'2022-01-21 20:07:21','',''),(2572541,'1','158',NULL,335,'Reception corrector for bridging 131660',0.00,0.00,0.00,24940.00,0.00,'2022-01-21 20:08:29','',''),(2572542,'1','158','780',335,'Received from bridging 131660',0.00,0.00,24940.00,0.00,0.00,'2022-01-21 20:08:29','',''),(2572568,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348078',1345000.00,0.00,0.00,2690.00,0.00,'2022-01-21 20:16:20','',''),(2572570,'1','158','780',335,'Distributed to JABI for sales id:348079',2110000.00,0.00,0.00,4220.00,0.00,'2022-01-21 20:16:40','',''),(2572571,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348080',2730000.00,0.00,0.00,5460.00,0.00,'2022-01-21 20:16:54','',''),(2572572,'1','158','780',335,'Distributed to KUJE for sales id:348081',2535000.00,0.00,0.00,5070.00,0.00,'2022-01-21 20:17:08','',''),(2572574,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:348083',3445000.00,0.00,0.00,6890.00,0.00,'2022-01-21 20:17:21','',''),(2572580,'1','158','780',335,'Distributed to KEFFI for sales id:348089',230000.00,0.00,0.00,460.00,0.00,'2022-01-21 20:20:17','',''),(2572583,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348092',75000.00,0.00,0.00,150.00,0.00,'2022-01-21 20:21:48','',''),(2572595,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12500000.00,25000.00,0.00,0.00,'2022-01-21 20:38:41','',''),(2572596,'1','158',NULL,335,'Reception corrector for bridging 131665',0.00,0.00,0.00,25000.00,0.00,'2022-01-21 20:40:42','',''),(2572597,'1','158','780',335,'Received from bridging 131665',0.00,0.00,25000.00,0.00,0.00,'2022-01-21 20:40:42','',''),(2572598,'1','158','780',335,'Distributed to KEFFI for sales id:348093',2455000.00,0.00,0.00,4910.00,0.00,'2022-01-21 20:43:35','',''),(2572639,'1','158','780',335,'Distributed to NYANYA for sales id:348099',2550000.00,0.00,0.00,5100.00,0.00,'2022-01-21 20:55:42','',''),(2572640,'1','158','780',335,'Distributed to CITY GATE for sales id:348100',2690000.00,0.00,0.00,5380.00,0.00,'2022-01-21 20:55:57','',''),(2572641,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348101',2625000.00,0.00,0.00,5250.00,0.00,'2022-01-21 20:56:16','',''),(2572642,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348102',2140000.00,0.00,0.00,4280.00,0.00,'2022-01-21 20:56:32','',''),(2572646,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348104',40000.00,0.00,0.00,80.00,0.00,'2022-01-21 21:00:21','',''),(2572647,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12370000.00,24740.00,0.00,0.00,'2022-01-21 21:04:03','',''),(2572649,'1','158',NULL,335,'Reception corrector for bridging 131667',0.00,0.00,0.00,24740.00,0.00,'2022-01-21 21:06:19','',''),(2572650,'1','158','780',335,'Received from bridging 131667',0.00,0.00,24740.00,0.00,0.00,'2022-01-21 21:06:19','',''),(2572655,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348107',135000.00,0.00,0.00,270.00,0.00,'2022-01-21 21:10:34','',''),(2572656,'1','158','780',335,'Distributed to KUJE for sales id:348108',2705000.00,0.00,0.00,5410.00,0.00,'2022-01-21 21:10:54','',''),(2572661,'1','158','780',335,'Distributed to JABI for sales id:348109',2625000.00,0.00,0.00,5250.00,0.00,'2022-01-21 21:16:04','',''),(2572662,'1','158','780',335,'Distributed to KARU PLANT for sales id:348110',2635000.00,0.00,0.00,5270.00,0.00,'2022-01-21 21:16:18','',''),(2572682,'1','158','780',335,'Distributed to KATAMFE for sales id:348113',2555000.00,0.00,0.00,5110.00,0.00,'2022-01-21 21:36:09','',''),(2572683,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348114',1605000.00,0.00,0.00,3210.00,0.00,'2022-01-21 21:36:27','',''),(2572685,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348115',110000.00,0.00,0.00,220.00,0.00,'2022-01-21 21:38:32','',''),(2572697,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12500000.00,25000.00,0.00,0.00,'2022-01-21 21:41:45','',''),(2572714,'1','158',NULL,335,'Reception corrector for bridging 131668',0.00,0.00,0.00,25000.00,0.00,'2022-01-21 21:47:19','',''),(2572715,'1','158','781',335,'Received from bridging 131668',0.00,0.00,25000.00,0.00,0.00,'2022-01-21 21:47:19','',''),(2572732,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:348116',730000.00,0.00,0.00,1460.00,0.00,'2022-01-21 21:52:01','',''),(2572733,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:348117',2715000.00,0.00,0.00,5430.00,0.00,'2022-01-21 21:52:16','',''),(2572771,'1','158','781',335,'Distributed to JEFF GAS for sales id:348118',4665000.00,0.00,0.00,9330.00,0.00,'2022-01-21 21:59:27','',''),(2572772,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:348119',2780000.00,0.00,0.00,5560.00,0.00,'2022-01-21 21:59:41','',''),(2572773,'1','158','781',335,'Distributed to KATAMFE for sales id:348120',1600000.00,0.00,0.00,3200.00,0.00,'2022-01-21 21:59:58','',''),(2572774,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348121',10000.00,0.00,0.00,20.00,0.00,'2022-01-21 22:01:37','',''),(2572775,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12480000.00,24960.00,0.00,0.00,'2022-01-21 22:04:25','',''),(2572776,'1','158',NULL,335,'Reception corrector for bridging 131669',0.00,0.00,0.00,24960.00,0.00,'2022-01-21 22:05:42','',''),(2572777,'1','158','781',335,'Received from bridging 131669',0.00,0.00,24960.00,0.00,0.00,'2022-01-21 22:05:42','',''),(2572778,'1','158','781',335,'Distributed to KATAMFE for sales id:348122',930000.00,0.00,0.00,1860.00,0.00,'2022-01-21 22:13:01','',''),(2572779,'1','158','781',335,'Distributed to NYANYA for sales id:348123',1460000.00,0.00,0.00,2920.00,0.00,'2022-01-21 22:13:23','',''),(2572782,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:348124',2300000.00,0.00,0.00,4600.00,0.00,'2022-01-21 22:13:42','',''),(2572783,'1','158','781',335,'Distributed to GANO GAS for sales id:348125',2630000.00,0.00,0.00,5260.00,0.00,'2022-01-21 22:13:57','',''),(2572815,'1','158','781',335,'Distributed to KARU PLANT for sales id:348126',2555000.00,0.00,0.00,5110.00,0.00,'2022-01-21 22:18:28','',''),(2572816,'1','158','781',335,'Distributed to KUJE for sales id:348127',2595000.00,0.00,0.00,5190.00,0.00,'2022-01-21 22:18:46','',''),(2572826,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348128',10000.00,0.00,0.00,20.00,0.00,'2022-01-21 22:20:45','',''),(2572830,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12450000.00,24900.00,0.00,0.00,'2022-01-21 22:22:45','',''),(2572831,'1','158',NULL,335,'Reception corrector for bridging 131670',0.00,0.00,0.00,24900.00,0.00,'2022-01-21 22:24:05','',''),(2572832,'1','158','781',335,'Received from bridging 131670',0.00,0.00,24900.00,0.00,0.00,'2022-01-21 22:24:05','',''),(2572838,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:348129',2410000.00,0.00,0.00,4820.00,0.00,'2022-01-21 22:31:14','',''),(2572839,'1','158','781',335,'Distributed to KEFFI for sales id:348130',2460000.00,0.00,0.00,4920.00,0.00,'2022-01-21 22:31:29','',''),(2572840,'1','158','781',335,'Distributed to KATAMFE for sales id:348131',2725000.00,0.00,0.00,5450.00,0.00,'2022-01-21 22:31:44','',''),(2572841,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:348132',2700000.00,0.00,0.00,5400.00,0.00,'2022-01-21 22:32:07','',''),(2572842,'1','158','781',335,'Distributed to KARU PLANT for sales id:348133',2015000.00,0.00,0.00,4030.00,0.00,'2022-01-21 22:35:27','',''),(2572843,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348134',140000.00,0.00,0.00,280.00,0.00,'2022-01-21 22:38:38','',''),(2572844,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12515000.00,25030.00,0.00,0.00,'2022-01-21 22:41:45','',''),(2572845,'1','158',NULL,335,'Reception corrector for bridging 131671',0.00,0.00,0.00,25030.00,0.00,'2022-01-21 22:43:22','',''),(2572846,'1','158','780',335,'Received from bridging 131671',0.00,0.00,25030.00,0.00,0.00,'2022-01-21 22:43:22','',''),(2572848,'1','158','780',335,'Distributed to KARU PLANT for sales id:348135',530000.00,0.00,0.00,1060.00,0.00,'2022-01-21 22:49:06','',''),(2572849,'1','158','780',335,'Distributed to NYANYA for sales id:348136',2430000.00,0.00,0.00,4860.00,0.00,'2022-01-21 22:49:27','',''),(2572851,'1','158','780',335,'Distributed to JABI for sales id:348137',2740000.00,0.00,0.00,5480.00,0.00,'2022-01-21 22:50:03','',''),(2572853,'1','158','780',335,'Distributed to KARU PLANT for sales id:348139',2725000.00,0.00,0.00,5450.00,0.00,'2022-01-21 22:58:05','',''),(2572855,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348140',2335000.00,0.00,0.00,4670.00,0.00,'2022-01-21 22:58:54','',''),(2572856,'1','158','780',335,'Distributed to APO for sales id:348141',1640000.00,0.00,0.00,3280.00,0.00,'2022-01-21 22:59:11','',''),(2572858,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348142',115000.00,0.00,0.00,230.00,0.00,'2022-01-21 23:01:56','',''),(2572986,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,10020000.00,20040.00,0.00,0.00,'2022-01-22 06:53:51','',''),(2573025,'1','158',NULL,335,'Reception corrector for bridging 131675',0.00,0.00,0.00,20040.00,0.00,'2022-01-22 07:18:28','',''),(2573026,'1','158','781',335,'Received from bridging 131675',0.00,0.00,20040.00,0.00,0.00,'2022-01-22 07:18:28','',''),(2573075,'1','158','781',335,'Distributed to APO for sales id:348145',640000.00,0.00,0.00,1280.00,0.00,'2022-01-22 07:26:03','',''),(2573076,'1','158','781',335,'Distributed to KM TRADE GAS for sales id:348146',5370000.00,0.00,0.00,10740.00,0.00,'2022-01-22 07:26:16','',''),(2573077,'1','158','781',335,'Distributed to CITY GATE for sales id:348147',2690000.00,0.00,0.00,5380.00,0.00,'2022-01-22 07:26:29','',''),(2573078,'1','158','781',335,'Distributed to KUJE for sales id:348149',1220000.00,0.00,0.00,2440.00,0.00,'2022-01-22 07:26:41','',''),(2573086,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348150',100000.00,0.00,0.00,200.00,0.00,'2022-01-22 07:28:17','',''),(2573094,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12495000.00,24990.00,0.00,0.00,'2022-01-22 07:30:07','',''),(2573101,'1','158',NULL,335,'Reception corrector for bridging 131677',0.00,0.00,0.00,24990.00,0.00,'2022-01-22 07:31:29','',''),(2573102,'1','158','780',335,'Received from bridging 131677',0.00,0.00,24990.00,0.00,0.00,'2022-01-22 07:31:29','',''),(2573143,'1','158','780',335,'Distributed to KUJE for sales id:348151',1465000.00,0.00,0.00,2930.00,0.00,'2022-01-22 07:37:19','',''),(2573144,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348152',2640000.00,0.00,0.00,5280.00,0.00,'2022-01-22 07:37:33','',''),(2573146,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:348153',2285000.00,0.00,0.00,4570.00,0.00,'2022-01-22 07:37:46','',''),(2573147,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:348154',2520000.00,0.00,0.00,5040.00,0.00,'2022-01-22 07:37:58','',''),(2573170,'1','158','780',335,'Distributed to KARU PLANT for sales id:348155',2665000.00,0.00,0.00,5330.00,0.00,'2022-01-22 07:42:33','',''),(2573173,'1','158','780',335,'Distributed to NYANYA for sales id:348156',825000.00,0.00,0.00,1650.00,0.00,'2022-01-22 07:42:46','',''),(2573184,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348157',95000.00,0.00,0.00,190.00,0.00,'2022-01-22 07:44:24','',''),(2573191,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12460000.00,24920.00,0.00,0.00,'2022-01-22 07:46:05','',''),(2573199,'1','158',NULL,335,'Reception corrector for bridging 131679',0.00,0.00,0.00,24920.00,0.00,'2022-01-22 07:47:25','',''),(2573200,'1','158','780',335,'Received from bridging 131679',0.00,0.00,24920.00,0.00,0.00,'2022-01-22 07:47:25','',''),(2573210,'1','158','780',335,'Distributed to NYANYA for sales id:348158',1555000.00,0.00,0.00,3110.00,0.00,'2022-01-22 07:49:11','',''),(2573253,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348159',2195000.00,0.00,0.00,4390.00,0.00,'2022-01-22 07:56:15','',''),(2573254,'1','158','780',335,'Distributed to KARU PLANT for sales id:348160',2730000.00,0.00,0.00,5460.00,0.00,'2022-01-22 07:56:28','',''),(2573256,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348161',2655000.00,0.00,0.00,5310.00,0.00,'2022-01-22 07:56:41','',''),(2573262,'1','158','780',335,'Distributed to JABI for sales id:348162',1710000.00,0.00,0.00,3420.00,0.00,'2022-01-22 07:57:02','',''),(2573266,'1','158','780',335,'Distributed to KUJE for sales id:348163',1545000.00,0.00,0.00,3090.00,0.00,'2022-01-22 08:00:37','',''),(2573267,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348164',70000.00,0.00,0.00,140.00,0.00,'2022-01-22 08:02:20','',''),(2573581,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12555000.00,25110.00,0.00,0.00,'2022-01-22 08:35:05','',''),(2573594,'1','158',NULL,335,'Reception corrector for bridging 131688',0.00,0.00,0.00,25110.00,0.00,'2022-01-22 08:36:18','',''),(2573595,'1','158','780',335,'Received from bridging 131688',0.00,0.00,25110.00,0.00,0.00,'2022-01-22 08:36:18','',''),(2573656,'1','158','780',335,'Distributed to KUJE for sales id:348167',1030000.00,0.00,0.00,2060.00,0.00,'2022-01-22 08:43:41','',''),(2573658,'1','158','780',335,'Distributed to KEFFI for sales id:348168',2680000.00,0.00,0.00,5360.00,0.00,'2022-01-22 08:43:55','',''),(2573660,'1','158','780',335,'Distributed to KARU PLANT for sales id:348169',2630000.00,0.00,0.00,5260.00,0.00,'2022-01-22 08:44:11','',''),(2573665,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:348170',3605000.00,0.00,0.00,7210.00,0.00,'2022-01-22 08:44:25','',''),(2573668,'1','158','780',335,'Distributed to KUJE for sales id:348171',2575000.00,0.00,0.00,5150.00,0.00,'2022-01-22 08:44:44','',''),(2573691,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348172',35000.00,0.00,0.00,70.00,0.00,'2022-01-22 08:46:46','',''),(2573712,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12540000.00,25080.00,0.00,0.00,'2022-01-22 08:48:40','',''),(2573818,'1','158',NULL,335,'Reception corrector for bridging 131691',0.00,0.00,0.00,25080.00,0.00,'2022-01-22 09:01:55','',''),(2573819,'1','158','780',335,'Received from bridging 131691',0.00,0.00,25080.00,0.00,0.00,'2022-01-22 09:01:55','',''),(2573849,'1','158','780',335,'Distributed to GANO GAS for sales id:348182',2620000.00,0.00,0.00,5240.00,0.00,'2022-01-22 09:05:06','',''),(2573851,'1','158','780',335,'Distributed to NYANYA for sales id:348183',1070000.00,0.00,0.00,2140.00,0.00,'2022-01-22 09:05:21','',''),(2573855,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348184',1590000.00,0.00,0.00,3180.00,0.00,'2022-01-22 09:05:37','',''),(2573963,'1','158','780',335,'Distributed to CITY GATE for sales id:348191',2605000.00,0.00,0.00,5210.00,0.00,'2022-01-22 09:15:15','',''),(2573968,'1','158','780',335,'Distributed to KARU PLANT for sales id:348192',2535000.00,0.00,0.00,5070.00,0.00,'2022-01-22 09:15:28','',''),(2573973,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348193',2020000.00,0.00,0.00,4040.00,0.00,'2022-01-22 09:15:43','',''),(2574197,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12660000.00,25320.00,0.00,0.00,'2022-01-22 09:37:07','',''),(2574213,'1','158',NULL,335,'Reception corrector for bridging 131699',0.00,0.00,0.00,25320.00,0.00,'2022-01-22 09:38:33','',''),(2574214,'1','158','780',335,'Received from bridging 131699',0.00,0.00,25320.00,0.00,0.00,'2022-01-22 09:38:33','',''),(2574295,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348194',255000.00,0.00,0.00,510.00,0.00,'2022-01-22 09:45:10','',''),(2574299,'1','158','780',335,'Distributed to JABI for sales id:348195',2550000.00,0.00,0.00,5100.00,0.00,'2022-01-22 09:45:28','',''),(2574303,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:348196',2605000.00,0.00,0.00,5210.00,0.00,'2022-01-22 09:45:52','',''),(2574506,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348204',2660000.00,0.00,0.00,5320.00,0.00,'2022-01-22 09:59:44','',''),(2574508,'1','158','780',335,'Distributed to NYANYA for sales id:348205',2515000.00,0.00,0.00,5030.00,0.00,'2022-01-22 09:59:57','',''),(2574520,'1','158','780',335,'Distributed to KARU PLANT for sales id:348206',1955000.00,0.00,0.00,3910.00,0.00,'2022-01-22 10:00:17','',''),(2574570,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12495000.00,24990.00,0.00,0.00,'2022-01-22 10:04:28','',''),(2574593,'1','158',NULL,335,'Reception corrector for bridging 131701',0.00,0.00,0.00,24990.00,0.00,'2022-01-22 10:05:58','',''),(2574594,'1','158','780',335,'Received from bridging 131701',0.00,0.00,24990.00,0.00,0.00,'2022-01-22 10:05:58','',''),(2574735,'1','158','780',335,'Distributed to KARU PLANT for sales id:348208',730000.00,0.00,0.00,1460.00,0.00,'2022-01-22 10:17:19','',''),(2574740,'1','158','780',335,'Distributed to LIFE CAMP for sales id:348209',2705000.00,0.00,0.00,5410.00,0.00,'2022-01-22 10:17:34','',''),(2574820,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348211',2355000.00,0.00,0.00,4710.00,0.00,'2022-01-22 10:25:08','',''),(2574822,'1','158','780',335,'Distributed to KUJE for sales id:348212',2635000.00,0.00,0.00,5270.00,0.00,'2022-01-22 10:25:21','',''),(2574824,'1','158','780',335,'Distributed to KARU PLANT for sales id:348213',2650000.00,0.00,0.00,5300.00,0.00,'2022-01-22 10:25:35','',''),(2574888,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348214',2735000.00,0.00,0.00,5470.00,0.00,'2022-01-22 10:30:45','',''),(2574932,'1','158','781',335,'Distributed to OVERAGE for sales id:348215',1095000.00,0.00,0.00,2190.00,0.00,'2022-01-22 10:34:20','',''),(2575423,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12470000.00,24940.00,0.00,0.00,'2022-01-22 11:10:38','',''),(2575443,'1','158',NULL,335,'Reception corrector for bridging 131713',0.00,0.00,0.00,24940.00,0.00,'2022-01-22 11:12:00','',''),(2575444,'1','158','780',335,'Received from bridging 131713',0.00,0.00,24940.00,0.00,0.00,'2022-01-22 11:12:00','',''),(2575510,'1','158',NULL,335,'Inventory reconciliation by HAFIZ NURA  GAYA',0.00,0.00,24940.00,20560.00,0.00,'2022-01-22 11:17:43','',''),(2575523,'1','158','780',0,'Tank level zero out for dipping',0.00,0.00,0.00,22721.00,0.00,'2022-01-22 11:18:34','',''),(2575524,'1','158','780',0,'Inventory adjustment from tank dipping to 24940',0.00,0.00,24940.00,0.00,0.00,'2022-01-22 11:18:34','',''),(2575532,'1','158','781',0,'Tank level zero out for dipping',0.00,0.00,0.00,-2160.00,0.00,'2022-01-22 11:18:58','',''),(2575533,'1','158','781',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-01-22 11:18:58','',''),(2575960,'1','158','780',335,'Distributed to LIFE CAMP for sales id:348231',2690000.00,0.00,0.00,5380.00,0.00,'2022-01-22 11:49:04','',''),(2575962,'1','158','780',335,'Distributed to NYANYA for sales id:348232',2435000.00,0.00,0.00,4870.00,0.00,'2022-01-22 11:49:18','',''),(2575964,'1','158','780',335,'Distributed to JABI for sales id:348233',2000000.00,0.00,0.00,4000.00,0.00,'2022-01-22 11:49:35','',''),(2575971,'1','158','780',335,'Distributed to APO for sales id:348234',2595000.00,0.00,0.00,5190.00,0.00,'2022-01-22 11:49:49','',''),(2575975,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:348235',2340000.00,0.00,0.00,4680.00,0.00,'2022-01-22 11:50:05','',''),(2576075,'1','158','780',335,'Distributed to LIFE CAMP for sales id:348237',410000.00,0.00,0.00,820.00,0.00,'2022-01-22 11:58:09','',''),(2576118,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12580000.00,25160.00,0.00,0.00,'2022-01-22 12:00:14','',''),(2576136,'1','158',NULL,335,'Reception corrector for bridging 131721',0.00,0.00,0.00,25160.00,0.00,'2022-01-22 12:01:34','',''),(2576137,'1','158','781',335,'Received from bridging 131721',0.00,0.00,25160.00,0.00,0.00,'2022-01-22 12:01:34','',''),(2576284,'1','158','781',335,'Distributed to LIFE CAMP for sales id:348239',2160000.00,0.00,0.00,4320.00,0.00,'2022-01-22 12:13:07','',''),(2576290,'1','158','781',335,'Distributed to KARU PLANT for sales id:348240',2610000.00,0.00,0.00,5220.00,0.00,'2022-01-22 12:13:23','',''),(2576294,'1','158','781',335,'Distributed to KEFFI for sales id:348241',2480000.00,0.00,0.00,4960.00,0.00,'2022-01-22 12:13:41','',''),(2576297,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:348242',2160000.00,0.00,0.00,4320.00,0.00,'2022-01-22 12:13:59','',''),(2576305,'1','158','781',335,'Distributed to CITY GATE for sales id:348243',2740000.00,0.00,0.00,5480.00,0.00,'2022-01-22 12:14:21','',''),(2576312,'1','158','781',335,'Distributed to JEFF GAS for sales id:348244',350000.00,0.00,0.00,700.00,0.00,'2022-01-22 12:14:37','',''),(2576343,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348245',80000.00,0.00,0.00,160.00,0.00,'2022-01-22 12:17:14','',''),(2576482,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12465000.00,24930.00,0.00,0.00,'2022-01-22 12:27:43','',''),(2576513,'1','158',NULL,335,'Reception corrector for bridging 131726',0.00,0.00,0.00,24930.00,0.00,'2022-01-22 12:29:17','',''),(2576514,'1','158','781',335,'Received from bridging 131726',0.00,0.00,24930.00,0.00,0.00,'2022-01-22 12:29:17','',''),(2576555,'1','158','781',335,'Distributed to JEFF GAS for sales id:348265',4345000.00,0.00,0.00,8690.00,0.00,'2022-01-22 12:31:17','',''),(2576773,'1','158','781',335,'Distributed to KARU PLANT for sales id:348271',2590000.00,0.00,0.00,5180.00,0.00,'2022-01-22 12:46:18','',''),(2576775,'1','158','781',335,'Distributed to LIFE CAMP for sales id:348272',2685000.00,0.00,0.00,5370.00,0.00,'2022-01-22 12:46:32','',''),(2576791,'1','158','781',335,'Distributed to APO for sales id:348273',2620000.00,0.00,0.00,5240.00,0.00,'2022-01-22 12:47:28','',''),(2576815,'1','158','781',335,'Distributed to KUJE for sales id:348280',225000.00,0.00,0.00,450.00,0.00,'2022-01-22 12:48:44','',''),(2590826,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12530000.00,25060.00,0.00,0.00,'2022-01-24 09:05:24','',''),(2590833,'1','158',NULL,335,'Reception corrector for bridging 131926',0.00,0.00,0.00,25060.00,0.00,'2022-01-24 09:06:55','',''),(2590834,'1','158','780',335,'Received from bridging 131926',0.00,0.00,25060.00,0.00,0.00,'2022-01-24 09:06:55','',''),(2590904,'1','158','780',335,'Distributed to KUJE for sales id:348554',2160000.00,0.00,0.00,4320.00,0.00,'2022-01-24 09:17:43','',''),(2590907,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:348555',2525000.00,0.00,0.00,5050.00,0.00,'2022-01-24 09:17:59','',''),(2590910,'1','158','780',335,'Distributed to GANO GAS for sales id:348556',2660000.00,0.00,0.00,5320.00,0.00,'2022-01-24 09:18:13','',''),(2590913,'1','158','780',335,'Distributed to JABI for sales id:348557',1800000.00,0.00,0.00,3600.00,0.00,'2022-01-24 09:18:28','',''),(2590916,'1','158','780',335,'Distributed to MAXPRIME GAS for sales id:348558',1375000.00,0.00,0.00,2750.00,0.00,'2022-01-24 09:18:44','',''),(2590920,'1','158','780',335,'Distributed to KATAMFE for sales id:348559',1880000.00,0.00,0.00,3760.00,0.00,'2022-01-24 09:18:58','',''),(2590933,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:348567',130000.00,0.00,0.00,260.00,0.00,'2022-01-24 09:20:56','',''),(2590946,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12610000.00,25220.00,0.00,0.00,'2022-01-24 09:22:55','',''),(2590961,'1','158',NULL,335,'Reception corrector for bridging 131928',0.00,0.00,0.00,25220.00,0.00,'2022-01-24 09:24:27','',''),(2590962,'1','158','780',335,'Received from bridging 131928',0.00,0.00,25220.00,0.00,0.00,'2022-01-24 09:24:27','',''),(2590986,'1','158','780',335,'Distributed to KATAMFE for sales id:348569',830000.00,0.00,0.00,1660.00,0.00,'2022-01-24 09:26:22','',''),(2591186,'1','158','780',335,'Distributed to NYANYA for sales id:348570',2405000.00,0.00,0.00,4810.00,0.00,'2022-01-24 09:37:22','',''),(2591193,'1','158','780',335,'Distributed to KARU PLANT for sales id:348571',2530000.00,0.00,0.00,5060.00,0.00,'2022-01-24 09:37:39','',''),(2591196,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:348572',2280000.00,0.00,0.00,4560.00,0.00,'2022-01-24 09:37:58','',''),(2591198,'1','158','780',335,'Distributed to APO for sales id:348573',2660000.00,0.00,0.00,5320.00,0.00,'2022-01-24 09:38:19','',''),(2591219,'1','158','780',335,'Distributed to LIFE CAMP for sales id:348574',1905000.00,0.00,0.00,3810.00,0.00,'2022-01-24 09:38:44','',''),(2600585,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12480000.00,24960.00,0.00,0.00,'2022-01-25 13:04:18','',''),(2600606,'1','158',NULL,335,'Reception corrector for bridging 132059',0.00,0.00,0.00,24960.00,0.00,'2022-01-25 13:06:46','',''),(2600607,'1','158','781',335,'Received from bridging 132059',0.00,0.00,24960.00,0.00,0.00,'2022-01-25 13:06:46','',''),(2600645,'1','158','781',335,'Distributed to LIFE CAMP for sales id:348896',355000.00,0.00,0.00,710.00,0.00,'2022-01-25 13:11:11','',''),(2600827,'1','158','781',335,'Distributed to KUJE for sales id:348897',2580000.00,0.00,0.00,5160.00,0.00,'2022-01-25 13:22:43','',''),(2600830,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:348898',2470000.00,0.00,0.00,4940.00,0.00,'2022-01-25 13:22:58','',''),(2600833,'1','158','781',335,'Distributed to KARU PLANT for sales id:348899',2600000.00,0.00,0.00,5200.00,0.00,'2022-01-25 13:23:13','',''),(2600836,'1','158','781',335,'Distributed to APO for sales id:348900',2580000.00,0.00,0.00,5160.00,0.00,'2022-01-25 13:23:28','',''),(2600858,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:348901',1870000.00,0.00,0.00,3740.00,0.00,'2022-01-25 13:25:59','',''),(2600874,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:348903',25000.00,0.00,0.00,50.00,0.00,'2022-01-25 13:28:08','',''),(2609753,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12580000.00,25160.00,0.00,0.00,'2022-01-26 14:50:57','',''),(2609759,'1','158',NULL,335,'Reception corrector for bridging 132185',0.00,0.00,0.00,25160.00,0.00,'2022-01-26 14:52:23','',''),(2609760,'1','158','781',335,'Received from bridging 132185',0.00,0.00,25160.00,0.00,0.00,'2022-01-26 14:52:23','',''),(2609763,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:349243',645000.00,0.00,0.00,1290.00,0.00,'2022-01-26 14:54:21','',''),(2609812,'1','158','781',335,'Distributed to JABI for sales id:349250',2750000.00,0.00,0.00,5500.00,0.00,'2022-01-26 15:01:24','',''),(2609834,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:349251',2355000.00,0.00,0.00,4710.00,0.00,'2022-01-26 15:01:41','',''),(2609835,'1','158','781',335,'Distributed to NYANYA for sales id:349252',2575000.00,0.00,0.00,5150.00,0.00,'2022-01-26 15:02:01','',''),(2609837,'1','158','781',335,'Distributed to CITY GATE for sales id:349253',2445000.00,0.00,0.00,4890.00,0.00,'2022-01-26 15:02:20','',''),(2609868,'1','158','781',335,'Distributed to KEFFI for sales id:349254',1745000.00,0.00,0.00,3490.00,0.00,'2022-01-26 15:06:20','',''),(2609874,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:349255',65000.00,0.00,0.00,130.00,0.00,'2022-01-26 15:08:35','',''),(2612828,'1','158',NULL,335,'Balance from closing inventory values 2021-11-31 23:59:59',3053492846.85,3079869430.00,11076594.00,11076094.00,0.00,'2021-11-30 23:59:59','',''),(2613277,'1','158','780',0,'Balance from closing inventory values 2021-11-31 23:59:59',1527930160.00,0.00,4363564.00,4363573.00,0.00,'2021-11-30 23:59:59','',''),(2613840,'1','158','781',0,'Balance from closing inventory values 2021-11-31 23:59:59',1424124296.85,0.00,4155915.00,4155405.00,0.00,'2021-11-30 23:59:59','',''),(2621410,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12500000.00,25000.00,0.00,0.00,'2022-01-27 17:53:45','',''),(2621420,'1','158',NULL,335,'Reception corrector for bridging 132313',0.00,0.00,0.00,25000.00,0.00,'2022-01-27 17:55:02','',''),(2621421,'1','158','780',335,'Received from bridging 132313',0.00,0.00,25000.00,0.00,0.00,'2022-01-27 17:55:02','',''),(2621508,'1','158','780',335,'Distributed to KEFFI for sales id:349644',805000.00,0.00,0.00,1610.00,0.00,'2022-01-27 18:02:32','',''),(2621511,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:349645',2695000.00,0.00,0.00,5390.00,0.00,'2022-01-27 18:02:47','',''),(2621517,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:349647',2635000.00,0.00,0.00,5270.00,0.00,'2022-01-27 18:03:06','',''),(2621520,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:349648',2685000.00,0.00,0.00,5370.00,0.00,'2022-01-27 18:03:22','',''),(2621524,'1','158','780',335,'Distributed to GANO GAS for sales id:349649',2660000.00,0.00,0.00,5320.00,0.00,'2022-01-27 18:03:36','',''),(2621555,'1','158','780',335,'Distributed to KUJE for sales id:349650',1620000.00,0.00,0.00,3240.00,0.00,'2022-01-27 18:06:43','',''),(2631665,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12475000.00,24950.00,0.00,0.00,'2022-01-29 08:00:47','',''),(2631668,'1','158',NULL,335,'Reception corrector for bridging 132494',0.00,0.00,0.00,24950.00,0.00,'2022-01-29 08:02:15','',''),(2631669,'1','158','780',335,'Received from bridging 132494',0.00,0.00,24950.00,0.00,0.00,'2022-01-29 08:02:15','',''),(2631679,'1','158','780',335,'Distributed to KUJE for sales id:350047',1020000.00,0.00,0.00,2040.00,0.00,'2022-01-29 08:05:40','',''),(2631681,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350048',2030000.00,0.00,0.00,4060.00,0.00,'2022-01-29 08:05:59','',''),(2631708,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350049',2175000.00,0.00,0.00,4350.00,0.00,'2022-01-29 08:11:22','',''),(2631709,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350050',2510000.00,0.00,0.00,5020.00,0.00,'2022-01-29 08:11:37','',''),(2631710,'1','158','780',335,'Distributed to JABI for sales id:350052',1345000.00,0.00,0.00,2690.00,0.00,'2022-01-29 08:11:52','',''),(2631730,'1','158','780',335,'Distributed to NYANYA for sales id:350057',2570000.00,0.00,0.00,5140.00,0.00,'2022-01-29 08:16:14','',''),(2631739,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350058',225000.00,0.00,0.00,450.00,0.00,'2022-01-29 08:17:53','',''),(2631740,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12520000.00,25040.00,0.00,0.00,'2022-01-31 14:03:50','',''),(2631741,'1','158',NULL,335,'Reception corrector for bridging 132495',0.00,0.00,0.00,25040.00,0.00,'2022-01-31 14:05:04','',''),(2631742,'1','158','780',335,'Received from bridging 132495',0.00,0.00,25040.00,0.00,0.00,'2022-01-31 14:05:04','',''),(2631743,'1','158','780',335,'Distributed to JABI for sales id:350059',1415000.00,0.00,0.00,2830.00,0.00,'2022-01-31 14:06:44','',''),(2631744,'1','158','780',335,'Distributed to KUJE for sales id:350060',2595000.00,0.00,0.00,5190.00,0.00,'2022-01-31 14:13:44','',''),(2631745,'1','158','780',335,'Distributed to CITY GATE for sales id:350061',2655000.00,0.00,0.00,5310.00,0.00,'2022-01-31 14:14:10','',''),(2631746,'1','158','780',335,'Distributed to KARU PLANT for sales id:350062',2570000.00,0.00,0.00,5140.00,0.00,'2022-01-31 14:14:32','',''),(2631747,'1','158','780',335,'Distributed to NYANYA for sales id:350063',2590000.00,0.00,0.00,5180.00,0.00,'2022-01-31 14:48:05','',''),(2631748,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350064',475000.00,0.00,0.00,950.00,0.00,'2022-01-31 14:48:23','',''),(2631749,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350065',220000.00,0.00,0.00,440.00,0.00,'2022-01-31 14:49:55','',''),(2631750,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12435000.00,24870.00,0.00,0.00,'2022-01-31 15:20:19','',''),(2631751,'1','158',NULL,335,'Reception corrector for bridging 132496',0.00,0.00,0.00,24870.00,0.00,'2022-01-31 15:21:38','',''),(2631752,'1','158','781',335,'Received from bridging 132496',0.00,0.00,24870.00,0.00,0.00,'2022-01-31 15:21:38','',''),(2631753,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350066',2150000.00,0.00,0.00,4300.00,0.00,'2022-01-31 15:29:31','',''),(2631754,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350067',2715000.00,0.00,0.00,5430.00,0.00,'2022-01-31 15:29:46','',''),(2631755,'1','158','781',335,'Distributed to KEFFI for sales id:350068',2675000.00,0.00,0.00,5350.00,0.00,'2022-01-31 15:30:01','',''),(2631756,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350069',2550000.00,0.00,0.00,5100.00,0.00,'2022-01-31 15:30:15','',''),(2631757,'1','158','781',335,'Distributed to KARU PLANT for sales id:350070',2345000.00,0.00,0.00,4690.00,0.00,'2022-01-31 15:30:29','',''),(2631758,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12590000.00,25180.00,0.00,0.00,'2022-02-01 12:57:46','',''),(2631759,'1','158',NULL,335,'Reception corrector for bridging 132497',0.00,0.00,0.00,25180.00,0.00,'2022-02-01 12:59:14','',''),(2631760,'1','158','781',335,'Received from bridging 132497',0.00,0.00,25180.00,0.00,0.00,'2022-02-01 12:59:14','',''),(2631761,'1','158','781',335,'Distributed to KARU PLANT for sales id:350071',390000.00,0.00,0.00,780.00,0.00,'2022-02-01 13:01:06','',''),(2631762,'1','158','781',335,'Distributed to SUNSHINE GAS for sales id:350072',2565000.00,0.00,0.00,5130.00,0.00,'2022-02-01 13:09:10','',''),(2631763,'1','158','781',335,'Distributed to KUJE for sales id:350073',2585000.00,0.00,0.00,5170.00,0.00,'2022-02-01 13:09:24','',''),(2631764,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350074',2195000.00,0.00,0.00,4390.00,0.00,'2022-02-01 13:09:39','',''),(2631765,'1','158','781',335,'Distributed to KARU PLANT for sales id:350075',2705000.00,0.00,0.00,5410.00,0.00,'2022-02-01 13:09:52','',''),(2631766,'1','158','781',335,'Distributed to JABI for sales id:350076',2075000.00,0.00,0.00,4150.00,0.00,'2022-02-01 13:10:05','',''),(2631767,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350077',75000.00,0.00,0.00,150.00,0.00,'2022-02-01 13:11:47','',''),(2631768,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12505000.00,25010.00,0.00,0.00,'2022-02-01 17:16:59','',''),(2631769,'1','158',NULL,335,'Reception corrector for bridging 132498',0.00,0.00,0.00,25010.00,0.00,'2022-02-01 17:18:31','',''),(2631770,'1','158','780',335,'Received from bridging 132498',0.00,0.00,25010.00,0.00,0.00,'2022-02-01 17:18:31','',''),(2631771,'1','158','780',335,'Distributed to JABI for sales id:350078',620000.00,0.00,0.00,1240.00,0.00,'2022-02-01 17:20:53','',''),(2631772,'1','158','780',335,'Distributed to NYANYA for sales id:350080',2515000.00,0.00,0.00,5030.00,0.00,'2022-02-01 17:54:12','',''),(2631773,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350081',2385000.00,0.00,0.00,4770.00,0.00,'2022-02-01 17:54:25','',''),(2631774,'1','158','780',335,'Distributed to APO for sales id:350082',2710000.00,0.00,0.00,5420.00,0.00,'2022-02-01 17:54:39','',''),(2631775,'1','158','780',335,'Distributed to CITY GATE for sales id:350083',2710000.00,0.00,0.00,5420.00,0.00,'2022-02-01 17:54:53','',''),(2631776,'1','158','780',335,'Distributed to KATAMFE for sales id:350084',1345000.00,0.00,0.00,2690.00,0.00,'2022-02-01 17:55:08','',''),(2631777,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350085',220000.00,0.00,0.00,440.00,0.00,'2022-02-01 17:56:39','',''),(2631778,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12338200.00,25180.00,0.00,0.00,'2022-02-03 14:02:44','',''),(2631779,'1','158',NULL,335,'Reception corrector for bridging 132499',0.00,0.00,0.00,25180.00,0.00,'2022-02-03 14:04:10','',''),(2631780,'1','158','780',335,'Received from bridging 132499',0.00,0.00,25180.00,0.00,0.00,'2022-02-03 14:04:10','',''),(2631781,'1','158','780',335,'Distributed to KATAMFE for sales id:350086',1166200.00,0.00,0.00,2380.00,0.00,'2022-02-03 14:09:12','',''),(2631782,'1','158','780',335,'Distributed to KARU PLANT for sales id:350087',2097200.00,0.00,0.00,4280.00,0.00,'2022-02-03 14:09:28','',''),(2631783,'1','158','780',335,'Distributed to GANO GAS for sales id:350088',2508800.00,0.00,0.00,5120.00,0.00,'2022-02-03 14:09:43','',''),(2631784,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350089',2739100.00,0.00,0.00,5590.00,0.00,'2022-02-03 14:15:50','',''),(2631785,'1','158','780',335,'Distributed to U I DANDADA for sales id:350090',2601900.00,0.00,0.00,5310.00,0.00,'2022-02-03 14:16:03','',''),(2631786,'1','158','780',335,'Distributed to KARU PLANT for sales id:350091',1029000.00,0.00,0.00,2100.00,0.00,'2022-02-03 14:16:16','',''),(2631787,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350092',196000.00,0.00,0.00,400.00,0.00,'2022-02-03 14:18:16','',''),(2631788,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12308800.00,25120.00,0.00,0.00,'2022-02-03 14:19:30','',''),(2631789,'1','158',NULL,335,'Reception corrector for bridging 132500',0.00,0.00,0.00,25120.00,0.00,'2022-02-03 14:20:52','',''),(2631790,'1','158','781',335,'Received from bridging 132500',0.00,0.00,25120.00,0.00,0.00,'2022-02-03 14:20:52','',''),(2631791,'1','158','781',335,'Distributed to KARU PLANT for sales id:350091',4900.00,0.00,0.00,10.00,0.00,'2022-02-03 15:02:08','',''),(2631792,'1','158','781',335,'Distributed to KARU PLANT for sales id:350093',1396500.00,0.00,0.00,2850.00,0.00,'2022-02-03 15:15:22','',''),(2631793,'1','158','781',335,'Distributed to KUJE for sales id:350094',2846900.00,0.00,0.00,5810.00,0.00,'2022-02-03 15:15:36','',''),(2631794,'1','158','781',335,'Distributed to U I DANDADA for sales id:350095',2895900.00,0.00,0.00,5910.00,0.00,'2022-02-03 15:15:50','',''),(2631795,'1','158','781',335,'Distributed to NYANYA for sales id:350096',2337300.00,0.00,0.00,4770.00,0.00,'2022-02-03 15:21:15','',''),(2631796,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350097',2499000.00,0.00,0.00,5100.00,0.00,'2022-02-03 15:21:30','',''),(2631797,'1','158','781',335,'Distributed to APO for sales id:350098',240100.00,0.00,0.00,490.00,0.00,'2022-02-03 15:21:43','',''),(2631798,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350099',88200.00,0.00,0.00,180.00,0.00,'2022-02-03 15:23:18','',''),(2631799,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12210800.00,24920.00,0.00,0.00,'2022-02-04 11:40:18','',''),(2631800,'1','158',NULL,335,'Reception corrector for bridging 132501',0.00,0.00,0.00,24920.00,0.00,'2022-02-04 11:41:38','',''),(2631801,'1','158','781',335,'Received from bridging 132501',0.00,0.00,24920.00,0.00,0.00,'2022-02-04 11:41:38','',''),(2631802,'1','158','781',335,'Distributed to APO for sales id:350100',2332400.00,0.00,0.00,4760.00,0.00,'2022-02-04 11:48:58','',''),(2631803,'1','158','781',335,'Distributed to JABI for sales id:350103',2538200.00,0.00,0.00,5180.00,0.00,'2022-02-04 11:49:16','',''),(2631804,'1','158','781',335,'Distributed to KARU PLANT for sales id:350102',2538200.00,0.00,0.00,5180.00,0.00,'2022-02-04 11:49:35','',''),(2631805,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350101',2577400.00,0.00,0.00,5260.00,0.00,'2022-02-04 11:49:54','',''),(2631806,'1','158','781',335,'Distributed to KEFFI for sales id:350104',2224600.00,0.00,0.00,4540.00,0.00,'2022-02-04 11:52:29','',''),(2631807,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12176500.00,24850.00,0.00,0.00,'2022-02-05 08:18:05','',''),(2631808,'1','158',NULL,335,'Reception corrector for bridging 132502',0.00,0.00,0.00,24850.00,0.00,'2022-02-05 08:19:26','',''),(2631809,'1','158','780',335,'Received from bridging 132502',0.00,0.00,24850.00,0.00,0.00,'2022-02-05 08:19:26','',''),(2631810,'1','158','780',335,'Distributed to KEFFI for sales id:350105',671300.00,0.00,0.00,1370.00,0.00,'2022-02-05 08:40:11','',''),(2631811,'1','158','780',335,'Distributed to APO for sales id:350106',2641100.00,0.00,0.00,5390.00,0.00,'2022-02-05 08:40:39','',''),(2631812,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350107',2366700.00,0.00,0.00,4830.00,0.00,'2022-02-05 08:41:01','',''),(2631813,'1','158','780',335,'Distributed to CITY GATE for sales id:350108',2611700.00,0.00,0.00,5330.00,0.00,'2022-02-05 08:41:20','',''),(2631814,'1','158','780',335,'Distributed to KARU PLANT for sales id:350109',2562700.00,0.00,0.00,5230.00,0.00,'2022-02-05 08:41:39','',''),(2631815,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350110',1180900.00,0.00,0.00,2410.00,0.00,'2022-02-05 08:41:58','',''),(2631816,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350111',142100.00,0.00,0.00,290.00,0.00,'2022-02-05 08:43:50','',''),(2631817,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12250000.00,25000.00,0.00,0.00,'2022-02-05 15:54:38','',''),(2631818,'1','158',NULL,335,'Reception corrector for bridging 132503',0.00,0.00,0.00,25000.00,0.00,'2022-02-05 15:56:00','',''),(2631819,'1','158','780',335,'Received from bridging 132503',0.00,0.00,25000.00,0.00,0.00,'2022-02-05 15:56:00','',''),(2631820,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350112',1288700.00,0.00,0.00,2630.00,0.00,'2022-02-05 16:00:42','',''),(2631821,'1','158','780',335,'Distributed to NYANYA for sales id:350114',2709700.00,0.00,0.00,5530.00,0.00,'2022-02-05 16:08:28','',''),(2631822,'1','158','780',335,'Distributed to KUJE for sales id:350113',2621500.00,0.00,0.00,5350.00,0.00,'2022-02-05 16:08:51','',''),(2631823,'1','158','780',335,'Distributed to JEFF GAS for sales id:350115',4615800.00,0.00,0.00,9420.00,0.00,'2022-02-05 16:09:15','',''),(2631824,'1','158','780',335,'Distributed to KARU PLANT for sales id:350116',1014300.00,0.00,0.00,2070.00,0.00,'2022-02-05 16:09:36','',''),(2631825,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12235300.00,24970.00,0.00,0.00,'2022-02-07 18:01:10','',''),(2631826,'1','158',NULL,335,'Reception corrector for bridging 132504',0.00,0.00,0.00,24970.00,0.00,'2022-02-07 18:02:35','',''),(2631827,'1','158','781',335,'Received from bridging 132504',0.00,0.00,24970.00,0.00,0.00,'2022-02-07 18:02:35','',''),(2631828,'1','158','781',335,'Distributed to KARU PLANT for sales id:350117',1327900.00,0.00,0.00,2710.00,0.00,'2022-02-07 18:13:50','',''),(2631829,'1','158','781',335,'Distributed to U I DANDADA for sales id:350118',2572500.00,0.00,0.00,5250.00,0.00,'2022-02-07 18:14:11','',''),(2631830,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350119',2538200.00,0.00,0.00,5180.00,0.00,'2022-02-07 18:14:29','',''),(2631831,'1','158','781',335,'Distributed to APO for sales id:350120',2450000.00,0.00,0.00,5000.00,0.00,'2022-02-07 18:14:46','',''),(2631832,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350121',2597000.00,0.00,0.00,5300.00,0.00,'2022-02-07 18:18:46','',''),(2631833,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350122',720300.00,0.00,0.00,1470.00,0.00,'2022-02-07 18:19:04','',''),(2631834,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350123',29400.00,0.00,0.00,60.00,0.00,'2022-02-07 18:20:45','',''),(2631835,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12191200.00,24880.00,0.00,0.00,'2022-02-07 18:22:13','',''),(2631836,'1','158',NULL,335,'Reception corrector for bridging 132505',0.00,0.00,0.00,24880.00,0.00,'2022-02-07 18:23:37','',''),(2631837,'1','158','781',335,'Received from bridging 132505',0.00,0.00,24880.00,0.00,0.00,'2022-02-07 18:23:37','',''),(2631838,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350124',1636600.00,0.00,0.00,3340.00,0.00,'2022-02-07 18:32:04','',''),(2631839,'1','158','781',335,'Distributed to KARU PLANT for sales id:350125',2445100.00,0.00,0.00,4990.00,0.00,'2022-02-07 18:32:22','',''),(2631840,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350126',2680300.00,0.00,0.00,5470.00,0.00,'2022-02-07 18:32:41','',''),(2631841,'1','158','781',335,'Distributed to JABI for sales id:350127',2616600.00,0.00,0.00,5340.00,0.00,'2022-02-07 18:33:01','',''),(2631842,'1','158','781',335,'Distributed to NYANYA for sales id:350128',2484300.00,0.00,0.00,5070.00,0.00,'2022-02-07 18:33:19','',''),(2631843,'1','158','781',335,'Distributed to CITY GATE for sales id:350129',264600.00,0.00,0.00,540.00,0.00,'2022-02-07 18:33:39','',''),(2631844,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350130',63700.00,0.00,0.00,130.00,0.00,'2022-02-07 18:35:39','',''),(2631845,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12274500.00,25050.00,0.00,0.00,'2022-02-08 13:00:59','',''),(2631846,'1','158',NULL,335,'Reception corrector for bridging 132506',0.00,0.00,0.00,25050.00,0.00,'2022-02-08 13:02:30','',''),(2631847,'1','158','780',335,'Received from bridging 132506',0.00,0.00,25050.00,0.00,0.00,'2022-02-08 13:02:30','',''),(2631848,'1','158','780',335,'Distributed to CITY GATE for sales id:350131',2185400.00,0.00,0.00,4460.00,0.00,'2022-02-08 13:04:25','',''),(2631849,'1','158','780',335,'Distributed to KUJE for sales id:350132',2621500.00,0.00,0.00,5350.00,0.00,'2022-02-08 13:16:50','',''),(2631850,'1','158','780',335,'Distributed to APO for sales id:350133',2528400.00,0.00,0.00,5160.00,0.00,'2022-02-08 13:17:09','',''),(2631851,'1','158','780',335,'Distributed to KARU PLANT for sales id:350134',2499000.00,0.00,0.00,5100.00,0.00,'2022-02-08 13:17:26','',''),(2631852,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350135',1396500.00,0.00,0.00,2850.00,0.00,'2022-02-08 13:17:43','',''),(2631853,'1','158','780',335,'Distributed to KEFFI for sales id:350136',926100.00,0.00,0.00,1890.00,0.00,'2022-02-08 13:18:25','',''),(2631854,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350137',117600.00,0.00,0.00,240.00,0.00,'2022-02-08 13:20:45','',''),(2631855,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,9961700.00,20330.00,0.00,0.00,'2022-02-09 08:19:01','',''),(2631856,'1','158',NULL,335,'Reception corrector for bridging 132507',0.00,0.00,0.00,20330.00,0.00,'2022-02-09 08:21:20','',''),(2631857,'1','158','780',335,'Received from bridging 132507',0.00,0.00,20330.00,0.00,0.00,'2022-02-09 08:21:20','',''),(2631858,'1','158','780',335,'Distributed to KEFFI for sales id:350138',1421000.00,0.00,0.00,2900.00,0.00,'2022-02-09 08:26:52','',''),(2631859,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350139',2410800.00,0.00,0.00,4920.00,0.00,'2022-02-09 08:27:12','',''),(2631860,'1','158','780',335,'Distributed to U I DANDADA for sales id:350140',2494100.00,0.00,0.00,5090.00,0.00,'2022-02-09 08:27:30','',''),(2631861,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350141',2773400.00,0.00,0.00,5660.00,0.00,'2022-02-09 08:32:08','',''),(2631862,'1','158','780',335,'Distributed to APO for sales id:350142',573300.00,0.00,0.00,1170.00,0.00,'2022-02-09 08:32:27','',''),(2631863,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350143',289100.00,0.00,0.00,590.00,0.00,'2022-02-09 08:34:31','',''),(2631864,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12230400.00,24960.00,0.00,0.00,'2022-02-09 16:44:05','',''),(2631865,'1','158',NULL,335,'Reception corrector for bridging 132508',0.00,0.00,0.00,24960.00,0.00,'2022-02-09 16:45:36','',''),(2631866,'1','158','781',335,'Received from bridging 132508',0.00,0.00,24960.00,0.00,0.00,'2022-02-09 16:45:36','',''),(2631867,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350145',2268700.00,0.00,0.00,4630.00,0.00,'2022-02-09 16:53:30','',''),(2631868,'1','158','781',335,'Distributed to APO for sales id:350144',1901200.00,0.00,0.00,3880.00,0.00,'2022-02-09 16:53:58','',''),(2631869,'1','158','781',335,'Distributed to KARU PLANT for sales id:350146',2528400.00,0.00,0.00,5160.00,0.00,'2022-02-09 16:54:22','',''),(2631870,'1','158','781',335,'Distributed to EDEMA GAS for sales id:350147',2822400.00,0.00,0.00,5760.00,0.00,'2022-02-09 16:55:51','',''),(2631871,'1','158','781',335,'Distributed to SUNSHINE GAS for sales id:350148',2499000.00,0.00,0.00,5100.00,0.00,'2022-02-09 16:56:24','',''),(2631872,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350149',210700.00,0.00,0.00,430.00,0.00,'2022-02-09 16:58:22','',''),(2631873,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12176500.00,24850.00,0.00,0.00,'2022-02-10 12:07:44','',''),(2631874,'1','158',NULL,335,'Reception corrector for bridging 132509',0.00,0.00,0.00,24850.00,0.00,'2022-02-10 12:09:57','',''),(2631875,'1','158','781',335,'Received from bridging 132509',0.00,0.00,24850.00,0.00,0.00,'2022-02-10 12:09:57','',''),(2631876,'1','158','781',335,'Distributed to KATAMFE for sales id:350150',2616600.00,0.00,0.00,5340.00,0.00,'2022-02-10 12:23:42','',''),(2631877,'1','158','781',335,'Distributed to NYANYA for sales id:350151',2156000.00,0.00,0.00,4400.00,0.00,'2022-02-10 12:24:02','',''),(2631878,'1','158','781',335,'Distributed to KARU PLANT for sales id:350152',2695000.00,0.00,0.00,5500.00,0.00,'2022-02-10 12:24:19','',''),(2631879,'1','158','781',335,'Distributed to CITY GATE for sales id:350153',2489200.00,0.00,0.00,5080.00,0.00,'2022-02-10 12:24:34','',''),(2631880,'1','158','781',335,'Distributed to JABI for sales id:350154',2131500.00,0.00,0.00,4350.00,0.00,'2022-02-10 12:24:50','',''),(2631881,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350155',88200.00,0.00,0.00,180.00,0.00,'2022-02-10 12:27:06','',''),(2631882,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12274500.00,25050.00,0.00,0.00,'2022-02-10 14:29:18','',''),(2631883,'1','158',NULL,335,'Reception corrector for bridging 132510',0.00,0.00,0.00,25050.00,0.00,'2022-02-10 14:30:38','',''),(2631884,'1','158','780',335,'Received from bridging 132510',0.00,0.00,25050.00,0.00,0.00,'2022-02-10 14:30:38','',''),(2631885,'1','158','780',335,'Distributed to JABI for sales id:350156',494900.00,0.00,0.00,1010.00,0.00,'2022-02-10 14:34:17','',''),(2631886,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350157',2386300.00,0.00,0.00,4870.00,0.00,'2022-02-10 14:34:36','',''),(2631887,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350158',2435300.00,0.00,0.00,4970.00,0.00,'2022-02-10 15:16:55','',''),(2631888,'1','158','780',335,'Distributed to KUJE for sales id:350159',2508800.00,0.00,0.00,5120.00,0.00,'2022-02-10 15:17:12','',''),(2631889,'1','158','780',335,'Distributed to U I DANDADA for sales id:350160',2582300.00,0.00,0.00,5270.00,0.00,'2022-02-10 15:17:29','',''),(2631890,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350161',1680700.00,0.00,0.00,3430.00,0.00,'2022-02-10 15:17:45','',''),(2631891,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350162',186200.00,0.00,0.00,380.00,0.00,'2022-02-10 15:19:20','',''),(2631892,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12730200.00,25980.00,0.00,0.00,'2022-02-16 12:39:44','',''),(2631893,'1','158',NULL,335,'Reception corrector for bridging 132511',0.00,0.00,0.00,25980.00,0.00,'2022-02-16 12:41:23','',''),(2631894,'1','158','780',335,'Received from bridging 132511',0.00,0.00,25980.00,0.00,0.00,'2022-02-16 12:41:23','',''),(2631895,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350163',641900.00,0.00,0.00,1310.00,0.00,'2022-02-16 12:43:42','',''),(2631896,'1','158','780',335,'Distributed to KATAMFE for sales id:350164',2405900.00,0.00,0.00,4910.00,0.00,'2022-02-16 12:48:12','',''),(2631897,'1','158','780',335,'Distributed to KARU PLANT for sales id:350165',2577400.00,0.00,0.00,5260.00,0.00,'2022-02-16 12:48:31','',''),(2631898,'1','158','780',335,'Distributed to APO for sales id:350166',2518600.00,0.00,0.00,5140.00,0.00,'2022-02-16 12:48:49','',''),(2631899,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350167',2038400.00,0.00,0.00,4160.00,0.00,'2022-02-16 12:53:07','',''),(2631900,'1','158','780',335,'Distributed to KEFFI for sales id:350168',2474500.00,0.00,0.00,5050.00,0.00,'2022-02-16 12:53:24','',''),(2631901,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350169',73500.00,0.00,0.00,150.00,0.00,'2022-02-16 12:55:03','',''),(2631902,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12186300.00,24870.00,0.00,0.00,'2022-02-16 12:56:55','',''),(2631903,'1','158',NULL,335,'Reception corrector for bridging 132512',0.00,0.00,0.00,24870.00,0.00,'2022-02-16 12:58:48','',''),(2631904,'1','158','781',335,'Received from bridging 132512',0.00,0.00,24870.00,0.00,0.00,'2022-02-16 12:58:48','',''),(2631905,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350170',2513700.00,0.00,0.00,5130.00,0.00,'2022-02-16 13:05:50','',''),(2631906,'1','158','781',335,'Distributed to NYANYA for sales id:350171',2474500.00,0.00,0.00,5050.00,0.00,'2022-02-16 13:06:10','',''),(2631907,'1','158','781',335,'Distributed to JEFF GAS for sales id:350172',4468800.00,0.00,0.00,9120.00,0.00,'2022-02-16 13:06:28','',''),(2631908,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350173',2572500.00,0.00,0.00,5250.00,0.00,'2022-02-16 13:06:47','',''),(2631909,'1','158','781',335,'Distributed to KARU PLANT for sales id:350174',142100.00,0.00,0.00,290.00,0.00,'2022-02-16 13:10:35','',''),(2631910,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350175',14700.00,0.00,0.00,30.00,0.00,'2022-02-16 13:12:30','',''),(2631911,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,9863700.00,20130.00,0.00,0.00,'2022-02-16 20:21:57','',''),(2631912,'1','158',NULL,335,'Reception corrector for bridging 132513',0.00,0.00,0.00,20130.00,0.00,'2022-02-16 20:23:29','',''),(2631913,'1','158','780',335,'Received from bridging 132513',0.00,0.00,20130.00,0.00,0.00,'2022-02-16 20:23:29','',''),(2631914,'1','158','780',335,'Distributed to KARU PLANT for sales id:350176',2587200.00,0.00,0.00,5280.00,0.00,'2022-02-16 20:32:08','',''),(2631915,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350177',2503900.00,0.00,0.00,5110.00,0.00,'2022-02-16 20:32:27','',''),(2631916,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350179',2513700.00,0.00,0.00,5130.00,0.00,'2022-02-16 20:32:47','',''),(2631917,'1','158','780',335,'Distributed to CITY GATE for sales id:350180',2131500.00,0.00,0.00,4350.00,0.00,'2022-02-16 20:33:23','',''),(2631918,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350181',127400.00,0.00,0.00,260.00,0.00,'2022-02-16 20:36:00','',''),(2631919,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12068700.00,24630.00,0.00,0.00,'2022-02-16 20:46:25','',''),(2631920,'1','158',NULL,335,'Reception corrector for bridging 132514',0.00,0.00,0.00,24630.00,0.00,'2022-02-16 20:48:29','',''),(2631921,'1','158','781',335,'Received from bridging 132514',0.00,0.00,24630.00,0.00,0.00,'2022-02-16 20:48:29','',''),(2631922,'1','158','781',335,'Distributed to CITY GATE for sales id:350182',210700.00,0.00,0.00,430.00,0.00,'2022-02-16 20:52:56','',''),(2631923,'1','158','781',335,'Distributed to APO for sales id:350183',2396100.00,0.00,0.00,4890.00,0.00,'2022-02-16 20:53:17','',''),(2631924,'1','158','781',335,'Distributed to KARU PLANT for sales id:350186',2513700.00,0.00,0.00,5130.00,0.00,'2022-02-16 21:05:45','',''),(2631925,'1','158','781',335,'Distributed to JABI for sales id:350187',2062900.00,0.00,0.00,4210.00,0.00,'2022-02-16 21:06:26','',''),(2631926,'1','158','781',335,'Distributed to KUJE for sales id:350188',2714600.00,0.00,0.00,5540.00,0.00,'2022-02-16 21:07:13','',''),(2631927,'1','158','781',335,'Distributed to NYANYA for sales id:350189',2170700.00,0.00,0.00,4430.00,0.00,'2022-02-16 21:07:58','',''),(2631928,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12181400.00,24860.00,0.00,0.00,'2022-02-17 15:29:53','',''),(2631929,'1','158',NULL,335,'Reception corrector for bridging 132515',0.00,0.00,0.00,24860.00,0.00,'2022-02-17 15:31:11','',''),(2631930,'1','158','780',335,'Received from bridging 132515',0.00,0.00,24860.00,0.00,0.00,'2022-02-17 15:31:11','',''),(2631931,'1','158','780',335,'Distributed to NYANYA for sales id:350190',352800.00,0.00,0.00,720.00,0.00,'2022-02-17 15:34:09','',''),(2631932,'1','158','780',335,'Distributed to APO for sales id:350191',2484300.00,0.00,0.00,5070.00,0.00,'2022-02-17 15:42:47','',''),(2631933,'1','158','780',335,'Distributed to SUNSHINE GAS for sales id:350192',2479400.00,0.00,0.00,5060.00,0.00,'2022-02-17 15:43:04','',''),(2631934,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350193',1764000.00,0.00,0.00,3600.00,0.00,'2022-02-17 15:43:20','',''),(2631935,'1','158','780',335,'Distributed to KARU PLANT for sales id:350194',2572500.00,0.00,0.00,5250.00,0.00,'2022-02-17 15:43:37','',''),(2631936,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350195',2494100.00,0.00,0.00,5090.00,0.00,'2022-02-17 15:46:26','',''),(2631937,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350196',34300.00,0.00,0.00,70.00,0.00,'2022-02-17 21:39:13','',''),(2631938,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12436200.00,25380.00,0.00,0.00,'2022-02-17 21:45:51','',''),(2631939,'1','158',NULL,335,'Reception corrector for bridging 132516',0.00,0.00,0.00,25380.00,0.00,'2022-02-17 21:48:48','',''),(2631940,'1','158','780',335,'Received from bridging 132516',0.00,0.00,25380.00,0.00,0.00,'2022-02-17 21:48:48','',''),(2631941,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350197',137200.00,0.00,0.00,280.00,0.00,'2022-02-17 22:02:23','',''),(2631942,'1','158','780',335,'Distributed to CITY GATE for sales id:350198',2273600.00,0.00,0.00,4640.00,0.00,'2022-02-17 22:03:15','',''),(2631943,'1','158','780',335,'Distributed to JABI for sales id:350199',2660700.00,0.00,0.00,5430.00,0.00,'2022-02-17 22:03:36','',''),(2631944,'1','158','780',335,'Distributed to APO for sales id:350200',2513700.00,0.00,0.00,5130.00,0.00,'2022-02-17 22:03:56','',''),(2631945,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350201',1974700.00,0.00,0.00,4030.00,0.00,'2022-02-17 22:04:17','',''),(2631946,'1','158','780',335,'Distributed to KATAMFE for sales id:350202',2734200.00,0.00,0.00,5580.00,0.00,'2022-02-17 22:04:39','',''),(2631947,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350203',142100.00,0.00,0.00,290.00,0.00,'2022-02-17 22:11:31','',''),(2631948,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12181400.00,24860.00,0.00,0.00,'2022-02-17 22:14:43','',''),(2631949,'1','158',NULL,335,'Reception corrector for bridging 132517',0.00,0.00,0.00,24860.00,0.00,'2022-02-17 22:16:03','',''),(2631950,'1','158','781',335,'Received from bridging 132517',0.00,0.00,24860.00,0.00,0.00,'2022-02-17 22:16:03','',''),(2631951,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350204',2430400.00,0.00,0.00,4960.00,0.00,'2022-02-17 22:29:12','',''),(2631952,'1','158','781',335,'Distributed to KARU PLANT for sales id:350205',2636200.00,0.00,0.00,5380.00,0.00,'2022-02-17 22:29:34','',''),(2631953,'1','158','781',335,'Distributed to KEFFI for sales id:350206',2567600.00,0.00,0.00,5240.00,0.00,'2022-02-17 22:29:53','',''),(2631954,'1','158','781',335,'Distributed to EDEMA GAS for sales id:350207',2797900.00,0.00,0.00,5710.00,0.00,'2022-02-17 22:30:22','',''),(2631955,'1','158','781',335,'Distributed to NIP WEST GAS for sales id:350208',1656200.00,0.00,0.00,3380.00,0.00,'2022-02-17 22:33:57','',''),(2631956,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350209',93100.00,0.00,0.00,190.00,0.00,'2022-02-17 22:37:01','',''),(2631957,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12289200.00,25080.00,0.00,0.00,'2022-02-18 11:07:30','',''),(2631958,'1','158',NULL,335,'Reception corrector for bridging 132518',0.00,0.00,0.00,25080.00,0.00,'2022-02-18 11:09:26','',''),(2631959,'1','158','780',335,'Received from bridging 132518',0.00,0.00,25080.00,0.00,0.00,'2022-02-18 11:09:26','',''),(2631960,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:350210',1352400.00,0.00,0.00,2760.00,0.00,'2022-02-18 11:21:57','',''),(2631961,'1','158','780',335,'Distributed to NYANYA for sales id:350211',2469600.00,0.00,0.00,5040.00,0.00,'2022-02-18 11:22:21','',''),(2631962,'1','158','780',335,'Distributed to KATAMFE for sales id:350212',2670500.00,0.00,0.00,5450.00,0.00,'2022-02-18 11:22:39','',''),(2631963,'1','158','780',335,'Distributed to APO for sales id:350213',2611700.00,0.00,0.00,5330.00,0.00,'2022-02-18 11:23:00','',''),(2631964,'1','158','780',335,'Distributed to KUJE for sales id:350214',651700.00,0.00,0.00,1330.00,0.00,'2022-02-18 11:23:19','',''),(2631965,'1','158','780',335,'Distributed to KARU PLANT for sales id:350215',2533300.00,0.00,0.00,5170.00,0.00,'2022-02-18 11:26:09','',''),(2631966,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12259800.00,25020.00,0.00,0.00,'2022-02-21 14:02:02','',''),(2631967,'1','158',NULL,335,'Reception corrector for bridging 132519',0.00,0.00,0.00,25020.00,0.00,'2022-02-21 14:03:23','',''),(2631968,'1','158','781',335,'Received from bridging 132519',0.00,0.00,25020.00,0.00,0.00,'2022-02-21 14:03:23','',''),(2631969,'1','158','781',335,'Distributed to KUJE for sales id:350216',1896300.00,0.00,0.00,3870.00,0.00,'2022-02-21 14:08:58','',''),(2631970,'1','158','781',335,'Distributed to KATAMFE for sales id:350217',2601900.00,0.00,0.00,5310.00,0.00,'2022-02-21 14:09:17','',''),(2631971,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350218',2641100.00,0.00,0.00,5390.00,0.00,'2022-02-21 14:09:40','',''),(2631972,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350219',2601900.00,0.00,0.00,5310.00,0.00,'2022-02-21 14:14:47','',''),(2631973,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350220',2508800.00,0.00,0.00,5120.00,0.00,'2022-02-21 14:15:04','',''),(2631974,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12201000.00,24900.00,0.00,0.00,'2022-02-21 14:18:34','',''),(2631975,'1','158',NULL,335,'Reception corrector for bridging 132520',0.00,0.00,0.00,24900.00,0.00,'2022-02-21 14:19:50','',''),(2631976,'1','158','780',335,'Received from bridging 132520',0.00,0.00,24900.00,0.00,0.00,'2022-02-21 14:19:50','',''),(2631977,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350221',137200.00,0.00,0.00,280.00,0.00,'2022-02-21 14:30:04','',''),(2631978,'1','158','780',335,'Distributed to KARU PLANT for sales id:350222',2479400.00,0.00,0.00,5060.00,0.00,'2022-02-21 14:30:26','',''),(2631979,'1','158','780',335,'Distributed to JABI for sales id:350223',2611700.00,0.00,0.00,5330.00,0.00,'2022-02-21 14:30:50','',''),(2631980,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350224',2611700.00,0.00,0.00,5330.00,0.00,'2022-02-21 14:31:08','',''),(2631981,'1','158','780',335,'Distributed to KATAMFE for sales id:350225',2503900.00,0.00,0.00,5110.00,0.00,'2022-02-21 14:31:28','',''),(2631982,'1','158','780',335,'Distributed to APO for sales id:350226',1857100.00,0.00,0.00,3790.00,0.00,'2022-02-21 14:31:57','',''),(2631983,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350227',9800.00,0.00,0.00,20.00,0.00,'2022-02-21 14:34:29','',''),(2631984,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12201000.00,24900.00,0.00,0.00,'2022-02-21 14:36:52','',''),(2631985,'1','158',NULL,335,'Reception corrector for bridging 132521',0.00,0.00,0.00,24900.00,0.00,'2022-02-21 14:38:04','',''),(2631986,'1','158','780',335,'Received from bridging 132521',0.00,0.00,24900.00,0.00,0.00,'2022-02-21 14:38:04','',''),(2631987,'1','158','780',335,'Distributed to APO for sales id:350228',602700.00,0.00,0.00,1230.00,0.00,'2022-02-21 14:43:26','',''),(2631988,'1','158','780',335,'Distributed to CITY GATE for sales id:350229',2352000.00,0.00,0.00,4800.00,0.00,'2022-02-21 14:43:50','',''),(2631989,'1','158','780',335,'Distributed to NYANYA for sales id:350230',2533300.00,0.00,0.00,5170.00,0.00,'2022-02-21 14:52:34','',''),(2631990,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:350231',3768100.00,0.00,0.00,7690.00,0.00,'2022-02-21 14:52:53','',''),(2631991,'1','158','780',335,'Distributed to AMITEX GAS for sales id:350232',2195200.00,0.00,0.00,4480.00,0.00,'2022-02-21 14:53:13','',''),(2631992,'1','158','780',335,'Distributed to KATAMFE for sales id:350233',676200.00,0.00,0.00,1380.00,0.00,'2022-02-21 14:53:32','',''),(2631993,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350234',73500.00,0.00,0.00,150.00,0.00,'2022-02-21 14:55:27','',''),(2631994,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12269600.00,25040.00,0.00,0.00,'2022-02-21 14:57:07','',''),(2631995,'1','158',NULL,335,'Reception corrector for bridging 132522',0.00,0.00,0.00,25040.00,0.00,'2022-02-21 14:58:24','',''),(2631996,'1','158','781',335,'Received from bridging 132522',0.00,0.00,25040.00,0.00,0.00,'2022-02-21 14:58:24','',''),(2631997,'1','158','781',335,'Distributed to KATAMFE for sales id:350235',1960000.00,0.00,0.00,4000.00,0.00,'2022-02-21 15:08:41','',''),(2631998,'1','158','781',335,'Distributed to KARU PLANT for sales id:350236',2655800.00,0.00,0.00,5420.00,0.00,'2022-02-21 15:09:02','',''),(2631999,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350237',2670500.00,0.00,0.00,5450.00,0.00,'2022-02-21 15:09:20','',''),(2632000,'1','158','781',335,'Distributed to MAXPRIME GAS for sales id:350238',1210300.00,0.00,0.00,2470.00,0.00,'2022-02-21 15:09:39','',''),(2632001,'1','158','781',335,'Distributed to APO for sales id:350239',2626400.00,0.00,0.00,5360.00,0.00,'2022-02-21 15:09:59','',''),(2632002,'1','158','781',335,'Distributed to KATAMFE for sales id:350240',1146600.00,0.00,0.00,2340.00,0.00,'2022-02-21 15:12:58','',''),(2632003,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12259800.00,25020.00,0.00,0.00,'2022-02-21 15:53:57','',''),(2632004,'1','158',NULL,335,'Reception corrector for bridging 132523',0.00,0.00,0.00,25020.00,0.00,'2022-02-21 15:55:08','',''),(2632005,'1','158','780',335,'Received from bridging 132523',0.00,0.00,25020.00,0.00,0.00,'2022-02-21 15:55:08','',''),(2632006,'1','158','780',335,'Distributed to KATAMFE for sales id:350241',1528800.00,0.00,0.00,3120.00,0.00,'2022-02-21 16:03:53','',''),(2632007,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350242',2499000.00,0.00,0.00,5100.00,0.00,'2022-02-21 16:04:22','',''),(2632008,'1','158','780',335,'Distributed to KUJE for sales id:350243',2626400.00,0.00,0.00,5360.00,0.00,'2022-02-21 16:04:45','',''),(2632009,'1','158','780',335,'Distributed to KARU PLANT for sales id:350244',2523500.00,0.00,0.00,5150.00,0.00,'2022-02-21 16:05:04','',''),(2632010,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350245',2548000.00,0.00,0.00,5200.00,0.00,'2022-02-21 16:05:26','',''),(2632011,'1','158','780',335,'Distributed to APO for sales id:350246',534100.00,0.00,0.00,1090.00,0.00,'2022-02-21 16:08:15','',''),(2632012,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12220600.00,24940.00,0.00,0.00,'2022-02-21 18:09:36','',''),(2632013,'1','158',NULL,335,'Reception corrector for bridging 132524',0.00,0.00,0.00,24940.00,0.00,'2022-02-21 18:10:50','',''),(2632014,'1','158','780',335,'Received from bridging 132524',0.00,0.00,24940.00,0.00,0.00,'2022-02-21 18:10:50','',''),(2632015,'1','158','780',335,'Distributed to APO for sales id:350247',2160900.00,0.00,0.00,4410.00,0.00,'2022-02-21 18:33:06','',''),(2632016,'1','158','780',335,'Distributed to JEFF GAS for sales id:350248',4625600.00,0.00,0.00,9440.00,0.00,'2022-02-21 18:33:25','',''),(2632017,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350249',2312800.00,0.00,0.00,4720.00,0.00,'2022-02-21 18:33:46','',''),(2632018,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350250',2077600.00,0.00,0.00,4240.00,0.00,'2022-02-21 18:34:07','',''),(2632019,'1','158','780',335,'Distributed to JABI for sales id:350251',847700.00,0.00,0.00,1730.00,0.00,'2022-02-21 18:34:26','',''),(2632020,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350252',196000.00,0.00,0.00,400.00,0.00,'2022-02-21 18:36:06','',''),(2632021,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12156900.00,24810.00,0.00,0.00,'2022-02-22 12:47:45','',''),(2632022,'1','158',NULL,335,'Reception corrector for bridging 132525',0.00,0.00,0.00,24810.00,0.00,'2022-02-22 12:49:00','',''),(2632023,'1','158','781',335,'Received from bridging 132525',0.00,0.00,24810.00,0.00,0.00,'2022-02-22 12:49:00','',''),(2632024,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350253',1715000.00,0.00,0.00,3500.00,0.00,'2022-02-22 12:58:50','',''),(2632025,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350254',2293200.00,0.00,0.00,4680.00,0.00,'2022-02-22 12:59:12','',''),(2632026,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350255',2111900.00,0.00,0.00,4310.00,0.00,'2022-02-22 12:59:29','',''),(2632027,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350256',2650900.00,0.00,0.00,5410.00,0.00,'2022-02-22 12:59:48','',''),(2632028,'1','158','781',335,'Distributed to KARU PLANT for sales id:350257',2567600.00,0.00,0.00,5240.00,0.00,'2022-02-22 13:00:08','',''),(2632029,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350258',788900.00,0.00,0.00,1610.00,0.00,'2022-02-22 13:02:43','',''),(2632030,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350259',29400.00,0.00,0.00,60.00,0.00,'2022-02-22 13:04:41','',''),(2632031,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12250000.00,25000.00,0.00,0.00,'2022-02-23 09:56:54','',''),(2632032,'1','158',NULL,335,'Reception corrector for bridging 132526',0.00,0.00,0.00,25000.00,0.00,'2022-02-23 09:58:13','',''),(2632033,'1','158','781',335,'Received from bridging 132526',0.00,0.00,25000.00,0.00,0.00,'2022-02-23 09:58:13','',''),(2632034,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350260',1592500.00,0.00,0.00,3250.00,0.00,'2022-02-23 10:07:21','',''),(2632035,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350261',2450000.00,0.00,0.00,5000.00,0.00,'2022-02-23 10:07:43','',''),(2632036,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350262',2503900.00,0.00,0.00,5110.00,0.00,'2022-02-23 10:08:03','',''),(2632037,'1','158','781',335,'Distributed to KEFFI LPG SKID for sales id:350263',2469600.00,0.00,0.00,5040.00,0.00,'2022-02-23 10:08:22','',''),(2632038,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350264',2474500.00,0.00,0.00,5050.00,0.00,'2022-02-23 10:08:40','',''),(2632039,'1','158','781',335,'Distributed to KARU PLANT for sales id:350265',690900.00,0.00,0.00,1410.00,0.00,'2022-02-23 10:08:59','',''),(2632040,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350266',68600.00,0.00,0.00,140.00,0.00,'2022-02-23 10:10:47','',''),(2632041,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12186300.00,24870.00,0.00,0.00,'2022-02-24 13:51:58','',''),(2632042,'1','158',NULL,335,'Reception corrector for bridging 132527',0.00,0.00,0.00,24870.00,0.00,'2022-02-24 13:53:20','',''),(2632043,'1','158','780',335,'Received from bridging 132527',0.00,0.00,24870.00,0.00,0.00,'2022-02-24 13:53:20','',''),(2632044,'1','158','780',335,'Distributed to KARU PLANT for sales id:350267',1881600.00,0.00,0.00,3840.00,0.00,'2022-02-24 14:15:27','',''),(2632045,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350268',2175600.00,0.00,0.00,4440.00,0.00,'2022-02-24 14:21:44','',''),(2632046,'1','158','780',335,'Distributed to U I DANDADA for sales id:350269',2758700.00,0.00,0.00,5630.00,0.00,'2022-02-24 14:22:03','',''),(2632047,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350270',2557800.00,0.00,0.00,5220.00,0.00,'2022-02-24 14:22:31','',''),(2632048,'1','158','780',335,'Distributed to KARU PLANT for sales id:350271',2538200.00,0.00,0.00,5180.00,0.00,'2022-02-24 14:28:28','',''),(2632049,'1','158','780',335,'Distributed to SUNSHINE GAS for sales id:350272',83300.00,0.00,0.00,170.00,0.00,'2022-02-24 14:29:14','',''),(2632050,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350273',191100.00,0.00,0.00,390.00,0.00,'2022-02-24 14:31:07','',''),(2632051,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12191200.00,24880.00,0.00,0.00,'2022-02-24 18:14:53','',''),(2632052,'1','158',NULL,335,'Reception corrector for bridging 132528',0.00,0.00,0.00,24880.00,0.00,'2022-02-24 18:16:39','',''),(2632053,'1','158','780',335,'Received from bridging 132528',0.00,0.00,24880.00,0.00,0.00,'2022-02-24 18:16:39','',''),(2632054,'1','158','780',335,'Distributed to SUNSHINE GAS for sales id:350274',2391200.00,0.00,0.00,4880.00,0.00,'2022-02-24 18:25:07','',''),(2632055,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350275',2655800.00,0.00,0.00,5420.00,0.00,'2022-02-24 18:25:29','',''),(2632056,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350276',2548000.00,0.00,0.00,5200.00,0.00,'2022-02-24 18:25:52','',''),(2632057,'1','158','780',335,'Distributed to EDEMA GAS for sales id:350277',2690100.00,0.00,0.00,5490.00,0.00,'2022-02-24 18:26:16','',''),(2632058,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350278',1866900.00,0.00,0.00,3810.00,0.00,'2022-02-24 18:26:43','',''),(2632059,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350279',39200.00,0.00,0.00,80.00,0.00,'2022-02-24 18:28:49','',''),(2632060,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12191200.00,24880.00,0.00,0.00,'2022-02-25 17:37:58','',''),(2632061,'1','158',NULL,335,'Reception corrector for bridging 132529',0.00,0.00,0.00,24880.00,0.00,'2022-02-25 17:39:13','',''),(2632062,'1','158','781',335,'Received from bridging 132529',0.00,0.00,24880.00,0.00,0.00,'2022-02-25 17:39:13','',''),(2632063,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350280',700700.00,0.00,0.00,1430.00,0.00,'2022-02-25 17:44:07','',''),(2632064,'1','158','781',335,'Distributed to U I DANDADA for sales id:350281',2675400.00,0.00,0.00,5460.00,0.00,'2022-02-25 17:44:27','',''),(2632065,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350282',2538200.00,0.00,0.00,5180.00,0.00,'2022-02-25 17:52:10','',''),(2632066,'1','158','781',335,'Distributed to KARU PLANT for sales id:350283',2484300.00,0.00,0.00,5070.00,0.00,'2022-02-25 17:52:33','',''),(2632067,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:350284',2376500.00,0.00,0.00,4850.00,0.00,'2022-02-25 17:52:53','',''),(2632068,'1','158','781',335,'Distributed to NIP WEST GAS for sales id:350285',1372000.00,0.00,0.00,2800.00,0.00,'2022-02-25 17:53:36','',''),(2632069,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350286',44100.00,0.00,0.00,90.00,0.00,'2022-02-25 17:55:37','',''),(2632070,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12156900.00,24810.00,0.00,0.00,'2022-02-26 14:25:10','',''),(2632071,'1','158',NULL,335,'Reception corrector for bridging 132530',0.00,0.00,0.00,24810.00,0.00,'2022-02-26 14:26:26','',''),(2632072,'1','158','781',335,'Received from bridging 132530',0.00,0.00,24810.00,0.00,0.00,'2022-02-26 14:26:26','',''),(2632073,'1','158','781',335,'Distributed to NIP WEST GAS for sales id:350287',2009000.00,0.00,0.00,4100.00,0.00,'2022-02-26 14:38:29','',''),(2632074,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350288',2503900.00,0.00,0.00,5110.00,0.00,'2022-02-26 14:38:47','',''),(2632075,'1','158','781',335,'Distributed to U I DANDADA for sales id:350289',3013500.00,0.00,0.00,6150.00,0.00,'2022-02-26 14:39:05','',''),(2632076,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350290',2249100.00,0.00,0.00,4590.00,0.00,'2022-02-26 14:42:51','',''),(2632077,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350291',2376500.00,0.00,0.00,4850.00,0.00,'2022-02-26 14:43:07','',''),(2632078,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350292',4900.00,0.00,0.00,10.00,0.00,'2022-02-26 14:44:51','',''),(2632079,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12196100.00,24890.00,0.00,0.00,'2022-02-27 09:48:22','',''),(2632080,'1','158',NULL,335,'Reception corrector for bridging 132531',0.00,0.00,0.00,24890.00,0.00,'2022-02-27 09:49:40','',''),(2632081,'1','158','780',335,'Received from bridging 132531',0.00,0.00,24890.00,0.00,0.00,'2022-02-27 09:49:40','',''),(2632082,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350293',210700.00,0.00,0.00,430.00,0.00,'2022-02-27 10:00:22','',''),(2632083,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350294',2621500.00,0.00,0.00,5350.00,0.00,'2022-02-27 10:00:43','',''),(2632084,'1','158','780',335,'Distributed to KARU PLANT for sales id:350295',2837100.00,0.00,0.00,5790.00,0.00,'2022-02-27 10:01:02','',''),(2632085,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350296',2254000.00,0.00,0.00,4600.00,0.00,'2022-02-27 10:01:21','',''),(2632086,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350297',2616600.00,0.00,0.00,5340.00,0.00,'2022-02-27 10:01:40','',''),(2632087,'1','158','780',335,'Distributed to JEFF GAS for sales id:350298',1558200.00,0.00,0.00,3180.00,0.00,'2022-02-27 10:04:13','',''),(2632088,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350299',98000.00,0.00,0.00,200.00,0.00,'2022-02-27 10:06:00','',''),(2632089,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12147100.00,24790.00,0.00,0.00,'2022-02-28 08:46:55','',''),(2632090,'1','158',NULL,335,'Reception corrector for bridging 132532',0.00,0.00,0.00,24790.00,0.00,'2022-02-28 08:48:19','',''),(2632091,'1','158','780',335,'Received from bridging 132532',0.00,0.00,24790.00,0.00,0.00,'2022-02-28 08:48:19','',''),(2632092,'1','158','780',335,'Distributed to JEFF GAS for sales id:350300',3047800.00,0.00,0.00,6220.00,0.00,'2022-02-28 08:55:56','',''),(2632093,'1','158','780',335,'Distributed to U I DANDADA for sales id:350301',2611700.00,0.00,0.00,5330.00,0.00,'2022-02-28 08:56:14','',''),(2632094,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350302',2376500.00,0.00,0.00,4850.00,0.00,'2022-02-28 08:56:34','',''),(2632095,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350303',2508800.00,0.00,0.00,5120.00,0.00,'2022-02-28 08:56:52','',''),(2632096,'1','158','780',335,'Distributed to KARU PLANT for sales id:350304',1445500.00,0.00,0.00,2950.00,0.00,'2022-02-28 08:57:11','',''),(2632097,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350305',156800.00,0.00,0.00,320.00,0.00,'2022-02-28 08:58:59','',''),(2632098,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12210800.00,24920.00,0.00,0.00,'2022-03-01 08:08:35','',''),(2632099,'1','158',NULL,335,'Reception corrector for bridging 132533',0.00,0.00,0.00,24920.00,0.00,'2022-03-01 08:10:14','',''),(2632100,'1','158','781',335,'Received from bridging 132533',0.00,0.00,24920.00,0.00,0.00,'2022-03-01 08:10:14','',''),(2632101,'1','158','781',335,'Distributed to KARU PLANT for sales id:350306',798700.00,0.00,0.00,1630.00,0.00,'2022-03-01 08:15:28','',''),(2632102,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350308',2557800.00,0.00,0.00,5220.00,0.00,'2022-03-01 08:15:45','',''),(2632103,'1','158','781',335,'Distributed to KEFFI LPG SKID for sales id:350309',2454900.00,0.00,0.00,5010.00,0.00,'2022-03-01 08:22:33','',''),(2632104,'1','158','781',335,'Distributed to U I DANDADA for sales id:350310',2587200.00,0.00,0.00,5280.00,0.00,'2022-03-01 08:22:53','',''),(2632105,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350311',2435300.00,0.00,0.00,4970.00,0.00,'2022-03-01 08:23:10','',''),(2632106,'1','158','781',335,'Distributed to KARU PLANT for sales id:350312',1376900.00,0.00,0.00,2810.00,0.00,'2022-03-01 08:23:30','',''),(2632107,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12220600.00,24940.00,0.00,0.00,'2022-03-02 08:27:29','',''),(2632108,'1','158',NULL,335,'Reception corrector for bridging 132534',0.00,0.00,0.00,24940.00,0.00,'2022-03-02 08:28:58','',''),(2632109,'1','158','781',335,'Received from bridging 132534',0.00,0.00,24940.00,0.00,0.00,'2022-03-02 08:28:58','',''),(2632110,'1','158','781',335,'Distributed to KARU PLANT for sales id:350313',1479800.00,0.00,0.00,3020.00,0.00,'2022-03-02 08:36:15','',''),(2632111,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350314',3209500.00,0.00,0.00,6550.00,0.00,'2022-03-02 08:36:37','',''),(2632112,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350315',2459800.00,0.00,0.00,5020.00,0.00,'2022-03-02 08:36:56','',''),(2632113,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350316',2533300.00,0.00,0.00,5170.00,0.00,'2022-03-02 08:41:11','',''),(2632114,'1','158','781',335,'Distributed to KM TRADE GAS for sales id:350317',2454900.00,0.00,0.00,5010.00,0.00,'2022-03-02 08:41:27','',''),(2632115,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350318',83300.00,0.00,0.00,170.00,0.00,'2022-03-02 08:43:10','',''),(2632116,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12289200.00,25080.00,0.00,0.00,'2022-03-03 08:44:58','',''),(2632117,'1','158',NULL,335,'Reception corrector for bridging 132535',0.00,0.00,0.00,25080.00,0.00,'2022-03-03 08:46:45','',''),(2632118,'1','158','780',335,'Received from bridging 132535',0.00,0.00,25080.00,0.00,0.00,'2022-03-03 08:46:45','',''),(2632119,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:350319',1156400.00,0.00,0.00,2360.00,0.00,'2022-03-03 08:55:48','',''),(2632120,'1','158','780',335,'Distributed to U I DANDADA for sales id:350320',2969400.00,0.00,0.00,6060.00,0.00,'2022-03-03 08:56:10','',''),(2632121,'1','158','780',335,'Distributed to KARU PLANT for sales id:350321',2822400.00,0.00,0.00,5760.00,0.00,'2022-03-03 08:56:36','',''),(2632122,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350322',2028600.00,0.00,0.00,4140.00,0.00,'2022-03-03 08:56:59','',''),(2632123,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350323',2268700.00,0.00,0.00,4630.00,0.00,'2022-03-03 09:06:29','',''),(2632124,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:350324',1043700.00,0.00,0.00,2130.00,0.00,'2022-03-03 09:07:55','',''),(2632125,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,12250000.00,25000.00,0.00,0.00,'2022-03-03 09:42:36','',''),(2632126,'1','158',NULL,335,'Reception corrector for bridging 132536',0.00,0.00,0.00,25000.00,0.00,'2022-03-03 09:44:22','',''),(2632127,'1','158','780',335,'Received from bridging 132536',0.00,0.00,25000.00,0.00,0.00,'2022-03-03 09:44:22','',''),(2632128,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:350325',2709700.00,0.00,0.00,5530.00,0.00,'2022-03-03 09:53:04','',''),(2632129,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350326',2523500.00,0.00,0.00,5150.00,0.00,'2022-03-03 09:53:23','',''),(2632130,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:350327',2989000.00,0.00,0.00,6100.00,0.00,'2022-03-03 09:53:45','',''),(2632131,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350328',2464700.00,0.00,0.00,5030.00,0.00,'2022-03-03 09:54:13','',''),(2632132,'1','158','780',335,'Distributed to KARU PLANT for sales id:350329',1538600.00,0.00,0.00,3140.00,0.00,'2022-03-03 09:57:46','',''),(2632133,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350330',24500.00,0.00,0.00,50.00,0.00,'2022-03-03 10:48:23','',''),(2632134,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13076100.00,25050.00,0.00,0.00,'2022-03-04 11:24:26','',''),(2632135,'1','158',NULL,335,'Reception corrector for bridging 132537',0.00,0.00,0.00,25050.00,0.00,'2022-03-04 11:25:58','',''),(2632136,'1','158','781',335,'Received from bridging 132537',0.00,0.00,25050.00,0.00,0.00,'2022-03-04 11:25:58','',''),(2632137,'1','158','781',335,'Distributed to KARU PLANT for sales id:350331',955260.00,0.00,0.00,1830.00,0.00,'2022-03-04 11:33:03','',''),(2632138,'1','158','781',335,'Distributed to KM TRADE GAS for sales id:350332',6911280.00,0.00,0.00,13240.00,0.00,'2022-03-04 11:33:21','',''),(2632139,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350333',2724840.00,0.00,0.00,5220.00,0.00,'2022-03-04 11:33:41','',''),(2632140,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350335',2484720.00,0.00,0.00,4760.00,0.00,'2022-03-04 11:36:41','',''),(2632141,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13008240.00,24920.00,0.00,0.00,'2022-03-06 12:44:07','',''),(2632142,'1','158',NULL,335,'Reception corrector for bridging 132538',0.00,0.00,0.00,24920.00,0.00,'2022-03-06 12:45:47','',''),(2632143,'1','158','781',335,'Received from bridging 132538',0.00,0.00,24920.00,0.00,0.00,'2022-03-06 12:45:47','',''),(2632144,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350336',261000.00,0.00,0.00,500.00,0.00,'2022-03-06 12:53:13','',''),(2632145,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350337',2557800.00,0.00,0.00,4900.00,0.00,'2022-03-06 12:54:14','',''),(2632146,'1','158','781',335,'Distributed to KARU PLANT for sales id:350338',2787480.00,0.00,0.00,5340.00,0.00,'2022-03-06 12:54:58','',''),(2632147,'1','158','781',335,'Distributed to KARU PLANT for sales id:350339',2672640.00,0.00,0.00,5120.00,0.00,'2022-03-06 14:17:56','',''),(2632148,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350340',2604780.00,0.00,0.00,4990.00,0.00,'2022-03-06 14:18:19','',''),(2632149,'1','158','781',335,'Distributed to KARU PLANT for sales id:350341',2124540.00,0.00,0.00,4070.00,0.00,'2022-03-06 14:18:40','',''),(2632150,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,10502640.00,20120.00,0.00,0.00,'2022-03-07 11:30:09','',''),(2632151,'1','158',NULL,335,'Reception corrector for bridging 132539',0.00,0.00,0.00,20120.00,0.00,'2022-03-07 11:32:00','',''),(2632152,'1','158','780',335,'Received from bridging 132539',0.00,0.00,20120.00,0.00,0.00,'2022-03-07 11:32:00','',''),(2632153,'1','158','780',335,'Distributed to KARU PLANT for sales id:350342',506340.00,0.00,0.00,970.00,0.00,'2022-03-07 11:40:41','',''),(2632154,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350343',2750940.00,0.00,0.00,5270.00,0.00,'2022-03-07 11:41:03','',''),(2632155,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350344',2667420.00,0.00,0.00,5110.00,0.00,'2022-03-07 11:41:26','',''),(2632156,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350345',2777040.00,0.00,0.00,5320.00,0.00,'2022-03-07 11:41:47','',''),(2632157,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350346',1800900.00,0.00,0.00,3450.00,0.00,'2022-03-07 11:48:37','',''),(2632158,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13050000.00,25000.00,0.00,0.00,'2022-03-07 11:53:22','',''),(2632159,'1','158',NULL,335,'Reception corrector for bridging 132540',0.00,0.00,0.00,25000.00,0.00,'2022-03-07 11:55:07','',''),(2632160,'1','158','780',335,'Received from bridging 132540',0.00,0.00,25000.00,0.00,0.00,'2022-03-07 11:55:07','',''),(2632161,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350347',908280.00,0.00,0.00,1740.00,0.00,'2022-03-07 12:10:09','',''),(2632162,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350348',2145420.00,0.00,0.00,4110.00,0.00,'2022-03-07 12:10:35','',''),(2632163,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350349',2980620.00,0.00,0.00,5710.00,0.00,'2022-03-07 12:10:55','',''),(2632164,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350350',3194640.00,0.00,0.00,6120.00,0.00,'2022-03-07 12:11:15','',''),(2632165,'1','158','780',335,'Distributed to KARU PLANT for sales id:350351',2933640.00,0.00,0.00,5620.00,0.00,'2022-03-07 12:11:49','',''),(2632166,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350352',850860.00,0.00,0.00,1630.00,0.00,'2022-03-07 12:12:13','',''),(2632167,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350353',36540.00,0.00,0.00,70.00,0.00,'2022-03-07 12:15:18','',''),(2632168,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13102200.00,25100.00,0.00,0.00,'2022-03-09 13:35:14','',''),(2632169,'1','158',NULL,335,'Reception corrector for bridging 132541',0.00,0.00,0.00,25100.00,0.00,'2022-03-09 13:37:53','',''),(2632170,'1','158','781',335,'Received from bridging 132541',0.00,0.00,25100.00,0.00,0.00,'2022-03-09 13:37:53','',''),(2632171,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350354',1994040.00,0.00,0.00,3820.00,0.00,'2022-03-09 13:44:12','',''),(2632172,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350355',2656980.00,0.00,0.00,5090.00,0.00,'2022-03-09 13:53:23','',''),(2632173,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350356',2641320.00,0.00,0.00,5060.00,0.00,'2022-03-09 13:53:43','',''),(2632174,'1','158','781',335,'Distributed to SUNSHINE GAS for sales id:350357',2531700.00,0.00,0.00,4850.00,0.00,'2022-03-09 13:54:03','',''),(2632175,'1','158','781',335,'Distributed to HARIZ GAS for sales id:350358',3278160.00,0.00,0.00,6280.00,0.00,'2022-03-09 13:54:23','',''),(2632176,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,13003020.00,24910.00,0.00,0.00,'2022-03-09 13:58:17','',''),(2632177,'1','158',NULL,335,'Reception corrector for bridging 132542',0.00,0.00,0.00,24910.00,0.00,'2022-03-09 14:00:11','',''),(2632178,'1','158','781',335,'Received from bridging 132542',0.00,0.00,24910.00,0.00,0.00,'2022-03-09 14:00:11','',''),(2632179,'1','158','781',335,'Distributed to HARIZ GAS for sales id:350359',1143180.00,0.00,0.00,2190.00,0.00,'2022-03-09 14:10:11','',''),(2632180,'1','158','781',335,'Distributed to KATAMFE for sales id:350360',2563020.00,0.00,0.00,4910.00,0.00,'2022-03-09 14:10:33','',''),(2632181,'1','158','781',335,'Distributed to LUBE GAS for sales id:350361',2521260.00,0.00,0.00,4830.00,0.00,'2022-03-09 14:10:54','',''),(2632182,'1','158','781',335,'Distributed to LOKOJA LPG  for sales id:350362',6775560.00,0.00,0.00,12980.00,0.00,'2022-03-09 14:16:22','',''),(2632183,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11677140.00,22370.00,0.00,0.00,'2022-03-09 14:53:04','',''),(2632184,'1','158',NULL,335,'Reception corrector for bridging 132543',0.00,0.00,0.00,22370.00,0.00,'2022-03-09 14:54:35','',''),(2632185,'1','158','780',335,'Received from bridging 132543',0.00,0.00,22370.00,0.00,0.00,'2022-03-09 14:54:35','',''),(2632186,'1','158','780',335,'Distributed to LUBE GAS for sales id:350363',798660.00,0.00,0.00,1530.00,0.00,'2022-03-09 15:00:42','',''),(2632187,'1','158','780',335,'Distributed to KARU PLANT for sales id:350364',2093220.00,0.00,0.00,4010.00,0.00,'2022-03-09 15:01:04','',''),(2632188,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350365',2260260.00,0.00,0.00,4330.00,0.00,'2022-03-09 15:23:08','',''),(2632189,'1','158','780',335,'Distributed to MAXPRIME GAS for sales id:350367',1002240.00,0.00,0.00,1920.00,0.00,'2022-03-09 15:23:25','',''),(2632190,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350366',2636100.00,0.00,0.00,5050.00,0.00,'2022-03-09 15:23:44','',''),(2632191,'1','158','780',335,'Distributed to KATAMFE for sales id:350368',2458620.00,0.00,0.00,4710.00,0.00,'2022-03-09 15:24:02','',''),(2632192,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350369',428040.00,0.00,0.00,820.00,0.00,'2022-03-09 15:27:09','',''),(2632193,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,10998540.00,21070.00,0.00,0.00,'2022-03-09 15:29:01','',''),(2632194,'1','158',NULL,335,'Reception corrector for bridging 132544',0.00,0.00,0.00,21070.00,0.00,'2022-03-09 15:30:38','',''),(2632195,'1','158','780',335,'Received from bridging 132544',0.00,0.00,21070.00,0.00,0.00,'2022-03-09 15:30:38','',''),(2632196,'1','158','780',335,'Distributed to KATAMFE for sales id:350371',135720.00,0.00,0.00,260.00,0.00,'2022-03-09 15:42:22','',''),(2632197,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350372',2521260.00,0.00,0.00,4830.00,0.00,'2022-03-09 15:42:49','',''),(2632198,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350373',2307240.00,0.00,0.00,4420.00,0.00,'2022-03-09 15:43:24','',''),(2632199,'1','158','780',335,'Distributed to KARU PLANT for sales id:350374',2411640.00,0.00,0.00,4620.00,0.00,'2022-03-09 15:43:45','',''),(2632200,'1','158','780',335,'Distributed to GAS CONNECT for sales id:350375',3168540.00,0.00,0.00,6070.00,0.00,'2022-03-09 15:44:05','',''),(2632201,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350376',454140.00,0.00,0.00,870.00,0.00,'2022-03-09 15:46:21','',''),(2632202,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14265680.00,24940.00,0.00,0.00,'2022-03-11 14:51:15','',''),(2632203,'1','158',NULL,335,'Reception corrector for bridging 132545',0.00,0.00,0.00,24940.00,0.00,'2022-03-11 14:52:47','',''),(2632204,'1','158','781',335,'Received from bridging 132545',0.00,0.00,24940.00,0.00,0.00,'2022-03-11 14:52:47','',''),(2632205,'1','158','781',335,'Distributed to GAS CONNECT for sales id:350377',446160.00,0.00,0.00,780.00,0.00,'2022-03-11 15:00:27','',''),(2632206,'1','158','781',335,'Distributed to KATAMFE for sales id:350378',2940080.00,0.00,0.00,5140.00,0.00,'2022-03-11 15:00:59','',''),(2632207,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350379',2728440.00,0.00,0.00,4770.00,0.00,'2022-03-11 15:01:36','',''),(2632208,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350380',2945800.00,0.00,0.00,5150.00,0.00,'2022-03-11 15:08:33','',''),(2632209,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350381',2139280.00,0.00,0.00,3740.00,0.00,'2022-03-11 15:08:57','',''),(2632210,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350382',2797080.00,0.00,0.00,4890.00,0.00,'2022-03-11 15:09:18','',''),(2632211,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350383',268840.00,0.00,0.00,470.00,0.00,'2022-03-11 15:13:29','',''),(2632212,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14277120.00,24960.00,0.00,0.00,'2022-03-11 15:18:03','',''),(2632213,'1','158',NULL,335,'Reception corrector for bridging 132546',0.00,0.00,0.00,24960.00,0.00,'2022-03-11 15:20:07','',''),(2632214,'1','158','781',335,'Received from bridging 132546',0.00,0.00,24960.00,0.00,0.00,'2022-03-11 15:20:07','',''),(2632215,'1','158','781',335,'Distributed to KARU PLANT for sales id:350384',3037320.00,0.00,0.00,5310.00,0.00,'2022-03-11 15:22:45','',''),(2632216,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350385',2877160.00,0.00,0.00,5030.00,0.00,'2022-03-11 15:28:34','',''),(2632217,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350386',3552120.00,0.00,0.00,6210.00,0.00,'2022-03-11 15:28:58','',''),(2632218,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350387',1372800.00,0.00,0.00,2400.00,0.00,'2022-03-11 15:29:16','',''),(2632219,'1','158','781',335,'Distributed to KARU PLANT for sales id:350388',2905760.00,0.00,0.00,5080.00,0.00,'2022-03-11 15:33:47','',''),(2632220,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350389',383240.00,0.00,0.00,670.00,0.00,'2022-03-11 15:34:06','',''),(2632221,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350390',148720.00,0.00,0.00,260.00,0.00,'2022-03-11 15:36:14','',''),(2632222,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14322880.00,25040.00,0.00,0.00,'2022-03-14 12:22:17','',''),(2632223,'1','158',NULL,335,'Reception corrector for bridging 132547',0.00,0.00,0.00,25040.00,0.00,'2022-03-14 12:25:22','',''),(2632224,'1','158','780',335,'Received from bridging 132547',0.00,0.00,25040.00,0.00,0.00,'2022-03-14 12:25:22','',''),(2632225,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350391',2574000.00,0.00,0.00,4500.00,0.00,'2022-03-14 12:34:38','',''),(2632226,'1','158','780',335,'Distributed to KATAMFE for sales id:350392',3043040.00,0.00,0.00,5320.00,0.00,'2022-03-14 12:35:00','',''),(2632227,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350393',3123120.00,0.00,0.00,5460.00,0.00,'2022-03-14 12:35:26','',''),(2632228,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350394',2785640.00,0.00,0.00,4870.00,0.00,'2022-03-14 12:40:31','',''),(2632229,'1','158','780',335,'Distributed to KARU PLANT for sales id:350395',2688400.00,0.00,0.00,4700.00,0.00,'2022-03-14 12:40:50','',''),(2632230,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350396',108680.00,0.00,0.00,190.00,0.00,'2022-03-14 12:44:02','',''),(2632231,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14271400.00,24950.00,0.00,0.00,'2022-03-14 12:47:26','',''),(2632232,'1','158',NULL,335,'Reception corrector for bridging 132548',0.00,0.00,0.00,24950.00,0.00,'2022-03-14 12:49:37','',''),(2632233,'1','158','780',335,'Received from bridging 132548',0.00,0.00,24950.00,0.00,0.00,'2022-03-14 12:49:37','',''),(2632234,'1','158','780',335,'Distributed to KARU PLANT for sales id:350397',451880.00,0.00,0.00,790.00,0.00,'2022-03-14 12:57:47','',''),(2632235,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350398',3226080.00,0.00,0.00,5640.00,0.00,'2022-03-14 12:58:04','',''),(2632236,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350399',2854280.00,0.00,0.00,4990.00,0.00,'2022-03-14 12:59:02','',''),(2632237,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350400',3054480.00,0.00,0.00,5340.00,0.00,'2022-03-14 13:01:28','',''),(2632238,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350401',451880.00,0.00,0.00,790.00,0.00,'2022-03-14 13:08:11','',''),(2632239,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350402',4152720.00,0.00,0.00,7260.00,0.00,'2022-03-14 13:08:42','',''),(2632240,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350403',80080.00,0.00,0.00,140.00,0.00,'2022-03-14 13:10:45','',''),(2632241,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14357200.00,25100.00,0.00,0.00,'2022-03-16 11:54:13','',''),(2632242,'1','158',NULL,335,'Reception corrector for bridging 132549',0.00,0.00,0.00,25100.00,0.00,'2022-03-16 11:56:08','',''),(2632243,'1','158','781',335,'Received from bridging 132549',0.00,0.00,25100.00,0.00,0.00,'2022-03-16 11:56:08','',''),(2632244,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350404',1939080.00,0.00,0.00,3390.00,0.00,'2022-03-16 12:11:57','',''),(2632245,'1','158','781',335,'Distributed to KARU PLANT for sales id:350405',2957240.00,0.00,0.00,5170.00,0.00,'2022-03-16 12:12:23','',''),(2632246,'1','158','781',335,'Distributed to KATAMFE for sales id:350406',2894320.00,0.00,0.00,5060.00,0.00,'2022-03-16 12:21:26','',''),(2632247,'1','158','781',335,'Distributed to KARU PLANT for sales id:350407',3043040.00,0.00,0.00,5320.00,0.00,'2022-03-16 12:21:46','',''),(2632248,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350408',2631200.00,0.00,0.00,4600.00,0.00,'2022-03-16 12:22:06','',''),(2632249,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350409',789360.00,0.00,0.00,1380.00,0.00,'2022-03-16 12:22:25','',''),(2632250,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350410',102960.00,0.00,0.00,180.00,0.00,'2022-03-16 12:24:28','',''),(2632251,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11497200.00,20100.00,0.00,0.00,'2022-03-16 12:26:41','',''),(2632252,'1','158',NULL,335,'Reception corrector for bridging 132550',0.00,0.00,0.00,20100.00,0.00,'2022-03-16 12:28:28','',''),(2632253,'1','158','781',335,'Received from bridging 132550',0.00,0.00,20100.00,0.00,0.00,'2022-03-16 12:28:28','',''),(2632254,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350411',1939080.00,0.00,0.00,3390.00,0.00,'2022-03-16 12:34:03','',''),(2632255,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350413',2768480.00,0.00,0.00,4840.00,0.00,'2022-03-16 12:34:26','',''),(2632256,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350414',2860000.00,0.00,0.00,5000.00,0.00,'2022-03-16 12:34:43','',''),(2632257,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350415',2917200.00,0.00,0.00,5100.00,0.00,'2022-03-16 12:40:22','',''),(2632258,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350416',457600.00,0.00,0.00,800.00,0.00,'2022-03-16 12:40:40','',''),(2632259,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350417',554840.00,0.00,0.00,970.00,0.00,'2022-03-16 12:43:11','',''),(2632260,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11380000.00,20000.00,0.00,0.00,'2022-03-18 12:47:13','',''),(2632261,'1','158',NULL,335,'Reception corrector for bridging 132551',0.00,0.00,0.00,20000.00,0.00,'2022-03-18 12:49:00','',''),(2632262,'1','158','780',335,'Received from bridging 132551',0.00,0.00,20000.00,0.00,0.00,'2022-03-18 12:49:00','',''),(2632263,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350418',2298760.00,0.00,0.00,4040.00,0.00,'2022-03-18 12:53:03','',''),(2632264,'1','158','780',335,'Distributed to KARU PLANT for sales id:350419',2332900.00,0.00,0.00,4100.00,0.00,'2022-03-18 12:53:20','',''),(2632265,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350420',2992940.00,0.00,0.00,5260.00,0.00,'2022-03-18 12:59:04','',''),(2632266,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350421',2816550.00,0.00,0.00,4950.00,0.00,'2022-03-18 12:59:22','',''),(2632267,'1','158','780',335,'Distributed to KARU PLANT for sales id:350422',512100.00,0.00,0.00,900.00,0.00,'2022-03-18 12:59:40','',''),(2632268,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350423',426750.00,0.00,0.00,750.00,0.00,'2022-03-18 13:02:14','',''),(2632269,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14179480.00,24920.00,0.00,0.00,'2022-03-18 15:30:09','',''),(2632270,'1','158',NULL,335,'Reception corrector for bridging 132552',0.00,0.00,0.00,24920.00,0.00,'2022-03-18 15:31:30','',''),(2632271,'1','158','780',335,'Received from bridging 132552',0.00,0.00,24920.00,0.00,0.00,'2022-03-18 15:31:30','',''),(2632272,'1','158','780',335,'Distributed to KARU PLANT for sales id:350424',2509290.00,0.00,0.00,4410.00,0.00,'2022-03-18 15:36:38','',''),(2632273,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350425',3214850.00,0.00,0.00,5650.00,0.00,'2022-03-18 15:36:57','',''),(2632274,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350426',3038460.00,0.00,0.00,5340.00,0.00,'2022-03-18 15:41:06','',''),(2632275,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350427',2719820.00,0.00,0.00,4780.00,0.00,'2022-03-18 15:41:29','',''),(2632276,'1','158','780',335,'Distributed to KARU PLANT for sales id:350428',2566190.00,0.00,0.00,4510.00,0.00,'2022-03-18 15:44:57','',''),(2632277,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350429',130870.00,0.00,0.00,230.00,0.00,'2022-03-18 15:47:14','',''),(2632278,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14168100.00,24900.00,0.00,0.00,'2022-03-19 15:49:17','',''),(2632279,'1','158',NULL,335,'Reception corrector for bridging 132553',0.00,0.00,0.00,24900.00,0.00,'2022-03-19 15:50:49','',''),(2632280,'1','158','781',335,'Received from bridging 132553',0.00,0.00,24900.00,0.00,0.00,'2022-03-19 15:50:49','',''),(2632281,'1','158','781',335,'Distributed to KARU PLANT for sales id:350430',415370.00,0.00,0.00,730.00,0.00,'2022-03-19 15:54:11','',''),(2632282,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350431',3129500.00,0.00,0.00,5500.00,0.00,'2022-03-19 15:54:33','',''),(2632283,'1','158','781',335,'Distributed to KARU PLANT for sales id:350432',3965930.00,0.00,0.00,6970.00,0.00,'2022-03-19 16:02:20','',''),(2632284,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350433',3021390.00,0.00,0.00,5310.00,0.00,'2022-03-19 16:09:13','',''),(2632285,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350434',2372730.00,0.00,0.00,4170.00,0.00,'2022-03-19 16:09:32','',''),(2632286,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350435',1081100.00,0.00,0.00,1900.00,0.00,'2022-03-19 16:10:08','',''),(2632287,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350436',182080.00,0.00,0.00,320.00,0.00,'2022-03-19 16:11:44','',''),(2632288,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14894040.00,24990.00,0.00,0.00,'2022-03-21 11:08:02','',''),(2632289,'1','158',NULL,335,'Reception corrector for bridging 132554',0.00,0.00,0.00,24990.00,0.00,'2022-03-21 11:10:04','',''),(2632290,'1','158','781',335,'Received from bridging 132554',0.00,0.00,24990.00,0.00,0.00,'2022-03-21 11:10:04','',''),(2632291,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350437',2431680.00,0.00,0.00,4080.00,0.00,'2022-03-21 11:15:30','',''),(2632292,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350438',3105160.00,0.00,0.00,5210.00,0.00,'2022-03-21 11:15:51','',''),(2632293,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350439',3117080.00,0.00,0.00,5230.00,0.00,'2022-03-21 11:22:57','',''),(2632294,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350440',2997880.00,0.00,0.00,5030.00,0.00,'2022-03-21 11:23:16','',''),(2632295,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350441',3111120.00,0.00,0.00,5220.00,0.00,'2022-03-21 11:23:35','',''),(2632296,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350442',131120.00,0.00,0.00,220.00,0.00,'2022-03-21 11:25:28','',''),(2632297,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14717640.00,25030.00,0.00,0.00,'2022-03-22 14:57:17','',''),(2632298,'1','158',NULL,335,'Reception corrector for bridging 132555',0.00,0.00,0.00,25030.00,0.00,'2022-03-22 15:00:19','',''),(2632299,'1','158','780',335,'Received from bridging 132555',0.00,0.00,25030.00,0.00,0.00,'2022-03-22 15:00:19','',''),(2632300,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350443',2945880.00,0.00,0.00,5010.00,0.00,'2022-03-22 15:12:47','',''),(2632301,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350444',2957640.00,0.00,0.00,5030.00,0.00,'2022-03-22 15:13:06','',''),(2632302,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350445',2810640.00,0.00,0.00,4780.00,0.00,'2022-03-22 15:16:11','',''),(2632303,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350446',2945880.00,0.00,0.00,5010.00,0.00,'2022-03-22 15:20:13','',''),(2632304,'1','158','780',335,'Distributed to JEFF GAS for sales id:350447',2751840.00,0.00,0.00,4680.00,0.00,'2022-03-22 15:20:31','',''),(2632305,'1','158','780',335,'Distributed to JEFF GAS for sales id:350448',105840.00,0.00,0.00,180.00,0.00,'2022-03-22 15:28:03','',''),(2632306,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350449',199920.00,0.00,0.00,340.00,0.00,'2022-03-22 15:29:56','',''),(2632307,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14711760.00,25020.00,0.00,0.00,'2022-03-24 10:36:23','',''),(2632308,'1','158',NULL,335,'Reception corrector for bridging 132556',0.00,0.00,0.00,25020.00,0.00,'2022-03-24 10:37:41','',''),(2632309,'1','158','780',335,'Received from bridging 132556',0.00,0.00,25020.00,0.00,0.00,'2022-03-24 10:37:41','',''),(2632310,'1','158','780',335,'Distributed to JEFF GAS for sales id:350450',2634240.00,0.00,0.00,4480.00,0.00,'2022-03-24 10:41:33','',''),(2632311,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350451',2981160.00,0.00,0.00,5070.00,0.00,'2022-03-24 10:41:54','',''),(2632312,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350452',2887080.00,0.00,0.00,4910.00,0.00,'2022-03-24 10:48:21','',''),(2632313,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350453',3169320.00,0.00,0.00,5390.00,0.00,'2022-03-24 10:48:39','',''),(2632314,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350454',2834160.00,0.00,0.00,4820.00,0.00,'2022-03-24 10:48:57','',''),(2632315,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350455',105840.00,0.00,0.00,180.00,0.00,'2022-03-24 10:49:16','',''),(2632316,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350456',99960.00,0.00,0.00,170.00,0.00,'2022-03-24 10:50:54','',''),(2632317,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14717640.00,25030.00,0.00,0.00,'2022-03-26 13:02:26','',''),(2632318,'1','158',NULL,335,'Reception corrector for bridging 132557',0.00,0.00,0.00,25030.00,0.00,'2022-03-26 13:03:40','',''),(2632319,'1','158','781',335,'Received from bridging 132557',0.00,0.00,25030.00,0.00,0.00,'2022-03-26 13:03:40','',''),(2632320,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350457',2798880.00,0.00,0.00,4760.00,0.00,'2022-03-26 13:05:34','',''),(2632321,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350458',2810640.00,0.00,0.00,4780.00,0.00,'2022-03-26 13:11:28','',''),(2632322,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350459',3110520.00,0.00,0.00,5290.00,0.00,'2022-03-26 13:11:45','',''),(2632323,'1','158','781',335,'Distributed to MAXPRIME GAS for sales id:350460',1275960.00,0.00,0.00,2170.00,0.00,'2022-03-26 13:12:03','',''),(2632324,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350461',3510360.00,0.00,0.00,5970.00,0.00,'2022-03-26 13:12:19','',''),(2632325,'1','158','781',335,'Distributed to NIP WEST GAS for sales id:350462',1052520.00,0.00,0.00,1790.00,0.00,'2022-03-26 13:14:51','',''),(2632326,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350463',158760.00,0.00,0.00,270.00,0.00,'2022-03-26 13:16:24','',''),(2632327,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14582400.00,24800.00,0.00,0.00,'2022-03-28 11:58:15','',''),(2632328,'1','158',NULL,335,'Reception corrector for bridging 132558',0.00,0.00,0.00,24800.00,0.00,'2022-03-28 11:59:29','',''),(2632329,'1','158','780',335,'Received from bridging 132558',0.00,0.00,24800.00,0.00,0.00,'2022-03-28 11:59:29','',''),(2632330,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:350464',2646000.00,0.00,0.00,4500.00,0.00,'2022-03-28 12:01:28','',''),(2632331,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350465',2904720.00,0.00,0.00,4940.00,0.00,'2022-03-28 12:12:27','',''),(2632332,'1','158','780',335,'Distributed to KARU PLANT for sales id:350466',3204600.00,0.00,0.00,5450.00,0.00,'2022-03-28 12:13:04','',''),(2632333,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350467',3010560.00,0.00,0.00,5120.00,0.00,'2022-03-28 12:13:42','',''),(2632334,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350468',2675400.00,0.00,0.00,4550.00,0.00,'2022-03-28 12:14:25','',''),(2632335,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350469',141120.00,0.00,0.00,240.00,0.00,'2022-03-28 12:19:46','',''),(2632336,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15199280.00,25040.00,0.00,0.00,'2022-03-28 12:23:25','',''),(2632337,'1','158',NULL,335,'Reception corrector for bridging 132559',0.00,0.00,0.00,25040.00,0.00,'2022-03-28 12:25:46','',''),(2632338,'1','158','780',335,'Received from bridging 132559',0.00,0.00,25040.00,0.00,0.00,'2022-03-28 12:25:46','',''),(2632339,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350470',880150.00,0.00,0.00,1450.00,0.00,'2022-03-28 12:30:11','',''),(2632340,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350471',2767920.00,0.00,0.00,4560.00,0.00,'2022-03-28 12:30:28','',''),(2632341,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350472',3132120.00,0.00,0.00,5160.00,0.00,'2022-03-28 12:38:42','',''),(2632342,'1','158','780',335,'Distributed to KARU PLANT for sales id:350473',3787680.00,0.00,0.00,6240.00,0.00,'2022-03-28 12:39:15','',''),(2632343,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350474',3253520.00,0.00,0.00,5360.00,0.00,'2022-03-28 12:39:34','',''),(2632344,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350475',1323260.00,0.00,0.00,2180.00,0.00,'2022-03-28 12:43:59','',''),(2632345,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350476',54630.00,0.00,0.00,90.00,0.00,'2022-03-28 12:47:20','',''),(2632346,'1','158',NULL,335,'Reception corrector for bridging 132560',0.00,0.00,0.00,1000.00,0.00,'2022-03-28 12:54:34','',''),(2632347,'1','158','780',335,'Received from bridging 132560',0.00,0.00,1000.00,0.00,0.00,'2022-03-28 12:54:34','',''),(2632348,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15175000.00,25000.00,0.00,0.00,'2022-03-28 17:04:32','',''),(2632349,'1','158',NULL,335,'Reception corrector for bridging 132561',0.00,0.00,0.00,25000.00,0.00,'2022-03-28 17:05:37','',''),(2632350,'1','158','780',335,'Received from bridging 132561',0.00,0.00,25000.00,0.00,0.00,'2022-03-28 17:05:37','',''),(2632351,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350477',1857420.00,0.00,0.00,3060.00,0.00,'2022-03-28 17:10:56','',''),(2632352,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350478',3041070.00,0.00,0.00,5010.00,0.00,'2022-03-28 17:11:14','',''),(2632353,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350479',2871110.00,0.00,0.00,4730.00,0.00,'2022-03-28 17:11:33','',''),(2632354,'1','158','780',335,'Distributed to LOKOJA LPG  for sales id:350480',7399330.00,0.00,0.00,12190.00,0.00,'2022-03-28 17:11:51','',''),(2632355,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350481',6070.00,0.00,0.00,10.00,0.00,'2022-03-28 17:13:40','',''),(2632356,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15168930.00,24990.00,0.00,0.00,'2022-04-03 14:57:23','',''),(2632357,'1','158',NULL,335,'Reception corrector for bridging 132562',0.00,0.00,0.00,24990.00,0.00,'2022-04-03 14:59:10','',''),(2632358,'1','158','781',335,'Received from bridging 132562',0.00,0.00,24990.00,0.00,0.00,'2022-04-03 14:59:10','',''),(2632359,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350482',206380.00,0.00,0.00,340.00,0.00,'2022-04-03 15:08:08','',''),(2632360,'1','158','781',335,'Distributed to KARU PLANT for sales id:350483',3083560.00,0.00,0.00,5080.00,0.00,'2022-04-03 15:08:28','',''),(2632361,'1','158','781',335,'Distributed to KEFFI LPG SKID for sales id:350484',3126050.00,0.00,0.00,5150.00,0.00,'2022-04-03 15:08:47','',''),(2632362,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350485',3763400.00,0.00,0.00,6200.00,0.00,'2022-04-03 15:09:07','',''),(2632363,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350486',3599510.00,0.00,0.00,5930.00,0.00,'2022-04-03 15:09:27','',''),(2632364,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350487',1080460.00,0.00,0.00,1780.00,0.00,'2022-04-03 15:13:10','',''),(2632365,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350488',309570.00,0.00,0.00,510.00,0.00,'2022-04-03 15:16:13','',''),(2632366,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14823680.00,25040.00,0.00,0.00,'2022-04-03 15:19:34','',''),(2632367,'1','158',NULL,335,'Reception corrector for bridging 132563',0.00,0.00,0.00,25040.00,0.00,'2022-04-03 15:20:56','',''),(2632368,'1','158','780',335,'Received from bridging 132563',0.00,0.00,25040.00,0.00,0.00,'2022-04-03 15:20:56','',''),(2632369,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350489',1918080.00,0.00,0.00,3240.00,0.00,'2022-04-03 15:31:38','',''),(2632370,'1','158','780',335,'Distributed to KARU PLANT for sales id:350490',3226400.00,0.00,0.00,5450.00,0.00,'2022-04-03 15:31:58','',''),(2632371,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350491',3682240.00,0.00,0.00,6220.00,0.00,'2022-04-03 15:32:19','',''),(2632372,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350492',2806080.00,0.00,0.00,4740.00,0.00,'2022-04-03 15:32:46','',''),(2632373,'1','158','780',335,'Distributed to KARU PLANT for sales id:350494',224960.00,0.00,0.00,380.00,0.00,'2022-04-03 15:38:31','',''),(2632374,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350493',2859360.00,0.00,0.00,4830.00,0.00,'2022-04-03 15:38:50','',''),(2632375,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350495',106560.00,0.00,0.00,180.00,0.00,'2022-04-03 15:41:04','',''),(2632376,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-04 15:16:17','',''),(2632377,'1','158',NULL,335,'Reception corrector for bridging 132564',0.00,0.00,0.00,25000.00,0.00,'2022-04-04 15:17:33','',''),(2632378,'1','158','780',335,'Received from bridging 132564',0.00,0.00,25000.00,0.00,0.00,'2022-04-04 15:17:33','',''),(2632379,'1','158','780',335,'Distributed to KARU PLANT for sales id:350496',2906720.00,0.00,0.00,4910.00,0.00,'2022-04-04 15:23:15','',''),(2632380,'1','158','780',335,'Distributed to KARU PLANT for sales id:350497',3066560.00,0.00,0.00,5180.00,0.00,'2022-04-04 15:34:30','',''),(2632381,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350498',3173120.00,0.00,0.00,5360.00,0.00,'2022-04-04 15:34:50','',''),(2632382,'1','158','780',335,'Distributed to KATAMFE for sales id:350499',2764640.00,0.00,0.00,4670.00,0.00,'2022-04-04 15:35:07','',''),(2632383,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350500',2865280.00,0.00,0.00,4840.00,0.00,'2022-04-04 15:38:41','',''),(2632384,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350501',23680.00,0.00,0.00,40.00,0.00,'2022-04-04 15:42:05','',''),(2632385,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-04 15:44:23','',''),(2632386,'1','158',NULL,335,'Reception corrector for bridging 132565',0.00,0.00,0.00,25000.00,0.00,'2022-04-04 15:53:53','',''),(2632387,'1','158','781',335,'Received from bridging 132565',0.00,0.00,25000.00,0.00,0.00,'2022-04-04 15:53:53','',''),(2632388,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350502',248640.00,0.00,0.00,420.00,0.00,'2022-04-04 16:19:43','',''),(2632389,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350503',3025120.00,0.00,0.00,5110.00,0.00,'2022-04-04 16:20:01','',''),(2632390,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350504',3131680.00,0.00,0.00,5290.00,0.00,'2022-04-04 16:20:18','',''),(2632391,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350505',3007360.00,0.00,0.00,5080.00,0.00,'2022-04-04 16:20:37','',''),(2632392,'1','158','781',335,'Distributed to KARU PLANT for sales id:350506',3261920.00,0.00,0.00,5510.00,0.00,'2022-04-04 16:21:08','',''),(2632393,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350507',2107520.00,0.00,0.00,3560.00,0.00,'2022-04-04 16:21:30','',''),(2632394,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350508',17760.00,0.00,0.00,30.00,0.00,'2022-04-04 16:23:44','',''),(2632395,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-04 16:29:22','',''),(2632396,'1','158',NULL,335,'Reception corrector for bridging 132566',0.00,0.00,0.00,25000.00,0.00,'2022-04-04 16:30:50','',''),(2632397,'1','158','780',335,'Received from bridging 132566',0.00,0.00,25000.00,0.00,0.00,'2022-04-04 16:30:50','',''),(2632398,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350509',763680.00,0.00,0.00,1290.00,0.00,'2022-04-04 16:34:04','',''),(2632399,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350510',3226400.00,0.00,0.00,5450.00,0.00,'2022-04-04 16:34:22','',''),(2632400,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350511',3090240.00,0.00,0.00,5220.00,0.00,'2022-04-04 16:43:07','',''),(2632401,'1','158','780',335,'Distributed to KARU PLANT for sales id:350512',3078400.00,0.00,0.00,5200.00,0.00,'2022-04-04 16:43:23','',''),(2632402,'1','158','780',335,'Distributed to ADO PLANT for sales id:350513',3125760.00,0.00,0.00,5280.00,0.00,'2022-04-04 16:43:40','',''),(2632403,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350514',1515520.00,0.00,0.00,2560.00,0.00,'2022-04-04 16:46:26','',''),(2632404,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-08 16:49:09','',''),(2632405,'1','158',NULL,335,'Reception corrector for bridging 132567',0.00,0.00,0.00,25000.00,0.00,'2022-04-08 16:52:09','',''),(2632406,'1','158','780',335,'Received from bridging 132567',0.00,0.00,25000.00,0.00,0.00,'2022-04-08 16:52:09','',''),(2632407,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350515',1408960.00,0.00,0.00,2380.00,0.00,'2022-04-08 17:01:26','',''),(2632408,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350516',3273760.00,0.00,0.00,5530.00,0.00,'2022-04-08 17:03:30','',''),(2632409,'1','158','780',335,'Distributed to KARU PLANT for sales id:350517',3291520.00,0.00,0.00,5560.00,0.00,'2022-04-08 17:03:57','',''),(2632410,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350518',3273760.00,0.00,0.00,5530.00,0.00,'2022-04-08 17:04:20','',''),(2632411,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350519',3013280.00,0.00,0.00,5090.00,0.00,'2022-04-08 17:04:39','',''),(2632412,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350520',538720.00,0.00,0.00,910.00,0.00,'2022-04-08 17:04:56','',''),(2632413,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-08 17:07:22','',''),(2632414,'1','158',NULL,335,'Reception corrector for bridging 132568',0.00,0.00,0.00,25000.00,0.00,'2022-04-08 17:08:42','',''),(2632415,'1','158','781',335,'Received from bridging 132568',0.00,0.00,25000.00,0.00,0.00,'2022-04-08 17:08:42','',''),(2632416,'1','158','781',335,'Distributed to DON NAS GAS for sales id:350521',3267840.00,0.00,0.00,5520.00,0.00,'2022-04-08 17:14:56','',''),(2632417,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350522',3042880.00,0.00,0.00,5140.00,0.00,'2022-04-08 17:15:29','',''),(2632418,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350523',2669920.00,0.00,0.00,4510.00,0.00,'2022-04-08 17:15:47','',''),(2632419,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350524',3036960.00,0.00,0.00,5130.00,0.00,'2022-04-08 17:16:10','',''),(2632420,'1','158','781',335,'Distributed to KARU PLANT for sales id:350525',2782400.00,0.00,0.00,4700.00,0.00,'2022-04-08 17:19:57','',''),(2632421,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-08 17:21:35','',''),(2632422,'1','158',NULL,335,'Reception corrector for bridging 132569',0.00,0.00,0.00,25000.00,0.00,'2022-04-08 17:23:03','',''),(2632423,'1','158','780',335,'Received from bridging 132569',0.00,0.00,25000.00,0.00,0.00,'2022-04-08 17:23:03','',''),(2632424,'1','158','780',335,'Distributed to KARU PLANT for sales id:350526',219040.00,0.00,0.00,370.00,0.00,'2022-04-08 17:25:36','',''),(2632425,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350527',3084320.00,0.00,0.00,5210.00,0.00,'2022-04-08 17:34:34','',''),(2632426,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350528',3208640.00,0.00,0.00,5420.00,0.00,'2022-04-08 17:34:53','',''),(2632427,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350529',2883040.00,0.00,0.00,4870.00,0.00,'2022-04-08 17:35:12','',''),(2632428,'1','158','780',335,'Distributed to SUNSHINE GAS for sales id:350530',2912640.00,0.00,0.00,4920.00,0.00,'2022-04-08 17:35:31','',''),(2632429,'1','158','780',335,'Distributed to KARU PLANT for sales id:350531',2433120.00,0.00,0.00,4110.00,0.00,'2022-04-08 17:35:54','',''),(2632430,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350532',59200.00,0.00,0.00,100.00,0.00,'2022-04-08 17:38:31','',''),(2632431,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-09 12:12:15','',''),(2632432,'1','158',NULL,335,'Reception corrector for bridging 132570',0.00,0.00,0.00,25000.00,0.00,'2022-04-09 12:13:36','',''),(2632433,'1','158','780',335,'Received from bridging 132570',0.00,0.00,25000.00,0.00,0.00,'2022-04-09 12:13:36','',''),(2632434,'1','158','780',335,'Distributed to KARU PLANT for sales id:350533',716320.00,0.00,0.00,1210.00,0.00,'2022-04-09 12:24:18','',''),(2632435,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350534',1835200.00,0.00,0.00,3100.00,0.00,'2022-04-09 12:24:40','',''),(2632436,'1','158','780',335,'Distributed to KATAMFE for sales id:350535',3640800.00,0.00,0.00,6150.00,0.00,'2022-04-09 12:24:58','',''),(2632437,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350536',2965920.00,0.00,0.00,5010.00,0.00,'2022-04-09 12:25:18','',''),(2632438,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350537',1906240.00,0.00,0.00,3220.00,0.00,'2022-04-09 12:25:37','',''),(2632439,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350538',3001440.00,0.00,0.00,5070.00,0.00,'2022-04-09 12:25:56','',''),(2632440,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350539',674880.00,0.00,0.00,1140.00,0.00,'2022-04-09 12:26:12','',''),(2632441,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350540',59200.00,0.00,0.00,100.00,0.00,'2022-04-09 12:27:52','',''),(2632442,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14776320.00,24960.00,0.00,0.00,'2022-04-09 13:34:43','',''),(2632443,'1','158',NULL,335,'Reception corrector for bridging 132571',0.00,0.00,0.00,24960.00,0.00,'2022-04-09 13:36:18','',''),(2632444,'1','158','781',335,'Received from bridging 132571',0.00,0.00,24960.00,0.00,0.00,'2022-04-09 13:36:18','',''),(2632445,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350541',2172640.00,0.00,0.00,3670.00,0.00,'2022-04-09 13:41:59','',''),(2632446,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350542',3143520.00,0.00,0.00,5310.00,0.00,'2022-04-09 13:42:17','',''),(2632447,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350543',3184960.00,0.00,0.00,5380.00,0.00,'2022-04-09 13:42:34','',''),(2632448,'1','158','781',335,'Distributed to SUNSHINE GAS for sales id:350544',1841120.00,0.00,0.00,3110.00,0.00,'2022-04-09 13:42:51','',''),(2632449,'1','158','781',335,'Distributed to SUNSHINE GAS for sales id:350545',2912640.00,0.00,0.00,4920.00,0.00,'2022-04-09 13:47:06','',''),(2632450,'1','158','781',335,'Distributed to ADO PLANT for sales id:350546',1521440.00,0.00,0.00,2570.00,0.00,'2022-04-09 13:47:26','',''),(2632451,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11840000.00,20000.00,0.00,0.00,'2022-04-09 14:32:46','',''),(2632452,'1','158',NULL,335,'Reception corrector for bridging 132572',0.00,0.00,0.00,20000.00,0.00,'2022-04-09 14:34:05','',''),(2632453,'1','158','781',335,'Received from bridging 132572',0.00,0.00,20000.00,0.00,0.00,'2022-04-09 14:34:05','',''),(2632454,'1','158','781',335,'Distributed to ADO PLANT for sales id:350547',1734560.00,0.00,0.00,2930.00,0.00,'2022-04-09 14:40:11','',''),(2632455,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350548',3072480.00,0.00,0.00,5190.00,0.00,'2022-04-09 14:40:31','',''),(2632456,'1','158','781',335,'Distributed to KARU PLANT for sales id:350549',3072480.00,0.00,0.00,5190.00,0.00,'2022-04-09 14:40:47','',''),(2632457,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350550',3711840.00,0.00,0.00,6270.00,0.00,'2022-04-09 14:41:09','',''),(2632458,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350551',248640.00,0.00,0.00,420.00,0.00,'2022-04-09 14:42:59','',''),(2632459,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-09 14:44:28','',''),(2632460,'1','158',NULL,335,'Reception corrector for bridging 132573',0.00,0.00,0.00,25000.00,0.00,'2022-04-09 14:45:49','',''),(2632461,'1','158','781',335,'Received from bridging 132573',0.00,0.00,25000.00,0.00,0.00,'2022-04-09 14:45:49','',''),(2632462,'1','158','781',335,'Distributed to KATAMFE for sales id:350552',4303840.00,0.00,0.00,7270.00,0.00,'2022-04-09 14:51:05','',''),(2632463,'1','158','781',335,'Distributed to LOKOJA LPG  for sales id:350553',2871200.00,0.00,0.00,4850.00,0.00,'2022-04-09 14:51:25','',''),(2632464,'1','158','781',335,'Distributed to JEFF GAS for sales id:350554',5552960.00,0.00,0.00,9380.00,0.00,'2022-04-09 14:51:43','',''),(2632465,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350555',2072000.00,0.00,0.00,3500.00,0.00,'2022-04-09 14:54:32','',''),(2632466,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11840000.00,20000.00,0.00,0.00,'2022-04-10 11:59:33','',''),(2632467,'1','158',NULL,335,'Reception corrector for bridging 132574',0.00,0.00,0.00,20000.00,0.00,'2022-04-10 12:01:10','',''),(2632468,'1','158','781',335,'Received from bridging 132574',0.00,0.00,20000.00,0.00,0.00,'2022-04-10 12:01:10','',''),(2632469,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350556',864320.00,0.00,0.00,1460.00,0.00,'2022-04-10 12:09:57','',''),(2632470,'1','158','781',335,'Distributed to KARU PLANT for sales id:350557',3036960.00,0.00,0.00,5130.00,0.00,'2022-04-10 12:10:23','',''),(2632471,'1','158','781',335,'Distributed to KATAMFE for sales id:350558',3552000.00,0.00,0.00,6000.00,0.00,'2022-04-10 12:11:11','',''),(2632472,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350559',2906720.00,0.00,0.00,4910.00,0.00,'2022-04-10 12:11:30','',''),(2632473,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350560',1030080.00,0.00,0.00,1740.00,0.00,'2022-04-10 12:15:57','',''),(2632474,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350561',449920.00,0.00,0.00,760.00,0.00,'2022-04-10 12:18:08','',''),(2632475,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-10 12:20:54','',''),(2632476,'1','158',NULL,335,'Reception corrector for bridging 132575',0.00,0.00,0.00,25000.00,0.00,'2022-04-10 12:22:21','',''),(2632477,'1','158','781',335,'Received from bridging 132575',0.00,0.00,25000.00,0.00,0.00,'2022-04-10 12:22:21','',''),(2632478,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350562',2024640.00,0.00,0.00,3420.00,0.00,'2022-04-10 12:29:56','',''),(2632479,'1','158','781',335,'Distributed to KARU PLANT for sales id:350563',2989600.00,0.00,0.00,5050.00,0.00,'2022-04-10 12:30:13','',''),(2632480,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350564',2729120.00,0.00,0.00,4610.00,0.00,'2022-04-10 12:30:31','',''),(2632481,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350565',3054720.00,0.00,0.00,5160.00,0.00,'2022-04-10 12:30:48','',''),(2632482,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350566',3161280.00,0.00,0.00,5340.00,0.00,'2022-04-10 12:31:08','',''),(2632483,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350567',651200.00,0.00,0.00,1100.00,0.00,'2022-04-10 12:36:21','',''),(2632484,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350568',189440.00,0.00,0.00,320.00,0.00,'2022-04-10 12:38:21','',''),(2632485,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11840000.00,20000.00,0.00,0.00,'2022-04-12 09:21:08','',''),(2632486,'1','158',NULL,335,'Reception corrector for bridging 132576',0.00,0.00,0.00,20000.00,0.00,'2022-04-12 09:22:35','',''),(2632487,'1','158','781',335,'Received from bridging 132576',0.00,0.00,20000.00,0.00,0.00,'2022-04-12 09:22:35','',''),(2632488,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350569',2373920.00,0.00,0.00,4010.00,0.00,'2022-04-12 09:29:49','',''),(2632489,'1','158','781',335,'Distributed to KARU PLANT for sales id:350570',3297440.00,0.00,0.00,5570.00,0.00,'2022-04-12 09:30:49','',''),(2632490,'1','158','781',335,'Distributed to KEFFI LPG SKID for sales id:350571',3060640.00,0.00,0.00,5170.00,0.00,'2022-04-12 09:31:10','',''),(2632491,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350572',2474560.00,0.00,0.00,4180.00,0.00,'2022-04-12 09:31:32','',''),(2632492,'1','158','781',335,'Distributed to KARU PLANT for sales id:350573',414400.00,0.00,0.00,700.00,0.00,'2022-04-12 09:34:21','',''),(2632493,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350574',219040.00,0.00,0.00,370.00,0.00,'2022-04-12 09:36:07','',''),(2632494,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14841440.00,25070.00,0.00,0.00,'2022-04-12 14:10:46','',''),(2632495,'1','158',NULL,335,'Reception corrector for bridging 132577',0.00,0.00,0.00,25070.00,0.00,'2022-04-12 14:11:49','',''),(2632496,'1','158','781',335,'Received from bridging 132577',0.00,0.00,25070.00,0.00,0.00,'2022-04-12 14:11:49','',''),(2632497,'1','158','781',335,'Distributed to KARU PLANT for sales id:350575',2640320.00,0.00,0.00,4460.00,0.00,'2022-04-12 14:14:36','',''),(2632498,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350576',2924480.00,0.00,0.00,4940.00,0.00,'2022-04-12 14:22:05','',''),(2632499,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350577',3143520.00,0.00,0.00,5310.00,0.00,'2022-04-12 14:22:32','',''),(2632500,'1','158','781',335,'Distributed to KATAMFE for sales id:350578',2492320.00,0.00,0.00,4210.00,0.00,'2022-04-12 14:22:49','',''),(2632501,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350579',2871200.00,0.00,0.00,4850.00,0.00,'2022-04-12 14:24:41','',''),(2632502,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350580',663040.00,0.00,0.00,1120.00,0.00,'2022-04-12 14:25:32','',''),(2632503,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350581',106560.00,0.00,0.00,180.00,0.00,'2022-04-12 14:51:00','',''),(2632504,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14740800.00,24900.00,0.00,0.00,'2022-04-13 14:05:55','',''),(2632505,'1','158',NULL,335,'Reception corrector for bridging 132578',0.00,0.00,0.00,24900.00,0.00,'2022-04-13 14:07:45','',''),(2632506,'1','158','780',335,'Received from bridging 132578',0.00,0.00,24900.00,0.00,0.00,'2022-04-13 14:07:45','',''),(2632507,'1','158','780',335,'Distributed to ADO PLANT for sales id:350582',3149440.00,0.00,0.00,5320.00,0.00,'2022-04-13 14:11:21','',''),(2632508,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350583',3066560.00,0.00,0.00,5180.00,0.00,'2022-04-13 14:11:43','',''),(2632509,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350584',3007360.00,0.00,0.00,5080.00,0.00,'2022-04-13 14:17:17','',''),(2632510,'1','158','780',335,'Distributed to KARU PLANT for sales id:350585',3155360.00,0.00,0.00,5330.00,0.00,'2022-04-13 14:17:38','',''),(2632511,'1','158','780',335,'Distributed to LOKOJA LPG  for sales id:350586',2024640.00,0.00,0.00,3420.00,0.00,'2022-04-13 14:17:57','',''),(2632512,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350587',337440.00,0.00,0.00,570.00,0.00,'2022-04-13 14:19:46','',''),(2632513,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-15 15:43:15','',''),(2632514,'1','158',NULL,335,'Reception corrector for bridging 132579',0.00,0.00,0.00,25000.00,0.00,'2022-04-15 15:45:11','',''),(2632515,'1','158','781',335,'Received from bridging 132579',0.00,0.00,25000.00,0.00,0.00,'2022-04-15 15:45:11','',''),(2632516,'1','158','781',335,'Distributed to LOKOJA LPG  for sales id:350588',1491840.00,0.00,0.00,2520.00,0.00,'2022-04-15 15:50:56','',''),(2632517,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350589',2622560.00,0.00,0.00,4430.00,0.00,'2022-04-15 15:51:13','',''),(2632518,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350590',2977760.00,0.00,0.00,5030.00,0.00,'2022-04-15 15:51:33','',''),(2632519,'1','158','781',335,'Distributed to KARU PLANT for sales id:350591',3155360.00,0.00,0.00,5330.00,0.00,'2022-04-15 15:57:10','',''),(2632520,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350592',2983680.00,0.00,0.00,5040.00,0.00,'2022-04-15 15:57:29','',''),(2632521,'1','158','781',335,'Distributed to APO LPG SKID for sales id:350593',1391200.00,0.00,0.00,2350.00,0.00,'2022-04-15 15:57:48','',''),(2632522,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350594',177600.00,0.00,0.00,300.00,0.00,'2022-04-15 16:00:05','',''),(2632523,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14841440.00,25070.00,0.00,0.00,'2022-04-16 11:18:46','',''),(2632524,'1','158',NULL,335,'Reception corrector for bridging 132580',0.00,0.00,0.00,25070.00,0.00,'2022-04-16 11:20:34','',''),(2632525,'1','158','781',335,'Received from bridging 132580',0.00,0.00,25070.00,0.00,0.00,'2022-04-16 11:20:34','',''),(2632526,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350595',2841600.00,0.00,0.00,4800.00,0.00,'2022-04-16 11:30:12','',''),(2632527,'1','158','781',335,'Distributed to KARU PLANT for sales id:350596',3214560.00,0.00,0.00,5430.00,0.00,'2022-04-16 11:30:34','',''),(2632528,'1','158','781',335,'Distributed to KATAMFE for sales id:350597',3226400.00,0.00,0.00,5450.00,0.00,'2022-04-16 11:30:56','',''),(2632529,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350598',3001440.00,0.00,0.00,5070.00,0.00,'2022-04-16 11:31:17','',''),(2632530,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350599',2557440.00,0.00,0.00,4320.00,0.00,'2022-04-16 11:31:37','',''),(2632531,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-04-17 11:52:08','',''),(2632532,'1','158',NULL,335,'Reception corrector for bridging 132581',0.00,0.00,0.00,25000.00,0.00,'2022-04-17 12:16:33','',''),(2632533,'1','158','781',335,'Received from bridging 132581',0.00,0.00,25000.00,0.00,0.00,'2022-04-17 12:16:33','',''),(2632534,'1','158',NULL,335,'Reception corrector for bridging 121248',0.00,0.00,0.00,25000.00,0.00,'2022-04-17 12:19:03','',''),(2632535,'1','158','781',335,'Received from bridging 121248',0.00,0.00,25000.00,0.00,0.00,'2022-04-17 12:19:03','',''),(2632536,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350600',509120.00,0.00,0.00,860.00,0.00,'2022-04-17 12:19:36','',''),(2632537,'1','158','781',335,'Distributed to KARU PLANT for sales id:350601',3137600.00,0.00,0.00,5300.00,0.00,'2022-04-17 12:29:26','',''),(2632538,'1','158','781',335,'Distributed to KEFFI LPG SKID for sales id:350602',3001440.00,0.00,0.00,5070.00,0.00,'2022-04-17 12:29:45','',''),(2632539,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350603',2794240.00,0.00,0.00,4720.00,0.00,'2022-04-17 12:30:03','',''),(2632540,'1','158','781',335,'Distributed to ONE MAN VILLAGE  for sales id:350604',2516000.00,0.00,0.00,4250.00,0.00,'2022-04-17 12:30:22','',''),(2632541,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350605',2752800.00,0.00,0.00,4650.00,0.00,'2022-04-17 12:30:37','',''),(2632542,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350606',88800.00,0.00,0.00,150.00,0.00,'2022-04-17 12:32:31','',''),(2632543,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14646080.00,24740.00,0.00,0.00,'2022-04-18 12:34:36','',''),(2632544,'1','158',NULL,335,'Reception corrector for bridging 132582',0.00,0.00,0.00,24740.00,0.00,'2022-04-18 12:36:45','',''),(2632545,'1','158','780',335,'Received from bridging 132582',0.00,0.00,24740.00,0.00,0.00,'2022-04-18 12:36:45','',''),(2632546,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350607',124320.00,0.00,0.00,210.00,0.00,'2022-04-18 13:32:44','',''),(2632547,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350608',1941760.00,0.00,0.00,3280.00,0.00,'2022-04-18 13:33:03','',''),(2632548,'1','158','780',335,'Distributed to ADO PLANT for sales id:350609',3025120.00,0.00,0.00,5110.00,0.00,'2022-04-18 13:41:56','',''),(2632549,'1','158','780',335,'Distributed to KARU PLANT for sales id:350610',3256000.00,0.00,0.00,5500.00,0.00,'2022-04-18 13:42:14','',''),(2632550,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350611',2853440.00,0.00,0.00,4820.00,0.00,'2022-04-18 13:42:33','',''),(2632551,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350612',2048320.00,0.00,0.00,3460.00,0.00,'2022-04-18 13:42:53','',''),(2632552,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350613',1290560.00,0.00,0.00,2180.00,0.00,'2022-04-18 13:43:11','',''),(2632553,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350614',106560.00,0.00,0.00,180.00,0.00,'2022-04-18 13:45:27','',''),(2632554,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14859200.00,25100.00,0.00,0.00,'2022-04-21 12:37:36','',''),(2632555,'1','158',NULL,335,'Reception corrector for bridging 132583',0.00,0.00,0.00,25100.00,0.00,'2022-04-21 12:39:07','',''),(2632556,'1','158','780',335,'Received from bridging 132583',0.00,0.00,25100.00,0.00,0.00,'2022-04-21 12:39:07','',''),(2632557,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350615',3137600.00,0.00,0.00,5300.00,0.00,'2022-04-21 12:52:06','',''),(2632558,'1','158','780',335,'Distributed to KARU PLANT for sales id:350616',3007360.00,0.00,0.00,5080.00,0.00,'2022-04-21 12:52:22','',''),(2632559,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350617',2995520.00,0.00,0.00,5060.00,0.00,'2022-04-21 12:52:38','',''),(2632560,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350618',2936320.00,0.00,0.00,4960.00,0.00,'2022-04-21 12:52:56','',''),(2632561,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350619',2812000.00,0.00,0.00,4750.00,0.00,'2022-04-21 12:57:15','',''),(2632562,'1','158','780',335,'Distributed to KARU PLANT for sales id:350620',538720.00,0.00,0.00,910.00,0.00,'2022-04-21 12:57:32','',''),(2632563,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14550000.00,25000.00,0.00,0.00,'2022-04-21 13:30:42','',''),(2632564,'1','158',NULL,335,'Reception corrector for bridging 132584',0.00,0.00,0.00,25000.00,0.00,'2022-04-21 13:32:05','',''),(2632565,'1','158','780',335,'Received from bridging 132584',0.00,0.00,25000.00,0.00,0.00,'2022-04-21 13:32:05','',''),(2632566,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350624',2485140.00,0.00,0.00,4270.00,0.00,'2022-04-21 13:38:39','',''),(2632567,'1','158','780',335,'Distributed to LOKOJA LPG  for sales id:350623',3649140.00,0.00,0.00,6270.00,0.00,'2022-04-21 13:39:03','',''),(2632568,'1','158','780',335,'Distributed to KARU PLANT for sales id:350622',2386200.00,0.00,0.00,4100.00,0.00,'2022-04-21 13:39:25','',''),(2632569,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350625',2933280.00,0.00,0.00,5040.00,0.00,'2022-04-21 13:50:07','',''),(2632570,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350626',3096240.00,0.00,0.00,5320.00,0.00,'2022-04-21 13:50:28','',''),(2632571,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14538360.00,24980.00,0.00,0.00,'2022-04-22 12:11:19','',''),(2632572,'1','158',NULL,335,'Reception corrector for bridging 132585',0.00,0.00,0.00,24980.00,0.00,'2022-04-22 12:13:07','',''),(2632573,'1','158','780',335,'Received from bridging 132585',0.00,0.00,24980.00,0.00,0.00,'2022-04-22 12:13:07','',''),(2632574,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350627',436500.00,0.00,0.00,750.00,0.00,'2022-04-22 12:20:17','',''),(2632575,'1','158','780',335,'Distributed to KARU PLANT for sales id:350628',2863440.00,0.00,0.00,4920.00,0.00,'2022-04-22 12:20:41','',''),(2632576,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350629',3067140.00,0.00,0.00,5270.00,0.00,'2022-04-22 12:20:58','',''),(2632577,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350630',2863440.00,0.00,0.00,4920.00,0.00,'2022-04-22 12:36:19','',''),(2632578,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350631',3008940.00,0.00,0.00,5170.00,0.00,'2022-04-22 12:36:38','',''),(2632579,'1','158','780',335,'Distributed to KARU PLANT for sales id:350632',2095200.00,0.00,0.00,3600.00,0.00,'2022-04-22 12:36:56','',''),(2632580,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14014560.00,24080.00,0.00,0.00,'2022-04-23 14:43:05','',''),(2632581,'1','158',NULL,335,'Reception corrector for bridging 132586',0.00,0.00,0.00,24080.00,0.00,'2022-04-23 14:44:33','',''),(2632582,'1','158','780',335,'Received from bridging 132586',0.00,0.00,24080.00,0.00,0.00,'2022-04-23 14:44:33','',''),(2632583,'1','158','780',335,'Distributed to KARU PLANT for sales id:350633',710040.00,0.00,0.00,1220.00,0.00,'2022-04-23 14:46:33','',''),(2632584,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350634',3235920.00,0.00,0.00,5560.00,0.00,'2022-04-23 14:54:35','',''),(2632585,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350635',2543340.00,0.00,0.00,4370.00,0.00,'2022-04-23 14:54:54','',''),(2632586,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350636',2787780.00,0.00,0.00,4790.00,0.00,'2022-04-23 14:55:12','',''),(2632587,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350637',2991480.00,0.00,0.00,5140.00,0.00,'2022-04-23 14:55:29','',''),(2632588,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350638',1111620.00,0.00,0.00,1910.00,0.00,'2022-04-23 14:59:01','',''),(2632589,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350640',279360.00,0.00,0.00,480.00,0.00,'2022-04-23 15:02:55','',''),(2632590,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14456880.00,24840.00,0.00,0.00,'2022-04-25 13:52:43','',''),(2632591,'1','158',NULL,335,'Reception corrector for bridging 132587',0.00,0.00,0.00,24840.00,0.00,'2022-04-25 13:54:27','',''),(2632592,'1','158','780',335,'Received from bridging 132587',0.00,0.00,24840.00,0.00,0.00,'2022-04-25 13:54:27','',''),(2632593,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350641',1856580.00,0.00,0.00,3190.00,0.00,'2022-04-25 14:04:12','',''),(2632594,'1','158','780',335,'Distributed to KATAMFE for sales id:350642',3183540.00,0.00,0.00,5470.00,0.00,'2022-04-25 14:04:29','',''),(2632595,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350643',3230100.00,0.00,0.00,5550.00,0.00,'2022-04-25 14:04:48','',''),(2632596,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350644',1821660.00,0.00,0.00,3130.00,0.00,'2022-04-25 14:06:07','',''),(2632597,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350645',2880900.00,0.00,0.00,4950.00,0.00,'2022-04-25 14:06:30','',''),(2632598,'1','158','780',335,'Distributed to JUDA GAS for sales id:350646',1431720.00,0.00,0.00,2460.00,0.00,'2022-04-25 14:10:49','',''),(2632599,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350647',52380.00,0.00,0.00,90.00,0.00,'2022-04-25 14:12:36','',''),(2632600,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14503440.00,24920.00,0.00,0.00,'2022-04-26 12:36:14','',''),(2632601,'1','158',NULL,335,'Reception corrector for bridging 132588',0.00,0.00,0.00,24920.00,0.00,'2022-04-26 12:43:16','',''),(2632602,'1','158','780',335,'Received from bridging 132588',0.00,0.00,24920.00,0.00,0.00,'2022-04-26 12:43:16','',''),(2632603,'1','158','780',335,'Distributed to JUDA GAS for sales id:350648',1268760.00,0.00,0.00,2180.00,0.00,'2022-04-26 12:49:47','',''),(2632604,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350649',2223240.00,0.00,0.00,3820.00,0.00,'2022-04-26 12:50:21','',''),(2632605,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350650',2892540.00,0.00,0.00,4970.00,0.00,'2022-04-26 12:56:43','',''),(2632606,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350651',3067140.00,0.00,0.00,5270.00,0.00,'2022-04-26 12:57:00','',''),(2632607,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350652',2921640.00,0.00,0.00,5020.00,0.00,'2022-04-26 12:57:19','',''),(2632608,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350653',2130120.00,0.00,0.00,3660.00,0.00,'2022-04-26 12:57:36','',''),(2632609,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14561640.00,25020.00,0.00,0.00,'2022-04-27 14:21:31','',''),(2632610,'1','158',NULL,335,'Reception corrector for bridging 132589',0.00,0.00,0.00,25020.00,0.00,'2022-04-27 14:23:06','',''),(2632611,'1','158','780',335,'Received from bridging 132589',0.00,0.00,25020.00,0.00,0.00,'2022-04-27 14:23:06','',''),(2632612,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350654',1536480.00,0.00,0.00,2640.00,0.00,'2022-04-27 14:26:23','',''),(2632613,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350655',3125340.00,0.00,0.00,5370.00,0.00,'2022-04-27 14:36:50','',''),(2632614,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:350656',3788820.00,0.00,0.00,6510.00,0.00,'2022-04-27 14:37:09','',''),(2632615,'1','158','780',335,'Distributed to GENEP GAS for sales id:350657',5366040.00,0.00,0.00,9220.00,0.00,'2022-04-27 14:37:27','',''),(2632616,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350658',547080.00,0.00,0.00,940.00,0.00,'2022-04-27 14:37:47','',''),(2632617,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350659',197880.00,0.00,0.00,340.00,0.00,'2022-04-27 14:39:34','',''),(2632618,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14538360.00,24980.00,0.00,0.00,'2022-04-28 12:32:17','',''),(2632619,'1','158',NULL,335,'Reception corrector for bridging 132590',0.00,0.00,0.00,24980.00,0.00,'2022-04-28 12:33:35','',''),(2632620,'1','158','780',335,'Received from bridging 132590',0.00,0.00,24980.00,0.00,0.00,'2022-04-28 12:33:35','',''),(2632621,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350660',1740180.00,0.00,0.00,2990.00,0.00,'2022-04-28 12:37:43','',''),(2632622,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350661',3003120.00,0.00,0.00,5160.00,0.00,'2022-04-28 12:49:45','',''),(2632623,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350662',3375600.00,0.00,0.00,5800.00,0.00,'2022-04-28 12:50:05','',''),(2632624,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350663',3003120.00,0.00,0.00,5160.00,0.00,'2022-04-28 12:50:25','',''),(2632625,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350664',3008940.00,0.00,0.00,5170.00,0.00,'2022-04-28 12:56:27','',''),(2632626,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350665',407400.00,0.00,0.00,700.00,0.00,'2022-04-28 12:56:54','',''),(2632627,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14561640.00,25020.00,0.00,0.00,'2022-05-01 11:24:13','',''),(2632628,'1','158',NULL,335,'Reception corrector for bridging 132591',0.00,0.00,0.00,25020.00,0.00,'2022-05-01 11:26:03','',''),(2632629,'1','158','780',335,'Received from bridging 132591',0.00,0.00,25020.00,0.00,0.00,'2022-05-01 11:26:03','',''),(2632630,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350666',2322180.00,0.00,0.00,3990.00,0.00,'2022-05-01 11:37:16','',''),(2632631,'1','158','780',335,'Distributed to JEFF GAS for sales id:350667',5482440.00,0.00,0.00,9420.00,0.00,'2022-05-01 11:37:47','',''),(2632632,'1','158','780',335,'Distributed to EDEMA GAS for sales id:350668',3259200.00,0.00,0.00,5600.00,0.00,'2022-05-01 11:38:14','',''),(2632633,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350669',2927460.00,0.00,0.00,5030.00,0.00,'2022-05-01 11:46:10','',''),(2632634,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350670',570360.00,0.00,0.00,980.00,0.00,'2022-05-01 11:47:00','',''),(2632635,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14398680.00,24740.00,0.00,0.00,'2022-05-04 08:10:52','',''),(2632636,'1','158',NULL,335,'Reception corrector for bridging 132592',0.00,0.00,0.00,24740.00,0.00,'2022-05-04 08:13:12','',''),(2632637,'1','158','781',335,'Received from bridging 132592',0.00,0.00,24740.00,0.00,0.00,'2022-05-04 08:13:12','',''),(2632638,'1','158','781',335,'Distributed to JABI LPG SKID for sales id:350671',2357100.00,0.00,0.00,4050.00,0.00,'2022-05-04 08:20:35','',''),(2632639,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350672',3136980.00,0.00,0.00,5390.00,0.00,'2022-05-04 08:20:58','',''),(2632640,'1','158','781',335,'Distributed to ELOFUSIM GAS for sales id:350673',2828520.00,0.00,0.00,4860.00,0.00,'2022-05-04 08:21:17','',''),(2632641,'1','158','781',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350674',2979840.00,0.00,0.00,5120.00,0.00,'2022-05-04 08:31:54','',''),(2632642,'1','158','781',335,'Distributed to NYANYA LPG SKID for sales id:350675',2816880.00,0.00,0.00,4840.00,0.00,'2022-05-04 08:32:11','',''),(2632643,'1','158','781',335,'Distributed to CITY GATE LPG SKID for sales id:350676',221160.00,0.00,0.00,380.00,0.00,'2022-05-04 08:32:31','',''),(2632644,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350677',58200.00,0.00,0.00,100.00,0.00,'2022-05-04 08:34:38','',''),(2632645,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14480160.00,24880.00,0.00,0.00,'2022-05-04 08:48:01','',''),(2632646,'1','158',NULL,335,'Reception corrector for bridging 132593',0.00,0.00,0.00,24880.00,0.00,'2022-05-04 08:49:29','',''),(2632647,'1','158','780',335,'Received from bridging 132593',0.00,0.00,24880.00,0.00,0.00,'2022-05-04 08:49:29','',''),(2632648,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350678',2677200.00,0.00,0.00,4600.00,0.00,'2022-05-04 08:52:01','',''),(2632649,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350679',3119520.00,0.00,0.00,5360.00,0.00,'2022-05-04 09:09:45','',''),(2632650,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350680',2886720.00,0.00,0.00,4960.00,0.00,'2022-05-04 09:10:04','',''),(2632651,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350681',3177720.00,0.00,0.00,5460.00,0.00,'2022-05-04 09:10:21','',''),(2632652,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350682',2485140.00,0.00,0.00,4270.00,0.00,'2022-05-04 09:10:39','',''),(2632653,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350683',133860.00,0.00,0.00,230.00,0.00,'2022-05-04 09:12:26','',''),(2632654,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14596560.00,25080.00,0.00,0.00,'2022-05-05 11:49:57','',''),(2632655,'1','158',NULL,335,'Reception corrector for bridging 132594',0.00,0.00,0.00,25080.00,0.00,'2022-05-05 11:51:38','',''),(2632656,'1','158','780',335,'Received from bridging 132594',0.00,0.00,25080.00,0.00,0.00,'2022-05-05 11:51:38','',''),(2632657,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350684',442320.00,0.00,0.00,760.00,0.00,'2022-05-05 11:53:44','',''),(2632658,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350685',2700480.00,0.00,0.00,4640.00,0.00,'2022-05-05 12:03:36','',''),(2632659,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350686',2240700.00,0.00,0.00,3850.00,0.00,'2022-05-05 12:03:55','',''),(2632660,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350687',2793600.00,0.00,0.00,4800.00,0.00,'2022-05-05 12:04:15','',''),(2632661,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350688',3078780.00,0.00,0.00,5290.00,0.00,'2022-05-05 12:04:37','',''),(2632662,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350689',3067140.00,0.00,0.00,5270.00,0.00,'2022-05-05 12:11:10','',''),(2632663,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350690',273540.00,0.00,0.00,470.00,0.00,'2022-05-05 12:11:30','',''),(2632664,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14608200.00,25100.00,0.00,0.00,'2022-05-06 11:34:50','',''),(2632665,'1','158',NULL,335,'Reception corrector for bridging 132595',0.00,0.00,0.00,25100.00,0.00,'2022-05-06 11:37:37','',''),(2632666,'1','158','780',335,'Received from bridging 132595',0.00,0.00,25100.00,0.00,0.00,'2022-05-06 11:37:37','',''),(2632667,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350691',2316360.00,0.00,0.00,3980.00,0.00,'2022-05-06 11:40:10','',''),(2632668,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350692',3160260.00,0.00,0.00,5430.00,0.00,'2022-05-06 11:48:15','',''),(2632669,'1','158','780',335,'Distributed to JEFF GAS for sales id:350693',5459160.00,0.00,0.00,9380.00,0.00,'2022-05-06 11:48:32','',''),(2632670,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350694',2927460.00,0.00,0.00,5030.00,0.00,'2022-05-06 11:48:48','',''),(2632671,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350695',744960.00,0.00,0.00,1280.00,0.00,'2022-05-06 11:51:18','',''),(2632672,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14584920.00,25060.00,0.00,0.00,'2022-05-07 09:56:47','',''),(2632673,'1','158',NULL,335,'Reception corrector for bridging 132596',0.00,0.00,0.00,25060.00,0.00,'2022-05-07 09:58:15','',''),(2632674,'1','158','780',335,'Received from bridging 132596',0.00,0.00,25060.00,0.00,0.00,'2022-05-07 09:58:15','',''),(2632675,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350696',2147580.00,0.00,0.00,3690.00,0.00,'2022-05-07 10:06:50','',''),(2632676,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350697',3305760.00,0.00,0.00,5680.00,0.00,'2022-05-07 10:07:08','',''),(2632677,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350698',2933280.00,0.00,0.00,5040.00,0.00,'2022-05-07 10:07:27','',''),(2632678,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350699',2729580.00,0.00,0.00,4690.00,0.00,'2022-05-07 10:07:45','',''),(2632679,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350700',2985660.00,0.00,0.00,5130.00,0.00,'2022-05-07 10:08:03','',''),(2632680,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350701',506340.00,0.00,0.00,870.00,0.00,'2022-05-07 10:11:56','',''),(2632681,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14643120.00,25160.00,0.00,0.00,'2022-05-07 10:48:08','',''),(2632682,'1','158',NULL,335,'Reception corrector for bridging 132597',0.00,0.00,0.00,25160.00,0.00,'2022-05-07 10:49:59','',''),(2632683,'1','158','780',335,'Received from bridging 132597',0.00,0.00,25160.00,0.00,0.00,'2022-05-07 10:49:59','',''),(2632684,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350703',2368740.00,0.00,0.00,4070.00,0.00,'2022-05-07 10:59:25','',''),(2632685,'1','158','780',335,'Distributed to KATAMFE for sales id:350704',3282480.00,0.00,0.00,5640.00,0.00,'2022-05-07 10:59:46','',''),(2632686,'1','158','780',335,'Distributed to KARU PLANT for sales id:350705',3061320.00,0.00,0.00,5260.00,0.00,'2022-05-07 11:00:04','',''),(2632687,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350706',3142800.00,0.00,0.00,5400.00,0.00,'2022-05-07 11:00:22','',''),(2632688,'1','158','780',335,'Distributed to ADO PLANT for sales id:350707',2787780.00,0.00,0.00,4790.00,0.00,'2022-05-07 11:04:30','',''),(2632689,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14550000.00,25000.00,0.00,0.00,'2022-05-08 10:36:36','',''),(2632690,'1','158',NULL,335,'Reception corrector for bridging 132598',0.00,0.00,0.00,25000.00,0.00,'2022-05-08 10:38:09','',''),(2632691,'1','158','780',335,'Received from bridging 132598',0.00,0.00,25000.00,0.00,0.00,'2022-05-08 10:38:09','',''),(2632692,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:350708',6902520.00,0.00,0.00,11860.00,0.00,'2022-05-08 10:47:34','',''),(2632693,'1','158','780',335,'Distributed to ADO PLANT for sales id:350709',448140.00,0.00,0.00,770.00,0.00,'2022-05-08 10:47:54','',''),(2632694,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350710',2974020.00,0.00,0.00,5110.00,0.00,'2022-05-08 10:48:17','',''),(2632695,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350711',3590940.00,0.00,0.00,6170.00,0.00,'2022-05-08 10:48:57','',''),(2632696,'1','158','780',335,'Distributed to KATAMFE for sales id:350712',634380.00,0.00,0.00,1090.00,0.00,'2022-05-08 10:49:19','',''),(2632697,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14515080.00,24940.00,0.00,0.00,'2022-05-10 11:55:51','',''),(2632698,'1','158',NULL,335,'Reception corrector for bridging 132599',0.00,0.00,0.00,24940.00,0.00,'2022-05-10 11:58:26','',''),(2632699,'1','158','780',335,'Received from bridging 132599',0.00,0.00,24940.00,0.00,0.00,'2022-05-10 11:58:26','',''),(2632700,'1','158','780',335,'Distributed to KATAMFE for sales id:350713',2223240.00,0.00,0.00,3820.00,0.00,'2022-05-10 12:06:02','',''),(2632701,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350714',2397840.00,0.00,0.00,4120.00,0.00,'2022-05-10 12:06:21','',''),(2632702,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350715',2712120.00,0.00,0.00,4660.00,0.00,'2022-05-10 12:06:39','',''),(2632703,'1','158','780',335,'Distributed to KARU PLANT for sales id:350716',2589900.00,0.00,0.00,4450.00,0.00,'2022-05-10 12:06:58','',''),(2632704,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350717',2269800.00,0.00,0.00,3900.00,0.00,'2022-05-10 12:07:17','',''),(2632705,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350718',1810020.00,0.00,0.00,3110.00,0.00,'2022-05-10 12:12:20','',''),(2632706,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350719',360840.00,0.00,0.00,620.00,0.00,'2022-05-10 12:12:38','',''),(2632707,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350720',128040.00,0.00,0.00,220.00,0.00,'2022-05-10 12:14:23','',''),(2632708,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14515080.00,24940.00,0.00,0.00,'2022-05-12 16:25:01','',''),(2632709,'1','158',NULL,335,'Reception corrector for bridging 132600',0.00,0.00,0.00,24940.00,0.00,'2022-05-12 16:27:09','',''),(2632710,'1','158','780',335,'Received from bridging 132600',0.00,0.00,24940.00,0.00,0.00,'2022-05-12 16:27:09','',''),(2632711,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350721',1920600.00,0.00,0.00,3300.00,0.00,'2022-05-12 16:35:14','',''),(2632712,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350722',1623780.00,0.00,0.00,2790.00,0.00,'2022-05-12 16:35:35','',''),(2632713,'1','158','780',335,'Distributed to KATAMFE for sales id:350723',1780920.00,0.00,0.00,3060.00,0.00,'2022-05-12 16:35:56','',''),(2632714,'1','158','780',335,'Distributed to KARU PLANT for sales id:350724',2636460.00,0.00,0.00,4530.00,0.00,'2022-05-12 16:36:17','',''),(2632715,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350725',2444400.00,0.00,0.00,4200.00,0.00,'2022-05-12 16:42:26','',''),(2632716,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350726',2007900.00,0.00,0.00,3450.00,0.00,'2022-05-12 16:42:46','',''),(2632717,'1','158','780',335,'Distributed to KARU PLANT for sales id:350727',1379340.00,0.00,0.00,2370.00,0.00,'2022-05-12 16:47:34','',''),(2632718,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350728',523800.00,0.00,0.00,900.00,0.00,'2022-05-12 16:51:09','',''),(2632719,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350729',197880.00,0.00,0.00,340.00,0.00,'2022-05-12 16:53:51','',''),(2632720,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14561640.00,25020.00,0.00,0.00,'2022-05-12 16:56:14','',''),(2632721,'1','158',NULL,335,'Reception corrector for bridging 132601',0.00,0.00,0.00,25020.00,0.00,'2022-05-12 16:57:22','',''),(2632722,'1','158','780',335,'Received from bridging 132601',0.00,0.00,25020.00,0.00,0.00,'2022-05-12 16:57:22','',''),(2632723,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350730',1897320.00,0.00,0.00,3260.00,0.00,'2022-05-12 17:02:07','',''),(2632724,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350731',2677200.00,0.00,0.00,4600.00,0.00,'2022-05-12 17:02:26','',''),(2632725,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350732',1123260.00,0.00,0.00,1930.00,0.00,'2022-05-12 17:02:44','',''),(2632726,'1','158','780',335,'Distributed to KATAMFE for sales id:350733',2380380.00,0.00,0.00,4090.00,0.00,'2022-05-12 17:12:11','',''),(2632727,'1','158','780',335,'Distributed to KARU PLANT for sales id:350734',3038040.00,0.00,0.00,5220.00,0.00,'2022-05-12 17:12:31','',''),(2632728,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350735',2787780.00,0.00,0.00,4790.00,0.00,'2022-05-12 17:12:56','',''),(2632729,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350736',587820.00,0.00,0.00,1010.00,0.00,'2022-05-12 17:13:17','',''),(2632730,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350737',69840.00,0.00,0.00,120.00,0.00,'2022-05-12 17:15:06','',''),(2632731,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14579100.00,25050.00,0.00,0.00,'2022-05-13 12:34:46','',''),(2632732,'1','158',NULL,335,'Reception corrector for bridging 132602',0.00,0.00,0.00,25050.00,0.00,'2022-05-13 12:36:14','',''),(2632733,'1','158','780',335,'Received from bridging 132602',0.00,0.00,25050.00,0.00,0.00,'2022-05-13 12:36:14','',''),(2632734,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350738',1903140.00,0.00,0.00,3270.00,0.00,'2022-05-13 12:40:47','',''),(2632735,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350739',2584080.00,0.00,0.00,4440.00,0.00,'2022-05-13 12:41:05','',''),(2632736,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:350740',7787160.00,0.00,0.00,13380.00,0.00,'2022-05-13 12:41:24','',''),(2632737,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350741',2211600.00,0.00,0.00,3800.00,0.00,'2022-05-13 12:44:31','',''),(2632738,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350742',93120.00,0.00,0.00,160.00,0.00,'2022-05-13 12:46:12','',''),(2632739,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14451060.00,24830.00,0.00,0.00,'2022-05-14 12:41:02','',''),(2632740,'1','158',NULL,335,'Reception corrector for bridging 132603',0.00,0.00,0.00,24830.00,0.00,'2022-05-14 12:42:44','',''),(2632741,'1','158','780',335,'Received from bridging 132603',0.00,0.00,24830.00,0.00,0.00,'2022-05-14 12:42:44','',''),(2632742,'1','158','780',335,'Distributed to KARU PLANT for sales id:350744',3113700.00,0.00,0.00,5350.00,0.00,'2022-05-14 12:49:46','',''),(2632743,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350745',2880900.00,0.00,0.00,4950.00,0.00,'2022-05-14 12:50:09','',''),(2632744,'1','158','780',335,'Distributed to ADO PLANT for sales id:350746',3107880.00,0.00,0.00,5340.00,0.00,'2022-05-14 12:50:27','',''),(2632745,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350747',785700.00,0.00,0.00,1350.00,0.00,'2022-05-14 12:50:46','',''),(2632746,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350748',2892540.00,0.00,0.00,4970.00,0.00,'2022-05-14 12:55:24','',''),(2632747,'1','158','780',335,'Distributed to KARU PLANT for sales id:350749',1501560.00,0.00,0.00,2580.00,0.00,'2022-05-14 12:55:49','',''),(2632748,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350750',168780.00,0.00,0.00,290.00,0.00,'2022-05-14 12:57:48','',''),(2632749,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14538360.00,24980.00,0.00,0.00,'2022-05-17 08:47:56','',''),(2632750,'1','158',NULL,335,'Reception corrector for bridging 132604',0.00,0.00,0.00,24980.00,0.00,'2022-05-17 08:49:44','',''),(2632751,'1','158','780',335,'Received from bridging 132604',0.00,0.00,24980.00,0.00,0.00,'2022-05-17 08:49:44','',''),(2632752,'1','158','780',335,'Distributed to KARU PLANT for sales id:350751',1647060.00,0.00,0.00,2830.00,0.00,'2022-05-17 08:55:35','',''),(2632753,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350752',2968200.00,0.00,0.00,5100.00,0.00,'2022-05-17 08:55:54','',''),(2632754,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350753',2886720.00,0.00,0.00,4960.00,0.00,'2022-05-17 08:56:20','',''),(2632755,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350754',3008940.00,0.00,0.00,5170.00,0.00,'2022-05-17 08:56:40','',''),(2632756,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350755',2514240.00,0.00,0.00,4320.00,0.00,'2022-05-17 09:00:54','',''),(2632757,'1','158','780',335,'Distributed to KARU PLANT for sales id:350756',756600.00,0.00,0.00,1300.00,0.00,'2022-05-17 09:01:12','',''),(2632758,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350757',465600.00,0.00,0.00,800.00,0.00,'2022-05-17 09:04:00','',''),(2632759,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350758',291000.00,0.00,0.00,500.00,0.00,'2022-05-17 09:05:53','',''),(2632760,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14817760.00,25030.00,0.00,0.00,'2022-05-18 10:51:49','',''),(2632761,'1','158',NULL,335,'Reception corrector for bridging 132605',0.00,0.00,0.00,25030.00,0.00,'2022-05-18 10:52:58','',''),(2632762,'1','158','780',335,'Received from bridging 132605',0.00,0.00,25030.00,0.00,0.00,'2022-05-18 10:52:58','',''),(2632763,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350759',905760.00,0.00,0.00,1530.00,0.00,'2022-05-18 10:58:45','',''),(2632764,'1','158','780',335,'Distributed to KATAMFE for sales id:350760',1503680.00,0.00,0.00,2540.00,0.00,'2022-05-18 10:59:04','',''),(2632765,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350761',2444960.00,0.00,0.00,4130.00,0.00,'2022-05-18 10:59:23','',''),(2632766,'1','158','780',335,'Distributed to KARU PLANT for sales id:350762',3480960.00,0.00,0.00,5880.00,0.00,'2022-05-18 10:59:41','',''),(2632767,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350763',1947680.00,0.00,0.00,3290.00,0.00,'2022-05-18 11:05:05','',''),(2632768,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350764',2314720.00,0.00,0.00,3910.00,0.00,'2022-05-18 11:05:24','',''),(2632769,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350765',1734560.00,0.00,0.00,2930.00,0.00,'2022-05-18 11:05:43','',''),(2632770,'1','158','780',335,'Distributed to KARU PLANT for sales id:350766',355200.00,0.00,0.00,600.00,0.00,'2022-05-18 11:08:22','',''),(2632771,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350767',130240.00,0.00,0.00,220.00,0.00,'2022-05-18 11:10:10','',''),(2632772,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14764480.00,24940.00,0.00,0.00,'2022-05-20 10:32:27','',''),(2632773,'1','158',NULL,335,'Reception corrector for bridging 132606',0.00,0.00,0.00,24940.00,0.00,'2022-05-20 10:33:34','',''),(2632774,'1','158','780',335,'Received from bridging 132606',0.00,0.00,24940.00,0.00,0.00,'2022-05-20 10:33:34','',''),(2632775,'1','158','780',335,'Distributed to KARU PLANT for sales id:350768',2877120.00,0.00,0.00,4860.00,0.00,'2022-05-20 10:41:50','',''),(2632776,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350769',2137120.00,0.00,0.00,3610.00,0.00,'2022-05-20 10:42:08','',''),(2632777,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350770',2551520.00,0.00,0.00,4310.00,0.00,'2022-05-20 10:42:28','',''),(2632778,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350771',2350240.00,0.00,0.00,3970.00,0.00,'2022-05-20 10:42:49','',''),(2632779,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350772',2403520.00,0.00,0.00,4060.00,0.00,'2022-05-20 10:43:07','',''),(2632780,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350773',2000960.00,0.00,0.00,3380.00,0.00,'2022-05-20 10:43:25','',''),(2632781,'1','158','780',335,'Distributed to KATAMFE for sales id:350774',414400.00,0.00,0.00,700.00,0.00,'2022-05-20 10:46:27','',''),(2632782,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350775',29600.00,0.00,0.00,50.00,0.00,'2022-05-20 10:48:19','',''),(2632783,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14805920.00,25010.00,0.00,0.00,'2022-05-21 09:36:45','',''),(2632784,'1','158',NULL,335,'Reception corrector for bridging 132607',0.00,0.00,0.00,25010.00,0.00,'2022-05-21 09:38:11','',''),(2632785,'1','158','780',335,'Received from bridging 132607',0.00,0.00,25010.00,0.00,0.00,'2022-05-21 09:38:11','',''),(2632786,'1','158','780',335,'Distributed to KATAMFE for sales id:350776',1260960.00,0.00,0.00,2130.00,0.00,'2022-05-21 10:02:09','',''),(2632787,'1','158','780',335,'Distributed to KARU PLANT for sales id:350777',3202720.00,0.00,0.00,5410.00,0.00,'2022-05-21 10:02:28','',''),(2632788,'1','158','780',335,'Distributed to ADO PLANT for sales id:350778',2930400.00,0.00,0.00,4950.00,0.00,'2022-05-21 10:02:48','',''),(2632789,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350779',3256000.00,0.00,0.00,5500.00,0.00,'2022-05-21 10:03:06','',''),(2632790,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350780',1568800.00,0.00,0.00,2650.00,0.00,'2022-05-21 10:08:54','',''),(2632791,'1','158','780',335,'Distributed to KARU PLANT for sales id:350781',2048320.00,0.00,0.00,3460.00,0.00,'2022-05-21 10:09:12','',''),(2632792,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350782',307840.00,0.00,0.00,520.00,0.00,'2022-05-21 10:09:31','',''),(2632793,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350783',230880.00,0.00,0.00,390.00,0.00,'2022-05-21 10:11:44','',''),(2632794,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14871040.00,25120.00,0.00,0.00,'2022-05-22 15:15:40','',''),(2632795,'1','158',NULL,335,'Reception corrector for bridging 132608',0.00,0.00,0.00,25120.00,0.00,'2022-05-22 15:17:02','',''),(2632796,'1','158','780',335,'Received from bridging 132608',0.00,0.00,25120.00,0.00,0.00,'2022-05-22 15:17:02','',''),(2632797,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350784',1823360.00,0.00,0.00,3080.00,0.00,'2022-05-22 15:21:08','',''),(2632798,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350785',2652160.00,0.00,0.00,4480.00,0.00,'2022-05-22 15:21:25','',''),(2632799,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350786',2705440.00,0.00,0.00,4570.00,0.00,'2022-05-22 15:21:42','',''),(2632800,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350787',3072480.00,0.00,0.00,5190.00,0.00,'2022-05-22 15:27:01','',''),(2632801,'1','158','780',335,'Distributed to KARU PLANT for sales id:350788',3267840.00,0.00,0.00,5520.00,0.00,'2022-05-22 15:27:22','',''),(2632802,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350789',1349760.00,0.00,0.00,2280.00,0.00,'2022-05-22 15:27:40','',''),(2632803,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14853280.00,25090.00,0.00,0.00,'2022-05-22 15:43:45','',''),(2632804,'1','158',NULL,335,'Reception corrector for bridging 132609',0.00,0.00,0.00,25090.00,0.00,'2022-05-22 15:45:22','',''),(2632805,'1','158','780',335,'Received from bridging 132609',0.00,0.00,25090.00,0.00,0.00,'2022-05-22 15:45:22','',''),(2632806,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350790',870240.00,0.00,0.00,1470.00,0.00,'2022-05-22 15:48:26','',''),(2632807,'1','158','780',335,'Distributed to KATAMFE for sales id:350791',3226400.00,0.00,0.00,5450.00,0.00,'2022-05-22 15:48:44','',''),(2632808,'1','158','780',335,'Distributed to KARU PLANT for sales id:350793',3256000.00,0.00,0.00,5500.00,0.00,'2022-05-22 15:55:17','',''),(2632809,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350792',3036960.00,0.00,0.00,5130.00,0.00,'2022-05-22 15:55:36','',''),(2632810,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350794',2930400.00,0.00,0.00,4950.00,0.00,'2022-05-22 15:55:55','',''),(2632811,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350795',1480000.00,0.00,0.00,2500.00,0.00,'2022-05-22 15:56:14','',''),(2632812,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350796',53280.00,0.00,0.00,90.00,0.00,'2022-05-22 15:57:49','',''),(2632813,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2022-05-24 16:16:29','',''),(2632814,'1','158',NULL,335,'Reception corrector for bridging 132610',0.00,0.00,0.00,25000.00,0.00,'2022-05-24 16:17:41','',''),(2632815,'1','158','780',335,'Received from bridging 132610',0.00,0.00,25000.00,0.00,0.00,'2022-05-24 16:17:41','',''),(2632816,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350797',1704960.00,0.00,0.00,2880.00,0.00,'2022-05-24 16:21:48','',''),(2632817,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350798',3717760.00,0.00,0.00,6280.00,0.00,'2022-05-24 16:22:19','',''),(2632818,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350799',2936320.00,0.00,0.00,4960.00,0.00,'2022-05-24 16:31:02','',''),(2632819,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350800',2533760.00,0.00,0.00,4280.00,0.00,'2022-05-24 16:31:17','',''),(2632820,'1','158','780',335,'Distributed to ADO PLANT for sales id:350801',603840.00,0.00,0.00,1020.00,0.00,'2022-05-24 16:31:35','',''),(2632821,'1','158','780',335,'Distributed to KARU PLANT for sales id:350802',3303360.00,0.00,0.00,5580.00,0.00,'2022-05-24 16:48:27','',''),(2632822,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14663840.00,24770.00,0.00,0.00,'2022-05-25 11:20:26','',''),(2632823,'1','158',NULL,335,'Reception corrector for bridging 132611',0.00,0.00,0.00,24770.00,0.00,'2022-05-25 11:21:55','',''),(2632824,'1','158','780',335,'Received from bridging 132611',0.00,0.00,24770.00,0.00,0.00,'2022-05-25 11:21:55','',''),(2632825,'1','158','780',335,'Distributed to ADO PLANT for sales id:350803',2587040.00,0.00,0.00,4370.00,0.00,'2022-05-25 11:23:55','',''),(2632826,'1','158','780',335,'Distributed to KATAMFE for sales id:350804',2829760.00,0.00,0.00,4780.00,0.00,'2022-05-25 11:35:32','',''),(2632827,'1','158','780',335,'Distributed to KARU PLANT for sales id:350805',2817920.00,0.00,0.00,4760.00,0.00,'2022-05-25 11:35:53','',''),(2632828,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350806',2350240.00,0.00,0.00,3970.00,0.00,'2022-05-25 11:36:37','',''),(2632829,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350807',2433120.00,0.00,0.00,4110.00,0.00,'2022-05-25 11:37:06','',''),(2632830,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350808',1527360.00,0.00,0.00,2580.00,0.00,'2022-05-25 11:37:25','',''),(2632831,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350809',118400.00,0.00,0.00,200.00,0.00,'2022-05-25 11:40:14','',''),(2632832,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16247840.00,24920.00,0.00,0.00,'2022-05-26 16:33:40','',''),(2632833,'1','158',NULL,335,'Reception corrector for bridging 132612',0.00,0.00,0.00,24920.00,0.00,'2022-05-26 16:34:55','',''),(2632834,'1','158','780',335,'Received from bridging 132612',0.00,0.00,24920.00,0.00,0.00,'2022-05-26 16:34:55','',''),(2632835,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350811',3383880.00,0.00,0.00,5190.00,0.00,'2022-05-26 16:42:43','',''),(2632836,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350812',3559920.00,0.00,0.00,5460.00,0.00,'2022-05-26 16:43:00','',''),(2632837,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350813',3533840.00,0.00,0.00,5420.00,0.00,'2022-05-26 16:43:20','',''),(2632838,'1','158','780',335,'Distributed to KARU PLANT for sales id:350814',3677280.00,0.00,0.00,5640.00,0.00,'2022-05-26 16:43:37','',''),(2632839,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350815',2092920.00,0.00,0.00,3210.00,0.00,'2022-05-26 16:43:58','',''),(2632840,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16560800.00,25400.00,0.00,0.00,'2022-05-26 16:47:46','',''),(2632841,'1','158',NULL,335,'Reception corrector for bridging 132613',0.00,0.00,0.00,25400.00,0.00,'2022-05-26 16:50:08','',''),(2632842,'1','158','780',335,'Received from bridging 132613',0.00,0.00,25400.00,0.00,0.00,'2022-05-26 16:50:08','',''),(2632843,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350816',1284440.00,0.00,0.00,1970.00,0.00,'2022-05-26 17:00:32','',''),(2632844,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:350817',2392840.00,0.00,0.00,3670.00,0.00,'2022-05-26 17:00:49','',''),(2632845,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350818',4159760.00,0.00,0.00,6380.00,0.00,'2022-05-26 17:01:05','',''),(2632846,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:350819',2738400.00,0.00,0.00,4200.00,0.00,'2022-05-26 17:01:22','',''),(2632847,'1','158','780',335,'Distributed to JEFF GAS for sales id:350821',2575400.00,0.00,0.00,3950.00,0.00,'2022-05-26 17:28:31','',''),(2632848,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350820',2973120.00,0.00,0.00,4560.00,0.00,'2022-05-26 17:28:49','',''),(2632849,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350822',436840.00,0.00,0.00,670.00,0.00,'2022-05-26 17:31:17','',''),(2632850,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16443440.00,25220.00,0.00,0.00,'2022-05-27 10:21:33','',''),(2632851,'1','158',NULL,335,'Reception corrector for bridging 132615',0.00,0.00,0.00,25220.00,0.00,'2022-05-27 10:22:47','',''),(2632852,'1','158','780',335,'Received from bridging 132615',0.00,0.00,25220.00,0.00,0.00,'2022-05-27 10:22:47','',''),(2632853,'1','158','780',335,'Distributed to JEFF GAS for sales id:350823',3507760.00,0.00,0.00,5380.00,0.00,'2022-05-27 10:30:13','',''),(2632854,'1','158','780',335,'Distributed to THRESHOLD GAS for sales id:350824',3142640.00,0.00,0.00,4820.00,0.00,'2022-05-27 10:30:30','',''),(2632855,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350825',3735960.00,0.00,0.00,5730.00,0.00,'2022-05-27 10:30:46','',''),(2632856,'1','158','780',335,'Distributed to KARU PLANT for sales id:350826',3514280.00,0.00,0.00,5390.00,0.00,'2022-05-27 10:31:03','',''),(2632857,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350827',2125520.00,0.00,0.00,3260.00,0.00,'2022-05-27 10:31:19','',''),(2632858,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350828',417280.00,0.00,0.00,640.00,0.00,'2022-05-27 10:33:27','',''),(2632859,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16273920.00,24960.00,0.00,0.00,'2022-05-27 15:31:21','',''),(2632860,'1','158',NULL,335,'Reception corrector for bridging 132616',0.00,0.00,0.00,24960.00,0.00,'2022-05-27 15:32:46','',''),(2632861,'1','158','780',335,'Received from bridging 132616',0.00,0.00,24960.00,0.00,0.00,'2022-05-27 15:32:46','',''),(2632862,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:350829',1486560.00,0.00,0.00,2280.00,0.00,'2022-05-27 15:35:06','',''),(2632863,'1','158','780',335,'Distributed to KARU PLANT for sales id:350834',1382240.00,0.00,0.00,2120.00,0.00,'2022-05-27 15:44:00','',''),(2632864,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350830',3488200.00,0.00,0.00,5350.00,0.00,'2022-05-27 15:44:19','',''),(2632865,'1','158','780',335,'Distributed to ADO PLANT for sales id:350831',3442560.00,0.00,0.00,5280.00,0.00,'2022-05-27 15:44:38','',''),(2632866,'1','158','780',335,'Distributed to SUNSHINE GAS for sales id:350832',3344760.00,0.00,0.00,5130.00,0.00,'2022-05-27 15:44:54','',''),(2632867,'1','158','780',335,'Distributed to VINEE GAS for sales id:350833',3129600.00,0.00,0.00,4800.00,0.00,'2022-05-27 15:45:13','',''),(2632868,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16286960.00,24980.00,0.00,0.00,'2022-05-28 16:16:39','',''),(2632869,'1','158',NULL,335,'Reception corrector for bridging 132617',0.00,0.00,0.00,24980.00,0.00,'2022-05-28 16:18:13','',''),(2632870,'1','158','780',335,'Received from bridging 132617',0.00,0.00,24980.00,0.00,0.00,'2022-05-28 16:18:13','',''),(2632871,'1','158','780',335,'Distributed to KARU PLANT for sales id:350835',2960080.00,0.00,0.00,4540.00,0.00,'2022-05-28 16:24:33','',''),(2632872,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350836',3390400.00,0.00,0.00,5200.00,0.00,'2022-05-28 16:24:53','',''),(2632873,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350837',3233920.00,0.00,0.00,4960.00,0.00,'2022-05-28 16:25:13','',''),(2632874,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350838',3201320.00,0.00,0.00,4910.00,0.00,'2022-05-28 16:29:33','',''),(2632875,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350839',3592520.00,0.00,0.00,5510.00,0.00,'2022-05-28 16:29:51','',''),(2632876,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16247840.00,24920.00,0.00,0.00,'2022-05-29 18:09:05','',''),(2632877,'1','158',NULL,335,'Reception corrector for bridging 132618',0.00,0.00,0.00,24920.00,0.00,'2022-05-29 18:10:36','',''),(2632878,'1','158','780',335,'Received from bridging 132618',0.00,0.00,24920.00,0.00,0.00,'2022-05-29 18:10:36','',''),(2632879,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350841',3240440.00,0.00,0.00,4970.00,0.00,'2022-05-29 18:14:58','',''),(2632880,'1','158','780',335,'Distributed to KARU PLANT for sales id:350842',3599040.00,0.00,0.00,5520.00,0.00,'2022-05-29 18:15:18','',''),(2632881,'1','158','780',335,'Distributed to ADO PLANT for sales id:350843',3514280.00,0.00,0.00,5390.00,0.00,'2022-05-29 18:20:37','',''),(2632882,'1','158','780',335,'Distributed to KATAMFE for sales id:350844',3396920.00,0.00,0.00,5210.00,0.00,'2022-05-29 18:20:56','',''),(2632883,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350845',2484120.00,0.00,0.00,3810.00,0.00,'2022-05-29 18:21:15','',''),(2632884,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16286960.00,24980.00,0.00,0.00,'2022-05-30 12:06:41','',''),(2632885,'1','158',NULL,335,'Reception corrector for bridging 132619',0.00,0.00,0.00,24980.00,0.00,'2022-05-30 12:07:50','',''),(2632886,'1','158','780',335,'Received from bridging 132619',0.00,0.00,24980.00,0.00,0.00,'2022-05-30 12:07:50','',''),(2632887,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350846',443360.00,0.00,0.00,680.00,0.00,'2022-05-30 12:18:18','',''),(2632888,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350847',3018760.00,0.00,0.00,4630.00,0.00,'2022-05-30 12:18:54','',''),(2632889,'1','158','780',335,'Distributed to KARU PLANT for sales id:350848',3827240.00,0.00,0.00,5870.00,0.00,'2022-05-30 12:19:15','',''),(2632890,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350849',3149160.00,0.00,0.00,4830.00,0.00,'2022-05-30 12:20:08','',''),(2632891,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350850',2875320.00,0.00,0.00,4410.00,0.00,'2022-05-30 12:20:37','',''),(2632892,'1','158','780',335,'Distributed to KATAMFE for sales id:350851',2836200.00,0.00,0.00,4350.00,0.00,'2022-05-30 12:23:53','',''),(2632893,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350852',58680.00,0.00,0.00,90.00,0.00,'2022-05-30 12:25:26','',''),(2632894,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16260880.00,24940.00,0.00,0.00,'2022-05-31 13:42:14','',''),(2632895,'1','158',NULL,335,'Reception corrector for bridging 132620',0.00,0.00,0.00,24940.00,0.00,'2022-05-31 13:43:29','',''),(2632896,'1','158','780',335,'Received from bridging 132620',0.00,0.00,24940.00,0.00,0.00,'2022-05-31 13:43:29','',''),(2632897,'1','158','780',335,'Distributed to KATAMFE for sales id:350853',404240.00,0.00,0.00,620.00,0.00,'2022-05-31 13:52:20','',''),(2632898,'1','158','780',335,'Distributed to ADO PLANT for sales id:350854',3449080.00,0.00,0.00,5290.00,0.00,'2022-05-31 13:52:40','',''),(2632899,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350855',2660160.00,0.00,0.00,4080.00,0.00,'2022-05-31 13:52:59','',''),(2632900,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350856',2666680.00,0.00,0.00,4090.00,0.00,'2022-05-31 13:53:16','',''),(2632901,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350857',2764480.00,0.00,0.00,4240.00,0.00,'2022-05-31 13:53:35','',''),(2632902,'1','158','780',335,'Distributed to KATAMFE for sales id:350858',3970680.00,0.00,0.00,6090.00,0.00,'2022-05-31 13:53:57','',''),(2632903,'1','158','780',335,'Distributed to KARU PLANT for sales id:350859',345560.00,0.00,0.00,530.00,0.00,'2022-05-31 13:57:34','',''),(2632904,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16300000.00,25000.00,0.00,0.00,'2022-06-01 11:26:04','',''),(2632905,'1','158',NULL,335,'Reception corrector for bridging 132621',0.00,0.00,0.00,25000.00,0.00,'2022-06-01 11:27:17','',''),(2632906,'1','158','781',335,'Received from bridging 132621',0.00,0.00,25000.00,0.00,0.00,'2022-06-01 11:27:17','',''),(2632907,'1','158','781',335,'Distributed to KARU PLANT for sales id:350860',3409960.00,0.00,0.00,5230.00,0.00,'2022-06-01 11:34:39','',''),(2632908,'1','158','781',335,'Distributed to KUJE LPG SKID for sales id:350861',3468640.00,0.00,0.00,5320.00,0.00,'2022-06-01 11:34:57','',''),(2632909,'1','158','781',335,'Distributed to ASOKORO LPG for sales id:350862',3279560.00,0.00,0.00,5030.00,0.00,'2022-06-01 11:35:16','',''),(2632910,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350863',2601480.00,0.00,0.00,3990.00,0.00,'2022-06-01 11:35:33','',''),(2632911,'1','158','781',335,'Distributed to KATAMFE for sales id:350864',3207840.00,0.00,0.00,4920.00,0.00,'2022-06-01 11:35:53','',''),(2632912,'1','158','781',335,'Distributed to LIFE CAMP for sales id:350865',273840.00,0.00,0.00,420.00,0.00,'2022-06-01 11:38:40','',''),(2632913,'1','158','781',335,'Distributed to OPERATIONAL LOSS for sales id:350866',58680.00,0.00,0.00,90.00,0.00,'2022-06-01 11:40:15','',''),(2632914,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16365200.00,25100.00,0.00,0.00,'2022-06-02 11:22:12','',''),(2632915,'1','158',NULL,335,'Reception corrector for bridging 132622',0.00,0.00,0.00,25100.00,0.00,'2022-06-02 11:24:11','',''),(2632916,'1','158','780',335,'Received from bridging 132622',0.00,0.00,25100.00,0.00,0.00,'2022-06-02 11:24:11','',''),(2632917,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350867',1538720.00,0.00,0.00,2360.00,0.00,'2022-06-02 11:34:25','',''),(2632918,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:350868',1323560.00,0.00,0.00,2030.00,0.00,'2022-06-02 11:34:45','',''),(2632919,'1','158','780',335,'Distributed to KARU PLANT for sales id:350869',3116560.00,0.00,0.00,4780.00,0.00,'2022-06-02 11:35:02','',''),(2632920,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350870',3292600.00,0.00,0.00,5050.00,0.00,'2022-06-02 11:35:20','',''),(2632921,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350871',3403440.00,0.00,0.00,5220.00,0.00,'2022-06-02 11:35:39','',''),(2632922,'1','158','780',335,'Distributed to KATAMFE for sales id:350872',2725360.00,0.00,0.00,4180.00,0.00,'2022-06-02 11:38:06','',''),(2632923,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350873',964960.00,0.00,0.00,1480.00,0.00,'2022-06-02 11:38:23','',''),(2632924,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16326080.00,25040.00,0.00,0.00,'2022-06-05 15:23:32','',''),(2632925,'1','158',NULL,335,'Reception corrector for bridging 132623',0.00,0.00,0.00,25040.00,0.00,'2022-06-05 15:24:46','',''),(2632926,'1','158','780',335,'Received from bridging 132623',0.00,0.00,25040.00,0.00,0.00,'2022-06-05 15:24:46','',''),(2632927,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350874',1942960.00,0.00,0.00,2980.00,0.00,'2022-06-05 15:33:16','',''),(2632928,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350875',2581920.00,0.00,0.00,3960.00,0.00,'2022-06-05 15:33:39','',''),(2632929,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350876',3279560.00,0.00,0.00,5030.00,0.00,'2022-06-05 15:34:00','',''),(2632930,'1','158','780',335,'Distributed to KARU PLANT for sales id:350877',3586000.00,0.00,0.00,5500.00,0.00,'2022-06-05 15:34:21','',''),(2632931,'1','158','780',335,'Distributed to KATAMFE for sales id:350878',2810120.00,0.00,0.00,4310.00,0.00,'2022-06-05 15:34:39','',''),(2632932,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350879',2099440.00,0.00,0.00,3220.00,0.00,'2022-06-05 15:35:01','',''),(2632933,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350880',26080.00,0.00,0.00,40.00,0.00,'2022-06-05 15:36:44','',''),(2632934,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-06-05 16:20:41','',''),(2632935,'1','158',NULL,335,'Reception corrector for bridging 132624',0.00,0.00,0.00,24980.00,0.00,'2022-06-05 16:22:11','',''),(2632936,'1','158','780',335,'Received from bridging 132624',0.00,0.00,24980.00,0.00,0.00,'2022-06-05 16:22:11','',''),(2632937,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350881',1552320.00,0.00,0.00,2310.00,0.00,'2022-06-05 16:27:16','',''),(2632938,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350882',3151680.00,0.00,0.00,4690.00,0.00,'2022-06-05 16:27:33','',''),(2632939,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:350883',2210880.00,0.00,0.00,3290.00,0.00,'2022-06-05 16:27:52','',''),(2632940,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350884',3467520.00,0.00,0.00,5160.00,0.00,'2022-06-05 16:36:54','',''),(2632941,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350885',3433920.00,0.00,0.00,5110.00,0.00,'2022-06-05 16:37:12','',''),(2632942,'1','158','780',335,'Distributed to KARU PLANT for sales id:350886',2728320.00,0.00,0.00,4060.00,0.00,'2022-06-05 16:38:35','',''),(2632943,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350887',241920.00,0.00,0.00,360.00,0.00,'2022-06-05 16:40:12','',''),(2632944,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-05 16:45:06','',''),(2632945,'1','158',NULL,335,'Reception corrector for bridging 132625',0.00,0.00,0.00,25000.00,0.00,'2022-06-05 16:46:46','',''),(2632946,'1','158','780',335,'Received from bridging 132625',0.00,0.00,25000.00,0.00,0.00,'2022-06-05 16:46:46','',''),(2632947,'1','158','780',335,'Distributed to KARU PLANT for sales id:350888',1008000.00,0.00,0.00,1500.00,0.00,'2022-06-05 16:50:02','',''),(2632948,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350889',3796800.00,0.00,0.00,5650.00,0.00,'2022-06-05 16:50:28','',''),(2632949,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350890',3756480.00,0.00,0.00,5590.00,0.00,'2022-06-05 16:56:57','',''),(2632950,'1','158','780',335,'Distributed to KARU PLANT for sales id:350891',3917760.00,0.00,0.00,5830.00,0.00,'2022-06-05 16:57:14','',''),(2632951,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350892',3003840.00,0.00,0.00,4470.00,0.00,'2022-06-05 16:57:32','',''),(2632952,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350893',1317120.00,0.00,0.00,1960.00,0.00,'2022-06-05 17:00:40','',''),(2632953,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-06 11:29:59','',''),(2632954,'1','158',NULL,335,'Reception corrector for bridging 132626',0.00,0.00,0.00,25000.00,0.00,'2022-06-06 11:31:22','',''),(2632955,'1','158','780',335,'Received from bridging 132626',0.00,0.00,25000.00,0.00,0.00,'2022-06-06 11:31:22','',''),(2632956,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350894',2224320.00,0.00,0.00,3310.00,0.00,'2022-06-06 11:41:55','',''),(2632957,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350895',3427200.00,0.00,0.00,5100.00,0.00,'2022-06-06 11:42:17','',''),(2632958,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350896',3669120.00,0.00,0.00,5460.00,0.00,'2022-06-06 11:42:47','',''),(2632959,'1','158','780',335,'Distributed to KARU PLANT for sales id:350897',3124800.00,0.00,0.00,4650.00,0.00,'2022-06-06 11:43:11','',''),(2632960,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350898',3286080.00,0.00,0.00,4890.00,0.00,'2022-06-06 11:43:43','',''),(2632961,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350899',1008000.00,0.00,0.00,1500.00,0.00,'2022-06-06 11:44:11','',''),(2632962,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350900',60480.00,0.00,0.00,90.00,0.00,'2022-06-06 11:46:28','',''),(2632963,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16746240.00,24920.00,0.00,0.00,'2022-06-07 17:04:31','',''),(2632964,'1','158',NULL,335,'Reception corrector for bridging 132627',0.00,0.00,0.00,24920.00,0.00,'2022-06-07 17:05:48','',''),(2632965,'1','158','780',335,'Received from bridging 132627',0.00,0.00,24920.00,0.00,0.00,'2022-06-07 17:05:48','',''),(2632966,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350901',3171840.00,0.00,0.00,4720.00,0.00,'2022-06-07 17:08:40','',''),(2632967,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350902',3554880.00,0.00,0.00,5290.00,0.00,'2022-06-07 17:14:28','',''),(2632968,'1','158','780',335,'Distributed to KARU PLANT for sales id:350903',3870720.00,0.00,0.00,5760.00,0.00,'2022-06-07 17:14:47','',''),(2632969,'1','158','780',335,'Distributed to KATAMFE for sales id:350904',2493120.00,0.00,0.00,3710.00,0.00,'2022-06-07 17:15:05','',''),(2632970,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350905',3575040.00,0.00,0.00,5320.00,0.00,'2022-06-07 17:17:42','',''),(2632971,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350906',80640.00,0.00,0.00,120.00,0.00,'2022-06-07 17:19:14','',''),(2632972,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-14 10:23:00','',''),(2632973,'1','158',NULL,335,'Reception corrector for bridging 132628',0.00,0.00,0.00,25000.00,0.00,'2022-06-14 10:24:34','',''),(2632974,'1','158','780',335,'Received from bridging 132628',0.00,0.00,25000.00,0.00,0.00,'2022-06-14 10:24:34','',''),(2632975,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350907',362880.00,0.00,0.00,540.00,0.00,'2022-06-14 10:29:18','',''),(2632976,'1','158','780',335,'Distributed to KARU PLANT for sales id:350908',3480960.00,0.00,0.00,5180.00,0.00,'2022-06-14 10:29:36','',''),(2632977,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350909',3239040.00,0.00,0.00,4820.00,0.00,'2022-06-14 10:29:53','',''),(2632978,'1','158','780',335,'Distributed to KARU PLANT for sales id:350910',3326400.00,0.00,0.00,4950.00,0.00,'2022-06-14 10:33:04','',''),(2632979,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350911',2795520.00,0.00,0.00,4160.00,0.00,'2022-06-14 10:39:19','',''),(2632980,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350912',3568320.00,0.00,0.00,5310.00,0.00,'2022-06-14 10:39:37','',''),(2632981,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350913',26880.00,0.00,0.00,40.00,0.00,'2022-06-14 10:41:55','',''),(2632982,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16746240.00,24920.00,0.00,0.00,'2022-06-14 10:45:42','',''),(2632983,'1','158',NULL,335,'Reception corrector for bridging 132629',0.00,0.00,0.00,24920.00,0.00,'2022-06-14 10:48:48','',''),(2632984,'1','158','780',335,'Received from bridging 132629',0.00,0.00,24920.00,0.00,0.00,'2022-06-14 10:48:48','',''),(2632985,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350914',3400320.00,0.00,0.00,5060.00,0.00,'2022-06-14 10:56:18','',''),(2632986,'1','158','780',335,'Distributed to KARU PLANT for sales id:350915',3346560.00,0.00,0.00,4980.00,0.00,'2022-06-14 10:56:34','',''),(2632987,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350916',3400320.00,0.00,0.00,5060.00,0.00,'2022-06-14 10:56:52','',''),(2632988,'1','158','780',335,'Distributed to KATAMFE for sales id:350917',3911040.00,0.00,0.00,5820.00,0.00,'2022-06-14 10:57:10','',''),(2632989,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350918',2688000.00,0.00,0.00,4000.00,0.00,'2022-06-14 11:01:27','',''),(2632990,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-14 11:05:09','',''),(2632991,'1','158',NULL,335,'Reception corrector for bridging 132630',0.00,0.00,0.00,25000.00,0.00,'2022-06-14 11:07:33','',''),(2632992,'1','158','780',335,'Received from bridging 132630',0.00,0.00,25000.00,0.00,0.00,'2022-06-14 11:07:33','',''),(2632993,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350919',792960.00,0.00,0.00,1180.00,0.00,'2022-06-14 11:37:29','',''),(2632994,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350920',4052160.00,0.00,0.00,6030.00,0.00,'2022-06-14 11:37:49','',''),(2632995,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:350921',2560320.00,0.00,0.00,3810.00,0.00,'2022-06-14 11:38:08','',''),(2632996,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350922',3501120.00,0.00,0.00,5210.00,0.00,'2022-06-14 11:38:26','',''),(2632997,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350923',3507840.00,0.00,0.00,5220.00,0.00,'2022-06-14 11:38:44','',''),(2632998,'1','158','780',335,'Distributed to KARU PLANT for sales id:350924',2365440.00,0.00,0.00,3520.00,0.00,'2022-06-14 11:39:02','',''),(2632999,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350926',20160.00,0.00,0.00,30.00,0.00,'2022-06-14 11:42:00','',''),(2633000,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16759680.00,24940.00,0.00,0.00,'2022-06-14 11:44:02','',''),(2633001,'1','158',NULL,335,'Reception corrector for bridging 132631',0.00,0.00,0.00,24940.00,0.00,'2022-06-14 11:45:14','',''),(2633002,'1','158','780',335,'Received from bridging 132631',0.00,0.00,24940.00,0.00,0.00,'2022-06-14 11:45:14','',''),(2633003,'1','158','780',335,'Distributed to KARU PLANT for sales id:350927',1276800.00,0.00,0.00,1900.00,0.00,'2022-06-14 11:47:14','',''),(2633004,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350928',3407040.00,0.00,0.00,5070.00,0.00,'2022-06-14 11:58:12','',''),(2633005,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350929',3548160.00,0.00,0.00,5280.00,0.00,'2022-06-14 11:58:34','',''),(2633006,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350930',3480960.00,0.00,0.00,5180.00,0.00,'2022-06-14 11:58:52','',''),(2633007,'1','158','780',335,'Distributed to KARU PLANT for sales id:350931',3541440.00,0.00,0.00,5270.00,0.00,'2022-06-14 11:59:13','',''),(2633008,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350932',1364160.00,0.00,0.00,2030.00,0.00,'2022-06-14 12:10:21','',''),(2633009,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350933',141120.00,0.00,0.00,210.00,0.00,'2022-06-14 12:12:21','',''),(2633010,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-14 12:14:44','',''),(2633011,'1','158',NULL,335,'Reception corrector for bridging 132632',0.00,0.00,0.00,25000.00,0.00,'2022-06-14 12:16:50','',''),(2633012,'1','158','780',335,'Received from bridging 132632',0.00,0.00,25000.00,0.00,0.00,'2022-06-14 12:16:50','',''),(2633013,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350934',2076480.00,0.00,0.00,3090.00,0.00,'2022-06-14 12:35:56','',''),(2633014,'1','158','780',335,'Distributed to KATAMFE for sales id:350935',3507840.00,0.00,0.00,5220.00,0.00,'2022-06-14 12:36:16','',''),(2633015,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350936',3581760.00,0.00,0.00,5330.00,0.00,'2022-06-14 12:36:34','',''),(2633016,'1','158','780',335,'Distributed to KARU PLANT for sales id:350937',3682560.00,0.00,0.00,5480.00,0.00,'2022-06-14 12:36:54','',''),(2633017,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350938',3178560.00,0.00,0.00,4730.00,0.00,'2022-06-14 12:37:13','',''),(2633018,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350939',604800.00,0.00,0.00,900.00,0.00,'2022-06-14 12:39:52','',''),(2633019,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350940',168000.00,0.00,0.00,250.00,0.00,'2022-06-14 12:41:38','',''),(2633020,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-06-14 12:44:33','',''),(2633021,'1','158',NULL,335,'Reception corrector for bridging 132633',0.00,0.00,0.00,25000.00,0.00,'2022-06-14 12:50:39','',''),(2633022,'1','158','780',335,'Received from bridging 132633',0.00,0.00,25000.00,0.00,0.00,'2022-06-14 12:50:39','',''),(2633023,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350941',2782080.00,0.00,0.00,4140.00,0.00,'2022-06-14 12:59:12','',''),(2633024,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350942',3487680.00,0.00,0.00,5190.00,0.00,'2022-06-14 12:59:32','',''),(2633025,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:350943',3205440.00,0.00,0.00,4770.00,0.00,'2022-06-14 12:59:52','',''),(2633026,'1','158','780',335,'Distributed to KATAMFE for sales id:350944',3373440.00,0.00,0.00,5020.00,0.00,'2022-06-14 13:00:12','',''),(2633027,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350945',3669120.00,0.00,0.00,5460.00,0.00,'2022-06-14 13:00:33','',''),(2633028,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350946',282240.00,0.00,0.00,420.00,0.00,'2022-06-14 13:00:52','',''),(2633029,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16773120.00,24960.00,0.00,0.00,'2022-06-15 11:44:19','',''),(2633030,'1','158',NULL,335,'Reception corrector for bridging 132634',0.00,0.00,0.00,24960.00,0.00,'2022-06-15 11:45:30','',''),(2633031,'1','158','780',335,'Received from bridging 132634',0.00,0.00,24960.00,0.00,0.00,'2022-06-15 11:45:30','',''),(2633032,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350947',3252480.00,0.00,0.00,4840.00,0.00,'2022-06-15 11:48:52','',''),(2633033,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350948',3487680.00,0.00,0.00,5190.00,0.00,'2022-06-15 11:49:12','',''),(2633034,'1','158','780',335,'Distributed to KARU PLANT for sales id:350949',3769920.00,0.00,0.00,5610.00,0.00,'2022-06-15 11:54:33','',''),(2633035,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350950',3608640.00,0.00,0.00,5370.00,0.00,'2022-06-15 11:54:51','',''),(2633036,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350951',2654400.00,0.00,0.00,3950.00,0.00,'2022-06-15 11:55:11','',''),(2633037,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16759680.00,24940.00,0.00,0.00,'2022-06-16 15:25:30','',''),(2633038,'1','158',NULL,335,'Reception corrector for bridging 132635',0.00,0.00,0.00,24940.00,0.00,'2022-06-16 15:27:16','',''),(2633039,'1','158','780',335,'Received from bridging 132635',0.00,0.00,24940.00,0.00,0.00,'2022-06-16 15:27:16','',''),(2633040,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350952',967680.00,0.00,0.00,1440.00,0.00,'2022-06-16 15:29:59','',''),(2633041,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:350953',3319680.00,0.00,0.00,4940.00,0.00,'2022-06-16 15:37:09','',''),(2633042,'1','158','780',335,'Distributed to KARU PLANT for sales id:350954',4186560.00,0.00,0.00,6230.00,0.00,'2022-06-16 15:37:33','',''),(2633043,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350955',3669120.00,0.00,0.00,5460.00,0.00,'2022-06-16 15:37:52','',''),(2633044,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350956',3937920.00,0.00,0.00,5860.00,0.00,'2022-06-16 15:42:53','',''),(2633045,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350957',524160.00,0.00,0.00,780.00,0.00,'2022-06-16 15:43:15','',''),(2633046,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:350958',154560.00,0.00,0.00,230.00,0.00,'2022-06-16 15:46:20','',''),(2633047,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-06-17 11:21:19','',''),(2633048,'1','158',NULL,335,'Reception corrector for bridging 132636',0.00,0.00,0.00,24980.00,0.00,'2022-06-17 11:22:33','',''),(2633049,'1','158','780',335,'Received from bridging 132636',0.00,0.00,24980.00,0.00,0.00,'2022-06-17 11:22:33','',''),(2633050,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350959',2735040.00,0.00,0.00,4070.00,0.00,'2022-06-17 11:36:05','',''),(2633051,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350960',3326400.00,0.00,0.00,4950.00,0.00,'2022-06-17 11:36:24','',''),(2633052,'1','158','780',335,'Distributed to ADO PLANT for sales id:350961',3373440.00,0.00,0.00,5020.00,0.00,'2022-06-17 11:36:43','',''),(2633053,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350962',3447360.00,0.00,0.00,5130.00,0.00,'2022-06-17 11:37:00','',''),(2633054,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350963',4105920.00,0.00,0.00,6110.00,0.00,'2022-06-17 11:39:36','',''),(2633055,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16739520.00,24910.00,0.00,0.00,'2022-06-18 17:23:36','',''),(2633056,'1','158',NULL,335,'Reception corrector for bridging 132637',0.00,0.00,0.00,24910.00,0.00,'2022-06-18 17:26:55','',''),(2633057,'1','158','780',335,'Received from bridging 132637',0.00,0.00,24910.00,0.00,0.00,'2022-06-18 17:26:55','',''),(2633058,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350965',3615360.00,0.00,0.00,5380.00,0.00,'2022-06-18 17:31:02','',''),(2633059,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:350966',3588480.00,0.00,0.00,5340.00,0.00,'2022-06-18 17:31:27','',''),(2633060,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:350967',3958080.00,0.00,0.00,5890.00,0.00,'2022-06-18 17:40:37','',''),(2633061,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350969',3467520.00,0.00,0.00,5160.00,0.00,'2022-06-18 17:40:56','',''),(2633062,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350970',2036160.00,0.00,0.00,3030.00,0.00,'2022-06-18 17:41:15','',''),(2633063,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16759680.00,24940.00,0.00,0.00,'2022-06-19 11:31:51','',''),(2633064,'1','158',NULL,335,'Reception corrector for bridging 132638',0.00,0.00,0.00,24940.00,0.00,'2022-06-19 11:33:27','',''),(2633065,'1','158','780',335,'Received from bridging 132638',0.00,0.00,24940.00,0.00,0.00,'2022-06-19 11:33:27','',''),(2633066,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350971',1545600.00,0.00,0.00,2300.00,0.00,'2022-06-19 11:39:50','',''),(2633067,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350972',4341120.00,0.00,0.00,6460.00,0.00,'2022-06-19 11:40:30','',''),(2633068,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350973',3897600.00,0.00,0.00,5800.00,0.00,'2022-06-19 11:41:20','',''),(2633069,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350974',3514560.00,0.00,0.00,5230.00,0.00,'2022-06-19 11:45:48','',''),(2633070,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350975',3440640.00,0.00,0.00,5120.00,0.00,'2022-06-19 11:46:47','',''),(2633071,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-06-22 09:45:53','',''),(2633072,'1','158',NULL,335,'Reception corrector for bridging 132639',0.00,0.00,0.00,24980.00,0.00,'2022-06-22 09:47:07','',''),(2633073,'1','158','780',335,'Received from bridging 132639',0.00,0.00,24980.00,0.00,0.00,'2022-06-22 09:47:07','',''),(2633074,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350976',3548160.00,0.00,0.00,5280.00,0.00,'2022-06-22 09:49:09','',''),(2633075,'1','158','780',335,'Distributed to ADO PLANT for sales id:350977',4065600.00,0.00,0.00,6050.00,0.00,'2022-06-22 09:56:01','',''),(2633076,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:350978',3279360.00,0.00,0.00,4880.00,0.00,'2022-06-22 09:56:21','',''),(2633077,'1','158','780',335,'Distributed to APO LPG SKID for sales id:350979',3507840.00,0.00,0.00,5220.00,0.00,'2022-06-22 09:56:41','',''),(2633078,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350980',2372160.00,0.00,0.00,3530.00,0.00,'2022-06-22 09:57:00','',''),(2633079,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-06-22 16:23:30','',''),(2633080,'1','158',NULL,335,'Reception corrector for bridging 132640',0.00,0.00,0.00,24980.00,0.00,'2022-06-22 16:24:42','',''),(2633081,'1','158','780',335,'Received from bridging 132640',0.00,0.00,24980.00,0.00,0.00,'2022-06-22 16:24:42','',''),(2633082,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350981',1189440.00,0.00,0.00,1770.00,0.00,'2022-06-22 16:28:47','',''),(2633083,'1','158','780',335,'Distributed to LIFE CAMP for sales id:350982',4092480.00,0.00,0.00,6090.00,0.00,'2022-06-22 16:36:31','',''),(2633084,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350983',3501120.00,0.00,0.00,5210.00,0.00,'2022-06-22 16:36:50','',''),(2633085,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350984',3380160.00,0.00,0.00,5030.00,0.00,'2022-06-22 16:37:09','',''),(2633086,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350985',3655680.00,0.00,0.00,5440.00,0.00,'2022-06-22 16:37:28','',''),(2633087,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:350986',967680.00,0.00,0.00,1440.00,0.00,'2022-06-22 16:40:33','',''),(2633088,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16705920.00,24860.00,0.00,0.00,'2022-06-23 11:44:17','',''),(2633089,'1','158',NULL,335,'Reception corrector for bridging 132641',0.00,0.00,0.00,24860.00,0.00,'2022-06-23 11:45:44','',''),(2633090,'1','158','780',335,'Received from bridging 132641',0.00,0.00,24860.00,0.00,0.00,'2022-06-23 11:45:44','',''),(2633091,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:350987',2627520.00,0.00,0.00,3910.00,0.00,'2022-06-23 11:57:53','',''),(2633092,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:350988',3474240.00,0.00,0.00,5170.00,0.00,'2022-06-23 11:58:12','',''),(2633093,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350989',2311680.00,0.00,0.00,3440.00,0.00,'2022-06-23 11:58:47','',''),(2633094,'1','158','780',335,'Distributed to KARU PLANT for sales id:350990',8292480.00,0.00,0.00,12340.00,0.00,'2022-06-23 11:59:14','',''),(2633095,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16705920.00,24860.00,0.00,0.00,'2022-06-24 15:16:52','',''),(2633096,'1','158',NULL,335,'Reception corrector for bridging 132642',0.00,0.00,0.00,24860.00,0.00,'2022-06-24 15:18:02','',''),(2633097,'1','158','780',335,'Received from bridging 132642',0.00,0.00,24860.00,0.00,0.00,'2022-06-24 15:18:02','',''),(2633098,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350991',1438080.00,0.00,0.00,2140.00,0.00,'2022-06-24 15:24:38','',''),(2633099,'1','158','780',335,'Distributed to KARU PLANT for sales id:350992',3514560.00,0.00,0.00,5230.00,0.00,'2022-06-24 15:30:00','',''),(2633100,'1','158','780',335,'Distributed to MUNAH GAS for sales id:350993',3628800.00,0.00,0.00,5400.00,0.00,'2022-06-24 15:30:31','',''),(2633101,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:350994',3642240.00,0.00,0.00,5420.00,0.00,'2022-06-24 15:30:57','',''),(2633102,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:350995',3454080.00,0.00,0.00,5140.00,0.00,'2022-06-24 15:37:24','',''),(2633103,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350996',1028160.00,0.00,0.00,1530.00,0.00,'2022-06-24 15:39:15','',''),(2633104,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16826880.00,25040.00,0.00,0.00,'2022-06-26 12:42:09','',''),(2633105,'1','158',NULL,335,'Reception corrector for bridging 132643',0.00,0.00,0.00,25040.00,0.00,'2022-06-26 12:43:40','',''),(2633106,'1','158','780',335,'Received from bridging 132643',0.00,0.00,25040.00,0.00,0.00,'2022-06-26 12:43:40','',''),(2633107,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:350997',2399040.00,0.00,0.00,3570.00,0.00,'2022-06-26 12:48:46','',''),(2633108,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:350998',3924480.00,0.00,0.00,5840.00,0.00,'2022-06-26 12:49:04','',''),(2633109,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:350999',3722880.00,0.00,0.00,5540.00,0.00,'2022-06-26 12:49:22','',''),(2633110,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351000',3514560.00,0.00,0.00,5230.00,0.00,'2022-06-26 12:53:14','',''),(2633111,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351001',3265920.00,0.00,0.00,4860.00,0.00,'2022-06-26 12:53:34','',''),(2633112,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16826880.00,25040.00,0.00,0.00,'2022-06-27 12:16:28','',''),(2633113,'1','158',NULL,335,'Reception corrector for bridging 132644',0.00,0.00,0.00,25040.00,0.00,'2022-06-27 12:17:39','',''),(2633114,'1','158','780',335,'Received from bridging 132644',0.00,0.00,25040.00,0.00,0.00,'2022-06-27 12:17:39','',''),(2633115,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351002',571200.00,0.00,0.00,850.00,0.00,'2022-06-27 12:20:55','',''),(2633116,'1','158','780',335,'Distributed to ADO PLANT for sales id:351003',3447360.00,0.00,0.00,5130.00,0.00,'2022-06-27 12:21:14','',''),(2633117,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351004',3494400.00,0.00,0.00,5200.00,0.00,'2022-06-27 12:32:05','',''),(2633118,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351005',3763200.00,0.00,0.00,5600.00,0.00,'2022-06-27 12:32:24','',''),(2633119,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351006',3554880.00,0.00,0.00,5290.00,0.00,'2022-06-27 12:34:33','',''),(2633120,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351007',1868160.00,0.00,0.00,2780.00,0.00,'2022-06-27 12:34:53','',''),(2633121,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351008',33600.00,0.00,0.00,50.00,0.00,'2022-06-27 12:38:08','',''),(2633122,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16732800.00,24900.00,0.00,0.00,'2022-06-29 11:25:55','',''),(2633123,'1','158',NULL,335,'Reception corrector for bridging 132645',0.00,0.00,0.00,24900.00,0.00,'2022-06-29 11:28:18','',''),(2633124,'1','158','780',335,'Received from bridging 132645',0.00,0.00,24900.00,0.00,0.00,'2022-06-29 11:28:18','',''),(2633125,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351009',1659840.00,0.00,0.00,2470.00,0.00,'2022-06-29 11:32:30','',''),(2633126,'1','158','780',335,'Distributed to N.U SYNERGY LTD for sales id:351010',2264640.00,0.00,0.00,3370.00,0.00,'2022-06-29 11:32:49','',''),(2633127,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351011',3407040.00,0.00,0.00,5070.00,0.00,'2022-06-29 11:35:41','',''),(2633128,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351012',3467520.00,0.00,0.00,5160.00,0.00,'2022-06-29 11:41:32','',''),(2633129,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351013',3675840.00,0.00,0.00,5470.00,0.00,'2022-06-29 11:41:52','',''),(2633130,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351014',2190720.00,0.00,0.00,3260.00,0.00,'2022-06-29 11:42:12','',''),(2633131,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351015',67200.00,0.00,0.00,100.00,0.00,'2022-06-29 11:43:55','',''),(2633132,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16652160.00,24780.00,0.00,0.00,'2022-06-30 12:33:08','',''),(2633133,'1','158',NULL,335,'Reception corrector for bridging 132646',0.00,0.00,0.00,24780.00,0.00,'2022-06-30 12:35:27','',''),(2633134,'1','158','780',335,'Received from bridging 132646',0.00,0.00,24780.00,0.00,0.00,'2022-06-30 12:35:27','',''),(2633135,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351016',1034880.00,0.00,0.00,1540.00,0.00,'2022-06-30 12:39:03','',''),(2633136,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351017',3588480.00,0.00,0.00,5340.00,0.00,'2022-06-30 12:39:25','',''),(2633137,'1','158','780',335,'Distributed to ADO PLANT for sales id:351018',3675840.00,0.00,0.00,5470.00,0.00,'2022-06-30 12:51:44','',''),(2633138,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351019',3615360.00,0.00,0.00,5380.00,0.00,'2022-06-30 12:52:06','',''),(2633139,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351020',3682560.00,0.00,0.00,5480.00,0.00,'2022-06-30 12:52:40','',''),(2633140,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351021',1055040.00,0.00,0.00,1570.00,0.00,'2022-06-30 12:53:07','',''),(2633141,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15146880.00,22540.00,0.00,0.00,'2022-07-01 11:37:18','',''),(2633142,'1','158',NULL,335,'Reception corrector for bridging 132647',0.00,0.00,0.00,22540.00,0.00,'2022-07-01 11:38:44','',''),(2633143,'1','158','780',335,'Received from bridging 132647',0.00,0.00,22540.00,0.00,0.00,'2022-07-01 11:38:44','',''),(2633144,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351022',2876160.00,0.00,0.00,4280.00,0.00,'2022-07-01 11:41:55','',''),(2633145,'1','158','780',335,'Distributed to KATAMFE for sales id:351023',2970240.00,0.00,0.00,4420.00,0.00,'2022-07-01 11:42:12','',''),(2633146,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351024',3669120.00,0.00,0.00,5460.00,0.00,'2022-07-01 11:47:47','',''),(2633147,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351025',3433920.00,0.00,0.00,5110.00,0.00,'2022-07-01 11:48:04','',''),(2633148,'1','158','780',335,'Distributed to KATAMFE for sales id:351026',2197440.00,0.00,0.00,3270.00,0.00,'2022-07-01 11:48:21','',''),(2633149,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16853760.00,25080.00,0.00,0.00,'2022-07-02 11:19:46','',''),(2633150,'1','158',NULL,335,'Reception corrector for bridging 132648',0.00,0.00,0.00,25080.00,0.00,'2022-07-02 11:21:34','',''),(2633151,'1','158','780',335,'Received from bridging 132648',0.00,0.00,25080.00,0.00,0.00,'2022-07-02 11:21:34','',''),(2633152,'1','158','780',335,'Distributed to KATAMFE for sales id:351027',1404480.00,0.00,0.00,2090.00,0.00,'2022-07-02 12:14:24','',''),(2633153,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351028',3501120.00,0.00,0.00,5210.00,0.00,'2022-07-02 12:14:47','',''),(2633154,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351029',3682560.00,0.00,0.00,5480.00,0.00,'2022-07-02 12:29:59','',''),(2633155,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351030',3548160.00,0.00,0.00,5280.00,0.00,'2022-07-02 12:30:20','',''),(2633156,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351031',3608640.00,0.00,0.00,5370.00,0.00,'2022-07-02 12:30:40','',''),(2633157,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351032',934080.00,0.00,0.00,1390.00,0.00,'2022-07-02 12:31:04','',''),(2633158,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351033',174720.00,0.00,0.00,260.00,0.00,'2022-07-02 12:33:40','',''),(2633159,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16719360.00,24880.00,0.00,0.00,'2022-07-03 13:23:56','',''),(2633160,'1','158',NULL,335,'Reception corrector for bridging 132649',0.00,0.00,0.00,24880.00,0.00,'2022-07-03 13:26:24','',''),(2633161,'1','158','780',335,'Received from bridging 132649',0.00,0.00,24880.00,0.00,0.00,'2022-07-03 13:26:24','',''),(2633162,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351034',2546880.00,0.00,0.00,3790.00,0.00,'2022-07-03 13:29:53','',''),(2633163,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351035',3393600.00,0.00,0.00,5050.00,0.00,'2022-07-03 13:30:11','',''),(2633164,'1','158','780',335,'Distributed to KATAMFE for sales id:351036',3588480.00,0.00,0.00,5340.00,0.00,'2022-07-03 13:38:54','',''),(2633165,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351037',3648960.00,0.00,0.00,5430.00,0.00,'2022-07-03 13:39:14','',''),(2633166,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351038',3252480.00,0.00,0.00,4840.00,0.00,'2022-07-03 13:39:32','',''),(2633167,'1','158','780',335,'Distributed to ADO PLANT for sales id:351039',141120.00,0.00,0.00,210.00,0.00,'2022-07-03 13:39:50','',''),(2633168,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351040',147840.00,0.00,0.00,220.00,0.00,'2022-07-03 13:41:45','',''),(2633169,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16826880.00,25040.00,0.00,0.00,'2022-07-04 11:03:41','',''),(2633170,'1','158',NULL,335,'Reception corrector for bridging 132650',0.00,0.00,0.00,25040.00,0.00,'2022-07-04 11:05:28','',''),(2633171,'1','158','780',335,'Received from bridging 132650',0.00,0.00,25040.00,0.00,0.00,'2022-07-04 11:05:28','',''),(2633172,'1','158','780',335,'Distributed to ADO PLANT for sales id:351041',3440640.00,0.00,0.00,5120.00,0.00,'2022-07-04 11:10:27','',''),(2633173,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351042',3393600.00,0.00,0.00,5050.00,0.00,'2022-07-04 11:10:45','',''),(2633174,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351043',3608640.00,0.00,0.00,5370.00,0.00,'2022-07-04 11:17:19','',''),(2633175,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351044',3339840.00,0.00,0.00,4970.00,0.00,'2022-07-04 11:17:39','',''),(2633176,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351045',2929920.00,0.00,0.00,4360.00,0.00,'2022-07-04 11:18:02','',''),(2633177,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351046',114240.00,0.00,0.00,170.00,0.00,'2022-07-04 11:20:21','',''),(2633178,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16833600.00,25050.00,0.00,0.00,'2022-07-05 14:57:46','',''),(2633179,'1','158',NULL,335,'Reception corrector for bridging 132651',0.00,0.00,0.00,25050.00,0.00,'2022-07-05 14:59:14','',''),(2633180,'1','158','780',335,'Received from bridging 132651',0.00,0.00,25050.00,0.00,0.00,'2022-07-05 14:59:14','',''),(2633181,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351047',537600.00,0.00,0.00,800.00,0.00,'2022-07-05 15:03:22','',''),(2633182,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351048',3568320.00,0.00,0.00,5310.00,0.00,'2022-07-05 15:03:42','',''),(2633183,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351049',3931200.00,0.00,0.00,5850.00,0.00,'2022-07-05 15:03:59','',''),(2633184,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351050',3407040.00,0.00,0.00,5070.00,0.00,'2022-07-05 15:06:52','',''),(2633185,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351051',3521280.00,0.00,0.00,5240.00,0.00,'2022-07-05 15:10:30','',''),(2633186,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351052',1814400.00,0.00,0.00,2700.00,0.00,'2022-07-05 15:10:48','',''),(2633187,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351053',53760.00,0.00,0.00,80.00,0.00,'2022-07-11 09:53:08','',''),(2633188,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16752960.00,24930.00,0.00,0.00,'2022-07-11 09:56:06','',''),(2633189,'1','158',NULL,335,'Reception corrector for bridging 132652',0.00,0.00,0.00,24930.00,0.00,'2022-07-11 09:57:48','',''),(2633190,'1','158','780',335,'Received from bridging 132652',0.00,0.00,24930.00,0.00,0.00,'2022-07-11 09:57:48','',''),(2633191,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351054',1720320.00,0.00,0.00,2560.00,0.00,'2022-07-11 10:04:57','',''),(2633192,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351055',3407040.00,0.00,0.00,5070.00,0.00,'2022-07-11 10:05:18','',''),(2633193,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351056',3265920.00,0.00,0.00,4860.00,0.00,'2022-07-11 10:05:39','',''),(2633194,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351057',3709440.00,0.00,0.00,5520.00,0.00,'2022-07-11 10:05:58','',''),(2633195,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351058',4233600.00,0.00,0.00,6300.00,0.00,'2022-07-11 10:10:29','',''),(2633196,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351059',416640.00,0.00,0.00,620.00,0.00,'2022-07-11 10:10:52','',''),(2633197,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16766400.00,24950.00,0.00,0.00,'2022-07-11 10:12:42','',''),(2633198,'1','158',NULL,335,'Reception corrector for bridging 132653',0.00,0.00,0.00,24950.00,0.00,'2022-07-11 10:14:14','',''),(2633199,'1','158','780',335,'Received from bridging 132653',0.00,0.00,24950.00,0.00,0.00,'2022-07-11 10:14:14','',''),(2633200,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351060',3124800.00,0.00,0.00,4650.00,0.00,'2022-07-11 10:17:02','',''),(2633201,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351061',3339840.00,0.00,0.00,4970.00,0.00,'2022-07-11 10:22:01','',''),(2633202,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351062',2466240.00,0.00,0.00,3670.00,0.00,'2022-07-11 10:22:36','',''),(2633203,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351063',3400320.00,0.00,0.00,5060.00,0.00,'2022-07-11 10:27:39','',''),(2633204,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351064',745920.00,0.00,0.00,1110.00,0.00,'2022-07-11 10:27:57','',''),(2633205,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351065',3655680.00,0.00,0.00,5440.00,0.00,'2022-07-11 10:30:20','',''),(2633206,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351066',33600.00,0.00,0.00,50.00,0.00,'2022-07-11 10:32:07','',''),(2633207,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16840320.00,25060.00,0.00,0.00,'2022-07-11 10:36:02','',''),(2633208,'1','158',NULL,335,'Reception corrector for bridging 132654',0.00,0.00,0.00,25060.00,0.00,'2022-07-11 10:37:40','',''),(2633209,'1','158','780',335,'Received from bridging 132654',0.00,0.00,25060.00,0.00,0.00,'2022-07-11 10:37:40','',''),(2633210,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351067',2022720.00,0.00,0.00,3010.00,0.00,'2022-07-11 10:41:29','',''),(2633211,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351068',3521280.00,0.00,0.00,5240.00,0.00,'2022-07-11 10:41:47','',''),(2633212,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351069',3326400.00,0.00,0.00,4950.00,0.00,'2022-07-11 10:48:54','',''),(2633213,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351070',3675840.00,0.00,0.00,5470.00,0.00,'2022-07-11 10:49:18','',''),(2633214,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351071',3749760.00,0.00,0.00,5580.00,0.00,'2022-07-11 10:49:37','',''),(2633215,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351072',544320.00,0.00,0.00,810.00,0.00,'2022-07-11 10:52:20','',''),(2633216,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16826880.00,25040.00,0.00,0.00,'2022-07-12 16:09:36','',''),(2633217,'1','158',NULL,335,'Reception corrector for bridging 132655',0.00,0.00,0.00,25040.00,0.00,'2022-07-12 16:11:14','',''),(2633218,'1','158','780',335,'Received from bridging 132655',0.00,0.00,25040.00,0.00,0.00,'2022-07-12 16:11:14','',''),(2633219,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351073',2956800.00,0.00,0.00,4400.00,0.00,'2022-07-12 16:18:37','',''),(2633220,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351074',3460800.00,0.00,0.00,5150.00,0.00,'2022-07-12 16:18:57','',''),(2633221,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351075',2580480.00,0.00,0.00,3840.00,0.00,'2022-07-12 16:19:17','',''),(2633222,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351076',3514560.00,0.00,0.00,5230.00,0.00,'2022-07-12 16:19:45','',''),(2633223,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351077',2835840.00,0.00,0.00,4220.00,0.00,'2022-07-12 16:24:43','',''),(2633224,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351078',1417920.00,0.00,0.00,2110.00,0.00,'2022-07-12 16:25:08','',''),(2633225,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351079',53760.00,0.00,0.00,80.00,0.00,'2022-07-12 16:28:10','',''),(2633226,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-07-15 11:04:02','',''),(2633227,'1','158',NULL,335,'Reception corrector for bridging 132656',0.00,0.00,0.00,24980.00,0.00,'2022-07-15 11:06:14','',''),(2633228,'1','158','780',335,'Received from bridging 132656',0.00,0.00,24980.00,0.00,0.00,'2022-07-15 11:06:14','',''),(2633229,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351080',5476800.00,0.00,0.00,8150.00,0.00,'2022-07-15 11:14:08','',''),(2633230,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351081',3541440.00,0.00,0.00,5270.00,0.00,'2022-07-15 11:14:37','',''),(2633231,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351083',3346560.00,0.00,0.00,4980.00,0.00,'2022-07-15 11:15:08','',''),(2633232,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351082',2775360.00,0.00,0.00,4130.00,0.00,'2022-07-15 11:16:10','',''),(2633233,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351084',1646400.00,0.00,0.00,2450.00,0.00,'2022-07-15 11:19:47','',''),(2633234,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351085',6720.00,0.00,0.00,10.00,0.00,'2022-07-15 11:21:31','',''),(2633235,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-07-16 15:32:53','',''),(2633236,'1','158',NULL,335,'Reception corrector for bridging 132657',0.00,0.00,0.00,24980.00,0.00,'2022-07-16 15:34:34','',''),(2633237,'1','158','780',335,'Received from bridging 132657',0.00,0.00,24980.00,0.00,0.00,'2022-07-16 15:34:34','',''),(2633238,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351086',1767360.00,0.00,0.00,2630.00,0.00,'2022-07-16 15:39:04','',''),(2633239,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351087',3232320.00,0.00,0.00,4810.00,0.00,'2022-07-16 15:39:22','',''),(2633240,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351088',3494400.00,0.00,0.00,5200.00,0.00,'2022-07-16 15:39:50','',''),(2633241,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351089',3454080.00,0.00,0.00,5140.00,0.00,'2022-07-16 15:42:55','',''),(2633242,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351090',3528000.00,0.00,0.00,5250.00,0.00,'2022-07-16 15:46:52','',''),(2633243,'1','158','780',335,'Distributed to KATAMFE for sales id:351091',1310400.00,0.00,0.00,1950.00,0.00,'2022-07-16 15:47:09','',''),(2633244,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16773120.00,24960.00,0.00,0.00,'2022-07-18 11:11:03','',''),(2633245,'1','158',NULL,335,'Reception corrector for bridging 132658',0.00,0.00,0.00,24960.00,0.00,'2022-07-18 11:13:03','',''),(2633246,'1','158','780',335,'Received from bridging 132658',0.00,0.00,24960.00,0.00,0.00,'2022-07-18 11:13:03','',''),(2633247,'1','158','780',335,'Distributed to KATAMFE for sales id:351092',2385600.00,0.00,0.00,3550.00,0.00,'2022-07-18 11:15:19','',''),(2633248,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351093',3507840.00,0.00,0.00,5220.00,0.00,'2022-07-18 11:23:13','',''),(2633249,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351094',3951360.00,0.00,0.00,5880.00,0.00,'2022-07-18 11:23:34','',''),(2633250,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351095',3165120.00,0.00,0.00,4710.00,0.00,'2022-07-18 11:23:55','',''),(2633251,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351096',3024000.00,0.00,0.00,4500.00,0.00,'2022-07-18 11:24:15','',''),(2633252,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351097',739200.00,0.00,0.00,1100.00,0.00,'2022-07-18 11:27:23','',''),(2633253,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16759680.00,24940.00,0.00,0.00,'2022-07-20 09:51:33','',''),(2633254,'1','158',NULL,335,'Reception corrector for bridging 132659',0.00,0.00,0.00,24940.00,0.00,'2022-07-20 09:53:19','',''),(2633255,'1','158','780',335,'Received from bridging 132659',0.00,0.00,24940.00,0.00,0.00,'2022-07-20 09:53:19','',''),(2633256,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351098',2808960.00,0.00,0.00,4180.00,0.00,'2022-07-20 10:03:13','',''),(2633257,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351099',3682560.00,0.00,0.00,5480.00,0.00,'2022-07-20 10:03:31','',''),(2633258,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351100',3400320.00,0.00,0.00,5060.00,0.00,'2022-07-20 10:04:02','',''),(2633259,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351101',3554880.00,0.00,0.00,5290.00,0.00,'2022-07-20 10:09:49','',''),(2633260,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351102',3312960.00,0.00,0.00,4930.00,0.00,'2022-07-20 10:10:07','',''),(2633261,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16544640.00,24620.00,0.00,0.00,'2022-07-21 15:19:45','',''),(2633262,'1','158',NULL,335,'Reception corrector for bridging 132660',0.00,0.00,0.00,24620.00,0.00,'2022-07-21 15:21:06','',''),(2633263,'1','158','780',335,'Received from bridging 132660',0.00,0.00,24620.00,0.00,0.00,'2022-07-21 15:21:06','',''),(2633264,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351103',268800.00,0.00,0.00,400.00,0.00,'2022-07-21 15:23:08','',''),(2633265,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351104',3816960.00,0.00,0.00,5680.00,0.00,'2022-07-21 15:29:39','',''),(2633266,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351105',3595200.00,0.00,0.00,5350.00,0.00,'2022-07-21 15:29:56','',''),(2633267,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351106',3521280.00,0.00,0.00,5240.00,0.00,'2022-07-21 15:30:12','',''),(2633268,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351107',3501120.00,0.00,0.00,5210.00,0.00,'2022-07-21 15:30:29','',''),(2633269,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351108',1767360.00,0.00,0.00,2630.00,0.00,'2022-07-21 15:34:12','',''),(2633270,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351109',73920.00,0.00,0.00,110.00,0.00,'2022-07-21 15:41:40','',''),(2633271,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16786560.00,24980.00,0.00,0.00,'2022-07-21 16:38:48','',''),(2633272,'1','158',NULL,335,'Reception corrector for bridging 132661',0.00,0.00,0.00,24980.00,0.00,'2022-07-21 16:40:10','',''),(2633273,'1','158','780',335,'Received from bridging 132661',0.00,0.00,24980.00,0.00,0.00,'2022-07-21 16:40:10','',''),(2633274,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351110',8682240.00,0.00,0.00,12920.00,0.00,'2022-07-21 16:47:17','',''),(2633275,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351111',1592640.00,0.00,0.00,2370.00,0.00,'2022-07-21 16:47:36','',''),(2633276,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351112',3655680.00,0.00,0.00,5440.00,0.00,'2022-07-21 16:47:55','',''),(2633277,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351113',2856000.00,0.00,0.00,4250.00,0.00,'2022-07-21 16:48:13','',''),(2633278,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-07-25 13:35:22','',''),(2633279,'1','158',NULL,335,'Reception corrector for bridging 132662',0.00,0.00,0.00,25000.00,0.00,'2022-07-25 13:36:43','',''),(2633280,'1','158','780',335,'Received from bridging 132662',0.00,0.00,25000.00,0.00,0.00,'2022-07-25 13:36:43','',''),(2633281,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351114',604800.00,0.00,0.00,900.00,0.00,'2022-07-25 13:43:02','',''),(2633282,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351115',3796800.00,0.00,0.00,5650.00,0.00,'2022-07-25 13:49:02','',''),(2633283,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351116',3460800.00,0.00,0.00,5150.00,0.00,'2022-07-25 13:49:19','',''),(2633284,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351117',2842560.00,0.00,0.00,4230.00,0.00,'2022-07-25 13:49:43','',''),(2633285,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351118',3743040.00,0.00,0.00,5570.00,0.00,'2022-07-25 13:53:16','',''),(2633286,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351119',2022720.00,0.00,0.00,3010.00,0.00,'2022-07-25 13:53:32','',''),(2633287,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351120',329280.00,0.00,0.00,490.00,0.00,'2022-07-25 13:55:15','',''),(2633288,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-07-25 14:17:53','',''),(2633289,'1','158',NULL,335,'Reception corrector for bridging 132663',0.00,0.00,0.00,25000.00,0.00,'2022-07-25 14:19:22','',''),(2633290,'1','158','780',335,'Received from bridging 132663',0.00,0.00,25000.00,0.00,0.00,'2022-07-25 14:19:22','',''),(2633291,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351121',1606080.00,0.00,0.00,2390.00,0.00,'2022-07-25 14:21:35','',''),(2633292,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351122',3420480.00,0.00,0.00,5090.00,0.00,'2022-07-25 14:29:22','',''),(2633293,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351123',3467520.00,0.00,0.00,5160.00,0.00,'2022-07-25 14:29:39','',''),(2633294,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351124',2956800.00,0.00,0.00,4400.00,0.00,'2022-07-25 14:29:56','',''),(2633295,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351125',3971520.00,0.00,0.00,5910.00,0.00,'2022-07-25 14:30:14','',''),(2633296,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351126',987840.00,0.00,0.00,1470.00,0.00,'2022-07-25 14:34:17','',''),(2633297,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351127',389760.00,0.00,0.00,580.00,0.00,'2022-07-25 14:35:53','',''),(2633298,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16692480.00,24840.00,0.00,0.00,'2022-07-27 11:34:07','',''),(2633299,'1','158',NULL,335,'Reception corrector for bridging 132664',0.00,0.00,0.00,24840.00,0.00,'2022-07-27 11:35:35','',''),(2633300,'1','158','780',335,'Received from bridging 132664',0.00,0.00,24840.00,0.00,0.00,'2022-07-27 11:35:35','',''),(2633301,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351128',2627520.00,0.00,0.00,3910.00,0.00,'2022-07-27 11:53:34','',''),(2633302,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351129',3454080.00,0.00,0.00,5140.00,0.00,'2022-07-27 11:54:52','',''),(2633303,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351130',3514560.00,0.00,0.00,5230.00,0.00,'2022-07-27 11:55:21','',''),(2633304,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351131',3642240.00,0.00,0.00,5420.00,0.00,'2022-07-27 11:56:02','',''),(2633305,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351132',3393600.00,0.00,0.00,5050.00,0.00,'2022-07-27 11:57:25','',''),(2633306,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351133',60480.00,0.00,0.00,90.00,0.00,'2022-07-27 12:01:41','',''),(2633307,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16800000.00,25000.00,0.00,0.00,'2022-07-28 08:30:25','',''),(2633308,'1','158',NULL,335,'Reception corrector for bridging 132665',0.00,0.00,0.00,25000.00,0.00,'2022-07-28 08:31:49','',''),(2633309,'1','158','780',335,'Received from bridging 132665',0.00,0.00,25000.00,0.00,0.00,'2022-07-28 08:31:49','',''),(2633310,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351134',3279360.00,0.00,0.00,4880.00,0.00,'2022-07-28 08:35:50','',''),(2633311,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351135',3642240.00,0.00,0.00,5420.00,0.00,'2022-07-28 08:45:46','',''),(2633312,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351136',3225600.00,0.00,0.00,4800.00,0.00,'2022-07-28 08:46:03','',''),(2633313,'1','158','780',335,'Distributed to NIP WEST GAS for sales id:351137',3326400.00,0.00,0.00,4950.00,0.00,'2022-07-28 08:46:21','',''),(2633314,'1','158','780',335,'Distributed to KARU PLANT for sales id:351138',3292800.00,0.00,0.00,4900.00,0.00,'2022-07-28 08:46:38','',''),(2633315,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351139',33600.00,0.00,0.00,50.00,0.00,'2022-07-28 08:48:50','',''),(2633316,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16638720.00,24760.00,0.00,0.00,'2022-07-29 12:12:49','',''),(2633317,'1','158',NULL,335,'Reception corrector for bridging 132666',0.00,0.00,0.00,24760.00,0.00,'2022-07-29 12:14:11','',''),(2633318,'1','158','780',335,'Received from bridging 132666',0.00,0.00,24760.00,0.00,0.00,'2022-07-29 12:14:11','',''),(2633319,'1','158','780',335,'Distributed to KARU PLANT for sales id:351140',416640.00,0.00,0.00,620.00,0.00,'2022-07-29 12:16:26','',''),(2633320,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351141',3588480.00,0.00,0.00,5340.00,0.00,'2022-07-29 12:24:02','',''),(2633321,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351142',3507840.00,0.00,0.00,5220.00,0.00,'2022-07-29 12:24:21','',''),(2633322,'1','158','780',335,'Distributed to LUBE GAS for sales id:351143',3534720.00,0.00,0.00,5260.00,0.00,'2022-07-29 12:24:38','',''),(2633323,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351144',2694720.00,0.00,0.00,4010.00,0.00,'2022-07-29 12:24:57','',''),(2633324,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351145',2607360.00,0.00,0.00,3880.00,0.00,'2022-07-29 12:28:19','',''),(2633325,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351146',288960.00,0.00,0.00,430.00,0.00,'2022-07-29 12:29:51','',''),(2633326,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16625000.00,25000.00,0.00,0.00,'2022-07-30 15:09:11','',''),(2633327,'1','158',NULL,335,'Reception corrector for bridging 132667',0.00,0.00,0.00,25000.00,0.00,'2022-07-30 15:10:24','',''),(2633328,'1','158','780',335,'Received from bridging 132667',0.00,0.00,25000.00,0.00,0.00,'2022-07-30 15:10:24','',''),(2633329,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351147',844550.00,0.00,0.00,1270.00,0.00,'2022-07-30 15:21:57','',''),(2633330,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351149',3524500.00,0.00,0.00,5300.00,0.00,'2022-07-30 15:22:21','',''),(2633331,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351150',3298400.00,0.00,0.00,4960.00,0.00,'2022-07-30 15:22:51','',''),(2633332,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351151',3604300.00,0.00,0.00,5420.00,0.00,'2022-07-30 15:23:09','',''),(2633333,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351152',3344950.00,0.00,0.00,5030.00,0.00,'2022-07-30 15:23:26','',''),(2633334,'1','158','780',335,'Distributed to ADO PLANT for sales id:351153',1915200.00,0.00,0.00,2880.00,0.00,'2022-07-30 15:41:41','',''),(2633335,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351154',93100.00,0.00,0.00,140.00,0.00,'2022-07-30 15:43:23','',''),(2633336,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16558500.00,24900.00,0.00,0.00,'2022-08-01 10:46:35','',''),(2633337,'1','158',NULL,335,'Reception corrector for bridging 132668',0.00,0.00,0.00,24900.00,0.00,'2022-08-01 10:48:37','',''),(2633338,'1','158','780',335,'Received from bridging 132668',0.00,0.00,24900.00,0.00,0.00,'2022-08-01 10:48:37','',''),(2633339,'1','158','780',335,'Distributed to ADO PLANT for sales id:351155',1476300.00,0.00,0.00,2220.00,0.00,'2022-08-01 10:52:53','',''),(2633340,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351156',3557750.00,0.00,0.00,5350.00,0.00,'2022-08-01 10:53:29','',''),(2633341,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351157',3391500.00,0.00,0.00,5100.00,0.00,'2022-08-01 11:02:38','',''),(2633342,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351158',3504550.00,0.00,0.00,5270.00,0.00,'2022-08-01 11:03:03','',''),(2633343,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351159',3504550.00,0.00,0.00,5270.00,0.00,'2022-08-01 11:03:30','',''),(2633344,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351160',1143800.00,0.00,0.00,1720.00,0.00,'2022-08-01 11:03:50','',''),(2633345,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16432150.00,24710.00,0.00,0.00,'2022-08-01 11:26:27','',''),(2633346,'1','158',NULL,335,'Reception corrector for bridging 132669',0.00,0.00,0.00,24710.00,0.00,'2022-08-01 11:27:31','',''),(2633347,'1','158','780',335,'Received from bridging 132669',0.00,0.00,24710.00,0.00,0.00,'2022-08-01 11:27:31','',''),(2633348,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351161',8126300.00,0.00,0.00,12220.00,0.00,'2022-08-01 11:34:51','',''),(2633349,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351162',1908550.00,0.00,0.00,2870.00,0.00,'2022-08-01 11:35:10','',''),(2633350,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351163',3577700.00,0.00,0.00,5380.00,0.00,'2022-08-01 11:35:30','',''),(2633351,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351164',2819600.00,0.00,0.00,4240.00,0.00,'2022-08-01 11:36:05','',''),(2633352,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16565150.00,24910.00,0.00,0.00,'2022-08-02 15:18:01','',''),(2633353,'1','158',NULL,335,'Reception corrector for bridging 132670',0.00,0.00,0.00,24910.00,0.00,'2022-08-02 15:19:34','',''),(2633354,'1','158','780',335,'Received from bridging 132670',0.00,0.00,24910.00,0.00,0.00,'2022-08-02 15:19:34','',''),(2633355,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351165',279300.00,0.00,0.00,420.00,0.00,'2022-08-02 15:24:07','',''),(2633356,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351166',2726500.00,0.00,0.00,4100.00,0.00,'2022-08-02 15:24:24','',''),(2633357,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351167',3783850.00,0.00,0.00,5690.00,0.00,'2022-08-02 15:28:34','',''),(2633358,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351168',3411450.00,0.00,0.00,5130.00,0.00,'2022-08-02 15:29:24','',''),(2633359,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351169',3617600.00,0.00,0.00,5440.00,0.00,'2022-08-02 15:32:57','',''),(2633360,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351170',2746450.00,0.00,0.00,4130.00,0.00,'2022-08-02 15:33:15','',''),(2633361,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-02 17:56:29','',''),(2633362,'1','158',NULL,335,'Reception corrector for bridging 132671',0.00,0.00,0.00,24960.00,0.00,'2022-08-02 17:57:34','',''),(2633363,'1','158','780',335,'Received from bridging 132671',0.00,0.00,24960.00,0.00,0.00,'2022-08-02 17:57:34','',''),(2633364,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351171',698250.00,0.00,0.00,1050.00,0.00,'2022-08-02 18:04:57','',''),(2633365,'1','158','780',335,'Distributed to KARU PLANT for sales id:351172',3471300.00,0.00,0.00,5220.00,0.00,'2022-08-02 18:05:16','',''),(2633366,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351173',3458000.00,0.00,0.00,5200.00,0.00,'2022-08-02 18:05:39','',''),(2633367,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351174',2826250.00,0.00,0.00,4250.00,0.00,'2022-08-02 18:06:05','',''),(2633368,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351175',3238550.00,0.00,0.00,4870.00,0.00,'2022-08-02 18:06:24','',''),(2633369,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351176',2906050.00,0.00,0.00,4370.00,0.00,'2022-08-02 18:06:45','',''),(2633370,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-04 07:53:28','',''),(2633371,'1','158',NULL,335,'Reception corrector for bridging 132672',0.00,0.00,0.00,24960.00,0.00,'2022-08-04 07:54:49','',''),(2633372,'1','158','780',335,'Received from bridging 132672',0.00,0.00,24960.00,0.00,0.00,'2022-08-04 07:54:49','',''),(2633373,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351177',684950.00,0.00,0.00,1030.00,0.00,'2022-08-04 07:58:24','',''),(2633374,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351178',3497900.00,0.00,0.00,5260.00,0.00,'2022-08-04 08:00:32','',''),(2633375,'1','158','780',335,'Distributed to KARU PLANT for sales id:351179',3883600.00,0.00,0.00,5840.00,0.00,'2022-08-04 08:08:30','',''),(2633376,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351180',2773050.00,0.00,0.00,4170.00,0.00,'2022-08-04 08:08:52','',''),(2633377,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351181',2374050.00,0.00,0.00,3570.00,0.00,'2022-08-04 08:09:10','',''),(2633378,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351182',3384850.00,0.00,0.00,5090.00,0.00,'2022-08-04 08:09:28','',''),(2633379,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-05 11:04:39','',''),(2633380,'1','158',NULL,335,'Reception corrector for bridging 132673',0.00,0.00,0.00,24960.00,0.00,'2022-08-05 11:06:17','',''),(2633381,'1','158','780',335,'Received from bridging 132673',0.00,0.00,24960.00,0.00,0.00,'2022-08-05 11:06:17','',''),(2633382,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351183',1622600.00,0.00,0.00,2440.00,0.00,'2022-08-05 11:09:08','',''),(2633383,'1','158','780',335,'Distributed to KARU PLANT for sales id:351184',4315850.00,0.00,0.00,6490.00,0.00,'2022-08-05 11:14:33','',''),(2633384,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351185',3398150.00,0.00,0.00,5110.00,0.00,'2022-08-05 11:14:50','',''),(2633385,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351186',3464650.00,0.00,0.00,5210.00,0.00,'2022-08-05 11:15:12','',''),(2633386,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351187',3331650.00,0.00,0.00,5010.00,0.00,'2022-08-05 11:20:08','',''),(2633387,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351188',465500.00,0.00,0.00,700.00,0.00,'2022-08-05 11:20:28','',''),(2633388,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16585100.00,24940.00,0.00,0.00,'2022-08-06 08:30:56','',''),(2633389,'1','158',NULL,335,'Reception corrector for bridging 132674',0.00,0.00,0.00,24940.00,0.00,'2022-08-06 08:32:02','',''),(2633390,'1','158','780',335,'Received from bridging 132674',0.00,0.00,24940.00,0.00,0.00,'2022-08-06 08:32:02','',''),(2633391,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351189',3245200.00,0.00,0.00,4880.00,0.00,'2022-08-06 08:39:02','',''),(2633392,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351190',3032400.00,0.00,0.00,4560.00,0.00,'2022-08-06 08:39:19','',''),(2633393,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351191',3231900.00,0.00,0.00,4860.00,0.00,'2022-08-06 08:39:35','',''),(2633394,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351192',3398150.00,0.00,0.00,5110.00,0.00,'2022-08-06 08:39:53','',''),(2633395,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351193',3657500.00,0.00,0.00,5500.00,0.00,'2022-08-06 08:40:12','',''),(2633396,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-06 17:32:06','',''),(2633397,'1','158',NULL,335,'Reception corrector for bridging 132675',0.00,0.00,0.00,24960.00,0.00,'2022-08-06 17:34:17','',''),(2633398,'1','158','780',335,'Received from bridging 132675',0.00,0.00,24960.00,0.00,0.00,'2022-08-06 17:34:17','',''),(2633399,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351194',86450.00,0.00,0.00,130.00,0.00,'2022-08-06 17:42:05','',''),(2633400,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351196',3411450.00,0.00,0.00,5130.00,0.00,'2022-08-06 17:42:47','',''),(2633401,'1','158','780',335,'Distributed to KATAMFE for sales id:351197',4076450.00,0.00,0.00,6130.00,0.00,'2022-08-06 17:43:11','',''),(2633402,'1','158','780',335,'Distributed to KATAMFE for sales id:351198',3378200.00,0.00,0.00,5080.00,0.00,'2022-08-06 17:51:14','',''),(2633403,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351199',3610950.00,0.00,0.00,5430.00,0.00,'2022-08-06 17:51:33','',''),(2633404,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351200',1842050.00,0.00,0.00,2770.00,0.00,'2022-08-06 17:51:55','',''),(2633405,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351201',192850.00,0.00,0.00,290.00,0.00,'2022-08-06 17:54:36','',''),(2633406,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-07 19:51:30','',''),(2633407,'1','158',NULL,335,'Reception corrector for bridging 132676',0.00,0.00,0.00,24960.00,0.00,'2022-08-07 19:52:46','',''),(2633408,'1','158','780',335,'Received from bridging 132676',0.00,0.00,24960.00,0.00,0.00,'2022-08-07 19:52:46','',''),(2633409,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351202',964250.00,0.00,0.00,1450.00,0.00,'2022-08-07 19:57:21','',''),(2633410,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351203',3298400.00,0.00,0.00,4960.00,0.00,'2022-08-07 19:57:40','',''),(2633411,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351204',3424750.00,0.00,0.00,5150.00,0.00,'2022-08-07 19:57:57','',''),(2633412,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351205',2886100.00,0.00,0.00,4340.00,0.00,'2022-08-07 20:02:43','',''),(2633413,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351206',3132150.00,0.00,0.00,4710.00,0.00,'2022-08-07 20:02:59','',''),(2633414,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351207',2926000.00,0.00,0.00,4400.00,0.00,'2022-08-07 20:03:15','',''),(2633415,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-08-09 12:04:28','',''),(2633416,'1','158',NULL,335,'Reception corrector for bridging 132677',0.00,0.00,0.00,24960.00,0.00,'2022-08-09 12:08:16','',''),(2633417,'1','158','780',335,'Received from bridging 132677',0.00,0.00,24960.00,0.00,0.00,'2022-08-09 12:08:16','',''),(2633418,'1','158','780',335,'Distributed to KATAMFE for sales id:351209',4302550.00,0.00,0.00,6470.00,0.00,'2022-08-09 12:13:04','',''),(2633419,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351210',3245200.00,0.00,0.00,4880.00,0.00,'2022-08-09 12:13:21','',''),(2633420,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351211',3577700.00,0.00,0.00,5380.00,0.00,'2022-08-09 12:13:38','',''),(2633421,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351212',4003300.00,0.00,0.00,6020.00,0.00,'2022-08-09 12:19:25','',''),(2633422,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351213',1582700.00,0.00,0.00,2380.00,0.00,'2022-08-09 12:19:44','',''),(2633423,'1','158','780',335,'Distributed to OVERAGE for sales id:351215',113050.00,0.00,0.00,170.00,0.00,'2022-08-09 12:22:04','',''),(2633424,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16678200.00,25080.00,0.00,0.00,'2022-08-15 15:37:32','',''),(2633425,'1','158',NULL,335,'Reception corrector for bridging 132678',0.00,0.00,0.00,25080.00,0.00,'2022-08-15 15:39:17','',''),(2633426,'1','158','780',335,'Received from bridging 132678',0.00,0.00,25080.00,0.00,0.00,'2022-08-15 15:39:17','',''),(2633427,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351216',3704050.00,0.00,0.00,5570.00,0.00,'2022-08-15 15:49:02','',''),(2633428,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351218',3876950.00,0.00,0.00,5830.00,0.00,'2022-08-15 15:49:17','',''),(2633429,'1','158','780',335,'Distributed to KARU PLANT for sales id:351217',4435550.00,0.00,0.00,6670.00,0.00,'2022-08-15 15:49:34','',''),(2633430,'1','158','780',335,'Distributed to KATAMFE for sales id:351220',1356600.00,0.00,0.00,2040.00,0.00,'2022-08-15 15:49:48','',''),(2633431,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351219',3444700.00,0.00,0.00,5180.00,0.00,'2022-08-15 15:50:05','',''),(2633432,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15614200.00,23480.00,0.00,0.00,'2022-08-15 16:24:52','',''),(2633433,'1','158',NULL,335,'Reception corrector for bridging 132679',0.00,0.00,0.00,23480.00,0.00,'2022-08-15 16:27:14','',''),(2633434,'1','158','780',335,'Received from bridging 132679',0.00,0.00,23480.00,0.00,0.00,'2022-08-15 16:27:14','',''),(2633435,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351222',3464650.00,0.00,0.00,5210.00,0.00,'2022-08-15 16:36:31','',''),(2633436,'1','158','780',335,'Distributed to ADO PLANT for sales id:351224',3497900.00,0.00,0.00,5260.00,0.00,'2022-08-15 16:36:49','',''),(2633437,'1','158','780',335,'Distributed to KARU PLANT for sales id:351225',3910200.00,0.00,0.00,5880.00,0.00,'2022-08-15 16:37:06','',''),(2633438,'1','158','780',335,'Distributed to KATAMFE for sales id:351226',1469650.00,0.00,0.00,2210.00,0.00,'2022-08-15 16:37:23','',''),(2633439,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351223',3271800.00,0.00,0.00,4920.00,0.00,'2022-08-15 16:38:00','',''),(2633440,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16545200.00,24880.00,0.00,0.00,'2022-08-15 16:40:44','',''),(2633441,'1','158',NULL,335,'Reception corrector for bridging 132680',0.00,0.00,0.00,24880.00,0.00,'2022-08-15 16:42:32','',''),(2633442,'1','158','780',335,'Received from bridging 132680',0.00,0.00,24880.00,0.00,0.00,'2022-08-15 16:42:32','',''),(2633443,'1','158','780',335,'Distributed to KATAMFE for sales id:351227',2739800.00,0.00,0.00,4120.00,0.00,'2022-08-15 16:44:58','',''),(2633444,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351228',3098900.00,0.00,0.00,4660.00,0.00,'2022-08-15 16:54:00','',''),(2633445,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351229',3285100.00,0.00,0.00,4940.00,0.00,'2022-08-15 16:54:33','',''),(2633446,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351230',3531150.00,0.00,0.00,5310.00,0.00,'2022-08-15 16:55:20','',''),(2633447,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351231',3511200.00,0.00,0.00,5280.00,0.00,'2022-08-15 16:55:39','',''),(2633448,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351232',379050.00,0.00,0.00,570.00,0.00,'2022-08-15 16:55:58','',''),(2633449,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16359000.00,24600.00,0.00,0.00,'2022-08-15 16:59:27','',''),(2633450,'1','158',NULL,335,'Reception corrector for bridging 132681',0.00,0.00,0.00,24600.00,0.00,'2022-08-15 17:02:05','',''),(2633451,'1','158','780',335,'Received from bridging 132681',0.00,0.00,24600.00,0.00,0.00,'2022-08-15 17:02:05','',''),(2633452,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351233',3438050.00,0.00,0.00,5170.00,0.00,'2022-08-15 17:04:29','',''),(2633453,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351234',3704050.00,0.00,0.00,5570.00,0.00,'2022-08-15 17:12:20','',''),(2633454,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351235',3424750.00,0.00,0.00,5150.00,0.00,'2022-08-15 17:12:47','',''),(2633455,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351236',4275950.00,0.00,0.00,6430.00,0.00,'2022-08-15 17:13:05','',''),(2633456,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351237',1516200.00,0.00,0.00,2280.00,0.00,'2022-08-15 17:13:27','',''),(2633457,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16545200.00,24880.00,0.00,0.00,'2022-08-15 22:05:56','',''),(2633458,'1','158',NULL,335,'Reception corrector for bridging 132682',0.00,0.00,0.00,24880.00,0.00,'2022-08-15 22:07:56','',''),(2633459,'1','158','780',335,'Received from bridging 132682',0.00,0.00,24880.00,0.00,0.00,'2022-08-15 22:07:56','',''),(2633460,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351238',1881950.00,0.00,0.00,2830.00,0.00,'2022-08-15 22:15:33','',''),(2633461,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351239',2932650.00,0.00,0.00,4410.00,0.00,'2022-08-15 22:15:57','',''),(2633462,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351240',2387350.00,0.00,0.00,3590.00,0.00,'2022-08-15 22:16:31','',''),(2633463,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351241',3850350.00,0.00,0.00,5790.00,0.00,'2022-08-15 22:16:54','',''),(2633464,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351242',3617600.00,0.00,0.00,5440.00,0.00,'2022-08-15 22:24:44','',''),(2633465,'1','158','780',335,'Distributed to KATAMFE for sales id:351243',1875300.00,0.00,0.00,2820.00,0.00,'2022-08-15 22:25:07','',''),(2633466,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16625000.00,25000.00,0.00,0.00,'2022-08-15 22:35:32','',''),(2633467,'1','158',NULL,335,'Reception corrector for bridging 132683',0.00,0.00,0.00,25000.00,0.00,'2022-08-15 22:37:24','',''),(2633468,'1','158','780',335,'Received from bridging 132683',0.00,0.00,25000.00,0.00,0.00,'2022-08-15 22:37:24','',''),(2633469,'1','158','780',335,'Distributed to KATAMFE for sales id:351244',2147950.00,0.00,0.00,3230.00,0.00,'2022-08-15 22:52:41','',''),(2633470,'1','158','780',335,'Distributed to KARU PLANT for sales id:351245',3471300.00,0.00,0.00,5220.00,0.00,'2022-08-15 22:53:03','',''),(2633471,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351246',3211950.00,0.00,0.00,4830.00,0.00,'2022-08-15 22:53:26','',''),(2633472,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351247',3597650.00,0.00,0.00,5410.00,0.00,'2022-08-15 22:53:56','',''),(2633473,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351248',3251850.00,0.00,0.00,4890.00,0.00,'2022-08-15 22:54:14','',''),(2633474,'1','158','780',335,'Distributed to ADO PLANT for sales id:351249',944300.00,0.00,0.00,1420.00,0.00,'2022-08-15 22:54:30','',''),(2633475,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16425500.00,24700.00,0.00,0.00,'2022-08-16 16:57:45','',''),(2633476,'1','158',NULL,335,'Reception corrector for bridging 132684',0.00,0.00,0.00,24700.00,0.00,'2022-08-16 16:59:22','',''),(2633477,'1','158','780',335,'Received from bridging 132684',0.00,0.00,24700.00,0.00,0.00,'2022-08-16 16:59:22','',''),(2633478,'1','158','780',335,'Distributed to ADO PLANT for sales id:351250',2546950.00,0.00,0.00,3830.00,0.00,'2022-08-16 17:01:18','',''),(2633479,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351251',3777200.00,0.00,0.00,5680.00,0.00,'2022-08-16 17:11:19','',''),(2633480,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351252',3577700.00,0.00,0.00,5380.00,0.00,'2022-08-16 17:11:37','',''),(2633481,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351253',3524500.00,0.00,0.00,5300.00,0.00,'2022-08-16 17:11:54','',''),(2633482,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351254',2999150.00,0.00,0.00,4510.00,0.00,'2022-08-16 17:12:10','',''),(2633483,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16625000.00,25000.00,0.00,0.00,'2022-08-17 11:56:05','',''),(2633484,'1','158',NULL,335,'Reception corrector for bridging 132685',0.00,0.00,0.00,25000.00,0.00,'2022-08-17 11:58:31','',''),(2633485,'1','158','780',335,'Received from bridging 132685',0.00,0.00,25000.00,0.00,0.00,'2022-08-17 11:58:31','',''),(2633486,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351255',558600.00,0.00,0.00,840.00,0.00,'2022-08-17 12:02:33','',''),(2633487,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351256',3577700.00,0.00,0.00,5380.00,0.00,'2022-08-17 12:15:18','',''),(2633488,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351257',3411450.00,0.00,0.00,5130.00,0.00,'2022-08-17 12:17:19','',''),(2633489,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351258',4322500.00,0.00,0.00,6500.00,0.00,'2022-08-17 12:18:07','',''),(2633490,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351259',3650850.00,0.00,0.00,5490.00,0.00,'2022-08-17 12:27:47','',''),(2633491,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351260',1103900.00,0.00,0.00,1660.00,0.00,'2022-08-17 12:28:04','',''),(2633492,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15600900.00,23460.00,0.00,0.00,'2022-08-17 18:18:29','',''),(2633493,'1','158',NULL,335,'Reception corrector for bridging 132686',0.00,0.00,0.00,23460.00,0.00,'2022-08-17 18:19:44','',''),(2633494,'1','158','780',335,'Received from bridging 132686',0.00,0.00,23460.00,0.00,0.00,'2022-08-17 18:19:44','',''),(2633495,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351261',2380700.00,0.00,0.00,3580.00,0.00,'2022-08-17 18:26:24','',''),(2633496,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351262',3497900.00,0.00,0.00,5260.00,0.00,'2022-08-17 18:26:44','',''),(2633497,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351263',3278450.00,0.00,0.00,4930.00,0.00,'2022-08-17 18:27:01','',''),(2633498,'1','158','780',335,'Distributed to ADO PLANT for sales id:351264',3198650.00,0.00,0.00,4810.00,0.00,'2022-08-17 18:27:26','',''),(2633499,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351265',3245200.00,0.00,0.00,4880.00,0.00,'2022-08-17 18:28:45','',''),(2633500,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16585100.00,24940.00,0.00,0.00,'2022-08-19 16:29:23','',''),(2633501,'1','158',NULL,335,'Reception corrector for bridging 132687',0.00,0.00,0.00,24940.00,0.00,'2022-08-19 16:30:36','',''),(2633502,'1','158','780',335,'Received from bridging 132687',0.00,0.00,24940.00,0.00,0.00,'2022-08-19 16:30:36','',''),(2633503,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351266',399000.00,0.00,0.00,600.00,0.00,'2022-08-19 16:33:47','',''),(2633504,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351267',3311700.00,0.00,0.00,4980.00,0.00,'2022-08-19 16:44:32','',''),(2633505,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351268',2872800.00,0.00,0.00,4320.00,0.00,'2022-08-19 16:44:52','',''),(2633506,'1','158','780',335,'Distributed to HARIZ GAS for sales id:351269',3604300.00,0.00,0.00,5420.00,0.00,'2022-08-19 16:45:09','',''),(2633507,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351270',3444700.00,0.00,0.00,5180.00,0.00,'2022-08-19 16:58:08','',''),(2633508,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351271',2852850.00,0.00,0.00,4290.00,0.00,'2022-08-19 16:58:24','',''),(2633509,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16625000.00,25000.00,0.00,0.00,'2022-08-20 14:31:36','',''),(2633510,'1','158',NULL,335,'Reception corrector for bridging 132688',0.00,0.00,0.00,25000.00,0.00,'2022-08-20 14:33:03','',''),(2633511,'1','158','780',335,'Received from bridging 132688',0.00,0.00,25000.00,0.00,0.00,'2022-08-20 14:33:03','',''),(2633512,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351272',146300.00,0.00,0.00,220.00,0.00,'2022-08-20 15:06:09','',''),(2633513,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351273',3471300.00,0.00,0.00,5220.00,0.00,'2022-08-20 15:06:26','',''),(2633514,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351274',3511200.00,0.00,0.00,5280.00,0.00,'2022-08-20 15:06:43','',''),(2633515,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351275',3451350.00,0.00,0.00,5190.00,0.00,'2022-08-20 15:07:11','',''),(2633516,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351276',3591000.00,0.00,0.00,5400.00,0.00,'2022-08-20 15:11:14','',''),(2633517,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351277',2453850.00,0.00,0.00,3690.00,0.00,'2022-08-20 15:11:31','',''),(2633518,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16904300.00,25420.00,0.00,0.00,'2022-08-22 09:42:07','',''),(2633519,'1','158',NULL,335,'Reception corrector for bridging 132689',0.00,0.00,0.00,25420.00,0.00,'2022-08-22 09:43:18','',''),(2633520,'1','158','780',335,'Received from bridging 132689',0.00,0.00,25420.00,0.00,0.00,'2022-08-22 09:43:18','',''),(2633521,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351278',864500.00,0.00,0.00,1300.00,0.00,'2022-08-22 09:50:15','',''),(2633522,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351279',3830400.00,0.00,0.00,5760.00,0.00,'2022-08-22 09:50:31','',''),(2633523,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351280',3451350.00,0.00,0.00,5190.00,0.00,'2022-08-22 09:50:47','',''),(2633524,'1','158','780',335,'Distributed to KATAMFE for sales id:351281',3883600.00,0.00,0.00,5840.00,0.00,'2022-08-22 09:51:02','',''),(2633525,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351282',3438050.00,0.00,0.00,5170.00,0.00,'2022-08-22 09:51:19','',''),(2633526,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351283',1436400.00,0.00,0.00,2160.00,0.00,'2022-08-22 09:58:52','',''),(2633527,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16797900.00,25260.00,0.00,0.00,'2022-08-23 19:33:35','',''),(2633528,'1','158',NULL,335,'Reception corrector for bridging 132690',0.00,0.00,0.00,25260.00,0.00,'2022-08-23 19:34:58','',''),(2633529,'1','158','780',335,'Received from bridging 132690',0.00,0.00,25260.00,0.00,0.00,'2022-08-23 19:34:58','',''),(2633530,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351284',2001650.00,0.00,0.00,3010.00,0.00,'2022-08-23 19:41:08','',''),(2633531,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351285',3610950.00,0.00,0.00,5430.00,0.00,'2022-08-23 19:41:34','',''),(2633532,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351286',3192000.00,0.00,0.00,4800.00,0.00,'2022-08-23 19:41:55','',''),(2633533,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351287',2759750.00,0.00,0.00,4150.00,0.00,'2022-08-23 19:42:10','',''),(2633534,'1','158','780',335,'Distributed to KATAMFE for sales id:351288',3431400.00,0.00,0.00,5160.00,0.00,'2022-08-23 19:47:01','',''),(2633535,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351289',1802150.00,0.00,0.00,2710.00,0.00,'2022-08-23 19:47:19','',''),(2633536,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16651600.00,25040.00,0.00,0.00,'2022-08-23 19:49:46','',''),(2633537,'1','158',NULL,335,'Reception corrector for bridging 132691',0.00,0.00,0.00,25040.00,0.00,'2022-08-23 19:51:09','',''),(2633538,'1','158','780',335,'Received from bridging 132691',0.00,0.00,25040.00,0.00,0.00,'2022-08-23 19:51:09','',''),(2633539,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351290',2054850.00,0.00,0.00,3090.00,0.00,'2022-08-23 19:55:41','',''),(2633540,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351291',3451350.00,0.00,0.00,5190.00,0.00,'2022-08-23 19:55:56','',''),(2633541,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351292',3364900.00,0.00,0.00,5060.00,0.00,'2022-08-23 19:56:12','',''),(2633542,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351293',3803800.00,0.00,0.00,5720.00,0.00,'2022-08-23 20:03:21','',''),(2633543,'1','158','780',335,'Distributed to KATAMFE for sales id:351294',3178700.00,0.00,0.00,4780.00,0.00,'2022-08-23 20:03:39','',''),(2633544,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351295',798000.00,0.00,0.00,1200.00,0.00,'2022-08-23 20:03:59','',''),(2633545,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16545200.00,24880.00,0.00,0.00,'2022-08-25 15:04:33','',''),(2633546,'1','158',NULL,335,'Reception corrector for bridging 132692',0.00,0.00,0.00,24880.00,0.00,'2022-08-25 15:06:10','',''),(2633547,'1','158','780',335,'Received from bridging 132692',0.00,0.00,24880.00,0.00,0.00,'2022-08-25 15:06:10','',''),(2633548,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351296',2613450.00,0.00,0.00,3930.00,0.00,'2022-08-25 15:09:35','',''),(2633549,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351297',3930150.00,0.00,0.00,5910.00,0.00,'2022-08-25 15:09:56','',''),(2633550,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351298',3358250.00,0.00,0.00,5050.00,0.00,'2022-08-25 15:12:36','',''),(2633551,'1','158','780',335,'Distributed to KARU PLANT for sales id:351299',3730650.00,0.00,0.00,5610.00,0.00,'2022-08-25 15:16:21','',''),(2633552,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351300',3571050.00,0.00,0.00,5370.00,0.00,'2022-08-25 15:16:37','',''),(2633553,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16611700.00,24980.00,0.00,0.00,'2022-08-28 11:29:17','',''),(2633554,'1','158',NULL,335,'Reception corrector for bridging 132693',0.00,0.00,0.00,24980.00,0.00,'2022-08-28 11:30:35','',''),(2633555,'1','158','780',335,'Received from bridging 132693',0.00,0.00,24980.00,0.00,0.00,'2022-08-28 11:30:35','',''),(2633556,'1','158','780',335,'Distributed to KARU PLANT for sales id:351302',3251850.00,0.00,0.00,4890.00,0.00,'2022-08-28 11:43:52','',''),(2633557,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351303',3025750.00,0.00,0.00,4550.00,0.00,'2022-08-28 11:44:11','',''),(2633558,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351304',3391500.00,0.00,0.00,5100.00,0.00,'2022-08-28 11:44:28','',''),(2633559,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351305',3185350.00,0.00,0.00,4790.00,0.00,'2022-08-28 11:44:44','',''),(2633560,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351306',3225250.00,0.00,0.00,4850.00,0.00,'2022-08-28 11:45:01','',''),(2633561,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351307',512050.00,0.00,0.00,770.00,0.00,'2022-08-28 11:45:24','',''),(2633562,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16611700.00,24980.00,0.00,0.00,'2022-08-28 11:51:28','',''),(2633563,'1','158',NULL,335,'Reception corrector for bridging 132694',0.00,0.00,0.00,24980.00,0.00,'2022-08-28 11:53:01','',''),(2633564,'1','158','780',335,'Received from bridging 132694',0.00,0.00,24980.00,0.00,0.00,'2022-08-28 11:53:01','',''),(2633565,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351308',2932650.00,0.00,0.00,4410.00,0.00,'2022-08-28 12:34:11','',''),(2633566,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351309',3491250.00,0.00,0.00,5250.00,0.00,'2022-08-28 12:34:29','',''),(2633567,'1','158','780',335,'Distributed to KARU PLANT for sales id:351310',3497900.00,0.00,0.00,5260.00,0.00,'2022-08-28 12:34:45','',''),(2633568,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351311',3551100.00,0.00,0.00,5340.00,0.00,'2022-08-28 12:35:02','',''),(2633569,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351312',3085600.00,0.00,0.00,4640.00,0.00,'2022-08-28 12:35:18','',''),(2633570,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16744700.00,25180.00,0.00,0.00,'2022-08-29 10:30:07','',''),(2633571,'1','158',NULL,335,'Reception corrector for bridging 132695',0.00,0.00,0.00,25180.00,0.00,'2022-08-29 10:31:47','',''),(2633572,'1','158','780',335,'Received from bridging 132695',0.00,0.00,25180.00,0.00,0.00,'2022-08-29 10:31:47','',''),(2633573,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351313',532000.00,0.00,0.00,800.00,0.00,'2022-08-29 10:34:02','',''),(2633574,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351314',3438050.00,0.00,0.00,5170.00,0.00,'2022-08-29 10:41:45','',''),(2633575,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351315',3491250.00,0.00,0.00,5250.00,0.00,'2022-08-29 10:42:00','',''),(2633576,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351316',3524500.00,0.00,0.00,5300.00,0.00,'2022-08-29 10:42:16','',''),(2633577,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351317',2906050.00,0.00,0.00,4370.00,0.00,'2022-08-29 10:42:34','',''),(2633578,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351318',2852850.00,0.00,0.00,4290.00,0.00,'2022-08-29 10:42:53','',''),(2633579,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16591750.00,24950.00,0.00,0.00,'2022-08-30 09:03:38','',''),(2633580,'1','158',NULL,335,'Reception corrector for bridging 132696',0.00,0.00,0.00,24950.00,0.00,'2022-08-30 09:05:17','',''),(2633581,'1','158','780',335,'Received from bridging 132696',0.00,0.00,24950.00,0.00,0.00,'2022-08-30 09:05:17','',''),(2633582,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351319',485450.00,0.00,0.00,730.00,0.00,'2022-08-30 09:09:08','',''),(2633583,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351320',3524500.00,0.00,0.00,5300.00,0.00,'2022-08-30 09:09:58','',''),(2633584,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351321',3444700.00,0.00,0.00,5180.00,0.00,'2022-08-30 09:20:02','',''),(2633585,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351322',3697400.00,0.00,0.00,5560.00,0.00,'2022-08-30 09:20:20','',''),(2633586,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351323',3584350.00,0.00,0.00,5390.00,0.00,'2022-08-30 09:20:37','',''),(2633587,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351324',1748950.00,0.00,0.00,2630.00,0.00,'2022-08-30 09:20:54','',''),(2633588,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16638300.00,25020.00,0.00,0.00,'2022-09-01 06:55:16','',''),(2633589,'1','158',NULL,335,'Reception corrector for bridging 132697',0.00,0.00,0.00,25020.00,0.00,'2022-09-01 06:56:47','',''),(2633590,'1','158','780',335,'Received from bridging 132697',0.00,0.00,25020.00,0.00,0.00,'2022-09-01 06:56:47','',''),(2633591,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351325',1775550.00,0.00,0.00,2670.00,0.00,'2022-09-01 07:01:53','',''),(2633592,'1','158','780',335,'Distributed to ADO PLANT for sales id:351326',3823750.00,0.00,0.00,5750.00,0.00,'2022-09-01 07:02:11','',''),(2633593,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351327',4595150.00,0.00,0.00,6910.00,0.00,'2022-09-01 07:02:28','',''),(2633594,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351328',3391500.00,0.00,0.00,5100.00,0.00,'2022-09-01 07:05:08','',''),(2633595,'1','158','780',335,'Distributed to ADO PLANT for sales id:351329',2786350.00,0.00,0.00,4190.00,0.00,'2022-09-01 07:07:58','',''),(2633596,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16585100.00,24940.00,0.00,0.00,'2022-09-01 12:21:43','',''),(2633597,'1','158',NULL,335,'Reception corrector for bridging 132698',0.00,0.00,0.00,24940.00,0.00,'2022-09-01 12:23:44','',''),(2633598,'1','158','780',335,'Received from bridging 132698',0.00,0.00,24940.00,0.00,0.00,'2022-09-01 12:23:44','',''),(2633599,'1','158','780',335,'Distributed to ADO PLANT for sales id:351330',944300.00,0.00,0.00,1420.00,0.00,'2022-09-01 12:30:45','',''),(2633600,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351331',4123000.00,0.00,0.00,6200.00,0.00,'2022-09-01 12:31:35','',''),(2633601,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351332',3571050.00,0.00,0.00,5370.00,0.00,'2022-09-01 12:31:53','',''),(2633602,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351333',3936800.00,0.00,0.00,5920.00,0.00,'2022-09-01 12:32:09','',''),(2633603,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351334',3072300.00,0.00,0.00,4620.00,0.00,'2022-09-01 12:36:44','',''),(2633604,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351335',784700.00,0.00,0.00,1180.00,0.00,'2022-09-01 12:36:59','',''),(2633605,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16678200.00,25080.00,0.00,0.00,'2022-09-02 12:16:13','',''),(2633606,'1','158',NULL,335,'Reception corrector for bridging 132699',0.00,0.00,0.00,25080.00,0.00,'2022-09-02 12:17:28','',''),(2633607,'1','158','780',335,'Received from bridging 132699',0.00,0.00,25080.00,0.00,0.00,'2022-09-02 12:17:28','',''),(2633608,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351336',3052350.00,0.00,0.00,4590.00,0.00,'2022-09-02 12:25:19','',''),(2633609,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351337',3491250.00,0.00,0.00,5250.00,0.00,'2022-09-02 12:25:39','',''),(2633610,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351338',3371550.00,0.00,0.00,5070.00,0.00,'2022-09-02 12:25:55','',''),(2633611,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351339',3251850.00,0.00,0.00,4890.00,0.00,'2022-09-02 12:26:13','',''),(2633612,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351340',3431400.00,0.00,0.00,5160.00,0.00,'2022-09-02 12:26:30','',''),(2633613,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16611700.00,24980.00,0.00,0.00,'2022-09-03 09:03:42','',''),(2633614,'1','158',NULL,335,'Reception corrector for bridging 132700',0.00,0.00,0.00,24980.00,0.00,'2022-09-03 09:05:15','',''),(2633615,'1','158','780',335,'Received from bridging 132700',0.00,0.00,24980.00,0.00,0.00,'2022-09-03 09:05:15','',''),(2633616,'1','158','780',335,'Distributed to KATAMFE for sales id:351341',3378200.00,0.00,0.00,5080.00,0.00,'2022-09-03 09:07:12','',''),(2633617,'1','158','780',335,'Distributed to KARU PLANT for sales id:351342',4109700.00,0.00,0.00,6180.00,0.00,'2022-09-03 09:11:52','',''),(2633618,'1','158','780',335,'Distributed to ADO PLANT for sales id:351343',3325000.00,0.00,0.00,5000.00,0.00,'2022-09-03 09:12:07','',''),(2633619,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351344',3737300.00,0.00,0.00,5620.00,0.00,'2022-09-03 09:12:22','',''),(2633620,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351345',1948450.00,0.00,0.00,2930.00,0.00,'2022-09-03 09:14:35','',''),(2633621,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16644950.00,25030.00,0.00,0.00,'2022-09-03 18:14:21','',''),(2633622,'1','158',NULL,335,'Reception corrector for bridging 132701',0.00,0.00,0.00,25030.00,0.00,'2022-09-03 18:15:40','',''),(2633623,'1','158','780',335,'Received from bridging 132701',0.00,0.00,25030.00,0.00,0.00,'2022-09-03 18:15:40','',''),(2633624,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351346',1343300.00,0.00,0.00,2020.00,0.00,'2022-09-03 18:23:12','',''),(2633625,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351347',4448850.00,0.00,0.00,6690.00,0.00,'2022-09-03 18:23:29','',''),(2633626,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351348',2108050.00,0.00,0.00,3170.00,0.00,'2022-09-03 18:23:46','',''),(2633627,'1','158','780',335,'Distributed to KARU PLANT for sales id:351349',3059000.00,0.00,0.00,4600.00,0.00,'2022-09-03 18:24:02','',''),(2633628,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351350',3557750.00,0.00,0.00,5350.00,0.00,'2022-09-03 18:24:19','',''),(2633629,'1','158','780',335,'Distributed to KATAMFE for sales id:351351',2081450.00,0.00,0.00,3130.00,0.00,'2022-09-03 18:24:33','',''),(2633630,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16605050.00,24970.00,0.00,0.00,'2022-09-04 15:59:44','',''),(2633631,'1','158',NULL,335,'Reception corrector for bridging 132702',0.00,0.00,0.00,24970.00,0.00,'2022-09-04 16:00:54','',''),(2633632,'1','158','780',335,'Received from bridging 132702',0.00,0.00,24970.00,0.00,0.00,'2022-09-04 16:00:54','',''),(2633633,'1','158','780',335,'Distributed to KATAMFE for sales id:351352',1549450.00,0.00,0.00,2330.00,0.00,'2022-09-04 16:05:29','',''),(2633634,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351353',4402300.00,0.00,0.00,6620.00,0.00,'2022-09-04 16:05:44','',''),(2633635,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351354',2440550.00,0.00,0.00,3670.00,0.00,'2022-09-04 16:06:00','',''),(2633636,'1','158','780',335,'Distributed to KARU PLANT for sales id:351355',3311700.00,0.00,0.00,4980.00,0.00,'2022-09-04 16:10:15','',''),(2633637,'1','158','780',335,'Distributed to ADO PLANT for sales id:351356',3404800.00,0.00,0.00,5120.00,0.00,'2022-09-04 16:10:30','',''),(2633638,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351357',1496250.00,0.00,0.00,2250.00,0.00,'2022-09-04 16:11:07','',''),(2633639,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16625000.00,25000.00,0.00,0.00,'2022-09-05 14:17:15','',''),(2633640,'1','158',NULL,335,'Reception corrector for bridging 132703',0.00,0.00,0.00,25000.00,0.00,'2022-09-05 14:18:33','',''),(2633641,'1','158','780',335,'Received from bridging 132703',0.00,0.00,25000.00,0.00,0.00,'2022-09-05 14:18:33','',''),(2633642,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351361',824600.00,0.00,0.00,1240.00,0.00,'2022-09-05 14:29:49','',''),(2633643,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351362',3597650.00,0.00,0.00,5410.00,0.00,'2022-09-05 14:30:07','',''),(2633644,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351363',3105550.00,0.00,0.00,4670.00,0.00,'2022-09-05 14:30:22','',''),(2633645,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351364',3471300.00,0.00,0.00,5220.00,0.00,'2022-09-05 14:30:37','',''),(2633646,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351365',3305050.00,0.00,0.00,4970.00,0.00,'2022-09-05 14:30:53','',''),(2633647,'1','158','780',335,'Distributed to KARU PLANT for sales id:351366',2267650.00,0.00,0.00,3410.00,0.00,'2022-09-05 14:31:18','',''),(2633648,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16638300.00,25020.00,0.00,0.00,'2022-09-06 09:25:03','',''),(2633649,'1','158',NULL,335,'Reception corrector for bridging 132704',0.00,0.00,0.00,25020.00,0.00,'2022-09-06 09:26:31','',''),(2633650,'1','158','780',335,'Received from bridging 132704',0.00,0.00,25020.00,0.00,0.00,'2022-09-06 09:26:31','',''),(2633651,'1','158','780',335,'Distributed to KARU PLANT for sales id:351367',1290100.00,0.00,0.00,1940.00,0.00,'2022-09-06 09:28:23','',''),(2633652,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351368',3271800.00,0.00,0.00,4920.00,0.00,'2022-09-06 09:38:16','',''),(2633653,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351369',3557750.00,0.00,0.00,5350.00,0.00,'2022-09-06 09:38:33','',''),(2633654,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351370',3331650.00,0.00,0.00,5010.00,0.00,'2022-09-06 09:38:48','',''),(2633655,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351371',3464650.00,0.00,0.00,5210.00,0.00,'2022-09-06 09:39:03','',''),(2633656,'1','158','780',335,'Distributed to ADO PLANT for sales id:351372',1409800.00,0.00,0.00,2120.00,0.00,'2022-09-06 09:39:18','',''),(2633657,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351373',246050.00,0.00,0.00,370.00,0.00,'2022-09-06 09:40:53','',''),(2633658,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16239300.00,24420.00,0.00,0.00,'2022-09-06 16:39:12','',''),(2633659,'1','158',NULL,335,'Reception corrector for bridging 132705',0.00,0.00,0.00,24420.00,0.00,'2022-09-06 16:41:39','',''),(2633660,'1','158','780',335,'Received from bridging 132705',0.00,0.00,24420.00,0.00,0.00,'2022-09-06 16:41:39','',''),(2633661,'1','158','780',335,'Distributed to ADO PLANT for sales id:351374',2280950.00,0.00,0.00,3430.00,0.00,'2022-09-06 16:44:00','',''),(2633662,'1','158','780',335,'Distributed to KARU PLANT for sales id:351375',3497900.00,0.00,0.00,5260.00,0.00,'2022-09-06 16:50:41','',''),(2633663,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351376',3477950.00,0.00,0.00,5230.00,0.00,'2022-09-06 16:50:56','',''),(2633664,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351377',3491250.00,0.00,0.00,5250.00,0.00,'2022-09-06 16:51:21','',''),(2633665,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351378',3285100.00,0.00,0.00,4940.00,0.00,'2022-09-06 16:51:39','',''),(2633666,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351379',206150.00,0.00,0.00,310.00,0.00,'2022-09-06 16:53:26','',''),(2633667,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-09-09 17:37:42','',''),(2633668,'1','158',NULL,335,'Reception corrector for bridging 132706',0.00,0.00,0.00,24960.00,0.00,'2022-09-09 17:39:15','',''),(2633669,'1','158','780',335,'Received from bridging 132706',0.00,0.00,24960.00,0.00,0.00,'2022-09-09 17:39:15','',''),(2633670,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351380',3637550.00,0.00,0.00,5470.00,0.00,'2022-09-09 17:41:19','',''),(2633671,'1','158','780',335,'Distributed to KARU PLANT for sales id:351381',3517850.00,0.00,0.00,5290.00,0.00,'2022-09-09 17:47:48','',''),(2633672,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351382',3670800.00,0.00,0.00,5520.00,0.00,'2022-09-09 17:48:04','',''),(2633673,'1','158','780',335,'Distributed to ADO PLANT for sales id:351383',3650850.00,0.00,0.00,5490.00,0.00,'2022-09-09 17:48:19','',''),(2633674,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351384',2121350.00,0.00,0.00,3190.00,0.00,'2022-09-09 17:48:34','',''),(2633675,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16651600.00,25040.00,0.00,0.00,'2022-09-09 17:50:50','',''),(2633676,'1','158',NULL,335,'Reception corrector for bridging 132707',0.00,0.00,0.00,25040.00,0.00,'2022-09-09 17:52:23','',''),(2633677,'1','158','780',335,'Received from bridging 132707',0.00,0.00,25040.00,0.00,0.00,'2022-09-09 17:52:23','',''),(2633678,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351385',864500.00,0.00,0.00,1300.00,0.00,'2022-09-09 17:54:05','',''),(2633679,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351386',3624250.00,0.00,0.00,5450.00,0.00,'2022-09-09 18:01:36','',''),(2633680,'1','158','780',335,'Distributed to KARU PLANT for sales id:351387',3617600.00,0.00,0.00,5440.00,0.00,'2022-09-09 18:01:51','',''),(2633681,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351388',3005800.00,0.00,0.00,4520.00,0.00,'2022-09-09 18:02:08','',''),(2633682,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351389',3511200.00,0.00,0.00,5280.00,0.00,'2022-09-09 18:02:29','',''),(2633683,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351390',2028250.00,0.00,0.00,3050.00,0.00,'2022-09-09 18:02:46','',''),(2633684,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16598400.00,24960.00,0.00,0.00,'2022-09-09 18:04:21','',''),(2633685,'1','158',NULL,335,'Reception corrector for bridging 132708',0.00,0.00,0.00,24960.00,0.00,'2022-09-09 18:05:44','',''),(2633686,'1','158','780',335,'Received from bridging 132708',0.00,0.00,24960.00,0.00,0.00,'2022-09-09 18:05:44','',''),(2633687,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351391',1522850.00,0.00,0.00,2290.00,0.00,'2022-09-09 18:08:47','',''),(2633688,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351392',3178700.00,0.00,0.00,4780.00,0.00,'2022-09-09 18:09:06','',''),(2633689,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351393',3271800.00,0.00,0.00,4920.00,0.00,'2022-09-09 18:15:53','',''),(2633690,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351394',3464650.00,0.00,0.00,5210.00,0.00,'2022-09-09 18:16:08','',''),(2633691,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351395',2114700.00,0.00,0.00,3180.00,0.00,'2022-09-09 18:16:41','',''),(2633692,'1','158','780',335,'Distributed to KARU PLANT for sales id:351396',3045700.00,0.00,0.00,4580.00,0.00,'2022-09-09 18:17:17','',''),(2633693,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,11451300.00,17220.00,0.00,0.00,'2022-09-10 16:02:41','',''),(2633694,'1','158',NULL,335,'Reception corrector for bridging 132709',0.00,0.00,0.00,17220.00,0.00,'2022-09-10 16:07:51','',''),(2633695,'1','158','780',335,'Received from bridging 132709',0.00,0.00,17220.00,0.00,0.00,'2022-09-10 16:07:51','',''),(2633696,'1','158','780',335,'Distributed to KARU PLANT for sales id:351397',704900.00,0.00,0.00,1060.00,0.00,'2022-09-10 16:39:28','',''),(2633697,'1','158','780',335,'Distributed to KATAMFE for sales id:351398',1768900.00,0.00,0.00,2660.00,0.00,'2022-09-10 16:39:47','',''),(2633698,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351399',1995000.00,0.00,0.00,3000.00,0.00,'2022-09-10 16:40:22','',''),(2633699,'1','158','780',335,'Distributed to ADO PLANT for sales id:351400',1768900.00,0.00,0.00,2660.00,0.00,'2022-09-10 16:48:40','',''),(2633700,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351401',3085600.00,0.00,0.00,4640.00,0.00,'2022-09-10 16:48:56','',''),(2633701,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351402',2866150.00,0.00,0.00,4310.00,0.00,'2022-09-10 16:49:12','',''),(2633702,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16505300.00,24820.00,0.00,0.00,'2022-09-12 14:39:59','',''),(2633703,'1','158',NULL,335,'Reception corrector for bridging 132710',0.00,0.00,0.00,24820.00,0.00,'2022-09-12 14:41:26','',''),(2633704,'1','158','780',335,'Received from bridging 132710',0.00,0.00,24820.00,0.00,0.00,'2022-09-12 14:41:26','',''),(2633705,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351404',3471300.00,0.00,0.00,5220.00,0.00,'2022-09-12 14:47:51','',''),(2633706,'1','158','780',335,'Distributed to KARU PLANT for sales id:351405',3730650.00,0.00,0.00,5610.00,0.00,'2022-09-12 14:48:16','',''),(2633707,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351406',3471300.00,0.00,0.00,5220.00,0.00,'2022-09-12 14:48:34','',''),(2633708,'1','158','780',335,'Distributed to KATAMFE for sales id:351408',2247700.00,0.00,0.00,3380.00,0.00,'2022-09-12 14:48:52','',''),(2633709,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351407',3584350.00,0.00,0.00,5390.00,0.00,'2022-09-12 14:49:22','',''),(2633710,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16651600.00,25040.00,0.00,0.00,'2022-09-13 11:27:24','',''),(2633711,'1','158',NULL,335,'Reception corrector for bridging 132711',0.00,0.00,0.00,25040.00,0.00,'2022-09-13 11:28:39','',''),(2633712,'1','158','780',335,'Received from bridging 132711',0.00,0.00,25040.00,0.00,0.00,'2022-09-13 11:28:39','',''),(2633713,'1','158','780',335,'Distributed to KATAMFE for sales id:351409',871150.00,0.00,0.00,1310.00,0.00,'2022-09-13 11:36:36','',''),(2633714,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351410',4681600.00,0.00,0.00,7040.00,0.00,'2022-09-13 11:36:52','',''),(2633715,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351411',2959250.00,0.00,0.00,4450.00,0.00,'2022-09-13 11:37:11','',''),(2633716,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351412',3185350.00,0.00,0.00,4790.00,0.00,'2022-09-13 11:37:27','',''),(2633717,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351413',3591000.00,0.00,0.00,5400.00,0.00,'2022-09-13 11:37:44','',''),(2633718,'1','158','780',335,'Distributed to KARU PLANT for sales id:351414',1363250.00,0.00,0.00,2050.00,0.00,'2022-09-13 11:40:50','',''),(2633719,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16545200.00,24880.00,0.00,0.00,'2022-09-14 15:43:12','',''),(2633720,'1','158',NULL,335,'Reception corrector for bridging 132712',0.00,0.00,0.00,24880.00,0.00,'2022-09-14 15:44:20','',''),(2633721,'1','158','780',335,'Received from bridging 132712',0.00,0.00,24880.00,0.00,0.00,'2022-09-14 15:44:20','',''),(2633722,'1','158','780',335,'Distributed to KARU PLANT for sales id:351415',2400650.00,0.00,0.00,3610.00,0.00,'2022-09-14 15:52:17','',''),(2633723,'1','158','780',335,'Distributed to ADO PLANT for sales id:351416',3231900.00,0.00,0.00,4860.00,0.00,'2022-09-14 15:52:35','',''),(2633724,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351417',2327500.00,0.00,0.00,3500.00,0.00,'2022-09-14 15:52:52','',''),(2633725,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351418',3198650.00,0.00,0.00,4810.00,0.00,'2022-09-14 15:53:08','',''),(2633726,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351419',3664150.00,0.00,0.00,5510.00,0.00,'2022-09-14 15:53:22','',''),(2633727,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351420',1722350.00,0.00,0.00,2590.00,0.00,'2022-09-14 15:53:40','',''),(2633728,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16545200.00,24880.00,0.00,0.00,'2022-09-20 11:13:10','',''),(2633729,'1','158',NULL,335,'Reception corrector for bridging 132713',0.00,0.00,0.00,24880.00,0.00,'2022-09-20 11:14:46','',''),(2633730,'1','158','780',335,'Received from bridging 132713',0.00,0.00,24880.00,0.00,0.00,'2022-09-20 11:14:46','',''),(2633731,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351421',478800.00,0.00,0.00,720.00,0.00,'2022-09-20 11:17:07','',''),(2633732,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351422',2054850.00,0.00,0.00,3090.00,0.00,'2022-09-20 11:26:12','',''),(2633733,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351423',3451350.00,0.00,0.00,5190.00,0.00,'2022-09-20 11:26:35','',''),(2633734,'1','158','780',335,'Distributed to KARU PLANT for sales id:351424',3717350.00,0.00,0.00,5590.00,0.00,'2022-09-20 11:26:58','',''),(2633735,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351425',3803800.00,0.00,0.00,5720.00,0.00,'2022-09-20 11:27:17','',''),(2633736,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351426',3039050.00,0.00,0.00,4570.00,0.00,'2022-09-20 11:27:45','',''),(2633737,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16585100.00,24940.00,0.00,0.00,'2022-09-21 11:31:29','',''),(2633738,'1','158',NULL,335,'Reception corrector for bridging 132714',0.00,0.00,0.00,24940.00,0.00,'2022-09-21 11:33:05','',''),(2633739,'1','158','780',335,'Received from bridging 132714',0.00,0.00,24940.00,0.00,0.00,'2022-09-21 11:33:05','',''),(2633740,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351427',299250.00,0.00,0.00,450.00,0.00,'2022-09-21 11:42:44','',''),(2633741,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351428',3258500.00,0.00,0.00,4900.00,0.00,'2022-09-21 11:43:01','',''),(2633742,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351429',3012450.00,0.00,0.00,4530.00,0.00,'2022-09-21 11:43:20','',''),(2633743,'1','158','780',335,'Distributed to KATAMFE for sales id:351431',4016600.00,0.00,0.00,6040.00,0.00,'2022-09-21 11:49:49','',''),(2633744,'1','158','780',335,'Distributed to KARU PLANT for sales id:351432',4016600.00,0.00,0.00,6040.00,0.00,'2022-09-21 11:50:06','',''),(2633745,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351433',3577700.00,0.00,0.00,5380.00,0.00,'2022-09-21 11:50:29','',''),(2633746,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16571800.00,24920.00,0.00,0.00,'2022-09-21 12:00:30','',''),(2633747,'1','158',NULL,335,'Reception corrector for bridging 132715',0.00,0.00,0.00,24920.00,0.00,'2022-09-21 12:02:28','',''),(2633748,'1','158','780',335,'Received from bridging 132715',0.00,0.00,24920.00,0.00,0.00,'2022-09-21 12:02:28','',''),(2633749,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351435',2912700.00,0.00,0.00,4380.00,0.00,'2022-09-21 12:14:57','',''),(2633750,'1','158','780',335,'Distributed to KARU PLANT for sales id:351436',3491250.00,0.00,0.00,5250.00,0.00,'2022-09-21 12:15:21','',''),(2633751,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351437',3604300.00,0.00,0.00,5420.00,0.00,'2022-09-21 12:15:40','',''),(2633752,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351438',3305050.00,0.00,0.00,4970.00,0.00,'2022-09-21 12:15:58','',''),(2633753,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351439',3078950.00,0.00,0.00,4630.00,0.00,'2022-09-21 12:16:17','',''),(2633754,'1','158','780',335,'Distributed to ADO PLANT for sales id:351440',179550.00,0.00,0.00,270.00,0.00,'2022-09-21 12:16:45','',''),(2633755,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16585100.00,24940.00,0.00,0.00,'2022-09-21 12:19:14','',''),(2633756,'1','158',NULL,335,'Reception corrector for bridging 132716',0.00,0.00,0.00,24940.00,0.00,'2022-09-21 12:21:17','',''),(2633757,'1','158','780',335,'Received from bridging 132716',0.00,0.00,24940.00,0.00,0.00,'2022-09-21 12:21:17','',''),(2633758,'1','158','780',335,'Distributed to ADO PLANT for sales id:351441',3072300.00,0.00,0.00,4620.00,0.00,'2022-09-21 12:28:57','',''),(2633759,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351442',3451350.00,0.00,0.00,5190.00,0.00,'2022-09-21 12:29:19','',''),(2633760,'1','158','780',335,'Distributed to KATAMFE for sales id:351443',2008300.00,0.00,0.00,3020.00,0.00,'2022-09-21 12:29:36','',''),(2633761,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351444',2314200.00,0.00,0.00,3480.00,0.00,'2022-09-21 12:29:52','',''),(2633762,'1','158','780',335,'Distributed to KARU PLANT for sales id:351445',3936800.00,0.00,0.00,5920.00,0.00,'2022-09-21 12:36:09','',''),(2633763,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351446',638400.00,0.00,0.00,960.00,0.00,'2022-09-21 12:36:26','',''),(2633764,'1','158','781',335,'Distributed to KARU PLANT for sales id:351447',1030750.00,0.00,0.00,1550.00,0.00,'2022-09-21 12:44:19','',''),(2633765,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-09-22 12:26:51','',''),(2633766,'1','158',NULL,335,'Reception corrector for bridging 132717',0.00,0.00,0.00,24880.00,0.00,'2022-09-22 12:28:59','',''),(2633767,'1','158','780',335,'Received from bridging 132717',0.00,0.00,24880.00,0.00,0.00,'2022-09-22 12:28:59','',''),(2633768,'1','158','780',335,'Distributed to KARU PLANT for sales id:351448',3042600.00,0.00,0.00,4610.00,0.00,'2022-09-22 12:42:53','',''),(2633769,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351449',2448600.00,0.00,0.00,3710.00,0.00,'2022-09-22 12:43:16','',''),(2633770,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351450',3438600.00,0.00,0.00,5210.00,0.00,'2022-09-22 12:43:36','',''),(2633771,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351451',3267000.00,0.00,0.00,4950.00,0.00,'2022-09-22 12:44:43','',''),(2633772,'1','158','780',335,'Distributed to KATAMFE for sales id:351452',3333000.00,0.00,0.00,5050.00,0.00,'2022-09-22 12:45:10','',''),(2633773,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351453',891000.00,0.00,0.00,1350.00,0.00,'2022-09-22 12:45:27','',''),(2633774,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16486800.00,24980.00,0.00,0.00,'2022-09-22 12:47:27','',''),(2633775,'1','158',NULL,335,'Reception corrector for bridging 132718',0.00,0.00,0.00,24980.00,0.00,'2022-09-22 12:48:46','',''),(2633776,'1','158','780',335,'Received from bridging 132718',0.00,0.00,24980.00,0.00,0.00,'2022-09-22 12:48:46','',''),(2633777,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351454',2567400.00,0.00,0.00,3890.00,0.00,'2022-09-22 12:54:32','',''),(2633778,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351455',8758200.00,0.00,0.00,13270.00,0.00,'2022-09-22 12:54:50','',''),(2633779,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351456',3445200.00,0.00,0.00,5220.00,0.00,'2022-09-22 12:59:44','',''),(2633780,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351457',1716000.00,0.00,0.00,2600.00,0.00,'2022-09-22 13:00:03','',''),(2633781,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-09-22 13:02:26','',''),(2633782,'1','158',NULL,335,'Reception corrector for bridging 132719',0.00,0.00,0.00,25000.00,0.00,'2022-09-22 13:03:41','',''),(2633783,'1','158','780',335,'Received from bridging 132719',0.00,0.00,25000.00,0.00,0.00,'2022-09-22 13:03:41','',''),(2633784,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351458',1696200.00,0.00,0.00,2570.00,0.00,'2022-09-22 13:13:49','',''),(2633785,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351459',3326400.00,0.00,0.00,5040.00,0.00,'2022-09-22 13:14:06','',''),(2633786,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351460',3550800.00,0.00,0.00,5380.00,0.00,'2022-09-22 13:14:29','',''),(2633787,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351461',3465000.00,0.00,0.00,5250.00,0.00,'2022-09-22 13:14:50','',''),(2633788,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351462',3379200.00,0.00,0.00,5120.00,0.00,'2022-09-22 13:15:05','',''),(2633789,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351463',1082400.00,0.00,0.00,1640.00,0.00,'2022-09-22 13:18:16','',''),(2633790,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16632000.00,25200.00,0.00,0.00,'2022-09-22 13:34:30','',''),(2633791,'1','158',NULL,335,'Reception corrector for bridging 132720',0.00,0.00,0.00,25200.00,0.00,'2022-09-22 13:35:54','',''),(2633792,'1','158','780',335,'Received from bridging 132720',0.00,0.00,25200.00,0.00,0.00,'2022-09-22 13:35:54','',''),(2633793,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351464',2277000.00,0.00,0.00,3450.00,0.00,'2022-09-22 13:45:46','',''),(2633794,'1','158','780',335,'Distributed to KARU PLANT for sales id:351465',8751600.00,0.00,0.00,13260.00,0.00,'2022-09-22 13:46:09','',''),(2633795,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351466',3590400.00,0.00,0.00,5440.00,0.00,'2022-09-22 13:46:33','',''),(2633796,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351467',1973400.00,0.00,0.00,2990.00,0.00,'2022-09-22 13:46:54','',''),(2633797,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-09-24 11:42:30','',''),(2633798,'1','158',NULL,335,'Reception corrector for bridging 132721',0.00,0.00,0.00,24880.00,0.00,'2022-09-24 11:44:28','',''),(2633799,'1','158','780',335,'Received from bridging 132721',0.00,0.00,24880.00,0.00,0.00,'2022-09-24 11:44:28','',''),(2633800,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351468',1372800.00,0.00,0.00,2080.00,0.00,'2022-09-24 11:52:26','',''),(2633801,'1','158','780',335,'Distributed to ADO PLANT for sales id:351469',3669600.00,0.00,0.00,5560.00,0.00,'2022-09-24 11:52:42','',''),(2633802,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351470',3339600.00,0.00,0.00,5060.00,0.00,'2022-09-24 11:59:45','',''),(2633803,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351471',3775200.00,0.00,0.00,5720.00,0.00,'2022-09-24 12:00:07','',''),(2633804,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351472',3715800.00,0.00,0.00,5630.00,0.00,'2022-09-24 12:00:25','',''),(2633805,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351473',547800.00,0.00,0.00,830.00,0.00,'2022-09-24 12:00:43','',''),(2633806,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-09-27 10:10:15','',''),(2633807,'1','158',NULL,335,'Reception corrector for bridging 132722',0.00,0.00,0.00,24960.00,0.00,'2022-09-27 10:11:55','',''),(2633808,'1','158','780',335,'Received from bridging 132722',0.00,0.00,24960.00,0.00,0.00,'2022-09-27 10:11:55','',''),(2633809,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351474',2983200.00,0.00,0.00,4520.00,0.00,'2022-09-27 10:15:56','',''),(2633810,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351475',3465000.00,0.00,0.00,5250.00,0.00,'2022-09-27 10:16:18','',''),(2633811,'1','158','780',335,'Distributed to KARU PLANT for sales id:351476',3960000.00,0.00,0.00,6000.00,0.00,'2022-09-27 10:24:05','',''),(2633812,'1','158','780',335,'Distributed to KATAMFE for sales id:351477',3372600.00,0.00,0.00,5110.00,0.00,'2022-09-27 10:24:28','',''),(2633813,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351478',2257200.00,0.00,0.00,3420.00,0.00,'2022-09-27 10:24:45','',''),(2633814,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-09-27 10:33:19','',''),(2633815,'1','158',NULL,335,'Reception corrector for bridging 132723',0.00,0.00,0.00,24960.00,0.00,'2022-09-27 10:34:47','',''),(2633816,'1','158','780',335,'Received from bridging 132723',0.00,0.00,24960.00,0.00,0.00,'2022-09-27 10:34:47','',''),(2633817,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351479',1029600.00,0.00,0.00,1560.00,0.00,'2022-09-27 10:36:41','',''),(2633818,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351480',3676200.00,0.00,0.00,5570.00,0.00,'2022-09-27 10:43:04','',''),(2633819,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351481',3366000.00,0.00,0.00,5100.00,0.00,'2022-09-27 10:43:23','',''),(2633820,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351482',3445200.00,0.00,0.00,5220.00,0.00,'2022-09-27 10:43:41','',''),(2633821,'1','158','780',335,'Distributed to ADO PLANT for sales id:351483',3597000.00,0.00,0.00,5450.00,0.00,'2022-09-27 10:47:56','',''),(2633822,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351484',1293600.00,0.00,0.00,1960.00,0.00,'2022-09-27 10:48:14','',''),(2633823,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16493400.00,24990.00,0.00,0.00,'2022-09-27 10:50:15','',''),(2633824,'1','158',NULL,335,'Reception corrector for bridging 132724',0.00,0.00,0.00,24990.00,0.00,'2022-09-27 10:51:41','',''),(2633825,'1','158','780',335,'Received from bridging 132724',0.00,0.00,24990.00,0.00,0.00,'2022-09-27 10:51:41','',''),(2633826,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351485',2125200.00,0.00,0.00,3220.00,0.00,'2022-09-27 10:55:01','',''),(2633827,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351486',3359400.00,0.00,0.00,5090.00,0.00,'2022-09-27 10:55:18','',''),(2633828,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351487',3405600.00,0.00,0.00,5160.00,0.00,'2022-09-27 11:02:02','',''),(2633829,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351488',3148200.00,0.00,0.00,4770.00,0.00,'2022-09-27 11:02:20','',''),(2633830,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351489',3696000.00,0.00,0.00,5600.00,0.00,'2022-09-27 11:02:38','',''),(2633831,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351490',429000.00,0.00,0.00,650.00,0.00,'2022-09-27 11:03:00','',''),(2633832,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16493400.00,24990.00,0.00,0.00,'2022-09-28 10:08:44','',''),(2633833,'1','158',NULL,335,'Reception corrector for bridging 132725',0.00,0.00,0.00,24990.00,0.00,'2022-09-28 10:10:35','',''),(2633834,'1','158','780',335,'Received from bridging 132725',0.00,0.00,24990.00,0.00,0.00,'2022-09-28 10:10:35','',''),(2633835,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351491',3009600.00,0.00,0.00,4560.00,0.00,'2022-09-28 10:17:51','',''),(2633836,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351492',3630000.00,0.00,0.00,5500.00,0.00,'2022-09-28 10:18:10','',''),(2633837,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351493',3359400.00,0.00,0.00,5090.00,0.00,'2022-09-28 10:18:28','',''),(2633838,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351494',2739000.00,0.00,0.00,4150.00,0.00,'2022-09-28 10:24:03','',''),(2633839,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351495',3379200.00,0.00,0.00,5120.00,0.00,'2022-09-28 10:24:18','',''),(2633840,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351496',85800.00,0.00,0.00,130.00,0.00,'2022-09-28 10:24:34','',''),(2633841,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16447200.00,24920.00,0.00,0.00,'2022-09-29 10:55:04','',''),(2633842,'1','158',NULL,335,'Reception corrector for bridging 132726',0.00,0.00,0.00,24920.00,0.00,'2022-09-29 10:57:43','',''),(2633843,'1','158','780',335,'Received from bridging 132726',0.00,0.00,24920.00,0.00,0.00,'2022-09-29 10:57:43','',''),(2633844,'1','158','780',335,'Distributed to KARU PLANT for sales id:351497',8243400.00,0.00,0.00,12490.00,0.00,'2022-09-29 11:06:22','',''),(2633845,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351498',3326400.00,0.00,0.00,5040.00,0.00,'2022-09-29 11:06:43','',''),(2633846,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351499',3359400.00,0.00,0.00,5090.00,0.00,'2022-09-29 11:11:30','',''),(2633847,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351500',1432200.00,0.00,0.00,2170.00,0.00,'2022-09-29 11:11:47','',''),(2633848,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16486800.00,24980.00,0.00,0.00,'2022-09-30 08:32:10','',''),(2633849,'1','158',NULL,335,'Reception corrector for bridging 132727',0.00,0.00,0.00,24980.00,0.00,'2022-09-30 08:33:32','',''),(2633850,'1','158','780',335,'Received from bridging 132727',0.00,0.00,24980.00,0.00,0.00,'2022-09-30 08:33:32','',''),(2633851,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351501',2145000.00,0.00,0.00,3250.00,0.00,'2022-09-30 08:38:18','',''),(2633852,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351502',3352800.00,0.00,0.00,5080.00,0.00,'2022-09-30 08:38:34','',''),(2633853,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351503',3946800.00,0.00,0.00,5980.00,0.00,'2022-09-30 08:38:50','',''),(2633854,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351504',3379200.00,0.00,0.00,5120.00,0.00,'2022-09-30 08:42:34','',''),(2633855,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351505',3478200.00,0.00,0.00,5270.00,0.00,'2022-09-30 08:42:50','',''),(2633856,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16552800.00,25080.00,0.00,0.00,'2022-10-01 14:30:36','',''),(2633857,'1','158',NULL,335,'Reception corrector for bridging 132728',0.00,0.00,0.00,25080.00,0.00,'2022-10-01 14:31:47','',''),(2633858,'1','158','780',335,'Received from bridging 132728',0.00,0.00,25080.00,0.00,0.00,'2022-10-01 14:31:47','',''),(2633859,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351506',3339600.00,0.00,0.00,5060.00,0.00,'2022-10-01 14:37:42','',''),(2633860,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351507',3504600.00,0.00,0.00,5310.00,0.00,'2022-10-01 14:37:57','',''),(2633861,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351508',3346200.00,0.00,0.00,5070.00,0.00,'2022-10-01 14:38:11','',''),(2633862,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351509',2983200.00,0.00,0.00,4520.00,0.00,'2022-10-01 14:38:26','',''),(2633863,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351510',3339600.00,0.00,0.00,5060.00,0.00,'2022-10-01 14:40:43','',''),(2633864,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16434000.00,24900.00,0.00,0.00,'2022-10-02 13:18:01','',''),(2633865,'1','158',NULL,335,'Reception corrector for bridging 132729',0.00,0.00,0.00,24900.00,0.00,'2022-10-02 13:21:40','',''),(2633866,'1','158','780',335,'Received from bridging 132729',0.00,0.00,24900.00,0.00,0.00,'2022-10-02 13:21:40','',''),(2633867,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351511',231000.00,0.00,0.00,350.00,0.00,'2022-10-02 13:29:16','',''),(2633868,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351512',3663000.00,0.00,0.00,5550.00,0.00,'2022-10-02 13:29:31','',''),(2633869,'1','158','780',335,'Distributed to KARU PLANT for sales id:351513',3405600.00,0.00,0.00,5160.00,0.00,'2022-10-02 13:29:49','',''),(2633870,'1','158','780',335,'Distributed to ELOFUSIM GAS for sales id:351514',2791800.00,0.00,0.00,4230.00,0.00,'2022-10-02 13:30:04','',''),(2633871,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351515',3240600.00,0.00,0.00,4910.00,0.00,'2022-10-02 13:30:21','',''),(2633872,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351516',2580600.00,0.00,0.00,3910.00,0.00,'2022-10-02 13:30:36','',''),(2633873,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16407600.00,24860.00,0.00,0.00,'2022-10-03 11:24:57','',''),(2633874,'1','158',NULL,335,'Reception corrector for bridging 132730',0.00,0.00,0.00,24860.00,0.00,'2022-10-03 11:26:18','',''),(2633875,'1','158','780',335,'Received from bridging 132730',0.00,0.00,24860.00,0.00,0.00,'2022-10-03 11:26:18','',''),(2633876,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351517',943800.00,0.00,0.00,1430.00,0.00,'2022-10-03 11:28:17','',''),(2633877,'1','158','780',335,'Distributed to KARU PLANT for sales id:351518',3623400.00,0.00,0.00,5490.00,0.00,'2022-10-03 11:36:14','',''),(2633878,'1','158','780',335,'Distributed to KATAMFE for sales id:351519',3682800.00,0.00,0.00,5580.00,0.00,'2022-10-03 11:36:36','',''),(2633879,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351520',3273600.00,0.00,0.00,4960.00,0.00,'2022-10-03 11:36:54','',''),(2633880,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351521',3696000.00,0.00,0.00,5600.00,0.00,'2022-10-03 11:37:14','',''),(2633881,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351522',1108800.00,0.00,0.00,1680.00,0.00,'2022-10-03 11:37:33','',''),(2633882,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16434000.00,24900.00,0.00,0.00,'2022-10-04 00:14:23','',''),(2633883,'1','158',NULL,335,'Reception corrector for bridging 132731',0.00,0.00,0.00,24900.00,0.00,'2022-10-04 00:15:45','',''),(2633884,'1','158','780',335,'Received from bridging 132731',0.00,0.00,24900.00,0.00,0.00,'2022-10-04 00:15:45','',''),(2633885,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351523',2389200.00,0.00,0.00,3620.00,0.00,'2022-10-04 00:18:13','',''),(2633886,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351524',3148200.00,0.00,0.00,4770.00,0.00,'2022-10-04 00:24:37','',''),(2633887,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351525',3135000.00,0.00,0.00,4750.00,0.00,'2022-10-04 00:24:54','',''),(2633888,'1','158','780',335,'Distributed to KARU PLANT for sales id:351526',4158000.00,0.00,0.00,6300.00,0.00,'2022-10-04 00:25:10','',''),(2633889,'1','158','780',335,'Distributed to KARU PLANT for sales id:351527',3847800.00,0.00,0.00,5830.00,0.00,'2022-10-04 00:25:25','',''),(2633890,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-10-05 11:12:10','',''),(2633891,'1','158',NULL,335,'Reception corrector for bridging 132732',0.00,0.00,0.00,24880.00,0.00,'2022-10-05 11:13:34','',''),(2633892,'1','158','780',335,'Received from bridging 132732',0.00,0.00,24880.00,0.00,0.00,'2022-10-05 11:13:34','',''),(2633893,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351529',2785200.00,0.00,0.00,4220.00,0.00,'2022-10-05 11:19:21','',''),(2633894,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351530',3207600.00,0.00,0.00,4860.00,0.00,'2022-10-05 11:28:22','',''),(2633895,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351531',2574000.00,0.00,0.00,3900.00,0.00,'2022-10-05 11:28:47','',''),(2633896,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351532',2811600.00,0.00,0.00,4260.00,0.00,'2022-10-05 11:30:46','',''),(2633897,'1','158','780',335,'Distributed to ADO PLANT for sales id:351533',1808400.00,0.00,0.00,2740.00,0.00,'2022-10-05 11:31:38','',''),(2633898,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351534',3016200.00,0.00,0.00,4570.00,0.00,'2022-10-05 11:31:56','',''),(2633899,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-07 07:49:36','',''),(2633900,'1','158',NULL,335,'Reception corrector for bridging 132733',0.00,0.00,0.00,24960.00,0.00,'2022-10-07 07:51:49','',''),(2633901,'1','158','780',335,'Received from bridging 132733',0.00,0.00,24960.00,0.00,0.00,'2022-10-07 07:51:49','',''),(2633902,'1','158','780',335,'Distributed to KARU PLANT for sales id:351535',4138200.00,0.00,0.00,6270.00,0.00,'2022-10-07 07:59:34','',''),(2633903,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351536',2085600.00,0.00,0.00,3160.00,0.00,'2022-10-07 07:59:55','',''),(2633904,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351537',3425400.00,0.00,0.00,5190.00,0.00,'2022-10-07 08:00:20','',''),(2633905,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351538',3392400.00,0.00,0.00,5140.00,0.00,'2022-10-07 08:00:37','',''),(2633906,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351539',3214200.00,0.00,0.00,4870.00,0.00,'2022-10-07 08:00:55','',''),(2633907,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351540',79200.00,0.00,0.00,120.00,0.00,'2022-10-07 08:02:38','',''),(2633908,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-07 14:33:34','',''),(2633909,'1','158',NULL,335,'Reception corrector for bridging 132734',0.00,0.00,0.00,24960.00,0.00,'2022-10-07 14:35:11','',''),(2633910,'1','158','780',335,'Received from bridging 132734',0.00,0.00,24960.00,0.00,0.00,'2022-10-07 14:35:11','',''),(2633911,'1','158','780',335,'Distributed to KATAMFE for sales id:351541',2791800.00,0.00,0.00,4230.00,0.00,'2022-10-07 14:39:46','',''),(2633912,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351542',2838000.00,0.00,0.00,4300.00,0.00,'2022-10-07 14:40:01','',''),(2633913,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351543',2428800.00,0.00,0.00,3680.00,0.00,'2022-10-07 14:40:22','',''),(2633914,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351544',2131800.00,0.00,0.00,3230.00,0.00,'2022-10-07 14:49:16','',''),(2633915,'1','158','780',335,'Distributed to KARU PLANT for sales id:351545',2422200.00,0.00,0.00,3670.00,0.00,'2022-10-07 14:49:38','',''),(2633916,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351546',2224200.00,0.00,0.00,3370.00,0.00,'2022-10-07 14:49:55','',''),(2633917,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351547',1874400.00,0.00,0.00,2840.00,0.00,'2022-10-07 14:50:13','',''),(2633918,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-09 15:25:41','',''),(2633919,'1','158',NULL,335,'Reception corrector for bridging 132735',0.00,0.00,0.00,24960.00,0.00,'2022-10-09 15:26:51','',''),(2633920,'1','158','780',335,'Received from bridging 132735',0.00,0.00,24960.00,0.00,0.00,'2022-10-09 15:26:51','',''),(2633921,'1','158','780',335,'Distributed to KARU PLANT for sales id:351549',3300000.00,0.00,0.00,5000.00,0.00,'2022-10-09 15:32:39','',''),(2633922,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351548',1656600.00,0.00,0.00,2510.00,0.00,'2022-10-09 15:35:01','',''),(2633923,'1','158','780',335,'Distributed to ADO PLANT for sales id:351550',2607000.00,0.00,0.00,3950.00,0.00,'2022-10-09 15:35:19','',''),(2633924,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351551',2356200.00,0.00,0.00,3570.00,0.00,'2022-10-09 15:35:35','',''),(2633925,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351552',2442000.00,0.00,0.00,3700.00,0.00,'2022-10-09 15:35:52','',''),(2633926,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351553',2118600.00,0.00,0.00,3210.00,0.00,'2022-10-09 15:39:35','',''),(2633927,'1','158','780',335,'Distributed to KARU PLANT for sales id:351554',1841400.00,0.00,0.00,2790.00,0.00,'2022-10-09 15:39:53','',''),(2633928,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-10 19:23:27','',''),(2633929,'1','158',NULL,335,'Reception corrector for bridging 132736',0.00,0.00,0.00,24960.00,0.00,'2022-10-10 19:24:39','',''),(2633930,'1','158','780',335,'Received from bridging 132736',0.00,0.00,24960.00,0.00,0.00,'2022-10-10 19:24:39','',''),(2633931,'1','158','780',335,'Returned bridging 132736',0.00,0.00,0.00,24960.00,0.00,'2022-10-10 19:27:35','',''),(2633932,'1','158',NULL,335,'Reception Return corrector for bridging 132736',0.00,0.00,24960.00,0.00,0.00,'2022-10-10 19:27:35','',''),(2633933,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16453800.00,24930.00,0.00,0.00,'2022-10-10 19:33:03','',''),(2633934,'1','158',NULL,335,'Reception corrector for bridging 132737',0.00,0.00,0.00,24930.00,0.00,'2022-10-10 19:34:35','',''),(2633935,'1','158','780',335,'Received from bridging 132737',0.00,0.00,24930.00,0.00,0.00,'2022-10-10 19:34:35','',''),(2633936,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351555',8368800.00,0.00,0.00,12680.00,0.00,'2022-10-10 19:39:55','',''),(2633937,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351556',2851200.00,0.00,0.00,4320.00,0.00,'2022-10-10 19:40:12','',''),(2633938,'1','158','780',335,'Distributed to KARU PLANT for sales id:351557',3451800.00,0.00,0.00,5230.00,0.00,'2022-10-10 19:40:26','',''),(2633939,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351558',2046000.00,0.00,0.00,3100.00,0.00,'2022-10-10 19:40:58','',''),(2633940,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16467000.00,24950.00,0.00,0.00,'2022-10-11 08:18:19','',''),(2633941,'1','158',NULL,335,'Reception corrector for bridging 132738',0.00,0.00,0.00,24950.00,0.00,'2022-10-11 08:19:29','',''),(2633942,'1','158','780',335,'Received from bridging 132738',0.00,0.00,24950.00,0.00,0.00,'2022-10-11 08:19:29','',''),(2633943,'1','158',NULL,335,'Returned purchase #90910 to AA RANO NIGERIA LIMITED',16473600.00,0.00,0.00,24960.00,0.00,'2022-10-11 08:21:39','',''),(2633944,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351559',455400.00,0.00,0.00,690.00,0.00,'2022-10-11 10:19:02','',''),(2633945,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351560',2488200.00,0.00,0.00,3770.00,0.00,'2022-10-11 10:19:18','',''),(2633946,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351561',2811600.00,0.00,0.00,4260.00,0.00,'2022-10-11 10:19:33','',''),(2633947,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351562',2567400.00,0.00,0.00,3890.00,0.00,'2022-10-11 10:19:50','',''),(2633948,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351563',3049200.00,0.00,0.00,4620.00,0.00,'2022-10-11 10:20:06','',''),(2633949,'1','158','780',335,'Distributed to KATAMFE for sales id:351564',3088800.00,0.00,0.00,4680.00,0.00,'2022-10-11 10:20:24','',''),(2633950,'1','158','780',335,'Distributed to KARU PLANT for sales id:351565',1716000.00,0.00,0.00,2600.00,0.00,'2022-10-11 10:22:30','',''),(2633951,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-11 18:05:49','',''),(2633952,'1','158',NULL,335,'Reception corrector for bridging 132739',0.00,0.00,0.00,24960.00,0.00,'2022-10-11 18:07:43','',''),(2633953,'1','158','780',335,'Received from bridging 132739',0.00,0.00,24960.00,0.00,0.00,'2022-10-11 18:07:43','',''),(2633954,'1','158','780',335,'Distributed to KARU PLANT for sales id:351566',2032800.00,0.00,0.00,3080.00,0.00,'2022-10-11 18:14:28','',''),(2633955,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351567',3425400.00,0.00,0.00,5190.00,0.00,'2022-10-11 18:14:46','',''),(2633956,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351568',3742200.00,0.00,0.00,5670.00,0.00,'2022-10-11 18:15:02','',''),(2633957,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351569',3214200.00,0.00,0.00,4870.00,0.00,'2022-10-11 18:15:19','',''),(2633958,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351570',4072200.00,0.00,0.00,6170.00,0.00,'2022-10-11 18:15:36','',''),(2633959,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16539600.00,25060.00,0.00,0.00,'2022-10-13 10:45:42','',''),(2633960,'1','158',NULL,335,'Reception corrector for bridging 132740',0.00,0.00,0.00,25060.00,0.00,'2022-10-13 10:46:58','',''),(2633961,'1','158','780',335,'Received from bridging 132740',0.00,0.00,25060.00,0.00,0.00,'2022-10-13 10:46:58','',''),(2633962,'1','158','780',335,'Distributed to ADO PLANT for sales id:351572',2851200.00,0.00,0.00,4320.00,0.00,'2022-10-13 10:53:47','',''),(2633963,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351573',2679600.00,0.00,0.00,4060.00,0.00,'2022-10-13 10:54:09','',''),(2633964,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351574',2673000.00,0.00,0.00,4050.00,0.00,'2022-10-13 11:01:05','',''),(2633965,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351575',3286800.00,0.00,0.00,4980.00,0.00,'2022-10-13 11:01:24','',''),(2633966,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351576',3432000.00,0.00,0.00,5200.00,0.00,'2022-10-13 11:01:40','',''),(2633967,'1','158','780',335,'Distributed to KATAMFE for sales id:351577',1617000.00,0.00,0.00,2450.00,0.00,'2022-10-13 11:01:58','',''),(2633968,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16473600.00,24960.00,0.00,0.00,'2022-10-14 08:52:31','',''),(2633969,'1','158',NULL,335,'Reception corrector for bridging 132741',0.00,0.00,0.00,24960.00,0.00,'2022-10-14 08:55:39','',''),(2633970,'1','158','780',335,'Received from bridging 132741',0.00,0.00,24960.00,0.00,0.00,'2022-10-14 08:55:39','',''),(2633971,'1','158','780',335,'Distributed to KATAMFE for sales id:351578',2065800.00,0.00,0.00,3130.00,0.00,'2022-10-14 09:01:36','',''),(2633972,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351579',3491400.00,0.00,0.00,5290.00,0.00,'2022-10-14 09:01:55','',''),(2633973,'1','158','780',335,'Distributed to KARU PLANT for sales id:351580',7062000.00,0.00,0.00,10700.00,0.00,'2022-10-14 09:02:11','',''),(2633974,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351581',3352800.00,0.00,0.00,5080.00,0.00,'2022-10-14 09:07:26','',''),(2633975,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351582',501600.00,0.00,0.00,760.00,0.00,'2022-10-14 09:07:41','',''),(2633976,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-15 08:16:23','',''),(2633977,'1','158',NULL,335,'Reception corrector for bridging 132742',0.00,0.00,0.00,25000.00,0.00,'2022-10-15 08:17:31','',''),(2633978,'1','158','780',335,'Received from bridging 132742',0.00,0.00,25000.00,0.00,0.00,'2022-10-15 08:17:31','',''),(2633979,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351583',3069000.00,0.00,0.00,4650.00,0.00,'2022-10-15 08:20:52','',''),(2633980,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351584',3458400.00,0.00,0.00,5240.00,0.00,'2022-10-15 08:21:07','',''),(2633981,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351585',3544200.00,0.00,0.00,5370.00,0.00,'2022-10-15 08:26:15','',''),(2633982,'1','158','780',335,'Distributed to KATAMFE for sales id:351586',3260400.00,0.00,0.00,4940.00,0.00,'2022-10-15 08:26:32','',''),(2633983,'1','158','780',335,'Distributed to ADO PLANT for sales id:351587',3009600.00,0.00,0.00,4560.00,0.00,'2022-10-15 08:26:54','',''),(2633984,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351588',85800.00,0.00,0.00,130.00,0.00,'2022-10-15 08:28:48','',''),(2633985,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-15 20:07:29','',''),(2633986,'1','158',NULL,335,'Reception corrector for bridging 132743',0.00,0.00,0.00,25000.00,0.00,'2022-10-15 20:08:38','',''),(2633987,'1','158','780',335,'Received from bridging 132743',0.00,0.00,25000.00,0.00,0.00,'2022-10-15 20:08:38','',''),(2633988,'1','158','780',335,'Distributed to ADO PLANT for sales id:351589',561000.00,0.00,0.00,850.00,0.00,'2022-10-15 20:25:12','',''),(2633989,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351590',3267000.00,0.00,0.00,4950.00,0.00,'2022-10-15 20:25:28','',''),(2633990,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351591',2607000.00,0.00,0.00,3950.00,0.00,'2022-10-15 20:25:45','',''),(2633991,'1','158','780',335,'Distributed to KARU PLANT for sales id:351592',4052400.00,0.00,0.00,6140.00,0.00,'2022-10-15 20:26:01','',''),(2633992,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351593',3484800.00,0.00,0.00,5280.00,0.00,'2022-10-15 20:34:19','',''),(2633993,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351594',2448600.00,0.00,0.00,3710.00,0.00,'2022-10-15 20:34:51','',''),(2633994,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351595',79200.00,0.00,0.00,120.00,0.00,'2022-10-15 20:45:41','',''),(2633995,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-16 07:41:30','',''),(2633996,'1','158',NULL,335,'Reception corrector for bridging 132744',0.00,0.00,0.00,25000.00,0.00,'2022-10-16 07:42:46','',''),(2633997,'1','158','780',335,'Received from bridging 132744',0.00,0.00,25000.00,0.00,0.00,'2022-10-16 07:42:46','',''),(2633998,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351596',864600.00,0.00,0.00,1310.00,0.00,'2022-10-16 07:53:54','',''),(2633999,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351597',3722400.00,0.00,0.00,5640.00,0.00,'2022-10-16 07:54:30','',''),(2634000,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351598',3418800.00,0.00,0.00,5180.00,0.00,'2022-10-16 07:54:54','',''),(2634001,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351599',2574000.00,0.00,0.00,3900.00,0.00,'2022-10-16 07:55:17','',''),(2634002,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351600',2943600.00,0.00,0.00,4460.00,0.00,'2022-10-16 07:55:34','',''),(2634003,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351601',2950200.00,0.00,0.00,4470.00,0.00,'2022-10-16 07:56:00','',''),(2634004,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351602',26400.00,0.00,0.00,40.00,0.00,'2022-10-16 07:58:30','',''),(2634005,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16539600.00,25060.00,0.00,0.00,'2022-10-16 19:04:13','',''),(2634006,'1','158',NULL,335,'Reception corrector for bridging 132745',0.00,0.00,0.00,25060.00,0.00,'2022-10-16 19:05:33','',''),(2634007,'1','158','780',335,'Received from bridging 132745',0.00,0.00,25060.00,0.00,0.00,'2022-10-16 19:05:33','',''),(2634008,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351603',719400.00,0.00,0.00,1090.00,0.00,'2022-10-16 19:07:33','',''),(2634009,'1','158','780',335,'Distributed to KARU PLANT for sales id:351604',3966600.00,0.00,0.00,6010.00,0.00,'2022-10-16 19:15:47','',''),(2634010,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351605',2884200.00,0.00,0.00,4370.00,0.00,'2022-10-16 19:16:08','',''),(2634011,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351606',3227400.00,0.00,0.00,4890.00,0.00,'2022-10-16 19:16:29','',''),(2634012,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351607',3451800.00,0.00,0.00,5230.00,0.00,'2022-10-16 19:16:48','',''),(2634013,'1','158','780',335,'Distributed to KATAMFE for sales id:351608',2224200.00,0.00,0.00,3370.00,0.00,'2022-10-16 19:17:05','',''),(2634014,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351609',66000.00,0.00,0.00,100.00,0.00,'2022-10-16 19:18:45','',''),(2634015,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16453800.00,24930.00,0.00,0.00,'2022-10-17 16:15:22','',''),(2634016,'1','158',NULL,335,'Reception corrector for bridging 132746',0.00,0.00,0.00,24930.00,0.00,'2022-10-17 16:16:40','',''),(2634017,'1','158','780',335,'Received from bridging 132746',0.00,0.00,24930.00,0.00,0.00,'2022-10-17 16:16:40','',''),(2634018,'1','158','780',335,'Distributed to KATAMFE for sales id:351610',1267200.00,0.00,0.00,1920.00,0.00,'2022-10-17 16:23:26','',''),(2634019,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351611',2514600.00,0.00,0.00,3810.00,0.00,'2022-10-17 16:23:44','',''),(2634020,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351612',3372600.00,0.00,0.00,5110.00,0.00,'2022-10-17 16:24:01','',''),(2634021,'1','158','780',335,'Distributed to KARU PLANT for sales id:351613',3564000.00,0.00,0.00,5400.00,0.00,'2022-10-17 16:24:34','',''),(2634022,'1','158','780',335,'Distributed to ADO PLANT for sales id:351614',3484800.00,0.00,0.00,5280.00,0.00,'2022-10-17 16:28:07','',''),(2634023,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351615',2250600.00,0.00,0.00,3410.00,0.00,'2022-10-17 16:28:26','',''),(2634024,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16486800.00,24980.00,0.00,0.00,'2022-10-18 17:27:05','',''),(2634025,'1','158',NULL,335,'Reception corrector for bridging 132747',0.00,0.00,0.00,24980.00,0.00,'2022-10-18 17:28:18','',''),(2634026,'1','158','780',335,'Received from bridging 132747',0.00,0.00,24980.00,0.00,0.00,'2022-10-18 17:28:18','',''),(2634027,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351616',706200.00,0.00,0.00,1070.00,0.00,'2022-10-18 17:34:55','',''),(2634028,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351617',3286800.00,0.00,0.00,4980.00,0.00,'2022-10-18 17:35:28','',''),(2634029,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351619',3471600.00,0.00,0.00,5260.00,0.00,'2022-10-18 17:36:29','',''),(2634030,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351620',3451800.00,0.00,0.00,5230.00,0.00,'2022-10-18 17:41:22','',''),(2634031,'1','158','780',335,'Distributed to KARU PLANT for sales id:351621',3874200.00,0.00,0.00,5870.00,0.00,'2022-10-18 17:41:41','',''),(2634032,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351622',1696200.00,0.00,0.00,2570.00,0.00,'2022-10-18 17:41:57','',''),(2634033,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-19 16:44:13','',''),(2634034,'1','158',NULL,335,'Reception corrector for bridging 132748',0.00,0.00,0.00,25000.00,0.00,'2022-10-19 16:45:47','',''),(2634035,'1','158','780',335,'Received from bridging 132748',0.00,0.00,25000.00,0.00,0.00,'2022-10-19 16:45:47','',''),(2634036,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351623',2224200.00,0.00,0.00,3370.00,0.00,'2022-10-19 16:50:11','',''),(2634037,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351624',4936800.00,0.00,0.00,7480.00,0.00,'2022-10-19 16:50:27','',''),(2634038,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351625',3504600.00,0.00,0.00,5310.00,0.00,'2022-10-19 16:50:41','',''),(2634039,'1','158','780',335,'Distributed to KARU PLANT for sales id:351626',3313200.00,0.00,0.00,5020.00,0.00,'2022-10-19 16:54:11','',''),(2634040,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351627',2336400.00,0.00,0.00,3540.00,0.00,'2022-10-19 16:54:27','',''),(2634041,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351628',184800.00,0.00,0.00,280.00,0.00,'2022-10-19 16:55:59','',''),(2634042,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-10-20 07:35:16','',''),(2634043,'1','158',NULL,335,'Reception corrector for bridging 132749',0.00,0.00,0.00,24880.00,0.00,'2022-10-20 07:36:28','',''),(2634044,'1','158','780',335,'Received from bridging 132749',0.00,0.00,24880.00,0.00,0.00,'2022-10-20 07:36:28','',''),(2634045,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351629',1795200.00,0.00,0.00,2720.00,0.00,'2022-10-20 07:43:43','',''),(2634046,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351630',2560800.00,0.00,0.00,3880.00,0.00,'2022-10-20 07:44:03','',''),(2634047,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351631',3656400.00,0.00,0.00,5540.00,0.00,'2022-10-20 07:44:22','',''),(2634048,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351632',3465000.00,0.00,0.00,5250.00,0.00,'2022-10-20 07:44:41','',''),(2634049,'1','158','780',335,'Distributed to KATAMFE for sales id:351633',3603600.00,0.00,0.00,5460.00,0.00,'2022-10-20 07:44:58','',''),(2634050,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351634',1339800.00,0.00,0.00,2030.00,0.00,'2022-10-20 07:47:34','',''),(2634051,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-21 08:47:59','',''),(2634052,'1','158',NULL,335,'Reception corrector for bridging 132750',0.00,0.00,0.00,25000.00,0.00,'2022-10-21 08:49:22','',''),(2634053,'1','158','780',335,'Received from bridging 132750',0.00,0.00,25000.00,0.00,0.00,'2022-10-21 08:49:22','',''),(2634054,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351635',2191200.00,0.00,0.00,3320.00,0.00,'2022-10-21 09:01:27','',''),(2634055,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351636',3088800.00,0.00,0.00,4680.00,0.00,'2022-10-21 09:01:42','',''),(2634056,'1','158','780',335,'Distributed to KARU PLANT for sales id:351637',3973200.00,0.00,0.00,6020.00,0.00,'2022-10-21 09:01:56','',''),(2634057,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351638',3880800.00,0.00,0.00,5880.00,0.00,'2022-10-21 09:02:12','',''),(2634058,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351639',3253800.00,0.00,0.00,4930.00,0.00,'2022-10-21 09:02:29','',''),(2634059,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351640',112200.00,0.00,0.00,170.00,0.00,'2022-10-21 09:04:42','',''),(2634060,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-22 12:10:28','',''),(2634061,'1','158',NULL,335,'Reception corrector for bridging 132751',0.00,0.00,0.00,25000.00,0.00,'2022-10-22 12:11:36','',''),(2634062,'1','158','780',335,'Received from bridging 132751',0.00,0.00,25000.00,0.00,0.00,'2022-10-22 12:11:36','',''),(2634063,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351641',330000.00,0.00,0.00,500.00,0.00,'2022-10-22 12:13:24','',''),(2634064,'1','158','780',335,'Distributed to KARU PLANT for sales id:351642',3458400.00,0.00,0.00,5240.00,0.00,'2022-10-22 12:20:35','',''),(2634065,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351643',3379200.00,0.00,0.00,5120.00,0.00,'2022-10-22 12:21:00','',''),(2634066,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351644',2673000.00,0.00,0.00,4050.00,0.00,'2022-10-22 12:21:18','',''),(2634067,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351645',2547600.00,0.00,0.00,3860.00,0.00,'2022-10-22 12:21:34','',''),(2634068,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351646',3465000.00,0.00,0.00,5250.00,0.00,'2022-10-22 12:21:52','',''),(2634069,'1','158','780',335,'Distributed to ADO PLANT for sales id:351647',594000.00,0.00,0.00,900.00,0.00,'2022-10-22 12:25:28','',''),(2634070,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351648',52800.00,0.00,0.00,80.00,0.00,'2022-10-22 12:27:13','',''),(2634071,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-10-23 11:05:52','',''),(2634072,'1','158',NULL,335,'Reception corrector for bridging 132752',0.00,0.00,0.00,24880.00,0.00,'2022-10-23 11:07:17','',''),(2634073,'1','158','780',335,'Received from bridging 132752',0.00,0.00,24880.00,0.00,0.00,'2022-10-23 11:07:17','',''),(2634074,'1','158','780',335,'Distributed to ADO PLANT for sales id:351649',2943600.00,0.00,0.00,4460.00,0.00,'2022-10-23 11:13:42','',''),(2634075,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351650',3583800.00,0.00,0.00,5430.00,0.00,'2022-10-23 11:13:59','',''),(2634076,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351651',3682800.00,0.00,0.00,5580.00,0.00,'2022-10-23 11:14:16','',''),(2634077,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351652',3412200.00,0.00,0.00,5170.00,0.00,'2022-10-23 11:14:32','',''),(2634078,'1','158','780',335,'Distributed to KATAMFE for sales id:351653',2791800.00,0.00,0.00,4230.00,0.00,'2022-10-23 11:14:48','',''),(2634079,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351654',6600.00,0.00,0.00,10.00,0.00,'2022-10-23 11:16:26','',''),(2634080,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16526400.00,25040.00,0.00,0.00,'2022-10-24 09:07:26','',''),(2634081,'1','158',NULL,335,'Reception corrector for bridging 132753',0.00,0.00,0.00,25040.00,0.00,'2022-10-24 09:08:42','',''),(2634082,'1','158','780',335,'Received from bridging 132753',0.00,0.00,25040.00,0.00,0.00,'2022-10-24 09:08:42','',''),(2634083,'1','158','780',335,'Distributed to KATAMFE for sales id:351655',838200.00,0.00,0.00,1270.00,0.00,'2022-10-24 09:13:15','',''),(2634084,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351656',3128400.00,0.00,0.00,4740.00,0.00,'2022-10-24 09:13:40','',''),(2634085,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351657',3557400.00,0.00,0.00,5390.00,0.00,'2022-10-24 09:21:48','',''),(2634086,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351658',3471600.00,0.00,0.00,5260.00,0.00,'2022-10-24 09:22:16','',''),(2634087,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351659',3240600.00,0.00,0.00,4910.00,0.00,'2022-10-24 09:22:42','',''),(2634088,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351660',2290200.00,0.00,0.00,3470.00,0.00,'2022-10-24 09:23:00','',''),(2634089,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-25 06:47:40','',''),(2634090,'1','158',NULL,335,'Reception corrector for bridging 132754',0.00,0.00,0.00,25000.00,0.00,'2022-10-25 06:49:00','',''),(2634091,'1','158','780',335,'Received from bridging 132754',0.00,0.00,25000.00,0.00,0.00,'2022-10-25 06:49:00','',''),(2634092,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351661',943800.00,0.00,0.00,1430.00,0.00,'2022-10-25 06:52:05','',''),(2634093,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351662',3214200.00,0.00,0.00,4870.00,0.00,'2022-10-25 06:52:20','',''),(2634094,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351663',3755400.00,0.00,0.00,5690.00,0.00,'2022-10-25 06:58:25','',''),(2634095,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351664',3887400.00,0.00,0.00,5890.00,0.00,'2022-10-25 06:58:55','',''),(2634096,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351665',3306600.00,0.00,0.00,5010.00,0.00,'2022-10-25 06:59:20','',''),(2634097,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351666',1326600.00,0.00,0.00,2010.00,0.00,'2022-10-25 06:59:36','',''),(2634098,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351667',66000.00,0.00,0.00,100.00,0.00,'2022-10-25 07:01:18','',''),(2634099,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16480200.00,24970.00,0.00,0.00,'2022-10-25 16:53:18','',''),(2634100,'1','158',NULL,335,'Reception corrector for bridging 132755',0.00,0.00,0.00,24970.00,0.00,'2022-10-25 16:54:48','',''),(2634101,'1','158','780',335,'Received from bridging 132755',0.00,0.00,24970.00,0.00,0.00,'2022-10-25 16:54:48','',''),(2634102,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351668',2415600.00,0.00,0.00,3660.00,0.00,'2022-10-25 16:57:01','',''),(2634103,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351669',3399000.00,0.00,0.00,5150.00,0.00,'2022-10-25 17:03:42','',''),(2634104,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351670',3280200.00,0.00,0.00,4970.00,0.00,'2022-10-25 17:04:01','',''),(2634105,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351671',4085400.00,0.00,0.00,6190.00,0.00,'2022-10-25 17:04:18','',''),(2634106,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351672',3280200.00,0.00,0.00,4970.00,0.00,'2022-10-25 17:04:38','',''),(2634107,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351673',19800.00,0.00,0.00,30.00,0.00,'2022-10-25 17:06:10','',''),(2634108,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-10-26 17:24:57','',''),(2634109,'1','158',NULL,335,'Reception corrector for bridging 132756',0.00,0.00,0.00,24880.00,0.00,'2022-10-26 17:26:15','',''),(2634110,'1','158','780',335,'Received from bridging 132756',0.00,0.00,24880.00,0.00,0.00,'2022-10-26 17:26:15','',''),(2634111,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351674',138600.00,0.00,0.00,210.00,0.00,'2022-10-26 17:29:06','',''),(2634112,'1','158','780',335,'Distributed to KATAMFE for sales id:351675',3577200.00,0.00,0.00,5420.00,0.00,'2022-10-26 17:29:22','',''),(2634113,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351676',3379200.00,0.00,0.00,5120.00,0.00,'2022-10-26 17:35:01','',''),(2634114,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351677',3729000.00,0.00,0.00,5650.00,0.00,'2022-10-26 17:35:19','',''),(2634115,'1','158','780',335,'Distributed to ADO PLANT for sales id:351678',3451800.00,0.00,0.00,5230.00,0.00,'2022-10-26 17:35:37','',''),(2634116,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351679',844800.00,0.00,0.00,1280.00,0.00,'2022-10-26 17:36:06','',''),(2634117,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351680',1300200.00,0.00,0.00,1970.00,0.00,'2022-10-26 17:39:24','',''),(2634118,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-30 05:49:54','',''),(2634119,'1','158',NULL,335,'Reception corrector for bridging 132757',0.00,0.00,0.00,25000.00,0.00,'2022-10-30 05:51:26','',''),(2634120,'1','158','780',335,'Received from bridging 132757',0.00,0.00,25000.00,0.00,0.00,'2022-10-30 05:51:26','',''),(2634121,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351681',844800.00,0.00,0.00,1280.00,0.00,'2022-10-30 05:59:13','',''),(2634122,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351682',3095400.00,0.00,0.00,4690.00,0.00,'2022-10-30 05:59:33','',''),(2634123,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351683',3102000.00,0.00,0.00,4700.00,0.00,'2022-10-30 05:59:50','',''),(2634124,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351684',3616800.00,0.00,0.00,5480.00,0.00,'2022-10-30 06:01:09','',''),(2634125,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351685',3583800.00,0.00,0.00,5430.00,0.00,'2022-10-30 06:01:26','',''),(2634126,'1','158','780',335,'Distributed to KARU PLANT for sales id:351686',2257200.00,0.00,0.00,3420.00,0.00,'2022-10-30 06:06:31','',''),(2634127,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16526400.00,25040.00,0.00,0.00,'2022-10-31 21:26:14','',''),(2634128,'1','158',NULL,335,'Reception corrector for bridging 132758',0.00,0.00,0.00,25040.00,0.00,'2022-10-31 21:27:45','',''),(2634129,'1','158','780',335,'Received from bridging 132758',0.00,0.00,25040.00,0.00,0.00,'2022-10-31 21:27:45','',''),(2634130,'1','158','780',335,'Distributed to KARU PLANT for sales id:351687',1320000.00,0.00,0.00,2000.00,0.00,'2022-10-31 21:30:45','',''),(2634131,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351688',3181200.00,0.00,0.00,4820.00,0.00,'2022-10-31 21:38:33','',''),(2634132,'1','158','780',335,'Distributed to KARU PLANT for sales id:351689',3498000.00,0.00,0.00,5300.00,0.00,'2022-10-31 21:38:51','',''),(2634133,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351690',3465000.00,0.00,0.00,5250.00,0.00,'2022-10-31 21:40:13','',''),(2634134,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351691',3366000.00,0.00,0.00,5100.00,0.00,'2022-10-31 21:40:32','',''),(2634135,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351692',1537800.00,0.00,0.00,2330.00,0.00,'2022-10-31 21:44:11','',''),(2634136,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351694',158400.00,0.00,0.00,240.00,0.00,'2022-10-31 21:47:55','',''),(2634137,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-10-31 21:49:43','',''),(2634138,'1','158',NULL,335,'Reception corrector for bridging 132759',0.00,0.00,0.00,24880.00,0.00,'2022-10-31 21:51:34','',''),(2634139,'1','158','780',335,'Received from bridging 132759',0.00,0.00,24880.00,0.00,0.00,'2022-10-31 21:51:34','',''),(2634140,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351695',2145000.00,0.00,0.00,3250.00,0.00,'2022-10-31 23:07:40','',''),(2634141,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351696',3570600.00,0.00,0.00,5410.00,0.00,'2022-10-31 23:08:45','',''),(2634142,'1','158','780',335,'Distributed to KARU PLANT for sales id:351697',3326400.00,0.00,0.00,5040.00,0.00,'2022-10-31 23:09:50','',''),(2634143,'1','158','780',335,'Distributed to KATAMFE for sales id:351698',3465000.00,0.00,0.00,5250.00,0.00,'2022-10-31 23:10:07','',''),(2634144,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351699',3748800.00,0.00,0.00,5680.00,0.00,'2022-10-31 23:10:27','',''),(2634145,'1','158','780',335,'Distributed to ADO PLANT for sales id:351700',132000.00,0.00,0.00,200.00,0.00,'2022-10-31 23:11:31','',''),(2634146,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351701',33000.00,0.00,0.00,50.00,0.00,'2022-10-31 23:13:36','',''),(2634147,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-10-31 23:16:37','',''),(2634148,'1','158',NULL,335,'Reception corrector for bridging 132760',0.00,0.00,0.00,25000.00,0.00,'2022-10-31 23:18:09','',''),(2634149,'1','158','780',335,'Received from bridging 132760',0.00,0.00,25000.00,0.00,0.00,'2022-10-31 23:18:09','',''),(2634150,'1','158','780',335,'Distributed to ADO PLANT for sales id:351702',3306600.00,0.00,0.00,5010.00,0.00,'2022-10-31 23:20:42','',''),(2634151,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351703',3550800.00,0.00,0.00,5380.00,0.00,'2022-10-31 23:28:12','',''),(2634152,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351704',3260400.00,0.00,0.00,4940.00,0.00,'2022-10-31 23:28:30','',''),(2634153,'1','158','780',335,'Distributed to KARU PLANT for sales id:351705',3267000.00,0.00,0.00,4950.00,0.00,'2022-10-31 23:28:50','',''),(2634154,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351706',2719200.00,0.00,0.00,4120.00,0.00,'2022-10-31 23:29:07','',''),(2634155,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351707',396000.00,0.00,0.00,600.00,0.00,'2022-10-31 23:31:28','',''),(2634156,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16447200.00,24920.00,0.00,0.00,'2022-11-07 16:15:20','',''),(2634157,'1','158',NULL,335,'Reception corrector for bridging 132761',0.00,0.00,0.00,24920.00,0.00,'2022-11-07 16:16:55','',''),(2634158,'1','158','780',335,'Received from bridging 132761',0.00,0.00,24920.00,0.00,0.00,'2022-11-07 16:16:55','',''),(2634159,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351708',2824800.00,0.00,0.00,4280.00,0.00,'2022-11-07 16:34:26','',''),(2634160,'1','158','780',335,'Distributed to KARU PLANT for sales id:351709',3432000.00,0.00,0.00,5200.00,0.00,'2022-11-07 16:35:22','',''),(2634161,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351710',2442000.00,0.00,0.00,3700.00,0.00,'2022-11-07 16:35:49','',''),(2634162,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351711',3392400.00,0.00,0.00,5140.00,0.00,'2022-11-07 16:36:15','',''),(2634163,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351712',3524400.00,0.00,0.00,5340.00,0.00,'2022-11-07 16:36:34','',''),(2634164,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351713',587400.00,0.00,0.00,890.00,0.00,'2022-11-07 16:40:33','',''),(2634165,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351714',244200.00,0.00,0.00,370.00,0.00,'2022-11-07 16:42:24','',''),(2634166,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16420800.00,24880.00,0.00,0.00,'2022-11-07 16:50:31','',''),(2634167,'1','158',NULL,335,'Reception corrector for bridging 132762',0.00,0.00,0.00,24880.00,0.00,'2022-11-07 16:52:05','',''),(2634168,'1','158','780',335,'Received from bridging 132762',0.00,0.00,24880.00,0.00,0.00,'2022-11-07 16:52:05','',''),(2634169,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351715',2659800.00,0.00,0.00,4030.00,0.00,'2022-11-07 17:09:46','',''),(2634170,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351716',3385800.00,0.00,0.00,5130.00,0.00,'2022-11-07 17:10:05','',''),(2634171,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351717',2382600.00,0.00,0.00,3610.00,0.00,'2022-11-07 17:10:23','',''),(2634172,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351718',3478200.00,0.00,0.00,5270.00,0.00,'2022-11-07 17:11:03','',''),(2634173,'1','158','780',335,'Distributed to KARU PLANT for sales id:351719',4243800.00,0.00,0.00,6430.00,0.00,'2022-11-07 17:11:41','',''),(2634174,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351720',270600.00,0.00,0.00,410.00,0.00,'2022-11-07 17:12:07','',''),(2634175,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16434000.00,24900.00,0.00,0.00,'2022-11-07 17:16:02','',''),(2634176,'1','158',NULL,335,'Reception corrector for bridging 132763',0.00,0.00,0.00,24900.00,0.00,'2022-11-07 17:17:14','',''),(2634177,'1','158','780',335,'Received from bridging 132763',0.00,0.00,24900.00,0.00,0.00,'2022-11-07 17:17:14','',''),(2634178,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351721',2323200.00,0.00,0.00,3520.00,0.00,'2022-11-07 17:20:44','',''),(2634179,'1','158','780',335,'Distributed to KATAMFE for sales id:351722',2541000.00,0.00,0.00,3850.00,0.00,'2022-11-07 17:20:59','',''),(2634180,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351723',2963400.00,0.00,0.00,4490.00,0.00,'2022-11-07 17:27:11','',''),(2634181,'1','158','780',335,'Distributed to ADO PLANT for sales id:351724',2659800.00,0.00,0.00,4030.00,0.00,'2022-11-07 17:27:30','',''),(2634182,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351725',2937000.00,0.00,0.00,4450.00,0.00,'2022-11-07 17:27:45','',''),(2634183,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351726',2620200.00,0.00,0.00,3970.00,0.00,'2022-11-07 17:28:03','',''),(2634184,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351727',389400.00,0.00,0.00,590.00,0.00,'2022-11-07 17:29:38','',''),(2634185,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16486800.00,24980.00,0.00,0.00,'2022-11-07 17:31:33','',''),(2634186,'1','158',NULL,335,'Reception corrector for bridging 132764',0.00,0.00,0.00,24980.00,0.00,'2022-11-07 17:32:39','',''),(2634187,'1','158','780',335,'Received from bridging 132764',0.00,0.00,24980.00,0.00,0.00,'2022-11-07 17:32:39','',''),(2634188,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351728',739200.00,0.00,0.00,1120.00,0.00,'2022-11-07 17:41:13','',''),(2634189,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351729',3590400.00,0.00,0.00,5440.00,0.00,'2022-11-07 17:41:31','',''),(2634190,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351730',8124600.00,0.00,0.00,12310.00,0.00,'2022-11-07 17:41:48','',''),(2634191,'1','158','780',335,'Distributed to KARU PLANT for sales id:351731',3135000.00,0.00,0.00,4750.00,0.00,'2022-11-07 17:42:39','',''),(2634192,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351732',897600.00,0.00,0.00,1360.00,0.00,'2022-11-07 17:45:29','',''),(2634193,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16453800.00,24930.00,0.00,0.00,'2022-11-07 17:47:04','',''),(2634194,'1','158',NULL,335,'Reception corrector for bridging 132765',0.00,0.00,0.00,24930.00,0.00,'2022-11-07 17:48:51','',''),(2634195,'1','158','780',335,'Received from bridging 132765',0.00,0.00,24930.00,0.00,0.00,'2022-11-07 17:48:51','',''),(2634196,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351733',2534400.00,0.00,0.00,3840.00,0.00,'2022-11-07 17:54:07','',''),(2634197,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351734',3577200.00,0.00,0.00,5420.00,0.00,'2022-11-07 17:54:22','',''),(2634198,'1','158','780',335,'Distributed to KARU PLANT for sales id:351735',3372600.00,0.00,0.00,5110.00,0.00,'2022-11-07 17:54:40','',''),(2634199,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351736',3425400.00,0.00,0.00,5190.00,0.00,'2022-11-07 17:59:23','',''),(2634200,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351737',3141600.00,0.00,0.00,4760.00,0.00,'2022-11-07 17:59:40','',''),(2634201,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351738',402600.00,0.00,0.00,610.00,0.00,'2022-11-07 18:01:21','',''),(2634202,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16440600.00,24910.00,0.00,0.00,'2022-11-08 11:39:18','',''),(2634203,'1','158',NULL,335,'Reception corrector for bridging 132766',0.00,0.00,0.00,24910.00,0.00,'2022-11-08 11:41:19','',''),(2634204,'1','158','780',335,'Received from bridging 132766',0.00,0.00,24910.00,0.00,0.00,'2022-11-08 11:41:19','',''),(2634205,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351739',448800.00,0.00,0.00,680.00,0.00,'2022-11-08 11:46:40','',''),(2634206,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351740',3009600.00,0.00,0.00,4560.00,0.00,'2022-11-08 11:47:01','',''),(2634207,'1','158','780',335,'Distributed to ADO PLANT for sales id:351741',3867600.00,0.00,0.00,5860.00,0.00,'2022-11-08 11:47:19','',''),(2634208,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351742',3537600.00,0.00,0.00,5360.00,0.00,'2022-11-08 11:47:36','',''),(2634209,'1','158','780',335,'Distributed to KARU PLANT for sales id:351743',3465000.00,0.00,0.00,5250.00,0.00,'2022-11-08 11:51:45','',''),(2634210,'1','158','780',335,'Distributed to KATAMFE for sales id:351744',2092200.00,0.00,0.00,3170.00,0.00,'2022-11-08 11:52:00','',''),(2634211,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351745',19800.00,0.00,0.00,30.00,0.00,'2022-11-08 11:53:46','',''),(2634212,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16414200.00,24870.00,0.00,0.00,'2022-11-09 13:47:06','',''),(2634213,'1','158',NULL,335,'Reception corrector for bridging 132767',0.00,0.00,0.00,24870.00,0.00,'2022-11-09 13:48:31','',''),(2634214,'1','158','780',335,'Received from bridging 132767',0.00,0.00,24870.00,0.00,0.00,'2022-11-09 13:48:31','',''),(2634215,'1','158','780',335,'Distributed to KATAMFE for sales id:351746',1247400.00,0.00,0.00,1890.00,0.00,'2022-11-09 13:53:52','',''),(2634216,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351747',3326400.00,0.00,0.00,5040.00,0.00,'2022-11-09 13:54:11','',''),(2634217,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351748',3128400.00,0.00,0.00,4740.00,0.00,'2022-11-09 13:54:29','',''),(2634218,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351749',3319800.00,0.00,0.00,5030.00,0.00,'2022-11-09 13:54:48','',''),(2634219,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351750',4237200.00,0.00,0.00,6420.00,0.00,'2022-11-09 14:01:00','',''),(2634220,'1','158','780',335,'Distributed to KARU PLANT for sales id:351751',976800.00,0.00,0.00,1480.00,0.00,'2022-11-09 14:01:16','',''),(2634221,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351752',178200.00,0.00,0.00,270.00,0.00,'2022-11-09 14:03:35','',''),(2634222,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-11-10 10:44:19','',''),(2634223,'1','158',NULL,335,'Reception corrector for bridging 132768',0.00,0.00,0.00,25000.00,0.00,'2022-11-10 10:45:57','',''),(2634224,'1','158','780',335,'Received from bridging 132768',0.00,0.00,25000.00,0.00,0.00,'2022-11-10 10:45:57','',''),(2634225,'1','158','780',335,'Distributed to KARU PLANT for sales id:351753',3069000.00,0.00,0.00,4650.00,0.00,'2022-11-10 10:54:35','',''),(2634226,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351754',3649800.00,0.00,0.00,5530.00,0.00,'2022-11-10 10:54:52','',''),(2634227,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351755',3240600.00,0.00,0.00,4910.00,0.00,'2022-11-10 10:55:08','',''),(2634228,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351756',3465000.00,0.00,0.00,5250.00,0.00,'2022-11-10 10:55:27','',''),(2634229,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351757',3069000.00,0.00,0.00,4650.00,0.00,'2022-11-10 10:55:46','',''),(2634230,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16902000.00,25040.00,0.00,0.00,'2022-11-11 11:33:42','',''),(2634231,'1','158',NULL,335,'Reception corrector for bridging 132769',0.00,0.00,0.00,25040.00,0.00,'2022-11-11 11:35:04','',''),(2634232,'1','158','780',335,'Received from bridging 132769',0.00,0.00,25040.00,0.00,0.00,'2022-11-11 11:35:04','',''),(2634233,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351759',256500.00,0.00,0.00,380.00,0.00,'2022-11-11 11:36:35','',''),(2634234,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351760',3435750.00,0.00,0.00,5090.00,0.00,'2022-11-11 11:41:06','',''),(2634235,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351761',3321000.00,0.00,0.00,4920.00,0.00,'2022-11-11 11:41:30','',''),(2634236,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351762',3597750.00,0.00,0.00,5330.00,0.00,'2022-11-11 11:41:47','',''),(2634237,'1','158','780',335,'Distributed to KARU PLANT for sales id:351763',3429000.00,0.00,0.00,5080.00,0.00,'2022-11-11 11:45:15','',''),(2634238,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351764',2801250.00,0.00,0.00,4150.00,0.00,'2022-11-11 11:45:34','',''),(2634239,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351765',67500.00,0.00,0.00,100.00,0.00,'2022-11-11 11:47:05','',''),(2634240,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16875000.00,25000.00,0.00,0.00,'2022-11-13 11:08:04','',''),(2634241,'1','158',NULL,335,'Reception corrector for bridging 132770',0.00,0.00,0.00,25000.00,0.00,'2022-11-13 11:09:18','',''),(2634242,'1','158','780',335,'Received from bridging 132770',0.00,0.00,25000.00,0.00,0.00,'2022-11-13 11:09:18','',''),(2634243,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351766',803250.00,0.00,0.00,1190.00,0.00,'2022-11-13 11:13:49','',''),(2634244,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351767',3233250.00,0.00,0.00,4790.00,0.00,'2022-11-13 11:14:04','',''),(2634245,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351768',3597750.00,0.00,0.00,5330.00,0.00,'2022-11-13 11:14:19','',''),(2634246,'1','158','780',335,'Distributed to ADO PLANT for sales id:351769',3503250.00,0.00,0.00,5190.00,0.00,'2022-11-13 11:17:49','',''),(2634247,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351770',4185000.00,0.00,0.00,6200.00,0.00,'2022-11-13 11:18:04','',''),(2634248,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351771',1498500.00,0.00,0.00,2220.00,0.00,'2022-11-13 11:21:49','',''),(2634249,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351772',54000.00,0.00,0.00,80.00,0.00,'2022-11-13 11:23:13','',''),(2634250,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16834500.00,24940.00,0.00,0.00,'2022-11-14 16:59:19','',''),(2634251,'1','158',NULL,335,'Reception corrector for bridging 132771',0.00,0.00,0.00,24940.00,0.00,'2022-11-14 17:00:31','',''),(2634252,'1','158','780',335,'Received from bridging 132771',0.00,0.00,24940.00,0.00,0.00,'2022-11-14 17:00:31','',''),(2634253,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351773',2119500.00,0.00,0.00,3140.00,0.00,'2022-11-14 17:05:59','',''),(2634254,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351774',3402000.00,0.00,0.00,5040.00,0.00,'2022-11-14 17:06:15','',''),(2634255,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351775',3476250.00,0.00,0.00,5150.00,0.00,'2022-11-14 17:06:30','',''),(2634256,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351776',3840750.00,0.00,0.00,5690.00,0.00,'2022-11-14 17:06:44','',''),(2634257,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351777',3591000.00,0.00,0.00,5320.00,0.00,'2022-11-14 17:09:56','',''),(2634258,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351778',141750.00,0.00,0.00,210.00,0.00,'2022-11-14 17:10:10','',''),(2634259,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351779',263250.00,0.00,0.00,390.00,0.00,'2022-11-14 17:11:37','',''),(2634260,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16875000.00,25000.00,0.00,0.00,'2022-11-16 11:00:26','',''),(2634261,'1','158',NULL,335,'Reception corrector for bridging 132772',0.00,0.00,0.00,25000.00,0.00,'2022-11-16 11:01:45','',''),(2634262,'1','158','780',335,'Received from bridging 132772',0.00,0.00,25000.00,0.00,0.00,'2022-11-16 11:01:45','',''),(2634263,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351780',3354750.00,0.00,0.00,4970.00,0.00,'2022-11-16 11:12:08','',''),(2634264,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351781',3591000.00,0.00,0.00,5320.00,0.00,'2022-11-16 11:12:23','',''),(2634265,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351782',3537000.00,0.00,0.00,5240.00,0.00,'2022-11-16 11:16:19','',''),(2634266,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351783',3422250.00,0.00,0.00,5070.00,0.00,'2022-11-16 11:16:35','',''),(2634267,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351784',2970000.00,0.00,0.00,4400.00,0.00,'2022-11-16 11:19:04','',''),(2634268,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16875000.00,25000.00,0.00,0.00,'2022-11-17 16:17:09','',''),(2634269,'1','158',NULL,335,'Reception corrector for bridging 132773',0.00,0.00,0.00,25000.00,0.00,'2022-11-17 16:18:58','',''),(2634270,'1','158','780',335,'Received from bridging 132773',0.00,0.00,25000.00,0.00,0.00,'2022-11-17 16:18:58','',''),(2634271,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351785',654750.00,0.00,0.00,970.00,0.00,'2022-11-17 16:23:16','',''),(2634272,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351786',3624750.00,0.00,0.00,5370.00,0.00,'2022-11-17 16:23:31','',''),(2634273,'1','158','780',335,'Distributed to ADO PLANT for sales id:351787',3516750.00,0.00,0.00,5210.00,0.00,'2022-11-17 16:23:48','',''),(2634274,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351788',3462750.00,0.00,0.00,5130.00,0.00,'2022-11-17 16:29:04','',''),(2634275,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351789',3503250.00,0.00,0.00,5190.00,0.00,'2022-11-17 16:29:18','',''),(2634276,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351790',1768500.00,0.00,0.00,2620.00,0.00,'2022-11-17 16:29:35','',''),(2634277,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351791',344250.00,0.00,0.00,510.00,0.00,'2022-11-20 14:25:07','',''),(2634278,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16861500.00,24980.00,0.00,0.00,'2022-11-20 14:30:13','',''),(2634279,'1','158',NULL,335,'Reception corrector for bridging 132774',0.00,0.00,0.00,24980.00,0.00,'2022-11-20 14:31:28','',''),(2634280,'1','158','780',335,'Received from bridging 132774',0.00,0.00,24980.00,0.00,0.00,'2022-11-20 14:31:28','',''),(2634281,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351792',1566000.00,0.00,0.00,2320.00,0.00,'2022-11-20 14:35:37','',''),(2634282,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351793',3712500.00,0.00,0.00,5500.00,0.00,'2022-11-20 14:36:34','',''),(2634283,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351794',3415500.00,0.00,0.00,5060.00,0.00,'2022-11-20 14:43:53','',''),(2634284,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351795',3530250.00,0.00,0.00,5230.00,0.00,'2022-11-20 14:44:09','',''),(2634285,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351796',3429000.00,0.00,0.00,5080.00,0.00,'2022-11-20 14:55:50','',''),(2634286,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351797',1167750.00,0.00,0.00,1730.00,0.00,'2022-11-20 14:58:18','',''),(2634287,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351798',40500.00,0.00,0.00,60.00,0.00,'2022-11-20 14:59:55','',''),(2634288,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16908750.00,25050.00,0.00,0.00,'2022-11-20 19:02:58','',''),(2634289,'1','158',NULL,335,'Reception corrector for bridging 132775',0.00,0.00,0.00,25050.00,0.00,'2022-11-20 19:04:14','',''),(2634290,'1','158','780',335,'Received from bridging 132775',0.00,0.00,25050.00,0.00,0.00,'2022-11-20 19:04:14','',''),(2634291,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351799',2254500.00,0.00,0.00,3340.00,0.00,'2022-11-20 19:12:03','',''),(2634292,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351800',3597750.00,0.00,0.00,5330.00,0.00,'2022-11-20 19:12:23','',''),(2634293,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351802',3462750.00,0.00,0.00,5130.00,0.00,'2022-11-20 19:12:37','',''),(2634294,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351801',3462750.00,0.00,0.00,5130.00,0.00,'2022-11-20 19:12:54','',''),(2634295,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351803',3476250.00,0.00,0.00,5150.00,0.00,'2022-11-20 19:13:09','',''),(2634296,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351804',607500.00,0.00,0.00,900.00,0.00,'2022-11-20 19:13:25','',''),(2634297,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351805',47250.00,0.00,0.00,70.00,0.00,'2022-11-20 19:14:56','',''),(2634298,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16841250.00,24950.00,0.00,0.00,'2022-11-22 17:12:11','',''),(2634299,'1','158',NULL,335,'Reception corrector for bridging 132776',0.00,0.00,0.00,24950.00,0.00,'2022-11-22 17:13:36','',''),(2634300,'1','158','780',335,'Received from bridging 132776',0.00,0.00,24950.00,0.00,0.00,'2022-11-22 17:13:36','',''),(2634301,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351806',2868750.00,0.00,0.00,4250.00,0.00,'2022-11-22 17:15:21','',''),(2634302,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351807',3287250.00,0.00,0.00,4870.00,0.00,'2022-11-22 17:20:11','',''),(2634303,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351808',3564000.00,0.00,0.00,5280.00,0.00,'2022-11-22 17:20:30','',''),(2634304,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351809',3483000.00,0.00,0.00,5160.00,0.00,'2022-11-22 17:20:46','',''),(2634305,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351810',3597750.00,0.00,0.00,5330.00,0.00,'2022-11-22 17:23:23','',''),(2634306,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351811',40500.00,0.00,0.00,60.00,0.00,'2022-11-22 17:24:53','',''),(2634307,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16848000.00,24960.00,0.00,0.00,'2022-11-25 08:35:00','',''),(2634308,'1','158',NULL,335,'Reception corrector for bridging 132777',0.00,0.00,0.00,24960.00,0.00,'2022-11-25 08:36:23','',''),(2634309,'1','158','780',335,'Received from bridging 132777',0.00,0.00,24960.00,0.00,0.00,'2022-11-25 08:36:23','',''),(2634310,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351812',3341250.00,0.00,0.00,4950.00,0.00,'2022-11-25 08:39:06','',''),(2634311,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351813',3570750.00,0.00,0.00,5290.00,0.00,'2022-11-25 08:39:22','',''),(2634312,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351814',3746250.00,0.00,0.00,5550.00,0.00,'2022-11-25 08:41:59','',''),(2634313,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351815',3429000.00,0.00,0.00,5080.00,0.00,'2022-11-25 08:45:58','',''),(2634314,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351816',2760750.00,0.00,0.00,4090.00,0.00,'2022-11-25 08:46:15','',''),(2634315,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16942500.00,25100.00,0.00,0.00,'2022-11-26 11:39:54','',''),(2634316,'1','158',NULL,335,'Reception corrector for bridging 132778',0.00,0.00,0.00,25100.00,0.00,'2022-11-26 11:41:12','',''),(2634317,'1','158','780',335,'Received from bridging 132778',0.00,0.00,25100.00,0.00,0.00,'2022-11-26 11:41:12','',''),(2634318,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351818',3550500.00,0.00,0.00,5260.00,0.00,'2022-11-26 11:44:24','',''),(2634319,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351817',810000.00,0.00,0.00,1200.00,0.00,'2022-11-26 11:44:40','',''),(2634320,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351819',3375000.00,0.00,0.00,5000.00,0.00,'2022-11-26 11:55:21','',''),(2634321,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351821',3537000.00,0.00,0.00,5240.00,0.00,'2022-11-26 11:55:35','',''),(2634322,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351820',3537000.00,0.00,0.00,5240.00,0.00,'2022-11-26 11:56:10','',''),(2634323,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351822',2045250.00,0.00,0.00,3030.00,0.00,'2022-11-26 11:56:26','',''),(2634324,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351823',87750.00,0.00,0.00,130.00,0.00,'2022-11-26 11:58:17','',''),(2634325,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16875000.00,25000.00,0.00,0.00,'2022-11-28 08:06:41','',''),(2634326,'1','158',NULL,335,'Reception corrector for bridging 132779',0.00,0.00,0.00,25000.00,0.00,'2022-11-28 08:08:01','',''),(2634327,'1','158','780',335,'Received from bridging 132779',0.00,0.00,25000.00,0.00,0.00,'2022-11-28 08:08:01','',''),(2634328,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351824',1188000.00,0.00,0.00,1760.00,0.00,'2022-11-28 08:10:55','',''),(2634329,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351825',3456000.00,0.00,0.00,5120.00,0.00,'2022-11-28 08:15:59','',''),(2634330,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351826',3604500.00,0.00,0.00,5340.00,0.00,'2022-11-28 08:16:14','',''),(2634331,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351827',3361500.00,0.00,0.00,4980.00,0.00,'2022-11-28 08:16:34','',''),(2634332,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351828',3273750.00,0.00,0.00,4850.00,0.00,'2022-11-28 08:21:14','',''),(2634333,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351829',1802250.00,0.00,0.00,2670.00,0.00,'2022-11-28 08:21:32','',''),(2634334,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351830',189000.00,0.00,0.00,280.00,0.00,'2022-11-28 08:23:01','',''),(2634335,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16875000.00,25000.00,0.00,0.00,'2022-11-28 12:38:11','',''),(2634336,'1','158',NULL,335,'Reception corrector for bridging 132780',0.00,0.00,0.00,25000.00,0.00,'2022-11-28 12:39:27','',''),(2634337,'1','158','780',335,'Received from bridging 132780',0.00,0.00,25000.00,0.00,0.00,'2022-11-28 12:39:27','',''),(2634338,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351831',1890000.00,0.00,0.00,2800.00,0.00,'2022-11-28 12:44:48','',''),(2634339,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351832',3537000.00,0.00,0.00,5240.00,0.00,'2022-11-28 12:50:30','',''),(2634340,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:351833',8363250.00,0.00,0.00,12390.00,0.00,'2022-11-28 12:50:50','',''),(2634341,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351834',3084750.00,0.00,0.00,4570.00,0.00,'2022-11-28 12:54:32','',''),(2634342,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16551000.00,24520.00,0.00,0.00,'2022-11-30 07:35:19','',''),(2634343,'1','158',NULL,335,'Reception corrector for bridging 132781',0.00,0.00,0.00,24520.00,0.00,'2022-11-30 07:36:46','',''),(2634344,'1','158','780',335,'Received from bridging 132781',0.00,0.00,24520.00,0.00,0.00,'2022-11-30 07:36:46','',''),(2634345,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351835',337500.00,0.00,0.00,500.00,0.00,'2022-11-30 07:47:36','',''),(2634346,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351836',3591000.00,0.00,0.00,5320.00,0.00,'2022-11-30 07:48:03','',''),(2634347,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351837',3489750.00,0.00,0.00,5170.00,0.00,'2022-11-30 07:48:27','',''),(2634348,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351838',3381750.00,0.00,0.00,5010.00,0.00,'2022-11-30 07:53:08','',''),(2634349,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351839',3483000.00,0.00,0.00,5160.00,0.00,'2022-11-30 07:53:22','',''),(2634350,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:351840',2268000.00,0.00,0.00,3360.00,0.00,'2022-11-30 07:53:39','',''),(2634351,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15840000.00,24000.00,0.00,0.00,'2022-12-01 14:20:00','',''),(2634352,'1','158',NULL,335,'Reception corrector for bridging 132782',0.00,0.00,0.00,24000.00,0.00,'2022-12-01 14:21:04','',''),(2634353,'1','158','780',335,'Received from bridging 132782',0.00,0.00,24000.00,0.00,0.00,'2022-12-01 14:21:04','',''),(2634354,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:351841',627000.00,0.00,0.00,950.00,0.00,'2022-12-01 14:23:27','',''),(2634355,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351842',3306600.00,0.00,0.00,5010.00,0.00,'2022-12-01 14:31:08','',''),(2634356,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351843',3372600.00,0.00,0.00,5110.00,0.00,'2022-12-01 14:31:25','',''),(2634357,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351844',3379200.00,0.00,0.00,5120.00,0.00,'2022-12-01 14:32:16','',''),(2634358,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351845',3313200.00,0.00,0.00,5020.00,0.00,'2022-12-01 14:32:33','',''),(2634359,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:351846',1716000.00,0.00,0.00,2600.00,0.00,'2022-12-01 14:37:29','',''),(2634360,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351847',125400.00,0.00,0.00,190.00,0.00,'2022-12-01 14:39:26','',''),(2634361,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,17146800.00,25980.00,0.00,0.00,'2022-12-03 09:22:45','',''),(2634362,'1','158',NULL,335,'Reception corrector for bridging 132783',0.00,0.00,0.00,25980.00,0.00,'2022-12-03 09:24:02','',''),(2634363,'1','158','780',335,'Received from bridging 132783',0.00,0.00,25980.00,0.00,0.00,'2022-12-03 09:24:02','',''),(2634364,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:351848',1788600.00,0.00,0.00,2710.00,0.00,'2022-12-03 09:37:16','',''),(2634365,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351849',3326400.00,0.00,0.00,5040.00,0.00,'2022-12-03 09:37:33','',''),(2634366,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351850',3412200.00,0.00,0.00,5170.00,0.00,'2022-12-03 09:37:49','',''),(2634367,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351851',3260400.00,0.00,0.00,4940.00,0.00,'2022-12-03 09:38:04','',''),(2634368,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351852',3141600.00,0.00,0.00,4760.00,0.00,'2022-12-03 09:38:18','',''),(2634369,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351853',2217600.00,0.00,0.00,3360.00,0.00,'2022-12-03 09:41:14','',''),(2634370,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-12-04 06:56:32','',''),(2634371,'1','158',NULL,335,'Reception corrector for bridging 132784',0.00,0.00,0.00,25000.00,0.00,'2022-12-04 06:57:46','',''),(2634372,'1','158','780',335,'Received from bridging 132784',0.00,0.00,25000.00,0.00,0.00,'2022-12-04 06:57:46','',''),(2634373,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351854',1062600.00,0.00,0.00,1610.00,0.00,'2022-12-04 06:59:42','',''),(2634374,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351855',3359400.00,0.00,0.00,5090.00,0.00,'2022-12-04 07:35:44','',''),(2634375,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351856',3432000.00,0.00,0.00,5200.00,0.00,'2022-12-04 07:36:00','',''),(2634376,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351857',3458400.00,0.00,0.00,5240.00,0.00,'2022-12-04 07:36:19','',''),(2634377,'1','158','780',335,'Distributed to MUNAH GAS for sales id:351858',3762000.00,0.00,0.00,5700.00,0.00,'2022-12-04 07:36:41','',''),(2634378,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351859',1234200.00,0.00,0.00,1870.00,0.00,'2022-12-04 07:36:56','',''),(2634379,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351860',191400.00,0.00,0.00,290.00,0.00,'2022-12-04 07:38:37','',''),(2634380,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16486800.00,24980.00,0.00,0.00,'2022-12-05 14:34:01','',''),(2634381,'1','158',NULL,335,'Reception corrector for bridging 132785',0.00,0.00,0.00,24980.00,0.00,'2022-12-05 14:42:02','',''),(2634382,'1','158','780',335,'Received from bridging 132785',0.00,0.00,24980.00,0.00,0.00,'2022-12-05 14:42:02','',''),(2634383,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351861',2171400.00,0.00,0.00,3290.00,0.00,'2022-12-05 14:54:01','',''),(2634384,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351862',3550800.00,0.00,0.00,5380.00,0.00,'2022-12-05 14:56:01','',''),(2634385,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351863',3385800.00,0.00,0.00,5130.00,0.00,'2022-12-05 14:56:55','',''),(2634386,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351864',3484800.00,0.00,0.00,5280.00,0.00,'2022-12-05 15:05:29','',''),(2634387,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351865',3372600.00,0.00,0.00,5110.00,0.00,'2022-12-05 15:06:13','',''),(2634388,'1','158','780',335,'Distributed to KARU PLANT for sales id:351866',521400.00,0.00,0.00,790.00,0.00,'2022-12-05 15:06:36','',''),(2634389,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16500000.00,25000.00,0.00,0.00,'2022-12-05 19:13:58','',''),(2634390,'1','158',NULL,335,'Reception corrector for bridging 132786',0.00,0.00,0.00,25000.00,0.00,'2022-12-05 19:15:15','',''),(2634391,'1','158','780',335,'Received from bridging 132786',0.00,0.00,25000.00,0.00,0.00,'2022-12-05 19:15:15','',''),(2634392,'1','158','780',335,'Distributed to KARU PLANT for sales id:351867',2884200.00,0.00,0.00,4370.00,0.00,'2022-12-05 19:19:46','',''),(2634393,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351868',3531000.00,0.00,0.00,5350.00,0.00,'2022-12-05 19:20:01','',''),(2634394,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351869',3293400.00,0.00,0.00,4990.00,0.00,'2022-12-05 19:20:18','',''),(2634395,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351871',3088800.00,0.00,0.00,4680.00,0.00,'2022-12-05 19:24:05','',''),(2634396,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351870',3597000.00,0.00,0.00,5450.00,0.00,'2022-12-05 19:24:21','',''),(2634397,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351872',105600.00,0.00,0.00,160.00,0.00,'2022-12-05 19:25:58','',''),(2634398,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16440600.00,24910.00,0.00,0.00,'2022-12-07 13:57:25','',''),(2634399,'1','158',NULL,335,'Reception corrector for bridging 132787',0.00,0.00,0.00,24910.00,0.00,'2022-12-07 14:00:18','',''),(2634400,'1','158','780',335,'Received from bridging 132787',0.00,0.00,24910.00,0.00,0.00,'2022-12-07 14:00:18','',''),(2634401,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351873',409200.00,0.00,0.00,620.00,0.00,'2022-12-07 14:03:24','',''),(2634402,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351874',3636600.00,0.00,0.00,5510.00,0.00,'2022-12-07 14:03:42','',''),(2634403,'1','158','780',335,'Distributed to KARU PLANT for sales id:351876',3808200.00,0.00,0.00,5770.00,0.00,'2022-12-07 14:10:17','',''),(2634404,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351875',3313200.00,0.00,0.00,5020.00,0.00,'2022-12-07 14:10:32','',''),(2634405,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351877',1306800.00,0.00,0.00,1980.00,0.00,'2022-12-07 14:10:46','',''),(2634406,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351878',2475000.00,0.00,0.00,3750.00,0.00,'2022-12-07 14:11:01','',''),(2634407,'1','158','780',335,'Distributed to KARU PLANT for sales id:351879',1306800.00,0.00,0.00,1980.00,0.00,'2022-12-07 14:13:11','',''),(2634408,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351880',184800.00,0.00,0.00,280.00,0.00,'2022-12-07 14:14:34','',''),(2634409,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16447200.00,24920.00,0.00,0.00,'2022-12-08 17:01:36','',''),(2634410,'1','158',NULL,335,'Reception corrector for bridging 132788',0.00,0.00,0.00,24920.00,0.00,'2022-12-08 17:02:56','',''),(2634411,'1','158','780',335,'Received from bridging 132788',0.00,0.00,24920.00,0.00,0.00,'2022-12-08 17:02:56','',''),(2634412,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351882',3623400.00,0.00,0.00,5490.00,0.00,'2022-12-08 17:22:33','',''),(2634413,'1','158','780',335,'Distributed to KARU PLANT for sales id:351881',2376000.00,0.00,0.00,3600.00,0.00,'2022-12-08 17:22:52','',''),(2634414,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351883',3108600.00,0.00,0.00,4710.00,0.00,'2022-12-08 17:23:15','',''),(2634415,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351884',3392400.00,0.00,0.00,5140.00,0.00,'2022-12-08 17:23:55','',''),(2634416,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351885',3352800.00,0.00,0.00,5080.00,0.00,'2022-12-08 17:27:37','',''),(2634417,'1','158','780',335,'Distributed to KARU PLANT for sales id:351886',594000.00,0.00,0.00,900.00,0.00,'2022-12-08 17:27:52','',''),(2634418,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16764000.00,25400.00,0.00,0.00,'2022-12-09 11:42:42','',''),(2634419,'1','158',NULL,335,'Reception corrector for bridging 132789',0.00,0.00,0.00,25400.00,0.00,'2022-12-09 11:43:47','',''),(2634420,'1','158','780',335,'Received from bridging 132789',0.00,0.00,25400.00,0.00,0.00,'2022-12-09 11:43:47','',''),(2634421,'1','158','780',335,'Distributed to KARU PLANT for sales id:351887',3121800.00,0.00,0.00,4730.00,0.00,'2022-12-09 11:48:01','',''),(2634422,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351888',3491400.00,0.00,0.00,5290.00,0.00,'2022-12-09 11:48:15','',''),(2634423,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351889',3293400.00,0.00,0.00,4990.00,0.00,'2022-12-09 11:48:30','',''),(2634424,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351891',2455200.00,0.00,0.00,3720.00,0.00,'2022-12-09 11:51:31','',''),(2634425,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351890',4072200.00,0.00,0.00,6170.00,0.00,'2022-12-09 11:51:44','',''),(2634426,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351892',330000.00,0.00,0.00,500.00,0.00,'2022-12-09 11:53:06','',''),(2634427,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16513200.00,25020.00,0.00,0.00,'2022-12-10 10:49:14','',''),(2634428,'1','158',NULL,335,'Reception corrector for bridging 132790',0.00,0.00,0.00,25020.00,0.00,'2022-12-10 10:50:28','',''),(2634429,'1','158','780',335,'Received from bridging 132790',0.00,0.00,25020.00,0.00,0.00,'2022-12-10 10:50:28','',''),(2634430,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351893',1161600.00,0.00,0.00,1760.00,0.00,'2022-12-10 10:54:26','',''),(2634431,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351894',3300000.00,0.00,0.00,5000.00,0.00,'2022-12-10 10:54:41','',''),(2634432,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351895',3550800.00,0.00,0.00,5380.00,0.00,'2022-12-10 10:54:58','',''),(2634433,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351896',3570600.00,0.00,0.00,5410.00,0.00,'2022-12-10 10:59:35','',''),(2634434,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351897',3445200.00,0.00,0.00,5220.00,0.00,'2022-12-10 10:59:55','',''),(2634435,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351898',1280400.00,0.00,0.00,1940.00,0.00,'2022-12-10 11:00:20','',''),(2634436,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351899',204600.00,0.00,0.00,310.00,0.00,'2022-12-10 11:02:20','',''),(2634437,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16460400.00,24940.00,0.00,0.00,'2022-12-11 14:26:12','',''),(2634438,'1','158',NULL,335,'Reception corrector for bridging 132791',0.00,0.00,0.00,24940.00,0.00,'2022-12-11 14:27:56','',''),(2634439,'1','158','780',335,'Received from bridging 132791',0.00,0.00,24940.00,0.00,0.00,'2022-12-11 14:27:56','',''),(2634440,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351900',2211000.00,0.00,0.00,3350.00,0.00,'2022-12-11 14:34:35','',''),(2634441,'1','158','780',335,'Distributed to KATAMFE for sales id:351901',3300000.00,0.00,0.00,5000.00,0.00,'2022-12-11 14:34:52','',''),(2634442,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351902',3300000.00,0.00,0.00,5000.00,0.00,'2022-12-11 14:35:15','',''),(2634443,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351903',3253800.00,0.00,0.00,4930.00,0.00,'2022-12-11 14:35:36','',''),(2634444,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351904',3940200.00,0.00,0.00,5970.00,0.00,'2022-12-11 14:41:27','',''),(2634445,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351905',396000.00,0.00,0.00,600.00,0.00,'2022-12-11 14:41:47','',''),(2634446,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351906',59400.00,0.00,0.00,90.00,0.00,'2022-12-11 14:44:50','',''),(2634447,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16369620.00,25030.00,0.00,0.00,'2022-12-12 18:50:16','',''),(2634448,'1','158',NULL,335,'Reception corrector for bridging 132792',0.00,0.00,0.00,25030.00,0.00,'2022-12-12 18:51:47','',''),(2634449,'1','158','780',335,'Received from bridging 132792',0.00,0.00,25030.00,0.00,0.00,'2022-12-12 18:51:47','',''),(2634450,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351907',2851440.00,0.00,0.00,4360.00,0.00,'2022-12-12 18:53:42','',''),(2634451,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351909',3479280.00,0.00,0.00,5320.00,0.00,'2022-12-12 18:59:17','',''),(2634452,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351908',3276540.00,0.00,0.00,5010.00,0.00,'2022-12-12 18:59:33','',''),(2634453,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351910',3695100.00,0.00,0.00,5650.00,0.00,'2022-12-12 18:59:50','',''),(2634454,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351911',2890680.00,0.00,0.00,4420.00,0.00,'2022-12-12 19:00:05','',''),(2634455,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351912',176580.00,0.00,0.00,270.00,0.00,'2022-12-15 08:49:49','',''),(2634456,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16323840.00,24960.00,0.00,0.00,'2022-12-15 08:50:46','',''),(2634457,'1','158',NULL,335,'Reception corrector for bridging 132793',0.00,0.00,0.00,24960.00,0.00,'2022-12-15 08:51:58','',''),(2634458,'1','158','780',335,'Received from bridging 132793',0.00,0.00,24960.00,0.00,0.00,'2022-12-15 08:51:58','',''),(2634459,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351913',503580.00,0.00,0.00,770.00,0.00,'2022-12-15 08:53:51','',''),(2634460,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351914',3453120.00,0.00,0.00,5280.00,0.00,'2022-12-15 08:55:58','',''),(2634461,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351915',3211140.00,0.00,0.00,4910.00,0.00,'2022-12-15 09:00:55','',''),(2634462,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351916',3387720.00,0.00,0.00,5180.00,0.00,'2022-12-15 09:01:09','',''),(2634463,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351917',3413880.00,0.00,0.00,5220.00,0.00,'2022-12-15 09:01:23','',''),(2634464,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351918',2354400.00,0.00,0.00,3600.00,0.00,'2022-12-15 09:03:32','',''),(2634465,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16441560.00,25140.00,0.00,0.00,'2022-12-16 15:42:17','',''),(2634466,'1','158',NULL,335,'Reception corrector for bridging 132794',0.00,0.00,0.00,25140.00,0.00,'2022-12-16 15:50:05','',''),(2634467,'1','158','780',335,'Received from bridging 132794',0.00,0.00,25140.00,0.00,0.00,'2022-12-16 15:50:05','',''),(2634468,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351919',1301460.00,0.00,0.00,1990.00,0.00,'2022-12-16 15:55:41','',''),(2634469,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351920',3688560.00,0.00,0.00,5640.00,0.00,'2022-12-16 15:55:56','',''),(2634470,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351921',3498900.00,0.00,0.00,5350.00,0.00,'2022-12-16 15:56:14','',''),(2634471,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351922',3440040.00,0.00,0.00,5260.00,0.00,'2022-12-16 15:56:29','',''),(2634472,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351923',3348480.00,0.00,0.00,5120.00,0.00,'2022-12-16 15:59:46','',''),(2634473,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351924',1164120.00,0.00,0.00,1780.00,0.00,'2022-12-16 16:00:01','',''),(2634474,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16408860.00,25090.00,0.00,0.00,'2022-12-17 11:51:19','',''),(2634475,'1','158',NULL,335,'Reception corrector for bridging 132795',0.00,0.00,0.00,25090.00,0.00,'2022-12-17 11:53:23','',''),(2634476,'1','158','780',335,'Received from bridging 132795',0.00,0.00,25090.00,0.00,0.00,'2022-12-17 11:53:23','',''),(2634477,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351925',2249760.00,0.00,0.00,3440.00,0.00,'2022-12-17 11:57:42','',''),(2634478,'1','158','780',335,'Distributed to KATAMFE for sales id:351926',3610080.00,0.00,0.00,5520.00,0.00,'2022-12-17 11:57:57','',''),(2634479,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351927',3355020.00,0.00,0.00,5130.00,0.00,'2022-12-17 11:58:17','',''),(2634480,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351928',3171900.00,0.00,0.00,4850.00,0.00,'2022-12-17 12:03:10','',''),(2634481,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351929',3551220.00,0.00,0.00,5430.00,0.00,'2022-12-17 12:03:29','',''),(2634482,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351930',353160.00,0.00,0.00,540.00,0.00,'2022-12-17 12:03:46','',''),(2634483,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351931',117720.00,0.00,0.00,180.00,0.00,'2022-12-17 12:05:36','',''),(2634484,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16369620.00,25030.00,0.00,0.00,'2022-12-18 11:58:02','',''),(2634485,'1','158',NULL,335,'Reception corrector for bridging 132796',0.00,0.00,0.00,25030.00,0.00,'2022-12-18 12:01:29','',''),(2634486,'1','158','780',335,'Received from bridging 132796',0.00,0.00,25030.00,0.00,0.00,'2022-12-18 12:01:29','',''),(2634487,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351932',3014940.00,0.00,0.00,4610.00,0.00,'2022-12-18 12:05:37','',''),(2634488,'1','158','780',335,'Distributed to KATAMFE for sales id:351933',3878220.00,0.00,0.00,5930.00,0.00,'2022-12-18 12:05:53','',''),(2634489,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351934',3413880.00,0.00,0.00,5220.00,0.00,'2022-12-18 12:06:17','',''),(2634490,'1','158','780',335,'Distributed to KARU PLANT for sales id:351935',3472740.00,0.00,0.00,5310.00,0.00,'2022-12-18 12:10:35','',''),(2634491,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351936',2328240.00,0.00,0.00,3560.00,0.00,'2022-12-18 12:10:51','',''),(2634492,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351937',261600.00,0.00,0.00,400.00,0.00,'2022-12-18 12:12:16','',''),(2634493,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16323840.00,24960.00,0.00,0.00,'2022-12-19 08:41:48','',''),(2634494,'1','158',NULL,335,'Reception corrector for bridging 132797',0.00,0.00,0.00,24960.00,0.00,'2022-12-19 08:43:03','',''),(2634495,'1','158','780',335,'Received from bridging 132797',0.00,0.00,24960.00,0.00,0.00,'2022-12-19 08:43:03','',''),(2634496,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351938',1131420.00,0.00,0.00,1730.00,0.00,'2022-12-19 08:49:18','',''),(2634497,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351939',3296160.00,0.00,0.00,5040.00,0.00,'2022-12-19 08:49:34','',''),(2634498,'1','158','780',335,'Distributed to KARU PLANT for sales id:351940',3505440.00,0.00,0.00,5360.00,0.00,'2022-12-19 08:49:49','',''),(2634499,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351941',3250380.00,0.00,0.00,4970.00,0.00,'2022-12-19 08:50:04','',''),(2634500,'1','158','780',335,'Distributed to KATAMFE for sales id:351942',4349100.00,0.00,0.00,6650.00,0.00,'2022-12-19 08:50:19','',''),(2634501,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351943',752100.00,0.00,0.00,1150.00,0.00,'2022-12-19 08:52:32','',''),(2634502,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351944',39240.00,0.00,0.00,60.00,0.00,'2022-12-19 08:53:58','',''),(2634503,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16245360.00,24840.00,0.00,0.00,'2022-12-21 08:34:08','',''),(2634504,'1','158',NULL,335,'Reception corrector for bridging 132798',0.00,0.00,0.00,24840.00,0.00,'2022-12-21 08:35:31','',''),(2634505,'1','158','780',335,'Received from bridging 132798',0.00,0.00,24840.00,0.00,0.00,'2022-12-21 08:35:31','',''),(2634506,'1','158','780',335,'Distributed to LIFE CAMP for sales id:351945',2687940.00,0.00,0.00,4110.00,0.00,'2022-12-21 08:40:35','',''),(2634507,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351946',3459660.00,0.00,0.00,5290.00,0.00,'2022-12-21 08:40:52','',''),(2634508,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351947',3283080.00,0.00,0.00,5020.00,0.00,'2022-12-21 08:41:07','',''),(2634509,'1','158','780',335,'Distributed to KATAMFE for sales id:351948',3511980.00,0.00,0.00,5370.00,0.00,'2022-12-21 08:41:21','',''),(2634510,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351949',2910300.00,0.00,0.00,4450.00,0.00,'2022-12-21 08:43:57','',''),(2634511,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351950',392400.00,0.00,0.00,600.00,0.00,'2022-12-21 08:45:28','',''),(2634512,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15866040.00,24260.00,0.00,0.00,'2022-12-21 08:47:03','',''),(2634513,'1','158',NULL,335,'Reception corrector for bridging 132799',0.00,0.00,0.00,24260.00,0.00,'2022-12-21 08:48:29','',''),(2634514,'1','158','780',335,'Received from bridging 132799',0.00,0.00,24260.00,0.00,0.00,'2022-12-21 08:48:29','',''),(2634515,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351951',327000.00,0.00,0.00,500.00,0.00,'2022-12-21 09:03:38','',''),(2634516,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351952',3289620.00,0.00,0.00,5030.00,0.00,'2022-12-21 09:03:54','',''),(2634517,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351953',3368100.00,0.00,0.00,5150.00,0.00,'2022-12-21 09:04:14','',''),(2634518,'1','158','780',335,'Distributed to KARU PLANT for sales id:351954',3616620.00,0.00,0.00,5530.00,0.00,'2022-12-21 09:04:32','',''),(2634519,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351955',3256920.00,0.00,0.00,4980.00,0.00,'2022-12-21 09:04:49','',''),(2634520,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351956',2007780.00,0.00,0.00,3070.00,0.00,'2022-12-21 09:05:06','',''),(2634521,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15002760.00,22940.00,0.00,0.00,'2022-12-22 08:32:44','',''),(2634522,'1','158',NULL,335,'Reception corrector for bridging 132800',0.00,0.00,0.00,22940.00,0.00,'2022-12-22 08:34:45','',''),(2634523,'1','158','780',335,'Received from bridging 132800',0.00,0.00,22940.00,0.00,0.00,'2022-12-22 08:34:45','',''),(2634524,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351957',1151040.00,0.00,0.00,1760.00,0.00,'2022-12-22 08:36:32','',''),(2634525,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351958',3498900.00,0.00,0.00,5350.00,0.00,'2022-12-22 08:42:23','',''),(2634526,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351959',3296160.00,0.00,0.00,5040.00,0.00,'2022-12-22 08:42:41','',''),(2634527,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351960',3361560.00,0.00,0.00,5140.00,0.00,'2022-12-22 08:42:59','',''),(2634528,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351961',2825280.00,0.00,0.00,4320.00,0.00,'2022-12-22 08:43:16','',''),(2634529,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351962',869820.00,0.00,0.00,1330.00,0.00,'2022-12-22 08:45:02','',''),(2634530,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16336920.00,24980.00,0.00,0.00,'2022-12-23 09:49:15','',''),(2634531,'1','158',NULL,335,'Reception corrector for bridging 132801',0.00,0.00,0.00,24980.00,0.00,'2022-12-23 09:51:11','',''),(2634532,'1','158','780',335,'Received from bridging 132801',0.00,0.00,24980.00,0.00,0.00,'2022-12-23 09:51:11','',''),(2634533,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351963',876360.00,0.00,0.00,1340.00,0.00,'2022-12-23 09:52:49','',''),(2634534,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351964',3198060.00,0.00,0.00,4890.00,0.00,'2022-12-23 10:01:28','',''),(2634535,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351965',3466200.00,0.00,0.00,5300.00,0.00,'2022-12-23 10:02:07','',''),(2634536,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351966',3270000.00,0.00,0.00,5000.00,0.00,'2022-12-23 10:02:23','',''),(2634537,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351967',2419800.00,0.00,0.00,3700.00,0.00,'2022-12-23 10:02:38','',''),(2634538,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:351968',2864520.00,0.00,0.00,4380.00,0.00,'2022-12-23 10:02:53','',''),(2634539,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351969',241980.00,0.00,0.00,370.00,0.00,'2022-12-23 10:04:57','',''),(2634540,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16572360.00,25340.00,0.00,0.00,'2022-12-24 13:42:24','',''),(2634541,'1','158',NULL,335,'Reception corrector for bridging 132802',0.00,0.00,0.00,25340.00,0.00,'2022-12-24 13:43:32','',''),(2634542,'1','158','780',335,'Received from bridging 132802',0.00,0.00,25340.00,0.00,0.00,'2022-12-24 13:43:32','',''),(2634543,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:351970',385860.00,0.00,0.00,590.00,0.00,'2022-12-24 13:45:25','',''),(2634544,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351971',3479280.00,0.00,0.00,5320.00,0.00,'2022-12-24 14:01:51','',''),(2634545,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351972',3446580.00,0.00,0.00,5270.00,0.00,'2022-12-24 14:02:10','',''),(2634546,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351973',3407340.00,0.00,0.00,5210.00,0.00,'2022-12-24 14:02:27','',''),(2634547,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351974',3381180.00,0.00,0.00,5170.00,0.00,'2022-12-24 14:06:30','',''),(2634548,'1','158','780',335,'Distributed to KARU PLANT for sales id:351975',2472120.00,0.00,0.00,3780.00,0.00,'2022-12-24 14:06:45','',''),(2634549,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16350000.00,25000.00,0.00,0.00,'2022-12-24 19:09:15','',''),(2634550,'1','158',NULL,335,'Reception corrector for bridging 132803',0.00,0.00,0.00,25000.00,0.00,'2022-12-24 19:10:30','',''),(2634551,'1','158','780',335,'Received from bridging 132803',0.00,0.00,25000.00,0.00,0.00,'2022-12-24 19:10:30','',''),(2634552,'1','158','780',335,'Distributed to KARU PLANT for sales id:351976',948300.00,0.00,0.00,1450.00,0.00,'2022-12-24 19:17:49','',''),(2634553,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351977',3270000.00,0.00,0.00,5000.00,0.00,'2022-12-24 19:18:05','',''),(2634554,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351978',3446580.00,0.00,0.00,5270.00,0.00,'2022-12-24 19:18:21','',''),(2634555,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:351979',2897220.00,0.00,0.00,4430.00,0.00,'2022-12-24 19:18:36','',''),(2634556,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351980',3341940.00,0.00,0.00,5110.00,0.00,'2022-12-24 19:18:53','',''),(2634557,'1','158','780',335,'Distributed to KARU PLANT for sales id:351981',2445960.00,0.00,0.00,3740.00,0.00,'2022-12-24 19:19:08','',''),(2634558,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16166880.00,24720.00,0.00,0.00,'2022-12-26 11:16:57','',''),(2634559,'1','158',NULL,335,'Reception corrector for bridging 132804',0.00,0.00,0.00,24720.00,0.00,'2022-12-26 11:18:10','',''),(2634560,'1','158','780',335,'Received from bridging 132804',0.00,0.00,24720.00,0.00,0.00,'2022-12-26 11:18:10','',''),(2634561,'1','158','780',335,'Distributed to KARU PLANT for sales id:351982',1700400.00,0.00,0.00,2600.00,0.00,'2022-12-26 11:21:04','',''),(2634562,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351983',3505440.00,0.00,0.00,5360.00,0.00,'2022-12-26 11:21:21','',''),(2634563,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:351984',3387720.00,0.00,0.00,5180.00,0.00,'2022-12-26 11:29:10','',''),(2634564,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:351985',3485820.00,0.00,0.00,5330.00,0.00,'2022-12-26 11:29:26','',''),(2634565,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351986',3322320.00,0.00,0.00,5080.00,0.00,'2022-12-26 11:29:43','',''),(2634566,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351987',765180.00,0.00,0.00,1170.00,0.00,'2022-12-26 11:29:59','',''),(2634567,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16520040.00,25260.00,0.00,0.00,'2022-12-26 18:02:13','',''),(2634568,'1','158',NULL,335,'Reception corrector for bridging 132805',0.00,0.00,0.00,25260.00,0.00,'2022-12-26 18:03:30','',''),(2634569,'1','158','780',335,'Received from bridging 132805',0.00,0.00,25260.00,0.00,0.00,'2022-12-26 18:03:30','',''),(2634570,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:351988',2982240.00,0.00,0.00,4560.00,0.00,'2022-12-26 18:05:35','',''),(2634571,'1','158','780',335,'Distributed to APO LPG SKID for sales id:351989',3224220.00,0.00,0.00,4930.00,0.00,'2022-12-26 18:11:54','',''),(2634572,'1','158','780',335,'Distributed to KARU PLANT for sales id:351990',3610080.00,0.00,0.00,5520.00,0.00,'2022-12-26 18:12:12','',''),(2634573,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:351991',3492360.00,0.00,0.00,5340.00,0.00,'2022-12-26 18:12:27','',''),(2634574,'1','158','780',335,'Distributed to KARU PLANT for sales id:351992',3211140.00,0.00,0.00,4910.00,0.00,'2022-12-26 18:12:41','',''),(2634575,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16271520.00,24880.00,0.00,0.00,'2022-12-28 18:58:18','',''),(2634576,'1','158',NULL,335,'Reception corrector for bridging 132806',0.00,0.00,0.00,24880.00,0.00,'2022-12-28 18:59:34','',''),(2634577,'1','158','780',335,'Received from bridging 132806',0.00,0.00,24880.00,0.00,0.00,'2022-12-28 18:59:34','',''),(2634578,'1','158','780',335,'Distributed to KARU PLANT for sales id:351993',621300.00,0.00,0.00,950.00,0.00,'2022-12-28 19:01:31','',''),(2634579,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:351994',3433500.00,0.00,0.00,5250.00,0.00,'2022-12-28 19:07:53','',''),(2634580,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:351995',3276540.00,0.00,0.00,5010.00,0.00,'2022-12-28 19:08:10','',''),(2634581,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:351996',3420420.00,0.00,0.00,5230.00,0.00,'2022-12-28 19:08:24','',''),(2634582,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:351997',3250380.00,0.00,0.00,4970.00,0.00,'2022-12-28 19:08:39','',''),(2634583,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:351998',2217060.00,0.00,0.00,3390.00,0.00,'2022-12-28 19:15:02','',''),(2634584,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:351999',52320.00,0.00,0.00,80.00,0.00,'2022-12-28 19:17:05','',''),(2634585,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16363080.00,25020.00,0.00,0.00,'2022-12-31 14:31:06','',''),(2634586,'1','158',NULL,335,'Reception corrector for bridging 132807',0.00,0.00,0.00,25020.00,0.00,'2022-12-31 14:33:53','',''),(2634587,'1','158','780',335,'Received from bridging 132807',0.00,0.00,25020.00,0.00,0.00,'2022-12-31 14:33:53','',''),(2634588,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352000',1092180.00,0.00,0.00,1670.00,0.00,'2022-12-31 14:41:01','',''),(2634589,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352001',3538140.00,0.00,0.00,5410.00,0.00,'2022-12-31 14:41:21','',''),(2634590,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352002',3498900.00,0.00,0.00,5350.00,0.00,'2022-12-31 14:41:42','',''),(2634591,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352003',3191520.00,0.00,0.00,4880.00,0.00,'2022-12-31 14:53:53','',''),(2634592,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352004',3420420.00,0.00,0.00,5230.00,0.00,'2022-12-31 14:55:59','',''),(2634593,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352005',1484580.00,0.00,0.00,2270.00,0.00,'2022-12-31 14:56:34','',''),(2634594,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352006',137340.00,0.00,0.00,210.00,0.00,'2022-12-31 15:04:37','',''),(2634595,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16376160.00,25040.00,0.00,0.00,'2023-01-03 20:47:07','',''),(2634596,'1','158',NULL,335,'Reception corrector for bridging 132808',0.00,0.00,0.00,25040.00,0.00,'2023-01-03 20:50:39','',''),(2634597,'1','158','780',335,'Received from bridging 132808',0.00,0.00,25040.00,0.00,0.00,'2023-01-03 20:50:39','',''),(2634598,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352007',1772340.00,0.00,0.00,2710.00,0.00,'2023-01-03 20:53:07','',''),(2634599,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352008',3597000.00,0.00,0.00,5500.00,0.00,'2023-01-03 21:05:19','',''),(2634600,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352009',3387720.00,0.00,0.00,5180.00,0.00,'2023-01-03 21:13:29','',''),(2634601,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352010',3557760.00,0.00,0.00,5440.00,0.00,'2023-01-03 21:14:00','',''),(2634602,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352011',3531600.00,0.00,0.00,5400.00,0.00,'2023-01-03 21:14:16','',''),(2634603,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352012',529740.00,0.00,0.00,810.00,0.00,'2023-01-03 21:20:34','',''),(2634604,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16271520.00,24880.00,0.00,0.00,'2023-01-05 23:14:53','',''),(2634605,'1','158',NULL,335,'Reception corrector for bridging 132809',0.00,0.00,0.00,24880.00,0.00,'2023-01-05 23:17:47','',''),(2634606,'1','158','780',335,'Received from bridging 132809',0.00,0.00,24880.00,0.00,0.00,'2023-01-05 23:17:47','',''),(2634607,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352013',2916840.00,0.00,0.00,4460.00,0.00,'2023-01-06 11:27:13','',''),(2634608,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352014',3145740.00,0.00,0.00,4810.00,0.00,'2023-01-06 11:27:58','',''),(2634609,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352015',3355020.00,0.00,0.00,5130.00,0.00,'2023-01-06 11:29:29','',''),(2634610,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352016',3636240.00,0.00,0.00,5560.00,0.00,'2023-01-06 11:29:58','',''),(2634611,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352017',3021480.00,0.00,0.00,4620.00,0.00,'2023-01-06 11:35:51','',''),(2634612,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352018',196200.00,0.00,0.00,300.00,0.00,'2023-01-06 11:39:41','',''),(2634613,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15918360.00,24340.00,0.00,0.00,'2023-01-07 11:48:54','',''),(2634614,'1','158',NULL,335,'Reception corrector for bridging 132810',0.00,0.00,0.00,24340.00,0.00,'2023-01-07 11:53:15','',''),(2634615,'1','158','780',335,'Received from bridging 132810',0.00,0.00,24340.00,0.00,0.00,'2023-01-07 11:53:15','',''),(2634616,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352019',392400.00,0.00,0.00,600.00,0.00,'2023-01-07 11:58:05','',''),(2634617,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352020',3577380.00,0.00,0.00,5470.00,0.00,'2023-01-07 11:58:23','',''),(2634618,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352021',3420420.00,0.00,0.00,5230.00,0.00,'2023-01-07 12:07:26','',''),(2634619,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352022',3636240.00,0.00,0.00,5560.00,0.00,'2023-01-07 12:07:45','',''),(2634620,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352023',3433500.00,0.00,0.00,5250.00,0.00,'2023-01-07 12:08:09','',''),(2634621,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352024',1458420.00,0.00,0.00,2230.00,0.00,'2023-01-07 12:08:41','',''),(2634622,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16363080.00,25020.00,0.00,0.00,'2023-01-07 12:29:28','',''),(2634623,'1','158',NULL,335,'Reception corrector for bridging 132811',0.00,0.00,0.00,25020.00,0.00,'2023-01-07 12:32:05','',''),(2634624,'1','158','780',335,'Received from bridging 132811',0.00,0.00,25020.00,0.00,0.00,'2023-01-07 12:32:05','',''),(2634625,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352025',2007780.00,0.00,0.00,3070.00,0.00,'2023-01-07 12:35:49','',''),(2634626,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352026',3348480.00,0.00,0.00,5120.00,0.00,'2023-01-07 12:42:24','',''),(2634627,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352027',3400800.00,0.00,0.00,5200.00,0.00,'2023-01-07 12:42:41','',''),(2634628,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352028',3433500.00,0.00,0.00,5250.00,0.00,'2023-01-07 12:47:57','',''),(2634629,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352029',3538140.00,0.00,0.00,5410.00,0.00,'2023-01-07 12:48:14','',''),(2634630,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352030',327000.00,0.00,0.00,500.00,0.00,'2023-01-07 12:48:29','',''),(2634631,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352031',307380.00,0.00,0.00,470.00,0.00,'2023-01-07 12:50:08','',''),(2634632,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16363080.00,25020.00,0.00,0.00,'2023-01-09 11:27:55','',''),(2634633,'1','158',NULL,335,'Reception corrector for bridging 132812',0.00,0.00,0.00,25020.00,0.00,'2023-01-09 11:29:17','',''),(2634634,'1','158','780',335,'Received from bridging 132812',0.00,0.00,25020.00,0.00,0.00,'2023-01-09 11:29:17','',''),(2634635,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352032',2910300.00,0.00,0.00,4450.00,0.00,'2023-01-09 11:31:33','',''),(2634636,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352033',3662400.00,0.00,0.00,5600.00,0.00,'2023-01-09 11:40:43','',''),(2634637,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352034',3655860.00,0.00,0.00,5590.00,0.00,'2023-01-09 11:40:58','',''),(2634638,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352035',3374640.00,0.00,0.00,5160.00,0.00,'2023-01-09 11:41:15','',''),(2634639,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352036',2759880.00,0.00,0.00,4220.00,0.00,'2023-01-09 11:44:11','',''),(2634640,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16376160.00,25040.00,0.00,0.00,'2023-01-09 11:59:43','',''),(2634641,'1','158',NULL,335,'Reception corrector for bridging 132813',0.00,0.00,0.00,25040.00,0.00,'2023-01-09 12:01:18','',''),(2634642,'1','158','780',335,'Received from bridging 132813',0.00,0.00,25040.00,0.00,0.00,'2023-01-09 12:01:18','',''),(2634643,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352037',1203360.00,0.00,0.00,1840.00,0.00,'2023-01-09 12:10:44','',''),(2634644,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352038',3440040.00,0.00,0.00,5260.00,0.00,'2023-01-09 12:11:06','',''),(2634645,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352039',3583920.00,0.00,0.00,5480.00,0.00,'2023-01-09 12:11:25','',''),(2634646,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352040',3466200.00,0.00,0.00,5300.00,0.00,'2023-01-09 12:12:00','',''),(2634647,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352041',3400800.00,0.00,0.00,5200.00,0.00,'2023-01-09 12:12:20','',''),(2634648,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352042',1281840.00,0.00,0.00,1960.00,0.00,'2023-01-09 12:15:25','',''),(2634649,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16323840.00,24960.00,0.00,0.00,'2023-01-12 15:30:23','',''),(2634650,'1','158',NULL,335,'Reception corrector for bridging 132814',0.00,0.00,0.00,24960.00,0.00,'2023-01-12 15:31:40','',''),(2634651,'1','158','780',335,'Received from bridging 132814',0.00,0.00,24960.00,0.00,0.00,'2023-01-12 15:31:40','',''),(2634652,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352043',2203980.00,0.00,0.00,3370.00,0.00,'2023-01-12 15:36:42','',''),(2634653,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352044',3322320.00,0.00,0.00,5080.00,0.00,'2023-01-12 15:37:08','',''),(2634654,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352045',3505440.00,0.00,0.00,5360.00,0.00,'2023-01-12 15:37:30','',''),(2634655,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352046',3368100.00,0.00,0.00,5150.00,0.00,'2023-01-12 15:42:28','',''),(2634656,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352047',3466200.00,0.00,0.00,5300.00,0.00,'2023-01-12 15:42:44','',''),(2634657,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352048',405480.00,0.00,0.00,620.00,0.00,'2023-01-12 15:43:00','',''),(2634658,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352050',52320.00,0.00,0.00,80.00,0.00,'2023-01-12 15:44:57','',''),(2634659,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16480800.00,25200.00,0.00,0.00,'2023-01-12 15:46:31','',''),(2634660,'1','158',NULL,335,'Reception corrector for bridging 132815',0.00,0.00,0.00,25200.00,0.00,'2023-01-12 15:47:49','',''),(2634661,'1','158','780',335,'Received from bridging 132815',0.00,0.00,25200.00,0.00,0.00,'2023-01-12 15:47:49','',''),(2634662,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352051',2929920.00,0.00,0.00,4480.00,0.00,'2023-01-12 15:51:22','',''),(2634663,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352052',8299260.00,0.00,0.00,12690.00,0.00,'2023-01-12 15:51:39','',''),(2634664,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352053',3597000.00,0.00,0.00,5500.00,0.00,'2023-01-12 15:57:46','',''),(2634665,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352054',1654620.00,0.00,0.00,2530.00,0.00,'2023-01-12 15:58:02','',''),(2634666,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16454640.00,25160.00,0.00,0.00,'2023-01-12 16:47:30','',''),(2634667,'1','158',NULL,335,'Reception corrector for bridging 132816',0.00,0.00,0.00,25160.00,0.00,'2023-01-12 16:49:09','',''),(2634668,'1','158','780',335,'Received from bridging 132816',0.00,0.00,25160.00,0.00,0.00,'2023-01-12 16:49:09','',''),(2634669,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352055',1667700.00,0.00,0.00,2550.00,0.00,'2023-01-12 16:51:40','',''),(2634670,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352056',3381180.00,0.00,0.00,5170.00,0.00,'2023-01-12 16:55:00','',''),(2634671,'1','158','780',335,'Distributed to HARIZ GAS for sales id:352057',5879460.00,0.00,0.00,8990.00,0.00,'2023-01-12 16:55:19','',''),(2634672,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352058',3387720.00,0.00,0.00,5180.00,0.00,'2023-01-12 17:00:55','',''),(2634673,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352059',2138580.00,0.00,0.00,3270.00,0.00,'2023-01-12 17:01:12','',''),(2634674,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16193040.00,24760.00,0.00,0.00,'2023-01-13 11:37:09','',''),(2634675,'1','158',NULL,335,'Reception corrector for bridging 132817',0.00,0.00,0.00,24760.00,0.00,'2023-01-13 11:38:42','',''),(2634676,'1','158','780',335,'Received from bridging 132817',0.00,0.00,24760.00,0.00,0.00,'2023-01-13 11:38:42','',''),(2634677,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352060',1334160.00,0.00,0.00,2040.00,0.00,'2023-01-13 11:41:53','',''),(2634678,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352061',3361560.00,0.00,0.00,5140.00,0.00,'2023-01-13 11:42:10','',''),(2634679,'1','158','780',335,'Distributed to MUNAH GAS for sales id:352062',3642780.00,0.00,0.00,5570.00,0.00,'2023-01-13 11:47:48','',''),(2634680,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352063',3394260.00,0.00,0.00,5190.00,0.00,'2023-01-13 11:48:04','',''),(2634681,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352064',1648080.00,0.00,0.00,2520.00,0.00,'2023-01-13 11:48:22','',''),(2634682,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352065',2812200.00,0.00,0.00,4300.00,0.00,'2023-01-13 11:50:54','',''),(2634683,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16036080.00,24520.00,0.00,0.00,'2023-01-14 17:26:55','',''),(2634684,'1','158',NULL,335,'Reception corrector for bridging 132818',0.00,0.00,0.00,24520.00,0.00,'2023-01-14 17:28:04','',''),(2634685,'1','158','780',335,'Received from bridging 132818',0.00,0.00,24520.00,0.00,0.00,'2023-01-14 17:28:04','',''),(2634686,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352066',595140.00,0.00,0.00,910.00,0.00,'2023-01-14 17:37:08','',''),(2634687,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352067',2733720.00,0.00,0.00,4180.00,0.00,'2023-01-14 17:37:26','',''),(2634688,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352068',3603540.00,0.00,0.00,5510.00,0.00,'2023-01-14 17:37:47','',''),(2634689,'1','158','780',335,'Distributed to ADO PLANT for sales id:352069',3937080.00,0.00,0.00,6020.00,0.00,'2023-01-14 17:38:10','',''),(2634690,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352070',3250380.00,0.00,0.00,4970.00,0.00,'2023-01-14 17:38:27','',''),(2634691,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352071',1916220.00,0.00,0.00,2930.00,0.00,'2023-01-14 17:38:46','',''),(2634692,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16284600.00,24900.00,0.00,0.00,'2023-01-15 14:09:15','',''),(2634693,'1','158',NULL,335,'Reception corrector for bridging 132819',0.00,0.00,0.00,24900.00,0.00,'2023-01-15 14:10:29','',''),(2634694,'1','158','780',335,'Received from bridging 132819',0.00,0.00,24900.00,0.00,0.00,'2023-01-15 14:10:29','',''),(2634695,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352072',1399560.00,0.00,0.00,2140.00,0.00,'2023-01-15 14:12:41','',''),(2634696,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352073',3256920.00,0.00,0.00,4980.00,0.00,'2023-01-15 14:17:31','',''),(2634697,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352074',3387720.00,0.00,0.00,5180.00,0.00,'2023-01-15 14:17:47','',''),(2634698,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352075',3374640.00,0.00,0.00,5160.00,0.00,'2023-01-15 14:18:06','',''),(2634699,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352076',3368100.00,0.00,0.00,5150.00,0.00,'2023-01-15 14:21:18','',''),(2634700,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352077',1497660.00,0.00,0.00,2290.00,0.00,'2023-01-15 14:21:34','',''),(2634701,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16336920.00,24980.00,0.00,0.00,'2023-01-16 11:57:45','',''),(2634702,'1','158',NULL,335,'Reception corrector for bridging 132820',0.00,0.00,0.00,24980.00,0.00,'2023-01-16 11:59:02','',''),(2634703,'1','158','780',335,'Received from bridging 132820',0.00,0.00,24980.00,0.00,0.00,'2023-01-16 11:59:02','',''),(2634704,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352078',1831200.00,0.00,0.00,2800.00,0.00,'2023-01-16 12:08:10','',''),(2634705,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352079',3328860.00,0.00,0.00,5090.00,0.00,'2023-01-16 12:08:48','',''),(2634706,'1','158','780',335,'Distributed to KARU PLANT for sales id:352080',3623160.00,0.00,0.00,5540.00,0.00,'2023-01-16 12:09:09','',''),(2634707,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352081',3348480.00,0.00,0.00,5120.00,0.00,'2023-01-16 12:09:27','',''),(2634708,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352082',3230760.00,0.00,0.00,4940.00,0.00,'2023-01-16 12:09:45','',''),(2634709,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352083',974460.00,0.00,0.00,1490.00,0.00,'2023-01-16 12:10:04','',''),(2634710,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16356540.00,25010.00,0.00,0.00,'2023-01-17 09:59:15','',''),(2634711,'1','158',NULL,335,'Reception corrector for bridging 132821',0.00,0.00,0.00,25010.00,0.00,'2023-01-17 10:00:48','',''),(2634712,'1','158','780',335,'Received from bridging 132821',0.00,0.00,25010.00,0.00,0.00,'2023-01-17 10:00:48','',''),(2634713,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352084',2635620.00,0.00,0.00,4030.00,0.00,'2023-01-17 10:02:42','',''),(2634714,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352085',3400800.00,0.00,0.00,5200.00,0.00,'2023-01-17 10:29:21','',''),(2634715,'1','158','780',335,'Distributed to MUNAH GAS for sales id:352086',3296160.00,0.00,0.00,5040.00,0.00,'2023-01-17 10:29:37','',''),(2634716,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352087',3466200.00,0.00,0.00,5300.00,0.00,'2023-01-17 10:29:56','',''),(2634717,'1','158','780',335,'Distributed to KARU PLANT for sales id:352088',3577380.00,0.00,0.00,5470.00,0.00,'2023-01-17 10:30:14','',''),(2634718,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16297680.00,24920.00,0.00,0.00,'2023-01-17 13:41:03','',''),(2634719,'1','158',NULL,335,'Reception corrector for bridging 132822',0.00,0.00,0.00,24920.00,0.00,'2023-01-17 13:42:11','',''),(2634720,'1','158','780',335,'Received from bridging 132822',0.00,0.00,24920.00,0.00,0.00,'2023-01-17 13:42:11','',''),(2634721,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352090',8443140.00,0.00,0.00,12910.00,0.00,'2023-01-17 13:43:55','',''),(2634722,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352091',3276540.00,0.00,0.00,5010.00,0.00,'2023-01-17 13:48:21','',''),(2634723,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352092',3067260.00,0.00,0.00,4690.00,0.00,'2023-01-17 13:48:37','',''),(2634724,'1','158','780',335,'Distributed to ADO PLANT for sales id:352093',1510740.00,0.00,0.00,2310.00,0.00,'2023-01-17 13:48:53','',''),(2634725,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15002760.00,22940.00,0.00,0.00,'2023-01-18 13:35:14','',''),(2634726,'1','158',NULL,335,'Reception corrector for bridging 132823',0.00,0.00,0.00,22940.00,0.00,'2023-01-18 13:36:47','',''),(2634727,'1','158','780',335,'Received from bridging 132823',0.00,0.00,22940.00,0.00,0.00,'2023-01-18 13:36:47','',''),(2634728,'1','158','780',335,'Distributed to ADO PLANT for sales id:352094',1929300.00,0.00,0.00,2950.00,0.00,'2023-01-18 13:41:06','',''),(2634729,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352095',3296160.00,0.00,0.00,5040.00,0.00,'2023-01-18 13:41:21','',''),(2634730,'1','158','780',335,'Distributed to KARU PLANT for sales id:352096',3845520.00,0.00,0.00,5880.00,0.00,'2023-01-18 13:41:36','',''),(2634731,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352097',3603540.00,0.00,0.00,5510.00,0.00,'2023-01-18 13:45:06','',''),(2634732,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352098',2282460.00,0.00,0.00,3490.00,0.00,'2023-01-18 13:45:21','',''),(2634733,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352099',26160.00,0.00,0.00,40.00,0.00,'2023-01-18 13:46:43','',''),(2634734,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16350000.00,25000.00,0.00,0.00,'2023-01-19 13:44:20','',''),(2634735,'1','158',NULL,335,'Reception corrector for bridging 132824',0.00,0.00,0.00,25000.00,0.00,'2023-01-19 13:45:36','',''),(2634736,'1','158','780',335,'Received from bridging 132824',0.00,0.00,25000.00,0.00,0.00,'2023-01-19 13:45:36','',''),(2634737,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352100',1478040.00,0.00,0.00,2260.00,0.00,'2023-01-19 13:49:30','',''),(2634738,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352101',3256920.00,0.00,0.00,4980.00,0.00,'2023-01-19 13:49:46','',''),(2634739,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352102',3505440.00,0.00,0.00,5360.00,0.00,'2023-01-19 13:50:00','',''),(2634740,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352103',3551220.00,0.00,0.00,5430.00,0.00,'2023-01-19 13:54:25','',''),(2634741,'1','158','780',335,'Distributed to KARU PLANT for sales id:352104',3812820.00,0.00,0.00,5830.00,0.00,'2023-01-19 13:54:40','',''),(2634742,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352105',601680.00,0.00,0.00,920.00,0.00,'2023-01-19 13:55:01','',''),(2634743,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352106',143880.00,0.00,0.00,220.00,0.00,'2023-01-19 13:56:27','',''),(2634744,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,16350000.00,25000.00,0.00,0.00,'2023-01-21 12:07:05','',''),(2634745,'1','158',NULL,335,'Reception corrector for bridging 132825',0.00,0.00,0.00,25000.00,0.00,'2023-01-21 12:08:18','',''),(2634746,'1','158','780',335,'Received from bridging 132825',0.00,0.00,25000.00,0.00,0.00,'2023-01-21 12:08:18','',''),(2634747,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352107',2890680.00,0.00,0.00,4420.00,0.00,'2023-01-21 12:09:58','',''),(2634748,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352108',3440040.00,0.00,0.00,5260.00,0.00,'2023-01-21 12:28:33','',''),(2634749,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352109',3289620.00,0.00,0.00,5030.00,0.00,'2023-01-21 12:28:49','',''),(2634750,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352110',3400800.00,0.00,0.00,5200.00,0.00,'2023-01-21 12:29:05','',''),(2634751,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352111',3263460.00,0.00,0.00,4990.00,0.00,'2023-01-21 12:31:23','',''),(2634752,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352112',65400.00,0.00,0.00,100.00,0.00,'2023-01-21 12:32:43','',''),(2634753,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15661800.00,24860.00,0.00,0.00,'2023-01-22 16:47:29','',''),(2634754,'1','158',NULL,335,'Reception corrector for bridging 132826',0.00,0.00,0.00,24860.00,0.00,'2023-01-22 16:49:15','',''),(2634755,'1','158','780',335,'Received from bridging 132826',0.00,0.00,24860.00,0.00,0.00,'2023-01-22 16:49:15','',''),(2634756,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352113',239400.00,0.00,0.00,380.00,0.00,'2023-01-22 16:56:28','',''),(2634757,'1','158','780',335,'Distributed to KATAMFE for sales id:352114',2753100.00,0.00,0.00,4370.00,0.00,'2023-01-22 16:56:50','',''),(2634758,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352115',3414600.00,0.00,0.00,5420.00,0.00,'2023-01-22 16:57:38','',''),(2634759,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352116',3345300.00,0.00,0.00,5310.00,0.00,'2023-01-22 16:58:00','',''),(2634760,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352117',3301200.00,0.00,0.00,5240.00,0.00,'2023-01-22 16:58:33','',''),(2634761,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352118',2608200.00,0.00,0.00,4140.00,0.00,'2023-01-22 17:01:17','',''),(2634762,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15705900.00,24930.00,0.00,0.00,'2023-01-24 12:00:23','',''),(2634763,'1','158',NULL,335,'Reception corrector for bridging 132827',0.00,0.00,0.00,24930.00,0.00,'2023-01-24 12:02:01','',''),(2634764,'1','158','780',335,'Received from bridging 132827',0.00,0.00,24930.00,0.00,0.00,'2023-01-24 12:02:01','',''),(2634765,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352119',604800.00,0.00,0.00,960.00,0.00,'2023-01-24 12:07:25','',''),(2634766,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352120',3294900.00,0.00,0.00,5230.00,0.00,'2023-01-24 12:07:42','',''),(2634767,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352121',3093300.00,0.00,0.00,4910.00,0.00,'2023-01-24 12:07:59','',''),(2634768,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352122',3427200.00,0.00,0.00,5440.00,0.00,'2023-01-24 12:08:17','',''),(2634769,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352123',3213000.00,0.00,0.00,5100.00,0.00,'2023-01-24 12:12:20','',''),(2634770,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352124',2072700.00,0.00,0.00,3290.00,0.00,'2023-01-24 12:12:34','',''),(2634771,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-01-25 15:04:25','',''),(2634772,'1','158',NULL,335,'Reception corrector for bridging 132828',0.00,0.00,0.00,25000.00,0.00,'2023-01-25 15:05:27','',''),(2634773,'1','158','780',335,'Received from bridging 132828',0.00,0.00,25000.00,0.00,0.00,'2023-01-25 15:05:27','',''),(2634774,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352125',1058400.00,0.00,0.00,1680.00,0.00,'2023-01-25 15:09:19','',''),(2634775,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352126',3370500.00,0.00,0.00,5350.00,0.00,'2023-01-25 15:09:34','',''),(2634776,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352127',3061800.00,0.00,0.00,4860.00,0.00,'2023-01-25 15:17:47','',''),(2634777,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352128',3351600.00,0.00,0.00,5320.00,0.00,'2023-01-25 15:18:01','',''),(2634778,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352129',3515400.00,0.00,0.00,5580.00,0.00,'2023-01-25 15:18:17','',''),(2634779,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352130',1392300.00,0.00,0.00,2210.00,0.00,'2023-01-25 15:20:32','',''),(2634780,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15712200.00,24940.00,0.00,0.00,'2023-01-26 12:03:01','',''),(2634781,'1','158',NULL,335,'Reception corrector for bridging 132829',0.00,0.00,0.00,24940.00,0.00,'2023-01-26 12:04:14','',''),(2634782,'1','158','780',335,'Received from bridging 132829',0.00,0.00,24940.00,0.00,0.00,'2023-01-26 12:04:14','',''),(2634783,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352131',1801800.00,0.00,0.00,2860.00,0.00,'2023-01-26 12:07:58','',''),(2634784,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352132',3294900.00,0.00,0.00,5230.00,0.00,'2023-01-26 12:08:16','',''),(2634785,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352133',3263400.00,0.00,0.00,5180.00,0.00,'2023-01-26 12:08:33','',''),(2634786,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352134',3175200.00,0.00,0.00,5040.00,0.00,'2023-01-26 12:13:54','',''),(2634787,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352135',3420900.00,0.00,0.00,5430.00,0.00,'2023-01-26 12:14:11','',''),(2634788,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352136',756000.00,0.00,0.00,1200.00,0.00,'2023-01-26 12:14:27','',''),(2634789,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15680700.00,24890.00,0.00,0.00,'2023-01-27 17:36:54','',''),(2634790,'1','158',NULL,335,'Reception corrector for bridging 132830',0.00,0.00,0.00,24890.00,0.00,'2023-01-27 17:38:19','',''),(2634791,'1','158','780',335,'Received from bridging 132830',0.00,0.00,24890.00,0.00,0.00,'2023-01-27 17:38:19','',''),(2634792,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352137',2538900.00,0.00,0.00,4030.00,0.00,'2023-01-27 17:45:27','',''),(2634793,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352138',3257100.00,0.00,0.00,5170.00,0.00,'2023-01-27 17:45:42','',''),(2634794,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352139',3288600.00,0.00,0.00,5220.00,0.00,'2023-01-27 17:45:56','',''),(2634795,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352140',3200400.00,0.00,0.00,5080.00,0.00,'2023-01-27 17:51:22','',''),(2634796,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352141',3244500.00,0.00,0.00,5150.00,0.00,'2023-01-27 17:51:38','',''),(2634797,'1','158','780',335,'Distributed to KARU PLANT for sales id:352142',151200.00,0.00,0.00,240.00,0.00,'2023-01-27 17:51:53','',''),(2634798,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15680700.00,24890.00,0.00,0.00,'2023-01-28 15:15:00','',''),(2634799,'1','158',NULL,335,'Reception corrector for bridging 132831',0.00,0.00,0.00,24890.00,0.00,'2023-01-28 15:17:30','',''),(2634800,'1','158','780',335,'Received from bridging 132831',0.00,0.00,24890.00,0.00,0.00,'2023-01-28 15:17:30','',''),(2634801,'1','158','780',335,'Distributed to KARU PLANT for sales id:352143',3112200.00,0.00,0.00,4940.00,0.00,'2023-01-28 15:22:47','',''),(2634802,'1','158','780',335,'Distributed to KARU PLANT for sales id:352144',3282300.00,0.00,0.00,5210.00,0.00,'2023-01-28 15:23:15','',''),(2634803,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352145',3225600.00,0.00,0.00,5120.00,0.00,'2023-01-28 15:34:47','',''),(2634804,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352146',3376800.00,0.00,0.00,5360.00,0.00,'2023-01-28 15:46:24','',''),(2634805,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352147',2564100.00,0.00,0.00,4070.00,0.00,'2023-01-28 15:47:10','',''),(2634806,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352148',119700.00,0.00,0.00,190.00,0.00,'2023-01-28 15:51:20','',''),(2634807,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15705900.00,24930.00,0.00,0.00,'2023-01-30 08:10:16','',''),(2634808,'1','158',NULL,335,'Reception corrector for bridging 132832',0.00,0.00,0.00,24930.00,0.00,'2023-01-30 08:11:35','',''),(2634809,'1','158','780',335,'Received from bridging 132832',0.00,0.00,24930.00,0.00,0.00,'2023-01-30 08:11:35','',''),(2634810,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352149',1152900.00,0.00,0.00,1830.00,0.00,'2023-01-30 08:13:40','',''),(2634811,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352150',3168900.00,0.00,0.00,5030.00,0.00,'2023-01-30 08:20:45','',''),(2634812,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352151',3301200.00,0.00,0.00,5240.00,0.00,'2023-01-30 08:21:00','',''),(2634813,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352152',3005100.00,0.00,0.00,4770.00,0.00,'2023-01-30 08:21:16','',''),(2634814,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352153',3194100.00,0.00,0.00,5070.00,0.00,'2023-01-30 08:21:32','',''),(2634815,'1','158','780',335,'Distributed to KARU PLANT for sales id:352154',1883700.00,0.00,0.00,2990.00,0.00,'2023-01-30 08:21:48','',''),(2634816,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15687000.00,24900.00,0.00,0.00,'2023-01-30 14:54:21','',''),(2634817,'1','158',NULL,335,'Reception corrector for bridging 132833',0.00,0.00,0.00,24900.00,0.00,'2023-01-30 14:55:39','',''),(2634818,'1','158','780',335,'Received from bridging 132833',0.00,0.00,24900.00,0.00,0.00,'2023-01-30 14:55:39','',''),(2634819,'1','158','780',335,'Distributed to KARU PLANT for sales id:352155',1556100.00,0.00,0.00,2470.00,0.00,'2023-01-30 14:58:41','',''),(2634820,'1','158','780',335,'Distributed to KARU PLANT for sales id:352156',3420900.00,0.00,0.00,5430.00,0.00,'2023-01-30 14:58:56','',''),(2634821,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352157',3250800.00,0.00,0.00,5160.00,0.00,'2023-01-30 15:04:48','',''),(2634822,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352158',3301200.00,0.00,0.00,5240.00,0.00,'2023-01-30 15:05:04','',''),(2634823,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352159',2979900.00,0.00,0.00,4730.00,0.00,'2023-01-30 15:05:19','',''),(2634824,'1','158','780',335,'Distributed to MUNAH GAS for sales id:352160',768600.00,0.00,0.00,1220.00,0.00,'2023-01-30 15:05:34','',''),(2634825,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352161',409500.00,0.00,0.00,650.00,0.00,'2023-01-30 15:06:58','',''),(2634826,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-02-01 12:22:41','',''),(2634827,'1','158',NULL,335,'Reception corrector for bridging 132834',0.00,0.00,0.00,25000.00,0.00,'2023-02-01 12:23:58','',''),(2634828,'1','158','780',335,'Received from bridging 132834',0.00,0.00,25000.00,0.00,0.00,'2023-02-01 12:23:58','',''),(2634829,'1','158','780',335,'Distributed to MUNAH GAS for sales id:352162',2872800.00,0.00,0.00,4560.00,0.00,'2023-02-01 12:27:34','',''),(2634830,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352163',3326400.00,0.00,0.00,5280.00,0.00,'2023-02-01 12:34:18','',''),(2634831,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352164',3313800.00,0.00,0.00,5260.00,0.00,'2023-02-01 12:35:40','',''),(2634832,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352165',3162600.00,0.00,0.00,5020.00,0.00,'2023-02-01 12:35:57','',''),(2634833,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352166',2986200.00,0.00,0.00,4740.00,0.00,'2023-02-01 12:36:13','',''),(2634834,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352167',88200.00,0.00,0.00,140.00,0.00,'2023-02-01 12:37:54','',''),(2634835,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15674400.00,24880.00,0.00,0.00,'2023-02-02 10:30:07','',''),(2634836,'1','158',NULL,335,'Reception corrector for bridging 132835',0.00,0.00,0.00,24880.00,0.00,'2023-02-02 10:31:16','',''),(2634837,'1','158','780',335,'Received from bridging 132835',0.00,0.00,24880.00,0.00,0.00,'2023-02-02 10:31:16','',''),(2634838,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352168',359100.00,0.00,0.00,570.00,0.00,'2023-02-02 10:35:52','',''),(2634839,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352169',3339000.00,0.00,0.00,5300.00,0.00,'2023-02-02 10:36:08','',''),(2634840,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352170',3364200.00,0.00,0.00,5340.00,0.00,'2023-02-02 10:36:24','',''),(2634841,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352171',3168900.00,0.00,0.00,5030.00,0.00,'2023-02-02 10:41:17','',''),(2634842,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352172',3294900.00,0.00,0.00,5230.00,0.00,'2023-02-02 10:41:32','',''),(2634843,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352173',2060100.00,0.00,0.00,3270.00,0.00,'2023-02-02 10:41:50','',''),(2634844,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352174',88200.00,0.00,0.00,140.00,0.00,'2023-02-02 10:43:42','',''),(2634845,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15712200.00,24940.00,0.00,0.00,'2023-02-03 17:09:37','',''),(2634846,'1','158',NULL,335,'Reception corrector for bridging 132836',0.00,0.00,0.00,24940.00,0.00,'2023-02-03 17:11:03','',''),(2634847,'1','158','780',335,'Received from bridging 132836',0.00,0.00,24940.00,0.00,0.00,'2023-02-03 17:11:03','',''),(2634848,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352175',1159200.00,0.00,0.00,1840.00,0.00,'2023-02-03 17:20:02','',''),(2634849,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352176',3383100.00,0.00,0.00,5370.00,0.00,'2023-02-03 17:20:17','',''),(2634850,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352177',3257100.00,0.00,0.00,5170.00,0.00,'2023-02-03 17:30:39','',''),(2634851,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352178',3030300.00,0.00,0.00,4810.00,0.00,'2023-02-03 17:31:20','',''),(2634852,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352179',3559500.00,0.00,0.00,5650.00,0.00,'2023-02-03 17:31:40','',''),(2634853,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352180',1323000.00,0.00,0.00,2100.00,0.00,'2023-02-03 17:38:02','',''),(2634854,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14464800.00,22960.00,0.00,0.00,'2023-02-05 09:06:08','',''),(2634855,'1','158',NULL,335,'Reception corrector for bridging 132837',0.00,0.00,0.00,22960.00,0.00,'2023-02-05 09:07:29','',''),(2634856,'1','158','780',335,'Received from bridging 132837',0.00,0.00,22960.00,0.00,0.00,'2023-02-05 09:07:29','',''),(2634857,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352181',2047500.00,0.00,0.00,3250.00,0.00,'2023-02-05 09:11:34','',''),(2634858,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352182',3137400.00,0.00,0.00,4980.00,0.00,'2023-02-05 09:11:49','',''),(2634859,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352183',3326400.00,0.00,0.00,5280.00,0.00,'2023-02-05 09:12:03','',''),(2634860,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352184',2551500.00,0.00,0.00,4050.00,0.00,'2023-02-05 09:15:35','',''),(2634861,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352185',3225600.00,0.00,0.00,5120.00,0.00,'2023-02-05 09:15:48','',''),(2634862,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352186',176400.00,0.00,0.00,280.00,0.00,'2023-02-05 09:17:14','',''),(2634863,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15813000.00,25100.00,0.00,0.00,'2023-02-06 13:45:24','',''),(2634864,'1','158',NULL,335,'Reception corrector for bridging 132838',0.00,0.00,0.00,25100.00,0.00,'2023-02-06 13:46:44','',''),(2634865,'1','158','780',335,'Received from bridging 132838',0.00,0.00,25100.00,0.00,0.00,'2023-02-06 13:46:44','',''),(2634866,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352187',163800.00,0.00,0.00,260.00,0.00,'2023-02-06 13:51:04','',''),(2634867,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352188',3036600.00,0.00,0.00,4820.00,0.00,'2023-02-06 13:51:24','',''),(2634868,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352189',3282300.00,0.00,0.00,5210.00,0.00,'2023-02-06 13:51:42','',''),(2634869,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352190',3414600.00,0.00,0.00,5420.00,0.00,'2023-02-06 13:55:20','',''),(2634870,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352191',3143700.00,0.00,0.00,4990.00,0.00,'2023-02-06 13:55:40','',''),(2634871,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352192',2709000.00,0.00,0.00,4300.00,0.00,'2023-02-06 13:58:22','',''),(2634872,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352193',63000.00,0.00,0.00,100.00,0.00,'2023-02-06 14:00:39','',''),(2634873,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15876000.00,25200.00,0.00,0.00,'2023-02-07 10:42:17','',''),(2634874,'1','158',NULL,335,'Reception corrector for bridging 132839',0.00,0.00,0.00,25200.00,0.00,'2023-02-07 10:43:20','',''),(2634875,'1','158','780',335,'Received from bridging 132839',0.00,0.00,25200.00,0.00,0.00,'2023-02-07 10:43:20','',''),(2634876,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352194',592200.00,0.00,0.00,940.00,0.00,'2023-02-07 10:51:35','',''),(2634877,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352195',3452400.00,0.00,0.00,5480.00,0.00,'2023-02-07 10:51:53','',''),(2634878,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352196',7856100.00,0.00,0.00,12470.00,0.00,'2023-02-07 10:52:08','',''),(2634879,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352197',3250800.00,0.00,0.00,5160.00,0.00,'2023-02-07 10:52:23','',''),(2634880,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352198',724500.00,0.00,0.00,1150.00,0.00,'2023-02-07 10:52:46','',''),(2634881,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15687000.00,24900.00,0.00,0.00,'2023-02-08 14:34:45','',''),(2634882,'1','158',NULL,335,'Reception corrector for bridging 132840',0.00,0.00,0.00,24900.00,0.00,'2023-02-08 14:36:00','',''),(2634883,'1','158','780',335,'Received from bridging 132840',0.00,0.00,24900.00,0.00,0.00,'2023-02-08 14:36:00','',''),(2634884,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352199',2551500.00,0.00,0.00,4050.00,0.00,'2023-02-08 14:37:40','',''),(2634885,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352200',3124800.00,0.00,0.00,4960.00,0.00,'2023-02-08 14:44:30','',''),(2634886,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352201',3420900.00,0.00,0.00,5430.00,0.00,'2023-02-08 14:44:45','',''),(2634887,'1','158','780',335,'Distributed to APO LPG SKID for sales id:352202',3250800.00,0.00,0.00,5160.00,0.00,'2023-02-08 14:44:59','',''),(2634888,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352203',3339000.00,0.00,0.00,5300.00,0.00,'2023-02-08 14:48:55','',''),(2634889,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15964200.00,25340.00,0.00,0.00,'2023-02-16 12:23:55','',''),(2634890,'1','158',NULL,335,'Reception corrector for bridging 132841',0.00,0.00,0.00,25340.00,0.00,'2023-02-16 12:28:11','',''),(2634891,'1','158','780',335,'Received from bridging 132841',0.00,0.00,25340.00,0.00,0.00,'2023-02-16 12:28:11','',''),(2634892,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352204',56700.00,0.00,0.00,90.00,0.00,'2023-02-16 12:37:46','',''),(2634893,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352205',3439800.00,0.00,0.00,5460.00,0.00,'2023-02-16 12:38:08','',''),(2634894,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352206',3332700.00,0.00,0.00,5290.00,0.00,'2023-02-16 12:38:26','',''),(2634895,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352207',3402000.00,0.00,0.00,5400.00,0.00,'2023-02-16 12:38:53','',''),(2634896,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352208',3446100.00,0.00,0.00,5470.00,0.00,'2023-02-16 12:42:59','',''),(2634897,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352209',2286900.00,0.00,0.00,3630.00,0.00,'2023-02-16 12:47:35','',''),(2634898,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15712200.00,24940.00,0.00,0.00,'2023-02-16 12:54:52','',''),(2634899,'1','158',NULL,335,'Reception corrector for bridging 132842',0.00,0.00,0.00,24940.00,0.00,'2023-02-16 12:57:50','',''),(2634900,'1','158','780',335,'Received from bridging 132842',0.00,0.00,24940.00,0.00,0.00,'2023-02-16 12:57:50','',''),(2634901,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352211',957600.00,0.00,0.00,1520.00,0.00,'2023-02-16 13:05:13','',''),(2634902,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352213',3817800.00,0.00,0.00,6060.00,0.00,'2023-02-16 13:23:48','',''),(2634903,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352212',3175200.00,0.00,0.00,5040.00,0.00,'2023-02-16 13:24:48','',''),(2634904,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352214',3546900.00,0.00,0.00,5630.00,0.00,'2023-02-16 13:27:01','',''),(2634905,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352215',3313800.00,0.00,0.00,5260.00,0.00,'2023-02-16 13:28:01','',''),(2634906,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352216',762300.00,0.00,0.00,1210.00,0.00,'2023-02-16 13:34:19','',''),(2634907,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352217',138600.00,0.00,0.00,220.00,0.00,'2023-02-16 13:36:48','',''),(2634908,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-02-16 14:05:16','',''),(2634909,'1','158',NULL,335,'Reception corrector for bridging 132843',0.00,0.00,0.00,25000.00,0.00,'2023-02-16 14:06:37','',''),(2634910,'1','158','780',335,'Received from bridging 132843',0.00,0.00,25000.00,0.00,0.00,'2023-02-16 14:06:37','',''),(2634911,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352218',2104200.00,0.00,0.00,3340.00,0.00,'2023-02-16 14:14:30','',''),(2634912,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352219',3893400.00,0.00,0.00,6180.00,0.00,'2023-02-16 14:14:46','',''),(2634913,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352220',3219300.00,0.00,0.00,5110.00,0.00,'2023-02-16 14:15:53','',''),(2634914,'1','158','780',335,'Distributed to MUNAH GAS for sales id:352221',3414600.00,0.00,0.00,5420.00,0.00,'2023-02-16 14:16:08','',''),(2634915,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352222',2759400.00,0.00,0.00,4380.00,0.00,'2023-02-16 14:21:22','',''),(2634916,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352223',359100.00,0.00,0.00,570.00,0.00,'2023-02-16 14:23:25','',''),(2634917,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15825600.00,25120.00,0.00,0.00,'2023-02-23 16:47:03','',''),(2634918,'1','158',NULL,335,'Reception corrector for bridging 132844',0.00,0.00,0.00,25120.00,0.00,'2023-02-23 16:48:34','',''),(2634919,'1','158','780',335,'Received from bridging 132844',0.00,0.00,25120.00,0.00,0.00,'2023-02-23 16:48:34','',''),(2634920,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352224',478800.00,0.00,0.00,760.00,0.00,'2023-02-23 16:56:18','',''),(2634921,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352225',3370500.00,0.00,0.00,5350.00,0.00,'2023-02-23 16:56:57','',''),(2634922,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352226',3131100.00,0.00,0.00,4970.00,0.00,'2023-02-23 16:57:27','',''),(2634923,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352227',3357900.00,0.00,0.00,5330.00,0.00,'2023-02-23 17:03:48','',''),(2634924,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352228',3276000.00,0.00,0.00,5200.00,0.00,'2023-02-23 17:11:46','',''),(2634925,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352229',2198700.00,0.00,0.00,3490.00,0.00,'2023-02-23 17:12:27','',''),(2634926,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352230',12600.00,0.00,0.00,20.00,0.00,'2023-02-23 17:17:38','',''),(2634927,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15787800.00,25060.00,0.00,0.00,'2023-02-23 17:20:45','',''),(2634928,'1','158',NULL,335,'Reception corrector for bridging 132845',0.00,0.00,0.00,25060.00,0.00,'2023-02-23 17:22:52','',''),(2634929,'1','158','780',335,'Received from bridging 132845',0.00,0.00,25060.00,0.00,0.00,'2023-02-23 17:22:52','',''),(2634930,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352231',1014300.00,0.00,0.00,1610.00,0.00,'2023-02-23 17:27:15','',''),(2634931,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352232',3156300.00,0.00,0.00,5010.00,0.00,'2023-02-23 17:27:39','',''),(2634932,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352233',3490200.00,0.00,0.00,5540.00,0.00,'2023-02-23 17:32:43','',''),(2634933,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352234',3351600.00,0.00,0.00,5320.00,0.00,'2023-02-23 17:40:55','',''),(2634934,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352235',3345300.00,0.00,0.00,5310.00,0.00,'2023-02-23 17:41:20','',''),(2634935,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352236',1398600.00,0.00,0.00,2220.00,0.00,'2023-02-23 17:42:00','',''),(2634936,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352237',31500.00,0.00,0.00,50.00,0.00,'2023-02-23 17:45:10','',''),(2634937,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-02-23 17:46:15','',''),(2634938,'1','158',NULL,335,'Reception corrector for bridging 132846',0.00,0.00,0.00,25000.00,0.00,'2023-02-23 17:47:25','',''),(2634939,'1','158','780',335,'Received from bridging 132846',0.00,0.00,25000.00,0.00,0.00,'2023-02-23 17:47:25','',''),(2634940,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352238',7049700.00,0.00,0.00,11190.00,0.00,'2023-02-23 17:50:11','',''),(2634941,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352239',1789200.00,0.00,0.00,2840.00,0.00,'2023-02-23 17:50:27','',''),(2634942,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352240',3194100.00,0.00,0.00,5070.00,0.00,'2023-02-23 17:55:13','',''),(2634943,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352241',3376800.00,0.00,0.00,5360.00,0.00,'2023-02-23 17:55:30','',''),(2634944,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352242',182700.00,0.00,0.00,290.00,0.00,'2023-02-23 17:55:47','',''),(2634945,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15762600.00,25020.00,0.00,0.00,'2023-02-23 17:58:27','',''),(2634946,'1','158',NULL,335,'Reception corrector for bridging 132847',0.00,0.00,0.00,25020.00,0.00,'2023-02-23 17:59:37','',''),(2634947,'1','158','780',335,'Received from bridging 132847',0.00,0.00,25020.00,0.00,0.00,'2023-02-23 17:59:37','',''),(2634948,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352243',157500.00,0.00,0.00,250.00,0.00,'2023-02-23 18:03:12','',''),(2634949,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352244',3124800.00,0.00,0.00,4960.00,0.00,'2023-02-23 18:12:47','',''),(2634950,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352245',3137400.00,0.00,0.00,4980.00,0.00,'2023-02-23 18:13:04','',''),(2634951,'1','158','780',335,'Distributed to HARIZ GAS for sales id:352246',5531400.00,0.00,0.00,8780.00,0.00,'2023-02-23 18:13:20','',''),(2634952,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352247',3181500.00,0.00,0.00,5050.00,0.00,'2023-02-23 18:17:08','',''),(2634953,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352248',812700.00,0.00,0.00,1290.00,0.00,'2023-02-23 18:17:27','',''),(2634954,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15737400.00,24980.00,0.00,0.00,'2023-02-23 18:19:55','',''),(2634955,'1','158',NULL,335,'Reception corrector for bridging 132848',0.00,0.00,0.00,24980.00,0.00,'2023-02-23 18:21:06','',''),(2634956,'1','158','780',335,'Received from bridging 132848',0.00,0.00,24980.00,0.00,0.00,'2023-02-23 18:21:06','',''),(2634957,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352249',2438100.00,0.00,0.00,3870.00,0.00,'2023-02-23 18:25:47','',''),(2634958,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352250',3213000.00,0.00,0.00,5100.00,0.00,'2023-02-23 18:26:10','',''),(2634959,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352251',3282300.00,0.00,0.00,5210.00,0.00,'2023-02-23 18:26:28','',''),(2634960,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352252',3162600.00,0.00,0.00,5020.00,0.00,'2023-02-23 18:31:39','',''),(2634961,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352253',3288600.00,0.00,0.00,5220.00,0.00,'2023-02-23 18:31:56','',''),(2634962,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352254',270900.00,0.00,0.00,430.00,0.00,'2023-02-23 18:32:13','',''),(2634963,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352255',56700.00,0.00,0.00,90.00,0.00,'2023-02-23 18:33:51','',''),(2634964,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15485400.00,24580.00,0.00,0.00,'2023-02-23 18:36:38','',''),(2634965,'1','158',NULL,335,'Reception corrector for bridging 132849',0.00,0.00,0.00,24580.00,0.00,'2023-02-23 18:37:42','',''),(2634966,'1','158','780',335,'Received from bridging 132849',0.00,0.00,24580.00,0.00,0.00,'2023-02-23 18:37:42','',''),(2634967,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352256',2847600.00,0.00,0.00,4520.00,0.00,'2023-02-23 18:40:17','',''),(2634968,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352257',3156300.00,0.00,0.00,5010.00,0.00,'2023-02-23 19:10:08','',''),(2634969,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352258',3414600.00,0.00,0.00,5420.00,0.00,'2023-02-23 19:10:23','',''),(2634970,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352259',3263400.00,0.00,0.00,5180.00,0.00,'2023-02-23 19:15:31','',''),(2634971,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352260',2734200.00,0.00,0.00,4340.00,0.00,'2023-02-23 19:15:51','',''),(2634972,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352261',69300.00,0.00,0.00,110.00,0.00,'2023-02-23 19:17:56','',''),(2634973,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,14439600.00,22920.00,0.00,0.00,'2023-02-24 11:21:39','',''),(2634974,'1','158',NULL,335,'Reception corrector for bridging 132850',0.00,0.00,0.00,22920.00,0.00,'2023-02-24 11:23:59','',''),(2634975,'1','158','780',335,'Received from bridging 132850',0.00,0.00,22920.00,0.00,0.00,'2023-02-24 11:23:59','',''),(2634976,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352262',478800.00,0.00,0.00,760.00,0.00,'2023-02-24 11:25:44','',''),(2634977,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352263',3263400.00,0.00,0.00,5180.00,0.00,'2023-02-24 11:33:07','',''),(2634978,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352264',3168900.00,0.00,0.00,5030.00,0.00,'2023-02-24 11:33:22','',''),(2634979,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352265',3080700.00,0.00,0.00,4890.00,0.00,'2023-02-24 11:33:36','',''),(2634980,'1','158','780',335,'Distributed to JABI LPG SKID for sales id:352266',1978200.00,0.00,0.00,3140.00,0.00,'2023-02-24 11:33:51','',''),(2634981,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352267',2469600.00,0.00,0.00,3920.00,0.00,'2023-02-24 11:34:06','',''),(2634982,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-02-24 19:14:17','',''),(2634983,'1','158',NULL,335,'Reception corrector for bridging 132851',0.00,0.00,0.00,25000.00,0.00,'2023-02-24 19:15:36','',''),(2634984,'1','158','780',335,'Received from bridging 132851',0.00,0.00,25000.00,0.00,0.00,'2023-02-24 19:15:36','',''),(2634985,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352268',743400.00,0.00,0.00,1180.00,0.00,'2023-02-24 19:21:00','',''),(2634986,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352269',3024000.00,0.00,0.00,4800.00,0.00,'2023-02-24 19:21:16','',''),(2634987,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352270',50400.00,0.00,0.00,80.00,0.00,'2023-02-24 19:21:31','',''),(2634988,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352271',3137400.00,0.00,0.00,4980.00,0.00,'2023-02-24 19:29:17','',''),(2634989,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352272',3150000.00,0.00,0.00,5000.00,0.00,'2023-02-24 19:29:32','',''),(2634990,'1','158','780',335,'Distributed to KM TRADE GAS for sales id:352273',5021100.00,0.00,0.00,7970.00,0.00,'2023-02-24 19:30:24','',''),(2634991,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:352274',459900.00,0.00,0.00,730.00,0.00,'2023-02-24 19:30:41','',''),(2634992,'1','158','780',335,'Distributed to OPERATIONAL LOSS for sales id:352275',163800.00,0.00,0.00,260.00,0.00,'2023-02-24 19:32:37','',''),(2634993,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-02-26 19:52:30','',''),(2634994,'1','158',NULL,335,'Reception corrector for bridging 132852',0.00,0.00,0.00,25000.00,0.00,'2023-02-26 19:53:32','',''),(2634995,'1','158','780',335,'Received from bridging 132852',0.00,0.00,25000.00,0.00,0.00,'2023-02-26 19:53:32','',''),(2634996,'1','158','780',335,'Distributed to ADVANCE LINK OIL AND GAS for sales id:352276',1638000.00,0.00,0.00,2600.00,0.00,'2023-02-26 19:55:28','',''),(2634997,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352277',3087000.00,0.00,0.00,4900.00,0.00,'2023-02-26 20:02:41','',''),(2634998,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352277',56700.00,0.00,0.00,90.00,0.00,'2023-02-26 20:03:44','',''),(2634999,'1','158','780',335,'Distributed to KADO LPG SKID for sales id:352278',3257100.00,0.00,0.00,5170.00,0.00,'2023-02-26 20:04:23','',''),(2635000,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352279',3269700.00,0.00,0.00,5190.00,0.00,'2023-02-26 20:04:37','',''),(2635001,'1','158','780',335,'Distributed to ONE MAN VILLAGE  for sales id:352280',3402000.00,0.00,0.00,5400.00,0.00,'2023-02-26 20:04:52','',''),(2635002,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352281',1039500.00,0.00,0.00,1650.00,0.00,'2023-02-26 20:05:07','',''),(2635003,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-03-01 15:36:59','',''),(2635004,'1','158',NULL,335,'Reception corrector for bridging 132853',0.00,0.00,0.00,25000.00,0.00,'2023-03-01 15:39:32','',''),(2635005,'1','158','780',335,'Received from bridging 132853',0.00,0.00,25000.00,0.00,0.00,'2023-03-01 15:39:32','',''),(2635006,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352282',2526300.00,0.00,0.00,4010.00,0.00,'2023-03-01 15:46:22','',''),(2635007,'1','158','780',335,'Distributed to KUJE LPG SKID for sales id:352283',3175200.00,0.00,0.00,5040.00,0.00,'2023-03-01 15:51:16','',''),(2635008,'1','158','780',335,'Distributed to GUDU LPG SKID for sales id:352284',3074400.00,0.00,0.00,4880.00,0.00,'2023-03-01 15:51:33','',''),(2635009,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352285',3376800.00,0.00,0.00,5360.00,0.00,'2023-03-01 15:51:48','',''),(2635010,'1','158','780',335,'Distributed to CITY GATE LPG SKID for sales id:352286',3206700.00,0.00,0.00,5090.00,0.00,'2023-03-01 15:58:59','',''),(2635011,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352287',390600.00,0.00,0.00,620.00,0.00,'2023-03-01 15:59:15','',''),(2635012,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-03-02 16:31:20','',''),(2635013,'1','158',NULL,335,'Reception corrector for bridging 132854',0.00,0.00,0.00,25000.00,0.00,'2023-03-02 16:32:21','',''),(2635014,'1','158','780',335,'Received from bridging 132854',0.00,0.00,25000.00,0.00,0.00,'2023-03-02 16:32:21','',''),(2635015,'1','158','780',335,'Distributed to LOKOJA PLANT for sales id:352288',3017700.00,0.00,0.00,4790.00,0.00,'2023-03-02 16:36:24','',''),(2635016,'1','158','780',335,'Distributed to GWAGWALADA LPG SKID for sales id:352289',3017700.00,0.00,0.00,4790.00,0.00,'2023-03-02 16:44:15','',''),(2635017,'1','158','780',335,'Distributed to KARU PLANT for sales id:352290',3282300.00,0.00,0.00,5210.00,0.00,'2023-03-02 16:44:31','',''),(2635018,'1','158','780',335,'Distributed to KARU PLANT for sales id:352291',3168900.00,0.00,0.00,5030.00,0.00,'2023-03-02 16:44:47','',''),(2635019,'1','158','780',335,'Distributed to ASOKORO LPG for sales id:352292',3213000.00,0.00,0.00,5100.00,0.00,'2023-03-02 16:45:02','',''),(2635020,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352293',151200.00,0.00,0.00,240.00,0.00,'2023-03-02 16:47:43','',''),(2635021,'1','158',NULL,335,'Purchased from AA RANO NIGERIA LIMITED',0.00,15750000.00,25000.00,0.00,0.00,'2023-03-03 12:30:52','',''),(2635022,'1','158',NULL,335,'Reception corrector for bridging 132855',0.00,0.00,0.00,25000.00,0.00,'2023-03-03 12:32:29','',''),(2635023,'1','158','780',335,'Received from bridging 132855',0.00,0.00,25000.00,0.00,0.00,'2023-03-03 12:32:29','',''),(2635024,'1','158','780',335,'Distributed to SULEJA 2 LPG SKID for sales id:352294',3017700.00,0.00,0.00,4790.00,0.00,'2023-03-03 12:37:24','',''),(2635025,'1','158','780',335,'Distributed to SULEJA 1 LPG SKID for sales id:352295',3005100.00,0.00,0.00,4770.00,0.00,'2023-03-03 12:37:45','',''),(2635026,'1','158','780',335,'Distributed to KEFFI LPG SKID for sales id:352296',3326400.00,0.00,0.00,5280.00,0.00,'2023-03-03 12:37:59','',''),(2635027,'1','158','780',335,'Distributed to NYANYA LPG SKID for sales id:352297',3131100.00,0.00,0.00,4970.00,0.00,'2023-03-03 12:42:02','',''),(2635028,'1','158','780',335,'Distributed to ONE MAN VILLAGE 