-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_157
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_157`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_157` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_157`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2914,20035,'',0,'20','1','157','SALES','','2020-10-29 16:10:44',5,0.00,0.00,'','178','2020-10-29 16:10:44','178',0,1),(2915,400226,'',0,'24','1','157','PURCHASES','','2020-10-29 16:10:55',5,0.00,0.00,'','178','2020-10-29 16:10:55','178',0,1),(2916,400227,'',0,'24','1','157','SALARIES','','2020-10-29 16:11:03',5,0.00,0.00,'','178','2020-10-29 16:11:03','178',0,1),(2917,40035,'',0,'6.1','1','157','CASH','','2020-10-29 16:11:39',5,0.00,0.00,'','178','2020-10-29 16:11:39','178',0,1),(2955,400355,'',0,'2','1','157','E-BILLS COLLECTION ACCT','','2020-11-13 10:42:58',5,0.00,0.00,'','454','2020-11-13 10:42:58','454',0,1),(2998,400372,'',0,'2','1','157','FIDELITY POS','','2020-12-09 08:48:38',5,0.00,0.00,'','454','2020-12-09 08:48:38','454',0,1),(3005,400379,'',0,'2','1','157','ZENITH BANK  1017823202','','2020-12-09 09:11:53',5,0.00,0.00,'','454','2020-12-09 09:11:53','454',0,1),(3368,4036,'',0,'5','1','157','INVENTORY VALUE ADJUSTMENT','','2021-05-27 14:28:11',5,0.00,0.00,'','454','2021-05-27 14:28:11','454',0,1),(3913,40021,'',0,'14','1','157','CASH IMPRESS ','','2021-11-29 13:31:16',5,0.00,0.00,'','454','2021-11-29 13:31:16','454',0,0),(4104,400751,'',0,'2','1','157','SUPPLUS ACC KEYSTONE BANK	','','2022-01-24 14:50:21',5,0.00,0.00,'','454','2022-01-24 14:50:21','454',0,0),(4105,400752,'',0,'2','1','157','Moniepoint POS Micro fiannce b','','2023-03-08 16:42:36',5,0.00,0.00,'','454','2023-03-08 16:42:36','454',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82446 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (79608,'1','157','0000-00-00','2021-05-27 14:26:45',10,'454','','0000-00-00 00:00:00','454','2021-05-27 14:29:36'),(79774,'1','157','0000-00-00','2021-06-21 10:39:39',10,'454','','0000-00-00 00:00:00','454','2021-06-29 15:37:58'),(79852,'1','157','0000-00-00','2021-06-30 13:29:31',10,'454','','0000-00-00 00:00:00','454','2021-06-30 13:32:35'),(79853,'1','157','0000-00-00','2021-06-30 13:31:31',10,'454','','0000-00-00 00:00:00','454','2021-06-30 13:32:41'),(80028,'1','157','0000-00-00','2021-08-16 14:45:53',10,'454','','0000-00-00 00:00:00','454','2021-08-16 14:46:54'),(80046,'1','157','0000-00-00','2021-08-17 16:10:45',10,'454','','0000-00-00 00:00:00','454','2021-08-17 16:11:24'),(80175,'1','157','0000-00-00','2021-09-17 09:05:09',10,'454','','0000-00-00 00:00:00','454','2021-09-17 09:10:13'),(80230,'1','157','0000-00-00','2021-09-22 10:21:25',10,'454','','0000-00-00 00:00:00','454','2021-09-22 10:25:04'),(80278,'1','157','0000-00-00','2021-09-29 12:41:56',10,'454','','0000-00-00 00:00:00','454','2021-09-30 15:50:42'),(80830,'1','157','0000-00-00','2021-11-01 19:20:04',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:24:21'),(80831,'1','157','0000-00-00','2021-11-01 19:25:12',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:24:27'),(80832,'1','157','0000-00-00','2021-11-01 19:28:41',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:24:40'),(80833,'1','157','0000-00-00','2021-11-01 19:31:32',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:24:47'),(80834,'1','157','0000-00-00','2021-11-01 19:32:42',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:24:54'),(80836,'1','157','0000-00-00','2021-11-01 19:43:18',10,'556','','0000-00-00 00:00:00','454','2021-11-03 10:25:03'),(81856,'1','157','0000-00-00','2021-12-02 19:32:21',10,'556','','0000-00-00 00:00:00','454','2022-01-19 10:46:29'),(82316,'1','157','0000-00-00','2022-01-19 10:57:08',10,'454','','0000-00-00 00:00:00','454','2022-01-19 10:57:37'),(82362,'1','157','0000-00-00','2022-01-21 11:49:21',10,'454','','0000-00-00 00:00:00','454','2022-01-21 16:50:26'),(82430,'1','157','0000-00-00','2022-02-01 14:58:09',10,'454','','0000-00-00 00:00:00','454','2022-02-01 14:59:40'),(82431,'1','157','0000-00-00','2022-02-04 15:36:41',10,'454','','0000-00-00 00:00:00','454','2022-02-06 16:14:38'),(82432,'1','157','0000-00-00','2022-02-10 15:13:57',10,'454','','0000-00-00 00:00:00','454','2022-02-15 13:46:44'),(82434,'1','157','0000-00-00','2022-02-15 13:51:53',10,'454','','0000-00-00 00:00:00','454','2022-02-15 13:52:54'),(82435,'1','157','0000-00-00','2022-02-15 15:39:20',10,'454','','0000-00-00 00:00:00','454','2022-02-15 15:39:55'),(82436,'1','157','0000-00-00','2022-03-04 14:55:59',10,'454','','0000-00-00 00:00:00','454','2022-03-04 14:56:59'),(82437,'1','157','0000-00-00','2022-03-04 14:59:18',10,'454','','0000-00-00 00:00:00','454','2022-03-04 14:59:55'),(82438,'1','157','0000-00-00','2022-03-04 15:01:06',10,'454','','0000-00-00 00:00:00','454','2022-03-04 15:01:50'),(82439,'1','157','0000-00-00','2022-03-08 15:15:50',10,'454','','0000-00-00 00:00:00','454','2022-03-08 15:19:59'),(82440,'1','157','0000-00-00','2022-03-08 15:18:44',10,'454','','0000-00-00 00:00:00','454','2022-03-08 15:20:07'),(82441,'1','157','0000-00-00','2022-03-08 15:21:35',10,'454','','0000-00-00 00:00:00','454','2022-03-08 15:22:09'),(82442,'1','157','0000-00-00','2022-03-15 11:42:52',10,'454','','0000-00-00 00:00:00','454','2022-03-15 11:51:02'),(82443,'1','157','0000-00-00','2022-03-19 12:42:22',10,'454','','0000-00-00 00:00:00','454','2022-03-19 12:44:13'),(82444,'1','157','0000-00-00','2022-03-19 12:43:32',10,'454','','0000-00-00 00:00:00','454','2022-03-19 12:44:25'),(82445,'1','157','0000-00-00','2022-08-18 14:00:53',10,'454','','0000-00-00 00:00:00','454','2022-08-18 14:01:33');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174465 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (167539,'1','157','79608','201','supplier',22250.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 27/5/2021 FROM 265 TO 270 =5*4450=22250	',0.00,'2021-05-27'),(167540,'1','157','79608','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 27/5/2021 FROM 265 TO 270 =5*4450=22250	',22250.00,'2021-05-27'),(167936,'1','157','79774','201','supplier',0.00,'PRICE DICREMEN T FOR PMS PRODUCT ON 19/6/2021 FROM 165 TO 163=2*40,600=97200	',97200.00,'2021-06-19'),(167937,'1','157','79774','3368','5',97200.00,'PRICE DICREMEN T FOR PMS PRODUCT ON 19/6/2021 FROM 165 TO 163=2*40,600=97200	',0.00,'2021-06-19'),(168113,'1','157','79852','201','supplier',97000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/6/2021 FROM 280 TO 285 =5*19,400=97,000',0.00,'2021-06-21'),(168114,'1','157','79852','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/6/2021 FROM 280 TO 285 =5*19,400=97,000	',97000.00,'2021-06-21'),(168115,'1','157','79853','201','supplier',1500.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/6/2021 FROM 285 TO 290 =5*300=1500',0.00,'2021-06-29'),(168116,'1','157','79853','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/6/2021 FROM 285 TO 290 =5*300=1500	',1500.00,'2021-06-29'),(168491,'1','157','80028','201','supplier',0.00,'PRICE DICREMEN T FOR AGO PRODUCT ON 16/8/2021 FROM 295 TO 290=5*22,900=114,500	',114500.00,'2021-08-16'),(168492,'1','157','80028','3368','5',114500.00,'PRICE DICREMEN T FOR AGO PRODUCT ON 16/8/2021 FROM 295 TO 290=5*22,900=114,500	',0.00,'2021-08-16'),(168530,'1','157','80046','201','supplier',0.00,'PRICE DICREMEN T FOR PMS PRODUCT ON 17/8/2021 FROM 163 TO 162=2*48,700=97,400',97400.00,'2021-08-17'),(168531,'1','157','80046','3368','5',97400.00,'PRICE DICREMEN T FOR PMS PRODUCT ON 17/8/2021 FROM 163 TO 162=2*48,700=97,400	',0.00,'2021-08-17'),(168802,'1','157','80175','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 16/9/2021 FROM 290 TO 295 =5*37,000=185,000	',185000.00,'2021-09-16'),(168803,'1','157','80175','201','supplier',185000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 16/9/2021 FROM 290 TO 295 =5*37,000=185,000	',0.00,'2021-09-16'),(168925,'1','157','80230','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/9/2021 FROM 295 TO 300 =5*29,500= 147,500	',147500.00,'2021-09-21'),(168926,'1','157','80230','201','supplier',147500.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 21/9/2021 FROM 295 TO 300 =5*29,900= 147,500	',0.00,'2021-09-21'),(169028,'1','157','80278','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 28/09/2021 FROM 300 TO 305=5*25,000= 125,000	',125000.00,'2021-09-28'),(169029,'1','157','80278','201','supplier',125000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 28/09/2021 FROM 300 TO 305=5*25,000= 125,000	',0.00,'2021-09-28'),(170541,'1','157','80830','201','supplier',155000.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 305 TO 315 , DIPPING(15,500',0.00,'2021-11-01'),(170542,'1','157','80830','3368','5',0.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 305 TO 315 , DIPPING(15,500',155000.00,'2021-11-01'),(170543,'1','157','80831','201','supplier',120000.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 315 TO 325 , DIPPING(12000',0.00,'2021-10-09'),(170544,'1','157','80831','3368','5',0.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 315 TO 325 , DIPPING(12000',120000.00,'2021-11-01'),(170545,'1','157','80832','201','supplier',125000.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 325 TO 350 , DIPPING(5000',0.00,'2021-10-18'),(170546,'1','157','80832','3368','5',0.00,'INVENTORY ADJUSTMENT VALUE OF AGO FROM 325 TO 350 , DIPPING(5000',125000.00,'2021-10-18'),(170547,'1','157','80833','201','supplier',14000.00,'INVENTORY ADJUSTMENT VALUE OF PMS FROM 162 TO 163 , DIPPING(14000',0.00,'2021-10-18'),(170548,'1','157','80833','3368','5',0.00,'INVENTORY ADJUSTMENT VALUE OF PMS FROM 162 TO 163 , DIPPING(14000',14000.00,'2021-10-18'),(170550,'1','157','80834','201','supplier',0.00,'INVENTORY ADJUSTMENT VALUE PRICE DECREMENT OF AGO FROM 350 TO 335 , DIPPING(3800',57000.00,'2021-10-20'),(170551,'1','157','80834','3368','5',57000.00,'INVENTORY ADJUSTMENT VALUE PRICE DECREMENT OF AGO FROM 350 TO 335 , DIPPING(3800',0.00,'2021-10-20'),(170554,'1','157','80836','201','supplier',23000.00,'INVENTORY ADJUSTMENT VALUE PRICE INCREMENT OF AGO FROM 335 TO 345 , DIPPING(2300',0.00,'2021-10-22'),(170555,'1','157','80836','3368','5',0.00,'INVENTORY ADJUSTMENT VALUE PRICE INCREMENT OF AGO FROM 335 TO 345 , DIPPING(2300',23000.00,'2021-10-22'),(172719,'1','157','81856','201','supplier',76800.00,'NVENTORY VALUE ADJUSTMENT INCREMENT OF PMS FROM 163 TO 165 (DIPPING=38,400)',0.00,'2021-12-02'),(172720,'1','157','81856','3368','5',0.00,'NVENTORY VALUE ADJUSTMENT INCREMENT OF PMS FROM 163 TO 165 (DIPPING=38,400)',76800.00,'2021-12-02'),(173907,'1','157','82316','201','supplier',124000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 18/1/2022 FROM 345 TO 350 =5*24,800= 124,000	',0.00,'2022-01-18'),(173908,'1','157','82316','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 18/1/2022 FROM 345 TO 350 =5*24,800= 124,000	',124000.00,'2022-01-18'),(174135,'1','157','82362','201','supplier',117000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 20/1/2022 FROM 350 TO 355 =5*23,400= 117,000	',0.00,'2022-01-20'),(174136,'1','157','82362','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 20/1/2022 FROM 350 TO 355 =5*23,400= 117,000	',117000.00,'2022-01-20'),(174431,'1','157','82430','201','supplier',100000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 28/1/2022 FROM 355 TO 360 =5*20,000= 100,000	',0.00,'2022-01-28'),(174432,'1','157','82430','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 28/1/2022 FROM 355 TO 360 =5*20,000= 100,000	',100000.00,'2022-01-28'),(174433,'1','157','82431','201','supplier',234000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 4/2/2022 FROM 360 TO 380 =20*11,700=234,000',0.00,'2022-02-04'),(174434,'1','157','82431','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 4/2/2022 FROM 360 TO 380 =20*11,700=234,000	',234000.00,'2022-02-04'),(174435,'1','157','82432','201','supplier',74000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 8/2/2022 FROM 380 TO 390 =10*7,400=74,000',0.00,'2022-02-08'),(174436,'1','157','82432','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 8/2/2022 FROM 380 TO 390 =10*7,400=74,000	',74000.00,'2022-02-08'),(174439,'1','157','82434','201','supplier',45000.00,'PRICE ICREMENT FOR AGO PRODUCT ON 12/2/2021 FROM 390 TO 400=10*4,500= 45,000	',0.00,'2022-02-12'),(174440,'1','157','82434','3368','5',0.00,'PRICE ICREMENT FOR AGO PRODUCT ON 12/2/2021 FROM 390 TO 400=10*4,500= 45,000	',45000.00,'2022-02-12'),(174441,'1','157','82435','201','supplier',164000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 15/2/2022 FROM 400 TO 410=10*16,400= 164,000	',0.00,'2022-02-15'),(174442,'1','157','82435','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 15/2/2022 FROM 400 TO 410=10*16,400= 164,000	',164000.00,'2022-02-15'),(174443,'1','157','82436','201','supplier',16500.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 410 TO 415=5*3,300=16,500',0.00,'2022-02-22'),(174444,'1','157','82436','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 410 TO 415=5*3,300=16,500	',16500.00,'2022-02-22'),(174445,'1','157','82437','201','supplier',8750.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 415 TO 420=5*31,750=8,750',0.00,'2022-02-25'),(174446,'1','157','82437','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 415 TO 420=5*31,750=8,750	',8750.00,'2022-02-25'),(174447,'1','157','82438','201','supplier',13000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 420 TO 430=10*1,300=13,000',0.00,'2022-03-02'),(174448,'1','157','82438','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 22/2/2021 FROM 420 TO 430=10*1,300=13,000	',13000.00,'2022-03-02'),(174450,'1','157','82439','201','supplier',33000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 04/03/2022 FROM 430 TO 460=30*1,100=33,000	',0.00,'2022-03-04'),(174452,'1','157','82439','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 04/03/2022 FROM 430 TO 460=30*1,100=33,000	',33000.00,'2022-03-04'),(174453,'1','157','82440','201','supplier',40000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 05/03/2022 FROM 460 TO 500=30*1,000=40,000	',0.00,'2022-03-05'),(174454,'1','157','82440','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 05/03/2022 FROM 460 TO 500=30*1,000=40,000	',40000.00,'2022-03-05'),(174455,'1','157','82441','201','supplier',70000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 08/03/2022 FROM 500 TO 600=100*700=70,000	',0.00,'2022-03-08'),(174456,'1','157','82441','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 08/03/2022 FROM 500 TO 600=100*700=70,000	',70000.00,'2022-03-08'),(174457,'1','157','82442','201','supplier',20000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 14/03/2022 FROM 600 TO 650=50*400= 20,000	',0.00,'2022-03-14'),(174458,'1','157','82442','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 14/03/2022 FROM 600 TO 650=50*400= 20,000	',20000.00,'2022-03-14'),(174459,'1','157','82443','201','supplier',3000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 16/3/2022 FROM 650 TO 660=10*300= 3, 000	',0.00,'2022-03-16'),(174460,'1','157','82443','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 16/3/2022 FROM 650 TO 660=10*300= 3, 000	',3000.00,'2022-03-16'),(174461,'1','157','82444','201','supplier',6000.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 19/3/2022 FROM 660 TO 680=20*300= 6, 000	',0.00,'2022-03-19'),(174462,'1','157','82444','3368','5',0.00,'PRICE ICREMEN T FOR AGO PRODUCT ON 19/3/2022 FROM 660 TO 680=20*300= 6, 000	',6000.00,'2022-03-19'),(174463,'1','157','82445','201','supplier',59000.00,'PRICE DICREMEN T FOR AGO PRODUCT ON 17/08/2022 FROM 810 TO 800=10*5,900= 59,000	',0.00,'2022-08-17'),(174464,'1','157','82445','3368','5',0.00,'PRICE DICREMEN T FOR AGO PRODUCT ON 17/08/2022 FROM 810 TO 800=10*5,900= 59,000	',59000.00,'2022-08-17');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3897 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2709,'','1','157','DAPE SERVICE STATION','AA RANO DAPE','07039753986','dapestation@gmail.com','abuja','abuja','life camp abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-29 15:33:42',5,'454','2021-05-29 15:33:42','454'),(3893,'','1','157','BAJAJ BOXER PROMO','HEAD OFFICE','08035450199','info@rano.com','KANO','KANO','AA RANO HEAD OFFICE KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-29 13:31:00',5,'454','2021-11-29 13:31:00','454'),(3894,'','1','157','DRIVER SHORTAGE ACCOUNT','UMAR TRANSPORT','08035742431','dapeservicestation@gmail.com ','ABUJA','ABUJA','abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 12:28:04',5,'454','2022-07-21 12:28:04','454'),(3895,'','1','157','G U EBECO  INDUSTRIAL LTD ','Mr. ABEL EGWIN','08142084682','update-guebeco@outlook,com','ABUJA','ABUJA ','PLOT 624 INDUSTRIAL LAYOUT JABI ABUJA ','Nigeria',2000000.00,0.00,0.00,'0000-00-00','2022-10-11 10:51:21',5,'454','2022-10-11 13:29:52','454'),(3896,'','1','157','NIGERIANN POLICE FORCE -ELECTI','CP USMAN','08071785115','dapstransport@gmail.com','FCT','ABUJA','NPF HEADQUARTER ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:32:28',5,'454','2023-02-21 17:32:28','454');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18500 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','157',13381,'838',3392.00,20250.00,'2020-12-23','ADD DIPPING','2020-12-28 11:28:12','556','556',2020,'556','2020-12-28 11:28:12',5),('1','157',13645,'840',1991.00,26700.00,'2021-01-10','ADD DIPPING','2021-02-10 06:11:27','556','556',2021,'556','2021-02-10 06:11:27',5),('1','157',13702,'836',1514.00,6800.00,'2021-02-16','add dipping','2021-02-18 09:05:36','556','556',2021,'556','2021-02-18 09:05:36',5),('1','157',13703,'838',2591.00,10200.00,'2021-02-16','ADD DIPPING','2021-02-18 09:07:05','556','556',2021,'556','2021-02-18 09:07:05',5),('1','157',13754,'836',650.00,4900.00,'2021-02-20','ADD DIPPING','2021-02-22 14:19:07','556','556',2021,'556','2021-02-22 14:19:07',5),('1','157',14162,'837',2030.00,11700.00,'2021-03-23','ADD DIPPING','2021-03-24 15:18:19','556','556',2021,'556','2021-03-24 15:18:19',5),('1','157',14296,'838',441.00,13200.00,'2021-03-30','add dipping','2021-03-31 15:35:04','556','556',2021,'556','2021-03-31 15:35:04',5),('1','157',14663,'837',50644.00,5800.00,'2021-04-29','','2021-04-30 08:24:17','454','454',2021,'454','2021-04-30 08:24:17',5),('1','157',14664,'838',57425.00,15000.00,'2021-04-29','','2021-04-30 08:24:47','454','454',2021,'454','2021-04-30 08:24:47',5),('1','157',14665,'840',36964.00,2300.00,'2021-04-29','','2021-04-30 08:25:05','454','454',2021,'454','2021-04-30 08:25:05',5),('1','157',14666,'836',47950.00,10.00,'2021-04-29','','2021-04-30 08:25:28','454','454',2021,'454','2021-04-30 08:25:28',5),('1','157',14667,'835',3038.00,10.00,'2021-04-29','','2021-04-30 08:26:00','454','454',2021,'454','2021-04-30 08:26:00',5),('1','157',15479,'840',210.56,1037.00,'2021-06-24','ADD DIPPING','2021-06-24 16:59:11','556','556',2021,'556','2021-06-24 16:59:11',5),('1','157',15480,'840',1037.00,1250.00,'2021-06-24','ADD DIPPING','2021-06-24 17:09:34','556','556',2021,'556','2021-06-24 17:09:34',5),('1','157',15481,'840',1250.00,1500.00,'2021-06-24','','2021-06-24 17:25:13','556','556',2021,'556','2021-06-24 17:25:13',5),('1','157',15685,'837',2206.07,11000.00,'2021-07-09','','2021-07-09 15:46:55','454','454',2021,'454','2021-07-09 15:46:55',5),('1','157',15821,'837',488.12,4200.00,'2021-07-24','','2021-07-24 12:23:20','454','454',2021,'454','2021-07-24 12:23:20',5),('1','157',15822,'838',7371.68,18100.00,'2021-07-24','','2021-07-24 12:24:44','454','454',2021,'454','2021-07-24 12:24:44',5),('1','157',16144,'837',3095.77,9700.00,'2021-08-21','','2021-08-21 14:16:11','454','454',2021,'454','2021-08-21 14:16:11',5),('1','157',16145,'838',25533.24,10400.00,'2021-08-21','','2021-08-21 14:16:57','454','454',2021,'454','2021-08-21 14:16:57',5),('1','157',16180,'838',10853.12,10000.00,'2021-08-26','','2021-08-26 08:36:54','454','454',2021,'454','2021-08-26 08:36:54',5),('1','157',16181,'837',3770.07,4200.00,'2021-08-26','','2021-08-26 08:37:13','454','454',2021,'454','2021-08-26 08:37:13',5),('1','157',16897,'840',223.20,1500.00,'2021-10-24','','2021-10-24 09:49:48','454','454',2021,'454','2021-10-24 09:49:48',5),('1','157',17001,'835',10.00,1.00,'2021-10-27','','2021-10-27 10:08:13','454','454',2021,'454','2021-10-27 10:08:13',5),('1','157',17002,'836',10.00,300.00,'2021-10-27','','2021-10-27 10:08:25','454','454',2021,'454','2021-10-27 10:08:25',5),('1','157',17003,'837',20340.91,400.00,'2021-10-27','','2021-10-27 10:08:43','454','454',2021,'454','2021-10-27 10:08:43',5),('1','157',17004,'838',51441.89,36800.00,'2021-10-27','','2021-10-27 10:08:55','454','454',2021,'454','2021-10-27 10:08:55',5),('1','157',17005,'839',0.00,1.00,'2021-10-27','','2021-10-27 10:09:08','454','454',2021,'454','2021-10-27 10:09:08',5),('1','157',17006,'840',459.36,300.00,'2021-10-27','','2021-10-27 10:09:33','454','454',2021,'454','2021-10-27 10:09:33',5),('1','157',17519,'838',216.72,750.00,'2021-11-06','','2021-11-06 22:21:40','454','454',2021,'454','2021-11-06 22:21:40',5),('1','157',17833,'838',5604.82,6100.00,'2021-11-30','','2021-11-30 09:42:24','454','454',2021,'454','2021-11-30 09:42:24',5),('1','157',17834,'838',6100.00,6400.00,'2021-11-30','','2021-11-30 09:43:04','454','454',2021,'454','2021-11-30 09:43:04',5),('1','157',17855,'837',498.98,1500.00,'2021-12-01','','2021-12-01 14:26:14','454','454',2021,'454','2021-12-01 14:26:14',5),('1','157',17911,'837',876.23,1600.00,'2021-12-04','','2021-12-04 17:29:38','454','454',2021,'454','2021-12-04 17:29:38',5),('1','157',17971,'837',2256.47,3250.00,'2021-12-10','','2021-12-10 13:55:37','454','454',2021,'454','2021-12-10 13:55:37',5),('1','157',17973,'836',300.00,600.00,'2021-12-10','','2021-12-10 15:55:20','611','611',2021,'611','2021-12-10 15:55:20',5),('1','157',17975,'836',600.00,300.00,'2021-12-10','','2021-12-10 15:57:07','611','611',2021,'611','2021-12-10 15:57:07',5),('1','157',18060,'837',11127.26,12990.00,'2021-12-16','','2021-12-16 13:15:59','611','611',2021,'611','2021-12-16 13:15:59',5),('1','157',18107,'838',3723.77,1200.00,'2021-12-18','','2021-12-18 15:12:26','611','611',2021,'611','2021-12-18 15:12:26',5),('1','157',18110,'838',1200.00,5600.00,'2021-12-18','','2021-12-18 21:00:58','454','454',2021,'454','2021-12-18 21:00:58',5),('1','157',18111,'838',5600.00,5600.00,'2021-12-18','','2021-12-18 21:01:16','454','454',2021,'454','2021-12-18 21:01:16',5),('1','157',18117,'835',1.00,1.00,'2021-12-19','','2021-12-19 11:24:52','454','454',2021,'454','2021-12-19 11:24:52',5),('1','157',18118,'836',300.00,300.00,'2021-12-19','','2021-12-19 11:25:17','454','454',2021,'454','2021-12-19 11:25:17',5),('1','157',18119,'837',12388.12,12300.00,'2021-12-19','','2021-12-19 11:25:42','454','454',2021,'454','2021-12-19 11:25:42',5),('1','157',18120,'838',685.04,500.00,'2021-12-19','','2021-12-19 11:26:11','454','454',2021,'454','2021-12-19 11:26:11',5),('1','157',18121,'840',20245.04,20800.00,'2021-12-19','','2021-12-19 11:28:04','454','454',2021,'454','2021-12-19 11:28:04',5),('1','157',18437,'837',2786.02,3100.00,'2022-01-14','','2022-01-14 15:08:13','454','454',2022,'454','2022-01-14 15:08:13',5),('1','157',18438,'838',2038.92,2340.00,'2022-02-21','','2022-02-21 21:09:23','611','611',2022,'611','2022-02-21 21:09:23',5),('1','157',18439,'840',459.10,10000.00,'2022-02-26','','2022-02-26 12:29:18','611','611',2022,'611','2022-02-26 12:29:18',5),('1','157',18440,'838',18409.52,19100.00,'2022-03-05','','2022-03-05 11:39:13','454','454',2022,'454','2022-03-05 11:39:13',5),('1','157',18441,'838',8133.81,9000.00,'2022-03-10','','2022-03-10 19:17:35','611','611',2022,'611','2022-03-10 19:17:35',5),('1','157',18442,'837',8174.24,9000.00,'2022-03-14','','2022-03-14 17:01:40','611','611',2022,'611','2022-03-14 17:01:40',5),('1','157',18443,'837',9000.00,12000.00,'2022-03-14','','2022-03-14 17:16:47','611','611',2022,'611','2022-03-14 17:16:47',5),('1','157',18444,'837',1770.21,1795.00,'2022-04-01','','2022-04-01 15:23:34','454','454',2022,'454','2022-04-01 15:23:34',5),('1','157',18445,'837',4918.16,7000.00,'2022-04-07','','2022-04-07 10:50:55','611','611',2022,'611','2022-04-07 10:50:55',5),('1','157',18446,'837',2126.79,3000.00,'2022-04-24','','2022-04-24 17:54:20','611','611',2022,'611','2022-04-24 17:54:20',5),('1','157',18447,'837',9765.82,11050.00,'2022-05-08','Add dipping','2022-05-08 17:28:10','611','611',2022,'611','2022-05-08 17:28:10',5),('1','157',18448,'837',401.22,3259.00,'2022-05-22','','2022-05-22 13:57:33','611','611',2022,'611','2022-05-22 13:57:33',5),('1','157',18449,'838',5616.90,5973.00,'2022-05-24','','2022-05-24 11:37:15','611','611',2022,'611','2022-05-24 11:37:15',5),('1','157',18450,'837',14183.01,15215.00,'2022-06-04','','2022-06-04 15:23:40','611','611',2022,'611','2022-06-04 15:23:40',5),('1','157',18451,'837',17383.10,17969.00,'2022-06-06','','2022-06-06 17:24:04','611','611',2022,'611','2022-06-06 17:24:04',5),('1','157',18452,'837',229.98,500.00,'2022-06-08','','2022-06-08 12:09:04','454','454',2022,'454','2022-06-08 12:09:04',5),('1','157',18453,'838',326.26,1250.00,'2022-06-08','','2022-06-08 12:09:20','454','454',2022,'454','2022-06-08 12:09:20',5),('1','157',18454,'840',8058.63,300.00,'2022-06-08','','2022-06-08 12:09:45','454','454',2022,'454','2022-06-08 12:09:45',5),('1','157',18455,'837',7480.40,8010.00,'2022-06-12','','2022-06-12 16:11:48','611','611',2022,'611','2022-06-12 16:11:48',5),('1','157',18456,'837',16853.80,17235.00,'2022-06-16','','2022-06-16 08:02:32','611','611',2022,'611','2022-06-16 08:02:32',5),('1','157',18457,'837',16477.84,17300.00,'2022-06-18','','2022-06-18 14:55:06','611','611',2022,'611','2022-06-18 14:55:06',5),('1','157',18458,'837',16404.43,17000.00,'2022-06-22','','2022-06-22 15:33:11','611','611',2022,'611','2022-06-22 15:33:11',5),('1','157',18459,'838',2041.20,1495.00,'2022-06-25','','2022-06-25 18:19:51','611','611',2022,'611','2022-06-25 18:19:51',5),('1','157',18460,'837',6029.83,7092.00,'2022-06-28','','2022-06-28 16:40:31','611','611',2022,'611','2022-06-28 16:40:31',5),('1','157',18461,'837',8412.21,8591.00,'2022-07-01','','2022-07-01 20:33:50','611','611',2022,'611','2022-07-01 20:33:50',5),('1','157',18462,'837',11118.61,12400.00,'2022-07-09','','2022-07-09 19:36:44','611','611',2022,'611','2022-07-09 19:36:44',5),('1','157',18463,'838',2535.14,2547.00,'2022-07-21','','2022-07-21 17:55:21','611','611',2022,'611','2022-07-21 17:55:21',5),('1','157',18464,'837',17032.29,18065.00,'2022-07-29','Add dipping to p m s tank 3 ','2022-07-29 22:41:52','611','611',2022,'611','2022-07-29 22:41:52',5),('1','157',18465,'838',2265.23,2335.00,'2022-08-02','','2022-08-02 08:36:40','611','611',2022,'611','2022-08-02 08:36:40',5),('1','157',18466,'838',3.73,2335.00,'2022-08-02','','2022-08-02 09:32:10','611','611',2022,'611','2022-08-02 09:32:10',5),('1','157',18467,'837',3870.04,6045.00,'2022-08-14','','2022-08-14 20:10:51','611','611',2022,'611','2022-08-14 20:10:51',5),('1','157',18468,'837',3248.85,3710.00,'2022-08-18','','2022-08-18 07:43:18','611','611',2022,'611','2022-08-18 07:43:18',5),('1','157',18469,'840',255.21,765.00,'2022-08-20','','2022-08-20 19:40:46','611','611',2022,'611','2022-08-20 19:40:46',5),('1','157',18470,'840',93.34,410.00,'2022-09-18','','2022-09-18 08:46:02','611','611',2022,'611','2022-09-18 08:46:02',5),('1','157',18471,'837',1282.44,3500.00,'2022-09-29','','2022-09-29 07:06:05','611','611',2022,'611','2022-09-29 07:06:05',5),('1','157',18472,'837',6717.97,7589.00,'2022-08-01','','2022-10-06 21:02:33','611','611',2022,'611','2022-10-06 21:02:33',5),('1','157',18473,'840',720.20,850.00,'2022-10-12','','2022-10-12 19:29:34','611','611',2022,'611','2022-10-12 19:29:34',5),('1','157',18474,'837',12768.65,13360.00,'2022-10-20','','2022-10-20 08:23:49','611','611',2022,'611','2022-10-20 08:23:49',5),('1','157',18475,'837',5054.56,5400.00,'2022-10-22','','2022-10-22 08:01:21','611','611',2022,'611','2022-10-22 08:01:21',5),('1','157',18476,'837',19443.76,20200.00,'2022-10-27','','2022-10-27 08:21:37','611','611',2022,'611','2022-10-27 08:21:37',5),('1','157',18477,'837',19301.34,20500.00,'2022-11-02','','2022-11-02 06:42:55','611','611',2022,'611','2022-11-02 06:42:55',5),('1','157',18478,'837',15522.29,20360.00,'2022-11-07','','2022-11-07 07:13:46','611','611',2022,'611','2022-11-07 07:13:46',5),('1','157',18479,'840',485.79,770.00,'2022-11-07','','2022-11-07 19:58:53','611','611',2022,'611','2022-11-07 19:58:53',5),('1','157',18480,'837',18541.01,15300.00,'2022-11-09','','2022-11-09 07:56:47','611','611',2022,'611','2022-11-09 07:56:47',5),('1','157',18481,'840',6.65,800.00,'2022-11-10','','2022-11-10 12:57:42','611','611',2022,'611','2022-11-10 12:57:42',5),('1','157',18482,'837',2833.58,3800.00,'2022-11-12','','2022-11-12 19:50:35','611','611',2022,'611','2022-11-12 19:50:35',5),('1','157',18483,'838',1655.35,3500.00,'2022-11-21','','2022-11-21 22:13:14','611','611',2022,'611','2022-11-21 22:13:14',5),('1','157',18484,'837',25477.00,500.00,'2022-11-26','','2022-11-26 09:13:46','611','611',2022,'611','2022-11-26 09:13:46',5),('1','157',18485,'838',2778.55,8200.00,'2022-11-26','','2022-11-26 09:14:27','611','611',2022,'611','2022-11-26 09:14:27',5),('1','157',18486,'837',500.00,19500.00,'2022-11-26','','2022-11-26 09:23:15','611','611',2022,'611','2022-11-26 09:23:15',5),('1','157',18487,'837',7422.91,7930.00,'2022-12-03','','2022-12-03 15:36:44','611','611',2022,'611','2022-12-03 15:36:44',5),('1','157',18488,'837',25690.01,26800.00,'2022-12-12','','2022-12-12 06:45:55','611','611',2022,'611','2022-12-12 06:45:55',5),('1','157',18489,'837',128.07,1200.00,'2022-12-12','','2022-12-12 19:04:27','611','611',2022,'611','2022-12-12 19:04:27',5),('1','157',18490,'838',17543.14,18000.00,'2022-12-13','','2022-12-13 20:12:20','611','611',2022,'611','2022-12-13 20:12:20',5),('1','157',18491,'840',374.34,1200.00,'2022-12-13','','2022-12-13 20:13:15','611','611',2022,'611','2022-12-13 20:13:15',5),('1','157',18492,'837',17272.62,19500.00,'2022-12-15','','2022-12-15 07:14:54','611','611',2022,'611','2022-12-15 07:14:54',5),('1','157',18493,'837',20719.35,25000.00,'2023-01-14','','2023-01-14 20:37:40','611','611',2023,'611','2023-01-14 20:37:40',5),('1','157',18494,'838',2004.80,2400.00,'2023-01-16','','2023-01-16 00:21:43','611','611',2023,'611','2023-01-16 00:21:43',5),('1','157',18495,'837',6953.29,11000.00,'2023-03-10','','2023-03-10 07:47:29','913','913',2023,'913','2023-03-10 07:47:29',5),('1','157',18496,'837',17072.27,18000.00,'2023-03-12','','2023-03-12 09:40:49','913','913',2023,'913','2023-03-12 09:40:49',5),('1','157',18497,'838',7579.18,4800.00,'2023-03-13','','2023-03-13 07:45:03','611','611',2023,'611','2023-03-13 07:45:03',5),('1','157',18498,'838',4800.00,8000.00,'2023-03-13','','2023-03-13 07:52:18','913','913',2023,'913','2023-03-13 07:52:18',5),('1','157',18499,'838',95.74,3500.00,'2023-03-14','','2023-03-14 08:39:01','611','611',2023,'611','2023-03-14 08:39:01',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2413 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','157','835',2389,'5','PUMP 13',56814.23,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:39:09','178'),('1','157','835',2390,'5','PUMP 14',24541.94,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:39:29','178'),('1','157','835',2391,'5','PUMP 15',41290.47,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:39:49','178'),('1','157','835',2392,'5','PUMP 16',50546.09,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:40:08','178'),('1','157','836',2393,'5','PUMP 17',32563.00,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:40:31','178'),('1','157','836',2394,'5','PUMP 18',116014.63,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:40:48','178'),('1','157','836',2395,'5','PUMP 19',153498.46,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:41:09','178'),('1','157','836',2396,'5','PUMP 20',209570.50,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:41:27','178'),('1','157','837',2397,'5','PUMP 1',1625839.57,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:34:15','178'),('1','157','837',2398,'5','PUMP 2',1824687.21,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:34:39','178'),('1','157','837',2399,'5','PUMP 3',659000.74,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:35:04','178'),('1','157','837',2400,'5','PUMP 4',1846274.61,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:35:23','178'),('1','157','838',2401,'5','PUMP 5',1152046.71,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:35:42','178'),('1','157','838',2402,'5','PUMP 6',646863.71,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:35:59','178'),('1','157','838',2403,'5','PUMP 7',608516.43,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:36:19','178'),('1','157','838',2404,'5','PUMP 8',371385.56,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-26 10:05:47','454'),('1','157','839',2405,'5','PUMP 9',573.37,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:37:19','178'),('1','157','839',2406,'5','PUMP 10',621.35,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:37:40','178'),('1','157','839',2407,'5','PUMP 11',682.38,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:38:00','178'),('1','157','839',2408,'5','PUMP 12',593.32,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-12 10:38:35','178'),('1','157','840',2409,'5','AGO PUMP 1',13056.62,'DISPENSING AGO','',NULL,NULL,'',5,'2020-11-26 16:47:59','178'),('1','157','840',2410,'5','AGO PUMP 2',667253.31,'DISPENSING AGO','',NULL,NULL,'',5,'2020-11-26 16:48:30','178'),('1','157','840',2411,'5','AGO PUMP 3',2112862.19,'DISPENSING AGO','',NULL,NULL,'',5,'2020-11-16 14:36:44','556'),('1','157','840',2412,'5','AGO PUMP 4',1362683.11,'DISPENSING AGO','',NULL,NULL,'',5,'2020-11-16 14:37:31','556');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258007 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','157',161601,'FULL DAY','2020-10-22','2020-10-22 00:00:00',NULL,'556',886914.04,881300.66,'556','2020-11-12 14:44:08','556','2020-11-12 14:46:04',10,0),('1','157',161615,'FULL DAY','2020-10-23','2020-10-23 00:00:00',NULL,'556',1594132.61,1584224.99,'556','2020-11-12 15:23:48','556','2020-11-12 15:24:43',10,0),('1','157',161621,'FULL DAY','2020-10-24','2020-10-24 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',161626,'FULL DAY','2020-10-24','2020-10-24 00:00:00',NULL,'556',1714026.47,1703291.18,'556','2020-11-12 15:46:33','556','2020-11-12 15:47:43',10,0),('1','157',161628,'FULL DAY','2020-10-25','2020-10-25 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',162998,'FULL DAY','2020-10-25','2020-10-25 00:00:00',NULL,'556',1828222.20,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',163091,'FULL DAY','2020-10-25','2020-10-25 00:00:00',NULL,'556',0.00,0.00,'556','2020-11-20 11:42:42','556','2020-11-20 11:45:08',10,0),('1','157',163094,'FULL DAY','2020-10-25','2020-10-25 00:00:00',NULL,'556',1828222.20,1816817.65,'556','2020-11-20 11:53:29','556','2020-11-20 11:54:53',10,0),('1','157',163098,'MORNING','2020-11-20','2020-11-20 00:00:00',NULL,'556',0.00,0.00,'556','2020-11-20 11:57:07','556','2020-11-20 11:57:34',10,0),('1','157',163099,'MORNING','2020-10-26','2020-10-26 00:00:00',NULL,'556',1310325.87,1302080.78,'556','2020-11-20 12:02:22','556','2020-11-20 12:03:59',10,0),('1','157',163101,'AFTERNOON','2020-10-26','2020-10-26 00:00:00',NULL,'556',1281925.22,1274089.48,'556','2020-11-20 12:09:17','556','2020-11-20 12:10:27',10,0),('1','157',163103,'MORNING','2020-10-27','2020-10-27 00:00:00',NULL,'556',548927.27,546095.43,'556','2020-11-20 12:18:38','556','2020-11-20 12:20:05',10,0),('1','157',163118,'MORNING ONE','2020-10-28','2020-10-28 00:00:00',NULL,'556',597544.94,593763.01,'556','2020-11-20 13:26:08','556','2020-11-20 13:27:30',10,0),('1','157',163121,'MORNING TWO','2020-10-28','2020-10-28 00:00:00',NULL,'556',1664218.74,1685284.80,'556','2020-11-20 13:40:51','556','2020-11-20 13:42:28',10,0),('1','157',163128,'AFTERNOON','2020-10-28','2020-10-28 00:00:00',NULL,'556',1688511.01,1708678.25,'556','2020-11-20 13:47:12','556','2020-11-20 13:48:24',10,0),('1','157',163131,'MORNING','2020-10-29','2020-10-29 00:00:00',NULL,'556',1190513.80,1202684.20,'556','2020-11-20 13:58:36','556','2020-11-20 14:00:21',10,0),('1','157',163134,'AFTERNOON','2020-10-29','2020-10-29 00:00:00',NULL,'556',769543.35,779251.55,'556','2020-11-20 14:09:50','556','2020-11-20 14:11:24',10,0),('1','157',163140,'MORNING','2020-10-30','2020-10-30 00:00:00',NULL,'556',855594.13,866331.35,'556','2020-11-20 14:19:16','556','2020-11-20 14:20:43',10,0),('1','157',163144,'AFTERNOON','2020-10-30','2020-10-30 00:00:00',NULL,'556',1187765.15,1200521.35,'556','2020-11-20 14:28:02','556','2020-11-20 14:29:29',10,0),('1','157',163147,'MORNING','2020-10-31','2020-10-31 00:00:00',NULL,'556',1066932.34,1080090.20,'556','2020-11-20 14:38:37','556','2020-11-20 14:40:53',10,0),('1','157',163149,'AFTERNOON','2020-10-31','2020-10-31 00:00:00',NULL,'556',824638.79,834501.25,'556','2020-11-20 14:48:53','556','2020-11-20 14:50:15',10,0),('1','157',163151,'MORNING','2020-11-01','2020-11-01 00:00:00',NULL,'556',898112.08,908770.00,'556','2020-11-20 14:58:12','556','2020-11-20 14:59:16',10,0),('1','157',163154,'AFTERNOON','2020-11-01','2020-11-01 00:00:00',NULL,'556',784347.98,794229.60,'556','2020-11-20 15:04:34','556','2020-11-20 15:05:38',10,0),('1','157',163158,'MORNING','2020-11-02','2020-11-02 00:00:00',NULL,'556',1030040.29,1041196.95,'556','2020-11-20 15:15:57','556','2020-11-20 15:17:25',10,0),('1','157',163160,'AFTERNOON','2020-11-02','2020-11-02 00:00:00',NULL,'556',843125.65,853546.55,'556','2020-11-20 15:23:13','556','2020-11-20 15:25:26',10,0),('1','157',163161,'MORNING','2020-11-03','2020-11-03 00:00:00',NULL,'556',1039315.54,1039315.54,'556','2020-11-20 15:31:07','556','2020-11-20 15:32:30',10,0),('1','157',163163,'AFTERNOON','2020-11-03','2020-11-03 00:00:00',NULL,'556',1111689.39,1111689.39,'556','2020-11-20 15:51:56','556','2020-11-20 15:52:58',10,0),('1','157',163286,'MORNING','2020-11-04','2020-11-04 00:00:00',NULL,'556',916696.35,916696.35,'556','2020-11-21 11:34:24','556','2020-11-21 11:35:05',10,0),('1','157',163290,'AFTERNOON','2020-11-04','2020-11-04 00:00:00',NULL,'556',920610.56,920610.56,'556','2020-11-21 11:40:28','556','2020-11-21 11:43:13',10,0),('1','157',163292,'MORNING','2020-11-05','2020-11-05 00:00:00',NULL,'556',1115258.29,1115258.29,'556','2020-11-21 11:57:39','556','2020-11-21 11:58:12',10,0),('1','157',163295,'AFTERNOON','2020-11-05','2020-11-05 00:00:00',NULL,'556',998628.91,998628.91,'556','2020-11-21 12:01:48','556','2020-11-21 12:02:32',10,0),('1','157',163479,'MORNING','2020-11-06','2020-11-06 00:00:00',NULL,'556',1324225.92,1324225.92,'556','2020-11-22 13:27:21','556','2020-11-22 13:28:11',10,0),('1','157',163481,'AFTERNOON','2020-11-06','2020-11-06 00:00:00',NULL,'556',1410528.01,1410528.01,'556','2020-11-22 13:34:13','556','2020-11-22 13:35:09',10,0),('1','157',163482,'MORNING','2020-11-07','2020-11-07 00:00:00',NULL,'556',1656538.82,1656538.82,'556','2020-11-22 13:43:17','556','2020-11-22 13:52:23',10,0),('1','157',163490,'AFTERNOON','2020-11-07','2020-11-07 00:00:00',NULL,'556',1192226.76,1192226.76,'556','2020-11-22 13:56:55','556','2020-11-22 13:58:00',10,0),('1','157',163494,'MORNING','2020-11-08','2020-11-08 00:00:00',NULL,'556',1708408.60,1708408.60,'556','2020-11-22 14:07:02','556','2020-11-22 14:08:34',10,0),('1','157',163499,'AFTERNOON','2020-11-08','2020-11-08 00:00:00',NULL,'556',1195138.04,1195138.04,'556','2020-11-22 14:16:08','556','2020-11-22 14:17:24',10,0),('1','157',163504,'MORNING','2020-11-09','2020-11-09 00:00:00',NULL,'556',1555404.95,1555404.95,'556','2020-11-23 10:05:55','556','2020-11-23 10:06:28',10,0),('1','157',163608,'AFTERNOON','2020-11-09','2020-11-09 00:00:00',NULL,'556',1484141.28,1484141.28,'556','2020-11-23 10:09:45','556','2020-11-23 10:11:00',10,0),('1','157',163611,'MORNING','2020-11-10','2020-11-10 00:00:00',NULL,'556',1599607.23,1599607.23,'556','2020-11-23 10:16:06','556','2020-11-23 10:25:27',10,0),('1','157',163613,'AFTERNOON','2020-11-10','2020-11-10 00:00:00',NULL,'556',1381765.60,1381765.60,'556','2020-11-23 10:28:10','556','2020-11-23 10:31:18',10,0),('1','157',163619,'MORNING','2020-11-11','2020-11-11 00:00:00',NULL,'556',1147070.03,1147070.03,'556','2020-11-23 10:41:20','556','2020-11-23 10:48:24',10,0),('1','157',163623,'AFTERNOON','2020-11-11','2020-11-11 00:00:00',NULL,'556',1064818.50,1064818.50,'556','2020-11-23 10:51:14','556','2020-11-23 10:51:40',10,0),('1','157',163626,'MORNING','2020-11-12','2020-11-12 00:00:00',NULL,'556',1149264.33,1149264.33,'556','2020-11-23 10:55:35','556','2020-11-23 10:57:05',10,0),('1','157',163629,'AFTERNOON','2020-11-12','2020-11-12 00:00:00',NULL,'556',1041521.00,1041521.00,'556','2020-11-23 11:00:29','556','2020-11-23 11:01:36',10,0),('1','157',163631,'MORNING','2020-11-13','2020-11-13 00:00:00',NULL,'556',1274726.01,1274726.01,'556','2020-11-23 11:07:57','556','2020-11-23 11:08:22',10,0),('1','157',163634,'AFTERNOON','2020-11-13','2020-11-13 00:00:00',NULL,'556',1491793.49,1509756.05,'556','2020-11-24 14:38:14','556','2020-11-24 14:38:48',10,0),('1','157',163864,'MORNING ONE','2020-11-14','2020-11-14 00:00:00',NULL,'556',240980.54,232270.40,'556','2020-11-24 14:54:28','556','2020-11-24 14:55:01',10,0),('1','157',163865,'MORNING TWO','2020-11-14','2020-11-14 00:00:00',NULL,'556',1377884.01,1392526.63,'556','2020-11-24 14:58:16','556','2020-11-24 15:01:28',10,0),('1','157',163866,'AFTERNOON','2020-11-14','2020-11-14 00:00:00',NULL,'556',1048071.98,1060262.04,'556','2020-11-25 16:41:06','556','2020-11-25 16:41:45',10,0),('1','157',164071,'MORNING ONE','2020-11-15','2020-11-15 00:00:00',NULL,'556',616973.86,624407.28,'556','2020-11-25 16:55:39','556','2020-11-25 16:58:56',10,0),('1','157',164072,'MORNING TWO','2020-11-15','2020-11-15 00:00:00',NULL,'556',562104.36,562104.36,'556','2020-11-25 17:02:45','556','2020-11-25 17:03:36',10,0),('1','157',164073,'AFTERNOON','2020-11-15','2020-11-15 00:00:00',NULL,'556',894108.50,894108.50,'556','2020-11-25 17:07:57','556','2020-11-25 17:09:10',10,0),('1','157',164140,'MORNING','2020-11-16','2020-11-16 00:00:00',NULL,'556',1361270.08,1361270.08,'556','2020-11-26 10:48:43','556','2020-11-26 10:49:41',10,0),('1','157',164142,'AFTERNOON','2020-11-16','2020-11-16 00:00:00',NULL,'556',1360300.17,1360300.17,'556','2020-11-26 14:40:44','556','2020-11-26 14:41:24',10,0),('1','157',164203,'MORNING','2020-11-17','2020-11-17 00:00:00',NULL,'556',801273.14,801273.14,'556','2020-11-26 14:50:38','556','2020-11-26 14:51:44',10,0),('1','157',164207,'AFTERNOON','2020-11-17','2020-11-17 00:00:00',NULL,'556',10099.15,10099.15,'556','2020-11-26 14:54:00','556','2020-11-26 14:54:20',10,0),('1','157',164209,'MORNING','2020-11-18','2020-11-18 00:00:00',NULL,'556',1324109.40,1324109.40,'556','2020-11-26 15:01:08','556','2020-11-26 15:02:38',10,0),('1','157',164265,'AFTERNOON','2020-11-18','2020-11-18 00:00:00',NULL,'556',830739.99,830739.99,'556','2020-11-26 20:19:24','556','2020-11-26 20:20:55',10,0),('1','157',164267,'MORNING','2020-11-19','2020-11-19 00:00:00',NULL,'556',193203.27,193203.27,'556','2020-11-26 20:24:49','556','2020-11-26 20:26:01',10,0),('1','157',164269,'AFTERNOON','2020-11-19','2020-11-19 00:00:00',NULL,'556',15097.85,15097.85,'556','2020-11-26 21:36:26','556','2020-11-26 21:36:56',10,0),('1','157',164270,'MORNING','2020-11-20','2020-11-20 00:00:00',NULL,'556',1163423.98,1163423.98,'556','2020-11-26 21:40:36','556','2020-11-26 21:41:17',10,0),('1','157',164271,'AFTERNOON','2020-11-20','2020-11-20 00:00:00',NULL,'556',1007790.31,1007790.31,'556','2020-11-26 21:44:37','556','2020-11-26 21:45:13',10,0),('1','157',164272,'MORNING','2020-11-21','2020-11-21 00:00:00',NULL,'556',1167149.65,1167149.65,'556','2020-11-26 21:52:33','556','2020-11-26 21:53:12',10,0),('1','157',164273,'AFTERNOON','2020-11-21','2020-11-21 00:00:00',NULL,'556',1086216.74,1086216.74,'556','2020-11-26 21:56:24','556','2020-11-26 21:58:35',10,0),('1','157',164274,'MORNING','2020-11-22','2020-11-22 00:00:00',NULL,'556',948173.33,948173.33,'556','2020-11-26 22:07:54','556','2020-11-26 22:08:22',10,0),('1','157',164275,'AFTERNOON','2020-11-22','2020-11-22 00:00:00',NULL,'556',850330.78,850330.78,'556','2020-11-26 22:12:28','556','2020-11-26 22:13:01',10,0),('1','157',164276,'MORNING','2020-11-23','2020-11-23 00:00:00',NULL,'556',1102570.07,1102570.07,'556','2020-11-26 22:25:08','556','2020-11-26 22:25:31',10,0),('1','157',164279,'AFTERNOON','2020-11-23','2020-11-23 00:00:00',NULL,'556',1117395.53,1117395.53,'556','2020-11-26 22:28:59','556','2020-11-26 22:29:46',10,0),('1','157',164281,'MORNING','2020-11-24','2020-11-24 00:00:00',NULL,'556',1338965.72,1338965.72,'556','2020-11-30 11:12:20','556','2020-11-30 11:13:41',10,0),('1','157',164837,'AFTERNOON','2020-11-24','2020-11-24 00:00:00',NULL,'556',1089764.80,1089764.80,'556','2020-11-30 11:21:46','556','2020-11-30 11:26:00',10,0),('1','157',164839,'MORNING','2020-11-25','2020-11-25 00:00:00',NULL,'556',1203296.58,1203296.58,'556','2020-11-30 11:30:47','556','2020-11-30 11:31:59',10,0),('1','157',164841,'AFTERNOON','2020-11-25','2020-11-25 00:00:00',NULL,'556',1316592.01,1323929.96,'556','2020-11-30 11:39:52','556','2020-11-30 11:41:46',10,0),('1','157',164843,'MORNING','2020-11-30','2020-11-30 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',164844,'MORNING','2020-11-26','2020-11-26 00:00:00',NULL,'556',1155795.31,1156029.56,'556','2020-11-30 11:47:56','556','2020-11-30 11:48:41',10,0),('1','157',164845,'AFTERNOON','2020-11-26','2020-11-26 00:00:00',NULL,'556',1079248.57,1083746.07,'556','2020-11-30 11:52:27','556','2020-11-30 11:53:08',10,0),('1','157',164846,'MORNING','2020-11-27','2020-11-27 00:00:00',NULL,'556',1304293.15,1307974.65,'556','2020-11-30 11:58:55','556','2020-11-30 12:00:53',10,0),('1','157',164850,'AFTERNOON','2020-11-27','2020-11-27 00:00:00',NULL,'556',1283870.75,1288004.25,'556','2020-11-30 12:09:42','556','2020-11-30 12:11:26',10,0),('1','157',164855,'MORNING','2020-11-28','2020-11-28 00:00:00',NULL,'556',1186640.37,1191070.47,'556','2020-11-30 12:20:11','556','2020-11-30 12:21:50',10,0),('1','157',164857,'AFTERNOON','2020-11-28','2020-11-28 00:00:00',NULL,'556',1120339.11,1121795.61,'556','2020-11-30 12:24:29','556','2020-11-30 12:24:56',10,0),('1','157',164858,'MORNING','2020-11-29','2020-11-29 00:00:00',NULL,'556',1020716.91,1022537.41,'556','2020-11-30 12:28:22','556','2020-11-30 12:28:49',10,0),('1','157',164860,'AFTERNOON','2020-11-29','2020-11-29 00:00:00',NULL,'556',857292.38,858533.18,'556','2020-11-30 12:34:39','556','2020-11-30 12:35:34',10,0),('1','157',165174,'MORNING','2020-11-30','2020-11-30 00:00:00',NULL,'556',1203105.47,1206833.77,'556','2020-12-02 14:57:55','556','2020-12-02 14:59:41',10,0),('1','157',165235,'AFTERNOON','2020-11-30','2020-11-30 00:00:00',NULL,'556',1289351.65,1293205.35,'556','2020-12-02 15:20:24','556','2020-12-02 15:23:26',10,0),('1','157',165243,'MORNING','2020-12-01','2020-12-01 00:00:00',NULL,'556',1243194.86,1246030.46,'556','2020-12-02 15:41:27','556','2020-12-02 15:48:15',10,0),('1','157',165249,'AFTERNOON','2020-12-01','2020-12-01 00:00:00',NULL,'556',1096699.17,1098596.07,'556','2020-12-02 16:01:42','556','2020-12-02 16:06:26',10,0),('1','157',165254,'MORNING','2020-12-02','2020-12-02 00:00:00',NULL,'556',1315739.57,1317697.67,'556','2020-12-03 19:10:01','556','2020-12-03 19:11:03',10,0),('1','157',165440,'AFTERNOON','2020-12-02','2020-12-02 00:00:00',NULL,'556',1173660.38,1181568.38,'556','2020-12-03 19:28:06','556','2020-12-03 19:30:19',10,0),('1','157',165442,'MORNING','2020-12-03','2020-12-03 00:00:00',NULL,'556',1314495.97,1323318.47,'556','2020-12-07 16:50:55','556','2020-12-07 16:51:48',10,0),('1','157',166119,'AFTERNOON','2020-12-03','2020-12-03 00:00:00',NULL,'556',1244401.22,1246826.82,'556','2020-12-07 16:56:44','556','2020-12-07 16:57:58',10,0),('1','157',166122,'MORNING','2020-12-04','2020-12-04 00:00:00',NULL,'556',1477371.01,1493552.11,'556','2020-12-07 17:05:45','556','2020-12-07 17:08:14',10,0),('1','157',166127,'AFTERNOON','2020-12-04','2020-12-04 00:00:00',NULL,'556',1390636.51,1401813.41,'556','2020-12-07 17:19:41','556','2020-12-07 17:24:49',10,0),('1','157',166129,'MORNING','2020-12-05','2020-12-05 00:00:00',NULL,'556',1408734.11,1413418.81,'556','2020-12-07 17:39:11','556','2020-12-07 17:43:31',10,0),('1','157',166132,'AFTERNOON','2020-12-05','2020-12-05 00:00:00',NULL,'556',1234493.18,1244762.98,'556','2020-12-07 17:56:38','556','2020-12-07 17:57:12',10,0),('1','157',166135,'MORNING','2020-12-06','2020-12-06 00:00:00',NULL,'556',1025772.22,1027656.82,'556','2020-12-07 18:14:33','556','2020-12-07 18:17:09',10,0),('1','157',166137,'AFTERNOON','2020-12-06','2020-12-06 00:00:00',NULL,'556',872960.34,873247.54,'556','2020-12-07 18:43:34','556','2020-12-07 18:45:25',10,0),('1','157',166140,'MORNING','2020-12-07','2020-12-07 00:00:00',NULL,'556',1321189.87,1328094.17,'556','2020-12-09 17:35:49','556','2020-12-09 17:37:35',10,0),('1','157',166476,'AFTERNOON','2020-12-07','2020-12-07 00:00:00',NULL,'556',1273167.93,1275728.93,'556','2020-12-09 17:53:02','556','2020-12-09 17:53:59',10,0),('1','157',166479,'MORNING','2020-12-08','2020-12-08 00:00:00',NULL,'556',1306511.19,1313738.19,'556','2020-12-09 18:01:23','556','2020-12-09 18:02:26',10,0),('1','157',166482,'AFTERNOON','2020-12-08','2020-12-08 00:00:00',NULL,'556',1198206.84,1202065.64,'556','2020-12-09 18:09:47','556','2020-12-09 18:11:06',10,0),('1','157',166485,'MORNING','2020-12-09','2020-12-09 00:00:00',NULL,'556',1256169.41,1261169.61,'556','2020-12-09 18:18:48','556','2020-12-09 18:19:42',10,0),('1','157',166491,'AFTERNOON','2020-12-09','2020-12-09 00:00:00',NULL,'556',1257873.30,1262288.90,'556','2020-12-11 17:41:35','556','2020-12-12 16:33:21',10,0),('1','157',167012,'MORNING','2020-12-10','2020-12-10 00:00:00',NULL,'556',1253251.99,1258422.59,'556','2020-12-12 16:45:09','556','2020-12-12 16:45:51',10,0),('1','157',167018,'AFTERNOON','2020-12-10','2020-12-10 00:00:00',NULL,'556',1332685.65,1350740.65,'556','2020-12-12 17:21:31','556','2020-12-12 17:22:20',10,0),('1','157',167021,'MORNING','2020-12-11','2020-12-11 00:00:00',NULL,'556',1240443.36,1246062.96,'556','2020-12-12 17:30:59','556','2020-12-12 17:31:30',10,0),('1','157',167023,'AFTERNOON','2020-12-11','2020-12-11 00:00:00',NULL,'556',1410440.24,1423415.84,'556','2020-12-12 17:43:37','556','2020-12-12 17:44:11',10,0),('1','157',167025,'MORNING','2020-12-12','2020-12-12 00:00:00',NULL,'556',1352340.59,1361942.39,'556','2020-12-12 17:50:01','556','2020-12-12 17:50:54',10,0),('1','157',167026,'AFTERNOON','2020-12-12','2020-12-12 00:00:00',NULL,'556',1342860.18,1350896.18,'556','2020-12-16 10:44:50','556','2020-12-16 10:48:09',10,0),('1','157',167620,'MORNING','2020-12-13','2020-12-13 00:00:00',NULL,'556',1202830.33,1202830.33,'556','2020-12-16 11:02:22','556','2020-12-16 11:03:25',10,0),('1','157',167624,'AFTERNOON','2020-12-13','2020-12-13 00:00:00',NULL,'556',960109.14,960109.14,'556','2020-12-16 11:16:30','556','2020-12-16 11:17:25',10,0),('1','157',167627,'MORNING','2020-12-14','2020-12-14 00:00:00',NULL,'556',1367116.24,1367116.24,'556','2020-12-16 11:24:56','556','2020-12-16 11:25:55',10,0),('1','157',167630,'AFTERNOON','2020-12-14','2020-12-14 00:00:00',NULL,'556',1489399.69,1492741.34,'556','2020-12-16 11:37:01','556','2020-12-16 11:38:41',10,0),('1','157',167640,'MORNING','2020-12-15','2020-12-15 00:00:00',NULL,'556',1396205.29,1397583.84,'556','2020-12-16 11:48:50','556','2020-12-16 11:49:28',10,0),('1','157',167644,'AFTERNOON','2020-12-16','2020-12-16 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',167646,'AFTERNOON','2020-12-15','2020-12-15 00:00:00',NULL,'556',1375359.69,1375642.94,'556','2020-12-16 17:22:16','556','2020-12-16 17:22:50',10,0),('1','157',167715,'MORNING','2020-12-16','2020-12-16 00:00:00',NULL,'556',1413034.32,1415462.92,'556','2020-12-17 17:17:15','556','2020-12-17 17:24:04',10,0),('1','157',167896,'AFTERNOON','2020-12-16','2020-12-16 00:00:00',NULL,'556',1233144.09,1211580.07,'556','2020-12-17 17:32:37','556','2020-12-17 17:33:31',10,0),('1','157',167899,'MORNING','2020-12-17','2020-12-17 00:00:00',NULL,'556',1323764.68,1302958.94,'556','2020-12-17 17:40:53','556','2020-12-17 17:41:26',10,0),('1','157',167901,'AFTERNOON','2020-12-17','2020-12-17 00:00:00',NULL,'556',1384464.73,1368572.94,'556','2020-12-18 18:24:23','556','2020-12-18 18:24:56',10,0),('1','157',168112,'MORNING','2020-12-18','2020-12-18 00:00:00',NULL,'556',1379159.40,1356769.85,'556','2020-12-18 18:32:42','556','2020-12-18 18:33:27',10,0),('1','157',168115,'AFTERNOON','2020-12-18','2020-12-18 00:00:00',NULL,'556',1276554.60,1254575.05,'556','2020-12-21 14:54:11','556','2020-12-21 14:55:40',10,0),('1','157',168562,'MORNING','2020-12-19','2020-12-19 00:00:00',NULL,'556',1355212.50,1356539.40,'556','2020-12-21 15:00:27','556','2020-12-21 15:00:54',10,0),('1','157',168564,'AFTERNOON','2020-12-19','2020-12-19 00:00:00',NULL,'556',1373296.30,1376655.80,'556','2020-12-26 10:29:16','556','2020-12-26 10:29:42',10,0),('1','157',169325,'MORNING','2020-12-20','2020-12-20 00:00:00',NULL,'556',1459070.48,1446909.80,'556','2020-12-26 10:34:45','556','2020-12-26 10:35:08',10,0),('1','157',169327,'AFTERNOON','2020-12-20','2020-12-20 00:00:00',NULL,'556',1103900.29,1090999.90,'556','2020-12-26 10:39:18','556','2020-12-26 10:40:03',10,0),('1','157',169331,'MORNING','2020-12-21','2020-12-21 00:00:00',NULL,'556',1423821.40,1408437.40,'556','2020-12-26 10:45:37','556','2020-12-26 10:46:08',10,0),('1','157',169333,'AFTERNOON','2020-12-21','2020-12-21 00:00:00',NULL,'556',1424314.07,1407798.50,'556','2020-12-26 10:50:41','556','2020-12-26 10:51:05',10,0),('1','157',169334,'MORNING','2020-12-22','2020-12-22 00:00:00',NULL,'556',1483739.82,1468095.20,'556','2020-12-26 11:18:46','556','2020-12-26 11:19:14',10,0),('1','157',169339,'AFTERNOON','2020-12-22','2020-12-22 00:00:00',NULL,'556',496965.63,502316.97,'556','2020-12-26 11:30:40','556','2020-12-26 11:31:11',10,0),('1','157',169341,'MORNING','2020-12-23','2020-12-23 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',169342,'MORNING','2020-12-24','2020-12-24 00:00:00',NULL,'556',1332777.83,1335247.08,'556','2020-12-28 11:34:25','556','2020-12-28 11:35:35',10,0),('1','157',169673,'AFTERNOON','2020-12-24','2020-12-24 00:00:00',NULL,'556',1609287.02,1609744.02,'556','2020-12-28 11:39:33','556','2020-12-28 11:39:58',10,0),('1','157',169675,'MORNING','2020-12-25','2020-12-25 00:00:00',NULL,'556',1655531.52,1656574.92,'556','2020-12-30 15:14:16','556','2020-12-30 15:14:54',10,0),('1','157',170076,'AFTERNOON','2020-12-25','2020-12-25 00:00:00',NULL,'556',1361304.20,1361859.00,'556','2020-12-30 15:20:14','556','2020-12-30 15:20:48',10,0),('1','157',170077,'MORNING','2020-12-26','2020-12-26 00:00:00',NULL,'556',1111390.19,1114622.34,'556','2020-12-30 15:24:16','556','2020-12-30 15:24:55',10,0),('1','157',170079,'AFTERNOON','2020-12-26','2020-12-26 00:00:00',NULL,'556',598698.60,599636.70,'556','2020-12-30 15:29:08','556','2020-12-30 15:29:35',10,0),('1','157',170080,'MORNING','2020-12-27','2020-12-27 00:00:00',NULL,'556',957405.95,957811.20,'556','2020-12-30 15:39:21','556','2020-12-30 15:40:10',10,0),('1','157',170083,'AFTERNOON','2020-12-30','2020-12-30 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',170084,'AFTERNOON','2020-12-27','2020-12-27 00:00:00',NULL,'556',294677.91,295004.16,'556','2020-12-30 15:45:11','556','2020-12-30 15:45:36',10,0),('1','157',170085,'MORNING','2020-12-29','2020-12-29 00:00:00',NULL,'556',51551.35,52808.70,'556','2020-12-30 15:48:54','556','2020-12-30 15:50:15',10,0),('1','157',170086,'AFTERNOON','2020-12-29','2020-12-29 00:00:00',NULL,'556',414065.30,415777.20,'556','2020-12-30 15:55:11','556','2020-12-30 15:55:40',10,0),('1','157',170087,'MORNING','2020-12-30','2020-12-30 00:00:00',NULL,'556',849176.55,849717.00,'556','2020-12-30 15:58:59','556','2020-12-30 15:59:26',10,0),('1','157',170090,'AFTERNOON','2020-12-30','2020-12-30 00:00:00',NULL,'556',955255.58,955660.38,'556','2021-01-01 10:33:39','556','2021-01-01 10:34:14',10,0),('1','157',170385,'MORNING','2020-12-31','2020-12-31 00:00:00',NULL,'556',833792.24,834900.54,'556','2021-01-01 10:40:44','556','2021-01-01 10:41:11',10,0),('1','157',170390,'AFTERNOON','2020-12-31','2020-12-31 00:00:00',NULL,'556',1074761.89,1075328.94,'556','2021-01-01 10:47:08','556','2021-01-01 10:47:44',10,0),('1','157',170391,'MORNING','2021-01-01','2021-01-01 00:00:00',NULL,'556',1525193.11,1536648.06,'556','2021-01-02 14:42:46','556','2021-01-02 14:43:20',10,0),('1','157',170596,'AFTERNOON','2021-01-01','2021-01-01 00:00:00',NULL,'556',1195421.78,1195707.48,'556','2021-01-02 15:18:50','556','2021-01-02 15:19:37',10,0),('1','157',170609,'MORNING','2021-01-02','2021-01-02 00:00:00',NULL,'556',795452.29,796308.24,'556','2021-01-02 15:25:52','556','2021-01-02 15:26:24',10,0),('1','157',170612,'AFTERNOON','2021-01-02','2021-01-02 00:00:00',NULL,'556',907863.08,909176.28,'556','2021-01-03 15:09:16','556','2021-01-03 15:10:24',10,0),('1','157',170773,'MORNING','2021-01-03','2021-01-03 00:00:00',NULL,'556',813095.92,813638.82,'556','2021-01-03 15:23:29','556','2021-01-03 15:24:23',10,0),('1','157',170775,'AFTERNOON','2021-01-03','2021-01-03 00:00:00',NULL,'556',745311.86,746757.06,'556','2021-01-04 14:55:56','556','2021-01-04 14:56:20',10,0),('1','157',170933,'MORNING','2021-01-04','2021-01-04 00:00:00',NULL,'556',843885.13,844635.18,'556','2021-01-04 15:02:27','556','2021-01-04 15:02:54',10,0),('1','157',170937,'AFTERNOON','2021-01-04','2021-01-04 00:00:00',NULL,'556',1010356.93,1013797.38,'556','2021-01-05 09:33:35','556','2021-01-05 09:34:02',10,0),('1','157',171084,'MORNING SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'556',851175.87,851791.32,'556','2021-01-06 11:55:06','556','2021-01-06 11:56:32',10,0),('1','157',171280,'AFTERNOON SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'556',1112775.85,1114914.00,'556','2021-01-06 12:01:47','556','2021-01-06 12:03:27',10,0),('1','157',171283,'MORNING SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'556',958725.27,959651.82,'556','2021-01-07 15:39:37','556','2021-01-07 15:40:03',10,0),('1','157',171542,'AFTERNOON SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'556',1227285.27,1227969.72,'556','2021-01-07 15:46:50','556','2021-01-07 15:47:21',10,0),('1','157',171548,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'556',1218287.66,1220114.76,'556','2021-01-07 15:58:33','556','2021-01-07 15:59:00',10,0),('1','157',171552,'AFTERNOON SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'556',1052173.18,1054038.18,'556','2021-01-08 15:33:36','556','2021-01-08 15:34:03',10,0),('1','157',171716,'MORNING SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'556',943743.43,944067.18,'556','2021-01-08 15:40:13','556','2021-01-08 15:40:47',10,0),('1','157',171718,'AFTERNOON SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'556',915779.82,916096.32,'556','2021-01-09 11:50:11','556','2021-01-09 11:50:35',10,0),('1','157',171866,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'556',1199672.64,1199672.64,'556','2021-01-10 11:45:57','556','2021-01-10 11:46:22',10,0),('1','157',171999,'AFTERNOON SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'556',1187311.62,1187311.62,'556','2021-01-10 11:59:24','556','2021-01-10 12:01:59',10,0),('1','157',172004,'MORNING SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'556',828149.76,828149.76,'556','2021-01-10 16:40:26','556','2021-01-10 16:41:41',10,0),('1','157',172061,'AFTERNOON','2021-01-10','2021-01-10 00:00:00',NULL,'556',849063.84,849063.84,'556','2021-01-11 15:45:12','556','2021-01-11 15:45:58',10,0),('1','157',172235,'MORNING SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'556',1211860.14,1211860.14,'556','2021-01-11 16:08:52','556','2021-01-11 16:09:45',10,0),('1','157',172241,'AFTERNOON SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'556',1081694.22,1081694.22,'556','2021-01-12 15:56:52','556','2021-01-12 15:57:20',10,0),('1','157',172439,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'556',1001101.98,1001101.98,'556','2021-01-12 16:12:26','556','2021-01-12 16:12:50',10,0),('1','157',172447,'AFTERNOON SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'556',1021281.24,1023519.29,'556','2021-01-13 12:16:21','556','2021-01-13 12:16:56',10,0),('1','157',172608,'MORNING SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'556',1076329.80,1077114.00,'556','2021-01-13 15:13:42','556','2021-01-13 15:15:47',10,0),('1','157',172655,'AFTERNOON SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'556',1029476.16,1030466.91,'556','2021-01-14 16:00:26','556','2021-01-14 16:01:26',10,0),('1','157',172848,'MORNING','2021-01-14','2021-01-14 00:00:00',NULL,'556',980202.78,981020.28,'556','2021-01-14 16:05:19','556','2021-01-14 16:05:42',10,0),('1','157',173012,'AFTERNOON SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'556',1078843.86,1079320.41,'556','2021-01-15 15:55:47','556','2021-01-15 15:56:16',10,0),('1','157',173021,'MORNING SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'556',987605.40,988746.65,'556','2021-01-15 17:06:28','556','2021-01-15 17:07:56',10,0),('1','157',173113,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'556',1078989.60,1080435.10,'556','2021-01-16 11:25:33','556','2021-01-16 11:26:33',10,0),('1','157',173116,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'556',1098083.52,1099643.22,'556','2021-01-16 17:28:54','556','2021-01-16 17:29:23',10,0),('1','157',173196,'AFTERNOON SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'556',1146907.68,1148643.68,'556','2021-01-17 11:46:45','556','2021-01-17 11:47:15',10,0),('1','157',173279,'MORNING SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'556',906325.68,907330.18,'556','2021-01-17 15:07:11','556','2021-01-17 15:07:41',10,0),('1','157',173319,'AFTERNOON SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'556',793612.68,795684.38,'556','2021-01-18 14:31:54','556','2021-01-18 14:32:33',10,0),('1','157',173530,'MORNING SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'556',1176242.28,1185487.58,'556','2021-01-18 14:37:18','556','2021-01-18 14:37:46',10,0),('1','157',173533,'AFTERNOON SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'556',1277489.82,1289427.52,'556','2021-01-19 19:12:47','556','2021-01-19 19:14:45',10,0),('1','157',173758,'MORNING','2021-01-19','2021-01-19 00:00:00',NULL,'556',1141355.28,1145899.48,'556','2021-01-19 19:24:20','556','2021-01-19 19:25:47',10,0),('1','157',173760,'AFTERNOON','2021-01-19','2021-01-19 00:00:00',NULL,'556',1306143.24,1311765.74,'556','2021-01-20 14:19:53','556','2021-01-20 14:20:41',10,0),('1','157',173890,'MORNING','2021-01-20','2021-01-20 00:00:00',NULL,'556',1200298.44,1208782.84,'556','2021-01-21 06:54:51','556','2021-01-21 06:55:25',10,0),('1','157',173956,'AFTERNOON SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'556',1082682.90,1086466.20,'556','2021-01-21 07:00:58','556','2021-01-21 07:01:26',10,0),('1','157',173957,'MORNING SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'556',427933.38,429879.88,'556','2021-01-21 19:15:11','556','2021-01-21 19:15:46',10,0),('1','157',174125,'AFTERNOON SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'556',44240.70,46347.40,'556','2021-01-21 19:19:16','556','2021-01-21 19:19:43',10,0),('1','157',174286,'MORNING SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'556',1169222.22,1172510.52,'556','2021-01-22 17:05:44','556','2021-01-22 17:06:57',10,0),('1','157',174290,'AFTERNOON SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'556',1090992.42,1092674.22,'556','2021-01-23 16:15:40','556','2021-01-23 16:16:13',10,0),('1','157',174457,'MORNING SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'556',1028050.68,1031609.68,'556','2021-01-23 16:23:16','556','2021-01-23 16:23:39',10,0),('1','157',174458,'AFTERNOON SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'556',985156.14,986825.44,'556','2021-01-24 10:31:59','556','2021-01-24 10:32:30',10,0),('1','157',174522,'MORNING SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'556',1088026.20,1098304.80,'556','2021-01-24 15:28:51','556','2021-01-24 15:29:15',10,0),('1','157',174592,'AFTERNOON SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'556',907010.28,908028.48,'556','2021-01-25 18:14:53','556','2021-01-25 18:15:29',10,0),('1','157',174830,'MORNING SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'556',1018914.90,1021349.90,'556','2021-01-25 18:22:43','556','2021-01-25 18:23:14',10,0),('1','157',174831,'AFTERNOON SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'556',1142832.24,1145524.14,'556','2021-01-26 17:56:44','556','2021-01-26 17:57:23',10,0),('1','157',175024,'MORNING SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'556',1183599.54,1186472.34,'556','2021-01-26 18:02:36','556','2021-01-26 18:03:03',10,0),('1','157',175025,'AFTERNOON SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'556',1197303.90,1206064.80,'556','2021-01-27 15:47:57','556','2021-01-27 15:48:22',10,0),('1','157',175198,'MORNING SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'556',1106219.34,1115929.44,'556','2021-01-27 16:01:17','556','2021-01-27 16:01:53',10,0),('1','157',175202,'AFTERNOON SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'556',1520408.64,1559651.04,'556','2021-01-28 16:15:05','556','2021-01-28 16:15:34',10,0),('1','157',175383,'MORNING SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'556',1407484.92,1438805.52,'556','2021-01-28 16:25:41','556','2021-01-28 16:26:14',10,0),('1','157',175387,'AFTERNOON SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'556',1110247.32,1111934.07,'556','2021-01-29 09:16:13','556','2021-01-29 09:16:50',10,0),('1','157',175457,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'556',1169269.80,1178609.85,'556','2021-01-29 15:52:45','556','2021-01-29 15:53:27',10,0),('1','157',175555,'AFTERNOON SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'556',686205.18,687936.78,'556','2021-01-31 11:20:28','556','2021-01-31 11:20:57',10,0),('1','157',175820,'MORNING SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'556',1291054.38,1305960.48,'556','2021-01-31 11:25:17','556','2021-01-31 11:25:45',10,0),('1','157',175822,'AFTERNOON SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'556',1351640.58,1383382.98,'556','2021-01-31 11:29:12','556','2021-01-31 11:29:34',10,0),('1','157',175825,'MORNING SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'556',1099607.76,1110574.26,'556','2021-01-31 14:25:12','556','2021-01-31 14:25:35',10,0),('1','157',175868,'AFTERNOON SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'556',1120950.42,1137713.22,'556','2021-02-01 08:07:47','556','2021-02-01 08:08:31',10,0),('1','157',175927,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'556',1285651.98,1305062.28,'556','2021-02-01 16:19:18','556','2021-02-01 16:19:44',10,0),('1','157',176104,'AFTERNOON SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'556',1146907.20,1155614.40,'556','2021-02-02 16:30:11','556','2021-02-02 16:30:42',10,0),('1','157',176293,'MORNING SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'556',1084631.76,1092283.11,'556','2021-02-02 16:35:42','556','2021-02-02 16:36:06',10,0),('1','157',176294,'AFTERNOON SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'556',1304971.20,1308029.85,'556','2021-02-03 15:32:36','556','2021-02-03 15:33:00',10,0),('1','157',176492,'MORNING SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'556',1381686.60,1399018.05,'556','2021-02-03 15:44:14','556','2021-02-03 15:45:45',10,0),('1','157',176495,'AFTERNOON SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'556',799181.64,799181.64,'556','2021-02-04 18:18:23','556','2021-02-04 18:18:52',10,0),('1','157',176765,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'556',203237.10,203237.10,'556','2021-02-05 10:46:36','556','2021-02-05 10:47:44',10,0),('1','157',176843,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',176948,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'556',1459500.00,1486423.35,'556','2021-02-05 20:00:48','556','2021-02-05 20:01:48',10,0),('1','157',177173,'AFTERNOON SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'556',1135327.92,1136307.87,'556','2021-02-06 16:28:37','556','2021-02-06 16:29:33',10,0),('1','157',177179,'MORNING SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'556',1230876.24,1253245.84,'556','2021-02-06 16:42:14','556','2021-02-06 16:43:03',10,0),('1','157',177182,'AFTERNOON SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'556',1631352.48,1685503.48,'556','2021-02-08 15:13:01','556','2021-02-08 15:13:24',10,0),('1','157',177572,'MORNING SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'556',1060110.00,1073788.80,'556','2021-02-08 15:26:04','556','2021-02-08 15:26:56',10,0),('1','157',177575,'AFTERNOON SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'556',860661.48,861740.48,'556','2021-02-08 15:32:58','556','2021-02-08 15:33:40',10,0),('1','157',177581,'MORNING SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'556',1128838.56,1135198.36,'556','2021-02-08 16:08:10','556','2021-02-08 16:08:38',10,0),('1','157',177583,'AFTERNOON SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'556',1745062.20,1801806.00,'556','2021-02-10 06:21:36','556','2021-02-10 06:22:03',10,0),('1','157',177881,'MORNING SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'556',1346999.64,1368483.04,'556','2021-02-10 06:26:28','556','2021-02-10 06:27:10',10,0),('1','157',177883,'AFTERNOON SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'556',1492220.52,1529389.92,'556','2021-02-10 06:31:30','556','2021-02-10 06:32:02',10,0),('1','157',177884,'MORNING SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'556',1421342.88,1454107.48,'556','2021-02-11 06:19:20','556','2021-02-11 06:19:44',10,0),('1','157',178076,'AFTERNOON SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'556',1222088.28,1224270.88,'556','2021-02-12 08:50:45','556','2021-02-12 08:51:13',10,0),('1','157',178316,'AFTERNOON SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'556',1270306.35,1274008.40,'556','2021-02-12 08:56:39','556','2021-02-12 08:57:14',10,0),('1','157',178322,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'556',1378987.65,1397553.65,'556','2021-02-13 07:29:01','556','2021-02-13 07:29:33',10,0),('1','157',178498,'AFTERNOON SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'556',1010839.96,1012278.36,'556','2021-02-13 07:50:17','556','2021-02-13 07:50:51',10,0),('1','157',178508,'MORNING SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'556',1381324.29,1391792.89,'556','2021-02-14 16:31:01','556','2021-02-14 16:31:31',10,0),('1','157',178856,'AFTERNOON SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'556',1166042.51,1182859.51,'556','2021-02-14 16:43:01','556','2021-02-14 16:43:54',10,0),('1','157',178857,'MORNING SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'556',1269540.74,1285870.54,'556','2021-02-14 16:53:56','556','2021-02-14 16:54:31',10,0),('1','157',178861,'AFTERNOON SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'556',1081308.74,1088713.04,'556','2021-02-15 17:14:46','556','2021-02-15 17:15:15',10,0),('1','157',179091,'MORNING SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'556',1187249.45,1192214.35,'556','2021-02-15 17:20:29','556','2021-02-15 17:20:59',10,0),('1','157',179092,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'556',1077956.92,1089050.62,'556','2021-02-16 11:17:01','556','2021-02-16 11:17:32',10,0),('1','157',179244,'MORNING SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'556',1372994.15,1388853.80,'556','2021-02-16 16:06:39','556','2021-02-16 16:07:21',10,0),('1','157',179328,'AFTERNOON SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'556',1001851.31,1005349.91,'556','2021-02-17 07:10:56','556','2021-02-17 07:11:33',10,0),('1','157',179543,'MORNING SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'556',1253967.55,1272266.50,'556','2021-02-18 08:55:12','556','2021-02-18 08:56:02',10,0),('1','157',179603,'AFTERNOON SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'556',1305188.08,1320878.23,'556','2021-02-18 09:11:19','556','2021-02-18 09:12:13',10,0),('1','157',179829,'MORNING SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'556',1247032.05,1280772.00,'556','2021-02-19 10:21:57','556','2021-02-19 10:22:23',10,0),('1','157',179830,'MORNING SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'556',1605610.64,1652567.84,'556','2021-02-19 16:55:42','556','2021-02-19 16:56:16',10,0),('1','157',179961,'AFTERNOON SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'556',1196246.36,1199654.36,'556','2021-02-20 07:20:14','556','2021-02-20 07:20:40',10,0),('1','157',179996,'MORNING SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'556',1150460.03,1157099.23,'556','2021-02-21 14:08:14','556','2021-02-21 14:08:50',10,0),('1','157',180267,'AFTERNOON SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'556',1076153.11,1091372.91,'556','2021-02-21 14:23:06','556','2021-02-21 14:23:46',10,0),('1','157',180268,'MORNING SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'556',774356.36,776568.56,'556','2021-02-21 14:31:19','556','2021-02-21 14:31:55',10,0),('1','157',180272,'AFTERNOON SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'556',720567.96,722346.36,'556','2021-02-22 14:22:23','556','2021-02-22 14:22:48',10,0),('1','157',180484,'MORNING SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'556',1237033.69,1272977.49,'556','2021-02-22 19:21:49','556','2021-02-22 19:22:49',10,0),('1','157',180894,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',180895,'MORNING SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'556',396441.00,431680.20,'556','2021-02-24 15:07:15','556','2021-02-24 15:08:06',10,0),('1','157',180898,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'556',1145971.83,1195824.33,'556','2021-02-24 15:11:20','556','2021-02-24 15:11:46',10,0),('1','157',180899,'AFTERNOON SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'556',932752.34,938932.34,'556','2021-02-25 08:14:39','556','2021-02-25 08:15:03',10,0),('1','157',180975,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'556',989909.56,997773.31,'556','2021-02-26 10:16:33','556','2021-02-26 10:17:12',10,0),('1','157',181189,'AFTERNOON SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'556',710318.53,735053.28,'556','2021-02-26 10:21:17','556','2021-02-26 10:21:58',10,0),('1','157',181191,'MORNING SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',181554,'FULL DAY','2021-02-26','2021-02-26 00:00:00',NULL,'556',1021970.21,1062254.81,'556','2021-02-28 09:57:49','556','2021-02-28 09:58:15',10,0),('1','157',181555,'MORNING SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'556',1365532.88,1402870.58,'556','2021-02-28 10:01:33','556','2021-02-28 10:01:59',10,0),('1','157',181557,'AFTERNOON SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'556',715380.92,718266.02,'556','2021-02-28 10:12:51','556','2021-02-28 10:13:15',10,0),('1','157',182078,'FULL DAY','2021-03-01','2021-03-01 00:00:00',NULL,'556',590238.50,638901.50,'556','2021-03-02 16:56:41','556','2021-03-02 16:57:05',10,0),('1','157',182079,'MORNING SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'556',2349327.91,2401558.21,'556','2021-03-02 17:06:55','556','2021-03-02 17:07:20',10,0),('1','157',182085,'AFTERNOON SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'556',1080931.16,1101543.26,'556','2021-03-03 08:50:25','556','2021-03-03 08:50:47',10,0),('1','157',182632,'FULL DAY','2021-03-03','2021-03-03 00:00:00',NULL,'556',2254447.22,2333187.62,'556','2021-03-05 15:51:05','556','2021-03-05 15:52:03',10,0),('1','157',182633,'FULL DAY','2021-03-04','2021-03-04 00:00:00',NULL,'556',621237.23,677745.23,'556','2021-03-05 15:55:10','556','2021-03-05 15:55:49',10,0),('1','157',182891,'MORNING SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'556',881255.92,930452.32,'556','2021-03-07 12:18:34','556','2021-03-07 12:19:00',10,0),('1','157',182893,'AFTERNOON SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'556',908515.87,911139.67,'556','2021-03-07 12:22:21','556','2021-03-07 12:22:45',10,0),('1','157',182966,'MORNING SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'556',960701.67,981995.67,'556','2021-03-07 18:02:09','556','2021-03-07 18:02:34',10,0),('1','157',183135,'AFTERNOON SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'556',726284.34,727225.44,'556','2021-03-08 15:19:56','556','2021-03-08 15:21:03',10,0),('1','157',183138,'MORNING SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'556',1351704.21,1403315.31,'556','2021-03-08 15:26:14','556','2021-03-08 15:26:54',10,0),('1','157',183142,'AFTERNOON SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'556',992897.73,999671.73,'556','2021-03-10 10:17:58','556','2021-03-10 10:18:27',10,0),('1','157',183490,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'556',1205623.94,1245077.24,'556','2021-03-10 10:30:24','556','2021-03-10 10:31:01',10,0),('1','157',183496,'AFTERNOON SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'556',890071.75,896305.15,'556','2021-03-10 10:36:46','556','2021-03-10 10:37:28',10,0),('1','157',183683,'MORNING SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',183686,'MORNING SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'556',1456525.61,1526040.11,'556','2021-03-11 09:23:41','556','2021-03-11 09:24:12',10,0),('1','157',183690,'AFTERNOON SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'556',1278426.01,1323117.01,'556','2021-03-11 09:30:48','556','2021-03-11 09:31:24',10,0),('1','157',183709,'MORNING SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',183948,'FULL DAY','2021-03-11','2021-03-11 00:00:00',NULL,'556',1397260.15,1397260.15,'556','2021-03-12 10:05:57','556','2021-03-12 10:06:33',10,0),('1','157',184181,'FULL DAY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'556',1141575.96,1172681.56,'556','2021-03-13 15:25:08','556','2021-03-13 15:26:01',10,0),('1','157',184186,'FULL DAY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',184416,'MORNING SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'556',2211725.23,2241271.65,'556','2021-03-14 16:55:10','556','2021-03-14 16:55:41',10,0),('1','157',184420,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'556',671652.96,680668.00,'556','2021-03-14 17:02:33','556','2021-03-14 17:02:58',10,0),('1','157',184421,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'556',1622706.54,1653402.10,'556','2021-03-14 17:11:19','556','2021-03-14 17:12:39',10,0),('1','157',184424,'AFTERNOON SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'556',1096117.26,1116614.10,'556','2021-03-16 09:22:16','556','2021-03-16 09:22:46',10,0),('1','157',184740,'MORNING SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'556',941244.15,945889.45,'556','2021-03-16 10:01:28','556','2021-03-16 10:01:51',10,0),('1','157',184755,'AFTERNOON SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'556',1100348.70,1108155.40,'556','2021-03-16 10:06:53','556','2021-03-16 10:07:16',10,0),('1','157',185060,'MORNING SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'556',1239523.20,1251856.80,'556','2021-03-17 16:48:39','556','2021-03-17 16:49:01',10,0),('1','157',185066,'AFTERNOON SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'556',1387851.30,1405082.80,'556','2021-03-17 16:56:47','556','2021-03-17 16:57:24',10,0),('1','157',185070,'MORNING SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'556',870621.60,880455.50,'556','2021-03-17 17:01:23','556','2021-03-17 17:02:17',10,0),('1','157',185071,'AFTERNOON SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'556',804109.65,807115.25,'556','2021-03-18 07:15:21','556','2021-03-18 07:15:56',10,0),('1','157',185287,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'556',827918.25,836623.95,'556','2021-03-19 09:01:09','525','2021-03-19 10:00:01',10,0),('1','157',185488,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',185489,'MORNING SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'556',231075.90,231075.90,'556','2021-03-20 08:13:01','525','2021-03-20 08:43:08',10,0),('1','157',185499,'AFTERNOON SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'556',787606.05,778059.31,'556','2021-03-20 08:49:17','525','2021-03-20 12:12:44',10,0),('1','157',185583,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'556',754139.10,744998.02,'556','2021-03-20 15:14:54','525','2021-03-20 17:58:29',10,0),('1','157',185766,'AFTERNOON SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'556',1158990.31,1158990.31,'556','2021-03-21 12:26:14','525','2021-03-21 14:19:45',10,0),('1','157',185800,'MORNING SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'556',948570.35,948570.35,'556','2021-03-21 14:53:24','525','2021-03-21 16:01:18',10,0),('1','157',185884,'AFTERNOON SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'556',1217222.06,1217222.06,'556','2021-03-22 06:55:57','525','2021-03-22 11:12:36',10,0),('1','157',185997,'MORNING SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'556',640643.79,640643.79,'556','2021-03-22 14:31:43','525','2021-03-22 16:08:10',10,0),('1','157',186201,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'556',1017983.90,1017983.90,'556','2021-03-23 17:22:47','525','2021-03-23 18:20:20',10,0),('1','157',186407,'AFTERNOON SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'556',1365493.38,1365493.38,'556','2021-03-24 11:14:02','525','2021-03-24 11:18:30',10,0),('1','157',186457,'MORNING SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'556',948053.64,948053.64,'556','2021-03-24 15:20:42','525','2021-03-24 16:59:55',10,0),('1','157',186560,'AFTERNOON SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'556',1001129.70,1001129.70,'556','2021-03-25 08:34:23','525','2021-03-25 14:05:19',10,0),('1','157',186685,'MORNING SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'556',880954.69,880954.69,'556','2021-03-25 15:36:17','525','2021-03-25 16:21:19',10,0),('1','157',186736,'AFTERNOON SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'556',903057.49,903057.49,'556','2021-03-25 23:42:04','525','2021-03-26 08:21:59',10,0),('1','157',186786,'MORNING SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'556',1061607.59,1061607.59,'556','2021-03-26 15:49:26','525','2021-03-26 15:59:17',10,0),('1','157',186918,'AFTERNOON SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'556',1209246.47,1209246.47,'556','2021-03-27 10:15:26','525','2021-03-27 16:04:14',10,0),('1','157',187148,'MORNING SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'556',1300772.60,1300772.60,'556','2021-03-28 04:47:13','525','2021-03-28 07:53:35',10,0),('1','157',187216,'AFTERNOON SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'556',1212284.79,1212284.79,'556','2021-03-28 16:50:19','525','2021-03-28 16:51:42',10,0),('1','157',187297,'MORNING SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'556',956627.44,956627.44,'556','2021-03-28 16:58:23','525','2021-03-28 18:06:55',10,0),('1','157',187391,'AFTERNOON SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'556',1254839.20,1254839.20,'556','2021-03-29 08:39:45','525','2021-03-29 12:29:48',10,0),('1','157',187615,'MORNING SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'556',1803123.93,1803123.93,'556','2021-03-30 08:17:33','525','2021-03-30 12:01:53',10,0),('1','157',187697,'AFTERNOON SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'556',1821422.31,1821422.31,'556','2021-03-30 12:31:56','525','2021-03-30 13:10:52',10,0),('1','157',187775,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'556',343641.49,343641.49,'556','2021-03-30 19:00:18','525','2021-03-30 21:20:27',10,0),('1','157',187868,'AFTERNOON SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'556',1012212.07,1012212.07,'556','2021-03-31 10:00:06','525','2021-03-31 10:18:18',10,0),('1','157',187954,'MORNING SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'556',1076049.39,1076049.39,'556','2021-03-31 15:36:46','525','2021-03-31 16:17:15',10,0),('1','157',187997,'AFTERNOON SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'556',1059811.33,1059811.33,'556','2021-03-31 23:52:20','525','2021-04-01 08:04:34',10,0),('1','157',188048,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'556',1038314.89,1038314.89,'556','2021-04-01 16:08:10','525','2021-04-01 19:57:16',10,0),('1','157',188230,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'556',926014.41,926014.41,'556','2021-04-02 07:11:12','525','2021-04-02 14:02:47',10,0),('1','157',188329,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'556',954876.82,954876.82,'556','2021-04-02 14:37:03','525','2021-04-02 15:21:25',10,0),('1','157',188436,'AFTERNOON SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'556',864547.11,864547.11,'556','2021-04-03 07:13:01','525','2021-04-03 10:19:09',10,0),('1','157',188565,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'556',1045069.61,1045069.61,'556','2021-04-03 17:51:42','525','2021-04-03 18:26:17',10,0),('1','157',188658,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'556',922804.94,922804.94,'556','2021-04-04 09:52:17','525','2021-04-04 18:17:04',10,0),('1','157',188791,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'556',1514975.79,1514975.79,'556','2021-04-05 00:01:57','525','2021-04-05 06:48:37',10,0),('1','157',188840,'AFTERNOON SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'556',1228619.02,1228619.02,'556','2021-04-05 08:34:06','525','2021-04-05 13:10:19',10,0),('1','157',188945,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'556',861937.48,861937.48,'556','2021-04-05 16:06:58','525','2021-04-05 16:08:59',10,0),('1','157',189142,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'556',379817.71,379817.71,'556','2021-04-06 16:42:38','525','2021-04-06 16:49:49',10,0),('1','157',189248,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'556',370047.49,370047.49,'556','2021-04-07 08:51:42','525','2021-04-07 09:02:51',10,0),('1','157',189256,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'556',1022340.89,1022340.89,'556','2021-04-07 09:17:27','525','2021-04-07 15:00:25',10,0),('1','157',189372,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'556',1003882.77,1003882.77,'556','2021-04-07 17:56:13','525','2021-04-07 18:16:27',10,0),('1','157',189467,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'556',944167.72,944167.72,'556','2021-04-08 09:15:22','525','2021-04-08 10:11:49',10,0),('1','157',189630,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'556',945799.35,945799.35,'556','2021-04-09 07:11:17','525','2021-04-09 08:36:05',10,0),('1','157',189669,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'556',390627.87,390627.87,'556','2021-04-09 09:26:23','525','2021-04-09 13:50:12',10,0),('1','157',190360,'MORNING SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'556',1390104.75,1390104.75,'556','2021-04-12 15:19:59','525','2021-04-12 18:21:52',10,0),('1','157',190426,'AFTERNOON SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'556',1228389.61,1228389.61,'556','2021-04-13 05:53:57','525','2021-04-13 11:10:50',10,0),('1','157',190655,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'556',1553738.28,1567861.10,'556','2021-04-13 23:50:06','525','2021-04-14 06:42:56',10,0),('1','157',190725,'AFTERNOON SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'556',1225362.79,1235498.05,'556','2021-04-14 10:16:29','525','2021-04-14 10:53:11',10,0),('1','157',190871,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'556',1309715.44,1321825.20,'556','2021-04-14 22:45:39','525','2021-04-15 06:09:31',10,0),('1','157',190923,'AFTERNOON SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'556',820336.66,830141.40,'556','2021-04-15 08:38:04','525','2021-04-15 10:43:22',10,0),('1','157',191063,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'556',1221374.62,1233320.40,'556','2021-04-16 04:28:40','525','2021-04-16 08:00:52',10,0),('1','157',191148,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'556',946978.96,956449.20,'556','2021-04-16 22:23:27','525','2021-04-17 08:02:30',10,0),('1','157',191400,'FULL DAY','2021-04-16','2021-04-16 00:00:00',NULL,'556',544851.52,549671.80,'556','2021-04-17 13:09:04','525','2021-04-17 14:57:10',10,0),('1','157',191692,'FULL DAY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'556',2377426.94,2392907.50,'556','2021-04-18 23:04:03','525','2021-04-19 07:49:36',10,0),('1','157',191950,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'556',1213532.23,1226533.25,'556','2021-04-20 07:25:42','525','2021-04-20 12:39:05',10,0),('1','157',192318,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'556',1705821.25,1705821.25,'556','2021-04-21 21:14:51','525','2021-04-21 21:22:50',10,0),('1','157',192320,'FULL DAY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'556',1788605.25,1788605.25,'556','2021-04-21 21:35:04','525','2021-04-22 08:45:57',10,0),('1','157',192449,'FULL DAY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'556',2927012.30,2927012.30,'556','2021-04-22 11:53:59','525','2021-04-22 13:47:46',10,0),('1','157',192903,'FULL DAY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'556',1452422.95,1452422.95,'556','2021-04-24 16:42:00','525','2021-04-24 19:37:18',10,0),('1','157',192940,'FULL DAY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'556',526402.50,526402.50,'556','2021-04-24 21:47:25','525','2021-04-25 09:43:03',10,0),('1','157',193505,'FULL DAY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',193506,'FULL DAY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'556',583251.75,583251.75,'556','2021-04-27 12:09:10','525','2021-04-27 16:38:45',10,0),('1','157',193583,'FULL DAY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'556',443670.95,443670.95,'556','2021-04-27 16:51:38','525','2021-04-28 09:06:25',10,0),('1','157',193794,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'556',1000009.75,1000009.75,'556','2021-04-28 15:57:49','525','2021-04-28 16:09:18',10,0),('1','157',193805,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'556',1009829.00,1009829.00,'556','2021-04-28 16:16:16','525','2021-04-28 17:26:02',10,0),('1','157',193864,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'556',809917.90,809917.90,'556','2021-04-29 06:53:36','525','2021-04-29 09:10:30',10,0),('1','157',193940,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'556',814487.90,814487.90,'556','2021-04-29 10:40:06','525','2021-04-29 15:29:15',10,0),('1','157',194179,'FULL DAY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'556',1433167.55,1433167.55,'556','2021-04-30 11:46:34','525','2021-04-30 13:07:00',10,0),('1','157',194377,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'556',720886.65,720886.65,'556','2021-05-01 14:50:08','525','2021-05-01 14:54:38',10,0),('1','157',194422,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'556',896407.05,896407.05,'556','2021-05-01 15:07:09','525','2021-05-01 15:13:29',10,0),('1','157',194425,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'556',990920.70,990920.70,'556','2021-05-01 15:19:27','525','2021-05-01 15:34:48',10,0),('1','157',194434,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'556',896865.75,896865.75,'556','2021-05-02 10:30:28','525','2021-05-02 16:44:20',10,0),('1','157',194767,'FULL DAY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',194768,'FULL DAY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'556',949749.90,949749.90,'556','2021-05-03 10:53:06','525','2021-05-03 11:19:43',10,0),('1','157',195174,'FULL DAY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'556',417270.15,417270.15,'556','2021-05-05 11:04:57','525','2021-05-05 15:02:23',10,0),('1','157',195354,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'556',438391.80,438391.80,'556','2021-05-06 15:52:03','525','2021-05-06 17:30:18',10,0),('1','157',195510,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'556',630479.85,630479.85,'556','2021-05-07 05:26:41','525','2021-05-07 13:22:59',10,0),('1','157',195729,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'556',688731.45,688731.45,'556','2021-05-07 16:53:30','525','2021-05-07 18:02:53',10,0),('1','157',195807,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'556',615384.00,615384.00,'556','2021-05-08 08:32:21','525','2021-05-08 16:52:06',10,0),('1','157',195953,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'556',792445.50,792445.50,'556','2021-05-08 17:22:48','525','2021-05-08 17:31:44',10,0),('1','157',196026,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'556',736607.85,736607.85,'556','2021-05-09 08:04:44','525','2021-05-09 13:56:01',10,0),('1','157',196133,'MORNING SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'556',744603.75,744603.75,'556','2021-05-09 14:16:36','525','2021-05-09 20:18:52',10,0),('1','157',196201,'AFTERNOON ONE SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',196203,'AFTERNOON ONE','2021-05-09','2021-05-09 00:00:00',NULL,'556',486271.50,486271.50,'556','2021-05-10 09:07:57','525','2021-05-10 09:12:01',10,0),('1','157',196292,'AFTERNOON TWO','2021-05-09','2021-05-09 00:00:00',NULL,'556',202928.48,202928.48,'556','2021-05-10 09:22:30','525','2021-05-10 09:29:20',10,0),('1','157',196307,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'556',811179.28,811179.28,'556','2021-05-11 06:34:55','525','2021-05-11 06:55:19',10,0),('1','157',196462,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'556',728815.38,728815.38,'556','2021-05-11 06:59:34','525','2021-05-11 07:00:33',10,0),('1','157',196471,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'556',929346.13,929346.13,'556','2021-05-11 14:39:37','454','2021-05-12 12:48:19',10,0),('1','157',196767,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'556',862124.93,862124.93,'556','2021-05-12 13:05:46','454','2021-05-12 13:20:30',10,0),('1','157',196777,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'556',790760.27,790760.27,'556','2021-05-12 14:23:44','454','2021-05-17 11:43:55',10,0),('1','157',197664,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'556',659183.41,659183.41,'556','2021-05-17 11:49:57','454','2021-05-17 12:39:11',10,0),('1','157',197707,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'556',678582.04,678582.04,'556','2021-05-17 13:29:54','454','2021-05-17 15:38:47',10,0),('1','157',197790,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'556',555461.62,555461.62,'556','2021-05-17 16:24:51','454','2021-05-18 08:32:40',10,0),('1','157',197916,'FULL DAY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'556',1501753.23,1501753.23,'556','2021-05-18 08:53:39','454','2021-05-18 09:06:17',10,0),('1','157',197931,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'556',775573.56,775573.56,'556','2021-05-18 09:10:22','454','2021-05-18 09:17:31',10,0),('1','157',197935,'AFTERNOON SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'556',620519.81,620519.81,'556','2021-05-18 09:33:07','454','2021-05-18 09:35:28',10,0),('1','157',197945,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'556',513630.93,513630.93,'556','2021-05-18 09:40:11','454','2021-05-18 09:49:42',10,0),('1','157',197955,'AFTERNOON SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'556',619426.08,619426.08,'556','2021-05-18 09:56:11','454','2021-05-18 15:21:39',10,0),('1','157',198072,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'556',753835.88,753835.88,'556','2021-05-18 16:59:25','454','2021-05-18 17:35:42',10,0),('1','157',198081,'AFTERNOON SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'556',763146.44,763146.44,'556','2021-05-18 18:17:50','454','2021-05-18 18:23:39',10,0),('1','157',198087,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'556',749627.22,749627.22,'556','2021-05-18 18:45:08','454','2021-05-18 19:02:04',10,0),('1','157',198196,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'556',849353.88,849353.88,'556','2021-05-19 10:41:05','454','2021-05-19 15:50:18',10,0),('1','157',198377,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'556',837011.52,837011.52,'556','2021-05-20 07:44:32','454','2021-05-20 08:22:08',10,0),('1','157',198389,'AFTERNOON SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'556',826269.82,826269.82,'556','2021-05-20 08:31:05','454','2021-05-21 10:22:08',10,0),('1','157',198662,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'556',752039.62,752039.62,'556','2021-05-21 11:10:29','454','2021-05-21 11:12:07',10,0),('1','157',198665,'AFTERNOON SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'556',699566.66,699566.66,'556','2021-05-21 11:16:38','454','2021-05-22 08:34:07',10,0),('1','157',198821,'FULL DAY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'556',662474.38,662474.38,'556','2021-05-22 08:41:23','454','2021-05-22 15:42:47',10,0),('1','157',198939,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'556',1382282.43,1382282.43,'556','2021-05-22 16:37:34','454','2021-05-23 11:28:48',10,0),('1','157',199084,'AFTERNOON SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'556',758794.28,758794.28,'556','2021-05-23 11:40:45','454','2021-05-24 10:47:56',10,0),('1','157',199355,'MORNING SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'556',1013253.78,1013253.78,'556','2021-05-24 13:43:36','454','2021-05-24 13:53:10',10,0),('1','157',199363,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'556',783038.98,783038.98,'556','2021-05-24 14:01:31','454','2021-05-24 14:18:56',10,0),('1','157',199680,'FULL DAY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'556',532377.05,532377.05,'556','2021-05-26 09:04:45','454','2021-05-26 09:34:47',10,0),('1','157',199738,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'556',1198074.03,1198074.03,'556','2021-06-09 18:35:03','611','2021-06-10 08:52:48',10,0),('1','157',202921,'AFTERNOON SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'556',1867573.61,1854258.21,'556','2021-06-10 09:07:54','611','2021-06-10 09:43:12',10,0),('1','157',202943,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'556',1055086.75,1050062.20,'556','2021-06-10 10:19:15','611','2021-06-10 10:48:55',10,0),('1','157',202961,'AFTERNOON SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'556',802006.70,801551.85,'556','2021-06-10 11:41:32','611','2021-06-10 11:43:57',10,0),('1','157',202962,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'556',1671608.45,1662904.20,'556','2021-06-10 11:47:27','611','2021-06-10 11:52:27',10,0),('1','157',202965,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'556',1194635.97,1194635.97,'556','2021-06-10 12:00:33','611','2021-06-10 12:02:50',10,0),('1','157',202967,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'556',1250101.79,1250101.79,'556','2021-06-10 12:07:25','611','2021-06-10 12:08:21',10,0),('1','157',202970,'AFTERNOON SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'556',984718.98,984718.98,'556','2021-06-10 12:13:53','611','2021-06-10 12:17:00',10,0),('1','157',202973,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'556',1549497.23,1549497.23,'556','2021-06-10 12:23:49','611','2021-06-10 12:25:06',10,0),('1','157',202979,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'556',1244928.35,1244928.35,'556','2021-06-10 12:30:50','611','2021-06-10 12:34:49',10,0),('1','157',202981,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'556',762386.98,762386.98,'556','2021-06-10 12:38:40','611','2021-06-10 12:41:33',10,0),('1','157',202984,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'556',628921.04,628921.04,'556','2021-06-10 12:48:02','611','2021-06-10 12:49:22',10,0),('1','157',202987,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'556',973917.06,973917.06,'556','2021-06-10 13:00:17','611','2021-06-10 13:01:40',10,0),('1','157',202993,'AFTERNOON SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'556',1584939.89,1584939.89,'556','2021-06-10 13:17:44','611','2021-06-10 15:35:45',10,0),('1','157',203050,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'556',1302531.49,1302531.49,'556','2021-06-10 16:04:44','611','2021-06-12 13:46:29',10,0),('1','157',203436,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'556',1278915.84,1278915.84,'556','2021-06-12 13:50:44','611','2021-06-12 13:52:14',10,0),('1','157',203437,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'556',1409396.33,1409396.33,'556','2021-06-12 13:56:42','611','2021-06-12 13:58:31',10,0),('1','157',203439,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'556',1263117.76,1263117.76,'556','2021-06-12 14:03:36','611','2021-06-12 14:07:59',10,0),('1','157',203443,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'556',889430.41,889430.41,'556','2021-06-12 14:19:54','611','2021-06-12 14:21:18',10,0),('1','157',203446,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'556',1056438.16,1056438.16,'556','2021-06-12 14:26:06','611','2021-06-12 14:35:46',10,0),('1','157',203453,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'556',1047577.39,1047577.39,'556','2021-06-12 14:51:08','611','2021-06-12 14:52:22',10,0),('1','157',203456,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'556',1356079.80,1356079.80,'556','2021-06-12 15:19:57','454','2021-06-12 15:25:22',10,0),('1','157',203461,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'556',1206644.38,1206644.38,'556','2021-06-12 15:32:18','454','2021-06-12 15:33:20',10,0),('1','157',203463,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'556',1430633.85,1430633.85,'556','2021-06-12 15:39:41','454','2021-06-12 15:54:41',10,0),('1','157',203469,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'556',751356.16,751356.16,'556','2021-06-12 16:03:35','454','2021-06-12 16:05:40',10,0),('1','157',203471,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'556',1160379.33,1160379.33,'556','2021-06-12 16:09:32','454','2021-06-12 16:10:28',10,0),('1','157',203473,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'556',1052759.19,1052759.19,'556','2021-06-12 16:18:44','611','2021-06-12 20:33:14',10,0),('1','157',203500,'AFTERNOON SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'556',1414546.66,1414546.66,'556','2021-06-12 20:46:01','611','2021-06-12 20:51:42',10,0),('1','157',203501,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'556',1084533.67,1084533.67,'556','2021-06-12 20:55:37','611','2021-06-12 20:58:10',10,0),('1','157',203502,'AFTERNOON SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'556',1160103.95,1160103.95,'556','2021-06-12 21:06:06','611','2021-06-12 21:09:32',10,0),('1','157',203503,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'556',1151612.98,1151612.98,'556','2021-06-12 21:19:38','611','2021-06-12 21:21:49',10,0),('1','157',203504,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'556',1170588.51,1170588.51,'556','2021-06-12 21:30:54','611','2021-06-13 03:08:48',10,0),('1','157',203584,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'556',1118158.93,1118158.93,'556','2021-06-13 09:26:42','611','2021-06-13 23:17:55',10,0),('1','157',203837,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'556',1342659.10,1329298.82,'556','2021-06-14 12:30:07','454','2021-06-14 12:44:59',10,0),('1','157',203854,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'556',959276.20,949418.04,'556','2021-06-17 09:22:43','454','2021-06-17 09:25:39',10,0),('1','157',204466,'AFTERNOON SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'556',1066974.95,1055093.77,'556','2021-06-17 09:37:47','454','2021-06-17 10:13:06',10,0),('1','157',204486,'MORNING SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'556',1254510.60,1245249.88,'556','2021-06-17 10:28:16','454','2021-06-17 10:30:38',10,0),('1','157',204489,'AFTERNOON SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'556',744607.55,744607.55,'556','2021-06-17 10:39:00','454','2021-06-17 10:40:28',10,0),('1','157',204491,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'556',890372.05,890372.05,'556','2021-06-17 10:53:44','454','2021-06-17 11:27:00',10,0),('1','157',204502,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'556',840362.90,840362.90,'556','2021-06-17 11:35:41','454','2021-06-17 11:36:52',10,0),('1','157',204503,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'556',1190058.65,1190058.65,'556','2021-06-17 11:49:27','454','2021-06-17 11:49:43',10,0),('1','157',204507,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'556',1090515.40,1090515.40,'556','2021-06-17 11:52:49','454','2021-06-17 12:09:52',10,0),('1','157',204510,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'556',1338475.70,1338475.70,'556','2021-06-17 12:13:43','454','2021-06-17 12:14:20',10,0),('1','157',204511,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'556',936390.50,936390.50,'556','2021-06-17 12:17:19','454','2021-06-17 12:50:58',10,0),('1','157',204517,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'556',1139984.40,1139984.40,'556','2021-06-17 13:01:02','454','2021-06-17 13:02:39',10,0),('1','157',204520,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'556',1075548.05,1075548.05,'556','2021-06-17 13:14:25','454','2021-06-17 13:16:54',10,0),('1','157',204968,'FULL DAY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'556',1586726.80,1586726.80,'556','2021-06-19 13:34:21','611','2021-06-19 23:22:38',10,0),('1','157',205314,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'556',811532.75,811532.75,'556','2021-06-21 10:30:17','454','2021-06-21 11:25:05',10,0),('1','157',205383,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'556',841452.35,841452.35,'556','2021-06-21 14:35:23','454','2021-06-21 15:22:12',10,0),('1','157',205412,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'556',1096005.36,1096005.36,'556','2021-06-21 16:25:39','454','2021-06-21 16:35:45',10,0),('1','157',205420,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'556',1501011.09,1501011.09,'556','2021-06-22 13:46:30','454','2021-06-22 13:49:32',10,0),('1','157',205625,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'556',888087.41,888087.41,'556','2021-06-22 14:01:00','454','2021-06-22 14:02:01',10,0),('1','157',205632,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'556',941745.67,941745.67,'556','2021-06-22 14:06:17','454','2021-06-22 14:06:59',10,0),('1','157',205637,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'556',1396457.26,1396457.26,'556','2021-06-22 14:10:52','454','2021-06-22 14:12:15',10,0),('1','157',205645,'AFTERNOON SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'556',5007764.64,5007764.64,'556','2021-06-22 14:16:58','454','2021-06-22 14:18:02',10,0),('1','157',205789,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'556',974994.28,974994.28,'556','2021-06-23 09:44:14','454','2021-06-23 13:24:14',10,0),('1','157',205875,'AFTERNOON SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'556',1339414.03,1339414.03,'556','2021-06-23 14:24:52','611','2021-06-23 16:06:33',10,0),('1','157',205894,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'556',1055490.31,1055490.31,'556','2021-06-23 16:11:21','611','2021-06-24 16:20:10',10,0),('1','157',206096,'AFTERNOON SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'556',1495385.21,1495385.21,'556','2021-06-24 16:28:54','611','2021-06-24 16:39:40',10,0),('1','157',206102,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'556',1097917.02,1097917.02,'556','2021-06-26 10:37:25','611','2021-06-26 11:13:07',10,0),('1','157',206447,'AFTERNOON SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'556',844518.05,844518.05,'556','2021-06-26 11:29:29','611','2021-06-26 11:32:58',10,0),('1','157',206457,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'556',817581.92,817581.92,'556','2021-06-26 11:45:39','611','2021-06-26 12:01:40',10,0),('1','157',206465,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'556',674521.71,674521.71,'556','2021-06-26 12:10:08','611','2021-06-26 12:55:02',10,0),('1','157',206494,'MORNING SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'556',816436.03,816436.03,'556','2021-06-26 14:07:26','611','2021-06-27 08:20:13',10,0),('1','157',206689,'AFTERNOON SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'556',1105281.81,1105281.81,'556','2021-06-27 13:18:46','611','2021-06-27 18:30:37',10,0),('1','157',206944,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'556',845146.85,845146.85,'556','2021-06-28 13:42:18','611','2021-06-28 13:45:37',10,0),('1','157',206948,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'556',807673.15,807673.15,'556','2021-06-28 14:06:22','611','2021-06-28 16:34:37',10,0),('1','157',206983,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'556',909680.18,909680.18,'556','2021-06-28 16:44:28','611','2021-06-29 07:24:52',10,0),('1','157',207117,'AFTERNOON SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'556',915321.61,915321.61,'556','2021-06-29 11:37:32','611','2021-06-29 12:18:40',10,0),('1','157',207135,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'556',905187.90,905187.90,'556','2021-06-29 16:35:41','611','2021-06-29 22:03:56',10,0),('1','157',207313,'AFTERNOON SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'556',863107.82,863107.82,'556','2021-06-30 08:52:55','611','2021-06-30 13:55:32',10,0),('1','157',207429,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'556',939054.41,939054.41,'556','2021-06-30 16:36:22','611','2021-07-01 07:35:30',10,0),('1','157',207562,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'556',744856.21,744856.21,'556','2021-07-01 10:33:52','611','2021-07-01 11:50:33',10,0),('1','157',207631,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'556',937263.04,937263.04,'556','2021-07-01 15:09:29','611','2021-07-01 18:47:43',10,0),('1','157',207851,'AFTERNOON SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'556',720156.82,720156.82,'556','2021-07-03 15:11:47','611','2021-07-03 15:55:58',10,0),('1','157',208061,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'556',94747.01,94747.01,'556','2021-07-03 16:02:41','611','2021-07-04 07:01:03',10,0),('1','157',208256,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'556',646775.85,646775.85,'556','2021-07-04 15:01:35','611','2021-07-05 07:23:29',10,0),('1','157',208452,'AFTERNOON SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'556',922713.66,922713.66,'556','2021-07-05 12:41:33','611','2021-07-05 12:54:01',10,0),('1','157',208454,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'556',787977.86,787977.86,'556','2021-07-05 12:57:49','611','2021-07-05 13:07:28',10,0),('1','157',208461,'AFTERNOON SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'556',642360.18,642360.18,'556','2021-07-06 15:46:07','611','2021-07-06 16:32:45',10,0),('1','157',208720,'MORNING SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'556',233818.61,233818.61,'556','2021-07-06 16:37:29','611','2021-07-06 16:39:51',10,0),('1','157',208721,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'556',972743.25,972743.25,'556','2021-07-06 16:44:32','611','2021-07-07 08:07:51',10,0),('1','157',208862,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'556',832716.47,832716.47,'556','2021-07-07 10:43:07','611','2021-07-07 10:59:44',10,0),('1','157',208867,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'556',785736.61,785736.61,'556','2021-07-08 11:58:10','454','2021-07-08 12:50:32',10,0),('1','157',209113,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'556',888651.55,888651.55,'556','2021-07-08 13:16:02','611','2021-07-08 13:18:27',10,0),('1','157',209171,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'556',718385.01,718385.01,'556','2021-07-08 16:57:16','611','2021-07-08 17:07:07',10,0),('1','157',209175,'AFTERNOON SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'556',727757.51,727757.51,'556','2021-07-09 15:50:40','611','2021-07-09 19:31:25',10,0),('1','157',209409,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'556',807850.82,807850.82,'556','2021-07-10 16:05:49','611','2021-07-10 16:39:41',10,0),('1','157',209596,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'556',771912.58,771912.58,'556','2021-07-10 16:43:53','611','2021-07-10 16:49:31',10,0),('1','157',209601,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'556',327892.43,327892.43,'556','2021-07-11 10:52:58','611','2021-07-11 11:28:17',10,0),('1','157',209738,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'556',691915.44,691915.44,'556','2021-07-11 13:10:57','611','2021-07-11 15:45:44',10,0),('1','157',209823,'AFTERNOON SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'556',754169.54,754169.54,'556','2021-07-12 11:00:45','611','2021-07-12 11:35:39',10,0),('1','157',210039,'MORNING SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'556',814268.13,814268.13,'556','2021-07-12 15:44:48','611','2021-07-12 19:56:27',10,0),('1','157',210186,'AFTERNOON SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'556',758694.91,758694.91,'556','2021-07-13 10:47:38','611','2021-07-13 11:03:07',10,0),('1','157',210195,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'556',873373.56,873373.56,'556','2021-07-13 15:40:50','611','2021-07-13 15:47:04',10,0),('1','157',210264,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'556',845001.78,845001.78,'556','2021-07-14 14:19:50','454','2021-07-14 15:24:15',10,0),('1','157',210458,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'556',830061.20,830061.20,'556','2021-07-14 15:27:24','454','2021-07-14 15:32:19',10,0),('1','157',210461,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'556',533893.46,533893.46,'556','2021-07-15 12:17:37','454','2021-07-15 12:41:46',10,0),('1','157',210633,'MORNING SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'556',186190.01,186190.01,'556','2021-07-15 12:52:56','611','2021-07-16 07:26:00',10,0),('1','157',210841,'AFTERNOON SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'556',612418.71,612418.71,'556','2021-07-16 12:08:13','454','2021-07-16 16:03:00',10,0),('1','157',210897,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'556',929924.78,929924.78,'556','2021-07-16 16:57:48','611','2021-07-16 17:33:05',10,0),('1','157',211002,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'556',954034.11,954034.11,'556','2021-07-17 09:07:17','454','2021-07-17 10:43:17',10,0),('1','157',211064,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'556',792801.03,792801.03,'556','2021-07-17 13:43:52','611','2021-07-17 14:57:34',10,0),('1','157',211119,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'556',1168647.68,1168647.68,'556','2021-07-19 16:14:05','454','2021-07-20 13:20:42',10,0),('1','157',211686,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'556',1123570.46,1123570.46,'556','2021-07-20 14:30:16','454','2021-07-20 15:02:54',10,0),('1','157',211711,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'556',849693.67,849693.67,'556','2021-07-20 15:18:31','454','2021-07-20 15:20:25',10,0),('1','157',211712,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'556',778677.01,778677.01,'556','2021-07-20 15:24:21','454','2021-07-20 15:56:02',10,0),('1','157',212189,'AFTERNOON SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'556',845376.91,845376.91,'556','2021-07-22 18:22:27','454','2021-07-23 08:33:41',10,0),('1','157',212331,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'556',767690.88,767690.88,'556','2021-07-23 11:24:43','454','2021-07-23 12:29:25',10,0),('1','157',212345,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'556',22703.20,22703.20,'556','2021-07-23 12:39:14','454','2021-07-23 12:40:33',10,0),('1','157',212346,'AFTERNOON SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'556',873183.21,873183.21,'556','2021-07-23 12:50:12','454','2021-07-23 12:51:59',10,0),('1','157',212349,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'556',747982.35,747982.35,'556','2021-07-23 12:55:09','454','2021-07-23 12:56:03',10,0),('1','157',212353,'AFTERNOON SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'556',620061.18,620061.18,'556','2021-07-23 13:01:37','454','2021-07-23 13:05:59',10,0),('1','157',212356,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'556',667618.97,667618.97,'556','2021-07-23 13:18:28','454','2021-07-23 13:22:02',10,0),('1','157',212361,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'556',522942.30,522942.30,'556','2021-07-23 13:33:45','454','2021-07-23 14:33:10',10,0),('1','157',212546,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'556',660750.72,660750.72,'556','2021-07-24 13:33:16','611','2021-07-25 14:31:49',10,0),('1','157',212793,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'556',924496.61,924496.61,'556','2021-07-25 15:31:55','611','2021-07-25 15:57:30',10,0),('1','157',212804,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'556',692455.60,692455.60,'556','2021-07-25 16:05:57','611','2021-07-25 18:05:42',10,0),('1','157',212823,'AFTERNOON SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'556',752665.67,752665.67,'556','2021-07-25 18:16:39','454','2021-07-26 08:41:28',10,0),('1','157',213086,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'556',559536.62,559536.62,'556','2021-07-26 18:05:06','611','2021-07-27 07:01:37',10,0),('1','157',213252,'AFTERNOON SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'556',1191530.54,1191530.54,'556','2021-07-27 11:27:27','454','2021-07-27 11:28:36',10,0),('1','157',213265,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'556',417556.50,417556.50,'556','2021-07-27 11:39:08','454','2021-07-27 12:34:56',10,0),('1','157',213287,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'556',893792.24,893792.24,'556','2021-07-27 13:11:48','454','2021-07-27 13:13:13',10,0),('1','157',213327,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'556',785978.79,785978.79,'556','2021-07-27 15:32:29','611','2021-07-28 06:47:29',10,0),('1','157',213479,'AFTERNOON SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'556',909715.89,909715.89,'556','2021-07-28 10:44:09','454','2021-07-28 12:57:31',10,0),('1','157',213553,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'556',745764.24,745764.24,'556','2021-07-28 15:13:57','454','2021-07-28 15:46:05',10,0),('1','157',213578,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'556',1488782.84,1488782.84,'556','2021-07-29 14:39:48','611','2021-07-29 14:51:45',10,0),('1','157',213843,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'556',1076249.09,1076249.09,'556','2021-07-29 18:36:27','611','2021-07-30 09:59:41',10,0),('1','157',213994,'AFTERNOON SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'556',1554269.02,1554269.02,'556','2021-07-30 12:59:23','454','2021-07-30 15:25:16',10,0),('1','157',214170,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'556',712395.34,712395.34,'556','2021-07-31 11:11:44','611','2021-07-31 11:35:19',10,0),('1','157',214187,'AFTERNOON SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'556',974779.52,974779.52,'556','2021-07-31 12:52:04','611','2021-07-31 13:01:04',10,0),('1','157',214391,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'556',743135.96,743135.96,'556','2021-08-01 10:09:45','611','2021-08-01 13:03:23',10,0),('1','157',214443,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'556',987935.25,987935.25,'556','2021-08-01 13:28:54','611','2021-08-01 13:38:40',10,0),('1','157',214456,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'556',889342.10,889342.10,'556','2021-08-01 14:07:19','454','2021-08-02 08:20:34',10,0),('1','157',214730,'AFTERNOON SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'556',603533.30,603533.30,'556','2021-08-02 16:36:44','454','2021-08-03 08:46:06',10,0),('1','157',214868,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'556',765821.65,765821.65,'556','2021-08-03 11:11:57','454','2021-08-03 12:56:53',10,0),('1','157',214909,'AFTERNOON SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'556',1335163.81,1335163.81,'556','2021-08-03 16:18:06','611','2021-08-04 07:57:24',10,0),('1','157',215095,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'556',1079879.75,1079879.75,'556','2021-08-04 11:40:04','611','2021-08-04 11:48:09',10,0),('1','157',215102,'AFTERNOON SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'556',1095322.41,1095322.41,'556','2021-08-04 11:56:57','611','2021-08-04 11:59:31',10,0),('1','157',215108,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'556',776989.55,776989.55,'556','2021-08-04 16:59:12','454','2021-08-05 08:32:59',10,0),('1','157',215318,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'556',782597.49,782597.49,'556','2021-08-05 11:23:24','611','2021-08-05 11:43:00',10,0),('1','157',215396,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'556',967823.86,967823.86,'556','2021-08-05 16:55:51','611','2021-08-05 20:13:23',10,0),('1','157',215568,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'556',956806.93,956806.93,'556','2021-08-06 14:17:27','454','2021-08-06 15:56:30',10,0),('1','157',215613,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',215621,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'556',201777.70,201777.70,'556','2021-08-06 17:08:24','611','2021-08-06 17:17:25',10,0),('1','157',215626,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'556',862028.66,862028.66,'556','2021-08-06 17:38:31','454','2021-08-07 09:25:14',10,0),('1','157',215759,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'556',963755.00,963755.00,'556','2021-08-07 11:12:17','454','2021-08-07 11:18:19',10,0),('1','157',215800,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'556',949212.78,949212.78,'556','2021-08-07 14:00:59','611','2021-08-07 14:12:46',10,0),('1','157',215820,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'556',1038691.20,1038691.20,'556','2021-08-08 14:01:07','611','2021-08-08 17:30:51',10,0),('1','157',216163,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'556',538487.25,538487.25,'556','2021-08-09 09:30:37','611','2021-08-09 09:41:22',10,0),('1','157',216172,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'556',920005.48,920005.48,'556','2021-08-09 10:23:30','611','2021-08-09 14:39:12',10,0),('1','157',216295,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'556',1234890.40,1234890.40,'556','2021-08-09 18:34:42','454','2021-08-10 08:23:43',10,0),('1','157',216416,'AFTERNOON SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'556',932028.02,932028.02,'556','2021-08-10 14:38:49','454','2021-08-10 15:19:48',10,0),('1','157',216484,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'556',835481.72,835481.72,'556','2021-08-10 15:32:56','454','2021-08-10 15:47:11',10,0),('1','157',216618,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'556',805578.51,805578.51,'556','2021-08-11 10:37:29','454','2021-08-11 11:29:46',10,0),('1','157',216694,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'556',773284.75,773284.75,'556','2021-08-11 15:54:23','611','2021-08-11 16:22:54',10,0),('1','157',216863,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'556',1109355.05,1109355.05,'556','2021-08-12 11:10:11','611','2021-08-12 12:48:17',10,0),('1','157',216953,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'556',973536.20,973536.20,'556','2021-08-12 15:45:14','454','2021-08-13 08:22:56',10,0),('1','157',217108,'AFTERNOON SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'556',754244.89,754244.89,'556','2021-08-13 10:39:52','454','2021-08-13 13:41:03',10,0),('1','157',217206,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'556',928057.03,928057.03,'556','2021-08-14 12:26:42','611','2021-08-14 12:35:20',10,0),('1','157',217393,'AFTERNOON SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'556',1103713.31,1103713.31,'556','2021-08-14 13:00:05','454','2021-08-14 13:26:13',10,0),('1','157',217418,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'556',1031876.93,1031876.93,'556','2021-08-14 14:14:47','611','2021-08-15 13:47:31',10,0),('1','157',217594,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'556',1091170.22,1091170.22,'556','2021-08-15 14:23:05','611','2021-08-15 14:24:32',10,0),('1','157',217607,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'556',593373.74,593373.74,'556','2021-08-15 14:29:48','611','2021-08-16 09:13:47',10,0),('1','157',217785,'AFTERNOON SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'556',710173.43,710173.43,'556','2021-08-16 09:19:52','454','2021-08-16 09:46:10',10,0),('1','157',217805,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'556',832531.79,832531.79,'556','2021-08-16 16:56:35','611','2021-08-16 17:54:47',10,0),('1','157',218081,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'556',1185551.90,1185551.90,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',218187,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'556',1177650.20,1177650.20,'556','2021-08-17 19:36:15','611','2021-08-17 19:40:32',10,0),('1','157',218190,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'556',907306.86,907306.86,'556','2021-08-17 20:23:13','611','2021-08-17 20:29:37',10,0),('1','157',218302,'AFTERNOON SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'556',1162989.72,1162989.72,'556','2021-08-18 09:59:44','611','2021-08-18 11:22:49',10,0),('1','157',218328,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'556',1304285.40,1304285.40,'556','2021-08-18 16:30:07','611','2021-08-18 21:03:37',10,0),('1','157',218536,'AFTERNOON SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'556',692860.74,692860.74,'556','2021-08-19 11:57:54','611','2021-08-19 11:59:48',10,0),('1','157',218585,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'556',784146.92,784146.92,'556','2021-08-19 14:12:28','611','2021-08-19 14:45:45',10,0),('1','157',218781,'AFTERNOON SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'556',652264.28,652264.28,'556','2021-08-20 10:55:28','611','2021-08-20 13:16:39',10,0),('1','157',218807,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'556',1026439.54,1026439.54,'556','2021-08-20 13:19:50','454','2021-08-20 13:47:36',10,0),('1','157',218970,'AFTERNOON SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'556',804858.66,804858.66,'556','2021-08-21 14:20:38','454','2021-08-21 14:41:41',10,0),('1','157',219055,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'556',1064210.14,1064210.14,'556','2021-08-21 16:06:29','611','2021-08-22 06:39:38',10,0),('1','157',219242,'AFTERNOON SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'556',999570.46,999570.46,'556','2021-08-22 13:59:09','611','2021-08-22 14:13:01',10,0),('1','157',219253,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'556',995201.18,995201.18,'556','2021-08-23 10:00:20','611','2021-08-23 10:38:14',10,0),('1','157',219446,'AFTERNOON SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'556',641576.30,641576.30,'556','2021-08-23 10:44:32','611','2021-08-23 11:23:52',10,0),('1','157',219492,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'556',1119174.68,1119174.68,'556','2021-08-23 13:40:02','611','2021-08-23 15:08:33',10,0),('1','157',219522,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'556',1193777.90,1193777.90,'556','2021-08-24 10:50:20','611','2021-08-24 17:17:40',10,0),('1','157',219935,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'556',950814.94,950814.94,'556','2021-08-25 12:48:57','454','2021-08-25 13:08:46',10,0),('1','157',219942,'AFTERNOON SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'556',1228074.58,1228074.58,'556','2021-08-25 13:17:41','454','2021-08-25 13:20:09',10,0),('1','157',219953,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'556',1949737.68,1949737.68,'556','2021-08-25 14:11:19','611','2021-08-25 15:19:11',10,0),('1','157',220012,'AFTERNOON SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'556',1272216.70,1272216.70,'556','2021-08-26 10:11:51','611','2021-08-26 10:16:27',10,0),('1','157',220126,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'556',1568450.04,1568450.04,'556','2021-08-27 10:05:19','454','2021-08-27 10:32:27',10,0),('1','157',220336,'AFTERNOON SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'556',804555.70,804555.70,'556','2021-08-27 10:38:20','454','2021-08-27 10:39:40',10,0),('1','157',220354,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'556',860521.76,860521.76,'556','2021-08-27 18:46:02','611','2021-08-28 08:07:50',10,0),('1','157',220545,'AFTERNOON SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'556',845969.02,845969.02,'556','2021-08-28 11:08:01','611','2021-08-28 13:02:51',10,0),('1','157',220592,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'556',763994.38,763994.38,'556','2021-08-28 13:35:59','611','2021-08-28 14:49:41',10,0),('1','157',220627,'AFTERNOON SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'556',838011.32,838011.32,'556','2021-08-29 11:02:44','611','2021-08-29 12:08:23',10,0),('1','157',220789,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'556',1126656.82,1126656.82,'556','2021-08-29 17:25:33','611','2021-08-29 17:31:57',10,0),('1','157',220864,'AFTERNOON SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'556',1061667.46,1061667.46,'556','2021-08-30 13:02:33','454','2021-08-30 14:01:46',10,0),('1','157',221067,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'556',983987.34,983987.34,'556','2021-08-30 17:30:06','611','2021-08-31 06:29:31',10,0),('1','157',221238,'AFTERNOON SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'556',769815.28,769815.28,'556','2021-08-31 10:14:05','454','2021-08-31 10:53:46',10,0),('1','157',221276,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'556',923355.90,923355.90,'556','2021-08-31 13:01:02','611','2021-08-31 15:00:49',10,0),('1','157',221477,'AFTERNOON SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'556',969595.50,969595.50,'556','2021-09-01 10:31:58','454','2021-09-01 10:56:39',10,0),('1','157',221481,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'556',985292.78,985292.78,'556','2021-09-01 17:33:02','454','2021-09-02 10:04:37',10,0),('1','157',221702,'AFTERNOON SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'556',915410.97,910182.68,'556','2021-09-02 11:18:50','454','2021-09-02 12:27:13',10,0),('1','157',221731,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'556',890479.80,885506.30,'556','2021-09-02 13:18:01','611','2021-09-02 13:32:37',10,0),('1','157',221928,'AFTERNOON SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'556',898871.56,893746.34,'556','2021-09-03 11:53:02','611','2021-09-03 14:11:16',10,0),('1','157',221979,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'556',851056.90,851056.90,'556','2021-09-03 14:56:26','611','2021-09-03 19:08:06',10,0),('1','157',222140,'AFTERNOON SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'556',1382509.78,1382509.78,'556','2021-09-04 11:50:56','611','2021-09-04 11:56:40',10,0),('1','157',222191,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'556',1175330.22,1175330.22,'556','2021-09-04 18:36:17','611','2021-09-05 08:15:01',10,0),('1','157',222355,'AFTERNOON SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'556',1220561.64,1220561.64,'556','2021-09-05 11:39:50','454','2021-09-05 13:08:38',10,0),('1','157',222388,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'556',810114.18,810114.18,'556','2021-09-05 13:37:56','454','2021-09-05 15:15:46',10,0),('1','157',222591,'AFTERNOON SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'556',722583.04,722583.04,'556','2021-09-06 12:02:59','611','2021-09-06 14:38:46',10,0),('1','157',222657,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'556',854068.16,854068.16,'556','2021-09-06 15:43:09','454','2021-09-06 16:03:30',10,0),('1','157',222807,'AFTERNOON SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'556',805238.52,805238.52,'556','2021-09-07 10:56:11','454','2021-09-07 11:19:45',10,0),('1','157',222886,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'556',1012960.80,1012960.80,'556','2021-09-07 15:27:23','611','2021-09-07 17:04:01',10,0),('1','157',222907,'AFTERNOON SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'556',909089.92,909089.92,'556','2021-09-08 09:21:49','611','2021-09-08 09:36:35',10,0),('1','157',223006,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'556',1180665.88,1180665.88,'556','2021-09-08 16:09:59','454','2021-09-09 09:33:44',10,0),('1','157',223260,'AFTERNOON SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'556',682999.28,682999.28,'556','2021-09-09 13:46:06','454','2021-09-09 13:48:09',10,0),('1','157',223322,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'556',742426.08,742426.08,'556','2021-09-09 15:26:01','611','2021-09-09 20:19:08',10,0),('1','157',223396,'AFTERNOON SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'556',700961.62,700961.62,'556','2021-09-09 20:27:29','454','2021-09-10 08:48:25',10,0),('1','157',223454,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'556',923598.34,923598.34,'556','2021-09-10 14:31:53','611','2021-09-10 16:12:24',10,0),('1','157',223796,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'556',960119.72,960119.72,'556','2021-09-11 13:55:36','454','2021-09-11 13:59:17',10,0),('1','157',223800,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'556',1041857.76,1041857.76,'556','2021-09-11 14:12:22','454','2021-09-11 15:15:06',10,0),('1','157',223968,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'556',735016.92,735016.92,'556','2021-09-12 12:43:58','611','2021-09-12 12:46:50',10,0),('1','157',223976,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'556',841534.52,841534.52,'556','2021-09-12 14:58:22','611','2021-09-12 17:14:34',10,0),('1','157',224169,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'556',964070.38,964070.38,'556','2021-09-13 11:33:47','454','2021-09-13 11:37:12',10,0),('1','157',224266,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'556',1224567.86,1224567.86,'556','2021-09-13 16:34:14','454','2021-09-14 08:30:34',10,0),('1','157',224401,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'556',928073.92,928073.92,'556','2021-09-14 10:28:50','611','2021-09-14 11:11:33',10,0),('1','157',224417,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'556',979586.04,979586.04,'556','2021-09-14 14:49:43','611','2021-09-14 14:53:32',10,0),('1','157',224467,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'556',963603.78,963603.78,'556','2021-09-15 10:38:55','454','2021-09-15 12:16:16',10,0),('1','157',224692,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'556',833841.70,833841.70,'556','2021-09-15 14:27:11','454','2021-09-16 08:33:06',10,0),('1','157',224876,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'556',969874.36,969874.36,'556','2021-09-16 11:13:29','611','2021-09-16 13:06:15',10,0),('1','157',224913,'MORNING SHIFT (1)','2021-09-16','2021-09-16 00:00:00',NULL,'556',23115.90,23115.90,'556','2021-09-16 13:09:40','611','2021-09-16 13:12:05',10,0),('1','157',224922,'MORNING SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'556',878234.67,878234.67,'556','2021-09-16 16:26:20','454','2021-09-17 09:42:36',10,0),('1','157',225123,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'556',913273.79,913273.79,'556','2021-09-17 11:51:23','454','2021-09-17 13:41:57',10,0),('1','157',225153,'MORNING SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'556',797375.16,797375.16,'556','2021-09-17 14:04:46','611','2021-09-17 14:40:13',10,0),('1','157',225198,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'556',1142936.71,1142936.71,'556','2021-09-17 19:42:08','611','2021-09-17 20:07:51',10,0),('1','157',225253,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'556',760070.76,760070.76,'556','2021-09-18 13:12:40','611','2021-09-18 13:16:16',10,0),('1','157',225395,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'556',834596.28,834596.28,'556','2021-09-19 08:49:46','611','2021-09-19 11:54:42',10,0),('1','157',225576,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'556',982364.22,982364.22,'556','2021-09-19 13:46:11','454','2021-09-20 09:26:14',10,0),('1','157',225788,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'556',719193.24,719193.24,'556','2021-09-20 09:32:26','611','2021-09-20 09:37:35',10,0),('1','157',225814,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'556',974859.93,974859.93,'556','2021-09-20 15:06:46','611','2021-09-20 15:10:30',10,0),('1','157',225975,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'556',1300279.01,1300279.01,'556','2021-09-21 06:04:37','454','2021-09-21 08:09:23',10,0),('1','157',226109,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'556',497296.25,497296.25,'556','2021-09-21 13:39:38','454','2021-09-21 14:06:37',10,0),('1','157',226147,'MORNING SHIFT2','2021-09-21','2021-09-21 00:00:00',NULL,'556',887537.22,887537.22,'556','2021-09-21 15:13:13','611','2021-09-21 16:04:58',10,0),('1','157',226390,'AFTERNOON SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'556',862263.24,862263.24,'556','2021-09-22 14:05:23','454','2021-09-22 14:17:58',10,0),('1','157',226403,'MORNING SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'556',894591.00,894591.00,'556','2021-09-22 15:02:10','454','2021-09-22 15:07:55',10,0),('1','157',226418,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'556',744220.02,744220.02,'556','2021-09-23 11:23:38','611','2021-09-23 11:32:06',10,0),('1','157',226593,'MORNING SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'556',811074.54,811074.54,'556','2021-09-23 14:14:45','611','2021-09-23 14:34:17',10,0),('1','157',226651,'AFTERNOON SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'556',660774.42,660774.42,'556','2021-09-24 09:50:58','454','2021-09-24 13:41:09',10,0),('1','157',226871,'MORNING SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'556',788908.26,788908.26,'556','2021-09-24 13:56:24','454','2021-09-24 14:05:07',10,0),('1','157',226895,'AFTERNOON SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'556',748697.58,748697.58,'556','2021-09-25 11:00:30','454','2021-09-25 11:07:00',10,0),('1','157',227047,'MORNING SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'556',1128368.94,1128368.94,'556','2021-09-25 13:06:14','611','2021-09-25 13:09:30',10,0),('1','157',227082,'AFTERNOON SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'556',828486.96,828486.96,'556','2021-09-26 06:15:09','611','2021-09-26 17:09:41',10,0),('1','157',227332,'MORNING SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'556',955962.60,955962.60,'556','2021-09-26 17:50:52','611','2021-09-26 19:03:11',10,0),('1','157',227346,'AFTERNOON SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'556',710187.72,710187.72,'556','2021-09-27 06:14:50','454','2021-09-27 09:12:29',10,0),('1','157',227496,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'556',880239.90,880239.90,'556','2021-09-27 13:05:23','611','2021-09-27 14:19:47',10,0),('1','157',227554,'AFTERNOON SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'556',862663.20,862663.20,'556','2021-09-28 11:57:45','454','2021-09-28 12:15:06',10,0),('1','157',227735,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'556',1426626.30,1426626.30,'556','2021-09-28 15:40:30','611','2021-09-28 16:06:55',10,0),('1','157',227801,'AFTERNOON ONE','2021-09-28','2021-09-28 00:00:00',NULL,'556',77499.00,77499.00,'556','2021-09-28 16:23:00','611','2021-09-28 17:49:44',10,0),('1','157',227912,'AFTERNOON SHIFT 2','2021-09-28','2021-09-28 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',227964,'AFTERNOON TWO','2021-09-28','2021-09-28 00:00:00',NULL,'556',512363.51,512363.51,'556','2021-09-29 12:01:01','611','2021-09-29 12:04:24',10,0),('1','157',227973,'MORNING SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'556',210509.50,210509.50,'556','2021-09-30 07:28:38','454','2021-09-30 08:46:05',10,0),('1','157',228260,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',228278,'AFTERNOON SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'556',192058.49,192058.49,'556','2021-09-30 16:17:25','611','2021-09-30 19:03:55',10,0),('1','157',228418,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'556',1152185.66,1152185.66,'556','2021-10-01 10:24:14','611','2021-10-01 11:37:11',10,0),('1','157',228466,'MORNING SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'556',1005276.48,1005276.48,'556','2021-10-02 07:38:23','611','2021-10-02 08:35:05',10,0),('1','157',228595,'AFTERNOON SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'556',1122036.70,1122036.70,'556','2021-10-02 10:53:31','611','2021-10-02 13:01:11',10,0),('1','157',228647,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'556',1023934.77,1023934.77,'556','2021-10-02 14:25:03','611','2021-10-02 17:48:53',10,0),('1','157',228831,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'556',774088.61,774088.61,'556','2021-10-03 12:06:01','611','2021-10-03 12:10:08',10,0),('1','157',228833,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'556',874355.58,874355.58,'556','2021-10-03 13:25:53','611','2021-10-03 13:37:04',10,0),('1','157',228887,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'556',938812.79,938812.79,'556','2021-10-04 09:25:42','454','2021-10-04 10:18:06',10,0),('1','157',229061,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'556',1061886.04,1061886.04,'556','2021-10-04 14:01:20','611','2021-10-04 14:05:52',10,0),('1','157',229173,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'556',931583.10,931583.10,'556','2021-10-05 10:30:45','454','2021-10-05 10:32:27',10,0),('1','157',229248,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'556',956568.40,956568.40,'556','2021-10-05 14:11:37','611','2021-10-05 14:40:42',10,0),('1','157',229481,'AFTERNOON SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'556',39805.55,39805.55,'556','2021-10-06 09:36:34','611','2021-10-06 09:50:28',10,0),('1','157',229493,'AFTERNOON SHIFT 2','2021-10-06','2021-10-06 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',229494,'AFTERNOON SHIFT 2','2021-10-05','2021-10-05 00:00:00',NULL,'556',913128.84,913128.84,'556','2021-10-06 10:05:01','611','2021-10-06 10:59:10',10,0),('1','157',229628,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'556',780802.74,780802.74,'556','2021-10-06 18:21:05','611','2021-10-06 19:02:43',10,0),('1','157',229741,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'556',1037824.38,1037824.38,'556','2021-10-07 12:21:02','611','2021-10-07 13:39:16',10,0),('1','157',229786,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'556',1079771.04,1079771.04,'556','2021-10-07 17:55:28','611','2021-10-07 19:47:28',10,0),('1','157',229977,'AFTERNOON SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'556',849410.55,849410.55,'556','2021-10-08 12:45:09','611','2021-10-08 12:52:37',10,0),('1','157',230133,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'556',1147890.87,1147890.87,'556','2021-10-09 09:13:54','611','2021-10-09 09:28:12',10,0),('1','157',230142,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'556',931476.96,931476.96,'556','2021-10-09 10:10:43','611','2021-10-09 10:23:13',10,0),('1','157',230158,'MORNING SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'556',1017898.02,1017898.02,'556','2021-10-09 16:55:18','611','2021-10-09 19:16:21',10,0),('1','157',230365,'AFTERNOON SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'556',1000907.82,1000907.82,'556','2021-10-10 10:39:45','611','2021-10-10 12:18:40',10,0),('1','157',230400,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'556',1171158.90,1171158.90,'556','2021-10-10 13:27:08','611','2021-10-10 15:09:32',10,0),('1','157',230620,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'556',1460935.99,1460935.99,'556','2021-10-11 11:21:49','611','2021-10-11 11:45:42',10,0),('1','157',230642,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'556',553114.40,553114.40,'556','2021-10-11 16:05:32','611','2021-10-11 16:13:10',10,0),('1','157',230725,'AFTERNOON SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'556',1240083.26,1240083.26,'556','2021-10-12 11:44:43','611','2021-10-12 11:46:58',10,0),('1','157',230904,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'556',853684.62,853684.62,'556','2021-10-12 16:48:41','611','2021-10-12 16:57:27',10,0),('1','157',231149,'AFTERNOON SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'556',1141035.88,1141035.88,'556','2021-10-13 10:14:57','611','2021-10-13 13:25:37',10,0),('1','157',231284,'MORNING SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'556',873062.16,873062.16,'556','2021-10-14 07:26:44','611','2021-10-14 10:34:15',10,0),('1','157',231481,'AFTERNOON SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'556',802554.25,802554.25,'556','2021-10-14 11:20:11','611','2021-10-14 11:23:53',10,0),('1','157',231488,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'556',821762.03,821762.03,'556','2021-10-14 13:10:13','611','2021-10-14 16:40:29',10,0),('1','157',231705,'AFTERNOON SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'556',707757.16,707757.16,'556','2021-10-15 10:16:26','611','2021-10-15 11:35:14',10,0),('1','157',231798,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'556',761609.23,761609.23,'556','2021-10-15 13:58:19','611','2021-10-15 15:28:26',10,0),('1','157',231919,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'556',991684.63,991684.63,'556','2021-10-16 07:41:15','611','2021-10-16 07:57:53',10,0),('1','157',232008,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'556',945546.59,945546.59,'556','2021-10-16 13:34:49','611','2021-10-16 16:15:41',10,0),('1','157',232192,'AFTERNOON SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'556',1175823.32,1175823.32,'556','2021-10-17 11:43:22','611','2021-10-17 11:45:07',10,0),('1','157',232208,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'556',695925.36,695925.36,'556','2021-10-17 16:18:38','611','2021-10-17 16:52:06',10,0),('1','157',232302,'AFTERNOON SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'556',1047632.98,1047632.98,'556','2021-10-18 11:09:34','611','2021-10-18 11:12:11',10,0),('1','157',232443,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'556',1126606.71,1126606.71,'556','2021-10-18 18:44:50','611','2021-10-19 08:00:38',10,0),('1','157',232749,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'556',943799.14,943799.14,'556','2021-10-19 14:41:58','611','2021-10-19 20:32:45',10,0),('1','157',232819,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'556',1181455.53,1181455.53,'556','2021-10-20 06:15:26','611','2021-10-20 06:24:59',10,0),('1','157',232952,'AFTERNOON SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'556',860638.06,860638.06,'556','2021-10-20 10:43:36','611','2021-10-20 10:44:01',10,0),('1','157',232966,'MORNING SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'556',878097.53,878097.53,'556','2021-10-20 13:19:06','611','2021-10-20 13:21:55',10,0),('1','157',233019,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',233134,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'556',756289.02,756289.02,'556','2021-10-21 06:59:52','611','2021-10-21 07:04:39',10,0),('1','157',233272,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'556',869542.65,869542.65,'556','2021-10-21 14:14:36','611','2021-10-21 15:06:02',10,0),('1','157',233412,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'556',653679.59,653679.59,'556','2021-10-22 07:35:28','611','2021-10-22 08:51:42',10,0),('1','157',233549,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'556',868318.71,868318.71,'556','2021-10-22 16:03:17','611','2021-10-22 18:44:02',10,0),('1','157',233636,'AFTERNOON SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'556',1067391.24,1067391.24,'556','2021-10-23 07:28:28','611','2021-10-23 07:37:32',10,0),('1','157',233667,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',233689,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'556',1101235.42,1101235.42,'556','2021-10-23 13:26:41','611','2021-10-23 14:49:12',10,0),('1','157',233799,'AFTERNOON SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'556',1086975.92,1086975.92,'556','2021-10-24 10:18:57','611','2021-10-24 11:57:07',10,0),('1','157',233958,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'556',666314.21,666314.21,'556','2021-10-24 14:04:06','611','2021-10-24 14:04:49',10,0),('1','157',234144,'AFTERNOON SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'556',581802.42,581802.42,'556','2021-10-25 10:12:24','611','2021-10-25 10:45:10',10,0),('1','157',234187,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'556',734947.44,734947.44,'556','2021-10-25 14:29:00','611','2021-10-25 15:10:58',10,0),('1','157',234235,'AFTERNOON SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'556',904069.63,904069.63,'556','2021-10-26 08:16:45','611','2021-10-26 09:18:53',10,0),('1','157',234405,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'556',880024.12,880024.12,'556','2021-10-26 13:28:44','611','2021-10-26 13:32:09',10,0),('1','157',234472,'AFTERNOON SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'556',861588.66,861588.66,'556','2021-10-26 22:09:02','611','2021-10-27 06:40:21',10,0),('1','157',234709,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'556',756525.38,756525.38,'556','2021-10-27 12:52:20','611','2021-10-27 14:02:12',10,0),('1','157',234796,'AFTERNOON SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'556',663136.16,663136.16,'556','2021-10-27 22:12:50','611','2021-10-28 08:21:13',10,0),('1','157',234905,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'556',764897.06,764897.06,'556','2021-10-28 12:54:00','611','2021-10-28 13:47:35',10,0),('1','157',235039,'AFTERNOON SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'556',708486.02,708486.02,'556','2021-10-28 21:48:43','611','2021-10-28 22:18:40',10,0),('1','157',235044,'Morning shift','2021-10-29','2021-10-29 00:00:00',NULL,'556',794468.52,794468.52,'556','2021-10-29 13:49:00','611','2021-10-29 13:50:28',10,0),('1','157',235252,'AFTERNOON SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'556',1100549.92,1100549.92,'556','2021-10-29 20:17:38','611','2021-10-29 21:43:13',10,0),('1','157',235281,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'556',1308707.44,1308707.44,'556','2021-10-30 14:03:55','611','2021-10-30 14:05:53',10,0),('1','157',235501,'AFTERNOON SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'556',894850.44,894850.44,'556','2021-10-30 23:05:23','611','2021-10-31 05:55:51',10,0),('1','157',235579,'MORNING SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'556',670487.46,670487.46,'556','2021-10-31 12:29:01','611','2021-10-31 15:44:22',10,0),('1','157',235710,'AFTERNOON SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'556',587196.09,587196.09,'556','2021-10-31 19:42:24','611','2021-10-31 19:52:50',10,0),('1','157',235714,'MORNING SHIFT','2017-11-01','2017-11-01 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',235733,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'556',765888.10,765888.10,'556','2021-11-01 13:04:24','611','2021-11-01 14:50:38',10,0),('1','157',235988,'AFTERNOON SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'556',1225204.20,1225204.20,'556','2021-11-01 22:26:52','611','2021-11-02 06:52:21',10,0),('1','157',236051,'MORNING SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'556',1045017.60,1045017.60,'556','2021-11-02 13:00:10','611','2021-11-02 14:07:52',10,0),('1','157',236274,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'556',1022179.95,1022179.95,'556','2021-11-03 07:34:06','611','2021-11-03 10:06:17',10,0),('1','157',236356,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'556',808622.10,808622.10,'556','2021-11-03 15:07:11','611','2021-11-03 17:37:10',10,0),('1','157',236464,'AFTERNOON SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'556',723506.85,723506.85,'556','2021-11-03 19:51:09','611','2021-11-03 20:00:50',10,0),('1','157',236607,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'556',781496.10,781496.10,'556','2021-11-04 12:28:52','611','2021-11-04 12:53:27',10,0),('1','157',236668,'AFTERNOON SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'556',538383.45,538383.45,'556','2021-11-04 18:14:52','611','2021-11-04 18:37:05',10,0),('1','157',236710,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'556',641515.05,641515.05,'556','2021-11-05 12:57:43','611','2021-11-05 13:51:58',10,0),('1','157',236877,'AFTERNOON SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'556',106712.10,106712.10,'556','2021-11-06 23:02:20','611','2021-11-07 07:06:37',10,0),('1','157',237462,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'556',961253.55,961253.55,'556','2021-11-08 16:10:13','611','2021-11-08 16:14:10',10,0),('1','157',237540,'AFTERNOON SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'556',761280.75,761280.75,'556','2021-11-08 22:08:24','611','2021-11-09 07:10:13',10,0),('1','157',237645,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'556',729757.50,729757.50,'556','2021-11-09 13:59:24','611','2021-11-09 14:23:03',10,0),('1','157',237884,'AFTERNOON SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'556',866605.65,866605.65,'556','2021-11-10 06:57:49','611','2021-11-10 07:05:29',10,0),('1','157',237916,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'556',765877.20,765877.20,'556','2021-11-10 13:37:23','611','2021-11-10 14:02:57',10,0),('1','157',238150,'AFTERNOON SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'556',938993.55,938993.55,'556','2021-11-11 07:17:57','611','2021-11-11 07:25:37',10,0),('1','157',238184,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'556',1413675.60,1413675.60,'556','2021-11-11 16:11:43','611','2021-11-11 16:12:05',10,0),('1','157',238316,'AFTERNOON SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'556',1106080.20,1106080.20,'556','2021-11-11 19:44:16','611','2021-11-11 19:51:01',10,0),('1','157',238449,'MORNING SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'556',1211159.85,1211159.85,'556','2021-11-12 13:19:34','611','2021-11-12 13:57:15',10,0),('1','157',238607,'AFTERNOON SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'556',1141390.65,1141390.65,'556','2021-11-13 06:07:59','611','2021-11-13 06:40:23',10,0),('1','157',238675,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'556',1803470.40,1803470.40,'556','2021-11-13 15:09:19','611','2021-11-13 16:14:48',10,0),('1','157',238773,'AFTERNOON SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'556',1214403.75,1214403.75,'556','2021-11-14 10:32:21','611','2021-11-14 10:45:39',10,0),('1','157',238911,'MORNING SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'556',1207636.20,1207636.20,'556','2021-11-14 14:16:41','611','2021-11-14 14:48:05',10,0),('1','157',239042,'AFTERNOON SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'556',725551.35,725551.35,'556','2021-11-15 07:15:49','611','2021-11-15 07:17:33',10,0),('1','157',239115,'MORNING SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'556',1429002.45,1429002.45,'556','2021-11-15 13:39:57','611','2021-11-15 14:09:04',10,0),('1','157',239230,'AFTERNOON SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'556',582505.05,582505.05,'556','2021-11-16 07:00:41','611','2021-11-16 07:05:05',10,0),('1','157',239435,'MORNING SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'556',2030051.10,2030051.10,'556','2021-11-16 16:00:14','611','2021-11-16 16:13:48',10,0),('1','157',239558,'AFTERNOON SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'556',1262022.00,1262022.00,'556','2021-11-17 07:12:12','611','2021-11-17 07:32:32',10,0),('1','157',239597,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'556',1678703.40,1678703.40,'556','2021-11-17 14:27:21','611','2021-11-17 14:31:57',10,0),('1','157',239706,'AFTERNOON SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'556',430237.80,430237.80,'556','2021-11-17 18:16:33','611','2021-11-17 19:53:41',10,0),('1','157',239780,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'556',242652.30,242652.30,'556','2021-11-18 13:44:52','611','2021-11-18 13:51:07',10,0),('1','157',239965,'AFTERNOON SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'556',29500.95,29500.95,'556','2021-11-19 09:09:16','611','2021-11-19 11:44:26',10,0),('1','157',240231,'MORNING SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'556',400424.25,400424.25,'556','2021-11-20 08:06:43','611','2021-11-20 09:07:40',10,0),('1','157',240297,'AFTERNOON SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'556',167169.75,167169.75,'556','2021-11-20 13:01:17','611','2021-11-20 13:17:06',10,0),('1','157',240313,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'556',151624.05,151624.05,'556','2021-11-20 13:28:05','611','2021-11-20 14:13:05',10,0),('1','157',240473,'AFTERNOON SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'556',933723.90,933723.90,'556','2021-11-21 07:56:25','611','2021-11-21 08:27:15',10,0),('1','157',240559,'MORNING SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'556',655609.35,655609.35,'556','2021-11-21 13:35:56','611','2021-11-21 13:36:10',10,0),('1','157',240761,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'556',702959.10,702959.10,'556','2021-11-22 08:51:11','611','2021-11-22 10:23:33',10,0),('1','157',240798,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'556',1617120.30,1617120.30,'556','2021-11-22 14:20:37','611','2021-11-22 14:37:05',10,0),('1','157',241025,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'556',1207546.80,1207546.80,'556','2021-11-23 10:31:44','611','2021-11-23 12:49:27',10,0),('1','157',241156,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'556',2554813.95,2554813.95,'556','2021-11-23 16:43:55','611','2021-11-23 17:16:18',10,0),('1','157',241279,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',241283,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'556',2533677.90,2533677.90,'556','2021-11-24 08:01:53','611','2021-11-24 08:07:49',10,0),('1','157',241292,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'556',1198683.45,1198683.45,'556','2021-11-24 13:28:04','611','2021-11-24 13:43:12',10,0),('1','157',241514,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'556',1019080.05,1019080.05,'556','2021-11-25 07:11:08','611','2021-11-25 08:55:37',10,0),('1','157',241603,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'556',1128002.25,1128002.25,'556','2021-11-25 14:33:13','611','2021-11-25 14:44:29',10,0),('1','157',241689,'AFTERNOON SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'556',1157394.45,1157394.45,'556','2021-11-25 20:24:39','611','2021-11-25 22:02:04',10,0),('1','157',241710,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',241860,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'556',1124906.70,1124906.70,'556','2021-11-26 12:47:25','611','2021-11-26 14:13:51',10,0),('1','157',241949,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'556',1104910.65,1104910.65,'556','2021-11-27 06:13:50','611','2021-11-27 06:57:15',10,0),('1','157',242064,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'556',926609.25,926609.25,'556','2021-11-27 14:01:07','611','2021-11-27 14:07:04',10,0),('1','157',242134,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'556',1032419.40,1032419.40,'556','2021-11-28 07:43:44','611','2021-11-28 07:57:37',10,0),('1','157',242333,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'556',726382.65,726382.65,'556','2021-11-28 14:29:17','611','2021-11-28 15:11:23',10,0),('1','157',242357,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'556',789421.95,789421.95,'556','2021-11-29 06:34:59','611','2021-11-29 07:00:37',10,0),('1','157',242586,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'556',941450.70,941450.70,'556','2021-11-29 14:37:33','611','2021-11-29 19:01:34',10,0),('1','157',242699,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'556',1060086.75,1060086.75,'556','2021-11-30 11:52:19','611','2021-11-30 12:14:56',10,0),('1','157',242837,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'556',2182247.25,2182247.25,'556','2021-11-30 15:34:19','611','2021-11-30 16:39:01',10,0),('1','157',242845,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'556',1725208.95,1725208.95,'556','2021-11-30 17:48:34','611','2021-11-30 21:05:09',10,0),('1','157',242956,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'556',537820.80,537820.80,'556','2021-12-01 12:44:43','611','2021-12-01 13:04:39',10,0),('1','157',243051,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'556',266074.05,266074.05,'556','2021-12-01 17:18:41','611','2021-12-01 17:29:09',10,0),('1','157',243196,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',243305,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'556',770361.90,770361.90,'556','2021-12-02 19:14:18','611','2021-12-02 19:17:48',10,0),('1','157',243417,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'556',2305021.95,2305021.95,'556','2021-12-03 15:46:39','611','2021-12-03 16:53:09',10,0),('1','157',243532,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'556',1420579.05,1420579.05,'556','2021-12-03 18:10:29','611','2021-12-03 20:22:13',10,0),('1','157',243607,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'556',385380.60,385380.60,'556','2021-12-04 13:48:53','611','2021-12-04 13:59:44',10,0),('1','157',243750,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'556',187788.15,187788.15,'556','2021-12-04 20:00:13','611','2021-12-04 22:06:04',10,0),('1','157',243957,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'556',665413.65,665413.65,'556','2021-12-06 02:55:43','611','2021-12-06 07:51:13',10,0),('1','157',244151,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'556',897783.15,897783.15,'556','2021-12-06 13:38:43','611','2021-12-06 13:42:10',10,0),('1','157',244222,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'556',764346.00,764346.00,'556','2021-12-06 17:43:36','611','2021-12-06 19:43:19',10,0),('1','157',244356,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'556',237578.55,237578.55,'556','2021-12-07 14:26:03','611','2021-12-07 14:28:59',10,0),('1','157',244603,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',244849,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'556',2907379.20,2907379.20,'556','2021-12-09 12:53:29','611','2021-12-09 12:58:57',10,0),('1','157',244922,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'556',1746515.10,1746515.10,'556','2021-12-10 00:22:52','611','2021-12-10 08:06:56',10,0),('1','157',245031,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'556',897510.90,897510.90,'556','2021-12-10 14:02:02','611','2021-12-10 14:40:24',10,0),('1','157',245164,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'556',1281319.05,1281319.05,'556','2021-12-10 19:11:08','611','2021-12-10 20:31:40',10,0),('1','157',245260,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'556',1459254.75,1459254.75,'556','2021-12-11 14:36:45','611','2021-12-11 16:01:34',10,0),('1','157',245495,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'556',1576549.80,1576549.80,'556','2021-12-12 09:42:44','611','2021-12-12 10:43:48',10,0),('1','157',245564,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'556',957556.80,957556.80,'556','2021-12-12 13:43:54','611','2021-12-12 15:04:27',10,0),('1','157',245614,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'556',844438.65,844438.65,'556','2021-12-13 06:03:12','611','2021-12-13 08:14:12',10,0),('1','157',245772,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'556',1255513.80,1255513.80,'556','2021-12-13 14:39:37','611','2021-12-13 14:41:51',10,0),('1','157',245827,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'556',2470900.80,2470900.80,'556','2021-12-13 21:48:13','611','2021-12-14 06:32:56',10,0),('1','157',246112,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'556',2002918.05,2002918.05,'556','2021-12-14 15:54:14','611','2021-12-15 06:09:18',10,0),('1','157',246267,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'556',2975466.30,2975466.30,'556','2021-12-15 09:15:45','611','2021-12-15 09:19:26',10,0),('1','157',246275,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'556',1756014.60,1756014.60,'556','2021-12-15 12:59:30','611','2021-12-15 14:13:10',10,0),('1','157',246433,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'556',2765089.05,2765089.05,'556','2021-12-16 08:28:37','611','2021-12-16 08:38:49',10,0),('1','157',246520,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'556',1997499.90,1997499.90,'556','2021-12-16 13:22:11','611','2021-12-16 13:24:42',10,0),('1','157',246609,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'556',374986.35,374986.35,'556','2021-12-16 21:31:19','611','2021-12-16 21:56:38',10,0),('1','157',246759,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'556',1189783.50,1189783.50,'556','2021-12-17 15:06:40','611','2021-12-17 15:17:27',10,0),('1','157',246863,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'556',1312567.35,1312567.35,'556','2021-12-18 07:14:54','611','2021-12-18 07:44:26',10,0),('1','157',246987,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'556',991951.05,991951.05,'556','2021-12-18 21:05:40','611','2021-12-18 21:10:34',10,0),('1','157',247145,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'556',1328944.80,1328944.80,'556','2021-12-18 21:28:36','611','2021-12-19 08:23:01',10,0),('1','157',247265,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'556',953804.25,953804.25,'556','2021-12-19 13:17:19','611','2021-12-19 13:43:56',10,0),('1','157',247346,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'556',781492.50,781492.50,'556','2021-12-19 18:31:34','611','2021-12-19 18:37:59',10,0),('1','157',247426,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'556',365479.65,365479.65,'556','2021-12-20 13:37:19','611','2021-12-20 13:40:22',10,0),('1','157',247557,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'556',16432.35,16432.35,'556','2021-12-20 18:33:32','611','2021-12-20 18:47:30',10,0),('1','157',247734,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'556',2032328.40,2032328.40,'556','2021-12-21 14:15:54','611','2021-12-21 14:18:56',10,0),('1','157',247812,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'556',1195329.45,1195329.45,'556','2021-12-21 19:55:26','611','2021-12-21 20:15:41',10,0),('1','157',247884,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'556',1383057.90,1383057.90,'556','2021-12-22 13:49:33','611','2021-12-22 13:52:05',10,0),('1','157',248091,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'556',1286802.45,1286802.45,'556','2021-12-22 21:58:22','611','2021-12-22 22:22:29',10,0),('1','157',248132,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'556',1222161.75,1222161.75,'556','2021-12-23 12:25:10','611','2021-12-23 12:28:48',10,0),('1','157',248355,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'556',1342412.10,1342412.10,'556','2021-12-23 19:44:28','611','2021-12-23 19:58:32',10,0),('1','157',248376,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'556',955722.90,955722.90,'556','2021-12-24 15:09:50','611','2021-12-24 20:24:23',10,0),('1','157',248600,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'556',995307.15,995307.15,'556','2021-12-24 20:31:49','611','2021-12-25 07:38:00',10,0),('1','157',248706,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'556',1727686.50,1727686.50,'556','2021-12-25 12:34:40','611','2021-12-25 13:32:17',10,0),('1','157',248822,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'556',376883.70,376883.70,'556','2021-12-25 18:19:42','611','2021-12-25 18:28:18',10,0),('1','157',248854,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',249121,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',249440,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'556',810772.05,810772.05,'556','2021-12-28 13:18:32','611','2021-12-28 13:31:41',10,0),('1','157',249558,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'556',798014.10,798014.10,'556','2021-12-28 22:32:21','611','2021-12-28 22:38:25',10,0),('1','157',249628,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'556',539451.60,539451.60,'556','2021-12-29 12:32:23','611','2021-12-29 14:51:31',10,0),('1','157',249775,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'556',849073.50,849073.50,'556','2021-12-29 23:17:56','611','2021-12-30 06:37:08',10,0),('1','157',249900,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'556',830161.26,830161.26,'556','2021-12-30 13:14:03','611','2021-12-30 13:17:31',10,0),('1','157',249991,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'556',1003878.15,1003878.15,'556','2021-12-31 06:29:10','611','2021-12-31 06:33:59',10,0),('1','157',250114,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'556',760998.00,760998.00,'556','2021-12-31 13:44:28','611','2021-12-31 14:30:48',10,0),('1','157',250259,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'556',1119988.65,1119988.65,'556','2022-01-01 07:20:37','611','2022-01-01 08:11:42',10,0),('1','157',250383,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'556',1248693.75,1248693.75,'556','2022-01-01 14:16:43','611','2022-01-01 15:33:49',10,0),('1','157',250545,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',250546,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'556',818342.85,818342.85,'556','2022-01-02 00:30:03','611','2022-01-02 09:40:55',10,0),('1','157',250655,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'556',1236679.05,1236679.05,'556','2022-01-02 14:13:53','611','2022-01-02 14:19:20',10,0),('1','157',250730,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'556',521339.10,521339.10,'556','2022-01-02 22:31:26','611','2022-01-03 07:20:08',10,0),('1','157',250835,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'556',689987.40,689987.40,'556','2022-01-03 12:25:03','611','2022-01-03 13:39:06',10,0),('1','157',250954,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'556',832993.35,832993.35,'556','2022-01-03 17:53:22','611','2022-01-03 18:07:22',10,0),('1','157',251006,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'556',1335846.30,1335846.30,'556','2022-01-04 14:44:04','611','2022-01-04 14:46:50',10,0),('1','157',251236,'AFTERNOON','2022-01-04','2022-01-04 00:00:00',NULL,'556',1400678.85,1400678.85,'556','2022-01-04 20:32:15','611','2022-01-05 05:12:23',10,0),('1','157',251297,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'556',591862.65,591862.65,'556','2022-01-05 15:06:38','611','2022-01-05 15:33:26',10,0),('1','157',251498,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'556',689632.05,689632.05,'556','2022-01-06 07:06:12','611','2022-01-06 07:11:35',10,0),('1','157',251519,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'556',885324.60,885324.60,'556','2022-01-06 14:12:13','611','2022-01-06 14:22:03',10,0),('1','157',251703,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'556',624342.30,624342.30,'556','2022-01-07 03:53:53','611','2022-01-07 08:07:34',10,0),('1','157',251879,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'556',565672.80,565672.80,'556','2022-01-07 14:21:00','611','2022-01-07 15:32:28',10,0),('1','157',251976,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'556',808897.50,808897.50,'556','2022-01-08 07:23:22','611','2022-01-08 11:19:37',10,0),('1','157',252144,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'556',649959.60,649959.60,'556','2022-01-08 15:06:30','611','2022-01-08 17:04:13',10,0),('1','157',252215,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'556',688771.50,688771.50,'556','2022-01-09 08:55:46','611','2022-01-09 11:27:44',10,0),('1','157',252387,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'556',561715.05,561715.05,'556','2022-01-09 17:14:29','611','2022-01-09 19:14:00',10,0),('1','157',252429,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'556',809663.25,809663.25,'556','2022-01-09 21:14:22','611','2022-01-09 23:00:01',10,0),('1','157',252490,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'556',890698.05,890698.05,'556','2022-01-10 16:26:31','611','2022-01-10 18:53:19',10,0),('1','157',252716,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'556',1322265.45,1322265.45,'556','2022-01-11 07:16:26','611','2022-01-11 09:35:56',10,0),('1','157',252793,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'556',1350421.05,1350421.05,'556','2022-01-11 16:29:02','611','2022-01-11 22:05:58',10,0),('1','157',253033,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'556',1249827.15,1249827.15,'556','2022-01-12 09:26:34','611','2022-01-12 09:54:33',10,0),('1','157',253088,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'556',966063.15,966063.15,'556','2022-01-12 14:02:11','611','2022-01-12 14:58:25',10,0),('1','157',253237,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'556',953473.50,953473.50,'556','2022-01-13 09:19:27','611','2022-01-13 10:10:32',10,0),('1','157',253411,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'556',946113.90,946113.90,'556','2022-01-13 17:53:10','611','2022-01-13 18:47:34',10,0),('1','157',253416,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'556',1111335.30,1111335.30,'556','2022-01-13 21:02:50','611','2022-01-13 22:24:32',10,0),('1','157',253611,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'556',923730.60,923730.60,'556','2022-01-14 15:12:51','611','2022-01-14 15:16:20',10,0),('1','157',253669,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'556',1375723.20,1375723.20,'556','2022-01-14 20:40:05','611','2022-01-14 22:23:54',10,0),('1','157',253692,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'556',1242115.80,1242115.80,'556','2022-01-15 14:49:02','611','2022-01-15 15:03:03',10,0),('1','157',253935,'AFTERNOON','2022-01-15','2022-01-15 00:00:00',NULL,'556',1359305.85,1359305.85,'556','2022-01-16 00:06:43','611','2022-01-16 09:20:01',10,0),('1','157',254007,'MORNING','2022-01-16','2022-01-16 00:00:00',NULL,'556',643781.10,643781.10,'556','2022-01-16 15:24:20','611','2022-01-16 16:26:44',10,0),('1','157',254123,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'556',765919.05,765919.05,'556','2022-01-17 00:06:56','611','2022-01-17 07:20:27',10,0),('1','157',254227,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'556',832399.80,832399.80,'556','2022-01-17 15:03:52','611','2022-01-17 15:09:11',10,0),('1','157',254376,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'556',976232.25,976232.25,'556','2022-01-17 19:28:43','611','2022-01-17 20:57:35',10,0),('1','157',254497,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'556',394560.15,394560.15,'556','2022-01-18 13:10:35','611','2022-01-18 14:16:43',10,0),('1','157',254790,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'556',24489.50,24489.50,'556','2022-01-19 10:40:16','611','2022-01-19 13:28:57',10,0),('1','157',254832,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'556',5001.50,5001.50,'556','2022-01-19 15:00:24','611','2022-01-19 15:52:26',10,0),('1','157',254925,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'556',13853.00,13853.00,'556','2022-01-20 12:40:03','611','2022-01-20 13:22:32',10,0),('1','157',255091,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'556',256504.50,256504.50,'556','2022-01-20 14:24:13','611','2022-01-20 16:12:56',10,0),('1','157',255238,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'556',23299.50,23299.50,'556','2022-01-21 09:17:50','611','2022-01-21 13:17:20',10,0),('1','157',255312,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'556',88142.95,88142.95,'556','2022-01-21 13:25:50','611','2022-01-21 19:55:05',10,0),('1','157',255477,'AFTERNOON','2022-01-21','2022-01-21 00:00:00',NULL,'556',19003.15,19003.15,'556','2022-01-22 07:49:16','611','2022-01-22 09:42:55',10,0),('1','157',255627,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'556',928841.30,928841.30,'556','2022-01-22 17:13:35','611','2022-01-22 17:16:21',10,0),('1','157',255656,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'556',451284.90,451284.90,'556','2022-01-23 01:17:37','611','2022-01-23 09:08:52',10,0),('1','157',255757,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'556',821980.45,821980.45,'556','2022-01-23 13:55:54','611','2022-01-23 17:23:01',10,0),('1','157',255886,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'556',820015.65,820015.65,'556','2022-01-23 23:04:48','611','2022-01-24 00:33:32',10,0),('1','157',256012,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'556',1225630.50,1225630.50,'556','2022-01-24 14:36:33','611','2022-01-24 15:12:36',10,0),('1','157',256183,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'556',1849673.75,1849673.75,'556','2022-01-24 22:35:34','611','2022-01-25 00:29:44',10,0),('1','157',256275,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'556',1484591.45,1484591.45,'556','2022-01-25 14:47:28','611','2022-01-25 16:48:00',10,0),('1','157',256465,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'556',1097652.45,1097652.45,'556','2022-01-26 05:33:51','611','2022-01-26 06:22:24',10,0),('1','157',256497,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'556',1771826.15,1771826.15,'556','2022-01-26 14:39:16','611','2022-01-26 15:17:40',10,0),('1','157',256646,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'556',1649372.70,1649372.70,'556','2022-01-26 20:37:55','611','2022-01-27 06:37:53',10,0),('1','157',256733,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'556',1773579.00,1773579.00,'556','2022-01-27 16:13:17','611','2022-01-27 16:17:46',10,0),('1','157',256933,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'556',1904796.70,1904796.70,'556','2022-01-27 22:29:33','611','2022-01-28 07:28:47',10,0),('1','157',257020,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'556',2321025.55,2321025.55,'556','2022-01-28 15:26:18','611','2022-01-28 16:03:17',10,0),('1','157',257188,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'556',1058343.75,1058343.75,'556','2022-01-29 00:21:30','611','2022-01-29 09:39:51',10,0),('1','157',257293,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'556',1906076.70,1906076.70,'556','2022-01-29 15:41:22','611','2022-01-29 16:32:11',10,0),('1','157',257466,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'556',1565781.45,1565781.45,'556','2022-01-30 00:10:04','611','2022-01-30 09:37:32',10,0),('1','157',257546,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'556',616243.35,616243.35,'556','2022-01-30 14:56:58','611','2022-01-30 15:27:41',10,0),('1','157',257547,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'556',835147.50,835147.50,'556','2022-01-31 09:57:17','611','2022-01-31 11:12:05',10,0),('1','157',257548,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'556',1347448.95,1347448.95,'556','2022-01-31 14:24:41','611','2022-01-31 14:30:19',10,0),('1','157',257549,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'556',2739368.25,2739368.25,'556','2022-01-31 22:04:39','611','2022-02-01 06:26:02',10,0),('1','157',257550,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'556',2498065.80,2498065.80,'556','2022-02-01 14:52:22','611','2022-02-01 14:59:22',10,0),('1','157',257551,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'556',1857093.75,1857093.75,'556','2022-02-02 00:49:57','611','2022-02-02 01:50:21',10,0),('1','157',257552,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'556',1556609.85,1556609.85,'556','2022-02-02 15:22:53','611','2022-02-02 16:21:45',10,0),('1','157',257553,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'556',1325806.80,1325806.80,'556','2022-02-02 21:00:10','611','2022-02-03 08:29:05',10,0),('1','157',257554,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'556',2350529.25,2350529.25,'556','2022-02-03 17:41:43','611','2022-02-03 17:48:18',10,0),('1','157',257555,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'556',1612191.45,1612191.45,'556','2022-02-04 00:45:48','611','2022-02-04 07:26:00',10,0),('1','157',257556,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'556',1837177.50,1837177.50,'556','2022-02-04 15:45:07','611','2022-02-04 21:44:05',10,0),('1','157',257557,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'556',2009206.35,2009206.35,'556','2022-02-05 01:00:17','611','2022-02-05 08:08:47',10,0),('1','157',257558,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'556',2273080.50,2273080.50,'556','2022-02-05 15:34:31','611','2022-02-05 15:47:51',10,0),('1','157',257559,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'556',434029.65,434029.65,'556','2022-02-06 01:41:18','611','2022-02-06 09:37:33',10,0),('1','157',257560,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'556',161408.80,161408.80,'556','2022-02-06 19:57:43','611','2022-02-06 20:00:37',10,0),('1','157',257561,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'556',19748.60,19748.60,'556','2022-02-07 00:09:11','611','2022-02-07 08:32:02',10,0),('1','157',257562,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'556',604074.60,604074.60,'556','2022-02-07 15:47:22','611','2022-02-07 15:52:44',10,0),('1','157',257563,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'556',81798.80,81798.80,'556','2022-02-08 01:06:18','611','2022-02-08 07:08:17',10,0),('1','157',257564,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'556',44596.80,44596.80,'556','2022-02-08 13:59:22','611','2022-02-08 18:17:13',10,0),('1','157',257565,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'556',38904.40,38904.40,'556','2022-02-09 08:34:34','611','2022-02-09 08:45:55',10,0),('1','157',257566,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'556',51078.30,51078.30,'556','2022-02-09 13:23:43','611','2022-02-09 15:08:38',10,0),('1','157',257567,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'556',24371.10,24371.10,'556','2022-02-10 08:07:10','611','2022-02-10 13:02:44',10,0),('1','157',257568,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'556',88998.00,88998.00,'556','2022-02-10 14:58:17','611','2022-02-10 15:15:56',10,0),('1','157',257569,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'556',591914.70,591914.70,'556','2022-02-11 08:39:51','611','2022-02-11 09:45:24',10,0),('1','157',257570,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'556',118142.70,118142.70,'556','2022-02-11 13:46:41','611','2022-02-11 14:58:43',10,0),('1','157',257571,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'556',89809.20,89809.20,'556','2022-02-11 22:18:44','611','2022-02-12 07:23:10',10,0),('1','157',257572,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'556',79244.10,79244.10,'556','2022-02-12 18:11:44','611','2022-02-12 18:29:14',10,0),('1','157',257573,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'556',400000.00,400000.00,'556','2022-02-13 02:11:21','611','2022-02-13 06:49:59',10,0),('1','157',257574,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'556',1593290.60,1593290.60,'556','2022-02-13 17:12:12','611','2022-02-13 18:36:17',10,0),('1','157',257575,'AFTERNOON SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'556',108939.60,108939.60,'556','2022-02-14 12:40:04','611','2022-02-14 12:57:38',10,0),('1','157',257576,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'556',902265.65,902265.65,'556','2022-02-14 14:06:43','611','2022-02-14 14:18:06',10,0),('1','157',257577,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'556',324659.15,324659.15,'556','2022-02-14 18:54:29','611','2022-02-14 23:54:44',10,0),('1','157',257578,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',257579,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'556',635989.20,635989.20,'556','2022-02-15 14:59:01','611','2022-02-15 16:28:26',10,0),('1','157',257580,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'556',1567530.05,1567530.05,'556','2022-02-15 19:19:11','611','2022-02-15 20:02:10',10,0),('1','157',257581,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'556',2412263.95,2412263.95,'556','2022-02-16 07:45:42','611','2022-02-16 08:01:45',10,0),('1','157',257582,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'556',1350441.30,1350441.30,'556','2022-02-16 16:55:10','611','2022-02-16 16:57:53',10,0),('1','157',257583,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',257584,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'556',3342176.50,3342176.50,'556','2022-02-17 09:50:42','611','2022-02-17 11:51:50',10,0),('1','157',257585,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'556',3866101.55,3866101.55,'556','2022-02-17 18:20:39','611','2022-02-17 19:37:29',10,0),('1','157',257586,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'556',1711242.75,1711242.75,'556','2022-02-18 18:13:00','611','2022-02-19 07:22:19',10,0),('1','157',257587,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'556',757663.50,757663.50,'556','2022-02-19 12:23:39','611','2022-02-19 17:28:44',10,0),('1','157',257588,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'556',2034879.90,2034879.90,'556','2022-02-19 17:48:17','611','2022-02-19 20:51:15',10,0),('1','157',257589,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'556',1203174.25,1203174.25,'556','2022-02-20 11:06:16','611','2022-02-20 12:11:18',10,0),('1','157',257590,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'556',1339362.80,1339362.80,'556','2022-02-20 17:03:00','611','2022-02-20 18:25:46',10,0),('1','157',257591,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'556',1159905.05,1159905.05,'556','2022-02-20 20:21:47','611','2022-02-21 10:59:20',10,0),('1','157',257592,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','157',257593,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'556',1846172.60,1846172.60,'556','2022-02-21 12:56:21','611','2022-02-21 13:13:22',10,0),('1','157',257594,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'556',819237.40,819237.40,'556','2022-02-21 21:39:40','611','2022-02-22 10:23:56',10,0),('1','157',257595,'MORNING SHIFT','2022-02-22','2022-02-22 14:15:07','2022-02-23 14:15:07','556',397810.70,397810.70,'556','2022-02-22 14:18:11','611','2022-02-22 15:31:13',10,0),('1','157',257596,'AFTERNOON SHIFT','2022-02-22','2022-02-23 09:32:16','2022-02-24 09:32:16','556',422476.30,422476.30,'556','2022-02-23 11:15:49','611','2022-02-23 12:30:44',10,0),('1','157',257597,'MORNING SHIFT','2022-02-23','2022-02-24 08:32:26','2022-02-25 08:32:26','556',156697.90,156697.90,'556','2022-02-24 08:49:28','454','2022-02-24 10:11:47',10,0),('1','157',257598,'AFTERNOON SHIFT','2022-02-23','2022-02-24 10:32:05','2022-02-25 10:32:05','556',53680.25,53680.25,'556','2022-02-24 11:15:06','611','2022-02-24 11:27:37',10,0),('1','157',257599,'MORNING SHIFT','2022-02-24','2022-02-24 13:05:38','2022-02-25 13:05:38','556',96798.75,96798.75,'556','2022-02-24 14:31:32','611','2022-02-24 15:04:53',10,0),('1','157',257600,'AFTERNOON SHIFT ','2022-02-24','2022-02-25 12:13:10','2022-02-26 12:13:10','556',75310.05,75310.05,'556','2022-02-25 12:21:27','611','2022-02-25 16:23:33',10,0),('1','157',257601,'MORNING SHIFT','2022-02-25','2022-02-26 12:02:28','2022-02-27 12:02:28','556',214422.20,214422.20,'556','2022-02-26 13:03:38','454','2022-02-26 14:31:28',10,0),('1','157',257602,'AFTERNOON SHIFT','2022-02-25','2022-02-26 14:40:45','2022-02-27 14:40:45','556',61399.25,61399.25,'556','2022-02-26 14:41:48','454','2022-02-26 15:51:47',10,0),('1','157',257603,'MORNING SHIFT ','2022-02-26','2022-02-26 16:07:46','2022-02-27 16:07:46','556',1253270.70,1253270.70,'556','2022-02-26 18:38:04','611','2022-02-26 20:03:36',10,0),('1','157',257604,'AFTERNOON SHIFT','2022-02-26','2022-02-26 21:00:27','2022-02-27 21:00:27','556',947795.10,947795.10,'556','2022-02-28 10:33:10','454','2022-02-28 11:21:34',10,0),('1','157',257605,'AFTERNOON SHIFT','2022-02-28','2022-03-01 08:49:22','2022-03-02 08:49:22','556',1232495.55,1232495.55,'556','2022-03-01 15:28:56','611','2022-03-01 19:30:18',10,0),('1','157',257606,'MORNING SHIFT','2022-03-01','2022-03-02 23:10:28','2022-03-03 23:10:28','556',1560677.55,1560677.55,'556','2022-03-03 12:24:38','611','2022-03-03 12:29:57',10,0),('1','157',257607,'AFTERNOON SHIFT','2022-03-01','2022-03-03 12:39:27','2022-03-04 12:39:27','556',1756510.47,1756510.47,'556','2022-03-03 12:43:17','611','2022-03-03 12:56:21',10,0),('1','157',257608,'MORNING SHIFT','2022-03-02','2022-03-03 13:17:08','2022-03-04 13:17:08','556',1551075.90,1551075.90,'556','2022-03-03 18:48:09','611','2022-03-04 07:15:28',10,0),('1','157',257609,'AFTERNOON SHIFT','2022-03-02','2022-03-04 12:36:07','2022-03-05 12:36:07','556',1469547.75,1469547.75,'556','2022-03-04 12:51:55','611','2022-03-04 13:35:15',10,0),('1','157',257610,'MORNING SHIFT','2022-03-03','2022-03-05 10:13:05','2022-03-06 10:13:05','556',1048446.30,1048446.30,'556','2022-03-05 10:22:07','611','2022-03-05 10:38:00',10,0),('1','157',257611,'AFTERNOON SHIFT','2022-03-03','2022-03-05 10:42:33','2022-03-06 10:42:33','556',2931927.90,2931927.90,'556','2022-03-05 10:45:01','454','2022-03-05 11:13:34',10,0),('1','157',257612,'MORNING SHIFT','2022-03-04','2022-03-05 11:24:30','2022-03-06 11:24:30','556',542409.45,542409.45,'556','2022-03-05 11:29:49','611','2022-03-05 11:30:26',10,0),('1','157',257613,'AFTERNOON SHIFT','2022-03-04','2022-03-05 11:33:21','2022-03-06 11:33:21','556',3145938.90,3145938.90,'556','2022-03-06 13:14:34','611','2022-03-06 14:05:08',10,0),('1','157',257614,'MORNING SHIFT','2022-03-05','2022-03-06 14:55:16','2022-03-07 14:55:16','556',2549604.15,2549604.15,'556','2022-03-08 11:52:51','611','2022-03-08 12:00:35',10,0),('1','157',257615,'AFTERNOON SHIFT','2022-03-05','2022-03-08 12:05:25','2022-03-09 12:05:25','556',748722.15,748722.15,'556','2022-03-08 12:30:57','611','2022-03-08 12:34:24',10,0),('1','157',257616,'MORNING SHIFT','2022-03-06','2022-03-08 13:20:13','2022-03-09 13:20:13','556',1719700.95,1719700.95,'556','2022-03-08 13:25:52','611','2022-03-08 13:29:07',10,0),('1','157',257617,'AFTERNOON SHIFT','2022-03-06','2022-03-08 13:32:39','2022-03-09 13:32:39','556',1472357.70,1472357.70,'556','2022-03-08 13:35:49','611','2022-03-08 13:38:15',10,0),('1','157',257618,'MORNING SHIFT','2022-03-07','2022-03-08 13:49:20','2022-03-09 13:49:20','556',2747311.20,2747311.20,'556','2022-03-08 13:59:29','611','2022-03-08 14:04:38',10,0),('1','157',257619,'AFTERNOON SHIFT','2022-03-07','2022-03-08 19:56:53','2022-03-09 19:56:53','556',1382962.35,1382962.35,'556','2022-03-10 19:30:24','611','2022-03-10 21:02:06',10,0),('1','157',257620,'MORNING SHIFT','2022-03-08','2022-03-11 00:43:01','2022-03-12 00:43:01','556',2114498.10,2114498.10,'556','2022-03-11 11:17:33','611','2022-03-11 11:19:36',10,0),('1','157',257621,'AFTERNOON SHIFT','2022-03-08','2022-03-11 11:23:28','2022-03-12 11:23:28','556',2367870.45,2367870.45,'556','2022-03-11 11:29:45','454','2022-03-11 11:30:53',10,0),('1','157',257622,'MORNING SHIFT','2022-03-09','2022-03-11 11:31:24','2022-03-12 11:31:24','556',2505364.95,2505364.95,'556','2022-03-11 11:33:01','611','2022-03-11 11:34:03',10,0),('1','157',257623,'AFTERNOON SHIFT','2022-03-09','2022-03-11 11:36:32','2022-03-12 11:36:32','556',215595.60,215595.60,'556','2022-03-11 11:51:34','454','2022-03-11 12:04:51',10,0),('1','157',257624,'MORNING SHIFT','2022-03-10','2022-03-11 12:06:07','2022-03-12 12:06:07','556',2024084.70,2024084.70,'556','2022-03-11 12:08:16','454','2022-03-11 15:11:12',10,0),('1','157',257625,'AFTERNOON SHIFT','2022-03-10','2022-03-11 15:11:56','2022-03-12 15:11:56','556',0.00,0.00,'556','2022-03-11 15:12:19','454','2022-03-11 15:40:01',10,0),('1','157',257626,'AFTERNOON SHIFT','2022-03-10','2022-03-11 17:06:44','2022-03-12 17:06:44','556',1130551.95,1130551.95,'556','2022-03-13 20:46:54','454','2022-03-14 10:43:19',10,0),('1','157',257627,'AFTERNOON SHIFT','2022-03-10','2022-03-14 10:43:48','2022-03-15 10:43:48','556',90000.00,90000.00,'556','2022-03-14 10:44:18','454','2022-03-14 10:45:37',10,0),('1','157',257628,'MORNING SHIFT','2022-03-11','2022-03-14 10:46:49','2022-03-15 10:46:49','556',1654169.55,1654169.55,'556','2022-03-14 10:48:36','454','2022-03-14 10:49:59',10,0),('1','157',257629,'AFTERNOON SHIFT','2022-03-11','2022-03-14 10:50:32','2022-03-15 10:50:32','556',2318373.75,2318373.75,'556','2022-03-14 11:03:14','454','2022-03-14 11:04:34',10,0),('1','157',257630,'MORNING SHIFT','2022-03-12','2022-03-14 11:05:15','2022-03-15 11:05:15','556',2307442.50,2307442.50,'556','2022-03-14 11:06:56','454','2022-03-14 11:23:29',10,0),('1','157',257631,'AFTERNOON SHIFT','2022-03-12','2022-03-14 11:24:03','2022-03-15 11:24:03','556',2128821.75,2128821.75,'556','2022-03-14 11:37:06','454','2022-03-14 11:38:45',10,0),('1','157',257632,'MORNING SHIFT','2022-03-13','2022-03-14 11:39:11','2022-03-15 11:39:11','556',2482231.35,2482231.35,'556','2022-03-14 17:24:43','611','2022-03-15 07:55:34',10,0),('1','157',257633,'AFTERNOON SHIFT','2022-03-13','2022-03-15 09:11:15','2022-03-16 09:11:15','556',649143.00,649143.00,'556','2022-03-15 09:14:55','454','2022-03-15 09:23:08',10,0),('1','157',257634,'MORNING SHIFT','2022-03-16','2022-03-17 11:18:35','2022-03-18 11:18:35','556',2422018.50,2422018.50,'556','2022-03-17 11:21:01','611','2022-03-17 11:37:37',10,0),('1','157',257635,'AFTERNOON SHIFT','2022-03-16','2022-03-17 11:42:03','2022-03-18 11:42:03','556',2506003.50,2506003.50,'556','2022-03-17 11:44:22','454','2022-03-17 11:58:14',10,0),('1','157',257636,'MORNING SHIFT','2022-03-17','2022-03-17 12:14:59','2022-03-18 12:14:59','556',584669.25,584669.25,'556','2022-03-17 17:48:50','454','2022-03-18 09:20:59',10,0),('1','157',257637,'AFTERNOON SHIFT','2022-03-17','2022-03-18 11:06:08','2022-03-19 11:06:08','556',1522860.90,1522860.90,'556','2022-03-18 14:26:08','611','2022-03-18 18:53:33',10,0),('1','157',257638,'MORNING SHIFT','2022-03-18','2022-03-18 22:39:28','2022-03-19 22:39:28','556',988948.95,988948.95,'556','2022-03-21 08:58:54','454','2022-03-21 10:24:34',10,0),('1','157',257639,'AFTERNOON SHIFT','2022-03-18','2022-03-21 10:28:56','2022-03-22 10:28:56','556',533892.15,533892.15,'556','2022-03-21 10:42:32','454','2022-03-21 11:02:25',10,0),('1','157',257640,'AFTERNOON SHIFT','2022-03-22','2022-03-22 16:26:25','2022-03-23 16:26:25','556',2019159.45,2019159.45,'556','2022-03-23 12:52:07','611','2022-03-23 12:53:40',10,0),('1','157',257641,'MORNING SHIFT','2022-03-23','2022-03-23 17:29:42','2022-03-24 17:29:42','556',1940763.00,1940763.00,'556','2022-03-23 17:32:07','611','2022-03-23 22:07:09',10,0),('1','157',257642,'AFTERNOON SHIFT','2022-03-23','2022-03-24 11:41:18','2022-03-25 11:41:18','556',1965546.00,1965546.00,'556','2022-03-24 11:53:30','611','2022-03-25 11:39:49',10,0),('1','157',257643,'MORNING SHIFT','2022-03-24','2022-03-25 12:45:02','2022-03-26 12:45:02','556',1493053.65,1493053.65,'556','2022-03-25 17:15:44','611','2022-03-25 17:36:45',10,0),('1','157',257644,'AFTERNOON SHIFT','2022-03-24','2022-03-26 13:40:20','2022-03-27 13:40:20','556',1716633.60,1716633.60,'556','2022-03-26 14:03:19','611','2022-03-26 21:11:22',10,0),('1','157',257645,'MORNING SHIFT','2022-03-25','2022-03-27 13:38:57','2022-03-28 13:38:57','556',1942315.65,1942315.65,'556','2022-03-27 13:42:10','611','2022-03-27 14:04:47',10,0),('1','157',257646,'AFTERNOON SHIFT','2022-03-25','2022-03-27 14:07:42','2022-03-28 14:07:42','556',2091178.65,2091178.65,'556','2022-03-27 14:15:09','611','2022-03-27 14:18:00',10,0),('1','157',257647,'MORNING SHIFT','2022-03-26','2022-03-27 14:18:48','2022-03-28 14:18:48','556',1906726.80,1906726.80,'556','2022-03-27 14:23:56','611','2022-03-27 14:26:42',10,0),('1','157',257648,'AFTERNOON SHIFT','2022-03-26','2022-03-28 12:41:42','2022-03-29 12:41:42','556',1531970.55,1531970.55,'556','2022-03-28 12:55:12','454','2022-03-28 14:00:58',10,0),('1','157',257649,'MORNING SHIFT','2022-03-27','2022-03-29 12:49:37','2022-03-30 12:49:37','556',1139724.30,1139724.30,'556','2022-03-29 12:51:49','454','2022-03-29 13:44:41',10,0),('1','157',257650,'AFTERNOON SHIFT','2022-03-27','2022-03-29 16:57:21','2022-03-30 16:57:21','556',949012.35,949012.35,'556','2022-03-29 16:58:45','611','2022-03-30 07:37:58',10,0),('1','157',257651,'MORNING SHIFT','2022-03-28','2022-03-30 11:35:40','2022-03-31 11:35:40','556',1839118.05,1839118.05,'556','2022-03-30 11:44:07','611','2022-03-30 12:31:13',10,0),('1','157',257652,'AFTERNOON SHIFT','2022-03-28','2022-03-30 13:31:49','2022-03-31 13:31:49','556',1985555.55,1985555.55,'556','2022-03-30 13:33:54','454','2022-03-30 15:47:32',10,0),('1','157',257653,'MORNING SHIFT','2022-03-30','2022-03-30 18:48:48','2022-03-31 18:48:48','556',0.00,0.00,'556','2022-03-30 18:50:11','611','2022-03-30 18:52:16',10,0),('1','157',257654,'MORNING SHIFT','2022-03-29','2022-03-31 10:30:39','2022-04-01 10:30:39','556',1679307.30,1679307.30,'556','2022-03-31 10:32:31','454','2022-03-31 11:01:14',10,0),('1','157',257655,'AFTERNOON SHIFT','2022-03-29','2022-03-31 11:02:09','2022-04-01 11:02:09','556',1673967.90,1673967.90,'556','2022-03-31 11:04:52','454','2022-03-31 11:06:58',10,0),('1','157',257656,'MORNING SHIFT','2022-03-30','2022-03-31 11:07:38','2022-04-01 11:07:38','556',1630025.10,1630025.10,'556','2022-03-31 11:08:43','454','2022-03-31 11:10:07',10,0),('1','157',257657,'AFTERNOON SHIFT','2022-03-30','2022-03-31 11:10:37','2022-04-01 11:10:37','556',1275875.70,1275875.70,'556','2022-03-31 11:11:38','454','2022-03-31 11:12:56',10,0),('1','157',257658,'MORNING SHIFT','2022-03-31','2022-03-31 11:14:34','2022-04-01 11:14:34','556',1649597.40,1649597.40,'556','2022-03-31 16:23:11','611','2022-04-01 12:13:21',10,0),('1','157',257659,'AFTERNOON SHIFT','2022-03-31','2022-04-01 15:11:20','2022-04-02 15:11:20','556',1405126.80,1405126.80,'556','2022-04-02 12:04:08','611','2022-04-02 12:28:32',10,0),('1','157',257660,'MORNING SHIFT','2022-04-01','2022-04-02 12:32:39','2022-04-03 12:32:39','556',1711901.40,1711901.40,'556','2022-04-02 12:34:22','611','2022-04-02 12:42:13',10,0),('1','157',257661,'AFTERNOON SHIFT','2022-04-01','2022-04-03 11:23:25','2022-04-04 11:23:25','556',827768.70,827768.70,'556','2022-04-03 11:26:51','611','2022-04-03 11:35:42',10,0),('1','157',257662,'MORNING SHIFT','2022-04-02','2022-04-03 11:36:33','2022-04-04 11:36:33','556',1955485.95,1955485.95,'556','2022-04-03 11:37:35','611','2022-04-03 11:38:41',10,0),('1','157',257663,'AFTERNOON SHIFT','2022-04-02','2022-04-03 11:42:26','2022-04-04 11:42:26','556',1579559.85,1579559.85,'556','2022-04-03 11:48:04','611','2022-04-03 15:33:19',10,0),('1','157',257664,'MORNING SHIFT','2022-04-03','2022-04-03 18:31:35','2022-04-04 18:31:35','556',1306354.50,1306354.50,'556','2022-04-03 18:34:50','454','2022-04-04 12:04:36',10,0),('1','157',257665,'AFTERNOON SHIFT','2022-04-03','2022-04-05 07:06:01','2022-04-06 07:06:01','556',1081084.95,1081084.95,'556','2022-04-05 08:51:46','611','2022-04-05 08:55:42',10,0),('1','157',257666,'MORNING SHIFT','2022-04-04','2022-04-05 09:03:50','2022-04-06 09:03:50','556',1076501.25,1076501.25,'556','2022-04-05 09:04:44','611','2022-04-05 10:03:34',10,0),('1','157',257667,'AFTERNOON SHIFT','2022-04-04','2022-04-05 10:07:04','2022-04-06 10:07:04','556',1135081.20,1135081.20,'556','2022-04-05 10:08:53','611','2022-04-05 10:13:01',10,0),('1','157',257668,'MORNING SHIFT','2022-04-05','2022-04-05 10:18:26','2022-04-06 10:18:26','556',1374880.65,1374880.65,'556','2022-04-05 14:54:43','611','2022-04-05 14:59:58',10,0),('1','157',257669,'AFTERNOON SHIFT','2022-04-05','2022-04-05 21:40:42','2022-04-06 21:40:42','556',1244073.60,1244073.60,'556','2022-04-06 18:01:39','611','2022-04-06 18:05:10',10,0),('1','157',257670,'MORNING SHIFT','2022-04-06','2022-04-06 18:09:41','2022-04-07 18:09:41','556',1618339.80,1618339.80,'556','2022-04-07 12:04:31','454','2022-04-07 12:16:36',10,0),('1','157',257671,'AFTERNOON SHIFT','2022-04-06','2022-04-07 14:26:54','2022-04-08 14:26:54','556',1456687.65,1456687.65,'556','2022-04-07 14:30:05','611','2022-04-08 06:40:16',10,0),('1','157',257672,'MORNING SHIFT','2022-04-07','2022-04-08 12:37:14','2022-04-09 12:37:14','556',1436372.85,1436372.85,'556','2022-04-08 12:44:05','611','2022-04-08 12:49:21',10,0),('1','157',257673,'AFTERNOON SHIFT','2022-04-07','2022-04-08 12:51:07','2022-04-09 12:51:07','556',1117982.25,1117982.25,'556','2022-04-08 13:51:54','611','2022-04-09 08:15:16',10,0),('1','157',257674,'MORNING SHIFT','2022-04-08','2022-04-09 10:13:07','2022-04-10 10:13:07','556',969544.95,969544.95,'556','2022-04-09 10:26:02','611','2022-04-09 10:37:55',10,0),('1','157',257675,'AFTERNOON SHIFT','2022-04-08','2022-04-09 16:30:25','2022-04-10 16:30:25','556',759004.95,759004.95,'556','2022-04-10 09:06:22','611','2022-04-10 09:10:31',10,0),('1','157',257676,'MORNING SHIFT','2022-04-09','2022-04-10 09:11:37','2022-04-11 09:11:37','556',985175.40,985175.40,'556','2022-04-10 09:19:19','611','2022-04-10 09:21:20',10,0),('1','157',257677,'AFTERNOON SHIFT','2022-04-09','2022-04-10 09:21:58','2022-04-11 09:21:58','556',930078.60,930078.60,'556','2022-04-10 09:23:04','611','2022-04-10 09:28:45',10,0),('1','157',257678,'MORNING SHIFT','2022-04-10','2022-04-10 17:12:46','2022-04-11 17:12:46','556',1194184.20,1194184.20,'556','2022-04-10 17:15:57','611','2022-04-11 07:16:39',10,0),('1','157',257679,'AFTERNOON SHIFT','2022-04-10','2022-04-11 09:30:55','2022-04-12 09:30:55','556',1413718.35,1413718.35,'556','2022-04-11 09:36:48','611','2022-04-11 13:10:52',10,0),('1','157',257680,'MORNING SHIFT','2022-04-11','2022-04-11 14:05:27','2022-04-12 14:05:27','556',1458491.10,1458491.10,'556','2022-04-11 14:08:40','611','2022-04-11 17:11:31',10,0),('1','157',257681,'AFTERNOON SHIFT','2022-04-11','2022-04-11 19:17:24','2022-04-12 19:17:24','556',1595487.30,1595487.30,'556','2022-04-12 16:26:00','611','2022-04-12 16:33:43',10,0),('1','157',257682,'AFTERNOON SHIFT','2022-04-12','2022-04-12 16:45:42','2022-04-13 16:45:42','556',1003609.20,1003609.20,'556','2022-04-12 17:21:57','454','2022-04-13 09:40:16',10,0),('1','157',257683,'AFTERNOON SHIFT','2022-04-12','2022-04-13 17:14:33','2022-04-14 17:14:33','556',1074303.45,1074303.45,'556','2022-04-14 10:15:18','454','2022-04-14 10:33:08',10,0),('1','157',257684,'MORNING SHIFT','2022-04-13','2022-04-14 10:39:09','2022-04-15 10:39:09','556',1055311.95,1055311.95,'556','2022-04-14 10:51:32','611','2022-04-14 11:30:41',10,0),('1','157',257685,'AFTERNOON SHIFT','2022-04-13','2022-04-14 11:45:00','2022-04-15 11:45:00','556',1259893.80,1259893.80,'556','2022-04-14 11:47:19','611','2022-04-14 14:01:05',10,0),('1','157',257686,'MORNING SHIFT','2022-04-14','2022-04-14 14:18:45','2022-04-15 14:18:45','556',1560814.20,1560814.20,'556','2022-04-14 14:21:52','611','2022-04-15 07:04:17',10,0),('1','157',257687,'AFTERNOON SHIFT','2022-04-14','2022-04-15 14:32:38','2022-04-16 14:32:38','556',1384044.75,1384044.75,'556','2022-04-15 14:35:46','611','2022-04-15 16:38:48',10,0),('1','157',257688,'MORNING SHIFT','2022-04-15','2022-04-15 16:40:30','2022-04-16 16:40:30','556',1416562.95,1416562.95,'556','2022-04-15 17:07:59','611','2022-04-16 09:56:10',10,0),('1','157',257689,'AFTERNOON SHIFT','2022-04-16','2022-04-16 11:01:02','2022-04-17 11:01:02','556',973557.75,973557.75,'556','2022-04-16 11:04:28','611','2022-04-16 16:22:08',10,0),('1','157',257690,'MORNING SHIFT','2022-04-16','2022-04-17 09:04:12','2022-04-18 09:04:12','556',2383862.25,2383862.25,'556','2022-04-17 09:16:59','611','2022-04-17 09:56:47',10,0),('1','157',257691,'MORNING SHIFT','2022-04-17','2022-04-18 07:35:08','2022-04-19 07:35:08','556',1541392.05,1541392.05,'556','2022-04-18 07:43:12','611','2022-04-18 10:59:18',10,0),('1','157',257692,'MORNING SHIFT','2022-04-18','2022-04-18 17:05:39','2022-04-19 17:05:39','556',1774657.50,1774657.50,'556','2022-04-19 07:00:53','611','2022-04-19 08:08:31',10,0),('1','157',257693,'MORNING SHIFT','2022-04-19','2022-04-19 12:19:19','2022-04-20 12:19:19','556',921853.35,921853.35,'556','2022-04-20 06:30:05','611','2022-04-20 08:27:17',10,0),('1','157',257694,'MORNING SHIFT','2022-04-20','2022-04-20 12:33:33','2022-04-21 12:33:33','556',2460158.25,2460158.25,'556','2022-04-20 18:39:45','611','2022-04-21 07:07:02',10,0),('1','157',257695,'MORNING SHIFT','2022-04-21','2022-04-21 07:41:55','2022-04-22 07:41:55','556',794288.55,794288.55,'556','2022-04-22 08:14:28','611','2022-04-22 17:45:37',10,0),('1','157',257696,'MORNING SHIFT','2022-04-22','2022-04-22 18:35:43','2022-04-23 18:35:43','556',3041217.30,3041217.30,'556','2022-04-22 19:18:01','611','2022-04-23 06:58:36',10,0),('1','157',257697,'MORNING SHIFT','2022-04-23','2022-04-23 09:45:51','2022-04-24 09:45:51','556',1934085.45,1934085.45,'556','2022-04-24 06:03:43','611','2022-04-24 10:53:24',10,0),('1','157',257698,'MORNING SHIFT','2022-04-24','2022-04-24 14:22:01','2022-04-25 14:22:01','556',430473.45,430473.45,'556','2022-04-24 18:02:09','611','2022-04-24 19:42:44',10,0),('1','157',257699,'MORNING SHIFT','2022-04-26','2022-04-26 17:46:44','2022-04-27 17:46:44','556',270053.85,270053.85,'556','2022-04-27 07:34:56','611','2022-04-27 14:21:37',10,0),('1','157',257700,'FULL DAY SHIFT','2022-04-27','2022-04-27 17:00:51','2022-04-28 17:00:51','556',1462502.25,1462502.25,'556','2022-04-27 22:05:16','611','2022-04-28 14:13:19',10,0),('1','157',257701,'Full day shift','2022-04-28','2022-04-28 15:35:30','2022-04-29 15:35:30','556',2409985.05,2409985.05,'556','2022-04-28 19:32:11','611','2022-04-30 10:35:19',10,0),('1','157',257702,'FULL DAY SHIFT','2022-04-29','2022-04-30 10:53:42','2022-05-01 10:53:42','556',1179825.90,1179825.90,'556','2022-04-30 10:58:29','611','2022-04-30 11:04:07',10,0),('1','157',257703,'FULL DAY SHIFT','2022-04-30','2022-04-30 11:05:33','2022-05-01 11:05:33','556',2656194.75,2656194.75,'556','2022-04-30 20:11:44','611','2022-05-01 14:52:53',10,0),('1','157',257704,'FULL DAY SHIFT','2022-05-01','2022-05-01 15:03:53','2022-05-02 15:03:53','556',1309522.50,1309522.50,'556','2022-05-01 19:39:54','611','2022-05-01 23:02:24',10,0),('1','157',257705,'FULL DAY SHIFT','2022-05-02','2022-05-02 09:57:03','2022-05-03 09:57:03','556',1729962.30,1729962.30,'556','2022-05-02 23:46:04','611','2022-05-03 08:01:54',10,0),('1','157',257706,'Full day shift','2022-05-03','2022-05-03 14:42:37','2022-05-04 14:42:37','556',2341651.95,2341651.95,'556','2022-05-03 19:59:59','611','2022-05-04 00:40:21',10,0),('1','157',257707,'FULL DAY SHIFT','2022-05-04','2022-05-04 08:59:49','2022-05-05 08:59:49','556',1522072.20,1522072.20,'556','2022-05-05 06:00:38','611','2022-05-05 08:50:07',10,0),('1','157',257708,'FULL DAY SHIFT','2022-05-05','2022-05-05 18:26:44','2022-05-06 18:26:44','556',1516029.90,1516029.90,'556','2022-05-05 20:59:04','611','2022-05-06 09:03:29',10,0),('1','157',257709,'FULL DAY SHIFT','2022-05-06','2022-05-06 11:52:47','2022-05-07 11:52:47','556',1778399.70,1778399.70,'556','2022-05-07 05:40:02','454','2022-05-07 10:16:09',10,0),('1','157',257710,'Full day shift','2022-05-07','2022-05-07 14:07:42','2022-05-08 14:07:42','556',2920878.18,2920878.18,'556','2022-05-08 06:16:01','611','2022-05-08 11:19:42',10,0),('1','157',257711,'Full day shift','2022-05-08','2022-05-08 16:11:56','2022-05-09 16:11:56','556',1822165.95,1822165.95,'556','2022-05-08 17:50:51','611','2022-05-09 06:53:12',10,0),('1','157',257712,'FULL DAY SHIFT','2022-05-11','2022-05-11 15:01:02','2022-05-12 15:01:02','556',2018349.30,2018349.30,'556','2022-05-11 20:21:26','611','2022-05-12 09:32:00',10,0),('1','157',257713,'FULL DAY SHIFT','2022-05-12','2022-05-12 11:01:18','2022-05-13 11:01:18','556',1541695.65,1541695.65,'556','2022-05-12 13:32:02','611','2022-05-12 22:38:09',10,0),('1','157',257714,'Full day shift','2022-05-13','2022-05-13 10:24:17','2022-05-14 10:24:17','556',2305147.35,2305147.35,'556','2022-05-14 09:09:23','611','2022-05-14 13:31:39',10,0),('1','157',257715,'Full day shift','2022-05-14','2022-05-14 18:32:57','2022-05-15 18:32:57','556',2984561.25,2984561.25,'556','2022-05-15 07:15:04','611','2022-05-15 11:34:45',10,0),('1','157',257716,'FULL DAY SHIFT','2022-05-15','2022-05-15 13:59:05','2022-05-16 13:59:05','556',3890561.40,3890561.40,'556','2022-05-15 21:22:33','611','2022-05-16 08:32:35',10,0),('1','157',257717,'FULL DAY SHIFT','2022-05-16','2022-05-16 09:41:50','2022-05-17 09:41:50','556',2334898.50,2334898.50,'556','2022-05-17 09:59:54','611','2022-05-17 11:41:15',10,0),('1','157',257718,'FULL DAY SHIFT','2022-05-17','2022-05-17 12:35:27','2022-05-18 12:35:27','556',2558044.50,2558044.50,'556','2022-05-18 07:39:00','611','2022-05-18 11:38:34',10,0),('1','157',257719,'FULL DAY SHIFT','2022-05-18','2022-05-18 13:40:11','2022-05-19 13:40:11','556',2063536.20,2063536.20,'556','2022-05-18 21:29:40','611','2022-05-19 10:22:25',10,0),('1','157',257720,'FULL DAY SHIFT','2022-05-19','2022-05-19 11:59:51','2022-05-20 11:59:51','556',2979579.90,2979579.90,'556','2022-05-19 20:02:33','454','2022-05-20 09:46:16',10,0),('1','157',257721,'FULL DAY SHIFT','2022-05-20','2022-05-20 11:33:48','2022-05-21 11:33:48','556',2828717.10,2828717.10,'556','2022-05-21 07:30:01','454','2022-05-21 09:59:48',10,0),('1','157',257722,'FULL DAY SHIFT','2022-05-21','2022-05-21 10:17:32','2022-05-22 10:17:32','556',3072773.55,3072773.55,'556','2022-05-21 19:21:47','611','2022-05-21 19:39:30',10,0),('1','157',257723,'Full day shift','2022-05-22','2022-05-22 12:10:57','2022-05-23 12:10:57','556',2014811.70,2014811.70,'556','2022-05-22 19:32:08','611','2022-05-23 08:21:26',10,0),('1','157',257724,'FULL DAY SHIFT','2022-05-23','2022-05-23 08:42:43','2022-05-24 08:42:43','556',2665619.55,2665619.55,'556','2022-05-23 20:12:29','611','2022-05-24 06:59:57',10,0),('1','157',257725,'Full day shift','2022-05-24','2022-05-24 09:25:41','2022-05-25 09:25:41','556',985112.70,985112.70,'556','2022-05-24 14:40:36','611','2022-05-24 21:56:30',10,0),('1','157',257726,'FULL DAY SHIFT','2022-05-28','2022-05-28 14:05:49','2022-05-29 14:05:49','556',1582366.50,1582366.50,'556','2022-05-29 06:34:43','611','2022-05-29 08:54:19',10,0),('1','157',257727,'FULL DAY SHIFT','2022-05-29','2022-05-29 11:05:16','2022-05-30 11:05:16','556',3806178.75,3806178.75,'556','2022-05-29 20:44:22','611','2022-05-30 07:30:40',10,0),('1','157',257728,'FULL DAY SHIFT','2022-05-30','2022-05-30 08:42:52','2022-05-31 08:42:52','556',4431033.75,4431033.75,'556','2022-05-30 19:26:04','611','2022-05-31 08:45:22',10,0),('1','157',257729,'FULL DAY SHIFT','2022-05-31','2022-05-31 10:33:38','2022-06-01 10:33:38','556',4548357.00,4548357.00,'556','2022-05-31 20:03:58','611','2022-06-01 09:32:28',10,0),('1','157',257730,'FULL DAY SHIFT','2022-06-01','2022-06-01 11:59:32','2022-06-02 11:59:32','556',3987979.05,3987979.05,'556','2022-06-02 07:45:32','611','2022-06-02 09:05:46',10,0),('1','157',257731,'FULL DAY SHIFT','2022-06-02','2022-06-02 13:24:44','2022-06-03 13:24:44','556',4946827.05,4946827.05,'556','2022-06-02 20:09:07','611','2022-06-03 10:38:06',10,0),('1','157',257732,'Full day shift','2022-06-03','2022-06-03 14:38:48','2022-06-04 14:38:48','556',1484254.20,1484254.20,'556','2022-06-04 06:56:26','611','2022-06-04 12:00:40',10,0),('1','157',257733,'FULL DAY SHIFT','2022-06-04','2022-06-04 12:58:53','2022-06-05 12:58:53','556',2504929.35,2504929.35,'556','2022-06-04 15:35:17','611','2022-06-06 06:29:26',10,0),('1','157',257734,'Full day shift','2022-06-05','2022-06-06 06:31:35','2022-06-07 06:31:35','556',948834.15,948834.15,'556','2022-06-06 07:14:14','611','2022-06-06 08:17:32',10,0),('1','157',257735,'FULL DAY SHIFT','2022-06-06','2022-06-06 11:35:04','2022-06-07 11:35:04','556',2964625.95,2964625.95,'556','2022-06-06 17:32:37','611','2022-06-07 06:33:08',10,0),('1','157',257736,'FULL DAY SHIFT','2022-06-08','2022-06-08 11:22:30','2022-06-09 11:22:30','556',1499556.30,1499556.30,'556','2022-06-08 20:18:08','454','2022-06-09 09:59:53',10,0),('1','157',257737,'Full day shift','2022-06-09','2022-06-09 10:21:17','2022-06-10 10:21:17','556',4092445.50,4092445.50,'556','2022-06-09 21:28:21','611','2022-06-10 06:15:56',10,0),('1','157',257738,'Full day shift','2022-06-10','2022-06-10 10:12:47','2022-06-11 10:12:47','556',2459062.65,2459062.65,'556','2022-06-10 20:28:11','611','2022-06-11 12:29:36',10,0),('1','157',257739,'Full day shift','2022-06-11','2022-06-11 14:06:07','2022-06-12 14:06:07','556',3259995.75,3259995.75,'556','2022-06-11 20:16:45','611','2022-06-12 09:40:07',10,0),('1','157',257740,'Full day shift by','2022-06-12','2022-06-12 12:22:03','2022-06-13 12:22:03','556',1320394.35,1320394.35,'556','2022-06-12 16:24:28','611','2022-06-12 20:18:49',10,0),('1','157',257741,'Full day shift','2022-06-13','2022-06-13 07:36:04','2022-06-14 07:36:04','556',0.00,0.00,'556','2022-06-14 14:20:05','611','2022-06-14 14:23:01',10,0),('1','157',257742,'FULL DAY SHIFT','2022-06-14','2022-06-14 17:19:16','2022-06-15 17:19:16','556',520378.65,520378.65,'556','2022-06-14 20:24:50','611','2022-06-15 09:03:01',10,0),('1','157',257743,'Full day shift','2022-06-15','2022-06-15 10:15:42','2022-06-16 10:15:42','556',3336889.05,3336889.05,'556','2022-06-16 08:08:15','611','2022-06-16 08:58:53',10,0),('1','157',257744,'FULL DAY SHIFT','2022-06-16','2022-06-16 10:02:37','2022-06-17 10:02:37','556',3958049.70,3958049.70,'556','2022-06-16 20:42:16','454','2022-06-17 10:33:08',10,0),('1','157',257745,'FULL DAY SHIFT','2022-06-17','2022-06-17 11:12:10','2022-06-18 11:12:10','556',1620618.45,1620618.45,'556','2022-06-17 20:58:13','611','2022-06-18 06:46:38',10,0),('1','157',257746,'FULL DAY SHIFT','2022-06-18','2022-06-18 08:56:04','2022-06-19 08:56:04','556',2854443.90,2854443.90,'556','2022-06-18 16:58:48','611','2022-06-18 17:03:26',10,0),('1','157',257747,'FULL DAY SHIFT','2022-06-19','2022-06-19 13:24:02','2022-06-20 13:24:02','556',2105594.70,2105594.70,'556','2022-06-19 20:04:59','611','2022-06-20 08:09:42',10,0),('1','157',257748,'Full day shift','2022-06-20','2022-06-20 10:18:47','2022-06-21 10:18:47','556',2417891.85,2417891.85,'556','2022-06-21 07:28:00','611','2022-06-21 07:54:37',10,0),('1','157',257749,'Full day shift','2022-06-21','2022-06-21 10:14:44','2022-06-22 10:14:44','556',2125338.60,2125338.60,'556','2022-06-21 20:57:21','611','2022-06-22 08:48:59',10,0),('1','157',257750,'FULL DAY SHIFT','2022-06-22','2022-06-22 09:45:20','2022-06-23 09:45:20','556',2801518.50,2801518.50,'556','2022-06-22 16:59:02','611','2022-06-23 08:13:00',10,0),('1','157',257751,'FULL DAY SHIFT','2022-06-23','2022-06-23 20:23:31','2022-06-24 20:23:31','556',2208805.50,2208805.50,'556','2022-06-23 20:28:39','611','2022-06-24 08:36:59',10,0),('1','157',257752,'FULL DAY SHIFT','2022-06-24','2022-06-24 10:06:45','2022-06-25 10:06:45','556',643082.55,643082.55,'556','2022-06-24 22:01:48','611','2022-06-25 06:58:53',10,0),('1','157',257753,'FULL DAY SHIFT','2022-06-25','2022-06-25 09:35:23','2022-06-26 09:35:23','556',2891496.30,2891496.30,'556','2022-06-25 19:46:15','611','2022-06-26 08:00:25',10,0),('1','157',257754,'Full day shift','2022-06-26','2022-06-26 09:50:43','2022-06-27 09:50:43','556',4197190.80,4197190.80,'556','2022-06-26 20:07:58','611','2022-06-27 09:03:21',10,0),('1','157',257755,'Full day shift','2022-06-27','2022-06-27 09:56:21','2022-06-28 09:56:21','556',4246959.75,4246959.75,'556','2022-06-27 20:02:02','611','2022-06-28 09:31:22',10,0),('1','157',257756,'FULL DAY SHIFT','2022-06-28','2022-06-28 10:02:09','2022-06-29 10:02:09','556',1169942.40,1169942.40,'556','2022-06-28 17:13:37','611','2022-06-29 07:06:53',10,0),('1','157',257757,'Full day shift','2022-06-29','2022-06-29 19:03:30','2022-06-30 19:03:30','556',0.00,0.00,'556','2022-06-30 13:14:54','611','2022-06-30 13:16:41',10,0),('1','157',257758,'FULL DAY SHIFT','2022-06-30','2022-06-30 13:17:48','2022-07-01 13:17:48','556',2373545.25,2373545.25,'556','2022-06-30 20:57:24','611','2022-07-01 09:22:43',10,0),('1','157',257759,'FULL DAY SHIFT','2022-07-01','2022-07-01 10:37:52','2022-07-02 10:37:52','556',2646184.40,2646184.40,'556','2022-07-02 06:25:56','611','2022-07-02 10:19:18',10,0),('1','157',257760,'FULL DAY SHIFT','2022-07-02','2022-07-02 15:57:46','2022-07-03 15:57:46','556',0.00,0.00,'556','2022-07-03 09:42:58','611','2022-07-03 12:00:12',10,0),('1','157',257761,'Full day shift','2022-07-03','2022-07-03 14:42:18','2022-07-04 14:42:18','556',1066359.10,1066359.10,'556','2022-07-03 19:06:34','611','2022-07-04 07:36:04',10,0),('1','157',257762,'FULL DAY SHIFT','2022-07-04','2022-07-04 14:13:20','2022-07-05 14:13:20','556',1977798.90,1977798.90,'556','2022-07-04 19:53:57','611','2022-07-05 10:10:23',10,0),('1','157',257763,'FULL DAY SHIFT','2022-07-05','2022-07-05 11:15:59','2022-07-06 11:15:59','556',4400653.85,4400653.85,'556','2022-07-06 07:48:37','611','2022-07-06 08:41:50',10,0),('1','157',257764,'Full day shift','2022-07-06','2022-07-06 13:57:07','2022-07-07 13:57:07','556',4752053.50,4752053.50,'556','2022-07-07 05:54:31','611','2022-07-07 08:29:17',10,0),('1','157',257765,'Full day shift','2022-07-07','2022-07-07 14:30:57','2022-07-08 14:30:57','556',1484475.30,1484475.30,'556','2022-07-08 07:51:27','611','2022-07-08 09:28:48',10,0),('1','157',257766,'MORNING SHIFT','2022-07-08','2022-07-08 10:42:50','2022-07-09 10:42:50','556',1515851.15,1515851.15,'556','2022-07-08 11:23:01','611','2022-07-08 12:07:47',10,0),('1','157',257767,'AFTERNOON SHIFT','2022-07-08','2022-07-08 12:15:56','2022-07-09 12:15:56','556',3812217.35,3812217.35,'556','2022-07-08 21:14:44','611','2022-07-09 08:14:47',10,0),('1','157',257768,'FULL DAY SHIFT','2022-07-09','2022-07-09 09:52:41','2022-07-10 09:52:41','556',2040258.00,2040258.00,'556','2022-07-10 08:24:56','611','2022-07-10 09:17:57',10,0),('1','157',257769,'Full day shift','2022-07-11','2022-07-11 19:37:32','2022-07-12 19:37:32','556',1012716.20,1012716.20,'556','2022-07-11 21:04:27','611','2022-07-12 12:16:19',10,0),('1','157',257770,'FULL DAY SHIFT','2022-07-14','2022-07-14 17:25:45','2022-07-15 17:25:45','556',1152943.55,1152943.55,'556','2022-07-15 06:56:56','611','2022-07-15 07:50:57',10,0),('1','157',257771,'FULL DAY SHIFT','2022-07-15','2022-07-15 11:34:02','2022-07-16 11:34:02','556',648771.85,648771.85,'556','2022-07-15 20:13:29','611','2022-07-16 08:00:08',10,0),('1','157',257772,'FULL DAY SHIFT','2022-07-16','2022-07-16 13:48:47','2022-07-17 13:48:47','556',1751000.40,1751000.40,'556','2022-07-17 07:24:26','611','2022-07-17 08:46:32',10,0),('1','157',257773,'Full day shift','2022-07-17','2022-07-17 10:54:16','2022-07-18 10:54:16','556',1676249.85,1676249.85,'556','2022-07-17 20:18:58','611','2022-07-17 23:10:03',10,0),('1','157',257774,'Full day shift','2022-07-18','2022-07-18 12:04:36','2022-07-19 12:04:36','556',1218295.65,1218295.65,'556','2022-07-19 08:23:35','611','2022-07-19 09:43:26',10,0),('1','157',257775,'FULL DAY SHIFT','2022-07-19','2022-07-19 10:49:31','2022-07-20 10:49:31','556',0.00,0.00,'556','2022-07-20 06:46:49','611','2022-07-20 06:48:57',10,0),('1','157',257776,'FULL DAY SHIFT','2022-07-19','2022-07-20 06:53:26','2022-07-21 06:53:26','556',1915320.40,1915320.40,'556','2022-07-20 06:56:07','454','2022-07-20 09:28:44',10,0),('1','157',257777,'FULL DAY SHIFT','2022-07-20','2022-07-20 14:13:16','2022-07-21 14:13:16','556',1365344.75,1365344.75,'556','2022-07-21 07:43:42','611','2022-07-21 07:54:59',10,0),('1','157',257778,'FULL DAY SHIFT','2022-07-21','2022-07-21 17:35:12','2022-07-22 17:35:12','556',804220.65,804220.65,'556','2022-07-21 19:38:08','611','2022-07-22 09:18:21',10,0),('1','157',257779,'FULL DAY SHIFT','2022-07-22','2022-07-22 16:23:42','2022-07-23 16:23:42','556',83964.60,83964.60,'556','2022-07-22 20:45:30','611','2022-07-23 07:15:29',10,0),('1','157',257780,'FULL DAY SHIFT','2022-07-23','2022-07-23 14:04:14','2022-07-24 14:04:14','556',1227460.10,1227460.10,'556','2022-07-23 20:04:26','611','2022-07-24 10:39:15',10,0),('1','157',257781,'FULL DAY SHIFT','2022-07-24','2022-07-24 14:22:01','2022-07-25 14:22:01','556',2992216.50,2992216.50,'556','2022-07-25 06:22:29','611','2022-07-25 11:48:13',10,0),('1','157',257782,'FULL DAY SHIFT','2022-07-25','2022-07-25 13:00:28','2022-07-26 13:00:28','556',4487823.80,4487823.80,'556','2022-07-25 22:32:14','454','2022-07-26 09:37:33',10,0),('1','157',257783,'FULL DAY SHIFT','2022-07-26','2022-07-26 17:48:33','2022-07-27 17:48:33','556',2469396.90,2469396.90,'556','2022-07-27 06:20:34','611','2022-07-27 07:06:26',10,0),('1','157',257784,'FULL DAY SHIFT','2022-07-27','2022-07-27 10:40:49','2022-07-28 10:40:49','556',4349339.75,4349339.75,'556','2022-07-28 07:11:52','454','2022-07-28 09:46:37',10,0),('1','157',257785,'FULL DAY SHIFT','2022-07-28','2022-07-28 12:33:20','2022-07-29 12:33:20','556',6765834.30,6765834.30,'556','2022-07-28 23:25:11','611','2022-07-29 10:09:36',10,0),('1','157',257786,'Full day shift','2022-07-29','2022-07-29 13:51:41','2022-07-30 13:51:41','556',4866839.35,4866839.35,'556','2022-07-30 07:06:02','611','2022-07-30 08:31:41',10,0),('1','157',257787,'FULL DAY SHIFT','2022-07-31','2022-07-31 09:15:20','2022-08-01 09:15:20','556',1793348.10,1793348.10,'556','2022-07-31 21:13:50','611','2022-08-01 07:34:21',10,0),('1','157',257788,'FULL DAY SHIFT','2022-08-01','2022-08-01 16:54:12','2022-08-02 16:54:12','556',583466.85,583466.85,'556','2022-08-02 08:41:08','611','2022-08-02 08:46:35',10,0),('1','157',257789,'FULL DAY','2022-08-02','2022-08-02 17:40:50','2022-08-03 17:40:50','556',1378757.90,1378757.90,'556','2022-08-02 20:05:34','611','2022-08-02 22:01:02',10,0),('1','157',257790,'Full day shift','2022-08-03','2022-08-03 10:20:55','2022-08-04 10:20:55','556',2815499.75,2815499.75,'556','2022-08-03 22:25:32','454','2022-08-04 11:11:17',10,0),('1','157',257791,'FULL DAY SHIFT','2022-08-04','2022-08-04 12:34:44','2022-08-05 12:34:44','556',5970137.85,5970137.85,'556','2022-08-05 10:57:41','611','2022-08-05 12:00:12',10,0),('1','157',257792,'Full day shift','2022-08-05','2022-08-05 15:22:18','2022-08-06 15:22:18','556',7299858.30,7299858.30,'556','2022-08-06 07:46:51','454','2022-08-06 11:15:39',10,0),('1','157',257793,'FULL DAY SHIFT','2022-08-06','2022-08-06 14:24:32','2022-08-07 14:24:32','556',7247746.30,7247746.30,'556','2022-08-07 06:33:27','611','2022-08-07 10:37:02',10,0),('1','157',257794,'FULL DAY SHIFT','2022-08-07','2022-08-07 11:07:28','2022-08-08 11:07:28','556',4846668.90,4846668.90,'556','2022-08-08 07:15:59','611','2022-08-08 11:34:11',10,0),('1','157',257795,'FULL DAY SHIFT','2022-08-08','2022-08-08 11:49:10','2022-08-09 11:49:10','556',2278106.10,2278106.10,'556','2022-08-09 07:52:07','454','2022-08-09 10:05:59',10,0),('1','157',257796,'Full day shift','2022-08-09','2022-08-09 11:01:37','2022-08-10 11:01:37','556',2715740.40,2715740.40,'556','2022-08-10 07:08:46','454','2022-08-10 10:01:38',10,0),('1','157',257797,'Full day shift','2022-08-10','2022-08-10 12:01:21','2022-08-11 12:01:21','556',2690462.85,2690462.85,'556','2022-08-11 07:47:15','611','2022-08-11 09:52:23',10,0),('1','157',257798,'FULL DAY SHIFT','2022-08-11','2022-08-11 11:24:53','2022-08-12 11:24:53','556',2706255.75,2706255.75,'556','2022-08-12 07:49:42','454','2022-08-12 09:44:47',10,0),('1','157',257799,'Full day shift','2022-08-12','2022-08-12 11:16:27','2022-08-13 11:16:27','556',2325032.25,2325032.25,'556','2022-08-13 07:42:53','611','2022-08-13 08:28:08',10,0),('1','157',257800,'Full day shift','2022-08-13','2022-08-13 11:15:37','2022-08-14 11:15:37','556',3477086.40,3477086.40,'556','2022-08-13 21:10:48','611','2022-08-14 08:46:54',10,0),('1','157',257801,'FULL DAY SHIFT','2022-08-14','2022-08-14 19:54:57','2022-08-15 19:54:57','556',1057129.50,1057129.50,'556','2022-08-14 20:13:39','611','2022-08-15 00:04:19',10,0),('1','157',257802,'Full day shift','2022-08-15','2022-08-15 12:55:12','2022-08-16 12:55:12','556',1239564.25,1239564.25,'556','2022-08-16 08:04:36','611','2022-08-16 09:32:45',10,0),('1','157',257803,'Full day shift1','2022-08-16','2022-08-16 09:56:51','2022-08-17 09:56:51','556',2878569.70,2878569.70,'556','2022-08-17 06:22:40','611','2022-08-17 07:15:05',10,0),('1','157',257804,'FULL DAY SHIFT','2022-08-17','2022-08-17 12:16:42','2022-08-18 12:16:42','556',1513434.50,1513434.50,'556','2022-08-18 07:49:22','611','2022-08-18 11:38:56',10,0),('1','157',257805,'FULL DAY SHIFT','2022-08-18','2022-08-18 14:13:16','2022-08-19 14:13:16','556',2573569.25,2573569.25,'556','2022-08-19 06:27:49','611','2022-08-19 09:27:49',10,0),('1','157',257806,'FULL DAY SHIFT','2022-08-19','2022-08-19 19:45:32','2022-08-20 19:45:32','556',2990762.50,2990762.50,'556','2022-08-20 07:18:33','611','2022-08-20 07:37:32',10,0),('1','157',257807,'Full day shift','2022-08-20','2022-08-20 12:04:16','2022-08-21 12:04:16','556',2793854.75,2793854.75,'556','2022-08-20 20:21:11','611','2022-08-21 06:57:28',10,0),('1','157',257808,'Full day shift','2022-08-21','2022-08-21 08:13:28','2022-08-22 08:13:28','556',1931847.75,1931847.75,'556','2022-08-22 07:52:01','611','2022-08-22 09:40:14',10,0),('1','157',257809,'FULL DAY SHIFT','2022-08-22','2022-08-22 10:00:48','2022-08-23 10:00:48','556',1934089.50,1934089.50,'556','2022-08-23 07:35:58','611','2022-08-23 08:22:42',10,0),('1','157',257810,'FULL DAY SHIFT','2022-08-23','2022-08-23 14:20:33','2022-08-24 14:20:33','556',1707575.50,1707575.50,'556','2022-08-24 07:18:46','454','2022-08-24 09:38:16',10,0),('1','157',257811,'FULL DAY SHIFT','2022-08-24','2022-08-24 13:27:15','2022-08-25 13:27:15','556',1365386.75,1365386.75,'556','2022-08-25 06:39:35','611','2022-08-25 08:39:07',10,0),('1','157',257812,'FULL DAY SHIFT','2022-08-25','2022-08-25 20:09:41','2022-08-26 20:09:41','556',1549374.25,1549374.25,'556','2022-08-26 08:53:45','611','2022-08-26 08:56:00',10,0),('1','157',257813,'FULL DAY SHIFT','2022-08-26','2022-08-26 14:03:32','2022-08-27 14:03:32','556',1877444.00,1877444.00,'556','2022-08-27 08:24:23','611','2022-08-27 17:32:12',10,0),('1','157',257814,'Full day shift','2022-08-27','2022-08-27 18:36:39','2022-08-28 18:36:39','556',3434753.25,3434753.25,'556','2022-08-28 08:57:13','611','2022-08-28 12:53:28',10,0),('1','157',257815,'FULL DAY SHIFT','2022-08-28','2022-08-28 15:31:29','2022-08-29 15:31:29','556',4442102.25,4442102.25,'556','2022-08-29 06:09:30','611','2022-08-29 08:37:14',10,0),('1','157',257816,'Full day shift','2022-08-29','2022-08-29 11:52:54','2022-08-30 11:52:54','556',2583678.00,2583678.00,'556','2022-08-29 20:08:28','611','2022-08-29 20:09:42',10,0),('1','157',257817,'Full day shift','2022-08-30','2022-08-30 14:02:52','2022-08-31 14:02:52','556',2114993.50,2114993.50,'556','2022-08-31 07:44:40','611','2022-08-31 08:10:59',10,0),('1','157',257818,'FULL DAY SHIFT','2022-08-31','2022-08-31 17:59:10','2022-09-01 17:59:10','556',2519476.00,2519476.00,'556','2022-08-31 20:42:40','611','2022-08-31 20:56:11',10,0),('1','157',257819,'Full day shift','2022-09-01','2022-09-01 10:25:58','2022-09-02 10:25:58','556',2400452.75,2400452.75,'556','2022-09-02 08:16:02','611','2022-09-02 09:35:11',10,0),('1','157',257820,'Full day shift','2022-09-02','2022-09-02 14:07:39','2022-09-03 14:07:39','556',2261647.50,2261647.50,'556','2022-09-03 08:23:55','611','2022-09-03 09:20:31',10,0),('1','157',257821,'Full day shift','2022-09-03','2022-09-03 12:39:22','2022-09-04 12:39:22','556',2694027.25,2694027.25,'556','2022-09-03 19:57:52','611','2022-09-03 20:37:09',10,0),('1','157',257822,'Full day shift','2022-09-04','2022-09-04 11:30:34','2022-09-05 11:30:34','556',2989813.00,2989813.00,'556','2022-09-04 20:33:37','611','2022-09-05 07:18:49',10,0),('1','157',257823,'Full day shift','2022-09-05','2022-09-05 14:04:58','2022-09-06 14:04:58','556',2536057.50,2536057.50,'556','2022-09-06 07:50:49','611','2022-09-06 09:20:34',10,0),('1','157',257824,'Full day shift','2022-09-06','2022-09-06 12:46:32','2022-09-07 12:46:32','556',3017070.00,3017070.00,'556','2022-09-07 08:20:06','611','2022-09-07 09:09:21',10,0),('1','157',257825,'Full day shift','2022-09-07','2022-09-07 14:06:52','2022-09-08 14:06:52','556',2589515.25,2589515.25,'556','2022-09-08 06:48:36','611','2022-09-08 07:10:05',10,0),('1','157',257826,'Full day shift','2022-09-08','2022-09-08 10:57:18','2022-09-09 10:57:18','556',1735805.50,1735805.50,'556','2022-09-09 09:16:37','454','2022-09-09 09:40:01',10,0),('1','157',257827,'Full day shift','2022-09-09','2022-09-09 15:38:10','2022-09-10 15:38:10','556',1872349.25,1872349.25,'556','2022-09-10 07:22:14','611','2022-09-10 07:31:24',10,0),('1','157',257828,'FULL DAY SHIFT','2022-09-10','2022-09-10 11:09:44','2022-09-11 11:09:44','556',1622349.50,1622349.50,'556','2022-09-11 08:39:14','611','2022-09-11 16:44:44',10,0),('1','157',257829,'Full day shift','2022-09-11','2022-09-11 16:49:16','2022-09-12 16:49:16','556',2222851.00,2222851.00,'556','2022-09-11 20:02:39','611','2022-09-12 06:54:10',10,0),('1','157',257830,'Full day shift','2022-09-12','2022-09-12 14:14:59','2022-09-13 14:14:59','556',3024942.00,3024942.00,'556','2022-09-13 06:21:25','611','2022-09-13 07:17:49',10,0),('1','157',257831,'Full day shift','2022-09-13','2022-09-13 08:49:11','2022-09-14 08:49:11','556',2820568.00,2820568.00,'556','2022-09-14 06:49:28','611','2022-09-14 06:51:28',10,0),('1','157',257832,'Full day shift','2022-09-14','2022-09-14 10:50:17','2022-09-15 10:50:17','556',3353805.00,3353805.00,'556','2022-09-15 07:21:32','611','2022-09-15 07:50:34',10,0),('1','157',257833,'FULL DAY SHIFT','2022-09-15','2022-09-15 12:45:37','2022-09-16 12:45:37','556',1653000.00,1653000.00,'556','2022-09-16 05:57:50','611','2022-09-16 07:46:49',10,0),('1','157',257834,'Full day shift we','2022-09-16','2022-09-16 14:06:58','2022-09-17 14:06:58','556',1645245.25,1645245.25,'556','2022-09-17 07:22:58','611','2022-09-17 07:39:05',10,0),('1','157',257835,'FULL DAY SHIFT','2022-09-17','2022-09-17 10:49:43','2022-09-18 10:49:43','556',2277972.00,2277972.00,'556','2022-09-18 08:51:00','611','2022-09-18 11:28:06',10,0),('1','157',257836,'Full day shift','2022-09-18','2022-09-18 12:23:27','2022-09-19 12:23:27','556',1326997.00,1326997.00,'556','2022-09-19 08:30:06','611','2022-09-19 15:23:35',10,0),('1','157',257837,'FULL DAY SHIFT','2022-09-19','2022-09-19 15:32:44','2022-09-20 15:32:44','556',1404156.25,1404156.25,'556','2022-09-20 07:31:20','611','2022-09-20 09:54:45',10,0),('1','157',257838,'Full day shift','2022-09-20','2022-09-20 11:34:51','2022-09-21 11:34:51','556',1456087.50,1456087.50,'556','2022-09-21 06:14:59','611','2022-09-21 08:48:49',10,0),('1','157',257839,'Full day shift','2022-09-21','2022-09-21 12:19:48','2022-09-22 12:19:48','556',1682598.75,1682598.75,'556','2022-09-22 09:23:57','611','2022-09-22 09:48:43',10,0),('1','157',257840,'Full day shift','2022-09-22','2022-09-22 10:50:06','2022-09-23 10:50:06','556',1243555.25,1243555.25,'556','2022-09-23 09:57:58','611','2022-09-23 14:22:23',10,0),('1','157',257841,'FULL DAY SHIFT','2022-09-23','2022-09-23 15:40:04','2022-09-24 15:40:04','556',1033254.25,1033254.25,'556','2022-09-24 06:26:05','611','2022-09-24 08:52:15',10,0),('1','157',257842,'Full day shift','2022-09-24','2022-09-24 12:23:58','2022-09-25 12:23:58','556',2091929.00,2091929.00,'556','2022-09-25 07:36:38','611','2022-09-25 08:57:12',10,0),('1','157',257843,'FULL DAY SHIFT','2022-09-25','2022-09-25 13:35:50','2022-09-26 13:35:50','556',2550909.00,2550909.00,'556','2022-09-26 07:07:03','611','2022-09-26 11:23:30',10,0),('1','157',257844,'Full day shift','2022-09-26','2022-09-26 12:16:21','2022-09-27 12:16:21','556',1574218.00,1574218.00,'556','2022-09-27 08:22:10','611','2022-09-27 11:54:57',10,0),('1','157',257845,'FULL DAY SHIFT','2022-09-27','2022-09-27 13:23:50','2022-09-28 13:23:50','556',3142367.50,3142367.50,'556','2022-09-27 19:06:25','454','2022-09-28 10:02:32',10,0),('1','157',257846,'Full day shift','2022-09-28','2022-09-28 14:14:59','2022-09-29 14:14:59','556',2159891.00,2159891.00,'556','2022-09-29 07:09:50','611','2022-09-29 08:09:43',10,0),('1','157',257847,'FULL DAY SHIFT','2022-09-30','2022-09-30 14:13:40','2022-10-01 14:13:40','556',0.00,0.00,'556','2022-10-01 16:49:09','611','2022-10-01 17:03:47',10,0),('1','157',257848,'Full day shift','2022-10-01','2022-10-01 17:06:02','2022-10-02 17:06:02','556',1276754.55,1276754.55,'556','2022-10-01 19:51:17','611','2022-10-02 09:25:48',10,0),('1','157',257849,'Full day shift','2022-10-02','2022-10-02 16:41:10','2022-10-03 16:41:10','556',0.00,0.00,'556','2022-10-03 09:54:29','611','2022-10-03 13:44:47',10,0),('1','157',257850,'Full day shift','2022-10-03','2022-10-03 14:15:02','2022-10-04 14:15:02','556',1219320.00,1219320.00,'556','2022-10-03 20:28:49','611','2022-10-03 21:33:16',10,0),('1','157',257851,'FULL DAY SHIFT','2022-10-04','2022-10-04 21:49:20','2022-10-05 21:49:20','556',2331933.95,2331933.95,'556','2022-10-04 22:04:41','611','2022-10-05 11:25:28',10,0),('1','157',257852,'FULL DAY SHIFT','2022-10-05','2022-10-05 22:20:10','2022-10-06 22:20:10','556',3643007.35,3643007.35,'556','2022-10-05 22:29:01','611','2022-10-06 07:55:35',10,0),('1','157',257853,'Full day shift','2022-10-06','2022-10-06 16:53:43','2022-10-07 16:53:43','556',3236477.50,3236477.50,'556','2022-10-06 21:38:05','611','2022-10-07 09:16:37',10,0),('1','157',257854,'Full day shift','2022-10-07','2022-10-07 11:51:19','2022-10-08 11:51:19','556',860110.25,860110.25,'556','2022-10-07 21:55:17','611','2022-10-08 06:44:33',10,0),('1','157',257855,'FULL DAY SHIFT','2022-10-08','2022-10-11 12:59:38','2022-10-12 12:59:38','556',2772988.60,2772988.60,'556','2022-10-11 13:45:05','611','2022-10-11 14:08:28',10,0),('1','157',257856,'FULL DAY SHIFT ','2022-10-09','2022-10-11 15:25:14','2022-10-12 15:25:14','556',404525.25,404525.25,'556','2022-10-11 15:40:15','611','2022-10-12 11:25:24',10,0),('1','157',257857,'FULL DAY SHIFT','2022-10-12','2022-10-12 13:20:32','2022-10-13 13:20:32','556',3629806.35,3629806.35,'556','2022-10-13 06:10:45','611','2022-10-13 08:14:00',10,0),('1','157',257858,'FULL DAY SHIFT','2022-10-13','2022-10-13 16:23:18','2022-10-14 16:23:18','556',3078906.25,3078906.25,'556','2022-10-14 06:26:53','611','2022-10-14 09:47:47',10,0),('1','157',257859,'FULL DAY SHIFT','2022-10-14','2022-10-14 16:02:25','2022-10-15 16:02:25','556',2712998.75,2712998.75,'556','2022-10-15 06:47:48','611','2022-10-15 09:41:55',10,0),('1','157',257860,'FULL DAY SHIFT','2022-10-16','2022-10-16 19:46:51','2022-10-17 19:46:51','556',136003.80,136003.80,'556','2022-10-17 07:49:19','611','2022-10-17 10:14:25',10,0),('1','157',257861,'Full day shift','2022-10-17','2022-10-17 12:59:40','2022-10-18 12:59:40','556',1289413.30,1289413.30,'556','2022-10-17 18:53:46','611','2022-10-18 08:11:17',10,0),('1','157',257862,'Full day shift','2022-10-18','2022-10-18 11:33:14','2022-10-19 11:33:14','556',3990955.75,3990955.75,'556','2022-10-19 07:21:03','611','2022-10-19 14:25:56',10,0),('1','157',257863,'Full day shift','2022-10-19','2022-10-19 15:27:35','2022-10-20 15:27:35','556',3922349.30,3922349.30,'556','2022-10-20 09:06:32','454','2022-10-20 09:39:49',10,0),('1','157',257864,'Full day shift','2022-10-20','2022-10-20 20:15:16','2022-10-21 20:15:16','556',2764319.60,2764319.60,'556','2022-10-21 06:12:46','611','2022-10-21 10:08:04',10,0),('1','157',257865,'FULL DAY SHIFT','2022-10-21','2022-10-21 12:58:47','2022-10-22 12:58:47','556',2145588.40,2145588.40,'556','2022-10-22 08:23:27','611','2022-10-22 12:45:19',10,0),('1','157',257866,'Full day shift','2022-10-22','2022-10-22 12:55:58','2022-10-23 12:55:58','556',1462758.30,1462758.30,'556','2022-10-23 11:50:52','611','2022-10-23 15:15:24',10,0),('1','157',257867,'Full day shift','2022-10-23','2022-10-23 16:20:49','2022-10-24 16:20:49','556',3605078.75,3605078.75,'556','2022-10-23 18:59:54','611','2022-10-24 08:36:17',10,0),('1','157',257868,'FULL DAY SHIFT','2022-10-24','2022-10-24 16:15:16','2022-10-25 16:15:16','556',976793.80,976793.80,'556','2022-10-24 19:03:32','611','2022-10-25 07:56:04',10,0),('1','157',257869,'FULL DAY SHIFT','2022-10-25','2022-10-25 17:00:00','2022-10-26 17:00:00','556',128805.25,128805.25,'556','2022-10-26 12:19:02','611','2022-10-26 12:23:59',10,0),('1','157',257870,'FULL DAY SHIFT','2022-10-26','2022-10-26 12:55:06','2022-10-27 12:55:06','556',4445666.05,4445666.05,'556','2022-10-27 08:26:21','454','2022-10-27 14:34:20',10,0),('1','157',257871,'Full day shift','2022-10-28','2022-10-28 12:51:11','2022-10-29 12:51:11','556',1066823.90,1066823.90,'556','2022-10-28 19:05:52','611','2022-10-29 10:03:15',10,0),('1','157',257872,'FULL DAY SHIFT','2022-10-29','2022-10-29 15:06:12','2022-10-30 15:06:12','556',1422867.75,1422867.75,'556','2022-10-30 07:37:53','611','2022-10-30 13:24:39',10,0),('1','157',257873,'FULL DAY SHIFT','2022-10-30','2022-10-30 14:29:29','2022-10-31 14:29:29','556',4528722.60,4528722.60,'556','2022-10-31 06:07:04','611','2022-10-31 08:02:17',10,0),('1','157',257874,'Full day shift','2022-10-31','2022-10-31 13:42:17','2022-11-01 13:42:17','556',4974832.30,4974832.30,'556','2022-10-31 20:53:46','611','2022-11-01 07:22:48',10,0),('1','157',257875,'Full day shift1','2022-11-01','2022-11-01 11:50:57','2022-11-02 11:50:57','556',3745039.75,3745039.75,'556','2022-11-02 06:46:10','611','2022-11-02 09:26:29',10,0),('1','157',257876,'FULL DAY SHIFT','2022-11-03','2022-11-03 10:18:45','2022-11-04 10:18:45','556',4613220.05,4613220.05,'556','2022-11-04 08:11:22','454','2022-11-04 10:27:11',10,0),('1','157',257877,'FULL DAY SHIFT','2022-11-04','2022-11-04 12:46:33','2022-11-05 12:46:33','556',5196973.95,5196973.95,'556','2022-11-05 08:40:47','611','2022-11-05 09:21:10',10,0),('1','157',257878,'FULL DAY SHIFT','2022-11-05','2022-11-05 14:55:51','2022-11-06 14:55:51','556',4268142.30,4268142.30,'556','2022-11-06 07:58:43','611','2022-11-06 09:24:13',10,0),('1','157',257879,'PMS CHANGE OF PRICE','2022-11-06','2022-11-06 09:43:15','2022-11-07 09:43:15','556',620084.50,620084.50,'556','2022-11-06 09:44:46','611','2022-11-06 10:00:07',10,0),('1','157',257880,'FULL DAY SHIFT','2022-11-06','2022-11-06 10:45:40','2022-11-07 10:45:40','556',4364622.90,4364622.90,'556','2022-11-07 07:40:30','454','2022-11-07 11:28:29',10,0),('1','157',257881,'FULL DAY SHIFT','2022-11-07','2022-11-07 16:21:04','2022-11-08 16:21:04','556',633580.50,633580.50,'556','2022-11-07 20:00:58','611','2022-11-08 09:37:03',10,0),('1','157',257882,'FULL DAY SHIFT','2022-11-08','2022-11-08 10:44:26','2022-11-09 10:44:26','556',2743957.80,2743957.80,'556','2022-11-09 07:32:47','611','2022-11-09 10:30:40',10,0),('1','157',257883,'FULL DAY SHIFT','2022-11-09','2022-11-09 19:17:55','2022-11-10 19:17:55','556',1393543.80,1393543.80,'556','2022-11-10 11:36:31','611','2022-11-10 11:59:18',10,0),('1','157',257884,'AGO CHANGE OF PRICE','2022-11-10','2022-11-10 12:40:08','2022-11-11 12:40:08','556',194801.00,194801.00,'556','2022-11-10 13:49:14','611','2022-11-10 16:20:50',10,0),('1','157',257885,'FULL DAY SHIFT','2022-11-10','2022-11-10 16:34:48','2022-11-11 16:34:48','556',2309428.40,2309428.40,'556','2022-11-11 08:47:45','454','2022-11-11 10:33:20',10,0),('1','157',257886,'FULL DAY SHIFT','2022-11-11','2022-11-11 11:41:59','2022-11-12 11:41:59','556',4058031.60,4058031.60,'556','2022-11-11 18:36:39','454','2022-11-12 11:55:01',10,0),('1','157',257887,'Full day shift','2022-11-12','2022-11-12 12:55:08','2022-11-13 12:55:08','556',672958.80,672958.80,'556','2022-11-12 20:03:06','611','2022-11-12 23:55:44',10,0),('1','157',257888,'Full day shift','2022-11-13','2022-11-13 20:07:41','2022-11-14 20:07:41','556',2157922.80,2157922.80,'556','2022-11-14 07:37:34','454','2022-11-14 10:02:56',10,0),('1','157',257889,'FULL DAY SHIFT','2022-11-14','2022-11-14 17:06:46','2022-11-15 17:06:46','556',2123089.20,2123089.20,'556','2022-11-15 07:58:30','611','2022-11-15 09:00:16',10,0),('1','157',257890,'FULL DAY SHIFT','2022-11-15','2022-11-15 13:09:57','2022-11-16 13:09:57','556',1858543.20,1858543.20,'556','2022-11-16 10:05:42','454','2022-11-16 10:56:52',10,0),('1','157',257891,'Full day shift','2022-11-16','2022-11-16 14:08:23','2022-11-17 14:08:23','556',3437127.00,3437127.00,'556','2022-11-16 22:40:10','454','2022-11-17 10:05:39',10,0),('1','157',257892,'Full day shift','2022-11-17','2022-11-17 11:37:27','2022-11-18 11:37:27','556',1879612.20,1879612.20,'556','2022-11-18 10:04:35','611','2022-11-18 14:37:56',10,0),('1','157',257893,'Full day shift','2022-11-18','2022-11-18 18:43:56','2022-11-19 18:43:56','556',3925659.00,3925659.00,'556','2022-11-18 21:05:38','611','2022-11-19 06:54:13',10,0),('1','157',257894,'Full day shift','2022-11-19','2022-11-19 13:08:08','2022-11-20 13:08:08','556',5311038.20,5311038.20,'556','2022-11-20 10:14:09','611','2022-11-20 11:32:35',10,0),('1','157',257895,'Full day shift','2022-11-20','2022-11-20 13:42:34','2022-11-21 13:42:34','556',3717295.20,3717295.20,'556','2022-11-21 10:28:00','454','2022-11-21 12:27:52',10,0),('1','157',257896,'Full day shift','2022-11-21','2022-11-21 20:16:42','2022-11-22 20:16:42','556',4463688.20,4463688.20,'556','2022-11-21 22:13:32','611','2022-11-22 09:17:10',10,0),('1','157',257897,'Full day shift','2022-11-22','2022-11-22 14:30:12','2022-11-23 14:30:12','556',2437366.60,2437366.60,'556','2022-11-23 09:27:06','454','2022-11-23 10:41:59',10,0),('1','157',257898,'Full day shift','2022-11-23','2022-11-23 19:19:31','2022-11-24 19:19:31','556',3132729.20,3132729.20,'556','2022-11-23 21:50:10','454','2022-11-24 10:04:23',10,0),('1','157',257899,'Full day shift','2022-11-24','2022-11-24 14:24:35','2022-11-25 14:24:35','556',7259304.80,7259304.80,'556','2022-11-25 07:49:54','611','2022-11-25 09:19:16',10,0),('1','157',257900,'Full day shift','2022-11-25','2022-11-25 11:46:32','2022-11-26 11:46:32','556',5114264.00,5114264.00,'556','2022-11-26 09:27:51','611','2022-11-26 10:52:24',10,0),('1','157',257901,'FULL DAY SHIFT','2022-11-26','2022-11-26 13:35:42','2022-11-27 13:35:42','556',2323903.40,2323903.40,'556','2022-11-26 19:42:31','611','2022-11-27 06:50:46',10,0),('1','157',257902,'Full day shift','2022-11-27','2022-11-27 13:17:12','2022-11-28 13:17:12','556',940209.60,940209.60,'556','2022-11-27 19:07:23','611','2022-11-27 20:19:29',10,0),('1','157',257903,'Full day shift','2022-11-28','2022-11-28 16:15:54','2022-11-29 16:15:54','556',1232896.20,1232896.20,'556','2022-11-29 06:07:34','611','2022-11-29 07:22:22',10,0),('1','157',257904,'FULL DAY SHIFT','2022-12-01','2022-12-01 19:16:41','2022-12-02 19:16:41','556',1304546.40,1304546.40,'556','2022-12-02 07:14:24','611','2022-12-02 11:39:11',10,0),('1','157',257905,'FULL DAY SHIFT','2022-12-02','2022-12-02 15:19:56','2022-12-03 15:19:56','556',3142713.60,3142713.60,'556','2022-12-03 07:35:13','611','2022-12-03 12:25:21',10,0),('1','157',257906,'Full day shift','2022-12-03','2022-12-03 12:29:30','2022-12-04 12:29:30','556',3446422.80,3446422.80,'556','2022-12-03 15:58:04','611','2022-12-03 23:15:39',10,0),('1','157',257907,'Full day shift','2022-12-04','2022-12-04 13:28:40','2022-12-05 13:28:40','556',1000818.00,1000818.00,'556','2022-12-04 18:46:55','611','2022-12-04 19:49:47',10,0),('1','157',257908,'Full day shift','2022-12-05','2022-12-05 17:53:08','2022-12-06 17:53:08','556',3944444.40,3944444.40,'556','2022-12-06 08:46:50','454','2022-12-06 10:22:03',10,0),('1','157',257909,'Full day shift','2022-12-06','2022-12-06 11:52:19','2022-12-07 11:52:19','556',5276707.20,5276707.20,'556','2022-12-06 19:09:59','611','2022-12-07 08:09:18',10,0),('1','157',257910,'FULL DAY SHIFT','2022-12-07','2022-12-07 10:24:04','2022-12-08 10:24:04','556',2579752.00,2579752.00,'556','2022-12-08 06:54:26','611','2022-12-08 08:46:08',10,0),('1','157',257911,'Full day shift','2022-12-08','2022-12-08 14:55:50','2022-12-09 14:55:50','556',4983108.20,4983108.20,'556','2022-12-09 07:00:26','611','2022-12-09 09:16:07',10,0),('1','157',257912,'FULL DAY SHIFT','2022-12-09','2022-12-09 16:52:04','2022-12-10 16:52:04','556',5401036.60,5401036.60,'556','2022-12-10 07:14:38','611','2022-12-10 14:58:27',10,0),('1','157',257913,'FULL DAY SHIFT','2022-12-10','2022-12-10 15:23:57','2022-12-11 15:23:57','556',5705429.40,5705429.40,'556','2022-12-11 06:58:10','454','2022-12-11 11:01:13',10,0),('1','157',257914,'FULL DAY SHIFT','2022-12-11','2022-12-11 13:35:24','2022-12-12 13:35:24','556',6272245.80,6272245.80,'556','2022-12-12 07:16:04','611','2022-12-12 07:34:17',10,0),('1','157',257915,'FULL DAY SHIFT','2022-12-12','2022-12-12 13:35:19','2022-12-13 13:35:19','556',3332675.60,3332675.60,'556','2022-12-12 21:01:27','611','2022-12-13 09:31:15',10,0),('1','157',257916,'FULL DAY SHIFT','2022-12-13','2022-12-13 12:37:11','2022-12-14 12:37:11','556',3328303.40,3328303.40,'556','2022-12-14 06:38:09','611','2022-12-14 07:55:28',10,0),('1','157',257917,'FULL DAY SHIFT','2022-12-14','2022-12-14 11:24:26','2022-12-15 11:24:26','556',3835718.40,3835718.40,'556','2022-12-15 07:17:42','611','2022-12-15 09:30:05',10,0),('1','157',257918,'FULL DAY SHIFT','2022-12-15','2022-12-15 14:24:59','2022-12-16 14:24:59','556',2305278.00,2305278.00,'556','2022-12-16 08:16:47','611','2022-12-16 17:38:03',10,0),('1','157',257919,'Full day shift','2022-12-16','2022-12-16 17:41:56','2022-12-17 17:41:56','556',1295314.20,1295314.20,'556','2022-12-17 06:18:56','611','2022-12-17 09:42:37',10,0),('1','157',257920,'Full day shift','2022-12-17','2022-12-17 12:30:40','2022-12-18 12:30:40','556',1343071.80,1343071.80,'556','2022-12-18 06:45:24','611','2022-12-18 08:43:02',10,0),('1','157',257921,'Full day shift','2022-12-19','2022-12-19 12:26:48','2022-12-20 12:26:48','556',4508094.60,4508094.60,'556','2022-12-20 06:24:24','454','2022-12-20 10:20:33',10,0),('1','157',257922,'Full day shift','2022-12-20','2022-12-20 12:52:11','2022-12-21 12:52:11','556',2501735.40,2501735.40,'556','2022-12-21 08:35:25','454','2022-12-21 10:42:11',10,0),('1','157',257923,'Full day shift','2022-12-21','2022-12-21 11:03:42','2022-12-22 11:03:42','556',3596452.20,3596452.20,'556','2022-12-22 06:59:26','611','2022-12-22 10:32:33',10,0),('1','157',257924,'Full day shift','2022-12-22','2022-12-22 11:32:09','2022-12-23 11:32:09','556',3642132.60,3642132.60,'556','2022-12-23 07:03:10','454','2022-12-23 10:31:02',10,0),('1','157',257925,'FULL DAY SHIFT','2022-12-23','2022-12-23 14:03:56','2022-12-24 14:03:56','556',3617371.80,3617371.80,'556','2022-12-24 06:02:30','611','2022-12-24 09:44:53',10,0),('1','157',257926,'Full day shift','2022-12-28','2022-12-28 14:22:19','2022-12-29 14:22:19','556',2183185.80,2183185.80,'556','2022-12-28 20:05:14','611','2022-12-29 10:57:25',10,0),('1','157',257927,'Full day shift','2022-12-29','2022-12-29 12:49:21','2022-12-30 12:49:21','556',2149765.20,2149765.20,'556','2022-12-30 06:26:39','611','2022-12-30 09:31:11',10,0),('1','157',257928,'FULL DAY SHIFT','2022-12-30','2022-12-30 12:40:34','2022-12-31 12:40:34','556',2408148.18,2408148.18,'556','2022-12-31 07:41:00','611','2022-12-31 08:38:24',10,0),('1','157',257929,'Full day shift','2022-12-31','2022-12-31 12:17:46','2023-01-01 12:17:46','556',3283592.40,3283592.40,'556','2022-12-31 20:13:55','611','2023-01-01 08:12:41',10,0),('1','157',257930,'FULL DAY SHIFT','2023-01-01','2023-01-01 15:15:23','2023-01-02 15:15:23','556',2558493.00,2558493.00,'556','2023-01-02 07:54:53','611','2023-01-02 09:12:24',10,0),('1','157',257931,'FULL DAY SHIFT','2023-01-02','2023-01-02 10:20:44','2023-01-03 10:20:44','556',1466641.80,1466641.80,'556','2023-01-02 19:51:58','611','2023-01-03 08:38:57',10,0),('1','157',257932,'FULL DAY SHIFT','2023-01-03','2023-01-03 10:26:49','2023-01-04 10:26:49','556',1456824.60,1456824.60,'556','2023-01-04 06:54:14','454','2023-01-04 10:53:22',10,0),('1','157',257933,'Full day shift','2023-01-04','2023-01-04 13:09:10','2023-01-05 13:09:10','556',1433826.00,1433826.00,'556','2023-01-04 19:51:38','611','2023-01-05 00:03:26',10,0),('1','157',257934,'Full day shift','2023-01-05','2023-01-05 11:53:12','2023-01-06 11:53:12','556',1522368.00,1522368.00,'556','2023-01-06 07:16:40','454','2023-01-06 10:01:07',10,0),('1','157',257935,'Full day shift','2023-01-06','2023-01-06 14:58:15','2023-01-07 14:58:15','556',2137293.00,2137293.00,'556','2023-01-07 06:34:37','611','2023-01-07 09:11:00',10,0),('1','157',257936,'Full day shift','2023-01-07','2023-01-07 15:04:40','2023-01-08 15:04:40','556',1844668.80,1844668.80,'556','2023-01-08 07:11:45','611','2023-01-08 07:59:23',10,0),('1','157',257937,'Full day shift','2023-01-08','2023-01-08 10:24:20','2023-01-09 10:24:20','556',1911306.60,1911306.60,'556','2023-01-09 07:10:35','611','2023-01-09 11:46:32',10,0),('1','157',257938,'Full day shift','2023-01-09','2023-01-09 11:58:48','2023-01-10 11:58:48','556',2283822.00,2283822.00,'556','2023-01-10 00:24:28','611','2023-01-10 08:48:41',10,0),('1','157',257939,'Full day shift','2023-01-10','2023-01-10 12:26:25','2023-01-11 12:26:25','556',3000999.60,3000999.60,'556','2023-01-10 22:22:09','454','2023-01-11 10:45:18',10,0),('1','157',257940,'Full day shift','2023-01-11','2023-01-11 12:57:43','2023-01-12 12:57:43','556',3545415.00,3545415.00,'556','2023-01-11 21:35:18','611','2023-01-12 09:05:15',10,0),('1','157',257941,'Full day shift','2023-01-12','2023-01-12 16:26:53','2023-01-13 16:26:53','556',5155975.80,5155975.80,'556','2023-01-12 21:44:17','611','2023-01-12 21:46:15',10,0),('1','157',257942,'Full day shift','2023-01-13','2023-01-13 11:20:36','2023-01-14 11:20:36','556',3477456.00,3477456.00,'556','2023-01-13 21:09:01','611','2023-01-14 14:20:17',10,0),('1','157',257943,'Full day shift','2023-01-14','2023-01-14 15:30:28','2023-01-15 15:30:28','556',4421601.00,4421601.00,'556','2023-01-14 20:38:50','611','2023-01-15 10:46:25',10,0),('1','157',257944,'Full day shift','2023-01-15','2023-01-15 10:49:05','2023-01-16 10:49:05','556',3153279.60,3153279.60,'556','2023-01-16 00:22:20','611','2023-01-16 10:10:17',10,0),('1','157',257945,'Full day shift','2023-01-16','2023-01-16 10:59:52','2023-01-17 10:59:52','556',3793195.80,3793195.80,'556','2023-01-16 19:34:35','611','2023-01-17 11:44:39',10,0),('1','157',257946,'Full day shift','2023-01-18','2023-01-18 12:44:32','2023-01-19 12:44:32','556',1974813.00,1974813.00,'556','2023-01-18 18:35:59','611','2023-01-19 00:11:18',10,0),('1','157',257947,'Full day shift','2023-01-19','2023-01-19 15:26:18','2023-01-20 15:26:18','556',7467058.95,7467058.95,'556','2023-01-21 09:12:56','611','2023-01-21 14:11:41',10,0),('1','157',257948,'Full day shift','2023-01-21','2023-01-21 15:09:13','2023-01-22 15:09:13','556',6534525.90,6534525.90,'556','2023-01-21 19:25:05','611','2023-01-22 09:30:40',10,0),('1','157',257949,'FULL DAY SHIFT','2023-01-22','2023-01-22 14:07:16','2023-01-23 14:07:16','556',4418777.55,4418777.55,'556','2023-01-23 06:38:25','454','2023-01-23 11:46:07',10,0),('1','157',257950,'Full day shift','2023-01-23','2023-01-23 14:32:41','2023-01-24 14:32:41','556',4282648.35,4282648.35,'556','2023-01-24 06:51:42','611','2023-01-24 09:38:32',10,0),('1','157',257951,'FULL DAY SHIFT','2023-01-24','2023-01-24 13:05:54','2023-01-25 13:05:54','556',4840124.70,4840124.70,'556','2023-01-25 07:32:30','611','2023-01-25 10:07:14',10,0),('1','157',257952,'Full day shift','2023-01-25','2023-01-25 11:21:00','2023-01-26 11:21:00','556',5239319.85,5239319.85,'556','2023-01-25 21:46:47','913','2023-01-25 22:09:21',10,0),('1','157',257953,'FULL DAY SHIFT','2023-01-26','2023-01-26 12:43:03','2023-01-27 12:43:03','556',3627896.40,3627896.40,'556','2023-01-27 07:27:03','611','2023-01-27 07:44:54',10,0),('1','157',257954,'FULL DAY SHIFT','2023-01-27','2023-01-27 17:55:20','2023-01-28 17:55:20','556',5680938.75,5680938.75,'556','2023-01-28 07:55:40','913','2023-01-28 09:50:52',10,0),('1','157',257955,'Full day shift','2023-01-28','2023-01-28 13:53:32','2023-01-29 13:53:32','556',4956956.55,4956956.55,'556','2023-01-29 06:59:27','913','2023-01-29 08:07:37',10,0),('1','157',257956,'Full day shift','2023-01-29','2023-01-29 11:17:46','2023-01-30 11:17:46','556',3226829.25,3226829.25,'556','2023-01-30 06:42:27','611','2023-01-30 09:55:27',10,0),('1','157',257957,'Full day shift','2023-01-30','2023-01-30 12:07:55','2023-01-31 12:07:55','556',4792520.05,4792520.05,'556','2023-01-31 06:52:15','611','2023-01-31 08:57:37',10,0),('1','157',257958,'Full day shift','2023-01-31','2023-01-31 13:03:18','2023-02-01 13:03:18','556',2513801.50,2513801.50,'556','2023-01-31 19:44:22','913','2023-02-01 01:35:14',10,0),('1','157',257959,'Full day shift','2023-02-01','2023-02-01 12:29:51','2023-02-02 12:29:51','556',5019326.75,5019326.75,'556','2023-02-02 07:37:42','454','2023-02-02 09:50:19',10,0),('1','157',257960,'Full day shift','2023-02-02','2023-02-02 14:40:02','2023-02-03 14:40:02','556',5750215.65,5750215.65,'556','2023-02-03 09:05:56','913','2023-02-03 09:14:54',10,0),('1','157',257961,'Full day shift','2023-02-03','2023-02-03 12:21:19','2023-02-04 12:21:19','556',4279972.35,4279972.35,'556','2023-02-04 09:30:09','913','2023-02-04 11:03:57',10,0),('1','157',257962,'Full day shift','2023-02-04','2023-02-04 14:59:42','2023-02-05 14:59:42','556',4851518.50,4851518.50,'556','2023-02-05 06:46:34','913','2023-02-05 11:34:12',10,0),('1','157',257963,'FULL DAY SHIFT','2023-02-05','2023-02-05 12:58:42','2023-02-06 12:58:42','556',5757645.00,5757645.00,'556','2023-02-06 06:17:50','913','2023-02-06 11:47:21',10,0),('1','157',257964,'FULL DAY SHIFT','2023-02-06','2023-02-06 12:30:56','2023-02-07 12:30:56','556',5401571.90,5401571.90,'556','2023-02-07 09:20:03','913','2023-02-07 10:01:03',10,0),('1','157',257965,'Full day shift','2023-02-07','2023-02-07 13:40:32','2023-02-08 13:40:32','556',4631299.15,4631299.15,'556','2023-02-08 07:15:07','611','2023-02-08 08:53:45',10,0),('1','157',257966,'Full day shift','2023-02-08','2023-02-08 12:19:01','2023-02-09 12:19:01','556',5284074.60,5284074.60,'556','2023-02-09 08:05:00','913','2023-02-09 08:19:33',10,0),('1','157',257967,'Full day shift','2023-02-09','2023-02-09 11:58:25','2023-02-10 11:58:25','556',5513058.45,5513058.45,'556','2023-02-09 20:46:39','913','2023-02-09 21:14:43',10,0),('1','157',257968,'FULL DAY SHIFT','2023-02-10','2023-02-10 11:45:14','2023-02-11 11:45:14','556',4945439.70,4945439.70,'556','2023-02-11 06:28:02','913','2023-02-11 13:34:00',10,0),('1','157',257969,'FULL DAY SHIFT','2023-02-11','2023-02-11 14:58:25','2023-02-12 14:58:25','556',4969183.15,4969183.15,'556','2023-02-12 07:08:32','913','2023-02-12 10:36:42',10,0),('1','157',257970,'Full day shift','2023-02-12','2023-02-12 11:28:31','2023-02-13 11:28:31','556',3604213.30,3604213.30,'556','2023-02-13 06:37:18','454','2023-02-13 12:12:45',10,0),('1','157',257971,'Full day shift','2023-02-13','2023-02-13 14:12:58','2023-02-14 14:12:58','556',2793274.19,2793274.19,'556','2023-02-14 07:28:10','913','2023-02-14 09:50:16',10,0),('1','157',257972,'FULL DAY SHIFT','2023-02-14','2023-02-14 13:29:27','2023-02-15 13:29:27','556',4908912.30,4908912.30,'556','2023-02-15 06:12:17','454','2023-02-15 09:25:59',10,0),('1','157',257973,'Full day shift','2023-02-15','2023-02-15 20:30:27','2023-02-16 20:30:27','556',4048641.80,4048641.80,'556','2023-02-16 07:21:20','454','2023-02-16 10:09:59',10,0),('1','157',257974,'Full day shift','2023-02-16','2023-02-16 12:44:29','2023-02-17 12:44:29','556',3597397.80,3597397.80,'556','2023-02-17 09:38:31','454','2023-02-17 11:15:04',10,0),('1','157',257975,'Full day shift','2023-02-17','2023-02-17 11:24:57','2023-02-18 11:24:57','556',0.00,0.00,'556','2023-02-18 13:37:40','611','2023-02-18 13:39:24',10,0),('1','157',257976,'FULLDAY SHIFT','2023-02-17','2023-02-18 13:40:23','2023-02-19 13:40:23','556',4161603.05,4161603.05,'556','2023-02-18 13:44:09','913','2023-02-18 14:06:13',10,0),('1','157',257977,'Full day shift','2023-02-18','2023-02-18 16:22:54','2023-02-19 16:22:54','556',3224203.15,3224203.15,'556','2023-02-19 13:24:25','913','2023-02-19 13:51:30',10,0),('1','157',257978,'Full day shift','2023-02-19','2023-02-19 13:52:55','2023-02-20 13:52:55','556',3996114.60,3996114.60,'556','2023-02-20 10:27:02','913','2023-02-20 11:04:28',10,0),('1','157',257979,'FULL DAY SHIFT','2023-02-20','2023-02-21 00:30:51','2023-02-22 00:30:51','556',3145381.00,3145381.00,'556','2023-02-21 00:33:34','913','2023-02-21 01:31:31',10,0),('1','157',257980,'Full day shift','2023-02-21','2023-02-22 05:32:24','2023-02-23 05:32:24','556',3889219.40,3889219.40,'556','2023-02-22 08:27:07','454','2023-02-22 10:03:27',10,0),('1','157',257981,'Full day shift','2023-02-22','2023-02-22 10:30:24','2023-02-23 10:30:24','556',2491829.40,2491829.40,'556','2023-02-23 09:09:42','913','2023-02-23 09:56:35',10,0),('1','157',257982,'FULL DAY SHIFT','2023-02-23','2023-02-23 11:30:50','2023-02-24 11:30:50','556',2754103.45,2754103.45,'556','2023-02-24 07:24:52','454','2023-02-24 10:37:08',10,0),('1','157',257983,'FULL DAY SHIFT','2023-02-24','2023-02-24 14:03:57','2023-02-25 14:03:57','556',2970745.95,2970745.95,'556','2023-02-25 06:57:31','913','2023-02-25 09:22:07',10,0),('1','157',257984,'Full day shift','2023-02-26','2023-02-26 11:10:47','2023-02-27 11:10:47','556',4062343.75,4062343.75,'556','2023-02-27 07:01:30','913','2023-02-27 12:51:30',10,0),('1','157',257985,'Full day shift','2023-02-27','2023-02-27 19:27:58','2023-02-28 19:27:58','556',3329345.55,3329345.55,'556','2023-02-28 07:42:14','913','2023-02-28 08:45:24',10,0),('1','157',257986,'FULL DAY SHIFT','2023-02-28','2023-02-28 19:28:48','2023-03-01 19:28:48','556',2968875.15,2968875.15,'556','2023-03-01 06:44:46','454','2023-03-01 09:57:01',10,0),('1','157',257987,'Full day shift','2023-03-01','2023-03-01 15:07:10','2023-03-02 15:07:10','556',2179421.00,2179421.00,'556','2023-03-02 08:54:04','913','2023-03-02 10:18:04',10,0),('1','157',257988,'FULL DAY SHIFT','2023-03-02','2023-03-02 14:17:27','2023-03-03 14:17:27','556',2837422.80,2837422.80,'556','2023-03-03 06:47:14','454','2023-03-03 09:53:20',10,0),('1','157',257989,'FULL DAY SHIFT','2023-03-03','2023-03-03 17:17:19','2023-03-04 17:17:19','556',4507162.75,4507162.75,'556','2023-03-04 06:47:28','913','2023-03-04 13:03:31',10,0),('1','157',257990,'FULL DAY SHIFT','2023-03-04','2023-03-05 10:41:13','2023-03-06 10:41:13','556',5742082.55,5742082.55,'556','2023-03-05 10:45:45','913','2023-03-05 11:32:57',10,0),('1','157',257991,'FULL DAY SHIFT','2023-03-05','2023-03-05 14:22:16','2023-03-06 14:22:16','556',7639914.35,7639914.35,'556','2023-03-06 06:26:17','913','2023-03-06 08:11:22',10,0),('1','157',257992,'Full day shift','2023-03-06','2023-03-07 06:12:55','2023-03-08 06:12:55','556',6212606.35,6212606.35,'556','2023-03-07 08:07:01','913','2023-03-07 12:20:36',10,0),('1','157',257993,'Full day shift','2023-03-07','2023-03-07 17:54:57','2023-03-08 17:54:57','556',5606618.35,5606618.35,'556','2023-03-08 06:16:41','913','2023-03-08 13:37:18',10,0),('1','157',257994,'FULL DAY SHIFT','2023-03-08','2023-03-08 20:18:36','2023-03-09 20:18:36','556',6088571.20,6088571.20,'556','2023-03-09 09:00:39','454','2023-03-09 11:17:39',10,0),('1','157',257995,'FULL DAY SHIFT','2023-03-09','2023-03-09 14:16:10','2023-03-10 14:16:10','556',5481272.25,5481272.25,'556','2023-03-10 07:54:59','454','2023-03-10 09:43:39',10,0),('1','157',257996,'FULL DAY SHIFT','2023-03-10','2023-03-10 18:55:05','2023-03-11 18:55:05','556',1413341.20,1413341.20,'556','2023-03-11 10:44:29','454','2023-03-11 11:03:07',10,0),('1','157',257997,'FULL DAY SHIFT','2023-03-11','2023-03-11 13:53:55','2023-03-12 13:53:55','556',5585729.90,5585729.90,'556','2023-03-12 10:01:45','913','2023-03-12 11:29:47',10,0),('1','157',257998,'FULL DAY SHIFT','2023-03-12','2023-03-12 14:53:08','2023-03-13 14:53:08','556',4515653.40,4515653.40,'556','2023-03-13 07:56:13','454','2023-03-13 09:47:15',10,0),('1','157',257999,'FULL DAY SHIFT','2023-03-13','2023-03-14 08:45:36','2023-03-15 08:45:36','556',2915929.75,2915929.75,'556','2023-03-14 10:11:44','913','2023-03-14 10:54:40',10,0),('1','157',258000,'Full day shift','2023-03-14','2023-03-14 17:54:39','2023-03-15 17:54:39','556',2846169.30,2846169.30,'556','2023-03-15 08:40:27','454','2023-03-15 09:28:21',10,0),('1','157',258001,'Full day shift','2023-03-15','2023-03-15 15:27:32','2023-03-16 15:27:32','556',2923521.90,2923521.90,'556','2023-03-16 09:15:46','454','2023-03-16 09:49:00',10,0),('1','157',258002,'Full day shift','2023-03-16','2023-03-16 16:02:18','2023-03-17 16:02:18','556',3974152.30,3974152.30,'556','2023-03-17 07:50:57','913','2023-03-17 08:42:38',10,0),('1','157',258003,'Full day shift','2023-03-17','2023-03-17 12:38:27','2023-03-18 12:38:27','556',4108295.90,4108295.90,'556','2023-03-18 06:59:45','913','2023-03-18 11:27:44',10,0),('1','157',258004,'Full day shift','2023-03-18','2023-03-18 15:29:22','2023-03-19 15:29:22','556',4110668.85,4110668.85,'556','2023-03-19 08:17:55','913','2023-03-19 09:15:53',10,0),('1','157',258005,'FULL DAY SHIFT','2023-03-19','2023-03-19 13:44:14','2023-03-20 13:44:14','556',3671634.35,3671634.35,'556','2023-03-20 08:00:25','913','2023-03-20 09:29:49',10,0),('1','157',258006,'Full day shift','2023-03-20','2023-03-20 13:27:18','2023-03-21 13:27:18','556',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4915282 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','157','835','161601',3201958,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161601',3201959,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161601',3201960,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161601',3201961,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161601',3201962,'2393','364',636.27,1920.89,1284.62,201685.34,0.00,0.00,0.00,0.00,0.00),('1','157','836','161601',3201963,'2394','364',531.28,1276.40,745.12,116983.84,0.00,0.00,0.00,0.00,0.00),('1','157','836','161601',3201964,'2395','364',606.39,1336.61,730.22,114644.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','161601',3201965,'2396','364',525.82,1702.48,1176.66,184735.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','161601',3201966,'2397','364',772.71,1002.42,223.91,35153.87,0.00,0.00,5.80,0.00,0.00),('1','157','837','161601',3201967,'2398','364',738.18,738.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161601',3201968,'2399','364',753.17,1479.89,726.72,114095.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','161601',3201969,'2400','364',660.69,1386.82,726.13,114002.41,0.00,0.00,0.00,0.00,0.00),('1','157','838','161601',3201970,'2401','364',784.63,784.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161601',3201971,'2402','364',919.86,919.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161601',3201972,'2403','364',574.23,574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161601',3201973,'2404','364',509.57,509.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161601',3201974,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161601',3201975,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161601',3201976,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161601',3201977,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161601',3201978,'2409','365',873.58,873.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161601',3201979,'2410','365',5420.52,5420.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161601',3201980,'2411','365',12862.19,12862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161601',3201981,'2412','365',62683.11,62683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161615',3202264,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161615',3202265,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161615',3202266,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161615',3202267,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161615',3202268,'2393','364',1920.89,2887.23,966.34,151715.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','161615',3202269,'2394','364',1276.40,2358.83,1082.43,169941.51,0.00,0.00,0.00,0.00,0.00),('1','157','836','161615',3202270,'2395','364',1336.61,2219.30,882.69,138582.33,0.00,0.00,0.00,0.00,0.00),('1','157','836','161615',3202271,'2396','364',1702.48,2926.81,1224.33,192219.81,0.00,0.00,0.00,0.00,0.00),('1','157','837','161615',3202272,'2397','364',1002.42,2594.80,1592.38,250003.66,0.00,0.00,0.00,0.00,0.00),('1','157','837','161615',3202273,'2398','364',738.18,2142.90,1404.72,220541.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','161615',3202274,'2399','364',1479.89,2608.41,1128.52,177177.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','161615',3202275,'2400','364',1386.82,3013.03,1626.21,255314.97,0.00,0.00,0.00,0.00,0.00),('1','157','838','161615',3202276,'2401','364',784.63,784.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161615',3202277,'2402','364',919.86,919.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161615',3202278,'2403','364',574.23,574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161615',3202279,'2404','364',509.57,509.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161615',3202280,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161615',3202281,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161615',3202282,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161615',3202283,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161615',3202284,'2409','365',873.58,873.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161615',3202285,'2410','365',5420.52,5586.08,155.29,28728.65,0.00,0.00,10.27,0.00,0.00),('1','157','840','161615',3202286,'2411','365',12862.19,12862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161615',3202287,'2412','365',62683.11,62683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161621',3202384,'2389','364',472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161621',3202385,'2390','364',593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161621',3202386,'2391','364',582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161621',3202387,'2392','364',519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161621',3202388,'2393','364',2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161621',3202389,'2394','364',2358.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161621',3202390,'2395','364',2219.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161621',3202391,'2396','364',2926.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161621',3202392,'2397','364',2594.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161621',3202393,'2398','364',2142.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161621',3202394,'2399','364',2608.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161621',3202395,'2400','364',3013.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161621',3202396,'2401','364',784.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161621',3202397,'2402','364',919.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161621',3202398,'2403','364',574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161621',3202399,'2404','364',509.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161621',3202400,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161621',3202401,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161621',3202402,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161621',3202403,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161621',3202404,'2409','365',873.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161621',3202405,'2410','365',5586.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161621',3202406,'2411','365',12862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161621',3202407,'2412','365',62683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161626',3202503,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161626',3202504,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161626',3202505,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161626',3202506,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161626',3202507,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161626',3202508,'2394','364',2358.83,3067.13,708.30,111203.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','161626',3202509,'2395','364',2219.30,3183.24,963.94,151338.58,0.00,0.00,0.00,0.00,0.00),('1','157','836','161626',3202510,'2396','364',2926.81,3878.97,952.16,149489.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','161626',3202511,'2397','364',2594.80,3970.89,1376.09,216046.13,0.00,0.00,0.00,0.00,0.00),('1','157','837','161626',3202512,'2398','364',2142.90,4549.59,2406.69,377850.33,0.00,0.00,0.00,0.00,0.00),('1','157','837','161626',3202513,'2399','364',2608.41,3229.89,621.48,97572.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','161626',3202514,'2400','364',3013.03,4189.11,1176.08,184644.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','161626',3202515,'2401','364',784.63,1516.34,731.71,114878.47,0.00,0.00,0.00,0.00,0.00),('1','157','838','161626',3202516,'2402','364',919.86,1857.96,938.10,147281.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','161626',3202517,'2403','364',574.23,574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161626',3202518,'2404','364',509.57,1370.31,860.74,135136.18,0.00,0.00,0.00,0.00,0.00),('1','157','839','161626',3202519,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161626',3202520,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161626',3202521,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161626',3202522,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161626',3202523,'2409','365',5586.08,5606.08,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','157','840','161626',3202524,'2410','365',8731.58,8860.77,96.49,17850.65,0.00,0.00,32.70,0.00,0.00),('1','157','840','161626',3202525,'2411','365',12862.19,12862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161626',3202526,'2412','365',62683.11,62683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161628',3202535,'2389','364',472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161628',3202536,'2390','364',593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161628',3202537,'2391','364',582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','161628',3202538,'2392','364',519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161628',3202539,'2393','364',2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161628',3202540,'2394','364',3067.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161628',3202541,'2395','364',3183.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','161628',3202542,'2396','364',3878.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161628',3202543,'2397','364',3970.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161628',3202544,'2398','364',4549.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161628',3202545,'2399','364',3229.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','161628',3202546,'2400','364',4189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161628',3202547,'2401','364',1516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161628',3202548,'2402','364',1857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161628',3202549,'2403','364',574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','161628',3202550,'2404','364',1370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161628',3202551,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161628',3202552,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161628',3202553,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','161628',3202554,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161628',3202555,'2409','365',5606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161628',3202556,'2410','365',8860.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161628',3202557,'2411','365',12862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','161628',3202558,'2412','365',62683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','162998',3226181,'2389','364',472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','162998',3226182,'2390','364',593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','162998',3226183,'2391','364',582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','162998',3226184,'2392','364',519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','162998',3226185,'2393','364',2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','162998',3226186,'2394','364',3067.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','162998',3226187,'2395','364',3183.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','162998',3226188,'2396','364',3878.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','162998',3226189,'2397','364',3970.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','162998',3226190,'2398','364',4549.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','162998',3226191,'2399','364',3229.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','162998',3226192,'2400','364',4189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','162998',3226193,'2401','364',1516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','162998',3226194,'2402','364',1857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','162998',3226195,'2403','364',574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','162998',3226196,'2404','364',1370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','162998',3226197,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','162998',3226198,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','162998',3226199,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','162998',3226200,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','162998',3226201,'2409','365',695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','162998',3226202,'2410','365',418860.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','162998',3226203,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','162998',3226204,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163091',3227582,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,1655.00,0.00),('1','157','835','163091',3227583,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163091',3227584,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163091',3227585,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163091',3227586,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163091',3227587,'2394','364',3067.13,3067.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163091',3227588,'2395','364',3183.24,3183.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163091',3227589,'2396','364',3878.97,3878.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163091',3227590,'2397','364',3970.89,3970.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163091',3227591,'2398','364',4549.59,4549.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163091',3227592,'2399','364',3229.89,3229.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163091',3227593,'2400','364',4189.11,4189.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163091',3227594,'2401','364',1516.34,1516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163091',3227595,'2402','364',1857.96,1857.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163091',3227596,'2403','364',574.23,574.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163091',3227597,'2404','364',1370.31,1370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163091',3227598,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163091',3227599,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163091',3227600,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163091',3227601,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163091',3227602,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163091',3227603,'2410','365',418860.77,418860.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163091',3227604,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163091',3227605,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163094',3227655,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163094',3227656,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163094',3227657,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163094',3227658,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163094',3227659,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163094',3227660,'2394','364',3067.13,4326.38,1259.25,197702.25,0.00,0.00,0.00,0.00,0.00),('1','157','836','163094',3227661,'2395','364',3183.24,4615.41,1432.17,224850.69,0.00,0.00,0.00,0.00,0.00),('1','157','836','163094',3227662,'2396','364',3878.97,5130.32,1251.35,196461.95,0.00,0.00,0.00,0.00,0.00),('1','157','837','163094',3227663,'2397','364',3970.89,5239.80,1268.91,199218.87,0.00,0.00,0.00,0.00,0.00),('1','157','837','163094',3227664,'2398','364',4549.59,6040.23,1490.64,234030.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','163094',3227665,'2399','364',3229.89,3998.83,768.94,120723.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','163094',3227666,'2400','364',4189.11,5586.04,1396.93,219318.01,0.00,0.00,0.00,0.00,0.00),('1','157','838','163094',3227667,'2401','364',1516.34,2297.13,780.79,122584.03,0.00,0.00,0.00,0.00,0.00),('1','157','838','163094',3227668,'2402','364',1857.96,2856.87,998.91,156828.87,0.00,0.00,0.00,0.00,0.00),('1','157','838','163094',3227669,'2403','364',574.23,800.40,226.17,35508.69,0.00,0.00,0.00,0.00,0.00),('1','157','838','163094',3227670,'2404','364',1370.31,1900.80,530.49,83286.93,0.00,0.00,0.00,0.00,0.00),('1','157','839','163094',3227671,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163094',3227672,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163094',3227673,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163094',3227674,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163094',3227675,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163094',3227676,'2410','365',418860.77,419002.95,142.18,26303.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','163094',3227677,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163094',3227678,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163098',3227733,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163098',3227734,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163098',3227735,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163098',3227736,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163098',3227737,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163098',3227738,'2394','364',4326.38,4326.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163098',3227739,'2395','364',4615.41,4615.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163098',3227740,'2396','364',5130.32,5130.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163098',3227741,'2397','364',5239.80,5239.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163098',3227742,'2398','364',6040.23,6040.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163098',3227743,'2399','364',3998.83,3998.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163098',3227744,'2400','364',5586.04,5586.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163098',3227745,'2401','364',2297.13,2297.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163098',3227746,'2402','364',2856.87,2856.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163098',3227747,'2403','364',800.40,800.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163098',3227748,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163098',3227749,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163098',3227750,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163098',3227751,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163098',3227752,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163098',3227753,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163098',3227754,'2410','365',419002.95,419002.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163098',3227755,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163098',3227756,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163099',3227757,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163099',3227758,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163099',3227759,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163099',3227760,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163099',3227761,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163099',3227762,'2394','364',4326.38,6855.91,2529.53,397136.21,0.00,0.00,0.00,0.00,0.00),('1','157','836','163099',3227763,'2395','364',4615.41,4615.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163099',3227764,'2396','364',5130.32,6984.79,1854.47,291151.79,0.00,0.00,0.00,0.00,0.00),('1','157','837','163099',3227765,'2397','364',5239.80,5239.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163099',3227766,'2398','364',6040.23,6040.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163099',3227767,'2399','364',3998.83,3998.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163099',3227768,'2400','364',5586.04,6114.49,528.45,82966.65,0.00,0.00,0.00,0.00,0.00),('1','157','838','163099',3227769,'2401','364',2297.13,3273.08,975.95,153224.15,0.00,0.00,0.00,0.00,0.00),('1','157','838','163099',3227770,'2402','364',2856.87,4297.74,1440.87,226216.59,0.00,0.00,0.00,0.00,0.00),('1','157','838','163099',3227771,'2403','364',800.40,1716.22,915.82,143783.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','163099',3227772,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163099',3227773,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163099',3227774,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163099',3227775,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163099',3227776,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163099',3227777,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163099',3227778,'2410','365',419002.95,419044.04,41.09,7601.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','163099',3227779,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163099',3227780,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163101',3227783,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163101',3227784,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163101',3227785,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163101',3227786,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163101',3227787,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163101',3227788,'2394','364',6855.91,7022.30,166.39,26123.23,0.00,0.00,0.00,0.00,0.00),('1','157','836','163101',3227789,'2395','364',4615.41,4801.23,185.82,29173.74,0.00,0.00,0.00,0.00,0.00),('1','157','836','163101',3227790,'2396','364',6984.79,7031.31,46.52,7303.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','163101',3227791,'2397','364',5239.80,5239.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163101',3227792,'2398','364',6040.23,6040.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163101',3227793,'2399','364',3998.83,3998.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163101',3227794,'2400','364',6114.49,6114.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163101',3227795,'2401','364',3273.08,5895.19,2622.11,411671.27,0.00,0.00,0.00,0.00,0.00),('1','157','838','163101',3227796,'2402','364',4297.74,6228.16,1930.42,303075.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','163101',3227797,'2403','364',1716.22,4600.70,2884.48,452863.36,0.00,0.00,0.00,0.00,0.00),('1','157','838','163101',3227798,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163101',3227799,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163101',3227800,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163101',3227801,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163101',3227802,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163101',3227803,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163101',3227804,'2410','365',419044.04,419281.22,237.18,43878.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','163101',3227805,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163101',3227806,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163103',3227825,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163103',3227826,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163103',3227827,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163103',3227828,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163103',3227829,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163103',3227830,'2394','364',7022.30,7022.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163103',3227831,'2395','364',4801.23,4801.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163103',3227832,'2396','364',7031.31,7031.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163103',3227833,'2397','364',5239.80,5239.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163103',3227834,'2398','364',6040.23,6040.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163103',3227835,'2399','364',3998.83,3998.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163103',3227836,'2400','364',6114.49,6114.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163103',3227837,'2401','364',5895.19,6921.48,1026.29,161127.53,0.00,0.00,0.00,0.00,0.00),('1','157','838','163103',3227838,'2402','364',6228.16,6997.72,769.56,120820.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','163103',3227839,'2403','364',4600.70,5636.69,1035.99,162650.43,0.00,0.00,0.00,0.00,0.00),('1','157','838','163103',3227840,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163103',3227841,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163103',3227842,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163103',3227843,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163103',3227844,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163103',3227845,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163103',3227846,'2410','365',419281.22,419829.85,548.63,101496.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','163103',3227847,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163103',3227848,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163118',3228142,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163118',3228143,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163118',3228144,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163118',3228145,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163118',3228146,'2393','364',2887.23,2887.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163118',3228147,'2394','364',7022.30,7946.40,924.10,145083.70,0.00,0.00,0.00,0.00,0.00),('1','157','836','163118',3228148,'2395','364',4801.23,4801.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163118',3228149,'2396','364',7031.31,7862.23,830.92,130454.44,0.00,0.00,0.00,0.00,0.00),('1','157','837','163118',3228150,'2397','364',5239.80,5712.87,473.07,74271.99,0.00,0.00,0.00,0.00,0.00),('1','157','837','163118',3228151,'2398','364',6040.23,6860.68,820.45,128810.65,0.00,0.00,0.00,0.00,0.00),('1','157','837','163118',3228152,'2399','364',3998.83,3998.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163118',3228153,'2400','364',6114.49,6847.88,733.39,115142.23,0.00,0.00,0.00,0.00,0.00),('1','157','838','163118',3228154,'2401','364',6921.48,6921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163118',3228155,'2402','364',6997.72,6997.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163118',3228156,'2403','364',5636.69,5636.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163118',3228157,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163118',3228158,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163118',3228159,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163118',3228160,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163118',3228161,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163118',3228162,'2409','365',695606.08,695606.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163118',3228163,'2410','365',419829.85,419829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163118',3228164,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163118',3228165,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163121',3228199,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163121',3228200,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163121',3228201,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163121',3228202,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163121',3228203,'2393','364',2887.23,5035.96,2138.73,342196.80,0.00,0.00,10.00,0.00,0.00),('1','157','836','163121',3228204,'2394','364',7946.40,7956.49,0.09,14.40,0.00,0.00,10.00,0.00,0.00),('1','157','836','163121',3228205,'2395','364',4801.23,6733.68,1922.45,307592.00,0.00,0.00,10.00,0.00,0.00),('1','157','836','163121',3228206,'2396','364',7862.23,7874.73,2.50,400.00,0.00,0.00,10.00,0.00,0.00),('1','157','837','163121',3228207,'2397','364',5712.87,7439.21,1716.34,274614.40,0.00,0.00,10.00,0.00,0.00),('1','157','837','163121',3228208,'2398','364',6860.68,9592.83,2722.15,435544.00,0.00,0.00,10.00,0.00,0.00),('1','157','837','163121',3228209,'2399','364',3998.83,6039.60,2030.77,324923.20,0.00,0.00,10.00,0.00,0.00),('1','157','837','163121',3228210,'2400','364',6847.88,6858.88,0.00,0.00,0.00,0.00,11.00,0.00,0.00),('1','157','838','163121',3228211,'2401','364',6921.48,6921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163121',3228212,'2402','364',6997.72,6997.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163121',3228213,'2403','364',5636.69,5636.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163121',3228214,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163121',3228215,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163121',3228216,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163121',3228217,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163121',3228218,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163121',3228219,'2409','365',695606.08,695608.97,0.00,0.00,0.00,0.00,2.89,0.00,0.00),('1','157','840','163121',3228220,'2410','365',419829.85,419832.96,0.00,0.00,0.00,0.00,3.11,0.00,0.00),('1','157','840','163121',3228221,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163121',3228222,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163128',3228401,'2389','364',472.56,472.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163128',3228402,'2390','364',593.48,593.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163128',3228403,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163128',3228404,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163128',3228405,'2393','364',5035.96,7075.79,2039.83,326372.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','163128',3228406,'2394','364',7956.49,7956.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163128',3228407,'2395','364',6733.68,6733.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163128',3228408,'2396','364',7874.73,10114.56,2239.83,358372.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','163128',3228409,'2397','364',7439.21,8368.85,929.64,148742.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163128',3228410,'2398','364',9592.83,11652.14,2059.31,329489.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','163128',3228411,'2399','364',6039.60,7810.48,1770.88,283340.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','163128',3228412,'2400','364',6858.88,7903.01,1044.13,167060.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163128',3228413,'2401','364',6921.48,6921.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163128',3228414,'2402','364',6997.72,6997.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163128',3228415,'2403','364',5636.69,5636.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163128',3228416,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163128',3228417,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163128',3228418,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163128',3228419,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163128',3228420,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163128',3228421,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163128',3228422,'2410','365',419832.96,420348.09,515.13,95299.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','163128',3228423,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163128',3228424,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163131',3228436,'2389','364',472.56,500.06,0.00,0.00,0.00,0.00,27.50,0.00,0.00),('1','157','835','163131',3228437,'2390','364',593.48,607.28,0.00,0.00,0.00,0.00,13.80,0.00,0.00),('1','157','835','163131',3228438,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163131',3228439,'2392','364',519.84,519.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163131',3228440,'2393','364',7075.79,7783.37,696.28,111404.80,0.00,0.00,11.30,0.00,0.00),('1','157','836','163131',3228441,'2394','364',7956.49,8879.10,912.61,146017.60,0.00,0.00,10.00,0.00,0.00),('1','157','836','163131',3228442,'2395','364',6733.68,6930.58,186.90,29904.00,0.00,0.00,10.00,0.00,0.00),('1','157','836','163131',3228443,'2396','364',10114.56,11828.28,1703.72,272595.20,0.00,0.00,10.00,0.00,0.00),('1','157','837','163131',3228444,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163131',3228445,'2398','364',11652.14,12077.24,425.10,68016.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163131',3228446,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163131',3228447,'2400','364',7903.01,8016.95,113.94,18230.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163131',3228448,'2401','364',6921.48,7924.69,1003.21,160513.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','163131',3228449,'2402','364',6997.72,6997.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163131',3228450,'2403','364',5636.69,6680.13,1043.44,166950.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163131',3228451,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163131',3228452,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163131',3228453,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163131',3228454,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163131',3228455,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163131',3228456,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163131',3228457,'2410','365',420348.09,421586.21,1238.12,229052.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','163131',3228458,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163131',3228459,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163134',3228517,'2389','364',500.06,500.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163134',3228518,'2390','364',607.28,607.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163134',3228519,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163134',3228520,'2392','364',519.84,520.16,0.00,0.00,0.00,0.00,0.32,0.00,0.00),('1','157','836','163134',3228521,'2393','364',7783.37,8792.01,1008.64,161382.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','163134',3228522,'2394','364',8879.10,8879.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163134',3228523,'2395','364',6930.58,7908.41,977.83,156452.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','163134',3228524,'2396','364',11828.28,12765.07,936.79,149886.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163134',3228525,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163134',3228526,'2398','364',12077.24,12077.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163134',3228527,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163134',3228528,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163134',3228529,'2401','364',7924.69,9537.60,1612.91,258065.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','163134',3228530,'2402','364',6997.72,6997.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163134',3228531,'2403','364',6680.13,6998.06,317.93,50868.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163134',3228532,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163134',3228533,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163134',3228534,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163134',3228535,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163134',3228536,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163134',3228537,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163134',3228538,'2410','365',421586.21,421600.24,14.03,2595.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','163134',3228539,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163134',3228540,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163140',3228640,'2389','364',500.06,500.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163140',3228641,'2390','364',607.28,607.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163140',3228642,'2391','364',582.20,582.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163140',3228643,'2392','364',520.16,520.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163140',3228644,'2393','364',8792.01,10051.98,1259.97,201595.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163140',3228645,'2394','364',8879.10,10180.22,1301.12,208179.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163140',3228646,'2395','364',7908.41,8830.95,922.54,147606.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','163140',3228647,'2396','364',12765.07,13886.51,1121.44,179430.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163140',3228648,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163140',3228649,'2398','364',12077.24,12077.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163140',3228650,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163140',3228651,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163140',3228652,'2401','364',9537.60,10301.14,763.54,122166.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163140',3228653,'2402','364',6997.72,6998.00,0.00,0.00,0.00,0.00,0.28,0.00,0.00),('1','157','838','163140',3228654,'2403','364',6998.06,6998.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163140',3228655,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163140',3228656,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163140',3228657,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163140',3228658,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163140',3228659,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163140',3228660,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163140',3228661,'2410','365',421600.24,421639.99,39.75,7353.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','163140',3228662,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163140',3228663,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163144',3228700,'2389','364',500.06,608.02,0.00,0.00,0.00,0.00,107.96,0.00,0.00),('1','157','835','163144',3228701,'2390','364',607.28,714.70,0.00,0.00,0.00,0.00,107.42,0.00,0.00),('1','157','835','163144',3228702,'2391','364',582.20,638.35,0.00,0.00,0.00,0.00,56.15,0.00,0.00),('1','157','835','163144',3228703,'2392','364',520.16,606.29,-0.16,-25.60,0.00,0.00,86.29,0.00,0.00),('1','157','836','163144',3228704,'2393','364',10051.98,11269.65,1217.67,194827.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163144',3228705,'2394','364',10180.22,10990.84,810.62,129699.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163144',3228706,'2395','364',8830.95,10519.95,1689.00,270240.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163144',3228707,'2396','364',13886.51,15092.00,1205.49,192878.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163144',3228708,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163144',3228709,'2398','364',12077.24,12077.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163144',3228710,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163144',3228711,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163144',3228712,'2401','364',10301.14,11285.17,984.03,157444.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163144',3228713,'2402','364',6998.00,6998.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163144',3228714,'2403','364',6998.06,7469.51,471.45,75432.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163144',3228715,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163144',3228716,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163144',3228717,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163144',3228718,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163144',3228719,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163144',3228720,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163144',3228721,'2410','365',421639.99,422613.10,973.11,180025.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','163144',3228722,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163144',3228723,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163147',3228780,'2389','364',608.02,1641.42,1033.40,165344.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163147',3228781,'2390','364',714.70,714.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163147',3228782,'2391','364',638.35,1640.66,1002.31,160369.60,0.00,0.00,0.00,0.00,0.00),('1','157','835','163147',3228783,'2392','364',606.29,708.38,102.09,16334.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','163147',3228784,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163147',3228785,'2394','364',10990.84,12230.73,1239.89,198382.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','163147',3228786,'2395','364',10519.95,10519.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163147',3228787,'2396','364',15092.00,16824.44,1732.44,277190.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163147',3228788,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163147',3228789,'2398','364',12077.24,12077.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163147',3228790,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163147',3228791,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163147',3228792,'2401','364',11285.17,12753.97,1468.80,235008.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163147',3228793,'2402','364',6998.00,6998.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163147',3228794,'2403','364',7469.51,7469.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163147',3228795,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163147',3228796,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163147',3228797,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163147',3228798,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163147',3228799,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163147',3228800,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163147',3228801,'2410','365',422613.10,422761.54,148.44,27461.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','163147',3228802,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163147',3228803,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163149',3228826,'2389','364',1641.42,2536.70,895.28,143244.80,0.00,0.00,0.00,0.00,0.00),('1','157','835','163149',3228827,'2390','364',714.70,714.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163149',3228828,'2391','364',1640.66,2745.20,1104.54,176726.40,0.00,0.00,0.00,0.00,0.00),('1','157','835','163149',3228829,'2392','364',708.38,708.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163149',3228830,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163149',3228831,'2394','364',12230.73,12362.77,132.04,21126.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','163149',3228832,'2395','364',10519.95,11040.67,520.72,83315.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163149',3228833,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163149',3228834,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163149',3228835,'2398','364',12077.24,12077.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163149',3228836,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163149',3228837,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163149',3228838,'2401','364',12753.97,14330.57,1576.60,252256.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163149',3228839,'2402','364',6998.00,6998.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163149',3228840,'2403','364',7469.51,8171.56,702.05,112328.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163149',3228841,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163149',3228842,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163149',3228843,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163149',3228844,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163149',3228845,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163149',3228846,'2409','365',695608.97,695608.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163149',3228847,'2410','365',422761.54,423007.51,245.97,45504.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','163149',3228848,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163149',3228849,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163151',3228872,'2389','364',2536.70,3123.76,587.06,93929.60,0.00,0.00,0.00,0.00,0.00),('1','157','835','163151',3228873,'2390','364',714.70,1387.55,672.85,107656.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163151',3228874,'2391','364',2745.20,2745.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163151',3228875,'2392','364',708.38,1824.69,1116.31,178609.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','163151',3228876,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163151',3228877,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163151',3228878,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163151',3228879,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163151',3228880,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163151',3228881,'2398','364',12077.24,13849.65,1772.41,283585.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','163151',3228882,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163151',3228883,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163151',3228884,'2401','364',14330.57,15510.90,1180.33,188852.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163151',3228885,'2402','364',6998.00,6998.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163151',3228886,'2403','364',8171.56,8171.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163151',3228887,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163151',3228888,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163151',3228889,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163151',3228890,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163151',3228891,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163151',3228892,'2409','365',695608.97,695912.41,303.44,56136.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','163151',3228893,'2410','365',423007.51,423007.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163151',3228894,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163151',3228895,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163154',3228936,'2389','364',3123.76,3725.39,601.63,96260.80,0.00,0.00,0.00,0.00,0.00),('1','157','835','163154',3228937,'2390','364',1387.55,1878.23,490.68,78508.80,0.00,0.00,0.00,0.00,0.00),('1','157','835','163154',3228938,'2391','364',2745.20,3387.99,642.79,102846.40,0.00,0.00,0.00,0.00,0.00),('1','157','835','163154',3228939,'2392','364',1824.69,2498.12,673.43,107748.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','163154',3228940,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163154',3228941,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163154',3228942,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163154',3228943,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163154',3228944,'2397','364',8368.85,8368.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163154',3228945,'2398','364',13849.65,15712.16,1862.51,298001.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','163154',3228946,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163154',3228947,'2400','364',8016.95,8016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163154',3228948,'2401','364',15510.90,16180.67,669.77,107163.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','163154',3228949,'2402','364',6998.00,6998.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163154',3228950,'2403','364',8171.56,8171.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163154',3228951,'2404','364',1900.80,1900.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163154',3228952,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163154',3228953,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163154',3228954,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163154',3228955,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163154',3228956,'2409','365',695912.41,695932.41,20.00,3700.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163154',3228957,'2410','365',423007.51,423007.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163154',3228958,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163154',3228959,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163158',3229025,'2389','364',3725.39,4697.01,971.62,155459.20,0.00,0.00,0.00,0.00,0.00),('1','157','835','163158',3229026,'2390','364',1878.23,2716.55,838.32,134131.20,0.00,0.00,0.00,0.00,0.00),('1','157','835','163158',3229027,'2391','364',3387.99,4819.90,1431.91,229105.60,0.00,0.00,0.00,0.00,0.00),('1','157','835','163158',3229028,'2392','364',2498.12,2511.60,13.48,2156.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','163158',3229029,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163158',3229030,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163158',3229031,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163158',3229032,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163158',3229033,'2397','364',8368.85,8371.10,0.00,0.00,0.00,0.00,2.25,0.00,0.00),('1','157','837','163158',3229034,'2398','364',15712.16,15714.41,0.00,0.00,0.00,0.00,2.25,0.00,0.00),('1','157','837','163158',3229035,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163158',3229036,'2400','364',8016.95,9592.54,1575.59,252094.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163158',3229037,'2401','364',16180.67,16928.08,747.41,119585.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','163158',3229038,'2402','364',6998.00,7006.46,0.00,0.00,0.00,0.00,8.46,0.00,0.00),('1','157','838','163158',3229039,'2403','364',8171.56,8175.81,0.00,0.00,0.00,0.00,4.25,0.00,0.00),('1','157','838','163158',3229040,'2404','364',1900.80,1910.37,0.00,0.00,0.00,0.00,9.57,0.00,0.00),('1','157','839','163158',3229041,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163158',3229042,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163158',3229043,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163158',3229044,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163158',3229045,'2409','365',695932.41,696738.80,803.59,148664.15,0.00,0.00,2.80,0.00,0.00),('1','157','840','163158',3229046,'2410','365',423007.51,423010.98,0.00,0.00,0.00,0.00,3.47,0.00,0.00),('1','157','840','163158',3229047,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163158',3229048,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163160',3229064,'2389','364',4697.01,4697.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163160',3229065,'2390','364',2716.55,3746.88,1030.33,164852.80,0.00,0.00,0.00,0.00,0.00),('1','157','835','163160',3229066,'2391','364',4819.90,5604.12,784.22,125475.20,0.00,0.00,0.00,0.00,0.00),('1','157','835','163160',3229067,'2392','364',2511.60,2511.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163160',3229068,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163160',3229069,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163160',3229070,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163160',3229071,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163160',3229072,'2397','364',8371.10,9732.73,1361.63,217860.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','163160',3229073,'2398','364',15714.41,15714.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163160',3229074,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163160',3229075,'2400','364',9592.54,10763.46,1170.92,187347.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','163160',3229076,'2401','364',16928.08,17791.43,863.35,138136.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163160',3229077,'2402','364',7006.46,7006.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163160',3229078,'2403','364',8175.81,8175.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163160',3229079,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163160',3229080,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163160',3229081,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163160',3229082,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163160',3229083,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163160',3229084,'2409','365',696738.80,696738.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163160',3229085,'2410','365',423010.98,423118.41,107.43,19874.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','163160',3229086,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163160',3229087,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163161',3229088,'2389','364',4697.01,4697.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163161',3229089,'2390','364',3746.88,4494.36,747.48,118101.84,0.00,0.00,0.00,0.00,0.00),('1','157','835','163161',3229090,'2391','364',5604.12,6647.16,1043.04,164800.32,0.00,0.00,0.00,0.00,0.00),('1','157','835','163161',3229091,'2392','364',2511.60,2511.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163161',3229092,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163161',3229093,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163161',3229094,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163161',3229095,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163161',3229096,'2397','364',9732.73,9732.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163161',3229097,'2398','364',15714.41,17073.26,1358.85,214698.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','163161',3229098,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163161',3229099,'2400','364',10763.46,11761.43,997.97,157679.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','163161',3229100,'2401','364',17791.43,19087.70,1296.27,204810.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','163161',3229101,'2402','364',7006.46,7006.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163161',3229102,'2403','364',8175.81,8824.30,645.07,101921.06,0.00,0.00,3.42,0.00,0.00),('1','157','838','163161',3229103,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163161',3229104,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163161',3229105,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163161',3229106,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163161',3229107,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163161',3229108,'2409','365',696738.80,697156.66,417.86,77304.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','163161',3229109,'2410','365',423118.41,423118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163161',3229110,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163161',3229111,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163163',3229131,'2389','364',4697.01,4697.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163163',3229132,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163163',3229133,'2391','364',6647.16,7801.06,1143.07,180605.06,0.00,0.00,10.83,0.00,0.00),('1','157','835','163163',3229134,'2392','364',2511.60,2511.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163163',3229135,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163163',3229136,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163163',3229137,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163163',3229138,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163163',3229139,'2397','364',9732.73,9732.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163163',3229140,'2398','364',17073.26,18688.36,1615.10,255185.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','163163',3229141,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163163',3229142,'2400','364',11761.43,12970.73,1209.30,191069.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163163',3229143,'2401','364',19087.70,20509.56,1421.86,224653.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','163163',3229144,'2402','364',7006.46,7006.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163163',3229145,'2403','364',8824.30,9606.90,782.60,123650.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163163',3229146,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163163',3229147,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163163',3229148,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163163',3229149,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163163',3229150,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163163',3229151,'2409','365',697156.66,697894.63,737.97,136524.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','163163',3229152,'2410','365',423118.41,423118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163163',3229153,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163163',3229154,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163286',3231127,'2389','364',4697.01,5377.54,680.53,107523.74,0.00,0.00,0.00,0.00,0.00),('1','157','835','163286',3231128,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163286',3231129,'2391','364',7801.06,7801.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163286',3231130,'2392','364',2511.60,3248.82,737.22,116480.76,0.00,0.00,0.00,0.00,0.00),('1','157','836','163286',3231131,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163286',3231132,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163286',3231133,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163286',3231134,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163286',3231135,'2397','364',9732.73,9732.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163286',3231136,'2398','364',18688.36,20025.23,1336.87,211225.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','163286',3231137,'2399','364',7810.48,7810.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163286',3231138,'2400','364',12970.73,14277.21,1306.48,206423.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','163286',3231139,'2401','364',20509.56,21288.92,779.36,123138.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','163286',3231140,'2402','364',7006.46,7006.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163286',3231141,'2403','364',9606.90,10396.09,789.19,124692.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','163286',3231142,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163286',3231143,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163286',3231144,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163286',3231145,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163286',3231146,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163286',3231147,'2409','365',697894.63,698041.72,147.09,27211.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','163286',3231148,'2410','365',423118.41,423118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163286',3231149,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163286',3231150,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163290',3231191,'2389','364',5377.54,5717.40,339.86,53697.88,0.00,0.00,0.00,0.00,0.00),('1','157','835','163290',3231192,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163290',3231193,'2391','364',7801.06,8364.13,563.07,88965.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','163290',3231194,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163290',3231195,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163290',3231196,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163290',3231197,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163290',3231198,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163290',3231199,'2397','364',9732.73,11033.45,1300.72,205513.76,0.00,0.00,0.00,0.00,0.00),('1','157','837','163290',3231200,'2398','364',20025.23,20589.99,564.76,89232.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','163290',3231201,'2399','364',7810.48,8490.81,680.33,107492.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','163290',3231202,'2400','364',14277.21,14277.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163290',3231203,'2401','364',21288.92,22502.49,1213.57,191744.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','163290',3231204,'2402','364',7006.46,7006.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163290',3231205,'2403','364',10396.09,11509.80,1113.71,175966.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','163290',3231206,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163290',3231207,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163290',3231208,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163290',3231209,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163290',3231210,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163290',3231211,'2409','365',698041.72,698084.96,43.24,7999.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','163290',3231212,'2410','365',423118.41,423118.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163290',3231213,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163290',3231214,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163292',3231255,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163292',3231256,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163292',3231257,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163292',3231258,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163292',3231259,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163292',3231260,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163292',3231261,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163292',3231262,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163292',3231263,'2397','364',11033.45,12441.32,1407.87,222443.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','163292',3231264,'2398','364',20589.99,21562.61,972.62,153673.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','163292',3231265,'2399','364',8490.81,9079.60,588.79,93028.82,0.00,0.00,0.00,0.00,0.00),('1','157','837','163292',3231266,'2400','364',14277.21,15152.09,874.88,138231.04,0.00,0.00,0.00,0.00,0.00),('1','157','838','163292',3231267,'2401','364',22502.49,23693.29,1190.80,188146.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163292',3231268,'2402','364',7006.46,7006.65,0.00,0.00,0.00,0.00,0.19,0.00,0.00),('1','157','838','163292',3231269,'2403','364',11509.80,12385.02,875.22,138284.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','163292',3231270,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163292',3231271,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163292',3231272,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163292',3231273,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163292',3231274,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163292',3231275,'2409','365',698084.96,698084.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163292',3231276,'2410','365',423118.41,424099.22,980.81,181449.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','163292',3231277,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163292',3231278,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163295',3231349,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163295',3231350,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163295',3231351,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163295',3231352,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163295',3231353,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163295',3231354,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163295',3231355,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163295',3231356,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163295',3231357,'2397','364',12441.32,13155.37,714.05,112819.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','163295',3231358,'2398','364',21562.61,22851.41,1288.80,203630.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163295',3231359,'2399','364',9079.60,10589.05,1509.45,238493.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','163295',3231360,'2400','364',15152.09,16490.81,1338.72,211517.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','163295',3231361,'2401','364',23693.29,24237.84,544.55,86038.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','163295',3231362,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163295',3231363,'2403','364',12385.02,12708.32,323.30,51081.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','163295',3231364,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163295',3231365,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163295',3231366,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163295',3231367,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163295',3231368,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163295',3231369,'2409','365',698084.96,698598.73,513.77,95047.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','163295',3231370,'2410','365',424099.22,424099.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163295',3231371,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163295',3231372,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163479',3234673,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163479',3234674,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163479',3234675,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163479',3234676,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163479',3234677,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163479',3234678,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163479',3234679,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163479',3234680,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163479',3234681,'2397','364',13155.37,14927.45,1772.08,279988.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','163479',3234682,'2398','364',22851.41,24926.26,2074.85,327826.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','163479',3234683,'2399','364',10589.05,13075.92,2486.87,392925.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','163479',3234684,'2400','364',16490.81,18333.75,1842.94,291184.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','163479',3234685,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163479',3234686,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163479',3234687,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163479',3234688,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163479',3234689,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163479',3234690,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163479',3234691,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163479',3234692,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163479',3234693,'2409','365',698598.73,698773.33,174.60,32301.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163479',3234694,'2410','365',424099.22,424099.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163479',3234695,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163479',3234696,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163481',3234725,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163481',3234726,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163481',3234727,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163481',3234728,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163481',3234729,'2393','364',11269.65,11269.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163481',3234730,'2394','364',12362.77,12362.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163481',3234731,'2395','364',11040.67,11040.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163481',3234732,'2396','364',16824.44,16824.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163481',3234733,'2397','364',14927.45,17186.28,2258.83,356895.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','163481',3234734,'2398','364',24926.26,27390.84,2464.58,389403.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','163481',3234735,'2399','364',13075.92,15506.56,2430.64,384041.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','163481',3234736,'2400','364',18333.75,19990.32,1656.57,261738.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','163481',3234737,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163481',3234738,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163481',3234739,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163481',3234740,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163481',3234741,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163481',3234742,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163481',3234743,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163481',3234744,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163481',3234745,'2409','365',698773.33,698873.06,99.73,18450.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','163481',3234746,'2410','365',424099.22,424099.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163481',3234747,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163481',3234748,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163482',3234749,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163482',3234750,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163482',3234751,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163482',3234752,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163482',3234753,'2393','364',11269.65,13475.69,2206.04,348554.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','163482',3234754,'2394','364',12362.77,14636.18,2273.41,359198.78,0.00,0.00,0.00,0.00,0.00),('1','157','836','163482',3234755,'2395','364',11040.67,13510.54,2469.87,390239.46,0.00,0.00,0.00,0.00,0.00),('1','157','836','163482',3234756,'2396','364',16824.44,18761.16,1936.72,306001.76,0.00,0.00,0.00,0.00,0.00),('1','157','837','163482',3234757,'2397','364',17186.28,17186.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163482',3234758,'2398','364',27390.84,28025.71,634.87,100309.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','163482',3234759,'2399','364',15506.56,15859.69,353.13,55794.54,0.00,0.00,0.00,0.00,0.00),('1','157','837','163482',3234760,'2400','364',19990.32,19990.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163482',3234761,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163482',3234762,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163482',3234763,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163482',3234764,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163482',3234765,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163482',3234766,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163482',3234767,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163482',3234768,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163482',3234769,'2409','365',698873.06,699394.36,521.30,96440.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','163482',3234770,'2410','365',424099.22,424099.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163482',3234771,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163482',3234772,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163490',3234932,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163490',3234933,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163490',3234934,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163490',3234935,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163490',3234936,'2393','364',13475.69,15453.26,1977.57,312456.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','163490',3234937,'2394','364',14636.18,16259.81,1623.63,256533.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','163490',3234938,'2395','364',13510.54,15311.61,1801.07,284569.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','163490',3234939,'2396','364',18761.16,20771.71,2010.55,317666.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','163490',3234940,'2397','364',17186.28,17186.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163490',3234941,'2398','364',28025.71,28025.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163490',3234942,'2399','364',15859.69,15859.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163490',3234943,'2400','364',19990.32,19990.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163490',3234944,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163490',3234945,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163490',3234946,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163490',3234947,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163490',3234948,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163490',3234949,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163490',3234950,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163490',3234951,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163490',3234952,'2409','365',699394.36,699394.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163490',3234953,'2410','365',424099.22,424212.74,113.52,21001.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','163490',3234954,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163490',3234955,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163494',3235014,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163494',3235015,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163494',3235016,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163494',3235017,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163494',3235018,'2393','364',15453.26,17702.55,2249.29,355387.82,0.00,0.00,0.00,0.00,0.00),('1','157','836','163494',3235019,'2394','364',16259.81,18678.71,2418.90,382186.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','163494',3235020,'2395','364',15311.61,17763.07,2451.46,387330.68,0.00,0.00,0.00,0.00,0.00),('1','157','836','163494',3235021,'2396','364',20771.71,23064.51,2292.80,362262.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163494',3235022,'2397','364',17186.28,17186.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163494',3235023,'2398','364',28025.71,28025.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163494',3235024,'2399','364',15859.69,15859.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163494',3235025,'2400','364',19990.32,19990.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163494',3235026,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163494',3235027,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163494',3235028,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163494',3235029,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163494',3235030,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163494',3235031,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163494',3235032,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163494',3235033,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163494',3235034,'2409','365',699394.36,700590.26,1195.90,221241.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','163494',3235035,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163494',3235036,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163494',3235037,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163499',3235102,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163499',3235103,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163499',3235104,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163499',3235105,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163499',3235106,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163499',3235107,'2394','364',18678.71,20514.02,1835.31,289978.98,0.00,0.00,0.00,0.00,0.00),('1','157','836','163499',3235108,'2395','364',17763.07,19130.11,1367.04,215992.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','163499',3235109,'2396','364',23064.51,23064.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163499',3235110,'2397','364',17186.28,18849.58,1663.30,262801.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163499',3235111,'2398','364',28025.71,28025.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163499',3235112,'2399','364',15859.69,17312.93,1453.24,229611.92,0.00,0.00,0.00,0.00,0.00),('1','157','837','163499',3235113,'2400','364',19990.32,21200.96,1210.64,191281.12,0.00,0.00,0.00,0.00,0.00),('1','157','838','163499',3235114,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163499',3235115,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163499',3235116,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163499',3235117,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163499',3235118,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163499',3235119,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163499',3235120,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163499',3235121,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163499',3235122,'2409','365',700590.26,700619.84,29.58,5472.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','163499',3235123,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163499',3235124,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163499',3235125,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163504',3235211,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163504',3235212,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163504',3235213,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163504',3235214,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163504',3235215,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163504',3235216,'2394','364',20514.02,20948.04,434.02,68575.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','163504',3235217,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163504',3235218,'2396','364',23064.51,23481.85,417.34,65939.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','163504',3235219,'2397','364',18849.58,21317.31,2467.73,389901.34,0.00,0.00,0.00,0.00,0.00),('1','157','837','163504',3235220,'2398','364',28025.71,30526.52,2500.81,395127.98,0.00,0.00,0.00,0.00,0.00),('1','157','837','163504',3235221,'2399','364',17312.93,19923.01,2610.08,412392.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','163504',3235222,'2400','364',21200.96,22400.68,1199.72,189555.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','163504',3235223,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163504',3235224,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163504',3235225,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163504',3235226,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163504',3235227,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163504',3235228,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163504',3235229,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163504',3235230,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163504',3235231,'2409','365',700619.84,700803.15,183.31,33912.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','163504',3235232,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163504',3235233,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163504',3235234,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163608',3237029,'2389','364',5717.40,5717.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163608',3237030,'2390','364',4494.36,4494.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163608',3237031,'2391','364',8364.13,8364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163608',3237032,'2392','364',3248.82,3248.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163608',3237033,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163608',3237034,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163608',3237035,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163608',3237036,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163608',3237037,'2397','364',21317.31,23724.23,2406.92,380293.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','163608',3237038,'2398','364',30526.52,32684.40,2157.88,340945.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','163608',3237039,'2399','364',19923.01,22455.31,2532.30,400103.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163608',3237040,'2400','364',22400.68,24295.64,1894.96,299403.68,0.00,0.00,0.00,0.00,0.00),('1','157','838','163608',3237041,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163608',3237042,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163608',3237043,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163608',3237044,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163608',3237045,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163608',3237046,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163608',3237047,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163608',3237048,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163608',3237049,'2409','365',700803.15,701145.83,342.68,63395.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','163608',3237050,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163608',3237051,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163608',3237052,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163611',3237104,'2389','364',5717.40,6257.70,540.30,85367.40,0.00,0.00,0.00,0.00,0.00),('1','157','835','163611',3237105,'2390','364',4494.36,5121.36,627.00,99066.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163611',3237106,'2391','364',8364.13,9175.20,811.07,128149.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','163611',3237107,'2392','364',3248.82,3285.71,36.89,5828.62,0.00,0.00,0.00,0.00,0.00),('1','157','836','163611',3237108,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163611',3237109,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163611',3237110,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163611',3237111,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163611',3237112,'2397','364',23724.23,25720.96,1996.73,315483.34,0.00,0.00,0.00,0.00,0.00),('1','157','837','163611',3237113,'2398','364',32684.40,34585.75,1901.35,300413.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','163611',3237114,'2399','364',22455.31,24787.63,2332.32,368506.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','163611',3237115,'2400','364',24295.64,25846.24,1550.60,244994.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','163611',3237116,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163611',3237117,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163611',3237118,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163611',3237119,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163611',3237120,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163611',3237121,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163611',3237122,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163611',3237123,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163611',3237124,'2409','365',701145.83,701425.82,279.99,51798.15,0.00,0.00,0.00,0.00,0.00),('1','157','840','163611',3237125,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163611',3237126,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163611',3237127,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163613',3237168,'2389','364',6257.70,8236.09,1978.39,312585.62,0.00,0.00,0.00,0.00,0.00),('1','157','835','163613',3237169,'2390','364',5121.36,6695.92,1574.56,248780.48,0.00,0.00,0.00,0.00,0.00),('1','157','835','163613',3237170,'2391','364',9175.20,11362.34,2187.14,345568.12,0.00,0.00,0.00,0.00,0.00),('1','157','835','163613',3237171,'2392','364',3285.71,5046.32,1760.61,278176.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','163613',3237172,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163613',3237173,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163613',3237174,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163613',3237175,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163613',3237176,'2397','364',25720.96,25720.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163613',3237177,'2398','364',34585.75,34585.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163613',3237178,'2399','364',24787.63,24787.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163613',3237179,'2400','364',25846.24,25846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163613',3237180,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163613',3237181,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163613',3237182,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163613',3237183,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163613',3237184,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163613',3237185,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163613',3237186,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163613',3237187,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163613',3237188,'2409','365',701425.82,702488.82,1063.00,196655.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163613',3237189,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163613',3237190,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163613',3237191,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163619',3237290,'2389','364',8236.09,10089.16,1853.07,292785.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','163619',3237291,'2390','364',6695.92,8190.00,1494.08,236064.64,0.00,0.00,0.00,0.00,0.00),('1','157','835','163619',3237292,'2391','364',11362.34,13067.99,1705.65,269492.70,0.00,0.00,0.00,0.00,0.00),('1','157','835','163619',3237293,'2392','364',5046.32,6932.88,1886.56,298076.48,0.00,0.00,0.00,0.00,0.00),('1','157','836','163619',3237294,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163619',3237295,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163619',3237296,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163619',3237297,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163619',3237298,'2397','364',25720.96,25720.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163619',3237299,'2398','364',34585.75,34585.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163619',3237300,'2399','364',24787.63,24787.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163619',3237301,'2400','364',25846.24,25846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163619',3237302,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163619',3237303,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163619',3237304,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163619',3237305,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163619',3237306,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163619',3237307,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163619',3237308,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163619',3237309,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163619',3237310,'2409','365',702488.82,702762.61,273.79,50651.15,0.00,0.00,0.00,0.00,0.00),('1','157','840','163619',3237311,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163619',3237312,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163619',3237313,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163623',3237379,'2389','364',10089.16,11669.19,1580.03,249644.74,0.00,0.00,0.00,0.00,0.00),('1','157','835','163623',3237380,'2390','364',8190.00,9612.20,1422.20,224707.60,0.00,0.00,0.00,0.00,0.00),('1','157','835','163623',3237381,'2391','364',13067.99,14575.66,1507.67,238211.86,0.00,0.00,0.00,0.00,0.00),('1','157','835','163623',3237382,'2392','364',6932.88,8912.33,1979.45,312753.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','163623',3237383,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163623',3237384,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163623',3237385,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163623',3237386,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163623',3237387,'2397','364',25720.96,25720.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163623',3237388,'2398','364',34585.75,34585.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163623',3237389,'2399','364',24787.63,24787.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163623',3237390,'2400','364',25846.24,25846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163623',3237391,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163623',3237392,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163623',3237393,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163623',3237394,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163623',3237395,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163623',3237396,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163623',3237397,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163623',3237398,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163623',3237399,'2409','365',702762.61,702976.13,213.52,39501.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','163623',3237400,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163623',3237401,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163623',3237402,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163626',3237436,'2389','364',11669.19,13271.08,1601.89,253098.62,0.00,0.00,0.00,0.00,0.00),('1','157','835','163626',3237437,'2390','364',9612.20,11643.27,2031.07,320909.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','163626',3237438,'2391','364',14575.66,16053.27,1477.61,233462.38,0.00,0.00,0.00,0.00,0.00),('1','157','835','163626',3237439,'2392','364',8912.33,10529.87,1617.54,255571.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','163626',3237440,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163626',3237441,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163626',3237442,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163626',3237443,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163626',3237444,'2397','364',25720.96,25720.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163626',3237445,'2398','364',34585.75,34585.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163626',3237446,'2399','364',24787.63,24787.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163626',3237447,'2400','364',25846.24,25846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163626',3237448,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163626',3237449,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163626',3237450,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163626',3237451,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163626',3237452,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163626',3237453,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163626',3237454,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163626',3237455,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163626',3237456,'2409','365',702976.13,703442.20,466.07,86222.95,0.00,0.00,0.00,0.00,0.00),('1','157','840','163626',3237457,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163626',3237458,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163626',3237459,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163629',3237494,'2389','364',13271.08,14904.56,1633.48,258089.84,0.00,0.00,0.00,0.00,0.00),('1','157','835','163629',3237495,'2390','364',11643.27,12997.82,1354.55,214018.90,0.00,0.00,0.00,0.00,0.00),('1','157','835','163629',3237496,'2391','364',16053.27,17580.80,1527.53,241349.74,0.00,0.00,0.00,0.00,0.00),('1','157','835','163629',3237497,'2392','364',10529.87,12194.11,1664.24,262949.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','163629',3237498,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163629',3237499,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163629',3237500,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163629',3237501,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163629',3237502,'2397','364',25720.96,25720.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163629',3237503,'2398','364',34585.75,34585.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163629',3237504,'2399','364',24787.63,24787.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163629',3237505,'2400','364',25846.24,25846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163629',3237506,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163629',3237507,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163629',3237508,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163629',3237509,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163629',3237510,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163629',3237511,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163629',3237512,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163629',3237513,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163629',3237514,'2409','365',703442.20,703794.16,351.96,65112.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','163629',3237515,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163629',3237516,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163629',3237517,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163631',3237528,'2389','364',14904.56,15362.85,458.29,72409.82,0.00,0.00,0.00,0.00,0.00),('1','157','835','163631',3237529,'2390','364',12997.82,14068.60,1070.78,169183.24,0.00,0.00,0.00,0.00,0.00),('1','157','835','163631',3237530,'2391','364',17580.80,18051.61,470.81,74387.98,0.00,0.00,0.00,0.00,0.00),('1','157','835','163631',3237531,'2392','364',12194.11,13390.75,1196.64,189069.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','163631',3237532,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163631',3237533,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163631',3237534,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163631',3237535,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163631',3237536,'2397','364',25720.96,26798.99,1078.03,170328.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','163631',3237537,'2398','364',34585.75,35666.83,1081.08,170810.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','163631',3237538,'2399','364',24787.63,26295.06,1507.43,238173.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','163631',3237539,'2400','364',25846.24,26534.60,688.36,108760.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','163631',3237540,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163631',3237541,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163631',3237542,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163631',3237543,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163631',3237544,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163631',3237545,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163631',3237546,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163631',3237547,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163631',3237548,'2409','365',703794.16,704235.25,441.09,81601.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','163631',3237549,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163631',3237550,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163631',3237551,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163634',3237573,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163634',3237574,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163634',3237575,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163634',3237576,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163634',3237577,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163634',3237578,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163634',3237579,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163634',3237580,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163634',3237581,'2397','364',26798.99,29060.89,2261.90,361904.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163634',3237582,'2398','364',35666.83,38164.89,2498.06,399689.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','163634',3237583,'2399','364',26295.06,28806.88,2511.82,401891.20,0.00,0.00,0.00,0.00,0.00),('1','157','837','163634',3237584,'2400','364',26534.60,28244.10,1709.50,273520.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163634',3237585,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163634',3237586,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163634',3237587,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163634',3237588,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163634',3237589,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163634',3237590,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163634',3237591,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163634',3237592,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163634',3237593,'2409','365',704235.25,704628.50,393.25,72751.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','163634',3237594,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163634',3237595,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163634',3237596,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163864',3241514,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163864',3241515,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163864',3241516,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163864',3241517,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163864',3241518,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163864',3241519,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163864',3241520,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163864',3241521,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163864',3241522,'2397','364',29060.89,29371.84,310.95,49752.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163864',3241523,'2398','364',38164.89,38512.98,348.09,55694.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','163864',3241524,'2399','364',28806.88,29218.23,411.35,65816.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163864',3241525,'2400','364',28244.10,28625.40,381.30,61008.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163864',3241526,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163864',3241527,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163864',3241528,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163864',3241529,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163864',3241530,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163864',3241531,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163864',3241532,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163864',3241533,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163864',3241534,'2409','365',704628.50,704628.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163864',3241535,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163864',3241536,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163864',3241537,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163865',3241538,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163865',3241539,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163865',3241540,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163865',3241541,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163865',3241542,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163865',3241543,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163865',3241544,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163865',3241545,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163865',3241546,'2397','364',29371.84,31688.74,2316.90,389239.20,0.00,0.00,0.00,0.00,0.00),('1','157','837','163865',3241547,'2398','364',38512.98,40257.73,1744.75,293118.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163865',3241548,'2399','364',29218.23,30880.08,1661.85,279190.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','163865',3241549,'2400','364',28625.40,30223.21,1597.81,268432.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','163865',3241550,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163865',3241551,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163865',3241552,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163865',3241553,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163865',3241554,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163865',3241555,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163865',3241556,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163865',3241557,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163865',3241558,'2409','365',704628.50,705507.13,878.63,162546.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','163865',3241559,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163865',3241560,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163865',3241561,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163866',3241562,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163866',3241563,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163866',3241564,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','163866',3241565,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163866',3241566,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163866',3241567,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163866',3241568,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','163866',3241569,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','163866',3241570,'2397','364',31688.74,32767.44,1078.70,181221.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','163866',3241571,'2398','364',40257.73,41749.45,1491.72,250608.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','163866',3241572,'2399','364',30880.08,32518.75,1638.67,275296.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','163866',3241573,'2400','364',30223.21,32109.15,1885.94,316837.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','163866',3241574,'2401','364',24237.84,24237.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163866',3241575,'2402','364',7006.65,7006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163866',3241576,'2403','364',12708.32,12708.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','163866',3241577,'2404','364',1910.37,1910.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163866',3241578,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163866',3241579,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163866',3241580,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','163866',3241581,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163866',3241582,'2409','365',705507.13,705703.33,196.20,36297.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163866',3241583,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163866',3241584,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','163866',3241585,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164071',3245445,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164071',3245446,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164071',3245447,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164071',3245448,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164071',3245449,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164071',3245450,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164071',3245451,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164071',3245452,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164071',3245453,'2397','364',32767.44,32767.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164071',3245454,'2398','364',41749.45,42602.82,853.37,143366.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','164071',3245455,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164071',3245456,'2400','364',32109.15,32622.25,513.10,86200.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','164071',3245457,'2401','364',24237.84,25248.29,1010.45,169755.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','164071',3245458,'2402','364',7006.65,7019.58,12.93,2172.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','164071',3245459,'2403','364',12708.32,13514.85,806.53,135497.04,0.00,0.00,0.00,0.00,0.00),('1','157','838','164071',3245460,'2404','364',1910.37,2435.70,520.33,87415.44,0.00,0.00,5.00,0.00,0.00),('1','157','839','164071',3245461,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164071',3245462,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164071',3245463,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164071',3245464,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164071',3245465,'2409','365',705703.33,705703.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164071',3245466,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164071',3245467,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164071',3245468,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164072',3245469,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164072',3245470,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164072',3245471,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164072',3245472,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164072',3245473,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164072',3245474,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164072',3245475,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164072',3245476,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164072',3245477,'2397','364',32767.44,32767.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164072',3245478,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164072',3245479,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164072',3245480,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164072',3245481,'2401','364',25248.29,25798.51,550.22,91336.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','164072',3245482,'2402','364',7019.58,7801.39,781.81,129780.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','164072',3245483,'2403','364',13514.85,14315.38,800.53,132887.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','164072',3245484,'2404','364',2435.70,3152.90,717.20,119055.20,0.00,0.00,0.00,0.00,0.00),('1','157','839','164072',3245485,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164072',3245486,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164072',3245487,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164072',3245488,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164072',3245489,'2409','365',705703.33,706184.65,481.32,89044.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','164072',3245490,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164072',3245491,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164072',3245492,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164073',3245493,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164073',3245494,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164073',3245495,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164073',3245496,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164073',3245497,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164073',3245498,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164073',3245499,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164073',3245500,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164073',3245501,'2397','364',32767.44,33124.33,356.89,59243.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','164073',3245502,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164073',3245503,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164073',3245504,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164073',3245505,'2401','364',25798.51,27602.30,1803.79,299429.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','164073',3245506,'2402','364',7801.39,8885.69,1084.30,179993.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','164073',3245507,'2403','364',14315.38,14833.09,517.71,85939.86,0.00,0.00,0.00,0.00,0.00),('1','157','838','164073',3245508,'2404','364',3152.90,4664.96,1512.06,251001.96,0.00,0.00,0.00,0.00,0.00),('1','157','839','164073',3245509,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164073',3245510,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164073',3245511,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164073',3245512,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164073',3245513,'2409','365',706184.65,706284.65,100.00,18500.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164073',3245514,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164073',3245515,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164073',3245516,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164140',3246483,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164140',3246484,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164140',3246485,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164140',3246486,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164140',3246487,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164140',3246488,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164140',3246489,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164140',3246490,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164140',3246491,'2397','364',33124.33,33124.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164140',3246492,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164140',3246493,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164140',3246494,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164140',3246495,'2401','364',27602.30,30128.15,2525.85,419291.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','164140',3246496,'2402','364',8885.69,10521.10,1635.41,271478.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','164140',3246497,'2403','364',14833.09,17032.21,2199.12,365053.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','164140',3246498,'2404','364',4664.96,6054.36,1389.40,230640.40,0.00,0.00,0.00,0.00,0.00),('1','157','839','164140',3246499,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164140',3246500,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164140',3246501,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164140',3246502,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164140',3246503,'2409','365',706284.65,706689.01,404.36,74806.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','164140',3246504,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164140',3246505,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164140',3246506,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164142',3246525,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164142',3246526,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164142',3246527,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164142',3246528,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164142',3246529,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164142',3246530,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164142',3246531,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164142',3246532,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164142',3246533,'2397','364',33124.33,33124.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164142',3246534,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164142',3246535,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164142',3246536,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164142',3246537,'2401','364',30128.15,32484.23,2356.08,391109.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','164142',3246538,'2402','364',10521.10,12265.54,1734.44,287917.04,0.00,0.00,10.00,0.00,0.00),('1','157','838','164142',3246539,'2403','364',17032.21,19122.47,2090.26,346983.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','164142',3246540,'2404','364',6054.36,7756.10,1701.74,282488.84,0.00,0.00,0.00,0.00,0.00),('1','157','839','164142',3246541,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164142',3246542,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164142',3246543,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164142',3246544,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164142',3246545,'2409','365',706689.01,706969.02,280.01,51801.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','164142',3246546,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164142',3246547,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164142',3246548,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164203',3247760,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164203',3247761,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164203',3247762,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164203',3247763,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164203',3247764,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164203',3247765,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164203',3247766,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164203',3247767,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164203',3247768,'2397','364',33124.33,33124.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164203',3247769,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164203',3247770,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164203',3247771,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164203',3247772,'2401','364',32484.23,33593.81,1109.58,184190.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','164203',3247773,'2402','364',12265.54,13357.49,1091.95,181263.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','164203',3247774,'2403','364',19122.47,20323.44,1200.97,199361.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','164203',3247775,'2404','364',7756.10,8519.74,763.64,126764.24,0.00,0.00,0.00,0.00,0.00),('1','157','839','164203',3247776,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164203',3247777,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164203',3247778,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164203',3247779,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164203',3247780,'2409','365',706969.02,707561.96,592.94,109693.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','164203',3247781,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164203',3247782,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164203',3247783,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164207',3247836,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164207',3247837,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164207',3247838,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164207',3247839,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164207',3247840,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164207',3247841,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164207',3247842,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164207',3247843,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164207',3247844,'2397','364',33124.33,33124.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164207',3247845,'2398','364',42602.82,42602.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164207',3247846,'2399','364',32518.75,32518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164207',3247847,'2400','364',32622.25,32622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164207',3247848,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164207',3247849,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164207',3247850,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164207',3247851,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164207',3247852,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164207',3247853,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164207',3247854,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164207',3247855,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164207',3247856,'2409','365',707561.96,707616.55,54.59,10099.15,0.00,0.00,0.00,0.00,0.00),('1','157','840','164207',3247857,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164207',3247858,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164207',3247859,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164209',3247876,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164209',3247877,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164209',3247878,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164209',3247879,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164209',3247880,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164209',3247881,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164209',3247882,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164209',3247883,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164209',3247884,'2397','364',33124.33,34673.69,1549.36,257193.76,0.00,0.00,0.00,0.00,0.00),('1','157','837','164209',3247885,'2398','364',42602.82,44234.43,1631.61,270847.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','164209',3247886,'2399','364',32518.75,34491.81,1970.06,327029.96,0.00,0.00,3.00,0.00,0.00),('1','157','837','164209',3247887,'2400','364',32622.25,35003.27,2381.02,395249.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','164209',3247888,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164209',3247889,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164209',3247890,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164209',3247891,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164209',3247892,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164209',3247893,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164209',3247894,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164209',3247895,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164209',3247896,'2409','365',707616.55,708015.41,398.86,73789.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','164209',3247897,'2410','365',424212.74,424212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164209',3247898,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164209',3247899,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164265',3248796,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164265',3248797,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164265',3248798,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164265',3248799,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164265',3248800,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164265',3248801,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164265',3248802,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164265',3248803,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164265',3248804,'2397','364',34673.69,35934.94,1261.25,209367.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','164265',3248805,'2398','364',44234.43,45454.98,1220.55,202611.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','164265',3248806,'2399','364',34491.81,35692.21,1200.40,199266.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','164265',3248807,'2400','364',35003.27,36132.76,1129.49,187495.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','164265',3248808,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164265',3248809,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164265',3248810,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164265',3248811,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164265',3248812,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164265',3248813,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164265',3248814,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164265',3248815,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164265',3248816,'2409','365',582.96,582.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164265',3248817,'2410','365',649.44,822.41,172.97,31999.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','164265',3248818,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164265',3248819,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164267',3248838,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164267',3248839,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164267',3248840,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164267',3248841,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164267',3248842,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164267',3248843,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164267',3248844,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164267',3248845,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164267',3248846,'2397','364',35934.94,36076.29,141.35,23464.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','164267',3248847,'2398','364',45454.98,45739.14,284.16,47170.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','164267',3248848,'2399','364',35692.21,35936.25,244.04,40510.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','164267',3248849,'2400','364',36132.76,36397.83,265.07,44001.62,0.00,0.00,0.00,0.00,0.00),('1','157','838','164267',3248850,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164267',3248851,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164267',3248852,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164267',3248853,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164267',3248854,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164267',3248855,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164267',3248856,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164267',3248857,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164267',3248858,'2409','365',582.96,582.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164267',3248859,'2410','365',822.41,1028.12,205.71,38056.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','164267',3248860,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164267',3248861,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164269',3248878,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164269',3248879,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164269',3248880,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164269',3248881,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164269',3248882,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164269',3248883,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164269',3248884,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164269',3248885,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164269',3248886,'2397','364',36076.29,36076.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164269',3248887,'2398','364',45739.14,45739.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164269',3248888,'2399','364',35936.25,35936.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164269',3248889,'2400','364',36397.83,36397.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164269',3248890,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164269',3248891,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164269',3248892,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164269',3248893,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164269',3248894,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164269',3248895,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164269',3248896,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164269',3248897,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164269',3248898,'2409','365',582.96,582.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164269',3248899,'2410','365',1028.12,1109.73,81.61,15097.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','164269',3248900,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164269',3248901,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164270',3248902,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164270',3248903,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164270',3248904,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164270',3248905,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164270',3248906,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164270',3248907,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164270',3248908,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164270',3248909,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164270',3248910,'2397','364',36076.29,37608.42,1532.13,254333.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','164270',3248911,'2398','364',45739.14,47614.18,1875.04,311256.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','164270',3248912,'2399','364',35936.25,37924.17,1987.92,329994.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','164270',3248913,'2400','364',36397.83,37882.42,1484.59,246441.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','164270',3248914,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164270',3248915,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164270',3248916,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164270',3248917,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164270',3248918,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164270',3248919,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164270',3248920,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164270',3248921,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164270',3248922,'2409','365',582.96,614.85,31.89,5899.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','164270',3248923,'2410','365',1109.73,1193.50,83.77,15497.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','164270',3248924,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164270',3248925,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164271',3248926,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164271',3248927,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164271',3248928,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164271',3248929,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164271',3248930,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164271',3248931,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164271',3248932,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164271',3248933,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164271',3248934,'2397','364',37608.42,39318.98,1710.56,283952.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','164271',3248935,'2398','364',47614.18,48937.23,1323.05,219626.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','164271',3248936,'2399','364',37924.17,39261.02,1336.85,221917.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','164271',3248937,'2400','364',37882.42,39300.17,1417.75,235346.50,0.00,0.00,0.00,0.00,0.00),('1','157','838','164271',3248938,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164271',3248939,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164271',3248940,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164271',3248941,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164271',3248942,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164271',3248943,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164271',3248944,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164271',3248945,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164271',3248946,'2409','365',614.85,614.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164271',3248947,'2410','365',1193.50,1447.27,253.77,46947.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','164271',3248948,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164271',3248949,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164272',3248950,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164272',3248951,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164272',3248952,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164272',3248953,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164272',3248954,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164272',3248955,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164272',3248956,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164272',3248957,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164272',3248958,'2397','364',39318.98,40820.38,1501.40,249232.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','164272',3248959,'2398','364',48937.23,51408.80,2471.57,410280.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','164272',3248960,'2399','364',39261.02,40745.07,1484.05,246352.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','164272',3248961,'2400','364',39300.17,40583.80,1283.63,213082.58,0.00,0.00,0.00,0.00,0.00),('1','157','838','164272',3248962,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164272',3248963,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164272',3248964,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164272',3248965,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164272',3248966,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164272',3248967,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164272',3248968,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164272',3248969,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164272',3248970,'2409','365',614.85,875.40,260.55,48201.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','164272',3248971,'2410','365',1447.27,1447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164272',3248972,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164272',3248973,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164273',3248974,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164273',3248975,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164273',3248976,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164273',3248977,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164273',3248978,'2393','364',17702.55,17702.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164273',3248979,'2394','364',20948.04,20948.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164273',3248980,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164273',3248981,'2396','364',23481.85,23481.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164273',3248982,'2397','364',40820.38,42482.98,1662.60,275991.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','164273',3248983,'2398','364',51408.80,52766.31,1357.51,225346.66,0.00,0.00,0.00,0.00,0.00),('1','157','837','164273',3248984,'2399','364',40745.07,42503.37,1758.30,291877.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','164273',3248985,'2400','364',40583.80,41874.93,1291.13,214327.58,0.00,0.00,0.00,0.00,0.00),('1','157','838','164273',3248986,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164273',3248987,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164273',3248988,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164273',3248989,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164273',3248990,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164273',3248991,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164273',3248992,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164273',3248993,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164273',3248994,'2409','365',875.40,1300.66,425.26,78673.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','164273',3248995,'2410','365',1447.27,1447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164273',3248996,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164273',3248997,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164274',3248998,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164274',3248999,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164274',3249000,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164274',3249001,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164274',3249002,'2393','364',17702.55,18959.91,1257.36,208721.76,0.00,0.00,0.00,0.00,0.00),('1','157','836','164274',3249003,'2394','364',20948.04,20948.86,0.00,0.00,0.00,0.00,0.82,0.00,0.00),('1','157','836','164274',3249004,'2395','364',19130.11,19130.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164274',3249005,'2396','364',23481.85,25207.48,1725.63,286454.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','164274',3249006,'2397','364',42482.98,42482.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164274',3249007,'2398','364',52766.31,54403.27,1636.96,271735.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','164274',3249008,'2399','364',42503.37,43531.75,1028.38,170711.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','164274',3249009,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164274',3249010,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164274',3249011,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164274',3249012,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164274',3249013,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164274',3249014,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164274',3249015,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164274',3249016,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164274',3249017,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164274',3249018,'2409','365',1300.66,1300.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164274',3249019,'2410','365',1447.27,1504.30,57.03,10550.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','164274',3249020,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164274',3249021,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164275',3249022,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164275',3249023,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164275',3249024,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164275',3249025,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164275',3249026,'2393','364',18959.91,20360.71,1400.80,232532.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','164275',3249027,'2394','364',20948.86,20948.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164275',3249028,'2395','364',19130.11,20116.77,986.66,163785.56,0.00,0.00,0.00,0.00,0.00),('1','157','836','164275',3249029,'2396','364',25207.48,26426.48,1219.00,202354.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164275',3249030,'2397','364',42482.98,42482.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164275',3249031,'2398','364',54403.27,55895.19,1491.92,247658.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','164275',3249032,'2399','364',43531.75,43531.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164275',3249033,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164275',3249034,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164275',3249035,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164275',3249036,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164275',3249037,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164275',3249038,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164275',3249039,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164275',3249040,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164275',3249041,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164275',3249042,'2409','365',1300.66,1300.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164275',3249043,'2410','365',1504.30,1525.92,21.62,3999.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','164275',3249044,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164275',3249045,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164276',3249046,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164276',3249047,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164276',3249048,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164276',3249049,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164276',3249050,'2393','364',20360.71,22234.36,1873.65,311025.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','164276',3249051,'2394','364',20948.86,22228.57,1279.71,212431.86,0.00,0.00,0.00,0.00,0.00),('1','157','836','164276',3249052,'2395','364',20116.77,21676.62,1559.85,258935.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','164276',3249053,'2396','364',26426.48,27784.09,1357.61,225363.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','164276',3249054,'2397','364',42482.98,42790.88,307.90,51111.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','164276',3249055,'2398','364',55895.19,55895.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164276',3249056,'2399','364',43531.75,43531.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164276',3249057,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164276',3249058,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164276',3249059,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164276',3249060,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164276',3249061,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164276',3249062,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164276',3249063,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164276',3249064,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164276',3249065,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164276',3249066,'2409','365',1300.66,1536.89,236.23,43702.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','164276',3249067,'2410','365',1525.92,1525.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164276',3249068,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164276',3249069,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164279',3249097,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164279',3249098,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164279',3249099,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164279',3249100,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164279',3249101,'2393','364',22234.36,23554.77,1320.41,219188.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','164279',3249102,'2394','364',22228.57,23596.98,1368.41,227156.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','164279',3249103,'2395','364',21676.62,23550.03,1873.41,310986.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','164279',3249104,'2396','364',27784.09,29399.44,1615.35,268148.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','164279',3249105,'2397','364',42790.88,42790.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164279',3249106,'2398','364',55895.19,55895.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164279',3249107,'2399','364',43531.75,43531.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164279',3249108,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164279',3249109,'2401','364',33593.81,33593.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164279',3249110,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164279',3249111,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164279',3249112,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164279',3249113,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164279',3249114,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164279',3249115,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164279',3249116,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164279',3249117,'2409','365',1536.89,2033.74,496.85,91917.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','164279',3249118,'2410','365',1525.92,1525.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164279',3249119,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164279',3249120,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164281',3249132,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164281',3249133,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164281',3249134,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164281',3249135,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164281',3249136,'2393','364',23554.77,24963.09,1408.32,233781.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','164281',3249137,'2394','364',23596.98,23796.14,199.16,33060.56,0.00,0.00,0.00,0.00,0.00),('1','157','836','164281',3249138,'2395','364',23550.03,23820.00,269.97,44815.02,0.00,0.00,0.00,0.00,0.00),('1','157','836','164281',3249139,'2396','364',29399.44,31299.60,1900.16,315426.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','164281',3249140,'2397','364',42790.88,43951.26,1160.38,192623.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','164281',3249141,'2398','364',55895.19,55895.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164281',3249142,'2399','364',43531.75,44616.35,1084.60,180043.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','164281',3249143,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164281',3249144,'2401','364',33593.81,34577.34,983.53,163265.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','164281',3249145,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164281',3249146,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164281',3249147,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164281',3249148,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164281',3249149,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164281',3249150,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164281',3249151,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164281',3249152,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164281',3249153,'2410','365',1525.92,2477.00,951.08,175949.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','164281',3249154,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164281',3249155,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164837',3259258,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164837',3259259,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164837',3259260,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164837',3259261,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164837',3259262,'2393','364',24963.09,26219.02,1245.93,206824.38,0.00,0.00,10.00,0.00,0.00),('1','157','836','164837',3259263,'2394','364',23796.14,24219.13,412.99,68556.34,0.00,0.00,10.00,0.00,0.00),('1','157','836','164837',3259264,'2395','364',23820.00,24871.56,1041.56,172898.96,0.00,0.00,10.00,0.00,0.00),('1','157','836','164837',3259265,'2396','364',31299.60,32962.46,1652.86,274374.76,0.00,0.00,10.00,0.00,0.00),('1','157','837','164837',3259266,'2397','364',43951.26,45207.63,1246.37,206897.42,0.00,0.00,10.00,0.00,0.00),('1','157','837','164837',3259267,'2398','364',55895.19,55895.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164837',3259268,'2399','364',44616.35,45357.14,730.79,121311.14,0.00,0.00,10.00,0.00,0.00),('1','157','837','164837',3259269,'2400','364',41874.93,41874.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164837',3259270,'2401','364',34577.34,34577.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164837',3259271,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164837',3259272,'2403','364',20323.44,20323.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164837',3259273,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164837',3259274,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164837',3259275,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164837',3259276,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164837',3259277,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164837',3259278,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164837',3259279,'2410','365',2477.00,2687.28,210.28,38901.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','164837',3259280,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164837',3259281,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164839',3259298,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164839',3259299,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164839',3259300,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164839',3259301,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164839',3259302,'2393','364',26219.02,26749.30,530.28,88026.48,0.00,0.00,0.00,0.00,0.00),('1','157','836','164839',3259303,'2394','364',24219.13,24769.45,550.32,91353.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','164839',3259304,'2395','364',24871.56,25749.14,877.58,145678.28,0.00,0.00,0.00,0.00,0.00),('1','157','836','164839',3259305,'2396','364',32962.46,33901.13,938.67,155819.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','164839',3259306,'2397','364',45207.63,46720.19,1512.56,251084.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','164839',3259307,'2398','364',55895.19,56958.15,1062.96,176451.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','164839',3259308,'2399','364',45357.14,45357.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164839',3259309,'2400','364',41874.93,42867.90,992.97,164833.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','164839',3259310,'2401','364',34577.34,35064.98,487.64,80948.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','164839',3259311,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164839',3259312,'2403','364',20323.44,20595.14,271.70,45102.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','164839',3259313,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164839',3259314,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164839',3259315,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164839',3259316,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164839',3259317,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164839',3259318,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164839',3259319,'2410','365',2687.28,2708.90,21.62,3999.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','164839',3259320,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164839',3259321,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164841',3259338,'2389','364',15362.85,15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164841',3259339,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164841',3259340,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164841',3259341,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164841',3259342,'2393','364',26749.30,26749.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164841',3259343,'2394','364',24769.45,24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164841',3259344,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164841',3259345,'2396','364',33901.13,33901.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164841',3259346,'2397','364',46720.19,48361.24,1631.74,270868.84,0.00,0.00,9.31,0.00,0.00),('1','157','837','164841',3259347,'2398','364',56958.15,56965.96,0.01,1.66,0.00,0.00,7.80,0.00,0.00),('1','157','837','164841',3259348,'2399','364',45357.14,45364.32,0.00,0.00,0.00,0.00,7.18,0.00,0.00),('1','157','837','164841',3259349,'2400','364',42867.90,44591.63,1715.90,284839.40,0.00,0.00,7.83,0.00,0.00),('1','157','838','164841',3259350,'2401','364',35064.98,36579.25,1476.27,245060.82,0.00,0.00,38.00,0.00,0.00),('1','157','838','164841',3259351,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164841',3259352,'2403','364',20595.14,22091.93,1471.79,244317.14,0.00,0.00,25.00,0.00,0.00),('1','157','838','164841',3259353,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164841',3259354,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164841',3259355,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164841',3259356,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164841',3259357,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164841',3259358,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164841',3259359,'2410','365',2708.90,4176.49,1467.59,278842.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','164841',3259360,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164841',3259361,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164843',3259364,'2389','364',15362.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164843',3259365,'2390','364',14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164843',3259366,'2391','364',18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164843',3259367,'2392','364',13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164843',3259368,'2393','364',26749.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164843',3259369,'2394','364',24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164843',3259370,'2395','364',25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164843',3259371,'2396','364',33901.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164843',3259372,'2397','364',48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164843',3259373,'2398','364',56965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164843',3259374,'2399','364',45364.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164843',3259375,'2400','364',44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164843',3259376,'2401','364',36579.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164843',3259377,'2402','364',13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164843',3259378,'2403','364',22091.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164843',3259379,'2404','364',8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164843',3259380,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164843',3259381,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164843',3259382,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164843',3259383,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164843',3259384,'2409','365',2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164843',3259385,'2410','365',4176.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164843',3259386,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164843',3259387,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164844',3259388,'2389','364',15362.85,16480.54,1117.69,185536.54,0.00,0.00,0.00,0.00,0.00),('1','157','835','164844',3259389,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164844',3259390,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164844',3259391,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164844',3259392,'2393','364',26749.30,27763.73,1014.43,168395.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','164844',3259393,'2394','364',24769.45,24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164844',3259394,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164844',3259395,'2396','364',33901.13,35324.88,1423.75,236342.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','164844',3259396,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164844',3259397,'2398','364',56965.96,58525.36,1559.40,258860.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','164844',3259398,'2399','364',45364.32,45364.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164844',3259399,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164844',3259400,'2401','364',36579.25,37616.03,1036.78,172105.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','164844',3259401,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164844',3259402,'2403','364',22091.93,22850.29,758.36,125887.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','164844',3259403,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164844',3259404,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164844',3259405,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164844',3259406,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164844',3259407,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164844',3259408,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164844',3259409,'2410','365',4176.49,4223.34,46.85,8901.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','164844',3259410,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164844',3259411,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164845',3259412,'2389','364',16480.54,17576.69,1096.15,181960.90,0.00,0.00,0.00,0.00,0.00),('1','157','835','164845',3259413,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164845',3259414,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164845',3259415,'2392','364',13390.75,13390.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164845',3259416,'2393','364',27763.73,28528.82,765.09,127004.94,0.00,0.00,0.00,0.00,0.00),('1','157','836','164845',3259417,'2394','364',24769.45,24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164845',3259418,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164845',3259419,'2396','364',35324.88,37183.84,1858.96,308587.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','164845',3259420,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164845',3259421,'2398','364',58525.36,59760.02,1234.66,204953.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','164845',3259422,'2399','364',45364.32,45364.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164845',3259423,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164845',3259424,'2401','364',37616.03,38661.44,1045.41,173538.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','164845',3259425,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164845',3259426,'2403','364',22850.29,22850.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164845',3259427,'2404','364',8519.74,8519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164845',3259428,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164845',3259429,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164845',3259430,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164845',3259431,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164845',3259432,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164845',3259433,'2410','365',4223.34,4673.09,449.75,87701.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','164845',3259434,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164845',3259435,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164846',3259436,'2389','364',17576.69,18996.32,1419.63,235658.58,0.00,0.00,0.00,0.00,0.00),('1','157','835','164846',3259437,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164846',3259438,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164846',3259439,'2392','364',13390.75,14226.34,835.59,138707.94,0.00,0.00,0.00,0.00,0.00),('1','157','836','164846',3259440,'2393','364',28528.82,28528.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164846',3259441,'2394','364',24769.45,24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164846',3259442,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164846',3259443,'2396','364',37183.84,38638.48,1454.64,241470.24,0.00,0.00,0.00,0.00,0.00),('1','157','837','164846',3259444,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164846',3259445,'2398','364',59760.02,61655.29,1895.27,314614.82,0.00,0.00,0.00,0.00,0.00),('1','157','837','164846',3259446,'2399','364',45364.32,46741.62,1377.30,228631.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','164846',3259447,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164846',3259448,'2401','364',38661.44,38661.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164846',3259449,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164846',3259450,'2403','364',22850.29,22850.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164846',3259451,'2404','364',8519.74,8984.21,464.47,77102.02,0.00,0.00,0.00,0.00,0.00),('1','157','839','164846',3259452,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164846',3259453,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164846',3259454,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164846',3259455,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164846',3259456,'2409','365',2033.74,2033.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164846',3259457,'2410','365',4673.09,5041.24,368.15,71789.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','164846',3259458,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164846',3259459,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164850',3259537,'2389','364',18996.32,20300.71,1304.39,216528.74,0.00,0.00,0.00,0.00,0.00),('1','157','835','164850',3259538,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164850',3259539,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164850',3259540,'2392','364',14226.34,14226.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164850',3259541,'2393','364',28528.82,28905.35,376.53,62503.98,0.00,0.00,0.00,0.00,0.00),('1','157','836','164850',3259542,'2394','364',24769.45,24769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164850',3259543,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164850',3259544,'2396','364',38638.48,40206.24,1567.76,260248.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','164850',3259545,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164850',3259546,'2398','364',61655.29,62891.66,1236.37,205237.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','164850',3259547,'2399','364',46741.62,48330.40,1588.78,263737.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','164850',3259548,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164850',3259549,'2401','364',38661.44,39140.64,479.20,79547.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','164850',3259550,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164850',3259551,'2403','364',22850.29,23580.76,720.47,119598.02,0.00,0.00,10.00,0.00,0.00),('1','157','838','164850',3259552,'2404','364',8984.21,8984.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164850',3259553,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164850',3259554,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164850',3259555,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164850',3259556,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164850',3259557,'2409','365',2033.74,2133.74,100.00,19500.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164850',3259558,'2410','365',5041.24,5354.59,313.35,61103.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','164850',3259559,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164850',3259560,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164855',3259628,'2389','364',20300.71,20300.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164855',3259629,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164855',3259630,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164855',3259631,'2392','364',14226.34,15251.62,1025.28,170196.48,0.00,0.00,0.00,0.00,0.00),('1','157','836','164855',3259632,'2393','364',28905.35,28905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164855',3259633,'2394','364',24769.45,26083.09,1313.64,218064.24,0.00,0.00,0.00,0.00,0.00),('1','157','836','164855',3259634,'2395','364',25749.14,25749.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164855',3259635,'2396','364',40206.24,42486.00,2279.76,378440.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','164855',3259636,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164855',3259637,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164855',3259638,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164855',3259639,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164855',3259640,'2401','364',39140.64,40036.30,895.66,148679.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','164855',3259641,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164855',3259642,'2403','364',23580.76,23580.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164855',3259643,'2404','364',8984.21,10124.59,1140.38,189303.08,0.00,0.00,0.00,0.00,0.00),('1','157','839','164855',3259644,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164855',3259645,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164855',3259646,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164855',3259647,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164855',3259648,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164855',3259649,'2410','365',5354.59,5797.60,443.01,86386.95,0.00,0.00,0.00,0.00,0.00),('1','157','840','164855',3259650,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164855',3259651,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164857',3259674,'2389','364',20300.71,20300.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164857',3259675,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164857',3259676,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164857',3259677,'2392','364',15251.62,16489.36,1237.74,205464.84,0.00,0.00,0.00,0.00,0.00),('1','157','836','164857',3259678,'2393','364',28905.35,28905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164857',3259679,'2394','364',26083.09,27442.85,1359.76,225720.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','164857',3259680,'2395','364',25749.14,27117.62,1368.48,227167.68,0.00,0.00,0.00,0.00,0.00),('1','157','836','164857',3259681,'2396','364',42486.00,42486.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164857',3259682,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164857',3259683,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164857',3259684,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164857',3259685,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164857',3259686,'2401','364',40036.30,41753.88,1717.58,285118.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','164857',3259687,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164857',3259688,'2403','364',23580.76,23580.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164857',3259689,'2404','364',10124.59,11027.74,903.15,149922.90,0.00,0.00,0.00,0.00,0.00),('1','157','839','164857',3259690,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164857',3259691,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164857',3259692,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164857',3259693,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164857',3259694,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164857',3259695,'2410','365',5797.60,5943.25,145.65,28401.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','164857',3259696,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164857',3259697,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164858',3259698,'2389','364',20300.71,21351.49,1050.78,174429.48,0.00,0.00,0.00,0.00,0.00),('1','157','835','164858',3259699,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164858',3259700,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164858',3259701,'2392','364',16489.36,16489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164858',3259702,'2393','364',28905.35,28905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164858',3259703,'2394','364',27442.85,28672.39,1229.54,204103.64,0.00,0.00,0.00,0.00,0.00),('1','157','836','164858',3259704,'2395','364',27117.62,27117.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164858',3259705,'2396','364',42486.00,43903.75,1417.75,235346.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','164858',3259706,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164858',3259707,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164858',3259708,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164858',3259709,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164858',3259710,'2401','364',41753.88,43118.71,1364.83,226561.78,0.00,0.00,0.00,0.00,0.00),('1','157','838','164858',3259711,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164858',3259712,'2403','364',23580.76,24463.87,883.11,146596.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','164858',3259713,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164858',3259714,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164858',3259715,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164858',3259716,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164858',3259717,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164858',3259718,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164858',3259719,'2410','365',5943.25,6125.30,182.05,35499.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','164858',3259720,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164858',3259721,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164860',3259734,'2389','364',21351.49,22109.16,757.67,125773.22,0.00,0.00,0.00,0.00,0.00),('1','157','835','164860',3259735,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164860',3259736,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','164860',3259737,'2392','364',16489.36,16489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164860',3259738,'2393','364',28905.35,28905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164860',3259739,'2394','364',28672.39,29378.57,706.18,117225.88,0.00,0.00,0.00,0.00,0.00),('1','157','836','164860',3259740,'2395','364',27117.62,27117.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','164860',3259741,'2396','364',43903.75,45201.12,1297.37,215363.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','164860',3259742,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164860',3259743,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164860',3259744,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','164860',3259745,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164860',3259746,'2401','364',43118.71,43913.97,795.26,132013.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','164860',3259747,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','164860',3259748,'2403','364',24463.87,25933.52,1469.65,243961.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','164860',3259749,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164860',3259750,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164860',3259751,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164860',3259752,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','164860',3259753,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164860',3259754,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164860',3259755,'2410','365',6125.30,6249.38,124.08,24195.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','164860',3259756,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','164860',3259757,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165174',3265130,'2389','364',22109.16,23641.42,1532.26,254355.16,0.00,0.00,0.00,0.00,0.00),('1','157','835','165174',3265131,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165174',3265132,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165174',3265133,'2392','364',16489.36,17650.28,1160.92,192712.72,0.00,0.00,0.00,0.00,0.00),('1','157','836','165174',3265134,'2393','364',28905.35,28905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165174',3265135,'2394','364',29378.57,30622.66,1244.09,206518.94,0.00,0.00,0.00,0.00,0.00),('1','157','836','165174',3265136,'2395','364',27117.62,27117.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165174',3265137,'2396','364',45201.12,47092.37,1891.25,313947.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','165174',3265138,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165174',3265139,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165174',3265140,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165174',3265141,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165174',3265142,'2401','364',43913.97,43913.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165174',3265143,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165174',3265144,'2403','364',25933.52,26937.12,1003.60,166597.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','165174',3265145,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165174',3265146,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165174',3265147,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165174',3265148,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165174',3265149,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165174',3265150,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165174',3265151,'2410','365',6249.38,6622.21,372.83,72701.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','165174',3265152,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165174',3265153,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165235',3266433,'2389','364',23641.42,25037.87,1396.45,231810.70,0.00,0.00,0.00,0.00,0.00),('1','157','835','165235',3266434,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165235',3266435,'2391','364',18051.61,18051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165235',3266436,'2392','364',17650.28,19282.70,1632.42,270981.72,0.00,0.00,0.00,0.00,0.00),('1','157','836','165235',3266437,'2393','364',28905.35,29475.47,570.12,94639.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','165235',3266438,'2394','364',30622.66,31931.35,1308.69,217242.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','165235',3266439,'2395','364',27117.62,27739.56,621.94,103242.04,0.00,0.00,0.00,0.00,0.00),('1','157','836','165235',3266440,'2396','364',47092.37,48469.48,1377.11,228600.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','165235',3266441,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165235',3266442,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165235',3266443,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165235',3266444,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165235',3266445,'2401','364',43913.97,44080.75,166.78,27685.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','165235',3266446,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165235',3266447,'2403','364',26937.12,27201.31,264.19,43855.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','165235',3266448,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165235',3266449,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165235',3266450,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165235',3266451,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165235',3266452,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165235',3266453,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165235',3266454,'2410','365',6622.21,7007.58,385.37,75147.15,0.00,0.00,0.00,0.00,0.00),('1','157','840','165235',3266455,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165235',3266456,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165243',3266562,'2389','364',25037.87,26462.97,1425.10,236566.60,0.00,0.00,0.00,0.00,0.00),('1','157','835','165243',3266563,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165243',3266564,'2391','364',18051.61,19532.96,1481.35,245904.10,0.00,0.00,0.00,0.00,0.00),('1','157','835','165243',3266565,'2392','364',19282.70,19282.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165243',3266566,'2393','364',29475.47,29475.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165243',3266567,'2394','364',31931.35,33168.68,1237.33,205396.78,0.00,0.00,0.00,0.00,0.00),('1','157','836','165243',3266568,'2395','364',27739.56,28755.46,1015.90,168639.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','165243',3266569,'2396','364',48469.48,50482.91,2013.43,334229.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','165243',3266570,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165243',3266571,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165243',3266572,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165243',3266573,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165243',3266574,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165243',3266575,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165243',3266576,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165243',3266577,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165243',3266578,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165243',3266579,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165243',3266580,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165243',3266581,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165243',3266582,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165243',3266583,'2410','365',7007.58,7291.14,283.56,55294.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','165243',3266584,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165243',3266585,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165249',3266640,'2389','364',26462.97,27649.91,1186.94,197032.04,0.00,0.00,0.00,0.00,0.00),('1','157','835','165249',3266641,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165249',3266642,'2391','364',19532.96,20419.64,886.68,147188.88,0.00,0.00,0.00,0.00,0.00),('1','157','835','165249',3266643,'2392','364',19282.70,20013.18,730.48,121259.68,0.00,0.00,0.00,0.00,0.00),('1','157','836','165249',3266644,'2393','364',29475.47,29475.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165249',3266645,'2394','364',33168.68,34515.74,1347.06,223611.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','165249',3266646,'2395','364',28755.46,30003.91,1248.45,207242.70,0.00,0.00,0.00,0.00,0.00),('1','157','836','165249',3266647,'2396','364',50482.91,51478.52,995.61,165271.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','165249',3266648,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165249',3266649,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165249',3266650,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165249',3266651,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165249',3266652,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165249',3266653,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165249',3266654,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165249',3266655,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165249',3266656,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165249',3266657,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165249',3266658,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165249',3266659,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165249',3266660,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165249',3266661,'2410','365',7291.14,7480.83,189.69,36989.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','165249',3266662,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165249',3266663,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165254',3266746,'2389','364',27649.91,29455.12,1785.21,296344.86,0.00,0.00,20.00,0.00,0.00),('1','157','835','165254',3266747,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165254',3266748,'2391','364',20419.64,20419.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165254',3266749,'2392','364',20013.18,21194.79,1181.61,196147.26,0.00,0.00,0.00,0.00,0.00),('1','157','836','165254',3266750,'2393','364',29475.47,29475.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165254',3266751,'2394','364',34515.74,35774.67,1258.93,208982.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','165254',3266752,'2395','364',30003.91,31401.56,1397.65,232009.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','165254',3266753,'2396','364',51478.52,53563.04,2084.52,346030.32,0.00,0.00,0.00,0.00,0.00),('1','157','837','165254',3266754,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165254',3266755,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165254',3266756,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165254',3266757,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165254',3266758,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165254',3266759,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165254',3266760,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165254',3266761,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165254',3266762,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165254',3266763,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165254',3266764,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165254',3266765,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165254',3266766,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165254',3266767,'2410','365',7480.83,7676.64,195.81,38182.95,0.00,0.00,0.00,0.00,0.00),('1','157','840','165254',3266768,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165254',3266769,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165440',3269879,'2389','364',29455.12,30532.95,1077.83,178919.78,0.00,0.00,0.00,0.00,0.00),('1','157','835','165440',3269880,'2390','364',14068.60,14068.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165440',3269881,'2391','364',20419.64,20419.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165440',3269882,'2392','364',21194.79,22487.86,1293.07,214649.62,0.00,0.00,0.00,0.00,0.00),('1','157','836','165440',3269883,'2393','364',29475.47,30855.83,1380.36,229139.76,0.00,0.00,0.00,0.00,0.00),('1','157','836','165440',3269884,'2394','364',35774.67,35774.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165440',3269885,'2395','364',31401.56,32357.12,955.56,158622.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','165440',3269886,'2396','364',53563.04,55055.15,1482.11,246030.26,0.00,0.00,10.00,0.00,0.00),('1','157','837','165440',3269887,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165440',3269888,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165440',3269889,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165440',3269890,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165440',3269891,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165440',3269892,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165440',3269893,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165440',3269894,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165440',3269895,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165440',3269896,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165440',3269897,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165440',3269898,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165440',3269899,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165440',3269900,'2410','365',7676.64,8467.44,790.80,154206.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165440',3269901,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165440',3269902,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','165442',3269905,'2389','364',30532.95,31839.68,1306.73,216917.18,0.00,0.00,0.00,0.00,0.00),('1','157','835','165442',3269906,'2390','364',14068.60,15128.74,1060.14,175983.24,0.00,0.00,0.00,0.00,0.00),('1','157','835','165442',3269907,'2391','364',20419.64,21924.76,1505.12,249849.92,0.00,0.00,0.00,0.00,0.00),('1','157','835','165442',3269908,'2392','364',22487.86,22700.21,212.35,35250.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','165442',3269909,'2393','364',30855.83,32033.67,1177.84,195521.44,0.00,0.00,0.00,0.00,0.00),('1','157','836','165442',3269910,'2394','364',35774.67,35774.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165442',3269911,'2395','364',32357.12,32357.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','165442',3269912,'2396','364',55055.15,56728.39,1673.24,277757.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','165442',3269913,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165442',3269914,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165442',3269915,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','165442',3269916,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165442',3269917,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165442',3269918,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165442',3269919,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','165442',3269920,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165442',3269921,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165442',3269922,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165442',3269923,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','165442',3269924,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165442',3269925,'2409','365',2133.74,2133.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165442',3269926,'2410','365',8467.44,9349.69,882.25,172038.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','165442',3269927,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','165442',3269928,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166119',3282082,'2389','364',31839.68,33488.21,1648.53,273655.98,0.00,0.00,0.00,0.00,0.00),('1','157','835','166119',3282083,'2390','364',15128.74,16437.39,1308.65,217235.90,0.00,0.00,0.00,0.00,0.00),('1','157','835','166119',3282084,'2391','364',21924.76,24109.78,2185.02,362713.32,0.00,0.00,0.00,0.00,0.00),('1','157','835','166119',3282085,'2392','364',22700.21,22700.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166119',3282086,'2393','364',32033.67,32033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166119',3282087,'2394','364',35774.67,36435.49,660.82,109696.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','166119',3282088,'2395','364',32357.12,33086.70,729.58,121110.28,0.00,0.00,0.00,0.00,0.00),('1','157','836','166119',3282089,'2396','364',56728.39,57421.86,693.47,115116.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','166119',3282090,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166119',3282091,'2398','364',62891.66,62891.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166119',3282092,'2399','364',48330.40,48330.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166119',3282093,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166119',3282094,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166119',3282095,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166119',3282096,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166119',3282097,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166119',3282098,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166119',3282099,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166119',3282100,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166119',3282101,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166119',3282102,'2409','365',2133.74,2376.30,242.56,47299.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','166119',3282103,'2410','365',9349.69,9349.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166119',3282104,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166119',3282105,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166122',3282161,'2389','364',33488.21,35368.85,1880.64,312186.24,0.00,0.00,0.00,0.00,0.00),('1','157','835','166122',3282162,'2390','364',16437.39,18083.30,1645.91,273221.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','166122',3282163,'2391','364',24109.78,26470.18,2360.40,391826.40,0.00,0.00,0.00,0.00,0.00),('1','157','835','166122',3282164,'2392','364',22700.21,22700.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166122',3282165,'2393','364',32033.67,32033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166122',3282166,'2394','364',36435.49,36435.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166122',3282167,'2395','364',33086.70,33086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166122',3282168,'2396','364',57421.86,57421.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166122',3282169,'2397','364',48361.24,48361.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166122',3282170,'2398','364',62891.66,63458.39,566.73,94077.18,0.00,0.00,0.00,0.00,0.00),('1','157','837','166122',3282171,'2399','364',48330.40,48973.23,642.83,106709.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','166122',3282172,'2400','364',44591.63,44591.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166122',3282173,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166122',3282174,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166122',3282175,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166122',3282176,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166122',3282177,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166122',3282178,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166122',3282179,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166122',3282180,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166122',3282181,'2409','365',2376.30,2444.50,68.20,13299.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166122',3282182,'2410','365',9349.69,10899.60,1549.91,302232.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','166122',3282183,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166122',3282184,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166127',3282238,'2389','364',35368.85,35466.64,87.79,14573.14,0.00,0.00,10.00,0.00,0.00),('1','157','835','166127',3282239,'2390','364',18083.30,18093.30,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','835','166127',3282240,'2391','364',26470.18,26669.80,189.62,31476.92,0.00,0.00,10.00,0.00,0.00),('1','157','835','166127',3282241,'2392','364',22700.21,22701.58,0.00,0.00,0.00,0.00,1.37,0.00,0.00),('1','157','836','166127',3282242,'2393','364',32033.67,32033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166127',3282243,'2394','364',36435.49,36435.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166127',3282244,'2395','364',33086.70,33086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166127',3282245,'2396','364',57421.86,57421.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166127',3282246,'2397','364',48361.24,49985.52,1614.28,267970.48,0.00,0.00,10.00,0.00,0.00),('1','157','837','166127',3282247,'2398','364',63458.39,65062.36,1593.97,264599.02,0.00,0.00,10.00,0.00,0.00),('1','157','837','166127',3282248,'2399','364',48973.23,50846.60,1863.37,309319.42,0.00,0.00,10.00,0.00,0.00),('1','157','837','166127',3282249,'2400','364',44591.63,46384.31,1782.68,295924.88,0.00,0.00,10.00,0.00,0.00),('1','157','838','166127',3282250,'2401','364',44080.75,44080.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166127',3282251,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166127',3282252,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166127',3282253,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166127',3282254,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166127',3282255,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166127',3282256,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166127',3282257,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166127',3282258,'2409','365',2444.50,2444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166127',3282259,'2410','365',10899.60,12017.29,1117.69,217949.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','166127',3282260,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166127',3282261,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166129',3282287,'2389','364',35466.64,35466.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166129',3282288,'2390','364',18093.30,18093.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166129',3282289,'2391','364',26669.80,26669.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166129',3282290,'2392','364',22701.58,22701.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166129',3282291,'2393','364',32033.67,32033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166129',3282292,'2394','364',36435.49,36435.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166129',3282293,'2395','364',33086.70,33086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166129',3282294,'2396','364',57421.86,57699.46,267.60,44421.60,0.00,0.00,10.00,0.00,0.00),('1','157','837','166129',3282295,'2397','364',49985.52,51818.87,1833.35,304336.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','166129',3282296,'2398','364',65062.36,67564.13,2491.77,413633.82,0.00,0.00,10.00,0.00,0.00),('1','157','837','166129',3282297,'2399','364',50846.60,52515.90,1657.26,275105.16,0.00,0.00,12.04,0.00,0.00),('1','157','837','166129',3282298,'2400','364',46384.31,48098.59,1714.28,284570.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','166129',3282299,'2401','364',44080.75,44091.05,0.00,0.00,0.00,0.00,10.30,0.00,0.00),('1','157','838','166129',3282300,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166129',3282301,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166129',3282302,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166129',3282303,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166129',3282304,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166129',3282305,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166129',3282306,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166129',3282307,'2409','365',2444.50,2444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166129',3282308,'2410','365',12017.29,12485.76,468.47,91351.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','166129',3282309,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166129',3282310,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166132',3282329,'2389','364',35466.64,35466.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166132',3282330,'2390','364',18093.30,18093.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166132',3282331,'2391','364',26669.80,27545.41,855.61,142031.26,0.00,0.00,20.00,0.00,0.00),('1','157','835','166132',3282332,'2392','364',22701.58,22701.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166132',3282333,'2393','364',32033.67,32033.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166132',3282334,'2394','364',36435.49,37651.37,1195.88,198516.08,0.00,0.00,20.00,0.00,0.00),('1','157','836','166132',3282335,'2395','364',33086.70,33086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166132',3282336,'2396','364',57699.46,58843.67,1144.21,189938.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','166132',3282337,'2397','364',51818.87,53111.25,1292.38,214535.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','166132',3282338,'2398','364',67564.13,67564.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166132',3282339,'2399','364',52515.90,53642.89,1126.99,187080.34,0.00,0.00,0.00,0.00,0.00),('1','157','837','166132',3282340,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166132',3282341,'2401','364',44091.05,44768.16,677.11,112400.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','166132',3282342,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166132',3282343,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166132',3282344,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166132',3282345,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166132',3282346,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166132',3282347,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166132',3282348,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166132',3282349,'2409','365',2444.50,2444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166132',3282350,'2410','365',12485.76,13512.74,1026.98,200261.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','166132',3282351,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166132',3282352,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166135',3282397,'2389','364',35466.64,35466.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166135',3282398,'2390','364',18093.30,18093.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166135',3282399,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166135',3282400,'2392','364',22701.58,23564.84,841.22,139642.52,0.00,0.00,22.04,0.00,0.00),('1','157','836','166135',3282401,'2393','364',32033.67,32068.03,12.33,2046.78,0.00,0.00,22.03,0.00,0.00),('1','157','836','166135',3282402,'2394','364',37651.37,37651.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166135',3282403,'2395','364',33086.70,33086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166135',3282404,'2396','364',58843.67,60905.47,2061.80,342258.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','166135',3282405,'2397','364',53111.25,53111.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166135',3282406,'2398','364',67564.13,69200.30,1636.17,271604.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','166135',3282407,'2399','364',53642.89,53719.99,77.10,12798.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','166135',3282408,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166135',3282409,'2401','364',44768.16,46108.86,1340.70,222556.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','166135',3282410,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166135',3282411,'2403','364',27201.31,27201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166135',3282412,'2404','364',11027.74,11027.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166135',3282413,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166135',3282414,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166135',3282415,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166135',3282416,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166135',3282417,'2409','365',2444.50,2444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166135',3282418,'2410','365',13512.74,13701.20,188.46,36749.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','166135',3282419,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166135',3282420,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166137',3282422,'2389','364',35466.64,35486.64,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','157','835','166137',3282423,'2390','364',18093.30,18093.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166137',3282424,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166137',3282425,'2392','364',23564.84,23564.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166137',3282426,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166137',3282427,'2394','364',37651.37,37651.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166137',3282428,'2395','364',33086.70,34567.30,1450.60,240799.60,0.00,0.00,30.00,0.00,0.00),('1','157','836','166137',3282429,'2396','364',60905.47,62212.27,1306.80,216928.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','166137',3282430,'2397','364',53111.25,53111.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166137',3282431,'2398','364',69200.30,69200.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166137',3282432,'2399','364',53719.99,53719.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166137',3282433,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166137',3282434,'2401','364',46108.86,47133.18,1024.32,170037.12,0.00,0.00,0.00,0.00,0.00),('1','157','838','166137',3282435,'2402','364',13357.49,13357.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166137',3282436,'2403','364',27201.31,28055.61,834.28,138490.48,0.00,0.00,20.02,0.00,0.00),('1','157','838','166137',3282437,'2404','364',11027.74,11658.83,610.79,101391.14,0.00,0.00,20.30,0.00,0.00),('1','157','839','166137',3282438,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166137',3282439,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166137',3282440,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166137',3282441,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166137',3282442,'2409','365',2444.50,2444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166137',3282443,'2410','365',13701.20,13729.92,28.72,5600.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','166137',3282444,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166137',3282445,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166140',3282448,'2389','364',35486.64,35486.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166140',3282449,'2390','364',18093.30,18123.30,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','157','835','166140',3282450,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166140',3282451,'2392','364',23564.84,23564.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166140',3282452,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166140',3282453,'2394','364',37651.37,37659.20,7.83,1299.78,0.00,0.00,0.00,0.00,0.00),('1','157','836','166140',3282454,'2395','364',34567.30,36068.21,1490.91,247491.06,0.00,0.00,10.00,0.00,0.00),('1','157','836','166140',3282455,'2396','364',62212.27,64013.57,1791.30,297355.80,0.00,0.00,10.00,0.00,0.00),('1','157','837','166140',3282456,'2397','364',53111.25,53111.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166140',3282457,'2398','364',69200.30,69200.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166140',3282458,'2399','364',53719.99,53719.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166140',3282459,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166140',3282460,'2401','364',47133.18,48593.86,1450.68,240812.88,0.00,0.00,10.00,0.00,0.00),('1','157','838','166140',3282461,'2402','364',13357.49,14397.87,1010.38,167723.08,0.00,0.00,30.00,0.00,0.00),('1','157','838','166140',3282462,'2403','364',28055.61,28677.49,611.88,101572.08,0.00,0.00,10.00,0.00,0.00),('1','157','838','166140',3282463,'2404','364',11658.83,12495.37,826.54,137205.64,0.00,0.00,10.00,0.00,0.00),('1','157','839','166140',3282464,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166140',3282465,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166140',3282466,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166140',3282467,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166140',3282468,'2409','365',2444.50,2454.50,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','166140',3282469,'2410','365',13729.92,14430.35,690.43,134633.85,0.00,0.00,10.00,0.00,0.00),('1','157','840','166140',3282470,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166140',3282471,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166476',3288617,'2389','364',35486.64,35486.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166476',3288618,'2390','364',18123.30,18123.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166476',3288619,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166476',3288620,'2392','364',23564.84,23564.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166476',3288621,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166476',3288622,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166476',3288623,'2395','364',36068.21,37281.19,1212.98,201354.68,0.00,0.00,0.00,0.00,0.00),('1','157','836','166476',3288624,'2396','364',64013.57,65872.13,1858.56,308520.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','166476',3288625,'2397','364',53111.25,53111.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166476',3288626,'2398','364',69200.30,69200.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166476',3288627,'2399','364',53719.99,53719.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166476',3288628,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166476',3288629,'2401','364',48593.86,50037.37,1443.51,239622.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','166476',3288630,'2402','364',14397.87,14397.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166476',3288631,'2403','364',28677.49,29582.34,904.85,150205.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','166476',3288632,'2404','364',12495.37,14602.45,2107.08,349775.28,0.00,0.00,0.00,0.00,0.00),('1','157','839','166476',3288633,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166476',3288634,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166476',3288635,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166476',3288636,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166476',3288637,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166476',3288638,'2410','365',14430.35,14558.40,128.05,26250.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','166476',3288639,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166476',3288640,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166479',3288685,'2389','364',35486.64,35486.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166479',3288686,'2390','364',18123.30,18123.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166479',3288687,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166479',3288688,'2392','364',23564.84,23564.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166479',3288689,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166479',3288690,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166479',3288691,'2395','364',37281.19,38756.82,1475.63,244954.58,0.00,0.00,0.00,0.00,0.00),('1','157','836','166479',3288692,'2396','364',65872.13,67015.84,1143.71,189855.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','166479',3288693,'2397','364',53111.25,53111.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166479',3288694,'2398','364',69200.30,69200.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166479',3288695,'2399','364',53719.99,53719.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166479',3288696,'2400','364',48098.59,48098.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166479',3288697,'2401','364',50037.37,51299.93,1262.56,209584.96,0.00,0.00,0.00,0.00,0.00),('1','157','838','166479',3288698,'2402','364',14397.87,15763.86,1365.99,226754.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','166479',3288699,'2403','364',29582.34,30615.67,1033.33,171532.78,0.00,0.00,0.00,0.00,0.00),('1','157','838','166479',3288700,'2404','364',14602.45,15789.07,1186.62,196978.92,0.00,0.00,0.00,0.00,0.00),('1','157','839','166479',3288701,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166479',3288702,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166479',3288703,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166479',3288704,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166479',3288705,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166479',3288706,'2410','365',14558.40,14919.75,361.35,74076.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','166479',3288707,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166479',3288708,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166482',3288763,'2389','364',35486.64,35486.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166482',3288764,'2390','364',18123.30,18123.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166482',3288765,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166482',3288766,'2392','364',23564.84,23564.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166482',3288767,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166482',3288768,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166482',3288769,'2395','364',38756.82,40473.33,1716.51,284940.66,0.00,0.00,0.00,0.00,0.00),('1','157','836','166482',3288770,'2396','364',67015.84,68739.47,1723.63,286122.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','166482',3288771,'2397','364',53111.25,53559.14,447.89,74349.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','166482',3288772,'2398','364',69200.30,69583.61,383.31,63629.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','166482',3288773,'2399','364',53719.99,53719.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166482',3288774,'2400','364',48098.59,48638.24,539.65,89581.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','166482',3288775,'2401','364',51299.93,51945.31,645.38,107133.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','166482',3288776,'2402','364',15763.86,16291.67,527.81,87616.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','166482',3288777,'2403','364',30615.67,31634.58,1018.91,169139.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','166482',3288778,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166482',3288779,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166482',3288780,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166482',3288781,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166482',3288782,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166482',3288783,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166482',3288784,'2410','365',14919.75,15112.69,192.94,39552.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','166482',3288785,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166482',3288786,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166485',3288821,'2389','364',35486.64,35486.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166485',3288822,'2390','364',18123.30,19399.87,1276.57,211910.62,0.00,0.00,0.00,0.00,0.00),('1','157','835','166485',3288823,'2391','364',27545.41,27545.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166485',3288824,'2392','364',23564.84,24935.94,1371.10,227602.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','166485',3288825,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166485',3288826,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166485',3288827,'2395','364',40473.33,40473.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166485',3288828,'2396','364',68739.47,68739.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166485',3288829,'2397','364',53559.14,54856.11,1296.97,215297.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','166485',3288830,'2398','364',69583.61,71102.29,1518.68,252100.88,0.00,0.00,0.00,0.00,0.00),('1','157','837','166485',3288831,'2399','364',53719.99,54407.71,687.72,114161.52,0.00,0.00,0.00,0.00,0.00),('1','157','837','166485',3288832,'2400','364',48638.24,49775.86,1137.62,188844.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','166485',3288833,'2401','364',51945.31,51945.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166485',3288834,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166485',3288835,'2403','364',31634.58,31634.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166485',3288836,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166485',3288837,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166485',3288838,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166485',3288839,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166485',3288840,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166485',3288841,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166485',3288842,'2410','365',15112.69,15362.70,250.01,51252.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','166485',3288843,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166485',3288844,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','166491',3288882,'2389','364',35486.64,36690.38,1193.74,198160.84,0.00,0.00,10.00,0.00,0.00),('1','157','835','166491',3288883,'2390','364',19399.87,19409.87,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','835','166491',3288884,'2391','364',27545.41,27555.41,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','835','166491',3288885,'2392','364',24935.94,26335.08,1389.14,230597.24,0.00,0.00,10.00,0.00,0.00),('1','157','836','166491',3288886,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166491',3288887,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166491',3288888,'2395','364',40473.33,40473.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','166491',3288889,'2396','364',68739.47,68739.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166491',3288890,'2397','364',54856.11,55825.97,959.86,159336.76,0.00,0.00,10.00,0.00,0.00),('1','157','837','166491',3288891,'2398','364',71102.29,73313.65,2201.36,365425.76,0.00,0.00,10.00,0.00,0.00),('1','157','837','166491',3288892,'2399','364',54407.71,54407.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','166491',3288893,'2400','364',49775.86,51373.26,1587.40,263508.40,0.00,0.00,10.00,0.00,0.00),('1','157','838','166491',3288894,'2401','364',51945.31,51945.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166491',3288895,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166491',3288896,'2403','364',31634.58,31634.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','166491',3288897,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166491',3288898,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166491',3288899,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166491',3288900,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','166491',3288901,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166491',3288902,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166491',3288903,'2410','365',15362.70,15593.48,220.78,45259.90,0.00,0.00,10.00,0.00,0.00),('1','157','840','166491',3288904,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','166491',3288905,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167012',3297879,'2389','364',36690.38,37966.33,1275.95,211807.70,0.00,0.00,0.00,0.00,0.00),('1','157','835','167012',3297880,'2390','364',19409.87,19469.32,0.00,0.00,0.00,0.00,59.45,0.00,0.00),('1','157','835','167012',3297881,'2391','364',27555.41,27615.12,0.01,1.66,0.00,0.00,59.70,0.00,0.00),('1','157','835','167012',3297882,'2392','364',26335.08,27202.52,867.44,143995.04,0.00,0.00,0.00,0.00,0.00),('1','157','836','167012',3297883,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167012',3297884,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167012',3297885,'2395','364',40473.33,40473.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167012',3297886,'2396','364',68739.47,68739.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167012',3297887,'2397','364',55825.97,57150.90,1324.93,219938.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','167012',3297888,'2398','364',73313.65,74784.78,1471.13,244207.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','167012',3297889,'2399','364',54407.71,55607.14,1199.43,199105.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','167012',3297890,'2400','364',51373.26,52505.96,1122.70,186368.20,0.00,0.00,10.00,0.00,0.00),('1','157','838','167012',3297891,'2401','364',51945.31,51945.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167012',3297892,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167012',3297893,'2403','364',31634.58,31634.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167012',3297894,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167012',3297895,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167012',3297896,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167012',3297897,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167012',3297898,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167012',3297899,'2409','365',2454.50,2454.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167012',3297900,'2410','365',15593.48,15852.01,258.53,52998.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','167012',3297901,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167012',3297902,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167018',3297981,'2389','364',37966.33,39018.04,1051.71,174583.86,0.00,0.00,0.00,0.00,0.00),('1','157','835','167018',3297982,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167018',3297983,'2391','364',27615.12,28530.21,915.09,151904.94,0.00,0.00,0.00,0.00,0.00),('1','157','835','167018',3297984,'2392','364',27202.52,28709.82,1507.30,250211.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','167018',3297985,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167018',3297986,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167018',3297987,'2395','364',40473.33,40473.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167018',3297988,'2396','364',68739.47,68739.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167018',3297989,'2397','364',57150.90,57150.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167018',3297990,'2398','364',74784.78,76668.94,1864.16,309450.56,0.00,0.00,20.00,0.00,0.00),('1','157','837','167018',3297991,'2399','364',55607.14,57291.03,1683.89,279525.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','167018',3297992,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167018',3297993,'2401','364',51945.31,51945.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167018',3297994,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167018',3297995,'2403','364',31634.58,31634.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167018',3297996,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167018',3297997,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167018',3297998,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167018',3297999,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167018',3298000,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167018',3298001,'2409','365',2454.50,3377.25,902.75,185063.75,0.00,0.00,20.00,0.00,0.00),('1','157','840','167018',3298002,'2410','365',15852.01,15852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167018',3298003,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167018',3298004,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167021',3298040,'2389','364',39018.04,39889.11,871.07,144597.62,0.00,0.00,0.00,0.00,0.00),('1','157','835','167021',3298041,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167021',3298042,'2391','364',28530.21,28530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167021',3298043,'2392','364',28709.82,29972.91,1263.09,209672.94,0.00,0.00,0.00,0.00,0.00),('1','157','836','167021',3298044,'2393','364',32068.03,32068.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167021',3298045,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167021',3298046,'2395','364',40473.33,41354.53,881.20,146279.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','167021',3298047,'2396','364',68739.47,70235.66,1496.19,248367.54,0.00,0.00,0.00,0.00,0.00),('1','157','837','167021',3298048,'2397','364',57150.90,57779.99,629.09,104428.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','167021',3298049,'2398','364',76668.94,76668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167021',3298050,'2399','364',57291.03,57291.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167021',3298051,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167021',3298052,'2401','364',51945.31,52756.51,811.20,134659.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','167021',3298053,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167021',3298054,'2403','364',31634.58,32842.15,1207.57,200456.62,0.00,0.00,0.00,0.00,0.00),('1','157','838','167021',3298055,'2404','364',15789.07,15789.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167021',3298056,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167021',3298057,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167021',3298058,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167021',3298059,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167021',3298060,'2409','365',3377.25,3658.23,280.98,57600.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','167021',3298061,'2410','365',15852.01,15852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167021',3298062,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167021',3298063,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167023',3298065,'2389','364',39889.11,41329.02,1439.91,239025.06,0.00,0.00,0.00,0.00,0.00),('1','157','835','167023',3298066,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167023',3298067,'2391','364',28530.21,28530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167023',3298068,'2392','364',29972.91,31325.60,1352.69,224546.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','167023',3298069,'2393','364',32068.03,32071.13,0.00,0.00,0.00,0.00,3.10,0.00,0.00),('1','157','836','167023',3298070,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167023',3298071,'2395','364',41354.53,41354.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167023',3298072,'2396','364',70235.66,72798.75,2563.09,425472.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','167023',3298073,'2397','364',57779.99,57779.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167023',3298074,'2398','364',76668.94,76668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167023',3298075,'2399','364',57291.03,57291.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167023',3298076,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167023',3298077,'2401','364',52756.51,54049.28,1292.77,214599.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','167023',3298078,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167023',3298079,'2403','364',32842.15,32842.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167023',3298080,'2404','364',15789.07,16914.20,1125.13,186771.58,0.00,0.00,0.00,0.00,0.00),('1','157','839','167023',3298081,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167023',3298082,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167023',3298083,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167023',3298084,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167023',3298085,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167023',3298086,'2410','365',15852.01,16500.79,648.78,132999.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','167023',3298087,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167023',3298088,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167025',3298090,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167025',3298091,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167025',3298092,'2391','364',28530.21,28530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167025',3298093,'2392','364',31325.60,32452.36,1126.76,187042.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','167025',3298094,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167025',3298095,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167025',3298096,'2395','364',41354.53,41354.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167025',3298097,'2396','364',72798.75,74503.52,1704.77,282991.82,0.00,0.00,0.00,0.00,0.00),('1','157','837','167025',3298098,'2397','364',57779.99,59490.08,1710.09,283874.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','167025',3298099,'2398','364',76668.94,76668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167025',3298100,'2399','364',57291.03,58378.03,1087.00,180442.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167025',3298101,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167025',3298102,'2401','364',54049.28,55208.63,1159.35,192452.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','167025',3298103,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167025',3298104,'2403','364',32842.15,32842.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167025',3298105,'2404','364',16914.20,17737.82,823.62,136720.92,0.00,0.00,0.00,0.00,0.00),('1','157','839','167025',3298106,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167025',3298107,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167025',3298108,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167025',3298109,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167025',3298110,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167025',3298111,'2410','365',16500.79,16980.88,480.09,98418.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','167025',3298112,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167025',3298113,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167026',3298114,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167026',3298115,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167026',3298116,'2391','364',28530.21,28530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167026',3298117,'2392','364',32452.36,34174.77,1722.41,285920.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','167026',3298118,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167026',3298119,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167026',3298120,'2395','364',41354.53,43364.78,2010.25,333701.50,0.00,0.00,0.00,0.00,0.00),('1','157','836','167026',3298121,'2396','364',74503.52,74519.78,16.26,2699.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','167026',3298122,'2397','364',59490.08,61229.53,1739.45,288748.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','167026',3298123,'2398','364',76668.94,76668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167026',3298124,'2399','364',58378.03,58378.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167026',3298125,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167026',3298126,'2401','364',55208.63,55208.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167026',3298127,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167026',3298128,'2403','364',32842.15,32842.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167026',3298129,'2404','364',17737.82,19891.18,2153.36,357457.76,0.00,0.00,0.00,0.00,0.00),('1','157','839','167026',3298130,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167026',3298131,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167026',3298132,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167026',3298133,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167026',3298134,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167026',3298135,'2410','365',16980.88,17382.68,401.80,82369.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167026',3298136,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167026',3298137,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167620',3308699,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167620',3308700,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167620',3308701,'2391','364',28530.21,29387.76,857.55,142353.30,0.00,0.00,0.00,0.00,0.00),('1','157','835','167620',3308702,'2392','364',34174.77,34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167620',3308703,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167620',3308704,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167620',3308705,'2395','364',43364.78,43364.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167620',3308706,'2396','364',74519.78,76010.56,1490.78,247469.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','167620',3308707,'2397','364',61229.53,61284.35,54.82,9100.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','167620',3308708,'2398','364',76668.94,78138.32,1469.38,243917.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','167620',3308709,'2399','364',58378.03,59543.35,1165.32,193443.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','167620',3308710,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167620',3308711,'2401','364',55208.63,56214.48,1005.85,166971.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','167620',3308712,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167620',3308713,'2403','364',32842.15,33837.23,995.08,165183.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','167620',3308714,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167620',3308715,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167620',3308716,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167620',3308717,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167620',3308718,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167620',3308719,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167620',3308720,'2410','365',17382.68,17550.45,167.77,34392.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','167620',3308721,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167620',3308722,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167624',3308788,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167624',3308789,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167624',3308790,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167624',3308791,'2392','364',34174.77,34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167624',3308792,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167624',3308793,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167624',3308794,'2395','364',43364.78,43364.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167624',3308795,'2396','364',76010.56,77377.71,1367.15,226946.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','167624',3308796,'2397','364',61284.35,61284.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167624',3308797,'2398','364',78138.32,80121.42,1983.10,329194.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','167624',3308798,'2399','364',59543.35,60521.95,978.60,162447.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','167624',3308799,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167624',3308800,'2401','364',56214.48,57016.14,801.66,133075.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','167624',3308801,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167624',3308802,'2403','364',33837.23,34490.51,653.28,108444.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','167624',3308803,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167624',3308804,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167624',3308805,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167624',3308806,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167624',3308807,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167624',3308808,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167624',3308809,'2410','365',17550.45,17550.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167624',3308810,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167624',3308811,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167627',3308876,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167627',3308877,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167627',3308878,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167627',3308879,'2392','364',34174.77,34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167627',3308880,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167627',3308881,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167627',3308882,'2395','364',43364.78,43465.87,101.09,16780.94,0.00,0.00,0.00,0.00,0.00),('1','157','836','167627',3308883,'2396','364',77377.71,79462.35,2084.64,346050.24,0.00,0.00,0.00,0.00,0.00),('1','157','837','167627',3308884,'2397','364',61284.35,62574.11,1289.76,214100.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','167627',3308885,'2398','364',80121.42,82292.30,2170.88,360366.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','167627',3308886,'2399','364',60521.95,61942.83,1420.88,235866.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','167627',3308887,'2400','364',52505.96,52505.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167627',3308888,'2401','364',57016.14,58184.53,1168.39,193952.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','167627',3308889,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167627',3308890,'2403','364',34490.51,34490.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167627',3308891,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167627',3308892,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167627',3308893,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167627',3308894,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167627',3308895,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167627',3308896,'2409','365',3658.23,3658.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167627',3308897,'2410','365',17550.45,17550.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167627',3308898,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167627',3308899,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167630',3308924,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167630',3308925,'2390','364',19469.32,19469.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167630',3308926,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167630',3308927,'2392','364',34174.77,34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167630',3308928,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167630',3308929,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167630',3308930,'2395','364',43465.87,44786.50,1310.63,217564.58,0.00,0.00,10.00,0.00,0.00),('1','157','836','167630',3308931,'2396','364',79462.35,80602.63,1130.28,187626.48,0.00,0.00,10.00,0.00,0.00),('1','157','837','167630',3308932,'2397','364',62574.11,63959.37,1335.26,221653.16,0.00,0.00,50.00,0.00,0.00),('1','157','837','167630',3308933,'2398','364',82292.30,83694.56,1392.26,231115.16,0.00,0.00,10.00,0.00,0.00),('1','157','837','167630',3308934,'2399','364',61942.83,63369.18,1416.35,235114.10,0.00,0.00,10.00,0.00,0.00),('1','157','837','167630',3308935,'2400','364',52505.96,54088.12,1562.16,259318.56,0.00,0.00,20.00,0.00,0.00),('1','157','838','167630',3308936,'2401','364',58184.53,58184.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167630',3308937,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167630',3308938,'2403','364',34490.51,34490.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167630',3308939,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167630',3308940,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167630',3308941,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167630',3308942,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167630',3308943,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167630',3308944,'2409','365',3658.23,3673.23,0.00,0.00,0.00,0.00,15.00,0.00,0.00),('1','157','840','167630',3308945,'2410','365',17550.45,18238.78,668.33,140349.30,0.00,0.00,20.00,0.00,0.00),('1','157','840','167630',3308946,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167630',3308947,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167640',3309060,'2389','364',41329.02,41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167640',3309061,'2390','364',19469.32,20909.68,1440.36,239099.76,0.00,0.00,0.00,0.00,0.00),('1','157','835','167640',3309062,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167640',3309063,'2392','364',34174.77,34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167640',3309064,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167640',3309065,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167640',3309066,'2395','364',44786.50,46440.55,1654.05,274572.30,0.00,0.00,0.00,0.00,0.00),('1','157','836','167640',3309067,'2396','364',80602.63,80602.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167640',3309068,'2397','364',63959.37,63959.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167640',3309069,'2398','364',83694.56,85520.27,1825.71,303067.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','167640',3309070,'2399','364',63369.18,63369.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167640',3309071,'2400','364',54088.12,56222.27,2134.15,354268.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','167640',3309072,'2401','364',58184.53,58184.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167640',3309073,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167640',3309074,'2403','364',34490.51,35506.63,1016.12,168675.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','167640',3309075,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167640',3309076,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167640',3309077,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167640',3309078,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167640',3309079,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167640',3309080,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167640',3309081,'2410','365',18238.78,18514.49,275.71,57899.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','167640',3309082,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167640',3309083,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167644',3309143,'2389','364',41329.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167644',3309144,'2390','364',20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167644',3309145,'2391','364',29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167644',3309146,'2392','364',34174.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167644',3309147,'2393','364',32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167644',3309148,'2394','364',37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167644',3309149,'2395','364',46440.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167644',3309150,'2396','364',80602.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167644',3309151,'2397','364',63959.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167644',3309152,'2398','364',85520.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167644',3309153,'2399','364',63369.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167644',3309154,'2400','364',56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167644',3309155,'2401','364',58184.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167644',3309156,'2402','364',16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167644',3309157,'2403','364',35506.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167644',3309158,'2404','364',19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167644',3309159,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167644',3309160,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167644',3309161,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167644',3309162,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167644',3309163,'2409','365',3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167644',3309164,'2410','365',18514.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167644',3309165,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167644',3309166,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167646',3309192,'2389','364',41329.02,42626.01,1296.99,215300.34,0.00,0.00,0.00,0.00,0.00),('1','157','835','167646',3309193,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167646',3309194,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167646',3309195,'2392','364',34174.77,34971.00,786.23,130514.18,0.00,0.00,10.00,0.00,0.00),('1','157','836','167646',3309196,'2393','364',32071.13,32071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167646',3309197,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167646',3309198,'2395','364',46440.55,46440.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167646',3309199,'2396','364',80602.63,82077.92,1475.29,244898.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','167646',3309200,'2397','364',63959.37,65946.94,1987.57,329936.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','167646',3309201,'2398','364',85520.27,85520.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167646',3309202,'2399','364',63369.18,64821.92,1452.74,241154.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','167646',3309203,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167646',3309204,'2401','364',58184.53,58184.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167646',3309205,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167646',3309206,'2403','364',35506.63,36723.15,1216.52,201942.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','167646',3309207,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167646',3309208,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167646',3309209,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167646',3309210,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167646',3309211,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167646',3309212,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167646',3309213,'2410','365',18514.49,18571.14,56.65,11896.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','167646',3309214,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167646',3309215,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167715',3310471,'2389','364',42626.01,43642.84,1016.83,168793.78,0.00,0.00,0.00,0.00,0.00),('1','157','835','167715',3310472,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167715',3310473,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167715',3310474,'2392','364',34971.00,36036.32,1065.32,176843.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','167715',3310475,'2393','364',32071.13,32074.71,0.00,0.00,0.00,0.00,3.58,0.00,0.00),('1','157','836','167715',3310476,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167715',3310477,'2395','364',46440.55,46464.65,24.10,4000.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','167715',3310478,'2396','364',82077.92,84628.92,2551.00,423466.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167715',3310479,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167715',3310480,'2398','364',85520.27,87018.52,1498.25,248709.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','167715',3310481,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167715',3310482,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167715',3310483,'2401','364',58184.53,59607.76,1423.23,236256.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','167715',3310484,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167715',3310485,'2403','364',36723.15,37056.84,333.69,55392.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','167715',3310486,'2404','364',19891.18,19891.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167715',3310487,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167715',3310488,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167715',3310489,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167715',3310490,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167715',3310491,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167715',3310492,'2410','365',18571.14,19056.86,485.72,102001.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','167715',3310493,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167715',3310494,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167896',3313579,'2389','364',43642.84,44415.31,772.47,125912.61,0.00,0.00,0.00,0.00,0.00),('1','157','835','167896',3313580,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167896',3313581,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167896',3313582,'2392','364',36036.32,37332.00,1295.68,211195.84,0.00,0.00,0.00,0.00,0.00),('1','157','836','167896',3313583,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167896',3313584,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167896',3313585,'2395','364',46464.65,47578.53,1113.88,181562.44,0.00,0.00,0.00,0.00,0.00),('1','157','836','167896',3313586,'2396','364',84628.92,85989.07,1360.15,221704.45,0.00,0.00,0.00,0.00,0.00),('1','157','837','167896',3313587,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167896',3313588,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167896',3313589,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167896',3313590,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167896',3313591,'2401','364',59607.76,61186.83,1579.07,257388.41,0.00,0.00,0.00,0.00,0.00),('1','157','838','167896',3313592,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167896',3313593,'2403','364',37056.84,37435.52,378.68,61724.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','167896',3313594,'2404','364',19891.18,20717.44,826.26,134680.38,0.00,0.00,0.00,0.00,0.00),('1','157','839','167896',3313595,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167896',3313596,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167896',3313597,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167896',3313598,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167896',3313599,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167896',3313600,'2410','365',19056.86,19139.77,82.91,17411.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','167896',3313601,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167896',3313602,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167899',3313635,'2389','364',44415.31,45595.71,1180.40,192405.20,0.00,0.00,0.00,0.00,0.00),('1','157','835','167899',3313636,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167899',3313637,'2391','364',29387.76,29387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167899',3313638,'2392','364',37332.00,39061.82,1729.82,281960.66,0.00,0.00,0.00,0.00,0.00),('1','157','836','167899',3313639,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167899',3313640,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167899',3313641,'2395','364',47578.53,49549.08,1970.55,321199.65,0.00,0.00,0.00,0.00,0.00),('1','157','836','167899',3313642,'2396','364',85989.07,85989.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167899',3313643,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167899',3313644,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167899',3313645,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167899',3313646,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167899',3313647,'2401','364',61186.83,62562.88,1376.05,224296.15,0.00,0.00,0.00,0.00,0.00),('1','157','838','167899',3313648,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167899',3313649,'2403','364',37435.52,37435.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167899',3313650,'2404','364',20717.44,21992.80,1275.36,207883.68,0.00,0.00,0.00,0.00,0.00),('1','157','839','167899',3313651,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167899',3313652,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167899',3313653,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167899',3313654,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167899',3313655,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167899',3313656,'2410','365',19139.77,19497.93,358.16,75213.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','167899',3313657,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167899',3313658,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167901',3313675,'2389','364',45595.71,46341.63,745.92,121584.96,0.00,0.00,0.00,0.00,0.00),('1','157','835','167901',3313676,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','167901',3313677,'2391','364',29387.76,30970.22,1582.46,257940.98,0.00,0.00,0.00,0.00,0.00),('1','157','835','167901',3313678,'2392','364',39061.82,40377.01,1315.19,214375.97,0.00,0.00,0.00,0.00,0.00),('1','157','836','167901',3313679,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167901',3313680,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','167901',3313681,'2395','364',49549.08,49558.92,9.84,1603.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','167901',3313682,'2396','364',85989.07,86016.44,27.37,4461.31,0.00,0.00,0.00,0.00,0.00),('1','157','837','167901',3313683,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167901',3313684,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167901',3313685,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','167901',3313686,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167901',3313687,'2401','364',62562.88,63675.70,1112.82,181389.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','167901',3313688,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','167901',3313689,'2403','364',37435.52,38378.06,942.54,153634.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','167901',3313690,'2404','364',21992.80,23301.74,1308.94,213357.22,0.00,0.00,0.00,0.00,0.00),('1','157','839','167901',3313691,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167901',3313692,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167901',3313693,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','167901',3313694,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167901',3313695,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167901',3313696,'2410','365',19497.93,20546.62,1048.69,220224.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','167901',3313697,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','167901',3313698,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168112',3317683,'2389','364',46341.63,47784.47,1442.84,235182.92,0.00,0.00,0.00,0.00,0.00),('1','157','835','168112',3317684,'2390','364',20909.68,20909.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168112',3317685,'2391','364',30970.22,30970.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168112',3317686,'2392','364',40377.01,41716.33,1339.32,218309.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','168112',3317687,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168112',3317688,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168112',3317689,'2395','364',49558.92,50640.72,1081.80,176333.40,0.00,0.00,0.00,0.00,0.00),('1','157','836','168112',3317690,'2396','364',86016.44,88014.34,1997.90,325657.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','168112',3317691,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168112',3317692,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168112',3317693,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168112',3317694,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168112',3317695,'2401','364',63675.70,65076.66,1400.96,228356.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','168112',3317696,'2402','364',16291.67,16291.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168112',3317697,'2403','364',38378.06,38378.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168112',3317698,'2404','364',23301.74,23987.47,685.73,111773.99,0.00,0.00,0.00,0.00,0.00),('1','157','839','168112',3317699,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168112',3317700,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168112',3317701,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168112',3317702,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168112',3317703,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168112',3317704,'2410','365',20546.62,20837.84,291.22,61156.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','168112',3317705,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168112',3317706,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168115',3317728,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168115',3317729,'2390','364',20909.68,22034.01,1124.33,183265.79,0.00,0.00,0.00,0.00,0.00),('1','157','835','168115',3317730,'2391','364',30970.22,31953.59,983.37,160289.31,0.00,0.00,0.00,0.00,0.00),('1','157','835','168115',3317731,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168115',3317732,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168115',3317733,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168115',3317734,'2395','364',50640.72,51894.03,1253.31,204289.53,0.00,0.00,0.00,0.00,0.00),('1','157','836','168115',3317735,'2396','364',88014.34,89478.79,1464.45,238705.35,0.00,0.00,0.00,0.00,0.00),('1','157','837','168115',3317736,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168115',3317737,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168115',3317738,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168115',3317739,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168115',3317740,'2401','364',65076.66,66692.31,1609.51,262350.13,0.00,0.00,6.14,0.00,0.00),('1','157','838','168115',3317741,'2402','364',16291.67,16414.96,123.29,20096.27,0.00,0.00,0.00,0.00,0.00),('1','157','838','168115',3317742,'2403','364',38378.06,39235.53,857.47,139767.61,0.00,0.00,0.00,0.00,0.00),('1','157','838','168115',3317743,'2404','364',23987.47,24107.09,119.62,19498.06,0.00,0.00,0.00,0.00,0.00),('1','157','839','168115',3317744,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168115',3317745,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168115',3317746,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168115',3317747,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168115',3317748,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168115',3317749,'2410','365',20837.84,20963.14,125.30,26313.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168115',3317750,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168115',3317751,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168562',3325664,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168562',3325665,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168562',3325666,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168562',3325667,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168562',3325668,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168562',3325669,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168562',3325670,'2395','364',51894.03,54955.99,3061.96,489913.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','168562',3325671,'2396','364',89478.79,92222.18,2743.39,438942.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','168562',3325672,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168562',3325673,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168562',3325674,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168562',3325675,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168562',3325676,'2401','364',66692.31,67340.34,648.03,103684.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','168562',3325677,'2402','364',16414.96,17073.62,658.66,105385.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','168562',3325678,'2403','364',39235.53,39821.05,585.52,93683.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','168562',3325679,'2404','364',24107.09,24539.59,432.50,69200.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168562',3325680,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168562',3325681,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168562',3325682,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168562',3325683,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168562',3325684,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168562',3325685,'2410','365',20963.14,21228.52,265.38,55729.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','168562',3325686,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168562',3325687,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168564',3325718,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168564',3325719,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168564',3325720,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','168564',3325721,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168564',3325722,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168564',3325723,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','168564',3325724,'2395','364',54955.99,58897.52,3939.53,630324.80,0.00,0.00,2.00,0.00,0.00),('1','157','836','168564',3325725,'2396','364',92222.18,96004.88,3782.70,605232.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168564',3325726,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168564',3325727,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168564',3325728,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','168564',3325729,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168564',3325730,'2401','364',67340.34,67340.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168564',3325731,'2402','364',17073.62,17073.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168564',3325732,'2403','364',39821.05,39821.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','168564',3325733,'2404','364',24539.59,24539.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168564',3325734,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168564',3325735,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168564',3325736,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','168564',3325737,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168564',3325738,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168564',3325739,'2410','365',21228.52,21900.42,671.90,141099.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168564',3325740,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','168564',3325741,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169325',3339533,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169325',3339534,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169325',3339535,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169325',3339536,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169325',3339537,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169325',3339538,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169325',3339539,'2395','364',58897.52,60280.17,1372.65,219624.00,0.00,0.00,10.00,0.00,0.00),('1','157','836','169325',3339540,'2396','364',96004.88,97913.41,1898.53,303764.80,0.00,0.00,10.00,0.00,0.00),('1','157','837','169325',3339541,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169325',3339542,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169325',3339543,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169325',3339544,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169325',3339545,'2401','364',67340.34,68837.59,1487.25,237960.00,0.00,0.00,10.00,0.00,0.00),('1','157','838','169325',3339546,'2402','364',17073.62,18055.08,971.46,155433.60,0.00,0.00,10.00,0.00,0.00),('1','157','838','169325',3339547,'2403','364',39821.05,40876.38,1045.33,167252.80,0.00,0.00,10.00,0.00,0.00),('1','157','838','169325',3339548,'2404','364',24539.59,25797.56,1247.97,199675.20,0.00,0.00,10.00,0.00,0.00),('1','157','839','169325',3339549,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169325',3339550,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169325',3339551,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169325',3339552,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169325',3339553,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169325',3339554,'2410','365',21900.42,22677.56,777.14,163199.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','169325',3339555,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169325',3339556,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169327',3339574,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169327',3339575,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169327',3339576,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169327',3339577,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169327',3339578,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169327',3339579,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169327',3339580,'2395','364',60280.17,61439.00,1158.83,185412.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','169327',3339581,'2396','364',97913.41,99283.80,1370.39,219262.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','169327',3339582,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169327',3339583,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169327',3339584,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169327',3339585,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169327',3339586,'2401','364',68837.59,69963.60,1126.01,180161.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','169327',3339587,'2402','364',18055.08,19722.80,1667.72,266835.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','169327',3339588,'2403','364',40876.38,41637.20,760.82,121731.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','169327',3339589,'2404','364',25797.56,26405.66,608.10,97296.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169327',3339590,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169327',3339591,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169327',3339592,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169327',3339593,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169327',3339594,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169327',3339595,'2410','365',22677.56,22774.23,96.67,20300.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','169327',3339596,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169327',3339597,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169331',3339644,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169331',3339645,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169331',3339646,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169331',3339647,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169331',3339648,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169331',3339649,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169331',3339650,'2395','364',61439.00,62991.92,1552.92,248467.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','169331',3339651,'2396','364',99283.80,101054.60,1770.80,283328.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169331',3339652,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169331',3339653,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169331',3339654,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169331',3339655,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169331',3339656,'2401','364',69963.60,71591.51,1627.91,260465.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','169331',3339657,'2402','364',19722.80,20874.66,1151.86,184297.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','169331',3339658,'2403','364',41637.20,42897.56,1260.36,201657.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','169331',3339659,'2404','364',26405.66,27462.16,1056.50,169040.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169331',3339660,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169331',3339661,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169331',3339662,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169331',3339663,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169331',3339664,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169331',3339665,'2410','365',22774.23,23065.57,291.34,61181.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','169331',3339666,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169331',3339667,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169333',3339682,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169333',3339683,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169333',3339684,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169333',3339685,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169333',3339686,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169333',3339687,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169333',3339688,'2395','364',62991.92,63434.33,442.41,70785.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','169333',3339689,'2396','364',101054.60,101888.44,833.84,133414.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','169333',3339690,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169333',3339691,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169333',3339692,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169333',3339693,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169333',3339694,'2401','364',71591.51,73964.58,2373.07,379691.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','169333',3339695,'2402','364',20874.66,22768.84,1894.18,303068.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','169333',3339696,'2403','364',42897.56,44221.27,1323.71,211793.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','169333',3339697,'2404','364',27462.16,29207.46,1745.30,279248.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169333',3339698,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169333',3339699,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169333',3339700,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169333',3339701,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169333',3339702,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169333',3339703,'2410','365',23065.57,23207.46,141.89,29796.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','169333',3339704,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169333',3339705,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169334',3339706,'2389','364',47784.47,47784.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169334',3339707,'2390','364',22034.01,22034.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169334',3339708,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169334',3339709,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169334',3339710,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169334',3339711,'2394','364',37659.20,37659.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169334',3339712,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169334',3339713,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169334',3339714,'2397','364',65946.94,65946.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169334',3339715,'2398','364',87018.52,87018.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169334',3339716,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169334',3339717,'2400','364',56222.27,56222.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169334',3339718,'2401','364',73964.58,76795.52,2830.94,452950.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','169334',3339719,'2402','364',22768.84,24832.47,2063.63,330180.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','169334',3339720,'2403','364',44221.27,46188.55,1967.28,314764.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','169334',3339721,'2404','364',29207.46,31055.32,1847.86,295657.60,0.00,0.00,0.00,0.00,0.00),('1','157','839','169334',3339722,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169334',3339723,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169334',3339724,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169334',3339725,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169334',3339726,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169334',3339727,'2410','365',23207.46,23562.42,354.96,74541.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','169334',3339728,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169334',3339729,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169339',3339794,'2389','364',47784.47,47784.74,0.00,0.00,0.00,0.00,0.27,0.00,0.00),('1','157','835','169339',3339795,'2390','364',22034.01,22034.29,0.00,0.00,0.00,0.00,0.28,0.00,0.00),('1','157','835','169339',3339796,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169339',3339797,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169339',3339798,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169339',3339799,'2394','364',37659.20,37659.81,0.00,0.00,0.00,0.00,0.61,0.00,0.00),('1','157','836','169339',3339800,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169339',3339801,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169339',3339802,'2397','364',65946.94,65947.29,0.00,0.00,0.00,0.00,0.35,0.00,0.00),('1','157','837','169339',3339803,'2398','364',87018.52,87019.04,0.00,0.00,0.00,0.00,0.52,0.00,0.00),('1','157','837','169339',3339804,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169339',3339805,'2400','364',56222.27,56222.96,0.00,0.00,0.00,0.00,0.69,0.00,0.00),('1','157','838','169339',3339806,'2401','364',76795.52,77418.60,623.08,101562.04,0.00,0.00,0.00,0.00,0.00),('1','157','838','169339',3339807,'2402','364',24832.47,25366.41,533.94,87032.22,0.00,0.00,0.00,0.00,0.00),('1','157','838','169339',3339808,'2403','364',46188.55,46886.62,698.07,113785.41,0.00,0.00,0.00,0.00,0.00),('1','157','838','169339',3339809,'2404','364',31055.32,31494.12,438.80,71524.40,0.00,0.00,0.00,0.00,0.00),('1','157','839','169339',3339810,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169339',3339811,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169339',3339812,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169339',3339813,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169339',3339814,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169339',3339815,'2410','365',23562.42,24173.91,611.49,128412.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','169339',3339816,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169339',3339817,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169341',3339828,'2389','364',47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169341',3339829,'2390','364',22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169341',3339830,'2391','364',31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169341',3339831,'2392','364',41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169341',3339832,'2393','364',32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169341',3339833,'2394','364',37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169341',3339834,'2395','364',63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169341',3339835,'2396','364',101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169341',3339836,'2397','364',65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169341',3339837,'2398','364',87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169341',3339838,'2399','364',64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169341',3339839,'2400','364',56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169341',3339840,'2401','364',77418.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169341',3339841,'2402','364',25366.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169341',3339842,'2403','364',46886.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169341',3339843,'2404','364',31494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169341',3339844,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169341',3339845,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169341',3339846,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169341',3339847,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169341',3339848,'2409','365',3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169341',3339849,'2410','365',24173.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169341',3339850,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169341',3339851,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169342',3339852,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169342',3339853,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169342',3339854,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169342',3339855,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169342',3339856,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169342',3339857,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169342',3339858,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169342',3339859,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169342',3339860,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169342',3339861,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169342',3339862,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169342',3339863,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169342',3339864,'2401','364',77418.60,80018.79,2600.19,421230.78,0.00,0.00,0.00,0.00,0.00),('1','157','838','169342',3339865,'2402','364',25366.41,27090.56,1724.15,279312.30,0.00,0.00,0.00,0.00,0.00),('1','157','838','169342',3339866,'2403','364',46886.62,48871.85,1985.23,321607.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','169342',3339867,'2404','364',31494.12,32786.64,1292.52,209388.24,0.00,0.00,0.00,0.00,0.00),('1','157','839','169342',3339868,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169342',3339869,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169342',3339870,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169342',3339871,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169342',3339872,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169342',3339873,'2410','365',24173.91,24667.76,493.85,103708.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','169342',3339874,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169342',3339875,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169673',3346500,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169673',3346501,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169673',3346502,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169673',3346503,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169673',3346504,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169673',3346505,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169673',3346506,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169673',3346507,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169673',3346508,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169673',3346509,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169673',3346510,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169673',3346511,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169673',3346512,'2401','364',80018.79,82450.37,2431.58,393915.96,0.00,0.00,0.00,0.00,0.00),('1','157','838','169673',3346513,'2402','364',27090.56,29247.89,2157.33,349487.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','169673',3346514,'2403','364',48871.85,51187.71,2315.86,375169.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','169673',3346515,'2404','364',32786.64,35700.08,2913.44,471977.28,0.00,0.00,0.00,0.00,0.00),('1','157','839','169673',3346516,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169673',3346517,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169673',3346518,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169673',3346519,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169673',3346520,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169673',3346521,'2410','365',24667.76,24759.16,91.40,19194.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169673',3346522,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169673',3346523,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169675',3346548,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169675',3346549,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169675',3346550,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','169675',3346551,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169675',3346552,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169675',3346553,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169675',3346554,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','169675',3346555,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169675',3346556,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169675',3346557,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169675',3346558,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','169675',3346559,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','169675',3346560,'2401','364',82450.37,85489.25,3038.88,492298.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','169675',3346561,'2402','364',29247.89,31331.65,2083.76,337569.12,0.00,0.00,0.00,0.00,0.00),('1','157','838','169675',3346562,'2403','364',51187.71,53201.57,2013.86,326245.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','169675',3346563,'2404','364',35700.08,38518.84,2818.76,456639.12,0.00,0.00,0.00,0.00,0.00),('1','157','839','169675',3346564,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169675',3346565,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169675',3346566,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','169675',3346567,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169675',3346568,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169675',3346569,'2410','365',24759.16,24967.84,208.68,43822.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','169675',3346570,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','169675',3346571,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170076',3353921,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170076',3353922,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170076',3353923,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170076',3353924,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170076',3353925,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170076',3353926,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170076',3353927,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170076',3353928,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170076',3353929,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170076',3353930,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170076',3353931,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170076',3353932,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170076',3353933,'2401','364',85489.25,87674.85,2185.60,354067.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','170076',3353934,'2402','364',31331.65,33388.39,2056.74,333191.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','170076',3353935,'2403','364',53201.57,54835.40,1633.83,264680.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','170076',3353936,'2404','364',38518.84,40905.37,2386.53,386617.86,0.00,0.00,0.00,0.00,0.00),('1','157','839','170076',3353937,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170076',3353938,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170076',3353939,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170076',3353940,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170076',3353941,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170076',3353942,'2410','365',24967.84,25078.80,110.96,23301.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','170076',3353943,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170076',3353944,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170077',3353945,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170077',3353946,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170077',3353947,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170077',3353948,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170077',3353949,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170077',3353950,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170077',3353951,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170077',3353952,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170077',3353953,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170077',3353954,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170077',3353955,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170077',3353956,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170077',3353957,'2401','364',87674.85,89330.58,1655.73,268228.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','170077',3353958,'2402','364',33388.39,34863.26,1474.87,238928.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','170077',3353959,'2403','364',54835.40,56453.33,1617.93,262104.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','170077',3353960,'2404','364',40905.37,42199.26,1293.89,209610.18,0.00,0.00,0.00,0.00,0.00),('1','157','839','170077',3353961,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170077',3353962,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170077',3353963,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170077',3353964,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170077',3353965,'2409','365',3673.23,3673.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170077',3353966,'2410','365',25078.80,25725.23,646.43,135750.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','170077',3353967,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170077',3353968,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170079',3354023,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170079',3354024,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170079',3354025,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170079',3354026,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170079',3354027,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170079',3354028,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170079',3354029,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170079',3354030,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170079',3354031,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170079',3354032,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170079',3354033,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170079',3354034,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170079',3354035,'2401','364',89330.58,90228.27,897.69,145425.78,0.00,0.00,0.00,0.00,0.00),('1','157','838','170079',3354036,'2402','364',34863.26,35500.68,637.42,103262.04,0.00,0.00,0.00,0.00,0.00),('1','157','838','170079',3354037,'2403','364',56453.33,57606.15,1152.82,186756.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','170079',3354038,'2404','364',42199.26,42969.58,770.32,124791.84,0.00,0.00,0.00,0.00,0.00),('1','157','839','170079',3354039,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170079',3354040,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170079',3354041,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170079',3354042,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170079',3354043,'2409','365',3673.23,3713.23,40.00,8400.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170079',3354044,'2410','365',25725.23,25872.85,147.62,31000.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','170079',3354045,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170079',3354046,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170080',3354047,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170080',3354048,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170080',3354049,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170080',3354050,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170080',3354051,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170080',3354052,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170080',3354053,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170080',3354054,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170080',3354055,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170080',3354056,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170080',3354057,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170080',3354058,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170080',3354059,'2401','364',90228.27,91655.43,1427.16,231199.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','170080',3354060,'2402','364',35500.68,36857.23,1356.55,219761.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','170080',3354061,'2403','364',57606.15,58920.11,1313.96,212861.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','170080',3354062,'2404','364',42969.58,44679.26,1709.68,276968.16,0.00,0.00,0.00,0.00,0.00),('1','157','839','170080',3354063,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170080',3354064,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170080',3354065,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170080',3354066,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170080',3354067,'2409','365',3713.23,3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170080',3354068,'2410','365',25872.85,25953.90,81.05,17020.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','170080',3354069,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170080',3354070,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170083',3354075,'2389','364',47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170083',3354076,'2390','364',22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170083',3354077,'2391','364',31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170083',3354078,'2392','364',41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170083',3354079,'2393','364',32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170083',3354080,'2394','364',37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170083',3354081,'2395','364',63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170083',3354082,'2396','364',101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170083',3354083,'2397','364',65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170083',3354084,'2398','364',87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170083',3354085,'2399','364',64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170083',3354086,'2400','364',56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170083',3354087,'2401','364',91655.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170083',3354088,'2402','364',36857.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170083',3354089,'2403','364',58920.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170083',3354090,'2404','364',44679.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170083',3354091,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170083',3354092,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170083',3354093,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170083',3354094,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170083',3354095,'2409','365',3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170083',3354096,'2410','365',25953.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170083',3354097,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170083',3354098,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170084',3354099,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170084',3354100,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170084',3354101,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170084',3354102,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170084',3354103,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170084',3354104,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170084',3354105,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170084',3354106,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170084',3354107,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170084',3354108,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170084',3354109,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170084',3354110,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170084',3354111,'2401','364',91655.43,91733.77,68.34,11071.08,0.00,0.00,10.00,0.00,0.00),('1','157','838','170084',3354112,'2402','364',36857.23,37824.82,967.59,156749.58,0.00,0.00,0.00,0.00,0.00),('1','157','838','170084',3354113,'2403','364',58920.11,59265.54,345.43,55959.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','170084',3354114,'2404','364',44679.26,45034.33,355.07,57521.34,0.00,0.00,0.00,0.00,0.00),('1','157','839','170084',3354115,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170084',3354116,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170084',3354117,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170084',3354118,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170084',3354119,'2409','365',3713.23,3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170084',3354120,'2410','365',25953.90,26019.15,65.25,13702.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','170084',3354121,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170084',3354122,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170085',3354123,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170085',3354124,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170085',3354125,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170085',3354126,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170085',3354127,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170085',3354128,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170085',3354129,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170085',3354130,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170085',3354131,'2397','364',65947.29,65947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170085',3354132,'2398','364',87019.04,87019.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170085',3354133,'2399','364',64821.92,64821.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170085',3354134,'2400','364',56222.96,56222.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170085',3354135,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170085',3354136,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170085',3354137,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170085',3354138,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170085',3354139,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170085',3354140,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170085',3354141,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170085',3354142,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170085',3354143,'2409','365',3713.23,3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170085',3354144,'2410','365',26019.15,26280.62,251.47,52808.70,0.00,0.00,10.00,0.00,0.00),('1','157','840','170085',3354145,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170085',3354146,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170086',3354147,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170086',3354148,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170086',3354149,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170086',3354150,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170086',3354151,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170086',3354152,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170086',3354153,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170086',3354154,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170086',3354155,'2397','364',65947.29,66530.13,572.84,92800.08,0.00,0.00,10.00,0.00,0.00),('1','157','837','170086',3354156,'2398','364',87019.04,87538.28,509.24,82496.88,0.00,0.00,10.00,0.00,0.00),('1','157','837','170086',3354157,'2399','364',64821.92,65311.29,479.37,77657.94,0.00,0.00,10.00,0.00,0.00),('1','157','837','170086',3354158,'2400','364',56222.96,56794.21,561.25,90922.50,0.00,0.00,10.00,0.00,0.00),('1','157','838','170086',3354159,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170086',3354160,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170086',3354161,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170086',3354162,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170086',3354163,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170086',3354164,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170086',3354165,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170086',3354166,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170086',3354167,'2409','365',3713.23,3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170086',3354168,'2410','365',26280.62,26633.00,342.38,71899.80,0.00,0.00,10.00,0.00,0.00),('1','157','840','170086',3354169,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170086',3354170,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170087',3354171,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170087',3354172,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170087',3354173,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170087',3354174,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170087',3354175,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170087',3354176,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170087',3354177,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170087',3354178,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170087',3354179,'2397','364',66530.13,67816.90,1286.77,208456.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','170087',3354180,'2398','364',87538.28,88937.54,1399.26,226680.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','170087',3354181,'2399','364',65311.29,66758.51,1447.22,234449.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','170087',3354182,'2400','364',56794.21,57766.01,971.80,157431.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','170087',3354183,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170087',3354184,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170087',3354185,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170087',3354186,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170087',3354187,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170087',3354188,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170087',3354189,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170087',3354190,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170087',3354191,'2409','365',3713.23,3713.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170087',3354192,'2410','365',26633.00,26741.09,108.09,22698.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','170087',3354193,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170087',3354194,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170090',3354210,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170090',3354211,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170090',3354212,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170090',3354213,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170090',3354214,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170090',3354215,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170090',3354216,'2395','364',63434.33,63434.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170090',3354217,'2396','364',101888.44,101888.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170090',3354218,'2397','364',67816.90,69673.52,1856.62,300772.44,0.00,0.00,0.00,0.00,0.00),('1','157','837','170090',3354219,'2398','364',88937.54,89963.97,1026.43,166281.66,0.00,0.00,0.00,0.00,0.00),('1','157','837','170090',3354220,'2399','364',66758.51,68215.86,1457.35,236090.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','170090',3354221,'2400','364',57766.01,59219.80,1453.79,235513.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','170090',3354222,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170090',3354223,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170090',3354224,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170090',3354225,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170090',3354226,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170090',3354227,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170090',3354228,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170090',3354229,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170090',3354230,'2409','365',3713.23,3794.19,80.96,17001.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','170090',3354231,'2410','365',26741.09,26741.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170090',3354232,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170090',3354233,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170385',3359041,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170385',3359042,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170385',3359043,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170385',3359044,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170385',3359045,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170385',3359046,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170385',3359047,'2395','364',63434.33,63493.00,33.67,5454.54,0.00,0.00,25.00,0.00,0.00),('1','157','836','170385',3359048,'2396','364',101888.44,102036.59,108.15,17520.30,0.00,0.00,40.00,0.00,0.00),('1','157','837','170385',3359049,'2397','364',69673.52,70627.90,914.38,148129.56,0.00,0.00,40.00,0.00,0.00),('1','157','837','170385',3359050,'2398','364',89963.97,91470.68,1466.71,237607.02,0.00,0.00,40.00,0.00,0.00),('1','157','837','170385',3359051,'2399','364',68215.86,69129.17,873.31,141476.22,0.00,0.00,40.00,0.00,0.00),('1','157','837','170385',3359052,'2400','364',59219.80,60729.95,1470.15,238164.30,0.00,0.00,40.00,0.00,0.00),('1','157','838','170385',3359053,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170385',3359054,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170385',3359055,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170385',3359056,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170385',3359057,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170385',3359058,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170385',3359059,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170385',3359060,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170385',3359061,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170385',3359062,'2410','365',26741.09,26962.75,221.66,46548.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','170385',3359063,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170385',3359064,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170390',3359156,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170390',3359157,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170390',3359158,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170390',3359159,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170390',3359160,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170390',3359161,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170390',3359162,'2395','364',63493.00,65964.51,2461.51,398764.62,0.00,0.00,10.00,0.00,0.00),('1','157','836','170390',3359163,'2396','364',102036.59,104261.60,2215.01,358831.62,0.00,0.00,10.00,0.00,0.00),('1','157','837','170390',3359164,'2397','364',70627.90,71035.76,397.86,64453.32,0.00,0.00,10.00,0.00,0.00),('1','157','837','170390',3359165,'2398','364',91470.68,92199.74,719.06,116487.72,0.00,0.00,10.00,0.00,0.00),('1','157','837','170390',3359166,'2399','364',69129.17,69172.38,43.21,7000.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','170390',3359167,'2400','364',60729.95,61394.12,654.17,105975.54,0.00,0.00,10.00,0.00,0.00),('1','157','838','170390',3359168,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170390',3359169,'2402','364',37824.82,37824.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170390',3359170,'2403','364',59265.54,59265.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170390',3359171,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170390',3359172,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170390',3359173,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170390',3359174,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170390',3359175,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170390',3359176,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170390',3359177,'2410','365',26962.75,27081.16,113.41,23816.10,0.00,0.00,5.00,0.00,0.00),('1','157','840','170390',3359178,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170390',3359179,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170391',3359180,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170391',3359181,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170391',3359182,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170391',3359183,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170391',3359184,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170391',3359185,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170391',3359186,'2395','364',65964.51,66890.53,926.02,150015.24,0.00,0.00,0.00,0.00,0.00),('1','157','836','170391',3359187,'2396','364',104261.60,105186.61,925.01,149851.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','170391',3359188,'2397','364',71035.76,72261.48,1225.72,198566.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','170391',3359189,'2398','364',92199.74,92199.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','170391',3359190,'2399','364',69172.38,70900.67,1728.29,279982.98,0.00,0.00,0.00,0.00,0.00),('1','157','837','170391',3359191,'2400','364',61394.12,61394.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170391',3359192,'2401','364',91733.77,91733.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170391',3359193,'2402','364',37824.82,38691.06,866.24,140330.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','170391',3359194,'2403','364',59265.54,60109.94,844.40,136792.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','170391',3359195,'2404','364',45034.33,45034.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170391',3359196,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170391',3359197,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170391',3359198,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170391',3359199,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170391',3359200,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170391',3359201,'2410','365',27081.16,29372.15,2290.99,481107.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','170391',3359202,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170391',3359203,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170596',3362844,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170596',3362845,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170596',3362846,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170596',3362847,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170596',3362848,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170596',3362849,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170596',3362850,'2395','364',66890.53,67838.70,948.17,153603.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','170596',3362851,'2396','364',105186.61,106915.76,1704.15,276072.30,0.00,0.00,25.00,0.00,0.00),('1','157','837','170596',3362852,'2397','364',72261.48,72670.85,409.37,66317.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','170596',3362853,'2398','364',92199.74,93816.60,1606.86,260311.32,0.00,0.00,10.00,0.00,0.00),('1','157','837','170596',3362854,'2399','364',70900.67,72263.35,1362.68,220754.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','170596',3362855,'2400','364',61394.12,61877.01,462.89,74988.18,0.00,0.00,20.00,0.00,0.00),('1','157','838','170596',3362856,'2401','364',91733.77,92229.93,466.16,75517.92,0.00,0.00,30.00,0.00,0.00),('1','157','838','170596',3362857,'2402','364',38691.06,38729.25,0.00,0.00,0.00,0.00,38.19,0.00,0.00),('1','157','838','170596',3362858,'2403','364',60109.94,60467.50,346.56,56142.72,0.00,0.00,11.00,0.00,0.00),('1','157','838','170596',3362859,'2404','364',45034.33,45082.35,0.00,0.00,0.00,0.00,48.02,0.00,0.00),('1','157','839','170596',3362860,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170596',3362861,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170596',3362862,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170596',3362863,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170596',3362864,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170596',3362865,'2410','365',29372.15,29429.29,57.14,11999.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','170596',3362866,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170596',3362867,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170609',3363070,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170609',3363071,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170609',3363072,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170609',3363073,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170609',3363074,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170609',3363075,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170609',3363076,'2395','364',67838.70,68603.47,764.77,123892.74,0.00,0.00,0.00,0.00,0.00),('1','157','836','170609',3363077,'2396','364',106915.76,107644.71,728.95,118089.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','170609',3363078,'2397','364',72670.85,73355.33,684.48,110885.76,0.00,0.00,0.00,0.00,0.00),('1','157','837','170609',3363079,'2398','364',93816.60,95345.51,1528.91,247683.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','170609',3363080,'2399','364',72263.35,72649.81,386.46,62606.52,0.00,0.00,0.00,0.00,0.00),('1','157','837','170609',3363081,'2400','364',61877.01,62477.01,600.00,97200.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170609',3363082,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170609',3363083,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170609',3363084,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170609',3363085,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170609',3363086,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170609',3363087,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170609',3363088,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170609',3363089,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170609',3363090,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170609',3363091,'2410','365',29429.29,29600.48,171.19,35949.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','170609',3363092,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170609',3363093,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170612',3363170,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170612',3363171,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170612',3363172,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170612',3363173,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170612',3363174,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170612',3363175,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170612',3363176,'2395','364',68603.47,69453.68,840.21,136114.02,0.00,0.00,10.00,0.00,0.00),('1','157','836','170612',3363177,'2396','364',107644.71,108698.96,1034.25,167548.50,0.00,0.00,20.00,0.00,0.00),('1','157','837','170612',3363178,'2397','364',73355.33,74243.02,867.69,140565.78,0.00,0.00,20.00,0.00,0.00),('1','157','837','170612',3363179,'2398','364',95345.51,96399.72,1044.21,169162.02,0.00,0.00,10.00,0.00,0.00),('1','157','837','170612',3363180,'2399','364',72649.81,74155.19,1485.38,240631.56,0.00,0.00,20.00,0.00,0.00),('1','157','837','170612',3363181,'2400','364',62477.01,62477.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170612',3363182,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170612',3363183,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170612',3363184,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170612',3363185,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170612',3363186,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170612',3363187,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170612',3363188,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170612',3363189,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170612',3363190,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170612',3363191,'2410','365',29600.48,29873.12,262.64,55154.40,0.00,0.00,10.00,0.00,0.00),('1','157','840','170612',3363192,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170612',3363193,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170773',3366136,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170773',3366137,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170773',3366138,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170773',3366139,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170773',3366140,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170773',3366141,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170773',3366142,'2395','364',69453.68,70195.85,742.17,120231.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','170773',3366143,'2396','364',108698.96,109430.85,731.89,118566.18,0.00,0.00,0.00,0.00,0.00),('1','157','837','170773',3366144,'2397','364',74243.02,75008.82,765.80,124059.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','170773',3366145,'2398','364',96399.72,97637.10,1237.38,200455.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','170773',3366146,'2399','364',74155.19,74744.75,589.56,95508.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','170773',3366147,'2400','364',62477.01,63291.92,814.91,132015.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','170773',3366148,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170773',3366149,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170773',3366150,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170773',3366151,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170773',3366152,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170773',3366153,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170773',3366154,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170773',3366155,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170773',3366156,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170773',3366157,'2410','365',29873.12,29981.70,108.58,22801.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','170773',3366158,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170773',3366159,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170775',3366176,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170775',3366177,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170775',3366178,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170775',3366179,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170775',3366180,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170775',3366181,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170775',3366182,'2395','364',70195.85,71066.02,870.17,140967.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','170775',3366183,'2396','364',109430.85,110019.88,589.03,95422.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','170775',3366184,'2397','364',75008.82,75648.40,639.58,103611.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','170775',3366185,'2398','364',97637.10,98353.85,716.75,116113.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','170775',3366186,'2399','364',74744.75,75457.69,712.94,115496.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','170775',3366187,'2400','364',63291.92,63998.38,706.46,114446.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','170775',3366188,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170775',3366189,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170775',3366190,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170775',3366191,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170775',3366192,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170775',3366193,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170775',3366194,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170775',3366195,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170775',3366196,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170775',3366197,'2410','365',29981.70,30270.74,289.04,60698.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','170775',3366198,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170775',3366199,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170933',3368832,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170933',3368833,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170933',3368834,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170933',3368835,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170933',3368836,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170933',3368837,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170933',3368838,'2395','364',71066.02,71721.26,655.24,106148.88,0.00,0.00,0.00,0.00,0.00),('1','157','836','170933',3368839,'2396','364',110019.88,110889.15,869.27,140821.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','170933',3368840,'2397','364',75648.40,76324.26,675.86,109489.32,0.00,0.00,0.00,0.00,0.00),('1','157','837','170933',3368841,'2398','364',98353.85,99705.46,1351.61,218960.82,0.00,0.00,0.00,0.00,0.00),('1','157','837','170933',3368842,'2399','364',75457.69,76002.37,544.68,88238.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','170933',3368843,'2400','364',63998.38,64921.06,922.68,149474.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','170933',3368844,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170933',3368845,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170933',3368846,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170933',3368847,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170933',3368848,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170933',3368849,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170933',3368850,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170933',3368851,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170933',3368852,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170933',3368853,'2410','365',30270.74,30420.75,150.01,31502.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','170933',3368854,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170933',3368855,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170937',3368913,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170937',3368914,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170937',3368915,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','170937',3368916,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170937',3368917,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170937',3368918,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','170937',3368919,'2395','364',71721.26,72050.81,329.55,53387.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','170937',3368920,'2396','364',110889.15,111371.92,482.77,78208.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','170937',3368921,'2397','364',76324.26,77153.40,829.14,134320.68,0.00,0.00,0.00,0.00,0.00),('1','157','837','170937',3368922,'2398','364',99705.46,101318.59,1603.13,259707.06,0.00,0.00,10.00,0.00,0.00),('1','157','837','170937',3368923,'2399','364',76002.37,76986.75,984.38,159469.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','170937',3368924,'2400','364',64921.06,66058.13,1137.07,184205.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','170937',3368925,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170937',3368926,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170937',3368927,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','170937',3368928,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170937',3368929,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170937',3368930,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170937',3368931,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','170937',3368932,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170937',3368933,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170937',3368934,'2410','365',30420.75,31108.84,688.09,144498.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','170937',3368935,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','170937',3368936,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171084',3371617,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171084',3371618,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171084',3371619,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171084',3371620,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171084',3371621,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171084',3371622,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171084',3371623,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171084',3371624,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171084',3371625,'2397','364',77153.40,78064.67,911.27,147625.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','171084',3371626,'2398','364',101318.59,102848.09,1529.50,247779.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171084',3371627,'2399','364',76986.75,78447.34,1460.59,236615.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','171084',3371628,'2400','364',66058.13,67255.18,1197.05,193922.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','171084',3371629,'2401','364',92229.93,92229.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171084',3371630,'2402','364',38729.25,38729.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171084',3371631,'2403','364',60467.50,60467.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171084',3371632,'2404','364',45082.35,45082.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171084',3371633,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171084',3371634,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171084',3371635,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171084',3371636,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171084',3371637,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171084',3371638,'2410','365',31108.84,31231.93,123.09,25848.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','171084',3371639,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171084',3371640,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171280',3375336,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171280',3375337,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171280',3375338,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171280',3375339,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171280',3375340,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171280',3375341,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171280',3375342,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171280',3375343,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171280',3375344,'2397','364',78064.67,78064.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171280',3375345,'2398','364',102848.09,102848.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171280',3375346,'2399','364',78447.34,78447.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171280',3375347,'2400','364',67255.18,67255.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171280',3375348,'2401','364',92229.93,94230.49,1960.56,317610.72,0.00,0.00,40.00,0.00,0.00),('1','157','838','171280',3375349,'2402','364',38729.25,40169.29,1410.04,228426.48,0.00,0.00,30.00,0.00,0.00),('1','157','838','171280',3375350,'2403','364',60467.50,61779.92,1282.42,207752.04,0.00,0.00,30.00,0.00,0.00),('1','157','838','171280',3375351,'2404','364',45082.35,46787.18,1674.83,271322.46,0.00,0.00,30.00,0.00,0.00),('1','157','839','171280',3375352,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171280',3375353,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171280',3375354,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171280',3375355,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171280',3375356,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171280',3375357,'2410','365',31231.93,31659.56,427.63,89802.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','171280',3375358,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171280',3375359,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171283',3375444,'2389','364',47784.74,47784.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171283',3375445,'2390','364',22034.29,22034.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171283',3375446,'2391','364',31953.59,31953.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171283',3375447,'2392','364',41716.33,41716.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171283',3375448,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171283',3375449,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171283',3375450,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171283',3375451,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171283',3375452,'2397','364',78064.67,79071.26,1006.59,163067.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','171283',3375453,'2398','364',102848.09,103732.03,883.94,143198.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','171283',3375454,'2399','364',78447.34,79541.11,1093.77,177190.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','171283',3375455,'2400','364',67255.18,68050.98,795.80,128919.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','171283',3375456,'2401','364',94230.49,94921.99,691.50,112023.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171283',3375457,'2402','364',40169.29,40755.00,585.71,94885.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','171283',3375458,'2403','364',61779.92,62406.17,626.25,101452.50,0.00,0.00,0.00,0.00,0.00),('1','157','838','171283',3375459,'2404','364',46787.18,46787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171283',3375460,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171283',3375461,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171283',3375462,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171283',3375463,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171283',3375464,'2409','365',3794.19,3794.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171283',3375465,'2410','365',31659.56,31844.87,185.31,38915.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','171283',3375466,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171283',3375467,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171542',3380097,'2389','364',47784.74,48109.56,314.82,51000.84,0.00,0.00,10.00,0.00,0.00),('1','157','835','171542',3380098,'2390','364',22034.29,22046.67,2.38,385.56,0.00,0.00,10.00,0.00,0.00),('1','157','835','171542',3380099,'2391','364',31953.59,32508.79,545.20,88322.40,0.00,0.00,10.00,0.00,0.00),('1','157','835','171542',3380100,'2392','364',41716.33,41729.97,3.64,589.68,0.00,0.00,10.00,0.00,0.00),('1','157','836','171542',3380101,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171542',3380102,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171542',3380103,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171542',3380104,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171542',3380105,'2397','364',79071.26,80730.05,1648.79,267103.98,0.00,0.00,10.00,0.00,0.00),('1','157','837','171542',3380106,'2398','364',103732.03,105240.35,1508.32,244347.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','171542',3380107,'2399','364',79541.11,79867.65,316.54,51279.48,0.00,0.00,10.00,0.00,0.00),('1','157','837','171542',3380108,'2400','364',68050.98,69123.37,1072.39,173727.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','171542',3380109,'2401','364',94921.99,95934.42,1002.43,162393.66,0.00,0.00,10.00,0.00,0.00),('1','157','838','171542',3380110,'2402','364',40755.00,40990.67,235.67,38178.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','171542',3380111,'2403','364',62406.17,63168.60,752.43,121893.66,0.00,0.00,10.00,0.00,0.00),('1','157','838','171542',3380112,'2404','364',46787.18,46787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171542',3380113,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171542',3380114,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171542',3380115,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171542',3380116,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171542',3380117,'2409','365',3794.19,3941.08,136.89,28746.90,0.00,0.00,10.00,0.00,0.00),('1','157','840','171542',3380118,'2410','365',31844.87,31854.87,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','171542',3380119,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171542',3380120,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171548',3380217,'2389','364',48109.56,48109.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171548',3380218,'2390','364',22046.67,22793.08,746.41,120918.42,0.00,0.00,0.00,0.00,0.00),('1','157','835','171548',3380219,'2391','364',32508.79,32508.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171548',3380220,'2392','364',41729.97,42527.11,797.14,129136.68,0.00,0.00,0.00,0.00,0.00),('1','157','836','171548',3380221,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171548',3380222,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171548',3380223,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171548',3380224,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171548',3380225,'2397','364',80730.05,81855.60,1125.55,182339.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','171548',3380226,'2398','364',105240.35,106619.70,1379.35,223454.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','171548',3380227,'2399','364',79867.65,80855.19,987.54,159981.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','171548',3380228,'2400','364',69123.37,69123.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171548',3380229,'2401','364',95934.42,95934.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171548',3380230,'2402','364',40990.67,41853.28,857.61,138932.82,0.00,0.00,5.00,0.00,0.00),('1','157','838','171548',3380231,'2403','364',63168.60,64332.88,1164.28,188613.36,0.00,0.00,0.00,0.00,0.00),('1','157','838','171548',3380232,'2404','364',46787.18,46787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171548',3380233,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171548',3380234,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171548',3380235,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171548',3380236,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171548',3380237,'2409','365',3941.08,3986.32,45.24,9500.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','171548',3380238,'2410','365',31854.87,32175.05,320.18,67237.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','171548',3380239,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171548',3380240,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171552',3380280,'2389','364',48109.56,48699.15,589.59,95513.58,0.00,0.00,0.00,0.00,0.00),('1','157','835','171552',3380281,'2390','364',22793.08,22793.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171552',3380282,'2391','364',32508.79,32508.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171552',3380283,'2392','364',42527.11,43412.69,885.58,143463.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','171552',3380284,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171552',3380285,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171552',3380286,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171552',3380287,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171552',3380288,'2397','364',81855.60,82760.35,904.75,146569.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','171552',3380289,'2398','364',106619.70,108016.53,1396.83,226286.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','171552',3380290,'2399','364',80855.19,80986.36,131.17,21249.54,0.00,0.00,0.00,0.00,0.00),('1','157','837','171552',3380291,'2400','364',69123.37,70052.24,928.87,150476.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','171552',3380292,'2401','364',95934.42,96825.20,890.78,144306.36,0.00,0.00,0.00,0.00,0.00),('1','157','838','171552',3380293,'2402','364',41853.28,41853.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171552',3380294,'2403','364',64332.88,64332.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171552',3380295,'2404','364',46787.18,47082.50,295.32,47841.84,0.00,0.00,0.00,0.00,0.00),('1','157','839','171552',3380296,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171552',3380297,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171552',3380298,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171552',3380299,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171552',3380300,'2409','365',3986.32,3986.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171552',3380301,'2410','365',32175.05,32548.05,373.00,78330.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171552',3380302,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171552',3380303,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171716',3383253,'2389','364',48699.15,49588.93,889.78,144144.36,0.00,0.00,0.00,0.00,0.00),('1','157','835','171716',3383254,'2390','364',22793.08,22793.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171716',3383255,'2391','364',32508.79,32961.04,452.25,73264.50,0.00,0.00,0.00,0.00,0.00),('1','157','835','171716',3383256,'2392','364',43412.69,44132.22,719.53,116563.86,0.00,0.00,0.00,0.00,0.00),('1','157','836','171716',3383257,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171716',3383258,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171716',3383259,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171716',3383260,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171716',3383261,'2397','364',82760.35,83797.79,1037.44,168065.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','171716',3383262,'2398','364',108016.53,109465.32,1448.79,234703.98,0.00,0.00,0.00,0.00,0.00),('1','157','837','171716',3383263,'2399','364',80986.36,81818.55,832.19,134814.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','171716',3383264,'2400','364',70052.24,70415.90,363.66,58912.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','171716',3383265,'2401','364',96825.20,96825.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171716',3383266,'2402','364',41853.28,41853.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171716',3383267,'2403','364',64332.88,64332.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171716',3383268,'2404','364',47082.50,47082.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171716',3383269,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171716',3383270,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171716',3383271,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171716',3383272,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171716',3383273,'2409','365',3986.32,3986.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171716',3383274,'2410','365',32548.05,32612.80,64.75,13597.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','171716',3383275,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171716',3383276,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171718',3383308,'2389','364',49588.93,50167.21,578.28,93681.36,0.00,0.00,0.00,0.00,0.00),('1','157','835','171718',3383309,'2390','364',22793.08,22793.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171718',3383310,'2391','364',32961.04,33477.42,516.38,83653.56,0.00,0.00,0.00,0.00,0.00),('1','157','835','171718',3383311,'2392','364',44132.22,44705.26,573.04,92832.48,0.00,0.00,0.00,0.00,0.00),('1','157','836','171718',3383312,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171718',3383313,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171718',3383314,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171718',3383315,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171718',3383316,'2397','364',83797.79,84744.75,946.96,153407.52,0.00,0.00,0.00,0.00,0.00),('1','157','837','171718',3383317,'2398','364',109465.32,110623.42,1158.10,187612.20,0.00,0.00,0.00,0.00,0.00),('1','157','837','171718',3383318,'2399','364',81818.55,82421.42,602.87,97664.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','171718',3383319,'2400','364',70415.90,71613.13,1197.23,193951.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','171718',3383320,'2401','364',96825.20,96825.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171718',3383321,'2402','364',41853.28,41853.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171718',3383322,'2403','364',64332.88,64332.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171718',3383323,'2404','364',47082.50,47082.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171718',3383324,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171718',3383325,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171718',3383326,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171718',3383327,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171718',3383328,'2409','365',3986.32,3986.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171718',3383329,'2410','365',32612.80,32676.10,63.30,13293.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171718',3383330,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171718',3383331,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171866',3385909,'2389','364',50167.21,50853.30,686.09,111146.58,0.00,0.00,0.00,0.00,0.00),('1','157','835','171866',3385910,'2390','364',22793.08,22793.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171866',3385911,'2391','364',33477.42,34637.28,1159.86,187897.32,0.00,0.00,0.00,0.00,0.00),('1','157','835','171866',3385912,'2392','364',44705.26,44705.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171866',3385913,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171866',3385914,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171866',3385915,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171866',3385916,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171866',3385917,'2397','364',84744.75,85788.67,1043.92,169115.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','171866',3385918,'2398','364',110623.42,111890.77,1267.35,205310.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','171866',3385919,'2399','364',82421.42,83110.37,688.95,111609.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','171866',3385920,'2400','364',71613.13,72645.18,1032.05,167192.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','171866',3385921,'2401','364',96825.20,96825.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171866',3385922,'2402','364',41853.28,41853.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171866',3385923,'2403','364',64332.88,64332.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171866',3385924,'2404','364',47082.50,47082.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171866',3385925,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171866',3385926,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171866',3385927,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171866',3385928,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171866',3385929,'2409','365',3986.32,4069.65,83.33,17499.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','171866',3385930,'2410','365',32676.10,33770.87,1094.77,229901.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','171866',3385931,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171866',3385932,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171999',3388063,'2389','364',50853.30,51994.03,1140.73,184798.26,0.00,0.00,0.00,0.00,0.00),('1','157','835','171999',3388064,'2390','364',22793.08,22793.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','171999',3388065,'2391','364',34637.28,35742.77,1105.49,179089.38,0.00,0.00,0.00,0.00,0.00),('1','157','835','171999',3388066,'2392','364',44705.26,45414.80,709.54,114945.48,0.00,0.00,0.00,0.00,0.00),('1','157','836','171999',3388067,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171999',3388068,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171999',3388069,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','171999',3388070,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','171999',3388071,'2397','364',85788.67,86366.48,577.81,93605.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','171999',3388072,'2398','364',111890.77,113036.62,1145.85,185627.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','171999',3388073,'2399','364',83110.37,83440.05,329.68,53408.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','171999',3388074,'2400','364',72645.18,73459.20,814.02,131871.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','171999',3388075,'2401','364',96825.20,97013.16,187.96,30449.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','171999',3388076,'2402','364',41853.28,41853.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','171999',3388077,'2403','364',64332.88,64360.05,27.17,4401.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','171999',3388078,'2404','364',47082.50,47101.11,18.61,3014.82,0.00,0.00,0.00,0.00,0.00),('1','157','839','171999',3388079,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171999',3388080,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171999',3388081,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','171999',3388082,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171999',3388083,'2409','365',4069.65,4169.65,100.00,21000.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171999',3388084,'2410','365',33770.87,34652.30,881.43,185100.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','171999',3388085,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','171999',3388086,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172004',3388183,'2389','364',51994.03,52438.01,443.98,71924.76,0.00,0.00,0.00,0.00,0.00),('1','157','835','172004',3388184,'2390','364',22793.08,23553.40,760.32,123171.84,0.00,0.00,0.00,0.00,0.00),('1','157','835','172004',3388185,'2391','364',35742.77,35742.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172004',3388186,'2392','364',45414.80,46322.88,908.08,147108.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','172004',3388187,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172004',3388188,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172004',3388189,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172004',3388190,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172004',3388191,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172004',3388192,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172004',3388193,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172004',3388194,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172004',3388195,'2401','364',97013.16,98147.51,1134.35,183764.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','172004',3388196,'2402','364',41853.28,42348.65,495.37,80249.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','172004',3388197,'2403','364',64360.05,65020.78,660.73,107038.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','172004',3388198,'2404','364',47101.11,47591.76,490.65,79485.30,0.00,0.00,0.00,0.00,0.00),('1','157','839','172004',3388199,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172004',3388200,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172004',3388201,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172004',3388202,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172004',3388203,'2409','365',4169.65,4169.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172004',3388204,'2410','365',34652.30,34820.90,168.60,35406.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172004',3388205,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172004',3388206,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172061',3389401,'2389','364',52438.01,53031.05,593.04,96072.48,0.00,0.00,0.00,0.00,0.00),('1','157','835','172061',3389402,'2390','364',23553.40,23553.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172061',3389403,'2391','364',35742.77,36283.14,540.37,87539.94,0.00,0.00,0.00,0.00,0.00),('1','157','835','172061',3389404,'2392','364',46322.88,47205.78,882.90,143029.80,0.00,0.00,0.00,0.00,0.00),('1','157','836','172061',3389405,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172061',3389406,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172061',3389407,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172061',3389408,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172061',3389409,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172061',3389410,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172061',3389411,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172061',3389412,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172061',3389413,'2401','364',98147.51,98915.47,767.96,124409.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','172061',3389414,'2402','364',42348.65,43636.78,1288.13,208677.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','172061',3389415,'2403','364',65020.78,65387.94,367.16,59479.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','172061',3389416,'2404','364',47591.76,48158.77,567.01,91855.62,0.00,0.00,0.00,0.00,0.00),('1','157','839','172061',3389417,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172061',3389418,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172061',3389419,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172061',3389420,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172061',3389421,'2409','365',4169.65,4169.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172061',3389422,'2410','365',34820.90,35001.85,180.95,37999.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','172061',3389423,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172061',3389424,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172235',3392545,'2389','364',53031.05,53921.58,890.53,144265.86,0.00,0.00,0.00,0.00,0.00),('1','157','835','172235',3392546,'2390','364',23553.40,23553.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172235',3392547,'2391','364',36283.14,36943.68,660.54,107007.48,0.00,0.00,0.00,0.00,0.00),('1','157','835','172235',3392548,'2392','364',47205.78,48153.78,948.00,153576.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172235',3392549,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172235',3392550,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172235',3392551,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172235',3392552,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172235',3392553,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172235',3392554,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172235',3392555,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172235',3392556,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172235',3392557,'2401','364',98915.47,99815.80,900.33,145853.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','172235',3392558,'2402','364',43636.78,44758.15,1121.37,181661.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','172235',3392559,'2403','364',65387.94,66689.27,1301.33,210815.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','172235',3392560,'2404','364',48158.77,49118.39,959.62,155458.44,0.00,0.00,0.00,0.00,0.00),('1','157','839','172235',3392561,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172235',3392562,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172235',3392563,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172235',3392564,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172235',3392565,'2409','365',4169.65,4169.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172235',3392566,'2410','365',35001.85,35541.00,539.15,113221.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','172235',3392567,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172235',3392568,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172241',3392667,'2389','364',53921.58,54563.97,642.39,104067.18,0.00,0.00,0.00,0.00,0.00),('1','157','835','172241',3392668,'2390','364',23553.40,24341.23,787.83,127628.46,0.00,0.00,0.00,0.00,0.00),('1','157','835','172241',3392669,'2391','364',36943.68,38555.25,1611.57,261074.34,0.00,0.00,0.00,0.00,0.00),('1','157','835','172241',3392670,'2392','364',48153.78,48165.51,11.73,1900.26,0.00,0.00,0.00,0.00,0.00),('1','157','836','172241',3392671,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172241',3392672,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172241',3392673,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172241',3392674,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172241',3392675,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172241',3392676,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172241',3392677,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172241',3392678,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172241',3392679,'2401','364',99815.80,100933.10,1117.30,181002.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','172241',3392680,'2402','364',44758.15,45654.28,896.13,145173.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','172241',3392681,'2403','364',66689.27,67288.68,599.41,97104.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','172241',3392682,'2404','364',49118.39,49766.84,648.45,105048.90,0.00,0.00,0.00,0.00,0.00),('1','157','839','172241',3392683,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172241',3392684,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172241',3392685,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172241',3392686,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172241',3392687,'2409','365',4169.65,4449.15,279.50,58695.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172241',3392688,'2410','365',35541.00,35541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172241',3392689,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172241',3392690,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172439',3396320,'2389','364',54563.97,55420.67,856.70,138785.40,0.00,0.00,0.00,0.00,0.00),('1','157','835','172439',3396321,'2390','364',24341.23,24341.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172439',3396322,'2391','364',38555.25,39860.29,1305.04,211416.48,0.00,0.00,0.00,0.00,0.00),('1','157','835','172439',3396323,'2392','364',48165.51,48875.96,710.45,115092.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','172439',3396324,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172439',3396325,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172439',3396326,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172439',3396327,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172439',3396328,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172439',3396329,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172439',3396330,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172439',3396331,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172439',3396332,'2401','364',100933.10,101836.13,903.03,146290.86,0.00,0.00,0.00,0.00,0.00),('1','157','838','172439',3396333,'2402','364',45654.28,46637.41,983.13,159267.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','172439',3396334,'2403','364',67288.68,67798.68,510.00,82620.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172439',3396335,'2404','364',49766.84,50584.28,817.44,132425.28,0.00,0.00,0.00,0.00,0.00),('1','157','839','172439',3396336,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172439',3396337,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172439',3396338,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172439',3396339,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172439',3396340,'2409','365',4449.15,4521.55,72.40,15204.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172439',3396341,'2410','365',35541.00,35541.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172439',3396342,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172439',3396343,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172447',3396436,'2389','364',55420.67,56173.35,752.68,121934.16,0.00,0.00,0.00,0.00,0.00),('1','157','835','172447',3396437,'2390','364',24341.23,24341.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172447',3396438,'2391','364',39860.29,40885.15,1024.86,166027.32,0.00,0.00,0.00,0.00,0.00),('1','157','835','172447',3396439,'2392','364',48875.96,49685.85,809.89,131202.18,0.00,0.00,0.00,0.00,0.00),('1','157','836','172447',3396440,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172447',3396441,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172447',3396442,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172447',3396443,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172447',3396444,'2397','364',86366.48,86366.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172447',3396445,'2398','364',113036.62,113036.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172447',3396446,'2399','364',83440.05,83440.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172447',3396447,'2400','364',73459.20,73459.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172447',3396448,'2401','364',101836.13,102892.54,1056.41,171138.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','172447',3396449,'2402','364',46637.41,47451.86,814.45,131940.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','172447',3396450,'2403','364',67798.68,68391.22,592.54,95991.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','172447',3396451,'2404','364',50584.28,51257.42,673.14,109048.68,0.00,0.00,0.00,0.00,0.00),('1','157','839','172447',3396452,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172447',3396453,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172447',3396454,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172447',3396455,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172447',3396456,'2409','365',4521.55,4717.38,195.83,42103.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','172447',3396457,'2410','365',35541.00,35792.78,251.78,54132.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','172447',3396458,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172447',3396459,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172608',3399265,'2389','364',56173.35,56814.23,640.88,103822.56,0.00,0.00,0.00,0.00,0.00),('1','157','835','172608',3399266,'2390','364',24341.23,24341.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172608',3399267,'2391','364',40885.15,40885.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172608',3399268,'2392','364',49685.85,50546.09,860.24,139358.88,0.00,0.00,0.00,0.00,0.00),('1','157','836','172608',3399269,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172608',3399270,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172608',3399271,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172608',3399272,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172608',3399273,'2397','364',86366.48,87880.92,1504.44,243719.28,0.00,0.00,10.00,0.00,0.00),('1','157','837','172608',3399274,'2398','364',113036.62,114485.40,1438.78,233082.36,0.00,0.00,10.00,0.00,0.00),('1','157','837','172608',3399275,'2399','364',83440.05,84230.01,779.96,126353.52,0.00,0.00,10.00,0.00,0.00),('1','157','837','172608',3399276,'2400','364',73459.20,73469.42,0.00,0.00,0.00,0.00,10.22,0.00,0.00),('1','157','838','172608',3399277,'2401','364',102892.54,103615.99,723.45,117198.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','172608',3399278,'2402','364',47451.86,47451.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172608',3399279,'2403','364',68391.22,68884.17,492.95,79857.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','172608',3399280,'2404','364',51257.42,51257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172608',3399281,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172608',3399282,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172608',3399283,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172608',3399284,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172608',3399285,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172608',3399286,'2410','365',35792.78,35949.62,156.84,33720.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','172608',3399287,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172608',3399288,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172655',3400209,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172655',3400210,'2390','364',24341.23,24541.94,200.71,32515.02,0.00,0.00,0.00,0.00,0.00),('1','157','835','172655',3400211,'2391','364',40885.15,41290.47,405.32,65661.84,0.00,0.00,0.00,0.00,0.00),('1','157','835','172655',3400212,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172655',3400213,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172655',3400214,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172655',3400215,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172655',3400216,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172655',3400217,'2397','364',87880.92,88586.03,695.11,112607.82,0.00,0.00,10.00,0.00,0.00),('1','157','837','172655',3400218,'2398','364',114485.40,115972.31,1476.91,239259.42,0.00,0.00,10.00,0.00,0.00),('1','157','837','172655',3400219,'2399','364',84230.01,85028.48,788.47,127732.14,0.00,0.00,10.00,0.00,0.00),('1','157','837','172655',3400220,'2400','364',73469.42,74219.77,740.35,119936.70,0.00,0.00,10.00,0.00,0.00),('1','157','838','172655',3400221,'2401','364',103615.99,104396.25,770.26,124782.12,0.00,0.00,10.00,0.00,0.00),('1','157','838','172655',3400222,'2402','364',47451.86,47461.86,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','838','172655',3400223,'2403','364',68884.17,69317.88,423.71,68641.02,0.00,0.00,10.00,0.00,0.00),('1','157','838','172655',3400224,'2404','364',51257.42,51864.51,597.09,96728.58,0.00,0.00,10.00,0.00,0.00),('1','157','839','172655',3400225,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172655',3400226,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172655',3400227,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172655',3400228,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172655',3400229,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172655',3400230,'2410','365',35949.62,36147.77,198.15,42602.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','172655',3400231,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172655',3400232,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172848',3403753,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172848',3403754,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172848',3403755,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','172848',3403756,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172848',3403757,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172848',3403758,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172848',3403759,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','172848',3403760,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','172848',3403761,'2397','364',88586.03,89849.80,1263.77,204730.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','172848',3403762,'2398','364',115972.31,117436.57,1464.26,237210.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','172848',3403763,'2399','364',85028.48,85886.76,858.28,139041.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','172848',3403764,'2400','364',74219.77,74219.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','172848',3403765,'2401','364',104396.25,104777.45,381.20,61754.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','172848',3403766,'2402','364',47461.86,47995.84,533.98,86504.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','172848',3403767,'2403','364',69317.88,70407.54,1089.66,176524.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','172848',3403768,'2404','364',51864.51,52112.05,247.54,40101.48,0.00,0.00,0.00,0.00,0.00),('1','157','839','172848',3403769,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172848',3403770,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172848',3403771,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','172848',3403772,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172848',3403773,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172848',3403774,'2410','365',36147.77,36311.27,163.50,35152.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','172848',3403775,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','172848',3403776,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173012',3406752,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173012',3406753,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173012',3406754,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173012',3406755,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173012',3406756,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173012',3406757,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173012',3406758,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173012',3406759,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173012',3406760,'2397','364',89849.80,90613.85,764.05,123776.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','173012',3406761,'2398','364',117436.57,118896.10,1459.53,236443.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','173012',3406762,'2399','364',85886.76,87434.50,1547.74,250733.88,0.00,0.00,0.00,0.00,0.00),('1','157','837','173012',3406763,'2400','364',74219.77,75011.11,791.34,128197.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','173012',3406764,'2401','364',104777.45,105442.92,665.47,107806.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','173012',3406765,'2402','364',47995.84,48810.37,814.53,131953.86,0.00,0.00,0.00,0.00,0.00),('1','157','838','173012',3406766,'2403','364',70407.54,70900.86,493.32,79917.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','173012',3406767,'2404','364',52112.05,52112.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173012',3406768,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173012',3406769,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173012',3406770,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173012',3406771,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173012',3406772,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173012',3406773,'2410','365',36311.27,36406.58,95.31,20491.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','173012',3406774,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173012',3406775,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173021',3406978,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173021',3406979,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173021',3406980,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173021',3406981,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173021',3406982,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173021',3406983,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173021',3406984,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173021',3406985,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173021',3406986,'2397','364',90613.85,91375.72,761.87,123422.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','173021',3406987,'2398','364',118896.10,120381.61,1485.51,240652.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','173021',3406988,'2399','364',87434.50,88088.48,653.98,105944.76,0.00,0.00,0.00,0.00,0.00),('1','157','837','173021',3406989,'2400','364',75011.11,75993.85,982.74,159203.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','173021',3406990,'2401','364',105442.92,106061.21,618.29,100162.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','173021',3406991,'2402','364',48810.37,49155.94,345.57,55982.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','173021',3406992,'2403','364',70900.86,71369.35,468.49,75895.38,0.00,0.00,0.00,0.00,0.00),('1','157','838','173021',3406993,'2404','364',52112.05,52596.05,484.00,78408.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173021',3406994,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173021',3406995,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173021',3406996,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173021',3406997,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173021',3406998,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173021',3406999,'2410','365',36406.58,36634.83,228.25,49073.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','173021',3407000,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173021',3407001,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173113',3408767,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173113',3408768,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173113',3408769,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173113',3408770,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173113',3408771,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173113',3408772,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173113',3408773,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173113',3408774,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173113',3408775,'2397','364',91375.72,92988.34,1612.62,261244.44,0.00,0.00,0.00,0.00,0.00),('1','157','837','173113',3408776,'2398','364',120381.61,121405.85,1014.24,164306.88,0.00,0.00,10.00,0.00,0.00),('1','157','837','173113',3408777,'2399','364',88088.48,89602.19,1513.71,245221.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','173113',3408778,'2400','364',75993.85,77137.62,1143.77,185290.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','173113',3408779,'2401','364',106061.21,106573.52,502.31,81374.22,0.00,0.00,10.00,0.00,0.00),('1','157','838','173113',3408780,'2402','364',49155.94,49155.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173113',3408781,'2403','364',71369.35,71369.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173113',3408782,'2404','364',52596.05,53282.45,686.40,111196.80,0.00,0.00,0.00,0.00,0.00),('1','157','839','173113',3408783,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173113',3408784,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173113',3408785,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173113',3408786,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173113',3408787,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173113',3408788,'2410','365',36634.83,36779.38,144.55,31801.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173113',3408789,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173113',3408790,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173116',3408829,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173116',3408830,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173116',3408831,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173116',3408832,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173116',3408833,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173116',3408834,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173116',3408835,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173116',3408836,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173116',3408837,'2397','364',92988.34,94129.07,1140.73,184798.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','173116',3408838,'2398','364',121405.85,122855.18,1449.33,234791.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','173116',3408839,'2399','364',89602.19,90099.50,497.31,80564.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','173116',3408840,'2400','364',77137.62,78013.63,876.01,141913.62,0.00,0.00,0.00,0.00,0.00),('1','157','838','173116',3408841,'2401','364',106573.52,107022.79,449.27,72781.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','173116',3408842,'2402','364',49155.94,49614.50,458.56,74286.72,0.00,0.00,0.00,0.00,0.00),('1','157','838','173116',3408843,'2403','364',71369.35,72090.73,721.38,116863.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','173116',3408844,'2404','364',53282.45,54265.97,983.52,159330.24,0.00,0.00,0.00,0.00,0.00),('1','157','839','173116',3408845,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173116',3408846,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173116',3408847,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173116',3408848,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173116',3408849,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173116',3408850,'2410','365',36779.38,36935.35,155.97,34313.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','173116',3408851,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173116',3408852,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173196',3410607,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173196',3410608,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173196',3410609,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173196',3410610,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173196',3410611,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173196',3410612,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173196',3410613,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173196',3410614,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173196',3410615,'2397','364',94129.07,95932.55,1793.48,290543.76,0.00,0.00,10.00,0.00,0.00),('1','157','837','173196',3410616,'2398','364',122855.18,124200.20,1335.02,216273.24,0.00,0.00,10.00,0.00,0.00),('1','157','837','173196',3410617,'2399','364',90099.50,91175.36,1065.86,172669.32,0.00,0.00,10.00,0.00,0.00),('1','157','837','173196',3410618,'2400','364',78013.63,78935.06,911.43,147651.66,0.00,0.00,10.00,0.00,0.00),('1','157','838','173196',3410619,'2401','364',107022.79,107573.10,530.31,85910.22,0.00,0.00,20.00,0.00,0.00),('1','157','838','173196',3410620,'2402','364',49614.50,49624.50,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','838','173196',3410621,'2403','364',72090.73,72090.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173196',3410622,'2404','364',54265.97,55494.51,1218.54,197403.48,0.00,0.00,10.00,0.00,0.00),('1','157','839','173196',3410623,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173196',3410624,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173196',3410625,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173196',3410626,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173196',3410627,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173196',3410628,'2410','365',36935.35,37108.95,173.60,38192.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173196',3410629,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173196',3410630,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173279',3411913,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173279',3411914,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173279',3411915,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173279',3411916,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173279',3411917,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173279',3411918,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173279',3411919,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173279',3411920,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173279',3411921,'2397','364',95932.55,96931.76,999.21,161872.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','173279',3411922,'2398','364',124200.20,125051.76,851.56,137952.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','173279',3411923,'2399','364',91175.36,91965.19,789.83,127952.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','173279',3411924,'2400','364',78935.06,79539.02,603.96,97841.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','173279',3411925,'2401','364',107573.10,108216.87,643.77,104290.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','173279',3411926,'2402','364',49624.50,50134.74,510.24,82658.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','173279',3411927,'2403','364',72090.73,72092.58,0.00,0.00,0.00,0.00,1.85,0.00,0.00),('1','157','838','173279',3411928,'2404','364',55494.51,56560.33,1065.82,172662.84,0.00,0.00,0.00,0.00,0.00),('1','157','839','173279',3411929,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173279',3411930,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173279',3411931,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173279',3411932,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173279',3411933,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173279',3411934,'2410','365',37108.95,37209.40,100.45,22099.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173279',3411935,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173279',3411936,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173319',3412748,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173319',3412749,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173319',3412750,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173319',3412751,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173319',3412752,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173319',3412753,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173319',3412754,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173319',3412755,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173319',3412756,'2397','364',96931.76,97466.25,514.49,83347.38,0.00,0.00,20.00,0.00,0.00),('1','157','837','173319',3412757,'2398','364',125051.76,126129.39,1037.63,168096.06,0.00,0.00,40.00,0.00,0.00),('1','157','837','173319',3412758,'2399','364',91965.19,92509.08,523.89,84870.18,0.00,0.00,20.00,0.00,0.00),('1','157','837','173319',3412759,'2400','364',79539.02,80122.34,563.32,91257.84,0.00,0.00,20.00,0.00,0.00),('1','157','838','173319',3412760,'2401','364',108216.87,108775.02,538.15,87180.30,0.00,0.00,20.00,0.00,0.00),('1','157','838','173319',3412761,'2402','364',50134.74,51091.72,936.98,151790.76,0.00,0.00,20.00,0.00,0.00),('1','157','838','173319',3412762,'2403','364',72092.58,72102.58,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','157','838','173319',3412763,'2404','364',56560.33,57096.16,515.83,83564.46,0.00,0.00,20.00,0.00,0.00),('1','157','839','173319',3412764,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173319',3412765,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173319',3412766,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173319',3412767,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173319',3412768,'2409','365',4717.38,4717.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173319',3412769,'2410','365',37209.40,37416.57,207.17,45577.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','173319',3412770,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173319',3412771,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173530',3416607,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173530',3416608,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173530',3416609,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173530',3416610,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173530',3416611,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173530',3416612,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173530',3416613,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173530',3416614,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173530',3416615,'2397','364',97466.25,97466.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173530',3416616,'2398','364',126129.39,126129.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173530',3416617,'2399','364',92509.08,92509.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173530',3416618,'2400','364',80122.34,80122.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173530',3416619,'2401','364',108775.02,110535.28,1760.26,285162.12,0.00,0.00,0.00,0.00,0.00),('1','157','838','173530',3416620,'2402','364',51091.72,52613.62,1521.90,246547.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','173530',3416621,'2403','364',72102.58,73332.93,1230.35,199316.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','173530',3416622,'2404','364',57096.16,58645.94,1549.78,251064.36,0.00,0.00,0.00,0.00,0.00),('1','157','839','173530',3416623,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173530',3416624,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173530',3416625,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173530',3416626,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173530',3416627,'2409','365',4717.38,4787.55,70.17,15437.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','173530',3416628,'2410','365',37416.57,38270.93,854.36,187959.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','173530',3416629,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173530',3416630,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173533',3416689,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173533',3416690,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173533',3416691,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173533',3416692,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173533',3416693,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173533',3416694,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173533',3416695,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173533',3416696,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173533',3416697,'2397','364',97466.25,97466.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173533',3416698,'2398','364',126129.39,126129.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173533',3416699,'2399','364',92509.08,92509.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173533',3416700,'2400','364',80122.34,80122.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173533',3416701,'2401','364',110535.28,112725.99,2190.71,354895.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','173533',3416702,'2402','364',52613.62,53512.73,899.11,145655.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','173533',3416703,'2403','364',73332.93,75136.90,1803.97,292243.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','173533',3416704,'2404','364',58645.94,60090.41,1444.47,234004.14,0.00,0.00,0.00,0.00,0.00),('1','157','839','173533',3416705,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173533',3416706,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173533',3416707,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173533',3416708,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173533',3416709,'2409','365',4787.55,4820.74,0.00,0.00,0.00,0.00,33.19,0.00,0.00),('1','157','840','173533',3416710,'2410','365',38270.93,39524.70,1193.77,262629.40,0.00,0.00,60.00,0.00,0.00),('1','157','840','173533',3416711,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173533',3416712,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173758',3420715,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173758',3420716,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173758',3420717,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173758',3420718,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173758',3420719,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173758',3420720,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173758',3420721,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173758',3420722,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173758',3420723,'2397','364',97466.25,98282.39,816.14,132214.68,0.00,0.00,0.00,0.00,0.00),('1','157','837','173758',3420724,'2398','364',126129.39,127107.80,978.41,158502.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','173758',3420725,'2399','364',92509.08,93337.16,828.08,134148.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','173758',3420726,'2400','364',80122.34,81080.59,958.25,155236.50,0.00,0.00,0.00,0.00,0.00),('1','157','838','173758',3420727,'2401','364',112725.99,113402.93,676.94,109664.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','173758',3420728,'2402','364',53512.73,54023.35,510.62,82720.44,0.00,0.00,0.00,0.00,0.00),('1','157','838','173758',3420729,'2403','364',75136.90,75835.84,698.94,113228.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','173758',3420730,'2404','364',60090.41,61079.37,988.96,160211.52,0.00,0.00,0.00,0.00,0.00),('1','157','839','173758',3420731,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173758',3420732,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173758',3420733,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173758',3420734,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173758',3420735,'2409','365',4820.74,5254.71,433.97,95473.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','173758',3420736,'2410','365',39524.70,39545.15,20.45,4499.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173758',3420737,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173758',3420738,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173760',3420741,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173760',3420742,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173760',3420743,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173760',3420744,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173760',3420745,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173760',3420746,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173760',3420747,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173760',3420748,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173760',3420749,'2397','364',98282.39,99341.92,1059.53,171643.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','173760',3420750,'2398','364',127107.80,128565.82,1458.02,236199.24,0.00,0.00,0.00,0.00,0.00),('1','157','837','173760',3420751,'2399','364',93337.16,94312.86,975.70,158063.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','173760',3420752,'2400','364',81080.59,81937.85,847.26,137256.12,0.00,0.00,10.00,0.00,0.00),('1','157','838','173760',3420753,'2401','364',113402.93,114635.60,1232.67,199692.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','173760',3420754,'2402','364',54023.35,54651.15,627.80,101703.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','173760',3420755,'2403','364',75835.84,76968.63,1132.79,183511.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','173760',3420756,'2404','364',61079.37,61079.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173760',3420757,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173760',3420758,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173760',3420759,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173760',3420760,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173760',3420761,'2409','365',5254.71,5816.96,562.25,123695.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173760',3420762,'2410','365',39545.15,39545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173760',3420763,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173760',3420764,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173890',3423230,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173890',3423231,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173890',3423232,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173890',3423233,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173890',3423234,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173890',3423235,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173890',3423236,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173890',3423237,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173890',3423238,'2397','364',99341.92,100303.19,961.27,155725.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','173890',3423239,'2398','364',128565.82,129874.82,1309.00,212058.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173890',3423240,'2399','364',94312.86,95575.45,1262.59,204539.58,0.00,0.00,0.00,0.00,0.00),('1','157','837','173890',3423241,'2400','364',81937.85,82782.57,844.72,136844.64,0.00,0.00,0.00,0.00,0.00),('1','157','838','173890',3423242,'2401','364',114635.60,115757.68,1122.08,181776.96,0.00,0.00,0.00,0.00,0.00),('1','157','838','173890',3423243,'2402','364',54651.15,54923.05,271.90,44047.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','173890',3423244,'2403','364',76968.63,77506.49,537.86,87133.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','173890',3423245,'2404','364',61079.37,61079.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173890',3423246,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173890',3423247,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173890',3423248,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173890',3423249,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173890',3423250,'2409','365',5816.96,5816.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173890',3423251,'2410','365',39545.15,40393.59,848.44,186656.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','173890',3423252,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173890',3423253,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173956',3424290,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173956',3424291,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173956',3424292,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173956',3424293,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173956',3424294,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173956',3424295,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173956',3424296,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173956',3424297,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173956',3424298,'2397','364',100303.19,101519.12,1215.93,196980.66,0.00,0.00,0.00,0.00,0.00),('1','157','837','173956',3424299,'2398','364',129874.82,131936.89,2062.07,334055.34,0.00,0.00,0.00,0.00,0.00),('1','157','837','173956',3424300,'2399','364',95575.45,96295.94,720.49,116719.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','173956',3424301,'2400','364',82782.57,84085.45,1302.88,211066.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','173956',3424302,'2401','364',115757.68,116039.88,282.20,45716.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','173956',3424303,'2402','364',54923.05,55147.16,224.11,36305.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','173956',3424304,'2403','364',77506.49,77506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173956',3424305,'2404','364',61079.37,61474.49,385.12,62389.44,0.00,0.00,10.00,0.00,0.00),('1','157','839','173956',3424306,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173956',3424307,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173956',3424308,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173956',3424309,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173956',3424310,'2409','365',5816.96,5816.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173956',3424311,'2410','365',40393.59,40771.92,378.33,83232.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','173956',3424312,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173956',3424313,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173957',3424314,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173957',3424315,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173957',3424316,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','173957',3424317,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173957',3424318,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173957',3424319,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173957',3424320,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','173957',3424321,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','173957',3424322,'2397','364',101519.12,102111.70,592.58,95997.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','173957',3424323,'2398','364',131936.89,132611.20,674.31,109238.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','173957',3424324,'2399','364',96295.94,96932.88,636.94,103184.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','173957',3424325,'2400','364',84085.45,84570.86,485.41,78636.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','173957',3424326,'2401','364',116039.88,116039.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173957',3424327,'2402','364',55147.16,55147.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173957',3424328,'2403','364',77506.49,77506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','173957',3424329,'2404','364',61474.49,61474.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173957',3424330,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173957',3424331,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173957',3424332,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','173957',3424333,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173957',3424334,'2409','365',5816.96,5816.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173957',3424335,'2410','365',40771.92,40966.57,194.65,42823.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173957',3424336,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','173957',3424337,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174125',3427305,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174125',3427306,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174125',3427307,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174125',3427308,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174125',3427309,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174125',3427310,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174125',3427311,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174125',3427312,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174125',3427313,'2397','364',102111.70,102111.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174125',3427314,'2398','364',132611.20,132611.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174125',3427315,'2399','364',96932.88,96932.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174125',3427316,'2400','364',84570.86,84570.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174125',3427317,'2401','364',116039.88,116039.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174125',3427318,'2402','364',55147.16,55147.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174125',3427319,'2403','364',77506.49,77506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174125',3427320,'2404','364',61474.49,61474.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174125',3427321,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174125',3427322,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174125',3427323,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174125',3427324,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174125',3427325,'2409','365',5816.96,6027.63,210.67,46347.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','174125',3427326,'2410','365',40966.57,40966.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174125',3427327,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174125',3427328,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174286',3430322,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174286',3430323,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174286',3430324,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174286',3430325,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174286',3430326,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174286',3430327,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174286',3430328,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174286',3430329,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174286',3430330,'2397','364',102111.70,103321.12,1209.42,195926.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','174286',3430331,'2398','364',132611.20,134172.68,1556.48,252149.76,0.00,0.00,5.00,0.00,0.00),('1','157','837','174286',3430332,'2399','364',96932.88,98054.91,1122.03,181768.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','174286',3430333,'2400','364',84570.86,85917.31,1346.45,218124.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','174286',3430334,'2401','364',116039.88,116265.13,225.25,36490.50,0.00,0.00,0.00,0.00,0.00),('1','157','838','174286',3430335,'2402','364',55147.16,55595.71,448.55,72665.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','174286',3430336,'2403','364',77506.49,77506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174286',3430337,'2404','364',61474.49,62357.47,882.98,143042.76,0.00,0.00,0.00,0.00,0.00),('1','157','839','174286',3430338,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174286',3430339,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174286',3430340,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174286',3430341,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174286',3430342,'2409','365',6027.63,6027.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174286',3430343,'2410','365',40966.57,41295.40,328.83,72342.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','174286',3430344,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174286',3430345,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174290',3430399,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174290',3430400,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174290',3430401,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174290',3430402,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174290',3430403,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174290',3430404,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174290',3430405,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174290',3430406,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174290',3430407,'2397','364',103321.12,104412.68,1091.56,176832.72,0.00,0.00,0.00,0.00,0.00),('1','157','837','174290',3430408,'2398','364',134172.68,135531.49,1358.81,220127.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','174290',3430409,'2399','364',98054.91,98639.73,584.82,94740.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','174290',3430410,'2400','364',85917.31,86746.61,829.30,134346.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','174290',3430411,'2401','364',116265.13,117457.56,1192.43,193173.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','174290',3430412,'2402','364',55595.71,56177.12,581.41,94188.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','174290',3430413,'2403','364',77506.49,78384.67,878.18,142265.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','174290',3430414,'2404','364',62357.47,62357.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174290',3430415,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174290',3430416,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174290',3430417,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174290',3430418,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174290',3430419,'2409','365',6027.63,6027.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174290',3430420,'2410','365',41295.40,41463.58,168.18,36999.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','174290',3430421,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174290',3430422,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174457',3433103,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174457',3433104,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174457',3433105,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174457',3433106,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174457',3433107,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174457',3433108,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174457',3433109,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174457',3433110,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174457',3433111,'2397','364',104412.68,105272.63,849.95,137691.90,0.00,0.00,10.00,0.00,0.00),('1','157','837','174457',3433112,'2398','364',135531.49,136787.92,1246.43,201921.66,0.00,0.00,10.00,0.00,0.00),('1','157','837','174457',3433113,'2399','364',98639.73,99451.62,801.89,129906.18,0.00,0.00,10.00,0.00,0.00),('1','157','837','174457',3433114,'2400','364',86746.61,88091.10,1334.49,216187.38,0.00,0.00,10.00,0.00,0.00),('1','157','838','174457',3433115,'2401','364',117457.56,118369.82,902.26,146166.12,0.00,0.00,10.00,0.00,0.00),('1','157','838','174457',3433116,'2402','364',56177.12,56177.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174457',3433117,'2403','364',78384.67,78384.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174457',3433118,'2404','364',62357.47,63117.09,749.62,121438.44,0.00,0.00,10.00,0.00,0.00),('1','157','839','174457',3433119,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174457',3433120,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174457',3433121,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174457',3433122,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174457',3433123,'2409','365',6027.63,6393.53,355.90,78298.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','174457',3433124,'2410','365',41463.58,41474.94,0.00,0.00,0.00,0.00,11.36,0.00,0.00),('1','157','840','174457',3433125,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174457',3433126,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174458',3433127,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174458',3433128,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174458',3433129,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174458',3433130,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174458',3433131,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174458',3433132,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174458',3433133,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174458',3433134,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174458',3433135,'2397','364',105272.63,106203.66,931.03,150826.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','174458',3433136,'2398','364',136787.92,138045.83,1257.91,203781.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','174458',3433137,'2399','364',99451.62,100223.38,771.76,125025.12,0.00,0.00,0.00,0.00,0.00),('1','157','837','174458',3433138,'2400','364',88091.10,88923.92,832.82,134916.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','174458',3433139,'2401','364',118369.82,119372.68,1002.86,162463.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','174458',3433140,'2402','364',56177.12,56706.52,529.40,85762.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','174458',3433141,'2403','364',78384.67,78384.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174458',3433142,'2404','364',63117.09,63656.13,539.04,87324.48,0.00,0.00,0.00,0.00,0.00),('1','157','839','174458',3433143,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174458',3433144,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174458',3433145,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174458',3433146,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174458',3433147,'2409','365',6393.53,6560.46,166.93,36724.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','174458',3433148,'2410','365',41474.94,41478.53,0.00,0.00,0.00,0.00,3.59,0.00,0.00),('1','157','840','174458',3433149,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174458',3433150,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174522',3434249,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174522',3434250,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174522',3434251,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174522',3434252,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174522',3434253,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174522',3434254,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174522',3434255,'2395','364',72050.81,72050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174522',3434256,'2396','364',111371.92,111371.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','174522',3434257,'2397','364',106203.66,107408.34,1204.68,195158.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','174522',3434258,'2398','364',138045.83,139312.02,1266.19,205122.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','174522',3434259,'2399','364',100223.38,100273.60,50.22,8135.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','174522',3434260,'2400','364',88923.92,90004.91,1080.99,175120.38,0.00,0.00,0.00,0.00,0.00),('1','157','838','174522',3434261,'2401','364',119372.68,120070.36,697.68,113024.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','174522',3434262,'2402','364',56706.52,56706.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174522',3434263,'2403','364',78384.67,78384.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174522',3434264,'2404','364',63656.13,64740.17,1084.04,175614.48,0.00,0.00,0.00,0.00,0.00),('1','157','839','174522',3434265,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174522',3434266,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174522',3434267,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174522',3434268,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174522',3434269,'2409','365',6560.46,7550.25,989.79,217753.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','174522',3434270,'2410','365',41478.53,41516.60,38.07,8375.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','174522',3434271,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174522',3434272,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174592',3435605,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174592',3435606,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174592',3435607,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174592',3435608,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174592',3435609,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174592',3435610,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174592',3435611,'2395','364',72050.81,72463.38,402.57,65216.34,0.00,0.00,10.00,0.00,0.00),('1','157','836','174592',3435612,'2396','364',111371.92,111626.65,244.73,39646.26,0.00,0.00,10.00,0.00,0.00),('1','157','837','174592',3435613,'2397','364',107408.34,107444.76,36.42,5900.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','174592',3435614,'2398','364',139312.02,141049.86,1737.84,281530.08,0.00,0.00,0.00,0.00,0.00),('1','157','837','174592',3435615,'2399','364',100273.60,100585.07,311.47,50458.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','174592',3435616,'2400','364',90004.91,90741.26,736.35,119288.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','174592',3435617,'2401','364',120070.36,120820.06,749.70,121451.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','174592',3435618,'2402','364',56706.52,57301.26,594.74,96347.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','174592',3435619,'2403','364',78384.67,79037.69,653.02,105789.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','174592',3435620,'2404','364',64740.17,64740.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174592',3435621,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174592',3435622,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174592',3435623,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174592',3435624,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174592',3435625,'2409','365',7550.25,7550.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174592',3435626,'2410','365',41516.60,41618.42,101.82,22400.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','174592',3435627,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174592',3435628,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174830',3439917,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174830',3439918,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174830',3439919,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174830',3439920,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174830',3439921,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174830',3439922,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174830',3439923,'2395','364',72463.38,72463.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174830',3439924,'2396','364',111626.65,112456.34,809.69,131169.78,0.00,0.00,20.00,0.00,0.00),('1','157','837','174830',3439925,'2397','364',107444.76,108710.13,1255.37,203369.94,0.00,0.00,10.00,0.00,0.00),('1','157','837','174830',3439926,'2398','364',141049.86,142077.65,1017.79,164881.98,0.00,0.00,10.00,0.00,0.00),('1','157','837','174830',3439927,'2399','364',100585.07,101224.52,629.45,101970.90,0.00,0.00,10.00,0.00,0.00),('1','157','837','174830',3439928,'2400','364',90741.26,91552.88,801.62,129862.44,0.00,0.00,10.00,0.00,0.00),('1','157','838','174830',3439929,'2401','364',120820.06,121480.94,650.88,105442.56,0.00,0.00,10.00,0.00,0.00),('1','157','838','174830',3439930,'2402','364',57301.26,57301.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174830',3439931,'2403','364',79037.69,79037.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174830',3439932,'2404','364',64740.17,65559.32,809.15,131082.30,0.00,0.00,10.00,0.00,0.00),('1','157','839','174830',3439933,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174830',3439934,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174830',3439935,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174830',3439936,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174830',3439937,'2409','365',7550.25,7600.25,40.00,8800.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','174830',3439938,'2410','365',41618.42,41831.92,203.50,44770.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','174830',3439939,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174830',3439940,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174831',3439941,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174831',3439942,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174831',3439943,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','174831',3439944,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174831',3439945,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174831',3439946,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','174831',3439947,'2395','364',72463.38,73227.74,764.36,123826.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','174831',3439948,'2396','364',112456.34,113649.37,1193.03,193270.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','174831',3439949,'2397','364',108710.13,110182.12,1471.99,238462.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','174831',3439950,'2398','364',142077.65,142735.97,658.32,106647.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','174831',3439951,'2399','364',101224.52,102312.40,1087.88,176236.56,0.00,0.00,0.00,0.00,0.00),('1','157','837','174831',3439952,'2400','364',91552.88,92133.08,580.20,93992.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','174831',3439953,'2401','364',121480.94,121950.00,469.06,75987.72,0.00,0.00,0.00,0.00,0.00),('1','157','838','174831',3439954,'2402','364',57301.26,57301.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','174831',3439955,'2403','364',79037.69,79518.42,480.73,77878.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','174831',3439956,'2404','364',65559.32,65559.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174831',3439957,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174831',3439958,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174831',3439959,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','174831',3439960,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174831',3439961,'2409','365',7600.25,7600.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174831',3439962,'2410','365',41831.92,42101.11,269.19,59221.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','174831',3439963,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','174831',3439964,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175024',3443759,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175024',3443760,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175024',3443761,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175024',3443762,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175024',3443763,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175024',3443764,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175024',3443765,'2395','364',73227.74,74747.72,1519.98,246236.76,0.00,0.00,0.00,0.00,0.00),('1','157','836','175024',3443766,'2396','364',113649.37,114977.19,1327.82,215106.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','175024',3443767,'2397','364',110182.12,110182.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175024',3443768,'2398','364',142735.97,142735.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175024',3443769,'2399','364',102312.40,102312.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175024',3443770,'2400','364',92133.08,92133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175024',3443771,'2401','364',121950.00,122958.63,1008.63,163398.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','175024',3443772,'2402','364',57301.26,58493.00,1191.74,193061.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','175024',3443773,'2403','364',79518.42,80445.99,927.57,150266.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','175024',3443774,'2404','364',65559.32,66517.35,958.03,155200.86,0.00,0.00,0.00,0.00,0.00),('1','157','839','175024',3443775,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175024',3443776,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175024',3443777,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175024',3443778,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175024',3443779,'2409','365',7600.25,7650.25,50.00,11000.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175024',3443780,'2410','365',42101.11,42338.39,237.28,52201.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','175024',3443781,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175024',3443782,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175025',3443783,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175025',3443784,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175025',3443785,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175025',3443786,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175025',3443787,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175025',3443788,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175025',3443789,'2395','364',74747.72,75961.24,1213.52,196590.24,0.00,0.00,0.00,0.00,0.00),('1','157','836','175025',3443790,'2396','364',114977.19,116261.81,1284.62,208108.44,0.00,0.00,0.00,0.00,0.00),('1','157','837','175025',3443791,'2397','364',110182.12,110182.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175025',3443792,'2398','364',142735.97,142735.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175025',3443793,'2399','364',102312.40,102312.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175025',3443794,'2400','364',92133.08,92133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175025',3443795,'2401','364',122958.63,124262.80,1304.17,211275.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','175025',3443796,'2402','364',58493.00,59989.46,1496.46,242426.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','175025',3443797,'2403','364',80445.99,81780.87,1334.88,216250.56,0.00,0.00,0.00,0.00,0.00),('1','157','838','175025',3443798,'2404','364',66517.35,66517.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175025',3443799,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175025',3443800,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175025',3443801,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175025',3443802,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175025',3443803,'2409','365',7650.25,7650.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175025',3443804,'2410','365',42338.39,42922.45,584.06,131413.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','175025',3443805,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175025',3443806,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175198',3446811,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175198',3446812,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175198',3446813,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175198',3446814,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175198',3446815,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175198',3446816,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175198',3446817,'2395','364',75961.24,76733.67,762.43,123513.66,0.00,0.00,10.00,0.00,0.00),('1','157','836','175198',3446818,'2396','364',116261.81,117535.45,1253.64,203089.68,0.00,0.00,20.00,0.00,0.00),('1','157','837','175198',3446819,'2397','364',110182.12,110182.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175198',3446820,'2398','364',142735.97,142735.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175198',3446821,'2399','364',102312.40,102312.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175198',3446822,'2400','364',92133.08,92133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175198',3446823,'2401','364',124262.80,125252.39,969.59,157073.58,0.00,0.00,20.00,0.00,0.00),('1','157','838','175198',3446824,'2402','364',59989.46,60888.48,889.02,144021.24,0.00,0.00,10.00,0.00,0.00),('1','157','838','175198',3446825,'2403','364',81780.87,82700.82,909.95,147411.90,0.00,0.00,10.00,0.00,0.00),('1','157','838','175198',3446826,'2404','364',66517.35,67732.09,1204.74,195167.88,0.00,0.00,10.00,0.00,0.00),('1','157','839','175198',3446827,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175198',3446828,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175198',3446829,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175198',3446830,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175198',3446831,'2409','365',7650.25,7700.25,40.00,9000.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','175198',3446832,'2410','365',42922.45,43539.79,607.34,136651.50,0.00,0.00,10.00,0.00,0.00),('1','157','840','175198',3446833,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175198',3446834,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175202',3446894,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175202',3446895,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175202',3446896,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175202',3446897,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175202',3446898,'2393','364',32074.71,32074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175202',3446899,'2394','364',37659.81,37659.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175202',3446900,'2395','364',76733.67,77623.78,890.11,144197.82,0.00,0.00,0.00,0.00,0.00),('1','157','836','175202',3446901,'2396','364',117535.45,118539.60,1004.15,162672.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','175202',3446902,'2397','364',110182.12,110182.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175202',3446903,'2398','364',142735.97,142735.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175202',3446904,'2399','364',102312.40,102312.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175202',3446905,'2400','364',92133.08,92133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175202',3446906,'2401','364',125252.39,126517.95,1265.56,205020.72,0.00,0.00,0.00,0.00,0.00),('1','157','838','175202',3446907,'2402','364',60888.48,61739.81,851.33,137915.46,0.00,0.00,0.00,0.00,0.00),('1','157','838','175202',3446908,'2403','364',82700.82,83781.84,1081.02,175125.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','175202',3446909,'2404','364',67732.09,68633.84,901.75,146083.50,0.00,0.00,0.00,0.00,0.00),('1','157','839','175202',3446910,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175202',3446911,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175202',3446912,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175202',3446913,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175202',3446914,'2409','365',7700.25,7849.13,148.88,33498.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175202',3446915,'2410','365',43539.79,46007.07,2467.28,555138.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175202',3446916,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175202',3446917,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175383',3450261,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175383',3450262,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175383',3450263,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175383',3450264,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175383',3450265,'2393','364',32074.71,32125.08,10.37,1679.94,0.00,0.00,40.00,0.00,0.00),('1','157','836','175383',3450266,'2394','364',37659.81,37751.70,51.89,8406.18,0.00,0.00,40.00,0.00,0.00),('1','157','836','175383',3450267,'2395','364',77623.78,77654.47,10.69,1731.78,0.00,0.00,20.00,0.00,0.00),('1','157','836','175383',3450268,'2396','364',118539.60,119670.93,1091.33,176795.46,0.00,0.00,40.00,0.00,0.00),('1','157','837','175383',3450269,'2397','364',110182.12,110201.38,9.26,1500.12,0.00,0.00,10.00,0.00,0.00),('1','157','837','175383',3450270,'2398','364',142735.97,144620.05,1844.08,298740.96,0.00,0.00,40.00,0.00,0.00),('1','157','837','175383',3450271,'2399','364',102312.40,102342.40,10.00,1620.00,0.00,0.00,20.00,0.00,0.00),('1','157','837','175383',3450272,'2400','364',92133.08,93394.71,1221.63,197904.06,0.00,0.00,40.00,0.00,0.00),('1','157','838','175383',3450273,'2401','364',126517.95,127523.95,966.00,156492.00,0.00,0.00,40.00,0.00,0.00),('1','157','838','175383',3450274,'2402','364',61739.81,61759.81,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','157','838','175383',3450275,'2403','364',83781.84,83802.74,0.90,145.80,0.00,0.00,20.00,0.00,0.00),('1','157','838','175383',3450276,'2404','364',68633.84,69439.15,765.31,123980.22,0.00,0.00,40.00,0.00,0.00),('1','157','839','175383',3450277,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175383',3450278,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175383',3450279,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175383',3450280,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175383',3450281,'2409','365',7849.13,7989.13,140.00,31500.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175383',3450282,'2410','365',46007.07,47955.11,1948.04,438309.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175383',3450283,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175383',3450284,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175387',3450351,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175387',3450352,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175387',3450353,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175387',3450354,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175387',3450355,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175387',3450356,'2394','364',37751.70,38139.79,388.09,62870.58,0.00,0.00,0.00,0.00,0.00),('1','157','836','175387',3450357,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175387',3450358,'2396','364',119670.93,120423.17,752.24,121862.88,0.00,0.00,0.00,0.00,0.00),('1','157','837','175387',3450359,'2397','364',110201.38,111122.58,921.20,149234.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','175387',3450360,'2398','364',144620.05,145863.08,1243.03,201370.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','175387',3450361,'2399','364',102342.40,102637.48,295.08,47802.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','175387',3450362,'2400','364',93394.71,94509.99,1115.28,180675.36,0.00,0.00,0.00,0.00,0.00),('1','157','838','175387',3450363,'2401','364',127523.95,128423.45,899.50,145719.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175387',3450364,'2402','364',61759.81,62007.62,247.81,40145.22,0.00,0.00,0.00,0.00,0.00),('1','157','838','175387',3450365,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175387',3450366,'2404','364',69439.15,70284.53,845.38,136951.56,0.00,0.00,0.00,0.00,0.00),('1','157','839','175387',3450367,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175387',3450368,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175387',3450369,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175387',3450370,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175387',3450371,'2409','365',7989.13,7989.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175387',3450372,'2410','365',47955.11,48067.56,112.45,25301.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','175387',3450373,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175387',3450374,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175457',3451395,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175457',3451396,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175457',3451397,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175457',3451398,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175457',3451399,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175457',3451400,'2394','364',38139.79,38139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175457',3451401,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175457',3451402,'2396','364',120423.17,120423.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175457',3451403,'2397','364',111122.58,112804.97,1682.39,272547.18,0.00,0.00,0.00,0.00,0.00),('1','157','837','175457',3451404,'2398','364',145863.08,148032.02,2168.94,351368.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','175457',3451405,'2399','364',102637.48,103954.52,1317.04,213360.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','175457',3451406,'2400','364',94509.99,95752.17,1242.18,201233.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','175457',3451407,'2401','364',128423.45,128423.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175457',3451408,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175457',3451409,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175457',3451410,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175457',3451411,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175457',3451412,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175457',3451413,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175457',3451414,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175457',3451415,'2409','365',7989.13,7989.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175457',3451416,'2410','365',48067.56,48690.23,622.67,140100.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','175457',3451417,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175457',3451418,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175555',3453225,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175555',3453226,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175555',3453227,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175555',3453228,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175555',3453229,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175555',3453230,'2394','364',38139.79,38139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175555',3453231,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175555',3453232,'2396','364',120423.17,120423.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175555',3453233,'2397','364',112804.97,114573.34,1768.37,286475.94,0.00,0.00,0.00,0.00,0.00),('1','157','837','175555',3453234,'2398','364',148032.02,148904.55,872.53,141349.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','175555',3453235,'2399','364',103954.52,104796.70,842.18,136433.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','175555',3453236,'2400','364',95752.17,96355.28,603.11,97703.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','175555',3453237,'2401','364',128423.45,128423.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175555',3453238,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175555',3453239,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175555',3453240,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175555',3453241,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175555',3453242,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175555',3453243,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175555',3453244,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175555',3453245,'2409','365',7989.13,8039.13,50.00,11250.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175555',3453246,'2410','365',48690.23,48755.67,65.44,14724.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175555',3453247,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175555',3453248,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175820',3458011,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175820',3458012,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175820',3458013,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175820',3458014,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175820',3458015,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175820',3458016,'2394','364',38139.79,38139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175820',3458017,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175820',3458018,'2396','364',120423.17,120423.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175820',3458019,'2397','364',114573.34,116658.04,2084.70,337721.40,0.00,0.00,0.00,0.00,0.00),('1','157','837','175820',3458020,'2398','364',148904.55,150805.28,1900.73,307918.26,0.00,0.00,0.00,0.00,0.00),('1','157','837','175820',3458021,'2399','364',104796.70,106040.52,1243.82,201498.84,0.00,0.00,0.00,0.00,0.00),('1','157','837','175820',3458022,'2400','364',96355.28,97807.32,1452.04,235230.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','175820',3458023,'2401','364',128423.45,128423.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175820',3458024,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175820',3458025,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175820',3458026,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175820',3458027,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175820',3458028,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175820',3458029,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175820',3458030,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175820',3458031,'2409','365',8039.13,8050.24,11.11,2499.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','175820',3458032,'2410','365',48755.67,49738.30,982.63,221091.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','175820',3458033,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175820',3458034,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175822',3458058,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175822',3458059,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175822',3458060,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175822',3458061,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175822',3458062,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175822',3458063,'2394','364',38139.79,38139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175822',3458064,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175822',3458065,'2396','364',120423.17,120423.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175822',3458066,'2397','364',116658.04,118397.01,1738.97,281713.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','175822',3458067,'2398','364',150805.28,152347.19,1541.91,249789.42,0.00,0.00,0.00,0.00,0.00),('1','157','837','175822',3458068,'2399','364',106040.52,107341.35,1300.83,210734.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','175822',3458069,'2400','364',97807.32,98825.90,1018.58,165009.96,0.00,0.00,0.00,0.00,0.00),('1','157','838','175822',3458070,'2401','364',128423.45,128423.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175822',3458071,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175822',3458072,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175822',3458073,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175822',3458074,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175822',3458075,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175822',3458076,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175822',3458077,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175822',3458078,'2409','365',8050.24,8109.79,59.55,13398.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','175822',3458079,'2410','365',49738.30,51794.91,2056.61,462737.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','175822',3458080,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175822',3458081,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175825',3458100,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175825',3458101,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175825',3458102,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175825',3458103,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175825',3458104,'2393','364',32125.08,32125.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175825',3458105,'2394','364',38139.79,38139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175825',3458106,'2395','364',77654.47,77654.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175825',3458107,'2396','364',120423.17,120423.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175825',3458108,'2397','364',118397.01,120147.72,1750.71,283615.02,0.00,0.00,0.00,0.00,0.00),('1','157','837','175825',3458109,'2398','364',152347.19,153978.04,1630.85,264197.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','175825',3458110,'2399','364',107341.35,108858.71,1517.36,245812.32,0.00,0.00,0.00,0.00,0.00),('1','157','837','175825',3458111,'2400','364',98825.90,99766.96,941.06,152451.72,0.00,0.00,0.00,0.00,0.00),('1','157','838','175825',3458112,'2401','364',128423.45,128423.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175825',3458113,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175825',3458114,'2403','364',83802.74,83802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175825',3458115,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175825',3458116,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175825',3458117,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175825',3458118,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175825',3458119,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175825',3458120,'2409','365',8109.79,8159.79,50.00,11250.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175825',3458121,'2410','365',51794.91,52476.01,681.10,153247.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','175825',3458122,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175825',3458123,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175868',3458958,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175868',3458959,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175868',3458960,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175868',3458961,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175868',3458962,'2393','364',32125.08,32547.74,422.66,68470.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','175868',3458963,'2394','364',38139.79,38445.63,305.84,49546.08,0.00,0.00,0.00,0.00,0.00),('1','157','836','175868',3458964,'2395','364',77654.47,77900.19,245.72,39806.64,0.00,0.00,0.00,0.00,0.00),('1','157','836','175868',3458965,'2396','364',120423.17,120676.57,253.40,41050.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','175868',3458966,'2397','364',120147.72,121254.47,1106.75,179293.50,0.00,0.00,0.00,0.00,0.00),('1','157','837','175868',3458967,'2398','364',153978.04,154955.08,977.04,158280.48,0.00,0.00,0.00,0.00,0.00),('1','157','837','175868',3458968,'2399','364',108858.71,109852.63,993.92,161015.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','175868',3458969,'2400','364',99766.96,100319.96,553.00,89586.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175868',3458970,'2401','364',128423.45,128889.82,466.37,75551.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','175868',3458971,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175868',3458972,'2403','364',83802.74,83948.85,146.11,23669.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','175868',3458973,'2404','364',70284.53,70284.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175868',3458974,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175868',3458975,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175868',3458976,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175868',3458977,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175868',3458978,'2409','365',8159.79,8226.45,66.66,14998.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','175868',3458979,'2410','365',52476.01,53526.87,1050.86,236443.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','175868',3458980,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175868',3458981,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175927',3459932,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175927',3459933,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175927',3459934,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','175927',3459935,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','175927',3459936,'2393','364',32547.74,32562.55,4.81,779.22,0.00,0.00,10.00,0.00,0.00),('1','157','836','175927',3459937,'2394','364',38445.63,39889.34,1433.71,232261.02,0.00,0.00,10.00,0.00,0.00),('1','157','836','175927',3459938,'2395','364',77900.19,78975.65,1065.46,172604.52,0.00,0.00,10.00,0.00,0.00),('1','157','836','175927',3459939,'2396','364',120676.57,121674.38,987.81,160025.22,0.00,0.00,10.00,0.00,0.00),('1','157','837','175927',3459940,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175927',3459941,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175927',3459942,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','175927',3459943,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175927',3459944,'2401','364',128889.82,130359.61,1459.79,236485.98,0.00,0.00,10.00,0.00,0.00),('1','157','838','175927',3459945,'2402','364',62007.62,62007.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','175927',3459946,'2403','364',83948.85,84465.76,506.91,82119.42,0.00,0.00,10.00,0.00,0.00),('1','157','838','175927',3459947,'2404','364',70284.53,71094.73,800.20,129632.40,0.00,0.00,10.00,0.00,0.00),('1','157','839','175927',3459948,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175927',3459949,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175927',3459950,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','175927',3459951,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175927',3459952,'2409','365',8226.45,8276.45,40.00,9000.00,0.00,0.00,10.00,0.00,0.00),('1','157','840','175927',3459953,'2410','365',53526.87,54790.89,1254.02,282154.50,0.00,0.00,10.00,0.00,0.00),('1','157','840','175927',3459954,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','175927',3459955,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176104',3463201,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176104',3463202,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176104',3463203,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176104',3463204,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176104',3463205,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176104',3463206,'2394','364',39889.34,40876.14,986.80,159861.60,0.00,0.00,0.00,0.00,0.00),('1','157','836','176104',3463207,'2395','364',78975.65,79866.33,890.68,144290.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','176104',3463208,'2396','364',121674.38,122955.28,1280.90,207505.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','176104',3463209,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176104',3463210,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176104',3463211,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176104',3463212,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176104',3463213,'2401','364',130359.61,131716.02,1356.41,219738.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','176104',3463214,'2402','364',62007.62,62860.83,853.21,138220.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','176104',3463215,'2403','364',84465.76,84530.58,64.82,10500.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','176104',3463216,'2404','364',71094.73,71989.11,894.38,144889.56,0.00,0.00,0.00,0.00,0.00),('1','157','839','176104',3463217,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176104',3463218,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176104',3463219,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176104',3463220,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176104',3463221,'2409','365',8276.45,8856.93,580.48,130608.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176104',3463222,'2410','365',54790.89,54790.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176104',3463223,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176104',3463224,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176293',3466775,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176293',3466776,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176293',3466777,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176293',3466778,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176293',3466779,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176293',3466780,'2394','364',40876.14,42299.87,1423.73,230644.26,0.00,0.00,0.00,0.00,0.00),('1','157','836','176293',3466781,'2395','364',79866.33,80482.59,616.26,99834.12,0.00,0.00,0.00,0.00,0.00),('1','157','836','176293',3466782,'2396','364',122955.28,124197.63,1242.35,201260.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','176293',3466783,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176293',3466784,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176293',3466785,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176293',3466786,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176293',3466787,'2401','364',131716.02,132541.68,825.66,133756.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','176293',3466788,'2402','364',62860.83,63712.87,852.04,138030.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','176293',3466789,'2403','364',84530.58,85604.57,1073.99,173986.38,0.00,0.00,0.00,0.00,0.00),('1','157','838','176293',3466790,'2404','364',71989.11,71989.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176293',3466791,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176293',3466792,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176293',3466793,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176293',3466794,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176293',3466795,'2409','365',8856.93,8856.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176293',3466796,'2410','365',54790.89,55300.98,510.09,114770.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','176293',3466797,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176293',3466798,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176294',3466799,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176294',3466800,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176294',3466801,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176294',3466802,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176294',3466803,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176294',3466804,'2394','364',42299.87,43914.58,1614.71,261583.02,0.00,0.00,0.00,0.00,0.00),('1','157','836','176294',3466805,'2395','364',80482.59,81291.22,808.63,130998.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','176294',3466806,'2396','364',124197.63,126248.79,2051.16,332287.92,0.00,0.00,0.00,0.00,0.00),('1','157','837','176294',3466807,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176294',3466808,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176294',3466809,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176294',3466810,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176294',3466811,'2401','364',132541.68,133270.36,728.68,118046.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','176294',3466812,'2402','364',63712.87,64884.12,1171.25,189742.50,0.00,0.00,0.00,0.00,0.00),('1','157','838','176294',3466813,'2403','364',85604.57,85604.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176294',3466814,'2404','364',71989.11,73405.73,1416.62,229492.44,0.00,0.00,0.00,0.00,0.00),('1','157','839','176294',3466815,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176294',3466816,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176294',3466817,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176294',3466818,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176294',3466819,'2409','365',8856.93,8856.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176294',3466820,'2410','365',55300.98,55504.89,203.91,45879.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','176294',3466821,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176294',3466822,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176492',3470364,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176492',3470365,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176492',3470366,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176492',3470367,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176492',3470368,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176492',3470369,'2394','364',43914.58,45569.63,1655.05,268118.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','176492',3470370,'2395','364',81291.22,82342.67,1051.45,170334.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','176492',3470371,'2396','364',126248.79,127474.30,1225.51,198532.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','176492',3470372,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176492',3470373,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176492',3470374,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176492',3470375,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176492',3470376,'2401','364',133270.36,134719.61,1429.25,231538.50,0.00,0.00,20.00,0.00,0.00),('1','157','838','176492',3470377,'2402','364',64884.12,65663.30,769.86,124717.32,0.00,0.00,9.32,0.00,0.00),('1','157','838','176492',3470378,'2403','364',85604.57,86504.60,900.03,145804.86,0.00,0.00,0.00,0.00,0.00),('1','157','838','176492',3470379,'2404','364',73405.73,73405.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176492',3470380,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176492',3470381,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176492',3470382,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176492',3470383,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176492',3470384,'2409','365',8856.93,8958.19,101.26,22783.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','176492',3470385,'2410','365',55504.89,56569.06,1054.17,237188.25,0.00,0.00,10.00,0.00,0.00),('1','157','840','176492',3470386,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176492',3470387,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176495',3470404,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176495',3470405,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176495',3470406,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176495',3470407,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176495',3470408,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176495',3470409,'2394','364',45569.63,45842.21,272.58,44157.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','176495',3470410,'2395','364',82342.67,82517.09,174.42,28256.04,0.00,0.00,0.00,0.00,0.00),('1','157','836','176495',3470411,'2396','364',127474.30,127718.72,244.42,39596.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','176495',3470412,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176495',3470413,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176495',3470414,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176495',3470415,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176495',3470416,'2401','364',134719.61,135839.24,1119.63,181380.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','176495',3470417,'2402','364',65663.30,66573.77,910.47,147496.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','176495',3470418,'2403','364',86504.60,87701.15,1171.85,189839.70,0.00,0.00,24.70,0.00,0.00),('1','157','838','176495',3470419,'2404','364',73405.73,74445.58,1039.85,168455.70,0.00,0.00,0.00,0.00,0.00),('1','157','839','176495',3470420,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176495',3470421,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176495',3470422,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176495',3470423,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176495',3470424,'2409','365',8958.19,8958.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176495',3470425,'2410','365',56569.06,56569.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176495',3470426,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176495',3470427,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176765',3475440,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176765',3475441,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176765',3475442,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176765',3475443,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176765',3475444,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176765',3475445,'2394','364',45842.21,46038.14,195.93,31740.66,0.00,0.00,0.00,0.00,0.00),('1','157','836','176765',3475446,'2395','364',82517.09,82745.78,228.69,37047.78,0.00,0.00,0.00,0.00,0.00),('1','157','836','176765',3475447,'2396','364',127718.72,127984.80,266.08,43104.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','176765',3475448,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176765',3475449,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176765',3475450,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176765',3475451,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176765',3475452,'2401','364',135839.24,136051.30,212.06,34353.72,0.00,0.00,0.00,0.00,0.00),('1','157','838','176765',3475453,'2402','364',66573.77,66787.38,213.61,34604.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','176765',3475454,'2403','364',87701.15,87839.33,138.18,22385.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','176765',3475455,'2404','364',74445.58,74445.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176765',3475456,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176765',3475457,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176765',3475458,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176765',3475459,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176765',3475460,'2409','365',8958.19,8958.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176765',3475461,'2410','365',56569.06,56569.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176765',3475462,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176765',3475463,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176843',3476851,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176843',3476852,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176843',3476853,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176843',3476854,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176843',3476855,'2393','364',32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176843',3476856,'2394','364',46038.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176843',3476857,'2395','364',82745.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176843',3476858,'2396','364',127984.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176843',3476859,'2397','364',121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176843',3476860,'2398','364',154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176843',3476861,'2399','364',109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176843',3476862,'2400','364',100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176843',3476863,'2401','364',136051.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176843',3476864,'2402','364',66787.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176843',3476865,'2403','364',87839.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176843',3476866,'2404','364',74445.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176843',3476867,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176843',3476868,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176843',3476869,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176843',3476870,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176843',3476871,'2409','365',8958.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176843',3476872,'2410','365',56569.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176843',3476873,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176843',3476874,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176948',3478916,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176948',3478917,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176948',3478918,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','176948',3478919,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176948',3478920,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','176948',3478921,'2394','364',46038.14,47455.66,1417.52,229638.24,0.00,0.00,0.00,0.00,0.00),('1','157','836','176948',3478922,'2395','364',82745.78,83598.81,853.03,138190.86,0.00,0.00,0.00,0.00,0.00),('1','157','836','176948',3478923,'2396','364',127984.80,129375.81,1391.01,225343.62,0.00,0.00,0.00,0.00,0.00),('1','157','837','176948',3478924,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176948',3478925,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176948',3478926,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','176948',3478927,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','176948',3478928,'2401','364',136051.30,137011.77,960.47,155596.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','176948',3478929,'2402','364',66787.38,67617.58,830.20,134492.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','176948',3478930,'2403','364',87839.33,89069.65,1230.32,199311.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','176948',3478931,'2404','364',74445.58,74445.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176948',3478932,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176948',3478933,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176948',3478934,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','176948',3478935,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176948',3478936,'2409','365',8958.19,9408.19,450.00,101250.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176948',3478937,'2410','365',56569.06,57913.95,1344.89,302600.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','176948',3478938,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','176948',3478939,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177173',3483245,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177173',3483246,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177173',3483247,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177173',3483248,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177173',3483249,'2393','364',32562.55,32562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177173',3483250,'2394','364',47455.66,48943.82,1488.16,241081.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','177173',3483251,'2395','364',83598.81,85051.25,1452.44,235295.28,0.00,0.00,0.00,0.00,0.00),('1','157','836','177173',3483252,'2396','364',129375.81,130557.80,1181.99,191482.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','177173',3483253,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177173',3483254,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177173',3483255,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177173',3483256,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177173',3483257,'2401','364',137011.77,137928.17,916.40,148456.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','177173',3483258,'2402','364',67617.58,68521.79,904.21,146482.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','177173',3483259,'2403','364',89069.65,90049.96,980.31,158810.22,0.00,0.00,0.00,0.00,0.00),('1','157','838','177173',3483260,'2404','364',74445.58,74445.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177173',3483261,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177173',3483262,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177173',3483263,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177173',3483264,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177173',3483265,'2409','365',9408.19,9408.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177173',3483266,'2410','365',57913.95,57979.28,65.33,14699.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','177173',3483267,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177173',3483268,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177179',3483340,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177179',3483341,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177179',3483342,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177179',3483343,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177179',3483344,'2393','364',32562.55,32563.00,0.00,0.00,0.00,0.00,0.45,0.00,0.00),('1','157','836','177179',3483345,'2394','364',48943.82,50144.82,1201.00,194562.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177179',3483346,'2395','364',85051.25,86049.23,997.98,161672.76,0.00,0.00,0.00,0.00,0.00),('1','157','836','177179',3483347,'2396','364',130557.80,131859.52,1301.72,210878.64,0.00,0.00,0.00,0.00,0.00),('1','157','837','177179',3483348,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177179',3483349,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177179',3483350,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177179',3483351,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177179',3483352,'2401','364',137928.17,138921.81,993.64,160969.68,0.00,0.00,0.00,0.00,0.00),('1','157','838','177179',3483353,'2402','364',68521.79,69065.36,543.57,88058.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','177179',3483354,'2403','364',90049.96,90530.93,480.97,77917.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','177179',3483355,'2404','364',74445.58,75074.82,629.24,101936.88,0.00,0.00,0.00,0.00,0.00),('1','157','839','177179',3483356,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177179',3483357,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177179',3483358,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177179',3483359,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177179',3483360,'2409','365',9408.19,9595.15,176.96,40700.80,0.00,0.00,10.00,0.00,0.00),('1','157','840','177179',3483361,'2410','365',57979.28,58930.80,941.52,216549.60,0.00,0.00,10.00,0.00,0.00),('1','157','840','177179',3483362,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177179',3483363,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177182',3483381,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177182',3483382,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177182',3483383,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177182',3483384,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177182',3483385,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177182',3483386,'2394','364',50144.82,51063.31,918.49,148795.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','177182',3483387,'2395','364',86049.23,87222.46,1173.23,190063.26,0.00,0.00,0.00,0.00,0.00),('1','157','836','177182',3483388,'2396','364',131859.52,133226.70,1367.18,221483.16,0.00,0.00,0.00,0.00,0.00),('1','157','837','177182',3483389,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177182',3483390,'2398','364',154955.08,154955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177182',3483391,'2399','364',109852.63,109852.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177182',3483392,'2400','364',100319.96,100319.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177182',3483393,'2401','364',138921.81,139803.48,881.67,142830.54,0.00,0.00,0.00,0.00,0.00),('1','157','838','177182',3483394,'2402','364',69065.36,70395.84,1330.48,215537.76,0.00,0.00,0.00,0.00,0.00),('1','157','838','177182',3483395,'2403','364',90530.93,91275.95,745.02,120693.24,0.00,0.00,0.00,0.00,0.00),('1','157','838','177182',3483396,'2404','364',75074.82,75219.04,144.22,23363.64,0.00,0.00,0.00,0.00,0.00),('1','157','839','177182',3483397,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177182',3483398,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177182',3483399,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177182',3483400,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177182',3483401,'2409','365',9595.15,9606.02,10.87,2500.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','177182',3483402,'2410','365',58930.80,61627.48,2696.68,620236.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','177182',3483403,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177182',3483404,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177572',3491377,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177572',3491378,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177572',3491379,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177572',3491380,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177572',3491381,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177572',3491382,'2394','364',51063.31,52063.26,989.95,160371.90,0.00,0.00,10.00,0.00,0.00),('1','157','836','177572',3491383,'2395','364',87222.46,87222.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177572',3491384,'2396','364',133226.70,134345.05,1108.35,179552.70,0.00,0.00,10.00,0.00,0.00),('1','157','837','177572',3491385,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177572',3491386,'2398','364',154955.08,156358.86,1393.78,225792.36,0.00,0.00,10.00,0.00,0.00),('1','157','837','177572',3491387,'2399','364',109852.63,110239.36,376.73,61030.26,0.00,0.00,10.00,0.00,0.00),('1','157','837','177572',3491388,'2400','364',100319.96,100909.48,579.52,93882.24,0.00,0.00,10.00,0.00,0.00),('1','157','838','177572',3491389,'2401','364',139803.48,140597.93,784.45,127080.90,0.00,0.00,10.00,0.00,0.00),('1','157','838','177572',3491390,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177572',3491391,'2403','364',91275.95,91710.47,424.52,68772.24,0.00,0.00,10.00,0.00,0.00),('1','157','838','177572',3491392,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177572',3491393,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177572',3491394,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177572',3491395,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177572',3491396,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177572',3491397,'2409','365',9606.02,9606.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177572',3491398,'2410','365',61627.48,62321.42,683.94,157306.20,0.00,0.00,10.00,0.00,0.00),('1','157','840','177572',3491399,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177572',3491400,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177575',3491418,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177575',3491419,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177575',3491420,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177575',3491421,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177575',3491422,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177575',3491423,'2394','364',52063.26,53078.61,1015.35,164486.70,0.00,0.00,0.00,0.00,0.00),('1','157','836','177575',3491424,'2395','364',87222.46,88847.79,1625.33,263303.46,0.00,0.00,0.00,0.00,0.00),('1','157','836','177575',3491425,'2396','364',134345.05,134345.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177575',3491426,'2397','364',121254.47,121254.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177575',3491427,'2398','364',156358.86,157791.98,1433.12,232165.44,0.00,0.00,0.00,0.00,0.00),('1','157','837','177575',3491428,'2399','364',110239.36,110264.05,24.69,3999.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','177575',3491429,'2400','364',100909.48,102053.78,1144.30,185376.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','177575',3491430,'2401','364',140597.93,140597.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177575',3491431,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177575',3491432,'2403','364',91710.47,91710.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177575',3491433,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177575',3491434,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177575',3491435,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177575',3491436,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177575',3491437,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177575',3491438,'2409','365',9606.02,9616.72,10.70,2461.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177575',3491439,'2410','365',62321.42,62364.67,43.25,9947.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','177575',3491440,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177575',3491441,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177581',3491564,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177581',3491565,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177581',3491566,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177581',3491567,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177581',3491568,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177581',3491569,'2394','364',53078.61,54791.52,1712.91,277491.42,0.00,0.00,0.00,0.00,0.00),('1','157','836','177581',3491570,'2395','364',88847.79,89173.74,325.95,52803.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','177581',3491571,'2396','364',134345.05,135387.74,1042.69,168915.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','177581',3491572,'2397','364',121254.47,122288.25,1033.78,167472.36,0.00,0.00,0.00,0.00,0.00),('1','157','837','177581',3491573,'2398','364',157791.98,159171.37,1379.39,223461.18,0.00,0.00,0.00,0.00,0.00),('1','157','837','177581',3491574,'2399','364',110264.05,110924.02,659.97,106915.14,0.00,0.00,0.00,0.00,0.00),('1','157','837','177581',3491575,'2400','364',102053.78,102455.02,401.24,65000.88,0.00,0.00,0.00,0.00,0.00),('1','157','838','177581',3491576,'2401','364',140597.93,140597.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177581',3491577,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177581',3491578,'2403','364',91710.47,91710.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177581',3491579,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177581',3491580,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177581',3491581,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177581',3491582,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177581',3491583,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177581',3491584,'2409','365',9616.72,9616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177581',3491585,'2410','365',62364.67,62682.66,317.99,73137.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','177581',3491586,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177581',3491587,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177583',3491605,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177583',3491606,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177583',3491607,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177583',3491608,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177583',3491609,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177583',3491610,'2394','364',54791.52,56111.57,1320.05,213848.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','177583',3491611,'2395','364',89173.74,90238.63,1064.89,172512.18,0.00,0.00,0.00,0.00,0.00),('1','157','836','177583',3491612,'2396','364',135387.74,136441.03,1053.29,170632.98,0.00,0.00,0.00,0.00,0.00),('1','157','837','177583',3491613,'2397','364',122288.25,123378.71,1090.46,176654.52,0.00,0.00,0.00,0.00,0.00),('1','157','837','177583',3491614,'2398','364',159171.37,160504.33,1332.96,215939.52,0.00,0.00,0.00,0.00,0.00),('1','157','837','177583',3491615,'2399','364',110924.02,112156.52,1232.50,199665.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177583',3491616,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177583',3491617,'2401','364',140597.93,140597.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177583',3491618,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177583',3491619,'2403','364',91710.47,91710.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177583',3491620,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177583',3491621,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177583',3491622,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177583',3491623,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177583',3491624,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177583',3491625,'2409','365',9616.72,9718.02,101.30,23299.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177583',3491626,'2410','365',62682.66,65418.55,2735.89,629254.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','177583',3491627,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177583',3491628,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177881',3496814,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177881',3496815,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177881',3496816,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177881',3496817,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177881',3496818,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177881',3496819,'2394','364',56111.57,57383.57,1272.00,206064.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177881',3496820,'2395','364',90238.63,91239.58,1000.95,162153.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','177881',3496821,'2396','364',136441.03,137732.39,1291.36,209200.32,0.00,0.00,0.00,0.00,0.00),('1','157','837','177881',3496822,'2397','364',123378.71,124380.37,1001.66,162268.92,0.00,0.00,0.00,0.00,0.00),('1','157','837','177881',3496823,'2398','364',160504.33,161897.10,1392.77,225628.74,0.00,0.00,0.00,0.00,0.00),('1','157','837','177881',3496824,'2399','364',112156.52,113120.15,963.63,156108.06,0.00,0.00,0.00,0.00,0.00),('1','157','837','177881',3496825,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177881',3496826,'2401','364',140597.93,140597.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177881',3496827,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177881',3496828,'2403','364',91710.47,91710.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177881',3496829,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177881',3496830,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177881',3496831,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177881',3496832,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177881',3496833,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177881',3496834,'2409','365',9718.02,9756.73,38.71,8903.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','177881',3496835,'2410','365',65418.55,66454.01,1035.46,238155.80,0.00,0.00,0.00,0.00,0.00),('1','157','840','177881',3496836,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177881',3496837,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177883',3496850,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177883',3496851,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177883',3496852,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177883',3496853,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177883',3496854,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177883',3496855,'2394','364',57383.57,59000.88,1617.31,262004.22,0.00,0.00,0.00,0.00,0.00),('1','157','836','177883',3496856,'2395','364',91239.58,92171.09,931.51,150904.62,0.00,0.00,0.00,0.00,0.00),('1','157','836','177883',3496857,'2396','364',137732.39,139095.42,1363.03,220810.86,0.00,0.00,0.00,0.00,0.00),('1','157','837','177883',3496858,'2397','364',124380.37,125964.18,1583.81,256577.22,0.00,0.00,0.00,0.00,0.00),('1','157','837','177883',3496859,'2398','364',161897.10,161897.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','177883',3496860,'2399','364',113120.15,114426.60,1306.45,211644.90,0.00,0.00,0.00,0.00,0.00),('1','157','837','177883',3496861,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177883',3496862,'2401','364',140597.93,140597.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177883',3496863,'2402','364',70395.84,70395.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177883',3496864,'2403','364',91710.47,91710.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177883',3496865,'2404','364',75219.04,75219.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177883',3496866,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177883',3496867,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177883',3496868,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177883',3496869,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177883',3496870,'2409','365',9756.73,9863.25,106.52,24499.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','177883',3496871,'2410','365',66454.01,68205.96,1751.95,402948.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','177883',3496872,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177883',3496873,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177884',3496874,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177884',3496875,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177884',3496876,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','177884',3496877,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177884',3496878,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','177884',3496879,'2394','364',59000.88,60454.87,1453.99,235546.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','177884',3496880,'2395','364',92171.09,92550.47,369.38,59839.56,0.00,0.00,10.00,0.00,0.00),('1','157','836','177884',3496881,'2396','364',139095.42,140116.41,1020.99,165400.38,0.00,0.00,0.00,0.00,0.00),('1','157','837','177884',3496882,'2397','364',125964.18,126477.71,503.53,81571.86,0.00,0.00,10.00,0.00,0.00),('1','157','837','177884',3496883,'2398','364',161897.10,162657.02,759.92,123107.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','177884',3496884,'2399','364',114426.60,114802.62,366.02,59295.24,0.00,0.00,10.00,0.00,0.00),('1','157','837','177884',3496885,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','177884',3496886,'2401','364',140597.93,141464.16,866.23,140329.26,0.00,0.00,0.00,0.00,0.00),('1','157','838','177884',3496887,'2402','364',70395.84,70766.22,360.38,58381.56,0.00,0.00,10.00,0.00,0.00),('1','157','838','177884',3496888,'2403','364',91710.47,92415.84,705.37,114269.94,0.00,0.00,0.00,0.00,0.00),('1','157','838','177884',3496889,'2404','364',75219.04,75473.32,244.28,39573.36,0.00,0.00,10.00,0.00,0.00),('1','157','839','177884',3496890,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177884',3496891,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177884',3496892,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','177884',3496893,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177884',3496894,'2409','365',9863.25,9880.65,17.40,4002.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177884',3496895,'2410','365',68205.96,69836.79,1620.83,372790.90,0.00,0.00,10.00,0.00,0.00),('1','157','840','177884',3496896,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','177884',3496897,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178076',3500700,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178076',3500701,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178076',3500702,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178076',3500703,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178076',3500704,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178076',3500705,'2394','364',60454.87,62090.59,1635.72,264986.64,0.00,0.00,0.00,0.00,0.00),('1','157','836','178076',3500706,'2395','364',92550.47,93800.49,1250.02,202503.24,0.00,0.00,0.00,0.00,0.00),('1','157','836','178076',3500707,'2396','364',140116.41,141354.55,1238.14,200578.68,0.00,0.00,0.00,0.00,0.00),('1','157','837','178076',3500708,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178076',3500709,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178076',3500710,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178076',3500711,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178076',3500712,'2401','364',141464.16,142596.37,1132.21,183418.02,0.00,0.00,0.00,0.00,0.00),('1','157','838','178076',3500713,'2402','364',70766.22,71773.99,1007.77,163258.74,0.00,0.00,0.00,0.00,0.00),('1','157','838','178076',3500714,'2403','364',92415.84,93554.27,1138.43,184425.66,0.00,0.00,0.00,0.00,0.00),('1','157','838','178076',3500715,'2404','364',75473.32,75473.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178076',3500716,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178076',3500717,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178076',3500718,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178076',3500719,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178076',3500720,'2409','365',9880.65,9880.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178076',3500721,'2410','365',69836.79,69945.92,109.13,25099.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','178076',3500722,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178076',3500723,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178316',3504967,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178316',3504968,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178316',3504969,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178316',3504970,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178316',3504971,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178316',3504972,'2394','364',62090.59,62110.27,19.68,3188.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','178316',3504973,'2395','364',93800.49,93830.12,29.63,4800.06,0.00,0.00,0.00,0.00,0.00),('1','157','836','178316',3504974,'2396','364',141354.55,141448.38,93.83,15200.46,0.00,0.00,0.00,0.00,0.00),('1','157','837','178316',3504975,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178316',3504976,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178316',3504977,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178316',3504978,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178316',3504979,'2401','364',142596.37,144577.18,1980.81,320891.22,0.00,0.00,0.00,0.00,0.00),('1','157','838','178316',3504980,'2402','364',71773.99,73829.99,2056.00,333072.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178316',3504981,'2403','364',93554.27,94875.40,1321.13,214023.06,0.00,0.00,0.00,0.00,0.00),('1','157','838','178316',3504982,'2404','364',75473.32,76785.29,1311.97,212539.14,0.00,0.00,0.00,0.00,0.00),('1','157','839','178316',3504983,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178316',3504984,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178316',3504985,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178316',3504986,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178316',3504987,'2409','365',9880.65,9933.69,53.04,12199.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','178316',3504988,'2410','365',69945.92,70633.29,687.37,158095.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','178316',3504989,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178316',3504990,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178322',3505120,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178322',3505121,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178322',3505122,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178322',3505123,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178322',3505124,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178322',3505125,'2394','364',62110.27,62110.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178322',3505126,'2395','364',93830.12,93830.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178322',3505127,'2396','364',141448.38,141448.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178322',3505128,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178322',3505129,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178322',3505130,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178322',3505131,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178322',3505132,'2401','364',144577.18,146152.36,1575.18,256754.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','178322',3505133,'2402','364',73829.99,75721.88,1891.89,308378.07,0.00,0.00,0.00,0.00,0.00),('1','157','838','178322',3505134,'2403','364',94875.40,96444.28,1568.88,255727.44,0.00,0.00,0.00,0.00,0.00),('1','157','838','178322',3505135,'2404','364',76785.29,78640.04,1854.75,302324.25,0.00,0.00,0.00,0.00,0.00),('1','157','839','178322',3505136,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178322',3505137,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178322',3505138,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178322',3505139,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178322',3505140,'2409','365',9933.69,9933.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178322',3505141,'2410','365',70633.29,71800.82,1167.53,274369.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','178322',3505142,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178322',3505143,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178498',3508410,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178498',3508411,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178498',3508412,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178498',3508413,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178498',3508414,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178498',3508415,'2394','364',62110.27,63208.17,1097.90,178957.70,0.00,0.00,0.00,0.00,0.00),('1','157','836','178498',3508416,'2395','364',93830.12,94871.43,1041.31,169733.53,0.00,0.00,0.00,0.00,0.00),('1','157','836','178498',3508417,'2396','364',141448.38,142072.35,623.97,101707.11,0.00,0.00,0.00,0.00,0.00),('1','157','837','178498',3508418,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178498',3508419,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178498',3508420,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178498',3508421,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178498',3508422,'2401','364',146152.36,147215.02,1062.66,173213.58,0.00,0.00,0.00,0.00,0.00),('1','157','838','178498',3508423,'2402','364',75721.88,76456.14,734.26,119684.38,0.00,0.00,0.00,0.00,0.00),('1','157','838','178498',3508424,'2403','364',96444.28,97252.24,807.96,131697.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','178498',3508425,'2404','364',78640.04,79274.90,634.86,103482.18,0.00,0.00,0.00,0.00,0.00),('1','157','839','178498',3508426,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178498',3508427,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178498',3508428,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178498',3508429,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178498',3508430,'2409','365',9933.69,9933.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178498',3508431,'2410','365',71800.82,71944.66,143.84,33802.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','178498',3508432,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178498',3508433,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178508',3508622,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178508',3508623,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178508',3508624,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178508',3508625,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178508',3508626,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178508',3508627,'2394','364',63208.17,65498.90,2290.73,373388.99,0.00,0.00,0.00,0.00,0.00),('1','157','836','178508',3508628,'2395','364',94871.43,96121.75,1250.32,203802.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','178508',3508629,'2396','364',142072.35,143408.49,1336.14,217790.82,0.00,0.00,0.00,0.00,0.00),('1','157','837','178508',3508630,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178508',3508631,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178508',3508632,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178508',3508633,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178508',3508634,'2401','364',147215.02,147259.18,44.16,7198.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','178508',3508635,'2402','364',76456.14,77689.48,1233.34,201034.42,0.00,0.00,0.00,0.00,0.00),('1','157','838','178508',3508636,'2403','364',97252.24,97273.10,20.86,3400.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','178508',3508637,'2404','364',79274.90,80128.68,853.78,139166.14,0.00,0.00,0.00,0.00,0.00),('1','157','839','178508',3508638,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178508',3508639,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178508',3508640,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178508',3508641,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178508',3508642,'2409','365',9933.69,9969.44,35.75,8401.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','178508',3508643,'2410','365',71944.66,72955.77,1011.11,237610.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','178508',3508644,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178508',3508645,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178856',3515139,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178856',3515140,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178856',3515141,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178856',3515142,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178856',3515143,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178856',3515144,'2394','364',65498.90,66680.06,1181.16,192529.08,0.00,0.00,0.00,0.00,0.00),('1','157','836','178856',3515145,'2395','364',96121.75,96968.90,847.15,138085.45,0.00,0.00,0.00,0.00,0.00),('1','157','836','178856',3515146,'2396','364',143408.49,144231.22,822.73,134104.99,0.00,0.00,0.00,0.00,0.00),('1','157','837','178856',3515147,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178856',3515148,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178856',3515149,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178856',3515150,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178856',3515151,'2401','364',147259.18,147544.23,285.05,46463.15,0.00,0.00,0.00,0.00,0.00),('1','157','838','178856',3515152,'2402','364',77689.48,78421.68,732.20,119348.60,0.00,0.00,0.00,0.00,0.00),('1','157','838','178856',3515153,'2403','364',97273.10,97735.98,462.88,75449.44,0.00,0.00,0.00,0.00,0.00),('1','157','838','178856',3515154,'2404','364',80128.68,80629.78,501.10,81679.30,0.00,0.00,0.00,0.00,0.00),('1','157','839','178856',3515155,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178856',3515156,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178856',3515157,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178856',3515158,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178856',3515159,'2409','365',9969.44,9969.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178856',3515160,'2410','365',72955.77,74637.47,1681.70,395199.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','178856',3515161,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178856',3515162,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178857',3515163,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178857',3515164,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178857',3515165,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178857',3515166,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178857',3515167,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178857',3515168,'2394','364',66680.06,68198.38,1518.32,247486.16,0.00,0.00,0.00,0.00,0.00),('1','157','836','178857',3515169,'2395','364',96968.90,97590.36,621.46,101297.98,0.00,0.00,0.00,0.00,0.00),('1','157','836','178857',3515170,'2396','364',144231.22,145278.06,1046.84,170634.92,0.00,0.00,0.00,0.00,0.00),('1','157','837','178857',3515171,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178857',3515172,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178857',3515173,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178857',3515174,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178857',3515175,'2401','364',147544.23,148399.91,855.68,139475.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','178857',3515176,'2402','364',78421.68,79018.63,596.95,97302.85,0.00,0.00,0.00,0.00,0.00),('1','157','838','178857',3515177,'2403','364',97735.98,98084.71,348.73,56842.99,0.00,0.00,0.00,0.00,0.00),('1','157','838','178857',3515178,'2404','364',80629.78,81176.28,546.50,89079.50,0.00,0.00,0.00,0.00,0.00),('1','157','839','178857',3515179,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178857',3515180,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178857',3515181,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178857',3515182,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178857',3515183,'2409','365',9969.44,9977.95,8.51,1999.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','178857',3515184,'2410','365',74637.47,76261.94,1624.47,381750.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','178857',3515185,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178857',3515186,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178861',3515227,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178861',3515228,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178861',3515229,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','178861',3515230,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178861',3515231,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','178861',3515232,'2394','364',68198.38,69566.02,1367.64,222925.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','178861',3515233,'2395','364',97590.36,99046.65,1436.29,234115.27,0.00,0.00,20.00,0.00,0.00),('1','157','836','178861',3515234,'2396','364',145278.06,146786.14,1508.08,245817.04,0.00,0.00,0.00,0.00,0.00),('1','157','837','178861',3515235,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178861',3515236,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178861',3515237,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','178861',3515238,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','178861',3515239,'2401','364',148399.91,148640.86,240.95,39274.85,0.00,0.00,0.00,0.00,0.00),('1','157','838','178861',3515240,'2402','364',79018.63,79553.64,535.01,87206.63,0.00,0.00,0.00,0.00,0.00),('1','157','838','178861',3515241,'2403','364',98084.71,98346.62,261.91,42691.33,0.00,0.00,0.00,0.00,0.00),('1','157','838','178861',3515242,'2404','364',81176.28,81438.13,261.85,42681.55,0.00,0.00,0.00,0.00,0.00),('1','157','839','178861',3515243,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178861',3515244,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178861',3515245,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','178861',3515246,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178861',3515247,'2409','365',9977.95,9977.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178861',3515248,'2410','365',76261.94,77002.37,740.43,174001.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','178861',3515249,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','178861',3515250,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179091',3519345,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179091',3519346,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179091',3519347,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179091',3519348,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179091',3519349,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179091',3519350,'2394','364',69566.02,72207.11,2641.09,430497.67,0.00,0.00,0.00,0.00,0.00),('1','157','836','179091',3519351,'2395','364',99046.65,101057.48,2010.83,327765.29,0.00,0.00,0.00,0.00,0.00),('1','157','836','179091',3519352,'2396','364',146786.14,148742.62,1946.48,317276.24,0.00,0.00,10.00,0.00,0.00),('1','157','837','179091',3519353,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179091',3519354,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179091',3519355,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179091',3519356,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179091',3519357,'2401','364',148640.86,148640.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179091',3519358,'2402','364',79553.64,79553.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179091',3519359,'2403','364',98346.62,98346.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179091',3519360,'2404','364',81438.13,81438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179091',3519361,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179091',3519362,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179091',3519363,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179091',3519364,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179091',3519365,'2409','365',9977.95,9977.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179091',3519366,'2410','365',77002.37,77498.86,496.49,116675.15,0.00,0.00,0.00,0.00,0.00),('1','157','840','179091',3519367,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179091',3519368,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179092',3519369,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179092',3519370,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179092',3519371,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179092',3519372,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179092',3519373,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179092',3519374,'2394','364',72207.11,74413.37,2206.26,359620.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','179092',3519375,'2395','364',101057.48,102617.45,1539.97,251015.11,0.00,0.00,20.00,0.00,0.00),('1','157','836','179092',3519376,'2396','364',148742.62,150588.73,1846.11,300915.93,0.00,0.00,0.00,0.00,0.00),('1','157','837','179092',3519377,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179092',3519378,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179092',3519379,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179092',3519380,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179092',3519381,'2401','364',148640.86,148640.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179092',3519382,'2402','364',79553.64,79553.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179092',3519383,'2403','364',98346.62,98346.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179092',3519384,'2404','364',81438.13,81438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179092',3519385,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179092',3519386,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179092',3519387,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179092',3519388,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179092',3519389,'2409','365',9977.95,9977.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179092',3519390,'2410','365',77498.86,78238.44,739.58,177499.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','179092',3519391,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179092',3519392,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179244',3522210,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179244',3522211,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179244',3522212,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179244',3522213,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179244',3522214,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179244',3522215,'2394','364',74413.37,76080.03,1656.66,270035.58,0.00,0.00,10.00,0.00,0.00),('1','157','836','179244',3522216,'2395','364',102617.45,103604.49,987.04,160887.52,0.00,0.00,0.00,0.00,0.00),('1','157','836','179244',3522217,'2396','364',150588.73,151919.84,1321.11,215340.93,0.00,0.00,10.00,0.00,0.00),('1','157','837','179244',3522218,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179244',3522219,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179244',3522220,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179244',3522221,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179244',3522222,'2401','364',148640.86,149766.77,1125.91,183523.33,0.00,0.00,0.00,0.00,0.00),('1','157','838','179244',3522223,'2402','364',79553.64,80316.11,762.47,124282.61,0.00,0.00,0.00,0.00,0.00),('1','157','838','179244',3522224,'2403','364',98346.62,98877.41,530.79,86518.77,0.00,0.00,0.00,0.00,0.00),('1','157','838','179244',3522225,'2404','364',81438.13,82027.95,579.82,94510.66,0.00,0.00,10.00,0.00,0.00),('1','157','839','179244',3522226,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179244',3522227,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179244',3522228,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179244',3522229,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179244',3522230,'2409','365',9977.95,9983.78,5.83,1399.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','179244',3522231,'2410','365',78238.44,79289.92,1051.48,252355.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','179244',3522232,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179244',3522233,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179328',3524068,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179328',3524069,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179328',3524070,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179328',3524071,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179328',3524072,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179328',3524073,'2394','364',76080.03,77318.67,1238.64,201898.32,0.00,0.00,0.00,0.00,0.00),('1','157','836','179328',3524074,'2395','364',103604.49,104537.22,917.73,149589.99,0.00,0.00,15.00,0.00,0.00),('1','157','836','179328',3524075,'2396','364',151919.84,152836.91,917.07,149482.41,0.00,0.00,0.00,0.00,0.00),('1','157','837','179328',3524076,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179328',3524077,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179328',3524078,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179328',3524079,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179328',3524080,'2401','364',149766.77,150459.65,692.88,112939.44,0.00,0.00,0.00,0.00,0.00),('1','157','838','179328',3524081,'2402','364',80316.11,81181.28,865.17,141022.71,0.00,0.00,0.00,0.00,0.00),('1','157','838','179328',3524082,'2403','364',98877.41,98877.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179328',3524083,'2404','364',82027.95,83230.83,1192.88,194439.44,0.00,0.00,10.00,0.00,0.00),('1','157','839','179328',3524084,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179328',3524085,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179328',3524086,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179328',3524087,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179328',3524088,'2409','365',9983.78,9983.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179328',3524089,'2410','365',79289.92,79543.16,233.24,55977.60,0.00,0.00,20.00,0.00,0.00),('1','157','840','179328',3524090,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179328',3524091,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179543',3527985,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179543',3527986,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179543',3527987,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179543',3527988,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179543',3527989,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179543',3527990,'2394','364',77318.67,78420.44,1086.77,177143.51,0.00,0.00,15.00,0.00,0.00),('1','157','836','179543',3527991,'2395','364',104537.22,105617.95,1080.73,176158.99,0.00,0.00,0.00,0.00,0.00),('1','157','836','179543',3527992,'2396','364',152836.91,153982.54,1145.63,186737.69,0.00,0.00,0.00,0.00,0.00),('1','157','837','179543',3527993,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179543',3527994,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179543',3527995,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179543',3527996,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179543',3527997,'2401','364',150459.65,151063.81,604.16,98478.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','179543',3527998,'2402','364',81181.28,82010.60,829.32,135179.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','179543',3527999,'2403','364',98877.41,99439.73,562.32,91658.16,0.00,0.00,0.00,0.00,0.00),('1','157','838','179543',3528000,'2404','364',83230.83,83931.00,700.17,114127.71,0.00,0.00,0.00,0.00,0.00),('1','157','839','179543',3528001,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179543',3528002,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179543',3528003,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179543',3528004,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179543',3528005,'2409','365',9983.78,9983.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179543',3528006,'2410','365',79543.16,80763.09,1219.93,292783.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','179543',3528007,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179543',3528008,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179603',3528907,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179603',3528908,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179603',3528909,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179603',3528910,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179603',3528911,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179603',3528912,'2394','364',78420.44,79652.84,1232.40,200881.20,0.00,0.00,0.00,0.00,0.00),('1','157','836','179603',3528913,'2395','364',105617.95,106692.12,1074.17,175089.71,0.00,0.00,0.00,0.00,0.00),('1','157','836','179603',3528914,'2396','364',153982.54,155242.60,1260.06,205389.78,0.00,0.00,0.00,0.00,0.00),('1','157','837','179603',3528915,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179603',3528916,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179603',3528917,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179603',3528918,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179603',3528919,'2401','364',151063.81,151752.21,688.40,112209.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','179603',3528920,'2402','364',82010.60,83332.01,1311.41,213759.83,0.00,0.00,10.00,0.00,0.00),('1','157','838','179603',3528921,'2403','364',99439.73,99923.01,483.28,78774.64,0.00,0.00,0.00,0.00,0.00),('1','157','838','179603',3528922,'2404','364',83931.00,84444.69,513.69,83731.47,0.00,0.00,0.00,0.00,0.00),('1','157','839','179603',3528923,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179603',3528924,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179603',3528925,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179603',3528926,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179603',3528927,'2409','365',9983.78,9983.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179603',3528928,'2410','365',80763.09,81809.10,1046.01,251042.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','179603',3528929,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179603',3528930,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179829',3533368,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179829',3533369,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179829',3533370,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179829',3533371,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179829',3533372,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179829',3533373,'2394','364',79652.84,79653.77,0.93,151.59,0.00,0.00,0.00,0.00,0.00),('1','157','836','179829',3533374,'2395','364',106692.12,106692.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179829',3533375,'2396','364',155242.60,155264.08,21.48,3501.24,0.00,0.00,0.00,0.00,0.00),('1','157','837','179829',3533376,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179829',3533377,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179829',3533378,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179829',3533379,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179829',3533380,'2401','364',151752.21,153120.76,1368.55,223073.65,0.00,0.00,0.00,0.00,0.00),('1','157','838','179829',3533381,'2402','364',83332.01,84502.87,1170.86,190850.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','179829',3533382,'2403','364',99923.01,100807.92,884.91,144240.33,0.00,0.00,0.00,0.00,0.00),('1','157','838','179829',3533383,'2404','364',84444.69,85543.56,1098.87,179115.81,0.00,0.00,0.00,0.00,0.00),('1','157','839','179829',3533384,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179829',3533385,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179829',3533386,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179829',3533387,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179829',3533388,'2409','365',9983.78,10056.71,72.93,17503.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','179829',3533389,'2410','365',81809.10,83985.50,2176.40,522336.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179829',3533390,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179829',3533391,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179830',3533392,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179830',3533393,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179830',3533394,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179830',3533395,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179830',3533396,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179830',3533397,'2394','364',79653.77,81183.10,1529.33,249280.79,0.00,0.00,0.00,0.00,0.00),('1','157','836','179830',3533398,'2395','364',106692.12,107561.33,869.21,141681.23,0.00,0.00,0.00,0.00,0.00),('1','157','836','179830',3533399,'2396','364',155264.08,156895.86,1611.78,262720.14,0.00,0.00,20.00,0.00,0.00),('1','157','837','179830',3533400,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179830',3533401,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179830',3533402,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179830',3533403,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179830',3533404,'2401','364',153120.76,154162.32,1041.56,169774.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','179830',3533405,'2402','364',84502.87,84800.65,297.78,48538.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','179830',3533406,'2403','364',100807.92,101435.74,627.82,102334.82,0.00,0.00,0.00,0.00,0.00),('1','157','838','179830',3533407,'2404','364',85543.56,86175.54,631.98,103012.74,0.00,0.00,0.00,0.00,0.00),('1','157','839','179830',3533408,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179830',3533409,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179830',3533410,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179830',3533411,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179830',3533412,'2409','365',10056.71,11205.49,1148.78,281451.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','179830',3533413,'2410','365',83985.50,85194.58,1199.08,293774.60,0.00,0.00,10.00,0.00,0.00),('1','157','840','179830',3533414,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179830',3533415,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179961',3535875,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179961',3535876,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179961',3535877,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179961',3535878,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179961',3535879,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179961',3535880,'2394','364',81183.10,83089.63,1906.53,310764.39,0.00,0.00,0.00,0.00,0.00),('1','157','836','179961',3535881,'2395','364',107561.33,107561.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179961',3535882,'2396','364',156895.86,158792.53,1896.67,309157.21,0.00,0.00,0.00,0.00,0.00),('1','157','837','179961',3535883,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179961',3535884,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179961',3535885,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179961',3535886,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179961',3535887,'2401','364',154162.32,155222.78,1060.46,172854.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','179961',3535888,'2402','364',84800.65,85773.82,973.17,158626.71,0.00,0.00,0.00,0.00,0.00),('1','157','838','179961',3535889,'2403','364',101435.74,101435.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179961',3535890,'2404','364',86175.54,87442.43,1266.89,206503.07,0.00,0.00,0.00,0.00,0.00),('1','157','839','179961',3535891,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179961',3535892,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179961',3535893,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179961',3535894,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179961',3535895,'2409','365',11205.49,11205.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179961',3535896,'2410','365',85194.58,85364.98,170.40,41748.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179961',3535897,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179961',3535898,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179996',3536445,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179996',3536446,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179996',3536447,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','179996',3536448,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179996',3536449,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','179996',3536450,'2394','364',83089.63,84349.27,1249.64,203691.32,0.00,0.00,10.00,0.00,0.00),('1','157','836','179996',3536451,'2395','364',107561.33,108784.59,1213.26,197761.38,0.00,0.00,10.00,0.00,0.00),('1','157','836','179996',3536452,'2396','364',158792.53,159882.34,1079.81,176009.03,0.00,0.00,10.00,0.00,0.00),('1','157','837','179996',3536453,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179996',3536454,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179996',3536455,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','179996',3536456,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','179996',3536457,'2401','364',155222.78,156240.49,1007.71,164256.73,0.00,0.00,10.00,0.00,0.00),('1','157','838','179996',3536458,'2402','364',85773.82,86790.43,1006.61,164077.43,0.00,0.00,10.00,0.00,0.00),('1','157','838','179996',3536459,'2403','364',101435.74,102125.07,679.33,110730.79,0.00,0.00,10.00,0.00,0.00),('1','157','838','179996',3536460,'2404','364',87442.43,87815.88,363.45,59242.35,0.00,0.00,10.00,0.00,0.00),('1','157','839','179996',3536461,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179996',3536462,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179996',3536463,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','179996',3536464,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179996',3536465,'2409','365',11205.49,11205.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179996',3536466,'2410','365',85364.98,85706.94,331.96,81330.20,0.00,0.00,10.00,0.00,0.00),('1','157','840','179996',3536467,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','179996',3536468,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180267',3541552,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180267',3541553,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180267',3541554,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180267',3541555,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180267',3541556,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180267',3541557,'2394','364',84349.27,85513.43,1164.16,189758.08,0.00,0.00,0.00,0.00,0.00),('1','157','836','180267',3541558,'2395','364',108784.59,110053.17,1268.58,206778.54,0.00,0.00,0.00,0.00,0.00),('1','157','836','180267',3541559,'2396','364',159882.34,161103.26,1220.92,199009.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','180267',3541560,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180267',3541561,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180267',3541562,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180267',3541563,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180267',3541564,'2401','364',156240.49,157177.22,936.73,152686.99,0.00,0.00,0.00,0.00,0.00),('1','157','838','180267',3541565,'2402','364',86790.43,86790.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180267',3541566,'2403','364',102125.07,102125.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180267',3541567,'2404','364',87815.88,88777.21,961.33,156696.79,0.00,0.00,0.00,0.00,0.00),('1','157','839','180267',3541568,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180267',3541569,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180267',3541570,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180267',3541571,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180267',3541572,'2409','365',11205.49,11220.59,15.10,3699.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','180267',3541573,'2410','365',85706.94,86452.83,745.89,182743.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','180267',3541574,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180267',3541575,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180268',3541576,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180268',3541577,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180268',3541578,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180268',3541579,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180268',3541580,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180268',3541581,'2394','364',85513.43,86317.12,803.69,131001.47,0.00,0.00,0.00,0.00,0.00),('1','157','836','180268',3541582,'2395','364',110053.17,110913.85,860.68,140290.84,0.00,0.00,0.00,0.00,0.00),('1','157','836','180268',3541583,'2396','364',161103.26,161989.08,885.82,144388.66,0.00,0.00,0.00,0.00,0.00),('1','157','837','180268',3541584,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180268',3541585,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180268',3541586,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180268',3541587,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180268',3541588,'2401','364',157177.22,157852.86,675.64,110129.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','180268',3541589,'2402','364',86790.43,87562.44,772.01,125837.63,0.00,0.00,0.00,0.00,0.00),('1','157','838','180268',3541590,'2403','364',102125.07,102725.20,600.13,97821.19,0.00,0.00,0.00,0.00,0.00),('1','157','838','180268',3541591,'2404','364',88777.21,88777.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180268',3541592,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180268',3541593,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180268',3541594,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180268',3541595,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180268',3541596,'2409','365',11220.59,11220.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180268',3541597,'2410','365',86452.83,86563.44,110.61,27099.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','180268',3541598,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180268',3541599,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180272',3541630,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180272',3541631,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180272',3541632,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180272',3541633,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180272',3541634,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180272',3541635,'2394','364',86317.12,87392.42,1075.30,175273.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','180272',3541636,'2395','364',110913.85,111363.74,449.89,73332.07,0.00,0.00,0.00,0.00,0.00),('1','157','836','180272',3541637,'2396','364',161989.08,162793.00,803.92,131038.96,0.00,0.00,0.00,0.00,0.00),('1','157','837','180272',3541638,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180272',3541639,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180272',3541640,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180272',3541641,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180272',3541642,'2401','364',157852.86,158399.04,546.18,89027.34,0.00,0.00,0.00,0.00,0.00),('1','157','838','180272',3541643,'2402','364',87562.44,88225.41,662.97,108064.11,0.00,0.00,0.00,0.00,0.00),('1','157','838','180272',3541644,'2403','364',102725.20,103267.79,522.59,85182.17,0.00,0.00,20.00,0.00,0.00),('1','157','838','180272',3541645,'2404','364',88777.21,89014.28,237.07,38642.41,0.00,0.00,0.00,0.00,0.00),('1','157','839','180272',3541646,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180272',3541647,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180272',3541648,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180272',3541649,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180272',3541650,'2409','365',11220.59,11220.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180272',3541651,'2410','365',86563.44,86652.36,88.92,21785.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','180272',3541652,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180272',3541653,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180484',3545543,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180484',3545544,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180484',3545545,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180484',3545546,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180484',3545547,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180484',3545548,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180484',3545549,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180484',3545550,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180484',3545551,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180484',3545552,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180484',3545553,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180484',3545554,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180484',3545555,'2401','364',158399.04,159776.99,1377.95,224605.85,0.00,0.00,0.00,0.00,0.00),('1','157','838','180484',3545556,'2402','364',88225.41,89467.57,1242.16,202472.08,0.00,0.00,0.00,0.00,0.00),('1','157','838','180484',3545557,'2403','364',103267.79,104349.57,1081.78,176330.14,0.00,0.00,0.00,0.00,0.00),('1','157','838','180484',3545558,'2404','364',89014.28,90420.77,1406.49,229257.87,0.00,0.00,0.00,0.00,0.00),('1','157','839','180484',3545559,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180484',3545560,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180484',3545561,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180484',3545562,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180484',3545563,'2409','365',11220.59,11245.08,24.49,6000.05,0.00,0.00,0.00,0.00,0.00),('1','157','840','180484',3545564,'2410','365',86652.36,88435.06,1772.70,434311.50,0.00,0.00,10.00,0.00,0.00),('1','157','840','180484',3545565,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180484',3545566,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180894',3553081,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180894',3553082,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180894',3553083,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180894',3553084,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180894',3553085,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180894',3553086,'2394','364',87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180894',3553087,'2395','364',111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180894',3553088,'2396','364',162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180894',3553089,'2397','364',126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180894',3553090,'2398','364',162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180894',3553091,'2399','364',114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180894',3553092,'2400','364',102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180894',3553093,'2401','364',159776.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180894',3553094,'2402','364',89467.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180894',3553095,'2403','364',104349.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180894',3553096,'2404','364',90420.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180894',3553097,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180894',3553098,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180894',3553099,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180894',3553100,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180894',3553101,'2409','365',11245.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180894',3553102,'2410','365',88435.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180894',3553103,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180894',3553104,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180895',3553105,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180895',3553106,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180895',3553107,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180895',3553108,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180895',3553109,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180895',3553110,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180895',3553111,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180895',3553112,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180895',3553113,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180895',3553114,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180895',3553115,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180895',3553116,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180895',3553117,'2401','364',159776.99,159776.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180895',3553118,'2402','364',89467.57,89467.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180895',3553119,'2403','364',104349.57,104349.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180895',3553120,'2404','364',90420.77,90420.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180895',3553121,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180895',3553122,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180895',3553123,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180895',3553124,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180895',3553125,'2409','365',11245.08,11367.33,122.25,29951.25,0.00,0.00,0.00,0.00,0.00),('1','157','840','180895',3553126,'2410','365',88435.06,90084.77,1639.71,401728.95,0.00,0.00,10.00,0.00,0.00),('1','157','840','180895',3553127,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180895',3553128,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180898',3553155,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180898',3553156,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180898',3553157,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180898',3553158,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180898',3553159,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180898',3553160,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180898',3553161,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180898',3553162,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180898',3553163,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180898',3553164,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180898',3553165,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180898',3553166,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180898',3553167,'2401','364',159776.99,160718.88,941.89,153528.07,0.00,0.00,0.00,0.00,0.00),('1','157','838','180898',3553168,'2402','364',89467.57,90759.13,1291.56,210524.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','180898',3553169,'2403','364',104349.57,105316.00,966.43,157528.09,0.00,0.00,0.00,0.00,0.00),('1','157','838','180898',3553170,'2404','364',90420.77,91498.80,1078.03,175718.89,0.00,0.00,0.00,0.00,0.00),('1','157','839','180898',3553171,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180898',3553172,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180898',3553173,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180898',3553174,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180898',3553175,'2409','365',11367.33,12166.71,799.38,199845.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180898',3553176,'2410','365',90084.77,91279.49,1194.72,298680.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180898',3553177,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180898',3553178,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180899',3553179,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180899',3553180,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180899',3553181,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180899',3553182,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180899',3553183,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180899',3553184,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180899',3553185,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180899',3553186,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180899',3553187,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180899',3553188,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180899',3553189,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180899',3553190,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180899',3553191,'2401','364',160718.88,162497.82,1748.94,285077.22,0.00,0.00,30.00,0.00,0.00),('1','157','838','180899',3553192,'2402','364',90759.13,91843.51,1044.38,170233.94,0.00,0.00,40.00,0.00,0.00),('1','157','838','180899',3553193,'2403','364',105316.00,106653.90,1297.90,211557.70,0.00,0.00,40.00,0.00,0.00),('1','157','838','180899',3553194,'2404','364',91498.80,92818.76,1289.96,210263.48,0.00,0.00,30.00,0.00,0.00),('1','157','839','180899',3553195,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180899',3553196,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180899',3553197,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180899',3553198,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180899',3553199,'2409','365',12166.71,12234.31,47.60,11900.00,0.00,0.00,20.00,0.00,0.00),('1','157','840','180899',3553200,'2410','365',91279.49,91499.09,199.60,49900.00,0.00,0.00,20.00,0.00,0.00),('1','157','840','180899',3553201,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180899',3553202,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180975',3554601,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180975',3554602,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180975',3554603,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','180975',3554604,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180975',3554605,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180975',3554606,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180975',3554607,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','180975',3554608,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180975',3554609,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180975',3554610,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180975',3554611,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','180975',3554612,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','180975',3554613,'2401','364',162497.82,163663.89,1166.07,190069.41,0.00,0.00,0.00,0.00,0.00),('1','157','838','180975',3554614,'2402','364',91843.51,93716.47,1872.96,305292.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','180975',3554615,'2403','364',106653.90,108202.15,1548.25,252364.75,0.00,0.00,0.00,0.00,0.00),('1','157','838','180975',3554616,'2404','364',92818.76,93870.35,1051.59,171409.17,0.00,0.00,0.00,0.00,0.00),('1','157','839','180975',3554617,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180975',3554618,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180975',3554619,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','180975',3554620,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180975',3554621,'2409','365',12234.31,12234.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180975',3554622,'2410','365',91499.09,91813.64,314.55,78637.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','180975',3554623,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','180975',3554624,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181189',3558808,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181189',3558809,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181189',3558810,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181189',3558811,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181189',3558812,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181189',3558813,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181189',3558814,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181189',3558815,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181189',3558816,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181189',3558817,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181189',3558818,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181189',3558819,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181189',3558820,'2401','364',163663.89,164565.93,902.04,147032.52,0.00,0.00,0.00,0.00,0.00),('1','157','838','181189',3558821,'2402','364',93716.47,94569.15,852.68,138986.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','181189',3558822,'2403','364',108202.15,108726.86,524.71,85527.73,0.00,0.00,0.00,0.00,0.00),('1','157','838','181189',3558823,'2404','364',93870.35,94582.98,712.63,116158.69,0.00,0.00,0.00,0.00,0.00),('1','157','839','181189',3558824,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181189',3558825,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181189',3558826,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181189',3558827,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181189',3558828,'2409','365',12234.31,12234.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181189',3558829,'2410','365',91813.64,92803.03,989.39,247347.50,0.00,0.00,0.00,0.00,0.00),('1','157','840','181189',3558830,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181189',3558831,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181191',3558846,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181191',3558847,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181191',3558848,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181191',3558849,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181191',3558850,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181191',3558851,'2394','364',87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181191',3558852,'2395','364',111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181191',3558853,'2396','364',162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181191',3558854,'2397','364',126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181191',3558855,'2398','364',162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181191',3558856,'2399','364',114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181191',3558857,'2400','364',102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181191',3558858,'2401','364',164565.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181191',3558859,'2402','364',94569.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181191',3558860,'2403','364',108726.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181191',3558861,'2404','364',94582.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181191',3558862,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181191',3558863,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181191',3558864,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181191',3558865,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181191',3558866,'2409','365',12234.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181191',3558867,'2410','365',92803.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181191',3558868,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181191',3558869,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181554',3565467,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181554',3565468,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181554',3565469,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181554',3565470,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181554',3565471,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181554',3565472,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181554',3565473,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181554',3565474,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181554',3565475,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181554',3565476,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181554',3565477,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181554',3565478,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181554',3565479,'2401','364',164565.93,165251.39,685.46,111729.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','181554',3565480,'2402','364',94569.15,95940.72,1351.57,220305.91,0.00,0.00,20.00,0.00,0.00),('1','157','838','181554',3565481,'2403','364',108726.86,109515.67,788.81,128576.03,0.00,0.00,0.00,0.00,0.00),('1','157','838','181554',3565482,'2404','364',94582.98,96173.31,1590.33,259223.79,0.00,0.00,0.00,0.00,0.00),('1','157','839','181554',3565483,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181554',3565484,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181554',3565485,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181554',3565486,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181554',3565487,'2409','365',12234.31,12234.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181554',3565488,'2410','365',92803.03,94145.85,1342.82,342419.10,0.00,0.00,0.00,0.00,0.00),('1','157','840','181554',3565489,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181554',3565490,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181555',3565491,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181555',3565492,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181555',3565493,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181555',3565494,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181555',3565495,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181555',3565496,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181555',3565497,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181555',3565498,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181555',3565499,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181555',3565500,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181555',3565501,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181555',3565502,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181555',3565503,'2401','364',165251.39,166557.33,1305.94,212868.22,0.00,0.00,0.00,0.00,0.00),('1','157','838','181555',3565504,'2402','364',95940.72,97678.28,1737.56,283222.28,0.00,0.00,0.00,0.00,0.00),('1','157','838','181555',3565505,'2403','364',109515.67,110934.93,1419.26,231339.38,0.00,0.00,0.00,0.00,0.00),('1','157','838','181555',3565506,'2404','364',96173.31,98370.06,2196.75,358070.25,0.00,0.00,0.00,0.00,0.00),('1','157','839','181555',3565507,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181555',3565508,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181555',3565509,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181555',3565510,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181555',3565511,'2409','365',12234.31,12288.23,53.92,13749.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','181555',3565512,'2410','365',94145.85,95336.52,1190.67,303620.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','181555',3565513,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181555',3565514,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181557',3565527,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181557',3565528,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181557',3565529,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','181557',3565530,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181557',3565531,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181557',3565532,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181557',3565533,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','181557',3565534,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181557',3565535,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181557',3565536,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181557',3565537,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','181557',3565538,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','181557',3565539,'2401','364',166557.33,167812.16,1254.83,204537.29,0.00,0.00,0.00,0.00,0.00),('1','157','838','181557',3565540,'2402','364',97678.28,98777.43,1099.15,179161.45,0.00,0.00,0.00,0.00,0.00),('1','157','838','181557',3565541,'2403','364',110934.93,112002.89,1067.96,174077.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','181557',3565542,'2404','364',98370.06,99204.21,834.15,135966.45,0.00,0.00,0.00,0.00,0.00),('1','157','839','181557',3565543,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181557',3565544,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181557',3565545,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','181557',3565546,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181557',3565547,'2409','365',12288.23,12288.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181557',3565548,'2410','365',95336.52,95432.69,96.17,24523.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','181557',3565549,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','181557',3565550,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182078',3575011,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182078',3575012,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182078',3575013,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182078',3575014,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182078',3575015,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182078',3575016,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182078',3575017,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182078',3575018,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182078',3575019,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182078',3575020,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182078',3575021,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182078',3575022,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182078',3575023,'2401','364',167812.16,169091.57,1249.41,203653.83,0.00,0.00,30.00,0.00,0.00),('1','157','838','182078',3575024,'2402','364',98777.43,98777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182078',3575025,'2403','364',112002.89,112159.29,126.40,20603.20,0.00,0.00,30.00,0.00,0.00),('1','157','838','182078',3575026,'2404','364',99204.21,99240.40,6.19,1008.97,0.00,0.00,30.00,0.00,0.00),('1','157','839','182078',3575027,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182078',3575028,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182078',3575029,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182078',3575030,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182078',3575031,'2409','365',12288.23,12288.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182078',3575032,'2410','365',95432.69,97074.79,1622.10,413635.50,0.00,0.00,20.00,0.00,0.00),('1','157','840','182078',3575033,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182078',3575034,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182079',3575035,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182079',3575036,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182079',3575037,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182079',3575038,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182079',3575039,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182079',3575040,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182079',3575041,'2395','364',111363.74,111363.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182079',3575042,'2396','364',162793.00,162793.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182079',3575043,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182079',3575044,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182079',3575045,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182079',3575046,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182079',3575047,'2401','364',169091.57,172469.70,3358.13,547375.19,0.00,0.00,20.00,0.00,0.00),('1','157','838','182079',3575048,'2402','364',98777.43,101418.38,2620.95,427214.85,0.00,0.00,20.00,0.00,0.00),('1','157','838','182079',3575049,'2403','364',112159.29,115483.92,3304.63,538654.69,0.00,0.00,20.00,0.00,0.00),('1','157','838','182079',3575050,'2404','364',99240.40,101986.51,2726.11,444355.93,0.00,0.00,20.00,0.00,0.00),('1','157','839','182079',3575051,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182079',3575052,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182079',3575053,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182079',3575054,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182079',3575055,'2409','365',12288.23,12440.19,141.96,36199.80,0.00,0.00,10.00,0.00,0.00),('1','157','840','182079',3575056,'2410','365',97074.79,98673.84,1599.05,407757.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','182079',3575057,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182079',3575058,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182085',3575160,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182085',3575161,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182085',3575162,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182085',3575163,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182085',3575164,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182085',3575165,'2394','364',87392.42,87392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182085',3575166,'2395','364',111363.74,112659.65,1295.91,211233.33,0.00,0.00,0.00,0.00,0.00),('1','157','836','182085',3575167,'2396','364',162793.00,164206.59,1413.59,230415.17,0.00,0.00,0.00,0.00,0.00),('1','157','837','182085',3575168,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182085',3575169,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182085',3575170,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182085',3575171,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182085',3575172,'2401','364',172469.70,173217.07,747.37,121821.31,0.00,0.00,0.00,0.00,0.00),('1','157','838','182085',3575173,'2402','364',101418.38,102077.74,659.36,107475.68,0.00,0.00,0.00,0.00,0.00),('1','157','838','182085',3575174,'2403','364',115483.92,116262.88,778.96,126970.48,0.00,0.00,0.00,0.00,0.00),('1','157','838','182085',3575175,'2404','364',101986.51,102774.39,787.88,128424.44,0.00,0.00,0.00,0.00,0.00),('1','157','839','182085',3575176,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182085',3575177,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182085',3575178,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182085',3575179,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182085',3575180,'2409','365',12440.19,12440.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182085',3575181,'2410','365',98673.84,99360.91,687.07,175202.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','182085',3575182,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182085',3575183,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182632',3584875,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182632',3584876,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182632',3584877,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182632',3584878,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182632',3584879,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182632',3584880,'2394','364',87392.42,90337.81,2935.39,478468.57,0.00,0.00,10.00,0.00,0.00),('1','157','836','182632',3584881,'2395','364',112659.65,116211.64,3551.99,578974.37,0.00,0.00,0.00,0.00,0.00),('1','157','836','182632',3584882,'2396','364',164206.59,167947.15,3720.56,606451.28,0.00,0.00,20.00,0.00,0.00),('1','157','837','182632',3584883,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182632',3584884,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182632',3584885,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182632',3584886,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182632',3584887,'2401','364',173217.07,173217.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182632',3584888,'2402','364',102077.74,102077.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182632',3584889,'2403','364',116262.88,116262.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182632',3584890,'2404','364',102774.39,102774.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182632',3584891,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182632',3584892,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182632',3584893,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182632',3584894,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182632',3584895,'2409','365',12440.19,12559.80,119.61,30500.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','182632',3584896,'2410','365',99360.91,101865.98,2505.07,638792.85,0.00,0.00,0.00,0.00,0.00),('1','157','840','182632',3584897,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182632',3584898,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182633',3584899,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182633',3584900,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182633',3584901,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182633',3584902,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182633',3584903,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182633',3584904,'2394','364',90337.81,91216.11,878.30,143162.90,0.00,0.00,0.00,0.00,0.00),('1','157','836','182633',3584905,'2395','364',116211.64,116544.55,332.91,54264.33,0.00,0.00,0.00,0.00,0.00),('1','157','836','182633',3584906,'2396','364',167947.15,167947.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182633',3584907,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182633',3584908,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182633',3584909,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182633',3584910,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182633',3584911,'2401','364',173217.07,173217.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182633',3584912,'2402','364',102077.74,102077.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182633',3584913,'2403','364',116262.88,116262.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182633',3584914,'2404','364',102774.39,102774.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182633',3584915,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182633',3584916,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182633',3584917,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182633',3584918,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182633',3584919,'2409','365',12559.80,12559.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182633',3584920,'2410','365',101865.98,103749.58,1883.60,480318.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182633',3584921,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182633',3584922,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182891',3589668,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182891',3589669,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182891',3589670,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182891',3589671,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182891',3589672,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182891',3589673,'2394','364',91216.11,91402.08,185.97,30313.11,0.00,0.00,0.00,0.00,0.00),('1','157','836','182891',3589674,'2395','364',116544.55,116545.61,1.06,172.78,0.00,0.00,0.00,0.00,0.00),('1','157','836','182891',3589675,'2396','364',167947.15,168581.34,614.19,100112.97,0.00,0.00,20.00,0.00,0.00),('1','157','837','182891',3589676,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182891',3589677,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182891',3589678,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182891',3589679,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182891',3589680,'2401','364',173217.07,173900.81,663.74,108189.62,0.00,0.00,20.00,0.00,0.00),('1','157','838','182891',3589681,'2402','364',102077.74,102815.43,737.69,120243.47,0.00,0.00,0.00,0.00,0.00),('1','157','838','182891',3589682,'2403','364',116262.88,116268.37,5.49,894.87,0.00,0.00,0.00,0.00,0.00),('1','157','838','182891',3589683,'2404','364',102774.39,103729.09,934.70,152356.10,0.00,0.00,20.00,0.00,0.00),('1','157','839','182891',3589684,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182891',3589685,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182891',3589686,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182891',3589687,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182891',3589688,'2409','365',12559.80,12593.14,33.34,8501.70,0.00,0.00,0.00,0.00,0.00),('1','157','840','182891',3589689,'2410','365',103749.58,105376.12,1606.54,409667.70,0.00,0.00,20.00,0.00,0.00),('1','157','840','182891',3589690,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182891',3589691,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182893',3589705,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182893',3589706,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182893',3589707,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182893',3589708,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182893',3589709,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182893',3589710,'2394','364',91402.08,91402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182893',3589711,'2395','364',116545.61,116545.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182893',3589712,'2396','364',168581.34,168581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182893',3589713,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182893',3589714,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182893',3589715,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182893',3589716,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182893',3589717,'2401','364',173900.81,175107.16,1206.35,196635.05,0.00,0.00,0.00,0.00,0.00),('1','157','838','182893',3589718,'2402','364',102815.43,104313.27,1497.84,244147.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','182893',3589719,'2403','364',116268.37,117321.83,1053.46,171713.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','182893',3589720,'2404','364',103729.09,105424.43,1695.34,276340.42,0.00,0.00,0.00,0.00,0.00),('1','157','839','182893',3589721,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182893',3589722,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182893',3589723,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182893',3589724,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182893',3589725,'2409','365',12593.14,12593.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182893',3589726,'2410','365',105376.12,105463.58,87.46,22302.30,0.00,0.00,0.00,0.00,0.00),('1','157','840','182893',3589727,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182893',3589728,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182966',3591143,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182966',3591144,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182966',3591145,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','182966',3591146,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182966',3591147,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182966',3591148,'2394','364',91402.08,91402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182966',3591149,'2395','364',116545.61,116545.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','182966',3591150,'2396','364',168581.34,168581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182966',3591151,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182966',3591152,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182966',3591153,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','182966',3591154,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','182966',3591155,'2401','364',175107.16,176561.21,1434.05,233750.15,0.00,0.00,20.00,0.00,0.00),('1','157','838','182966',3591156,'2402','364',104313.27,105618.37,1305.10,212731.30,0.00,0.00,0.00,0.00,0.00),('1','157','838','182966',3591157,'2403','364',117321.83,118518.51,1196.68,195058.84,0.00,0.00,0.00,0.00,0.00),('1','157','838','182966',3591158,'2404','364',105424.43,106402.69,978.26,159456.38,0.00,0.00,0.00,0.00,0.00),('1','157','839','182966',3591159,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182966',3591160,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182966',3591161,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','182966',3591162,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182966',3591163,'2409','365',12593.14,12593.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182966',3591164,'2410','365',105463.58,106173.38,709.80,180999.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182966',3591165,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','182966',3591166,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183135',3594036,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183135',3594037,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183135',3594038,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183135',3594039,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183135',3594040,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183135',3594041,'2394','364',91402.08,91402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183135',3594042,'2395','364',116545.61,116545.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183135',3594043,'2396','364',168581.34,168581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183135',3594044,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183135',3594045,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183135',3594046,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183135',3594047,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183135',3594048,'2401','364',176561.21,178007.87,1436.66,234175.58,0.00,0.00,10.00,0.00,0.00),('1','157','838','183135',3594049,'2402','364',105618.37,106594.22,975.85,159063.55,0.00,0.00,0.00,0.00,0.00),('1','157','838','183135',3594050,'2403','364',118518.51,119514.02,995.51,162268.13,0.00,0.00,0.00,0.00,0.00),('1','157','838','183135',3594051,'2404','364',106402.69,107407.10,1004.41,163718.83,0.00,0.00,0.00,0.00,0.00),('1','157','839','183135',3594052,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183135',3594053,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183135',3594054,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183135',3594055,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183135',3594056,'2409','365',12593.14,12593.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183135',3594057,'2410','365',106173.38,106204.75,31.37,7999.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','183135',3594058,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183135',3594059,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183138',3594112,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183138',3594113,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183138',3594114,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183138',3594115,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183138',3594116,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183138',3594117,'2394','364',91402.08,91402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183138',3594118,'2395','364',116545.61,116545.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183138',3594119,'2396','364',168581.34,168581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183138',3594120,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183138',3594121,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183138',3594122,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183138',3594123,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183138',3594124,'2401','364',178007.87,179717.56,1709.69,278679.47,0.00,0.00,0.00,0.00,0.00),('1','157','838','183138',3594125,'2402','364',106594.22,108006.06,1411.84,230129.92,0.00,0.00,0.00,0.00,0.00),('1','157','838','183138',3594126,'2403','364',119514.02,121144.48,1630.46,265764.98,0.00,0.00,0.00,0.00,0.00),('1','157','838','183138',3594127,'2404','364',107407.10,108573.03,1165.93,190046.59,0.00,0.00,0.00,0.00,0.00),('1','157','839','183138',3594128,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183138',3594129,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183138',3594130,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183138',3594131,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183138',3594132,'2409','365',12593.14,12748.03,154.89,39496.95,0.00,0.00,0.00,0.00,0.00),('1','157','840','183138',3594133,'2410','365',106204.75,107770.23,1565.48,399197.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','183138',3594134,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183138',3594135,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183142',3594228,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183142',3594229,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183142',3594230,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183142',3594231,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183142',3594232,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183142',3594233,'2394','364',91402.08,91402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183142',3594234,'2395','364',116545.61,116545.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183142',3594235,'2396','364',168581.34,168581.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183142',3594236,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183142',3594237,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183142',3594238,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183142',3594239,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183142',3594240,'2401','364',179717.56,181418.75,1701.19,277293.97,0.00,0.00,0.00,0.00,0.00),('1','157','838','183142',3594241,'2402','364',108006.06,109407.70,1401.64,228467.32,0.00,0.00,0.00,0.00,0.00),('1','157','838','183142',3594242,'2403','364',121144.48,122502.34,1357.86,221331.18,0.00,0.00,0.00,0.00,0.00),('1','157','838','183142',3594243,'2404','364',108573.03,109892.05,1319.02,215000.26,0.00,0.00,0.00,0.00,0.00),('1','157','839','183142',3594244,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183142',3594245,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183142',3594246,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183142',3594247,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183142',3594248,'2409','365',12748.03,12818.62,70.59,18000.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','183142',3594249,'2410','365',107770.23,107925.44,155.21,39578.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','183142',3594250,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183142',3594251,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183490',3600236,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183490',3600237,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183490',3600238,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183490',3600239,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183490',3600240,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183490',3600241,'2394','364',91402.08,92840.73,1428.65,232869.95,0.00,0.00,10.00,0.00,0.00),('1','157','836','183490',3600242,'2395','364',116545.61,118014.96,1459.35,237874.05,0.00,0.00,10.00,0.00,0.00),('1','157','836','183490',3600243,'2396','364',168581.34,170219.97,1628.63,265466.69,0.00,0.00,10.00,0.00,0.00),('1','157','837','183490',3600244,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183490',3600245,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183490',3600246,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183490',3600247,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183490',3600248,'2401','364',181418.75,181768.91,340.16,55446.08,0.00,0.00,10.00,0.00,0.00),('1','157','838','183490',3600249,'2402','364',109407.70,109713.68,295.98,48244.74,0.00,0.00,10.00,0.00,0.00),('1','157','838','183490',3600250,'2403','364',122502.34,122774.07,261.73,42661.99,0.00,0.00,10.00,0.00,0.00),('1','157','838','183490',3600251,'2404','364',109892.05,110068.68,166.63,27160.69,0.00,0.00,10.00,0.00,0.00),('1','157','839','183490',3600252,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183490',3600253,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183490',3600254,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183490',3600255,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183490',3600256,'2409','365',12818.62,12842.15,13.53,3450.15,0.00,0.00,10.00,0.00,0.00),('1','157','840','183490',3600257,'2410','365',107925.44,109237.02,1301.58,331902.90,0.00,0.00,10.00,0.00,0.00),('1','157','840','183490',3600258,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183490',3600259,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183496',3600352,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183496',3600353,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183496',3600354,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183496',3600355,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183496',3600356,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183496',3600357,'2394','364',92840.73,94747.49,1886.76,307541.88,0.00,0.00,20.00,0.00,0.00),('1','157','836','183496',3600358,'2395','364',118014.96,120102.88,2087.92,340330.96,0.00,0.00,0.00,0.00,0.00),('1','157','836','183496',3600359,'2396','364',170219.97,171434.04,1199.07,195448.41,0.00,0.00,15.00,0.00,0.00),('1','157','837','183496',3600360,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183496',3600361,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183496',3600362,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183496',3600363,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183496',3600364,'2401','364',181768.91,181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183496',3600365,'2402','364',109713.68,109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183496',3600366,'2403','364',122774.07,122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183496',3600367,'2404','364',110068.68,110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183496',3600368,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183496',3600369,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183496',3600370,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183496',3600371,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183496',3600372,'2409','365',12842.15,12842.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183496',3600373,'2410','365',109237.02,109444.80,207.78,52983.90,0.00,0.00,0.00,0.00,0.00),('1','157','840','183496',3600374,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183496',3600375,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183683',3603892,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183683',3603893,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183683',3603894,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183683',3603895,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183683',3603896,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183683',3603897,'2394','364',94747.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183683',3603898,'2395','364',120102.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183683',3603899,'2396','364',171434.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183683',3603900,'2397','364',126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183683',3603901,'2398','364',162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183683',3603902,'2399','364',114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183683',3603903,'2400','364',102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183683',3603904,'2401','364',181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183683',3603905,'2402','364',109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183683',3603906,'2403','364',122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183683',3603907,'2404','364',110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183683',3603908,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183683',3603909,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183683',3603910,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183683',3603911,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183683',3603912,'2409','365',12842.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183683',3603913,'2410','365',109444.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183683',3603914,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183683',3603915,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183686',3603936,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183686',3603937,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183686',3603938,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183686',3603939,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183686',3603940,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183686',3603941,'2394','364',94747.49,97365.33,2617.84,426707.92,0.00,0.00,0.00,0.00,0.00),('1','157','836','183686',3603942,'2395','364',120102.88,121463.35,1360.47,221756.61,0.00,0.00,0.00,0.00,0.00),('1','157','836','183686',3603943,'2396','364',171434.04,173192.95,1758.91,286702.33,0.00,0.00,0.00,0.00,0.00),('1','157','837','183686',3603944,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183686',3603945,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183686',3603946,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183686',3603947,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183686',3603948,'2401','364',181768.91,181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183686',3603949,'2402','364',109713.68,109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183686',3603950,'2403','364',122774.07,122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183686',3603951,'2404','364',110068.68,110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183686',3603952,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183686',3603953,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183686',3603954,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183686',3603955,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183686',3603956,'2409','365',12842.15,12920.58,78.43,19999.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','183686',3603957,'2410','365',109444.80,111683.52,2238.72,570873.60,0.00,0.00,0.00,0.00,0.00),('1','157','840','183686',3603958,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183686',3603959,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183690',3603986,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183690',3603987,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183690',3603988,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183690',3603989,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183690',3603990,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183690',3603991,'2394','364',97365.33,100077.89,2692.56,438887.28,0.00,0.00,20.00,0.00,0.00),('1','157','836','183690',3603992,'2395','364',121463.35,122800.61,1337.26,217973.38,0.00,0.00,0.00,0.00,0.00),('1','157','836','183690',3603993,'2396','364',173192.95,174949.90,1756.95,286382.85,0.00,0.00,0.00,0.00,0.00),('1','157','837','183690',3603994,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183690',3603995,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183690',3603996,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183690',3603997,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183690',3603998,'2401','364',181768.91,181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183690',3603999,'2402','364',109713.68,109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183690',3604000,'2403','364',122774.07,122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183690',3604001,'2404','364',110068.68,110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183690',3604002,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183690',3604003,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183690',3604004,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183690',3604005,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183690',3604006,'2409','365',12920.58,12920.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183690',3604007,'2410','365',111683.52,113178.22,1489.70,379873.50,0.00,0.00,5.00,0.00,0.00),('1','157','840','183690',3604008,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183690',3604009,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183709',3604345,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183709',3604346,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183709',3604347,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183709',3604348,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183709',3604349,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183709',3604350,'2394','364',100077.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183709',3604351,'2395','364',122800.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183709',3604352,'2396','364',174949.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183709',3604353,'2397','364',126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183709',3604354,'2398','364',162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183709',3604355,'2399','364',114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183709',3604356,'2400','364',102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183709',3604357,'2401','364',181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183709',3604358,'2402','364',109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183709',3604359,'2403','364',122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183709',3604360,'2404','364',110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183709',3604361,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183709',3604362,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183709',3604363,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183709',3604364,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183709',3604365,'2409','365',12920.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183709',3604366,'2410','365',113178.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183709',3604367,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183709',3604368,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183948',3608855,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183948',3608856,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183948',3608857,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','183948',3608858,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183948',3608859,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','183948',3608860,'2394','364',100077.89,102197.45,2119.56,345488.28,0.00,0.00,0.00,0.00,0.00),('1','157','836','183948',3608861,'2395','364',122800.61,124677.29,1876.68,305898.84,0.00,0.00,0.00,0.00,0.00),('1','157','836','183948',3608862,'2396','364',174949.90,177571.46,2621.56,427314.28,0.00,0.00,0.00,0.00,0.00),('1','157','837','183948',3608863,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183948',3608864,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183948',3608865,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','183948',3608866,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183948',3608867,'2401','364',181768.91,181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183948',3608868,'2402','364',109713.68,109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183948',3608869,'2403','364',122774.07,122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','183948',3608870,'2404','364',110068.68,110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183948',3608871,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183948',3608872,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183948',3608873,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','183948',3608874,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183948',3608875,'2409','365',12920.58,13056.62,136.04,34690.20,0.00,0.00,0.00,0.00,0.00),('1','157','840','183948',3608876,'2410','365',113178.22,114311.43,1113.21,283868.55,0.00,0.00,20.00,0.00,0.00),('1','157','840','183948',3608877,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','183948',3608878,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184181',3613028,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184181',3613029,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184181',3613030,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184181',3613031,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184181',3613032,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184181',3613033,'2394','364',102197.45,103642.32,1425.16,232301.08,0.00,0.00,19.71,0.00,0.00),('1','157','836','184181',3613034,'2395','364',124677.29,125130.92,453.63,73941.69,0.00,0.00,0.00,0.00,0.00),('1','157','836','184181',3613035,'2396','364',177571.46,177829.99,258.53,42140.39,0.00,0.00,0.00,0.00,0.00),('1','157','837','184181',3613036,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184181',3613037,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184181',3613038,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184181',3613039,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184181',3613040,'2401','364',181768.91,181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184181',3613041,'2402','364',109713.68,109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184181',3613042,'2403','364',122774.07,122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184181',3613043,'2404','364',110068.68,110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184181',3613044,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184181',3613045,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184181',3613046,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184181',3613047,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184181',3613048,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184181',3613049,'2410','365',114311.43,117421.99,3110.56,824298.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','184181',3613050,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184181',3613051,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184186',3613182,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184186',3613183,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184186',3613184,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184186',3613185,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184186',3613186,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184186',3613187,'2394','364',103642.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184186',3613188,'2395','364',125130.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184186',3613189,'2396','364',177829.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184186',3613190,'2397','364',126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184186',3613191,'2398','364',162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184186',3613192,'2399','364',114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184186',3613193,'2400','364',102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184186',3613194,'2401','364',181768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184186',3613195,'2402','364',109713.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184186',3613196,'2403','364',122774.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184186',3613197,'2404','364',110068.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184186',3613198,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184186',3613199,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184186',3613200,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184186',3613201,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184186',3613202,'2409','365',13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184186',3613203,'2410','365',117421.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184186',3613204,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184186',3613205,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184416',3617193,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184416',3617194,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184416',3617195,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184416',3617196,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184416',3617197,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184416',3617198,'2394','364',103642.32,103642.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184416',3617199,'2395','364',125130.92,125130.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184416',3617200,'2396','364',177829.99,177829.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184416',3617201,'2397','364',126477.71,126477.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184416',3617202,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184416',3617203,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184416',3617204,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184416',3617205,'2401','364',181768.91,185076.64,3307.73,545775.45,0.00,0.00,0.00,0.00,0.00),('1','157','838','184416',3617206,'2402','364',109713.68,112638.24,2924.56,482552.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','184416',3617207,'2403','364',122774.07,126010.03,3235.96,533933.40,0.00,0.00,0.00,0.00,0.00),('1','157','838','184416',3617208,'2404','364',110068.68,113620.89,3552.21,586114.65,0.00,0.00,0.00,0.00,0.00),('1','157','839','184416',3617209,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184416',3617210,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184416',3617211,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184416',3617212,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184416',3617213,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184416',3617214,'2410','365',117421.99,117772.54,350.55,92895.75,0.00,0.00,0.00,0.00,0.00),('1','157','840','184416',3617215,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184416',3617216,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184420',3617233,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184420',3617234,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184420',3617235,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184420',3617236,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184420',3617237,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184420',3617238,'2394','364',103642.32,104384.43,742.11,122448.15,0.00,0.00,0.00,0.00,0.00),('1','157','836','184420',3617239,'2395','364',125130.92,125629.21,498.29,82217.85,0.00,0.00,0.00,0.00,0.00),('1','157','836','184420',3617240,'2396','364',177829.99,178274.56,444.57,73354.05,0.00,0.00,0.00,0.00,0.00),('1','157','837','184420',3617241,'2397','364',126477.71,126783.47,285.76,47150.40,0.00,0.00,20.00,0.00,0.00),('1','157','837','184420',3617242,'2398','364',162657.02,162657.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184420',3617243,'2399','364',114802.62,114802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184420',3617244,'2400','364',102455.02,102455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184420',3617245,'2401','364',185076.64,185956.73,880.09,145214.85,0.00,0.00,0.00,0.00,0.00),('1','157','838','184420',3617246,'2402','364',112638.24,113360.86,722.62,119232.30,0.00,0.00,0.00,0.00,0.00),('1','157','838','184420',3617247,'2403','364',126010.03,126189.85,179.82,29670.30,0.00,0.00,0.00,0.00,0.00),('1','157','838','184420',3617248,'2404','364',113620.89,113812.00,191.11,31533.15,0.00,0.00,0.00,0.00,0.00),('1','157','839','184420',3617249,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184420',3617250,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184420',3617251,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184420',3617252,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184420',3617253,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184420',3617254,'2410','365',117772.54,117885.17,112.63,29846.95,0.00,0.00,0.00,0.00,0.00),('1','157','840','184420',3617255,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184420',3617256,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184421',3617257,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184421',3617258,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184421',3617259,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184421',3617260,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184421',3617261,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184421',3617262,'2394','364',104384.43,106081.61,1697.18,280034.70,0.00,0.00,0.00,0.00,0.00),('1','157','836','184421',3617263,'2395','364',125629.21,126809.10,1179.89,194681.85,0.00,0.00,0.00,0.00,0.00),('1','157','836','184421',3617264,'2396','364',178274.56,179075.77,801.21,132199.65,0.00,0.00,0.00,0.00,0.00),('1','157','837','184421',3617265,'2397','364',126783.47,128161.36,1377.89,227351.85,0.00,0.00,0.00,0.00,0.00),('1','157','837','184421',3617266,'2398','364',162657.02,163763.66,1106.64,182595.60,0.00,0.00,0.00,0.00,0.00),('1','157','837','184421',3617267,'2399','364',114802.62,114804.03,0.00,0.00,0.00,0.00,1.41,0.00,0.00),('1','157','837','184421',3617268,'2400','364',102455.02,103791.94,1336.92,220591.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','184421',3617269,'2401','364',185956.73,185956.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184421',3617270,'2402','364',113360.86,113360.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184421',3617271,'2403','364',126189.85,126189.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184421',3617272,'2404','364',113812.00,113812.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184421',3617273,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184421',3617274,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184421',3617275,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184421',3617276,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184421',3617277,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184421',3617278,'2410','365',117885.17,119454.78,1569.61,415946.65,0.00,0.00,0.00,0.00,0.00),('1','157','840','184421',3617279,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184421',3617280,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184424',3617323,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184424',3617324,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184424',3617325,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184424',3617326,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184424',3617327,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184424',3617328,'2394','364',106081.61,106705.00,623.39,102859.35,0.00,0.00,0.00,0.00,0.00),('1','157','836','184424',3617329,'2395','364',126809.10,127850.44,1041.34,171821.10,0.00,0.00,0.00,0.00,0.00),('1','157','836','184424',3617330,'2396','364',179075.77,179879.76,783.99,129358.35,0.00,0.00,20.00,0.00,0.00),('1','157','837','184424',3617331,'2397','364',128161.36,128512.69,351.33,57969.45,0.00,0.00,0.00,0.00,0.00),('1','157','837','184424',3617332,'2398','364',163763.66,165274.86,1496.20,246873.00,0.00,0.00,15.00,0.00,0.00),('1','157','837','184424',3617333,'2399','364',114804.03,115576.24,772.21,127414.65,0.00,0.00,0.00,0.00,0.00),('1','157','837','184424',3617334,'2400','364',103791.94,103843.55,51.61,8515.65,0.00,0.00,0.00,0.00,0.00),('1','157','838','184424',3617335,'2401','364',185956.73,185956.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184424',3617336,'2402','364',113360.86,113360.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184424',3617337,'2403','364',126189.85,126189.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184424',3617338,'2404','364',113812.00,113812.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184424',3617339,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184424',3617340,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184424',3617341,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184424',3617342,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184424',3617343,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184424',3617344,'2410','365',119454.78,120480.45,1025.67,271802.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','184424',3617345,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184424',3617346,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184740',3622972,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184740',3622973,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184740',3622974,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184740',3622975,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184740',3622976,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184740',3622977,'2394','364',106705.00,107678.57,973.57,160639.05,0.00,0.00,0.00,0.00,0.00),('1','157','836','184740',3622978,'2395','364',127850.44,128337.46,487.02,80358.30,0.00,0.00,0.00,0.00,0.00),('1','157','836','184740',3622979,'2396','364',179879.76,180172.35,292.59,48277.35,0.00,0.00,0.00,0.00,0.00),('1','157','837','184740',3622980,'2397','364',128512.69,129079.30,566.61,93490.65,0.00,0.00,0.00,0.00,0.00),('1','157','837','184740',3622981,'2398','364',165274.86,166386.98,1112.12,183499.80,0.00,0.00,0.00,0.00,0.00),('1','157','837','184740',3622982,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184740',3622983,'2400','364',103843.55,104480.14,636.59,105037.35,0.00,0.00,0.00,0.00,0.00),('1','157','838','184740',3622984,'2401','364',185956.73,186446.48,489.75,80808.75,0.00,0.00,0.00,0.00,0.00),('1','157','838','184740',3622985,'2402','364',113360.86,113360.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184740',3622986,'2403','364',126189.85,126189.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184740',3622987,'2404','364',113812.00,114240.35,428.35,70677.75,0.00,0.00,0.00,0.00,0.00),('1','157','839','184740',3622988,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184740',3622989,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184740',3622990,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184740',3622991,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184740',3622992,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184740',3622993,'2410','365',120480.45,120944.98,464.53,123100.45,0.00,0.00,0.00,0.00,0.00),('1','157','840','184740',3622994,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184740',3622995,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184755',3623267,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184755',3623268,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184755',3623269,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','184755',3623270,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184755',3623271,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','184755',3623272,'2394','364',107678.57,109121.19,1442.62,238032.30,0.00,0.00,0.00,0.00,0.00),('1','157','836','184755',3623273,'2395','364',128337.46,129160.87,823.41,135862.65,0.00,0.00,0.00,0.00,0.00),('1','157','836','184755',3623274,'2396','364',180172.35,180172.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184755',3623275,'2397','364',129079.30,129079.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184755',3623276,'2398','364',166386.98,167626.16,1239.18,204464.70,0.00,0.00,0.00,0.00,0.00),('1','157','837','184755',3623277,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','184755',3623278,'2400','364',104480.14,105084.00,603.86,99636.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','184755',3623279,'2401','364',186446.48,186446.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184755',3623280,'2402','364',113360.86,114006.73,625.87,103268.55,0.00,0.00,20.00,0.00,0.00),('1','157','838','184755',3623281,'2403','364',126189.85,126189.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','184755',3623282,'2404','364',114240.35,114967.70,727.35,120012.75,0.00,0.00,0.00,0.00,0.00),('1','157','839','184755',3623283,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184755',3623284,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184755',3623285,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','184755',3623286,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184755',3623287,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184755',3623288,'2410','365',120944.98,121725.65,780.67,206877.55,0.00,0.00,0.00,0.00,0.00),('1','157','840','184755',3623289,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','184755',3623290,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185060',3628710,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185060',3628711,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185060',3628712,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185060',3628713,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185060',3628714,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185060',3628715,'2394','364',109121.19,109831.76,710.57,117244.05,0.00,0.00,0.00,0.00,0.00),('1','157','836','185060',3628716,'2395','364',129160.87,130173.94,1013.07,167156.55,0.00,0.00,0.00,0.00,0.00),('1','157','836','185060',3628717,'2396','364',180172.35,180172.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185060',3628718,'2397','364',129079.30,129811.04,731.74,120737.10,0.00,0.00,0.00,0.00,0.00),('1','157','837','185060',3628719,'2398','364',167626.16,168464.78,838.62,138372.30,0.00,0.00,0.00,0.00,0.00),('1','157','837','185060',3628720,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185060',3628721,'2400','364',105084.00,105800.86,716.86,118281.90,0.00,0.00,0.00,0.00,0.00),('1','157','838','185060',3628722,'2401','364',186446.48,187303.40,856.92,141391.80,0.00,0.00,0.00,0.00,0.00),('1','157','838','185060',3628723,'2402','364',114006.73,114215.84,209.11,34503.15,0.00,0.00,0.00,0.00,0.00),('1','157','838','185060',3628724,'2403','364',126189.85,126189.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185060',3628725,'2404','364',114967.70,115496.97,529.27,87329.55,0.00,0.00,0.00,0.00,0.00),('1','157','839','185060',3628726,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185060',3628727,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185060',3628728,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185060',3628729,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185060',3628730,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185060',3628731,'2410','365',121725.65,122959.01,1233.36,326840.40,0.00,0.00,0.00,0.00,0.00),('1','157','840','185060',3628732,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185060',3628733,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185066',3628848,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185066',3628849,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185066',3628850,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185066',3628851,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185066',3628852,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185066',3628853,'2394','364',109831.76,109992.45,160.69,26513.85,0.00,0.00,0.00,0.00,0.00),('1','157','836','185066',3628854,'2395','364',130173.94,130973.34,799.40,131901.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185066',3628855,'2396','364',180172.35,180378.87,186.52,30775.80,0.00,0.00,20.00,0.00,0.00),('1','157','837','185066',3628856,'2397','364',129811.04,129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185066',3628857,'2398','364',168464.78,169567.11,1082.33,178584.45,0.00,0.00,20.00,0.00,0.00),('1','157','837','185066',3628858,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185066',3628859,'2400','364',105800.86,106476.54,675.68,111487.20,0.00,0.00,0.00,0.00,0.00),('1','157','838','185066',3628860,'2401','364',187303.40,187841.78,538.38,88832.70,0.00,0.00,0.00,0.00,0.00),('1','157','838','185066',3628861,'2402','364',114215.84,114969.41,753.57,124339.05,0.00,0.00,0.00,0.00,0.00),('1','157','838','185066',3628862,'2403','364',126189.85,126751.62,561.77,92692.05,0.00,0.00,0.00,0.00,0.00),('1','157','838','185066',3628863,'2404','364',115496.97,116486.80,989.83,163321.95,0.00,0.00,0.00,0.00,0.00),('1','157','839','185066',3628864,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185066',3628865,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185066',3628866,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185066',3628867,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185066',3628868,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185066',3628869,'2410','365',122959.01,124702.16,1723.15,456634.75,0.00,0.00,20.00,0.00,0.00),('1','157','840','185066',3628870,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185066',3628871,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185070',3628941,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185070',3628942,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185070',3628943,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185070',3628944,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185070',3628945,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185070',3628946,'2394','364',109992.45,109992.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185070',3628947,'2395','364',130973.34,130973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185070',3628948,'2396','364',180378.87,180378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185070',3628949,'2397','364',129811.04,129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185070',3628950,'2398','364',169567.11,169567.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185070',3628951,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185070',3628952,'2400','364',106476.54,106476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185070',3628953,'2401','364',187841.78,188261.57,419.79,69265.35,0.00,0.00,0.00,0.00,0.00),('1','157','838','185070',3628954,'2402','364',114969.41,116522.46,1553.05,256253.25,0.00,0.00,0.00,0.00,0.00),('1','157','838','185070',3628955,'2403','364',126751.62,127640.11,868.49,143300.85,0.00,0.00,20.00,0.00,0.00),('1','157','838','185070',3628956,'2404','364',116486.80,117402.18,915.38,151037.70,0.00,0.00,0.00,0.00,0.00),('1','157','839','185070',3628957,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185070',3628958,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185070',3628959,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185070',3628960,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185070',3628961,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185070',3628962,'2410','365',124702.16,125685.55,983.39,260598.35,0.00,0.00,0.00,0.00,0.00),('1','157','840','185070',3628963,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185070',3628964,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185071',3628965,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185071',3628966,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185071',3628967,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185071',3628968,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185071',3628969,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185071',3628970,'2394','364',109992.45,109992.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185071',3628971,'2395','364',130973.34,130973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185071',3628972,'2396','364',180378.87,180378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185071',3628973,'2397','364',129811.04,129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185071',3628974,'2398','364',169567.11,169567.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185071',3628975,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185071',3628976,'2400','364',106476.54,106476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185071',3628977,'2401','364',188261.57,189245.77,984.20,162393.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185071',3628978,'2402','364',116522.46,117988.42,1445.96,238583.40,0.00,0.00,20.00,0.00,0.00),('1','157','838','185071',3628979,'2403','364',127640.11,129043.52,1403.41,231562.65,0.00,0.00,0.00,0.00,0.00),('1','157','838','185071',3628980,'2404','364',117402.18,117977.50,575.32,94927.80,0.00,0.00,0.00,0.00,0.00),('1','157','839','185071',3628981,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185071',3628982,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185071',3628983,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185071',3628984,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185071',3628985,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185071',3628986,'2410','365',125685.55,125996.11,300.56,79648.40,0.00,0.00,10.00,0.00,0.00),('1','157','840','185071',3628987,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185071',3628988,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185287',3632262,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185287',3632263,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185287',3632264,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185287',3632265,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185287',3632266,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185287',3632267,'2394','364',109992.45,109992.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185287',3632268,'2395','364',130973.34,130973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185287',3632269,'2396','364',180378.87,180378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185287',3632270,'2397','364',129811.04,129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185287',3632271,'2398','364',169567.11,169567.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185287',3632272,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185287',3632273,'2400','364',106476.54,106476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185287',3632274,'2401','364',189245.77,190207.17,961.40,158631.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185287',3632275,'2402','364',117988.42,118941.63,953.21,157279.65,0.00,0.00,0.00,0.00,0.00),('1','157','838','185287',3632276,'2403','364',129043.52,129919.26,875.74,144497.10,0.00,0.00,0.00,0.00,0.00),('1','157','838','185287',3632277,'2404','364',117977.50,118869.41,881.91,145515.15,0.00,0.00,10.00,0.00,0.00),('1','157','839','185287',3632278,'2405','364',573.37,573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185287',3632279,'2406','364',621.35,621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185287',3632280,'2407','364',682.38,682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185287',3632281,'2408','364',593.32,593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185287',3632282,'2409','365',13056.62,13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185287',3632283,'2410','365',125996.11,126886.68,870.57,230701.05,0.00,0.00,20.00,0.00,0.00),('1','157','840','185287',3632284,'2411','365',2112862.19,2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185287',3632285,'2412','365',1362683.11,1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185488',3636082,'2389','364',56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185488',3636083,'2390','364',24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185488',3636084,'2391','364',41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185488',3636085,'2392','364',50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185488',3636086,'2393','364',32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185488',3636087,'2394','364',109992.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185488',3636088,'2395','364',130973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185488',3636089,'2396','364',180378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185488',3636090,'2397','364',129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185488',3636091,'2398','364',169567.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185488',3636092,'2399','364',115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185488',3636093,'2400','364',106476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185488',3636094,'2401','364',190207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185488',3636095,'2402','364',118941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185488',3636096,'2403','364',129919.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','838','185488',3636097,'2404','364',118869.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185488',3636098,'2405','364',573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185488',3636099,'2406','364',621.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185488',3636100,'2407','364',682.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','839','185488',3636101,'2408','364',593.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185488',3636102,'2409','365',13056.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185488',3636103,'2410','365',126886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185488',3636104,'2411','365',2112862.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','840','185488',3636105,'2412','365',1362683.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185489',3636106,'2389','364',56814.23,56814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185489',3636107,'2390','364',24541.94,24541.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185489',3636108,'2391','364',41290.47,41290.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','835','185489',3636109,'2392','364',50546.09,50546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185489',3636110,'2393','364',32563.00,32563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185489',3636111,'2394','364',109992.45,109992.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185489',3636112,'2395','364',130973.34,130973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','836','185489',3636113,'2396','364',180378.87,180378.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185489',3636114,'2397','364',129811.04,129811.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185489',3636115,'2398','364',169567.11,169567.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185489',3636116,'2399','364',115576.24,115576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','157','837','185489',3636117,'2400','364',1