-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_153
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_153`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_153` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_153`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3199 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2523,20009,'',0,'20','1','153','SALES','','2020-07-08 23:17:50',5,0.00,0.00,'','492','2020-07-08 23:17:50','492',0,1),(2524,40008,'',0,'6.1','1','153','CASH','','2020-07-08 23:18:33',5,0.00,0.00,'','492','2020-07-08 23:18:33','492',0,1),(2525,400074,'',0,'24','1','153','SALARIES & WAGES','','2020-07-08 23:19:07',5,0.00,0.00,'','492','2020-07-08 23:19:07','492',0,1),(2526,400075,'',0,'24','1','153','PURCHASES','','2020-07-08 23:20:16',5,0.00,0.00,'','492','2020-07-08 23:20:16','492',0,1),(2527,400199,'',0,'2','1','153','ZNB E-BILLS:1015372548','','2020-07-08 23:22:03',5,0.00,0.00,'','492','2020-07-08 23:22:03','492',0,1),(2528,400200,'',0,'2','1','153','ZBN(POS):1015965368','','2020-07-08 23:22:21',5,0.00,0.00,'','492','2020-07-08 23:22:21','492',0,1),(2912,400329,'',0,'2','1','153','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:06:38',5,0.00,0.00,'','489','2020-10-29 14:06:38','489',0,1),(3196,400475,'',0,'2','1','153','FID POS COLLECTION-5620141491','','2021-02-26 15:49:27',5,0.00,0.00,'','489','2021-02-26 15:49:27','489',0,1),(3197,400476,'',0,'2','1','153','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:29:43',5,0.00,0.00,'','792','2023-02-20 14:29:43','792',0,0),(3198,400477,'',0,'2','1','153','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:33:36',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:49:22','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4196 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1566,'','1','153','ALL DEALERS','ABUBAKAR','08066961167','abubakardts@gmail.com','Kano','Kano','NO.122 HARUNANA SULEIMAN GANDUN ALABASA NEW LAYOUT','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-10 11:21:10',5,'492','2020-07-10 11:21:10','492'),(1568,'','1','153','DANKANO','MUJITTAPHA','07036358180','mujittaphaqasim2018@yahoo.com','KANO','KANO','AA RANO DANKANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-13 12:51:47',5,'492','2020-07-13 12:51:47','492'),(1569,'','1','153','ADDED KG','ABUBAKAR YUSUF','08066961167','abubakardts@gmail.com','KANO','KANO','AA RANO BUK LPG','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-13 13:15:21',5,'492','2021-07-16 15:58:51','581'),(1757,'','1','153','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 14:06:16',5,'489','2020-10-29 14:06:16','489'),(2006,'','1','153','NURA JANBULO','NURa','08103350955','aaranobuklpg@gmail.com','KANO','KANO','janbulo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-10 10:35:10',5,'581','2021-02-10 10:35:10','581'),(2307,'','1','153','JILI GAS','JILI GULU GAS','08023666225','aaranolpg2@gmail.com','KANO','KANO','GULU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-10 10:29:15',5,'581','2021-03-10 10:29:15','581'),(3066,'','1','153','SHAKEER MINI DEPOT','SHAKEER','08108925812','uyabdullah26@gmail.com','KANO','KANO','SHOP NO 9 CIKIN KOFAR KABUGA BEHIND FCE KANO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 09:56:14',5,'581','2021-08-13 09:56:14','581'),(3067,'','1','153','G M S  GAS','AUWAL','07086089853','uyabdullah26@gmail.com','KANO','KANO','DAN BARE LAYIN BAYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 10:29:19',5,'581','2021-08-13 10:29:19','581'),(3115,'','1','153','BASIRU GAS','BASIRU','08022672485','hafizgaya@gmail.com','KANO','KANO','YAHAYA GUSAU OPP ZARA PLAZA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-19 08:27:09',5,'581','2021-08-19 08:27:09','581'),(3117,'','1','153','MKD GAS','BABBA','08109065050','info@aaranonigeria.com','KANO','KANO','SHARADA JA\'IN LAYIN DAN MARNA','Nigeria',250.00,0.00,0.00,'0000-00-00','2021-08-19 11:01:23',5,'581','2021-08-19 11:01:23','581'),(3120,'','1','153','TOFA GAS','MUKTAFI','07069550058','info@aaranonigeria.com','KANO','KANO','DANBARE B','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-08-19 14:50:20',5,'581','2021-08-19 14:50:20','581'),(3125,'','1','153','NAKURMI GAS ','HASSAN & HUSSAINI','09033542080','info@aaranonigeria.com','KANO','KANO','GWAURAN DUTSE OPP FILLING STATION','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-08-20 11:06:05',5,'581','2021-08-20 11:06:05','581'),(3129,'','1','153','CITY GAS','ABUBAKAR','08025428950','info@aaranonigeria.com','KANO','KANO','RAFIN DAN NANA','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-08-20 16:56:55',5,'581','2021-08-20 16:56:55','581'),(3130,'','1','153','GOMA GAS','ABUBAKAR','09065708994','info@aaranonigeria.com','KANO','KANO','SHARADA PHASE 11','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-08-20 16:58:07',5,'581','2021-08-20 16:58:07','581'),(3132,'','1','153','JIKAN TAJIRA GAS','GARBA MUHAMMAD GWARZO','08072065686','info@aaranonigeria.com','KANO','KANO','GWARZO ROAD','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-08-21 08:47:26',5,'581','2021-08-21 08:47:26','581'),(3133,'','1','153','ABU AHMAD GAS','AHMAD','09046747316','info@aaranonigeria.com','KANO','KANO','KUNTAU OPP ZAINAB FISHING LAYIN TRANSFORMER','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-08-21 09:01:00',5,'581','2021-08-21 09:01:00','581'),(3139,'','1','153','AMAZING GAS ','MUHAMMAD AHMAD','09030499728','info@aaranonigeria.com','KANO','KANO','LAYIN RIMIN AUZINAWA','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-08-22 08:50:28',5,'581','2021-08-22 08:50:28','581'),(3154,'','1','153','MUBARAK GAS ','ABBA','08166967111','info@aaranonigeria.com','KANO','KANO','UNGUWAR JAKADA','Nigeria',50.00,0.00,0.00,'0000-00-00','2021-08-27 15:17:08',5,'581','2021-08-27 15:17:08','581'),(3155,'','1','153','AGOGO GAS','ABUBAKAR','08165505805','info@aaranonigeria.com','KANO','KANO','BAKAR LAMBA','Nigeria',400.00,0.00,0.00,'0000-00-00','2021-08-27 15:18:58',5,'581','2021-08-27 15:18:58','581'),(3182,'','1','153','A K A 515 GAS','MUHAMMAD','08031106716','info@aaranonigeria.com','KANO','KANO','RIJIYAR ZAKI','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-09-02 14:24:00',5,'581','2021-09-02 14:24:00','581'),(3183,'','1','153','RAHAMA GAS','ALHAJI','08132512730','info@aaranonigeria.com','KANO','KANO','GAREJIN HASSAN RIJIYAR ZAKI','Nigeria',750.00,0.00,0.00,'0000-00-00','2021-09-02 14:25:40',5,'581','2021-09-02 14:25:40','581'),(3186,'','1','153','MAZA WAJE GAS','HAMZA','07064324472','info@aaranonigeria.com','KANO','KANO','GWANMAJA AREA','Nigeria',250.00,0.00,0.00,'0000-00-00','2021-09-03 11:29:57',5,'581','2021-09-03 11:29:57','581'),(3210,'','1','153','AREA MANAGER  GAS','BUK PMS STATION','09065708994','info@aaranonigeria.com','KANO','KANO','CAMP','Nigeria',470.00,0.00,0.00,'0000-00-00','2021-09-09 13:23:35',5,'581','2021-09-09 13:23:35','581'),(3225,'','1','153','CLASSIC GAS','MUKHTAR ','08122206882','info@aaranonigeria.com','KANO','KANO','SHARADA GADAR YAN MATA OPP AL IHSAN','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-09-11 14:54:41',5,'581','2021-09-11 14:54:41','581'),(3226,'','1','153','MUKHTAR GAS','ABUBAKAR','09065708994','info@aaranonigeria.com','KANO','KANO','DAN BARE','Nigeria',350.00,0.00,0.00,'0000-00-00','2021-09-11 15:10:22',5,'581','2021-09-11 15:10:22','581'),(3230,'','1','153','GODIYA GAS','GLORIA','09065708999','aarano@gmail.com','KANO','KANO','JANGUZA BY GULU','Nigeria',250.00,0.00,0.00,'0000-00-00','2021-09-12 06:43:06',5,'581','2021-09-12 06:43:06','581'),(3231,'','1','153','BARAKA GAS','HAJIYA','08145456444','aarano@gmail.com','KANO','KANO','RIMIN ZAKARA BY LAMBU','Nigeria',300.00,0.00,0.00,'0000-00-00','2021-09-12 06:45:03',5,'581','2021-09-12 06:45:03','581'),(3254,'','1','153','SUCCESS GAS ','YUSUF','09037379195','info@aaranonigeria.com','KANO','KANO','JAN BULO','Nigeria',47.00,0.00,0.00,'0000-00-00','2021-09-12 16:55:10',5,'581','2021-09-12 16:55:10','581'),(3257,'','1','153','RABI\'U GALADIMA GAS','RABI\'U','07086977086','info@aaranonigeria.com','KANO','KANO','BUK ROAD','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-09-13 12:06:42',5,'581','2021-09-13 12:06:42','581'),(3258,'','1','153','ZUMAR GAS','UMAR','09030736323','info@aaranonigeria.com','KANO','KANO','BUK DAN BARE','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-09-13 12:07:40',5,'581','2021-09-13 12:07:40','581'),(3259,'','1','153','HABIB GULU GAS','HABIB','07068132167','info@aaranonigeria.com','KANO','KANO','JAN GUZA','Nigeria',75.00,0.00,0.00,'0000-00-00','2021-09-13 12:09:02',5,'581','2021-09-13 12:09:02','581'),(3260,'','1','153','GULU GAS','AUWAL','09065708994','info@aaranonigeria.com','KANO','KANO','RIMIN GATA','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-09-13 12:09:59',5,'581','2021-09-13 12:09:59','581'),(3261,'','1','153','SURE GAS','ABDURRAHMAN','08147443256','info@aaranonigeria.com','KANO','KANO','DAN BARE','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-09-13 12:11:21',5,'581','2021-09-13 12:11:21','581'),(3262,'','1','153','AFUWA GAS ','ABUBAKAR','09065708994','info@aaranonigeria.com','KANO','KANO','LAMBU','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-09-13 12:13:28',5,'581','2021-09-13 12:13:28','581'),(3263,'','1','153','DAN FODIO GAS','BASIRU','09065708994','info@aaranonigeria.com','KANO','KANO','F C E GATE','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-09-13 12:14:11',5,'581','2021-09-13 12:14:11','581'),(3264,'','1','153','MANGARI GAS','BABBA','08108925812','info@aaranonigeria.com','KANO','KANO','JAN BULO','Nigeria',125.00,0.00,0.00,'0000-00-00','2021-09-13 12:15:00',5,'581','2021-09-13 12:15:00','581'),(3265,'','1','153','GAYAMCO GAS','GARBA','07086089853','info@aaranonigeria.com','KANO','KANO','JAN BULO BY FIRST GATE','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-09-13 12:15:58',5,'581','2021-09-13 12:15:58','581'),(3276,'','1','153','ASAS GAS ','RABI\'U ','09071373383','info@aaranonigeria.com','KANO','KANO','RING ROAD BAYAN TASHA','Nigeria',62.50,0.00,0.00,'0000-00-00','2021-09-15 10:14:14',5,'581','2021-09-15 10:14:14','581'),(3281,'','1','153','MAZAD GAS','UMAR','08033180061','info@aaranonigeria.com','KANO','KANO','RIJIYAR ZAKI','Nigeria',50.00,0.00,0.00,'0000-00-00','2021-09-15 16:57:10',5,'581','2021-09-15 16:57:10','581'),(3306,'','1','153','NASARA GAS','NASIRU','09065708994','info@aaranonigeria.com','KANO','KANO','SARAWA ','Nigeria',250.00,0.00,0.00,'0000-00-00','2021-09-17 14:50:35',5,'581','2021-09-17 14:50:35','581'),(3312,'','1','153','ALKHAIRI GAS','YUSUF','09065708994','info@aaranonigeria.com','KANO','KANO','LUNGUN KUNTAU STREET ','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-09-18 11:04:35',5,'581','2021-09-18 11:04:35','581'),(3313,'','1','153','NASSARA GAS','BABBA','07086089853','info@aaranonigeria.com','KANO','KANO','KUNTAU BEHIND ZAINAB VISION KARSHEN TITI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-09-18 11:30:04',5,'581','2021-09-18 11:30:04','581'),(3376,'','1','153','MUMMY GAS','BASIRU','07086089853','info@aaranonigeria.com','KANO','KANO','TITIN MANDAWARI','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-09-28 13:49:44',5,'581','2021-09-28 13:49:44','581'),(3393,'','1','153','S Y GAS ','DANBARE GAS ','09068683210','info@aaranonigeria.com','KANO','KANO','DANBARE','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-10-05 12:33:05',5,'581','2021-10-05 12:33:05','581'),(3394,'','1','153','HANNAFI GAS','HANNAFI','08024037878','info@aaranonigeria.com','KANO','KANO','UNGUWA UKU KUSA DA ASIBITIN DABBOBI','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-10-05 12:36:29',5,'581','2021-10-05 12:36:29','581'),(3395,'','1','153','WALWALA GAS','ABUBAKAR','08022672485','info@aaranonigeria.com','KANO','KANO','RIGIYAN ZAKI','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-10-05 12:40:29',5,'581','2021-10-05 12:40:29','581'),(3396,'','1','153','G U C GAS','ALHAJI ADAM','09065708994','info@aaranonigeria.com','KANO','KANO','RIGIYAN ZAKI','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-05 12:42:14',5,'581','2021-10-05 12:42:14','581'),(3409,'','1','153','GARO GAS','GARBA','08025917640','info@aaranonigeria.com','KANO','KANO','GARO TOWN','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-10-06 13:06:59',5,'581','2021-10-06 13:06:59','581'),(3410,'','1','153','NUR ALA NUR GAS','NURA','09065708994','info@aaranonigeria.com','KANO','KANO','JAN GUZA','Nigeria',50.00,0.00,0.00,'0000-00-00','2021-10-06 13:12:19',5,'581','2021-10-06 13:12:19','581'),(3435,'','1','153','MUSTAPHA GAS','MUSTAPHA BABBA','09067670982','aaranolpg@gmail.com','KANO','KANO','RIJIYAR ZAKI','Nigeria',250.00,0.00,0.00,'0000-00-00','2021-10-11 07:54:33',5,'581','2021-10-11 07:54:33','581'),(3436,'','1','153','RABI\'U GLDM GAS','RABI\'U','09067670982','aaranolpg@gmail.com','KANO','KANO','JANGUZA','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-10-11 07:58:17',5,'581','2021-10-11 07:58:17','581'),(3437,'','1','153','CARDINAL GAS','BABA','09067670982','aaranolpg@gmail.com','KANO','KANO','JANGUZA','Nigeria',180.00,0.00,0.00,'0000-00-00','2021-10-11 08:02:53',5,'581','2021-10-11 08:02:53','581'),(3438,'','1','153','A S FAGGE GAS','RABS','08126573321','aaranolpg@gmail.com','KANO','KANO','BUK ROAD','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-10-11 08:06:35',5,'581','2021-10-11 08:06:35','581'),(3439,'','1','153','ZUMAR  GAS','JAMIL','09032320156','aaranolpg@gmail.com','KANO','KANO','ZAINAB VISION ROAD','Nigeria',75.00,0.00,0.00,'0000-00-00','2021-10-11 08:11:23',5,'581','2021-10-11 08:11:23','581'),(3440,'','1','153','I B B GAS','IBRAHIM','07065433421','aaranolpg@gmail.com','KANO','KANO','KABUGA','Nigeria',80.00,0.00,0.00,'0000-00-00','2021-10-11 08:12:56',5,'581','2021-10-11 08:12:56','581'),(3441,'','1','153','KHALEED GAS','YUSUF','08132324156','aaranolpg@gmail.com','KANO','KANO','KABUGA','Nigeria',75.00,0.00,0.00,'0000-00-00','2021-10-11 08:16:34',5,'581','2021-10-11 08:16:34','581'),(3442,'','1','153','A U MADOBI GAS','USAMAT','08132324156','aaranolpg@gmail.com','KANO','KANO','MADOBI','Nigeria',100.00,0.00,0.00,'0000-00-00','2021-10-11 08:18:16',5,'581','2021-10-11 08:18:16','581'),(3443,'','1','153','RUMI GAS','ALI','09032345441','aaranolpg@gmail.com','KANO','KANO','GWARZO ROAD','Nigeria',50.00,0.00,0.00,'0000-00-00','2021-10-11 08:20:53',5,'581','2021-10-11 08:20:53','581'),(3444,'','1','153','ARMA YA\'U GAS','ARMA','07054456332','aaranolpg@gmail.com','KANO','KANO','JANGUZA','Nigeria',180.00,0.00,0.00,'0000-00-00','2021-10-11 08:22:58',5,'581','2021-10-11 08:22:58','581'),(3445,'','1','153','AUWAL GAS','AUWAL ','07065433232','aaranolpg@gmail.com','KANO','KANO','KABUGA','Nigeria',120.00,0.00,0.00,'0000-00-00','2021-10-11 08:24:24',5,'581','2021-10-11 08:24:24','581'),(3457,'','1','153','AL IHSAN GAS','MUSTAPHA','08109065050','info@aaranonigeria.com','KANO','KANO','JANGUZA','Nigeria',300.00,0.00,0.00,'0000-00-00','2021-10-12 08:06:32',5,'581','2021-10-12 08:06:32','581'),(3462,'','1','153','A Y A GAs','ALI','07039497020','aaranolpg@gmail.com','KANO','KANO','BAJALLABA BAYAN NORTH WEST','Nigeria',150.00,0.00,0.00,'0000-00-00','2021-10-13 10:02:29',5,'581','2021-10-13 10:02:29','581'),(3724,'','1','153','KARAYE GAS','ALKHAIRAT','08067363083','hafizgaya@gmail.com','KANO','KANO','KARAYE LGA','Nigeria',1150.00,0.00,0.00,'0000-00-00','2021-11-11 07:14:29',5,'581','2021-11-11 07:14:29','581'),(3730,'','1','153','GWARZO GAS','NURA','09126949568','hafizgaya@gmail.com','KANO','KANO','GWARZO','Nigeria',310.00,0.00,0.00,'0000-00-00','2021-11-11 10:39:52',5,'581','2021-11-11 10:39:52','581'),(4155,'','1','153','AL HALAL GAS','ABDUL','08141634829','info@aaranonigeria.comhawan da','KANO','KANO','HAWAN DAWAKI','Nigeria',50.00,0.00,0.00,'0000-00-00','2022-01-08 08:55:39',5,'581','2022-01-08 08:55:39','581'),(4164,'','1','153','A H GAS','ABUBAKAR','09065708994','info@aaranonigeria.com','KANO','KANO','DAN BARE','Nigeria',50.00,0.00,0.00,'0000-00-00','2022-01-09 15:26:19',5,'581','2022-01-09 15:26:19','581'),(4184,'','1','153','jAMBULO GAS','SHAMSU','08126017852','aaranolpg@gmail.com','KANO','KANO','RIJIYAR ZAKI LAYIN CUSTOM','Nigeria',75.00,0.00,0.00,'0000-00-00','2022-01-18 10:07:45',5,'581','2022-01-18 10:07:45','581'),(4185,'','1','153','B SUYA GAS','BASHIR','09065708994','info@aaranonigeria.com','KANO','KANO','RIJIYAR ZAKI','Nigeria',50.00,0.00,0.00,'0000-00-00','2022-02-03 15:26:27',5,'581','2022-02-03 15:26:27','581'),(4186,'','1','153','SHEHU GAS','SHEHU','08037677908','aaranolpg@gmail.com','KANO','KANO','CAMP','Nigeria',450.00,0.00,0.00,'0000-00-00','2022-02-16 17:28:35',5,'581','2022-02-16 17:28:35','581'),(4187,'','1','153','TINGA GAS','ABUBAKAR ','08163367417','aaranolpg@gmail.com','KANO','KANO','DORAWAR','Nigeria',180.00,0.00,0.00,'0000-00-00','2022-03-23 08:54:07',5,'581','2022-03-23 08:54:07','581'),(4188,'','1','153','MIL TARA','SAGIR MASAUD','09065708994','hafizgaya@gmail.com','UNGOGGO LGA','KANO','DAWANAU ROUNDABOUT KATSINA ROAD','Nigeria',6000.00,0.00,0.00,'0000-00-00','2022-04-05 17:51:59',5,'581','2022-04-05 17:51:59','581'),(4189,'','1','153','Garaje Gas','ABUBAKAR','09065708994','hafizgaya@gmail.com','KANO','KANO','janguza','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-04-08 09:59:56',5,'581','2022-04-08 09:59:56','581'),(4190,'','1','153','H S GLOLOBAL','TASI\'U','08021088585','info@aaranonigeria.com','150','KANO','NO 1 AUDU BAKO','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-04-24 16:16:33',5,'581','2022-04-24 16:16:33','581'),(4191,'','1','153','SABUWA GAS','USMAN','08052589332','hafizgaya@gmail.com','KANO','KANO','RIJIYAR LEMO','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-05-26 07:43:17',5,'581','2022-05-26 07:43:17','581'),(4192,'','1','153','BAKANOMA GAS','ABUBAKAR','08055360905','info@aaranonigeria.com','KANO','KANO','TAL\'UDU','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-06-30 10:52:17',5,'581','2022-06-30 10:52:17','581'),(4193,'','1','153','SADDAD GAS','SADDAQ','07066164869','info@aaranonigeria.com','KANO','KANO','RIMIN GADO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 07:53:19',5,'581','2022-07-21 07:53:19','581'),(4194,'','1','153','SABON ZUWA GAS','USMAN','09032599696','info@aaranonigeria.com','KANO','KANO','NORTH WEST','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-07-21 07:55:30',5,'581','2022-07-21 07:55:30','581'),(4195,'','1','153',' M Y GAS','MUHYIDDEEN','08084868903','uyabdullah26@gmail.com','KANO','KANO','GAIDA SERVICE STATION','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-07-23 12:02:36',5,'581','2022-07-23 12:02:36','581');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16529 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','153',16505,'763',5596.90,1798.00,'2021-09-20','new','2021-09-20 17:37:07','483','483',2021,'483','2021-09-20 17:37:07',5),('1','153',16528,'763',5962.49,63.00,'2021-09-22','new','2021-09-22 10:27:30','483','483',2021,'483','2021-09-22 10:27:30',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3000 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','153','763',2132,'5','LPG NOZZLE 1',2346925.42,'LPG DISPENSER','',NULL,NULL,'',5,'2020-07-21 12:20:49','487'),('1','153','763',2133,'5','LPG NOZZLE 2',1859660.34,'LPG DISPENSER','',NULL,NULL,'',5,'2020-07-21 12:22:02','487'),('1','153','763',2998,'5','LPG NOZZLE 3',313980.09,'LPG DISPENSER.','',NULL,NULL,'',5,'2021-10-21 22:36:03','479'),('1','153','763',2999,'5','LPG NOZZLE 4',53383.23,'LPG DISPENSER.','',NULL,NULL,'',5,'2021-10-21 22:39:47','479');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257948 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','153',144096,'DAILY SHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-21 13:20:55','492','2020-07-21 13:22:16',10,0),('1','153',144261,'DAILY SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-22 14:40:21','492','2020-07-22 14:41:54',10,0),('1','153',144347,'DAILY SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-23 12:31:47','492','2020-07-23 12:34:01',10,0),('1','153',144359,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-23 14:40:58','492','2020-07-23 14:41:40',10,0),('1','153',144452,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-23 21:21:47','492','2020-07-23 21:22:25',10,0),('1','153',144453,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-23 21:49:59','492','2020-07-23 21:50:44',10,0),('1','153',144533,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-24 14:32:31','492','2020-07-24 14:33:10',10,0),('1','153',144539,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-24 15:40:59','492','2020-07-24 15:41:25',10,0),('1','153',144588,'DAILY SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-24 21:36:59','492','2020-07-24 21:38:06',10,0),('1','153',144589,'DAILY SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-24 23:17:21','492','2020-07-24 23:17:53',10,0),('1','153',144590,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-25 00:09:34','492','2020-07-25 00:10:02',10,0),('1','153',144629,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-25 13:28:04','492','2020-07-25 13:28:57',10,0),('1','153',144666,'DAILY SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-25 14:09:03','492','2020-07-25 14:09:30',10,0),('1','153',144674,'DAILY SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-25 15:03:01','492','2020-07-25 15:04:34',10,0),('1','153',144727,'DAILY SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-25 22:06:31','492','2020-07-25 22:07:17',10,0),('1','153',144728,'DAILY SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 07:34:51','492','2020-07-26 07:36:26',10,0),('1','153',144736,'DAILY SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 08:38:32','492','2020-07-26 08:42:14',10,0),('1','153',144741,'DAILY SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 10:34:08','492','2020-07-26 10:36:46',10,0),('1','153',144759,'DAILY SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 12:19:16','492','2020-07-26 12:20:35',10,0),('1','153',144772,'DAILY SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 12:52:33','492','2020-07-26 12:53:10',10,0),('1','153',144778,'DAILY SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 13:29:19','492','2020-07-26 13:29:47',10,0),('1','153',144798,'DAILY SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-26 14:37:02','492','2020-07-26 14:37:40',10,0),('1','153',144945,'DAILY SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-27 15:15:37','492','2020-07-27 15:16:05',10,0),('1','153',144956,'DAILY SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-28 09:04:05','492','2020-07-28 09:04:55',10,0),('1','153',145013,'DAILY SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-28 09:46:06','492','2020-07-28 09:46:32',10,0),('1','153',145022,'DAILY SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-28 10:24:49','492','2020-07-28 10:25:41',10,0),('1','153',145029,'DAILY SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-28 10:51:13','492','2020-07-28 10:51:50',10,0),('1','153',145239,'DAILY SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 00:17:05','492','2020-07-30 00:17:54',10,0),('1','153',145240,'DAILY SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 12:58:03','492','2020-07-30 12:58:24',10,0),('1','153',145303,'DAILY SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 14:11:22','492','2020-07-30 14:11:40',10,0),('1','153',145308,'DAILY SHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 14:22:52','492','2020-07-30 14:23:12',10,0),('1','153',145313,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 14:40:45','492','2020-07-30 14:41:04',10,0),('1','153',145316,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 14:55:01','492','2020-07-30 14:55:20',10,0),('1','153',145318,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-30 15:22:12','492','2020-07-30 15:22:31',10,0),('1','153',145362,'DAILY SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-31 11:18:01','492','2020-07-31 11:18:35',10,0),('1','153',145364,'DAILY SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-31 13:25:17','492','2020-07-31 13:25:59',10,0),('1','153',145383,'DAILY SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-31 14:41:48','492','2020-07-31 14:42:19',10,0),('1','153',145389,'DAILY SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-31 16:03:59','492','2020-07-31 16:05:01',10,0),('1','153',145394,'DAILY SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-07-31 16:44:32','492','2020-07-31 16:46:08',10,0),('1','153',145492,'DAILY SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-02 08:42:20','492','2020-08-02 08:42:49',10,0),('1','153',145496,'DAILY SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-02 09:11:56','492','2020-08-02 09:12:22',10,0),('1','153',145588,'DAILY SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-03 01:29:10','492','2020-08-03 01:29:39',10,0),('1','153',146001,'DAILY SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-05 13:34:02','492','2020-08-05 13:34:30',10,0),('1','153',146022,'DAILY SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-05 19:44:04','492','2020-08-05 19:45:18',10,0),('1','153',146079,'DAILY SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-05 20:53:16','492','2020-08-05 20:53:46',10,0),('1','153',146080,'DAILY SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-05 22:25:11','492','2020-08-05 22:25:55',10,0),('1','153',146081,'DAILY SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-05 22:57:34','492','2020-08-05 22:58:28',10,0),('1','153',146086,'DAILY SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-07 22:23:10','492','2020-08-07 22:25:08',10,0),('1','153',146461,'DAILY SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-09 10:27:11','492','2020-08-09 10:30:14',10,0),('1','153',146543,'DAILY SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-09 16:02:23','492','2020-08-09 16:07:27',10,0),('1','153',146556,'DAILY SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-09 16:54:29','492','2020-08-09 16:54:57',10,0),('1','153',146566,'DAILY SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-09 17:33:20','492','2020-08-09 17:35:40',10,0),('1','153',146725,'DAILY SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-10 17:13:07','492','2020-08-10 17:13:30',10,0),('1','153',146744,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-11 07:46:38','492','2020-08-11 07:48:01',10,0),('1','153',146850,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-11 21:18:46','492','2020-08-11 21:20:02',10,0),('1','153',147080,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-12 16:24:51','492','2020-08-12 16:25:11',10,0),('1','153',147116,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-12 23:30:37','492','2020-08-12 23:31:05',10,0),('1','153',147117,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-13 00:45:55','492','2020-08-13 00:46:15',10,0),('1','153',147157,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-13 09:40:07','492','2020-08-13 09:40:41',10,0),('1','153',147173,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-13 10:34:15','492','2020-08-13 10:34:43',10,0),('1','153',147193,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-13 11:22:52','492','2020-08-13 11:23:31',10,0),('1','153',147610,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 12:38:01','492','2020-08-16 12:38:52',10,0),('1','153',147621,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 13:12:32','492','2020-08-16 13:13:03',10,0),('1','153',147626,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 14:03:13','492','2020-08-16 14:03:39',10,0),('1','153',147636,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 15:22:03','492','2020-08-16 15:22:29',10,0),('1','153',147640,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 15:47:26','492','2020-08-16 15:47:49',10,0),('1','153',147650,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 16:26:37','492','2020-08-16 16:27:00',10,0),('1','153',147660,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 16:51:36','492','2020-08-16 16:51:57',10,0),('1','153',147692,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 21:28:49','492','2020-08-16 21:29:26',10,0),('1','153',147693,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-16 22:09:45','492','2020-08-16 22:10:31',10,0),('1','153',147898,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 10:41:28','492','2020-08-18 10:41:47',10,0),('1','153',147902,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 10:59:36','492','2020-08-18 11:00:01',10,0),('1','153',147905,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 11:29:46','492','2020-08-18 11:30:14',10,0),('1','153',147914,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 12:27:24','492','2020-08-18 12:27:47',10,0),('1','153',147921,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 13:01:43','492','2020-08-18 13:02:03',10,0),('1','153',147935,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 13:30:19','492','2020-08-18 13:30:52',10,0),('1','153',147990,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 19:45:01','492','2020-08-18 19:46:23',10,0),('1','153',147992,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 20:05:32','492','2020-08-18 20:07:06',10,0),('1','153',147993,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 20:27:48','492','2020-08-18 20:28:13',10,0),('1','153',147995,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-18 20:48:14','492','2020-08-18 20:49:29',10,0),('1','153',148018,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-19 10:24:04','492','2020-08-19 10:24:27',10,0),('1','153',148060,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-19 13:18:25','492','2020-08-19 13:18:55',10,0),('1','153',148064,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-19 13:47:43','492','2020-08-19 13:48:12',10,0),('1','153',148084,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-19 15:33:18','492','2020-08-19 15:34:00',10,0),('1','153',148086,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-19 22:35:35','492','2020-08-19 22:36:01',10,0),('1','153',148471,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-22 11:06:46','492','2020-08-22 11:07:39',10,0),('1','153',148475,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-22 11:33:33','492','2020-08-22 11:33:59',10,0),('1','153',148478,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-22 11:54:28','492','2020-08-22 11:55:01',10,0),('1','153',148487,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-22 21:56:40','492','2020-08-22 21:57:10',10,0),('1','153',148581,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-23 11:28:41','492','2020-08-23 11:29:18',10,0),('1','153',148672,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-23 21:34:48','492','2020-08-23 21:35:07',10,0),('1','153',148731,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-24 11:41:03','492','2020-08-24 11:41:22',10,0),('1','153',148814,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-24 21:20:32','492','2020-08-24 21:21:07',10,0),('1','153',148871,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-25 16:34:37','492','2020-08-25 16:35:06',10,0),('1','153',148937,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-25 22:20:15','492','2020-08-25 22:20:52',10,0),('1','153',149152,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-26 21:08:17','492','2020-08-26 21:08:53',10,0),('1','153',149310,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-27 21:29:23','492','2020-08-27 21:29:46',10,0),('1','153',149478,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-28 22:29:44','492','2020-08-28 22:30:06',10,0),('1','153',149479,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-28 22:51:43','492','2020-08-28 22:52:06',10,0),('1','153',149603,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-29 22:45:41','492','2020-08-29 22:46:05',10,0),('1','153',149604,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-29 23:10:15','492','2020-08-29 23:10:48',10,0),('1','153',149701,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-30 23:05:21','492','2020-08-30 23:05:49',10,0),('1','153',149702,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-30 23:25:32','492','2020-08-30 23:25:54',10,0),('1','153',149862,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-31 22:40:00','492','2020-08-31 22:40:22',10,0),('1','153',149863,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-08-31 23:12:21','492','2020-08-31 23:12:46',10,0),('1','153',150048,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-02 10:47:41','492','2020-09-02 10:48:12',10,0),('1','153',150222,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-03 13:00:42','492','2020-09-03 13:01:09',10,0),('1','153',150272,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-03 13:38:04','492','2020-09-03 13:40:42',10,0),('1','153',150392,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-03 23:13:38','492','2020-09-03 23:14:48',10,0),('1','153',150512,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-04 16:24:59','492','2020-09-04 16:25:23',10,0),('1','153',150558,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-04 21:54:11','492','2020-09-04 21:54:35',10,0),('1','153',150559,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-04 22:22:07','492','2020-09-04 22:22:31',10,0),('1','153',150844,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-06 20:26:06','492','2020-09-06 20:26:33',10,0),('1','153',150846,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-06 21:01:26','492','2020-09-06 21:02:03',10,0),('1','153',150849,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-06 21:27:32','492','2020-09-06 21:28:00',10,0),('1','153',150853,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-06 22:15:01','492','2020-09-06 22:15:24',10,0),('1','153',151110,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-08 15:32:50','492','2020-09-08 15:33:15',10,0),('1','153',151117,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-08 15:57:48','492','2020-09-08 15:58:09',10,0),('1','153',151151,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-08 20:21:11','492','2020-09-08 20:21:41',10,0),('1','153',151393,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-10 14:36:45','492','2020-09-10 14:37:10',10,0),('1','153',151441,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-10 21:25:33','492','2020-09-10 21:26:20',10,0),('1','153',151443,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-10 22:23:13','492','2020-09-10 22:24:45',10,0),('1','153',151733,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-13 11:30:52','492','2020-09-13 11:31:13',10,0),('1','153',151738,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-13 11:49:06','492','2020-09-13 11:49:39',10,0),('1','153',151766,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-13 13:58:33','492','2020-09-13 13:58:56',10,0),('1','153',151771,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-13 14:24:54','492','2020-09-13 14:28:51',10,0),('1','153',151820,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-13 23:39:04','492','2020-09-13 23:39:32',10,0),('1','153',152034,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-15 08:02:24','492','2020-09-15 08:03:34',10,0),('1','153',152113,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-15 15:13:01','492','2020-09-15 15:13:21',10,0),('1','153',152190,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-16 08:25:44','492','2020-09-16 08:26:10',10,0),('1','153',152401,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-17 13:40:32','492','2020-09-17 13:41:12',10,0),('1','153',152480,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-18 13:26:33','492','2020-09-18 13:39:53',10,0),('1','153',152593,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-18 16:50:10','492','2020-09-18 16:52:28',10,0),('1','153',152682,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-19 12:42:23','492','2020-09-19 12:43:03',10,0),('1','153',152869,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-20 16:45:13','492','2020-09-20 16:48:09',10,0),('1','153',152883,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-20 19:04:53','492','2020-09-20 19:07:17',10,0),('1','153',153047,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-21 16:50:01','492','2020-09-21 16:51:25',10,0),('1','153',153200,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-22 14:55:36','492','2020-09-22 14:58:54',10,0),('1','153',153226,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-22 16:23:18','492','2020-09-22 16:25:41',10,0),('1','153',153456,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-23 17:27:41','492','2020-09-23 17:29:41',10,0),('1','153',153543,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-24 10:56:31','492','2020-09-24 10:58:31',10,0),('1','153',153550,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-24 11:47:40','492','2020-09-24 11:48:46',10,0),('1','153',153658,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-25 07:03:38','492','2020-09-25 07:04:58',10,0),('1','153',153694,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-25 10:52:37','492','2020-09-25 10:53:50',10,0),('1','153',153705,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-25 11:31:36','492','2020-09-25 11:33:16',10,0),('1','153',153890,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-26 15:40:54','492','2020-09-26 15:42:11',10,0),('1','153',154055,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-27 20:09:01','492','2020-09-27 20:09:53',10,0),('1','153',154124,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-28 11:57:52','492','2020-09-28 11:59:07',10,0),('1','153',154219,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-28 16:28:05','492','2020-09-28 16:30:15',10,0),('1','153',154302,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-29 10:30:48','492','2020-09-29 10:32:03',10,0),('1','153',154359,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-29 14:34:13','492','2020-09-29 14:34:53',10,0),('1','153',154471,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-09-30 11:45:26','492','2020-09-30 11:46:01',10,0),('1','153',154759,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-02 09:10:58','492','2020-10-02 09:11:55',10,0),('1','153',154998,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-03 16:44:55','492','2020-10-03 16:45:32',10,0),('1','153',155101,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-04 15:00:04','492','2020-10-04 15:00:42',10,0),('1','153',155110,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-04 15:55:00','492','2020-10-04 15:55:26',10,0),('1','153',155264,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-05 16:00:25','492','2020-10-05 16:01:01',10,0),('1','153',155266,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-05 16:23:10','492','2020-10-05 16:23:46',10,0),('1','153',155384,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-06 13:06:36','492','2020-10-06 13:07:22',10,0),('1','153',155482,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-07 08:59:49','492','2020-10-07 09:00:18',10,0),('1','153',155577,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-07 14:43:26','492','2020-10-07 14:43:53',10,0),('1','153',155706,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-08 13:22:17','492','2020-10-08 13:22:45',10,0),('1','153',155836,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-09 11:37:17','492','2020-10-09 11:37:54',10,0),('1','153',155849,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-09 13:02:35','492','2020-10-09 13:03:07',10,0),('1','153',156117,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-11 09:34:43','492','2020-10-11 09:35:12',10,0),('1','153',156126,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-11 09:55:08','492','2020-10-11 09:55:37',10,0),('1','153',156183,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-11 16:10:20','492','2020-10-11 16:10:57',10,0),('1','153',156390,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-12 16:47:29','492','2020-10-12 16:48:16',10,0),('1','153',156396,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-12 17:00:22','492','2020-10-12 17:00:46',10,0),('1','153',156435,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-13 08:02:41','492','2020-10-13 08:03:46',10,0),('1','153',156654,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-14 13:13:53','492','2020-10-14 13:14:20',10,0),('1','153',156768,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-15 09:33:22','492','2020-10-15 09:33:54',10,0),('1','153',156771,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-15 09:57:34','492','2020-10-15 09:58:12',10,0),('1','153',157064,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-16 17:57:22','492','2020-10-16 17:57:59',10,0),('1','153',157071,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-16 18:20:42','492','2020-10-16 18:21:17',10,0),('1','153',157226,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-17 15:51:05','492','2020-10-17 15:51:32',10,0),('1','153',157399,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-18 13:52:38','492','2020-10-18 13:53:09',10,0),('1','153',157403,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-18 14:10:52','492','2020-10-18 14:13:29',10,0),('1','153',157631,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-19 17:05:26','492','2020-10-19 17:05:50',10,0),('1','153',157776,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-20 15:25:12','492','2020-10-20 15:25:54',10,0),('1','153',157782,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-20 16:03:17','492','2020-10-20 16:03:42',10,0),('1','153',157872,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-21 11:11:36','492','2020-10-21 11:12:06',10,0),('1','153',157887,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-21 11:35:54','492','2020-10-21 11:36:23',10,0),('1','153',158049,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-22 15:37:10','492','2020-10-22 15:37:52',10,0),('1','153',158247,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-23 17:49:57','492','2020-10-23 17:51:08',10,0),('1','153',158253,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-23 18:17:51','492','2020-10-23 18:18:57',10,0),('1','153',158311,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-24 11:31:58','492','2020-10-24 11:32:41',10,0),('1','153',158441,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-25 09:19:33','492','2020-10-25 09:20:11',10,0),('1','153',158742,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-26 18:12:40','492','2020-10-26 18:13:11',10,0),('1','153',158746,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-26 19:14:59','492','2020-10-26 19:15:39',10,0),('1','153',158902,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-27 16:09:58','492','2020-10-27 16:10:27',10,0),('1','153',158986,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-28 10:55:55','492','2020-10-28 10:56:23',10,0),('1','153',159113,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-28 18:35:36','492','2020-10-28 18:36:01',10,0),('1','153',159323,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-30 09:21:24','492','2020-10-30 09:22:06',10,0),('1','153',159344,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-31 15:41:29','492','2020-10-31 15:41:57',10,0),('1','153',159602,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-10-31 16:02:41','492','2020-10-31 16:03:16',10,0),('1','153',159696,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-01 14:42:20','492','2020-11-01 14:42:43',10,0),('1','153',159699,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-01 14:56:10','492','2020-11-01 14:56:36',10,0),('1','153',159706,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-01 15:29:48','492','2020-11-01 15:30:09',10,0),('1','153',159709,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-01 15:46:47','492','2020-11-01 15:47:09',10,0),('1','153',159826,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-02 11:36:21','492','2020-11-02 11:36:45',10,0),('1','153',160040,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-03 12:32:53','492','2020-11-03 12:33:17',10,0),('1','153',160205,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-04 10:54:22','492','2020-11-04 10:54:45',10,0),('1','153',160383,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-05 15:43:50','492','2020-11-05 15:44:30',10,0),('1','153',160512,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-06 11:02:19','492','2020-11-06 11:03:14',10,0),('1','153',160515,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-06 11:23:53','492','2020-11-06 11:24:18',10,0),('1','153',160654,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-07 10:33:28','492','2020-11-07 10:33:51',10,0),('1','153',160819,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-08 12:49:57','492','2020-11-08 12:50:26',10,0),('1','153',160822,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-08 13:05:34','492','2020-11-08 13:06:04',10,0),('1','153',160953,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-09 09:04:03','492','2020-11-09 09:04:40',10,0),('1','153',161161,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-10 11:11:57','492','2020-11-10 11:12:22',10,0),('1','153',161353,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-11 10:33:40','492','2020-11-11 10:34:03',10,0),('1','153',161525,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-12 09:19:11','492','2020-11-12 09:19:37',10,0),('1','153',161531,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-12 09:38:47','492','2020-11-12 09:39:20',10,0),('1','153',161738,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-13 11:07:44','492','2020-11-13 11:08:12',10,0),('1','153',161966,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-14 12:36:17','492','2020-11-14 12:36:50',10,0),('1','153',161980,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-14 13:29:30','492','2020-11-14 13:30:12',10,0),('1','153',162136,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-15 13:20:38','492','2020-11-15 13:20:58',10,0),('1','153',162279,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-16 08:48:58','492','2020-11-16 08:49:39',10,0),('1','153',162294,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-16 09:26:00','492','2020-11-16 09:26:19',10,0),('1','153',162505,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-17 09:07:21','492','2020-11-17 09:07:48',10,0),('1','153',162763,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-18 15:05:19','492','2020-11-18 15:05:47',10,0),('1','153',162903,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-19 11:45:55','492','2020-11-19 11:46:19',10,0),('1','153',163066,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-20 10:22:45','492','2020-11-20 10:23:09',10,0),('1','153',163495,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-22 14:09:52','492','2020-11-22 14:10:27',10,0),('1','153',163506,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-22 14:31:14','492','2020-11-22 14:31:36',10,0),('1','153',163509,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-22 14:48:53','492','2020-11-22 14:49:32',10,0),('1','153',163715,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-23 16:07:54','492','2020-11-23 16:08:29',10,0),('1','153',163882,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-24 16:25:52','492','2020-11-24 16:26:13',10,0),('1','153',163886,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-24 16:44:50','492','2020-11-24 16:45:12',10,0),('1','153',164055,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-25 16:12:43','492','2020-11-25 16:13:05',10,0),('1','153',164061,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-25 16:35:29','492','2020-11-25 16:35:50',10,0),('1','153',164103,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-26 08:09:12','492','2020-11-26 08:09:37',10,0),('1','153',164412,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-27 15:44:30','492','2020-11-27 15:44:57',10,0),('1','153',164550,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-28 14:12:56','492','2020-11-28 14:13:15',10,0),('1','153',164557,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-28 14:27:29','492','2020-11-28 14:27:50',10,0),('1','153',164695,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-29 14:20:06','492','2020-11-29 14:20:33',10,0),('1','153',164842,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-11-30 11:53:27','492','2020-11-30 11:53:47',10,0),('1','153',165059,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-01 14:30:46','492','2020-12-01 14:31:29',10,0),('1','153',165238,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-02 15:27:09','492','2020-12-02 15:27:35',10,0),('1','153',165245,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-02 15:47:41','492','2020-12-02 15:56:01',10,0),('1','153',165328,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-03 08:08:52','492','2020-12-03 08:21:14',10,0),('1','153',165340,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-03 09:12:51','492','2020-12-03 09:13:30',10,0),('1','153',165499,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-04 09:05:44','492','2020-12-04 09:06:07',10,0),('1','153',165728,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-05 13:58:39','492','2020-12-05 13:59:01',10,0),('1','153',165863,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-06 13:47:34','492','2020-12-06 13:47:59',10,0),('1','153',165873,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-06 14:12:17','492','2020-12-06 14:12:51',10,0),('1','153',166186,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-08 09:18:49','492','2020-12-08 09:19:11',10,0),('1','153',166191,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-08 09:43:35','492','2020-12-08 09:43:56',10,0),('1','153',166205,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-08 10:18:05','492','2020-12-08 10:18:30',10,0),('1','153',166555,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-10 09:57:00','492','2020-12-10 09:57:19',10,0),('1','153',166579,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-10 11:18:36','492','2020-12-10 11:19:02',10,0),('1','153',166780,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-11 10:55:21','492','2020-12-11 10:55:49',10,0),('1','153',167147,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-13 15:53:53','492','2020-12-13 15:54:14',10,0),('1','153',167151,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-13 16:10:18','492','2020-12-13 16:10:41',10,0),('1','153',167399,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-15 07:17:17','492','2020-12-15 07:17:40',10,0),('1','153',167400,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-15 07:39:49','492','2020-12-15 07:40:40',10,0),('1','153',167535,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-15 15:41:20','492','2020-12-15 15:41:51',10,0),('1','153',167698,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-16 15:44:59','492','2020-12-16 15:45:26',10,0),('1','153',167795,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-17 10:39:09','492','2020-12-17 10:39:36',10,0),('1','153',167800,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-17 10:58:22','492','2020-12-17 10:58:46',10,0),('1','153',168047,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-18 14:42:05','492','2020-12-18 14:42:24',10,0),('1','153',168474,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-21 10:02:16','492','2020-12-21 10:03:14',10,0),('1','153',168493,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-21 10:45:01','492','2020-12-21 10:45:45',10,0),('1','153',168509,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-21 11:26:09','492','2020-12-21 11:26:44',10,0),('1','153',168655,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-22 09:21:42','492','2020-12-22 09:22:05',10,0),('1','153',168852,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-23 11:54:16','492','2020-12-23 11:54:42',10,0),('1','153',168861,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-23 12:38:50','492','2020-12-23 12:39:11',10,0),('1','153',169043,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-24 14:16:07','492','2020-12-24 14:16:32',10,0),('1','153',169052,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-24 14:41:10','492','2020-12-24 14:41:34',10,0),('1','153',169239,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-25 15:56:41','492','2020-12-25 15:57:23',10,0),('1','153',169387,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-26 15:33:08','492','2020-12-26 15:33:42',10,0),('1','153',169392,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-26 15:58:50','492','2020-12-26 15:59:26',10,0),('1','153',169580,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-28 06:41:50','492','2020-12-28 06:42:21',10,0),('1','153',169735,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-28 14:43:29','492','2020-12-28 14:43:51',10,0),('1','153',170104,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-30 17:33:05','492','2020-12-30 17:34:19',10,0),('1','153',170168,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-31 08:24:45','492','2020-12-31 08:25:08',10,0),('1','153',170303,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-31 16:10:03','492','2020-12-31 16:10:31',10,0),('1','153',170310,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'492',0.00,0.00,'492','2020-12-31 16:46:44','492','2020-12-31 16:50:25',10,0),('1','153',170490,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-01 19:42:41','492','2021-01-01 19:43:10',10,0),('1','153',170493,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-01 20:04:06','492','2021-01-01 20:04:31',10,0),('1','153',170525,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-02 08:58:26','492','2021-01-02 08:58:47',10,0),('1','153',170594,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-02 14:50:25','492','2021-01-02 14:51:00',10,0),('1','153',170753,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-03 13:54:20','492','2021-01-03 13:54:48',10,0),('1','153',170967,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-06 14:47:54','492','2021-01-06 14:48:13',10,0),('1','153',171325,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-06 15:39:47','492','2021-01-06 15:40:22',10,0),('1','153',171331,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-06 16:11:23','492','2021-01-06 16:11:46',10,0),('1','153',171337,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-06 16:33:53','492','2021-01-06 16:34:17',10,0),('1','153',171904,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-09 14:49:20','492','2021-01-09 14:49:41',10,0),('1','153',171909,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-09 15:26:04','492','2021-01-09 15:26:25',10,0),('1','153',171918,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-09 15:58:45','492','2021-01-09 15:59:09',10,0),('1','153',171985,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-10 10:22:24','492','2021-01-10 10:22:51',10,0),('1','153',171993,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-10 10:51:05','492','2021-01-10 10:51:43',10,0),('1','153',172195,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-11 13:38:48','492','2021-01-11 13:39:09',10,0),('1','153',172446,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-13 11:20:20','492','2021-01-13 11:20:47',10,0),('1','153',172598,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-13 12:21:52','492','2021-01-13 12:22:33',10,0),('1','153',172667,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-13 16:09:49','492','2021-01-13 16:10:28',10,0),('1','153',172928,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-15 10:27:41','492','2021-01-15 10:28:03',10,0),('1','153',173010,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-15 15:51:54','492','2021-01-15 15:52:21',10,0),('1','153',173265,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-17 10:33:04','492','2021-01-17 11:50:46',10,0),('1','153',173305,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-17 13:53:42','492','2021-01-17 13:54:17',10,0),('1','153',173545,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-18 15:42:28','492','2021-01-18 15:43:06',10,0),('1','153',173668,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-19 11:27:04','492','2021-01-19 11:27:26',10,0),('1','153',173742,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-19 17:02:41','492','2021-01-19 17:03:18',10,0),('1','153',173837,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-20 11:56:31','492','2021-01-20 11:56:47',10,0),('1','153',174112,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-21 17:28:10','492','2021-01-21 17:28:38',10,0),('1','153',174119,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-21 18:34:15','492','2021-01-21 18:34:37',10,0),('1','153',174156,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-22 08:55:33','492','2021-01-22 08:55:49',10,0),('1','153',174507,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-24 09:01:47','492','2021-01-24 09:02:06',10,0),('1','153',175029,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-26 18:26:20','492','2021-01-26 18:26:42',10,0),('1','153',175035,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-26 20:17:11','492','2021-01-26 20:17:36',10,0),('1','153',175040,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-26 20:56:18','492','2021-01-26 20:56:47',10,0),('1','153',175063,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-27 14:05:27','492','2021-01-27 14:05:48',10,0),('1','153',175176,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-27 14:52:17','492','2021-01-27 14:52:35',10,0),('1','153',175196,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-27 15:53:42','492','2021-01-27 15:54:05',10,0),('1','153',175214,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-27 17:26:17','492','2021-01-27 17:26:36',10,0),('1','153',175309,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-28 11:39:56','492','2021-01-28 11:40:14',10,0),('1','153',175454,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-29 09:22:10','492','2021-01-29 09:22:38',10,0),('1','153',175472,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-29 10:10:06','492','2021-01-29 10:10:27',10,0),('1','153',175783,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-31 10:43:36','492','2021-01-31 10:44:16',10,0),('1','153',175823,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'492',0.00,0.00,'492','2021-01-31 11:35:25','492','2021-01-31 11:35:49',10,0),('1','153',176061,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-01 14:08:28','492','2021-02-01 14:09:16',10,0),('1','153',176074,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-01 14:53:54','492','2021-02-01 14:54:22',10,0),('1','153',176534,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-03 19:59:22','492','2021-02-03 19:59:56',10,0),('1','153',176556,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-04 05:38:13','492','2021-02-04 05:38:40',10,0),('1','153',176558,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-04 06:03:50','492','2021-02-04 06:04:17',10,0),('1','153',176931,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-05 16:51:59','492','2021-02-05 16:52:33',10,0),('1','153',177027,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-06 20:56:45','492','2021-02-06 20:57:12',10,0),('1','153',177221,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-06 21:04:43','492','2021-02-06 21:05:16',10,0),('1','153',177222,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-06 21:24:49','492','2021-02-06 21:25:34',10,0),('1','153',177307,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'492',0.00,0.00,'492','2021-02-07 11:48:14','492','2021-02-07 11:49:51',10,0),('1','153',177531,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'492',0.00,0.00,'581','2021-02-09 14:15:08','581','2021-02-09 14:15:28',10,0),('1','153',177794,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-09 14:53:01','581','2021-02-09 14:53:23',10,0),('1','153',177810,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-10 06:26:39','581','2021-02-10 06:28:43',10,0),('1','153',177888,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-11 14:06:30','581','2021-02-11 14:07:00',10,0),('1','153',178214,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-11 14:35:19','581','2021-02-11 14:35:44',10,0),('1','153',178228,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-11 15:38:22','581','2021-02-11 15:38:47',10,0),('1','153',178236,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-12 09:18:09','581','2021-02-12 09:18:38',10,0),('1','153',178331,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-12 20:55:01','581','2021-02-12 20:55:25',10,0),('1','153',178491,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-14 07:35:14','581','2021-02-14 07:35:37',10,0),('1','153',178741,'DAILY SHIFTS','2021-02-14','2021-02-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-14 21:51:35','581','2021-02-14 21:52:07',10,0),('1','153',178911,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-16 05:38:05','581','2021-02-16 05:38:44',10,0),('1','153',179139,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-17 05:54:42','581','2021-02-17 05:55:04',10,0),('1','153',179363,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-17 16:53:04','581','2021-02-17 16:53:39',10,0),('1','153',179538,'DAILY SHIFT report','2021-02-17','2021-02-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-18 06:09:59','581','2021-02-18 06:10:19',10,0),('1','153',179567,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-18 21:29:30','581','2021-02-18 21:30:08',10,0),('1','153',179766,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-19 19:40:19','581','2021-02-19 19:40:39',10,0),('1','153',179986,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-20 13:07:21','581','2021-02-20 13:08:33',10,0),('1','153',180082,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-21 06:01:24','581','2021-02-21 06:01:46',10,0),('1','153',180171,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-22 10:38:38','581','2021-02-22 10:39:06',10,0),('1','153',180418,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-22 11:23:25','581','2021-02-22 11:23:47',10,0),('1','153',180430,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-23 05:55:27','581','2021-02-23 05:55:52',10,0),('1','153',180545,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-24 05:34:27','581','2021-02-24 05:34:54',10,0),('1','153',180731,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-25 06:03:00','581','2021-02-25 06:03:27',10,0),('1','153',180954,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-26 07:03:33','581','2021-02-26 07:04:17',10,0),('1','153',181138,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-27 08:10:40','581','2021-02-27 08:11:04',10,0),('1','153',181360,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-28 08:01:43','581','2021-02-28 08:02:16',10,0),('1','153',181538,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-02-28 21:51:53','581','2021-02-28 21:52:16',10,0),('1','153',181707,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-01 12:45:11','581','2021-03-01 12:45:36',10,0),('1','153',181789,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-02 05:59:12','581','2021-03-02 05:59:45',10,0),('1','153',181901,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-03 07:32:26','581','2021-03-03 07:32:56',10,0),('1','153',182119,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-04 06:17:56','581','2021-03-04 06:18:23',10,0),('1','153',182306,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-05 05:55:39','581','2021-03-05 05:56:04',10,0),('1','153',182490,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-06 10:54:49','581','2021-03-06 10:55:14',10,0),('1','153',182746,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-07 05:39:49','581','2021-03-07 05:40:15',10,0),('1','153',182830,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-07 22:31:01','581','2021-03-07 22:31:33',10,0),('1','153',182979,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-07 22:56:50','581','2021-03-07 22:57:15',10,0),('1','153',182983,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-09 06:18:57','581','2021-03-09 06:19:30',10,0),('1','153',183206,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-09 11:27:54','581','2021-03-09 11:28:24',10,0),('1','153',183302,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-09 20:58:50','581','2021-03-09 20:59:23',10,0),('1','153',183421,'DAILY SHIFT ','2021-03-10','2021-03-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-11 05:38:01','581','2021-03-11 05:38:28',10,0),('1','153',183635,'DAILY SHIFT ','2021-03-11','2021-03-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-11 15:23:11','581','2021-03-11 15:23:40',10,0),('1','153',183814,'DAILY SHIFT ','2021-03-11','2021-03-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-11 20:37:12','581','2021-03-11 20:37:37',10,0),('1','153',183864,'DAILY SHIFT ','2021-03-12','2021-03-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-12 15:49:25','581','2021-03-12 15:50:44',10,0),('1','153',184096,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-13 12:54:44','581','2021-03-13 12:55:01',10,0),('1','153',184146,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-14 06:57:54','581','2021-03-14 06:58:21',10,0),('1','153',184278,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-14 13:36:46','581','2021-03-14 13:43:54',10,0),('1','153',184380,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-15 06:22:02','581','2021-03-15 06:22:22',10,0),('1','153',184464,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-15 20:00:21','581','2021-03-15 20:01:22',10,0),('1','153',184670,'DAILY SHIFT ','2021-03-16','2021-03-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-16 14:48:13','581','2021-03-16 14:48:48',10,0),('1','153',184813,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-16 22:19:31','581','2021-03-16 22:20:26',10,0),('1','153',184866,'DAILY SHIFT ','2021-03-17','2021-03-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-17 20:20:54','581','2021-03-17 20:21:42',10,0),('1','153',185092,'DAILY SHIFT ','2021-03-18','2021-03-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-18 21:06:44','581','2021-03-18 21:07:13',10,0),('1','153',185252,'DAILY SHIFT ','2021-03-19','2021-03-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-19 21:08:02','581','2021-03-19 21:08:54',10,0),('1','153',185455,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-20 21:56:14','581','2021-03-20 21:57:11',10,0),('1','153',185665,'DAILY SHIFT ','2021-03-21','2021-03-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-21 12:30:17','581','2021-03-21 12:30:34',10,0),('1','153',185769,'DAILY SHIFT ','2021-03-21','2021-03-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-22 07:28:05','581','2021-03-22 07:28:50',10,0),('1','153',185895,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-22 19:48:54','581','2021-03-22 19:49:16',10,0),('1','153',186070,'DAILY SHIFT ','2021-03-23','2021-03-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-23 20:39:37','581','2021-03-23 20:40:08',10,0),('1','153',186305,'DAILY SHIFT ','2021-03-24','2021-03-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-24 20:05:30','581','2021-03-24 20:05:57',10,0),('1','153',186519,'DAILY SHIFT ','2021-03-25','2021-03-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-25 19:46:10','581','2021-03-25 19:47:13',10,0),('1','153',186737,'DAILY SHIFT ','2021-03-26','2021-03-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-26 19:36:20','581','2021-03-26 19:36:48',10,0),('1','153',186967,'DAILY SHIFT ','2021-03-27','2021-03-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-27 21:02:13','581','2021-03-27 21:02:38',10,0),('1','153',187149,'DAILY SHIFT ','2021-03-28','2021-03-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-28 20:50:07','581','2021-03-28 20:50:46',10,0),('1','153',187335,'DAILY SHIFT ','2021-03-29','2021-03-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-29 20:36:00','581','2021-03-29 20:36:32',10,0),('1','153',187561,'DAILY SHIFT ','2021-03-30','2021-03-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-30 20:08:20','581','2021-03-30 20:09:16',10,0),('1','153',187784,'DAILY SHIFT ','2021-03-31','2021-03-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-31 09:28:47','581','2021-03-31 09:29:08',10,0),('1','153',187863,'DAILY SHIFT ','2021-03-31','2021-03-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-03-31 20:37:00','581','2021-03-31 20:37:45',10,0),('1','153',188029,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-02 05:20:36','581','2021-04-02 05:21:08',10,0),('1','153',188209,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-02 16:06:56','581','2021-04-02 16:07:38',10,0),('1','153',188358,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-02 21:08:08','581','2021-04-02 21:08:40',10,0),('1','153',188405,'DAILY SHIFT ','2021-04-03','2021-04-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-03 20:56:36','581','2021-04-03 20:57:19',10,0),('1','153',188594,'DAILY SHIFT ','2021-04-04','2021-04-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-04 13:30:39','581','2021-04-04 13:30:59',10,0),('1','153',188699,'DAILY SHIFT ','2021-04-04','2021-04-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-05 08:25:04','581','2021-04-05 08:25:24',10,0),('1','153',188841,'DAILY SHIFT ','2021-04-05','2021-04-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-05 20:51:44','581','2021-04-05 20:52:31',10,0),('1','153',188990,'DAILY SHIFT ','2021-04-06','2021-04-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-06 10:07:13','581','2021-04-06 10:07:40',10,0),('1','153',189072,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-06 21:27:31','581','2021-04-06 21:28:01',10,0),('1','153',189188,'DAILY SHIFT ','2021-04-07','2021-04-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-07 21:02:18','581','2021-04-07 21:02:44',10,0),('1','153',189396,'DAILY SHIFT ','2021-04-07','2021-04-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-07 21:23:17','581','2021-04-07 21:23:38',10,0),('1','153',189401,'DAILY SHIFT ','2021-04-08','2021-04-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-08 21:44:08','581','2021-04-08 21:44:43',10,0),('1','153',189607,'DAILY SHIFT ','2021-04-09','2021-04-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-09 13:42:47','581','2021-04-09 13:43:06',10,0),('1','153',189728,'DAILY SHIFT ','2021-04-09','2021-04-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-09 21:50:27','581','2021-04-09 21:50:42',10,0),('1','153',189802,'DAILY SHIFT ','2021-04-10','2021-04-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-10 21:30:09','581','2021-04-10 21:31:07',10,0),('1','153',190020,'DAILY SHIFT ','2021-04-11','2021-04-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-11 14:10:19','581','2021-04-11 14:11:07',10,0),('1','153',190137,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-11 21:47:17','581','2021-04-11 21:48:35',10,0),('1','153',190196,'DAILY SHIFT ','2021-04-12','2021-04-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-12 16:51:02','581','2021-04-12 16:52:01',10,0),('1','153',190384,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-12 22:45:11','581','2021-04-12 22:45:48',10,0),('1','153',190419,'DAILY SHIFT ','2021-04-12','2021-04-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-14 04:46:44','581','2021-04-14 04:47:49',10,0),('1','153',190663,'DAILY SHIFT ','2021-04-14','2021-04-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-14 06:10:38','581','2021-04-14 06:11:07',10,0),('1','153',190666,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-15 05:03:39','581','2021-04-15 05:04:16',10,0),('1','153',190879,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-15 13:46:27','581','2021-04-15 13:46:52',10,0),('1','153',191004,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-16 08:33:59','581','2021-04-16 08:34:42',10,0),('1','153',191113,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-16 17:24:41','581','2021-04-16 17:25:37',10,0),('1','153',191263,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-17 07:26:20','581','2021-04-17 07:26:41',10,0),('1','153',191304,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-18 06:03:36','581','2021-04-18 06:04:14',10,0),('1','153',191490,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-18 11:45:28','581','2021-04-18 11:45:49',10,0),('1','153',191574,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-18 22:09:32','581','2021-04-18 22:10:11',10,0),('1','153',191698,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-20 05:14:03','581','2021-04-20 05:14:30',10,0),('1','153',191927,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-20 22:27:51','581','2021-04-20 22:28:51',10,0),('1','153',192187,'DAILY SHIFTS','2021-04-21','2021-04-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-21 11:47:53','581','2021-04-21 11:48:16',10,0),('1','153',192236,'DAILY SHIFTS','2021-04-21','2021-04-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-22 04:49:31','581','2021-04-22 04:50:02',10,0),('1','153',192330,'DAILY SHIFT ','2021-04-22','2021-04-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-23 05:01:03','581','2021-04-23 05:01:33',10,0),('1','153',192554,'DAILY SHIFT ','2021-04-23','2021-04-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-23 10:09:56','581','2021-04-23 10:10:25',10,0),('1','153',192624,'DAILY SHIFTS','2021-04-23','2021-04-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-24 04:54:46','581','2021-04-24 04:55:12',10,0),('1','153',192744,'DAILY SHIFT ','2021-04-24','2021-04-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-25 05:01:54','581','2021-04-25 05:02:27',10,0),('1','153',192946,'DAILY SHIFT ','2021-04-25','2021-04-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-26 04:51:35','581','2021-04-26 04:52:01',10,0),('1','153',193158,'DAILY SHIFT ','2021-04-26','2021-04-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-27 09:04:24','581','2021-04-27 09:05:06',10,0),('1','153',193452,'DAILY SHIFTS','2021-04-27','2021-04-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-28 05:02:49','581','2021-04-28 05:03:17',10,0),('1','153',193614,'DAILY SHIFT ','2021-04-28','2021-04-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-29 05:05:03','581','2021-04-29 05:05:51',10,0),('1','153',193837,'DAILY SHIFT ','2021-04-28','2021-04-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-29 05:24:43','581','2021-04-29 05:25:07',10,0),('1','153',193839,'DAILY SHIFT ','2021-04-29','2021-04-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-04-30 05:03:18','581','2021-04-30 05:03:42',10,0),('1','153',194072,'DAILY SHIFT ','2021-04-30','2021-04-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-01 05:05:32','581','2021-05-01 05:05:59',10,0),('1','153',194277,'DAILY SHIFT ','2021-05-01','2021-05-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-02 04:54:52','581','2021-05-02 04:55:17',10,0),('1','153',194477,'DAILY SHIFT ','2021-05-02','2021-05-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-03 04:43:49','581','2021-05-03 04:44:20',10,0),('1','153',194659,'DAILY SHIFT ','2021-05-03','2021-05-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-04 15:45:49','581','2021-05-04 15:46:48',10,0),('1','153',195013,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-05 04:51:25','581','2021-05-05 04:51:49',10,0),('1','153',195070,'DAILY SHIFT ','2021-05-05','2021-05-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-06 04:33:09','581','2021-05-06 04:33:54',10,0),('1','153',195292,'DAILY SHIFT ','2021-05-06','2021-05-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-07 05:09:23','581','2021-05-07 05:10:06',10,0),('1','153',195509,'DAILY SHIFT ','2021-05-07','2021-05-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-07 05:32:25','581','2021-05-07 05:33:10',10,0),('1','153',195512,'DAILY SHIFT ','2021-05-07','2021-05-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-07 21:03:12','581','2021-05-07 21:03:57',10,0),('1','153',195766,'DAILY SHIFT ','2021-05-08','2021-05-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-08 14:15:07','581','2021-05-08 14:15:42',10,0),('1','153',195915,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-08 20:00:45','581','2021-05-08 20:01:14',10,0),('1','153',195991,'DAILY SHIFT ','2021-05-09','2021-05-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-10 07:17:16','581','2021-05-10 07:17:56',10,0),('1','153',196251,'DAILY SHIFT ','2021-05-10','2021-05-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-10 14:23:22','581','2021-05-10 14:25:02',10,0),('1','153',196372,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-11 04:44:26','581','2021-05-11 04:44:48',10,0),('1','153',196436,'DAILY SHIFT ','2021-05-11','2021-05-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-12 04:43:26','581','2021-05-12 04:44:17',10,0),('1','153',196653,'DAILY SHIFT ','2021-05-12','2021-05-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-13 20:30:53','581','2021-05-13 20:31:22',10,0),('1','153',197004,'DAILY SHIFT ','2021-05-13','2021-05-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-13 20:55:57','581','2021-05-13 20:56:24',10,0),('1','153',197017,'DAILY SHIFT ','2021-05-14','2021-05-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-14 21:07:56','581','2021-05-14 21:08:30',10,0),('1','153',197242,'DAILY SHIFTS','2021-05-15','2021-05-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-15 20:01:57','581','2021-05-15 20:02:25',10,0),('1','153',197243,'DAILY SHIFTS','2021-05-15','2021-05-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-15 20:16:39','581','2021-05-15 20:16:58',10,0),('1','153',197287,'DAILY SHIFTS','2021-05-16','2021-05-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-16 20:40:36','581','2021-05-16 20:41:01',10,0),('1','153',197511,'DAILY SHIFT ','2021-05-17','2021-05-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-18 04:52:21','581','2021-05-18 04:52:42',10,0),('1','153',197859,'DAILY SHIFT ','2021-05-18','2021-05-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-19 10:33:26','581','2021-05-19 10:34:14',10,0),('1','153',198200,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-19 11:09:03','581','2021-05-19 11:09:22',10,0),('1','153',198212,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-19 20:16:17','581','2021-05-19 20:16:39',10,0),('1','153',198349,'DAILY SHIFT ','2021-05-20','2021-05-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-21 05:06:34','581','2021-05-21 05:07:13',10,0),('1','153',198556,'DAILY SHIFT ','2021-05-21','2021-05-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-22 09:16:34','581','2021-05-22 09:16:54',10,0),('1','153',198838,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-23 11:19:37','581','2021-05-23 11:20:21',10,0),('1','153',199079,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-24 05:29:02','581','2021-05-24 05:29:42',10,0),('1','153',199197,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-24 22:16:24','581','2021-05-24 22:17:13',10,0),('1','153',199436,'DAILY SHIFT ','2021-05-25','2021-05-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-25 06:54:41','581','2021-05-25 06:54:59',10,0),('1','153',199444,'DAILY SHIFT ','2021-05-25','2021-05-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-26 06:29:12','581','2021-05-26 06:29:58',10,0),('1','153',199652,'DAILY SHIFT ','2021-05-26','2021-05-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-27 05:09:10','581','2021-05-27 05:09:32',10,0),('1','153',199857,'DAILY SHIFT ','2021-05-27','2021-05-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-28 07:55:19','581','2021-05-28 07:55:49',10,0),('1','153',200127,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-29 05:29:03','581','2021-05-29 05:29:23',10,0),('1','153',200285,'DAILY SHIFT ','2021-05-29','2021-05-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-30 05:05:20','581','2021-05-30 05:05:42',10,0),('1','153',200481,'DAILY SHIFT ','2021-05-30','2021-05-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-05-31 04:46:22','581','2021-05-31 04:46:48',10,0),('1','153',200683,'DAILY SHIFT ','2021-05-31','2021-05-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-01 10:35:44','581','2021-06-01 10:36:25',10,0),('1','153',200994,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-01 19:17:30','581','2021-06-01 19:31:58',10,0),('1','153',201090,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-01 19:43:01','581','2021-06-01 19:43:25',10,0),('1','153',201096,'DAILY SHIFT ','2021-06-02','2021-06-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-03 04:50:46','581','2021-06-03 04:53:24',10,0),('1','153',201299,'DAILY SHIFT ','2021-06-03','2021-06-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-03 16:59:22','581','2021-06-03 16:59:49',10,0),('1','153',201467,'DAILY SHIFT ','2021-06-03','2021-06-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-04 06:15:45','581','2021-06-04 06:16:06',10,0),('1','153',201496,'DAILY SHIFT ','2021-06-04','2021-06-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-04 21:43:55','581','2021-06-04 21:44:41',10,0),('1','153',201743,'DAILY SHIFT ','2021-06-04','2021-06-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-05 05:02:13','581','2021-06-05 05:02:31',10,0),('1','153',201754,'DAILY SHIFT ','2021-06-05','2021-06-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-06 05:29:26','581','2021-06-06 05:29:54',10,0),('1','153',202021,'DAILY SHIFT ','2021-06-06','2021-06-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-06 12:34:48','581','2021-06-06 12:35:41',10,0),('1','153',202113,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-07 07:31:38','581','2021-06-07 07:32:14',10,0),('1','153',202251,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-08 05:12:25','581','2021-06-08 05:12:55',10,0),('1','153',202419,'DAILY SHIFT ','2021-06-08','2021-06-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-08 14:42:00','581','2021-06-08 14:42:58',10,0),('1','153',202569,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-09 05:22:52','581','2021-06-09 05:23:18',10,0),('1','153',202640,'DAILY SHIFT ','2021-06-09','2021-06-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-10 05:17:51','581','2021-06-10 05:18:24',10,0),('1','153',202842,'DAILY SHIFT ','2021-06-10','2021-06-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-10 06:42:16','581','2021-06-10 06:42:41',10,0),('1','153',202867,'DAILY SHIFT ','2021-06-10','2021-06-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-10 15:42:01','581','2021-06-10 15:43:19',10,0),('1','153',203042,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-11 05:13:28','581','2021-06-11 05:15:11',10,0),('1','153',203097,'DAILY SHIFT ','2021-06-11','2021-06-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-12 06:22:33','581','2021-06-12 06:23:49',10,0),('1','153',203311,'DAILY SHIFT ','2021-06-12','2021-06-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-13 05:18:56','581','2021-06-13 05:24:37',10,0),('1','153',203516,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-14 06:23:24','581','2021-06-14 06:24:38',10,0),('1','153',203732,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-15 06:14:34','581','2021-06-15 06:15:28',10,0),('1','153',203966,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-16 05:23:55','581','2021-06-16 05:26:01',10,0),('1','153',204182,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-16 09:18:40','581','2021-06-16 09:19:25',10,0),('1','153',204249,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-16 21:28:02','581','2021-06-16 21:29:30',10,0),('1','153',204373,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-18 06:29:52','581','2021-06-18 06:31:10',10,0),('1','153',204628,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-19 03:56:24','581','2021-06-19 03:57:11',10,0),('1','153',204824,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-20 04:44:23','581','2021-06-20 04:45:23',10,0),('1','153',205029,'DAILY SHIFT ','2021-06-20','2021-06-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-21 06:27:31','581','2021-06-21 06:28:21',10,0),('1','153',205243,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-22 04:43:03','581','2021-06-22 04:43:29',10,0),('1','153',205463,'DAILY SHIFT ','2021-06-22','2021-06-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-23 05:29:44','581','2021-06-23 05:31:40',10,0),('1','153',205718,'DAILY SHIFT ','2021-06-23','2021-06-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-24 05:33:18','581','2021-06-24 05:34:11',10,0),('1','153',205937,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-24 09:08:28','581','2021-06-24 09:10:42',10,0),('1','153',206000,'DAILY SHIFT ','2021-06-24','2021-06-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-25 06:23:34','581','2021-06-25 06:27:25',10,0),('1','153',206153,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-26 04:48:40','581','2021-06-26 04:49:27',10,0),('1','153',206346,'DAILY SHIFT ','2021-06-26','2021-06-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-26 21:23:02','581','2021-06-26 21:24:44',10,0),('1','153',206548,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-27 03:53:55','581','2021-06-27 03:54:22',10,0),('1','153',206559,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-27 21:52:50','581','2021-06-27 21:53:42',10,0),('1','153',206789,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-28 13:31:44','581','2021-06-28 13:32:23',10,0),('1','153',206942,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-28 20:54:55','581','2021-06-28 20:55:42',10,0),('1','153',207008,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-06-29 22:36:10','581','2021-06-29 22:37:21',10,0),('1','153',207235,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-01 05:51:31','581','2021-07-01 05:53:01',10,0),('1','153',207475,'DAILY SHIFT ','2021-07-01','2021-07-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-01 16:39:02','581','2021-07-01 16:39:59',10,0),('1','153',207647,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-02 06:17:22','581','2021-07-02 06:17:43',10,0),('1','153',207703,'DAILY SHIFT ','2021-07-02','2021-07-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-02 21:49:26','581','2021-07-02 21:52:07',10,0),('1','153',207899,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-04 05:37:33','581','2021-07-04 05:38:23',10,0),('1','153',208102,'DAILY SHIFT ','2021-07-04','2021-07-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-04 22:30:49','581','2021-07-04 22:32:33',10,0),('1','153',208310,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-06 07:21:45','581','2021-07-06 07:22:53',10,0),('1','153',208563,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-06 15:43:19','581','2021-07-06 15:45:37',10,0),('1','153',208714,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-06 21:37:56','581','2021-07-06 21:38:45',10,0),('1','153',208744,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-08 06:24:34','581','2021-07-08 06:25:35',10,0),('1','153',208999,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-09 06:42:05','581','2021-07-09 07:00:45',10,0),('1','153',209225,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-09 22:29:05','581','2021-07-09 22:30:36',10,0),('1','153',209423,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-11 05:00:45','581','2021-07-11 05:03:16',10,0),('1','153',209631,'DAILY SHIFT ','2021-07-11','2021-07-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-11 17:06:18','581','2021-07-11 17:06:59',10,0),('1','153',209813,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-12 05:28:15','581','2021-07-12 05:28:44',10,0),('1','153',209854,'DAILY SHIFT ','2021-07-12','2021-07-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-13 05:04:17','581','2021-07-13 05:09:31',10,0),('1','153',210089,'DAILY SHIFTS','2021-07-13','2021-07-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-13 19:03:24','581','2021-07-13 19:04:20',10,0),('1','153',210302,'DAILY SHIFT ','2021-07-14','2021-07-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-14 20:42:33','581','2021-07-15 05:55:18',10,0),('1','153',210509,'DAILY SHIFT ','2021-07-15','2021-07-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-16 05:50:24','581','2021-07-16 05:51:25',10,0),('1','153',210723,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-17 05:14:53','581','2021-07-17 06:09:32',10,0),('1','153',210944,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-17 21:06:29','581','2021-07-17 21:07:58',10,0),('1','153',211159,'DAILY SHIFT ','2021-07-18','2021-07-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-19 05:10:47','581','2021-07-19 05:16:30',10,0),('1','153',211360,'DAILY SHIFT ','2021-07-19','2021-07-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-20 07:17:57','581','2021-07-20 07:29:54',10,0),('1','153',211607,'DAILY SHIFT ','2021-07-20','2021-07-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-20 22:10:12','581','2021-07-20 22:14:27',10,0),('1','153',211765,'DAILY SHIFT ','2021-07-21','2021-07-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-22 04:04:02','581','2021-07-22 04:05:44',10,0),('1','153',211975,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-23 06:02:32','581','2021-07-23 06:07:27',10,0),('1','153',212224,'DAILY SHIFT ','2021-07-23','2021-07-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-24 04:39:40','581','2021-07-24 04:41:49',10,0),('1','153',212446,'DAILY SHIFT ','2021-07-24','2021-07-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-24 11:05:54','581','2021-07-24 11:09:02',10,0),('1','153',212538,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-24 22:26:00','581','2021-07-24 22:28:08',10,0),('1','153',212653,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-26 03:58:56','581','2021-07-26 04:01:58',10,0),('1','153',212855,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-26 21:29:35','581','2021-07-26 21:32:51',10,0),('1','153',213115,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-27 17:21:50','581','2021-07-27 17:24:56',10,0),('1','153',213352,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-28 06:00:18','581','2021-07-28 06:00:43',10,0),('1','153',213383,'DAILY SHIFT ','2021-07-28','2021-07-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-29 04:01:27','581','2021-07-29 05:43:45',10,0),('1','153',213620,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-29 12:25:46','581','2021-07-29 12:27:41',10,0),('1','153',213742,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-30 04:58:46','581','2021-07-30 05:03:40',10,0),('1','153',213870,'DAILY SHIFT ','2021-07-30','2021-07-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-07-30 19:05:46','581','2021-07-30 19:35:50',10,0),('1','153',214110,'DAILY SHIFT ','2021-07-31','2021-07-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-01 05:57:18','581','2021-08-01 06:10:05',10,0),('1','153',214333,'DAILY SHIFT ','2021-08-01','2021-08-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-01 15:08:30','581','2021-08-01 15:12:22',10,0),('1','153',214475,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-01 22:02:39','581','2021-08-01 22:04:44',10,0),('1','153',214551,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-03 04:11:07','581','2021-08-03 04:22:48',10,0),('1','153',214759,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-03 10:48:28','581','2021-08-03 10:49:04',10,0),('1','153',214865,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-03 21:42:48','581','2021-08-03 21:45:40',10,0),('1','153',214986,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-04 20:43:16','581','2021-08-04 20:45:15',10,0),('1','153',215212,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-05 21:56:38','581','2021-08-05 22:09:25',10,0),('1','153',215429,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-06 21:47:36','581','2021-08-06 21:51:02',10,0),('1','153',215662,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-07 21:27:44','581','2021-08-07 21:45:43',10,0),('1','153',215894,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-08 21:11:58','581','2021-08-08 21:15:24',10,0),('1','153',216088,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-09 12:55:08','581','2021-08-09 13:02:44',10,0),('1','153',216233,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-09 20:25:04','581','2021-08-09 20:35:48',10,0),('1','153',216308,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-10 21:33:38','581','2021-08-10 21:36:58',10,0),('1','153',216540,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-11 21:08:40','581','2021-08-11 21:23:43',10,0),('1','153',216867,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-12 20:08:36','581','2021-08-12 20:15:08',10,0),('1','153',217009,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-13 21:07:08','581','2021-08-13 21:18:09',10,0),('1','153',217260,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-14 19:15:00','581','2021-08-14 19:34:21',10,0),('1','153',217510,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-15 20:03:27','581','2021-08-15 20:05:15',10,0),('1','153',217789,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-16 21:14:58','581','2021-08-16 21:18:25',10,0),('1','153',217967,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-17 08:16:12','581','2021-08-17 08:16:47',10,0),('1','153',218027,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-17 20:17:24','581','2021-08-17 20:19:07',10,0),('1','153',218309,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-18 20:14:17','581','2021-08-18 20:18:09',10,0),('1','153',218434,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-19 13:00:15','581','2021-08-19 13:03:13',10,0),('1','153',218566,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-19 18:40:54','581','2021-08-19 18:50:38',10,0),('1','153',218664,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-20 18:24:12','581','2021-08-20 18:33:42',10,0),('1','153',218894,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-21 19:28:31','581','2021-08-21 19:32:57',10,0),('1','153',219108,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-22 18:15:14','581','2021-08-22 18:28:49',10,0),('1','153',219332,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-23 15:57:31','581','2021-08-23 16:00:20',10,0),('1','153',219532,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-23 18:37:33','581','2021-08-23 18:38:27',10,0),('1','153',219573,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-24 19:48:36','581','2021-08-24 19:56:34',10,0),('1','153',219794,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-25 18:43:11','581','2021-08-25 18:45:49',10,0),('1','153',220018,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-26 20:22:09','581','2021-08-26 20:28:02',10,0),('1','153',220224,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-27 18:39:55','581','2021-08-27 18:44:11',10,0),('1','153',220451,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-28 19:01:42','581','2021-08-28 20:20:04',10,0),('1','153',220672,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-29 18:47:27','581','2021-08-29 18:51:07',10,0),('1','153',220891,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-30 00:04:35','581','2021-08-30 00:19:03',10,0),('1','153',220892,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-30 20:12:25','581','2021-08-30 20:16:36',10,0),('1','153',221124,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-31 14:54:19','581','2021-08-31 15:03:39',10,0),('1','153',221340,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-08-31 18:46:20','581','2021-08-31 18:46:44',10,0),('1','153',221371,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-01 18:55:51','581','2021-09-01 18:58:58',10,0),('1','153',221600,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-02 19:02:30','581','2021-09-02 19:14:29',10,0),('1','153',221811,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-03 18:49:47','581','2021-09-03 18:53:36',10,0),('1','153',222044,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-04 21:06:53','581','2021-09-04 21:10:57',10,0),('1','153',222257,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-05 13:45:27','581','2021-09-05 13:46:00',10,0),('1','153',222406,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-05 18:33:02','581','2021-09-05 18:34:24',10,0),('1','153',222474,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-06 18:43:34','581','2021-09-06 18:46:44',10,0),('1','153',222716,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-08 16:30:02','581','2021-09-08 16:32:03',10,0),('1','153',223130,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-08 22:23:04','581','2021-09-08 22:23:36',10,0),('1','153',223161,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-09 06:38:55','581','2021-09-09 06:39:20',10,0),('1','153',223184,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-09 06:54:22','581','2021-09-09 06:54:46',10,0),('1','153',223190,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-09 13:17:12','581','2021-09-09 13:19:29',10,0),('1','153',223310,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-09 18:45:37','581','2021-09-09 18:47:43',10,0),('1','153',223403,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-10 21:03:29','581','2021-09-10 21:07:49',10,0),('1','153',223627,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-11 17:34:29','581','2021-09-11 17:39:06',10,0),('1','153',223875,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-12 19:00:49','581','2021-09-12 19:03:00',10,0),('1','153',224064,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-13 15:17:00','581','2021-09-13 15:20:03',10,0),('1','153',224258,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-13 20:28:47','581','2021-09-13 20:30:25',10,0),('1','153',224292,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-14 20:18:09','581','2021-09-14 20:28:05',10,0),('1','153',224518,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-15 20:32:11','581','2021-09-15 20:36:42',10,0),('1','153',224763,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-16 18:39:15','581','2021-09-16 18:53:12',10,0),('1','153',225019,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-17 18:37:38','581','2021-09-17 18:58:05',10,0),('1','153',225245,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-18 17:48:37','581','2021-09-18 17:59:33',10,0),('1','153',225451,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-18 21:12:27','581','2021-09-18 21:12:59',10,0),('1','153',225469,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-19 17:45:24','581','2021-09-19 17:47:59',10,0),('1','153',225678,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-20 21:26:12','581','2021-09-20 21:28:59',10,0),('1','153',225960,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-21 20:29:58','581','2021-09-21 20:38:33',10,0),('1','153',226226,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-22 20:23:31','581','2021-09-22 20:34:26',10,0),('1','153',226467,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-23 13:33:45','581','2021-09-23 13:47:25',10,0),('1','153',226654,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-23 19:39:52','581','2021-09-23 21:03:23',10,0),('1','153',226717,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-24 20:10:36','581','2021-09-24 20:16:27',10,0),('1','153',226940,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-25 21:36:38','581','2021-09-25 21:44:31',10,0),('1','153',227171,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-26 18:32:27','581','2021-09-26 18:37:05',10,0),('1','153',227372,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-27 20:39:11','581','2021-09-27 20:44:46',10,0),('1','153',227587,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-27 21:23:30','581','2021-09-27 21:26:30',10,0),('1','153',227595,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-28 19:00:33','581','2021-09-28 21:13:50',10,0),('1','153',227834,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-29 18:38:20','581','2021-09-29 18:41:22',10,0),('1','153',228104,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-09-30 19:10:39','581','2021-09-30 20:22:47',10,0),('1','153',228337,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-01 19:38:17','581','2021-10-01 19:46:39',10,0),('1','153',228518,'DAILY SHIFT ','2021-10-02','2021-10-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-02 11:02:04','581','2021-10-02 11:03:53',10,0),('1','153',228599,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-02 11:20:40','581','2021-10-02 11:21:21',10,0),('1','153',228602,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-02 20:14:42','581','2021-10-02 20:19:53',10,0),('1','153',228744,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-03 21:27:55','581','2021-10-03 21:40:47',10,0),('1','153',228923,'DAILY SHIFT ','2021-10-04','2021-10-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-04 21:22:20','581','2021-10-04 21:27:53',10,0),('1','153',229156,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-05 18:36:56','581','2021-10-05 19:12:03',10,0),('1','153',229403,'DAILY SHIFT ','2021-10-06','2021-10-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-06 06:04:36','581','2021-10-06 06:33:08',10,0),('1','153',229418,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-06 06:43:58','581','2021-10-06 06:44:28',10,0),('1','153',229422,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-06 10:49:33','581','2021-10-06 10:53:10',10,0),('1','153',229522,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-06 11:28:34','581','2021-10-06 11:29:32',10,0),('1','153',229536,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-06 20:29:45','581','2021-10-07 05:23:02',10,0),('1','153',229653,'DAILY SHIFT ','2021-10-07','2021-10-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-07 18:49:19','581','2021-10-07 18:52:48',10,0),('1','153',229872,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-08 21:51:45','581','2021-10-08 22:00:53',10,0),('1','153',230070,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-08 22:32:49','581','2021-10-08 22:33:46',10,0),('1','153',230077,'DAILY SHIFT ','2021-10-09','2021-10-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-09 20:38:26','581','2021-10-09 20:40:52',10,0),('1','153',230266,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-09 20:47:29','581','2021-10-09 20:48:26',10,0),('1','153',230276,'DAILY SHIFT ','2021-10-10','2021-10-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-10 21:45:27','581','2021-10-10 21:47:47',10,0),('1','153',230503,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-10 21:58:40','581','2021-10-10 22:00:04',10,0),('1','153',230510,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-11 20:20:35','581','2021-10-11 20:24:40',10,0),('1','153',230771,'DAILY SHIFT ','2021-10-12','2021-10-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-12 18:59:25','581','2021-10-12 19:06:02',10,0),('1','153',231063,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-13 22:06:30','581','2021-10-13 22:13:13',10,0),('1','153',231353,'DAILY SHIFT ','2021-10-14','2021-10-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-14 13:49:13','581','2021-10-14 13:49:54',10,0),('1','153',231531,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-14 13:59:17','581','2021-10-14 13:59:59',10,0),('1','153',231534,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-14 19:25:46','581','2021-10-14 19:26:46',10,0),('1','153',231635,'DAILY SHIFT ','2021-10-15','2021-10-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-15 20:57:48','581','2021-10-15 20:58:29',10,0),('1','153',231874,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-16 13:25:52','581','2021-10-16 13:26:57',10,0),('1','153',232010,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-16 20:17:12','581','2021-10-16 20:24:31',10,0),('1','153',232084,'DAILY SHIFT ','2021-10-17','2021-10-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-17 21:22:46','581','2021-10-17 21:38:38',10,0),('1','153',232315,'DAILY SHIFT ','2021-10-18','2021-10-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-18 20:51:02','581','2021-10-18 21:02:48',10,0),('1','153',232569,'DAILY SHIFT ','2021-10-19','2021-10-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-19 14:13:13','581','2021-10-19 14:31:51',10,0),('1','153',232746,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-19 20:38:20','581','2021-10-19 20:46:13',10,0),('1','153',232824,'DAILY SHIFT ','2021-10-20','2021-10-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-20 20:52:48','581','2021-10-20 21:03:07',10,0),('1','153',233093,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-21 03:44:00','581','2021-10-21 03:44:39',10,0),('1','153',233094,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-21 21:04:15','581','2021-10-21 21:11:39',10,0),('1','153',233354,'DAILY SHIFT ','2021-10-22','2021-10-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-22 20:45:01','581','2021-10-22 21:02:07',10,0),('1','153',233582,'DAILY SHIFT ','2021-10-23','2021-10-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-23 20:55:38','581','2021-10-23 20:59:44',10,0),('1','153',233822,'DAILY SHIFT ','2021-10-24','2021-10-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-24 20:19:06','581','2021-10-24 20:23:35',10,0),('1','153',234030,'DAILY SHIFT ','2021-10-25','2021-10-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-26 02:12:17','581','2021-10-26 02:15:12',10,0),('1','153',234348,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-26 17:35:16','581','2021-10-26 17:41:07',10,0),('1','153',234517,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-26 17:47:15','581','2021-10-26 17:47:51',10,0),('1','153',234534,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-26 20:32:21','581','2021-10-26 20:33:08',10,0),('1','153',234592,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-27 20:36:35','581','2021-10-27 20:42:27',10,0),('1','153',234816,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-28 21:12:04','581','2021-10-28 21:28:49',10,0),('1','153',235046,'DAILY SHIFT ','2021-10-29','2021-10-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-29 21:59:00','581','2021-10-29 22:06:33',10,0),('1','153',235280,'DAILY SHIFT ','2021-10-30','2021-10-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-30 20:47:07','581','2021-10-30 21:21:37',10,0),('1','153',235530,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-31 19:23:12','581','2021-10-31 19:54:09',10,0),('1','153',235728,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-10-31 22:06:50','581','2021-10-31 22:07:34',10,0),('1','153',235815,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-01 08:25:33','581','2021-11-01 08:54:47',10,0),('1','153',235839,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-01 22:05:07','581','2021-11-01 22:12:09',10,0),('1','153',236013,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-02 14:41:42','581','2021-11-02 15:46:17',10,0),('1','153',236171,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-02 21:20:13','581','2021-11-02 21:21:11',10,0),('1','153',236219,'DAILY SHIFT ','2021-11-03','2021-11-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-03 21:31:55','581','2021-11-03 21:37:20',10,0),('1','153',236487,'DAILY SHIFT ','2021-11-04','2021-11-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-04 23:45:08','581','2021-11-04 23:54:18',10,0),('1','153',236715,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-05 22:01:24','581','2021-11-05 22:03:29',10,0),('1','153',236934,'DAILY SHIFT ','2021-11-06','2021-11-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-06 21:51:32','581','2021-11-06 21:53:12',10,0),('1','153',237149,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-07 10:04:54','581','2021-11-07 10:06:13',10,0),('1','153',237246,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-07 10:37:30','581','2021-11-07 10:37:52',10,0),('1','153',237255,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-07 22:28:58','581','2021-11-07 22:29:40',10,0),('1','153',237363,'DAILY SHIFT ','2021-11-08','2021-11-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-08 23:04:50','581','2021-11-08 23:07:21',10,0),('1','153',237585,'DAILY SHIFT ','2021-11-09','2021-11-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-09 22:02:53','581','2021-11-09 22:22:37',10,0),('1','153',237845,'DAILY SHIFT ','2021-11-10','2021-11-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-11 01:32:48','581','2021-11-11 01:33:58',10,0),('1','153',238105,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-11 22:59:32','581','2021-11-11 23:00:44',10,0),('1','153',238332,'DAILY SHIFT ','2021-11-12','2021-11-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-12 23:19:46','581','2021-11-12 23:20:45',10,0),('1','153',238593,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-13 11:21:23','581','2021-11-13 11:22:19',10,0),('1','153',238703,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-13 11:26:37','581','2021-11-13 11:26:55',10,0),('1','153',238705,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-13 20:14:14','581','2021-11-13 20:15:17',10,0),('1','153',238816,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-14 21:05:59','581','2021-11-14 21:07:11',10,0),('1','153',239051,'DAILY SHIFT ','2021-11-15','2021-11-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-15 21:26:21','581','2021-11-15 21:27:44',10,0),('1','153',239276,'DAILY SHIFT ','2021-11-16','2021-11-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-16 22:51:52','581','2021-11-16 23:23:06',10,0),('1','153',239504,'DAILY SHIFT ','2021-11-17','2021-11-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-17 21:42:44','581','2021-11-17 22:32:06',10,0),('1','153',239765,'DAILY SHIFT ','2021-11-18','2021-11-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-18 21:03:13','581','2021-11-18 21:04:24',10,0),('1','153',239968,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-19 22:03:16','581','2021-11-19 22:13:29',10,0),('1','153',240173,'DAILY SHIFT ','2021-11-20','2021-11-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-20 16:48:59','581','2021-11-20 16:50:00',10,0),('1','153',240358,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-20 16:58:50','581','2021-11-20 16:59:13',10,0),('1','153',240359,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-20 21:05:32','581','2021-11-20 21:06:00',10,0),('1','153',240430,'DAILY SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-21 19:45:17','581','2021-11-21 19:48:09',10,0),('1','153',240651,'DAILY SHIFT ','2021-11-22','2021-11-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-22 20:25:51','581','2021-11-22 20:27:28',10,0),('1','153',240958,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-23 20:24:08','581','2021-11-23 20:26:52',10,0),('1','153',241198,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-24 19:56:32','581','2021-11-24 21:36:46',10,0),('1','153',241475,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-25 20:09:31','581','2021-11-25 21:17:10',10,0),('1','153',241709,'DAILY SHIFT ','2021-11-26','2021-11-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-26 21:28:45','581','2021-11-26 21:33:48',10,0),('1','153',241958,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-27 21:45:03','581','2021-11-27 21:46:32',10,0),('1','153',242191,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-28 18:06:12','581','2021-11-28 18:07:15',10,0),('1','153',242366,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-28 18:19:23','581','2021-11-28 18:19:45',10,0),('1','153',242416,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-29 20:55:14','581','2021-11-29 20:59:51',10,0),('1','153',242648,'DAILY SHIFT ','2021-11-30','2021-11-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-11-30 20:00:43','581','2021-11-30 21:00:26',10,0),('1','153',242897,'DAILY SHIFT ','2021-12-01','2021-12-01 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-01 21:55:29','581','2021-12-02 05:58:16',10,0),('1','153',243137,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-02 20:56:18','581','2021-12-02 20:57:19',10,0),('1','153',243343,'DAILY SHIFT ','2021-12-03','2021-12-03 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-03 20:34:36','581','2021-12-03 20:36:47',10,0),('1','153',243589,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-04 23:36:30','581','2021-12-04 23:42:41',10,0),('1','153',243817,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-05 20:44:10','581','2021-12-05 21:11:26',10,0),('1','153',244034,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-06 21:10:44','581','2021-12-06 21:53:19',10,0),('1','153',244259,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-06 22:06:41','581','2021-12-06 22:07:05',10,0),('1','153',244277,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-07 21:27:38','581','2021-12-07 22:09:35',10,0),('1','153',244503,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-08 21:10:03','581','2021-12-08 21:29:53',10,0),('1','153',244732,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-09 22:37:38','581','2021-12-09 22:39:01',10,0),('1','153',244958,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-10 21:04:40','581','2021-12-10 21:15:21',10,0),('1','153',245199,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-11 20:29:34','581','2021-12-11 21:20:58',10,0),('1','153',245423,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-12 20:35:41','581','2021-12-12 21:03:05',10,0),('1','153',245662,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-13 22:07:54','581','2021-12-13 22:16:03',10,0),('1','153',245964,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-14 23:41:30','581','2021-12-14 23:45:44',10,0),('1','153',246171,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-15 11:43:54','581','2021-12-15 11:46:15',10,0),('1','153',246330,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-15 18:26:03','581','2021-12-15 18:27:16',10,0),('1','153',246436,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-16 22:49:54','581','2021-12-16 22:51:28',10,0),('1','153',246685,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-17 23:35:01','581','2021-12-17 23:36:45',10,0),('1','153',246916,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-18 21:57:05','581','2021-12-18 22:05:37',10,0),('1','153',247156,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-19 20:19:38','581','2021-12-19 20:38:13',10,0),('1','153',247384,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-20 21:25:11','581','2021-12-20 21:38:17',10,0),('1','153',247650,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-21 21:22:49','581','2021-12-21 21:26:58',10,0),('1','153',247895,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-22 21:56:13','581','2021-12-22 21:58:03',10,0),('1','153',248138,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-23 21:06:47','581','2021-12-23 21:11:02',10,0),('1','153',248405,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-24 08:23:51','581','2021-12-24 08:24:28',10,0),('1','153',248481,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-24 09:09:30','581','2021-12-24 09:11:49',10,0),('1','153',248487,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-24 21:02:47','581','2021-12-24 21:03:44',10,0),('1','153',248623,'DAILY SHFT','2021-12-25','2021-12-25 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-25 22:53:35','581','2021-12-25 22:55:57',10,0),('1','153',248874,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-26 22:40:31','581','2021-12-26 23:16:49',10,0),('1','153',249089,'DAILY SHFT','2021-12-27','2021-12-27 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-27 20:57:31','581','2021-12-27 20:59:50',10,0),('1','153',249326,'DAILY SHFT','2021-12-28','2021-12-28 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-28 20:43:44','581','2021-12-28 20:46:54',10,0),('1','153',249564,'DAILY SHFT','2021-12-29','2021-12-29 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-29 21:39:15','581','2021-12-29 21:47:49',10,0),('1','153',249827,'DAILY SHFT','2021-12-30','2021-12-30 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-30 22:35:50','581','2021-12-30 22:37:03',10,0),('1','153',250076,'DAILY SHFT','2021-12-31','2021-12-31 00:00:00',NULL,'581',0.00,0.00,'581','2021-12-31 19:54:58','581','2021-12-31 19:57:02',10,0),('1','153',250316,'DAILY SHFT','2022-01-01','2022-01-01 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-01 10:10:50','581','2022-01-01 10:11:59',10,0),('1','153',250413,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-01 10:16:55','581','2022-01-01 10:17:40',10,0),('1','153',250424,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-01 20:49:31','581','2022-01-01 20:54:16',10,0),('1','153',250554,'DAILY SHFT','2022-01-02','2022-01-02 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-02 20:48:08','581','2022-01-02 20:54:43',10,0),('1','153',250784,'DAILY SHFT','2022-01-03','2022-01-03 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-03 21:35:33','581','2022-01-03 21:37:09',10,0),('1','153',251001,'DAILY SHFT','2022-01-04','2022-01-04 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-04 21:20:56','581','2022-01-04 21:22:47',10,0),('1','153',251253,'DAILY SHFT','2022-01-05','2022-01-05 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-05 23:17:04','581','2022-01-05 23:19:12',10,0),('1','153',251505,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-06 22:48:54','581','2022-01-06 22:50:36',10,0),('1','153',251746,'DAILY SHFT','2022-01-07','2022-01-07 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-07 22:40:24','581','2022-01-07 22:42:22',10,0),('1','153',251975,'DAILY SHFT','2022-01-08','2022-01-08 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-08 13:08:13','581','2022-01-08 13:09:02',10,0),('1','153',252107,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-09 00:29:02','581','2022-01-09 00:30:14',10,0),('1','153',252220,'DAILY SHFT','2022-01-09','2022-01-09 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-09 23:56:41','581','2022-01-09 23:58:06',10,0),('1','153',252485,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-10 22:34:55','581','2022-01-10 22:36:20',10,0),('1','153',252693,'DAILY SHFT','2022-01-11','2022-01-11 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-11 23:10:03','581','2022-01-11 23:12:11',10,0),('1','153',252953,'DAILY SHFT','2022-01-12','2022-01-12 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-12 22:33:43','581','2022-01-12 22:35:22',10,0),('1','153',253196,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-14 09:18:28','581','2022-01-14 09:25:28',10,0),('1','153',253534,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-14 23:15:28','581','2022-01-14 23:16:50',10,0),('1','153',253707,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-15 23:32:29','581','2022-01-15 23:33:43',10,0),('1','153',253934,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-15 23:40:25','581','2022-01-15 23:41:23',10,0),('1','153',253949,'DAILY SHFT','2022-01-16','2022-01-16 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-16 22:08:52','581','2022-01-16 22:10:19',10,0),('1','153',254202,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-17 23:20:06','581','2022-01-17 23:22:43',10,0),('1','153',254442,'DAILY SHFT','2022-01-18','2022-01-18 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-18 23:34:48','581','2022-01-18 23:37:34',10,0),('1','153',254679,'DAILY SHFT','2022-01-19','2022-01-19 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-20 06:38:40','581','2022-01-20 06:40:48',10,0),('1','153',254938,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-20 23:06:46','581','2022-01-20 23:09:24',10,0),('1','153',255180,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-22 12:52:55','581','2022-01-22 12:58:53',10,0),('1','153',255575,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-22 21:08:23','581','2022-01-22 21:11:03',10,0),('1','153',255697,'DAILY SHFT','2022-01-23','2022-01-23 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-23 22:16:23','581','2022-01-23 22:25:20',10,0),('1','153',255944,'DAILY SHFT','2022-01-24','2022-01-24 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-24 13:37:43','581','2022-01-24 13:39:55',10,0),('1','153',256080,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-24 13:45:52','581','2022-01-24 13:47:55',10,0),('1','153',256083,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-24 21:56:16','581','2022-01-24 21:57:29',10,0),('1','153',256197,'DAILY SHFT','2022-01-25','2022-01-25 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-26 12:53:10','581','2022-01-26 12:59:50',10,0),('1','153',256591,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-26 23:01:49','581','2022-01-26 23:04:05',10,0),('1','153',256704,'DAILY SHFT','2022-01-27','2022-01-27 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-28 08:36:54','581','2022-01-28 08:40:32',10,0),('1','153',257007,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-28 22:50:22','581','2022-01-28 22:52:25',10,0),('1','153',257217,'DAILY SHFT','2022-01-29','2022-01-29 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-29 23:13:24','581','2022-01-29 23:14:49',10,0),('1','153',257475,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-31 09:31:15','581','2022-01-31 09:33:07',10,0),('1','153',257476,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'581',0.00,0.00,'581','2022-01-31 22:41:07','581','2022-01-31 22:41:50',10,0),('1','153',257477,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-01 22:08:05','581','2022-02-01 22:08:45',10,0),('1','153',257478,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-02 18:08:03','581','2022-02-02 18:23:45',10,0),('1','153',257479,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-02 23:18:40','581','2022-02-02 23:19:07',10,0),('1','153',257480,'DAILY SHFT','2022-02-03','2022-02-03 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-03 23:46:35','581','2022-02-03 23:46:59',10,0),('1','153',257481,'DAILY SHFT','2022-02-04','2022-02-04 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-04 23:30:21','581','2022-02-04 23:30:49',10,0),('1','153',257482,'DAILY SHFT','2022-02-05','2022-02-05 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-05 22:57:25','581','2022-02-05 22:57:47',10,0),('1','153',257483,'DAILY SHFT','2022-02-06','2022-02-06 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-06 21:37:39','581','2022-02-06 21:38:08',10,0),('1','153',257484,'DAILY SHFT','2022-02-07','2022-02-07 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-07 22:29:16','581','2022-02-07 22:29:46',10,0),('1','153',257485,'DAILY SHFT','2022-02-08','2022-02-08 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-08 21:34:59','581','2022-02-08 21:35:24',10,0),('1','153',257486,'DAILY SHFT','2022-02-09','2022-02-09 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-09 23:21:28','581','2022-02-09 23:21:48',10,0),('1','153',257487,'DAILY SHFT','2022-02-10','2022-02-10 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-10 22:29:05','581','2022-02-10 22:29:41',10,0),('1','153',257488,'DAILY SHFT','2022-02-11','2022-02-11 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-11 12:14:45','581','2022-02-11 12:15:24',10,0),('1','153',257489,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-11 12:23:09','581','2022-02-11 12:23:49',10,0),('1','153',257490,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-12 06:31:06','581','2022-02-12 06:31:29',10,0),('1','153',257491,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-12 23:49:34','581','2022-02-12 23:50:06',10,0),('1','153',257492,'DAILY SHFT','2022-02-13','2022-02-13 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-13 23:10:33','581','2022-02-13 23:10:57',10,0),('1','153',257493,'DAILY SHFT','2022-02-14','2022-02-14 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-14 22:29:13','581','2022-02-14 22:29:47',10,0),('1','153',257494,'DAILY SHFT','2022-02-15','2022-02-15 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-15 22:29:58','581','2022-02-15 22:30:26',10,0),('1','153',257495,'DAILY SHFT','2022-02-16','2022-02-16 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-16 22:21:02','581','2022-02-16 22:23:40',10,0),('1','153',257496,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-17 22:08:23','581','2022-02-17 22:09:01',10,0),('1','153',257497,'DAILY SHFT','2022-02-18','2022-02-18 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-18 20:30:40','581','2022-02-18 20:31:24',10,0),('1','153',257498,'DAILY SHFT','2022-02-19','2022-02-19 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-19 21:24:58','581','2022-02-19 21:29:31',10,0),('1','153',257499,'DAILY SHFT','2022-02-20','2022-02-20 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-20 21:50:51','581','2022-02-20 21:51:19',10,0),('1','153',257500,'DAILY SHFT','2022-02-21','2022-02-21 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-21 22:14:36','581','2022-02-21 22:15:13',10,0),('1','153',257501,'DAILY SHFT','2022-02-22','2022-02-22 00:00:00',NULL,'581',0.00,0.00,'581','2022-02-22 22:43:28','581','2022-02-22 22:43:57',10,0),('1','153',257502,'DAILY SHFT','2022-02-23','2022-02-23 01:07:13','2022-02-24 01:07:13','581',0.00,0.00,'581','2022-02-23 12:31:51','581','2022-02-23 12:32:17',10,0),('1','153',257503,'DAILY SHIFT','2022-02-23','2022-02-23 13:01:11','2022-02-24 13:01:11','581',0.00,0.00,'581','2022-02-23 13:04:57','581','2022-02-23 13:05:22',10,0),('1','153',257504,'DAILY SHIFT','2022-02-23','2022-02-23 13:05:46','2022-02-24 13:05:46','581',0.00,0.00,'581','2022-02-23 23:56:35','581','2022-02-23 23:57:04',10,0),('1','153',257505,'DAILY SHFT','2022-02-24','2022-02-24 01:37:51','2022-02-25 01:37:51','581',0.00,0.00,'581','2022-02-24 21:40:26','581','2022-02-24 21:40:56',10,0),('1','153',257506,'DAILY SHFT','2022-02-25','2022-02-25 01:21:17','2022-02-26 01:21:17','581',0.00,0.00,'581','2022-02-25 23:01:26','581','2022-02-25 23:02:34',10,0),('1','153',257507,'DAILY SHFT','2022-02-26','2022-02-26 04:11:29','2022-02-27 04:11:29','581',0.00,0.00,'581','2022-02-26 22:52:05','581','2022-02-26 22:52:43',10,0),('1','153',257508,'DAILY SHFT','2022-02-27','2022-02-27 01:33:07','2022-02-28 01:33:07','581',0.00,0.00,'581','2022-02-28 06:54:38','581','2022-02-28 07:11:40',10,0),('1','153',257509,'DAILY SHIFT','2022-02-28','2022-02-28 07:12:17','2022-03-01 07:12:17','581',0.00,0.00,'581','2022-02-28 21:22:54','581','2022-02-28 21:23:16',10,0),('1','153',257510,'DAILY SHFT','2022-03-01','2022-03-01 01:02:44','2022-03-02 01:02:44','581',0.00,0.00,'581','2022-03-01 22:39:21','581','2022-03-01 22:39:48',10,0),('1','153',257511,'DAILY SHFT','2022-03-02','2022-03-02 04:46:39','2022-03-03 04:46:39','581',0.00,0.00,'581','2022-03-02 22:36:25','581','2022-03-02 22:36:56',10,0),('1','153',257512,'DAILY SHIFT','2022-03-03','2022-03-03 07:32:28','2022-03-04 07:32:28','581',0.00,0.00,'581','2022-03-03 22:53:14','581','2022-03-03 22:54:31',10,0),('1','153',257513,'DAILY SHIFT','2022-03-04','2022-03-04 06:25:55','2022-03-05 06:25:55','581',0.00,0.00,'581','2022-03-04 22:05:39','581','2022-03-04 22:06:15',10,0),('1','153',257514,'DAILY SHFT','2022-03-05','2022-03-05 06:40:49','2022-03-06 06:40:49','581',0.00,0.00,'581','2022-03-05 22:29:35','581','2022-03-05 22:30:02',10,0),('1','153',257515,'DAILY SHIFT','2022-03-06','2022-03-06 07:25:38','2022-03-07 07:25:38','581',0.00,0.00,'581','2022-03-06 22:51:15','581','2022-03-06 22:51:55',10,0),('1','153',257516,'DAILY SHIFT','2022-03-07','2022-03-07 12:01:05','2022-03-08 12:01:05','581',0.00,0.00,'581','2022-03-07 12:04:50','581','2022-03-07 12:05:25',10,0),('1','153',257517,'DAILY SHIFT','2022-03-07','2022-03-07 12:05:47','2022-03-08 12:05:47','581',0.00,0.00,'581','2022-03-07 12:10:10','581','2022-03-07 12:10:39',10,0),('1','153',257518,'DAILY SHIFT','2022-03-07','2022-03-07 12:17:05','2022-03-08 12:17:05','581',0.00,0.00,'581','2022-03-07 22:38:23','581','2022-03-07 22:39:01',10,0),('1','153',257519,'DAILY SHIFT','2022-03-08','2022-03-08 07:02:44','2022-03-09 07:02:44','581',0.00,0.00,'581','2022-03-08 21:21:21','581','2022-03-08 21:24:16',10,0),('1','153',257520,'DAILY SHFT','2022-03-09','2022-03-09 06:17:55','2022-03-10 06:17:55','581',0.00,0.00,'581','2022-03-09 22:10:50','581','2022-03-09 22:12:05',10,0),('1','153',257521,'DAILY SHIFT','2022-03-10','2022-03-10 06:54:12','2022-03-11 06:54:12','581',0.00,0.00,'581','2022-03-10 21:25:49','581','2022-03-10 21:26:27',10,0),('1','153',257522,'DAILY SHIFT','2022-03-11','2022-03-11 06:12:23','2022-03-12 06:12:23','581',0.00,0.00,'581','2022-03-11 22:56:43','581','2022-03-11 22:57:09',10,0),('1','153',257523,'DAILY SHIFT','2022-03-12','2022-03-12 07:12:09','2022-03-13 07:12:09','581',0.00,0.00,'581','2022-03-12 21:36:34','581','2022-03-12 21:37:25',10,0),('1','153',257524,'DAILY SHIFT','2022-03-13','2022-03-13 06:18:50','2022-03-14 06:18:50','581',0.00,0.00,'581','2022-03-13 21:33:20','581','2022-03-13 21:33:43',10,0),('1','153',257525,'DAILY SHIFT','2022-03-14','2022-03-14 07:20:44','2022-03-15 07:20:44','581',0.00,0.00,'581','2022-03-14 21:55:31','581','2022-03-14 21:56:19',10,0),('1','153',257526,'DAILY SHIFT','2022-03-15','2022-03-15 07:21:49','2022-03-16 07:21:49','581',0.00,0.00,'581','2022-03-15 22:13:36','581','2022-03-15 22:14:33',10,0),('1','153',257527,'DAILY SHIFT','2022-03-16','2022-03-16 08:28:17','2022-03-17 08:28:17','581',0.00,0.00,'581','2022-03-16 22:39:38','581','2022-03-16 22:40:19',10,0),('1','153',257528,'DAILY SHIFT','2022-03-17','2022-03-17 06:43:05','2022-03-18 06:43:05','581',0.00,0.00,'581','2022-03-17 23:38:13','581','2022-03-17 23:39:30',10,0),('1','153',257529,'DAILY SHIFT','2022-03-18','2022-03-18 07:09:34','2022-03-19 07:09:34','581',0.00,0.00,'581','2022-03-18 21:53:58','581','2022-03-18 21:54:26',10,0),('1','153',257530,'DAILY SHIFT','2022-03-19','2022-03-19 06:07:03','2022-03-20 06:07:03','581',0.00,0.00,'581','2022-03-19 21:35:04','581','2022-03-19 21:35:39',10,0),('1','153',257531,'DAILY SHIFT','2022-03-20','2022-03-20 06:10:43','2022-03-21 06:10:43','581',0.00,0.00,'581','2022-03-20 12:43:58','581','2022-03-20 12:44:30',10,0),('1','153',257532,'DAILY SHIFT','2022-03-20','2022-03-20 12:47:17','2022-03-21 12:47:17','581',0.00,0.00,'581','2022-03-20 12:50:18','581','2022-03-20 12:50:36',10,0),('1','153',257533,'DAILY SHIFT','2022-03-20','2022-03-20 12:50:54','2022-03-21 12:50:54','581',0.00,0.00,'581','2022-03-20 20:07:20','581','2022-03-20 20:07:51',10,0),('1','153',257534,'DAILY SHIFT','2022-03-21','2022-03-21 06:50:19','2022-03-22 06:50:19','581',0.00,0.00,'581','2022-03-21 21:49:08','581','2022-03-21 21:50:09',10,0),('1','153',257535,'DAILY SHIFT','2022-03-22','2022-03-22 06:09:08','2022-03-23 06:09:08','581',0.00,0.00,'581','2022-03-22 23:35:38','581','2022-03-22 23:36:08',10,0),('1','153',257536,'DAILY SHIFT','2022-03-23','2022-03-23 07:21:23','2022-03-24 07:21:23','581',0.00,0.00,'581','2022-03-24 07:54:09','581','2022-03-24 07:54:30',10,0),('1','153',257537,'DAILY SHIFT','2022-03-24','2022-03-24 07:54:51','2022-03-25 07:54:51','581',0.00,0.00,'581','2022-03-24 23:06:04','581','2022-03-24 23:07:08',10,0),('1','153',257538,'DAILY Swift','2022-03-25','2022-03-25 06:06:52','2022-03-26 06:06:52','581',0.00,0.00,'581','2022-03-26 06:11:03','581','2022-03-26 06:11:30',10,0),('1','153',257539,'DAILY SHIFT','2022-03-26','2022-03-26 06:12:10','2022-03-27 06:12:10','581',0.00,0.00,'581','2022-03-26 21:06:19','581','2022-03-26 21:06:51',10,0),('1','153',257540,'DAILY SHIFT','2022-03-27','2022-03-27 06:07:16','2022-03-28 06:07:16','581',0.00,0.00,'581','2022-03-27 21:55:07','581','2022-03-27 21:55:36',10,0),('1','153',257541,'DAILY SHIFT','2022-03-28','2022-03-28 07:45:33','2022-03-29 07:45:33','581',0.00,0.00,'581','2022-03-29 06:49:06','581','2022-03-29 06:50:00',10,0),('1','153',257542,'DAILY SHIFT','2022-03-29','2022-03-29 06:51:32','2022-03-30 06:51:32','581',0.00,0.00,'581','2022-03-30 06:52:39','581','2022-03-30 06:53:02',10,0),('1','153',257543,'DAILY SHIFT','2022-03-30','2022-03-30 06:53:47','2022-03-31 06:53:47','581',0.00,0.00,'581','2022-03-31 05:51:37','581','2022-03-31 05:52:09',10,0),('1','153',257544,'DAILY SHIFT','2022-03-31','2022-03-31 05:52:42','2022-04-01 05:52:42','581',0.00,0.00,'581','2022-04-01 06:56:43','581','2022-04-01 06:57:12',10,0),('1','153',257545,'DAILY SHIFT','2022-04-01','2022-04-01 06:57:36','2022-04-02 06:57:36','581',0.00,0.00,'581','2022-04-01 07:11:13','581','2022-04-01 07:11:31',10,0),('1','153',257546,'DAILY SHIFT','2022-04-01','2022-04-01 07:12:03','2022-04-02 07:12:03','581',0.00,0.00,'581','2022-04-02 05:57:59','581','2022-04-02 05:58:55',10,0),('1','153',257547,'DAILY SHIFT','2022-04-02','2022-04-02 05:59:25','2022-04-03 05:59:25','581',0.00,0.00,'581','2022-04-03 07:29:48','581','2022-04-03 07:30:12',10,0),('1','153',257548,'DAILY SHIFT','2022-04-03','2022-04-03 07:30:54','2022-04-04 07:30:54','581',0.00,0.00,'581','2022-04-04 05:56:16','581','2022-04-04 05:56:45',10,0),('1','153',257549,'DAILY SHIFT','2022-04-04','2022-04-04 05:57:42','2022-04-05 05:57:42','581',0.00,0.00,'581','2022-04-05 05:46:54','581','2022-04-05 05:48:32',10,0),('1','153',257550,'DAILY SHIFT','2022-04-05','2022-04-05 05:49:36','2022-04-06 05:49:36','581',0.00,0.00,'581','2022-04-05 17:28:41','581','2022-04-05 17:29:15',10,0),('1','153',257551,'DAILY SHFT','2022-04-05','2022-04-05 17:29:57','2022-04-06 17:29:57','581',0.00,0.00,'581','2022-04-05 21:55:18','581','2022-04-05 21:55:38',10,0),('1','153',257552,'DAILY SHIFT','2022-04-06','2022-04-06 05:51:37','2022-04-07 05:51:37','581',0.00,0.00,'581','2022-04-06 21:54:48','581','2022-04-06 21:55:14',10,0),('1','153',257553,'DAILY SHIFT','2022-04-07','2022-04-07 07:17:55','2022-04-08 07:17:55','581',0.00,0.00,'581','2022-04-07 14:43:17','581','2022-04-07 14:44:11',10,0),('1','153',257554,'DAILY SHIFT','2022-04-07','2022-04-07 14:53:35','2022-04-08 14:53:35','581',0.00,0.00,'581','2022-04-07 22:23:08','581','2022-04-07 22:23:35',10,0),('1','153',257555,'DAILY SHIFT','2022-04-08','2022-04-08 07:07:54','2022-04-09 07:07:54','581',0.00,0.00,'581','2022-04-08 21:52:24','581','2022-04-08 21:52:49',10,0),('1','153',257556,'DAILY SHIFT','2022-04-09','2022-04-09 06:48:38','2022-04-10 06:48:38','581',0.00,0.00,'581','2022-04-09 14:47:52','581','2022-04-09 14:48:15',10,0),('1','153',257557,'DAILY SHIFT','2022-04-09','2022-04-09 14:51:19','2022-04-10 14:51:19','581',0.00,0.00,'581','2022-04-09 21:23:03','581','2022-04-09 21:23:24',10,0),('1','153',257558,'DAILY SHIFT','2022-04-10','2022-04-10 06:43:36','2022-04-11 06:43:36','581',0.00,0.00,'581','2022-04-10 22:32:22','581','2022-04-10 22:32:48',10,0),('1','153',257559,'DAILY SHIFT','2022-04-11','2022-04-11 07:00:54','2022-04-12 07:00:54','581',0.00,0.00,'581','2022-04-11 14:53:27','581','2022-04-11 14:53:46',10,0),('1','153',257560,'DAILY SHIFT','2022-04-11','2022-04-11 15:05:58','2022-04-12 15:05:58','581',0.00,0.00,'581','2022-04-11 22:37:47','581','2022-04-11 22:39:22',10,0),('1','153',257561,'DAILY SHIFT','2022-04-12','2022-04-12 07:22:09','2022-04-13 07:22:09','581',0.00,0.00,'581','2022-04-12 22:22:59','581','2022-04-12 22:23:23',10,0),('1','153',257562,'DAILY SHIFT','2022-04-13','2022-04-13 07:00:28','2022-04-14 07:00:28','581',0.00,0.00,'581','2022-04-13 22:50:05','581','2022-04-13 22:50:28',10,0),('1','153',257563,'DAILY SHIFT','2022-04-14','2022-04-14 06:54:09','2022-04-15 06:54:09','581',0.00,0.00,'581','2022-04-14 11:02:25','581','2022-04-14 11:02:52',10,0),('1','153',257564,'DAILY SHIFT','2022-04-14','2022-04-14 11:03:22','2022-04-15 11:03:22','581',0.00,0.00,'581','2022-04-14 20:29:24','581','2022-04-14 20:29:59',10,0),('1','153',257565,'DAILY SHIFT','2022-04-15','2022-04-15 06:07:40','2022-04-16 06:07:40','581',0.00,0.00,'581','2022-04-15 21:00:23','581','2022-04-15 21:00:48',10,0),('1','153',257566,'DAILY SHIFT','2022-04-16','2022-04-16 06:45:20','2022-04-17 06:45:20','581',0.00,0.00,'581','2022-04-16 20:44:04','581','2022-04-16 20:44:49',10,0),('1','153',257567,'DAILY SHIFT','2022-04-17','2022-04-17 06:43:46','2022-04-18 06:43:46','581',0.00,0.00,'581','2022-04-17 22:09:45','581','2022-04-17 22:10:14',10,0),('1','153',257568,'DAILY SHIFT','2022-04-18','2022-04-18 05:56:16','2022-04-19 05:56:16','581',0.00,0.00,'581','2022-04-18 13:47:16','581','2022-04-18 13:47:41',10,0),('1','153',257569,'DAILY SHIFT','2022-04-18','2022-04-18 15:16:37','2022-04-19 15:16:37','581',0.00,0.00,'581','2022-04-18 20:52:42','581','2022-04-18 20:53:02',10,0),('1','153',257570,'DAILY SHIFT','2022-04-19','2022-04-19 06:33:44','2022-04-20 06:33:44','581',0.00,0.00,'581','2022-04-19 21:23:50','581','2022-04-19 21:24:21',10,0),('1','153',257571,'DAILY SHIFT','2022-04-20','2022-04-20 06:53:55','2022-04-21 06:53:55','581',0.00,0.00,'581','2022-04-20 21:20:56','581','2022-04-20 21:21:25',10,0),('1','153',257572,'DAILY SHIFT','2022-04-21','2022-04-21 06:41:30','2022-04-22 06:41:30','581',0.00,0.00,'581','2022-04-21 21:02:52','581','2022-04-21 21:03:27',10,0),('1','153',257573,'DAILY SHIFT','2022-04-22','2022-04-22 06:54:13','2022-04-23 06:54:13','581',0.00,0.00,'581','2022-04-22 17:13:56','581','2022-04-22 17:14:18',10,0),('1','153',257574,'DAILY SHIFT','2022-04-22','2022-04-22 17:15:06','2022-04-23 17:15:06','581',0.00,0.00,'581','2022-04-22 21:08:27','581','2022-04-22 21:08:49',10,0),('1','153',257575,'DAILY SHIFT','2022-04-23','2022-04-23 05:43:04','2022-04-24 05:43:04','581',0.00,0.00,'581','2022-04-23 21:16:11','581','2022-04-23 21:16:29',10,0),('1','153',257576,'DAILY SHIFT','2022-04-24','2022-04-24 06:56:44','2022-04-25 06:56:44','581',0.00,0.00,'581','2022-04-24 21:41:21','581','2022-04-24 21:41:43',10,0),('1','153',257577,'DAILY SHIFT','2022-04-25','2022-04-25 05:58:19','2022-04-26 05:58:19','581',0.00,0.00,'581','2022-04-25 19:28:09','581','2022-04-25 19:28:30',10,0),('1','153',257578,'DAILY SHIFT','2022-04-26','2022-04-26 07:16:19','2022-04-27 07:16:19','581',0.00,0.00,'581','2022-04-26 21:31:46','581','2022-04-26 21:32:06',10,0),('1','153',257579,'DAILY SHIFT','2022-04-27','2022-04-27 06:44:48','2022-04-28 06:44:48','581',0.00,0.00,'581','2022-04-27 10:36:20','581','2022-04-27 10:36:54',10,0),('1','153',257580,'DAILY SHIFT','2022-04-27','2022-04-27 11:33:03','2022-04-28 11:33:03','581',0.00,0.00,'581','2022-04-27 21:36:59','581','2022-04-27 21:37:26',10,0),('1','153',257581,'DAILY SHFT','2022-04-28','2022-04-28 06:21:56','2022-04-29 06:21:56','581',0.00,0.00,'581','2022-04-28 21:28:52','581','2022-04-28 21:29:25',10,0),('1','153',257582,'DAILY SHIFT','2022-04-29','2022-04-29 05:49:30','2022-04-30 05:49:30','581',0.00,0.00,'581','2022-04-29 23:21:59','581','2022-04-29 23:22:23',10,0),('1','153',257583,'DAILY SHIFT','2022-04-30','2022-04-30 07:33:09','2022-05-01 07:33:09','581',0.00,0.00,'581','2022-04-30 16:20:48','581','2022-04-30 16:21:08',10,0),('1','153',257584,'DAILY SHIFT','2022-04-30','2022-04-30 16:21:31','2022-05-01 16:21:31','581',0.00,0.00,'581','2022-04-30 21:18:13','581','2022-04-30 21:18:35',10,0),('1','153',257585,'DAILY SHIFT','2022-05-01','2022-05-01 07:43:03','2022-05-02 07:43:03','581',0.00,0.00,'581','2022-05-01 22:02:08','581','2022-05-01 22:02:30',10,0),('1','153',257586,'DAILY SHIFT','2022-05-02','2022-05-02 09:18:59','2022-05-03 09:18:59','581',0.00,0.00,'581','2022-05-02 20:26:03','581','2022-05-02 20:26:24',10,0),('1','153',257587,'DAILY SHIFT','2022-05-03','2022-05-03 07:11:18','2022-05-04 07:11:18','581',0.00,0.00,'581','2022-05-03 22:20:05','581','2022-05-03 22:20:32',10,0),('1','153',257588,'DAILY SHFT','2022-05-04','2022-05-04 06:38:56','2022-05-05 06:38:56','581',0.00,0.00,'581','2022-05-04 14:12:51','581','2022-05-04 14:13:13',10,0),('1','153',257589,'DAILY SHIFT','2022-05-04','2022-05-04 14:13:35','2022-05-05 14:13:35','581',0.00,0.00,'581','2022-05-04 19:57:47','581','2022-05-04 19:58:02',10,0),('1','153',257590,'DAILY SHIFT','2022-05-05','2022-05-05 07:09:22','2022-05-08 07:09:22','581',0.00,0.00,'581','2022-05-05 21:37:44','581','2022-05-05 21:38:48',10,0),('1','153',257591,'DAILY SHFT','2022-05-06','2022-05-06 06:49:26','2022-05-07 06:49:26','581',0.00,0.00,'581','2022-05-06 21:14:59','581','2022-05-06 21:15:23',10,0),('1','153',257592,'DAILY SHIFT','2022-05-07','2022-05-07 07:14:29','2022-05-08 07:14:29','581',0.00,0.00,'581','2022-05-07 21:18:52','581','2022-05-07 21:19:12',10,0),('1','153',257593,'DAILY SHIFT','2022-05-08','2022-05-08 05:27:25','2022-05-09 05:27:25','581',0.00,0.00,'581','2022-05-08 11:02:18','581','2022-05-08 11:02:39',10,0),('1','153',257594,'DAILY SHIFT','2022-05-08','2022-05-08 11:05:12','2022-05-09 11:05:12','581',0.00,0.00,'581','2022-05-08 21:41:25','581','2022-05-08 21:42:00',10,0),('1','153',257595,'DAILY SHIFT','2022-05-09','2022-05-09 06:21:25','2022-05-10 06:21:25','581',0.00,0.00,'581','2022-05-09 21:31:31','581','2022-05-09 21:31:51',10,0),('1','153',257596,'DAILY SHIFT','2022-05-10','2022-05-10 06:14:41','2022-05-11 06:14:41','581',0.00,0.00,'581','2022-05-10 20:09:03','581','2022-05-10 20:09:29',10,0),('1','153',257597,'DAILY SHIFT','2022-05-11','2022-05-11 06:02:10','2022-05-12 06:02:10','581',0.00,0.00,'581','2022-05-11 12:59:07','581','2022-05-11 12:59:32',10,0),('1','153',257598,'DAILY SHIFT','2022-05-11','2022-05-11 13:10:15','2022-05-12 13:10:15','581',0.00,0.00,'581','2022-05-12 08:39:19','581','2022-05-12 08:39:47',10,0),('1','153',257599,'DAILY SHIFT','2022-05-12','2022-05-12 08:41:06','2022-05-13 08:41:06','581',0.00,0.00,'581','2022-05-12 21:08:53','581','2022-05-12 21:09:16',10,0),('1','153',257600,'DAILY SHIFT','2022-05-13','2022-05-13 07:00:46','2022-05-14 07:00:46','581',0.00,0.00,'581','2022-05-13 21:36:58','581','2022-05-13 21:37:48',10,0),('1','153',257601,'DAILY SHIFT','2022-05-14','2022-05-14 06:56:29','2022-05-15 06:56:29','581',0.00,0.00,'581','2022-05-14 21:49:21','581','2022-05-14 21:50:18',10,0),('1','153',257602,'DAILY SHIFT','2022-05-15','2022-05-15 07:01:29','2022-05-16 07:01:29','581',0.00,0.00,'581','2022-05-15 11:06:14','581','2022-05-15 11:24:39',10,0),('1','153',257603,'DAILY SHIFT','2022-05-15','2022-05-15 11:28:13','2022-05-16 11:28:13','581',0.00,0.00,'581','2022-05-15 21:35:21','581','2022-05-15 21:35:40',10,0),('1','153',257604,'DAILY SHIFT','2022-05-16','2022-05-16 07:04:07','2022-05-17 07:04:07','581',0.00,0.00,'581','2022-05-16 21:57:05','581','2022-05-16 21:57:41',10,0),('1','153',257605,'DAILY SHIFT','2022-05-17','2022-05-17 06:58:59','2022-05-18 06:58:59','581',0.00,0.00,'581','2022-05-17 21:25:26','581','2022-05-17 21:26:01',10,0),('1','153',257606,'DAILY SHFT','2022-05-18','2022-05-18 06:36:24','2022-05-19 06:36:24','581',0.00,0.00,'581','2022-05-18 21:44:26','581','2022-05-18 21:44:55',10,0),('1','153',257607,'DAILY SHIFT','2022-05-19','2022-05-19 06:12:58','2022-05-20 06:12:58','581',0.00,0.00,'581','2022-05-19 12:03:34','581','2022-05-19 12:03:57',10,0),('1','153',257608,'DAILY SHIFT','2022-05-19','2022-05-19 12:58:19','2022-05-20 12:58:19','581',0.00,0.00,'581','2022-05-19 21:39:52','581','2022-05-19 21:40:54',10,0),('1','153',257609,'DAILY SHIFT','2022-05-20','2022-05-20 06:30:22','2022-05-21 06:30:22','581',0.00,0.00,'581','2022-05-20 20:54:04','581','2022-05-20 20:54:54',10,0),('1','153',257610,'DAILY SHIFT','2022-05-21','2022-05-21 06:40:48','2022-05-22 06:40:48','581',0.00,0.00,'581','2022-05-21 10:24:50','581','2022-05-21 10:25:07',10,0),('1','153',257611,'DAILY SHIFT','2022-05-21','2022-05-21 10:25:34','2022-05-22 10:25:34','581',0.00,0.00,'581','2022-05-21 21:28:30','581','2022-05-21 21:29:16',10,0),('1','153',257612,'DAILY SHFT','2022-05-22','2022-05-22 06:52:40','2022-05-23 06:52:40','581',0.00,0.00,'581','2022-05-22 21:58:25','581','2022-05-22 22:00:08',10,0),('1','153',257613,'DAILY SHIFT','2022-05-23','2022-05-23 05:39:47','2022-05-24 05:39:47','581',0.00,0.00,'581','2022-05-23 13:30:46','581','2022-05-23 13:31:10',10,0),('1','153',257614,'DAILY SHIFT','2022-05-23','2022-05-23 13:37:48','2022-05-24 13:37:48','581',0.00,0.00,'581','2022-05-23 21:46:24','581','2022-05-23 21:48:02',10,0),('1','153',257615,'DAILY SHFT','2022-05-24','2022-05-24 06:59:30','2022-05-25 06:59:30','581',0.00,0.00,'581','2022-05-24 21:53:24','581','2022-05-24 21:53:53',10,0),('1','153',257616,'DAILY SHIFT','2022-05-25','2022-05-25 07:15:40','2022-05-26 07:15:40','581',0.00,0.00,'581','2022-05-25 19:37:06','581','2022-05-25 19:37:27',10,0),('1','153',257617,'DAILY SHIFT','2022-05-26','2022-05-26 06:48:58','2022-05-27 06:48:58','581',0.00,0.00,'581','2022-05-26 19:43:23','581','2022-05-26 19:43:45',10,0),('1','153',257618,'DAILY SHIFT','2022-05-27','2022-05-27 07:05:41','2022-05-28 07:05:41','581',0.00,0.00,'581','2022-05-27 19:59:30','581','2022-05-27 19:59:49',10,0),('1','153',257619,'DAILY SHIFT','2022-05-28','2022-05-28 07:37:51','2022-05-29 07:37:51','581',0.00,0.00,'581','2022-05-28 19:35:41','581','2022-05-28 20:25:05',10,0),('1','153',257620,'DAILY SHIFT','2022-05-29','2022-05-29 07:04:57','2022-05-30 07:04:57','581',0.00,0.00,'581','2022-05-29 19:36:03','581','2022-05-29 19:36:27',10,0),('1','153',257621,'DAILY SHFT','2022-05-30','2022-05-30 06:54:27','2022-05-31 06:54:27','581',0.00,0.00,'581','2022-05-30 19:37:46','581','2022-05-30 19:38:11',10,0),('1','153',257622,'DAILY SHIFT','2022-05-31','2022-05-31 06:56:10','2022-06-01 06:56:10','581',0.00,0.00,'581','2022-05-31 11:28:11','581','2022-05-31 11:28:40',10,0),('1','153',257623,'DAILY SHIFT','2022-05-31','2022-05-31 12:00:14','2022-06-01 12:00:14','581',0.00,0.00,'581','2022-05-31 19:59:47','581','2022-05-31 20:00:16',10,0),('1','153',257624,'DAILY SHIFT','2022-06-01','2022-06-01 07:01:54','2022-06-02 07:01:54','581',0.00,0.00,'581','2022-06-01 21:49:00','581','2022-06-01 21:50:21',10,0),('1','153',257625,'DAILY SHIFT','2022-06-02','2022-06-02 06:52:33','2022-06-03 06:52:33','581',0.00,0.00,'581','2022-06-02 22:35:27','581','2022-06-02 22:35:51',10,0),('1','153',257626,'DAILY SHIFT','2022-06-03','2022-06-03 07:01:37','2022-06-04 07:01:37','581',0.00,0.00,'581','2022-06-03 22:55:03','581','2022-06-03 22:55:46',10,0),('1','153',257627,'DAILY SHIFT','2022-06-04','2022-06-04 07:02:28','2022-06-05 07:02:28','581',0.00,0.00,'581','2022-06-04 09:44:24','581','2022-06-04 09:44:45',10,0),('1','153',257628,'DAILY SHIFT','2022-06-04','2022-06-04 10:16:23','2022-06-05 10:16:23','581',0.00,0.00,'581','2022-06-04 21:38:42','581','2022-06-04 21:41:06',10,0),('1','153',257629,'DAILY SHIFT','2022-06-05','2022-06-05 07:03:03','2022-06-06 07:03:03','581',0.00,0.00,'581','2022-06-05 19:38:23','581','2022-06-05 19:38:54',10,0),('1','153',257630,'DAILY SHFT','2022-06-06','2022-06-06 06:46:28','2022-06-07 06:46:28','581',0.00,0.00,'581','2022-06-06 22:33:39','581','2022-06-06 22:34:27',10,0),('1','153',257631,'DAILY SHIFT','2022-06-07','2022-06-07 07:08:01','2022-06-08 07:08:01','581',0.00,0.00,'581','2022-06-07 16:12:35','581','2022-06-07 16:13:02',10,0),('1','153',257632,'DAILY SHIFT','2022-06-07','2022-06-07 16:16:24','2022-06-08 16:16:24','581',0.00,0.00,'581','2022-06-07 22:17:30','581','2022-06-07 22:17:54',10,0),('1','153',257633,'DAILY SHIFT','2022-06-08','2022-06-08 07:00:45','2022-06-09 07:00:45','581',0.00,0.00,'581','2022-06-08 21:10:45','581','2022-06-08 21:11:12',10,0),('1','153',257634,'DAILY SHFT','2022-06-09','2022-06-09 06:27:04','2022-06-10 06:27:04','581',0.00,0.00,'581','2022-06-09 21:59:45','581','2022-06-09 22:01:05',10,0),('1','153',257635,'DAILY SHIFT','2022-06-10','2022-06-10 06:56:53','2022-06-11 06:56:53','581',0.00,0.00,'581','2022-06-10 22:20:34','581','2022-06-10 22:21:24',10,0),('1','153',257636,'DAILY SHFT','2022-06-11','2022-06-11 06:40:16','2022-06-12 06:40:16','581',0.00,0.00,'581','2022-06-11 15:18:07','581','2022-06-11 15:18:27',10,0),('1','153',257637,'DAILY SHFT','2022-06-15','2022-06-15 07:41:56','2022-06-16 07:41:56','581',0.00,0.00,'581','2022-06-15 16:47:56','581','2022-06-15 16:48:42',10,0),('1','153',257638,'DAILY SHIFT','2022-06-15','2022-06-15 16:53:21','2022-06-16 16:53:21','581',0.00,0.00,'581','2022-06-15 19:35:31','581','2022-06-15 19:35:50',10,0),('1','153',257639,'DAILY SHIFT','2022-06-16','2022-06-16 07:10:43','2022-06-17 07:10:43','581',0.00,0.00,'581','2022-06-16 19:24:56','581','2022-06-16 19:25:15',10,0),('1','153',257640,'DAILY SHFT','2022-06-17','2022-06-17 06:50:36','2022-06-18 06:50:36','581',0.00,0.00,'581','2022-06-17 21:43:08','581','2022-06-17 21:48:57',10,0),('1','153',257641,'DAILY SHIFT','2022-06-18','2022-06-18 06:40:31','2022-06-19 06:40:31','581',0.00,0.00,'581','2022-06-18 19:23:07','581','2022-06-18 19:23:26',10,0),('1','153',257642,'DAILY SHIFT','2022-06-19','2022-06-19 05:58:45','2022-06-20 05:58:45','581',0.00,0.00,'581','2022-06-19 19:15:11','581','2022-06-19 19:15:35',10,0),('1','153',257643,'DAILY SHIFT','2022-06-20','2022-06-20 06:33:45','2022-06-21 06:33:45','581',0.00,0.00,'581','2022-06-20 19:30:03','581','2022-06-20 19:30:22',10,0),('1','153',257644,'DAILY SHFT','2022-06-21','2022-06-21 06:22:27','2022-06-22 06:22:27','581',0.00,0.00,'581','2022-06-21 19:26:02','581','2022-06-21 19:26:29',10,0),('1','153',257645,'DAILY SHIFT','2022-06-22','2022-06-22 07:02:48','2022-06-23 07:02:48','581',0.00,0.00,'581','2022-06-22 19:28:23','581','2022-06-22 19:28:46',10,0),('1','153',257646,'DAILY SHFT','2022-06-23','2022-06-23 06:14:15','2022-06-24 06:14:15','581',0.00,0.00,'581','2022-06-23 19:32:17','581','2022-06-23 19:33:33',10,0),('1','153',257647,'DAILY SHIFT','2022-06-24','2022-06-24 06:47:15','2022-06-25 06:47:15','581',0.00,0.00,'581','2022-06-24 14:07:15','581','2022-06-24 14:07:42',10,0),('1','153',257648,'DAILY SHIFT','2022-06-24','2022-06-24 14:53:58','2022-06-25 14:53:58','581',0.00,0.00,'581','2022-06-24 19:41:24','581','2022-06-24 19:41:46',10,0),('1','153',257649,'DAILY SHIFT','2022-06-25','2022-06-25 06:43:54','2022-06-26 06:43:54','581',0.00,0.00,'581','2022-06-25 22:56:51','581','2022-06-25 22:57:48',10,0),('1','153',257650,'DAILY SHIFT','2022-06-26','2022-06-26 06:33:49','2022-06-27 06:33:49','581',0.00,0.00,'581','2022-06-26 22:46:12','581','2022-06-26 22:47:01',10,0),('1','153',257651,'DAILY SHIFT','2022-06-27','2022-06-27 06:27:41','2022-06-28 06:27:41','581',0.00,0.00,'581','2022-06-27 19:45:55','581','2022-06-27 19:46:20',10,0),('1','153',257652,'DAILY SHIFT','2022-06-28','2022-06-28 07:52:08','2022-06-29 07:52:08','581',0.00,0.00,'581','2022-06-28 14:44:15','581','2022-06-28 14:45:04',10,0),('1','153',257653,'DAILY SHIFT','2022-06-28','2022-06-28 14:51:39','2022-06-29 14:51:39','581',0.00,0.00,'581','2022-06-28 19:38:23','581','2022-06-28 19:38:57',10,0),('1','153',257654,'DAILY SHIFT','2022-06-29','2022-06-29 06:47:57','2022-06-30 06:47:57','581',0.00,0.00,'581','2022-06-29 19:44:07','581','2022-06-29 19:44:41',10,0),('1','153',257655,'DAILY SHIFT','2022-06-30','2022-06-30 07:11:53','2022-07-01 07:11:53','581',0.00,0.00,'581','2022-06-30 19:19:28','581','2022-06-30 19:20:00',10,0),('1','153',257656,'DAILY SHFT','2022-07-01','2022-07-01 07:03:05','2022-07-02 07:03:05','581',0.00,0.00,'581','2022-07-01 19:27:08','581','2022-07-01 19:27:34',10,0),('1','153',257657,'DAILY SHIFT','2022-07-02','2022-07-02 06:34:38','2022-07-03 06:34:38','581',0.00,0.00,'581','2022-07-02 11:29:05','581','2022-07-02 11:29:33',10,0),('1','153',257658,'DAILY SHIFT','2022-07-02','2022-07-02 11:38:03','2022-07-03 11:38:03','581',0.00,0.00,'581','2022-07-02 21:47:55','581','2022-07-02 21:48:27',10,0),('1','153',257659,'DAILY SHIFT','2022-07-03','2022-07-03 07:15:04','2022-07-04 07:15:04','581',0.00,0.00,'581','2022-07-03 22:23:24','581','2022-07-03 22:23:48',10,0),('1','153',257660,'DAILY SHIFT','2022-07-04','2022-07-04 06:56:58','2022-07-05 06:56:58','581',0.00,0.00,'581','2022-07-04 21:50:52','581','2022-07-04 21:51:25',10,0),('1','153',257661,'DAILY SHFT','2022-07-05','2022-07-05 06:46:50','2022-07-06 06:46:50','581',0.00,0.00,'581','2022-07-05 18:44:23','581','2022-07-05 18:44:52',10,0),('1','153',257662,'DAILY SHIFT','2022-07-06','2022-07-06 06:51:58','2022-07-07 06:51:58','581',0.00,0.00,'581','2022-07-06 19:38:49','581','2022-07-06 19:39:20',10,0),('1','153',257663,'DAILY SHIFT','2022-07-07','2022-07-07 07:00:44','2022-07-08 07:00:44','581',0.00,0.00,'581','2022-07-07 22:35:09','581','2022-07-07 22:35:44',10,0),('1','153',257664,'DAILY SHIFT','2022-07-08','2022-07-08 06:27:27','2022-07-09 06:27:27','581',0.00,0.00,'581','2022-07-08 16:13:36','581','2022-07-08 16:14:54',10,0),('1','153',257665,'DAILY SHIFT','2022-07-08','2022-07-08 16:17:50','2022-07-09 16:17:50','581',0.00,0.00,'581','2022-07-08 20:58:55','581','2022-07-08 20:59:22',10,0),('1','153',257666,'DAILY SHIFT','2022-07-09','2022-07-09 06:48:20','2022-07-10 06:48:20','581',0.00,0.00,'581','2022-07-09 22:54:29','581','2022-07-09 22:55:30',10,0),('1','153',257667,'DAILY SHIFT','2022-07-10','2022-07-10 07:11:36','2022-07-11 07:11:36','581',0.00,0.00,'581','2022-07-10 21:58:20','581','2022-07-10 21:58:43',10,0),('1','153',257668,'DAILY SHIFT','2022-07-11','2022-07-11 06:56:51','2022-07-12 06:56:51','581',0.00,0.00,'581','2022-07-11 22:48:13','581','2022-07-11 22:48:39',10,0),('1','153',257669,'DAILY SHIFT','2022-07-12','2022-07-12 07:09:03','2022-07-13 07:09:03','581',0.00,0.00,'581','2022-07-12 23:25:22','581','2022-07-12 23:25:56',10,0),('1','153',257670,'DAILY SHIFT','2022-07-13','2022-07-13 06:53:24','2022-07-14 06:53:24','581',0.00,0.00,'581','2022-07-13 18:17:55','581','2022-07-13 18:18:21',10,0),('1','153',257671,'DAILY SHIFT','2022-07-13','2022-07-13 18:28:52','2022-07-14 18:28:52','581',0.00,0.00,'581','2022-07-13 21:20:51','581','2022-07-13 21:21:19',10,0),('1','153',257672,'DAILY SHIFT','2022-07-14','2022-07-14 07:14:42','2022-07-15 07:14:42','581',0.00,0.00,'581','2022-07-14 21:35:51','581','2022-07-14 21:36:18',10,0),('1','153',257673,'DAILY SHIFT','2022-07-15','2022-07-15 06:33:22','2022-07-16 06:33:22','581',0.00,0.00,'581','2022-07-15 21:12:48','581','2022-07-15 21:13:10',10,0),('1','153',257674,'DAILY SHIFT','2022-07-16','2022-07-16 06:53:53','2022-07-17 06:53:53','581',0.00,0.00,'581','2022-07-16 19:36:30','581','2022-07-16 21:12:29',10,0),('1','153',257675,'DAILY SHIFT','2022-07-17','2022-07-17 06:48:59','2022-07-18 06:48:59','581',0.00,0.00,'581','2022-07-17 19:21:52','581','2022-07-17 22:41:24',10,0),('1','153',257676,'DAILY SHIFT','2022-07-18','2022-07-18 06:04:36','2022-07-19 06:04:36','581',0.00,0.00,'581','2022-07-18 11:35:21','581','2022-07-18 11:35:52',10,0),('1','153',257677,'DAILY SHIFT','2022-07-18','2022-07-18 12:04:48','2022-07-19 12:04:48','581',0.00,0.00,'581','2022-07-18 22:16:20','581','2022-07-18 22:16:38',10,0),('1','153',257678,'DAILY SHIFT','2022-07-19','2022-07-19 06:26:02','2022-07-20 06:26:02','581',0.00,0.00,'581','2022-07-19 21:38:51','581','2022-07-19 21:39:17',10,0),('1','153',257679,'DAILY SHIFT','2022-07-20','2022-07-20 06:47:40','2022-07-21 06:47:40','581',0.00,0.00,'581','2022-07-20 10:38:46','581','2022-07-20 10:39:11',10,0),('1','153',257680,'DAILY SHIFT','2022-07-20','2022-07-20 10:51:17','2022-07-21 10:51:17','581',0.00,0.00,'581','2022-07-20 19:35:35','581','2022-07-20 21:00:24',10,0),('1','153',257681,'DAILY SHIFT','2022-07-21','2022-07-21 07:14:50','2022-07-22 07:14:50','581',0.00,0.00,'581','2022-07-21 21:27:02','581','2022-07-21 21:27:57',10,0),('1','153',257682,'DAILY SHIFT','2022-07-22','2022-07-22 06:31:22','2022-07-23 06:31:22','581',0.00,0.00,'581','2022-07-22 20:42:14','581','2022-07-22 21:08:31',10,0),('1','153',257683,'DAILY SHFT','2022-07-23','2022-07-23 06:58:36','2022-07-24 06:58:36','581',0.00,0.00,'581','2022-07-23 15:12:20','581','2022-07-23 17:26:39',10,0),('1','153',257684,'DAILY SHIFT','2022-07-23','2022-07-23 17:30:14','2022-07-24 17:30:14','581',0.00,0.00,'581','2022-07-23 21:10:23','581','2022-07-23 21:12:30',10,0),('1','153',257685,'DAILY SHIFT','2022-07-24','2022-07-24 07:00:30','2022-07-25 07:00:30','581',0.00,0.00,'581','2022-07-24 20:11:53','581','2022-07-24 21:15:32',10,0),('1','153',257686,'DAILY SHIFT','2022-07-25','2022-07-25 06:45:34','2022-07-26 06:45:34','581',0.00,0.00,'581','2022-07-25 21:12:59','581','2022-07-25 21:40:19',10,0),('1','153',257687,'DAILY SHIFT','2022-07-26','2022-07-26 07:01:10','2022-07-27 07:01:10','581',0.00,0.00,'581','2022-07-26 19:40:54','581','2022-07-26 19:42:17',10,0),('1','153',257688,'DAILY SHIFT','2022-07-27','2022-07-27 06:06:05','2022-07-28 06:06:05','581',0.00,0.00,'581','2022-07-27 19:07:04','581','2022-07-27 21:05:23',10,0),('1','153',257689,'DAILY SHIFT','2022-07-28','2022-07-28 06:53:04','2022-07-29 06:53:04','581',0.00,0.00,'581','2022-07-28 12:31:32','581','2022-07-28 12:31:55',10,0),('1','153',257690,'DAILY SHIFT','2022-07-28','2022-07-28 12:47:50','2022-07-29 12:47:50','581',0.00,0.00,'581','2022-07-28 19:24:30','581','2022-07-29 07:34:38',10,0),('1','153',257691,'DAILY SHFT','2022-07-29','2022-07-29 07:35:30','2022-07-30 07:35:30','581',0.00,0.00,'581','2022-07-29 21:14:22','581','2022-07-29 21:14:47',10,0),('1','153',257692,'DAILY SHIFT','2022-07-30','2022-07-30 05:45:38','2022-07-31 05:45:38','581',0.00,0.00,'581','2022-07-30 19:38:50','581','2022-07-30 19:39:30',10,0),('1','153',257693,'DAILY SHIFT','2022-07-31','2022-07-31 06:17:53','2022-08-01 06:17:53','581',0.00,0.00,'581','2022-07-31 21:25:11','581','2022-07-31 21:26:26',10,0),('1','153',257694,'DAILY SHIFT','2022-08-01','2022-08-01 05:34:19','2022-08-02 05:34:19','581',0.00,0.00,'581','2022-08-01 12:34:01','581','2022-08-01 12:35:09',10,0),('1','153',257695,'DAILY SHIFT','2022-08-01','2022-08-01 12:37:51','2022-08-02 12:37:51','581',0.00,0.00,'581','2022-08-01 21:26:15','581','2022-08-01 21:26:46',10,0),('1','153',257696,'DAILY SHIFT','2022-08-02','2022-08-02 06:11:05','2022-08-03 06:11:05','581',0.00,0.00,'581','2022-08-02 21:15:19','581','2022-08-02 21:16:02',10,0),('1','153',257697,'DAILY SHIFT','2022-08-03','2022-08-03 07:20:20','2022-08-04 07:20:20','581',0.00,0.00,'581','2022-08-03 20:50:29','581','2022-08-03 20:50:50',10,0),('1','153',257698,'DAILY SHIFT','2022-08-04','2022-08-04 06:42:51','2022-08-05 06:42:51','581',0.00,0.00,'581','2022-08-04 19:03:45','581','2022-08-04 21:30:20',10,0),('1','153',257699,'DAILY SHIFT','2022-08-05','2022-08-05 07:09:20','2022-08-06 07:09:20','581',0.00,0.00,'581','2022-08-05 19:32:45','581','2022-08-05 21:11:59',10,0),('1','153',257700,'DAILY SHIFT','2022-08-06','2022-08-06 06:24:47','2022-08-07 06:24:47','581',0.00,0.00,'581','2022-08-06 20:10:32','581','2022-08-06 20:59:44',10,0),('1','153',257701,'DAILY SHIFT','2022-08-07','2022-08-07 06:35:21','2022-08-08 06:35:21','581',0.00,0.00,'581','2022-08-07 20:49:18','581','2022-08-07 20:49:54',10,0),('1','153',257702,'DAILY SHIFT','2022-08-08','2022-08-08 06:49:46','2022-08-09 06:49:46','581',0.00,0.00,'581','2022-08-08 13:27:07','581','2022-08-08 13:27:40',10,0),('1','153',257703,'DAILY SHIFT','2022-08-08','2022-08-08 13:33:15','2022-08-09 13:33:15','581',0.00,0.00,'581','2022-08-08 19:43:29','581','2022-08-08 19:43:58',10,0),('1','153',257704,'DAILY SHIFT','2022-08-09','2022-08-09 07:07:37','2022-08-10 07:07:37','581',0.00,0.00,'581','2022-08-09 19:28:45','581','2022-08-09 19:29:09',10,0),('1','153',257705,'DAILY SHIFT','2022-08-10','2022-08-10 07:03:45','2022-08-11 07:03:45','581',0.00,0.00,'581','2022-08-10 19:36:59','581','2022-08-10 19:58:50',10,0),('1','153',257706,'DAILY SHIFT','2022-08-11','2022-08-11 07:46:15','2022-08-12 07:46:15','581',0.00,0.00,'581','2022-08-11 19:07:25','581','2022-08-11 19:08:28',10,0),('1','153',257707,'DAILY SHFT','2022-08-12','2022-08-12 06:55:59','2022-08-13 06:55:59','581',0.00,0.00,'581','2022-08-12 14:26:41','581','2022-08-12 14:27:03',10,0),('1','153',257708,'Daily shift','2022-08-12','2022-08-12 15:51:49','2022-08-13 15:51:49','581',0.00,0.00,'581','2022-08-12 18:48:09','581','2022-08-12 18:48:37',10,0),('1','153',257709,'Daily shift','2022-08-13','2022-08-13 07:30:03','2022-08-14 07:30:03','581',0.00,0.00,'581','2022-08-13 18:44:15','581','2022-08-13 18:44:39',10,0),('1','153',257710,'DAILY SHFT','2022-08-14','2022-08-14 06:52:06','2022-08-15 06:52:06','581',0.00,0.00,'581','2022-08-14 20:24:00','581','2022-08-14 20:24:25',10,0),('1','153',257711,'Daily shift','2022-08-15','2022-08-15 07:57:48','2022-08-16 07:57:48','581',0.00,0.00,'581','2022-08-15 22:18:53','581','2022-08-15 22:19:49',10,0),('1','153',257712,'DAILY SHFT','2022-08-16','2022-08-16 06:54:46','2022-08-17 06:54:46','581',0.00,0.00,'581','2022-08-16 20:56:45','581','2022-08-16 20:58:17',10,0),('1','153',257713,'Daily shift','2022-08-17','2022-08-17 07:36:40','2022-08-18 07:36:40','581',0.00,0.00,'581','2022-08-17 13:10:31','581','2022-08-17 13:11:06',10,0),('1','153',257714,'Daily shift','2022-08-17','2022-08-17 13:11:31','2022-08-18 13:11:31','581',0.00,0.00,'581','2022-08-17 20:42:18','581','2022-08-17 20:42:39',10,0),('1','153',257715,'DAILY SHFT','2022-08-18','2022-08-18 06:35:00','2022-08-19 06:35:00','581',0.00,0.00,'581','2022-08-18 18:48:20','581','2022-08-18 18:48:49',10,0),('1','153',257716,'Daily shift','2022-08-19','2022-08-19 07:20:31','2022-08-20 07:20:31','581',0.00,0.00,'581','2022-08-19 18:41:40','581','2022-08-19 18:42:03',10,0),('1','153',257717,'Daily shift','2022-08-19','2022-08-19 18:42:31','2022-08-20 18:42:31','581',0.00,0.00,'581','2022-08-19 18:51:23','581','2022-08-19 18:51:45',10,0),('1','153',257718,'DAILY SHFT','2022-08-20','2022-08-20 06:54:15','2022-08-21 06:54:15','581',0.00,0.00,'581','2022-08-20 21:06:58','581','2022-08-20 21:07:31',10,0),('1','153',257719,'Daily shift','2022-08-21','2022-08-21 07:32:43','2022-08-22 07:32:43','581',0.00,0.00,'581','2022-08-21 19:55:03','581','2022-08-21 19:55:25',10,0),('1','153',257720,'DAILY SHFT','2022-08-22','2022-08-22 06:56:16','2022-08-23 06:56:16','581',0.00,0.00,'581','2022-08-22 21:25:25','581','2022-08-22 21:25:50',10,0),('1','153',257721,'Daily shift','2022-08-23','2022-08-23 07:40:22','2022-08-24 07:40:22','581',0.00,0.00,'581','2022-08-23 21:46:41','581','2022-08-23 21:47:07',10,0),('1','153',257722,'DAILY SHFT','2022-08-24','2022-08-24 06:34:58','2022-08-25 06:34:58','581',0.00,0.00,'581','2022-08-24 20:46:19','581','2022-08-24 20:47:56',10,0),('1','153',257723,'Daily shift','2022-08-25','2022-08-25 08:32:26','2022-08-26 08:32:26','581',0.00,0.00,'581','2022-08-25 20:28:15','581','2022-08-25 20:30:24',10,0),('1','153',257724,'DAILY SHFT','2022-08-26','2022-08-26 06:09:23','2022-08-27 06:09:23','581',0.00,0.00,'581','2022-08-26 20:52:51','581','2022-08-26 20:53:22',10,0),('1','153',257725,'Daily shift','2022-08-27','2022-08-27 07:22:50','2022-08-28 07:22:50','581',0.00,0.00,'581','2022-08-27 21:19:37','581','2022-08-27 21:20:36',10,0),('1','153',257726,'DAILY SHFT','2022-08-28','2022-08-28 06:55:18','2022-08-29 06:55:18','581',0.00,0.00,'581','2022-08-28 11:36:25','581','2022-08-28 11:36:47',10,0),('1','153',257727,'Daily shift','2022-08-28','2022-08-28 17:57:58','2022-08-29 17:57:58','581',0.00,0.00,'581','2022-08-28 18:04:18','581','2022-08-28 18:04:36',10,0),('1','153',257728,'Daily shift','2022-08-30','2022-08-30 07:42:02','2022-08-31 07:42:02','581',0.00,0.00,'581','2022-08-30 19:05:55','581','2022-08-30 19:06:15',10,0),('1','153',257729,'Daily shift','2022-08-31','2022-08-31 07:43:22','2022-09-01 07:43:22','581',0.00,0.00,'581','2022-08-31 21:29:49','581','2022-08-31 21:30:18',10,0),('1','153',257730,'DAILY SHFT','2022-09-01','2022-09-01 07:15:39','2022-09-02 07:15:39','581',0.00,0.00,'581','2022-09-01 21:31:50','581','2022-09-01 21:32:11',10,0),('1','153',257731,'Daily shift','2022-09-02','2022-09-02 07:25:48','2022-09-03 07:25:48','581',0.00,0.00,'581','2022-09-02 21:16:48','581','2022-09-02 21:17:23',10,0),('1','153',257732,'Daily shift','2022-09-03','2022-09-03 09:44:41','2022-09-04 09:44:41','581',0.00,0.00,'581','2022-09-03 20:35:32','581','2022-09-03 20:35:54',10,0),('1','153',257733,'Daily shift','2022-09-04','2022-09-04 07:13:28','2022-09-05 07:13:28','581',0.00,0.00,'581','2022-09-04 23:11:35','581','2022-09-04 23:11:59',10,0),('1','153',257734,'Daily shift','2022-09-05','2022-09-05 13:28:43','2022-09-06 13:28:43','581',0.00,0.00,'581','2022-09-05 21:11:31','581','2022-09-05 21:11:53',10,0),('1','153',257735,'Daily shift','2022-09-06','2022-09-06 07:20:11','2022-09-07 07:20:11','581',0.00,0.00,'581','2022-09-06 21:20:14','581','2022-09-06 21:33:58',10,0),('1','153',257736,'DAILY SHFT','2022-09-07','2022-09-07 07:05:31','2022-09-08 07:05:31','581',0.00,0.00,'581','2022-09-07 22:07:06','581','2022-09-07 22:07:33',10,0),('1','153',257737,'Daily shift','2022-09-08','2022-09-08 07:25:51','2022-09-09 07:25:51','581',0.00,0.00,'581','2022-09-08 20:53:20','581','2022-09-08 20:55:14',10,0),('1','153',257738,'DAILY SHFT','2022-09-09','2022-09-09 06:30:28','2022-09-10 06:30:28','581',0.00,0.00,'581','2022-09-09 13:00:48','581','2022-09-09 13:01:15',10,0),('1','153',257739,'Daily shift','2022-09-10','2022-09-10 14:32:10','2022-09-11 14:32:10','581',0.00,0.00,'581','2022-09-10 20:29:08','581','2022-09-10 20:29:30',10,0),('1','153',257740,'DAILY SHFT','2022-09-11','2022-09-11 06:28:09','2022-09-12 06:28:09','581',0.00,0.00,'581','2022-09-11 21:00:48','581','2022-09-11 21:01:16',10,0),('1','153',257741,'DAILY SHIFTS','2022-09-12','2022-09-12 07:03:40','2022-09-13 07:03:40','581',0.00,0.00,'581','2022-09-12 21:15:50','581','2022-09-12 21:16:21',10,0),('1','153',257742,'DAILY SHFT','2022-09-13','2022-09-13 06:51:04','2022-09-14 06:51:04','581',0.00,0.00,'581','2022-09-13 20:44:47','581','2022-09-13 20:45:18',10,0),('1','153',257743,'Daily shift','2022-09-14','2022-09-14 07:28:09','2022-09-15 07:28:09','581',0.00,0.00,'581','2022-09-14 11:35:53','581','2022-09-14 11:36:15',10,0),('1','153',257744,'Daily shift','2022-09-14','2022-09-14 11:36:52','2022-09-15 11:36:52','581',0.00,0.00,'581','2022-09-14 20:41:48','581','2022-09-14 20:42:32',10,0),('1','153',257745,'DAILY SHFT','2022-09-15','2022-09-15 07:04:06','2022-09-16 07:04:06','581',0.00,0.00,'581','2022-09-15 21:19:25','581','2022-09-15 21:19:52',10,0),('1','153',257746,'Daily shift','2022-09-16','2022-09-16 07:17:28','2022-09-17 07:17:28','581',0.00,0.00,'581','2022-09-16 21:16:41','581','2022-09-16 21:17:06',10,0),('1','153',257747,'DAILY SHFT','2022-09-17','2022-09-17 06:56:33','2022-09-18 06:56:33','581',0.00,0.00,'581','2022-09-17 21:45:59','581','2022-09-17 21:46:24',10,0),('1','153',257748,'Daily shift','2022-09-18','2022-09-18 07:25:07','2022-09-19 07:25:07','581',0.00,0.00,'581','2022-09-18 21:29:01','581','2022-09-18 21:29:42',10,0),('1','153',257749,'Daily shift','2022-09-20','2022-09-20 14:40:45','2022-09-21 14:40:45','581',0.00,0.00,'581','2022-09-20 20:48:33','581','2022-09-20 20:49:09',10,0),('1','153',257750,'Daily shift','2022-09-21','2022-09-21 07:33:26','2022-09-22 07:33:26','581',0.00,0.00,'581','2022-09-21 21:53:28','581','2022-09-21 21:53:59',10,0),('1','153',257751,'Daily shift','2022-09-22','2022-09-22 07:26:21','2022-09-23 07:26:21','581',0.00,0.00,'581','2022-09-22 20:20:23','581','2022-09-22 20:21:04',10,0),('1','153',257752,'DAILY SHFT','2022-09-23','2022-09-23 06:14:32','2022-09-24 06:14:32','581',0.00,0.00,'581','2022-09-23 21:12:26','581','2022-09-23 21:12:54',10,0),('1','153',257753,'Daily shift','2022-09-24','2022-09-24 07:43:08','2022-09-25 07:43:08','581',0.00,0.00,'581','2022-09-24 21:22:04','581','2022-09-24 21:22:35',10,0),('1','153',257754,'DAILY SHFT','2022-09-25','2022-09-25 06:49:54','2022-09-26 06:49:54','581',0.00,0.00,'581','2022-09-25 13:11:00','581','2022-09-25 13:11:27',10,0),('1','153',257755,'Daily shift','2022-09-25','2022-09-25 16:52:39','2022-09-26 16:52:39','581',0.00,0.00,'581','2022-09-25 22:32:29','581','2022-09-25 22:32:55',10,0),('1','153',257756,'Daily shift','2022-09-26','2022-09-26 07:34:20','2022-09-27 07:34:20','581',0.00,0.00,'581','2022-09-26 20:49:48','581','2022-09-26 20:50:17',10,0),('1','153',257757,'DAILY SHFT','2022-09-27','2022-09-27 06:30:35','2022-09-28 06:30:35','581',0.00,0.00,'581','2022-09-27 21:30:38','581','2022-09-27 21:31:12',10,0),('1','153',257758,'Daily shift','2022-09-28','2022-09-28 06:54:50','2022-09-29 06:54:50','581',0.00,0.00,'581','2022-09-28 20:59:10','581','2022-09-28 20:59:40',10,0),('1','153',257759,'DAILY SHIFT','2022-09-29','2022-09-29 07:10:25','2022-09-30 07:10:25','581',0.00,0.00,'581','2022-09-29 21:33:26','581','2022-09-29 21:33:51',10,0),('1','153',257760,'Daily shift','2022-09-30','2022-09-30 07:14:52','2022-10-01 07:14:52','581',0.00,0.00,'581','2022-09-30 12:00:08','581','2022-09-30 12:00:32',10,0),('1','153',257761,'Daily shift','2022-09-30','2022-09-30 15:04:37','2022-10-01 15:04:37','581',0.00,0.00,'581','2022-09-30 21:07:30','581','2022-09-30 21:08:19',10,0),('1','153',257762,'DAILY SHIFT','2022-10-01','2022-10-01 07:17:59','2022-10-02 07:17:59','581',0.00,0.00,'581','2022-10-01 21:34:50','581','2022-10-01 21:35:22',10,0),('1','153',257763,'Daily shift','2022-10-02','2022-10-02 07:09:40','2022-10-03 07:09:40','581',0.00,0.00,'581','2022-10-02 20:55:44','581','2022-10-02 20:56:08',10,0),('1','153',257764,'Daily shift','2022-10-03','2022-10-03 07:03:49','2022-10-04 07:03:49','581',0.00,0.00,'581','2022-10-03 20:31:54','581','2022-10-03 20:32:27',10,0),('1','153',257765,'Daily shift','2022-10-04','2022-10-04 07:12:38','2022-10-05 07:12:38','581',0.00,0.00,'581','2022-10-04 14:33:15','581','2022-10-04 14:33:40',10,0),('1','153',257766,'Daily shift','2022-10-04','2022-10-04 14:40:13','2022-10-05 14:40:13','581',0.00,0.00,'581','2022-10-04 21:07:15','581','2022-10-04 21:07:43',10,0),('1','153',257767,'Daily shift','2022-10-05','2022-10-05 07:56:49','2022-10-06 07:56:49','581',0.00,0.00,'581','2022-10-05 17:24:55','581','2022-10-05 17:25:20',10,0),('1','153',257768,'Daily shift','2022-10-05','2022-10-05 17:25:57','2022-10-06 17:25:57','581',0.00,0.00,'581','2022-10-05 21:04:51','581','2022-10-05 21:05:24',10,0),('1','153',257769,'Daily shift','2022-10-06','2022-10-06 07:36:14','2022-10-07 07:36:14','581',0.00,0.00,'581','2022-10-06 20:28:29','581','2022-10-06 20:28:55',10,0),('1','153',257770,'Daily shift','2022-10-07','2022-10-07 07:13:34','2022-10-08 07:13:34','581',0.00,0.00,'581','2022-10-07 20:50:20','581','2022-10-07 20:51:03',10,0),('1','153',257771,'Daily shift','2022-10-08','2022-10-08 07:28:19','2022-10-09 07:28:19','581',0.00,0.00,'581','2022-10-08 21:01:42','581','2022-10-08 21:02:11',10,0),('1','153',257772,'Daily shift','2022-10-13','2022-10-13 14:47:29','2022-10-14 14:47:29','581',0.00,0.00,'581','2022-10-13 20:00:36','581','2022-10-13 20:01:04',10,0),('1','153',257773,'DAILY SHFT','2022-10-14','2022-10-14 07:04:01','2022-10-15 07:04:01','581',0.00,0.00,'581','2022-10-14 11:29:57','581','2022-10-14 11:30:20',10,0),('1','153',257774,'Daily shift','2022-10-14','2022-10-14 12:38:50','2022-10-15 12:38:50','581',0.00,0.00,'581','2022-10-14 20:47:56','581','2022-10-14 20:48:40',10,0),('1','153',257775,'DAILY SHFT','2022-10-15','2022-10-15 06:34:39','2022-10-16 06:34:39','581',0.00,0.00,'581','2022-10-15 22:43:10','581','2022-10-15 22:43:32',10,0),('1','153',257776,'Daily shift','2022-10-16','2022-10-16 07:01:20','2022-10-17 07:01:20','581',0.00,0.00,'581','2022-10-16 21:29:21','581','2022-10-16 21:29:48',10,0),('1','153',257777,'Daily shift','2022-10-17','2022-10-17 07:02:31','2022-10-18 07:02:31','581',0.00,0.00,'581','2022-10-17 19:04:57','581','2022-10-17 19:05:25',10,0),('1','153',257778,'DAILY SHIFT','2022-10-18','2022-10-18 06:45:12','2022-10-19 06:45:12','581',0.00,0.00,'581','2022-10-18 18:05:54','581','2022-10-18 18:06:17',10,0),('1','153',257779,'Daily shift','2022-10-19','2022-10-19 07:09:17','2022-10-20 07:09:17','581',0.00,0.00,'965','2022-10-19 20:31:10','965','2022-10-19 20:31:36',10,0),('1','153',257780,'Daily shift','2022-10-20','2022-10-20 07:05:57','2022-10-21 07:05:57','965',0.00,0.00,'965','2022-10-20 21:35:29','965','2022-10-20 21:35:57',10,0),('1','153',257781,'Daily shift','2022-10-21','2022-10-21 07:20:42','2022-10-22 07:20:42','965',0.00,0.00,'965','2022-10-21 20:38:29','965','2022-10-21 20:39:04',10,0),('1','153',257782,'Daily shift','2022-10-22','2022-10-22 07:02:23','2022-10-23 07:02:23','965',0.00,0.00,'965','2022-10-22 20:37:41','965','2022-10-22 20:38:08',10,0),('1','153',257783,'DAILY SHIFT','2022-10-23','2022-10-23 06:39:44','2022-10-24 06:39:44','965',0.00,0.00,'965','2022-10-23 09:02:50','965','2022-10-23 09:06:09',10,0),('1','153',257784,'Daily shift','2022-10-23','2022-10-23 09:26:00','2022-10-24 09:26:00','965',0.00,0.00,'965','2022-10-23 20:54:18','965','2022-10-23 20:54:41',10,0),('1','153',257785,'Daily shift','2022-10-24','2022-10-24 07:04:05','2022-10-25 07:04:05','965',0.00,0.00,'965','2022-10-24 21:15:45','965','2022-10-24 21:16:10',10,0),('1','153',257786,'DAILY SHIFT','2022-10-25','2022-10-25 06:36:35','2022-10-26 06:36:35','965',0.00,0.00,'965','2022-10-25 21:21:56','965','2022-10-25 21:22:20',10,0),('1','153',257787,'DAILY SHIFT','2022-10-26','2022-10-26 06:40:39','2022-10-27 06:40:39','965',0.00,0.00,'965','2022-10-26 21:23:13','965','2022-10-26 21:24:16',10,0),('1','153',257788,'Daily shift','2022-10-27','2022-10-27 08:04:02','2022-10-28 08:04:02','965',0.00,0.00,'965','2022-10-27 21:24:21','965','2022-10-27 21:25:01',10,0),('1','153',257789,'DAILY SHIFT','2022-10-28','2022-10-28 07:00:52','2022-10-29 07:00:52','965',0.00,0.00,'965','2022-10-28 20:57:58','965','2022-10-28 20:58:25',10,0),('1','153',257790,'DAILY SHIFT','2022-10-29','2022-10-29 10:34:46','2022-10-30 10:34:46','965',0.00,0.00,'965','2022-10-29 20:37:15','965','2022-10-29 20:37:37',10,0),('1','153',257791,'Daily shift','2022-10-31','2022-10-31 16:22:02','2022-11-01 16:22:02','965',0.00,0.00,'965','2022-10-31 22:37:34','965','2022-10-31 22:38:03',10,0),('1','153',257792,'Daily shift','2022-11-01','2022-11-01 07:20:49','2022-11-02 07:20:49','965',0.00,0.00,'965','2022-11-01 23:06:40','965','2022-11-01 23:07:13',10,0),('1','153',257793,'Daily shift','2022-11-02','2022-11-02 07:33:39','2022-11-03 07:33:39','965',0.00,0.00,'965','2022-11-02 20:15:39','965','2022-11-02 20:16:13',10,0),('1','153',257794,'Daily shift','2022-11-05','2022-11-05 15:37:07','2022-11-06 15:37:07','965',0.00,0.00,'965','2022-11-05 21:05:53','965','2022-11-05 21:06:20',10,0),('1','153',257795,'Daily shift','2022-11-06','2022-11-06 09:09:22','2022-11-07 09:09:22','965',0.00,0.00,'965','2022-11-06 21:32:23','965','2022-11-06 21:32:47',10,0),('1','153',257796,'Daily shift','2022-11-07','2022-11-07 10:21:03','2022-11-08 10:21:03','965',0.00,0.00,'965','2022-11-07 20:35:26','965','2022-11-07 20:35:48',10,0),('1','153',257797,'Daily shift','2022-11-08','2022-11-08 07:34:26','2022-11-09 07:34:26','965',0.00,0.00,'965','2022-11-08 19:15:06','965','2022-11-08 19:15:32',10,0),('1','153',257798,'Daily shift','2022-11-10','2022-11-10 07:22:39','2022-11-11 07:22:39','965',0.00,0.00,'965','2022-11-10 23:00:16','965','2022-11-10 23:00:40',10,0),('1','153',257799,'Daily shift','2022-11-11','2022-11-11 07:29:55','2022-11-12 07:29:55','965',0.00,0.00,'965','2022-11-11 23:47:43','965','2022-11-11 23:48:10',10,0),('1','153',257800,'Daily shift','2022-11-12','2022-11-12 07:33:10','2022-11-13 07:33:10','965',0.00,0.00,'965','2022-11-12 22:01:58','965','2022-11-12 22:02:22',10,0),('1','153',257801,'Daily shift','2022-11-13','2022-11-13 07:38:42','2022-11-14 07:38:42','965',0.00,0.00,'965','2022-11-13 23:24:36','965','2022-11-13 23:25:11',10,0),('1','153',257802,'Daily shift','2022-11-13','2022-11-13 23:25:54','2022-11-14 23:25:54','965',0.00,0.00,'965','2022-11-14 06:09:18','965','2022-11-14 06:09:37',10,0),('1','153',257803,'DAILY SHIFT','2022-11-14','2022-11-14 07:15:25','2022-11-15 07:15:25','965',0.00,0.00,'965','2022-11-14 21:57:52','965','2022-11-14 21:58:38',10,0),('1','153',257804,'DAILY SHIFT','2022-11-15','2022-11-15 07:12:10','2022-11-16 07:12:10','965',0.00,0.00,'965','2022-11-15 22:15:51','965','2022-11-15 22:16:21',10,0),('1','153',257805,'DAILY SHIFT','2022-11-16','2022-11-16 07:15:06','2022-11-17 07:15:06','965',0.00,0.00,'965','2022-11-16 21:40:28','965','2022-11-16 21:40:56',10,0),('1','153',257806,'DAILY SHIFT','2022-11-17','2022-11-17 07:15:01','2022-11-18 07:15:01','965',0.00,0.00,'965','2022-11-18 06:37:10','965','2022-11-18 06:37:32',10,0),('1','153',257807,'Daily shift','2022-11-18','2022-11-18 09:19:20','2022-11-19 09:19:20','965',0.00,0.00,'965','2022-11-18 21:12:47','965','2022-11-18 21:13:22',10,0),('1','153',257808,'Daily shift','2022-11-19','2022-11-19 08:46:05','2022-11-20 08:46:05','965',0.00,0.00,'965','2022-11-20 06:49:51','965','2022-11-20 06:50:11',10,0),('1','153',257809,'Daily shift','2022-11-20','2022-11-20 08:31:18','2022-11-21 08:31:18','965',0.00,0.00,'965','2022-11-20 12:08:18','965','2022-11-20 12:08:45',10,0),('1','153',257810,'Daily shift','2022-11-20','2022-11-20 12:15:31','2022-11-21 12:15:31','965',0.00,0.00,'965','2022-11-20 21:29:22','965','2022-11-20 21:29:47',10,0),('1','153',257811,'Daily shift','2022-11-21','2022-11-21 07:23:08','2022-11-22 07:23:08','965',0.00,0.00,'965','2022-11-21 20:42:16','965','2022-11-21 20:42:38',10,0),('1','153',257812,'Daily shift','2022-11-22','2022-11-22 07:23:32','2022-11-23 07:23:32','965',0.00,0.00,'965','2022-11-22 22:17:59','965','2022-11-22 22:18:21',10,0),('1','153',257813,'Daily shift','2022-11-23','2022-11-23 07:07:14','2022-11-24 07:07:14','965',0.00,0.00,'965','2022-11-23 20:36:13','965','2022-11-23 20:36:34',10,0),('1','153',257814,'Daily shift','2022-11-24','2022-11-24 07:32:16','2022-11-25 07:32:16','965',0.00,0.00,'965','2022-11-24 18:05:13','965','2022-11-24 18:05:45',10,0),('1','153',257815,'Daily shift','2022-11-24','2022-11-24 18:09:45','2022-11-25 18:09:45','965',0.00,0.00,'965','2022-11-24 22:14:31','965','2022-11-24 22:15:38',10,0),('1','153',257816,'Daily shift','2022-11-25','2022-11-25 07:53:46','2022-11-26 07:53:46','965',0.00,0.00,'965','2022-11-25 14:25:10','965','2022-11-25 14:25:39',10,0),('1','153',257817,'Daily shift','2022-11-25','2022-11-25 17:02:06','2022-11-26 17:02:06','965',0.00,0.00,'965','2022-11-25 21:17:26','965','2022-11-25 21:17:44',10,0),('1','153',257818,'DAILY SHIFT','2022-11-26','2022-11-26 10:11:55','2022-11-27 10:11:55','965',0.00,0.00,'965','2022-11-26 22:43:24','965','2022-11-26 22:43:47',10,0),('1','153',257819,'DAILY SHIFT','2022-11-27','2022-11-27 06:46:12','2022-11-28 06:46:12','965',0.00,0.00,'965','2022-11-27 21:20:56','965','2022-11-27 21:21:18',10,0),('1','153',257820,'DAILY SHIFT','2022-11-28','2022-11-28 06:48:43','2022-11-29 06:48:43','965',0.00,0.00,'965','2022-11-28 10:06:00','965','2022-11-28 10:06:22',10,0),('1','153',257821,'Daily shift','2022-11-28','2022-11-28 10:08:18','2022-11-29 10:08:18','965',0.00,0.00,'965','2022-11-28 18:43:30','965','2022-11-28 18:43:51',10,0),('1','153',257822,'Daily shift','2022-11-28','2022-11-28 18:44:22','2022-11-29 18:44:22','965',0.00,0.00,'965','2022-11-28 21:39:55','965','2022-11-28 21:40:21',10,0),('1','153',257823,'DAILY SHIFT','2022-11-29','2022-11-29 06:49:10','2022-11-30 06:49:10','965',0.00,0.00,'965','2022-11-29 21:03:14','965','2022-11-29 21:03:39',10,0),('1','153',257824,'Daily shift','2022-11-29','2022-11-29 21:04:08','2022-11-30 21:04:08','965',0.00,0.00,'965','2022-11-29 23:34:51','965','2022-11-29 23:35:11',10,0),('1','153',257825,'Daily shift','2022-11-30','2022-11-30 07:34:58','2022-12-01 07:34:58','965',0.00,0.00,'965','2022-11-30 23:02:00','965','2022-11-30 23:02:23',10,0),('1','153',257826,'DAILY SHIFT','2022-12-01','2022-12-01 07:44:36','2022-12-02 07:44:36','965',0.00,0.00,'965','2022-12-01 21:11:29','965','2022-12-01 21:11:52',10,0),('1','153',257827,'Daily shift','2022-12-02','2022-12-02 07:39:09','2022-12-03 07:39:09','965',0.00,0.00,'965','2022-12-02 17:52:01','965','2022-12-02 17:52:30',10,0),('1','153',257828,'Daily shift','2022-12-02','2022-12-02 18:00:34','2022-12-03 18:00:34','965',0.00,0.00,'965','2022-12-02 21:32:31','965','2022-12-02 21:33:09',10,0),('1','153',257829,'DAILY SHIFT','2022-12-03','2022-12-03 06:56:37','2022-12-04 06:56:37','965',0.00,0.00,'965','2022-12-03 22:02:10','965','2022-12-03 22:02:58',10,0),('1','153',257830,'Daily shift','2022-12-04','2022-12-04 07:37:14','2022-12-05 07:37:14','965',0.00,0.00,'965','2022-12-05 09:43:23','965','2022-12-05 09:43:47',10,0),('1','153',257831,'Daily shift','2022-12-05','2022-12-05 09:49:24','2022-12-06 09:49:24','965',0.00,0.00,'965','2022-12-05 21:53:52','965','2022-12-05 21:54:15',10,0),('1','153',257832,'Daily shift','2022-12-06','2022-12-06 07:37:49','2022-12-07 07:37:49','965',0.00,0.00,'965','2022-12-06 21:10:23','965','2022-12-06 21:10:47',10,0),('1','153',257833,'DAILY SHIFT','2022-12-07','2022-12-07 06:58:52','2022-12-08 06:58:52','965',0.00,0.00,'965','2022-12-07 22:16:07','965','2022-12-07 22:16:30',10,0),('1','153',257834,'Daily shift','2022-12-08','2022-12-08 09:46:25','2022-12-09 09:46:25','965',0.00,0.00,'965','2022-12-08 22:43:08','965','2022-12-08 22:43:35',10,0),('1','153',257835,'DAILY SHIFT','2022-12-09','2022-12-09 06:59:18','2022-12-10 06:59:18','965',0.00,0.00,'965','2022-12-09 09:40:54','965','2022-12-09 09:41:15',10,0),('1','153',257836,'Daily shift','2022-12-09','2022-12-09 09:41:43','2022-12-10 09:41:43','965',0.00,0.00,'965','2022-12-09 21:50:31','965','2022-12-09 21:50:56',10,0),('1','153',257837,'Daily shift','2022-12-10','2022-12-10 07:38:09','2022-12-11 07:38:09','965',0.00,0.00,'965','2022-12-10 22:20:33','965','2022-12-10 22:20:58',10,0),('1','153',257838,'DAILY SHIFT','2022-12-11','2022-12-11 07:14:56','2022-12-12 07:14:56','965',0.00,0.00,'965','2022-12-11 13:29:30','965','2022-12-11 13:29:53',10,0),('1','153',257839,'DAILY SHIFT','2022-12-11','2022-12-11 14:08:08','2022-12-12 14:08:08','965',0.00,0.00,'965','2022-12-11 22:33:02','965','2022-12-11 22:33:23',10,0),('1','153',257840,'Daily shift','2022-12-12','2022-12-12 07:54:04','2022-12-13 07:54:04','965',0.00,0.00,'965','2022-12-12 22:28:06','965','2022-12-12 22:28:33',10,0),('1','153',257841,'DAILY SHIFT','2022-12-13','2022-12-13 07:31:11','2022-12-14 07:31:11','965',0.00,0.00,'965','2022-12-13 21:10:17','965','2022-12-13 21:10:43',10,0),('1','153',257842,'Daily shift','2022-12-14','2022-12-14 07:08:02','2022-12-15 07:08:02','965',0.00,0.00,'965','2022-12-14 17:46:11','965','2022-12-14 17:46:33',10,0),('1','153',257843,'Daily shift','2022-12-14','2022-12-14 17:48:50','2022-12-15 17:48:50','965',0.00,0.00,'965','2022-12-14 22:34:01','965','2022-12-14 22:34:21',10,0),('1','153',257844,'DAILY SHIFT','2022-12-15','2022-12-15 07:27:36','2022-12-16 07:27:36','965',0.00,0.00,'965','2022-12-15 21:04:30','965','2022-12-15 21:04:56',10,0),('1','153',257845,'Daily shift','2022-12-16','2022-12-16 07:24:11','2022-12-17 07:24:11','965',0.00,0.00,'965','2022-12-17 05:24:30','965','2022-12-17 05:24:56',10,0),('1','153',257846,'DAILY SHIFT','2022-12-17','2022-12-17 07:18:29','2022-12-18 07:18:29','965',0.00,0.00,'965','2022-12-17 12:27:10','965','2022-12-17 12:28:32',10,0),('1','153',257847,'Daily shift','2022-12-17','2022-12-17 12:42:29','2022-12-18 12:42:29','965',0.00,0.00,'965','2022-12-17 22:18:31','965','2022-12-17 22:18:53',10,0),('1','153',257848,'Daily shift','2022-12-18','2022-12-18 07:59:24','2022-12-19 07:59:24','965',0.00,0.00,'965','2022-12-18 21:48:22','965','2022-12-18 21:49:19',10,0),('1','153',257849,'DAILY SHIFT','2022-12-19','2022-12-19 06:52:13','2022-12-20 06:52:13','965',0.00,0.00,'965','2022-12-19 19:08:47','965','2022-12-19 19:09:13',10,0),('1','153',257850,'DAILY SHIFT','2022-12-19','2022-12-19 19:53:35','2022-12-20 19:53:35','965',0.00,0.00,'965','2022-12-19 23:34:20','965','2022-12-19 23:34:47',10,0),('1','153',257851,'Daily shift','2022-12-20','2022-12-20 08:08:24','2022-12-21 08:08:24','965',0.00,0.00,'965','2022-12-20 22:09:58','965','2022-12-20 22:10:20',10,0),('1','153',257852,'DAILY SHIFT','2022-12-21','2022-12-21 06:54:05','2022-12-22 06:54:05','965',0.00,0.00,'965','2022-12-21 16:55:53','965','2022-12-21 16:56:16',10,0),('1','153',257853,'Daily shift','2022-12-21','2022-12-21 17:02:06','2022-12-22 17:02:06','965',0.00,0.00,'965','2022-12-21 21:25:57','965','2022-12-21 21:26:27',10,0),('1','153',257854,'Daily shift','2022-12-22','2022-12-22 07:47:57','2022-12-23 07:47:57','965',0.00,0.00,'965','2022-12-22 20:45:54','965','2022-12-22 20:46:20',10,0),('1','153',257855,'DAILY SHIFT','2022-12-23','2022-12-23 06:50:37','2022-12-24 06:50:37','965',0.00,0.00,'965','2022-12-23 20:27:51','965','2022-12-23 20:28:15',10,0),('1','153',257856,'DAILY SHIFT','2022-12-24','2022-12-24 07:18:38','2022-12-25 07:18:38','965',0.00,0.00,'965','2022-12-24 22:11:59','965','2022-12-24 22:12:31',10,0),('1','153',257857,'DAILY SHIFT','2022-12-25','2022-12-25 06:57:50','2022-12-26 06:57:50','965',0.00,0.00,'965','2022-12-25 16:50:34','965','2022-12-25 16:50:58',10,0),('1','153',257858,'Daily shift','2022-12-25','2022-12-25 16:57:22','2022-12-26 16:57:22','965',0.00,0.00,'965','2022-12-25 21:47:11','965','2022-12-25 21:47:39',10,0),('1','153',257859,'Daily shift','2022-12-26','2022-12-26 07:47:45','2022-12-27 07:47:45','965',0.00,0.00,'965','2022-12-26 22:53:56','965','2022-12-26 22:55:02',10,0),('1','153',257860,'DAILY SHIFT','2022-12-27','2022-12-27 07:02:55','2022-12-28 07:02:55','965',0.00,0.00,'965','2022-12-27 21:08:15','965','2022-12-27 21:09:00',10,0),('1','153',257861,'Daily shift','2022-12-28','2022-12-28 08:06:44','2022-12-29 08:06:44','965',0.00,0.00,'965','2022-12-28 17:46:55','965','2022-12-28 17:47:17',10,0),('1','153',257862,'Daily shift','2022-12-28','2022-12-28 17:47:40','2022-12-29 17:47:40','965',0.00,0.00,'965','2022-12-28 23:07:18','965','2022-12-28 23:07:39',10,0),('1','153',257863,'DAILY SHIFT','2022-12-29','2022-12-29 06:58:05','2022-12-30 06:58:05','965',0.00,0.00,'965','2022-12-29 20:25:31','965','2022-12-29 20:27:27',10,0),('1','153',257864,'DAILY SHIFT','2022-12-30','2022-12-30 07:26:29','2022-12-31 07:26:29','965',0.00,0.00,'965','2022-12-30 22:50:45','965','2022-12-30 22:51:11',10,0),('1','153',257865,'DAILY SHIFT','2022-12-31','2022-12-31 07:07:34','2023-01-01 07:07:34','965',0.00,0.00,'965','2022-12-31 17:04:52','965','2022-12-31 17:07:54',10,0),('1','153',257866,'Daily shift','2022-12-31','2022-12-31 17:49:08','2023-01-01 17:49:08','965',0.00,0.00,'965','2022-12-31 22:18:49','965','2022-12-31 22:19:15',10,0),('1','153',257867,'DAILY SHIFT','2023-01-01','2023-01-01 07:16:28','2023-01-02 07:16:28','965',0.00,0.00,'965','2023-01-01 22:54:40','965','2023-01-01 22:55:13',10,0),('1','153',257868,'Daily shift','2023-01-02','2023-01-02 07:42:09','2023-01-03 07:42:09','965',0.00,0.00,'965','2023-01-02 22:38:38','965','2023-01-02 22:39:04',10,0),('1','153',257869,'Daily shift','2023-01-03','2023-01-03 07:36:55','2023-01-04 07:36:55','965',0.00,0.00,'965','2023-01-03 21:22:17','965','2023-01-03 21:22:40',10,0),('1','153',257870,'Daily shift','2023-01-04','2023-01-04 07:40:22','2023-01-05 07:40:22','965',0.00,0.00,'965','2023-01-04 17:06:36','965','2023-01-04 17:07:02',10,0),('1','153',257871,'Daily shift','2023-01-04','2023-01-04 17:12:01','2023-01-05 17:12:01','965',0.00,0.00,'965','2023-01-04 23:14:13','965','2023-01-04 23:14:36',10,0),('1','153',257872,'DAILY SHIFT','2023-01-05','2023-01-05 07:19:32','2023-01-06 07:19:32','965',0.00,0.00,'965','2023-01-05 21:51:51','965','2023-01-05 21:52:16',10,0),('1','153',257873,'Daily shift','2023-01-06','2023-01-06 07:59:50','2023-01-07 07:59:50','965',0.00,0.00,'965','2023-01-06 20:38:09','965','2023-01-06 20:38:34',10,0),('1','153',257874,'DAILY SHIFT','2023-01-07','2023-01-07 07:42:54','2023-01-08 07:42:54','965',0.00,0.00,'965','2023-01-07 16:39:21','965','2023-01-07 16:39:43',10,0),('1','153',257875,'Daily shift','2023-01-07','2023-01-07 16:43:50','2023-01-08 16:43:50','965',0.00,0.00,'965','2023-01-07 22:02:01','965','2023-01-07 22:02:29',10,0),('1','153',257876,'Daily shift','2023-01-08','2023-01-08 07:38:06','2023-01-09 07:38:06','965',0.00,0.00,'965','2023-01-08 22:21:06','965','2023-01-08 22:22:24',10,0),('1','153',257877,'Daily shift','2023-01-09','2023-01-09 08:10:29','2023-01-10 08:10:29','965',0.00,0.00,'965','2023-01-09 23:30:04','965','2023-01-09 23:30:33',10,0),('1','153',257878,'Daily shift','2023-01-10','2023-01-10 09:22:38','2023-01-11 09:22:38','965',0.00,0.00,'965','2023-01-10 21:23:45','965','2023-01-10 21:24:11',10,0),('1','153',257879,'DAILY SHIFT','2023-01-11','2023-01-11 07:10:12','2023-01-12 07:10:12','965',0.00,0.00,'965','2023-01-11 21:42:39','965','2023-01-11 21:43:18',10,0),('1','153',257880,'Daily shift','2023-01-12','2023-01-12 07:36:20','2023-01-13 07:36:20','965',0.00,0.00,'965','2023-01-12 22:38:46','965','2023-01-12 22:39:18',10,0),('1','153',257881,'DAILY SHIFT','2023-01-13','2023-01-13 07:15:33','2023-01-14 07:15:33','965',0.00,0.00,'965','2023-01-13 21:11:15','965','2023-01-13 21:11:42',10,0),('1','153',257882,'Daily shift','2023-01-14','2023-01-14 07:47:24','2023-01-15 07:47:24','965',0.00,0.00,'965','2023-01-14 21:14:33','965','2023-01-14 21:15:29',10,0),('1','153',257883,'DAILY SHIFT','2023-01-15','2023-01-15 13:48:25','2023-01-16 13:48:25','965',0.00,0.00,'965','2023-01-15 21:40:31','965','2023-01-15 21:41:25',10,0),('1','153',257884,'Daily shift','2023-01-16','2023-01-16 08:26:54','2023-01-17 08:26:54','965',0.00,0.00,'965','2023-01-16 23:48:15','965','2023-01-16 23:48:40',10,0),('1','153',257885,'DAILY SHIFT','2023-01-17','2023-01-17 09:18:22','2023-01-18 09:18:22','965',0.00,0.00,'965','2023-01-17 21:12:08','965','2023-01-17 21:12:38',10,0),('1','153',257886,'Daily shift','2023-01-18','2023-01-18 08:03:08','2023-01-19 08:03:08','965',0.00,0.00,'965','2023-01-18 21:45:27','965','2023-01-18 21:45:53',10,0),('1','153',257887,'DAILY SHIFT','2023-01-19','2023-01-19 08:02:18','2023-01-20 08:02:18','965',0.00,0.00,'965','2023-01-19 21:09:12','965','2023-01-19 21:10:28',10,0),('1','153',257888,'DAILY SHIFT','2023-01-21','2023-01-21 13:08:05','2023-01-22 13:08:05','965',0.00,0.00,'965','2023-01-22 11:01:40','965','2023-01-22 11:02:05',10,0),('1','153',257889,'Daily shift','2023-01-22','2023-01-22 11:02:28','2023-01-23 11:02:28','965',0.00,0.00,'965','2023-01-22 22:25:50','965','2023-01-22 22:26:13',10,0),('1','153',257890,'DAILY SHIFT','2023-01-23','2023-01-23 07:25:24','2023-01-24 07:25:24','965',0.00,0.00,'965','2023-01-23 22:35:05','965','2023-01-23 22:35:34',10,0),('1','153',257891,'Daily shift','2023-01-24','2023-01-24 08:40:43','2023-01-25 08:40:43','965',0.00,0.00,'965','2023-01-24 21:17:57','965','2023-01-24 21:18:21',10,0),('1','153',257892,'Daily shift','2023-01-26','2023-01-26 08:43:16','2023-01-27 08:43:16','965',0.00,0.00,'965','2023-01-26 14:02:29','965','2023-01-26 14:02:51',10,0),('1','153',257893,'Daily shift','2023-01-26','2023-01-26 16:18:50','2023-01-27 16:18:50','965',0.00,0.00,'965','2023-01-26 22:13:09','965','2023-01-26 22:13:37',10,0),('1','153',257894,'DAILY SHIFT','2023-01-27','2023-01-27 07:08:53','2023-01-28 07:08:53','965',0.00,0.00,'965','2023-01-28 07:53:09','965','2023-01-28 07:53:40',10,0),('1','153',257895,'DAILY SHIFT','2023-01-28','2023-01-28 09:55:26','2023-01-29 09:55:26','965',0.00,0.00,'965','2023-01-28 21:36:28','965','2023-01-28 21:36:58',10,0),('1','153',257896,'Daily shift','2023-01-29','2023-01-29 12:38:15','2023-01-30 12:38:15','965',0.00,0.00,'965','2023-01-29 20:35:59','965','2023-01-29 20:36:26',10,0),('1','153',257897,'Daily shift','2023-01-30','2023-01-30 07:52:25','2023-01-31 07:52:25','965',0.00,0.00,'965','2023-01-30 22:56:34','965','2023-01-30 23:02:08',10,0),('1','153',257898,'DAILY SHIFT','2023-01-31','2023-01-31 07:19:49','2023-02-01 07:19:49','965',0.00,0.00,'965','2023-01-31 21:15:47','965','2023-01-31 21:17:26',10,0),('1','153',257899,'DAILY SHIFT','2023-02-01','2023-02-01 06:56:01','2023-02-02 06:56:01','965',0.00,0.00,'965','2023-02-01 21:29:23','965','2023-02-02 07:27:27',10,0),('1','153',257900,'DAILY SHIFT','2023-02-02','2023-02-02 07:28:33','2023-02-03 07:28:33','965',0.00,0.00,'965','2023-02-02 21:16:37','965','2023-02-02 21:17:53',10,0),('1','153',257901,'Daily shift','2023-02-03','2023-02-03 07:40:12','2023-02-04 07:40:12','965',0.00,0.00,'965','2023-02-03 21:51:21','965','2023-02-03 21:51:44',10,0),('1','153',257902,'DAILY SHIFT','2023-02-04','2023-02-04 15:12:09','2023-02-05 15:12:09','965',0.00,0.00,'965','2023-02-04 21:58:57','965','2023-02-04 21:59:21',10,0),('1','153',257903,'Daily shift','2023-02-05','2023-02-05 07:53:23','2023-02-06 07:53:23','965',0.00,0.00,'965','2023-02-05 20:34:33','965','2023-02-05 20:35:02',10,0),('1','153',257904,'DAILY SHIFT','2023-02-06','2023-02-06 07:14:34','2023-02-07 07:14:34','965',0.00,0.00,'965','2023-02-06 22:31:23','965','2023-02-06 22:31:50',10,0),('1','153',257905,'Daily shift the','2023-02-07','2023-02-07 07:47:27','2023-02-08 07:47:27','965',0.00,0.00,'965','2023-02-08 06:38:59','965','2023-02-08 06:39:26',10,0),('1','153',257906,'DAILY SHIFT','2023-02-08','2023-02-08 07:10:17','2023-02-09 07:10:17','965',0.00,0.00,'965','2023-02-09 07:11:09','965','2023-02-09 07:11:41',10,0),('1','153',257907,'Daily shift','2023-02-09','2023-02-09 07:33:01','2023-02-10 07:33:01','965',0.00,0.00,'965','2023-02-09 21:30:32','965','2023-02-09 21:30:59',10,0),('1','153',257908,'DAILY SHIFT','2023-02-10','2023-02-10 07:08:50','2023-02-11 07:08:50','965',0.00,0.00,'965','2023-02-11 06:15:38','965','2023-02-11 06:16:07',10,0),('1','153',257909,'Daily shift','2023-02-11','2023-02-11 07:42:12','2023-02-12 07:42:12','965',0.00,0.00,'965','2023-02-11 21:37:20','965','2023-02-11 21:37:50',10,0),('1','153',257910,'DAILY SHIFT','2023-02-12','2023-02-12 07:52:48','2023-02-13 07:52:48','965',0.00,0.00,'965','2023-02-12 22:31:21','965','2023-02-12 22:31:48',10,0),('1','153',257911,'Daily shift','2023-02-13','2023-02-13 07:47:57','2023-02-14 07:47:57','965',0.00,0.00,'965','2023-02-13 21:22:45','965','2023-02-13 21:23:13',10,0),('1','153',257912,'DAILY SHIFT','2023-02-14','2023-02-14 07:07:08','2023-02-15 07:07:08','965',0.00,0.00,'965','2023-02-14 21:31:41','965','2023-02-14 21:32:35',10,0),('1','153',257913,'Daily shift','2023-02-15','2023-02-15 07:54:28','2023-02-16 07:54:28','965',0.00,0.00,'965','2023-02-15 21:30:40','965','2023-02-15 21:31:07',10,0),('1','153',257914,'DAILY SHIFT','2023-02-16','2023-02-16 07:17:34','2023-02-17 07:17:34','965',0.00,0.00,'965','2023-02-16 13:42:13','965','2023-02-16 13:42:40',10,0),('1','153',257915,'Daily shift','2023-02-16','2023-02-16 16:44:44','2023-02-17 16:44:44','965',0.00,0.00,'965','2023-02-16 21:29:51','965','2023-02-16 21:30:21',10,0),('1','153',257916,'Daily shift','2023-02-17','2023-02-17 07:41:15','2023-02-18 07:41:15','965',0.00,0.00,'965','2023-02-17 22:08:42','965','2023-02-17 22:09:09',10,0),('1','153',257917,'DAILY SHIFT','2023-02-18','2023-02-18 07:14:02','2023-02-19 07:14:02','965',0.00,0.00,'965','2023-02-18 22:09:20','965','2023-02-18 22:09:46',10,0),('1','153',257918,'Daily shift','2023-02-19','2023-02-19 07:32:05','2023-02-20 07:32:05','965',0.00,0.00,'965','2023-02-19 22:35:19','965','2023-02-19 22:35:47',10,0),('1','153',257919,'DAILY SHIFT','2023-02-20','2023-02-20 07:14:45','2023-02-21 07:14:45','965',0.00,0.00,'965','2023-02-20 12:45:39','965','2023-02-20 12:46:03',10,0),('1','153',257920,'Daily shift','2023-02-20','2023-02-20 12:46:30','2023-02-21 12:46:30','965',0.00,0.00,'965','2023-02-20 20:34:47','965','2023-02-20 20:35:26',10,0),('1','153',257921,'Daily shift the','2023-02-21','2023-02-21 07:43:37','2023-02-22 07:43:37','965',0.00,0.00,'965','2023-02-21 22:29:14','965','2023-02-21 22:29:39',10,0),('1','153',257922,'DAILY SHIFT','2023-02-22','2023-02-22 07:16:18','2023-02-23 07:16:18','965',0.00,0.00,'965','2023-02-22 22:52:25','965','2023-02-22 22:52:55',10,0),('1','153',257923,'Daily shift','2023-02-23','2023-02-23 07:39:06','2023-02-24 07:39:06','965',0.00,0.00,'965','2023-02-23 23:14:05','965','2023-02-23 23:14:47',10,0),('1','153',257924,'DAILY SHIFT','2023-02-24','2023-02-24 07:03:54','2023-02-25 07:03:54','965',0.00,0.00,'965','2023-02-24 14:00:54','965','2023-02-24 14:01:18',10,0),('1','153',257925,'Daily shift','2023-02-24','2023-02-24 15:36:46','2023-02-25 15:36:46','965',0.00,0.00,'965','2023-02-24 22:23:27','965','2023-02-24 22:23:55',10,0),('1','153',257926,'Daily shift','2023-02-26','2023-02-26 08:02:14','2023-02-27 08:02:14','965',0.00,0.00,'965','2023-02-26 21:12:39','965','2023-02-26 21:13:46',10,0),('1','153',257927,'DAILY SHIFT','2023-02-27','2023-02-27 07:20:26','2023-02-28 07:20:26','965',0.00,0.00,'965','2023-02-27 22:20:15','965','2023-02-27 22:20:39',10,0),('1','153',257928,'Daily shift','2023-02-28','2023-02-28 07:41:28','2023-03-01 07:41:28','965',0.00,0.00,'965','2023-02-28 22:18:44','965','2023-02-28 22:20:13',10,0),('1','153',257929,'DAILY SHIFT','2023-03-01','2023-03-01 07:11:29','2023-03-02 07:11:29','965',0.00,0.00,'965','2023-03-01 21:37:35','965','2023-03-01 21:38:02',10,0),('1','153',257930,'Daily shift','2023-03-02','2023-03-02 07:55:51','2023-03-03 07:55:51','965',0.00,0.00,'965','2023-03-02 23:56:38','965','2023-03-02 23:57:09',10,0),('1','153',257931,'DAILY SHIFT','2023-03-03','2023-03-03 07:18:19','2023-03-04 07:18:19','965',0.00,0.00,'965','2023-03-03 22:07:27','965','2023-03-03 22:07:52',10,0),('1','153',257932,'Daily shift','2023-03-04','2023-03-04 07:40:23','2023-03-05 07:40:23','965',0.00,0.00,'965','2023-03-04 21:45:05','965','2023-03-04 21:45:59',10,0),('1','153',257933,'DAILY SHIFT','2023-03-05','2023-03-05 07:06:27','2023-03-06 07:06:27','965',0.00,0.00,'965','2023-03-05 21:15:31','965','2023-03-05 21:16:15',10,0),('1','153',257934,'Daily shift','2023-03-06','2023-03-06 07:47:17','2023-03-07 07:47:17','965',0.00,0.00,'965','2023-03-06 22:28:20','965','2023-03-06 22:28:50',10,0),('1','153',257935,'DAILY SHIFT','2023-03-07','2023-03-07 07:45:52','2023-03-08 07:45:52','965',0.00,0.00,'965','2023-03-07 21:16:29','965','2023-03-07 21:16:54',10,0),('1','153',257936,'Daily shift','2023-03-08','2023-03-08 07:17:12','2023-03-09 07:17:12','965',0.00,0.00,'965','2023-03-08 14:00:10','965','2023-03-08 14:01:06',10,0),('1','153',257937,'Daily shift','2023-03-08','2023-03-08 14:01:46','2023-03-09 14:01:46','965',0.00,0.00,'965','2023-03-08 21:31:42','965','2023-03-08 21:32:08',10,0),('1','153',257938,'DAILY SHIFT','2023-03-09','2023-03-09 07:12:48','2023-03-10 07:12:48','965',0.00,0.00,'965','2023-03-09 23:50:40','965','2023-03-09 23:51:07',10,0),('1','153',257939,'Daily shift','2023-03-10','2023-03-10 07:30:28','2023-03-11 07:30:28','965',0.00,0.00,'965','2023-03-11 06:16:45','965','2023-03-11 06:17:12',10,0),('1','153',257940,'DAILY SHIFT','2023-03-11','2023-03-11 07:47:18','2023-03-12 07:47:18','965',0.00,0.00,'965','2023-03-11 23:40:08','965','2023-03-11 23:40:35',10,0),('1','153',257941,'Daily shift','2023-03-12','2023-03-12 07:42:24','2023-03-13 07:42:24','965',0.00,0.00,'965','2023-03-12 21:57:10','965','2023-03-12 22:09:01',10,0),('1','153',257942,'DAILY SHIFT','2023-03-13','2023-03-13 07:37:57','2023-03-14 07:37:57','965',0.00,0.00,'965','2023-03-13 21:32:52','965','2023-03-13 21:33:16',10,0),('1','153',257943,'Daily shift','2023-03-14','2023-03-14 07:14:38','2023-03-15 07:14:38','965',0.00,0.00,'965','2023-03-14 22:07:22','965','2023-03-14 22:07:51',10,0),('1','153',257944,'DAILY SHIFT','2023-03-15','2023-03-15 07:10:34','2023-03-16 07:10:34','965',0.00,0.00,'965','2023-03-15 22:33:54','965','2023-03-15 22:34:21',10,0),('1','153',257945,'Daily shift','2023-03-16','2023-03-16 07:29:54','2023-03-17 07:29:54','965',0.00,0.00,'965','2023-03-16 22:47:23','965','2023-03-16 22:47:47',10,0),('1','153',257946,'DAILY SHIFT','2023-03-17','2023-03-17 07:12:08','2023-03-18 07:12:08','965',0.00,0.00,'965','2023-03-17 22:39:15','965','2023-03-17 22:40:09',10,0),('1','153',257947,'Daily shift','2023-03-19','2023-03-19 09:07:09','2023-03-20 09:07:09','965',0.00,0.00,'965','2023-03-20 02:37:34','965','2023-03-20 02:37:59',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905304 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','153','763','144096',2883978,'2132','321',1236433.71,1237579.65,0.00,0.00,1145.94,245231.16,0.00,0.00,0.00),('1','153','763','144096',2883979,'2133','321',349213.14,350385.56,0.00,0.00,1172.42,293713.10,0.00,0.00,0.00),('1','153','763','144261',2887082,'2132','321',1237579.65,1239405.89,0.00,0.00,1826.24,390815.36,0.00,0.00,0.00),('1','153','763','144261',2887083,'2133','321',350385.56,352540.01,0.00,0.00,2154.45,531907.98,0.00,0.00,0.00),('1','153','763','144347',2888725,'2132','321',1239405.89,1240232.35,0.00,0.00,826.46,176862.44,0.00,0.00,0.00),('1','153','763','144347',2888726,'2133','321',352540.01,353163.18,0.00,0.00,623.17,159531.52,0.00,0.00,0.00),('1','153','763','144359',2888963,'2132','321',1240232.35,1242967.32,0.00,0.00,2734.97,585283.58,0.00,0.00,0.00),('1','153','763','144359',2888964,'2133','321',353163.18,355239.83,0.00,0.00,2076.65,526634.06,0.00,0.00,0.00),('1','153','763','144452',2890713,'2132','321',1242967.32,1243085.28,0.00,0.00,117.96,25997.76,0.00,0.00,0.00),('1','153','763','144452',2890714,'2133','321',355239.83,355331.59,0.00,0.00,91.76,23490.56,0.00,0.00,0.00),('1','153','763','144453',2890715,'2132','321',1243085.28,1244811.10,0.00,0.00,1725.82,370254.52,0.00,0.00,0.00),('1','153','763','144453',2890716,'2133','321',355331.59,357696.59,0.00,0.00,2365.00,605440.00,0.00,0.00,0.00),('1','153','763','144533',2892265,'2132','321',1244811.10,1244949.73,0.00,0.00,138.63,35489.28,0.00,0.00,0.00),('1','153','763','144533',2892266,'2133','321',357696.59,357797.45,0.00,0.00,100.86,25820.16,0.00,0.00,0.00),('1','153','763','144539',2892391,'2132','321',1244949.73,1247568.41,0.00,0.00,2618.68,662822.08,0.00,0.00,0.00),('1','153','763','144539',2892392,'2133','321',357797.45,361001.29,0.00,0.00,3203.84,685621.76,0.00,0.00,0.00),('1','153','763','144588',2893452,'2132','321',1247568.41,1247802.66,0.00,0.00,234.25,59968.00,0.00,0.00,0.00),('1','153','763','144588',2893453,'2133','321',361001.29,361015.72,0.00,0.00,14.43,3169.08,0.00,0.00,0.00),('1','153','763','144589',2893454,'2132','321',1247802.66,1251192.33,0.00,0.00,3389.67,786605.64,0.00,0.00,0.00),('1','153','763','144589',2893455,'2133','321',361015.72,361600.96,0.00,0.00,585.24,149821.44,0.00,0.00,0.00),('1','153','763','144590',2893456,'2132','321',1251192.33,1252475.05,0.00,0.00,1282.72,274502.08,0.00,0.00,0.00),('1','153','763','144590',2893457,'2133','321',361600.96,362636.87,0.00,0.00,1035.91,264265.60,0.00,0.00,0.00),('1','153','763','144629',2894210,'2132','321',1252475.05,1253870.87,0.00,0.00,1395.82,298705.48,0.00,0.00,0.00),('1','153','763','144629',2894211,'2133','321',362636.87,363781.33,0.00,0.00,1144.46,289122.80,0.00,0.00,0.00),('1','153','763','144666',2894803,'2132','321',1253870.87,1254705.07,0.00,0.00,834.20,200490.40,0.00,0.00,0.00),('1','153','763','144666',2894804,'2133','321',363781.33,365429.83,0.00,0.00,1648.50,422016.00,0.00,0.00,0.00),('1','153','763','144674',2894937,'2132','321',1254705.07,1255057.44,0.00,0.00,352.37,90206.72,0.00,0.00,0.00),('1','153','763','144674',2894938,'2133','321',365429.83,366337.42,0.00,0.00,907.59,225095.84,0.00,0.00,0.00),('1','153','763','144727',2896015,'2132','321',1255057.44,1255867.62,0.00,0.00,810.18,196603.68,0.00,0.00,0.00),('1','153','763','144727',2896016,'2133','321',366337.42,367173.34,0.00,0.00,835.92,213995.52,0.00,0.00,0.00),('1','153','763','144728',2896017,'2132','321',1255867.62,1256714.42,0.00,0.00,846.80,203232.00,0.00,0.00,0.00),('1','153','763','144728',2896018,'2133','321',367173.34,368285.63,0.00,0.00,1112.29,284442.24,0.00,0.00,0.00),('1','153','763','144736',2896145,'2132','321',1256714.42,1257095.80,0.00,0.00,381.38,94791.68,0.00,0.00,0.00),('1','153','763','144736',2896146,'2133','321',368285.63,368698.70,0.00,0.00,413.07,105745.92,0.00,0.00,0.00),('1','153','763','144741',2896232,'2132','321',1257095.80,1258721.06,0.00,0.00,1625.26,377360.32,0.00,0.00,0.00),('1','153','763','144741',2896233,'2133','321',368698.70,370800.50,0.00,0.00,2101.80,579230.20,0.00,0.00,0.00),('1','153','763','144759',2896516,'2132','321',1258721.06,1259423.86,0.00,0.00,702.80,170729.60,0.00,0.00,0.00),('1','153','763','144759',2896517,'2133','321',370800.50,371822.84,0.00,0.00,1022.34,278076.48,0.00,0.00,0.00),('1','153','763','144772',2896759,'2132','321',1259423.86,1260543.03,0.00,0.00,1119.17,259647.44,0.00,0.00,0.00),('1','153','763','144772',2896760,'2133','321',371822.84,372950.54,0.00,0.00,1127.70,296082.80,0.00,0.00,0.00),('1','153','763','144778',2896851,'2132','321',1260543.03,1261972.02,0.00,0.00,1428.99,388685.28,0.00,0.00,0.00),('1','153','763','144778',2896852,'2133','321',372950.54,374813.76,0.00,0.00,1863.22,447583.44,0.00,0.00,0.00),('1','153','763','144798',2897206,'2132','321',1261972.02,1262386.27,0.00,0.00,414.25,96106.00,0.00,0.00,0.00),('1','153','763','144798',2897207,'2133','321',374813.76,375185.14,0.00,0.00,371.38,100639.36,0.00,0.00,0.00),('1','153','763','144945',2900135,'2132','321',1262386.27,1263926.98,0.00,0.00,1540.71,357444.72,0.00,0.00,0.00),('1','153','763','144945',2900136,'2133','321',375185.14,376625.91,0.00,0.00,1440.77,380455.44,0.00,0.00,0.00),('1','153','763','144956',2900351,'2132','321',1263926.98,1265653.50,0.00,0.00,1726.52,406247.04,0.00,0.00,0.00),('1','153','763','144956',2900352,'2133','321',376625.91,378178.54,0.00,0.00,1552.63,422315.36,0.00,0.00,0.00),('1','153','763','145013',2901356,'2132','321',1265653.50,1265724.62,0.00,0.00,71.12,19344.64,0.00,0.00,0.00),('1','153','763','145013',2901357,'2133','321',378178.54,378253.98,0.00,0.00,75.44,20519.68,0.00,0.00,0.00),('1','153','763','145022',2901486,'2132','321',1265724.62,1267739.10,0.00,0.00,2014.48,463330.40,0.00,0.00,0.00),('1','153','763','145022',2901487,'2133','321',378253.98,380274.90,0.00,0.00,2020.92,535942.80,0.00,0.00,0.00),('1','153','763','145029',2901583,'2132','321',1267739.10,1267740.39,0.00,0.00,1.29,350.88,0.00,0.00,0.00),('1','153','763','145029',2901584,'2133','321',380274.90,380281.84,0.00,0.00,6.94,1887.68,0.00,0.00,0.00),('1','153','763','145239',2905906,'2132','321',1267740.39,1269785.59,0.00,0.00,2045.20,472771.54,0.00,0.00,0.00),('1','153','763','145239',2905907,'2133','321',380281.84,381800.22,0.00,0.00,1518.38,412999.36,0.00,0.00,0.00),('1','153','763','145240',2905908,'2132','321',1269785.59,1271038.79,0.00,0.00,1253.20,288236.00,0.00,0.00,0.00),('1','153','763','145240',2905909,'2133','321',381800.22,383273.24,0.00,0.00,1473.02,398389.66,0.00,0.00,0.00),('1','153','763','145303',2907089,'2132','321',1271038.79,1271490.63,0.00,0.00,451.84,104000.48,0.00,0.00,0.00),('1','153','763','145303',2907090,'2133','321',383273.24,383797.40,0.00,0.00,524.16,142571.52,0.00,0.00,0.00),('1','153','763','145308',2907201,'2132','321',1271490.63,1273741.78,0.00,0.00,2251.15,517764.50,0.00,0.00,0.00),('1','153','763','145308',2907202,'2133','321',383797.40,386288.03,0.00,0.00,2490.63,652383.66,0.00,0.00,0.00),('1','153','763','145313',2907265,'2132','321',1273741.78,1274027.31,0.00,0.00,285.53,65671.90,0.00,0.00,0.00),('1','153','763','145313',2907266,'2133','321',386288.03,386579.16,0.00,0.00,291.13,74379.62,0.00,0.00,0.00),('1','153','763','145316',2907286,'2132','321',1274027.31,1275836.12,0.00,0.00,1808.81,416026.30,0.00,0.00,0.00),('1','153','763','145316',2907287,'2133','321',386579.16,388177.91,0.00,0.00,1598.75,420619.48,0.00,0.00,0.00),('1','153','763','145318',2907305,'2132','321',1275836.12,1277509.42,0.00,0.00,1673.30,386971.18,0.00,0.00,0.00),('1','153','763','145318',2907306,'2133','321',388177.91,389407.99,0.00,0.00,1230.08,334581.76,0.00,0.00,0.00),('1','153','763','145362',2908250,'2132','321',1277509.42,1277873.41,0.00,0.00,363.99,83717.70,0.00,0.00,0.00),('1','153','763','145362',2908251,'2133','321',389407.99,389813.51,0.00,0.00,405.52,108915.02,0.00,0.00,0.00),('1','153','763','145364',2908266,'2132','321',1277873.41,1279469.92,0.00,0.00,1596.51,367197.30,0.00,0.00,0.00),('1','153','763','145364',2908267,'2133','321',389813.51,391412.45,0.00,0.00,1598.94,419287.68,0.00,0.00,0.00),('1','153','763','145383',2908737,'2132','321',1279469.92,1279769.31,0.00,0.00,299.39,68859.70,0.00,0.00,0.00),('1','153','763','145383',2908738,'2133','321',391412.45,391707.76,0.00,0.00,295.31,80324.32,0.00,0.00,0.00),('1','153','763','145389',2908870,'2132','321',1279769.31,1281918.95,0.00,0.00,2149.64,494417.20,0.00,0.00,0.00),('1','153','763','145389',2908871,'2133','321',391707.76,393627.49,0.00,0.00,1919.73,517484.40,0.00,0.00,0.00),('1','153','763','145394',2908940,'2132','321',1281918.95,1282534.33,0.00,0.00,615.38,141537.40,0.00,0.00,0.00),('1','153','763','145394',2908941,'2133','321',393627.49,394627.81,0.00,0.00,1000.32,252051.92,0.00,0.00,0.00),('1','153','763','145492',2910907,'2132','321',1282534.33,1283376.55,0.00,0.00,842.22,193710.60,0.00,0.00,0.00),('1','153','763','145492',2910908,'2133','321',394627.81,395620.59,0.00,0.00,992.78,252930.20,0.00,0.00,0.00),('1','153','763','145496',2910948,'2132','321',1283376.55,1285674.17,0.00,0.00,2297.62,528452.60,0.00,0.00,0.00),('1','153','763','145496',2910949,'2133','321',395620.59,397844.83,0.00,0.00,2224.24,569405.44,0.00,0.00,0.00),('1','153','763','145588',2912698,'2132','321',1285674.17,1285822.00,0.00,0.00,147.83,34000.90,0.00,0.00,0.00),('1','153','763','145588',2912699,'2133','321',397844.83,397990.87,0.00,0.00,146.04,35769.82,0.00,0.00,0.00),('1','153','763','146001',2920856,'2132','321',1285822.00,1288489.79,0.00,0.00,2667.79,613591.70,0.00,0.00,0.00),('1','153','763','146001',2920857,'2133','321',397990.87,401116.92,0.00,0.00,3126.05,782744.54,0.00,0.00,0.00),('1','153','763','146022',2921147,'2132','321',1288489.79,1288640.04,0.00,0.00,150.25,35665.10,0.00,0.00,0.00),('1','153','763','146022',2921148,'2133','321',401116.92,401304.30,0.00,0.00,187.38,47969.28,0.00,0.00,0.00),('1','153','763','146079',2922357,'2132','321',1288640.04,1290576.36,0.00,0.00,1936.32,446967.68,0.00,0.00,0.00),('1','153','763','146079',2922358,'2133','321',401304.30,403089.90,0.00,0.00,1785.60,457113.60,0.00,0.00,0.00),('1','153','763','146080',2922359,'2132','321',1290576.36,1290636.48,0.00,0.00,60.12,15390.72,0.00,0.00,0.00),('1','153','763','146080',2922360,'2133','321',403089.90,403093.02,0.00,0.00,3.12,798.72,0.00,0.00,0.00),('1','153','763','146081',2922361,'2132','321',1290636.48,1292927.33,0.00,0.00,2290.85,528022.60,0.00,0.00,0.00),('1','153','763','146081',2922362,'2133','321',403093.02,405205.06,0.00,0.00,2112.04,540682.24,0.00,0.00,0.00),('1','153','763','146086',2922407,'2132','321',1292927.33,1293729.50,0.00,0.00,802.17,185605.92,0.00,0.00,0.00),('1','153','763','146086',2922408,'2133','321',405205.06,406321.92,0.00,0.00,1116.86,285916.16,0.00,0.00,0.00),('1','153','763','146461',2930162,'2132','321',1293729.50,1295880.44,0.00,0.00,2150.94,498042.64,0.00,0.00,0.00),('1','153','763','146461',2930163,'2133','321',406321.92,408216.85,0.00,0.00,1894.93,485102.08,0.00,0.00,0.00),('1','153','763','146543',2931874,'2132','321',1295880.44,1296922.66,0.00,0.00,1042.22,242981.92,0.00,0.00,0.00),('1','153','763','146543',2931875,'2133','321',408216.85,409419.43,0.00,0.00,1202.58,307860.48,0.00,0.00,0.00),('1','153','763','146556',2932094,'2132','321',1296922.66,1298995.18,0.00,0.00,2072.52,494131.32,0.00,0.00,0.00),('1','153','763','146556',2932095,'2133','321',409419.43,411715.04,0.00,0.00,2295.61,587676.16,0.00,0.00,0.00),('1','153','763','146566',2932245,'2132','321',1298995.18,1299984.36,0.00,0.00,989.18,227511.40,0.00,0.00,0.00),('1','153','763','146566',2932246,'2133','321',411715.04,412624.54,0.00,0.00,909.50,230037.00,0.00,0.00,0.00),('1','153','763','146725',2935381,'2132','321',1299984.36,1301185.55,0.00,0.00,1201.19,276273.70,0.00,0.00,0.00),('1','153','763','146725',2935382,'2133','321',412624.54,413716.94,0.00,0.00,1092.40,271110.54,0.00,0.00,0.00),('1','153','763','146744',2935815,'2132','321',1301185.55,1302198.30,0.00,0.00,1012.75,232932.50,0.00,0.00,0.00),('1','153','763','146744',2935816,'2133','321',413716.94,414663.11,0.00,0.00,946.17,232911.52,0.00,0.00,0.00),('1','153','763','146850',2937751,'2132','321',1302198.30,1304241.42,0.00,0.00,2043.12,469917.60,0.00,0.00,0.00),('1','153','763','146850',2937752,'2133','321',414663.11,417189.71,0.00,0.00,2526.60,616258.56,0.00,0.00,0.00),('1','153','763','147080',2941556,'2132','321',1304241.42,1305022.71,0.00,0.00,781.29,182367.42,0.00,0.00,0.00),('1','153','763','147080',2941557,'2133','321',417189.71,418158.71,0.00,0.00,969.00,248064.00,0.00,0.00,0.00),('1','153','763','147116',2941805,'2132','321',1305022.71,1306031.53,0.00,0.00,1008.82,232028.60,0.00,0.00,0.00),('1','153','763','147116',2941806,'2133','321',418158.71,419002.28,0.00,0.00,843.57,201224.92,0.00,0.00,0.00),('1','153','763','147117',2941807,'2132','321',1306031.53,1307856.55,0.00,0.00,1825.02,420766.26,0.00,0.00,0.00),('1','153','763','147117',2941808,'2133','321',419002.28,421076.73,0.00,0.00,2074.45,531059.20,0.00,0.00,0.00),('1','153','763','147157',2942369,'2132','321',1307856.55,1308031.14,0.00,0.00,174.59,40173.90,0.00,0.00,0.00),('1','153','763','147157',2942370,'2133','321',421076.73,421450.42,0.00,0.00,373.69,95664.64,0.00,0.00,0.00),('1','153','763','147173',2942479,'2132','321',1308031.14,1309646.79,0.00,0.00,1615.65,374050.00,0.00,0.00,0.00),('1','153','763','147173',2942480,'2133','321',421450.42,422982.32,0.00,0.00,1531.90,392166.40,0.00,0.00,0.00),('1','153','763','147193',2942743,'2132','321',1309646.79,1311402.94,0.00,0.00,1756.15,403914.50,0.00,0.00,0.00),('1','153','763','147193',2942744,'2133','321',422982.32,424402.48,0.00,0.00,1420.16,361552.46,0.00,0.00,0.00),('1','153','763','147610',2949778,'2132','321',1311402.94,1311894.45,0.00,0.00,491.51,115049.56,0.00,0.00,0.00),('1','153','763','147610',2949779,'2133','321',424402.48,424869.63,0.00,0.00,467.15,119590.40,0.00,0.00,0.00),('1','153','763','147621',2949965,'2132','321',1311894.45,1313308.22,0.00,0.00,1413.77,325167.10,0.00,0.00,0.00),('1','153','763','147621',2949966,'2133','321',424869.63,426544.93,0.00,0.00,1675.30,428876.80,0.00,0.00,0.00),('1','153','763','147626',2950078,'2132','321',1313308.22,1313308.79,0.00,0.00,0.57,145.92,0.00,0.00,0.00),('1','153','763','147626',2950079,'2133','321',426544.93,426979.82,0.00,0.00,434.89,111193.00,0.00,0.00,0.00),('1','153','763','147636',2950274,'2132','321',1313308.79,1314743.11,0.00,0.00,1434.32,330586.50,0.00,0.00,0.00),('1','153','763','147636',2950275,'2133','321',426979.82,428133.50,0.00,0.00,1153.68,295342.08,0.00,0.00,0.00),('1','153','763','147640',2950346,'2132','321',1314743.11,1315857.18,0.00,0.00,1114.07,256236.10,0.00,0.00,0.00),('1','153','763','147640',2950347,'2133','321',428133.50,429350.70,0.00,0.00,1217.20,307348.82,0.00,0.00,0.00),('1','153','763','147650',2950532,'2132','321',1315857.18,1316698.66,0.00,0.00,841.48,193540.40,0.00,0.00,0.00),('1','153','763','147650',2950533,'2133','321',429350.70,429946.70,0.00,0.00,596.00,152576.00,0.00,0.00,0.00),('1','153','763','147660',2950716,'2132','321',1316698.66,1318690.92,0.00,0.00,1992.26,459577.52,0.00,0.00,0.00),('1','153','763','147660',2950717,'2133','321',429946.70,431550.08,0.00,0.00,1603.38,410465.28,0.00,0.00,0.00),('1','153','763','147692',2951119,'2132','321',1318690.92,1320190.31,0.00,0.00,1499.39,344859.70,0.00,0.00,0.00),('1','153','763','147692',2951120,'2133','321',431550.08,432782.96,0.00,0.00,1232.88,310297.42,0.00,0.00,0.00),('1','153','763','147693',2951121,'2132','321',1320190.31,1321077.14,0.00,0.00,886.83,204538.48,0.00,0.00,0.00),('1','153','763','147693',2951122,'2133','321',432782.96,433617.16,0.00,0.00,834.20,213555.20,0.00,0.00,0.00),('1','153','763','147898',2954903,'2132','321',1321077.14,1323309.45,0.00,0.00,2232.31,513431.30,0.00,0.00,0.00),('1','153','763','147898',2954904,'2133','321',433617.16,435922.70,0.00,0.00,2305.54,583666.76,0.00,0.00,0.00),('1','153','763','147902',2954944,'2132','321',1323309.45,1323317.45,0.00,0.00,8.00,1840.00,0.00,0.00,0.00),('1','153','763','147902',2954945,'2133','321',435922.70,435988.66,0.00,0.00,65.96,16885.76,0.00,0.00,0.00),('1','153','763','147905',2954988,'2132','321',1323317.45,1325201.85,0.00,0.00,1884.40,433412.00,0.00,0.00,0.00),('1','153','763','147905',2954989,'2133','321',435988.66,438208.58,0.00,0.00,2219.92,557444.78,0.00,0.00,0.00),('1','153','763','147914',2955157,'2132','321',1325201.85,1325616.52,0.00,0.00,414.67,95374.10,0.00,0.00,0.00),('1','153','763','147914',2955158,'2133','321',438208.58,438830.73,0.00,0.00,622.15,157800.62,0.00,0.00,0.00),('1','153','763','147921',2955246,'2132','321',1325616.52,1326483.31,0.00,0.00,866.79,199361.70,0.00,0.00,0.00),('1','153','763','147921',2955247,'2133','321',438830.73,440032.72,0.00,0.00,1201.99,302174.82,0.00,0.00,0.00),('1','153','763','147935',2955434,'2132','321',1326483.31,1328110.07,0.00,0.00,1626.76,374154.80,0.00,0.00,0.00),('1','153','763','147935',2955435,'2133','321',440032.72,442166.37,0.00,0.00,2133.65,541413.76,0.00,0.00,0.00),('1','153','763','147990',2956334,'2132','321',1328110.07,1328410.33,0.00,0.00,300.26,69059.80,0.00,0.00,0.00),('1','153','763','147990',2956335,'2133','321',442166.37,442340.09,0.00,0.00,173.72,42718.88,0.00,0.00,0.00),('1','153','763','147992',2956337,'2132','321',1328410.33,1330712.31,0.00,0.00,2301.98,529455.40,0.00,0.00,0.00),('1','153','763','147992',2956338,'2133','321',442340.09,444898.07,0.00,0.00,2557.98,644408.56,0.00,0.00,0.00),('1','153','763','147993',2956339,'2132','321',1330712.31,1331546.92,0.00,0.00,834.61,191960.30,0.00,0.00,0.00),('1','153','763','147993',2956340,'2133','321',444898.07,445529.25,0.00,0.00,631.18,160521.54,0.00,0.00,0.00),('1','153','763','147995',2956342,'2132','321',1331546.92,1333072.41,0.00,0.00,1525.49,350862.70,0.00,0.00,0.00),('1','153','763','147995',2956343,'2133','321',445529.25,447340.59,0.00,0.00,1811.34,458629.40,0.00,0.00,0.00),('1','153','763','148018',2956662,'2132','321',1333072.41,1334665.87,0.00,0.00,1593.46,366495.80,0.00,0.00,0.00),('1','153','763','148018',2956663,'2133','321',447340.59,448694.79,0.00,0.00,1354.20,338641.20,0.00,0.00,0.00),('1','153','763','148060',2957498,'2132','321',1334665.87,1335575.26,0.00,0.00,909.39,209159.70,0.00,0.00,0.00),('1','153','763','148060',2957499,'2133','321',448694.79,449615.66,0.00,0.00,920.87,233766.72,0.00,0.00,0.00),('1','153','763','148064',2957556,'2132','321',1335575.26,1336402.39,0.00,0.00,827.13,190239.90,0.00,0.00,0.00),('1','153','763','148064',2957557,'2133','321',449615.66,450680.98,0.00,0.00,1065.32,272331.92,0.00,0.00,0.00),('1','153','763','148084',2957892,'2132','321',1336402.39,1337235.34,0.00,0.00,832.95,191578.50,0.00,0.00,0.00),('1','153','763','148084',2957893,'2133','321',450680.98,451746.41,0.00,0.00,1065.43,263716.38,0.00,0.00,0.00),('1','153','763','148086',2957924,'2132','321',1337235.34,1339016.56,0.00,0.00,1781.22,409680.60,0.00,0.00,0.00),('1','153','763','148086',2957925,'2133','321',451746.41,454001.97,0.00,0.00,2255.56,571079.36,0.00,0.00,0.00),('1','153','763','148471',2964705,'2132','321',1339016.56,1339268.12,0.00,0.00,251.56,58817.16,0.00,0.00,0.00),('1','153','763','148471',2964706,'2133','321',454001.97,454123.76,0.00,0.00,121.79,31178.24,0.00,0.00,0.00),('1','153','763','148475',2964772,'2132','321',1339268.12,1340632.87,0.00,0.00,1364.75,313892.50,0.00,0.00,0.00),('1','153','763','148475',2964773,'2133','321',454123.76,455444.18,0.00,0.00,1320.42,332035.04,0.00,0.00,0.00),('1','153','763','148478',2964838,'2132','321',1340632.87,1342138.05,0.00,0.00,1505.18,346191.40,0.00,0.00,0.00),('1','153','763','148478',2964839,'2133','321',455444.18,457472.32,0.00,0.00,2028.14,513998.12,0.00,0.00,0.00),('1','153','763','148487',2964990,'2132','321',1342138.05,1344936.34,0.00,0.00,2798.29,643606.70,0.00,0.00,0.00),('1','153','763','148487',2964991,'2133','321',457472.32,459780.21,0.00,0.00,2307.89,585627.38,0.00,0.00,0.00),('1','153','763','148581',2966613,'2132','321',1344936.34,1345635.54,0.00,0.00,699.20,160816.00,0.00,0.00,0.00),('1','153','763','148581',2966614,'2133','321',459780.21,460333.74,0.00,0.00,553.53,140557.86,0.00,0.00,0.00),('1','153','763','148672',2968090,'2132','321',1345635.54,1347299.52,0.00,0.00,1663.98,382715.40,0.00,0.00,0.00),('1','153','763','148672',2968091,'2133','321',460333.74,462021.05,0.00,0.00,1687.31,424179.96,0.00,0.00,0.00),('1','153','763','148731',2969158,'2132','321',1347299.52,1347674.34,0.00,0.00,374.82,86809.72,0.00,0.00,0.00),('1','153','763','148731',2969159,'2133','321',462021.05,462474.35,0.00,0.00,453.30,116044.80,0.00,0.00,0.00),('1','153','763','148814',2970296,'2132','321',1347674.34,1349610.97,0.00,0.00,1936.63,445424.90,0.00,0.00,0.00),('1','153','763','148814',2970297,'2133','321',462474.35,463952.21,0.00,0.00,1477.86,376726.14,0.00,0.00,0.00),('1','153','763','148871',2971424,'2132','321',1349610.97,1351132.49,0.00,0.00,1521.52,349949.60,0.00,0.00,0.00),('1','153','763','148871',2971425,'2133','321',463952.21,465383.79,0.00,0.00,1431.58,358978.28,0.00,0.00,0.00),('1','153','763','148937',2972845,'2132','321',1351132.49,1351933.59,0.00,0.00,801.10,184253.00,0.00,0.00,0.00),('1','153','763','148937',2972846,'2133','321',465383.79,466065.19,0.00,0.00,681.40,174438.40,0.00,0.00,0.00),('1','153','763','149152',2976922,'2132','321',1351933.59,1354418.84,0.00,0.00,2485.25,571607.50,0.00,0.00,0.00),('1','153','763','149152',2976923,'2133','321',466065.19,468440.48,0.00,0.00,2375.29,599520.24,0.00,0.00,0.00),('1','153','763','149310',2979660,'2132','321',1354418.84,1356418.63,0.00,0.00,1999.79,459951.70,0.00,0.00,0.00),('1','153','763','149310',2979661,'2133','321',468440.48,470624.04,0.00,0.00,2183.56,550866.62,0.00,0.00,0.00),('1','153','763','149478',2982424,'2132','321',1356418.63,1357613.25,0.00,0.00,1194.62,275610.20,0.00,0.00,0.00),('1','153','763','149478',2982425,'2133','321',470624.04,471585.04,0.00,0.00,961.00,246016.00,0.00,0.00,0.00),('1','153','763','149479',2982426,'2132','321',1357613.25,1359146.86,0.00,0.00,1533.61,352730.30,0.00,0.00,0.00),('1','153','763','149479',2982427,'2133','321',471585.04,472654.88,0.00,0.00,1069.84,272641.70,0.00,0.00,0.00),('1','153','763','149603',2984599,'2132','321',1359146.86,1359755.40,0.00,0.00,608.54,145409.64,0.00,0.00,0.00),('1','153','763','149603',2984600,'2133','321',472654.88,473338.62,0.00,0.00,683.74,175037.44,0.00,0.00,0.00),('1','153','763','149604',2984601,'2132','321',1359755.40,1360996.68,0.00,0.00,1241.28,289151.56,0.00,0.00,0.00),('1','153','763','149604',2984602,'2133','321',473338.62,474420.28,0.00,0.00,1081.66,276904.96,0.00,0.00,0.00),('1','153','763','149701',2986031,'2132','321',1360996.68,1362799.08,0.00,0.00,1802.40,420513.02,0.00,0.00,0.00),('1','153','763','149701',2986032,'2133','321',474420.28,476600.64,0.00,0.00,2180.36,558172.16,0.00,0.00,0.00),('1','153','763','149702',2986033,'2132','321',1362799.08,1363770.03,0.00,0.00,970.95,232221.16,0.00,0.00,0.00),('1','153','763','149702',2986034,'2133','321',476600.64,477469.24,0.00,0.00,868.60,222361.60,0.00,0.00,0.00),('1','153','763','149862',2989082,'2132','321',1363770.03,1366105.06,0.00,0.00,2335.03,537056.90,0.00,0.00,0.00),('1','153','763','149862',2989083,'2133','321',477469.24,479659.31,0.00,0.00,2190.07,547763.74,0.00,0.00,0.00),('1','153','763','149863',2989084,'2132','321',1366105.06,1366530.98,0.00,0.00,425.92,98635.52,0.00,0.00,0.00),('1','153','763','149863',2989085,'2133','321',479659.31,480364.95,0.00,0.00,705.64,180643.84,0.00,0.00,0.00),('1','153','763','150048',2992468,'2132','321',1366530.98,1369173.22,0.00,0.00,2642.24,607715.20,0.00,0.00,0.00),('1','153','763','150048',2992469,'2133','321',480364.95,482934.11,0.00,0.00,2569.16,653960.96,0.00,0.00,0.00),('1','153','763','150222',2995825,'2132','321',1369173.22,1370691.40,0.00,0.00,1518.18,349181.40,0.00,0.00,0.00),('1','153','763','150222',2995826,'2133','321',482934.11,484645.70,0.00,0.00,1711.59,429535.04,0.00,0.00,0.00),('1','153','763','150272',2996566,'2132','321',1370691.40,1372875.78,0.00,0.00,2184.38,502407.40,0.00,0.00,0.00),('1','153','763','150272',2996567,'2133','321',484645.70,486532.18,0.00,0.00,1886.48,466235.18,0.00,0.00,0.00),('1','153','763','150392',2998732,'2132','321',1372875.78,1373967.88,0.00,0.00,1092.10,251183.00,0.00,0.00,0.00),('1','153','763','150392',2998733,'2133','321',486532.18,487729.28,0.00,0.00,1197.10,302625.72,0.00,0.00,0.00),('1','153','763','150512',3001142,'2132','321',1373967.88,1374885.00,0.00,0.00,917.12,215771.52,0.00,0.00,0.00),('1','153','763','150512',3001143,'2133','321',487729.28,488878.25,0.00,0.00,1148.97,294136.32,0.00,0.00,0.00),('1','153','763','150558',3001961,'2132','321',1374885.00,1377177.98,0.00,0.00,2292.98,527385.40,0.00,0.00,0.00),('1','153','763','150558',3001962,'2133','321',488878.25,490835.04,0.00,0.00,1956.79,492131.00,0.00,0.00,0.00),('1','153','763','150559',3001963,'2132','321',1377177.98,1377861.63,0.00,0.00,683.65,157239.50,0.00,0.00,0.00),('1','153','763','150559',3001964,'2133','321',490835.04,491386.80,0.00,0.00,551.76,138650.04,0.00,0.00,0.00),('1','153','763','150844',3007491,'2132','321',1377861.63,1379251.67,0.00,0.00,1390.04,321352.66,0.00,0.00,0.00),('1','153','763','150844',3007492,'2133','321',491386.80,492996.38,0.00,0.00,1609.58,412052.48,0.00,0.00,0.00),('1','153','763','150846',3007495,'2132','321',1379251.67,1380375.08,0.00,0.00,1123.41,258922.24,0.00,0.00,0.00),('1','153','763','150846',3007496,'2133','321',492996.38,493723.21,0.00,0.00,726.83,186068.48,0.00,0.00,0.00),('1','153','763','150849',3007565,'2132','321',1380375.08,1382729.42,0.00,0.00,2354.34,541498.20,0.00,0.00,0.00),('1','153','763','150849',3007566,'2133','321',493723.21,495823.23,0.00,0.00,2100.02,527101.64,0.00,0.00,0.00),('1','153','763','150853',3007570,'2132','321',1382729.42,1383957.57,0.00,0.00,1228.15,282474.50,0.00,0.00,0.00),('1','153','763','150853',3007571,'2133','321',495823.23,496978.75,0.00,0.00,1155.52,285968.22,0.00,0.00,0.00),('1','153','763','151110',3012495,'2132','321',1383957.57,1385897.48,0.00,0.00,1939.91,447280.66,0.00,0.00,0.00),('1','153','763','151110',3012496,'2133','321',496978.75,498964.06,0.00,0.00,1985.31,508239.36,0.00,0.00,0.00),('1','153','763','151117',3012547,'2132','321',1385897.48,1386213.33,0.00,0.00,315.85,74026.10,0.00,0.00,0.00),('1','153','763','151117',3012548,'2133','321',498964.06,499259.25,0.00,0.00,295.19,75568.64,0.00,0.00,0.00),('1','153','763','151151',3013084,'2132','321',1386213.33,1388334.38,0.00,0.00,2121.05,487841.50,0.00,0.00,0.00),('1','153','763','151151',3013085,'2133','321',499259.25,501262.67,0.00,0.00,2003.42,512875.52,0.00,0.00,0.00),('1','153','763','151393',3017866,'2132','321',1388334.38,1389279.86,0.00,0.00,945.48,217460.40,0.00,0.00,0.00),('1','153','763','151393',3017867,'2133','321',501262.67,502741.39,0.00,0.00,1478.72,371350.32,0.00,0.00,0.00),('1','153','763','151441',3018623,'2132','321',1389279.86,1390057.26,0.00,0.00,777.40,178802.00,0.00,0.00,0.00),('1','153','763','151441',3018624,'2133','321',502741.39,503360.05,0.00,0.00,618.66,158376.96,0.00,0.00,0.00),('1','153','763','151443',3018647,'2132','321',1390057.26,1392207.21,0.00,0.00,2149.95,494488.50,0.00,0.00,0.00),('1','153','763','151443',3018648,'2133','321',503360.05,505270.71,0.00,0.00,1910.66,489128.96,0.00,0.00,0.00),('1','153','763','151733',3023880,'2132','321',1392207.21,1392698.85,0.00,0.00,491.64,113317.44,0.00,0.00,0.00),('1','153','763','151733',3023881,'2133','321',505270.71,505589.94,0.00,0.00,319.23,81722.88,0.00,0.00,0.00),('1','153','763','151738',3023971,'2132','321',1392698.85,1394790.15,0.00,0.00,2091.30,481105.08,0.00,0.00,0.00),('1','153','763','151738',3023972,'2133','321',505589.94,507167.36,0.00,0.00,1577.42,403819.52,0.00,0.00,0.00),('1','153','763','151766',3024412,'2132','321',1394790.15,1396004.21,0.00,0.00,1214.06,279233.80,0.00,0.00,0.00),('1','153','763','151766',3024413,'2133','321',507167.36,508634.84,0.00,0.00,1467.48,365850.78,0.00,0.00,0.00),('1','153','763','151771',3024478,'2132','321',1396004.21,1396624.56,0.00,0.00,620.35,146282.80,0.00,0.00,0.00),('1','153','763','151771',3024479,'2133','321',508634.84,509198.38,0.00,0.00,563.54,144266.24,0.00,0.00,0.00),('1','153','763','151820',3025464,'2132','321',1396624.56,1399237.86,0.00,0.00,2613.30,601914.40,0.00,0.00,0.00),('1','153','763','151820',3025465,'2133','321',509198.38,511727.75,0.00,0.00,2529.37,647518.72,0.00,0.00,0.00),('1','153','763','152034',3029568,'2132','321',1399237.86,1401058.72,0.00,0.00,1820.86,418797.80,0.00,0.00,0.00),('1','153','763','152034',3029569,'2133','321',511727.75,513991.07,0.00,0.00,2263.32,538540.52,0.00,0.00,0.00),('1','153','763','152113',3030998,'2132','321',1401058.72,1401386.58,0.00,0.00,327.86,75407.80,0.00,0.00,0.00),('1','153','763','152113',3030999,'2133','321',513991.07,514406.37,0.00,0.00,415.30,106316.80,0.00,0.00,0.00),('1','153','763','152190',3032426,'2132','321',1401386.58,1403604.92,0.00,0.00,2218.34,510218.20,0.00,0.00,0.00),('1','153','763','152190',3032427,'2133','321',514406.37,516687.18,0.00,0.00,2280.81,577107.86,0.00,0.00,0.00),('1','153','763','152401',3036413,'2132','321',1403604.92,1404126.97,0.00,0.00,522.05,122061.28,0.00,0.00,0.00),('1','153','763','152401',3036414,'2133','321',516687.18,517179.57,0.00,0.00,492.39,126051.84,0.00,0.00,0.00),('1','153','763','152480',3037773,'2132','321',1404126.97,1405647.82,0.00,0.00,1520.85,349795.50,0.00,0.00,0.00),('1','153','763','152480',3037774,'2133','321',517179.57,518925.81,0.00,0.00,1746.24,432252.54,0.00,0.00,0.00),('1','153','763','152593',3039883,'2132','321',1405647.82,1407367.62,0.00,0.00,1719.80,400752.18,0.00,0.00,0.00),('1','153','763','152593',3039884,'2133','321',518925.81,520269.04,0.00,0.00,1343.23,343866.88,0.00,0.00,0.00),('1','153','763','152682',3041568,'2132','321',1407367.62,1408071.68,0.00,0.00,704.06,165343.96,0.00,0.00,0.00),('1','153','763','152682',3041569,'2133','321',520269.04,520803.51,0.00,0.00,534.47,136824.32,0.00,0.00,0.00),('1','153','763','152869',3044961,'2132','321',1408071.68,1410542.69,0.00,0.00,2471.01,568332.30,0.00,0.00,0.00),('1','153','763','152869',3044962,'2133','321',520803.51,523169.16,0.00,0.00,2365.65,598331.86,0.00,0.00,0.00),('1','153','763','152883',3045203,'2132','321',1410542.69,1410708.70,0.00,0.00,166.01,42498.56,0.00,0.00,0.00),('1','153','763','152883',3045204,'2133','321',523169.16,523219.52,0.00,0.00,50.36,12892.16,0.00,0.00,0.00),('1','153','763','153047',3048068,'2132','321',1410708.70,1412431.73,0.00,0.00,1723.03,401448.28,0.00,0.00,0.00),('1','153','763','153047',3048069,'2133','321',523219.52,524567.93,0.00,0.00,1348.41,345192.96,0.00,0.00,0.00),('1','153','763','153200',3050885,'2132','321',1412431.73,1414341.10,0.00,0.00,1909.37,439155.10,0.00,0.00,0.00),('1','153','763','153200',3050886,'2133','321',524567.93,525887.32,0.00,0.00,1319.39,335688.26,0.00,0.00,0.00),('1','153','763','153226',3051279,'2132','321',1414341.10,1415021.05,0.00,0.00,679.95,156388.50,0.00,0.00,0.00),('1','153','763','153226',3051280,'2133','321',525887.32,526574.89,0.00,0.00,687.57,174818.02,0.00,0.00,0.00),('1','153','763','153456',3055530,'2132','321',1415021.05,1417437.16,0.00,0.00,2416.11,577312.76,0.00,0.00,0.00),('1','153','763','153456',3055531,'2133','321',526574.89,528272.47,0.00,0.00,1697.58,461741.76,0.00,0.00,0.00),('1','153','763','153543',3056994,'2132','321',1417437.16,1417909.26,0.00,0.00,472.10,111147.80,0.00,0.00,0.00),('1','153','763','153543',3056995,'2133','321',528272.47,528565.13,0.00,0.00,292.66,79603.52,0.00,0.00,0.00),('1','153','763','153550',3057177,'2132','321',1417909.26,1419055.07,0.00,0.00,1145.81,268119.54,0.00,0.00,0.00),('1','153','763','153550',3057178,'2133','321',528565.13,530154.14,0.00,0.00,1589.01,428570.70,0.00,0.00,0.00),('1','153','763','153658',3059106,'2132','321',1419055.07,1420969.98,0.00,0.00,1914.91,448088.94,0.00,0.00,0.00),('1','153','763','153658',3059107,'2133','321',530154.14,531844.03,0.00,0.00,1689.89,447874.26,0.00,0.00,0.00),('1','153','763','153694',3059700,'2132','321',1420969.98,1422612.89,0.00,0.00,1642.91,384440.94,0.00,0.00,0.00),('1','153','763','153694',3059701,'2133','321',531844.03,533563.03,0.00,0.00,1719.00,465983.02,0.00,0.00,0.00),('1','153','763','153705',3059908,'2132','321',1422612.89,1422999.80,0.00,0.00,386.91,91228.92,0.00,0.00,0.00),('1','153','763','153705',3059909,'2133','321',533563.03,534226.69,0.00,0.00,663.66,180515.52,0.00,0.00,0.00),('1','153','763','153890',3063223,'2132','321',1422999.80,1425546.44,0.00,0.00,2546.64,603530.10,0.00,0.00,0.00),('1','153','763','153890',3063224,'2133','321',534226.69,535918.11,0.00,0.00,1691.42,460066.24,0.00,0.00,0.00),('1','153','763','154055',3066089,'2132','321',1425546.44,1425951.58,0.00,0.00,405.14,95355.28,0.00,0.00,0.00),('1','153','763','154055',3066090,'2133','321',535918.11,536511.58,0.00,0.00,593.47,161423.84,0.00,0.00,0.00),('1','153','763','154124',3067178,'2132','321',1425951.58,1427831.88,0.00,0.00,1880.30,439990.20,0.00,0.00,0.00),('1','153','763','154124',3067179,'2133','321',536511.58,538118.65,0.00,0.00,1607.07,430392.48,0.00,0.00,0.00),('1','153','763','154219',3068964,'2132','321',1427831.88,1429338.47,0.00,0.00,1506.59,360159.54,0.00,0.00,0.00),('1','153','763','154219',3068965,'2133','321',538118.65,539447.63,0.00,0.00,1328.98,361482.56,0.00,0.00,0.00),('1','153','763','154302',3070453,'2132','321',1429338.47,1431258.01,0.00,0.00,1919.54,449172.36,0.00,0.00,0.00),('1','153','763','154302',3070454,'2133','321',539447.63,541132.29,0.00,0.00,1684.66,451185.74,0.00,0.00,0.00),('1','153','763','154359',3071622,'2132','321',1431258.01,1431748.83,0.00,0.00,490.82,114851.88,0.00,0.00,0.00),('1','153','763','154359',3071623,'2133','321',541132.29,541751.32,0.00,0.00,619.03,166613.72,0.00,0.00,0.00),('1','153','763','154471',3073698,'2132','321',1431748.83,1432405.53,0.00,0.00,656.70,153667.80,0.00,0.00,0.00),('1','153','763','154471',3073699,'2133','321',541751.32,542469.38,0.00,0.00,718.06,195312.32,0.00,0.00,0.00),('1','153','763','154759',3079100,'2132','321',1432405.53,1434860.02,0.00,0.00,2454.49,592182.16,0.00,0.00,0.00),('1','153','763','154759',3079101,'2133','321',542469.38,544972.41,0.00,0.00,2503.03,680824.16,0.00,0.00,0.00),('1','153','763','154998',3083695,'2132','321',1434860.02,1437137.01,0.00,0.00,2276.99,550264.12,0.00,0.00,0.00),('1','153','763','154998',3083696,'2133','321',544972.41,547079.85,0.00,0.00,2107.44,573223.68,0.00,0.00,0.00),('1','153','763','155101',3085664,'2132','321',1437137.01,1437854.67,0.00,0.00,717.66,172202.12,0.00,0.00,0.00),('1','153','763','155101',3085665,'2133','321',547079.85,548241.33,0.00,0.00,1161.48,315922.56,0.00,0.00,0.00),('1','153','763','155110',3085850,'2132','321',1437854.67,1438979.25,0.00,0.00,1124.58,263151.72,0.00,0.00,0.00),('1','153','763','155110',3085851,'2133','321',548241.33,549445.57,0.00,0.00,1204.24,323525.28,0.00,0.00,0.00),('1','153','763','155264',3088662,'2132','321',1438979.25,1440605.08,0.00,0.00,1625.83,380444.22,0.00,0.00,0.00),('1','153','763','155264',3088663,'2133','321',549445.57,551853.61,0.00,0.00,2408.04,646340.74,0.00,0.00,0.00),('1','153','763','155266',3088687,'2132','321',1440605.08,1441329.30,0.00,0.00,724.22,171516.44,0.00,0.00,0.00),('1','153','763','155266',3088688,'2133','321',551853.61,552512.05,0.00,0.00,658.44,179095.68,0.00,0.00,0.00),('1','153','763','155384',3090888,'2132','321',1441329.30,1443970.15,0.00,0.00,2640.85,622141.56,0.00,0.00,0.00),('1','153','763','155384',3090889,'2133','321',552512.05,554807.35,0.00,0.00,2295.30,624321.60,0.00,0.00,0.00),('1','153','763','155482',3092603,'2132','321',1443970.15,1445966.04,0.00,0.00,1995.89,467038.26,0.00,0.00,0.00),('1','153','763','155482',3092604,'2133','321',554807.35,557302.35,0.00,0.00,2495.00,672722.26,0.00,0.00,0.00),('1','153','763','155577',3094232,'2132','321',1445966.04,1447090.67,0.00,0.00,1124.63,275623.62,0.00,0.00,0.00),('1','153','763','155577',3094233,'2133','321',557302.35,558027.62,0.00,0.00,725.27,197273.44,0.00,0.00,0.00),('1','153','763','155706',3096738,'2132','321',1447090.67,1448410.86,0.00,0.00,1320.19,309904.48,0.00,0.00,0.00),('1','153','763','155706',3096739,'2133','321',558027.62,559135.33,0.00,0.00,1107.71,301297.12,0.00,0.00,0.00),('1','153','763','155836',3099080,'2132','321',1448410.86,1448712.51,0.00,0.00,301.65,70586.10,0.00,0.00,0.00),('1','153','763','155836',3099081,'2133','321',559135.33,559913.92,0.00,0.00,778.59,208042.98,0.00,0.00,0.00),('1','153','763','155849',3099327,'2132','321',1448712.51,1450074.21,0.00,0.00,1361.70,318637.80,0.00,0.00,0.00),('1','153','763','155849',3099328,'2133','321',559913.92,561426.53,0.00,0.00,1512.61,407227.12,0.00,0.00,0.00),('1','153','763','156117',3103900,'2132','321',1450074.21,1451681.81,0.00,0.00,1607.60,377853.06,0.00,0.00,0.00),('1','153','763','156117',3103901,'2133','321',561426.53,563237.81,0.00,0.00,1811.28,492668.16,0.00,0.00,0.00),('1','153','763','156126',3104019,'2132','321',1451681.81,1451938.32,0.00,0.00,256.51,64739.52,0.00,0.00,0.00),('1','153','763','156126',3104020,'2133','321',563237.81,563432.14,0.00,0.00,194.33,52857.76,0.00,0.00,0.00),('1','153','763','156183',3105341,'2132','321',1451938.32,1454124.26,0.00,0.00,2185.94,511509.96,0.00,0.00,0.00),('1','153','763','156183',3105342,'2133','321',563432.14,565928.03,0.00,0.00,2495.89,676791.32,0.00,0.00,0.00),('1','153','763','156390',3109137,'2132','321',1454124.26,1454790.15,0.00,0.00,665.89,160066.28,0.00,0.00,0.00),('1','153','763','156390',3109138,'2133','321',565928.03,566418.32,0.00,0.00,490.29,133358.88,0.00,0.00,0.00),('1','153','763','156396',3109231,'2132','321',1454790.15,1456495.99,0.00,0.00,1705.84,404139.24,0.00,0.00,0.00),('1','153','763','156396',3109232,'2133','321',566418.32,567555.87,0.00,0.00,1137.55,309413.60,0.00,0.00,0.00),('1','153','763','156435',3109755,'2132','321',1456495.99,1458139.51,0.00,0.00,1643.52,384583.68,0.00,0.00,0.00),('1','153','763','156435',3109756,'2133','321',567555.87,569386.99,0.00,0.00,1831.12,490952.94,0.00,0.00,0.00),('1','153','763','156654',3114025,'2132','321',1458139.51,1461674.36,0.00,0.00,3534.85,838191.24,0.00,0.00,0.00),('1','153','763','156654',3114026,'2133','321',569386.99,571182.28,0.00,0.00,1795.29,488318.88,0.00,0.00,0.00),('1','153','763','156768',3116053,'2132','321',1461674.36,1461994.42,0.00,0.00,320.06,74894.04,0.00,0.00,0.00),('1','153','763','156768',3116054,'2133','321',571182.28,571801.67,0.00,0.00,619.39,166023.08,0.00,0.00,0.00),('1','153','763','156771',3116131,'2132','321',1461994.42,1463682.64,0.00,0.00,1688.22,395043.48,0.00,0.00,0.00),('1','153','763','156771',3116132,'2133','321',571801.67,573451.20,0.00,0.00,1649.53,437745.26,0.00,0.00,0.00),('1','153','763','157064',3121489,'2132','321',1463682.64,1464924.08,0.00,0.00,1241.44,295202.88,0.00,0.00,0.00),('1','153','763','157064',3121490,'2133','321',573451.20,574025.61,0.00,0.00,574.41,156239.52,0.00,0.00,0.00),('1','153','763','157071',3121666,'2132','321',1464924.08,1466605.87,0.00,0.00,1681.79,394678.48,0.00,0.00,0.00),('1','153','763','157071',3121667,'2133','321',574025.61,574914.32,0.00,0.00,888.71,241729.12,0.00,0.00,0.00),('1','153','763','157226',3124274,'2132','321',1466605.87,1468521.00,0.00,0.00,1915.13,449148.56,0.00,0.00,0.00),('1','153','763','157226',3124275,'2133','321',574914.32,576730.10,0.00,0.00,1815.78,493892.16,0.00,0.00,0.00),('1','153','763','157399',3127087,'2132','321',1468521.00,1471886.77,0.00,0.00,3365.77,793100.94,0.00,0.00,0.00),('1','153','763','157399',3127088,'2133','321',576730.10,578888.53,0.00,0.00,2158.43,587092.96,0.00,0.00,0.00),('1','153','763','157403',3127163,'2132','321',1471886.77,1472198.65,0.00,0.00,311.88,72979.92,0.00,0.00,0.00),('1','153','763','157403',3127164,'2133','321',578888.53,579398.65,0.00,0.00,510.12,135112.24,0.00,0.00,0.00),('1','153','763','157631',3131417,'2132','321',1472198.65,1474760.36,0.00,0.00,2561.71,599440.14,0.00,0.00,0.00),('1','153','763','157631',3131418,'2133','321',579398.65,581004.53,0.00,0.00,1605.88,431651.50,0.00,0.00,0.00),('1','153','763','157776',3134011,'2132','321',1474760.36,1476203.78,0.00,0.00,1443.42,351647.00,0.00,0.00,0.00),('1','153','763','157776',3134012,'2133','321',581004.53,581714.35,0.00,0.00,709.82,193071.04,0.00,0.00,0.00),('1','153','763','157782',3134108,'2132','321',1476203.78,1477098.64,0.00,0.00,894.86,218825.42,0.00,0.00,0.00),('1','153','763','157782',3134109,'2133','321',581714.35,582315.35,0.00,0.00,601.00,163472.00,0.00,0.00,0.00),('1','153','763','157872',3135758,'2132','321',1477098.64,1478557.90,0.00,0.00,1459.26,341466.84,0.00,0.00,0.00),('1','153','763','157872',3135759,'2133','321',582315.35,583554.48,0.00,0.00,1239.13,318719.38,0.00,0.00,0.00),('1','153','763','157887',3136070,'2132','321',1478557.90,1478953.49,0.00,0.00,395.59,92883.08,0.00,0.00,0.00),('1','153','763','157887',3136071,'2133','321',583554.48,583924.66,0.00,0.00,370.18,100688.96,0.00,0.00,0.00),('1','153','763','158049',3139076,'2132','321',1478953.49,1481712.23,0.00,0.00,2758.74,659999.98,0.00,0.00,0.00),('1','153','763','158049',3139077,'2133','321',583924.66,585426.81,0.00,0.00,1502.15,408584.80,0.00,0.00,0.00),('1','153','763','158247',3142859,'2132','321',1481712.23,1482278.79,0.00,0.00,566.56,134891.90,0.00,0.00,0.00),('1','153','763','158247',3142860,'2133','321',585426.81,586101.36,0.00,0.00,674.55,183477.60,0.00,0.00,0.00),('1','153','763','158253',3142914,'2132','321',1482278.79,1484224.14,0.00,0.00,1945.35,455211.90,0.00,0.00,0.00),('1','153','763','158253',3142915,'2133','321',586101.36,587704.45,0.00,0.00,1603.09,429901.96,0.00,0.00,0.00),('1','153','763','158311',3143954,'2132','321',1484224.14,1486760.04,0.00,0.00,2535.90,615897.36,0.00,0.00,0.00),('1','153','763','158311',3143955,'2133','321',587704.45,589663.00,0.00,0.00,1958.55,532725.60,0.00,0.00,0.00),('1','153','763','158441',3146389,'2132','321',1486760.04,1487548.14,0.00,0.00,788.10,214363.20,0.00,0.00,0.00),('1','153','763','158441',3146390,'2133','321',589663.00,591232.96,0.00,0.00,1569.96,427029.12,0.00,0.00,0.00),('1','153','763','158742',3151863,'2132','321',1487548.14,1489035.96,0.00,0.00,1487.82,403262.04,0.00,0.00,0.00),('1','153','763','158742',3151864,'2133','321',591232.96,592758.30,0.00,0.00,1525.34,414892.48,0.00,0.00,0.00),('1','153','763','158746',3151960,'2132','321',1489035.96,1490244.28,0.00,0.00,1208.32,327238.04,0.00,0.00,0.00),('1','153','763','158746',3151961,'2133','321',592758.30,593673.19,0.00,0.00,914.89,248850.08,0.00,0.00,0.00),('1','153','763','158902',3154638,'2132','321',1490244.28,1490963.87,0.00,0.00,719.59,195728.48,0.00,0.00,0.00),('1','153','763','158902',3154639,'2133','321',593673.19,594264.98,0.00,0.00,591.79,160966.88,0.00,0.00,0.00),('1','153','763','158986',3156021,'2132','321',1490963.87,1491916.67,0.00,0.00,952.80,234630.40,0.00,0.00,0.00),('1','153','763','158986',3156022,'2133','321',594264.98,595159.10,0.00,0.00,894.12,243200.64,0.00,0.00,0.00),('1','153','763','159113',3158306,'2132','321',1491916.67,1494516.08,0.00,0.00,2599.41,628553.44,0.00,0.00,0.00),('1','153','763','159113',3158307,'2133','321',595159.10,597002.07,0.00,0.00,1842.97,501287.84,0.00,0.00,0.00),('1','153','763','159323',3162015,'2132','321',1494516.08,1496970.31,0.00,0.00,2454.23,611348.96,0.00,0.00,0.00),('1','153','763','159323',3162016,'2133','321',597002.07,599537.24,0.00,0.00,2535.17,689566.24,0.00,0.00,0.00),('1','153','763','159344',3162313,'2132','321',1496970.31,1497596.56,0.00,0.00,626.25,154647.20,0.00,0.00,0.00),('1','153','763','159344',3162314,'2133','321',599537.24,600025.24,0.00,0.00,488.00,132736.00,0.00,0.00,0.00),('1','153','763','159602',3166859,'2132','321',1497596.56,1497596.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','159602',3166860,'2133','321',600025.24,600160.24,0.00,0.00,135.00,36720.00,0.00,0.00,0.00),('1','153','763','159696',3168409,'2132','321',1497596.56,1499990.52,0.00,0.00,2393.96,574550.40,0.00,0.00,0.00),('1','153','763','159696',3168410,'2133','321',600160.24,602357.54,0.00,0.00,2197.30,587390.40,0.00,0.00,0.00),('1','153','763','159699',3168476,'2132','321',1499990.52,1500550.74,0.00,0.00,560.22,134452.80,0.00,0.00,0.00),('1','153','763','159699',3168477,'2133','321',602357.54,603084.85,0.00,0.00,727.31,197828.32,0.00,0.00,0.00),('1','153','763','159706',3168669,'2132','321',1500550.74,1500989.23,0.00,0.00,438.49,107829.60,0.00,0.00,0.00),('1','153','763','159706',3168670,'2133','321',603084.85,603528.58,0.00,0.00,443.73,120694.56,0.00,0.00,0.00),('1','153','763','159709',3168738,'2132','321',1500989.23,1502478.16,0.00,0.00,1488.93,358429.60,0.00,0.00,0.00),('1','153','763','159709',3168739,'2133','321',603528.58,605083.57,0.00,0.00,1554.99,422957.28,0.00,0.00,0.00),('1','153','763','159826',3170565,'2132','321',1502478.16,1503788.66,0.00,0.00,1310.50,326721.60,0.00,0.00,0.00),('1','153','763','159826',3170566,'2133','321',605083.57,606368.11,0.00,0.00,1284.54,349394.88,0.00,0.00,0.00),('1','153','763','160040',3174465,'2132','321',1503788.66,1507095.08,0.00,0.00,3306.42,793540.80,0.00,0.00,0.00),('1','153','763','160040',3174466,'2133','321',606368.11,609425.67,0.00,0.00,3057.56,819020.80,0.00,0.00,0.00),('1','153','763','160205',3177531,'2132','321',1507095.08,1510285.24,0.00,0.00,3190.16,765638.40,0.00,0.00,0.00),('1','153','763','160205',3177532,'2133','321',609425.67,612542.19,0.00,0.00,3116.52,820752.00,0.00,0.00,0.00),('1','153','763','160383',3180821,'2132','321',1510285.24,1512836.68,0.00,0.00,2551.44,632732.72,0.00,0.00,0.00),('1','153','763','160383',3180822,'2133','321',612542.19,614629.79,0.00,0.00,2087.60,567827.20,0.00,0.00,0.00),('1','153','763','160512',3183184,'2132','321',1512836.68,1513633.11,0.00,0.00,796.43,196428.08,0.00,0.00,0.00),('1','153','763','160512',3183185,'2133','321',614629.79,615403.79,0.00,0.00,774.00,210528.00,0.00,0.00,0.00),('1','153','763','160515',3183237,'2132','321',1513633.11,1514689.22,0.00,0.00,1056.11,265345.48,0.00,0.00,0.00),('1','153','763','160515',3183238,'2133','321',615403.79,616587.56,0.00,0.00,1183.77,321985.44,0.00,0.00,0.00),('1','153','763','160654',3185539,'2132','321',1514689.22,1516308.76,0.00,0.00,1619.54,421134.04,0.00,0.00,0.00),('1','153','763','160654',3185540,'2133','321',616587.56,618222.45,0.00,0.00,1634.89,483927.44,0.00,0.00,0.00),('1','153','763','160819',3188453,'2132','321',1516308.76,1516661.17,0.00,0.00,352.41,89264.92,0.00,0.00,0.00),('1','153','763','160819',3188454,'2133','321',618222.45,618666.89,0.00,0.00,444.44,131554.24,0.00,0.00,0.00),('1','153','763','160822',3188472,'2132','321',1516661.17,1517940.08,0.00,0.00,1278.91,345265.32,0.00,0.00,0.00),('1','153','763','160822',3188473,'2133','321',618666.89,620035.39,0.00,0.00,1368.50,405076.00,0.00,0.00,0.00),('1','153','763','160953',3190537,'2132','321',1517940.08,1519842.25,0.00,0.00,1902.17,499033.32,0.00,0.00,0.00),('1','153','763','160953',3190538,'2133','321',620035.39,621723.96,0.00,0.00,1688.57,499816.72,0.00,0.00,0.00),('1','153','763','161161',3194501,'2132','321',1519842.25,1520726.48,0.00,0.00,884.23,243879.48,0.00,0.00,0.00),('1','153','763','161161',3194502,'2133','321',621723.96,623497.52,0.00,0.00,1773.56,524973.76,0.00,0.00,0.00),('1','153','763','161353',3197660,'2132','321',1520726.48,1522072.37,0.00,0.00,1345.89,350810.24,0.00,0.00,0.00),('1','153','763','161353',3197661,'2133','321',623497.52,625274.26,0.00,0.00,1776.74,525915.04,0.00,0.00,0.00),('1','153','763','161525',3200436,'2132','321',1522072.37,1522282.19,0.00,0.00,209.82,54631.72,0.00,0.00,0.00),('1','153','763','161525',3200437,'2133','321',625274.26,625660.44,0.00,0.00,386.18,114309.28,0.00,0.00,0.00),('1','153','763','161531',3200561,'2132','321',1522282.19,1523259.58,0.00,0.00,977.39,259961.74,0.00,0.00,0.00),('1','153','763','161531',3200562,'2133','321',625660.44,626753.20,0.00,0.00,1092.76,323456.96,0.00,0.00,0.00),('1','153','763','161738',3204049,'2132','321',1523259.58,1524632.10,0.00,0.00,1372.52,364958.84,0.00,0.00,0.00),('1','153','763','161738',3204050,'2133','321',626753.20,627961.42,0.00,0.00,1208.22,357633.12,0.00,0.00,0.00),('1','153','763','161966',3208425,'2132','321',1524632.10,1525431.49,0.00,0.00,799.39,201147.92,0.00,0.00,0.00),('1','153','763','161966',3208426,'2133','321',627961.42,628812.81,0.00,0.00,851.39,252011.44,0.00,0.00,0.00),('1','153','763','161980',3208684,'2132','321',1525431.49,1526098.41,0.00,0.00,666.92,169838.68,0.00,0.00,0.00),('1','153','763','161980',3208685,'2133','321',628812.81,629455.48,0.00,0.00,642.67,190230.32,0.00,0.00,0.00),('1','153','763','162136',3211237,'2132','321',1526098.41,1527599.80,0.00,0.00,1501.39,381693.20,0.00,0.00,0.00),('1','153','763','162136',3211238,'2133','321',629455.48,631112.36,0.00,0.00,1656.88,490436.48,0.00,0.00,0.00),('1','153','763','162279',3213723,'2132','321',1527599.80,1528517.01,0.00,0.00,917.21,263149.30,0.00,0.00,0.00),('1','153','763','162279',3213724,'2133','321',631112.36,632007.25,0.00,0.00,894.89,264887.44,0.00,0.00,0.00),('1','153','763','162294',3213895,'2132','321',1528517.01,1529005.17,0.00,0.00,488.16,130856.82,0.00,0.00,0.00),('1','153','763','162294',3213896,'2133','321',632007.25,632409.38,0.00,0.00,402.13,119030.48,0.00,0.00,0.00),('1','153','763','162505',3217395,'2132','321',1529005.17,1530377.58,0.00,0.00,1372.41,343102.50,0.00,0.00,0.00),('1','153','763','162505',3217396,'2133','321',632409.38,634388.49,0.00,0.00,1979.11,585816.56,0.00,0.00,0.00),('1','153','763','162763',3222017,'2132','321',1530377.58,1532147.86,0.00,0.00,1770.28,462689.48,0.00,0.00,0.00),('1','153','763','162763',3222018,'2133','321',634388.49,635891.43,0.00,0.00,1502.94,444870.24,0.00,0.00,0.00),('1','153','763','162903',3224318,'2132','321',1532147.86,1533482.49,0.00,0.00,1334.63,337541.28,0.00,0.00,0.00),('1','153','763','162903',3224319,'2133','321',635891.43,637596.27,0.00,0.00,1704.84,504632.64,0.00,0.00,0.00),('1','153','763','163066',3227107,'2132','321',1533482.49,1535560.73,0.00,0.00,2078.24,533655.32,0.00,0.00,0.00),('1','153','763','163066',3227108,'2133','321',637596.27,639304.54,0.00,0.00,1708.27,505647.92,0.00,0.00,0.00),('1','153','763','163495',3235038,'2132','321',1535560.73,1536766.37,0.00,0.00,1205.64,301410.00,0.00,0.00,0.00),('1','153','763','163495',3235039,'2133','321',639304.54,640618.85,0.00,0.00,1314.31,376431.76,0.00,0.00,0.00),('1','153','763','163506',3235254,'2132','321',1536766.37,1537426.65,0.00,0.00,660.28,165070.00,0.00,0.00,0.00),('1','153','763','163506',3235255,'2133','321',640618.85,641078.25,0.00,0.00,459.40,135982.40,0.00,0.00,0.00),('1','153','763','163509',3235287,'2132','321',1537426.65,1540213.08,0.00,0.00,2786.43,699162.34,0.00,0.00,0.00),('1','153','763','163509',3235288,'2133','321',641078.25,643216.70,0.00,0.00,2138.45,632981.20,0.00,0.00,0.00),('1','153','763','163715',3239042,'2132','321',1540213.08,1543223.18,0.00,0.00,3010.10,752525.00,0.00,0.00,0.00),('1','153','763','163715',3239043,'2133','321',643216.70,645351.27,0.00,0.00,2134.57,612190.72,0.00,0.00,0.00),('1','153','763','163882',3241969,'2132','321',1543223.18,1546026.90,0.00,0.00,2803.72,700930.00,0.00,0.00,0.00),('1','153','763','163882',3241970,'2133','321',645351.27,648262.84,0.00,0.00,2911.57,787258.72,0.00,0.00,0.00),('1','153','763','163886',3242052,'2132','321',1546026.90,1546641.74,0.00,0.00,614.84,153710.00,0.00,0.00,0.00),('1','153','763','163886',3242053,'2133','321',648262.84,648688.41,0.00,0.00,425.57,121577.10,0.00,0.00,0.00),('1','153','763','164055',3245153,'2132','321',1546641.74,1549768.74,0.00,0.00,3127.00,781750.00,0.00,0.00,0.00),('1','153','763','164055',3245154,'2133','321',648688.41,650800.89,0.00,0.00,2112.48,585634.26,0.00,0.00,0.00),('1','153','763','164061',3245236,'2132','321',1549768.74,1550919.72,0.00,0.00,1150.98,290595.00,0.00,0.00,0.00),('1','153','763','164061',3245237,'2133','321',650800.89,651559.07,0.00,0.00,758.18,224421.28,0.00,0.00,0.00),('1','153','763','164103',3245795,'2132','321',1550919.72,1552741.10,0.00,0.00,1821.38,495246.82,0.00,0.00,0.00),('1','153','763','164103',3245796,'2133','321',651559.07,653260.16,0.00,0.00,1701.09,503522.64,0.00,0.00,0.00),('1','153','763','164412',3251779,'2132','321',1552741.10,1554947.77,0.00,0.00,2206.67,599219.90,0.00,0.00,0.00),('1','153','763','164412',3251780,'2133','321',653260.16,655277.40,0.00,0.00,2017.24,597103.04,0.00,0.00,0.00),('1','153','763','164550',3254110,'2132','321',1554947.77,1555452.26,0.00,0.00,504.49,136992.04,0.00,0.00,0.00),('1','153','763','164550',3254111,'2133','321',655277.40,655623.40,0.00,0.00,346.00,102416.00,0.00,0.00,0.00),('1','153','763','164557',3254216,'2132','321',1555452.26,1557180.05,0.00,0.00,1727.79,476871.58,0.00,0.00,0.00),('1','153','763','164557',3254217,'2133','321',655623.40,656724.70,0.00,0.00,1101.30,325984.80,0.00,0.00,0.00),('1','153','763','164695',3256691,'2132','321',1557180.05,1558922.66,0.00,0.00,1742.61,483806.30,0.00,0.00,0.00),('1','153','763','164695',3256692,'2133','321',656724.70,658465.95,0.00,0.00,1741.25,515410.00,0.00,0.00,0.00),('1','153','763','164842',3259362,'2132','321',1558922.66,1561814.12,0.00,0.00,2891.46,787553.00,0.00,0.00,0.00),('1','153','763','164842',3259363,'2133','321',658465.95,661242.91,0.00,0.00,2776.96,821980.16,0.00,0.00,0.00),('1','153','763','165059',3263171,'2132','321',1561814.12,1563967.75,0.00,0.00,2153.63,607790.28,0.00,0.00,0.00),('1','153','763','165059',3263172,'2133','321',661242.91,663691.64,0.00,0.00,2448.73,724824.08,0.00,0.00,0.00),('1','153','763','165238',3266479,'2132','321',1563967.75,1564791.43,0.00,0.00,823.68,246347.52,0.00,0.00,0.00),('1','153','763','165238',3266480,'2133','321',663691.64,664539.10,0.00,0.00,847.46,271187.20,0.00,0.00,0.00),('1','153','763','165245',3266597,'2132','321',1564791.43,1566000.99,0.00,0.00,1209.56,364814.56,0.00,0.00,0.00),('1','153','763','165245',3266598,'2133','321',664539.10,665861.73,0.00,0.00,1322.63,423241.60,0.00,0.00,0.00),('1','153','763','165328',3267834,'2132','321',1566000.99,1567104.94,0.00,0.00,1103.95,329167.52,0.00,0.00,0.00),('1','153','763','165328',3267835,'2133','321',665861.73,667033.88,0.00,0.00,1172.15,375088.00,0.00,0.00,0.00),('1','153','763','165340',3267990,'2132','321',1567104.94,1568005.38,0.00,0.00,900.44,275590.96,0.00,0.00,0.00),('1','153','763','165340',3267991,'2133','321',667033.88,667866.49,0.00,0.00,832.61,266435.20,0.00,0.00,0.00),('1','153','763','165499',3270741,'2132','321',1568005.38,1569941.45,0.00,0.00,1936.07,584512.24,0.00,0.00,0.00),('1','153','763','165499',3270742,'2133','321',667866.49,670272.71,0.00,0.00,2406.22,769990.40,0.00,0.00,0.00),('1','153','763','165728',3275024,'2132','321',1569941.45,1571711.81,0.00,0.00,1770.36,526306.56,0.00,0.00,0.00),('1','153','763','165728',3275025,'2133','321',670272.71,672748.36,0.00,0.00,2475.65,792208.00,0.00,0.00,0.00),('1','153','763','165863',3277633,'2132','321',1571711.81,1573006.08,0.00,0.00,1294.27,398747.60,0.00,0.00,0.00),('1','153','763','165863',3277634,'2133','321',672748.36,673484.27,0.00,0.00,735.91,235491.20,0.00,0.00,0.00),('1','153','763','165873',3277869,'2132','321',1573006.08,1573769.97,0.00,0.00,763.89,232699.44,0.00,0.00,0.00),('1','153','763','165873',3277870,'2133','321',673484.27,674137.53,0.00,0.00,653.26,209043.20,0.00,0.00,0.00),('1','153','763','166186',3283084,'2132','321',1573769.97,1575568.47,0.00,0.00,1798.50,542430.96,0.00,0.00,0.00),('1','153','763','166186',3283085,'2133','321',674137.53,676508.92,0.00,0.00,2371.39,758844.80,0.00,0.00,0.00),('1','153','763','166191',3283189,'2132','321',1575568.47,1576042.24,0.00,0.00,473.77,142988.00,0.00,0.00,0.00),('1','153','763','166191',3283190,'2133','321',676508.92,676749.91,0.00,0.00,240.99,77116.80,0.00,0.00,0.00),('1','153','763','166205',3283447,'2132','321',1576042.24,1578389.32,0.00,0.00,2347.08,694735.68,0.00,0.00,0.00),('1','153','763','166205',3283448,'2133','321',676749.91,678379.21,0.00,0.00,1629.30,517466.88,0.00,0.00,0.00),('1','153','763','166555',3289842,'2132','321',1578389.32,1579974.10,0.00,0.00,1584.78,479976.00,0.00,0.00,0.00),('1','153','763','166555',3289843,'2133','321',678379.21,679689.86,0.00,0.00,1310.65,419408.00,0.00,0.00,0.00),('1','153','763','166579',3290304,'2132','321',1579974.10,1581977.20,0.00,0.00,2003.10,611983.68,0.00,0.00,0.00),('1','153','763','166579',3290305,'2133','321',679689.86,680963.98,0.00,0.00,1274.12,407718.40,0.00,0.00,0.00),('1','153','763','166780',3293637,'2132','321',1581977.20,1583072.41,0.00,0.00,1095.21,334068.00,0.00,0.00,0.00),('1','153','763','166780',3293638,'2133','321',680963.98,682694.73,0.00,0.00,1730.75,553840.00,0.00,0.00,0.00),('1','153','763','167147',3300386,'2132','321',1583072.41,1585153.29,0.00,0.00,2080.88,634524.64,0.00,0.00,0.00),('1','153','763','167147',3300387,'2133','321',682694.73,684023.15,0.00,0.00,1328.42,425094.40,0.00,0.00,0.00),('1','153','763','167151',3300460,'2132','321',1585153.29,1587071.13,0.00,0.00,1917.84,575416.32,0.00,0.00,0.00),('1','153','763','167151',3300461,'2133','321',684023.15,685910.47,0.00,0.00,1887.32,603942.40,0.00,0.00,0.00),('1','153','763','167399',3304604,'2132','321',1587071.13,1588595.47,0.00,0.00,1524.34,462124.64,0.00,0.00,0.00),('1','153','763','167399',3304605,'2133','321',685910.47,686856.90,0.00,0.00,946.43,302857.60,0.00,0.00,0.00),('1','153','763','167400',3304606,'2132','321',1588595.47,1589485.44,0.00,0.00,889.97,267820.96,0.00,0.00,0.00),('1','153','763','167400',3304607,'2133','321',686856.90,687542.49,0.00,0.00,685.59,219388.80,0.00,0.00,0.00),('1','153','763','167535',3307383,'2132','321',1589485.44,1592136.71,0.00,0.00,2651.27,786351.52,0.00,0.00,0.00),('1','153','763','167535',3307384,'2133','321',687542.49,689529.82,0.00,0.00,1987.33,635945.60,0.00,0.00,0.00),('1','153','763','167698',3310169,'2132','321',1592136.71,1594097.24,0.00,0.00,1960.53,590792.64,0.00,0.00,0.00),('1','153','763','167698',3310170,'2133','321',689529.82,691140.59,0.00,0.00,1610.77,515446.40,0.00,0.00,0.00),('1','153','763','167795',3311715,'2132','321',1594097.24,1594400.00,0.00,0.00,302.76,92991.84,0.00,0.00,0.00),('1','153','763','167795',3311716,'2133','321',691140.59,691567.65,0.00,0.00,427.06,136659.20,0.00,0.00,0.00),('1','153','763','167800',3311830,'2132','321',1594400.00,1595948.11,0.00,0.00,1548.11,466980.64,0.00,0.00,0.00),('1','153','763','167800',3311831,'2133','321',691567.65,692638.33,0.00,0.00,1070.68,342617.60,0.00,0.00,0.00),('1','153','763','168047',3316370,'2132','321',1595948.11,1597820.67,0.00,0.00,1872.56,561612.16,0.00,0.00,0.00),('1','153','763','168047',3316371,'2133','321',692638.33,694441.67,0.00,0.00,1803.34,577068.80,0.00,0.00,0.00),('1','153','763','168474',3324193,'2132','321',1597820.67,1599514.61,0.00,0.00,1693.94,515514.88,0.00,0.00,0.00),('1','153','763','168474',3324194,'2133','321',694441.67,696171.84,0.00,0.00,1730.17,553654.40,0.00,0.00,0.00),('1','153','763','168493',3324512,'2132','321',1599514.61,1601686.05,0.00,0.00,2171.44,650390.00,0.00,0.00,0.00),('1','153','763','168493',3324513,'2133','321',696171.84,697822.25,0.00,0.00,1650.41,528131.20,0.00,0.00,0.00),('1','153','763','168509',3324757,'2132','321',1601686.05,1604128.56,0.00,0.00,2442.51,726410.64,0.00,0.00,0.00),('1','153','763','168509',3324758,'2133','321',697822.25,699825.75,0.00,0.00,2003.50,641120.00,0.00,0.00,0.00),('1','153','763','168655',3327430,'2132','321',1604128.56,1606302.84,0.00,0.00,2174.28,667616.40,0.00,0.00,0.00),('1','153','763','168655',3327431,'2133','321',699825.75,701046.19,0.00,0.00,1220.44,390540.80,0.00,0.00,0.00),('1','153','763','168852',3330928,'2132','321',1606302.84,1606819.14,0.00,0.00,516.30,155505.60,0.00,0.00,0.00),('1','153','763','168852',3330929,'2133','321',701046.19,701973.44,0.00,0.00,927.25,296720.00,0.00,0.00,0.00),('1','153','763','168861',3331104,'2132','321',1606819.14,1607876.61,0.00,0.00,1057.47,321000.96,0.00,0.00,0.00),('1','153','763','168861',3331105,'2133','321',701973.44,703224.44,0.00,0.00,1251.00,400320.00,0.00,0.00,0.00),('1','153','763','169043',3334353,'2132','321',1607876.61,1610107.09,0.00,0.00,2230.48,670701.92,0.00,0.00,0.00),('1','153','763','169043',3334354,'2133','321',703224.44,705041.35,0.00,0.00,1816.91,581411.20,0.00,0.00,0.00),('1','153','763','169052',3334551,'2132','321',1610107.09,1610523.81,0.00,0.00,416.72,125532.40,0.00,0.00,0.00),('1','153','763','169052',3334552,'2133','321',705041.35,705548.51,0.00,0.00,507.16,162291.20,0.00,0.00,0.00),('1','153','763','169239',3338032,'2132','321',1610523.81,1612322.70,0.00,0.00,1798.89,545593.68,0.00,0.00,0.00),('1','153','763','169239',3338033,'2133','321',705548.51,707588.48,0.00,0.00,2039.97,652790.40,0.00,0.00,0.00),('1','153','763','169387',3341001,'2132','321',1612322.70,1613523.47,0.00,0.00,1200.77,355427.92,0.00,0.00,0.00),('1','153','763','169387',3341002,'2133','321',707588.48,708668.50,0.00,0.00,1080.02,341102.08,0.00,0.00,0.00),('1','153','763','169392',3341090,'2132','321',1613523.47,1615277.03,0.00,0.00,1753.56,522502.32,0.00,0.00,0.00),('1','153','763','169392',3341091,'2133','321',708668.50,710229.50,0.00,0.00,1561.00,499520.00,0.00,0.00,0.00),('1','153','763','169580',3344812,'2132','321',1615277.03,1618966.53,0.00,0.00,3689.50,1092092.00,0.00,0.00,0.00),('1','153','763','169580',3344813,'2133','321',710229.50,712521.96,0.00,0.00,2292.46,731010.80,0.00,0.00,0.00),('1','153','763','169735',3347674,'2132','321',1618966.53,1621873.90,0.00,0.00,2907.37,904640.08,0.00,0.00,0.00),('1','153','763','169735',3347675,'2133','321',712521.96,715372.92,0.00,0.00,2850.96,935114.88,0.00,0.00,0.00),('1','153','763','170104',3354357,'2132','321',1621873.90,1622230.82,0.00,0.00,356.92,111761.56,0.00,0.00,0.00),('1','153','763','170104',3354358,'2133','321',715372.92,715597.77,0.00,0.00,224.85,73750.80,0.00,0.00,0.00),('1','153','763','170168',3355380,'2132','321',1622230.82,1625207.90,0.00,0.00,2977.08,927614.76,0.00,0.00,0.00),('1','153','763','170168',3355381,'2133','321',715597.77,717947.93,0.00,0.00,2350.16,770852.48,0.00,0.00,0.00),('1','153','763','170303',3357760,'2132','321',1625207.90,1626296.92,0.00,0.00,1089.02,340952.84,0.00,0.00,0.00),('1','153','763','170303',3357761,'2133','321',717947.93,719104.15,0.00,0.00,1156.22,379240.16,0.00,0.00,0.00),('1','153','763','170310',3357843,'2132','321',1626296.92,1627576.92,0.00,0.00,1280.00,405691.46,0.00,0.00,0.00),('1','153','763','170310',3357844,'2133','321',719104.15,720265.34,0.00,0.00,1161.19,380870.32,0.00,0.00,0.00),('1','153','763','170490',3360926,'2132','321',1627576.92,1629631.79,0.00,0.00,2054.87,645509.30,0.00,0.00,0.00),('1','153','763','170490',3360927,'2133','321',720265.34,722142.05,0.00,0.00,1876.71,615560.88,0.00,0.00,0.00),('1','153','763','170493',3360996,'2132','321',1629631.79,1630037.75,0.00,0.00,405.96,130084.44,0.00,0.00,0.00),('1','153','763','170493',3360997,'2133','321',722142.05,722634.12,0.00,0.00,492.07,161398.96,0.00,0.00,0.00),('1','153','763','170525',3361525,'2132','321',1630037.75,1631687.97,0.00,0.00,1650.22,518532.40,0.00,0.00,0.00),('1','153','763','170525',3361526,'2133','321',722634.12,724601.56,0.00,0.00,1967.44,645320.32,0.00,0.00,0.00),('1','153','763','170594',3362840,'2132','321',1631687.97,1634634.79,0.00,0.00,2946.82,927339.82,0.00,0.00,0.00),('1','153','763','170594',3362841,'2133','321',724601.56,727324.65,0.00,0.00,2723.09,893173.52,0.00,0.00,0.00),('1','153','763','170753',3365732,'2132','321',1634634.79,1635033.73,0.00,0.00,398.94,124984.32,0.00,0.00,0.00),('1','153','763','170753',3365733,'2133','321',727324.65,727554.89,0.00,0.00,230.24,75518.72,0.00,0.00,0.00),('1','153','763','170967',3369499,'2132','321',1635033.73,1636253.98,0.00,0.00,1220.25,386031.54,0.00,0.00,0.00),('1','153','763','170967',3369500,'2133','321',727554.89,729124.26,0.00,0.00,1569.37,514753.36,0.00,0.00,0.00),('1','153','763','171325',3376257,'2132','321',1636253.98,1638238.71,0.00,0.00,1984.73,623130.86,0.00,0.00,0.00),('1','153','763','171325',3376258,'2133','321',729124.26,730727.99,0.00,0.00,1603.73,526023.44,0.00,0.00,0.00),('1','153','763','171331',3376378,'2132','321',1638238.71,1640121.70,0.00,0.00,1882.99,593414.32,0.00,0.00,0.00),('1','153','763','171331',3376379,'2133','321',730727.99,732859.23,0.00,0.00,2131.24,699046.72,0.00,0.00,0.00),('1','153','763','171337',3376465,'2132','321',1640121.70,1641447.72,0.00,0.00,1326.02,417418.76,0.00,0.00,0.00),('1','153','763','171337',3376466,'2133','321',732859.23,734318.47,0.00,0.00,1459.24,478630.72,0.00,0.00,0.00),('1','153','763','171904',3386576,'2132','321',1641447.72,1643436.61,0.00,0.00,1988.89,629017.30,0.00,0.00,0.00),('1','153','763','171904',3386577,'2133','321',734318.47,736261.03,0.00,0.00,1942.56,637159.68,0.00,0.00,0.00),('1','153','763','171909',3386645,'2132','321',1643436.61,1645111.74,0.00,0.00,1675.13,524488.70,0.00,0.00,0.00),('1','153','763','171909',3386646,'2133','321',736261.03,737556.73,0.00,0.00,1295.70,424989.60,0.00,0.00,0.00),('1','153','763','171918',3386767,'2132','321',1645111.74,1647424.05,0.00,0.00,2312.31,725346.48,0.00,0.00,0.00),('1','153','763','171918',3386768,'2133','321',737556.73,739909.22,0.00,0.00,2352.49,771616.72,0.00,0.00,0.00),('1','153','763','171985',3387938,'2132','321',1647424.05,1648099.46,0.00,0.00,675.41,214050.08,0.00,0.00,0.00),('1','153','763','171985',3387939,'2133','321',739909.22,740809.67,0.00,0.00,900.45,295347.60,0.00,0.00,0.00),('1','153','763','171993',3388013,'2132','321',1648099.46,1649260.60,0.00,0.00,1161.14,361609.94,0.00,0.00,0.00),('1','153','763','171993',3388014,'2133','321',740809.67,741636.66,0.00,0.00,826.99,271252.72,0.00,0.00,0.00),('1','153','763','172195',3391759,'2132','321',1649260.60,1650583.06,0.00,0.00,1322.46,419226.66,0.00,0.00,0.00),('1','153','763','172195',3391760,'2133','321',741636.66,743394.96,0.00,0.00,1758.30,576722.40,0.00,0.00,0.00),('1','153','763','172446',3396434,'2132','321',1650583.06,1651185.85,0.00,0.00,602.79,186864.90,0.00,0.00,0.00),('1','153','763','172446',3396435,'2133','321',743394.96,743998.82,0.00,0.00,603.86,198066.08,0.00,0.00,0.00),('1','153','763','172598',3399032,'2132','321',1651185.85,1652565.08,0.00,0.00,1379.23,431683.12,0.00,0.00,0.00),('1','153','763','172598',3399033,'2133','321',743998.82,745068.16,0.00,0.00,1069.34,350743.52,0.00,0.00,0.00),('1','153','763','172667',3400460,'2132','321',1652565.08,1653677.02,0.00,0.00,1111.94,354128.90,0.00,0.00,0.00),('1','153','763','172667',3400461,'2133','321',745068.16,746920.51,0.00,0.00,1852.35,607570.80,0.00,0.00,0.00),('1','153','763','172928',3405099,'2132','321',1653677.02,1655496.36,0.00,0.00,1819.34,570745.58,0.00,0.00,0.00),('1','153','763','172928',3405100,'2133','321',746920.51,749050.34,0.00,0.00,2129.83,698584.24,0.00,0.00,0.00),('1','153','763','173010',3406737,'2132','321',1655496.36,1656552.76,0.00,0.00,1056.40,330508.72,0.00,0.00,0.00),('1','153','763','173010',3406738,'2133','321',749050.34,750331.48,0.00,0.00,1281.14,420213.92,0.00,0.00,0.00),('1','153','763','173265',3411658,'2132','321',1656552.76,1657297.53,0.00,0.00,744.77,230878.70,0.00,0.00,0.00),('1','153','763','173265',3411659,'2133','321',750331.48,751170.89,0.00,0.00,839.41,274618.54,0.00,0.00,0.00),('1','153','763','173305',3412467,'2132','321',1657297.53,1659596.04,0.00,0.00,2298.51,728025.84,0.00,0.00,0.00),('1','153','763','173305',3412468,'2133','321',751170.89,753072.34,0.00,0.00,1901.45,623675.60,0.00,0.00,0.00),('1','153','763','173545',3416963,'2132','321',1659596.04,1663149.72,0.00,0.00,3553.68,1118484.84,0.00,0.00,0.00),('1','153','763','173545',3416964,'2133','321',753072.34,756161.52,0.00,0.00,3089.18,1013251.04,0.00,0.00,0.00),('1','153','763','173668',3418972,'2132','321',1663149.72,1665265.18,0.00,0.00,2115.46,670110.34,0.00,0.00,0.00),('1','153','763','173668',3418973,'2133','321',756161.52,758322.05,0.00,0.00,2160.53,708653.84,0.00,0.00,0.00),('1','153','763','173742',3420542,'2132','321',1665265.18,1666149.55,0.00,0.00,884.37,278667.66,0.00,0.00,0.00),('1','153','763','173742',3420543,'2133','321',758322.05,759268.71,0.00,0.00,946.66,310504.48,0.00,0.00,0.00),('1','153','763','173837',3422193,'2132','321',1666149.55,1667524.81,0.00,0.00,1375.26,432494.70,0.00,0.00,0.00),('1','153','763','173837',3422194,'2133','321',759268.71,760600.49,0.00,0.00,1331.78,436823.84,0.00,0.00,0.00),('1','153','763','174112',3427143,'2132','321',1667524.81,1669652.52,0.00,0.00,2127.71,669835.88,0.00,0.00,0.00),('1','153','763','174112',3427144,'2133','321',760600.49,762323.24,0.00,0.00,1722.75,565062.00,0.00,0.00,0.00),('1','153','763','174119',3427269,'2132','321',1669652.52,1670183.60,0.00,0.00,531.08,167918.72,0.00,0.00,0.00),('1','153','763','174119',3427270,'2133','321',762323.24,762671.61,0.00,0.00,348.37,114265.36,0.00,0.00,0.00),('1','153','763','174156',3427672,'2132','321',1670183.60,1672470.16,0.00,0.00,2286.56,721681.10,0.00,0.00,0.00),('1','153','763','174156',3427673,'2133','321',762671.61,764978.59,0.00,0.00,2306.98,756689.44,0.00,0.00,0.00),('1','153','763','174507',3433989,'2132','321',1672470.16,1675289.02,0.00,0.00,2818.86,885167.70,0.00,0.00,0.00),('1','153','763','174507',3433990,'2133','321',764978.59,767488.19,0.00,0.00,2509.60,823148.80,0.00,0.00,0.00),('1','153','763','175029',3443866,'2132','321',1675289.02,1675849.66,0.00,0.00,560.64,177049.92,0.00,0.00,0.00),('1','153','763','175029',3443867,'2133','321',767488.19,767971.66,0.00,0.00,483.47,158578.16,0.00,0.00,0.00),('1','153','763','175035',3443928,'2132','321',1675849.66,1677987.63,0.00,0.00,2137.97,671009.84,0.00,0.00,0.00),('1','153','763','175035',3443929,'2133','321',767971.66,769935.68,0.00,0.00,1964.02,644198.56,0.00,0.00,0.00),('1','153','763','175040',3443988,'2132','321',1677987.63,1679426.42,0.00,0.00,1438.79,451535.60,0.00,0.00,0.00),('1','153','763','175040',3443989,'2133','321',769935.68,771271.30,0.00,0.00,1335.62,438083.36,0.00,0.00,0.00),('1','153','763','175063',3444225,'2132','321',1679426.42,1680958.56,0.00,0.00,1532.14,479452.06,0.00,0.00,0.00),('1','153','763','175063',3444226,'2133','321',771271.30,772679.30,0.00,0.00,1408.00,461824.00,0.00,0.00,0.00),('1','153','763','175176',3446307,'2132','321',1680958.56,1682804.45,0.00,0.00,1845.89,572225.90,0.00,0.00,0.00),('1','153','763','175176',3446308,'2133','321',772679.30,774229.88,0.00,0.00,1550.58,506999.76,0.00,0.00,0.00),('1','153','763','175196',3446778,'2132','321',1682804.45,1683746.32,0.00,0.00,941.87,296526.14,0.00,0.00,0.00),('1','153','763','175196',3446779,'2133','321',774229.88,775242.32,0.00,0.00,1012.44,332080.32,0.00,0.00,0.00),('1','153','763','175214',3447117,'2132','321',1683746.32,1686436.87,0.00,0.00,2690.55,868358.50,0.00,0.00,0.00),('1','153','763','175214',3447118,'2133','321',775242.32,777340.74,0.00,0.00,2098.42,738643.84,0.00,0.00,0.00),('1','153','763','175309',3448764,'2132','321',1686436.87,1688759.12,0.00,0.00,2322.25,742528.68,0.00,0.00,0.00),('1','153','763','175309',3448765,'2133','321',777340.74,779754.31,0.00,0.00,2413.57,849576.64,0.00,0.00,0.00),('1','153','763','175454',3451344,'2132','321',1688759.12,1689616.21,0.00,0.00,857.09,281501.72,0.00,0.00,0.00),('1','153','763','175454',3451345,'2133','321',779754.31,780566.74,0.00,0.00,812.43,285975.36,0.00,0.00,0.00),('1','153','763','175472',3451732,'2132','321',1689616.21,1690968.47,0.00,0.00,1352.26,439346.42,0.00,0.00,0.00),('1','153','763','175472',3451733,'2133','321',780566.74,781694.48,0.00,0.00,1127.74,396964.48,0.00,0.00,0.00),('1','153','763','175783',3457329,'2132','321',1690968.47,1692502.44,0.00,0.00,1533.97,485201.72,0.00,0.00,0.00),('1','153','763','175783',3457330,'2133','321',781694.48,783314.59,0.00,0.00,1620.11,570278.72,0.00,0.00,0.00),('1','153','763','175823',3458082,'2132','321',1692502.44,1693430.15,0.00,0.00,927.71,299979.76,0.00,0.00,0.00),('1','153','763','175823',3458083,'2133','321',783314.59,784354.55,0.00,0.00,1039.96,366065.92,0.00,0.00,0.00),('1','153','763','176061',3462293,'2132','321',1693430.15,1696295.55,0.00,0.00,2865.40,917498.70,0.00,0.00,0.00),('1','153','763','176061',3462294,'2133','321',784354.55,786648.86,0.00,0.00,2294.31,807597.12,0.00,0.00,0.00),('1','153','763','176074',3462581,'2132','321',1696295.55,1699497.66,0.00,0.00,3202.11,1033432.44,0.00,0.00,0.00),('1','153','763','176074',3462582,'2133','321',786648.86,789776.18,0.00,0.00,3127.32,1100816.64,0.00,0.00,0.00),('1','153','763','176534',3471333,'2132','321',1699497.66,1703580.23,0.00,0.00,4082.57,1301179.30,0.00,0.00,0.00),('1','153','763','176534',3471334,'2133','321',789776.18,792448.43,0.00,0.00,2672.25,940632.00,0.00,0.00,0.00),('1','153','763','176556',3471643,'2132','321',1703580.23,1705798.52,0.00,0.00,2218.29,696543.06,0.00,0.00,0.00),('1','153','763','176556',3471644,'2133','321',792448.43,794565.11,0.00,0.00,2116.68,731945.78,0.00,0.00,0.00),('1','153','763','176558',3471647,'2132','321',1705798.52,1707246.43,0.00,0.00,1447.91,460615.06,0.00,0.00,0.00),('1','153','763','176558',3471648,'2133','321',794565.11,796028.50,0.00,0.00,1463.39,515113.28,0.00,0.00,0.00),('1','153','763','176931',3478579,'2132','321',1707246.43,1709204.71,0.00,0.00,1958.28,623394.84,0.00,0.00,0.00),('1','153','763','176931',3478580,'2133','321',796028.50,797458.47,0.00,0.00,1429.97,503349.44,0.00,0.00,0.00),('1','153','763','177027',3480008,'2132','321',1709204.71,1710887.05,0.00,0.00,1682.34,541782.76,0.00,0.00,0.00),('1','153','763','177027',3480009,'2133','321',797458.47,798679.32,0.00,0.00,1220.85,429739.20,0.00,0.00,0.00),('1','153','763','177221',3484166,'2132','321',1710887.05,1713132.61,0.00,0.00,2245.56,714088.08,0.00,0.00,0.00),('1','153','763','177221',3484167,'2133','321',798679.32,799931.48,0.00,0.00,1252.16,440760.32,0.00,0.00,0.00),('1','153','763','177222',3484168,'2132','321',1713132.61,1715403.83,0.00,0.00,2271.22,722247.96,0.00,0.00,0.00),('1','153','763','177222',3484169,'2133','321',799931.48,802880.51,0.00,0.00,2949.03,1038058.56,0.00,0.00,0.00),('1','153','763','177307',3485733,'2132','321',1715403.83,1716173.56,0.00,0.00,769.73,244774.14,0.00,0.00,0.00),('1','153','763','177307',3485734,'2133','321',802880.51,803895.42,0.00,0.00,1014.91,357248.32,0.00,0.00,0.00),('1','153','763','177531',3490623,'2132','321',1716173.56,1717076.49,0.00,0.00,902.93,301174.42,0.00,0.00,0.00),('1','153','763','177531',3490624,'2133','321',803895.42,804937.77,0.00,0.00,1042.35,366907.20,0.00,0.00,0.00),('1','153','763','177794',3495275,'2132','321',1717076.49,1719179.79,0.00,0.00,2103.30,668849.40,0.00,0.00,0.00),('1','153','763','177794',3495276,'2133','321',804937.77,806908.62,0.00,0.00,1970.85,693739.20,0.00,0.00,0.00),('1','153','763','177810',3495607,'2132','321',1719179.79,1722043.49,0.00,0.00,2863.70,914249.20,0.00,0.00,0.00),('1','153','763','177810',3495608,'2133','321',806908.62,809252.30,0.00,0.00,2343.68,806225.92,0.00,0.00,0.00),('1','153','763','177888',3496924,'2132','321',1722043.49,1722159.64,0.00,0.00,116.15,36471.10,0.00,0.00,0.00),('1','153','763','177888',3496925,'2133','321',809252.30,810081.45,0.00,0.00,829.15,285227.60,0.00,0.00,0.00),('1','153','763','178214',3503251,'2132','321',1722159.64,1724462.43,0.00,0.00,2302.79,726816.46,0.00,0.00,0.00),('1','153','763','178214',3503252,'2133','321',810081.45,811722.95,0.00,0.00,1641.50,564676.00,0.00,0.00,0.00),('1','153','763','178228',3503513,'2132','321',1724462.43,1725809.91,0.00,0.00,1347.48,432450.12,0.00,0.00,0.00),('1','153','763','178228',3503514,'2133','321',811722.95,812759.94,0.00,0.00,1036.99,356724.56,0.00,0.00,0.00),('1','153','763','178236',3503691,'2132','321',1725809.91,1727003.56,0.00,0.00,1193.65,374806.10,0.00,0.00,0.00),('1','153','763','178236',3503692,'2133','321',812759.94,813838.59,0.00,0.00,1078.65,371055.60,0.00,0.00,0.00),('1','153','763','178331',3505307,'2132','321',1727003.56,1729224.15,0.00,0.00,2220.59,712543.98,0.00,0.00,0.00),('1','153','763','178331',3505308,'2133','321',813838.59,816395.55,0.00,0.00,2556.96,879594.24,0.00,0.00,0.00),('1','153','763','178491',3508349,'2132','321',1729224.15,1731364.23,0.00,0.00,2140.08,713835.54,0.00,0.00,0.00),('1','153','763','178491',3508350,'2133','321',816395.55,819200.08,0.00,0.00,2804.53,983810.48,0.00,0.00,0.00),('1','153','763','178741',3512826,'2132','321',1731364.23,1732990.36,0.00,0.00,1626.13,550145.30,0.00,0.00,0.00),('1','153','763','178741',3512827,'2133','321',819200.08,821460.80,0.00,0.00,2260.72,795773.44,0.00,0.00,0.00),('1','153','763','178911',3515875,'2132','321',1732990.36,1734326.17,0.00,0.00,1335.81,454454.88,0.00,0.00,0.00),('1','153','763','178911',3515876,'2133','321',821460.80,823863.95,0.00,0.00,2403.15,845908.80,0.00,0.00,0.00),('1','153','763','179139',3520237,'2132','321',1734326.17,1736032.25,0.00,0.00,1706.08,580067.20,0.00,0.00,0.00),('1','153','763','179139',3520238,'2133','321',823863.95,826526.98,0.00,0.00,2663.03,937386.56,0.00,0.00,0.00),('1','153','763','179363',3524643,'2132','321',1736032.25,1736325.37,0.00,0.00,293.12,99777.60,0.00,0.00,0.00),('1','153','763','179363',3524644,'2133','321',826526.98,827518.10,0.00,0.00,991.12,357258.96,0.00,0.00,0.00),('1','153','763','179538',3527879,'2132','321',1736325.37,1737211.84,0.00,0.00,886.47,301699.80,0.00,0.00,0.00),('1','153','763','179538',3527880,'2133','321',827518.10,828680.94,0.00,0.00,1162.84,418622.40,0.00,0.00,0.00),('1','153','763','179567',3528428,'2132','321',1737211.84,1738625.46,0.00,0.00,1413.62,481231.00,0.00,0.00,0.00),('1','153','763','179567',3528429,'2133','321',828680.94,831221.34,0.00,0.00,2540.40,913577.68,0.00,0.00,0.00),('1','153','763','179766',3532373,'2132','321',1738625.46,1739899.75,0.00,0.00,1274.29,433383.60,0.00,0.00,0.00),('1','153','763','179766',3532374,'2133','321',831221.34,833900.10,0.00,0.00,2678.76,949002.88,0.00,0.00,0.00),('1','153','763','179986',3536361,'2132','321',1739899.75,1741031.66,0.00,0.00,1131.91,384849.40,0.00,0.00,0.00),('1','153','763','179986',3536362,'2133','321',833900.10,835190.50,0.00,0.00,1290.40,465104.00,0.00,0.00,0.00),('1','153','763','180082',3537982,'2132','321',1741031.66,1741731.81,0.00,0.00,700.15,238051.00,0.00,0.00,0.00),('1','153','763','180082',3537983,'2133','321',835190.50,836556.90,0.00,0.00,1366.40,495144.00,0.00,0.00,0.00),('1','153','763','180171',3539897,'2132','321',1741731.81,1742840.37,0.00,0.00,1108.56,377216.00,0.00,0.00,0.00),('1','153','763','180171',3539898,'2133','321',836556.90,838303.29,0.00,0.00,1746.39,632738.16,0.00,0.00,0.00),('1','153','763','180418',3544216,'2132','321',1742840.37,1743788.07,0.00,0.00,947.70,322218.00,0.00,0.00,0.00),('1','153','763','180418',3544217,'2133','321',838303.29,839211.03,0.00,0.00,907.74,326786.40,0.00,0.00,0.00),('1','153','763','180430',3544433,'2132','321',1743788.07,1744934.92,0.00,0.00,1146.85,389990.20,0.00,0.00,0.00),('1','153','763','180430',3544434,'2133','321',839211.03,841722.61,0.00,0.00,2511.58,908308.80,0.00,0.00,0.00),('1','153','763','180545',3546680,'2132','321',1744934.92,1746332.07,0.00,0.00,1397.15,475236.40,0.00,0.00,0.00),('1','153','763','180545',3546681,'2133','321',841722.61,844214.60,0.00,0.00,2491.99,897116.40,0.00,0.00,0.00),('1','153','763','180731',3550043,'2132','321',1746332.07,1748375.78,0.00,0.00,2043.71,694861.40,0.00,0.00,0.00),('1','153','763','180731',3550044,'2133','321',844214.60,846810.72,0.00,0.00,2596.12,934603.20,0.00,0.00,0.00),('1','153','763','180954',3554386,'2132','321',1748375.78,1750380.84,0.00,0.00,2005.06,701356.00,0.00,0.00,0.00),('1','153','763','180954',3554387,'2133','321',846810.72,848625.89,0.00,0.00,1815.17,653461.20,0.00,0.00,0.00),('1','153','763','181138',3557675,'2132','321',1750380.84,1752098.93,0.00,0.00,1718.09,584150.60,0.00,0.00,0.00),('1','153','763','181138',3557676,'2133','321',848625.89,851043.90,0.00,0.00,2418.01,870483.60,0.00,0.00,0.00),('1','153','763','181360',3562039,'2132','321',1752098.93,1753080.40,0.00,0.00,981.47,335325.80,0.00,0.00,0.00),('1','153','763','181360',3562040,'2133','321',851043.90,852723.10,0.00,0.00,1679.20,604512.00,0.00,0.00,0.00),('1','153','763','181538',3565212,'2132','321',1753080.40,1754893.92,0.00,0.00,1813.52,618802.80,0.00,0.00,0.00),('1','153','763','181538',3565213,'2133','321',852723.10,855686.57,0.00,0.00,2963.47,1063900.40,0.00,0.00,0.00),('1','153','763','181707',3568177,'2132','321',1754893.92,1755161.93,0.00,0.00,268.01,91245.60,0.00,0.00,0.00),('1','153','763','181707',3568178,'2133','321',855686.57,856938.56,0.00,0.00,1251.99,450716.40,0.00,0.00,0.00),('1','153','763','181789',3569636,'2132','321',1755161.93,1756231.89,0.00,0.00,1069.96,363847.60,0.00,0.00,0.00),('1','153','763','181789',3569637,'2133','321',856938.56,858064.73,0.00,0.00,1126.17,405421.20,0.00,0.00,0.00),('1','153','763','181901',3571511,'2132','321',1756231.89,1757854.62,0.00,0.00,1622.73,551728.20,0.00,0.00,0.00),('1','153','763','181901',3571512,'2133','321',858064.73,860669.20,0.00,0.00,2604.47,936869.20,0.00,0.00,0.00),('1','153','763','182119',3575600,'2132','321',1757854.62,1760128.21,0.00,0.00,2273.59,773187.20,0.00,0.00,0.00),('1','153','763','182119',3575601,'2133','321',860669.20,863169.64,0.00,0.00,2500.44,898958.40,0.00,0.00,0.00),('1','153','763','182306',3578876,'2132','321',1760128.21,1761821.66,0.00,0.00,1693.45,589788.20,0.00,0.00,0.00),('1','153','763','182306',3578877,'2133','321',863169.64,866060.92,0.00,0.00,2891.28,1040860.80,0.00,0.00,0.00),('1','153','763','182490',3582287,'2132','321',1761821.66,1764180.02,0.00,0.00,2358.36,821456.20,0.00,0.00,0.00),('1','153','763','182490',3582288,'2133','321',866060.92,868220.82,0.00,0.00,2159.90,777564.00,0.00,0.00,0.00),('1','153','763','182746',3586948,'2132','321',1764180.02,1765616.22,0.00,0.00,1436.20,490711.40,0.00,0.00,0.00),('1','153','763','182746',3586949,'2133','321',868220.82,870841.20,0.00,0.00,2620.38,943336.80,0.00,0.00,0.00),('1','153','763','182830',3588647,'2132','321',1765616.22,1765917.58,0.00,0.00,301.36,102462.40,0.00,0.00,0.00),('1','153','763','182830',3588648,'2133','321',870841.20,872893.17,0.00,0.00,2051.97,738709.20,0.00,0.00,0.00),('1','153','763','182979',3591381,'2132','321',1765917.58,1767369.53,0.00,0.00,1451.95,493663.00,0.00,0.00,0.00),('1','153','763','182979',3591382,'2133','321',872893.17,873242.76,0.00,0.00,349.59,125852.40,0.00,0.00,0.00),('1','153','763','182983',3591396,'2132','321',1767369.53,1769304.44,0.00,0.00,1934.91,672420.00,0.00,0.00,0.00),('1','153','763','182983',3591397,'2133','321',873242.76,875082.94,0.00,0.00,1840.18,662464.80,0.00,0.00,0.00),('1','153','763','183206',3595520,'2132','321',1769304.44,1769852.70,0.00,0.00,548.26,186408.40,0.00,0.00,0.00),('1','153','763','183206',3595521,'2133','321',875082.94,875829.45,0.00,0.00,746.51,268743.60,0.00,0.00,0.00),('1','153','763','183302',3596931,'2132','321',1769852.70,1770868.04,0.00,0.00,1015.34,347229.80,0.00,0.00,0.00),('1','153','763','183302',3596932,'2133','321',875829.45,877242.08,0.00,0.00,1412.63,508546.80,0.00,0.00,0.00),('1','153','763','183421',3599378,'2132','321',1770868.04,1772063.88,0.00,0.00,1195.84,406730.00,0.00,0.00,0.00),('1','153','763','183421',3599379,'2133','321',877242.08,879574.04,0.00,0.00,2331.96,836005.60,0.00,0.00,0.00),('1','153','763','183635',3603240,'2132','321',1772063.88,1773042.73,0.00,0.00,978.85,333009.00,0.00,0.00,0.00),('1','153','763','183635',3603241,'2133','321',879574.04,880747.12,0.00,0.00,1173.08,422308.80,0.00,0.00,0.00),('1','153','763','183814',3606410,'2132','321',1773042.73,1773564.65,0.00,0.00,521.92,177452.80,0.00,0.00,0.00),('1','153','763','183814',3606411,'2133','321',880747.12,881854.45,0.00,0.00,1107.33,391638.80,0.00,0.00,0.00),('1','153','763','183864',3607508,'2132','321',1773564.65,1774043.12,0.00,0.00,478.47,162957.80,0.00,0.00,0.00),('1','153','763','183864',3607509,'2133','321',881854.45,882971.41,0.00,0.00,1116.96,402105.60,0.00,0.00,0.00),('1','153','763','184096',3611533,'2132','321',1774043.12,1774573.25,0.00,0.00,530.13,181607.20,0.00,0.00,0.00),('1','153','763','184096',3611534,'2133','321',882971.41,883943.63,0.00,0.00,972.22,349999.20,0.00,0.00,0.00),('1','153','763','184146',3612381,'2132','321',1774573.25,1777008.60,0.00,0.00,2435.35,876726.00,0.00,0.00,0.00),('1','153','763','184146',3612382,'2133','321',883943.63,884628.87,0.00,0.00,685.24,234675.10,0.00,0.00,0.00),('1','153','763','184278',3614730,'2132','321',1777008.60,1777943.58,0.00,0.00,934.98,336592.80,0.00,0.00,0.00),('1','153','763','184278',3614731,'2133','321',884628.87,885126.86,0.00,0.00,497.99,170405.60,0.00,0.00,0.00),('1','153','763','184380',3616479,'2132','321',1777943.58,1778598.33,0.00,0.00,654.75,235710.00,0.00,0.00,0.00),('1','153','763','184380',3616480,'2133','321',885126.86,885701.32,0.00,0.00,574.46,198038.60,0.00,0.00,0.00),('1','153','763','184464',3618048,'2132','321',1778598.33,1779527.50,0.00,0.00,929.17,330945.60,0.00,0.00,0.00),('1','153','763','184464',3618049,'2133','321',885701.32,887329.45,0.00,0.00,1628.13,580122.20,0.00,0.00,0.00),('1','153','763','184670',3621928,'2132','321',1779527.50,1780304.44,0.00,0.00,776.94,264159.60,0.00,0.00,0.00),('1','153','763','184670',3621929,'2133','321',887329.45,888787.89,0.00,0.00,1458.44,524138.40,0.00,0.00,0.00),('1','153','763','184813',3624483,'2132','321',1780304.44,1780900.38,0.00,0.00,595.94,205992.40,0.00,0.00,0.00),('1','153','763','184813',3624484,'2133','321',888787.89,889191.02,0.00,0.00,403.13,145126.80,0.00,0.00,0.00),('1','153','763','184866',3625470,'2132','321',1780900.38,1781525.68,0.00,0.00,625.30,212602.00,0.00,0.00,0.00),('1','153','763','184866',3625471,'2133','321',889191.02,891109.34,0.00,0.00,1918.32,687336.00,0.00,0.00,0.00),('1','153','763','185092',3629329,'2132','321',1781525.68,1782699.46,0.00,0.00,1173.78,404728.20,0.00,0.00,0.00),('1','153','763','185092',3629330,'2133','321',891109.34,892965.11,0.00,0.00,1855.77,667577.20,0.00,0.00,0.00),('1','153','763','185252',3631852,'2132','321',1782699.46,1783150.24,0.00,0.00,450.78,154694.00,0.00,0.00,0.00),('1','153','763','185252',3631853,'2133','321',892965.11,895006.91,0.00,0.00,2041.80,733619.20,0.00,0.00,0.00),('1','153','763','185455',3635702,'2132','321',1783150.24,1784306.58,0.00,0.00,1156.34,396419.80,0.00,0.00,0.00),('1','153','763','185455',3635703,'2133','321',895006.91,896759.82,0.00,0.00,1752.91,631047.60,0.00,0.00,0.00),('1','153','763','185665',3639433,'2132','321',1784306.58,1784675.19,0.00,0.00,368.61,125577.40,0.00,0.00,0.00),('1','153','763','185665',3639434,'2133','321',896759.82,897552.66,0.00,0.00,792.84,285422.40,0.00,0.00,0.00),('1','153','763','185769',3641005,'2132','321',1784675.19,1785026.38,0.00,0.00,351.19,119654.60,0.00,0.00,0.00),('1','153','763','185769',3641006,'2133','321',897552.66,898845.62,0.00,0.00,1292.96,465465.60,0.00,0.00,0.00),('1','153','763','185895',3643335,'2132','321',1785026.38,1785686.89,0.00,0.00,660.51,227985.60,0.00,0.00,0.00),('1','153','763','185895',3643336,'2133','321',898845.62,900657.10,0.00,0.00,1811.48,652132.80,0.00,0.00,0.00),('1','153','763','186070',3646700,'2132','321',1785686.89,1786023.85,0.00,0.00,336.96,115160.80,0.00,0.00,0.00),('1','153','763','186070',3646701,'2133','321',900657.10,902495.72,0.00,0.00,1838.62,661243.60,0.00,0.00,0.00),('1','153','763','186305',3650617,'2132','321',1786023.85,1786585.94,0.00,0.00,562.09,192884.40,0.00,0.00,0.00),('1','153','763','186305',3650618,'2133','321',902495.72,904128.43,0.00,0.00,1632.71,587775.60,0.00,0.00,0.00),('1','153','763','186519',3654273,'2132','321',1786585.94,1786992.30,0.00,0.00,406.36,138384.80,0.00,0.00,0.00),('1','153','763','186519',3654274,'2133','321',904128.43,906038.53,0.00,0.00,1910.10,687636.00,0.00,0.00,0.00),('1','153','763','186737',3658001,'2132','321',1786992.30,1787683.60,0.00,0.00,691.30,244476.00,0.00,0.00,0.00),('1','153','763','186737',3658002,'2133','321',906038.53,907426.58,0.00,0.00,1388.05,499698.00,0.00,0.00,0.00),('1','153','763','186967',3661779,'2132','321',1787683.60,1788447.97,0.00,0.00,764.37,267583.40,0.00,0.00,0.00),('1','153','763','186967',3661780,'2133','321',907426.58,909237.54,0.00,0.00,1810.96,651945.60,0.00,0.00,0.00),('1','153','763','187149',3664917,'2132','321',1788447.97,1790148.12,0.00,0.00,1700.15,594161.80,0.00,0.00,0.00),('1','153','763','187149',3664918,'2133','321',909237.54,911008.94,0.00,0.00,1771.40,635954.00,0.00,0.00,0.00),('1','153','763','187335',3668278,'2132','321',1790148.12,1791093.66,0.00,0.00,945.54,329470.40,0.00,0.00,0.00),('1','153','763','187335',3668279,'2133','321',911008.94,912806.72,0.00,0.00,1797.78,647200.80,0.00,0.00,0.00),('1','153','763','187561',3672290,'2132','321',1791093.66,1792248.33,0.00,0.00,1154.67,404446.20,0.00,0.00,0.00),('1','153','763','187561',3672291,'2133','321',912806.72,914633.29,0.00,0.00,1826.57,657565.20,0.00,0.00,0.00),('1','153','763','187784',3676273,'2132','321',1792248.33,1792248.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','187784',3676274,'2133','321',914633.29,914889.53,0.00,0.00,256.24,92246.40,0.00,0.00,0.00),('1','153','763','187863',3677436,'2132','321',1792248.33,1793075.63,0.00,0.00,827.30,290009.80,0.00,0.00,0.00),('1','153','763','187863',3677437,'2133','321',914889.53,916867.68,0.00,0.00,1978.15,712134.00,0.00,0.00,0.00),('1','153','763','188029',3680374,'2132','321',1793075.63,1794510.91,0.00,0.00,1435.28,508016.40,0.00,0.00,0.00),('1','153','763','188029',3680375,'2133','321',916867.68,919018.92,0.00,0.00,2151.24,773060.60,0.00,0.00,0.00),('1','153','763','188209',3683574,'2132','321',1794510.91,1795153.00,0.00,0.00,642.09,226182.40,0.00,0.00,0.00),('1','153','763','188209',3683575,'2133','321',919018.92,920144.58,0.00,0.00,1125.66,405237.60,0.00,0.00,0.00),('1','153','763','188358',3686055,'2132','321',1795153.00,1795985.14,0.00,0.00,832.14,295282.40,0.00,0.00,0.00),('1','153','763','188358',3686056,'2133','321',920144.58,921163.64,0.00,0.00,1019.06,366861.60,0.00,0.00,0.00),('1','153','763','188405',3687039,'2132','321',1795985.14,1797071.99,0.00,0.00,1086.85,385023.20,0.00,0.00,0.00),('1','153','763','188405',3687040,'2133','321',921163.64,922917.82,0.00,0.00,1754.18,630504.80,0.00,0.00,0.00),('1','153','763','188594',3690302,'2132','321',1797071.99,1797456.34,0.00,0.00,384.35,135013.20,0.00,0.00,0.00),('1','153','763','188594',3690303,'2133','321',922917.82,924000.46,0.00,0.00,1082.64,389750.40,0.00,0.00,0.00),('1','153','763','188699',3692009,'2132','321',1797456.34,1798061.45,0.00,0.00,605.11,211587.40,0.00,0.00,0.00),('1','153','763','188699',3692010,'2133','321',924000.46,925125.11,0.00,0.00,1124.65,404874.00,0.00,0.00,0.00),('1','153','763','188841',3694427,'2132','321',1798061.45,1799753.26,0.00,0.00,1691.81,583063.24,0.00,0.00,0.00),('1','153','763','188841',3694428,'2133','321',925125.11,927156.45,0.00,0.00,2031.34,731282.40,0.00,0.00,0.00),('1','153','763','188990',3697405,'2132','321',1799753.26,1799908.15,0.00,0.00,154.89,55760.40,0.00,0.00,0.00),('1','153','763','188990',3697406,'2133','321',927156.45,927647.30,0.00,0.00,490.85,176706.00,0.00,0.00,0.00),('1','153','763','189072',3698659,'2132','321',1799908.15,1801615.60,0.00,0.00,1707.45,589289.04,0.00,0.00,0.00),('1','153','763','189072',3698660,'2133','321',927647.30,929248.30,0.00,0.00,1601.00,576360.00,0.00,0.00,0.00),('1','153','763','189188',3700919,'2132','321',1801615.60,1803109.37,0.00,0.00,1493.77,512776.32,0.00,0.00,0.00),('1','153','763','189188',3700920,'2133','321',929248.30,930786.71,0.00,0.00,1538.41,553827.60,0.00,0.00,0.00),('1','153','763','189396',3704808,'2132','321',1803109.37,1803577.47,0.00,0.00,468.10,159165.60,0.00,0.00,0.00),('1','153','763','189396',3704809,'2133','321',930786.71,931356.42,0.00,0.00,569.71,205095.60,0.00,0.00,0.00),('1','153','763','189401',3704869,'2132','321',1803577.47,1805344.09,0.00,0.00,1766.62,603211.20,0.00,0.00,0.00),('1','153','763','189401',3704870,'2133','321',931356.42,933766.21,0.00,0.00,2409.79,866780.40,0.00,0.00,0.00),('1','153','763','189607',3708383,'2132','321',1805344.09,1806449.39,0.00,0.00,1105.30,378262.32,0.00,0.00,0.00),('1','153','763','189607',3708384,'2133','321',933766.21,934821.53,0.00,0.00,1055.32,379915.20,0.00,0.00,0.00),('1','153','763','189728',3710228,'2132','321',1806449.39,1807509.27,0.00,0.00,1059.88,362223.84,0.00,0.00,0.00),('1','153','763','189728',3710229,'2133','321',934821.53,935741.00,0.00,0.00,919.47,331009.20,0.00,0.00,0.00),('1','153','763','189802',3711828,'2132','321',1807509.27,1809495.77,0.00,0.00,1986.50,686071.84,0.00,0.00,0.00),('1','153','763','189802',3711829,'2133','321',935741.00,938292.63,0.00,0.00,2551.63,918586.80,0.00,0.00,0.00),('1','153','763','190020',3716162,'2132','321',1809495.77,1811989.72,0.00,0.00,2493.95,847863.36,0.00,0.00,0.00),('1','153','763','190020',3716163,'2133','321',938292.63,940225.13,0.00,0.00,1932.50,695700.00,0.00,0.00,0.00),('1','153','763','190137',3718227,'2132','321',1811989.72,1813225.06,0.00,0.00,1235.34,421119.12,0.00,0.00,0.00),('1','153','763','190137',3718228,'2133','321',940225.13,941476.62,0.00,0.00,1251.49,448136.40,0.00,0.00,0.00),('1','153','763','190196',3719553,'2132','321',1813225.06,1816383.06,0.00,0.00,3158.00,1070577.84,0.00,0.00,0.00),('1','153','763','190196',3719554,'2133','321',941476.62,943676.13,0.00,0.00,2199.51,791823.60,0.00,0.00,0.00),('1','153','763','190384',3722916,'2132','321',1816383.06,1817381.68,0.00,0.00,998.62,342354.96,0.00,0.00,0.00),('1','153','763','190384',3722917,'2133','321',943676.13,944508.39,0.00,0.00,832.26,299613.60,0.00,0.00,0.00),('1','153','763','190419',3723658,'2132','321',1817381.68,1820119.24,0.00,0.00,2737.56,943418.40,0.00,0.00,0.00),('1','153','763','190419',3723659,'2133','321',944508.39,947977.00,0.00,0.00,3468.61,1225836.24,0.00,0.00,0.00),('1','153','763','190663',3728121,'2132','321',1820119.24,1822041.90,0.00,0.00,1922.66,669211.20,0.00,0.00,0.00),('1','153','763','190663',3728122,'2133','321',947977.00,948000.29,0.00,0.00,23.29,8384.40,0.00,0.00,0.00),('1','153','763','190666',3728157,'2132','321',1822041.90,1825527.71,0.00,0.00,3485.81,1189180.56,0.00,0.00,0.00),('1','153','763','190666',3728158,'2133','321',948000.29,950508.57,0.00,0.00,2508.28,900580.80,0.00,0.00,0.00),('1','153','763','190879',3732111,'2132','321',1825527.71,1826174.50,0.00,0.00,646.79,222320.40,0.00,0.00,0.00),('1','153','763','190879',3732112,'2133','321',950508.57,951296.66,0.00,0.00,788.09,280712.40,0.00,0.00,0.00),('1','153','763','191004',3734120,'2132','321',1826174.50,1827495.79,0.00,0.00,1321.29,458595.60,0.00,0.00,0.00),('1','153','763','191004',3734121,'2133','321',951296.66,952691.85,0.00,0.00,1395.19,502268.40,0.00,0.00,0.00),('1','153','763','191113',3736005,'2132','321',1827495.79,1829588.53,0.00,0.00,2092.74,721579.92,0.00,0.00,0.00),('1','153','763','191113',3736006,'2133','321',952691.85,954572.40,0.00,0.00,1880.55,676998.00,0.00,0.00,0.00),('1','153','763','191263',3738895,'2132','321',1829588.53,1829874.16,0.00,0.00,285.63,95971.68,0.00,0.00,0.00),('1','153','763','191263',3738896,'2133','321',954572.40,954968.36,0.00,0.00,395.96,142545.60,0.00,0.00,0.00),('1','153','763','191304',3739395,'2132','321',1829874.16,1832411.10,0.00,0.00,2536.94,859418.40,0.00,0.00,0.00),('1','153','763','191304',3739396,'2133','321',954968.36,957163.21,0.00,0.00,2194.85,781002.00,0.00,0.00,0.00),('1','153','763','191490',3742915,'2132','321',1832411.10,1833151.37,0.00,0.00,740.27,248804.16,0.00,0.00,0.00),('1','153','763','191490',3742916,'2133','321',957163.21,957862.09,0.00,0.00,698.88,251596.80,0.00,0.00,0.00),('1','153','763','191574',3744286,'2132','321',1833151.37,1834944.79,0.00,0.00,1793.42,618180.00,0.00,0.00,0.00),('1','153','763','191574',3744287,'2133','321',957862.09,959372.84,0.00,0.00,1510.75,543870.00,0.00,0.00,0.00),('1','153','763','191698',3747077,'2132','321',1834944.79,1836634.10,0.00,0.00,1689.31,578830.80,0.00,0.00,0.00),('1','153','763','191698',3747078,'2133','321',959372.84,961037.58,0.00,0.00,1664.74,599306.40,0.00,0.00,0.00),('1','153','763','191927',3751481,'2132','321',1836634.10,1838256.33,0.00,0.00,1622.23,550486.80,0.00,0.00,0.00),('1','153','763','191927',3751482,'2133','321',961037.58,962954.87,0.00,0.00,1917.29,690224.40,0.00,0.00,0.00),('1','153','763','192187',3755854,'2132','321',1838256.33,1838990.90,0.00,0.00,734.57,251785.20,0.00,0.00,0.00),('1','153','763','192187',3755855,'2133','321',962954.87,963577.14,0.00,0.00,622.27,224017.20,0.00,0.00,0.00),('1','153','763','192236',3756789,'2132','321',1838990.90,1839846.99,0.00,0.00,856.09,287646.24,0.00,0.00,0.00),('1','153','763','192236',3756790,'2133','321',963577.14,964573.21,0.00,0.00,996.07,358585.20,0.00,0.00,0.00),('1','153','763','192330',3758757,'2132','321',1839846.99,1841551.96,0.00,0.00,1704.97,572970.00,0.00,0.00,0.00),('1','153','763','192330',3758758,'2133','321',964573.21,966457.91,0.00,0.00,1884.70,678492.00,0.00,0.00,0.00),('1','153','763','192554',3762815,'2132','321',1841551.96,1841952.03,0.00,0.00,400.07,135726.00,0.00,0.00,0.00),('1','153','763','192554',3762816,'2133','321',966457.91,966900.67,0.00,0.00,442.76,159393.60,0.00,0.00,0.00),('1','153','763','192624',3763760,'2132','321',1841952.03,1843196.49,0.00,0.00,1244.46,423720.00,0.00,0.00,0.00),('1','153','763','192624',3763761,'2133','321',966900.67,968048.36,0.00,0.00,1147.69,413168.40,0.00,0.00,0.00),('1','153','763','192744',3766173,'2132','321',1843196.49,1845402.23,0.00,0.00,2205.74,743361.84,0.00,0.00,0.00),('1','153','763','192744',3766174,'2133','321',968048.36,969992.30,0.00,0.00,1943.94,696218.40,0.00,0.00,0.00),('1','153','763','192946',3769857,'2132','321',1845402.23,1847617.09,0.00,0.00,2214.86,744192.96,0.00,0.00,0.00),('1','153','763','192946',3769858,'2133','321',969992.30,971742.13,0.00,0.00,1749.83,629938.80,0.00,0.00,0.00),('1','153','763','193158',3773893,'2132','321',1847617.09,1849062.81,0.00,0.00,1445.72,498958.32,0.00,0.00,0.00),('1','153','763','193158',3773894,'2133','321',971742.13,973258.80,0.00,0.00,1516.67,546001.20,0.00,0.00,0.00),('1','153','763','193452',3779473,'2132','321',1849062.81,1850506.80,0.00,0.00,1443.99,501584.40,0.00,0.00,0.00),('1','153','763','193452',3779474,'2133','321',973258.80,974309.59,0.00,0.00,1050.79,378284.40,0.00,0.00,0.00),('1','153','763','193614',3782788,'2132','321',1850506.80,1851976.37,0.00,0.00,1469.57,503280.48,0.00,0.00,0.00),('1','153','763','193614',3782789,'2133','321',974309.59,975578.98,0.00,0.00,1269.39,456980.40,0.00,0.00,0.00),('1','153','763','193837',3786779,'2132','321',1851976.37,1852421.41,0.00,0.00,445.04,154617.60,0.00,0.00,0.00),('1','153','763','193837',3786780,'2133','321',975578.98,975865.33,0.00,0.00,286.35,103086.00,0.00,0.00,0.00),('1','153','763','193839',3786783,'2132','321',1852421.41,1852446.41,0.00,0.00,25.00,9000.00,0.00,0.00,0.00),('1','153','763','193839',3786784,'2133','321',975865.33,979006.78,0.00,0.00,3141.45,1108972.80,0.00,0.00,0.00),('1','153','763','194072',3790840,'2132','321',1852446.41,1853272.90,0.00,0.00,826.49,284414.68,0.00,0.00,0.00),('1','153','763','194072',3790841,'2133','321',979006.78,981250.62,0.00,0.00,2243.84,798997.40,0.00,0.00,0.00),('1','153','763','194277',3794745,'2132','321',1853272.90,1854742.10,0.00,0.00,1469.20,505665.84,0.00,0.00,0.00),('1','153','763','194277',3794746,'2133','321',981250.62,983196.90,0.00,0.00,1946.28,700660.80,0.00,0.00,0.00),('1','153','763','194477',3798202,'2132','321',1854742.10,1856319.91,0.00,0.00,1577.81,542427.72,0.00,0.00,0.00),('1','153','763','194477',3798203,'2133','321',983196.90,985266.85,0.00,0.00,2069.95,745182.00,0.00,0.00,0.00),('1','153','763','194659',3801465,'2132','321',1856319.91,1858289.66,0.00,0.00,1969.75,691011.40,0.00,0.00,0.00),('1','153','763','194659',3801466,'2133','321',985266.85,986681.39,0.00,0.00,1414.54,509234.40,0.00,0.00,0.00),('1','153','763','195013',3808211,'2132','321',1858289.66,1859747.34,0.00,0.00,1457.68,497386.80,0.00,0.00,0.00),('1','153','763','195013',3808212,'2133','321',986681.39,988457.88,0.00,0.00,1776.49,639536.40,0.00,0.00,0.00),('1','153','763','195070',3809287,'2132','321',1859747.34,1862001.54,0.00,0.00,2254.20,775418.80,0.00,0.00,0.00),('1','153','763','195070',3809288,'2133','321',988457.88,989969.74,0.00,0.00,1511.86,544269.60,0.00,0.00,0.00),('1','153','763','195292',3813240,'2132','321',1862001.54,1862486.76,0.00,0.00,485.22,162193.48,0.00,0.00,0.00),('1','153','763','195292',3813241,'2133','321',989969.74,990441.80,0.00,0.00,472.06,169941.60,0.00,0.00,0.00),('1','153','763','195509',3817060,'2132','321',1862486.76,1863383.19,0.00,0.00,896.43,299320.74,0.00,0.00,0.00),('1','153','763','195509',3817061,'2133','321',990441.80,991457.42,0.00,0.00,1015.62,353435.76,0.00,0.00,0.00),('1','153','763','195512',3817096,'2132','321',1863383.19,1865047.11,0.00,0.00,1663.92,553775.76,0.00,0.00,0.00),('1','153','763','195512',3817097,'2133','321',991457.42,992957.40,0.00,0.00,1499.98,521993.04,0.00,0.00,0.00),('1','153','763','195766',3821297,'2132','321',1865047.11,1865803.83,0.00,0.00,756.72,255704.76,0.00,0.00,0.00),('1','153','763','195766',3821298,'2133','321',992957.40,993794.37,0.00,0.00,836.97,291265.56,0.00,0.00,0.00),('1','153','763','195915',3823903,'2132','321',1865803.83,1866438.08,0.00,0.00,634.25,212651.94,0.00,0.00,0.00),('1','153','763','195915',3823904,'2133','321',993794.37,994726.22,0.00,0.00,931.85,324283.80,0.00,0.00,0.00),('1','153','763','195991',3825456,'2132','321',1866438.08,1868116.84,0.00,0.00,1678.76,566401.08,0.00,0.00,0.00),('1','153','763','195991',3825457,'2133','321',994726.22,996698.84,0.00,0.00,1972.62,686471.76,0.00,0.00,0.00),('1','153','763','196251',3830165,'2132','321',1868116.84,1868785.31,0.00,0.00,668.47,224882.52,0.00,0.00,0.00),('1','153','763','196251',3830166,'2133','321',996698.84,997354.44,0.00,0.00,655.60,228148.80,0.00,0.00,0.00),('1','153','763','196372',3832488,'2132','321',1868785.31,1869582.60,0.00,0.00,797.29,270431.52,0.00,0.00,0.00),('1','153','763','196372',3832489,'2133','321',997354.44,998409.28,0.00,0.00,1054.84,367084.32,0.00,0.00,0.00),('1','153','763','196436',3833684,'2132','321',1869582.60,1871461.67,0.00,0.00,1879.07,630152.22,0.00,0.00,0.00),('1','153','763','196436',3833685,'2133','321',998409.28,1000534.60,0.00,0.00,2125.32,739611.36,0.00,0.00,0.00),('1','153','763','196653',3837535,'2132','321',1871461.67,1873877.47,0.00,0.00,2415.80,809250.08,0.00,0.00,0.00),('1','153','763','196653',3837536,'2133','321',1000534.60,1002711.15,0.00,0.00,2176.55,757439.40,0.00,0.00,0.00),('1','153','763','197004',3843887,'2132','321',1873877.47,1874999.62,0.00,0.00,1122.15,361332.30,0.00,0.00,0.00),('1','153','763','197004',3843888,'2133','321',1002711.15,1003433.16,0.00,0.00,722.01,251259.48,0.00,0.00,0.00),('1','153','763','197017',3844138,'2132','321',1874999.62,1877539.54,0.00,0.00,2539.92,826350.52,0.00,0.00,0.00),('1','153','763','197017',3844139,'2133','321',1003433.16,1005501.61,0.00,0.00,2068.45,717731.24,0.00,0.00,0.00),('1','153','763','197242',3848135,'2132','321',1877539.54,1878384.43,0.00,0.00,844.89,272054.58,0.00,0.00,0.00),('1','153','763','197242',3848136,'2133','321',1005501.61,1006296.69,0.00,0.00,795.08,276687.84,0.00,0.00,0.00),('1','153','763','197243',3848137,'2132','321',1878384.43,1879486.31,0.00,0.00,1101.88,362559.34,0.00,0.00,0.00),('1','153','763','197243',3848138,'2133','321',1006296.69,1007008.25,0.00,0.00,711.56,247622.88,0.00,0.00,0.00),('1','153','763','197287',3849155,'2132','321',1879486.31,1881242.38,0.00,0.00,1756.07,577979.78,0.00,0.00,0.00),('1','153','763','197287',3849156,'2133','321',1007008.25,1008807.35,0.00,0.00,1799.10,626086.80,0.00,0.00,0.00),('1','153','763','197511',3852428,'2132','321',1881242.38,1883284.25,0.00,0.00,2041.87,676186.02,0.00,0.00,0.00),('1','153','763','197511',3852429,'2133','321',1008807.35,1010493.03,0.00,0.00,1685.68,586616.64,0.00,0.00,0.00),('1','153','763','197859',3858639,'2132','321',1883284.25,1884348.69,0.00,0.00,1064.44,353265.12,0.00,0.00,0.00),('1','153','763','197859',3858640,'2133','321',1010493.03,1010547.77,0.00,0.00,54.74,19049.52,0.00,0.00,0.00),('1','153','763','198200',3864435,'2132','321',1884348.69,1884422.21,0.00,0.00,73.52,25584.96,0.00,0.00,0.00),('1','153','763','198200',3864436,'2133','321',1010547.77,1012867.73,0.00,0.00,2319.96,797952.54,0.00,0.00,0.00),('1','153','763','198212',3864592,'2132','321',1884422.21,1885512.60,0.00,0.00,1090.39,368368.54,0.00,0.00,0.00),('1','153','763','198212',3864593,'2133','321',1012867.73,1014742.19,0.00,0.00,1874.46,652312.08,0.00,0.00,0.00),('1','153','763','198349',3867048,'2132','321',1885512.60,1885953.78,0.00,0.00,441.18,150540.64,0.00,0.00,0.00),('1','153','763','198349',3867049,'2133','321',1014742.19,1016860.56,0.00,0.00,2118.37,728712.08,0.00,0.00,0.00),('1','153','763','198556',3870698,'2132','321',1885953.78,1887075.13,0.00,0.00,1121.35,361153.22,0.00,0.00,0.00),('1','153','763','198556',3870699,'2133','321',1016860.56,1018564.97,0.00,0.00,1704.41,593134.68,0.00,0.00,0.00),('1','153','763','198838',3875185,'2132','321',1887075.13,1888248.77,0.00,0.00,1173.64,400781.30,0.00,0.00,0.00),('1','153','763','198838',3875186,'2133','321',1018564.97,1020772.89,0.00,0.00,2207.92,745729.14,0.00,0.00,0.00),('1','153','763','199079',3879591,'2132','321',1888248.77,1889638.90,0.00,0.00,1390.13,461593.22,0.00,0.00,0.00),('1','153','763','199079',3879592,'2133','321',1020772.89,1022591.03,0.00,0.00,1818.14,621230.34,0.00,0.00,0.00),('1','153','763','199197',3881760,'2132','321',1889638.90,1890990.82,0.00,0.00,1351.92,441249.36,0.00,0.00,0.00),('1','153','763','199197',3881761,'2133','321',1022591.03,1023254.55,0.00,0.00,663.52,230904.96,0.00,0.00,0.00),('1','153','763','199436',3885502,'2132','321',1890990.82,1891596.92,0.00,0.00,606.10,207093.52,0.00,0.00,0.00),('1','153','763','199436',3885503,'2133','321',1023254.55,1024282.10,0.00,0.00,1027.55,357587.40,0.00,0.00,0.00),('1','153','763','199444',3885573,'2132','321',1891596.92,1892980.18,0.00,0.00,1383.26,460946.28,0.00,0.00,0.00),('1','153','763','199444',3885574,'2133','321',1024282.10,1026160.17,0.00,0.00,1878.07,648073.52,0.00,0.00,0.00),('1','153','763','199652',3889236,'2132','321',1892980.18,1894127.34,0.00,0.00,1147.16,380942.52,0.00,0.00,0.00),('1','153','763','199652',3889237,'2133','321',1026160.17,1027657.33,0.00,0.00,1497.16,519384.60,0.00,0.00,0.00),('1','153','763','199857',3892386,'2132','321',1894127.34,1894998.89,0.00,0.00,871.55,283403.16,0.00,0.00,0.00),('1','153','763','199857',3892387,'2133','321',1027657.33,1029559.74,0.00,0.00,1902.41,662038.68,0.00,0.00,0.00),('1','153','763','200127',3897145,'2132','321',1894998.89,1896515.88,0.00,0.00,1516.99,500114.36,0.00,0.00,0.00),('1','153','763','200127',3897146,'2133','321',1029559.74,1030858.42,0.00,0.00,1298.68,451845.22,0.00,0.00,0.00),('1','153','763','200285',3900153,'2132','321',1896515.88,1898042.53,0.00,0.00,1526.65,508550.20,0.00,0.00,0.00),('1','153','763','200285',3900154,'2133','321',1030858.42,1032808.77,0.00,0.00,1950.35,678721.80,0.00,0.00,0.00),('1','153','763','200481',3903902,'2132','321',1898042.53,1899503.42,0.00,0.00,1460.89,483407.36,0.00,0.00,0.00),('1','153','763','200481',3903903,'2133','321',1032808.77,1034507.90,0.00,0.00,1699.13,587292.72,0.00,0.00,0.00),('1','153','763','200683',3907436,'2132','321',1899503.42,1901835.95,0.00,0.00,2332.53,764743.64,0.00,0.00,0.00),('1','153','763','200683',3907437,'2133','321',1034507.90,1037095.62,0.00,0.00,2587.72,900526.56,0.00,0.00,0.00),('1','153','763','200994',3912556,'2132','321',1901835.95,1902959.15,0.00,0.00,1123.20,371727.98,0.00,0.00,0.00),('1','153','763','200994',3912557,'2133','321',1037095.62,1038576.95,0.00,0.00,1481.33,515502.84,0.00,0.00,0.00),('1','153','763','201090',3914404,'2132','321',1902959.15,1903520.64,0.00,0.00,561.49,195398.52,0.00,0.00,0.00),('1','153','763','201090',3914405,'2133','321',1038576.95,1039180.56,0.00,0.00,603.61,202388.88,0.00,0.00,0.00),('1','153','763','201096',3914507,'2132','321',1903520.64,1904964.63,0.00,0.00,1443.99,482140.12,0.00,0.00,0.00),('1','153','763','201096',3914508,'2133','321',1039180.56,1041279.78,0.00,0.00,2099.22,730528.56,0.00,0.00,0.00),('1','153','763','201299',3917864,'2132','321',1904964.63,1905954.11,0.00,0.00,989.48,336059.34,0.00,0.00,0.00),('1','153','763','201299',3917865,'2133','321',1041279.78,1042522.06,0.00,0.00,1242.28,432313.44,0.00,0.00,0.00),('1','153','763','201467',3920985,'2132','321',1905954.11,1906594.71,0.00,0.00,640.60,218222.80,0.00,0.00,0.00),('1','153','763','201467',3920986,'2133','321',1042522.06,1043177.91,0.00,0.00,655.85,228235.80,0.00,0.00,0.00),('1','153','763','201496',3921451,'2132','321',1906594.71,1907560.08,0.00,0.00,965.37,311666.06,0.00,0.00,0.00),('1','153','763','201496',3921452,'2133','321',1043177.91,1044430.73,0.00,0.00,1252.82,435981.36,0.00,0.00,0.00),('1','153','763','201743',3926415,'2132','321',1907560.08,1908316.21,0.00,0.00,756.13,255333.24,0.00,0.00,0.00),('1','153','763','201743',3926416,'2133','321',1044430.73,1045117.83,0.00,0.00,687.10,239110.80,0.00,0.00,0.00),('1','153','763','201754',3926550,'2132','321',1908316.21,1909763.77,0.00,0.00,1447.56,489565.28,0.00,0.00,0.00),('1','153','763','201754',3926551,'2133','321',1045117.83,1047166.91,0.00,0.00,2049.08,713079.84,0.00,0.00,0.00),('1','153','763','202021',3931493,'2132','321',1909763.77,1910063.40,0.00,0.00,299.63,102841.24,0.00,0.00,0.00),('1','153','763','202021',3931494,'2133','321',1047166.91,1047656.25,0.00,0.00,489.34,170290.32,0.00,0.00,0.00),('1','153','763','202113',3932989,'2132','321',1910063.40,1911442.47,0.00,0.00,1379.07,464363.16,0.00,0.00,0.00),('1','153','763','202113',3932990,'2133','321',1047656.25,1048917.31,0.00,0.00,1261.06,438848.88,0.00,0.00,0.00),('1','153','763','202251',3935180,'2132','321',1911442.47,1912554.26,0.00,0.00,1111.79,373098.22,0.00,0.00,0.00),('1','153','763','202251',3935181,'2133','321',1048917.31,1050706.55,0.00,0.00,1789.24,622655.52,0.00,0.00,0.00),('1','153','763','202419',3938353,'2132','321',1912554.26,1913438.68,0.00,0.00,884.42,299029.16,0.00,0.00,0.00),('1','153','763','202419',3938354,'2133','321',1050706.55,1051847.26,0.00,0.00,1140.71,396967.08,0.00,0.00,0.00),('1','153','763','202569',3940845,'2132','321',1913438.68,1914296.34,0.00,0.00,857.66,285754.28,0.00,0.00,0.00),('1','153','763','202569',3940846,'2133','321',1051847.26,1052704.83,0.00,0.00,857.57,298434.36,0.00,0.00,0.00),('1','153','763','202640',3942135,'2132','321',1914296.34,1916285.95,0.00,0.00,1989.61,649238.32,0.00,0.00,0.00),('1','153','763','202640',3942136,'2133','321',1052704.83,1054712.67,0.00,0.00,2007.84,688670.22,0.00,0.00,0.00),('1','153','763','202842',3945819,'2132','321',1916285.95,1916285.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','202842',3945820,'2133','321',1054712.67,1054712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','202867',3946063,'2132','321',1916285.95,1917205.10,0.00,0.00,919.15,318030.00,0.00,0.00,0.00),('1','153','763','202867',3946064,'2133','321',1054712.67,1055951.56,0.00,0.00,1238.89,445845.24,0.00,0.00,0.00),('1','153','763','203042',3949605,'2132','321',1917205.10,1917853.20,0.00,0.00,648.10,224010.72,0.00,0.00,0.00),('1','153','763','203042',3949606,'2133','321',1055951.56,1056747.15,0.00,0.00,795.59,286412.40,0.00,0.00,0.00),('1','153','763','203097',3950750,'2132','321',1917853.20,1919612.08,0.00,0.00,1758.88,605488.80,0.00,0.00,0.00),('1','153','763','203097',3950751,'2133','321',1056747.15,1058502.05,0.00,0.00,1754.90,631764.00,0.00,0.00,0.00),('1','153','763','203311',3954540,'2132','321',1919612.08,1920757.35,0.00,0.00,1145.27,396591.60,0.00,0.00,0.00),('1','153','763','203311',3954541,'2133','321',1058502.05,1060696.36,0.00,0.00,2194.31,789951.60,0.00,0.00,0.00),('1','153','763','203516',3958258,'2132','321',1920757.35,1922124.52,0.00,0.00,1367.17,474500.16,0.00,0.00,0.00),('1','153','763','203516',3958259,'2133','321',1060696.36,1062521.13,0.00,0.00,1824.77,656917.20,0.00,0.00,0.00),('1','153','763','203732',3962067,'2132','321',1922124.52,1923617.51,0.00,0.00,1492.99,515655.60,0.00,0.00,0.00),('1','153','763','203732',3962068,'2133','321',1062521.13,1064598.92,0.00,0.00,2077.79,748004.40,0.00,0.00,0.00),('1','153','763','203966',3966157,'2132','321',1923617.51,1925488.21,0.00,0.00,1870.70,640989.60,0.00,0.00,0.00),('1','153','763','203966',3966158,'2133','321',1064598.92,1066099.62,0.00,0.00,1500.70,540252.00,0.00,0.00,0.00),('1','153','763','204182',3970299,'2132','321',1925488.21,1925677.64,0.00,0.00,189.43,68086.80,0.00,0.00,0.00),('1','153','763','204182',3970300,'2133','321',1066099.62,1066311.70,0.00,0.00,212.08,76348.80,0.00,0.00,0.00),('1','153','763','204249',3971227,'2132','321',1925677.64,1926558.49,0.00,0.00,880.85,308700.96,0.00,0.00,0.00),('1','153','763','204249',3971228,'2133','321',1066311.70,1067444.38,0.00,0.00,1132.68,407764.80,0.00,0.00,0.00),('1','153','763','204373',3973747,'2132','321',1926558.49,1927737.27,0.00,0.00,1178.78,416344.80,0.00,0.00,0.00),('1','153','763','204373',3973748,'2133','321',1067444.38,1068985.04,0.00,0.00,1540.66,545935.20,0.00,0.00,0.00),('1','153','763','204628',3978130,'2132','321',1927737.27,1928804.53,0.00,0.00,1067.26,368241.60,0.00,0.00,0.00),('1','153','763','204628',3978131,'2133','321',1068985.04,1070549.53,0.00,0.00,1564.49,563216.40,0.00,0.00,0.00),('1','153','763','204824',3981471,'2132','321',1928804.53,1929682.18,0.00,0.00,877.65,304670.64,0.00,0.00,0.00),('1','153','763','204824',3981472,'2133','321',1070549.53,1072389.44,0.00,0.00,1839.91,656226.00,0.00,0.00,0.00),('1','153','763','205029',3985109,'2132','321',1929682.18,1930733.00,0.00,0.00,1050.82,358107.36,0.00,0.00,0.00),('1','153','763','205029',3985110,'2133','321',1072389.44,1074831.50,0.00,0.00,2442.06,879141.60,0.00,0.00,0.00),('1','153','763','205243',3988845,'2132','321',1930733.00,1932746.87,0.00,0.00,2013.87,706273.20,0.00,0.00,0.00),('1','153','763','205243',3988846,'2133','321',1074831.50,1076197.60,0.00,0.00,1366.10,486861.60,0.00,0.00,0.00),('1','153','763','205463',3993035,'2132','321',1932746.87,1934574.15,0.00,0.00,1827.28,641360.16,0.00,0.00,0.00),('1','153','763','205463',3993036,'2133','321',1076197.60,1077434.56,0.00,0.00,1236.96,445305.60,0.00,0.00,0.00),('1','153','763','205718',3997674,'2132','321',1934574.15,1935626.60,0.00,0.00,1052.45,367430.64,0.00,0.00,0.00),('1','153','763','205718',3997675,'2133','321',1077434.56,1079783.00,0.00,0.00,2348.44,841089.60,0.00,0.00,0.00),('1','153','763','205937',4001518,'2132','321',1935626.60,1935885.37,0.00,0.00,258.77,91297.52,0.00,0.00,0.00),('1','153','763','205937',4001519,'2133','321',1079783.00,1080123.07,0.00,0.00,340.07,127866.32,0.00,0.00,0.00),('1','153','763','206000',4002483,'2132','321',1935885.37,1936673.81,0.00,0.00,788.44,288100.24,0.00,0.00,0.00),('1','153','763','206000',4002484,'2133','321',1080123.07,1081367.20,0.00,0.00,1244.13,467792.88,0.00,0.00,0.00),('1','153','763','206153',4005292,'2132','321',1936673.81,1937778.57,0.00,0.00,1104.76,404603.76,0.00,0.00,0.00),('1','153','763','206153',4005293,'2133','321',1081367.20,1082826.55,0.00,0.00,1459.35,539822.70,0.00,0.00,0.00),('1','153','763','206346',4008739,'2132','321',1937778.57,1938328.59,0.00,0.00,550.02,205267.92,0.00,0.00,0.00),('1','153','763','206346',4008740,'2133','321',1082826.55,1083691.10,0.00,0.00,864.55,325070.80,0.00,0.00,0.00),('1','153','763','206548',4012257,'2132','321',1938328.59,1938767.31,0.00,0.00,438.72,160587.72,0.00,0.00,0.00),('1','153','763','206548',4012258,'2133','321',1083691.10,1084319.04,0.00,0.00,627.94,236105.44,0.00,0.00,0.00),('1','153','763','206559',4012444,'2132','321',1938767.31,1940170.23,0.00,0.00,1402.92,500471.82,0.00,0.00,0.00),('1','153','763','206559',4012445,'2133','321',1084319.04,1086369.03,0.00,0.00,2049.99,770796.24,0.00,0.00,0.00),('1','153','763','206789',4016446,'2132','321',1940170.23,1940649.57,0.00,0.00,479.34,176212.14,0.00,0.00,0.00),('1','153','763','206789',4016447,'2133','321',1086369.03,1087309.25,0.00,0.00,940.22,352022.72,0.00,0.00,0.00),('1','153','763','206942',4019174,'2132','321',1940649.57,1941319.43,0.00,0.00,669.86,239597.36,0.00,0.00,0.00),('1','153','763','206942',4019175,'2133','321',1087309.25,1088017.82,0.00,0.00,708.57,266422.32,0.00,0.00,0.00),('1','153','763','207008',4020528,'2132','321',1941319.43,1942395.99,0.00,0.00,1076.56,389379.16,0.00,0.00,0.00),('1','153','763','207008',4020529,'2133','321',1088017.82,1090052.70,0.00,0.00,2034.88,765114.88,0.00,0.00,0.00),('1','153','763','207235',4024583,'2132','321',1942395.99,1944260.21,0.00,0.00,1864.22,664597.22,0.00,0.00,0.00),('1','153','763','207235',4024584,'2133','321',1090052.70,1092274.42,0.00,0.00,2221.72,835366.72,0.00,0.00,0.00),('1','153','763','207475',4028782,'2132','321',1944260.21,1945969.92,0.00,0.00,1709.71,606174.46,0.00,0.00,0.00),('1','153','763','207475',4028783,'2133','321',1092274.42,1093874.61,0.00,0.00,1600.19,601671.44,0.00,0.00,0.00),('1','153','763','207647',4031734,'2132','321',1945969.92,1946393.19,0.00,0.00,423.27,146451.42,0.00,0.00,0.00),('1','153','763','207647',4031735,'2133','321',1093874.61,1094427.07,0.00,0.00,552.46,207724.96,0.00,0.00,0.00),('1','153','763','207703',4032601,'2132','321',1946393.19,1948784.89,0.00,0.00,2391.70,878097.00,0.00,0.00,0.00),('1','153','763','207703',4032602,'2133','321',1094427.07,1096753.07,0.00,0.00,2326.00,893184.00,0.00,0.00,0.00),('1','153','763','207899',4036027,'2132','321',1948784.89,1951305.18,0.00,0.00,2520.29,916740.05,0.00,0.00,0.00),('1','153','763','207899',4036028,'2133','321',1096753.07,1099459.89,0.00,0.00,2706.82,1033618.88,0.00,0.00,0.00),('1','153','763','208102',4039547,'2132','321',1951305.18,1953879.04,0.00,0.00,2573.86,958480.93,0.00,0.00,0.00),('1','153','763','208102',4039548,'2133','321',1099459.89,1101650.46,0.00,0.00,2190.57,841178.88,0.00,0.00,0.00),('1','153','763','208310',4043333,'2132','321',1953879.04,1956357.74,0.00,0.00,2478.70,910914.56,0.00,0.00,0.00),('1','153','763','208310',4043334,'2133','321',1101650.46,1103298.20,0.00,0.00,1647.74,632732.16,0.00,0.00,0.00),('1','153','763','208563',4047585,'2132','321',1956357.74,1958510.53,0.00,0.00,2152.79,790250.26,0.00,0.00,0.00),('1','153','763','208563',4047586,'2133','321',1103298.20,1104635.63,0.00,0.00,1337.43,510455.62,0.00,0.00,0.00),('1','153','763','208714',4050355,'2132','321',1958510.53,1959031.93,0.00,0.00,521.40,196715.27,0.00,0.00,0.00),('1','153','763','208714',4050356,'2133','321',1104635.63,1105102.12,0.00,0.00,466.49,179132.16,0.00,0.00,0.00),('1','153','763','208744',4050946,'2132','321',1959031.93,1962802.53,0.00,0.00,3770.60,1358618.82,0.00,0.00,0.00),('1','153','763','208744',4050947,'2133','321',1105102.12,1107940.36,0.00,0.00,2838.24,1089884.16,0.00,0.00,0.00),('1','153','763','208999',4055119,'2132','321',1962802.53,1964240.71,0.00,0.00,1438.18,555510.64,0.00,0.00,0.00),('1','153','763','208999',4055120,'2133','321',1107940.36,1109769.12,0.00,0.00,1828.76,730004.00,0.00,0.00,0.00),('1','153','763','209225',4059078,'2132','321',1964240.71,1966609.05,0.00,0.00,2368.34,911179.52,0.00,0.00,0.00),('1','153','763','209225',4059079,'2133','321',1109769.12,1111643.74,0.00,0.00,1874.62,749848.00,0.00,0.00,0.00),('1','153','763','209423',4062766,'2132','321',1966609.05,1969069.31,0.00,0.00,2460.26,950888.00,0.00,0.00,0.00),('1','153','763','209423',4062767,'2133','321',1111643.74,1113692.49,0.00,0.00,2048.75,819500.00,0.00,0.00,0.00),('1','153','763','209631',4066501,'2132','321',1969069.31,1971269.46,0.00,0.00,2200.15,846652.00,0.00,0.00,0.00),('1','153','763','209631',4066502,'2133','321',1113692.49,1114941.33,0.00,0.00,1248.84,499536.00,0.00,0.00,0.00),('1','153','763','209813',4069726,'2132','321',1971269.46,1971807.71,0.00,0.00,538.25,80016.00,0.00,0.00,0.00),('1','153','763','209813',4069727,'2133','321',1114941.33,1115063.58,0.00,0.00,122.25,48900.00,0.00,0.00,0.00),('1','153','763','209854',4070374,'2132','321',1971807.71,1973081.11,0.00,0.00,1273.40,518146.00,0.00,0.00,0.00),('1','153','763','209854',4070375,'2133','321',1115063.58,1116483.19,0.00,0.00,1419.61,596236.20,0.00,0.00,0.00),('1','153','763','210089',4074646,'2132','321',1973081.11,1974965.89,0.00,0.00,1884.78,747296.56,0.00,0.00,0.00),('1','153','763','210089',4074647,'2133','321',1116483.19,1117652.69,0.00,0.00,1169.50,490335.00,0.00,0.00,0.00),('1','153','763','210302',4078274,'2132','321',1974965.89,1976470.11,0.00,0.00,1504.22,607338.40,0.00,0.00,0.00),('1','153','763','210302',4078275,'2133','321',1117652.69,1119026.26,0.00,0.00,1373.57,576899.40,0.00,0.00,0.00),('1','153','763','210509',4082146,'2132','321',1976470.11,1978472.38,0.00,0.00,2002.27,786670.40,0.00,0.00,0.00),('1','153','763','210509',4082147,'2133','321',1119026.26,1120304.27,0.00,0.00,1278.01,589422.00,0.00,0.00,0.00),('1','153','763','210723',4085928,'2132','321',1978472.38,1980196.36,0.00,0.00,1723.98,698425.40,0.00,0.00,0.00),('1','153','763','210723',4085929,'2133','321',1120304.27,1121842.18,0.00,0.00,1537.91,645922.20,0.00,0.00,0.00),('1','153','763','210944',4089619,'2132','321',1980196.36,1981959.12,0.00,0.00,1762.76,698331.96,0.00,0.00,0.00),('1','153','763','210944',4089620,'2133','321',1121842.18,1123641.81,0.00,0.00,1799.63,755844.60,0.00,0.00,0.00),('1','153','763','211159',4093475,'2132','321',1981959.12,1984194.50,0.00,0.00,2235.38,931482.24,0.00,0.00,0.00),('1','153','763','211159',4093476,'2133','321',1123641.81,1125276.21,0.00,0.00,1634.40,692985.60,0.00,0.00,0.00),('1','153','763','211360',4097139,'2132','321',1984194.50,1988010.66,0.00,0.00,3816.16,1541570.43,0.00,0.00,0.00),('1','153','763','211360',4097140,'2133','321',1125276.21,1128235.81,0.00,0.00,2959.60,1251317.90,0.00,0.00,0.00),('1','153','763','211607',4101338,'2132','321',1988010.66,1990472.08,0.00,0.00,2461.42,990365.31,0.00,0.00,0.00),('1','153','763','211607',4101339,'2133','321',1128235.81,1129964.78,0.00,0.00,1728.97,733083.28,0.00,0.00,0.00),('1','153','763','211765',4103988,'2132','321',1990472.08,1993608.05,0.00,0.00,3135.97,1247740.78,0.00,0.00,0.00),('1','153','763','211765',4103989,'2133','321',1129964.78,1131843.41,0.00,0.00,1878.63,795814.12,0.00,0.00,0.00),('1','153','763','211975',4107738,'2132','321',1993608.05,1995664.23,0.00,0.00,2056.18,812984.54,0.00,0.00,0.00),('1','153','763','211975',4107739,'2133','321',1131843.41,1133126.42,0.00,0.00,1283.01,543996.24,0.00,0.00,0.00),('1','153','763','212224',4112076,'2132','321',1995664.23,1997924.31,0.00,0.00,2260.08,900702.83,0.00,0.00,0.00),('1','153','763','212224',4112077,'2133','321',1133126.42,1134939.78,0.00,0.00,1813.36,768864.64,0.00,0.00,0.00),('1','153','763','212446',4116227,'2132','321',1997924.31,1998796.08,0.00,0.00,871.77,353548.26,0.00,0.00,0.00),('1','153','763','212446',4116228,'2133','321',1134939.78,1135456.24,0.00,0.00,516.46,218979.04,0.00,0.00,0.00),('1','153','763','212538',4117725,'2132','321',1998796.08,2000357.47,0.00,0.00,1561.39,635101.36,0.00,0.00,0.00),('1','153','763','212538',4117726,'2133','321',1135456.24,1136471.32,0.00,0.00,1015.08,430393.92,0.00,0.00,0.00),('1','153','763','212653',4119947,'2132','321',2000357.47,2002380.83,0.00,0.00,2023.36,826781.46,0.00,0.00,0.00),('1','153','763','212653',4119948,'2133','321',1136471.32,1137983.89,0.00,0.00,1512.57,641329.68,0.00,0.00,0.00),('1','153','763','212855',4123477,'2132','321',2002380.83,2004064.00,0.00,0.00,1683.17,701476.08,0.00,0.00,0.00),('1','153','763','212855',4123478,'2133','321',1137983.89,1139434.40,0.00,0.00,1450.51,615016.24,0.00,0.00,0.00),('1','153','763','213115',4128002,'2132','321',2004064.00,2005352.02,0.00,0.00,1288.02,528370.22,0.00,0.00,0.00),('1','153','763','213115',4128003,'2133','321',1139434.40,1140751.61,0.00,0.00,1317.21,558497.04,0.00,0.00,0.00),('1','153','763','213352',4131857,'2132','321',2005352.02,2005505.27,0.00,0.00,153.25,64857.00,0.00,0.00,0.00),('1','153','763','213352',4131858,'2133','321',1140751.61,1140985.89,0.00,0.00,234.28,99334.72,0.00,0.00,0.00),('1','153','763','213383',4132361,'2132','321',2005505.27,2007956.31,0.00,0.00,2451.04,1024005.96,0.00,0.00,0.00),('1','153','763','213383',4132362,'2133','321',1140985.89,1142591.27,0.00,0.00,1605.38,680681.12,0.00,0.00,0.00),('1','153','763','213620',4136325,'2132','321',2007956.31,2009036.55,0.00,0.00,1080.24,438847.00,0.00,0.00,0.00),('1','153','763','213620',4136326,'2133','321',1142591.27,1143249.95,0.00,0.00,658.68,279280.32,0.00,0.00,0.00),('1','153','763','213742',4138262,'2132','321',2009036.55,2010282.90,0.00,0.00,1246.35,513103.00,0.00,0.00,0.00),('1','153','763','213742',4138263,'2133','321',1143249.95,1144585.71,0.00,0.00,1335.76,566362.24,0.00,0.00,0.00),('1','153','763','213870',4140441,'2132','321',2010282.90,2013053.81,0.00,0.00,2770.91,1143343.58,0.00,0.00,0.00),('1','153','763','213870',4140442,'2133','321',1144585.71,1146503.36,0.00,0.00,1917.65,813083.60,0.00,0.00,0.00),('1','153','763','214110',4144264,'2132','321',2013053.81,2014752.58,0.00,0.00,1698.77,696584.92,0.00,0.00,0.00),('1','153','763','214110',4144265,'2133','321',1146503.36,1147450.11,0.00,0.00,946.75,401422.00,0.00,0.00,0.00),('1','153','763','214333',4148303,'2132','321',2014752.58,2016032.61,0.00,0.00,1280.03,532312.86,0.00,0.00,0.00),('1','153','763','214333',4148304,'2133','321',1147450.11,1149624.09,0.00,0.00,2173.98,921767.52,0.00,0.00,0.00),('1','153','763','214475',4150771,'2132','321',2016032.61,2016509.61,0.00,0.00,477.00,198398.00,0.00,0.00,0.00),('1','153','763','214475',4150772,'2133','321',1149624.09,1149993.39,0.00,0.00,369.30,156583.20,0.00,0.00,0.00),('1','153','763','214551',4151782,'2132','321',2016509.61,2018323.24,0.00,0.00,1813.63,750815.26,0.00,0.00,0.00),('1','153','763','214551',4151783,'2133','321',1149993.39,1152367.08,0.00,0.00,2373.69,1002044.56,0.00,0.00,0.00),('1','153','763','214759',4155729,'2132','321',2018323.24,2018880.71,0.00,0.00,557.47,233056.28,0.00,0.00,0.00),('1','153','763','214759',4155730,'2133','321',1152367.08,1152886.74,0.00,0.00,519.66,220335.84,0.00,0.00,0.00),('1','153','763','214865',4157418,'2132','321',2018880.71,2019945.21,0.00,0.00,1064.50,444154.00,0.00,0.00,0.00),('1','153','763','214865',4157419,'2133','321',1152886.74,1154290.47,0.00,0.00,1403.73,595181.52,0.00,0.00,0.00),('1','153','763','214986',4159469,'2132','321',2019945.21,2022267.71,0.00,0.00,2322.50,948930.60,0.00,0.00,0.00),('1','153','763','214986',4159470,'2133','321',1154290.47,1156649.12,0.00,0.00,2358.65,1000067.60,0.00,0.00,0.00),('1','153','763','215212',4163423,'2132','321',2022267.71,2024383.37,0.00,0.00,2115.66,874984.84,0.00,0.00,0.00),('1','153','763','215212',4163424,'2133','321',1156649.12,1158425.26,0.00,0.00,1776.14,753083.36,0.00,0.00,0.00),('1','153','763','215429',4167017,'2132','321',2024383.37,2026265.69,0.00,0.00,1882.32,796251.60,0.00,0.00,0.00),('1','153','763','215429',4167018,'2133','321',1158425.26,1160171.25,0.00,0.00,1745.99,767954.48,0.00,0.00,0.00),('1','153','763','215662',4170983,'2132','321',2026265.69,2027955.32,0.00,0.00,1689.63,725200.20,0.00,0.00,0.00),('1','153','763','215662',4170984,'2133','321',1160171.25,1161900.60,0.00,0.00,1729.35,760914.00,0.00,0.00,0.00),('1','153','763','215894',4174959,'2132','321',2027955.32,2029417.52,0.00,0.00,1462.20,617883.30,0.00,0.00,0.00),('1','153','763','215894',4174960,'2133','321',1161900.60,1163970.07,0.00,0.00,2069.47,910566.80,0.00,0.00,0.00),('1','153','763','216088',4178352,'2132','321',2029417.52,2030323.37,0.00,0.00,905.85,377019.00,0.00,0.00,0.00),('1','153','763','216088',4178353,'2133','321',1163970.07,1164646.08,0.00,0.00,676.01,297444.40,0.00,0.00,0.00),('1','153','763','216233',4180583,'2132','321',2030323.37,2030935.50,0.00,0.00,612.13,262902.20,0.00,0.00,0.00),('1','153','763','216233',4180584,'2133','321',1164646.08,1165607.77,0.00,0.00,961.69,423143.60,0.00,0.00,0.00),('1','153','763','216308',4182189,'2132','321',2030935.50,2033106.55,0.00,0.00,2171.05,905935.25,0.00,0.00,0.00),('1','153','763','216308',4182190,'2133','321',1165607.77,1167807.51,0.00,0.00,2199.74,967885.60,0.00,0.00,0.00),('1','153','763','216540',4186204,'2132','321',2033106.55,2034718.86,0.00,0.00,1612.31,681498.90,0.00,0.00,0.00),('1','153','763','216540',4186205,'2133','321',1167807.51,1169496.12,0.00,0.00,1688.61,742988.40,0.00,0.00,0.00),('1','153','763','216867',4191718,'2132','321',2034718.86,2036222.74,0.00,0.00,1503.88,633527.20,0.00,0.00,0.00),('1','153','763','216867',4191719,'2133','321',1169496.12,1171339.20,0.00,0.00,1843.08,810955.20,0.00,0.00,0.00),('1','153','763','217009',4194397,'2132','321',2036222.74,2037176.81,0.00,0.00,954.07,434559.12,0.00,0.00,0.00),('1','153','763','217009',4194398,'2133','321',1171339.20,1173144.96,0.00,0.00,1805.76,852318.72,0.00,0.00,0.00),('1','153','763','217260',4199252,'2132','321',2037176.81,2038013.29,0.00,0.00,836.48,371255.68,0.00,0.00,0.00),('1','153','763','217260',4199253,'2133','321',1173144.96,1175370.80,0.00,0.00,2225.84,1050596.48,0.00,0.00,0.00),('1','153','763','217510',4203292,'2132','321',2038013.29,2038789.77,0.00,0.00,776.48,345637.76,0.00,0.00,0.00),('1','153','763','217510',4203293,'2133','321',1175370.80,1177876.88,0.00,0.00,2506.08,1182869.76,0.00,0.00,0.00),('1','153','763','217789',4208096,'2132','321',2038789.77,2039593.92,0.00,0.00,804.15,362502.80,0.00,0.00,0.00),('1','153','763','217789',4208097,'2133','321',1177876.88,1179658.54,0.00,0.00,1781.66,840943.52,0.00,0.00,0.00),('1','153','763','217967',4211609,'2132','321',2039593.92,2039610.70,0.00,0.00,16.78,7383.20,0.00,0.00,0.00),('1','153','763','217967',4211610,'2133','321',1179658.54,1179742.20,0.00,0.00,83.66,39487.52,0.00,0.00,0.00),('1','153','763','218027',4212358,'2132','321',2039610.70,2039954.75,0.00,0.00,344.05,151927.60,0.00,0.00,0.00),('1','153','763','218027',4212359,'2133','321',1179742.20,1181929.21,0.00,0.00,2187.01,1032268.72,0.00,0.00,0.00),('1','153','763','218309',4217286,'2132','321',2039954.75,2040731.63,0.00,0.00,776.88,353855.68,0.00,0.00,0.00),('1','153','763','218309',4217287,'2133','321',1181929.21,1183476.40,0.00,0.00,1547.19,730128.08,0.00,0.00,0.00),('1','153','763','218434',4219746,'2132','321',2040731.63,2041011.27,0.00,0.00,279.64,125007.04,0.00,0.00,0.00),('1','153','763','218434',4219747,'2133','321',1183476.40,1184412.31,0.00,0.00,935.91,441749.52,0.00,0.00,0.00),('1','153','763','218566',4221971,'2132','321',2041011.27,2041262.61,0.00,0.00,251.34,112600.48,0.00,0.00,0.00),('1','153','763','218566',4221972,'2133','321',1184412.31,1185571.73,0.00,0.00,1159.42,547246.24,0.00,0.00,0.00),('1','153','763','218664',4223874,'2132','321',2041262.61,2042305.33,0.00,0.00,1042.72,473382.72,0.00,0.00,0.00),('1','153','763','218664',4223875,'2133','321',1185571.73,1187254.98,0.00,0.00,1683.25,794494.00,0.00,0.00,0.00),('1','153','763','218894',4227917,'2132','321',2042305.33,2043275.29,0.00,0.00,969.96,437949.12,0.00,0.00,0.00),('1','153','763','218894',4227918,'2133','321',1187254.98,1189422.87,0.00,0.00,2167.89,1023244.08,0.00,0.00,0.00),('1','153','763','219108',4231504,'2132','321',2043275.29,2044286.54,0.00,0.00,1011.25,453481.40,0.00,0.00,0.00),('1','153','763','219108',4231505,'2133','321',1189422.87,1191388.31,0.00,0.00,1965.44,904102.40,0.00,0.00,0.00),('1','153','763','219332',4235327,'2132','321',2044286.54,2045184.42,0.00,0.00,897.88,408214.80,0.00,0.00,0.00),('1','153','763','219332',4235328,'2133','321',1191388.31,1192454.38,0.00,0.00,1066.07,490392.20,0.00,0.00,0.00),('1','153','763','219532',4238819,'2132','321',2045184.42,2045505.87,0.00,0.00,321.45,147127.00,0.00,0.00,0.00),('1','153','763','219532',4238820,'2133','321',1192454.38,1192859.09,0.00,0.00,404.71,186166.60,0.00,0.00,0.00),('1','153','763','219573',4239593,'2132','321',2045505.87,2046379.86,0.00,0.00,873.99,392185.20,0.00,0.00,0.00),('1','153','763','219573',4239594,'2133','321',1192859.09,1194459.74,0.00,0.00,1600.65,736299.00,0.00,0.00,0.00),('1','153','763','219794',4243600,'2132','321',2046379.86,2047005.10,0.00,0.00,625.24,282040.40,0.00,0.00,0.00),('1','153','763','219794',4243601,'2133','321',1194459.74,1196258.02,0.00,0.00,1798.28,827208.80,0.00,0.00,0.00),('1','153','763','220018',4247712,'2132','321',2047005.10,2047908.82,0.00,0.00,903.72,405994.00,0.00,0.00,0.00),('1','153','763','220018',4247713,'2133','321',1196258.02,1198199.95,0.00,0.00,1941.93,893287.80,0.00,0.00,0.00),('1','153','763','220224',4251241,'2132','321',2047908.82,2049052.16,0.00,0.00,1143.34,512395.60,0.00,0.00,0.00),('1','153','763','220224',4251242,'2133','321',1198199.95,1200090.27,0.00,0.00,1890.32,869547.20,0.00,0.00,0.00),('1','153','763','220451',4255443,'2132','321',2049052.16,2049948.74,0.00,0.00,896.58,399756.80,0.00,0.00,0.00),('1','153','763','220451',4255444,'2133','321',1200090.27,1201485.33,0.00,0.00,1395.06,641727.60,0.00,0.00,0.00),('1','153','763','220672',4259159,'2132','321',2049948.74,2052292.72,0.00,0.00,2343.98,1053963.20,0.00,0.00,0.00),('1','153','763','220672',4259160,'2133','321',1201485.33,1203620.68,0.00,0.00,2135.35,982261.00,0.00,0.00,0.00),('1','153','763','220891',4263114,'2132','321',2052292.72,2052292.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','220891',4263115,'2133','321',1203620.68,1203620.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','220892',4263116,'2132','321',2052292.72,2053278.22,0.00,0.00,985.50,440281.92,0.00,0.00,0.00),('1','153','763','220892',4263117,'2133','321',1203620.68,1205637.27,0.00,0.00,2016.59,927631.40,0.00,0.00,0.00),('1','153','763','221124',4267238,'2132','321',2053278.22,2054859.60,0.00,0.00,1581.38,695185.28,0.00,0.00,0.00),('1','153','763','221124',4267239,'2133','321',1205637.27,1207049.70,0.00,0.00,1412.43,649717.80,0.00,0.00,0.00),('1','153','763','221340',4270935,'2132','321',2054859.60,2055700.88,0.00,0.00,841.28,373548.80,0.00,0.00,0.00),('1','153','763','221340',4270936,'2133','321',1207049.70,1207698.95,0.00,0.00,649.25,298655.00,0.00,0.00,0.00),('1','153','763','221371',4271661,'2132','321',2055700.88,2058325.86,0.00,0.00,2624.98,1151767.12,0.00,0.00,0.00),('1','153','763','221371',4271662,'2133','321',1207698.95,1210231.38,0.00,0.00,2532.43,1163717.80,0.00,0.00,0.00),('1','153','763','221600',4275949,'2132','321',2058325.86,2061758.53,0.00,0.00,3432.67,1519268.20,0.00,0.00,0.00),('1','153','763','221600',4275950,'2133','321',1210231.38,1212810.82,0.00,0.00,2579.44,1186542.40,0.00,0.00,0.00),('1','153','763','221811',4279606,'2132','321',2061758.53,2063774.31,0.00,0.00,2015.78,889410.80,0.00,0.00,0.00),('1','153','763','221811',4279607,'2133','321',1212810.82,1215370.89,0.00,0.00,2560.07,1177632.20,0.00,0.00,0.00),('1','153','763','222044',4283889,'2132','321',2063774.31,2065055.08,0.00,0.00,1280.77,559298.20,0.00,0.00,0.00),('1','153','763','222044',4283890,'2133','321',1215370.89,1218785.92,0.00,0.00,3415.03,1570913.80,0.00,0.00,0.00),('1','153','763','222257',4287420,'2132','321',2065055.08,2066323.20,0.00,0.00,1268.12,558123.20,0.00,0.00,0.00),('1','153','763','222257',4287421,'2133','321',1218785.92,1220302.00,0.00,0.00,1516.08,697396.80,0.00,0.00,0.00),('1','153','763','222406',4289726,'2132','321',2066323.20,2067488.06,0.00,0.00,1164.86,516695.60,0.00,0.00,0.00),('1','153','763','222406',4289727,'2133','321',1220302.00,1221335.75,0.00,0.00,1033.75,475525.00,0.00,0.00,0.00),('1','153','763','222474',4291172,'2132','321',2067488.06,2070790.15,0.00,0.00,3302.09,1448773.40,0.00,0.00,0.00),('1','153','763','222474',4291173,'2133','321',1221335.75,1223669.03,0.00,0.00,2333.28,1073308.80,0.00,0.00,0.00),('1','153','763','222716',4295662,'2132','321',2070790.15,2074126.03,0.00,0.00,3335.88,1456919.76,0.00,0.00,0.00),('1','153','763','222716',4295663,'2133','321',1223669.03,1226572.54,0.00,0.00,2903.51,1335614.60,0.00,0.00,0.00),('1','153','763','223130',4303194,'2132','321',2074126.03,2077768.91,0.00,0.00,3642.88,1588295.68,0.00,0.00,0.00),('1','153','763','223130',4303195,'2133','321',1226572.54,1229230.12,0.00,0.00,2657.58,1209367.92,0.00,0.00,0.00),('1','153','763','223161',4303644,'2132','321',2077768.91,2077768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','223161',4303645,'2133','321',1229230.12,1229230.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','223184',4303803,'2132','321',2077768.91,2078821.42,0.00,0.00,1052.51,458894.36,0.00,0.00,0.00),('1','153','763','223184',4303804,'2133','321',1229230.12,1230280.42,0.00,0.00,1050.30,477222.24,0.00,0.00,0.00),('1','153','763','223190',4303825,'2132','321',2078821.42,2079931.05,0.00,0.00,1109.63,513352.50,0.00,0.00,0.00),('1','153','763','223190',4303826,'2133','321',1230280.42,1231106.86,0.00,0.00,826.44,395284.32,0.00,0.00,0.00),('1','153','763','223310',4305673,'2132','321',2079931.05,2081518.24,0.00,0.00,1587.19,736931.10,0.00,0.00,0.00),('1','153','763','223310',4305674,'2133','321',1231106.86,1232627.63,0.00,0.00,1520.77,729969.60,0.00,0.00,0.00),('1','153','763','223403',4307802,'2132','321',2081518.24,2084391.50,0.00,0.00,2873.26,1331878.62,0.00,0.00,0.00),('1','153','763','223403',4307803,'2133','321',1232627.63,1234624.92,0.00,0.00,1997.29,958699.20,0.00,0.00,0.00),('1','153','763','223627',4311919,'2132','321',2084391.50,2087996.59,0.00,0.00,3605.09,1665551.58,0.00,0.00,0.00),('1','153','763','223627',4311920,'2133','321',1234624.92,1237264.65,0.00,0.00,2639.73,1256548.68,0.00,0.00,0.00),('1','153','763','223875',4316417,'2132','321',2087996.59,2091454.29,0.00,0.00,3457.70,1604665.50,0.00,0.00,0.00),('1','153','763','223875',4316418,'2133','321',1237264.65,1239642.65,0.00,0.00,2378.00,1141440.00,0.00,0.00,0.00),('1','153','763','224064',4319781,'2132','321',2091454.29,2093806.46,0.00,0.00,2352.17,1086702.54,0.00,0.00,0.00),('1','153','763','224064',4319782,'2133','321',1239642.65,1241321.01,0.00,0.00,1678.36,802326.00,0.00,0.00,0.00),('1','153','763','224258',4323292,'2132','321',2093806.46,2094653.40,0.00,0.00,846.94,391735.20,0.00,0.00,0.00),('1','153','763','224258',4323293,'2133','321',1241321.01,1241892.00,0.00,0.00,570.99,274075.20,0.00,0.00,0.00),('1','153','763','224292',4323979,'2132','321',2094653.40,2096569.30,0.00,0.00,1915.90,980298.00,0.00,0.00,0.00),('1','153','763','224292',4323980,'2133','321',1241892.00,1243326.13,0.00,0.00,1434.13,774430.20,0.00,0.00,0.00),('1','153','763','224518',4327850,'2132','321',2096569.30,2099158.28,0.00,0.00,2588.98,1317549.20,0.00,0.00,0.00),('1','153','763','224518',4327851,'2133','321',1243326.13,1245129.12,0.00,0.00,1802.99,973614.60,0.00,0.00,0.00),('1','153','763','224763',4332171,'2132','321',2099158.28,2102250.73,0.00,0.00,3092.45,1561763.00,0.00,0.00,0.00),('1','153','763','224763',4332172,'2133','321',1245129.12,1247157.70,0.00,0.00,2028.58,1095433.20,0.00,0.00,0.00),('1','153','763','225019',4336568,'2132','321',2102250.73,2105391.79,0.00,0.00,3141.06,1549426.80,0.00,0.00,0.00),('1','153','763','225019',4336569,'2133','321',1247157.70,1249228.88,0.00,0.00,2071.18,1118437.20,0.00,0.00,0.00),('1','153','763','225245',4340830,'2132','321',2105391.79,2108654.10,0.00,0.00,3262.31,1592007.28,0.00,0.00,0.00),('1','153','763','225245',4340831,'2133','321',1249228.88,1251127.16,0.00,0.00,1898.28,1007989.72,0.00,0.00,0.00),('1','153','763','225451',4344639,'2132','321',2108654.10,2109373.14,0.00,0.00,719.04,350891.52,0.00,0.00,0.00),('1','153','763','225451',4344640,'2133','321',1251127.16,1251526.94,0.00,0.00,399.78,215311.28,0.00,0.00,0.00),('1','153','763','225469',4344968,'2132','321',2109373.14,2113048.84,0.00,0.00,3675.70,1795119.60,0.00,0.00,0.00),('1','153','763','225469',4344969,'2133','321',1251526.94,1254050.81,0.00,0.00,2523.87,1346520.20,0.00,0.00,0.00),('1','153','763','225678',4348581,'2132','321',2113048.84,2115972.69,0.00,0.00,2923.85,1450826.80,0.00,0.00,0.00),('1','153','763','225678',4348582,'2133','321',1254050.81,1256858.73,0.00,0.00,2807.92,1516276.80,0.00,0.00,0.00),('1','153','763','225960',4353298,'2132','321',2115972.69,2118745.10,0.00,0.00,2772.41,1398041.40,0.00,0.00,0.00),('1','153','763','225960',4353299,'2133','321',1256858.73,1258678.79,0.00,0.00,1820.06,982832.40,0.00,0.00,0.00),('1','153','763','226226',4358312,'2132','321',2118745.10,2121555.33,0.00,0.00,2810.23,1426924.20,0.00,0.00,0.00),('1','153','763','226226',4358313,'2133','321',1258678.79,1260840.85,0.00,0.00,2162.06,1167512.40,0.00,0.00,0.00),('1','153','763','226467',4362485,'2132','321',2121555.33,2122883.19,0.00,0.00,1327.86,668384.40,0.00,0.00,0.00),('1','153','763','226467',4362486,'2133','321',1260840.85,1261786.73,0.00,0.00,945.88,510775.20,0.00,0.00,0.00),('1','153','763','226654',4365921,'2132','321',2122883.19,2124196.51,0.00,0.00,1313.32,656660.00,0.00,0.00,0.00),('1','153','763','226654',4365922,'2133','321',1261786.73,1262805.22,0.00,0.00,1018.49,548377.40,0.00,0.00,0.00),('1','153','763','226717',4367138,'2132','321',2124196.51,2127127.32,0.00,0.00,2930.81,1495157.40,0.00,0.00,0.00),('1','153','763','226717',4367139,'2133','321',1262805.22,1264977.69,0.00,0.00,2172.47,1159933.80,0.00,0.00,0.00),('1','153','763','226940',4371161,'2132','321',2127127.32,2130428.65,0.00,0.00,3301.33,1655178.20,0.00,0.00,0.00),('1','153','763','226940',4371162,'2133','321',1264977.69,1267091.50,0.00,0.00,2113.81,1141457.40,0.00,0.00,0.00),('1','153','763','227171',4375160,'2132','321',2130428.65,2134094.32,0.00,0.00,3665.67,1843461.80,0.00,0.00,0.00),('1','153','763','227171',4375161,'2133','321',1267091.50,1269554.46,0.00,0.00,2462.96,1329198.40,0.00,0.00,0.00),('1','153','763','227372',4378552,'2132','321',2134094.32,2137562.19,0.00,0.00,3467.87,1752929.80,0.00,0.00,0.00),('1','153','763','227372',4378553,'2133','321',1269554.46,1271622.64,0.00,0.00,2068.18,1116817.20,0.00,0.00,0.00),('1','153','763','227587',4382367,'2132','321',2137562.19,2137562.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','227587',4382368,'2133','321',1271622.64,1271622.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','227595',4382472,'2132','321',2137562.19,2140847.12,0.00,0.00,3284.93,1717353.00,0.00,0.00,0.00),('1','153','763','227595',4382473,'2133','321',1271622.64,1273940.54,0.00,0.00,2317.90,1247835.80,0.00,0.00,0.00),('1','153','763','227834',4386772,'2132','321',2140847.12,2143683.59,0.00,0.00,2836.47,1474231.78,0.00,0.00,0.00),('1','153','763','227834',4386773,'2133','321',1273940.54,1276213.90,0.00,0.00,2273.36,1227020.40,0.00,0.00,0.00),('1','153','763','228104',4391899,'2132','321',2143683.59,2147383.14,0.00,0.00,3699.55,1933074.80,0.00,0.00,0.00),('1','153','763','228104',4391900,'2133','321',1276213.90,1278753.81,0.00,0.00,2539.91,1365776.40,0.00,0.00,0.00),('1','153','763','228337',4396405,'2132','321',2147383.14,2151384.62,0.00,0.00,4001.48,2072929.66,0.00,0.00,0.00),('1','153','763','228337',4396406,'2133','321',1278753.81,1281510.62,0.00,0.00,2756.81,1483886.02,0.00,0.00,0.00),('1','153','763','228518',4399738,'2132','321',2151384.62,2151897.24,0.00,0.00,512.62,268454.80,0.00,0.00,0.00),('1','153','763','228518',4399739,'2133','321',1281510.62,1282021.89,0.00,0.00,511.27,276085.80,0.00,0.00,0.00),('1','153','763','228599',4400960,'2132','321',2151897.24,2151897.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','228599',4400961,'2133','321',1282021.89,1282021.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','228602',4401023,'2132','321',2151897.24,2153993.54,0.00,0.00,2096.30,1089894.44,0.00,0.00,0.00),('1','153','763','228602',4401024,'2133','321',1282021.89,1283360.15,0.00,0.00,1338.26,721289.36,0.00,0.00,0.00),('1','153','763','228744',4403977,'2132','321',2153993.54,2157358.31,0.00,0.00,3364.77,1746796.68,0.00,0.00,0.00),('1','153','763','228744',4403978,'2133','321',1283360.15,1285658.54,0.00,0.00,2298.39,1241130.60,0.00,0.00,0.00),('1','153','763','228923',4407291,'2132','321',2157358.31,2161150.69,0.00,0.00,3792.38,1970850.00,0.00,0.00,0.00),('1','153','763','228923',4407292,'2133','321',1285658.54,1288162.33,0.00,0.00,2503.79,1349736.60,0.00,0.00,0.00),('1','153','763','229156',4411884,'2132','321',2161150.69,2164854.87,0.00,0.00,3704.18,1923752.42,0.00,0.00,0.00),('1','153','763','229156',4411885,'2133','321',1288162.33,1290964.21,0.00,0.00,2801.88,1513015.20,0.00,0.00,0.00),('1','153','763','229403',4416248,'2132','321',2164854.87,2164854.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','229403',4416249,'2133','321',1290964.21,1290964.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','229418',4416349,'2132','321',2164854.87,2165508.61,0.00,0.00,653.74,347245.48,0.00,0.00,0.00),('1','153','763','229418',4416350,'2133','321',1290964.21,1291539.05,0.00,0.00,574.84,310413.60,0.00,0.00,0.00),('1','153','763','229422',4416378,'2132','321',2165508.61,2166356.41,0.00,0.00,847.80,451926.03,0.00,0.00,0.00),('1','153','763','229422',4416379,'2133','321',1291539.05,1292278.47,0.00,0.00,739.42,431821.28,0.00,0.00,0.00),('1','153','763','229522',4418250,'2132','321',2166356.41,2166356.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','229522',4418251,'2133','321',1292278.47,1292278.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','229536',4418586,'2132','321',2166356.41,2168646.06,0.00,0.00,2289.65,1221059.10,0.00,0.00,0.00),('1','153','763','229536',4418587,'2133','321',1292278.47,1293986.18,0.00,0.00,1707.71,997302.64,0.00,0.00,0.00),('1','153','763','229653',4421096,'2132','321',2168646.06,2172248.53,0.00,0.00,3602.47,1912911.57,0.00,0.00,0.00),('1','153','763','229653',4421097,'2133','321',1293986.18,1296523.56,0.00,0.00,2537.38,1469226.52,0.00,0.00,0.00),('1','153','763','229872',4425544,'2132','321',2172248.53,2176042.98,0.00,0.00,3794.45,2014958.95,0.00,0.00,0.00),('1','153','763','229872',4425545,'2133','321',1296523.56,1299524.12,0.00,0.00,3000.56,1750623.62,0.00,0.00,0.00),('1','153','763','230070',4429222,'2132','321',2176042.98,2176686.72,0.00,0.00,643.74,341825.94,0.00,0.00,0.00),('1','153','763','230070',4429223,'2133','321',1299524.12,1300142.27,0.00,0.00,618.15,343534.51,0.00,0.00,0.00),('1','153','763','230077',4429262,'2132','321',2176686.72,2180365.49,0.00,0.00,3678.77,1956273.50,0.00,0.00,0.00),('1','153','763','230077',4429263,'2133','321',1300142.27,1302940.86,0.00,0.00,2798.59,1595021.94,0.00,0.00,0.00),('1','153','763','230266',4432896,'2132','321',2180365.49,2180365.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','230266',4432897,'2133','321',1302940.86,1302940.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','230276',4432987,'2132','321',2180365.49,2184169.72,0.00,0.00,3804.23,2028955.59,0.00,0.00,0.00),('1','153','763','230276',4432988,'2133','321',1302940.86,1305476.79,0.00,0.00,2535.93,1427689.20,0.00,0.00,0.00),('1','153','763','230503',4437317,'2132','321',2184169.72,2185269.36,0.00,0.00,1099.64,599025.76,0.00,0.00,0.00),('1','153','763','230503',4437318,'2133','321',1305476.79,1306354.92,0.00,0.00,878.13,512827.92,0.00,0.00,0.00),('1','153','763','230510',4437429,'2132','321',2185269.36,2187989.53,0.00,0.00,2720.17,1488034.44,0.00,0.00,0.00),('1','153','763','230510',4437430,'2133','321',1306354.92,1308449.90,0.00,0.00,2094.98,1216868.32,0.00,0.00,0.00),('1','153','763','230771',4442038,'2132','321',2187989.53,2191497.06,0.00,0.00,3507.53,1910255.12,0.00,0.00,0.00),('1','153','763','230771',4442039,'2133','321',1308449.90,1310666.20,0.00,0.00,2216.30,1294319.20,0.00,0.00,0.00),('1','153','763','231063',4446934,'2132','321',2191497.06,2193255.23,0.00,0.00,1758.17,949411.80,0.00,0.00,0.00),('1','153','763','231063',4446935,'2133','321',1310666.20,1311807.26,0.00,0.00,1141.06,661128.08,0.00,0.00,0.00),('1','153','763','231353',4451684,'2132','321',2193255.23,2194725.29,0.00,0.00,1470.06,833815.44,0.00,0.00,0.00),('1','153','763','231353',4451685,'2133','321',1311807.26,1312936.38,0.00,0.00,1129.12,659406.08,0.00,0.00,0.00),('1','153','763','231531',4454471,'2132','321',2194725.29,2194725.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','231531',4454472,'2133','321',1312936.38,1312936.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','231534',4454569,'2132','321',2194725.29,2195846.22,0.00,0.00,1120.93,633644.72,0.00,0.00,0.00),('1','153','763','231534',4454570,'2133','321',1312936.38,1313804.96,0.00,0.00,868.58,507250.72,0.00,0.00,0.00),('1','153','763','231635',4456388,'2132','321',2195846.22,2197222.37,0.00,0.00,1376.15,776052.88,0.00,0.00,0.00),('1','153','763','231635',4456389,'2133','321',1313804.96,1315655.51,0.00,0.00,1850.55,1080721.20,0.00,0.00,0.00),('1','153','763','231874',4460897,'2132','321',2197222.37,2197734.63,0.00,0.00,512.26,288734.24,0.00,0.00,0.00),('1','153','763','231874',4460898,'2133','321',1315655.51,1316092.43,0.00,0.00,436.92,255161.28,0.00,0.00,0.00),('1','153','763','232010',4463199,'2132','321',2197734.63,2198778.95,0.00,0.00,1044.32,591559.36,0.00,0.00,0.00),('1','153','763','232010',4463200,'2133','321',1316092.43,1317470.59,0.00,0.00,1378.16,804845.44,0.00,0.00,0.00),('1','153','763','232084',4464748,'2132','321',2198778.95,2198778.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','232084',4464749,'2133','321',1317470.59,1321261.62,0.00,0.00,3791.03,2178372.40,0.00,0.00,0.00),('1','153','763','232315',4468756,'2132','321',2198778.95,2200717.79,0.00,0.00,1938.84,1092788.16,0.00,0.00,0.00),('1','153','763','232315',4468757,'2133','321',1321261.62,1323212.42,0.00,0.00,1950.80,1134107.20,0.00,0.00,0.00),('1','153','763','232569',4473508,'2132','321',2200717.79,2201991.38,0.00,0.00,1273.59,715679.52,0.00,0.00,0.00),('1','153','763','232569',4473509,'2133','321',1323212.42,1324264.72,0.00,0.00,1052.30,612143.20,0.00,0.00,0.00),('1','153','763','232746',4476599,'2132','321',2201991.38,2202782.70,0.00,0.00,791.32,448714.88,0.00,0.00,0.00),('1','153','763','232746',4476600,'2133','321',1324264.72,1324842.67,0.00,0.00,577.95,337522.80,0.00,0.00,0.00),('1','153','763','232824',4478031,'2132','321',2202782.70,2205384.06,0.00,0.00,2601.36,1467586.32,0.00,0.00,0.00),('1','153','763','232824',4478032,'2133','321',1324842.67,1326703.44,0.00,0.00,1860.77,1086689.68,0.00,0.00,0.00),('1','153','763','233093',4482841,'2132','321',2205384.06,2205384.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','233093',4482842,'2133','321',1326703.44,1326703.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','233094',4482843,'2132','321',2205384.06,2207645.05,0.00,0.00,2260.99,1266154.40,0.00,0.00,0.00),('1','153','763','233094',4482844,'2133','321',1326703.44,1328885.88,0.00,0.00,2182.44,1270307.76,0.00,0.00,0.00),('1','153','763','233354',4487555,'2132','321',2207645.05,2209022.47,0.00,0.00,1377.42,809994.96,0.00,0.00,0.00),('1','153','763','233354',4487556,'2133','321',1328885.88,1330172.69,0.00,0.00,1286.81,802969.44,0.00,0.00,0.00),('1','153','763','233354',4487557,'2998','321',0.00,692.23,0.00,0.00,692.23,431951.52,0.00,0.00,0.00),('1','153','763','233354',4487558,'2999','321',0.00,479.28,0.00,0.00,479.28,299070.72,0.00,0.00,0.00),('1','153','763','233582',4491833,'2132','321',2209022.47,2211213.22,0.00,0.00,2190.75,1288161.00,0.00,0.00,0.00),('1','153','763','233582',4491834,'2133','321',1330172.69,1331006.15,0.00,0.00,833.46,520079.04,0.00,0.00,0.00),('1','153','763','233582',4491835,'2998','321',692.23,1668.85,0.00,0.00,976.62,609410.88,0.00,0.00,0.00),('1','153','763','233582',4491836,'2999','321',479.28,1394.40,0.00,0.00,915.12,568154.88,0.00,0.00,0.00),('1','153','763','233822',4496019,'2132','321',2211213.22,2212758.92,0.00,0.00,1545.70,908871.60,0.00,0.00,0.00),('1','153','763','233822',4496020,'2133','321',1331006.15,1332219.67,0.00,0.00,1213.52,757236.48,0.00,0.00,0.00),('1','153','763','233822',4496021,'2998','321',1668.85,2509.26,0.00,0.00,840.41,524415.84,0.00,0.00,0.00),('1','153','763','233822',4496022,'2999','321',1394.40,2051.56,0.00,0.00,657.16,410067.84,0.00,0.00,0.00),('1','153','763','234030',4499670,'2132','321',2212758.92,2213920.98,0.00,0.00,1162.06,683291.28,0.00,0.00,0.00),('1','153','763','234030',4499671,'2133','321',1332219.67,1333478.91,0.00,0.00,1259.24,747542.40,0.00,0.00,0.00),('1','153','763','234030',4499672,'2998','321',2509.26,3313.88,0.00,0.00,804.62,502082.88,0.00,0.00,0.00),('1','153','763','234030',4499673,'2999','321',2051.56,3019.53,0.00,0.00,967.97,604013.28,0.00,0.00,0.00),('1','153','763','234348',4505220,'2132','321',2213920.98,2214822.25,0.00,0.00,901.27,530396.76,0.00,0.00,0.00),('1','153','763','234348',4505221,'2133','321',1333478.91,1334544.05,0.00,0.00,1065.14,639885.84,0.00,0.00,0.00),('1','153','763','234348',4505222,'2998','321',3313.88,3754.36,0.00,0.00,440.48,274859.52,0.00,0.00,0.00),('1','153','763','234348',4505223,'2999','321',3019.53,3647.75,0.00,0.00,628.22,392009.28,0.00,0.00,0.00),('1','153','763','234517',4508391,'2132','321',2214822.25,2214822.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','234517',4508392,'2133','321',1334544.05,1334544.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','234517',4508393,'2998','321',3754.36,3754.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','234517',4508394,'2999','321',3647.75,3647.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','234534',4508796,'2132','321',2214822.25,2215210.23,0.00,0.00,387.98,228132.24,0.00,0.00,0.00),('1','153','763','234534',4508797,'2133','321',1334544.05,1334794.83,0.00,0.00,250.78,147458.64,0.00,0.00,0.00),('1','153','763','234534',4508798,'2998','321',3754.36,4140.31,0.00,0.00,385.95,240832.80,0.00,0.00,0.00),('1','153','763','234534',4508799,'2999','321',3647.75,4053.22,0.00,0.00,405.47,253013.28,0.00,0.00,0.00),('1','153','763','234592',4509568,'2132','321',2215210.23,2215311.63,0.00,0.00,101.40,59623.20,0.00,0.00,0.00),('1','153','763','234592',4509569,'2133','321',1334794.83,1337257.42,0.00,0.00,2462.59,1448002.92,0.00,0.00,0.00),('1','153','763','234592',4509570,'2998','321',4140.31,5418.78,0.00,0.00,1278.47,797765.28,0.00,0.00,0.00),('1','153','763','234592',4509571,'2999','321',4053.22,5213.94,0.00,0.00,1160.72,724289.28,0.00,0.00,0.00),('1','153','763','234816',4513689,'2132','321',2215311.63,2215991.01,0.00,0.00,679.38,399475.44,0.00,0.00,0.00),('1','153','763','234816',4513690,'2133','321',1337257.42,1339393.84,0.00,0.00,2136.42,1278439.56,0.00,0.00,0.00),('1','153','763','234816',4513691,'2998','321',5418.78,6136.49,0.00,0.00,717.71,447851.04,0.00,0.00,0.00),('1','153','763','234816',4513692,'2999','321',5213.94,6245.28,0.00,0.00,1031.34,643556.16,0.00,0.00,0.00),('1','153','763','235046',4517935,'2132','321',2215991.01,2216348.34,0.00,0.00,357.33,210110.04,0.00,0.00,0.00),('1','153','763','235046',4517936,'2133','321',1339393.84,1341570.41,0.00,0.00,2176.57,1286852.88,0.00,0.00,0.00),('1','153','763','235046',4517937,'2998','321',6136.49,7352.02,0.00,0.00,1215.53,758490.72,0.00,0.00,0.00),('1','153','763','235046',4517938,'2999','321',6245.28,7373.28,0.00,0.00,1128.00,703872.00,0.00,0.00,0.00),('1','153','763','235280',4521873,'2132','321',2216348.34,2217572.74,0.00,0.00,1224.40,720397.20,0.00,0.00,0.00),('1','153','763','235280',4521874,'2133','321',1341570.41,1343487.64,0.00,0.00,1917.23,1150571.40,0.00,0.00,0.00),('1','153','763','235280',4521875,'2998','321',7352.02,8079.54,0.00,0.00,727.52,453972.48,0.00,0.00,0.00),('1','153','763','235280',4521876,'2999','321',7373.28,8060.63,0.00,0.00,687.35,428906.40,0.00,0.00,0.00),('1','153','763','235530',4526133,'2132','321',2217572.74,2218956.18,0.00,0.00,1383.44,813462.72,0.00,0.00,0.00),('1','153','763','235530',4526134,'2133','321',1343487.64,1345381.47,0.00,0.00,1893.83,1153046.76,0.00,0.00,0.00),('1','153','763','235530',4526135,'2998','321',8079.54,8642.53,0.00,0.00,562.99,351305.76,0.00,0.00,0.00),('1','153','763','235530',4526136,'2999','321',8060.63,8551.73,0.00,0.00,491.10,306446.40,0.00,0.00,0.00),('1','153','763','235728',4529774,'2132','321',2218956.18,2218956.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','235728',4529775,'2133','321',1345381.47,1345381.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','235728',4529776,'2998','321',8642.53,8642.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','235728',4529777,'2999','321',8551.73,8551.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','235815',4531166,'2132','321',2218956.18,2219609.97,0.00,0.00,653.79,384428.52,0.00,0.00,0.00),('1','153','763','235815',4531167,'2133','321',1345381.47,1345846.67,0.00,0.00,465.20,290284.80,0.00,0.00,0.00),('1','153','763','235815',4531168,'2998','321',8642.53,8776.79,0.00,0.00,134.26,83778.24,0.00,0.00,0.00),('1','153','763','235815',4531169,'2999','321',8551.73,8560.60,0.00,0.00,8.87,5534.88,0.00,0.00,0.00),('1','153','763','235839',4531652,'2132','321',2219609.97,2220180.58,0.00,0.00,570.61,345816.18,0.00,0.00,0.00),('1','153','763','235839',4531653,'2133','321',1345846.67,1347987.06,0.00,0.00,2140.39,1331093.34,0.00,0.00,0.00),('1','153','763','235839',4531654,'2998','321',8776.79,9509.80,0.00,0.00,733.01,469023.84,0.00,0.00,0.00),('1','153','763','235839',4531655,'2999','321',8560.60,9359.40,0.00,0.00,798.80,511232.00,0.00,0.00,0.00),('1','153','763','236013',4534581,'2132','321',2220180.58,2220332.67,0.00,0.00,152.09,92166.54,0.00,0.00,0.00),('1','153','763','236013',4534582,'2133','321',1347987.06,1348292.70,0.00,0.00,305.64,185217.84,0.00,0.00,0.00),('1','153','763','236013',4534583,'2998','321',9509.80,9655.54,0.00,0.00,145.74,93273.60,0.00,0.00,0.00),('1','153','763','236013',4534584,'2999','321',9359.40,9433.61,0.00,0.00,74.21,47494.40,0.00,0.00,0.00),('1','153','763','236171',4537622,'2132','321',2220332.67,2220867.11,0.00,0.00,534.44,323870.64,0.00,0.00,0.00),('1','153','763','236171',4537623,'2133','321',1348292.70,1350308.69,0.00,0.00,2015.99,1241663.58,0.00,0.00,0.00),('1','153','763','236171',4537624,'2998','321',9655.54,10474.83,0.00,0.00,819.29,524345.60,0.00,0.00,0.00),('1','153','763','236171',4537625,'2999','321',9433.61,9953.27,0.00,0.00,519.66,332582.40,0.00,0.00,0.00),('1','153','763','236219',4538535,'2132','321',2220867.11,2221159.85,0.00,0.00,292.74,177400.44,0.00,0.00,0.00),('1','153','763','236219',4538536,'2133','321',1350308.69,1352465.06,0.00,0.00,2156.37,1342506.12,0.00,0.00,0.00),('1','153','763','236219',4538537,'2998','321',10474.83,11602.58,0.00,0.00,1127.75,721760.00,0.00,0.00,0.00),('1','153','763','236219',4538538,'2999','321',9953.27,10999.09,0.00,0.00,1045.82,669324.80,0.00,0.00,0.00),('1','153','763','236487',4543232,'2132','321',2221159.85,2221965.01,0.00,0.00,805.16,488912.96,0.00,0.00,0.00),('1','153','763','236487',4543233,'2133','321',1352465.06,1354421.57,0.00,0.00,1956.51,1219315.94,0.00,0.00,0.00),('1','153','763','236487',4543234,'2998','321',11602.58,12894.28,0.00,0.00,1291.70,826688.00,0.00,0.00,0.00),('1','153','763','236487',4543235,'2999','321',10999.09,11557.63,0.00,0.00,558.54,357465.60,0.00,0.00,0.00),('1','153','763','236715',4547013,'2132','321',2221965.01,2222195.62,0.00,0.00,230.61,139749.66,0.00,0.00,0.00),('1','153','763','236715',4547014,'2133','321',1354421.57,1358138.42,0.00,0.00,3716.85,2285460.46,0.00,0.00,0.00),('1','153','763','236715',4547015,'2998','321',12894.28,14267.65,0.00,0.00,1373.37,878956.80,0.00,0.00,0.00),('1','153','763','236715',4547016,'2999','321',11557.63,12324.54,0.00,0.00,766.91,490822.40,0.00,0.00,0.00),('1','153','763','236934',4550930,'2132','321',2222195.62,2222399.96,0.00,0.00,204.34,124238.72,0.00,0.00,0.00),('1','153','763','236934',4550931,'2133','321',1358138.42,1360937.20,0.00,0.00,2798.78,1732529.08,0.00,0.00,0.00),('1','153','763','236934',4550932,'2998','321',14267.65,15297.49,0.00,0.00,1029.84,659097.60,0.00,0.00,0.00),('1','153','763','236934',4550933,'2999','321',12324.54,13137.77,0.00,0.00,813.23,520467.20,0.00,0.00,0.00),('1','153','763','237149',4554760,'2132','321',2222399.96,2222399.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237149',4554761,'2133','321',1360937.20,1361510.64,0.00,0.00,573.44,357099.10,0.00,0.00,0.00),('1','153','763','237149',4554762,'2998','321',15297.49,15517.88,0.00,0.00,220.39,141049.60,0.00,0.00,0.00),('1','153','763','237149',4554763,'2999','321',13137.77,13137.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237246',4556172,'2132','321',2222399.96,2222399.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237246',4556173,'2133','321',1361510.64,1361510.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237246',4556174,'2998','321',15517.88,15517.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237246',4556175,'2999','321',13137.77,13137.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','237255',4556357,'2132','321',2222399.96,2223262.69,0.00,0.00,862.73,535054.38,0.00,0.00,0.00),('1','153','763','237255',4556358,'2133','321',1361510.64,1362946.46,0.00,0.00,1435.82,896026.48,0.00,0.00,0.00),('1','153','763','237255',4556359,'2998','321',15517.88,16310.23,0.00,0.00,792.35,507104.00,0.00,0.00,0.00),('1','153','763','237255',4556360,'2999','321',13137.77,13247.85,0.00,0.00,110.08,70451.20,0.00,0.00,0.00),('1','153','763','237363',4558626,'2132','321',2223262.69,2223739.73,0.00,0.00,477.04,289086.24,0.00,0.00,0.00),('1','153','763','237363',4558627,'2133','321',1362946.46,1365069.26,0.00,0.00,2122.80,1325937.72,0.00,0.00,0.00),('1','153','763','237363',4558628,'2998','321',16310.23,17298.69,0.00,0.00,988.46,632614.40,0.00,0.00,0.00),('1','153','763','237363',4558629,'2999','321',13247.85,13925.32,0.00,0.00,677.47,433580.80,0.00,0.00,0.00),('1','153','763','237585',4562619,'2132','321',2223739.73,2224089.30,0.00,0.00,349.57,219053.32,0.00,0.00,0.00),('1','153','763','237585',4562620,'2133','321',1365069.26,1367352.25,0.00,0.00,2282.99,1458350.42,0.00,0.00,0.00),('1','153','763','237585',4562621,'2998','321',17298.69,18394.80,0.00,0.00,1096.11,714022.08,0.00,0.00,0.00),('1','153','763','237585',4562622,'2999','321',13925.32,14251.37,0.00,0.00,326.05,208769.60,0.00,0.00,0.00),('1','153','763','237845',4566880,'2132','321',2224089.30,2224271.50,0.00,0.00,182.20,113328.40,0.00,0.00,0.00),('1','153','763','237845',4566881,'2133','321',1367352.25,1369588.97,0.00,0.00,2236.72,1411386.88,0.00,0.00,0.00),('1','153','763','237845',4566882,'2998','321',18394.80,19606.35,0.00,0.00,1211.55,775392.00,0.00,0.00,0.00),('1','153','763','237845',4566883,'2999','321',14251.37,14925.08,0.00,0.00,673.71,431174.40,0.00,0.00,0.00),('1','153','763','238105',4570991,'2132','321',2224271.50,2224643.95,0.00,0.00,372.45,237360.00,0.00,0.00,0.00),('1','153','763','238105',4570992,'2133','321',1369588.97,1371782.92,0.00,0.00,2193.95,1374864.68,0.00,0.00,0.00),('1','153','763','238105',4570993,'2998','321',19606.35,21009.79,0.00,0.00,1403.44,898201.60,0.00,0.00,0.00),('1','153','763','238105',4570994,'2999','321',14925.08,15124.10,0.00,0.00,199.02,127372.80,0.00,0.00,0.00),('1','153','763','238332',4575079,'2132','321',2224643.95,2224719.42,0.00,0.00,75.47,47264.72,0.00,0.00,0.00),('1','153','763','238332',4575080,'2133','321',1371782.92,1373599.09,0.00,0.00,1816.17,1153698.00,0.00,0.00,0.00),('1','153','763','238332',4575081,'2998','321',21009.79,21991.67,0.00,0.00,981.88,628403.20,0.00,0.00,0.00),('1','153','763','238332',4575082,'2999','321',15124.10,15330.75,0.00,0.00,206.65,132256.00,0.00,0.00,0.00),('1','153','763','238593',4579311,'2132','321',2224719.42,2225089.91,0.00,0.00,370.49,236861.60,0.00,0.00,0.00),('1','153','763','238593',4579312,'2133','321',1373599.09,1374307.95,0.00,0.00,708.86,449620.40,0.00,0.00,0.00),('1','153','763','238593',4579313,'2998','321',21991.67,22356.69,0.00,0.00,365.02,233612.80,0.00,0.00,0.00),('1','153','763','238593',4579314,'2999','321',15330.75,15330.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238703',4581213,'2132','321',2225089.91,2225089.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238703',4581214,'2133','321',1374307.95,1374307.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238703',4581215,'2998','321',22356.69,22356.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238703',4581216,'2999','321',15330.75,15330.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238705',4581225,'2132','321',2225089.91,2225471.25,0.00,0.00,381.34,241997.32,0.00,0.00,0.00),('1','153','763','238705',4581226,'2133','321',1374307.95,1375514.50,0.00,0.00,1206.55,763460.38,0.00,0.00,0.00),('1','153','763','238705',4581227,'2998','321',22356.69,23182.26,0.00,0.00,825.57,528364.80,0.00,0.00,0.00),('1','153','763','238705',4581228,'2999','321',15330.75,15330.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','238816',4583284,'2132','321',2225471.25,2225507.04,0.00,0.00,35.79,22905.60,0.00,0.00,0.00),('1','153','763','238816',4583285,'2133','321',1375514.50,1377594.65,0.00,0.00,2080.15,1316866.30,0.00,0.00,0.00),('1','153','763','238816',4583286,'2998','321',23182.26,24389.03,0.00,0.00,1206.77,772332.80,0.00,0.00,0.00),('1','153','763','238816',4583287,'2999','321',15330.75,15497.94,0.00,0.00,167.19,107001.60,0.00,0.00,0.00),('1','153','763','239051',4587475,'2132','321',2225507.04,2225654.21,0.00,0.00,147.17,94188.80,0.00,0.00,0.00),('1','153','763','239051',4587476,'2133','321',1377594.65,1380251.69,0.00,0.00,2657.04,1678974.00,0.00,0.00,0.00),('1','153','763','239051',4587477,'2998','321',24389.03,25452.50,0.00,0.00,1063.47,680620.80,0.00,0.00,0.00),('1','153','763','239051',4587478,'2999','321',15497.94,15497.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','239276',4591338,'2132','321',2225654.21,2225868.98,0.00,0.00,214.77,137452.80,0.00,0.00,0.00),('1','153','763','239276',4591339,'2133','321',1380251.69,1382128.85,0.00,0.00,1877.16,1188246.00,0.00,0.00,0.00),('1','153','763','239276',4591340,'2998','321',25452.50,26615.20,0.00,0.00,1162.70,744128.00,0.00,0.00,0.00),('1','153','763','239276',4591341,'2999','321',15497.94,15502.63,0.00,0.00,4.69,3001.60,0.00,0.00,0.00),('1','153','763','239504',4595261,'2132','321',2225868.98,2226090.33,0.00,0.00,221.35,141664.00,0.00,0.00,0.00),('1','153','763','239504',4595262,'2133','321',1382128.85,1383923.98,0.00,0.00,1795.13,1139270.48,0.00,0.00,0.00),('1','153','763','239504',4595263,'2998','321',26615.20,27700.14,0.00,0.00,1084.94,693231.20,0.00,0.00,0.00),('1','153','763','239504',4595264,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','239765',4599631,'2132','321',2226090.33,2226233.63,0.00,0.00,143.30,94004.80,0.00,0.00,0.00),('1','153','763','239765',4599632,'2133','321',1383923.98,1385574.76,0.00,0.00,1650.78,1065687.72,0.00,0.00,0.00),('1','153','763','239765',4599633,'2998','321',27700.14,28930.62,0.00,0.00,1230.48,807194.88,0.00,0.00,0.00),('1','153','763','239765',4599634,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','239968',4603366,'2132','321',2226233.63,2226233.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','239968',4603367,'2133','321',1385574.76,1387393.19,0.00,0.00,1818.43,1176685.84,0.00,0.00,0.00),('1','153','763','239968',4603368,'2998','321',28930.62,30073.98,0.00,0.00,1143.36,746857.34,0.00,0.00,0.00),('1','153','763','239968',4603369,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240173',4606931,'2132','321',2226233.63,2226233.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240173',4606932,'2133','321',1387393.19,1388848.45,0.00,0.00,1455.26,943410.76,0.00,0.00,0.00),('1','153','763','240173',4606933,'2998','321',30073.98,30486.22,0.00,0.00,412.24,270429.44,0.00,0.00,0.00),('1','153','763','240173',4606934,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240358',4609979,'2132','321',2226233.63,2226233.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240358',4609980,'2133','321',1388848.45,1388848.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240358',4609981,'2998','321',30486.22,30486.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240358',4609982,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240359',4609983,'2132','321',2226233.63,2226233.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240359',4609984,'2133','321',1388848.45,1389511.80,0.00,0.00,663.35,428585.58,0.00,0.00,0.00),('1','153','763','240359',4609985,'2998','321',30486.22,30795.94,0.00,0.00,309.72,203176.32,0.00,0.00,0.00),('1','153','763','240359',4609986,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240430',4611130,'2132','321',2226233.63,2226343.15,0.00,0.00,109.52,70092.80,0.00,0.00,0.00),('1','153','763','240430',4611131,'2133','321',1389511.80,1391878.56,0.00,0.00,2366.76,1495641.84,0.00,0.00,0.00),('1','153','763','240430',4611132,'2998','321',30795.94,32031.30,0.00,0.00,1235.36,779555.36,0.00,0.00,0.00),('1','153','763','240430',4611133,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240651',4614639,'2132','321',2226343.15,2226478.97,0.00,0.00,135.82,83665.12,0.00,0.00,0.00),('1','153','763','240651',4614640,'2133','321',1391878.56,1393342.20,0.00,0.00,1463.64,929274.24,0.00,0.00,0.00),('1','153','763','240651',4614641,'2998','321',32031.30,33077.90,0.00,0.00,1046.60,669824.00,0.00,0.00,0.00),('1','153','763','240651',4614642,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','240958',4619824,'2132','321',2226478.97,2226600.03,0.00,0.00,121.06,77478.40,0.00,0.00,0.00),('1','153','763','240958',4619825,'2133','321',1393342.20,1395382.00,0.00,0.00,2039.80,1290498.16,0.00,0.00,0.00),('1','153','763','240958',4619826,'2998','321',33077.90,34245.13,0.00,0.00,1167.23,744116.00,0.00,0.00,0.00),('1','153','763','240958',4619827,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','241198',4624282,'2132','321',2226600.03,2226667.18,0.00,0.00,67.15,42976.00,0.00,0.00,0.00),('1','153','763','241198',4624283,'2133','321',1395382.00,1396878.98,0.00,0.00,1496.98,950245.92,0.00,0.00,0.00),('1','153','763','241198',4624284,'2998','321',34245.13,35306.86,0.00,0.00,1061.73,679507.20,0.00,0.00,0.00),('1','153','763','241198',4624285,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','241475',4628918,'2132','321',2226667.18,2226667.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','241475',4628919,'2133','321',1396878.98,1398565.64,0.00,0.00,1686.66,1074720.72,0.00,0.00,0.00),('1','153','763','241475',4628920,'2998','321',35306.86,36512.05,0.00,0.00,1205.19,765894.24,0.00,0.00,0.00),('1','153','763','241475',4628921,'2999','321',15502.63,15502.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','241709',4633014,'2132','321',2226667.18,2227325.33,0.00,0.00,658.15,417120.40,0.00,0.00,0.00),('1','153','763','241709',4633015,'2133','321',1398565.64,1400416.28,0.00,0.00,1850.64,1156016.40,0.00,0.00,0.00),('1','153','763','241709',4633016,'2998','321',36512.05,37370.59,0.00,0.00,858.54,549465.60,0.00,0.00,0.00),('1','153','763','241709',4633017,'2999','321',15502.63,15540.13,0.00,0.00,37.50,23248.56,0.00,0.00,0.00),('1','153','763','241958',4637266,'2132','321',2227325.33,2227394.59,0.00,0.00,69.26,44326.40,0.00,0.00,0.00),('1','153','763','241958',4637267,'2133','321',1400416.28,1401937.73,0.00,0.00,1521.45,969704.88,0.00,0.00,0.00),('1','153','763','241958',4637268,'2998','321',37370.59,38382.71,0.00,0.00,1012.12,642995.92,0.00,0.00,0.00),('1','153','763','241958',4637269,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242191',4641415,'2132','321',2227394.59,2227536.44,0.00,0.00,141.85,90784.00,0.00,0.00,0.00),('1','153','763','242191',4641416,'2133','321',1401937.73,1403541.28,0.00,0.00,1603.55,1020997.04,0.00,0.00,0.00),('1','153','763','242191',4641417,'2998','321',38382.71,39193.69,0.00,0.00,810.98,519027.20,0.00,0.00,0.00),('1','153','763','242191',4641418,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242366',4644457,'2132','321',2227536.44,2227536.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242366',4644458,'2133','321',1403541.28,1403541.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242366',4644459,'2998','321',39193.69,39193.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242366',4644460,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242416',4645307,'2132','321',2227536.44,2227745.33,0.00,0.00,208.89,133689.60,0.00,0.00,0.00),('1','153','763','242416',4645308,'2133','321',1403541.28,1405126.17,0.00,0.00,1584.89,1005907.52,0.00,0.00,0.00),('1','153','763','242416',4645309,'2998','321',39193.69,40498.37,0.00,0.00,1304.68,828119.68,0.00,0.00,0.00),('1','153','763','242416',4645310,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242648',4649498,'2132','321',2227745.33,2228039.84,0.00,0.00,294.51,182906.40,0.00,0.00,0.00),('1','153','763','242648',4649499,'2133','321',1405126.17,1406658.18,0.00,0.00,1532.01,975302.64,0.00,0.00,0.00),('1','153','763','242648',4649500,'2998','321',40498.37,41673.95,0.00,0.00,1175.58,752371.20,0.00,0.00,0.00),('1','153','763','242648',4649501,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','242897',4653653,'2132','321',2228039.84,2228232.75,0.00,0.00,192.91,123462.40,0.00,0.00,0.00),('1','153','763','242897',4653654,'2133','321',1406658.18,1408164.73,0.00,0.00,1506.55,959618.08,0.00,0.00,0.00),('1','153','763','242897',4653655,'2998','321',41673.95,43202.53,0.00,0.00,1528.58,975519.20,0.00,0.00,0.00),('1','153','763','242897',4653656,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','243137',4657707,'2132','321',2228232.75,2228841.32,0.00,0.00,608.57,386448.80,0.00,0.00,0.00),('1','153','763','243137',4657708,'2133','321',1408164.73,1409992.75,0.00,0.00,1828.02,1163901.36,0.00,0.00,0.00),('1','153','763','243137',4657709,'2998','321',43202.53,44468.83,0.00,0.00,1266.30,810432.00,0.00,0.00,0.00),('1','153','763','243137',4657710,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','243343',4661612,'2132','321',2228841.32,2228897.69,0.00,0.00,56.37,36076.80,0.00,0.00,0.00),('1','153','763','243343',4661613,'2133','321',1409992.75,1411885.64,0.00,0.00,1892.89,1208593.60,0.00,0.00,0.00),('1','153','763','243343',4661614,'2998','321',44468.83,45944.23,0.00,0.00,1475.40,940593.36,0.00,0.00,0.00),('1','153','763','243343',4661615,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','243589',4665711,'2132','321',2228897.69,2229610.83,0.00,0.00,713.14,452689.60,0.00,0.00,0.00),('1','153','763','243589',4665712,'2133','321',1411885.64,1414023.32,0.00,0.00,2137.68,1361455.20,0.00,0.00,0.00),('1','153','763','243589',4665713,'2998','321',45944.23,46070.48,0.00,0.00,126.25,80800.00,0.00,0.00,0.00),('1','153','763','243589',4665714,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','243817',4669755,'2132','321',2229610.83,2229768.49,0.00,0.00,157.66,97310.56,0.00,0.00,0.00),('1','153','763','243817',4669756,'2133','321',1414023.32,1415800.50,0.00,0.00,1777.18,1136579.20,0.00,0.00,0.00),('1','153','763','243817',4669757,'2998','321',46070.48,47448.90,0.00,0.00,1378.42,882041.44,0.00,0.00,0.00),('1','153','763','243817',4669758,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244034',4673537,'2132','321',2229768.49,2230001.59,0.00,0.00,233.10,149184.00,0.00,0.00,0.00),('1','153','763','244034',4673538,'2133','321',1415800.50,1416733.99,0.00,0.00,933.49,595723.36,0.00,0.00,0.00),('1','153','763','244034',4673539,'2998','321',47448.90,48478.90,0.00,0.00,1030.00,654670.24,0.00,0.00,0.00),('1','153','763','244034',4673540,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244259',4677381,'2132','321',2230001.59,2230001.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244259',4677382,'2133','321',1416733.99,1416733.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244259',4677383,'2998','321',48478.90,48478.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244259',4677384,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244277',4677521,'2132','321',2230001.59,2230506.38,0.00,0.00,504.79,323065.60,0.00,0.00,0.00),('1','153','763','244277',4677522,'2133','321',1416733.99,1418466.81,0.00,0.00,1732.82,1109004.80,0.00,0.00,0.00),('1','153','763','244277',4677523,'2998','321',48478.90,49854.20,0.00,0.00,1375.30,867759.76,0.00,0.00,0.00),('1','153','763','244277',4677524,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244503',4681577,'2132','321',2230506.38,2230776.21,0.00,0.00,269.83,172691.20,0.00,0.00,0.00),('1','153','763','244503',4681578,'2133','321',1418466.81,1419946.33,0.00,0.00,1479.52,939647.68,0.00,0.00,0.00),('1','153','763','244503',4681579,'2998','321',49854.20,50893.46,0.00,0.00,1039.26,665126.40,0.00,0.00,0.00),('1','153','763','244503',4681580,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244732',4685346,'2132','321',2230776.21,2230830.82,0.00,0.00,54.61,34950.40,0.00,0.00,0.00),('1','153','763','244732',4685347,'2133','321',1419946.33,1421261.25,0.00,0.00,1314.92,839655.20,0.00,0.00,0.00),('1','153','763','244732',4685348,'2998','321',50893.46,51980.40,0.00,0.00,1086.94,693094.24,0.00,0.00,0.00),('1','153','763','244732',4685349,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','244958',4689494,'2132','321',2230830.82,2231277.32,0.00,0.00,446.50,275211.84,0.00,0.00,0.00),('1','153','763','244958',4689495,'2133','321',1421261.25,1422416.79,0.00,0.00,1155.54,718656.96,0.00,0.00,0.00),('1','153','763','244958',4689496,'2998','321',51980.40,53051.62,0.00,0.00,1071.22,668441.28,0.00,0.00,0.00),('1','153','763','244958',4689497,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','245199',4693674,'2132','321',2231277.32,2231536.72,0.00,0.00,259.40,161865.60,0.00,0.00,0.00),('1','153','763','245199',4693675,'2133','321',1422416.79,1424241.69,0.00,0.00,1824.90,1131348.00,0.00,0.00,0.00),('1','153','763','245199',4693676,'2998','321',53051.62,54394.49,0.00,0.00,1342.87,837950.88,0.00,0.00,0.00),('1','153','763','245199',4693677,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','245423',4697586,'2132','321',2231536.72,2231927.12,0.00,0.00,390.40,240105.60,0.00,0.00,0.00),('1','153','763','245423',4697587,'2133','321',1424241.69,1425833.85,0.00,0.00,1592.16,989723.04,0.00,0.00,0.00),('1','153','763','245423',4697588,'2998','321',54394.49,55366.26,0.00,0.00,971.77,606384.48,0.00,0.00,0.00),('1','153','763','245423',4697589,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','245662',4701756,'2132','321',2231927.12,2232259.79,0.00,0.00,332.67,203402.88,0.00,0.00,0.00),('1','153','763','245662',4701757,'2133','321',1425833.85,1427071.80,0.00,0.00,1237.95,771232.80,0.00,0.00,0.00),('1','153','763','245662',4701758,'2998','321',55366.26,56455.79,0.00,0.00,1089.53,679866.72,0.00,0.00,0.00),('1','153','763','245662',4701759,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','245964',4706150,'2132','321',2232259.79,2233257.86,0.00,0.00,998.07,598711.12,0.00,0.00,0.00),('1','153','763','245964',4706151,'2133','321',1427071.80,1428465.65,0.00,0.00,1393.85,857231.60,0.00,0.00,0.00),('1','153','763','245964',4706152,'2998','321',56455.79,57454.75,0.00,0.00,998.96,584093.16,0.00,0.00,0.00),('1','153','763','245964',4706153,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','246171',4709914,'2132','321',2233257.86,2233368.55,0.00,0.00,110.69,67603.60,0.00,0.00,0.00),('1','153','763','246171',4709915,'2133','321',1428465.65,1429030.61,0.00,0.00,564.96,343249.30,0.00,0.00,0.00),('1','153','763','246171',4709916,'2998','321',57454.75,57971.14,0.00,0.00,516.39,318096.24,0.00,0.00,0.00),('1','153','763','246171',4709917,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','246330',4712297,'2132','321',2233368.55,2233637.72,0.00,0.00,269.17,164984.40,0.00,0.00,0.00),('1','153','763','246330',4712298,'2133','321',1429030.61,1429961.98,0.00,0.00,931.37,566416.82,0.00,0.00,0.00),('1','153','763','246330',4712299,'2998','321',57971.14,58872.56,0.00,0.00,901.42,555274.72,0.00,0.00,0.00),('1','153','763','246330',4712300,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','246436',4714390,'2132','321',2233637.72,2234224.18,0.00,0.00,586.46,356659.36,0.00,0.00,0.00),('1','153','763','246436',4714391,'2133','321',1429961.98,1430976.83,0.00,0.00,1014.85,619692.46,0.00,0.00,0.00),('1','153','763','246436',4714392,'2998','321',58872.56,59951.36,0.00,0.00,1078.80,646345.50,0.00,0.00,0.00),('1','153','763','246436',4714393,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','246685',4718683,'2132','321',2234224.18,2234653.19,0.00,0.00,429.01,253409.10,0.00,0.00,0.00),('1','153','763','246685',4718684,'2133','321',1430976.83,1431884.97,0.00,0.00,908.14,559179.18,0.00,0.00,0.00),('1','153','763','246685',4718685,'2998','321',59951.36,61362.27,0.00,0.00,1410.91,869120.56,0.00,0.00,0.00),('1','153','763','246685',4718686,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','246916',4722861,'2132','321',2234653.19,2235246.35,0.00,0.00,593.16,364129.84,0.00,0.00,0.00),('1','153','763','246916',4722862,'2133','321',1431884.97,1433111.63,0.00,0.00,1226.66,746107.00,0.00,0.00,0.00),('1','153','763','246916',4722863,'2998','321',61362.27,62604.67,0.00,0.00,1242.40,730473.40,0.00,0.00,0.00),('1','153','763','246916',4722864,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','247156',4726866,'2132','321',2235246.35,2235606.21,0.00,0.00,359.86,221213.76,0.00,0.00,0.00),('1','153','763','247156',4726867,'2133','321',1433111.63,1434635.19,0.00,0.00,1523.56,922908.84,0.00,0.00,0.00),('1','153','763','247156',4726868,'2998','321',62604.67,63848.21,0.00,0.00,1243.54,766020.64,0.00,0.00,0.00),('1','153','763','247156',4726869,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','247384',4730925,'2132','321',2235606.21,2236154.51,0.00,0.00,548.30,337752.80,0.00,0.00,0.00),('1','153','763','247384',4730926,'2133','321',1434635.19,1435848.87,0.00,0.00,1213.68,740726.88,0.00,0.00,0.00),('1','153','763','247384',4730927,'2998','321',63848.21,64934.46,0.00,0.00,1086.25,654732.00,0.00,0.00,0.00),('1','153','763','247384',4730928,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','247650',4735366,'2132','321',2236154.51,2236402.44,0.00,0.00,247.93,149170.92,0.00,0.00,0.00),('1','153','763','247650',4735367,'2133','321',1435848.87,1437082.64,0.00,0.00,1233.77,750572.32,0.00,0.00,0.00),('1','153','763','247650',4735368,'2998','321',64934.46,66073.34,0.00,0.00,1138.88,701550.08,0.00,0.00,0.00),('1','153','763','247650',4735369,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','247895',4739509,'2132','321',2236402.44,2236781.59,0.00,0.00,379.15,222436.36,0.00,0.00,0.00),('1','153','763','247895',4739510,'2133','321',1437082.64,1438128.60,0.00,0.00,1045.96,636182.70,0.00,0.00,0.00),('1','153','763','247895',4739511,'2998','321',66073.34,67201.74,0.00,0.00,1128.40,695094.40,0.00,0.00,0.00),('1','153','763','247895',4739512,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248138',4743653,'2132','321',2236781.59,2237209.84,0.00,0.00,428.25,263802.00,0.00,0.00,0.00),('1','153','763','248138',4743654,'2133','321',1438128.60,1439392.65,0.00,0.00,1264.05,755212.74,0.00,0.00,0.00),('1','153','763','248138',4743655,'2998','321',67201.74,68289.56,0.00,0.00,1087.82,670097.12,0.00,0.00,0.00),('1','153','763','248138',4743656,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248405',4748014,'2132','321',2237209.84,2237234.21,0.00,0.00,24.37,15011.92,0.00,0.00,0.00),('1','153','763','248405',4748015,'2133','321',1439392.65,1439483.40,0.00,0.00,90.75,55902.00,0.00,0.00,0.00),('1','153','763','248405',4748016,'2998','321',68289.56,68350.73,0.00,0.00,61.17,37680.72,0.00,0.00,0.00),('1','153','763','248405',4748017,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248481',4749239,'2132','321',2237234.21,2237234.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248481',4749240,'2133','321',1439483.40,1439483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248481',4749241,'2998','321',68350.73,68350.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248481',4749242,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248487',4749418,'2132','321',2237234.21,2237787.83,0.00,0.00,553.62,338545.92,0.00,0.00,0.00),('1','153','763','248487',4749419,'2133','321',1439483.40,1440373.85,0.00,0.00,890.45,541636.06,0.00,0.00,0.00),('1','153','763','248487',4749420,'2998','321',68350.73,69478.14,0.00,0.00,1127.41,686325.08,0.00,0.00,0.00),('1','153','763','248487',4749421,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248623',4751796,'2132','321',2237787.83,2237901.45,0.00,0.00,113.62,69989.92,0.00,0.00,0.00),('1','153','763','248623',4751797,'2133','321',1440373.85,1441731.10,0.00,0.00,1357.25,826820.00,0.00,0.00,0.00),('1','153','763','248623',4751798,'2998','321',69478.14,70727.91,0.00,0.00,1249.77,766716.98,0.00,0.00,0.00),('1','153','763','248623',4751799,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','248874',4755975,'2132','321',2237901.45,2238237.89,0.00,0.00,336.44,201864.00,0.00,0.00,0.00),('1','153','763','248874',4755976,'2133','321',1441731.10,1442635.97,0.00,0.00,904.87,540177.00,0.00,0.00,0.00),('1','153','763','248874',4755977,'2998','321',70727.91,71837.74,0.00,0.00,1109.83,653137.35,0.00,0.00,0.00),('1','153','763','248874',4755978,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','249089',4759690,'2132','321',2238237.89,2238409.34,0.00,0.00,171.45,98370.00,0.00,0.00,0.00),('1','153','763','249089',4759691,'2133','321',1442635.97,1443979.92,0.00,0.00,1343.95,795634.35,0.00,0.00,0.00),('1','153','763','249089',4759692,'2998','321',71837.74,73041.77,0.00,0.00,1204.03,722418.00,0.00,0.00,0.00),('1','153','763','249089',4759693,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','249326',4763786,'2132','321',2238409.34,2238667.12,0.00,0.00,257.78,150851.55,0.00,0.00,0.00),('1','153','763','249326',4763787,'2133','321',1443979.92,1445312.04,0.00,0.00,1332.12,792184.50,0.00,0.00,0.00),('1','153','763','249326',4763788,'2998','321',73041.77,74399.36,0.00,0.00,1357.59,814509.00,0.00,0.00,0.00),('1','153','763','249326',4763789,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','249564',4767795,'2132','321',2238667.12,2239218.39,0.00,0.00,551.27,330762.00,0.00,0.00,0.00),('1','153','763','249564',4767796,'2133','321',1445312.04,1447012.04,0.00,0.00,1700.00,997027.50,0.00,0.00,0.00),('1','153','763','249564',4767797,'2998','321',74399.36,75487.77,0.00,0.00,1088.41,649761.00,0.00,0.00,0.00),('1','153','763','249564',4767798,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','249827',4772291,'2132','321',2239218.39,2239470.27,0.00,0.00,251.88,151128.00,0.00,0.00,0.00),('1','153','763','249827',4772292,'2133','321',1447012.04,1448211.85,0.00,0.00,1199.81,717073.50,0.00,0.00,0.00),('1','153','763','249827',4772293,'2998','321',75487.77,77083.47,0.00,0.00,1595.70,941472.45,0.00,0.00,0.00),('1','153','763','249827',4772294,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250076',4776324,'2132','321',2239470.27,2239745.74,0.00,0.00,275.47,165282.00,0.00,0.00,0.00),('1','153','763','250076',4776325,'2133','321',1448211.85,1450152.90,0.00,0.00,1941.05,1149931.20,0.00,0.00,0.00),('1','153','763','250076',4776326,'2998','321',77083.47,78431.47,0.00,0.00,1348.00,808800.00,0.00,0.00,0.00),('1','153','763','250076',4776327,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250316',4780450,'2132','321',2239745.74,2240016.95,0.00,0.00,271.21,150521.55,0.00,0.00,0.00),('1','153','763','250316',4780451,'2133','321',1450152.90,1450376.32,0.00,0.00,223.42,134052.00,0.00,0.00,0.00),('1','153','763','250316',4780452,'2998','321',78431.47,78723.05,0.00,0.00,291.58,171964.95,0.00,0.00,0.00),('1','153','763','250316',4780453,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250413',4781671,'2132','321',2240016.95,2240016.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250413',4781672,'2133','321',1450376.32,1450376.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250413',4781673,'2998','321',78723.05,78723.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250413',4781674,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250424',4781883,'2132','321',2240016.95,2240428.08,0.00,0.00,411.13,233521.84,0.00,0.00,0.00),('1','153','763','250424',4781884,'2133','321',1450376.32,1451378.71,0.00,0.00,1002.39,564673.92,0.00,0.00,0.00),('1','153','763','250424',4781885,'2998','321',78723.05,79710.35,0.00,0.00,987.30,560786.40,0.00,0.00,0.00),('1','153','763','250424',4781886,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250554',4784289,'2132','321',2240428.08,2240664.71,0.00,0.00,236.63,134405.84,0.00,0.00,0.00),('1','153','763','250554',4784290,'2133','321',1451378.71,1453433.62,0.00,0.00,2054.91,1162199.28,0.00,0.00,0.00),('1','153','763','250554',4784291,'2998','321',79710.35,81097.33,0.00,0.00,1386.98,787804.64,0.00,0.00,0.00),('1','153','763','250554',4784292,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','250784',4788323,'2132','321',2240664.71,2241081.86,0.00,0.00,417.15,231235.68,0.00,0.00,0.00),('1','153','763','250784',4788324,'2133','321',1453433.62,1455054.41,0.00,0.00,1620.79,914583.52,0.00,0.00,0.00),('1','153','763','250784',4788325,'2998','321',81097.33,82401.79,0.00,0.00,1304.46,740933.28,0.00,0.00,0.00),('1','153','763','250784',4788326,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','251001',4792230,'2132','321',2241081.86,2241775.46,0.00,0.00,693.60,393964.80,0.00,0.00,0.00),('1','153','763','251001',4792231,'2133','321',1455054.41,1456943.18,0.00,0.00,1888.77,1072065.36,0.00,0.00,0.00),('1','153','763','251001',4792232,'2998','321',82401.79,83833.43,0.00,0.00,1431.64,796728.64,0.00,0.00,0.00),('1','153','763','251001',4792233,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','251253',4796631,'2132','321',2241775.46,2242526.87,0.00,0.00,751.41,415987.92,0.00,0.00,0.00),('1','153','763','251253',4796632,'2133','321',1456943.18,1458549.08,0.00,0.00,1605.90,908431.20,0.00,0.00,0.00),('1','153','763','251253',4796633,'2998','321',83833.43,85503.75,0.00,0.00,1670.32,948741.76,0.00,0.00,0.00),('1','153','763','251253',4796634,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','251505',4800828,'2132','321',2242526.87,2243037.40,0.00,0.00,510.53,285231.20,0.00,0.00,0.00),('1','153','763','251505',4800829,'2133','321',1458549.08,1460326.73,0.00,0.00,1777.65,999505.20,0.00,0.00,0.00),('1','153','763','251505',4800830,'2998','321',85503.75,87029.25,0.00,0.00,1525.50,866484.00,0.00,0.00,0.00),('1','153','763','251505',4800831,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','251746',4805263,'2132','321',2243037.40,2243600.17,0.00,0.00,562.77,316784.64,0.00,0.00,0.00),('1','153','763','251746',4805264,'2133','321',1460326.73,1461597.81,0.00,0.00,1271.08,715841.44,0.00,0.00,0.00),('1','153','763','251746',4805265,'2998','321',87029.25,88521.04,0.00,0.00,1491.79,847336.72,0.00,0.00,0.00),('1','153','763','251746',4805266,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','251975',4809150,'2132','321',2243600.17,2243710.94,0.00,0.00,110.77,62917.36,0.00,0.00,0.00),('1','153','763','251975',4809151,'2133','321',1461597.81,1461953.98,0.00,0.00,356.17,201500.56,0.00,0.00,0.00),('1','153','763','251975',4809152,'2998','321',88521.04,88625.82,0.00,0.00,104.78,59515.04,0.00,0.00,0.00),('1','153','763','251975',4809153,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','252107',4811245,'2132','321',2243710.94,2244085.35,0.00,0.00,374.41,212664.88,0.00,0.00,0.00),('1','153','763','252107',4811246,'2133','321',1461953.98,1462982.60,0.00,0.00,1028.62,580536.40,0.00,0.00,0.00),('1','153','763','252107',4811247,'2998','321',88625.82,89511.27,0.00,0.00,885.45,502935.60,0.00,0.00,0.00),('1','153','763','252107',4811248,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','252220',4813386,'2132','321',2244085.35,2244549.95,0.00,0.00,464.60,256860.56,0.00,0.00,0.00),('1','153','763','252220',4813387,'2133','321',1462982.60,1464525.45,0.00,0.00,1542.85,871478.80,0.00,0.00,0.00),('1','153','763','252220',4813388,'2998','321',89511.27,90952.60,0.00,0.00,1441.33,818675.44,0.00,0.00,0.00),('1','153','763','252220',4813389,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','252485',4818057,'2132','321',2244549.95,2245040.14,0.00,0.00,490.19,278427.92,0.00,0.00,0.00),('1','153','763','252485',4818058,'2133','321',1464525.45,1465819.61,0.00,0.00,1294.16,727234.88,0.00,0.00,0.00),('1','153','763','252485',4818059,'2998','321',90952.60,92321.76,0.00,0.00,1369.16,777615.68,0.00,0.00,0.00),('1','153','763','252485',4818060,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','252693',4821775,'2132','321',2245040.14,2245360.79,0.00,0.00,320.65,182129.20,0.00,0.00,0.00),('1','153','763','252693',4821776,'2133','321',1465819.61,1467211.38,0.00,0.00,1391.77,786908.56,0.00,0.00,0.00),('1','153','763','252693',4821777,'2998','321',92321.76,93783.96,0.00,0.00,1462.20,825429.12,0.00,0.00,0.00),('1','153','763','252693',4821778,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','252953',4825996,'2132','321',2245360.79,2246164.84,0.00,0.00,804.05,449587.76,0.00,0.00,0.00),('1','153','763','252953',4825997,'2133','321',1467211.38,1468553.77,0.00,0.00,1342.39,760274.32,0.00,0.00,0.00),('1','153','763','252953',4825998,'2998','321',93783.96,94741.30,0.00,0.00,957.34,543769.12,0.00,0.00,0.00),('1','153','763','252953',4825999,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253196',4830169,'2132','321',2246164.84,2246560.12,0.00,0.00,395.28,224519.04,0.00,0.00,0.00),('1','153','763','253196',4830170,'2133','321',1468553.77,1469914.80,0.00,0.00,1361.03,771013.04,0.00,0.00,0.00),('1','153','763','253196',4830171,'2998','321',94741.30,96199.80,0.00,0.00,1458.50,821091.44,0.00,0.00,0.00),('1','153','763','253196',4830172,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253534',4835554,'2132','321',2246560.12,2246702.79,0.00,0.00,142.67,81036.56,0.00,0.00,0.00),('1','153','763','253534',4835555,'2133','321',1469914.80,1471669.94,0.00,0.00,1755.14,995155.52,0.00,0.00,0.00),('1','153','763','253534',4835556,'2998','321',96199.80,97283.29,0.00,0.00,1083.49,613730.08,0.00,0.00,0.00),('1','153','763','253534',4835557,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253707',4838754,'2132','321',2246702.79,2246850.92,0.00,0.00,148.13,84137.84,0.00,0.00,0.00),('1','153','763','253707',4838755,'2133','321',1471669.94,1472962.32,0.00,0.00,1292.38,733435.84,0.00,0.00,0.00),('1','153','763','253707',4838756,'2998','321',97283.29,98581.13,0.00,0.00,1297.84,730606.72,0.00,0.00,0.00),('1','153','763','253707',4838757,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253934',4842866,'2132','321',2246850.92,2246850.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253934',4842867,'2133','321',1472962.32,1472962.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253934',4842868,'2998','321',98581.13,98581.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253934',4842869,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','253949',4843016,'2132','321',2246850.92,2247053.47,0.00,0.00,202.55,114712.40,0.00,0.00,0.00),('1','153','763','253949',4843017,'2133','321',1472962.32,1474455.52,0.00,0.00,1493.20,848077.60,0.00,0.00,0.00),('1','153','763','253949',4843018,'2998','321',98581.13,99802.11,0.00,0.00,1220.98,689591.68,0.00,0.00,0.00),('1','153','763','253949',4843019,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','254202',4847441,'2132','321',2247053.47,2247351.72,0.00,0.00,298.25,163448.00,0.00,0.00,0.00),('1','153','763','254202',4847442,'2133','321',1474455.52,1475765.30,0.00,0.00,1309.78,742647.04,0.00,0.00,0.00),('1','153','763','254202',4847443,'2998','321',99802.11,101066.93,0.00,0.00,1264.82,718417.76,0.00,0.00,0.00),('1','153','763','254202',4847444,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','254442',4851698,'2132','321',2247351.72,2247694.11,0.00,0.00,342.39,190551.12,0.00,0.00,0.00),('1','153','763','254442',4851699,'2133','321',1475765.30,1477549.60,0.00,0.00,1784.30,1012090.40,0.00,0.00,0.00),('1','153','763','254442',4851700,'2998','321',101066.93,101974.87,0.00,0.00,907.94,512645.60,0.00,0.00,0.00),('1','153','763','254442',4851701,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','254679',4855930,'2132','321',2247694.11,2248108.80,0.00,0.00,414.69,232099.92,0.00,0.00,0.00),('1','153','763','254679',4855931,'2133','321',1477549.60,1478848.00,0.00,0.00,1298.40,735771.36,0.00,0.00,0.00),('1','153','763','254679',4855932,'2998','321',101974.87,103265.57,0.00,0.00,1290.70,728201.68,0.00,0.00,0.00),('1','153','763','254679',4855933,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','254938',4860208,'2132','321',2248108.80,2248249.09,0.00,0.00,140.29,76695.28,0.00,0.00,0.00),('1','153','763','254938',4860209,'2133','321',1478848.00,1480606.03,0.00,0.00,1758.03,998441.04,0.00,0.00,0.00),('1','153','763','254938',4860210,'2998','321',103265.57,104063.17,0.00,0.00,797.60,452659.28,0.00,0.00,0.00),('1','153','763','254938',4860211,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','255180',4864420,'2132','321',2248249.09,2248689.19,0.00,0.00,440.10,242272.80,0.00,0.00,0.00),('1','153','763','255180',4864421,'2133','321',1480606.03,1481488.58,0.00,0.00,882.55,501190.24,0.00,0.00,0.00),('1','153','763','255180',4864422,'2998','321',104063.17,105338.27,0.00,0.00,1275.10,721398.40,0.00,0.00,0.00),('1','153','763','255180',4864423,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','255575',4870781,'2132','321',2248689.19,2248906.53,0.00,0.00,217.34,121637.12,0.00,0.00,0.00),('1','153','763','255575',4870782,'2133','321',1481488.58,1482951.40,0.00,0.00,1462.82,830881.76,0.00,0.00,0.00),('1','153','763','255575',4870783,'2998','321',105338.27,106700.57,0.00,0.00,1362.30,770310.24,0.00,0.00,0.00),('1','153','763','255575',4870784,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','255697',4873144,'2132','321',2248906.53,2249242.72,0.00,0.00,336.19,187912.24,0.00,0.00,0.00),('1','153','763','255697',4873145,'2133','321',1482951.40,1484635.48,0.00,0.00,1684.08,956221.44,0.00,0.00,0.00),('1','153','763','255697',4873146,'2998','321',106700.57,107962.35,0.00,0.00,1261.78,711930.16,0.00,0.00,0.00),('1','153','763','255697',4873147,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','255944',4876990,'2132','321',2249242.72,2249447.77,0.00,0.00,205.05,111547.20,0.00,0.00,0.00),('1','153','763','255944',4876991,'2133','321',1484635.48,1485072.26,0.00,0.00,436.78,248091.04,0.00,0.00,0.00),('1','153','763','255944',4876992,'2998','321',107962.35,108351.92,0.00,0.00,389.57,221275.76,0.00,0.00,0.00),('1','153','763','255944',4876993,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256080',4879385,'2132','321',2249447.77,2249447.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256080',4879386,'2133','321',1485072.26,1485072.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256080',4879387,'2998','321',108351.92,108351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256080',4879388,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256083',4879418,'2132','321',2249447.77,2249990.45,0.00,0.00,542.68,295217.92,0.00,0.00,0.00),('1','153','763','256083',4879419,'2133','321',1485072.26,1485806.26,0.00,0.00,734.00,416912.00,0.00,0.00,0.00),('1','153','763','256083',4879420,'2998','321',108351.92,108806.53,0.00,0.00,454.61,258218.48,0.00,0.00,0.00),('1','153','763','256083',4879421,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256197',4881130,'2132','321',2249990.45,2250473.93,0.00,0.00,483.48,264954.48,0.00,0.00,0.00),('1','153','763','256197',4881131,'2133','321',1485806.26,1487023.24,0.00,0.00,1216.98,690782.16,0.00,0.00,0.00),('1','153','763','256197',4881132,'2998','321',108806.53,109900.41,0.00,0.00,1093.88,619762.88,0.00,0.00,0.00),('1','153','763','256197',4881133,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256591',4887790,'2132','321',2250473.93,2250636.24,0.00,0.00,162.31,92192.08,0.00,0.00,0.00),('1','153','763','256591',4887791,'2133','321',1487023.24,1488265.27,0.00,0.00,1242.03,705402.96,0.00,0.00,0.00),('1','153','763','256591',4887792,'2998','321',109900.41,110950.42,0.00,0.00,1050.01,592510.24,0.00,0.00,0.00),('1','153','763','256591',4887793,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','256704',4889772,'2132','321',2250636.24,2250816.32,0.00,0.00,180.08,98392.64,0.00,0.00,0.00),('1','153','763','256704',4889773,'2133','321',1488265.27,1489365.69,0.00,0.00,1100.42,624562.88,0.00,0.00,0.00),('1','153','763','256704',4889774,'2998','321',110950.42,111959.68,0.00,0.00,1009.26,573166.56,0.00,0.00,0.00),('1','153','763','256704',4889775,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257007',4894709,'2132','321',2250816.32,2251062.95,0.00,0.00,246.63,136591.44,0.00,0.00,0.00),('1','153','763','257007',4894710,'2133','321',1489365.69,1490797.60,0.00,0.00,1431.91,813225.76,0.00,0.00,0.00),('1','153','763','257007',4894711,'2998','321',111959.68,112896.93,0.00,0.00,937.25,529933.28,0.00,0.00,0.00),('1','153','763','257007',4894712,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257217',4898921,'2132','321',2251062.95,2251587.26,0.00,0.00,524.31,296920.08,0.00,0.00,0.00),('1','153','763','257217',4898922,'2133','321',1490797.60,1492434.28,0.00,0.00,1636.68,929246.88,0.00,0.00,0.00),('1','153','763','257217',4898923,'2998','321',112896.93,113880.86,0.00,0.00,983.93,547501.28,0.00,0.00,0.00),('1','153','763','257217',4898924,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257475',4903412,'2132','321',2251587.26,2251789.96,0.00,0.00,202.70,113465.60,0.00,0.00,0.00),('1','153','763','257475',4903413,'2133','321',1492434.28,1494026.40,0.00,0.00,1592.12,904226.72,0.00,0.00,0.00),('1','153','763','257475',4903414,'2998','321',113880.86,115267.67,0.00,0.00,1386.81,784511.28,0.00,0.00,0.00),('1','153','763','257475',4903415,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257476',4903416,'2132','321',2251789.96,2252577.04,0.00,0.00,787.08,437644.08,0.00,0.00,0.00),('1','153','763','257476',4903417,'2133','321',1494026.40,1495681.47,0.00,0.00,1655.07,939935.76,0.00,0.00,0.00),('1','153','763','257476',4903418,'2998','321',115267.67,115718.77,0.00,0.00,451.10,256224.80,0.00,0.00,0.00),('1','153','763','257476',4903419,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257477',4903420,'2132','321',2252577.04,2253583.34,0.00,0.00,1006.30,566618.56,0.00,0.00,0.00),('1','153','763','257477',4903421,'2133','321',1495681.47,1497158.34,0.00,0.00,1476.87,838694.16,0.00,0.00,0.00),('1','153','763','257477',4903422,'2998','321',115718.77,115736.84,0.00,0.00,18.07,10263.76,0.00,0.00,0.00),('1','153','763','257477',4903423,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257478',4903424,'2132','321',2253583.34,2254080.85,0.00,0.00,497.51,281369.36,0.00,0.00,0.00),('1','153','763','257478',4903425,'2133','321',1497158.34,1498027.40,0.00,0.00,869.06,493626.08,0.00,0.00,0.00),('1','153','763','257478',4903426,'2998','321',115736.84,115742.30,0.00,0.00,5.46,3101.28,0.00,0.00,0.00),('1','153','763','257478',4903427,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257479',4903428,'2132','321',2254080.85,2254509.33,0.00,0.00,428.48,243376.64,0.00,0.00,0.00),('1','153','763','257479',4903429,'2133','321',1498027.40,1498511.74,0.00,0.00,484.34,271929.68,0.00,0.00,0.00),('1','153','763','257479',4903430,'2998','321',115742.30,115946.91,0.00,0.00,204.61,116218.48,0.00,0.00,0.00),('1','153','763','257479',4903431,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257480',4903432,'2132','321',2254509.33,2254698.96,0.00,0.00,189.63,104899.44,0.00,0.00,0.00),('1','153','763','257480',4903433,'2133','321',1498511.74,1500079.80,0.00,0.00,1568.06,890658.08,0.00,0.00,0.00),('1','153','763','257480',4903434,'2998','321',115946.91,117157.96,0.00,0.00,1211.05,686135.68,0.00,0.00,0.00),('1','153','763','257480',4903435,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257481',4903436,'2132','321',2254698.96,2254962.13,0.00,0.00,263.17,143175.76,0.00,0.00,0.00),('1','153','763','257481',4903437,'2133','321',1500079.80,1501662.21,0.00,0.00,1582.41,898749.60,0.00,0.00,0.00),('1','153','763','257481',4903438,'2998','321',117157.96,118287.94,0.00,0.00,1129.98,641828.64,0.00,0.00,0.00),('1','153','763','257481',4903439,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257482',4903440,'2132','321',2254962.13,2255070.63,0.00,0.00,108.50,59456.00,0.00,0.00,0.00),('1','153','763','257482',4903441,'2133','321',1501662.21,1503102.96,0.00,0.00,1440.75,818346.00,0.00,0.00,0.00),('1','153','763','257482',4903442,'2998','321',118287.94,119654.86,0.00,0.00,1366.92,775978.56,0.00,0.00,0.00),('1','153','763','257482',4903443,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257483',4903444,'2132','321',2255070.63,2255385.48,0.00,0.00,314.85,171950.40,0.00,0.00,0.00),('1','153','763','257483',4903445,'2133','321',1503102.96,1504551.31,0.00,0.00,1448.35,822278.80,0.00,0.00,0.00),('1','153','763','257483',4903446,'2998','321',119654.86,120897.57,0.00,0.00,1242.71,705571.28,0.00,0.00,0.00),('1','153','763','257483',4903447,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257484',4903448,'2132','321',2255385.48,2255497.22,0.00,0.00,111.74,60786.56,0.00,0.00,0.00),('1','153','763','257484',4903449,'2133','321',1504551.31,1505842.29,0.00,0.00,1290.98,733276.64,0.00,0.00,0.00),('1','153','763','257484',4903450,'2998','321',120897.57,122141.59,0.00,0.00,1244.02,706603.36,0.00,0.00,0.00),('1','153','763','257484',4903451,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257485',4903452,'2132','321',2255497.22,2255889.48,0.00,0.00,392.26,215321.44,0.00,0.00,0.00),('1','153','763','257485',4903453,'2133','321',1505842.29,1507128.65,0.00,0.00,1286.36,728720.48,0.00,0.00,0.00),('1','153','763','257485',4903454,'2998','321',122141.59,123350.44,0.00,0.00,1208.85,686626.80,0.00,0.00,0.00),('1','153','763','257485',4903455,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257486',4903456,'2132','321',2255889.48,2256031.36,0.00,0.00,141.88,77182.72,0.00,0.00,0.00),('1','153','763','257486',4903457,'2133','321',1507128.65,1508277.79,0.00,0.00,1149.14,652711.52,0.00,0.00,0.00),('1','153','763','257486',4903458,'2998','321',123350.44,124632.71,0.00,0.00,1282.27,728329.36,0.00,0.00,0.00),('1','153','763','257486',4903459,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257487',4903460,'2132','321',2256031.36,2256422.03,0.00,0.00,390.67,212524.48,0.00,0.00,0.00),('1','153','763','257487',4903461,'2133','321',1508277.79,1509692.93,0.00,0.00,1415.14,803799.52,0.00,0.00,0.00),('1','153','763','257487',4903462,'2998','321',124632.71,125650.01,0.00,0.00,1017.30,577826.40,0.00,0.00,0.00),('1','153','763','257487',4903463,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257488',4903464,'2132','321',2256422.03,2256503.13,0.00,0.00,81.10,44118.40,0.00,0.00,0.00),('1','153','763','257488',4903465,'2133','321',1509692.93,1510075.97,0.00,0.00,383.04,217566.72,0.00,0.00,0.00),('1','153','763','257488',4903466,'2998','321',125650.01,126072.49,0.00,0.00,422.48,239968.64,0.00,0.00,0.00),('1','153','763','257488',4903467,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257489',4903468,'2132','321',2256503.13,2256503.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257489',4903469,'2133','321',1510075.97,1510075.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257489',4903470,'2998','321',126072.49,126072.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257489',4903471,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257490',4903472,'2132','321',2256503.13,2256626.23,0.00,0.00,123.10,67126.96,0.00,0.00,0.00),('1','153','763','257490',4903473,'2133','321',1510075.97,1510530.48,0.00,0.00,454.51,258161.68,0.00,0.00,0.00),('1','153','763','257490',4903474,'2998','321',126072.49,126656.71,0.00,0.00,584.22,331676.40,0.00,0.00,0.00),('1','153','763','257490',4903475,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257491',4903476,'2132','321',2256626.23,2256985.65,0.00,0.00,359.42,196808.72,0.00,0.00,0.00),('1','153','763','257491',4903477,'2133','321',1510530.48,1511727.20,0.00,0.00,1196.72,678632.72,0.00,0.00,0.00),('1','153','763','257491',4903478,'2998','321',126656.71,127704.93,0.00,0.00,1048.22,595208.96,0.00,0.00,0.00),('1','153','763','257491',4903479,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257492',4903480,'2132','321',2256985.65,2257021.43,0.00,0.00,35.78,19464.32,0.00,0.00,0.00),('1','153','763','257492',4903481,'2133','321',1511727.20,1513071.88,0.00,0.00,1344.68,763778.24,0.00,0.00,0.00),('1','153','763','257492',4903482,'2998','321',127704.93,128367.22,0.00,0.00,662.29,376180.72,0.00,0.00,0.00),('1','153','763','257492',4903483,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257493',4903484,'2132','321',2257021.43,2257188.32,0.00,0.00,166.89,91136.16,0.00,0.00,0.00),('1','153','763','257493',4903485,'2133','321',1513071.88,1514157.86,0.00,0.00,1085.98,616488.64,0.00,0.00,0.00),('1','153','763','257493',4903486,'2998','321',128367.22,129354.47,0.00,0.00,987.25,560758.00,0.00,0.00,0.00),('1','153','763','257493',4903487,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257494',4903488,'2132','321',2257188.32,2257256.12,0.00,0.00,67.80,36883.20,0.00,0.00,0.00),('1','153','763','257494',4903489,'2133','321',1514157.86,1515273.13,0.00,0.00,1115.27,633473.36,0.00,0.00,0.00),('1','153','763','257494',4903490,'2998','321',129354.47,130013.94,0.00,0.00,659.47,374578.96,0.00,0.00,0.00),('1','153','763','257494',4903491,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257495',4903492,'2132','321',2257256.12,2258052.11,0.00,0.00,795.99,433497.12,0.00,0.00,0.00),('1','153','763','257495',4903493,'2133','321',1515273.13,1516221.15,0.00,0.00,948.02,537995.36,0.00,0.00,0.00),('1','153','763','257495',4903494,'2998','321',130013.94,131013.57,0.00,0.00,999.63,567789.84,0.00,0.00,0.00),('1','153','763','257495',4903495,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257496',4903496,'2132','321',2258052.11,2258352.13,0.00,0.00,300.02,163210.88,0.00,0.00,0.00),('1','153','763','257496',4903497,'2133','321',1516221.15,1517341.90,0.00,0.00,1120.75,636618.00,0.00,0.00,0.00),('1','153','763','257496',4903498,'2998','321',131013.57,131523.15,0.00,0.00,509.58,289441.44,0.00,0.00,0.00),('1','153','763','257496',4903499,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257497',4903500,'2132','321',2258352.13,2258630.81,0.00,0.00,278.68,151601.92,0.00,0.00,0.00),('1','153','763','257497',4903501,'2133','321',1517341.90,1517984.65,0.00,0.00,642.75,365082.00,0.00,0.00,0.00),('1','153','763','257497',4903502,'2998','321',131523.15,132267.52,0.00,0.00,744.37,422802.16,0.00,0.00,0.00),('1','153','763','257497',4903503,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257498',4903504,'2132','321',2258630.81,2258809.31,0.00,0.00,178.50,97104.00,0.00,0.00,0.00),('1','153','763','257498',4903505,'2133','321',1517984.65,1519057.31,0.00,0.00,1072.66,609270.88,0.00,0.00,0.00),('1','153','763','257498',4903506,'2998','321',132267.52,133215.34,0.00,0.00,947.82,538361.76,0.00,0.00,0.00),('1','153','763','257498',4903507,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257499',4903508,'2132','321',2258809.31,2258919.01,0.00,0.00,109.70,59676.80,0.00,0.00,0.00),('1','153','763','257499',4903509,'2133','321',1519057.31,1519990.92,0.00,0.00,933.61,530290.48,0.00,0.00,0.00),('1','153','763','257499',4903510,'2998','321',133215.34,134288.20,0.00,0.00,1072.86,609384.48,0.00,0.00,0.00),('1','153','763','257499',4903511,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257500',4903512,'2132','321',2258919.01,2258989.39,0.00,0.00,70.38,38286.72,0.00,0.00,0.00),('1','153','763','257500',4903513,'2133','321',1519990.92,1520959.42,0.00,0.00,968.50,550108.00,0.00,0.00,0.00),('1','153','763','257500',4903514,'2998','321',134288.20,134901.16,0.00,0.00,612.96,348161.28,0.00,0.00,0.00),('1','153','763','257500',4903515,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257501',4903516,'2132','321',2258989.39,2259149.29,0.00,0.00,159.90,87057.60,0.00,0.00,0.00),('1','153','763','257501',4903517,'2133','321',1520959.42,1522041.48,0.00,0.00,1082.06,614610.08,0.00,0.00,0.00),('1','153','763','257501',4903518,'2998','321',134901.16,135789.53,0.00,0.00,888.37,504594.16,0.00,0.00,0.00),('1','153','763','257501',4903519,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257502',4903520,'2132','321',2259149.29,2259149.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257502',4903521,'2133','321',1522041.48,1522306.46,0.00,0.00,264.98,150508.64,0.00,0.00,0.00),('1','153','763','257502',4903522,'2998','321',135789.53,135803.62,0.00,0.00,14.09,8003.12,0.00,0.00,0.00),('1','153','763','257502',4903523,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257503',4903524,'2132','321',2259149.29,2259149.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257503',4903525,'2133','321',1522306.46,1522306.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257503',4903526,'2998','321',135803.62,135803.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257503',4903527,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257504',4903528,'2132','321',2259149.29,2259190.29,0.00,0.00,41.00,22304.00,0.00,0.00,0.00),('1','153','763','257504',4903529,'2133','321',1522306.46,1522786.47,0.00,0.00,480.01,272645.68,0.00,0.00,0.00),('1','153','763','257504',4903530,'2998','321',135803.62,136545.46,0.00,0.00,741.84,421365.12,0.00,0.00,0.00),('1','153','763','257504',4903531,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257505',4903532,'2132','321',2259190.29,2259270.63,0.00,0.00,80.34,43981.20,0.00,0.00,0.00),('1','153','763','257505',4903533,'2133','321',1522786.47,1523711.34,0.00,0.00,924.87,525050.16,0.00,0.00,0.00),('1','153','763','257505',4903534,'2998','321',136545.46,137477.44,0.00,0.00,931.98,529364.64,0.00,0.00,0.00),('1','153','763','257505',4903535,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257506',4903536,'2132','321',2259270.63,2259334.63,0.00,0.00,64.00,34816.00,0.00,0.00,0.00),('1','153','763','257506',4903537,'2133','321',1523711.34,1524648.31,0.00,0.00,936.97,532198.96,0.00,0.00,0.00),('1','153','763','257506',4903538,'2998','321',137477.44,138231.25,0.00,0.00,753.81,428164.08,0.00,0.00,0.00),('1','153','763','257506',4903539,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257507',4903540,'2132','321',2259334.63,2259528.66,0.00,0.00,194.03,105845.84,0.00,0.00,0.00),('1','153','763','257507',4903541,'2133','321',1524648.31,1525405.33,0.00,0.00,757.02,429987.36,0.00,0.00,0.00),('1','153','763','257507',4903542,'2998','321',138231.25,139083.82,0.00,0.00,852.57,483966.48,0.00,0.00,0.00),('1','153','763','257507',4903543,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257508',4903544,'2132','321',2259528.66,2259548.16,0.00,0.00,19.50,10608.00,0.00,0.00,0.00),('1','153','763','257508',4903545,'2133','321',1525405.33,1525900.39,0.00,0.00,495.06,281194.08,0.00,0.00,0.00),('1','153','763','257508',4903546,'2998','321',139083.82,140251.54,0.00,0.00,1167.72,663264.96,0.00,0.00,0.00),('1','153','763','257508',4903547,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257509',4903548,'2132','321',2259548.16,2259658.33,0.00,0.00,110.17,59932.48,0.00,0.00,0.00),('1','153','763','257509',4903549,'2133','321',1525900.39,1526855.43,0.00,0.00,955.04,542462.72,0.00,0.00,0.00),('1','153','763','257509',4903550,'2998','321',140251.54,141159.31,0.00,0.00,907.77,515613.36,0.00,0.00,0.00),('1','153','763','257509',4903551,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257510',4903552,'2132','321',2259658.33,2259739.76,0.00,0.00,81.43,44297.92,0.00,0.00,0.00),('1','153','763','257510',4903553,'2133','321',1526855.43,1527855.02,0.00,0.00,999.59,567767.12,0.00,0.00,0.00),('1','153','763','257510',4903554,'2998','321',141159.31,142372.90,0.00,0.00,1213.59,689319.12,0.00,0.00,0.00),('1','153','763','257510',4903555,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257511',4903556,'2132','321',2259739.76,2259832.16,0.00,0.00,92.40,50265.60,0.00,0.00,0.00),('1','153','763','257511',4903557,'2133','321',1527855.02,1528478.77,0.00,0.00,623.75,354290.00,0.00,0.00,0.00),('1','153','763','257511',4903558,'2998','321',142372.90,143097.51,0.00,0.00,724.61,411578.48,0.00,0.00,0.00),('1','153','763','257511',4903559,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257512',4903560,'2132','321',2259832.16,2259853.16,0.00,0.00,21.00,11424.00,0.00,0.00,0.00),('1','153','763','257512',4903561,'2133','321',1528478.77,1529215.00,0.00,0.00,736.23,418178.64,0.00,0.00,0.00),('1','153','763','257512',4903562,'2998','321',143097.51,144197.00,0.00,0.00,1099.49,624510.32,0.00,0.00,0.00),('1','153','763','257512',4903563,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257513',4903564,'2132','321',2259853.16,2259930.73,0.00,0.00,77.57,42342.08,0.00,0.00,0.00),('1','153','763','257513',4903565,'2133','321',1529215.00,1530468.18,0.00,0.00,1253.18,711662.24,0.00,0.00,0.00),('1','153','763','257513',4903566,'2998','321',144197.00,145504.85,0.00,0.00,1307.85,742858.80,0.00,0.00,0.00),('1','153','763','257513',4903567,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257514',4903568,'2132','321',2259930.73,2260072.84,0.00,0.00,142.11,77307.84,0.00,0.00,0.00),('1','153','763','257514',4903569,'2133','321',1530468.18,1531614.55,0.00,0.00,1146.37,651138.16,0.00,0.00,0.00),('1','153','763','257514',4903570,'2998','321',145504.85,146707.00,0.00,0.00,1202.15,682821.20,0.00,0.00,0.00),('1','153','763','257514',4903571,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257515',4903572,'2132','321',2260072.84,2260145.82,0.00,0.00,72.98,39701.12,0.00,0.00,0.00),('1','153','763','257515',4903573,'2133','321',1531614.55,1532666.21,0.00,0.00,1051.66,597342.88,0.00,0.00,0.00),('1','153','763','257515',4903574,'2998','321',146707.00,148055.59,0.00,0.00,1348.59,765999.12,0.00,0.00,0.00),('1','153','763','257515',4903575,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257516',4903576,'2132','321',2260145.82,2260145.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257516',4903577,'2133','321',1532666.21,1532824.78,0.00,0.00,158.57,90067.76,0.00,0.00,0.00),('1','153','763','257516',4903578,'2998','321',148055.59,148088.75,0.00,0.00,33.16,18834.88,0.00,0.00,0.00),('1','153','763','257516',4903579,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257517',4903580,'2132','321',2260145.82,2260145.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257517',4903581,'2133','321',1532824.78,1532824.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257517',4903582,'2998','321',148088.75,148088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257517',4903583,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257518',4903584,'2132','321',2260145.82,2260399.86,0.00,0.00,254.04,138197.76,0.00,0.00,0.00),('1','153','763','257518',4903585,'2133','321',1532824.78,1533699.18,0.00,0.00,874.40,496659.20,0.00,0.00,0.00),('1','153','763','257518',4903586,'2998','321',148088.75,149102.77,0.00,0.00,1014.02,575963.36,0.00,0.00,0.00),('1','153','763','257518',4903587,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257519',4903588,'2132','321',2260399.86,2260575.76,0.00,0.00,175.90,95689.60,0.00,0.00,0.00),('1','153','763','257519',4903589,'2133','321',1533699.18,1534450.01,0.00,0.00,750.83,426471.44,0.00,0.00,0.00),('1','153','763','257519',4903590,'2998','321',149102.77,150227.24,0.00,0.00,1124.47,638698.96,0.00,0.00,0.00),('1','153','763','257519',4903591,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257520',4903592,'2132','321',2260575.76,2260769.39,0.00,0.00,193.63,120050.60,0.00,0.00,0.00),('1','153','763','257520',4903593,'2133','321',1534450.01,1535501.28,0.00,0.00,1051.27,672812.80,0.00,0.00,0.00),('1','153','763','257520',4903594,'2998','321',150227.24,150853.30,0.00,0.00,626.06,400678.40,0.00,0.00,0.00),('1','153','763','257520',4903595,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257521',4903596,'2132','321',2260769.39,2260781.39,0.00,0.00,12.00,7440.00,0.00,0.00,0.00),('1','153','763','257521',4903597,'2133','321',1535501.28,1536282.12,0.00,0.00,780.84,499737.60,0.00,0.00,0.00),('1','153','763','257521',4903598,'2998','321',150853.30,151706.95,0.00,0.00,853.65,546336.00,0.00,0.00,0.00),('1','153','763','257521',4903599,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257522',4903600,'2132','321',2260781.39,2261304.89,0.00,0.00,523.50,324570.00,0.00,0.00,0.00),('1','153','763','257522',4903601,'2133','321',1536282.12,1537277.54,0.00,0.00,995.42,637068.80,0.00,0.00,0.00),('1','153','763','257522',4903602,'2998','321',151706.95,152374.99,0.00,0.00,668.04,427545.60,0.00,0.00,0.00),('1','153','763','257522',4903603,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257523',4903604,'2132','321',2261304.89,2261579.36,0.00,0.00,274.47,170171.40,0.00,0.00,0.00),('1','153','763','257523',4903605,'2133','321',1537277.54,1537981.17,0.00,0.00,703.63,450323.20,0.00,0.00,0.00),('1','153','763','257523',4903606,'2998','321',152374.99,153313.32,0.00,0.00,938.33,600531.20,0.00,0.00,0.00),('1','153','763','257523',4903607,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257524',4903608,'2132','321',2261579.36,2261753.86,0.00,0.00,174.50,108190.00,0.00,0.00,0.00),('1','153','763','257524',4903609,'2133','321',1537981.17,1539013.98,0.00,0.00,1032.81,660998.40,0.00,0.00,0.00),('1','153','763','257524',4903610,'2998','321',153313.32,154227.99,0.00,0.00,914.67,585388.80,0.00,0.00,0.00),('1','153','763','257524',4903611,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257525',4903612,'2132','321',2261753.86,2261831.35,0.00,0.00,77.49,48043.80,0.00,0.00,0.00),('1','153','763','257525',4903613,'2133','321',1539013.98,1539723.31,0.00,0.00,709.33,453971.20,0.00,0.00,0.00),('1','153','763','257525',4903614,'2998','321',154227.99,155304.03,0.00,0.00,1076.04,688665.60,0.00,0.00,0.00),('1','153','763','257525',4903615,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257526',4903616,'2132','321',2261831.35,2261857.05,0.00,0.00,25.70,16448.00,0.00,0.00,0.00),('1','153','763','257526',4903617,'2133','321',1539723.31,1540584.83,0.00,0.00,861.52,585833.60,0.00,0.00,0.00),('1','153','763','257526',4903618,'2998','321',155304.03,155734.23,0.00,0.00,430.20,292536.00,0.00,0.00,0.00),('1','153','763','257526',4903619,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257527',4903620,'2132','321',2261857.05,2262446.30,0.00,0.00,589.25,377620.00,0.00,0.00,0.00),('1','153','763','257527',4903621,'2133','321',1540584.83,1541034.59,0.00,0.00,449.76,305836.80,0.00,0.00,0.00),('1','153','763','257527',4903622,'2998','321',155734.23,156128.55,0.00,0.00,394.32,267637.60,0.00,0.00,0.00),('1','153','763','257527',4903623,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257528',4903624,'2132','321',2262446.30,2262623.75,0.00,0.00,177.45,113568.00,0.00,0.00,0.00),('1','153','763','257528',4903625,'2133','321',1541034.59,1542084.31,0.00,0.00,1049.72,713809.60,0.00,0.00,0.00),('1','153','763','257528',4903626,'2998','321',156128.55,156789.74,0.00,0.00,661.19,449609.20,0.00,0.00,0.00),('1','153','763','257528',4903627,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257529',4903628,'2132','321',2262623.75,2262652.62,0.00,0.00,28.87,17783.92,0.00,0.00,0.00),('1','153','763','257529',4903629,'2133','321',1542084.31,1542791.07,0.00,0.00,706.76,452326.40,0.00,0.00,0.00),('1','153','763','257529',4903630,'2998','321',156789.74,157773.52,0.00,0.00,983.78,629619.20,0.00,0.00,0.00),('1','153','763','257529',4903631,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257530',4903632,'2132','321',2262652.62,2262762.36,0.00,0.00,109.74,67599.84,0.00,0.00,0.00),('1','153','763','257530',4903633,'2133','321',1542791.07,1543727.66,0.00,0.00,936.59,599417.60,0.00,0.00,0.00),('1','153','763','257530',4903634,'2998','321',157773.52,158509.02,0.00,0.00,735.50,470720.00,0.00,0.00,0.00),('1','153','763','257530',4903635,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257531',4903636,'2132','321',2262762.36,2262763.87,0.00,0.00,1.51,930.16,0.00,0.00,0.00),('1','153','763','257531',4903637,'2133','321',1543727.66,1544181.46,0.00,0.00,453.80,290432.00,0.00,0.00,0.00),('1','153','763','257531',4903638,'2998','321',158509.02,158811.38,0.00,0.00,302.36,193510.40,0.00,0.00,0.00),('1','153','763','257531',4903639,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257532',4903640,'2132','321',2262763.87,2262763.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257532',4903641,'2133','321',1544181.46,1544181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257532',4903642,'2998','321',158811.38,158811.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257532',4903643,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257533',4903644,'2132','321',2262763.87,2262833.87,0.00,0.00,70.00,43120.00,0.00,0.00,0.00),('1','153','763','257533',4903645,'2133','321',1544181.46,1544513.58,0.00,0.00,332.12,212556.80,0.00,0.00,0.00),('1','153','763','257533',4903646,'2998','321',158811.38,159435.42,0.00,0.00,624.04,399385.60,0.00,0.00,0.00),('1','153','763','257533',4903647,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257534',4903648,'2132','321',2262833.87,2262996.91,0.00,0.00,163.04,100432.64,0.00,0.00,0.00),('1','153','763','257534',4903649,'2133','321',1544513.58,1545205.39,0.00,0.00,691.81,442758.40,0.00,0.00,0.00),('1','153','763','257534',4903650,'2998','321',159435.42,160239.27,0.00,0.00,803.85,514464.00,0.00,0.00,0.00),('1','153','763','257534',4903651,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257535',4903652,'2132','321',2262996.91,2263082.84,0.00,0.00,85.93,52932.88,0.00,0.00,0.00),('1','153','763','257535',4903653,'2133','321',1545205.39,1545926.14,0.00,0.00,720.75,461280.00,0.00,0.00,0.00),('1','153','763','257535',4903654,'2998','321',160239.27,161148.61,0.00,0.00,909.34,581977.60,0.00,0.00,0.00),('1','153','763','257535',4903655,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257536',4903656,'2132','321',2263082.84,2263234.84,0.00,0.00,152.00,93632.00,0.00,0.00,0.00),('1','153','763','257536',4903657,'2133','321',1545926.14,1546426.31,0.00,0.00,500.17,320108.80,0.00,0.00,0.00),('1','153','763','257536',4903658,'2998','321',161148.61,161737.83,0.00,0.00,589.22,377100.80,0.00,0.00,0.00),('1','153','763','257536',4903659,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257537',4903660,'2132','321',2263234.84,2263386.83,0.00,0.00,151.99,93625.84,0.00,0.00,0.00),('1','153','763','257537',4903661,'2133','321',1546426.31,1547326.76,0.00,0.00,900.45,576288.00,0.00,0.00,0.00),('1','153','763','257537',4903662,'2998','321',161737.83,162484.27,0.00,0.00,746.44,477721.60,0.00,0.00,0.00),('1','153','763','257537',4903663,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257538',4903664,'2132','321',2263386.83,2263748.90,0.00,0.00,362.07,223035.12,0.00,0.00,0.00),('1','153','763','257538',4903665,'2133','321',1547326.76,1547931.54,0.00,0.00,604.78,387059.20,0.00,0.00,0.00),('1','153','763','257538',4903666,'2998','321',162484.27,163405.67,0.00,0.00,921.40,589696.00,0.00,0.00,0.00),('1','153','763','257538',4903667,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257539',4903668,'2132','321',2263748.90,2263797.59,0.00,0.00,48.69,29993.04,0.00,0.00,0.00),('1','153','763','257539',4903669,'2133','321',1547931.54,1548556.60,0.00,0.00,625.06,400038.40,0.00,0.00,0.00),('1','153','763','257539',4903670,'2998','321',163405.67,163887.65,0.00,0.00,481.98,308467.20,0.00,0.00,0.00),('1','153','763','257539',4903671,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257540',4903672,'2132','321',2263797.59,2264030.16,0.00,0.00,232.57,149309.94,0.00,0.00,0.00),('1','153','763','257540',4903673,'2133','321',1548556.60,1549632.06,0.00,0.00,1075.46,731312.80,0.00,0.00,0.00),('1','153','763','257540',4903674,'2998','321',163887.65,164771.84,0.00,0.00,884.19,601249.20,0.00,0.00,0.00),('1','153','763','257540',4903675,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257541',4903676,'2132','321',2264030.16,2264175.75,0.00,0.00,145.59,93468.78,0.00,0.00,0.00),('1','153','763','257541',4903677,'2133','321',1549632.06,1550511.76,0.00,0.00,879.70,598196.00,0.00,0.00,0.00),('1','153','763','257541',4903678,'2998','321',164771.84,165751.76,0.00,0.00,979.92,666345.60,0.00,0.00,0.00),('1','153','763','257541',4903679,'2999','321',15540.13,15540.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257542',4903680,'2132','321',2264175.75,2264391.80,0.00,0.00,216.05,138704.10,0.00,0.00,0.00),('1','153','763','257542',4903681,'2133','321',1550511.76,1551011.56,0.00,0.00,499.80,339864.00,0.00,0.00,0.00),('1','153','763','257542',4903682,'2998','321',165751.76,166840.32,0.00,0.00,1088.56,740220.80,0.00,0.00,0.00),('1','153','763','257542',4903683,'2999','321',15540.13,15552.63,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','153','763','257543',4903684,'2132','321',2264391.80,2264492.80,0.00,0.00,101.00,64842.00,0.00,0.00,0.00),('1','153','763','257543',4903685,'2133','321',1551011.56,1552258.94,0.00,0.00,1247.38,848218.40,0.00,0.00,0.00),('1','153','763','257543',4903686,'2998','321',166840.32,167119.19,0.00,0.00,278.87,189631.60,0.00,0.00,0.00),('1','153','763','257543',4903687,'2999','321',15552.63,15552.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257544',4903688,'2132','321',2264492.80,2264634.50,0.00,0.00,141.70,88654.00,0.00,0.00,0.00),('1','153','763','257544',4903689,'2133','321',1552258.94,1552946.70,0.00,0.00,687.76,440166.40,0.00,0.00,0.00),('1','153','763','257544',4903690,'2998','321',167119.19,167806.53,0.00,0.00,687.34,439897.60,0.00,0.00,0.00),('1','153','763','257544',4903691,'2999','321',15552.63,15552.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257545',4903692,'2132','321',2264634.50,2264637.51,0.00,0.00,3.01,1866.20,0.00,0.00,0.00),('1','153','763','257545',4903693,'2133','321',1552946.70,1552959.20,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','153','763','257545',4903694,'2998','321',167806.53,168799.70,0.00,0.00,993.17,635628.80,0.00,0.00,0.00),('1','153','763','257545',4903695,'2999','321',15552.63,15552.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257546',4903696,'2132','321',2264637.51,2264680.40,0.00,0.00,42.89,26801.80,0.00,0.00,0.00),('1','153','763','257546',4903697,'2133','321',1552959.20,1554035.74,0.00,0.00,1076.54,688985.60,0.00,0.00,0.00),('1','153','763','257546',4903698,'2998','321',168799.70,170386.10,0.00,0.00,1586.40,1015296.00,0.00,0.00,0.00),('1','153','763','257546',4903699,'2999','321',15552.63,15552.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257547',4903700,'2132','321',2264680.40,2266246.41,0.00,0.00,1566.01,976773.60,0.00,0.00,0.00),('1','153','763','257547',4903701,'2133','321',1554035.74,1556278.80,0.00,0.00,2243.06,1435558.40,0.00,0.00,0.00),('1','153','763','257547',4903702,'2998','321',170386.10,172195.92,0.00,0.00,1809.82,1158284.80,0.00,0.00,0.00),('1','153','763','257547',4903703,'2999','321',15552.63,15552.79,0.00,0.00,0.16,102.40,0.00,0.00,0.00),('1','153','763','257548',4903704,'2132','321',2266246.41,2267523.35,0.00,0.00,1276.94,791749.60,0.00,0.00,0.00),('1','153','763','257548',4903705,'2133','321',1556278.80,1557677.29,0.00,0.00,1398.49,895033.60,0.00,0.00,0.00),('1','153','763','257548',4903706,'2998','321',172195.92,173666.02,0.00,0.00,1470.10,940864.00,0.00,0.00,0.00),('1','153','763','257548',4903707,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257549',4903708,'2132','321',2267523.35,2268134.41,0.00,0.00,611.06,378857.20,0.00,0.00,0.00),('1','153','763','257549',4903709,'2133','321',1557677.29,1558250.88,0.00,0.00,573.59,367097.60,0.00,0.00,0.00),('1','153','763','257549',4903710,'2998','321',173666.02,174731.62,0.00,0.00,1065.60,681984.00,0.00,0.00,0.00),('1','153','763','257549',4903711,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257550',4903712,'2132','321',2268134.41,2268455.02,0.00,0.00,320.61,198778.20,0.00,0.00,0.00),('1','153','763','257550',4903713,'2133','321',1558250.88,1558874.52,0.00,0.00,623.64,399129.60,0.00,0.00,0.00),('1','153','763','257550',4903714,'2998','321',174731.62,175444.37,0.00,0.00,712.75,456160.00,0.00,0.00,0.00),('1','153','763','257550',4903715,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257551',4903716,'2132','321',2268455.02,2268689.71,0.00,0.00,234.69,145507.80,0.00,0.00,0.00),('1','153','763','257551',4903717,'2133','321',1558874.52,1558955.09,0.00,0.00,80.57,51564.80,0.00,0.00,0.00),('1','153','763','257551',4903718,'2998','321',175444.37,175588.49,0.00,0.00,144.12,92236.80,0.00,0.00,0.00),('1','153','763','257551',4903719,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257552',4903720,'2132','321',2268689.71,2269303.95,0.00,0.00,614.24,380828.80,0.00,0.00,0.00),('1','153','763','257552',4903721,'2133','321',1558955.09,1559709.30,0.00,0.00,754.21,482694.40,0.00,0.00,0.00),('1','153','763','257552',4903722,'2998','321',175588.49,176519.34,0.00,0.00,930.85,595744.00,0.00,0.00,0.00),('1','153','763','257552',4903723,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257553',4903724,'2132','321',2269303.95,2269809.95,0.00,0.00,506.00,313795.40,0.00,0.00,0.00),('1','153','763','257553',4903725,'2133','321',1559709.30,1560017.69,0.00,0.00,308.39,197369.60,0.00,0.00,0.00),('1','153','763','257553',4903726,'2998','321',176519.34,176776.89,0.00,0.00,257.55,164832.00,0.00,0.00,0.00),('1','153','763','257553',4903727,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257554',4903728,'2132','321',2269809.95,2270116.95,0.00,0.00,307.00,190340.00,0.00,0.00,0.00),('1','153','763','257554',4903729,'2133','321',1560017.69,1560393.07,0.00,0.00,375.38,240243.20,0.00,0.00,0.00),('1','153','763','257554',4903730,'2998','321',176776.89,177198.67,0.00,0.00,421.78,269939.20,0.00,0.00,0.00),('1','153','763','257554',4903731,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257555',4903732,'2132','321',2270116.95,2271433.37,0.00,0.00,1316.42,816180.40,0.00,0.00,0.00),('1','153','763','257555',4903733,'2133','321',1560393.07,1561116.48,0.00,0.00,723.41,462982.40,0.00,0.00,0.00),('1','153','763','257555',4903734,'2998','321',177198.67,178136.38,0.00,0.00,937.71,600134.40,0.00,0.00,0.00),('1','153','763','257555',4903735,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257556',4903736,'2132','321',2271433.37,2272626.74,0.00,0.00,1193.37,739948.80,0.00,0.00,0.00),('1','153','763','257556',4903737,'2133','321',1561116.48,1561439.92,0.00,0.00,323.44,207001.60,0.00,0.00,0.00),('1','153','763','257556',4903738,'2998','321',178136.38,178697.69,0.00,0.00,561.31,359238.40,0.00,0.00,0.00),('1','153','763','257556',4903739,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257557',4903740,'2132','321',2272626.74,2273047.24,0.00,0.00,420.50,260710.00,0.00,0.00,0.00),('1','153','763','257557',4903741,'2133','321',1561439.92,1561619.15,0.00,0.00,179.23,114707.20,0.00,0.00,0.00),('1','153','763','257557',4903742,'2998','321',178697.69,179376.93,0.00,0.00,679.24,434713.60,0.00,0.00,0.00),('1','153','763','257557',4903743,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257558',4903744,'2132','321',2273047.24,2275002.61,0.00,0.00,1955.37,1212329.40,0.00,0.00,0.00),('1','153','763','257558',4903745,'2133','321',1561619.15,1562329.90,0.00,0.00,710.75,454880.00,0.00,0.00,0.00),('1','153','763','257558',4903746,'2998','321',179376.93,180446.77,0.00,0.00,1069.84,684697.60,0.00,0.00,0.00),('1','153','763','257558',4903747,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257559',4903748,'2132','321',2275002.61,2275493.90,0.00,0.00,491.29,304599.80,0.00,0.00,0.00),('1','153','763','257559',4903749,'2133','321',1562329.90,1562723.56,0.00,0.00,393.66,251942.40,0.00,0.00,0.00),('1','153','763','257559',4903750,'2998','321',180446.77,180752.70,0.00,0.00,305.93,195795.20,0.00,0.00,0.00),('1','153','763','257559',4903751,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257560',4903752,'2132','321',2275493.90,2275740.06,0.00,0.00,246.16,152619.20,0.00,0.00,0.00),('1','153','763','257560',4903753,'2133','321',1562723.56,1563058.55,0.00,0.00,334.99,214393.60,0.00,0.00,0.00),('1','153','763','257560',4903754,'2998','321',180752.70,181184.35,0.00,0.00,431.65,276256.00,0.00,0.00,0.00),('1','153','763','257560',4903755,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257561',4903756,'2132','321',2275740.06,2277148.06,0.00,0.00,1408.00,873710.00,0.00,0.00,0.00),('1','153','763','257561',4903757,'2133','321',1563058.55,1563788.38,0.00,0.00,729.83,466391.20,0.00,0.00,0.00),('1','153','763','257561',4903758,'2998','321',181184.35,182098.29,0.00,0.00,913.94,584921.60,0.00,0.00,0.00),('1','153','763','257561',4903759,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257562',4903760,'2132','321',2277148.06,2277388.06,0.00,0.00,240.00,148846.80,0.00,0.00,0.00),('1','153','763','257562',4903761,'2133','321',1563788.38,1564491.46,0.00,0.00,703.08,449971.20,0.00,0.00,0.00),('1','153','763','257562',4903762,'2998','321',182098.29,182872.11,0.00,0.00,773.82,495244.80,0.00,0.00,0.00),('1','153','763','257562',4903763,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257563',4903764,'2132','321',2277388.06,2277457.06,0.00,0.00,69.00,42780.00,0.00,0.00,0.00),('1','153','763','257563',4903765,'2133','321',1564491.46,1564711.98,0.00,0.00,220.52,141132.80,0.00,0.00,0.00),('1','153','763','257563',4903766,'2998','321',182872.11,183004.19,0.00,0.00,132.08,84531.20,0.00,0.00,0.00),('1','153','763','257563',4903767,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257564',4903768,'2132','321',2277457.06,2277500.06,0.00,0.00,43.00,26660.00,0.00,0.00,0.00),('1','153','763','257564',4903769,'2133','321',1564711.98,1565197.82,0.00,0.00,485.84,310937.60,0.00,0.00,0.00),('1','153','763','257564',4903770,'2998','321',183004.19,183707.91,0.00,0.00,703.72,450380.80,0.00,0.00,0.00),('1','153','763','257564',4903771,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257565',4903772,'2132','321',2277500.06,2277501.76,0.00,0.00,1.70,1054.00,0.00,0.00,0.00),('1','153','763','257565',4903773,'2133','321',1565197.82,1565944.08,0.00,0.00,746.26,477606.40,0.00,0.00,0.00),('1','153','763','257565',4903774,'2998','321',183707.91,184676.51,0.00,0.00,968.60,619904.00,0.00,0.00,0.00),('1','153','763','257565',4903775,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257566',4903776,'2132','321',2277501.76,2277545.76,0.00,0.00,44.00,27280.00,0.00,0.00,0.00),('1','153','763','257566',4903777,'2133','321',1565944.08,1566559.65,0.00,0.00,615.57,393964.80,0.00,0.00,0.00),('1','153','763','257566',4903778,'2998','321',184676.51,185413.21,0.00,0.00,736.70,471488.00,0.00,0.00,0.00),('1','153','763','257566',4903779,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257567',4903780,'2132','321',2277545.76,2277550.71,0.00,0.00,4.95,3069.00,0.00,0.00,0.00),('1','153','763','257567',4903781,'2133','321',1566559.65,1567234.49,0.00,0.00,674.84,431897.60,0.00,0.00,0.00),('1','153','763','257567',4903782,'2998','321',185413.21,186152.81,0.00,0.00,739.60,473344.00,0.00,0.00,0.00),('1','153','763','257567',4903783,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257568',4903784,'2132','321',2277550.71,2277550.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257568',4903785,'2133','321',1567234.49,1567356.92,0.00,0.00,122.43,78006.24,0.00,0.00,0.00),('1','153','763','257568',4903786,'2998','321',186152.81,186541.60,0.00,0.00,388.79,247375.72,0.00,0.00,0.00),('1','153','763','257568',4903787,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257569',4903788,'2132','321',2277550.71,2277622.98,0.00,0.00,72.27,44373.78,0.00,0.00,0.00),('1','153','763','257569',4903789,'2133','321',1567356.92,1567627.94,0.00,0.00,271.02,172368.72,0.00,0.00,0.00),('1','153','763','257569',4903790,'2998','321',186541.60,186759.97,0.00,0.00,218.37,138883.32,0.00,0.00,0.00),('1','153','763','257569',4903791,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257570',4903792,'2132','321',2277622.98,2277727.48,0.00,0.00,104.50,64163.00,0.00,0.00,0.00),('1','153','763','257570',4903793,'2133','321',1567627.94,1568359.26,0.00,0.00,731.32,465119.52,0.00,0.00,0.00),('1','153','763','257570',4903794,'2998','321',186759.97,187363.95,0.00,0.00,603.98,384131.28,0.00,0.00,0.00),('1','153','763','257570',4903795,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257571',4903796,'2132','321',2277727.48,2277869.56,0.00,0.00,142.08,87237.12,0.00,0.00,0.00),('1','153','763','257571',4903797,'2133','321',1568359.26,1569122.67,0.00,0.00,763.41,485528.76,0.00,0.00,0.00),('1','153','763','257571',4903798,'2998','321',187363.95,188050.00,0.00,0.00,686.05,436327.80,0.00,0.00,0.00),('1','153','763','257571',4903799,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257572',4903800,'2132','321',2277869.56,2278025.17,0.00,0.00,155.61,95544.54,0.00,0.00,0.00),('1','153','763','257572',4903801,'2133','321',1569122.67,1569736.85,0.00,0.00,614.18,390618.48,0.00,0.00,0.00),('1','153','763','257572',4903802,'2998','321',188050.00,188858.43,0.00,0.00,808.43,514161.48,0.00,0.00,0.00),('1','153','763','257572',4903803,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257573',4903804,'2132','321',2278025.17,2278119.65,0.00,0.00,94.48,58010.72,0.00,0.00,0.00),('1','153','763','257573',4903805,'2133','321',1569736.85,1570215.97,0.00,0.00,479.12,304720.32,0.00,0.00,0.00),('1','153','763','257573',4903806,'2998','321',188858.43,189373.25,0.00,0.00,514.82,327425.52,0.00,0.00,0.00),('1','153','763','257573',4903807,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257574',4903808,'2132','321',2278119.65,2278164.65,0.00,0.00,45.00,27630.00,0.00,0.00,0.00),('1','153','763','257574',4903809,'2133','321',1570215.97,1570389.33,0.00,0.00,173.36,110256.96,0.00,0.00,0.00),('1','153','763','257574',4903810,'2998','321',189373.25,189524.29,0.00,0.00,151.04,96061.44,0.00,0.00,0.00),('1','153','763','257574',4903811,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257575',4903812,'2132','321',2278164.65,2278208.02,0.00,0.00,43.37,26629.18,0.00,0.00,0.00),('1','153','763','257575',4903813,'2133','321',1570389.33,1571423.51,0.00,0.00,1034.18,657738.48,0.00,0.00,0.00),('1','153','763','257575',4903814,'2998','321',189524.29,190107.11,0.00,0.00,582.82,370673.52,0.00,0.00,0.00),('1','153','763','257575',4903815,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257576',4903816,'2132','321',2278208.02,2278343.02,0.00,0.00,135.00,82959.08,0.00,0.00,0.00),('1','153','763','257576',4903817,'2133','321',1571423.51,1572175.19,0.00,0.00,751.68,478068.48,0.00,0.00,0.00),('1','153','763','257576',4903818,'2998','321',190107.11,190897.37,0.00,0.00,790.26,502605.36,0.00,0.00,0.00),('1','153','763','257576',4903819,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257577',4903820,'2132','321',2278343.02,2278349.53,0.00,0.00,6.51,3997.14,0.00,0.00,0.00),('1','153','763','257577',4903821,'2133','321',1572175.19,1572646.77,0.00,0.00,471.58,299924.88,0.00,0.00,0.00),('1','153','763','257577',4903822,'2998','321',190897.37,191501.81,0.00,0.00,604.44,384423.84,0.00,0.00,0.00),('1','153','763','257577',4903823,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257578',4903824,'2132','321',2278349.53,2278365.48,0.00,0.00,15.95,10052.68,0.00,0.00,0.00),('1','153','763','257578',4903825,'2133','321',1572646.77,1573190.46,0.00,0.00,543.69,345786.84,0.00,0.00,0.00),('1','153','763','257578',4903826,'2998','321',191501.81,192094.79,0.00,0.00,592.98,376761.28,0.00,0.00,0.00),('1','153','763','257578',4903827,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257579',4903828,'2132','321',2278365.48,2278365.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257579',4903829,'2133','321',1573190.46,1573272.21,0.00,0.00,81.75,51993.00,0.00,0.00,0.00),('1','153','763','257579',4903830,'2998','321',192094.79,192239.46,0.00,0.00,144.67,92010.12,0.00,0.00,0.00),('1','153','763','257579',4903831,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257580',4903832,'2132','321',2278365.48,2278445.48,0.00,0.00,80.00,49120.00,0.00,0.00,0.00),('1','153','763','257580',4903833,'2133','321',1573272.21,1573616.49,0.00,0.00,344.28,218962.08,0.00,0.00,0.00),('1','153','763','257580',4903834,'2998','321',192239.46,192994.50,0.00,0.00,755.04,480205.44,0.00,0.00,0.00),('1','153','763','257580',4903835,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257581',4903836,'2132','321',2278445.48,2278667.98,0.00,0.00,222.50,136890.00,0.00,0.00,0.00),('1','153','763','257581',4903837,'2133','321',1573616.49,1574365.64,0.00,0.00,749.15,476184.40,0.00,0.00,0.00),('1','153','763','257581',4903838,'2998','321',192994.50,193732.76,0.00,0.00,738.26,469533.36,0.00,0.00,0.00),('1','153','763','257581',4903839,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257582',4903840,'2132','321',2278667.98,2278731.28,0.00,0.00,63.30,38866.20,0.00,0.00,0.00),('1','153','763','257582',4903841,'2133','321',1574365.64,1575220.52,0.00,0.00,854.88,543703.68,0.00,0.00,0.00),('1','153','763','257582',4903842,'2998','321',193732.76,194658.05,0.00,0.00,925.29,588484.44,0.00,0.00,0.00),('1','153','763','257582',4903843,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257583',4903844,'2132','321',2278731.28,2278797.24,0.00,0.00,65.96,40689.52,0.00,0.00,0.00),('1','153','763','257583',4903845,'2133','321',1575220.52,1575874.88,0.00,0.00,654.36,416172.96,0.00,0.00,0.00),('1','153','763','257583',4903846,'2998','321',194658.05,195386.32,0.00,0.00,728.27,462989.64,0.00,0.00,0.00),('1','153','763','257583',4903847,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257584',4903848,'2132','321',2278797.24,2278797.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257584',4903849,'2133','321',1575874.88,1576130.69,0.00,0.00,255.81,162695.16,0.00,0.00,0.00),('1','153','763','257584',4903850,'2998','321',195386.32,195710.65,0.00,0.00,324.33,206273.88,0.00,0.00,0.00),('1','153','763','257584',4903851,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257585',4903852,'2132','321',2278797.24,2278818.24,0.00,0.00,21.00,13356.00,0.00,0.00,0.00),('1','153','763','257585',4903853,'2133','321',1576130.69,1577242.68,0.00,0.00,1111.99,706950.64,0.00,0.00,0.00),('1','153','763','257585',4903854,'2998','321',195710.65,197236.72,0.00,0.00,1526.07,970460.40,0.00,0.00,0.00),('1','153','763','257585',4903855,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257586',4903856,'2132','321',2278818.24,2278968.24,0.00,0.00,150.00,92100.00,0.00,0.00,0.00),('1','153','763','257586',4903857,'2133','321',1577242.68,1577753.58,0.00,0.00,510.90,324932.40,0.00,0.00,0.00),('1','153','763','257586',4903858,'2998','321',197236.72,197642.25,0.00,0.00,405.53,257917.08,0.00,0.00,0.00),('1','153','763','257586',4903859,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257587',4903860,'2132','321',2278968.24,2278991.18,0.00,0.00,22.94,14085.16,0.00,0.00,0.00),('1','153','763','257587',4903861,'2133','321',1577753.58,1578101.10,0.00,0.00,347.52,221022.72,0.00,0.00,0.00),('1','153','763','257587',4903862,'2998','321',197642.25,198552.14,0.00,0.00,909.89,578690.04,0.00,0.00,0.00),('1','153','763','257587',4903863,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257588',4903864,'2132','321',2278991.18,2279013.18,0.00,0.00,22.00,13508.00,0.00,0.00,0.00),('1','153','763','257588',4903865,'2133','321',1578101.10,1578240.78,0.00,0.00,139.68,88836.48,0.00,0.00,0.00),('1','153','763','257588',4903866,'2998','321',198552.14,198820.17,0.00,0.00,268.03,170467.08,0.00,0.00,0.00),('1','153','763','257588',4903867,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257589',4903868,'2132','321',2279013.18,2279013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257589',4903869,'2133','321',1578240.78,1578602.79,0.00,0.00,362.01,230238.36,0.00,0.00,0.00),('1','153','763','257589',4903870,'2998','321',198820.17,199077.43,0.00,0.00,257.26,163617.36,0.00,0.00,0.00),('1','153','763','257589',4903871,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257590',4903872,'2132','321',2279013.18,2279239.18,0.00,0.00,226.00,138764.00,0.00,0.00,0.00),('1','153','763','257590',4903873,'2133','321',1578602.79,1579449.16,0.00,0.00,846.37,538291.32,0.00,0.00,0.00),('1','153','763','257590',4903874,'2998','321',199077.43,199908.71,0.00,0.00,831.28,528694.08,0.00,0.00,0.00),('1','153','763','257590',4903875,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257591',4903876,'2132','321',2279239.18,2279265.28,0.00,0.00,26.10,16025.40,0.00,0.00,0.00),('1','153','763','257591',4903877,'2133','321',1579449.16,1579997.65,0.00,0.00,548.49,348839.64,0.00,0.00,0.00),('1','153','763','257591',4903878,'2998','321',199908.71,200678.23,0.00,0.00,769.52,489414.72,0.00,0.00,0.00),('1','153','763','257591',4903879,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257592',4903880,'2132','321',2279265.28,2279437.74,0.00,0.00,172.46,105890.44,0.00,0.00,0.00),('1','153','763','257592',4903881,'2133','321',1579997.65,1581588.64,0.00,0.00,1590.99,1011869.64,0.00,0.00,0.00),('1','153','763','257592',4903882,'2998','321',200678.23,200928.38,0.00,0.00,250.15,159095.40,0.00,0.00,0.00),('1','153','763','257592',4903883,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257593',4903884,'2132','321',2279437.74,2279437.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257593',4903885,'2133','321',1581588.64,1581751.43,0.00,0.00,162.79,103534.44,0.00,0.00,0.00),('1','153','763','257593',4903886,'2998','321',200928.38,201133.32,0.00,0.00,204.94,130341.84,0.00,0.00,0.00),('1','153','763','257593',4903887,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257594',4903888,'2132','321',2279437.74,2279518.24,0.00,0.00,80.50,49427.00,0.00,0.00,0.00),('1','153','763','257594',4903889,'2133','321',1581751.43,1582574.34,0.00,0.00,822.91,523370.76,0.00,0.00,0.00),('1','153','763','257594',4903890,'2998','321',201133.32,201941.77,0.00,0.00,808.45,514174.20,0.00,0.00,0.00),('1','153','763','257594',4903891,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257595',4903892,'2132','321',2279518.24,2279801.74,0.00,0.00,283.50,174069.00,0.00,0.00,0.00),('1','153','763','257595',4903893,'2133','321',1582574.34,1583169.67,0.00,0.00,595.33,378629.88,0.00,0.00,0.00),('1','153','763','257595',4903894,'2998','321',201941.77,202431.99,0.00,0.00,490.22,311779.92,0.00,0.00,0.00),('1','153','763','257595',4903895,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257596',4903896,'2132','321',2279801.74,2279994.23,0.00,0.00,192.49,118327.24,0.00,0.00,0.00),('1','153','763','257596',4903897,'2133','321',1583169.67,1584201.76,0.00,0.00,1032.09,656134.24,0.00,0.00,0.00),('1','153','763','257596',4903898,'2998','321',202431.99,203644.70,0.00,0.00,1212.71,771283.56,0.00,0.00,0.00),('1','153','763','257596',4903899,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257597',4903900,'2132','321',2279994.23,2280019.23,0.00,0.00,25.00,15350.00,0.00,0.00,0.00),('1','153','763','257597',4903901,'2133','321',1584201.76,1584674.16,0.00,0.00,472.40,300446.40,0.00,0.00,0.00),('1','153','763','257597',4903902,'2998','321',203644.70,203887.18,0.00,0.00,242.48,154217.28,0.00,0.00,0.00),('1','153','763','257597',4903903,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257598',4903904,'2132','321',2280019.23,2280025.23,0.00,0.00,6.00,3684.00,0.00,0.00,0.00),('1','153','763','257598',4903905,'2133','321',1584674.16,1585678.85,0.00,0.00,1004.69,638982.84,0.00,0.00,0.00),('1','153','763','257598',4903906,'2998','321',203887.18,203900.97,0.00,0.00,13.79,8770.44,0.00,0.00,0.00),('1','153','763','257598',4903907,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257599',4903908,'2132','321',2280025.23,2280212.73,0.00,0.00,187.50,115211.46,0.00,0.00,0.00),('1','153','763','257599',4903909,'2133','321',1585678.85,1586478.73,0.00,0.00,799.88,508723.68,0.00,0.00,0.00),('1','153','763','257599',4903910,'2998','321',203900.97,204624.66,0.00,0.00,723.69,460266.84,0.00,0.00,0.00),('1','153','763','257599',4903911,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257600',4903912,'2132','321',2280212.73,2280242.73,0.00,0.00,30.00,18420.00,0.00,0.00,0.00),('1','153','763','257600',4903913,'2133','321',1586478.73,1587223.47,0.00,0.00,744.74,473654.64,0.00,0.00,0.00),('1','153','763','257600',4903914,'2998','321',204624.66,205594.32,0.00,0.00,969.66,616703.76,0.00,0.00,0.00),('1','153','763','257600',4903915,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257601',4903916,'2132','321',2280242.73,2280392.73,0.00,0.00,150.00,92203.84,0.00,0.00,0.00),('1','153','763','257601',4903917,'2133','321',1587223.47,1588011.69,0.00,0.00,788.22,501307.92,0.00,0.00,0.00),('1','153','763','257601',4903918,'2998','321',205594.32,206120.93,0.00,0.00,526.61,334769.96,0.00,0.00,0.00),('1','153','763','257601',4903919,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257602',4903920,'2132','321',2280392.73,2280392.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257602',4903921,'2133','321',1588011.69,1588199.32,0.00,0.00,187.63,130590.48,0.00,0.00,0.00),('1','153','763','257602',4903922,'2998','321',206120.93,206239.94,0.00,0.00,119.01,82830.96,0.00,0.00,0.00),('1','153','763','257602',4903923,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257603',4903924,'2132','321',2280392.73,2280441.73,0.00,0.00,49.00,31948.00,0.00,0.00,0.00),('1','153','763','257603',4903925,'2133','321',1588199.32,1588664.88,0.00,0.00,465.56,324029.76,0.00,0.00,0.00),('1','153','763','257603',4903926,'2998','321',206239.94,206781.36,0.00,0.00,541.42,376828.32,0.00,0.00,0.00),('1','153','763','257603',4903927,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257604',4903928,'2132','321',2280441.73,2280512.31,0.00,0.00,70.58,46460.80,0.00,0.00,0.00),('1','153','763','257604',4903929,'2133','321',1588664.88,1589165.84,0.00,0.00,500.96,348228.16,0.00,0.00,0.00),('1','153','763','257604',4903930,'2998','321',206781.36,207732.71,0.00,0.00,951.35,662139.60,0.00,0.00,0.00),('1','153','763','257604',4903931,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257605',4903932,'2132','321',2280512.31,2280735.31,0.00,0.00,223.00,145396.00,0.00,0.00,0.00),('1','153','763','257605',4903933,'2133','321',1589165.84,1589832.09,0.00,0.00,666.25,463710.00,0.00,0.00,0.00),('1','153','763','257605',4903934,'2998','321',207732.71,208426.40,0.00,0.00,693.69,482808.24,0.00,0.00,0.00),('1','153','763','257605',4903935,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257606',4903936,'2132','321',2280735.31,2280792.36,0.00,0.00,57.05,37196.60,0.00,0.00,0.00),('1','153','763','257606',4903937,'2133','321',1589832.09,1590505.39,0.00,0.00,673.30,468616.80,0.00,0.00,0.00),('1','153','763','257606',4903938,'2998','321',208426.40,209216.08,0.00,0.00,789.68,549617.28,0.00,0.00,0.00),('1','153','763','257606',4903939,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257607',4903940,'2132','321',2280792.36,2280792.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257607',4903941,'2133','321',1590505.39,1590790.67,0.00,0.00,285.28,198554.88,0.00,0.00,0.00),('1','153','763','257607',4903942,'2998','321',209216.08,209474.82,0.00,0.00,258.74,180083.04,0.00,0.00,0.00),('1','153','763','257607',4903943,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257608',4903944,'2132','321',2280792.36,2280797.39,0.00,0.00,5.03,3279.56,0.00,0.00,0.00),('1','153','763','257608',4903945,'2133','321',1590790.67,1591281.63,0.00,0.00,490.96,341708.16,0.00,0.00,0.00),('1','153','763','257608',4903946,'2998','321',209474.82,209731.59,0.00,0.00,256.77,178711.92,0.00,0.00,0.00),('1','153','763','257608',4903947,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257609',4903948,'2132','321',2280797.39,2280822.52,0.00,0.00,25.13,16384.76,0.00,0.00,0.00),('1','153','763','257609',4903949,'2133','321',1591281.63,1591864.11,0.00,0.00,582.48,405406.08,0.00,0.00,0.00),('1','153','763','257609',4903950,'2998','321',209731.59,210647.28,0.00,0.00,915.69,637320.24,0.00,0.00,0.00),('1','153','763','257609',4903951,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257610',4903952,'2132','321',2280822.52,2280822.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257610',4903953,'2133','321',1591864.11,1592090.36,0.00,0.00,226.25,157470.00,0.00,0.00,0.00),('1','153','763','257610',4903954,'2998','321',210647.28,210862.37,0.00,0.00,215.09,149702.64,0.00,0.00,0.00),('1','153','763','257610',4903955,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257611',4903956,'2132','321',2280822.52,2280843.42,0.00,0.00,20.90,13376.00,0.00,0.00,0.00),('1','153','763','257611',4903957,'2133','321',1592090.36,1592750.81,0.00,0.00,660.45,449106.00,0.00,0.00,0.00),('1','153','763','257611',4903958,'2998','321',210862.37,211527.70,0.00,0.00,665.33,452424.40,0.00,0.00,0.00),('1','153','763','257611',4903959,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257612',4903960,'2132','321',2280843.42,2280885.92,0.00,0.00,42.50,27376.40,0.00,0.00,0.00),('1','153','763','257612',4903961,'2133','321',1592750.81,1593559.27,0.00,0.00,808.46,549752.80,0.00,0.00,0.00),('1','153','763','257612',4903962,'2998','321',211527.70,212124.14,0.00,0.00,596.44,405579.20,0.00,0.00,0.00),('1','153','763','257612',4903963,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257613',4903964,'2132','321',2280885.92,2280885.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257613',4903965,'2133','321',1593559.27,1593933.78,0.00,0.00,374.51,254666.80,0.00,0.00,0.00),('1','153','763','257613',4903966,'2998','321',212124.14,212417.87,0.00,0.00,293.73,199736.40,0.00,0.00,0.00),('1','153','763','257613',4903967,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257614',4903968,'2132','321',2280885.92,2280885.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257614',4903969,'2133','321',1593933.78,1594249.29,0.00,0.00,315.51,214546.80,0.00,0.00,0.00),('1','153','763','257614',4903970,'2998','321',212417.87,212776.05,0.00,0.00,358.18,243562.40,0.00,0.00,0.00),('1','153','763','257614',4903971,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257615',4903972,'2132','321',2280885.92,2280991.83,0.00,0.00,105.91,67782.40,0.00,0.00,0.00),('1','153','763','257615',4903973,'2133','321',1594249.29,1594906.10,0.00,0.00,656.81,446630.80,0.00,0.00,0.00),('1','153','763','257615',4903974,'2998','321',212776.05,213321.37,0.00,0.00,545.32,370817.60,0.00,0.00,0.00),('1','153','763','257615',4903975,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257616',4903976,'2132','321',2280991.83,2280999.83,0.00,0.00,8.00,5568.00,0.00,0.00,0.00),('1','153','763','257616',4903977,'2133','321',1594906.10,1595673.80,0.00,0.00,767.70,568098.00,0.00,0.00,0.00),('1','153','763','257616',4903978,'2998','321',213321.37,214024.38,0.00,0.00,703.01,520227.40,0.00,0.00,0.00),('1','153','763','257616',4903979,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257617',4903980,'2132','321',2280999.83,2281139.82,0.00,0.00,139.99,97433.04,0.00,0.00,0.00),('1','153','763','257617',4903981,'2133','321',1595673.80,1596397.43,0.00,0.00,723.63,535486.20,0.00,0.00,0.00),('1','153','763','257617',4903982,'2998','321',214024.38,214529.46,0.00,0.00,505.08,373759.20,0.00,0.00,0.00),('1','153','763','257617',4903983,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257618',4903984,'2132','321',2281139.82,2281156.82,0.00,0.00,17.00,11832.00,0.00,0.00,0.00),('1','153','763','257618',4903985,'2133','321',1596397.43,1597524.37,0.00,0.00,1126.94,833935.60,0.00,0.00,0.00),('1','153','763','257618',4903986,'2998','321',214529.46,214811.16,0.00,0.00,281.70,208458.00,0.00,0.00,0.00),('1','153','763','257618',4903987,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257619',4903988,'2132','321',2281156.82,2281179.82,0.00,0.00,23.00,16008.00,0.00,0.00,0.00),('1','153','763','257619',4903989,'2133','321',1597524.37,1598300.29,0.00,0.00,775.92,574180.80,0.00,0.00,0.00),('1','153','763','257619',4903990,'2998','321',214811.16,215733.31,0.00,0.00,922.15,682391.00,0.00,0.00,0.00),('1','153','763','257619',4903991,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257620',4903992,'2132','321',2281179.82,2281219.82,0.00,0.00,40.00,27840.00,0.00,0.00,0.00),('1','153','763','257620',4903993,'2133','321',1598300.29,1599662.12,0.00,0.00,1361.83,953281.00,0.00,0.00,0.00),('1','153','763','257620',4903994,'2998','321',215733.31,216134.47,0.00,0.00,401.16,280812.00,0.00,0.00,0.00),('1','153','763','257620',4903995,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257621',4903996,'2132','321',2281219.82,2281219.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257621',4903997,'2133','321',1599662.12,1600904.78,0.00,0.00,1242.66,869862.00,0.00,0.00,0.00),('1','153','763','257621',4903998,'2998','321',216134.47,216826.60,0.00,0.00,692.13,484491.00,0.00,0.00,0.00),('1','153','763','257621',4903999,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257622',4904000,'2132','321',2281219.82,2281657.82,0.00,0.00,438.00,289956.00,0.00,0.00,0.00),('1','153','763','257622',4904001,'2133','321',1600904.78,1601203.18,0.00,0.00,298.40,202912.00,0.00,0.00,0.00),('1','153','763','257622',4904002,'2998','321',216826.60,216918.71,0.00,0.00,92.11,62634.80,0.00,0.00,0.00),('1','153','763','257622',4904003,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257623',4904004,'2132','321',2281657.82,2281957.53,0.00,0.00,299.71,198408.02,0.00,0.00,0.00),('1','153','763','257623',4904005,'2133','321',1601203.18,1602153.56,0.00,0.00,950.38,645877.34,0.00,0.00,0.00),('1','153','763','257623',4904006,'2998','321',216918.71,217084.21,0.00,0.00,165.50,112540.00,0.00,0.00,0.00),('1','153','763','257623',4904007,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257624',4904008,'2132','321',2281957.53,2281999.45,0.00,0.00,41.92,27751.04,0.00,0.00,0.00),('1','153','763','257624',4904009,'2133','321',1602153.56,1602844.60,0.00,0.00,691.04,469907.20,0.00,0.00,0.00),('1','153','763','257624',4904010,'2998','321',217084.21,217940.00,0.00,0.00,855.79,581937.20,0.00,0.00,0.00),('1','153','763','257624',4904011,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257625',4904012,'2132','321',2281999.45,2281999.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257625',4904013,'2133','321',1602844.60,1604039.42,0.00,0.00,1194.82,812477.60,0.00,0.00,0.00),('1','153','763','257625',4904014,'2998','321',217940.00,218217.73,0.00,0.00,277.73,188856.40,0.00,0.00,0.00),('1','153','763','257625',4904015,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257626',4904016,'2132','321',2281999.45,2282031.95,0.00,0.00,32.50,21515.00,0.00,0.00,0.00),('1','153','763','257626',4904017,'2133','321',1604039.42,1605267.02,0.00,0.00,1227.60,834768.00,0.00,0.00,0.00),('1','153','763','257626',4904018,'2998','321',218217.73,218546.75,0.00,0.00,329.02,223733.60,0.00,0.00,0.00),('1','153','763','257626',4904019,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257627',4904020,'2132','321',2282031.95,2282031.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257627',4904021,'2133','321',1605267.02,1605446.09,0.00,0.00,179.07,121767.60,0.00,0.00,0.00),('1','153','763','257627',4904022,'2998','321',218546.75,218553.22,0.00,0.00,6.47,4399.60,0.00,0.00,0.00),('1','153','763','257627',4904023,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257628',4904024,'2132','321',2282031.95,2282081.92,0.00,0.00,49.97,33080.14,0.00,0.00,0.00),('1','153','763','257628',4904025,'2133','321',1605446.09,1606626.42,0.00,0.00,1180.33,802624.40,0.00,0.00,0.00),('1','153','763','257628',4904026,'2998','321',218553.22,218871.86,0.00,0.00,318.64,216675.20,0.00,0.00,0.00),('1','153','763','257628',4904027,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257629',4904028,'2132','321',2282081.92,2282085.70,0.00,0.00,3.78,2502.36,0.00,0.00,0.00),('1','153','763','257629',4904029,'2133','321',1606626.42,1607706.52,0.00,0.00,1080.10,734468.00,0.00,0.00,0.00),('1','153','763','257629',4904030,'2998','321',218871.86,219672.14,0.00,0.00,800.28,544190.40,0.00,0.00,0.00),('1','153','763','257629',4904031,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257630',4904032,'2132','321',2282085.70,2282134.65,0.00,0.00,48.95,32404.90,0.00,0.00,0.00),('1','153','763','257630',4904033,'2133','321',1607706.52,1609032.01,0.00,0.00,1325.49,901333.20,0.00,0.00,0.00),('1','153','763','257630',4904034,'2998','321',219672.14,219849.25,0.00,0.00,177.11,120434.80,0.00,0.00,0.00),('1','153','763','257630',4904035,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257631',4904036,'2132','321',2282134.65,2282140.65,0.00,0.00,6.00,3972.00,0.00,0.00,0.00),('1','153','763','257631',4904037,'2133','321',1609032.01,1609943.40,0.00,0.00,911.39,619745.20,0.00,0.00,0.00),('1','153','763','257631',4904038,'2998','321',219849.25,220217.74,0.00,0.00,368.49,250573.20,0.00,0.00,0.00),('1','153','763','257631',4904039,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257632',4904040,'2132','321',2282140.65,2282140.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257632',4904041,'2133','321',1609943.40,1610245.75,0.00,0.00,302.35,205598.00,0.00,0.00,0.00),('1','153','763','257632',4904042,'2998','321',220217.74,220374.17,0.00,0.00,156.43,106372.40,0.00,0.00,0.00),('1','153','763','257632',4904043,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257633',4904044,'2132','321',2282140.65,2282140.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257633',4904045,'2133','321',1610245.75,1611452.71,0.00,0.00,1206.96,820732.80,0.00,0.00,0.00),('1','153','763','257633',4904046,'2998','321',220374.17,220837.90,0.00,0.00,463.73,315336.40,0.00,0.00,0.00),('1','153','763','257633',4904047,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257634',4904048,'2132','321',2282140.65,2282215.81,0.00,0.00,75.16,49755.92,0.00,0.00,0.00),('1','153','763','257634',4904049,'2133','321',1611452.71,1612513.55,0.00,0.00,1060.84,721371.20,0.00,0.00,0.00),('1','153','763','257634',4904050,'2998','321',220837.90,221099.25,0.00,0.00,261.35,177718.00,0.00,0.00,0.00),('1','153','763','257634',4904051,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257635',4904052,'2132','321',2282215.81,2282219.33,0.00,0.00,3.52,2499.20,0.00,0.00,0.00),('1','153','763','257635',4904053,'2133','321',1612513.55,1613563.88,0.00,0.00,1050.33,790797.50,0.00,0.00,0.00),('1','153','763','257635',4904054,'2998','321',221099.25,221262.14,0.00,0.00,162.89,119167.50,0.00,0.00,0.00),('1','153','763','257635',4904055,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257636',4904056,'2132','321',2282219.33,2282219.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257636',4904057,'2133','321',1613563.88,1613819.84,0.00,0.00,255.96,191970.00,0.00,0.00,0.00),('1','153','763','257636',4904058,'2998','321',221262.14,221320.81,0.00,0.00,58.67,44002.50,0.00,0.00,0.00),('1','153','763','257636',4904059,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257637',4904060,'2132','321',2282219.33,2282244.33,0.00,0.00,25.00,17750.00,0.00,0.00,0.00),('1','153','763','257637',4904061,'2133','321',1613819.84,1614801.14,0.00,0.00,981.30,735975.00,0.00,0.00,0.00),('1','153','763','257637',4904062,'2998','321',221320.81,221532.19,0.00,0.00,211.38,158535.00,0.00,0.00,0.00),('1','153','763','257637',4904063,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257638',4904064,'2132','321',2282244.33,2282249.33,0.00,0.00,5.00,3550.00,0.00,0.00,0.00),('1','153','763','257638',4904065,'2133','321',1614801.14,1615005.02,0.00,0.00,203.88,152910.00,0.00,0.00,0.00),('1','153','763','257638',4904066,'2998','321',221532.19,221599.49,0.00,0.00,67.30,50475.00,0.00,0.00,0.00),('1','153','763','257638',4904067,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257639',4904068,'2132','321',2282249.33,2282254.33,0.00,0.00,5.00,3550.00,0.00,0.00,0.00),('1','153','763','257639',4904069,'2133','321',1615005.02,1616363.89,0.00,0.00,1358.87,1019152.50,0.00,0.00,0.00),('1','153','763','257639',4904070,'2998','321',221599.49,222142.84,0.00,0.00,543.35,407512.50,0.00,0.00,0.00),('1','153','763','257639',4904071,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257640',4904072,'2132','321',2282254.33,2282254.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257640',4904073,'2133','321',1616363.89,1617469.48,0.00,0.00,1105.59,829192.50,0.00,0.00,0.00),('1','153','763','257640',4904074,'2998','321',222142.84,222441.42,0.00,0.00,298.58,223935.00,0.00,0.00,0.00),('1','153','763','257640',4904075,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257641',4904076,'2132','321',2282254.33,2282332.28,0.00,0.00,77.95,55344.50,0.00,0.00,0.00),('1','153','763','257641',4904077,'2133','321',1617469.48,1618474.75,0.00,0.00,1005.27,753952.50,0.00,0.00,0.00),('1','153','763','257641',4904078,'2998','321',222441.42,222714.77,0.00,0.00,273.35,205012.50,0.00,0.00,0.00),('1','153','763','257641',4904079,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257642',4904080,'2132','321',2282332.28,2282344.78,0.00,0.00,12.50,8875.00,0.00,0.00,0.00),('1','153','763','257642',4904081,'2133','321',1618474.75,1619428.81,0.00,0.00,954.06,715545.00,0.00,0.00,0.00),('1','153','763','257642',4904082,'2998','321',222714.77,223007.74,0.00,0.00,292.97,219727.50,0.00,0.00,0.00),('1','153','763','257642',4904083,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257643',4904084,'2132','321',2282344.78,2282344.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257643',4904085,'2133','321',1619428.81,1620252.89,0.00,0.00,824.08,618060.00,0.00,0.00,0.00),('1','153','763','257643',4904086,'2998','321',223007.74,223369.90,0.00,0.00,362.16,271620.00,0.00,0.00,0.00),('1','153','763','257643',4904087,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257644',4904088,'2132','321',2282344.78,2282356.93,0.00,0.00,12.15,8626.50,0.00,0.00,0.00),('1','153','763','257644',4904089,'2133','321',1620252.89,1621069.42,0.00,0.00,816.53,612397.50,0.00,0.00,0.00),('1','153','763','257644',4904090,'2998','321',223369.90,223636.83,0.00,0.00,266.93,200197.50,0.00,0.00,0.00),('1','153','763','257644',4904091,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257645',4904092,'2132','321',2282356.93,2282361.43,0.00,0.00,4.50,3195.00,0.00,0.00,0.00),('1','153','763','257645',4904093,'2133','321',1621069.42,1622174.08,0.00,0.00,1104.66,828495.00,0.00,0.00,0.00),('1','153','763','257645',4904094,'2998','321',223636.83,224177.01,0.00,0.00,540.18,405135.00,0.00,0.00,0.00),('1','153','763','257645',4904095,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257646',4904096,'2132','321',2282361.43,2282516.75,0.00,0.00,155.32,110357.20,0.00,0.00,0.00),('1','153','763','257646',4904097,'2133','321',1622174.08,1623321.34,0.00,0.00,1147.26,860445.00,0.00,0.00,0.00),('1','153','763','257646',4904098,'2998','321',224177.01,224322.57,0.00,0.00,145.56,109170.00,0.00,0.00,0.00),('1','153','763','257646',4904099,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257647',4904100,'2132','321',2282516.75,2282516.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257647',4904101,'2133','321',1623321.34,1623918.83,0.00,0.00,597.49,448117.50,0.00,0.00,0.00),('1','153','763','257647',4904102,'2998','321',224322.57,224557.29,0.00,0.00,234.72,176040.00,0.00,0.00,0.00),('1','153','763','257647',4904103,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257648',4904104,'2132','321',2282516.75,2282557.94,0.00,0.00,41.19,29244.90,0.00,0.00,0.00),('1','153','763','257648',4904105,'2133','321',1623918.83,1624364.96,0.00,0.00,446.13,334597.50,0.00,0.00,0.00),('1','153','763','257648',4904106,'2998','321',224557.29,224745.48,0.00,0.00,188.19,141142.50,0.00,0.00,0.00),('1','153','763','257648',4904107,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257649',4904108,'2132','321',2282557.94,2282563.94,0.00,0.00,6.00,4260.00,0.00,0.00,0.00),('1','153','763','257649',4904109,'2133','321',1624364.96,1625282.04,0.00,0.00,917.08,687810.00,0.00,0.00,0.00),('1','153','763','257649',4904110,'2998','321',224745.48,225037.88,0.00,0.00,292.40,219300.00,0.00,0.00,0.00),('1','153','763','257649',4904111,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257650',4904112,'2132','321',2282563.94,2282569.92,0.00,0.00,5.98,4245.80,0.00,0.00,0.00),('1','153','763','257650',4904113,'2133','321',1625282.04,1626166.53,0.00,0.00,884.49,663367.50,0.00,0.00,0.00),('1','153','763','257650',4904114,'2998','321',225037.88,225822.07,0.00,0.00,784.19,588142.50,0.00,0.00,0.00),('1','153','763','257650',4904115,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257651',4904116,'2132','321',2282569.92,2282589.43,0.00,0.00,19.51,13852.10,0.00,0.00,0.00),('1','153','763','257651',4904117,'2133','321',1626166.53,1627362.95,0.00,0.00,1196.42,897315.00,0.00,0.00,0.00),('1','153','763','257651',4904118,'2998','321',225822.07,226114.65,0.00,0.00,292.58,219435.00,0.00,0.00,0.00),('1','153','763','257651',4904119,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257652',4904120,'2132','321',2282589.43,2282729.85,0.00,0.00,140.42,99698.20,0.00,0.00,0.00),('1','153','763','257652',4904121,'2133','321',1627362.95,1628016.89,0.00,0.00,653.94,490455.00,0.00,0.00,0.00),('1','153','763','257652',4904122,'2998','321',226114.65,226309.02,0.00,0.00,194.37,145777.50,0.00,0.00,0.00),('1','153','763','257652',4904123,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257653',4904124,'2132','321',2282729.85,2282837.84,0.00,0.00,107.99,76672.90,0.00,0.00,0.00),('1','153','763','257653',4904125,'2133','321',1628016.89,1628421.39,0.00,0.00,404.50,303375.00,0.00,0.00,0.00),('1','153','763','257653',4904126,'2998','321',226309.02,226423.98,0.00,0.00,114.96,86220.00,0.00,0.00,0.00),('1','153','763','257653',4904127,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257654',4904128,'2132','321',2282837.84,2282887.84,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','153','763','257654',4904129,'2133','321',1628421.39,1629678.74,0.00,0.00,1257.35,943012.50,0.00,0.00,0.00),('1','153','763','257654',4904130,'2998','321',226423.98,227179.52,0.00,0.00,755.54,566655.00,0.00,0.00,0.00),('1','153','763','257654',4904131,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257655',4904132,'2132','321',2282887.84,2282947.34,0.00,0.00,59.50,42245.00,0.00,0.00,0.00),('1','153','763','257655',4904133,'2133','321',1629678.74,1630699.64,0.00,0.00,1020.90,765675.00,0.00,0.00,0.00),('1','153','763','257655',4904134,'2998','321',227179.52,227505.99,0.00,0.00,326.47,244852.50,0.00,0.00,0.00),('1','153','763','257655',4904135,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257656',4904136,'2132','321',2282947.34,2282954.84,0.00,0.00,7.50,5325.00,0.00,0.00,0.00),('1','153','763','257656',4904137,'2133','321',1630699.64,1631780.83,0.00,0.00,1081.19,810892.50,0.00,0.00,0.00),('1','153','763','257656',4904138,'2998','321',227505.99,228179.48,0.00,0.00,673.49,505117.50,0.00,0.00,0.00),('1','153','763','257656',4904139,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257657',4904140,'2132','321',2282954.84,2282954.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257657',4904141,'2133','321',1631780.83,1631911.61,0.00,0.00,130.78,98085.00,0.00,0.00,0.00),('1','153','763','257657',4904142,'2998','321',228179.48,228250.07,0.00,0.00,70.59,52942.50,0.00,0.00,0.00),('1','153','763','257657',4904143,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257658',4904144,'2132','321',2282954.84,2283004.63,0.00,0.00,49.79,37342.50,0.00,0.00,0.00),('1','153','763','257658',4904145,'2133','321',1631911.61,1632369.85,0.00,0.00,458.24,343680.00,0.00,0.00,0.00),('1','153','763','257658',4904146,'2998','321',228250.07,228844.64,0.00,0.00,594.57,445927.50,0.00,0.00,0.00),('1','153','763','257658',4904147,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257659',4904148,'2132','321',2283004.63,2283062.63,0.00,0.00,58.00,41180.00,0.00,0.00,0.00),('1','153','763','257659',4904149,'2133','321',1632369.85,1633434.54,0.00,0.00,1064.69,798517.50,0.00,0.00,0.00),('1','153','763','257659',4904150,'2998','321',228844.64,229514.15,0.00,0.00,669.51,502132.50,0.00,0.00,0.00),('1','153','763','257659',4904151,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257660',4904152,'2132','321',2283062.63,2283064.89,0.00,0.00,2.26,1604.60,0.00,0.00,0.00),('1','153','763','257660',4904153,'2133','321',1633434.54,1634675.21,0.00,0.00,1240.67,930502.50,0.00,0.00,0.00),('1','153','763','257660',4904154,'2998','321',229514.15,229944.15,0.00,0.00,430.00,322500.00,0.00,0.00,0.00),('1','153','763','257660',4904155,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257661',4904156,'2132','321',2283064.89,2283180.89,0.00,0.00,116.00,82360.00,0.00,0.00,0.00),('1','153','763','257661',4904157,'2133','321',1634675.21,1635764.69,0.00,0.00,1089.48,817110.00,0.00,0.00,0.00),('1','153','763','257661',4904158,'2998','321',229944.15,230271.44,0.00,0.00,327.29,245467.50,0.00,0.00,0.00),('1','153','763','257661',4904159,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257662',4904160,'2132','321',2283180.89,2283239.89,0.00,0.00,59.00,41890.00,0.00,0.00,0.00),('1','153','763','257662',4904161,'2133','321',1635764.69,1637083.23,0.00,0.00,1318.54,988905.00,0.00,0.00,0.00),('1','153','763','257662',4904162,'2998','321',230271.44,230732.82,0.00,0.00,461.38,346035.00,0.00,0.00,0.00),('1','153','763','257662',4904163,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257663',4904164,'2132','321',2283239.89,2283346.02,0.00,0.00,106.13,75352.30,0.00,0.00,0.00),('1','153','763','257663',4904165,'2133','321',1637083.23,1638444.28,0.00,0.00,1361.05,1020787.50,0.00,0.00,0.00),('1','153','763','257663',4904166,'2998','321',230732.82,231687.34,0.00,0.00,954.52,715890.00,0.00,0.00,0.00),('1','153','763','257663',4904167,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257664',4904168,'2132','321',2283346.02,2283700.73,0.00,0.00,354.71,266032.50,0.00,0.00,0.00),('1','153','763','257664',4904169,'2133','321',1638444.28,1639725.44,0.00,0.00,1281.16,960870.00,0.00,0.00,0.00),('1','153','763','257664',4904170,'2998','321',231687.34,231851.62,0.00,0.00,164.28,123210.00,0.00,0.00,0.00),('1','153','763','257664',4904171,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257665',4904172,'2132','321',2283700.73,2283881.76,0.00,0.00,181.03,135772.50,0.00,0.00,0.00),('1','153','763','257665',4904173,'2133','321',1639725.44,1640257.20,0.00,0.00,531.76,398820.00,0.00,0.00,0.00),('1','153','763','257665',4904174,'2998','321',231851.62,232090.58,0.00,0.00,238.96,179220.00,0.00,0.00,0.00),('1','153','763','257665',4904175,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257666',4904176,'2132','321',2283881.76,2283915.56,0.00,0.00,33.80,23998.00,0.00,0.00,0.00),('1','153','763','257666',4904177,'2133','321',1640257.20,1640929.59,0.00,0.00,672.39,504292.50,0.00,0.00,0.00),('1','153','763','257666',4904178,'2998','321',232090.58,232317.63,0.00,0.00,227.05,170287.50,0.00,0.00,0.00),('1','153','763','257666',4904179,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257667',4904180,'2132','321',2283915.56,2283917.55,0.00,0.00,1.99,1492.50,0.00,0.00,0.00),('1','153','763','257667',4904181,'2133','321',1640929.59,1641973.65,0.00,0.00,1044.06,783045.00,0.00,0.00,0.00),('1','153','763','257667',4904182,'2998','321',232317.63,232536.87,0.00,0.00,219.24,164430.00,0.00,0.00,0.00),('1','153','763','257667',4904183,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257668',4904184,'2132','321',2283917.55,2283930.05,0.00,0.00,12.50,9375.00,0.00,0.00,0.00),('1','153','763','257668',4904185,'2133','321',1641973.65,1642986.15,0.00,0.00,1012.50,759375.00,0.00,0.00,0.00),('1','153','763','257668',4904186,'2998','321',232536.87,232733.52,0.00,0.00,196.65,147487.50,0.00,0.00,0.00),('1','153','763','257668',4904187,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257669',4904188,'2132','321',2283930.05,2284683.14,0.00,0.00,753.09,564817.50,0.00,0.00,0.00),('1','153','763','257669',4904189,'2133','321',1642986.15,1643005.96,0.00,0.00,19.81,14857.50,0.00,0.00,0.00),('1','153','763','257669',4904190,'2998','321',232733.52,232996.97,0.00,0.00,263.45,197587.50,0.00,0.00,0.00),('1','153','763','257669',4904191,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257670',4904192,'2132','321',2284683.14,2284835.46,0.00,0.00,152.32,114240.00,0.00,0.00,0.00),('1','153','763','257670',4904193,'2133','321',1643005.96,1643472.01,0.00,0.00,466.05,349537.50,0.00,0.00,0.00),('1','153','763','257670',4904194,'2998','321',232996.97,233068.80,0.00,0.00,71.83,53872.50,0.00,0.00,0.00),('1','153','763','257670',4904195,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257671',4904196,'2132','321',2284835.46,2284938.17,0.00,0.00,102.71,77032.50,0.00,0.00,0.00),('1','153','763','257671',4904197,'2133','321',1643472.01,1643562.65,0.00,0.00,90.64,67980.00,0.00,0.00,0.00),('1','153','763','257671',4904198,'2998','321',233068.80,233124.45,0.00,0.00,55.65,41737.50,0.00,0.00,0.00),('1','153','763','257671',4904199,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257672',4904200,'2132','321',2284938.17,2285754.75,0.00,0.00,816.58,612435.00,0.00,0.00,0.00),('1','153','763','257672',4904201,'2133','321',1643562.65,1643649.17,0.00,0.00,86.52,64890.00,0.00,0.00,0.00),('1','153','763','257672',4904202,'2998','321',233124.45,233619.17,0.00,0.00,494.72,371040.00,0.00,0.00,0.00),('1','153','763','257672',4904203,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257673',4904204,'2132','321',2285754.75,2286070.79,0.00,0.00,316.04,237030.00,0.00,0.00,0.00),('1','153','763','257673',4904205,'2133','321',1643649.17,1644446.69,0.00,0.00,797.52,598140.00,0.00,0.00,0.00),('1','153','763','257673',4904206,'2998','321',233619.17,233655.63,0.00,0.00,36.46,27345.00,0.00,0.00,0.00),('1','153','763','257673',4904207,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257674',4904208,'2132','321',2286070.79,2287057.12,0.00,0.00,986.33,736147.50,0.00,0.00,0.00),('1','153','763','257674',4904209,'2133','321',1644446.69,1644536.69,0.00,0.00,90.00,67500.00,0.00,0.00,0.00),('1','153','763','257674',4904210,'2998','321',233655.63,234098.32,0.00,0.00,442.69,332017.50,0.00,0.00,0.00),('1','153','763','257674',4904211,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257675',4904212,'2132','321',2287057.12,2287505.01,0.00,0.00,447.89,335917.50,0.00,0.00,0.00),('1','153','763','257675',4904213,'2133','321',1644536.69,1645224.64,0.00,0.00,687.95,515962.50,0.00,0.00,0.00),('1','153','763','257675',4904214,'2998','321',234098.32,234228.32,0.00,0.00,130.00,92300.00,0.00,0.00,0.00),('1','153','763','257675',4904215,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257676',4904216,'2132','321',2287505.01,2287505.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257676',4904217,'2133','321',1645224.64,1645502.63,0.00,0.00,277.99,208492.50,0.00,0.00,0.00),('1','153','763','257676',4904218,'2998','321',234228.32,234336.71,0.00,0.00,108.39,81292.50,0.00,0.00,0.00),('1','153','763','257676',4904219,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257677',4904220,'2132','321',2287505.01,2287566.01,0.00,0.00,61.00,43310.00,0.00,0.00,0.00),('1','153','763','257677',4904221,'2133','321',1645502.63,1646287.22,0.00,0.00,784.59,588442.50,0.00,0.00,0.00),('1','153','763','257677',4904222,'2998','321',234336.71,234718.45,0.00,0.00,381.74,286305.00,0.00,0.00,0.00),('1','153','763','257677',4904223,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257678',4904224,'2132','321',2287566.01,2287611.34,0.00,0.00,45.33,32184.30,0.00,0.00,0.00),('1','153','763','257678',4904225,'2133','321',1646287.22,1647256.89,0.00,0.00,969.67,727252.50,0.00,0.00,0.00),('1','153','763','257678',4904226,'2998','321',234718.45,235490.67,0.00,0.00,772.22,579165.00,0.00,0.00,0.00),('1','153','763','257678',4904227,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257679',4904228,'2132','321',2287611.34,2287611.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257679',4904229,'2133','321',1647256.89,1647557.78,0.00,0.00,300.89,225667.50,0.00,0.00,0.00),('1','153','763','257679',4904230,'2998','321',235490.67,235534.31,0.00,0.00,43.64,32730.00,0.00,0.00,0.00),('1','153','763','257679',4904231,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257680',4904232,'2132','321',2287611.34,2287721.32,0.00,0.00,109.98,78085.80,0.00,0.00,0.00),('1','153','763','257680',4904233,'2133','321',1647557.78,1648313.59,0.00,0.00,755.81,566857.50,0.00,0.00,0.00),('1','153','763','257680',4904234,'2998','321',235534.31,235852.05,0.00,0.00,317.74,238305.00,0.00,0.00,0.00),('1','153','763','257680',4904235,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257681',4904236,'2132','321',2287721.32,2287910.77,0.00,0.00,189.45,134509.50,0.00,0.00,0.00),('1','153','763','257681',4904237,'2133','321',1648313.59,1649344.90,0.00,0.00,1031.31,773482.50,0.00,0.00,0.00),('1','153','763','257681',4904238,'2998','321',235852.05,236084.28,0.00,0.00,232.23,174172.50,0.00,0.00,0.00),('1','153','763','257681',4904239,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257682',4904240,'2132','321',2287910.77,2288610.35,0.00,0.00,699.58,496701.80,0.00,0.00,0.00),('1','153','763','257682',4904241,'2133','321',1649344.90,1650448.94,0.00,0.00,1104.04,828030.00,0.00,0.00,0.00),('1','153','763','257682',4904242,'2998','321',236084.28,236363.93,0.00,0.00,279.65,209737.50,0.00,0.00,0.00),('1','153','763','257682',4904243,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257683',4904244,'2132','321',2288610.35,2289045.33,0.00,0.00,434.98,308835.80,0.00,0.00,0.00),('1','153','763','257683',4904245,'2133','321',1650448.94,1651273.09,0.00,0.00,824.15,618112.50,0.00,0.00,0.00),('1','153','763','257683',4904246,'2998','321',236363.93,236679.38,0.00,0.00,315.45,236587.50,0.00,0.00,0.00),('1','153','763','257683',4904247,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257684',4904248,'2132','321',2289045.33,2289082.33,0.00,0.00,37.00,26270.00,0.00,0.00,0.00),('1','153','763','257684',4904249,'2133','321',1651273.09,1651585.55,0.00,0.00,312.46,234345.00,0.00,0.00,0.00),('1','153','763','257684',4904250,'2998','321',236679.38,236723.17,0.00,0.00,43.79,32842.50,0.00,0.00,0.00),('1','153','763','257684',4904251,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257685',4904252,'2132','321',2289082.33,2289137.33,0.00,0.00,55.00,39050.00,0.00,0.00,0.00),('1','153','763','257685',4904253,'2133','321',1651585.55,1652806.83,0.00,0.00,1221.28,915960.00,0.00,0.00,0.00),('1','153','763','257685',4904254,'2998','321',236723.17,236987.91,0.00,0.00,264.74,198555.00,0.00,0.00,0.00),('1','153','763','257685',4904255,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257686',4904256,'2132','321',2289137.33,2289215.33,0.00,0.00,78.00,55380.00,0.00,0.00,0.00),('1','153','763','257686',4904257,'2133','321',1652806.83,1653390.94,0.00,0.00,584.11,438082.50,0.00,0.00,0.00),('1','153','763','257686',4904258,'2998','321',236987.91,237374.19,0.00,0.00,386.28,289710.00,0.00,0.00,0.00),('1','153','763','257686',4904259,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257687',4904260,'2132','321',2289215.33,2289215.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257687',4904261,'2133','321',1653390.94,1654490.58,0.00,0.00,1099.64,824730.00,0.00,0.00,0.00),('1','153','763','257687',4904262,'2998','321',237374.19,237647.37,0.00,0.00,273.18,204885.00,0.00,0.00,0.00),('1','153','763','257687',4904263,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257688',4904264,'2132','321',2289215.33,2289265.35,0.00,0.00,50.02,35514.20,0.00,0.00,0.00),('1','153','763','257688',4904265,'2133','321',1654490.58,1655530.66,0.00,0.00,1040.08,780060.00,0.00,0.00,0.00),('1','153','763','257688',4904266,'2998','321',237647.37,238034.72,0.00,0.00,387.35,290512.50,0.00,0.00,0.00),('1','153','763','257688',4904267,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257689',4904268,'2132','321',2289265.35,2289265.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257689',4904269,'2133','321',1655530.66,1655913.93,0.00,0.00,383.27,287452.50,0.00,0.00,0.00),('1','153','763','257689',4904270,'2998','321',238034.72,238138.31,0.00,0.00,103.59,77692.50,0.00,0.00,0.00),('1','153','763','257689',4904271,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257690',4904272,'2132','321',2289265.35,2289265.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257690',4904273,'2133','321',1655913.93,1656578.67,0.00,0.00,664.74,498555.00,0.00,0.00,0.00),('1','153','763','257690',4904274,'2998','321',238138.31,238345.52,0.00,0.00,207.21,155407.50,0.00,0.00,0.00),('1','153','763','257690',4904275,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257691',4904276,'2132','321',2289265.35,2289313.82,0.00,0.00,48.47,34413.70,0.00,0.00,0.00),('1','153','763','257691',4904277,'2133','321',1656578.67,1657536.28,0.00,0.00,957.61,718207.50,0.00,0.00,0.00),('1','153','763','257691',4904278,'2998','321',238345.52,238949.02,0.00,0.00,603.50,452625.00,0.00,0.00,0.00),('1','153','763','257691',4904279,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257692',4904280,'2132','321',2289313.82,2289325.91,0.00,0.00,12.09,8583.90,0.00,0.00,0.00),('1','153','763','257692',4904281,'2133','321',1657536.28,1658827.36,0.00,0.00,1291.08,968310.00,0.00,0.00,0.00),('1','153','763','257692',4904282,'2998','321',238949.02,239402.22,0.00,0.00,453.20,339900.00,0.00,0.00,0.00),('1','153','763','257692',4904283,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257693',4904284,'2132','321',2289325.91,2289414.99,0.00,0.00,89.08,63246.80,0.00,0.00,0.00),('1','153','763','257693',4904285,'2133','321',1658827.36,1659845.55,0.00,0.00,1018.19,763602.50,0.00,0.00,0.00),('1','153','763','257693',4904286,'2998','321',239402.22,239958.32,0.00,0.00,556.10,417075.00,0.00,0.00,0.00),('1','153','763','257693',4904287,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257694',4904288,'2132','321',2289414.99,2289414.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257694',4904289,'2133','321',1659845.55,1660133.00,0.00,0.00,287.45,215587.50,0.00,0.00,0.00),('1','153','763','257694',4904290,'2998','321',239958.32,240029.54,0.00,0.00,71.22,53415.00,0.00,0.00,0.00),('1','153','763','257694',4904291,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257695',4904292,'2132','321',2289414.99,2289980.06,0.00,0.00,565.07,423802.50,0.00,0.00,0.00),('1','153','763','257695',4904293,'2133','321',1660133.00,1660563.06,0.00,0.00,430.06,322545.00,0.00,0.00,0.00),('1','153','763','257695',4904294,'2998','321',240029.54,240371.05,0.00,0.00,341.51,256132.50,0.00,0.00,0.00),('1','153','763','257695',4904295,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257696',4904296,'2132','321',2289980.06,2290033.87,0.00,0.00,53.81,38205.10,0.00,0.00,0.00),('1','153','763','257696',4904297,'2133','321',1660563.06,1661440.10,0.00,0.00,877.04,657780.00,0.00,0.00,0.00),('1','153','763','257696',4904298,'2998','321',240371.05,240679.48,0.00,0.00,308.43,231322.50,0.00,0.00,0.00),('1','153','763','257696',4904299,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257697',4904300,'2132','321',2290033.87,2290033.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257697',4904301,'2133','321',1661440.10,1662787.55,0.00,0.00,1347.45,1010587.50,0.00,0.00,0.00),('1','153','763','257697',4904302,'2998','321',240679.48,240964.16,0.00,0.00,284.68,213510.00,0.00,0.00,0.00),('1','153','763','257697',4904303,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257698',4904304,'2132','321',2290033.87,2290196.37,0.00,0.00,162.50,115375.00,0.00,0.00,0.00),('1','153','763','257698',4904305,'2133','321',1662787.55,1664032.03,0.00,0.00,1244.48,933360.00,0.00,0.00,0.00),('1','153','763','257698',4904306,'2998','321',240964.16,241607.80,0.00,0.00,643.64,482730.00,0.00,0.00,0.00),('1','153','763','257698',4904307,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257699',4904308,'2132','321',2290196.37,2290690.37,0.00,0.00,494.00,350740.00,0.00,0.00,0.00),('1','153','763','257699',4904309,'2133','321',1664032.03,1665218.20,0.00,0.00,1186.17,889627.50,0.00,0.00,0.00),('1','153','763','257699',4904310,'2998','321',241607.80,241999.72,0.00,0.00,391.92,293940.00,0.00,0.00,0.00),('1','153','763','257699',4904311,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257700',4904312,'2132','321',2290690.37,2291022.37,0.00,0.00,332.00,235720.00,0.00,0.00,0.00),('1','153','763','257700',4904313,'2133','321',1665218.20,1666182.65,0.00,0.00,964.45,723337.50,0.00,0.00,0.00),('1','153','763','257700',4904314,'2998','321',241999.72,242648.41,0.00,0.00,648.69,486517.50,0.00,0.00,0.00),('1','153','763','257700',4904315,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257701',4904316,'2132','321',2291022.37,2291222.37,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','153','763','257701',4904317,'2133','321',1666182.65,1667587.93,0.00,0.00,1405.28,1053960.00,0.00,0.00,0.00),('1','153','763','257701',4904318,'2998','321',242648.41,242822.28,0.00,0.00,173.87,130402.50,0.00,0.00,0.00),('1','153','763','257701',4904319,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257702',4904320,'2132','321',2291222.37,2291525.87,0.00,0.00,303.50,215485.00,0.00,0.00,0.00),('1','153','763','257702',4904321,'2133','321',1667587.93,1667811.15,0.00,0.00,223.22,167415.00,0.00,0.00,0.00),('1','153','763','257702',4904322,'2998','321',242822.28,242822.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257702',4904323,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257703',4904324,'2132','321',2291525.87,2291625.87,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','153','763','257703',4904325,'2133','321',1667811.15,1668438.49,0.00,0.00,627.34,470505.00,0.00,0.00,0.00),('1','153','763','257703',4904326,'2998','321',242822.28,243113.41,0.00,0.00,291.13,218347.50,0.00,0.00,0.00),('1','153','763','257703',4904327,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257704',4904328,'2132','321',2291625.87,2291925.87,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','153','763','257704',4904329,'2133','321',1668438.49,1669638.68,0.00,0.00,1200.19,900142.50,0.00,0.00,0.00),('1','153','763','257704',4904330,'2998','321',243113.41,243292.99,0.00,0.00,179.58,134685.00,0.00,0.00,0.00),('1','153','763','257704',4904331,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257705',4904332,'2132','321',2291925.87,2291929.37,0.00,0.00,3.50,2485.00,0.00,0.00,0.00),('1','153','763','257705',4904333,'2133','321',1669638.68,1670589.49,0.00,0.00,950.81,713107.50,0.00,0.00,0.00),('1','153','763','257705',4904334,'2998','321',243292.99,243888.81,0.00,0.00,595.82,446865.00,0.00,0.00,0.00),('1','153','763','257705',4904335,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257706',4904336,'2132','321',2291929.37,2291929.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257706',4904337,'2133','321',1670589.49,1671709.02,0.00,0.00,1119.53,839647.50,0.00,0.00,0.00),('1','153','763','257706',4904338,'2998','321',243888.81,244072.24,0.00,0.00,183.43,137572.50,0.00,0.00,0.00),('1','153','763','257706',4904339,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257707',4904340,'2132','321',2291929.37,2291929.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257707',4904341,'2133','321',1671709.02,1672223.19,0.00,0.00,514.17,385627.50,0.00,0.00,0.00),('1','153','763','257707',4904342,'2998','321',244072.24,244307.27,0.00,0.00,235.03,176272.50,0.00,0.00,0.00),('1','153','763','257707',4904343,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257708',4904344,'2132','321',2291929.37,2291929.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257708',4904345,'2133','321',1672223.19,1672559.10,0.00,0.00,335.91,251932.50,0.00,0.00,0.00),('1','153','763','257708',4904346,'2998','321',244307.27,244538.59,0.00,0.00,231.32,173490.00,0.00,0.00,0.00),('1','153','763','257708',4904347,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257709',4904348,'2132','321',2291929.37,2291929.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257709',4904349,'2133','321',1672559.10,1673690.41,0.00,0.00,1131.31,848482.50,0.00,0.00,0.00),('1','153','763','257709',4904350,'2998','321',244538.59,244739.39,0.00,0.00,200.80,150600.00,0.00,0.00,0.00),('1','153','763','257709',4904351,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257710',4904352,'2132','321',2291929.37,2292810.43,0.00,0.00,881.06,660795.00,0.00,0.00,0.00),('1','153','763','257710',4904353,'2133','321',1673690.41,1673690.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257710',4904354,'2998','321',244739.39,245227.16,0.00,0.00,487.77,365827.50,0.00,0.00,0.00),('1','153','763','257710',4904355,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257711',4904356,'2132','321',2292810.43,2293791.21,0.00,0.00,980.78,735585.00,0.00,0.00,0.00),('1','153','763','257711',4904357,'2133','321',1673690.41,1673858.92,0.00,0.00,168.51,126382.50,0.00,0.00,0.00),('1','153','763','257711',4904358,'2998','321',245227.16,245418.23,0.00,0.00,191.07,143302.50,0.00,0.00,0.00),('1','153','763','257711',4904359,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257712',4904360,'2132','321',2293791.21,2294770.16,0.00,0.00,978.95,724972.50,0.00,0.00,0.00),('1','153','763','257712',4904361,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257712',4904362,'2998','321',245418.23,245902.42,0.00,0.00,484.19,363142.50,0.00,0.00,0.00),('1','153','763','257712',4904363,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257713',4904364,'2132','321',2294770.16,2295055.41,0.00,0.00,285.25,213937.50,0.00,0.00,0.00),('1','153','763','257713',4904365,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257713',4904366,'2998','321',245902.42,245902.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257713',4904367,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257714',4904368,'2132','321',2295055.41,2295398.59,0.00,0.00,343.18,256385.00,0.00,0.00,0.00),('1','153','763','257714',4904369,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257714',4904370,'2998','321',245902.42,245991.02,0.00,0.00,88.60,66450.00,0.00,0.00,0.00),('1','153','763','257714',4904371,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257715',4904372,'2132','321',2295398.59,2296387.68,0.00,0.00,989.09,741817.50,0.00,0.00,0.00),('1','153','763','257715',4904373,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257715',4904374,'2998','321',245991.02,246175.01,0.00,0.00,183.99,137992.50,0.00,0.00,0.00),('1','153','763','257715',4904375,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257716',4904376,'2132','321',2296387.68,2297139.58,0.00,0.00,751.90,555925.00,0.00,0.00,0.00),('1','153','763','257716',4904377,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257716',4904378,'2998','321',246175.01,246450.58,0.00,0.00,275.57,206677.50,0.00,0.00,0.00),('1','153','763','257716',4904379,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257717',4904380,'2132','321',2297139.58,2297307.57,0.00,0.00,167.99,125992.50,0.00,0.00,0.00),('1','153','763','257717',4904381,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257717',4904382,'2998','321',246450.58,246498.05,0.00,0.00,47.47,35602.50,0.00,0.00,0.00),('1','153','763','257717',4904383,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257718',4904384,'2132','321',2297307.57,2298374.91,0.00,0.00,1067.34,791225.00,0.00,0.00,0.00),('1','153','763','257718',4904385,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257718',4904386,'2998','321',246498.05,246802.38,0.00,0.00,304.33,228247.50,0.00,0.00,0.00),('1','153','763','257718',4904387,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257719',4904388,'2132','321',2298374.91,2299530.49,0.00,0.00,1155.58,864405.00,0.00,0.00,0.00),('1','153','763','257719',4904389,'2133','321',1673858.92,1673858.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257719',4904390,'2998','321',246802.38,247001.64,0.00,0.00,199.26,149445.00,0.00,0.00,0.00),('1','153','763','257719',4904391,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257720',4904392,'2132','321',2299530.49,2300490.83,0.00,0.00,960.34,720255.00,0.00,0.00,0.00),('1','153','763','257720',4904393,'2133','321',1673858.92,1673864.76,0.00,0.00,5.84,4380.00,0.00,0.00,0.00),('1','153','763','257720',4904394,'2998','321',247001.64,247331.45,0.00,0.00,329.81,248607.50,0.00,0.00,0.00),('1','153','763','257720',4904395,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257721',4904396,'2132','321',2300490.83,2301387.32,0.00,0.00,896.49,672367.50,0.00,0.00,0.00),('1','153','763','257721',4904397,'2133','321',1673864.76,1674095.80,0.00,0.00,231.04,164038.40,0.00,0.00,0.00),('1','153','763','257721',4904398,'2998','321',247331.45,247521.22,0.00,0.00,189.77,142327.50,0.00,0.00,0.00),('1','153','763','257721',4904399,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257722',4904400,'2132','321',2301387.32,2301387.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257722',4904401,'2133','321',1674095.80,1674663.29,0.00,0.00,567.49,425617.50,0.00,0.00,0.00),('1','153','763','257722',4904402,'2998','321',247521.22,247964.36,0.00,0.00,443.14,332355.00,0.00,0.00,0.00),('1','153','763','257722',4904403,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257723',4904404,'2132','321',2301387.32,2301811.68,0.00,0.00,424.36,318270.00,0.00,0.00,0.00),('1','153','763','257723',4904405,'2133','321',1674663.29,1675625.26,0.00,0.00,961.97,721477.50,0.00,0.00,0.00),('1','153','763','257723',4904406,'2998','321',247964.36,248545.84,0.00,0.00,581.48,436110.00,0.00,0.00,0.00),('1','153','763','257723',4904407,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257724',4904408,'2132','321',2301811.68,2301845.66,0.00,0.00,33.98,25485.00,0.00,0.00,0.00),('1','153','763','257724',4904409,'2133','321',1675625.26,1676649.39,0.00,0.00,1024.13,768097.50,0.00,0.00,0.00),('1','153','763','257724',4904410,'2998','321',248545.84,248771.88,0.00,0.00,226.04,169530.00,0.00,0.00,0.00),('1','153','763','257724',4904411,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257725',4904412,'2132','321',2301845.66,2301931.94,0.00,0.00,86.28,64710.00,0.00,0.00,0.00),('1','153','763','257725',4904413,'2133','321',1676649.39,1677703.88,0.00,0.00,1054.49,790867.50,0.00,0.00,0.00),('1','153','763','257725',4904414,'2998','321',248771.88,248920.71,0.00,0.00,148.83,111622.50,0.00,0.00,0.00),('1','153','763','257725',4904415,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257726',4904416,'2132','321',2301931.94,2301931.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257726',4904417,'2133','321',1677703.88,1677869.90,0.00,0.00,166.02,124515.00,0.00,0.00,0.00),('1','153','763','257726',4904418,'2998','321',248920.71,248920.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257726',4904419,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257727',4904420,'2132','321',2301931.94,2301931.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257727',4904421,'2133','321',1677869.90,1677968.52,0.00,0.00,98.62,73965.00,0.00,0.00,0.00),('1','153','763','257727',4904422,'2998','321',248920.71,248941.32,0.00,0.00,20.61,15457.50,0.00,0.00,0.00),('1','153','763','257727',4904423,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257728',4904424,'2132','321',2301931.94,2302106.94,0.00,0.00,175.00,124250.00,0.00,0.00,0.00),('1','153','763','257728',4904425,'2133','321',1677968.52,1679091.35,0.00,0.00,1122.83,842122.50,0.00,0.00,0.00),('1','153','763','257728',4904426,'2998','321',248941.32,249401.22,0.00,0.00,459.90,344925.00,0.00,0.00,0.00),('1','153','763','257728',4904427,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257729',4904428,'2132','321',2302106.94,2302142.94,0.00,0.00,36.00,25560.00,0.00,0.00,0.00),('1','153','763','257729',4904429,'2133','321',1679091.35,1680259.72,0.00,0.00,1168.37,876277.50,0.00,0.00,0.00),('1','153','763','257729',4904430,'2998','321',249401.22,249777.71,0.00,0.00,376.49,282367.50,0.00,0.00,0.00),('1','153','763','257729',4904431,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257730',4904432,'2132','321',2302142.94,2302142.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257730',4904433,'2133','321',1680259.72,1681234.51,0.00,0.00,974.79,731092.50,0.00,0.00,0.00),('1','153','763','257730',4904434,'2998','321',249777.71,250069.28,0.00,0.00,291.57,218677.50,0.00,0.00,0.00),('1','153','763','257730',4904435,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257731',4904436,'2132','321',2302142.94,2302378.07,0.00,0.00,235.13,166942.30,0.00,0.00,0.00),('1','153','763','257731',4904437,'2133','321',1681234.51,1682515.23,0.00,0.00,1280.72,960540.00,0.00,0.00,0.00),('1','153','763','257731',4904438,'2998','321',250069.28,250173.69,0.00,0.00,104.41,78307.50,0.00,0.00,0.00),('1','153','763','257731',4904439,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257732',4904440,'2132','321',2302378.07,2302678.07,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','153','763','257732',4904441,'2133','321',1682515.23,1684234.17,0.00,0.00,1718.94,1289205.00,0.00,0.00,0.00),('1','153','763','257732',4904442,'2998','321',250173.69,250796.70,0.00,0.00,623.01,467257.50,0.00,0.00,0.00),('1','153','763','257732',4904443,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257733',4904444,'2132','321',2302678.07,2304235.77,0.00,0.00,1557.70,1105967.00,0.00,0.00,0.00),('1','153','763','257733',4904445,'2133','321',1684234.17,1685855.98,0.00,0.00,1621.81,1216357.50,0.00,0.00,0.00),('1','153','763','257733',4904446,'2998','321',250796.70,251365.20,0.00,0.00,568.50,426375.00,0.00,0.00,0.00),('1','153','763','257733',4904447,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257734',4904448,'2132','321',2304235.77,2304286.77,0.00,0.00,51.00,38250.00,0.00,0.00,0.00),('1','153','763','257734',4904449,'2133','321',1685855.98,1686631.93,0.00,0.00,775.95,581962.50,0.00,0.00,0.00),('1','153','763','257734',4904450,'2998','321',251365.20,251599.49,0.00,0.00,234.29,175717.50,0.00,0.00,0.00),('1','153','763','257734',4904451,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257735',4904452,'2132','321',2304286.77,2304286.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257735',4904453,'2133','321',1686631.93,1687888.98,0.00,0.00,1257.05,942787.50,0.00,0.00,0.00),('1','153','763','257735',4904454,'2998','321',251599.49,251842.72,0.00,0.00,243.23,182422.50,0.00,0.00,0.00),('1','153','763','257735',4904455,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257736',4904456,'2132','321',2304286.77,2304432.73,0.00,0.00,145.96,109470.00,0.00,0.00,0.00),('1','153','763','257736',4904457,'2133','321',1687888.98,1688818.69,0.00,0.00,929.71,697282.50,0.00,0.00,0.00),('1','153','763','257736',4904458,'2998','321',251842.72,252438.41,0.00,0.00,595.69,446767.50,0.00,0.00,0.00),('1','153','763','257736',4904459,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257737',4904460,'2132','321',2304432.73,2304432.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257737',4904461,'2133','321',1688818.69,1689931.97,0.00,0.00,1113.28,834960.00,0.00,0.00,0.00),('1','153','763','257737',4904462,'2998','321',252438.41,252687.65,0.00,0.00,249.24,186930.00,0.00,0.00,0.00),('1','153','763','257737',4904463,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257738',4904464,'2132','321',2304432.73,2304563.22,0.00,0.00,130.49,97867.50,0.00,0.00,0.00),('1','153','763','257738',4904465,'2133','321',1689931.97,1690162.61,0.00,0.00,230.64,172980.00,0.00,0.00,0.00),('1','153','763','257738',4904466,'2998','321',252687.65,252816.09,0.00,0.00,128.44,96330.00,0.00,0.00,0.00),('1','153','763','257738',4904467,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257739',4904468,'2132','321',2304563.22,2304563.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257739',4904469,'2133','321',1690162.61,1690536.92,0.00,0.00,374.31,280732.50,0.00,0.00,0.00),('1','153','763','257739',4904470,'2998','321',252816.09,252938.73,0.00,0.00,122.64,91980.00,0.00,0.00,0.00),('1','153','763','257739',4904471,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257740',4904472,'2132','321',2304563.22,2304909.08,0.00,0.00,345.86,259395.00,0.00,0.00,0.00),('1','153','763','257740',4904473,'2133','321',1690536.92,1691020.35,0.00,0.00,483.43,362572.50,0.00,0.00,0.00),('1','153','763','257740',4904474,'2998','321',252938.73,253486.20,0.00,0.00,547.47,410602.50,0.00,0.00,0.00),('1','153','763','257740',4904475,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257741',4904476,'2132','321',2304909.08,2304992.55,0.00,0.00,83.47,62602.50,0.00,0.00,0.00),('1','153','763','257741',4904477,'2133','321',1691020.35,1692409.57,0.00,0.00,1389.22,1041915.00,0.00,0.00,0.00),('1','153','763','257741',4904478,'2998','321',253486.20,253988.71,0.00,0.00,502.51,376882.50,0.00,0.00,0.00),('1','153','763','257741',4904479,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257742',4904480,'2132','321',2304992.55,2305234.08,0.00,0.00,241.53,181147.50,0.00,0.00,0.00),('1','153','763','257742',4904481,'2133','321',1692409.57,1693645.09,0.00,0.00,1235.52,926640.00,0.00,0.00,0.00),('1','153','763','257742',4904482,'2998','321',253988.71,254354.65,0.00,0.00,365.94,274455.00,0.00,0.00,0.00),('1','153','763','257742',4904483,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257743',4904484,'2132','321',2305234.08,2305293.40,0.00,0.00,59.32,44490.00,0.00,0.00,0.00),('1','153','763','257743',4904485,'2133','321',1693645.09,1693926.15,0.00,0.00,281.06,210795.00,0.00,0.00,0.00),('1','153','763','257743',4904486,'2998','321',254354.65,254364.60,0.00,0.00,9.95,7462.50,0.00,0.00,0.00),('1','153','763','257743',4904487,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257744',4904488,'2132','321',2305293.40,2305358.02,0.00,0.00,64.62,48465.00,0.00,0.00,0.00),('1','153','763','257744',4904489,'2133','321',1693926.15,1694549.47,0.00,0.00,623.32,467490.00,0.00,0.00,0.00),('1','153','763','257744',4904490,'2998','321',254364.60,254532.49,0.00,0.00,167.89,125917.50,0.00,0.00,0.00),('1','153','763','257744',4904491,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257745',4904492,'2132','321',2305358.02,2305886.21,0.00,0.00,528.19,396142.50,0.00,0.00,0.00),('1','153','763','257745',4904493,'2133','321',1694549.47,1695122.09,0.00,0.00,572.62,429465.00,0.00,0.00,0.00),('1','153','763','257745',4904494,'2998','321',254532.49,254734.30,0.00,0.00,201.81,151357.50,0.00,0.00,0.00),('1','153','763','257745',4904495,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257746',4904496,'2132','321',2305886.21,2305982.04,0.00,0.00,95.83,71872.50,0.00,0.00,0.00),('1','153','763','257746',4904497,'2133','321',1695122.09,1695904.18,0.00,0.00,782.09,586567.50,0.00,0.00,0.00),('1','153','763','257746',4904498,'2998','321',254734.30,254864.49,0.00,0.00,130.19,97642.50,0.00,0.00,0.00),('1','153','763','257746',4904499,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257747',4904500,'2132','321',2305982.04,2306153.43,0.00,0.00,171.39,128542.50,0.00,0.00,0.00),('1','153','763','257747',4904501,'2133','321',1695904.18,1696702.61,0.00,0.00,798.43,598822.50,0.00,0.00,0.00),('1','153','763','257747',4904502,'2998','321',254864.49,255113.53,0.00,0.00,249.04,186780.00,0.00,0.00,0.00),('1','153','763','257747',4904503,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257748',4904504,'2132','321',2306153.43,2306508.76,0.00,0.00,355.33,266497.50,0.00,0.00,0.00),('1','153','763','257748',4904505,'2133','321',1696702.61,1697915.34,0.00,0.00,1212.73,909547.50,0.00,0.00,0.00),('1','153','763','257748',4904506,'2998','321',255113.53,255207.38,0.00,0.00,93.85,70387.50,0.00,0.00,0.00),('1','153','763','257748',4904507,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257749',4904508,'2132','321',2306508.76,2306593.35,0.00,0.00,84.59,63442.50,0.00,0.00,0.00),('1','153','763','257749',4904509,'2133','321',1697915.34,1698264.71,0.00,0.00,349.37,262027.50,0.00,0.00,0.00),('1','153','763','257749',4904510,'2998','321',255207.38,255349.78,0.00,0.00,142.40,106800.00,0.00,0.00,0.00),('1','153','763','257749',4904511,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257750',4904512,'2132','321',2306593.35,2306695.01,0.00,0.00,101.66,76245.00,0.00,0.00,0.00),('1','153','763','257750',4904513,'2133','321',1698264.71,1699027.32,0.00,0.00,762.61,571957.50,0.00,0.00,0.00),('1','153','763','257750',4904514,'2998','321',255349.78,255510.09,0.00,0.00,160.31,120232.50,0.00,0.00,0.00),('1','153','763','257750',4904515,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257751',4904516,'2132','321',2306695.01,2306942.18,0.00,0.00,247.17,185377.50,0.00,0.00,0.00),('1','153','763','257751',4904517,'2133','321',1699027.32,1699768.19,0.00,0.00,740.87,555652.50,0.00,0.00,0.00),('1','153','763','257751',4904518,'2998','321',255510.09,255743.71,0.00,0.00,233.62,175215.00,0.00,0.00,0.00),('1','153','763','257751',4904519,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257752',4904520,'2132','321',2306942.18,2307142.46,0.00,0.00,200.28,150210.00,0.00,0.00,0.00),('1','153','763','257752',4904521,'2133','321',1699768.19,1700584.44,0.00,0.00,816.25,612187.50,0.00,0.00,0.00),('1','153','763','257752',4904522,'2998','321',255743.71,255904.37,0.00,0.00,160.66,120495.00,0.00,0.00,0.00),('1','153','763','257752',4904523,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257753',4904524,'2132','321',2307142.46,2307428.36,0.00,0.00,285.90,214425.00,0.00,0.00,0.00),('1','153','763','257753',4904525,'2133','321',1700584.44,1701323.86,0.00,0.00,739.42,554565.00,0.00,0.00,0.00),('1','153','763','257753',4904526,'2998','321',255904.37,255982.53,0.00,0.00,78.16,58620.00,0.00,0.00,0.00),('1','153','763','257753',4904527,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257754',4904528,'2132','321',2307428.36,2307616.17,0.00,0.00,187.81,140857.50,0.00,0.00,0.00),('1','153','763','257754',4904529,'2133','321',1701323.86,1701899.10,0.00,0.00,575.24,431430.00,0.00,0.00,0.00),('1','153','763','257754',4904530,'2998','321',255982.53,256090.25,0.00,0.00,107.72,80790.00,0.00,0.00,0.00),('1','153','763','257754',4904531,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257755',4904532,'2132','321',2307616.17,2307718.41,0.00,0.00,102.24,76680.00,0.00,0.00,0.00),('1','153','763','257755',4904533,'2133','321',1701899.10,1702073.72,0.00,0.00,174.62,130965.00,0.00,0.00,0.00),('1','153','763','257755',4904534,'2998','321',256090.25,256117.23,0.00,0.00,26.98,20235.00,0.00,0.00,0.00),('1','153','763','257755',4904535,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257756',4904536,'2132','321',2307718.41,2308282.89,0.00,0.00,564.48,423360.00,0.00,0.00,0.00),('1','153','763','257756',4904537,'2133','321',1702073.72,1702643.31,0.00,0.00,569.59,427192.50,0.00,0.00,0.00),('1','153','763','257756',4904538,'2998','321',256117.23,256208.89,0.00,0.00,91.66,68745.00,0.00,0.00,0.00),('1','153','763','257756',4904539,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257757',4904540,'2132','321',2308282.89,2308600.34,0.00,0.00,317.45,238087.50,0.00,0.00,0.00),('1','153','763','257757',4904541,'2133','321',1702643.31,1703068.76,0.00,0.00,425.45,319087.50,0.00,0.00,0.00),('1','153','763','257757',4904542,'2998','321',256208.89,256596.18,0.00,0.00,387.29,290467.50,0.00,0.00,0.00),('1','153','763','257757',4904543,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257758',4904544,'2132','321',2308600.34,2309146.32,0.00,0.00,545.98,409485.00,0.00,0.00,0.00),('1','153','763','257758',4904545,'2133','321',1703068.76,1703834.04,0.00,0.00,765.28,573960.00,0.00,0.00,0.00),('1','153','763','257758',4904546,'2998','321',256596.18,256791.42,0.00,0.00,195.24,146430.00,0.00,0.00,0.00),('1','153','763','257758',4904547,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257759',4904548,'2132','321',2309146.32,2309590.96,0.00,0.00,444.64,333480.00,0.00,0.00,0.00),('1','153','763','257759',4904549,'2133','321',1703834.04,1704412.71,0.00,0.00,578.67,434002.50,0.00,0.00,0.00),('1','153','763','257759',4904550,'2998','321',256791.42,256992.98,0.00,0.00,201.56,151170.00,0.00,0.00,0.00),('1','153','763','257759',4904551,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257760',4904552,'2132','321',2309590.96,2309755.91,0.00,0.00,164.95,123712.50,0.00,0.00,0.00),('1','153','763','257760',4904553,'2133','321',1704412.71,1704738.83,0.00,0.00,326.12,244590.00,0.00,0.00,0.00),('1','153','763','257760',4904554,'2998','321',256992.98,257047.58,0.00,0.00,54.60,40950.00,0.00,0.00,0.00),('1','153','763','257760',4904555,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257761',4904556,'2132','321',2309755.91,2309922.59,0.00,0.00,166.68,123810.00,0.00,0.00,0.00),('1','153','763','257761',4904557,'2133','321',1704738.83,1705129.80,0.00,0.00,390.97,293227.50,0.00,0.00,0.00),('1','153','763','257761',4904558,'2998','321',257047.58,257243.36,0.00,0.00,195.78,146835.00,0.00,0.00,0.00),('1','153','763','257761',4904559,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257762',4904560,'2132','321',2309922.59,2310468.77,0.00,0.00,546.18,409635.00,0.00,0.00,0.00),('1','153','763','257762',4904561,'2133','321',1705129.80,1705903.35,0.00,0.00,773.55,580162.50,0.00,0.00,0.00),('1','153','763','257762',4904562,'2998','321',257243.36,257572.80,0.00,0.00,329.44,247080.00,0.00,0.00,0.00),('1','153','763','257762',4904563,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257763',4904564,'2132','321',2310468.77,2311138.15,0.00,0.00,669.38,502035.00,0.00,0.00,0.00),('1','153','763','257763',4904565,'2133','321',1705903.35,1707071.24,0.00,0.00,1167.89,875917.50,0.00,0.00,0.00),('1','153','763','257763',4904566,'2998','321',257572.80,257765.74,0.00,0.00,192.94,144705.00,0.00,0.00,0.00),('1','153','763','257763',4904567,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257764',4904568,'2132','321',2311138.15,2311600.99,0.00,0.00,462.84,344730.00,0.00,0.00,0.00),('1','153','763','257764',4904569,'2133','321',1707071.24,1707913.09,0.00,0.00,841.85,631387.50,0.00,0.00,0.00),('1','153','763','257764',4904570,'2998','321',257765.74,257832.33,0.00,0.00,66.59,49942.50,0.00,0.00,0.00),('1','153','763','257764',4904571,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257765',4904572,'2132','321',2311600.99,2311609.51,0.00,0.00,8.52,6390.00,0.00,0.00,0.00),('1','153','763','257765',4904573,'2133','321',1707913.09,1707995.00,0.00,0.00,81.91,61432.50,0.00,0.00,0.00),('1','153','763','257765',4904574,'2998','321',257832.33,257832.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257765',4904575,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257766',4904576,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257766',4904577,'2133','321',1707995.00,1709090.73,0.00,0.00,1095.73,821797.50,0.00,0.00,0.00),('1','153','763','257766',4904578,'2998','321',257832.33,258116.79,0.00,0.00,284.46,213345.00,0.00,0.00,0.00),('1','153','763','257766',4904579,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257767',4904580,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257767',4904581,'2133','321',1709090.73,1709493.13,0.00,0.00,402.40,301800.00,0.00,0.00,0.00),('1','153','763','257767',4904582,'2998','321',258116.79,258492.11,0.00,0.00,375.32,281490.00,0.00,0.00,0.00),('1','153','763','257767',4904583,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257768',4904584,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257768',4904585,'2133','321',1709493.13,1709821.54,0.00,0.00,328.41,246307.50,0.00,0.00,0.00),('1','153','763','257768',4904586,'2998','321',258492.11,258591.05,0.00,0.00,98.94,74205.00,0.00,0.00,0.00),('1','153','763','257768',4904587,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257769',4904588,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257769',4904589,'2133','321',1709821.54,1710912.57,0.00,0.00,1091.03,818272.50,0.00,0.00,0.00),('1','153','763','257769',4904590,'2998','321',258591.05,259283.31,0.00,0.00,692.26,519195.00,0.00,0.00,0.00),('1','153','763','257769',4904591,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257770',4904592,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257770',4904593,'2133','321',1710912.57,1711853.98,0.00,0.00,941.41,706057.50,0.00,0.00,0.00),('1','153','763','257770',4904594,'2998','321',259283.31,259955.13,0.00,0.00,671.82,503865.00,0.00,0.00,0.00),('1','153','763','257770',4904595,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257771',4904596,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257771',4904597,'2133','321',1711853.98,1712362.52,0.00,0.00,508.54,381405.00,0.00,0.00,0.00),('1','153','763','257771',4904598,'2998','321',259955.13,260189.40,0.00,0.00,234.27,175702.50,0.00,0.00,0.00),('1','153','763','257771',4904599,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257772',4904600,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257772',4904601,'2133','321',1712362.52,1712794.40,0.00,0.00,431.88,323910.00,0.00,0.00,0.00),('1','153','763','257772',4904602,'2998','321',260189.40,260223.73,0.00,0.00,34.33,25747.50,0.00,0.00,0.00),('1','153','763','257772',4904603,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257773',4904604,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257773',4904605,'2133','321',1712794.40,1713144.68,0.00,0.00,350.28,262710.00,0.00,0.00,0.00),('1','153','763','257773',4904606,'2998','321',260223.73,260278.11,0.00,0.00,54.38,40785.00,0.00,0.00,0.00),('1','153','763','257773',4904607,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257774',4904608,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257774',4904609,'2133','321',1713144.68,1713575.74,0.00,0.00,431.06,323295.00,0.00,0.00,0.00),('1','153','763','257774',4904610,'2998','321',260278.11,260483.62,0.00,0.00,205.51,154132.50,0.00,0.00,0.00),('1','153','763','257774',4904611,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257775',4904612,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257775',4904613,'2133','321',1713575.74,1714572.25,0.00,0.00,996.51,747382.50,0.00,0.00,0.00),('1','153','763','257775',4904614,'2998','321',260483.62,260674.55,0.00,0.00,190.93,143197.50,0.00,0.00,0.00),('1','153','763','257775',4904615,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257776',4904616,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257776',4904617,'2133','321',1714572.25,1716048.07,0.00,0.00,1475.82,1106865.00,0.00,0.00,0.00),('1','153','763','257776',4904618,'2998','321',260674.55,261235.72,0.00,0.00,561.17,420877.50,0.00,0.00,0.00),('1','153','763','257776',4904619,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257777',4904620,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257777',4904621,'2133','321',1716048.07,1717277.33,0.00,0.00,1229.26,921945.00,0.00,0.00,0.00),('1','153','763','257777',4904622,'2998','321',261235.72,261271.01,0.00,0.00,35.29,26467.50,0.00,0.00,0.00),('1','153','763','257777',4904623,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257778',4904624,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257778',4904625,'2133','321',1717277.33,1718292.96,0.00,0.00,1015.63,761722.50,0.00,0.00,0.00),('1','153','763','257778',4904626,'2998','321',261271.01,261462.68,0.00,0.00,191.67,143752.50,0.00,0.00,0.00),('1','153','763','257778',4904627,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257779',4904628,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257779',4904629,'2133','321',1718292.96,1719311.33,0.00,0.00,1018.37,763777.50,0.00,0.00,0.00),('1','153','763','257779',4904630,'2998','321',261462.68,261844.55,0.00,0.00,381.87,286402.50,0.00,0.00,0.00),('1','153','763','257779',4904631,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257780',4904632,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257780',4904633,'2133','321',1719311.33,1720312.99,0.00,0.00,1001.66,751245.00,0.00,0.00,0.00),('1','153','763','257780',4904634,'2998','321',261844.55,262105.80,0.00,0.00,261.25,195937.50,0.00,0.00,0.00),('1','153','763','257780',4904635,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257781',4904636,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257781',4904637,'2133','321',1720312.99,1721473.95,0.00,0.00,1160.96,870720.00,0.00,0.00,0.00),('1','153','763','257781',4904638,'2998','321',262105.80,262182.42,0.00,0.00,76.62,57465.00,0.00,0.00,0.00),('1','153','763','257781',4904639,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257782',4904640,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257782',4904641,'2133','321',1721473.95,1723659.87,0.00,0.00,2185.92,1639440.00,0.00,0.00,0.00),('1','153','763','257782',4904642,'2998','321',262182.42,262199.02,0.00,0.00,16.60,12450.00,0.00,0.00,0.00),('1','153','763','257782',4904643,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257783',4904644,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257783',4904645,'2133','321',1723659.87,1723805.10,0.00,0.00,145.23,108922.50,0.00,0.00,0.00),('1','153','763','257783',4904646,'2998','321',262199.02,262204.02,0.00,0.00,5.00,3750.00,0.00,0.00,0.00),('1','153','763','257783',4904647,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257784',4904648,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257784',4904649,'2133','321',1723805.10,1725071.65,0.00,0.00,1266.55,949912.50,0.00,0.00,0.00),('1','153','763','257784',4904650,'2998','321',262204.02,262610.80,0.00,0.00,406.78,305085.00,0.00,0.00,0.00),('1','153','763','257784',4904651,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257785',4904652,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257785',4904653,'2133','321',1725071.65,1726054.13,0.00,0.00,982.48,736860.00,0.00,0.00,0.00),('1','153','763','257785',4904654,'2998','321',262610.80,262982.79,0.00,0.00,371.99,278992.50,0.00,0.00,0.00),('1','153','763','257785',4904655,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257786',4904656,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257786',4904657,'2133','321',1726054.13,1727655.01,0.00,0.00,1600.88,1200660.00,0.00,0.00,0.00),('1','153','763','257786',4904658,'2998','321',262982.79,263180.82,0.00,0.00,198.03,148522.50,0.00,0.00,0.00),('1','153','763','257786',4904659,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257787',4904660,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257787',4904661,'2133','321',1727655.01,1728967.61,0.00,0.00,1312.60,984450.00,0.00,0.00,0.00),('1','153','763','257787',4904662,'2998','321',263180.82,263260.03,0.00,0.00,79.21,59407.50,0.00,0.00,0.00),('1','153','763','257787',4904663,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257788',4904664,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257788',4904665,'2133','321',1728967.61,1730278.45,0.00,0.00,1310.84,1022455.20,0.00,0.00,0.00),('1','153','763','257788',4904666,'2998','321',263260.03,263771.25,0.00,0.00,511.22,398751.60,0.00,0.00,0.00),('1','153','763','257788',4904667,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257789',4904668,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257789',4904669,'2133','321',1730278.45,1731788.70,0.00,0.00,1510.25,1177995.00,0.00,0.00,0.00),('1','153','763','257789',4904670,'2998','321',263771.25,264283.16,0.00,0.00,511.91,399289.80,0.00,0.00,0.00),('1','153','763','257789',4904671,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257790',4904672,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257790',4904673,'2133','321',1731788.70,1733571.27,0.00,0.00,1782.57,1390404.60,0.00,0.00,0.00),('1','153','763','257790',4904674,'2998','321',264283.16,264968.97,0.00,0.00,685.81,534931.80,0.00,0.00,0.00),('1','153','763','257790',4904675,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257791',4904676,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257791',4904677,'2133','321',1733571.27,1734043.24,0.00,0.00,471.97,368136.60,0.00,0.00,0.00),('1','153','763','257791',4904678,'2998','321',264968.97,265134.33,0.00,0.00,165.36,128980.80,0.00,0.00,0.00),('1','153','763','257791',4904679,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257792',4904680,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257792',4904681,'2133','321',1734043.24,1736299.91,0.00,0.00,2256.67,1760202.60,0.00,0.00,0.00),('1','153','763','257792',4904682,'2998','321',265134.33,266041.53,0.00,0.00,907.20,707616.00,0.00,0.00,0.00),('1','153','763','257792',4904683,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257793',4904684,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257793',4904685,'2133','321',1736299.91,1738083.67,0.00,0.00,1783.76,1391332.80,0.00,0.00,0.00),('1','153','763','257793',4904686,'2998','321',266041.53,266695.22,0.00,0.00,653.69,509878.20,0.00,0.00,0.00),('1','153','763','257793',4904687,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257794',4904688,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257794',4904689,'2133','321',1738083.67,1738659.21,0.00,0.00,575.54,448921.20,0.00,0.00,0.00),('1','153','763','257794',4904690,'2998','321',266695.22,266890.57,0.00,0.00,195.35,152373.00,0.00,0.00,0.00),('1','153','763','257794',4904691,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257795',4904692,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257795',4904693,'2133','321',1738659.21,1740390.94,0.00,0.00,1731.73,1350749.40,0.00,0.00,0.00),('1','153','763','257795',4904694,'2998','321',266890.57,267586.23,0.00,0.00,695.66,542614.80,0.00,0.00,0.00),('1','153','763','257795',4904695,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257796',4904696,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257796',4904697,'2133','321',1740390.94,1741439.30,0.00,0.00,1048.36,817720.80,0.00,0.00,0.00),('1','153','763','257796',4904698,'2998','321',267586.23,267788.37,0.00,0.00,202.14,157669.20,0.00,0.00,0.00),('1','153','763','257796',4904699,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257797',4904700,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257797',4904701,'2133','321',1741439.30,1743051.84,0.00,0.00,1612.54,1257781.20,0.00,0.00,0.00),('1','153','763','257797',4904702,'2998','321',267788.37,267990.66,0.00,0.00,202.29,157786.20,0.00,0.00,0.00),('1','153','763','257797',4904703,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257798',4904704,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257798',4904705,'2133','321',1743051.84,1744471.40,0.00,0.00,1419.56,1107256.80,0.00,0.00,0.00),('1','153','763','257798',4904706,'2998','321',267990.66,268302.70,0.00,0.00,312.04,243391.20,0.00,0.00,0.00),('1','153','763','257798',4904707,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257799',4904708,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257799',4904709,'2133','321',1744471.40,1745698.67,0.00,0.00,1227.27,957270.60,0.00,0.00,0.00),('1','153','763','257799',4904710,'2998','321',268302.70,268516.80,0.00,0.00,214.10,166998.00,0.00,0.00,0.00),('1','153','763','257799',4904711,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257800',4904712,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257800',4904713,'2133','321',1745698.67,1747387.28,0.00,0.00,1688.61,1317115.80,0.00,0.00,0.00),('1','153','763','257800',4904714,'2998','321',268516.80,268929.33,0.00,0.00,412.53,321773.40,0.00,0.00,0.00),('1','153','763','257800',4904715,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257801',4904716,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257801',4904717,'2133','321',1747387.28,1748388.48,0.00,0.00,1001.20,780936.00,0.00,0.00,0.00),('1','153','763','257801',4904718,'2998','321',268929.33,268929.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257801',4904719,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257802',4904720,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257802',4904721,'2133','321',1748388.48,1748756.32,0.00,0.00,367.84,286915.20,0.00,0.00,0.00),('1','153','763','257802',4904722,'2998','321',268929.33,269045.69,0.00,0.00,116.36,90760.80,0.00,0.00,0.00),('1','153','763','257802',4904723,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257803',4904724,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257803',4904725,'2133','321',1748756.32,1749903.59,0.00,0.00,1147.27,894870.60,0.00,0.00,0.00),('1','153','763','257803',4904726,'2998','321',269045.69,269518.28,0.00,0.00,472.59,368620.20,0.00,0.00,0.00),('1','153','763','257803',4904727,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257804',4904728,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257804',4904729,'2133','321',1749903.59,1751407.58,0.00,0.00,1503.99,1173112.20,0.00,0.00,0.00),('1','153','763','257804',4904730,'2998','321',269518.28,269779.76,0.00,0.00,261.48,203954.40,0.00,0.00,0.00),('1','153','763','257804',4904731,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257805',4904732,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257805',4904733,'2133','321',1751407.58,1752535.41,0.00,0.00,1127.83,879707.40,0.00,0.00,0.00),('1','153','763','257805',4904734,'2998','321',269779.76,270138.27,0.00,0.00,358.51,279637.80,0.00,0.00,0.00),('1','153','763','257805',4904735,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257806',4904736,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257806',4904737,'2133','321',1752535.41,1753589.03,0.00,0.00,1053.62,815387.60,0.00,0.00,0.00),('1','153','763','257806',4904738,'2998','321',270138.27,270451.58,0.00,0.00,313.31,244381.80,0.00,0.00,0.00),('1','153','763','257806',4904739,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257807',4904740,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257807',4904741,'2133','321',1753589.03,1754716.42,0.00,0.00,1127.39,869612.60,0.00,0.00,0.00),('1','153','763','257807',4904742,'2998','321',270451.58,270874.73,0.00,0.00,423.15,330057.00,0.00,0.00,0.00),('1','153','763','257807',4904743,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257808',4904744,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257808',4904745,'2133','321',1754716.42,1756257.18,0.00,0.00,1540.76,1193418.80,0.00,0.00,0.00),('1','153','763','257808',4904746,'2998','321',270874.73,271389.16,0.00,0.00,514.43,401255.40,0.00,0.00,0.00),('1','153','763','257808',4904747,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257809',4904748,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257809',4904749,'2133','321',1756257.18,1756425.46,0.00,0.00,168.28,131258.40,0.00,0.00,0.00),('1','153','763','257809',4904750,'2998','321',271389.16,271391.71,0.00,0.00,2.55,1989.00,0.00,0.00,0.00),('1','153','763','257809',4904751,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257810',4904752,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257810',4904753,'2133','321',1756425.46,1757353.21,0.00,0.00,927.75,713825.00,0.00,0.00,0.00),('1','153','763','257810',4904754,'2998','321',271391.71,271758.99,0.00,0.00,367.28,286478.40,0.00,0.00,0.00),('1','153','763','257810',4904755,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257811',4904756,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257811',4904757,'2133','321',1757353.21,1758626.89,0.00,0.00,1273.68,984590.80,0.00,0.00,0.00),('1','153','763','257811',4904758,'2998','321',271758.99,272071.63,0.00,0.00,312.64,243859.20,0.00,0.00,0.00),('1','153','763','257811',4904759,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257812',4904760,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257812',4904761,'2133','321',1758626.89,1759604.94,0.00,0.00,978.05,751818.20,0.00,0.00,0.00),('1','153','763','257812',4904762,'2998','321',272071.63,272370.58,0.00,0.00,298.95,233181.00,0.00,0.00,0.00),('1','153','763','257812',4904763,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257813',4904764,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257813',4904765,'2133','321',1759604.94,1760908.24,0.00,0.00,1303.30,998292.40,0.00,0.00,0.00),('1','153','763','257813',4904766,'2998','321',272370.58,272672.74,0.00,0.00,302.16,235684.80,0.00,0.00,0.00),('1','153','763','257813',4904767,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257814',4904768,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257814',4904769,'2133','321',1760908.24,1762405.96,0.00,0.00,1497.72,1139580.40,0.00,0.00,0.00),('1','153','763','257814',4904770,'2998','321',272672.74,273108.82,0.00,0.00,436.08,340142.40,0.00,0.00,0.00),('1','153','763','257814',4904771,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257815',4904772,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257815',4904773,'2133','321',1762405.96,1762795.78,0.00,0.00,389.82,296136.80,0.00,0.00,0.00),('1','153','763','257815',4904774,'2998','321',273108.82,273196.25,0.00,0.00,87.43,68195.40,0.00,0.00,0.00),('1','153','763','257815',4904775,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257816',4904776,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257816',4904777,'2133','321',1762795.78,1763580.92,0.00,0.00,785.14,605681.60,0.00,0.00,0.00),('1','153','763','257816',4904778,'2998','321',273196.25,273466.43,0.00,0.00,270.18,210740.40,0.00,0.00,0.00),('1','153','763','257816',4904779,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257817',4904780,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257817',4904781,'2133','321',1763580.92,1764113.10,0.00,0.00,532.18,402800.40,0.00,0.00,0.00),('1','153','763','257817',4904782,'2998','321',273466.43,273696.86,0.00,0.00,230.43,179735.40,0.00,0.00,0.00),('1','153','763','257817',4904783,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257818',4904784,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257818',4904785,'2133','321',1764113.10,1765764.14,0.00,0.00,1651.04,1254158.40,0.00,0.00,0.00),('1','153','763','257818',4904786,'2998','321',273696.86,274206.41,0.00,0.00,509.55,397449.00,0.00,0.00,0.00),('1','153','763','257818',4904787,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257819',4904788,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257819',4904789,'2133','321',1765764.14,1767785.81,0.00,0.00,2021.67,1566806.20,0.00,0.00,0.00),('1','153','763','257819',4904790,'2998','321',274206.41,274298.15,0.00,0.00,91.74,71557.20,0.00,0.00,0.00),('1','153','763','257819',4904791,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257820',4904792,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257820',4904793,'2133','321',1767785.81,1768081.16,0.00,0.00,295.35,227965.56,0.00,0.00,0.00),('1','153','763','257820',4904794,'2998','321',274298.15,274298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257820',4904795,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257821',4904796,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257821',4904797,'2133','321',1768081.16,1769040.48,0.00,0.00,959.32,698114.44,0.00,0.00,0.00),('1','153','763','257821',4904798,'2998','321',274298.15,274298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257821',4904799,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257822',4904800,'2132','321',2311609.51,2311609.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257822',4904801,'2133','321',1769040.48,1769493.70,0.00,0.00,453.22,330995.92,0.00,0.00,0.00),('1','153','763','257822',4904802,'2998','321',274298.15,274304.36,0.00,0.00,6.21,4570.56,0.00,0.00,0.00),('1','153','763','257822',4904803,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257823',4904804,'2132','321',2311609.51,2311646.09,0.00,0.00,36.58,26922.88,0.00,0.00,0.00),('1','153','763','257823',4904805,'2133','321',1769493.70,1771061.45,0.00,0.00,1567.75,1144597.60,0.00,0.00,0.00),('1','153','763','257823',4904806,'2998','321',274304.36,274304.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257823',4904807,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257824',4904808,'2132','321',2311646.09,2311646.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257824',4904809,'2133','321',1771061.45,1771579.84,0.00,0.00,518.39,376719.84,0.00,0.00,0.00),('1','153','763','257824',4904810,'2998','321',274304.36,274373.58,0.00,0.00,69.22,50945.92,0.00,0.00,0.00),('1','153','763','257824',4904811,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257825',4904812,'2132','321',2311646.09,2311646.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257825',4904813,'2133','321',1771579.84,1773591.10,0.00,0.00,2011.26,1468481.02,0.00,0.00,0.00),('1','153','763','257825',4904814,'2998','321',274373.58,274635.65,0.00,0.00,262.07,192883.52,0.00,0.00,0.00),('1','153','763','257825',4904815,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257826',4904816,'2132','321',2311646.09,2311646.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257826',4904817,'2133','321',1773591.10,1775774.27,0.00,0.00,2183.17,1591588.04,0.00,0.00,0.00),('1','153','763','257826',4904818,'2998','321',274635.65,275040.70,0.00,0.00,405.05,298116.80,0.00,0.00,0.00),('1','153','763','257826',4904819,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257827',4904820,'2132','321',2311646.09,2311646.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257827',4904821,'2133','321',1775774.27,1776577.43,0.00,0.00,803.16,589732.42,0.00,0.00,0.00),('1','153','763','257827',4904822,'2998','321',275040.70,275134.00,0.00,0.00,93.30,68668.80,0.00,0.00,0.00),('1','153','763','257827',4904823,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257828',4904824,'2132','321',2311646.09,2311945.91,0.00,0.00,299.82,220667.52,0.00,0.00,0.00),('1','153','763','257828',4904825,'2133','321',1776577.43,1776928.56,0.00,0.00,351.13,251710.16,0.00,0.00,0.00),('1','153','763','257828',4904826,'2998','321',275134.00,275141.88,0.00,0.00,7.88,5799.68,0.00,0.00,0.00),('1','153','763','257828',4904827,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257829',4904828,'2132','321',2311945.91,2313198.10,0.00,0.00,1252.19,919960.84,0.00,0.00,0.00),('1','153','763','257829',4904829,'2133','321',1776928.56,1778875.90,0.00,0.00,1947.34,1414641.32,0.00,0.00,0.00),('1','153','763','257829',4904830,'2998','321',275141.88,275141.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257829',4904831,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257830',4904832,'2132','321',2313198.10,2314153.17,0.00,0.00,955.07,684810.56,0.00,0.00,0.00),('1','153','763','257830',4904833,'2133','321',1778875.90,1780365.92,0.00,0.00,1490.02,1095376.56,0.00,0.00,0.00),('1','153','763','257830',4904834,'2998','321',275141.88,275156.15,0.00,0.00,14.27,10502.72,0.00,0.00,0.00),('1','153','763','257830',4904835,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257831',4904836,'2132','321',2314153.17,2315032.12,0.00,0.00,878.95,636400.60,0.00,0.00,0.00),('1','153','763','257831',4904837,'2133','321',1780365.92,1781098.01,0.00,0.00,732.09,532695.24,0.00,0.00,0.00),('1','153','763','257831',4904838,'2998','321',275156.15,275583.28,0.00,0.00,427.13,314367.68,0.00,0.00,0.00),('1','153','763','257831',4904839,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257832',4904840,'2132','321',2315032.12,2315665.57,0.00,0.00,633.45,449749.50,0.00,0.00,0.00),('1','153','763','257832',4904841,'2133','321',1781098.01,1782602.95,0.00,0.00,1504.94,1107635.84,0.00,0.00,0.00),('1','153','763','257832',4904842,'2998','321',275583.28,275813.46,0.00,0.00,230.18,169412.48,0.00,0.00,0.00),('1','153','763','257832',4904843,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257833',4904844,'2132','321',2315665.57,2316252.32,0.00,0.00,586.75,416592.50,0.00,0.00,0.00),('1','153','763','257833',4904845,'2133','321',1782602.95,1783611.01,0.00,0.00,1008.06,741932.16,0.00,0.00,0.00),('1','153','763','257833',4904846,'2998','321',275813.46,275813.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257833',4904847,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257834',4904848,'2132','321',2316252.32,2316252.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257834',4904849,'2133','321',1783611.01,1784851.95,0.00,0.00,1240.94,901071.02,0.00,0.00,0.00),('1','153','763','257834',4904850,'2998','321',275813.46,276557.33,0.00,0.00,743.87,547488.32,0.00,0.00,0.00),('1','153','763','257834',4904851,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257835',4904852,'2132','321',2316252.32,2316252.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257835',4904853,'2133','321',1784851.95,1784982.31,0.00,0.00,130.36,94488.96,0.00,0.00,0.00),('1','153','763','257835',4904854,'2998','321',276557.33,276557.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257835',4904855,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257836',4904856,'2132','321',2316252.32,2316252.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257836',4904857,'2133','321',1784982.31,1786699.89,0.00,0.00,1717.58,1245734.00,0.00,0.00,0.00),('1','153','763','257836',4904858,'2998','321',276557.33,277134.66,0.00,0.00,577.33,424914.88,0.00,0.00,0.00),('1','153','763','257836',4904859,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257837',4904860,'2132','321',2316252.32,2316874.22,0.00,0.00,621.90,441549.00,0.00,0.00,0.00),('1','153','763','257837',4904861,'2133','321',1786699.89,1788314.25,0.00,0.00,1614.36,1186566.58,0.00,0.00,0.00),('1','153','763','257837',4904862,'2998','321',277134.66,278160.03,0.00,0.00,1025.37,754672.32,0.00,0.00,0.00),('1','153','763','257837',4904863,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257838',4904864,'2132','321',2316874.22,2317186.22,0.00,0.00,312.00,221520.00,0.00,0.00,0.00),('1','153','763','257838',4904865,'2133','321',1788314.25,1788723.69,0.00,0.00,409.44,301347.84,0.00,0.00,0.00),('1','153','763','257838',4904866,'2998','321',278160.03,278160.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257838',4904867,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257839',4904868,'2132','321',2317186.22,2317694.40,0.00,0.00,508.18,360807.80,0.00,0.00,0.00),('1','153','763','257839',4904869,'2133','321',1788723.69,1789224.58,0.00,0.00,500.89,368655.04,0.00,0.00,0.00),('1','153','763','257839',4904870,'2998','321',278160.03,278338.63,0.00,0.00,178.60,131449.60,0.00,0.00,0.00),('1','153','763','257839',4904871,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257840',4904872,'2132','321',2317694.40,2318254.35,0.00,0.00,559.95,399156.22,0.00,0.00,0.00),('1','153','763','257840',4904873,'2133','321',1789224.58,1790280.26,0.00,0.00,1055.68,776980.48,0.00,0.00,0.00),('1','153','763','257840',4904874,'2998','321',278338.63,278622.65,0.00,0.00,284.02,209038.72,0.00,0.00,0.00),('1','153','763','257840',4904875,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257841',4904876,'2132','321',2318254.35,2318835.57,0.00,0.00,581.22,416599.74,0.00,0.00,0.00),('1','153','763','257841',4904877,'2133','321',1790280.26,1791696.89,0.00,0.00,1416.63,1032255.54,0.00,0.00,0.00),('1','153','763','257841',4904878,'2998','321',278622.65,278622.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257841',4904879,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257842',4904880,'2132','321',2318835.57,2319193.45,0.00,0.00,357.88,254094.80,0.00,0.00,0.00),('1','153','763','257842',4904881,'2133','321',1791696.89,1792510.27,0.00,0.00,813.38,598647.68,0.00,0.00,0.00),('1','153','763','257842',4904882,'2998','321',278622.65,278654.45,0.00,0.00,31.80,23404.80,0.00,0.00,0.00),('1','153','763','257842',4904883,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257843',4904884,'2132','321',2319193.45,2320056.31,0.00,0.00,862.86,612630.60,0.00,0.00,0.00),('1','153','763','257843',4904885,'2133','321',1792510.27,1792900.83,0.00,0.00,390.56,284740.10,0.00,0.00,0.00),('1','153','763','257843',4904886,'2998','321',278654.45,278701.36,0.00,0.00,46.91,34525.76,0.00,0.00,0.00),('1','153','763','257843',4904887,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257844',4904888,'2132','321',2320056.31,2321047.38,0.00,0.00,991.07,727864.40,0.00,0.00,0.00),('1','153','763','257844',4904889,'2133','321',1792900.83,1794122.44,0.00,0.00,1221.61,874900.00,0.00,0.00,0.00),('1','153','763','257844',4904890,'2998','321',278701.36,278829.82,0.00,0.00,128.46,94546.56,0.00,0.00,0.00),('1','153','763','257844',4904891,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257845',4904892,'2132','321',2321047.38,2322473.91,0.00,0.00,1426.53,1013336.28,0.00,0.00,0.00),('1','153','763','257845',4904893,'2133','321',1794122.44,1794966.24,0.00,0.00,843.80,619594.32,0.00,0.00,0.00),('1','153','763','257845',4904894,'2998','321',278829.82,278885.73,0.00,0.00,55.91,41149.76,0.00,0.00,0.00),('1','153','763','257845',4904895,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257846',4904896,'2132','321',2322473.91,2322558.62,0.00,0.00,84.71,60656.56,0.00,0.00,0.00),('1','153','763','257846',4904897,'2133','321',1794966.24,1795239.37,0.00,0.00,273.13,201023.68,0.00,0.00,0.00),('1','153','763','257846',4904898,'2998','321',278885.73,278885.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257846',4904899,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257847',4904900,'2132','321',2322558.62,2324201.40,0.00,0.00,1642.78,1173653.80,0.00,0.00,0.00),('1','153','763','257847',4904901,'2133','321',1795239.37,1796203.47,0.00,0.00,964.10,702297.60,0.00,0.00,0.00),('1','153','763','257847',4904902,'2998','321',278885.73,279185.73,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','153','763','257847',4904903,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257848',4904904,'2132','321',2324201.40,2324831.92,0.00,0.00,630.52,447669.20,0.00,0.00,0.00),('1','153','763','257848',4904905,'2133','321',1796203.47,1797288.42,0.00,0.00,1084.95,798523.20,0.00,0.00,0.00),('1','153','763','257848',4904906,'2998','321',279185.73,279433.68,0.00,0.00,247.95,182491.20,0.00,0.00,0.00),('1','153','763','257848',4904907,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257849',4904908,'2132','321',2324831.92,2325427.17,0.00,0.00,595.25,422627.76,0.00,0.00,0.00),('1','153','763','257849',4904909,'2133','321',1797288.42,1798118.10,0.00,0.00,829.68,610644.48,0.00,0.00,0.00),('1','153','763','257849',4904910,'2998','321',279433.68,279433.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257849',4904911,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257850',4904912,'2132','321',2325427.17,2325825.08,0.00,0.00,397.91,282516.10,0.00,0.00,0.00),('1','153','763','257850',4904913,'2133','321',1798118.10,1798427.06,0.00,0.00,308.96,227394.56,0.00,0.00,0.00),('1','153','763','257850',4904914,'2998','321',279433.68,279451.64,0.00,0.00,17.96,13218.56,0.00,0.00,0.00),('1','153','763','257850',4904915,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257851',4904916,'2132','321',2325825.08,2327837.82,0.00,0.00,2012.74,1432492.74,0.00,0.00,0.00),('1','153','763','257851',4904917,'2133','321',1798427.06,1799651.29,0.00,0.00,1224.23,901033.28,0.00,0.00,0.00),('1','153','763','257851',4904918,'2998','321',279451.64,279631.55,0.00,0.00,179.91,132413.76,0.00,0.00,0.00),('1','153','763','257851',4904919,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257852',4904920,'2132','321',2327837.82,2329003.54,0.00,0.00,1165.72,827713.20,0.00,0.00,0.00),('1','153','763','257852',4904921,'2133','321',1799651.29,1800612.75,0.00,0.00,961.46,707634.56,0.00,0.00,0.00),('1','153','763','257852',4904922,'2998','321',279631.55,279631.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257852',4904923,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257853',4904924,'2132','321',2329003.54,2329536.24,0.00,0.00,532.70,378217.00,0.00,0.00,0.00),('1','153','763','257853',4904925,'2133','321',1800612.75,1800867.89,0.00,0.00,255.14,187783.04,0.00,0.00,0.00),('1','153','763','257853',4904926,'2998','321',279631.55,280056.44,0.00,0.00,424.89,301671.90,0.00,0.00,0.00),('1','153','763','257853',4904927,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257854',4904928,'2132','321',2329536.24,2330566.03,0.00,0.00,1029.79,731150.90,0.00,0.00,0.00),('1','153','763','257854',4904929,'2133','321',1800867.89,1801811.80,0.00,0.00,943.91,694717.76,0.00,0.00,0.00),('1','153','763','257854',4904930,'2998','321',280056.44,280819.57,0.00,0.00,763.13,549963.68,0.00,0.00,0.00),('1','153','763','257854',4904931,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257855',4904932,'2132','321',2330566.03,2331603.91,0.00,0.00,1037.88,736894.80,0.00,0.00,0.00),('1','153','763','257855',4904933,'2133','321',1801811.80,1802907.80,0.00,0.00,1096.00,798103.04,0.00,0.00,0.00),('1','153','763','257855',4904934,'2998','321',280819.57,280919.57,0.00,0.00,100.00,73600.00,0.00,0.00,0.00),('1','153','763','257855',4904935,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257856',4904936,'2132','321',2331603.91,2332870.41,0.00,0.00,1266.50,899822.62,0.00,0.00,0.00),('1','153','763','257856',4904937,'2133','321',1802907.80,1804323.19,0.00,0.00,1415.39,1041727.04,0.00,0.00,0.00),('1','153','763','257856',4904938,'2998','321',280919.57,281540.04,0.00,0.00,620.47,442909.32,0.00,0.00,0.00),('1','153','763','257856',4904939,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257857',4904940,'2132','321',2332870.41,2333711.27,0.00,0.00,840.86,600230.96,0.00,0.00,0.00),('1','153','763','257857',4904941,'2133','321',1804323.19,1804992.96,0.00,0.00,669.77,479352.20,0.00,0.00,0.00),('1','153','763','257857',4904942,'2998','321',281540.04,281939.20,0.00,0.00,399.16,293781.76,0.00,0.00,0.00),('1','153','763','257857',4904943,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257858',4904944,'2132','321',2333711.27,2334202.39,0.00,0.00,491.12,352832.32,0.00,0.00,0.00),('1','153','763','257858',4904945,'2133','321',1804992.96,1805335.72,0.00,0.00,342.76,248134.24,0.00,0.00,0.00),('1','153','763','257858',4904946,'2998','321',281939.20,282313.52,0.00,0.00,374.32,265767.20,0.00,0.00,0.00),('1','153','763','257858',4904947,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257859',4904948,'2132','321',2334202.39,2334557.35,0.00,0.00,354.96,252021.60,0.00,0.00,0.00),('1','153','763','257859',4904949,'2133','321',1805335.72,1806641.36,0.00,0.00,1305.64,960951.04,0.00,0.00,0.00),('1','153','763','257859',4904950,'2998','321',282313.52,282476.09,0.00,0.00,162.57,119651.52,0.00,0.00,0.00),('1','153','763','257859',4904951,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257860',4904952,'2132','321',2334557.35,2335041.55,0.00,0.00,484.20,348670.00,0.00,0.00,0.00),('1','153','763','257860',4904953,'2133','321',1806641.36,1808095.28,0.00,0.00,1453.92,1065197.12,0.00,0.00,0.00),('1','153','763','257860',4904954,'2998','321',282476.09,282538.09,0.00,0.00,62.00,44020.00,0.00,0.00,0.00),('1','153','763','257860',4904955,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257861',4904956,'2132','321',2335041.55,2335495.18,0.00,0.00,453.63,322077.30,0.00,0.00,0.00),('1','153','763','257861',4904957,'2133','321',1808095.28,1808856.31,0.00,0.00,761.03,560118.08,0.00,0.00,0.00),('1','153','763','257861',4904958,'2998','321',282538.09,282578.09,0.00,0.00,40.00,29440.00,0.00,0.00,0.00),('1','153','763','257861',4904959,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257862',4904960,'2132','321',2335495.18,2335525.18,0.00,0.00,30.00,21300.00,0.00,0.00,0.00),('1','153','763','257862',4904961,'2133','321',1808856.31,1809147.79,0.00,0.00,291.48,214529.28,0.00,0.00,0.00),('1','153','763','257862',4904962,'2998','321',282578.09,282689.15,0.00,0.00,111.06,81740.16,0.00,0.00,0.00),('1','153','763','257862',4904963,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257863',4904964,'2132','321',2335525.18,2336434.26,0.00,0.00,909.08,645524.54,0.00,0.00,0.00),('1','153','763','257863',4904965,'2133','321',1809147.79,1810602.93,0.00,0.00,1455.14,1070983.04,0.00,0.00,0.00),('1','153','763','257863',4904966,'2998','321',282689.15,282689.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257863',4904967,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257864',4904968,'2132','321',2336434.26,2337125.86,0.00,0.00,691.60,491362.30,0.00,0.00,0.00),('1','153','763','257864',4904969,'2133','321',1810602.93,1812179.09,0.00,0.00,1576.16,1160053.76,0.00,0.00,0.00),('1','153','763','257864',4904970,'2998','321',282689.15,283276.60,0.00,0.00,587.45,421963.20,0.00,0.00,0.00),('1','153','763','257864',4904971,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257865',4904972,'2132','321',2337125.86,2337283.85,0.00,0.00,157.99,113134.90,0.00,0.00,0.00),('1','153','763','257865',4904973,'2133','321',1812179.09,1812524.58,0.00,0.00,345.49,253318.64,0.00,0.00,0.00),('1','153','763','257865',4904974,'2998','321',283276.60,283276.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257865',4904975,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257866',4904976,'2132','321',2337283.85,2337487.38,0.00,0.00,203.53,144506.30,0.00,0.00,0.00),('1','153','763','257866',4904977,'2133','321',1812524.58,1812892.87,0.00,0.00,368.29,271061.44,0.00,0.00,0.00),('1','153','763','257866',4904978,'2998','321',283276.60,283276.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257866',4904979,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257867',4904980,'2132','321',2337487.38,2338037.46,0.00,0.00,550.08,397211.76,0.00,0.00,0.00),('1','153','763','257867',4904981,'2133','321',1812892.87,1814218.61,0.00,0.00,1325.74,975744.64,0.00,0.00,0.00),('1','153','763','257867',4904982,'2998','321',283276.60,283788.35,0.00,0.00,511.75,376648.00,0.00,0.00,0.00),('1','153','763','257867',4904983,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257868',4904984,'2132','321',2338037.46,2338526.12,0.00,0.00,488.66,346948.60,0.00,0.00,0.00),('1','153','763','257868',4904985,'2133','321',1814218.61,1815546.01,0.00,0.00,1327.40,976966.40,0.00,0.00,0.00),('1','153','763','257868',4904986,'2998','321',283788.35,283917.03,0.00,0.00,128.68,94708.48,0.00,0.00,0.00),('1','153','763','257868',4904987,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257869',4904988,'2132','321',2338526.12,2338800.83,0.00,0.00,274.71,195044.10,0.00,0.00,0.00),('1','153','763','257869',4904989,'2133','321',1815546.01,1816599.63,0.00,0.00,1053.62,775464.32,0.00,0.00,0.00),('1','153','763','257869',4904990,'2998','321',283917.03,284008.34,0.00,0.00,91.31,67204.16,0.00,0.00,0.00),('1','153','763','257869',4904991,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257870',4904992,'2132','321',2338800.83,2339235.87,0.00,0.00,435.04,308878.40,0.00,0.00,0.00),('1','153','763','257870',4904993,'2133','321',1816599.63,1817284.63,0.00,0.00,685.00,504160.00,0.00,0.00,0.00),('1','153','763','257870',4904994,'2998','321',284008.34,284058.34,0.00,0.00,50.00,36800.00,0.00,0.00,0.00),('1','153','763','257870',4904995,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257871',4904996,'2132','321',2339235.87,2339641.02,0.00,0.00,405.15,288786.72,0.00,0.00,0.00),('1','153','763','257871',4904997,'2133','321',1817284.63,1817962.21,0.00,0.00,677.58,498698.88,0.00,0.00,0.00),('1','153','763','257871',4904998,'2998','321',284058.34,284185.49,0.00,0.00,127.15,93582.40,0.00,0.00,0.00),('1','153','763','257871',4904999,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257872',4905000,'2132','321',2339641.02,2340160.02,0.00,0.00,519.00,369761.66,0.00,0.00,0.00),('1','153','763','257872',4905001,'2133','321',1817962.21,1819720.86,0.00,0.00,1758.65,1291454.40,0.00,0.00,0.00),('1','153','763','257872',4905002,'2998','321',284185.49,284528.55,0.00,0.00,343.06,252492.16,0.00,0.00,0.00),('1','153','763','257872',4905003,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257873',4905004,'2132','321',2340160.02,2341263.10,0.00,0.00,1103.08,783186.80,0.00,0.00,0.00),('1','153','763','257873',4905005,'2133','321',1819720.86,1820897.01,0.00,0.00,1176.15,865646.40,0.00,0.00,0.00),('1','153','763','257873',4905006,'2998','321',284528.55,284771.39,0.00,0.00,242.84,178730.24,0.00,0.00,0.00),('1','153','763','257873',4905007,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257874',4905008,'2132','321',2341263.10,2341607.13,0.00,0.00,344.03,245639.30,0.00,0.00,0.00),('1','153','763','257874',4905009,'2133','321',1820897.01,1821621.90,0.00,0.00,724.89,530841.04,0.00,0.00,0.00),('1','153','763','257874',4905010,'2998','321',284771.39,284879.44,0.00,0.00,108.05,79524.80,0.00,0.00,0.00),('1','153','763','257874',4905011,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257875',4905012,'2132','321',2341607.13,2341927.15,0.00,0.00,320.02,231356.00,0.00,0.00,0.00),('1','153','763','257875',4905013,'2133','321',1821621.90,1822023.45,0.00,0.00,401.55,291640.80,0.00,0.00,0.00),('1','153','763','257875',4905014,'2998','321',284879.44,285002.58,0.00,0.00,123.14,90631.04,0.00,0.00,0.00),('1','153','763','257875',4905015,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257876',4905016,'2132','321',2341927.15,2342801.26,0.00,0.00,874.11,624347.80,0.00,0.00,0.00),('1','153','763','257876',4905017,'2133','321',1822023.45,1823700.20,0.00,0.00,1676.75,1234088.00,0.00,0.00,0.00),('1','153','763','257876',4905018,'2998','321',285002.58,285147.63,0.00,0.00,145.05,106756.80,0.00,0.00,0.00),('1','153','763','257876',4905019,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257877',4905020,'2132','321',2342801.26,2343695.93,0.00,0.00,894.67,635215.70,0.00,0.00,0.00),('1','153','763','257877',4905021,'2133','321',1823700.20,1825235.98,0.00,0.00,1535.78,1130191.08,0.00,0.00,0.00),('1','153','763','257877',4905022,'2998','321',285147.63,285375.55,0.00,0.00,227.92,167749.12,0.00,0.00,0.00),('1','153','763','257877',4905023,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257878',4905024,'2132','321',2343695.93,2344352.60,0.00,0.00,656.67,466628.56,0.00,0.00,0.00),('1','153','763','257878',4905025,'2133','321',1825235.98,1826470.47,0.00,0.00,1234.49,905464.64,0.00,0.00,0.00),('1','153','763','257878',4905026,'2998','321',285375.55,285766.34,0.00,0.00,390.79,287621.44,0.00,0.00,0.00),('1','153','763','257878',4905027,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257879',4905028,'2132','321',2344352.60,2344620.33,0.00,0.00,267.73,190349.86,0.00,0.00,0.00),('1','153','763','257879',4905029,'2133','321',1826470.47,1828003.56,0.00,0.00,1533.09,1120318.68,0.00,0.00,0.00),('1','153','763','257879',4905030,'2998','321',285766.34,286200.31,0.00,0.00,433.97,315177.44,0.00,0.00,0.00),('1','153','763','257879',4905031,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257880',4905032,'2132','321',2344620.33,2344620.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257880',4905033,'2133','321',1828003.56,1829262.46,0.00,0.00,1258.90,905750.40,0.00,0.00,0.00),('1','153','763','257880',4905034,'2998','321',286200.31,286624.34,0.00,0.00,424.03,307798.68,0.00,0.00,0.00),('1','153','763','257880',4905035,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257881',4905036,'2132','321',2344620.33,2345167.76,0.00,0.00,547.43,392513.94,0.00,0.00,0.00),('1','153','763','257881',4905037,'2133','321',1829262.46,1830524.64,0.00,0.00,1262.18,913022.58,0.00,0.00,0.00),('1','153','763','257881',4905038,'2998','321',286624.34,287388.25,0.00,0.00,763.91,554416.96,0.00,0.00,0.00),('1','153','763','257881',4905039,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257882',4905040,'2132','321',2345167.76,2345720.48,0.00,0.00,552.72,393366.68,0.00,0.00,0.00),('1','153','763','257882',4905041,'2133','321',1830524.64,1831743.30,0.00,0.00,1218.66,890199.76,0.00,0.00,0.00),('1','153','763','257882',4905042,'2998','321',287388.25,287668.35,0.00,0.00,280.10,206153.60,0.00,0.00,0.00),('1','153','763','257882',4905043,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257883',4905044,'2132','321',2345720.48,2345720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257883',4905045,'2133','321',1831743.30,1832174.11,0.00,0.00,430.81,311865.76,0.00,0.00,0.00),('1','153','763','257883',4905046,'2998','321',287668.35,287729.40,0.00,0.00,61.05,44672.80,0.00,0.00,0.00),('1','153','763','257883',4905047,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257884',4905048,'2132','321',2345720.48,2345720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257884',4905049,'2133','321',1832174.11,1833142.75,0.00,0.00,968.64,705723.80,0.00,0.00,0.00),('1','153','763','257884',4905050,'2998','321',287729.40,287733.17,0.00,0.00,3.77,2774.72,0.00,0.00,0.00),('1','153','763','257884',4905051,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257885',4905052,'2132','321',2345720.48,2345720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257885',4905053,'2133','321',1833142.75,1834341.94,0.00,0.00,1199.19,864928.00,0.00,0.00,0.00),('1','153','763','257885',4905054,'2998','321',287733.17,288175.64,0.00,0.00,442.47,321506.24,0.00,0.00,0.00),('1','153','763','257885',4905055,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257886',4905056,'2132','321',2345720.48,2345720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257886',4905057,'2133','321',1834341.94,1835844.07,0.00,0.00,1502.13,1082160.40,0.00,0.00,0.00),('1','153','763','257886',4905058,'2998','321',288175.64,288872.23,0.00,0.00,696.59,506190.24,0.00,0.00,0.00),('1','153','763','257886',4905059,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257887',4905060,'2132','321',2345720.48,2345720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257887',4905061,'2133','321',1835844.07,1836852.46,0.00,0.00,1008.39,729510.18,0.00,0.00,0.00),('1','153','763','257887',4905062,'2998','321',288872.23,289000.48,0.00,0.00,128.25,94392.00,0.00,0.00,0.00),('1','153','763','257887',4905063,'2999','321',15552.79,15552.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257888',4905064,'2132','321',2345720.48,2346181.58,0.00,0.00,461.10,338485.60,0.00,0.00,0.00),('1','153','763','257888',4905065,'2133','321',1836852.46,1837250.68,0.00,0.00,398.22,293089.92,0.00,0.00,0.00),('1','153','763','257888',4905066,'2998','321',289000.48,289253.20,0.00,0.00,252.72,186001.92,0.00,0.00,0.00),('1','153','763','257888',4905067,'2999','321',15552.79,15616.11,0.00,0.00,63.32,45982.38,0.00,0.00,0.00),('1','153','763','257889',4905068,'2132','321',2346181.58,2346748.72,0.00,0.00,567.14,405178.66,0.00,0.00,0.00),('1','153','763','257889',4905069,'2133','321',1837250.68,1838321.71,0.00,0.00,1071.03,788278.08,0.00,0.00,0.00),('1','153','763','257889',4905070,'2998','321',289253.20,289359.95,0.00,0.00,106.75,78568.00,0.00,0.00,0.00),('1','153','763','257889',4905071,'2999','321',15616.11,15650.10,0.00,0.00,33.99,25016.64,0.00,0.00,0.00),('1','153','763','257890',4905072,'2132','321',2346748.72,2346925.42,0.00,0.00,176.70,129739.20,0.00,0.00,0.00),('1','153','763','257890',4905073,'2133','321',1838321.71,1839005.78,0.00,0.00,684.07,502653.40,0.00,0.00,0.00),('1','153','763','257890',4905074,'2998','321',289359.95,289723.52,0.00,0.00,363.57,266112.54,0.00,0.00,0.00),('1','153','763','257890',4905075,'2999','321',15650.10,16000.71,0.00,0.00,350.61,256063.60,0.00,0.00,0.00),('1','153','763','257891',4905076,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257891',4905077,'2133','321',1839005.78,1839805.48,0.00,0.00,799.70,582812.40,0.00,0.00,0.00),('1','153','763','257891',4905078,'2998','321',289723.52,289862.91,0.00,0.00,139.39,102591.04,0.00,0.00,0.00),('1','153','763','257891',4905079,'2999','321',16000.71,16277.77,0.00,0.00,277.06,203824.64,0.00,0.00,0.00),('1','153','763','257892',4905080,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257892',4905081,'2133','321',1839805.48,1840410.83,0.00,0.00,605.35,435638.36,0.00,0.00,0.00),('1','153','763','257892',4905082,'2998','321',289862.91,290150.87,0.00,0.00,287.96,211938.56,0.00,0.00,0.00),('1','153','763','257892',4905083,'2999','321',16277.77,16277.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257893',4905084,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257893',4905085,'2133','321',1840410.83,1840745.93,0.00,0.00,335.10,240531.40,0.00,0.00,0.00),('1','153','763','257893',4905086,'2998','321',290150.87,290369.20,0.00,0.00,218.33,160690.88,0.00,0.00,0.00),('1','153','763','257893',4905087,'2999','321',16277.77,16277.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257894',4905088,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257894',4905089,'2133','321',1840745.93,1841754.37,0.00,0.00,1008.44,733475.84,0.00,0.00,0.00),('1','153','763','257894',4905090,'2998','321',290369.20,290679.55,0.00,0.00,310.35,227689.60,0.00,0.00,0.00),('1','153','763','257894',4905091,'2999','321',16277.77,17075.72,0.00,0.00,797.95,583302.28,0.00,0.00,0.00),('1','153','763','257895',4905092,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257895',4905093,'2133','321',1841754.37,1842888.02,0.00,0.00,1133.65,827022.70,0.00,0.00,0.00),('1','153','763','257895',4905094,'2998','321',290679.55,290762.05,0.00,0.00,82.50,60720.00,0.00,0.00,0.00),('1','153','763','257895',4905095,'2999','321',17075.72,17075.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257896',4905096,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257896',4905097,'2133','321',1842888.02,1843110.45,0.00,0.00,222.43,162671.86,0.00,0.00,0.00),('1','153','763','257896',4905098,'2998','321',290762.05,290922.97,0.00,0.00,160.92,118437.12,0.00,0.00,0.00),('1','153','763','257896',4905099,'2999','321',17075.72,17273.27,0.00,0.00,197.55,145396.80,0.00,0.00,0.00),('1','153','763','257897',4905100,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257897',4905101,'2133','321',1843110.45,1844378.61,0.00,0.00,1268.16,926527.76,0.00,0.00,0.00),('1','153','763','257897',4905102,'2998','321',290922.97,291139.49,0.00,0.00,216.52,159358.72,0.00,0.00,0.00),('1','153','763','257897',4905103,'2999','321',17273.27,17361.89,0.00,0.00,88.62,65102.12,0.00,0.00,0.00),('1','153','763','257898',4905104,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257898',4905105,'2133','321',1844378.61,1845089.54,0.00,0.00,710.93,517124.86,0.00,0.00,0.00),('1','153','763','257898',4905106,'2998','321',291139.49,291476.86,0.00,0.00,337.37,243364.32,0.00,0.00,0.00),('1','153','763','257898',4905107,'2999','321',17361.89,18060.20,0.00,0.00,698.31,508756.16,0.00,0.00,0.00),('1','153','763','257899',4905108,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257899',4905109,'2133','321',1845089.54,1846453.08,0.00,0.00,1363.54,985966.04,0.00,0.00,0.00),('1','153','763','257899',4905110,'2998','321',291476.86,291715.77,0.00,0.00,238.91,174251.76,0.00,0.00,0.00),('1','153','763','257899',4905111,'2999','321',18060.20,18250.98,0.00,0.00,190.78,139114.34,0.00,0.00,0.00),('1','153','763','257900',4905112,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257900',4905113,'2133','321',1846453.08,1847357.92,0.00,0.00,904.84,659508.00,0.00,0.00,0.00),('1','153','763','257900',4905114,'2998','321',291715.77,292019.03,0.00,0.00,303.26,222463.30,0.00,0.00,0.00),('1','153','763','257900',4905115,'2999','321',18250.98,19157.96,0.00,0.00,906.98,664417.28,0.00,0.00,0.00),('1','153','763','257901',4905116,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257901',4905117,'2133','321',1847357.92,1847754.93,0.00,0.00,397.01,290303.96,0.00,0.00,0.00),('1','153','763','257901',4905118,'2998','321',292019.03,292134.28,0.00,0.00,115.25,84824.00,0.00,0.00,0.00),('1','153','763','257901',4905119,'2999','321',19157.96,19218.95,0.00,0.00,60.99,44888.64,0.00,0.00,0.00),('1','153','763','257902',4905120,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257902',4905121,'2133','321',1847754.93,1847963.22,0.00,0.00,208.29,152552.38,0.00,0.00,0.00),('1','153','763','257902',4905122,'2998','321',292134.28,292134.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257902',4905123,'2999','321',19218.95,19418.52,0.00,0.00,199.57,144553.66,0.00,0.00,0.00),('1','153','763','257903',4905124,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257903',4905125,'2133','321',1847963.22,1849486.86,0.00,0.00,1523.64,1116108.30,0.00,0.00,0.00),('1','153','763','257903',4905126,'2998','321',292134.28,292310.83,0.00,0.00,176.55,129940.80,0.00,0.00,0.00),('1','153','763','257903',4905127,'2999','321',19418.52,19479.16,0.00,0.00,60.64,44631.04,0.00,0.00,0.00),('1','153','763','257904',4905128,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257904',4905129,'2133','321',1849486.86,1849965.43,0.00,0.00,478.57,345714.78,0.00,0.00,0.00),('1','153','763','257904',4905130,'2998','321',292310.83,292911.68,0.00,0.00,600.85,440815.36,0.00,0.00,0.00),('1','153','763','257904',4905131,'2999','321',19479.16,20064.51,0.00,0.00,585.35,429517.60,0.00,0.00,0.00),('1','153','763','257905',4905132,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257905',4905133,'2133','321',1849965.43,1851396.26,0.00,0.00,1430.83,1041839.90,0.00,0.00,0.00),('1','153','763','257905',4905134,'2998','321',292911.68,293002.96,0.00,0.00,91.28,67182.08,0.00,0.00,0.00),('1','153','763','257905',4905135,'2999','321',20064.51,20187.17,0.00,0.00,122.66,90277.76,0.00,0.00,0.00),('1','153','763','257906',4905136,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257906',4905137,'2133','321',1851396.26,1852767.94,0.00,0.00,1371.68,1007799.14,0.00,0.00,0.00),('1','153','763','257906',4905138,'2998','321',293002.96,293201.67,0.00,0.00,198.71,144355.42,0.00,0.00,0.00),('1','153','763','257906',4905139,'2999','321',20187.17,21458.01,0.00,0.00,1270.84,935338.24,0.00,0.00,0.00),('1','153','763','257907',4905140,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257907',4905141,'2133','321',1852767.94,1853158.80,0.00,0.00,390.86,277510.60,0.00,0.00,0.00),('1','153','763','257907',4905142,'2998','321',293201.67,293884.86,0.00,0.00,683.19,502827.84,0.00,0.00,0.00),('1','153','763','257907',4905143,'2999','321',21458.01,22384.88,0.00,0.00,926.87,682176.32,0.00,0.00,0.00),('1','153','763','257908',4905144,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257908',4905145,'2133','321',1853158.80,1853212.57,0.00,0.00,53.77,38456.72,0.00,0.00,0.00),('1','153','763','257908',4905146,'2998','321',293884.86,294646.57,0.00,0.00,761.71,560618.56,0.00,0.00,0.00),('1','153','763','257908',4905147,'2999','321',22384.88,23891.08,0.00,0.00,1506.20,1108563.20,0.00,0.00,0.00),('1','153','763','257909',4905148,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257909',4905149,'2133','321',1853212.57,1853322.57,0.00,0.00,110.00,78100.00,0.00,0.00,0.00),('1','153','763','257909',4905150,'2998','321',294646.57,295798.77,0.00,0.00,1152.20,848019.20,0.00,0.00,0.00),('1','153','763','257909',4905151,'2999','321',23891.08,24576.68,0.00,0.00,685.60,504601.60,0.00,0.00,0.00),('1','153','763','257910',4905152,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257910',4905153,'2133','321',1853322.57,1853361.55,0.00,0.00,38.98,28689.28,0.00,0.00,0.00),('1','153','763','257910',4905154,'2998','321',295798.77,296587.91,0.00,0.00,789.14,580807.04,0.00,0.00,0.00),('1','153','763','257910',4905155,'2999','321',24576.68,25630.59,0.00,0.00,1053.91,774664.02,0.00,0.00,0.00),('1','153','763','257911',4905156,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257911',4905157,'2133','321',1853361.55,1853820.05,0.00,0.00,458.50,325535.00,0.00,0.00,0.00),('1','153','763','257911',4905158,'2998','321',296587.91,297479.27,0.00,0.00,891.36,656040.96,0.00,0.00,0.00),('1','153','763','257911',4905159,'2999','321',25630.59,26380.63,0.00,0.00,750.04,552029.44,0.00,0.00,0.00),('1','153','763','257912',4905160,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257912',4905161,'2133','321',1853820.05,1854305.96,0.00,0.00,485.91,349155.58,0.00,0.00,0.00),('1','153','763','257912',4905162,'2998','321',297479.27,298112.57,0.00,0.00,633.30,466108.80,0.00,0.00,0.00),('1','153','763','257912',4905163,'2999','321',26380.63,27096.68,0.00,0.00,716.05,522852.80,0.00,0.00,0.00),('1','153','763','257913',4905164,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257913',4905165,'2133','321',1854305.96,1855235.38,0.00,0.00,929.42,659888.20,0.00,0.00,0.00),('1','153','763','257913',4905166,'2998','321',298112.57,298590.11,0.00,0.00,477.54,351469.44,0.00,0.00,0.00),('1','153','763','257913',4905167,'2999','321',27096.68,27659.79,0.00,0.00,563.11,414448.96,0.00,0.00,0.00),('1','153','763','257914',4905168,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257914',4905169,'2133','321',1855235.38,1855235.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257914',4905170,'2998','321',298590.11,298801.96,0.00,0.00,211.85,155921.60,0.00,0.00,0.00),('1','153','763','257914',4905171,'2999','321',27659.79,27827.46,0.00,0.00,167.67,123405.12,0.00,0.00,0.00),('1','153','763','257915',4905172,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257915',4905173,'2133','321',1855235.38,1855316.30,0.00,0.00,80.92,58257.12,0.00,0.00,0.00),('1','153','763','257915',4905174,'2998','321',298801.96,298943.52,0.00,0.00,141.56,103383.46,0.00,0.00,0.00),('1','153','763','257915',4905175,'2999','321',27827.46,28016.36,0.00,0.00,188.90,139030.40,0.00,0.00,0.00),('1','153','763','257916',4905176,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257916',4905177,'2133','321',1855316.30,1855658.68,0.00,0.00,342.38,243089.80,0.00,0.00,0.00),('1','153','763','257916',4905178,'2998','321',298943.52,299357.99,0.00,0.00,414.47,305049.92,0.00,0.00,0.00),('1','153','763','257916',4905179,'2999','321',28016.36,28619.21,0.00,0.00,602.85,443697.60,0.00,0.00,0.00),('1','153','763','257917',4905180,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257917',4905181,'2133','321',1855658.68,1855787.18,0.00,0.00,128.50,94576.00,0.00,0.00,0.00),('1','153','763','257917',4905182,'2998','321',299357.99,300079.48,0.00,0.00,721.49,531016.64,0.00,0.00,0.00),('1','153','763','257917',4905183,'2999','321',28619.21,29400.20,0.00,0.00,780.99,571467.64,0.00,0.00,0.00),('1','153','763','257918',4905184,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257918',4905185,'2133','321',1855787.18,1856507.18,0.00,0.00,720.00,511200.00,0.00,0.00,0.00),('1','153','763','257918',4905186,'2998','321',300079.48,300752.05,0.00,0.00,672.57,495011.52,0.00,0.00,0.00),('1','153','763','257918',4905187,'2999','321',29400.20,30461.74,0.00,0.00,1061.54,781293.44,0.00,0.00,0.00),('1','153','763','257919',4905188,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257919',4905189,'2133','321',1856507.18,1856544.67,0.00,0.00,37.49,26617.90,0.00,0.00,0.00),('1','153','763','257919',4905190,'2998','321',300752.05,300918.87,0.00,0.00,166.82,122779.52,0.00,0.00,0.00),('1','153','763','257919',4905191,'2999','321',30461.74,30669.58,0.00,0.00,207.84,152970.24,0.00,0.00,0.00),('1','153','763','257920',4905192,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257920',4905193,'2133','321',1856544.67,1856556.88,0.00,0.00,12.21,8986.56,0.00,0.00,0.00),('1','153','763','257920',4905194,'2998','321',300918.87,301205.80,0.00,0.00,286.93,210862.76,0.00,0.00,0.00),('1','153','763','257920',4905195,'2999','321',30669.58,31147.00,0.00,0.00,477.42,351381.12,0.00,0.00,0.00),('1','153','763','257921',4905196,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257921',4905197,'2133','321',1856556.88,1856785.88,0.00,0.00,229.00,162590.00,0.00,0.00,0.00),('1','153','763','257921',4905198,'2998','321',301205.80,301663.13,0.00,0.00,457.33,336594.88,0.00,0.00,0.00),('1','153','763','257921',4905199,'2999','321',31147.00,31947.24,0.00,0.00,800.24,588976.64,0.00,0.00,0.00),('1','153','763','257922',4905200,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257922',4905201,'2133','321',1856785.88,1856785.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257922',4905202,'2998','321',301663.13,302280.27,0.00,0.00,617.14,454215.04,0.00,0.00,0.00),('1','153','763','257922',4905203,'2999','321',31947.24,32791.61,0.00,0.00,844.37,621456.32,0.00,0.00,0.00),('1','153','763','257923',4905204,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257923',4905205,'2133','321',1856785.88,1857008.89,0.00,0.00,223.01,158337.10,0.00,0.00,0.00),('1','153','763','257923',4905206,'2998','321',302280.27,302820.24,0.00,0.00,539.97,397417.92,0.00,0.00,0.00),('1','153','763','257923',4905207,'2999','321',32791.61,33705.84,0.00,0.00,914.23,672873.28,0.00,0.00,0.00),('1','153','763','257924',4905208,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257924',4905209,'2133','321',1857008.89,1857020.88,0.00,0.00,11.99,8618.98,0.00,0.00,0.00),('1','153','763','257924',4905210,'2998','321',302820.24,303110.92,0.00,0.00,290.68,213628.48,0.00,0.00,0.00),('1','153','763','257924',4905211,'2999','321',33705.84,34267.11,0.00,0.00,561.27,413094.72,0.00,0.00,0.00),('1','153','763','257925',4905212,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257925',4905213,'2133','321',1857020.88,1857036.30,0.00,0.00,15.42,11349.12,0.00,0.00,0.00),('1','153','763','257925',4905214,'2998','321',303110.92,303373.34,0.00,0.00,262.42,193141.12,0.00,0.00,0.00),('1','153','763','257925',4905215,'2999','321',34267.11,34643.06,0.00,0.00,375.95,276296.46,0.00,0.00,0.00),('1','153','763','257926',4905216,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257926',4905217,'2133','321',1857036.30,1857265.38,0.00,0.00,229.08,162646.80,0.00,0.00,0.00),('1','153','763','257926',4905218,'2998','321',303373.34,303928.10,0.00,0.00,554.76,408303.36,0.00,0.00,0.00),('1','153','763','257926',4905219,'2999','321',34643.06,35581.28,0.00,0.00,938.22,690529.92,0.00,0.00,0.00),('1','153','763','257927',4905220,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257927',4905221,'2133','321',1857265.38,1857305.37,0.00,0.00,39.99,29432.64,0.00,0.00,0.00),('1','153','763','257927',4905222,'2998','321',303928.10,304627.12,0.00,0.00,699.02,514153.72,0.00,0.00,0.00),('1','153','763','257927',4905223,'2999','321',35581.28,36637.01,0.00,0.00,1055.73,776304.10,0.00,0.00,0.00),('1','153','763','257928',4905224,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257928',4905225,'2133','321',1857305.37,1857471.35,0.00,0.00,165.98,117845.80,0.00,0.00,0.00),('1','153','763','257928',4905226,'2998','321',304627.12,305294.24,0.00,0.00,667.12,491000.32,0.00,0.00,0.00),('1','153','763','257928',4905227,'2999','321',36637.01,37645.94,0.00,0.00,1008.93,742572.48,0.00,0.00,0.00),('1','153','763','257929',4905228,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257929',4905229,'2133','321',1857471.35,1857530.03,0.00,0.00,58.68,42858.80,0.00,0.00,0.00),('1','153','763','257929',4905230,'2998','321',305294.24,305851.71,0.00,0.00,557.47,409101.92,0.00,0.00,0.00),('1','153','763','257929',4905231,'2999','321',37645.94,38408.71,0.00,0.00,762.77,561398.72,0.00,0.00,0.00),('1','153','763','257930',4905232,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257930',4905233,'2133','321',1857530.03,1857715.69,0.00,0.00,185.66,131818.60,0.00,0.00,0.00),('1','153','763','257930',4905234,'2998','321',305851.71,306345.85,0.00,0.00,494.14,363687.04,0.00,0.00,0.00),('1','153','763','257930',4905235,'2999','321',38408.71,39305.54,0.00,0.00,896.83,660066.88,0.00,0.00,0.00),('1','153','763','257931',4905236,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257931',4905237,'2133','321',1857715.69,1857854.04,0.00,0.00,138.35,100448.12,0.00,0.00,0.00),('1','153','763','257931',4905238,'2998','321',306345.85,306943.00,0.00,0.00,597.15,438735.66,0.00,0.00,0.00),('1','153','763','257931',4905239,'2999','321',39305.54,40357.71,0.00,0.00,1052.17,772941.12,0.00,0.00,0.00),('1','153','763','257932',4905240,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257932',4905241,'2133','321',1857854.04,1857970.30,0.00,0.00,116.26,82544.60,0.00,0.00,0.00),('1','153','763','257932',4905242,'2998','321',306943.00,307452.43,0.00,0.00,509.43,374940.48,0.00,0.00,0.00),('1','153','763','257932',4905243,'2999','321',40357.71,41273.33,0.00,0.00,915.62,673896.32,0.00,0.00,0.00),('1','153','763','257933',4905244,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257933',4905245,'2133','321',1857970.30,1858007.30,0.00,0.00,37.00,27128.00,0.00,0.00,0.00),('1','153','763','257933',4905246,'2998','321',307452.43,307987.03,0.00,0.00,534.60,392607.60,0.00,0.00,0.00),('1','153','763','257933',4905247,'2999','321',41273.33,42059.05,0.00,0.00,785.72,578289.92,0.00,0.00,0.00),('1','153','763','257934',4905248,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257934',4905249,'2133','321',1858007.30,1858196.59,0.00,0.00,189.29,134395.90,0.00,0.00,0.00),('1','153','763','257934',4905250,'2998','321',307987.03,308332.25,0.00,0.00,345.22,254081.92,0.00,0.00,0.00),('1','153','763','257934',4905251,'2999','321',42059.05,42886.29,0.00,0.00,827.24,608848.64,0.00,0.00,0.00),('1','153','763','257935',4905252,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257935',4905253,'2133','321',1858196.59,1858300.09,0.00,0.00,103.50,74213.00,0.00,0.00,0.00),('1','153','763','257935',4905254,'2998','321',308332.25,308795.19,0.00,0.00,462.94,339995.84,0.00,0.00,0.00),('1','153','763','257935',4905255,'2999','321',42886.29,43408.58,0.00,0.00,522.29,384405.44,0.00,0.00,0.00),('1','153','763','257936',4905256,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257936',4905257,'2133','321',1858300.09,1858389.19,0.00,0.00,89.10,62370.00,0.00,0.00,0.00),('1','153','763','257936',4905258,'2998','321',308795.19,309030.27,0.00,0.00,235.08,170668.08,0.00,0.00,0.00),('1','153','763','257936',4905259,'2999','321',43408.58,43900.53,0.00,0.00,491.95,357155.70,0.00,0.00,0.00),('1','153','763','257937',4905260,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257937',4905261,'2133','321',1858389.19,1858389.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257937',4905262,'2998','321',309030.27,309292.91,0.00,0.00,262.64,190676.64,0.00,0.00,0.00),('1','153','763','257937',4905263,'2999','321',43900.53,44387.20,0.00,0.00,486.67,353322.42,0.00,0.00,0.00),('1','153','763','257938',4905264,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257938',4905265,'2133','321',1858389.19,1858435.18,0.00,0.00,45.99,33388.74,0.00,0.00,0.00),('1','153','763','257938',4905266,'2998','321',309292.91,309630.57,0.00,0.00,337.66,243945.42,0.00,0.00,0.00),('1','153','763','257938',4905267,'2999','321',44387.20,45141.72,0.00,0.00,754.52,547781.52,0.00,0.00,0.00),('1','153','763','257939',4905268,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257939',4905269,'2133','321',1858435.18,1858661.46,0.00,0.00,226.28,158396.00,0.00,0.00,0.00),('1','153','763','257939',4905270,'2998','321',309630.57,309990.33,0.00,0.00,359.76,261185.76,0.00,0.00,0.00),('1','153','763','257939',4905271,'2999','321',45141.72,46044.15,0.00,0.00,902.43,655164.18,0.00,0.00,0.00),('1','153','763','257940',4905272,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257940',4905273,'2133','321',1858661.46,1858735.45,0.00,0.00,73.99,52104.74,0.00,0.00,0.00),('1','153','763','257940',4905274,'2998','321',309990.33,310382.67,0.00,0.00,392.34,284527.10,0.00,0.00,0.00),('1','153','763','257940',4905275,'2999','321',46044.15,46772.51,0.00,0.00,728.36,528789.36,0.00,0.00,0.00),('1','153','763','257941',4905276,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257941',4905277,'2133','321',1858735.45,1858833.95,0.00,0.00,98.50,68950.00,0.00,0.00,0.00),('1','153','763','257941',4905278,'2998','321',310382.67,310855.09,0.00,0.00,472.42,342976.92,0.00,0.00,0.00),('1','153','763','257941',4905279,'2999','321',46772.51,47794.17,0.00,0.00,1021.66,741725.16,0.00,0.00,0.00),('1','153','763','257942',4905280,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257942',4905281,'2133','321',1858833.95,1858926.93,0.00,0.00,92.98,65982.22,0.00,0.00,0.00),('1','153','763','257942',4905282,'2998','321',310855.09,311172.56,0.00,0.00,317.47,229833.22,0.00,0.00,0.00),('1','153','763','257942',4905283,'2999','321',47794.17,48373.02,0.00,0.00,578.85,420245.10,0.00,0.00,0.00),('1','153','763','257943',4905284,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257943',4905285,'2133','321',1858926.93,1859258.71,0.00,0.00,331.78,236177.46,0.00,0.00,0.00),('1','153','763','257943',4905286,'2998','321',311172.56,311463.91,0.00,0.00,291.35,211520.10,0.00,0.00,0.00),('1','153','763','257943',4905287,'2999','321',48373.02,49216.52,0.00,0.00,843.50,608435.76,0.00,0.00,0.00),('1','153','763','257944',4905288,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257944',4905289,'2133','321',1859258.71,1859379.13,0.00,0.00,120.42,84850.92,0.00,0.00,0.00),('1','153','763','257944',4905290,'2998','321',311463.91,312367.51,0.00,0.00,903.60,655456.68,0.00,0.00,0.00),('1','153','763','257944',4905291,'2999','321',49216.52,50631.81,0.00,0.00,1415.29,1027500.54,0.00,0.00,0.00),('1','153','763','257945',4905292,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257945',4905293,'2133','321',1859379.13,1859568.34,0.00,0.00,189.21,132447.00,0.00,0.00,0.00),('1','153','763','257945',4905294,'2998','321',312367.51,312695.95,0.00,0.00,328.44,238447.44,0.00,0.00,0.00),('1','153','763','257945',4905295,'2999','321',50631.81,51177.68,0.00,0.00,545.87,396301.62,0.00,0.00,0.00),('1','153','763','257946',4905296,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257946',4905297,'2133','321',1859568.34,1859592.34,0.00,0.00,24.00,17424.00,0.00,0.00,0.00),('1','153','763','257946',4905298,'2998','321',312695.95,313395.43,0.00,0.00,699.48,507198.48,0.00,0.00,0.00),('1','153','763','257946',4905299,'2999','321',51177.68,52413.39,0.00,0.00,1235.71,897125.46,0.00,0.00,0.00),('1','153','763','257947',4905300,'2132','321',2346925.42,2346925.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','153','763','257947',4905301,'2133','321',1859592.34,1859660.34,0.00,0.00,68.00,47600.00,0.00,0.00,0.00),('1','153','763','257947',4905302,'2998','321',313395.43,313980.09,0.00,0.00,584.66,424463.16,0.00,0.00,0.00),('1','153','763','257947',4905303,'2999','321',52413.39,53383.23,0.00,0.00,969.84,704103.84,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730068 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','153','144096','321',202.00,256.00,0.00,2318.36,468308.72,538944.26,70635.54,433177),('1','153','144261','321',202.00,256.00,0.00,3980.69,804099.38,922723.34,118623.96,433654),('1','153','144347','321',202.00,256.00,0.00,1449.63,292825.26,336393.96,43568.70,433904),('1','153','144359','321',202.00,256.00,0.00,4811.62,971947.24,1111917.64,139970.40,433936),('1','153','144452','321',202.00,256.00,0.00,209.72,42363.44,49488.32,7124.88,434206),('1','153','144453','321',202.00,256.00,0.00,4090.82,826345.64,975694.52,149348.88,434207),('1','153','144533','321',202.00,256.00,0.00,239.49,48376.98,61309.44,12932.46,434443),('1','153','144539','321',202.00,256.00,0.00,5822.52,1176149.04,1348443.84,172294.80,434459),('1','153','144588','321',202.00,256.00,0.00,248.68,50233.36,63137.08,12903.72,434593),('1','153','144589','321',202.00,0.00,0.00,3974.91,802931.82,936427.08,133495.26,434594),('1','153','144590','321',202.00,256.00,0.00,2318.63,468363.26,538767.68,70404.42,434595),('1','153','144629','321',202.00,256.00,0.00,2540.28,513136.56,587828.28,74691.72,434710),('1','153','144666','321',202.00,256.00,0.00,2482.70,501505.40,622506.40,121001.00,434823),('1','153','144674','321',202.00,256.00,0.00,1259.96,254511.92,315302.56,60790.64,434845),('1','153','144727','321',202.00,256.00,0.00,1646.10,332512.20,410599.20,78087.00,434996),('1','153','144728','321',202.00,256.00,0.00,1959.09,395736.18,487674.24,91938.06,434997),('1','153','144736','321',202.00,256.00,0.00,794.45,160478.90,200537.60,40058.70,435019),('1','153','144741','321',202.00,256.00,0.00,3727.06,752866.12,956590.52,203724.40,435032),('1','153','144759','321',202.00,272.00,0.00,1725.14,348478.28,448806.08,100327.80,435080),('1','153','144772','321',202.00,272.00,0.00,2246.87,453867.74,555730.24,101862.50,435116),('1','153','144778','321',202.00,272.00,0.00,3292.21,665026.42,836268.72,171242.30,435132),('1','153','144798','321',202.00,272.00,0.00,785.63,158697.26,196745.36,38048.10,435190),('1','153','144945','321',202.00,272.00,0.00,2981.48,602258.96,737900.16,135641.20,435622),('1','153','144956','321',202.00,272.00,0.00,3279.15,662388.30,828562.40,166174.10,435652),('1','153','145013','321',202.00,272.00,0.00,146.56,29605.12,39864.32,10259.20,435815),('1','153','145022','321',202.00,272.00,0.00,4035.40,815150.80,999273.20,184122.40,435840),('1','153','145029','321',202.00,272.00,0.00,8.23,1662.46,2238.56,576.10,435857),('1','153','145239','321',202.00,272.00,0.00,3563.58,719843.16,885770.90,165927.74,436467),('1','153','145240','321',202.00,272.00,0.00,2726.22,550696.44,686625.66,135929.22,436468),('1','153','145303','321',202.00,272.00,0.00,976.00,197152.00,246572.00,49420.00,436645),('1','153','145308','321',202.00,272.00,0.00,4741.78,957839.56,1170148.16,212308.60,436658),('1','153','145313','321',202.00,272.00,0.00,576.66,116485.32,140051.52,23566.20,436671),('1','153','145316','321',210.00,272.00,0.00,3407.56,715587.60,836645.78,121058.18,436676),('1','153','145318','321',210.00,272.00,0.00,2903.38,609709.80,721552.94,111843.14,436680),('1','153','145362','321',202.00,272.00,0.00,769.51,155441.02,192632.72,37191.70,436811),('1','153','145364','321',202.00,272.00,0.00,3195.45,645480.90,786484.98,141004.08,436815),('1','153','145383','321',202.00,272.00,0.00,594.70,120129.40,149184.02,29054.62,436870),('1','153','145389','321',202.00,272.00,0.00,4069.37,822012.74,1011901.60,189888.86,436886),('1','153','145394','321',202.00,256.00,0.00,1615.70,326371.40,393589.32,67217.92,436900),('1','153','145492','321',202.00,256.00,0.00,1835.00,370670.00,446640.80,75970.80,437184),('1','153','145496','321',202.00,256.00,0.00,4521.86,913415.72,1097858.04,184442.32,437194),('1','153','145588','321',202.00,256.00,0.00,293.87,59361.74,69770.72,10408.98,437458),('1','153','146001','321',202.00,256.00,0.00,5793.84,1170355.68,1396336.24,225980.56,438655),('1','153','146022','321',202.00,256.00,0.00,337.63,68201.26,83634.38,15433.12,438708),('1','153','146079','321',202.00,0.00,0.00,3721.92,751827.84,904081.28,152253.44,438867),('1','153','146080','321',202.00,0.00,0.00,63.24,12774.48,16189.44,3414.96,438868),('1','153','146081','321',202.00,256.00,0.00,4402.89,889383.78,1068704.84,179321.06,438869),('1','153','146086','321',202.00,256.00,0.00,1919.03,387644.06,471522.08,83878.02,438882),('1','153','146461','321',202.00,256.00,0.00,4045.87,817265.74,983144.72,165878.98,440002),('1','153','146543','321',202.00,256.00,0.00,2244.80,453449.60,550842.40,97392.80,440246),('1','153','146556','321',202.00,256.00,0.00,4368.13,882362.26,1081807.48,199445.22,440281),('1','153','146566','321',202.00,256.00,0.00,1898.68,383533.36,457548.40,74015.04,440307),('1','153','146725','321',202.00,256.00,0.00,2293.59,463305.18,547384.24,84079.06,440778),('1','153','146744','321',202.00,256.00,0.00,1958.92,395701.84,465844.02,70142.18,440833),('1','153','146850','321',202.00,256.00,0.00,4569.72,923083.44,1086176.16,163092.72,441130),('1','153','147080','321',202.00,256.00,0.00,1750.29,353558.58,430431.42,76872.84,441728),('1','153','147116','321',202.00,256.00,0.00,1852.39,374182.78,433253.52,59070.74,441786),('1','153','147117','321',202.00,256.00,0.00,3899.47,787692.94,951825.46,164132.52,441787),('1','153','147157','321',202.00,256.00,0.00,548.28,110752.56,135838.54,25085.98,441881),('1','153','147173','321',202.00,256.00,0.00,3147.55,635805.10,766216.40,130411.30,441905),('1','153','147193','321',202.00,256.00,0.00,3176.31,641614.62,765466.96,123852.34,441945),('1','153','147610','321',202.00,256.00,0.00,958.66,193649.32,234639.96,40990.64,443031),('1','153','147621','321',202.00,256.00,0.00,3089.07,623992.14,754043.90,130051.76,443062),('1','153','147626','321',202.00,256.00,0.00,435.46,87962.92,111338.92,23376.00,443075),('1','153','147636','321',202.00,256.00,0.00,2588.00,522776.00,625928.58,103152.58,443101),('1','153','147640','321',202.00,256.00,0.00,2331.27,470916.54,563584.92,92668.38,443111),('1','153','147650','321',202.00,256.00,0.00,1437.48,290370.96,346116.40,55745.44,443139),('1','153','147660','321',202.00,256.00,0.00,3595.64,726319.28,870042.80,143723.52,443167),('1','153','147692','321',202.00,256.00,0.00,2732.27,551918.54,655157.12,103238.58,443235),('1','153','147693','321',202.00,256.00,0.00,1721.03,347648.06,418093.68,70445.62,443236),('1','153','147898','321',202.00,256.00,0.00,4537.85,916645.70,1097098.06,180452.36,443809),('1','153','147902','321',202.00,256.00,0.00,73.96,14939.92,18725.76,3785.84,443817),('1','153','147905','321',202.00,256.00,0.00,4104.32,829072.64,990856.78,161784.14,443824),('1','153','147914','321',202.00,256.00,0.00,1036.82,209437.64,253174.72,43737.08,443845),('1','153','147921','321',207.00,256.00,0.00,2068.78,428237.46,501536.52,73299.06,443864),('1','153','147935','321',207.00,256.00,0.00,3760.41,778404.87,915568.56,137163.69,443900),('1','153','147990','321',207.00,256.00,0.00,473.98,98113.86,111778.68,13664.82,444045),('1','153','147992','321',207.00,256.00,0.00,4859.96,1006011.72,1173863.96,167852.24,444047),('1','153','147993','321',207.00,256.00,0.00,1465.79,303418.53,352481.84,49063.31,444048),('1','153','147995','321',207.00,256.00,0.00,3336.83,690723.81,809492.10,118768.29,444050),('1','153','148018','321',207.00,256.00,0.00,2947.66,610165.62,705137.00,94971.38,444111),('1','153','148060','321',207.00,256.00,0.00,1830.26,378863.82,442926.42,64062.60,444233),('1','153','148064','321',207.00,256.00,0.00,1892.45,391737.15,462571.82,70834.67,444243),('1','153','148084','321',207.00,256.00,0.00,1898.38,392964.66,455294.88,62330.22,444301),('1','153','148086','321',207.00,256.00,0.00,4036.78,835613.46,980759.96,145146.50,444305),('1','153','148471','321',207.00,256.00,0.00,373.35,77283.45,89995.40,12711.95,445306),('1','153','148475','321',207.00,256.00,0.00,2685.17,555830.19,645927.54,90097.35,445316),('1','153','148478','321',207.00,256.00,0.00,3533.32,731397.24,860189.52,128792.28,445323),('1','153','148487','321',207.00,256.00,0.00,5106.18,1056979.26,1229234.08,172254.82,445348),('1','153','148581','321',207.00,256.00,0.00,1252.73,259315.11,301373.86,42058.75,445593),('1','153','148672','321',207.00,256.00,0.00,3351.29,693717.03,806895.36,113178.33,445817),('1','153','148731','321',207.00,256.00,0.00,828.12,171420.84,202854.52,31433.68,445983),('1','153','148814','321',207.00,256.00,0.00,3414.49,706799.43,822151.04,115351.61,446180),('1','153','148871','321',207.00,256.00,0.00,2953.10,611291.70,708927.88,97636.18,446344),('1','153','148937','321',207.00,256.00,0.00,1482.50,306877.50,358691.40,51813.90,446520),('1','153','149152','321',207.00,256.00,0.00,4860.54,1006131.78,1171127.74,164995.96,447082),('1','153','149310','321',207.00,256.00,0.00,4183.35,865953.45,1010818.32,144864.87,447491),('1','153','149478','321',207.00,256.00,0.00,2155.62,446213.34,521626.20,75412.86,447951),('1','153','149479','321',207.00,256.00,0.00,2603.45,538914.15,625372.00,86457.85,447952),('1','153','149603','321',207.00,256.00,0.00,1292.28,267501.96,320447.08,52945.12,448289),('1','153','149604','321',207.00,256.00,0.00,2322.94,480848.58,566056.52,85207.94,448290),('1','153','149701','321',207.00,256.00,0.00,3982.76,824431.32,978685.18,154253.86,448540),('1','153','149702','321',207.00,256.00,0.00,1839.55,380786.85,454582.76,73795.91,448541),('1','153','149862','321',213.00,256.00,0.00,4525.10,963846.30,1084820.64,120974.34,448966),('1','153','149863','321',213.00,256.00,0.00,1131.56,241022.28,279279.36,38257.08,448967),('1','153','150048','321',213.00,256.00,0.00,5211.40,1110028.20,1261676.16,151647.96,449463),('1','153','150222','321',213.00,256.00,0.00,3229.77,687941.01,778716.44,90775.43,449929),('1','153','150272','321',213.00,256.00,0.00,4070.86,867093.18,968642.58,101549.40,450063),('1','153','150392','321',213.00,256.00,0.00,2289.20,487599.60,553808.72,66209.12,450359),('1','153','150512','321',213.00,256.00,0.00,2066.09,440077.17,509907.84,69830.67,450702),('1','153','150558','321',213.00,256.00,0.00,4249.77,905201.01,1019516.40,114315.39,450818),('1','153','150559','321',213.00,256.00,0.00,1235.41,263142.33,295889.54,32747.21,450819),('1','153','150844','321',213.00,256.00,0.00,2999.62,638919.06,733405.14,94486.08,451567),('1','153','150846','321',213.00,256.00,0.00,1850.24,394101.12,444990.72,50889.60,451569),('1','153','150849','321',213.00,256.00,0.00,4454.36,948778.68,1068599.84,119821.16,451574),('1','153','150853','321',213.00,256.00,0.00,2383.67,507721.71,568442.72,60721.01,451578),('1','153','151110','321',213.00,256.00,0.00,3925.22,836071.86,955520.02,119448.16,452282),('1','153','151117','321',213.00,256.00,0.00,611.04,130151.52,149594.74,19443.22,452297),('1','153','151151','321',213.00,256.00,0.00,4124.47,878512.11,1000717.02,122204.91,452395),('1','153','151393','321',213.00,256.00,0.00,2424.20,516354.60,588810.72,72456.12,453060),('1','153','151441','321',213.00,256.00,0.00,1396.06,297360.78,337178.96,39818.18,453180),('1','153','151443','321',213.00,256.00,0.00,4060.61,864909.93,983617.46,118707.53,453184),('1','153','151733','321',213.00,256.00,0.00,810.87,172715.31,195040.32,22325.01,453982),('1','153','151738','321',213.00,256.00,0.00,3668.72,781437.36,884924.60,103487.24,453995),('1','153','151766','321',213.00,256.00,0.00,2681.54,571168.02,645084.58,73916.56,454065),('1','153','151771','321',213.00,256.00,0.00,1183.89,252168.57,290549.04,38380.47,454076),('1','153','151820','321',213.00,256.00,0.00,5142.67,1095388.71,1249433.12,154044.41,454199),('1','153','152034','321',213.00,256.00,0.00,4084.18,869930.34,957338.32,87407.98,454774),('1','153','152113','321',213.00,256.00,0.00,743.16,158293.08,181724.60,23431.52,454991),('1','153','152190','321',213.00,256.00,0.00,4499.15,958318.95,1087326.06,129007.11,455179),('1','153','152401','321',213.00,256.00,0.00,1014.44,216075.72,248113.12,32037.40,455746),('1','153','152480','321',213.00,256.00,0.00,3267.09,695890.17,782048.04,86157.87,455964),('1','153','152593','321',213.00,256.00,0.00,3063.03,652425.39,744619.06,92193.67,456276),('1','153','152682','321',213.00,256.00,0.00,1238.53,263806.89,302168.28,38361.39,456500),('1','153','152869','321',213.00,256.00,0.00,4836.66,1030208.58,1166664.16,136455.58,457018),('1','153','152883','321',213.00,256.00,0.00,216.37,46086.81,55390.72,9303.91,457052),('1','153','153047','321',213.00,256.00,0.00,3071.44,654216.72,746641.24,92424.52,457493),('1','153','153200','321',213.00,256.00,0.00,3228.76,687725.88,774843.36,87117.48,457911),('1','153','153226','321',213.00,256.00,0.00,1367.52,291281.76,331206.52,39924.76,457988),('1','153','153456','321',213.00,256.00,0.00,4113.69,876215.97,1039054.52,162838.55,458628),('1','153','153543','321',213.00,256.00,0.00,764.76,162893.88,190751.32,27857.44,458837),('1','153','153550','321',213.00,256.00,0.00,2734.82,582516.66,696690.24,114173.58,458856),('1','153','153658','321',213.00,256.00,0.00,3604.80,767822.40,895963.20,128140.80,459152),('1','153','153694','321',213.00,256.00,0.00,3361.91,716086.83,850423.96,134337.13,459246),('1','153','153705','321',215.00,272.00,0.00,1050.57,225872.55,271744.44,45871.89,459270),('1','153','153890','321',215.00,272.00,0.00,4238.06,911182.90,1063596.34,152413.44,459770),('1','153','154055','321',215.00,272.00,0.00,998.61,214701.15,256779.12,42077.97,460196),('1','153','154124','321',215.00,0.00,0.00,3487.37,749784.55,870382.68,120598.13,460369),('1','153','154219','321',215.00,272.00,0.00,2835.57,609647.55,721642.10,111994.55,460648),('1','153','154302','321',215.00,272.00,0.00,3604.20,774903.00,900358.10,125455.10,460854),('1','153','154359','321',215.00,272.00,0.00,1109.85,238617.75,281465.60,42847.85,461008),('1','153','154471','321',215.00,272.00,0.00,1374.76,295573.40,348980.12,53406.72,461312),('1','153','154759','321',215.00,272.00,0.00,4957.52,1065866.80,1273006.32,207139.52,462103),('1','153','154998','321',215.00,272.00,0.00,4384.43,942652.45,1123487.80,180835.35,462756),('1','153','155101','321',215.00,272.00,0.00,1879.14,404015.10,488124.68,84109.58,463041),('1','153','155110','321',215.00,272.00,0.00,2328.82,500696.30,586677.00,85980.70,463067),('1','153','155264','321',215.00,272.00,0.00,4033.87,867282.05,1026784.96,159502.91,463488),('1','153','155266','321',215.00,272.00,0.00,1382.66,297271.90,350612.12,53340.22,463492),('1','153','155384','321',215.00,272.00,0.00,4936.15,1061272.25,1246463.16,185190.91,463795),('1','153','155482','321',215.00,272.00,0.00,4490.89,965541.35,1139760.52,174219.17,464042),('1','153','155577','321',215.00,272.00,0.00,1849.90,397728.50,472897.06,75168.56,464312),('1','153','155706','321',215.00,272.00,0.00,2427.90,521998.50,611201.60,89203.10,464667),('1','153','155836','321',215.00,272.00,0.00,1080.24,232251.60,278629.08,46377.48,465006),('1','153','155849','321',215.00,272.00,0.00,2874.31,617976.65,725864.92,107888.27,465043),('1','153','156117','321',215.00,272.00,0.00,3418.88,735059.20,870521.22,135462.02,465738),('1','153','156126','321',215.00,272.00,0.00,450.84,96930.60,117597.28,20666.68,465763),('1','153','156183','321',215.00,272.00,0.00,4681.83,1006593.45,1188301.28,181707.83,465922),('1','153','156390','321',215.00,272.00,0.00,1156.18,248578.70,293425.16,44846.46,466469),('1','153','156396','321',215.00,272.00,0.00,2843.39,611328.85,713552.84,102223.99,466485),('1','153','156435','321',215.00,272.00,0.00,3474.64,747047.60,875536.62,128489.02,466580),('1','153','156654','321',215.00,272.00,0.00,5330.14,1145980.10,1326510.12,180530.02,467179),('1','153','156768','321',215.00,272.00,0.00,939.45,201981.75,240917.12,38935.37,467494),('1','153','156771','321',215.00,272.00,0.00,3337.75,717616.25,832788.74,115172.49,467501),('1','153','157064','321',215.00,272.00,0.00,1815.85,390407.75,451442.40,61034.65,468293),('1','153','157071','321',215.00,272.00,0.00,2570.50,552657.50,636407.60,83750.10,468310),('1','153','157226','321',215.00,272.00,0.00,3730.91,802145.65,943040.72,140895.07,468701),('1','153','157399','321',215.00,272.00,0.00,5524.20,1187703.00,1380193.90,192490.90,469144),('1','153','157403','321',215.00,272.00,0.00,822.00,176730.00,208092.16,31362.16,469154),('1','153','157631','321',215.00,272.00,0.00,4167.59,896031.85,1031091.64,135059.79,469756),('1','153','157776','321',215.00,272.00,0.00,2153.24,462946.60,544718.04,81771.44,470141),('1','153','157782','321',215.00,272.00,0.00,1495.86,321609.90,382297.42,60687.52,470153),('1','153','157872','321',215.00,272.00,0.00,2698.39,580153.85,660186.22,80032.37,470389),('1','153','157887','321',215.00,272.00,0.00,765.77,164640.55,193572.04,28931.49,470433),('1','153','158049','321',215.00,272.00,0.00,4260.89,916091.35,1068584.78,152493.43,470864),('1','153','158247','321',215.00,272.00,0.00,1241.11,266838.65,318369.50,51530.85,471386),('1','153','158253','321',215.00,272.00,0.00,3548.44,762914.60,885113.86,122199.26,471398),('1','153','158311','321',215.00,272.00,0.00,4494.45,966306.75,1148622.96,182316.21,471545),('1','153','158441','321',215.00,272.00,0.00,2358.06,506982.90,641392.32,134409.42,471889),('1','153','158742','321',215.00,272.00,0.00,3013.16,647829.40,818154.52,170325.12,472681),('1','153','158746','321',215.00,272.00,0.00,2123.21,456490.15,576088.12,119597.97,472691),('1','153','158902','321',215.00,272.00,0.00,1311.38,281946.70,356695.36,74748.66,473094),('1','153','158986','321',218.00,272.00,0.00,1846.92,402628.56,477831.04,75202.48,473316),('1','153','159113','321',218.00,272.00,0.00,4442.38,968438.84,1129841.28,161402.44,473658),('1','153','159323','321',218.00,272.00,0.00,4989.40,1087689.20,1300915.20,213226.00,474218),('1','153','159344','321',218.00,272.00,0.00,1114.25,242906.50,287383.20,44476.70,474264),('1','153','159602','321',218.00,272.00,0.00,135.00,29430.00,36720.00,7290.00,474946),('1','153','159696','321',218.00,272.00,0.00,4591.26,1000894.68,1161940.80,161046.12,475169),('1','153','159699','321',218.00,272.00,0.00,1287.53,280681.54,332281.12,51599.58,475176),('1','153','159706','321',218.00,272.00,0.00,882.22,192323.96,228524.16,36200.20,475195),('1','153','159709','321',218.00,272.00,0.00,3043.92,663574.56,781386.88,117812.32,475202),('1','153','159826','321',218.00,272.00,0.00,2595.04,565718.72,676116.48,110397.76,475505),('1','153','160040','321',218.00,272.00,0.00,6363.98,1387347.64,1612561.60,225213.96,476049),('1','153','160205','321',218.00,272.00,0.00,6306.68,1374856.24,1586390.40,211534.16,476481),('1','153','160383','321',218.00,272.00,0.00,4639.04,1011310.72,1200559.92,189249.20,476949),('1','153','160512','321',218.00,272.00,0.00,1570.43,342353.74,406956.08,64602.34,477291),('1','153','160515','321',218.00,272.00,0.00,2239.88,488293.84,587330.92,99037.08,477298),('1','153','160654','321',218.00,272.00,0.00,3254.43,709465.74,905061.48,195595.74,477650),('1','153','160819','321',225.00,296.00,0.00,796.85,179291.25,220819.16,41527.91,478073),('1','153','160822','321',225.00,296.00,0.00,2647.41,595667.25,750341.32,154674.07,478078),('1','153','160953','321',225.00,296.00,0.00,3590.74,807916.50,998850.04,190933.54,478402),('1','153','161161','321',225.00,296.00,0.00,2657.79,598002.75,768853.24,170850.49,478960),('1','153','161353','321',225.00,296.00,0.00,3122.63,702591.75,876725.28,174133.53,479433),('1','153','161525','321',250.00,296.00,0.00,596.00,149000.00,168941.00,19941.00,479873),('1','153','161531','321',225.00,296.00,0.00,2070.15,465783.75,583418.70,117634.95,479889),('1','153','161738','321',225.00,296.00,0.00,2580.74,580666.50,722591.96,141925.46,480418),('1','153','161966','321',225.00,296.00,0.00,1650.78,371425.50,453159.36,81733.86,481024),('1','153','161980','321',225.00,296.00,0.00,1309.59,294657.75,360069.00,65411.25,481064),('1','153','162136','321',225.00,296.00,0.00,3158.27,710610.75,872129.68,161518.93,481470),('1','153','162279','321',225.00,296.00,0.00,1812.10,407722.50,528036.74,120314.24,481825),('1','153','162294','321',225.00,296.00,0.00,890.29,200315.25,249887.30,49572.05,481868),('1','153','162505','321',225.00,296.00,0.00,3351.52,754092.00,928919.06,174827.06,482400),('1','153','162763','321',225.00,296.00,0.00,3273.22,736474.50,907559.72,171085.22,483073),('1','153','162903','321',225.00,296.00,0.00,3039.47,683880.75,842173.92,158293.17,483434),('1','153','163066','321',225.00,296.00,0.00,3786.51,851964.75,1039303.24,187338.49,483848),('1','153','163495','321',225.00,296.00,0.00,2519.95,566988.75,677841.76,110853.01,484973),('1','153','163506','321',225.00,296.00,0.00,1119.68,251928.00,301052.40,49124.40,485002),('1','153','163509','321',225.00,296.00,0.00,4924.88,1108098.00,1332143.54,224045.54,485009),('1','153','163715','321',225.00,296.00,0.00,5144.67,1157550.75,1364715.72,207164.97,485552),('1','153','163882','321',225.00,296.00,0.00,5715.29,1285940.25,1488188.72,202248.47,485980),('1','153','163886','321',225.00,296.00,0.00,1040.41,234092.25,275287.10,41194.85,485988),('1','153','164055','321',230.00,296.00,0.00,5239.48,1205080.40,1367384.26,162303.86,486442),('1','153','164061','321',230.00,296.00,0.00,1909.16,439106.80,515016.28,75909.48,486455),('1','153','164103','321',230.00,296.00,0.00,3522.47,810168.10,998769.46,188601.36,486536),('1','153','164412','321',230.00,296.00,0.00,4223.91,971499.30,1196322.94,224823.64,487385),('1','153','164550','321',230.00,296.00,0.00,850.49,195612.70,239408.04,43795.34,487755),('1','153','164557','321',230.00,296.00,0.00,2829.09,650690.70,802856.38,152165.68,487771),('1','153','164695','321',230.00,296.00,0.00,3483.86,801287.80,999216.30,197928.50,488144),('1','153','164842','321',230.00,296.00,0.00,5668.42,1303736.60,1609533.16,305796.56,488527),('1','153','165059','321',230.00,296.00,0.00,4602.36,1058542.80,1332614.36,274071.56,489074),('1','153','165238','321',245.00,320.00,0.00,1671.14,409429.30,517534.72,108105.42,489546),('1','153','165245','321',245.00,320.00,0.00,2532.19,620386.55,788056.16,167669.61,489564),('1','153','165328','321',245.00,320.00,0.00,2276.10,557644.50,704255.52,146611.02,489763),('1','153','165340','321',245.00,320.00,0.00,1733.05,424597.25,542026.16,117428.91,489793),('1','153','165499','321',245.00,320.00,0.00,4342.29,1063861.05,1354502.64,290641.59,490214),('1','153','165728','321',245.00,320.00,0.00,4246.01,1040272.45,1318514.56,278242.11,490837),('1','153','165863','321',245.00,320.00,0.00,2030.18,497394.10,634238.80,136844.70,491200),('1','153','165873','321',245.00,320.00,0.00,1417.15,347201.75,441742.64,94540.89,491228),('1','153','166186','321',245.00,320.00,0.00,4169.89,1021623.05,1301275.76,279652.71,492030),('1','153','166191','321',245.00,320.00,0.00,714.76,175116.20,220104.80,44988.60,492043),('1','153','166205','321',245.00,320.00,0.00,3976.38,974213.10,1212202.56,237989.46,492082),('1','153','166555','321',245.00,320.00,0.00,2895.43,709380.35,899384.00,190003.65,493032),('1','153','166579','321',245.00,320.00,0.00,3277.22,802918.90,1019702.08,216783.18,493097),('1','153','166780','321',145.00,320.00,0.00,2825.96,409764.20,887908.00,478143.80,493634),('1','153','167147','321',245.00,320.00,0.00,3409.30,835278.50,1059619.04,224340.54,494638),('1','153','167151','321',245.00,320.00,0.00,3805.16,932264.20,1179358.72,247094.52,494648),('1','153','167399','321',245.00,320.00,0.00,2470.77,605338.65,764982.24,159643.59,495291),('1','153','167400','321',245.00,320.00,0.00,1575.56,386012.20,487209.76,101197.56,495292),('1','153','167535','321',245.00,320.00,0.00,4638.60,1136457.00,1422297.12,285840.12,495671),('1','153','167698','321',245.00,320.00,0.00,3571.30,874968.50,1106239.04,231270.54,496093),('1','153','167795','321',245.00,320.00,0.00,729.82,178805.90,229651.04,50845.14,496330),('1','153','167800','321',245.00,320.00,0.00,2618.79,641603.55,809598.24,167994.69,496343),('1','153','168047','321',245.00,320.00,0.00,3675.90,900595.50,1138680.96,238085.46,497021),('1','153','168474','321',245.00,320.00,0.00,3424.11,838906.95,1069169.28,230262.33,498158),('1','153','168493','321',245.00,320.00,0.00,3821.85,936353.25,1178521.20,242167.95,498204),('1','153','168509','321',245.00,320.00,0.00,4446.01,1089272.45,1367530.64,278258.19,498246),('1','153','168655','321',245.00,320.00,0.00,3394.72,831706.40,1058157.20,226450.80,498624),('1','153','168852','321',245.00,320.00,0.00,1443.55,353669.75,452225.60,98555.85,499146),('1','153','168861','321',245.00,320.00,0.00,2308.47,565575.15,721320.96,155745.81,499171),('1','153','169043','321',245.00,320.00,0.00,4047.39,991610.55,1252113.12,260502.57,499653),('1','153','169052','321',245.00,320.00,0.00,923.88,226350.60,287823.60,61473.00,499678),('1','153','169239','321',245.00,320.00,0.00,3838.86,940520.70,1198384.08,257863.38,500149),('1','153','169387','321',245.00,320.00,0.00,2280.79,558793.55,696530.00,137736.45,500531),('1','153','169392','321',245.00,320.00,0.00,3314.56,812067.20,1022022.32,209955.12,500543),('1','153','169580','321',245.00,320.00,0.00,5981.96,1465580.20,1823102.80,357522.60,501014),('1','153','169735','321',270.00,328.00,0.00,5758.33,1554749.10,1839754.96,285005.86,501445),('1','153','170104','321',270.00,328.00,0.00,581.77,157077.90,185512.36,28434.46,502411),('1','153','170168','321',270.00,328.00,0.00,5327.24,1438354.80,1698467.24,260112.44,502565),('1','153','170303','321',270.00,328.00,0.00,2245.24,606214.80,720193.00,113978.20,502932),('1','153','170310','321',270.00,328.00,0.00,2441.19,659121.30,786561.78,127440.48,502947),('1','153','170490','321',270.00,328.00,0.00,3931.58,1061526.60,1261070.18,199543.58,503417),('1','153','170493','321',270.00,328.00,0.00,898.03,242468.10,291483.40,49015.30,503422),('1','153','170525','321',270.00,328.00,0.00,3617.66,976768.20,1163852.72,187084.52,503503),('1','153','170594','321',270.00,328.00,0.00,5669.91,1530875.70,1820513.34,289637.64,503691),('1','153','170753','321',270.00,328.00,0.00,629.18,169878.60,200503.04,30624.44,504105),('1','153','170967','321',270.00,328.00,0.00,2789.62,753197.40,900784.90,147587.50,504676),('1','153','171325','321',270.00,328.00,0.00,3588.46,968884.20,1149154.30,180270.10,505635),('1','153','171331','321',270.00,328.00,0.00,4014.23,1083842.10,1292461.04,208618.94,505651),('1','153','171337','321',270.00,328.00,0.00,2785.26,752020.20,896049.48,144029.28,505665),('1','153','171904','321',270.00,328.00,0.00,3931.45,1061491.50,1266176.98,204685.48,507173),('1','153','171909','321',270.00,328.00,0.00,2970.83,802124.10,949478.30,147354.20,507186),('1','153','171918','321',270.00,328.00,0.00,4664.80,1259496.00,1496963.20,237467.20,507209),('1','153','171985','321',270.00,328.00,0.00,1575.86,425482.20,509397.68,83915.48,507373),('1','153','171993','321',270.00,328.00,0.00,1988.13,536795.10,632862.66,96067.56,507389),('1','153','172195','321',270.00,328.00,0.00,3080.76,831805.20,995949.06,164143.86,507934),('1','153','172446','321',270.00,328.00,0.00,1206.65,325795.50,384930.98,59135.48,508605),('1','153','172598','321',270.00,328.00,0.00,2448.57,661113.90,782426.64,121312.74,509001),('1','153','172667','321',270.00,328.00,0.00,2964.29,800358.30,961699.70,161341.40,509192),('1','153','172928','321',270.00,328.00,0.00,3949.17,1066275.90,1269329.82,203053.92,509865),('1','153','173010','321',270.00,328.00,0.00,2337.54,631135.80,750722.64,119586.84,510098),('1','153','173265','321',270.00,328.00,0.00,1584.18,427728.60,505497.24,77768.64,510757),('1','153','173305','321',270.00,328.00,0.00,4199.96,1133989.20,1351701.44,217712.24,510868),('1','153','173545','321',270.00,328.00,0.00,6642.86,1793572.20,2131735.88,338163.68,511530),('1','153','173668','321',270.00,328.00,0.00,4275.99,1154517.30,1378764.18,224246.88,511836),('1','153','173742','321',270.00,328.00,0.00,1831.03,494378.10,589172.14,94794.04,512044),('1','153','173837','321',270.00,328.00,0.00,2707.04,730900.80,869318.54,138417.74,512288),('1','153','174112','321',270.00,328.00,0.00,3850.46,1039624.20,1234897.88,195273.68,513020),('1','153','174119','321',270.00,328.00,0.00,879.45,237451.50,282184.08,44732.58,513035),('1','153','174156','321',270.00,328.00,0.00,4593.54,1240255.80,1478370.54,238114.74,513114),('1','153','174507','321',270.00,328.00,0.00,5328.46,1438684.20,1708316.50,269632.30,514025),('1','153','175029','321',270.00,328.00,0.00,1044.11,281909.70,335628.08,53718.38,515406),('1','153','175035','321',270.00,328.00,0.00,4101.99,1107537.30,1315208.40,207671.10,515416),('1','153','175040','321',270.00,328.00,0.00,2774.41,749090.70,889618.96,140528.26,515425),('1','153','175063','321',270.00,328.00,0.00,2940.14,793837.80,941276.06,147438.26,515484),('1','153','175176','321',270.00,328.00,0.00,3396.47,917046.90,1079225.66,162178.76,515798),('1','153','175196','321',270.00,328.00,0.00,1954.31,527663.70,628606.46,100942.76,515851),('1','153','175214','321',298.00,352.00,0.00,4788.97,1427113.06,1607002.34,179889.28,515899),('1','153','175309','321',298.00,352.00,0.00,4735.82,1411274.36,1592105.32,180830.96,516137),('1','153','175454','321',298.00,352.00,0.00,1669.52,497516.96,567477.08,69960.12,516513),('1','153','175472','321',298.00,352.00,0.00,2480.00,739040.00,836310.90,97270.90,516562),('1','153','175783','321',298.00,352.00,0.00,3154.08,939915.84,1055480.44,115564.60,517371),('1','153','175823','321',298.00,352.00,0.00,1967.67,586365.66,666045.68,79680.02,517485),('1','153','176061','321',298.00,352.00,0.00,5159.71,1537593.58,1725095.82,187502.24,518085),('1','153','176074','321',298.00,352.00,0.00,6329.43,1886170.14,2134249.08,248078.94,518122),('1','153','176534','321',298.00,352.00,0.00,6754.82,2012936.36,2241811.30,228874.94,519316),('1','153','176556','321',298.00,352.00,0.00,4334.97,1291821.06,1428488.84,136667.78,519367),('1','153','176558','321',298.00,352.00,0.00,2911.30,867567.40,975728.34,108160.94,519369),('1','153','176931','321',298.00,352.00,0.00,3388.25,1009698.50,1126744.28,117045.78,520393),('1','153','177027','321',298.00,352.00,0.00,2903.19,865150.62,971521.96,106371.34,520625),('1','153','177221','321',298.00,352.00,0.00,3497.72,1042320.56,1154848.40,112527.84,521131),('1','153','177222','321',298.00,352.00,0.00,5220.25,1555634.50,1760306.52,204672.02,521132),('1','153','177307','321',298.00,352.00,0.00,1784.64,531822.72,602022.46,70199.74,521354),('1','153','177531','321',298.00,352.00,0.00,1945.28,624355.27,668081.62,43726.35,521958),('1','153','177794','321',301.00,352.00,0.00,4074.15,1226319.15,1362588.60,136269.45,522681),('1','153','177810','321',301.00,344.00,0.00,5207.38,1567421.38,1720475.12,153053.74,522725),('1','153','177888','321',301.00,344.00,0.00,945.30,284535.30,321698.70,37163.40,522901),('1','153','178214','321',298.00,344.00,0.00,3944.29,1175398.42,1291492.46,116094.04,523771),('1','153','178228','321',298.00,344.00,0.00,2384.47,710572.06,789174.68,78602.62,523812),('1','153','178236','321',298.00,344.00,0.00,2272.30,677145.40,745861.70,68716.30,523832),('1','153','178331','321',298.00,344.00,0.00,4777.55,1423709.90,1592138.22,168428.32,524063),('1','153','178491','321',298.00,344.00,0.00,4944.61,1709630.38,1697646.02,-11984.36,524486),('1','153','178741','321',352.00,352.00,0.00,3886.85,1158281.30,1345918.74,187637.44,525133),('1','153','178911','321',298.00,352.00,0.00,3738.96,1114210.08,1300363.68,186153.60,525577),('1','153','179139','321',298.00,352.00,0.00,4369.11,1301994.78,1517453.76,215458.98,526184),('1','153','179363','321',298.00,352.00,0.00,1284.24,382703.52,457036.56,74333.04,526790),('1','153','179538','321',298.00,352.00,0.00,2049.31,610694.38,720322.20,109627.82,527255),('1','153','179567','321',298.00,360.00,0.00,3954.02,1178297.96,1394808.68,216510.72,527328),('1','153','179766','321',298.00,360.00,0.00,3953.05,1178008.90,1382386.48,204377.58,527868),('1','153','179986','321',298.00,360.00,0.00,2422.31,721848.38,849953.40,128105.02,528438),('1','153','180082','321',298.00,360.00,0.00,2066.55,615831.90,733195.00,117363.10,528682),('1','153','180171','321',298.00,360.00,0.00,2854.95,850775.10,1009954.16,159179.06,528920),('1','153','180418','321',298.00,360.00,0.00,1855.44,552921.12,649004.40,96083.28,529545),('1','153','180430','321',298.00,360.00,0.00,3658.43,1090212.14,1298299.00,208086.86,529579),('1','153','180545','321',298.00,360.00,0.00,3889.14,1284407.70,1372352.80,87945.10,529901),('1','153','180731','321',318.00,360.00,0.00,4639.83,1475465.94,1629464.60,153998.66,530385),('1','153','180954','321',318.00,360.00,0.00,3820.23,1214833.14,1354817.20,139984.06,530986),('1','153','181138','321',318.00,360.00,0.00,4136.10,1315279.80,1454634.20,139354.40,531451),('1','153','181360','321',318.00,360.00,0.00,2660.67,846093.06,939837.80,93744.74,532053),('1','153','181538','321',318.00,360.00,0.00,4776.99,1519082.82,1682703.20,163620.38,532512),('1','153','181707','321',318.00,360.00,0.00,1520.00,483360.00,541962.00,58602.00,532966),('1','153','181789','321',318.00,360.00,0.00,2196.13,698369.34,769268.80,70899.46,533183),('1','153','181901','321',318.00,360.00,0.00,4227.20,1344249.60,1488597.40,144347.80,533497),('1','153','182119','321',318.00,360.00,0.00,4774.03,1518141.54,1672145.60,154004.06,534065),('1','153','182306','321',318.00,360.00,0.00,4584.73,1457944.14,1630649.00,172704.86,534553),('1','153','182490','321',318.00,360.00,0.00,4518.26,1436806.68,1599020.20,162213.52,535057),('1','153','182746','321',318.00,360.00,0.00,4056.58,1289992.44,1434048.20,144055.76,535731),('1','153','182830','321',318.00,360.00,0.00,2353.33,748358.94,841171.60,92812.66,535964),('1','153','182979','321',318.00,360.00,0.00,1801.54,572889.72,619515.40,46625.68,536379),('1','153','182983','321',318.00,360.00,0.00,3775.09,1200478.62,1334884.80,134406.18,536385),('1','153','183206','321',318.00,360.00,0.00,1294.77,411736.86,455152.00,43415.14,536954),('1','153','183302','321',318.00,360.00,0.00,2427.97,772094.46,855776.60,83682.14,537189),('1','153','183421','321',318.00,360.00,0.00,3527.80,1121840.40,1242735.60,120895.20,537508),('1','153','183635','321',318.00,360.00,0.00,2151.93,684313.74,755317.80,71004.06,538078),('1','153','183814','321',318.00,360.00,0.00,1629.25,518101.50,569091.60,50990.10,538557),('1','153','183864','321',318.00,360.00,0.00,1595.43,507346.74,565063.40,57716.66,538684),('1','153','184096','321',321.00,360.00,0.00,1502.35,482254.35,531606.40,49352.05,539295),('1','153','184146','321',321.00,360.00,0.00,3120.59,1001709.39,1111401.10,109691.71,539428),('1','153','184278','321',321.00,360.00,0.00,1432.97,459983.37,506998.40,47015.03,539776),('1','153','184380','321',321.00,360.00,0.00,1229.21,394576.41,433748.60,39172.19,540046),('1','153','184464','321',321.00,360.00,0.00,2557.30,820893.30,911067.80,90174.50,540254),('1','153','184670','321',321.00,360.00,0.00,2235.38,717556.98,788298.00,70741.02,540825),('1','153','184813','321',321.00,360.00,0.00,999.07,320701.47,351119.20,30417.73,541210),('1','153','184866','321',321.00,360.00,0.00,2543.62,816502.02,899938.00,83435.98,541347),('1','153','185092','321',321.00,360.00,0.00,3029.55,972485.55,1072305.40,99819.85,541927),('1','153','185252','321',321.00,360.00,0.00,2492.58,800118.18,888313.20,88195.02,542327),('1','153','185455','321',321.00,360.00,0.00,2909.25,933869.25,1027467.40,93598.15,542867),('1','153','185665','321',321.00,360.00,0.00,1161.45,372825.45,410999.80,38174.35,543426),('1','153','185769','321',321.00,360.00,0.00,1644.15,530025.29,585120.20,55094.91,543695),('1','153','185895','321',323.00,360.00,0.00,2471.99,798452.77,880118.40,81665.63,544022),('1','153','186070','321',323.00,360.00,0.00,2175.58,702712.34,776404.40,73692.06,544501),('1','153','186305','321',323.00,360.00,0.00,2194.80,708920.40,780660.00,71739.60,545116),('1','153','186519','321',323.00,360.00,0.00,2316.46,748216.58,826020.80,77804.22,545686),('1','153','186737','321',323.00,360.00,0.00,2079.35,671630.05,744174.00,72543.95,546247),('1','153','186967','321',323.00,360.00,0.00,2575.33,831831.59,919529.00,87697.41,546817),('1','153','187149','321',323.00,360.00,0.00,3471.55,1121310.65,1230115.80,108805.15,547309),('1','153','187335','321',323.00,360.00,0.00,2743.32,886092.36,976671.20,90578.84,547795),('1','153','187561','321',323.00,360.00,0.00,2981.24,962940.52,1062011.40,99070.88,548392),('1','153','187784','321',323.00,360.00,0.00,256.24,82765.52,92246.40,9480.88,548985),('1','153','187863','321',323.00,360.00,0.00,2805.45,906160.35,1002143.80,95983.45,549183),('1','153','188029','321',323.00,360.00,0.00,3586.52,1158445.96,1281077.00,122631.04,549608),('1','153','188209','321',323.00,360.00,0.00,1767.75,570983.25,631420.00,60436.75,550086),('1','153','188358','321',323.00,360.00,0.00,1851.20,597937.60,662144.00,64206.40,550474),('1','153','188405','321',323.00,360.00,0.00,2841.03,917652.69,1015528.00,97875.31,550603),('1','153','188594','321',323.00,360.00,0.00,1466.99,473837.77,524763.60,50925.83,551076),('1','153','188699','321',323.00,360.00,0.00,1729.76,558712.48,616461.40,57748.92,551345),('1','153','188841','321',323.00,360.00,0.00,3723.15,1202577.45,1314345.64,111768.19,551716),('1','153','188990','321',323.00,360.00,0.00,645.74,208574.02,232466.40,23892.38,552124),('1','153','189072','321',323.00,360.00,0.00,3308.45,1068629.35,1165649.04,97019.69,552329),('1','153','189188','321',323.00,360.00,0.00,3032.18,979394.14,1066603.92,87209.78,552645),('1','153','189396','321',323.00,360.00,0.00,1037.81,335212.63,364261.20,29048.57,553194),('1','153','189401','321',323.00,360.00,0.00,4176.41,1348980.43,1469991.60,121011.17,553205),('1','153','189607','321',323.00,360.00,0.00,2160.62,697880.26,758177.52,60297.26,553732),('1','153','189728','321',323.00,360.00,0.00,1979.35,639330.05,693233.04,53902.99,554030),('1','153','189802','321',323.00,360.00,0.00,4538.13,1465815.99,1604658.64,138842.65,554237),('1','153','190020','321',323.00,360.00,0.00,4426.45,1429743.35,1543563.36,113820.01,554809),('1','153','190137','321',323.00,360.00,0.00,2486.83,803246.09,869255.52,66009.43,555105),('1','153','190196','321',323.00,360.00,0.00,5357.51,1730475.73,1862401.44,131925.71,555269),('1','153','190384','321',323.00,360.00,0.00,1830.88,591374.24,641968.56,50594.32,555760),('1','153','190419','321',323.00,360.00,0.00,6206.17,2004592.91,2169254.64,164661.73,555853),('1','153','190663','321',323.00,360.00,0.00,1945.95,628541.85,677595.60,49053.75,556498),('1','153','190666','321',323.00,360.00,0.00,5994.09,1936091.07,2089761.36,153670.29,556503),('1','153','190879','321',323.00,360.00,0.00,1434.88,463466.24,503032.80,39566.56,557063),('1','153','191004','321',323.00,360.00,0.00,2716.48,877423.04,960864.00,83440.96,557384),('1','153','191113','321',323.00,360.00,0.00,3973.29,1283372.67,1398577.92,115205.25,557659),('1','153','191263','321',323.00,360.00,0.00,681.59,220153.57,238517.28,18363.71,558073),('1','153','191304','321',323.00,360.00,0.00,4731.79,1528368.17,1640420.40,112052.23,558164),('1','153','191490','321',323.00,360.00,0.00,1439.15,464845.45,500400.96,35555.51,558671),('1','153','191574','321',323.00,360.00,0.00,3304.17,1067246.91,1162050.00,94803.09,558880),('1','153','191698','321',323.00,360.00,0.00,3354.05,1083358.15,1178137.20,94779.05,559228),('1','153','191927','321',323.00,360.00,0.00,3539.52,1143264.96,1240711.20,97446.24,559840),('1','153','192187','321',323.00,360.00,0.00,1356.84,438259.32,475802.40,37543.08,560514),('1','153','192236','321',323.00,360.00,0.00,1852.16,598247.68,646231.44,47983.76,560645),('1','153','192330','321',323.00,360.00,0.00,3589.67,1159463.41,1251462.00,91998.59,560895),('1','153','192554','321',323.00,360.00,0.00,842.83,267961.49,295119.60,27158.11,561486),('1','153','192624','321',317.00,360.00,0.00,2392.15,758311.55,836888.40,78576.85,561653),('1','153','192744','321',317.00,360.00,0.00,4149.68,1315448.56,1439580.24,124131.68,561983),('1','153','192946','321',317.00,360.00,0.00,3964.69,1256806.73,1374131.76,117325.03,562508),('1','153','193158','321',317.00,360.00,0.00,2962.39,939077.63,1044959.52,105881.89,563069),('1','153','193452','321',317.00,360.00,0.00,2494.78,790845.26,879868.80,89023.54,563824),('1','153','193614','321',317.00,360.00,0.00,2738.96,868250.32,960260.88,92010.56,564269),('1','153','193837','321',317.00,360.00,0.00,731.39,231850.63,257703.60,25852.97,564825),('1','153','193839','321',317.00,360.00,0.00,3166.45,1003764.65,1117972.80,114208.15,564827),('1','153','194072','321',317.00,360.00,0.00,3070.33,973294.61,1083412.08,110117.47,565405),('1','153','194277','321',317.00,360.00,0.00,3415.48,1082707.16,1206326.64,123619.48,565948),('1','153','194477','321',317.00,360.00,0.00,3647.76,1156339.92,1287609.72,131269.80,566442),('1','153','194659','321',317.00,360.00,0.00,3384.29,1072819.93,1200245.80,127425.87,566910),('1','153','195013','321',317.00,360.00,0.00,3234.17,1033850.95,1136923.20,103072.25,567835),('1','153','195070','321',323.00,360.00,0.00,3766.06,1216437.38,1319688.40,103251.02,567991),('1','153','195292','321',323.00,360.00,0.00,957.28,325433.71,332135.08,6701.37,568565),('1','153','195509','321',360.00,360.00,0.00,1912.05,635143.40,652756.50,17613.10,569121),('1','153','195512','321',323.00,348.00,0.00,3163.90,1021939.70,1075768.80,53829.10,569127),('1','153','195766','321',323.00,348.00,0.00,1593.69,514761.87,546970.32,32208.45,569755),('1','153','195915','321',323.00,348.00,0.00,1566.10,496453.70,536935.74,40482.04,570129),('1','153','195991','321',317.00,348.00,0.00,3651.38,1157487.46,1252872.84,95385.38,570332),('1','153','196251','321',317.00,348.00,0.00,1324.07,419730.19,453031.32,33301.13,570968),('1','153','196372','321',317.00,348.00,0.00,1852.13,587125.21,637515.84,50390.63,571292),('1','153','196436','321',317.00,348.00,0.00,4004.39,1269391.63,1369763.58,100371.95,571464),('1','153','196653','321',317.00,348.00,0.00,4592.35,1455774.95,1566689.48,110914.53,572018),('1','153','197004','321',317.00,348.00,0.00,1844.16,584598.72,612591.78,27993.06,572937),('1','153','197017','321',317.00,348.00,0.00,4608.37,1460853.29,1544081.76,83228.47,572971),('1','153','197242','321',317.00,348.00,0.00,1639.97,519870.49,548742.42,28871.93,573557),('1','153','197243','321',317.00,348.00,0.00,1813.44,574860.48,610182.22,35321.74,573558),('1','153','197287','321',317.00,348.00,0.00,3555.17,1126988.89,1204066.58,77077.69,573685),('1','153','197511','321',317.00,348.00,0.00,3727.55,1181633.35,1262802.66,81169.31,574159),('1','153','197859','321',317.00,348.00,0.00,1119.18,354780.06,372314.64,17534.58,575090),('1','153','198200','321',317.00,348.00,0.00,2393.48,758733.16,823537.50,64804.34,575958),('1','153','198212','321',317.00,348.00,0.00,2964.85,939857.45,1020680.62,80823.17,575984),('1','153','198349','321',317.00,348.00,0.00,2559.55,811377.35,879252.72,67875.37,576355),('1','153','198556','321',317.00,348.00,0.00,2825.76,908404.17,954287.90,45883.73,576904),('1','153','198838','321',322.00,348.00,0.00,3381.56,1088862.32,1146510.44,57648.12,577583),('1','153','199079','321',322.00,348.00,0.00,3208.27,1017021.59,1082823.56,65801.97,578226),('1','153','199197','321',317.00,348.00,0.00,2015.44,638894.48,672154.32,33259.84,578509),('1','153','199436','321',317.00,348.00,0.00,1633.65,517867.05,564680.92,46813.87,579097),('1','153','199444','321',317.00,348.00,0.00,3261.33,1033841.61,1109019.80,75178.19,579113),('1','153','199652','321',317.00,348.00,0.00,2644.32,838249.44,900327.12,62077.68,579644),('1','153','199857','321',317.00,348.00,0.00,2773.96,879345.32,945441.84,66096.52,580134),('1','153','200127','321',317.00,348.00,0.00,2815.67,895372.44,951959.58,56587.14,580831),('1','153','200285','321',322.00,348.00,0.00,3477.00,1084824.00,1187272.00,102448.00,581257),('1','153','200481','321',312.00,348.00,0.00,3160.02,985926.24,1070700.08,84773.84,581770),('1','153','200683','321',312.00,348.00,0.00,4920.25,1535118.00,1665270.20,130152.20,582299),('1','153','200994','321',312.00,348.00,0.00,2604.53,812613.36,887230.82,74617.46,583074),('1','153','201090','321',312.00,348.00,0.00,1165.10,363511.20,397787.40,34276.20,583333),('1','153','201096','321',312.00,348.00,0.00,3543.21,1105481.52,1212668.68,107187.16,583349),('1','153','201299','321',312.00,348.00,0.00,2231.76,696309.12,768372.78,72063.66,583866),('1','153','201467','321',312.00,348.00,0.00,1296.45,404492.40,446458.60,41966.20,584312),('1','153','201496','321',312.00,348.00,0.00,2218.19,692075.28,747647.42,55572.14,584377),('1','153','201743','321',312.00,348.00,0.00,1443.23,450287.76,494444.04,44156.28,585047),('1','153','201754','321',312.00,348.00,0.00,3496.64,1090951.68,1202645.12,111693.44,585069),('1','153','202021','321',312.00,348.00,0.00,788.97,246158.64,273131.56,26972.92,585767),('1','153','202113','321',312.00,348.00,0.00,2640.13,823720.56,903212.04,79491.48,586000),('1','153','202251','321',312.00,348.00,0.00,2901.03,905121.36,995753.74,90632.38,586350),('1','153','202419','321',312.00,348.00,0.00,2025.13,631840.56,695996.24,64155.68,586787),('1','153','202569','321',312.00,348.00,0.00,1715.23,535151.76,584188.64,49036.88,587164),('1','153','202640','321',312.00,348.00,0.00,3997.45,1247204.40,1337908.54,90704.14,587352),('1','153','202842','321',312.00,348.00,0.00,0.00,0.00,0.00,0.00,587874),('1','153','202867','321',360.00,360.00,0.00,2158.04,673308.48,763875.24,90566.76,587928),('1','153','203042','321',312.00,360.00,0.00,1443.69,450431.28,510423.12,59991.84,588389),('1','153','203097','321',312.00,360.00,0.00,3513.78,1096299.36,1237252.80,140953.44,588543),('1','153','203311','321',312.00,360.00,0.00,3339.58,1041948.96,1186543.20,144594.24,589104),('1','153','203516','321',312.00,360.00,0.00,3191.94,995885.28,1131417.36,135532.08,589620),('1','153','203732','321',312.00,360.00,0.00,3570.78,1114083.36,1263660.00,149576.64,590172),('1','153','203966','321',312.00,360.00,0.00,3371.40,1051876.80,1181241.60,129364.80,590774),('1','153','204182','321',312.00,360.00,0.00,401.51,125271.12,144435.60,19164.48,591351),('1','153','204249','321',312.00,360.00,0.00,2013.53,645639.96,716465.76,70825.80,591509),('1','153','204373','321',322.00,360.00,0.00,2719.44,875659.68,962280.00,86620.32,591847),('1','153','204628','321',322.00,360.00,0.00,2631.75,847423.50,931458.00,84034.50,592486),('1','153','204824','321',322.00,360.00,0.00,2717.56,875054.32,960896.64,85842.32,592966),('1','153','205029','321',322.00,360.00,0.00,3492.88,1124707.36,1237248.96,112541.60,593489),('1','153','205243','321',322.00,360.00,0.00,3379.97,1088350.34,1193134.80,104784.46,594040),('1','153','205463','321',322.00,360.00,0.00,3064.24,986685.28,1086665.76,99980.48,594610),('1','153','205718','321',322.00,360.00,0.00,3400.89,1095086.58,1208520.24,113433.66,595274),('1','153','205937','321',322.00,376.00,0.00,598.84,225163.84,219163.84,-6000.00,595837),('1','153','206000','321',376.00,376.00,0.00,2032.57,700827.64,755893.12,55065.48,595991),('1','153','206153','321',322.00,376.00,0.00,2564.11,825643.42,944426.46,118783.04,596383),('1','153','206346','321',322.00,376.00,0.00,1414.57,455491.54,530338.72,74847.18,596884),('1','153','206548','321',322.00,376.00,0.00,1066.66,343464.52,396693.16,53228.64,597402),('1','153','206559','321',322.00,376.00,0.00,3452.91,1111837.02,1271268.06,159431.04,597427),('1','153','206789','321',322.00,376.00,0.00,1419.56,457098.32,528234.86,71136.54,598016),('1','153','206942','321',322.00,376.00,0.00,1378.43,443854.46,506019.68,62165.22,598413),('1','153','207008','321',322.00,376.00,0.00,3111.44,1001883.68,1154494.04,152610.36,598592),('1','153','207235','321',322.00,376.00,0.00,4085.94,1315672.68,1499963.94,184291.26,599175),('1','153','207475','321',322.00,376.00,0.00,3309.90,1065787.80,1207845.90,142058.10,599793),('1','153','207647','321',322.00,376.00,0.00,975.73,314185.06,354176.38,39991.32,600229),('1','153','207703','321',384.00,384.00,0.00,4717.70,1619705.88,1771281.00,151575.12,600363),('1','153','207899','321',332.00,384.00,0.00,5227.11,1735400.52,1950358.93,214958.41,600868),('1','153','208102','321',332.00,384.00,0.00,4764.43,1581790.76,1799659.81,217869.05,601390),('1','153','208310','321',332.00,384.00,0.00,4126.44,1369978.08,1543646.72,173668.64,601922),('1','153','208563','321',332.00,384.00,0.00,3490.22,1158753.04,1300705.88,141952.84,602563),('1','153','208714','321',332.00,384.00,0.00,987.89,327979.48,375847.43,47867.95,602970),('1','153','208744','321',332.00,384.00,0.00,6608.84,2204866.36,2448502.98,243636.62,603047),('1','153','208999','321',400.00,400.00,0.00,3266.94,1306776.00,1285514.64,-21261.36,603672),('1','153','209225','321',400.00,400.00,0.00,4242.96,1697184.00,1661027.52,-36156.48,604251),('1','153','209423','321',400.00,400.00,0.00,4509.01,1803604.00,1770388.00,-33216.00,604766),('1','153','209631','321',400.00,400.00,0.00,3448.99,1379596.00,1346188.00,-33408.00,605301),('1','153','209813','321',400.00,400.00,0.00,660.50,264200.00,128916.00,-135284.00,605774),('1','153','209854','321',382.00,420.00,0.00,2693.01,915623.40,1114382.20,198758.80,605876),('1','153','210089','321',340.00,420.00,0.00,3054.28,1038455.20,1237631.56,199176.36,606490),('1','153','210302','321',340.00,420.00,0.00,2877.79,978448.60,1184237.80,205789.20,607036),('1','153','210509','321',340.00,420.00,0.00,3280.28,1169585.80,1376092.40,206506.60,607582),('1','153','210723','321',382.00,420.00,0.00,3261.89,1246041.98,1344347.60,98305.62,608144),('1','153','210944','321',382.00,420.00,0.00,3562.39,1360832.98,1454176.56,93343.58,608709),('1','153','211159','321',424.00,424.00,0.00,3869.78,1640786.72,1624467.84,-16318.88,609263),('1','153','211360','321',424.00,424.00,0.00,6775.76,2634260.18,2792888.33,158628.15,609787),('1','153','211607','321',382.00,424.00,0.00,4190.39,1600728.98,1723448.59,122719.61,610428),('1','153','211765','321',382.00,424.00,0.00,5014.60,1915577.20,2043554.90,127977.70,610826),('1','153','211975','321',382.00,424.00,0.00,3339.19,1275570.58,1356980.78,81410.20,611375),('1','153','212224','321',382.00,424.00,0.00,4073.44,1556054.08,1669567.47,113513.39,612020),('1','153','212446','321',382.00,424.00,0.00,1388.23,530303.86,572527.30,42223.44,612613),('1','153','212538','321',382.00,424.00,0.00,2576.47,984211.54,1065495.28,81283.74,612845),('1','153','212653','321',382.00,424.00,0.00,3535.93,1350725.26,1468111.14,117385.88,613165),('1','153','212855','321',382.00,424.00,0.00,3133.68,1197065.76,1316492.32,119426.56,613686),('1','153','213115','321',382.00,424.00,0.00,2605.23,995197.86,1086867.26,91669.40,614368),('1','153','213352','321',382.00,424.00,0.00,387.53,148036.46,164191.72,16155.26,614977),('1','153','213383','321',382.00,424.00,0.00,4056.42,1549552.44,1704687.08,155134.64,615057),('1','153','213620','321',382.00,424.00,0.00,1738.92,664267.44,718127.32,53859.88,615688),('1','153','213742','321',382.00,424.00,0.00,2582.11,986366.02,1079465.24,93099.22,615997),('1','153','213870','321',382.00,424.00,0.00,4688.56,1791029.92,1956427.18,165397.26,616342),('1','153','214110','321',382.00,424.00,0.00,2645.52,1010588.64,1098006.92,87418.28,616948),('1','153','214333','321',382.00,424.00,0.00,3454.01,1319431.82,1454080.38,134648.56,617537),('1','153','214475','321',382.00,424.00,0.00,846.30,323286.60,354981.20,31694.60,617909),('1','153','214551','321',382.00,424.00,0.00,4187.32,1599556.24,1752859.82,153303.58,618089),('1','153','214759','321',382.00,424.00,0.00,1077.13,411463.66,453392.12,41928.46,618653),('1','153','214865','321',382.00,424.00,0.00,2468.23,942863.86,1039335.52,96471.66,618920),('1','153','214986','321',382.00,424.00,0.00,4681.15,1788199.30,1948998.20,160798.90,619247),('1','153','215212','321',382.00,424.00,0.00,3891.80,1486667.60,1628068.20,141400.60,619823),('1','153','215429','321',382.00,424.00,0.00,3628.31,1501087.00,1564206.08,63119.08,620382),('1','153','215662','321',382.00,440.00,0.00,3418.98,1306050.36,1486114.20,180063.84,620986),('1','153','215894','321',382.00,440.00,0.00,3531.67,1349097.94,1528450.10,179352.16,621574),('1','153','216088','321',382.00,440.00,0.00,1581.86,604270.52,674463.40,70192.88,622083),('1','153','216233','321',382.00,440.00,0.00,1573.82,632675.64,686045.80,53370.16,622448),('1','153','216308','321',440.00,440.00,0.00,4370.79,1923147.60,1873820.85,-49326.75,622652),('1','153','216540','321',440.00,440.00,0.00,3300.92,1326969.84,1424487.30,97517.46,623273),('1','153','216867','321',402.00,440.00,0.00,3346.96,1345477.92,1444482.40,99004.48,624115),('1','153','217009','321',472.00,472.00,0.00,2759.83,1302639.76,1286877.84,-15761.92,624492),('1','153','217260','321',472.00,472.00,0.00,3062.32,1445415.04,1421852.16,-23562.88,625162),('1','153','217510','321',472.00,472.00,0.00,3282.56,1325589.52,1528507.52,202918.00,625798),('1','153','217789','321',402.00,472.00,0.00,2585.81,1039495.62,1203446.32,163950.70,626526),('1','153','217967','321',402.00,472.00,0.00,100.44,40376.88,46870.72,6493.84,627011),('1','153','218027','321',402.00,472.00,0.00,2531.06,1080762.62,1184196.32,103433.70,627147),('1','153','218309','321',427.00,472.00,0.00,2324.07,992377.89,1083983.76,91605.87,627899),('1','153','218434','321',427.00,472.00,0.00,1215.55,519039.85,566756.56,47716.71,628237),('1','153','218566','321',427.00,472.00,0.00,1410.76,602394.52,659846.72,57452.20,628567),('1','153','218664','321',427.00,472.00,0.00,2725.97,1163989.19,1267876.72,103887.53,628832),('1','153','218894','321',427.00,472.00,0.00,3137.85,1339861.95,1461193.20,121331.25,629437),('1','153','219108','321',460.00,460.00,0.00,2976.69,1369277.40,1357583.80,-11693.60,629989),('1','153','219332','321',460.00,460.00,0.00,1963.95,884326.17,898607.00,14280.83,630571),('1','153','219532','321',427.00,460.00,0.00,726.16,310070.32,333293.60,23223.28,631104),('1','153','219573','321',427.00,460.00,0.00,2474.64,1056671.28,1128484.20,71812.92,631213),('1','153','219794','321',427.00,460.00,0.00,2423.52,1034843.04,1109249.20,74406.16,631795),('1','153','220018','321',427.00,460.00,0.00,2845.65,1215092.55,1299281.80,84189.25,632394),('1','153','220224','321',427.00,460.00,0.00,3033.66,1295372.82,1381942.80,86569.98,632937),('1','153','220451','321',427.00,460.00,0.00,2291.64,978530.28,1041484.40,62954.12,633530),('1','153','220672','321',427.00,460.00,0.00,4479.33,1912673.91,2036224.20,123550.29,634102),('1','153','220891','321',427.00,460.00,0.00,0.00,0.00,0.00,0.00,634674),('1','153','220892','321',427.00,460.00,0.00,3002.09,1379307.11,1367913.32,-11393.79,634675),('1','153','221124','321',460.00,460.00,0.00,2993.81,1354689.17,1344903.08,-9786.09,635276),('1','153','221340','321',427.00,460.00,0.00,1490.53,636456.31,672203.80,35747.49,635840),('1','153','221371','321',427.00,460.00,0.00,5157.41,2202214.07,2315484.92,113270.85,635923),('1','153','221600','321',427.00,460.00,0.00,6012.11,2567170.97,2705810.60,138639.63,636524),('1','153','221811','321',427.00,460.00,0.00,4575.85,1953887.95,2067043.00,113155.05,637071),('1','153','222044','321',427.00,460.00,0.00,4695.80,2005106.60,2130212.00,125105.40,637681),('1','153','222257','321',427.00,460.00,0.00,2784.20,1188853.40,1255520.00,66666.60,638216),('1','153','222406','321',427.00,460.00,0.00,2198.61,938806.47,992220.60,53414.13,638596),('1','153','222474','321',427.00,460.00,0.00,5635.37,2406302.99,2522082.20,115779.21,638777),('1','153','222716','321',427.00,460.00,0.00,6239.39,2664219.53,2792534.36,128314.83,639419),('1','153','223130','321',427.00,460.00,0.00,6300.46,2690296.42,2797663.60,107367.18,640525),('1','153','223161','321',427.00,460.00,0.00,0.00,0.00,0.00,0.00,640594),('1','153','223184','321',427.00,460.00,0.00,2102.81,897899.87,936116.60,38216.73,640635),('1','153','223190','321',480.00,480.00,0.00,1936.07,864641.69,908636.82,43995.13,640642),('1','153','223310','321',447.00,480.00,0.00,3107.96,1389258.12,1466900.70,77642.58,640936),('1','153','223403','321',447.00,480.00,0.00,4870.55,2177135.85,2290577.82,113441.97,641186),('1','153','223627','321',447.00,480.00,0.00,6244.82,2791434.54,2922100.26,130665.72,641752),('1','153','223875','321',447.00,480.00,0.00,5835.70,2608557.90,2746105.50,137547.60,642383),('1','153','224064','321',447.00,480.00,0.00,4030.53,1801646.91,1889028.54,87381.63,642885),('1','153','224258','321',447.00,480.00,0.00,1417.93,647994.01,665810.40,17816.39,643387),('1','153','224292','321',540.00,540.00,0.00,3350.03,1809016.20,1754728.20,-54288.00,643477),('1','153','224518','321',540.00,540.00,0.00,4391.97,2100000.65,2291163.80,191163.15,644078),('1','153','224763','321',457.00,540.00,0.00,5121.03,2340310.71,2657196.20,316885.49,644703),('1','153','225019','321',457.00,540.00,0.00,5212.24,2568990.19,2667864.00,98873.81,645342),('1','153','225245','321',457.00,540.00,0.00,5160.59,2358389.63,2599997.00,241607.37,645947),('1','153','225451','321',457.00,540.00,0.00,1118.82,511300.74,566202.80,54902.06,646471),('1','153','225469','321',457.00,540.00,0.00,6199.57,2833203.49,3141639.80,308436.31,646519),('1','153','225678','321',457.00,540.00,0.00,5731.77,2984978.28,2967103.60,-17874.68,647058),('1','153','225960','321',457.00,540.00,0.00,4592.47,2098758.79,2380873.80,282115.01,647795),('1','153','226226','321',457.00,540.00,0.00,4972.29,2272336.53,2594436.60,322100.07,648485),('1','153','226467','321',457.00,540.00,0.00,2273.74,1039099.18,1179159.60,140060.42,649100),('1','153','226654','321',457.00,540.00,0.00,2331.81,1123932.42,1205037.40,81104.98,649585),('1','153','226717','321',482.00,540.00,0.00,5103.28,2459780.96,2655091.20,195310.24,649750),('1','153','226940','321',482.00,540.00,0.00,5415.14,2610097.48,2796635.60,186538.12,650336),('1','153','227171','321',482.00,540.00,0.00,6128.63,2953999.66,3172660.20,218660.54,650933),('1','153','227372','321',482.00,540.00,0.00,5536.05,2668376.10,2869747.00,201370.90,651432),('1','153','227587','321',482.00,540.00,0.00,0.00,0.00,0.00,0.00,652002),('1','153','227595','321',482.00,540.00,0.00,5602.83,2700564.06,2965188.80,264624.74,652022),('1','153','227834','321',482.00,540.00,0.00,5109.83,2462938.06,2701252.18,238314.12,652642),('1','153','228104','321',482.00,540.00,0.00,6239.46,3007419.72,3298851.20,291431.48,653360),('1','153','228337','321',482.00,540.00,0.00,6758.29,3257495.78,3556815.68,299319.90,653963),('1','153','228518','321',482.00,540.00,0.00,1023.89,493514.98,544540.60,51025.62,654419),('1','153','228599','321',482.00,540.00,0.00,0.00,0.00,0.00,0.00,654607),('1','153','228602','321',482.00,540.00,0.00,3434.56,1655457.92,1811183.80,155725.88,654614),('1','153','228744','321',482.00,540.00,0.00,5663.16,2729643.12,2987927.28,258284.16,654992),('1','153','228923','321',482.00,540.00,0.00,6296.17,3034753.94,3320586.60,285832.66,655451),('1','153','229156','321',482.00,540.00,0.00,6506.06,3135920.92,3436767.62,300846.70,656071),('1','153','229403','321',482.00,540.00,0.00,0.00,0.00,0.00,0.00,656703),('1','153','229418','321',540.00,540.00,0.00,1228.58,663433.20,657659.08,-5774.12,656730),('1','153','229422','321',584.00,584.00,0.00,1587.22,926936.48,883747.31,-43189.17,656738),('1','153','229522','321',584.00,584.00,0.00,0.00,0.00,0.00,0.00,656994),('1','153','229536','321',584.00,584.00,0.00,3997.36,2006674.72,2218361.74,211687.02,657034),('1','153','229653','321',502.00,584.00,0.00,6139.85,3082204.70,3382138.09,299933.39,657339),('1','153','229872','321',502.00,584.00,0.00,6795.01,3411095.02,3765582.57,354487.55,657906),('1','153','230070','321',502.00,584.00,0.00,1261.89,633468.78,685360.45,51891.67,658421),('1','153','230077','321',502.00,584.00,0.00,6477.36,3251634.72,3551295.44,299660.72,658431),('1','153','230266','321',502.00,584.00,0.00,0.00,0.00,0.00,0.00,658922),('1','153','230276','321',502.00,584.00,0.00,6340.16,3399264.92,3456644.79,57379.87,658939),('1','153','230503','321',584.00,584.00,0.00,1977.77,1155017.68,1111853.68,-43164.00,659537),('1','153','230510','321',584.00,584.00,0.00,4815.15,2812047.60,2704902.76,-107144.84,659552),('1','153','230771','321',584.00,584.00,0.00,5723.83,3342716.72,3204574.32,-138142.40,660229),('1','153','231063','321',584.00,584.00,0.00,2899.23,1693150.32,1610539.88,-82610.44,660993),('1','153','231353','321',584.00,584.00,0.00,2599.18,1517921.12,1493221.52,-24699.60,661784),('1','153','231531','321',584.00,584.00,0.00,0.00,0.00,0.00,0.00,662245),('1','153','231534','321',584.00,584.00,0.00,1989.51,1137999.72,1140895.44,2895.72,662252),('1','153','231635','321',572.00,584.00,0.00,3226.70,1845672.40,1856774.08,11101.68,662508),('1','153','231874','321',572.00,584.00,0.00,949.18,543865.28,543895.52,30.24,663170),('1','153','232010','321',584.00,584.00,0.00,2422.48,1414728.32,1396404.80,-18323.52,663525),('1','153','232084','321',584.00,584.00,0.00,3791.03,2206493.44,2178372.40,-28121.04,663728),('1','153','232315','321',572.00,584.00,0.00,3889.64,2224874.08,2226895.36,2021.28,664321),('1','153','232569','321',572.00,584.00,0.00,2325.89,1330409.08,1327822.72,-2586.36,665002),('1','153','232746','321',572.00,584.00,0.00,1369.27,783222.44,786237.68,3015.24,665456),('1','153','232824','321',572.00,584.00,0.00,4462.13,2552338.36,2554276.00,1937.64,665675),('1','153','233093','321',572.00,584.00,0.00,0.00,0.00,0.00,0.00,666375),('1','153','233094','321',572.00,584.00,0.00,4443.43,2541641.96,2536462.16,-5179.80,666376),('1','153','233354','321',624.00,624.00,0.00,3835.74,2393501.76,2343986.64,-49515.12,667058),('1','153','233582','321',624.00,624.00,0.00,4915.95,3067552.80,2985805.80,-81747.00,667658),('1','153','233822','321',624.00,624.00,0.00,4256.79,2656236.96,2600591.76,-55645.20,668286),('1','153','234030','321',624.00,624.00,0.00,4193.89,2616987.36,2536929.84,-80057.52,668837),('1','153','234348','321',624.00,624.00,0.00,3035.11,1893908.64,1837151.40,-56757.24,669652),('1','153','234517','321',624.00,624.00,0.00,0.00,0.00,0.00,0.00,670124),('1','153','234534','321',542.00,624.00,0.00,1430.18,775157.56,869436.96,94279.40,670173),('1','153','234592','321',542.00,624.00,0.00,5003.18,2711723.56,3029680.68,317957.12,670304),('1','153','234816','321',542.00,624.00,0.00,4564.85,2474148.70,2769322.20,295173.50,670909),('1','153','235046','321',542.00,624.00,0.00,4877.43,2643567.06,2959325.64,315758.58,671547),('1','153','235280','321',542.00,624.00,0.00,4556.50,2469623.00,2753847.48,284224.48,672147),('1','153','235530','321',542.00,624.00,0.00,4331.36,2347597.12,2624261.64,276664.52,672771),('1','153','235728','321',542.00,624.00,0.00,0.00,0.00,0.00,0.00,673301),('1','153','235815','321',542.00,624.00,0.00,1262.12,684069.04,764026.44,79957.40,673508),('1','153','235839','321',640.00,640.00,0.00,4242.81,2715398.40,2657165.36,-58233.04,673574),('1','153','236013','321',640.00,640.00,0.00,677.68,403762.48,418152.38,14389.90,674040),('1','153','236171','321',542.00,640.00,0.00,3889.38,2302512.96,2422462.22,119949.26,674466),('1','153','236219','321',592.00,640.00,0.00,4622.68,2736626.56,2910991.36,174364.80,674595),('1','153','236487','321',592.00,640.00,0.00,4611.91,2730250.72,2892382.50,162131.78,675305),('1','153','236715','321',592.00,640.00,0.00,6087.74,3603942.08,3794989.32,191047.24,675896),('1','153','236934','321',592.00,640.00,0.00,4846.19,2868944.48,3036332.60,167388.12,676461),('1','153','237149','321',592.00,640.00,0.00,793.83,469947.36,498148.70,28201.34,677015),('1','153','237246','321',592.00,640.00,0.00,0.00,0.00,0.00,0.00,677243),('1','153','237255','321',592.00,640.00,0.00,3200.98,1894980.16,2008636.06,113655.90,677266),('1','153','237363','321',592.00,640.00,0.00,4265.77,2525335.84,2681219.16,155883.32,677562),('1','153','237585','321',592.00,640.00,0.00,4054.72,2615928.80,2600195.42,-15733.38,678146),('1','153','237845','321',640.00,640.00,0.00,4304.18,2754675.20,2731281.68,-23393.52,678824),('1','153','238105','321',640.00,640.00,0.00,4168.86,2668070.40,2637799.08,-30271.32,679490),('1','153','238332','321',640.00,640.00,0.00,3080.17,1971308.80,1961621.92,-9686.88,680073),('1','153','238593','321',640.00,640.00,0.00,1444.37,924396.80,920094.80,-4302.00,680759),('1','153','238703','321',640.00,640.00,0.00,0.00,0.00,0.00,0.00,681029),('1','153','238705','321',640.00,640.00,0.00,2413.46,1428768.32,1533822.50,105054.18,681033),('1','153','238816','321',592.00,640.00,0.00,3489.90,2066020.80,2219106.30,153085.50,681331),('1','153','239051','321',592.00,640.00,0.00,3867.68,2289666.56,2453783.60,164117.04,681936),('1','153','239276','321',592.00,640.00,0.00,3259.32,1929517.44,2072828.40,143310.96,682528),('1','153','239504','321',592.00,640.00,0.00,3101.42,1836040.64,1974165.68,138125.04,683120),('1','153','239765','321',592.00,640.00,0.00,3024.56,1984111.36,1966887.40,-17223.96,683797),('1','153','239968','321',656.00,656.00,0.00,2961.79,1942934.24,1923543.18,-19391.06,684329),('1','153','240173','321',656.00,656.00,0.00,1867.50,1225080.00,1213840.20,-11239.80,684859),('1','153','240358','321',656.00,656.00,0.00,0.00,0.00,0.00,0.00,685329),('1','153','240359','321',656.00,656.00,0.00,973.07,595518.84,631761.90,36243.06,685330),('1','153','240430','321',640.00,640.00,0.00,3711.64,2375449.60,2345290.00,-30159.60,685530),('1','153','240651','321',640.00,640.00,0.00,2646.06,1693478.40,1682763.36,-10715.04,686085),('1','153','240958','321',640.00,640.00,0.00,3328.09,2129977.60,2112092.56,-17885.04,686880),('1','153','241198','321',640.00,640.00,0.00,2625.86,1680550.40,1672729.12,-7821.28,687512),('1','153','241475','321',640.00,640.00,0.00,2891.85,1850784.00,1840614.96,-10169.04,688248),('1','153','241709','321',640.00,640.00,0.00,3404.83,2179091.20,2145850.96,-33240.24,688863),('1','153','241958','321',640.00,640.00,0.00,2602.83,1665811.20,1657027.20,-8784.00,689515),('1','153','242191','321',640.00,640.00,0.00,2556.38,1636083.20,1630808.24,-5274.96,690114),('1','153','242366','321',640.00,640.00,0.00,0.00,0.00,0.00,0.00,690566),('1','153','242416','321',602.00,640.00,0.00,3098.46,1865272.92,1967716.80,102443.88,690691),('1','153','242648','321',602.00,640.00,0.00,3002.10,1807264.20,1910580.24,103316.04,691302),('1','153','242897','321',602.00,640.00,0.00,3228.04,1943280.08,2058599.68,115319.60,691956),('1','153','243137','321',602.00,640.00,0.00,3702.89,2229139.78,2360782.16,131642.38,692571),('1','153','243343','321',602.00,640.00,0.00,3424.66,2061645.32,2185263.76,123618.44,693127),('1','153','243589','321',602.00,640.00,0.00,2977.07,1792196.14,1894944.80,102748.66,693751),('1','153','243817','321',602.00,640.00,0.00,3313.26,1994582.52,2115931.20,121348.68,694346),('1','153','244034','321',602.00,640.00,0.00,2196.59,1322347.18,1399577.60,77230.42,694900),('1','153','244259','321',602.00,640.00,0.00,0.00,0.00,0.00,0.00,695496),('1','153','244277','321',602.00,640.00,0.00,3612.91,2174971.82,2299830.16,124858.34,695533),('1','153','244503','321',602.00,640.00,0.00,2788.61,1678743.22,1777465.28,98722.06,696122),('1','153','244732','321',602.00,640.00,0.00,2456.47,1478794.94,1567699.84,88904.90,696719),('1','153','244958','321',624.00,624.00,0.00,2673.26,1668114.24,1662310.08,-5804.16,697311),('1','153','245199','321',624.00,624.00,0.00,3427.17,2138554.08,2131164.48,-7389.60,697927),('1','153','245423','321',624.00,624.00,0.00,2954.33,1843501.92,1836213.12,-7288.80,698508),('1','153','245662','321',624.00,624.00,0.00,2660.15,1659933.60,1654502.40,-5431.20,699127),('1','153','245964','321',550.00,616.00,0.00,3390.88,1864984.00,2040035.88,175051.88,699899),('1','153','246171','321',550.00,616.00,0.00,1192.04,655622.00,728949.14,73327.14,700440),('1','153','246330','321',550.00,616.00,0.00,2101.96,1156078.00,1286675.94,130597.94,700859),('1','153','246436','321',550.00,616.00,0.00,2680.11,1474060.50,1622697.32,148636.82,701148),('1','153','246685','321',550.00,616.00,0.00,2748.06,1511433.00,1681708.84,170275.84,701803),('1','153','246916','321',550.00,616.00,0.00,3062.22,1684221.00,1840710.24,156489.24,702394),('1','153','247156','321',550.00,616.00,0.00,3126.96,1719828.00,1910143.24,190315.24,703017),('1','153','247384','321',550.00,616.00,0.00,2848.23,1566526.50,1733211.68,166685.18,703589),('1','153','247650','321',550.00,616.00,0.00,2620.58,1441319.00,1601293.32,159974.32,704291),('1','153','247895','321',550.00,616.00,0.00,2553.51,1404430.50,1553713.46,149282.96,704916),('1','153','248138','321',550.00,616.00,0.00,2780.12,1529066.00,1689111.86,160045.86,705547),('1','153','248405','321',550.00,616.00,0.00,176.29,96959.50,108594.64,11635.14,706227),('1','153','248481','321',550.00,616.00,0.00,0.00,0.00,0.00,0.00,706405),('1','153','248487','321',550.00,616.00,0.00,2571.48,1414314.00,1566507.06,152193.06,706421),('1','153','248623','321',550.00,616.00,0.00,2720.64,1496352.00,1663526.90,167174.90,706798),('1','153','248874','321',550.00,616.00,0.00,2351.14,1175570.00,1395178.35,219608.35,707430),('1','153','249089','321',500.00,600.00,0.00,2719.43,1359715.00,1616422.35,256707.35,708002),('1','153','249326','321',500.00,600.00,0.00,2947.49,1473745.00,1757545.05,283800.05,708599),('1','153','249564','321',500.00,600.00,0.00,3339.68,1669840.00,1977550.50,307710.50,709210),('1','153','249827','321',500.00,600.00,0.00,3047.39,1523695.00,1809673.95,285978.95,709891),('1','153','250076','321',500.00,600.00,0.00,3564.52,1782260.00,2124013.20,341753.20,710519),('1','153','250316','321',500.00,600.00,0.00,786.21,393105.00,456538.50,63433.50,711133),('1','153','250413','321',500.00,600.00,0.00,0.00,0.00,0.00,0.00,711348),('1','153','250424','321',547.00,568.00,0.00,2400.82,1313248.54,1358982.16,45733.62,711372),('1','153','250554','321',547.00,568.00,0.00,3678.52,2012150.44,2084409.76,72259.32,711731),('1','153','250784','321',547.00,568.00,0.00,3342.40,1828292.80,1886752.48,58459.68,712336),('1','153','251001','321',547.00,568.00,0.00,4014.01,2195663.47,2262758.80,67095.33,712894),('1','153','251253','321',547.00,568.00,0.00,4027.63,2203113.61,2273160.88,70047.27,713550),('1','153','251505','321',547.00,568.00,0.00,3813.68,2086082.96,2151220.40,65137.44,714208),('1','153','251746','321',547.00,568.00,0.00,3325.64,1819125.08,1879962.80,60837.72,714845),('1','153','251975','321',547.00,568.00,0.00,571.72,312730.84,323932.96,11202.12,715446),('1','153','252107','321',547.00,568.00,0.00,2288.48,1251798.56,1296136.88,44338.32,715759),('1','153','252220','321',547.00,568.00,0.00,3448.78,1886482.66,1947014.80,60532.14,716082),('1','153','252485','321',547.00,568.00,0.00,3153.51,1724969.97,1783278.48,58308.51,716753),('1','153','252693','321',547.00,568.00,0.00,3174.62,1736517.14,1794466.88,57949.74,717308),('1','153','252953','321',547.00,568.00,0.00,3103.78,1697767.66,1753631.20,55863.54,717984),('1','153','253196','321',547.00,568.00,0.00,3214.81,1758501.07,1816623.52,58122.45,718623),('1','153','253534','321',547.00,568.00,0.00,2981.30,1630771.10,1689922.16,59151.06,719465),('1','153','253707','321',547.00,568.00,0.00,2738.35,1497877.45,1548180.40,50302.95,719939),('1','153','253934','321',547.00,568.00,0.00,0.00,0.00,0.00,0.00,720536),('1','153','253949','321',547.00,568.00,0.00,2916.73,1595451.31,1652381.68,56930.37,720565),('1','153','254202','321',547.00,568.00,0.00,2872.85,1571448.95,1624512.80,53063.85,721211),('1','153','254442','321',547.00,568.00,0.00,3034.63,1659942.61,1715287.12,55344.51,721850),('1','153','254679','321',547.00,568.00,0.00,3003.79,1643073.13,1696072.96,52999.83,722453),('1','153','254938','321',547.00,568.00,0.00,2695.92,1474668.24,1527795.60,53127.36,723101),('1','153','255180','321',547.00,568.00,0.00,2597.75,1420969.25,1464861.44,43892.19,723734),('1','153','255575','321',547.00,568.00,0.00,3042.46,1664225.62,1722829.12,58603.50,724671),('1','153','255697','321',547.00,568.00,0.00,3282.05,1795281.35,1856063.84,60782.49,725015),('1','153','255944','321',547.00,568.00,0.00,1031.40,564175.80,580914.00,16738.20,725633),('1','153','256080','321',547.00,568.00,0.00,0.00,0.00,0.00,0.00,725969),('1','153','256083','321',547.00,568.00,0.00,1731.29,947015.63,970348.40,23332.77,725976),('1','153','256197','321',547.00,568.00,0.00,2794.34,1528503.98,1575499.52,46995.54,726263),('1','153','256591','321',547.00,568.00,0.00,2454.35,1342529.45,1390105.28,47575.83,727266),('1','153','256704','321',547.00,568.00,0.00,2289.76,1252498.72,1296122.08,43623.36,727584),('1','153','257007','321',547.00,568.00,0.00,2615.79,1430837.13,1479750.48,48913.35,728340),('1','153','257217','321',547.00,568.00,0.00,3144.92,1720271.24,1773668.24,53397.00,728922),('1','153','257475','321',547.00,568.00,0.00,3181.63,1740351.61,1802203.60,61851.99,729595),('1','153','257476','321',547.00,568.00,0.00,2893.25,1582607.75,1633804.64,51196.89,729596),('1','153','257477','321',547.00,568.00,0.00,2501.24,1368178.28,1415576.48,47398.20,729597),('1','153','257478','321',547.00,568.00,0.00,1372.03,750500.41,778096.72,27596.31,729598),('1','153','257479','321',547.00,568.00,0.00,1117.43,611234.21,631524.80,20290.59,729599),('1','153','257480','321',547.00,568.00,0.00,2968.74,1623900.78,1681693.20,57792.42,729600),('1','153','257481','321',547.00,568.00,0.00,2975.56,1627631.32,1683754.00,56122.68,729601),('1','153','257482','321',547.00,568.00,0.00,2916.17,1595144.99,1653780.56,58635.57,729602),('1','153','257483','321',547.00,568.00,0.00,3005.91,1644232.77,1699800.48,55567.71,729603),('1','153','257484','321',547.00,568.00,0.00,2646.74,1447766.78,1500666.56,52899.78,729604),('1','153','257485','321',547.00,568.00,0.00,2887.47,1579446.09,1630668.72,51222.63,729605),('1','153','257486','321',547.00,568.00,0.00,2573.29,1407589.63,1458223.60,50633.97,729606),('1','153','257487','321',547.00,568.00,0.00,2823.11,1544241.17,1594150.40,49909.23,729607),('1','153','257488','321',547.00,568.00,0.00,886.62,484981.14,501653.76,16672.62,729608),('1','153','257489','321',547.00,568.00,0.00,0.00,0.00,0.00,0.00,729609),('1','153','257490','321',547.00,568.00,0.00,1161.83,635521.01,656965.04,21444.03,729610),('1','153','257491','321',547.00,568.00,0.00,2604.36,1424584.92,1470650.40,46065.48,729611),('1','153','257492','321',547.00,568.00,0.00,2042.75,1117384.25,1159423.28,42039.03,729612),('1','153','257493','321',547.00,568.00,0.00,2240.12,1225345.64,1268382.80,43037.16,729613),('1','153','257494','321',547.00,568.00,0.00,1842.54,1007869.38,1044935.52,37066.14,729614),('1','153','257495','321',547.00,568.00,0.00,2743.64,1500771.08,1539282.32,38511.24,729615),('1','153','257496','321',547.00,568.00,0.00,1930.35,1055901.45,1089270.32,33368.87,729616),('1','153','257497','321',547.00,568.00,0.00,1665.80,911192.60,939486.08,28293.48,729617),('1','153','257498','321',547.00,568.00,0.00,2198.98,1202842.06,1244736.64,41894.58,729618),('1','153','257499','321',547.00,568.00,0.00,2116.17,1157544.99,1199351.76,41806.77,729619),('1','153','257500','321',547.00,568.00,0.00,1651.84,903556.48,936556.00,32999.52,729620),('1','153','257501','321',547.00,568.00,0.00,2130.33,1165290.51,1206261.84,40971.33,729621),('1','153','257502','321',547.00,568.00,0.00,279.07,152651.29,158511.76,5860.47,729622),('1','153','257503','321',547.00,568.00,0.00,0.00,0.00,0.00,0.00,729623),('1','153','257504','321',547.00,568.00,0.00,1262.85,690778.95,716314.80,25535.85,729624),('1','153','257505','321',547.00,568.00,0.00,1937.19,1059642.93,1098396.00,38753.07,729625),('1','153','257506','321',547.00,568.00,0.00,1754.78,959864.66,995179.04,35314.38,729626),('1','153','257507','321',547.00,568.00,0.00,1803.62,986580.14,1019799.68,33219.54,729627),('1','153','257508','321',547.00,568.00,0.00,1682.28,920207.16,955067.04,34859.88,729628),('1','153','257509','321',547.00,568.00,0.00,1972.98,1079220.06,1118008.56,38788.50,729629),('1','153','257510','321',547.00,568.00,0.00,2294.61,1255151.67,1301384.16,46232.49,729630),('1','153','257511','321',547.00,568.00,0.00,1440.76,788095.72,816134.08,28038.36,729631),('1','153','257512','321',547.00,568.00,0.00,1856.72,1015625.84,1054112.96,38487.12,729632),('1','153','257513','321',547.00,568.00,0.00,2638.60,1443314.20,1496863.12,53548.92,729633),('1','153','257514','321',547.00,568.00,0.00,2490.63,1362374.61,1411267.20,48892.59,729634),('1','153','257515','321',547.00,568.00,0.00,2473.23,1352856.81,1403043.12,50186.31,729635),('1','153','257516','321',547.00,568.00,0.00,191.73,104876.31,108902.64,4026.33,729636),('1','153','257517','321',547.00,568.00,0.00,0.00,0.00,0.00,0.00,729637),('1','153','257518','321',547.00,568.00,0.00,2142.46,1171925.62,1210820.32,38894.70,729638),('1','153','257519','321',547.00,568.00,0.00,2051.20,1122006.40,1160860.00,38853.60,729639),('1','153','257520','321',547.00,568.00,0.00,1870.96,0.00,1193541.80,1193541.80,729640),('1','153','257521','321',0.00,640.00,0.00,1646.49,0.00,1053513.60,1053513.60,729641),('1','153','257522','321',0.00,640.00,0.00,2186.96,0.00,1389184.40,1389184.40,729642),('1','153','257523','321',0.00,640.00,0.00,1916.43,0.00,1221025.80,1221025.80,729643),('1','153','257524','321',0.00,640.00,0.00,2121.98,0.00,1354577.20,1354577.20,729644),('1','153','257525','321',0.00,640.00,0.00,1862.86,0.00,1190680.60,1190680.60,729645),('1','153','257526','321',0.00,640.00,0.00,1317.42,0.00,894817.60,894817.60,729646),('1','153','257527','321',0.00,680.00,0.00,1433.33,0.00,951094.40,951094.40,729647),('1','153','257528','321',0.00,680.00,0.00,1888.36,0.00,1276986.80,1276986.80,729648),('1','153','257529','321',0.00,640.00,0.00,1719.41,0.00,1099729.52,1099729.52,729649),('1','153','257530','321',0.00,640.00,0.00,1781.83,0.00,1137737.44,1137737.44,729650),('1','153','257531','321',0.00,640.00,0.00,757.67,0.00,484872.56,484872.56,729651),('1','153','257532','321',0.00,640.00,0.00,0.00,0.00,0.00,0.00,729652),('1','153','257533','321',0.00,640.00,0.00,1026.16,561309.52,655062.40,93752.88,729653),('1','153','257534','321',547.00,640.00,0.00,1658.70,907308.90,1057655.04,150346.14,729654),('1','153','257535','321',547.00,640.00,0.00,1716.02,938662.94,1096190.48,157527.54,729655),('1','153','257536','321',547.00,640.00,0.00,1241.39,679040.33,790841.60,111801.27,729656),('1','153','257537','321',547.00,640.00,0.00,1798.88,983987.36,1147635.44,163648.08,729657),('1','153','257538','321',547.00,640.00,0.00,1888.25,1032872.75,1199790.32,166917.57,729658),('1','153','257539','321',547.00,640.00,0.00,1155.73,632184.31,738498.64,106314.33,729659),('1','153','257540','321',512.00,680.00,0.00,2192.22,1122416.64,1481871.94,359455.30,729660),('1','153','257541','321',512.00,680.00,0.00,2005.21,1026667.52,1358010.38,331342.86,729661),('1','153','257542','321',512.00,680.00,0.00,1816.91,930257.92,1227288.90,297030.98,729662),('1','153','257543','321',512.00,680.00,0.00,1627.25,833152.00,1102692.00,269540.00,729663),('1','153','257544','321',512.00,680.00,0.00,1516.80,906445.50,968718.00,62272.50,729664),('1','153','257545','321',612.00,640.00,0.00,1008.68,617312.16,645495.00,28182.84,729665),('1','153','257546','321',612.00,640.00,0.00,2705.83,1655967.96,1731083.40,75115.44,729666),('1','153','257547','321',612.00,640.00,0.00,5619.05,3438858.60,3570719.20,131860.60,729667),('1','153','257548','321',612.00,640.00,0.00,4145.53,2537064.36,2627647.20,90582.84,729668),('1','153','257549','321',612.00,640.00,0.00,2250.25,1377153.00,1427938.80,50785.80,729669),('1','153','257550','321',612.00,640.00,0.00,1657.00,1014084.00,1054067.80,39983.80,729670),('1','153','257551','321',612.00,640.00,0.00,459.38,281140.56,289309.40,8168.84,729671),('1','153','257552','321',612.00,640.00,0.00,2299.30,1407171.60,1459267.20,52095.60,729672),('1','153','257553','321',612.00,640.00,0.00,1071.94,656027.28,675997.00,19969.72,729673),('1','153','257554','321',612.00,640.00,0.00,1104.16,675745.92,700522.40,24776.48,729674),('1','153','257555','321',612.00,640.00,0.00,2977.54,1822254.48,1879297.20,57042.72,729675),('1','153','257556','321',612.00,640.00,0.00,2078.12,1271809.44,1306188.80,34379.36,729676),('1','153','257557','321',612.00,640.00,0.00,1278.97,782729.64,810130.80,27401.16,729677),('1','153','257558','321',612.00,640.00,0.00,3735.96,2286407.52,2351907.00,65499.48,729678),('1','153','257559','321',612.00,640.00,0.00,1190.88,728818.56,752337.40,23518.84,729679),('1','153','257560','321',612.00,640.00,0.00,1012.80,619833.60,643268.80,23435.20,729680),('1','153','257561','321',612.00,640.00,0.00,3051.77,1867683.24,1925022.80,57339.56,729681),('1','153','257562','321',612.00,640.00,0.00,1716.90,1050742.80,1094062.80,43320.00,729682),('1','153','257563','321',612.00,640.00,0.00,421.60,258019.20,268444.00,10424.80,729683),('1','153','257564','321',612.00,640.00,0.00,1232.56,754326.72,787978.40,33651.68,729684),('1','153','257565','321',612.00,640.00,0.00,1716.56,1050534.72,1098564.40,48029.68,729685),('1','153','257566','321',612.00,640.00,0.00,1396.27,854517.24,892732.80,38215.56,729686),('1','153','257567','321',612.00,640.00,0.00,1419.39,868666.68,908310.60,39643.92,729687),('1','153','257568','321',612.00,640.00,0.00,511.22,82542.12,325381.96,242839.84,729688),('1','153','257569','321',606.00,636.00,0.00,561.66,338119.32,355625.82,17506.50,729689),('1','153','257570','321',602.00,636.00,0.00,1439.80,866759.60,913413.80,46654.20,729690),('1','153','257571','321',602.00,636.00,0.00,1591.54,958107.08,1009093.68,50986.60,729691),('1','153','257572','321',602.00,636.00,0.00,1578.22,950088.44,1000324.50,50236.06,729692),('1','153','257573','321',602.00,636.00,0.00,1088.42,655228.84,690156.56,34927.72,729693),('1','153','257574','321',602.00,636.00,0.00,369.40,222378.80,233948.40,11569.60,729694),('1','153','257575','321',602.00,636.00,0.00,1660.37,999542.74,1055041.18,55498.44,729695),('1','153','257576','321',602.00,636.00,0.00,1676.94,1009517.88,1063632.92,54115.04,729696),('1','153','257577','321',602.00,636.00,0.00,1082.53,651683.06,688345.86,36662.80,729697),('1','153','257578','321',602.00,636.00,0.00,1152.62,693877.24,732600.80,38723.56,729698),('1','153','257579','321',602.00,636.00,0.00,226.42,136304.84,144003.12,7698.28,729699),('1','153','257580','321',602.00,636.00,0.00,1179.32,709950.64,748287.52,38336.88,729700),('1','153','257581','321',602.00,636.00,0.00,1709.91,1029365.82,1082607.76,53241.94,729701),('1','153','257582','321',602.00,636.00,0.00,1843.47,1109768.94,1171054.32,61285.38,729702),('1','153','257583','321',602.00,636.00,0.00,1448.59,872051.18,919852.12,47800.94,729703),('1','153','257584','321',602.00,636.00,0.00,580.14,349244.28,368969.04,19724.76,729704),('1','153','257585','321',602.00,636.00,0.00,2659.06,1600754.12,1690767.04,90012.92,729705),('1','153','257586','321',602.00,636.00,0.00,1066.43,641990.86,674949.48,32958.62,729706),('1','153','257587','321',602.00,636.00,0.00,1280.35,770770.70,813797.92,43027.22,729707),('1','153','257588','321',602.00,636.00,0.00,429.71,258685.42,272811.56,14126.14,729708),('1','153','257589','321',602.00,636.00,0.00,619.27,372800.54,393855.72,21055.18,729709),('1','153','257590','321',602.00,636.00,0.00,1903.65,1145997.30,1205749.40,59752.10,729710),('1','153','257591','321',602.00,636.00,0.00,1344.11,809154.22,854279.76,45125.54,729711),('1','153','257592','321',602.00,636.00,0.00,2013.60,1212187.20,1276855.48,64668.28,729712),('1','153','257593','321',602.00,636.00,0.00,367.73,221373.46,233876.28,12502.82,729713),('1','153','257594','321',602.00,636.00,0.00,1711.86,1030539.72,1086971.96,56432.24,729714),('1','153','257595','321',602.00,636.00,0.00,1369.05,824168.10,864478.80,40310.70,729715),('1','153','257596','321',602.00,636.00,0.00,2437.29,1467248.58,1545745.04,78496.46,729716),('1','153','257597','321',602.00,636.00,0.00,739.88,445407.76,470013.68,24605.92,729717),('1','153','257598','321',602.00,636.00,0.00,1024.48,616736.96,651437.28,34700.32,729718),('1','153','257599','321',602.00,636.00,0.00,1711.07,1030064.14,1084201.98,54137.84,729719),('1','153','257600','321',602.00,636.00,0.00,1744.40,1050128.80,1108778.40,58649.60,729720),('1','153','257601','321',602.00,636.00,0.00,1464.83,881827.66,928281.72,46454.06,729721),('1','153','257602','321',0.00,696.00,0.00,306.64,171822.84,213421.44,41598.60,729722),('1','153','257603','321',602.00,696.00,0.00,1055.98,635699.96,732806.08,97106.12,729723),('1','153','257604','321',602.00,696.00,0.00,1522.89,916779.78,1056828.56,140048.78,729724),('1','153','257605','321',602.00,696.00,0.00,1582.94,952929.88,1091914.24,138984.36,729725),('1','153','257606','321',602.00,696.00,0.00,1520.03,915058.06,1055430.68,140372.62,729726),('1','153','257607','321',602.00,696.00,0.00,544.02,330768.64,378637.92,47869.28,729727),('1','153','257608','321',612.00,696.00,0.00,752.76,460689.12,523699.64,63010.52,729728),('1','153','257609','321',612.00,696.00,0.00,1523.30,932259.60,1059111.08,126851.48,729729),('1','153','257610','321',612.00,696.00,0.00,441.34,270100.08,307172.64,37072.56,729730),('1','153','257611','321',612.00,680.00,0.00,1346.68,824168.16,914906.40,90738.24,729731),('1','153','257612','321',612.00,680.00,0.00,1447.40,885808.80,982708.40,96899.60,729732),('1','153','257613','321',612.00,680.00,0.00,668.24,408962.88,454403.20,45440.32,729733),('1','153','257614','321',612.00,680.00,0.00,673.69,412298.28,458109.20,45810.92,729734),('1','153','257615','321',612.00,680.00,0.00,1308.04,800520.48,885230.80,84710.32,729735),('1','153','257616','321',668.00,740.00,0.00,1478.71,987778.28,1093893.40,106115.12,729736),('1','153','257617','321',668.00,740.00,0.00,1368.70,914291.60,1006678.44,92386.84,729737),('1','153','257618','321',668.00,740.00,0.00,1425.64,932681.35,1054225.60,121544.25,729738),('1','153','257619','321',672.00,740.00,0.00,1721.07,1156559.04,1272579.80,116020.76,729739),('1','153','257620','321',672.00,700.00,0.00,1802.99,1211609.28,1261933.00,50323.72,729740),('1','153','257621','321',672.00,700.00,0.00,1934.79,1300178.88,1354353.00,54174.12,729741),('1','153','257622','321',612.00,680.00,0.00,828.51,526466.12,555502.80,29036.68,729742),('1','153','257623','321',662.00,680.00,0.00,1415.59,937120.58,956825.36,19704.78,729743),('1','153','257624','321',662.00,680.00,0.00,1588.75,1051752.50,1079595.44,27842.94,729744),('1','153','257625','321',662.00,680.00,0.00,1472.55,974828.10,1001334.00,26505.90,729745),('1','153','257626','321',662.00,680.00,0.00,1589.12,1051997.44,1080016.60,28019.16,729746),('1','153','257627','321',662.00,680.00,0.00,185.54,122827.48,126167.20,3339.72,729747),('1','153','257628','321',662.00,680.00,0.00,1548.94,1025398.28,1052379.74,26981.46,729748),('1','153','257629','321',662.00,680.00,0.00,1884.16,1247313.92,1281160.76,33846.84,729749),('1','153','257630','321',662.00,680.00,0.00,1551.55,1027126.10,1054172.90,27046.80,729750),('1','153','257631','321',662.00,680.00,0.00,1285.88,851252.56,874290.40,23037.84,729751),('1','153','257632','321',662.00,680.00,0.00,458.78,303712.36,311970.40,8258.04,729752),('1','153','257633','321',662.00,680.00,0.00,1670.69,1105996.78,1136069.20,30072.42,729753),('1','153','257634','321',662.00,680.00,0.00,1397.35,925045.70,948845.12,23799.42,729754),('1','153','257635','321',700.00,750.00,0.00,1216.74,851718.00,912464.20,60746.20,729755),('1','153','257636','321',692.00,750.00,0.00,314.63,217723.96,235972.50,18248.54,729756),('1','153','257637','321',692.00,750.00,0.00,1217.68,842634.56,912260.00,69625.44,729757),('1','153','257638','321',692.00,750.00,0.00,276.18,191116.56,206935.00,15818.44,729758),('1','153','257639','321',692.00,750.00,0.00,1907.22,1319796.24,1430215.00,110418.76,729759),('1','153','257640','321',692.00,750.00,0.00,1404.17,971685.64,1053127.50,81441.86,729760),('1','153','257641','321',692.00,750.00,0.00,1356.57,938746.44,1014309.50,75563.06,729761),('1','153','257642','321',692.00,750.00,0.00,1259.53,871594.76,944147.50,72552.74,729762),('1','153','257643','321',692.00,750.00,0.00,1186.24,820878.08,889680.00,68801.92,729763),('1','153','257644','321',692.00,750.00,0.00,1095.61,758162.12,821221.50,63059.38,729764),('1','153','257645','321',692.00,750.00,0.00,1649.34,1141343.28,1236825.00,95481.72,729765),('1','153','257646','321',692.00,750.00,0.00,1448.14,1002112.88,1079972.20,77859.32,729766),('1','153','257647','321',692.00,750.00,0.00,832.21,575889.32,624157.50,48268.18,729767),('1','153','257648','321',692.00,750.00,0.00,675.51,467452.92,504984.90,37531.98,729768),('1','153','257649','321',692.00,750.00,0.00,1215.48,841112.16,911370.00,70257.84,729769),('1','153','257650','321',692.00,750.00,0.00,1674.66,1158864.72,1255755.80,96891.08,729770),('1','153','257651','321',692.00,750.00,0.00,1508.51,1043888.92,1130602.10,86713.18,729771),('1','153','257652','321',692.00,750.00,0.00,988.73,684201.16,735930.70,51729.54,729772),('1','153','257653','321',692.00,750.00,0.00,627.45,434195.40,466267.90,32072.50,729773),('1','153','257654','321',692.00,750.00,0.00,2062.89,1427519.88,1545167.50,117647.62,729774),('1','153','257655','321',692.00,750.00,0.00,1406.87,973554.04,1052772.50,79218.46,729775),('1','153','257656','321',692.00,750.00,0.00,1762.18,1219428.56,1321335.00,101906.44,729776),('1','153','257657','321',692.00,750.00,0.00,201.37,139348.04,151027.50,11679.46,729777),('1','153','257658','321',692.00,750.00,0.00,1102.60,762999.20,826950.00,63950.80,729778),('1','153','257659','321',692.00,750.00,0.00,1792.20,1240202.40,1341830.00,101627.60,729779),('1','153','257660','321',692.00,750.00,0.00,1672.93,1157667.56,1254607.10,96939.54,729780),('1','153','257661','321',692.00,750.00,0.00,1532.77,1060676.84,1144937.50,84260.66,729781),('1','153','257662','321',692.00,750.00,0.00,1838.92,1272532.64,1376830.00,104297.36,729782),('1','153','257663','321',692.00,750.00,0.00,2421.70,1675816.40,1812029.80,136213.40,729783),('1','153','257664','321',692.00,750.00,0.00,1800.15,1245703.80,1350112.50,104408.70,729784),('1','153','257665','321',692.00,750.00,0.00,951.75,658611.00,713812.50,55201.50,729785),('1','153','257666','321',692.00,750.00,0.00,933.24,645802.08,698578.00,52775.92,729786),('1','153','257667','321',692.00,750.00,0.00,1265.29,875580.68,948967.50,73386.82,729787),('1','153','257668','321',692.00,750.00,0.00,1221.65,845381.80,916237.50,70855.70,729788),('1','153','257669','321',692.00,750.00,0.00,1036.35,717154.20,777262.50,60108.30,729789),('1','153','257670','321',692.00,750.00,0.00,690.20,477618.40,517650.00,40031.60,729790),('1','153','257671','321',692.00,750.00,0.00,249.00,172308.00,186750.00,14442.00,729791),('1','153','257672','321',692.00,750.00,0.00,1397.82,967291.44,1048365.00,81073.56,729792),('1','153','257673','321',692.00,750.00,0.00,1150.02,795813.84,862515.00,66701.16,729793),('1','153','257674','321',692.00,750.00,0.00,1519.02,1051161.84,1135665.00,84503.16,729794),('1','153','257675','321',692.00,750.00,0.00,1265.84,875961.28,944180.00,68218.72,729795),('1','153','257676','321',692.00,750.00,0.00,386.38,267374.96,289785.00,22410.04,729796),('1','153','257677','321',692.00,750.00,0.00,1227.33,849312.36,918057.50,68745.14,729797),('1','153','257678','321',692.00,750.00,0.00,1787.22,1236756.24,1338601.80,101845.56,729798),('1','153','257679','321',692.00,750.00,0.00,344.53,238414.76,258397.50,19982.74,729799),('1','153','257680','321',692.00,750.00,0.00,1183.53,819002.76,883248.30,64245.54,729800),('1','153','257681','321',692.00,750.00,0.00,1452.99,1005469.08,1082164.50,76695.42,729801),('1','153','257682','321',692.00,750.00,0.00,2083.27,1441622.84,1534469.30,92846.46,729802),('1','153','257683','321',692.00,750.00,0.00,1574.58,1089609.36,1163535.80,73926.44,729803),('1','153','257684','321',692.00,750.00,0.00,393.25,272129.00,293457.50,21328.50,729804),('1','153','257685','321',692.00,750.00,0.00,1541.02,1066385.84,1153565.00,87179.16,729805),('1','153','257686','321',692.00,750.00,0.00,1048.39,725485.88,783172.50,57686.62,729806),('1','153','257687','321',692.00,750.00,0.00,1372.82,949991.44,1029615.00,79623.56,729807),('1','153','257688','321',692.00,750.00,0.00,1477.45,1022395.40,1106086.70,83691.30,729808),('1','153','257689','321',692.00,750.00,0.00,486.86,336907.12,365145.00,28237.88,729809),('1','153','257690','321',684.00,750.00,0.00,871.95,596413.80,653962.50,57548.70,729810),('1','153','257691','321',684.00,750.00,0.00,1609.58,1100952.72,1205246.20,104293.48,729811),('1','153','257692','321',684.00,750.00,0.00,1756.37,1201357.08,1316793.90,115436.82,729812),('1','153','257693','321',684.00,750.00,0.00,1663.37,1137745.08,1243924.30,106179.22,729813),('1','153','257694','321',684.00,750.00,0.00,358.67,245330.28,269002.50,23672.22,729814),('1','153','257695','321',684.00,750.00,0.00,1336.64,914261.76,1002480.00,88218.24,729815),('1','153','257696','321',684.00,750.00,0.00,1239.28,847667.52,927307.60,79640.08,729816),('1','153','257697','321',684.00,750.00,0.00,1632.13,1116376.92,1224097.50,107720.58,729817),('1','153','257698','321',684.00,750.00,0.00,2050.62,1402983.75,1531465.00,128481.25,729818),('1','153','257699','321',685.00,750.00,0.00,2072.09,1419381.65,1534307.50,114925.85,729819),('1','153','257700','321',685.00,750.00,0.00,1945.14,1332420.90,1445575.00,113154.10,729820),('1','153','257701','321',685.00,750.00,0.00,1779.15,1218717.75,1326362.50,107644.75,729821),('1','153','257702','321',685.00,750.00,0.00,526.72,360803.20,382900.00,22096.80,729822),('1','153','257703','321',685.00,750.00,0.00,1018.47,697651.95,759852.50,62200.55,729823),('1','153','257704','321',685.00,750.00,0.00,1679.77,1150642.45,1247827.50,97185.05,729824),('1','153','257705','321',685.00,750.00,0.00,1550.13,1061839.05,1162457.50,100618.45,729825),('1','153','257706','321',685.00,750.00,0.00,1302.96,892527.60,977220.00,84692.40,729826),('1','153','257707','321',685.00,750.00,0.00,749.20,513202.00,561900.00,48698.00,729827),('1','153','257708','321',697.00,750.00,0.00,567.23,395359.31,425422.50,30063.19,729828),('1','153','257709','321',697.00,750.00,0.00,1332.11,928480.67,999082.50,70601.83,729829),('1','153','257710','321',697.00,750.00,0.00,1368.83,954074.51,1026622.50,72547.99,729830),('1','153','257711','321',697.00,750.00,0.00,1340.36,934230.92,1005270.00,71039.08,729831),('1','153','257712','321',697.00,750.00,0.00,1463.14,1019808.58,1088115.00,68306.42,729832),('1','153','257713','321',697.00,750.00,0.00,285.25,198819.25,213937.50,15118.25,729833),('1','153','257714','321',697.00,750.00,0.00,431.78,300950.66,322835.00,21884.34,729834),('1','153','257715','321',697.00,750.00,0.00,1173.08,817636.76,879810.00,62173.24,729835),('1','153','257716','321',697.00,750.00,0.00,1027.47,716146.59,762602.50,46455.91,729836),('1','153','257717','321',697.00,750.00,0.00,215.46,147590.10,161595.00,14004.90,729837),('1','153','257718','321',685.00,750.00,0.00,1371.67,939593.95,1019472.50,79878.55,729838),('1','153','257719','321',685.00,750.00,0.00,1354.84,928065.40,1013850.00,85784.60,729839),('1','153','257720','321',685.00,750.00,0.00,1295.99,887753.15,973242.50,85489.35,729840),('1','153','257721','321',685.00,750.00,0.00,1317.30,902350.50,978733.40,76382.90,729841),('1','153','257722','321',685.00,750.00,0.00,1010.63,692281.55,757972.50,65690.95,729842),('1','153','257723','321',685.00,750.00,0.00,1967.81,1347949.85,1475857.50,127907.65,729843),('1','153','257724','321',685.00,750.00,0.00,1284.15,879642.75,963112.50,83469.75,729844),('1','153','257725','321',685.00,750.00,0.00,1289.60,883376.00,967200.00,83824.00,729845),('1','153','257726','321',685.00,750.00,0.00,166.02,113723.70,124515.00,10791.30,729846),('1','153','257727','321',685.00,750.00,0.00,119.23,81672.55,89422.50,7749.95,729847),('1','153','257728','321',685.00,750.00,0.00,1757.73,1204045.05,1311297.50,107252.45,729848),('1','153','257729','321',685.00,750.00,0.00,1580.86,1082889.10,1184205.00,101315.90,729849),('1','153','257730','321',685.00,750.00,0.00,1266.36,867456.60,949770.00,82313.40,729850),('1','153','257731','321',685.00,750.00,0.00,1620.26,1109878.10,1205789.80,95911.70,729851),('1','153','257732','321',685.00,750.00,0.00,2641.95,1809735.75,1969462.50,159726.75,729852),('1','153','257733','321',685.00,750.00,0.00,3748.01,2567386.85,2748699.50,181312.65,729853),('1','153','257734','321',685.00,750.00,0.00,1061.24,726949.40,795930.00,68980.60,729854),('1','153','257735','321',685.00,750.00,0.00,1500.28,1027691.80,1125210.00,97518.20,729855),('1','153','257736','321',685.00,750.00,0.00,1671.36,1144881.60,1253520.00,108638.40,729856),('1','153','257737','321',685.00,750.00,0.00,1362.52,933326.20,1021890.00,88563.80,729857),('1','153','257738','321',685.00,750.00,0.00,489.57,335355.45,367177.50,31822.05,729858),('1','153','257739','321',685.00,750.00,0.00,496.95,340410.75,372712.50,32301.75,729859),('1','153','257740','321',685.00,750.00,0.00,1376.76,943080.60,1032570.00,89489.40,729860),('1','153','257741','321',685.00,750.00,0.00,1975.20,1353012.00,1481400.00,128388.00,729861),('1','153','257742','321',685.00,750.00,0.00,1842.99,1262448.15,1382242.50,119794.35,729862),('1','153','257743','321',685.00,750.00,0.00,350.33,239976.05,262747.50,22771.45,729863),('1','153','257744','321',685.00,750.00,0.00,855.83,586243.55,641872.50,55628.95,729864),('1','153','257745','321',685.00,750.00,0.00,1302.62,892294.70,976965.00,84670.30,729865),('1','153','257746','321',685.00,750.00,0.00,1008.11,690555.35,756082.50,65527.15,729866),('1','153','257747','321',685.00,750.00,0.00,1218.86,834919.10,914145.00,79225.90,729867),('1','153','257748','321',685.00,750.00,0.00,1661.91,1138408.35,1246432.50,108024.15,729868),('1','153','257749','321',677.00,750.00,0.00,576.36,390195.72,432270.00,42074.28,729869),('1','153','257750','321',677.00,750.00,0.00,1024.58,693640.66,768435.00,74794.34,729870),('1','153','257751','321',677.00,750.00,0.00,1221.66,827063.82,916245.00,89181.18,729871),('1','153','257752','321',677.00,750.00,0.00,1177.19,796957.63,882892.50,85934.87,729872),('1','153','257753','321',677.00,750.00,0.00,1103.48,747055.96,827610.00,80554.04,729873),('1','153','257754','321',677.00,750.00,0.00,870.77,589511.29,653077.50,63566.21,729874),('1','153','257755','321',677.00,750.00,0.00,303.84,205699.68,227880.00,22180.32,729875),('1','153','257756','321',677.00,750.00,0.00,1225.73,829819.21,919297.50,89478.29,729876),('1','153','257757','321',677.00,750.00,0.00,1130.19,765138.63,847642.50,82503.87,729877),('1','153','257758','321',677.00,750.00,0.00,1506.50,1019900.50,1129875.00,109974.50,729878),('1','153','257759','321',677.00,750.00,0.00,1224.87,829236.99,918652.50,89415.51,729879),('1','153','257760','321',677.00,750.00,0.00,545.67,369418.59,409252.50,39833.91,729880),('1','153','257761','321',677.00,750.00,0.00,753.43,510072.11,563872.50,53800.39,729881),('1','153','257762','321',677.00,750.00,0.00,1649.17,1116488.09,1236877.50,120389.41,729882),('1','153','257763','321',677.00,750.00,0.00,2030.21,1374452.17,1522657.50,148205.33,729883),('1','153','257764','321',677.00,750.00,0.00,1371.28,928356.56,1026060.00,97703.44,729884),('1','153','257765','321',677.00,750.00,0.00,90.43,61221.11,67822.50,6601.39,729885),('1','153','257766','321',677.00,750.00,0.00,1380.19,934388.63,1035142.50,100753.87,729886),('1','153','257767','321',677.00,750.00,0.00,777.72,526516.44,583290.00,56773.56,729887),('1','153','257768','321',677.00,750.00,0.00,427.35,289315.95,320512.50,31196.55,729888),('1','153','257769','321',677.00,750.00,0.00,1783.29,1207287.33,1337467.50,130180.17,729889),('1','153','257770','321',677.00,750.00,0.00,1613.23,1092156.71,1209922.50,117765.79,729890),('1','153','257771','321',677.00,750.00,0.00,742.81,502882.37,557107.50,54225.13,729891),('1','153','257772','321',677.00,750.00,0.00,466.21,315624.17,349657.50,34033.33,729892),('1','153','257773','321',677.00,750.00,0.00,404.66,273954.82,303495.00,29540.18,729893),('1','153','257774','321',677.00,750.00,0.00,636.57,430957.89,477427.50,46469.61,729894),('1','153','257775','321',677.00,750.00,0.00,1187.44,803896.88,890580.00,86683.12,729895),('1','153','257776','321',677.00,750.00,0.00,2036.99,1379042.23,1527742.50,148700.27,729896),('1','153','257777','321',677.00,750.00,0.00,1264.55,856100.35,948412.50,92312.15,729897),('1','153','257778','321',677.00,750.00,0.00,1207.30,817342.10,905475.00,88132.90,729898),('1','153','257779','321',677.00,750.00,0.00,1400.24,947962.48,1050180.00,102217.52,729899),('1','153','257780','321',677.00,750.00,0.00,1262.91,854990.07,947182.50,92192.43,729900),('1','153','257781','321',677.00,750.00,0.00,1237.58,837841.66,928185.00,90343.34,729901),('1','153','257782','321',677.00,750.00,0.00,2202.52,1491106.04,1651890.00,160783.96,729902),('1','153','257783','321',677.00,750.00,0.00,150.23,101705.71,112672.50,10966.79,729903),('1','153','257784','321',677.00,750.00,0.00,1673.33,1132844.41,1254997.50,122153.09,729904),('1','153','257785','321',677.00,750.00,0.00,1354.47,916976.19,1015852.50,98876.31,729905),('1','153','257786','321',677.00,750.00,0.00,1798.91,1217862.07,1349182.50,131320.43,729906),('1','153','257787','321',677.00,750.00,0.00,1391.81,942255.37,1043857.50,101602.13,729907),('1','153','257788','321',677.00,750.00,0.00,1822.06,1248111.10,1421206.80,173095.70,729908),('1','153','257789','321',685.00,780.00,0.00,2022.16,1385179.60,1577284.80,192105.20,729909),('1','153','257790','321',685.00,780.00,0.00,2468.38,1690840.30,1925336.40,234496.10,729910),('1','153','257791','321',685.00,780.00,0.00,637.33,436571.05,497117.40,60546.35,729911),('1','153','257792','321',685.00,780.00,0.00,3163.87,2167250.95,2467818.60,300567.65,729912),('1','153','257793','321',685.00,780.00,0.00,2437.45,1669653.25,1901211.00,231557.75,729913),('1','153','257794','321',685.00,780.00,0.00,770.89,528059.65,601294.20,73234.55,729914),('1','153','257795','321',685.00,780.00,0.00,2427.39,1662762.15,1893364.20,230602.05,729915),('1','153','257796','321',685.00,780.00,0.00,1250.50,856592.50,975390.00,118797.50,729916),('1','153','257797','321',685.00,780.00,0.00,1814.83,1243158.55,1415567.40,172408.85,729917),('1','153','257798','321',685.00,780.00,0.00,1731.60,1186146.00,1350648.00,164502.00,729918),('1','153','257799','321',685.00,780.00,0.00,1441.37,987338.45,1124268.60,136930.15,729919),('1','153','257800','321',685.00,780.00,0.00,2101.14,1439280.90,1638889.20,199608.30,729920),('1','153','257801','321',685.00,780.00,0.00,1001.20,685822.00,780936.00,95114.00,729921),('1','153','257802','321',685.00,780.00,0.00,484.20,331677.00,377676.00,45999.00,729922),('1','153','257803','321',685.00,780.00,0.00,1619.86,1109604.10,1263490.80,153886.70,729923),('1','153','257804','321',685.00,780.00,0.00,1765.47,1209346.95,1377066.60,167719.65,729924),('1','153','257805','321',685.00,780.00,0.00,1486.34,1018142.90,1159345.20,141202.30,729925),('1','153','257806','321',685.00,780.00,0.00,1366.93,936347.05,1059769.40,123422.35,729926),('1','153','257807','321',685.00,780.00,0.00,1550.54,1062119.90,1199669.60,137549.70,729927),('1','153','257808','321',685.00,780.00,0.00,2055.19,1407805.15,1594674.20,186869.05,729928),('1','153','257809','321',685.00,780.00,0.00,170.83,117018.55,133247.40,16228.85,729929),('1','153','257810','321',685.00,780.00,0.00,1295.03,887095.55,1000303.40,113207.85,729930),('1','153','257811','321',685.00,780.00,0.00,1586.32,1086629.20,1228450.00,141820.80,729931),('1','153','257812','321',685.00,780.00,0.00,1277.00,874745.00,984999.20,110254.20,729932),('1','153','257813','321',685.00,780.00,0.00,1605.46,1099740.10,1233977.20,134237.10,729933),('1','153','257814','321',685.00,780.00,0.00,1933.80,1324653.00,1479722.80,155069.80,729934),('1','153','257815','321',685.00,780.00,0.00,477.25,326916.25,364332.20,37415.95,729935),('1','153','257816','321',685.00,780.00,0.00,1055.32,722894.20,816422.00,93527.80,729936),('1','153','257817','321',685.00,780.00,0.00,762.61,522387.85,582535.80,60147.95,729937),('1','153','257818','321',685.00,780.00,0.00,2160.59,1480004.15,1651607.40,171603.25,729938),('1','153','257819','321',685.00,780.00,0.00,2113.41,1447685.85,1638363.40,190677.55,729939),('1','153','257820','321',685.00,780.00,0.00,295.35,202314.75,227965.56,25650.81,729940),('1','153','257821','321',685.00,736.00,0.00,959.32,657134.20,698114.44,40980.24,729941),('1','153','257822','321',685.00,736.00,0.00,459.43,314709.55,335566.48,20856.93,729942),('1','153','257823','321',685.00,736.00,0.00,1604.33,1098966.05,1171520.48,72554.43,729943),('1','153','257824','321',685.00,736.00,0.00,587.61,402512.85,427665.76,25152.91,729944),('1','153','257825','321',685.00,736.00,0.00,2273.33,1557231.05,1661364.54,104133.49,729945),('1','153','257826','321',685.00,736.00,0.00,2588.22,1772930.70,1889704.84,116774.14,729946),('1','153','257827','321',685.00,736.00,0.00,896.46,614075.10,658401.22,44326.12,729947),('1','153','257828','321',685.00,736.00,0.00,658.83,451298.55,478177.36,26878.81,729948),('1','153','257829','321',685.00,736.00,0.00,3199.53,2191678.05,2334602.16,142924.11,729949),('1','153','257830','321',685.00,736.00,0.00,2459.36,1684661.60,1790689.84,106028.24,729950),('1','153','257831','321',685.00,736.00,0.00,2038.17,1396146.45,1483463.52,87317.07,729951),('1','153','257832','321',685.00,736.00,0.00,2368.57,1622470.45,1726797.82,104327.37,729952),('1','153','257833','321',685.00,736.00,0.00,1594.81,1092444.85,1158524.66,66079.81,729953),('1','153','257834','321',685.00,736.00,0.00,1984.81,1359594.85,1448559.34,88964.49,729954),('1','153','257835','321',685.00,736.00,0.00,130.36,89296.60,94488.96,5192.36,729955),('1','153','257836','321',685.00,736.00,0.00,2294.91,1551359.16,1670648.88,119289.72,729956),('1','153','257837','321',676.00,736.00,0.00,3261.63,2204861.88,2382787.90,177926.02,729957),('1','153','257838','321',676.00,736.00,0.00,721.44,487693.44,522867.84,35174.40,729958),('1','153','257839','321',676.00,736.00,0.00,1187.67,802864.92,860912.44,58047.52,729959),('1','153','257840','321',676.00,736.00,0.00,1899.65,1284163.40,1385175.42,101012.02,729960),('1','153','257841','321',676.00,736.00,0.00,1997.85,1350546.60,1448855.28,98308.68,729961),('1','153','257842','321',676.00,736.00,0.00,1203.06,813268.56,876147.28,62878.72,729962),('1','153','257843','321',676.00,736.00,0.00,1300.33,879023.08,931896.46,52873.38,729963),('1','153','257844','321',676.00,736.00,0.00,2341.14,1582610.64,1697310.96,114700.32,729964),('1','153','257845','321',676.00,736.00,0.00,2326.24,1572538.24,1674080.36,101542.12,729965),('1','153','257846','321',676.00,736.00,0.00,357.84,241899.84,261680.24,19780.40,729966),('1','153','257847','321',676.00,736.00,0.00,2906.88,1965050.88,2088951.40,123900.52,729967),('1','153','257848','321',676.00,736.00,0.00,1963.42,1327271.92,1428683.60,101411.68,729968),('1','153','257849','321',676.00,736.00,0.00,1424.93,963252.68,1033272.24,70019.56,729969),('1','153','257850','321',676.00,736.00,0.00,724.83,489985.08,523129.22,33144.14,729970),('1','153','257851','321',676.00,736.00,0.00,3416.88,2309810.88,2465939.78,156128.90,729971),('1','153','257852','321',676.00,736.00,0.00,2127.18,1437973.68,1535347.76,97374.08,729972),('1','153','257853','321',676.00,736.00,0.00,1212.73,819805.48,867671.94,47866.46,729973),('1','153','257854','321',676.00,736.00,0.00,2736.83,1850097.08,1975832.34,125735.26,729974),('1','153','257855','321',676.00,736.00,0.00,2233.88,1510102.88,1608597.84,98494.96,729975),('1','153','257856','321',676.00,736.00,0.00,3302.36,2232395.36,2384458.98,152063.62,729976),('1','153','257857','321',676.00,736.00,0.00,1909.79,1291018.04,1373364.92,82346.88,729977),('1','153','257858','321',676.00,736.00,0.00,1208.20,816743.20,866733.76,49990.56,729978),('1','153','257859','321',676.00,736.00,0.00,1823.17,1232462.92,1332624.16,100161.24,729979),('1','153','257860','321',676.00,736.00,0.00,2000.12,1352081.12,1457887.12,105806.00,729980),('1','153','257861','321',676.00,736.00,0.00,1254.66,848150.16,911635.38,63485.22,729981),('1','153','257862','321',676.00,736.00,0.00,432.54,292397.04,317569.44,25172.40,729982),('1','153','257863','321',676.00,736.00,0.00,2364.22,1598212.72,1716507.58,118294.86,729983),('1','153','257864','321',676.00,736.00,0.00,2855.21,1930121.96,2073379.26,143257.30,729984),('1','153','257865','321',676.00,736.00,0.00,503.48,340352.48,366453.54,26101.06,729985),('1','153','257866','321',676.00,736.00,0.00,571.82,386550.32,415567.74,29017.42,729986),('1','153','257867','321',676.00,736.00,0.00,2387.57,1613997.32,1749604.40,135607.08,729987),('1','153','257868','321',676.00,736.00,0.00,1944.74,1314644.24,1418623.48,103979.24,729988),('1','153','257869','321',676.00,736.00,0.00,1419.64,959676.64,1037712.58,78035.94,729989),('1','153','257870','321',676.00,736.00,0.00,1170.04,790947.04,849838.40,58891.36,729990),('1','153','257871','321',676.00,736.00,0.00,1209.88,817878.88,881068.00,63189.12,729991),('1','153','257872','321',676.00,736.00,0.00,2620.71,1771599.96,1913708.22,142108.26,729992),('1','153','257873','321',676.00,736.00,0.00,2522.07,1704919.32,1827563.44,122644.12,729993),('1','153','257874','321',676.00,736.00,0.00,1176.97,795631.72,856005.14,60373.42,729994),('1','153','257875','321',676.00,736.00,0.00,844.71,571023.96,613627.84,42603.88,729995),('1','153','257876','321',676.00,736.00,0.00,2695.91,1822435.16,1965192.60,142757.44,729996),('1','153','257877','321',676.00,736.00,0.00,2658.37,1797058.12,1933155.90,136097.78,729997),('1','153','257878','321',676.00,736.00,0.00,2281.95,1542598.20,1659714.64,117116.44,729998),('1','153','257879','321',676.00,736.00,0.00,2234.79,1510718.04,1625845.98,115127.94,729999),('1','153','257880','321',676.00,736.00,0.00,1682.93,1137660.68,1213549.08,75888.40,730000),('1','153','257881','321',676.00,736.00,0.00,2573.52,1739699.52,1859953.48,120253.96,730001),('1','153','257882','321',676.00,736.00,0.00,2051.48,1386800.48,1489720.04,102919.56,730002),('1','153','257883','321',676.00,736.00,0.00,491.86,332497.36,356538.56,24041.20,730003),('1','153','257884','321',676.00,736.00,0.00,972.41,657349.16,708498.52,51149.36,730004),('1','153','257885','321',676.00,736.00,0.00,1641.66,1109762.16,1186434.24,76672.08,730005),('1','153','257886','321',676.00,736.00,0.00,2198.72,1486334.72,1588350.64,102015.92,730006),('1','153','257887','321',676.00,736.00,0.00,1136.64,768368.64,823902.18,55533.54,730007),('1','153','257888','321',676.00,736.00,0.00,1175.36,794543.36,863559.82,69016.46,730008),('1','153','257889','321',651.00,736.00,0.00,1778.91,1158070.41,1297041.38,138970.97,730009),('1','153','257890','321',651.00,736.00,0.00,1574.95,1025292.45,1154568.74,129276.29,730010),('1','153','257891','321',651.00,736.00,0.00,1216.15,791713.65,889228.08,97514.43,730011),('1','153','257892','321',651.00,736.00,0.00,893.31,581544.81,647576.92,66032.11,730012),('1','153','257893','321',651.00,736.00,0.00,553.43,360282.93,401222.28,40939.35,730013),('1','153','257894','321',651.00,736.00,0.00,2116.74,1377997.74,1544467.72,166469.98,730014),('1','153','257895','321',651.00,736.00,0.00,1216.15,791713.65,887742.70,96029.05,730015),('1','153','257896','321',651.00,736.00,0.00,580.90,378165.90,426505.78,48339.88,730016),('1','153','257897','321',651.00,736.00,0.00,1573.30,1025633.50,1150988.60,125355.10,730017),('1','153','257898','321',661.00,736.00,0.00,1746.61,1154509.21,1269245.34,114736.13,730018),('1','153','257899','321',661.00,736.00,0.00,1793.23,1185325.03,1299332.14,114007.11,730019),('1','153','257900','321',661.00,736.00,0.00,2115.08,1398067.88,1546388.58,148320.70,730020),('1','153','257901','321',661.00,736.00,0.00,573.25,378918.25,420016.60,41098.35,730021),('1','153','257902','321',651.00,736.00,0.00,407.86,265516.86,297106.04,31589.18,730022),('1','153','257903','321',651.00,736.00,0.00,1760.83,1146300.33,1290680.14,144379.81,730023),('1','153','257904','321',661.00,736.00,0.00,1664.77,1100412.97,1216047.74,115634.77,730024),('1','153','257905','321',661.00,736.00,0.00,1644.77,1087192.97,1199299.74,112106.77,730025),('1','153','257906','321',661.00,736.00,0.00,2841.23,1878053.03,2087492.80,209439.77,730026),('1','153','257907','321',661.00,736.00,0.00,2000.92,1322608.12,1462514.76,139906.64,730027),('1','153','257908','321',661.00,736.00,0.00,2321.68,1534630.48,1707638.48,173008.00,730028),('1','153','257909','321',661.00,736.00,0.00,1947.80,1287495.80,1430720.80,143225.00,730029),('1','153','257910','321',661.00,736.00,0.00,1882.03,1244021.83,1384160.34,140138.51,730030),('1','153','257911','321',661.00,736.00,0.00,2099.90,1388033.90,1533605.40,145571.50,730031),('1','153','257912','321',661.00,736.00,0.00,1835.26,1213106.86,1338117.18,125010.32,730032),('1','153','257913','321',661.00,736.00,0.00,1970.07,1302216.27,1425806.60,123590.33,730033),('1','153','257914','321',661.00,736.00,0.00,379.52,250862.72,279326.72,28464.00,730034),('1','153','257915','321',661.00,736.00,0.00,411.38,271922.18,300670.98,28748.80,730035),('1','153','257916','321',661.00,736.00,0.00,1359.70,898761.70,991837.32,93075.62,730036),('1','153','257917','321',661.00,736.00,0.00,1630.98,1078077.78,1197060.28,118982.50,730037),('1','153','257918','321',661.00,736.00,0.00,2454.11,1622166.71,1787504.96,165338.25,730038),('1','153','257919','321',661.00,736.00,0.00,412.15,272431.15,302367.66,29936.51,730039),('1','153','257920','321',661.00,736.00,0.00,776.56,513306.16,571230.44,57924.28,730040),('1','153','257921','321',661.00,736.00,0.00,1486.57,982622.77,1088161.52,105538.75,730041),('1','153','257922','321',661.00,736.00,0.00,1461.51,966058.11,1075671.36,109613.25,730042),('1','153','257923','321',661.00,736.00,0.00,1677.21,1108635.81,1228628.30,119992.49,730043),('1','153','257924','321',661.00,736.00,0.00,863.94,571064.34,635342.18,64277.84,730044),('1','153','257925','321',651.00,736.00,0.00,653.79,425617.29,480786.70,55169.41,730045),('1','153','257926','321',651.00,736.00,0.00,1722.06,1121061.06,1261480.08,140419.02,730046),('1','153','257927','321',651.00,736.00,0.00,1794.74,1168375.74,1319890.46,151514.72,730047),('1','153','257928','321',651.00,736.00,0.00,1842.03,1199161.53,1351418.60,152257.07,730048),('1','153','257929','321',651.00,736.00,0.00,1378.92,897676.92,1013359.44,115682.52,730049),('1','153','257930','321',651.00,736.00,0.00,1576.63,1026386.13,1155572.52,129186.39,730050),('1','153','257931','321',651.00,736.00,0.00,1787.67,1163773.17,1312124.90,148351.73,730051),('1','153','257932','321',651.00,736.00,0.00,1541.31,1003392.81,1131381.40,127988.59,730052),('1','153','257933','321',651.00,736.00,0.00,1357.32,883615.32,998025.52,114410.20,730053),('1','153','257934','321',651.00,736.00,0.00,1361.75,886499.25,997326.46,110827.21,730054),('1','153','257935','321',651.00,736.00,0.00,1088.73,708763.23,798614.28,89851.05,730055),('1','153','257936','321',651.00,736.00,0.00,816.13,531300.63,590193.78,58893.15,730056),('1','153','257937','321',651.00,726.00,0.00,749.31,487800.81,543999.06,56198.25,730057),('1','153','257938','321',651.00,726.00,0.00,1138.17,740948.67,825115.68,84167.01,730058),('1','153','257939','321',651.00,726.00,0.00,1488.47,968993.97,1074745.94,105751.97,730059),('1','153','257940','321',651.00,726.00,0.00,1194.69,777743.19,865421.20,87678.01,730060),('1','153','257941','321',651.00,726.00,0.00,1592.58,1036769.58,1153652.08,116882.50,730061),('1','153','257942','321',651.00,726.00,0.00,989.30,644034.30,716060.54,72026.24,730062),('1','153','257943','321',651.00,726.00,0.00,1466.63,954776.13,1056133.32,101357.19,730063),('1','153','257944','321',651.00,726.00,0.00,2439.31,1587990.81,1767808.14,179817.33,730064),('1','153','257945','321',644.00,726.00,0.00,1063.52,684906.88,767196.06,82289.18,730065),('1','153','257946','321',644.00,726.00,0.00,1959.19,1261718.36,1421747.94,160029.58,730066),('1','153','257947','321',644.00,726.00,0.00,1622.50,1044890.00,1176167.00,131277.00,730067);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=299 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',298,'153','LPG TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=764 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','153','298',763,1,'321','LPG TANK',7000.00,1.00,5741.28,'TANK CONTAINING LPG PRODUCT.','479','2020-07-20 12:12:51','2020-07-20 12:12:51','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','153',763,1254.09,'2023-03-20 02:36:47');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2736000 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108091,'1','153','763',321,'Retail Sale Id 1254061',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:22:40','',''),(2108092,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:22:40','',''),(2108133,'1','153','763',321,'Retail Sale Id 1254083',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 06:26:57','',''),(2108134,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:26:57','',''),(2108135,'1','153','763',321,'Retail Sale Id 1254083',7302.40,0.00,0.00,0.00,433.58,'2021-12-01 06:26:57','',''),(2108136,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.41,0.00,'2021-12-01 06:26:57','',''),(2108166,'1','153','763',321,'Retail Sale Id 1254100',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 06:29:25','',''),(2108167,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 06:29:25','',''),(2108168,'1','153','763',321,'Retail Sale Id 1254100',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:29:25','',''),(2108169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:29:25','',''),(2108565,'1','153','763',321,'Retail Sale Id 1254282',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 06:54:45','',''),(2108566,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 06:54:45','',''),(2108583,'1','153','763',321,'Retail Sale Id 1254299',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 06:55:52','',''),(2108584,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:55:52','',''),(2108599,'1','153','763',321,'Retail Sale Id 1254308',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 06:56:41','',''),(2108600,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:56:41','',''),(2108619,'1','153','763',321,'Retail Sale Id 1254318',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:57:26','',''),(2108620,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:57:26','',''),(2108654,'1','153','763',321,'Retail Sale Id 1254330',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:58:50','',''),(2108655,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:58:50','',''),(2108670,'1','153','763',321,'Retail Sale Id 1254343',1280.00,0.00,0.00,0.00,76.00,'2021-12-01 06:59:37','',''),(2108671,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:59:37','',''),(2108699,'1','153','763',321,'Retail Sale Id 1254356',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:00:53','',''),(2108700,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:00:53','',''),(2108717,'1','153','763',321,'Retail Sale Id 1254367',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 07:01:57','',''),(2108718,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 07:01:57','',''),(2108729,'1','153','763',321,'Retail Sale Id 1254372',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:02:48','',''),(2108730,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:02:48','',''),(2108746,'1','153','763',321,'Retail Sale Id 1254377',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:03:38','',''),(2108747,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:03:38','',''),(2108760,'1','153','763',321,'Retail Sale Id 1254382',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 07:04:28','',''),(2108761,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:04:28','',''),(2108790,'1','153','763',321,'Retail Sale Id 1254396',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 07:05:31','',''),(2108791,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:05:31','',''),(2108829,'1','153','763',321,'Retail Sale Id 1254412',6502.40,0.00,0.00,0.00,386.08,'2021-12-01 07:08:05','',''),(2108830,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 07:08:05','',''),(2108852,'1','153','763',321,'Retail Sale Id 1254424',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:08:58','',''),(2108853,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:08:58','',''),(2108876,'1','153','763',321,'Retail Sale Id 1254433',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:09:46','',''),(2108877,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:09:46','',''),(2108953,'1','153','763',321,'Retail Sale Id 1254457',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:12:29','',''),(2108954,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:12:29','',''),(2108979,'1','153','763',321,'Retail Sale Id 1254470',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 07:13:36','',''),(2108980,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:13:36','',''),(2108991,'1','153','763',321,'Retail Sale Id 1254479',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:14:22','',''),(2108992,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:14:22','',''),(2108993,'1','153','763',321,'Retail Sale Id 1254479',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:14:22','',''),(2108994,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:14:22','',''),(2109035,'1','153','763',321,'Retail Sale Id 1254499',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:16:51','',''),(2109036,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:16:51','',''),(2109077,'1','153','763',321,'Retail Sale Id 1254522',15400.00,0.00,0.00,0.00,350.00,'2021-12-01 07:19:14','',''),(2109078,'1','153','763',321,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 07:19:14','',''),(2109123,'1','153','763',321,'Retail Sale Id 1254539',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:20:59','',''),(2109124,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:20:59','',''),(2109142,'1','153','763',321,'Retail Sale Id 1254549',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 07:22:05','',''),(2109143,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:22:05','',''),(2109183,'1','153','763',321,'Retail Sale Id 1254557',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 07:22:54','',''),(2109184,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 07:22:54','',''),(2109203,'1','153','763',321,'Retail Sale Id 1254563',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:23:33','',''),(2109204,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:23:33','',''),(2109223,'1','153','763',321,'Retail Sale Id 1254573',5760.00,0.00,0.00,0.00,342.00,'2021-12-01 07:24:51','',''),(2109224,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 07:24:51','',''),(2109240,'1','153','763',321,'Retail Sale Id 1254577',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 07:25:36','',''),(2109241,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 07:25:36','',''),(2109252,'1','153','763',321,'Retail Sale Id 1254583',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:26:47','',''),(2109253,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:26:47','',''),(2109261,'1','153','763',321,'Retail Sale Id 1254587',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 07:27:34','',''),(2109262,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:27:34','',''),(2109294,'1','153','763',321,'Retail Sale Id 1254598',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:28:43','',''),(2109295,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:28:43','',''),(2109304,'1','153','763',321,'Retail Sale Id 1254606',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:29:33','',''),(2109305,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:29:33','',''),(2109314,'1','153','763',321,'Retail Sale Id 1254610',24997.28,0.00,0.00,0.00,568.12,'2021-12-01 07:30:25','',''),(2109315,'1','153','763',321,'Retail sales',0.00,0.00,0.00,40.58,0.00,'2021-12-01 07:30:25','',''),(2109344,'1','153','763',321,'Retail Sale Id 1254630',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 07:32:05','',''),(2109345,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:32:05','',''),(2109358,'1','153','763',321,'Retail Sale Id 1254640',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:32:52','',''),(2109359,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:32:52','',''),(2109372,'1','153','763',321,'Retail Sale Id 1254646',652.80,0.00,0.00,0.00,38.76,'2021-12-01 07:33:48','',''),(2109373,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 07:33:48','',''),(2109390,'1','153','763',321,'Retail Sale Id 1254658',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:34:31','',''),(2109391,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:34:31','',''),(2109404,'1','153','763',321,'Retail Sale Id 1254665',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:35:16','',''),(2109405,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:35:16','',''),(2109424,'1','153','763',321,'Retail Sale Id 1254675',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 07:36:04','',''),(2109425,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:36:04','',''),(2109438,'1','153','763',321,'Retail Sale Id 1254682',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:36:51','',''),(2109439,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:36:51','',''),(2109440,'1','153','763',321,'Retail Sale Id 1254682',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:36:51','',''),(2109441,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:36:51','',''),(2109458,'1','153','763',321,'Retail Sale Id 1254693',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 07:37:44','',''),(2109459,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 07:37:44','',''),(2109478,'1','153','763',321,'Retail Sale Id 1254705',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:38:26','',''),(2109479,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:38:26','',''),(2109492,'1','153','763',321,'Retail Sale Id 1254713',6080.00,0.00,0.00,0.00,361.00,'2021-12-01 07:39:10','',''),(2109493,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-01 07:39:10','',''),(2109512,'1','153','763',321,'Retail Sale Id 1254723',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 07:40:14','',''),(2109513,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 07:40:14','',''),(2109596,'1','153','763',321,'Retail Sale Id 1254750',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:43:02','',''),(2109597,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:43:02','',''),(2109608,'1','153','763',321,'Retail Sale Id 1254757',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 07:44:06','',''),(2109609,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:44:06','',''),(2109633,'1','153','763',321,'Retail Sale Id 1254767',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:45:03','',''),(2109634,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:45:03','',''),(2109740,'1','153','763',321,'Retail Sale Id 1254814',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:48:40','',''),(2109741,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:48:40','',''),(2109762,'1','153','763',321,'Retail Sale Id 1254824',902.40,0.00,0.00,0.00,53.58,'2021-12-01 07:49:38','',''),(2109763,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 07:49:38','',''),(2109846,'1','153','763',321,'Retail Sale Id 1254859',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:54:06','',''),(2109847,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:54:06','',''),(2109848,'1','153','763',321,'Retail Sale Id 1254859',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:54:06','',''),(2109849,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:54:06','',''),(2109876,'1','153','763',321,'Retail Sale Id 1254881',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 07:55:26','',''),(2109877,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 07:55:26','',''),(2109911,'1','153','763',321,'Retail Sale Id 1254897',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 07:57:24','',''),(2109912,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 07:57:24','',''),(2109943,'1','153','763',321,'Retail Sale Id 1254914',30800.00,0.00,0.00,0.00,700.00,'2021-12-01 07:59:08','',''),(2109944,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 07:59:08','',''),(2109953,'1','153','763',321,'Retail Sale Id 1254917',30800.00,0.00,0.00,0.00,700.00,'2021-12-01 08:00:00','',''),(2109954,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 08:00:00','',''),(2110027,'1','153','763',321,'Retail Sale Id 1254959',7500.80,0.00,0.00,0.00,445.36,'2021-12-01 08:03:39','',''),(2110028,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-01 08:03:39','',''),(2110052,'1','153','763',321,'Retail Sale Id 1254967',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 08:04:34','',''),(2110053,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:04:34','',''),(2110062,'1','153','763',321,'Retail Sale Id 1254975',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:05:31','',''),(2110063,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:05:31','',''),(2110108,'1','153','763',321,'Retail Sale Id 1254990',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 08:07:49','',''),(2110109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 08:07:49','',''),(2110168,'1','153','763',321,'Retail Sale Id 1255017',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 08:11:45','',''),(2110169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:11:45','',''),(2110176,'1','153','763',321,'Retail Sale Id 1255024',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:12:27','',''),(2110177,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:12:27','',''),(2110194,'1','153','763',321,'Retail Sale Id 1255032',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:13:12','',''),(2110195,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:13:12','',''),(2110214,'1','153','763',321,'Retail Sale Id 1255042',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 08:14:11','',''),(2110215,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 08:14:11','',''),(2110244,'1','153','763',321,'Retail Sale Id 1255058',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 08:16:19','',''),(2110245,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:16:19','',''),(2110316,'1','153','763',321,'Retail Sale Id 1255095',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:19:57','',''),(2110317,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:19:57','',''),(2110336,'1','153','763',321,'Retail Sale Id 1255107',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 08:20:46','',''),(2110337,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:20:46','',''),(2110354,'1','153','763',321,'Retail Sale Id 1255113',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 08:21:34','',''),(2110355,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 08:21:34','',''),(2110491,'1','153','763',321,'Retail Sale Id 1255185',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 08:31:10','',''),(2110492,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:31:10','',''),(2110519,'1','153','763',321,'Retail Sale Id 1255198',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:32:23','',''),(2110520,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:32:23','',''),(2110535,'1','153','763',321,'Retail Sale Id 1255204',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:33:23','',''),(2110536,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:33:23','',''),(2110570,'1','153','763',321,'Retail Sale Id 1255219',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 08:34:54','',''),(2110571,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 08:34:54','',''),(2110659,'1','153','763',321,'Retail Sale Id 1255258',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:40:30','',''),(2110660,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:40:30','',''),(2110661,'1','153','763',321,'Retail Sale Id 1255258',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 08:40:30','',''),(2110662,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:40:30','',''),(2110663,'1','153','763',321,'Retail Sale Id 1255258',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 08:40:30','',''),(2110664,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:40:30','',''),(2110665,'1','153','763',321,'Retail Sale Id 1255258',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 08:40:30','',''),(2110666,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 08:40:30','',''),(2110667,'1','153','763',321,'Retail Sale Id 1255258',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 08:40:30','',''),(2110668,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 08:40:30','',''),(2110669,'1','153','763',321,'Retail Sale Id 1255258',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:40:30','',''),(2110670,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:40:30','',''),(2110683,'1','153','763',321,'Retail Sale Id 1255269',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:41:11','',''),(2110684,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:41:11','',''),(2110698,'1','153','763',321,'Retail Sale Id 1255274',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 08:41:51','',''),(2110699,'1','153','763',321,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 08:41:51','',''),(2110730,'1','153','763',321,'Retail Sale Id 1255293',652.80,0.00,0.00,0.00,38.76,'2021-12-01 08:43:39','',''),(2110731,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 08:43:39','',''),(2110748,'1','153','763',321,'Retail Sale Id 1255302',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 08:44:40','',''),(2110749,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:44:40','',''),(2110762,'1','153','763',321,'Retail Sale Id 1255309',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 08:45:39','',''),(2110763,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 08:45:40','',''),(2110786,'1','153','763',321,'Retail Sale Id 1255326',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 08:47:21','',''),(2110787,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:47:21','',''),(2110804,'1','153','763',321,'Retail Sale Id 1255338',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 08:48:13','',''),(2110805,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:48:13','',''),(2110806,'1','153','763',321,'Retail Sale Id 1255338',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 08:48:13','',''),(2110807,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 08:48:13','',''),(2110818,'1','153','763',321,'Retail Sale Id 1255349',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:49:08','',''),(2110819,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:49:08','',''),(2110834,'1','153','763',321,'Retail Sale Id 1255357',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 08:49:57','',''),(2110835,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:49:57','',''),(2110858,'1','153','763',321,'Retail Sale Id 1255368',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:51:46','',''),(2110859,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:51:46','',''),(2110878,'1','153','763',321,'Retail Sale Id 1255378',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 08:52:52','',''),(2110879,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:52:52','',''),(2110924,'1','153','763',321,'Retail Sale Id 1255401',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:55:41','',''),(2110925,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:55:41','',''),(2110943,'1','153','763',321,'Retail Sale Id 1255413',15400.00,0.00,0.00,0.00,350.00,'2021-12-01 08:56:41','',''),(2110944,'1','153','763',321,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 08:56:41','',''),(2110977,'1','153','763',321,'Retail Sale Id 1255431',998.40,0.00,0.00,0.00,59.28,'2021-12-01 08:59:02','',''),(2110978,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:59:02','',''),(2110998,'1','153','763',321,'Retail Sale Id 1255441',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 09:00:06','',''),(2110999,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:00:06','',''),(2111012,'1','153','763',321,'Retail Sale Id 1255448',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 09:00:55','',''),(2111013,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:00:55','',''),(2111026,'1','153','763',321,'Retail Sale Id 1255456',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:01:52','',''),(2111027,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:01:52','',''),(2111028,'1','153','763',321,'Retail Sale Id 1255456',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:01:52','',''),(2111029,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:01:52','',''),(2111092,'1','153','763',321,'Retail Sale Id 1255488',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 09:05:02','',''),(2111093,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:05:02','',''),(2111108,'1','153','763',321,'Retail Sale Id 1255493',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 09:05:49','',''),(2111109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:05:49','',''),(2111120,'1','153','763',321,'Retail Sale Id 1255498',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:07:08','',''),(2111121,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:07:08','',''),(2111122,'1','153','763',321,'Retail Sale Id 1255498',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 09:07:08','',''),(2111123,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:07:08','',''),(2111128,'1','153','763',321,'Retail Sale Id 1255501',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 09:07:49','',''),(2111129,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 09:07:49','',''),(2111196,'1','153','763',321,'Retail Sale Id 1255538',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 09:12:02','',''),(2111197,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 09:12:02','',''),(2111254,'1','153','763',321,'Retail Sale Id 1255568',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 09:15:32','',''),(2111255,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:15:32','',''),(2111272,'1','153','763',321,'Retail Sale Id 1255582',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:16:17','',''),(2111273,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:16:17','',''),(2111297,'1','153','763',321,'Retail Sale Id 1255595',998.40,0.00,0.00,0.00,59.28,'2021-12-01 09:18:03','',''),(2111298,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:18:03','',''),(2111336,'1','153','763',321,'Retail Sale Id 1255616',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:20:16','',''),(2111337,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:20:16','',''),(2111348,'1','153','763',321,'Retail Sale Id 1255624',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 09:21:16','',''),(2111349,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 09:21:16','',''),(2111376,'1','153','763',321,'Retail Sale Id 1255640',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 09:23:12','',''),(2111377,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:23:12','',''),(2111408,'1','153','763',321,'Retail Sale Id 1255658',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 09:25:21','',''),(2111409,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:25:21','',''),(2111410,'1','153','763',321,'Retail Sale Id 1255658',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 09:25:21','',''),(2111411,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:25:21','',''),(2111539,'1','153','763',321,'Retail Sale Id 1255718',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:33:35','',''),(2111540,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:33:35','',''),(2111557,'1','153','763',321,'Retail Sale Id 1255731',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 09:34:53','',''),(2111558,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:34:53','',''),(2111631,'1','153','763',321,'Retail Sale Id 1255770',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 09:38:34','',''),(2111632,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:38:34','',''),(2111684,'1','153','763',321,'Retail Sale Id 1255798',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 09:42:45','',''),(2111685,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:42:45','',''),(2111706,'1','153','763',321,'Retail Sale Id 1255811',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 09:44:20','',''),(2111707,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 09:44:20','',''),(2111774,'1','153','763',321,'Retail Sale Id 1255850',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:48:49','',''),(2111775,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:48:49','',''),(2111782,'1','153','763',321,'Retail Sale Id 1255855',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 09:49:30','',''),(2111783,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:49:30','',''),(2111806,'1','153','763',321,'Retail Sale Id 1255867',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 09:52:15','',''),(2111807,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:52:15','',''),(2111808,'1','153','763',321,'Retail Sale Id 1255867',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:52:15','',''),(2111809,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:52:15','',''),(2111810,'1','153','763',321,'Retail Sale Id 1255867',27136.00,0.00,0.00,0.00,1611.20,'2021-12-01 09:52:15','',''),(2111811,'1','153','763',321,'Retail sales',0.00,0.00,0.00,42.40,0.00,'2021-12-01 09:52:15','',''),(2111812,'1','153','763',321,'Retail Sale Id 1255867',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 09:52:15','',''),(2111813,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:52:15','',''),(2111814,'1','153','763',321,'Retail Sale Id 1255867',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 09:52:15','',''),(2111815,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:52:15','',''),(2111872,'1','153','763',321,'Retail Sale Id 1255894',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 09:56:17','',''),(2111873,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:56:17','',''),(2111886,'1','153','763',321,'Retail Sale Id 1255901',800.00,0.00,0.00,0.00,47.50,'2021-12-01 09:57:16','',''),(2111887,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 09:57:16','',''),(2111915,'1','153','763',321,'Retail Sale Id 1255911',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 09:58:38','',''),(2111916,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:58:38','',''),(2111975,'1','153','763',321,'Retail Sale Id 1255938',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 10:01:30','',''),(2111976,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 10:01:30','',''),(2112003,'1','153','763',321,'Retail Sale Id 1255954',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:03:57','',''),(2112004,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:03:57','',''),(2112027,'1','153','763',321,'Retail Sale Id 1255966',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:06:32','',''),(2112028,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:06:32','',''),(2112029,'1','153','763',321,'Retail Sale Id 1255966',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:06:32','',''),(2112030,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:06:32','',''),(2112070,'1','153','763',321,'Retail Sale Id 1255986',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 10:10:18','',''),(2112071,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 10:10:18','',''),(2112110,'1','153','763',321,'Retail Sale Id 1256009',998.40,0.00,0.00,0.00,59.28,'2021-12-01 10:12:11','',''),(2112111,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 10:12:11','',''),(2112136,'1','153','763',321,'Retail Sale Id 1256023',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 10:14:03','',''),(2112137,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 10:14:03','',''),(2112150,'1','153','763',321,'Retail Sale Id 1256029',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 10:14:51','',''),(2112151,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:14:51','',''),(2112176,'1','153','763',321,'Retail Sale Id 1256041',6776.00,0.00,0.00,0.00,154.00,'2021-12-01 10:15:56','',''),(2112177,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 10:15:56','',''),(2112202,'1','153','763',321,'Retail Sale Id 1256051',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:16:59','',''),(2112203,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:59','',''),(2112223,'1','153','763',321,'Retail Sale Id 1256062',499.20,0.00,0.00,0.00,29.64,'2021-12-01 10:18:28','',''),(2112224,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 10:18:28','',''),(2112225,'1','153','763',321,'Retail Sale Id 1256062',499.20,0.00,0.00,0.00,29.64,'2021-12-01 10:18:28','',''),(2112226,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 10:18:28','',''),(2112237,'1','153','763',321,'Retail Sale Id 1256069',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:19:30','',''),(2112238,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:19:30','',''),(2112255,'1','153','763',321,'Retail Sale Id 1256079',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 10:21:31','',''),(2112256,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 10:21:31','',''),(2112261,'1','153','763',321,'Retail Sale Id 1256084',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:22:13','',''),(2112262,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:22:13','',''),(2112291,'1','153','763',321,'Retail Sale Id 1256095',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 10:25:24','',''),(2112292,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 10:25:24','',''),(2112305,'1','153','763',321,'Retail Sale Id 1256097',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:26:17','',''),(2112306,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:26:17','',''),(2112397,'1','153','763',321,'Retail Sale Id 1256145',601.60,0.00,0.00,0.00,35.72,'2021-12-01 10:32:52','',''),(2112398,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-01 10:32:52','',''),(2112427,'1','153','763',321,'Retail Sale Id 1256164',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 10:35:26','',''),(2112428,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 10:35:26','',''),(2112441,'1','153','763',321,'Retail Sale Id 1256169',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 10:36:14','',''),(2112442,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 10:36:14','',''),(2112463,'1','153','763',321,'Retail Sale Id 1256177',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:36:57','',''),(2112464,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:36:57','',''),(2112487,'1','153','763',321,'Retail Sale Id 1256189',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:38:59','',''),(2112488,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:38:59','',''),(2112497,'1','153','763',321,'Retail Sale Id 1256195',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:39:41','',''),(2112498,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:39:41','',''),(2112523,'1','153','763',321,'Retail Sale Id 1256207',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 10:42:19','',''),(2112524,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:42:19','',''),(2112530,'1','153','763',321,'Retail Sale Id 1256211',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 10:43:41','',''),(2112531,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 10:43:41','',''),(2112570,'1','153','763',321,'Retail Sale Id 1256232',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:47:12','',''),(2112571,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:47:12','',''),(2112572,'1','153','763',321,'Retail Sale Id 1256232',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:47:12','',''),(2112573,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:47:12','',''),(2112590,'1','153','763',321,'Retail Sale Id 1256241',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:48:04','',''),(2112591,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:48:04','',''),(2112606,'1','153','763',321,'Retail Sale Id 1256250',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:49:25','',''),(2112607,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:49:25','',''),(2112616,'1','153','763',321,'Retail Sale Id 1256255',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:50:30','',''),(2112617,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:50:30','',''),(2112624,'1','153','763',321,'Retail Sale Id 1256261',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:51:15','',''),(2112625,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:51:15','',''),(2112636,'1','153','763',321,'Retail Sale Id 1256266',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 10:52:33','',''),(2112637,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:52:33','',''),(2112652,'1','153','763',321,'Retail Sale Id 1256275',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:54:02','',''),(2112653,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:54:02','',''),(2112680,'1','153','763',321,'Retail Sale Id 1256292',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 10:57:27','',''),(2112681,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:57:27','',''),(2112692,'1','153','763',321,'Retail Sale Id 1256299',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 10:58:26','',''),(2112693,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 10:58:26','',''),(2112706,'1','153','763',321,'Retail Sale Id 1256306',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 10:59:21','',''),(2112707,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 10:59:21','',''),(2112722,'1','153','763',321,'Retail Sale Id 1256314',499.20,0.00,0.00,0.00,29.64,'2021-12-01 11:00:09','',''),(2112723,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 11:00:09','',''),(2112738,'1','153','763',321,'Retail Sale Id 1256322',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:01:47','',''),(2112739,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:01:47','',''),(2112740,'1','153','763',321,'Retail Sale Id 1256322',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:01:47','',''),(2112741,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:01:47','',''),(2112751,'1','153','763',321,'Retail Sale Id 1256327',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 11:02:54','',''),(2112752,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 11:02:54','',''),(2112765,'1','153','763',321,'Retail Sale Id 1256335',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:04:13','',''),(2112766,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:04:13','',''),(2112792,'1','153','763',321,'Retail Sale Id 1256350',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:06:03','',''),(2112793,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:06:03','',''),(2112818,'1','153','763',321,'Retail Sale Id 1256365',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:07:48','',''),(2112819,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:07:48','',''),(2112820,'1','153','763',321,'Retail Sale Id 1256365',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 11:07:48','',''),(2112821,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:07:48','',''),(2112838,'1','153','763',321,'Retail Sale Id 1256372',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:08:49','',''),(2112839,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:08:49','',''),(2112865,'1','153','763',321,'Retail Sale Id 1256389',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 11:10:53','',''),(2112866,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 11:10:53','',''),(2112880,'1','153','763',321,'Retail Sale Id 1256395',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 11:11:36','',''),(2112881,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 11:11:36','',''),(2112886,'1','153','763',321,'Retail Sale Id 1256401',1600.00,0.00,0.00,0.00,95.00,'2021-12-01 11:12:24','',''),(2112887,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 11:12:24','',''),(2112917,'1','153','763',321,'Retail Sale Id 1256407',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 11:13:13','',''),(2112918,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 11:13:13','',''),(2112919,'1','153','763',321,'Retail Sale Id 1256407',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 11:13:13','',''),(2112920,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 11:13:13','',''),(2112927,'1','153','763',321,'Retail Sale Id 1256411',652.80,0.00,0.00,0.00,38.76,'2021-12-01 11:14:14','',''),(2112928,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 11:14:14','',''),(2112954,'1','153','763',321,'Retail Sale Id 1256420',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:15:44','',''),(2112955,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:15:44','',''),(2112976,'1','153','763',321,'Retail Sale Id 1256432',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 11:16:49','',''),(2112977,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 11:16:49','',''),(2112999,'1','153','763',321,'Retail Sale Id 1256440',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:17:33','',''),(2113000,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:17:33','',''),(2113006,'1','153','763',321,'Retail Sale Id 1256445',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 11:18:09','',''),(2113007,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 11:18:09','',''),(2113024,'1','153','763',321,'Retail Sale Id 1256451',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 11:18:59','',''),(2113025,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:18:59','',''),(2113026,'1','153','763',321,'Retail Sale Id 1256451',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 11:18:59','',''),(2113027,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:18:59','',''),(2113048,'1','153','763',321,'Retail Sale Id 1256462',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 11:20:03','',''),(2113049,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 11:20:03','',''),(2113052,'1','153','763',321,'Retail Sale Id 1256465',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:20:50','',''),(2113053,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:20:50','',''),(2113114,'1','153','763',321,'Retail Sale Id 1256497',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:25:05','',''),(2113115,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:25:05','',''),(2113136,'1','153','763',321,'Retail Sale Id 1256504',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:26:01','',''),(2113137,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:26:01','',''),(2113162,'1','153','763',321,'Retail Sale Id 1256516',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 11:26:47','',''),(2113163,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 11:26:47','',''),(2113168,'1','153','763',321,'Retail Sale Id 1256520',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:27:33','',''),(2113169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:27:33','',''),(2113180,'1','153','763',321,'Retail Sale Id 1256527',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:28:14','',''),(2113181,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:28:14','',''),(2113214,'1','153','763',321,'Retail Sale Id 1256544',800.00,0.00,0.00,0.00,47.50,'2021-12-01 11:31:06','',''),(2113215,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 11:31:06','',''),(2113272,'1','153','763',321,'Retail Sale Id 1256579',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 11:36:05','',''),(2113273,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 11:36:05','',''),(2113292,'1','153','763',321,'Retail Sale Id 1256589',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:37:17','',''),(2113293,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:37:17','',''),(2113327,'1','153','763',321,'Retail Sale Id 1256605',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:39:48','',''),(2113328,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:39:48','',''),(2113329,'1','153','763',321,'Retail Sale Id 1256605',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:39:48','',''),(2113330,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:39:48','',''),(2113341,'1','153','763',321,'Retail Sale Id 1256614',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:40:45','',''),(2113342,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:40:45','',''),(2113380,'1','153','763',321,'Retail Sale Id 1256632',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:43:22','',''),(2113381,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:43:22','',''),(2113406,'1','153','763',321,'Retail Sale Id 1256650',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 11:45:41','',''),(2113407,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 11:45:41','',''),(2113417,'1','153','763',321,'Retail Sale Id 1256653',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:46:36','',''),(2113418,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:46:36','',''),(2113431,'1','153','763',321,'Retail Sale Id 1256662',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:48:21','',''),(2113432,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:48:21','',''),(2113433,'1','153','763',321,'Retail Sale Id 1256662',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:48:21','',''),(2113434,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:48:21','',''),(2113455,'1','153','763',321,'Retail Sale Id 1256671',403.20,0.00,0.00,0.00,23.94,'2021-12-01 11:49:45','',''),(2113456,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.63,0.00,'2021-12-01 11:49:45','',''),(2113475,'1','153','763',321,'Retail Sale Id 1256682',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:51:13','',''),(2113476,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:51:13','',''),(2113485,'1','153','763',321,'Retail Sale Id 1256687',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:52:15','',''),(2113486,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:52:15','',''),(2113487,'1','153','763',321,'Retail Sale Id 1256687',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:52:15','',''),(2113488,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:52:15','',''),(2113505,'1','153','763',321,'Retail Sale Id 1256698',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:53:39','',''),(2113506,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:53:39','',''),(2113523,'1','153','763',321,'Retail Sale Id 1256708',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 11:55:13','',''),(2113524,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 11:55:13','',''),(2113705,'1','153','763',321,'Retail Sale Id 1256807',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:12:44','',''),(2113706,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:12:44','',''),(2113729,'1','153','763',321,'Retail Sale Id 1256819',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 12:14:42','',''),(2113730,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:14:42','',''),(2113753,'1','153','763',321,'Retail Sale Id 1256831',1280.00,0.00,0.00,0.00,76.00,'2021-12-01 12:16:12','',''),(2113754,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:16:12','',''),(2113761,'1','153','763',321,'Retail Sale Id 1256836',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 12:16:52','',''),(2113762,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:16:52','',''),(2113773,'1','153','763',321,'Retail Sale Id 1256842',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 12:17:45','',''),(2113774,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 12:17:45','',''),(2113787,'1','153','763',321,'Retail Sale Id 1256848',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 12:18:47','',''),(2113788,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:18:47','',''),(2113963,'1','153','763',321,'Retail Sale Id 1256937',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 12:30:07','',''),(2113964,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 12:30:07','',''),(2113973,'1','153','763',321,'Retail Sale Id 1256943',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 12:31:48','',''),(2113974,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:31:48','',''),(2113989,'1','153','763',321,'Retail Sale Id 1256950',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:32:43','',''),(2113990,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:32:43','',''),(2114033,'1','153','763',321,'Retail Sale Id 1256970',6803.20,0.00,0.00,0.00,403.94,'2021-12-01 12:36:53','',''),(2114034,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.63,0.00,'2021-12-01 12:36:53','',''),(2114037,'1','153','763',321,'Retail Sale Id 1256975',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:37:51','',''),(2114038,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:37:51','',''),(2114047,'1','153','763',321,'Retail Sale Id 1256980',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 12:39:34','',''),(2114048,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:39:34','',''),(2114083,'1','153','763',321,'Retail Sale Id 1256998',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:42:58','',''),(2114084,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:42:58','',''),(2114093,'1','153','763',321,'Retail Sale Id 1257003',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 12:43:43','',''),(2114094,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:43:43','',''),(2114105,'1','153','763',321,'Retail Sale Id 1257009',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 12:45:26','',''),(2114106,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 12:45:26','',''),(2114111,'1','153','763',321,'Retail Sale Id 1257012',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:46:16','',''),(2114112,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:46:16','',''),(2114126,'1','153','763',321,'Retail Sale Id 1257017',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:47:12','',''),(2114127,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:47:12','',''),(2114128,'1','153','763',321,'Retail Sale Id 1257017',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:47:12','',''),(2114129,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:47:12','',''),(2114148,'1','153','763',321,'Retail Sale Id 1257027',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 12:50:02','',''),(2114149,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:50:02','',''),(2114150,'1','153','763',321,'Retail Sale Id 1257027',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:50:02','',''),(2114151,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:50:02','',''),(2114204,'1','153','763',321,'Retail Sale Id 1257059',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:56:07','',''),(2114205,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:56:07','',''),(2114228,'1','153','763',321,'Retail Sale Id 1257074',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 12:59:44','',''),(2114229,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 12:59:44','',''),(2114230,'1','153','763',321,'Retail Sale Id 1257074',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 12:59:44','',''),(2114231,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:59:44','',''),(2114242,'1','153','763',321,'Retail Sale Id 1257080',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 13:00:44','',''),(2114243,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:00:44','',''),(2114254,'1','153','763',321,'Retail Sale Id 1257086',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 13:01:56','',''),(2114255,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 13:01:56','',''),(2114333,'1','153','763',321,'Retail Sale Id 1257108',5798.40,0.00,0.00,0.00,344.28,'2021-12-01 13:05:54','',''),(2114334,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.06,0.00,'2021-12-01 13:05:54','',''),(2114346,'1','153','763',321,'Retail Sale Id 1257116',652.80,0.00,0.00,0.00,38.76,'2021-12-01 13:07:12','',''),(2114347,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 13:07:12','',''),(2114374,'1','153','763',321,'Retail Sale Id 1257131',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 13:09:02','',''),(2114375,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:09:02','',''),(2114384,'1','153','763',321,'Retail Sale Id 1257145',7500.80,0.00,0.00,0.00,445.36,'2021-12-01 13:10:28','',''),(2114385,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-01 13:10:28','',''),(2114392,'1','153','763',321,'Retail Sale Id 1257183',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:11:21','',''),(2114393,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:11:21','',''),(2114412,'1','153','763',321,'Retail Sale Id 1257194',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 13:12:05','',''),(2114413,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:12:05','',''),(2114470,'1','153','763',321,'Retail Sale Id 1257226',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 13:15:18','',''),(2114471,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:15:18','',''),(2114502,'1','153','763',321,'Retail Sale Id 1257242',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 13:17:27','',''),(2114503,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:17:27','',''),(2114518,'1','153','763',321,'Retail Sale Id 1257249',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 13:19:08','',''),(2114519,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:19:08','',''),(2114538,'1','153','763',321,'Retail Sale Id 1257261',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 13:20:46','',''),(2114539,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 13:20:46','',''),(2114564,'1','153','763',321,'Retail Sale Id 1257278',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 13:22:43','',''),(2114565,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 13:22:43','',''),(2114582,'1','153','763',321,'Retail Sale Id 1257287',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 13:24:08','',''),(2114583,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 13:24:08','',''),(2114584,'1','153','763',321,'Retail Sale Id 1257287',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:24:08','',''),(2114585,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:24:08','',''),(2114665,'1','153','763',321,'Retail Sale Id 1257323',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 13:30:56','',''),(2114666,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 13:30:56','',''),(2114681,'1','153','763',321,'Retail Sale Id 1257331',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:32:53','',''),(2114682,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:32:53','',''),(2114695,'1','153','763',321,'Retail Sale Id 1257338',2803.20,0.00,0.00,0.00,166.44,'2021-12-01 13:33:51','',''),(2114696,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 13:33:51','',''),(2114717,'1','153','763',321,'Retail Sale Id 1257350',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:35:40','',''),(2114718,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:35:40','',''),(2114874,'1','153','763',321,'Retail Sale Id 1257391',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 13:42:46','',''),(2114875,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:42:46','',''),(2114894,'1','153','763',321,'Retail Sale Id 1257396',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:43:54','',''),(2114895,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:43:54','',''),(2114992,'1','153','763',321,'Retail Sale Id 1257431',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 13:49:20','',''),(2114993,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 13:49:20','',''),(2115088,'1','153','763',321,'Retail Sale Id 1257474',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 13:54:46','',''),(2115089,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 13:54:46','',''),(2115106,'1','153','763',321,'Retail Sale Id 1257484',800.00,0.00,0.00,0.00,47.50,'2021-12-01 13:55:48','',''),(2115107,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 13:55:48','',''),(2115114,'1','153','763',321,'Retail Sale Id 1257490',998.40,0.00,0.00,0.00,59.28,'2021-12-01 13:56:24','',''),(2115115,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:56:24','',''),(2115190,'1','153','763',321,'Retail Sale Id 1257526',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 13:59:57','',''),(2115191,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 13:59:57','',''),(2115204,'1','153','763',321,'Retail Sale Id 1257533',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 14:00:48','',''),(2115205,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:00:48','',''),(2115235,'1','153','763',321,'Retail Sale Id 1257548',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 14:02:08','',''),(2115236,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 14:02:08','',''),(2115297,'1','153','763',321,'Retail Sale Id 1257577',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 14:05:49','',''),(2115298,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:05:49','',''),(2115327,'1','153','763',321,'Retail Sale Id 1257591',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 14:07:59','',''),(2115328,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 14:07:59','',''),(2115343,'1','153','763',321,'Retail Sale Id 1257599',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 14:08:55','',''),(2115344,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 14:08:55','',''),(2115365,'1','153','763',321,'Retail Sale Id 1257620',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 14:11:00','',''),(2115366,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 14:11:00','',''),(2115433,'1','153','763',321,'Retail Sale Id 1257657',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:15:33','',''),(2115434,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:15:33','',''),(2115459,'1','153','763',321,'Retail Sale Id 1257670',2803.20,0.00,0.00,0.00,166.44,'2021-12-01 14:17:11','',''),(2115460,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 14:17:11','',''),(2115473,'1','153','763',321,'Retail Sale Id 1257678',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 14:18:26','',''),(2115474,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:18:26','',''),(2115504,'1','153','763',321,'Retail Sale Id 1257688',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 14:19:52','',''),(2115505,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:19:52','',''),(2115518,'1','153','763',321,'Retail Sale Id 1257695',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:21:07','',''),(2115519,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:21:07','',''),(2115575,'1','153','763',321,'Retail Sale Id 1257735',998.40,0.00,0.00,0.00,59.28,'2021-12-01 14:25:42','',''),(2115576,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:25:42','',''),(2115577,'1','153','763',321,'Retail Sale Id 1257735',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:25:42','',''),(2115578,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:25:42','',''),(2115579,'1','153','763',321,'Retail Sale Id 1257735',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:25:42','',''),(2115580,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:25:42','',''),(2116600,'1','153','763',321,'Retail Sale Id 1258202',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 15:33:35','',''),(2116601,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:33:35','',''),(2116602,'1','153','763',321,'Retail Sale Id 1258202',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 15:33:35','',''),(2116603,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:33:35','',''),(2116612,'1','153','763',321,'Retail Sale Id 1258207',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 15:34:22','',''),(2116613,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 15:34:22','',''),(2116626,'1','153','763',321,'Retail Sale Id 1258216',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 15:35:24','',''),(2116627,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:35:24','',''),(2116658,'1','153','763',321,'Retail Sale Id 1258232',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:37:22','',''),(2116659,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:37:22','',''),(2116752,'1','153','763',321,'Retail Sale Id 1258275',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 15:43:34','',''),(2116753,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:43:34','',''),(2116786,'1','153','763',321,'Retail Sale Id 1258286',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:44:46','',''),(2116787,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:44:47','',''),(2116830,'1','153','763',321,'Retail Sale Id 1258309',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:46:44','',''),(2116831,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:46:44','',''),(2116876,'1','153','763',321,'Retail Sale Id 1258331',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:48:54','',''),(2116877,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:48:54','',''),(2116926,'1','153','763',321,'Retail Sale Id 1258358',499.20,0.00,0.00,0.00,29.64,'2021-12-01 15:50:47','',''),(2116927,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 15:50:47','',''),(2116962,'1','153','763',321,'Retail Sale Id 1258374',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:51:50','',''),(2116963,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:51:50','',''),(2116992,'1','153','763',321,'Retail Sale Id 1258388',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:53:12','',''),(2116993,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:53:12','',''),(2116994,'1','153','763',321,'Retail Sale Id 1258388',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:53:12','',''),(2116995,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:53:12','',''),(2117041,'1','153','763',321,'Retail Sale Id 1258409',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 15:55:26','',''),(2117042,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 15:55:26','',''),(2117076,'1','153','763',321,'Retail Sale Id 1258424',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 15:56:46','',''),(2117077,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 15:56:46','',''),(2117104,'1','153','763',321,'Retail Sale Id 1258442',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 15:58:08','',''),(2117105,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 15:58:08','',''),(2117129,'1','153','763',321,'Retail Sale Id 1258453',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:59:20','',''),(2117130,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:59:20','',''),(2117162,'1','153','763',321,'Retail Sale Id 1258467',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:00:26','',''),(2117163,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:00:26','',''),(2117193,'1','153','763',321,'Retail Sale Id 1258485',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:01:58','',''),(2117194,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:01:58','',''),(2117217,'1','153','763',321,'Retail Sale Id 1258498',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:03:19','',''),(2117218,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:03:19','',''),(2117219,'1','153','763',321,'Retail Sale Id 1258498',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:03:19','',''),(2117220,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:03:19','',''),(2117239,'1','153','763',321,'Retail Sale Id 1258508',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:04:31','',''),(2117240,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:04:31','',''),(2117283,'1','153','763',321,'Retail Sale Id 1258523',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:05:55','',''),(2117284,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:05:55','',''),(2117320,'1','153','763',321,'Retail Sale Id 1258541',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 16:07:17','',''),(2117321,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:07:17','',''),(2117366,'1','153','763',321,'Retail Sale Id 1258556',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:08:46','',''),(2117367,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:08:46','',''),(2117395,'1','153','763',321,'Retail Sale Id 1258567',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:10:00','',''),(2117396,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:10:00','',''),(2117420,'1','153','763',321,'Retail Sale Id 1258577',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 16:11:01','',''),(2117421,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:11:01','',''),(2117442,'1','153','763',321,'Retail Sale Id 1258586',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:12:12','',''),(2117443,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:12:12','',''),(2117484,'1','153','763',321,'Retail Sale Id 1258603',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 16:13:42','',''),(2117485,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 16:13:42','',''),(2117577,'1','153','763',321,'Retail Sale Id 1258652',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 16:17:16','',''),(2117578,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 16:17:16','',''),(2117603,'1','153','763',321,'Retail Sale Id 1258667',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:18:37','',''),(2117604,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:18:37','',''),(2117629,'1','153','763',321,'Retail Sale Id 1258683',4499.20,0.00,0.00,0.00,267.14,'2021-12-01 16:19:54','',''),(2117630,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 16:19:54','',''),(2117631,'1','153','763',321,'Retail Sale Id 1258683',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:19:54','',''),(2117632,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:19:54','',''),(2117633,'1','153','763',321,'Retail Sale Id 1258683',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:19:54','',''),(2117634,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:19:54','',''),(2117682,'1','153','763',321,'Retail Sale Id 1258704',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:21:36','',''),(2117683,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:21:36','',''),(2117716,'1','153','763',321,'Retail Sale Id 1258723',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:23:09','',''),(2117717,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:23:09','',''),(2117718,'1','153','763',321,'Retail Sale Id 1258723',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:23:09','',''),(2117719,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:23:09','',''),(2117842,'1','153','763',321,'Retail Sale Id 1258804',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:29:05','',''),(2117843,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:29:05','',''),(2117844,'1','153','763',321,'Retail Sale Id 1258804',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:29:05','',''),(2117845,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:29:05','',''),(2117938,'1','153','763',321,'Retail Sale Id 1258855',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 16:33:50','',''),(2117939,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 16:33:50','',''),(2117988,'1','153','763',321,'Retail Sale Id 1258882',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:36:40','',''),(2117989,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:36:40','',''),(2118068,'1','153','763',321,'Retail Sale Id 1258921',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:40:09','',''),(2118069,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:40:09','',''),(2118092,'1','153','763',321,'Retail Sale Id 1258939',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:41:11','',''),(2118093,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:41:11','',''),(2118122,'1','153','763',321,'Retail Sale Id 1258956',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:43:06','',''),(2118123,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:43:06','',''),(2118148,'1','153','763',321,'Retail Sale Id 1258967',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 16:44:15','',''),(2118149,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:44:15','',''),(2118168,'1','153','763',321,'Retail Sale Id 1258979',6502.40,0.00,0.00,0.00,386.08,'2021-12-01 16:45:16','',''),(2118169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 16:45:16','',''),(2118194,'1','153','763',321,'Retail Sale Id 1258991',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:46:45','',''),(2118195,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:46:45','',''),(2118212,'1','153','763',321,'Retail Sale Id 1259001',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:47:53','',''),(2118213,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:47:53','',''),(2118214,'1','153','763',321,'Retail Sale Id 1259001',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:47:53','',''),(2118215,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:47:53','',''),(2118250,'1','153','763',321,'Retail Sale Id 1259020',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 16:49:37','',''),(2118251,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:49:37','',''),(2118266,'1','153','763',321,'Retail Sale Id 1259029',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:50:28','',''),(2118267,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:50:28','',''),(2118298,'1','153','763',321,'Retail Sale Id 1259046',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 16:51:57','',''),(2118299,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 16:51:57','',''),(2118359,'1','153','763',321,'Retail Sale Id 1259066',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 16:53:44','',''),(2118360,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 16:53:44','',''),(2118409,'1','153','763',321,'Retail Sale Id 1259096',2297.60,0.00,0.00,0.00,136.42,'2021-12-01 16:55:57','',''),(2118410,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-01 16:55:57','',''),(2118456,'1','153','763',321,'Retail Sale Id 1259120',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:58:12','',''),(2118457,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:58:12','',''),(2118548,'1','153','763',321,'Retail Sale Id 1259170',499.20,0.00,0.00,0.00,29.64,'2021-12-01 17:02:02','',''),(2118549,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 17:02:02','',''),(2118628,'1','153','763',321,'Retail Sale Id 1259204',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 17:05:59','',''),(2118629,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:05:59','',''),(2118660,'1','153','763',321,'Retail Sale Id 1259222',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 17:07:42','',''),(2118661,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:07:42','',''),(2118726,'1','153','763',321,'Retail Sale Id 1259254',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 17:11:26','',''),(2118727,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:11:26','',''),(2118744,'1','153','763',321,'Retail Sale Id 1259264',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 17:12:31','',''),(2118745,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:12:31','',''),(2118762,'1','153','763',321,'Retail Sale Id 1259275',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 17:13:23','',''),(2118763,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 17:13:23','',''),(2118979,'1','153','763',321,'Retail Sale Id 1259382',652.80,0.00,0.00,0.00,38.76,'2021-12-01 17:27:41','',''),(2118980,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 17:27:41','',''),(2119861,'1','153','763',321,'Return of Retail Sale Id 1259382',0.00,652.80,1.02,0.00,-38.76,'2021-12-01 19:51:29','',''),(2119881,'1','153','763',321,'Return of Retail Sale Id 1257116',0.00,652.80,1.02,0.00,-38.76,'2021-12-01 19:53:40','',''),(2119888,'1','153','763',321,'Return of Retail Sale Id 1256411',0.00,652.80,1.02,0.00,-38.76,'2021-12-01 19:55:18','',''),(2120009,'1','153','763',321,'Return of Retail Sale Id 1256322',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:16:52','',''),(2120010,'1','153','763',321,'Return of Retail Sale Id 1256322',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:16:52','',''),(2120011,'1','153','763',321,'Return of Retail Sale Id 1255867',0.00,3840.00,6.00,0.00,-228.00,'2021-12-01 20:19:22','',''),(2120012,'1','153','763',321,'Return of Retail Sale Id 1255867',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:19:22','',''),(2120013,'1','153','763',321,'Return of Retail Sale Id 1255867',0.00,27136.00,42.40,0.00,-1611.20,'2021-12-01 20:19:22','',''),(2120014,'1','153','763',321,'Return of Retail Sale Id 1255867',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-01 20:19:22','',''),(2120015,'1','153','763',321,'Return of Retail Sale Id 1255867',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-01 20:19:22','',''),(2120016,'1','153','763',321,'Return of Retail Sale Id 1255456',0.00,3200.00,5.00,0.00,-190.00,'2021-12-01 20:23:03','',''),(2120017,'1','153','763',321,'Return of Retail Sale Id 1255456',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:23:03','',''),(2120018,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,1952.00,3.05,0.00,-115.90,'2021-12-01 20:24:54','',''),(2120019,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,3200.00,5.00,0.00,-190.00,'2021-12-01 20:24:54','',''),(2120020,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,3200.00,5.00,0.00,-190.00,'2021-12-01 20:24:54','',''),(2120021,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,6400.00,10.00,0.00,-380.00,'2021-12-01 20:24:54','',''),(2120022,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,6400.00,10.00,0.00,-380.00,'2021-12-01 20:24:54','',''),(2120023,'1','153','763',321,'Return of Retail Sale Id 1255258',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:24:54','',''),(2120024,'1','153','763',321,'Return of Retail Sale Id 1255274',0.00,16000.00,25.00,0.00,-950.00,'2021-12-01 20:26:47','',''),(2120025,'1','153','763',321,'Return of Retail Sale Id 1255338',0.00,3001.60,4.69,0.00,-178.22,'2021-12-01 20:27:58','',''),(2120026,'1','153','763',321,'Return of Retail Sale Id 1255338',0.00,7001.60,10.94,0.00,-415.72,'2021-12-01 20:27:58','',''),(2120027,'1','153','763',321,'Return of Retail Sale Id 1254859',0.00,3852.80,6.02,0.00,-228.76,'2021-12-01 20:29:32','',''),(2120028,'1','153','763',321,'Return of Retail Sale Id 1254859',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:29:32','',''),(2120041,'1','153','763',321,'Return of Retail Sale Id 1254646',0.00,652.80,1.02,0.00,-38.76,'2021-12-01 20:31:18','',''),(2120043,'1','153','763',321,'Return of Retail Sale Id 1254479',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:33:19','',''),(2120044,'1','153','763',321,'Return of Retail Sale Id 1254479',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:33:19','',''),(2120047,'1','153','763',321,'Return of Retail Sale Id 1254083',0.00,3200.00,5.00,0.00,-190.00,'2021-12-01 20:35:25','',''),(2120048,'1','153','763',321,'Return of Retail Sale Id 1254083',0.00,7302.40,11.41,0.00,-433.58,'2021-12-01 20:35:25','',''),(2120049,'1','153','763',321,'Return of Retail Sale Id 1258683',0.00,4499.20,7.03,0.00,-267.14,'2021-12-01 20:37:08','',''),(2120050,'1','153','763',321,'Return of Retail Sale Id 1258683',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:37:08','',''),(2120051,'1','153','763',321,'Return of Retail Sale Id 1258683',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:37:08','',''),(2120052,'1','153','763',321,'Return of Retail Sale Id 1258804',0.00,3200.00,5.00,0.00,-190.00,'2021-12-01 20:39:07','',''),(2120053,'1','153','763',321,'Return of Retail Sale Id 1258804',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:39:07','',''),(2120055,'1','153','763',321,'Return of Retail Sale Id 1258388',0.00,3852.80,6.02,0.00,-228.76,'2021-12-01 20:41:03','',''),(2120056,'1','153','763',321,'Return of Retail Sale Id 1258388',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:41:03','',''),(2120059,'1','153','763',321,'Return of Retail Sale Id 1257735',0.00,998.40,1.56,0.00,-59.28,'2021-12-01 20:42:17','',''),(2120060,'1','153','763',321,'Return of Retail Sale Id 1257735',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:42:17','',''),(2120061,'1','153','763',321,'Return of Retail Sale Id 1257735',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:42:17','',''),(2120062,'1','153','763',321,'Return of Retail Sale Id 1257287',0.00,3001.60,4.69,0.00,-178.22,'2021-12-01 20:44:16','',''),(2120063,'1','153','763',321,'Return of Retail Sale Id 1257287',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:44:16','',''),(2120064,'1','153','763',321,'Return of Retail Sale Id 1257027',0.00,3001.60,4.69,0.00,-178.22,'2021-12-01 20:46:01','',''),(2120065,'1','153','763',321,'Return of Retail Sale Id 1257027',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:46:01','',''),(2120066,'1','153','763',321,'Return of Retail Sale Id 1257017',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:47:46','',''),(2120067,'1','153','763',321,'Return of Retail Sale Id 1257017',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:47:46','',''),(2120069,'1','153','763',321,'Return of Retail Sale Id 1256687',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:51:03','',''),(2120070,'1','153','763',321,'Return of Retail Sale Id 1256687',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:51:03','',''),(2120073,'1','153','763',321,'Return of Retail Sale Id 1256605',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:52:44','',''),(2120074,'1','153','763',321,'Return of Retail Sale Id 1256605',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:52:44','',''),(2120075,'1','153','763',321,'Return of Retail Sale Id 1256232',0.00,3852.80,6.02,0.00,-228.76,'2021-12-01 20:55:14','',''),(2120076,'1','153','763',321,'Return of Retail Sale Id 1256232',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 20:55:14','',''),(2120078,'1','153','763',321,'Return of Retail Sale Id 1256544',0.00,800.00,1.25,0.00,-47.50,'2021-12-01 20:59:20','',''),(2120081,'1','153','763',321,'Return of Retail Sale Id 1259170',0.00,499.20,0.78,0.00,-29.64,'2021-12-01 21:01:27','',''),(2120082,'1','153','763',321,'Return of Retail Sale Id 1256671',0.00,403.20,0.63,0.00,-23.94,'2021-12-01 21:03:19','',''),(2120083,'1','153','763',321,'Return of Retail Sale Id 1256145',0.00,601.60,0.94,0.00,-35.72,'2021-12-01 21:05:40','',''),(2120084,'1','153','763',321,'Return of Retail Sale Id 1255293',0.00,652.80,1.02,0.00,-38.76,'2021-12-01 21:09:32','',''),(2120085,'1','153','763',321,'Return of Retail Sale Id 1254499',0.00,8000.00,12.50,0.00,-475.00,'2021-12-01 21:11:43','',''),(2120086,'1','153','763',321,'Retail Sale Id 1259764',640000.00,0.00,0.00,0.00,38000.00,'2021-12-01 21:13:44','',''),(2120087,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-01 21:13:44','',''),(2120103,'1','153','763',321,'Retail Sale Id 1259768',71148.00,0.00,0.00,0.00,1617.00,'2021-12-01 21:34:13','',''),(2120104,'1','153','763',321,'Retail sales',0.00,0.00,0.00,115.50,0.00,'2021-12-01 21:34:13','',''),(2120105,'1','153','763',321,'Retail Sale Id 1259769',4780.80,0.00,0.00,0.00,283.86,'2021-12-01 21:37:07','',''),(2120106,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.47,0.00,'2021-12-01 21:37:07','',''),(2120108,'1','153','763',321,'Retail Sale Id 1259770',123462.40,0.00,0.00,0.00,7330.58,'2021-12-01 21:39:28','',''),(2120109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,192.91,0.00,'2021-12-01 21:39:28','',''),(2120110,'1','153','763',321,'Return of Retail Sale Id 1259770',0.00,123462.40,192.91,0.00,-7330.58,'2021-12-01 21:40:51','',''),(2120119,'1','153','763',321,'Retail Sale Id 1259771',123462.40,0.00,0.00,0.00,7330.58,'2021-12-01 21:42:04','',''),(2120120,'1','153','763',321,'Retail sales',0.00,0.00,0.00,192.91,0.00,'2021-12-01 21:42:04','',''),(2120125,'1','153','763',321,'Retail Sale Id 1259772',105593.60,0.00,0.00,0.00,6269.62,'2021-12-01 21:44:44','',''),(2120126,'1','153','763',321,'Retail sales',0.00,0.00,0.00,164.99,0.00,'2021-12-01 21:44:44','',''),(2120127,'1','153','763',321,'Return of Retail Sale Id 1256041',0.00,6776.00,11.00,0.00,-154.00,'2021-12-01 21:48:32','',''),(2120128,'1','153','763',321,'Retail Sale Id 1259773',2560.00,0.00,0.00,0.00,152.00,'2021-12-01 21:50:51','',''),(2120129,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 21:50:51','',''),(2120130,'1','153','763',321,'Retail Sale Id 1259774',4480.00,0.00,0.00,0.00,266.00,'2021-12-01 21:54:21','',''),(2120131,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 21:54:21','',''),(2120337,'1','153','763',321,'Retail Sale Id 1259822',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:00:13','',''),(2120338,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:00:13','',''),(2120355,'1','153','763',321,'Retail Sale Id 1259828',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 06:01:23','',''),(2120356,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 06:01:23','',''),(2120377,'1','153','763',321,'Retail Sale Id 1259839',652.80,0.00,0.00,0.00,38.76,'2021-12-02 06:02:48','',''),(2120378,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-02 06:02:48','',''),(2121855,'1','153','763',321,'Retail Sale Id 1260509',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:29:29','',''),(2121856,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:29:29','',''),(2121873,'1','153','763',321,'Retail Sale Id 1260518',2560.00,0.00,0.00,0.00,152.00,'2021-12-02 07:30:47','',''),(2121874,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:30:47','',''),(2121889,'1','153','763',321,'Retail Sale Id 1260529',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 07:31:37','',''),(2121890,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 07:31:37','',''),(2121909,'1','153','763',321,'Retail Sale Id 1260550',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:33:18','',''),(2121910,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:33:18','',''),(2121911,'1','153','763',321,'Retail Sale Id 1260550',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:33:18','',''),(2121912,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:33:18','',''),(2121933,'1','153','763',321,'Retail Sale Id 1260563',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 07:34:36','',''),(2121934,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:34:36','',''),(2121935,'1','153','763',321,'Retail Sale Id 1260564',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:34:47','',''),(2121936,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:34:47','',''),(2121951,'1','153','763',321,'Retail Sale Id 1260572',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 07:35:31','',''),(2121952,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:35:31','',''),(2121961,'1','153','763',321,'Retail Sale Id 1260578',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 07:36:23','',''),(2121962,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:36:23','',''),(2121969,'1','153','763',321,'Retail Sale Id 1260581',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:36:51','',''),(2121970,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:36:51','',''),(2121977,'1','153','763',321,'Retail Sale Id 1260585',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 07:37:13','',''),(2121978,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:37:13','',''),(2121999,'1','153','763',321,'Retail Sale Id 1260599',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:38:07','',''),(2122000,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:38:07','',''),(2122019,'1','153','763',321,'Retail Sale Id 1260608',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:38:49','',''),(2122020,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:38:49','',''),(2122037,'1','153','763',321,'Retail Sale Id 1260620',748.80,0.00,0.00,0.00,44.46,'2021-12-02 07:39:38','',''),(2122038,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.17,0.00,'2021-12-02 07:39:38','',''),(2122058,'1','153','763',321,'Retail Sale Id 1260626',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:40:21','',''),(2122059,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:40:21','',''),(2122078,'1','153','763',321,'Retail Sale Id 1260639',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 07:41:09','',''),(2122079,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:41:09','',''),(2122090,'1','153','763',321,'Retail Sale Id 1260640',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 07:41:46','',''),(2122091,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:41:46','',''),(2122108,'1','153','763',321,'Retail Sale Id 1260654',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 07:42:13','',''),(2122109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:42:13','',''),(2122110,'1','153','763',321,'Retail Sale Id 1260654',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:42:13','',''),(2122111,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:42:13','',''),(2122132,'1','153','763',321,'Retail Sale Id 1260665',9600.00,0.00,0.00,0.00,570.00,'2021-12-02 07:43:22','',''),(2122133,'1','153','763',321,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 07:43:22','',''),(2122137,'1','153','763',321,'Retail Sale Id 1260667',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:44:01','',''),(2122138,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:44:01','',''),(2122139,'1','153','763',321,'Retail Sale Id 1260667',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:44:01','',''),(2122140,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:44:01','',''),(2122165,'1','153','763',321,'Retail Sale Id 1260682',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:45:27','',''),(2122166,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:45:27','',''),(2122169,'1','153','763',321,'Retail Sale Id 1260684',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:45:43','',''),(2122170,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:45:43','',''),(2122199,'1','153','763',321,'Retail Sale Id 1260697',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:47:18','',''),(2122200,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:47:18','',''),(2122217,'1','153','763',321,'Retail Sale Id 1260709',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:48:02','',''),(2122218,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:48:02','',''),(2122329,'1','153','763',321,'Retail Sale Id 1260752',652.80,0.00,0.00,0.00,38.76,'2021-12-02 07:51:36','',''),(2122330,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-02 07:51:36','',''),(2122353,'1','153','763',321,'Retail Sale Id 1260765',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:52:22','',''),(2122354,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:52:22','',''),(2122406,'1','153','763',321,'Retail Sale Id 1260789',23680.00,0.00,0.00,0.00,1406.00,'2021-12-02 07:54:52','',''),(2122407,'1','153','763',321,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-02 07:54:52','',''),(2122408,'1','153','763',321,'Retail Sale Id 1260789',23680.00,0.00,0.00,0.00,1406.00,'2021-12-02 07:54:52','',''),(2122409,'1','153','763',321,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-02 07:54:52','',''),(2122410,'1','153','763',321,'Retail Sale Id 1260789',23680.00,0.00,0.00,0.00,1406.00,'2021-12-02 07:54:52','',''),(2122411,'1','153','763',321,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-02 07:54:52','',''),(2122480,'1','153','763',321,'Retail Sale Id 1260819',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:57:54','',''),(2122481,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:57:55','',''),(2122563,'1','153','763',321,'Retail Sale Id 1260845',30800.00,0.00,0.00,0.00,700.00,'2021-12-02 08:00:02','',''),(2122564,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:00:02','',''),(2122585,'1','153','763',321,'Retail Sale Id 1260865',30800.00,0.00,0.00,0.00,700.00,'2021-12-02 08:01:03','',''),(2122586,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:01:03','',''),(2122605,'1','153','763',321,'Retail Sale Id 1260873',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 08:02:04','',''),(2122606,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 08:02:04','',''),(2122643,'1','153','763',321,'Retail Sale Id 1260892',2560.00,0.00,0.00,0.00,152.00,'2021-12-02 08:04:12','',''),(2122644,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 08:04:12','',''),(2122645,'1','153','763',321,'Retail Sale Id 1260892',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:04:12','',''),(2122646,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:04:12','',''),(2122675,'1','153','763',321,'Retail Sale Id 1260907',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 08:05:19','',''),(2122676,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:05:19','',''),(2122703,'1','153','763',321,'Retail Sale Id 1260917',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 08:06:24','',''),(2122704,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 08:06:24','',''),(2122751,'1','153','763',321,'Retail Sale Id 1260947',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:09:10','',''),(2122752,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:09:10','',''),(2122767,'1','153','763',321,'Retail Sale Id 1260954',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:10:21','',''),(2122768,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:10:21','',''),(2122783,'1','153','763',321,'Retail Sale Id 1260965',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 08:11:08','',''),(2122784,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 08:11:08','',''),(2122795,'1','153','763',321,'Retail Sale Id 1260971',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 08:11:52','',''),(2122796,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 08:11:52','',''),(2122807,'1','153','763',321,'Retail Sale Id 1260976',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:12:44','',''),(2122808,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:12:44','',''),(2122827,'1','153','763',321,'Retail Sale Id 1260989',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:13:39','',''),(2122828,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:13:39','',''),(2122850,'1','153','763',321,'Retail Sale Id 1260996',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:15:02','',''),(2122851,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:15:02','',''),(2122852,'1','153','763',321,'Retail Sale Id 1260996',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:15:02','',''),(2122853,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:15:02','',''),(2122872,'1','153','763',321,'Retail Sale Id 1261011',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:16:28','',''),(2122873,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:16:28','',''),(2122890,'1','153','763',321,'Retail Sale Id 1261023',2150.40,0.00,0.00,0.00,127.68,'2021-12-02 08:17:31','',''),(2122891,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.36,0.00,'2021-12-02 08:17:31','',''),(2122920,'1','153','763',321,'Retail Sale Id 1261038',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 08:18:40','',''),(2122921,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 08:18:40','',''),(2122940,'1','153','763',321,'Retail Sale Id 1261043',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:19:43','',''),(2122941,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:19:43','',''),(2122960,'1','153','763',321,'Retail Sale Id 1261060',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:20:38','',''),(2122961,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:20:38','',''),(2122976,'1','153','763',321,'Retail Sale Id 1261067',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:21:34','',''),(2122977,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:21:34','',''),(2122994,'1','153','763',321,'Retail Sale Id 1261079',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 08:22:32','',''),(2122995,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:22:32','',''),(2123019,'1','153','763',321,'Retail Sale Id 1261093',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:23:34','',''),(2123020,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:23:34','',''),(2123043,'1','153','763',321,'Retail Sale Id 1261100',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:24:31','',''),(2123044,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:24:31','',''),(2123069,'1','153','763',321,'Retail Sale Id 1261113',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:25:44','',''),(2123070,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:25:44','',''),(2123097,'1','153','763',321,'Retail Sale Id 1261125',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:27:11','',''),(2123098,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:27:11','',''),(2123187,'1','153','763',321,'Retail Sale Id 1261173',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 08:32:31','',''),(2123188,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 08:32:31','',''),(2123205,'1','153','763',321,'Retail Sale Id 1261183',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:33:24','',''),(2123206,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:33:24','',''),(2123217,'1','153','763',321,'Retail Sale Id 1261189',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 08:34:08','',''),(2123218,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 08:34:08','',''),(2123231,'1','153','763',321,'Retail Sale Id 1261197',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:35:08','',''),(2123232,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:35:08','',''),(2123263,'1','153','763',321,'Retail Sale Id 1261210',1600.00,0.00,0.00,0.00,95.00,'2021-12-02 08:36:33','',''),(2123264,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 08:36:33','',''),(2123317,'1','153','763',321,'Retail Sale Id 1261224',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 08:38:36','',''),(2123318,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:38:36','',''),(2123348,'1','153','763',321,'Retail Sale Id 1261233',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:39:20','',''),(2123349,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:39:20','',''),(2123373,'1','153','763',321,'Retail Sale Id 1261244',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:40:34','',''),(2123374,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:40:34','',''),(2123415,'1','153','763',321,'Retail Sale Id 1261267',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:42:45','',''),(2123416,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:42:45','',''),(2123427,'1','153','763',321,'Retail Sale Id 1261274',12160.00,0.00,0.00,0.00,722.00,'2021-12-02 08:43:40','',''),(2123428,'1','153','763',321,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 08:43:40','',''),(2123455,'1','153','763',321,'Retail Sale Id 1261288',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:44:49','',''),(2123456,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:44:49','',''),(2123467,'1','153','763',321,'Retail Sale Id 1261292',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:45:42','',''),(2123468,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:45:42','',''),(2123487,'1','153','763',321,'Retail Sale Id 1261302',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:46:46','',''),(2123488,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:46:46','',''),(2123579,'1','153','763',321,'Retail Sale Id 1261350',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 08:52:45','',''),(2123580,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 08:52:45','',''),(2123591,'1','153','763',321,'Retail Sale Id 1261355',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:53:27','',''),(2123592,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:53:27','',''),(2123667,'1','153','763',321,'Retail Sale Id 1261392',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:57:25','',''),(2123668,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:57:25','',''),(2123699,'1','153','763',321,'Retail Sale Id 1261403',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:59:14','',''),(2123700,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:59:14','',''),(2123701,'1','153','763',321,'Retail Sale Id 1261403',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:59:14','',''),(2123702,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:59:14','',''),(2123731,'1','153','763',321,'Retail Sale Id 1261421',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:00:43','',''),(2123732,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:00:43','',''),(2123755,'1','153','763',321,'Retail Sale Id 1261434',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:01:54','',''),(2123756,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:01:54','',''),(2123775,'1','153','763',321,'Retail Sale Id 1261464',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:03:08','',''),(2123776,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:03:08','',''),(2123817,'1','153','763',321,'Retail Sale Id 1261479',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:05:16','',''),(2123818,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:05:16','',''),(2123833,'1','153','763',321,'Retail Sale Id 1261488',998.40,0.00,0.00,0.00,59.28,'2021-12-02 09:06:00','',''),(2123834,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:06:00','',''),(2123865,'1','153','763',321,'Retail Sale Id 1261508',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:07:28','',''),(2123866,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:07:28','',''),(2123883,'1','153','763',321,'Retail Sale Id 1261516',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:08:16','',''),(2123884,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:08:16','',''),(2123963,'1','153','763',321,'Retail Sale Id 1261550',1932.80,0.00,0.00,0.00,114.76,'2021-12-02 09:11:29','',''),(2123964,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-02 09:11:29','',''),(2124001,'1','153','763',321,'Retail Sale Id 1261569',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 09:13:35','',''),(2124002,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 09:13:35','',''),(2124017,'1','153','763',321,'Retail Sale Id 1261575',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:14:39','',''),(2124018,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:14:39','',''),(2124128,'1','153','763',321,'Retail Sale Id 1261607',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:18:20','',''),(2124129,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:18:20','',''),(2124176,'1','153','763',321,'Retail Sale Id 1261637',998.40,0.00,0.00,0.00,59.28,'2021-12-02 09:21:21','',''),(2124177,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:21:21','',''),(2124184,'1','153','763',321,'Retail Sale Id 1261642',499.20,0.00,0.00,0.00,29.64,'2021-12-02 09:22:04','',''),(2124185,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 09:22:04','',''),(2124204,'1','153','763',321,'Retail Sale Id 1261653',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 09:23:07','',''),(2124205,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 09:23:07','',''),(2124224,'1','153','763',321,'Retail Sale Id 1261662',6502.40,0.00,0.00,0.00,386.08,'2021-12-02 09:24:06','',''),(2124225,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-02 09:24:06','',''),(2124242,'1','153','763',321,'Retail Sale Id 1261675',697.60,0.00,0.00,0.00,41.42,'2021-12-02 09:24:54','',''),(2124243,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 09:24:54','',''),(2124284,'1','153','763',321,'Retail Sale Id 1261694',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:27:41','',''),(2124285,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:27:41','',''),(2124298,'1','153','763',321,'Retail Sale Id 1261699',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 09:28:34','',''),(2124299,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 09:28:34','',''),(2124312,'1','153','763',321,'Retail Sale Id 1261707',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:29:28','',''),(2124313,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:29:28','',''),(2124344,'1','153','763',321,'Retail Sale Id 1261721',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:31:11','',''),(2124345,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:31:11','',''),(2124360,'1','153','763',321,'Retail Sale Id 1261729',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:32:06','',''),(2124361,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:32:06','',''),(2124407,'1','153','763',321,'Retail Sale Id 1261753',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 09:35:17','',''),(2124408,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 09:35:17','',''),(2124463,'1','153','763',321,'Retail Sale Id 1261783',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:40:22','',''),(2124464,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:40:22','',''),(2124477,'1','153','763',321,'Retail Sale Id 1261791',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:41:02','',''),(2124478,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:41:02','',''),(2124517,'1','153','763',321,'Retail Sale Id 1261806',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:43:06','',''),(2124518,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:43:06','',''),(2124539,'1','153','763',321,'Retail Sale Id 1261819',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:44:13','',''),(2124540,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:44:13','',''),(2124562,'1','153','763',321,'Retail Sale Id 1261831',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 09:45:08','',''),(2124563,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:45:08','',''),(2124580,'1','153','763',321,'Retail Sale Id 1261839',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 09:45:54','',''),(2124581,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:45:54','',''),(2124588,'1','153','763',321,'Retail Sale Id 1261843',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 09:46:47','',''),(2124589,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 09:46:47','',''),(2124606,'1','153','763',321,'Retail Sale Id 1261851',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:47:41','',''),(2124607,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:47:41','',''),(2124614,'1','153','763',321,'Retail Sale Id 1261856',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 09:48:26','',''),(2124615,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 09:48:26','',''),(2124677,'1','153','763',321,'Retail Sale Id 1261887',697.60,0.00,0.00,0.00,41.42,'2021-12-02 09:51:02','',''),(2124678,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 09:51:02','',''),(2124695,'1','153','763',321,'Retail Sale Id 1261905',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:51:56','',''),(2124696,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:51:56','',''),(2124721,'1','153','763',321,'Retail Sale Id 1261915',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:53:03','',''),(2124722,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:53:03','',''),(2124768,'1','153','763',321,'Retail Sale Id 1261943',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:55:24','',''),(2124769,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:55:24','',''),(2124811,'1','153','763',321,'Retail Sale Id 1261969',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:57:47','',''),(2124812,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:57:47','',''),(2124813,'1','153','763',321,'Retail Sale Id 1261969',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:57:47','',''),(2124814,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:57:47','',''),(2124815,'1','153','763',321,'Retail Sale Id 1261969',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:57:47','',''),(2124816,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:57:47','',''),(2124835,'1','153','763',321,'Retail Sale Id 1261979',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:58:31','',''),(2124836,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:58:31','',''),(2124851,'1','153','763',321,'Retail Sale Id 1261987',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:59:36','',''),(2124852,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:59:36','',''),(2124896,'1','153','763',321,'Retail Sale Id 1262004',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:01:59','',''),(2124897,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:01:59','',''),(2124925,'1','153','763',321,'Retail Sale Id 1262018',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:03:23','',''),(2124926,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:03:23','',''),(2124945,'1','153','763',321,'Retail Sale Id 1262030',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:04:25','',''),(2124946,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:04:25','',''),(2124957,'1','153','763',321,'Retail Sale Id 1262038',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 10:05:14','',''),(2124958,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:05:14','',''),(2124969,'1','153','763',321,'Retail Sale Id 1262043',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:06:14','',''),(2124970,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:06:14','',''),(2124977,'1','153','763',321,'Retail Sale Id 1262048',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 10:06:54','',''),(2124978,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 10:06:54','',''),(2124981,'1','153','763',321,'Retail Sale Id 1262049',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:07:38','',''),(2124982,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:07:38','',''),(2124997,'1','153','763',321,'Retail Sale Id 1262065',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:08:32','',''),(2124998,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:08:32','',''),(2125011,'1','153','763',321,'Retail Sale Id 1262072',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:09:40','',''),(2125012,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:09:40','',''),(2125051,'1','153','763',321,'Retail Sale Id 1262089',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:11:57','',''),(2125052,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:11:57','',''),(2125071,'1','153','763',321,'Retail Sale Id 1262099',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:12:42','',''),(2125072,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:12:42','',''),(2125092,'1','153','763',321,'Retail Sale Id 1262106',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 10:13:38','',''),(2125093,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:13:38','',''),(2125114,'1','153','763',321,'Retail Sale Id 1262120',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:15:21','',''),(2125115,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:15:21','',''),(2125116,'1','153','763',321,'Retail Sale Id 1262120',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:15:21','',''),(2125117,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:15:21','',''),(2125128,'1','153','763',321,'Retail Sale Id 1262131',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:16:05','',''),(2125129,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:16:05','',''),(2125172,'1','153','763',321,'Retail Sale Id 1262151',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:18:38','',''),(2125173,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:18:38','',''),(2125253,'1','153','763',321,'Retail Sale Id 1262194',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:23:01','',''),(2125254,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:23:01','',''),(2125297,'1','153','763',321,'Retail Sale Id 1262208',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:24:55','',''),(2125298,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:24:55','',''),(2125319,'1','153','763',321,'Retail Sale Id 1262217',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 10:25:54','',''),(2125320,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:25:54','',''),(2125335,'1','153','763',321,'Retail Sale Id 1262226',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:26:47','',''),(2125336,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:26:47','',''),(2125370,'1','153','763',321,'Retail Sale Id 1262245',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:29:16','',''),(2125371,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:29:16','',''),(2125418,'1','153','763',321,'Retail Sale Id 1262273',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:32:23','',''),(2125419,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:32:23','',''),(2125436,'1','153','763',321,'Retail Sale Id 1262280',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:33:51','',''),(2125437,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:33:51','',''),(2125464,'1','153','763',321,'Retail Sale Id 1262293',998.40,0.00,0.00,0.00,59.28,'2021-12-02 10:35:04','',''),(2125465,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:35:04','',''),(2125476,'1','153','763',321,'Retail Sale Id 1262300',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 10:36:01','',''),(2125477,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:36:01','',''),(2125528,'1','153','763',321,'Retail Sale Id 1262321',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 10:38:51','',''),(2125529,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:38:51','',''),(2125542,'1','153','763',321,'Retail Sale Id 1262331',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:40:07','',''),(2125543,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:40:07','',''),(2125544,'1','153','763',321,'Retail Sale Id 1262331',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:40:07','',''),(2125545,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:40:07','',''),(2125556,'1','153','763',321,'Retail Sale Id 1262337',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:40:56','',''),(2125557,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:40:56','',''),(2125566,'1','153','763',321,'Retail Sale Id 1262341',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:41:51','',''),(2125567,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:41:51','',''),(2125584,'1','153','763',321,'Retail Sale Id 1262351',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:42:48','',''),(2125585,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:42:48','',''),(2125600,'1','153','763',321,'Retail Sale Id 1262360',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 10:43:40','',''),(2125603,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:43:40','',''),(2125604,'1','153','763',321,'Retail Sale Id 1262360',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 10:43:40','',''),(2125605,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:43:40','',''),(2125640,'1','153','763',321,'Retail Sale Id 1262378',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 10:45:24','',''),(2125641,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 10:45:24','',''),(2125658,'1','153','763',321,'Retail Sale Id 1262389',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 10:46:32','',''),(2125659,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 10:46:32','',''),(2125674,'1','153','763',321,'Retail Sale Id 1262398',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:47:45','',''),(2125675,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:47:45','',''),(2125714,'1','153','763',321,'Retail Sale Id 1262410',3897.60,0.00,0.00,0.00,231.42,'2021-12-02 10:49:58','',''),(2125715,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:49:58','',''),(2125724,'1','153','763',321,'Retail Sale Id 1262413',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:51:08','',''),(2125725,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:51:08','',''),(2125754,'1','153','763',321,'Retail Sale Id 1262427',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 10:52:31','',''),(2125755,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 10:52:31','',''),(2125774,'1','153','763',321,'Retail Sale Id 1262435',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:54:31','',''),(2125775,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:54:31','',''),(2125776,'1','153','763',321,'Retail Sale Id 1262435',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:54:31','',''),(2125777,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:54:31','',''),(2125790,'1','153','763',321,'Retail Sale Id 1262446',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 10:55:59','',''),(2125791,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 10:55:59','',''),(2125848,'1','153','763',321,'Retail Sale Id 1262480',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 11:00:01','',''),(2125849,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:00:01','',''),(2125874,'1','153','763',321,'Retail Sale Id 1262495',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 11:01:36','',''),(2125875,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 11:01:36','',''),(2125884,'1','153','763',321,'Retail Sale Id 1262501',800.00,0.00,0.00,0.00,47.50,'2021-12-02 11:02:22','',''),(2125885,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 11:02:22','',''),(2125926,'1','153','763',321,'Retail Sale Id 1262524',5760.00,0.00,0.00,0.00,342.00,'2021-12-02 11:04:59','',''),(2125927,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 11:04:59','',''),(2125946,'1','153','763',321,'Retail Sale Id 1262538',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:06:00','',''),(2125947,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:06:00','',''),(2125968,'1','153','763',321,'Retail Sale Id 1262548',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 11:07:23','',''),(2125969,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:07:23','',''),(2125982,'1','153','763',321,'Retail Sale Id 1262556',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 11:08:14','',''),(2125983,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 11:08:14','',''),(2125992,'1','153','763',321,'Retail Sale Id 1262564',3897.60,0.00,0.00,0.00,231.42,'2021-12-02 11:09:10','',''),(2125993,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 11:09:10','',''),(2126014,'1','153','763',321,'Retail Sale Id 1262574',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:10:03','',''),(2126015,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:10:03','',''),(2126035,'1','153','763',321,'Retail Sale Id 1262582',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 11:11:14','',''),(2126036,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 11:11:14','',''),(2126053,'1','153','763',321,'Retail Sale Id 1262592',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 11:12:13','',''),(2126054,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:12:13','',''),(2126096,'1','153','763',321,'Retail Sale Id 1262616',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:15:18','',''),(2126097,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:15:18','',''),(2126108,'1','153','763',321,'Retail Sale Id 1262626',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:15:43','',''),(2126109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:15:43','',''),(2126126,'1','153','763',321,'Retail Sale Id 1262629',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:16:36','',''),(2126127,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:16:36','',''),(2126144,'1','153','763',321,'Retail Sale Id 1262648',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 11:17:33','',''),(2126145,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:17:33','',''),(2126146,'1','153','763',321,'Retail Sale Id 1262646',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 11:17:33','',''),(2126147,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:17:33','',''),(2126168,'1','153','763',321,'Retail Sale Id 1262661',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 11:19:12','',''),(2126169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:19:12','',''),(2126184,'1','153','763',321,'Retail Sale Id 1262668',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 11:19:57','',''),(2126185,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 11:19:57','',''),(2126202,'1','153','763',321,'Retail Sale Id 1262681',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 11:20:59','',''),(2126203,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 11:20:59','',''),(2126216,'1','153','763',321,'Retail Sale Id 1262683',16016.00,0.00,0.00,0.00,364.00,'2021-12-02 11:21:29','',''),(2126217,'1','153','763',321,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-02 11:21:29','',''),(2126226,'1','153','763',321,'Retail Sale Id 1262690',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:21:54','',''),(2126227,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:21:54','',''),(2126238,'1','153','763',321,'Retail Sale Id 1262697',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:22:58','',''),(2126239,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:22:58','',''),(2126258,'1','153','763',321,'Retail Sale Id 1262707',15400.00,0.00,0.00,0.00,350.00,'2021-12-02 11:24:49','',''),(2126259,'1','153','763',321,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 11:24:49','',''),(2126298,'1','153','763',321,'Retail Sale Id 1262723',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 11:27:13','',''),(2126299,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:27:13','',''),(2126534,'1','153','763',321,'Retail Sale Id 1262819',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 11:37:16','',''),(2126535,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:37:16','',''),(2126575,'1','153','763',321,'Retail Sale Id 1262835',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:39:30','',''),(2126576,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:39:30','',''),(2126623,'1','153','763',321,'Retail Sale Id 1262860',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:42:29','',''),(2126624,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:42:29','',''),(2126625,'1','153','763',321,'Retail Sale Id 1262860',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:42:29','',''),(2126626,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:42:29','',''),(2126663,'1','153','763',321,'Retail Sale Id 1262877',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 11:45:18','',''),(2126664,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:45:18','',''),(2126701,'1','153','763',321,'Retail Sale Id 1262897',21560.00,0.00,0.00,0.00,490.00,'2021-12-02 11:49:06','',''),(2126702,'1','153','763',321,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-02 11:49:06','',''),(2126755,'1','153','763',321,'Retail Sale Id 1262931',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 11:53:22','',''),(2126756,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 11:53:22','',''),(2126763,'1','153','763',321,'Retail Sale Id 1262933',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 11:54:08','',''),(2126764,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 11:54:08','',''),(2126785,'1','153','763',321,'Retail Sale Id 1262943',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 11:55:26','',''),(2126786,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 11:55:26','',''),(2126799,'1','153','763',321,'Retail Sale Id 1262952',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 11:56:15','',''),(2126800,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:56:15','',''),(2126805,'1','153','763',321,'Retail Sale Id 1262955',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:56:53','',''),(2126806,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:56:53','',''),(2126819,'1','153','763',321,'Retail Sale Id 1262964',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 11:58:09','',''),(2126820,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:58:09','',''),(2126875,'1','153','763',321,'Retail Sale Id 1262990',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:03:12','',''),(2126876,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:03:12','',''),(2126893,'1','153','763',321,'Retail Sale Id 1262996',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 12:04:53','',''),(2126894,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 12:04:53','',''),(2126926,'1','153','763',321,'Retail Sale Id 1263017',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 12:07:48','',''),(2126927,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:07:48','',''),(2127060,'1','153','763',321,'Retail Sale Id 1263083',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:20:37','',''),(2127061,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:20:37','',''),(2127076,'1','153','763',321,'Retail Sale Id 1263092',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:21:29','',''),(2127077,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:21:29','',''),(2127108,'1','153','763',321,'Retail Sale Id 1263109',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 12:23:34','',''),(2127109,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:23:34','',''),(2127110,'1','153','763',321,'Retail Sale Id 1263109',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 12:23:34','',''),(2127111,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:23:34','',''),(2127120,'1','153','763',321,'Retail Sale Id 1263114',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:24:48','',''),(2127121,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:24:48','',''),(2127142,'1','153','763',321,'Retail Sale Id 1263123',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 12:25:41','',''),(2127143,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 12:25:41','',''),(2127168,'1','153','763',321,'Retail Sale Id 1263140',499.20,0.00,0.00,0.00,29.64,'2021-12-02 12:27:24','',''),(2127169,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 12:27:24','',''),(2127188,'1','153','763',321,'Retail Sale Id 1263148',3801.60,0.00,0.00,0.00,225.72,'2021-12-02 12:29:10','',''),(2127189,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-02 12:29:10','',''),(2127206,'1','153','763',321,'Retail Sale Id 1263165',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 12:30:23','',''),(2127207,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:30:23','',''),(2127236,'1','153','763',321,'Retail Sale Id 1263192',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:32:27','',''),(2127237,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:32:27','',''),(2127256,'1','153','763',321,'Retail Sale Id 1263199',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 12:33:38','',''),(2127257,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:33:38','',''),(2127262,'1','153','763',321,'Retail Sale Id 1263205',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 12:34:30','',''),(2127263,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:34:30','',''),(2127270,'1','153','763',321,'Retail Sale Id 1263209',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 12:35:35','',''),(2127271,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:35:35','',''),(2127288,'1','153','763',321,'Retail Sale Id 1263216',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 12:36:57','',''),(2127289,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:36:57','',''),(2127304,'1','153','763',321,'Retail Sale Id 1263228',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 12:38:08','',''),(2127305,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 12:38:08','',''),(2127320,'1','153','763',321,'Retail Sale Id 1263236',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 12:39:13','',''),(2127321,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 12:39:13','',''),(2127380,'1','153','763',321,'Retail Sale Id 1263267',4198.40,0.00,0.00,0.00,249.28,'2021-12-02 12:44:42','',''),(2127381,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.56,0.00,'2021-12-02 12:44:42','',''),(2127394,'1','153','763',321,'Retail Sale Id 1263270',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 12:46:13','',''),(2127395,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:46:13','',''),(2128590,'1','153','763',321,'Retail Sale Id 1263795',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 14:03:19','',''),(2128591,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 14:03:19','',''),(2128650,'1','153','763',321,'Retail Sale Id 1263822',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 14:06:52','',''),(2128651,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:06:52','',''),(2128696,'1','153','763',321,'Retail Sale Id 1263846',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 14:10:04','',''),(2128697,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:10:04','',''),(2128772,'1','153','763',321,'Retail Sale Id 1263875',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 14:13:52','',''),(2128773,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:13:52','',''),(2128774,'1','153','763',321,'Retail Sale Id 1263875',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 14:13:52','',''),(2128775,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 14:13:52','',''),(2128845,'1','153','763',321,'Retail Sale Id 1263911',20020.00,0.00,0.00,0.00,455.00,'2021-12-02 14:18:17','',''),(2128846,'1','153','763',321,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-02 14:18:17','',''),(2128866,'1','153','763',321,'Retail Sale Id 1263922',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 14:19:07','',''),(2128867,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:19:07','',''),(2128882,'1','153','763',321,'Retail Sale Id 1263927',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:19:54','',''),(2128883,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:19:54','',''),(2128904,'1','153','763',321,'Retail Sale Id 1263942',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:21:11','',''),(2128905,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:21:11','',''),(2128931,'1','153','763',321,'Retail Sale Id 1263953',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:22:26','',''),(2128932,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:22:26','',''),(2129620,'1','153','763',321,'Retail Sale Id 1264233',3801.60,0.00,0.00,0.00,225.72,'2021-12-02 14:54:28','',''),(2129621,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-02 14:54:28','',''),(2129649,'1','153','763',321,'Retail Sale Id 1264249',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 14:56:09','',''),(2129650,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:56:09','',''),(2129691,'1','153','763',321,'Retail Sale Id 1264274',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 14:57:55','',''),(2129692,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:57:55','',''),(2129719,'1','153','763',321,'Retail Sale Id 1264286',998.40,0.00,0.00,0.00,59.28,'2021-12-02 14:59:08','',''),(2129720,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:59:08','',''),(2129741,'1','153','763',321,'Retail Sale Id 1264296',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:01:32','',''),(2129742,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:01:32','',''),(2129757,'1','153','763',321,'Retail Sale Id 1264305',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:03:34','',''),(2129758,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:03:34','',''),(2129771,'1','153','763',321,'Retail Sale Id 1264312',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:04:24','',''),(2129772,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:04:24','',''),(2129789,'1','153','763',321,'Retail Sale Id 1264324',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:05:53','',''),(2129790,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:05:53','',''),(2129801,'1','153','763',321,'Retail Sale Id 1264329',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 15:06:56','',''),(2129802,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:06:56','',''),(2129815,'1','153','763',321,'Retail Sale Id 1264335',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:07:54','',''),(2129816,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:07:54','',''),(2129831,'1','153','763',321,'Retail Sale Id 1264341',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:08:52','',''),(2129832,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:08:52','',''),(2129841,'1','153','763',321,'Retail Sale Id 1264348',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:09:42','',''),(2129842,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:09:42','',''),(2129857,'1','153','763',321,'Retail Sale Id 1264358',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:10:54','',''),(2129858,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:10:54','',''),(2129880,'1','153','763',321,'Retail Sale Id 1264363',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:11:59','',''),(2129881,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:11:59','',''),(2129912,'1','153','763',321,'Retail Sale Id 1264377',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 15:13:52','',''),(2129913,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 15:13:52','',''),(2129942,'1','153','763',321,'Retail Sale Id 1264398',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 15:15:03','',''),(2129943,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:15:03','',''),(2129962,'1','153','763',321,'Retail Sale Id 1264409',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:16:00','',''),(2129963,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:16:00','',''),(2130004,'1','153','763',321,'Retail Sale Id 1264429',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 15:17:59','',''),(2130005,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:17:59','',''),(2130026,'1','153','763',321,'Retail Sale Id 1264443',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:19:14','',''),(2130027,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:19:14','',''),(2130046,'1','153','763',321,'Retail Sale Id 1264453',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 15:20:40','',''),(2130047,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:20:40','',''),(2130056,'1','153','763',321,'Retail Sale Id 1264458',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:21:29','',''),(2130057,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:21:29','',''),(2130088,'1','153','763',321,'Retail Sale Id 1264476',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 15:23:16','',''),(2130089,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:23:16','',''),(2130112,'1','153','763',321,'Retail Sale Id 1264483',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 15:24:00','',''),(2130113,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 15:24:00','',''),(2130480,'1','153','763',321,'Retail Sale Id 1264657',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:40:26','',''),(2130481,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:40:26','',''),(2130526,'1','153','763',321,'Retail Sale Id 1264681',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:42:23','',''),(2130527,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:42:23','',''),(2130544,'1','153','763',321,'Retail Sale Id 1264699',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 15:43:27','',''),(2130545,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 15:43:27','',''),(2130577,'1','153','763',321,'Retail Sale Id 1264717',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:44:42','',''),(2130579,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:44:42','',''),(2130612,'1','153','763',321,'Retail Sale Id 1264737',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 15:46:13','',''),(2130613,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 15:46:13','',''),(2130642,'1','153','763',321,'Retail Sale Id 1264753',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:47:46','',''),(2130643,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:47:46','',''),(2130658,'1','153','763',321,'Retail Sale Id 1264763',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:48:32','',''),(2130659,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:48:32','',''),(2130668,'1','153','763',321,'Retail Sale Id 1264768',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:48:48','',''),(2130669,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:48:48','',''),(2130696,'1','153','763',321,'Retail Sale Id 1264784',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 15:50:34','',''),(2130697,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:50:34','',''),(2130698,'1','153','763',321,'Retail Sale Id 1264786',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:50:44','',''),(2130699,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:50:44','',''),(2130740,'1','153','763',321,'Retail Sale Id 1264807',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 15:52:16','',''),(2130741,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 15:52:16','',''),(2130764,'1','153','763',321,'Retail Sale Id 1264814',2899.20,0.00,0.00,0.00,172.14,'2021-12-02 15:53:15','',''),(2130765,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-02 15:53:15','',''),(2130782,'1','153','763',321,'Retail Sale Id 1264826',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:54:01','',''),(2130783,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:54:01','',''),(2130824,'1','153','763',321,'Retail Sale Id 1264850',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:55:06','',''),(2130825,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:55:06','',''),(2130846,'1','153','763',321,'Retail Sale Id 1264861',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:56:03','',''),(2130847,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:56:03','',''),(2130918,'1','153','763',321,'Retail Sale Id 1264898',15400.00,0.00,0.00,0.00,350.00,'2021-12-02 15:59:57','',''),(2130919,'1','153','763',321,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 15:59:57','',''),(2130940,'1','153','763',321,'Retail Sale Id 1264909',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 16:01:03','',''),(2130941,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:01:03','',''),(2130992,'1','153','763',321,'Retail Sale Id 1264931',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 16:02:57','',''),(2130993,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:02:57','',''),(2131008,'1','153','763',321,'Retail Sale Id 1264938',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 16:03:24','',''),(2131009,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 16:03:24','',''),(2131014,'1','153','763',321,'Retail Sale Id 1264943',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 16:03:54','',''),(2131015,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:03:54','',''),(2131054,'1','153','763',321,'Retail Sale Id 1264957',1651.20,0.00,0.00,0.00,98.04,'2021-12-02 16:05:39','',''),(2131055,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.58,0.00,'2021-12-02 16:05:39','',''),(2131094,'1','153','763',321,'Retail Sale Id 1264971',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 16:07:29','',''),(2131095,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:07:29','',''),(2131124,'1','153','763',321,'Retail Sale Id 1264987',2560.00,0.00,0.00,0.00,152.00,'2021-12-02 16:08:33','',''),(2131125,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:08:33','',''),(2131152,'1','153','763',321,'Retail Sale Id 1265000',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:09:16','',''),(2131153,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:09:16','',''),(2131184,'1','153','763',321,'Retail Sale Id 1265019',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:11:03','',''),(2131185,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:11:03','',''),(2131228,'1','153','763',321,'Retail Sale Id 1265042',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 16:13:30','',''),(2131229,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:13:30','',''),(2131273,'1','153','763',321,'Retail Sale Id 1265066',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:15:36','',''),(2131274,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:15:36','',''),(2131347,'1','153','763',321,'Retail Sale Id 1265103',8506.96,0.00,0.00,0.00,193.34,'2021-12-02 16:19:18','',''),(2131348,'1','153','763',321,'Retail sales',0.00,0.00,0.00,13.81,0.00,'2021-12-02 16:19:18','',''),(2131367,'1','153','763',321,'Retail Sale Id 1265114',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 16:20:30','',''),(2131368,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 16:20:30','',''),(2131398,'1','153','763',321,'Retail Sale Id 1265133',499.20,0.00,0.00,0.00,29.64,'2021-12-02 16:22:08','',''),(2131399,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 16:22:08','',''),(2131490,'1','153','763',321,'Retail Sale Id 1265173',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 16:26:44','',''),(2131491,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:26:44','',''),(2131544,'1','153','763',321,'Retail Sale Id 1265203',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 16:28:59','',''),(2131545,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:28:59','',''),(2133480,'1','153','763',321,'Retail Sale Id 1266042',77924.00,0.00,0.00,0.00,1771.00,'2021-12-02 20:33:48','',''),(2133481,'1','153','763',321,'Retail sales',0.00,0.00,0.00,126.50,0.00,'2021-12-02 20:33:48','',''),(2133498,'1','153','763',321,'Retail Sale Id 1266044',275200.00,0.00,0.00,0.00,16340.00,'2021-12-02 20:37:13','',''),(2133499,'1','153','763',321,'Retail sales',0.00,0.00,0.00,430.00,0.00,'2021-12-02 20:37:13','',''),(2133504,'1','153',NULL,321,'Reception corrector for bridging 125999',0.00,0.00,0.00,5899.00,0.00,'2021-12-02 20:39:07','',''),(2133505,'1','153','763',321,'Received from bridging 125999',0.00,0.00,5899.00,0.00,0.00,'2021-12-02 20:39:07','',''),(2133506,'1','153','763',321,'Retail Sale Id 1266045',33324.80,0.00,0.00,0.00,1978.66,'2021-12-02 20:40:17','',''),(2133507,'1','153','763',321,'Retail sales',0.00,0.00,0.00,52.07,0.00,'2021-12-02 20:40:17','',''),(2133508,'1','153','763',321,'Retail Sale Id 1266046',270457.60,0.00,0.00,0.00,16058.42,'2021-12-02 20:42:35','',''),(2133509,'1','153','763',321,'Retail sales',0.00,0.00,0.00,422.59,0.00,'2021-12-02 20:42:35','',''),(2133527,'1','153','763',321,'Retail Sale Id 1266049',486771.20,0.00,0.00,0.00,28902.04,'2021-12-02 20:45:53','',''),(2133528,'1','153','763',321,'Retail sales',0.00,0.00,0.00,760.58,0.00,'2021-12-02 20:45:53','',''),(2133544,'1','153','763',321,'Return of Retail Sale Id 1260865',0.00,30800.00,50.00,0.00,-700.00,'2021-12-02 20:49:17','',''),(2133545,'1','153','763',321,'Retail Sale Id 1266051',27104.00,0.00,0.00,0.00,616.00,'2021-12-02 20:50:56','',''),(2133546,'1','153','763',321,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-02 20:50:56','',''),(2133549,'1','153','763',321,'Retail Sale Id 1266052',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 20:52:33','',''),(2133550,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 20:52:33','',''),(2136110,'1','153','763',321,'Retail Sale Id 1267092',320000.00,0.00,0.00,0.00,19000.00,'2021-12-03 08:12:06','',''),(2136111,'1','153','763',321,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-03 08:12:06','',''),(2136124,'1','153','763',321,'Retail Sale Id 1267100',112000.00,0.00,0.00,0.00,6650.00,'2021-12-03 08:12:48','',''),(2136125,'1','153','763',321,'Retail sales',0.00,0.00,0.00,175.00,0.00,'2021-12-03 08:12:48','',''),(2136138,'1','153','763',321,'Retail Sale Id 1267107',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 08:13:27','',''),(2136139,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:13:27','',''),(2136828,'1','153','763',321,'Retail Sale Id 1267371',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 08:47:10','',''),(2136829,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 08:47:10','',''),(2136908,'1','153','763',321,'Retail Sale Id 1267416',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 08:52:24','',''),(2136909,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 08:52:24','',''),(2136934,'1','153','763',321,'Retail Sale Id 1267428',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 08:53:47','',''),(2136935,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:53:47','',''),(2136936,'1','153','763',321,'Retail Sale Id 1267428',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 08:53:47','',''),(2136937,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:53:47','',''),(2136970,'1','153','763',321,'Retail Sale Id 1267448',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 08:55:32','',''),(2136971,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:55:32','',''),(2137000,'1','153','763',321,'Retail Sale Id 1267462',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 08:57:13','',''),(2137001,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:57:13','',''),(2137017,'1','153','763',321,'Retail Sale Id 1267470',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 08:58:18','',''),(2137018,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:58:18','',''),(2137032,'1','153','763',321,'Retail Sale Id 1267479',998.40,0.00,0.00,0.00,59.28,'2021-12-03 08:59:11','',''),(2137033,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:59:11','',''),(2137058,'1','153','763',321,'Retail Sale Id 1267491',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:00:22','',''),(2137059,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:00:22','',''),(2137060,'1','153','763',321,'Retail Sale Id 1267491',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:00:22','',''),(2137061,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:00:22','',''),(2137076,'1','153','763',321,'Retail Sale Id 1267505',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:01:24','',''),(2137077,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:01:24','',''),(2137098,'1','153','763',321,'Retail Sale Id 1267513',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 09:02:19','',''),(2137099,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:02:19','',''),(2137134,'1','153','763',321,'Retail Sale Id 1267532',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:03:57','',''),(2137135,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:03:57','',''),(2137176,'1','153','763',321,'Retail Sale Id 1267558',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:05:59','',''),(2137177,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:05:59','',''),(2137211,'1','153','763',321,'Retail Sale Id 1267576',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:07:37','',''),(2137212,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:07:37','',''),(2137253,'1','153','763',321,'Retail Sale Id 1267601',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:09:44','',''),(2137254,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:09:44','',''),(2137271,'1','153','763',321,'Retail Sale Id 1267624',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:10:30','',''),(2137272,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:10:30','',''),(2137291,'1','153','763',321,'Retail Sale Id 1267634',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 09:11:44','',''),(2137292,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 09:11:44','',''),(2137334,'1','153','763',321,'Retail Sale Id 1267659',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 09:13:48','',''),(2137335,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 09:13:48','',''),(2137356,'1','153','763',321,'Retail Sale Id 1267669',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 09:14:47','',''),(2137357,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 09:14:47','',''),(2137375,'1','153','763',321,'Retail Sale Id 1267680',499.20,0.00,0.00,0.00,29.64,'2021-12-03 09:15:46','',''),(2137377,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-03 09:15:46','',''),(2137401,'1','153','763',321,'Retail Sale Id 1267692',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 09:16:56','',''),(2137402,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 09:16:56','',''),(2137478,'1','153','763',321,'Retail Sale Id 1267730',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:21:19','',''),(2137479,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:21:19','',''),(2137499,'1','153','763',321,'Retail Sale Id 1267743',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 09:22:35','',''),(2137500,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 09:22:35','',''),(2137501,'1','153','763',321,'Retail Sale Id 1267743',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 09:22:35','',''),(2137502,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 09:22:35','',''),(2137521,'1','153','763',321,'Retail Sale Id 1267756',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:24:04','',''),(2137522,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:24:04','',''),(2137523,'1','153','763',321,'Retail Sale Id 1267756',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:24:04','',''),(2137525,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:24:04','',''),(2137537,'1','153','763',321,'Retail Sale Id 1267765',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 09:25:02','',''),(2137538,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 09:25:02','',''),(2137555,'1','153','763',321,'Retail Sale Id 1267774',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 09:26:09','',''),(2137556,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 09:26:09','',''),(2137573,'1','153','763',321,'Retail Sale Id 1267782',9600.00,0.00,0.00,0.00,570.00,'2021-12-03 09:27:08','',''),(2137574,'1','153','763',321,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 09:27:08','',''),(2137593,'1','153','763',321,'Retail Sale Id 1267794',38500.00,0.00,0.00,0.00,875.00,'2021-12-03 09:28:26','',''),(2137594,'1','153','763',321,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-03 09:28:26','',''),(2137633,'1','153','763',321,'Retail Sale Id 1267821',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:31:02','',''),(2137634,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:31:02','',''),(2137655,'1','153','763',321,'Retail Sale Id 1267831',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:32:32','',''),(2137656,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:32:32','',''),(2137677,'1','153','763',321,'Retail Sale Id 1267844',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:33:48','',''),(2137678,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:33:48','',''),(2137689,'1','153','763',321,'Retail Sale Id 1267852',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 09:34:32','',''),(2137690,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:34:32','',''),(2137755,'1','153','763',321,'Retail Sale Id 1267892',998.40,0.00,0.00,0.00,59.28,'2021-12-03 09:38:55','',''),(2137756,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:38:56','',''),(2137775,'1','153','763',321,'Retail Sale Id 1267903',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 09:39:54','',''),(2137776,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:39:54','',''),(2137795,'1','153','763',321,'Retail Sale Id 1267913',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:41:36','',''),(2137796,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:41:36','',''),(2137851,'1','153','763',321,'Retail Sale Id 1267938',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 09:44:47','',''),(2137852,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 09:44:47','',''),(2137902,'1','153','763',321,'Retail Sale Id 1267964',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 09:47:40','',''),(2137903,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 09:47:40','',''),(2137918,'1','153','763',321,'Retail Sale Id 1267972',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 09:48:36','',''),(2137919,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 09:48:36','',''),(2137942,'1','153','763',321,'Retail Sale Id 1267981',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:49:46','',''),(2137943,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:49:46','',''),(2137954,'1','153','763',321,'Retail Sale Id 1267987',652.80,0.00,0.00,0.00,38.76,'2021-12-03 09:50:30','',''),(2137955,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-03 09:50:30','',''),(2137964,'1','153','763',321,'Retail Sale Id 1267993',9600.00,0.00,0.00,0.00,570.00,'2021-12-03 09:51:20','',''),(2137965,'1','153','763',321,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 09:51:20','',''),(2137984,'1','153','763',321,'Retail Sale Id 1268003',697.60,0.00,0.00,0.00,41.42,'2021-12-03 09:52:41','',''),(2137985,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:52:41','',''),(2138102,'1','153','763',321,'Retail Sale Id 1268059',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:59:51','',''),(2138103,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:59:51','',''),(2138116,'1','153','763',321,'Retail Sale Id 1268066',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 10:00:55','',''),(2138117,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 10:00:55','',''),(2138142,'1','153','763',321,'Retail Sale Id 1268083',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 10:02:33','',''),(2138143,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 10:02:33','',''),(2138175,'1','153','763',321,'Retail Sale Id 1268098',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 10:04:31','',''),(2138176,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 10:04:31','',''),(2138211,'1','153','763',321,'Retail Sale Id 1268118',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 10:06:34','',''),(2138212,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 10:06:34','',''),(2138239,'1','153','763',321,'Retail Sale Id 1268132',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:07:41','',''),(2138240,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:07:41','',''),(2138241,'1','153','763',321,'Retail Sale Id 1268132',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:07:41','',''),(2138242,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:07:41','',''),(2138261,'1','153','763',321,'Retail Sale Id 1268144',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 10:08:54','',''),(2138262,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 10:08:54','',''),(2138292,'1','153','763',321,'Retail Sale Id 1268157',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:10:16','',''),(2138293,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:10:16','',''),(2138316,'1','153','763',321,'Retail Sale Id 1268169',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 10:11:38','',''),(2138317,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 10:11:38','',''),(2138356,'1','153','763',321,'Retail Sale Id 1268190',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 10:13:45','',''),(2138357,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:13:45','',''),(2138367,'1','153','763',321,'Retail Sale Id 1268197',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:14:36','',''),(2138368,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:14:36','',''),(2138407,'1','153','763',321,'Retail Sale Id 1268216',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:16:59','',''),(2138408,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:16:59','',''),(2138436,'1','153','763',321,'Retail Sale Id 1268228',2547.20,0.00,0.00,0.00,151.24,'2021-12-03 10:18:44','',''),(2138437,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.98,0.00,'2021-12-03 10:18:44','',''),(2138454,'1','153','763',321,'Retail Sale Id 1268234',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 10:19:36','',''),(2138455,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:19:36','',''),(2138472,'1','153','763',321,'Retail Sale Id 1268243',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:20:38','',''),(2138473,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:20:38','',''),(2138488,'1','153','763',321,'Retail Sale Id 1268251',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 10:21:18','',''),(2138489,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:21:18','',''),(2138498,'1','153','763',321,'Retail Sale Id 1268257',2201.60,0.00,0.00,0.00,130.72,'2021-12-03 10:22:15','',''),(2138499,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-03 10:22:15','',''),(2138518,'1','153','763',321,'Retail Sale Id 1268267',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 10:23:05','',''),(2138519,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 10:23:05','',''),(2138540,'1','153','763',321,'Retail Sale Id 1268281',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 10:24:37','',''),(2138541,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 10:24:37','',''),(2138560,'1','153','763',321,'Retail Sale Id 1268293',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 10:26:06','',''),(2138561,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:26:06','',''),(2138562,'1','153','763',321,'Retail Sale Id 1268293',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 10:26:06','',''),(2138563,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:26:06','',''),(2138627,'1','153','763',321,'Retail Sale Id 1268322',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 10:30:02','',''),(2138628,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 10:30:02','',''),(2138775,'1','153','763',321,'Retail Sale Id 1268390',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 10:38:32','',''),(2138776,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 10:38:32','',''),(2138785,'1','153','763',321,'Retail Sale Id 1268397',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 10:39:26','',''),(2138786,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:39:26','',''),(2138811,'1','153','763',321,'Retail Sale Id 1268410',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 10:40:52','',''),(2138812,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:40:52','',''),(2138829,'1','153','763',321,'Retail Sale Id 1268417',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 10:42:12','',''),(2138830,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 10:42:12','',''),(2138841,'1','153','763',321,'Retail Sale Id 1268435',1900.80,0.00,0.00,0.00,112.86,'2021-12-03 10:43:53','',''),(2138842,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 10:43:53','',''),(2138880,'1','153','763',321,'Retail Sale Id 1268453',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:46:51','',''),(2138881,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:46:51','',''),(2138919,'1','153','763',321,'Retail Sale Id 1268473',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:49:49','',''),(2138920,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:49:49','',''),(2138949,'1','153','763',321,'Retail Sale Id 1268489',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:52:17','',''),(2138950,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:52:17','',''),(2142271,'1','153','763',321,'Retail Sale Id 1270066',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:40:55','',''),(2142272,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:40:55','',''),(2142317,'1','153','763',321,'Retail Sale Id 1270078',2560.00,0.00,0.00,0.00,152.00,'2021-12-03 14:42:27','',''),(2142318,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:42:27','',''),(2142343,'1','153','763',321,'Retail Sale Id 1270087',1203.20,0.00,0.00,0.00,71.44,'2021-12-03 14:43:32','',''),(2142344,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-03 14:43:32','',''),(2142373,'1','153','763',321,'Retail Sale Id 1270101',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:44:30','',''),(2142374,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:44:30','',''),(2142387,'1','153','763',321,'Retail Sale Id 1270108',998.40,0.00,0.00,0.00,59.28,'2021-12-03 14:45:10','',''),(2142388,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:45:10','',''),(2142405,'1','153','763',321,'Retail Sale Id 1270115',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:45:58','',''),(2142406,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:45:58','',''),(2142435,'1','153','763',321,'Retail Sale Id 1270135',1900.80,0.00,0.00,0.00,112.86,'2021-12-03 14:47:12','',''),(2142436,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 14:47:12','',''),(2142455,'1','153','763',321,'Retail Sale Id 1270145',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 14:48:04','',''),(2142456,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:48:04','',''),(2142488,'1','153','763',321,'Retail Sale Id 1270163',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 14:49:19','',''),(2142489,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:49:19','',''),(2142523,'1','153','763',321,'Retail Sale Id 1270180',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 14:51:16','',''),(2142524,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:51:16','',''),(2142539,'1','153','763',321,'Retail Sale Id 1270189',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 14:51:54','',''),(2142540,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:51:54','',''),(2142555,'1','153','763',321,'Retail Sale Id 1270198',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:52:49','',''),(2142556,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:52:49','',''),(2142557,'1','153','763',321,'Retail Sale Id 1270198',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 14:52:49','',''),(2142558,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:52:49','',''),(2142594,'1','153','763',321,'Retail Sale Id 1270214',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:54:38','',''),(2142595,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:54:38','',''),(2142596,'1','153','763',321,'Retail Sale Id 1270214',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:54:38','',''),(2142597,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:54:38','',''),(2142634,'1','153','763',321,'Retail Sale Id 1270225',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 14:55:57','',''),(2142635,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:55:57','',''),(2142636,'1','153','763',321,'Retail Sale Id 1270225',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 14:55:57','',''),(2142637,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:55:57','',''),(2142655,'1','153','763',321,'Retail Sale Id 1270233',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 14:56:46','',''),(2142656,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 14:56:46','',''),(2142876,'1','153','763',321,'Retail Sale Id 1270348',7500.80,0.00,0.00,0.00,445.36,'2021-12-03 15:11:00','',''),(2142877,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-03 15:11:00','',''),(2142926,'1','153','763',321,'Retail Sale Id 1270369',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:13:13','',''),(2142927,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:13:13','',''),(2142958,'1','153','763',321,'Retail Sale Id 1270386',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:14:24','',''),(2142959,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:14:24','',''),(2142986,'1','153','763',321,'Retail Sale Id 1270409',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 15:15:37','',''),(2142987,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:15:37','',''),(2143018,'1','153','763',321,'Retail Sale Id 1270428',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 15:17:10','',''),(2143019,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:17:10','',''),(2143039,'1','153','763',321,'Retail Sale Id 1270441',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:18:27','',''),(2143040,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:18:27','',''),(2143063,'1','153','763',321,'Retail Sale Id 1270455',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:19:29','',''),(2143064,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:19:29','',''),(2143129,'1','153','763',321,'Retail Sale Id 1270491',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 15:22:39','',''),(2143130,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 15:22:39','',''),(2143147,'1','153','763',321,'Retail Sale Id 1270503',697.60,0.00,0.00,0.00,41.42,'2021-12-03 15:23:48','',''),(2143148,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 15:23:48','',''),(2143210,'1','153','763',321,'Retail Sale Id 1270532',1900.80,0.00,0.00,0.00,112.86,'2021-12-03 15:27:33','',''),(2143211,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 15:27:33','',''),(2143247,'1','153','763',321,'Retail Sale Id 1270549',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:29:21','',''),(2143248,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:29:21','',''),(2143335,'1','153','763',321,'Retail Sale Id 1270589',1280.00,0.00,0.00,0.00,76.00,'2021-12-03 15:33:38','',''),(2143336,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:33:38','',''),(2143381,'1','153','763',321,'Retail Sale Id 1270610',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:34:51','',''),(2143382,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:34:52','',''),(2143383,'1','153','763',321,'Retail Sale Id 1270610',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:34:52','',''),(2143384,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:34:52','',''),(2143385,'1','153','763',321,'Retail Sale Id 1270610',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:34:52','',''),(2143386,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:34:52','',''),(2143444,'1','153','763',321,'Retail Sale Id 1270645',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 15:37:32','',''),(2143445,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:37:32','',''),(2143504,'1','153','763',321,'Retail Sale Id 1270677',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:39:53','',''),(2143505,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:39:53','',''),(2143550,'1','153','763',321,'Retail Sale Id 1270700',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:41:58','',''),(2143551,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:41:58','',''),(2143552,'1','153','763',321,'Retail Sale Id 1270700',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:41:58','',''),(2143553,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:41:58','',''),(2143554,'1','153','763',321,'Retail Sale Id 1270700',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:41:58','',''),(2143555,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:41:58','',''),(2143556,'1','153','763',321,'Retail Sale Id 1270700',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:41:58','',''),(2143557,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:41:58','',''),(2143592,'1','153','763',321,'Retail Sale Id 1270720',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:43:38','',''),(2143593,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:43:38','',''),(2143594,'1','153','763',321,'Retail Sale Id 1270720',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:43:38','',''),(2143595,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:43:38','',''),(2143596,'1','153','763',321,'Retail Sale Id 1270720',15001.60,0.00,0.00,0.00,890.72,'2021-12-03 15:43:38','',''),(2143597,'1','153','763',321,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-03 15:43:38','',''),(2143617,'1','153','763',321,'Retail Sale Id 1270732',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:44:48','',''),(2143618,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:44:48','',''),(2143620,'1','153','763',321,'Retail Sale Id 1270732',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:44:48','',''),(2143621,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:44:48','',''),(2143662,'1','153','763',321,'Retail Sale Id 1270750',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 15:46:14','',''),(2143663,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 15:46:14','',''),(2143682,'1','153','763',321,'Retail Sale Id 1270763',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:47:24','',''),(2143683,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:47:24','',''),(2143742,'1','153','763',321,'Retail Sale Id 1270786',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 15:48:55','',''),(2143743,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:48:55','',''),(2143786,'1','153','763',321,'Retail Sale Id 1270809',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:51:27','',''),(2143787,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:51:27','',''),(2143816,'1','153','763',321,'Retail Sale Id 1270829',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 15:52:39','',''),(2143817,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:52:39','',''),(2143830,'1','153','763',321,'Retail Sale Id 1270836',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:53:25','',''),(2143831,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:53:25','',''),(2143842,'1','153','763',321,'Retail Sale Id 1270843',16632.00,0.00,0.00,0.00,378.00,'2021-12-03 15:54:23','',''),(2143843,'1','153','763',321,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-03 15:54:23','',''),(2143877,'1','153','763',321,'Retail Sale Id 1270861',1798.40,0.00,0.00,0.00,106.78,'2021-12-03 15:55:53','',''),(2143878,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 15:55:53','',''),(2143915,'1','153','763',321,'Retail Sale Id 1270881',2201.60,0.00,0.00,0.00,130.72,'2021-12-03 15:58:04','',''),(2143916,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-03 15:58:04','',''),(2143946,'1','153','763',321,'Retail Sale Id 1270894',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:59:22','',''),(2143947,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:59:22','',''),(2143969,'1','153','763',321,'Retail Sale Id 1270906',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 16:00:20','',''),(2143970,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:00:20','',''),(2144025,'1','153','763',321,'Retail Sale Id 1270930',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:02:46','',''),(2144026,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:02:46','',''),(2144061,'1','153','763',321,'Retail Sale Id 1270950',3302.40,0.00,0.00,0.00,196.08,'2021-12-03 16:03:57','',''),(2144062,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-03 16:03:57','',''),(2144140,'1','153','763',321,'Retail Sale Id 1270985',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:07:22','',''),(2144141,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:07:22','',''),(2144176,'1','153','763',321,'Retail Sale Id 1271005',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 16:08:56','',''),(2144177,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:08:56','',''),(2144194,'1','153','763',321,'Retail Sale Id 1271016',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 16:09:52','',''),(2144195,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:09:52','',''),(2144256,'1','153','763',321,'Retail Sale Id 1271045',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 16:12:43','',''),(2144257,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:12:43','',''),(2144264,'1','153','763',321,'Retail Sale Id 1271053',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:13:32','',''),(2144265,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:13:32','',''),(2144282,'1','153','763',321,'Retail Sale Id 1271063',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:14:32','',''),(2144283,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:14:32','',''),(2144314,'1','153','763',321,'Retail Sale Id 1271080',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 16:16:50','',''),(2144315,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:16:50','',''),(2144330,'1','153','763',321,'Retail Sale Id 1271092',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:17:53','',''),(2144331,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:17:53','',''),(2144332,'1','153','763',321,'Retail Sale Id 1271092',14003.20,0.00,0.00,0.00,831.44,'2021-12-03 16:17:53','',''),(2144333,'1','153','763',321,'Retail sales',0.00,0.00,0.00,21.88,0.00,'2021-12-03 16:17:53','',''),(2144446,'1','153','763',321,'Retail Sale Id 1271145',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 16:23:01','',''),(2144447,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:23:01','',''),(2144460,'1','153','763',321,'Retail Sale Id 1271153',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:23:51','',''),(2144461,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:23:51','',''),(2144490,'1','153','763',321,'Retail Sale Id 1271167',902.40,0.00,0.00,0.00,53.58,'2021-12-03 16:25:34','',''),(2144491,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-03 16:25:34','',''),(2144528,'1','153','763',321,'Retail Sale Id 1271188',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 16:27:50','',''),(2144529,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 16:27:50','',''),(2144552,'1','153','763',321,'Retail Sale Id 1271196',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:29:06','',''),(2144553,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:29:06','',''),(2144580,'1','153','763',321,'Retail Sale Id 1271214',1248.00,0.00,0.00,0.00,74.10,'2021-12-03 16:30:32','',''),(2144581,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.95,0.00,'2021-12-03 16:30:32','',''),(2144582,'1','153','763',321,'Retail Sale Id 1271214',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:30:32','',''),(2144583,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:30:32','',''),(2144602,'1','153','763',321,'Retail Sale Id 1271221',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 16:31:26','',''),(2144603,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:31:26','',''),(2144618,'1','153','763',321,'Retail Sale Id 1271230',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 16:32:16','',''),(2144619,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:32:16','',''),(2144637,'1','153','763',321,'Retail Sale Id 1271239',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 16:33:14','',''),(2144638,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 16:33:14','',''),(2144659,'1','153','763',321,'Retail Sale Id 1271250',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 16:34:31','',''),(2144660,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 16:34:31','',''),(2144679,'1','153','763',321,'Retail Sale Id 1271260',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 16:35:30','',''),(2144680,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:35:30','',''),(2144696,'1','153','763',321,'Retail Sale Id 1271274',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:36:35','',''),(2144697,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:36:35','',''),(2144720,'1','153','763',321,'Retail Sale Id 1271283',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 16:37:27','',''),(2144721,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 16:37:27','',''),(2144740,'1','153','763',321,'Retail Sale Id 1271297',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 16:38:29','',''),(2144741,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:38:29','',''),(2144783,'1','153','763',321,'Retail Sale Id 1271317',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 16:40:19','',''),(2144784,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:40:19','',''),(2144889,'1','153','763',321,'Retail Sale Id 1271366',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 16:45:21','',''),(2144890,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:45:21','',''),(2144923,'1','153','763',321,'Retail Sale Id 1271383',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 16:47:27','',''),(2144924,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:47:27','',''),(2144943,'1','153','763',321,'Retail Sale Id 1271394',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:48:45','',''),(2144944,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:48:45','',''),(2144967,'1','153','763',321,'Retail Sale Id 1271408',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 16:50:19','',''),(2144968,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:50:19','',''),(2145017,'1','153','763',321,'Retail Sale Id 1271423',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:52:14','',''),(2145018,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:52:14','',''),(2145046,'1','153','763',321,'Retail Sale Id 1271433',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 16:53:38','',''),(2145047,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:53:38','',''),(2145084,'1','153','763',321,'Retail Sale Id 1271447',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 16:54:36','',''),(2145085,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:54:36','',''),(2145129,'1','153','763',321,'Retail Sale Id 1271461',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:56:01','',''),(2145130,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:56:01','',''),(2145190,'1','153','763',321,'Retail Sale Id 1271485',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 16:59:13','',''),(2145191,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:59:13','',''),(2145218,'1','153','763',321,'Retail Sale Id 1271499',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 17:00:54','',''),(2145219,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:00:54','',''),(2145240,'1','153','763',321,'Retail Sale Id 1271508',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 17:02:16','',''),(2145241,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 17:02:16','',''),(2145252,'1','153','763',321,'Retail Sale Id 1271520',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 17:03:33','',''),(2145253,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 17:03:33','',''),(2145266,'1','153','763',321,'Retail Sale Id 1271531',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 17:04:48','',''),(2145267,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:04:48','',''),(2145268,'1','153','763',321,'Retail Sale Id 1271531',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 17:04:48','',''),(2145269,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 17:04:48','',''),(2145300,'1','153','763',321,'Retail Sale Id 1271544',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 17:06:21','',''),(2145301,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:06:21','',''),(2145312,'1','153','763',321,'Retail Sale Id 1271553',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 17:07:55','',''),(2145313,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 17:07:56','',''),(2145437,'1','153','763',321,'Retail Sale Id 1271615',20944.00,0.00,0.00,0.00,476.00,'2021-12-03 17:20:42','',''),(2145438,'1','153','763',321,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-03 17:20:42','',''),(2145452,'1','153','763',321,'Retail Sale Id 1271623',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 17:22:22','',''),(2145453,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:22:22','',''),(2145461,'1','153','763',321,'Retail Sale Id 1271627',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 17:23:28','',''),(2145462,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 17:23:28','',''),(2145483,'1','153','763',321,'Retail Sale Id 1271638',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 17:25:52','',''),(2145484,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 17:25:52','',''),(2145517,'1','153','763',321,'Retail Sale Id 1271656',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 17:29:55','',''),(2145518,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:29:55','',''),(2145527,'1','153','763',321,'Retail Sale Id 1271661',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 17:30:57','',''),(2145528,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 17:30:57','',''),(2145531,'1','153','763',321,'Retail Sale Id 1271663',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 17:31:58','',''),(2145532,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 17:31:58','',''),(2145541,'1','153','763',321,'Retail Sale Id 1271668',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 17:33:48','',''),(2145542,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 17:33:48','',''),(2146145,'1','153','763',321,'Retail Sale Id 1271914',94007.76,0.00,0.00,0.00,2136.54,'2021-12-03 20:19:45','',''),(2146146,'1','153','763',321,'Retail sales',0.00,0.00,0.00,152.61,0.00,'2021-12-03 20:19:45','',''),(2146149,'1','153','763',321,'Retail Sale Id 1271915',36076.80,0.00,0.00,0.00,2142.06,'2021-12-03 20:21:24','',''),(2146150,'1','153','763',321,'Retail sales',0.00,0.00,0.00,56.37,0.00,'2021-12-03 20:21:24','',''),(2146171,'1','153','763',321,'Retail Sale Id 1271916',768422.40,0.00,0.00,0.00,45625.08,'2021-12-03 20:23:35','',''),(2146172,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1200.66,0.00,'2021-12-03 20:23:35','',''),(2146175,'1','153','763',321,'Return of Retail Sale Id 1268293',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-03 20:25:13','',''),(2146176,'1','153','763',321,'Return of Retail Sale Id 1268293',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-03 20:25:13','',''),(2146178,'1','153','763',321,'Retail Sale Id 1271917',6054.40,0.00,0.00,0.00,359.48,'2021-12-03 20:28:17','',''),(2146179,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.46,0.00,'2021-12-03 20:28:17','',''),(2146184,'1','153','763',321,'Return of Retail Sale Id 1267794',0.00,38500.00,62.50,0.00,-875.00,'2021-12-03 20:30:46','',''),(2146185,'1','153','763',321,'Retail Sale Id 1271919',35728.00,0.00,0.00,0.00,812.00,'2021-12-03 20:32:27','',''),(2146186,'1','153','763',321,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-03 20:32:27','',''),(2146191,'1','153','763',321,'Retail Sale Id 1271920',2880.00,0.00,0.00,0.00,171.00,'2021-12-03 20:33:37','',''),(2146192,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 20:33:37','',''),(2146636,'1','153','763',321,'Retail Sale Id 1271996',7001.60,0.00,0.00,0.00,415.72,'2021-12-04 06:08:51','',''),(2146637,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 06:08:51','',''),(2146644,'1','153','763',321,'Retail Sale Id 1272000',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:09:39','',''),(2146645,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:09:39','',''),(2146652,'1','153','763',321,'Retail Sale Id 1272004',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 06:10:54','',''),(2146653,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:10:54','',''),(2146662,'1','153','763',321,'Retail Sale Id 1272010',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:11:44','',''),(2146663,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:11:44','',''),(2146689,'1','153','763',321,'Retail Sale Id 1272015',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:13:33','',''),(2146690,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:13:33','',''),(2146697,'1','153','763',321,'Retail Sale Id 1272018',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:14:29','',''),(2146698,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:14:29','',''),(2146805,'1','153','763',321,'Retail Sale Id 1272052',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 06:21:51','',''),(2146806,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:21:51','',''),(2146834,'1','153','763',321,'Retail Sale Id 1272059',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:23:23','',''),(2146835,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:23:23','',''),(2146836,'1','153','763',321,'Retail Sale Id 1272059',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 06:23:23','',''),(2146837,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 06:23:23','',''),(2147002,'1','153','763',321,'Retail Sale Id 1272116',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 06:30:23','',''),(2147003,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:30:23','',''),(2147110,'1','153','763',321,'Retail Sale Id 1272164',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:36:19','',''),(2147111,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:36:19','',''),(2147136,'1','153','763',321,'Retail Sale Id 1272177',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 06:38:02','',''),(2147137,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 06:38:02','',''),(2147162,'1','153','763',321,'Retail Sale Id 1272190',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:39:27','',''),(2147163,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:39:27','',''),(2147164,'1','153','763',321,'Retail Sale Id 1272190',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:39:27','',''),(2147165,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:39:27','',''),(2147219,'1','153','763',321,'Retail Sale Id 1272210',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 06:42:05','',''),(2147220,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 06:42:05','',''),(2147237,'1','153','763',321,'Retail Sale Id 1272218',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:43:06','',''),(2147238,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:43:06','',''),(2147251,'1','153','763',321,'Retail Sale Id 1272226',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:44:03','',''),(2147252,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:44:03','',''),(2147291,'1','153','763',321,'Retail Sale Id 1272240',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 06:45:56','',''),(2147292,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 06:45:56','',''),(2147308,'1','153','763',321,'Retail Sale Id 1272252',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 06:47:19','',''),(2147309,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:47:19','',''),(2147328,'1','153','763',321,'Retail Sale Id 1272259',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:48:30','',''),(2147329,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:48:30','',''),(2147420,'1','153','763',321,'Retail Sale Id 1272306',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 06:53:25','',''),(2147421,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:53:25','',''),(2147440,'1','153','763',321,'Retail Sale Id 1272313',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:54:09','',''),(2147441,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:54:09','',''),(2147469,'1','153','763',321,'Retail Sale Id 1272326',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 06:55:13','',''),(2147470,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:55:13','',''),(2147490,'1','153','763',321,'Retail Sale Id 1272335',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 06:56:16','',''),(2147491,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 06:56:16','',''),(2147524,'1','153','763',321,'Retail Sale Id 1272347',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:57:36','',''),(2147525,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:57:36','',''),(2147542,'1','153','763',321,'Retail Sale Id 1272360',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 06:58:40','',''),(2147543,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 06:58:40','',''),(2147558,'1','153','763',321,'Retail Sale Id 1272366',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:59:43','',''),(2147559,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:59:43','',''),(2147578,'1','153','763',321,'Retail Sale Id 1272376',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:00:59','',''),(2147579,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:00:59','',''),(2147613,'1','153','763',321,'Retail Sale Id 1272390',2560.00,0.00,0.00,0.00,152.00,'2021-12-04 07:02:12','',''),(2147614,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:02:12','',''),(2147639,'1','153','763',321,'Retail Sale Id 1272406',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 07:04:18','',''),(2147640,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:04:18','',''),(2147641,'1','153','763',321,'Retail Sale Id 1272406',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 07:04:18','',''),(2147642,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:04:18','',''),(2147665,'1','153','763',321,'Retail Sale Id 1272417',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:05:43','',''),(2147666,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:05:43','',''),(2147683,'1','153','763',321,'Retail Sale Id 1272426',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:06:35','',''),(2147684,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:06:35','',''),(2147695,'1','153','763',321,'Retail Sale Id 1272432',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:07:21','',''),(2147696,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:07:21','',''),(2147734,'1','153','763',321,'Retail Sale Id 1272451',20328.00,0.00,0.00,0.00,462.00,'2021-12-04 07:09:43','',''),(2147735,'1','153','763',321,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-04 07:09:43','',''),(2147835,'1','153','763',321,'Retail Sale Id 1272509',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 07:15:27','',''),(2147836,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:15:27','',''),(2147892,'1','153','763',321,'Retail Sale Id 1272544',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 07:17:52','',''),(2147893,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:17:52','',''),(2147912,'1','153','763',321,'Retail Sale Id 1272553',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 07:18:56','',''),(2147913,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:18:56','',''),(2147926,'1','153','763',321,'Retail Sale Id 1272560',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:19:54','',''),(2147927,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:19:54','',''),(2147944,'1','153','763',321,'Retail Sale Id 1272571',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:20:57','',''),(2147945,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:20:57','',''),(2147966,'1','153','763',321,'Retail Sale Id 1272583',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:21:45','',''),(2147967,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:21:45','',''),(2148022,'1','153','763',321,'Retail Sale Id 1272613',2560.00,0.00,0.00,0.00,152.00,'2021-12-04 07:25:16','',''),(2148023,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:25:16','',''),(2148052,'1','153','763',321,'Retail Sale Id 1272628',499.20,0.00,0.00,0.00,29.64,'2021-12-04 07:26:20','',''),(2148053,'1','153','763',321,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 07:26:20','',''),(2148080,'1','153','763',321,'Retail Sale Id 1272643',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 07:27:47','',''),(2148081,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:27:47','',''),(2148172,'1','153','763',321,'Retail Sale Id 1272690',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:32:14','',''),(2148173,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:32:14','',''),(2148198,'1','153','763',321,'Retail Sale Id 1272703',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:33:37','',''),(2148199,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:33:37','',''),(2148244,'1','153','763',321,'Retail Sale Id 1272730',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:35:10','',''),(2148245,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:35:10','',''),(2148299,'1','153','763',321,'Retail Sale Id 1272764',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 07:37:52','',''),(2148300,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 07:37:52','',''),(2148341,'1','153','763',321,'Retail Sale Id 1272786',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:39:44','',''),(2148342,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:39:44','',''),(2148371,'1','153','763',321,'Retail Sale Id 1272803',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 07:40:48','',''),(2148372,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 07:40:48','',''),(2148392,'1','153','763',321,'Retail Sale Id 1272818',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 07:42:04','',''),(2148393,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:42:04','',''),(2148416,'1','153','763',321,'Retail Sale Id 1272862',7001.60,0.00,0.00,0.00,415.72,'2021-12-04 07:43:49','',''),(2148417,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 07:43:49','',''),(2148460,'1','153','763',321,'Retail Sale Id 1272898',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 07:46:37','',''),(2148461,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 07:46:37','',''),(2148525,'1','153','763',321,'Retail Sale Id 1272936',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 07:50:35','',''),(2148526,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:50:35','',''),(2148539,'1','153','763',321,'Retail Sale Id 1272945',5497.60,0.00,0.00,0.00,326.42,'2021-12-04 07:51:38','',''),(2148540,'1','153','763',321,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-04 07:51:38','',''),(2148568,'1','153','763',321,'Retail Sale Id 1272966',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:53:18','',''),(2148569,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:53:18','',''),(2148594,'1','153','763',321,'Retail Sale Id 1272976',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 07:54:49','',''),(2148595,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 07:54:49','',''),(2148596,'1','153','763',321,'Retail Sale Id 1272976',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 07:54:49','',''),(2148597,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:54:49','',''),(2148608,'1','153','763',321,'Retail Sale Id 1272981',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 07:56:03','',''),(2148609,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:56:03','',''),(2148620,'1','153','763',321,'Retail Sale Id 1273010',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:57:03','',''),(2148621,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:57:03','',''),(2148669,'1','153','763',321,'Retail Sale Id 1273028',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 07:59:10','',''),(2148670,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:59:10','',''),(2148707,'1','153','763',321,'Retail Sale Id 1273044',5120.00,0.00,0.00,0.00,304.00,'2021-12-04 08:00:26','',''),(2148708,'1','153','763',321,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 08:00:26','',''),(2148737,'1','153','763',321,'Retail Sale Id 1273056',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:01:39','',''),(2148738,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:01:39','',''),(2148755,'1','153','763',321,'Retail Sale Id 1273071',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:02:50','',''),(2148756,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:02:50','',''),(2148799,'1','153','763',321,'Retail Sale Id 1273091',7040.00,0.00,0.00,0.00,418.00,'2021-12-04 08:04:34','',''),(2148800,'1','153','763',321,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 08:04:34','',''),(2148813,'1','153','763',321,'Retail Sale Id 1273099',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:05:21','',''),(2148814,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:05:21','',''),(2148843,'1','153','763',321,'Retail Sale Id 1273117',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 08:06:10','',''),(2148844,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:06:10','',''),(2148864,'1','153','763',321,'Retail Sale Id 1273125',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:07:08','',''),(2148865,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:07:08','',''),(2148882,'1','153','763',321,'Retail Sale Id 1273139',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 08:08:04','',''),(2148883,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:08:04','',''),(2148924,'1','153','763',321,'Retail Sale Id 1273167',30800.00,0.00,0.00,0.00,700.00,'2021-12-04 08:10:20','',''),(2148925,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:10:20','',''),(2149015,'1','153','763',321,'Retail Sale Id 1273213',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:13:45','',''),(2149016,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:13:45','',''),(2149085,'1','153','763',321,'Retail Sale Id 1273242',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 08:16:22','',''),(2149086,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:16:22','',''),(2149087,'1','153','763',321,'Retail Sale Id 1273242',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:16:22','',''),(2149088,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:16:22','',''),(2149121,'1','153','763',321,'Retail Sale Id 1273253',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:17:34','',''),(2149124,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:17:34','',''),(2149154,'1','153','763',321,'Retail Sale Id 1273276',30800.00,0.00,0.00,0.00,700.00,'2021-12-04 08:19:32','',''),(2149155,'1','153','763',321,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:19:32','',''),(2149262,'1','153','763',321,'Retail Sale Id 1273391',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:24:04','',''),(2149263,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:24:04','',''),(2149334,'1','153','763',321,'Retail Sale Id 1273428',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:27:30','',''),(2149335,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:27:30','',''),(2149489,'1','153','763',321,'Retail Sale Id 1273525',1900.80,0.00,0.00,0.00,112.86,'2021-12-04 08:32:03','',''),(2149490,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 08:32:03','',''),(2149507,'1','153','763',321,'Retail Sale Id 1273533',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 08:33:03','',''),(2149508,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:33:03','',''),(2149547,'1','153','763',321,'Retail Sale Id 1273554',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:34:21','',''),(2149548,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:34:21','',''),(2149558,'1','153','763',321,'Retail Sale Id 1273562',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:35:04','',''),(2149559,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:35:04','',''),(2149586,'1','153','763',321,'Retail Sale Id 1273574',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:36:23','',''),(2149587,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:36:23','',''),(2149690,'1','153','763',321,'Retail Sale Id 1273618',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:40:44','',''),(2149691,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:40:44','',''),(2149725,'1','153','763',321,'Retail Sale Id 1273626',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:42:02','',''),(2149726,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:42:02','',''),(2149790,'1','153','763',321,'Retail Sale Id 1273655',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 08:44:33','',''),(2149791,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:44:33','',''),(2149818,'1','153','763',321,'Retail Sale Id 1273683',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:45:33','',''),(2149819,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:45:33','',''),(2149848,'1','153','763',321,'Retail Sale Id 1273696',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 08:46:35','',''),(2149849,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:46:35','',''),(2149878,'1','153','763',321,'Retail Sale Id 1273715',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:47:59','',''),(2149879,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:47:59','',''),(2149904,'1','153','763',321,'Retail Sale Id 1273729',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 08:49:15','',''),(2149905,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:49:15','',''),(2149958,'1','153','763',321,'Retail Sale Id 1273761',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:52:15','',''),(2149959,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:52:15','',''),(2150004,'1','153','763',321,'Retail Sale Id 1273789',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 08:54:19','',''),(2150005,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:54:19','',''),(2150033,'1','153','763',321,'Retail Sale Id 1273802',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:55:43','',''),(2150034,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:55:43','',''),(2150035,'1','153','763',321,'Retail Sale Id 1273802',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:55:43','',''),(2150036,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:55:43','',''),(2150053,'1','153','763',321,'Retail Sale Id 1273814',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 08:56:28','',''),(2150054,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:56:28','',''),(2150087,'1','153','763',321,'Retail Sale Id 1273829',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:57:54','',''),(2150088,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:57:54','',''),(2150217,'1','153','763',321,'Retail Sale Id 1273888',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 09:03:53','',''),(2150218,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 09:03:53','',''),(2150253,'1','153','763',321,'Retail Sale Id 1273918',998.40,0.00,0.00,0.00,59.28,'2021-12-04 09:05:40','',''),(2150254,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:05:40','',''),(2150280,'1','153','763',321,'Retail Sale Id 1273937',6502.40,0.00,0.00,0.00,386.08,'2021-12-04 09:07:05','',''),(2150281,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-04 09:07:05','',''),(2150290,'1','153','763',321,'Retail Sale Id 1273944',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 09:07:52','',''),(2150291,'1','153','763',321,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:07:52','',''),(2150311,'1','153','763',321,'Retail Sale Id 1273953',6003.20,0.00,0.00,0.00,356.44,'2021-12-04 09:09:07','',''),(2150312,'1','153','763',321,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 09:09:07','',''),(2150353,'1','153','763',321,'Retail Sale Id 1273976',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 09:11:23','',''),(2150354,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:11:23','',''),(2150375,'1','153','763',321,'Retail Sale Id 1273987',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 09:12:33','',''),(2150376,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:12:33','',''),(2150403,'1','153','763',321,'Retail Sale Id 1273997',7001.60,0.00,0.00,0.00,415.72,'2021-12-04 09:13:39','',''),(2150404,'1','153','763',321,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 09:13:39','',''),(2150417,'1','153','763',321,'Retail Sale Id 1274004',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 09:14:26','',''),(2150418,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:14:26','',''),(2150431,'1','153','763',321,'Retail Sale Id 1274012',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 09:15:17','',''),(2150432,'1','153','763',321,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:15:17','',''),(2150457,'1','153','763',321,'Retail Sale Id 1274025',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 09:16:38','',''),(2150458,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:16:38','',''),(2150459,'1','153','763',321,'Retail Sale Id 1274025',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:16:38','',''),(2150460,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:16:38','',''),(2150479,'1','153','763',321,'Retail Sale Id 1274039',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:17:38','',''),(2150480,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:17:38','',''),(2150499,'1','153','763',321,'Retail Sale Id 1274049',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 09:18:42','',''),(2150500,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:18:42','',''),(2150525,'1','153','763',321,'Retail Sale Id 1274061',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:19:28','',''),(2150526,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:19:28','',''),(2150559,'1','153','763',321,'Retail Sale Id 1274080',3097.60,0.00,0.00,0.00,183.92,'2021-12-04 09:20:47','',''),(2150560,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-04 09:20:47','',''),(2150573,'1','153','763',321,'Retail Sale Id 1274092',998.40,0.00,0.00,0.00,59.28,'2021-12-04 09:21:35','',''),(2150574,'1','153','763',321,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:21:35','',''),(2150597,'1','153','763',321,'Retail Sale Id 1274101',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 09:22:48','',''),(2150598,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:22:48','',''),(2150627,'1','153','763',321,'Retail Sale Id 1274116',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:23:49','',''),(2150628,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:23:49','',''),(2150637,'1','153','763',321,'Retail Sale Id 1274120',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 09:24:49','',''),(2150638,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:24:49','',''),(2150651,'1','153','763',321,'Retail Sale Id 1274128',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 09:25:54','',''),(2150652,'1','153','763',321,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 09:25:54','',''),(2150702,'1','153','763',321,'Retail Sale Id 1274153',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 09:28:03','',''),(2150703,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:28:03','',''),(2150714,'1','153','763',321,'Retail Sale Id 1274161',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 09:28:43','',''),(2150715,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:28:43','',''),(2150732,'1','153','763',321,'Retail Sale Id 1274167',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 09:29:37','',''),(2150733,'1','153','763',321,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 09:29:37','',''),(2150756,'1','153','763',321,'Retail Sale Id 1274179',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 09:30:36','',''),(2150757,'1','153','763',321,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:30:36','',''),(2150772,'1','153','763',321,'Retail Sale Id 1274196',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 09:31:55','',''),(2150773,'1','153','763',321,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:31:55','',''),(2150810,'1','153','763',321,'Retail Sale Id 1274216',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:33:43','',''),(2150811,'1','153','763',321,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:33:43','',''),(2150840,'1','153','763',321,'Retail Sale Id 1274229',3200.00,0.00,0.0