-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_152
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_152`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_152` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_152`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3218 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2529,20010,'',0,'20','1','152','SALES','','2020-07-08 23:33:00',5,0.00,0.00,'','493','2020-07-08 23:33:00','493',0,1),(2530,40009,'',0,'6.1','1','152','CASH','','2020-07-08 23:33:32',5,0.00,0.00,'','493','2020-07-08 23:33:32','493',0,1),(2531,400076,'',0,'24','1','152','SALARIES & WAGES','','2020-07-08 23:33:58',5,0.00,0.00,'','493','2020-07-08 23:33:58','493',0,1),(2532,400077,'',0,'24','1','152','PURCHASES','','2020-07-08 23:34:20',5,0.00,0.00,'','493','2020-07-08 23:34:20','493',0,1),(2533,400201,'',0,'2','1','152','ZNB E-BILLS:1015372548','','2020-07-08 23:39:53',5,0.00,0.00,'','493','2020-07-08 23:39:53','493',0,1),(2534,400202,'',0,'2','1','152','ZBN(POS):1015965368','','2020-07-08 23:40:17',5,0.00,0.00,'','493','2020-07-08 23:40:17','493',0,1),(2911,400328,'',0,'2','1','152','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:05:33',5,0.00,0.00,'','489','2020-10-29 14:05:33','489',0,1),(3215,400494,'',0,'2','1','152','FID POS COLLECTION-5620141491','','2021-02-26 16:06:19',5,0.00,0.00,'','489','2021-02-26 16:06:19','489',0,1),(3216,400495,'',0,'2','1','152','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:00:19',5,0.00,0.00,'','792','2023-02-20 14:00:19','792',0,0),(3217,400496,'',0,'2','1','152','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:14:46',5,0.00,0.00,'2023-03-17','792','2023-03-17 12:19:01','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3422 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1570,'','1','152','TOTAL DEALER SALE','09011161611','08141262300','nnayaya\'123@gmail.com','kano','kano','NO 50 FRW QTRS KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-14 11:40:44',5,'493','2020-07-14 11:40:44','493'),(1573,'','1','152','SHORTAGES ACC','09011161611','08141262300','nnayaya\'123@gmail.com','KANO','kano','NO 50 FRW QTRS','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-17 13:37:38',5,'493','2020-07-17 13:37:38','493'),(1756,'','1','152','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 14:04:42',5,'489','2020-10-29 14:04:42','489'),(3379,'','1','152','AMINU IDRIS GAS','AMINU IDRIS','08030803959','hafeexnura@gmail.com','KANO','KANO','NAIBAWA KUMBOTSO L.G','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-09-30 13:05:36',5,'587','2021-09-30 13:05:36','587'),(3380,'','1','152','EVERLASTING ','EVERLASTING','09021140487','hgaya@gmail.com','KANO','KANO','KMC','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-14 08:53:35',5,'587','2022-02-14 08:53:35','587'),(3381,'','1','152','SY GAS','SALISU YARO','08134779408','hgaya@gmail.com','KANO','KANO','DARMANAWA PRIMARY SCHOOL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-14 09:01:03',5,'587','2022-02-14 09:01:03','587'),(3382,'','1','152','BOFAK ENERGY','BOYCAR','09136207203','hgaya@gmail.com','KANO','KANO','DAKA TSALLE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-14 09:25:33',5,'587','2022-02-14 09:25:33','587'),(3383,'','1','152','M A GAS','MAS\'UD','07083237204','hgaya@gmail.com','KANO','KANO','DAKA TSALLE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-14 09:36:34',5,'587','2022-02-14 09:36:34','587'),(3384,'','1','152','US GLOBAL','ALHAJI ILYA','08087728737','hgaya@gmail.com','KANO','KANO','RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-14 13:10:08',5,'587','2022-02-14 13:10:08','587'),(3385,'','1','152','GAS SOLUTION','NIL','08134779408','hgaya@gmail.com','KANO','KANO','ZOO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-15 09:10:12',5,'587','2022-02-15 09:10:12','587'),(3386,'','1','152','AKIB GAS','ABUBAKAR','08032147654','umarmahmad45@gmail.com','KANO','STATE','BUNKURE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-16 11:13:45',5,'587','2022-02-16 11:13:45','587'),(3387,'','1','152','ASA GAS','ALHAJI SHEHU','08037682839','umarmahmad45@gmail.com','KANO','KANO','DARMANAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-16 12:20:33',5,'587','2022-02-16 12:20:33','587'),(3388,'','1','152','MS GAS','ALKASIM','07036435328','umarmahmad45@gmail.com','RANO','KANO','RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-18 07:42:41',5,'587','2022-02-18 07:42:41','587'),(3389,'','1','152','MUKHTAR GAS','MUKHTAR','07082762011','umarmahmad45@gmail.com','DOGUWA','KANO','DOGUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-18 09:38:35',5,'587','2022-02-18 09:38:35','587'),(3390,'','1','152','RANO GAS','UBALE','08144873245','hgaya@gmail.com','RANO','KANO','RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-18 14:26:37',5,'587','2022-02-18 14:26:37','587'),(3391,'','1','152','musa chiromawa ','chiromawa','09123622677','hgaya@gmail.com','KANO','KANO','chiromawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-19 08:28:25',5,'587','2022-02-19 08:28:25','587'),(3392,'','1','152','SPEEDWAY ','SHAHABUDDEEN','08037687628','hgaya@gmail.com','KUMBOTSO','KANO','NAIBAWA,YAN KATAKO.','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-22 07:55:23',5,'587','2022-02-22 07:55:23','587'),(3393,'','1','152','RAHAMA VENTURES','MAGAJI SULE','09074927413','hgaya@gmail.com','KANO','KANO','NAIBAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 09:13:12',5,'587','2022-02-22 09:13:12','587'),(3394,'','1','152','MUHIB','MUSA INUWA BABA','08140218191','hgaya@gmail.com','KUMBOTSO','KANO','DARMANAWA','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-22 09:31:32',5,'587','2022-02-22 09:31:32','587'),(3395,'','1','152','GUNDAWA','ABU LAWAN','09029299953','hgaya@gmail.com','KUMBOTSO','KANO','SALLARI ','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-22 10:30:58',5,'587','2022-02-22 10:30:58','587'),(3396,'','1','152','A JA\'E AND SONS','BALARABE TIJJANI','08027276413','umarmahmad45@gmail.com','RANO','KANO','RANO KIBIYA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 13:26:27',5,'587','2022-02-22 13:26:27','587'),(3397,'','1','152','ONE DIAL','SIDI ABDULNASAR','08037878747','hgaya@gmail.com','NASARAWA','KANO','PLOT 16,MUHAMMAD GAUYAMA ROAD,KANO','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-22 16:42:18',5,'587','2022-02-22 16:42:18','587'),(3398,'','1','152','ALHAJI GAMS','ALHAJI GAMS','08146466819','hgaya@gmail.com','RANO','KANO','RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-24 09:57:10',5,'587','2022-02-24 09:57:10','587'),(3399,'','1','152','R FADA','ABDULLAHI AHMAD','08131910364','umarmahmad45@gmail.com','KUMBOTSO','KANO','LAYIN CHAIRMAN,NAIBAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-24 11:06:20',5,'587','2022-02-24 11:06:20','587'),(3400,'','1','152','LG GAS','BABA LAWAN','08037452453','hgaya@gmail.com','TARAUNI','KANO','AHMAD MUSA STREET,UNGUWA UKU.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 11:09:29',5,'587','2022-02-26 11:09:29','587'),(3401,'','1','152','M & R','MURTALA RABIU','08064924753','hgaya@gmail.com','KANO','KANO','KARFI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 11:57:03',5,'587','2022-02-26 11:57:03','587'),(3402,'','1','152','CITIZEN','FARUK','09067532178','hgaya@gmail.com','KANO','KANO','GADAR TANBURAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 16:22:17',5,'587','2022-02-26 16:22:17','587'),(3403,'','1','152','NSS GAS','NASIRU SHUAIBU SANI','09016232323','hgaya@gmail.com','KANO','KANO','UNGUWA UKU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-28 14:56:09',5,'587','2022-02-28 14:56:09','587'),(3404,'','1','152','HUSSAINI GAS','HUSSAINI','07035212127','hgaya@gmail.com','KANO','KANO','FARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-28 15:39:51',5,'587','2022-02-28 15:39:51','587'),(3405,'','1','152','ALIYU DOGUWA','ALIYU','07061221441','hgaya@gmail.com','KANO','STATE','DOGUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 09:56:54',5,'587','2022-03-02 09:56:54','587'),(3406,'','1','152','UMAR GAS','UMAR','08030803959','hgaya@gmail.com','KANO','KANO','NAIBAWA LAYIN DAN HASSAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 13:36:24',5,'587','2022-03-02 13:36:24','587'),(3407,'','1','152','MUY','FARUK UMAR','07065090057','hgaya@gmail.com','KUMBOTSO','KANO','SALLARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 09:40:47',5,'587','2022-03-04 09:40:47','587'),(3408,'','1','152','MAZ GAS','MANSUR','08131699130','hgaya@gmail.com','KANO','KANO','UNGUWA UKU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 09:57:09',5,'587','2022-03-06 09:57:09','587'),(3409,'','1','152','BARNA GAS','IBRAHIM ','07014909999','hgaya@gmail.com','KANO','KANO','NAIBAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 12:44:52',5,'587','2022-03-06 12:44:52','587'),(3410,'','1','152','A2 RIRUWAI GAS','BASHIR','08069186880','umarmahmad45@gmail.com','KANO','KANO','RIRUWAI DOGUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 07:44:07',5,'587','2022-03-08 07:44:07','587'),(3411,'','1','152','ZUMUNTA GAS','MUHAMMAD BELLO','08063332142','hgaya@gmail.com','KANO','KANO','KOFAR  FADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-12 10:40:02',5,'587','2022-03-12 10:40:02','587'),(3412,'','1','152','Zola Gas','Safiyanu Ado Maraku','08066378481','safiyanuado@gmail.com','Kano','Kano','Sharada phase 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-17 13:41:43',5,'587','2022-03-17 13:41:43','587'),(3413,'','1','152','DAN HASSAN GAS','UMAR','07034239005','hgaya@gmail.com','KANO','KANO','SABUWAR GANDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-11 11:26:10',5,'587','2022-04-11 11:26:10','587'),(3414,'','1','152','KAMILU GAS','KAMILU','09077549770','safiyanuado@gmail.com','KANO','KANO','KAFIN MAI YAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-05 08:51:12',5,'587','2022-05-05 08:51:12','587'),(3415,'','1','152','BK GAS','ABUBAKAR SALISU','08092941263','morosyy20@gmail.com','KANO','KANO','HOTORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-10 12:34:35',5,'894','2022-06-10 12:34:35','894'),(3416,'','1','152','DAN BABA GAS','UMAR IBRAHIM','08036007634','morosyy@gmail.com','KANO','KANO','OPP SCROE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-04 12:45:23',5,'894','2022-07-04 12:45:23','894'),(3417,'','1','152','COUNTRY PRIDE','ABUBAKAR ','07069554876','morosyy20@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-15 17:10:34',5,'894','2022-10-15 17:10:34','894'),(3418,'','1','152','AB GAS','07061979396','07061979396','morosyy20@gmail.com','KANO','KANO','BARKOM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-23 14:51:34',5,'894','2022-11-23 14:51:34','894'),(3419,'','1','152','JANWUYA GAS','08039798759','08039798759','bksuhair@gmail.com','KANO','KANO','NAIBAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 10:52:03',5,'894','2022-11-30 10:52:03','894'),(3420,'','1','152','SAYYADI ULTIMATE GAS','SALISU ABUBAKAR','09027967332','kura@gmai.com','KANO','KANO','KURA K/AREWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-13 07:24:54',5,'894','2022-12-13 07:24:54','894'),(3421,'','1','152','SHABRIK GAS ','SAFIYA IBRAHIM','08067841431','ohunene4real@gmail.com','KANO','KANO','NO.444 YAR AKWA KWANAR MASALLACI NAIBAWA KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-13 15:58:05',5,'894','2023-01-13 15:58:05','894');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16442 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','152',12366,'757',402.00,66.00,'2020-07-02','','2020-07-14 13:44:05','493','493',2020,'493','2020-07-14 13:44:05',5),('1','152',12367,'757',66.00,468.00,'2020-07-02','','2020-07-14 13:47:24','493','493',2020,'493','2020-07-14 13:47:24',5),('1','152',12377,'757',315.00,249.00,'2020-07-15','NEW DIPPING','2020-07-15 12:41:36','493','493',2020,'493','2020-07-15 12:41:36',5),('1','152',12748,'757',899.00,886.00,'2020-09-18','','2020-09-18 10:58:37','487','487',2020,'487','2020-09-18 10:58:37',5),('1','152',14957,'757',2107.00,283.00,'2021-05-16','','2021-05-16 11:44:07','483','483',2021,'483','2021-05-16 11:44:07',5),('1','152',16439,'757',5899.83,4000.00,'2021-09-16','new','2021-09-16 10:45:02','483','483',2021,'483','2021-09-16 10:45:02',5),('1','152',16440,'757',5404.00,5899.00,'2021-09-16','new','2021-09-16 10:49:50','483','483',2021,'483','2021-09-16 10:49:50',5),('1','152',16441,'757',1.21,2465.00,'2023-03-14','new dipping','2023-03-14 17:47:49','483','483',2023,'483','2023-03-14 17:47:49',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2829 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','152','757',2123,'5','LPG NOZZLE 1',1153778.72,'LPG DESPENSER (END USER)','',NULL,NULL,'',5,'2022-01-20 07:26:26','483'),('1','152','757',2124,'5','LPG NOZZLE 2',994136.40,'LPG DISPENSER (DEALER & END-USER)','',NULL,NULL,'',5,'2022-01-20 07:27:16','483'),('1','152','757',2668,'5','LPG NOZZLE 3',297884.44,'LPG DESPENSER (FOR DEALERS)','',NULL,NULL,'',5,'2022-01-20 07:28:06','483'),('1','152','757',2828,'5','LPG NOZZLE 4',86381571.66,'LPG DISPENSER','',NULL,NULL,'',5,'2022-01-20 07:28:50','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258028 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','152',143130,'DAILY SHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-14 12:19:17','493','2020-07-14 12:19:56',10,0),('1','152',143151,'DAILY SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 09:53:37','493','2020-07-15 09:54:16',10,0),('1','152',143242,'DAILY SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 10:19:40','493','2020-07-15 10:20:12',10,0),('1','152',143251,'DAILY SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 11:53:42','493','2020-07-15 11:54:28',10,0),('1','152',143256,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 12:50:23','493','2020-07-15 12:51:01',10,0),('1','152',143270,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 13:06:05','493','2020-07-15 13:06:51',10,0),('1','152',143279,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 14:14:46','493','2020-07-15 14:15:36',10,0),('1','152',143285,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 14:24:34','493','2020-07-15 14:26:13',10,0),('1','152',143290,'DAILY SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-15 15:07:37','493','2020-07-15 15:14:04',10,0),('1','152',143549,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-17 15:28:55','493','2020-07-17 15:29:24',10,0),('1','152',143568,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-17 15:46:32','493','2020-07-17 15:47:29',10,0),('1','152',143577,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-18 11:18:40','493','2020-07-18 11:39:32',10,0),('1','152',143650,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-18 11:48:50','493','2020-07-18 12:05:54',10,0),('1','152',143692,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-18 14:00:57','493','2020-07-18 14:01:26',10,0),('1','152',143698,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-18 14:29:08','493','2020-07-18 14:35:33',10,0),('1','152',143705,'DAILY SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-18 14:43:47','493','2020-07-21 12:17:41',10,0),('1','152',144095,'DAILY SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-07-21 13:51:41','493','2020-08-11 12:23:34',10,0),('1','152',146805,'DAILY SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-11 12:37:37','493','2020-08-11 12:43:18',10,0),('1','152',146807,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-17 13:33:43','493','2020-08-17 13:34:47',10,0),('1','152',147797,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-17 14:10:30','493','2020-08-17 14:17:28',10,0),('1','152',147806,'DAILY SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-17 14:47:32','493','2020-08-19 17:32:40',10,0),('1','152',148106,'DAILY SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-19 17:44:39','493','2020-08-20 10:33:30',10,0),('1','152',148171,'DAILY SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 10:45:41','493','2020-08-20 10:50:28',10,0),('1','152',148177,'DAILY SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 11:07:42','493','2020-08-20 11:11:37',10,0),('1','152',148181,'DAILY SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 14:22:51','493','2020-08-20 14:26:13',10,0),('1','152',148230,'DAILY SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 15:19:53','493','2020-08-20 15:20:33',10,0),('1','152',148248,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 16:18:31','493','2020-08-20 16:20:49',10,0),('1','152',148252,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 16:33:59','493','2020-08-20 16:39:03',10,0),('1','152',148255,'DAILY SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-20 16:55:53','493','2020-08-20 16:58:06',10,0),('1','152',148379,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-21 16:01:12','493','2020-08-21 16:02:41',10,0),('1','152',148382,'DAILY SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-21 16:20:05','493','2020-08-21 16:20:59',10,0),('1','152',148506,'DAILY SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-22 14:29:27','493','2020-08-22 14:30:24',10,0),('1','152',148514,'DAILY SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-22 14:53:06','493','2020-08-22 14:53:36',10,0),('1','152',148538,'DAILY SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-22 17:12:58','493','2020-08-22 17:14:11',10,0),('1','152',148598,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 12:40:46','493','2020-08-23 12:42:09',10,0),('1','152',148601,'DAILY SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 13:07:32','493','2020-08-23 13:08:31',10,0),('1','152',148609,'DAILY SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 13:25:43','493','2020-08-23 13:26:16',10,0),('1','152',148613,'DAILY SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 13:44:42','493','2020-08-23 13:45:26',10,0),('1','152',148617,'DAILY SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 14:10:52','493','2020-08-23 14:11:29',10,0),('1','152',148623,'DAILY SHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 14:24:35','493','2020-08-23 14:25:23',10,0),('1','152',148634,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 14:54:27','493','2020-08-23 15:44:33',10,0),('1','152',148638,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-23 15:55:09','493','2020-08-23 15:56:10',10,0),('1','152',148734,'DAILY SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 12:18:11','493','2020-08-24 12:19:12',10,0),('1','152',148747,'DAILY SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 12:53:15','493','2020-08-24 12:54:19',10,0),('1','152',148755,'DAILY SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 13:14:27','493','2020-08-24 13:15:20',10,0),('1','152',148757,'DAILY SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 13:29:09','493','2020-08-24 13:29:56',10,0),('1','152',148761,'DAILY SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 13:51:18','493','2020-08-24 13:51:44',10,0),('1','152',148762,'DAILY SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 14:12:14','493','2020-08-24 14:12:44',10,0),('1','152',148765,'DAILY SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 14:29:28','493','2020-08-24 14:31:34',10,0),('1','152',148766,'DAILY SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 14:53:09','493','2020-08-24 14:53:46',10,0),('1','152',148771,'DAILY SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 15:33:30','493','2020-08-24 15:34:45',10,0),('1','152',148774,'DAILY SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 15:55:16','493','2020-08-24 15:56:03',10,0),('1','152',148777,'DAILY SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 16:17:34','493','2020-08-24 16:18:20',10,0),('1','152',148784,'DAILY SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 16:38:43','493','2020-08-24 16:39:43',10,0),('1','152',148789,'DAILY SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-24 17:01:43','493','2020-08-24 17:02:24',10,0),('1','152',148869,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 11:50:38','493','2020-08-25 11:51:06',10,0),('1','152',148874,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 12:26:42','493','2020-08-25 12:27:22',10,0),('1','152',148879,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 12:55:55','493','2020-08-25 12:56:33',10,0),('1','152',148888,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 13:16:10','493','2020-08-25 13:16:50',10,0),('1','152',148894,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 13:27:03','493','2020-08-25 13:27:57',10,0),('1','152',148898,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 13:41:54','493','2020-08-25 13:42:40',10,0),('1','152',148902,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 13:57:47','493','2020-08-25 13:58:22',10,0),('1','152',148906,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 14:48:55','493','2020-08-25 14:49:30',10,0),('1','152',148907,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-25 15:11:52','493','2020-08-25 15:12:19',10,0),('1','152',149021,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-26 11:28:59','493','2020-08-26 11:29:44',10,0),('1','152',149039,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-26 12:30:00','493','2020-08-26 12:30:41',10,0),('1','152',149045,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-26 12:56:09','493','2020-08-26 12:57:39',10,0),('1','152',149053,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-26 15:12:55','493','2020-08-26 15:13:59',10,0),('1','152',149108,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-26 16:01:11','493','2020-08-26 16:01:40',10,0),('1','152',149112,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 11:14:03','493','2020-08-27 11:15:34',10,0),('1','152',149196,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 12:27:02','493','2020-08-27 12:27:50',10,0),('1','152',149208,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 12:47:48','493','2020-08-27 12:49:00',10,0),('1','152',149214,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 13:04:41','493','2020-08-27 13:05:40',10,0),('1','152',149217,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 13:21:18','493','2020-08-27 13:21:56',10,0),('1','152',149219,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 13:35:42','493','2020-08-27 13:36:19',10,0),('1','152',149226,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 13:55:19','493','2020-08-27 13:58:37',10,0),('1','152',149229,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 14:13:52','493','2020-08-27 14:14:34',10,0),('1','152',149233,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 14:30:07','493','2020-08-27 14:33:03',10,0),('1','152',149238,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 14:53:24','493','2020-08-27 14:54:06',10,0),('1','152',149244,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 15:17:26','493','2020-08-27 15:18:03',10,0),('1','152',149247,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 15:37:53','493','2020-08-27 15:38:46',10,0),('1','152',149251,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 15:46:17','493','2020-08-27 15:46:48',10,0),('1','152',149254,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 15:55:27','493','2020-08-27 15:56:27',10,0),('1','152',149257,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 16:14:33','493','2020-08-27 16:15:27',10,0),('1','152',149259,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 16:26:29','493','2020-08-27 16:27:19',10,0),('1','152',149266,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 16:40:46','493','2020-08-27 16:41:24',10,0),('1','152',149269,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 16:53:30','493','2020-08-27 16:54:05',10,0),('1','152',149272,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-27 17:08:51','493','2020-08-27 17:09:34',10,0),('1','152',149343,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 10:34:34','493','2020-08-28 10:35:16',10,0),('1','152',149348,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 10:58:22','493','2020-08-28 10:59:15',10,0),('1','152',149350,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 11:17:34','493','2020-08-28 11:18:14',10,0),('1','152',149376,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 13:34:43','493','2020-08-28 13:35:51',10,0),('1','152',149382,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 13:59:00','493','2020-08-28 13:59:36',10,0),('1','152',149385,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-28 14:10:04','493','2020-08-28 14:11:00',10,0),('1','152',149640,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-30 11:20:09','493','2020-08-30 11:20:49',10,0),('1','152',149641,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-31 12:40:33','493','2020-08-31 12:41:00',10,0),('1','152',149773,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-31 12:53:28','493','2020-08-31 12:54:19',10,0),('1','152',149778,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-31 13:05:11','493','2020-08-31 13:06:00',10,0),('1','152',149784,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-08-31 13:18:06','493','2020-08-31 13:18:43',10,0),('1','152',149932,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-01 12:58:20','493','2020-09-01 12:59:48',10,0),('1','152',150071,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-02 12:43:04','493','2020-09-02 12:43:44',10,0),('1','152',150258,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-03 12:45:47','493','2020-09-03 12:46:40',10,0),('1','152',150493,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-04 14:09:54','493','2020-09-04 14:10:19',10,0),('1','152',150647,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-05 13:54:53','493','2020-09-05 13:55:26',10,0),('1','152',150898,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'493',0.00,0.01,'493','2020-09-07 11:24:33','493','2020-09-07 11:25:00',10,0),('1','152',150939,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-07 14:30:50','493','2020-09-07 14:31:24',10,0),('1','152',151050,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-08 12:02:26','493','2020-09-08 12:02:46',10,0),('1','152',151055,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'493',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','152',152518,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-18 10:53:54','493','2020-09-18 10:54:20',10,0),('1','152',153681,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 09:48:44','493','2020-09-25 09:49:21',10,0),('1','152',153687,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 10:10:06','493','2020-09-25 10:10:56',10,0),('1','152',153690,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 10:27:28','493','2020-09-25 10:27:52',10,0),('1','152',153693,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 10:46:56','493','2020-09-25 10:47:29',10,0),('1','152',153700,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 11:01:58','493','2020-09-25 11:02:26',10,0),('1','152',153703,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-25 11:13:18','493','2020-09-25 11:13:43',10,0),('1','152',153833,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 11:49:17','493','2020-09-26 11:49:54',10,0),('1','152',153859,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 13:20:43','493','2020-09-26 13:22:09',10,0),('1','152',153869,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 13:50:35','493','2020-09-26 13:51:20',10,0),('1','152',153874,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 14:47:52','493','2020-09-26 14:48:49',10,0),('1','152',153928,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 20:50:45','493','2020-09-26 20:51:09',10,0),('1','152',153929,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 21:22:31','493','2020-09-26 21:22:53',10,0),('1','152',153930,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-26 21:48:19','493','2020-09-26 21:48:52',10,0),('1','152',153969,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 11:45:38','493','2020-09-27 11:46:08',10,0),('1','152',153974,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 12:23:54','493','2020-09-27 12:24:15',10,0),('1','152',153987,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 13:13:36','493','2020-09-27 13:13:59',10,0),('1','152',153997,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 13:34:36','493','2020-09-27 13:34:54',10,0),('1','152',154005,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 20:08:41','493','2020-09-27 20:09:13',10,0),('1','152',154056,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 20:28:06','493','2020-09-27 20:28:28',10,0),('1','152',154060,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 20:45:43','493','2020-09-27 20:46:24',10,0),('1','152',154067,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-27 22:05:50','493','2020-09-27 22:07:36',10,0),('1','152',154068,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-28 06:54:54','493','2020-09-28 06:55:20',10,0),('1','152',154076,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-28 07:25:56','493','2020-09-28 07:26:21',10,0),('1','152',154081,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-28 08:08:00','493','2020-09-28 08:08:37',10,0),('1','152',154086,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-28 08:44:48','493','2020-09-28 08:45:16',10,0),('1','152',154093,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-28 09:31:26','493','2020-09-28 09:31:46',10,0),('1','152',154369,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-09-29 15:49:30','493','2020-09-29 15:49:59',10,0),('1','152',154893,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 07:51:24','493','2020-10-03 07:51:51',10,0),('1','152',154894,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 08:24:47','493','2020-10-03 08:25:26',10,0),('1','152',154900,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 09:16:28','493','2020-10-03 09:16:51',10,0),('1','152',154924,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 10:43:37','493','2020-10-03 10:44:08',10,0),('1','152',154927,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 10:55:36','493','2020-10-03 10:55:56',10,0),('1','152',154953,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-03 12:46:28','493','2020-10-03 12:46:51',10,0),('1','152',155419,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 15:36:44','493','2020-10-06 15:37:11',10,0),('1','152',155421,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 15:45:45','493','2020-10-06 15:46:29',10,0),('1','152',155426,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 16:02:50','493','2020-10-06 16:03:21',10,0),('1','152',155433,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 16:39:08','493','2020-10-06 16:39:37',10,0),('1','152',155438,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 17:10:23','493','2020-10-06 17:10:57',10,0),('1','152',155453,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-06 19:02:23','493','2020-10-06 19:05:41',10,0),('1','152',155884,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-09 15:34:20','493','2020-10-09 15:34:56',10,0),('1','152',155895,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-09 21:24:43','493','2020-10-09 21:27:50',10,0),('1','152',155935,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-09 21:52:41','493','2020-10-09 21:54:50',10,0),('1','152',155948,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-10 07:24:38','493','2020-10-10 07:25:16',10,0),('1','152',155949,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-10 07:51:16','493','2020-10-10 07:51:54',10,0),('1','152',155955,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-10 08:20:32','493','2020-10-10 08:20:56',10,0),('1','152',156229,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-12 07:33:44','493','2020-10-12 07:34:27',10,0),('1','152',156249,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-12 09:02:52','493','2020-10-12 09:03:21',10,0),('1','152',156253,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-12 09:20:39','493','2020-10-12 09:21:05',10,0),('1','152',156436,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-13 08:07:03','493','2020-10-13 08:07:24',10,0),('1','152',156462,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-13 10:12:58','493','2020-10-13 10:13:20',10,0),('1','152',156632,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-14 11:26:52','493','2020-10-14 11:27:15',10,0),('1','152',156640,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-14 11:46:19','493','2020-10-14 11:47:05',10,0),('1','152',156760,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-15 08:54:25','493','2020-10-15 08:55:08',10,0),('1','152',157835,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-25 12:38:04','493','2020-10-25 12:38:24',10,0),('1','152',158487,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-25 12:46:00','493','2020-10-25 12:46:23',10,0),('1','152',158492,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-25 13:04:49','493','2020-10-25 13:05:12',10,0),('1','152',158554,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-25 17:14:01','493','2020-10-25 17:14:32',10,0),('1','152',158583,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 06:30:31','493','2020-10-26 06:30:52',10,0),('1','152',158584,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 06:39:39','493','2020-10-26 06:46:47',10,0),('1','152',158589,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 07:07:28','493','2020-10-26 07:07:46',10,0),('1','152',158590,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 07:24:50','493','2020-10-26 07:25:16',10,0),('1','152',158592,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 08:26:53','493','2020-10-26 08:27:24',10,0),('1','152',158716,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 16:10:44','493','2020-10-26 16:11:09',10,0),('1','152',158724,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 16:28:44','493','2020-10-26 16:29:03',10,0),('1','152',158727,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 16:47:15','493','2020-10-26 16:47:34',10,0),('1','152',158730,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 22:10:01','493','2020-10-26 22:11:20',10,0),('1','152',158754,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 22:53:06','493','2020-10-26 22:53:55',10,0),('1','152',158755,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 23:05:50','493','2020-10-26 23:06:14',10,0),('1','152',158756,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 23:40:51','493','2020-10-26 23:41:13',10,0),('1','152',158757,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-26 23:52:56','493','2020-10-26 23:53:25',10,0),('1','152',158758,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 05:09:05','493','2020-10-27 05:09:27',10,0),('1','152',158759,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 05:24:54','493','2020-10-27 05:25:18',10,0),('1','152',158760,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 05:32:55','493','2020-10-27 05:33:18',10,0),('1','152',158761,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 05:47:42','493','2020-10-27 05:48:03',10,0),('1','152',158762,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 06:02:03','493','2020-10-27 06:02:37',10,0),('1','152',158765,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 08:29:33','493','2020-10-27 08:29:52',10,0),('1','152',158792,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 08:55:31','493','2020-10-27 08:55:57',10,0),('1','152',158794,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-27 09:01:08','493','2020-10-27 09:01:29',10,0),('1','152',158944,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-28 06:58:53','493','2020-10-28 06:59:24',10,0),('1','152',158994,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-29 16:36:26','493','2020-10-29 16:37:04',10,0),('1','152',159261,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-29 17:45:24','493','2020-10-29 17:46:09',10,0),('1','152',159427,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-30 17:13:56','493','2020-10-30 17:14:28',10,0),('1','152',159440,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-30 17:40:09','493','2020-10-30 17:40:38',10,0),('1','152',159448,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-10-30 18:22:15','493','2020-10-30 18:22:49',10,0),('1','152',159646,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-01 11:28:48','493','2020-11-01 11:29:24',10,0),('1','152',159652,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-01 12:22:05','493','2020-11-01 12:22:43',10,0),('1','152',159662,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-01 13:10:46','493','2020-11-01 13:11:19',10,0),('1','152',159677,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-01 13:41:13','493','2020-11-01 13:41:42',10,0),('1','152',159686,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-01 13:57:24','493','2020-11-01 13:58:04',10,0),('1','152',159907,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-02 16:59:24','493','2020-11-02 17:00:01',10,0),('1','152',159919,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-02 17:52:31','493','2020-11-02 17:53:02',10,0),('1','152',159926,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-02 17:59:40','493','2020-11-02 18:00:19',10,0),('1','152',160009,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-03 10:38:42','493','2020-11-03 10:39:05',10,0),('1','152',160077,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-03 15:15:12','493','2020-11-03 15:15:48',10,0),('1','152',160087,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-03 15:39:19','493','2020-11-03 15:39:47',10,0),('1','152',160188,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-04 16:46:19','493','2020-11-04 16:46:51',10,0),('1','152',160293,'BULK SALES','2020-11-03','2020-11-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-04 17:25:48','493','2020-11-04 17:26:26',10,0),('1','152',160299,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-04 17:34:43','493','2020-11-04 17:35:17',10,0),('1','152',160302,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-04 17:51:46','493','2020-11-04 17:52:17',10,0),('1','152',160439,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-05 16:54:47','493','2020-11-05 16:55:13',10,0),('1','152',160441,'BULK SALES','2020-11-04','2020-11-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-05 17:33:55','493','2020-11-05 17:34:39',10,0),('1','152',160445,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-06 15:48:11','493','2020-11-06 15:48:32',10,0),('1','152',160569,'BULK SALES','2020-11-04','2020-11-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-06 15:58:29','493','2020-11-06 15:59:08',10,0),('1','152',160571,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-06 16:08:15','493','2020-11-06 16:08:47',10,0),('1','152',160831,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-08 13:32:12','493','2020-11-08 13:32:31',10,0),('1','152',160838,'BULK SALES','2020-11-06','2020-11-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-08 14:10:29','493','2020-11-08 14:10:50',10,0),('1','152',160843,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-08 14:18:05','493','2020-11-08 14:18:26',10,0),('1','152',160844,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-08 14:32:16','493','2020-11-08 14:32:36',10,0),('1','152',161199,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-10 14:33:48','493','2020-11-10 14:34:10',10,0),('1','152',161247,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-10 16:58:09','493','2020-11-10 16:58:38',10,0),('1','152',161253,'BULK SALES','2020-11-09','2020-11-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-10 17:59:10','493','2020-11-10 17:59:40',10,0),('1','152',161259,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-10 18:08:16','493','2020-11-10 18:08:46',10,0),('1','152',161434,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-11 17:27:37','493','2020-11-11 17:28:00',10,0),('1','152',161448,'BULK SALES','2020-11-10','2020-11-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-13 08:57:13','493','2020-11-13 08:57:33',10,0),('1','152',161725,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-13 09:02:25','493','2020-11-13 09:02:44',10,0),('1','152',161898,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-14 07:27:48','493','2020-11-14 07:28:22',10,0),('1','152',161902,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-14 07:50:10','493','2020-11-14 07:50:47',10,0),('1','152',161906,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-14 08:06:47','493','2020-11-14 08:07:09',10,0),('1','152',161910,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-14 08:41:16','493','2020-11-14 08:41:41',10,0),('1','152',162416,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 15:44:59','493','2020-11-16 15:45:34',10,0),('1','152',162421,'BULK SALES','2020-11-13','2020-11-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 16:07:05','493','2020-11-16 16:07:33',10,0),('1','152',162424,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 16:11:52','493','2020-11-16 16:12:16',10,0),('1','152',162429,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 16:24:33','493','2020-11-16 16:25:04',10,0),('1','152',162433,'BULK SALES','2020-11-15','2020-11-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 16:36:49','493','2020-11-16 16:38:14',10,0),('1','152',162437,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-16 16:42:18','493','2020-11-16 16:42:42',10,0),('1','152',162543,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-17 11:23:43','493','2020-11-17 11:24:10',10,0),('1','152',162893,'BULK SALES','2020-11-16','2020-11-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-19 15:37:53','493','2020-11-19 15:38:18',10,0),('1','152',162988,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-19 16:49:38','493','2020-11-19 16:50:07',10,0),('1','152',162990,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-19 16:58:21','493','2020-11-19 16:58:41',10,0),('1','152',163124,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-20 13:37:54','493','2020-11-20 13:38:18',10,0),('1','152',163129,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-20 13:56:19','493','2020-11-20 13:56:45',10,0),('1','152',163135,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-20 14:09:10','493','2020-11-20 14:10:48',10,0),('1','152',163142,'BULK SALES','2020-11-19','2020-11-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-20 14:21:01','493','2020-11-20 14:21:39',10,0),('1','152',163145,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-20 14:31:57','493','2020-11-20 14:32:23',10,0),('1','152',163283,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-21 11:24:58','493','2020-11-21 11:26:12',10,0),('1','152',163287,'BULK SALES','2020-11-20','2020-11-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-22 12:19:13','493','2020-11-22 12:19:42',10,0),('1','152',163461,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-22 12:28:20','493','2020-11-22 12:29:26',10,0),('1','152',163464,'BULK SALES','2020-11-21','2020-11-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-22 12:40:42','493','2020-11-22 12:41:18',10,0),('1','152',163469,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-23 09:18:30','493','2020-11-23 09:18:59',10,0),('1','152',163592,'BULK SALES','2020-11-22','2020-11-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-23 09:23:05','493','2020-11-23 09:23:41',10,0),('1','152',163596,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-23 09:39:48','493','2020-11-23 09:40:15',10,0),('1','152',163802,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-24 10:58:10','493','2020-11-24 10:58:34',10,0),('1','152',163810,'BULK SALES','2020-11-23','2020-11-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-25 12:36:05','493','2020-11-25 12:36:33',10,0),('1','152',163985,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-25 12:42:56','493','2020-11-25 12:43:17',10,0),('1','152',164078,'BULK SALES','2020-11-24','2020-11-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-25 19:31:16','493','2020-11-25 19:31:58',10,0),('1','152',164079,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-25 19:42:34','493','2020-11-25 19:43:05',10,0),('1','152',164701,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-29 14:51:36','493','2020-11-29 14:52:14',10,0),('1','152',164863,'BULK SALES','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 12:47:37','493','2020-11-30 12:48:07',10,0),('1','152',164864,'BULK SALES','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 13:15:40','493','2020-11-30 13:16:03',10,0),('1','152',164870,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 13:29:43','493','2020-11-30 13:30:34',10,0),('1','152',164875,'BULK SALES','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 13:48:55','493','2020-11-30 13:49:27',10,0),('1','152',164880,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 13:57:50','493','2020-11-30 13:58:17',10,0),('1','152',164886,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 14:10:47','493','2020-11-30 14:11:11',10,0),('1','152',164888,'BULK SALES','2020-11-27','2020-11-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 14:34:49','493','2020-11-30 14:35:58',10,0),('1','152',164894,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-11-30 15:26:15','493','2020-11-30 15:26:40',10,0),('1','152',164924,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-01 09:21:20','493','2020-12-01 09:22:09',10,0),('1','152',165006,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-01 09:40:46','493','2020-12-01 09:41:13',10,0),('1','152',165012,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-01 10:05:22','493','2020-12-01 10:05:45',10,0),('1','152',165181,'BULK SALES','2020-11-30','2020-11-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-02 11:41:02','493','2020-12-02 11:41:38',10,0),('1','152',165186,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-02 11:58:59','493','2020-12-02 11:59:38',10,0),('1','152',165348,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-03 09:47:29','493','2020-12-03 09:48:25',10,0),('1','152',165479,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-04 08:26:55','493','2020-12-04 08:27:19',10,0),('1','152',165509,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-06 14:51:24','493','2020-12-06 14:51:54',10,0),('1','152',165899,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-06 16:03:38','493','2020-12-06 16:06:43',10,0),('1','152',165928,'BULK SALES','2020-12-04','2020-12-04 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-06 19:32:36','493','2020-12-06 19:33:31',10,0),('1','152',165930,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-06 19:55:11','493','2020-12-06 19:55:39',10,0),('1','152',166061,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-07 13:27:52','493','2020-12-07 13:28:20',10,0),('1','152',166067,'BULK SALES','2020-12-06','2020-12-06 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-08 15:18:00','493','2020-12-08 15:18:26',10,0),('1','152',166287,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-08 15:40:32','493','2020-12-08 15:40:54',10,0),('1','152',166419,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-09 14:27:09','493','2020-12-09 14:33:30',10,0),('1','152',166609,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-10 14:05:37','493','2020-12-10 14:05:59',10,0),('1','152',166748,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-11 08:46:31','493','2020-12-11 08:49:03',10,0),('1','152',167157,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-13 16:22:59','493','2020-12-13 16:23:22',10,0),('1','152',167162,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-13 16:30:48','493','2020-12-13 16:31:09',10,0),('1','152',167163,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-13 19:01:38','493','2020-12-13 19:02:08',10,0),('1','152',167183,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-13 19:14:14','493','2020-12-13 19:14:41',10,0),('1','152',167184,'BULK SALES','2020-12-13','2020-12-13 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-13 19:21:43','493','2020-12-13 19:22:08',10,0),('1','152',167526,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-15 15:06:54','493','2020-12-15 15:07:16',10,0),('1','152',167705,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-16 16:16:28','493','2020-12-16 16:17:19',10,0),('1','152',167707,'BULK SALES','2020-12-15','2020-12-15 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-16 16:38:17','493','2020-12-16 16:38:48',10,0),('1','152',167791,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-17 10:54:07','493','2020-12-17 10:54:44',10,0),('1','152',167941,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-18 08:28:04','493','2020-12-18 08:29:50',10,0),('1','152',168010,'BULK SALES','2020-12-17','2020-12-17 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-18 13:21:55','493','2020-12-18 13:22:18',10,0),('1','152',168015,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-18 13:39:39','493','2020-12-18 13:40:09',10,0),('1','152',168374,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-20 14:30:53','493','2020-12-20 14:31:17',10,0),('1','152',168391,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-20 16:24:39','493','2020-12-20 16:25:23',10,0),('1','152',168537,'BULK SALES','2020-12-19','2020-12-19 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-21 13:36:34','493','2020-12-21 13:42:00',10,0),('1','152',168558,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-21 15:17:36','493','2020-12-21 15:18:47',10,0),('1','152',168732,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-22 15:42:06','493','2020-12-22 15:43:09',10,0),('1','152',168917,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-23 17:04:49','493','2020-12-23 17:05:08',10,0),('1','152',169002,'BULK SALES','2020-12-23','2020-12-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-24 11:26:27','493','2020-12-24 11:26:51',10,0),('1','152',169009,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-24 11:44:31','493','2020-12-24 11:45:06',10,0),('1','152',169467,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 09:20:02','493','2020-12-27 09:21:47',10,0),('1','152',169473,'BULK SALES','2020-12-24','2020-12-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 09:34:49','493','2020-12-27 09:35:09',10,0),('1','152',169474,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 09:49:14','493','2020-12-27 09:50:12',10,0),('1','152',169540,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 14:51:12','493','2020-12-27 14:51:37',10,0),('1','152',169555,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 17:08:02','493','2020-12-27 17:08:29',10,0),('1','152',169573,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-27 19:48:28','493','2020-12-27 19:49:10',10,0),('1','152',169774,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-28 19:58:42','493','2020-12-28 19:59:06',10,0),('1','152',169932,'BULK SALES','2020-12-27','2020-12-27 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-29 19:33:58','493','2020-12-29 19:34:20',10,0),('1','152',169934,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-29 19:43:54','493','2020-12-29 19:44:14',10,0),('1','152',170147,'BULK SALES','2020-12-28','2020-12-28 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-30 19:46:25','493','2020-12-30 19:46:51',10,0),('1','152',170148,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-30 19:55:18','493','2020-12-30 19:55:37',10,0),('1','152',170248,'BULK SALES','2020-12-30','2020-12-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-31 13:24:44','493','2020-12-31 13:25:09',10,0),('1','152',170250,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'493',0.00,0.00,'493','2020-12-31 13:37:28','493','2020-12-31 13:37:47',10,0),('1','152',170484,'BULK SALES','2020-12-30','2020-12-30 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-01 18:39:27','493','2021-01-01 18:39:50',10,0),('1','152',170485,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-01 18:51:41','493','2021-01-01 18:52:15',10,0),('1','152',170595,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-02 14:49:54','493','2021-01-02 14:50:19',10,0),('1','152',170599,'BULK SALES','2021-01-01','2021-01-01 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-03 19:54:45','493','2021-01-03 19:55:06',10,0),('1','152',170813,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-03 19:58:28','493','2021-01-03 19:58:51',10,0),('1','152',170814,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-03 20:05:57','493','2021-01-03 20:06:17',10,0),('1','152',170815,'BULK SALES','2021-01-03','2021-01-03 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-03 20:15:25','493','2021-01-03 20:15:48',10,0),('1','152',171177,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-05 16:06:10','493','2021-01-05 16:06:33',10,0),('1','152',171182,'BULK SALES','2021-01-04','2021-01-04 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-06 19:42:53','493','2021-01-06 19:43:10',10,0),('1','152',171381,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-06 19:53:25','493','2021-01-06 19:53:47',10,0),('1','152',171384,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-06 20:12:39','493','2021-01-06 20:13:00',10,0),('1','152',171602,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-08 07:57:07','493','2021-01-08 07:57:32',10,0),('1','152',171608,'BULK SALES','2021-01-06','2021-01-06 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-08 08:55:01','493','2021-01-08 08:58:51',10,0),('1','152',171674,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-08 13:07:31','493','2021-01-08 13:07:57',10,0),('1','152',171916,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-09 16:36:07','493','2021-01-09 16:37:27',10,0),('1','152',172083,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-10 19:30:52','493','2021-01-10 19:31:17',10,0),('1','152',172084,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-10 19:40:54','493','2021-01-10 19:41:23',10,0),('1','152',172368,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-12 12:08:33','493','2021-01-12 12:08:58',10,0),('1','152',172374,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-12 12:16:00','493','2021-01-12 12:16:21',10,0),('1','152',172376,'BULK SALES','2021-01-11','2021-01-11 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-12 12:23:18','493','2021-01-12 12:23:39',10,0),('1','152',172380,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-12 12:49:14','493','2021-01-12 12:49:35',10,0),('1','152',172670,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-13 16:15:24','493','2021-01-13 16:15:50',10,0),('1','152',172891,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-15 08:31:40','493','2021-01-15 08:31:59',10,0),('1','152',172893,'BULK SALES','2021-01-13','2021-01-13 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-15 08:55:42','493','2021-01-15 08:56:06',10,0),('1','152',172899,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-15 08:57:06','493','2021-01-15 08:58:46',10,0),('1','152',172900,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-15 09:06:31','493','2021-01-15 09:06:50',10,0),('1','152',173246,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-17 08:36:48','493','2021-01-17 08:37:12',10,0),('1','152',173248,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-17 08:47:20','493','2021-01-17 08:47:46',10,0),('1','152',173249,'BULK SALES','2021-01-16','2021-01-16 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-18 15:42:28','493','2021-01-18 15:44:30',10,0),('1','152',173551,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-18 15:49:59','493','2021-01-18 15:50:23',10,0),('1','152',173574,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-18 18:22:00','493','2021-01-18 18:22:35',10,0),('1','152',173697,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-19 13:41:45','493','2021-01-19 13:42:09',10,0),('1','152',173887,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-20 14:20:21','493','2021-01-20 14:20:40',10,0),('1','152',173892,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-20 14:30:32','493','2021-01-20 14:30:54',10,0),('1','152',174061,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-21 13:46:34','493','2021-01-21 13:47:31',10,0),('1','152',174080,'BULK SALES','2021-01-20','2021-01-20 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-22 13:38:43','493','2021-01-22 13:39:08',10,0),('1','152',174237,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-22 13:47:29','493','2021-01-22 13:47:56',10,0),('1','152',174465,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-23 17:02:42','493','2021-01-23 17:03:00',10,0),('1','152',174611,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-24 17:32:35','493','2021-01-24 17:32:59',10,0),('1','152',174643,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-24 20:00:12','493','2021-01-24 20:00:34',10,0),('1','152',174644,'BULK SALES','2021-01-24','2021-01-24 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-24 20:06:19','493','2021-01-24 20:06:39',10,0),('1','152',174854,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-26 07:03:27','493','2021-01-26 07:04:02',10,0),('1','152',174855,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-26 07:08:16','493','2021-01-26 07:08:39',10,0),('1','152',174976,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-26 14:44:07','493','2021-01-26 14:44:30',10,0),('1','152',174983,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-26 15:07:49','493','2021-01-26 15:08:08',10,0),('1','152',175250,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-28 07:00:47','493','2021-01-28 07:01:15',10,0),('1','152',175414,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-28 23:04:55','493','2021-01-28 23:05:30',10,0),('1','152',175415,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-28 23:13:07','493','2021-01-28 23:13:52',10,0),('1','152',175677,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-30 13:45:52','493','2021-01-30 13:46:11',10,0),('1','152',175681,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-30 17:02:34','493','2021-01-30 17:03:08',10,0),('1','152',175735,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-30 17:23:51','493','2021-01-30 17:24:17',10,0),('1','152',175908,'BULK SALES','2021-01-30','2021-01-30 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-31 19:03:05','493','2021-01-31 19:03:23',10,0),('1','152',175910,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'493',0.00,0.00,'493','2021-01-31 19:35:41','493','2021-01-31 19:36:11',10,0),('1','152',176077,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-01 16:29:34','493','2021-02-01 16:30:59',10,0),('1','152',177122,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-06 14:09:40','493','2021-02-06 14:10:10',10,0),('1','152',177127,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-06 14:35:04','493','2021-02-06 14:35:29',10,0),('1','152',177138,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-06 14:58:42','493','2021-02-06 14:59:05',10,0),('1','152',177150,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-06 15:43:31','493','2021-02-06 15:43:52',10,0),('1','152',177163,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-06 16:17:11','493','2021-02-06 16:17:30',10,0),('1','152',177410,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-07 19:04:20','493','2021-02-07 19:04:46',10,0),('1','152',177608,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-08 18:45:39','493','2021-02-08 18:46:01',10,0),('1','152',177872,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-09 19:25:50','493','2021-02-09 19:26:28',10,0),('1','152',177887,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'493',0.00,0.00,'493','2021-02-10 07:05:29','493','2021-02-10 07:06:06',10,0),('1','152',177891,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'493',0.00,0.00,'587','2021-02-10 20:25:00','587','2021-02-10 20:25:38',10,0),('1','152',178077,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-11 09:54:03','587','2021-02-11 09:54:26',10,0),('1','152',178131,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-11 19:57:54','587','2021-02-11 19:58:47',10,0),('1','152',178290,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-12 16:16:25','587','2021-02-12 16:16:46',10,0),('1','152',178440,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-12 20:19:13','587','2021-02-12 20:19:35',10,0),('1','152',178492,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-13 20:56:34','587','2021-02-13 20:57:20',10,0),('1','152',178718,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-14 13:42:18','587','2021-02-14 13:42:46',10,0),('1','152',178813,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-14 13:44:46','587','2021-02-14 13:45:15',10,0),('1','152',178814,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-14 20:02:09','587','2021-02-14 20:02:31',10,0),('1','152',178902,'Daily Shift ','2021-02-15','2021-02-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-15 11:22:35','587','2021-02-15 11:22:51',10,0),('1','152',179002,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-15 20:02:57','587','2021-02-15 20:03:22',10,0),('1','152',179138,'Daily Shift ','2021-02-16','2021-02-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-16 15:36:40','587','2021-02-16 15:36:58',10,0),('1','152',179329,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-16 20:27:38','587','2021-02-16 20:28:03',10,0),('1','152',179360,'Daily Shift ','2021-02-17','2021-02-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-17 16:50:57','587','2021-02-17 16:51:27',10,0),('1','152',179547,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-17 19:39:23','587','2021-02-17 19:39:40',10,0),('1','152',179564,'Daily Shift ','2021-02-18','2021-02-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-18 19:37:42','587','2021-02-18 19:38:23',10,0),('1','152',179770,'Daily Shift ','2021-02-19','2021-02-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-19 11:19:05','587','2021-02-19 11:19:22',10,0),('1','152',179871,'DAILY SHIFT29686','2021-02-19','2021-02-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-19 19:20:57','587','2021-02-19 21:50:41',10,0),('1','152',179985,'Daily Shift ','2021-02-20','2021-02-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-20 17:38:38','587','2021-02-20 17:39:08',10,0),('1','152',180152,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-20 19:39:29','587','2021-02-20 19:39:49',10,0),('1','152',180166,'Daily Shift ','2021-02-21','2021-02-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-21 17:22:55','587','2021-02-21 17:23:15',10,0),('1','152',180308,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-21 19:47:12','587','2021-02-21 19:47:40',10,0),('1','152',180334,'Daily Shift ','2021-02-22','2021-02-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-22 19:58:03','587','2021-02-22 19:58:25',10,0),('1','152',180571,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-23 08:49:09','587','2021-02-23 08:49:58',10,0),('1','152',180599,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-23 19:47:42','587','2021-02-23 19:49:18',10,0),('1','152',180729,'Daily Shift ','2021-02-24','2021-02-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-24 14:47:44','587','2021-02-24 14:48:51',10,0),('1','152',180910,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-24 19:44:40','587','2021-02-24 19:45:06',10,0),('1','152',180953,'Daily Shift ','2021-02-25','2021-02-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-25 18:31:57','587','2021-02-25 18:32:20',10,0),('1','152',181120,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-25 19:52:36','587','2021-02-25 19:53:03',10,0),('1','152',181126,'Daily Shift ','2021-02-26','2021-02-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-26 19:37:29','587','2021-02-27 03:10:53',10,0),('1','152',181333,'Daily Shift ','2021-02-27','2021-02-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-27 12:50:45','587','2021-02-27 12:51:17',10,0),('1','152',181450,'Daily Shift ','2021-02-27','2021-02-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-27 19:34:44','587','2021-02-27 19:35:07',10,0),('1','152',181520,'Daily Shift ','2021-02-28','2021-02-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-28 13:45:03','587','2021-02-28 13:46:07',10,0),('1','152',181642,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-02-28 19:18:35','587','2021-02-28 19:19:08',10,0),('1','152',181696,'Daily Shift ','2021-03-01','2021-03-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-01 16:32:24','587','2021-03-01 16:32:49',10,0),('1','152',181885,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-01 19:29:19','587','2021-03-01 19:29:42',10,0),('1','152',181898,'Daily Shift ','2021-03-02','2021-03-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-02 18:36:29','587','2021-03-02 18:37:28',10,0),('1','152',182100,'Daily Shift ','2021-03-03','2021-03-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-03 18:43:55','587','2021-03-04 05:24:52',10,0),('1','152',182299,'Daily Shift ','2021-03-04','2021-03-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-04 16:42:21','587','2021-03-04 16:42:44',10,0),('1','152',182475,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-04 20:07:48','587','2021-03-04 20:13:37',10,0),('1','152',182492,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-05 19:43:03','587','2021-03-05 19:43:25',10,0),('1','152',182679,'Daily Shift ','2021-03-06','2021-03-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-06 20:07:02','587','2021-03-06 20:07:29',10,0),('1','152',182829,'Daily Shift ','2021-03-07','2021-03-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-07 07:17:27','587','2021-03-07 07:18:19',10,0),('1','152',182852,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-07 20:11:54','587','2021-03-07 20:22:34',10,0),('1','152',182982,'Daily Shift ','2021-03-08','2021-03-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-08 08:40:27','587','2021-03-08 08:41:00',10,0),('1','152',183041,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-08 19:57:39','587','2021-03-08 19:58:04',10,0),('1','152',183205,'Daily Shift ','2021-03-09','2021-03-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-09 10:18:15','587','2021-03-09 10:18:37',10,0),('1','152',183273,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-09 20:11:57','587','2021-03-09 20:13:01',10,0),('1','152',183430,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-10 20:19:54','587','2021-03-10 20:27:50',10,0),('1','152',183642,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-11 19:53:50','587','2021-03-11 19:54:14',10,0),('1','152',183874,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-12 19:29:40','587','2021-03-12 19:50:43',10,0),('1','152',184071,'Daily Shift ','2021-03-13','2021-03-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-13 19:57:53','587','2021-03-13 19:58:40',10,0),('1','152',184259,'Daily Shift ','2021-03-14','2021-03-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-14 10:20:24','587','2021-03-14 10:21:14',10,0),('1','152',184340,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-14 18:57:42','587','2021-03-14 18:58:03',10,0),('1','152',184449,'Daily Shift ','2021-03-15','2021-03-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-15 19:35:53','587','2021-03-15 19:36:19',10,0),('1','152',184690,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-16 19:56:16','587','2021-03-16 19:57:50',10,0),('1','152',184876,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-17 19:37:04','587','2021-03-17 19:37:46',10,0),('1','152',185105,'Daily Shift ','2021-03-18','2021-03-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-18 18:00:09','587','2021-03-18 18:00:33',10,0),('1','152',185236,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-18 20:15:41','587','2021-03-18 20:16:00',10,0),('1','152',185255,'DAILY SHIFTp','2021-03-19','2021-03-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-19 19:20:22','587','2021-03-19 20:41:20',10,0),('1','152',185464,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-20 11:22:50','587','2021-03-20 11:23:10',10,0),('1','152',185539,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-20 20:14:34','587','2021-03-20 20:15:11',10,0),('1','152',185690,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-21 14:27:34','587','2021-03-21 14:28:12',10,0),('1','152',185803,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-21 19:47:46','587','2021-03-21 19:48:09',10,0),('1','152',185868,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-22 18:40:11','587','2021-03-22 18:41:00',10,0),('1','152',186051,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-22 19:57:45','587','2021-03-22 19:58:10',10,0),('1','152',186090,'Daily Shift ','2021-03-23','2021-03-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-23 21:00:06','587','2021-03-23 21:00:26',10,0),('1','152',186314,'Daily Shift ','2021-03-24','2021-03-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-24 18:10:43','587','2021-03-24 18:11:05',10,0),('1','152',186526,'BULK SALE','2021-03-25','2021-03-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-25 06:17:44','587','2021-03-25 06:18:06',10,0),('1','152',186528,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-25 20:52:30','587','2021-03-25 20:53:22',10,0),('1','152',186744,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-26 14:38:29','587','2021-03-26 14:38:55',10,0),('1','152',186884,'BULK SALES','2021-03-26','2021-03-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-26 14:42:50','587','2021-03-26 14:43:09',10,0),('1','152',186890,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-26 20:28:36','587','2021-03-26 20:29:08',10,0),('1','152',187016,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-27 20:27:42','587','2021-03-27 20:28:29',10,0),('1','152',187153,'Bulk sale ','2021-03-28','2021-03-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-28 05:59:05','587','2021-03-28 05:59:23',10,0),('1','152',187154,'Daily Shift ','2021-03-28','2021-03-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-28 20:51:40','587','2021-03-28 20:52:38',10,0),('1','152',187343,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-29 08:10:10','587','2021-03-29 08:10:37',10,0),('1','152',187406,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-29 20:02:13','587','2021-03-29 20:02:36',10,0),('1','152',187567,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-30 14:11:54','587','2021-03-30 14:12:22',10,0),('1','152',187725,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-30 20:40:15','587','2021-03-30 20:40:39',10,0),('1','152',187790,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-31 15:17:25','587','2021-03-31 15:17:44',10,0),('1','152',187952,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-31 15:58:47','587','2021-03-31 15:59:03',10,0),('1','152',187958,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-03-31 20:34:10','587','2021-03-31 20:34:36',10,0),('1','152',188032,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-01 16:52:43','587','2021-04-01 16:55:20',10,0),('1','152',188167,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-01 20:21:43','587','2021-04-01 20:23:05',10,0),('1','152',188201,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-02 17:45:36','587','2021-04-02 17:45:56',10,0),('1','152',188371,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-02 20:39:39','587','2021-04-02 20:40:05',10,0),('1','152',188434,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-03 16:07:25','587','2021-04-03 16:07:49',10,0),('1','152',188553,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-03 20:54:46','587','2021-04-03 20:55:13',10,0),('1','152',188596,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-04 19:35:34','587','2021-04-04 19:37:26',10,0),('1','152',188795,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-05 20:28:19','587','2021-04-05 20:29:43',10,0),('1','152',188998,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-06 19:58:04','587','2021-04-06 19:58:39',10,0),('1','152',189190,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-07 16:09:22','587','2021-04-07 16:09:46',10,0),('1','152',189357,'BULK SALES','2021-04-07','2021-04-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-07 16:15:55','587','2021-04-07 16:16:12',10,0),('1','152',189363,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-07 20:08:18','587','2021-04-07 20:08:43',10,0),('1','152',189400,'DAILY SHIFT ','2021-04-08','2021-04-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-08 16:48:36','587','2021-04-08 16:49:15',10,0),('1','152',189580,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-08 17:14:26','587','2021-04-08 17:14:48',10,0),('1','152',189581,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-08 19:49:51','587','2021-04-08 19:50:20',10,0),('1','152',189603,'DAILY SHIFT ','2021-04-09','2021-04-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-09 20:25:59','587','2021-04-09 20:28:13',10,0),('1','152',189803,'DAILY SHIFT ','2021-04-10','2021-04-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-10 19:59:44','587','2021-04-10 20:01:07',10,0),('1','152',190012,'DAILY SHIFT ','2021-04-10','2021-04-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-10 21:42:42','587','2021-04-10 21:43:03',10,0),('1','152',190019,'DAILY SHIFT ','2021-04-11','2021-04-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-11 18:38:36','587','2021-04-11 18:39:45',10,0),('1','152',190197,'DAILY SHIFT ','2021-04-12','2021-04-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-12 06:11:09','587','2021-04-12 06:11:30',10,0),('1','152',190210,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-12 10:42:25','587','2021-04-12 10:42:51',10,0),('1','152',190295,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-12 22:00:53','587','2021-04-12 22:01:30',10,0),('1','152',190420,'DAILY SHIFT ','2021-04-13','2021-04-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-13 10:06:41','587','2021-04-13 10:07:37',10,0),('1','152',190499,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-13 20:16:17','587','2021-04-13 20:16:49',10,0),('1','152',190656,'DAILY SHIFT ','2021-04-14','2021-04-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-14 10:42:25','587','2021-04-14 10:42:48',10,0),('1','152',190800,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-14 19:10:19','587','2021-04-14 19:11:17',10,0),('1','152',190874,'DAILY SHIFT ','2021-04-15','2021-04-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-15 11:59:27','587','2021-04-15 12:00:22',10,0),('1','152',190984,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-15 20:27:50','587','2021-04-15 20:29:20',10,0),('1','152',191058,'DAILY SHIFT ','2021-04-16','2021-04-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-16 14:52:50','587','2021-04-16 14:53:13',10,0),('1','152',191230,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-16 19:38:57','587','2021-04-16 19:39:32',10,0),('1','152',191285,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-17 19:29:55','587','2021-04-17 19:30:26',10,0),('1','152',191483,'DAILY SHIFT ','2021-04-18','2021-04-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-18 19:07:11','587','2021-04-18 19:07:41',10,0),('1','152',191695,'DAILY SHIFT ','2021-04-19','2021-04-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-19 19:56:03','587','2021-04-19 19:56:45',10,0),('1','152',191918,'DAILY SHIFT ','2021-04-20','2021-04-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-20 17:35:30','587','2021-04-20 17:35:54',10,0),('1','152',192128,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-21 19:59:34','587','2021-04-21 20:01:22',10,0),('1','152',192324,'DAILY SHIFT ','2021-04-22','2021-04-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-22 19:39:16','587','2021-04-22 19:39:48',10,0),('1','152',192550,'DAILY SHIFT ','2021-04-23','2021-04-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-23 20:49:51','587','2021-04-23 20:50:17',10,0),('1','152',192741,'DAILY SHIFT ','2021-04-24','2021-04-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-24 10:29:25','587','2021-04-24 10:30:05',10,0),('1','152',192816,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-24 18:55:51','587','2021-04-24 18:56:09',10,0),('1','152',192943,'DAILY SHIFT ','2021-04-25','2021-04-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-25 17:21:01','587','2021-04-25 17:21:35',10,0),('1','152',193166,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-26 20:16:09','587','2021-04-26 20:16:48',10,0),('1','152',193402,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-27 12:24:20','587','2021-04-27 12:25:00',10,0),('1','152',193511,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-27 12:31:04','587','2021-04-27 12:31:56',10,0),('1','152',193512,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-27 20:15:37','587','2021-04-27 20:16:15',10,0),('1','152',193619,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-28 19:37:32','587','2021-04-28 19:38:08',10,0),('1','152',193847,'BULK SALE','2021-04-29','2021-04-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-29 06:38:25','587','2021-04-29 06:38:45',10,0),('1','152',193862,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-29 09:03:44','587','2021-04-29 09:04:30',10,0),('1','152',193904,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-29 09:07:21','587','2021-04-29 09:07:43',10,0),('1','152',193909,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-29 19:59:07','587','2021-04-29 20:00:09',10,0),('1','152',194059,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-29 20:03:49','587','2021-04-29 20:04:09',10,0),('1','152',194078,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-30 14:05:09','587','2021-04-30 14:05:33',10,0),('1','152',194205,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-04-30 20:12:26','587','2021-04-30 20:12:43',10,0),('1','152',194287,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-01 08:21:59','587','2021-05-01 08:22:31',10,0),('1','152',194328,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-01 20:17:56','587','2021-05-01 20:18:17',10,0),('1','152',194486,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-02 19:40:33','587','2021-05-02 19:41:08',10,0),('1','152',194663,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-03 19:46:29','587','2021-05-03 19:47:29',10,0),('1','152',194960,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-04 15:35:23','587','2021-05-04 15:35:44',10,0),('1','152',195010,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-04 19:19:59','587','2021-05-04 19:20:19',10,0),('1','152',195071,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-05 17:35:26','587','2021-05-05 17:35:47',10,0),('1','152',195418,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-06 19:34:52','587','2021-05-06 19:35:14',10,0),('1','152',195507,'DAILY SHIFT ','2021-05-07','2021-05-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-07 16:40:39','587','2021-05-07 16:40:57',10,0),('1','152',195726,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-07 16:49:01','587','2021-05-07 16:49:22',10,0),('1','152',195731,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-07 19:55:23','587','2021-05-07 19:56:04',10,0),('1','152',195784,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-08 19:53:46','587','2021-05-08 19:54:17',10,0),('1','152',195994,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-09 09:38:02','587','2021-05-09 09:38:32',10,0),('1','152',196070,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-09 20:06:10','587','2021-05-09 20:06:35',10,0),('1','152',196218,'DAILY SHIFT ','2021-05-10','2021-05-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-10 16:14:41','587','2021-05-10 16:15:23',10,0),('1','152',196393,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-10 19:39:41','587','2021-05-10 19:40:11',10,0),('1','152',196450,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-11 19:26:59','587','2021-05-11 19:27:34',10,0),('1','152',196664,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-12 08:08:37','587','2021-05-12 08:09:19',10,0),('1','152',196708,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-12 20:18:11','587','2021-05-12 20:18:45',10,0),('1','152',196890,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-13 20:03:08','587','2021-05-13 20:03:27',10,0),('1','152',197028,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-14 12:52:15','587','2021-05-14 12:52:39',10,0),('1','152',197132,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-15 14:10:26','587','2021-05-15 14:11:37',10,0),('1','152',197226,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-15 20:19:45','587','2021-05-15 20:20:12',10,0),('1','152',197323,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-17 06:36:34','587','2021-05-17 06:36:57',10,0),('1','152',197519,'DAILY SHIFT ','2021-05-17','2021-05-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-17 20:46:46','587','2021-05-17 20:47:24',10,0),('1','152',197857,'DAILY SHIFT ','2021-05-18','2021-05-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-18 19:43:24','587','2021-05-18 19:43:58',10,0),('1','152',198097,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-18 20:09:19','587','2021-05-18 20:09:34',10,0),('1','152',198107,'DAILY SHIFT ','2021-05-19','2021-05-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-19 19:50:11','587','2021-05-19 19:50:29',10,0),('1','152',198350,'DAILY SHIFT ','2021-05-20','2021-05-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-20 19:56:30','587','2021-05-20 19:57:06',10,0),('1','152',198542,'BULK SALE','2021-05-20','2021-05-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-20 20:07:35','587','2021-05-20 20:07:55',10,0),('1','152',198544,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-20 20:11:44','587','2021-05-20 20:12:02',10,0),('1','152',198553,'DAILY SHIFT ','2021-05-21','2021-05-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-22 09:07:39','587','2021-05-22 09:08:10',10,0),('1','152',198835,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-22 16:52:39','587','2021-05-22 16:53:07',10,0),('1','152',198945,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-22 19:56:39','587','2021-05-22 19:57:02',10,0),('1','152',198970,'DAILY SHIFT ','2021-05-23','2021-05-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-23 22:45:27','587','2021-05-23 22:45:58',10,0),('1','152',199190,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-24 10:29:48','587','2021-05-24 10:30:21',10,0),('1','152',199356,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-24 19:56:12','587','2021-05-24 19:56:37',10,0),('1','152',199435,'DAILY SHIFT ','2021-05-25','2021-05-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-25 20:59:12','587','2021-05-25 20:59:35',10,0),('1','152',199638,'DAILY SHIFT ','2021-05-26','2021-05-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-27 04:36:16','587','2021-05-27 04:38:28',10,0),('1','152',199854,'DAILY SHIFT ','2021-05-27','2021-05-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-28 05:51:55','587','2021-05-28 05:52:56',10,0),('1','152',200088,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-28 09:01:59','587','2021-05-28 09:02:19',10,0),('1','152',200154,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-29 04:50:59','587','2021-05-29 04:51:27',10,0),('1','152',200282,'DAILY SHIFT ','2021-05-29','2021-05-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-29 16:13:34','587','2021-05-29 16:13:56',10,0),('1','152',200439,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-29 19:55:50','587','2021-05-29 19:56:13',10,0),('1','152',200479,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-30 23:35:10','587','2021-05-30 23:35:49',10,0),('1','152',200681,'DAILY SHIFT ','2021-05-31','2021-05-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-05-31 21:06:56','587','2021-05-31 21:09:05',10,0),('1','152',200904,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-01 11:14:43','587','2021-06-01 11:15:05',10,0),('1','152',201005,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-01 11:17:25','587','2021-06-01 11:17:46',10,0),('1','152',201009,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-01 22:16:35','587','2021-06-01 22:16:57',10,0),('1','152',201097,'DAILY SHIFT ','2021-06-02','2021-06-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-02 16:15:49','587','2021-06-02 16:16:22',10,0),('1','152',201288,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-02 21:41:56','587','2021-06-02 21:42:20',10,0),('1','152',201294,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-03 11:23:43','587','2021-06-03 11:24:16',10,0),('1','152',201404,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-04 07:06:47','587','2021-06-04 07:07:05',10,0),('1','152',201515,'DAILY SHIFT ','2021-06-04','2021-06-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-05 08:22:03','587','2021-06-05 08:22:26',10,0),('1','152',201804,'DAILY SHIFT ','2021-06-05','2021-06-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-05 23:08:30','587','2021-06-05 23:09:15',10,0),('1','152',202012,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-05 23:17:59','587','2021-06-05 23:18:24',10,0),('1','152',202014,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-05 23:34:55','587','2021-06-05 23:35:28',10,0),('1','152',202016,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-06 17:46:20','587','2021-06-06 17:46:55',10,0),('1','152',202174,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-06 22:32:50','587','2021-06-06 22:33:11',10,0),('1','152',202199,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-07 19:31:21','587','2021-06-07 19:32:05',10,0),('1','152',202413,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-08 19:47:48','587','2021-06-08 19:49:12',10,0),('1','152',202627,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-09 08:12:42','587','2021-06-09 08:13:07',10,0),('1','152',202687,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-09 20:48:39','587','2021-06-09 20:55:59',10,0),('1','152',202834,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-10 14:20:31','587','2021-06-10 14:21:08',10,0),('1','152',203021,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-10 20:44:34','587','2021-06-10 20:44:57',10,0),('1','152',203093,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-12 07:50:34','587','2021-06-12 07:51:45',10,0),('1','152',203336,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-12 20:12:08','587','2021-06-12 20:12:38',10,0),('1','152',203511,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-13 22:35:55','587','2021-06-14 04:15:32',10,0),('1','152',203713,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-14 17:00:41','587','2021-06-14 17:01:08',10,0),('1','152',203922,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-14 19:55:56','587','2021-06-14 19:56:14',10,0),('1','152',203938,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-14 20:01:58','587','2021-06-14 20:02:15',10,0),('1','152',203951,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-15 19:45:46','587','2021-06-15 19:47:13',10,0),('1','152',204174,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-16 07:55:16','587','2021-06-16 07:55:34',10,0),('1','152',204223,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-16 20:52:26','587','2021-06-16 20:53:00',10,0),('1','152',204381,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-17 13:01:38','587','2021-06-17 13:03:11',10,0),('1','152',204522,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-17 21:47:54','587','2021-06-17 21:48:31',10,0),('1','152',204600,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-19 07:15:25','587','2021-06-19 07:18:21',10,0),('1','152',204855,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-19 19:41:26','587','2021-06-19 19:42:15',10,0),('1','152',205027,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-20 16:19:40','587','2021-06-20 16:20:45',10,0),('1','152',205182,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-20 20:07:39','587','2021-06-20 20:07:58',10,0),('1','152',205214,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-21 11:00:56','587','2021-06-21 11:02:42',10,0),('1','152',205332,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-21 20:17:20','587','2021-06-21 20:17:48',10,0),('1','152',205471,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-22 12:57:23','587','2021-06-22 12:57:40',10,0),('1','152',205603,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-22 20:50:42','587','2021-06-22 20:51:17',10,0),('1','152',205711,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-23 20:32:15','587','2021-06-23 20:33:12',10,0),('1','152',205929,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-24 21:38:03','587','2021-06-24 21:40:22',10,0),('1','152',206129,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-25 10:53:48','587','2021-06-25 10:54:18',10,0),('1','152',206255,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-25 20:28:20','587','2021-06-25 20:28:54',10,0),('1','152',206347,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-26 21:11:33','587','2021-06-26 21:11:58',10,0),('1','152',206560,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-27 08:39:04','587','2021-06-27 08:39:41',10,0),('1','152',206612,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-27 20:53:05','587','2021-06-27 20:53:26',10,0),('1','152',206780,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-28 20:14:22','587','2021-06-28 20:15:17',10,0),('1','152',207011,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-29 20:12:39','587','2021-06-29 20:13:30',10,0),('1','152',207233,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-06-30 20:14:07','587','2021-06-30 20:15:24',10,0),('1','152',207468,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-01 13:59:23','587','2021-07-01 14:00:55',10,0),('1','152',207612,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-01 21:05:08','587','2021-07-01 21:06:00',10,0),('1','152',207690,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-02 09:21:17','587','2021-07-02 09:21:42',10,0),('1','152',207769,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-02 21:00:13','587','2021-07-02 21:01:51',10,0),('1','152',207891,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-03 20:43:31','587','2021-07-03 20:44:34',10,0),('1','152',208098,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-04 20:48:55','587','2021-07-04 20:49:43',10,0),('1','152',208312,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-05 20:21:31','587','2021-07-05 20:26:26',10,0),('1','152',208626,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-06 11:28:52','587','2021-07-06 11:29:20',10,0),('1','152',208684,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-06 20:38:25','587','2021-07-06 20:39:14',10,0),('1','152',208745,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-07 20:58:35','587','2021-07-07 20:59:23',10,0),('1','152',208975,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-08 20:06:47','587','2021-07-08 20:07:20',10,0),('1','152',209203,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-09 20:05:08','587','2021-07-09 20:06:05',10,0),('1','152',209424,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-10 16:56:15','587','2021-07-10 16:56:59',10,0),('1','152',209603,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-10 20:44:15','587','2021-07-10 20:44:40',10,0),('1','152',209630,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-11 22:33:21','587','2021-07-11 22:34:33',10,0),('1','152',209849,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-13 09:32:18','587','2021-07-13 09:34:47',10,0),('1','152',210173,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-13 22:44:17','587','2021-07-13 22:44:47',10,0),('1','152',210297,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-14 22:05:08','587','2021-07-14 22:05:54',10,0),('1','152',210513,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-15 17:27:40','587','2021-07-15 17:29:04',10,0),('1','152',210696,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-15 21:45:17','587','2021-07-15 21:45:55',10,0),('1','152',210715,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-16 21:33:36','587','2021-07-16 21:34:55',10,0),('1','152',210937,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-17 22:05:30','587','2021-07-17 22:06:51',10,0),('1','152',211160,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-18 21:44:29','587','2021-07-18 21:46:48',10,0),('1','152',211356,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-19 12:52:15','587','2021-07-19 12:55:38',10,0),('1','152',211510,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-19 22:29:04','587','2021-07-19 22:29:37',10,0),('1','152',211591,'DAILY SHIFT2','2021-07-20','2021-07-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-20 20:51:24','587','2021-07-20 20:53:25',10,0),('1','152',211768,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-21 20:46:51','587','2021-07-21 20:47:19',10,0),('1','152',211976,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-22 21:27:06','587','2021-07-22 21:28:03',10,0),('1','152',212216,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-23 22:02:05','587','2021-07-23 22:07:49',10,0),('1','152',212465,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-24 21:55:56','587','2021-07-24 21:58:45',10,0),('1','152',212656,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-25 09:01:32','587','2021-07-25 09:02:29',10,0),('1','152',212710,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-25 20:16:10','587','2021-07-25 20:18:26',10,0),('1','152',212856,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-26 21:16:08','587','2021-07-26 21:17:39',10,0),('1','152',213116,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-27 22:07:42','587','2021-07-27 22:11:13',10,0),('1','152',213374,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-28 22:06:40','587','2021-07-28 22:09:26',10,0),('1','152',213618,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-29 13:07:50','587','2021-07-29 13:08:45',10,0),('1','152',213754,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-29 21:12:57','587','2021-07-29 21:14:33',10,0),('1','152',213868,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-31 00:09:19','587','2021-07-31 04:01:05',10,0),('1','152',214083,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-07-31 20:31:11','587','2021-07-31 20:40:08',10,0),('1','152',214323,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-01 19:47:08','587','2021-08-01 19:51:26',10,0),('1','152',214550,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-02 17:06:44','587','2021-08-02 17:22:26',10,0),('1','152',214737,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-02 21:00:42','587','2021-08-02 21:01:52',10,0),('1','152',214762,'DAILY SHIFT ','2021-08-03','2021-08-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-04 06:47:04','587','2021-08-04 06:49:28',10,0),('1','152',215012,'DAILY SHIFT ','2021-08-04','2021-08-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-04 18:59:34','587','2021-08-04 19:01:49',10,0),('1','152',215215,'DAILY SHIFT ','2021-08-05','2021-08-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-05 20:33:12','587','2021-08-05 20:35:27',10,0),('1','152',215432,'DAILY SHIFT ','2021-08-06','2021-08-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-06 21:51:39','587','2021-08-06 21:58:23',10,0),('1','152',215664,'DAILY SHIFT ','2021-08-07','2021-08-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-08 05:36:23','587','2021-08-08 05:40:16',10,0),('1','152',215897,'DAILY SHIFT ','2021-08-08','2021-08-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-09 05:34:38','587','2021-08-09 05:37:26',10,0),('1','152',216091,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-10 05:06:38','587','2021-08-10 05:14:29',10,0),('1','152',216310,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-11 05:49:11','587','2021-08-11 05:52:15',10,0),('1','152',216547,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-11 13:44:49','587','2021-08-11 13:47:11',10,0),('1','152',216690,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-11 17:30:43','587','2021-08-11 17:31:29',10,0),('1','152',216754,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-12 06:02:25','587','2021-08-12 06:03:11',10,0),('1','152',216783,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-12 15:41:44','587','2021-08-13 04:02:30',10,0),('1','152',217005,'DAILY SHIFT ','2021-08-13','2021-08-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-13 04:22:43','587','2021-08-13 04:23:06',10,0),('1','152',217006,'DAILY SHIFT ','2021-08-13','2021-08-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-14 05:03:12','587','2021-08-14 05:07:29',10,0),('1','152',217262,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-14 22:02:38','587','2021-08-14 22:09:41',10,0),('1','152',217493,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-15 20:41:10','587','2021-08-15 20:45:23',10,0),('1','152',217702,'DAILY SHIFT ','2021-08-16','2021-08-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-17 07:01:55','587','2021-08-17 07:03:07',10,0),('1','152',217999,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-17 21:28:41','587','2021-08-17 21:34:27',10,0),('1','152',218206,'DAILY SHIFT ','2021-08-18','2021-08-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-18 20:57:26','587','2021-08-18 20:58:10',10,0),('1','152',218433,'DAILY SHIFT ','2021-08-19','2021-08-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-19 21:44:27','587','2021-08-20 05:59:15',10,0),('1','152',218673,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-20 21:22:36','587','2021-08-20 21:27:57',10,0),('1','152',218893,'DAILY SHIFT ','2021-08-21','2021-08-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-21 21:17:35','587','2021-08-21 21:19:35',10,0),('1','152',219113,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-22 16:27:29','587','2021-08-22 16:31:23',10,0),('1','152',219285,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-22 16:44:17','587','2021-08-22 16:44:39',10,0),('1','152',219286,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-23 06:31:42','587','2021-08-23 06:32:28',10,0),('1','152',219340,'DAILY SHIFT ','2021-08-23','2021-08-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-23 20:38:37','587','2021-08-23 20:43:16',10,0),('1','152',219576,'DAILY SHIFT ','2021-08-24','2021-08-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-25 05:14:12','587','2021-08-25 05:19:33',10,0),('1','152',219797,'DAILY SHIFT ','2021-08-25','2021-08-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-26 06:03:38','587','2021-08-26 06:11:21',10,0),('1','152',220036,'DAILY SHIFT ','2021-08-26','2021-08-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-26 20:51:08','587','2021-08-26 20:54:46',10,0),('1','152',220228,'DAILY SHIFT ','2021-08-27','2021-08-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-28 05:25:42','587','2021-08-28 05:30:28',10,0),('1','152',220456,'DAILY SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-28 12:27:55','587','2021-08-28 12:33:26',10,0),('1','152',220611,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-28 14:17:11','587','2021-08-28 14:17:33',10,0),('1','152',220612,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-29 05:19:55','587','2021-08-29 05:20:19',10,0),('1','152',220676,'DAILY SHIFT ','2021-08-29','2021-08-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-30 05:34:59','587','2021-08-30 05:40:51',10,0),('1','152',220898,'DAILY SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-08-31 05:18:00','587','2021-08-31 05:25:01',10,0),('1','152',221128,'DAILY SHIFTS','2021-08-31','2021-08-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-01 05:48:43','587','2021-09-01 05:53:16',10,0),('1','152',221383,'DAILY SHIFT ','2021-09-01','2021-09-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-02 05:09:20','587','2021-09-02 05:14:20',10,0),('1','152',221606,'DAILY SHIFT ','2021-09-02','2021-09-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-03 06:37:56','587','2021-09-03 06:45:14',10,0),('1','152',221838,'DAILY SHIFT ','2021-09-03','2021-09-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-04 06:46:06','587','2021-09-04 06:51:26',10,0),('1','152',222063,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-05 08:02:59','587','2021-09-05 08:04:43',10,0),('1','152',222299,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-05 22:10:05','587','2021-09-05 22:13:04',10,0),('1','152',222488,'DAILY SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-06 06:50:42','587','2021-09-06 06:51:09',10,0),('1','152',222512,'DAILY SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-07 04:42:00','587','2021-09-07 04:45:38',10,0),('1','152',222717,'DAILY SHIFT ','2021-09-07','2021-09-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-08 05:35:55','587','2021-09-08 05:37:49',10,0),('1','152',222936,'DAILY SHIFT ','2021-09-08','2021-09-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-08 14:03:14','587','2021-09-08 14:05:24',10,0),('1','152',223079,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-09 05:01:38','587','2021-09-09 05:02:42',10,0),('1','152',223164,'DAILY SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-09 17:27:40','587','2021-09-09 17:33:05',10,0),('1','152',223379,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-09 21:40:34','587','2021-09-09 21:45:59',10,0),('1','152',223406,'DAILY SHIFT ','2021-09-10','2021-09-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-10 17:37:01','587','2021-09-10 17:37:59',10,0),('1','152',223613,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-10 19:38:25','587','2021-09-10 19:39:06',10,0),('1','152',223626,'DAILY SHIFT ','2021-09-11','2021-09-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-12 06:13:53','587','2021-09-12 06:19:38',10,0),('1','152',223872,'DAILY SHIFT ','2021-09-12','2021-09-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-13 07:15:26','587','2021-09-13 07:18:38',10,0),('1','152',224097,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-14 05:12:53','587','2021-09-14 06:50:44',10,0),('1','152',224314,'DAILY SHIFT ','2021-09-14','2021-09-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-15 05:55:36','587','2021-09-15 05:59:30',10,0),('1','152',224523,'DAILY SHIFT ','2021-09-15','2021-09-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-16 06:23:04','587','2021-09-16 06:49:55',10,0),('1','152',224789,'DAILY SHIFT it','2021-09-16','2021-09-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-16 09:40:56','587','2021-09-16 09:41:33',10,0),('1','152',224842,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-16 09:53:05','587','2021-09-16 09:53:43',10,0),('1','152',224856,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-16 10:51:07','587','2021-09-16 10:51:44',10,0),('1','152',224874,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-17 06:03:28','587','2021-09-17 06:07:15',10,0),('1','152',225013,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-18 05:31:48','587','2021-09-18 05:46:56',10,0),('1','152',225256,'DAILY SHIFT ','2021-09-18','2021-09-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-19 06:40:58','587','2021-09-19 06:44:27',10,0),('1','152',225488,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-20 06:46:22','587','2021-09-20 06:51:30',10,0),('1','152',225709,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-21 05:31:37','587','2021-09-21 05:35:17',10,0),('1','152',225967,'DAILY SHIFT ','2021-09-21','2021-09-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-21 14:17:39','587','2021-09-21 14:21:26',10,0),('1','152',226142,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-21 14:39:54','587','2021-09-21 14:40:53',10,0),('1','152',226149,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-22 21:30:32','587','2021-09-22 21:34:33',10,0),('1','152',226458,'DAILY SHIFTS','2021-09-22','2021-09-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-22 22:16:45','587','2021-09-22 22:18:40',10,0),('1','152',226462,'DAILY SHIFTS','2021-09-23','2021-09-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-24 05:18:49','587','2021-09-24 05:21:31',10,0),('1','152',226719,'DAILY SHIFTS','2021-09-24','2021-09-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-25 05:26:41','587','2021-09-25 05:28:55',10,0),('1','152',226945,'DAILY SHIFTS','2021-09-25','2021-09-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-26 11:33:19','587','2021-09-26 11:37:37',10,0),('1','152',227268,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-26 19:17:29','587','2021-09-26 19:18:23',10,0),('1','152',227363,'DAILY SHIFTS','2021-09-27','2021-09-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-27 20:56:37','587','2021-09-27 20:59:32',10,0),('1','152',227596,'DAILY SHIFTS','2021-09-28','2021-09-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-29 05:42:14','587','2021-09-29 05:45:00',10,0),('1','152',227843,'DAILY SHIFTS','2021-09-29','2021-09-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-09-30 05:54:24','587','2021-09-30 05:55:15',10,0),('1','152',228111,'DAILY SHIFTS','2021-09-30','2021-09-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-01 05:35:08','587','2021-10-01 05:37:07',10,0),('1','152',228340,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-01 21:46:07','587','2021-10-01 21:47:05',10,0),('1','152',228525,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-03 05:29:38','587','2021-10-03 05:32:00',10,0),('1','152',228743,'DAILY SHIFTS','2021-10-03','2021-10-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-03 20:53:48','587','2021-10-03 20:56:49',10,0),('1','152',228924,'DAILY SHIFTS','2021-10-04','2021-10-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-04 21:30:44','587','2021-10-04 21:32:59',10,0),('1','152',229157,'DAILY SHIFTS3','2021-10-05','2021-10-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-05 19:57:12','587','2021-10-05 20:01:15',10,0),('1','152',229393,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-06 03:20:32','587','2021-10-06 03:21:16',10,0),('1','152',229400,'DAILY SHIFT ','2021-10-06','2021-10-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-06 05:28:49','587','2021-10-06 05:30:22',10,0),('1','152',229405,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-07 05:18:05','587','2021-10-07 05:21:41',10,0),('1','152',229651,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-08 05:20:27','587','2021-10-08 05:24:44',10,0),('1','152',229877,'DAILY SHIFTS ','2021-10-08','2021-10-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-09 07:13:17','587','2021-10-09 07:26:16',10,0),('1','152',230105,'DAILY SHIFTS','2021-10-09','2021-10-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-10 07:41:57','587','2021-10-10 07:43:27',10,0),('1','152',230312,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-10 13:57:25','587','2021-10-10 13:58:26',10,0),('1','152',230426,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-11 06:32:00','587','2021-10-11 06:33:37',10,0),('1','152',230531,'DAILY SHIFTS ','2021-10-11','2021-10-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-12 06:37:50','587','2021-10-12 06:59:18',10,0),('1','152',230799,'DAILY SHIFTS','2021-10-12','2021-10-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-13 07:39:42','587','2021-10-13 08:03:36',10,0),('1','152',231099,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-13 21:32:14','587','2021-10-13 21:33:07',10,0),('1','152',231357,'DAILY SHIFTS','2021-10-14','2021-10-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-15 05:43:40','587','2021-10-15 05:45:46',10,0),('1','152',231627,'DAILY SHIFTS','2021-10-15','2021-10-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-16 07:50:20','587','2021-10-16 08:18:00',10,0),('1','152',231931,'DAILY SHIFTS','2021-10-16','2021-10-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-16 12:34:48','587','2021-10-16 12:38:09',10,0),('1','152',231999,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-17 07:55:27','587','2021-10-17 07:56:53',10,0),('1','152',232128,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-18 14:51:41','587','2021-10-18 15:17:27',10,0),('1','152',232514,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-19 15:11:04','587','2021-10-19 15:13:38',10,0),('1','152',232751,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-20 15:42:24','587','2021-10-20 15:45:05',10,0),('1','152',233042,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-20 16:00:33','587','2021-10-20 16:01:31',10,0),('1','152',233047,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-21 11:10:18','587','2021-10-21 11:14:07',10,0),('1','152',233230,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-22 06:12:40','587','2021-10-22 06:14:01',10,0),('1','152',233375,'DAILY SHIFTS4','2021-10-22','2021-10-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-23 08:26:20','587','2021-10-23 08:32:37',10,0),('1','152',233660,'DAILY SHIFTS','2021-10-23','2021-10-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-24 14:48:11','587','2021-10-24 15:15:34',10,0),('1','152',233974,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-25 16:03:12','587','2021-10-25 16:10:23',10,0),('1','152',234243,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-25 16:24:08','587','2021-10-25 16:26:43',10,0),('1','152',234320,'DAILY SHIFTS','2021-10-26','2021-10-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-26 12:33:36','587','2021-10-26 12:44:45',10,0),('1','152',234456,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-27 08:09:20','587','2021-10-27 08:12:12',10,0),('1','152',234626,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-28 10:50:30','587','2021-10-28 10:55:35',10,0),('1','152',234945,'DAILY SHIFTS','2021-10-28','2021-10-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-29 11:26:36','587','2021-10-29 11:32:31',10,0),('1','152',235182,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-30 05:54:37','587','2021-10-30 05:55:39',10,0),('1','152',235360,'DAILY SHIFTS','2021-10-30','2021-10-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-31 05:47:52','587','2021-10-31 05:48:55',10,0),('1','152',235529,'DAILY SHIFTS','2021-10-31','2021-10-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-10-31 15:35:44','587','2021-10-31 15:36:48',10,0),('1','152',235682,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-01 07:40:46','587','2021-11-01 07:45:26',10,0),('1','152',235811,'DAILY SHIFTS','2021-11-01','2021-11-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-02 07:28:39','587','2021-11-02 07:30:44',10,0),('1','152',236066,'DAILY SHIFTS','2021-11-02','2021-11-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-02 20:38:30','587','2021-11-02 20:39:16',10,0),('1','152',236232,'DAILY SHIFTS','2021-11-03','2021-11-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-03 15:28:21','587','2021-11-03 15:30:48',10,0),('1','152',236421,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-04 07:56:09','587','2021-11-04 07:59:35',10,0),('1','152',236563,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-05 05:08:31','587','2021-11-05 05:09:13',10,0),('1','152',236719,'DAILY SHIFTS','2021-11-05','2021-11-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-05 21:31:38','587','2021-11-05 21:32:34',10,0),('1','152',236953,'DAILY SHIFTS','2021-11-06','2021-11-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-07 05:02:24','587','2021-11-07 05:03:10',10,0),('1','152',237154,'DAILY SHIFTS','2021-11-07','2021-11-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-07 19:13:39','587','2021-11-07 19:14:53',10,0),('1','152',237461,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-08 11:25:13','587','2021-11-08 11:25:48',10,0),('1','152',237487,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-08 20:33:47','587','2021-11-08 20:34:29',10,0),('1','152',237591,'DAILY SHIFTS','2021-11-09','2021-11-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-09 23:23:23','587','2021-11-09 23:24:06',10,0),('1','152',237857,'DAILY SHIFTS','2021-11-10','2021-11-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-11 08:04:09','587','2021-11-11 08:04:52',10,0),('1','152',238179,'DAILY SHIFTS','2021-11-11','2021-11-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-11 21:06:42','587','2021-11-11 21:07:19',10,0),('1','152',238342,'DAILY SHIFTS ya','2021-11-12','2021-11-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-12 21:45:37','587','2021-11-12 21:46:21',10,0),('1','152',238599,'DAILY SHIFTS','2021-11-13','2021-11-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-13 20:50:55','587','2021-11-13 20:51:54',10,0),('1','152',238819,'DAILY SHIFTS','2021-11-14','2021-11-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-14 10:44:22','587','2021-11-14 10:44:51',10,0),('1','152',238910,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-14 19:39:59','587','2021-11-14 19:40:35',10,0),('1','152',239047,'DAILY SHIFTS','2021-11-15','2021-11-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-15 21:17:04','587','2021-11-15 21:18:27',10,0),('1','152',239280,'DAILY SHIFTS','2021-11-16','2021-11-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-17 06:29:34','587','2021-11-17 06:30:47',10,0),('1','152',239540,'DAILY SHIFTS','2021-11-17','2021-11-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-18 04:49:16','587','2021-11-18 04:50:19',10,0),('1','152',239747,'DAILY SHIFTS','2021-11-18','2021-11-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-18 21:31:13','587','2021-11-18 21:33:14',10,0),('1','152',239971,'DAILY SHIFTS','2021-11-19','2021-11-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-20 06:38:33','587','2021-11-20 06:40:46',10,0),('1','152',240211,'DAILY SHIFTS','2021-11-20','2021-11-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-20 16:39:55','587','2021-11-20 16:42:26',10,0),('1','152',240392,'DAILY SHIFTS','2021-11-20','2021-11-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-20 19:39:01','587','2021-11-20 19:39:35',10,0),('1','152',240434,'DAILY SHIFTS','2021-11-21','2021-11-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-21 19:15:07','587','2021-11-21 19:15:52',10,0),('1','152',240677,'DAILY SHIFTS','2021-11-22','2021-11-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-22 17:58:48','587','2021-11-22 17:59:36',10,0),('1','152',240897,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-23 08:19:08','587','2021-11-23 08:19:42',10,0),('1','152',241027,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-23 22:02:34','587','2021-11-23 22:03:40',10,0),('1','152',241226,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-25 05:33:02','587','2021-11-25 05:33:34',10,0),('1','152',241480,'DAILY SHIFTS','2021-11-25','2021-11-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-25 20:14:24','587','2021-11-25 20:17:35',10,0),('1','152',241716,'DAILY SHIFTS','2021-11-26','2021-11-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-26 19:17:28','587','2021-11-26 19:19:06',10,0),('1','152',241961,'DAILY SHIFTS','2021-11-27','2021-11-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-27 19:38:16','587','2021-11-27 19:39:56',10,0),('1','152',242197,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-29 07:04:15','587','2021-11-29 07:04:53',10,0),('1','152',242473,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-29 07:18:19','587','2021-11-29 07:18:48',10,0),('1','152',242489,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-30 05:44:33','587','2021-11-30 05:45:40',10,0),('1','152',242671,'DAILY SHIFTS','2021-11-30','2021-11-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-11-30 19:45:27','587','2021-11-30 19:46:35',10,0),('1','152',242910,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-01 19:25:56','587','2021-12-01 19:36:28',10,0),('1','152',243135,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-02 21:01:57','587','2021-12-02 21:03:43',10,0),('1','152',243352,'DAILY SHIFTS','2021-12-03','2021-12-03 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-03 21:13:32','587','2021-12-03 21:14:25',10,0),('1','152',243579,'DAILY SHIFTS','2021-12-04','2021-12-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-04 10:37:48','587','2021-12-04 10:38:45',10,0),('1','152',243683,'DAILY SHIFTS','2021-12-04','2021-12-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-04 10:53:17','587','2021-12-04 10:53:45',10,0),('1','152',243689,'DAILY SHIFTS','2021-12-04','2021-12-04 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-04 20:28:53','587','2021-12-04 20:29:48',10,0),('1','152',243828,'DAILY SHIFTS','2021-12-05','2021-12-05 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-05 19:26:38','587','2021-12-05 19:27:46',10,0),('1','152',244040,'DAILY SHIFTS','2021-12-06','2021-12-06 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-06 19:07:32','587','2021-12-06 19:09:15',10,0),('1','152',244289,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-08 00:53:59','587','2021-12-08 00:55:18',10,0),('1','152',244519,'DAILY SHIFTS','2021-12-08','2021-12-08 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-08 19:35:06','587','2021-12-08 19:35:40',10,0),('1','152',244727,'DAILY SHIFTS','2021-12-09','2021-12-09 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-09 19:09:10','587','2021-12-09 19:09:45',10,0),('1','152',244962,'DAILY SHIFT\'S','2021-12-10','2021-12-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-10 11:38:09','587','2021-12-10 11:38:42',10,0),('1','152',245084,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-10 12:00:56','587','2021-12-10 12:01:32',10,0),('1','152',245092,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-10 19:32:46','587','2021-12-10 19:33:19',10,0),('1','152',245210,'DAILY SHIFTS','2021-12-11','2021-12-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-11 16:59:25','587','2021-12-11 17:00:45',10,0),('1','152',245366,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-11 19:20:59','587','2021-12-11 19:21:33',10,0),('1','152',245394,'DAILY SHIFTS','2021-12-11','2021-12-11 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-11 20:02:16','587','2021-12-11 20:02:45',10,0),('1','152',245486,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-13 06:22:10','587','2021-12-13 06:22:52',10,0),('1','152',245685,'DAILY SHIFTS','2021-12-13','2021-12-13 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-13 19:42:58','587','2021-12-13 19:43:38',10,0),('1','152',245923,'DAILY SHIFTS','2021-12-14','2021-12-14 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-14 19:37:49','587','2021-12-14 19:38:24',10,0),('1','152',246177,'DAILY SHIFT\'S','2021-12-15','2021-12-15 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-15 21:58:13','587','2021-12-15 21:58:58',10,0),('1','152',246442,'DAILY SHIFTS','2021-12-16','2021-12-16 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-16 20:29:55','587','2021-12-16 20:30:43',10,0),('1','152',246700,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-17 18:46:39','587','2021-12-17 18:47:09',10,0),('1','152',246970,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-18 19:00:40','587','2021-12-18 19:01:10',10,0),('1','152',247178,'DAILY SHIFTS','2021-12-19','2021-12-19 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-19 18:40:45','587','2021-12-19 18:41:46',10,0),('1','152',247381,'DAILY SHIFTS','2021-12-20','2021-12-20 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-20 20:33:57','587','2021-12-20 20:34:41',10,0),('1','152',247642,'DAILY SHIFTS','2021-12-21','2021-12-21 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-22 06:47:28','587','2021-12-22 06:48:34',10,0),('1','152',247933,'DAILY SHIFTS','2021-12-22','2021-12-22 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-22 19:49:10','587','2021-12-22 19:50:52',10,0),('1','152',248141,'DAILY SHIFTS','2021-12-23','2021-12-23 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-23 19:32:27','587','2021-12-23 19:33:03',10,0),('1','152',248449,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-24 07:52:01','587','2021-12-24 07:52:31',10,0),('1','152',248461,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-24 20:31:36','587','2021-12-24 20:32:07',10,0),('1','152',248649,'DAILY SHIFTS ','2021-12-25','2021-12-25 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-25 19:35:48','587','2021-12-25 19:36:43',10,0),('1','152',248880,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-26 19:39:30','587','2021-12-26 19:39:56',10,0),('1','152',249100,'DAILY SHIFTS','2021-12-27','2021-12-27 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-27 19:10:42','587','2021-12-27 19:11:18',10,0),('1','152',249360,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-28 19:16:36','587','2021-12-28 19:17:16',10,0),('1','152',249582,'DAILY SHIFTS','2021-12-29','2021-12-29 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-30 03:06:31','587','2021-12-30 03:06:58',10,0),('1','152',249835,'DAILY SHIFTS','2021-12-30','2021-12-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-30 12:22:32','587','2021-12-30 12:23:08',10,0),('1','152',249978,'DAILY SHIFT\'S me','2021-12-30','2021-12-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-30 12:59:48','587','2021-12-30 13:00:13',10,0),('1','152',250010,'DAILY SHIFTS','2021-12-30','2021-12-30 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-30 20:34:14','587','2021-12-30 20:34:45',10,0),('1','152',250083,'DAILY SHIFTS','2021-12-31','2021-12-31 00:00:00',NULL,'587',0.00,0.00,'587','2021-12-31 19:28:13','587','2021-12-31 19:29:19',10,0),('1','152',250326,'DAILY SHIFTS','2022-01-01','2022-01-01 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-02 06:54:04','587','2022-01-02 06:55:02',10,0),('1','152',250579,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-02 19:42:07','587','2022-01-02 19:42:52',10,0),('1','152',250805,'DAILY SHIFTS','2022-01-03','2022-01-03 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-03 19:20:39','587','2022-01-03 19:21:08',10,0),('1','152',251018,'DAILY SHIFTS','2022-01-04','2022-01-04 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-04 15:54:15','587','2022-01-04 15:54:44',10,0),('1','152',251216,'DAILY SHIFTS','2022-01-04','2022-01-04 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-04 18:14:53','587','2022-01-04 18:15:23',10,0),('1','152',251227,'DAILY SHIFT\'S','2022-01-04','2022-01-04 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-04 19:28:05','587','2022-01-04 19:28:40',10,0),('1','152',251259,'DAILY SHIFTS','2022-01-05','2022-01-05 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-05 21:41:37','587','2022-01-05 21:42:28',10,0),('1','152',251510,'DAILY SHIFTS','2022-01-06','2022-01-06 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-06 20:31:43','587','2022-01-06 20:32:35',10,0),('1','152',251760,'DAILY SHIFTS','2022-01-07','2022-01-07 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-07 21:11:48','587','2022-01-07 21:12:49',10,0),('1','152',251978,'DAILY SHIFTS','2022-01-08','2022-01-08 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-09 09:37:16','587','2022-01-09 09:39:29',10,0),('1','152',252289,'DAILY SHIFTS','2022-01-09','2022-01-09 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-09 20:56:05','587','2022-01-09 20:56:38',10,0),('1','152',252462,'DAILY SHIFTS','2022-01-10','2022-01-10 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-10 14:37:51','587','2022-01-10 14:38:22',10,0),('1','152',252620,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-10 15:03:40','587','2022-01-10 15:04:20',10,0),('1','152',252638,'DAILY SHIFTS','2022-01-10','2022-01-10 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-11 07:28:12','587','2022-01-11 07:29:15',10,0),('1','152',252723,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-12 06:28:24','587','2022-01-12 06:34:47',10,0),('1','152',252960,'DAILY SHIFTS','2022-01-12','2022-01-12 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-12 20:34:44','587','2022-01-12 20:36:27',10,0),('1','152',253218,'DAILY SHIFTS','2022-01-13','2022-01-13 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-13 21:04:31','587','2022-01-13 21:07:15',10,0),('1','152',253466,'DAILY SHIFTS','2022-01-14','2022-01-14 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-14 20:39:07','587','2022-01-14 20:39:37',10,0),('1','152',253701,'DAILY SHIFTS','2022-01-15','2022-01-15 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-15 22:27:29','587','2022-01-15 22:35:31',10,0),('1','152',253956,'DAILY SHIFTS','2022-01-16','2022-01-16 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-16 20:23:44','587','2022-01-16 20:26:19',10,0),('1','152',254146,'DAILY SHIFTS','2022-01-16','2022-01-16 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-17 05:30:43','587','2022-01-17 05:31:11',10,0),('1','152',254178,'DAILY SHIFTS','2022-01-17','2022-01-17 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-18 06:23:40','587','2022-01-18 06:28:47',10,0),('1','152',254456,'DAILY SHIFTS','2022-01-18','2022-01-18 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-19 06:52:58','587','2022-01-19 06:57:18',10,0),('1','152',254695,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-20 07:19:08','587','2022-01-20 07:20:26',10,0),('1','152',254962,'DAILY SHIFTS','2022-01-20','2022-01-20 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-21 00:28:34','587','2022-01-21 00:35:46',10,0),('1','152',255189,'DAILY SHIFTS','2022-01-21','2022-01-21 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-21 23:29:46','587','2022-01-21 23:33:37',10,0),('1','152',255453,'DAILY SHIFTS','2022-01-22','2022-01-22 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-22 16:40:02','587','2022-01-22 16:43:17',10,0),('1','152',255629,'DAILY SHIFTS','2022-01-22','2022-01-22 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-22 17:04:16','587','2022-01-22 17:05:15',10,0),('1','152',255637,'DAILY SHIFTS','2022-01-22','2022-01-22 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-22 23:06:56','587','2022-01-22 23:10:00',10,0),('1','152',255715,'DAILY','2022-01-23','2022-01-23 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-23 22:02:44','587','2022-01-23 22:05:57',10,0),('1','152',255945,'DAILY SHIFT\'S','2022-01-24','2022-01-24 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-24 20:34:44','587','2022-01-24 21:15:31',10,0),('1','152',256204,'DAILY SHIFTS','2022-01-25','2022-01-25 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-25 22:43:50','587','2022-01-25 22:49:26',10,0),('1','152',256477,'DAILY SHIFTS','2022-01-26','2022-01-26 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-26 22:16:45','587','2022-01-27 05:32:24',10,0),('1','152',256709,'DAILY SHIFTS ','2022-01-27','2022-01-27 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-27 21:43:20','587','2022-01-27 21:53:23',10,0),('1','152',256954,'DAILY SHIFTS','2022-01-28','2022-01-28 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-28 17:46:20','587','2022-01-28 17:50:01',10,0),('1','152',257168,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-28 20:56:32','587','2022-01-28 21:01:28',10,0),('1','152',257248,'DAILY SHIFTS ','2022-01-29','2022-01-29 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-29 21:45:27','587','2022-01-29 21:52:59',10,0),('1','152',257476,'DAILY SHIFTS','2022-01-30','2022-01-30 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-30 18:54:42','587','2022-01-30 18:56:44',10,0),('1','152',257477,'DAILY','2022-01-31','2022-01-31 00:00:00',NULL,'587',0.00,0.00,'587','2022-01-31 21:18:10','587','2022-01-31 21:18:41',10,0),('1','152',257478,'DAILY SHIFTS','2022-02-01','2022-02-01 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-01 20:35:21','587','2022-02-01 20:35:44',10,0),('1','152',257479,'DAILY','2022-02-02','2022-02-02 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-02 12:48:03','587','2022-02-02 12:48:26',10,0),('1','152',257480,'DAILY SHIFTS','2022-02-02','2022-02-02 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-02 13:53:30','587','2022-02-02 13:53:52',10,0),('1','152',257481,'DAILY SHIFTS','2022-02-02','2022-02-02 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-03 06:43:41','587','2022-02-03 06:44:37',10,0),('1','152',257482,'DAILY SHIFTS','2022-02-03','2022-02-03 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-04 00:45:16','587','2022-02-04 00:45:36',10,0),('1','152',257483,'DAILY SHIFTS','2022-02-04','2022-02-04 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-04 22:14:09','587','2022-02-04 22:14:38',10,0),('1','152',257484,'DAILY SHIFTS','2022-02-05','2022-02-05 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-05 20:57:15','587','2022-02-05 20:57:40',10,0),('1','152',257485,'DAILY SHIFTS','2022-02-06','2022-02-06 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-07 09:30:09','587','2022-02-07 09:30:38',10,0),('1','152',257486,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-07 09:36:58','587','2022-02-07 09:37:19',10,0),('1','152',257487,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-08 08:11:23','587','2022-02-08 08:11:54',10,0),('1','152',257488,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-08 21:59:37','587','2022-02-08 22:00:04',10,0),('1','152',257489,'DAILY SHIFTS','2022-02-09','2022-02-09 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-09 21:53:02','587','2022-02-09 21:53:35',10,0),('1','152',257490,'DAILY SHIFTS','2022-02-10','2022-02-10 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-10 21:30:45','587','2022-02-10 21:31:18',10,0),('1','152',257491,'DAILY SHIFTS','2022-02-11','2022-02-11 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-11 20:34:38','587','2022-02-11 20:35:14',10,0),('1','152',257492,'DAILY SHIFTS','2022-02-12','2022-02-12 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-12 20:44:14','587','2022-02-12 20:44:42',10,0),('1','152',257493,'DAILY SHIFTS','2022-02-13','2022-02-13 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-13 09:29:33','587','2022-02-13 09:30:09',10,0),('1','152',257494,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-13 09:38:17','587','2022-02-13 09:38:37',10,0),('1','152',257495,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-13 20:43:35','587','2022-02-13 20:44:28',10,0),('1','152',257496,'DAILY SHIFTS','2022-02-14','2022-02-14 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-14 22:02:36','587','2022-02-14 22:03:07',10,0),('1','152',257497,'DAILY SHIFTS','2022-02-15','2022-02-15 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-15 23:01:36','587','2022-02-15 23:02:03',10,0),('1','152',257498,'DAILY SHIFTS','2022-02-16','2022-02-16 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-16 20:49:13','587','2022-02-16 20:49:41',10,0),('1','152',257499,'DAILY SHIFTS','2022-02-17','2022-02-17 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-17 20:35:19','587','2022-02-17 20:35:42',10,0),('1','152',257500,'DAILY SHIFTS','2022-02-18','2022-02-18 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-18 21:16:02','587','2022-02-18 21:16:32',10,0),('1','152',257501,'DAILY SHIFTS','2022-02-19','2022-02-19 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-19 18:19:08','587','2022-02-19 18:19:30',10,0),('1','152',257502,'DAILY SHIFTS','2022-02-19','2022-02-19 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-19 18:26:31','587','2022-02-19 18:26:56',10,0),('1','152',257503,'DAILY SHIFTS','2022-02-19','2022-02-19 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-19 22:05:36','587','2022-02-19 22:07:04',10,0),('1','152',257504,'DAILY SHIFTS','2022-02-20','2022-02-20 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-20 20:45:21','587','2022-02-20 20:47:48',10,0),('1','152',257505,'DAILY SHIFTS','2022-02-21','2022-02-21 00:00:00',NULL,'587',0.00,0.00,'587','2022-02-21 20:32:01','587','2022-02-21 20:32:28',10,0),('1','152',257506,'DAILY SHIFTS','2022-02-22','2022-02-22 06:17:42','2022-02-23 06:17:42','587',0.00,0.00,'587','2022-02-22 20:33:31','587','2022-02-22 20:34:00',10,0),('1','152',257507,'DAILY SHIFTS','2022-02-23','2022-02-23 06:36:09','2022-02-24 06:36:09','587',0.00,0.00,'587','2022-02-23 20:39:29','587','2022-02-23 20:39:57',10,0),('1','152',257508,'DAILY SHIFTS','2022-02-24','2022-02-24 06:30:53','2022-02-25 06:30:53','587',0.00,0.00,'587','2022-02-24 21:25:55','587','2022-02-24 21:26:20',10,0),('1','152',257509,'DAILY SHIFTS','2022-02-25','2022-02-25 06:20:53','2022-02-26 06:20:53','587',0.00,0.00,'587','2022-02-25 21:09:17','587','2022-02-25 21:09:43',10,0),('1','152',257510,'DAILY','2022-02-26','2022-02-26 10:07:06','2022-02-27 10:07:06','587',0.00,0.00,'587','2022-02-26 14:39:46','587','2022-02-26 14:40:18',10,0),('1','152',257511,'DAILY SHIFT','2022-02-26','2022-02-26 14:41:40','2022-02-27 14:41:40','587',0.00,0.00,'587','2022-02-26 14:48:05','587','2022-02-26 14:48:35',10,0),('1','152',257512,'DAILY SHIFT','2022-02-26','2022-02-26 14:58:00','2022-02-27 14:58:00','587',0.00,0.00,'587','2022-02-26 20:55:55','587','2022-02-26 20:56:26',10,0),('1','152',257513,'DAILY SHIFTS','2022-02-27','2022-02-27 06:09:25','2022-02-28 06:09:25','587',0.00,0.00,'587','2022-02-27 21:00:40','587','2022-02-27 21:01:13',10,0),('1','152',257514,'DAILY','2022-02-28','2022-02-28 07:15:27','2022-03-01 07:15:27','587',0.00,0.00,'587','2022-02-28 21:29:01','587','2022-02-28 21:29:29',10,0),('1','152',257515,'DAILY SHIFTS','2022-03-01','2022-03-01 06:13:43','2022-03-02 06:13:43','587',0.00,0.00,'587','2022-03-01 20:37:17','587','2022-03-01 20:37:44',10,0),('1','152',257516,'DAILY','2022-03-02','2022-03-02 07:10:41','2022-03-03 07:10:41','587',0.00,0.00,'587','2022-03-02 21:18:54','587','2022-03-02 21:19:24',10,0),('1','152',257517,'DAILY SHIFTS','2022-03-03','2022-03-03 06:15:27','2022-03-04 06:15:27','587',0.00,0.00,'587','2022-03-03 23:38:11','587','2022-03-03 23:38:37',10,0),('1','152',257518,'DAILY SHIFTS','2022-03-04','2022-03-04 06:17:23','2022-03-05 06:17:23','587',0.00,0.00,'587','2022-03-04 11:38:59','587','2022-03-04 11:39:29',10,0),('1','152',257519,'DAILY SHIFTS','2022-03-04','2022-03-04 11:41:10','2022-03-05 11:41:10','587',0.00,0.00,'587','2022-03-04 11:47:04','587','2022-03-04 11:47:29',10,0),('1','152',257520,'DAILY SHIFTS','2022-03-04','2022-03-04 12:02:29','2022-03-05 12:02:29','587',0.00,0.00,'587','2022-03-04 21:11:30','587','2022-03-04 21:12:06',10,0),('1','152',257521,'DAILY SHIFTS','2022-03-05','2022-03-05 06:20:22','2022-03-06 06:20:22','587',0.00,0.00,'587','2022-03-05 20:45:32','587','2022-03-05 22:15:51',10,0),('1','152',257522,'DAILY','2022-03-06','2022-03-06 07:10:37','2022-03-07 07:10:37','587',0.00,0.00,'587','2022-03-06 21:12:37','587','2022-03-06 21:13:02',10,0),('1','152',257523,'DAILY','2022-03-07','2022-03-07 07:11:52','2022-03-08 07:11:52','587',0.00,0.00,'587','2022-03-07 22:26:51','587','2022-03-07 22:28:10',10,0),('1','152',257524,'DAILY SHIFTS','2022-03-08','2022-03-08 05:43:54','2022-03-09 05:43:54','587',0.00,0.00,'587','2022-03-08 20:51:09','587','2022-03-08 20:51:43',10,0),('1','152',257525,'DAILY','2022-03-09','2022-03-09 06:56:35','2022-03-10 06:56:35','587',0.00,0.00,'587','2022-03-10 07:09:52','587','2022-03-10 07:11:18',10,0),('1','152',257526,'DAILY SHIFT','2022-03-10','2022-03-10 07:11:51','2022-03-11 07:11:51','587',0.00,0.00,'587','2022-03-10 09:37:29','587','2022-03-10 09:37:51',10,0),('1','152',257527,'DAILY SHIFT','2022-03-10','2022-03-10 09:44:51','2022-03-11 09:44:51','587',0.00,0.00,'587','2022-03-10 09:56:08','587','2022-03-10 09:56:46',10,0),('1','152',257528,'DAILY SHIFT','2022-03-10','2022-03-10 10:03:24','2022-03-11 10:03:24','587',0.00,0.00,'587','2022-03-10 20:34:53','587','2022-03-10 20:35:17',10,0),('1','152',257529,'DAILY','2022-03-11','2022-03-11 07:19:38','2022-03-12 07:19:38','587',0.00,0.00,'587','2022-03-11 20:09:38','587','2022-03-11 20:10:20',10,0),('1','152',257530,'DAILY SHIFTS','2022-03-12','2022-03-12 06:38:32','2022-03-13 06:38:32','587',0.00,0.00,'587','2022-03-12 20:51:36','587','2022-03-12 20:51:59',10,0),('1','152',257531,'DAILY','2022-03-13','2022-03-13 06:55:12','2022-03-14 06:55:12','587',0.00,0.00,'587','2022-03-13 20:38:21','587','2022-03-13 20:39:18',10,0),('1','152',257532,'DAILY SHIFTS','2022-03-14','2022-03-14 05:10:46','2022-03-15 05:10:46','587',0.00,0.00,'587','2022-03-14 20:41:31','587','2022-03-14 20:42:12',10,0),('1','152',257533,'DAILY SHIFTS','2022-03-15','2022-03-15 06:21:09','2022-03-16 06:21:09','587',0.00,0.00,'587','2022-03-15 20:29:11','587','2022-03-15 20:34:33',10,0),('1','152',257534,'DAILY SHIFTS','2022-03-16','2022-03-16 06:06:05','2022-03-17 06:06:05','587',0.00,0.00,'587','2022-03-16 20:37:19','587','2022-03-16 20:37:49',10,0),('1','152',257535,'DAILY SHIFTS','2022-03-17','2022-03-17 06:02:42','2022-03-18 06:02:42','587',0.00,0.00,'587','2022-03-17 15:13:28','587','2022-03-17 15:14:18',10,0),('1','152',257536,'DAILY SHIFTS','2022-03-17','2022-03-17 15:19:41','2022-03-18 15:19:41','587',0.00,0.00,'587','2022-03-17 15:29:11','587','2022-03-17 15:29:31',10,0),('1','152',257537,'DAILY SHIFTS','2022-03-17','2022-03-17 15:35:35','2022-03-18 15:35:35','587',0.00,0.00,'587','2022-03-17 21:47:37','587','2022-03-17 21:48:19',10,0),('1','152',257538,'DAILY SHIFTS','2022-03-18','2022-03-18 06:28:40','2022-03-19 06:28:40','587',0.00,0.00,'587','2022-03-18 20:51:03','587','2022-03-18 20:51:33',10,0),('1','152',257539,'DAILY SHIFTS','2022-03-19','2022-03-19 06:46:31','2022-03-20 06:46:31','587',0.00,0.00,'587','2022-03-19 21:01:40','587','2022-03-19 21:03:05',10,0),('1','152',257540,'DAILY SHIFTS','2022-03-20','2022-03-20 06:15:55','2022-03-21 06:15:55','587',0.00,0.00,'587','2022-03-20 20:45:59','587','2022-03-20 20:46:34',10,0),('1','152',257541,'DAILY SHIFTS','2022-03-21','2022-03-21 05:12:01','2022-03-22 05:12:01','587',0.00,0.00,'587','2022-03-21 20:31:40','587','2022-03-21 20:32:23',10,0),('1','152',257542,'DAILY SHIFTS','2022-03-22','2022-03-22 05:15:13','2022-03-23 05:15:13','587',0.00,0.00,'587','2022-03-22 20:32:58','587','2022-03-22 20:33:32',10,0),('1','152',257543,'DAILY SHIFT','2022-03-23','2022-03-23 06:56:42','2022-03-24 06:56:42','587',0.00,0.00,'587','2022-03-23 21:28:13','587','2022-03-23 21:28:59',10,0),('1','152',257544,'DAILY SHIFTS','2022-03-24','2022-03-24 05:59:48','2022-03-25 05:59:48','587',0.00,0.00,'587','2022-03-24 20:35:53','587','2022-03-24 20:36:42',10,0),('1','152',257545,'DAILY SHIFTS ','2022-03-25','2022-03-25 06:47:16','2022-03-26 06:47:16','587',0.00,0.00,'587','2022-03-25 12:31:23','587','2022-03-25 12:31:51',10,0),('1','152',257546,'DAILY SHIFTS','2022-03-25','2022-03-25 12:42:52','2022-03-26 12:42:52','587',0.00,0.00,'587','2022-03-25 20:47:12','587','2022-03-25 20:47:38',10,0),('1','152',257547,'DAILY','2022-03-26','2022-03-26 10:05:05','2022-03-27 10:05:05','587',0.00,0.00,'587','2022-03-26 20:21:34','587','2022-03-26 20:22:18',10,0),('1','152',257548,'DAILY SHIFTS','2022-03-27','2022-03-27 05:59:19','2022-03-28 05:59:19','587',0.00,0.00,'587','2022-03-27 20:14:07','587','2022-03-27 20:14:33',10,0),('1','152',257549,'DAILY SHIFTS','2022-03-28','2022-03-28 06:03:26','2022-03-29 06:03:26','587',0.00,0.00,'587','2022-03-28 20:45:36','587','2022-03-28 20:46:18',10,0),('1','152',257550,'DAILY SHIFTS','2022-03-29','2022-03-29 05:56:15','2022-03-30 05:56:15','587',0.00,0.00,'587','2022-03-29 20:19:53','587','2022-03-29 20:20:18',10,0),('1','152',257551,'DAILY SHIFTS','2022-03-30','2022-03-30 05:51:31','2022-03-31 05:51:31','587',0.00,0.00,'587','2022-03-30 20:43:47','587','2022-03-30 20:44:34',10,0),('1','152',257552,'DAILY SHIFTS','2022-03-31','2022-03-31 05:56:29','2022-04-01 05:56:29','587',0.00,0.00,'587','2022-03-31 18:39:34','587','2022-03-31 18:39:55',10,0),('1','152',257553,'DAILY SHIFTS','2022-03-31','2022-03-31 18:41:06','2022-04-01 18:41:06','587',0.00,0.00,'587','2022-03-31 18:46:08','587','2022-03-31 18:46:28',10,0),('1','152',257554,'DAILY SHIFTS','2022-03-31','2022-03-31 19:06:53','2022-04-01 19:06:53','587',0.00,0.00,'587','2022-03-31 20:46:28','587','2022-03-31 20:46:48',10,0),('1','152',257555,'DAILY SHIFTS ','2022-04-01','2022-04-01 06:38:01','2022-04-02 06:38:01','587',0.00,0.00,'587','2022-04-01 21:34:20','587','2022-04-01 21:35:24',10,0),('1','152',257556,'DAILY SHIFTS ','2022-04-02','2022-04-02 04:47:51','2022-04-03 04:47:51','587',0.00,0.00,'587','2022-04-02 23:48:55','587','2022-04-02 23:49:22',10,0),('1','152',257557,'DAILY SHIFTS','2022-04-03','2022-04-03 05:50:03','2022-04-04 05:50:03','587',0.00,0.00,'587','2022-04-03 20:14:43','587','2022-04-03 20:15:53',10,0),('1','152',257558,'DAILY SHIFT','2022-04-03','2022-04-03 20:19:31','2022-04-04 20:19:31','587',0.00,0.00,'587','2022-04-03 20:24:03','587','2022-04-03 20:24:29',10,0),('1','152',257559,'DAILY SHIFT','2022-04-03','2022-04-03 20:56:33','2022-04-04 20:56:33','587',0.00,0.00,'587','2022-04-03 21:03:04','587','2022-04-03 21:03:30',10,0),('1','152',257560,'DAILY SHIFTS','2022-04-04','2022-04-04 05:44:28','2022-04-05 05:44:28','587',0.00,0.00,'587','2022-04-04 20:11:04','587','2022-04-04 20:11:38',10,0),('1','152',257561,'DAILY SHIFTS','2022-04-05','2022-04-05 05:52:00','2022-04-06 05:52:00','587',0.00,0.00,'587','2022-04-05 19:32:24','587','2022-04-05 19:32:50',10,0),('1','152',257562,'DAILY SHIFTS','2022-04-06','2022-04-06 06:58:04','2022-04-07 06:58:04','587',0.00,0.00,'587','2022-04-06 21:05:25','587','2022-04-06 21:05:53',10,0),('1','152',257563,'DAILY SHIFTS ','2022-04-07','2022-04-07 06:14:00','2022-04-08 06:14:00','587',0.00,0.00,'587','2022-04-07 14:52:40','587','2022-04-07 14:53:04',10,0),('1','152',257564,'DAILY ','2022-04-07','2022-04-07 17:01:27','2022-04-08 17:01:27','587',0.00,0.00,'587','2022-04-07 18:27:37','587','2022-04-07 18:27:57',10,0),('1','152',257565,'DAILY SHIFT','2022-04-07','2022-04-07 18:28:20','2022-04-08 18:28:20','587',0.00,0.00,'587','2022-04-07 21:29:22','587','2022-04-07 21:29:49',10,0),('1','152',257566,'DAILY SHIFTS','2022-04-07','2022-04-07 21:42:03','2022-04-08 21:42:03','587',0.00,0.00,'587','2022-04-07 21:48:25','587','2022-04-07 21:48:47',10,0),('1','152',257567,'DAILY SHIFTS','2022-04-08','2022-04-08 05:45:23','2022-04-09 05:45:23','587',0.00,0.00,'587','2022-04-08 20:51:26','587','2022-04-08 20:51:54',10,0),('1','152',257568,'DAILY','2022-04-09','2022-04-09 06:55:05','2022-04-10 06:55:05','587',0.00,0.00,'587','2022-04-09 19:47:36','587','2022-04-09 19:48:07',10,0),('1','152',257569,'DAILY SHIFTS','2022-04-10','2022-04-10 05:37:05','2022-04-11 05:37:05','587',0.00,0.00,'587','2022-04-10 19:44:29','587','2022-04-10 19:44:53',10,0),('1','152',257570,'DAILY SHIFTS','2022-04-11','2022-04-11 05:44:39','2022-04-12 05:44:39','587',0.00,0.00,'587','2022-04-11 19:58:53','587','2022-04-11 19:59:34',10,0),('1','152',257571,'DAILY SHIFTS','2022-04-12','2022-04-12 05:37:31','2022-04-13 05:37:31','587',0.00,0.00,'587','2022-04-12 21:13:44','587','2022-04-12 21:14:18',10,0),('1','152',257572,'DAILY SHIFTS ','2022-04-13','2022-04-13 06:58:26','2022-04-14 06:58:26','587',0.00,0.00,'587','2022-04-14 07:10:59','587','2022-04-14 07:11:27',10,0),('1','152',257573,'DAILY SHIFTS ','2022-04-14','2022-04-14 07:12:04','2022-04-15 07:12:04','587',0.00,0.00,'587','2022-04-14 11:34:58','587','2022-04-14 11:35:31',10,0),('1','152',257574,'DAILY SHIFTS','2022-04-14','2022-04-14 11:45:00','2022-04-15 11:45:00','587',0.00,0.00,'587','2022-04-14 11:50:11','587','2022-04-14 11:50:38',10,0),('1','152',257575,'DAILY SHIFT','2022-04-14','2022-04-14 12:45:13','2022-04-15 12:45:13','587',0.00,0.00,'587','2022-04-14 20:20:55','587','2022-04-14 20:21:13',10,0),('1','152',257576,'DAILY SHIFTS','2022-04-15','2022-04-15 06:57:00','2022-04-16 06:57:00','587',0.00,0.00,'587','2022-04-15 20:18:36','587','2022-04-15 20:19:10',10,0),('1','152',257577,'DAILY SHIFTS ','2022-04-16','2022-04-16 06:47:50','2022-04-17 06:47:50','587',0.00,0.00,'587','2022-04-16 13:38:48','587','2022-04-16 13:39:10',10,0),('1','152',257578,'DAILY SHIFTS','2022-04-16','2022-04-16 13:54:37','2022-04-17 13:54:37','587',0.00,0.00,'587','2022-04-16 14:05:12','587','2022-04-16 14:05:38',10,0),('1','152',257579,'DAILY SHIFT','2022-04-16','2022-04-16 14:30:59','2022-04-17 14:30:59','587',0.00,0.00,'587','2022-04-16 19:54:33','587','2022-04-16 19:54:53',10,0),('1','152',257580,'DAILY SHIFTS','2022-04-17','2022-04-17 06:09:07','2022-04-18 06:09:07','587',0.00,0.00,'587','2022-04-17 19:38:55','587','2022-04-17 19:39:31',10,0),('1','152',257581,'DAILY SHIFTS','2022-04-18','2022-04-18 05:32:30','2022-04-19 05:32:30','587',0.00,0.00,'587','2022-04-18 09:14:33','587','2022-04-18 09:14:53',10,0),('1','152',257582,'DAILY SHIFT','2022-04-18','2022-04-18 09:16:20','2022-04-19 09:16:20','587',0.00,0.00,'587','2022-04-18 19:55:44','587','2022-04-18 19:56:12',10,0),('1','152',257583,'DAILY SHIFTS','2022-04-19','2022-04-19 07:01:05','2022-04-20 07:01:05','587',0.00,0.00,'587','2022-04-19 19:52:05','587','2022-04-19 19:52:34',10,0),('1','152',257584,'DAILY SHIFTS','2022-04-20','2022-04-20 05:32:58','2022-04-21 05:32:58','587',0.00,0.00,'587','2022-04-20 20:44:22','587','2022-04-20 20:44:44',10,0),('1','152',257585,'DAILY SHIFTS','2022-04-21','2022-04-21 06:54:11','2022-04-22 06:54:11','587',0.00,0.00,'587','2022-04-21 19:50:35','587','2022-04-21 19:51:23',10,0),('1','152',257586,'DAILY SHIFTS ','2022-04-22','2022-04-22 07:07:09','2022-04-23 07:07:09','587',0.00,0.00,'587','2022-04-22 16:43:26','587','2022-04-22 16:43:59',10,0),('1','152',257587,'DAILY SHIFTS','2022-04-22','2022-04-22 16:55:52','2022-04-23 16:55:52','587',0.00,0.00,'587','2022-04-22 19:53:43','587','2022-04-22 19:54:01',10,0),('1','152',257588,'DAILY SHIFTS ','2022-04-23','2022-04-23 06:30:15','2022-04-24 06:30:15','587',0.00,0.00,'587','2022-04-23 20:38:36','587','2022-04-23 23:18:33',10,0),('1','152',257589,'Daily shift','2022-04-24','2022-04-24 06:55:59','2022-04-25 06:55:59','587',0.00,0.00,'587','2022-04-24 19:47:52','587','2022-04-24 19:48:13',10,0),('1','152',257590,'DAILY SHIFTS ','2022-04-25','2022-04-25 06:40:28','2022-04-26 06:40:28','587',0.00,0.00,'587','2022-04-25 19:27:48','587','2022-04-25 19:28:24',10,0),('1','152',257591,'DAILY SHIFTS ','2022-04-26','2022-04-26 06:57:09','2022-04-27 06:57:09','587',0.00,0.00,'587','2022-04-26 20:16:59','587','2022-04-26 20:17:26',10,0),('1','152',257592,'DAILY SHIFTS ','2022-04-27','2022-04-27 06:46:51','2022-04-28 06:46:51','587',0.00,0.00,'587','2022-04-27 20:05:32','587','2022-04-27 20:06:28',10,0),('1','152',257593,'DAILY SHIFTS ','2022-04-28','2022-04-28 06:18:53','2022-04-29 06:18:53','587',0.00,0.00,'587','2022-04-28 20:38:43','587','2022-04-28 20:39:11',10,0),('1','152',257594,'DAILY SHIFTS ','2022-04-29','2022-04-29 05:58:16','2022-04-30 05:58:16','587',0.00,0.00,'587','2022-04-29 16:45:17','587','2022-04-29 16:46:29',10,0),('1','152',257595,'DAILY SHIFT','2022-04-29','2022-04-29 16:50:25','2022-04-30 16:50:25','587',0.00,0.00,'587','2022-04-29 17:07:59','587','2022-04-29 17:08:40',10,0),('1','152',257596,'DAILY SHIFT','2022-04-29','2022-04-29 17:09:03','2022-04-30 17:09:03','587',0.00,0.00,'587','2022-04-29 20:00:57','587','2022-04-29 20:01:26',10,0),('1','152',257597,'DAILY SHIFTS','2022-04-30','2022-04-30 05:29:53','2022-05-01 05:29:53','587',0.00,0.00,'587','2022-04-30 20:29:56','587','2022-04-30 20:30:23',10,0),('1','152',257598,'DAILY SHIFTS ','2022-05-01','2022-05-01 06:36:58','2022-05-02 06:36:58','587',0.00,0.00,'587','2022-05-01 20:26:13','587','2022-05-01 20:26:44',10,0),('1','152',257599,'DAILY SHIFT','2022-05-02','2022-05-02 08:57:27','2022-05-03 08:57:27','587',0.00,0.00,'587','2022-05-02 18:47:42','587','2022-05-02 18:48:27',10,0),('1','152',257600,'DAILY SHIFTS ','2022-05-03','2022-05-03 06:18:17','2022-05-04 06:18:17','587',0.00,0.00,'587','2022-05-03 21:10:26','587','2022-05-03 21:11:10',10,0),('1','152',257601,'DAILY SHIFTS ','2022-05-04','2022-05-04 06:34:07','2022-05-05 06:34:07','587',0.00,0.00,'587','2022-05-04 19:57:18','587','2022-05-04 19:57:47',10,0),('1','152',257602,'DAILY SHIFTS ','2022-05-05','2022-05-05 05:55:47','2022-05-06 05:55:47','587',0.00,0.00,'587','2022-05-05 20:58:42','587','2022-05-05 20:59:36',10,0),('1','152',257603,'DAILY SHIFTS ','2022-05-06','2022-05-06 06:52:56','2022-05-07 06:52:56','587',0.00,0.00,'587','2022-05-06 09:20:49','587','2022-05-06 09:21:12',10,0),('1','152',257604,'DAILY SHIFT','2022-05-06','2022-05-06 09:22:12','2022-05-07 09:22:12','587',0.00,0.00,'587','2022-05-06 09:27:55','587','2022-05-06 09:28:21',10,0),('1','152',257605,'DAILY SHIFT','2022-05-06','2022-05-06 09:32:47','2022-05-07 09:32:47','587',0.00,0.00,'587','2022-05-06 21:10:06','587','2022-05-06 21:10:34',10,0),('1','152',257606,'DAILY SHIFTS ','2022-05-07','2022-05-07 06:08:23','2022-05-08 06:08:23','587',0.00,0.00,'587','2022-05-07 20:16:17','587','2022-05-07 20:16:59',10,0),('1','152',257607,'DAILY SHIFTS ','2022-05-08','2022-05-08 05:55:59','2022-05-09 05:55:59','587',0.00,0.00,'587','2022-05-08 20:23:03','587','2022-05-08 20:23:38',10,0),('1','152',257608,'DAILY SHIFTS ','2022-05-09','2022-05-09 06:43:10','2022-05-10 06:43:10','587',0.00,0.00,'587','2022-05-09 20:07:00','587','2022-05-09 20:07:42',10,0),('1','152',257609,'DAILY SHIFTS ','2022-05-10','2022-05-10 04:49:35','2022-05-11 04:49:35','587',0.00,0.00,'587','2022-05-10 19:51:09','587','2022-05-10 19:51:41',10,0),('1','152',257610,'DAILY SHIFTS ','2022-05-11','2022-05-11 06:49:52','2022-05-12 06:49:52','587',0.00,0.00,'587','2022-05-11 20:25:35','587','2022-05-11 20:26:04',10,0),('1','152',257611,'DAILY SHIFTS ','2022-05-12','2022-05-12 06:33:40','2022-05-13 06:33:40','587',0.00,0.00,'587','2022-05-12 10:41:25','587','2022-05-12 10:42:00',10,0),('1','152',257612,'DAILY SHIFT','2022-05-12','2022-05-12 11:27:05','2022-05-13 11:27:05','587',0.00,0.00,'587','2022-05-12 11:32:48','587','2022-05-12 11:33:08',10,0),('1','152',257613,'DAILY SHIFT','2022-05-12','2022-05-12 13:11:56','2022-05-13 13:11:56','587',0.00,0.00,'587','2022-05-12 20:39:56','587','2022-05-12 20:40:28',10,0),('1','152',257614,'DAILY SHIFTS ','2022-05-13','2022-05-13 04:50:35','2022-05-14 04:50:35','587',0.00,0.00,'587','2022-05-13 19:59:44','587','2022-05-13 20:00:16',10,0),('1','152',257615,'DAILY SHIFTS ','2022-05-14','2022-05-14 05:54:07','2022-05-15 05:54:07','587',0.00,0.00,'587','2022-05-14 20:31:20','587','2022-05-14 20:31:43',10,0),('1','152',257616,'DAILY SHIFTS ','2022-05-15','2022-05-15 06:03:23','2022-05-16 06:03:23','587',0.00,0.00,'587','2022-05-15 22:26:05','587','2022-05-15 22:26:28',10,0),('1','152',257617,'DAILY SHIFTS ','2022-05-16','2022-05-16 06:24:28','2022-05-17 06:24:28','587',0.00,0.00,'587','2022-05-16 22:45:25','587','2022-05-16 22:45:51',10,0),('1','152',257618,'DAILY SHIFT','2022-05-17','2022-05-17 06:54:29','2022-05-18 06:54:29','587',0.00,0.00,'587','2022-05-17 20:42:32','587','2022-05-17 20:42:56',10,0),('1','152',257619,'DAILY SHIFTS ','2022-05-18','2022-05-18 04:31:40','2022-05-19 04:31:40','587',0.00,0.00,'587','2022-05-18 20:39:07','587','2022-05-18 20:39:32',10,0),('1','152',257620,'DAILY SHIFTS ','2022-05-19','2022-05-19 04:47:58','2022-05-20 04:47:58','587',0.00,0.00,'587','2022-05-19 20:02:59','587','2022-05-19 20:03:31',10,0),('1','152',257621,'DAILY SHIFTS ','2022-05-20','2022-05-20 04:50:14','2022-05-21 04:50:14','587',0.00,0.00,'587','2022-05-20 12:08:45','587','2022-05-20 12:10:28',10,0),('1','152',257622,'DAILY SHIFT','2022-05-20','2022-05-20 12:21:02','2022-05-21 12:21:02','587',0.00,0.00,'587','2022-05-20 12:27:05','587','2022-05-20 12:27:28',10,0),('1','152',257623,'DAILY SHIFT','2022-05-20','2022-05-20 14:07:32','2022-05-21 14:07:32','587',0.00,0.00,'587','2022-05-20 20:26:09','587','2022-05-20 20:26:35',10,0),('1','152',257624,'DAILY SHIFTS ','2022-05-21','2022-05-21 06:02:10','2022-05-22 06:02:10','587',0.00,0.00,'587','2022-05-21 10:44:46','587','2022-05-21 10:45:12',10,0),('1','152',257625,'DAILY SHIFT','2022-05-21','2022-05-21 10:45:34','2022-05-22 10:45:34','587',0.00,0.00,'587','2022-05-21 20:29:46','587','2022-05-21 20:30:25',10,0),('1','152',257626,'DAILY SHIFTS ','2022-05-22','2022-05-22 05:31:36','2022-05-23 05:31:36','587',0.00,0.00,'587','2022-05-22 22:00:50','587','2022-05-22 22:01:22',10,0),('1','152',257627,'DAILY SHIFTS ','2022-05-23','2022-05-23 06:42:19','2022-05-24 06:42:19','587',0.00,0.00,'587','2022-05-23 09:58:31','587','2022-05-23 10:07:20',10,0),('1','152',257628,'DAILY SHIFTS ','2022-05-23','2022-05-23 10:19:34','2022-05-24 10:19:34','587',0.00,0.00,'587','2022-05-23 10:41:53','587','2022-05-23 10:42:55',10,0),('1','152',257629,'DAILY SHIFTS','2022-05-23','2022-05-23 10:56:33','2022-05-24 10:56:33','587',0.00,0.00,'587','2022-05-23 21:06:08','587','2022-05-23 21:06:36',10,0),('1','152',257630,'DAILY SHIFTS ','2022-05-24','2022-05-24 06:19:28','2022-05-25 06:19:28','587',0.00,0.00,'587','2022-05-24 20:03:08','587','2022-05-24 20:03:36',10,0),('1','152',257631,'DAILY SHIFT','2022-05-25','2022-05-25 06:30:12','2022-05-26 06:30:12','587',0.00,0.00,'587','2022-05-25 19:58:48','587','2022-05-25 19:59:23',10,0),('1','152',257632,'DAILY SHIFT','2022-05-26','2022-05-26 06:50:17','2022-05-27 06:50:17','587',0.00,0.00,'587','2022-05-26 20:01:46','587','2022-05-26 20:02:24',10,0),('1','152',257633,'DAILY SHIFTs','2022-05-27','2022-05-27 06:57:55','2022-05-28 06:57:55','587',0.00,0.00,'587','2022-05-27 21:29:27','587','2022-05-27 21:29:53',10,0),('1','152',257634,'DAILY SHIFT','2022-05-28','2022-05-28 07:14:08','2022-05-29 07:14:08','587',0.00,0.00,'587','2022-05-28 21:30:20','587','2022-05-28 21:31:01',10,0),('1','152',257635,'DAILY SHIFTS','2022-05-29','2022-05-29 06:06:30','2022-05-30 06:06:30','587',0.00,0.00,'587','2022-05-29 21:20:12','587','2022-05-29 21:20:41',10,0),('1','152',257636,'DAILY SHIFTS ','2022-05-30','2022-05-30 06:34:06','2022-05-31 06:34:06','587',0.00,0.00,'587','2022-05-30 20:19:19','587','2022-05-30 20:20:15',10,0),('1','152',257637,'DAILY SHIFTs','2022-05-31','2022-05-31 06:29:33','2022-06-01 06:29:33','587',0.00,0.00,'587','2022-05-31 17:16:15','587','2022-05-31 17:16:46',10,0),('1','152',257638,'DAILY SHIFT1','2022-05-31','2022-05-31 17:18:32','2022-06-01 17:18:32','587',0.00,0.00,'587','2022-05-31 17:33:02','587','2022-05-31 17:33:26',10,0),('1','152',257639,'DAILY SHIFT','2022-05-31','2022-05-31 17:44:30','2022-06-01 17:44:30','587',0.00,0.00,'587','2022-05-31 22:02:26','587','2022-05-31 22:02:59',10,0),('1','152',257640,'DAILY SHIFT','2022-06-01','2022-06-01 06:48:09','2022-06-02 06:48:09','587',0.00,0.00,'587','2022-06-01 21:52:58','587','2022-06-01 21:53:23',10,0),('1','152',257641,'DAILY SHIFT','2022-06-02','2022-06-02 06:54:20','2022-06-03 06:54:20','587',0.00,0.00,'587','2022-06-02 21:53:44','587','2022-06-02 21:54:18',10,0),('1','152',257642,'DAILY SHIFT','2022-06-03','2022-06-03 06:47:47','2022-06-04 06:47:47','587',0.00,0.00,'587','2022-06-03 22:34:16','587','2022-06-03 22:34:44',10,0),('1','152',257643,'DAILY SHIFTs','2022-06-04','2022-06-04 07:01:08','2022-06-05 07:01:08','587',0.00,0.00,'587','2022-06-04 22:22:44','587','2022-06-05 06:46:07',10,0),('1','152',257644,'DAILY SHIFTS ','2022-06-05','2022-06-05 06:47:08','2022-06-06 06:47:08','587',0.00,0.00,'587','2022-06-05 20:13:51','587','2022-06-05 20:15:03',10,0),('1','152',257645,'DAILY SHIFTs','2022-06-06','2022-06-06 07:09:10','2022-06-07 07:09:10','587',0.00,0.00,'587','2022-06-06 20:14:28','587','2022-06-06 20:15:21',10,0),('1','152',257646,'DAILY SHIFT','2022-06-07','2022-06-07 07:01:48','2022-06-08 07:01:48','587',0.00,0.00,'587','2022-06-07 11:45:03','587','2022-06-07 11:45:50',10,0),('1','152',257647,'DAILY SHIFT','2022-06-07','2022-06-07 11:46:42','2022-06-08 11:46:42','587',0.00,0.00,'587','2022-06-07 12:11:37','587','2022-06-07 12:11:58',10,0),('1','152',257648,'DAILY SHIFTs','2022-06-07','2022-06-07 12:32:52','2022-06-08 12:32:52','587',0.00,0.00,'587','2022-06-07 20:08:49','587','2022-06-07 22:03:29',10,0),('1','152',257649,'DAILY SHIFTS','2022-06-08','2022-06-08 06:58:14','2022-06-09 06:58:14','587',0.00,0.00,'894','2022-06-08 21:38:27','894','2022-06-08 21:39:08',10,0),('1','152',257650,'DAILY SHIFT','2022-06-09','2022-06-09 06:54:21','2022-06-10 06:54:21','894',0.00,0.00,'894','2022-06-09 21:09:06','894','2022-06-09 21:09:50',10,0),('1','152',257651,'DAILY SHIFT','2022-06-10','2022-06-10 06:41:46','2022-06-11 06:41:46','894',0.00,0.00,'894','2022-06-10 20:24:29','894','2022-06-10 20:24:59',10,0),('1','152',257652,'DAILY SHIFT','2022-06-11','2022-06-11 06:53:15','2022-06-12 06:53:15','894',0.00,0.00,'894','2022-06-11 22:15:48','894','2022-06-11 22:16:36',10,0),('1','152',257653,'DAILY SHIFTS','2022-06-12','2022-06-12 06:49:40','2022-06-13 06:49:40','894',0.00,0.00,'894','2022-06-12 20:37:57','894','2022-06-12 20:39:09',10,0),('1','152',257654,'DAILY SHIFTs','2022-06-13','2022-06-13 07:02:42','2022-06-14 07:02:42','894',0.00,0.00,'894','2022-06-13 22:39:02','894','2022-06-13 22:39:31',10,0),('1','152',257655,'DAILY SHIFTs','2022-06-14','2022-06-14 07:02:25','2022-06-15 07:02:25','894',0.00,0.00,'894','2022-06-14 20:40:30','894','2022-06-15 06:55:34',10,0),('1','152',257656,'DAILY SHIFT','2022-06-15','2022-06-15 06:56:17','2022-06-16 06:56:17','894',0.00,0.00,'894','2022-06-15 15:46:42','894','2022-06-15 15:47:05',10,0),('1','152',257657,'DAILY SHIFT','2022-06-15','2022-06-15 15:47:43','2022-06-16 15:47:43','894',0.00,0.00,'894','2022-06-15 15:58:26','894','2022-06-15 15:58:52',10,0),('1','152',257658,'DAILY SHIFT','2022-06-15','2022-06-15 15:59:14','2022-06-16 15:59:14','894',0.00,0.00,'894','2022-06-15 20:58:30','894','2022-06-15 20:58:56',10,0),('1','152',257659,'DAILY SHIFT','2022-06-16','2022-06-16 07:10:23','2022-06-17 07:10:23','894',0.00,0.00,'894','2022-06-16 22:04:45','894','2022-06-16 22:05:20',10,0),('1','152',257660,'DAILY SHIFT','2022-06-17','2022-06-17 06:57:21','2022-06-18 06:57:21','894',0.00,0.00,'894','2022-06-17 21:04:34','894','2022-06-17 21:05:13',10,0),('1','152',257661,'DAILY SHIFT','2022-06-18','2022-06-18 07:07:13','2022-06-19 07:07:13','894',0.00,0.00,'894','2022-06-18 20:19:53','894','2022-06-18 20:20:44',10,0),('1','152',257662,'DAILY SHIFTs','2022-06-19','2022-06-19 06:51:34','2022-06-20 06:51:34','894',0.00,0.00,'894','2022-06-19 22:27:39','894','2022-06-19 22:28:17',10,0),('1','152',257663,'DAILY SHIFTs','2022-06-20','2022-06-20 07:04:31','2022-06-21 07:04:31','894',0.00,0.00,'894','2022-06-20 19:40:37','894','2022-06-20 19:44:11',10,0),('1','152',257664,'DAILY SHIFT','2022-06-20','2022-06-20 19:51:34','2022-06-21 19:51:34','894',0.00,0.00,'894','2022-06-20 20:11:31','894','2022-06-20 20:11:53',10,0),('1','152',257665,'DAILY SHIFTS ','2022-06-21','2022-06-21 07:26:03','2022-06-22 07:26:03','894',0.00,0.00,'894','2022-06-21 22:17:36','894','2022-06-21 22:18:08',10,0),('1','152',257666,'DAILY SHIFT','2022-06-22','2022-06-22 06:58:26','2022-06-23 06:58:26','894',0.00,0.00,'894','2022-06-22 21:24:49','894','2022-06-22 21:25:44',10,0),('1','152',257667,'DAILY SHIFTS ','2022-06-23','2022-06-23 06:35:47','2022-06-24 06:35:47','894',0.00,0.00,'894','2022-06-23 22:03:10','894','2022-06-23 22:04:03',10,0),('1','152',257668,'DAILY SHIFTs','2022-06-24','2022-06-24 07:07:35','2022-06-25 07:07:35','894',0.00,0.00,'894','2022-06-24 20:15:41','894','2022-06-24 20:16:19',10,0),('1','152',257669,'DAILY SHIFT','2022-06-25','2022-06-25 07:18:25','2022-06-26 07:18:25','894',0.00,0.00,'894','2022-06-25 21:37:02','894','2022-06-25 21:37:27',10,0),('1','152',257670,'DAILY SHIFTS ','2022-06-26','2022-06-26 09:06:07','2022-06-27 09:06:07','894',0.00,0.00,'894','2022-06-26 19:58:24','894','2022-06-26 20:00:17',10,0),('1','152',257671,'DAILY SHIFT','2022-06-27','2022-06-27 07:09:55','2022-06-28 07:09:55','894',0.00,0.00,'894','2022-06-27 22:21:49','894','2022-06-27 22:22:40',10,0),('1','152',257672,'DAILY SHIFT','2022-06-28','2022-06-28 06:50:13','2022-06-29 06:50:13','894',0.00,0.00,'894','2022-06-28 20:08:12','894','2022-06-28 20:10:48',10,0),('1','152',257673,'DAILY SHIFT','2022-06-29','2022-06-29 07:50:29','2022-06-30 07:50:29','894',0.00,0.00,'894','2022-06-29 19:47:22','894','2022-06-29 19:47:58',10,0),('1','152',257674,'DAILY SHIFT','2022-06-29','2022-06-29 19:50:40','2022-06-30 19:50:40','894',0.00,0.00,'894','2022-06-29 19:55:59','894','2022-06-29 19:56:28',10,0),('1','152',257675,'DAILY SHIFTs','2022-06-30','2022-06-30 07:04:35','2022-07-01 07:04:35','894',0.00,0.00,'894','2022-06-30 19:57:01','894','2022-06-30 19:58:14',10,0),('1','152',257676,'DAILY SHIFT','2022-07-01','2022-07-01 06:55:32','2022-07-02 06:55:32','894',0.00,0.00,'894','2022-07-01 20:32:27','894','2022-07-01 20:33:09',10,0),('1','152',257677,'DAILY SHIFTs','2022-07-02','2022-07-02 07:09:33','2022-07-03 07:09:33','894',0.00,0.00,'894','2022-07-03 07:23:40','894','2022-07-03 07:27:37',10,0),('1','152',257678,'DAILY SHIFT','2022-07-03','2022-07-03 07:28:17','2022-07-04 07:28:17','894',0.00,0.00,'894','2022-07-03 20:24:18','894','2022-07-03 20:27:16',10,0),('1','152',257679,'DAILY SHIFTs','2022-07-04','2022-07-04 07:05:49','2022-07-05 07:05:49','894',0.00,0.00,'894','2022-07-04 20:19:16','894','2022-07-04 20:19:59',10,0),('1','152',257680,'DAILY SHIFT','2022-07-05','2022-07-05 06:59:32','2022-07-06 06:59:32','894',0.00,0.00,'894','2022-07-05 20:17:05','894','2022-07-05 20:19:22',10,0),('1','152',257681,'DAILY SHIFTs','2022-07-06','2022-07-06 06:58:06','2022-07-07 06:58:06','894',0.00,0.00,'894','2022-07-06 21:43:37','894','2022-07-06 21:44:13',10,0),('1','152',257682,'DAILY SHIFT','2022-07-07','2022-07-07 07:03:01','2022-07-08 07:03:01','894',0.00,0.00,'894','2022-07-07 09:30:01','894','2022-07-07 09:32:47',10,0),('1','152',257683,'DAILY SHIFT','2022-07-07','2022-07-07 10:21:27','2022-07-08 10:21:27','894',0.00,0.00,'894','2022-07-07 10:30:00','894','2022-07-07 10:30:30',10,0),('1','152',257684,'DAILY SHIFT','2022-07-07','2022-07-07 10:40:02','2022-07-08 10:40:02','894',0.00,0.00,'894','2022-07-07 20:44:26','894','2022-07-07 20:45:11',10,0),('1','152',257685,'DAILY SHIFT','2022-07-08','2022-07-08 07:03:41','2022-07-09 07:03:41','894',0.00,0.00,'894','2022-07-08 20:25:38','894','2022-07-08 20:26:47',10,0),('1','152',257686,'DAILY SHIFTS ','2022-07-09','2022-07-09 07:31:47','2022-07-10 07:31:47','894',0.00,0.00,'894','2022-07-09 21:39:41','894','2022-07-09 21:40:27',10,0),('1','152',257687,'DAILY SHIFT','2022-07-10','2022-07-10 07:16:09','2022-07-11 07:16:09','894',0.00,0.00,'894','2022-07-10 20:25:42','894','2022-07-10 20:26:51',10,0),('1','152',257688,'DAILY SHIFTS ','2022-07-11','2022-07-11 06:55:57','2022-07-12 06:55:57','894',0.00,0.00,'894','2022-07-11 20:05:59','894','2022-07-11 20:06:36',10,0),('1','152',257689,'DAILY SHIFT','2022-07-12','2022-07-12 07:01:49','2022-07-13 07:01:49','894',0.00,0.00,'894','2022-07-12 20:29:24','894','2022-07-12 20:30:26',10,0),('1','152',257690,'DAILY SHIFT','2022-07-13','2022-07-13 07:01:50','2022-07-14 07:01:50','894',0.00,0.00,'894','2022-07-13 22:21:52','894','2022-07-13 22:22:19',10,0),('1','152',257691,'DAILY SHIFT','2022-07-14','2022-07-14 07:08:09','2022-07-15 07:08:09','894',0.00,0.00,'894','2022-07-14 20:41:26','894','2022-07-14 20:43:24',10,0),('1','152',257692,'DAILY SHIFT','2022-07-15','2022-07-15 07:14:31','2022-07-16 07:14:31','894',0.00,0.00,'894','2022-07-15 11:48:33','894','2022-07-15 11:49:09',10,0),('1','152',257693,'DAILY SHIFT','2022-07-15','2022-07-15 11:58:40','2022-07-16 11:58:40','894',0.00,0.00,'894','2022-07-15 19:56:38','894','2022-07-15 19:57:16',10,0),('1','152',257694,'DAILY SHIFT','2022-07-16','2022-07-16 07:06:13','2022-07-17 07:06:13','894',0.00,0.00,'894','2022-07-16 21:01:49','894','2022-07-16 21:02:28',10,0),('1','152',257695,'DAILY SHIFT','2022-07-17','2022-07-17 07:38:57','2022-07-18 07:38:57','894',0.00,0.00,'894','2022-07-17 19:39:54','894','2022-07-17 19:40:49',10,0),('1','152',257696,'DAILY SHIFT','2022-07-18','2022-07-18 07:13:02','2022-07-19 07:13:02','894',0.00,0.00,'894','2022-07-18 21:12:35','894','2022-07-18 21:12:57',10,0),('1','152',257697,'DAILY SHIFT','2022-07-19','2022-07-19 07:00:40','2022-07-20 07:00:40','894',0.00,0.00,'894','2022-07-19 22:29:53','894','2022-07-19 22:30:36',10,0),('1','152',257698,'DAILY SHIFT','2022-07-20','2022-07-20 07:09:46','2022-07-21 07:09:46','894',0.00,0.00,'894','2022-07-20 21:03:29','894','2022-07-20 21:03:57',10,0),('1','152',257699,'DAILY SHIFT','2022-07-21','2022-07-21 07:20:55','2022-07-22 07:20:55','894',0.00,0.00,'894','2022-07-21 21:02:16','894','2022-07-21 21:02:50',10,0),('1','152',257700,'DAILY SHIFT','2022-07-22','2022-07-22 07:11:42','2022-07-23 07:11:42','894',0.00,0.00,'894','2022-07-22 20:32:32','894','2022-07-22 20:33:33',10,0),('1','152',257701,'DAILY SHIFT','2022-07-23','2022-07-23 07:23:14','2022-07-24 07:23:14','894',0.00,0.00,'894','2022-07-23 21:42:37','894','2022-07-23 21:43:17',10,0),('1','152',257702,'DAILY SHIFT','2022-07-24','2022-07-24 09:08:56','2022-07-25 09:08:56','894',0.00,0.00,'894','2022-07-24 10:28:43','894','2022-07-24 10:29:08',10,0),('1','152',257703,'DAILY SHIFT','2022-07-24','2022-07-24 10:30:01','2022-07-25 10:30:01','894',0.00,0.00,'894','2022-07-24 10:35:59','894','2022-07-24 10:36:39',10,0),('1','152',257704,'DAILY SHIFT','2022-07-24','2022-07-24 10:40:53','2022-07-25 10:40:53','894',0.00,0.00,'894','2022-07-24 20:57:48','894','2022-07-24 20:58:59',10,0),('1','152',257705,'DAILY SHIFT','2022-07-25','2022-07-25 07:11:31','2022-07-26 07:11:31','894',0.00,0.00,'894','2022-07-25 22:10:31','894','2022-07-25 22:11:01',10,0),('1','152',257706,'DAILY SHIFT','2022-07-26','2022-07-26 07:21:21','2022-07-27 07:21:21','894',0.00,0.00,'894','2022-07-26 21:15:08','894','2022-07-26 21:15:51',10,0),('1','152',257707,'DAILY SHIFTs','2022-07-27','2022-07-27 07:07:50','2022-07-28 07:07:50','894',0.00,0.00,'894','2022-07-27 19:33:45','894','2022-07-27 19:34:48',10,0),('1','152',257708,'DAILY SHIFT','2022-07-28','2022-07-28 07:42:55','2022-07-29 07:42:55','894',0.00,0.00,'894','2022-07-28 20:55:22','894','2022-07-28 20:55:55',10,0),('1','152',257709,'DAILY SHIFT','2022-07-29','2022-07-29 07:12:35','2022-07-30 07:12:35','894',0.00,0.00,'894','2022-07-29 20:32:18','894','2022-07-29 20:43:33',10,0),('1','152',257710,'DAILY SHIFT','2022-07-30','2022-07-30 08:57:25','2022-07-31 08:57:25','894',0.00,0.00,'894','2022-07-30 18:05:28','894','2022-07-30 18:06:00',10,0),('1','152',257711,'DAILY SHIFT','2022-07-30','2022-07-30 18:33:18','2022-07-31 18:33:18','894',0.00,0.00,'894','2022-07-30 20:42:18','894','2022-07-30 20:42:53',10,0),('1','152',257712,'DAILY SHIFTS ','2022-07-31','2022-07-31 07:04:29','2022-08-01 07:04:29','894',0.00,0.00,'894','2022-07-31 20:21:11','894','2022-07-31 20:22:03',10,0),('1','152',257713,'DAILY SHIFT','2022-08-01','2022-08-01 07:19:06','2022-08-02 07:19:06','894',0.00,0.00,'894','2022-08-01 22:08:10','894','2022-08-01 22:09:10',10,0),('1','152',257714,'DAILY SHIFT','2022-08-02','2022-08-02 07:16:00','2022-08-03 07:16:00','894',0.00,0.00,'894','2022-08-02 20:28:37','894','2022-08-02 20:29:36',10,0),('1','152',257715,'DAILY SHIFT','2022-08-03','2022-08-03 07:52:31','2022-08-04 07:52:31','894',0.00,0.00,'894','2022-08-03 20:20:31','894','2022-08-03 20:23:31',10,0),('1','152',257716,'DAILY SHIFTs','2022-08-04','2022-08-04 07:04:03','2022-08-05 07:04:03','894',0.00,0.00,'894','2022-08-04 20:14:36','894','2022-08-04 20:15:38',10,0),('1','152',257717,'DAILY SHIFT','2022-08-05','2022-08-05 07:19:25','2022-08-06 07:19:25','894',0.00,0.00,'894','2022-08-05 21:19:32','894','2022-08-05 21:20:51',10,0),('1','152',257718,'DAILY SHIFTs','2022-08-06','2022-08-06 07:06:59','2022-08-07 07:06:59','894',0.00,0.00,'894','2022-08-06 11:48:48','894','2022-08-06 11:50:29',10,0),('1','152',257719,'DAILY SHIFT','2022-08-06','2022-08-06 11:51:11','2022-08-07 11:51:11','894',0.00,0.00,'894','2022-08-06 12:56:21','894','2022-08-06 12:57:04',10,0),('1','152',257720,'DAILY SHIFT','2022-08-06','2022-08-06 13:05:02','2022-08-07 13:05:02','894',0.00,0.00,'894','2022-08-06 20:23:10','894','2022-08-06 20:24:26',10,0),('1','152',257721,'DAILY SHIFT','2022-08-07','2022-08-07 07:05:56','2022-08-08 07:05:56','894',0.00,0.00,'894','2022-08-07 19:35:59','894','2022-08-07 19:36:37',10,0),('1','152',257722,'DAILY SHIFT','2022-08-07','2022-08-07 19:38:01','2022-08-08 19:38:01','894',0.00,0.00,'894','2022-08-07 19:46:27','894','2022-08-07 19:47:38',10,0),('1','152',257723,'DAILY SHIFTs','2022-08-08','2022-08-08 07:33:01','2022-08-09 07:33:01','894',0.00,0.00,'894','2022-08-08 21:21:40','894','2022-08-08 21:22:32',10,0),('1','152',257724,'DAILY SHIFT','2022-08-09','2022-08-09 07:15:27','2022-08-10 07:15:27','894',0.00,0.00,'894','2022-08-09 17:08:31','894','2022-08-09 17:09:39',10,0),('1','152',257725,'DAILY SHIFT','2022-08-09','2022-08-09 17:11:30','2022-08-10 17:11:30','894',0.00,0.00,'894','2022-08-09 17:15:59','894','2022-08-09 17:16:25',10,0),('1','152',257726,'DAILY SHIFT','2022-08-09','2022-08-09 17:20:09','2022-08-10 17:20:09','894',0.00,0.00,'894','2022-08-09 21:26:41','894','2022-08-09 21:27:21',10,0),('1','152',257727,'DAILY SHIFTs','2022-08-10','2022-08-10 07:05:33','2022-08-11 07:05:33','894',0.00,0.00,'894','2022-08-10 20:26:06','894','2022-08-10 20:27:31',10,0),('1','152',257728,'DAILY SHIFT','2022-08-11','2022-08-11 07:49:56','2022-08-12 07:49:56','894',0.00,0.00,'894','2022-08-11 16:07:50','894','2022-08-11 16:08:57',10,0),('1','152',257729,'DAILY SHIFT','2022-08-11','2022-08-11 16:09:36','2022-08-12 16:09:36','894',0.00,0.00,'894','2022-08-11 16:26:06','894','2022-08-11 16:26:34',10,0),('1','152',257730,'DAILY SHIFT','2022-08-11','2022-08-11 16:42:56','2022-08-12 16:42:56','894',0.00,0.00,'894','2022-08-11 21:40:17','894','2022-08-11 21:40:47',10,0),('1','152',257731,'DAILY SHIFTs','2022-08-12','2022-08-12 07:10:14','2022-08-13 07:10:14','894',0.00,0.00,'894','2022-08-12 07:12:17','894','2022-08-12 07:13:51',10,0),('1','152',257732,'DAILY SHIFTs','2022-08-12','2022-08-12 07:14:16','2022-08-13 07:14:16','894',0.00,0.00,'894','2022-08-12 20:59:40','894','2022-08-12 21:01:06',10,0),('1','152',257733,'DAILY SHIFT','2022-08-13','2022-08-13 07:31:04','2022-08-14 07:31:04','894',0.00,0.00,'894','2022-08-13 15:27:50','894','2022-08-13 15:29:14',10,0),('1','152',257734,'DAILY SHIFT','2022-08-13','2022-08-13 15:32:11','2022-08-14 15:32:11','894',0.00,0.00,'894','2022-08-13 20:21:12','894','2022-08-13 20:21:37',10,0),('1','152',257735,'DAILY SHIFT','2022-08-14','2022-08-14 07:19:08','2022-08-15 07:19:08','894',0.00,0.00,'894','2022-08-14 20:19:04','894','2022-08-14 20:20:17',10,0),('1','152',257736,'DAILY SHIFT','2022-08-15','2022-08-15 07:53:10','2022-08-16 07:53:10','894',0.00,0.00,'894','2022-08-15 15:35:20','894','2022-08-15 15:37:00',10,0),('1','152',257737,'DAILY SHIFT','2022-08-15','2022-08-15 15:37:33','2022-08-16 15:37:33','894',0.00,0.00,'894','2022-08-15 19:57:20','894','2022-08-15 19:58:43',10,0),('1','152',257738,'DAILY SHIFT','2022-08-16','2022-08-16 07:00:08','2022-08-17 07:00:08','894',0.00,0.00,'894','2022-08-16 20:48:34','894','2022-08-16 20:49:26',10,0),('1','152',257739,'DAILY SHIFT','2022-08-17','2022-08-17 07:11:20','2022-08-18 07:11:20','894',0.00,0.00,'894','2022-08-17 15:15:42','894','2022-08-17 15:16:57',10,0),('1','152',257740,'DAILY SHIFT','2022-08-17','2022-08-17 15:21:24','2022-08-18 15:21:24','894',0.00,0.00,'894','2022-08-17 22:23:53','894','2022-08-17 22:24:21',10,0),('1','152',257741,'DAILY SHIFT','2022-08-18','2022-08-18 06:53:12','2022-08-19 06:53:12','894',0.00,0.00,'894','2022-08-18 23:05:34','894','2022-08-18 23:06:22',10,0),('1','152',257742,'DAILY SHIFT','2022-08-19','2022-08-19 07:11:52','2022-08-20 07:11:52','894',0.00,0.00,'894','2022-08-19 15:33:38','894','2022-08-19 15:34:15',10,0),('1','152',257743,'DAILY SHIFT','2022-08-19','2022-08-19 15:41:49','2022-08-20 15:41:49','894',0.00,0.00,'894','2022-08-19 20:02:31','894','2022-08-19 20:03:13',10,0),('1','152',257744,'DAILY SHIFT','2022-08-20','2022-08-20 06:55:38','2022-08-21 06:55:38','894',0.00,0.00,'894','2022-08-20 10:39:13','894','2022-08-20 10:39:55',10,0),('1','152',257745,'DAILY SHIFT','2022-08-20','2022-08-20 10:42:22','2022-08-21 10:42:22','894',0.00,0.00,'894','2022-08-20 10:51:22','894','2022-08-20 10:51:46',10,0),('1','152',257746,'DAILY SHIFT','2022-08-20','2022-08-20 10:52:17','2022-08-21 10:52:17','894',0.00,0.00,'894','2022-08-20 21:43:54','894','2022-08-20 21:44:40',10,0),('1','152',257747,'DAILY SHIFT','2022-08-21','2022-08-21 07:03:06','2022-08-22 07:03:06','894',0.00,0.00,'894','2022-08-21 11:22:53','894','2022-08-21 11:23:22',10,0),('1','152',257748,'DAILY SHIFT','2022-08-21','2022-08-21 11:23:45','2022-08-22 11:23:45','894',0.00,0.00,'894','2022-08-21 20:31:49','894','2022-08-21 20:34:59',10,0),('1','152',257749,'DAILY SHIFT','2022-08-22','2022-08-22 07:09:41','2022-08-23 07:09:41','894',0.00,0.00,'894','2022-08-22 22:29:10','894','2022-08-22 22:31:00',10,0),('1','152',257750,'DAILY SHIFT','2022-08-23','2022-08-23 07:11:40','2022-08-24 07:11:40','894',0.00,0.00,'894','2022-08-23 20:10:29','894','2022-08-23 20:12:16',10,0),('1','152',257751,'DAILY SHIFTs','2022-08-24','2022-08-24 07:01:43','2022-08-25 07:01:43','894',0.00,0.00,'894','2022-08-24 20:21:12','894','2022-08-24 20:22:16',10,0),('1','152',257752,'DAILY SHIFT','2022-08-25','2022-08-25 07:45:18','2022-08-26 07:45:18','894',0.00,0.00,'894','2022-08-25 20:19:54','894','2022-08-25 20:20:25',10,0),('1','152',257753,'DAILY SHIFT','2022-08-26','2022-08-26 06:42:09','2022-08-27 06:42:09','894',0.00,0.00,'894','2022-08-26 21:00:48','894','2022-08-26 21:02:04',10,0),('1','152',257754,'DAILY SHIFT','2022-08-27','2022-08-27 06:54:04','2022-08-28 06:54:04','894',0.00,0.00,'894','2022-08-27 20:00:45','894','2022-08-27 20:01:50',10,0),('1','152',257755,'DAILY SHIFT','2022-08-27','2022-08-27 20:02:48','2022-08-28 20:02:48','894',0.00,0.00,'894','2022-08-27 20:12:19','894','2022-08-27 20:12:54',10,0),('1','152',257756,'DAILY SHIFT','2022-08-28','2022-08-28 07:08:17','2022-08-29 07:08:17','894',0.00,0.00,'894','2022-08-28 20:54:38','894','2022-08-28 20:55:29',10,0),('1','152',257757,'DAILY SHIFT','2022-08-29','2022-08-29 07:07:54','2022-08-30 07:07:54','894',0.00,0.00,'894','2022-08-29 19:55:10','894','2022-08-29 19:56:03',10,0),('1','152',257758,'DAILY SHIFT','2022-08-30','2022-08-30 07:13:46','2022-08-31 07:13:46','894',0.00,0.00,'894','2022-08-30 21:27:59','894','2022-08-30 21:29:09',10,0),('1','152',257759,'DAILY SHIFT','2022-08-31','2022-08-31 07:04:32','2022-09-01 07:04:32','894',0.00,0.00,'894','2022-08-31 21:15:23','894','2022-08-31 21:16:08',10,0),('1','152',257760,'DAILY SHIFT','2022-09-01','2022-09-01 06:57:04','2022-09-02 06:57:04','894',0.00,0.00,'894','2022-09-01 23:11:31','894','2022-09-01 23:12:21',10,0),('1','152',257761,'DAILY SHIFT','2022-09-02','2022-09-02 07:22:11','2022-09-03 07:22:11','894',0.00,0.00,'894','2022-09-02 20:13:32','894','2022-09-02 20:16:48',10,0),('1','152',257762,'DAILY SHIFT','2022-09-03','2022-09-03 07:04:52','2022-09-04 07:04:52','894',0.00,0.00,'894','2022-09-03 22:22:58','894','2022-09-03 22:24:00',10,0),('1','152',257763,'DAILY SHIFT','2022-09-04','2022-09-04 07:07:14','2022-09-05 07:07:14','894',0.00,0.00,'894','2022-09-04 11:32:13','894','2022-09-04 11:33:08',10,0),('1','152',257764,'DAILY SHIFT','2022-09-04','2022-09-04 11:33:46','2022-09-05 11:33:46','894',0.00,0.00,'894','2022-09-04 11:43:49','894','2022-09-04 11:44:36',10,0),('1','152',257765,'DAILY SHIFT','2022-09-04','2022-09-04 12:15:54','2022-09-05 12:15:54','894',0.00,0.00,'894','2022-09-04 22:15:50','894','2022-09-04 22:17:15',10,0),('1','152',257766,'DAILY SHIFT','2022-09-05','2022-09-05 07:04:22','2022-09-06 07:04:22','894',0.00,0.00,'894','2022-09-05 21:54:39','894','2022-09-05 21:56:00',10,0),('1','152',257767,'DAILY SHIFT','2022-09-06','2022-09-06 07:00:40','2022-09-07 07:00:40','894',0.00,0.00,'894','2022-09-06 13:16:02','894','2022-09-06 13:16:54',10,0),('1','152',257768,'DAILY SHIFT','2022-09-06','2022-09-06 13:22:07','2022-09-07 13:22:07','894',0.00,0.00,'894','2022-09-06 22:03:50','894','2022-09-06 22:04:52',10,0),('1','152',257769,'DAILY SHIFTs','2022-09-07','2022-09-07 06:42:06','2022-09-08 06:42:06','894',0.00,0.00,'894','2022-09-07 21:02:03','894','2022-09-07 21:03:23',10,0),('1','152',257770,'DAILY SHIFT','2022-09-08','2022-09-08 07:04:31','2022-09-09 07:04:31','894',0.00,0.00,'894','2022-09-08 10:07:47','894','2022-09-08 10:08:15',10,0),('1','152',257771,'DAILY SHIFT','2022-09-08','2022-09-08 11:45:54','2022-09-09 11:45:54','894',0.00,0.00,'894','2022-09-08 20:09:48','894','2022-09-08 20:11:10',10,0),('1','152',257772,'DAILY SHIFTs','2022-09-09','2022-09-09 06:58:38','2022-09-10 06:58:38','894',0.00,0.00,'894','2022-09-09 20:59:42','894','2022-09-09 21:00:40',10,0),('1','152',257773,'DAILY SHIFT','2022-09-10','2022-09-10 07:20:07','2022-09-11 07:20:07','894',0.00,0.00,'894','2022-09-10 11:01:36','894','2022-09-10 11:02:19',10,0),('1','152',257774,'DAILY SHIFT','2022-09-10','2022-09-10 11:03:20','2022-09-11 11:03:20','894',0.00,0.00,'894','2022-09-10 21:04:56','894','2022-09-10 21:06:35',10,0),('1','152',257775,'DAILY SHIFTs','2022-09-11','2022-09-11 06:56:53','2022-09-12 06:56:53','894',0.00,0.00,'894','2022-09-11 10:34:04','894','2022-09-11 10:34:35',10,0),('1','152',257776,'DAILY SHIFT','2022-09-11','2022-09-11 10:35:09','2022-09-12 10:35:09','894',0.00,0.00,'894','2022-09-11 10:40:58','894','2022-09-11 10:41:30',10,0),('1','152',257777,'DAILY SHIFT','2022-09-11','2022-09-11 10:42:04','2022-09-12 10:42:04','894',0.00,0.00,'894','2022-09-11 19:58:27','894','2022-09-11 19:59:32',10,0),('1','152',257778,'DAILY SHIFT','2022-09-12','2022-09-12 06:58:08','2022-09-13 06:58:08','894',0.00,0.00,'894','2022-09-12 21:15:05','894','2022-09-12 21:16:25',10,0),('1','152',257779,'DAILY SHIFT','2022-09-13','2022-09-13 06:47:57','2022-09-14 06:47:57','894',0.00,0.00,'894','2022-09-13 09:26:23','894','2022-09-13 09:26:49',10,0),('1','152',257780,'DAILY SHIFT','2022-09-13','2022-09-13 09:27:42','2022-09-14 09:27:42','894',0.00,0.00,'894','2022-09-13 20:42:17','894','2022-09-13 20:43:24',10,0),('1','152',257781,'DAILY SHIFT','2022-09-14','2022-09-14 07:03:40','2022-09-15 07:03:40','894',0.00,0.00,'894','2022-09-14 09:08:18','894','2022-09-14 09:08:42',10,0),('1','152',257782,'DAILY SHIFT','2022-09-14','2022-09-14 09:09:34','2022-09-15 09:09:34','894',0.00,0.00,'894','2022-09-14 09:14:13','894','2022-09-14 09:14:39',10,0),('1','152',257783,'DAILY SHIFT','2022-09-14','2022-09-14 09:15:03','2022-09-15 09:15:03','894',0.00,0.00,'894','2022-09-14 21:33:17','894','2022-09-14 21:34:23',10,0),('1','152',257784,'DAILY SHIFT','2022-09-15','2022-09-15 16:53:55','2022-09-16 16:53:55','894',0.00,0.00,'894','2022-09-15 21:18:10','894','2022-09-15 21:18:58',10,0),('1','152',257785,'DAILY SHIFT','2022-09-16','2022-09-16 07:18:17','2022-09-17 07:18:17','894',0.00,0.00,'894','2022-09-16 20:36:44','894','2022-09-16 20:38:15',10,0),('1','152',257786,'DAILY SHIFT','2022-09-17','2022-09-17 07:11:11','2022-09-18 07:11:11','894',0.00,0.00,'894','2022-09-17 17:33:12','894','2022-09-17 17:37:39',10,0),('1','152',257787,'DAILY SHIFT','2022-09-17','2022-09-17 20:12:30','2022-09-18 20:12:30','894',0.00,0.00,'894','2022-09-17 20:23:33','894','2022-09-17 20:24:02',10,0),('1','152',257788,'DAILY SHIFT','2022-09-18','2022-09-18 07:33:32','2022-09-19 07:33:32','894',0.00,0.00,'894','2022-09-18 20:52:11','894','2022-09-18 20:53:07',10,0),('1','152',257789,'DAILY SHIFT','2022-09-19','2022-09-19 07:04:33','2022-09-20 07:04:33','894',0.00,0.00,'894','2022-09-19 21:29:52','894','2022-09-19 21:31:08',10,0),('1','152',257790,'DAILY SHIFT','2022-09-20','2022-09-20 07:06:07','2022-09-21 07:06:07','894',0.00,0.00,'894','2022-09-20 10:23:07','894','2022-09-20 10:23:32',10,0),('1','152',257791,'DAILY SHIFT','2022-09-20','2022-09-20 10:24:14','2022-09-21 10:24:14','894',0.00,0.00,'894','2022-09-20 20:49:28','894','2022-09-20 20:50:39',10,0),('1','152',257792,'DAILY SHIFT','2022-09-21','2022-09-21 07:05:27','2022-09-22 07:05:27','894',0.00,0.00,'894','2022-09-21 20:47:10','894','2022-09-21 20:48:30',10,0),('1','152',257793,'DAILY SHIFT','2022-09-22','2022-09-22 07:00:07','2022-09-23 07:00:07','894',0.00,0.00,'894','2022-09-22 12:46:13','894','2022-09-22 13:00:28',10,0),('1','152',257794,'DAILY SHIFT','2022-09-22','2022-09-22 13:09:52','2022-09-23 13:09:52','894',0.00,0.00,'894','2022-09-22 22:15:17','894','2022-09-22 22:16:30',10,0),('1','152',257795,'DAILY SHIFT','2022-09-23','2022-09-23 07:05:10','2022-09-24 07:05:10','894',0.00,0.00,'894','2022-09-23 09:14:41','894','2022-09-23 09:15:25',10,0),('1','152',257796,'DAILY SHIFT','2022-09-23','2022-09-23 11:11:57','2022-09-24 11:11:57','894',0.00,0.00,'894','2022-09-24 06:46:56','894','2022-09-24 06:48:00',10,0),('1','152',257797,'DAILY SHIFT','2022-09-24','2022-09-24 06:48:26','2022-09-25 06:48:26','894',0.00,0.00,'894','2022-09-24 21:25:39','894','2022-09-24 21:26:59',10,0),('1','152',257798,'DAILY SHIFT','2022-09-25','2022-09-25 06:58:19','2022-09-26 06:58:19','894',0.00,0.00,'894','2022-09-25 12:30:14','894','2022-09-25 12:31:21',10,0),('1','152',257799,'DAILY SHIFT','2022-09-25','2022-09-25 12:34:29','2022-09-26 12:34:29','894',0.00,0.00,'894','2022-09-25 20:02:21','894','2022-09-25 20:03:44',10,0),('1','152',257800,'DAILY SHIFT','2022-09-26','2022-09-26 06:48:51','2022-09-27 06:48:51','894',0.00,0.00,'894','2022-09-26 21:06:21','894','2022-09-26 21:09:53',10,0),('1','152',257801,'DAILY SHIFT','2022-09-27','2022-09-27 06:52:12','2022-09-28 06:52:12','894',0.00,0.00,'894','2022-09-27 11:55:37','894','2022-09-27 11:56:22',10,0),('1','152',257802,'DAILY SHIFT','2022-09-27','2022-09-27 12:39:10','2022-09-28 12:39:10','894',0.00,0.00,'894','2022-09-27 22:48:22','894','2022-09-27 23:22:11',10,0),('1','152',257803,'DAILY SHIFT','2022-09-28','2022-09-28 06:52:45','2022-09-29 06:52:45','894',0.00,0.00,'894','2022-09-28 14:15:53','894','2022-09-28 14:16:27',10,0),('1','152',257804,'DAILY SHIFT','2022-09-28','2022-09-28 14:17:07','2022-09-29 14:17:07','894',0.00,0.00,'894','2022-09-28 21:32:46','894','2022-09-28 21:33:25',10,0),('1','152',257805,'DAILY SHIFT','2022-09-29','2022-09-29 06:55:50','2022-09-30 06:55:50','894',0.00,0.00,'894','2022-09-29 21:55:58','894','2022-09-29 21:56:43',10,0),('1','152',257806,'DAILY SHIFT','2022-09-30','2022-09-30 06:54:33','2022-10-01 06:54:33','894',0.00,0.00,'894','2022-09-30 21:36:36','894','2022-09-30 21:39:31',10,0),('1','152',257807,'DAILY SHIFT','2022-10-01','2022-10-01 07:00:08','2022-10-02 07:00:08','894',0.00,0.00,'894','2022-10-01 20:01:41','894','2022-10-01 20:04:52',10,0),('1','152',257808,'DAILY SHIFTs','2022-10-02','2022-10-02 06:49:40','2022-10-03 06:49:40','894',0.00,0.00,'894','2022-10-02 21:26:17','894','2022-10-02 21:30:31',10,0),('1','152',257809,'DAILY SHIFTs','2022-10-03','2022-10-03 06:33:42','2022-10-04 06:33:42','894',0.00,0.00,'894','2022-10-03 20:15:58','894','2022-10-04 06:49:04',10,0),('1','152',257810,'DAILY SHIFT','2022-10-04','2022-10-04 06:49:48','2022-10-05 06:49:48','894',0.00,0.00,'894','2022-10-04 22:01:51','894','2022-10-04 22:03:36',10,0),('1','152',257811,'DAILY SHIFTs','2022-10-05','2022-10-05 06:39:52','2022-10-06 06:39:52','894',0.00,0.00,'894','2022-10-05 16:35:47','894','2022-10-05 16:37:36',10,0),('1','152',257812,'DAILY SHIFT','2022-10-05','2022-10-05 16:39:55','2022-10-06 16:39:55','894',0.00,0.00,'894','2022-10-05 16:44:30','894','2022-10-05 16:45:17',10,0),('1','152',257813,'DAILY SHIFT','2022-10-05','2022-10-05 16:51:28','2022-10-06 16:51:28','894',0.00,0.00,'894','2022-10-05 20:02:31','894','2022-10-05 20:03:59',10,0),('1','152',257814,'DAILY SHIFT','2022-10-06','2022-10-06 06:37:06','2022-10-07 06:37:06','894',0.00,0.00,'894','2022-10-06 19:40:16','894','2022-10-06 19:42:27',10,0),('1','152',257815,'DAILY SHIFT','2022-10-07','2022-10-07 06:51:50','2022-10-08 06:51:50','894',0.00,0.00,'894','2022-10-07 11:22:08','894','2022-10-07 11:22:48',10,0),('1','152',257816,'DAILY SHIFT','2022-10-07','2022-10-07 11:24:34','2022-10-08 11:24:34','894',0.00,0.00,'894','2022-10-07 19:43:52','894','2022-10-07 23:47:35',10,0),('1','152',257817,'DAILY SHIFT','2022-10-08','2022-10-08 06:46:17','2022-10-09 06:46:17','894',0.00,0.00,'894','2022-10-08 11:52:49','894','2022-10-08 11:54:26',10,0),('1','152',257818,'DAILY SHIFT','2022-10-08','2022-10-08 11:57:12','2022-10-09 11:57:12','894',0.00,0.00,'894','2022-10-08 19:52:44','894','2022-10-09 06:44:46',10,0),('1','152',257819,'DAILY SHIFT','2022-10-09','2022-10-09 06:45:51','2022-10-10 06:45:51','894',0.00,0.00,'894','2022-10-09 18:35:10','894','2022-10-09 23:41:50',10,0),('1','152',257820,'DAILY SHIFT','2022-10-11','2022-10-11 15:31:34','2022-10-12 15:31:34','894',0.00,0.00,'894','2022-10-11 21:45:35','894','2022-10-11 21:46:02',10,0),('1','152',257821,'DAILY SHIFT','2022-10-12','2022-10-12 07:33:19','2022-10-13 07:33:19','894',0.00,0.00,'894','2022-10-12 21:52:06','894','2022-10-12 21:53:30',10,0),('1','152',257822,'DAILY SHIFT','2022-10-13','2022-10-13 06:54:36','2022-10-14 06:54:36','894',0.00,0.00,'894','2022-10-13 12:32:35','894','2022-10-13 12:37:49',10,0),('1','152',257823,'DAILY SHIFT','2022-10-13','2022-10-13 12:46:44','2022-10-14 12:46:44','894',0.00,0.00,'894','2022-10-13 19:48:36','894','2022-10-13 20:33:12',10,0),('1','152',257824,'DAILY SHIFT','2022-10-14','2022-10-14 06:52:31','2022-10-15 06:52:31','894',0.00,0.00,'894','2022-10-14 19:46:12','894','2022-10-14 19:48:29',10,0),('1','152',257825,'DAILY SHIFT','2022-10-15','2022-10-15 07:00:06','2022-10-16 07:00:06','894',0.00,0.00,'894','2022-10-15 09:49:14','894','2022-10-15 09:50:46',10,0),('1','152',257826,'DAILY SHIFT','2022-10-15','2022-10-15 09:54:12','2022-10-16 09:54:12','894',0.00,0.00,'894','2022-10-15 22:29:27','894','2022-10-15 22:31:28',10,0),('1','152',257827,'DAILY SHIFTs','2022-10-16','2022-10-16 06:44:13','2022-10-17 06:44:13','894',0.00,0.00,'894','2022-10-16 07:49:11','894','2022-10-16 07:49:44',10,0),('1','152',257828,'DAILY SHIFT','2022-10-16','2022-10-16 07:50:52','2022-10-17 07:50:52','894',0.00,0.00,'894','2022-10-16 20:19:12','894','2022-10-16 20:22:24',10,0),('1','152',257829,'DAILY SHIFTs','2022-10-17','2022-10-17 06:45:17','2022-10-18 06:45:17','894',0.00,0.00,'894','2022-10-17 18:12:23','894','2022-10-17 18:14:06',10,0),('1','152',257830,'DAILY SHIFT','2022-10-17','2022-10-17 19:42:41','2022-10-18 19:42:41','894',0.00,0.00,'894','2022-10-17 20:07:57','894','2022-10-17 20:08:29',10,0),('1','152',257831,'DAILY SHIFT','2022-10-18','2022-10-18 06:49:49','2022-10-19 06:49:49','894',0.00,0.00,'894','2022-10-18 17:44:36','894','2022-10-18 17:46:38',10,0),('1','152',257832,'DAILY SHIFTS ','2022-10-18','2022-10-18 21:42:22','2022-10-19 21:42:22','894',0.00,0.00,'894','2022-10-18 21:49:54','894','2022-10-18 21:50:20',10,0),('1','152',257833,'DAILY SHIFT','2022-10-19','2022-10-19 06:48:56','2022-10-20 06:48:56','894',0.00,0.00,'894','2022-10-19 21:41:41','894','2022-10-19 21:42:35',10,0),('1','152',257834,'DAILY SHIFT','2022-10-20','2022-10-20 06:39:53','2022-10-21 06:39:53','894',0.00,0.00,'894','2022-10-20 18:37:03','894','2022-10-20 18:37:46',10,0),('1','152',257835,'DAILY SHIFT','2022-10-20','2022-10-20 18:38:21','2022-10-21 18:38:21','894',0.00,0.00,'894','2022-10-20 21:51:29','894','2022-10-20 21:52:59',10,0),('1','152',257836,'DAILY SHIFT','2022-10-21','2022-10-21 06:50:40','2022-10-22 06:50:40','894',0.00,0.00,'894','2022-10-21 12:39:30','894','2022-10-21 12:41:14',10,0),('1','152',257837,'DAILY SHIFT','2022-10-22','2022-10-22 14:22:41','2022-10-23 14:22:41','894',0.00,0.00,'894','2022-10-22 19:42:44','894','2022-10-22 19:44:00',10,0),('1','152',257838,'DAILY SHIFTs','2022-10-23','2022-10-23 06:50:39','2022-10-24 06:50:39','894',0.00,0.00,'894','2022-10-23 19:44:45','894','2022-10-23 19:50:19',10,0),('1','152',257839,'DAILY SHIFTs','2022-10-24','2022-10-24 06:46:53','2022-10-25 06:46:53','894',0.00,0.00,'894','2022-10-24 09:16:02','894','2022-10-24 09:16:28',10,0),('1','152',257840,'DAILY SHIFT','2022-10-24','2022-10-24 09:16:54','2022-10-25 09:16:54','894',0.00,0.00,'894','2022-10-24 19:50:37','894','2022-10-24 19:51:28',10,0),('1','152',257841,'DAILY SHIFT','2022-10-25','2022-10-25 06:48:06','2022-10-26 06:48:06','894',0.00,0.00,'894','2022-10-25 20:08:44','894','2022-10-25 20:10:13',10,0),('1','152',257842,'DAILY SHIFT','2022-10-26','2022-10-26 06:39:23','2022-10-27 06:39:23','894',0.00,0.00,'894','2022-10-26 09:27:58','894','2022-10-26 09:28:36',10,0),('1','152',257843,'DAILY SHIFT','2022-10-26','2022-10-26 09:29:05','2022-10-27 09:29:05','894',0.00,0.00,'894','2022-10-26 19:35:32','894','2022-10-26 19:36:43',10,0),('1','152',257844,'DAILY SHIFT','2022-10-27','2022-10-27 06:53:12','2022-10-28 06:53:12','894',0.00,0.00,'894','2022-10-27 13:48:16','894','2022-10-27 13:49:42',10,0),('1','152',257845,'DAILY SHIFT','2022-10-27','2022-10-27 14:42:10','2022-10-28 14:42:10','894',0.00,0.00,'894','2022-10-27 23:27:12','894','2022-10-27 23:27:42',10,0),('1','152',257846,'DAILY SHIFT','2022-10-28','2022-10-28 06:43:12','2022-10-29 06:43:12','894',0.00,0.00,'894','2022-10-28 18:36:28','894','2022-10-28 18:38:41',10,0),('1','152',257847,'DAILY SHIFT','2022-10-31','2022-10-31 13:17:57','2022-11-01 13:17:57','894',0.00,0.00,'894','2022-10-31 19:43:19','894','2022-10-31 19:44:32',10,0),('1','152',257848,'DAILY SHIFT','2022-11-01','2022-11-01 06:46:42','2022-11-02 06:46:42','894',0.00,0.00,'894','2022-11-01 22:52:03','894','2022-11-01 22:52:54',10,0),('1','152',257849,'DAILY SHIFT','2022-11-01','2022-11-01 22:56:18','2022-11-02 22:56:18','894',0.00,0.00,'894','2022-11-01 23:02:20','894','2022-11-01 23:03:11',10,0),('1','152',257850,'DAILY SHIFT','2022-11-02','2022-11-02 07:29:52','2022-11-03 07:29:52','894',0.00,0.00,'894','2022-11-02 19:57:18','894','2022-11-02 19:58:18',10,0),('1','152',257851,'DAILY SHIFT','2022-11-03','2022-11-03 06:42:47','2022-11-04 06:42:47','894',0.00,0.00,'894','2022-11-03 21:51:06','894','2022-11-03 21:52:40',10,0),('1','152',257852,'DAILY SHIFT','2022-11-05','2022-11-05 09:46:44','2022-11-06 09:46:44','894',0.00,0.00,'894','2022-11-05 21:02:37','894','2022-11-05 22:26:35',10,0),('1','152',257853,'DAILY SHIFT','2022-11-06','2022-11-06 09:29:56','2022-11-07 09:29:56','894',0.00,0.00,'894','2022-11-06 11:20:22','894','2022-11-06 11:21:27',10,0),('1','152',257854,'DAILY SHIFT','2022-11-06','2022-11-06 11:38:54','2022-11-07 11:38:54','894',0.00,0.00,'894','2022-11-06 19:43:38','894','2022-11-06 19:47:47',10,0),('1','152',257855,'DAILY SHIFT','2022-11-07','2022-11-07 06:52:42','2022-11-08 06:52:42','894',0.00,0.00,'894','2022-11-07 18:55:03','894','2022-11-07 18:56:33',10,0),('1','152',257856,'DAILY SHIFT','2022-11-07','2022-11-07 18:59:08','2022-11-08 18:59:08','894',0.00,0.00,'894','2022-11-07 20:48:59','894','2022-11-07 20:52:32',10,0),('1','152',257857,'DAILY SHIFT','2022-11-08','2022-11-08 07:08:20','2022-11-09 07:08:20','894',0.00,0.00,'894','2022-11-08 20:02:13','894','2022-11-08 20:04:44',10,0),('1','152',257858,'DAILY SHIFT','2022-11-09','2022-11-09 06:55:29','2022-11-10 06:55:29','894',0.00,0.00,'894','2022-11-09 18:54:11','894','2022-11-09 19:08:03',10,0),('1','152',257859,'DAILY SHIFT','2022-11-09','2022-11-09 19:13:47','2022-11-10 19:13:47','894',0.00,0.00,'894','2022-11-09 20:52:27','894','2022-11-09 20:53:01',10,0),('1','152',257860,'DAILY SHIFT','2022-11-10','2022-11-10 06:51:11','2022-11-11 06:51:11','894',0.00,0.00,'894','2022-11-10 21:12:04','894','2022-11-10 21:13:43',10,0),('1','152',257861,'DAILY SHIFT','2022-11-11','2022-11-11 06:45:08','2022-11-12 06:45:08','894',0.00,0.00,'894','2022-11-11 19:44:04','894','2022-11-11 22:38:53',10,0),('1','152',257862,'DAILY SHIFT','2022-11-12','2022-11-12 06:51:57','2022-11-13 06:51:57','894',0.00,0.00,'894','2022-11-12 21:51:59','894','2022-11-12 21:53:07',10,0),('1','152',257863,'DAILY SHIFT','2022-11-13','2022-11-13 06:51:08','2022-11-14 06:51:08','894',0.00,0.00,'894','2022-11-13 11:00:16','894','2022-11-13 11:01:50',10,0),('1','152',257864,'DAILY SHIFT','2022-11-13','2022-11-13 11:02:21','2022-11-14 11:02:21','894',0.00,0.00,'894','2022-11-13 13:40:39','894','2022-11-13 13:42:10',10,0),('1','152',257865,'DAILY SHIFT','2022-11-13','2022-11-13 13:46:33','2022-11-14 13:46:33','894',0.00,0.00,'894','2022-11-13 21:26:40','894','2022-11-13 21:27:50',10,0),('1','152',257866,'DAILY SHIFTs','2022-11-14','2022-11-14 07:02:23','2022-11-15 07:02:23','894',0.00,0.00,'894','2022-11-14 19:55:12','894','2022-11-14 19:56:35',10,0),('1','152',257867,'DAILY SHIFT','2022-11-15','2022-11-15 06:45:28','2022-11-16 06:45:28','894',0.00,0.00,'894','2022-11-15 16:38:15','894','2022-11-15 16:40:29',10,0),('1','152',257868,'DAILY SHIFT','2022-11-15','2022-11-15 16:44:13','2022-11-16 16:44:13','894',0.00,0.00,'894','2022-11-15 20:45:23','894','2022-11-15 20:45:49',10,0),('1','152',257869,'DAILY SHIFT','2022-11-16','2022-11-16 06:57:21','2022-11-17 06:57:21','894',0.00,0.00,'894','2022-11-16 20:47:28','894','2022-11-16 20:49:31',10,0),('1','152',257870,'DAILY SHIFT','2022-11-17','2022-11-17 06:47:27','2022-11-18 06:47:27','894',0.00,0.00,'894','2022-11-17 19:38:15','894','2022-11-17 19:39:12',10,0),('1','152',257871,'DAILY SHIFTs','2022-11-18','2022-11-18 06:51:48','2022-11-19 06:51:48','894',0.00,0.00,'894','2022-11-18 11:24:16','894','2022-11-18 11:26:40',10,0),('1','152',257872,'DAILY SHIFTs','2022-11-18','2022-11-18 11:34:19','2022-11-19 11:34:19','894',0.00,0.00,'894','2022-11-18 22:08:23','894','2022-11-18 22:08:50',10,0),('1','152',257873,'DAILY SHIFTs','2022-11-19','2022-11-19 06:46:14','2022-11-20 06:46:14','894',0.00,0.00,'894','2022-11-19 20:26:01','894','2022-11-19 20:28:40',10,0),('1','152',257874,'DAILY SHIFT','2022-11-20','2022-11-20 07:01:23','2022-11-21 07:01:23','894',0.00,0.00,'894','2022-11-20 14:35:41','894','2022-11-20 14:36:24',10,0),('1','152',257875,'DAILY SHIFT','2022-11-20','2022-11-20 14:37:23','2022-11-21 14:37:23','894',0.00,0.00,'894','2022-11-20 22:44:24','894','2022-11-20 22:46:33',10,0),('1','152',257876,'DAILY SHIFT','2022-11-21','2022-11-21 07:26:24','2022-11-22 07:26:24','894',0.00,0.00,'894','2022-11-21 19:54:16','894','2022-11-21 19:56:00',10,0),('1','152',257877,'DAILY SHIFT','2022-11-22','2022-11-22 06:56:10','2022-11-23 06:56:10','894',0.00,0.00,'894','2022-11-22 16:01:08','894','2022-11-22 16:02:15',10,0),('1','152',257878,'DAILY SHIFT','2022-11-22','2022-11-22 16:05:22','2022-11-23 16:05:22','894',0.00,0.00,'894','2022-11-22 19:54:53','894','2022-11-22 19:55:39',10,0),('1','152',257879,'DAILY SHIFT','2022-11-23','2022-11-23 07:05:35','2022-11-24 07:05:35','894',0.00,0.00,'894','2022-11-23 10:45:16','894','2022-11-23 10:45:49',10,0),('1','152',257880,'DAILY','2022-11-23','2022-11-23 10:49:18','2022-11-24 10:49:18','894',0.00,0.00,'894','2022-11-23 23:06:03','894','2022-11-23 23:07:02',10,0),('1','152',257881,'DAILY SHIFT','2022-11-24','2022-11-24 06:55:23','2022-11-25 06:55:23','894',0.00,0.00,'894','2022-11-24 21:24:51','894','2022-11-24 21:26:17',10,0),('1','152',257882,'DAILY SHIFT','2022-11-25','2022-11-25 07:04:38','2022-11-26 07:04:38','894',0.00,0.00,'894','2022-11-25 21:59:34','894','2022-11-25 22:01:27',10,0),('1','152',257883,'DAILY SHIFT','2022-11-26','2022-11-26 07:22:31','2022-11-27 07:22:31','894',0.00,0.00,'894','2022-11-26 22:22:49','894','2022-11-26 22:24:07',10,0),('1','152',257884,'DAILY SHIFT','2022-11-27','2022-11-27 06:57:25','2022-11-28 06:57:25','894',0.00,0.00,'894','2022-11-27 19:57:24','894','2022-11-27 19:59:40',10,0),('1','152',257885,'DAILY SHIFT','2022-11-28','2022-11-28 07:19:22','2022-11-29 07:19:22','894',0.00,0.00,'894','2022-11-28 20:09:19','894','2022-11-28 20:11:25',10,0),('1','152',257886,'DAILY SHIFT','2022-11-29','2022-11-29 06:59:31','2022-11-30 06:59:31','894',0.00,0.00,'894','2022-11-29 22:07:02','894','2022-11-29 22:09:08',10,0),('1','152',257887,'DAILY SHIFT','2022-11-30','2022-11-30 06:55:41','2022-12-01 06:55:41','894',0.00,0.00,'894','2022-11-30 19:15:51','894','2022-11-30 19:20:21',10,0),('1','152',257888,'DAILY SHIFT','2022-11-30','2022-11-30 19:22:00','2022-12-01 19:22:00','894',0.00,0.00,'894','2022-11-30 19:27:34','894','2022-11-30 22:49:57',10,0),('1','152',257889,'DAILY SHIFT','2022-12-01','2022-12-01 07:29:30','2022-12-02 07:29:30','894',0.00,0.00,'894','2022-12-01 20:27:42','894','2022-12-01 20:29:33',10,0),('1','152',257890,'DAILY SHIFT','2022-12-02','2022-12-02 07:01:35','2022-12-03 07:01:35','894',0.00,0.00,'894','2022-12-02 20:56:57','894','2022-12-02 20:58:35',10,0),('1','152',257891,'DAILY SHIFT','2022-12-03','2022-12-03 06:58:57','2022-12-04 06:58:57','894',0.00,0.00,'894','2022-12-03 21:02:58','894','2022-12-03 21:04:20',10,0),('1','152',257892,'DAILY SHIFT','2022-12-04','2022-12-04 07:01:09','2022-12-05 07:01:09','894',0.00,0.00,'894','2022-12-04 23:47:00','894','2022-12-04 23:50:33',10,0),('1','152',257893,'DAILY SHIFTs','2022-12-05','2022-12-05 07:04:00','2022-12-06 07:04:00','894',0.00,0.00,'894','2022-12-06 00:24:14','894','2022-12-06 00:24:54',10,0),('1','152',257894,'DAILY SHIFT','2022-12-06','2022-12-06 06:51:14','2022-12-07 06:51:14','894',0.00,0.00,'894','2022-12-06 19:55:48','894','2022-12-06 19:57:32',10,0),('1','152',257895,'DAILY SHIFT','2022-12-07','2022-12-07 07:12:31','2022-12-08 07:12:31','894',0.00,0.00,'894','2022-12-07 10:47:31','894','2022-12-07 10:48:38',10,0),('1','152',257896,'DAILY SHIFTS ','2022-12-07','2022-12-07 10:50:04','2022-12-08 10:50:04','894',0.00,0.00,'894','2022-12-07 10:58:03','894','2022-12-07 10:58:32',10,0),('1','152',257897,'DAILY SHIFTS ','2022-12-07','2022-12-07 11:04:06','2022-12-08 11:04:06','894',0.00,0.00,'894','2022-12-07 21:13:31','894','2022-12-07 21:14:35',10,0),('1','152',257898,'DAILY SHIFT','2022-12-08','2022-12-08 07:03:42','2022-12-09 07:03:42','894',0.00,0.00,'894','2022-12-08 20:47:45','894','2022-12-08 20:49:15',10,0),('1','152',257899,'DAILY SHIFTs','2022-12-09','2022-12-09 07:04:03','2022-12-10 07:04:03','894',0.00,0.00,'894','2022-12-09 20:07:51','894','2022-12-09 20:08:47',10,0),('1','152',257900,'DAILY SHIFT','2022-12-10','2022-12-10 07:01:56','2022-12-11 07:01:56','894',0.00,0.00,'894','2022-12-10 22:04:20','894','2022-12-10 22:05:42',10,0),('1','152',257901,'DAILY SHIFT','2022-12-11','2022-12-11 06:57:19','2022-12-12 06:57:19','894',0.00,0.00,'894','2022-12-11 20:58:36','894','2022-12-11 20:59:27',10,0),('1','152',257902,'DAILY SHIFT','2022-12-12','2022-12-12 07:00:46','2022-12-13 07:00:46','894',0.00,0.00,'894','2022-12-12 21:45:36','894','2022-12-12 21:46:58',10,0),('1','152',257903,'DAILY SHIFT','2022-12-13','2022-12-13 06:54:31','2022-12-14 06:54:31','894',0.00,0.00,'894','2022-12-13 19:51:27','894','2022-12-13 19:52:12',10,0),('1','152',257904,'DAILY SHIFTs','2022-12-14','2022-12-14 07:01:31','2022-12-15 07:01:31','894',0.00,0.00,'894','2022-12-14 17:04:55','894','2022-12-14 17:06:29',10,0),('1','152',257905,'DAILY SHIFT','2022-12-14','2022-12-14 17:20:22','2022-12-15 17:20:22','894',0.00,0.00,'894','2022-12-14 22:19:41','894','2022-12-14 22:20:46',10,0),('1','152',257906,'DAILY SHIFT','2022-12-15','2022-12-15 07:01:43','2022-12-16 07:01:43','894',0.00,0.00,'894','2022-12-15 21:07:35','894','2022-12-15 21:09:46',10,0),('1','152',257907,'DAILY SHIFT','2022-12-16','2022-12-16 07:02:26','2022-12-17 07:02:26','894',0.00,0.00,'894','2022-12-16 20:03:39','894','2022-12-16 20:05:21',10,0),('1','152',257908,'DAILY SHIFT','2022-12-17','2022-12-17 07:25:34','2022-12-18 07:25:34','894',0.00,0.00,'894','2022-12-17 22:40:08','894','2022-12-17 22:53:58',10,0),('1','152',257909,'DAILY SHIFTs','2022-12-18','2022-12-18 07:13:25','2022-12-19 07:13:25','894',0.00,0.00,'894','2022-12-18 20:57:03','894','2022-12-18 20:58:10',10,0),('1','152',257910,'DAILY SHIFTS','2022-12-19','2022-12-19 07:00:07','2022-12-20 07:00:07','894',0.00,0.00,'894','2022-12-19 21:01:57','894','2022-12-19 21:03:03',10,0),('1','152',257911,'DAILY SHIFT','2022-12-20','2022-12-20 07:15:20','2022-12-21 07:15:20','894',0.00,0.00,'894','2022-12-20 20:17:54','894','2022-12-20 21:19:06',10,0),('1','152',257912,'DAILY SHIFT','2022-12-21','2022-12-21 07:04:12','2022-12-22 07:04:12','894',0.00,0.00,'894','2022-12-21 20:19:21','894','2022-12-21 20:20:37',10,0),('1','152',257913,'DAILY SHIFT','2022-12-22','2022-12-22 07:05:14','2022-12-23 07:05:14','894',0.00,0.00,'894','2022-12-22 14:56:22','894','2022-12-22 14:57:06',10,0),('1','152',257914,'DAILY SHIFT','2022-12-22','2022-12-22 14:57:24','2022-12-23 14:57:24','894',0.00,0.00,'894','2022-12-22 15:01:44','894','2022-12-22 15:02:15',10,0),('1','152',257915,'DAILY SHIFT','2022-12-22','2022-12-22 15:10:34','2022-12-23 15:10:34','894',0.00,0.00,'894','2022-12-22 20:16:08','894','2022-12-22 20:16:34',10,0),('1','152',257916,'DAILY SHIFT','2022-12-23','2022-12-23 07:15:53','2022-12-24 07:15:53','894',0.00,0.00,'894','2022-12-23 21:44:23','894','2022-12-23 21:45:57',10,0),('1','152',257917,'DAILY SHIFTs','2022-12-24','2022-12-24 07:15:07','2022-12-25 07:15:07','894',0.00,0.00,'894','2022-12-24 10:30:33','894','2022-12-24 10:31:48',10,0),('1','152',257918,'DAILY SHIFT','2022-12-24','2022-12-24 11:01:40','2022-12-25 11:01:40','894',0.00,0.00,'894','2022-12-24 17:10:11','894','2022-12-24 17:11:52',10,0),('1','152',257919,'DAILY SHIFT','2022-12-24','2022-12-24 18:07:17','2022-12-25 18:07:17','894',0.00,0.00,'894','2022-12-24 20:47:40','894','2022-12-24 20:48:09',10,0),('1','152',257920,'DAILY SHIFT','2022-12-25','2022-12-25 07:43:08','2022-12-26 07:43:08','894',0.00,0.00,'894','2022-12-25 21:47:10','894','2022-12-25 21:48:34',10,0),('1','152',257921,'DAILY SHIFTs','2022-12-26','2022-12-26 07:24:05','2022-12-27 07:24:05','894',0.00,0.00,'894','2022-12-26 11:14:00','894','2022-12-26 11:14:42',10,0),('1','152',257922,'DAILY SHIFTS ','2022-12-26','2022-12-26 11:20:22','2022-12-27 11:20:22','894',0.00,0.00,'894','2022-12-26 19:49:00','894','2022-12-26 19:49:41',10,0),('1','152',257923,'DAILY SHIFT','2022-12-27','2022-12-27 07:11:51','2022-12-28 07:11:51','894',0.00,0.00,'894','2022-12-27 20:42:44','894','2022-12-27 20:43:32',10,0),('1','152',257924,'DAILY SHIFT','2022-12-28','2022-12-28 07:20:50','2022-12-29 07:20:50','894',0.00,0.00,'894','2022-12-28 14:53:01','894','2022-12-28 14:54:12',10,0),('1','152',257925,'DAILY SHIFT','2022-12-28','2022-12-28 15:05:21','2022-12-29 15:05:21','894',0.00,0.00,'894','2022-12-28 19:36:45','894','2022-12-28 19:37:52',10,0),('1','152',257926,'DAILY SHIFT','2022-12-29','2022-12-29 07:21:34','2022-12-30 07:21:34','894',0.00,0.00,'894','2022-12-29 22:51:47','894','2022-12-29 22:53:14',10,0),('1','152',257927,'DAILY SHIFT','2022-12-30','2022-12-30 07:18:02','2022-12-31 07:18:02','894',0.00,0.00,'894','2022-12-30 20:06:31','894','2022-12-30 20:07:28',10,0),('1','152',257928,'DAILY SHIFT','2022-12-31','2022-12-31 09:33:57','2023-01-01 09:33:57','894',0.00,0.00,'894','2022-12-31 19:48:26','894','2022-12-31 19:49:15',10,0),('1','152',257929,'DAILY SHIFTs','2023-01-01','2023-01-01 07:21:02','2023-01-02 07:21:02','894',0.00,0.00,'894','2023-01-01 20:04:03','894','2023-01-01 20:07:01',10,0),('1','152',257930,'DAILY SHIFT','2023-01-02','2023-01-02 07:31:30','2023-01-03 07:31:30','894',0.00,0.00,'894','2023-01-02 21:58:42','894','2023-01-02 22:00:05',10,0),('1','152',257931,'DAILY SHIFT','2023-01-03','2023-01-03 07:23:36','2023-01-04 07:23:36','894',0.00,0.00,'894','2023-01-04 00:29:49','894','2023-01-04 00:30:40',10,0),('1','152',257932,'DAILY SHIFT','2023-01-04','2023-01-04 07:20:40','2023-01-05 07:20:40','894',0.00,0.00,'894','2023-01-04 16:35:47','894','2023-01-04 16:36:45',10,0),('1','152',257933,'DAILY SHIFT','2023-01-04','2023-01-04 16:38:13','2023-01-05 16:38:13','894',0.00,0.00,'894','2023-01-04 16:46:10','894','2023-01-04 16:46:41',10,0),('1','152',257934,'DAILY SHIFT','2023-01-04','2023-01-04 16:54:28','2023-01-05 16:54:28','894',0.00,0.00,'894','2023-01-04 21:17:02','894','2023-01-04 21:17:50',10,0),('1','152',257935,'DAILY SHIFT','2023-01-05','2023-01-05 07:17:38','2023-01-06 07:17:38','894',0.00,0.00,'894','2023-01-05 19:52:09','894','2023-01-05 19:52:42',10,0),('1','152',257936,'DAILY SHIFT','2023-01-06','2023-01-06 07:28:34','2023-01-07 07:28:34','894',0.00,0.00,'894','2023-01-06 19:45:15','894','2023-01-06 19:46:37',10,0),('1','152',257937,'DAILY SHIFT','2023-01-07','2023-01-07 07:23:22','2023-01-08 07:23:22','894',0.00,0.00,'894','2023-01-07 23:06:51','894','2023-01-07 23:08:32',10,0),('1','152',257938,'DAILY SHIFT','2023-01-08','2023-01-08 07:35:51','2023-01-09 07:35:51','894',0.00,0.00,'894','2023-01-08 23:31:15','894','2023-01-08 23:32:28',10,0),('1','152',257939,'DAILY SHIFT','2023-01-09','2023-01-09 07:11:38','2023-01-10 07:11:38','894',0.00,0.00,'894','2023-01-09 22:04:47','894','2023-01-09 22:05:34',10,0),('1','152',257940,'DAILY SHIFT','2023-01-10','2023-01-10 07:16:11','2023-01-11 07:16:11','894',0.00,0.00,'894','2023-01-10 21:18:19','894','2023-01-10 21:19:36',10,0),('1','152',257941,'DAILY SHIFT','2023-01-11','2023-01-11 07:21:10','2023-01-12 07:21:10','894',0.00,0.00,'894','2023-01-11 18:35:40','894','2023-01-11 18:37:20',10,0),('1','152',257942,'DAILY SHIFT','2023-01-11','2023-01-11 18:43:16','2023-01-12 18:43:16','894',0.00,0.00,'894','2023-01-11 18:47:38','894','2023-01-11 18:48:17',10,0),('1','152',257943,'DAILY SHIFT','2023-01-12','2023-01-12 07:53:26','2023-01-13 07:53:26','894',0.00,0.00,'894','2023-01-12 22:05:14','894','2023-01-12 22:06:26',10,0),('1','152',257944,'DAILY SHIFT','2023-01-13','2023-01-13 07:25:50','2023-01-14 07:25:50','894',0.00,0.00,'894','2023-01-13 22:01:17','894','2023-01-13 22:02:07',10,0),('1','152',257945,'DAILY SHIFT','2023-01-14','2023-01-14 07:18:57','2023-01-15 07:18:57','894',0.00,0.00,'894','2023-01-14 22:09:59','894','2023-01-14 22:12:30',10,0),('1','152',257946,'DAILY SHIFTS ','2023-01-15','2023-01-15 06:32:32','2023-01-16 06:32:32','894',0.00,0.00,'894','2023-01-15 21:15:16','894','2023-01-15 21:16:04',10,0),('1','152',257947,'DAILY SHIFT','2023-01-16','2023-01-16 07:16:10','2023-01-17 07:16:10','894',0.00,0.00,'894','2023-01-16 22:31:42','894','2023-01-16 22:32:28',10,0),('1','152',257948,'DAILY SHIFT','2023-01-17','2023-01-17 07:19:28','2023-01-18 07:19:28','894',0.00,0.00,'894','2023-01-17 19:56:45','894','2023-01-17 19:57:51',10,0),('1','152',257949,'DAILY SHIFT','2023-01-18','2023-01-18 07:25:01','2023-01-19 07:25:01','894',0.00,0.00,'894','2023-01-18 17:51:08','894','2023-01-18 17:52:10',10,0),('1','152',257950,'DAILY SHIFT','2023-01-18','2023-01-18 17:52:31','2023-01-19 17:52:31','894',0.00,0.00,'894','2023-01-18 17:57:38','894','2023-01-18 17:58:03',10,0),('1','152',257951,'DAILY SHIFT','2023-01-18','2023-01-18 18:03:44','2023-01-19 18:03:44','894',0.00,0.00,'894','2023-01-18 19:55:02','894','2023-01-18 19:55:30',10,0),('1','152',257952,'DAILY SHIFTS','2023-01-19','2023-01-19 07:15:49','2023-01-20 07:15:49','894',0.00,0.00,'894','2023-01-19 21:05:44','894','2023-01-19 21:07:34',10,0),('1','152',257953,'DAILY SHIFT','2023-01-20','2023-01-20 07:07:20','2023-01-21 07:07:20','894',0.00,0.00,'894','2023-01-20 16:35:00','894','2023-01-20 16:35:59',10,0),('1','152',257954,'DAILY SHIFT','2023-01-20','2023-01-20 16:36:24','2023-01-21 16:36:24','894',0.00,0.00,'894','2023-01-20 19:40:49','894','2023-01-20 19:42:04',10,0),('1','152',257955,'DAILY SHIFT','2023-01-21','2023-01-21 07:07:04','2023-01-22 07:07:04','894',0.00,0.00,'894','2023-01-21 19:48:25','894','2023-01-21 19:50:20',10,0),('1','152',257956,'DAILY SHIFT','2023-01-22','2023-01-22 07:27:37','2023-01-23 07:27:37','894',0.00,0.00,'894','2023-01-22 15:52:54','894','2023-01-22 15:54:22',10,0),('1','152',257957,'DAILY SHIFT','2023-01-22','2023-01-22 15:58:35','2023-01-23 15:58:35','894',0.00,0.00,'894','2023-01-22 21:32:42','894','2023-01-22 21:33:17',10,0),('1','152',257958,'DAILY SHIFT','2023-01-23','2023-01-23 07:11:46','2023-01-24 07:11:46','894',0.00,0.00,'894','2023-01-23 19:31:48','894','2023-01-23 19:32:38',10,0),('1','152',257959,'DAILY SHIFT','2023-01-24','2023-01-24 07:31:32','2023-01-25 07:31:32','894',0.00,0.00,'894','2023-01-24 10:00:08','894','2023-01-24 10:00:35',10,0),('1','152',257960,'DAILY SHIFTS ','2023-01-24','2023-01-24 10:17:14','2023-01-25 10:17:14','894',0.00,0.00,'894','2023-01-24 10:28:15','894','2023-01-24 10:28:49',10,0),('1','152',257961,'DAILY SHIFTS ','2023-01-24','2023-01-24 10:32:26','2023-01-25 10:32:26','894',0.00,0.00,'894','2023-01-24 20:29:18','894','2023-01-24 20:30:47',10,0),('1','152',257962,'DAILY SHIFT','2023-01-25','2023-01-25 07:15:12','2023-01-26 07:15:12','894',0.00,0.00,'894','2023-01-25 22:51:53','894','2023-01-25 22:54:22',10,0),('1','152',257963,'DAILY SHIFT','2023-01-26','2023-01-26 07:18:18','2023-01-27 07:18:18','894',0.00,0.00,'894','2023-01-26 22:14:55','894','2023-01-26 22:16:11',10,0),('1','152',257964,'DAILY SHIFT','2023-01-27','2023-01-27 07:31:27','2023-01-28 07:31:27','894',0.00,0.00,'894','2023-01-27 20:23:33','894','2023-01-27 20:25:05',10,0),('1','152',257965,'DAILY SHIFT','2023-01-28','2023-01-28 08:34:17','2023-01-29 08:34:17','894',0.00,0.00,'894','2023-01-28 23:14:53','894','2023-01-28 23:16:17',10,0),('1','152',257966,'DAILY SHIFTS ','2023-01-28','2023-01-28 23:42:46','2023-01-29 23:42:46','894',0.00,0.00,'894','2023-01-28 23:51:46','894','2023-01-28 23:52:22',10,0),('1','152',257967,'DAILY SHIFT','2023-01-29','2023-01-29 07:21:44','2023-01-30 07:21:44','894',0.00,0.00,'894','2023-01-29 22:05:31','894','2023-01-29 22:06:26',10,0),('1','152',257968,'DAILY SHIFT','2023-01-30','2023-01-30 07:21:25','2023-01-31 07:21:25','894',0.00,0.00,'894','2023-01-30 20:21:47','894','2023-01-30 20:25:06',10,0),('1','152',257969,'DAILY SHIFT','2023-01-31','2023-01-31 07:11:40','2023-02-01 07:11:40','894',0.00,0.00,'894','2023-01-31 20:27:32','894','2023-01-31 20:28:03',10,0),('1','152',257970,'DAILY SHIFT','2023-02-01','2023-02-01 07:19:02','2023-02-02 07:19:02','894',0.00,0.00,'894','2023-02-01 23:11:03','894','2023-02-01 23:13:48',10,0),('1','152',257971,'DAILY SHIFT','2023-02-02','2023-02-02 07:21:55','2023-02-03 07:21:55','894',0.00,0.00,'894','2023-02-02 21:19:31','894','2023-02-02 21:20:22',10,0),('1','152',257972,'DAILY SHIFTS ','2023-02-02','2023-02-02 22:45:39','2023-02-03 22:45:39','894',0.00,0.00,'894','2023-02-02 23:10:39','894','2023-02-02 23:11:06',10,0),('1','152',257973,'DAILY SHIFTS ','2023-02-02','2023-02-02 23:15:53','2023-02-03 23:15:53','894',0.00,0.00,'894','2023-02-02 23:21:47','894','2023-02-02 23:22:16',10,0),('1','152',257974,'DAILY SHIFT','2023-02-03','2023-02-03 07:13:11','2023-02-04 07:13:11','894',0.00,0.00,'894','2023-02-03 22:51:27','894','2023-02-03 22:52:50',10,0),('1','152',257975,'DAILY SHIFT','2023-02-04','2023-02-04 07:25:56','2023-02-05 07:25:56','894',0.00,0.00,'894','2023-02-04 20:42:39','894','2023-02-04 20:43:53',10,0),('1','152',257976,'DAILY SHIFT','2023-02-05','2023-02-05 07:26:10','2023-02-06 07:26:10','894',0.00,0.00,'894','2023-02-05 22:23:19','894','2023-02-05 22:25:00',10,0),('1','152',257977,'DAILY SHIFTs','2023-02-06','2023-02-06 07:25:05','2023-02-07 07:25:05','894',0.00,0.00,'894','2023-02-06 22:18:10','894','2023-02-06 22:18:43',10,0),('1','152',257978,'DAILY SHIFT','2023-02-07','2023-02-07 07:37:43','2023-02-08 07:37:43','894',0.00,0.00,'894','2023-02-07 22:27:17','894','2023-02-07 22:28:33',10,0),('1','152',257979,'DAILY SHIFT','2023-02-08','2023-02-08 07:23:15','2023-02-09 07:23:15','894',0.00,0.00,'894','2023-02-08 20:35:32','894','2023-02-08 20:36:36',10,0),('1','152',257980,'DAILY SHIFT','2023-02-09','2023-02-09 07:18:29','2023-02-10 07:18:29','894',0.00,0.00,'894','2023-02-09 20:34:41','894','2023-02-09 20:36:54',10,0),('1','152',257981,'DAILY SHIFT','2023-02-10','2023-02-10 07:28:25','2023-02-11 07:28:25','894',0.00,0.00,'894','2023-02-10 22:01:22','894','2023-02-10 22:01:55',10,0),('1','152',257982,'DAILY SHIFT','2023-02-11','2023-02-11 07:22:14','2023-02-12 07:22:14','894',0.00,0.00,'894','2023-02-11 19:42:49','894','2023-02-11 19:45:42',10,0),('1','152',257983,'DAILY SHIFT','2023-02-12','2023-02-12 07:23:09','2023-02-13 07:23:09','894',0.00,0.00,'894','2023-02-12 19:53:59','894','2023-02-12 19:55:14',10,0),('1','152',257984,'DAILY SHIFT','2023-02-13','2023-02-13 07:18:38','2023-02-14 07:18:38','894',0.00,0.00,'894','2023-02-13 12:12:31','894','2023-02-13 12:14:46',10,0),('1','152',257985,'DAILY SHIFT','2023-02-13','2023-02-13 13:31:56','2023-02-14 13:31:56','894',0.00,0.00,'894','2023-02-13 13:47:46','894','2023-02-13 13:48:22',10,0),('1','152',257986,'DAILY SHIFT','2023-02-13','2023-02-13 14:12:56','2023-02-14 14:12:56','894',0.00,0.00,'894','2023-02-13 20:16:45','894','2023-02-13 20:23:23',10,0),('1','152',257987,'DAILY SHIFT','2023-02-14','2023-02-14 07:19:23','2023-02-15 07:19:23','894',0.00,0.00,'894','2023-02-14 20:30:41','894','2023-02-14 20:31:30',10,0),('1','152',257988,'DAILY SHIFT','2023-02-15','2023-02-15 07:23:05','2023-02-16 07:23:05','894',0.00,0.00,'894','2023-02-15 19:57:15','894','2023-02-15 19:59:26',10,0),('1','152',257989,'DAILY SHIFT','2023-02-16','2023-02-16 07:46:39','2023-02-17 07:46:39','894',0.00,0.00,'894','2023-02-16 20:09:04','894','2023-02-16 20:10:02',10,0),('1','152',257990,'DAILY SHIFT','2023-02-17','2023-02-17 07:16:17','2023-02-18 07:16:17','894',0.00,0.00,'894','2023-02-17 20:03:08','894','2023-02-17 20:09:37',10,0),('1','152',257991,'DAILY SHIFT','2023-02-18','2023-02-18 07:37:28','2023-02-19 07:37:28','894',0.00,0.00,'894','2023-02-18 20:13:35','894','2023-02-18 20:14:45',10,0),('1','152',257992,'DAILY SHIFT','2023-02-19','2023-02-19 07:33:01','2023-02-20 07:33:01','894',0.00,0.00,'894','2023-02-19 20:03:27','894','2023-02-19 20:04:40',10,0),('1','152',257993,'DAILY SHIFT','2023-02-20','2023-02-20 07:33:12','2023-02-21 07:33:12','894',0.00,0.00,'894','2023-02-21 07:07:38','894','2023-02-21 07:08:30',10,0),('1','152',257994,'DAILY SHIFT','2023-02-21','2023-02-21 07:08:49','2023-02-22 07:08:49','894',0.00,0.00,'894','2023-02-21 20:41:48','894','2023-02-21 20:44:03',10,0),('1','152',257995,'DAILY SHIFT','2023-02-22','2023-02-22 07:22:21','2023-02-23 07:22:21','894',0.00,0.00,'894','2023-02-22 20:29:25','894','2023-02-22 20:31:09',10,0),('1','152',257996,'DAILY SHIFT','2023-02-23','2023-02-23 07:07:29','2023-02-24 07:07:29','894',0.00,0.00,'894','2023-02-23 20:50:04','894','2023-02-23 20:50:48',10,0),('1','152',257997,'DAILY SHIFT','2023-02-24','2023-02-24 07:20:19','2023-02-25 07:20:19','894',0.00,0.00,'894','2023-02-24 21:24:45','894','2023-02-24 21:25:25',10,0),('1','152',257998,'DAILY SHIFT','2023-02-24','2023-02-24 21:27:15','2023-02-25 21:27:15','894',0.00,0.00,'894','2023-02-24 21:31:37','894','2023-02-24 21:32:02',10,0),('1','152',257999,'DAILY SHIFT','2023-02-24','2023-02-24 21:42:55','2023-02-25 21:42:55','894',0.00,0.00,'894','2023-02-24 21:50:57','894','2023-02-24 21:51:20',10,0),('1','152',258000,'DAILY SHIFT','2023-02-26','2023-02-26 07:26:40','2023-02-27 07:26:40','894',0.00,0.00,'894','2023-02-26 19:37:50','894','2023-02-26 19:38:16',10,0),('1','152',258001,'DAILY SHIFT','2023-02-27','2023-02-27 07:35:39','2023-02-28 07:35:39','894',0.00,0.00,'894','2023-02-27 19:37:28','894','2023-02-27 19:38:57',10,0),('1','152',258002,'DAILY SHIFT','2023-02-28','2023-02-28 07:40:12','2023-03-01 07:40:12','894',0.00,0.00,'894','2023-02-28 19:54:52','894','2023-02-28 19:55:19',10,0),('1','152',258003,'DAILY SHIFT','2023-03-01','2023-03-01 07:16:29','2023-03-02 07:16:29','894',0.00,0.00,'894','2023-03-01 19:58:19','894','2023-03-01 19:59:16',10,0),('1','152',258004,'DAILY SHIFT','2023-03-02','2023-03-02 07:16:11','2023-03-03 07:16:11','894',0.00,0.00,'894','2023-03-02 20:19:46','894','2023-03-02 20:20:16',10,0),('1','152',258005,'DAILY SHIFT','2023-03-03','2023-03-03 07:15:26','2023-03-04 07:15:26','894',0.00,0.00,'894','2023-03-03 20:16:43','894','2023-03-03 20:17:45',10,0),('1','152',258006,'DAILY SHIFT','2023-03-04','2023-03-04 07:19:57','2023-03-05 07:19:57','894',0.00,0.00,'894','2023-03-04 20:02:12','894','2023-03-04 20:02:49',10,0),('1','152',258007,'DAILY SHIFT','2023-03-05','2023-03-05 07:15:20','2023-03-06 07:15:20','894',0.00,0.00,'894','2023-03-05 19:05:43','894','2023-03-05 19:07:02',10,0),('1','152',258008,'DAILY SHIFT','2023-03-05','2023-03-05 19:12:05','2023-03-06 19:12:05','894',0.00,0.00,'894','2023-03-05 19:17:44','894','2023-03-05 19:18:52',10,0),('1','152',258009,'DAILY SHIFT','2023-03-05','2023-03-05 19:23:15','2023-03-06 19:23:15','894',0.00,0.00,'894','2023-03-05 19:41:45','894','2023-03-05 19:42:37',10,0),('1','152',258010,'DAILY SHIFT','2023-03-06','2023-03-06 07:22:51','2023-03-07 07:22:51','894',0.00,0.00,'894','2023-03-06 20:20:18','894','2023-03-06 20:21:17',10,0),('1','152',258011,'DAILY SHIFT','2023-03-07','2023-03-07 07:02:30','2023-03-08 07:02:30','894',0.00,0.00,'894','2023-03-07 20:44:02','894','2023-03-07 20:45:25',10,0),('1','152',258012,'DAILY SHIFT','2023-03-08','2023-03-08 07:20:05','2023-03-09 07:20:05','894',0.00,0.00,'894','2023-03-08 08:15:42','894','2023-03-08 08:16:05',10,0),('1','152',258013,'DAILY SHIFTS ','2023-03-08','2023-03-08 08:26:33','2023-03-09 08:26:33','894',0.00,0.00,'894','2023-03-08 19:50:44','894','2023-03-08 19:51:27',10,0),('1','152',258014,'DAILY SHIFTs','2023-03-09','2023-03-09 06:51:46','2023-03-10 06:51:46','894',0.00,0.00,'894','2023-03-09 20:56:08','894','2023-03-09 20:59:06',10,0),('1','152',258015,'DAILY SHIFT','2023-03-10','2023-03-10 08:33:00','2023-03-11 08:33:00','894',0.00,0.00,'894','2023-03-10 19:45:13','894','2023-03-10 19:45:59',10,0),('1','152',258016,'DAILY SHIFT','2023-03-11','2023-03-11 07:13:28','2023-03-12 07:13:28','894',0.00,0.00,'894','2023-03-11 20:04:30','894','2023-03-11 20:06:13',10,0),('1','152',258017,'DAILY SHIFT','2023-03-12','2023-03-12 07:19:56','2023-03-13 07:19:56','894',0.00,0.00,'894','2023-03-12 12:19:21','894','2023-03-12 12:19:51',10,0),('1','152',258018,'DAILY SHIFT','2023-03-12','2023-03-12 12:25:32','2023-03-13 12:25:32','894',0.00,0.00,'894','2023-03-12 13:57:49','894','2023-03-12 13:58:23',10,0),('1','152',258019,'DAILY SHIFTs','2023-03-12','2023-03-12 14:42:45','2023-03-13 14:42:45','894',0.00,0.00,'894','2023-03-12 20:12:47','894','2023-03-12 20:13:33',10,0),('1','152',258020,'DAILY SHIFT','2023-03-13','2023-03-13 06:51:16','2023-03-14 06:51:16','894',0.00,0.00,'894','2023-03-13 23:22:07','894','2023-03-13 23:24:12',10,0),('1','152',258021,'DAILY SHIFT','2023-03-14','2023-03-14 07:19:35','2023-03-15 07:19:35','894',0.00,0.00,'894','2023-03-14 21:12:54','894','2023-03-14 21:13:24',10,0),('1','152',258022,'DAILY SHIFT','2023-03-15','2023-03-15 07:10:58','2023-03-16 07:10:58','894',0.00,0.00,'894','2023-03-15 12:55:45','894','2023-03-15 12:57:44',10,0),('1','152',258023,'DAILY SHIFT','2023-03-15','2023-03-15 13:03:04','2023-03-16 13:03:04','894',0.00,0.00,'894','2023-03-15 20:35:14','894','2023-03-15 20:36:23',10,0),('1','152',258024,'DAILY SHIFT','2023-03-16','2023-03-16 07:09:52','2023-03-17 07:09:52','894',0.00,0.00,'894','2023-03-16 20:23:57','894','2023-03-16 20:24:58',10,0),('1','152',258025,'DAILY SHIFT','2023-03-17','2023-03-17 07:11:26','2023-03-18 07:11:26','894',0.00,0.00,'894','2023-03-17 20:17:06','894','2023-03-17 20:19:32',10,0),('1','152',258026,'DAILY SHIFT','2023-03-19','2023-03-19 07:58:17','2023-03-20 07:58:17','894',0.00,0.00,'894','2023-03-19 17:27:22','894','2023-03-19 17:29:17',10,0),('1','152',258027,'DAILY SHIFT','2023-03-20','2023-03-20 07:24:50','2023-03-21 07:24:50','894',0.00,0.00,'894','2023-03-20 08:52:04','894','2023-03-20 08:52:30',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905624 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','152','757','143130',2864879,'2123','316',663560.07,666294.78,0.00,0.00,2734.71,700085.76,0.00,0.00,0.00),('1','152','757','143130',2864880,'2124','316',1444334.67,1445996.67,0.00,0.00,1662.00,355668.00,0.00,0.00,0.00),('1','152','757','143151',2865231,'2123','316',665622.45,666251.24,0.00,0.00,628.79,160970.24,0.00,0.00,0.00),('1','152','757','143151',2865232,'2124','316',1447167.80,1447842.36,0.00,0.00,674.56,155803.36,0.00,0.00,0.00),('1','152','757','143242',2866945,'2123','316',666251.24,666251.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143242',2866946,'2124','316',1447842.36,1447908.36,0.00,0.00,66.00,14124.00,0.00,0.00,0.00),('1','152','757','143251',2867134,'2123','316',666251.24,667469.61,0.00,0.00,1218.37,311902.72,0.00,0.00,0.00),('1','152','757','143251',2867135,'2124','316',1447908.36,1449938.14,0.00,0.00,2029.78,487751.56,0.00,0.00,0.00),('1','152','757','143256',2867239,'2123','316',667469.61,668361.29,0.00,0.00,891.68,228270.08,0.00,0.00,0.00),('1','152','757','143256',2867240,'2124','316',1449938.14,1451498.97,0.00,0.00,1560.83,344475.62,0.00,0.00,0.00),('1','152','757','143270',2867438,'2123','316',668361.29,668361.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143270',2867439,'2124','316',1451498.97,1451584.97,0.00,0.00,86.00,22016.00,0.00,0.00,0.00),('1','152','757','143279',2867614,'2123','316',668361.29,669272.49,0.00,0.00,911.20,233267.20,0.00,0.00,0.00),('1','152','757','143279',2867615,'2124','316',1451584.97,1453882.60,0.00,0.00,2297.63,525039.14,0.00,0.00,0.00),('1','152','757','143285',2867698,'2123','316',669272.49,669272.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143285',2867699,'2124','316',1453882.60,1453882.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143290',2867778,'2123','316',669272.49,670548.60,0.00,0.00,1276.11,326684.16,0.00,0.00,0.00),('1','152','757','143290',2867779,'2124','316',1453882.60,1455074.17,0.00,0.00,1191.57,269551.92,0.00,0.00,0.00),('1','152','757','143549',2873060,'2123','316',670548.60,670548.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143549',2873061,'2124','316',1455074.17,1455074.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143568',2873360,'2123','316',670548.60,672290.42,0.00,0.00,1741.82,445905.92,0.00,0.00,0.00),('1','152','757','143568',2873361,'2124','316',1455074.17,1457445.85,0.00,0.00,2371.68,520933.74,0.00,0.00,0.00),('1','152','757','143577',2873485,'2123','316',672290.42,673030.63,0.00,0.00,740.21,189493.76,0.00,0.00,0.00),('1','152','757','143577',2873486,'2124','316',1457445.85,1458206.14,0.00,0.00,760.29,173982.84,0.00,0.00,0.00),('1','152','757','143650',2875130,'2123','316',673030.63,673752.35,0.00,0.00,721.72,184760.32,0.00,0.00,0.00),('1','152','757','143650',2875131,'2124','316',1458206.14,1458720.74,0.00,0.00,514.60,110124.40,0.00,0.00,0.00),('1','152','757','143692',2875967,'2123','316',673752.35,673752.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','143692',2875968,'2124','316',1458720.74,1458894.29,0.00,0.00,173.55,44428.80,0.00,0.00,0.00),('1','152','757','143698',2876051,'2123','316',673752.35,674656.99,0.00,0.00,904.64,231587.84,0.00,0.00,0.00),('1','152','757','143698',2876052,'2124','316',1458894.29,1460638.84,0.00,0.00,1744.55,395973.80,0.00,0.00,0.00),('1','152','757','143705',2876153,'2123','316',674656.99,675876.26,0.00,0.00,1219.27,312133.12,0.00,0.00,0.00),('1','152','757','143705',2876154,'2124','316',1460638.84,1462483.67,0.00,0.00,1844.83,419272.48,0.00,0.00,0.00),('1','152','757','144095',2883976,'2123','316',675876.26,676744.58,0.00,0.00,868.32,222289.92,0.00,0.00,0.00),('1','152','757','144095',2883977,'2124','316',1462483.67,1464489.83,0.00,0.00,2006.16,483042.96,0.00,0.00,0.00),('1','152','757','146805',2936898,'2123','316',676744.58,676744.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','146805',2936899,'2124','316',1464489.83,1464489.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','146807',2936902,'2123','316',676744.58,676937.48,0.00,0.00,192.90,49382.40,0.00,0.00,0.00),('1','152','757','146807',2936903,'2124','316',1464489.83,1464958.33,0.00,0.00,468.50,95917.24,0.00,0.00,0.00),('1','152','757','147797',2953145,'2123','316',676937.48,678605.82,0.00,0.00,1668.34,427095.04,0.00,0.00,0.00),('1','152','757','147797',2953146,'2124','316',1464259.96,1465833.88,0.00,0.00,1573.92,363729.12,0.00,0.00,0.00),('1','152','757','147806',2953310,'2123','316',678605.82,679396.14,0.00,0.00,790.32,202321.92,0.00,0.00,0.00),('1','152','757','147806',2953311,'2124','316',1465833.88,1467517.82,0.00,0.00,1683.94,419752.24,0.00,0.00,0.00),('1','152','757','148106',2958441,'2123','316',679396.14,679975.86,0.00,0.00,579.72,148408.32,0.00,0.00,0.00),('1','152','757','148106',2958442,'2124','316',1467517.82,1468117.11,0.00,0.00,599.29,147488.64,0.00,0.00,0.00),('1','152','757','148171',2959524,'2123','316',679975.86,681136.57,0.00,0.00,1160.71,297141.76,0.00,0.00,0.00),('1','152','757','148171',2959525,'2124','316',1468117.11,1469181.41,0.00,0.00,1064.30,260924.80,0.00,0.00,0.00),('1','152','757','148177',2959690,'2123','316',681136.57,682199.41,0.00,0.00,1062.84,272087.04,0.00,0.00,0.00),('1','152','757','148177',2959691,'2124','316',1469181.41,1469678.60,0.00,0.00,497.19,122280.64,0.00,0.00,0.00),('1','152','757','148181',2959778,'2123','316',682199.41,682605.57,0.00,0.00,406.16,103976.96,0.00,0.00,0.00),('1','152','757','148181',2959779,'2124','316',1469678.60,1470065.55,0.00,0.00,386.95,96155.20,0.00,0.00,0.00),('1','152','757','148230',2960671,'2123','316',682605.57,683558.66,0.00,0.00,953.09,243991.04,0.00,0.00,0.00),('1','152','757','148230',2960672,'2124','316',1470065.55,1471610.65,0.00,0.00,1545.10,372752.00,0.00,0.00,0.00),('1','152','757','148248',2961036,'2123','316',683558.66,683608.11,0.00,0.00,49.45,12659.20,0.00,0.00,0.00),('1','152','757','148248',2961037,'2124','316',1471610.65,1471691.23,0.00,0.00,80.58,20380.00,0.00,0.00,0.00),('1','152','757','148252',2961078,'2123','316',683608.11,685819.19,0.00,0.00,2211.08,610258.08,0.00,0.00,0.00),('1','152','757','148252',2961079,'2124','316',1471691.23,1474002.58,0.00,0.00,2311.35,579572.60,0.00,0.00,0.00),('1','152','757','148255',2961098,'2123','316',685819.19,686392.25,0.00,0.00,573.06,158164.56,0.00,0.00,0.00),('1','152','757','148255',2961099,'2124','316',1474002.58,1474513.95,0.00,0.00,511.37,128238.12,0.00,0.00,0.00),('1','152','757','148379',2963157,'2123','316',686392.25,687499.31,0.00,0.00,1107.06,305548.56,0.00,0.00,0.00),('1','152','757','148379',2963158,'2124','316',1474513.95,1477104.65,0.00,0.00,2590.70,641173.20,0.00,0.00,0.00),('1','152','757','148382',2963172,'2123','316',687499.31,688329.34,0.00,0.00,830.03,229088.28,0.00,0.00,0.00),('1','152','757','148382',2963173,'2124','316',1477104.65,1478300.85,0.00,0.00,1196.20,313755.20,0.00,0.00,0.00),('1','152','757','148506',2965303,'2123','316',688329.34,689037.97,0.00,0.00,708.63,195581.88,0.00,0.00,0.00),('1','152','757','148506',2965304,'2124','316',1478300.85,1479874.48,0.00,0.00,1573.63,394183.88,0.00,0.00,0.00),('1','152','757','148514',2965427,'2123','316',689037.97,689594.62,0.00,0.00,556.65,153635.40,0.00,0.00,0.00),('1','152','757','148514',2965428,'2124','316',1479874.48,1480333.65,0.00,0.00,459.17,123510.92,0.00,0.00,0.00),('1','152','757','148538',2965946,'2123','316',689594.62,691405.73,0.00,0.00,1811.11,499866.36,0.00,0.00,0.00),('1','152','757','148538',2965947,'2124','316',1480333.65,1483198.56,0.00,0.00,2864.91,711775.16,0.00,0.00,0.00),('1','152','757','148598',2966926,'2123','316',691405.73,691723.38,0.00,0.00,317.65,87671.40,0.00,0.00,0.00),('1','152','757','148598',2966927,'2124','316',1483198.56,1483879.30,0.00,0.00,680.74,172171.44,0.00,0.00,0.00),('1','152','757','148601',2966974,'2123','316',691723.38,693362.13,0.00,0.00,1638.75,452295.00,0.00,0.00,0.00),('1','152','757','148601',2966975,'2124','316',1483879.30,1486383.70,0.00,0.00,2504.40,643246.40,0.00,0.00,0.00),('1','152','757','148609',2967151,'2123','316',693362.13,693634.14,0.00,0.00,272.01,75074.76,0.00,0.00,0.00),('1','152','757','148609',2967152,'2124','316',1486383.70,1486678.95,0.00,0.00,295.25,74175.00,0.00,0.00,0.00),('1','152','757','148613',2967199,'2123','316',693634.14,694801.43,0.00,0.00,1167.29,322172.04,0.00,0.00,0.00),('1','152','757','148613',2967200,'2124','316',1486678.95,1488096.25,0.00,0.00,1417.30,359848.80,0.00,0.00,0.00),('1','152','757','148617',2967246,'2123','316',694801.43,696597.58,0.00,0.00,1796.15,495737.40,0.00,0.00,0.00),('1','152','757','148617',2967247,'2124','316',1488096.25,1490200.39,0.00,0.00,2104.14,553257.64,0.00,0.00,0.00),('1','152','757','148623',2967325,'2123','316',696597.58,697568.71,0.00,0.00,971.13,268031.88,0.00,0.00,0.00),('1','152','757','148623',2967326,'2124','316',1490200.39,1491362.02,0.00,0.00,1161.63,286821.50,0.00,0.00,0.00),('1','152','757','148634',2967512,'2123','316',697568.71,699871.01,0.00,0.00,2302.30,635434.80,0.00,0.00,0.00),('1','152','757','148634',2967513,'2124','316',1491362.02,1494814.92,0.00,0.00,3452.90,843497.40,0.00,0.00,0.00),('1','152','757','148638',2967570,'2123','316',699871.01,700858.67,0.00,0.00,987.66,272594.16,0.00,0.00,0.00),('1','152','757','148638',2967571,'2124','316',1494814.92,1495805.80,0.00,0.00,990.88,260625.88,0.00,0.00,0.00),('1','152','757','148734',2969204,'2123','316',700858.67,702932.80,0.00,0.00,2074.13,572459.88,0.00,0.00,0.00),('1','152','757','148734',2969205,'2124','316',1495805.80,1497664.99,0.00,0.00,1859.19,478943.72,0.00,0.00,0.00),('1','152','757','148747',2969396,'2123','316',702932.80,703522.57,0.00,0.00,589.77,162776.52,0.00,0.00,0.00),('1','152','757','148747',2969397,'2124','316',1497664.99,1498781.12,0.00,0.00,1116.13,284062.88,0.00,0.00,0.00),('1','152','757','148755',2969516,'2123','316',703522.57,704316.33,0.00,0.00,793.76,219077.76,0.00,0.00,0.00),('1','152','757','148755',2969517,'2124','316',1498781.12,1499867.58,0.00,0.00,1086.46,272653.96,0.00,0.00,0.00),('1','152','757','148757',2969568,'2123','316',704316.33,705981.95,0.00,0.00,1665.62,426398.72,0.00,0.00,0.00),('1','152','757','148757',2969569,'2124','316',1499867.58,1502043.23,0.00,0.00,2175.65,529471.40,0.00,0.00,0.00),('1','152','757','148761',2969638,'2123','316',705981.95,706906.36,0.00,0.00,924.41,236648.96,0.00,0.00,0.00),('1','152','757','148761',2969639,'2124','316',1502043.23,1503318.74,0.00,0.00,1275.51,311502.56,0.00,0.00,0.00),('1','152','757','148762',2969640,'2123','316',706906.36,709281.38,0.00,0.00,2375.02,608005.12,0.00,0.00,0.00),('1','152','757','148762',2969641,'2124','316',1503318.74,1506665.86,0.00,0.00,3347.12,804823.72,0.00,0.00,0.00),('1','152','757','148765',2969693,'2123','316',709281.38,711722.47,0.00,0.00,2441.09,624919.04,0.00,0.00,0.00),('1','152','757','148765',2969694,'2124','316',1506665.86,1509975.87,0.00,0.00,3310.01,790715.06,0.00,0.00,0.00),('1','152','757','148766',2969695,'2123','316',711722.47,712670.94,0.00,0.00,948.47,242808.32,0.00,0.00,0.00),('1','152','757','148766',2969696,'2124','316',1509975.87,1511324.18,0.00,0.00,1348.31,315579.36,0.00,0.00,0.00),('1','152','757','148771',2969797,'2123','316',712670.94,715369.35,0.00,0.00,2698.41,690792.96,0.00,0.00,0.00),('1','152','757','148771',2969798,'2124','316',1511324.18,1514822.87,0.00,0.00,3498.69,829416.64,0.00,0.00,0.00),('1','152','757','148774',2969881,'2123','316',715369.35,717895.72,0.00,0.00,2526.37,646750.72,0.00,0.00,0.00),('1','152','757','148774',2969882,'2124','316',1514822.87,1518038.32,0.00,0.00,3215.45,781371.90,0.00,0.00,0.00),('1','152','757','148777',2969911,'2123','316',717895.72,718922.64,0.00,0.00,1026.92,262891.52,0.00,0.00,0.00),('1','152','757','148777',2969912,'2124','316',1518038.32,1519054.71,0.00,0.00,1016.39,240946.22,0.00,0.00,0.00),('1','152','757','148784',2970009,'2123','316',718922.64,721575.99,0.00,0.00,2653.35,679257.60,0.00,0.00,0.00),('1','152','757','148784',2970010,'2124','316',1519054.71,1522195.33,0.00,0.00,3140.62,738830.50,0.00,0.00,0.00),('1','152','757','148789',2970053,'2123','316',721575.99,724547.12,0.00,0.00,2971.13,753459.28,0.00,0.00,0.00),('1','152','757','148789',2970054,'2124','316',1522195.33,1525928.23,0.00,0.00,3732.90,880827.16,0.00,0.00,0.00),('1','152','757','148869',2971399,'2123','316',724547.12,726937.32,0.00,0.00,2390.20,611891.20,0.00,0.00,0.00),('1','152','757','148869',2971400,'2124','316',1525928.23,1529309.18,0.00,0.00,3380.95,784515.00,0.00,0.00,0.00),('1','152','757','148874',2971474,'2123','316',726937.32,728851.07,0.00,0.00,1913.75,462674.08,0.00,0.00,0.00),('1','152','757','148874',2971475,'2124','316',1529309.18,1531406.12,0.00,0.00,2096.94,482296.20,0.00,0.00,0.00),('1','152','757','148879',2971548,'2123','316',728851.07,729788.01,0.00,0.00,936.94,239856.64,0.00,0.00,0.00),('1','152','757','148879',2971549,'2124','316',1531406.12,1532449.39,0.00,0.00,1043.27,244886.12,0.00,0.00,0.00),('1','152','757','148888',2971720,'2123','316',729788.01,730697.66,0.00,0.00,909.65,232870.40,0.00,0.00,0.00),('1','152','757','148888',2971721,'2124','316',1532449.39,1533848.10,0.00,0.00,1398.71,328652.84,0.00,0.00,0.00),('1','152','757','148894',2971795,'2123','316',730697.66,732248.91,0.00,0.00,1551.25,397120.00,0.00,0.00,0.00),('1','152','757','148894',2971796,'2124','316',1533848.10,1536374.12,0.00,0.00,2526.02,605334.12,0.00,0.00,0.00),('1','152','757','148898',2971846,'2123','316',732248.91,734278.45,0.00,0.00,2029.54,519562.24,0.00,0.00,0.00),('1','152','757','148898',2971847,'2124','316',1536374.12,1539332.24,0.00,0.00,2958.12,726221.72,0.00,0.00,0.00),('1','152','757','148902',2971901,'2123','316',734278.45,734744.55,0.00,0.00,466.10,119321.60,0.00,0.00,0.00),('1','152','757','148902',2971902,'2124','316',1539332.24,1540123.99,0.00,0.00,791.75,183188.00,0.00,0.00,0.00),('1','152','757','148906',2971965,'2123','316',734744.55,736412.67,0.00,0.00,1668.12,427038.72,0.00,0.00,0.00),('1','152','757','148906',2971966,'2124','316',1540123.99,1542417.18,0.00,0.00,2293.19,552838.82,0.00,0.00,0.00),('1','152','757','148907',2971967,'2123','316',736412.67,736934.24,0.00,0.00,521.57,133521.92,0.00,0.00,0.00),('1','152','757','148907',2971968,'2124','316',1542417.18,1543692.85,0.00,0.00,1275.67,296269.56,0.00,0.00,0.00),('1','152','757','149021',2974333,'2123','316',736934.24,738117.86,0.00,0.00,1183.62,303006.72,0.00,0.00,0.00),('1','152','757','149021',2974334,'2124','316',1543692.85,1545033.27,0.00,0.00,1340.42,322152.52,0.00,0.00,0.00),('1','152','757','149039',2974803,'2123','316',738117.86,740833.42,0.00,0.00,2715.56,695183.36,0.00,0.00,0.00),('1','152','757','149039',2974804,'2124','316',1545033.27,1548201.11,0.00,0.00,3167.84,753026.04,0.00,0.00,0.00),('1','152','757','149045',2974920,'2123','316',740833.42,742463.88,0.00,0.00,1630.46,417397.76,0.00,0.00,0.00),('1','152','757','149045',2974921,'2124','316',1548201.11,1550103.32,0.00,0.00,1902.21,460133.76,0.00,0.00,0.00),('1','152','757','149053',2975088,'2123','316',742463.88,743329.76,0.00,0.00,865.88,221665.28,0.00,0.00,0.00),('1','152','757','149053',2975089,'2124','316',1550103.32,1551436.71,0.00,0.00,1333.39,333388.46,0.00,0.00,0.00),('1','152','757','149108',2976242,'2123','316',743329.76,744423.92,0.00,0.00,1094.16,280104.96,0.00,0.00,0.00),('1','152','757','149108',2976243,'2124','316',1551436.71,1552883.33,0.00,0.00,1446.62,353083.72,0.00,0.00,0.00),('1','152','757','149112',2976295,'2123','316',744423.92,745578.65,0.00,0.00,1154.73,295610.88,0.00,0.00,0.00),('1','152','757','149112',2976296,'2124','316',1552883.33,1554810.24,0.00,0.00,1926.91,452559.96,0.00,0.00,0.00),('1','152','757','149196',2977871,'2123','316',745578.65,746547.70,0.00,0.00,969.05,248076.80,0.00,0.00,0.00),('1','152','757','149196',2977872,'2124','316',1554810.24,1555914.90,0.00,0.00,1104.66,269428.96,0.00,0.00,0.00),('1','152','757','149208',2978085,'2123','316',746547.70,747962.74,0.00,0.00,1415.04,362250.24,0.00,0.00,0.00),('1','152','757','149208',2978086,'2124','316',1555914.90,1558384.51,0.00,0.00,2469.61,572707.84,0.00,0.00,0.00),('1','152','757','149214',2978178,'2123','316',747962.74,750068.14,0.00,0.00,2105.40,538982.40,0.00,0.00,0.00),('1','152','757','149214',2978179,'2124','316',1558384.51,1561535.86,0.00,0.00,3151.35,751664.60,0.00,0.00,0.00),('1','152','757','149217',2978208,'2123','316',750068.14,750880.37,0.00,0.00,812.23,207930.88,0.00,0.00,0.00),('1','152','757','149217',2978209,'2124','316',1561535.86,1562797.31,0.00,0.00,1261.45,298920.20,0.00,0.00,0.00),('1','152','757','149219',2978226,'2123','316',750880.37,752483.08,0.00,0.00,1602.71,410293.76,0.00,0.00,0.00),('1','152','757','149219',2978227,'2124','316',1562797.31,1564891.10,0.00,0.00,2093.79,511205.72,0.00,0.00,0.00),('1','152','757','149226',2978380,'2123','316',752483.08,754081.92,0.00,0.00,1598.84,409303.04,0.00,0.00,0.00),('1','152','757','149226',2978381,'2124','316',1564891.10,1567042.41,0.00,0.00,2151.31,524254.36,0.00,0.00,0.00),('1','152','757','149229',2978408,'2123','316',754081.92,755066.12,0.00,0.00,984.20,251955.20,0.00,0.00,0.00),('1','152','757','149229',2978409,'2124','316',1567042.41,1568106.69,0.00,0.00,1064.28,260040.68,0.00,0.00,0.00),('1','152','757','149233',2978457,'2123','316',755066.12,757324.85,0.00,0.00,2258.73,578234.88,0.00,0.00,0.00),('1','152','757','149233',2978458,'2124','316',1568106.69,1571609.34,0.00,0.00,3502.65,820627.36,0.00,0.00,0.00),('1','152','757','149238',2978521,'2123','316',757324.85,758041.38,0.00,0.00,716.53,183431.68,0.00,0.00,0.00),('1','152','757','149238',2978522,'2124','316',1571609.34,1572405.05,0.00,0.00,795.71,202011.76,0.00,0.00,0.00),('1','152','757','149244',2978596,'2123','316',758041.38,759446.67,0.00,0.00,1405.29,359754.24,0.00,0.00,0.00),('1','152','757','149244',2978597,'2124','316',1572405.05,1574720.77,0.00,0.00,2315.72,562989.32,0.00,0.00,0.00),('1','152','757','149247',2978640,'2123','316',759446.67,759661.08,0.00,0.00,214.41,54888.96,0.00,0.00,0.00),('1','152','757','149247',2978641,'2124','316',1574720.77,1574961.48,0.00,0.00,240.71,61396.34,0.00,0.00,0.00),('1','152','757','149251',2978694,'2123','316',759661.08,761163.53,0.00,0.00,1502.45,384627.20,0.00,0.00,0.00),('1','152','757','149251',2978695,'2124','316',1574961.48,1577332.87,0.00,0.00,2371.39,585331.52,0.00,0.00,0.00),('1','152','757','149254',2978730,'2123','316',761163.53,761654.02,0.00,0.00,490.49,125565.44,0.00,0.00,0.00),('1','152','757','149254',2978731,'2124','316',1577332.87,1578218.23,0.00,0.00,885.36,206346.16,0.00,0.00,0.00),('1','152','757','149257',2978766,'2123','316',761654.02,762899.35,0.00,0.00,1245.33,318804.48,0.00,0.00,0.00),('1','152','757','149257',2978767,'2124','316',1578218.23,1579983.21,0.00,0.00,1764.98,420678.56,0.00,0.00,0.00),('1','152','757','149259',2978786,'2123','316',762899.35,764203.39,0.00,0.00,1304.04,333834.24,0.00,0.00,0.00),('1','152','757','149259',2978787,'2124','316',1579983.21,1581402.91,0.00,0.00,1419.70,345568.20,0.00,0.00,0.00),('1','152','757','149266',2978902,'2123','316',764203.39,764763.63,0.00,0.00,560.24,143421.44,0.00,0.00,0.00),('1','152','757','149266',2978903,'2124','316',1581402.91,1582262.44,0.00,0.00,859.53,203932.68,0.00,0.00,0.00),('1','152','757','149269',2978943,'2123','316',764763.63,766364.27,0.00,0.00,1600.64,409763.84,0.00,0.00,0.00),('1','152','757','149269',2978944,'2124','316',1582262.44,1584947.33,0.00,0.00,2684.89,648838.84,0.00,0.00,0.00),('1','152','757','149272',2979006,'2123','316',766364.27,768771.52,0.00,0.00,2407.25,616256.00,0.00,0.00,0.00),('1','152','757','149272',2979007,'2124','316',1584947.33,1588065.97,0.00,0.00,3118.64,744070.32,0.00,0.00,0.00),('1','152','757','149343',2980259,'2123','316',768771.52,771201.57,0.00,0.00,2430.05,622092.80,0.00,0.00,0.00),('1','152','757','149343',2980260,'2124','316',1588065.97,1591447.51,0.00,0.00,3381.54,793069.24,0.00,0.00,0.00),('1','152','757','149348',2980316,'2123','316',771201.57,773004.12,0.00,0.00,1802.55,461452.80,0.00,0.00,0.00),('1','152','757','149348',2980317,'2124','316',1591447.51,1593992.27,0.00,0.00,2544.76,598106.56,0.00,0.00,0.00),('1','152','757','149350',2980319,'2123','316',773004.12,773602.80,0.00,0.00,598.68,153262.08,0.00,0.00,0.00),('1','152','757','149350',2980320,'2124','316',1593992.27,1594756.04,0.00,0.00,763.77,192873.12,0.00,0.00,0.00),('1','152','757','149376',2980750,'2123','316',773602.80,774472.07,0.00,0.00,869.27,222533.12,0.00,0.00,0.00),('1','152','757','149376',2980751,'2124','316',1594756.04,1595576.90,0.00,0.00,820.86,198167.16,0.00,0.00,0.00),('1','152','757','149382',2980839,'2123','316',774472.07,776337.11,0.00,0.00,1865.04,477450.24,0.00,0.00,0.00),('1','152','757','149382',2980840,'2124','316',1595576.90,1597611.39,0.00,0.00,2034.49,495323.44,0.00,0.00,0.00),('1','152','757','149385',2980880,'2123','316',776337.11,777231.30,0.00,0.00,894.19,228912.64,0.00,0.00,0.00),('1','152','757','149385',2980881,'2124','316',1597611.39,1598558.17,0.00,0.00,946.78,234718.68,0.00,0.00,0.00),('1','152','757','149640',2985238,'2123','316',777231.30,777894.37,0.00,0.00,663.07,169745.92,0.00,0.00,0.00),('1','152','757','149640',2985239,'2124','316',1598558.17,1599666.54,0.00,0.00,1108.37,266517.72,0.00,0.00,0.00),('1','152','757','149641',2985240,'2123','316',777894.37,779848.93,0.00,0.00,1954.56,500367.36,0.00,0.00,0.00),('1','152','757','149641',2985241,'2124','316',1599666.54,1601683.25,0.00,0.00,2016.71,492232.44,0.00,0.00,0.00),('1','152','757','149773',2987464,'2123','316',779848.93,782409.75,0.00,0.00,2560.82,655569.92,0.00,0.00,0.00),('1','152','757','149773',2987465,'2124','316',1601683.25,1604872.16,0.00,0.00,3188.91,763462.14,0.00,0.00,0.00),('1','152','757','149778',2987581,'2123','316',782409.75,785068.27,0.00,0.00,2658.52,680581.12,0.00,0.00,0.00),('1','152','757','149778',2987582,'2124','316',1604872.16,1607622.04,0.00,0.00,2749.88,667933.28,0.00,0.00,0.00),('1','152','757','149784',2987683,'2123','316',785068.27,785769.80,0.00,0.00,701.53,179591.68,0.00,0.00,0.00),('1','152','757','149784',2987684,'2124','316',1607622.04,1608631.09,0.00,0.00,1009.05,236060.80,0.00,0.00,0.00),('1','152','757','149932',2990172,'2123','316',785769.80,788084.60,0.00,0.00,2314.80,592588.80,0.00,0.00,0.00),('1','152','757','149932',2990173,'2124','316',1608631.09,1612009.58,0.00,0.00,3378.49,797748.44,0.00,0.00,0.00),('1','152','757','150071',2993070,'2123','316',788084.60,790922.72,0.00,0.00,2838.12,726558.72,0.00,0.00,0.00),('1','152','757','150071',2993071,'2124','316',1612009.58,1614918.59,0.00,0.00,2909.01,702664.04,0.00,0.00,0.00),('1','152','757','150258',2996280,'2123','316',790922.72,793671.25,0.00,0.00,2748.53,703623.68,0.00,0.00,0.00),('1','152','757','150258',2996281,'2124','316',1614918.59,1617945.99,0.00,0.00,3027.40,726758.40,0.00,0.00,0.00),('1','152','757','150493',3000736,'2123','316',793671.25,795379.69,0.00,0.00,1708.44,437360.64,0.00,0.00,0.00),('1','152','757','150493',3000737,'2124','316',1617945.99,1619902.09,0.00,0.00,1956.10,468027.60,0.00,0.00,0.00),('1','152','757','150647',3003818,'2123','316',795379.69,797613.72,0.00,0.00,2234.03,571911.68,0.00,0.00,0.00),('1','152','757','150647',3003819,'2124','316',1619902.09,1623454.92,0.00,0.00,3552.83,846438.60,0.00,0.00,0.00),('1','152','757','150898',3008434,'2123','316',797613.72,799856.04,0.00,0.00,2242.32,574033.92,0.00,0.00,0.00),('1','152','757','150898',3008435,'2124','316',1623454.92,1626978.31,0.00,0.00,3523.39,825417.84,0.00,0.00,0.00),('1','152','757','150939',3009256,'2123','316',799856.04,802436.25,0.00,0.00,2580.21,660533.76,0.00,0.00,0.00),('1','152','757','150939',3009257,'2124','316',1626978.31,1630171.22,0.00,0.00,3192.91,752413.04,0.00,0.00,0.00),('1','152','757','151050',3011162,'2123','316',802436.25,802436.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','151050',3011163,'2124','316',1630171.22,1633198.62,0.00,0.00,3027.40,720909.96,0.00,0.00,0.00),('1','152','757','151055',3011268,'2123','316',803331.41,0.00,0.00,0.00,19.38,4961.28,0.00,0.00,0.00),('1','152','757','151055',3011269,'2124','316',1631219.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','152518',3038568,'2123','316',804353.95,804802.64,0.00,0.00,448.69,114864.64,0.00,0.00,0.00),('1','152','757','152518',3038569,'2124','316',1632375.68,1633767.18,0.00,0.00,1391.50,332888.76,0.00,0.00,0.00),('1','152','757','153681',3059532,'2123','316',804802.64,807460.38,0.00,0.00,2657.74,680381.44,0.00,0.00,0.00),('1','152','757','153681',3059533,'2124','316',1633767.18,1636886.91,0.00,0.00,3119.73,742947.12,0.00,0.00,0.00),('1','152','757','153687',3059611,'2123','316',807460.38,808236.99,0.00,0.00,776.61,198812.16,0.00,0.00,0.00),('1','152','757','153687',3059612,'2124','316',1636886.91,1637691.91,0.00,0.00,805.00,192287.00,0.00,0.00,0.00),('1','152','757','153690',3059664,'2123','316',808236.99,810801.74,0.00,0.00,2564.75,656576.00,0.00,0.00,0.00),('1','152','757','153690',3059665,'2124','316',1637691.91,1640922.22,0.00,0.00,3230.31,774738.10,0.00,0.00,0.00),('1','152','757','153693',3059698,'2123','316',810801.74,813174.25,0.00,0.00,2372.51,607362.56,0.00,0.00,0.00),('1','152','757','153693',3059699,'2124','316',1640922.22,1644323.40,0.00,0.00,3401.18,827099.04,0.00,0.00,0.00),('1','152','757','153700',3059833,'2123','316',813174.25,815337.31,0.00,0.00,2163.06,553743.36,0.00,0.00,0.00),('1','152','757','153700',3059834,'2124','316',1644323.40,1646760.38,0.00,0.00,2436.98,597892.36,0.00,0.00,0.00),('1','152','757','153703',3059891,'2123','316',815337.31,815834.07,0.00,0.00,496.76,127170.56,0.00,0.00,0.00),('1','152','757','153703',3059892,'2124','316',1646760.38,1647369.99,0.00,0.00,609.61,147584.16,0.00,0.00,0.00),('1','152','757','153833',3062217,'2123','316',815834.07,817790.53,0.00,0.00,1956.46,500853.76,0.00,0.00,0.00),('1','152','757','153833',3062218,'2124','316',1647369.99,1650277.14,0.00,0.00,2907.15,698848.18,0.00,0.00,0.00),('1','152','757','153859',3062699,'2123','316',817790.53,819378.10,0.00,0.00,1587.57,406417.92,0.00,0.00,0.00),('1','152','757','153859',3062700,'2124','316',1650277.14,1652738.72,0.00,0.00,2461.58,602563.92,0.00,0.00,0.00),('1','152','757','153869',3062825,'2123','316',819378.10,819968.51,0.00,0.00,590.41,151144.96,0.00,0.00,0.00),('1','152','757','153869',3062826,'2124','316',1652738.72,1653665.29,0.00,0.00,926.57,222603.70,0.00,0.00,0.00),('1','152','757','153874',3062885,'2123','316',819968.51,821067.52,0.00,0.00,1099.01,281346.56,0.00,0.00,0.00),('1','152','757','153874',3062886,'2124','316',1653665.29,1655470.22,0.00,0.00,1804.93,443186.08,0.00,0.00,0.00),('1','152','757','153928',3063922,'2123','316',821067.52,822224.02,0.00,0.00,1156.50,296064.00,0.00,0.00,0.00),('1','152','757','153928',3063923,'2124','316',1655470.22,1657036.36,0.00,0.00,1566.14,375218.10,0.00,0.00,0.00),('1','152','757','153929',3063924,'2123','316',822224.02,823111.58,0.00,0.00,887.56,227215.36,0.00,0.00,0.00),('1','152','757','153929',3063925,'2124','316',1657036.36,1658328.21,0.00,0.00,1291.85,303283.60,0.00,0.00,0.00),('1','152','757','153930',3063926,'2123','316',823111.58,824601.18,0.00,0.00,1489.60,381337.60,0.00,0.00,0.00),('1','152','757','153930',3063927,'2124','316',1658328.21,1660405.23,0.00,0.00,2077.02,501555.30,0.00,0.00,0.00),('1','152','757','153969',3064553,'2123','316',824601.18,824852.28,0.00,0.00,251.10,64281.60,0.00,0.00,0.00),('1','152','757','153969',3064554,'2124','316',1660405.23,1660593.93,0.00,0.00,188.70,45707.20,0.00,0.00,0.00),('1','152','757','153974',3064654,'2123','316',824852.28,826201.94,0.00,0.00,1349.66,345512.96,0.00,0.00,0.00),('1','152','757','153974',3064655,'2124','316',1660593.93,1663604.14,0.00,0.00,3010.21,737196.48,0.00,0.00,0.00),('1','152','757','153987',3064894,'2123','316',826201.94,826334.66,0.00,0.00,132.72,33976.32,0.00,0.00,0.00),('1','152','757','153987',3064895,'2124','316',1663604.14,1664456.95,0.00,0.00,852.81,208582.92,0.00,0.00,0.00),('1','152','757','153997',3065102,'2123','316',826334.66,827839.75,0.00,0.00,1505.09,409384.48,0.00,0.00,0.00),('1','152','757','153997',3065103,'2124','316',1664456.95,1666581.30,0.00,0.00,2124.35,513508.20,0.00,0.00,0.00),('1','152','757','154005',3065212,'2123','316',827839.75,828703.50,0.00,0.00,863.75,234940.00,0.00,0.00,0.00),('1','152','757','154005',3065213,'2124','316',1666581.30,1667675.36,0.00,0.00,1094.06,268613.88,0.00,0.00,0.00),('1','152','757','154056',3066091,'2123','316',828703.50,829788.01,0.00,0.00,1084.51,294986.72,0.00,0.00,0.00),('1','152','757','154056',3066092,'2124','316',1667675.36,1669385.96,0.00,0.00,1710.60,413698.20,0.00,0.00,0.00),('1','152','757','154060',3066138,'2123','316',829788.01,830796.65,0.00,0.00,1008.64,274350.08,0.00,0.00,0.00),('1','152','757','154060',3066139,'2124','316',1669385.96,1671243.02,0.00,0.00,1857.06,477861.40,0.00,0.00,0.00),('1','152','757','154067',3066189,'2123','316',830796.65,832199.70,0.00,0.00,1403.05,381629.60,0.00,0.00,0.00),('1','152','757','154067',3066190,'2124','316',1671243.02,1673338.14,0.00,0.00,2095.12,536185.64,0.00,0.00,0.00),('1','152','757','154068',3066191,'2123','316',832199.70,832919.43,0.00,0.00,719.73,195766.56,0.00,0.00,0.00),('1','152','757','154068',3066192,'2124','316',1673338.14,1674886.55,0.00,0.00,1548.41,393446.52,0.00,0.00,0.00),('1','152','757','154076',3066313,'2123','316',832919.43,833397.36,0.00,0.00,477.93,129996.96,0.00,0.00,0.00),('1','152','757','154076',3066314,'2124','316',1674886.55,1675636.72,0.00,0.00,750.17,197757.24,0.00,0.00,0.00),('1','152','757','154081',3066392,'2123','316',833397.36,835212.42,0.00,0.00,1815.06,493696.32,0.00,0.00,0.00),('1','152','757','154081',3066393,'2124','316',1675636.72,1678390.87,0.00,0.00,2754.15,658941.12,0.00,0.00,0.00),('1','152','757','154086',3066483,'2123','316',835212.42,835539.38,0.00,0.00,326.96,88933.12,0.00,0.00,0.00),('1','152','757','154086',3066484,'2124','316',1678390.87,1678965.43,0.00,0.00,574.56,139959.32,0.00,0.00,0.00),('1','152','757','154093',3066619,'2123','316',835539.38,837776.58,0.00,0.00,2237.20,608518.40,0.00,0.00,0.00),('1','152','757','154093',3066620,'2124','316',1678965.43,1682492.80,0.00,0.00,3527.37,849132.16,0.00,0.00,0.00),('1','152','757','154369',3071745,'2123','316',837776.58,839525.81,0.00,0.00,1749.23,475790.56,0.00,0.00,0.00),('1','152','757','154369',3071746,'2124','316',1682492.80,1685377.96,0.00,0.00,2885.16,726643.28,0.00,0.00,0.00),('1','152','757','154893',3081546,'2123','316',839525.81,839891.07,0.00,0.00,365.26,99350.72,0.00,0.00,0.00),('1','152','757','154893',3081547,'2124','316',1685377.96,1686079.61,0.00,0.00,701.65,190848.80,0.00,0.00,0.00),('1','152','757','154894',3081548,'2123','316',839891.07,841405.24,0.00,0.00,1514.17,411854.24,0.00,0.00,0.00),('1','152','757','154894',3081549,'2124','316',1686079.61,1688032.81,0.00,0.00,1953.20,468988.40,0.00,0.00,0.00),('1','152','757','154900',3081672,'2123','316',841405.24,842271.27,0.00,0.00,866.03,235560.16,0.00,0.00,0.00),('1','152','757','154900',3081673,'2124','316',1688032.81,1689386.99,0.00,0.00,1354.18,334987.40,0.00,0.00,0.00),('1','152','757','154924',3082084,'2123','316',842271.27,844079.48,0.00,0.00,1808.21,491833.12,0.00,0.00,0.00),('1','152','757','154924',3082085,'2124','316',1689386.99,1691322.02,0.00,0.00,1935.03,468483.42,0.00,0.00,0.00),('1','152','757','154927',3082118,'2123','316',844079.48,844848.85,0.00,0.00,769.37,209268.64,0.00,0.00,0.00),('1','152','757','154927',3082119,'2124','316',1691322.02,1692081.02,0.00,0.00,759.00,206448.00,0.00,0.00,0.00),('1','152','757','154953',3082770,'2123','316',844848.85,847682.53,0.00,0.00,2833.68,770760.96,0.00,0.00,0.00),('1','152','757','154953',3082771,'2124','316',1692081.02,1695764.82,0.00,0.00,3683.80,882755.68,0.00,0.00,0.00),('1','152','757','155419',3091645,'2123','316',847682.53,847682.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','155419',3091646,'2124','316',1695764.82,1695764.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','155421',3091673,'2123','316',847682.53,849730.44,0.00,0.00,2047.91,557031.52,0.00,0.00,0.00),('1','152','757','155421',3091674,'2124','316',1695764.82,1698306.31,0.00,0.00,2541.49,659619.12,0.00,0.00,0.00),('1','152','757','155426',3091746,'2123','316',849730.44,849866.79,0.00,0.00,136.35,37087.20,0.00,0.00,0.00),('1','152','757','155426',3091747,'2124','316',1698306.31,1698580.57,0.00,0.00,274.26,70418.72,0.00,0.00,0.00),('1','152','757','155433',3091905,'2123','316',849866.79,851922.72,0.00,0.00,2055.93,559212.96,0.00,0.00,0.00),('1','152','757','155433',3091906,'2124','316',1698580.57,1701680.09,0.00,0.00,3099.52,753312.68,0.00,0.00,0.00),('1','152','757','155438',3092033,'2123','316',851922.72,852083.00,0.00,0.00,160.28,43596.16,0.00,0.00,0.00),('1','152','757','155438',3092034,'2124','316',1701680.09,1702132.52,0.00,0.00,452.43,110938.96,0.00,0.00,0.00),('1','152','757','155453',3092247,'2123','316',852083.00,853922.27,0.00,0.00,1839.27,500281.44,0.00,0.00,0.00),('1','152','757','155453',3092248,'2124','316',1702132.52,1704789.20,0.00,0.00,2656.68,646567.56,0.00,0.00,0.00),('1','152','757','155884',3099909,'2123','316',853922.27,854368.18,0.00,0.00,445.91,121287.52,0.00,0.00,0.00),('1','152','757','155884',3099910,'2124','316',1704789.20,1705507.76,0.00,0.00,718.56,177605.04,0.00,0.00,0.00),('1','152','757','155895',3100102,'2123','316',854368.18,855382.97,0.00,0.00,1014.79,276022.88,0.00,0.00,0.00),('1','152','757','155895',3100103,'2124','316',1705507.76,1707156.76,0.00,0.00,1649.00,410566.00,0.00,0.00,0.00),('1','152','757','155935',3100824,'2123','316',855382.97,856570.53,0.00,0.00,1187.56,323016.32,0.00,0.00,0.00),('1','152','757','155935',3100825,'2124','316',1707156.76,1709021.78,0.00,0.00,1865.02,457873.28,0.00,0.00,0.00),('1','152','757','155948',3101007,'2123','316',856570.53,857573.29,0.00,0.00,1002.76,272750.72,0.00,0.00,0.00),('1','152','757','155948',3101008,'2124','316',1709021.78,1710970.18,0.00,0.00,1948.40,464380.22,0.00,0.00,0.00),('1','152','757','155949',3101009,'2123','316',857573.29,858652.67,0.00,0.00,1079.38,293591.36,0.00,0.00,0.00),('1','152','757','155949',3101010,'2124','316',1710970.18,1712758.38,0.00,0.00,1788.20,432468.40,0.00,0.00,0.00),('1','152','757','155955',3101112,'2123','316',858652.67,859456.90,0.00,0.00,804.23,218750.56,0.00,0.00,0.00),('1','152','757','155955',3101113,'2124','316',1712758.38,1713725.08,0.00,0.00,966.70,244640.08,0.00,0.00,0.00),('1','152','757','156229',3106121,'2123','316',859456.90,861057.76,0.00,0.00,1600.86,435433.92,0.00,0.00,0.00),('1','152','757','156229',3106122,'2124','316',1713725.08,1716052.64,0.00,0.00,2327.56,575896.82,0.00,0.00,0.00),('1','152','757','156249',3106483,'2123','316',861057.76,861243.29,0.00,0.00,185.53,50464.16,0.00,0.00,0.00),('1','152','757','156249',3106484,'2124','316',1716052.64,1716291.60,0.00,0.00,238.96,63971.12,0.00,0.00,0.00),('1','152','757','156253',3106533,'2123','316',861243.29,863146.43,0.00,0.00,1903.14,517654.08,0.00,0.00,0.00),('1','152','757','156253',3106534,'2124','316',1716291.60,1719602.87,0.00,0.00,3311.27,809093.80,0.00,0.00,0.00),('1','152','757','156436',3109757,'2123','316',863146.43,865306.05,0.00,0.00,2159.62,587416.64,0.00,0.00,0.00),('1','152','757','156436',3109758,'2124','316',1719602.87,1722893.66,0.00,0.00,3290.79,824234.00,0.00,0.00,0.00),('1','152','757','156462',3110223,'2123','316',865306.05,865849.06,0.00,0.00,543.01,147698.72,0.00,0.00,0.00),('1','152','757','156462',3110224,'2124','316',1722893.66,1724055.95,0.00,0.00,1162.29,301094.88,0.00,0.00,0.00),('1','152','757','156632',3113605,'2123','316',865849.06,867311.94,0.00,0.00,1462.88,397903.36,0.00,0.00,0.00),('1','152','757','156632',3113606,'2124','316',1724055.95,1726560.37,0.00,0.00,2504.42,631137.24,0.00,0.00,0.00),('1','152','757','156640',3113781,'2123','316',867311.94,867569.09,0.00,0.00,257.15,69944.80,0.00,0.00,0.00),('1','152','757','156640',3113782,'2124','316',1726560.37,1727142.94,0.00,0.00,582.57,147819.04,0.00,0.00,0.00),('1','152','757','156760',3115880,'2123','316',867569.09,869323.70,0.00,0.00,1754.61,477253.92,0.00,0.00,0.00),('1','152','757','156760',3115881,'2124','316',1727142.94,1730218.19,0.00,0.00,3075.25,742976.60,0.00,0.00,0.00),('1','152','757','157835',3134981,'2123','316',869323.70,869323.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','157835',3134982,'2124','316',1730218.19,1730218.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158487',3147228,'2123','316',869323.70,870377.69,0.00,0.00,1053.99,286685.28,0.00,0.00,0.00),('1','152','757','158487',3147229,'2124','316',1730218.19,1731126.75,0.00,0.00,908.56,212603.04,0.00,0.00,0.00),('1','152','757','158492',3147324,'2123','316',870377.69,872327.69,0.00,0.00,1950.00,530400.00,0.00,0.00,0.00),('1','152','757','158492',3147325,'2124','316',1731126.75,1732188.80,0.00,0.00,1062.05,248519.70,0.00,0.00,0.00),('1','152','757','158554',3148506,'2123','316',872327.69,872327.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158554',3148507,'2124','316',1732188.80,1732188.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158583',3148837,'2123','316',872327.69,872327.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158583',3148838,'2124','316',1732188.80,1732188.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158584',3148839,'2123','316',872327.69,874567.44,0.00,0.00,2239.75,609212.00,0.00,0.00,0.00),('1','152','757','158584',3148840,'2124','316',1732188.80,1732646.80,0.00,0.00,458.00,107172.00,0.00,0.00,0.00),('1','152','757','158589',3148916,'2123','316',874567.44,875981.42,0.00,0.00,1413.98,384602.56,0.00,0.00,0.00),('1','152','757','158589',3148917,'2124','316',1732646.80,1733506.30,0.00,0.00,859.50,201123.00,0.00,0.00,0.00),('1','152','757','158590',3148918,'2123','316',875981.42,877540.92,0.00,0.00,1559.50,424184.00,0.00,0.00,0.00),('1','152','757','158590',3148919,'2124','316',1733506.30,1734453.80,0.00,0.00,947.50,221715.00,0.00,0.00,0.00),('1','152','757','158592',3148942,'2123','316',877540.92,879171.07,0.00,0.00,1630.15,443400.80,0.00,0.00,0.00),('1','152','757','158592',3148943,'2124','316',1734453.80,1736038.45,0.00,0.00,1584.65,370808.10,0.00,0.00,0.00),('1','152','757','158716',3151533,'2123','316',879171.07,879912.50,0.00,0.00,741.43,201668.96,0.00,0.00,0.00),('1','152','757','158716',3151534,'2124','316',1736038.45,1736474.45,0.00,0.00,436.00,102024.00,0.00,0.00,0.00),('1','152','757','158724',3151679,'2123','316',879912.50,883620.24,0.00,0.00,3707.74,1008505.28,0.00,0.00,0.00),('1','152','757','158724',3151680,'2124','316',1736474.45,1737043.95,0.00,0.00,569.50,133263.00,0.00,0.00,0.00),('1','152','757','158727',3151704,'2123','316',883620.24,883620.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158727',3151705,'2124','316',1737043.95,1737043.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158730',3151748,'2123','316',883620.24,887160.92,0.00,0.00,3540.68,963064.96,0.00,0.00,0.00),('1','152','757','158730',3151749,'2124','316',1737043.95,1738371.04,0.00,0.00,1327.09,311241.68,0.00,0.00,0.00),('1','152','757','158754',3152050,'2123','316',887160.92,887539.41,0.00,0.00,378.49,102949.28,0.00,0.00,0.00),('1','152','757','158754',3152051,'2124','316',1738371.04,1738621.04,0.00,0.00,250.00,58500.00,0.00,0.00,0.00),('1','152','757','158755',3152052,'2123','316',887539.41,887539.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158755',3152053,'2124','316',1738621.04,1738621.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158756',3152054,'2123','316',887539.41,887539.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158756',3152055,'2124','316',1738621.04,1738621.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158757',3152056,'2123','316',887539.41,887935.18,0.00,0.00,395.77,107649.44,0.00,0.00,0.00),('1','152','757','158757',3152057,'2124','316',1738621.04,1738638.04,0.00,0.00,17.00,3978.00,0.00,0.00,0.00),('1','152','757','158758',3152058,'2123','316',887935.18,889510.44,0.00,0.00,1575.26,428470.72,0.00,0.00,0.00),('1','152','757','158758',3152059,'2124','316',1738638.04,1739368.54,0.00,0.00,730.50,170937.00,0.00,0.00,0.00),('1','152','757','158759',3152060,'2123','316',889510.44,890129.99,0.00,0.00,619.55,168517.60,0.00,0.00,0.00),('1','152','757','158759',3152061,'2124','316',1739368.54,1739509.54,0.00,0.00,141.00,32994.00,0.00,0.00,0.00),('1','152','757','158760',3152062,'2123','316',890129.99,894266.87,0.00,0.00,4136.88,1125231.36,0.00,0.00,0.00),('1','152','757','158760',3152063,'2124','316',1739509.54,1739884.14,0.00,0.00,374.60,87656.40,0.00,0.00,0.00),('1','152','757','158761',3152064,'2123','316',894266.87,894266.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158761',3152065,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158762',3152066,'2123','316',894266.87,897954.22,0.00,0.00,3687.35,1002959.20,0.00,0.00,0.00),('1','152','757','158762',3152067,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158765',3152098,'2123','316',897954.22,899964.73,0.00,0.00,2010.51,546858.72,0.00,0.00,0.00),('1','152','757','158765',3152099,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158792',3152623,'2123','316',899964.73,899964.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158792',3152624,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158794',3152641,'2123','316',899964.73,901938.55,0.00,0.00,1973.82,536879.04,0.00,0.00,0.00),('1','152','757','158794',3152642,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158944',3155235,'2123','316',901938.55,905567.75,0.00,0.00,3629.20,987142.40,0.00,0.00,0.00),('1','152','757','158944',3155236,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','158994',3156200,'2123','316',905567.75,909511.27,0.00,0.00,3943.52,1072637.44,0.00,0.00,0.00),('1','152','757','158994',3156201,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159261',3161274,'2123','316',909511.27,911177.99,0.00,0.00,1666.72,453347.84,0.00,0.00,0.00),('1','152','757','159261',3161275,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159427',3163783,'2123','316',911177.99,911177.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159427',3163784,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159440',3163952,'2123','316',911177.99,913818.30,0.00,0.00,2640.31,718164.32,0.00,0.00,0.00),('1','152','757','159440',3163953,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159448',3164061,'2123','316',913818.30,916668.59,0.00,0.00,2850.29,775278.88,0.00,0.00,0.00),('1','152','757','159448',3164062,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159646',3167487,'2123','316',916668.59,916668.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159646',3167488,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159652',3167584,'2123','316',916668.59,916668.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159652',3167585,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159662',3167822,'2123','316',916668.59,918902.06,0.00,0.00,2233.47,607503.84,0.00,0.00,0.00),('1','152','757','159662',3167823,'2124','316',1739884.14,1739884.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159677',3168041,'2123','316',918902.06,921827.88,0.00,0.00,2925.82,795823.04,0.00,0.00,0.00),('1','152','757','159677',3168042,'2124','316',1739884.14,1740596.64,0.00,0.00,712.50,166725.00,0.00,0.00,0.00),('1','152','757','159686',3168182,'2123','316',921827.88,922318.46,0.00,0.00,490.58,133437.76,0.00,0.00,0.00),('1','152','757','159686',3168183,'2124','316',1740596.64,1740596.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159907',3172078,'2123','316',922318.46,925946.59,0.00,0.00,3628.13,986851.36,0.00,0.00,0.00),('1','152','757','159907',3172079,'2124','316',1740596.64,1741989.56,0.00,0.00,1392.92,332179.44,0.00,0.00,0.00),('1','152','757','159919',3172375,'2123','316',925946.59,925946.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159919',3172376,'2124','316',1741989.56,1741989.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','159926',3172507,'2123','316',925946.59,926404.89,0.00,0.00,458.30,124657.60,0.00,0.00,0.00),('1','152','757','159926',3172508,'2124','316',1741989.56,1742290.56,0.00,0.00,301.00,72842.00,0.00,0.00,0.00),('1','152','757','160009',3173855,'2123','316',926404.89,927048.02,0.00,0.00,643.13,174931.36,0.00,0.00,0.00),('1','152','757','160009',3173856,'2124','316',1742290.56,1742906.66,0.00,0.00,616.10,149096.20,0.00,0.00,0.00),('1','152','757','160077',3175276,'2123','316',927048.02,927048.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160077',3175277,'2124','316',1742906.66,1742906.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160087',3175553,'2123','316',927048.02,929653.23,0.00,0.00,2605.21,708617.12,0.00,0.00,0.00),('1','152','757','160087',3175554,'2124','316',1742906.66,1743487.66,0.00,0.00,581.00,140602.00,0.00,0.00,0.00),('1','152','757','160188',3177265,'2123','316',929653.23,931591.37,0.00,0.00,1938.14,527174.08,0.00,0.00,0.00),('1','152','757','160188',3177266,'2124','316',1743487.66,1743919.66,0.00,0.00,432.00,104544.00,0.00,0.00,0.00),('1','152','757','160293',3179297,'2123','316',931591.37,931591.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160293',3179298,'2124','316',1743919.66,1743919.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160299',3179342,'2123','316',931591.37,931591.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160299',3179343,'2124','316',1743919.66,1743919.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160302',3179347,'2123','316',931591.37,933847.71,0.00,0.00,2256.34,613724.48,0.00,0.00,0.00),('1','152','757','160302',3179348,'2124','316',1743919.66,1744551.16,0.00,0.00,631.50,152823.00,0.00,0.00,0.00),('1','152','757','160439',3181982,'2123','316',933847.71,935379.10,0.00,0.00,1531.39,416538.08,0.00,0.00,0.00),('1','152','757','160439',3181983,'2124','316',1744551.16,1745711.66,0.00,0.00,1160.50,280841.00,0.00,0.00,0.00),('1','152','757','160441',3181985,'2123','316',935379.10,935379.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160441',3181986,'2124','316',1745711.66,1745711.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160445',3182051,'2123','316',935379.10,937695.77,0.00,0.00,2316.67,622065.44,0.00,0.00,0.00),('1','152','757','160445',3182052,'2124','316',1745711.66,1745711.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160569',3184241,'2123','316',937695.77,937695.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160569',3184242,'2124','316',1745711.66,1745711.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160571',3184259,'2123','316',937695.77,941223.22,0.00,0.00,3527.45,959466.40,0.00,0.00,0.00),('1','152','757','160571',3184260,'2124','316',1745711.66,1746032.66,0.00,0.00,321.00,77682.00,0.00,0.00,0.00),('1','152','757','160831',3188576,'2123','316',941223.22,942376.45,0.00,0.00,1153.23,341356.08,0.00,0.00,0.00),('1','152','757','160831',3188577,'2124','316',1746032.66,1746482.66,0.00,0.00,450.00,112500.00,0.00,0.00,0.00),('1','152','757','160838',3188707,'2123','316',942376.45,942376.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160838',3188708,'2124','316',1746482.66,1746482.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','160843',3188781,'2123','316',942376.45,944239.35,0.00,0.00,1862.90,551418.40,0.00,0.00,0.00),('1','152','757','160843',3188782,'2124','316',1746482.66,1746633.66,0.00,0.00,151.00,37750.00,0.00,0.00,0.00),('1','152','757','160844',3188783,'2123','316',944239.35,947519.33,0.00,0.00,3279.98,970874.08,0.00,0.00,0.00),('1','152','757','160844',3188784,'2124','316',1746633.66,1747241.16,0.00,0.00,607.50,151875.00,0.00,0.00,0.00),('1','152','757','161199',3195261,'2123','316',947519.33,951306.89,0.00,0.00,3787.56,1121117.76,0.00,0.00,0.00),('1','152','757','161199',3195262,'2124','316',1747241.16,1748220.36,0.00,0.00,979.20,244800.00,0.00,0.00,0.00),('1','152','757','161247',3196198,'2123','316',951306.89,953084.25,0.00,0.00,1777.36,526098.56,0.00,0.00,0.00),('1','152','757','161247',3196199,'2124','316',1748220.36,1748466.36,0.00,0.00,246.00,61500.00,0.00,0.00,0.00),('1','152','757','161253',3196342,'2123','316',953084.25,953084.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161253',3196343,'2124','316',1748466.36,1748466.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161259',3196459,'2123','316',953084.25,954336.51,0.00,0.00,1252.26,370668.96,0.00,0.00,0.00),('1','152','757','161259',3196460,'2124','316',1748466.36,1748851.86,0.00,0.00,385.50,96375.00,0.00,0.00,0.00),('1','152','757','161434',3199259,'2123','316',954336.51,957116.97,0.00,0.00,2780.46,823016.16,0.00,0.00,0.00),('1','152','757','161434',3199260,'2124','316',1748851.86,1749881.36,0.00,0.00,1029.50,257375.00,0.00,0.00,0.00),('1','152','757','161448',3199432,'2123','316',957116.97,957116.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161448',3199433,'2124','316',1749881.36,1749881.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161725',3203758,'2123','316',957116.97,960261.65,0.00,0.00,3144.68,930825.28,0.00,0.00,0.00),('1','152','757','161725',3203759,'2124','316',1749881.36,1752290.86,0.00,0.00,2409.50,602375.00,0.00,0.00,0.00),('1','152','757','161898',3206968,'2123','316',960261.65,960261.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161898',3206969,'2124','316',1752290.86,1752290.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161902',3207042,'2123','316',960261.65,961855.23,0.00,0.00,1593.58,471699.68,0.00,0.00,0.00),('1','152','757','161902',3207043,'2124','316',1752290.86,1753133.36,0.00,0.00,842.50,210625.00,0.00,0.00,0.00),('1','152','757','161906',3207085,'2123','316',961855.23,961855.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161906',3207086,'2124','316',1753133.36,1753133.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','161910',3207145,'2123','316',961855.23,962719.58,0.00,0.00,864.35,255847.60,0.00,0.00,0.00),('1','152','757','161910',3207146,'2124','316',1753133.36,1753373.36,0.00,0.00,240.00,60000.00,0.00,0.00,0.00),('1','152','757','162416',3216174,'2123','316',962719.58,965918.97,0.00,0.00,3199.39,947019.44,0.00,0.00,0.00),('1','152','757','162416',3216175,'2124','316',1753373.36,1754561.31,0.00,0.00,1187.95,296987.50,0.00,0.00,0.00),('1','152','757','162421',3216249,'2123','316',965918.97,965918.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162421',3216250,'2124','316',1754561.31,1754561.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162424',3216289,'2123','316',965918.97,968142.18,0.00,0.00,2223.21,658070.16,0.00,0.00,0.00),('1','152','757','162424',3216290,'2124','316',1754561.31,1755217.81,0.00,0.00,656.50,164125.00,0.00,0.00,0.00),('1','152','757','162429',3216368,'2123','316',968142.18,970254.33,0.00,0.00,2112.15,625196.40,0.00,0.00,0.00),('1','152','757','162429',3216369,'2124','316',1755217.81,1755828.51,0.00,0.00,610.70,152675.00,0.00,0.00,0.00),('1','152','757','162433',3216426,'2123','316',970254.33,970254.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162433',3216427,'2124','316',1755828.51,1755828.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162437',3216475,'2123','316',970254.33,971232.03,0.00,0.00,977.70,289399.20,0.00,0.00,0.00),('1','152','757','162437',3216476,'2124','316',1755828.51,1756163.01,0.00,0.00,334.50,83625.00,0.00,0.00,0.00),('1','152','757','162543',3217998,'2123','316',971232.03,974174.53,0.00,0.00,2942.50,870980.00,0.00,0.00,0.00),('1','152','757','162543',3217999,'2124','316',1756163.01,1757446.61,0.00,0.00,1283.60,320900.00,0.00,0.00,0.00),('1','152','757','162893',3224162,'2123','316',974174.53,974174.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162893',3224163,'2124','316',1757446.61,1757446.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','162988',3226058,'2123','316',974174.53,977306.12,0.00,0.00,3131.59,926950.64,0.00,0.00,0.00),('1','152','757','162988',3226059,'2124','316',1757446.61,1758645.11,0.00,0.00,1198.50,299625.00,0.00,0.00,0.00),('1','152','757','162990',3226074,'2123','316',977306.12,977883.06,0.00,0.00,576.94,170774.24,0.00,0.00,0.00),('1','152','757','162990',3226075,'2124','316',1758645.11,1759270.61,0.00,0.00,625.50,156375.00,0.00,0.00,0.00),('1','152','757','163124',3228288,'2123','316',977883.06,977883.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163124',3228289,'2124','316',1759270.61,1759270.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163129',3228425,'2123','316',977883.06,979931.75,0.00,0.00,2048.69,606412.24,0.00,0.00,0.00),('1','152','757','163129',3228426,'2124','316',1759270.61,1760209.11,0.00,0.00,938.50,234625.00,0.00,0.00,0.00),('1','152','757','163135',3228541,'2123','316',979931.75,981963.17,0.00,0.00,2031.42,577212.82,0.00,0.00,0.00),('1','152','757','163135',3228542,'2124','316',1760209.11,1760738.61,0.00,0.00,529.50,132375.00,0.00,0.00,0.00),('1','152','757','163142',3228681,'2123','316',981963.17,981963.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163142',3228682,'2124','316',1760738.61,1760738.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163145',3228724,'2123','316',981963.17,983317.19,0.00,0.00,1354.02,400789.92,0.00,0.00,0.00),('1','152','757','163145',3228725,'2124','316',1760738.61,1760838.61,0.00,0.00,100.00,25000.00,0.00,0.00,0.00),('1','152','757','163283',3231087,'2123','316',983317.19,986042.39,0.00,0.00,2725.20,806659.20,0.00,0.00,0.00),('1','152','757','163283',3231088,'2124','316',1760838.61,1762276.04,0.00,0.00,1437.43,359357.50,0.00,0.00,0.00),('1','152','757','163287',3231151,'2123','316',986042.39,986042.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163287',3231152,'2124','316',1762276.04,1762276.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163461',3234322,'2123','316',986042.39,989917.74,0.00,0.00,3875.35,1147103.60,0.00,0.00,0.00),('1','152','757','163461',3234323,'2124','316',1762276.04,1764034.44,0.00,0.00,1758.40,439600.00,0.00,0.00,0.00),('1','152','757','163464',3234374,'2123','316',989917.74,989917.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163464',3234375,'2124','316',1764034.44,1764034.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163469',3234492,'2123','316',989917.74,991618.14,0.00,0.00,1700.40,503318.40,0.00,0.00,0.00),('1','152','757','163469',3234493,'2124','316',1764034.44,1764837.94,0.00,0.00,803.50,200875.00,0.00,0.00,0.00),('1','152','757','163592',3236723,'2123','316',991618.14,991618.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163592',3236724,'2124','316',1764837.94,1764837.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163596',3236774,'2123','316',991618.14,992312.05,0.00,0.00,693.91,205397.36,0.00,0.00,0.00),('1','152','757','163596',3236775,'2124','316',1764837.94,1765052.44,0.00,0.00,214.50,53625.00,0.00,0.00,0.00),('1','152','757','163802',3240390,'2123','316',992312.05,994600.41,0.00,0.00,2288.36,677354.56,0.00,0.00,0.00),('1','152','757','163802',3240391,'2124','316',1765052.44,1767305.94,0.00,0.00,2253.50,563375.00,0.00,0.00,0.00),('1','152','757','163810',3240544,'2123','316',994600.41,994600.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163810',3240545,'2124','316',1767305.94,1767305.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','163985',3243771,'2123','316',994600.41,997348.21,0.00,0.00,2747.80,813348.80,0.00,0.00,0.00),('1','152','757','163985',3243772,'2124','316',1767305.94,1770115.44,0.00,0.00,2809.50,703125.00,0.00,0.00,0.00),('1','152','757','164078',3245522,'2123','316',997348.21,997348.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164078',3245523,'2124','316',1770115.44,1770115.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164079',3245524,'2123','316',997348.21,1000670.39,0.00,0.00,3322.18,983365.28,0.00,0.00,0.00),('1','152','757','164079',3245525,'2124','316',1770115.44,1770962.89,0.00,0.00,847.45,228811.50,0.00,0.00,0.00),('1','152','757','164701',3256851,'2123','316',1000670.39,1001504.32,0.00,0.00,833.93,246843.28,0.00,0.00,0.00),('1','152','757','164701',3256852,'2124','316',1770962.89,1771553.59,0.00,0.00,590.70,159489.00,0.00,0.00,0.00),('1','152','757','164863',3259797,'2123','316',1001504.32,1001504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164863',3259798,'2124','316',1771553.59,1771553.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164864',3259799,'2123','316',1001504.32,1001504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164864',3259800,'2124','316',1771553.59,1771553.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164870',3259882,'2123','316',1001504.32,1002933.58,0.00,0.00,1429.26,423060.96,0.00,0.00,0.00),('1','152','757','164870',3259883,'2124','316',1771553.59,1772205.27,0.00,0.00,651.68,175953.60,0.00,0.00,0.00),('1','152','757','164875',3259964,'2123','316',1002933.58,1002933.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164875',3259965,'2124','316',1772205.27,1772205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164880',3260049,'2123','316',1002933.58,1003507.76,0.00,0.00,574.18,169957.28,0.00,0.00,0.00),('1','152','757','164880',3260050,'2124','316',1772205.27,1772238.60,0.00,0.00,33.33,8999.10,0.00,0.00,0.00),('1','152','757','164886',3260154,'2123','316',1003507.76,1006505.12,0.00,0.00,2997.36,887218.56,0.00,0.00,0.00),('1','152','757','164886',3260155,'2124','316',1772238.60,1774169.08,0.00,0.00,1930.48,521229.60,0.00,0.00,0.00),('1','152','757','164888',3260172,'2123','316',1006505.12,1006505.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164888',3260173,'2124','316',1774169.08,1774169.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','164894',3260257,'2123','316',1006505.12,1009872.01,0.00,0.00,3366.89,996599.44,0.00,0.00,0.00),('1','152','757','164894',3260258,'2124','316',1774169.08,1776883.57,0.00,0.00,2714.49,732912.30,0.00,0.00,0.00),('1','152','757','164924',3260801,'2123','316',1009872.01,1013000.49,0.00,0.00,3128.48,926030.08,0.00,0.00,0.00),('1','152','757','164924',3260802,'2124','316',1776883.57,1778598.87,0.00,0.00,1715.30,463131.00,0.00,0.00,0.00),('1','152','757','165006',3262134,'2123','316',1013000.49,1013254.13,0.00,0.00,253.64,75077.44,0.00,0.00,0.00),('1','152','757','165006',3262135,'2124','316',1778598.87,1779248.79,0.00,0.00,649.92,175478.40,0.00,0.00,0.00),('1','152','757','165012',3262218,'2123','316',1013254.13,1016397.92,0.00,0.00,3143.79,930561.84,0.00,0.00,0.00),('1','152','757','165012',3262219,'2124','316',1779248.79,1780632.18,0.00,0.00,1383.39,409483.44,0.00,0.00,0.00),('1','152','757','165181',3265292,'2123','316',1016397.92,1016397.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','165181',3265293,'2124','316',1780632.18,1780632.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','165186',3265373,'2123','316',1016397.92,1019912.04,0.00,0.00,3514.12,1124518.40,0.00,0.00,0.00),('1','152','757','165186',3265374,'2124','316',1780632.18,1782958.28,0.00,0.00,2326.10,688525.60,0.00,0.00,0.00),('1','152','757','165348',3268125,'2123','316',1019912.04,1023093.33,0.00,0.00,3181.29,1018012.80,0.00,0.00,0.00),('1','152','757','165348',3268126,'2124','316',1782958.28,1785674.88,0.00,0.00,2716.60,804113.60,0.00,0.00,0.00),('1','152','757','165479',3270410,'2123','316',1023093.33,1026511.14,0.00,0.00,3417.81,1093699.20,0.00,0.00,0.00),('1','152','757','165479',3270411,'2124','316',1785674.88,1787694.40,0.00,0.00,2019.52,597777.92,0.00,0.00,0.00),('1','152','757','165509',3270900,'2123','316',1026511.14,1026859.52,0.00,0.00,348.38,111481.60,0.00,0.00,0.00),('1','152','757','165509',3270901,'2124','316',1787694.40,1788042.50,0.00,0.00,348.10,103037.60,0.00,0.00,0.00),('1','152','757','165899',3278302,'2123','316',1026859.52,1029121.81,0.00,0.00,2262.29,723932.80,0.00,0.00,0.00),('1','152','757','165899',3278303,'2124','316',1788042.50,1789883.97,0.00,0.00,1841.47,545075.12,0.00,0.00,0.00),('1','152','757','165928',3278704,'2123','316',1029121.81,1029121.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','165928',3278705,'2124','316',1789883.97,1789883.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','165930',3278719,'2123','316',1029121.81,1032819.41,0.00,0.00,3697.60,1183232.00,0.00,0.00,0.00),('1','152','757','165930',3278720,'2124','316',1789883.97,1792078.47,0.00,0.00,2194.50,649572.00,0.00,0.00,0.00),('1','152','757','166061',3281000,'2123','316',1032819.41,1035369.59,0.00,0.00,2550.18,816057.60,0.00,0.00,0.00),('1','152','757','166061',3281001,'2124','316',1792078.47,1794682.33,0.00,0.00,2603.86,770742.56,0.00,0.00,0.00),('1','152','757','166067',3281097,'2123','316',1035369.59,1035369.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','166067',3281098,'2124','316',1794682.33,1794682.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','166287',3285029,'2123','316',1035369.59,1038843.24,0.00,0.00,3473.65,1111568.00,0.00,0.00,0.00),('1','152','757','166287',3285030,'2124','316',1794682.33,1797086.77,0.00,0.00,2404.44,711714.24,0.00,0.00,0.00),('1','152','757','166419',3287515,'2123','316',1038843.24,1039520.28,0.00,0.00,677.04,216652.80,0.00,0.00,0.00),('1','152','757','166419',3287516,'2124','316',1797086.77,1797591.77,0.00,0.00,505.00,149480.00,0.00,0.00,0.00),('1','152','757','166609',3290868,'2123','316',1039520.28,1041661.66,0.00,0.00,2141.38,685241.60,0.00,0.00,0.00),('1','152','757','166609',3290869,'2124','316',1797591.77,1799916.42,0.00,0.00,2324.65,688096.40,0.00,0.00,0.00),('1','152','757','166748',3293104,'2123','316',1041661.66,1044923.78,0.00,0.00,3262.12,1043878.40,0.00,0.00,0.00),('1','152','757','166748',3293105,'2124','316',1799916.42,1800915.20,0.00,0.00,998.78,295638.88,0.00,0.00,0.00),('1','152','757','167157',3300563,'2123','316',1044923.78,1045896.16,0.00,0.00,972.38,311161.60,0.00,0.00,0.00),('1','152','757','167157',3300564,'2124','316',1800915.20,1801697.59,0.00,0.00,782.39,231587.44,0.00,0.00,0.00),('1','152','757','167162',3300656,'2123','316',1045896.16,1047088.56,0.00,0.00,1192.40,381568.00,0.00,0.00,0.00),('1','152','757','167162',3300657,'2124','316',1801697.59,1802414.59,0.00,0.00,717.00,212232.00,0.00,0.00,0.00),('1','152','757','167163',3300658,'2123','316',1047088.56,1049533.33,0.00,0.00,2444.77,782326.40,0.00,0.00,0.00),('1','152','757','167163',3300659,'2124','316',1802414.59,1803702.16,0.00,0.00,1287.57,381120.72,0.00,0.00,0.00),('1','152','757','167183',3300947,'2123','316',1049533.33,1052634.21,0.00,0.00,3100.88,992281.60,0.00,0.00,0.00),('1','152','757','167183',3300948,'2124','316',1803702.16,1805755.16,0.00,0.00,2053.00,607688.00,0.00,0.00,0.00),('1','152','757','167184',3300949,'2123','316',1052634.21,1052634.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','167184',3300950,'2124','316',1805755.16,1805755.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','167526',3307199,'2123','316',1052634.21,1056514.90,0.00,0.00,3880.69,1241820.80,0.00,0.00,0.00),('1','152','757','167526',3307200,'2124','316',1805755.16,1808236.99,0.00,0.00,2481.83,734621.68,0.00,0.00,0.00),('1','152','757','167705',3310312,'2123','316',1056514.90,1059428.67,0.00,0.00,2913.77,932406.40,0.00,0.00,0.00),('1','152','757','167705',3310313,'2124','316',1808236.99,1810832.83,0.00,0.00,2595.84,768368.64,0.00,0.00,0.00),('1','152','757','167707',3310338,'2123','316',1059428.67,1059428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','167707',3310339,'2124','316',1810832.83,1810832.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','167791',3311612,'2123','316',1059428.67,1061430.45,0.00,0.00,2001.78,640569.60,0.00,0.00,0.00),('1','152','757','167791',3311613,'2124','316',1810832.83,1811800.33,0.00,0.00,967.50,286380.00,0.00,0.00,0.00),('1','152','757','167941',3314243,'2123','316',1061430.45,1064864.18,0.00,0.00,3433.73,1098793.60,0.00,0.00,0.00),('1','152','757','167941',3314244,'2124','316',1811800.33,1813717.81,0.00,0.00,1917.48,567574.08,0.00,0.00,0.00),('1','152','757','168010',3315656,'2123','316',1064864.18,1064864.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','168010',3315657,'2124','316',1813717.81,1813717.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','168015',3315727,'2123','316',1064864.18,1066156.27,0.00,0.00,1292.09,413468.80,0.00,0.00,0.00),('1','152','757','168015',3315728,'2124','316',1813717.81,1814200.48,0.00,0.00,482.67,142870.32,0.00,0.00,0.00),('1','152','757','168374',3322523,'2123','316',1066156.27,1069587.02,0.00,0.00,3430.75,1097840.00,0.00,0.00,0.00),('1','152','757','168374',3322524,'2124','316',1814200.48,1816406.36,0.00,0.00,2205.88,652940.48,0.00,0.00,0.00),('1','152','757','168391',3322869,'2123','316',1069587.02,1072908.07,0.00,0.00,3321.05,1062736.00,0.00,0.00,0.00),('1','152','757','168391',3322870,'2124','316',1816406.36,1818612.36,0.00,0.00,2206.00,652976.00,0.00,0.00,0.00),('1','152','757','168537',3325228,'2123','316',1072908.07,1072908.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','168537',3325229,'2124','316',1818612.36,1818612.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','168558',3325602,'2123','316',1072908.07,1075216.58,0.00,0.00,2308.51,738723.20,0.00,0.00,0.00),('1','152','757','168558',3325603,'2124','316',1818612.36,1819597.33,0.00,0.00,984.97,291551.12,0.00,0.00,0.00),('1','152','757','168732',3328924,'2123','316',1075216.58,1076547.52,0.00,0.00,1330.94,425900.80,0.00,0.00,0.00),('1','152','757','168732',3328925,'2124','316',1819597.33,1820255.65,0.00,0.00,658.32,194862.72,0.00,0.00,0.00),('1','152','757','168917',3332129,'2123','316',1076547.52,1080198.18,0.00,0.00,3650.66,1168211.20,0.00,0.00,0.00),('1','152','757','168917',3332130,'2124','316',1820255.65,1821377.85,0.00,0.00,1122.20,332171.20,0.00,0.00,0.00),('1','152','757','169002',3333652,'2123','316',1080198.18,1080198.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169002',3333653,'2124','316',1821377.85,1821377.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169009',3333739,'2123','316',1080198.18,1082697.35,0.00,0.00,2499.17,799734.40,0.00,0.00,0.00),('1','152','757','169009',3333740,'2124','316',1821377.85,1822683.42,0.00,0.00,1305.57,386448.72,0.00,0.00,0.00),('1','152','757','169467',3342376,'2123','316',1082697.35,1085668.35,0.00,0.00,2971.00,950720.00,0.00,0.00,0.00),('1','152','757','169467',3342377,'2124','316',1822683.42,1825242.31,0.00,0.00,2558.89,757431.44,0.00,0.00,0.00),('1','152','757','169473',3342475,'2123','316',1085668.35,1085668.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169473',3342476,'2124','316',1825242.31,1825242.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169474',3342477,'2123','316',1085668.35,1086512.23,0.00,0.00,843.88,267075.20,0.00,0.00,0.00),('1','152','757','169474',3342478,'2124','316',1825242.31,1825242.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169540',3343918,'2123','316',1086512.23,1090091.31,0.00,0.00,3579.08,1145305.60,0.00,0.00,0.00),('1','152','757','169540',3343919,'2124','316',1825242.31,1826889.40,0.00,0.00,1647.09,487538.64,0.00,0.00,0.00),('1','152','757','169555',3344171,'2123','316',1090091.31,1092157.97,0.00,0.00,2066.66,661331.20,0.00,0.00,0.00),('1','152','757','169555',3344172,'2124','316',1826889.40,1830548.56,0.00,0.00,3659.16,1083111.36,0.00,0.00,0.00),('1','152','757','169573',3344685,'2123','316',1092157.97,1092945.22,0.00,0.00,787.25,258218.00,0.00,0.00,0.00),('1','152','757','169573',3344686,'2124','316',1830548.56,1830829.56,0.00,0.00,281.00,87110.00,0.00,0.00,0.00),('1','152','757','169774',3348200,'2123','316',1092945.22,1095725.99,0.00,0.00,2780.77,912092.56,0.00,0.00,0.00),('1','152','757','169774',3348201,'2124','316',1830829.56,1833498.74,0.00,0.00,2669.18,827445.80,0.00,0.00,0.00),('1','152','757','169932',3351362,'2123','316',1095725.99,1095725.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169932',3351363,'2124','316',1833498.74,1833498.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','169934',3351377,'2123','316',1095725.99,1098516.12,0.00,0.00,2790.13,915162.64,0.00,0.00,0.00),('1','152','757','169934',3351378,'2124','316',1833498.74,1836177.04,0.00,0.00,2678.30,830273.00,0.00,0.00,0.00),('1','152','757','170147',3355105,'2123','316',1098516.12,1098516.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170147',3355106,'2124','316',1836177.04,1836177.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170148',3355107,'2123','316',1098516.12,1101904.02,0.00,0.00,3387.90,1111231.20,0.00,0.00,0.00),('1','152','757','170148',3355108,'2124','316',1836177.04,1837138.71,0.00,0.00,961.67,298117.70,0.00,0.00,0.00),('1','152','757','170248',3356795,'2123','316',1101904.02,1101904.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170248',3356796,'2124','316',1837138.71,1837138.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170250',3356799,'2123','316',1101904.02,1105254.39,0.00,0.00,3350.37,1098921.36,0.00,0.00,0.00),('1','152','757','170250',3356800,'2124','316',1837138.71,1839395.27,0.00,0.00,2256.56,699533.60,0.00,0.00,0.00),('1','152','757','170484',3360824,'2123','316',1105254.39,1105254.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170484',3360825,'2124','316',1839395.27,1839395.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170485',3360826,'2123','316',1105254.39,1109074.70,0.00,0.00,3820.31,1253061.68,0.00,0.00,0.00),('1','152','757','170485',3360827,'2124','316',1839395.27,1841248.09,0.00,0.00,1852.82,574374.20,0.00,0.00,0.00),('1','152','757','170595',3362842,'2123','316',1109074.70,1112477.03,0.00,0.00,3402.33,1115964.24,0.00,0.00,0.00),('1','152','757','170595',3362843,'2124','316',1841248.09,1843424.35,0.00,0.00,2176.26,674640.60,0.00,0.00,0.00),('1','152','757','170599',3362896,'2123','316',1112477.03,1112477.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170599',3362897,'2124','316',1843424.35,1843424.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170813',3366811,'2123','316',1112477.03,1113162.24,0.00,0.00,685.21,224748.88,0.00,0.00,0.00),('1','152','757','170813',3366812,'2124','316',1843424.35,1843674.35,0.00,0.00,250.00,77500.00,0.00,0.00,0.00),('1','152','757','170814',3366813,'2123','316',1113162.24,1116283.12,0.00,0.00,3120.88,1023648.64,0.00,0.00,0.00),('1','152','757','170814',3366814,'2124','316',1843674.35,1845201.70,0.00,0.00,1527.35,473478.50,0.00,0.00,0.00),('1','152','757','170815',3366815,'2123','316',1116283.12,1116283.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','170815',3366816,'2124','316',1845201.70,1845201.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','171177',3373468,'2123','316',1116283.12,1119435.63,0.00,0.00,3152.51,1034023.28,0.00,0.00,0.00),('1','152','757','171177',3373469,'2124','316',1845201.70,1847293.15,0.00,0.00,2091.45,648349.50,0.00,0.00,0.00),('1','152','757','171182',3373551,'2123','316',1119435.63,1119435.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','171182',3373552,'2124','316',1847293.15,1847293.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','171381',3377212,'2123','316',1119435.63,1123678.96,0.00,0.00,4243.33,1391812.24,0.00,0.00,0.00),('1','152','757','171381',3377213,'2124','316',1847293.15,1849120.56,0.00,0.00,1827.41,566497.10,0.00,0.00,0.00),('1','152','757','171384',3377242,'2123','316',1123678.96,1124080.17,0.00,0.00,401.21,131596.88,0.00,0.00,0.00),('1','152','757','171384',3377243,'2124','316',1849120.56,1849637.32,0.00,0.00,516.76,160195.60,0.00,0.00,0.00),('1','152','757','171602',3381084,'2123','316',1124080.17,1127260.59,0.00,0.00,3180.42,1043177.76,0.00,0.00,0.00),('1','152','757','171602',3381085,'2124','316',1849637.32,1851867.16,0.00,0.00,2229.84,691250.40,0.00,0.00,0.00),('1','152','757','171608',3381188,'2123','316',1127260.59,1127260.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','171608',3381189,'2124','316',1851867.16,1851867.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','171674',3382457,'2123','316',1127260.59,1127801.76,0.00,0.00,541.17,177503.76,0.00,0.00,0.00),('1','152','757','171674',3382458,'2124','316',1851867.16,1851879.16,0.00,0.00,12.00,3720.00,0.00,0.00,0.00),('1','152','757','171916',3386722,'2123','316',1127801.76,1131277.89,0.00,0.00,3476.13,1140170.64,0.00,0.00,0.00),('1','152','757','171916',3386723,'2124','316',1851879.16,1853871.73,0.00,0.00,1992.57,617696.70,0.00,0.00,0.00),('1','152','757','172083',3389782,'2123','316',1131277.89,1134962.90,0.00,0.00,3685.01,1208683.28,0.00,0.00,0.00),('1','152','757','172083',3389783,'2124','316',1853871.73,1855611.73,0.00,0.00,1740.00,539400.00,0.00,0.00,0.00),('1','152','757','172084',3389784,'2123','316',1134962.90,1134962.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172084',3389785,'2124','316',1855611.73,1855611.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172368',3394860,'2123','316',1134962.90,1136131.89,0.00,0.00,1168.99,383428.72,0.00,0.00,0.00),('1','152','757','172368',3394861,'2124','316',1855611.73,1855947.73,0.00,0.00,336.00,104160.00,0.00,0.00,0.00),('1','152','757','172374',3394933,'2123','316',1136131.89,1138627.44,0.00,0.00,2495.55,818540.40,0.00,0.00,0.00),('1','152','757','172374',3394934,'2124','316',1855947.73,1857295.33,0.00,0.00,1347.60,417756.00,0.00,0.00,0.00),('1','152','757','172376',3394965,'2123','316',1138627.44,1138627.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172376',3394966,'2124','316',1857295.33,1857295.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172380',3395055,'2123','316',1138627.44,1139320.63,0.00,0.00,693.19,227366.32,0.00,0.00,0.00),('1','152','757','172380',3395056,'2124','316',1857295.33,1857755.39,0.00,0.00,460.06,142618.60,0.00,0.00,0.00),('1','152','757','172670',3400465,'2123','316',1139320.63,1143076.08,0.00,0.00,3755.45,1231787.60,0.00,0.00,0.00),('1','152','757','172670',3400466,'2124','316',1857755.39,1858653.29,0.00,0.00,897.90,278349.00,0.00,0.00,0.00),('1','152','757','172891',3404489,'2123','316',1143076.08,1143740.79,0.00,0.00,664.71,218024.88,0.00,0.00,0.00),('1','152','757','172891',3404490,'2124','316',1858653.29,1858861.29,0.00,0.00,208.00,64480.00,0.00,0.00,0.00),('1','152','757','172893',3404502,'2123','316',1143740.79,1143740.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172893',3404503,'2124','316',1858861.29,1858861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172899',3404586,'2123','316',1143740.79,1143740.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172899',3404587,'2124','316',1858861.29,1858861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','172900',3404588,'2123','316',1143740.79,1147154.86,0.00,0.00,3414.07,1119814.96,0.00,0.00,0.00),('1','152','757','172900',3404589,'2124','316',1858861.29,1861309.91,0.00,0.00,2448.62,759072.20,0.00,0.00,0.00),('1','152','757','173246',3411312,'2123','316',1147154.86,1150098.88,0.00,0.00,2944.02,965638.56,0.00,0.00,0.00),('1','152','757','173246',3411313,'2124','316',1861309.91,1862921.73,0.00,0.00,1611.82,499664.20,0.00,0.00,0.00),('1','152','757','173248',3411323,'2123','316',1150098.88,1150909.13,0.00,0.00,810.25,265762.00,0.00,0.00,0.00),('1','152','757','173248',3411324,'2124','316',1862921.73,1863115.53,0.00,0.00,193.80,60078.00,0.00,0.00,0.00),('1','152','757','173249',3411325,'2123','316',1150909.13,1150909.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','173249',3411326,'2124','316',1863115.53,1863115.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','173551',3417071,'2123','316',1150909.13,1151307.13,0.00,0.00,398.00,130544.00,0.00,0.00,0.00),('1','152','757','173551',3417072,'2124','316',1863115.53,1863115.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','173574',3417502,'2123','316',1151307.13,1154668.23,0.00,0.00,3361.10,1102440.80,0.00,0.00,0.00),('1','152','757','173574',3417503,'2124','316',1863115.53,1864959.28,0.00,0.00,1843.75,571562.50,0.00,0.00,0.00),('1','152','757','173697',3419542,'2123','316',1154668.23,1156351.53,0.00,0.00,1683.30,552122.40,0.00,0.00,0.00),('1','152','757','173697',3419543,'2124','316',1864959.28,1866155.02,0.00,0.00,1195.74,370679.40,0.00,0.00,0.00),('1','152','757','173887',3423196,'2123','316',1156351.53,1157676.17,0.00,0.00,1324.64,434481.92,0.00,0.00,0.00),('1','152','757','173887',3423197,'2124','316',1866155.02,1866360.02,0.00,0.00,205.00,63550.00,0.00,0.00,0.00),('1','152','757','173892',3423255,'2123','316',1157676.17,1160004.28,0.00,0.00,2328.11,763620.08,0.00,0.00,0.00),('1','152','757','173892',3423256,'2124','316',1866360.02,1868135.50,0.00,0.00,1775.48,550398.80,0.00,0.00,0.00),('1','152','757','174061',3426082,'2123','316',1160004.28,1163405.83,0.00,0.00,3401.55,1115708.40,0.00,0.00,0.00),('1','152','757','174061',3426083,'2124','316',1868135.50,1870260.56,0.00,0.00,2125.06,658768.60,0.00,0.00,0.00),('1','152','757','174080',3426459,'2123','316',1163405.83,1163405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174080',3426460,'2124','316',1870260.56,1870260.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174237',3429400,'2123','316',1163405.83,1167051.26,0.00,0.00,3645.43,1195701.04,0.00,0.00,0.00),('1','152','757','174237',3429401,'2124','316',1870260.56,1872254.92,0.00,0.00,1994.36,618251.60,0.00,0.00,0.00),('1','152','757','174465',3433228,'2123','316',1167051.26,1171540.86,0.00,0.00,4489.60,1472588.80,0.00,0.00,0.00),('1','152','757','174465',3433229,'2124','316',1872254.92,1873880.32,0.00,0.00,1625.40,503874.00,0.00,0.00,0.00),('1','152','757','174611',3435842,'2123','316',1171540.86,1174943.74,0.00,0.00,3402.88,1116144.64,0.00,0.00,0.00),('1','152','757','174611',3435843,'2124','316',1873880.32,1875870.49,0.00,0.00,1990.17,616952.70,0.00,0.00,0.00),('1','152','757','174643',3436481,'2123','316',1174943.74,1174943.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174643',3436482,'2124','316',1875870.49,1876070.49,0.00,0.00,200.00,62000.00,0.00,0.00,0.00),('1','152','757','174644',3436483,'2123','316',1174943.74,1174943.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174644',3436484,'2124','316',1876070.49,1876070.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174854',3440313,'2123','316',1174943.74,1174943.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174854',3440314,'2124','316',1876070.49,1876070.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174855',3440315,'2123','316',1174943.74,1176243.59,0.00,0.00,1299.85,426350.80,0.00,0.00,0.00),('1','152','757','174855',3440316,'2124','316',1876070.49,1876746.26,0.00,0.00,675.77,209488.70,0.00,0.00,0.00),('1','152','757','174976',3442650,'2123','316',1176243.59,1178573.05,0.00,0.00,2329.46,764062.88,0.00,0.00,0.00),('1','152','757','174976',3442651,'2124','316',1876746.26,1877815.97,0.00,0.00,1069.71,331610.10,0.00,0.00,0.00),('1','152','757','174983',3442788,'2123','316',1178573.05,1178573.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','174983',3442789,'2124','316',1877815.97,1878098.14,0.00,0.00,282.17,94744.84,0.00,0.00,0.00),('1','152','757','175250',3447592,'2123','316',1178573.05,1182037.98,0.00,0.00,3464.93,1219655.36,0.00,0.00,0.00),('1','152','757','175250',3447593,'2124','316',1878098.14,1880334.21,0.00,0.00,2236.07,702125.98,0.00,0.00,0.00),('1','152','757','175414',3450696,'2123','316',1182037.98,1183852.98,0.00,0.00,1815.00,638880.00,0.00,0.00,0.00),('1','152','757','175414',3450697,'2124','316',1880334.21,1881584.21,0.00,0.00,1250.00,392500.00,0.00,0.00,0.00),('1','152','757','175415',3450698,'2123','316',1183852.98,1185696.17,0.00,0.00,1843.19,648802.88,0.00,0.00,0.00),('1','152','757','175415',3450699,'2124','316',1881584.21,1882317.27,0.00,0.00,733.06,230180.84,0.00,0.00,0.00),('1','152','757','175677',3455433,'2123','316',1185696.17,1185696.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','175677',3455434,'2124','316',1882317.27,1882317.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','175681',3455496,'2123','316',1185696.17,1186470.38,0.00,0.00,774.21,272521.92,0.00,0.00,0.00),('1','152','757','175681',3455497,'2124','316',1882317.27,1882886.11,0.00,0.00,568.84,178615.76,0.00,0.00,0.00),('1','152','757','175735',3456561,'2123','316',1186470.38,1190470.14,0.00,0.00,3999.76,1407915.52,0.00,0.00,0.00),('1','152','757','175735',3456562,'2124','316',1882886.11,1884493.48,0.00,0.00,1607.37,504714.18,0.00,0.00,0.00),('1','152','757','175908',3459632,'2123','316',1190470.14,1190470.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','175908',3459633,'2124','316',1884493.48,1884493.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','175910',3459653,'2123','316',1190470.14,1194926.82,0.00,0.00,4456.68,1568751.36,0.00,0.00,0.00),('1','152','757','175910',3459654,'2124','316',1884493.48,1886119.08,0.00,0.00,1625.60,510438.40,0.00,0.00,0.00),('1','152','757','176077',3462655,'2123','316',1194926.82,1198856.07,0.00,0.00,3929.25,1383096.00,0.00,0.00,0.00),('1','152','757','176077',3462656,'2124','316',1886119.08,1888089.09,0.00,0.00,1970.01,618583.14,0.00,0.00,0.00),('1','152','757','177122',3482164,'2123','316',1198856.07,1201711.60,0.00,0.00,2855.53,1005146.56,0.00,0.00,0.00),('1','152','757','177122',3482165,'2124','316',1888089.09,1890963.32,0.00,0.00,2874.23,902508.22,0.00,0.00,0.00),('1','152','757','177127',3482243,'2123','316',1201711.60,1206528.00,0.00,0.00,4816.40,1695372.80,0.00,0.00,0.00),('1','152','757','177127',3482244,'2124','316',1890963.32,1892172.54,0.00,0.00,1209.22,379695.08,0.00,0.00,0.00),('1','152','757','177138',3482474,'2123','316',1206528.00,1208742.26,0.00,0.00,2214.26,779419.52,0.00,0.00,0.00),('1','152','757','177138',3482475,'2124','316',1892172.54,1892563.54,0.00,0.00,391.00,124338.00,0.00,0.00,0.00),('1','152','757','177150',3482727,'2123','316',1208742.26,1212630.62,0.00,0.00,3888.36,1368702.72,0.00,0.00,0.00),('1','152','757','177150',3482728,'2124','316',1892563.54,1893081.54,0.00,0.00,518.00,164724.00,0.00,0.00,0.00),('1','152','757','177163',3483054,'2123','316',1212630.62,1216728.82,0.00,0.00,4098.20,1442566.40,0.00,0.00,0.00),('1','152','757','177163',3483055,'2124','316',1893081.54,1894959.45,0.00,0.00,1877.91,597175.38,0.00,0.00,0.00),('1','152','757','177410',3488002,'2123','316',1216728.82,1220585.39,0.00,0.00,3856.57,1357512.64,0.00,0.00,0.00),('1','152','757','177410',3488003,'2124','316',1894959.45,1897062.55,0.00,0.00,2103.10,668785.80,0.00,0.00,0.00),('1','152','757','177608',3492076,'2123','316',1220585.39,1224583.36,0.00,0.00,3997.97,1407285.44,0.00,0.00,0.00),('1','152','757','177608',3492077,'2124','316',1897062.55,1898958.63,0.00,0.00,1896.08,602953.44,0.00,0.00,0.00),('1','152','757','177872',3496694,'2123','316',1224583.36,1225546.05,0.00,0.00,962.69,338866.88,0.00,0.00,0.00),('1','152','757','177872',3496695,'2124','316',1898958.63,1899592.63,0.00,0.00,634.00,201612.00,0.00,0.00,0.00),('1','152','757','177887',3496922,'2123','316',1225546.05,1228168.88,0.00,0.00,2622.83,902253.52,0.00,0.00,0.00),('1','152','757','177887',3496923,'2124','316',1899592.63,1901456.41,0.00,0.00,1863.78,585226.92,0.00,0.00,0.00),('1','152','757','177891',3496958,'2123','316',1228168.88,1231241.41,0.00,0.00,3072.53,1056950.32,0.00,0.00,0.00),('1','152','757','177891',3496959,'2124','316',1901456.41,1903641.06,0.00,0.00,2184.65,712876.60,0.00,0.00,0.00),('1','152','757','178077',3500724,'2123','316',1231241.41,1231664.19,0.00,0.00,422.78,145436.32,0.00,0.00,0.00),('1','152','757','178077',3500725,'2124','316',1903641.06,1903858.33,0.00,0.00,217.27,73990.88,0.00,0.00,0.00),('1','152','757','178131',3501725,'2123','316',1231664.19,1233068.40,0.00,0.00,1404.21,483048.24,0.00,0.00,0.00),('1','152','757','178131',3501726,'2124','316',1903858.33,1904634.19,0.00,0.00,775.86,266895.84,0.00,0.00,0.00),('1','152','757','178290',3504614,'2123','316',1233068.40,1234260.63,0.00,0.00,1192.23,410127.12,0.00,0.00,0.00),('1','152','757','178290',3504615,'2124','316',1904634.19,1905270.77,0.00,0.00,636.58,218983.52,0.00,0.00,0.00),('1','152','757','178290',3504616,'2668','316',0.00,1488.51,0.00,0.00,1488.51,470038.74,0.00,0.00,0.00),('1','152','757','178440',3507485,'2123','316',1234260.63,1235131.30,0.00,0.00,870.67,299510.48,0.00,0.00,0.00),('1','152','757','178440',3507486,'2124','316',1905270.77,1905270.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','178440',3507487,'2668','316',1488.51,1928.51,0.00,0.00,440.00,146250.00,0.00,0.00,0.00),('1','152','757','178492',3508351,'2123','316',1235131.30,1236935.72,0.00,0.00,1804.42,635155.84,0.00,0.00,0.00),('1','152','757','178492',3508352,'2124','316',1905270.77,1906589.57,0.00,0.00,1318.80,464217.60,0.00,0.00,0.00),('1','152','757','178492',3508353,'2668','316',1928.51,3554.21,0.00,0.00,1625.70,543841.32,0.00,0.00,0.00),('1','152','757','178718',3512575,'2123','316',1236935.72,1238417.08,0.00,0.00,1481.36,521438.72,0.00,0.00,0.00),('1','152','757','178718',3512576,'2124','316',1906589.57,1907855.73,0.00,0.00,1266.16,445688.32,0.00,0.00,0.00),('1','152','757','178718',3512577,'2668','316',3554.21,4488.40,0.00,0.00,934.19,316372.88,0.00,0.00,0.00),('1','152','757','178813',3514249,'2123','316',1238417.08,1238417.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','178813',3514250,'2124','316',1907855.73,1907855.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','178813',3514251,'2668','316',4488.40,4488.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','178814',3514252,'2123','316',1238417.08,1238645.78,0.00,0.00,228.70,80502.40,0.00,0.00,0.00),('1','152','757','178814',3514253,'2124','316',1907855.73,1908158.65,0.00,0.00,302.92,106627.84,0.00,0.00,0.00),('1','152','757','178814',3514254,'2668','316',4488.40,4876.03,0.00,0.00,387.63,133823.16,0.00,0.00,0.00),('1','152','757','178902',3515754,'2123','316',1238645.78,1238946.69,0.00,0.00,300.91,105920.32,0.00,0.00,0.00),('1','152','757','178902',3515755,'2124','316',1908158.65,1908534.82,0.00,0.00,376.17,132411.84,0.00,0.00,0.00),('1','152','757','178902',3515756,'2668','316',4876.03,5563.37,0.00,0.00,687.34,233766.40,0.00,0.00,0.00),('1','152','757','179002',3517660,'2123','316',1238946.69,1239604.98,0.00,0.00,658.29,231514.08,0.00,0.00,0.00),('1','152','757','179002',3517661,'2124','316',1908534.82,1909495.22,0.00,0.00,960.40,336380.80,0.00,0.00,0.00),('1','152','757','179002',3517662,'2668','316',5563.37,6671.93,0.00,0.00,1108.56,379319.64,0.00,0.00,0.00),('1','152','757','179138',3520234,'2123','316',1239604.98,1240159.70,0.00,0.00,554.72,195261.44,0.00,0.00,0.00),('1','152','757','179138',3520235,'2124','316',1909495.22,1910618.78,0.00,0.00,1123.56,395493.12,0.00,0.00,0.00),('1','152','757','179138',3520236,'2668','316',6671.93,8055.40,0.00,0.00,1383.47,471685.40,0.00,0.00,0.00),('1','152','757','179329',3524092,'2123','316',1240159.70,1240335.72,0.00,0.00,176.02,61959.04,0.00,0.00,0.00),('1','152','757','179329',3524093,'2124','316',1910618.78,1911360.14,0.00,0.00,741.36,260958.72,0.00,0.00,0.00),('1','152','757','179329',3524094,'2668','316',8055.40,8259.31,0.00,0.00,203.91,69704.28,0.00,0.00,0.00),('1','152','757','179360',3524637,'2123','316',1240335.72,1241301.85,0.00,0.00,966.13,346819.36,0.00,0.00,0.00),('1','152','757','179360',3524638,'2124','316',1911360.14,1912432.77,0.00,0.00,1072.63,385410.40,0.00,0.00,0.00),('1','152','757','179360',3524639,'2668','316',8259.31,10584.14,0.00,0.00,2324.83,790720.00,0.00,0.00,0.00),('1','152','757','179547',3528087,'2123','316',1241301.85,1241535.27,0.00,0.00,233.42,84031.20,0.00,0.00,0.00),('1','152','757','179547',3528088,'2124','316',1912432.77,1912602.24,0.00,0.00,169.47,61009.20,0.00,0.00,0.00),('1','152','757','179547',3528089,'2668','316',10584.14,10671.14,0.00,0.00,87.00,29580.00,0.00,0.00,0.00),('1','152','757','179564',3528393,'2123','316',1241535.27,1243340.90,0.00,0.00,1805.63,650026.80,0.00,0.00,0.00),('1','152','757','179564',3528394,'2124','316',1912602.24,1913916.00,0.00,0.00,1313.76,472953.60,0.00,0.00,0.00),('1','152','757','179564',3528395,'2668','316',10671.14,11817.13,0.00,0.00,1145.99,389692.20,0.00,0.00,0.00),('1','152','757','179770',3532419,'2123','316',1243340.90,1243667.62,0.00,0.00,326.72,117619.20,0.00,0.00,0.00),('1','152','757','179770',3532420,'2124','316',1913916.00,1914384.23,0.00,0.00,468.23,168562.80,0.00,0.00,0.00),('1','152','757','179770',3532421,'2668','316',11817.13,12196.35,0.00,0.00,379.22,129279.20,0.00,0.00,0.00),('1','152','757','179871',3534155,'2123','316',1243667.62,1244518.61,0.00,0.00,850.99,306356.40,0.00,0.00,0.00),('1','152','757','179871',3534156,'2124','316',1914384.23,1915279.01,0.00,0.00,894.78,322120.80,0.00,0.00,0.00),('1','152','757','179871',3534157,'2668','316',12196.35,12729.21,0.00,0.00,532.86,181794.80,0.00,0.00,0.00),('1','152','757','179985',3536358,'2123','316',1244518.61,1245708.96,0.00,0.00,1190.35,428526.00,0.00,0.00,0.00),('1','152','757','179985',3536359,'2124','316',1915279.01,1916825.32,0.00,0.00,1546.31,556671.60,0.00,0.00,0.00),('1','152','757','179985',3536360,'2668','316',12729.21,13753.27,0.00,0.00,1024.06,348430.40,0.00,0.00,0.00),('1','152','757','180152',3539560,'2123','316',1245708.96,1245775.71,0.00,0.00,66.75,24030.00,0.00,0.00,0.00),('1','152','757','180152',3539561,'2124','316',1916825.32,1917203.10,0.00,0.00,377.78,136000.80,0.00,0.00,0.00),('1','152','757','180152',3539562,'2668','316',13753.27,14124.46,0.00,0.00,371.19,126258.40,0.00,0.00,0.00),('1','152','757','180166',3539847,'2123','316',1245775.71,1247275.44,0.00,0.00,1499.73,539902.80,0.00,0.00,0.00),('1','152','757','180166',3539848,'2124','316',1917203.10,1918526.84,0.00,0.00,1323.74,476426.40,0.00,0.00,0.00),('1','152','757','180166',3539849,'2668','316',14124.46,16392.90,0.00,0.00,2268.44,771547.40,0.00,0.00,0.00),('1','152','757','180308',3542292,'2123','316',1247275.44,1247641.71,0.00,0.00,366.27,131857.20,0.00,0.00,0.00),('1','152','757','180308',3542293,'2124','316',1918526.84,1918571.03,0.00,0.00,44.19,15908.40,0.00,0.00,0.00),('1','152','757','180308',3542294,'2668','316',16392.90,16465.90,0.00,0.00,73.00,25070.00,0.00,0.00,0.00),('1','152','757','180334',3542770,'2123','316',1247641.71,1248983.47,0.00,0.00,1341.76,483033.60,0.00,0.00,0.00),('1','152','757','180334',3542771,'2124','316',1918571.03,1919929.16,0.00,0.00,1358.13,488926.80,0.00,0.00,0.00),('1','152','757','180334',3542772,'2668','316',16465.90,17815.07,0.00,0.00,1349.17,458779.00,0.00,0.00,0.00),('1','152','757','180571',3546923,'2123','316',1248983.47,1248983.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','180571',3546924,'2124','316',1919929.16,1920316.30,0.00,0.00,387.14,139370.40,0.00,0.00,0.00),('1','152','757','180571',3546925,'2668','316',17815.07,18124.54,0.00,0.00,309.47,105219.80,0.00,0.00,0.00),('1','152','757','180599',3547472,'2123','316',1248983.47,1250412.21,0.00,0.00,1428.74,514346.40,0.00,0.00,0.00),('1','152','757','180599',3547473,'2124','316',1920316.30,1921042.65,0.00,0.00,726.35,261486.00,0.00,0.00,0.00),('1','152','757','180599',3547474,'2668','316',18124.54,19255.39,0.00,0.00,1130.85,384827.80,0.00,0.00,0.00),('1','152','757','180729',3550038,'2123','316',1250412.21,1251268.64,0.00,0.00,856.43,308314.80,0.00,0.00,0.00),('1','152','757','180729',3550039,'2124','316',1921042.65,1921720.21,0.00,0.00,677.56,243921.60,0.00,0.00,0.00),('1','152','757','180729',3550040,'2668','316',19255.39,20371.89,0.00,0.00,1116.50,379610.00,0.00,0.00,0.00),('1','152','757','180910',3553429,'2123','316',1251268.64,1251591.96,0.00,0.00,323.32,116395.20,0.00,0.00,0.00),('1','152','757','180910',3553430,'2124','316',1921720.21,1922276.25,0.00,0.00,556.04,200174.40,0.00,0.00,0.00),('1','152','757','180910',3553431,'2668','316',20371.89,20730.79,0.00,0.00,358.90,122320.40,0.00,0.00,0.00),('1','152','757','180953',3554383,'2123','316',1251591.96,1252991.79,0.00,0.00,1399.83,503938.80,0.00,0.00,0.00),('1','152','757','180953',3554384,'2124','316',1922276.25,1923612.34,0.00,0.00,1336.09,476992.40,0.00,0.00,0.00),('1','152','757','180953',3554385,'2668','316',20730.79,22538.39,0.00,0.00,1807.60,615373.00,0.00,0.00,0.00),('1','152','757','181120',3557543,'2123','316',1252991.79,1253041.79,0.00,0.00,50.00,18000.00,0.00,0.00,0.00),('1','152','757','181120',3557544,'2124','316',1923612.34,1923790.42,0.00,0.00,178.08,64108.80,0.00,0.00,0.00),('1','152','757','181120',3557545,'2668','316',22538.39,22657.39,0.00,0.00,119.00,40460.00,0.00,0.00,0.00),('1','152','757','181126',3557641,'2123','316',1253041.79,1254837.30,0.00,0.00,1795.51,646383.60,0.00,0.00,0.00),('1','152','757','181126',3557642,'2124','316',1923790.42,1925096.54,0.00,0.00,1306.12,470203.20,0.00,0.00,0.00),('1','152','757','181126',3557643,'2668','316',22657.39,23603.17,0.00,0.00,945.78,322632.00,0.00,0.00,0.00),('1','152','757','181333',3561693,'2123','316',1254837.30,1255375.08,0.00,0.00,537.78,193600.80,0.00,0.00,0.00),('1','152','757','181333',3561694,'2124','316',1925096.54,1925420.18,0.00,0.00,323.64,116510.40,0.00,0.00,0.00),('1','152','757','181333',3561695,'2668','316',23603.17,24042.05,0.00,0.00,438.88,149219.20,0.00,0.00,0.00),('1','152','757','181450',3563761,'2123','316',1255375.08,1255713.41,0.00,0.00,338.33,121798.80,0.00,0.00,0.00),('1','152','757','181450',3563762,'2124','316',1925420.18,1926604.02,0.00,0.00,1183.84,426182.40,0.00,0.00,0.00),('1','152','757','181450',3563763,'2668','316',24042.05,24625.35,0.00,0.00,583.30,198861.00,0.00,0.00,0.00),('1','152','757','181520',3565065,'2123','316',1255713.41,1256268.18,0.00,0.00,554.77,199717.20,0.00,0.00,0.00),('1','152','757','181520',3565066,'2124','316',1926604.02,1928183.90,0.00,0.00,1579.88,568756.80,0.00,0.00,0.00),('1','152','757','181520',3565067,'2668','316',24625.35,26004.99,0.00,0.00,1379.64,469077.60,0.00,0.00,0.00),('1','152','757','181642',3566965,'2123','316',1256268.18,1257185.13,0.00,0.00,916.95,329982.00,0.00,0.00,0.00),('1','152','757','181642',3566966,'2124','316',1928183.90,1928589.15,0.00,0.00,405.25,145890.00,0.00,0.00,0.00),('1','152','757','181642',3566967,'2668','316',26004.99,26471.75,0.00,0.00,466.76,158881.80,0.00,0.00,0.00),('1','152','757','181696',3568062,'2123','316',1257185.13,1258243.70,0.00,0.00,1058.57,381085.20,0.00,0.00,0.00),('1','152','757','181696',3568063,'2124','316',1928589.15,1929682.56,0.00,0.00,1093.41,391067.60,0.00,0.00,0.00),('1','152','757','181696',3568064,'2668','316',26471.75,28424.10,0.00,0.00,1952.35,664538.00,0.00,0.00,0.00),('1','152','757','181885',3571239,'2123','316',1258243.70,1258243.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','181885',3571240,'2124','316',1929682.56,1930654.53,0.00,0.00,971.97,349909.20,0.00,0.00,0.00),('1','152','757','181885',3571241,'2668','316',28424.10,28760.10,0.00,0.00,336.00,114240.00,0.00,0.00,0.00),('1','152','757','181898',3571506,'2123','316',1258243.70,1261133.02,0.00,0.00,2889.32,1040155.20,0.00,0.00,0.00),('1','152','757','181898',3571507,'2124','316',1930654.53,1931307.73,0.00,0.00,653.20,235152.00,0.00,0.00,0.00),('1','152','757','181898',3571508,'2668','316',28760.10,29785.58,0.00,0.00,1025.48,348663.20,0.00,0.00,0.00),('1','152','757','182100',3575429,'2123','316',1261133.02,1262331.13,0.00,0.00,1198.11,431319.60,0.00,0.00,0.00),('1','152','757','182100',3575430,'2124','316',1931307.73,1932808.75,0.00,0.00,1501.02,540367.20,0.00,0.00,0.00),('1','152','757','182100',3575431,'2668','316',29785.58,32920.27,0.00,0.00,3134.69,1068278.00,0.00,0.00,0.00),('1','152','757','182299',3578823,'2123','316',1262331.13,1263326.58,0.00,0.00,995.45,358362.00,0.00,0.00,0.00),('1','152','757','182299',3578824,'2124','316',1932808.75,1934513.70,0.00,0.00,1704.95,613782.00,0.00,0.00,0.00),('1','152','757','182299',3578825,'2668','316',32920.27,36154.67,0.00,0.00,3234.40,1100557.00,0.00,0.00,0.00),('1','152','757','182475',3582034,'2123','316',1263326.58,1263371.87,0.00,0.00,45.29,16304.40,0.00,0.00,0.00),('1','152','757','182475',3582035,'2124','316',1934513.70,1935194.90,0.00,0.00,681.20,245232.00,0.00,0.00,0.00),('1','152','757','182475',3582036,'2668','316',36154.67,36376.17,0.00,0.00,221.50,75310.00,0.00,0.00,0.00),('1','152','757','182492',3582290,'2123','316',1263371.87,1264003.86,0.00,0.00,631.99,227516.40,0.00,0.00,0.00),('1','152','757','182492',3582291,'2124','316',1935194.90,1937679.61,0.00,0.00,2484.71,894495.60,0.00,0.00,0.00),('1','152','757','182492',3582292,'2668','316',36376.17,38384.86,0.00,0.00,2008.69,680743.60,0.00,0.00,0.00),('1','152','757','182679',3585801,'2123','316',1264003.86,1265884.64,0.00,0.00,1880.78,677080.80,0.00,0.00,0.00),('1','152','757','182679',3585802,'2124','316',1937679.61,1939694.00,0.00,0.00,2014.39,725180.40,0.00,0.00,0.00),('1','152','757','182679',3585803,'2668','316',38384.86,40083.87,0.00,0.00,1699.01,578441.40,0.00,0.00,0.00),('1','152','757','182829',3588644,'2123','316',1265884.64,1265897.14,0.00,0.00,12.50,4500.00,0.00,0.00,0.00),('1','152','757','182829',3588645,'2124','316',1939694.00,1940001.21,0.00,0.00,307.21,110595.60,0.00,0.00,0.00),('1','152','757','182829',3588646,'2668','316',40083.87,40110.34,0.00,0.00,26.47,8999.80,0.00,0.00,0.00),('1','152','757','182852',3588916,'2123','316',1265897.14,1267091.13,0.00,0.00,1193.99,429836.40,0.00,0.00,0.00),('1','152','757','182852',3588917,'2124','316',1940001.21,1941963.13,0.00,0.00,1961.92,706291.20,0.00,0.00,0.00),('1','152','757','182852',3588918,'2668','316',40110.34,42279.49,0.00,0.00,2169.15,737933.20,0.00,0.00,0.00),('1','152','757','182982',3591393,'2123','316',1267091.13,1267270.33,0.00,0.00,179.20,64512.00,0.00,0.00,0.00),('1','152','757','182982',3591394,'2124','316',1941963.13,1942294.73,0.00,0.00,331.60,119376.00,0.00,0.00,0.00),('1','152','757','182982',3591395,'2668','316',42279.49,42338.90,0.00,0.00,59.41,20199.40,0.00,0.00,0.00),('1','152','757','183041',3592491,'2123','316',1267270.33,1267989.15,0.00,0.00,718.82,258775.20,0.00,0.00,0.00),('1','152','757','183041',3592492,'2124','316',1942294.73,1944086.25,0.00,0.00,1791.52,641947.20,0.00,0.00,0.00),('1','152','757','183041',3592493,'2668','316',42338.90,43688.94,0.00,0.00,1350.04,461001.00,0.00,0.00,0.00),('1','152','757','183205',3595517,'2123','316',1267989.15,1268112.51,0.00,0.00,123.36,44409.60,0.00,0.00,0.00),('1','152','757','183205',3595518,'2124','316',1944086.25,1944317.41,0.00,0.00,231.16,83217.60,0.00,0.00,0.00),('1','152','757','183205',3595519,'2668','316',43688.94,44634.94,0.00,0.00,946.00,321640.00,0.00,0.00,0.00),('1','152','757','183273',3596454,'2123','316',1268112.51,1268595.06,0.00,0.00,482.55,173718.00,0.00,0.00,0.00),('1','152','757','183273',3596455,'2124','316',1944317.41,1946444.21,0.00,0.00,2126.80,765648.00,0.00,0.00,0.00),('1','152','757','183273',3596456,'2668','316',44634.94,46015.70,0.00,0.00,1380.76,471519.60,0.00,0.00,0.00),('1','152','757','183430',3599427,'2123','316',1268595.06,1269507.70,0.00,0.00,912.64,328550.40,0.00,0.00,0.00),('1','152','757','183430',3599428,'2124','316',1946444.21,1948672.79,0.00,0.00,2228.58,802288.80,0.00,0.00,0.00),('1','152','757','183430',3599429,'2668','316',46015.70,47646.38,0.00,0.00,1630.68,556014.80,0.00,0.00,0.00),('1','152','757','183642',3603286,'2123','316',1269507.70,1269956.68,0.00,0.00,448.98,161632.80,0.00,0.00,0.00),('1','152','757','183642',3603287,'2124','316',1948672.79,1950486.04,0.00,0.00,1813.25,650530.00,0.00,0.00,0.00),('1','152','757','183642',3603288,'2668','316',47646.38,49733.04,0.00,0.00,2086.66,714975.60,0.00,0.00,0.00),('1','152','757','183874',3607637,'2123','316',1269956.68,1271309.86,0.00,0.00,1353.18,487144.80,0.00,0.00,0.00),('1','152','757','183874',3607638,'2124','316',1950486.04,1951210.07,0.00,0.00,724.03,260650.80,0.00,0.00,0.00),('1','152','757','183874',3607639,'2668','316',49733.04,51230.46,0.00,0.00,1497.42,512153.00,0.00,0.00,0.00),('1','152','757','184071',3611139,'2123','316',1271309.86,1272420.11,0.00,0.00,1110.25,399690.00,0.00,0.00,0.00),('1','152','757','184071',3611140,'2124','316',1951210.07,1952283.53,0.00,0.00,1073.46,386445.60,0.00,0.00,0.00),('1','152','757','184071',3611141,'2668','316',51230.46,53576.32,0.00,0.00,2345.86,808463.80,0.00,0.00,0.00),('1','152','757','184259',3614495,'2123','316',1272420.11,1272621.56,0.00,0.00,201.45,72522.00,0.00,0.00,0.00),('1','152','757','184259',3614496,'2124','316',1952283.53,1952392.16,0.00,0.00,108.63,39106.80,0.00,0.00,0.00),('1','152','757','184259',3614497,'2668','316',53576.32,54905.12,0.00,0.00,1328.80,451792.00,0.00,0.00,0.00),('1','152','757','184340',3615793,'2123','316',1272621.56,1273271.09,0.00,0.00,649.53,233830.80,0.00,0.00,0.00),('1','152','757','184340',3615794,'2124','316',1952392.16,1953583.36,0.00,0.00,1191.20,428832.00,0.00,0.00,0.00),('1','152','757','184340',3615795,'2668','316',54905.12,56256.92,0.00,0.00,1351.80,462154.00,0.00,0.00,0.00),('1','152','757','184449',3617800,'2123','316',1273271.09,1274065.42,0.00,0.00,794.33,285958.80,0.00,0.00,0.00),('1','152','757','184449',3617801,'2124','316',1953583.36,1954867.67,0.00,0.00,1284.31,462351.60,0.00,0.00,0.00),('1','152','757','184449',3617802,'2668','316',56256.92,58313.20,0.00,0.00,2056.28,700452.20,0.00,0.00,0.00),('1','152','757','184690',3622205,'2123','316',1274065.42,1274715.77,0.00,0.00,650.35,234126.00,0.00,0.00,0.00),('1','152','757','184690',3622206,'2124','316',1954867.67,1956311.26,0.00,0.00,1443.59,519692.40,0.00,0.00,0.00),('1','152','757','184690',3622207,'2668','316',58313.20,59866.29,0.00,0.00,1553.09,530401.00,0.00,0.00,0.00),('1','152','757','184876',3625584,'2123','316',1274715.77,1275463.27,0.00,0.00,747.50,269100.00,0.00,0.00,0.00),('1','152','757','184876',3625585,'2124','316',1956311.26,1957991.55,0.00,0.00,1680.29,604904.40,0.00,0.00,0.00),('1','152','757','184876',3625586,'2668','316',59866.29,61252.49,0.00,0.00,1386.20,473530.20,0.00,0.00,0.00),('1','152','757','185105',3629465,'2123','316',1275463.27,1276307.64,0.00,0.00,844.37,303973.20,0.00,0.00,0.00),('1','152','757','185105',3629466,'2124','316',1957991.55,1959123.31,0.00,0.00,1131.76,407433.60,0.00,0.00,0.00),('1','152','757','185105',3629467,'2668','316',61252.49,63045.60,0.00,0.00,1793.11,610018.60,0.00,0.00,0.00),('1','152','757','185236',3631634,'2123','316',1276307.64,1276362.64,0.00,0.00,55.00,19800.00,0.00,0.00,0.00),('1','152','757','185236',3631635,'2124','316',1959123.31,1959255.26,0.00,0.00,131.95,47502.00,0.00,0.00,0.00),('1','152','757','185236',3631636,'2668','316',63045.60,63577.23,0.00,0.00,531.63,183913.80,0.00,0.00,0.00),('1','152','757','185255',3631885,'2123','316',1276362.64,1277100.25,0.00,0.00,737.61,265539.60,0.00,0.00,0.00),('1','152','757','185255',3631886,'2124','316',1959255.26,1960683.79,0.00,0.00,1428.53,514270.80,0.00,0.00,0.00),('1','152','757','185255',3631887,'2668','316',63577.23,65297.09,0.00,0.00,1719.86,587591.40,0.00,0.00,0.00),('1','152','757','185464',3635764,'2123','316',1277100.25,1277654.79,0.00,0.00,554.54,199634.40,0.00,0.00,0.00),('1','152','757','185464',3635765,'2124','316',1960683.79,1960792.42,0.00,0.00,108.63,39106.80,0.00,0.00,0.00),('1','152','757','185464',3635766,'2668','316',65297.09,65634.98,0.00,0.00,337.89,115049.20,0.00,0.00,0.00),('1','152','757','185539',3637069,'2123','316',1277654.79,1278730.59,0.00,0.00,1075.80,387288.00,0.00,0.00,0.00),('1','152','757','185539',3637070,'2124','316',1960792.42,1961529.59,0.00,0.00,737.17,263781.20,0.00,0.00,0.00),('1','152','757','185539',3637071,'2668','316',65634.98,66504.28,0.00,0.00,869.30,295562.00,0.00,0.00,0.00),('1','152','757','185690',3639719,'2123','316',1278730.59,1279901.67,0.00,0.00,1171.08,421588.80,0.00,0.00,0.00),('1','152','757','185690',3639720,'2124','316',1961529.59,1961723.53,0.00,0.00,193.94,69818.40,0.00,0.00,0.00),('1','152','757','185690',3639721,'2668','316',66504.28,67876.63,0.00,0.00,1372.35,466599.00,0.00,0.00,0.00),('1','152','757','185803',3641697,'2123','316',1279901.67,1280639.27,0.00,0.00,737.60,265536.00,0.00,0.00,0.00),('1','152','757','185803',3641698,'2124','316',1961723.53,1962108.28,0.00,0.00,384.75,138510.00,0.00,0.00,0.00),('1','152','757','185803',3641699,'2668','316',67876.63,69227.02,0.00,0.00,1350.39,460699.40,0.00,0.00,0.00),('1','152','757','185868',3643036,'2123','316',1280639.27,1281411.74,0.00,0.00,772.47,278089.20,0.00,0.00,0.00),('1','152','757','185868',3643037,'2124','316',1962108.28,1963074.46,0.00,0.00,966.18,347824.80,0.00,0.00,0.00),('1','152','757','185868',3643038,'2668','316',69227.02,70494.18,0.00,0.00,1267.16,431401.20,0.00,0.00,0.00),('1','152','757','186051',3646324,'2123','316',1281411.74,1281467.30,0.00,0.00,55.56,20001.60,0.00,0.00,0.00),('1','152','757','186051',3646325,'2124','316',1963074.46,1963074.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186051',3646326,'2668','316',70494.18,70877.16,0.00,0.00,382.98,134872.80,0.00,0.00,0.00),('1','152','757','186090',3647008,'2123','316',1281467.30,1282218.28,0.00,0.00,750.98,270352.80,0.00,0.00,0.00),('1','152','757','186090',3647009,'2124','316',1963074.46,1964919.47,0.00,0.00,1845.01,664203.60,0.00,0.00,0.00),('1','152','757','186090',3647010,'2668','316',70877.16,72178.06,0.00,0.00,1300.90,443361.80,0.00,0.00,0.00),('1','152','757','186314',3650666,'2123','316',1282218.28,1283620.58,0.00,0.00,1402.30,502548.00,0.00,0.00,0.00),('1','152','757','186314',3650667,'2124','316',1964919.47,1965238.14,0.00,0.00,318.67,114721.20,0.00,0.00,0.00),('1','152','757','186314',3650668,'2668','316',72178.06,73000.38,0.00,0.00,822.32,280100.00,0.00,0.00,0.00),('1','152','757','186526',3654321,'2123','316',1283620.58,1283620.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186526',3654322,'2124','316',1965238.14,1965238.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186526',3654323,'2668','316',73000.38,73000.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186528',3654354,'2123','316',1283620.58,1285335.00,0.00,0.00,1714.42,617191.20,0.00,0.00,0.00),('1','152','757','186528',3654355,'2124','316',1965238.14,1966306.61,0.00,0.00,1068.47,384649.20,0.00,0.00,0.00),('1','152','757','186528',3654356,'2668','316',73000.38,74093.41,0.00,0.00,1093.03,372213.60,0.00,0.00,0.00),('1','152','757','186744',3658069,'2123','316',1285335.00,1285726.52,0.00,0.00,391.52,140947.20,0.00,0.00,0.00),('1','152','757','186744',3658070,'2124','316',1966306.61,1966893.93,0.00,0.00,587.32,211435.20,0.00,0.00,0.00),('1','152','757','186744',3658071,'2668','316',74093.41,74877.28,0.00,0.00,783.87,271895.00,0.00,0.00,0.00),('1','152','757','186884',3660452,'2123','316',1285726.52,1285726.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186884',3660453,'2124','316',1966893.93,1966893.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186884',3660454,'2668','316',74877.28,74877.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','186890',3660534,'2123','316',1285726.52,1287019.92,0.00,0.00,1293.40,449780.00,0.00,0.00,0.00),('1','152','757','186890',3660535,'2124','316',1966893.93,1967326.60,0.00,0.00,432.67,155761.20,0.00,0.00,0.00),('1','152','757','186890',3660536,'2668','316',74877.28,75033.49,0.00,0.00,156.21,53111.40,0.00,0.00,0.00),('1','152','757','187016',3662399,'2123','316',1287019.92,1288704.76,0.00,0.00,1684.84,602422.40,0.00,0.00,0.00),('1','152','757','187016',3662400,'2124','316',1967326.60,1968305.22,0.00,0.00,978.62,352303.20,0.00,0.00,0.00),('1','152','757','187016',3662401,'2668','316',75033.49,76132.05,0.00,0.00,1098.56,373960.40,0.00,0.00,0.00),('1','152','757','187153',3664956,'2123','316',1288704.76,1288704.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187153',3664957,'2124','316',1968305.22,1968305.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187153',3664958,'2668','316',76132.05,76132.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187154',3664959,'2123','316',1288704.76,1292157.95,0.00,0.00,3453.19,1216496.60,0.00,0.00,0.00),('1','152','757','187154',3664960,'2124','316',1968305.22,1969716.41,0.00,0.00,1411.19,506828.40,0.00,0.00,0.00),('1','152','757','187154',3664961,'2668','316',76132.05,76640.74,0.00,0.00,508.69,173143.60,0.00,0.00,0.00),('1','152','757','187343',3668394,'2123','316',1292157.95,1292357.30,0.00,0.00,199.35,68818.00,0.00,0.00,0.00),('1','152','757','187343',3668395,'2124','316',1969716.41,1969812.59,0.00,0.00,96.18,34624.80,0.00,0.00,0.00),('1','152','757','187343',3668396,'2668','316',76640.74,76640.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187406',3669422,'2123','316',1292357.30,1293132.68,0.00,0.00,775.38,275606.80,0.00,0.00,0.00),('1','152','757','187406',3669423,'2124','316',1969812.59,1972028.83,0.00,0.00,2216.24,797846.40,0.00,0.00,0.00),('1','152','757','187406',3669424,'2668','316',76640.74,77478.24,0.00,0.00,837.50,284750.00,0.00,0.00,0.00),('1','152','757','187567',3672339,'2123','316',1293132.68,1295558.92,0.00,0.00,2426.24,854569.20,0.00,0.00,0.00),('1','152','757','187567',3672340,'2124','316',1972028.83,1972424.33,0.00,0.00,395.50,140380.00,0.00,0.00,0.00),('1','152','757','187567',3672341,'2668','316',77478.24,77478.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187725',3675085,'2123','316',1295558.92,1295860.24,0.00,0.00,301.32,108475.20,0.00,0.00,0.00),('1','152','757','187725',3675086,'2124','316',1972424.33,1973298.98,0.00,0.00,874.65,314874.00,0.00,0.00,0.00),('1','152','757','187725',3675087,'2668','316',77478.24,78300.24,0.00,0.00,822.00,279852.20,0.00,0.00,0.00),('1','152','757','187790',3676322,'2123','316',1295860.24,1297910.68,0.00,0.00,2050.44,735458.40,0.00,0.00,0.00),('1','152','757','187790',3676323,'2124','316',1973298.98,1973553.16,0.00,0.00,254.18,91504.80,0.00,0.00,0.00),('1','152','757','187790',3676324,'2668','316',78300.24,79640.24,0.00,0.00,1340.00,455600.00,0.00,0.00,0.00),('1','152','757','187952',3679139,'2123','316',1297910.68,1297910.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187952',3679140,'2124','316',1973553.16,1973553.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187952',3679141,'2668','316',79640.24,79640.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','187958',3679282,'2123','316',1297910.68,1297960.21,0.00,0.00,49.53,17830.80,0.00,0.00,0.00),('1','152','757','187958',3679283,'2124','316',1973553.16,1974675.94,0.00,0.00,1122.78,404200.80,0.00,0.00,0.00),('1','152','757','187958',3679284,'2668','316',79640.24,80290.74,0.00,0.00,650.50,221170.00,0.00,0.00,0.00),('1','152','757','188032',3680439,'2123','316',1297960.21,1299201.57,0.00,0.00,1241.36,426051.60,0.00,0.00,0.00),('1','152','757','188032',3680440,'2124','316',1974675.94,1976696.43,0.00,0.00,2020.49,727376.40,0.00,0.00,0.00),('1','152','757','188032',3680441,'2668','316',80290.74,80903.38,0.00,0.00,612.64,208297.60,0.00,0.00,0.00),('1','152','757','188167',3682916,'2123','316',1299201.57,1299201.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','188167',3682917,'2124','316',1976696.43,1976696.83,0.00,0.00,0.40,144.00,0.00,0.00,0.00),('1','152','757','188167',3682918,'2668','316',80903.38,82675.77,0.00,0.00,1772.39,631390.40,0.00,0.00,0.00),('1','152','757','188201',3683486,'2123','316',1299201.57,1301004.68,0.00,0.00,1803.11,649119.60,0.00,0.00,0.00),('1','152','757','188201',3683487,'2124','316',1976696.83,1977061.77,0.00,0.00,364.94,130718.40,0.00,0.00,0.00),('1','152','757','188201',3683488,'2668','316',82675.77,84452.38,0.00,0.00,1776.61,604508.60,0.00,0.00,0.00),('1','152','757','188371',3686296,'2123','316',1301004.68,1302273.95,0.00,0.00,1269.27,456937.20,0.00,0.00,0.00),('1','152','757','188371',3686297,'2124','316',1977061.77,1977130.10,0.00,0.00,68.33,24598.80,0.00,0.00,0.00),('1','152','757','188371',3686298,'2668','316',84452.38,85564.27,0.00,0.00,1111.89,378320.40,0.00,0.00,0.00),('1','152','757','188434',3687308,'2123','316',1302273.95,1304378.29,0.00,0.00,2104.34,756202.40,0.00,0.00,0.00),('1','152','757','188434',3687309,'2124','316',1977130.10,1977332.35,0.00,0.00,202.25,72810.00,0.00,0.00,0.00),('1','152','757','188434',3687310,'2668','316',85564.27,86559.77,0.00,0.00,995.50,338470.00,0.00,0.00,0.00),('1','152','757','188553',3689593,'2123','316',1304378.29,1304378.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','188553',3689594,'2124','316',1977332.35,1978470.35,0.00,0.00,1138.00,409680.00,0.00,0.00,0.00),('1','152','757','188553',3689595,'2668','316',86559.77,86791.58,0.00,0.00,231.81,78815.40,0.00,0.00,0.00),('1','152','757','188596',3690306,'2123','316',1304378.29,1307725.96,0.00,0.00,3347.67,1195681.20,0.00,0.00,0.00),('1','152','757','188596',3690307,'2124','316',1978470.35,1978863.90,0.00,0.00,393.55,141678.00,0.00,0.00,0.00),('1','152','757','188596',3690308,'2668','316',86791.58,88881.08,0.00,0.00,2089.50,710430.00,0.00,0.00,0.00),('1','152','757','188795',3693888,'2123','316',1307725.96,1311680.89,0.00,0.00,3954.93,1399254.80,0.00,0.00,0.00),('1','152','757','188795',3693889,'2124','316',1978863.90,1980709.50,0.00,0.00,1845.60,636858.40,0.00,0.00,0.00),('1','152','757','188795',3693890,'2668','316',88881.08,88890.25,0.00,0.00,9.17,3301.20,0.00,0.00,0.00),('1','152','757','188998',3697536,'2123','316',1311680.89,1315316.14,0.00,0.00,3635.25,1308690.00,0.00,0.00,0.00),('1','152','757','188998',3697537,'2124','316',1980709.50,1980828.95,0.00,0.00,119.45,43002.00,0.00,0.00,0.00),('1','152','757','188998',3697538,'2668','316',88890.25,91563.73,0.00,0.00,2673.48,909038.80,0.00,0.00,0.00),('1','152','757','189190',3700923,'2123','316',1315316.14,1318253.83,0.00,0.00,2937.69,1037739.80,0.00,0.00,0.00),('1','152','757','189190',3700924,'2124','316',1980828.95,1981342.45,0.00,0.00,513.50,184860.00,0.00,0.00,0.00),('1','152','757','189190',3700925,'2668','316',91563.73,92698.46,0.00,0.00,1134.73,385808.20,0.00,0.00,0.00),('1','152','757','189357',3704050,'2123','316',1318253.83,1318253.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189357',3704051,'2124','316',1981342.45,1981342.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189357',3704052,'2668','316',92698.46,92698.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189363',3704154,'2123','316',1318253.83,1319054.27,0.00,0.00,800.44,285238.40,0.00,0.00,0.00),('1','152','757','189363',3704155,'2124','316',1981342.45,1981749.49,0.00,0.00,407.04,141326.20,0.00,0.00,0.00),('1','152','757','189363',3704156,'2668','316',92698.46,92704.05,0.00,0.00,5.59,1900.60,0.00,0.00,0.00),('1','152','757','189400',3704866,'2123','316',1319054.27,1321782.03,0.00,0.00,2727.76,976910.20,0.00,0.00,0.00),('1','152','757','189400',3704867,'2124','316',1981749.49,1982071.75,0.00,0.00,322.26,116013.60,0.00,0.00,0.00),('1','152','757','189400',3704868,'2668','316',92704.05,94083.53,0.00,0.00,1379.48,469023.20,0.00,0.00,0.00),('1','152','757','189580',3707972,'2123','316',1321782.03,1321782.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189580',3707973,'2124','316',1982071.75,1982071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189580',3707974,'2668','316',94083.53,94083.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','189581',3707975,'2123','316',1321782.03,1322107.03,0.00,0.00,325.00,117000.00,0.00,0.00,0.00),('1','152','757','189581',3707976,'2124','316',1982071.75,1982102.31,0.00,0.00,30.56,11001.60,0.00,0.00,0.00),('1','152','757','189581',3707977,'2668','316',94083.53,94339.71,0.00,0.00,256.18,87101.20,0.00,0.00,0.00),('1','152','757','189603',3708346,'2123','316',1322107.03,1325998.30,0.00,0.00,3891.27,1298066.20,0.00,0.00,0.00),('1','152','757','189603',3708347,'2124','316',1982102.31,1982578.87,0.00,0.00,476.56,171561.60,0.00,0.00,0.00),('1','152','757','189603',3708348,'2668','316',94339.71,95261.00,0.00,0.00,921.29,313238.60,0.00,0.00,0.00),('1','152','757','189803',3711830,'2123','316',1325998.30,1329573.71,0.00,0.00,3575.41,1274077.60,0.00,0.00,0.00),('1','152','757','189803',3711831,'2124','316',1982578.87,1983155.37,0.00,0.00,576.50,207540.00,0.00,0.00,0.00),('1','152','757','189803',3711832,'2668','316',95261.00,96791.23,0.00,0.00,1530.23,520339.40,0.00,0.00,0.00),('1','152','757','190012',3716038,'2123','316',1329573.71,1329573.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190012',3716039,'2124','316',1983155.37,1983155.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190012',3716040,'2668','316',96791.23,96791.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190019',3716159,'2123','316',1329573.71,1333368.35,0.00,0.00,3794.64,1333562.20,0.00,0.00,0.00),('1','152','757','190019',3716160,'2124','316',1983155.37,1984074.77,0.00,0.00,919.40,330984.00,0.00,0.00,0.00),('1','152','757','190019',3716161,'2668','316',96791.23,97750.02,0.00,0.00,958.79,325988.60,0.00,0.00,0.00),('1','152','757','190197',3719555,'2123','316',1333368.35,1333368.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190197',3719556,'2124','316',1984074.77,1984074.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190197',3719557,'2668','316',97750.02,97750.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190210',3719693,'2123','316',1333368.35,1334678.20,0.00,0.00,1309.85,460056.00,0.00,0.00,0.00),('1','152','757','190210',3719694,'2124','316',1984074.77,1984439.74,0.00,0.00,364.97,131389.20,0.00,0.00,0.00),('1','152','757','190210',3719695,'2668','316',97750.02,97750.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190295',3721019,'2123','316',1334678.20,1338311.65,0.00,0.00,3633.45,1277388.00,0.00,0.00,0.00),('1','152','757','190295',3721020,'2124','316',1984439.74,1985429.70,0.00,0.00,989.96,356385.60,0.00,0.00,0.00),('1','152','757','190295',3721021,'2668','316',97750.02,97760.02,0.00,0.00,10.00,3400.00,0.00,0.00,0.00),('1','152','757','190420',3723660,'2123','316',1338311.65,1339241.43,0.00,0.00,929.78,328606.60,0.00,0.00,0.00),('1','152','757','190420',3723661,'2124','316',1985429.70,1985622.21,0.00,0.00,192.51,69303.60,0.00,0.00,0.00),('1','152','757','190420',3723662,'2668','316',97760.02,97760.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190499',3724781,'2123','316',1339241.43,1339886.23,0.00,0.00,644.80,225838.00,0.00,0.00,0.00),('1','152','757','190499',3724782,'2124','316',1985622.21,1987671.10,0.00,0.00,2048.89,737600.40,0.00,0.00,0.00),('1','152','757','190499',3724783,'2668','316',97760.02,99146.52,0.00,0.00,1386.50,471410.00,0.00,0.00,0.00),('1','152','757','190656',3728088,'2123','316',1339886.23,1341638.29,0.00,0.00,1752.06,613961.60,0.00,0.00,0.00),('1','152','757','190656',3728089,'2124','316',1987671.10,1987961.40,0.00,0.00,290.30,104508.00,0.00,0.00,0.00),('1','152','757','190656',3728090,'2668','316',99146.52,99146.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190800',3730567,'2123','316',1341638.29,1343583.05,0.00,0.00,1944.76,700053.60,0.00,0.00,0.00),('1','152','757','190800',3730568,'2124','316',1987961.40,1989053.15,0.00,0.00,1091.75,377490.00,0.00,0.00,0.00),('1','152','757','190800',3730569,'2668','316',99146.52,99151.25,0.00,0.00,4.73,1702.80,0.00,0.00,0.00),('1','152','757','190874',3732064,'2123','316',1343583.05,1345856.50,0.00,0.00,2273.45,786599.80,0.00,0.00,0.00),('1','152','757','190874',3732065,'2124','316',1989053.15,1989515.96,0.00,0.00,462.81,166611.60,0.00,0.00,0.00),('1','152','757','190874',3732066,'2668','316',99151.25,99151.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','190984',3733767,'2123','316',1345856.50,1347419.56,0.00,0.00,1563.06,561021.60,0.00,0.00,0.00),('1','152','757','190984',3733768,'2124','316',1989515.96,1989852.15,0.00,0.00,336.19,121028.40,0.00,0.00,0.00),('1','152','757','190984',3733769,'2668','316',99151.25,100552.19,0.00,0.00,1400.94,476347.40,0.00,0.00,0.00),('1','152','757','191058',3735239,'2123','316',1347419.56,1348432.95,0.00,0.00,1013.39,356750.40,0.00,0.00,0.00),('1','152','757','191058',3735240,'2124','316',1989852.15,1990549.76,0.00,0.00,697.61,251139.60,0.00,0.00,0.00),('1','152','757','191058',3735241,'2668','316',100552.19,101280.69,0.00,0.00,728.50,247690.00,0.00,0.00,0.00),('1','152','757','191230',3738302,'2123','316',1348432.95,1348947.65,0.00,0.00,514.70,185292.00,0.00,0.00,0.00),('1','152','757','191230',3738303,'2124','316',1990549.76,1991424.22,0.00,0.00,874.46,297999.80,0.00,0.00,0.00),('1','152','757','191230',3738304,'2668','316',101280.69,101286.25,0.00,0.00,5.56,2001.60,0.00,0.00,0.00),('1','152','757','191285',3739200,'2123','316',1348947.65,1351974.28,0.00,0.00,3026.63,1073225.80,0.00,0.00,0.00),('1','152','757','191285',3739201,'2124','316',1991424.22,1992127.05,0.00,0.00,702.83,253018.80,0.00,0.00,0.00),('1','152','757','191285',3739202,'2668','316',101286.25,102177.06,0.00,0.00,890.81,302875.40,0.00,0.00,0.00),('1','152','757','191483',3742845,'2123','316',1351974.28,1354315.05,0.00,0.00,2340.77,834349.20,0.00,0.00,0.00),('1','152','757','191483',3742846,'2124','316',1992127.05,1992793.49,0.00,0.00,666.44,239918.40,0.00,0.00,0.00),('1','152','757','191483',3742847,'2668','316',102177.06,102858.44,0.00,0.00,681.38,231724.80,0.00,0.00,0.00),('1','152','757','191695',3747031,'2123','316',1354315.05,1356043.57,0.00,0.00,1728.52,618267.20,0.00,0.00,0.00),('1','152','757','191695',3747032,'2124','316',1992793.49,1993475.36,0.00,0.00,681.87,245473.20,0.00,0.00,0.00),('1','152','757','191695',3747033,'2668','316',102858.44,103663.44,0.00,0.00,805.00,273700.00,0.00,0.00,0.00),('1','152','757','191918',3751338,'2123','316',1356043.57,1357248.29,0.00,0.00,1204.72,433699.20,0.00,0.00,0.00),('1','152','757','191918',3751339,'2124','316',1993475.36,1993953.63,0.00,0.00,478.27,172177.20,0.00,0.00,0.00),('1','152','757','191918',3751340,'2668','316',103663.44,104466.44,0.00,0.00,803.00,273020.00,0.00,0.00,0.00),('1','152','757','192128',3754922,'2123','316',1357248.29,1358813.72,0.00,0.00,1565.43,559194.80,0.00,0.00,0.00),('1','152','757','192128',3754923,'2124','316',1993953.63,1994735.62,0.00,0.00,781.99,281516.40,0.00,0.00,0.00),('1','152','757','192128',3754924,'2668','316',104466.44,106499.44,0.00,0.00,2033.00,691220.00,0.00,0.00,0.00),('1','152','757','192324',3758715,'2123','316',1358813.72,1360305.96,0.00,0.00,1492.24,530666.00,0.00,0.00,0.00),('1','152','757','192324',3758716,'2124','316',1994735.62,1995410.54,0.00,0.00,674.92,242971.20,0.00,0.00,0.00),('1','152','757','192324',3758717,'2668','316',106499.44,107159.94,0.00,0.00,660.50,225510.00,0.00,0.00,0.00),('1','152','757','192550',3762744,'2123','316',1360305.96,1361756.45,0.00,0.00,1450.49,521906.40,0.00,0.00,0.00),('1','152','757','192550',3762745,'2124','316',1995410.54,1995907.32,0.00,0.00,496.78,178840.80,0.00,0.00,0.00),('1','152','757','192550',3762746,'2668','316',107159.94,108050.17,0.00,0.00,890.23,302800.40,0.00,0.00,0.00),('1','152','757','192741',3766115,'2123','316',1361756.45,1362082.78,0.00,0.00,326.33,115078.80,0.00,0.00,0.00),('1','152','757','192741',3766116,'2124','316',1995907.32,1995922.60,0.00,0.00,15.28,5500.80,0.00,0.00,0.00),('1','152','757','192741',3766117,'2668','316',108050.17,108050.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','192816',3767186,'2123','316',1362082.78,1363522.18,0.00,0.00,1439.40,516314.00,0.00,0.00,0.00),('1','152','757','192816',3767187,'2124','316',1995922.60,1996914.01,0.00,0.00,991.41,342757.60,0.00,0.00,0.00),('1','152','757','192816',3767188,'2668','316',108050.17,108069.61,0.00,0.00,19.44,6998.40,0.00,0.00,0.00),('1','152','757','192943',3769852,'2123','316',1363522.18,1365603.57,0.00,0.00,2081.39,735965.20,0.00,0.00,0.00),('1','152','757','192943',3769853,'2124','316',1996914.01,1997344.28,0.00,0.00,430.27,154897.20,0.00,0.00,0.00),('1','152','757','192943',3769854,'2668','316',108069.61,108804.54,0.00,0.00,734.93,249896.20,0.00,0.00,0.00),('1','152','757','193166',3773947,'2123','316',1365603.57,1368062.38,0.00,0.00,2458.81,870301.60,0.00,0.00,0.00),('1','152','757','193166',3773948,'2124','316',1997344.28,1997942.45,0.00,0.00,598.17,215341.20,0.00,0.00,0.00),('1','152','757','193166',3773949,'2668','316',108804.54,109927.09,0.00,0.00,1122.55,381728.20,0.00,0.00,0.00),('1','152','757','193402',3778801,'2123','316',1368062.38,1369247.04,0.00,0.00,1184.66,420099.00,0.00,0.00,0.00),('1','152','757','193402',3778802,'2124','316',1997942.45,1998257.04,0.00,0.00,314.59,113252.40,0.00,0.00,0.00),('1','152','757','193402',3778803,'2668','316',109927.09,109927.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193511',3780668,'2123','316',1369247.04,1369247.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193511',3780669,'2124','316',1998257.04,1998257.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193511',3780670,'2668','316',109927.09,109927.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193512',3780671,'2123','316',1369247.04,1370253.69,0.00,0.00,1006.65,362394.00,0.00,0.00,0.00),('1','152','757','193512',3780672,'2124','316',1998257.04,1998372.59,0.00,0.00,115.55,41598.00,0.00,0.00,0.00),('1','152','757','193512',3780673,'2668','316',109927.09,111159.15,0.00,0.00,1232.06,418961.60,0.00,0.00,0.00),('1','152','757','193619',3782824,'2123','316',1370253.69,1372033.30,0.00,0.00,1779.61,633979.60,0.00,0.00,0.00),('1','152','757','193619',3782825,'2124','316',1998372.59,1998944.42,0.00,0.00,571.83,205858.80,0.00,0.00,0.00),('1','152','757','193619',3782826,'2668','316',111159.15,112106.15,0.00,0.00,947.00,321980.00,0.00,0.00,0.00),('1','152','757','193847',3786843,'2123','316',1372033.30,1372033.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193847',3786844,'2124','316',1998944.42,1998944.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193847',3786845,'2668','316',112106.15,112106.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193862',3786969,'2123','316',1372033.30,1372527.29,0.00,0.00,493.99,173189.40,0.00,0.00,0.00),('1','152','757','193862',3786970,'2124','316',1998944.42,1999062.76,0.00,0.00,118.34,42602.40,0.00,0.00,0.00),('1','152','757','193862',3786971,'2668','316',112106.15,112119.48,0.00,0.00,13.33,4798.80,0.00,0.00,0.00),('1','152','757','193904',3787562,'2123','316',1372527.29,1372527.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193904',3787563,'2124','316',1999062.76,1999062.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193904',3787564,'2668','316',112119.48,112119.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','193909',3787653,'2123','316',1372527.29,1373120.07,0.00,0.00,592.78,206223.20,0.00,0.00,0.00),('1','152','757','193909',3787654,'2124','316',1999062.76,2001022.63,0.00,0.00,1959.87,705553.20,0.00,0.00,0.00),('1','152','757','193909',3787655,'2668','316',112119.48,112704.77,0.00,0.00,585.29,195698.60,0.00,0.00,0.00),('1','152','757','194059',3790705,'2123','316',1373120.07,1373221.95,0.00,0.00,101.88,36676.80,0.00,0.00,0.00),('1','152','757','194059',3790706,'2124','316',2001022.63,2001022.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','194059',3790707,'2668','316',112704.77,112704.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','194078',3790899,'2123','316',1373221.95,1375001.62,0.00,0.00,1779.67,622923.20,0.00,0.00,0.00),('1','152','757','194078',3790900,'2124','316',2001022.63,2001380.21,0.00,0.00,357.58,128728.80,0.00,0.00,0.00),('1','152','757','194078',3790901,'2668','316',112704.77,113176.90,0.00,0.00,472.13,157691.42,0.00,0.00,0.00),('1','152','757','194205',3793160,'2123','316',1375001.62,1375917.29,0.00,0.00,915.67,329641.20,0.00,0.00,0.00),('1','152','757','194205',3793161,'2124','316',2001380.21,2001433.94,0.00,0.00,53.73,19342.80,0.00,0.00,0.00),('1','152','757','194205',3793162,'2668','316',113176.90,113615.40,0.00,0.00,438.50,146459.00,0.00,0.00,0.00),('1','152','757','194287',3794822,'2123','316',1375917.29,1376068.37,0.00,0.00,151.08,52620.80,0.00,0.00,0.00),('1','152','757','194287',3794823,'2124','316',2001433.94,2001520.23,0.00,0.00,86.29,31064.40,0.00,0.00,0.00),('1','152','757','194287',3794824,'2668','316',113615.40,113615.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','194328',3795423,'2123','316',1376068.37,1377845.32,0.00,0.00,1776.95,639702.00,0.00,0.00,0.00),('1','152','757','194328',3795424,'2124','316',2001520.23,2001769.52,0.00,0.00,249.29,89744.40,0.00,0.00,0.00),('1','152','757','194328',3795425,'2668','316',113615.40,114692.85,0.00,0.00,1077.45,365676.54,0.00,0.00,0.00),('1','152','757','194486',3798320,'2123','316',1377845.32,1379017.96,0.00,0.00,1172.64,403549.22,0.00,0.00,0.00),('1','152','757','194486',3798321,'2124','316',2001769.52,2004376.20,0.00,0.00,2606.68,938404.80,0.00,0.00,0.00),('1','152','757','194486',3798322,'2668','316',114692.85,115864.15,0.00,0.00,1171.30,398167.00,0.00,0.00,0.00),('1','152','757','194663',3801526,'2123','316',1379017.96,1381175.06,0.00,0.00,2157.10,763517.00,0.00,0.00,0.00),('1','152','757','194663',3801527,'2124','316',2004376.20,2005065.54,0.00,0.00,689.34,247362.40,0.00,0.00,0.00),('1','152','757','194663',3801528,'2668','316',115864.15,117226.62,0.00,0.00,1362.47,455155.20,0.00,0.00,0.00),('1','152','757','194960',3807356,'2123','316',1381175.06,1382205.46,0.00,0.00,1030.40,370944.00,0.00,0.00,0.00),('1','152','757','194960',3807357,'2124','316',2005065.54,2005065.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','194960',3807358,'2668','316',117226.62,117695.58,0.00,0.00,468.96,156632.64,0.00,0.00,0.00),('1','152','757','195010',3808185,'2123','316',1382205.46,1383056.54,0.00,0.00,851.08,306388.80,0.00,0.00,0.00),('1','152','757','195010',3808186,'2124','316',2005065.54,2005065.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','195010',3808187,'2668','316',117695.58,118367.58,0.00,0.00,672.00,224448.00,0.00,0.00,0.00),('1','152','757','195071',3809289,'2123','316',1383056.54,1385405.36,0.00,0.00,2348.82,831564.58,0.00,0.00,0.00),('1','152','757','195071',3809290,'2124','316',2005065.54,2005600.27,0.00,0.00,534.73,191646.62,0.00,0.00,0.00),('1','152','757','195071',3809291,'2668','316',118367.58,118837.15,0.00,0.00,469.57,156901.38,0.00,0.00,0.00),('1','152','757','195418',3815198,'2123','316',1385405.36,1386356.54,0.00,0.00,951.18,331083.96,0.00,0.00,0.00),('1','152','757','195418',3815199,'2124','316',2005600.27,2005637.05,0.00,0.00,36.78,12799.44,0.00,0.00,0.00),('1','152','757','195418',3815200,'2668','316',118837.15,119589.15,0.00,0.00,752.00,248160.00,0.00,0.00,0.00),('1','152','757','195507',3817034,'2123','316',1386356.54,1387487.98,0.00,0.00,1131.44,390441.72,0.00,0.00,0.00),('1','152','757','195507',3817035,'2124','316',2005637.05,2006228.72,0.00,0.00,591.67,205901.16,0.00,0.00,0.00),('1','152','757','195507',3817036,'2668','316',119589.15,121573.85,0.00,0.00,1984.70,654951.00,0.00,0.00,0.00),('1','152','757','195726',3820654,'2123','316',1387487.98,1387487.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','195726',3820655,'2124','316',2006228.72,2006228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','195726',3820656,'2668','316',121573.85,121573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','195731',3820718,'2123','316',1387487.98,1387943.91,0.00,0.00,455.93,158663.64,0.00,0.00,0.00),('1','152','757','195731',3820719,'2124','316',2006228.72,2006254.15,0.00,0.00,25.43,8849.64,0.00,0.00,0.00),('1','152','757','195731',3820720,'2668','316',121573.85,121834.01,0.00,0.00,260.16,85909.68,0.00,0.00,0.00),('1','152','757','195784',3821514,'2123','316',1387943.91,1390271.58,0.00,0.00,2327.67,803445.12,0.00,0.00,0.00),('1','152','757','195784',3821515,'2124','316',2006254.15,2006863.27,0.00,0.00,609.12,211973.76,0.00,0.00,0.00),('1','152','757','195784',3821516,'2668','316',121834.01,122967.39,0.00,0.00,1133.38,374015.40,0.00,0.00,0.00),('1','152','757','195994',3825479,'2123','316',1390271.58,1390877.45,0.00,0.00,605.87,202263.24,0.00,0.00,0.00),('1','152','757','195994',3825480,'2124','316',2006863.27,2007184.64,0.00,0.00,321.37,111836.76,0.00,0.00,0.00),('1','152','757','195994',3825481,'2668','316',122967.39,122967.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','196070',3826608,'2123','316',1390877.45,1392803.85,0.00,0.00,1926.40,661387.20,0.00,0.00,0.00),('1','152','757','196070',3826609,'2124','316',2007184.64,2007795.27,0.00,0.00,610.63,212499.24,0.00,0.00,0.00),('1','152','757','196070',3826610,'2668','316',122967.39,123875.75,0.00,0.00,908.36,299758.80,0.00,0.00,0.00),('1','152','757','196218',3829683,'2123','316',1392803.85,1393334.39,0.00,0.00,530.54,178237.92,0.00,0.00,0.00),('1','152','757','196218',3829684,'2124','316',2007795.27,2008827.10,0.00,0.00,1031.83,359076.84,0.00,0.00,0.00),('1','152','757','196218',3829685,'2668','316',123875.75,124622.75,0.00,0.00,747.00,246510.00,0.00,0.00,0.00),('1','152','757','196393',3832936,'2123','316',1393334.39,1393413.98,0.00,0.00,79.59,27697.32,0.00,0.00,0.00),('1','152','757','196393',3832937,'2124','316',2008827.10,2009063.07,0.00,0.00,235.97,82117.56,0.00,0.00,0.00),('1','152','757','196393',3832938,'2668','316',124622.75,124872.75,0.00,0.00,250.00,82500.00,0.00,0.00,0.00),('1','152','757','196450',3833831,'2123','316',1393413.98,1395898.68,0.00,0.00,2484.70,855498.12,0.00,0.00,0.00),('1','152','757','196450',3833832,'2124','316',2009063.07,2010141.69,0.00,0.00,1078.62,372587.76,0.00,0.00,0.00),('1','152','757','196450',3833833,'2668','316',124872.75,126049.75,0.00,0.00,1177.00,388410.00,0.00,0.00,0.00),('1','152','757','196664',3837612,'2123','316',1395898.68,1396242.18,0.00,0.00,343.50,116028.00,0.00,0.00,0.00),('1','152','757','196664',3837613,'2124','316',2010141.69,2010202.74,0.00,0.00,61.05,21245.40,0.00,0.00,0.00),('1','152','757','196664',3837614,'2668','316',126049.75,126049.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','196708',3838304,'2123','316',1396242.18,1396450.37,0.00,0.00,208.19,69038.12,0.00,0.00,0.00),('1','152','757','196708',3838305,'2124','316',2010202.74,2012464.30,0.00,0.00,2261.56,787022.88,0.00,0.00,0.00),('1','152','757','196708',3838306,'2668','316',126049.75,127075.28,0.00,0.00,1025.53,330220.66,0.00,0.00,0.00),('1','152','757','196890',3841650,'2123','316',1396450.37,1397764.15,0.00,0.00,1313.78,457195.44,0.00,0.00,0.00),('1','152','757','196890',3841651,'2124','316',2012464.30,2012529.49,0.00,0.00,65.19,22686.12,0.00,0.00,0.00),('1','152','757','196890',3841652,'2668','316',127075.28,128025.28,0.00,0.00,950.00,305900.00,0.00,0.00,0.00),('1','152','757','197028',3844236,'2123','316',1397764.15,1399000.35,0.00,0.00,1236.20,412671.52,0.00,0.00,0.00),('1','152','757','197028',3844237,'2124','316',2012529.49,2012751.95,0.00,0.00,222.46,77416.08,0.00,0.00,0.00),('1','152','757','197028',3844238,'2668','316',128025.28,128135.20,0.00,0.00,109.92,35394.24,0.00,0.00,0.00),('1','152','757','197132',3846000,'2123','316',1399000.35,1399391.49,0.00,0.00,391.14,127863.80,0.00,0.00,0.00),('1','152','757','197132',3846001,'2124','316',2012751.95,2014018.94,0.00,0.00,1266.99,440912.52,0.00,0.00,0.00),('1','152','757','197132',3846002,'2668','316',128135.20,128135.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','197226',3847736,'2123','316',1399391.49,1401547.09,0.00,0.00,2155.60,750148.80,0.00,0.00,0.00),('1','152','757','197226',3847737,'2124','316',2014018.94,2014059.46,0.00,0.00,40.52,14100.96,0.00,0.00,0.00),('1','152','757','197226',3847738,'2668','316',128135.20,129694.50,0.00,0.00,1559.30,502094.60,0.00,0.00,0.00),('1','152','757','197323',3849821,'2123','316',238337.61,241722.17,0.00,0.00,3384.56,1117779.62,0.00,0.00,0.00),('1','152','757','197323',3849822,'2124','316',216594.14,218417.01,0.00,0.00,1822.87,634358.76,0.00,0.00,0.00),('1','152','757','197323',3849823,'2668','316',129694.50,129694.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','197519',3852498,'2123','316',241722.17,243616.42,0.00,0.00,1894.25,634675.28,0.00,0.00,0.00),('1','152','757','197519',3852499,'2124','316',218417.01,219801.22,0.00,0.00,1384.21,481705.08,0.00,0.00,0.00),('1','152','757','197519',3852500,'2668','316',129694.50,129694.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','197857',3858634,'2123','316',243616.42,245130.88,0.00,0.00,1514.46,492608.08,0.00,0.00,0.00),('1','152','757','197857',3858635,'2124','316',219801.22,220793.07,0.00,0.00,991.85,345163.80,0.00,0.00,0.00),('1','152','757','197857',3858636,'2668','316',129694.50,129704.32,0.00,0.00,9.82,3417.36,0.00,0.00,0.00),('1','152','757','198097',3862880,'2123','316',245130.88,246009.86,0.00,0.00,878.98,290519.04,0.00,0.00,0.00),('1','152','757','198097',3862881,'2124','316',220793.07,221385.80,0.00,0.00,592.73,206270.04,0.00,0.00,0.00),('1','152','757','198097',3862882,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198107',3863023,'2123','316',246009.86,248326.18,0.00,0.00,2316.32,770014.50,0.00,0.00,0.00),('1','152','757','198107',3863024,'2124','316',221385.80,222698.49,0.00,0.00,1312.69,456816.12,0.00,0.00,0.00),('1','152','757','198107',3863025,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198350',3867050,'2123','316',248326.18,250072.37,0.00,0.00,1746.19,573471.12,0.00,0.00,0.00),('1','152','757','198350',3867051,'2124','316',222698.49,223625.19,0.00,0.00,926.70,322491.60,0.00,0.00,0.00),('1','152','757','198350',3867052,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198542',3870467,'2123','316',250072.37,250072.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198542',3870468,'2124','316',223625.19,223625.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198542',3870469,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198544',3870504,'2123','316',250072.37,250227.88,0.00,0.00,155.51,52817.48,0.00,0.00,0.00),('1','152','757','198544',3870505,'2124','316',223625.19,223756.08,0.00,0.00,130.89,45549.72,0.00,0.00,0.00),('1','152','757','198544',3870506,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198553',3870691,'2123','316',250227.88,252091.73,0.00,0.00,1863.85,618914.80,0.00,0.00,0.00),('1','152','757','198553',3870692,'2124','316',223756.08,225097.55,0.00,0.00,1341.47,466831.56,0.00,0.00,0.00),('1','152','757','198553',3870693,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198835',3875128,'2123','316',252091.73,254115.75,0.00,0.00,2024.02,684637.96,0.00,0.00,0.00),('1','152','757','198835',3875129,'2124','316',225097.55,225614.66,0.00,0.00,517.11,179954.28,0.00,0.00,0.00),('1','152','757','198835',3875130,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198945',3877303,'2123','316',254115.75,254473.49,0.00,0.00,357.74,120593.52,0.00,0.00,0.00),('1','152','757','198945',3877304,'2124','316',225614.66,225894.35,0.00,0.00,279.69,97332.12,0.00,0.00,0.00),('1','152','757','198945',3877305,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','198970',3877759,'2123','316',254473.49,257082.06,0.00,0.00,2608.57,861266.28,0.00,0.00,0.00),('1','152','757','198970',3877760,'2124','316',225894.35,227588.49,0.00,0.00,1694.14,589560.72,0.00,0.00,0.00),('1','152','757','198970',3877761,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','199190',3881693,'2123','316',257082.06,257613.09,0.00,0.00,531.03,170991.66,0.00,0.00,0.00),('1','152','757','199190',3881694,'2124','316',227588.49,227870.82,0.00,0.00,282.33,98250.84,0.00,0.00,0.00),('1','152','757','199190',3881695,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','199356',3884175,'2123','316',257613.09,258488.77,0.00,0.00,875.68,289094.52,0.00,0.00,0.00),('1','152','757','199356',3884176,'2124','316',227870.82,228569.39,0.00,0.00,698.57,243102.36,0.00,0.00,0.00),('1','152','757','199356',3884177,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','199435',3885499,'2123','316',258488.77,260291.51,0.00,0.00,1802.74,594891.22,0.00,0.00,0.00),('1','152','757','199435',3885500,'2124','316',228569.39,230749.97,0.00,0.00,2180.58,743241.84,0.00,0.00,0.00),('1','152','757','199435',3885501,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','199638',3889130,'2123','316',260291.51,262107.48,0.00,0.00,1815.97,594414.86,0.00,0.00,0.00),('1','152','757','199638',3889131,'2124','316',230749.97,231953.21,0.00,0.00,1203.24,418727.52,0.00,0.00,0.00),('1','152','757','199638',3889132,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','199854',3892381,'2123','316',262107.48,264604.00,0.00,0.00,2496.52,815116.38,0.00,0.00,0.00),('1','152','757','199854',3892382,'2124','316',231953.21,233463.08,0.00,0.00,1509.87,525434.76,0.00,0.00,0.00),('1','152','757','199854',3892383,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200088',3896698,'2123','316',264604.00,264968.60,0.00,0.00,364.60,121030.80,0.00,0.00,0.00),('1','152','757','200088',3896699,'2124','316',233463.08,233606.30,0.00,0.00,143.22,49840.56,0.00,0.00,0.00),('1','152','757','200088',3896700,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200154',3897730,'2123','316',264968.60,267137.99,0.00,0.00,2169.39,705842.56,0.00,0.00,0.00),('1','152','757','200154',3897731,'2124','316',233606.30,234963.14,0.00,0.00,1356.84,471080.26,0.00,0.00,0.00),('1','152','757','200154',3897732,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200282',3900148,'2123','316',267137.99,268500.12,0.00,0.00,1362.13,446357.24,0.00,0.00,0.00),('1','152','757','200282',3900149,'2124','316',234963.14,235933.71,0.00,0.00,970.57,337758.36,0.00,0.00,0.00),('1','152','757','200282',3900150,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200439',3902955,'2123','316',268500.12,268964.24,0.00,0.00,464.12,152439.76,0.00,0.00,0.00),('1','152','757','200439',3902956,'2124','316',235933.71,236277.10,0.00,0.00,343.39,119499.72,0.00,0.00,0.00),('1','152','757','200439',3902957,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200479',3903898,'2123','316',268964.24,271915.70,0.00,0.00,2951.46,979125.08,0.00,0.00,0.00),('1','152','757','200479',3903899,'2124','316',236277.10,238140.37,0.00,0.00,1863.27,648417.96,0.00,0.00,0.00),('1','152','757','200479',3903900,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200681',3907432,'2123','316',271915.70,274524.76,0.00,0.00,2609.06,865392.70,0.00,0.00,0.00),('1','152','757','200681',3907433,'2124','316',238140.37,239783.32,0.00,0.00,1642.95,571746.60,0.00,0.00,0.00),('1','152','757','200681',3907434,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','200904',3911350,'2123','316',274524.76,275827.00,0.00,0.00,1302.24,429901.98,0.00,0.00,0.00),('1','152','757','200904',3911351,'2124','316',239783.32,240299.97,0.00,0.00,516.65,179794.20,0.00,0.00,0.00),('1','152','757','200904',3911352,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201005',3912755,'2123','316',275827.00,275827.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201005',3912756,'2124','316',240299.97,240299.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201005',3912757,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201009',3912815,'2123','316',275827.00,277472.39,0.00,0.00,1645.39,538977.72,0.00,0.00,0.00),('1','152','757','201009',3912816,'2124','316',240299.97,241320.36,0.00,0.00,1020.39,355095.72,0.00,0.00,0.00),('1','152','757','201009',3912817,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201097',3914509,'2123','316',277472.39,279412.66,0.00,0.00,1940.27,642976.82,0.00,0.00,0.00),('1','152','757','201097',3914510,'2124','316',241320.36,242504.31,0.00,0.00,1183.95,412014.60,0.00,0.00,0.00),('1','152','757','201097',3914511,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201288',3917737,'2123','316',279412.66,280027.02,0.00,0.00,614.36,203399.88,0.00,0.00,0.00),('1','152','757','201288',3917738,'2124','316',242504.31,242927.70,0.00,0.00,423.39,147339.72,0.00,0.00,0.00),('1','152','757','201288',3917739,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201294',3917839,'2123','316',280027.02,280684.08,0.00,0.00,657.06,214987.38,0.00,0.00,0.00),('1','152','757','201294',3917840,'2124','316',242927.70,243825.36,0.00,0.00,897.66,310338.96,0.00,0.00,0.00),('1','152','757','201294',3917841,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201404',3919640,'2123','316',280684.08,282096.52,0.00,0.00,1412.44,471683.58,0.00,0.00,0.00),('1','152','757','201404',3919641,'2124','316',243825.36,244876.70,0.00,0.00,1051.34,365866.32,0.00,0.00,0.00),('1','152','757','201404',3919642,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201515',3921645,'2123','316',282096.52,284656.00,0.00,0.00,2559.48,851218.04,0.00,0.00,0.00),('1','152','757','201515',3921646,'2124','316',244876.70,245907.97,0.00,0.00,1031.27,358881.96,0.00,0.00,0.00),('1','152','757','201515',3921647,'2668','316',129704.32,129704.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','201804',3927185,'2123','316',284656.00,287472.82,0.00,0.00,2816.82,929800.36,0.00,0.00,0.00),('1','152','757','201804',3927186,'2124','316',245907.97,247454.56,0.00,0.00,1546.59,538213.32,0.00,0.00,0.00),('1','152','757','201804',3927187,'2668','316',129704.32,129718.83,0.00,0.00,14.51,5049.48,0.00,0.00,0.00),('1','152','757','202012',3931454,'2123','316',287472.82,287472.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202012',3931455,'2124','316',247454.56,247454.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202012',3931456,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202014',3931465,'2123','316',287472.82,288362.66,0.00,0.00,889.84,290535.34,0.00,0.00,0.00),('1','152','757','202014',3931466,'2124','316',247454.56,247929.61,0.00,0.00,475.05,165317.40,0.00,0.00,0.00),('1','152','757','202014',3931467,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202016',3931484,'2123','316',288362.66,291214.41,0.00,0.00,2851.75,935729.00,0.00,0.00,0.00),('1','152','757','202016',3931485,'2124','316',247929.61,249497.78,0.00,0.00,1568.17,545723.16,0.00,0.00,0.00),('1','152','757','202016',3931486,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202174',3934153,'2123','316',291214.41,291745.14,0.00,0.00,530.73,175594.04,0.00,0.00,0.00),('1','152','757','202174',3934154,'2124','316',249497.78,249839.03,0.00,0.00,341.25,118755.00,0.00,0.00,0.00),('1','152','757','202174',3934155,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202199',3934515,'2123','316',291745.14,294112.33,0.00,0.00,2367.19,784080.12,0.00,0.00,0.00),('1','152','757','202199',3934516,'2124','316',249839.03,251262.60,0.00,0.00,1423.57,495402.36,0.00,0.00,0.00),('1','152','757','202199',3934517,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202413',3938303,'2123','316',294112.33,295595.14,0.00,0.00,1482.81,495061.88,0.00,0.00,0.00),('1','152','757','202413',3938304,'2124','316',251262.60,252214.59,0.00,0.00,951.99,331292.52,0.00,0.00,0.00),('1','152','757','202413',3938305,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202627',3942013,'2123','316',295595.14,295661.21,0.00,0.00,66.07,22992.36,0.00,0.00,0.00),('1','152','757','202627',3942014,'2124','316',252214.59,252275.92,0.00,0.00,61.33,21342.84,0.00,0.00,0.00),('1','152','757','202627',3942015,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202687',3942785,'2123','316',295661.21,298211.51,0.00,0.00,2550.30,834917.84,0.00,0.00,0.00),('1','152','757','202687',3942786,'2124','316',252275.92,253530.80,0.00,0.00,1254.88,436698.24,0.00,0.00,0.00),('1','152','757','202687',3942787,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','202834',3945778,'2123','316',298211.51,299400.24,0.00,0.00,1188.73,405611.04,0.00,0.00,0.00),('1','152','757','202834',3945779,'2124','316',253530.80,254368.46,0.00,0.00,837.66,301495.56,0.00,0.00,0.00),('1','152','757','202834',3945780,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203021',3949138,'2123','316',299400.24,300398.82,0.00,0.00,998.58,344520.00,0.00,0.00,0.00),('1','152','757','203021',3949139,'2124','316',254368.46,254870.65,0.00,0.00,502.19,180788.40,0.00,0.00,0.00),('1','152','757','203021',3949140,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203093',3950703,'2123','316',300398.82,302759.96,0.00,0.00,2361.14,813859.20,0.00,0.00,0.00),('1','152','757','203093',3950704,'2124','316',254870.65,256397.11,0.00,0.00,1526.46,549525.60,0.00,0.00,0.00),('1','152','757','203093',3950705,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203336',3954805,'2123','316',302759.96,305983.23,0.00,0.00,3223.27,1108050.96,0.00,0.00,0.00),('1','152','757','203336',3954806,'2124','316',256397.11,258180.90,0.00,0.00,1783.79,642164.40,0.00,0.00,0.00),('1','152','757','203336',3954807,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203511',3958222,'2123','316',305983.23,309745.12,0.00,0.00,3761.89,1280715.84,0.00,0.00,0.00),('1','152','757','203511',3958223,'2124','316',258180.90,260060.06,0.00,0.00,1879.16,676497.60,0.00,0.00,0.00),('1','152','757','203511',3958224,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203713',3961890,'2123','316',309745.12,311514.16,0.00,0.00,1769.04,600789.60,0.00,0.00,0.00),('1','152','757','203713',3961891,'2124','316',260060.06,260801.03,0.00,0.00,740.97,266749.20,0.00,0.00,0.00),('1','152','757','203713',3961892,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203922',3965515,'2123','316',311514.16,311871.03,0.00,0.00,356.87,123373.20,0.00,0.00,0.00),('1','152','757','203922',3965516,'2124','316',260801.03,261174.16,0.00,0.00,373.13,134326.80,0.00,0.00,0.00),('1','152','757','203922',3965517,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203938',3965791,'2123','316',311871.03,312461.05,0.00,0.00,590.02,202423.20,0.00,0.00,0.00),('1','152','757','203938',3965792,'2124','316',261174.16,261676.58,0.00,0.00,502.42,180871.20,0.00,0.00,0.00),('1','152','757','203938',3965793,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','203951',3966027,'2123','316',312461.05,315350.75,0.00,0.00,2889.70,978104.40,0.00,0.00,0.00),('1','152','757','203951',3966028,'2124','316',261676.58,263242.81,0.00,0.00,1566.23,563842.80,0.00,0.00,0.00),('1','152','757','203951',3966029,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204174',3970249,'2123','316',315350.75,315523.28,0.00,0.00,172.53,59230.80,0.00,0.00,0.00),('1','152','757','204174',3970250,'2124','316',263242.81,263298.37,0.00,0.00,55.56,20001.60,0.00,0.00,0.00),('1','152','757','204174',3970251,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204223',3970662,'2123','316',315523.28,318200.74,0.00,0.00,2677.46,909555.12,0.00,0.00,0.00),('1','152','757','204223',3970663,'2124','316',263298.37,264747.09,0.00,0.00,1448.72,521539.20,0.00,0.00,0.00),('1','152','757','204223',3970664,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204381',3973884,'2123','316',318200.74,319277.20,0.00,0.00,1076.46,365049.60,0.00,0.00,0.00),('1','152','757','204381',3973885,'2124','316',264747.09,265406.84,0.00,0.00,659.75,237510.00,0.00,0.00,0.00),('1','152','757','204381',3973886,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204522',3976218,'2123','316',319277.20,320557.79,0.00,0.00,1280.59,435150.72,0.00,0.00,0.00),('1','152','757','204522',3976219,'2124','316',265406.84,266131.89,0.00,0.00,725.05,261018.00,0.00,0.00,0.00),('1','152','757','204522',3976220,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204600',3977860,'2123','316',320557.79,322799.82,0.00,0.00,2242.03,768833.04,0.00,0.00,0.00),('1','152','757','204600',3977861,'2124','316',266131.89,267254.61,0.00,0.00,1122.72,404179.20,0.00,0.00,0.00),('1','152','757','204600',3977862,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','204855',3981806,'2123','316',322799.82,324475.21,0.00,0.00,1675.39,574160.40,0.00,0.00,0.00),('1','152','757','204855',3981807,'2124','316',267254.61,268449.49,0.00,0.00,1194.88,430156.80,0.00,0.00,0.00),('1','152','757','204855',3981808,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205027',3985105,'2123','316',324475.21,326018.18,0.00,0.00,1542.97,532107.84,0.00,0.00,0.00),('1','152','757','205027',3985106,'2124','316',268449.49,269696.42,0.00,0.00,1246.93,448894.80,0.00,0.00,0.00),('1','152','757','205027',3985107,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205182',3987961,'2123','316',326018.18,326703.92,0.00,0.00,685.74,234726.96,0.00,0.00,0.00),('1','152','757','205182',3987962,'2124','316',269696.42,270213.37,0.00,0.00,516.95,186102.00,0.00,0.00,0.00),('1','152','757','205182',3987963,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205214',3988568,'2123','316',326703.92,327257.37,0.00,0.00,553.45,186822.00,0.00,0.00,0.00),('1','152','757','205214',3988569,'2124','316',270213.37,270487.64,0.00,0.00,274.27,98737.20,0.00,0.00,0.00),('1','152','757','205214',3988570,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205332',3990404,'2123','316',327257.37,329894.84,0.00,0.00,2637.47,893549.28,0.00,0.00,0.00),('1','152','757','205332',3990405,'2124','316',270487.64,271958.41,0.00,0.00,1470.77,529477.20,0.00,0.00,0.00),('1','152','757','205332',3990406,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205471',3993101,'2123','316',329894.84,330800.15,0.00,0.00,905.31,307095.60,0.00,0.00,0.00),('1','152','757','205471',3993102,'2124','316',271958.41,272795.69,0.00,0.00,837.28,301420.80,0.00,0.00,0.00),('1','152','757','205471',3993103,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205603',3995420,'2123','316',330800.15,332257.55,0.00,0.00,1457.40,498546.96,0.00,0.00,0.00),('1','152','757','205603',3995421,'2124','316',272795.69,273690.15,0.00,0.00,894.46,322005.60,0.00,0.00,0.00),('1','152','757','205603',3995422,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205711',3997606,'2123','316',332257.55,334674.42,0.00,0.00,2416.87,828889.92,0.00,0.00,0.00),('1','152','757','205711',3997607,'2124','316',273690.15,275175.90,0.00,0.00,1485.75,534870.00,0.00,0.00,0.00),('1','152','757','205711',3997608,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','205929',4001434,'2123','316',334674.42,337634.78,0.00,0.00,2960.36,1048194.26,0.00,0.00,0.00),('1','152','757','205929',4001435,'2124','316',275175.90,276666.11,0.00,0.00,1490.21,560318.96,0.00,0.00,0.00),('1','152','757','205929',4001436,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206129',4005000,'2123','316',337634.78,338615.08,0.00,0.00,980.30,344712.80,0.00,0.00,0.00),('1','152','757','206129',4005001,'2124','316',276666.11,277091.00,0.00,0.00,424.89,159758.64,0.00,0.00,0.00),('1','152','757','206129',4005002,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206255',4007010,'2123','316',338615.08,340485.41,0.00,0.00,1870.33,667574.08,0.00,0.00,0.00),('1','152','757','206255',4007011,'2124','316',277091.00,277978.40,0.00,0.00,887.40,333662.40,0.00,0.00,0.00),('1','152','757','206255',4007012,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206347',4008741,'2123','316',340485.41,342678.58,0.00,0.00,2193.17,768282.02,0.00,0.00,0.00),('1','152','757','206347',4008742,'2124','316',277978.40,279342.29,0.00,0.00,1363.89,512822.64,0.00,0.00,0.00),('1','152','757','206347',4008743,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206560',4012446,'2123','316',342678.58,343043.05,0.00,0.00,364.47,126810.72,0.00,0.00,0.00),('1','152','757','206560',4012447,'2124','316',279342.29,279562.23,0.00,0.00,219.94,82697.44,0.00,0.00,0.00),('1','152','757','206560',4012448,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206612',4013174,'2123','316',343043.05,346822.14,0.00,0.00,3779.09,1311597.74,0.00,0.00,0.00),('1','152','757','206612',4013175,'2124','316',279562.23,281324.22,0.00,0.00,1761.99,662508.24,0.00,0.00,0.00),('1','152','757','206612',4013176,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','206780',4016323,'2123','316',346822.14,349721.39,0.00,0.00,2899.25,1036506.20,0.00,0.00,0.00),('1','152','757','206780',4016324,'2124','316',281324.22,282808.52,0.00,0.00,1484.30,558096.80,0.00,0.00,0.00),('1','152','757','206780',4016325,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207011',4020541,'2123','316',349721.39,352153.83,0.00,0.00,2432.44,866897.44,0.00,0.00,0.00),('1','152','757','207011',4020542,'2124','316',282808.52,284125.70,0.00,0.00,1317.18,495259.68,0.00,0.00,0.00),('1','152','757','207011',4020543,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207233',4024572,'2123','316',352153.83,354969.99,0.00,0.00,2816.16,1006913.76,0.00,0.00,0.00),('1','152','757','207233',4024573,'2124','316',284125.70,285901.61,0.00,0.00,1775.91,667742.16,0.00,0.00,0.00),('1','152','757','207233',4024574,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207468',4028696,'2123','316',354969.99,356807.81,0.00,0.00,1837.82,644623.52,0.00,0.00,0.00),('1','152','757','207468',4028697,'2124','316',285901.61,286828.08,0.00,0.00,926.47,348352.72,0.00,0.00,0.00),('1','152','757','207468',4028698,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207612',4031103,'2123','316',356807.81,358596.05,0.00,0.00,1788.24,625833.24,0.00,0.00,0.00),('1','152','757','207612',4031104,'2124','316',286828.08,287889.74,0.00,0.00,1061.66,399184.16,0.00,0.00,0.00),('1','152','757','207612',4031105,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207690',4032462,'2123','316',358596.05,358908.82,0.00,0.00,312.77,114126.49,0.00,0.00,0.00),('1','152','757','207690',4032463,'2124','316',287889.74,288065.96,0.00,0.00,176.22,67668.48,0.00,0.00,0.00),('1','152','757','207690',4032464,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207769',4033662,'2123','316',358908.82,361867.85,0.00,0.00,2959.03,1060639.29,0.00,0.00,0.00),('1','152','757','207769',4033663,'2124','316',288065.96,289841.53,0.00,0.00,1775.57,681818.88,0.00,0.00,0.00),('1','152','757','207769',4033664,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','207891',4035921,'2123','316',361867.85,365563.55,0.00,0.00,3695.70,1341704.30,0.00,0.00,0.00),('1','152','757','207891',4035922,'2124','316',289841.53,292000.98,0.00,0.00,2159.45,829228.80,0.00,0.00,0.00),('1','152','757','207891',4035923,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208098',4039456,'2123','316',365563.55,369350.27,0.00,0.00,3786.72,1363994.58,0.00,0.00,0.00),('1','152','757','208098',4039457,'2124','316',292000.98,294066.90,0.00,0.00,2065.92,793313.28,0.00,0.00,0.00),('1','152','757','208098',4039458,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208312',4043351,'2123','316',369350.27,372524.33,0.00,0.00,3174.06,1153787.11,0.00,0.00,0.00),('1','152','757','208312',4043352,'2124','316',294066.90,296256.48,0.00,0.00,2189.58,840798.72,0.00,0.00,0.00),('1','152','757','208312',4043353,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208626',4048639,'2123','316',372524.33,374163.66,0.00,0.00,1639.33,589540.72,0.00,0.00,0.00),('1','152','757','208626',4048640,'2124','316',296256.48,296973.28,0.00,0.00,716.80,275251.20,0.00,0.00,0.00),('1','152','757','208626',4048641,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208684',4049724,'2123','316',374163.66,375870.55,0.00,0.00,1706.89,614972.78,0.00,0.00,0.00),('1','152','757','208684',4049725,'2124','316',296973.28,298173.56,0.00,0.00,1200.28,460907.52,0.00,0.00,0.00),('1','152','757','208684',4049726,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208745',4050948,'2123','316',375870.55,380164.59,0.00,0.00,4294.04,1541576.27,0.00,0.00,0.00),('1','152','757','208745',4050949,'2124','316',298173.56,300206.79,0.00,0.00,2033.23,780760.32,0.00,0.00,0.00),('1','152','757','208745',4050950,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','208975',4054948,'2123','316',380164.59,383345.91,0.00,0.00,3181.32,1229473.68,0.00,0.00,0.00),('1','152','757','208975',4054949,'2124','316',300206.79,301640.64,0.00,0.00,1433.85,573540.00,0.00,0.00,0.00),('1','152','757','208975',4054950,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','209203',4058877,'2123','316',383345.91,386689.26,0.00,0.00,3343.35,1271014.32,0.00,0.00,0.00),('1','152','757','209203',4058878,'2124','316',301640.64,303596.30,0.00,0.00,1955.66,782264.00,0.00,0.00,0.00),('1','152','757','209203',4058879,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','209424',4062768,'2123','316',386689.26,389092.58,0.00,0.00,2403.32,923606.24,0.00,0.00,0.00),('1','152','757','209424',4062769,'2124','316',303596.30,304758.03,0.00,0.00,1161.73,464692.00,0.00,0.00,0.00),('1','152','757','209424',4062770,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','209603',4066009,'2123','316',389092.58,389678.21,0.00,0.00,585.63,225048.00,0.00,0.00,0.00),('1','152','757','209603',4066010,'2124','316',304758.03,305127.17,0.00,0.00,369.14,147656.00,0.00,0.00,0.00),('1','152','757','209603',4066011,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','209630',4066498,'2123','316',389678.21,392565.19,0.00,0.00,2886.98,1154792.00,0.00,0.00,0.00),('1','152','757','209630',4066499,'2124','316',305127.17,307261.94,0.00,0.00,2134.77,853908.00,0.00,0.00,0.00),('1','152','757','209630',4066500,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','209849',4070320,'2123','316',392565.19,395249.74,0.00,0.00,2684.55,1052169.54,0.00,0.00,0.00),('1','152','757','209849',4070321,'2124','316',307261.94,309056.70,0.00,0.00,1794.76,704399.20,0.00,0.00,0.00),('1','152','757','209849',4070322,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210173',4075844,'2123','316',395249.74,397470.12,0.00,0.00,2220.38,880644.76,0.00,0.00,0.00),('1','152','757','210173',4075845,'2124','316',309056.70,311260.65,0.00,0.00,2203.95,906607.70,0.00,0.00,0.00),('1','152','757','210173',4075846,'2668','316',129718.83,129718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210297',4078244,'2123','316',397470.12,399430.73,0.00,0.00,1960.61,782541.60,0.00,0.00,0.00),('1','152','757','210297',4078245,'2124','316',311260.65,313530.41,0.00,0.00,2269.76,902340.44,0.00,0.00,0.00),('1','152','757','210297',4078246,'2668','316',129718.83,130380.16,0.00,0.00,661.33,277758.60,0.00,0.00,0.00),('1','152','757','210513',4082188,'2123','316',399430.73,401601.95,0.00,0.00,2171.22,845725.90,0.00,0.00,0.00),('1','152','757','210513',4082189,'2124','316',313530.41,314922.09,0.00,0.00,1391.68,584505.60,0.00,0.00,0.00),('1','152','757','210513',4082190,'2668','316',130380.16,130381.35,0.00,0.00,1.19,499.80,0.00,0.00,0.00),('1','152','757','210513',4082191,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210696',4085459,'2123','316',401601.95,402147.62,0.00,0.00,545.67,214907.46,0.00,0.00,0.00),('1','152','757','210696',4085460,'2124','316',314922.09,315291.36,0.00,0.00,369.27,155093.40,0.00,0.00,0.00),('1','152','757','210696',4085461,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210696',4085462,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210715',4085807,'2123','316',402147.62,405011.99,0.00,0.00,2864.37,1129460.94,0.00,0.00,0.00),('1','152','757','210715',4085808,'2124','316',315291.36,317060.96,0.00,0.00,1769.60,743232.00,0.00,0.00,0.00),('1','152','757','210715',4085809,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210715',4085810,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210937',4089546,'2123','316',405011.99,409166.01,0.00,0.00,4154.02,1630205.42,0.00,0.00,0.00),('1','152','757','210937',4089547,'2124','316',317060.96,319347.42,0.00,0.00,2286.46,954613.20,0.00,0.00,0.00),('1','152','757','210937',4089548,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','210937',4089549,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211160',4093477,'2123','316',409166.01,412559.73,0.00,0.00,3393.72,1369554.49,0.00,0.00,0.00),('1','152','757','211160',4093478,'2124','316',319347.42,321488.61,0.00,0.00,2141.19,907864.56,0.00,0.00,0.00),('1','152','757','211160',4093479,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211160',4093480,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211356',4097082,'2123','316',412559.73,414212.39,0.00,0.00,1652.66,661950.78,0.00,0.00,0.00),('1','152','757','211356',4097083,'2124','316',321488.61,322448.44,0.00,0.00,959.83,406967.92,0.00,0.00,0.00),('1','152','757','211356',4097084,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211356',4097085,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211510',4099498,'2123','316',414212.39,415852.43,0.00,0.00,1640.04,677102.32,0.00,0.00,0.00),('1','152','757','211510',4099499,'2124','316',322448.44,323486.09,0.00,0.00,1037.65,439963.60,0.00,0.00,0.00),('1','152','757','211510',4099500,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211510',4099501,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211591',4101117,'2123','316',415852.43,419243.73,0.00,0.00,3391.30,1345180.80,0.00,0.00,0.00),('1','152','757','211591',4101118,'2124','316',323486.09,325368.31,0.00,0.00,1882.22,798061.28,0.00,0.00,0.00),('1','152','757','211591',4101119,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211591',4101120,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211768',4104010,'2123','316',419243.73,422387.01,0.00,0.00,3143.28,1259925.92,0.00,0.00,0.00),('1','152','757','211768',4104011,'2124','316',325368.31,327052.07,0.00,0.00,1683.76,713914.24,0.00,0.00,0.00),('1','152','757','211768',4104012,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211768',4104013,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211976',4107740,'2123','316',422387.01,426244.21,0.00,0.00,3857.20,1540331.06,0.00,0.00,0.00),('1','152','757','211976',4107741,'2124','316',327052.07,328931.58,0.00,0.00,1879.51,796912.24,0.00,0.00,0.00),('1','152','757','211976',4107742,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','211976',4107743,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212216',4112005,'2123','316',426244.21,430494.26,0.00,0.00,4250.05,1708292.91,0.00,0.00,0.00),('1','152','757','212216',4112006,'2124','316',328931.58,330732.73,0.00,0.00,1801.15,763687.60,0.00,0.00,0.00),('1','152','757','212216',4112007,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212216',4112008,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212465',4116382,'2123','316',430494.26,433774.91,0.00,0.00,3280.65,1327061.18,0.00,0.00,0.00),('1','152','757','212465',4116383,'2124','316',330732.73,332485.92,0.00,0.00,1753.19,743352.56,0.00,0.00,0.00),('1','152','757','212465',4116384,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212465',4116385,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212656',4119973,'2123','316',433774.91,434347.85,0.00,0.00,572.94,231068.56,0.00,0.00,0.00),('1','152','757','212656',4119974,'2124','316',332485.92,332712.10,0.00,0.00,226.18,95900.32,0.00,0.00,0.00),('1','152','757','212656',4119975,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212656',4119976,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212710',4120759,'2123','316',434347.85,436885.58,0.00,0.00,2537.73,1032306.40,0.00,0.00,0.00),('1','152','757','212710',4120760,'2124','316',332712.10,334264.69,0.00,0.00,1552.59,658298.16,0.00,0.00,0.00),('1','152','757','212710',4120761,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212710',4120762,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212856',4123479,'2123','316',436885.58,439480.72,0.00,0.00,2595.14,1060739.58,0.00,0.00,0.00),('1','152','757','212856',4123480,'2124','316',334264.69,335832.62,0.00,0.00,1567.93,664802.32,0.00,0.00,0.00),('1','152','757','212856',4123481,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','212856',4123482,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213116',4128004,'2123','316',439480.72,443734.18,0.00,0.00,4253.46,1717164.78,0.00,0.00,0.00),('1','152','757','213116',4128005,'2124','316',335832.62,338076.74,0.00,0.00,2244.12,951506.88,0.00,0.00,0.00),('1','152','757','213116',4128006,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213116',4128007,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213374',4132238,'2123','316',443734.18,447833.65,0.00,0.00,4099.47,1659080.22,0.00,0.00,0.00),('1','152','757','213374',4132239,'2124','316',338076.74,340341.97,0.00,0.00,2265.23,960457.52,0.00,0.00,0.00),('1','152','757','213374',4132240,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213374',4132241,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213618',4136305,'2123','316',447833.65,449204.79,0.00,0.00,1371.14,558498.54,0.00,0.00,0.00),('1','152','757','213618',4136306,'2124','316',340341.97,341331.17,0.00,0.00,989.20,419420.80,0.00,0.00,0.00),('1','152','757','213618',4136307,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213618',4136308,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213754',4138409,'2123','316',449204.79,450991.08,0.00,0.00,1786.29,729149.52,0.00,0.00,0.00),('1','152','757','213754',4138410,'2124','316',341331.17,342325.45,0.00,0.00,994.28,421574.72,0.00,0.00,0.00),('1','152','757','213754',4138411,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213754',4138412,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213868',4140429,'2123','316',450991.08,454557.84,0.00,0.00,3566.76,1442818.58,0.00,0.00,0.00),('1','152','757','213868',4140430,'2124','316',342325.45,344478.36,0.00,0.00,2152.91,912833.84,0.00,0.00,0.00),('1','152','757','213868',4140431,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','213868',4140432,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214083',4144041,'2123','316',454557.84,457531.94,0.00,0.00,2974.10,1216248.40,0.00,0.00,0.00),('1','152','757','214083',4144042,'2124','316',344478.36,346987.92,0.00,0.00,2509.56,1064053.44,0.00,0.00,0.00),('1','152','757','214083',4144043,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214083',4144044,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214323',4148225,'2123','316',457531.94,460581.71,0.00,0.00,3049.77,1250772.06,0.00,0.00,0.00),('1','152','757','214323',4148226,'2124','316',346987.92,349604.58,0.00,0.00,2616.66,1109463.84,0.00,0.00,0.00),('1','152','757','214323',4148227,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214323',4148228,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214550',4151778,'2123','316',460581.71,462927.30,0.00,0.00,2345.59,954226.16,0.00,0.00,0.00),('1','152','757','214550',4151779,'2124','316',349604.58,351470.17,0.00,0.00,1865.59,791010.16,0.00,0.00,0.00),('1','152','757','214550',4151780,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214550',4151781,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214737',4155281,'2123','316',462927.30,463604.72,0.00,0.00,677.42,275608.54,0.00,0.00,0.00),('1','152','757','214737',4155282,'2124','316',351470.17,352155.64,0.00,0.00,685.47,290639.28,0.00,0.00,0.00),('1','152','757','214737',4155283,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214737',4155284,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214762',4155763,'2123','316',463604.72,467034.42,0.00,0.00,3429.70,1399608.60,0.00,0.00,0.00),('1','152','757','214762',4155764,'2124','316',352155.64,354659.11,0.00,0.00,2503.47,1061471.28,0.00,0.00,0.00),('1','152','757','214762',4155765,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','214762',4155766,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','215012',4159757,'2123','316',467034.42,471034.29,0.00,0.00,3999.87,1618276.30,0.00,0.00,0.00),('1','152','757','215012',4159758,'2124','316',354659.11,357075.18,0.00,0.00,2416.07,1024413.68,0.00,0.00,0.00),('1','152','757','215012',4159759,'2668','316',130381.35,130381.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','215012',4159760,'2828','316',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','215215',4163427,'2123','316',471034.29,472870.21,0.00,0.00,1835.92,756948.40,0.00,0.00,0.00),('1','152','757','215215',4163428,'2124','316',357075.18,358826.88,0.00,0.00,1751.70,742720.80,0.00,0.00,0.00),('1','152','757','215215',4163429,'2668','316',130381.35,131826.70,0.00,0.00,1445.35,583686.76,0.00,0.00,0.00),('1','152','757','215215',4163430,'2828','316',0.00,891.11,0.00,0.00,891.11,377830.64,0.00,0.00,0.00),('1','152','757','215432',4167036,'2123','316',472870.21,474543.37,0.00,0.00,1673.16,710091.12,0.00,0.00,0.00),('1','152','757','215432',4167037,'2124','316',358826.88,360129.40,0.00,0.00,1302.52,567710.36,0.00,0.00,0.00),('1','152','757','215432',4167038,'2668','316',131826.70,132029.32,0.00,0.00,202.62,89152.80,0.00,0.00,0.00),('1','152','757','215432',4167039,'2828','316',891.11,2155.11,0.00,0.00,1264.00,518240.00,0.00,0.00,0.00),('1','152','757','215664',4170987,'2123','316',474543.37,476219.86,0.00,0.00,1676.49,734944.50,0.00,0.00,0.00),('1','152','757','215664',4170988,'2124','316',360129.40,362085.13,0.00,0.00,1955.73,860521.20,0.00,0.00,0.00),('1','152','757','215664',4170989,'2668','316',132029.32,132315.57,0.00,0.00,286.25,118569.70,0.00,0.00,0.00),('1','152','757','215664',4170990,'2828','316',2155.11,4017.23,0.00,0.00,1862.12,763469.20,0.00,0.00,0.00),('1','152','757','215897',4174979,'2123','316',476219.86,478273.09,0.00,0.00,2053.23,885150.00,0.00,0.00,0.00),('1','152','757','215897',4174980,'2124','316',362085.13,363533.39,0.00,0.00,1448.26,637234.40,0.00,0.00,0.00),('1','152','757','215897',4174981,'2668','316',132315.57,132833.76,0.00,0.00,518.19,215024.40,0.00,0.00,0.00),('1','152','757','215897',4174982,'2828','316',4017.23,6141.05,0.00,0.00,2123.82,872266.20,0.00,0.00,0.00),('1','152','757','216091',4178367,'2123','316',478273.09,480166.40,0.00,0.00,1893.31,811681.40,0.00,0.00,0.00),('1','152','757','216091',4178368,'2124','316',363533.39,365244.90,0.00,0.00,1711.51,752903.30,0.00,0.00,0.00),('1','152','757','216091',4178369,'2668','316',132833.76,133212.63,0.00,0.00,378.87,166702.80,0.00,0.00,0.00),('1','152','757','216091',4178370,'2828','316',6141.05,7757.70,0.00,0.00,1616.65,662826.50,0.00,0.00,0.00),('1','152','757','216310',4182197,'2123','316',480166.40,482040.88,0.00,0.00,1874.48,821994.10,0.00,0.00,0.00),('1','152','757','216310',4182198,'2124','316',365244.90,366454.94,0.00,0.00,1210.04,528306.60,0.00,0.00,0.00),('1','152','757','216310',4182199,'2668','316',133212.63,133462.60,0.00,0.00,249.97,109986.80,0.00,0.00,0.00),('1','152','757','216310',4182200,'2828','316',7757.70,8671.95,0.00,0.00,914.25,379413.75,0.00,0.00,0.00),('1','152','757','216547',4186248,'2123','316',482040.88,482828.91,0.00,0.00,788.03,346187.70,0.00,0.00,0.00),('1','152','757','216547',4186249,'2124','316',366454.94,367020.40,0.00,0.00,565.46,248802.40,0.00,0.00,0.00),('1','152','757','216547',4186250,'2668','316',133462.60,133487.49,0.00,0.00,24.89,10951.60,0.00,0.00,0.00),('1','152','757','216547',4186251,'2828','316',8671.95,9686.67,0.00,0.00,1014.72,421108.80,0.00,0.00,0.00),('1','152','757','216690',4188569,'2123','316',482828.91,482828.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216690',4188570,'2124','316',367020.40,367020.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216690',4188571,'2668','316',133487.49,134089.20,0.00,0.00,601.71,249709.65,0.00,0.00,0.00),('1','152','757','216690',4188572,'2828','316',9686.67,9686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216754',4189979,'2123','316',482828.91,482828.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216754',4189980,'2124','316',367020.40,367020.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216754',4189981,'2668','316',134089.20,134089.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216754',4189982,'2828','316',9686.67,9686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','216783',4190456,'2123','316',482828.91,484664.56,0.00,0.00,1835.65,791259.00,0.00,0.00,0.00),('1','152','757','216783',4190457,'2124','316',367020.40,368759.66,0.00,0.00,1739.26,765274.40,0.00,0.00,0.00),('1','152','757','216783',4190458,'2668','316',134089.20,134946.05,0.00,0.00,856.85,377014.00,0.00,0.00,0.00),('1','152','757','216783',4190459,'2828','316',9686.67,10614.65,0.00,0.00,927.98,385111.70,0.00,0.00,0.00),('1','152','757','217005',4194371,'2123','316',484664.56,485517.96,0.00,0.00,853.40,375496.00,0.00,0.00,0.00),('1','152','757','217005',4194372,'2124','316',368759.66,369583.21,0.00,0.00,823.55,362362.00,0.00,0.00,0.00),('1','152','757','217005',4194373,'2668','316',134946.05,135598.05,0.00,0.00,652.00,286880.00,0.00,0.00,0.00),('1','152','757','217005',4194374,'2828','316',10614.65,11219.65,0.00,0.00,605.00,251075.00,0.00,0.00,0.00),('1','152','757','217006',4194375,'2123','316',485517.96,486699.55,0.00,0.00,1181.59,557710.48,0.00,0.00,0.00),('1','152','757','217006',4194376,'2124','316',369583.21,370414.13,0.00,0.00,830.92,392194.24,0.00,0.00,0.00),('1','152','757','217006',4194377,'2668','316',135598.05,136303.82,0.00,0.00,705.77,333123.44,0.00,0.00,0.00),('1','152','757','217006',4194378,'2828','316',11219.65,12290.91,0.00,0.00,1071.26,471354.40,0.00,0.00,0.00),('1','152','757','217262',4199255,'2123','316',486699.55,488426.86,0.00,0.00,1727.31,806553.36,0.00,0.00,0.00),('1','152','757','217262',4199256,'2124','316',370414.13,371579.18,0.00,0.00,1165.05,549903.60,0.00,0.00,0.00),('1','152','757','217262',4199257,'2668','316',136303.82,136800.55,0.00,0.00,496.73,234456.56,0.00,0.00,0.00),('1','152','757','217262',4199258,'2828','316',12290.91,13323.62,0.00,0.00,1032.71,455375.44,0.00,0.00,0.00),('1','152','757','217493',4203115,'2123','316',488426.86,489867.31,0.00,0.00,1440.45,668132.40,0.00,0.00,0.00),('1','152','757','217493',4203116,'2124','316',371579.18,372657.75,0.00,0.00,1078.57,509085.04,0.00,0.00,0.00),('1','152','757','217493',4203117,'2668','316',136800.55,137698.33,0.00,0.00,897.78,423752.16,0.00,0.00,0.00),('1','152','757','217493',4203118,'2828','316',13323.62,14894.06,0.00,0.00,1570.44,690993.60,0.00,0.00,0.00),('1','152','757','217702',4206684,'2123','316',489867.31,490962.33,0.00,0.00,1095.02,516849.44,0.00,0.00,0.00),('1','152','757','217702',4206685,'2124','316',372657.75,373735.21,0.00,0.00,1077.46,508561.12,0.00,0.00,0.00),('1','152','757','217702',4206686,'2668','316',137698.33,137825.54,0.00,0.00,127.21,60043.12,0.00,0.00,0.00),('1','152','757','217702',4206687,'2828','316',14894.06,15809.06,0.00,0.00,915.00,392850.00,0.00,0.00,0.00),('1','152','757','217999',4211890,'2123','316',490962.33,492266.66,0.00,0.00,1304.33,615643.76,0.00,0.00,0.00),('1','152','757','217999',4211891,'2124','316',373735.21,375143.38,0.00,0.00,1408.17,664656.24,0.00,0.00,0.00),('1','152','757','217999',4211892,'2668','316',137825.54,138535.74,0.00,0.00,710.20,335214.40,0.00,0.00,0.00),('1','152','757','217999',4211893,'2828','316',15809.06,16656.86,0.00,0.00,847.80,388232.00,0.00,0.00,0.00),('1','152','757','218206',4215672,'2123','316',492266.66,493090.42,0.00,0.00,823.76,388814.72,0.00,0.00,0.00),('1','152','757','218206',4215673,'2124','316',375143.38,376386.29,0.00,0.00,1242.91,585949.52,0.00,0.00,0.00),('1','152','757','218206',4215674,'2668','316',138535.74,138935.74,0.00,0.00,400.00,188800.00,0.00,0.00,0.00),('1','152','757','218206',4215675,'2828','316',16656.86,17496.86,0.00,0.00,840.00,369600.00,0.00,0.00,0.00),('1','152','757','218433',4219742,'2123','316',493090.42,494242.17,0.00,0.00,1151.75,543306.00,0.00,0.00,0.00),('1','152','757','218433',4219743,'2124','316',376386.29,377429.11,0.00,0.00,1042.82,492211.04,0.00,0.00,0.00),('1','152','757','218433',4219744,'2668','316',138935.74,139836.97,0.00,0.00,901.23,425380.56,0.00,0.00,0.00),('1','152','757','218433',4219745,'2828','316',17496.86,19411.13,0.00,0.00,1914.27,842278.80,0.00,0.00,0.00),('1','152','757','218673',4223983,'2123','316',494242.17,495346.92,0.00,0.00,1104.75,505788.56,0.00,0.00,0.00),('1','152','757','218673',4223984,'2124','316',377429.11,378473.00,0.00,0.00,1043.89,492716.08,0.00,0.00,0.00),('1','152','757','218673',4223985,'2668','316',139836.97,140982.52,0.00,0.00,1145.55,526785.04,0.00,0.00,0.00),('1','152','757','218673',4223986,'2828','316',19411.13,20999.86,0.00,0.00,1588.73,699041.20,0.00,0.00,0.00),('1','152','757','218893',4227913,'2123','316',495346.92,496818.39,0.00,0.00,1471.47,679651.92,0.00,0.00,0.00),('1','152','757','218893',4227914,'2124','316',378473.00,379278.87,0.00,0.00,805.87,380370.64,0.00,0.00,0.00),('1','152','757','218893',4227915,'2668','316',140982.52,141639.47,0.00,0.00,656.95,310080.40,0.00,0.00,0.00),('1','152','757','218893',4227916,'2828','316',20999.86,22707.89,0.00,0.00,1708.03,751533.20,0.00,0.00,0.00),('1','152','757','219113',4231522,'2123','316',496818.39,497657.55,0.00,0.00,839.16,380292.60,0.00,0.00,0.00),('1','152','757','219113',4231523,'2124','316',379278.87,379965.86,0.00,0.00,686.99,316015.40,0.00,0.00,0.00),('1','152','757','219113',4231524,'2668','316',141639.47,141784.05,0.00,0.00,144.58,66506.80,0.00,0.00,0.00),('1','152','757','219113',4231525,'2828','316',22707.89,23105.43,0.00,0.00,397.54,174917.60,0.00,0.00,0.00),('1','152','757','219285',4234595,'2123','316',497657.55,497657.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','219285',4234596,'2124','316',379965.86,379965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','219285',4234597,'2668','316',141784.05,141784.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','219285',4234598,'2828','316',23105.43,23105.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','219286',4234599,'2123','316',497657.55,498692.61,0.00,0.00,1035.06,469127.60,0.00,0.00,0.00),('1','152','757','219286',4234600,'2124','316',379965.86,380365.35,0.00,0.00,399.49,183765.40,0.00,0.00,0.00),('1','152','757','219286',4234601,'2668','316',141784.05,141977.69,0.00,0.00,193.64,89074.40,0.00,0.00,0.00),('1','152','757','219286',4234602,'2828','316',23105.43,24101.35,0.00,0.00,995.92,438204.80,0.00,0.00,0.00),('1','152','757','219340',4235372,'2123','316',498692.61,499384.81,0.00,0.00,692.20,313732.40,0.00,0.00,0.00),('1','152','757','219340',4235373,'2124','316',380365.35,381323.17,0.00,0.00,957.82,440597.20,0.00,0.00,0.00),('1','152','757','219340',4235374,'2668','316',141977.69,142571.50,0.00,0.00,593.81,273152.60,0.00,0.00,0.00),('1','152','757','219340',4235375,'2828','316',24101.35,26505.64,0.00,0.00,2404.29,1057887.60,0.00,0.00,0.00),('1','152','757','219576',4239622,'2123','316',499384.81,500404.16,0.00,0.00,1019.35,457701.00,0.00,0.00,0.00),('1','152','757','219576',4239623,'2124','316',381323.17,382550.39,0.00,0.00,1227.22,564521.20,0.00,0.00,0.00),('1','152','757','219576',4239624,'2668','316',142571.50,143579.45,0.00,0.00,1007.95,455657.00,0.00,0.00,0.00),('1','152','757','219576',4239625,'2828','316',26505.64,26813.23,0.00,0.00,307.59,135339.60,0.00,0.00,0.00),('1','152','757','219797',4243633,'2123','316',500404.16,502435.18,0.00,0.00,2031.02,902320.20,0.00,0.00,0.00),('1','152','757','219797',4243634,'2124','316',382550.39,383691.68,0.00,0.00,1141.29,524993.40,0.00,0.00,0.00),('1','152','757','219797',4243635,'2668','316',143579.45,144331.41,0.00,0.00,751.96,345901.60,0.00,0.00,0.00),('1','152','757','219797',4243636,'2828','316',26813.23,26933.14,0.00,0.00,119.91,52760.40,0.00,0.00,0.00),('1','152','757','220036',4247851,'2123','316',502435.18,504768.77,0.00,0.00,2333.59,1050632.20,0.00,0.00,0.00),('1','152','757','220036',4247852,'2124','316',383691.68,385443.70,0.00,0.00,1752.02,805929.20,0.00,0.00,0.00),('1','152','757','220036',4247853,'2668','316',144331.41,144624.17,0.00,0.00,292.76,134069.60,0.00,0.00,0.00),('1','152','757','220036',4247854,'2828','316',26933.14,26933.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','220228',4251276,'2123','316',504768.77,506913.14,0.00,0.00,2144.37,951500.80,0.00,0.00,0.00),('1','152','757','220228',4251277,'2124','316',385443.70,386967.69,0.00,0.00,1523.99,693035.40,0.00,0.00,0.00),('1','152','757','220228',4251278,'2668','316',144624.17,145088.18,0.00,0.00,464.01,213344.60,0.00,0.00,0.00),('1','152','757','220228',4251279,'2828','316',26933.14,27399.15,0.00,0.00,466.01,213329.20,0.00,0.00,0.00),('1','152','757','220456',4255482,'2123','316',506913.14,507030.56,0.00,0.00,117.42,54013.20,0.00,0.00,0.00),('1','152','757','220456',4255483,'2124','316',386967.69,387126.41,0.00,0.00,158.72,73011.20,0.00,0.00,0.00),('1','152','757','220456',4255484,'2668','316',145088.18,145194.46,0.00,0.00,106.28,48888.80,0.00,0.00,0.00),('1','152','757','220456',4255485,'2828','316',27399.15,27741.90,0.00,0.00,342.75,150810.00,0.00,0.00,0.00),('1','152','757','220611',4257925,'2123','316',507030.56,507030.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','220611',4257926,'2124','316',387126.41,387126.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','220611',4257927,'2668','316',145194.46,145194.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','220611',4257928,'2828','316',27741.90,27741.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','220612',4257929,'2123','316',507030.56,507942.90,0.00,0.00,912.34,419676.40,0.00,0.00,0.00),('1','152','757','220612',4257930,'2124','316',387126.41,387866.58,0.00,0.00,740.17,340478.20,0.00,0.00,0.00),('1','152','757','220612',4257931,'2668','316',145194.46,145752.89,0.00,0.00,558.43,256877.80,0.00,0.00,0.00),('1','152','757','220612',4257932,'2828','316',27741.90,28629.53,0.00,0.00,887.63,390557.20,0.00,0.00,0.00),('1','152','757','220676',4259195,'2123','316',507942.90,510809.87,0.00,0.00,2866.97,1272974.20,0.00,0.00,0.00),('1','152','757','220676',4259196,'2124','316',387866.58,389773.07,0.00,0.00,1906.49,876985.40,0.00,0.00,0.00),('1','152','757','220676',4259197,'2668','316',145752.89,146428.47,0.00,0.00,675.58,310766.80,0.00,0.00,0.00),('1','152','757','220676',4259198,'2828','316',28629.53,29637.93,0.00,0.00,1008.40,443696.00,0.00,0.00,0.00),('1','152','757','220898',4263155,'2123','316',510809.87,512090.39,0.00,0.00,1280.52,568901.76,0.00,0.00,0.00),('1','152','757','220898',4263156,'2124','316',389773.07,390847.16,0.00,0.00,1074.09,494081.40,0.00,0.00,0.00),('1','152','757','220898',4263157,'2668','316',146428.47,147490.00,0.00,0.00,1061.53,488303.80,0.00,0.00,0.00),('1','152','757','220898',4263158,'2828','316',29637.93,31276.55,0.00,0.00,1638.62,714488.32,0.00,0.00,0.00),('1','152','757','221128',4267278,'2123','316',512090.39,513437.43,0.00,0.00,1347.04,619638.40,0.00,0.00,0.00),('1','152','757','221128',4267279,'2124','316',390847.16,392145.71,0.00,0.00,1298.55,597333.00,0.00,0.00,0.00),('1','152','757','221128',4267280,'2668','316',147490.00,148191.13,0.00,0.00,701.13,310787.20,0.00,0.00,0.00),('1','152','757','221128',4267281,'2828','316',31276.55,32057.51,0.00,0.00,780.96,341960.40,0.00,0.00,0.00),('1','152','757','221383',4271762,'2123','316',513437.43,514960.16,0.00,0.00,1522.73,700455.80,0.00,0.00,0.00),('1','152','757','221383',4271763,'2124','316',392145.71,394057.63,0.00,0.00,1911.92,879483.20,0.00,0.00,0.00),('1','152','757','221383',4271764,'2668','316',148191.13,149205.18,0.00,0.00,1014.05,466463.00,0.00,0.00,0.00),('1','152','757','221383',4271765,'2828','316',32057.51,33548.51,0.00,0.00,1491.00,656040.00,0.00,0.00,0.00),('1','152','757','221606',4275998,'2123','316',514960.16,517555.87,0.00,0.00,2595.71,1166705.00,0.00,0.00,0.00),('1','152','757','221606',4275999,'2124','316',394057.63,395553.78,0.00,0.00,1496.15,688229.00,0.00,0.00,0.00),('1','152','757','221606',4276000,'2668','316',149205.18,150374.32,0.00,0.00,1169.14,537804.40,0.00,0.00,0.00),('1','152','757','221606',4276001,'2828','316',33548.51,34687.13,0.00,0.00,1138.62,496438.32,0.00,0.00,0.00),('1','152','757','221838',4279847,'2123','316',517555.87,519460.46,0.00,0.00,1904.59,859155.40,0.00,0.00,0.00),('1','152','757','221838',4279848,'2124','316',395553.78,397188.26,0.00,0.00,1634.48,751860.80,0.00,0.00,0.00),('1','152','757','221838',4279849,'2668','316',150374.32,151610.10,0.00,0.00,1235.78,562938.80,0.00,0.00,0.00),('1','152','757','221838',4279850,'2828','316',34687.13,35094.13,0.00,0.00,407.00,177452.00,0.00,0.00,0.00),('1','152','757','222063',4284044,'2123','316',519460.46,522689.11,0.00,0.00,3228.65,1421120.60,0.00,0.00,0.00),('1','152','757','222063',4284045,'2124','316',397188.26,398891.24,0.00,0.00,1702.98,783370.80,0.00,0.00,0.00),('1','152','757','222063',4284046,'2668','316',151610.10,152851.35,0.00,0.00,1241.25,570975.00,0.00,0.00,0.00),('1','152','757','222063',4284047,'2828','316',35094.13,35094.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','222299',4287806,'2123','316',522689.11,524519.99,0.00,0.00,1830.88,810000.40,0.00,0.00,0.00),('1','152','757','222299',4287807,'2124','316',398891.24,400559.09,0.00,0.00,1667.85,756222.04,0.00,0.00,0.00),('1','152','757','222299',4287808,'2668','316',152851.35,153996.74,0.00,0.00,1145.39,504850.04,0.00,0.00,0.00),('1','152','757','222299',4287809,'2828','316',35094.13,36462.71,0.00,0.00,1368.58,624188.00,0.00,0.00,0.00),('1','152','757','222488',4291287,'2123','316',524519.99,524519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','222488',4291288,'2124','316',400559.09,400559.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','222488',4291289,'2668','316',153996.74,153996.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','222488',4291290,'2828','316',36462.71,36462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','222512',4291559,'2123','316',524519.99,526163.92,0.00,0.00,1643.93,751575.80,0.00,0.00,0.00),('1','152','757','222512',4291560,'2124','316',400559.09,402009.96,0.00,0.00,1450.87,667400.20,0.00,0.00,0.00),('1','152','757','222512',4291561,'2668','316',153996.74,155041.99,0.00,0.00,1045.25,480815.00,0.00,0.00,0.00),('1','152','757','222512',4291562,'2828','316',36462.71,37517.21,0.00,0.00,1054.50,459762.00,0.00,0.00,0.00),('1','152','757','222717',4295664,'2123','316',526163.92,527603.72,0.00,0.00,1439.80,662308.00,0.00,0.00,0.00),('1','152','757','222717',4295665,'2124','316',402009.96,402051.37,0.00,0.00,41.41,19048.60,0.00,0.00,0.00),('1','152','757','222717',4295666,'2668','316',155041.99,155091.99,0.00,0.00,50.00,23000.00,0.00,0.00,0.00),('1','152','757','222717',4295667,'2828','316',37517.21,39933.50,0.00,0.00,2416.29,1053502.44,0.00,0.00,0.00),('1','152','757','222936',4299651,'2123','316',527603.72,527918.82,0.00,0.00,315.10,141346.00,0.00,0.00,0.00),('1','152','757','222936',4299652,'2124','316',402051.37,402558.41,0.00,0.00,507.04,232038.40,0.00,0.00,0.00),('1','152','757','222936',4299653,'2668','316',155091.99,155659.06,0.00,0.00,577.29,265553.40,0.00,0.00,0.00),('1','152','757','222936',4299654,'2828','316',39933.50,41664.45,0.00,0.00,1730.95,754694.20,0.00,0.00,0.00),('1','152','757','223079',4302251,'2123','316',527918.82,529068.43,0.00,0.00,1149.61,528820.60,0.00,0.00,0.00),('1','152','757','223079',4302252,'2124','316',402558.41,403638.90,0.00,0.00,1080.49,497025.40,0.00,0.00,0.00),('1','152','757','223079',4302253,'2668','316',155659.06,156556.64,0.00,0.00,897.58,412886.80,0.00,0.00,0.00),('1','152','757','223079',4302254,'2828','316',41664.45,42878.62,0.00,0.00,1214.17,529378.12,0.00,0.00,0.00),('1','152','757','223164',4303664,'2123','316',529068.43,529729.66,0.00,0.00,661.23,307295.20,0.00,0.00,0.00),('1','152','757','223164',4303665,'2124','316',403638.90,405488.40,0.00,0.00,1849.50,846698.00,0.00,0.00,0.00),('1','152','757','223164',4303666,'2668','316',156556.64,157090.87,0.00,0.00,534.23,246245.20,0.00,0.00,0.00),('1','152','757','223164',4303667,'2828','316',42878.62,43751.27,0.00,0.00,872.65,380475.40,0.00,0.00,0.00),('1','152','757','223379',4307163,'2123','316',529729.66,530078.85,0.00,0.00,349.19,167611.20,0.00,0.00,0.00),('1','152','757','223379',4307164,'2124','316',405488.40,406430.85,0.00,0.00,942.45,452376.00,0.00,0.00,0.00),('1','152','757','223379',4307165,'2668','316',157090.87,158221.35,0.00,0.00,1130.48,542630.40,0.00,0.00,0.00),('1','152','757','223379',4307166,'2828','316',43751.27,44581.95,0.00,0.00,830.68,383774.16,0.00,0.00,0.00),('1','152','757','223406',4307808,'2123','316',530078.85,530185.89,0.00,0.00,107.04,51379.20,0.00,0.00,0.00),('1','152','757','223406',4307809,'2124','316',406430.85,406849.86,0.00,0.00,419.01,201124.80,0.00,0.00,0.00),('1','152','757','223406',4307810,'2668','316',158221.35,158272.29,0.00,0.00,50.94,24451.20,0.00,0.00,0.00),('1','152','757','223406',4307811,'2828','316',44581.95,44927.42,0.00,0.00,345.47,159607.14,0.00,0.00,0.00),('1','152','757','223613',4311719,'2123','316',530185.89,530518.06,0.00,0.00,332.17,159441.60,0.00,0.00,0.00),('1','152','757','223613',4311720,'2124','316',406849.86,407267.55,0.00,0.00,417.69,200491.20,0.00,0.00,0.00),('1','152','757','223613',4311721,'2668','316',158272.29,158708.96,0.00,0.00,436.67,209601.60,0.00,0.00,0.00),('1','152','757','223613',4311722,'2828','316',44927.42,45526.22,0.00,0.00,598.80,276645.60,0.00,0.00,0.00),('1','152','757','223626',4311915,'2123','316',530518.06,532191.95,0.00,0.00,1673.89,803467.20,0.00,0.00,0.00),('1','152','757','223626',4311916,'2124','316',407267.55,408620.04,0.00,0.00,1352.49,649195.20,0.00,0.00,0.00),('1','152','757','223626',4311917,'2668','316',158708.96,158883.55,0.00,0.00,174.59,83803.20,0.00,0.00,0.00),('1','152','757','223626',4311918,'2828','316',45526.22,47392.75,0.00,0.00,1866.53,813807.08,0.00,0.00,0.00),('1','152','757','223872',4316395,'2123','316',532191.95,533766.04,0.00,0.00,1574.09,755563.20,0.00,0.00,0.00),('1','152','757','223872',4316396,'2124','316',408620.04,410312.13,0.00,0.00,1692.09,812203.20,0.00,0.00,0.00),('1','152','757','223872',4316397,'2668','316',158883.55,159408.60,0.00,0.00,525.05,252024.00,0.00,0.00,0.00),('1','152','757','223872',4316398,'2828','316',47392.75,49446.59,0.00,0.00,2053.84,948874.08,0.00,0.00,0.00),('1','152','757','224097',4320138,'2123','316',533766.04,535096.45,0.00,0.00,1330.41,638596.80,0.00,0.00,0.00),('1','152','757','224097',4320139,'2124','316',410312.13,411740.71,0.00,0.00,1428.58,685718.40,0.00,0.00,0.00),('1','152','757','224097',4320140,'2668','316',159408.60,159601.64,0.00,0.00,193.04,92659.20,0.00,0.00,0.00),('1','152','757','224097',4320141,'2828','316',49446.59,50768.47,0.00,0.00,1321.88,610708.56,0.00,0.00,0.00),('1','152','757','224314',4324163,'2123','316',535096.45,536130.44,0.00,0.00,1033.99,558354.60,0.00,0.00,0.00),('1','152','757','224314',4324164,'2124','316',411740.71,412689.15,0.00,0.00,948.44,512157.60,0.00,0.00,0.00),('1','152','757','224314',4324165,'2668','316',159601.64,160245.43,0.00,0.00,643.79,347646.60,0.00,0.00,0.00),('1','152','757','224314',4324166,'2828','316',50768.47,51891.03,0.00,0.00,1122.56,561280.00,0.00,0.00,0.00),('1','152','757','224523',4327888,'2123','316',536130.44,537358.64,0.00,0.00,1228.20,663228.00,0.00,0.00,0.00),('1','152','757','224523',4327889,'2124','316',412689.15,413879.35,0.00,0.00,1190.20,642708.00,0.00,0.00,0.00),('1','152','757','224523',4327890,'2668','316',160245.43,160651.89,0.00,0.00,406.46,211488.40,0.00,0.00,0.00),('1','152','757','224523',4327891,'2828','316',51891.03,52712.13,0.00,0.00,821.10,410550.00,0.00,0.00,0.00),('1','152','757','224789',4332307,'2123','316',537358.64,537482.64,0.00,0.00,124.00,66960.00,0.00,0.00,0.00),('1','152','757','224789',4332308,'2124','316',413879.35,414006.65,0.00,0.00,127.30,68742.00,0.00,0.00,0.00),('1','152','757','224789',4332309,'2668','316',160651.89,160701.89,0.00,0.00,50.00,27000.00,0.00,0.00,0.00),('1','152','757','224789',4332310,'2828','316',52712.13,53035.20,0.00,0.00,323.07,161535.00,0.00,0.00,0.00),('1','152','757','224842',4333218,'2123','316',537482.64,537482.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224842',4333219,'2124','316',414006.65,414006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224842',4333220,'2668','316',160701.89,160701.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224842',4333221,'2828','316',53035.20,53035.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224856',4333467,'2123','316',537482.64,537482.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224856',4333468,'2124','316',414006.65,414006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224856',4333469,'2668','316',160701.89,160701.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224856',4333470,'2828','316',53035.20,53035.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','224874',4333820,'2123','316',537482.64,538279.07,0.00,0.00,796.43,430072.20,0.00,0.00,0.00),('1','152','757','224874',4333821,'2124','316',414006.65,414912.26,0.00,0.00,905.61,489029.40,0.00,0.00,0.00),('1','152','757','224874',4333822,'2668','316',29768.32,30371.37,0.00,0.00,603.05,325647.00,0.00,0.00,0.00),('1','152','757','224874',4333823,'2828','316',85952896.44,85953683.21,0.00,0.00,786.77,393385.00,0.00,0.00,0.00),('1','152','757','225013',4336509,'2123','316',538279.07,539193.44,0.00,0.00,914.37,493759.80,0.00,0.00,0.00),('1','152','757','225013',4336510,'2124','316',414912.26,416104.42,0.00,0.00,1192.16,643766.40,0.00,0.00,0.00),('1','152','757','225013',4336511,'2668','316',30371.37,31315.48,0.00,0.00,944.11,509819.40,0.00,0.00,0.00),('1','152','757','225013',4336512,'2828','316',85953683.21,85954571.81,0.00,0.00,888.60,434956.80,0.00,0.00,0.00),('1','152','757','225256',4340973,'2123','316',539193.44,540380.83,0.00,0.00,1187.39,641190.60,0.00,0.00,0.00),('1','152','757','225256',4340974,'2124','316',416104.42,417295.13,0.00,0.00,1190.71,642983.40,0.00,0.00,0.00),('1','152','757','225256',4340975,'2668','316',31315.48,32043.70,0.00,0.00,728.22,393238.80,0.00,0.00,0.00),('1','152','757','225256',4340976,'2828','316',85954571.81,85956493.29,0.00,0.00,1921.48,937682.24,0.00,0.00,0.00),('1','152','757','225488',4345135,'2123','316',540380.83,541299.88,0.00,0.00,919.05,496287.00,0.00,0.00,0.00),('1','152','757','225488',4345136,'2124','316',417295.13,418592.65,0.00,0.00,1297.52,700660.80,0.00,0.00,0.00),('1','152','757','225488',4345137,'2668','316',32043.70,33435.23,0.00,0.00,1391.53,751426.20,0.00,0.00,0.00),('1','152','757','225488',4345138,'2828','316',85956493.29,85957184.35,0.00,0.00,691.06,337237.28,0.00,0.00,0.00),('1','152','757','225709',4348805,'2123','316',541299.88,542647.15,0.00,0.00,1347.27,727525.80,0.00,0.00,0.00),('1','152','757','225709',4348806,'2124','316',418592.65,419592.03,0.00,0.00,999.38,539665.20,0.00,0.00,0.00),('1','152','757','225709',4348807,'2668','316',33435.23,34686.68,0.00,0.00,1251.45,628463.00,0.00,0.00,0.00),('1','152','757','225709',4348808,'2828','316',85957184.35,85958651.25,0.00,0.00,1466.90,725975.20,0.00,0.00,0.00),('1','152','757','225967',4353336,'2123','316',542647.15,542890.25,0.00,0.00,243.10,131274.00,0.00,0.00,0.00),('1','152','757','225967',4353337,'2124','316',419592.03,420037.22,0.00,0.00,445.19,240402.60,0.00,0.00,0.00),('1','152','757','225967',4353338,'2668','316',34686.68,35103.47,0.00,0.00,416.79,225066.60,0.00,0.00,0.00),('1','152','757','225967',4353339,'2828','316',85958651.25,85960055.37,0.00,0.00,1404.12,702060.00,0.00,0.00,0.00),('1','152','757','226142',4356564,'2123','316',542890.25,542890.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','226142',4356565,'2124','316',420037.22,420037.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','226142',4356566,'2668','316',35103.47,35103.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','226142',4356567,'2828','316',85960055.37,85960055.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','226149',4356711,'2123','316',542890.25,543231.35,0.00,0.00,341.10,184194.00,0.00,0.00,0.00),('1','152','757','226149',4356712,'2124','316',420037.22,420528.56,0.00,0.00,491.34,265323.60,0.00,0.00,0.00),('1','152','757','226149',4356713,'2668','316',35103.47,35629.16,0.00,0.00,525.69,283872.60,0.00,0.00,0.00),('1','152','757','226149',4356714,'2828','316',85960055.37,85960421.97,0.00,0.00,366.60,183300.00,0.00,0.00,0.00),('1','152','757','226458',4362380,'2123','316',543231.35,543364.11,0.00,0.00,132.76,71690.40,0.00,0.00,0.00),('1','152','757','226458',4362381,'2124','316',420528.56,422292.73,0.00,0.00,1764.17,952651.80,0.00,0.00,0.00),('1','152','757','226458',4362382,'2668','316',35629.16,36976.51,0.00,0.00,1347.35,715569.00,0.00,0.00,0.00),('1','152','757','226458',4362383,'2828','316',85960421.97,85960803.01,0.00,0.00,381.04,190520.00,0.00,0.00,0.00),('1','152','757','226462',4362472,'2123','316',543364.11,544702.48,0.00,0.00,1338.37,722719.80,0.00,0.00,0.00),('1','152','757','226462',4362473,'2124','316',422292.73,423766.58,0.00,0.00,1473.85,795879.00,0.00,0.00,0.00),('1','152','757','226462',4362474,'2668','316',36976.51,37079.99,0.00,0.00,103.48,55879.20,0.00,0.00,0.00),('1','152','757','226462',4362475,'2828','316',85960803.01,85962095.50,0.00,0.00,1292.49,646245.00,0.00,0.00,0.00),('1','152','757','226719',4367142,'2123','316',544702.48,545923.12,0.00,0.00,1220.64,659145.60,0.00,0.00,0.00),('1','152','757','226719',4367143,'2124','316',423766.58,424691.46,0.00,0.00,924.88,499435.20,0.00,0.00,0.00),('1','152','757','226719',4367144,'2668','316',37079.99,38034.80,0.00,0.00,954.81,515597.40,0.00,0.00,0.00),('1','152','757','226719',4367145,'2828','316',85962095.50,85962713.23,0.00,0.00,617.73,308865.00,0.00,0.00,0.00),('1','152','757','226945',4371184,'2123','316',545923.12,546924.59,0.00,0.00,1001.47,540793.80,0.00,0.00,0.00),('1','152','757','226945',4371185,'2124','316',424691.46,425946.12,0.00,0.00,1254.66,677516.40,0.00,0.00,0.00),('1','152','757','226945',4371186,'2668','316',38034.80,38691.45,0.00,0.00,656.65,354591.00,0.00,0.00,0.00),('1','152','757','226945',4371187,'2828','316',85962713.23,85966291.89,0.00,0.00,3578.66,1789330.00,0.00,0.00,0.00),('1','152','757','227268',4376502,'2123','316',546924.59,548768.32,0.00,0.00,1843.73,995614.20,0.00,0.00,0.00),('1','152','757','227268',4376503,'2124','316',425946.12,427183.04,0.00,0.00,1236.92,666788.80,0.00,0.00,0.00),('1','152','757','227268',4376504,'2668','316',38691.45,38937.39,0.00,0.00,245.94,124118.00,0.00,0.00,0.00),('1','152','757','227268',4376505,'2828','316',85966291.89,85967852.92,0.00,0.00,1561.03,780515.00,0.00,0.00,0.00),('1','152','757','227363',4378481,'2123','316',548768.32,550005.28,0.00,0.00,1236.96,667958.40,0.00,0.00,0.00),('1','152','757','227363',4378482,'2124','316',427183.04,428232.75,0.00,0.00,1049.71,566843.40,0.00,0.00,0.00),('1','152','757','227363',4378483,'2668','316',38937.39,40349.21,0.00,0.00,1411.82,750382.80,0.00,0.00,0.00),('1','152','757','227363',4378484,'2828','316',85967852.92,85969052.51,0.00,0.00,1199.59,599795.00,0.00,0.00,0.00),('1','152','757','227596',4382474,'2123','316',550005.28,551428.83,0.00,0.00,1423.55,768717.00,0.00,0.00,0.00),('1','152','757','227596',4382475,'2124','316',428232.75,429510.29,0.00,0.00,1277.54,689871.60,0.00,0.00,0.00),('1','152','757','227596',4382476,'2668','316',40349.21,40930.53,0.00,0.00,581.32,313912.80,0.00,0.00,0.00),('1','152','757','227596',4382477,'2828','316',85969052.51,85970349.14,0.00,0.00,1296.63,658755.00,0.00,0.00,0.00),('1','152','757','227843',4386861,'2123','316',551428.83,552810.76,0.00,0.00,1381.93,746242.20,0.00,0.00,0.00),('1','152','757','227843',4386862,'2124','316',429510.29,430610.10,0.00,0.00,1099.81,593897.40,0.00,0.00,0.00),('1','152','757','227843',4386863,'2668','316',40930.53,41935.51,0.00,0.00,1004.98,542689.20,0.00,0.00,0.00),('1','152','757','227843',4386864,'2828','316',85970349.14,85972169.17,0.00,0.00,1820.03,942775.54,0.00,0.00,0.00),('1','152','757','228111',4391954,'2123','316',552810.76,554572.30,0.00,0.00,1761.54,951231.60,0.00,0.00,0.00),('1','152','757','228111',4391955,'2124','316',430610.10,432086.19,0.00,0.00,1476.09,797088.60,0.00,0.00,0.00),('1','152','757','228111',4391956,'2668','316',41935.51,42468.41,0.00,0.00,532.90,287766.00,0.00,0.00,0.00),('1','152','757','228111',4391957,'2828','316',85972169.17,85974173.86,0.00,0.00,2004.69,1038429.42,0.00,0.00,0.00),('1','152','757','228340',4396410,'2123','316',554572.30,555605.02,0.00,0.00,1032.72,557668.80,0.00,0.00,0.00),('1','152','757','228340',4396411,'2124','316',432086.19,433062.00,0.00,0.00,975.81,526937.40,0.00,0.00,0.00),('1','152','757','228340',4396412,'2668','316',42468.41,42901.34,0.00,0.00,432.93,233782.20,0.00,0.00,0.00),('1','152','757','228340',4396413,'2828','316',85974173.86,85975800.94,0.00,0.00,1627.08,842827.44,0.00,0.00,0.00),('1','152','757','228525',4399805,'2123','316',555605.02,557716.30,0.00,0.00,2111.28,1140091.20,0.00,0.00,0.00),('1','152','757','228525',4399806,'2124','316',433062.00,435126.63,0.00,0.00,2064.63,1114900.20,0.00,0.00,0.00),('1','152','757','228525',4399807,'2668','316',42901.34,44253.13,0.00,0.00,1351.79,729966.60,0.00,0.00,0.00),('1','152','757','228525',4399808,'2828','316',85975800.94,85978082.17,0.00,0.00,2281.23,1181677.14,0.00,0.00,0.00),('1','152','757','228743',4403973,'2123','316',557716.30,559087.23,0.00,0.00,1370.93,740302.20,0.00,0.00,0.00),('1','152','757','228743',4403974,'2124','316',435126.63,436105.40,0.00,0.00,978.77,528535.80,0.00,0.00,0.00),('1','152','757','228743',4403975,'2668','316',44253.13,45718.79,0.00,0.00,1465.66,791456.40,0.00,0.00,0.00),('1','152','757','228743',4403976,'2828','316',85978082.17,85979491.38,0.00,0.00,1409.21,729970.78,0.00,0.00,0.00),('1','152','757','228924',4407293,'2123','316',559087.23,560601.73,0.00,0.00,1514.50,817830.00,0.00,0.00,0.00),('1','152','757','228924',4407294,'2124','316',436105.40,437484.89,0.00,0.00,1379.49,744924.60,0.00,0.00,0.00),('1','152','757','228924',4407295,'2668','316',45718.79,46298.22,0.00,0.00,579.43,312892.20,0.00,0.00,0.00),('1','152','757','228924',4407296,'2828','316',85979491.38,85981801.88,0.00,0.00,2310.50,1196839.00,0.00,0.00,0.00),('1','152','757','229157',4411886,'2123','316',560601.73,561917.53,0.00,0.00,1315.80,710532.00,0.00,0.00,0.00),('1','152','757','229157',4411887,'2124','316',437484.89,438743.32,0.00,0.00,1258.43,679552.20,0.00,0.00,0.00),('1','152','757','229157',4411888,'2668','316',46298.22,47451.16,0.00,0.00,1152.94,622587.60,0.00,0.00,0.00),('1','152','757','229157',4411889,'2828','316',85981801.88,85983683.61,0.00,0.00,1881.73,974736.14,0.00,0.00,0.00),('1','152','757','229393',4416097,'2123','316',561917.53,561917.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','229393',4416098,'2124','316',438743.32,438743.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','229393',4416099,'2668','316',47451.16,47451.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','229393',4416100,'2828','316',85983683.61,85983683.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','229400',4416230,'2123','316',561917.53,562930.96,0.00,0.00,1013.43,547252.20,0.00,0.00,0.00),('1','152','757','229400',4416231,'2124','316',438743.32,439876.29,0.00,0.00,1132.97,611803.80,0.00,0.00,0.00),('1','152','757','229400',4416232,'2668','316',47451.16,48436.90,0.00,0.00,985.74,532299.60,0.00,0.00,0.00),('1','152','757','229400',4416233,'2828','316',85983683.61,85984552.65,0.00,0.00,869.04,464286.72,0.00,0.00,0.00),('1','152','757','229405',4416258,'2123','316',562930.96,563657.89,0.00,0.00,726.93,424527.12,0.00,0.00,0.00),('1','152','757','229405',4416259,'2124','316',439876.29,440524.54,0.00,0.00,648.25,378453.48,0.00,0.00,0.00),('1','152','757','229405',4416260,'2668','316',48436.90,48522.53,0.00,0.00,85.63,50007.92,0.00,0.00,0.00),('1','152','757','229405',4416261,'2828','316',85984552.65,85986440.23,0.00,0.00,1887.58,999964.98,0.00,0.00,0.00),('1','152','757','229651',4421090,'2123','316',563657.89,565222.88,0.00,0.00,1564.99,913954.16,0.00,0.00,0.00),('1','152','757','229651',4421091,'2124','316',440524.54,441905.03,0.00,0.00,1380.49,804669.16,0.00,0.00,0.00),('1','152','757','229651',4421092,'2668','316',48522.53,48968.79,0.00,0.00,446.26,260615.84,0.00,0.00,0.00),('1','152','757','229651',4421093,'2828','316',85986440.23,85987689.67,0.00,0.00,1249.44,663452.64,0.00,0.00,0.00),('1','152','757','229877',4425555,'2123','316',565222.88,566948.41,0.00,0.00,1725.53,1007709.52,0.00,0.00,0.00),('1','152','757','229877',4425556,'2124','316',441905.03,443641.83,0.00,0.00,1736.80,1014291.20,0.00,0.00,0.00),('1','152','757','229877',4425557,'2668','316',48968.79,49117.34,0.00,0.00,148.55,86753.20,0.00,0.00,0.00),('1','152','757','229877',4425558,'2828','316',85987689.67,85989688.38,0.00,0.00,1998.71,1061315.01,0.00,0.00,0.00),('1','152','757','230105',4429503,'2123','316',566948.41,568514.64,0.00,0.00,1566.23,914678.32,0.00,0.00,0.00),('1','152','757','230105',4429504,'2124','316',443641.83,444642.50,0.00,0.00,1000.67,579395.50,0.00,0.00,0.00),('1','152','757','230105',4429505,'2668','316',49117.34,49618.47,0.00,0.00,501.13,271095.81,0.00,0.00,0.00),('1','152','757','230105',4429506,'2828','316',85989688.38,85990987.78,0.00,0.00,1299.40,689981.40,0.00,0.00,0.00),('1','152','757','230312',4433417,'2123','316',568514.64,569326.08,0.00,0.00,811.44,473880.96,0.00,0.00,0.00),('1','152','757','230312',4433418,'2124','316',444642.50,445349.56,0.00,0.00,707.06,412923.04,0.00,0.00,0.00),('1','152','757','230312',4433419,'2668','316',49618.47,49794.06,0.00,0.00,175.59,102544.56,0.00,0.00,0.00),('1','152','757','230312',4433420,'2828','316',85990987.78,85991637.21,0.00,0.00,649.43,345747.33,0.00,0.00,0.00),('1','152','757','230426',4435859,'2123','316',569326.08,570017.15,0.00,0.00,691.07,403584.88,0.00,0.00,0.00),('1','152','757','230426',4435860,'2124','316',445349.56,446129.39,0.00,0.00,779.83,455420.72,0.00,0.00,0.00),('1','152','757','230426',4435861,'2668','316',49794.06,50459.36,0.00,0.00,665.30,388535.20,0.00,0.00,0.00),('1','152','757','230426',4435862,'2828','316',85991637.21,85992199.30,0.00,0.00,562.09,303528.60,0.00,0.00,0.00),('1','152','757','230531',4437625,'2123','316',570017.15,571324.30,0.00,0.00,1307.15,761832.96,0.00,0.00,0.00),('1','152','757','230531',4437626,'2124','316',446129.39,447406.37,0.00,0.00,1276.98,744128.32,0.00,0.00,0.00),('1','152','757','230531',4437627,'2668','316',50459.36,51133.96,0.00,0.00,674.60,393966.40,0.00,0.00,0.00),('1','152','757','230531',4437628,'2828','316',85992199.30,85994347.78,0.00,0.00,2148.48,1159135.20,0.00,0.00,0.00),('1','152','757','230799',4442247,'2123','316',571324.30,572815.93,0.00,0.00,1491.63,871111.92,0.00,0.00,0.00),('1','152','757','230799',4442248,'2124','316',447406.37,448490.99,0.00,0.00,1084.62,633418.08,0.00,0.00,0.00),('1','152','757','230799',4442249,'2668','316',51133.96,51204.68,0.00,0.00,70.72,41300.48,0.00,0.00,0.00),('1','152','757','230799',4442250,'2828','316',85994347.78,85995508.50,0.00,0.00,1160.72,626788.80,0.00,0.00,0.00),('1','152','757','231099',4447528,'2123','316',572815.93,574159.57,0.00,0.00,1343.64,784685.76,0.00,0.00,0.00),('1','152','757','231099',4447529,'2124','316',448490.99,449400.97,0.00,0.00,909.98,531428.32,0.00,0.00,0.00),('1','152','757','231099',4447530,'2668','316',51204.68,51453.28,0.00,0.00,248.60,145182.40,0.00,0.00,0.00),('1','152','757','231099',4447531,'2828','316',85995508.50,85996120.08,0.00,0.00,611.58,330253.20,0.00,0.00,0.00),('1','152','757','231357',4451716,'2123','316',574159.57,576256.57,0.00,0.00,2097.00,1224648.00,0.00,0.00,0.00),('1','152','757','231357',4451717,'2124','316',449400.97,451456.57,0.00,0.00,2055.60,1200470.40,0.00,0.00,0.00),('1','152','757','231357',4451718,'2668','316',51453.28,51753.28,0.00,0.00,300.00,175200.00,0.00,0.00,0.00),('1','152','757','231357',4451719,'2828','316',85996120.08,85997279.98,0.00,0.00,1159.90,649544.00,0.00,0.00,0.00),('1','152','757','231627',4456352,'2123','316',576256.57,576985.50,0.00,0.00,728.93,425695.12,0.00,0.00,0.00),('1','152','757','231627',4456353,'2124','316',451456.57,451779.92,0.00,0.00,323.35,188836.40,0.00,0.00,0.00),('1','152','757','231627',4456354,'2668','316',51753.28,52003.39,0.00,0.00,250.11,146064.24,0.00,0.00,0.00),('1','152','757','231627',4456355,'2828','316',85997279.98,85997969.26,0.00,0.00,689.28,385996.80,0.00,0.00,0.00),('1','152','757','231931',4461665,'2123','316',576985.50,577190.45,0.00,0.00,204.95,119690.80,0.00,0.00,0.00),('1','152','757','231931',4461666,'2124','316',451779.92,452093.35,0.00,0.00,313.43,183043.12,0.00,0.00,0.00),('1','152','757','231931',4461667,'2668','316',52003.39,52015.54,0.00,0.00,12.15,7095.60,0.00,0.00,0.00),('1','152','757','231931',4461668,'2828','316',85997969.26,85999438.30,0.00,0.00,1469.04,822662.40,0.00,0.00,0.00),('1','152','757','231999',4463019,'2123','316',577190.45,578245.79,0.00,0.00,1055.34,616318.56,0.00,0.00,0.00),('1','152','757','231999',4463020,'2124','316',452093.35,453059.22,0.00,0.00,965.87,564068.08,0.00,0.00,0.00),('1','152','757','231999',4463021,'2668','316',52015.54,52015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','231999',4463022,'2828','316',85999438.30,86000538.74,0.00,0.00,1100.44,616682.00,0.00,0.00,0.00),('1','152','757','232128',4465242,'2123','316',578245.79,579778.18,0.00,0.00,1532.39,894915.76,0.00,0.00,0.00),('1','152','757','232128',4465243,'2124','316',453059.22,454146.52,0.00,0.00,1087.30,634983.20,0.00,0.00,0.00),('1','152','757','232128',4465244,'2668','316',52015.54,52353.71,0.00,0.00,338.17,197491.28,0.00,0.00,0.00),('1','152','757','232128',4465245,'2828','316',86000538.74,86001310.34,0.00,0.00,771.60,432096.00,0.00,0.00,0.00),('1','152','757','232514',4472357,'2123','316',579778.18,581538.85,0.00,0.00,1760.67,1028231.28,0.00,0.00,0.00),('1','152','757','232514',4472358,'2124','316',454146.52,455521.74,0.00,0.00,1375.22,803128.48,0.00,0.00,0.00),('1','152','757','232514',4472359,'2668','316',52353.71,52353.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','232514',4472360,'2828','316',86001310.34,86002596.44,0.00,0.00,1286.10,720216.00,0.00,0.00,0.00),('1','152','757','232751',4476665,'2123','316',581538.85,583047.53,0.00,0.00,1508.68,881069.12,0.00,0.00,0.00),('1','152','757','232751',4476666,'2124','316',455521.74,457223.09,0.00,0.00,1701.35,993588.40,0.00,0.00,0.00),('1','152','757','232751',4476667,'2668','316',52353.71,52696.34,0.00,0.00,342.63,200095.92,0.00,0.00,0.00),('1','152','757','232751',4476668,'2828','316',86002596.44,86003451.67,0.00,0.00,855.23,478928.80,0.00,0.00,0.00),('1','152','757','233042',4481800,'2123','316',583047.53,583047.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','233042',4481801,'2124','316',457223.09,457223.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','233042',4481802,'2668','316',52696.34,52696.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','233042',4481803,'2828','316',86003451.67,86003451.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','233047',4481877,'2123','316',583047.53,584264.15,0.00,0.00,1216.62,710506.08,0.00,0.00,0.00),('1','152','757','233047',4481878,'2124','316',457223.09,457946.83,0.00,0.00,723.74,422664.16,0.00,0.00,0.00),('1','152','757','233047',4481879,'2668','316',52696.34,52706.61,0.00,0.00,10.27,5997.68,0.00,0.00,0.00),('1','152','757','233047',4481880,'2828','316',86003451.67,86005180.65,0.00,0.00,1728.98,968228.80,0.00,0.00,0.00),('1','152','757','233230',4485107,'2123','316',584264.15,586300.69,0.00,0.00,2036.54,1189339.36,0.00,0.00,0.00),('1','152','757','233230',4485108,'2124','316',457946.83,459459.73,0.00,0.00,1512.90,883533.60,0.00,0.00,0.00),('1','152','757','233230',4485109,'2668','316',52706.61,53206.61,0.00,0.00,500.00,292000.00,0.00,0.00,0.00),('1','152','757','233230',4485110,'2828','316',86005180.65,86006494.93,0.00,0.00,1314.28,735996.80,0.00,0.00,0.00),('1','152','757','233375',4487767,'2123','316',586300.69,587104.61,0.00,0.00,803.92,501646.08,0.00,0.00,0.00),('1','152','757','233375',4487768,'2124','316',459459.73,459978.86,0.00,0.00,519.13,323937.12,0.00,0.00,0.00),('1','152','757','233375',4487769,'2668','316',53206.61,53346.84,0.00,0.00,140.23,87503.52,0.00,0.00,0.00),('1','152','757','233375',4487770,'2828','316',86006494.93,86007166.45,0.00,0.00,671.52,394853.76,0.00,0.00,0.00),('1','152','757','233660',4492801,'2123','316',587104.61,588452.55,0.00,0.00,1347.94,841114.56,0.00,0.00,0.00),('1','152','757','233660',4492802,'2124','316',459978.86,461158.22,0.00,0.00,1179.36,735920.64,0.00,0.00,0.00),('1','152','757','233660',4492803,'2668','316',53346.84,53374.56,0.00,0.00,27.72,17297.28,0.00,0.00,0.00),('1','152','757','233660',4492804,'2828','316',86007166.45,86008615.25,0.00,0.00,1448.80,851894.40,0.00,0.00,0.00),('1','152','757','233974',4498702,'2123','316',588452.55,589848.02,0.00,0.00,1395.47,870773.28,0.00,0.00,0.00),('1','152','757','233974',4498703,'2124','316',461158.22,462183.35,0.00,0.00,1025.13,639681.12,0.00,0.00,0.00),('1','152','757','233974',4498704,'2668','316',53374.56,54975.06,0.00,0.00,1600.50,941094.00,0.00,0.00,0.00),('1','152','757','233974',4498705,'2828','316',86008615.25,86009410.86,0.00,0.00,795.61,467818.68,0.00,0.00,0.00),('1','152','757','234243',4503481,'2123','316',589848.02,589848.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','234243',4503482,'2124','316',462183.35,462183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','234243',4503483,'2668','316',54975.06,54975.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','234243',4503484,'2828','316',86009410.86,86009410.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','234320',4504757,'2123','316',589848.02,591485.52,0.00,0.00,1637.50,1021424.88,0.00,0.00,0.00),('1','152','757','234320',4504758,'2124','316',462183.35,463540.02,0.00,0.00,1356.67,846562.08,0.00,0.00,0.00),('1','152','757','234320',4504759,'2668','316',54975.06,54985.48,0.00,0.00,10.42,6502.08,0.00,0.00,0.00),('1','152','757','234320',4504760,'2828','316',86009410.86,86009964.05,0.00,0.00,553.19,325275.72,0.00,0.00,0.00),('1','152','757','234456',4507330,'2123','316',591485.52,592172.51,0.00,0.00,686.99,426939.72,0.00,0.00,0.00),('1','152','757','234456',4507331,'2124','316',463540.02,465040.99,0.00,0.00,1500.97,936605.28,0.00,0.00,0.00),('1','152','757','234456',4507332,'2668','316',54985.48,55033.87,0.00,0.00,48.39,30195.36,0.00,0.00,0.00),('1','152','757','234456',4507333,'2828','316',86009964.05,86010807.19,0.00,0.00,843.14,495766.32,0.00,0.00,0.00),('1','152','757','234626',4510314,'2123','316',592172.51,593622.46,0.00,0.00,1449.95,904768.80,0.00,0.00,0.00),('1','152','757','234626',4510315,'2124','316',465040.99,466358.70,0.00,0.00,1317.71,822251.04,0.00,0.00,0.00),('1','152','757','234626',4510316,'2668','316',55033.87,56234.50,0.00,0.00,1200.63,706867.56,0.00,0.00,0.00),('1','152','757','234626',4510317,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','234945',4516073,'2123','316',593622.46,595290.82,0.00,0.00,1668.36,1041056.64,0.00,0.00,0.00),('1','152','757','234945',4516074,'2124','316',466358.70,467823.50,0.00,0.00,1464.80,913322.40,0.00,0.00,0.00),('1','152','757','234945',4516075,'2668','316',56234.50,57367.39,0.00,0.00,1132.89,666852.12,0.00,0.00,0.00),('1','152','757','234945',4516076,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','235182',4520126,'2123','316',595290.82,596868.78,0.00,0.00,1577.96,984647.04,0.00,0.00,0.00),('1','152','757','235182',4520127,'2124','316',467823.50,468974.81,0.00,0.00,1151.31,718417.44,0.00,0.00,0.00),('1','152','757','235182',4520128,'2668','316',57367.39,58598.80,0.00,0.00,1231.41,724069.08,0.00,0.00,0.00),('1','152','757','235182',4520129,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','235360',4523106,'2123','316',596868.78,598497.11,0.00,0.00,1628.33,1016077.92,0.00,0.00,0.00),('1','152','757','235360',4523107,'2124','316',468974.81,470287.32,0.00,0.00,1312.51,819006.24,0.00,0.00,0.00),('1','152','757','235360',4523108,'2668','316',58598.80,60838.25,0.00,0.00,2239.45,1316796.60,0.00,0.00,0.00),('1','152','757','235360',4523109,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','235529',4526129,'2123','316',598497.11,598514.42,0.00,0.00,17.31,10801.44,0.00,0.00,0.00),('1','152','757','235529',4526130,'2124','316',470287.32,470295.33,0.00,0.00,8.01,4998.24,0.00,0.00,0.00),('1','152','757','235529',4526131,'2668','316',60838.25,61351.15,0.00,0.00,512.90,301585.20,0.00,0.00,0.00),('1','152','757','235529',4526132,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','235682',4528918,'2123','316',598514.42,600635.60,0.00,0.00,2121.18,1323616.32,0.00,0.00,0.00),('1','152','757','235682',4528919,'2124','316',470295.33,472039.67,0.00,0.00,1744.34,1088468.16,0.00,0.00,0.00),('1','152','757','235682',4528920,'2668','316',61351.15,62710.03,0.00,0.00,1358.88,799021.44,0.00,0.00,0.00),('1','152','757','235682',4528921,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','235811',4531083,'2123','316',600635.60,602610.26,0.00,0.00,1974.66,1263782.40,0.00,0.00,0.00),('1','152','757','235811',4531084,'2124','316',472039.67,473611.06,0.00,0.00,1571.39,1005689.60,0.00,0.00,0.00),('1','152','757','235811',4531085,'2668','316',62710.03,63027.21,0.00,0.00,317.18,193273.58,0.00,0.00,0.00),('1','152','757','235811',4531086,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','236066',4535452,'2123','316',602610.26,604716.51,0.00,0.00,2106.25,1348000.00,0.00,0.00,0.00),('1','152','757','236066',4535453,'2124','316',473611.06,475123.74,0.00,0.00,1512.68,968115.20,0.00,0.00,0.00),('1','152','757','236066',4535454,'2668','316',63027.21,64732.21,0.00,0.00,1705.00,1033230.00,0.00,0.00,0.00),('1','152','757','236066',4535455,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','236232',4538657,'2123','316',604716.51,605890.61,0.00,0.00,1174.10,751424.00,0.00,0.00,0.00),('1','152','757','236232',4538658,'2124','316',475123.74,475975.66,0.00,0.00,851.92,545228.80,0.00,0.00,0.00),('1','152','757','236232',4538659,'2668','316',64732.21,65743.15,0.00,0.00,1010.94,612629.64,0.00,0.00,0.00),('1','152','757','236232',4538660,'2828','316',86010807.19,86010807.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','236421',4541990,'2123','316',605890.61,606461.86,0.00,0.00,571.25,365600.00,0.00,0.00,0.00),('1','152','757','236421',4541991,'2124','316',475975.66,476430.85,0.00,0.00,455.19,291321.60,0.00,0.00,0.00),('1','152','757','236421',4541992,'2668','316',65743.15,65995.95,0.00,0.00,252.80,153196.80,0.00,0.00,0.00),('1','152','757','236421',4541993,'2828','316',86010807.19,86010917.22,0.00,0.00,110.03,70419.20,0.00,0.00,0.00),('1','152','757','236563',4544256,'2123','316',606461.86,608485.87,0.00,0.00,2024.01,1295366.40,0.00,0.00,0.00),('1','152','757','236563',4544257,'2124','316',476430.85,477984.47,0.00,0.00,1553.62,994316.80,0.00,0.00,0.00),('1','152','757','236563',4544258,'2668','316',65995.95,66842.79,0.00,0.00,846.84,513185.04,0.00,0.00,0.00),('1','152','757','236563',4544259,'2828','316',86010917.22,86011110.44,0.00,0.00,193.22,123660.80,0.00,0.00,0.00),('1','152','757','236719',4547043,'2123','316',608485.87,610185.37,0.00,0.00,1699.50,1087680.00,0.00,0.00,0.00),('1','152','757','236719',4547044,'2124','316',477984.47,479194.43,0.00,0.00,1209.96,773785.18,0.00,0.00,0.00),('1','152','757','236719',4547045,'2668','316',66842.79,67513.39,0.00,0.00,670.60,408083.60,0.00,0.00,0.00),('1','152','757','236719',4547046,'2828','316',86011110.44,86012171.95,0.00,0.00,1061.51,643275.06,0.00,0.00,0.00),('1','152','757','236953',4551116,'2123','316',610185.37,612106.18,0.00,0.00,1920.81,1200637.36,0.00,0.00,0.00),('1','152','757','236953',4551117,'2124','316',479194.43,480987.73,0.00,0.00,1793.30,1147712.00,0.00,0.00,0.00),('1','152','757','236953',4551118,'2668','316',67513.39,68832.98,0.00,0.00,1319.59,799671.54,0.00,0.00,0.00),('1','152','757','236953',4551119,'2828','316',86012171.95,86012701.73,0.00,0.00,529.78,339059.20,0.00,0.00,0.00),('1','152','757','237154',4554786,'2123','316',612106.18,613625.05,0.00,0.00,1518.87,963821.60,0.00,0.00,0.00),('1','152','757','237154',4554787,'2124','316',480987.73,482462.55,0.00,0.00,1474.82,943884.80,0.00,0.00,0.00),('1','152','757','237154',4554788,'2668','316',68832.98,70819.23,0.00,0.00,1986.25,1206253.20,0.00,0.00,0.00),('1','152','757','237154',4554789,'2828','316',86012701.73,86013481.52,0.00,0.00,779.79,490463.60,0.00,0.00,0.00),('1','152','757','237461',4560323,'2123','316',613625.05,614263.22,0.00,0.00,638.17,408428.80,0.00,0.00,0.00),('1','152','757','237461',4560324,'2124','316',482462.55,482969.71,0.00,0.00,507.16,324582.40,0.00,0.00,0.00),('1','152','757','237461',4560325,'2668','316',70819.23,71802.08,0.00,0.00,982.85,595607.10,0.00,0.00,0.00),('1','152','757','237461',4560326,'2828','316',86013481.52,86013625.15,0.00,0.00,143.63,91923.20,0.00,0.00,0.00),('1','152','757','237487',4560756,'2123','316',614263.22,615279.08,0.00,0.00,1015.86,650150.40,0.00,0.00,0.00),('1','152','757','237487',4560757,'2124','316',482969.71,483656.85,0.00,0.00,687.14,439769.60,0.00,0.00,0.00),('1','152','757','237487',4560758,'2668','316',71802.08,73299.67,0.00,0.00,1497.59,907539.54,0.00,0.00,0.00),('1','152','757','237487',4560759,'2828','316',86013625.15,86013815.09,0.00,0.00,189.94,121561.60,0.00,0.00,0.00),('1','152','757','237591',4562669,'2123','316',615279.08,616683.76,0.00,0.00,1404.68,901074.88,0.00,0.00,0.00),('1','152','757','237591',4562670,'2124','316',483656.85,484980.58,0.00,0.00,1323.73,847446.96,0.00,0.00,0.00),('1','152','757','237591',4562671,'2668','316',73299.67,74388.96,0.00,0.00,1089.29,685188.34,0.00,0.00,0.00),('1','152','757','237591',4562672,'2828','316',86013815.09,86014330.23,0.00,0.00,515.14,328487.84,0.00,0.00,0.00),('1','152','757','237857',4567009,'2123','316',616683.76,618358.56,0.00,0.00,1674.80,1071872.00,0.00,0.00,0.00),('1','152','757','237857',4567010,'2124','316',484980.58,485907.26,0.00,0.00,926.68,593075.20,0.00,0.00,0.00),('1','152','757','237857',4567011,'2668','316',74388.96,75288.28,0.00,0.00,899.32,559377.04,0.00,0.00,0.00),('1','152','757','237857',4567012,'2828','316',86014330.23,86014526.60,0.00,0.00,196.37,125676.80,0.00,0.00,0.00),('1','152','757','238179',4572117,'2123','316',618358.56,619536.50,0.00,0.00,1177.94,753881.60,0.00,0.00,0.00),('1','152','757','238179',4572118,'2124','316',485907.26,486874.09,0.00,0.00,966.83,618771.20,0.00,0.00,0.00),('1','152','757','238179',4572119,'2668','316',75288.28,77108.34,0.00,0.00,1820.06,1132132.22,0.00,0.00,0.00),('1','152','757','238179',4572120,'2828','316',86014526.60,86014735.44,0.00,0.00,208.84,133657.60,0.00,0.00,0.00),('1','152','757','238342',4575172,'2123','316',619536.50,621097.90,0.00,0.00,1561.40,999296.00,0.00,0.00,0.00),('1','152','757','238342',4575173,'2124','316',486874.09,488009.69,0.00,0.00,1135.60,726784.00,0.00,0.00,0.00),('1','152','757','238342',4575174,'2668','316',77108.34,77987.32,0.00,0.00,878.98,546946.58,0.00,0.00,0.00),('1','152','757','238342',4575175,'2828','316',86014735.44,86014872.01,0.00,0.00,136.57,87404.80,0.00,0.00,0.00),('1','152','757','238599',4579332,'2123','316',621097.90,622563.57,0.00,0.00,1465.67,938028.80,0.00,0.00,0.00),('1','152','757','238599',4579333,'2124','316',488009.69,489245.44,0.00,0.00,1235.75,790880.00,0.00,0.00,0.00),('1','152','757','238599',4579334,'2668','316',77987.32,78863.59,0.00,0.00,876.27,545147.94,0.00,0.00,0.00),('1','152','757','238599',4579335,'2828','316',86014872.01,86015400.84,0.00,0.00,528.83,338343.20,0.00,0.00,0.00),('1','152','757','238819',4583299,'2123','316',622563.57,623026.03,0.00,0.00,462.46,295074.40,0.00,0.00,0.00),('1','152','757','238819',4583300,'2124','316',489245.44,489517.74,0.00,0.00,272.30,174272.00,0.00,0.00,0.00),('1','152','757','238819',4583301,'2668','316',78863.59,78962.80,0.00,0.00,99.21,61708.62,0.00,0.00,0.00),('1','152','757','238819',4583302,'2828','316',86015400.84,86015577.88,0.00,0.00,177.04,113305.60,0.00,0.00,0.00),('1','152','757','238910',4584850,'2123','316',623026.03,624156.24,0.00,0.00,1130.21,723334.40,0.00,0.00,0.00),('1','152','757','238910',4584851,'2124','316',489517.74,490284.27,0.00,0.00,766.53,490579.20,0.00,0.00,0.00),('1','152','757','238910',4584852,'2668','316',78962.80,79256.47,0.00,0.00,293.67,182662.74,0.00,0.00,0.00),('1','152','757','238910',4584853,'2828','316',86015577.88,86015913.28,0.00,0.00,335.40,214656.00,0.00,0.00,0.00),('1','152','757','239047',4587467,'2123','316',624156.24,625479.31,0.00,0.00,1323.07,846764.80,0.00,0.00,0.00),('1','152','757','239047',4587468,'2124','316',490284.27,491251.73,0.00,0.00,967.46,619174.40,0.00,0.00,0.00),('1','152','757','239047',4587469,'2668','316',79256.47,79725.08,0.00,0.00,468.61,292375.42,0.00,0.00,0.00),('1','152','757','239047',4587470,'2828','316',86015913.28,86016263.11,0.00,0.00,349.83,222991.20,0.00,0.00,0.00),('1','152','757','239280',4591355,'2123','316',625479.31,626767.90,0.00,0.00,1288.59,824697.60,0.00,0.00,0.00),('1','152','757','239280',4591356,'2124','316',491251.73,492315.62,0.00,0.00,1063.89,680889.60,0.00,0.00,0.00),('1','152','757','239280',4591357,'2668','316',79725.08,80748.29,0.00,0.00,1023.21,636436.62,0.00,0.00,0.00),('1','152','757','239280',4591358,'2828','316',86016263.11,86016561.59,0.00,0.00,298.48,191027.20,0.00,0.00,0.00),('1','152','757','239540',4595638,'2123','316',626767.90,627663.16,0.00,0.00,895.26,572966.40,0.00,0.00,0.00),('1','152','757','239540',4595639,'2124','316',492315.62,493306.63,0.00,0.00,991.01,634246.40,0.00,0.00,0.00),('1','152','757','239540',4595640,'2668','316',80748.29,82449.04,0.00,0.00,1700.75,1065066.50,0.00,0.00,0.00),('1','152','757','239540',4595641,'2828','316',86016561.59,86016961.59,0.00,0.00,400.00,248800.00,0.00,0.00,0.00),('1','152','757','239747',4599491,'2123','316',627663.16,628902.60,0.00,0.00,1239.44,813072.64,0.00,0.00,0.00),('1','152','757','239747',4599492,'2124','316',493306.63,494337.76,0.00,0.00,1031.13,676421.28,0.00,0.00,0.00),('1','152','757','239747',4599493,'2668','316',82449.04,84006.56,0.00,0.00,1557.52,981271.40,0.00,0.00,0.00),('1','152','757','239747',4599494,'2828','316',86016961.59,86017105.42,0.00,0.00,143.83,94352.48,0.00,0.00,0.00),('1','152','757','239971',4603415,'2123','316',628902.60,630168.37,0.00,0.00,1265.77,830345.12,0.00,0.00,0.00),('1','152','757','239971',4603416,'2124','316',494337.76,495366.50,0.00,0.00,1028.74,674853.44,0.00,0.00,0.00),('1','152','757','239971',4603417,'2668','316',84006.56,84490.06,0.00,0.00,483.50,304605.00,0.00,0.00,0.00),('1','152','757','239971',4603418,'2828','316',86017105.42,86017301.31,0.00,0.00,195.89,128503.84,0.00,0.00,0.00),('1','152','757','240211',4607372,'2123','316',630168.37,631120.33,0.00,0.00,951.96,623185.76,0.00,0.00,0.00),('1','152','757','240211',4607373,'2124','316',495366.50,496279.92,0.00,0.00,913.42,599203.52,0.00,0.00,0.00),('1','152','757','240211',4607374,'2668','316',84490.06,85855.19,0.00,0.00,1365.13,861331.90,0.00,0.00,0.00),('1','152','757','240211',4607375,'2828','316',86017301.31,86017642.12,0.00,0.00,340.81,223571.36,0.00,0.00,0.00),('1','152','757','240392',4610563,'2123','316',631120.33,631277.07,0.00,0.00,156.74,102821.44,0.00,0.00,0.00),('1','152','757','240392',4610564,'2124','316',496279.92,496400.46,0.00,0.00,120.54,79074.24,0.00,0.00,0.00),('1','152','757','240392',4610565,'2668','316',85855.19,85855.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','240392',4610566,'2828','316',86017642.12,86017707.36,0.00,0.00,65.24,42797.44,0.00,0.00,0.00),('1','152','757','240434',4611168,'2123','316',631277.07,632643.54,0.00,0.00,1366.47,874206.96,0.00,0.00,0.00),('1','152','757','240434',4611169,'2124','316',496400.46,497320.56,0.00,0.00,920.10,588864.00,0.00,0.00,0.00),('1','152','757','240434',4611170,'2668','316',85855.19,86304.01,0.00,0.00,448.82,276806.96,0.00,0.00,0.00),('1','152','757','240434',4611171,'2828','316',86017707.36,86018187.12,0.00,0.00,479.76,307046.40,0.00,0.00,0.00),('1','152','757','240677',4614831,'2123','316',632643.54,633529.74,0.00,0.00,886.20,567168.00,0.00,0.00,0.00),('1','152','757','240677',4614832,'2124','316',497320.56,497931.33,0.00,0.00,610.77,390892.80,0.00,0.00,0.00),('1','152','757','240677',4614833,'2668','316',86304.01,86691.86,0.00,0.00,387.85,238915.60,0.00,0.00,0.00),('1','152','757','240677',4614834,'2828','316',86018187.12,86018366.27,0.00,0.00,179.15,114656.00,0.00,0.00,0.00),('1','152','757','240897',4618653,'2123','316',633529.74,633843.17,0.00,0.00,313.43,200595.20,0.00,0.00,0.00),('1','152','757','240897',4618654,'2124','316',497931.33,498160.19,0.00,0.00,228.86,146470.40,0.00,0.00,0.00),('1','152','757','240897',4618655,'2668','316',86691.86,86711.36,0.00,0.00,19.50,12012.00,0.00,0.00,0.00),('1','152','757','240897',4618656,'2828','316',86018366.27,86018557.45,0.00,0.00,191.18,122355.20,0.00,0.00,0.00),('1','152','757','241027',4620855,'2123','316',633843.17,635247.36,0.00,0.00,1404.19,898681.60,0.00,0.00,0.00),('1','152','757','241027',4620856,'2124','316',498160.19,499101.16,0.00,0.00,940.97,602220.80,0.00,0.00,0.00),('1','152','757','241027',4620857,'2668','316',86711.36,88223.79,0.00,0.00,1512.43,931656.88,0.00,0.00,0.00),('1','152','757','241027',4620858,'2828','316',86018557.45,86018892.21,0.00,0.00,334.76,214246.40,0.00,0.00,0.00),('1','152','757','241226',4624560,'2123','316',635247.36,636672.22,0.00,0.00,1424.86,914270.40,0.00,0.00,0.00),('1','152','757','241226',4624561,'2124','316',499101.16,499975.33,0.00,0.00,874.17,559468.80,0.00,0.00,0.00),('1','152','757','241226',4624562,'2668','316',88223.79,89544.36,0.00,0.00,1320.57,813471.12,0.00,0.00,0.00),('1','152','757','241226',4624563,'2828','316',86018892.21,86019130.69,0.00,0.00,238.48,152627.20,0.00,0.00,0.00),('1','152','757','241480',4628928,'2123','316',636672.22,637993.01,0.00,0.00,1320.79,845041.12,0.00,0.00,0.00),('1','152','757','241480',4628929,'2124','316',499975.33,501258.44,0.00,0.00,1283.11,821190.40,0.00,0.00,0.00),('1','152','757','241480',4628930,'2668','316',89544.36,89969.67,0.00,0.00,425.31,262255.44,0.00,0.00,0.00),('1','152','757','241480',4628931,'2828','316',86019130.69,86019528.99,0.00,0.00,398.30,254912.00,0.00,0.00,0.00),('1','152','757','241716',4633123,'2123','316',637993.01,639395.52,0.00,0.00,1402.51,897606.40,0.00,0.00,0.00),('1','152','757','241716',4633124,'2124','316',501258.44,502247.80,0.00,0.00,989.36,633190.40,0.00,0.00,0.00),('1','152','757','241716',4633125,'2668','316',89969.67,91578.59,0.00,0.00,1608.92,991094.72,0.00,0.00,0.00),('1','152','757','241716',4633126,'2828','316',86019528.99,86019891.61,0.00,0.00,362.62,232076.80,0.00,0.00,0.00),('1','152','757','241961',4637288,'2123','316',639395.52,640478.57,0.00,0.00,1083.05,693152.00,0.00,0.00,0.00),('1','152','757','241961',4637289,'2124','316',502247.80,503241.33,0.00,0.00,993.53,635859.20,0.00,0.00,0.00),('1','152','757','241961',4637290,'2668','316',91578.59,92114.79,0.00,0.00,536.20,330529.84,0.00,0.00,0.00),('1','152','757','241961',4637291,'2828','316',86019891.61,86020589.13,0.00,0.00,697.52,446412.80,0.00,0.00,0.00),('1','152','757','242197',4641427,'2123','316',640478.57,641879.42,0.00,0.00,1400.85,892944.00,0.00,0.00,0.00),('1','152','757','242197',4641428,'2124','316',503241.33,504458.85,0.00,0.00,1217.52,779212.80,0.00,0.00,0.00),('1','152','757','242197',4641429,'2668','316',92114.79,93273.06,0.00,0.00,1158.27,713906.88,0.00,0.00,0.00),('1','152','757','242197',4641430,'2828','316',86020589.13,86021436.92,0.00,0.00,847.79,542585.60,0.00,0.00,0.00),('1','152','757','242473',4646053,'2123','316',641879.42,641879.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','242473',4646054,'2124','316',504458.85,504458.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','242473',4646055,'2668','316',93273.06,93273.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','242473',4646056,'2828','316',86021436.92,86021436.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','242489',4646349,'2123','316',641879.42,643246.90,0.00,0.00,1367.48,875187.20,0.00,0.00,0.00),('1','152','757','242489',4646350,'2124','316',504458.85,505644.67,0.00,0.00,1185.82,758924.80,0.00,0.00,0.00),('1','152','757','242489',4646351,'2668','316',93273.06,94403.90,0.00,0.00,1130.84,697245.92,0.00,0.00,0.00),('1','152','757','242489',4646352,'2828','316',86021436.92,86022036.07,0.00,0.00,599.15,383456.00,0.00,0.00,0.00),('1','152','757','242671',4649738,'2123','316',643246.90,644938.95,0.00,0.00,1692.05,1082912.00,0.00,0.00,0.00),('1','152','757','242671',4649739,'2124','316',505644.67,507000.90,0.00,0.00,1356.23,867987.20,0.00,0.00,0.00),('1','152','757','242671',4649740,'2668','316',94403.90,94970.73,0.00,0.00,566.83,349167.28,0.00,0.00,0.00),('1','152','757','242671',4649741,'2828','316',86022036.07,86022555.23,0.00,0.00,519.16,323862.40,0.00,0.00,0.00),('1','152','757','242910',4653749,'2123','316',644938.95,646137.50,0.00,0.00,1198.55,767072.00,0.00,0.00,0.00),('1','152','757','242910',4653750,'2124','316',507000.90,508401.69,0.00,0.00,1400.79,896505.60,0.00,0.00,0.00),('1','152','757','242910',4653751,'2668','316',94970.73,98156.10,0.00,0.00,3185.37,1962385.44,0.00,0.00,0.00),('1','152','757','242910',4653752,'2828','316',86022555.23,86023002.79,0.00,0.00,447.56,285386.48,0.00,0.00,0.00),('1','152','757','243135',4657682,'2123','316',646137.50,647731.83,0.00,0.00,1594.33,1009298.80,0.00,0.00,0.00),('1','152','757','243135',4657683,'2124','316',508401.69,509715.35,0.00,0.00,1313.66,840742.40,0.00,0.00,0.00),('1','152','757','243135',4657684,'2668','316',98156.10,99038.36,0.00,0.00,882.26,543472.16,0.00,0.00,0.00),('1','152','757','243135',4657685,'2828','316',86023002.79,86023573.43,0.00,0.00,570.64,365209.60,0.00,0.00,0.00),('1','152','757','243352',4661708,'2123','316',647731.83,649329.60,0.00,0.00,1597.77,1022572.80,0.00,0.00,0.00),('1','152','757','243352',4661709,'2124','316',509715.35,511114.08,0.00,0.00,1398.73,895187.20,0.00,0.00,0.00),('1','152','757','243352',4661710,'2668','316',99038.36,100282.18,0.00,0.00,1243.82,766444.40,0.00,0.00,0.00),('1','152','757','243352',4661711,'2828','316',86023573.43,86024170.67,0.00,0.00,597.24,382233.60,0.00,0.00,0.00),('1','152','757','243579',4665603,'2123','316',649329.60,649611.29,0.00,0.00,281.69,180281.60,0.00,0.00,0.00),('1','152','757','243579',4665604,'2124','316',511114.08,511418.37,0.00,0.00,304.29,194745.60,0.00,0.00,0.00),('1','152','757','243579',4665605,'2668','316',100282.18,101002.35,0.00,0.00,720.17,443624.72,0.00,0.00,0.00),('1','152','757','243579',4665606,'2828','316',86024170.67,86024212.71,0.00,0.00,42.04,26905.60,0.00,0.00,0.00),('1','152','757','243683',4667162,'2123','316',649611.29,649611.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','243683',4667163,'2124','316',511418.37,511418.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','243683',4667164,'2668','316',101002.35,101002.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','243683',4667165,'2828','316',86024212.71,86024212.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','243689',4667317,'2123','316',649611.29,650638.12,0.00,0.00,1026.83,657171.20,0.00,0.00,0.00),('1','152','757','243689',4667318,'2124','316',511418.37,512398.87,0.00,0.00,980.50,627520.00,0.00,0.00,0.00),('1','152','757','243689',4667319,'2668','316',101002.35,101745.11,0.00,0.00,742.76,457652.72,0.00,0.00,0.00),('1','152','757','243689',4667320,'2828','316',86024212.71,86024876.63,0.00,0.00,663.92,424908.80,0.00,0.00,0.00),('1','152','757','243828',4669839,'2123','316',650638.12,652304.04,0.00,0.00,1665.92,1066188.80,0.00,0.00,0.00),('1','152','757','243828',4669840,'2124','316',512398.87,513999.77,0.00,0.00,1600.90,1024576.00,0.00,0.00,0.00),('1','152','757','243828',4669841,'2668','316',101745.11,102447.61,0.00,0.00,702.50,432860.00,0.00,0.00,0.00),('1','152','757','243828',4669842,'2828','316',86024876.63,86025474.28,0.00,0.00,597.65,382496.00,0.00,0.00,0.00),('1','152','757','244040',4673576,'2123','316',652304.04,653893.57,0.00,0.00,1589.53,1017299.20,0.00,0.00,0.00),('1','152','757','244040',4673577,'2124','316',513999.77,514999.71,0.00,0.00,999.94,639961.60,0.00,0.00,0.00),('1','152','757','244040',4673578,'2668','316',102447.61,103924.43,0.00,0.00,1476.82,909721.12,0.00,0.00,0.00),('1','152','757','244040',4673579,'2828','316',86025474.28,86025743.48,0.00,0.00,269.20,172288.00,0.00,0.00,0.00),('1','152','757','244289',4677687,'2123','316',653893.57,655479.76,0.00,0.00,1586.19,1015161.60,0.00,0.00,0.00),('1','152','757','244289',4677688,'2124','316',514999.71,516234.16,0.00,0.00,1234.45,790048.00,0.00,0.00,0.00),('1','152','757','244289',4677689,'2668','316',103924.43,104794.19,0.00,0.00,869.76,535772.16,0.00,0.00,0.00),('1','152','757','244289',4677690,'2828','316',86025743.48,86025899.05,0.00,0.00,155.57,99564.80,0.00,0.00,0.00),('1','152','757','244519',4681717,'2123','316',655479.76,656907.87,0.00,0.00,1428.11,913990.40,0.00,0.00,0.00),('1','152','757','244519',4681718,'2124','316',516234.16,517318.04,0.00,0.00,1083.88,693683.20,0.00,0.00,0.00),('1','152','757','244519',4681719,'2668','316',104794.19,105735.61,0.00,0.00,941.42,579914.72,0.00,0.00,0.00),('1','152','757','244519',4681720,'2828','316',86025899.05,86026000.23,0.00,0.00,101.18,64755.20,0.00,0.00,0.00),('1','152','757','244727',4685318,'2123','316',656907.87,658091.89,0.00,0.00,1184.02,757772.80,0.00,0.00,0.00),('1','152','757','244727',4685319,'2124','316',517318.04,518488.85,0.00,0.00,1170.81,749318.40,0.00,0.00,0.00),('1','152','757','244727',4685320,'2668','316',105735.61,106344.12,0.00,0.00,608.51,374842.16,0.00,0.00,0.00),('1','152','757','244727',4685321,'2828','316',86026000.23,86026130.10,0.00,0.00,129.87,83116.80,0.00,0.00,0.00),('1','152','757','244962',4689522,'2123','316',658091.89,658611.05,0.00,0.00,519.16,323955.84,0.00,0.00,0.00),('1','152','757','244962',4689523,'2124','316',518488.85,518893.20,0.00,0.00,404.35,252314.40,0.00,0.00,0.00),('1','152','757','244962',4689524,'2668','316',106344.12,106783.97,0.00,0.00,439.85,263910.00,0.00,0.00,0.00),('1','152','757','244962',4689525,'2828','316',86026130.10,86026231.14,0.00,0.00,101.04,63048.96,0.00,0.00,0.00),('1','152','757','245084',4691561,'2123','316',658611.05,658611.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245084',4691562,'2124','316',518893.20,518893.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245084',4691563,'2668','316',106783.97,106783.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245084',4691564,'2828','316',86026231.14,86026231.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245092',4691686,'2123','316',658611.05,659556.47,0.00,0.00,945.42,589942.08,0.00,0.00,0.00),('1','152','757','245092',4691687,'2124','316',518893.20,519473.72,0.00,0.00,580.52,362244.48,0.00,0.00,0.00),('1','152','757','245092',4691688,'2668','316',106783.97,106949.58,0.00,0.00,165.61,99366.00,0.00,0.00,0.00),('1','152','757','245092',4691689,'2828','316',86026231.14,86026648.22,0.00,0.00,417.08,260257.92,0.00,0.00,0.00),('1','152','757','245210',4693810,'2123','316',659556.47,660776.07,0.00,0.00,1219.60,759806.40,0.00,0.00,0.00),('1','152','757','245210',4693811,'2124','316',519473.72,520513.38,0.00,0.00,1039.66,648747.84,0.00,0.00,0.00),('1','152','757','245210',4693812,'2668','316',106949.58,108208.19,0.00,0.00,1258.61,755166.00,0.00,0.00,0.00),('1','152','757','245210',4693813,'2828','316',86026648.22,86026762.75,0.00,0.00,114.53,71466.72,0.00,0.00,0.00),('1','152','757','245366',4696599,'2123','316',660776.07,660776.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245366',4696600,'2124','316',520513.38,520513.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245366',4696601,'2668','316',108208.19,108208.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245366',4696602,'2828','316',86026762.75,86026762.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245394',4697080,'2123','316',660776.07,660776.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245394',4697081,'2124','316',520513.38,520513.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245394',4697082,'2668','316',108208.19,108208.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245394',4697083,'2828','316',86026762.75,86026762.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','245486',4698432,'2123','316',660776.07,662711.60,0.00,0.00,1935.53,1207770.72,0.00,0.00,0.00),('1','152','757','245486',4698433,'2124','316',520513.38,522256.41,0.00,0.00,1743.03,1087650.72,0.00,0.00,0.00),('1','152','757','245486',4698434,'2668','316',108208.19,110161.93,0.00,0.00,1953.74,1172244.00,0.00,0.00,0.00),('1','152','757','245486',4698435,'2828','316',86026762.75,86027208.20,0.00,0.00,445.45,277960.80,0.00,0.00,0.00),('1','152','757','245685',4701934,'2123','316',662711.60,664198.30,0.00,0.00,1486.70,927700.80,0.00,0.00,0.00),('1','152','757','245685',4701935,'2124','316',522256.41,523176.48,0.00,0.00,920.07,574123.68,0.00,0.00,0.00),('1','152','757','245685',4701936,'2668','316',110161.93,111035.80,0.00,0.00,873.87,524322.00,0.00,0.00,0.00),('1','152','757','245685',4701937,'2828','316',86027208.20,86027479.59,0.00,0.00,271.39,169347.36,0.00,0.00,0.00),('1','152','757','245923',4705749,'2123','316',664198.30,665792.82,0.00,0.00,1594.52,982224.32,0.00,0.00,0.00),('1','152','757','245923',4705750,'2124','316',523176.48,524321.25,0.00,0.00,1144.77,705178.32,0.00,0.00,0.00),('1','152','757','245923',4705751,'2668','316',111035.80,111589.40,0.00,0.00,553.60,315552.00,0.00,0.00,0.00),('1','152','757','245923',4705752,'2828','316',86027479.59,86027739.94,0.00,0.00,260.35,160375.60,0.00,0.00,0.00),('1','152','757','246177',4709983,'2123','316',665792.82,667321.39,0.00,0.00,1528.57,941599.12,0.00,0.00,0.00),('1','152','757','246177',4709984,'2124','316',524321.25,525409.78,0.00,0.00,1088.53,670534.48,0.00,0.00,0.00),('1','152','757','246177',4709985,'2668','316',111589.40,112590.22,0.00,0.00,1000.82,570467.40,0.00,0.00,0.00),('1','152','757','246177',4709986,'2828','316',86027739.94,86028042.45,0.00,0.00,302.51,186346.16,0.00,0.00,0.00),('1','152','757','246442',4714414,'2123','316',667321.39,668931.84,0.00,0.00,1610.45,992037.20,0.00,0.00,0.00),('1','152','757','246442',4714415,'2124','316',525409.78,526797.44,0.00,0.00,1387.66,854798.56,0.00,0.00,0.00),('1','152','757','246442',4714416,'2668','316',112590.22,113136.09,0.00,0.00,545.87,311145.90,0.00,0.00,0.00),('1','152','757','246442',4714417,'2828','316',86028042.45,86028381.95,0.00,0.00,339.50,209132.00,0.00,0.00,0.00),('1','152','757','246700',4718773,'2123','316',668931.84,670407.89,0.00,0.00,1476.05,909430.80,0.00,0.00,0.00),('1','152','757','246700',4718774,'2124','316',526797.44,528060.65,0.00,0.00,1263.21,762037.36,0.00,0.00,0.00),('1','152','757','246700',4718775,'2668','316',113136.09,114278.77,0.00,0.00,1142.68,651327.60,0.00,0.00,0.00),('1','152','757','246700',4718776,'2828','316',86028381.95,86028543.08,0.00,0.00,161.13,99256.08,0.00,0.00,0.00),('1','152','757','246970',4723398,'2123','316',670407.89,671859.68,0.00,0.00,1451.79,894302.64,0.00,0.00,0.00),('1','152','757','246970',4723399,'2124','316',528060.65,529315.51,0.00,0.00,1254.86,772993.76,0.00,0.00,0.00),('1','152','757','246970',4723400,'2668','316',114278.77,115656.82,0.00,0.00,1378.05,785488.50,0.00,0.00,0.00),('1','152','757','246970',4723401,'2828','316',86028543.08,86028881.63,0.00,0.00,338.55,208546.80,0.00,0.00,0.00),('1','152','757','247178',4726987,'2123','316',671859.68,673418.59,0.00,0.00,1558.91,960288.56,0.00,0.00,0.00),('1','152','757','247178',4726988,'2124','316',529315.51,530679.29,0.00,0.00,1363.78,840088.48,0.00,0.00,0.00),('1','152','757','247178',4726989,'2668','316',115656.82,116371.77,0.00,0.00,714.95,407521.50,0.00,0.00,0.00),('1','152','757','247178',4726990,'2828','316',86028881.63,86029545.65,0.00,0.00,664.02,409036.32,0.00,0.00,0.00),('1','152','757','247381',4730876,'2123','316',673418.59,674741.66,0.00,0.00,1323.07,815011.12,0.00,0.00,0.00),('1','152','757','247381',4730877,'2124','316',530679.29,531776.92,0.00,0.00,1097.63,676140.08,0.00,0.00,0.00),('1','152','757','247381',4730878,'2668','316',116371.77,117328.99,0.00,0.00,957.22,545615.40,0.00,0.00,0.00),('1','152','757','247381',4730879,'2828','316',86029545.65,86030059.94,0.00,0.00,514.29,316802.64,0.00,0.00,0.00),('1','152','757','247642',4735283,'2123','316',674741.66,676197.27,0.00,0.00,1455.61,896655.76,0.00,0.00,0.00),('1','152','757','247642',4735284,'2124','316',531776.92,533017.56,0.00,0.00,1240.64,764234.24,0.00,0.00,0.00),('1','152','757','247642',4735285,'2668','316',117328.99,118123.46,0.00,0.00,794.47,452847.90,0.00,0.00,0.00),('1','152','757','247642',4735286,'2828','316',86030059.94,86030275.08,0.00,0.00,215.14,132526.24,0.00,0.00,0.00),('1','152','757','247933',4739839,'2123','316',676197.27,677788.32,0.00,0.00,1591.05,979810.34,0.00,0.00,0.00),('1','152','757','247933',4739840,'2124','316',533017.56,534265.74,0.00,0.00,1248.18,768878.88,0.00,0.00,0.00),('1','152','757','247933',4739841,'2668','316',118123.46,119487.56,0.00,0.00,1364.10,777813.46,0.00,0.00,0.00),('1','152','757','247933',4739842,'2828','316',86030275.08,86030571.23,0.00,0.00,296.15,182428.40,0.00,0.00,0.00),('1','152','757','248141',4743680,'2123','316',677788.32,679439.00,0.00,0.00,1650.68,1016818.88,0.00,0.00,0.00),('1','152','757','248141',4743681,'2124','316',534265.74,535533.81,0.00,0.00,1268.07,781131.12,0.00,0.00,0.00),('1','152','757','248141',4743682,'2668','316',119487.56,120603.50,0.00,0.00,1115.94,636085.80,0.00,0.00,0.00),('1','152','757','248141',4743683,'2828','316',86030571.23,86030763.21,0.00,0.00,191.98,118259.68,0.00,0.00,0.00),('1','152','757','248449',4748567,'2123','316',679439.00,679450.01,0.00,0.00,11.01,6782.16,0.00,0.00,0.00),('1','152','757','248449',4748568,'2124','316',535533.81,535583.13,0.00,0.00,49.32,30381.12,0.00,0.00,0.00),('1','152','757','248449',4748569,'2668','316',120603.50,120723.50,0.00,0.00,120.00,68400.00,0.00,0.00,0.00),('1','152','757','248449',4748570,'2828','316',86030763.21,86030771.21,0.00,0.00,8.00,4928.00,0.00,0.00,0.00),('1','152','757','248461',4748754,'2123','316',679450.01,680879.23,0.00,0.00,1429.22,880399.52,0.00,0.00,0.00),('1','152','757','248461',4748755,'2124','316',535583.13,536866.85,0.00,0.00,1283.72,790771.52,0.00,0.00,0.00),('1','152','757','248461',4748756,'2668','316',120723.50,121248.99,0.00,0.00,525.49,305435.70,0.00,0.00,0.00),('1','152','757','248461',4748757,'2828','316',86030771.21,86031250.70,0.00,0.00,479.49,289459.44,0.00,0.00,0.00),('1','152','757','248649',4752042,'2123','316',680879.23,682543.99,0.00,0.00,1664.76,1025492.16,0.00,0.00,0.00),('1','152','757','248649',4752043,'2124','316',536866.85,538073.21,0.00,0.00,1206.36,743117.76,0.00,0.00,0.00),('1','152','757','248649',4752044,'2668','316',121248.99,121594.61,0.00,0.00,345.62,197003.40,0.00,0.00,0.00),('1','152','757','248649',4752045,'2828','316',86031250.70,86031501.84,0.00,0.00,251.14,154702.24,0.00,0.00,0.00),('1','152','757','248880',4756065,'2123','316',682543.99,684031.38,0.00,0.00,1487.39,892434.00,0.00,0.00,0.00),('1','152','757','248880',4756066,'2124','316',538073.21,539261.23,0.00,0.00,1188.02,712812.00,0.00,0.00,0.00),('1','152','757','248880',4756067,'2668','316',121594.61,121914.02,0.00,0.00,319.41,177272.55,0.00,0.00,0.00),('1','152','757','248880',4756068,'2828','316',86031501.84,86031914.88,0.00,0.00,413.04,247824.00,0.00,0.00,0.00),('1','152','757','249100',4759790,'2123','316',684031.38,685571.37,0.00,0.00,1539.99,923994.00,0.00,0.00,0.00),('1','152','757','249100',4759791,'2124','316',539261.23,540298.26,0.00,0.00,1037.03,622218.00,0.00,0.00,0.00),('1','152','757','249100',4759792,'2668','316',121914.02,122928.93,0.00,0.00,1014.91,563275.05,0.00,0.00,0.00),('1','152','757','249100',4759793,'2828','316',86031914.88,86032253.30,0.00,0.00,338.42,203052.00,0.00,0.00,0.00),('1','152','757','249360',4764157,'2123','316',685571.37,686893.90,0.00,0.00,1322.53,793518.00,0.00,0.00,0.00),('1','152','757','249360',4764158,'2124','316',540298.26,541537.94,0.00,0.00,1239.68,743808.00,0.00,0.00,0.00),('1','152','757','249360',4764159,'2668','316',122928.93,124153.94,0.00,0.00,1225.01,679880.55,0.00,0.00,0.00),('1','152','757','249360',4764160,'2828','316',86032253.30,86032954.43,0.00,0.00,701.13,420678.00,0.00,0.00,0.00),('1','152','757','249582',4767994,'2123','316',686893.90,688473.28,0.00,0.00,1579.38,947628.00,0.00,0.00,0.00),('1','152','757','249582',4767995,'2124','316',541537.94,542722.57,0.00,0.00,1184.63,710778.00,0.00,0.00,0.00),('1','152','757','249582',4767996,'2668','316',124153.94,124792.16,0.00,0.00,638.22,354212.10,0.00,0.00,0.00),('1','152','757','249582',4767997,'2828','316',86032954.43,86033217.47,0.00,0.00,263.04,157824.00,0.00,0.00,0.00),('1','152','757','249835',4772352,'2123','316',688473.28,689052.82,0.00,0.00,579.54,330399.00,0.00,0.00,0.00),('1','152','757','249835',4772353,'2124','316',542722.57,543055.04,0.00,0.00,332.47,199482.00,0.00,0.00,0.00),('1','152','757','249835',4772354,'2668','316',124792.16,125705.16,0.00,0.00,913.00,506715.00,0.00,0.00,0.00),('1','152','757','249835',4772355,'2828','316',86033217.47,86033229.97,0.00,0.00,12.50,7500.00,0.00,0.00,0.00),('1','152','757','249978',4774726,'2123','316',689052.82,689052.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','249978',4774727,'2124','316',543055.04,543055.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','249978',4774728,'2668','316',125705.16,125705.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','249978',4774729,'2828','316',86033229.97,86033229.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','250010',4775268,'2123','316',689052.82,690021.99,0.00,0.00,969.17,581502.00,0.00,0.00,0.00),('1','152','757','250010',4775269,'2124','316',543055.04,543755.53,0.00,0.00,700.49,420294.00,0.00,0.00,0.00),('1','152','757','250010',4775270,'2668','316',125705.16,126250.11,0.00,0.00,544.95,302447.25,0.00,0.00,0.00),('1','152','757','250010',4775271,'2828','316',86033229.97,86033909.58,0.00,0.00,679.61,407766.00,0.00,0.00,0.00),('1','152','757','250083',4776390,'2123','316',690021.99,691863.11,0.00,0.00,1841.12,1104672.00,0.00,0.00,0.00),('1','152','757','250083',4776391,'2124','316',543755.53,545141.46,0.00,0.00,1385.93,831558.00,0.00,0.00,0.00),('1','152','757','250083',4776392,'2668','316',126250.11,126750.80,0.00,0.00,500.69,277882.95,0.00,0.00,0.00),('1','152','757','250083',4776393,'2828','316',86033909.58,86034604.52,0.00,0.00,694.94,416964.00,0.00,0.00,0.00),('1','152','757','250326',4780569,'2123','316',691863.11,693671.21,0.00,0.00,1808.10,1031753.76,0.00,0.00,0.00),('1','152','757','250326',4780570,'2124','316',545141.46,546401.19,0.00,0.00,1259.73,719382.32,0.00,0.00,0.00),('1','152','757','250326',4780571,'2668','316',126750.80,127588.74,0.00,0.00,837.94,462750.31,0.00,0.00,0.00),('1','152','757','250326',4780572,'2828','316',86034604.52,86035367.76,0.00,0.00,763.24,433520.32,0.00,0.00,0.00),('1','152','757','250579',4784497,'2123','316',693671.21,695315.34,0.00,0.00,1644.13,933865.84,0.00,0.00,0.00),('1','152','757','250579',4784498,'2124','316',546401.19,547501.18,0.00,0.00,1099.99,624794.32,0.00,0.00,0.00),('1','152','757','250579',4784499,'2668','316',127588.74,128817.80,0.00,0.00,1229.06,668608.64,0.00,0.00,0.00),('1','152','757','250579',4784500,'2828','316',86035367.76,86035860.77,0.00,0.00,493.01,280029.68,0.00,0.00,0.00),('1','152','757','250805',4788527,'2123','316',695315.34,696973.85,0.00,0.00,1658.51,942033.68,0.00,0.00,0.00),('1','152','757','250805',4788528,'2124','316',547501.18,549012.05,0.00,0.00,1510.87,858174.16,0.00,0.00,0.00),('1','152','757','250805',4788529,'2668','316',128817.80,129358.26,0.00,0.00,540.46,294010.24,0.00,0.00,0.00),('1','152','757','250805',4788530,'2828','316',86035860.77,86036703.52,0.00,0.00,842.75,478682.00,0.00,0.00,0.00),('1','152','757','251018',4792496,'2123','316',696973.85,698003.66,0.00,0.00,1029.81,584932.08,0.00,0.00,0.00),('1','152','757','251018',4792497,'2124','316',549012.05,549745.90,0.00,0.00,733.85,416826.80,0.00,0.00,0.00),('1','152','757','251018',4792498,'2668','316',129358.26,130804.76,0.00,0.00,1446.50,787136.96,0.00,0.00,0.00),('1','152','757','251018',4792499,'2828','316',86036703.52,86037044.39,0.00,0.00,340.87,193614.16,0.00,0.00,0.00),('1','152','757','251216',4795916,'2123','316',698003.66,698003.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','251216',4795917,'2124','316',549745.90,549745.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','251216',4795918,'2668','316',130804.76,130804.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','251216',4795919,'2828','316',86037044.39,86037044.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','251227',4796125,'2123','316',698003.66,698377.75,0.00,0.00,374.09,212483.12,0.00,0.00,0.00),('1','152','757','251227',4796126,'2124','316',549745.90,549964.52,0.00,0.00,218.62,124176.16,0.00,0.00,0.00),('1','152','757','251227',4796127,'2668','316',130804.76,130904.60,0.00,0.00,99.84,54312.96,0.00,0.00,0.00),('1','152','757','251227',4796128,'2828','316',86037044.39,86037291.15,0.00,0.00,246.76,140159.68,0.00,0.00,0.00),('1','152','757','251259',4796676,'2123','316',698377.75,700217.94,0.00,0.00,1840.19,1045227.92,0.00,0.00,0.00),('1','152','757','251259',4796677,'2124','316',549964.52,551427.06,0.00,0.00,1462.54,830722.72,0.00,0.00,0.00),('1','152','757','251259',4796678,'2668','316',130904.60,132080.44,0.00,0.00,1175.84,639656.96,0.00,0.00,0.00),('1','152','757','251259',4796679,'2828','316',86037291.15,86037928.84,0.00,0.00,637.69,362207.92,0.00,0.00,0.00),('1','152','757','251510',4800860,'2123','316',700217.94,701838.73,0.00,0.00,1620.79,920608.72,0.00,0.00,0.00),('1','152','757','251510',4800861,'2124','316',551427.06,552522.14,0.00,0.00,1095.08,622005.44,0.00,0.00,0.00),('1','152','757','251510',4800862,'2668','316',132080.44,132857.85,0.00,0.00,777.41,422911.04,0.00,0.00,0.00),('1','152','757','251510',4800863,'2828','316',86037928.84,86038372.12,0.00,0.00,443.28,251783.04,0.00,0.00,0.00),('1','152','757','251760',4805363,'2123','316',701838.73,703348.24,0.00,0.00,1509.51,857401.68,0.00,0.00,0.00),('1','152','757','251760',4805364,'2124','316',552522.14,553594.00,0.00,0.00,1071.86,608816.48,0.00,0.00,0.00),('1','152','757','251760',4805365,'2668','316',132857.85,133272.88,0.00,0.00,415.03,225776.32,0.00,0.00,0.00),('1','152','757','251760',4805366,'2828','316',86038372.12,86038779.64,0.00,0.00,407.52,231471.36,0.00,0.00,0.00),('1','152','757','251978',4809182,'2123','316',703348.24,704952.64,0.00,0.00,1604.40,902099.28,0.00,0.00,0.00),('1','152','757','251978',4809183,'2124','316',553594.00,554692.22,0.00,0.00,1098.22,623788.96,0.00,0.00,0.00),('1','152','757','251978',4809184,'2668','316',133272.88,134154.25,0.00,0.00,881.37,488665.20,0.00,0.00,0.00),('1','152','757','251978',4809185,'2828','316',86038779.64,86039352.28,0.00,0.00,572.64,325259.52,0.00,0.00,0.00),('1','152','757','252289',4814255,'2123','316',704952.64,706667.67,0.00,0.00,1715.03,974137.04,0.00,0.00,0.00),('1','152','757','252289',4814256,'2124','316',554692.22,556020.37,0.00,0.00,1328.15,754389.20,0.00,0.00,0.00),('1','152','757','252289',4814257,'2668','316',134154.25,134344.11,0.00,0.00,189.86,103283.84,0.00,0.00,0.00),('1','152','757','252289',4814258,'2828','316',86039352.28,86039982.10,0.00,0.00,629.82,357737.76,0.00,0.00,0.00),('1','152','757','252462',4817803,'2123','316',706667.67,707396.15,0.00,0.00,728.48,413776.64,0.00,0.00,0.00),('1','152','757','252462',4817804,'2124','316',556020.37,556503.28,0.00,0.00,482.91,274292.88,0.00,0.00,0.00),('1','152','757','252462',4817805,'2668','316',134344.11,135761.61,0.00,0.00,1417.50,771120.00,0.00,0.00,0.00),('1','152','757','252462',4817806,'2828','316',86039982.10,86040044.25,0.00,0.00,62.15,35301.20,0.00,0.00,0.00),('1','152','757','252620',4820409,'2123','316',707396.15,707396.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','252620',4820410,'2124','316',556503.28,556503.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','252620',4820411,'2668','316',135761.61,135761.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','252620',4820412,'2828','316',86040044.25,86040044.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','252638',4820692,'2123','316',707396.15,708050.69,0.00,0.00,654.54,371778.72,0.00,0.00,0.00),('1','152','757','252638',4820693,'2124','316',556503.28,556944.36,0.00,0.00,441.08,250533.44,0.00,0.00,0.00),('1','152','757','252638',4820694,'2668','316',135761.61,135791.61,0.00,0.00,30.00,16320.00,0.00,0.00,0.00),('1','152','757','252638',4820695,'2828','316',86040044.25,86040377.70,0.00,0.00,333.45,189399.60,0.00,0.00,0.00),('1','152','757','252723',4822133,'2123','316',708050.69,709612.43,0.00,0.00,1561.74,887068.32,0.00,0.00,0.00),('1','152','757','252723',4822134,'2124','316',556944.36,557905.48,0.00,0.00,961.12,545916.16,0.00,0.00,0.00),('1','152','757','252723',4822135,'2668','316',135791.61,136134.41,0.00,0.00,342.80,186483.20,0.00,0.00,0.00),('1','152','757','252723',4822136,'2828','316',86040377.70,86040716.84,0.00,0.00,339.14,192631.52,0.00,0.00,0.00),('1','152','757','252960',4826054,'2123','316',709612.43,711217.38,0.00,0.00,1604.95,911611.60,0.00,0.00,0.00),('1','152','757','252960',4826055,'2124','316',557905.48,558818.74,0.00,0.00,913.26,518731.68,0.00,0.00,0.00),('1','152','757','252960',4826056,'2668','316',136134.41,137162.11,0.00,0.00,1027.70,559068.80,0.00,0.00,0.00),('1','152','757','252960',4826057,'2828','316',86040716.84,86041129.17,0.00,0.00,412.33,234203.44,0.00,0.00,0.00),('1','152','757','253218',4830312,'2123','316',711217.38,712722.29,0.00,0.00,1504.91,854788.88,0.00,0.00,0.00),('1','152','757','253218',4830313,'2124','316',558818.74,559837.79,0.00,0.00,1019.05,578820.40,0.00,0.00,0.00),('1','152','757','253218',4830314,'2668','316',137162.11,137960.66,0.00,0.00,798.55,434411.20,0.00,0.00,0.00),('1','152','757','253218',4830315,'2828','316',86041129.17,86041602.95,0.00,0.00,473.78,269107.04,0.00,0.00,0.00),('1','152','757','253466',4834669,'2123','316',712722.29,714093.57,0.00,0.00,1371.28,778887.04,0.00,0.00,0.00),('1','152','757','253466',4834670,'2124','316',559837.79,560779.61,0.00,0.00,941.82,534953.76,0.00,0.00,0.00),('1','152','757','253466',4834671,'2668','316',137960.66,139353.59,0.00,0.00,1392.93,757753.92,0.00,0.00,0.00),('1','152','757','253466',4834672,'2828','316',86041602.95,86041953.12,0.00,0.00,350.17,198896.56,0.00,0.00,0.00),('1','152','757','253701',4838653,'2123','316',714093.57,715752.11,0.00,0.00,1658.54,942050.72,0.00,0.00,0.00),('1','152','757','253701',4838654,'2124','316',560779.61,562021.00,0.00,0.00,1241.39,705109.52,0.00,0.00,0.00),('1','152','757','253701',4838655,'2668','316',139353.59,139828.57,0.00,0.00,474.98,258528.56,0.00,0.00,0.00),('1','152','757','253701',4838656,'2828','316',86041953.12,86042203.62,0.00,0.00,250.50,142284.00,0.00,0.00,0.00),('1','152','757','253956',4843058,'2123','316',715752.11,717213.21,0.00,0.00,1461.10,829904.80,0.00,0.00,0.00),('1','152','757','253956',4843059,'2124','316',562021.00,563373.64,0.00,0.00,1352.64,768299.52,0.00,0.00,0.00),('1','152','757','253956',4843060,'2668','316',139828.57,141099.10,0.00,0.00,1270.53,691189.44,0.00,0.00,0.00),('1','152','757','253956',4843061,'2828','316',86042203.62,86042942.16,0.00,0.00,738.54,419490.72,0.00,0.00,0.00),('1','152','757','254146',4846668,'2123','316',717213.21,717213.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254146',4846669,'2124','316',563373.64,563373.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254146',4846670,'2668','316',141099.10,141099.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254146',4846671,'2828','316',86042942.16,86042942.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254178',4847259,'2123','316',717213.21,719023.35,0.00,0.00,1810.14,1028159.52,0.00,0.00,0.00),('1','152','757','254178',4847260,'2124','316',563373.64,564391.09,0.00,0.00,1017.45,577911.60,0.00,0.00,0.00),('1','152','757','254178',4847261,'2668','316',141099.10,143520.70,0.00,0.00,2421.60,1317350.40,0.00,0.00,0.00),('1','152','757','254178',4847262,'2828','316',86042942.16,86043239.86,0.00,0.00,297.70,169093.60,0.00,0.00,0.00),('1','152','757','254456',4851776,'2123','316',719023.35,720385.31,0.00,0.00,1361.96,773593.28,0.00,0.00,0.00),('1','152','757','254456',4851777,'2124','316',564391.09,565751.58,0.00,0.00,1360.49,772758.32,0.00,0.00,0.00),('1','152','757','254456',4851778,'2668','316',143520.70,144311.57,0.00,0.00,790.87,430233.28,0.00,0.00,0.00),('1','152','757','254456',4851779,'2828','316',86043239.86,86043932.46,0.00,0.00,692.60,393396.80,0.00,0.00,0.00),('1','152','757','254695',4856037,'2123','316',720385.31,723922.52,0.00,0.00,3537.21,2007935.28,0.00,0.00,0.00),('1','152','757','254695',4856038,'2124','316',565751.58,565751.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254695',4856039,'2668','316',144311.57,145411.63,0.00,0.00,1100.06,598432.64,0.00,0.00,0.00),('1','152','757','254695',4856040,'2828','316',86043932.46,86043932.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','254962',4860478,'2123','316',721665.56,722530.43,0.00,0.00,864.87,491246.16,0.00,0.00,0.00),('1','152','757','254962',4860479,'2124','316',567072.23,568229.00,0.00,0.00,1156.77,657045.36,0.00,0.00,0.00),('1','152','757','254962',4860480,'2668','316',145461.17,145735.10,0.00,0.00,273.93,149017.92,0.00,0.00,0.00),('1','152','757','254962',4860481,'2828','316',86045734.00,86046770.83,0.00,0.00,1036.83,588919.44,0.00,0.00,0.00),('1','152','757','255189',4864479,'2123','316',722530.43,723633.59,0.00,0.00,1103.16,626594.88,0.00,0.00,0.00),('1','152','757','255189',4864480,'2124','316',568229.00,569153.35,0.00,0.00,924.35,525030.80,0.00,0.00,0.00),('1','152','757','255189',4864481,'2668','316',145735.10,146804.31,0.00,0.00,1069.21,581650.24,0.00,0.00,0.00),('1','152','757','255189',4864482,'2828','316',86046770.83,86047753.51,0.00,0.00,982.68,558162.24,0.00,0.00,0.00),('1','152','757','255453',4869043,'2123','316',723633.59,724281.76,0.00,0.00,648.17,368160.56,0.00,0.00,0.00),('1','152','757','255453',4869044,'2124','316',569153.35,569925.98,0.00,0.00,772.63,438853.84,0.00,0.00,0.00),('1','152','757','255453',4869045,'2668','316',146804.31,147201.31,0.00,0.00,397.00,215968.00,0.00,0.00,0.00),('1','152','757','255453',4869046,'2828','316',86047753.51,86048538.90,0.00,0.00,785.39,446101.52,0.00,0.00,0.00),('1','152','757','255629',4871800,'2123','316',724281.76,724281.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','255629',4871801,'2124','316',569925.98,569925.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','255629',4871802,'2668','316',147201.31,147201.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','255629',4871803,'2828','316',86048538.90,86048538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','255637',4871971,'2123','316',724281.76,724806.24,0.00,0.00,524.48,297904.64,0.00,0.00,0.00),('1','152','757','255637',4871972,'2124','316',569925.98,570541.50,0.00,0.00,615.52,349615.36,0.00,0.00,0.00),('1','152','757','255637',4871973,'2668','316',147201.31,147418.31,0.00,0.00,217.00,118048.00,0.00,0.00,0.00),('1','152','757','255637',4871974,'2828','316',86048538.90,86049022.17,0.00,0.00,483.27,274497.36,0.00,0.00,0.00),('1','152','757','255715',4873263,'2123','316',724806.24,725929.31,0.00,0.00,1123.07,637903.76,0.00,0.00,0.00),('1','152','757','255715',4873264,'2124','316',570541.50,571741.90,0.00,0.00,1200.40,681827.20,0.00,0.00,0.00),('1','152','757','255715',4873265,'2668','316',147418.31,148096.58,0.00,0.00,678.27,368978.88,0.00,0.00,0.00),('1','152','757','255715',4873266,'2828','316',86049022.17,86050300.47,0.00,0.00,1278.30,726074.40,0.00,0.00,0.00),('1','152','757','255945',4876994,'2123','316',725929.31,726900.23,0.00,0.00,970.92,551482.56,0.00,0.00,0.00),('1','152','757','255945',4876995,'2124','316',571741.90,572691.68,0.00,0.00,949.78,539475.04,0.00,0.00,0.00),('1','152','757','255945',4876996,'2668','316',148096.58,149415.94,0.00,0.00,1319.36,717731.84,0.00,0.00,0.00),('1','152','757','255945',4876997,'2828','316',86050300.47,86051441.77,0.00,0.00,1141.30,648258.40,0.00,0.00,0.00),('1','152','757','256204',4881192,'2123','316',726900.23,727944.14,0.00,0.00,1043.91,592940.88,0.00,0.00,0.00),('1','152','757','256204',4881193,'2124','316',572691.68,573613.72,0.00,0.00,922.04,523718.72,0.00,0.00,0.00),('1','152','757','256204',4881194,'2668','316',149415.94,150387.59,0.00,0.00,971.65,528577.60,0.00,0.00,0.00),('1','152','757','256204',4881195,'2828','316',86051441.77,86052464.29,0.00,0.00,1022.52,580791.36,0.00,0.00,0.00),('1','152','757','256477',4885952,'2123','316',727944.14,728937.21,0.00,0.00,993.07,564063.76,0.00,0.00,0.00),('1','152','757','256477',4885953,'2124','316',573613.72,574625.71,0.00,0.00,1011.99,574810.32,0.00,0.00,0.00),('1','152','757','256477',4885954,'2668','316',150387.59,150794.29,0.00,0.00,406.70,221244.80,0.00,0.00,0.00),('1','152','757','256477',4885955,'2828','316',86052464.29,86053581.28,0.00,0.00,1116.99,634450.32,0.00,0.00,0.00),('1','152','757','256709',4889820,'2123','316',728937.21,730078.15,0.00,0.00,1140.94,648053.92,0.00,0.00,0.00),('1','152','757','256709',4889821,'2124','316',574625.71,575731.12,0.00,0.00,1105.41,627872.88,0.00,0.00,0.00),('1','152','757','256709',4889822,'2668','316',150794.29,151374.63,0.00,0.00,580.34,315704.96,0.00,0.00,0.00),('1','152','757','256709',4889823,'2828','316',86053581.28,86054813.21,0.00,0.00,1231.93,699736.24,0.00,0.00,0.00),('1','152','757','256954',4894059,'2123','316',730078.15,730791.13,0.00,0.00,712.98,404972.64,0.00,0.00,0.00),('1','152','757','256954',4894060,'2124','316',575731.12,576703.98,0.00,0.00,972.86,552584.48,0.00,0.00,0.00),('1','152','757','256954',4894061,'2668','316',151374.63,151959.38,0.00,0.00,584.75,318104.00,0.00,0.00,0.00),('1','152','757','256954',4894062,'2828','316',86054813.21,86055520.69,0.00,0.00,707.48,401848.64,0.00,0.00,0.00),('1','152','757','257168',4897947,'2123','316',730791.13,730987.51,0.00,0.00,196.38,111543.84,0.00,0.00,0.00),('1','152','757','257168',4897948,'2124','316',576703.98,576939.07,0.00,0.00,235.09,133531.12,0.00,0.00,0.00),('1','152','757','257168',4897949,'2668','316',151959.38,151959.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257168',4897950,'2828','316',86055520.69,86055724.84,0.00,0.00,204.15,115957.20,0.00,0.00,0.00),('1','152','757','257248',4899235,'2123','316',730987.51,732194.66,0.00,0.00,1207.15,685661.20,0.00,0.00,0.00),('1','152','757','257248',4899236,'2124','316',576939.07,578135.89,0.00,0.00,1196.82,679793.76,0.00,0.00,0.00),('1','152','757','257248',4899237,'2668','316',151959.38,153058.11,0.00,0.00,1098.73,597709.12,0.00,0.00,0.00),('1','152','757','257248',4899238,'2828','316',86055724.84,86056842.22,0.00,0.00,1117.38,634671.84,0.00,0.00,0.00),('1','152','757','257476',4903416,'2123','316',732194.66,733643.92,0.00,0.00,1449.26,823179.68,0.00,0.00,0.00),('1','152','757','257476',4903417,'2124','316',578135.89,579565.29,0.00,0.00,1429.40,811899.20,0.00,0.00,0.00),('1','152','757','257476',4903418,'2668','316',153058.11,154748.18,0.00,0.00,1690.07,919398.08,0.00,0.00,0.00),('1','152','757','257476',4903419,'2828','316',86056842.22,86058156.62,0.00,0.00,1314.40,746579.20,0.00,0.00,0.00),('1','152','757','257477',4903420,'2123','316',733643.92,735162.83,0.00,0.00,1518.91,862740.88,0.00,0.00,0.00),('1','152','757','257477',4903421,'2124','316',579565.29,581128.71,0.00,0.00,1563.42,888022.56,0.00,0.00,0.00),('1','152','757','257477',4903422,'2668','316',154748.18,155507.27,0.00,0.00,759.09,412944.96,0.00,0.00,0.00),('1','152','757','257477',4903423,'2828','316',86058156.62,86059827.31,0.00,0.00,1670.69,948951.92,0.00,0.00,0.00),('1','152','757','257478',4903424,'2123','316',735162.83,736928.20,0.00,0.00,1765.37,1002730.16,0.00,0.00,0.00),('1','152','757','257478',4903425,'2124','316',581128.71,582714.23,0.00,0.00,1585.52,900575.36,0.00,0.00,0.00),('1','152','757','257478',4903426,'2668','316',155507.27,157123.17,0.00,0.00,1615.90,879049.60,0.00,0.00,0.00),('1','152','757','257478',4903427,'2828','316',86059827.31,86061156.91,0.00,0.00,1329.60,755212.80,0.00,0.00,0.00),('1','152','757','257479',4903428,'2123','316',736928.20,737321.95,0.00,0.00,393.75,223650.00,0.00,0.00,0.00),('1','152','757','257479',4903429,'2124','316',582714.23,583229.65,0.00,0.00,515.42,292758.56,0.00,0.00,0.00),('1','152','757','257479',4903430,'2668','316',157123.17,157249.73,0.00,0.00,126.56,68848.64,0.00,0.00,0.00),('1','152','757','257479',4903431,'2828','316',86061156.91,86061681.12,0.00,0.00,524.21,297751.28,0.00,0.00,0.00),('1','152','757','257480',4903432,'2123','316',737321.95,737321.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257480',4903433,'2124','316',583229.65,583229.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257480',4903434,'2668','316',157249.73,157249.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257480',4903435,'2828','316',86061681.12,86061681.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257481',4903436,'2123','316',737321.95,738119.38,0.00,0.00,797.43,452940.24,0.00,0.00,0.00),('1','152','757','257481',4903437,'2124','316',583229.65,584050.48,0.00,0.00,820.83,466231.44,0.00,0.00,0.00),('1','152','757','257481',4903438,'2668','316',157249.73,157946.79,0.00,0.00,697.06,379200.64,0.00,0.00,0.00),('1','152','757','257481',4903439,'2828','316',86061681.12,86062503.50,0.00,0.00,822.38,467111.84,0.00,0.00,0.00),('1','152','757','257482',4903440,'2123','316',738119.38,739683.54,0.00,0.00,1564.16,888442.88,0.00,0.00,0.00),('1','152','757','257482',4903441,'2124','316',584050.48,585674.68,0.00,0.00,1624.20,922245.60,0.00,0.00,0.00),('1','152','757','257482',4903442,'2668','316',157946.79,158800.83,0.00,0.00,854.04,464897.76,0.00,0.00,0.00),('1','152','757','257482',4903443,'2828','316',86062503.50,86063755.76,0.00,0.00,1252.26,711283.68,0.00,0.00,0.00),('1','152','757','257483',4903444,'2123','316',739683.54,741168.94,0.00,0.00,1485.40,843707.20,0.00,0.00,0.00),('1','152','757','257483',4903445,'2124','316',585674.68,587060.27,0.00,0.00,1385.59,787015.12,0.00,0.00,0.00),('1','152','757','257483',4903446,'2668','316',158800.83,159878.13,0.00,0.00,1077.30,586051.20,0.00,0.00,0.00),('1','152','757','257483',4903447,'2828','316',86063755.76,86064992.60,0.00,0.00,1236.84,702525.12,0.00,0.00,0.00),('1','152','757','257484',4903448,'2123','316',741168.94,742559.43,0.00,0.00,1390.49,789798.32,0.00,0.00,0.00),('1','152','757','257484',4903449,'2124','316',587060.27,588410.79,0.00,0.00,1350.52,767095.36,0.00,0.00,0.00),('1','152','757','257484',4903450,'2668','316',159878.13,161484.00,0.00,0.00,1605.87,873777.12,0.00,0.00,0.00),('1','152','757','257484',4903451,'2828','316',86064992.60,86066185.51,0.00,0.00,1192.91,677389.04,0.00,0.00,0.00),('1','152','757','257485',4903452,'2123','316',742559.43,744160.77,0.00,0.00,1601.34,909561.12,0.00,0.00,0.00),('1','152','757','257485',4903453,'2124','316',588410.79,589813.74,0.00,0.00,1402.95,796875.60,0.00,0.00,0.00),('1','152','757','257485',4903454,'2668','316',161484.00,162996.73,0.00,0.00,1512.73,822925.12,0.00,0.00,0.00),('1','152','757','257485',4903455,'2828','316',86066185.51,86067499.47,0.00,0.00,1313.96,746329.28,0.00,0.00,0.00),('1','152','757','257486',4903456,'2123','316',744160.77,744160.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257486',4903457,'2124','316',589813.74,589813.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257486',4903458,'2668','316',162996.73,162996.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257486',4903459,'2828','316',86067499.47,86067499.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257487',4903460,'2123','316',744160.77,745416.48,0.00,0.00,1255.71,706826.88,0.00,0.00,0.00),('1','152','757','257487',4903461,'2124','316',589813.74,590748.75,0.00,0.00,935.01,531085.68,0.00,0.00,0.00),('1','152','757','257487',4903462,'2668','316',162996.73,163295.96,0.00,0.00,299.23,162781.12,0.00,0.00,0.00),('1','152','757','257487',4903463,'2828','316',86067499.47,86068547.80,0.00,0.00,1048.33,601983.44,0.00,0.00,0.00),('1','152','757','257488',4903464,'2123','316',745416.48,746527.84,0.00,0.00,1111.36,631252.48,0.00,0.00,0.00),('1','152','757','257488',4903465,'2124','316',590748.75,591905.60,0.00,0.00,1156.85,657090.80,0.00,0.00,0.00),('1','152','757','257488',4903466,'2668','316',163295.96,163922.96,0.00,0.00,627.00,341088.00,0.00,0.00,0.00),('1','152','757','257488',4903467,'2828','316',86068547.80,86069751.60,0.00,0.00,1203.80,683758.40,0.00,0.00,0.00),('1','152','757','257489',4903468,'2123','316',746527.84,747707.86,0.00,0.00,1180.02,670251.36,0.00,0.00,0.00),('1','152','757','257489',4903469,'2124','316',591905.60,593087.51,0.00,0.00,1181.91,671324.88,0.00,0.00,0.00),('1','152','757','257489',4903470,'2668','316',163922.96,164564.12,0.00,0.00,641.16,348791.04,0.00,0.00,0.00),('1','152','757','257489',4903471,'2828','316',86069751.60,86070722.49,0.00,0.00,970.89,551465.52,0.00,0.00,0.00),('1','152','757','257490',4903472,'2123','316',747707.86,748600.27,0.00,0.00,892.41,506888.88,0.00,0.00,0.00),('1','152','757','257490',4903473,'2124','316',593087.51,593951.79,0.00,0.00,864.28,490911.04,0.00,0.00,0.00),('1','152','757','257490',4903474,'2668','316',164564.12,164971.92,0.00,0.00,407.80,221843.20,0.00,0.00,0.00),('1','152','757','257490',4903475,'2828','316',86070722.49,86071612.64,0.00,0.00,890.15,505605.20,0.00,0.00,0.00),('1','152','757','257491',4903476,'2123','316',748600.27,749695.66,0.00,0.00,1095.39,622181.52,0.00,0.00,0.00),('1','152','757','257491',4903477,'2124','316',593951.79,594948.41,0.00,0.00,996.62,566080.16,0.00,0.00,0.00),('1','152','757','257491',4903478,'2668','316',164971.92,165714.88,0.00,0.00,742.96,404204.08,0.00,0.00,0.00),('1','152','757','257491',4903479,'2828','316',86071612.64,86072584.83,0.00,0.00,972.19,552203.92,0.00,0.00,0.00),('1','152','757','257492',4903480,'2123','316',749695.66,750805.56,0.00,0.00,1109.90,630423.20,0.00,0.00,0.00),('1','152','757','257492',4903481,'2124','316',594948.41,596030.33,0.00,0.00,1081.92,614530.56,0.00,0.00,0.00),('1','152','757','257492',4903482,'2668','316',165714.88,167920.72,0.00,0.00,2205.84,1199976.96,0.00,0.00,0.00),('1','152','757','257492',4903483,'2828','316',86072584.83,86073849.19,0.00,0.00,1264.36,718156.48,0.00,0.00,0.00),('1','152','757','257493',4903484,'2123','316',750805.56,750890.05,0.00,0.00,84.49,47990.32,0.00,0.00,0.00),('1','152','757','257493',4903485,'2124','316',596030.33,596117.91,0.00,0.00,87.58,49745.44,0.00,0.00,0.00),('1','152','757','257493',4903486,'2668','316',167920.72,167920.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257493',4903487,'2828','316',86073849.19,86073934.55,0.00,0.00,85.36,48484.48,0.00,0.00,0.00),('1','152','757','257494',4903488,'2123','316',750890.05,750890.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257494',4903489,'2124','316',596117.91,596117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257494',4903490,'2668','316',167920.72,167920.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257494',4903491,'2828','316',86073934.55,86073934.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257495',4903492,'2123','316',750890.05,752040.42,0.00,0.00,1150.37,653410.16,0.00,0.00,0.00),('1','152','757','257495',4903493,'2124','316',596117.91,597095.63,0.00,0.00,977.72,555344.96,0.00,0.00,0.00),('1','152','757','257495',4903494,'2668','316',167920.72,168247.28,0.00,0.00,326.56,177648.64,0.00,0.00,0.00),('1','152','757','257495',4903495,'2828','316',86073934.55,86074850.50,0.00,0.00,915.95,520259.60,0.00,0.00,0.00),('1','152','757','257496',4903496,'2123','316',752040.42,752879.30,0.00,0.00,838.88,476483.84,0.00,0.00,0.00),('1','152','757','257496',4903497,'2124','316',597095.63,598059.36,0.00,0.00,963.73,547398.64,0.00,0.00,0.00),('1','152','757','257496',4903498,'2668','316',168247.28,169519.55,0.00,0.00,1272.27,692136.00,0.00,0.00,0.00),('1','152','757','257496',4903499,'2828','316',86074850.50,86075815.34,0.00,0.00,964.84,548029.12,0.00,0.00,0.00),('1','152','757','257497',4903500,'2123','316',752879.30,753958.83,0.00,0.00,1079.53,613173.04,0.00,0.00,0.00),('1','152','757','257497',4903501,'2124','316',598059.36,598935.61,0.00,0.00,876.25,497710.00,0.00,0.00,0.00),('1','152','757','257497',4903502,'2668','316',169519.55,169861.71,0.00,0.00,342.16,186282.88,0.00,0.00,0.00),('1','152','757','257497',4903503,'2828','316',86075815.34,86076694.08,0.00,0.00,878.74,499124.32,0.00,0.00,0.00),('1','152','757','257498',4903504,'2123','316',753958.83,754779.28,0.00,0.00,820.45,466015.60,0.00,0.00,0.00),('1','152','757','257498',4903505,'2124','316',598935.61,599971.02,0.00,0.00,1035.41,588112.88,0.00,0.00,0.00),('1','152','757','257498',4903506,'2668','316',169861.71,170498.51,0.00,0.00,636.80,346419.20,0.00,0.00,0.00),('1','152','757','257498',4903507,'2828','316',86076694.08,86077763.39,0.00,0.00,1069.31,607368.08,0.00,0.00,0.00),('1','152','757','257499',4903508,'2123','316',754779.28,755654.78,0.00,0.00,875.50,497284.00,0.00,0.00,0.00),('1','152','757','257499',4903509,'2124','316',599971.02,600975.78,0.00,0.00,1004.76,570703.68,0.00,0.00,0.00),('1','152','757','257499',4903510,'2668','316',170498.51,171026.15,0.00,0.00,527.64,287036.16,0.00,0.00,0.00),('1','152','757','257499',4903511,'2828','316',86077763.39,86078644.97,0.00,0.00,881.58,500737.44,0.00,0.00,0.00),('1','152','757','257500',4903512,'2123','316',755654.78,756590.77,0.00,0.00,935.99,531642.32,0.00,0.00,0.00),('1','152','757','257500',4903513,'2124','316',600975.78,601785.68,0.00,0.00,809.90,460023.20,0.00,0.00,0.00),('1','152','757','257500',4903514,'2668','316',171026.15,171663.20,0.00,0.00,637.05,346555.20,0.00,0.00,0.00),('1','152','757','257500',4903515,'2828','316',86078644.97,86079516.54,0.00,0.00,871.57,495051.76,0.00,0.00,0.00),('1','152','757','257501',4903516,'2123','316',756590.77,757436.09,0.00,0.00,845.32,480141.76,0.00,0.00,0.00),('1','152','757','257501',4903517,'2124','316',601785.68,602642.59,0.00,0.00,856.91,486724.88,0.00,0.00,0.00),('1','152','757','257501',4903518,'2668','316',171663.20,172729.17,0.00,0.00,1065.97,579961.60,0.00,0.00,0.00),('1','152','757','257501',4903519,'2828','316',86079516.54,86080075.75,0.00,0.00,559.21,317631.28,0.00,0.00,0.00),('1','152','757','257502',4903520,'2123','316',757436.09,757436.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257502',4903521,'2124','316',602642.59,602642.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257502',4903522,'2668','316',172729.17,172729.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257502',4903523,'2828','316',86080075.75,86080075.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257503',4903524,'2123','316',757436.09,757596.08,0.00,0.00,159.99,90874.32,0.00,0.00,0.00),('1','152','757','257503',4903525,'2124','316',602642.59,602876.38,0.00,0.00,233.79,132792.72,0.00,0.00,0.00),('1','152','757','257503',4903526,'2668','316',172729.17,172779.17,0.00,0.00,50.00,27200.00,0.00,0.00,0.00),('1','152','757','257503',4903527,'2828','316',86080075.75,86080301.99,0.00,0.00,226.24,128504.32,0.00,0.00,0.00),('1','152','757','257504',4903528,'2123','316',757596.08,758730.60,0.00,0.00,1134.52,644407.36,0.00,0.00,0.00),('1','152','757','257504',4903529,'2124','316',602876.38,603955.16,0.00,0.00,1078.78,612747.04,0.00,0.00,0.00),('1','152','757','257504',4903530,'2668','316',172779.17,172860.47,0.00,0.00,81.30,44227.20,0.00,0.00,0.00),('1','152','757','257504',4903531,'2828','316',86080301.99,86081294.52,0.00,0.00,992.53,563757.04,0.00,0.00,0.00),('1','152','757','257505',4903532,'2123','316',758730.60,759827.23,0.00,0.00,1096.63,622885.84,0.00,0.00,0.00),('1','152','757','257505',4903533,'2124','316',603955.16,605248.86,0.00,0.00,1293.70,734821.60,0.00,0.00,0.00),('1','152','757','257505',4903534,'2668','316',172860.47,173014.48,0.00,0.00,154.01,83781.44,0.00,0.00,0.00),('1','152','757','257505',4903535,'2828','316',86081294.52,86082252.27,0.00,0.00,957.75,544002.00,0.00,0.00,0.00),('1','152','757','257506',4903536,'2123','316',759827.23,760699.42,0.00,0.00,872.19,495403.92,0.00,0.00,0.00),('1','152','757','257506',4903537,'2124','316',605248.86,606105.88,0.00,0.00,857.02,486787.36,0.00,0.00,0.00),('1','152','757','257506',4903538,'2668','316',173014.48,174239.30,0.00,0.00,1224.82,666302.08,0.00,0.00,0.00),('1','152','757','257506',4903539,'2828','316',86082252.27,86083350.82,0.00,0.00,1098.55,623976.40,0.00,0.00,0.00),('1','152','757','257507',4903540,'2123','316',760699.42,761765.18,0.00,0.00,1065.76,605351.68,0.00,0.00,0.00),('1','152','757','257507',4903541,'2124','316',606105.88,607173.38,0.00,0.00,1067.50,606340.00,0.00,0.00,0.00),('1','152','757','257507',4903542,'2668','316',174239.30,175403.98,0.00,0.00,1164.68,633585.92,0.00,0.00,0.00),('1','152','757','257507',4903543,'2828','316',86083350.82,86084267.87,0.00,0.00,917.05,520884.40,0.00,0.00,0.00),('1','152','757','257508',4903544,'2123','316',761765.18,762421.06,0.00,0.00,655.88,372539.84,0.00,0.00,0.00),('1','152','757','257508',4903545,'2124','316',607173.38,608277.02,0.00,0.00,1103.64,626867.52,0.00,0.00,0.00),('1','152','757','257508',4903546,'2668','316',175403.98,175613.96,0.00,0.00,209.98,114229.12,0.00,0.00,0.00),('1','152','757','257508',4903547,'2828','316',86084267.87,86085109.92,0.00,0.00,842.05,478284.40,0.00,0.00,0.00),('1','152','757','257509',4903548,'2123','316',762421.06,763524.64,0.00,0.00,1103.58,626833.44,0.00,0.00,0.00),('1','152','757','257509',4903549,'2124','316',608277.02,609100.17,0.00,0.00,823.15,467549.20,0.00,0.00,0.00),('1','152','757','257509',4903550,'2668','316',175613.96,175797.96,0.00,0.00,184.00,100096.00,0.00,0.00,0.00),('1','152','757','257509',4903551,'2828','316',86085109.92,86086189.22,0.00,0.00,1079.30,613042.40,0.00,0.00,0.00),('1','152','757','257510',4903552,'2123','316',763524.64,763921.65,0.00,0.00,397.01,225501.68,0.00,0.00,0.00),('1','152','757','257510',4903553,'2124','316',609100.17,609635.52,0.00,0.00,535.35,304078.80,0.00,0.00,0.00),('1','152','757','257510',4903554,'2668','316',175797.96,176938.30,0.00,0.00,1140.34,620344.96,0.00,0.00,0.00),('1','152','757','257510',4903555,'2828','316',86086189.22,86086617.82,0.00,0.00,428.60,243444.80,0.00,0.00,0.00),('1','152','757','257511',4903556,'2123','316',763921.65,763921.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257511',4903557,'2124','316',609635.52,609635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257511',4903558,'2668','316',176938.30,176938.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257511',4903559,'2828','316',86086617.82,86086617.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257512',4903560,'2123','316',763921.65,764314.51,0.00,0.00,392.86,223144.48,0.00,0.00,0.00),('1','152','757','257512',4903561,'2124','316',609635.52,610105.66,0.00,0.00,470.14,267039.52,0.00,0.00,0.00),('1','152','757','257512',4903562,'2668','316',176938.30,177326.86,0.00,0.00,388.56,211376.64,0.00,0.00,0.00),('1','152','757','257512',4903563,'2828','316',86086617.82,86087119.95,0.00,0.00,502.13,285209.84,0.00,0.00,0.00),('1','152','757','257513',4903564,'2123','316',764314.51,765415.53,0.00,0.00,1101.02,624711.36,0.00,0.00,0.00),('1','152','757','257513',4903565,'2124','316',610105.66,611212.96,0.00,0.00,1107.30,628946.40,0.00,0.00,0.00),('1','152','757','257513',4903566,'2668','316',177326.86,178029.61,0.00,0.00,702.75,382296.00,0.00,0.00,0.00),('1','152','757','257513',4903567,'2828','316',86087119.95,86088319.78,0.00,0.00,1199.83,681503.44,0.00,0.00,0.00),('1','152','757','257514',4903568,'2123','316',765415.53,766304.56,0.00,0.00,889.03,504969.04,0.00,0.00,0.00),('1','152','757','257514',4903569,'2124','316',611212.96,612098.50,0.00,0.00,885.54,502986.72,0.00,0.00,0.00),('1','152','757','257514',4903570,'2668','316',178029.61,178739.37,0.00,0.00,709.76,386109.44,0.00,0.00,0.00),('1','152','757','257514',4903571,'2828','316',86088319.78,86089555.88,0.00,0.00,1236.10,702104.80,0.00,0.00,0.00),('1','152','757','257515',4903572,'2123','316',766304.56,767673.42,0.00,0.00,1368.86,777512.48,0.00,0.00,0.00),('1','152','757','257515',4903573,'2124','316',612098.50,613331.78,0.00,0.00,1233.28,700503.04,0.00,0.00,0.00),('1','152','757','257515',4903574,'2668','316',178739.37,179973.47,0.00,0.00,1234.10,671350.40,0.00,0.00,0.00),('1','152','757','257515',4903575,'2828','316',86089555.88,86090350.59,0.00,0.00,794.71,451395.28,0.00,0.00,0.00),('1','152','757','257516',4903576,'2123','316',767673.42,768706.29,0.00,0.00,1032.87,586670.16,0.00,0.00,0.00),('1','152','757','257516',4903577,'2124','316',613331.78,614301.49,0.00,0.00,969.71,550795.28,0.00,0.00,0.00),('1','152','757','257516',4903578,'2668','316',179973.47,181023.16,0.00,0.00,1049.69,571031.36,0.00,0.00,0.00),('1','152','757','257516',4903579,'2828','316',86090350.59,86091660.41,0.00,0.00,1309.82,743977.76,0.00,0.00,0.00),('1','152','757','257517',4903580,'2123','316',768706.29,769952.82,0.00,0.00,1246.53,708029.04,0.00,0.00,0.00),('1','152','757','257517',4903581,'2124','316',614301.49,615123.49,0.00,0.00,822.00,466896.00,0.00,0.00,0.00),('1','152','757','257517',4903582,'2668','316',181023.16,181317.75,0.00,0.00,294.59,160256.96,0.00,0.00,0.00),('1','152','757','257517',4903583,'2828','316',86091660.41,86093083.97,0.00,0.00,1423.56,808582.08,0.00,0.00,0.00),('1','152','757','257518',4903584,'2123','316',769952.82,770334.37,0.00,0.00,381.55,216720.40,0.00,0.00,0.00),('1','152','757','257518',4903585,'2124','316',615123.49,615427.44,0.00,0.00,303.95,172643.60,0.00,0.00,0.00),('1','152','757','257518',4903586,'2668','316',181317.75,181838.15,0.00,0.00,520.40,283097.60,0.00,0.00,0.00),('1','152','757','257518',4903587,'2828','316',86093083.97,86093482.96,0.00,0.00,398.99,226626.32,0.00,0.00,0.00),('1','152','757','257519',4903588,'2123','316',770334.37,770334.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257519',4903589,'2124','316',615427.44,615427.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257519',4903590,'2668','316',181838.15,181838.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257519',4903591,'2828','316',86093482.96,86093482.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257520',4903592,'2123','316',770334.37,771323.94,0.00,0.00,989.57,562075.76,0.00,0.00,0.00),('1','152','757','257520',4903593,'2124','316',615427.44,616184.36,0.00,0.00,756.92,429930.56,0.00,0.00,0.00),('1','152','757','257520',4903594,'2668','316',181838.15,182033.00,0.00,0.00,194.85,105998.40,0.00,0.00,0.00),('1','152','757','257520',4903595,'2828','316',86093482.96,86094358.75,0.00,0.00,875.79,497448.72,0.00,0.00,0.00),('1','152','757','257521',4903596,'2123','316',771323.94,772572.89,0.00,0.00,1248.95,709298.00,0.00,0.00,0.00),('1','152','757','257521',4903597,'2124','316',616184.36,617278.92,0.00,0.00,1094.56,621710.08,0.00,0.00,0.00),('1','152','757','257521',4903598,'2668','316',182033.00,182341.00,0.00,0.00,308.00,167657.60,0.00,0.00,0.00),('1','152','757','257521',4903599,'2828','316',86094358.75,86095521.12,0.00,0.00,1162.37,660226.16,0.00,0.00,0.00),('1','152','757','257522',4903600,'2123','316',772572.89,773958.68,0.00,0.00,1385.79,787128.72,0.00,0.00,0.00),('1','152','757','257522',4903601,'2124','316',617278.92,618531.61,0.00,0.00,1252.69,711527.92,0.00,0.00,0.00),('1','152','757','257522',4903602,'2668','316',182341.00,183008.33,0.00,0.00,667.33,363027.52,0.00,0.00,0.00),('1','152','757','257522',4903603,'2828','316',86095521.12,86097168.58,0.00,0.00,1647.46,935757.28,0.00,0.00,0.00),('1','152','757','257523',4903604,'2123','316',773958.68,775237.62,0.00,0.00,1278.94,726437.92,0.00,0.00,0.00),('1','152','757','257523',4903605,'2124','316',618531.61,619739.16,0.00,0.00,1207.55,687120.40,0.00,0.00,0.00),('1','152','757','257523',4903606,'2668','316',183008.33,184630.88,0.00,0.00,1622.55,882667.20,0.00,0.00,0.00),('1','152','757','257523',4903607,'2828','316',86097168.58,86098239.66,0.00,0.00,1071.08,614905.44,0.00,0.00,0.00),('1','152','757','257524',4903608,'2123','316',775237.62,776140.59,0.00,0.00,902.97,512886.96,0.00,0.00,0.00),('1','152','757','257524',4903609,'2124','316',619739.16,620717.88,0.00,0.00,978.72,555912.96,0.00,0.00,0.00),('1','152','757','257524',4903610,'2668','316',184630.88,185355.84,0.00,0.00,724.96,394378.24,0.00,0.00,0.00),('1','152','757','257524',4903611,'2828','316',86098239.66,86099419.66,0.00,0.00,1180.00,670240.00,0.00,0.00,0.00),('1','152','757','257525',4903612,'2123','316',776140.59,777060.10,0.00,0.00,919.51,588486.40,0.00,0.00,0.00),('1','152','757','257525',4903613,'2124','316',620717.88,621646.82,0.00,0.00,928.94,594521.60,0.00,0.00,0.00),('1','152','757','257525',4903614,'2668','316',185355.84,185637.82,0.00,0.00,281.98,174827.60,0.00,0.00,0.00),('1','152','757','257525',4903615,'2828','316',86099419.66,86100300.59,0.00,0.00,880.93,563795.20,0.00,0.00,0.00),('1','152','757','257526',4903616,'2123','316',777060.10,777157.18,0.00,0.00,97.08,62131.20,0.00,0.00,0.00),('1','152','757','257526',4903617,'2124','316',621646.82,621735.21,0.00,0.00,88.39,56569.60,0.00,0.00,0.00),('1','152','757','257526',4903618,'2668','316',185637.82,185705.29,0.00,0.00,67.47,41831.40,0.00,0.00,0.00),('1','152','757','257526',4903619,'2828','316',86100300.59,86100420.74,0.00,0.00,120.15,76896.00,0.00,0.00,0.00),('1','152','757','257527',4903620,'2123','316',777157.18,777157.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257527',4903621,'2124','316',621735.21,621735.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257527',4903622,'2668','316',185705.29,185705.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257527',4903623,'2828','316',86100420.74,86100420.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257528',4903624,'2123','316',777157.18,777871.93,0.00,0.00,714.75,457440.00,0.00,0.00,0.00),('1','152','757','257528',4903625,'2124','316',621735.21,622402.23,0.00,0.00,667.02,426892.80,0.00,0.00,0.00),('1','152','757','257528',4903626,'2668','316',185705.29,186001.82,0.00,0.00,296.53,183848.60,0.00,0.00,0.00),('1','152','757','257528',4903627,'2828','316',86100420.74,86101349.89,0.00,0.00,929.15,594656.00,0.00,0.00,0.00),('1','152','757','257529',4903628,'2123','316',777871.93,778794.92,0.00,0.00,922.99,590713.60,0.00,0.00,0.00),('1','152','757','257529',4903629,'2124','316',622402.23,623135.74,0.00,0.00,733.51,469446.40,0.00,0.00,0.00),('1','152','757','257529',4903630,'2668','316',186001.82,186551.42,0.00,0.00,549.60,340752.00,0.00,0.00,0.00),('1','152','757','257529',4903631,'2828','316',86101349.89,86102022.91,0.00,0.00,673.02,430732.80,0.00,0.00,0.00),('1','152','757','257530',4903632,'2123','316',778794.92,779590.92,0.00,0.00,796.00,509440.00,0.00,0.00,0.00),('1','152','757','257530',4903633,'2124','316',623135.74,623908.17,0.00,0.00,772.43,494355.20,0.00,0.00,0.00),('1','152','757','257530',4903634,'2668','316',186551.42,187171.92,0.00,0.00,620.50,384710.00,0.00,0.00,0.00),('1','152','757','257530',4903635,'2828','316',86102022.91,86103289.27,0.00,0.00,1266.36,810470.40,0.00,0.00,0.00),('1','152','757','257531',4903636,'2123','316',779590.92,780560.91,0.00,0.00,969.99,620793.60,0.00,0.00,0.00),('1','152','757','257531',4903637,'2124','316',623908.17,624718.18,0.00,0.00,810.01,518406.40,0.00,0.00,0.00),('1','152','757','257531',4903638,'2668','316',187171.92,187500.40,0.00,0.00,328.48,203657.60,0.00,0.00,0.00),('1','152','757','257531',4903639,'2828','316',86103289.27,86104656.50,0.00,0.00,1367.23,875027.20,0.00,0.00,0.00),('1','152','757','257532',4903640,'2123','316',780560.91,781419.33,0.00,0.00,858.42,549388.80,0.00,0.00,0.00),('1','152','757','257532',4903641,'2124','316',624718.18,625569.03,0.00,0.00,850.85,544544.00,0.00,0.00,0.00),('1','152','757','257532',4903642,'2668','316',187500.40,188520.82,0.00,0.00,1020.42,632769.80,0.00,0.00,0.00),('1','152','757','257532',4903643,'2828','316',86104656.50,86105641.55,0.00,0.00,985.05,630432.00,0.00,0.00,0.00),('1','152','757','257533',4903644,'2123','316',781419.33,782488.02,0.00,0.00,1068.69,726709.20,0.00,0.00,0.00),('1','152','757','257533',4903645,'2124','316',625569.03,626562.16,0.00,0.00,993.13,675328.40,0.00,0.00,0.00),('1','152','757','257533',4903646,'2668','316',188520.82,188956.44,0.00,0.00,435.62,278796.80,0.00,0.00,0.00),('1','152','757','257533',4903647,'2828','316',86105641.55,86106451.09,0.00,0.00,809.54,550487.20,0.00,0.00,0.00),('1','152','757','257534',4903648,'2123','316',782488.02,783498.03,0.00,0.00,1010.01,686806.80,0.00,0.00,0.00),('1','152','757','257534',4903649,'2124','316',626562.16,627458.25,0.00,0.00,896.09,609341.20,0.00,0.00,0.00),('1','152','757','257534',4903650,'2668','316',188956.44,189288.13,0.00,0.00,331.69,212281.60,0.00,0.00,0.00),('1','152','757','257534',4903651,'2828','316',86106451.09,86107226.45,0.00,0.00,775.36,527244.80,0.00,0.00,0.00),('1','152','757','257535',4903652,'2123','316',783498.03,784008.03,0.00,0.00,510.00,346800.00,0.00,0.00,0.00),('1','152','757','257535',4903653,'2124','316',627458.25,627998.91,0.00,0.00,540.66,367648.80,0.00,0.00,0.00),('1','152','757','257535',4903654,'2668','316',189288.13,189421.02,0.00,0.00,132.89,85049.60,0.00,0.00,0.00),('1','152','757','257535',4903655,'2828','316',86107226.45,86107607.85,0.00,0.00,381.40,259352.00,0.00,0.00,0.00),('1','152','757','257536',4903656,'2123','316',784008.03,784008.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257536',4903657,'2124','316',627998.91,627998.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257536',4903658,'2668','316',189421.02,189421.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257536',4903659,'2828','316',86107607.85,86107607.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257537',4903660,'2123','316',784008.03,784328.37,0.00,0.00,320.34,217831.20,0.00,0.00,0.00),('1','152','757','257537',4903661,'2124','316',627998.91,628392.60,0.00,0.00,393.69,268029.20,0.00,0.00,0.00),('1','152','757','257537',4903662,'2668','316',189421.02,189444.71,0.00,0.00,23.69,15161.60,0.00,0.00,0.00),('1','152','757','257537',4903663,'2828','316',86107607.85,86107978.60,0.00,0.00,370.75,252110.00,0.00,0.00,0.00),('1','152','757','257538',4903664,'2123','316',784328.37,785189.30,0.00,0.00,860.93,550995.20,0.00,0.00,0.00),('1','152','757','257538',4903665,'2124','316',628392.60,629159.10,0.00,0.00,766.50,490560.00,0.00,0.00,0.00),('1','152','757','257538',4903666,'2668','316',189444.71,189736.21,0.00,0.00,291.50,179564.00,0.00,0.00,0.00),('1','152','757','257538',4903667,'2828','316',86107978.60,86109178.63,0.00,0.00,1200.03,768019.20,0.00,0.00,0.00),('1','152','757','257539',4903668,'2123','316',785189.30,786462.01,0.00,0.00,1272.71,814534.40,0.00,0.00,0.00),('1','152','757','257539',4903669,'2124','316',629159.10,630271.40,0.00,0.00,1112.30,711872.00,0.00,0.00,0.00),('1','152','757','257539',4903670,'2668','316',189736.21,190181.46,0.00,0.00,445.25,274274.00,0.00,0.00,0.00),('1','152','757','257539',4903671,'2828','316',86109178.63,86110269.02,0.00,0.00,1090.39,697849.60,0.00,0.00,0.00),('1','152','757','257540',4903672,'2123','316',786462.01,787571.98,0.00,0.00,1109.97,710380.80,0.00,0.00,0.00),('1','152','757','257540',4903673,'2124','316',630271.40,631203.33,0.00,0.00,931.93,596435.20,0.00,0.00,0.00),('1','152','757','257540',4903674,'2668','316',190181.46,190623.05,0.00,0.00,441.59,272319.44,0.00,0.00,0.00),('1','152','757','257540',4903675,'2828','316',86110269.02,86111315.38,0.00,0.00,1046.36,669670.40,0.00,0.00,0.00),('1','152','757','257541',4903676,'2123','316',787571.98,788486.85,0.00,0.00,914.87,585516.80,0.00,0.00,0.00),('1','152','757','257541',4903677,'2124','316',631203.33,632212.43,0.00,0.00,1009.10,645824.00,0.00,0.00,0.00),('1','152','757','257541',4903678,'2668','316',190623.05,190915.30,0.00,0.00,292.25,180026.00,0.00,0.00,0.00),('1','152','757','257541',4903679,'2828','316',86111315.38,86112095.30,0.00,0.00,779.92,499148.80,0.00,0.00,0.00),('1','152','757','257542',4903680,'2123','316',788486.85,789403.48,0.00,0.00,916.63,586643.20,0.00,0.00,0.00),('1','152','757','257542',4903681,'2124','316',632212.43,633015.36,0.00,0.00,802.93,513875.20,0.00,0.00,0.00),('1','152','757','257542',4903682,'2668','316',190915.30,191364.23,0.00,0.00,448.93,276540.88,0.00,0.00,0.00),('1','152','757','257542',4903683,'2828','316',86112095.30,86113004.93,0.00,0.00,909.63,582163.20,0.00,0.00,0.00),('1','152','757','257543',4903684,'2123','316',789403.48,790261.53,0.00,0.00,858.05,549152.00,0.00,0.00,0.00),('1','152','757','257543',4903685,'2124','316',633015.36,633904.39,0.00,0.00,889.03,568979.20,0.00,0.00,0.00),('1','152','757','257543',4903686,'2668','316',191364.23,192088.21,0.00,0.00,723.98,445971.68,0.00,0.00,0.00),('1','152','757','257543',4903687,'2828','316',86113004.93,86113901.89,0.00,0.00,896.96,574054.40,0.00,0.00,0.00),('1','152','757','257544',4903688,'2123','316',790261.53,791115.89,0.00,0.00,854.36,546790.40,0.00,0.00,0.00),('1','152','757','257544',4903689,'2124','316',633904.39,634939.54,0.00,0.00,1035.15,662496.00,0.00,0.00,0.00),('1','152','757','257544',4903690,'2668','316',192088.21,192492.43,0.00,0.00,404.22,248999.52,0.00,0.00,0.00),('1','152','757','257544',4903691,'2828','316',86113901.89,86114716.84,0.00,0.00,814.95,521568.00,0.00,0.00,0.00),('1','152','757','257545',4903692,'2123','316',791115.89,791420.81,0.00,0.00,304.92,195148.80,0.00,0.00,0.00),('1','152','757','257545',4903693,'2124','316',634939.54,635209.85,0.00,0.00,270.31,172998.40,0.00,0.00,0.00),('1','152','757','257545',4903694,'2668','316',192492.43,192492.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257545',4903695,'2828','316',86114716.84,86114859.72,0.00,0.00,142.88,91443.20,0.00,0.00,0.00),('1','152','757','257546',4903696,'2123','316',791420.81,792001.49,0.00,0.00,580.68,371635.20,0.00,0.00,0.00),('1','152','757','257546',4903697,'2124','316',635209.85,635771.29,0.00,0.00,561.44,359321.60,0.00,0.00,0.00),('1','152','757','257546',4903698,'2668','316',192492.43,193353.71,0.00,0.00,861.28,530548.48,0.00,0.00,0.00),('1','152','757','257546',4903699,'2828','316',86114859.72,86115418.66,0.00,0.00,558.94,357721.60,0.00,0.00,0.00),('1','152','757','257547',4903700,'2123','316',792001.49,792825.27,0.00,0.00,823.78,527219.20,0.00,0.00,0.00),('1','152','757','257547',4903701,'2124','316',635771.29,636931.23,0.00,0.00,1159.94,742361.60,0.00,0.00,0.00),('1','152','757','257547',4903702,'2668','316',193353.71,193885.57,0.00,0.00,531.86,327625.76,0.00,0.00,0.00),('1','152','757','257547',4903703,'2828','316',86115418.66,86116446.53,0.00,0.00,1027.87,657836.80,0.00,0.00,0.00),('1','152','757','257548',4903704,'2123','316',792825.27,794059.54,0.00,0.00,1234.27,839303.60,0.00,0.00,0.00),('1','152','757','257548',4903705,'2124','316',636931.23,637849.99,0.00,0.00,918.76,624756.80,0.00,0.00,0.00),('1','152','757','257548',4903706,'2668','316',193885.57,194121.86,0.00,0.00,236.29,151698.18,0.00,0.00,0.00),('1','152','757','257548',4903707,'2828','316',86116446.53,86117676.30,0.00,0.00,1229.77,836243.60,0.00,0.00,0.00),('1','152','757','257549',4903708,'2123','316',794059.54,795158.42,0.00,0.00,1098.88,747238.40,0.00,0.00,0.00),('1','152','757','257549',4903709,'2124','316',637849.99,638726.25,0.00,0.00,876.26,595856.80,0.00,0.00,0.00),('1','152','757','257549',4903710,'2668','316',194121.86,194420.19,0.00,0.00,298.33,191527.86,0.00,0.00,0.00),('1','152','757','257549',4903711,'2828','316',86117676.30,86118594.42,0.00,0.00,918.12,624321.60,0.00,0.00,0.00),('1','152','757','257550',4903712,'2123','316',795158.42,796824.72,0.00,0.00,1666.30,1133084.00,0.00,0.00,0.00),('1','152','757','257550',4903713,'2124','316',638726.25,639471.39,0.00,0.00,745.14,506695.20,0.00,0.00,0.00),('1','152','757','257550',4903714,'2668','316',194420.19,194514.45,0.00,0.00,94.26,60682.50,0.00,0.00,0.00),('1','152','757','257550',4903715,'2828','316',86118594.42,86119329.75,0.00,0.00,735.33,500024.40,0.00,0.00,0.00),('1','152','757','257551',4903716,'2123','316',796824.72,798026.19,0.00,0.00,1201.47,816999.60,0.00,0.00,0.00),('1','152','757','257551',4903717,'2124','316',639471.39,640801.00,0.00,0.00,1329.61,904134.80,0.00,0.00,0.00),('1','152','757','257551',4903718,'2668','316',194514.45,195294.51,0.00,0.00,780.06,500798.52,0.00,0.00,0.00),('1','152','757','257551',4903719,'2828','316',86119329.75,86120472.15,0.00,0.00,1142.40,776832.00,0.00,0.00,0.00),('1','152','757','257552',4903720,'2123','316',798026.19,799060.16,0.00,0.00,1033.97,661740.80,0.00,0.00,0.00),('1','152','757','257552',4903721,'2124','316',640801.00,641675.61,0.00,0.00,874.61,559750.40,0.00,0.00,0.00),('1','152','757','257552',4903722,'2668','316',195294.51,196083.53,0.00,0.00,789.02,489192.40,0.00,0.00,0.00),('1','152','757','257552',4903723,'2828','316',86120472.15,86121733.59,0.00,0.00,1261.44,807321.60,0.00,0.00,0.00),('1','152','757','257553',4903724,'2123','316',799060.16,799060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257553',4903725,'2124','316',641675.61,641675.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257553',4903726,'2668','316',196083.53,196083.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257553',4903727,'2828','316',86121733.59,86121733.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257554',4903728,'2123','316',799060.16,799417.26,0.00,0.00,357.10,228544.00,0.00,0.00,0.00),('1','152','757','257554',4903729,'2124','316',641675.61,642152.95,0.00,0.00,477.34,305497.60,0.00,0.00,0.00),('1','152','757','257554',4903730,'2668','316',196083.53,196247.83,0.00,0.00,164.30,101866.00,0.00,0.00,0.00),('1','152','757','257554',4903731,'2828','316',86121733.59,86122167.89,0.00,0.00,434.30,277952.00,0.00,0.00,0.00),('1','152','757','257555',4903732,'2123','316',799417.26,801499.63,0.00,0.00,2082.37,1332716.80,0.00,0.00,0.00),('1','152','757','257555',4903733,'2124','316',642152.95,644677.19,0.00,0.00,2524.24,1615513.60,0.00,0.00,0.00),('1','152','757','257555',4903734,'2668','316',196247.83,196853.63,0.00,0.00,605.80,375596.00,0.00,0.00,0.00),('1','152','757','257555',4903735,'2828','316',86122167.89,86124081.93,0.00,0.00,1914.04,1224985.60,0.00,0.00,0.00),('1','152','757','257556',4903736,'2123','316',801499.63,803638.39,0.00,0.00,2138.76,1368806.40,0.00,0.00,0.00),('1','152','757','257556',4903737,'2124','316',644677.19,647011.09,0.00,0.00,2333.90,1493696.00,0.00,0.00,0.00),('1','152','757','257556',4903738,'2668','316',196853.63,198627.28,0.00,0.00,1773.65,1099663.00,0.00,0.00,0.00),('1','152','757','257556',4903739,'2828','316',86124081.93,86125969.18,0.00,0.00,1887.25,1207840.00,0.00,0.00,0.00),('1','152','757','257557',4903740,'2123','316',803638.39,805035.55,0.00,0.00,1397.16,894182.40,0.00,0.00,0.00),('1','152','757','257557',4903741,'2124','316',647011.09,648525.22,0.00,0.00,1514.13,969043.20,0.00,0.00,0.00),('1','152','757','257557',4903742,'2668','316',198627.28,201785.49,0.00,0.00,3158.21,1958212.00,0.00,0.00,0.00),('1','152','757','257557',4903743,'2828','316',86125969.18,86127237.27,0.00,0.00,1268.09,811577.60,0.00,0.00,0.00),('1','152','757','257558',4903744,'2123','316',805035.55,805035.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257558',4903745,'2124','316',648525.22,648525.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257558',4903746,'2668','316',201785.49,201785.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257558',4903747,'2828','316',86127237.27,86127237.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257559',4903748,'2123','316',805035.55,805280.80,0.00,0.00,245.25,156960.00,0.00,0.00,0.00),('1','152','757','257559',4903749,'2124','316',648525.22,648847.86,0.00,0.00,322.64,206489.60,0.00,0.00,0.00),('1','152','757','257559',4903750,'2668','316',201785.49,201921.99,0.00,0.00,136.50,84630.00,0.00,0.00,0.00),('1','152','757','257559',4903751,'2828','316',86127237.27,86127449.79,0.00,0.00,212.52,136012.80,0.00,0.00,0.00),('1','152','757','257560',4903752,'2123','316',805280.80,806876.85,0.00,0.00,1596.05,1021472.00,0.00,0.00,0.00),('1','152','757','257560',4903753,'2124','316',648847.86,649875.20,0.00,0.00,1027.34,657497.60,0.00,0.00,0.00),('1','152','757','257560',4903754,'2668','316',201921.99,203016.01,0.00,0.00,1094.02,678292.40,0.00,0.00,0.00),('1','152','757','257560',4903755,'2828','316',86127449.79,86129207.83,0.00,0.00,1758.04,1125145.60,0.00,0.00,0.00),('1','152','757','257561',4903756,'2123','316',806876.85,807977.24,0.00,0.00,1100.39,704249.60,0.00,0.00,0.00),('1','152','757','257561',4903757,'2124','316',649875.20,650951.01,0.00,0.00,1075.81,688518.40,0.00,0.00,0.00),('1','152','757','257561',4903758,'2668','316',203016.01,203764.18,0.00,0.00,748.17,463957.20,0.00,0.00,0.00),('1','152','757','257561',4903759,'2828','316',86129207.83,86130319.91,0.00,0.00,1112.08,711731.20,0.00,0.00,0.00),('1','152','757','257562',4903760,'2123','316',807977.24,808994.66,0.00,0.00,1017.42,651148.80,0.00,0.00,0.00),('1','152','757','257562',4903761,'2124','316',650951.01,651843.22,0.00,0.00,892.21,571014.40,0.00,0.00,0.00),('1','152','757','257562',4903762,'2668','316',203764.18,204655.13,0.00,0.00,890.95,552389.00,0.00,0.00,0.00),('1','152','757','257562',4903763,'2828','316',86130319.91,86131266.25,0.00,0.00,946.34,605657.60,0.00,0.00,0.00),('1','152','757','257563',4903764,'2123','316',808994.66,809384.08,0.00,0.00,389.42,249228.80,0.00,0.00,0.00),('1','152','757','257563',4903765,'2124','316',651843.22,652249.18,0.00,0.00,405.96,259814.40,0.00,0.00,0.00),('1','152','757','257563',4903766,'2668','316',204655.13,205137.78,0.00,0.00,482.65,299243.00,0.00,0.00,0.00),('1','152','757','257563',4903767,'2828','316',86131266.25,86131718.74,0.00,0.00,452.49,289593.60,0.00,0.00,0.00),('1','152','757','257564',4903768,'2123','316',809384.08,809384.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257564',4903769,'2124','316',652249.18,652249.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257564',4903770,'2668','316',205137.78,205137.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257564',4903771,'2828','316',86131718.74,86131718.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257565',4903772,'2123','316',809384.08,809384.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257565',4903773,'2124','316',652249.18,652249.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257565',4903774,'2668','316',205137.78,205137.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257565',4903775,'2828','316',86131718.74,86131718.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257566',4903776,'2123','316',809384.08,809785.40,0.00,0.00,401.32,256844.80,0.00,0.00,0.00),('1','152','757','257566',4903777,'2124','316',652249.18,652736.58,0.00,0.00,487.40,311936.00,0.00,0.00,0.00),('1','152','757','257566',4903778,'2668','316',205137.78,205673.43,0.00,0.00,535.65,332103.00,0.00,0.00,0.00),('1','152','757','257566',4903779,'2828','316',86131718.74,86132315.58,0.00,0.00,596.84,381977.60,0.00,0.00,0.00),('1','152','757','257567',4903780,'2123','316',809785.40,810811.73,0.00,0.00,1026.33,656851.20,0.00,0.00,0.00),('1','152','757','257567',4903781,'2124','316',652736.58,653828.24,0.00,0.00,1091.66,698662.40,0.00,0.00,0.00),('1','152','757','257567',4903782,'2668','316',205673.43,207593.08,0.00,0.00,1919.65,1190183.00,0.00,0.00,0.00),('1','152','757','257567',4903783,'2828','316',86132315.58,86133149.65,0.00,0.00,834.07,533804.80,0.00,0.00,0.00),('1','152','757','257568',4903784,'2123','316',810811.73,811487.84,0.00,0.00,676.11,432710.40,0.00,0.00,0.00),('1','152','757','257568',4903785,'2124','316',653828.24,654878.33,0.00,0.00,1050.09,672057.60,0.00,0.00,0.00),('1','152','757','257568',4903786,'2668','316',207593.08,208435.11,0.00,0.00,842.03,522058.60,0.00,0.00,0.00),('1','152','757','257568',4903787,'2828','316',86133149.65,86134316.12,0.00,0.00,1166.47,746540.80,0.00,0.00,0.00),('1','152','757','257569',4903788,'2123','316',811487.84,812582.95,0.00,0.00,1095.11,700870.40,0.00,0.00,0.00),('1','152','757','257569',4903789,'2124','316',654878.33,655940.60,0.00,0.00,1062.27,679852.80,0.00,0.00,0.00),('1','152','757','257569',4903790,'2668','316',208435.11,209638.34,0.00,0.00,1203.23,746402.60,0.00,0.00,0.00),('1','152','757','257569',4903791,'2828','316',86134316.12,86134991.50,0.00,0.00,675.38,432243.20,0.00,0.00,0.00),('1','152','757','257570',4903792,'2123','316',812582.95,813325.90,0.00,0.00,742.95,475488.00,0.00,0.00,0.00),('1','152','757','257570',4903793,'2124','316',655940.60,656720.72,0.00,0.00,780.12,499276.80,0.00,0.00,0.00),('1','152','757','257570',4903794,'2668','316',209638.34,210148.34,0.00,0.00,510.00,316200.00,0.00,0.00,0.00),('1','152','757','257570',4903795,'2828','316',86134991.50,86135859.08,0.00,0.00,867.58,555251.20,0.00,0.00,0.00),('1','152','757','257571',4903796,'2123','316',813325.90,814169.05,0.00,0.00,843.15,539616.00,0.00,0.00,0.00),('1','152','757','257571',4903797,'2124','316',656720.72,657534.39,0.00,0.00,813.67,520748.80,0.00,0.00,0.00),('1','152','757','257571',4903798,'2668','316',210148.34,211068.23,0.00,0.00,919.89,570331.80,0.00,0.00,0.00),('1','152','757','257571',4903799,'2828','316',86135859.08,86136435.01,0.00,0.00,575.93,368595.20,0.00,0.00,0.00),('1','152','757','257572',4903800,'2123','316',814169.05,814796.08,0.00,0.00,627.03,401299.20,0.00,0.00,0.00),('1','152','757','257572',4903801,'2124','316',657534.39,658364.55,0.00,0.00,830.16,531302.40,0.00,0.00,0.00),('1','152','757','257572',4903802,'2668','316',211068.23,211687.69,0.00,0.00,619.46,384065.20,0.00,0.00,0.00),('1','152','757','257572',4903803,'2828','316',86136435.01,86137276.43,0.00,0.00,841.42,538508.80,0.00,0.00,0.00),('1','152','757','257573',4903804,'2123','316',814796.08,815089.23,0.00,0.00,293.15,187616.00,0.00,0.00,0.00),('1','152','757','257573',4903805,'2124','316',658364.55,658555.27,0.00,0.00,190.72,122060.80,0.00,0.00,0.00),('1','152','757','257573',4903806,'2668','316',211687.69,212087.69,0.00,0.00,400.00,248000.00,0.00,0.00,0.00),('1','152','757','257573',4903807,'2828','316',86137276.43,86137428.79,0.00,0.00,152.36,97510.40,0.00,0.00,0.00),('1','152','757','257574',4903808,'2123','316',815089.23,815089.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257574',4903809,'2124','316',658555.27,658555.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257574',4903810,'2668','316',212087.69,212087.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257574',4903811,'2828','316',86137428.79,86137428.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257575',4903812,'2123','316',815089.23,815749.47,0.00,0.00,660.24,422553.60,0.00,0.00,0.00),('1','152','757','257575',4903813,'2124','316',658555.27,659366.01,0.00,0.00,810.74,518873.60,0.00,0.00,0.00),('1','152','757','257575',4903814,'2668','316',212087.69,213203.87,0.00,0.00,1116.18,692031.60,0.00,0.00,0.00),('1','152','757','257575',4903815,'2828','316',86137428.79,86137812.30,0.00,0.00,383.51,245446.40,0.00,0.00,0.00),('1','152','757','257576',4903816,'2123','316',815749.47,816609.52,0.00,0.00,860.05,550432.00,0.00,0.00,0.00),('1','152','757','257576',4903817,'2124','316',659366.01,660269.66,0.00,0.00,903.65,578336.00,0.00,0.00,0.00),('1','152','757','257576',4903818,'2668','316',213203.87,213660.25,0.00,0.00,456.38,282955.60,0.00,0.00,0.00),('1','152','757','257576',4903819,'2828','316',86137812.30,86139079.22,0.00,0.00,1266.92,810828.80,0.00,0.00,0.00),('1','152','757','257577',4903820,'2123','316',816609.52,817199.55,0.00,0.00,590.03,377619.20,0.00,0.00,0.00),('1','152','757','257577',4903821,'2124','316',660269.66,660804.62,0.00,0.00,534.96,342374.40,0.00,0.00,0.00),('1','152','757','257577',4903822,'2668','316',213660.25,214229.40,0.00,0.00,569.15,352873.00,0.00,0.00,0.00),('1','152','757','257577',4903823,'2828','316',86139079.22,86139485.90,0.00,0.00,406.68,260275.20,0.00,0.00,0.00),('1','152','757','257578',4903824,'2123','316',817199.55,817199.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257578',4903825,'2124','316',660804.62,660804.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257578',4903826,'2668','316',214229.40,214229.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257578',4903827,'2828','316',86139485.90,86139485.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257579',4903828,'2123','316',817199.55,817746.31,0.00,0.00,546.76,349926.40,0.00,0.00,0.00),('1','152','757','257579',4903829,'2124','316',660804.62,661399.39,0.00,0.00,594.77,380652.80,0.00,0.00,0.00),('1','152','757','257579',4903830,'2668','316',214229.40,214690.66,0.00,0.00,461.26,285981.20,0.00,0.00,0.00),('1','152','757','257579',4903831,'2828','316',86139485.90,86139846.67,0.00,0.00,360.77,230892.80,0.00,0.00,0.00),('1','152','757','257580',4903832,'2123','316',817746.31,818569.57,0.00,0.00,823.26,526886.40,0.00,0.00,0.00),('1','152','757','257580',4903833,'2124','316',661399.39,662213.81,0.00,0.00,814.42,521228.80,0.00,0.00,0.00),('1','152','757','257580',4903834,'2668','316',214690.66,215851.95,0.00,0.00,1161.29,719999.80,0.00,0.00,0.00),('1','152','757','257580',4903835,'2828','316',86139846.67,86140688.73,0.00,0.00,842.06,538918.40,0.00,0.00,0.00),('1','152','757','257581',4903836,'2123','316',818569.57,818595.32,0.00,0.00,25.75,16480.00,0.00,0.00,0.00),('1','152','757','257581',4903837,'2124','316',662213.81,662233.32,0.00,0.00,19.51,12486.40,0.00,0.00,0.00),('1','152','757','257581',4903838,'2668','316',215851.95,216501.95,0.00,0.00,650.00,403000.00,0.00,0.00,0.00),('1','152','757','257581',4903839,'2828','316',86140688.73,86140718.34,0.00,0.00,29.61,18950.40,0.00,0.00,0.00),('1','152','757','257582',4903840,'2123','316',818595.32,819356.76,0.00,0.00,761.44,484275.84,0.00,0.00,0.00),('1','152','757','257582',4903841,'2124','316',662233.32,662952.11,0.00,0.00,718.79,457150.44,0.00,0.00,0.00),('1','152','757','257582',4903842,'2668','316',216501.95,217035.19,0.00,0.00,533.24,327409.36,0.00,0.00,0.00),('1','152','757','257582',4903843,'2828','316',86140718.34,86141298.95,0.00,0.00,580.61,369267.96,0.00,0.00,0.00),('1','152','757','257583',4903844,'2123','316',819356.76,820129.28,0.00,0.00,772.52,491322.72,0.00,0.00,0.00),('1','152','757','257583',4903845,'2124','316',662952.11,663838.19,0.00,0.00,886.08,563546.88,0.00,0.00,0.00),('1','152','757','257583',4903846,'2668','316',217035.19,217905.95,0.00,0.00,870.76,534646.64,0.00,0.00,0.00),('1','152','757','257583',4903847,'2828','316',86141298.95,86142293.45,0.00,0.00,994.50,632502.00,0.00,0.00,0.00),('1','152','757','257584',4903848,'2123','316',820129.28,821014.56,0.00,0.00,885.28,563038.08,0.00,0.00,0.00),('1','152','757','257584',4903849,'2124','316',663838.19,664799.31,0.00,0.00,961.12,611272.32,0.00,0.00,0.00),('1','152','757','257584',4903850,'2668','316',217905.95,218033.93,0.00,0.00,127.98,78579.72,0.00,0.00,0.00),('1','152','757','257584',4903851,'2828','316',86142293.45,86143181.97,0.00,0.00,888.52,565098.72,0.00,0.00,0.00),('1','152','757','257585',4903852,'2123','316',821014.56,821821.64,0.00,0.00,807.08,513302.88,0.00,0.00,0.00),('1','152','757','257585',4903853,'2124','316',664799.31,665688.83,0.00,0.00,889.52,565734.72,0.00,0.00,0.00),('1','152','757','257585',4903854,'2668','316',218033.93,218151.30,0.00,0.00,117.37,72065.18,0.00,0.00,0.00),('1','152','757','257585',4903855,'2828','316',86143181.97,86144002.74,0.00,0.00,820.77,522009.72,0.00,0.00,0.00),('1','152','757','257586',4903856,'2123','316',821821.64,822358.92,0.00,0.00,537.28,341710.08,0.00,0.00,0.00),('1','152','757','257586',4903857,'2124','316',665688.83,666342.30,0.00,0.00,653.47,415606.92,0.00,0.00,0.00),('1','152','757','257586',4903858,'2668','316',218151.30,218374.10,0.00,0.00,222.80,136799.20,0.00,0.00,0.00),('1','152','757','257586',4903859,'2828','316',86144002.74,86144219.24,0.00,0.00,216.50,137694.00,0.00,0.00,0.00),('1','152','757','257587',4903860,'2123','316',822358.92,822812.28,0.00,0.00,453.36,288336.96,0.00,0.00,0.00),('1','152','757','257587',4903861,'2124','316',666342.30,666699.87,0.00,0.00,357.57,227414.52,0.00,0.00,0.00),('1','152','757','257587',4903862,'2668','316',218374.10,218542.65,0.00,0.00,168.55,103489.70,0.00,0.00,0.00),('1','152','757','257587',4903863,'2828','316',86144219.24,86144344.53,0.00,0.00,125.29,79684.44,0.00,0.00,0.00),('1','152','757','257588',4903864,'2123','316',822812.28,823986.33,0.00,0.00,1174.05,746695.80,0.00,0.00,0.00),('1','152','757','257588',4903865,'2124','316',666699.87,667640.98,0.00,0.00,941.11,598545.96,0.00,0.00,0.00),('1','152','757','257588',4903866,'2668','316',218542.65,219150.73,0.00,0.00,608.08,373361.12,0.00,0.00,0.00),('1','152','757','257588',4903867,'2828','316',86144344.53,86144946.54,0.00,0.00,602.01,382878.36,0.00,0.00,0.00),('1','152','757','257589',4903868,'2123','316',823986.33,825065.38,0.00,0.00,1079.05,686275.80,0.00,0.00,0.00),('1','152','757','257589',4903869,'2124','316',667640.98,668668.81,0.00,0.00,1027.83,653699.88,0.00,0.00,0.00),('1','152','757','257589',4903870,'2668','316',219150.73,220126.16,0.00,0.00,975.43,598914.02,0.00,0.00,0.00),('1','152','757','257589',4903871,'2828','316',86144946.54,86145575.32,0.00,0.00,628.78,399904.08,0.00,0.00,0.00),('1','152','757','257590',4903872,'2123','316',825065.38,825861.42,0.00,0.00,796.04,506281.44,0.00,0.00,0.00),('1','152','757','257590',4903873,'2124','316',668668.81,669431.22,0.00,0.00,762.41,484892.76,0.00,0.00,0.00),('1','152','757','257590',4903874,'2668','316',220126.16,221176.26,0.00,0.00,1050.10,644761.40,0.00,0.00,0.00),('1','152','757','257590',4903875,'2828','316',86145575.32,86146311.32,0.00,0.00,736.00,468096.00,0.00,0.00,0.00),('1','152','757','257591',4903876,'2123','316',825861.42,826699.30,0.00,0.00,837.88,532891.68,0.00,0.00,0.00),('1','152','757','257591',4903877,'2124','316',669431.22,670326.37,0.00,0.00,895.15,569315.40,0.00,0.00,0.00),('1','152','757','257591',4903878,'2668','316',221176.26,221798.71,0.00,0.00,622.45,382184.30,0.00,0.00,0.00),('1','152','757','257591',4903879,'2828','316',86146311.32,86147072.32,0.00,0.00,761.00,483996.00,0.00,0.00,0.00),('1','152','757','257592',4903880,'2123','316',826699.30,827691.66,0.00,0.00,992.36,631140.96,0.00,0.00,0.00),('1','152','757','257592',4903881,'2124','316',670326.37,671440.98,0.00,0.00,1114.61,708891.96,0.00,0.00,0.00),('1','152','757','257592',4903882,'2668','316',221798.71,222679.46,0.00,0.00,880.75,540780.50,0.00,0.00,0.00),('1','152','757','257592',4903883,'2828','316',86147072.32,86147724.26,0.00,0.00,651.94,414633.84,0.00,0.00,0.00),('1','152','757','257593',4903884,'2123','316',827691.66,828510.33,0.00,0.00,818.67,520674.12,0.00,0.00,0.00),('1','152','757','257593',4903885,'2124','316',671440.98,672393.50,0.00,0.00,952.52,605802.72,0.00,0.00,0.00),('1','152','757','257593',4903886,'2668','316',222679.46,223265.42,0.00,0.00,585.96,359779.44,0.00,0.00,0.00),('1','152','757','257593',4903887,'2828','316',86147724.26,86148796.11,0.00,0.00,1071.85,681696.60,0.00,0.00,0.00),('1','152','757','257594',4903888,'2123','316',828510.33,829148.02,0.00,0.00,637.69,405570.84,0.00,0.00,0.00),('1','152','757','257594',4903889,'2124','316',672393.50,673148.98,0.00,0.00,755.48,480485.28,0.00,0.00,0.00),('1','152','757','257594',4903890,'2668','316',223265.42,223956.44,0.00,0.00,691.02,424286.28,0.00,0.00,0.00),('1','152','757','257594',4903891,'2828','316',86148796.11,86149475.06,0.00,0.00,678.95,431812.20,0.00,0.00,0.00),('1','152','757','257595',4903892,'2123','316',829148.02,829148.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257595',4903893,'2124','316',673148.98,673148.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257595',4903894,'2668','316',223956.44,223956.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257595',4903895,'2828','316',86149475.06,86149475.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257596',4903896,'2123','316',829148.02,829415.88,0.00,0.00,267.86,170358.96,0.00,0.00,0.00),('1','152','757','257596',4903897,'2124','316',673148.98,673343.92,0.00,0.00,194.94,123981.84,0.00,0.00,0.00),('1','152','757','257596',4903898,'2668','316',223956.44,224084.59,0.00,0.00,128.15,78684.10,0.00,0.00,0.00),('1','152','757','257596',4903899,'2828','316',86149475.06,86149783.21,0.00,0.00,308.15,195983.40,0.00,0.00,0.00),('1','152','757','257597',4903900,'2123','316',829415.88,830665.61,0.00,0.00,1249.73,794828.28,0.00,0.00,0.00),('1','152','757','257597',4903901,'2124','316',673343.92,674805.05,0.00,0.00,1461.13,929278.68,0.00,0.00,0.00),('1','152','757','257597',4903902,'2668','316',224084.59,224761.09,0.00,0.00,676.50,415371.00,0.00,0.00,0.00),('1','152','757','257597',4903903,'2828','316',86149783.21,86150924.28,0.00,0.00,1141.07,725720.52,0.00,0.00,0.00),('1','152','757','257598',4903904,'2123','316',830665.61,832237.89,0.00,0.00,1572.28,999970.08,0.00,0.00,0.00),('1','152','757','257598',4903905,'2124','316',674805.05,676482.80,0.00,0.00,1677.75,1067049.00,0.00,0.00,0.00),('1','152','757','257598',4903906,'2668','316',224761.09,225322.22,0.00,0.00,561.13,344533.82,0.00,0.00,0.00),('1','152','757','257598',4903907,'2828','316',86150924.28,86152153.31,0.00,0.00,1229.03,781663.08,0.00,0.00,0.00),('1','152','757','257599',4903908,'2123','316',832237.89,832784.50,0.00,0.00,546.61,347643.96,0.00,0.00,0.00),('1','152','757','257599',4903909,'2124','316',676482.80,677306.32,0.00,0.00,823.52,523758.72,0.00,0.00,0.00),('1','152','757','257599',4903910,'2668','316',225322.22,226335.44,0.00,0.00,1013.22,622117.08,0.00,0.00,0.00),('1','152','757','257599',4903911,'2828','316',86152153.31,86152609.23,0.00,0.00,455.92,289965.12,0.00,0.00,0.00),('1','152','757','257600',4903912,'2123','316',832784.50,833672.34,0.00,0.00,887.84,564666.24,0.00,0.00,0.00),('1','152','757','257600',4903913,'2124','316',677306.32,678154.15,0.00,0.00,847.83,539219.88,0.00,0.00,0.00),('1','152','757','257600',4903914,'2668','316',226335.44,227672.44,0.00,0.00,1337.00,820918.00,0.00,0.00,0.00),('1','152','757','257600',4903915,'2828','316',86152609.23,86153181.45,0.00,0.00,572.22,363931.92,0.00,0.00,0.00),('1','152','757','257601',4903916,'2123','316',833672.34,834365.58,0.00,0.00,693.24,440900.64,0.00,0.00,0.00),('1','152','757','257601',4903917,'2124','316',678154.15,678945.88,0.00,0.00,791.73,503540.28,0.00,0.00,0.00),('1','152','757','257601',4903918,'2668','316',227672.44,228503.58,0.00,0.00,831.14,510319.96,0.00,0.00,0.00),('1','152','757','257601',4903919,'2828','316',86153181.45,86153736.77,0.00,0.00,555.32,353183.52,0.00,0.00,0.00),('1','152','757','257602',4903920,'2123','316',834365.58,835554.38,0.00,0.00,1188.80,756076.80,0.00,0.00,0.00),('1','152','757','257602',4903921,'2124','316',678945.88,679824.79,0.00,0.00,878.91,558986.76,0.00,0.00,0.00),('1','152','757','257602',4903922,'2668','316',228503.58,229962.96,0.00,0.00,1459.38,896059.32,0.00,0.00,0.00),('1','152','757','257602',4903923,'2828','316',86153736.77,86154623.48,0.00,0.00,886.71,563947.56,0.00,0.00,0.00),('1','152','757','257603',4903924,'2123','316',835554.38,835677.53,0.00,0.00,123.15,78323.40,0.00,0.00,0.00),('1','152','757','257603',4903925,'2124','316',679824.79,679990.30,0.00,0.00,165.51,105264.36,0.00,0.00,0.00),('1','152','757','257603',4903926,'2668','316',229962.96,229970.37,0.00,0.00,7.41,4549.74,0.00,0.00,0.00),('1','152','757','257603',4903927,'2828','316',86154623.48,86154707.59,0.00,0.00,84.11,53493.96,0.00,0.00,0.00),('1','152','757','257604',4903928,'2123','316',835677.53,835677.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257604',4903929,'2124','316',679990.30,679990.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257604',4903930,'2668','316',229970.37,229970.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257604',4903931,'2828','316',86154707.59,86154707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257605',4903932,'2123','316',835677.53,836485.35,0.00,0.00,807.82,513773.52,0.00,0.00,0.00),('1','152','757','257605',4903933,'2124','316',679990.30,680933.81,0.00,0.00,943.51,600072.36,0.00,0.00,0.00),('1','152','757','257605',4903934,'2668','316',229970.37,231098.60,0.00,0.00,1128.23,692733.22,0.00,0.00,0.00),('1','152','757','257605',4903935,'2828','316',86154707.59,86155469.92,0.00,0.00,762.33,484841.88,0.00,0.00,0.00),('1','152','757','257606',4903936,'2123','316',836485.35,837642.08,0.00,0.00,1156.73,735680.28,0.00,0.00,0.00),('1','152','757','257606',4903937,'2124','316',680933.81,682060.96,0.00,0.00,1127.15,716867.40,0.00,0.00,0.00),('1','152','757','257606',4903938,'2668','316',231098.60,231843.82,0.00,0.00,745.22,457565.08,0.00,0.00,0.00),('1','152','757','257606',4903939,'2828','316',86155469.92,86156684.18,0.00,0.00,1214.26,772269.36,0.00,0.00,0.00),('1','152','757','257607',4903940,'2123','316',837642.08,838876.39,0.00,0.00,1234.31,785021.16,0.00,0.00,0.00),('1','152','757','257607',4903941,'2124','316',682060.96,683215.68,0.00,0.00,1154.72,734401.92,0.00,0.00,0.00),('1','152','757','257607',4903942,'2668','316',231843.82,232522.06,0.00,0.00,678.24,416439.36,0.00,0.00,0.00),('1','152','757','257607',4903943,'2828','316',86156684.18,86157925.37,0.00,0.00,1241.19,789396.84,0.00,0.00,0.00),('1','152','757','257608',4903944,'2123','316',838876.39,839726.39,0.00,0.00,850.00,540600.00,0.00,0.00,0.00),('1','152','757','257608',4903945,'2124','316',683215.68,684196.73,0.00,0.00,981.05,623947.80,0.00,0.00,0.00),('1','152','757','257608',4903946,'2668','316',232522.06,232848.54,0.00,0.00,326.48,200597.10,0.00,0.00,0.00),('1','152','757','257608',4903947,'2828','316',86157925.37,86158949.31,0.00,0.00,1023.94,651225.84,0.00,0.00,0.00),('1','152','757','257609',4903948,'2123','316',839726.39,841176.28,0.00,0.00,1449.89,922130.04,0.00,0.00,0.00),('1','152','757','257609',4903949,'2124','316',684196.73,685418.15,0.00,0.00,1221.42,776823.12,0.00,0.00,0.00),('1','152','757','257609',4903950,'2668','316',232848.54,234389.57,0.00,0.00,1541.03,946192.42,0.00,0.00,0.00),('1','152','757','257609',4903951,'2828','316',86158949.31,86159501.88,0.00,0.00,552.57,351434.52,0.00,0.00,0.00),('1','152','757','257610',4903952,'2123','316',841176.28,842273.19,0.00,0.00,1096.91,697634.76,0.00,0.00,0.00),('1','152','757','257610',4903953,'2124','316',685418.15,686484.19,0.00,0.00,1066.04,678001.44,0.00,0.00,0.00),('1','152','757','257610',4903954,'2668','316',234389.57,234811.09,0.00,0.00,421.52,258813.28,0.00,0.00,0.00),('1','152','757','257610',4903955,'2828','316',86159501.88,86160450.83,0.00,0.00,948.95,603532.20,0.00,0.00,0.00),('1','152','757','257611',4903956,'2123','316',842273.19,842480.72,0.00,0.00,207.53,131989.08,0.00,0.00,0.00),('1','152','757','257611',4903957,'2124','316',686484.19,686734.64,0.00,0.00,250.45,159286.20,0.00,0.00,0.00),('1','152','757','257611',4903958,'2668','316',234811.09,234884.70,0.00,0.00,73.61,45196.54,0.00,0.00,0.00),('1','152','757','257611',4903959,'2828','316',86160450.83,86160651.68,0.00,0.00,200.85,127740.60,0.00,0.00,0.00),('1','152','757','257612',4903960,'2123','316',842480.72,842480.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257612',4903961,'2124','316',686734.64,686734.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257612',4903962,'2668','316',234884.70,234884.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257612',4903963,'2828','316',86160651.68,86160651.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257613',4903964,'2123','316',842480.72,843352.80,0.00,0.00,872.08,554642.88,0.00,0.00,0.00),('1','152','757','257613',4903965,'2124','316',686734.64,687402.10,0.00,0.00,667.46,424504.56,0.00,0.00,0.00),('1','152','757','257613',4903966,'2668','316',234884.70,235241.59,0.00,0.00,356.89,219130.46,0.00,0.00,0.00),('1','152','757','257613',4903967,'2828','316',86160651.68,86161318.09,0.00,0.00,666.41,423836.76,0.00,0.00,0.00),('1','152','757','257614',4903968,'2123','316',843352.80,844173.75,0.00,0.00,820.95,522124.20,0.00,0.00,0.00),('1','152','757','257614',4903969,'2124','316',687402.10,688456.07,0.00,0.00,1053.97,670324.92,0.00,0.00,0.00),('1','152','757','257614',4903970,'2668','316',235241.59,235561.09,0.00,0.00,319.50,196173.00,0.00,0.00,0.00),('1','152','757','257614',4903971,'2828','316',86161318.09,86162201.99,0.00,0.00,883.90,562160.40,0.00,0.00,0.00),('1','152','757','257615',4903972,'2123','316',844173.75,845191.32,0.00,0.00,1017.57,647174.52,0.00,0.00,0.00),('1','152','757','257615',4903973,'2124','316',688456.07,689391.20,0.00,0.00,935.13,594742.68,0.00,0.00,0.00),('1','152','757','257615',4903974,'2668','316',235561.09,235813.95,0.00,0.00,252.86,155256.04,0.00,0.00,0.00),('1','152','757','257615',4903975,'2828','316',86162201.99,86163072.93,0.00,0.00,870.94,553917.84,0.00,0.00,0.00),('1','152','757','257616',4903976,'2123','316',845191.32,846147.76,0.00,0.00,956.44,665682.24,0.00,0.00,0.00),('1','152','757','257616',4903977,'2124','316',689391.20,690397.54,0.00,0.00,1006.34,700412.64,0.00,0.00,0.00),('1','152','757','257616',4903978,'2668','316',235813.95,237044.07,0.00,0.00,1230.12,802474.28,0.00,0.00,0.00),('1','152','757','257616',4903979,'2828','316',86163072.93,86164093.10,0.00,0.00,1020.17,710038.32,0.00,0.00,0.00),('1','152','757','257617',4903980,'2123','316',846147.76,847101.18,0.00,0.00,953.42,663580.32,0.00,0.00,0.00),('1','152','757','257617',4903981,'2124','316',690397.54,691203.99,0.00,0.00,806.45,561289.20,0.00,0.00,0.00),('1','152','757','257617',4903982,'2668','316',237044.07,237124.72,0.00,0.00,80.65,52583.80,0.00,0.00,0.00),('1','152','757','257617',4903983,'2828','316',86164093.10,86164977.18,0.00,0.00,884.08,615319.68,0.00,0.00,0.00),('1','152','757','257618',4903984,'2123','316',847101.18,847831.67,0.00,0.00,730.49,508421.04,0.00,0.00,0.00),('1','152','757','257618',4903985,'2124','316',691203.99,692013.76,0.00,0.00,809.77,563599.92,0.00,0.00,0.00),('1','152','757','257618',4903986,'2668','316',237124.72,237210.22,0.00,0.00,85.50,55746.00,0.00,0.00,0.00),('1','152','757','257618',4903987,'2828','316',86164977.18,86165851.12,0.00,0.00,873.94,608262.24,0.00,0.00,0.00),('1','152','757','257619',4903988,'2123','316',847831.67,848768.58,0.00,0.00,936.91,652089.36,0.00,0.00,0.00),('1','152','757','257619',4903989,'2124','316',692013.76,692747.99,0.00,0.00,734.23,511024.08,0.00,0.00,0.00),('1','152','757','257619',4903990,'2668','316',237210.22,237662.86,0.00,0.00,452.64,295121.28,0.00,0.00,0.00),('1','152','757','257619',4903991,'2828','316',86165851.12,86166326.65,0.00,0.00,475.53,330968.88,0.00,0.00,0.00),('1','152','757','257620',4903992,'2123','316',848768.58,849510.17,0.00,0.00,741.59,516146.64,0.00,0.00,0.00),('1','152','757','257620',4903993,'2124','316',692747.99,693533.63,0.00,0.00,785.64,546805.44,0.00,0.00,0.00),('1','152','757','257620',4903994,'2668','316',237662.86,237917.33,0.00,0.00,254.47,166199.12,0.00,0.00,0.00),('1','152','757','257620',4903995,'2828','316',86166326.65,86167103.32,0.00,0.00,776.67,540562.32,0.00,0.00,0.00),('1','152','757','257621',4903996,'2123','316',849510.17,849867.82,0.00,0.00,357.65,248924.40,0.00,0.00,0.00),('1','152','757','257621',4903997,'2124','316',693533.63,693822.07,0.00,0.00,288.44,200754.24,0.00,0.00,0.00),('1','152','757','257621',4903998,'2668','316',237917.33,238058.43,0.00,0.00,141.10,91997.20,0.00,0.00,0.00),('1','152','757','257621',4903999,'2828','316',86167103.32,86167501.16,0.00,0.00,397.84,276896.64,0.00,0.00,0.00),('1','152','757','257622',4904000,'2123','316',849867.82,849867.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257622',4904001,'2124','316',693822.07,693822.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257622',4904002,'2668','316',238058.43,238058.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257622',4904003,'2828','316',86167501.16,86167501.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257623',4904004,'2123','316',849867.82,850304.39,0.00,0.00,436.57,303852.72,0.00,0.00,0.00),('1','152','757','257623',4904005,'2124','316',693822.07,694200.50,0.00,0.00,378.43,263387.28,0.00,0.00,0.00),('1','152','757','257623',4904006,'2668','316',238058.43,238178.99,0.00,0.00,120.56,78668.48,0.00,0.00,0.00),('1','152','757','257623',4904007,'2828','316',86167501.16,86167898.55,0.00,0.00,397.39,276583.44,0.00,0.00,0.00),('1','152','757','257624',4904008,'2123','316',850304.39,850459.97,0.00,0.00,155.58,107730.08,0.00,0.00,0.00),('1','152','757','257624',4904009,'2124','316',694200.50,694460.34,0.00,0.00,259.84,180024.00,0.00,0.00,0.00),('1','152','757','257624',4904010,'2668','316',238178.99,238960.05,0.00,0.00,781.06,509251.12,0.00,0.00,0.00),('1','152','757','257624',4904011,'2828','316',86167898.55,86167959.90,0.00,0.00,61.35,42699.60,0.00,0.00,0.00),('1','152','757','257625',4904012,'2123','316',850459.97,851185.70,0.00,0.00,725.73,493496.40,0.00,0.00,0.00),('1','152','757','257625',4904013,'2124','316',694460.34,695292.73,0.00,0.00,832.39,566025.20,0.00,0.00,0.00),('1','152','757','257625',4904014,'2668','316',238960.05,238994.08,0.00,0.00,34.03,21779.20,0.00,0.00,0.00),('1','152','757','257625',4904015,'2828','316',86167959.90,86168494.44,0.00,0.00,534.54,363487.20,0.00,0.00,0.00),('1','152','757','257626',4904016,'2123','316',851185.70,852500.11,0.00,0.00,1314.41,893798.80,0.00,0.00,0.00),('1','152','757','257626',4904017,'2124','316',695292.73,696300.75,0.00,0.00,1008.02,685453.60,0.00,0.00,0.00),('1','152','757','257626',4904018,'2668','316',238994.08,239030.39,0.00,0.00,36.31,23238.40,0.00,0.00,0.00),('1','152','757','257626',4904019,'2828','316',86168494.44,86169284.96,0.00,0.00,790.52,537553.60,0.00,0.00,0.00),('1','152','757','257627',4904020,'2123','316',852500.11,852593.69,0.00,0.00,93.58,63634.40,0.00,0.00,0.00),('1','152','757','257627',4904021,'2124','316',696300.75,696434.16,0.00,0.00,133.41,90718.80,0.00,0.00,0.00),('1','152','757','257627',4904022,'2668','316',239030.39,239030.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257627',4904023,'2828','316',86169284.96,86169394.96,0.00,0.00,110.00,74800.00,0.00,0.00,0.00),('1','152','757','257628',4904024,'2123','316',852593.69,852593.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257628',4904025,'2124','316',696434.16,696434.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257628',4904026,'2668','316',239030.39,239030.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257628',4904027,'2828','316',86169394.96,86169394.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257629',4904028,'2123','316',852593.69,853213.87,0.00,0.00,620.18,421722.40,0.00,0.00,0.00),('1','152','757','257629',4904029,'2124','316',696434.16,697145.33,0.00,0.00,711.17,483595.60,0.00,0.00,0.00),('1','152','757','257629',4904030,'2668','316',239030.39,239109.44,0.00,0.00,79.05,50592.00,0.00,0.00,0.00),('1','152','757','257629',4904031,'2828','316',86169394.96,86170008.69,0.00,0.00,613.73,417336.40,0.00,0.00,0.00),('1','152','757','257630',4904032,'2123','316',853213.87,853825.39,0.00,0.00,611.52,415833.60,0.00,0.00,0.00),('1','152','757','257630',4904033,'2124','316',697145.33,698100.18,0.00,0.00,954.85,649298.00,0.00,0.00,0.00),('1','152','757','257630',4904034,'2668','316',239109.44,239848.52,0.00,0.00,739.08,473011.20,0.00,0.00,0.00),('1','152','757','257630',4904035,'2828','316',86170008.69,86170932.13,0.00,0.00,923.44,627939.20,0.00,0.00,0.00),('1','152','757','257631',4904036,'2123','316',853825.39,854435.37,0.00,0.00,609.98,451385.20,0.00,0.00,0.00),('1','152','757','257631',4904037,'2124','316',698100.18,698975.07,0.00,0.00,874.89,647418.60,0.00,0.00,0.00),('1','152','757','257631',4904038,'2668','316',239848.52,239874.67,0.00,0.00,26.15,18200.40,0.00,0.00,0.00),('1','152','757','257631',4904039,'2828','316',86170932.13,86171704.81,0.00,0.00,772.68,571783.20,0.00,0.00,0.00),('1','152','757','257632',4904040,'2123','316',854435.37,855044.70,0.00,0.00,609.33,450904.20,0.00,0.00,0.00),('1','152','757','257632',4904041,'2124','316',698975.07,699847.13,0.00,0.00,872.06,645324.40,0.00,0.00,0.00),('1','152','757','257632',4904042,'2668','316',239874.67,239916.33,0.00,0.00,41.66,28995.36,0.00,0.00,0.00),('1','152','757','257632',4904043,'2828','316',86171704.81,86172391.64,0.00,0.00,686.83,508254.20,0.00,0.00,0.00),('1','152','757','257633',4904044,'2123','316',855044.70,855848.59,0.00,0.00,803.89,594878.60,0.00,0.00,0.00),('1','152','757','257633',4904045,'2124','316',699847.13,700760.59,0.00,0.00,913.46,675960.40,0.00,0.00,0.00),('1','152','757','257633',4904046,'2668','316',239916.33,240071.63,0.00,0.00,155.30,108088.80,0.00,0.00,0.00),('1','152','757','257633',4904047,'2828','316',86172391.64,86173140.16,0.00,0.00,748.52,553904.80,0.00,0.00,0.00),('1','152','757','257634',4904048,'2123','316',855848.59,856591.91,0.00,0.00,743.32,550056.80,0.00,0.00,0.00),('1','152','757','257634',4904049,'2124','316',700760.59,701884.29,0.00,0.00,1123.70,831538.00,0.00,0.00,0.00),('1','152','757','257634',4904050,'2668','316',240071.63,240089.39,0.00,0.00,17.76,12360.96,0.00,0.00,0.00),('1','152','757','257634',4904051,'2828','316',86173140.16,86174062.07,0.00,0.00,921.91,682213.40,0.00,0.00,0.00),('1','152','757','257635',4904052,'2123','316',856591.91,857477.78,0.00,0.00,885.87,620109.00,0.00,0.00,0.00),('1','152','757','257635',4904053,'2124','316',701884.29,703078.64,0.00,0.00,1194.35,836045.00,0.00,0.00,0.00),('1','152','757','257635',4904054,'2668','316',240089.39,240298.45,0.00,0.00,209.06,145505.76,0.00,0.00,0.00),('1','152','757','257635',4904055,'2828','316',86174062.07,86175220.46,0.00,0.00,1158.39,810873.00,0.00,0.00,0.00),('1','152','757','257636',4904056,'2123','316',857477.78,858520.28,0.00,0.00,1042.50,729750.00,0.00,0.00,0.00),('1','152','757','257636',4904057,'2124','316',703078.64,704180.50,0.00,0.00,1101.86,771302.00,0.00,0.00,0.00),('1','152','757','257636',4904058,'2668','316',240298.45,240464.53,0.00,0.00,166.08,115600.24,0.00,0.00,0.00),('1','152','757','257636',4904059,'2828','316',86175220.46,86176169.47,0.00,0.00,949.01,664307.00,0.00,0.00,0.00),('1','152','757','257637',4904060,'2123','316',858520.28,859168.00,0.00,0.00,647.72,440449.60,0.00,0.00,0.00),('1','152','757','257637',4904061,'2124','316',704180.50,705147.33,0.00,0.00,966.83,657444.40,0.00,0.00,0.00),('1','152','757','257637',4904062,'2668','316',240464.53,240629.80,0.00,0.00,165.27,109408.74,0.00,0.00,0.00),('1','152','757','257637',4904063,'2828','316',86176169.47,86176746.32,0.00,0.00,576.85,392258.00,0.00,0.00,0.00),('1','152','757','257638',4904064,'2123','316',859168.00,859168.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257638',4904065,'2124','316',705147.33,705147.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257638',4904066,'2668','316',240629.80,240629.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257638',4904067,'2828','316',86176746.32,86176746.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257639',4904068,'2123','316',859168.00,859394.71,0.00,0.00,226.71,154162.80,0.00,0.00,0.00),('1','152','757','257639',4904069,'2124','316',705147.33,705481.24,0.00,0.00,333.91,227058.80,0.00,0.00,0.00),('1','152','757','257639',4904070,'2668','316',240629.80,240659.80,0.00,0.00,30.00,20400.00,0.00,0.00,0.00),('1','152','757','257639',4904071,'2828','316',86176746.32,86177074.41,0.00,0.00,328.09,223101.20,0.00,0.00,0.00),('1','152','757','257640',4904072,'2123','316',859394.71,860391.18,0.00,0.00,996.47,677599.60,0.00,0.00,0.00),('1','152','757','257640',4904073,'2124','316',705481.24,706570.14,0.00,0.00,1088.90,740452.00,0.00,0.00,0.00),('1','152','757','257640',4904074,'2668','316',240659.80,240718.87,0.00,0.00,59.07,39320.34,0.00,0.00,0.00),('1','152','757','257640',4904075,'2828','316',86177074.41,86178041.81,0.00,0.00,967.40,657832.00,0.00,0.00,0.00),('1','152','757','257641',4904076,'2123','316',860391.18,861332.98,0.00,0.00,941.80,640424.00,0.00,0.00,0.00),('1','152','757','257641',4904077,'2124','316',706570.14,707691.66,0.00,0.00,1121.52,762633.60,0.00,0.00,0.00),('1','152','757','257641',4904078,'2668','316',240718.87,241414.79,0.00,0.00,695.92,460725.50,0.00,0.00,0.00),('1','152','757','257641',4904079,'2828','316',86178041.81,86178796.72,0.00,0.00,754.91,513338.80,0.00,0.00,0.00),('1','152','757','257642',4904080,'2123','316',861332.98,862173.12,0.00,0.00,840.14,571295.20,0.00,0.00,0.00),('1','152','757','257642',4904081,'2124','316',707691.66,708899.95,0.00,0.00,1208.29,821637.20,0.00,0.00,0.00),('1','152','757','257642',4904082,'2668','316',241414.79,241996.31,0.00,0.00,581.52,384966.24,0.00,0.00,0.00),('1','152','757','257642',4904083,'2828','316',86178796.72,86179685.97,0.00,0.00,889.25,604690.00,0.00,0.00,0.00),('1','152','757','257643',4904084,'2123','316',862173.12,863212.96,0.00,0.00,1039.84,707091.20,0.00,0.00,0.00),('1','152','757','257643',4904085,'2124','316',708899.95,710155.57,0.00,0.00,1255.62,853821.60,0.00,0.00,0.00),('1','152','757','257643',4904086,'2668','316',241996.31,242094.94,0.00,0.00,98.63,65293.06,0.00,0.00,0.00),('1','152','757','257643',4904087,'2828','316',86179685.97,86180848.78,0.00,0.00,1162.81,790710.80,0.00,0.00,0.00),('1','152','757','257644',4904088,'2123','316',863212.96,864489.64,0.00,0.00,1276.68,868142.40,0.00,0.00,0.00),('1','152','757','257644',4904089,'2124','316',710155.57,711405.47,0.00,0.00,1249.90,849932.00,0.00,0.00,0.00),('1','152','757','257644',4904090,'2668','316',242094.94,243220.88,0.00,0.00,1125.94,745372.28,0.00,0.00,0.00),('1','152','757','257644',4904091,'2828','316',86180848.78,86182256.28,0.00,0.00,1407.50,957100.00,0.00,0.00,0.00),('1','152','757','257645',4904092,'2123','316',864489.64,865238.44,0.00,0.00,748.80,509184.00,0.00,0.00,0.00),('1','152','757','257645',4904093,'2124','316',711405.47,712531.83,0.00,0.00,1126.36,765924.80,0.00,0.00,0.00),('1','152','757','257645',4904094,'2668','316',243220.88,243540.87,0.00,0.00,319.99,211833.38,0.00,0.00,0.00),('1','152','757','257645',4904095,'2828','316',86182256.28,86183294.84,0.00,0.00,1038.56,706220.80,0.00,0.00,0.00),('1','152','757','257646',4904096,'2123','316',865238.44,865566.13,0.00,0.00,327.69,222829.20,0.00,0.00,0.00),('1','152','757','257646',4904097,'2124','316',712531.83,712952.13,0.00,0.00,420.30,285804.00,0.00,0.00,0.00),('1','152','757','257646',4904098,'2668','316',243540.87,244275.87,0.00,0.00,735.00,486570.00,0.00,0.00,0.00),('1','152','757','257646',4904099,'2828','316',86183294.84,86183473.66,0.00,0.00,178.82,121597.60,0.00,0.00,0.00),('1','152','757','257647',4904100,'2123','316',865566.13,865566.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257647',4904101,'2124','316',712952.13,712952.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257647',4904102,'2668','316',244275.87,244275.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257647',4904103,'2828','316',86183473.66,86183473.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257648',4904104,'2123','316',865566.13,866266.73,0.00,0.00,700.60,476408.00,0.00,0.00,0.00),('1','152','757','257648',4904105,'2124','316',712952.13,713742.23,0.00,0.00,790.10,537268.00,0.00,0.00,0.00),('1','152','757','257648',4904106,'2668','316',244275.87,244577.25,0.00,0.00,301.38,199540.02,0.00,0.00,0.00),('1','152','757','257648',4904107,'2828','316',86183473.66,86184307.13,0.00,0.00,833.47,566759.60,0.00,0.00,0.00),('1','152','757','257649',4904108,'2123','316',866266.73,867050.48,0.00,0.00,783.75,532950.00,0.00,0.00,0.00),('1','152','757','257649',4904109,'2124','316',713742.23,714771.28,0.00,0.00,1029.05,699754.00,0.00,0.00,0.00),('1','152','757','257649',4904110,'2668','316',244577.25,244670.16,0.00,0.00,92.91,61506.42,0.00,0.00,0.00),('1','152','757','257649',4904111,'2828','316',86184307.13,86185334.62,0.00,0.00,1027.49,698693.20,0.00,0.00,0.00),('1','152','757','257650',4904112,'2123','316',867050.48,867938.89,0.00,0.00,888.41,604118.80,0.00,0.00,0.00),('1','152','757','257650',4904113,'2124','316',714771.28,715680.83,0.00,0.00,909.55,618494.00,0.00,0.00,0.00),('1','152','757','257650',4904114,'2668','316',244670.16,245259.56,0.00,0.00,589.40,390182.80,0.00,0.00,0.00),('1','152','757','257650',4904115,'2828','316',86185334.62,86186125.30,0.00,0.00,790.68,537662.40,0.00,0.00,0.00),('1','152','757','257651',4904116,'2123','316',867938.89,868647.08,0.00,0.00,708.19,531142.50,0.00,0.00,0.00),('1','152','757','257651',4904117,'2124','316',715680.83,716501.89,0.00,0.00,821.06,615795.00,0.00,0.00,0.00),('1','152','757','257651',4904118,'2668','316',245259.56,245504.56,0.00,0.00,245.00,173950.00,0.00,0.00,0.00),('1','152','757','257651',4904119,'2828','316',86186125.30,86186907.73,0.00,0.00,782.43,586822.50,0.00,0.00,0.00),('1','152','757','257652',4904120,'2123','316',868647.08,869489.14,0.00,0.00,842.06,631545.00,0.00,0.00,0.00),('1','152','757','257652',4904121,'2124','316',716501.89,717372.52,0.00,0.00,870.63,652972.50,0.00,0.00,0.00),('1','152','757','257652',4904122,'2668','316',245504.56,245614.56,0.00,0.00,110.00,78100.00,0.00,0.00,0.00),('1','152','757','257652',4904123,'2828','316',86186907.73,86187688.06,0.00,0.00,780.33,585247.50,0.00,0.00,0.00),('1','152','757','257653',4904124,'2123','316',869489.14,870506.85,0.00,0.00,1017.71,764782.50,0.00,0.00,0.00),('1','152','757','257653',4904125,'2124','316',717372.52,718328.15,0.00,0.00,955.63,716722.50,0.00,0.00,0.00),('1','152','757','257653',4904126,'2668','316',245614.56,245638.58,0.00,0.00,24.02,17054.20,0.00,0.00,0.00),('1','152','757','257653',4904127,'2828','316',86187688.06,86188934.88,0.00,0.00,1246.82,935115.00,0.00,0.00,0.00),('1','152','757','257654',4904128,'2123','316',870506.85,871372.38,0.00,0.00,865.53,649147.50,0.00,0.00,0.00),('1','152','757','257654',4904129,'2124','316',718328.15,719195.36,0.00,0.00,867.21,650407.50,0.00,0.00,0.00),('1','152','757','257654',4904130,'2668','316',245638.58,245727.39,0.00,0.00,88.81,63055.10,0.00,0.00,0.00),('1','152','757','257654',4904131,'2828','316',86188934.88,86189901.92,0.00,0.00,967.04,725280.00,0.00,0.00,0.00),('1','152','757','257655',4904132,'2123','316',871372.38,872112.84,0.00,0.00,740.46,555345.00,0.00,0.00,0.00),('1','152','757','257655',4904133,'2124','316',719195.36,719941.50,0.00,0.00,746.14,559605.00,0.00,0.00,0.00),('1','152','757','257655',4904134,'2668','316',245727.39,245782.39,0.00,0.00,55.00,39050.00,0.00,0.00,0.00),('1','152','757','257655',4904135,'2828','316',86189901.92,86190698.87,0.00,0.00,796.95,597712.50,0.00,0.00,0.00),('1','152','757','257656',4904136,'2123','316',872112.84,872608.75,0.00,0.00,495.91,371932.50,0.00,0.00,0.00),('1','152','757','257656',4904137,'2124','316',719941.50,720680.80,0.00,0.00,739.30,554475.00,0.00,0.00,0.00),('1','152','757','257656',4904138,'2668','316',245782.39,245805.07,0.00,0.00,22.68,16102.80,0.00,0.00,0.00),('1','152','757','257656',4904139,'2828','316',86190698.87,86191417.64,0.00,0.00,718.77,539077.50,0.00,0.00,0.00),('1','152','757','257657',4904140,'2123','316',872608.75,872608.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257657',4904141,'2124','316',720680.80,720680.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257657',4904142,'2668','316',245805.07,245805.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257657',4904143,'2828','316',86191417.64,86191417.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257658',4904144,'2123','316',872608.75,872844.91,0.00,0.00,236.16,177120.00,0.00,0.00,0.00),('1','152','757','257658',4904145,'2124','316',720680.80,721070.44,0.00,0.00,389.64,292230.00,0.00,0.00,0.00),('1','152','757','257658',4904146,'2668','316',245805.07,245939.61,0.00,0.00,134.54,95523.40,0.00,0.00,0.00),('1','152','757','257658',4904147,'2828','316',86191417.64,86191680.21,0.00,0.00,262.57,196927.50,0.00,0.00,0.00),('1','152','757','257659',4904148,'2123','316',872844.91,873796.09,0.00,0.00,951.18,713385.00,0.00,0.00,0.00),('1','152','757','257659',4904149,'2124','316',721070.44,722142.43,0.00,0.00,1071.99,803992.50,0.00,0.00,0.00),('1','152','757','257659',4904150,'2668','316',245939.61,245994.55,0.00,0.00,54.94,39007.40,0.00,0.00,0.00),('1','152','757','257659',4904151,'2828','316',86191680.21,86192764.76,0.00,0.00,1084.55,813412.50,0.00,0.00,0.00),('1','152','757','257660',4904152,'2123','316',873796.09,874355.79,0.00,0.00,559.70,419775.00,0.00,0.00,0.00),('1','152','757','257660',4904153,'2124','316',722142.43,722991.59,0.00,0.00,849.16,636870.00,0.00,0.00,0.00),('1','152','757','257660',4904154,'2668','316',245994.55,246002.19,0.00,0.00,7.64,5424.40,0.00,0.00,0.00),('1','152','757','257660',4904155,'2828','316',86192764.76,86193672.29,0.00,0.00,907.53,680647.50,0.00,0.00,0.00),('1','152','757','257661',4904156,'2123','316',874355.79,875397.33,0.00,0.00,1041.54,781155.00,0.00,0.00,0.00),('1','152','757','257661',4904157,'2124','316',722991.59,723828.25,0.00,0.00,836.66,631245.00,0.00,0.00,0.00),('1','152','757','257661',4904158,'2668','316',246002.19,246076.69,0.00,0.00,74.50,52895.00,0.00,0.00,0.00),('1','152','757','257661',4904159,'2828','316',86193672.29,86194624.98,0.00,0.00,952.69,714517.50,0.00,0.00,0.00),('1','152','757','257662',4904160,'2123','316',875397.33,876231.99,0.00,0.00,834.66,625995.00,0.00,0.00,0.00),('1','152','757','257662',4904161,'2124','316',723828.25,724991.34,0.00,0.00,1163.09,872317.50,0.00,0.00,0.00),('1','152','757','257662',4904162,'2668','316',246076.69,247009.30,0.00,0.00,932.61,662153.10,0.00,0.00,0.00),('1','152','757','257662',4904163,'2828','316',86194624.98,86195290.09,0.00,0.00,665.11,498832.50,0.00,0.00,0.00),('1','152','757','257663',4904164,'2123','316',876231.99,876905.61,0.00,0.00,673.62,505215.00,0.00,0.00,0.00),('1','152','757','257663',4904165,'2124','316',724991.34,725728.15,0.00,0.00,736.81,552607.50,0.00,0.00,0.00),('1','152','757','257663',4904166,'2668','316',247009.30,247167.30,0.00,0.00,158.00,112180.00,0.00,0.00,0.00),('1','152','757','257663',4904167,'2828','316',86195290.09,86195927.01,0.00,0.00,636.92,477690.00,0.00,0.00,0.00),('1','152','757','257664',4904168,'2123','316',876905.61,876905.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257664',4904169,'2124','316',725728.15,725728.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257664',4904170,'2668','316',247167.30,247167.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257664',4904171,'2828','316',86195927.01,86195927.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257665',4904172,'2123','316',876905.61,877621.57,0.00,0.00,715.96,536970.00,0.00,0.00,0.00),('1','152','757','257665',4904173,'2124','316',725728.15,726696.83,0.00,0.00,968.68,726510.00,0.00,0.00,0.00),('1','152','757','257665',4904174,'2668','316',247167.30,247248.38,0.00,0.00,81.08,57566.80,0.00,0.00,0.00),('1','152','757','257665',4904175,'2828','316',86195927.01,86196770.22,0.00,0.00,843.21,632407.50,0.00,0.00,0.00),('1','152','757','257666',4904176,'2123','316',877621.57,878463.66,0.00,0.00,842.09,631567.50,0.00,0.00,0.00),('1','152','757','257666',4904177,'2124','316',726696.83,727459.89,0.00,0.00,763.06,572295.00,0.00,0.00,0.00),('1','152','757','257666',4904178,'2668','316',247248.38,247359.65,0.00,0.00,111.27,79001.70,0.00,0.00,0.00),('1','152','757','257666',4904179,'2828','316',86196770.22,86197607.01,0.00,0.00,836.79,627592.50,0.00,0.00,0.00),('1','152','757','257667',4904180,'2123','316',878463.66,879164.33,0.00,0.00,700.67,525502.50,0.00,0.00,0.00),('1','152','757','257667',4904181,'2124','316',727459.89,728309.91,0.00,0.00,850.02,637515.00,0.00,0.00,0.00),('1','152','757','257667',4904182,'2668','316',247359.65,247427.21,0.00,0.00,67.56,47967.60,0.00,0.00,0.00),('1','152','757','257667',4904183,'2828','316',86197607.01,86198441.69,0.00,0.00,834.68,626010.00,0.00,0.00,0.00),('1','152','757','257668',4904184,'2123','316',879164.33,879869.23,0.00,0.00,704.90,528675.00,0.00,0.00,0.00),('1','152','757','257668',4904185,'2124','316',728309.91,728987.67,0.00,0.00,677.76,508320.00,0.00,0.00,0.00),('1','152','757','257668',4904186,'2668','316',247427.21,247427.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257668',4904187,'2828','316',86198441.69,86199285.90,0.00,0.00,844.21,633157.50,0.00,0.00,0.00),('1','152','757','257669',4904188,'2123','316',879869.23,880672.56,0.00,0.00,803.33,602497.50,0.00,0.00,0.00),('1','152','757','257669',4904189,'2124','316',728987.67,729844.15,0.00,0.00,856.48,642360.00,0.00,0.00,0.00),('1','152','757','257669',4904190,'2668','316',247427.21,247496.71,0.00,0.00,69.50,49451.80,0.00,0.00,0.00),('1','152','757','257669',4904191,'2828','316',86199285.90,86200140.53,0.00,0.00,854.63,640972.50,0.00,0.00,0.00),('1','152','757','257670',4904192,'2123','316',880672.56,881809.48,0.00,0.00,1136.92,852690.00,0.00,0.00,0.00),('1','152','757','257670',4904193,'2124','316',729844.15,730950.09,0.00,0.00,1105.94,829455.00,0.00,0.00,0.00),('1','152','757','257670',4904194,'2668','316',247496.71,247722.98,0.00,0.00,226.27,160651.70,0.00,0.00,0.00),('1','152','757','257670',4904195,'2828','316',86200140.53,86201330.81,0.00,0.00,1190.28,892710.00,0.00,0.00,0.00),('1','152','757','257671',4904196,'2123','316',881809.48,882638.10,0.00,0.00,828.62,621465.00,0.00,0.00,0.00),('1','152','757','257671',4904197,'2124','316',730950.09,732010.32,0.00,0.00,1060.23,795172.50,0.00,0.00,0.00),('1','152','757','257671',4904198,'2668','316',247722.98,247798.48,0.00,0.00,75.50,53605.00,0.00,0.00,0.00),('1','152','757','257671',4904199,'2828','316',86201330.81,86202178.76,0.00,0.00,847.95,635962.50,0.00,0.00,0.00),('1','152','757','257672',4904200,'2123','316',882638.10,883494.23,0.00,0.00,856.13,642097.50,0.00,0.00,0.00),('1','152','757','257672',4904201,'2124','316',732010.32,732905.22,0.00,0.00,894.90,671175.00,0.00,0.00,0.00),('1','152','757','257672',4904202,'2668','316',247798.48,247908.48,0.00,0.00,110.00,78100.00,0.00,0.00,0.00),('1','152','757','257672',4904203,'2828','316',86202178.76,86203070.18,0.00,0.00,891.42,668565.00,0.00,0.00,0.00),('1','152','757','257673',4904204,'2123','316',883494.23,884455.29,0.00,0.00,961.06,720795.00,0.00,0.00,0.00),('1','152','757','257673',4904205,'2124','316',732905.22,733791.67,0.00,0.00,886.45,664837.50,0.00,0.00,0.00),('1','152','757','257673',4904206,'2668','316',247908.48,248029.09,0.00,0.00,120.61,85659.90,0.00,0.00,0.00),('1','152','757','257673',4904207,'2828','316',86203070.18,86203875.43,0.00,0.00,805.25,603937.50,0.00,0.00,0.00),('1','152','757','257674',4904208,'2123','316',884455.29,884455.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257674',4904209,'2124','316',733791.67,733791.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257674',4904210,'2668','316',248029.09,248029.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257674',4904211,'2828','316',86203875.43,86203875.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257675',4904212,'2123','316',884455.29,885343.18,0.00,0.00,887.89,665917.50,0.00,0.00,0.00),('1','152','757','257675',4904213,'2124','316',733791.67,734679.17,0.00,0.00,887.50,665625.00,0.00,0.00,0.00),('1','152','757','257675',4904214,'2668','316',248029.09,248095.09,0.00,0.00,66.00,46860.00,0.00,0.00,0.00),('1','152','757','257675',4904215,'2828','316',86203875.43,86204751.34,0.00,0.00,875.91,656932.50,0.00,0.00,0.00),('1','152','757','257676',4904216,'2123','316',885343.18,886371.34,0.00,0.00,1028.16,771120.00,0.00,0.00,0.00),('1','152','757','257676',4904217,'2124','316',734679.17,735965.29,0.00,0.00,1286.12,964590.00,0.00,0.00,0.00),('1','152','757','257676',4904218,'2668','316',248095.09,248210.09,0.00,0.00,115.00,81650.00,0.00,0.00,0.00),('1','152','757','257676',4904219,'2828','316',86204751.34,86206062.69,0.00,0.00,1311.35,983512.50,0.00,0.00,0.00),('1','152','757','257677',4904220,'2123','316',886371.34,887525.63,0.00,0.00,1154.29,865717.50,0.00,0.00,0.00),('1','152','757','257677',4904221,'2124','316',735965.29,737084.55,0.00,0.00,1119.26,839445.00,0.00,0.00,0.00),('1','152','757','257677',4904222,'2668','316',248210.09,248279.09,0.00,0.00,69.00,49470.00,0.00,0.00,0.00),('1','152','757','257677',4904223,'2828','316',86206062.69,86207245.71,0.00,0.00,1183.02,887265.00,0.00,0.00,0.00),('1','152','757','257678',4904224,'2123','316',887525.63,888862.80,0.00,0.00,1337.17,1002877.50,0.00,0.00,0.00),('1','152','757','257678',4904225,'2124','316',737084.55,738281.31,0.00,0.00,1196.76,897570.00,0.00,0.00,0.00),('1','152','757','257678',4904226,'2668','316',248279.09,248429.09,0.00,0.00,150.00,106500.00,0.00,0.00,0.00),('1','152','757','257678',4904227,'2828','316',86207245.71,86208946.13,0.00,0.00,1700.42,1275315.00,0.00,0.00,0.00),('1','152','757','257679',4904228,'2123','316',888862.80,889760.73,0.00,0.00,897.93,673447.50,0.00,0.00,0.00),('1','152','757','257679',4904229,'2124','316',738281.31,739380.76,0.00,0.00,1099.45,824587.50,0.00,0.00,0.00),('1','152','757','257679',4904230,'2668','316',248429.09,248429.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257679',4904231,'2828','316',86208946.13,86210012.95,0.00,0.00,1066.82,800115.00,0.00,0.00,0.00),('1','152','757','257680',4904232,'2123','316',889760.73,890536.87,0.00,0.00,776.14,582105.00,0.00,0.00,0.00),('1','152','757','257680',4904233,'2124','316',739380.76,740683.48,0.00,0.00,1302.72,977040.00,0.00,0.00,0.00),('1','152','757','257680',4904234,'2668','316',248429.09,248429.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257680',4904235,'2828','316',86210012.95,86210966.74,0.00,0.00,953.79,715342.50,0.00,0.00,0.00),('1','152','757','257681',4904236,'2123','316',890536.87,891783.53,0.00,0.00,1246.66,934995.00,0.00,0.00,0.00),('1','152','757','257681',4904237,'2124','316',740683.48,741895.24,0.00,0.00,1211.76,908820.00,0.00,0.00,0.00),('1','152','757','257681',4904238,'2668','316',248429.09,248601.80,0.00,0.00,172.71,122624.10,0.00,0.00,0.00),('1','152','757','257681',4904239,'2828','316',86210966.74,86212180.77,0.00,0.00,1214.03,910522.50,0.00,0.00,0.00),('1','152','757','257682',4904240,'2123','316',891783.53,891876.37,0.00,0.00,92.84,69630.00,0.00,0.00,0.00),('1','152','757','257682',4904241,'2124','316',741895.24,741999.09,0.00,0.00,103.85,77887.50,0.00,0.00,0.00),('1','152','757','257682',4904242,'2668','316',248601.80,248601.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257682',4904243,'2828','316',86212180.77,86212180.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257683',4904244,'2123','316',891876.37,891876.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257683',4904245,'2124','316',741999.09,741999.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257683',4904246,'2668','316',248601.80,248601.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257683',4904247,'2828','316',86212180.77,86212180.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257684',4904248,'2123','316',891876.37,893306.61,0.00,0.00,1430.24,1072680.00,0.00,0.00,0.00),('1','152','757','257684',4904249,'2124','316',741999.09,743353.81,0.00,0.00,1354.72,1016040.00,0.00,0.00,0.00),('1','152','757','257684',4904250,'2668','316',248601.80,248601.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257684',4904251,'2828','316',86212180.77,86213745.98,0.00,0.00,1565.21,1173907.50,0.00,0.00,0.00),('1','152','757','257685',4904252,'2123','316',893306.61,894889.45,0.00,0.00,1582.84,1187130.00,0.00,0.00,0.00),('1','152','757','257685',4904253,'2124','316',743353.81,745180.19,0.00,0.00,1826.38,1369785.00,0.00,0.00,0.00),('1','152','757','257685',4904254,'2668','316',248601.80,249194.00,0.00,0.00,592.20,420462.00,0.00,0.00,0.00),('1','152','757','257685',4904255,'2828','316',86213745.98,86215364.85,0.00,0.00,1618.87,1214152.50,0.00,0.00,0.00),('1','152','757','257686',4904256,'2123','316',894889.45,895618.99,0.00,0.00,729.54,547155.00,0.00,0.00,0.00),('1','152','757','257686',4904257,'2124','316',745180.19,746013.45,0.00,0.00,833.26,624945.00,0.00,0.00,0.00),('1','152','757','257686',4904258,'2668','316',249194.00,249544.00,0.00,0.00,350.00,248500.00,0.00,0.00,0.00),('1','152','757','257686',4904259,'2828','316',86215364.85,86216141.65,0.00,0.00,776.80,582600.00,0.00,0.00,0.00),('1','152','757','257687',4904260,'2123','316',895618.99,896333.56,0.00,0.00,714.57,535927.50,0.00,0.00,0.00),('1','152','757','257687',4904261,'2124','316',746013.45,746963.20,0.00,0.00,949.75,712312.50,0.00,0.00,0.00),('1','152','757','257687',4904262,'2668','316',249544.00,249687.00,0.00,0.00,143.00,101530.00,0.00,0.00,0.00),('1','152','757','257687',4904263,'2828','316',86216141.65,86217030.42,0.00,0.00,888.77,666577.50,0.00,0.00,0.00),('1','152','757','257688',4904264,'2123','316',896333.56,896992.90,0.00,0.00,659.34,494505.00,0.00,0.00,0.00),('1','152','757','257688',4904265,'2124','316',746963.20,747593.23,0.00,0.00,630.03,472522.50,0.00,0.00,0.00),('1','152','757','257688',4904266,'2668','316',249687.00,249744.00,0.00,0.00,57.00,40470.00,0.00,0.00,0.00),('1','152','757','257688',4904267,'2828','316',86217030.42,86217576.31,0.00,0.00,545.89,409417.50,0.00,0.00,0.00),('1','152','757','257689',4904268,'2123','316',896992.90,897651.64,0.00,0.00,658.74,494055.00,0.00,0.00,0.00),('1','152','757','257689',4904269,'2124','316',747593.23,748420.81,0.00,0.00,827.58,620685.00,0.00,0.00,0.00),('1','152','757','257689',4904270,'2668','316',249744.00,249744.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257689',4904271,'2828','316',86217576.31,86218306.40,0.00,0.00,730.09,547567.50,0.00,0.00,0.00),('1','152','757','257690',4904272,'2123','316',897651.64,898520.97,0.00,0.00,869.33,651997.50,0.00,0.00,0.00),('1','152','757','257690',4904273,'2124','316',748420.81,748879.44,0.00,0.00,458.63,343972.50,0.00,0.00,0.00),('1','152','757','257690',4904274,'2668','316',249744.00,249904.00,0.00,0.00,160.00,113600.00,0.00,0.00,0.00),('1','152','757','257690',4904275,'2828','316',86218306.40,86219236.37,0.00,0.00,929.97,697477.50,0.00,0.00,0.00),('1','152','757','257691',4904276,'2123','316',898520.97,899299.03,0.00,0.00,778.06,583545.00,0.00,0.00,0.00),('1','152','757','257691',4904277,'2124','316',748879.44,749723.86,0.00,0.00,844.42,633315.00,0.00,0.00,0.00),('1','152','757','257691',4904278,'2668','316',249904.00,249904.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257691',4904279,'2828','316',86219236.37,86220042.02,0.00,0.00,805.65,604237.50,0.00,0.00,0.00),('1','152','757','257692',4904280,'2123','316',899299.03,899559.44,0.00,0.00,260.41,195307.50,0.00,0.00,0.00),('1','152','757','257692',4904281,'2124','316',749723.86,750040.50,0.00,0.00,316.64,237480.00,0.00,0.00,0.00),('1','152','757','257692',4904282,'2668','316',249904.00,249904.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257692',4904283,'2828','316',86220042.02,86220193.55,0.00,0.00,151.53,113647.50,0.00,0.00,0.00),('1','152','757','257693',4904284,'2123','316',899559.44,900001.55,0.00,0.00,442.11,331582.50,0.00,0.00,0.00),('1','152','757','257693',4904285,'2124','316',750040.50,750433.59,0.00,0.00,393.09,294817.50,0.00,0.00,0.00),('1','152','757','257693',4904286,'2668','316',249904.00,249988.51,0.00,0.00,84.51,60002.10,0.00,0.00,0.00),('1','152','757','257693',4904287,'2828','316',86220193.55,86220697.88,0.00,0.00,504.33,378247.50,0.00,0.00,0.00),('1','152','757','257694',4904288,'2123','316',900001.55,900881.08,0.00,0.00,879.53,659647.50,0.00,0.00,0.00),('1','152','757','257694',4904289,'2124','316',750433.59,751398.77,0.00,0.00,965.18,724135.00,0.00,0.00,0.00),('1','152','757','257694',4904290,'2668','316',249988.51,250060.36,0.00,0.00,71.85,51013.50,0.00,0.00,0.00),('1','152','757','257694',4904291,'2828','316',86220697.88,86221803.42,0.00,0.00,1105.54,829155.00,0.00,0.00,0.00),('1','152','757','257695',4904292,'2123','316',900881.08,901824.19,0.00,0.00,943.11,707332.50,0.00,0.00,0.00),('1','152','757','257695',4904293,'2124','316',751398.77,752141.50,0.00,0.00,742.73,557047.50,0.00,0.00,0.00),('1','152','757','257695',4904294,'2668','316',250060.36,250510.07,0.00,0.00,449.71,319294.10,0.00,0.00,0.00),('1','152','757','257695',4904295,'2828','316',86221803.42,86222856.11,0.00,0.00,1052.69,789517.50,0.00,0.00,0.00),('1','152','757','257696',4904296,'2123','316',901824.19,902888.23,0.00,0.00,1064.04,798030.00,0.00,0.00,0.00),('1','152','757','257696',4904297,'2124','316',752141.50,753188.58,0.00,0.00,1047.08,785310.00,0.00,0.00,0.00),('1','152','757','257696',4904298,'2668','316',250510.07,250705.97,0.00,0.00,195.90,139089.00,0.00,0.00,0.00),('1','152','757','257696',4904299,'2828','316',86222856.11,86223870.70,0.00,0.00,1014.59,760942.50,0.00,0.00,0.00),('1','152','757','257697',4904300,'2123','316',902888.23,903725.53,0.00,0.00,837.30,627975.00,0.00,0.00,0.00),('1','152','757','257697',4904301,'2124','316',753188.58,754074.56,0.00,0.00,885.98,664485.00,0.00,0.00,0.00),('1','152','757','257697',4904302,'2668','316',250705.97,250839.08,0.00,0.00,133.11,94508.10,0.00,0.00,0.00),('1','152','757','257697',4904303,'2828','316',86223870.70,86224741.55,0.00,0.00,870.85,653137.50,0.00,0.00,0.00),('1','152','757','257698',4904304,'2123','316',903725.53,904105.47,0.00,0.00,379.94,284955.00,0.00,0.00,0.00),('1','152','757','257698',4904305,'2124','316',754074.56,755288.30,0.00,0.00,1213.74,910305.00,0.00,0.00,0.00),('1','152','757','257698',4904306,'2668','316',250839.08,250990.67,0.00,0.00,151.59,107628.90,0.00,0.00,0.00),('1','152','757','257698',4904307,'2828','316',86224741.55,86225827.77,0.00,0.00,1086.22,814665.00,0.00,0.00,0.00),('1','152','757','257699',4904308,'2123','316',904105.47,905005.08,0.00,0.00,899.61,674707.50,0.00,0.00,0.00),('1','152','757','257699',4904309,'2124','316',755288.30,756126.15,0.00,0.00,837.85,628387.50,0.00,0.00,0.00),('1','152','757','257699',4904310,'2668','316',250990.67,251279.58,0.00,0.00,288.91,205126.10,0.00,0.00,0.00),('1','152','757','257699',4904311,'2828','316',86225827.77,86226682.75,0.00,0.00,854.98,641235.00,0.00,0.00,0.00),('1','152','757','257700',4904312,'2123','316',905005.08,905707.12,0.00,0.00,702.04,526530.00,0.00,0.00,0.00),('1','152','757','257700',4904313,'2124','316',756126.15,756918.55,0.00,0.00,792.40,594300.00,0.00,0.00,0.00),('1','152','757','257700',4904314,'2668','316',251279.58,251547.89,0.00,0.00,268.31,190500.10,0.00,0.00,0.00),('1','152','757','257700',4904315,'2828','316',86226682.75,86227463.99,0.00,0.00,781.24,585930.00,0.00,0.00,0.00),('1','152','757','257701',4904316,'2123','316',905707.12,906602.60,0.00,0.00,895.48,671610.00,0.00,0.00,0.00),('1','152','757','257701',4904317,'2124','316',756918.55,757831.31,0.00,0.00,912.76,684570.00,0.00,0.00,0.00),('1','152','757','257701',4904318,'2668','316',251547.89,251602.89,0.00,0.00,55.00,39050.00,0.00,0.00,0.00),('1','152','757','257701',4904319,'2828','316',86227463.99,86228323.64,0.00,0.00,859.65,644737.50,0.00,0.00,0.00),('1','152','757','257702',4904320,'2123','316',906602.60,906625.60,0.00,0.00,23.00,17250.00,0.00,0.00,0.00),('1','152','757','257702',4904321,'2124','316',757831.31,757831.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257702',4904322,'2668','316',251602.89,251602.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257702',4904323,'2828','316',86228323.64,86228323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257703',4904324,'2123','316',906625.60,906625.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257703',4904325,'2124','316',757831.31,757831.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257703',4904326,'2668','316',251602.89,251602.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257703',4904327,'2828','316',86228323.64,86228323.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257704',4904328,'2123','316',906625.60,907539.37,0.00,0.00,913.77,685327.50,0.00,0.00,0.00),('1','152','757','257704',4904329,'2124','316',757831.31,758878.40,0.00,0.00,1047.09,785317.50,0.00,0.00,0.00),('1','152','757','257704',4904330,'2668','316',251602.89,252863.52,0.00,0.00,1260.63,895047.30,0.00,0.00,0.00),('1','152','757','257704',4904331,'2828','316',86228323.64,86229252.90,0.00,0.00,929.26,696945.00,0.00,0.00,0.00),('1','152','757','257705',4904332,'2123','316',907539.37,908314.82,0.00,0.00,775.45,581587.50,0.00,0.00,0.00),('1','152','757','257705',4904333,'2124','316',758878.40,759528.22,0.00,0.00,649.82,487365.00,0.00,0.00,0.00),('1','152','757','257705',4904334,'2668','316',252863.52,253004.29,0.00,0.00,140.77,99946.70,0.00,0.00,0.00),('1','152','757','257705',4904335,'2828','316',86229252.90,86229935.71,0.00,0.00,682.81,512107.50,0.00,0.00,0.00),('1','152','757','257706',4904336,'2123','316',908314.82,909219.41,0.00,0.00,904.59,678442.50,0.00,0.00,0.00),('1','152','757','257706',4904337,'2124','316',759528.22,760283.48,0.00,0.00,755.26,566445.00,0.00,0.00,0.00),('1','152','757','257706',4904338,'2668','316',253004.29,253004.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257706',4904339,'2828','316',86229935.71,86230896.81,0.00,0.00,961.10,720825.00,0.00,0.00,0.00),('1','152','757','257707',4904340,'2123','316',909219.41,909743.56,0.00,0.00,524.15,393112.50,0.00,0.00,0.00),('1','152','757','257707',4904341,'2124','316',760283.48,761029.06,0.00,0.00,745.58,559185.00,0.00,0.00,0.00),('1','152','757','257707',4904342,'2668','316',253004.29,253044.29,0.00,0.00,40.00,28400.00,0.00,0.00,0.00),('1','152','757','257707',4904343,'2828','316',86230896.81,86231908.72,0.00,0.00,1011.91,758932.50,0.00,0.00,0.00),('1','152','757','257708',4904344,'2123','316',909743.56,910444.33,0.00,0.00,700.77,525577.50,0.00,0.00,0.00),('1','152','757','257708',4904345,'2124','316',761029.06,762103.46,0.00,0.00,1074.40,805800.00,0.00,0.00,0.00),('1','152','757','257708',4904346,'2668','316',253044.29,253065.88,0.00,0.00,21.59,15328.90,0.00,0.00,0.00),('1','152','757','257708',4904347,'2828','316',86231908.72,86232947.18,0.00,0.00,1038.46,778845.00,0.00,0.00,0.00),('1','152','757','257709',4904348,'2123','316',910444.33,911058.97,0.00,0.00,614.64,460980.00,0.00,0.00,0.00),('1','152','757','257709',4904349,'2124','316',762103.46,763004.20,0.00,0.00,900.74,675555.00,0.00,0.00,0.00),('1','152','757','257709',4904350,'2668','316',253065.88,253079.52,0.00,0.00,13.64,9684.40,0.00,0.00,0.00),('1','152','757','257709',4904351,'2828','316',86232947.18,86234081.42,0.00,0.00,1134.24,850680.00,0.00,0.00,0.00),('1','152','757','257710',4904352,'2123','316',911058.97,911846.39,0.00,0.00,787.42,590565.00,0.00,0.00,0.00),('1','152','757','257710',4904353,'2124','316',763004.20,763892.01,0.00,0.00,887.81,665857.50,0.00,0.00,0.00),('1','152','757','257710',4904354,'2668','316',253079.52,253167.69,0.00,0.00,88.17,62600.70,0.00,0.00,0.00),('1','152','757','257710',4904355,'2828','316',86234081.42,86234877.35,0.00,0.00,795.93,596947.50,0.00,0.00,0.00),('1','152','757','257711',4904356,'2123','316',911846.39,912001.19,0.00,0.00,154.80,116100.00,0.00,0.00,0.00),('1','152','757','257711',4904357,'2124','316',763892.01,764049.42,0.00,0.00,157.41,118057.50,0.00,0.00,0.00),('1','152','757','257711',4904358,'2668','316',253167.69,253267.69,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','152','757','257711',4904359,'2828','316',86234877.35,86235056.53,0.00,0.00,179.18,134385.00,0.00,0.00,0.00),('1','152','757','257712',4904360,'2123','316',912001.19,913126.87,0.00,0.00,1125.68,844260.00,0.00,0.00,0.00),('1','152','757','257712',4904361,'2124','316',764049.42,765201.07,0.00,0.00,1151.65,863737.50,0.00,0.00,0.00),('1','152','757','257712',4904362,'2668','316',253267.69,253325.68,0.00,0.00,57.99,41172.90,0.00,0.00,0.00),('1','152','757','257712',4904363,'2828','316',86235056.53,86236298.92,0.00,0.00,1242.39,931792.50,0.00,0.00,0.00),('1','152','757','257713',4904364,'2123','316',913126.87,914219.31,0.00,0.00,1092.44,819330.00,0.00,0.00,0.00),('1','152','757','257713',4904365,'2124','316',765201.07,766178.28,0.00,0.00,977.21,732907.50,0.00,0.00,0.00),('1','152','757','257713',4904366,'2668','316',253325.68,253400.28,0.00,0.00,74.60,52966.00,0.00,0.00,0.00),('1','152','757','257713',4904367,'2828','316',86236298.92,86237432.88,0.00,0.00,1133.96,850470.00,0.00,0.00,0.00),('1','152','757','257714',4904368,'2123','316',914219.31,915245.49,0.00,0.00,1026.18,769635.00,0.00,0.00,0.00),('1','152','757','257714',4904369,'2124','316',766178.28,767508.73,0.00,0.00,1330.45,997837.50,0.00,0.00,0.00),('1','152','757','257714',4904370,'2668','316',253400.28,253412.78,0.00,0.00,12.50,8875.00,0.00,0.00,0.00),('1','152','757','257714',4904371,'2828','316',86237432.88,86238396.46,0.00,0.00,963.58,722685.00,0.00,0.00,0.00),('1','152','757','257715',4904372,'2123','316',915245.49,916568.78,0.00,0.00,1323.29,992467.50,0.00,0.00,0.00),('1','152','757','257715',4904373,'2124','316',767508.73,768629.23,0.00,0.00,1120.50,840375.00,0.00,0.00,0.00),('1','152','757','257715',4904374,'2668','316',253412.78,253530.92,0.00,0.00,118.14,83879.40,0.00,0.00,0.00),('1','152','757','257715',4904375,'2828','316',86238396.46,86239471.58,0.00,0.00,1075.12,806340.00,0.00,0.00,0.00),('1','152','757','257716',4904376,'2123','316',916568.78,917869.38,0.00,0.00,1300.60,975450.00,0.00,0.00,0.00),('1','152','757','257716',4904377,'2124','316',768629.23,770145.03,0.00,0.00,1515.80,1136850.00,0.00,0.00,0.00),('1','152','757','257716',4904378,'2668','316',253530.92,254291.79,0.00,0.00,760.87,540217.70,0.00,0.00,0.00),('1','152','757','257716',4904379,'2828','316',86239471.58,86240744.12,0.00,0.00,1272.54,954405.00,0.00,0.00,0.00),('1','152','757','257717',4904380,'2123','316',917869.38,918936.40,0.00,0.00,1067.02,800265.00,0.00,0.00,0.00),('1','152','757','257717',4904381,'2124','316',770145.03,771315.66,0.00,0.00,1170.63,877972.50,0.00,0.00,0.00),('1','152','757','257717',4904382,'2668','316',254291.79,254723.70,0.00,0.00,431.91,310656.10,0.00,0.00,0.00),('1','152','757','257717',4904383,'2828','316',86240744.12,86241919.83,0.00,0.00,1175.71,881782.50,0.00,0.00,0.00),('1','152','757','257718',4904384,'2123','316',918936.40,919231.69,0.00,0.00,295.29,221467.50,0.00,0.00,0.00),('1','152','757','257718',4904385,'2124','316',771315.66,771736.37,0.00,0.00,420.71,315532.50,0.00,0.00,0.00),('1','152','757','257718',4904386,'2668','316',254723.70,255030.70,0.00,0.00,307.00,217970.00,0.00,0.00,0.00),('1','152','757','257718',4904387,'2828','316',86241919.83,86242222.75,0.00,0.00,302.92,227190.00,0.00,0.00,0.00),('1','152','757','257719',4904388,'2123','316',919231.69,919231.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257719',4904389,'2124','316',771736.37,771736.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257719',4904390,'2668','316',255030.70,255030.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257719',4904391,'2828','316',86242222.75,86242222.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257720',4904392,'2123','316',919231.69,919855.96,0.00,0.00,624.27,468202.50,0.00,0.00,0.00),('1','152','757','257720',4904393,'2124','316',771736.37,772394.49,0.00,0.00,658.12,493590.00,0.00,0.00,0.00),('1','152','757','257720',4904394,'2668','316',255030.70,255238.70,0.00,0.00,208.00,147680.00,0.00,0.00,0.00),('1','152','757','257720',4904395,'2828','316',86242222.75,86242723.34,0.00,0.00,500.59,375442.50,0.00,0.00,0.00),('1','152','757','257721',4904396,'2123','316',919855.96,921071.94,0.00,0.00,1215.98,911985.00,0.00,0.00,0.00),('1','152','757','257721',4904397,'2124','316',772394.49,773634.61,0.00,0.00,1240.12,930090.00,0.00,0.00,0.00),('1','152','757','257721',4904398,'2668','316',255238.70,255620.70,0.00,0.00,382.00,271220.00,0.00,0.00,0.00),('1','152','757','257721',4904399,'2828','316',86242723.34,86243697.45,0.00,0.00,974.11,730582.50,0.00,0.00,0.00),('1','152','757','257722',4904400,'2123','316',921071.94,921071.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257722',4904401,'2124','316',773634.61,773634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257722',4904402,'2668','316',255620.70,255620.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257722',4904403,'2828','316',86243697.45,86243697.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257723',4904404,'2123','316',921071.94,922009.62,0.00,0.00,937.68,703260.00,0.00,0.00,0.00),('1','152','757','257723',4904405,'2124','316',773634.61,774859.09,0.00,0.00,1224.48,918360.00,0.00,0.00,0.00),('1','152','757','257723',4904406,'2668','316',255620.70,255658.20,0.00,0.00,37.50,27225.00,0.00,0.00,0.00),('1','152','757','257723',4904407,'2828','316',86243697.45,86244765.33,0.00,0.00,1067.88,800910.00,0.00,0.00,0.00),('1','152','757','257724',4904408,'2123','316',922009.62,922797.03,0.00,0.00,787.41,590557.50,0.00,0.00,0.00),('1','152','757','257724',4904409,'2124','316',774859.09,775527.33,0.00,0.00,668.24,501180.00,0.00,0.00,0.00),('1','152','757','257724',4904410,'2668','316',255658.20,256305.20,0.00,0.00,647.00,459370.00,0.00,0.00,0.00),('1','152','757','257724',4904411,'2828','316',86244765.33,86245249.83,0.00,0.00,484.50,363375.00,0.00,0.00,0.00),('1','152','757','257725',4904412,'2123','316',922797.03,922797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257725',4904413,'2124','316',775527.33,775527.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257725',4904414,'2668','316',256305.20,256305.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257725',4904415,'2828','316',86245249.83,86245249.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257726',4904416,'2123','316',922797.03,923003.87,0.00,0.00,206.84,159380.00,0.00,0.00,0.00),('1','152','757','257726',4904417,'2124','316',775527.33,775707.38,0.00,0.00,180.05,135037.50,0.00,0.00,0.00),('1','152','757','257726',4904418,'2668','316',256305.20,256314.20,0.00,0.00,9.00,6390.00,0.00,0.00,0.00),('1','152','757','257726',4904419,'2828','316',86245249.83,86245502.70,0.00,0.00,252.87,189652.50,0.00,0.00,0.00),('1','152','757','257727',4904420,'2123','316',923003.87,924066.67,0.00,0.00,1062.80,797100.00,0.00,0.00,0.00),('1','152','757','257727',4904421,'2124','316',775707.38,776819.30,0.00,0.00,1111.92,833940.00,0.00,0.00,0.00),('1','152','757','257727',4904422,'2668','316',256314.20,256481.83,0.00,0.00,167.63,119017.30,0.00,0.00,0.00),('1','152','757','257727',4904423,'2828','316',86245502.70,86246481.29,0.00,0.00,978.59,733942.50,0.00,0.00,0.00),('1','152','757','257728',4904424,'2123','316',924066.67,924602.85,0.00,0.00,536.18,402135.00,0.00,0.00,0.00),('1','152','757','257728',4904425,'2124','316',776819.30,777551.77,0.00,0.00,732.47,549352.50,0.00,0.00,0.00),('1','152','757','257728',4904426,'2668','316',256481.83,256681.83,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','152','757','257728',4904427,'2828','316',86246481.29,86246895.91,0.00,0.00,414.62,310965.00,0.00,0.00,0.00),('1','152','757','257729',4904428,'2123','316',924602.85,924602.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257729',4904429,'2124','316',777551.77,777551.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257729',4904430,'2668','316',256681.83,256681.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257729',4904431,'2828','316',86246895.91,86246895.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257730',4904432,'2123','316',924602.85,924832.55,0.00,0.00,229.70,172275.00,0.00,0.00,0.00),('1','152','757','257730',4904433,'2124','316',777551.77,777787.26,0.00,0.00,235.49,176617.50,0.00,0.00,0.00),('1','152','757','257730',4904434,'2668','316',256681.83,256681.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257730',4904435,'2828','316',86246895.91,86247217.27,0.00,0.00,321.36,241020.00,0.00,0.00,0.00),('1','152','757','257731',4904436,'2123','316',924832.55,924832.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257731',4904437,'2124','316',777787.26,777787.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257731',4904438,'2668','316',256681.83,256681.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257731',4904439,'2828','316',86247217.27,86247217.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257732',4904440,'2123','316',924832.55,925637.67,0.00,0.00,805.12,603840.00,0.00,0.00,0.00),('1','152','757','257732',4904441,'2124','316',777787.26,778766.48,0.00,0.00,979.22,734415.00,0.00,0.00,0.00),('1','152','757','257732',4904442,'2668','316',256681.83,256947.44,0.00,0.00,265.61,188585.90,0.00,0.00,0.00),('1','152','757','257732',4904443,'2828','316',86247217.27,86248056.76,0.00,0.00,839.49,629617.50,0.00,0.00,0.00),('1','152','757','257733',4904444,'2123','316',925637.67,926116.59,0.00,0.00,478.92,359190.00,0.00,0.00,0.00),('1','152','757','257733',4904445,'2124','316',778766.48,779303.00,0.00,0.00,536.52,402390.00,0.00,0.00,0.00),('1','152','757','257733',4904446,'2668','316',256947.44,257725.16,0.00,0.00,777.72,552181.20,0.00,0.00,0.00),('1','152','757','257733',4904447,'2828','316',86248056.76,86248517.26,0.00,0.00,460.50,345375.00,0.00,0.00,0.00),('1','152','757','257734',4904448,'2123','316',926116.59,926450.47,0.00,0.00,333.88,250410.00,0.00,0.00,0.00),('1','152','757','257734',4904449,'2124','316',779303.00,779701.62,0.00,0.00,398.62,298965.00,0.00,0.00,0.00),('1','152','757','257734',4904450,'2668','316',257725.16,257775.16,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','152','757','257734',4904451,'2828','316',86248517.26,86248865.62,0.00,0.00,348.36,261270.00,0.00,0.00,0.00),('1','152','757','257735',4904452,'2123','316',926450.47,927610.86,0.00,0.00,1160.39,870292.50,0.00,0.00,0.00),('1','152','757','257735',4904453,'2124','316',779701.62,780837.33,0.00,0.00,1135.71,851782.50,0.00,0.00,0.00),('1','152','757','257735',4904454,'2668','316',257775.16,258365.96,0.00,0.00,590.80,419468.00,0.00,0.00,0.00),('1','152','757','257735',4904455,'2828','316',86248865.62,86249868.42,0.00,0.00,1002.80,752100.00,0.00,0.00,0.00),('1','152','757','257736',4904456,'2123','316',927610.86,928224.67,0.00,0.00,613.81,460357.50,0.00,0.00,0.00),('1','152','757','257736',4904457,'2124','316',780837.33,781512.26,0.00,0.00,674.93,506197.50,0.00,0.00,0.00),('1','152','757','257736',4904458,'2668','316',258365.96,258530.79,0.00,0.00,164.83,117029.30,0.00,0.00,0.00),('1','152','757','257736',4904459,'2828','316',86249868.42,86250460.43,0.00,0.00,592.01,444007.50,0.00,0.00,0.00),('1','152','757','257737',4904460,'2123','316',928224.67,928580.72,0.00,0.00,356.05,267037.50,0.00,0.00,0.00),('1','152','757','257737',4904461,'2124','316',781512.26,781958.06,0.00,0.00,445.80,334350.00,0.00,0.00,0.00),('1','152','757','257737',4904462,'2668','316',258530.79,258630.79,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','152','757','257737',4904463,'2828','316',86250460.43,86250811.02,0.00,0.00,350.59,262942.50,0.00,0.00,0.00),('1','152','757','257738',4904464,'2123','316',928580.72,929411.34,0.00,0.00,830.62,622965.00,0.00,0.00,0.00),('1','152','757','257738',4904465,'2124','316',781958.06,782930.55,0.00,0.00,972.49,729367.50,0.00,0.00,0.00),('1','152','757','257738',4904466,'2668','316',258630.79,258901.95,0.00,0.00,271.16,192523.60,0.00,0.00,0.00),('1','152','757','257738',4904467,'2828','316',86250811.02,86251738.72,0.00,0.00,927.70,695775.00,0.00,0.00,0.00),('1','152','757','257739',4904468,'2123','316',929411.34,929872.13,0.00,0.00,460.79,345592.50,0.00,0.00,0.00),('1','152','757','257739',4904469,'2124','316',782930.55,783421.68,0.00,0.00,491.13,368347.50,0.00,0.00,0.00),('1','152','757','257739',4904470,'2668','316',258901.95,259122.95,0.00,0.00,221.00,157043.20,0.00,0.00,0.00),('1','152','757','257739',4904471,'2828','316',86251738.72,86252238.70,0.00,0.00,499.98,374985.00,0.00,0.00,0.00),('1','152','757','257740',4904472,'2123','316',929872.13,930256.15,0.00,0.00,384.02,288015.00,0.00,0.00,0.00),('1','152','757','257740',4904473,'2124','316',783421.68,783820.08,0.00,0.00,398.40,298800.00,0.00,0.00,0.00),('1','152','757','257740',4904474,'2668','316',259122.95,259191.45,0.00,0.00,68.50,48635.00,0.00,0.00,0.00),('1','152','757','257740',4904475,'2828','316',86252238.70,86252722.00,0.00,0.00,483.30,362475.00,0.00,0.00,0.00),('1','152','757','257741',4904476,'2123','316',930256.15,931093.98,0.00,0.00,837.83,628372.50,0.00,0.00,0.00),('1','152','757','257741',4904477,'2124','316',783820.08,784752.00,0.00,0.00,931.92,698460.00,0.00,0.00,0.00),('1','152','757','257741',4904478,'2668','316',259191.45,259391.45,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','152','757','257741',4904479,'2828','316',86252722.00,86253735.43,0.00,0.00,1013.43,760072.50,0.00,0.00,0.00),('1','152','757','257742',4904480,'2123','316',931093.98,931553.51,0.00,0.00,459.53,344647.50,0.00,0.00,0.00),('1','152','757','257742',4904481,'2124','316',784752.00,785198.25,0.00,0.00,446.25,334687.50,0.00,0.00,0.00),('1','152','757','257742',4904482,'2668','316',259391.45,259639.95,0.00,0.00,248.50,176435.00,0.00,0.00,0.00),('1','152','757','257742',4904483,'2828','316',86253735.43,86254152.83,0.00,0.00,417.40,313050.00,0.00,0.00,0.00),('1','152','757','257743',4904484,'2123','316',931553.51,931961.69,0.00,0.00,408.18,306135.00,0.00,0.00,0.00),('1','152','757','257743',4904485,'2124','316',785198.25,785636.51,0.00,0.00,438.26,328695.00,0.00,0.00,0.00),('1','152','757','257743',4904486,'2668','316',259639.95,259666.89,0.00,0.00,26.94,19127.40,0.00,0.00,0.00),('1','152','757','257743',4904487,'2828','316',86254152.83,86254645.87,0.00,0.00,493.04,369780.00,0.00,0.00,0.00),('1','152','757','257744',4904488,'2123','316',931961.69,932219.00,0.00,0.00,257.31,192982.50,0.00,0.00,0.00),('1','152','757','257744',4904489,'2124','316',785636.51,785920.98,0.00,0.00,284.47,213352.50,0.00,0.00,0.00),('1','152','757','257744',4904490,'2668','316',259666.89,259666.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257744',4904491,'2828','316',86254645.87,86254850.76,0.00,0.00,204.89,153667.50,0.00,0.00,0.00),('1','152','757','257745',4904492,'2123','316',932219.00,932219.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257745',4904493,'2124','316',785920.98,785920.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257745',4904494,'2668','316',259666.89,259666.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257745',4904495,'2828','316',86254850.76,86254850.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257746',4904496,'2123','316',932219.00,933047.59,0.00,0.00,828.59,621442.50,0.00,0.00,0.00),('1','152','757','257746',4904497,'2124','316',785920.98,786691.46,0.00,0.00,770.48,577860.00,0.00,0.00,0.00),('1','152','757','257746',4904498,'2668','316',259666.89,259955.83,0.00,0.00,288.94,205147.40,0.00,0.00,0.00),('1','152','757','257746',4904499,'2828','316',86254850.76,86255630.45,0.00,0.00,779.69,584767.50,0.00,0.00,0.00),('1','152','757','257747',4904500,'2123','316',933047.59,933282.69,0.00,0.00,235.10,176325.00,0.00,0.00,0.00),('1','152','757','257747',4904501,'2124','316',786691.46,786930.14,0.00,0.00,238.68,179010.00,0.00,0.00,0.00),('1','152','757','257747',4904502,'2668','316',259955.83,259998.83,0.00,0.00,43.00,30530.00,0.00,0.00,0.00),('1','152','757','257747',4904503,'2828','316',86255630.45,86255782.65,0.00,0.00,152.20,114150.00,0.00,0.00,0.00),('1','152','757','257748',4904504,'2123','316',933282.69,933988.86,0.00,0.00,706.17,529627.50,0.00,0.00,0.00),('1','152','757','257748',4904505,'2124','316',786930.14,787688.43,0.00,0.00,758.29,568717.50,0.00,0.00,0.00),('1','152','757','257748',4904506,'2668','316',259998.83,260013.24,0.00,0.00,14.41,10231.10,0.00,0.00,0.00),('1','152','757','257748',4904507,'2828','316',86255782.65,86256580.30,0.00,0.00,797.65,598237.50,0.00,0.00,0.00),('1','152','757','257749',4904508,'2123','316',933988.86,934727.53,0.00,0.00,738.67,554002.50,0.00,0.00,0.00),('1','152','757','257749',4904509,'2124','316',787688.43,788568.02,0.00,0.00,879.59,659692.50,0.00,0.00,0.00),('1','152','757','257749',4904510,'2668','316',260013.24,260590.56,0.00,0.00,577.32,409897.20,0.00,0.00,0.00),('1','152','757','257749',4904511,'2828','316',86256580.30,86257440.43,0.00,0.00,860.13,645097.50,0.00,0.00,0.00),('1','152','757','257750',4904512,'2123','316',934727.53,935632.14,0.00,0.00,904.61,678457.50,0.00,0.00,0.00),('1','152','757','257750',4904513,'2124','316',788568.02,789314.34,0.00,0.00,746.32,559740.00,0.00,0.00,0.00),('1','152','757','257750',4904514,'2668','316',260590.56,260687.86,0.00,0.00,97.30,69083.00,0.00,0.00,0.00),('1','152','757','257750',4904515,'2828','316',86257440.43,86258349.44,0.00,0.00,909.01,681757.50,0.00,0.00,0.00),('1','152','757','257751',4904516,'2123','316',935632.14,936454.56,0.00,0.00,822.42,616815.00,0.00,0.00,0.00),('1','152','757','257751',4904517,'2124','316',789314.34,790223.70,0.00,0.00,909.36,682020.00,0.00,0.00,0.00),('1','152','757','257751',4904518,'2668','316',260687.86,260800.26,0.00,0.00,112.40,79804.00,0.00,0.00,0.00),('1','152','757','257751',4904519,'2828','316',86258349.44,86259140.12,0.00,0.00,790.68,593010.00,0.00,0.00,0.00),('1','152','757','257752',4904520,'2123','316',936454.56,937377.21,0.00,0.00,922.65,691987.50,0.00,0.00,0.00),('1','152','757','257752',4904521,'2124','316',790223.70,790996.35,0.00,0.00,772.65,579487.50,0.00,0.00,0.00),('1','152','757','257752',4904522,'2668','316',260800.26,260800.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257752',4904523,'2828','316',86259140.12,86260288.41,0.00,0.00,1148.29,861217.50,0.00,0.00,0.00),('1','152','757','257753',4904524,'2123','316',937377.21,938159.56,0.00,0.00,782.35,586762.50,0.00,0.00,0.00),('1','152','757','257753',4904525,'2124','316',790996.35,791870.91,0.00,0.00,874.56,655920.00,0.00,0.00,0.00),('1','152','757','257753',4904526,'2668','316',260800.26,260800.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257753',4904527,'2828','316',86260288.41,86261306.28,0.00,0.00,1017.87,763402.50,0.00,0.00,0.00),('1','152','757','257754',4904528,'2123','316',938159.56,939200.22,0.00,0.00,1040.66,780495.00,0.00,0.00,0.00),('1','152','757','257754',4904529,'2124','316',791870.91,792857.25,0.00,0.00,986.34,739755.00,0.00,0.00,0.00),('1','152','757','257754',4904530,'2668','316',260800.26,260802.26,0.00,0.00,2.00,1420.00,0.00,0.00,0.00),('1','152','757','257754',4904531,'2828','316',86261306.28,86262234.52,0.00,0.00,928.24,696180.00,0.00,0.00,0.00),('1','152','757','257755',4904532,'2123','316',939200.22,939200.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257755',4904533,'2124','316',792857.25,792857.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257755',4904534,'2668','316',260802.26,260802.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257755',4904535,'2828','316',86262234.52,86262234.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257756',4904536,'2123','316',939200.22,940162.99,0.00,0.00,962.77,722077.50,0.00,0.00,0.00),('1','152','757','257756',4904537,'2124','316',792857.25,793893.93,0.00,0.00,1036.68,777510.00,0.00,0.00,0.00),('1','152','757','257756',4904538,'2668','316',260802.26,260802.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257756',4904539,'2828','316',86262234.52,86263583.43,0.00,0.00,1348.91,1011682.50,0.00,0.00,0.00),('1','152','757','257757',4904540,'2123','316',940162.99,940975.07,0.00,0.00,812.08,609060.00,0.00,0.00,0.00),('1','152','757','257757',4904541,'2124','316',793893.93,794816.92,0.00,0.00,922.99,692242.50,0.00,0.00,0.00),('1','152','757','257757',4904542,'2668','316',260802.26,260802.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257757',4904543,'2828','316',86263583.43,86264403.60,0.00,0.00,820.17,615127.50,0.00,0.00,0.00),('1','152','757','257758',4904544,'2123','316',940975.07,941879.87,0.00,0.00,904.80,678600.00,0.00,0.00,0.00),('1','152','757','257758',4904545,'2124','316',794816.92,795970.55,0.00,0.00,1153.63,865222.50,0.00,0.00,0.00),('1','152','757','257758',4904546,'2668','316',260802.26,260802.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257758',4904547,'2828','316',86264403.60,86265793.87,0.00,0.00,1390.27,1042702.50,0.00,0.00,0.00),('1','152','757','257759',4904548,'2123','316',941879.87,942842.09,0.00,0.00,962.22,721665.00,0.00,0.00,0.00),('1','152','757','257759',4904549,'2124','316',795970.55,796965.44,0.00,0.00,994.89,746167.50,0.00,0.00,0.00),('1','152','757','257759',4904550,'2668','316',260802.26,260902.26,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','152','757','257759',4904551,'2828','316',86265793.87,86266775.40,0.00,0.00,981.53,736147.50,0.00,0.00,0.00),('1','152','757','257760',4904552,'2123','316',942842.09,943998.73,0.00,0.00,1156.64,867480.00,0.00,0.00,0.00),('1','152','757','257760',4904553,'2124','316',796965.44,798185.77,0.00,0.00,1220.33,915247.50,0.00,0.00,0.00),('1','152','757','257760',4904554,'2668','316',260902.26,260902.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257760',4904555,'2828','316',86266775.40,86268184.80,0.00,0.00,1409.40,1057050.00,0.00,0.00,0.00),('1','152','757','257761',4904556,'2123','316',943998.73,945241.60,0.00,0.00,1242.87,932152.50,0.00,0.00,0.00),('1','152','757','257761',4904557,'2124','316',798185.77,799265.65,0.00,0.00,1079.88,809910.00,0.00,0.00,0.00),('1','152','757','257761',4904558,'2668','316',260902.26,261092.25,0.00,0.00,189.99,134892.90,0.00,0.00,0.00),('1','152','757','257761',4904559,'2828','316',86268184.80,86269179.08,0.00,0.00,994.28,745710.00,0.00,0.00,0.00),('1','152','757','257762',4904560,'2123','316',945241.60,946417.78,0.00,0.00,1176.18,882135.00,0.00,0.00,0.00),('1','152','757','257762',4904561,'2124','316',799265.65,800616.73,0.00,0.00,1351.08,1013310.00,0.00,0.00,0.00),('1','152','757','257762',4904562,'2668','316',261092.25,261262.25,0.00,0.00,170.00,120700.00,0.00,0.00,0.00),('1','152','757','257762',4904563,'2828','316',86269179.08,86270503.77,0.00,0.00,1324.69,993517.50,0.00,0.00,0.00),('1','152','757','257763',4904564,'2123','316',946417.78,946926.29,0.00,0.00,508.51,381382.50,0.00,0.00,0.00),('1','152','757','257763',4904565,'2124','316',800616.73,801075.64,0.00,0.00,458.91,344182.50,0.00,0.00,0.00),('1','152','757','257763',4904566,'2668','316',261262.25,261322.25,0.00,0.00,60.00,42600.00,0.00,0.00,0.00),('1','152','757','257763',4904567,'2828','316',86270503.77,86270960.51,0.00,0.00,456.74,342555.00,0.00,0.00,0.00),('1','152','757','257764',4904568,'2123','316',946926.29,946926.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257764',4904569,'2124','316',801075.64,801075.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257764',4904570,'2668','316',261322.25,261322.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257764',4904571,'2828','316',86270960.51,86270960.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257765',4904572,'2123','316',946926.29,947932.99,0.00,0.00,1006.70,755025.00,0.00,0.00,0.00),('1','152','757','257765',4904573,'2124','316',801075.64,802088.85,0.00,0.00,1013.21,759907.50,0.00,0.00,0.00),('1','152','757','257765',4904574,'2668','316',261322.25,261322.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257765',4904575,'2828','316',86270960.51,86271838.56,0.00,0.00,878.05,658537.50,0.00,0.00,0.00),('1','152','757','257766',4904576,'2123','316',947932.99,949235.15,0.00,0.00,1302.16,976620.00,0.00,0.00,0.00),('1','152','757','257766',4904577,'2124','316',802088.85,803219.11,0.00,0.00,1130.26,847695.00,0.00,0.00,0.00),('1','152','757','257766',4904578,'2668','316',261322.25,261322.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257766',4904579,'2828','316',86271838.56,86272780.84,0.00,0.00,942.28,706710.00,0.00,0.00,0.00),('1','152','757','257767',4904580,'2123','316',949235.15,949672.31,0.00,0.00,437.16,327870.00,0.00,0.00,0.00),('1','152','757','257767',4904581,'2124','316',803219.11,803792.62,0.00,0.00,573.51,430132.50,0.00,0.00,0.00),('1','152','757','257767',4904582,'2668','316',261322.25,261322.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257767',4904583,'2828','316',86272780.84,86273172.21,0.00,0.00,391.37,293527.50,0.00,0.00,0.00),('1','152','757','257768',4904584,'2123','316',949672.31,950229.12,0.00,0.00,556.81,417607.50,0.00,0.00,0.00),('1','152','757','257768',4904585,'2124','316',803792.62,804378.99,0.00,0.00,586.37,439777.50,0.00,0.00,0.00),('1','152','757','257768',4904586,'2668','316',261322.25,261552.25,0.00,0.00,230.00,163300.00,0.00,0.00,0.00),('1','152','757','257768',4904587,'2828','316',86273172.21,86273705.95,0.00,0.00,533.74,400305.00,0.00,0.00,0.00),('1','152','757','257769',4904588,'2123','316',950229.12,951219.31,0.00,0.00,990.19,742642.50,0.00,0.00,0.00),('1','152','757','257769',4904589,'2124','316',804378.99,805796.27,0.00,0.00,1417.28,1062960.00,0.00,0.00,0.00),('1','152','757','257769',4904590,'2668','316',261552.25,261687.25,0.00,0.00,135.00,95850.00,0.00,0.00,0.00),('1','152','757','257769',4904591,'2828','316',86273705.95,86274799.28,0.00,0.00,1093.33,819997.50,0.00,0.00,0.00),('1','152','757','257770',4904592,'2123','316',951219.31,951330.10,0.00,0.00,110.79,83092.50,0.00,0.00,0.00),('1','152','757','257770',4904593,'2124','316',805796.27,805852.18,0.00,0.00,55.91,41932.50,0.00,0.00,0.00),('1','152','757','257770',4904594,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257770',4904595,'2828','316',86274799.28,86274846.41,0.00,0.00,47.13,35347.50,0.00,0.00,0.00),('1','152','757','257771',4904596,'2123','316',951330.10,952105.27,0.00,0.00,775.17,581377.50,0.00,0.00,0.00),('1','152','757','257771',4904597,'2124','316',805852.18,806619.49,0.00,0.00,767.31,575482.50,0.00,0.00,0.00),('1','152','757','257771',4904598,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257771',4904599,'2828','316',86274846.41,86275472.41,0.00,0.00,626.00,469500.00,0.00,0.00,0.00),('1','152','757','257772',4904600,'2123','316',952105.27,953062.68,0.00,0.00,957.41,718057.50,0.00,0.00,0.00),('1','152','757','257772',4904601,'2124','316',806619.49,807630.62,0.00,0.00,1011.13,758347.50,0.00,0.00,0.00),('1','152','757','257772',4904602,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257772',4904603,'2828','316',86275472.41,86276482.29,0.00,0.00,1009.88,757410.00,0.00,0.00,0.00),('1','152','757','257773',4904604,'2123','316',953062.68,953238.39,0.00,0.00,175.71,131782.50,0.00,0.00,0.00),('1','152','757','257773',4904605,'2124','316',807630.62,807904.03,0.00,0.00,273.41,205057.50,0.00,0.00,0.00),('1','152','757','257773',4904606,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257773',4904607,'2828','316',86276482.29,86276694.87,0.00,0.00,212.58,159435.00,0.00,0.00,0.00),('1','152','757','257774',4904608,'2123','316',953238.39,954085.33,0.00,0.00,846.94,635205.00,0.00,0.00,0.00),('1','152','757','257774',4904609,'2124','316',807904.03,808803.61,0.00,0.00,899.58,674685.00,0.00,0.00,0.00),('1','152','757','257774',4904610,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257774',4904611,'2828','316',86276694.87,86277488.15,0.00,0.00,793.28,594960.00,0.00,0.00,0.00),('1','152','757','257775',4904612,'2123','316',954085.33,954244.04,0.00,0.00,158.71,119032.50,0.00,0.00,0.00),('1','152','757','257775',4904613,'2124','316',808803.61,809116.48,0.00,0.00,312.87,234652.50,0.00,0.00,0.00),('1','152','757','257775',4904614,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257775',4904615,'2828','316',86277488.15,86277585.92,0.00,0.00,97.77,73327.50,0.00,0.00,0.00),('1','152','757','257776',4904616,'2123','316',954244.04,954244.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257776',4904617,'2124','316',809116.48,809116.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257776',4904618,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257776',4904619,'2828','316',86277585.92,86277585.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257777',4904620,'2123','316',954244.04,955154.37,0.00,0.00,910.33,682747.50,0.00,0.00,0.00),('1','152','757','257777',4904621,'2124','316',809116.48,810117.16,0.00,0.00,1000.68,750510.00,0.00,0.00,0.00),('1','152','757','257777',4904622,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257777',4904623,'2828','316',86277585.92,86278433.24,0.00,0.00,847.32,635490.00,0.00,0.00,0.00),('1','152','757','257778',4904624,'2123','316',955154.37,956129.33,0.00,0.00,974.96,731220.00,0.00,0.00,0.00),('1','152','757','257778',4904625,'2124','316',810117.16,810957.29,0.00,0.00,840.13,630097.50,0.00,0.00,0.00),('1','152','757','257778',4904626,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257778',4904627,'2828','316',86278433.24,86279346.63,0.00,0.00,913.39,685042.50,0.00,0.00,0.00),('1','152','757','257779',4904628,'2123','316',956129.33,956255.60,0.00,0.00,126.27,94702.50,0.00,0.00,0.00),('1','152','757','257779',4904629,'2124','316',810957.29,811113.41,0.00,0.00,156.12,117090.00,0.00,0.00,0.00),('1','152','757','257779',4904630,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257779',4904631,'2828','316',86279346.63,86279461.04,0.00,0.00,114.41,85807.50,0.00,0.00,0.00),('1','152','757','257780',4904632,'2123','316',956255.60,957081.53,0.00,0.00,825.93,619447.50,0.00,0.00,0.00),('1','152','757','257780',4904633,'2124','316',811113.41,812070.23,0.00,0.00,956.82,717615.00,0.00,0.00,0.00),('1','152','757','257780',4904634,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257780',4904635,'2828','316',86279461.04,86280321.03,0.00,0.00,859.99,644992.50,0.00,0.00,0.00),('1','152','757','257781',4904636,'2123','316',957081.53,957172.63,0.00,0.00,91.10,68325.00,0.00,0.00,0.00),('1','152','757','257781',4904637,'2124','316',812070.23,812172.28,0.00,0.00,102.05,76537.50,0.00,0.00,0.00),('1','152','757','257781',4904638,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257781',4904639,'2828','316',86280321.03,86280382.12,0.00,0.00,61.09,45817.50,0.00,0.00,0.00),('1','152','757','257782',4904640,'2123','316',957172.63,957172.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257782',4904641,'2124','316',812172.28,812172.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257782',4904642,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257782',4904643,'2828','316',86280382.12,86280382.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257783',4904644,'2123','316',957172.63,957187.71,0.00,0.00,15.08,11310.00,0.00,0.00,0.00),('1','152','757','257783',4904645,'2124','316',812172.28,812184.03,0.00,0.00,11.75,8812.50,0.00,0.00,0.00),('1','152','757','257783',4904646,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257783',4904647,'2828','316',86280382.12,86280388.72,0.00,0.00,6.60,4950.00,0.00,0.00,0.00),('1','152','757','257784',4904648,'2123','316',957187.71,957634.32,0.00,0.00,446.61,334957.50,0.00,0.00,0.00),('1','152','757','257784',4904649,'2124','316',812184.03,812624.92,0.00,0.00,440.89,330667.50,0.00,0.00,0.00),('1','152','757','257784',4904650,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257784',4904651,'2828','316',86280388.72,86280869.35,0.00,0.00,480.63,360472.50,0.00,0.00,0.00),('1','152','757','257785',4904652,'2123','316',957634.32,958444.10,0.00,0.00,809.78,607335.00,0.00,0.00,0.00),('1','152','757','257785',4904653,'2124','316',812624.92,813535.39,0.00,0.00,910.47,682852.50,0.00,0.00,0.00),('1','152','757','257785',4904654,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257785',4904655,'2828','316',86280869.35,86281625.66,0.00,0.00,756.31,567232.50,0.00,0.00,0.00),('1','152','757','257786',4904656,'2123','316',958444.10,959072.05,0.00,0.00,627.95,470962.50,0.00,0.00,0.00),('1','152','757','257786',4904657,'2124','316',813535.39,814235.75,0.00,0.00,700.36,525270.00,0.00,0.00,0.00),('1','152','757','257786',4904658,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257786',4904659,'2828','316',86281625.66,86282258.69,0.00,0.00,633.03,474772.50,0.00,0.00,0.00),('1','152','757','257787',4904660,'2123','316',959072.05,959280.90,0.00,0.00,208.85,156637.50,0.00,0.00,0.00),('1','152','757','257787',4904661,'2124','316',814235.75,814451.44,0.00,0.00,215.69,161767.50,0.00,0.00,0.00),('1','152','757','257787',4904662,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257787',4904663,'2828','316',86282258.69,86282531.16,0.00,0.00,272.47,204352.50,0.00,0.00,0.00),('1','152','757','257788',4904664,'2123','316',959280.90,959801.92,0.00,0.00,521.02,390765.00,0.00,0.00,0.00),('1','152','757','257788',4904665,'2124','316',814451.44,814879.71,0.00,0.00,428.27,321202.50,0.00,0.00,0.00),('1','152','757','257788',4904666,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257788',4904667,'2828','316',86282531.16,86282853.20,0.00,0.00,322.04,241530.00,0.00,0.00,0.00),('1','152','757','257789',4904668,'2123','316',959801.92,960754.27,0.00,0.00,952.35,714262.50,0.00,0.00,0.00),('1','152','757','257789',4904669,'2124','316',814879.71,815957.04,0.00,0.00,1077.33,807997.50,0.00,0.00,0.00),('1','152','757','257789',4904670,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257789',4904671,'2828','316',86282853.20,86283786.06,0.00,0.00,932.86,699645.00,0.00,0.00,0.00),('1','152','757','257790',4904672,'2123','316',960754.27,960908.05,0.00,0.00,153.78,115335.00,0.00,0.00,0.00),('1','152','757','257790',4904673,'2124','316',815957.04,816174.11,0.00,0.00,217.07,162802.50,0.00,0.00,0.00),('1','152','757','257790',4904674,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257790',4904675,'2828','316',86283786.06,86283879.34,0.00,0.00,93.28,69960.00,0.00,0.00,0.00),('1','152','757','257791',4904676,'2123','316',960908.05,961741.61,0.00,0.00,833.56,625170.00,0.00,0.00,0.00),('1','152','757','257791',4904677,'2124','316',816174.11,816902.39,0.00,0.00,728.28,546210.00,0.00,0.00,0.00),('1','152','757','257791',4904678,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257791',4904679,'2828','316',86283879.34,86284636.31,0.00,0.00,756.97,567727.50,0.00,0.00,0.00),('1','152','757','257792',4904680,'2123','316',961741.61,962653.13,0.00,0.00,911.52,683640.00,0.00,0.00,0.00),('1','152','757','257792',4904681,'2124','316',816902.39,817773.28,0.00,0.00,870.89,653167.50,0.00,0.00,0.00),('1','152','757','257792',4904682,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257792',4904683,'2828','316',86284636.31,86285377.98,0.00,0.00,741.67,556252.50,0.00,0.00,0.00),('1','152','757','257793',4904684,'2123','316',962653.13,962970.01,0.00,0.00,316.88,237660.00,0.00,0.00,0.00),('1','152','757','257793',4904685,'2124','316',817773.28,818135.54,0.00,0.00,362.26,271695.00,0.00,0.00,0.00),('1','152','757','257793',4904686,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257793',4904687,'2828','316',86285377.98,86285746.13,0.00,0.00,368.15,276112.50,0.00,0.00,0.00),('1','152','757','257794',4904688,'2123','316',962970.01,963392.59,0.00,0.00,422.58,316935.00,0.00,0.00,0.00),('1','152','757','257794',4904689,'2124','316',818135.54,818668.72,0.00,0.00,533.18,399885.00,0.00,0.00,0.00),('1','152','757','257794',4904690,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257794',4904691,'2828','316',86285746.13,86286183.55,0.00,0.00,437.42,328065.00,0.00,0.00,0.00),('1','152','757','257795',4904692,'2123','316',963392.59,963493.36,0.00,0.00,100.77,75577.50,0.00,0.00,0.00),('1','152','757','257795',4904693,'2124','316',818668.72,818702.04,0.00,0.00,33.32,24990.00,0.00,0.00,0.00),('1','152','757','257795',4904694,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257795',4904695,'2828','316',86286183.55,86286270.48,0.00,0.00,86.93,65197.50,0.00,0.00,0.00),('1','152','757','257796',4904696,'2123','316',963493.36,964203.52,0.00,0.00,710.16,532620.00,0.00,0.00,0.00),('1','152','757','257796',4904697,'2124','316',818702.04,819356.80,0.00,0.00,654.76,491070.00,0.00,0.00,0.00),('1','152','757','257796',4904698,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257796',4904699,'2828','316',86286270.48,86286885.82,0.00,0.00,615.34,461505.00,0.00,0.00,0.00),('1','152','757','257797',4904700,'2123','316',964203.52,965082.01,0.00,0.00,878.49,658867.50,0.00,0.00,0.00),('1','152','757','257797',4904701,'2124','316',819356.80,820284.20,0.00,0.00,927.40,695550.00,0.00,0.00,0.00),('1','152','757','257797',4904702,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257797',4904703,'2828','316',86286885.82,86287792.12,0.00,0.00,906.30,679725.00,0.00,0.00,0.00),('1','152','757','257798',4904704,'2123','316',965082.01,965455.04,0.00,0.00,373.03,279772.50,0.00,0.00,0.00),('1','152','757','257798',4904705,'2124','316',820284.20,820683.58,0.00,0.00,399.38,299535.00,0.00,0.00,0.00),('1','152','757','257798',4904706,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257798',4904707,'2828','316',86287792.12,86288179.19,0.00,0.00,387.07,290302.50,0.00,0.00,0.00),('1','152','757','257799',4904708,'2123','316',965455.04,966094.66,0.00,0.00,639.62,479715.00,0.00,0.00,0.00),('1','152','757','257799',4904709,'2124','316',820683.58,821391.43,0.00,0.00,707.85,530887.50,0.00,0.00,0.00),('1','152','757','257799',4904710,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257799',4904711,'2828','316',86288179.19,86289037.08,0.00,0.00,857.89,643417.50,0.00,0.00,0.00),('1','152','757','257800',4904712,'2123','316',966094.66,966895.25,0.00,0.00,800.59,600442.50,0.00,0.00,0.00),('1','152','757','257800',4904713,'2124','316',821391.43,822322.59,0.00,0.00,931.16,698370.00,0.00,0.00,0.00),('1','152','757','257800',4904714,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257800',4904715,'2828','316',86289037.08,86289962.00,0.00,0.00,924.92,693690.00,0.00,0.00,0.00),('1','152','757','257801',4904716,'2123','316',966895.25,967282.42,0.00,0.00,387.17,290377.50,0.00,0.00,0.00),('1','152','757','257801',4904717,'2124','316',822322.59,822595.29,0.00,0.00,272.70,204525.00,0.00,0.00,0.00),('1','152','757','257801',4904718,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257801',4904719,'2828','316',86289962.00,86290255.42,0.00,0.00,293.42,220065.00,0.00,0.00,0.00),('1','152','757','257802',4904720,'2123','316',967282.42,968052.86,0.00,0.00,770.44,577830.00,0.00,0.00,0.00),('1','152','757','257802',4904721,'2124','316',822595.29,823173.70,0.00,0.00,578.41,433807.50,0.00,0.00,0.00),('1','152','757','257802',4904722,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257802',4904723,'2828','316',86290255.42,86290852.94,0.00,0.00,597.52,448140.00,0.00,0.00,0.00),('1','152','757','257803',4904724,'2123','316',968052.86,968529.55,0.00,0.00,476.69,357517.50,0.00,0.00,0.00),('1','152','757','257803',4904725,'2124','316',823173.70,823648.43,0.00,0.00,474.73,356047.50,0.00,0.00,0.00),('1','152','757','257803',4904726,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257803',4904727,'2828','316',86290852.94,86291207.21,0.00,0.00,354.27,265702.50,0.00,0.00,0.00),('1','152','757','257804',4904728,'2123','316',968529.55,969021.75,0.00,0.00,492.20,369150.00,0.00,0.00,0.00),('1','152','757','257804',4904729,'2124','316',823648.43,824080.91,0.00,0.00,432.48,324360.00,0.00,0.00,0.00),('1','152','757','257804',4904730,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257804',4904731,'2828','316',86291207.21,86291640.65,0.00,0.00,433.44,325080.00,0.00,0.00,0.00),('1','152','757','257805',4904732,'2123','316',969021.75,969981.85,0.00,0.00,960.10,720075.00,0.00,0.00,0.00),('1','152','757','257805',4904733,'2124','316',824080.91,824922.31,0.00,0.00,841.40,631550.00,0.00,0.00,0.00),('1','152','757','257805',4904734,'2668','316',261687.25,261687.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257805',4904735,'2828','316',86291640.65,86292491.14,0.00,0.00,850.49,637867.50,0.00,0.00,0.00),('1','152','757','257806',4904736,'2123','316',969981.85,971366.47,0.00,0.00,1384.62,1038465.00,0.00,0.00,0.00),('1','152','757','257806',4904737,'2124','316',824922.31,826188.50,0.00,0.00,1266.19,949642.50,0.00,0.00,0.00),('1','152','757','257806',4904738,'2668','316',261687.25,261987.25,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','152','757','257806',4904739,'2828','316',86292491.14,86293691.68,0.00,0.00,1200.54,900405.00,0.00,0.00,0.00),('1','152','757','257807',4904740,'2123','316',971366.47,972757.03,0.00,0.00,1390.56,1042920.00,0.00,0.00,0.00),('1','152','757','257807',4904741,'2124','316',826188.50,827443.66,0.00,0.00,1255.16,941370.00,0.00,0.00,0.00),('1','152','757','257807',4904742,'2668','316',261987.25,261987.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257807',4904743,'2828','316',86293691.68,86294856.94,0.00,0.00,1165.26,873945.00,0.00,0.00,0.00),('1','152','757','257808',4904744,'2123','316',972757.03,974133.13,0.00,0.00,1376.10,1032075.00,0.00,0.00,0.00),('1','152','757','257808',4904745,'2124','316',827443.66,828512.77,0.00,0.00,1069.11,801832.50,0.00,0.00,0.00),('1','152','757','257808',4904746,'2668','316',261987.25,262051.25,0.00,0.00,64.00,45440.00,0.00,0.00,0.00),('1','152','757','257808',4904747,'2828','316',86294856.94,86296005.44,0.00,0.00,1148.50,861375.00,0.00,0.00,0.00),('1','152','757','257809',4904748,'2123','316',974133.13,975225.72,0.00,0.00,1092.59,819442.50,0.00,0.00,0.00),('1','152','757','257809',4904749,'2124','316',828512.77,829651.24,0.00,0.00,1138.47,853852.50,0.00,0.00,0.00),('1','152','757','257809',4904750,'2668','316',262051.25,262346.25,0.00,0.00,295.00,209450.00,0.00,0.00,0.00),('1','152','757','257809',4904751,'2828','316',86296005.44,86297034.25,0.00,0.00,1028.81,771607.50,0.00,0.00,0.00),('1','152','757','257810',4904752,'2123','316',975225.72,976299.61,0.00,0.00,1073.89,805417.50,0.00,0.00,0.00),('1','152','757','257810',4904753,'2124','316',829651.24,830647.01,0.00,0.00,995.77,746827.50,0.00,0.00,0.00),('1','152','757','257810',4904754,'2668','316',262346.25,263152.25,0.00,0.00,806.00,572260.00,0.00,0.00,0.00),('1','152','757','257810',4904755,'2828','316',86297034.25,86297957.36,0.00,0.00,923.11,692332.50,0.00,0.00,0.00),('1','152','757','257811',4904756,'2123','316',976299.61,976815.60,0.00,0.00,515.99,386992.50,0.00,0.00,0.00),('1','152','757','257811',4904757,'2124','316',830647.01,831232.05,0.00,0.00,585.04,438780.00,0.00,0.00,0.00),('1','152','757','257811',4904758,'2668','316',263152.25,263252.25,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','152','757','257811',4904759,'2828','316',86297957.36,86298380.27,0.00,0.00,422.91,317182.50,0.00,0.00,0.00),('1','152','757','257812',4904760,'2123','316',976815.60,976815.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257812',4904761,'2124','316',831232.05,831232.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257812',4904762,'2668','316',263252.25,263252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257812',4904763,'2828','316',86298380.27,86298380.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257813',4904764,'2123','316',976815.60,977169.82,0.00,0.00,354.22,265665.00,0.00,0.00,0.00),('1','152','757','257813',4904765,'2124','316',831232.05,831619.37,0.00,0.00,387.32,290490.00,0.00,0.00,0.00),('1','152','757','257813',4904766,'2668','316',263252.25,263252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257813',4904767,'2828','316',86298380.27,86298743.80,0.00,0.00,363.53,272647.50,0.00,0.00,0.00),('1','152','757','257814',4904768,'2123','316',977169.82,978256.36,0.00,0.00,1086.54,814905.00,0.00,0.00,0.00),('1','152','757','257814',4904769,'2124','316',831619.37,833011.80,0.00,0.00,1392.43,1044322.50,0.00,0.00,0.00),('1','152','757','257814',4904770,'2668','316',263252.25,263252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257814',4904771,'2828','316',86298743.80,86299920.67,0.00,0.00,1176.87,882652.50,0.00,0.00,0.00),('1','152','757','257815',4904772,'2123','316',978256.36,978497.20,0.00,0.00,240.84,180630.00,0.00,0.00,0.00),('1','152','757','257815',4904773,'2124','316',833011.80,833395.18,0.00,0.00,383.38,287535.00,0.00,0.00,0.00),('1','152','757','257815',4904774,'2668','316',263252.25,263252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257815',4904775,'2828','316',86299920.67,86300261.49,0.00,0.00,340.82,255615.00,0.00,0.00,0.00),('1','152','757','257816',4904776,'2123','316',978497.20,979193.74,0.00,0.00,696.54,522405.00,0.00,0.00,0.00),('1','152','757','257816',4904777,'2124','316',833395.18,834126.46,0.00,0.00,731.28,548460.00,0.00,0.00,0.00),('1','152','757','257816',4904778,'2668','316',263252.25,263652.25,0.00,0.00,400.00,284000.00,0.00,0.00,0.00),('1','152','757','257816',4904779,'2828','316',86300261.49,86300870.78,0.00,0.00,609.29,456967.50,0.00,0.00,0.00),('1','152','757','257817',4904780,'2123','316',979193.74,979316.52,0.00,0.00,122.78,92085.00,0.00,0.00,0.00),('1','152','757','257817',4904781,'2124','316',834126.46,834268.11,0.00,0.00,141.65,106237.50,0.00,0.00,0.00),('1','152','757','257817',4904782,'2668','316',263652.25,263652.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257817',4904783,'2828','316',86300870.78,86300971.47,0.00,0.00,100.69,75517.50,0.00,0.00,0.00),('1','152','757','257818',4904784,'2123','316',979316.52,980156.68,0.00,0.00,840.16,630120.00,0.00,0.00,0.00),('1','152','757','257818',4904785,'2124','316',834268.11,835344.82,0.00,0.00,1076.71,807532.50,0.00,0.00,0.00),('1','152','757','257818',4904786,'2668','316',263652.25,263652.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257818',4904787,'2828','316',86300971.47,86301819.51,0.00,0.00,848.04,636030.00,0.00,0.00,0.00),('1','152','757','257819',4904788,'2123','316',980156.68,981123.56,0.00,0.00,966.88,725160.00,0.00,0.00,0.00),('1','152','757','257819',4904789,'2124','316',835344.82,836280.81,0.00,0.00,935.99,701992.50,0.00,0.00,0.00),('1','152','757','257819',4904790,'2668','316',263652.25,264211.75,0.00,0.00,559.50,397245.00,0.00,0.00,0.00),('1','152','757','257819',4904791,'2828','316',86301819.51,86302599.02,0.00,0.00,779.51,584632.50,0.00,0.00,0.00),('1','152','757','257820',4904792,'2123','316',981123.56,981538.68,0.00,0.00,415.12,311340.00,0.00,0.00,0.00),('1','152','757','257820',4904793,'2124','316',836280.81,836661.68,0.00,0.00,380.87,285652.50,0.00,0.00,0.00),('1','152','757','257820',4904794,'2668','316',264211.75,264211.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257820',4904795,'2828','316',86302599.02,86303020.07,0.00,0.00,421.05,315787.50,0.00,0.00,0.00),('1','152','757','257821',4904796,'2123','316',981538.68,982626.65,0.00,0.00,1087.97,815977.50,0.00,0.00,0.00),('1','152','757','257821',4904797,'2124','316',836661.68,837618.14,0.00,0.00,956.46,717345.00,0.00,0.00,0.00),('1','152','757','257821',4904798,'2668','316',264211.75,264312.75,0.00,0.00,101.00,71710.00,0.00,0.00,0.00),('1','152','757','257821',4904799,'2828','316',86303020.07,86304217.64,0.00,0.00,1197.57,898177.50,0.00,0.00,0.00),('1','152','757','257822',4904800,'2123','316',982626.65,983042.01,0.00,0.00,415.36,311520.00,0.00,0.00,0.00),('1','152','757','257822',4904801,'2124','316',837618.14,838041.47,0.00,0.00,423.33,317497.50,0.00,0.00,0.00),('1','152','757','257822',4904802,'2668','316',264312.75,264312.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257822',4904803,'2828','316',86304217.64,86304590.61,0.00,0.00,372.97,279727.50,0.00,0.00,0.00),('1','152','757','257823',4904804,'2123','316',983042.01,983661.07,0.00,0.00,619.06,464295.00,0.00,0.00,0.00),('1','152','757','257823',4904805,'2124','316',838041.47,838641.07,0.00,0.00,599.60,449700.00,0.00,0.00,0.00),('1','152','757','257823',4904806,'2668','316',264312.75,264566.75,0.00,0.00,254.00,180340.00,0.00,0.00,0.00),('1','152','757','257823',4904807,'2828','316',86304590.61,86305281.89,0.00,0.00,691.28,518460.00,0.00,0.00,0.00),('1','152','757','257824',4904808,'2123','316',983661.07,984570.54,0.00,0.00,909.47,682102.50,0.00,0.00,0.00),('1','152','757','257824',4904809,'2124','316',838641.07,839584.05,0.00,0.00,942.98,707235.00,0.00,0.00,0.00),('1','152','757','257824',4904810,'2668','316',264566.75,265016.75,0.00,0.00,450.00,319500.00,0.00,0.00,0.00),('1','152','757','257824',4904811,'2828','316',86305281.89,86306159.96,0.00,0.00,878.07,658552.50,0.00,0.00,0.00),('1','152','757','257825',4904812,'2123','316',984570.54,984697.16,0.00,0.00,126.62,94965.00,0.00,0.00,0.00),('1','152','757','257825',4904813,'2124','316',839584.05,839704.05,0.00,0.00,120.00,90000.00,0.00,0.00,0.00),('1','152','757','257825',4904814,'2668','316',265016.75,265266.75,0.00,0.00,250.00,177500.00,0.00,0.00,0.00),('1','152','757','257825',4904815,'2828','316',86306159.96,86306204.16,0.00,0.00,44.20,33150.00,0.00,0.00,0.00),('1','152','757','257826',4904816,'2123','316',984697.16,985732.06,0.00,0.00,1034.90,776175.00,0.00,0.00,0.00),('1','152','757','257826',4904817,'2124','316',839704.05,840666.57,0.00,0.00,962.52,721890.00,0.00,0.00,0.00),('1','152','757','257826',4904818,'2668','316',265266.75,266153.29,0.00,0.00,886.54,629443.40,0.00,0.00,0.00),('1','152','757','257826',4904819,'2828','316',86306204.16,86306909.19,0.00,0.00,705.03,528772.50,0.00,0.00,0.00),('1','152','757','257827',4904820,'2123','316',985732.06,985732.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257827',4904821,'2124','316',840666.57,840746.85,0.00,0.00,80.28,60210.00,0.00,0.00,0.00),('1','152','757','257827',4904822,'2668','316',266153.29,266153.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257827',4904823,'2828','316',86306909.19,86306909.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257828',4904824,'2123','316',985732.06,986748.89,0.00,0.00,1016.83,762622.50,0.00,0.00,0.00),('1','152','757','257828',4904825,'2124','316',840746.85,841807.17,0.00,0.00,1060.32,795240.00,0.00,0.00,0.00),('1','152','757','257828',4904826,'2668','316',266153.29,266385.29,0.00,0.00,232.00,164720.00,0.00,0.00,0.00),('1','152','757','257828',4904827,'2828','316',86306909.19,86307684.70,0.00,0.00,775.51,581632.50,0.00,0.00,0.00),('1','152','757','257829',4904828,'2123','316',986748.89,987619.92,0.00,0.00,871.03,654772.50,0.00,0.00,0.00),('1','152','757','257829',4904829,'2124','316',841807.17,842829.36,0.00,0.00,1022.19,766642.50,0.00,0.00,0.00),('1','152','757','257829',4904830,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257829',4904831,'2828','316',86307684.70,86308491.36,0.00,0.00,806.66,604995.00,0.00,0.00,0.00),('1','152','757','257830',4904832,'2123','316',987619.92,987846.86,0.00,0.00,226.94,170205.00,0.00,0.00,0.00),('1','152','757','257830',4904833,'2124','316',842829.36,842962.62,0.00,0.00,133.26,99945.00,0.00,0.00,0.00),('1','152','757','257830',4904834,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257830',4904835,'2828','316',86308491.36,86308741.88,0.00,0.00,250.52,187890.00,0.00,0.00,0.00),('1','152','757','257831',4904836,'2123','316',987846.86,988441.75,0.00,0.00,594.89,446167.50,0.00,0.00,0.00),('1','152','757','257831',4904837,'2124','316',842962.62,843795.51,0.00,0.00,832.89,624667.50,0.00,0.00,0.00),('1','152','757','257831',4904838,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257831',4904839,'2828','316',86308741.88,86309311.63,0.00,0.00,569.75,427312.50,0.00,0.00,0.00),('1','152','757','257832',4904840,'2123','316',988441.75,988441.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257832',4904841,'2124','316',843795.51,843795.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257832',4904842,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257832',4904843,'2828','316',86309311.63,86309311.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257833',4904844,'2123','316',988441.75,989574.59,0.00,0.00,1132.84,851130.00,0.00,0.00,0.00),('1','152','757','257833',4904845,'2124','316',843795.51,845072.99,0.00,0.00,1277.48,958110.00,0.00,0.00,0.00),('1','152','757','257833',4904846,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257833',4904847,'2828','316',86309311.63,86310231.14,0.00,0.00,919.51,689632.50,0.00,0.00,0.00),('1','152','757','257834',4904848,'2123','316',989574.59,990376.52,0.00,0.00,801.93,601447.50,0.00,0.00,0.00),('1','152','757','257834',4904849,'2124','316',845072.99,846181.35,0.00,0.00,1108.36,831270.00,0.00,0.00,0.00),('1','152','757','257834',4904850,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257834',4904851,'2828','316',86310231.14,86310764.44,0.00,0.00,533.30,399975.00,0.00,0.00,0.00),('1','152','757','257835',4904852,'2123','316',990376.52,990454.46,0.00,0.00,77.94,58455.00,0.00,0.00,0.00),('1','152','757','257835',4904853,'2124','316',846181.35,846253.29,0.00,0.00,71.94,53955.00,0.00,0.00,0.00),('1','152','757','257835',4904854,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257835',4904855,'2828','316',86310764.44,86310811.49,0.00,0.00,47.05,35287.50,0.00,0.00,0.00),('1','152','757','257836',4904856,'2123','316',990454.46,990813.99,0.00,0.00,359.53,269647.50,0.00,0.00,0.00),('1','152','757','257836',4904857,'2124','316',846253.29,846760.18,0.00,0.00,506.89,380167.50,0.00,0.00,0.00),('1','152','757','257836',4904858,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257836',4904859,'2828','316',86310811.49,86311175.38,0.00,0.00,363.89,272917.50,0.00,0.00,0.00),('1','152','757','257837',4904860,'2123','316',990813.99,991294.29,0.00,0.00,480.30,360225.00,0.00,0.00,0.00),('1','152','757','257837',4904861,'2124','316',846760.18,847374.83,0.00,0.00,614.65,460987.50,0.00,0.00,0.00),('1','152','757','257837',4904862,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257837',4904863,'2828','316',86311175.38,86311679.61,0.00,0.00,504.23,378172.50,0.00,0.00,0.00),('1','152','757','257838',4904864,'2123','316',991294.29,992708.69,0.00,0.00,1414.40,1060800.00,0.00,0.00,0.00),('1','152','757','257838',4904865,'2124','316',847374.83,848544.38,0.00,0.00,1169.55,877162.50,0.00,0.00,0.00),('1','152','757','257838',4904866,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257838',4904867,'2828','316',86311679.61,86313067.36,0.00,0.00,1387.75,1040812.50,0.00,0.00,0.00),('1','152','757','257839',4904868,'2123','316',992708.69,992790.64,0.00,0.00,81.95,61462.50,0.00,0.00,0.00),('1','152','757','257839',4904869,'2124','316',848544.38,848615.55,0.00,0.00,71.17,53377.50,0.00,0.00,0.00),('1','152','757','257839',4904870,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257839',4904871,'2828','316',86313067.36,86313145.24,0.00,0.00,77.88,58410.00,0.00,0.00,0.00),('1','152','757','257840',4904872,'2123','316',992790.64,993690.33,0.00,0.00,899.69,674767.50,0.00,0.00,0.00),('1','152','757','257840',4904873,'2124','316',848615.55,849308.07,0.00,0.00,692.52,519390.00,0.00,0.00,0.00),('1','152','757','257840',4904874,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257840',4904875,'2828','316',86313145.24,86313880.08,0.00,0.00,734.84,551130.00,0.00,0.00,0.00),('1','152','757','257841',4904876,'2123','316',993690.33,994747.95,0.00,0.00,1057.62,793215.00,0.00,0.00,0.00),('1','152','757','257841',4904877,'2124','316',849308.07,850380.55,0.00,0.00,1072.48,804360.00,0.00,0.00,0.00),('1','152','757','257841',4904878,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257841',4904879,'2828','316',86313880.08,86314780.12,0.00,0.00,900.04,675030.00,0.00,0.00,0.00),('1','152','757','257842',4904880,'2123','316',994747.95,994915.21,0.00,0.00,167.26,125445.00,0.00,0.00,0.00),('1','152','757','257842',4904881,'2124','316',850380.55,850501.56,0.00,0.00,121.01,90757.50,0.00,0.00,0.00),('1','152','757','257842',4904882,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257842',4904883,'2828','316',86314780.12,86314866.86,0.00,0.00,86.74,65055.00,0.00,0.00,0.00),('1','152','757','257843',4904884,'2123','316',994915.21,995567.81,0.00,0.00,652.60,489450.00,0.00,0.00,0.00),('1','152','757','257843',4904885,'2124','316',850501.56,851110.35,0.00,0.00,608.79,456592.50,0.00,0.00,0.00),('1','152','757','257843',4904886,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257843',4904887,'2828','316',86314866.86,86315390.21,0.00,0.00,523.35,392512.50,0.00,0.00,0.00),('1','152','757','257844',4904888,'2123','316',995567.81,996111.99,0.00,0.00,544.18,424460.40,0.00,0.00,0.00),('1','152','757','257844',4904889,'2124','316',851110.35,851566.87,0.00,0.00,456.52,356085.60,0.00,0.00,0.00),('1','152','757','257844',4904890,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257844',4904891,'2828','316',86315390.21,86315765.35,0.00,0.00,375.14,292609.20,0.00,0.00,0.00),('1','152','757','257845',4904892,'2123','316',996111.99,996630.14,0.00,0.00,518.15,404157.00,0.00,0.00,0.00),('1','152','757','257845',4904893,'2124','316',851566.87,851979.42,0.00,0.00,412.55,321789.00,0.00,0.00,0.00),('1','152','757','257845',4904894,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257845',4904895,'2828','316',86315765.35,86316232.64,0.00,0.00,467.29,364486.20,0.00,0.00,0.00),('1','152','757','257846',4904896,'2123','316',996630.14,997599.74,0.00,0.00,969.60,756288.00,0.00,0.00,0.00),('1','152','757','257846',4904897,'2124','316',851979.42,852800.05,0.00,0.00,820.63,640091.40,0.00,0.00,0.00),('1','152','757','257846',4904898,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257846',4904899,'2828','316',86316232.64,86317075.88,0.00,0.00,843.24,657727.20,0.00,0.00,0.00),('1','152','757','257847',4904900,'2123','316',997599.74,998698.14,0.00,0.00,1098.40,856752.00,0.00,0.00,0.00),('1','152','757','257847',4904901,'2124','316',852800.05,853774.26,0.00,0.00,974.21,759883.80,0.00,0.00,0.00),('1','152','757','257847',4904902,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257847',4904903,'2828','316',86317075.88,86318547.53,0.00,0.00,1471.65,1147887.00,0.00,0.00,0.00),('1','152','757','257848',4904904,'2123','316',998698.14,999438.88,0.00,0.00,740.74,577777.20,0.00,0.00,0.00),('1','152','757','257848',4904905,'2124','316',853774.26,854443.73,0.00,0.00,669.47,522186.60,0.00,0.00,0.00),('1','152','757','257848',4904906,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257848',4904907,'2828','316',86318547.53,86319472.13,0.00,0.00,924.60,721188.00,0.00,0.00,0.00),('1','152','757','257849',4904908,'2123','316',999438.88,999796.99,0.00,0.00,358.11,279325.80,0.00,0.00,0.00),('1','152','757','257849',4904909,'2124','316',854443.73,854702.51,0.00,0.00,258.78,201848.40,0.00,0.00,0.00),('1','152','757','257849',4904910,'2668','316',266385.29,266385.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257849',4904911,'2828','316',86319472.13,86319720.83,0.00,0.00,248.70,193986.00,0.00,0.00,0.00),('1','152','757','257850',4904912,'2123','316',999796.99,1000905.60,0.00,0.00,1108.61,864715.80,0.00,0.00,0.00),('1','152','757','257850',4904913,'2124','316',854702.51,855781.91,0.00,0.00,1079.40,841932.00,0.00,0.00,0.00),('1','152','757','257850',4904914,'2668','316',266385.29,266497.29,0.00,0.00,112.00,82880.00,0.00,0.00,0.00),('1','152','757','257850',4904915,'2828','316',86319720.83,86320479.25,0.00,0.00,758.42,591567.60,0.00,0.00,0.00),('1','152','757','257851',4904916,'2123','316',1000905.60,1001167.67,0.00,0.00,262.07,204414.60,0.00,0.00,0.00),('1','152','757','257851',4904917,'2124','316',855781.91,856147.10,0.00,0.00,365.19,284848.20,0.00,0.00,0.00),('1','152','757','257851',4904918,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257851',4904919,'2828','316',86320479.25,86320997.11,0.00,0.00,517.86,403930.80,0.00,0.00,0.00),('1','152','757','257852',4904920,'2123','316',1001167.67,1002695.65,0.00,0.00,1527.98,1191824.40,0.00,0.00,0.00),('1','152','757','257852',4904921,'2124','316',856147.10,857929.83,0.00,0.00,1782.73,1390529.40,0.00,0.00,0.00),('1','152','757','257852',4904922,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257852',4904923,'2828','316',86320997.11,86322549.45,0.00,0.00,1552.34,1210825.20,0.00,0.00,0.00),('1','152','757','257853',4904924,'2123','316',1002695.65,1003097.46,0.00,0.00,401.81,313411.80,0.00,0.00,0.00),('1','152','757','257853',4904925,'2124','316',857929.83,858424.18,0.00,0.00,494.35,385593.00,0.00,0.00,0.00),('1','152','757','257853',4904926,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257853',4904927,'2828','316',86322549.45,86322660.45,0.00,0.00,111.00,86580.00,0.00,0.00,0.00),('1','152','757','257854',4904928,'2123','316',1003097.46,1004071.85,0.00,0.00,974.39,760024.20,0.00,0.00,0.00),('1','152','757','257854',4904929,'2124','316',858424.18,859471.73,0.00,0.00,1047.55,817089.00,0.00,0.00,0.00),('1','152','757','257854',4904930,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257854',4904931,'2828','316',86322660.45,86323446.77,0.00,0.00,786.32,613329.60,0.00,0.00,0.00),('1','152','757','257855',4904932,'2123','316',1004071.85,1005100.75,0.00,0.00,1028.90,802542.00,0.00,0.00,0.00),('1','152','757','257855',4904933,'2124','316',859471.73,860664.18,0.00,0.00,1192.45,930111.00,0.00,0.00,0.00),('1','152','757','257855',4904934,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257855',4904935,'2828','316',86323446.77,86324324.68,0.00,0.00,877.91,684769.80,0.00,0.00,0.00),('1','152','757','257856',4904936,'2123','316',1005100.75,1005166.08,0.00,0.00,65.33,50957.40,0.00,0.00,0.00),('1','152','757','257856',4904937,'2124','316',860664.18,860789.69,0.00,0.00,125.51,97897.80,0.00,0.00,0.00),('1','152','757','257856',4904938,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257856',4904939,'2828','316',86324324.68,86324393.64,0.00,0.00,68.96,53788.80,0.00,0.00,0.00),('1','152','757','257857',4904940,'2123','316',1005166.08,1006293.90,0.00,0.00,1127.82,879699.60,0.00,0.00,0.00),('1','152','757','257857',4904941,'2124','316',860789.69,862014.54,0.00,0.00,1224.85,955383.00,0.00,0.00,0.00),('1','152','757','257857',4904942,'2668','316',266497.29,266497.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257857',4904943,'2828','316',86324393.64,86325234.76,0.00,0.00,841.12,656073.60,0.00,0.00,0.00),('1','152','757','257858',4904944,'2123','316',1006293.90,1007033.21,0.00,0.00,739.31,576661.80,0.00,0.00,0.00),('1','152','757','257858',4904945,'2124','316',862014.54,862773.24,0.00,0.00,758.70,591786.00,0.00,0.00,0.00),('1','152','757','257858',4904946,'2668','316',266497.29,266597.29,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','152','757','257858',4904947,'2828','316',86325234.76,86325935.14,0.00,0.00,700.38,546296.40,0.00,0.00,0.00),('1','152','757','257859',4904948,'2123','316',1007033.21,1007127.18,0.00,0.00,93.97,73296.60,0.00,0.00,0.00),('1','152','757','257859',4904949,'2124','316',862773.24,862878.86,0.00,0.00,105.62,82383.60,0.00,0.00,0.00),('1','152','757','257859',4904950,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257859',4904951,'2828','316',86325935.14,86326001.59,0.00,0.00,66.45,51831.00,0.00,0.00,0.00),('1','152','757','257860',4904952,'2123','316',1007127.18,1008011.63,0.00,0.00,884.45,689871.00,0.00,0.00,0.00),('1','152','757','257860',4904953,'2124','316',862878.86,863709.63,0.00,0.00,830.77,648000.60,0.00,0.00,0.00),('1','152','757','257860',4904954,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257860',4904955,'2828','316',86326001.59,86326862.94,0.00,0.00,861.35,671853.00,0.00,0.00,0.00),('1','152','757','257861',4904956,'2123','316',1008011.63,1009089.97,0.00,0.00,1078.34,841105.20,0.00,0.00,0.00),('1','152','757','257861',4904957,'2124','316',863709.63,864623.62,0.00,0.00,913.99,712912.20,0.00,0.00,0.00),('1','152','757','257861',4904958,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257861',4904959,'2828','316',86326862.94,86327572.31,0.00,0.00,709.37,553308.60,0.00,0.00,0.00),('1','152','757','257862',4904960,'2123','316',1009089.97,1009964.44,0.00,0.00,874.47,682086.60,0.00,0.00,0.00),('1','152','757','257862',4904961,'2124','316',864623.62,865387.97,0.00,0.00,764.35,596193.00,0.00,0.00,0.00),('1','152','757','257862',4904962,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257862',4904963,'2828','316',86327572.31,86328390.62,0.00,0.00,818.31,638281.80,0.00,0.00,0.00),('1','152','757','257863',4904964,'2123','316',1009964.44,1010205.36,0.00,0.00,240.92,187917.60,0.00,0.00,0.00),('1','152','757','257863',4904965,'2124','316',865387.97,865608.47,0.00,0.00,220.50,171990.00,0.00,0.00,0.00),('1','152','757','257863',4904966,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257863',4904967,'2828','316',86328390.62,86328544.43,0.00,0.00,153.81,119971.80,0.00,0.00,0.00),('1','152','757','257864',4904968,'2123','316',1010205.36,1010517.11,0.00,0.00,311.75,243165.00,0.00,0.00,0.00),('1','152','757','257864',4904969,'2124','316',865608.47,865875.96,0.00,0.00,267.49,208642.20,0.00,0.00,0.00),('1','152','757','257864',4904970,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257864',4904971,'2828','316',86328544.43,86328605.83,0.00,0.00,61.40,47892.00,0.00,0.00,0.00),('1','152','757','257865',4904972,'2123','316',1010517.11,1010973.01,0.00,0.00,455.90,355602.00,0.00,0.00,0.00),('1','152','757','257865',4904973,'2124','316',865875.96,866343.80,0.00,0.00,467.84,364915.20,0.00,0.00,0.00),('1','152','757','257865',4904974,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257865',4904975,'2828','316',86328605.83,86329062.23,0.00,0.00,456.40,355992.00,0.00,0.00,0.00),('1','152','757','257866',4904976,'2123','316',1010973.01,1011781.30,0.00,0.00,808.29,630466.20,0.00,0.00,0.00),('1','152','757','257866',4904977,'2124','316',866343.80,867143.30,0.00,0.00,799.50,623610.00,0.00,0.00,0.00),('1','152','757','257866',4904978,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257866',4904979,'2828','316',86329062.23,86329949.87,0.00,0.00,887.64,692359.20,0.00,0.00,0.00),('1','152','757','257867',4904980,'2123','316',1011781.30,1012521.91,0.00,0.00,740.61,577675.80,0.00,0.00,0.00),('1','152','757','257867',4904981,'2124','316',867143.30,867865.37,0.00,0.00,722.07,563214.60,0.00,0.00,0.00),('1','152','757','257867',4904982,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257867',4904983,'2828','316',86329949.87,86330377.07,0.00,0.00,427.20,333216.00,0.00,0.00,0.00),('1','152','757','257868',4904984,'2123','316',1012521.91,1012800.28,0.00,0.00,278.37,217128.60,0.00,0.00,0.00),('1','152','757','257868',4904985,'2124','316',867865.37,868149.52,0.00,0.00,284.15,221637.00,0.00,0.00,0.00),('1','152','757','257868',4904986,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257868',4904987,'2828','316',86330377.07,86330623.89,0.00,0.00,246.82,192519.60,0.00,0.00,0.00),('1','152','757','257869',4904988,'2123','316',1012800.28,1013599.23,0.00,0.00,798.95,623181.00,0.00,0.00,0.00),('1','152','757','257869',4904989,'2124','316',868149.52,868878.06,0.00,0.00,728.54,568261.20,0.00,0.00,0.00),('1','152','757','257869',4904990,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257869',4904991,'2828','316',86330623.89,86331235.51,0.00,0.00,611.62,477063.60,0.00,0.00,0.00),('1','152','757','257870',4904992,'2123','316',1013599.23,1014381.02,0.00,0.00,781.79,609796.20,0.00,0.00,0.00),('1','152','757','257870',4904993,'2124','316',868878.06,869597.37,0.00,0.00,719.31,561061.80,0.00,0.00,0.00),('1','152','757','257870',4904994,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257870',4904995,'2828','316',86331235.51,86332007.50,0.00,0.00,771.99,602152.20,0.00,0.00,0.00),('1','152','757','257871',4904996,'2123','316',1014381.02,1014578.47,0.00,0.00,197.45,154011.00,0.00,0.00,0.00),('1','152','757','257871',4904997,'2124','316',869597.37,869890.28,0.00,0.00,292.91,228469.80,0.00,0.00,0.00),('1','152','757','257871',4904998,'2668','316',266597.29,266597.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257871',4904999,'2828','316',86332007.50,86332116.88,0.00,0.00,109.38,85316.40,0.00,0.00,0.00),('1','152','757','257872',4905000,'2123','316',1014578.47,1015256.73,0.00,0.00,678.26,529042.80,0.00,0.00,0.00),('1','152','757','257872',4905001,'2124','316',869890.28,870376.34,0.00,0.00,486.06,379126.80,0.00,0.00,0.00),('1','152','757','257872',4905002,'2668','316',266597.29,266687.17,0.00,0.00,89.88,66511.20,0.00,0.00,0.00),('1','152','757','257872',4905003,'2828','316',86332116.88,86332558.18,0.00,0.00,441.30,344214.00,0.00,0.00,0.00),('1','152','757','257873',4905004,'2123','316',1015256.73,1016276.76,0.00,0.00,1020.03,795623.40,0.00,0.00,0.00),('1','152','757','257873',4905005,'2124','316',870376.34,871413.90,0.00,0.00,1037.56,809296.80,0.00,0.00,0.00),('1','152','757','257873',4905006,'2668','316',266687.17,266687.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257873',4905007,'2828','316',86332558.18,86333225.78,0.00,0.00,667.60,520728.00,0.00,0.00,0.00),('1','152','757','257874',4905008,'2123','316',1016276.76,1016744.08,0.00,0.00,467.32,364509.60,0.00,0.00,0.00),('1','152','757','257874',4905009,'2124','316',871413.90,871924.69,0.00,0.00,510.79,398416.20,0.00,0.00,0.00),('1','152','757','257874',4905010,'2668','316',266687.17,266887.17,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','152','757','257874',4905011,'2828','316',86333225.78,86333549.70,0.00,0.00,323.92,252657.60,0.00,0.00,0.00),('1','152','757','257875',4905012,'2123','316',1016744.08,1017296.99,0.00,0.00,552.91,431269.80,0.00,0.00,0.00),('1','152','757','257875',4905013,'2124','316',871924.69,872488.75,0.00,0.00,564.06,439966.80,0.00,0.00,0.00),('1','152','757','257875',4905014,'2668','316',266887.17,267220.99,0.00,0.00,333.82,247026.80,0.00,0.00,0.00),('1','152','757','257875',4905015,'2828','316',86333549.70,86333981.75,0.00,0.00,432.05,336999.00,0.00,0.00,0.00),('1','152','757','257876',4905016,'2123','316',1017296.99,1018084.70,0.00,0.00,787.71,614413.80,0.00,0.00,0.00),('1','152','757','257876',4905017,'2124','316',872488.75,873476.23,0.00,0.00,987.48,770234.40,0.00,0.00,0.00),('1','152','757','257876',4905018,'2668','316',267220.99,267527.79,0.00,0.00,306.80,227032.00,0.00,0.00,0.00),('1','152','757','257876',4905019,'2828','316',86333981.75,86334682.01,0.00,0.00,700.26,546202.80,0.00,0.00,0.00),('1','152','757','257877',4905020,'2123','316',1018084.70,1018502.00,0.00,0.00,417.30,325494.00,0.00,0.00,0.00),('1','152','757','257877',4905021,'2124','316',873476.23,873864.84,0.00,0.00,388.61,303115.80,0.00,0.00,0.00),('1','152','757','257877',4905022,'2668','316',267527.79,267617.79,0.00,0.00,90.00,66600.00,0.00,0.00,0.00),('1','152','757','257877',4905023,'2828','316',86334682.01,86334819.58,0.00,0.00,137.57,107304.60,0.00,0.00,0.00),('1','152','757','257878',4905024,'2123','316',1018502.00,1019058.54,0.00,0.00,556.54,434101.20,0.00,0.00,0.00),('1','152','757','257878',4905025,'2124','316',873864.84,874266.10,0.00,0.00,401.26,312982.80,0.00,0.00,0.00),('1','152','757','257878',4905026,'2668','316',267617.79,267692.79,0.00,0.00,75.00,55900.00,0.00,0.00,0.00),('1','152','757','257878',4905027,'2828','316',86334819.58,86335131.98,0.00,0.00,312.40,243672.00,0.00,0.00,0.00),('1','152','757','257879',4905028,'2123','316',1019058.54,1019187.44,0.00,0.00,128.90,100542.00,0.00,0.00,0.00),('1','152','757','257879',4905029,'2124','316',874266.10,874415.99,0.00,0.00,149.89,116914.20,0.00,0.00,0.00),('1','152','757','257879',4905030,'2668','316',267692.79,267750.79,0.00,0.00,58.00,42920.00,0.00,0.00,0.00),('1','152','757','257879',4905031,'2828','316',86335131.98,86335140.30,0.00,0.00,8.32,6489.60,0.00,0.00,0.00),('1','152','757','257880',4905032,'2123','316',1019187.44,1019800.92,0.00,0.00,613.48,478514.40,0.00,0.00,0.00),('1','152','757','257880',4905033,'2124','316',874415.99,875100.67,0.00,0.00,684.68,534050.40,0.00,0.00,0.00),('1','152','757','257880',4905034,'2668','316',267750.79,267855.82,0.00,0.00,105.03,77722.20,0.00,0.00,0.00),('1','152','757','257880',4905035,'2828','316',86335140.30,86335562.77,0.00,0.00,422.47,329526.60,0.00,0.00,0.00),('1','152','757','257881',4905036,'2123','316',1019800.92,1020710.22,0.00,0.00,909.30,709254.00,0.00,0.00,0.00),('1','152','757','257881',4905037,'2124','316',875100.67,876168.28,0.00,0.00,1067.61,832735.80,0.00,0.00,0.00),('1','152','757','257881',4905038,'2668','316',267855.82,268169.85,0.00,0.00,314.03,232382.20,0.00,0.00,0.00),('1','152','757','257881',4905039,'2828','316',86335562.77,86336281.82,0.00,0.00,719.05,560859.00,0.00,0.00,0.00),('1','152','757','257882',4905040,'2123','316',1020710.22,1021654.83,0.00,0.00,944.61,736795.80,0.00,0.00,0.00),('1','152','757','257882',4905041,'2124','316',876168.28,877049.33,0.00,0.00,881.05,687219.00,0.00,0.00,0.00),('1','152','757','257882',4905042,'2668','316',268169.85,268403.83,0.00,0.00,233.98,173145.20,0.00,0.00,0.00),('1','152','757','257882',4905043,'2828','316',86336281.82,86336960.09,0.00,0.00,678.27,529050.60,0.00,0.00,0.00),('1','152','757','257883',4905044,'2123','316',1021654.83,1022650.24,0.00,0.00,995.41,776419.80,0.00,0.00,0.00),('1','152','757','257883',4905045,'2124','316',877049.33,877961.42,0.00,0.00,912.09,711430.20,0.00,0.00,0.00),('1','152','757','257883',4905046,'2668','316',268403.83,268546.18,0.00,0.00,142.35,105579.00,0.00,0.00,0.00),('1','152','757','257883',4905047,'2828','316',86336960.09,86337531.86,0.00,0.00,571.77,445980.60,0.00,0.00,0.00),('1','152','757','257884',4905048,'2123','316',1022650.24,1024079.12,0.00,0.00,1428.88,1114526.40,0.00,0.00,0.00),('1','152','757','257884',4905049,'2124','316',877961.42,879181.11,0.00,0.00,1219.69,951358.20,0.00,0.00,0.00),('1','152','757','257884',4905050,'2668','316',268546.18,268807.10,0.00,0.00,260.92,193080.80,0.00,0.00,0.00),('1','152','757','257884',4905051,'2828','316',86337531.86,86338104.44,0.00,0.00,572.58,446612.40,0.00,0.00,0.00),('1','152','757','257885',4905052,'2123','316',1024079.12,1025163.68,0.00,0.00,1084.56,800653.52,0.00,0.00,0.00),('1','152','757','257885',4905053,'2124','316',879181.11,880114.71,0.00,0.00,933.60,697348.60,0.00,0.00,0.00),('1','152','757','257885',4905054,'2668','316',268807.10,269258.91,0.00,0.00,451.81,322585.10,0.00,0.00,0.00),('1','152','757','257885',4905055,'2828','316',86338104.44,86338674.22,0.00,0.00,569.78,423143.84,0.00,0.00,0.00),('1','152','757','257886',4905056,'2123','316',1025163.68,1026468.21,0.00,0.00,1304.53,960134.08,0.00,0.00,0.00),('1','152','757','257886',4905057,'2124','316',880114.71,881573.37,0.00,0.00,1458.66,1073443.76,0.00,0.00,0.00),('1','152','757','257886',4905058,'2668','316',269258.91,269744.27,0.00,0.00,485.36,344605.60,0.00,0.00,0.00),('1','152','757','257886',4905059,'2828','316',86338674.22,86339517.52,0.00,0.00,843.30,620668.80,0.00,0.00,0.00),('1','152','757','257887',4905060,'2123','316',1026468.21,1027653.53,0.00,0.00,1185.32,872395.52,0.00,0.00,0.00),('1','152','757','257887',4905061,'2124','316',881573.37,882890.45,0.00,0.00,1317.08,969370.88,0.00,0.00,0.00),('1','152','757','257887',4905062,'2668','316',269744.27,270848.85,0.00,0.00,1104.58,784251.80,0.00,0.00,0.00),('1','152','757','257887',4905063,'2828','316',86339517.52,86340037.03,0.00,0.00,519.51,382359.36,0.00,0.00,0.00),('1','152','757','257888',4905064,'2123','316',1027653.53,1027653.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257888',4905065,'2124','316',882890.45,882890.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257888',4905066,'2668','316',270848.85,270848.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257888',4905067,'2828','316',86340037.03,86340037.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257889',4905068,'2123','316',1027653.53,1029173.41,0.00,0.00,1519.88,1118631.68,0.00,0.00,0.00),('1','152','757','257889',4905069,'2124','316',882890.45,884133.60,0.00,0.00,1243.15,914958.40,0.00,0.00,0.00),('1','152','757','257889',4905070,'2668','316',270848.85,271219.30,0.00,0.00,370.45,263019.50,0.00,0.00,0.00),('1','152','757','257889',4905071,'2828','316',86340037.03,86340823.01,0.00,0.00,785.98,578481.28,0.00,0.00,0.00),('1','152','757','257890',4905072,'2123','316',1029173.41,1030531.73,0.00,0.00,1358.32,999398.52,0.00,0.00,0.00),('1','152','757','257890',4905073,'2124','316',884133.60,885600.98,0.00,0.00,1467.38,1079991.68,0.00,0.00,0.00),('1','152','757','257890',4905074,'2668','316',271219.30,271806.10,0.00,0.00,586.80,416628.00,0.00,0.00,0.00),('1','152','757','257890',4905075,'2828','316',86340823.01,86341442.36,0.00,0.00,619.35,455841.60,0.00,0.00,0.00),('1','152','757','257891',4905076,'2123','316',1030531.73,1032619.26,0.00,0.00,2087.53,1536422.08,0.00,0.00,0.00),('1','152','757','257891',4905077,'2124','316',885600.98,886749.80,0.00,0.00,1148.82,845531.52,0.00,0.00,0.00),('1','152','757','257891',4905078,'2668','316',271806.10,272114.35,0.00,0.00,308.25,218857.50,0.00,0.00,0.00),('1','152','757','257891',4905079,'2828','316',86341442.36,86342270.25,0.00,0.00,827.89,609327.04,0.00,0.00,0.00),('1','152','757','257892',4905080,'2123','316',1032619.26,1034199.04,0.00,0.00,1579.78,1162718.08,0.00,0.00,0.00),('1','152','757','257892',4905081,'2124','316',886749.80,888214.97,0.00,0.00,1465.17,1078365.12,0.00,0.00,0.00),('1','152','757','257892',4905082,'2668','316',272114.35,272851.25,0.00,0.00,736.90,523199.00,0.00,0.00,0.00),('1','152','757','257892',4905083,'2828','316',86342270.25,86343016.26,0.00,0.00,746.01,549063.36,0.00,0.00,0.00),('1','152','757','257893',4905084,'2123','316',1034199.04,1034810.70,0.00,0.00,611.66,450181.76,0.00,0.00,0.00),('1','152','757','257893',4905085,'2124','316',888214.97,889368.02,0.00,0.00,1153.05,848644.80,0.00,0.00,0.00),('1','152','757','257893',4905086,'2668','316',272851.25,275014.78,0.00,0.00,2163.53,1536106.30,0.00,0.00,0.00),('1','152','757','257893',4905087,'2828','316',86343016.26,86343516.91,0.00,0.00,500.65,368478.40,0.00,0.00,0.00),('1','152','757','257894',4905088,'2123','316',1034810.70,1035990.68,0.00,0.00,1179.98,868465.28,0.00,0.00,0.00),('1','152','757','257894',4905089,'2124','316',889368.02,890505.65,0.00,0.00,1137.63,837295.68,0.00,0.00,0.00),('1','152','757','257894',4905090,'2668','316',275014.78,275522.78,0.00,0.00,508.00,360680.00,0.00,0.00,0.00),('1','152','757','257894',4905091,'2828','316',86343516.91,86343758.71,0.00,0.00,241.80,177964.80,0.00,0.00,0.00),('1','152','757','257895',4905092,'2123','316',1035990.68,1036202.11,0.00,0.00,211.43,155612.48,0.00,0.00,0.00),('1','152','757','257895',4905093,'2124','316',890505.65,890657.75,0.00,0.00,152.10,111945.60,0.00,0.00,0.00),('1','152','757','257895',4905094,'2668','316',275522.78,275685.78,0.00,0.00,163.00,115730.00,0.00,0.00,0.00),('1','152','757','257895',4905095,'2828','316',86343758.71,86343808.71,0.00,0.00,50.00,36800.00,0.00,0.00,0.00),('1','152','757','257896',4905096,'2123','316',1036202.11,1036202.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257896',4905097,'2124','316',890657.75,890657.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257896',4905098,'2668','316',275685.78,275685.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257896',4905099,'2828','316',86343808.71,86343808.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257897',4905100,'2123','316',1036202.11,1037148.48,0.00,0.00,946.37,696528.32,0.00,0.00,0.00),('1','152','757','257897',4905101,'2124','316',890657.75,891469.07,0.00,0.00,811.32,597131.52,0.00,0.00,0.00),('1','152','757','257897',4905102,'2668','316',275685.78,276211.58,0.00,0.00,525.80,373318.00,0.00,0.00,0.00),('1','152','757','257897',4905103,'2828','316',86343808.71,86344161.05,0.00,0.00,352.34,259322.24,0.00,0.00,0.00),('1','152','757','257898',4905104,'2123','316',1037148.48,1038160.24,0.00,0.00,1011.76,744655.36,0.00,0.00,0.00),('1','152','757','257898',4905105,'2124','316',891469.07,892934.93,0.00,0.00,1465.86,1078872.96,0.00,0.00,0.00),('1','152','757','257898',4905106,'2668','316',276211.58,276940.13,0.00,0.00,728.55,517270.50,0.00,0.00,0.00),('1','152','757','257898',4905107,'2828','316',86344161.05,86344301.43,0.00,0.00,140.38,103319.68,0.00,0.00,0.00),('1','152','757','257899',4905108,'2123','316',1038160.24,1039461.47,0.00,0.00,1301.23,957705.28,0.00,0.00,0.00),('1','152','757','257899',4905109,'2124','316',892934.93,893874.35,0.00,0.00,939.42,691413.12,0.00,0.00,0.00),('1','152','757','257899',4905110,'2668','316',276940.13,277706.19,0.00,0.00,766.06,543902.60,0.00,0.00,0.00),('1','152','757','257899',4905111,'2828','316',86344301.43,86344835.01,0.00,0.00,533.58,392714.88,0.00,0.00,0.00),('1','152','757','257900',4905112,'2123','316',1039461.47,1040845.93,0.00,0.00,1384.46,1018962.56,0.00,0.00,0.00),('1','152','757','257900',4905113,'2124','316',893874.35,895157.47,0.00,0.00,1283.12,944376.32,0.00,0.00,0.00),('1','152','757','257900',4905114,'2668','316',277706.19,278007.19,0.00,0.00,301.00,213710.00,0.00,0.00,0.00),('1','152','757','257900',4905115,'2828','316',86344835.01,86345049.99,0.00,0.00,214.98,158225.28,0.00,0.00,0.00),('1','152','757','257901',4905116,'2123','316',1040845.93,1042166.56,0.00,0.00,1320.63,971983.68,0.00,0.00,0.00),('1','152','757','257901',4905117,'2124','316',895157.47,896341.92,0.00,0.00,1184.45,871755.20,0.00,0.00,0.00),('1','152','757','257901',4905118,'2668','316',278007.19,278614.29,0.00,0.00,607.10,431041.00,0.00,0.00,0.00),('1','152','757','257901',4905119,'2828','316',86345049.99,86345522.65,0.00,0.00,472.66,347877.76,0.00,0.00,0.00),('1','152','757','257902',4905120,'2123','316',1042166.56,1043338.00,0.00,0.00,1171.44,862179.84,0.00,0.00,0.00),('1','152','757','257902',4905121,'2124','316',896341.92,897478.20,0.00,0.00,1136.28,836302.08,0.00,0.00,0.00),('1','152','757','257902',4905122,'2668','316',278614.29,280054.51,0.00,0.00,1440.22,1022626.92,0.00,0.00,0.00),('1','152','757','257902',4905123,'2828','316',86345522.65,86345685.62,0.00,0.00,162.97,119945.92,0.00,0.00,0.00),('1','152','757','257903',4905124,'2123','316',1043338.00,1044489.57,0.00,0.00,1151.57,847555.52,0.00,0.00,0.00),('1','152','757','257903',4905125,'2124','316',897478.20,898551.70,0.00,0.00,1073.50,790096.00,0.00,0.00,0.00),('1','152','757','257903',4905126,'2668','316',280054.51,280552.40,0.00,0.00,497.89,353572.62,0.00,0.00,0.00),('1','152','757','257903',4905127,'2828','316',86345685.62,86345758.87,0.00,0.00,73.25,53912.00,0.00,0.00,0.00),('1','152','757','257904',4905128,'2123','316',1044489.57,1045227.11,0.00,0.00,737.54,542829.44,0.00,0.00,0.00),('1','152','757','257904',4905129,'2124','316',898551.70,899222.31,0.00,0.00,670.61,493568.96,0.00,0.00,0.00),('1','152','757','257904',4905130,'2668','316',280552.40,281220.29,0.00,0.00,667.89,474669.90,0.00,0.00,0.00),('1','152','757','257904',4905131,'2828','316',86345758.87,86345808.87,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','152','757','257905',4905132,'2123','316',1045227.11,1045681.58,0.00,0.00,454.47,334489.92,0.00,0.00,0.00),('1','152','757','257905',4905133,'2124','316',899222.31,899546.89,0.00,0.00,324.58,238890.88,0.00,0.00,0.00),('1','152','757','257905',4905134,'2668','316',281220.29,281362.40,0.00,0.00,142.11,100898.10,0.00,0.00,0.00),('1','152','757','257905',4905135,'2828','316',86345808.87,86345911.67,0.00,0.00,102.80,75660.80,0.00,0.00,0.00),('1','152','757','257906',4905136,'2123','316',1045681.58,1047123.57,0.00,0.00,1441.99,1061304.64,0.00,0.00,0.00),('1','152','757','257906',4905137,'2124','316',899546.89,900582.67,0.00,0.00,1035.78,762334.08,0.00,0.00,0.00),('1','152','757','257906',4905138,'2668','316',281362.40,282934.65,0.00,0.00,1572.25,1116297.50,0.00,0.00,0.00),('1','152','757','257906',4905139,'2828','316',86345911.67,86345917.38,0.00,0.00,5.71,4202.56,0.00,0.00,0.00),('1','152','757','257907',4905140,'2123','316',1047123.57,1048128.83,0.00,0.00,1005.26,739871.36,0.00,0.00,0.00),('1','152','757','257907',4905141,'2124','316',900582.67,901644.34,0.00,0.00,1061.67,781389.12,0.00,0.00,0.00),('1','152','757','257907',4905142,'2668','316',282934.65,283615.74,0.00,0.00,681.09,483573.90,0.00,0.00,0.00),('1','152','757','257907',4905143,'2828','316',86345917.38,86345988.12,0.00,0.00,70.74,52064.64,0.00,0.00,0.00),('1','152','757','257908',4905144,'2123','316',1048128.83,1049164.95,0.00,0.00,1036.12,762584.32,0.00,0.00,0.00),('1','152','757','257908',4905145,'2124','316',901644.34,902775.54,0.00,0.00,1131.20,832563.20,0.00,0.00,0.00),('1','152','757','257908',4905146,'2668','316',283615.74,283977.74,0.00,0.00,362.00,257020.00,0.00,0.00,0.00),('1','152','757','257908',4905147,'2828','316',86345988.12,86346179.54,0.00,0.00,191.42,140885.12,0.00,0.00,0.00),('1','152','757','257909',4905148,'2123','316',1049164.95,1050395.35,0.00,0.00,1230.40,905574.40,0.00,0.00,0.00),('1','152','757','257909',4905149,'2124','316',902775.54,904077.56,0.00,0.00,1302.02,958286.72,0.00,0.00,0.00),('1','152','757','257909',4905150,'2668','316',283977.74,284748.29,0.00,0.00,770.55,547090.50,0.00,0.00,0.00),('1','152','757','257909',4905151,'2828','316',86346179.54,86346324.80,0.00,0.00,145.26,106911.36,0.00,0.00,0.00),('1','152','757','257910',4905152,'2123','316',1050395.35,1051599.11,0.00,0.00,1203.76,885967.36,0.00,0.00,0.00),('1','152','757','257910',4905153,'2124','316',904077.56,905150.90,0.00,0.00,1073.34,789978.24,0.00,0.00,0.00),('1','152','757','257910',4905154,'2668','316',284748.29,285237.05,0.00,0.00,488.76,347019.60,0.00,0.00,0.00),('1','152','757','257910',4905155,'2828','316',86346324.80,86346339.32,0.00,0.00,14.52,10686.72,0.00,0.00,0.00),('1','152','757','257911',4905156,'2123','316',1051599.11,1053015.27,0.00,0.00,1416.16,1042293.76,0.00,0.00,0.00),('1','152','757','257911',4905157,'2124','316',905150.90,906152.10,0.00,0.00,1001.20,736883.20,0.00,0.00,0.00),('1','152','757','257911',4905158,'2668','316',285237.05,285400.81,0.00,0.00,163.76,116269.60,0.00,0.00,0.00),('1','152','757','257911',4905159,'2828','316',86346339.32,86346585.87,0.00,0.00,246.55,181460.80,0.00,0.00,0.00),('1','152','757','257912',4905160,'2123','316',1053015.27,1054497.87,0.00,0.00,1482.60,1091193.60,0.00,0.00,0.00),('1','152','757','257912',4905161,'2124','316',906152.10,907186.32,0.00,0.00,1034.22,761185.92,0.00,0.00,0.00),('1','152','757','257912',4905162,'2668','316',285400.81,285946.26,0.00,0.00,545.45,387269.50,0.00,0.00,0.00),('1','152','757','257912',4905163,'2828','316',86346585.87,86346615.09,0.00,0.00,29.22,21505.92,0.00,0.00,0.00),('1','152','757','257913',4905164,'2123','316',1054497.87,1055324.18,0.00,0.00,826.31,608164.16,0.00,0.00,0.00),('1','152','757','257913',4905165,'2124','316',907186.32,908001.89,0.00,0.00,815.57,600259.52,0.00,0.00,0.00),('1','152','757','257913',4905166,'2668','316',285946.26,286048.76,0.00,0.00,102.50,72775.00,0.00,0.00,0.00),('1','152','757','257913',4905167,'2828','316',86346615.09,86346654.06,0.00,0.00,38.97,28681.92,0.00,0.00,0.00),('1','152','757','257914',4905168,'2123','316',1055324.18,1055324.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257914',4905169,'2124','316',908001.89,908001.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257914',4905170,'2668','316',286048.76,286048.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257914',4905171,'2828','316',86346654.06,86346654.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257915',4905172,'2123','316',1055324.18,1055907.32,0.00,0.00,583.14,429191.04,0.00,0.00,0.00),('1','152','757','257915',4905173,'2124','316',908001.89,908511.99,0.00,0.00,510.10,375433.60,0.00,0.00,0.00),('1','152','757','257915',4905174,'2668','316',286048.76,286348.76,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','152','757','257915',4905175,'2828','316',86346654.06,86346757.46,0.00,0.00,103.40,76102.40,0.00,0.00,0.00),('1','152','757','257916',4905176,'2123','316',1055907.32,1057526.34,0.00,0.00,1619.02,1191598.72,0.00,0.00,0.00),('1','152','757','257916',4905177,'2124','316',908511.99,909795.04,0.00,0.00,1283.05,944324.80,0.00,0.00,0.00),('1','152','757','257916',4905178,'2668','316',286348.76,286885.97,0.00,0.00,537.21,381419.10,0.00,0.00,0.00),('1','152','757','257916',4905179,'2828','316',86346757.46,86346778.68,0.00,0.00,21.22,15617.92,0.00,0.00,0.00),('1','152','757','257917',4905180,'2123','316',1057526.34,1057850.10,0.00,0.00,323.76,238287.36,0.00,0.00,0.00),('1','152','757','257917',4905181,'2124','316',909795.04,910063.06,0.00,0.00,268.02,197262.72,0.00,0.00,0.00),('1','152','757','257917',4905182,'2668','316',286885.97,287197.97,0.00,0.00,312.00,221520.00,0.00,0.00,0.00),('1','152','757','257917',4905183,'2828','316',86346778.68,86346782.76,0.00,0.00,4.08,3002.88,0.00,0.00,0.00),('1','152','757','257918',4905184,'2123','316',1057850.10,1058632.29,0.00,0.00,782.19,575691.84,0.00,0.00,0.00),('1','152','757','257918',4905185,'2124','316',910063.06,910772.39,0.00,0.00,709.33,522066.88,0.00,0.00,0.00),('1','152','757','257918',4905186,'2668','316',287197.97,287266.99,0.00,0.00,69.02,49498.72,0.00,0.00,0.00),('1','152','757','257918',4905187,'2828','316',86346782.76,86347137.24,0.00,0.00,354.48,260897.28,0.00,0.00,0.00),('1','152','757','257919',4905188,'2123','316',1058632.29,1059125.39,0.00,0.00,493.10,362921.60,0.00,0.00,0.00),('1','152','757','257919',4905189,'2124','316',910772.39,911223.05,0.00,0.00,450.66,331685.76,0.00,0.00,0.00),('1','152','757','257919',4905190,'2668','316',287266.99,287367.93,0.00,0.00,100.94,71667.40,0.00,0.00,0.00),('1','152','757','257919',4905191,'2828','316',86347137.24,86347482.24,0.00,0.00,345.00,253920.00,0.00,0.00,0.00),('1','152','757','257920',4905192,'2123','316',1059125.39,1060827.21,0.00,0.00,1701.82,1252539.52,0.00,0.00,0.00),('1','152','757','257920',4905193,'2124','316',911223.05,912687.57,0.00,0.00,1464.52,1077886.72,0.00,0.00,0.00),('1','152','757','257920',4905194,'2668','316',287367.93,288013.22,0.00,0.00,645.29,458155.90,0.00,0.00,0.00),('1','152','757','257920',4905195,'2828','316',86347482.24,86347509.01,0.00,0.00,26.77,19702.72,0.00,0.00,0.00),('1','152','757','257921',4905196,'2123','316',1060827.21,1061020.92,0.00,0.00,193.71,142570.56,0.00,0.00,0.00),('1','152','757','257921',4905197,'2124','316',912687.57,912894.26,0.00,0.00,206.69,152123.84,0.00,0.00,0.00),('1','152','757','257921',4905198,'2668','316',288013.22,288173.22,0.00,0.00,160.00,113600.00,0.00,0.00,0.00),('1','152','757','257921',4905199,'2828','316',86347509.01,86347512.00,0.00,0.00,2.99,2200.64,0.00,0.00,0.00),('1','152','757','257922',4905200,'2123','316',1061020.92,1062193.28,0.00,0.00,1172.36,862856.96,0.00,0.00,0.00),('1','152','757','257922',4905201,'2124','316',912894.26,914063.70,0.00,0.00,1169.44,860707.84,0.00,0.00,0.00),('1','152','757','257922',4905202,'2668','316',288173.22,288382.22,0.00,0.00,209.00,148390.00,0.00,0.00,0.00),('1','152','757','257922',4905203,'2828','316',86347512.00,86348082.51,0.00,0.00,570.51,419895.36,0.00,0.00,0.00),('1','152','757','257923',4905204,'2123','316',1062193.28,1063553.20,0.00,0.00,1359.92,1002365.12,0.00,0.00,0.00),('1','152','757','257923',4905205,'2124','316',914063.70,914827.43,0.00,0.00,763.73,562105.28,0.00,0.00,0.00),('1','152','757','257923',4905206,'2668','316',288382.22,288758.71,0.00,0.00,376.49,267307.90,0.00,0.00,0.00),('1','152','757','257923',4905207,'2828','316',86348082.51,86348095.01,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','152','757','257924',4905208,'2123','316',1063553.20,1064582.24,0.00,0.00,1029.04,757373.44,0.00,0.00,0.00),('1','152','757','257924',4905209,'2124','316',914827.43,915938.66,0.00,0.00,1111.23,817865.28,0.00,0.00,0.00),('1','152','757','257924',4905210,'2668','316',288758.71,288786.71,0.00,0.00,28.00,19880.00,0.00,0.00,0.00),('1','152','757','257924',4905211,'2828','316',86348095.01,86348227.94,0.00,0.00,132.93,97836.48,0.00,0.00,0.00),('1','152','757','257925',4905212,'2123','316',1064582.24,1065243.95,0.00,0.00,661.71,487018.56,0.00,0.00,0.00),('1','152','757','257925',4905213,'2124','316',915938.66,916521.55,0.00,0.00,582.89,429007.04,0.00,0.00,0.00),('1','152','757','257925',4905214,'2668','316',288786.71,289145.16,0.00,0.00,358.45,254499.50,0.00,0.00,0.00),('1','152','757','257925',4905215,'2828','316',86348227.94,86348597.69,0.00,0.00,369.75,272136.00,0.00,0.00,0.00),('1','152','757','257926',4905216,'2123','316',1065243.95,1066945.36,0.00,0.00,1701.41,1252237.76,0.00,0.00,0.00),('1','152','757','257926',4905217,'2124','316',916521.55,918108.10,0.00,0.00,1586.55,1167700.80,0.00,0.00,0.00),('1','152','757','257926',4905218,'2668','316',289145.16,289552.24,0.00,0.00,407.08,289026.80,0.00,0.00,0.00),('1','152','757','257926',4905219,'2828','316',86348597.69,86348597.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257927',4905220,'2123','316',1066945.36,1068316.50,0.00,0.00,1371.14,1009159.04,0.00,0.00,0.00),('1','152','757','257927',4905221,'2124','316',918108.10,919289.27,0.00,0.00,1181.17,869341.12,0.00,0.00,0.00),('1','152','757','257927',4905222,'2668','316',289552.24,289633.24,0.00,0.00,81.00,57510.00,0.00,0.00,0.00),('1','152','757','257927',4905223,'2828','316',86348597.69,86349183.03,0.00,0.00,585.34,430810.24,0.00,0.00,0.00),('1','152','757','257928',4905224,'2123','316',1068316.50,1069634.48,0.00,0.00,1317.98,970033.28,0.00,0.00,0.00),('1','152','757','257928',4905225,'2124','316',919289.27,920494.33,0.00,0.00,1205.06,886924.16,0.00,0.00,0.00),('1','152','757','257928',4905226,'2668','316',289633.24,289742.54,0.00,0.00,109.30,77603.00,0.00,0.00,0.00),('1','152','757','257928',4905227,'2828','316',86349183.03,86349566.34,0.00,0.00,383.31,282116.16,0.00,0.00,0.00),('1','152','757','257929',4905228,'2123','316',1069634.48,1071018.85,0.00,0.00,1384.37,1018896.32,0.00,0.00,0.00),('1','152','757','257929',4905229,'2124','316',920494.33,921897.12,0.00,0.00,1402.79,1032453.44,0.00,0.00,0.00),('1','152','757','257929',4905230,'2668','316',289742.54,290172.58,0.00,0.00,430.04,305328.40,0.00,0.00,0.00),('1','152','757','257929',4905231,'2828','316',86349566.34,86350425.15,0.00,0.00,858.81,632084.16,0.00,0.00,0.00),('1','152','757','257930',4905232,'2123','316',1071018.85,1072327.27,0.00,0.00,1308.42,962997.12,0.00,0.00,0.00),('1','152','757','257930',4905233,'2124','316',921897.12,923008.50,0.00,0.00,1111.38,817975.68,0.00,0.00,0.00),('1','152','757','257930',4905234,'2668','316',290172.58,290273.38,0.00,0.00,100.80,71568.00,0.00,0.00,0.00),('1','152','757','257930',4905235,'2828','316',86350425.15,86350926.82,0.00,0.00,501.67,369229.12,0.00,0.00,0.00),('1','152','757','257931',4905236,'2123','316',1072327.27,1073552.29,0.00,0.00,1225.02,901614.72,0.00,0.00,0.00),('1','152','757','257931',4905237,'2124','316',923008.50,924138.75,0.00,0.00,1130.25,831864.00,0.00,0.00,0.00),('1','152','757','257931',4905238,'2668','316',290273.38,290437.39,0.00,0.00,164.01,116447.10,0.00,0.00,0.00),('1','152','757','257931',4905239,'2828','316',86350926.82,86351508.38,0.00,0.00,581.56,428028.16,0.00,0.00,0.00),('1','152','757','257932',4905240,'2123','316',1073552.29,1074427.62,0.00,0.00,875.33,644242.88,0.00,0.00,0.00),('1','152','757','257932',4905241,'2124','316',924138.75,924918.82,0.00,0.00,780.07,574131.52,0.00,0.00,0.00),('1','152','757','257932',4905242,'2668','316',290437.39,290517.09,0.00,0.00,79.70,56587.00,0.00,0.00,0.00),('1','152','757','257932',4905243,'2828','316',86351508.38,86351603.08,0.00,0.00,94.70,69699.20,0.00,0.00,0.00),('1','152','757','257933',4905244,'2123','316',1074427.62,1074427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257933',4905245,'2124','316',924918.82,924918.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257933',4905246,'2668','316',290517.09,290517.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257933',4905247,'2828','316',86351603.08,86351603.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257934',4905248,'2123','316',1074427.62,1074675.51,0.00,0.00,247.89,182447.04,0.00,0.00,0.00),('1','152','757','257934',4905249,'2124','316',924918.82,925198.11,0.00,0.00,279.29,205557.44,0.00,0.00,0.00),('1','152','757','257934',4905250,'2668','316',290517.09,290685.19,0.00,0.00,168.10,119351.00,0.00,0.00,0.00),('1','152','757','257934',4905251,'2828','316',86351603.08,86351881.09,0.00,0.00,278.01,204615.36,0.00,0.00,0.00),('1','152','757','257935',4905252,'2123','316',1074675.51,1075897.84,0.00,0.00,1222.33,899634.88,0.00,0.00,0.00),('1','152','757','257935',4905253,'2124','316',925198.11,926467.31,0.00,0.00,1269.20,934131.20,0.00,0.00,0.00),('1','152','757','257935',4905254,'2668','316',290685.19,291237.29,0.00,0.00,552.10,391991.00,0.00,0.00,0.00),('1','152','757','257935',4905255,'2828','316',86351881.09,86352493.35,0.00,0.00,612.26,450623.36,0.00,0.00,0.00),('1','152','757','257936',4905256,'2123','316',1075897.84,1077313.26,0.00,0.00,1415.42,1041749.12,0.00,0.00,0.00),('1','152','757','257936',4905257,'2124','316',926467.31,927717.24,0.00,0.00,1249.93,919948.48,0.00,0.00,0.00),('1','152','757','257936',4905258,'2668','316',291237.29,291756.91,0.00,0.00,519.62,368930.20,0.00,0.00,0.00),('1','152','757','257936',4905259,'2828','316',86352493.35,86352698.34,0.00,0.00,204.99,150872.64,0.00,0.00,0.00),('1','152','757','257937',4905260,'2123','316',1077313.26,1078590.17,0.00,0.00,1276.91,939805.76,0.00,0.00,0.00),('1','152','757','257937',4905261,'2124','316',927717.24,928665.05,0.00,0.00,947.81,697588.16,0.00,0.00,0.00),('1','152','757','257937',4905262,'2668','316',291756.91,291969.54,0.00,0.00,212.63,150967.30,0.00,0.00,0.00),('1','152','757','257937',4905263,'2828','316',86352698.34,86353719.94,0.00,0.00,1021.60,751897.60,0.00,0.00,0.00),('1','152','757','257938',4905264,'2123','316',1078590.17,1080112.46,0.00,0.00,1522.29,1120405.44,0.00,0.00,0.00),('1','152','757','257938',4905265,'2124','316',928665.05,930002.49,0.00,0.00,1337.44,984355.84,0.00,0.00,0.00),('1','152','757','257938',4905266,'2668','316',291969.54,292289.44,0.00,0.00,319.90,227129.00,0.00,0.00,0.00),('1','152','757','257938',4905267,'2828','316',86353719.94,86354412.68,0.00,0.00,692.74,509856.64,0.00,0.00,0.00),('1','152','757','257939',4905268,'2123','316',1080112.46,1081210.05,0.00,0.00,1097.59,807826.24,0.00,0.00,0.00),('1','152','757','257939',4905269,'2124','316',930002.49,930884.34,0.00,0.00,881.85,649041.60,0.00,0.00,0.00),('1','152','757','257939',4905270,'2668','316',292289.44,292492.18,0.00,0.00,202.74,143945.40,0.00,0.00,0.00),('1','152','757','257939',4905271,'2828','316',86354412.68,86355048.33,0.00,0.00,635.65,467838.40,0.00,0.00,0.00),('1','152','757','257940',4905272,'2123','316',1081210.05,1082640.30,0.00,0.00,1430.25,1052664.00,0.00,0.00,0.00),('1','152','757','257940',4905273,'2124','316',930884.34,931986.93,0.00,0.00,1102.59,811506.24,0.00,0.00,0.00),('1','152','757','257940',4905274,'2668','316',292492.18,292768.96,0.00,0.00,276.78,196513.80,0.00,0.00,0.00),('1','152','757','257940',4905275,'2828','316',86355048.33,86355545.08,0.00,0.00,496.75,365608.00,0.00,0.00,0.00),('1','152','757','257941',4905276,'2123','316',1082640.30,1083686.52,0.00,0.00,1046.22,770017.92,0.00,0.00,0.00),('1','152','757','257941',4905277,'2124','316',931986.93,933027.94,0.00,0.00,1041.01,766183.36,0.00,0.00,0.00),('1','152','757','257941',4905278,'2668','316',292768.96,293351.35,0.00,0.00,582.39,413496.90,0.00,0.00,0.00),('1','152','757','257941',4905279,'2828','316',86355545.08,86356046.53,0.00,0.00,501.45,369067.20,0.00,0.00,0.00),('1','152','757','257942',4905280,'2123','316',1083686.52,1083686.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257942',4905281,'2124','316',933027.94,933027.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257942',4905282,'2668','316',293351.35,293351.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257942',4905283,'2828','316',86356046.53,86356046.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257943',4905284,'2123','316',1083686.52,1084980.71,0.00,0.00,1294.19,952523.84,0.00,0.00,0.00),('1','152','757','257943',4905285,'2124','316',933027.94,934143.20,0.00,0.00,1115.26,820831.36,0.00,0.00,0.00),('1','152','757','257943',4905286,'2668','316',293351.35,293826.42,0.00,0.00,475.07,337766.14,0.00,0.00,0.00),('1','152','757','257943',4905287,'2828','316',86356046.53,86356648.60,0.00,0.00,602.07,443123.52,0.00,0.00,0.00),('1','152','757','257944',4905288,'2123','316',1084980.71,1086235.28,0.00,0.00,1254.57,923363.52,0.00,0.00,0.00),('1','152','757','257944',4905289,'2124','316',934143.20,935253.01,0.00,0.00,1109.81,816820.16,0.00,0.00,0.00),('1','152','757','257944',4905290,'2668','316',293826.42,294894.82,0.00,0.00,1068.40,758564.00,0.00,0.00,0.00),('1','152','757','257944',4905291,'2828','316',86356648.60,86357505.11,0.00,0.00,856.51,630391.36,0.00,0.00,0.00),('1','152','757','257945',4905292,'2123','316',1086235.28,1087567.85,0.00,0.00,1332.57,980478.50,0.00,0.00,0.00),('1','152','757','257945',4905293,'2124','316',935253.01,936420.47,0.00,0.00,1167.46,859250.56,0.00,0.00,0.00),('1','152','757','257945',4905294,'2668','316',294894.82,295649.62,0.00,0.00,754.80,535908.00,0.00,0.00,0.00),('1','152','757','257945',4905295,'2828','316',86357505.11,86358466.08,0.00,0.00,960.97,707273.92,0.00,0.00,0.00),('1','152','757','257946',4905296,'2123','316',1087567.85,1088849.65,0.00,0.00,1281.80,943404.80,0.00,0.00,0.00),('1','152','757','257946',4905297,'2124','316',936420.47,937691.10,0.00,0.00,1270.63,935183.68,0.00,0.00,0.00),('1','152','757','257946',4905298,'2668','316',295649.62,296234.58,0.00,0.00,584.96,415321.60,0.00,0.00,0.00),('1','152','757','257946',4905299,'2828','316',86358466.08,86359098.55,0.00,0.00,632.47,465497.92,0.00,0.00,0.00),('1','152','757','257947',4905300,'2123','316',1088849.65,1090172.85,0.00,0.00,1323.20,973875.20,0.00,0.00,0.00),('1','152','757','257947',4905301,'2124','316',937691.10,938839.55,0.00,0.00,1148.45,845259.20,0.00,0.00,0.00),('1','152','757','257947',4905302,'2668','316',296234.58,296617.39,0.00,0.00,382.81,271795.10,0.00,0.00,0.00),('1','152','757','257947',4905303,'2828','316',86359098.55,86359415.25,0.00,0.00,316.70,233091.20,0.00,0.00,0.00),('1','152','757','257948',4905304,'2123','316',1090172.85,1091404.65,0.00,0.00,1231.80,906604.80,0.00,0.00,0.00),('1','152','757','257948',4905305,'2124','316',938839.55,940167.04,0.00,0.00,1327.49,977032.64,0.00,0.00,0.00),('1','152','757','257948',4905306,'2668','316',296617.39,297166.02,0.00,0.00,548.63,389527.30,0.00,0.00,0.00),('1','152','757','257948',4905307,'2828','316',86359415.25,86360011.54,0.00,0.00,596.29,438869.44,0.00,0.00,0.00),('1','152','757','257949',4905308,'2123','316',1091404.65,1092546.87,0.00,0.00,1142.22,840673.92,0.00,0.00,0.00),('1','152','757','257949',4905309,'2124','316',940167.04,940926.19,0.00,0.00,759.15,558734.40,0.00,0.00,0.00),('1','152','757','257949',4905310,'2668','316',297166.02,297302.12,0.00,0.00,136.10,96631.00,0.00,0.00,0.00),('1','152','757','257949',4905311,'2828','316',86360011.54,86360230.16,0.00,0.00,218.62,160904.32,0.00,0.00,0.00),('1','152','757','257950',4905312,'2123','316',1092546.87,1092546.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257950',4905313,'2124','316',940926.19,940926.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257950',4905314,'2668','316',297302.12,297302.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257950',4905315,'2828','316',86360230.16,86360230.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257951',4905316,'2123','316',1092546.87,1092743.30,0.00,0.00,196.43,144572.48,0.00,0.00,0.00),('1','152','757','257951',4905317,'2124','316',940926.19,941120.21,0.00,0.00,194.02,142798.72,0.00,0.00,0.00),('1','152','757','257951',4905318,'2668','316',297302.12,297584.44,0.00,0.00,282.32,200447.20,0.00,0.00,0.00),('1','152','757','257951',4905319,'2828','316',86360230.16,86360509.57,0.00,0.00,279.41,205645.76,0.00,0.00,0.00),('1','152','757','257952',4905320,'2123','316',1092743.30,1093747.69,0.00,0.00,1004.39,739231.04,0.00,0.00,0.00),('1','152','757','257952',4905321,'2124','316',941120.21,942294.74,0.00,0.00,1174.53,864454.08,0.00,0.00,0.00),('1','152','757','257952',4905322,'2668','316',297584.44,297884.44,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','152','757','257952',4905323,'2828','316',86360509.57,86360889.86,0.00,0.00,380.29,279893.44,0.00,0.00,0.00),('1','152','757','257953',4905324,'2123','316',1093747.69,1094857.57,0.00,0.00,1109.88,816871.68,0.00,0.00,0.00),('1','152','757','257953',4905325,'2124','316',942294.74,943046.16,0.00,0.00,751.42,553045.12,0.00,0.00,0.00),('1','152','757','257953',4905326,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257953',4905327,'2828','316',86360889.86,86361095.50,0.00,0.00,205.64,151351.04,0.00,0.00,0.00),('1','152','757','257954',4905328,'2123','316',1094857.57,1095162.00,0.00,0.00,304.43,224060.48,0.00,0.00,0.00),('1','152','757','257954',4905329,'2124','316',943046.16,943288.00,0.00,0.00,241.84,177994.24,0.00,0.00,0.00),('1','152','757','257954',4905330,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257954',4905331,'2828','316',86361095.50,86361412.34,0.00,0.00,316.84,233194.24,0.00,0.00,0.00),('1','152','757','257955',4905332,'2123','316',1095162.00,1096350.95,0.00,0.00,1188.95,875067.20,0.00,0.00,0.00),('1','152','757','257955',4905333,'2124','316',943288.00,944454.28,0.00,0.00,1166.28,858382.08,0.00,0.00,0.00),('1','152','757','257955',4905334,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257955',4905335,'2828','316',86361412.34,86362093.72,0.00,0.00,681.38,501495.68,0.00,0.00,0.00),('1','152','757','257956',4905336,'2123','316',1096350.95,1097247.18,0.00,0.00,896.23,659625.28,0.00,0.00,0.00),('1','152','757','257956',4905337,'2124','316',944454.28,945245.68,0.00,0.00,791.40,582470.40,0.00,0.00,0.00),('1','152','757','257956',4905338,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257956',4905339,'2828','316',86362093.72,86362346.07,0.00,0.00,252.35,185729.60,0.00,0.00,0.00),('1','152','757','257957',4905340,'2123','316',1097247.18,1097682.62,0.00,0.00,435.44,320483.84,0.00,0.00,0.00),('1','152','757','257957',4905341,'2124','316',945245.68,945622.85,0.00,0.00,377.17,277597.12,0.00,0.00,0.00),('1','152','757','257957',4905342,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257957',4905343,'2828','316',86362346.07,86362623.33,0.00,0.00,277.26,204063.36,0.00,0.00,0.00),('1','152','757','257958',4905344,'2123','316',1097682.62,1098615.59,0.00,0.00,932.97,686665.92,0.00,0.00,0.00),('1','152','757','257958',4905345,'2124','316',945622.85,946786.06,0.00,0.00,1163.21,856122.56,0.00,0.00,0.00),('1','152','757','257958',4905346,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257958',4905347,'2828','316',86362623.33,86362949.32,0.00,0.00,325.99,239928.64,0.00,0.00,0.00),('1','152','757','257959',4905348,'2123','316',1098615.59,1098752.76,0.00,0.00,137.17,100957.12,0.00,0.00,0.00),('1','152','757','257959',4905349,'2124','316',946786.06,946887.57,0.00,0.00,101.51,74711.36,0.00,0.00,0.00),('1','152','757','257959',4905350,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257959',4905351,'2828','316',86362949.32,86362949.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257960',4905352,'2123','316',1098752.76,1098752.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257960',4905353,'2124','316',946887.57,946887.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257960',4905354,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257960',4905355,'2828','316',86362949.32,86362949.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257961',4905356,'2123','316',1098752.76,1099746.09,0.00,0.00,993.33,731090.88,0.00,0.00,0.00),('1','152','757','257961',4905357,'2124','316',946887.57,947685.27,0.00,0.00,797.70,587107.20,0.00,0.00,0.00),('1','152','757','257961',4905358,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257961',4905359,'2828','316',86362949.32,86363471.61,0.00,0.00,522.29,420469.44,0.00,0.00,0.00),('1','152','757','257962',4905360,'2123','316',1099746.09,1100712.07,0.00,0.00,965.98,710961.28,0.00,0.00,0.00),('1','152','757','257962',4905361,'2124','316',947685.27,948795.06,0.00,0.00,1109.79,816805.44,0.00,0.00,0.00),('1','152','757','257962',4905362,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257962',4905363,'2828','316',86363471.61,86363971.89,0.00,0.00,500.28,368206.08,0.00,0.00,0.00),('1','152','757','257963',4905364,'2123','316',1100712.07,1101695.30,0.00,0.00,983.23,723657.28,0.00,0.00,0.00),('1','152','757','257963',4905365,'2124','316',948795.06,949727.33,0.00,0.00,932.27,686150.72,0.00,0.00,0.00),('1','152','757','257963',4905366,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257963',4905367,'2828','316',86363971.89,86364508.34,0.00,0.00,536.45,394827.20,0.00,0.00,0.00),('1','152','757','257964',4905368,'2123','316',1101695.30,1102699.86,0.00,0.00,1004.56,739356.16,0.00,0.00,0.00),('1','152','757','257964',4905369,'2124','316',949727.33,950889.12,0.00,0.00,1161.79,855077.44,0.00,0.00,0.00),('1','152','757','257964',4905370,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257964',4905371,'2828','316',86364508.34,86365017.25,0.00,0.00,508.91,374557.76,0.00,0.00,0.00),('1','152','757','257965',4905372,'2123','316',1102699.86,1103185.59,0.00,0.00,485.73,357497.28,0.00,0.00,0.00),('1','152','757','257965',4905373,'2124','316',950889.12,951207.94,0.00,0.00,318.82,234651.52,0.00,0.00,0.00),('1','152','757','257965',4905374,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257965',4905375,'2828','316',86365017.25,86365460.00,0.00,0.00,442.75,325864.00,0.00,0.00,0.00),('1','152','757','257966',4905376,'2123','316',1103185.59,1103674.54,0.00,0.00,488.95,359867.20,0.00,0.00,0.00),('1','152','757','257966',4905377,'2124','316',951207.94,951670.31,0.00,0.00,462.37,340304.32,0.00,0.00,0.00),('1','152','757','257966',4905378,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257966',4905379,'2828','316',86365460.00,86365573.81,0.00,0.00,113.81,83764.16,0.00,0.00,0.00),('1','152','757','257967',4905380,'2123','316',1103674.54,1104555.49,0.00,0.00,880.95,648379.20,0.00,0.00,0.00),('1','152','757','257967',4905381,'2124','316',951670.31,952653.66,0.00,0.00,983.35,723745.60,0.00,0.00,0.00),('1','152','757','257967',4905382,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257967',4905383,'2828','316',86365573.81,86366502.47,0.00,0.00,928.66,683493.76,0.00,0.00,0.00),('1','152','757','257968',4905384,'2123','316',1104555.49,1105590.06,0.00,0.00,1034.57,761443.52,0.00,0.00,0.00),('1','152','757','257968',4905385,'2124','316',952653.66,953550.98,0.00,0.00,897.32,660427.52,0.00,0.00,0.00),('1','152','757','257968',4905386,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257968',4905387,'2828','316',86366502.47,86366782.01,0.00,0.00,279.54,205741.44,0.00,0.00,0.00),('1','152','757','257969',4905388,'2123','316',1105590.06,1106359.07,0.00,0.00,769.01,565991.36,0.00,0.00,0.00),('1','152','757','257969',4905389,'2124','316',953550.98,954131.58,0.00,0.00,580.60,427321.60,0.00,0.00,0.00),('1','152','757','257969',4905390,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257969',4905391,'2828','316',86366782.01,86367757.99,0.00,0.00,975.98,718321.28,0.00,0.00,0.00),('1','152','757','257970',4905392,'2123','316',1106359.07,1107519.93,0.00,0.00,1160.86,854392.96,0.00,0.00,0.00),('1','152','757','257970',4905393,'2124','316',954131.58,955027.13,0.00,0.00,895.55,659124.80,0.00,0.00,0.00),('1','152','757','257970',4905394,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257970',4905395,'2828','316',86367757.99,86368214.74,0.00,0.00,456.75,336168.00,0.00,0.00,0.00),('1','152','757','257971',4905396,'2123','316',1107519.93,1108322.57,0.00,0.00,802.64,590743.04,0.00,0.00,0.00),('1','152','757','257971',4905397,'2124','316',955027.13,955699.98,0.00,0.00,672.85,495217.60,0.00,0.00,0.00),('1','152','757','257971',4905398,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257971',4905399,'2828','316',86368214.74,86368891.42,0.00,0.00,676.68,498036.48,0.00,0.00,0.00),('1','152','757','257972',4905400,'2123','316',1108322.57,1108322.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257972',4905401,'2124','316',955699.98,955699.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257972',4905402,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257972',4905403,'2828','316',86368891.42,86368891.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257973',4905404,'2123','316',1108322.57,1108388.28,0.00,0.00,65.71,48362.56,0.00,0.00,0.00),('1','152','757','257973',4905405,'2124','316',955699.98,955814.76,0.00,0.00,114.78,84478.08,0.00,0.00,0.00),('1','152','757','257973',4905406,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257973',4905407,'2828','316',86368891.42,86368950.45,0.00,0.00,59.03,43446.08,0.00,0.00,0.00),('1','152','757','257974',4905408,'2123','316',1108388.28,1109573.83,0.00,0.00,1185.55,872564.80,0.00,0.00,0.00),('1','152','757','257974',4905409,'2124','316',955814.76,956619.96,0.00,0.00,805.20,592627.20,0.00,0.00,0.00),('1','152','757','257974',4905410,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257974',4905411,'2828','316',86368950.45,86369222.84,0.00,0.00,272.39,200479.04,0.00,0.00,0.00),('1','152','757','257975',4905412,'2123','316',1109573.83,1110584.82,0.00,0.00,1010.99,744088.64,0.00,0.00,0.00),('1','152','757','257975',4905413,'2124','316',956619.96,957346.76,0.00,0.00,726.80,534924.80,0.00,0.00,0.00),('1','152','757','257975',4905414,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257975',4905415,'2828','316',86369222.84,86370166.39,0.00,0.00,943.55,694452.80,0.00,0.00,0.00),('1','152','757','257976',4905416,'2123','316',1110584.82,1112189.57,0.00,0.00,1604.75,1181096.00,0.00,0.00,0.00),('1','152','757','257976',4905417,'2124','316',957346.76,958807.33,0.00,0.00,1460.57,1074979.52,0.00,0.00,0.00),('1','152','757','257976',4905418,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257976',4905419,'2828','316',86370166.39,86370357.97,0.00,0.00,191.58,141002.88,0.00,0.00,0.00),('1','152','757','257977',4905420,'2123','316',1112189.57,1113348.63,0.00,0.00,1159.06,853068.16,0.00,0.00,0.00),('1','152','757','257977',4905421,'2124','316',958807.33,959641.18,0.00,0.00,833.85,613713.60,0.00,0.00,0.00),('1','152','757','257977',4905422,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257977',4905423,'2828','316',86370357.97,86370357.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257978',4905424,'2123','316',1113348.63,1114762.37,0.00,0.00,1413.74,1040512.64,0.00,0.00,0.00),('1','152','757','257978',4905425,'2124','316',959641.18,960620.64,0.00,0.00,979.46,720882.56,0.00,0.00,0.00),('1','152','757','257978',4905426,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257978',4905427,'2828','316',86370357.97,86370370.20,0.00,0.00,12.23,9001.28,0.00,0.00,0.00),('1','152','757','257979',4905428,'2123','316',1114762.37,1116131.83,0.00,0.00,1369.46,1007922.56,0.00,0.00,0.00),('1','152','757','257979',4905429,'2124','316',960620.64,961482.78,0.00,0.00,862.14,634535.04,0.00,0.00,0.00),('1','152','757','257979',4905430,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257979',4905431,'2828','316',86370370.20,86370370.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257980',4905432,'2123','316',1116131.83,1116933.73,0.00,0.00,801.90,590198.40,0.00,0.00,0.00),('1','152','757','257980',4905433,'2124','316',961482.78,962885.75,0.00,0.00,1402.97,1032585.92,0.00,0.00,0.00),('1','152','757','257980',4905434,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257980',4905435,'2828','316',86370370.20,86370578.45,0.00,0.00,208.25,153272.00,0.00,0.00,0.00),('1','152','757','257981',4905436,'2123','316',1116933.73,1118498.72,0.00,0.00,1564.99,1151832.64,0.00,0.00,0.00),('1','152','757','257981',4905437,'2124','316',962885.75,963253.71,0.00,0.00,367.96,270818.56,0.00,0.00,0.00),('1','152','757','257981',4905438,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257981',4905439,'2828','316',86370578.45,86370578.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257982',4905440,'2123','316',1118498.72,1119906.92,0.00,0.00,1408.20,1036435.20,0.00,0.00,0.00),('1','152','757','257982',4905441,'2124','316',963253.71,964108.09,0.00,0.00,854.38,628823.68,0.00,0.00,0.00),('1','152','757','257982',4905442,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257982',4905443,'2828','316',86370578.45,86370611.36,0.00,0.00,32.91,24221.76,0.00,0.00,0.00),('1','152','757','257983',4905444,'2123','316',1119906.92,1121082.17,0.00,0.00,1175.25,864984.00,0.00,0.00,0.00),('1','152','757','257983',4905445,'2124','316',964108.09,964777.05,0.00,0.00,668.96,492354.56,0.00,0.00,0.00),('1','152','757','257983',4905446,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257983',4905447,'2828','316',86370611.36,86371187.85,0.00,0.00,576.49,424296.64,0.00,0.00,0.00),('1','152','757','257984',4905448,'2123','316',1121082.17,1121415.30,0.00,0.00,333.13,245183.68,0.00,0.00,0.00),('1','152','757','257984',4905449,'2124','316',964777.05,965064.25,0.00,0.00,287.20,211379.20,0.00,0.00,0.00),('1','152','757','257984',4905450,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257984',4905451,'2828','316',86371187.85,86371187.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257985',4905452,'2123','316',1121415.30,1121415.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257985',4905453,'2124','316',965064.25,965064.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257985',4905454,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257985',4905455,'2828','316',86371187.85,86371187.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257986',4905456,'2123','316',1121415.30,1122078.41,0.00,0.00,663.11,488048.96,0.00,0.00,0.00),('1','152','757','257986',4905457,'2124','316',965064.25,965552.81,0.00,0.00,488.56,359580.16,0.00,0.00,0.00),('1','152','757','257986',4905458,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257986',4905459,'2828','316',86371187.85,86371288.53,0.00,0.00,100.68,74100.48,0.00,0.00,0.00),('1','152','757','257987',4905460,'2123','316',1122078.41,1122790.84,0.00,0.00,712.43,524348.48,0.00,0.00,0.00),('1','152','757','257987',4905461,'2124','316',965552.81,966004.13,0.00,0.00,451.32,332171.52,0.00,0.00,0.00),('1','152','757','257987',4905462,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257987',4905463,'2828','316',86371288.53,86371934.88,0.00,0.00,646.35,475713.60,0.00,0.00,0.00),('1','152','757','257988',4905464,'2123','316',1122790.84,1123895.81,0.00,0.00,1104.97,813257.92,0.00,0.00,0.00),('1','152','757','257988',4905465,'2124','316',966004.13,966765.55,0.00,0.00,761.42,560405.12,0.00,0.00,0.00),('1','152','757','257988',4905466,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257988',4905467,'2828','316',86371934.88,86372034.08,0.00,0.00,99.20,73011.20,0.00,0.00,0.00),('1','152','757','257989',4905468,'2123','316',1123895.81,1124645.66,0.00,0.00,749.85,551889.60,0.00,0.00,0.00),('1','152','757','257989',4905469,'2124','316',966765.55,967274.54,0.00,0.00,508.99,374616.64,0.00,0.00,0.00),('1','152','757','257989',4905470,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257989',4905471,'2828','316',86372034.08,86372671.87,0.00,0.00,637.79,469413.44,0.00,0.00,0.00),('1','152','757','257990',4905472,'2123','316',1124645.66,1125679.66,0.00,0.00,1034.00,761024.00,0.00,0.00,0.00),('1','152','757','257990',4905473,'2124','316',967274.54,968156.15,0.00,0.00,881.61,648864.96,0.00,0.00,0.00),('1','152','757','257990',4905474,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257990',4905475,'2828','316',86372671.87,86372801.60,0.00,0.00,129.73,95481.28,0.00,0.00,0.00),('1','152','757','257991',4905476,'2123','316',1125679.66,1126750.89,0.00,0.00,1071.23,788425.28,0.00,0.00,0.00),('1','152','757','257991',4905477,'2124','316',968156.15,968835.30,0.00,0.00,679.15,499854.40,0.00,0.00,0.00),('1','152','757','257991',4905478,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257991',4905479,'2828','316',86372801.60,86373336.07,0.00,0.00,534.47,393369.92,0.00,0.00,0.00),('1','152','757','257992',4905480,'2123','316',1126750.89,1128006.27,0.00,0.00,1255.38,923959.68,0.00,0.00,0.00),('1','152','757','257992',4905481,'2124','316',968835.30,969869.30,0.00,0.00,1034.00,761024.00,0.00,0.00,0.00),('1','152','757','257992',4905482,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257992',4905483,'2828','316',86373336.07,86373485.03,0.00,0.00,148.96,109634.56,0.00,0.00,0.00),('1','152','757','257993',4905484,'2123','316',1128006.27,1128885.16,0.00,0.00,878.89,646863.04,0.00,0.00,0.00),('1','152','757','257993',4905485,'2124','316',969869.30,970467.62,0.00,0.00,598.32,440363.52,0.00,0.00,0.00),('1','152','757','257993',4905486,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257993',4905487,'2828','316',86373485.03,86374048.12,0.00,0.00,563.09,414434.24,0.00,0.00,0.00),('1','152','757','257994',4905488,'2123','316',1128885.16,1129955.23,0.00,0.00,1070.07,787571.52,0.00,0.00,0.00),('1','152','757','257994',4905489,'2124','316',970467.62,971269.08,0.00,0.00,801.46,589874.56,0.00,0.00,0.00),('1','152','757','257994',4905490,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257994',4905491,'2828','316',86374048.12,86374246.34,0.00,0.00,198.22,145889.92,0.00,0.00,0.00),('1','152','757','257995',4905492,'2123','316',1129955.23,1130841.83,0.00,0.00,886.60,652537.60,0.00,0.00,0.00),('1','152','757','257995',4905493,'2124','316',971269.08,972099.60,0.00,0.00,830.52,611262.72,0.00,0.00,0.00),('1','152','757','257995',4905494,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257995',4905495,'2828','316',86374246.34,86374578.63,0.00,0.00,332.29,244565.44,0.00,0.00,0.00),('1','152','757','257996',4905496,'2123','316',1130841.83,1131881.04,0.00,0.00,1039.21,764858.56,0.00,0.00,0.00),('1','152','757','257996',4905497,'2124','316',972099.60,973200.62,0.00,0.00,1101.02,810350.72,0.00,0.00,0.00),('1','152','757','257996',4905498,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257996',4905499,'2828','316',86374578.63,86374854.79,0.00,0.00,276.16,203253.76,0.00,0.00,0.00),('1','152','757','257997',4905500,'2123','316',1131881.04,1132785.10,0.00,0.00,904.06,665388.16,0.00,0.00,0.00),('1','152','757','257997',4905501,'2124','316',973200.62,974182.33,0.00,0.00,981.71,722538.56,0.00,0.00,0.00),('1','152','757','257997',4905502,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257997',4905503,'2828','316',86374854.79,86375048.01,0.00,0.00,193.22,142209.92,0.00,0.00,0.00),('1','152','757','257998',4905504,'2123','316',1132785.10,1132785.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257998',4905505,'2124','316',974182.33,974182.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257998',4905506,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257998',4905507,'2828','316',86375048.01,86375048.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257999',4905508,'2123','316',1132785.10,1133119.47,0.00,0.00,334.37,246096.32,0.00,0.00,0.00),('1','152','757','257999',4905509,'2124','316',974182.33,974540.43,0.00,0.00,358.10,263561.60,0.00,0.00,0.00),('1','152','757','257999',4905510,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','257999',4905511,'2828','316',86375048.01,86375318.95,0.00,0.00,270.94,199411.84,0.00,0.00,0.00),('1','152','757','258000',4905512,'2123','316',1133119.47,1134409.20,0.00,0.00,1289.73,949241.28,0.00,0.00,0.00),('1','152','757','258000',4905513,'2124','316',974540.43,975781.39,0.00,0.00,1240.96,913346.56,0.00,0.00,0.00),('1','152','757','258000',4905514,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258000',4905515,'2828','316',86375318.95,86375379.38,0.00,0.00,60.43,44476.48,0.00,0.00,0.00),('1','152','757','258001',4905516,'2123','316',1134409.20,1135567.62,0.00,0.00,1158.42,852597.12,0.00,0.00,0.00),('1','152','757','258001',4905517,'2124','316',975781.39,976840.76,0.00,0.00,1059.37,779696.32,0.00,0.00,0.00),('1','152','757','258001',4905518,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258001',4905519,'2828','316',86375379.38,86375447.06,0.00,0.00,67.68,49812.48,0.00,0.00,0.00),('1','152','757','258002',4905520,'2123','316',1135567.62,1136361.30,0.00,0.00,793.68,584148.48,0.00,0.00,0.00),('1','152','757','258002',4905521,'2124','316',976840.76,977517.34,0.00,0.00,676.58,497962.88,0.00,0.00,0.00),('1','152','757','258002',4905522,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258002',4905523,'2828','316',86375447.06,86375869.32,0.00,0.00,422.26,310783.36,0.00,0.00,0.00),('1','152','757','258003',4905524,'2123','316',1136361.30,1137476.60,0.00,0.00,1115.30,820860.80,0.00,0.00,0.00),('1','152','757','258003',4905525,'2124','316',977517.34,978388.02,0.00,0.00,870.68,640820.48,0.00,0.00,0.00),('1','152','757','258003',4905526,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258003',4905527,'2828','316',86375869.32,86375938.34,0.00,0.00,69.02,50798.72,0.00,0.00,0.00),('1','152','757','258004',4905528,'2123','316',1137476.60,1138229.19,0.00,0.00,752.59,553906.24,0.00,0.00,0.00),('1','152','757','258004',4905529,'2124','316',978388.02,979074.92,0.00,0.00,686.90,505558.40,0.00,0.00,0.00),('1','152','757','258004',4905530,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258004',4905531,'2828','316',86375938.34,86376534.68,0.00,0.00,596.34,438906.24,0.00,0.00,0.00),('1','152','757','258005',4905532,'2123','316',1138229.19,1139427.06,0.00,0.00,1197.87,881632.32,0.00,0.00,0.00),('1','152','757','258005',4905533,'2124','316',979074.92,980174.88,0.00,0.00,1099.96,809570.56,0.00,0.00,0.00),('1','152','757','258005',4905534,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258005',4905535,'2828','316',86376534.68,86376674.67,0.00,0.00,139.99,103032.64,0.00,0.00,0.00),('1','152','757','258006',4905536,'2123','316',1139427.06,1140410.80,0.00,0.00,983.74,724032.64,0.00,0.00,0.00),('1','152','757','258006',4905537,'2124','316',980174.88,981056.51,0.00,0.00,881.63,648879.68,0.00,0.00,0.00),('1','152','757','258006',4905538,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258006',4905539,'2828','316',86376674.67,86377320.09,0.00,0.00,645.42,475029.12,0.00,0.00,0.00),('1','152','757','258007',4905540,'2123','316',1140410.80,1141349.68,0.00,0.00,938.88,691015.68,0.00,0.00,0.00),('1','152','757','258007',4905541,'2124','316',981056.51,982257.30,0.00,0.00,1200.79,883781.44,0.00,0.00,0.00),('1','152','757','258007',4905542,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258007',4905543,'2828','316',86377320.09,86377481.59,0.00,0.00,161.50,118864.00,0.00,0.00,0.00),('1','152','757','258008',4905544,'2123','316',1141349.68,1141349.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258008',4905545,'2124','316',982257.30,982257.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258008',4905546,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258008',4905547,'2828','316',86377481.59,86377481.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258009',4905548,'2123','316',1141349.68,1141467.81,0.00,0.00,118.13,86943.68,0.00,0.00,0.00),('1','152','757','258009',4905549,'2124','316',982257.30,982373.61,0.00,0.00,116.31,85604.16,0.00,0.00,0.00),('1','152','757','258009',4905550,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258009',4905551,'2828','316',86377481.59,86377584.72,0.00,0.00,103.13,75903.68,0.00,0.00,0.00),('1','152','757','258010',4905552,'2123','316',1141467.81,1142393.81,0.00,0.00,926.00,681536.00,0.00,0.00,0.00),('1','152','757','258010',4905553,'2124','316',982373.61,983252.29,0.00,0.00,878.68,646708.48,0.00,0.00,0.00),('1','152','757','258010',4905554,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258010',4905555,'2828','316',86377584.72,86378112.63,0.00,0.00,527.91,388541.76,0.00,0.00,0.00),('1','152','757','258011',4905556,'2123','316',1142393.81,1143509.62,0.00,0.00,1115.81,821236.16,0.00,0.00,0.00),('1','152','757','258011',4905557,'2124','316',983252.29,984026.33,0.00,0.00,774.04,569693.44,0.00,0.00,0.00),('1','152','757','258011',4905558,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258011',4905559,'2828','316',86378112.63,86378290.97,0.00,0.00,178.34,131258.24,0.00,0.00,0.00),('1','152','757','258012',4905560,'2123','316',1143509.62,1143539.94,0.00,0.00,30.32,22315.52,0.00,0.00,0.00),('1','152','757','258012',4905561,'2124','316',984026.33,984065.19,0.00,0.00,38.86,28600.96,0.00,0.00,0.00),('1','152','757','258012',4905562,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258012',4905563,'2828','316',86378290.97,86378290.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258013',4905564,'2123','316',1143539.94,1144212.09,0.00,0.00,672.15,487980.90,0.00,0.00,0.00),('1','152','757','258013',4905565,'2124','316',984065.19,984671.54,0.00,0.00,606.35,440210.10,0.00,0.00,0.00),('1','152','757','258013',4905566,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258013',4905567,'2828','316',86378290.97,86378867.54,0.00,0.00,576.57,418589.82,0.00,0.00,0.00),('1','152','757','258014',4905568,'2123','316',1144212.09,1145377.92,0.00,0.00,1165.83,846392.58,0.00,0.00,0.00),('1','152','757','258014',4905569,'2124','316',984671.54,985519.72,0.00,0.00,848.18,615778.68,0.00,0.00,0.00),('1','152','757','258014',4905570,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258014',4905571,'2828','316',86378867.54,86378942.82,0.00,0.00,75.28,54653.28,0.00,0.00,0.00),('1','152','757','258015',4905572,'2123','316',1145377.92,1146144.25,0.00,0.00,766.33,556355.58,0.00,0.00,0.00),('1','152','757','258015',4905573,'2124','316',985519.72,986238.31,0.00,0.00,718.59,521696.34,0.00,0.00,0.00),('1','152','757','258015',4905574,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258015',4905575,'2828','316',86378942.82,86379514.50,0.00,0.00,571.68,415039.68,0.00,0.00,0.00),('1','152','757','258016',4905576,'2123','316',1146144.25,1147007.93,0.00,0.00,863.68,627031.68,0.00,0.00,0.00),('1','152','757','258016',4905577,'2124','316',986238.31,987092.46,0.00,0.00,854.15,620112.90,0.00,0.00,0.00),('1','152','757','258016',4905578,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258016',4905579,'2828','316',86379514.50,86379514.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258017',4905580,'2123','316',1147007.93,1147293.98,0.00,0.00,286.05,207672.30,0.00,0.00,0.00),('1','152','757','258017',4905581,'2124','316',987092.46,987357.78,0.00,0.00,265.32,192622.32,0.00,0.00,0.00),('1','152','757','258017',4905582,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258017',4905583,'2828','316',86379514.50,86379734.88,0.00,0.00,220.38,159995.88,0.00,0.00,0.00),('1','152','757','258018',4905584,'2123','316',1147293.98,1147293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258018',4905585,'2124','316',987357.78,987357.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258018',4905586,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258018',4905587,'2828','316',86379734.88,86379734.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258019',4905588,'2123','316',1147293.98,1147731.68,0.00,0.00,437.70,317770.20,0.00,0.00,0.00),('1','152','757','258019',4905589,'2124','316',987357.78,987862.67,0.00,0.00,504.89,366550.14,0.00,0.00,0.00),('1','152','757','258019',4905590,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258019',4905591,'2828','316',86379734.88,86380067.32,0.00,0.00,332.44,241351.44,0.00,0.00,0.00),('1','152','757','258020',4905592,'2123','316',1147731.68,1148599.32,0.00,0.00,867.64,629906.64,0.00,0.00,0.00),('1','152','757','258020',4905593,'2124','316',987862.67,988504.32,0.00,0.00,641.65,465837.90,0.00,0.00,0.00),('1','152','757','258020',4905594,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258020',4905595,'2828','316',86380067.32,86380287.77,0.00,0.00,220.45,160046.70,0.00,0.00,0.00),('1','152','757','258021',4905596,'2123','316',1148599.32,1149554.72,0.00,0.00,955.40,693620.40,0.00,0.00,0.00),('1','152','757','258021',4905597,'2124','316',988504.32,989602.23,0.00,0.00,1097.91,797082.66,0.00,0.00,0.00),('1','152','757','258021',4905598,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258021',4905599,'2828','316',86380287.77,86380287.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258022',4905600,'2123','316',1149554.72,1149896.12,0.00,0.00,341.40,247856.40,0.00,0.00,0.00),('1','152','757','258022',4905601,'2124','316',989602.23,989893.03,0.00,0.00,290.80,211120.80,0.00,0.00,0.00),('1','152','757','258022',4905602,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258022',4905603,'2828','316',86380287.77,86380287.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258023',4905604,'2123','316',1149896.12,1150553.84,0.00,0.00,657.72,477504.72,0.00,0.00,0.00),('1','152','757','258023',4905605,'2124','316',989893.03,990448.80,0.00,0.00,555.77,403489.02,0.00,0.00,0.00),('1','152','757','258023',4905606,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258023',4905607,'2828','316',86380287.77,86380360.43,0.00,0.00,72.66,52751.16,0.00,0.00,0.00),('1','152','757','258024',4905608,'2123','316',1150553.84,1151379.10,0.00,0.00,825.26,599138.76,0.00,0.00,0.00),('1','152','757','258024',4905609,'2124','316',990448.80,991345.59,0.00,0.00,896.79,651069.54,0.00,0.00,0.00),('1','152','757','258024',4905610,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258024',4905611,'2828','316',86380360.43,86381268.09,0.00,0.00,907.66,658961.16,0.00,0.00,0.00),('1','152','757','258025',4905612,'2123','316',1151379.10,1152653.66,0.00,0.00,1274.56,925330.56,0.00,0.00,0.00),('1','152','757','258025',4905613,'2124','316',991345.59,993021.83,0.00,0.00,1676.24,1216950.24,0.00,0.00,0.00),('1','152','757','258025',4905614,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258025',4905615,'2828','316',86381268.09,86381537.77,0.00,0.00,269.68,195787.68,0.00,0.00,0.00),('1','152','757','258026',4905616,'2123','316',1152653.66,1153774.59,0.00,0.00,1120.93,813795.18,0.00,0.00,0.00),('1','152','757','258026',4905617,'2124','316',993021.83,994127.65,0.00,0.00,1105.82,802825.32,0.00,0.00,0.00),('1','152','757','258026',4905618,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258026',4905619,'2828','316',86381537.77,86381537.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258027',4905620,'2123','316',1153774.59,1153778.72,0.00,0.00,4.13,2998.38,0.00,0.00,0.00),('1','152','757','258027',4905621,'2124','316',994127.65,994136.40,0.00,0.00,8.75,6352.50,0.00,0.00,0.00),('1','152','757','258027',4905622,'2668','316',297884.44,297884.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','152','757','258027',4905623,'2828','316',86381537.77,86381571.66,0.00,0.00,33.89,24604.14,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730148 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','152','143130','316',202.00,256.00,0.00,4396.71,888135.42,1055753.76,167618.34,430426),('1','152','143151','316',202.00,256.00,0.00,1303.35,263276.70,316773.60,53496.90,430485),('1','152','143242','316',202.00,256.00,0.00,66.00,13332.00,14124.00,792.00,430752),('1','152','143251','316',202.00,256.00,0.00,3248.15,656126.30,799654.28,143527.98,430778),('1','152','143256','316',202.00,256.00,0.00,2452.51,495407.02,572745.70,77338.68,430791),('1','152','143270','316',202.00,256.00,0.00,86.00,17372.00,22016.00,4644.00,430831),('1','152','143279','316',202.00,256.00,0.00,3208.83,648183.66,758306.34,110122.68,430856),('1','152','143285','316',202.00,256.00,0.00,0.00,0.00,0.00,0.00,430870),('1','152','143290','316',202.00,256.00,0.00,2467.68,498471.36,596236.08,97764.72,430883),('1','152','143549','316',202.00,256.00,0.00,0.00,0.00,0.00,0.00,431644),('1','152','143568','316',202.00,256.00,0.00,4113.50,830927.00,966839.66,135912.66,431689),('1','152','143577','316',202.00,256.00,0.00,1500.50,303101.00,363476.60,60375.60,431710),('1','152','143650','316',202.00,256.00,0.00,1236.32,249736.64,294884.72,45148.08,431921),('1','152','143692','316',202.00,256.00,0.00,173.55,35057.10,44428.80,9371.70,432035),('1','152','143698','316',202.00,256.00,0.00,2649.19,535136.38,627561.64,92425.26,432049),('1','152','143705','316',202.00,256.00,0.00,3064.10,618948.20,731405.60,112457.40,432068),('1','152','144095','316',202.00,256.00,0.00,2874.48,580644.96,705332.88,124687.92,433176),('1','152','146805','316',202.00,202.00,0.00,0.00,0.00,0.00,0.00,441003),('1','152','146807','316',202.00,0.00,0.00,661.40,133602.80,145299.64,11696.84,441005),('1','152','147797','316',202.00,256.00,0.00,3242.26,654936.52,790824.16,135887.64,443547),('1','152','147806','316',202.00,256.00,0.00,2474.26,499800.52,622074.16,122273.64,443572),('1','152','148106','316',202.00,256.00,0.00,1179.01,238160.02,295896.96,57736.94,444356),('1','152','148171','316',202.00,256.00,0.00,2225.01,449452.02,558066.56,108614.54,444522),('1','152','148177','316',202.00,256.00,0.00,1560.03,315126.06,394367.68,79241.62,444538),('1','152','148181','316',202.00,256.00,0.00,793.11,160208.22,200132.16,39923.94,444548),('1','152','148230','316',202.00,256.00,0.00,2498.19,504634.38,616743.04,112108.66,444679),('1','152','148248','316',202.00,256.00,0.00,130.03,26266.06,33039.20,6773.14,444728),('1','152','148252','316',202.00,256.00,0.00,4522.43,913530.86,1189830.68,276299.82,444737),('1','152','148255','316',202.00,276.00,0.00,1084.43,219054.86,286402.68,67347.82,444742),('1','152','148379','316',202.00,276.00,0.00,3697.76,746947.52,946721.76,199774.24,445071),('1','152','148382','316',202.00,276.00,0.00,2026.23,409298.46,542843.48,133545.02,445076),('1','152','148506','316',202.00,276.00,0.00,2282.26,461016.52,589765.76,128749.24,445401),('1','152','148514','316',202.00,276.00,0.00,1015.82,205195.64,277146.32,71950.68,445421),('1','152','148538','316',202.00,276.00,0.00,4676.02,944556.04,1211641.52,267085.48,445487),('1','152','148598','316',202.00,276.00,0.00,998.39,201674.78,259842.84,58168.06,445640),('1','152','148601','316',202.00,0.00,0.00,4143.15,836916.30,1095541.40,258625.10,445647),('1','152','148609','316',202.00,0.03,0.00,567.26,114586.52,149249.76,34663.24,445667),('1','152','148613','316',202.00,276.00,0.00,2584.59,522087.18,682020.84,159933.66,445677),('1','152','148617','316',202.00,276.00,0.00,3900.29,787858.58,1048995.04,261136.46,445685),('1','152','148623','316',202.00,276.00,0.00,2132.76,430817.52,554853.38,124035.86,445699),('1','152','148634','316',202.00,276.00,0.00,5755.20,1162550.40,1478932.20,316381.80,445726),('1','152','148638','316',202.00,276.00,0.00,1978.54,399665.08,533220.04,133554.96,445732),('1','152','148734','316',202.00,276.00,0.00,3933.32,794530.64,1051403.60,256872.96,445990),('1','152','148747','316',202.00,276.00,0.00,1705.90,344591.80,446839.40,102247.60,446025),('1','152','148755','316',202.00,276.00,0.00,1880.22,379804.44,491731.72,111927.28,446047),('1','152','148757','316',202.00,256.00,0.00,3841.27,775936.54,955870.12,179933.58,446051),('1','152','148761','316',202.00,256.00,0.00,2199.92,444383.84,548151.52,103767.68,446061),('1','152','148762','316',202.00,256.00,0.00,5722.14,1155872.28,1412828.84,256956.56,446062),('1','152','148765','316',202.00,256.00,0.00,5751.10,1161722.20,1415634.10,253911.90,446069),('1','152','148766','316',202.00,0.03,0.00,2296.78,463949.56,558387.68,94438.12,446070),('1','152','148771','316',202.00,256.00,0.00,6197.10,1251814.20,1520209.60,268395.40,446083),('1','152','148774','316',202.00,256.00,0.00,5741.82,1159847.64,1428122.62,268274.98,446090),('1','152','148777','316',202.00,256.00,0.00,2043.31,412748.62,503837.74,91089.12,446097),('1','152','148784','316',202.00,256.00,0.00,5793.97,1170381.94,1418088.10,247706.16,446116),('1','152','148789','316',202.00,256.00,0.00,6704.03,1354214.06,1634286.44,280072.38,446127),('1','152','148869','316',207.00,256.00,0.00,5771.15,1194628.05,1396406.20,201778.15,446340),('1','152','148874','316',207.00,256.00,0.00,4010.69,830212.83,944970.28,114757.45,446351),('1','152','148879','316',207.00,256.00,0.00,1980.21,409903.47,484742.76,74839.29,446364),('1','152','148888','316',207.00,256.00,0.00,2308.36,477830.52,561523.24,83692.72,446389),('1','152','148894','316',207.00,256.00,0.00,4077.27,843994.89,1002454.12,158459.23,446405),('1','152','148898','316',207.00,256.00,0.00,4987.66,1032445.62,1245783.96,213338.34,446415),('1','152','148902','316',207.00,256.00,0.00,1257.85,260374.95,302509.60,42134.65,446425),('1','152','148906','316',207.00,256.00,0.00,3961.31,819991.17,979877.54,159886.37,446435),('1','152','148907','316',207.00,256.00,0.00,1797.24,372028.68,429791.48,57762.80,446436),('1','152','149021','316',207.00,256.00,0.00,2524.04,522476.28,625159.24,102682.96,446730),('1','152','149039','316',207.00,256.00,0.00,5883.40,1217863.80,1448209.40,230345.60,446776),('1','152','149045','316',207.00,256.00,0.00,3532.67,731262.69,877531.52,146268.83,446792),('1','152','149053','316',207.00,256.00,0.00,2199.27,455248.89,555053.74,99804.85,446812),('1','152','149108','316',207.00,256.00,0.00,2540.78,525941.46,633188.68,107247.22,446976),('1','152','149112','316',207.00,256.00,0.00,3081.64,637899.48,748170.84,110271.36,446984),('1','152','149196','316',207.00,256.00,0.00,2073.71,429257.97,517505.76,88247.79,447204),('1','152','149208','316',207.00,256.00,0.00,3884.65,804122.55,934958.08,130835.53,447237),('1','152','149214','316',207.00,256.00,0.00,5256.75,1088147.25,1290647.00,202499.75,447253),('1','152','149217','316',207.00,256.00,0.00,2073.68,429251.76,506851.08,77599.32,447260),('1','152','149219','316',207.00,256.00,0.00,3696.50,765175.50,921499.48,156323.98,447264),('1','152','149226','316',207.00,256.00,0.00,3750.15,776281.05,933557.40,157276.35,447281),('1','152','149229','316',207.00,256.00,0.00,2048.48,424035.36,511995.88,87960.52,447288),('1','152','149233','316',207.00,256.00,0.00,5761.38,1192605.66,1398862.24,206256.58,447298),('1','152','149238','316',207.00,256.00,0.00,1512.24,313033.68,385443.44,72409.76,447311),('1','152','149244','316',207.00,256.00,0.00,3721.01,770249.07,922743.56,152494.49,447327),('1','152','149247','316',207.00,256.00,0.00,455.12,94209.84,116285.30,22075.46,447334),('1','152','149251','316',207.00,256.00,0.00,3873.84,801884.88,969958.72,168073.84,447344),('1','152','149254','316',207.00,256.00,0.00,1375.85,284800.95,331911.60,47110.65,447351),('1','152','149257','316',207.00,256.00,0.00,3010.31,623134.17,739483.04,116348.87,447358),('1','152','149259','316',207.00,256.00,0.00,2723.74,563814.18,679402.44,115588.26,447362),('1','152','149266','316',207.00,256.00,0.00,1419.77,293892.39,347354.12,53461.73,447381),('1','152','149269','316',207.00,256.00,0.00,4285.53,887104.71,1058602.68,171497.97,447388),('1','152','149272','316',207.00,256.00,0.00,5525.89,1143859.23,1360326.32,216467.09,447395),('1','152','149343','316',207.00,256.00,0.00,5811.59,1202999.13,1415162.04,212162.91,447584),('1','152','149348','316',207.00,256.00,0.00,4347.31,899893.17,1059559.36,159666.19,447597),('1','152','149350','316',207.00,256.00,0.00,1362.45,282027.15,346135.20,64108.05,447599),('1','152','149376','316',207.00,256.00,0.00,1690.13,349856.91,420700.28,70843.37,447675),('1','152','149382','316',207.00,256.00,0.00,3899.53,807202.71,972773.68,165570.97,447687),('1','152','149385','316',207.00,256.00,0.00,1840.97,381080.79,463631.32,82550.53,447694),('1','152','149640','316',207.00,256.00,0.00,1771.44,366688.08,436263.64,69575.56,448390),('1','152','149641','316',207.00,0.00,0.00,3971.27,822052.89,992599.80,170546.91,448391),('1','152','149773','316',207.00,256.00,0.00,5749.73,1190194.11,1419032.06,228837.95,448742),('1','152','149778','316',207.00,256.00,0.00,5408.40,1119538.80,1348514.40,228975.60,448755),('1','152','149784','316',207.00,256.00,0.00,1710.58,354090.06,415652.48,61562.42,448771),('1','152','149932','316',207.00,256.00,0.00,5693.29,1178511.03,1390337.24,211826.21,449161),('1','152','150071','316',213.00,256.00,0.00,5747.13,1224138.69,1429222.76,205084.07,449527),('1','152','150258','316',213.00,256.00,0.00,5775.93,1230273.09,1430382.08,200108.99,450023),('1','152','150493','316',213.00,256.00,0.00,3664.54,780547.02,905388.24,124841.22,450647),('1','152','150647','316',213.00,256.00,0.00,5786.86,1232601.18,1418350.28,185749.10,451047),('1','152','150898','316',213.00,25624475.00,0.00,5765.71,1228096.23,1399451.76,171355.53,451702),('1','152','150939','316',213.00,2546.00,0.00,5773.12,1229674.56,1412946.80,183272.24,451819),('1','152','151050','316',230.00,256.00,0.00,5352.64,1231107.20,1316171.40,85064.20,452113),('1','152','151055','316',230.00,256.00,0.00,19.38,4457.40,4961.28,503.88,452126),('1','152','152518','316',230.00,256.00,0.00,1840.19,423243.70,447753.40,24509.70,456072),('1','152','153681','316',213.00,256.00,0.00,5777.47,1230601.11,1423328.56,192727.45,459219),('1','152','153687','316',213.00,256.00,0.00,1581.61,336882.93,391099.16,54216.23,459233),('1','152','153690','316',213.00,256.00,0.00,5795.06,1234347.78,1431314.10,196966.32,459238),('1','152','153693','316',213.00,256.00,0.00,5773.69,1229795.97,1434461.60,204665.63,459245),('1','152','153700','316',213.00,256.00,0.00,4600.04,979808.52,1151635.72,171827.20,459262),('1','152','153703','316',213.00,256.00,0.00,1106.37,235656.81,274754.72,39097.91,459267),('1','152','153833','316',213.00,256.00,0.00,4863.61,1035948.93,1199701.94,163753.01,459621),('1','152','153859','316',213.00,256.00,0.00,4049.15,862468.95,1008981.84,146512.89,459691),('1','152','153869','316',213.00,256.00,0.00,1516.98,323116.74,373748.66,50631.92,459717),('1','152','153874','316',213.00,256.00,0.00,2903.94,618539.22,724532.64,105993.42,459728),('1','152','153928','316',213.00,256.00,0.00,2722.64,579922.32,671282.10,91359.78,459863),('1','152','153929','316',213.00,2656.00,0.00,2179.41,464214.33,530498.96,66284.63,459864),('1','152','153930','316',213.00,256.00,0.00,3566.62,759690.06,882892.90,123202.84,459865),('1','152','153969','316',213.00,256.00,0.00,439.80,93677.40,109988.80,16311.40,459966),('1','152','153974','316',213.00,256.00,0.00,4359.87,928652.31,1082709.44,154057.13,459978),('1','152','153987','316',213.00,256.00,0.00,985.53,209917.89,242559.24,32641.35,460014),('1','152','153997','316',213.00,272.00,0.00,3629.44,773070.72,922892.68,149821.96,460042),('1','152','154005','316',213.00,272.00,0.00,1957.81,417013.53,503553.88,86540.35,460062),('1','152','154056','316',213.00,272.00,0.00,2795.11,595358.43,708684.92,113326.49,460197),('1','152','154060','316',213.00,272.00,0.00,2865.70,610394.10,752211.48,141817.38,460205),('1','152','154067','316',213.00,272.00,0.00,3498.17,745110.21,917815.24,172705.03,460216),('1','152','154068','316',213.00,272.00,0.00,2268.14,483113.82,589213.08,106099.26,460217),('1','152','154076','316',213.00,272.00,0.00,1228.10,261585.30,327754.20,66168.90,460239),('1','152','154081','316',213.00,272.00,0.00,4569.21,973241.73,1152637.44,179395.71,460252),('1','152','154086','316',213.00,272.00,0.00,901.52,192023.76,228892.44,36868.68,460265),('1','152','154093','316',213.00,272.00,0.00,5764.57,1227853.41,1457650.56,229797.15,460284),('1','152','154369','316',213.00,272.00,0.00,4634.39,987125.07,1202433.84,215308.77,461028),('1','152','154893','316',213.00,0.00,0.00,1066.91,227251.83,290199.52,62947.69,462461),('1','152','154894','316',213.00,0.00,0.00,3467.37,738549.81,880842.64,142292.83,462462),('1','152','154900','316',213.00,272.00,0.00,2220.21,472904.73,570547.56,97642.83,462478),('1','152','154924','316',213.00,272.00,0.00,3743.24,797310.12,960316.54,163006.42,462546),('1','152','154927','316',213.00,272.00,0.00,1528.37,325542.81,415716.64,90173.83,462553),('1','152','154953','316',213.00,272.00,0.00,6517.48,1388223.24,1653516.64,265293.40,462627),('1','152','155419','316',213.00,0.00,0.00,0.00,0.00,0.00,0.00,463894),('1','152','155421','316',213.00,272.00,0.00,4589.40,977542.20,1216650.64,239108.44,463898),('1','152','155426','316',213.00,272.00,0.00,410.61,87459.93,107505.92,20045.99,463909),('1','152','155433','316',213.00,272.00,0.00,5155.45,1098110.85,1312525.64,214414.79,463926),('1','152','155438','316',213.00,272.00,0.00,612.71,130507.23,154535.12,24027.89,463938),('1','152','155453','316',213.00,272.00,0.00,4495.95,957637.35,1146849.00,189211.65,463973),('1','152','155884','316',213.00,272.00,0.00,1164.47,248032.11,298892.56,50860.45,465136),('1','152','155895','316',213.00,272.00,0.00,2663.79,567387.27,686588.88,119201.61,465163),('1','152','155935','316',213.00,272.00,0.00,3052.58,650199.54,780889.60,130690.06,465257),('1','152','155948','316',213.00,272.00,0.00,2951.16,628597.08,737130.94,108533.86,465288),('1','152','155949','316',213.00,272.00,0.00,2867.58,610794.54,726059.76,115265.22,465289),('1','152','155955','316',213.00,272.00,0.00,1770.93,377208.09,463390.64,86182.55,465305),('1','152','156229','316',213.00,272.00,0.00,3928.42,836753.46,1011330.74,174577.28,466038),('1','152','156249','316',213.00,272.00,0.00,424.49,90416.37,114435.28,24018.91,466092),('1','152','156253','316',213.00,272.00,0.00,5214.41,1110669.33,1326747.88,216078.55,466102),('1','152','156436','316',213.00,272.00,0.00,5450.41,1160937.33,1411650.64,250713.31,466581),('1','152','156462','316',213.00,272.00,0.00,1705.30,363228.90,448793.60,85564.70,466652),('1','152','156632','316',213.00,272.00,0.00,3967.30,845034.90,1029040.60,184005.70,467119),('1','152','156640','316',213.00,272.00,0.00,839.72,178860.36,217763.84,38903.48,467141),('1','152','156760','316',213.00,272.00,0.00,4829.86,1028760.18,1220230.52,191470.34,467472),('1','152','157835','316',213.00,213.00,0.00,0.00,0.00,0.00,0.00,470287),('1','152','158487','316',220.00,272.00,0.00,1962.55,431761.00,499288.32,67527.32,472011),('1','152','158492','316',220.00,272.00,0.00,3012.05,662651.00,778919.70,116268.70,472023),('1','152','158554','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472187),('1','152','158583','316',220.00,0.00,0.00,0.00,0.00,0.00,0.00,472253),('1','152','158584','316',220.00,272.00,0.00,2697.75,593505.00,716384.00,122879.00,472254),('1','152','158589','316',220.00,272.00,0.00,2273.48,500165.60,585725.56,85559.96,472267),('1','152','158590','316',220.00,272.00,0.00,2507.00,551540.00,645899.00,94359.00,472268),('1','152','158592','316',220.00,272.00,0.00,3214.80,707256.00,814208.90,106952.90,472272),('1','152','158716','316',220.00,272.00,0.00,1177.43,259034.60,303692.96,44658.36,472626),('1','152','158724','316',220.00,272.00,0.00,4277.24,940992.80,1141768.28,200775.48,472648),('1','152','158727','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472655),('1','152','158730','316',220.00,272.00,0.00,4867.77,1070909.40,1274306.64,203397.24,472660),('1','152','158754','316',220.00,272.00,0.00,628.49,138267.80,161449.28,23181.48,472705),('1','152','158755','316',220.00,272.00,0.00,0.00,0.00,0.00,0.00,472706),('1','152','158756','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472707),('1','152','158757','316',220.00,272.00,0.00,412.77,90809.40,111627.44,20818.04,472708),('1','152','158758','316',220.00,272.00,0.00,2305.76,507267.20,599407.72,92140.52,472709),('1','152','158759','316',220.00,272.00,0.00,760.55,167321.00,201511.60,34190.60,472710),('1','152','158760','316',220.00,272.00,0.00,4511.48,992525.60,1212887.76,220362.16,472711),('1','152','158761','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472712),('1','152','158762','316',220.00,272.00,0.00,3687.35,811217.00,1002959.20,191742.20,472713),('1','152','158765','316',220.00,272.00,0.00,2010.51,442312.20,546858.72,104546.52,472720),('1','152','158792','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472794),('1','152','158794','316',220.00,272.00,0.00,1973.82,434240.40,536879.04,102638.64,472798),('1','152','158944','316',220.00,272.00,0.00,3629.20,798424.00,987142.40,188718.40,473194),('1','152','158994','316',220.00,272.00,0.00,3943.52,867574.40,1072637.44,205063.04,473338),('1','152','159261','316',220.00,272.00,0.00,1666.72,366678.40,453347.84,86669.44,474079),('1','152','159427','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,474478),('1','152','159440','316',220.00,272.00,0.00,2640.31,580868.20,718164.32,137296.12,474511),('1','152','159448','316',220.00,272.00,0.00,2850.29,627063.80,775278.88,148215.08,474526),('1','152','159646','316',220.00,0.00,0.00,0.00,0.00,0.00,0.00,475034),('1','152','159652','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,475050),('1','152','159662','316',220.00,272.00,0.00,2233.47,491363.40,607503.84,116140.44,475078),('1','152','159677','316',220.00,272.00,0.00,3638.32,800430.40,962548.04,162117.64,475115),('1','152','159686','316',220.00,272.00,0.00,490.58,107927.60,133437.76,25510.16,475141),('1','152','159907','316',220.00,272.00,0.00,5021.05,1104631.00,1319030.80,214399.80,475722),('1','152','159919','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,475750),('1','152','159926','316',220.00,272.00,0.00,759.30,167046.00,197499.60,30453.60,475767),('1','152','160009','316',220.00,272.00,0.00,1259.23,277030.60,324027.56,46996.96,475971),('1','152','160077','316',220.00,220.00,0.00,0.00,0.00,0.00,0.00,476155),('1','152','160087','316',225.00,272.00,0.00,3186.21,716897.25,849219.12,132321.87,476182),('1','152','160188','316',225.00,272.00,0.00,2370.14,533281.50,631718.08,98436.58,476432),('1','152','160293','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,476730),('1','152','160299','316',225.00,272.00,0.00,0.00,0.00,0.00,0.00,476738),('1','152','160302','316',225.00,272.00,0.00,2887.84,649764.00,766547.48,116783.48,476741),('1','152','160439','316',225.00,272.00,0.00,2691.89,605675.25,697379.08,91703.83,477111),('1','152','160441','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,477113),('1','152','160445','316',225.00,272.00,0.00,2316.67,521250.75,622065.44,100814.69,477124),('1','152','160569','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,477455),('1','152','160571','316',225.00,272.00,0.00,3848.45,865901.25,1037148.40,171247.15,477459),('1','152','160831','316',225.00,296.00,0.00,1603.23,360726.75,453856.08,93129.33,478097),('1','152','160838','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,478114),('1','152','160843','316',225.00,296.00,0.00,2013.90,453127.50,589168.40,136040.90,478127),('1','152','160844','316',225.00,296.00,0.00,3887.48,874683.00,1122749.08,248066.08,478128),('1','152','161199','316',225.00,296.00,0.00,4766.76,1072521.00,1365917.76,293396.76,479062),('1','152','161247','316',225.00,296.00,0.00,2023.36,455256.00,587598.56,132342.56,479202),('1','152','161253','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,479217),('1','152','161259','316',225.00,296.00,0.00,1637.76,368496.00,467043.96,98547.96,479229),('1','152','161434','316',225.00,296.00,0.00,3809.96,857241.00,1080391.16,223150.16,479665),('1','152','161448','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,479696),('1','152','161725','316',225.00,296.00,0.00,5554.18,1249690.50,1533200.28,283509.78,480383),('1','152','161898','316',225.00,296.00,0.00,0.00,0.00,0.00,0.00,480828),('1','152','161902','316',225.00,296.00,0.00,2436.08,548118.00,682324.68,134206.68,480838),('1','152','161906','316',225.00,296.00,0.00,0.00,0.00,0.00,0.00,480848),('1','152','161910','316',225.00,296.00,0.00,1104.35,248478.75,315847.60,67368.85,480858),('1','152','162416','316',225.00,296.00,0.00,4387.34,987151.50,1244006.94,256855.44,482192),('1','152','162421','316',225.00,225.00,0.00,0.00,0.00,0.00,0.00,482203),('1','152','162424','316',230.00,296.00,0.00,2879.71,662333.30,822195.16,159861.86,482210),('1','152','162429','316',230.00,296.00,0.00,2722.85,626255.50,777871.40,151615.90,482223),('1','152','162433','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,482230),('1','152','162437','316',230.00,296.00,0.00,1312.20,301806.00,373024.20,71218.20,482238),('1','152','162543','316',230.00,296.00,0.00,4226.10,972003.00,1191880.00,219877.00,482489),('1','152','162893','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,483406),('1','152','162988','316',230.00,296.00,0.00,4330.09,995920.70,1226575.64,230654.94,483665),('1','152','162990','316',230.00,296.00,0.00,1202.44,276561.20,327149.24,50588.04,483670),('1','152','163124','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,484002),('1','152','163129','316',230.00,296.00,0.00,2987.19,687053.70,841037.24,153983.54,484014),('1','152','163135','316',230.00,296.00,0.00,2560.92,589011.60,709587.82,120576.22,484028),('1','152','163142','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,484046),('1','152','163145','316',230.00,296.00,0.00,1454.02,334424.60,425789.92,91365.32,484052),('1','152','163283','316',230.00,296.00,0.00,4162.63,957404.90,1166016.70,208611.80,484407),('1','152','163287','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,484416),('1','152','163461','316',230.00,296.00,0.00,5633.75,1295762.50,1586703.60,290941.10,484884),('1','152','163464','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,484890),('1','152','163469','316',230.00,296.00,0.00,2503.90,575897.00,704193.40,128296.40,484903),('1','152','163592','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,485213),('1','152','163596','316',230.00,296.00,0.00,908.41,208934.30,259022.36,50088.06,485223),('1','152','163802','316',230.00,296.00,0.00,4541.86,1044627.80,1240729.56,196101.76,485757),('1','152','163810','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,485779),('1','152','163985','316',230.00,296.00,0.00,5557.30,1278179.00,1516473.80,238294.80,486241),('1','152','164078','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,486487),('1','152','164079','316',230.00,296.00,0.00,4169.63,959014.90,1212176.78,253161.88,486488),('1','152','164701','316',230.00,296.00,0.00,1424.63,327664.90,406332.28,78667.38,488160),('1','152','164863','316',230.00,296.00,0.00,0.00,0.00,0.00,0.00,488579),('1','152','164864','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,488580),('1','152','164870','316',230.00,296.00,0.00,2080.94,478616.20,599014.56,120398.36,488596),('1','152','164875','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,488609),('1','152','164880','316',245.00,296.00,0.00,607.51,148839.95,178956.38,30116.43,488622),('1','152','164886','316',245.00,296.00,0.00,4927.84,1207320.80,1408448.16,201127.36,488635),('1','152','164888','316',245.00,245.00,0.00,0.00,0.00,0.00,0.00,488639),('1','152','164894','316',245.00,296.00,0.00,6081.38,1489938.10,1729511.74,239573.64,488655),('1','152','164924','316',245.00,296.00,0.00,4843.78,1186726.10,1389161.08,202434.98,488737),('1','152','165006','316',245.00,296.00,0.00,903.56,221372.20,250555.84,29183.64,488929),('1','152','165012','316',245.00,296.00,0.00,4527.18,1109159.10,1340045.28,230886.18,488943),('1','152','165181','316',245.00,230.00,0.00,0.00,0.00,0.00,0.00,489389),('1','152','165186','316',230.00,320.00,0.00,5840.22,1343250.60,1813044.00,469793.40,489402),('1','152','165348','316',230.00,320.00,0.00,5897.89,1356514.70,1822126.40,465611.70,489814),('1','152','165479','316',230.00,320.00,0.00,5437.33,1250585.90,1691477.12,440891.22,490159),('1','152','165509','316',230.00,320.00,0.00,696.48,160190.40,214519.20,54328.80,490242),('1','152','165899','316',230.00,320.00,0.00,4103.76,943864.80,1269007.92,325143.12,491292),('1','152','165928','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,491367),('1','152','165930','316',230.00,320.00,0.00,5892.10,1355183.00,1832804.00,477621.00,491371),('1','152','166061','316',230.00,320.00,0.00,5154.04,1185429.20,1586800.16,401370.96,491725),('1','152','166067','316',230.00,230.00,0.00,0.00,0.00,0.00,0.00,491741),('1','152','166287','316',230.00,320.00,0.00,5878.09,1351960.70,1823282.24,471321.54,492314),('1','152','166419','316',230.00,320.00,0.00,1182.04,271869.20,366132.80,94263.60,492672),('1','152','166609','316',230.00,320.00,0.00,4466.03,1027186.90,1373338.00,346151.10,493183),('1','152','166748','316',270.00,320.00,0.00,4260.90,1150443.00,1339517.28,189074.28,493541),('1','152','167157','316',270.00,320.00,0.00,1754.77,442492.30,542749.04,100256.74,494662),('1','152','167162','316',270.00,320.00,0.00,1909.40,515538.00,593800.00,78262.00,494675),('1','152','167163','316',270.00,320.00,0.00,3732.34,1007731.80,1163447.12,155715.32,494676),('1','152','167183','316',270.00,320.00,0.00,5153.88,1391547.60,1599969.60,208422.00,494722),('1','152','167184','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,494723),('1','152','167526','316',270.00,320.00,0.00,6362.52,1717880.40,1976442.48,258562.08,495648),('1','152','167705','316',270.00,320.00,0.00,5509.61,1487594.70,1700775.04,213180.34,496112),('1','152','167707','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,496116),('1','152','167791','316',270.00,320.00,0.00,2969.28,801705.60,926949.60,125244.00,496320),('1','152','167941','316',270.00,320.00,0.00,5351.21,1444826.70,1666367.68,221540.98,496718),('1','152','168010','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,496919),('1','152','168015','316',270.00,320.00,0.00,1774.76,479185.20,556339.12,77153.92,496932),('1','152','168374','316',270.00,320.00,0.00,5636.63,1521890.10,1750780.48,228890.38,497891),('1','152','168391','316',270.00,320.00,0.00,5527.05,1492303.50,1715712.00,223408.50,497937),('1','152','168537','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,498318),('1','152','168558','316',270.00,320.00,0.00,3293.48,889239.60,1030274.32,141034.72,498373),('1','152','168732','316',270.00,320.00,0.00,1989.26,537100.20,620763.52,83663.32,498843),('1','152','168917','316',270.00,320.00,0.00,4772.86,1288672.20,1500382.40,211710.20,499327),('1','152','169002','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,499539),('1','152','169009','316',270.00,320.00,0.00,3804.74,1027279.80,1186183.12,158903.32,499556),('1','152','169467','316',270.00,320.00,0.00,5529.89,1493070.30,1708151.44,215081.14,500717),('1','152','169473','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,500733),('1','152','169474','316',270.00,0.00,0.00,843.88,227847.60,267075.20,39227.60,500734),('1','152','169540','316',270.00,320.00,0.00,5226.17,1411065.90,1632844.24,221778.34,500921),('1','152','169555','316',270.00,320.00,0.00,5725.82,1545971.40,1744442.56,198471.16,500961),('1','152','169573','316',270.00,328.00,0.00,1068.25,288427.50,345328.00,56900.50,501001),('1','152','169774','316',270.00,328.00,0.00,5449.95,1471486.50,1739538.36,268051.86,501537),('1','152','169932','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,501979),('1','152','169934','316',270.00,328.00,0.00,5468.43,1476476.10,1745435.64,268959.54,501983),('1','152','170147','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,502516),('1','152','170148','316',270.00,328.00,0.00,4349.57,1174383.90,1409348.90,234965.00,502517),('1','152','170248','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,502781),('1','152','170250','316',270.00,328.00,0.00,5606.93,1513871.10,1798454.96,284583.86,502783),('1','152','170484','316',270.00,328.00,0.00,0.00,0.00,0.00,0.00,503404),('1','152','170485','316',270.00,328.00,0.00,5673.13,1531745.10,1827435.88,295690.78,503405),('1','152','170595','316',270.00,0.00,0.00,5578.59,1506219.30,1790604.84,284385.54,503692),('1','152','170599','316',270.00,328.00,0.00,0.00,0.00,0.00,0.00,503700),('1','152','170813','316',270.00,328.00,0.00,935.21,252506.70,302248.88,49742.18,504260),('1','152','170814','316',270.00,328.00,0.00,4648.23,1255022.10,1497127.14,242105.04,504261),('1','152','170815','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,504262),('1','152','171177','316',270.00,328.00,0.00,5243.96,1415869.20,1682372.78,266503.58,505244),('1','152','171182','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,505257),('1','152','171381','316',270.00,328.00,0.00,6070.74,1639099.80,1958309.34,319209.54,505765),('1','152','171384','316',270.00,328.00,0.00,917.97,247851.90,291792.48,43940.58,505774),('1','152','171602','316',270.00,328.00,0.00,5410.26,1460770.20,1734428.16,273657.96,506362),('1','152','171608','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,506377),('1','152','171674','316',270.00,328.00,0.00,553.17,149355.90,181223.76,31867.86,506560),('1','152','171916','316',270.00,328.00,0.00,5468.70,1476549.00,1757867.34,281318.34,507205),('1','152','172083','316',270.00,328.00,0.00,5425.01,1464752.70,1748083.28,283330.58,507630),('1','152','172084','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,507631),('1','152','172368','316',270.00,328.00,0.00,1504.99,406347.30,487588.72,81241.42,508394),('1','152','172374','316',270.00,328.00,0.00,3843.15,1037650.50,1236296.40,198645.90,508408),('1','152','172376','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,508412),('1','152','172380','316',270.00,328.00,0.00,1153.25,311377.50,369984.92,58607.42,508422),('1','152','172670','316',270.00,328.00,0.00,4653.35,1256404.50,1510136.60,253732.10,509195),('1','152','172891','316',270.00,328.00,0.00,872.71,235631.70,282504.88,46873.18,509768),('1','152','172893','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,509772),('1','152','172899','316',270.00,328.00,0.00,0.00,0.00,0.00,0.00,509786),('1','152','172900','316',270.00,328.00,0.00,5862.69,1582926.30,1878887.16,295960.86,509787),('1','152','173246','316',270.00,328.00,0.00,4555.84,1230076.80,1465302.76,235225.96,510707),('1','152','173248','316',270.00,328.00,0.00,1004.05,271093.50,325840.00,54746.50,510711),('1','152','173249','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,510712),('1','152','173551','316',270.00,328.00,0.00,398.00,107460.00,130544.00,23084.00,511544),('1','152','173574','316',270.00,328.00,0.00,5204.85,1405309.50,1674003.30,268693.80,511604),('1','152','173697','316',270.00,328.00,0.00,2879.04,777340.80,922801.80,145461.00,511915),('1','152','173887','316',270.00,328.00,0.00,1529.64,413002.80,498031.92,85029.12,512427),('1','152','173892','316',270.00,328.00,0.00,4103.59,1107969.30,1314018.88,206049.58,512437),('1','152','174061','316',270.00,328.00,0.00,5526.61,1492184.70,1774477.00,282292.30,512877),('1','152','174080','316',270.00,270.00,0.00,0.00,0.00,0.00,0.00,512930),('1','152','174237','316',270.00,328.00,0.00,5639.79,1522743.30,1813952.64,291209.34,513339),('1','152','174465','316',281.00,328.00,0.00,6115.00,1718315.00,1976462.80,258147.80,513925),('1','152','174611','316',281.00,328.00,0.00,5393.05,1515447.05,1733097.34,217650.29,514294),('1','152','174643','316',281.00,328.00,0.00,200.00,56200.00,62000.00,5800.00,514370),('1','152','174644','316',281.00,328.00,0.00,0.00,0.00,0.00,0.00,514371),('1','152','174854','316',281.00,328.00,0.00,0.00,0.00,0.00,0.00,514931),('1','152','174855','316',281.00,328.00,0.00,1975.62,555149.22,635839.50,80690.28,514932),('1','152','174976','316',281.00,328.00,0.00,3399.17,955166.77,1095672.98,140506.21,515271),('1','152','174983','316',281.00,352.00,0.00,282.17,79289.77,94744.84,15455.07,515290),('1','152','175250','316',281.00,352.00,0.00,5701.00,1601981.00,1921781.34,319800.34,515969),('1','152','175414','316',281.00,352.00,0.00,3065.00,861265.00,1031380.00,170115.00,516405),('1','152','175415','316',281.00,352.00,0.00,2576.25,723926.25,878983.72,155057.47,516406),('1','152','175677','316',281.00,281.00,0.00,0.00,0.00,0.00,0.00,517101),('1','152','175681','316',281.00,352.00,0.00,1343.05,377397.05,451137.68,73740.63,517111),('1','152','175735','316',298.00,352.00,0.00,5607.13,1670924.74,1912629.70,241704.96,517258),('1','152','175908','316',298.00,298.00,0.00,0.00,0.00,0.00,0.00,517712),('1','152','175910','316',298.00,352.00,0.00,6082.28,1812519.44,2079189.76,266670.32,517716),('1','152','176077','316',298.00,352.00,0.00,5899.26,1757979.48,2001679.14,243699.66,518129),('1','152','177122','316',298.00,352.00,0.00,5729.76,1707468.48,1907654.78,200186.30,520889),('1','152','177127','316',301.00,352.00,0.00,6025.62,1813711.62,2075067.88,261356.26,520902),('1','152','177138','316',301.00,352.00,0.00,2605.26,784183.26,903757.52,119574.26,520930),('1','152','177150','316',301.00,354.00,0.00,4406.36,1326314.36,1533426.72,207112.36,520960),('1','152','177163','316',301.00,352.00,0.00,5976.11,1798809.11,2039741.78,240932.67,520994),('1','152','177410','316',301.00,352.00,0.00,5959.67,1793860.67,2026298.44,232437.77,521628),('1','152','177608','316',301.00,352.00,0.00,5894.05,1774109.05,2010238.88,236129.83,522168),('1','152','177872','316',301.00,352.00,0.00,1596.69,480603.69,540478.88,59875.19,522868),('1','152','177887','316',301.00,344.00,0.00,4486.61,1350469.61,1487480.44,137010.83,522900),('1','152','177891','316',301.00,344.00,0.00,5257.18,2841.44,1769826.92,1766985.48,522908),('1','152','178077','316',0.00,344.00,0.00,640.05,0.00,219427.20,219427.20,523410),('1','152','178131','316',301.00,344.00,0.00,2944.58,886318.58,995907.52,109588.94,523552),('1','152','178290','316',301.00,344.00,0.00,3317.32,998513.32,1099149.38,100636.06,523956),('1','152','178440','316',301.00,344.00,0.00,1310.67,394511.67,445760.48,51248.81,524365),('1','152','178492','316',301.00,352.00,0.00,4748.92,1429424.92,1643214.76,213789.84,524487),('1','152','178718','316',301.00,352.00,0.00,3681.71,1108194.71,1283499.92,175305.21,525082),('1','152','178813','316',301.00,352.00,0.00,0.00,0.00,0.00,0.00,525342),('1','152','178814','316',301.00,352.00,0.00,919.25,276694.25,320953.40,44259.15,525343),('1','152','178902','316',301.00,352.00,0.00,1364.42,410690.42,472098.56,61408.14,525559),('1','152','179002','316',301.00,352.00,0.00,2727.25,820902.25,947214.52,126312.27,525817),('1','152','179138','316',301.00,352.00,0.00,3061.75,921586.75,1062439.96,140853.21,526183),('1','152','179329','316',301.00,352.00,0.00,1121.29,337508.29,392622.04,55113.75,526704),('1','152','179360','316',301.00,352.00,0.00,4363.59,1313440.59,1522949.76,209509.17,526787),('1','152','179547','316',301.00,360.00,0.00,489.89,147456.89,174620.40,27163.51,527279),('1','152','179564','316',301.00,360.00,0.00,4265.38,1283879.38,1512672.60,228793.22,527321),('1','152','179770','316',301.00,360.00,0.00,1174.17,353425.17,415461.20,62036.03,527874),('1','152','179871','316',301.00,360.00,0.00,2278.63,685867.63,810272.00,124404.37,528144),('1','152','179985','316',301.00,360.00,0.00,3760.72,1131976.72,1333628.00,201651.28,528437),('1','152','180152','316',301.00,360.00,0.00,815.72,245531.72,286289.20,40757.48,528877),('1','152','180166','316',301.00,360.00,0.00,5091.91,1532664.91,1787876.60,255211.69,528911),('1','152','180308','316',301.00,360.00,0.00,483.46,145521.46,172835.60,27314.14,529267),('1','152','180334','316',301.00,360.00,0.00,4049.06,1218767.06,1430739.40,211972.34,529339),('1','152','180571','316',301.00,360.00,0.00,696.61,209679.61,244590.20,34910.59,529951),('1','152','180599','316',318.00,360.00,0.00,3285.94,1044928.92,1160660.20,115731.28,530025),('1','152','180729','316',318.00,360.00,0.00,2650.49,838425.45,931846.40,93420.95,530383),('1','152','180910','316',318.00,360.00,0.00,1238.26,393766.68,438890.00,45123.32,530867),('1','152','180953','316',318.00,360.00,0.00,4543.52,1444839.36,1596304.20,151464.84,530985),('1','152','181120','316',318.00,360.00,0.00,347.08,110371.44,122568.80,12197.36,531423),('1','152','181126','316',318.00,360.00,0.00,4047.41,1287076.38,1439218.80,152142.42,531437),('1','152','181333','316',318.00,360.00,0.00,1300.30,413495.40,459330.40,45835.00,531992),('1','152','181450','316',318.00,360.00,0.00,2105.47,669539.46,746842.20,77302.74,532293),('1','152','181520','316',318.00,360.00,0.00,3514.29,1117544.22,1237551.60,120007.38,532481),('1','152','181642','316',318.00,360.00,0.00,1788.96,568889.28,634753.80,65864.52,532792),('1','152','181696','316',318.00,360.00,0.00,4104.33,1305176.94,1436690.80,131513.86,532943),('1','152','181885','316',318.00,360.00,0.00,1307.97,415934.46,464149.20,48214.74,533459),('1','152','181898','316',318.00,360.00,0.00,4568.00,1452624.00,1623970.40,171346.40,533494),('1','152','182100','316',318.00,360.00,0.00,5833.82,1855154.76,2039964.80,184810.04,534032),('1','152','182299','316',318.00,360.00,0.00,5934.80,1887266.40,2072701.00,185434.60,534542),('1','152','182475','316',318.00,360.00,0.00,947.99,301460.82,336846.40,35385.58,535021),('1','152','182492','316',318.00,360.00,0.00,5125.39,1629874.02,1802755.60,172881.58,535059),('1','152','182679','316',318.00,360.00,0.00,5594.18,1778949.24,1980702.60,201753.36,535553),('1','152','182829','316',318.00,360.00,0.00,346.18,110085.24,124095.40,14010.16,535963),('1','152','182852','316',318.00,360.00,0.00,5325.06,1693369.08,1874060.80,180691.72,536013),('1','152','182982','316',318.00,360.00,0.00,570.21,181326.78,204087.40,22760.62,536384),('1','152','183041','316',318.00,360.00,0.00,3860.38,1227600.84,1361723.40,134122.56,536539),('1','152','183205','316',318.00,360.00,0.00,1300.52,431825.36,449267.20,17441.84,536953),('1','152','183273','316',318.00,360.00,0.00,3990.11,1268854.98,1410885.60,142030.62,537109),('1','152','183430','316',318.00,360.00,0.00,4771.90,1517464.20,1686854.00,169389.80,537523),('1','152','183642','316',318.00,360.00,0.00,4348.89,1382947.02,1527138.40,144191.38,538091),('1','152','183874','316',318.00,360.00,0.00,3574.63,1136732.34,1259948.60,123216.26,538708),('1','152','184071','316',318.00,360.00,0.00,4529.57,1440403.26,1594599.40,154196.14,539233),('1','152','184259','316',318.00,360.00,0.00,1638.88,521163.84,563420.80,42256.96,539737),('1','152','184340','316',323.00,360.00,0.00,3192.53,1031187.19,1124816.80,93629.61,539941),('1','152','184449','316',323.00,360.00,0.00,4134.92,1335579.16,1448762.60,113183.44,540217),('1','152','184690','316',323.00,360.00,0.00,3647.03,1177990.69,1284219.40,106228.71,540869),('1','152','184876','316',323.00,360.00,0.00,3813.99,1231918.77,1347534.60,115615.83,541369),('1','152','185105','316',323.00,360.00,0.00,3769.24,1217464.52,1321425.40,103960.88,541956),('1','152','185236','316',323.00,360.00,0.00,718.58,232101.34,251215.80,19114.46,542290),('1','152','185255','316',323.00,360.00,0.00,3886.00,1255178.00,1367401.80,112223.80,542332),('1','152','185464','316',323.00,360.00,0.00,1001.06,323342.38,353790.40,30448.02,542882),('1','152','185539','316',323.00,360.00,0.00,2682.27,866373.21,946631.20,80257.99,543072),('1','152','185690','316',323.00,360.00,0.00,2737.37,884170.51,958006.20,73835.69,543478),('1','152','185803','316',323.00,360.00,0.00,2472.74,798695.02,864745.40,66050.38,543789),('1','152','185868','316',323.00,360.00,0.00,3005.81,970876.63,1057315.20,86438.57,543964),('1','152','186051','316',323.00,360.00,0.00,438.54,141648.42,154874.40,13225.98,544457),('1','152','186090','316',323.00,360.00,0.00,3896.89,1258695.47,1377918.20,119222.73,544544),('1','152','186314','316',323.00,360.00,0.00,2543.29,821482.67,897369.20,75886.53,545129),('1','152','186526','316',323.00,323.00,0.00,0.00,0.00,0.00,0.00,545699),('1','152','186528','316',323.00,360.00,0.00,3875.92,1251922.16,1374054.00,122131.84,545703),('1','152','186744','316',323.00,360.00,0.00,1762.71,569355.33,624277.40,54922.07,546261),('1','152','186884','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,546625),('1','152','186890','316',323.00,360.00,0.00,1882.28,607976.44,658652.60,50676.16,546634),('1','152','187016','316',323.00,360.00,0.00,3762.02,1215132.46,1328686.00,113553.54,546932),('1','152','187153','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,547317),('1','152','187154','316',323.00,360.00,0.00,5373.07,1735501.61,1896468.60,160966.99,547318),('1','152','187343','316',323.00,360.00,0.00,295.53,95456.19,103442.80,7986.61,547813),('1','152','187406','316',323.00,360.00,0.00,3829.12,1236805.76,1358203.20,121397.44,547969),('1','152','187567','316',323.00,360.00,0.00,2821.74,911422.02,994949.20,83527.18,548404),('1','152','187725','316',323.00,360.00,0.00,1997.97,645344.31,703201.40,57857.09,548819),('1','152','187790','316',323.00,360.00,0.00,3644.62,1177212.26,1282563.20,105350.94,548997),('1','152','187952','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,549429),('1','152','187958','316',323.00,360.00,0.00,1822.81,588767.63,643201.60,54433.97,549444),('1','152','188032','316',323.00,360.00,0.00,3874.49,1251460.27,1361725.60,110265.33,549615),('1','152','188167','316',323.00,360.00,0.00,1772.79,572611.17,631534.40,58923.23,549985),('1','152','188201','316',323.00,360.00,0.00,3944.66,1274125.18,1384346.60,110221.42,550069),('1','152','188371','316',323.00,360.00,0.00,2449.49,791185.27,859856.40,68671.13,550507),('1','152','188434','316',323.00,360.00,0.00,3302.09,1066575.07,1167482.40,100907.33,550659),('1','152','188553','316',323.00,360.00,0.00,1369.81,442448.63,488495.40,46046.77,550969),('1','152','188596','316',323.00,360.00,0.00,5830.72,1883322.56,2047789.20,164466.64,551078),('1','152','188795','316',323.00,360.00,0.00,5809.70,1876533.10,2039414.40,162881.30,551613),('1','152','188998','316',323.00,360.00,0.00,6428.18,2076302.14,2260730.80,184428.66,552144),('1','152','189190','316',323.00,360.00,0.00,4585.92,1481252.16,1608408.00,127155.84,552647),('1','152','189357','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,553092),('1','152','189363','316',323.00,360.00,0.00,1213.07,391821.61,428465.20,36643.59,553104),('1','152','189400','316',323.00,360.00,0.00,4429.50,1430728.50,1561947.00,131218.50,553204),('1','152','189580','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,553666),('1','152','189581','316',323.00,360.00,0.00,611.74,197592.02,215102.80,17510.78,553667),('1','152','189603','316',323.00,360.00,0.00,5289.12,1708385.76,1782866.40,74480.64,553724),('1','152','189803','316',323.00,360.00,0.00,5682.14,1835331.22,2001957.00,166625.78,554238),('1','152','190012','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,554789),('1','152','190019','316',323.00,360.00,0.00,5672.83,1832324.09,1990534.80,158210.71,554808),('1','152','190197','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,555270),('1','152','190210','316',323.00,360.00,0.00,1674.82,540966.86,591445.20,50478.34,555297),('1','152','190295','316',323.00,360.00,0.00,4633.41,1496591.43,1637173.60,140582.17,555515),('1','152','190420','316',323.00,360.00,0.00,1122.29,362499.67,397910.20,35410.53,555854),('1','152','190499','316',323.00,360.00,0.00,4080.19,1317901.37,1434848.40,116947.03,556048),('1','152','190656','316',323.00,360.00,0.00,2042.36,659682.28,718469.60,58787.32,556487),('1','152','190800','316',323.00,360.00,0.00,3041.24,982320.52,1079246.40,96925.88,556852),('1','152','190874','316',323.00,360.00,0.00,2736.26,883811.98,953211.40,69399.42,557054),('1','152','190984','316',323.00,360.00,0.00,3300.19,1065961.37,1158397.40,92436.03,557331),('1','152','191058','316',323.00,360.00,0.00,2439.50,787958.50,855580.00,67621.50,557535),('1','152','191230','316',323.00,360.00,0.00,1394.72,450494.56,485293.40,34798.84,557990),('1','152','191285','316',323.00,360.00,0.00,4620.27,1492347.21,1629120.00,136772.79,558125),('1','152','191483','316',323.00,360.00,0.00,3688.59,1191414.57,1305992.40,114577.83,558658),('1','152','191695','316',323.00,360.00,0.00,3215.39,1038570.97,1137440.40,98869.43,559222),('1','152','191918','316',323.00,360.00,0.00,2485.99,802974.77,878896.40,75921.63,559822),('1','152','192128','316',323.00,360.00,0.00,4380.42,1414875.66,1531931.20,117055.54,560367),('1','152','192324','316',323.00,360.00,0.00,2827.66,913334.18,999147.20,85813.02,560886),('1','152','192550','316',323.00,360.00,0.00,2837.50,916512.50,1003547.60,87035.10,561477),('1','152','192741','316',323.00,360.00,0.00,341.61,110340.03,120579.60,10239.57,561978),('1','152','192816','316',323.00,360.00,0.00,2450.25,791430.75,866070.00,74639.25,562147),('1','152','192943','316',323.00,360.00,0.00,3246.59,1048648.57,1140758.60,92110.03,562505),('1','152','193166','316',323.00,360.00,0.00,4179.53,1349988.19,1467371.00,117382.81,563081),('1','152','193402','316',323.00,360.00,0.00,1499.25,484257.75,533351.40,49093.65,563709),('1','152','193511','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,563981),('1','152','193512','316',323.00,360.00,0.00,2354.26,760425.98,822953.60,62527.62,563982),('1','152','193619','316',323.00,360.00,0.00,3298.44,1065396.12,1161818.40,96422.28,564276),('1','152','193847','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,564841),('1','152','193862','316',323.00,360.00,0.00,625.66,202088.18,220590.60,18502.42,564868),('1','152','193904','316',323.00,360.00,0.00,0.00,0.00,0.00,0.00,564966),('1','152','193909','316',323.00,360.00,0.00,3137.94,1013554.62,1107475.00,93920.38,564979),('1','152','194059','316',323.00,360.00,0.00,101.88,32907.24,36676.80,3769.56,565380),('1','152','194078','316',323.00,360.00,0.00,2609.38,842829.74,909343.42,66513.68,565417),('1','152','194205','316',323.00,360.00,0.00,1407.90,454751.70,495443.00,40691.30,565747),('1','152','194287','316',323.00,360.00,0.00,237.37,76670.51,83685.20,7014.69,565966),('1','152','194328','316',323.00,360.00,0.00,3103.69,1002491.87,1095122.94,92631.07,566061),('1','152','194486','316',323.00,360.00,0.00,4950.62,1599050.26,1740121.02,141070.76,566460),('1','152','194663','316',323.00,360.00,0.00,4208.91,1359477.93,1466034.60,106556.67,566918),('1','152','194960','316',323.00,360.00,0.00,1499.36,484293.28,527576.64,43283.36,567699),('1','152','195010','316',334.00,360.00,0.00,1523.08,508708.72,530836.80,22128.08,567828),('1','152','195071','316',334.00,360.00,0.00,3353.12,1119942.08,1180112.58,60170.50,567992),('1','152','195418','316',334.00,360.00,0.00,1739.96,565712.79,592043.40,26330.61,568870),('1','152','195507','316',323.00,348.00,0.00,3707.81,1197622.63,1251293.88,53671.25,569117),('1','152','195726','316',323.00,348.00,0.00,0.00,0.00,0.00,0.00,569650),('1','152','195731','316',323.00,348.00,0.00,741.52,239510.96,253422.96,13912.00,569662),('1','152','195784','316',323.00,348.00,0.00,4070.17,1314664.91,1389434.28,74769.37,569797),('1','152','195994','316',323.00,348.00,0.00,927.24,299498.52,314100.00,14601.48,570339),('1','152','196070','316',317.00,348.00,0.00,3445.39,1092188.63,1173645.24,81456.61,570521),('1','152','196218','316',317.00,348.00,0.00,2309.37,732097.11,783824.76,51727.65,570890),('1','152','196393','316',323.00,348.00,0.00,565.56,182675.88,192314.88,9639.00,571351),('1','152','196450','316',323.00,348.00,0.00,4740.32,1531123.36,1616495.88,85372.52,571493),('1','152','196664','316',323.00,348.00,0.00,404.55,129778.65,137273.40,7494.75,572037),('1','152','196708','316',317.00,348.00,0.00,3495.28,1108003.76,1186281.66,78277.90,572146),('1','152','196890','316',317.00,348.00,0.00,2328.97,745489.55,785781.56,40292.01,572637),('1','152','197028','316',323.00,348.00,0.00,1568.58,503511.36,525481.84,21970.48,572992),('1','152','197132','316',317.00,348.00,0.00,1658.13,525627.21,568776.32,43149.11,573257),('1','152','197226','316',317.00,348.00,0.00,3755.42,1190468.14,1266344.36,75876.22,573517),('1','152','197323','316',317.00,348.00,0.00,5207.43,1650755.31,1752138.38,101383.07,573773),('1','152','197519','316',317.00,348.00,0.00,3278.46,1039271.82,1116380.36,77108.54,574172),('1','152','197857','316',317.00,348.00,0.00,2516.13,797613.21,841189.24,43576.03,575088),('1','152','198097','316',317.00,348.00,0.00,1471.71,466532.07,496789.08,30257.01,575710),('1','152','198107','316',317.00,348.00,0.00,3629.01,1150396.17,1226830.62,76434.45,575730),('1','152','198350','316',317.00,348.00,0.00,2672.89,847306.13,895962.72,48656.59,576356),('1','152','198542','316',317.00,348.00,0.00,0.00,0.00,0.00,0.00,576872),('1','152','198544','316',317.00,348.00,0.00,286.40,90788.80,98367.20,7578.40,576876),('1','152','198553','316',317.00,348.00,0.00,3205.32,1016086.44,1085746.36,69659.92,576901),('1','152','198835','316',317.00,348.00,0.00,2541.13,805538.21,864592.24,59054.03,577576),('1','152','198945','316',317.00,348.00,0.00,637.43,202065.31,217925.64,15860.33,577884),('1','152','198970','316',317.00,348.00,0.00,4302.71,1363959.07,1450827.00,86867.93,577951),('1','152','199190','316',317.00,348.00,0.00,813.36,257835.12,269242.50,11407.38,578494),('1','152','199356','316',317.00,348.00,0.00,1574.25,499037.25,532196.88,33159.63,578895),('1','152','199435','316',317.00,348.00,0.00,3983.32,1262712.44,1338133.06,75420.62,579096),('1','152','199638','316',317.00,348.00,0.00,3019.21,971886.07,1013142.38,41256.31,579620),('1','152','199854','316',322.00,348.00,0.00,4006.39,1290057.58,1340551.14,50493.56,580131),('1','152','200088','316',322.00,348.00,0.00,507.82,161280.69,170871.36,9590.67,580745),('1','152','200154','316',312.00,348.00,0.00,3526.23,1100183.76,1176922.82,76739.06,580908),('1','152','200282','316',312.00,348.00,0.00,2332.70,727802.40,784115.60,56313.20,581254),('1','152','200439','316',312.00,348.00,0.00,807.51,251943.12,271939.48,19996.36,581662),('1','152','200479','316',312.00,348.00,0.00,4814.73,1502195.76,1627543.04,125347.28,581768),('1','152','200681','316',312.00,348.00,0.00,4252.01,1326627.12,1437139.30,110512.18,582297),('1','152','200904','316',312.00,348.00,0.00,1818.89,567493.68,609696.18,42202.50,582860),('1','152','201005','316',312.00,348.00,0.00,0.00,0.00,0.00,0.00,583105),('1','152','201009','316',312.00,348.00,0.00,2665.78,831723.36,894073.44,62350.08,583114),('1','152','201097','316',312.00,348.00,0.00,3124.22,974756.64,1054991.42,80234.78,583350),('1','152','201288','316',312.00,348.00,0.00,1037.75,323778.00,350739.60,26961.60,583844),('1','152','201294','316',312.00,348.00,0.00,1554.72,485072.64,525326.34,40253.70,583859),('1','152','201404','316',312.00,348.00,0.00,2463.78,768699.36,837549.90,68850.54,584138),('1','152','201515','316',312.00,348.00,0.00,3590.75,1120314.00,1210100.00,89786.00,584417),('1','152','201804','316',312.00,348.00,0.00,4377.92,1365911.04,1473063.16,107152.12,585187),('1','152','202012','316',312.00,348.00,0.00,0.00,0.00,0.00,0.00,585754),('1','152','202014','316',312.00,348.00,0.00,1364.89,425845.68,455852.74,30007.06,585758),('1','152','202016','316',312.00,348.00,0.00,4419.92,1379015.04,1481452.16,102437.12,585762),('1','152','202174','316',312.00,348.00,0.00,871.98,272057.76,294349.04,22291.28,586156),('1','152','202199','316',312.00,348.00,0.00,3790.76,1182717.12,1279482.48,96765.36,586224),('1','152','202413','316',312.00,348.00,0.00,2434.80,759657.60,826354.40,66696.80,586777),('1','152','202627','316',312.00,348.00,0.00,127.40,39748.80,44335.20,4586.40,587323),('1','152','202687','316',312.00,348.00,0.00,3805.18,1187216.16,1271616.08,84399.92,587460),('1','152','202834','316',312.00,360.00,0.00,2026.39,632233.68,707106.60,74872.92,587860),('1','152','203021','316',312.00,360.00,0.00,1500.77,468240.24,525308.40,57068.16,588329),('1','152','203093','316',312.00,360.00,0.00,3887.60,1212931.20,1363384.80,150453.60,588533),('1','152','203336','316',312.00,360.00,0.00,5007.06,1562202.72,1750215.36,188012.64,589157),('1','152','203511','316',312.00,360.00,0.00,5641.05,1760007.60,1957213.44,197205.84,589609),('1','152','203713','316',312.00,360.00,0.00,2510.01,783123.12,867538.80,84415.68,590133),('1','152','203922','316',312.00,360.00,0.00,730.00,227760.00,257700.00,29940.00,590677),('1','152','203938','316',318.00,360.00,0.00,1092.44,347395.92,383294.40,35898.48,590713),('1','152','203951','316',318.00,360.00,0.00,4455.93,1416985.74,1541947.20,124961.46,590745),('1','152','204174','316',318.00,360.00,0.00,228.09,72532.62,79232.40,6699.78,591337),('1','152','204223','316',318.00,360.00,0.00,4126.18,1312125.24,1431094.32,118969.08,591436),('1','152','204381','316',318.00,360.00,0.00,1736.21,552114.78,602559.60,50444.82,591869),('1','152','204522','316',318.00,360.00,0.00,2005.64,637793.52,696168.72,58375.20,592213),('1','152','204600','316',318.00,360.00,0.00,3364.75,1069990.50,1173012.24,103021.74,592426),('1','152','204855','316',318.00,360.00,0.00,2870.27,912745.86,1004317.20,91571.34,593033),('1','152','205027','316',318.00,360.00,0.00,2789.90,887188.20,981002.64,93814.44,593487),('1','152','205182','316',318.00,360.00,0.00,1202.69,382455.42,420828.96,38373.54,593888),('1','152','205214','316',318.00,360.00,0.00,827.72,263214.96,285559.20,22344.24,593977),('1','152','205332','316',322.00,360.00,0.00,4108.24,1322853.28,1423026.48,100173.20,594267),('1','152','205471','316',322.00,360.00,0.00,1742.59,564930.16,608516.40,43586.24,594624),('1','152','205603','316',328.00,360.00,0.00,2351.86,771410.08,820552.56,49142.48,594969),('1','152','205711','316',328.00,360.00,0.00,3902.62,1280059.36,1363759.92,83700.56,595259),('1','152','205929','316',328.00,360.00,0.00,4450.57,1673414.32,1608513.22,-64901.10,595821),('1','152','206129','316',376.00,376.00,0.00,1405.19,519505.04,504471.44,-15033.60,596331),('1','152','206255','316',328.00,376.00,0.00,2757.73,904535.44,1001236.48,96701.04,596643),('1','152','206347','316',328.00,376.00,0.00,3557.06,1166715.68,1281104.66,114388.98,596885),('1','152','206560','316',328.00,376.00,0.00,584.41,188946.10,209508.16,20562.06,597428),('1','152','206612','316',322.00,376.00,0.00,5541.08,1784227.76,1974105.98,189878.22,597545),('1','152','206780','316',322.00,376.00,0.00,4383.55,1411503.10,1594603.00,183099.90,597994),('1','152','207011','316',322.00,376.00,0.00,3749.62,1207377.64,1362157.12,154779.48,598597),('1','152','207233','316',322.00,376.00,0.00,4592.07,1478646.54,1674655.92,196009.38,599171),('1','152','207468','316',322.00,376.00,0.00,2764.29,890101.38,992976.24,102874.86,599778),('1','152','207612','316',322.00,376.00,0.00,2849.90,917667.80,1025017.40,107349.60,600135),('1','152','207690','316',322.00,376.00,0.00,488.99,177903.84,181794.97,3891.13,600334),('1','152','207769','316',332.00,384.00,0.00,4734.60,1571887.20,1742458.17,170570.97,600528),('1','152','207891','316',332.00,384.00,0.00,5855.15,1943909.80,2170933.10,227023.30,600851),('1','152','208098','316',332.00,384.00,0.00,5852.64,1943076.48,2157307.86,214231.38,601382),('1','152','208312','316',332.00,384.00,0.00,5363.64,1780728.48,1994585.83,213857.35,601926),('1','152','208626','316',332.00,384.00,0.00,2356.13,782235.16,864791.92,82556.76,602724),('1','152','208684','316',340.00,384.00,0.00,2907.17,988437.80,1075880.30,87442.50,602883),('1','152','208745','316',340.00,384.00,0.00,6327.27,2151271.80,2322336.59,171064.79,603048),('1','152','208975','316',340.00,384.00,0.00,4615.17,1569157.80,1803013.68,233855.88,603627),('1','152','209203','316',340.00,400.00,0.00,5299.01,1801663.40,2053278.32,251614.92,604208),('1','152','209424','316',340.00,400.00,0.00,3565.05,25630917.00,1388298.24,-24242618.76,604767),('1','152','209603','316',340.00,400.00,0.00,954.77,324621.80,372704.00,48082.20,605234),('1','152','209630','316',340.00,400.00,0.00,5021.75,1707395.00,2008700.00,301305.00,605300),('1','152','209849','316',340.00,420.00,0.00,4479.31,1522965.40,1756568.74,233603.34,605867),('1','152','210173','316',340.00,420.00,0.00,4424.33,1504272.20,1787252.46,282980.26,606695),('1','152','210297','316',340.00,420.00,0.00,4897.18,1665041.20,1964942.24,299901.04,607027),('1','152','210513','316',340.00,420.00,0.00,3564.09,1211790.60,1430731.30,218940.70,607590),('1','152','210696','316',340.00,420.00,0.00,914.94,325737.04,370000.86,44263.82,608076),('1','152','210715','316',368.00,420.00,0.00,4633.97,1705300.96,1872692.94,167391.98,608124),('1','152','210937','316',368.00,420.00,0.00,6440.48,2370096.64,2584818.62,214721.98,608696),('1','152','211160','316',368.00,424.00,0.00,5534.91,2036846.88,2277419.05,240572.17,609264),('1','152','211356','316',368.00,424.00,0.00,2612.49,961396.32,1068918.70,107522.38,609777),('1','152','211510','316',382.00,424.00,0.00,2677.69,1022877.58,1117065.92,94188.34,610171),('1','152','211591','316',382.00,424.00,0.00,5273.52,2014484.64,2143242.08,128757.44,610389),('1','152','211768','316',382.00,424.00,0.00,4827.04,1843929.28,1973840.16,129910.88,610831),('1','152','211976','316',382.00,424.00,0.00,5736.71,2191423.22,2337243.30,145820.08,611376),('1','152','212216','316',382.00,424.00,0.00,6051.20,2311558.40,2471980.51,160422.11,612006),('1','152','212465','316',382.00,424.00,0.00,5033.84,1922926.88,2070413.74,147486.86,612646),('1','152','212656','316',382.00,424.00,0.00,799.12,305263.84,326968.88,21705.04,613172),('1','152','212710','316',382.00,424.00,0.00,4090.32,1562502.24,1690604.56,128102.32,613301),('1','152','212856','316',382.00,424.00,0.00,4163.07,1590292.74,1725541.90,135249.16,613687),('1','152','213116','316',382.00,424.00,0.00,6497.58,2482075.56,2668671.66,186596.10,614369),('1','152','213374','316',382.00,424.00,0.00,6364.70,2431315.40,2619537.74,188222.34,615036),('1','152','213618','316',382.00,424.00,0.00,2360.34,901649.88,977919.34,76269.46,615684),('1','152','213754','316',382.00,424.00,0.00,2780.57,1062177.74,1150724.24,88546.50,616026),('1','152','213868','316',382.00,424.00,0.00,5719.67,2190074.42,2355652.42,165578.00,616338),('1','152','214083','316',384.00,424.00,0.00,5483.66,2109120.56,2280301.84,171181.28,616898),('1','152','214323','316',382.00,424.00,0.00,5666.43,2169856.90,2360235.90,190379.00,617519),('1','152','214550','316',384.00,424.00,0.00,4211.18,1688337.22,1745236.32,56899.10,618088),('1','152','214737','316',382.00,424.00,0.00,1362.89,520623.98,566247.82,45623.84,618593),('1','152','214762','316',382.00,424.00,0.00,5933.17,2266470.94,2461079.88,194608.94,618660),('1','152','215012','316',382.00,424.00,0.00,6415.94,2450889.08,2642689.98,191800.90,619300),('1','152','215215','316',382.00,424.00,0.00,5924.08,2262998.56,2461186.60,198188.04,619826),('1','152','215432','316',382.00,424.00,0.00,4442.30,1950089.74,1885194.28,-64895.46,620387),('1','152','215664','316',440.00,440.00,0.00,5780.59,2208185.38,2477504.60,269319.22,620988),('1','152','215897','316',382.00,440.00,0.00,6143.50,2346817.00,2609675.00,262858.00,621581),('1','152','216091','316',382.00,440.00,0.00,5600.34,2139329.88,2394114.00,254784.12,622088),('1','152','216310','316',382.00,440.00,0.00,4248.74,1623018.68,1839701.25,216682.57,622656),('1','152','216547','316',382.00,440.00,0.00,2393.10,914164.20,1027050.50,112886.30,623284),('1','152','216690','316',382.00,440.00,0.00,601.71,229853.22,249709.65,19856.43,623653),('1','152','216754','316',382.00,440.00,0.00,0.00,0.00,0.00,0.00,623828),('1','152','216783','316',382.00,440.00,0.00,5359.74,2122457.04,2318659.10,196202.06,623902),('1','152','217005','316',396.00,440.00,0.00,2933.95,1161844.20,1275813.00,113968.80,624486),('1','152','217006','316',396.00,440.00,0.00,3789.54,1788662.88,1754382.56,-34280.32,624487),('1','152','217262','316',472.00,472.00,0.00,4421.80,2087089.60,2046288.96,-40800.64,625164),('1','152','217493','316',472.00,472.00,0.00,4987.24,2353977.28,2291963.20,-62014.08,625769),('1','152','217702','316',472.00,472.00,0.00,3214.69,1467933.68,1478303.68,10370.00,626310),('1','152','217999','316',396.00,472.00,0.00,4270.50,1823184.82,2003746.40,180561.58,627074),('1','152','218206','316',427.00,472.00,0.00,3306.67,1411948.09,1533164.24,121216.15,627637),('1','152','218433','316',427.00,472.00,0.00,5010.07,2139299.89,2303176.40,163876.51,628236),('1','152','218673','316',427.00,472.00,0.00,4882.92,2085006.84,2224330.88,139324.04,628852),('1','152','218893','316',427.00,472.00,0.00,4642.32,1982270.64,2121636.16,139365.52,629436),('1','152','219113','316',427.00,472.00,0.00,2068.27,883151.29,937732.40,54581.11,629996),('1','152','219285','316',427.00,460.00,0.00,0.00,0.00,0.00,0.00,630458),('1','152','219286','316',427.00,460.00,0.00,2624.11,1120494.97,1180172.20,59677.23,630459),('1','152','219340','316',427.00,460.00,0.00,4648.12,1984747.24,2085369.80,100622.56,630585),('1','152','219576','316',427.00,460.00,0.00,3562.11,1521020.97,1613218.80,92197.83,631220),('1','152','219797','316',427.00,460.00,0.00,4044.18,1726864.86,1825975.60,99110.74,631800),('1','152','220036','316',427.00,460.00,0.00,4378.37,1869563.99,1990631.00,121067.01,632434),('1','152','220228','316',427.00,460.00,0.00,4598.38,1963508.26,2071210.00,107701.74,632945),('1','152','220456','316',427.00,460.00,0.00,725.17,309647.59,326723.20,17075.61,633541),('1','152','220611','316',427.00,460.00,0.00,0.00,0.00,0.00,0.00,633935),('1','152','220612','316',427.00,460.00,0.00,3098.57,1323089.39,1407589.60,84500.21,633936),('1','152','220676','316',427.00,460.00,0.00,6457.44,2757326.88,2904422.40,147095.52,634110),('1','152','220898','316',427.00,460.00,0.00,5054.76,2158382.52,2265775.28,107392.76,634687),('1','152','221128','316',427.00,460.00,0.00,4127.68,1762519.36,1869719.00,107199.64,635286),('1','152','221383','316',427.00,460.00,0.00,5939.70,2536251.90,2702442.00,166190.10,635949),('1','152','221606','316',427.00,460.00,0.00,6399.62,2732637.74,2889176.72,156538.98,636534),('1','152','221838','316',427.00,460.00,0.00,5181.85,2212649.95,2351407.00,138757.05,637125),('1','152','222063','316',427.00,460.00,0.00,6172.88,2635819.76,2775466.40,139646.64,637716),('1','152','222299','316',427.00,460.00,0.00,6012.70,2567422.90,2695260.48,127837.58,638310),('1','152','222488','316',427.00,460.00,0.00,0.00,0.00,0.00,0.00,638802),('1','152','222512','316',427.00,460.00,0.00,5194.55,2218072.85,2359553.00,141480.15,638857),('1','152','222717','316',427.00,460.00,0.00,3947.50,1685582.50,1757859.04,72276.54,639420),('1','152','222936','316',427.00,460.00,0.00,3130.38,1336672.26,1393632.00,56959.74,639999),('1','152','223079','316',427.00,460.00,0.00,4341.85,1853969.95,1968110.92,114140.97,640384),('1','152','223164','316',427.00,460.00,0.00,3917.61,1672819.47,1780713.80,107894.33,640599),('1','152','223379','316',427.00,460.00,0.00,3252.80,1388945.60,1546391.76,157446.16,641124),('1','152','223406','316',427.00,480.00,0.00,922.46,393890.42,436562.34,42671.92,641189),('1','152','223613','316',427.00,480.00,0.00,1785.33,762335.91,846180.00,83844.09,641714),('1','152','223626','316',427.00,480.00,0.00,5067.50,2261214.30,2350272.68,89058.38,641751),('1','152','223872','316',447.00,480.00,0.00,5845.07,2612746.29,2768664.48,155918.19,642378),('1','152','224097','316',447.00,480.00,0.00,4273.91,1910437.77,2027682.96,117245.19,642955),('1','152','224314','316',447.00,480.00,0.00,3748.78,1675704.66,1979438.80,303734.14,643517),('1','152','224523','316',447.00,540.00,0.00,3645.96,1629744.12,1927974.40,298230.28,644085),('1','152','224789','316',447.00,540.00,0.00,624.37,279093.39,324237.00,45143.61,644742),('1','152','224842','316',447.00,540.00,0.00,0.00,0.00,0.00,0.00,644885),('1','152','224856','316',447.00,540.00,0.00,0.00,0.00,0.00,0.00,644924),('1','152','224874','316',485.00,540.00,0.00,3091.86,1499552.10,1638133.60,138581.50,644974),('1','152','225013','316',485.00,540.00,0.00,3939.24,1910531.40,2082302.40,171771.00,645330),('1','152','225256','316',485.00,540.00,0.00,5027.80,2438483.00,2615095.04,176612.04,645966),('1','152','225488','316',485.00,540.00,0.00,4299.16,2085092.60,2285611.28,200518.68,646552),('1','152','225709','316',485.00,540.00,0.00,5065.00,2456525.00,2621629.20,165104.20,647123),('1','152','225967','316',485.00,540.00,0.00,2509.20,1216962.00,1298803.20,81841.20,647805),('1','152','226142','316',485.00,540.00,0.00,0.00,0.00,0.00,0.00,648270),('1','152','226149','316',475.00,540.00,0.00,1724.73,819246.75,916690.20,97443.45,648286),('1','152','226458','316',475.00,540.00,0.00,3625.32,1722027.00,1930431.20,208404.20,649085),('1','152','226462','316',475.00,540.00,0.00,4208.19,1998890.25,2220723.00,221832.75,649095),('1','152','226719','316',475.00,540.00,0.00,3718.06,1766078.50,1983043.20,216964.70,649752),('1','152','226945','316',475.00,540.00,0.00,6491.44,3083434.00,3362231.20,278797.20,650343),('1','152','227268','316',475.00,540.00,0.00,4887.62,2321619.50,2567036.00,245416.50,651170),('1','152','227363','316',475.00,540.00,0.00,4898.08,2359311.18,2584979.60,225668.42,651415),('1','152','227596','316',482.00,540.00,0.00,4579.04,2207097.28,2431256.40,224159.12,652023),('1','152','227843','316',482.00,540.00,0.00,5306.75,2557853.50,2825604.34,267750.84,652659),('1','152','228111','316',482.00,540.00,0.00,5775.22,2783656.04,3074515.62,290859.58,653371),('1','152','228340','316',482.00,540.00,0.00,4068.54,1961036.28,2161215.84,200179.56,653966),('1','152','228525','316',482.00,540.00,0.00,7808.93,3785180.23,4166635.14,381454.91,654430),('1','152','228743','316',485.00,540.00,0.00,5224.57,2533916.45,2790265.18,256348.73,654991),('1','152','228924','316',485.00,540.00,0.00,5783.92,2805201.20,3072485.80,267284.60,655452),('1','152','229157','316',485.00,540.00,0.00,5608.90,2720316.50,2987407.94,267091.44,656072),('1','152','229393','316',485.00,540.00,0.00,0.00,0.00,0.00,0.00,656680),('1','152','229400','316',485.00,540.00,0.00,4001.18,1940572.30,2155642.32,215070.02,656698),('1','152','229405','316',485.00,584.00,0.00,3348.39,1648741.21,1852953.50,204212.29,656707),('1','152','229651','316',502.00,584.00,0.00,4641.18,2329872.36,2642691.80,312819.44,657337),('1','152','229877','316',502.00,584.00,0.00,5609.59,2816014.18,3170068.93,354054.75,657911),('1','152','230105','316',502.00,584.00,0.00,4367.43,2192449.86,2455151.03,262701.17,658483),('1','152','230312','316',502.00,584.00,0.00,2343.52,1176447.04,1335095.89,158648.85,659023),('1','152','230426','316',502.00,584.00,0.00,2698.29,1419300.54,1551069.40,131768.86,659334),('1','152','230531','316',526.00,584.00,0.00,5407.21,2844192.46,3059062.88,214870.42,659592),('1','152','230799','316',526.00,584.00,0.00,3807.69,2002844.94,2172619.28,169774.34,660278),('1','152','231099','316',526.00,584.00,0.00,3113.80,1637858.80,1791549.68,153690.88,661080),('1','152','231357','316',526.00,584.00,0.00,5612.50,2952175.00,3249862.40,297687.40,661792),('1','152','231627','316',526.00,584.00,0.00,1991.67,1047618.42,1146592.56,98974.14,662496),('1','152','231931','316',526.00,584.00,0.00,1999.57,1051773.82,1132491.92,80718.10,663302),('1','152','231999','316',526.00,584.00,0.00,3121.65,1641987.90,1797068.64,155080.74,663495),('1','152','232128','316',526.00,584.00,0.00,3729.46,1961695.96,2159486.24,197790.28,663826),('1','152','232514','316',526.00,584.00,0.00,4421.99,2325966.74,2551575.76,225609.02,664849),('1','152','232751','316',526.00,584.00,0.00,4407.89,2480344.56,2553682.24,73337.68,665466),('1','152','233042','316',572.00,584.00,0.00,0.00,0.00,0.00,0.00,666237),('1','152','233047','316',572.00,584.00,0.00,3679.61,2104736.92,2107396.72,2659.80,666250),('1','152','233230','316',572.00,584.00,0.00,5363.72,3068047.84,3100869.76,32821.92,666730),('1','152','233375','316',526.00,624.00,0.00,2134.80,1122904.80,1307940.48,185035.68,667105),('1','152','233660','316',526.00,624.00,0.00,4003.82,2106009.32,2446226.88,340217.56,667836),('1','152','233974','316',526.00,624.00,0.00,4816.71,2533589.46,2919367.08,385777.62,668677),('1','152','234243','316',526.00,624.00,0.00,0.00,0.00,0.00,0.00,669391),('1','152','234320','316',526.00,624.00,0.00,3557.78,1928316.76,2199764.76,271448.00,669582),('1','152','234456','316',542.00,624.00,0.00,3079.49,1669083.58,1889506.68,220423.10,669963),('1','152','234626','316',542.00,624.00,0.00,3968.29,2150813.18,2433887.40,283074.22,670392),('1','152','234945','316',542.00,624.00,0.00,4266.05,2312199.10,2621231.16,309032.06,671254),('1','152','235182','316',542.00,624.00,0.00,3960.68,2146688.56,2427133.56,280445.00,671878),('1','152','235360','316',542.00,624.00,0.00,5180.29,2807717.18,3151880.76,344163.58,672337),('1','152','235529','316',542.00,624.00,0.00,538.22,291715.24,317384.88,25669.64,672770),('1','152','235682','316',542.00,624.00,0.00,5224.40,2831624.80,3211105.92,379481.12,673177),('1','152','235811','316',542.00,640.00,0.00,3863.23,2093870.66,2462745.58,368874.92,673500),('1','152','236066','316',542.00,640.00,0.00,5323.93,2885570.06,3349345.20,463775.14,674171),('1','152','236232','316',542.00,640.00,0.00,3036.96,1646032.32,1909282.44,263250.12,674625),('1','152','236421','316',542.00,640.00,0.00,1389.27,752984.34,880537.60,127553.26,675130),('1','152','236563','316',542.00,640.00,0.00,4617.69,2502787.98,2926529.04,423741.06,675481),('1','152','236719','316',542.00,640.00,0.00,4641.57,2649207.34,2912823.84,263616.50,675902),('1','152','236953','316',582.00,640.00,0.00,5563.48,3237945.36,3487080.10,249134.74,676498),('1','152','237154','316',582.00,640.00,0.00,5759.73,3352162.86,3604423.20,252260.34,677025),('1','152','237461','316',582.00,640.00,0.00,2271.81,1322193.42,1420541.50,98348.08,677807),('1','152','237487','316',582.00,640.00,0.00,3390.53,1973288.46,2119021.14,145732.68,677871),('1','152','237591','316',582.00,640.00,0.00,4332.84,2521712.88,2762198.02,240485.14,678156),('1','152','237857','316',582.00,640.00,0.00,3697.17,2179395.44,2350001.04,170605.60,678848),('1','152','238179','316',592.00,640.00,0.00,4173.67,2470812.64,2638442.62,167629.98,679662),('1','152','238342','316',592.00,640.00,0.00,3712.55,2197829.60,2360431.38,162601.78,680091),('1','152','238599','316',592.00,640.00,0.00,4106.52,2431059.84,2612399.94,181340.10,680768),('1','152','238819','316',592.00,640.00,0.00,1011.01,598517.92,644360.62,45842.70,681336),('1','152','238910','316',592.00,640.00,0.00,2525.81,1495279.52,1611232.34,115952.82,681558),('1','152','239047','316',592.00,640.00,0.00,3108.97,1840510.24,1981305.82,140795.58,681932),('1','152','239280','316',592.00,640.00,0.00,3674.17,2175108.64,2333051.02,157942.38,682534),('1','152','239540','316',592.00,640.00,0.00,3987.02,2360315.84,2521079.30,160763.46,683200),('1','152','239747','316',592.00,640.00,0.00,3971.92,2351376.64,2565117.80,213741.16,683756),('1','152','239971','316',592.00,656.00,0.00,2973.90,1760548.80,1938307.40,177758.60,684336),('1','152','240211','316',592.00,656.00,0.00,3571.32,2114221.44,2307292.54,193071.10,684938),('1','152','240392','316',592.00,656.00,0.00,342.52,202771.84,224693.12,21921.28,685423),('1','152','240434','316',592.00,656.00,0.00,3215.15,1967671.80,2046924.32,79252.52,685539),('1','152','240677','316',612.00,640.00,0.00,2063.97,1263149.64,1311632.40,48482.76,686125),('1','152','240897','316',612.00,640.00,0.00,752.97,460817.64,481432.80,20615.16,686712),('1','152','241027','316',612.00,640.00,0.00,4192.35,2565718.20,2646805.68,81087.48,687042),('1','152','241226','316',612.00,640.00,0.00,3858.08,2361144.96,2439837.52,78692.56,687568),('1','152','241480','316',612.00,640.00,0.00,3427.51,2097636.12,2183398.96,85762.84,688253),('1','152','241716','316',612.00,640.00,0.00,4363.41,2670406.92,2753968.32,83561.40,688877),('1','152','241961','316',612.00,640.00,0.00,3310.30,2025903.60,2105953.84,80050.24,689520),('1','152','242197','316',612.00,640.00,0.00,4624.43,2830151.16,2928649.28,98498.12,690120),('1','152','242473','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,690821),('1','152','242489','316',602.00,640.00,0.00,4283.29,2578540.58,2714813.92,136273.34,690862),('1','152','242671','316',602.00,640.00,0.00,4134.27,2488830.54,2623928.88,135098.34,691350),('1','152','242910','316',602.00,640.00,0.00,6232.27,3751826.54,3911349.52,159522.98,691980),('1','152','243135','316',602.00,640.00,0.00,4360.89,2625255.78,2758722.96,133467.18,692567),('1','152','243352','316',602.00,640.00,0.00,4837.56,2912211.12,3066438.00,154226.88,693149),('1','152','243579','316',602.00,640.00,0.00,1348.19,811610.38,845557.52,33947.14,693729),('1','152','243683','316',602.00,640.00,0.00,0.00,0.00,0.00,0.00,693977),('1','152','243689','316',602.00,640.00,0.00,3414.01,2055234.02,2167252.72,112018.70,693993),('1','152','243828','316',602.00,640.00,0.00,4566.97,2749315.94,2906120.80,156804.86,694363),('1','152','244040','316',602.00,640.00,0.00,4335.49,2609964.98,2739269.92,129304.94,694908),('1','152','244289','316',602.00,640.00,0.00,3845.97,2315273.94,2440546.56,125272.62,695563),('1','152','244519','316',602.00,640.00,0.00,3554.59,2139863.18,2252343.52,112480.34,696152),('1','152','244727','316',602.00,640.00,0.00,3093.21,1862112.42,1965050.16,102937.74,696712),('1','152','244962','316',602.00,640.00,0.00,1464.40,887426.40,903229.20,15802.80,697320),('1','152','245084','316',606.00,624.00,0.00,0.00,0.00,0.00,0.00,697616),('1','152','245092','316',602.00,624.00,0.00,2108.63,1269395.26,1311810.48,42415.22,697636),('1','152','245210','316',602.00,624.00,0.00,3632.40,2186704.80,2235186.96,48482.16,697950),('1','152','245366','316',602.00,624.00,0.00,0.00,0.00,0.00,0.00,698349),('1','152','245394','316',602.00,624.00,0.00,0.00,0.00,0.00,0.00,698428),('1','152','245486','316',602.00,624.00,0.00,6077.75,3658805.50,3745626.24,86820.74,698649),('1','152','245685','316',602.00,624.00,0.00,3552.03,2138322.06,2195493.84,57171.78,699166),('1','152','245923','316',602.00,624.00,0.00,3553.24,1954282.00,2163330.24,209048.24,699808),('1','152','246177','316',550.00,616.00,0.00,3920.43,2156236.50,2368947.16,212710.66,700455),('1','152','246442','316',550.00,616.00,0.00,3883.48,2135914.00,2367113.66,231199.66,701160),('1','152','246700','316',550.00,616.00,0.00,4043.07,2223688.50,2422051.84,198363.34,701830),('1','152','246970','316',552.00,616.00,0.00,4423.25,2441634.00,2661331.70,219697.70,702505),('1','152','247178','316',552.00,616.00,0.00,4301.66,2374516.32,2616934.86,242418.54,703055),('1','152','247381','316',552.00,616.00,0.00,3892.21,2148499.92,2353569.24,205069.32,703584),('1','152','247642','316',552.00,616.00,0.00,3705.86,2045634.72,2246264.14,200629.42,704275),('1','152','247933','316',552.00,616.00,0.00,4499.48,2483712.96,2708931.08,225218.12,704997),('1','152','248141','316',552.00,616.00,0.00,4226.67,2333121.84,2552295.48,219173.64,705555),('1','152','248449','316',552.00,616.00,0.00,188.33,103958.16,110491.28,6533.12,706327),('1','152','248461','316',547.00,616.00,0.00,3717.92,2033702.24,2266066.18,232363.94,706354),('1','152','248649','316',547.00,616.00,0.00,3467.88,1896930.36,2120315.56,223385.20,706844),('1','152','248880','316',547.00,600.00,0.00,3407.86,1864099.42,2030342.55,166243.13,707442),('1','152','249100','316',547.00,600.00,0.00,3930.35,2149901.45,2312539.05,162637.60,708021),('1','152','249360','316',547.00,600.00,0.00,4488.35,2455127.45,2637884.55,182757.10,708666),('1','152','249582','316',547.00,600.00,0.00,3665.27,2004902.69,2170442.10,165539.41,709246),('1','152','249835','316',547.00,600.00,0.00,1837.51,1005117.97,1044096.00,38978.03,709906),('1','152','249978','316',547.00,600.00,0.00,0.00,0.00,0.00,0.00,710260),('1','152','250010','316',547.00,600.00,0.00,2894.22,1583138.34,1712009.25,128870.91,710348),('1','152','250083','316',547.00,600.00,0.00,4422.68,2419205.96,2631076.95,211870.99,710532),('1','152','250326','316',547.00,600.00,0.00,4669.01,2553948.47,2647406.71,93458.24,711153),('1','152','250579','316',547.00,568.00,0.00,4466.19,2443005.93,2507298.48,64292.55,711774),('1','152','250805','316',547.00,568.00,0.00,4552.59,2490266.73,2572900.08,82633.35,712375),('1','152','251018','316',547.00,568.00,0.00,3551.03,1942413.41,1982510.00,40096.59,712931),('1','152','251216','316',547.00,568.00,0.00,0.00,0.00,0.00,0.00,713448),('1','152','251227','316',527.00,568.00,0.00,939.31,495016.37,531131.92,36115.55,713480),('1','152','251259','316',527.00,568.00,0.00,5116.26,2696269.02,2877815.52,181546.50,713563),('1','152','251510','316',527.00,568.00,0.00,3936.56,2074567.12,2217308.24,142741.12,714217),('1','152','251760','316',527.00,568.00,0.00,3403.92,1793865.84,1923465.84,129600.00,714870),('1','152','251978','316',527.00,568.00,0.00,4156.63,2190544.01,2339812.96,149268.95,715450),('1','152','252289','316',527.00,568.00,0.00,3862.86,2035727.22,2189547.84,153820.62,716233),('1','152','252462','316',527.00,568.00,0.00,2691.04,1418178.08,1494490.72,76312.64,716708),('1','152','252620','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,717108),('1','152','252638','316',527.00,568.00,0.00,1459.07,768929.89,828031.76,59101.87,717156),('1','152','252723','316',527.00,568.00,0.00,3204.80,1688929.60,1812099.20,123169.60,717372),('1','152','252960','316',527.00,568.00,0.00,3958.24,2085992.48,2223615.52,137623.04,717998),('1','152','253218','316',527.00,568.00,0.00,3796.29,2000644.83,2137127.52,136482.69,718664),('1','152','253466','316',527.00,568.00,0.00,4056.20,2137617.40,2270491.28,132873.88,719316),('1','152','253701','316',527.00,568.00,0.00,3625.41,1910591.07,2047972.80,137381.73,719924),('1','152','253956','316',527.00,568.00,0.00,4822.81,2541620.87,2708884.48,167263.61,720578),('1','152','254146','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,721083),('1','152','254178','316',527.00,568.00,0.00,5546.89,2923211.03,3092515.12,169304.09,721172),('1','152','254456','316',527.00,568.00,0.00,4205.92,2216519.84,2369981.68,153461.84,721871),('1','152','254695','316',527.00,568.00,0.00,4637.27,2443841.29,2606367.92,162526.63,722479),('1','152','254962','316',527.00,568.00,0.00,3332.40,1756174.80,1886228.88,130054.08,723152),('1','152','255189','316',527.00,568.00,0.00,4079.40,2149843.80,2291438.16,141594.36,723749),('1','152','255453','316',527.00,568.00,0.00,2603.19,1371881.13,1469083.92,97202.79,724408),('1','152','255629','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,724824),('1','152','255637','316',527.00,568.00,0.00,1840.27,969822.29,1040065.36,70243.07,724846),('1','152','255715','316',527.00,568.00,0.00,4280.04,2255581.08,2414784.24,159203.16,725048),('1','152','255945','316',527.00,568.00,0.00,4381.36,2308976.72,2456947.84,147971.12,725634),('1','152','256204','316',527.00,568.00,0.00,3960.12,2086983.24,2226028.56,139045.32,726277),('1','152','256477','316',527.00,568.00,0.00,3528.75,1859651.25,1994569.20,134917.95,726992),('1','152','256709','316',527.00,568.00,0.00,4058.62,2138892.74,2291368.00,152475.26,727592),('1','152','256954','316',527.00,568.00,0.00,2978.07,1569442.89,1677509.76,108066.87,728234),('1','152','257168','316',527.00,568.00,0.00,635.62,334971.74,361032.16,26060.42,728787),('1','152','257248','316',527.00,568.00,0.00,4620.08,2434782.16,2597835.92,163053.76,728983),('1','152','257476','316',527.00,568.00,0.00,5883.13,3100409.51,3301056.16,200646.65,729596),('1','152','257477','316',527.00,568.00,0.00,5512.11,2904881.97,3112660.32,207778.35,729597),('1','152','257478','316',527.00,568.00,0.00,6296.39,3318197.53,3537567.92,219370.39,729598),('1','152','257479','316',527.00,568.00,0.00,1559.94,822088.38,883008.48,60920.10,729599),('1','152','257480','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,729600),('1','152','257481','316',527.00,568.00,0.00,3137.70,1653567.90,1765484.16,111916.26,729601),('1','152','257482','316',527.00,568.00,0.00,5294.66,2790285.82,2986869.92,196584.10,729602),('1','152','257483','316',527.00,568.00,0.00,5185.13,2732563.51,2919298.64,186735.13,729603),('1','152','257484','316',527.00,568.00,0.00,5539.79,2919469.33,3108059.84,188590.51,729604),('1','152','257485','316',527.00,568.00,0.00,5830.98,3072926.46,3275691.12,202764.66,729605),('1','152','257486','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,729606),('1','152','257487','316',527.00,568.00,0.00,3538.28,1864673.56,2002677.12,138003.56,729607),('1','152','257488','316',527.00,568.00,0.00,4099.01,2160178.27,2313189.68,153011.41,729608),('1','152','257489','316',527.00,568.00,0.00,3973.98,2094287.46,2241832.80,147545.34,729609),('1','152','257490','316',527.00,568.00,0.00,3054.64,1609795.28,1725248.32,115453.04,729610),('1','152','257491','316',527.00,568.00,0.00,3807.16,2006373.32,2144669.68,138296.36,729611),('1','152','257492','316',527.00,568.00,0.00,5662.02,2983884.54,3163087.20,179202.66,729612),('1','152','257493','316',527.00,568.00,0.00,257.43,135665.61,146220.24,10554.63,729613),('1','152','257494','316',527.00,568.00,0.00,0.00,0.00,0.00,0.00,729614),('1','152','257495','316',517.00,568.00,0.00,3370.60,1742600.20,1906663.36,164063.16,729615),('1','152','257496','316',517.00,568.00,0.00,4039.72,2088535.24,2264047.60,175512.36,729616),('1','152','257497','316',517.00,568.00,0.00,3176.68,1642343.56,1796290.24,153946.68,729617),('1','152','257498','316',517.00,568.00,0.00,3561.97,1841538.49,2007915.76,166377.27,729618),('1','152','257499','316',517.00,568.00,0.00,3289.48,1700661.16,1855761.28,155100.12,729619),('1','152','257500','316',517.00,568.00,0.00,3254.51,1682581.67,1833272.48,150690.81,729620),('1','152','257501','316',517.00,568.00,0.00,3327.41,1720270.97,1864459.52,144188.55,729621),('1','152','257502','316',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729622),('1','152','257503','316',517.00,568.00,0.00,670.02,346400.34,379371.36,32971.02,729623),('1','152','257504','316',517.00,568.00,0.00,3287.13,1699446.21,1865138.64,165692.43,729624),('1','152','257505','316',517.00,568.00,0.00,3502.09,1810580.53,1985490.88,174910.35,729625),('1','152','257506','316',517.00,568.00,0.00,4052.58,2095183.86,2272469.76,177285.90,729626),('1','152','257507','316',517.00,568.00,0.00,4214.99,2179149.83,2366162.00,187012.17,729627),('1','152','257508','316',517.00,568.00,0.00,2811.55,1453571.35,1591920.88,138349.53,729628),('1','152','257509','316',517.00,568.00,0.00,3190.03,1649245.51,1807521.04,158275.53,729629),('1','152','257510','316',517.00,568.00,0.00,2501.30,1293172.10,1393370.24,100198.14,729630),('1','152','257511','316',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729631),('1','152','257512','316',517.00,568.00,0.00,1753.69,906657.73,986770.48,80112.75,729632),('1','152','257513','316',517.00,568.00,0.00,4110.90,2125335.30,2317457.20,192121.90,729633),('1','152','257514','316',517.00,568.00,0.00,3720.43,1923462.31,2096170.00,172707.69,729634),('1','152','257515','316',517.00,568.00,0.00,4630.95,2394201.15,2600761.20,206560.05,729635),('1','152','257516','316',517.00,568.00,0.00,4362.09,2255200.53,2452474.56,197274.03,729636),('1','152','257517','316',517.00,568.00,0.00,3786.68,1957713.56,2143764.08,186050.52,729637),('1','152','257518','316',517.00,568.00,0.00,1604.89,829728.13,899087.92,69359.79,729638),('1','152','257519','316',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729639),('1','152','257520','316',517.00,568.00,0.00,2817.13,1456456.21,1595453.44,138997.23,729640),('1','152','257521','316',517.00,568.00,0.00,3813.88,1971775.96,2158891.84,187115.88,729641),('1','152','257522','316',517.00,568.00,0.00,4953.27,2560840.59,2797441.44,236600.85,729642),('1','152','257523','316',517.00,568.00,0.00,5180.12,2678122.04,2911130.96,233008.92,729643),('1','152','257524','316',517.00,568.00,0.00,3786.65,1957698.05,2133418.16,175720.11,729644),('1','152','257525','316',517.00,568.00,0.00,3011.36,1556873.12,1921630.80,364757.68,729645),('1','152','257526','316',517.00,640.00,0.00,373.09,192887.53,237428.20,44540.67,729646),('1','152','257527','316',517.00,640.00,0.00,0.00,0.00,0.00,0.00,729647),('1','152','257528','316',533.00,640.00,0.00,2607.45,1389770.85,1662837.40,273066.55,729648),('1','152','257529','316',533.00,640.00,0.00,2879.12,1534570.96,1831644.80,297073.84,729649),('1','152','257530','316',533.00,640.00,0.00,3455.29,1841669.57,2198975.60,357306.03,729650),('1','152','257531','316',533.00,640.00,0.00,3475.71,1852553.43,2217884.80,365331.37,729651),('1','152','257532','316',533.00,640.00,0.00,3714.74,1979956.42,2357134.60,377178.18,729652),('1','152','257533','316',533.00,680.00,0.00,3306.98,1762620.34,2231321.60,468701.26,729653),('1','152','257534','316',533.00,680.00,0.00,3013.15,1606008.95,2035674.40,429665.45,729654),('1','152','257535','316',533.00,680.00,0.00,1564.95,834118.35,1058850.40,224732.05,729655),('1','152','257536','316',533.00,680.00,0.00,0.00,0.00,0.00,0.00,729656),('1','152','257537','316',612.00,680.00,0.00,1108.47,678383.64,753132.00,74748.36,729657),('1','152','257538','316',612.00,680.00,0.00,3118.96,1908803.52,1989138.40,80334.88,729658),('1','152','257539','316',612.00,640.00,0.00,3920.65,2399437.80,2498530.00,99092.20,729659),('1','152','257540','316',612.00,640.00,0.00,3529.85,2160268.20,2248805.84,88537.64,729660),('1','152','257541','316',612.00,640.00,0.00,2996.14,1833637.68,1910515.60,76877.92,729661),('1','152','257542','316',612.00,640.00,0.00,3078.12,1883809.44,1959222.48,75413.04,729662),('1','152','257543','316',612.00,640.00,0.00,3368.02,2061228.24,2138157.28,76929.04,729663),('1','152','257544','316',612.00,640.00,0.00,3108.68,1902512.16,1979853.92,77341.76,729664),('1','152','257545','316',612.00,640.00,0.00,718.11,439483.32,459590.40,20107.08,729665),('1','152','257546','316',602.00,640.00,0.00,2562.34,1542528.68,1619226.88,76698.20,729666),('1','152','257547','316',602.00,640.00,0.00,3543.45,2133156.90,2255043.36,121886.46,729667),('1','152','257548','316',602.00,680.00,0.00,3619.09,2178692.18,2452002.18,273310.00,729668),('1','152','257549','316',602.00,680.00,0.00,3191.59,1921337.18,2158944.66,237607.48,729669),('1','152','257550','316',602.00,680.00,0.00,3241.03,1951100.06,2200486.10,249386.04,729670),('1','152','257551','316',602.00,680.00,0.00,4453.54,2681031.08,2998764.92,317733.84,729671),('1','152','257552','316',602.00,680.00,0.00,3959.04,2383342.08,2518005.20,134663.12,729672),('1','152','257553','316',602.00,640.00,0.00,0.00,0.00,0.00,0.00,729673),('1','152','257554','316',612.00,640.00,0.00,1433.04,877020.48,913859.60,36839.12,729674),('1','152','257555','316',612.00,640.00,0.00,7126.45,4361387.40,4548812.00,187424.60,729675),('1','152','257556','316',612.00,640.00,0.00,8133.56,4977738.72,5170005.40,192266.68,729676),('1','152','257557','316',612.00,640.00,0.00,7337.59,4490605.08,4633015.20,142410.12,729677),('1','152','257558','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,729678),('1','152','257559','316',612.00,640.00,0.00,916.91,561148.92,584092.40,22943.48,729679),('1','152','257560','316',612.00,640.00,0.00,5475.45,3350975.40,3482407.60,131432.20,729680),('1','152','257561','316',612.00,640.00,0.00,4036.45,2470307.40,2568456.40,98149.00,729681),('1','152','257562','316',612.00,640.00,0.00,3746.92,2293115.04,2380209.80,87094.76,729682),('1','152','257563','316',612.00,640.00,0.00,1730.52,1059078.24,1097879.80,38801.56,729683),('1','152','257564','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,729684),('1','152','257565','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,729685),('1','152','257566','316',612.00,640.00,0.00,2021.21,1236980.52,1282861.40,45880.88,729686),('1','152','257567','316',612.00,640.00,0.00,4871.71,2981486.52,3079501.40,98014.88,729687),('1','152','257568','316',612.00,640.00,0.00,3734.70,2285636.40,2373367.40,87731.00,729688),('1','152','257569','316',612.00,640.00,0.00,4035.99,2470025.88,2559369.00,89343.12,729689),('1','152','257570','316',612.00,640.00,0.00,2900.65,1775197.80,1846216.00,71018.20,729690),('1','152','257571','316',612.00,640.00,0.00,3152.64,1929415.68,1999291.80,69876.12,729691),('1','152','257572','316',612.00,640.00,0.00,2918.07,1785858.84,1855175.60,69316.76,729692),('1','152','257573','316',612.00,640.00,0.00,1036.23,634172.76,655187.20,21014.44,729693),('1','152','257574','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,729694),('1','152','257575','316',612.00,640.00,0.00,2970.67,1818050.04,1878905.20,60855.16,729695),('1','152','257576','316',612.00,640.00,0.00,3487.00,2134044.00,2222552.40,88508.40,729696),('1','152','257577','316',612.00,640.00,0.00,2100.82,1285701.84,1333141.80,47439.96,729697),('1','152','257578','316',612.00,640.00,0.00,0.00,0.00,0.00,0.00,729698),('1','152','257579','316',612.00,640.00,0.00,1963.56,1201698.72,1247453.20,45754.48,729699),('1','152','257580','316',612.00,640.00,0.00,3641.03,2228310.36,2307033.40,78723.04,729700),('1','152','257581','316',612.00,640.00,0.00,724.87,443620.44,450916.80,7296.36,729701),('1','152','257582','316',612.00,636.00,0.00,2594.08,1587576.96,1638103.60,50526.64,729702),('1','152','257583','316',612.00,636.00,0.00,3523.86,2156602.32,2222018.24,65415.92,729703),('1','152','257584','316',612.00,636.00,0.00,2862.90,1752094.80,1817988.84,65894.04,729704),('1','152','257585','316',612.00,636.00,0.00,2634.74,1612460.88,1673112.50,60651.62,729705),('1','152','257586','316',612.00,636.00,0.00,1630.05,997590.60,1031810.20,34219.60,729706),('1','152','257587','316',602.00,636.00,0.00,1104.77,665071.54,698925.62,33854.08,729707),('1','152','257588','316',602.00,636.00,0.00,3325.25,2001800.50,2101481.24,99680.74,729708),('1','152','257589','316',602.00,636.00,0.00,3711.09,2234076.18,2338793.78,104717.60,729709),('1','152','257590','316',602.00,636.00,0.00,3344.55,2013419.10,2104031.60,90612.50,729710),('1','152','257591','316',602.00,636.00,0.00,3116.48,1876120.96,1968387.38,92266.42,729711),('1','152','257592','316',602.00,636.00,0.00,3639.66,2191075.32,2295447.26,104371.94,729712),('1','152','257593','316',602.00,636.00,0.00,3429.00,2064258.00,2167952.88,103694.88,729713),('1','152','257594','316',602.00,636.00,0.00,2763.14,1663410.28,1742154.60,78744.32,729714),('1','152','257595','316',602.00,636.00,0.00,0.00,0.00,0.00,0.00,729715),('1','152','257596','316',602.00,636.00,0.00,899.10,541258.20,569008.30,27750.10,729716),('1','152','257597','316',602.00,636.00,0.00,4528.43,2726114.86,2865198.48,139083.62,729717),('1','152','257598','316',602.00,636.00,0.00,5040.19,3034194.38,3193215.98,159021.60,729718),('1','152','257599','316',602.00,636.00,0.00,2839.27,1709240.54,1783484.88,74244.34,729719),('1','152','257600','316',602.00,636.00,0.00,3644.89,2194223.78,2288736.04,94512.26,729720),('1','152','257601','316',602.00,636.00,0.00,2871.43,1728600.86,1807944.40,79343.54,729721),('1','152','257602','316',602.00,636.00,0.00,4413.80,2657107.60,2775070.44,117962.84,729722),('1','152','257603','316',602.00,636.00,0.00,380.18,228868.36,241631.46,12763.10,729723),('1','152','257604','316',602.00,636.00,0.00,0.00,0.00,0.00,0.00,729724),('1','152','257605','316',602.00,636.00,0.00,3641.89,2192417.78,2291420.98,99003.20,729725),('1','152','257606','316',602.00,636.00,0.00,4243.36,2554502.72,2682382.12,127879.40,729726),('1','152','257607','316',602.00,636.00,0.00,4308.46,2593692.92,2725259.28,131566.36,729727),('1','152','257608','316',602.00,636.00,0.00,3181.47,1915244.94,2016370.74,101125.80,729728),('1','152','257609','316',602.00,636.00,0.00,4764.91,2868475.82,2996580.10,128104.28,729729),('1','152','257610','316',602.00,636.00,0.00,3533.42,2127118.84,2237981.68,110862.84,729730),('1','152','257611','316',602.00,636.00,0.00,732.44,440928.88,464212.42,23283.54,729731),('1','152','257612','316',602.00,636.00,0.00,0.00,0.00,0.00,0.00,729732),('1','152','257613','316',602.00,636.00,0.00,2562.84,1542829.68,1622114.66,79284.98,729733),('1','152','257614','316',602.00,636.00,0.00,3078.32,1853148.64,1950782.52,97633.88,729734),('1','152','257615','316',602.00,636.00,0.00,3076.50,1852053.00,1951091.08,99038.08,729735),('1','152','257616','316',602.00,636.00,0.00,4213.07,2536268.14,2878607.48,342339.34,729736),('1','152','257617','316',602.00,696.00,0.00,2724.60,1640209.20,1892773.00,252563.80,729737),('1','152','257618','316',602.00,696.00,0.00,2499.70,1504819.40,1736029.20,231209.80,729738),('1','152','257619','316',602.00,696.00,0.00,2599.31,1564784.62,1789203.60,224418.98,729739),('1','152','257620','316',602.00,696.00,0.00,2558.37,1540138.74,1769713.52,229574.78,729740),('1','152','257621','316',602.00,696.00,0.00,1185.03,713388.06,818572.48,105184.42,729741),('1','152','257622','316',602.00,696.00,0.00,0.00,0.00,0.00,0.00,729742),('1','152','257623','316',622.00,696.00,0.00,1332.95,829094.90,922491.92,93397.02,729743),('1','152','257624','316',622.00,696.00,0.00,1257.83,782370.26,839704.80,57334.54,729744),('1','152','257625','316',622.00,680.00,0.00,2126.69,1322801.18,1444788.00,121986.82,729745),('1','152','257626','316',622.00,680.00,0.00,3149.26,1958839.72,2140044.40,181204.68,729746),('1','152','257627','316',622.00,680.00,0.00,336.99,209607.78,229153.20,19545.42,729747),('1','152','257628','316',622.00,680.00,0.00,0.00,0.00,0.00,0.00,729748),('1','152','257629','316',622.00,680.00,0.00,2024.13,1259008.86,1373246.40,114237.54,729749),('1','152','257630','316',622.00,680.00,0.00,3228.89,2008369.58,2166082.00,157712.42,729750),('1','152','257631','316',622.00,740.00,0.00,2283.70,1420461.40,1688787.40,268326.00,729751),('1','152','257632','316',622.00,740.00,0.00,2209.88,1374545.36,1633478.16,258932.80,729752),('1','152','257633','316',622.00,740.00,0.00,2621.17,1630367.74,1932832.60,302464.86,729753),('1','152','257634','316',622.00,740.00,0.00,2806.69,1745761.18,2076169.16,330407.98,729754),('1','152','257635','316',622.00,700.00,0.00,3447.67,2144450.74,2412532.76,268082.02,729755),('1','152','257636','316',622.00,700.00,0.00,3259.45,2027377.90,2280959.24,253581.34,729756),('1','152','257637','316',622.00,680.00,0.00,2356.67,1465848.74,1599560.74,133712.00,729757),('1','152','257638','316',622.00,680.00,0.00,0.00,0.00,0.00,0.00,729758),('1','152','257639','316',622.00,680.00,0.00,918.71,608186.02,624722.80,16536.78,729759),('1','152','257640','316',662.00,680.00,0.00,3111.84,2060038.08,2115203.94,55165.86,729760),('1','152','257641','316',662.00,680.00,0.00,3514.15,2326367.30,2377121.90,50754.60,729761),('1','152','257642','316',662.00,680.00,0.00,3519.20,2329710.40,2382588.64,52878.24,729762),('1','152','257643','316',662.00,680.00,0.00,3556.90,2354667.80,2416916.66,62248.86,729763),('1','152','257644','316',662.00,680.00,0.00,5060.02,3349733.24,3420546.68,70813.44,729764),('1','152','257645','316',662.00,680.00,0.00,3233.71,2140716.02,2193162.98,52446.96,729765),('1','152','257646','316',662.00,680.00,0.00,1661.81,1100118.22,1116800.80,16682.58,729766),('1','152','257647','316',662.00,680.00,0.00,0.00,0.00,0.00,0.00,729767),('1','152','257648','316',682.00,680.00,0.00,2625.55,1790625.10,1779975.62,-10649.48,729768),('1','152','257649','316',682.00,680.00,0.00,2933.20,2000442.40,1992903.62,-7538.78,729769),('1','152','257650','316',682.00,680.00,0.00,3178.04,2167423.28,2150458.00,-16965.28,729770),('1','152','257651','316',682.00,750.00,0.00,2556.68,1743655.76,1907710.00,164054.24,729771),('1','152','257652','316',682.00,750.00,0.00,2603.02,1775259.64,1947865.00,172605.36,729772),('1','152','257653','316',682.00,750.00,0.00,3244.18,2212530.76,2433674.20,221143.44,729773),('1','152','257654','316',682.00,750.00,0.00,2788.59,1901818.38,2087890.10,186071.72,729774),('1','152','257655','316',682.00,750.00,0.00,2338.55,1594891.10,1751712.50,156821.40,729775),('1','152','257656','316',682.00,750.00,0.00,1976.66,1348082.12,1481587.80,133505.68,729776),('1','152','257657','316',682.00,750.00,0.00,0.00,0.00,0.00,0.00,729777),('1','152','257658','316',682.00,750.00,0.00,1022.91,707853.72,761800.90,53947.18,729778),('1','152','257659','316',692.00,750.00,0.00,3162.66,2188560.72,2369797.40,181236.68,729779),('1','152','257660','316',692.00,750.00,0.00,2324.03,1608228.76,1742716.90,134488.14,729780),('1','152','257661','316',692.00,750.00,0.00,2905.39,2010529.88,2179812.50,169282.62,729781),('1','152','257662','316',692.00,750.00,0.00,3595.47,2488065.24,2659298.10,171232.86,729782),('1','152','257663','316',692.00,750.00,0.00,2205.35,1526102.20,1647692.50,121590.30,729783),('1','152','257664','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729784),('1','152','257665','316',692.00,750.00,0.00,2608.93,1805379.56,1953454.30,148074.74,729785),('1','152','257666','316',692.00,750.00,0.00,2553.21,1766821.32,1910456.70,143635.38,729786),('1','152','257667','316',692.00,750.00,0.00,2452.93,1697427.56,1836995.10,139567.54,729787),('1','152','257668','316',692.00,750.00,0.00,2226.87,1540994.04,1670152.50,129158.46,729788),('1','152','257669','316',692.00,750.00,0.00,2583.94,1788086.48,1935281.80,147195.32,729789),('1','152','257670','316',692.00,750.00,0.00,3659.41,2532311.72,2735506.70,203194.98,729790),('1','152','257671','316',692.00,750.00,0.00,2812.30,1946111.60,2106205.00,160093.40,729791),('1','152','257672','316',692.00,750.00,0.00,2752.45,1904695.40,2059937.50,155242.10,729792),('1','152','257673','316',692.00,750.00,0.00,2773.37,1919172.04,2075229.90,156057.86,729793),('1','152','257674','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729794),('1','152','257675','316',692.00,750.00,0.00,2717.30,1880371.60,2035335.00,154963.40,729795),('1','152','257676','316',692.00,750.00,0.00,3740.63,2588515.96,2800872.50,212356.54,729796),('1','152','257677','316',692.00,750.00,0.00,3525.57,2439694.44,2641897.50,202203.06,729797),('1','152','257678','316',692.00,750.00,0.00,4384.35,3033970.20,3282262.50,248292.30,729798),('1','152','257679','316',692.00,750.00,0.00,3064.20,2120426.40,2298150.00,177723.60,729799),('1','152','257680','316',692.00,750.00,0.00,3032.65,2098593.80,2274487.50,175893.70,729800),('1','152','257681','316',692.00,750.00,0.00,3845.16,2660850.72,2876961.60,216110.88,729801),('1','152','257682','316',692.00,750.00,0.00,196.69,136109.48,147517.50,11408.02,729802),('1','152','257683','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729803),('1','152','257684','316',692.00,750.00,0.00,4350.17,3010317.64,3262627.50,252309.86,729804),('1','152','257685','316',692.00,750.00,0.00,5620.29,3889240.68,4191529.50,302288.82,729805),('1','152','257686','316',692.00,750.00,0.00,2689.60,1861203.20,2003200.00,141996.80,729806),('1','152','257687','316',692.00,750.00,0.00,2696.09,1865694.28,2016347.50,150653.22,729807),('1','152','257688','316',692.00,750.00,0.00,1892.26,1309443.92,1416915.00,107471.08,729808),('1','152','257689','316',692.00,750.00,0.00,2216.41,1533755.72,1662307.50,128551.78,729809),('1','152','257690','316',692.00,750.00,0.00,2417.93,1673207.56,1807047.50,133839.94,729810),('1','152','257691','316',692.00,750.00,0.00,2428.13,1680265.96,1821097.50,140831.54,729811),('1','152','257692','316',692.00,750.00,0.00,728.58,504177.36,546435.00,42257.64,729812),('1','152','257693','316',692.00,750.00,0.00,1424.04,985435.68,1064649.60,79213.92,729813),('1','152','257694','316',692.00,750.00,0.00,3022.10,2091293.20,2263951.00,172657.80,729814),('1','152','257695','316',692.00,750.00,0.00,3188.24,2206262.08,2373191.60,166929.52,729815),('1','152','257696','316',692.00,750.00,0.00,3321.61,2298554.12,2483371.50,184817.38,729816),('1','152','257697','316',692.00,750.00,0.00,2727.24,1887250.08,2040105.60,152855.52,729817),('1','152','257698','316',692.00,750.00,0.00,2831.49,1959391.08,2117553.90,158162.82,729818),('1','152','257699','316',692.00,750.00,0.00,2881.35,1993894.20,2149456.10,155561.90,729819),('1','152','257700','316',692.00,750.00,0.00,2543.99,1760441.08,1897260.10,136819.02,729820),('1','152','257701','316',692.00,750.00,0.00,2722.89,1884239.88,2039967.50,155727.62,729821),('1','152','257702','316',692.00,750.00,0.00,23.00,15916.00,17250.00,1334.00,729822),('1','152','257703','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729823),('1','152','257704','316',692.00,750.00,0.00,4150.75,2872319.00,3062637.30,190318.30,729824),('1','152','257705','316',692.00,750.00,0.00,2248.85,1556204.20,1681006.70,124802.50,729825),('1','152','257706','316',692.00,750.00,0.00,2620.95,1813697.40,1965712.50,152015.10,729826),('1','152','257707','316',692.00,750.00,0.00,2321.64,1606574.88,1739630.00,133055.12,729827),('1','152','257708','316',692.00,750.00,0.00,2835.22,1961972.24,2125551.40,163579.16,729828),('1','152','257709','316',692.00,750.00,0.00,2663.26,1842975.92,1996899.40,153923.48,729829),('1','152','257710','316',692.00,750.00,0.00,2559.33,1771056.36,1915970.70,144914.34,729830),('1','152','257711','316',692.00,750.00,0.00,591.39,409241.88,439542.50,30300.62,729831),('1','152','257712','316',692.00,750.00,0.00,3577.71,2475775.32,2680962.90,205187.58,729832),('1','152','257713','316',692.00,750.00,0.00,3278.21,2268521.32,2455673.50,187152.18,729833),('1','152','257714','316',692.00,750.00,0.00,3332.71,2306235.32,2499032.50,192797.18,729834),('1','152','257715','316',692.00,750.00,0.00,3637.05,2516838.60,2723061.90,206223.30,729835),('1','152','257716','316',692.00,750.00,0.00,4849.81,3356068.52,3606922.70,250854.18,729836),('1','152','257717','316',692.00,750.00,0.00,3845.27,2660926.84,2870676.10,209749.26,729837),('1','152','257718','316',692.00,750.00,0.00,1325.92,917536.64,982160.00,64623.36,729838),('1','152','257719','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729839),('1','152','257720','316',692.00,750.00,0.00,1990.98,1377758.16,1484915.00,107156.84,729840),('1','152','257721','316',692.00,750.00,0.00,3812.21,2638049.32,2843877.50,205828.18,729841),('1','152','257722','316',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729842),('1','152','257723','316',685.00,750.00,0.00,3267.54,2238264.90,2449755.00,211490.10,729843),('1','152','257724','316',685.00,750.00,0.00,2587.15,1772197.75,1914482.50,142284.75,729844),('1','152','257725','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729845),('1','152','257726','316',685.00,750.00,0.00,648.76,444400.60,490460.00,46059.40,729846),('1','152','257727','316',685.00,750.00,0.00,3320.94,2274843.90,2483999.80,209155.90,729847),('1','152','257728','316',685.00,750.00,0.00,1883.27,1290039.95,1404452.50,114412.55,729848),('1','152','257729','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729849),('1','152','257730','316',685.00,750.00,0.00,786.55,538786.75,589912.50,51125.75,729850),('1','152','257731','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729851),('1','152','257732','316',685.00,750.00,0.00,2889.44,1979266.40,2156458.40,177192.00,729852),('1','152','257733','316',685.00,750.00,0.00,2253.66,1543757.10,1659136.20,115379.10,729853),('1','152','257734','316',685.00,750.00,0.00,1130.86,774639.10,846145.00,71505.90,729854),('1','152','257735','316',685.00,750.00,0.00,3889.70,2664444.50,2893643.00,229198.50,729855),('1','152','257736','316',685.00,750.00,0.00,2045.58,1401222.30,1527591.80,126369.50,729856),('1','152','257737','316',685.00,750.00,0.00,1252.44,857921.40,935330.00,77408.60,729857),('1','152','257738','316',685.00,750.00,0.00,3001.97,2056349.45,2240631.10,184281.65,729858),('1','152','257739','316',685.00,750.00,0.00,1672.90,1145936.50,1245968.20,100031.70,729859),('1','152','257740','316',685.00,750.00,0.00,1334.22,913940.70,997925.00,83984.30,729860),('1','152','257741','316',685.00,750.00,0.00,2983.18,2043478.30,2228905.00,185426.70,729861),('1','152','257742','316',685.00,750.00,0.00,1571.68,1076600.80,1168820.00,92219.20,729862),('1','152','257743','316',685.00,750.00,0.00,1366.42,935997.70,1023737.40,87739.70,729863),('1','152','257744','316',685.00,750.00,0.00,746.67,511468.95,560002.50,48533.55,729864),('1','152','257745','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729865),('1','152','257746','316',685.00,750.00,0.00,2667.70,1827374.50,1989217.40,161842.90,729866),('1','152','257747','316',685.00,750.00,0.00,668.98,458251.30,500015.00,41763.70,729867),('1','152','257748','316',685.00,750.00,0.00,2276.52,1559416.20,1706813.60,147397.40,729868),('1','152','257749','316',685.00,750.00,0.00,3055.71,2093161.35,2268689.70,175528.35,729869),('1','152','257750','316',685.00,750.00,0.00,2657.24,1820209.40,1989038.00,168828.60,729870),('1','152','257751','316',685.00,750.00,0.00,2634.86,1804879.10,1971649.00,166769.90,729871),('1','152','257752','316',685.00,750.00,0.00,2843.59,1947859.15,2132692.50,184833.35,729872),('1','152','257753','316',685.00,750.00,0.00,2674.78,1832224.30,2006085.00,173860.70,729873),('1','152','257754','316',685.00,750.00,0.00,2957.24,2025709.40,2217850.00,192140.60,729874),('1','152','257755','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729875),('1','152','257756','316',685.00,750.00,0.00,3348.36,2293626.60,2511270.00,217643.40,729876),('1','152','257757','316',685.00,750.00,0.00,2555.24,1750339.40,1916430.00,166090.60,729877),('1','152','257758','316',685.00,750.00,0.00,3448.70,2362359.50,2586525.00,224165.50,729878),('1','152','257759','316',685.00,750.00,0.00,3038.64,2081468.40,2274980.00,193511.60,729879),('1','152','257760','316',685.00,750.00,0.00,3786.37,2593663.45,2839777.50,246114.05,729880),('1','152','257761','316',685.00,750.00,0.00,3507.02,2402308.70,2622665.40,220356.70,729881),('1','152','257762','316',685.00,750.00,0.00,4021.95,2755035.75,3009662.50,254626.75,729882),('1','152','257763','316',685.00,750.00,0.00,1484.16,1016649.60,1110720.00,94070.40,729883),('1','152','257764','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729884),('1','152','257765','316',685.00,750.00,0.00,2897.96,1985102.60,2173470.00,188367.40,729885),('1','152','257766','316',685.00,750.00,0.00,3374.70,2311669.50,2531025.00,219355.50,729886),('1','152','257767','316',685.00,750.00,0.00,1402.04,960397.40,1051530.00,91132.60,729887),('1','152','257768','316',685.00,750.00,0.00,1906.92,1306240.20,1420990.00,114749.80,729888),('1','152','257769','316',685.00,750.00,0.00,3635.80,2490523.00,2721450.00,230927.00,729889),('1','152','257770','316',685.00,750.00,0.00,213.83,146473.55,160372.50,13898.95,729890),('1','152','257771','316',685.00,750.00,0.00,2168.48,1485408.80,1626360.00,140951.20,729891),('1','152','257772','316',685.00,750.00,0.00,2978.42,2040217.70,2233815.00,193597.30,729892),('1','152','257773','316',685.00,750.00,0.00,661.70,453264.50,496275.00,43010.50,729893),('1','152','257774','316',685.00,750.00,0.00,2539.80,1739763.00,1904850.00,165087.00,729894),('1','152','257775','316',685.00,750.00,0.00,569.35,390004.75,427012.50,37007.75,729895),('1','152','257776','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729896),('1','152','257777','316',685.00,750.00,0.00,2758.33,1889456.05,2068747.50,179291.45,729897),('1','152','257778','316',685.00,750.00,0.00,2728.48,1869008.80,2046360.00,177351.20,729898),('1','152','257779','316',685.00,750.00,0.00,396.80,271808.00,297600.00,25792.00,729899),('1','152','257780','316',685.00,750.00,0.00,2642.74,1810276.90,1982055.00,171778.10,729900),('1','152','257781','316',685.00,750.00,0.00,254.24,174154.40,190680.00,16525.60,729901),('1','152','257782','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729902),('1','152','257783','316',685.00,750.00,0.00,33.43,22899.55,25072.50,2172.95,729903),('1','152','257784','316',685.00,750.00,0.00,1368.13,937169.05,1026097.50,88928.45,729904),('1','152','257785','316',685.00,750.00,0.00,2476.56,1696443.60,1857420.00,160976.40,729905),('1','152','257786','316',685.00,750.00,0.00,1961.34,1343517.90,1471005.00,127487.10,729906),('1','152','257787','316',685.00,750.00,0.00,697.01,477451.85,522757.50,45305.65,729907),('1','152','257788','316',685.00,750.00,0.00,1271.33,870861.05,953497.50,82636.45,729908),('1','152','257789','316',685.00,750.00,0.00,2962.54,2029339.90,2221905.00,192565.10,729909),('1','152','257790','316',685.00,750.00,0.00,464.13,317929.05,348097.50,30168.45,729910),('1','152','257791','316',685.00,750.00,0.00,2318.81,1588384.85,1739107.50,150722.65,729911),('1','152','257792','316',685.00,750.00,0.00,2524.08,1728994.80,1893060.00,164065.20,729912),('1','152','257793','316',685.00,750.00,0.00,1047.29,717393.65,785467.50,68073.85,729913),('1','152','257794','316',685.00,750.00,0.00,1393.18,954328.30,1044885.00,90556.70,729914),('1','152','257795','316',685.00,750.00,0.00,221.02,151398.70,165765.00,14366.30,729915),('1','152','257796','316',685.00,750.00,0.00,1980.26,1356478.10,1485195.00,128716.90,729916),('1','152','257797','316',685.00,750.00,0.00,2712.19,1857850.15,2034142.50,176292.35,729917),('1','152','257798','316',685.00,750.00,0.00,1159.48,794243.80,869610.00,75366.20,729918),('1','152','257799','316',685.00,750.00,0.00,2205.36,1510671.60,1654020.00,143348.40,729919),('1','152','257800','316',685.00,750.00,0.00,2656.67,1819818.95,1992502.50,172683.55,729920),('1','152','257801','316',685.00,750.00,0.00,953.29,653003.65,714967.50,61963.85,729921),('1','152','257802','316',685.00,750.00,0.00,1946.37,1333263.45,1459777.50,126514.05,729922),('1','152','257803','316',685.00,750.00,0.00,1305.69,894397.65,979267.50,84869.85,729923),('1','152','257804','316',685.00,750.00,0.00,1358.12,930312.20,1018590.00,88277.80,729924),('1','152','257805','316',685.00,750.00,0.00,2651.99,1816613.15,1989492.50,172879.35,729925),('1','152','257806','316',685.00,750.00,0.00,4151.35,2843674.75,3101512.50,257837.75,729926),('1','152','257807','316',685.00,750.00,0.00,3810.98,2610521.30,2858235.00,247713.70,729927),('1','152','257808','316',685.00,750.00,0.00,3657.71,2505531.35,2740722.50,235191.15,729928),('1','152','257809','316',685.00,750.00,0.00,3554.87,2435085.95,2654352.50,219266.55,729929),('1','152','257810','316',685.00,750.00,0.00,3798.77,2602157.45,2816837.50,214680.05,729930),('1','152','257811','316',685.00,750.00,0.00,1623.94,1112398.90,1213955.00,101556.10,729931),('1','152','257812','316',685.00,750.00,0.00,0.00,0.00,0.00,0.00,729932),('1','152','257813','316',685.00,750.00,0.00,1105.07,756972.95,828802.50,71829.55,729933),('1','152','257814','316',685.00,750.00,0.00,3655.84,2504250.40,2741880.00,237629.60,729934),('1','152','257815','316',685.00,750.00,0.00,965.04,661052.40,723780.00,62727.60,729935),('1','152','257816','316',685.00,750.00,0.00,2437.11,1669420.35,1811832.50,142412.15,729936),('1','152','257817','316',685.00,750.00,0.00,365.12,250107.20,273840.00,23732.80,729937),('1','152','257818','316',685.00,750.00,0.00,2764.91,1893963.35,2073682.50,179719.15,729938),('1','152','257819','316',685.00,750.00,0.00,3241.88,2220687.80,2409030.00,188342.20,729939),('1','152','257820','316',685.00,750.00,0.00,1217.04,833672.40,912780.00,79107.60,729940),('1','152','257821','316',685.00,750.00,0.00,3343.00,2289955.00,2503210.00,213255.00,729941),('1','152','257822','316',685.00,750.00,0.00,1211.66,829987.10,908745.00,78757.90,729942),('1','152','257823','316',677.00,750.00,0.00,2163.94,1464987.38,1612795.00,147807.62,729943),('1','152','257824','316',677.00,750.00,0.00,3180.52,2153212.04,2367390.00,214177.96,729944),('1','152','257825','316',677.00,750.00,0.00,540.82,366135.14,395615.00,29479.86,729945),('1','152','257826','316',677.00,750.00,0.00,3588.99,2429746.23,2656280.90,226534.67,729946),('1','152','257827','316',677.00,750.00,0.00,80.28,54349.56,60210.00,5860.44,729947),('1','152','257828','316',677.00,750.00,0.00,3084.66,2088314.82,2304215.00,215900.18,729948),('1','152','257829','316',677.00,750.00,0.00,2699.88,1827818.76,2026410.00,198591.24,729949),('1','152','257830','316',677.00,750.00,0.00,610.72,413457.44,458040.00,44582.56,729950),('1','152','257831','316',677.00,750.00,0.00,1997.53,1352327.81,1498147.50,145819.69,729951),('1','152','257832','316',677.00,750.00,0.00,0.00,0.00,0.00,0.00,729952),('1','152','257833','316',677.00,750.00,0.00,3329.83,2254294.91,2498872.50,244577.59,729953),('1','152','257834','316',677.00,750.00,0.00,2443.59,1654310.43,1832692.50,178382.07,729954),('1','152','257835','316',677.00,750.00,0.00,196.93,133321.61,147697.50,14375.89,729955),('1','152','257836','316',677.00,750.00,0.00,1230.31,832919.87,922732.50,89812.63,729956),('1','152','257837','316',677.00,750.00,0.00,1599.18,1082644.86,1199385.00,116740.14,729957),('1','152','257838','316',677.00,750.00,0.00,3971.70,2688840.90,2978775.00,289934.10,729958),('1','152','257839','316',677.00,750.00,0.00,231.00,156387.00,173250.00,16863.00,729959),('1','152','257840','316',677.00,750.00,0.00,2327.05,1575412.85,1745287.50,169874.65,729960),('1','152','257841','316',677.00,750.00,0.00,3030.14,2051404.78,2272605.00,221200.22,729961),('1','152','257842','316',677.00,750.00,0.00,375.01,253881.77,281257.50,27375.73,729962),('1','152','257843','316',677.00,750.00,0.00,1784.74,1208268.98,1338555.00,130286.02,729963),('1','152','257844','316',677.00,750.00,0.00,1375.84,931443.68,1073155.20,141711.52,729964),('1','152','257845','316',685.00,780.00,0.00,1397.99,957623.15,1090432.20,132809.05,729965),('1','152','257846','316',685.00,780.00,0.00,2633.47,1803926.95,2054106.60,250179.65,729966),('1','152','257847','316',685.00,780.00,0.00,3544.26,2427818.10,2764522.80,336704.70,729967),('1','152','257848','316',685.00,780.00,0.00,2334.81,1599344.85,1821151.80,221806.95,729968),('1','152','257849','316',685.00,780.00,0.00,865.59,592929.15,675160.20,82231.05,729969),('1','152','257850','316',685.00,780.00,0.00,3058.43,2095024.55,2381095.40,286070.85,729970),('1','152','257851','316',685.00,780.00,0.00,1145.12,784407.20,893193.60,108786.40,729971),('1','152','257852','316',685.00,780.00,0.00,4863.05,3331189.25,3793179.00,461989.75,729972),('1','152','257853','316',685.00,780.00,0.00,1007.16,689904.60,785584.80,95680.20,729973),('1','152','257854','316',685.00,780.00,0.00,2808.26,1923658.10,2190442.80,266784.70,729974),('1','152','257855','316',685.00,780.00,0.00,3099.26,2122993.10,2417422.80,294429.70,729975),('1','152','257856','316',685.00,780.00,0.00,259.80,177963.00,202644.00,24681.00,729976),('1','152','257857','316',685.00,780.00,0.00,3193.79,2187746.15,2491156.20,303410.05,729977),('1','152','257858','316',685.00,780.00,0.00,2298.39,1574397.15,1788744.20,214347.05,729978),('1','152','257859','316',685.00,780.00,0.00,266.04,182237.40,207511.20,25273.80,729979),('1','152','257860','316',685.00,780.00,0.00,2576.57,1764950.45,2009724.60,244774.15,729980),('1','152','257861','316',685.00,780.00,0.00,2701.70,1850664.50,2107326.00,256661.50,729981),('1','152','257862','316',685.00,780.00,0.00,2457.13,1683134.05,1916561.40,233427.35,729982),('1','152','257863','316',685.00,780.00,0.00,615.23,421432.55,479879.40,58446.85,729983),('1','152','257864','316',685.00,780.00,0.00,640.64,438838.40,499699.20,60860.80,729984),('1','152','257865','316',685.00,780.00,0.00,1380.14,945395.90,1076509.20,131113.30,729985),('1','152','257866','316',685.00,780.00,0.00,2495.43,1709369.55,1946435.40,237065.85,729986),('1','152','257867','316',685.00,780.00,0.00,1889.88,1294567.80,1474106.40,179538.60,729987),('1','152','257868','316',685.00,780.00,0.00,809.34,554397.90,631285.20,76887.30,729988),('1','152','257869','316',685.00,780.00,0.00,2139.11,1465290.35,1668505.80,203215.45,729989),('1','152','257870','316',685.00,780.00,0.00,2273.09,1557066.65,1773010.20,215943.55,729990),('1','152','257871','316',685.00,780.00,0.00,599.74,410821.90,467797.20,56975.30,729991),('1','152','257872','316',685.00,780.00,0.00,1695.50,1161417.50,1318894.80,157477.30,729992),('1','152','257873','316',685.00,780.00,0.00,2725.19,1866755.15,2125648.20,258893.05,729993),('1','152','257874','316',685.00,780.00,0.00,1502.03,1028890.55,1163583.40,134692.85,729994),('1','152','257875','316',685.00,780.00,0.00,1882.84,1289745.40,1455262.40,165517.00,729995),('1','152','257876','316',685.00,780.00,0.00,2782.25,1905841.25,2157883.00,252041.75,729996),('1','152','257877','316',685.00,780.00,0.00,1033.48,707933.80,802514.40,94580.60,729997),('1','152','257878','316',685.00,780.00,0.00,1345.20,921462.00,1046656.00,125194.00,729998),('1','152','257879','316',685.00,780.00,0.00,345.11,236400.35,266865.80,30465.45,729999),('1','152','257880','316',685.00,780.00,0.00,1825.66,1250577.10,1419813.60,169236.50,730000),('1','152','257881','316',685.00,780.00,0.00,3009.99,2061843.15,2335231.00,273387.85,730001),('1','152','257882','316',685.00,780.00,0.00,2737.91,1875468.35,2126210.60,250742.25,730002),('1','152','257883','316',685.00,780.00,0.00,2621.62,1795809.70,2039409.60,243599.90,730003),('1','152','257884','316',685.00,780.00,0.00,3482.07,2385217.95,2705577.80,320359.85,730004),('1','152','257885','316',685.00,780.00,0.00,3039.75,2082228.75,2243731.06,161502.31,730005),('1','152','257886','316',685.00,736.00,0.00,4091.85,2802917.25,2998852.24,195934.99,730006),('1','152','257887','316',685.00,736.00,0.00,4126.49,2826645.65,3008377.56,181731.91,730007),('1','152','257888','316',685.00,736.00,0.00,0.00,0.00,0.00,0.00,730008),('1','152','257889','316',685.00,736.00,0.00,3919.46,2684830.10,2875090.86,190260.76,730009),('1','152','257890','316',685.00,736.00,0.00,4031.85,2761817.25,2951859.80,190042.55,730010),('1','152','257891','316',685.00,736.00,0.00,4372.49,2995155.65,3210138.14,214982.49,730011),('1','152','257892','316',685.00,736.00,0.00,4527.86,3101584.10,3313345.56,211761.46,730012),('1','152','257893','316',685.00,736.00,0.00,4428.89,3033789.65,3203411.26,169621.61,730013),('1','152','257894','316',685.00,736.00,0.00,3067.41,2101175.85,2244405.76,143229.91,730014),('1','152','257895','316',685.00,736.00,0.00,576.53,394923.05,420088.08,25165.03,730015),('1','152','257896','316',685.00,736.00,0.00,0.00,0.00,0.00,0.00,730016),('1','152','257897','316',685.00,736.00,0.00,2635.83,1805543.55,1926300.08,120756.53,730017),('1','152','257898','316',685.00,736.00,0.00,3346.55,2292386.75,2444118.50,151731.75,730018),('1','152','257899','316',685.00,736.00,0.00,3540.29,2425098.65,2585735.88,160637.23,730019),('1','152','257900','316',685.00,736.00,0.00,3183.56,2180738.60,2335274.16,154535.56,730020),('1','152','257901','316',685.00,736.00,0.00,3584.84,2455615.40,2622657.64,167042.24,730021),('1','152','257902','316',685.00,736.00,0.00,3910.91,2678973.35,2841054.76,162081.41,730022),('1','152','257903','316',685.00,736.00,0.00,2796.21,1915403.85,2045136.14,129732.29,730023),('1','152','257904','316',685.00,736.00,0.00,2126.04,1456337.40,1546568.30,90230.90,730024),('1','152','257905','316',676.00,736.00,0.00,1023.96,692196.96,749939.70,57742.74,730025),('1','152','257906','316',676.00,736.00,0.00,4055.73,2741673.48,2944138.78,202465.30,730026),('1','152','257907','316',676.00,736.00,0.00,2818.76,1905481.76,2056899.02,151417.26,730027),('1','152','257908','316',676.00,736.00,0.00,2720.74,1839220.24,1993052.64,153832.40,730028),('1','152','257909','316',676.00,736.00,0.00,3448.23,2331003.48,2517862.98,186859.50,730029),('1','152','257910','316',676.00,736.00,0.00,2780.38,1879536.88,2033651.92,154115.04,730030),('1','152','257911','316',676.00,736.00,0.00,2827.67,1911504.92,2076907.36,165402.44,730031),('1','152','257912','316',676.00,736.00,0.00,3091.49,2089847.24,2261154.94,171307.70,730032),('1','152','257913','316',676.00,736.00,0.00,1783.35,1205544.60,1309880.60,104336.00,730033),('1','152','257914','316',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730034),('1','152','257915','316',676.00,736.00,0.00,1496.64,1011728.64,1093727.04,81998.40,730035),('1','152','257916','316',676.00,736.00,0.00,3460.50,2339298.00,2532960.54,193662.54,730036),('1','152','257917','316',676.00,736.00,0.00,907.86,613713.36,660072.96,46359.60,730037),('1','152','257918','316',676.00,736.00,0.00,1915.02,1294553.52,1408154.72,113601.20,730038),('1','152','257919','316',676.00,736.00,0.00,1389.70,939437.20,1020194.76,80757.56,730039),('1','152','257920','316',676.00,736.00,0.00,3838.40,2594758.40,2808284.86,213526.46,730040),('1','152','257921','316',676.00,736.00,0.00,563.39,380851.64,410495.04,29643.40,730041),('1','152','257922','316',676.00,736.00,0.00,3121.31,2110005.56,2291850.16,181844.60,730042),('1','152','257923','316',676.00,736.00,0.00,2512.64,1698544.64,1840978.30,142433.66,730043),('1','152','257924','316',676.00,736.00,0.00,2301.20,1555611.20,1692955.20,137344.00,730044),('1','152','257925','316',676.00,736.00,0.00,1972.80,1333612.80,1442661.10,109048.30,730045),('1','152','257926','316',676.00,736.00,0.00,3695.04,2497847.04,2708965.36,211118.32,730046),('1','152','257927','316',676.00,736.00,0.00,3218.65,2175807.40,2366820.40,191013.00,730047),('1','152','257928','316',676.00,736.00,0.00,3015.65,2038579.40,2216676.60,178097.20,730048),('1','152','257929','316',676.00,736.00,0.00,4076.01,2755382.76,2988762.32,233379.56,730049),('1','152','257930','316',676.00,736.00,0.00,3022.27,2043054.52,2221769.92,178715.40,730050),('1','152','257931','316',676.00,736.00,0.00,3100.84,2096167.84,2277953.98,181786.14,730051),('1','152','257932','316',676.00,736.00,0.00,1829.80,1236944.80,1344660.60,107715.80,730052),('1','152','257933','316',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730053),('1','152','257934','316',676.00,736.00,0.00,973.29,657944.04,711970.84,54026.80,730054),('1','152','257935','316',676.00,736.00,0.00,3655.89,2471381.64,2676380.44,204998.80,730055),('1','152','257936','316',676.00,736.00,0.00,3389.96,2291612.96,2481500.44,189887.48,730056),('1','152','257937','316',676.00,736.00,0.00,3458.95,2338250.20,2540258.82,202008.62,730057),('1','152','257938','316',676.00,736.00,0.00,3872.37,2617722.12,2841746.92,224024.80,730058),('1','152','257939','316',676.00,736.00,0.00,2817.83,1904853.08,2068651.64,163798.56,730059),('1','152','257940','316',676.00,736.00,0.00,3306.37,2235106.12,2426292.04,191185.92,730060),('1','152','257941','316',676.00,736.00,0.00,3171.07,2143643.32,2318765.38,175122.06,730061),('1','152','257942','316',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730062),('1','152','257943','316',676.00,736.00,0.00,3486.59,2356934.84,2554244.86,197310.02,730063),('1','152','257944','316',676.00,736.00,0.00,4289.29,2899560.04,3129139.04,229579.00,730064),('1','152','257945','316',676.00,736.00,0.00,4215.80,2849880.80,3082910.98,233030.18,730065),('1','152','257946','316',676.00,736.00,0.00,3769.86,2548425.36,2759408.00,210982.64,730066),('1','152','257947','316',676.00,736.00,0.00,3171.16,2143704.16,2324020.70,180316.54,730067),('1','152','257948','316',676.00,736.00,0.00,3704.21,2504045.96,2712034.18,207988.22,730068),('1','152','257949','316',676.00,736.00,0.00,2256.09,1525116.84,1656943.64,131826.80,730069),('1','152','257950','316',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730070),('1','152','257951','316',676.00,736.00,0.00,952.18,643673.68,693464.16,49790.48,730071),('1','152','257952','316',676.00,736.00,0.00,2859.21,1932825.96,2096578.56,163752.60,730072),('1','152','257953','316',676.00,736.00,0.00,2066.94,1397251.44,1521267.84,124016.40,730073),('1','152','257954','316',676.00,736.00,0.00,863.11,583462.36,635248.96,51786.60,730074),('1','152','257955','316',676.00,736.00,0.00,3036.61,2052748.36,2234944.96,182196.60,730075),('1','152','257956','316',676.00,736.00,0.00,1939.98,1311426.48,1427825.28,116398.80,730076),('1','152','257957','316',651.00,736.00,0.00,1089.87,709505.37,802144.32,92638.95,730077),('1','152','257958','316',651.00,736.00,0.00,2422.17,1576832.67,1782717.12,205884.45,730078),('1','152','257959','316',651.00,736.00,0.00,238.68,155380.68,175668.48,20287.80,730079),('1','152','257960','316',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730080),('1','152','257961','316',651.00,736.00,0.00,2313.32,1505971.32,1738667.52,232696.20,730081),('1','152','257962','316',651.00,736.00,0.00,2576.05,1677008.55,1895972.80,218964.25,730082),('1','152','257963','316',651.00,736.00,0.00,2451.95,1596219.45,1804635.20,208415.75,730083),('1','152','257964','316',651.00,736.00,0.00,2675.26,1741594.26,1968991.36,227397.10,730084),('1','152','257965','316',651.00,736.00,0.00,1247.30,811992.30,918012.80,106020.50,730085),('1','152','257966','316',651.00,736.00,0.00,1065.13,693399.63,783935.68,90536.05,730086),('1','152','257967','316',651.00,736.00,0.00,2792.96,1818216.96,2055618.56,237401.60,730087),('1','152','257968','316',651.00,736.00,0.00,2211.43,1439640.93,1627612.48,187971.55,730088),('1','152','257969','316',651.00,736.00,0.00,2325.59,1513959.09,1711634.24,197675.15,730089),('1','152','257970','316',651.00,736.00,0.00,2513.16,1636067.16,1849685.76,213618.60,730090),('1','152','257971','316',651.00,736.00,0.00,2152.17,1401062.67,1583997.12,182934.45,730091),('1','152','257972','316',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730092),('1','152','257973','316',651.00,736.00,0.00,239.52,155927.52,176286.72,20359.20,730093),('1','152','257974','316',651.00,736.00,0.00,2263.14,1473304.14,1665671.04,192366.90,730094),('1','152','257975','316',651.00,736.00,0.00,2681.34,1745552.34,1973466.24,227913.90,730095),('1','152','257976','316',651.00,736.00,0.00,3256.90,2120241.90,2397078.40,276836.50,730096),('1','152','257977','316',651.00,736.00,0.00,1992.91,1297384.41,1466781.76,169397.35,730097),('1','152','257978','316',651.00,736.00,0.00,2405.43,1565934.93,1770396.48,204461.55,730098),('1','152','257979','316',651.00,736.00,0.00,2231.60,1452771.60,1642457.60,189686.00,730099),('1','152','257980','316',651.00,736.00,0.00,2413.12,1570941.12,1776056.32,205115.20,730100),('1','152','257981','316',651.00,736.00,0.00,1932.95,1258350.45,1422651.20,164300.75,730101),('1','152','257982','316',651.00,736.00,0.00,2295.49,1494363.99,1689480.64,195116.65,730102),('1','152','257983','316',651.00,736.00,0.00,2420.70,1575875.70,1781635.20,205759.50,730103),('1','152','257984','316',651.00,736.00,0.00,620.33,403834.83,456562.88,52728.05,730104),('1','152','257985','316',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730105),('1','152','257986','316',651.00,736.00,0.00,1252.35,815279.85,921729.60,106449.75,730106),('1','152','257987','316',651.00,736.00,0.00,1810.10,1178375.10,1332233.60,153858.50,730107),('1','152','257988','316',651.00,736.00,0.00,1965.59,1279599.09,1446674.24,167075.15,730108),('1','152','257989','316',651.00,736.00,0.00,1896.63,1234706.13,1395919.68,161213.55,730109),('1','152','257990','316',651.00,736.00,0.00,2045.34,1331516.34,1505370.24,173853.90,730110),('1','152','257991','316',651.00,736.00,0.00,2284.85,1487437.35,1681649.60,194212.25,730111),('1','152','257992','316',651.00,736.00,0.00,2438.34,1587359.34,1794618.24,207258.90,730112),('1','152','257993','316',651.00,736.00,0.00,2040.30,1328235.30,1501660.80,173425.50,730113),('1','152','257994','316',651.00,736.00,0.00,2069.75,1347407.25,1523336.00,175928.75,730114),('1','152','257995','316',651.00,736.00,0.00,2049.41,1334165.91,1508365.76,174199.85,730115),('1','152','257996','316',651.00,736.00,0.00,2416.39,1573069.89,1778463.04,205393.15,730116),('1','152','257997','316',651.00,736.00,0.00,2078.99,1353422.49,1530136.64,176714.15,730117),('1','152','257998','316',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730118),('1','152','257999','316',651.00,736.00,0.00,963.41,627179.91,709069.76,81889.85,730119),('1','152','258000','316',651.00,736.00,0.00,2591.12,1686819.12,1907064.32,220245.20,730120),('1','152','258001','316',651.00,736.00,0.00,2285.47,1487840.97,1682105.92,194264.95,730121),('1','152','258002','316',651.00,736.00,0.00,1892.52,1232030.52,1392894.72,160864.20,730122),('1','152','258003','316',651.00,736.00,0.00,2055.00,1337805.00,1512480.00,174675.00,730123),('1','152','258004','316',651.00,736.00,0.00,2035.83,1325325.33,1498370.88,173045.55,730124),('1','152','258005','316',651.00,736.00,0.00,2437.82,1587020.82,1794235.52,207214.70,730125),('1','152','258006','316',651.00,736.00,0.00,2510.79,1634524.29,1847941.44,213417.15,730126),('1','152','258007','316',651.00,736.00,0.00,2301.17,1498061.67,1693661.12,195599.45,730127),('1','152','258008','316',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730128),('1','152','258009','316',651.00,736.00,0.00,337.57,219758.07,248451.52,28693.45,730129),('1','152','258010','316',651.00,736.00,0.00,2332.59,1518516.09,1716786.24,198270.15,730130),('1','152','258011','316',651.00,736.00,0.00,2068.19,1346391.69,1522187.84,175796.15,730131),('1','152','258012','316',651.00,736.00,0.00,69.18,45036.18,50916.48,5880.30,730132),('1','152','258013','316',651.00,726.00,0.00,1855.07,1207650.57,1346780.82,139130.25,730133),('1','152','258014','316',651.00,726.00,0.00,2089.29,1360127.79,1516824.54,156696.75,730134),('1','152','258015','316',651.00,726.00,0.00,2056.60,1338846.60,1493091.60,154245.00,730135),('1','152','258016','316',651.00,726.00,0.00,1717.83,1118307.33,1247144.58,128837.25,730136),('1','152','258017','316',651.00,726.00,0.00,771.75,502409.25,560290.50,57881.25,730137),('1','152','258018','316',651.00,726.00,0.00,0.00,0.00,0.00,0.00,730138),('1','152','258019','316',651.00,726.00,0.00,1275.03,830044.53,925671.78,95627.25,730139),('1','152','258020','316',651.00,726.00,0.00,1729.74,1126060.74,1255791.24,129730.50,730140),('1','152','258021','316',651.00,726.00,0.00,2053.31,1336704.81,1490703.06,153998.25,730141),('1','152','258022','316',651.00,726.00,0.00,632.20,411562.20,458977.20,47415.00,730142),('1','152','258023','316',651.00,726.00,0.00,1286.15,837283.65,933744.90,96461.25,730143),('1','152','258024','316',651.00,726.00,0.00,2629.71,1711941.21,1909169.46,197228.25,730144),('1','152','258025','316',651.00,726.00,0.00,3220.48,2096532.48,2338068.48,241536.00,730145),('1','152','258026','316',651.00,726.00,0.00,2226.75,1449614.25,1616620.50,167006.25,730146),('1','152','258027','316',651.00,726.00,0.00,46.77,30447.27,33955.02,3507.75,730147);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',295,'152','LPG TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=758 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','152','295',757,1,'316','LPG SKID',7000.00,1.00,5896.03,'TANK CONTAINING LPG','493','2020-07-08 23:31:32','2020-07-10 09:39:32','493',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','152',757,3360.48,'2023-03-20 07:45:36');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2828955 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107857,'1','152','757',316,'Retail Sale Id 1253953',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 06:00:20','',''),(2107858,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:00:20','',''),(2107865,'1','152','757',316,'Retail Sale Id 1253957',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:01:03','',''),(2107866,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:01:03','',''),(2107877,'1','152','757',316,'Retail Sale Id 1253960',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 06:02:18','',''),(2107878,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 06:02:18','',''),(2107883,'1','152','757',316,'Retail Sale Id 1253963',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 06:03:00','',''),(2107884,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:03:00','',''),(2107891,'1','152','757',316,'Retail Sale Id 1253968',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 06:03:48','',''),(2107892,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 06:03:48','',''),(2107900,'1','152','757',316,'Retail Sale Id 1253971',1401.60,0.00,0.00,0.00,83.22,'2021-12-01 06:04:31','',''),(2107901,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-01 06:04:31','',''),(2107916,'1','152','757',316,'Retail Sale Id 1253979',499.20,0.00,0.00,0.00,29.64,'2021-12-01 06:05:32','',''),(2107917,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 06:05:32','',''),(2107924,'1','152','757',316,'Retail Sale Id 1253982',60060.00,0.00,0.00,0.00,1365.00,'2021-12-01 06:06:32','',''),(2107925,'1','152','757',316,'Retail sales',0.00,0.00,0.00,97.50,0.00,'2021-12-01 06:06:32','',''),(2108006,'1','152','757',316,'Retail Sale Id 1254026',277200.00,0.00,0.00,0.00,6300.00,'2021-12-01 06:14:56','',''),(2108007,'1','152','757',316,'Retail sales',0.00,0.00,0.00,450.00,0.00,'2021-12-01 06:14:56','',''),(2108043,'1','152','757',316,'Retail Sale Id 1254035',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 06:17:28','',''),(2108044,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 06:17:28','',''),(2108085,'1','152','757',316,'Retail Sale Id 1254056',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 06:22:32','',''),(2108086,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 06:22:32','',''),(2108101,'1','152','757',316,'Retail Sale Id 1254068',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 06:24:01','',''),(2108102,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:24:01','',''),(2108117,'1','152','757',316,'Retail Sale Id 1254076',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:25:14','',''),(2108118,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:25:14','',''),(2108127,'1','152','757',316,'Retail Sale Id 1254087',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:26:25','',''),(2108128,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:26:25','',''),(2108148,'1','152','757',316,'Retail Sale Id 1254093',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 06:27:39','',''),(2108149,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:27:39','',''),(2108231,'1','152','757',316,'Retail Sale Id 1254139',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 06:34:01','',''),(2108232,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:34:01','',''),(2108299,'1','152','757',316,'Retail Sale Id 1254165',800.00,0.00,0.00,0.00,47.50,'2021-12-01 06:36:47','',''),(2108300,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 06:36:47','',''),(2108516,'1','152','757',316,'Retail Sale Id 1254269',697.60,0.00,0.00,0.00,41.42,'2021-12-01 06:53:04','',''),(2108517,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 06:53:04','',''),(2108544,'1','152','757',316,'Retail Sale Id 1254285',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:54:29','',''),(2108545,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:54:29','',''),(2108748,'1','152','757',316,'Retail Sale Id 1254378',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 07:03:39','',''),(2108749,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 07:03:39','',''),(2108758,'1','152','757',316,'Retail Sale Id 1254383',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:04:19','',''),(2108759,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:04:19','',''),(2108773,'1','152','757',316,'Retail Sale Id 1254392',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:05:01','',''),(2108774,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:05:01','',''),(2108813,'1','152','757',316,'Retail Sale Id 1254403',2700.80,0.00,0.00,0.00,160.36,'2021-12-01 07:06:19','',''),(2108814,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-01 07:06:19','',''),(2108872,'1','152','757',316,'Retail Sale Id 1254431',800.00,0.00,0.00,0.00,47.50,'2021-12-01 07:09:38','',''),(2108873,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 07:09:38','',''),(2108941,'1','152','757',316,'Retail Sale Id 1254455',198.40,0.00,0.00,0.00,11.78,'2021-12-01 07:12:02','',''),(2108942,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.31,0.00,'2021-12-01 07:12:02','',''),(2108983,'1','152','757',316,'Retail Sale Id 1254473',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 07:13:53','',''),(2108984,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:13:53','',''),(2109055,'1','152','757',316,'Retail Sale Id 1254510',2560.00,0.00,0.00,0.00,152.00,'2021-12-01 07:18:09','',''),(2109056,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 07:18:09','',''),(2109096,'1','152','757',316,'Retail Sale Id 1254529',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 07:20:03','',''),(2109097,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 07:20:03','',''),(2109135,'1','152','757',316,'Retail Sale Id 1254544',300.80,0.00,0.00,0.00,17.86,'2021-12-01 07:21:43','',''),(2109136,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.47,0.00,'2021-12-01 07:21:43','',''),(2109201,'1','152','757',316,'Retail Sale Id 1254561',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:23:21','',''),(2109202,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:23:21','',''),(2109306,'1','152','757',316,'Retail Sale Id 1254607',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 07:29:48','',''),(2109307,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 07:29:48','',''),(2109426,'1','152','757',316,'Retail Sale Id 1254677',101640.00,0.00,0.00,0.00,2310.00,'2021-12-01 07:36:08','',''),(2109427,'1','152','757',316,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-01 07:36:08','',''),(2109568,'1','152','757',316,'Retail Sale Id 1254735',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 07:41:43','',''),(2109569,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 07:41:43','',''),(2109606,'1','152','757',316,'Retail Sale Id 1254755',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 07:43:56','',''),(2109607,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 07:43:56','',''),(2109652,'1','152','757',316,'Retail Sale Id 1254774',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 07:45:25','',''),(2109653,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 07:45:25','',''),(2109689,'1','152','757',316,'Retail Sale Id 1254789',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:46:46','',''),(2109690,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:46:46','',''),(2109750,'1','152','757',316,'Retail Sale Id 1254818',12000.00,0.00,0.00,0.00,712.50,'2021-12-01 07:48:58','',''),(2109751,'1','152','757',316,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 07:48:58','',''),(2110056,'1','152','757',316,'Retail Sale Id 1254971',2560.00,0.00,0.00,0.00,152.00,'2021-12-01 08:04:46','',''),(2110057,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 08:04:46','',''),(2110130,'1','152','757',316,'Retail Sale Id 1254999',800.00,0.00,0.00,0.00,47.50,'2021-12-01 08:09:15','',''),(2110131,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 08:09:15','',''),(2110170,'1','152','757',316,'Retail Sale Id 1255020',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 08:12:06','',''),(2110171,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 08:12:06','',''),(2110272,'1','152','757',316,'Retail Sale Id 1255071',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 08:17:25','',''),(2110273,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 08:17:25','',''),(2110487,'1','152','757',316,'Retail Sale Id 1255184',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:30:59','',''),(2110488,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:30:59','',''),(2110673,'1','152','757',316,'Retail Sale Id 1255260',1203.20,0.00,0.00,0.00,71.44,'2021-12-01 08:40:40','',''),(2110674,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 08:40:40','',''),(2110702,'1','152','757',316,'Retail Sale Id 1255279',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 08:42:07','',''),(2110703,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:42:07','',''),(2110770,'1','152','757',316,'Retail Sale Id 1255313',11001.76,0.00,0.00,0.00,250.04,'2021-12-01 08:46:15','',''),(2110771,'1','152','757',316,'Retail sales',0.00,0.00,0.00,17.86,0.00,'2021-12-01 08:46:15','',''),(2110794,'1','152','757',316,'Retail Sale Id 1255330',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 08:47:36','',''),(2110795,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 08:47:36','',''),(2110826,'1','152','757',316,'Retail Sale Id 1255351',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 08:49:28','',''),(2110827,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:49:28','',''),(2110856,'1','152','757',316,'Retail Sale Id 1255367',486640.00,0.00,0.00,0.00,11060.00,'2021-12-01 08:51:37','',''),(2110857,'1','152','757',316,'Retail sales',0.00,0.00,0.00,790.00,0.00,'2021-12-01 08:51:37','',''),(2110872,'1','152','757',316,'Retail Sale Id 1255376',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:52:39','',''),(2110873,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:52:39','',''),(2110890,'1','152','757',316,'Retail Sale Id 1255385',499.20,0.00,0.00,0.00,29.64,'2021-12-01 08:53:43','',''),(2110891,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 08:53:43','',''),(2111042,'1','152','757',316,'Retail Sale Id 1255463',33880.00,0.00,0.00,0.00,770.00,'2021-12-01 09:02:41','',''),(2111043,'1','152','757',316,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-01 09:02:41','',''),(2111094,'1','152','757',316,'Retail Sale Id 1255489',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:05:02','',''),(2111095,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:05:02','',''),(2111134,'1','152','757',316,'Retail Sale Id 1255507',4499.20,0.00,0.00,0.00,267.14,'2021-12-01 09:08:23','',''),(2111135,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 09:08:23','',''),(2111156,'1','152','757',316,'Retail Sale Id 1255515',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 09:09:14','',''),(2111157,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 09:09:14','',''),(2111328,'1','152','757',316,'Retail Sale Id 1255617',98560.00,0.00,0.00,0.00,2240.00,'2021-12-01 09:20:00','',''),(2111329,'1','152','757',316,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-01 09:20:00','',''),(2111342,'1','152','757',316,'Retail Sale Id 1255622',87502.80,0.00,0.00,0.00,1988.70,'2021-12-01 09:20:56','',''),(2111343,'1','152','757',316,'Retail sales',0.00,0.00,0.00,142.05,0.00,'2021-12-01 09:20:56','',''),(2111352,'1','152','757',316,'Retail Sale Id 1255627',5544.00,0.00,0.00,0.00,126.00,'2021-12-01 09:21:30','',''),(2111353,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 09:21:30','',''),(2111362,'1','152','757',316,'Retail Sale Id 1255632',2803.20,0.00,0.00,0.00,166.44,'2021-12-01 09:22:06','',''),(2111363,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 09:22:06','',''),(2111390,'1','152','757',316,'Retail Sale Id 1255645',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 09:23:28','',''),(2111391,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:23:28','',''),(2111454,'1','152','757',316,'Retail Sale Id 1255673',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 09:27:17','',''),(2111455,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:27:17','',''),(2111726,'1','152','757',316,'Retail Sale Id 1255820',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:45:17','',''),(2111727,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:45:17','',''),(2111827,'1','152','757',316,'Retail Sale Id 1255873',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 09:53:12','',''),(2111828,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:53:12','',''),(2111841,'1','152','757',316,'Retail Sale Id 1255878',21560.00,0.00,0.00,0.00,490.00,'2021-12-01 09:54:24','',''),(2111842,'1','152','757',316,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 09:54:24','',''),(2111928,'1','152','757',316,'Retail Sale Id 1255920',1203.20,0.00,0.00,0.00,71.44,'2021-12-01 09:59:59','',''),(2111929,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 09:59:59','',''),(2112007,'1','152','757',316,'Retail Sale Id 1255955',697.60,0.00,0.00,0.00,41.42,'2021-12-01 10:04:17','',''),(2112008,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 10:04:17','',''),(2112047,'1','152','757',316,'Retail Sale Id 1255975',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 10:08:24','',''),(2112048,'1','152','757',316,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:08:24','',''),(2112945,'1','152','757',316,'Retail Sale Id 1256423',2803.20,0.00,0.00,0.00,166.44,'2021-12-01 11:15:42','',''),(2112946,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 11:15:42','',''),(2112968,'1','152','757',316,'Retail Sale Id 1256429',1401.60,0.00,0.00,0.00,83.22,'2021-12-01 11:16:26','',''),(2112969,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-01 11:16:26','',''),(2113004,'1','152','757',316,'Retail Sale Id 1256443',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:18:03','',''),(2113005,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:18:03','',''),(2113022,'1','152','757',316,'Retail Sale Id 1256452',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 11:18:54','',''),(2113023,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 11:18:54','',''),(2113068,'1','152','757',316,'Retail Sale Id 1256473',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:22:06','',''),(2113069,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:22:06','',''),(2113080,'1','152','757',316,'Retail Sale Id 1256479',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:22:53','',''),(2113081,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:22:53','',''),(2113086,'1','152','757',316,'Retail Sale Id 1256484',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 11:23:34','',''),(2113087,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 11:23:34','',''),(2113355,'1','152','757',316,'Retail Sale Id 1256624',6160.00,0.00,0.00,0.00,140.00,'2021-12-01 11:42:01','',''),(2113356,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 11:42:01','',''),(2113365,'1','152','757',316,'Retail Sale Id 1256628',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 11:42:58','',''),(2113366,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 11:42:58','',''),(2113394,'1','152','757',316,'Retail Sale Id 1256645',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:44:46','',''),(2113395,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:44:46','',''),(2113441,'1','152','757',316,'Retail Sale Id 1256668',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 11:48:53','',''),(2113442,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 11:48:53','',''),(2113463,'1','152','757',316,'Retail Sale Id 1256677',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:50:13','',''),(2113464,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:50:13','',''),(2113495,'1','152','757',316,'Retail Sale Id 1256692',902.40,0.00,0.00,0.00,53.58,'2021-12-01 11:53:08','',''),(2113496,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 11:53:08','',''),(2113631,'1','152','757',316,'Retail Sale Id 1256770',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 12:07:46','',''),(2113632,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 12:07:46','',''),(2113639,'1','152','757',316,'Retail Sale Id 1256774',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 12:08:25','',''),(2113640,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 12:08:25','',''),(2113653,'1','152','757',316,'Retail Sale Id 1256781',499.20,0.00,0.00,0.00,29.64,'2021-12-01 12:09:39','',''),(2113654,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 12:09:39','',''),(2113661,'1','152','757',316,'Retail Sale Id 1256784',998.40,0.00,0.00,0.00,59.28,'2021-12-01 12:10:09','',''),(2113662,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:10:09','',''),(2113677,'1','152','757',316,'Retail Sale Id 1256794',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 12:11:49','',''),(2113678,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 12:11:49','',''),(2113695,'1','152','757',316,'Retail Sale Id 1256805',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:12:32','',''),(2113696,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:12:32','',''),(2113715,'1','152','757',316,'Retail Sale Id 1256814',23100.00,0.00,0.00,0.00,525.00,'2021-12-01 12:13:43','',''),(2113716,'1','152','757',316,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 12:13:43','',''),(2113725,'1','152','757',316,'Retail Sale Id 1256820',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 12:14:34','',''),(2113726,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:14:34','',''),(2113759,'1','152','757',316,'Retail Sale Id 1256835',215600.00,0.00,0.00,0.00,4900.00,'2021-12-01 12:16:38','',''),(2113760,'1','152','757',316,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-01 12:16:38','',''),(2113783,'1','152','757',316,'Retail Sale Id 1256847',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 12:18:35','',''),(2113784,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 12:18:35','',''),(2113789,'1','152','757',316,'Retail Sale Id 1256851',7680.00,0.00,0.00,0.00,456.00,'2021-12-01 12:18:58','',''),(2113790,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 12:18:58','',''),(2113799,'1','152','757',316,'Retail Sale Id 1256857',7040.00,0.00,0.00,0.00,418.00,'2021-12-01 12:19:35','',''),(2113800,'1','152','757',316,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 12:19:35','',''),(2113849,'1','152','757',316,'Retail Sale Id 1256885',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 12:22:03','',''),(2113850,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:22:03','',''),(2113871,'1','152','757',316,'Retail Sale Id 1256891',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:23:06','',''),(2113872,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:23:06','',''),(2113913,'1','152','757',316,'Retail Sale Id 1256913',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 12:26:49','',''),(2113914,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 12:26:49','',''),(2113943,'1','152','757',316,'Retail Sale Id 1256927',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:28:58','',''),(2113944,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:28:58','',''),(2113965,'1','152','757',316,'Retail Sale Id 1256938',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 12:30:41','',''),(2113966,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 12:30:41','',''),(2113971,'1','152','757',316,'Retail Sale Id 1256942',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 12:31:36','',''),(2113972,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 12:31:36','',''),(2113991,'1','152','757',316,'Retail Sale Id 1256952',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 12:33:13','',''),(2113992,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:33:13','',''),(2114041,'1','152','757',316,'Retail Sale Id 1256977',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 12:38:38','',''),(2114042,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 12:38:38','',''),(2114053,'1','152','757',316,'Retail Sale Id 1256983',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:40:16','',''),(2114054,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:40:16','',''),(2114067,'1','152','757',316,'Retail Sale Id 1256989',2560.00,0.00,0.00,0.00,152.00,'2021-12-01 12:41:12','',''),(2114068,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 12:41:12','',''),(2114087,'1','152','757',316,'Retail Sale Id 1257001',4499.20,0.00,0.00,0.00,267.14,'2021-12-01 12:43:08','',''),(2114088,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 12:43:08','',''),(2114134,'1','152','757',316,'Retail Sale Id 1257020',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:47:59','',''),(2114135,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:47:59','',''),(2114190,'1','152','757',316,'Retail Sale Id 1257051',1702.40,0.00,0.00,0.00,101.08,'2021-12-01 12:54:39','',''),(2114191,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 12:54:39','',''),(2114240,'1','152','757',316,'Retail Sale Id 1257079',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 13:00:33','',''),(2114241,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 13:00:33','',''),(2114268,'1','152','757',316,'Retail Sale Id 1257093',258720.00,0.00,0.00,0.00,5880.00,'2021-12-01 13:02:50','',''),(2114269,'1','152','757',316,'Retail sales',0.00,0.00,0.00,420.00,0.00,'2021-12-01 13:02:50','',''),(2114310,'1','152','757',316,'Retail Sale Id 1257105',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 13:05:11','',''),(2114311,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 13:05:11','',''),(2114378,'1','152','757',316,'Retail Sale Id 1257142',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 13:10:23','',''),(2114379,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 13:10:23','',''),(2114418,'1','152','757',316,'Retail Sale Id 1257199',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 13:12:30','',''),(2114419,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 13:12:30','',''),(2114450,'1','152','757',316,'Retail Sale Id 1257215',902.40,0.00,0.00,0.00,53.58,'2021-12-01 13:14:08','',''),(2114451,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 13:14:08','',''),(2114476,'1','152','757',316,'Retail Sale Id 1257229',800.00,0.00,0.00,0.00,47.50,'2021-12-01 13:15:33','',''),(2114477,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 13:15:33','',''),(2114594,'1','152','757',316,'Retail Sale Id 1257292',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 13:24:30','',''),(2114595,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 13:24:30','',''),(2114599,'1','152','757',316,'Retail Sale Id 1257213',902.40,0.00,0.00,0.00,53.58,'2021-12-01 13:25:05','',''),(2114600,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 13:25:05','',''),(2114838,'1','152','757',316,'Retail Sale Id 1257377',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 13:40:53','',''),(2114839,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:40:53','',''),(2115047,'1','152','757',316,'Retail Sale Id 1257455',7700.00,0.00,0.00,0.00,175.00,'2021-12-01 13:52:49','',''),(2115048,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:52:49','',''),(2115070,'1','152','757',316,'Retail Sale Id 1257466',1203.20,0.00,0.00,0.00,71.44,'2021-12-01 13:53:54','',''),(2115071,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 13:53:54','',''),(2115160,'1','152','757',316,'Retail Sale Id 1257513',697.60,0.00,0.00,0.00,41.42,'2021-12-01 13:58:34','',''),(2115161,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 13:58:34','',''),(2115172,'1','152','757',316,'Retail Sale Id 1257519',23100.00,0.00,0.00,0.00,525.00,'2021-12-01 13:59:21','',''),(2115173,'1','152','757',316,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 13:59:21','',''),(2115198,'1','152','757',316,'Retail Sale Id 1257531',2201.60,0.00,0.00,0.00,130.72,'2021-12-01 14:00:39','',''),(2115199,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 14:00:39','',''),(2115253,'1','152','757',316,'Retail Sale Id 1257557',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 14:03:26','',''),(2115254,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 14:03:26','',''),(2115309,'1','152','757',316,'Retail Sale Id 1257582',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 14:06:42','',''),(2115310,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 14:06:42','',''),(2115381,'1','152','757',316,'Retail Sale Id 1257629',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 14:11:46','',''),(2115382,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 14:11:46','',''),(2115638,'1','152','757',316,'Retail Sale Id 1257761',1600.00,0.00,0.00,0.00,95.00,'2021-12-01 14:29:24','',''),(2115639,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 14:29:24','',''),(2116132,'1','152','757',316,'Retail Sale Id 1257974',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 15:01:45','',''),(2116133,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:01:45','',''),(2116408,'1','152',NULL,316,'Reception corrector for bridging 125859',0.00,0.00,0.00,5899.00,0.00,'2021-12-01 15:21:15','',''),(2116409,'1','152','757',316,'Received from bridging 125859',0.00,0.00,5899.00,0.00,0.00,'2021-12-01 15:21:15','',''),(2116456,'1','152','757',316,'Retail Sale Id 1258132',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 15:23:59','',''),(2116457,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:23:59','',''),(2116517,'1','152','757',316,'Retail Sale Id 1258160',601.60,0.00,0.00,0.00,35.72,'2021-12-01 15:27:58','',''),(2116518,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-01 15:27:58','',''),(2116533,'1','152','757',316,'Retail Sale Id 1258167',1401.60,0.00,0.00,0.00,83.22,'2021-12-01 15:28:40','',''),(2116534,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-01 15:28:40','',''),(2116563,'1','152','757',316,'Retail Sale Id 1258182',4697.60,0.00,0.00,0.00,278.92,'2021-12-01 15:30:34','',''),(2116564,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.34,0.00,'2021-12-01 15:30:34','',''),(2116571,'1','152','757',316,'Retail Sale Id 1258187',2201.60,0.00,0.00,0.00,130.72,'2021-12-01 15:31:20','',''),(2116572,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 15:31:20','',''),(2116585,'1','152','757',316,'Retail Sale Id 1258195',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 15:32:33','',''),(2116586,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:32:33','',''),(2116672,'1','152','757',316,'Retail Sale Id 1258241',998.40,0.00,0.00,0.00,59.28,'2021-12-01 15:38:25','',''),(2116673,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:38:25','',''),(2116946,'1','152','757',316,'Retail Sale Id 1258367',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:51:25','',''),(2116947,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:51:25','',''),(2116966,'1','152','757',316,'Retail Sale Id 1258376',2560.00,0.00,0.00,0.00,152.00,'2021-12-01 15:52:05','',''),(2116967,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:52:05','',''),(2117002,'1','152','757',316,'Retail Sale Id 1258394',129360.00,0.00,0.00,0.00,2940.00,'2021-12-01 15:53:43','',''),(2117003,'1','152','757',316,'Retail sales',0.00,0.00,0.00,210.00,0.00,'2021-12-01 15:53:43','',''),(2117062,'1','152','757',316,'Retail Sale Id 1258420',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:56:02','',''),(2117063,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:56:02','',''),(2117086,'1','152','757',316,'Retail Sale Id 1258433',123200.00,0.00,0.00,0.00,2800.00,'2021-12-01 15:57:34','',''),(2117087,'1','152','757',316,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 15:57:34','',''),(2117249,'1','152','757',316,'Retail Sale Id 1258514',5120.00,0.00,0.00,0.00,304.00,'2021-12-01 16:04:39','',''),(2117250,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 16:04:39','',''),(2117269,'1','152','757',316,'Retail Sale Id 1258526',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:05:41','',''),(2117270,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:05:41','',''),(2117306,'1','152','757',316,'Retail Sale Id 1258534',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:06:35','',''),(2117307,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:06:35','',''),(2117318,'1','152','757',316,'Retail Sale Id 1258545',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:07:12','',''),(2117319,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:07:12','',''),(2117349,'1','152','757',316,'Retail Sale Id 1258555',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:08:23','',''),(2117350,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:08:23','',''),(2117370,'1','152','757',316,'Retail Sale Id 1258559',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:08:52','',''),(2117371,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:08:52','',''),(2117391,'1','152','757',316,'Retail Sale Id 1258568',23100.00,0.00,0.00,0.00,525.00,'2021-12-01 16:09:52','',''),(2117392,'1','152','757',316,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 16:09:52','',''),(2117430,'1','152','757',316,'Retail Sale Id 1258583',20636.00,0.00,0.00,0.00,469.00,'2021-12-01 16:11:27','',''),(2117431,'1','152','757',316,'Retail sales',0.00,0.00,0.00,33.50,0.00,'2021-12-01 16:11:27','',''),(2117452,'1','152','757',316,'Retail Sale Id 1258597',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 16:12:48','',''),(2117453,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 16:12:48','',''),(2117460,'1','152','757',316,'Retail Sale Id 1258602',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:13:29','',''),(2117461,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:13:29','',''),(2117497,'1','152','757',316,'Retail Sale Id 1258610',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:14:09','',''),(2117498,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:14:09','',''),(2117517,'1','152','757',316,'Retail Sale Id 1258617',499.20,0.00,0.00,0.00,29.64,'2021-12-01 16:14:45','',''),(2117518,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 16:14:45','',''),(2117531,'1','152','757',316,'Retail Sale Id 1258628',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:15:26','',''),(2117532,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:15:26','',''),(2117549,'1','152','757',316,'Retail Sale Id 1258636',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:16:10','',''),(2117550,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:16:10','',''),(2117563,'1','152','757',316,'Retail Sale Id 1258625',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:16:44','',''),(2117564,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:16:44','',''),(2117621,'1','152','757',316,'Retail Sale Id 1258676',697.60,0.00,0.00,0.00,41.42,'2021-12-01 16:19:25','',''),(2117622,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 16:19:25','',''),(2117662,'1','152','757',316,'Retail Sale Id 1258694',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:20:52','',''),(2117663,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:20:52','',''),(2117780,'1','152','757',316,'Retail Sale Id 1258767',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 16:26:21','',''),(2117781,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:26:21','',''),(2117874,'1','152','757',316,'Retail Sale Id 1258821',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:30:34','',''),(2117875,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:30:34','',''),(2117902,'1','152','757',316,'Retail Sale Id 1258837',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:31:56','',''),(2117903,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:31:56','',''),(2117920,'1','152','757',316,'Retail Sale Id 1258846',6502.40,0.00,0.00,0.00,386.08,'2021-12-01 16:32:52','',''),(2117921,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 16:32:52','',''),(2117936,'1','152','757',316,'Retail Sale Id 1258853',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:33:42','',''),(2117937,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:33:42','',''),(2117990,'1','152','757',316,'Retail Sale Id 1258883',5120.00,0.00,0.00,0.00,304.00,'2021-12-01 16:36:43','',''),(2117991,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 16:36:43','',''),(2118012,'1','152','757',316,'Retail Sale Id 1258897',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 16:37:42','',''),(2118013,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 16:37:42','',''),(2118058,'1','152','757',316,'Retail Sale Id 1258919',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 16:39:45','',''),(2118059,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 16:39:45','',''),(2118100,'1','152','757',316,'Retail Sale Id 1258942',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:41:28','',''),(2118101,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:41:28','',''),(2118130,'1','152','757',316,'Retail Sale Id 1258960',26999.28,0.00,0.00,0.00,613.62,'2021-12-01 16:43:24','',''),(2118131,'1','152','757',316,'Retail sales',0.00,0.00,0.00,43.83,0.00,'2021-12-01 16:43:24','',''),(2118868,'1','152','757',316,'Retail Sale Id 1259328',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 17:19:42','',''),(2118869,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:19:42','',''),(2118906,'1','152','757',316,'Retail Sale Id 1259347',800.00,0.00,0.00,0.00,47.50,'2021-12-01 17:22:11','',''),(2118907,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 17:22:11','',''),(2118918,'1','152','757',316,'Retail Sale Id 1258543',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 17:22:58','',''),(2118919,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 17:22:58','',''),(2118934,'1','152','757',316,'Retail Sale Id 1259364',2297.60,0.00,0.00,0.00,136.42,'2021-12-01 17:24:26','',''),(2118935,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-01 17:24:26','',''),(2119065,'1','152','757',316,'Retail Sale Id 1259425',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 17:32:59','',''),(2119066,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:32:59','',''),(2119079,'1','152','757',316,'Retail Sale Id 1259431',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 17:33:51','',''),(2119080,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:33:51','',''),(2119107,'1','152','757',316,'Retail Sale Id 1259446',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 17:36:32','',''),(2119108,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 17:36:32','',''),(2119127,'1','152','757',316,'Retail Sale Id 1259456',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 17:38:05','',''),(2119128,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 17:38:05','',''),(2119161,'1','152','757',316,'Retail Sale Id 1259473',3997.84,0.00,0.00,0.00,90.86,'2021-12-01 17:40:31','',''),(2119162,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-01 17:40:31','',''),(2119175,'1','152','757',316,'Retail Sale Id 1259479',403.20,0.00,0.00,0.00,23.94,'2021-12-01 17:41:25','',''),(2119176,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.63,0.00,'2021-12-01 17:41:25','',''),(2119292,'1','152','757',316,'Retail Sale Id 1259537',28000.00,0.00,0.00,0.00,1662.50,'2021-12-01 17:52:57','',''),(2119293,'1','152','757',316,'Retail sales',0.00,0.00,0.00,43.75,0.00,'2021-12-01 17:52:57','',''),(2119345,'1','152','757',316,'Retail Sale Id 1259565',9548.00,0.00,0.00,0.00,217.00,'2021-12-01 17:59:02','',''),(2119346,'1','152','757',316,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-01 17:59:02','',''),(2119351,'1','152','757',316,'Retail Sale Id 1259567',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 18:00:17','',''),(2119352,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 18:00:17','',''),(2119365,'1','152','757',316,'Retail Sale Id 1258624',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 18:03:03','',''),(2119366,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 18:03:03','',''),(2119625,'1','152','757',316,'Return of Retail Sale Id 1255622',0.00,87502.80,142.05,0.00,-1988.70,'2021-12-01 18:36:56','',''),(2119674,'1','152','757',316,'Retail Sale Id 1259715',16810.64,0.00,0.00,0.00,382.06,'2021-12-01 18:46:40','',''),(2119675,'1','152','757',316,'Retail sales',0.00,0.00,0.00,27.29,0.00,'2021-12-01 18:46:40','',''),(2119682,'1','152','757',316,'Retail Sale Id 1259719',5267.20,0.00,0.00,0.00,312.74,'2021-12-01 18:48:00','',''),(2119683,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.23,0.00,'2021-12-01 18:48:00','',''),(2119698,'1','152','757',316,'Retail Sale Id 1259727',304972.80,0.00,0.00,0.00,18107.76,'2021-12-01 18:50:52','',''),(2119699,'1','152','757',316,'Retail sales',0.00,0.00,0.00,476.52,0.00,'2021-12-01 18:50:52','',''),(2119704,'1','152','757',316,'Retail Sale Id 1259730',806393.60,0.00,0.00,0.00,47879.62,'2021-12-01 18:51:57','',''),(2119705,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1259.99,0.00,'2021-12-01 18:51:57','',''),(2119716,'1','152','757',316,'Retail Sale Id 1259735',257388.80,0.00,0.00,0.00,15282.46,'2021-12-01 18:54:16','',''),(2119717,'1','152','757',316,'Retail sales',0.00,0.00,0.00,402.17,0.00,'2021-12-01 18:54:16','',''),(2121641,'1','152','757',316,'Retail Sale Id 1260402',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:18:47','',''),(2121642,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:18:47','',''),(2121657,'1','152','757',316,'Retail Sale Id 1260406',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:19:58','',''),(2121658,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:19:58','',''),(2121688,'1','152','757',316,'Retail Sale Id 1260418',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 07:21:13','',''),(2121689,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:21:13','',''),(2121717,'1','152','757',316,'Retail Sale Id 1260432',2297.60,0.00,0.00,0.00,136.42,'2021-12-02 07:22:38','',''),(2121718,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-02 07:22:38','',''),(2121733,'1','152','757',316,'Retail Sale Id 1260440',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 07:23:42','',''),(2121734,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:23:42','',''),(2121799,'1','152','757',316,'Retail Sale Id 1260476',77000.00,0.00,0.00,0.00,1750.00,'2021-12-02 07:26:49','',''),(2121800,'1','152','757',316,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-02 07:26:49','',''),(2121813,'1','152','757',316,'Retail Sale Id 1260486',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:27:29','',''),(2121814,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:27:29','',''),(2121839,'1','152','757',316,'Retail Sale Id 1260499',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:28:44','',''),(2121840,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:28:44','',''),(2121883,'1','152','757',316,'Retail Sale Id 1260522',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 07:31:07','',''),(2121884,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 07:31:07','',''),(2121919,'1','152','757',316,'Retail Sale Id 1260555',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:33:50','',''),(2121920,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:33:50','',''),(2121981,'1','152','757',316,'Retail Sale Id 1260591',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 07:37:21','',''),(2121982,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:37:21','',''),(2122070,'1','152','757',316,'Retail Sale Id 1260636',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 07:40:46','',''),(2122071,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:40:46','',''),(2122116,'1','152','757',316,'Retail Sale Id 1260656',86240.00,0.00,0.00,0.00,1960.00,'2021-12-02 07:42:30','',''),(2122117,'1','152','757',316,'Retail sales',0.00,0.00,0.00,140.00,0.00,'2021-12-02 07:42:30','',''),(2122181,'1','152','757',316,'Retail Sale Id 1260690',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:46:26','',''),(2122182,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:46:26','',''),(2122227,'1','152','757',316,'Retail Sale Id 1260718',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:48:47','',''),(2122228,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:48:47','',''),(2122245,'1','152','757',316,'Retail Sale Id 1260726',1232.00,0.00,0.00,0.00,28.00,'2021-12-02 07:49:28','',''),(2122246,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:49:28','',''),(2122299,'1','152','757',316,'Retail Sale Id 1260737',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:50:17','',''),(2122300,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:50:17','',''),(2122319,'1','152','757',316,'Retail Sale Id 1260749',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:50:58','',''),(2122320,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:50:58','',''),(2122341,'1','152','757',316,'Retail Sale Id 1260758',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 07:51:51','',''),(2122342,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 07:51:51','',''),(2122383,'1','152','757',316,'Retail Sale Id 1260778',14502.40,0.00,0.00,0.00,861.08,'2021-12-02 07:53:34','',''),(2122384,'1','152','757',316,'Retail sales',0.00,0.00,0.00,22.66,0.00,'2021-12-02 07:53:34','',''),(2122416,'1','152','757',316,'Retail Sale Id 1260796',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:55:04','',''),(2122417,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:55:04','',''),(2122418,'1','152','757',316,'Retail Sale Id 1260796',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:55:04','',''),(2122419,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:55:04','',''),(2122470,'1','152','757',316,'Retail Sale Id 1260821',3699.20,0.00,0.00,0.00,219.64,'2021-12-02 07:57:25','',''),(2122471,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-02 07:57:25','',''),(2122504,'1','152','757',316,'Retail Sale Id 1260837',11001.60,0.00,0.00,0.00,653.22,'2021-12-02 07:58:22','',''),(2122505,'1','152','757',316,'Retail sales',0.00,0.00,0.00,17.19,0.00,'2021-12-02 07:58:22','',''),(2122561,'1','152','757',316,'Retail Sale Id 1260855',7700.00,0.00,0.00,0.00,175.00,'2021-12-02 07:59:54','',''),(2122562,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:59:54','',''),(2122633,'1','152','757',316,'Retail Sale Id 1260888',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:03:41','',''),(2122634,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:03:41','',''),(2122649,'1','152','757',316,'Retail Sale Id 1260894',499.20,0.00,0.00,0.00,29.64,'2021-12-02 08:04:21','',''),(2122650,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 08:04:21','',''),(2122681,'1','152','757',316,'Retail Sale Id 1260914',26488.00,0.00,0.00,0.00,602.00,'2021-12-02 08:05:45','',''),(2122682,'1','152','757',316,'Retail sales',0.00,0.00,0.00,43.00,0.00,'2021-12-02 08:05:45','',''),(2122896,'1','152','757',316,'Retail Sale Id 1261015',98560.00,0.00,0.00,0.00,2240.00,'2021-12-02 08:17:40','',''),(2122897,'1','152','757',316,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-02 08:17:40','',''),(2122918,'1','152','757',316,'Retail Sale Id 1261037',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:18:37','',''),(2122919,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:18:37','',''),(2123017,'1','152','757',316,'Retail Sale Id 1261092',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 08:23:23','',''),(2123018,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 08:23:23','',''),(2123053,'1','152','757',316,'Retail Sale Id 1261104',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:24:47','',''),(2123054,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:24:47','',''),(2123139,'1','152','757',316,'Retail Sale Id 1261148',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:29:25','',''),(2123140,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:29:25','',''),(2123207,'1','152','757',316,'Retail Sale Id 1261182',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 08:33:33','',''),(2123208,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:33:33','',''),(2123233,'1','152','757',316,'Retail Sale Id 1261200',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:35:11','',''),(2123234,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:35:11','',''),(2123383,'1','152','757',316,'Retail Sale Id 1261248',1702.40,0.00,0.00,0.00,101.08,'2021-12-02 08:40:49','',''),(2123384,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-02 08:40:49','',''),(2123401,'1','152','757',316,'Retail Sale Id 1261260',30800.00,0.00,0.00,0.00,700.00,'2021-12-02 08:41:51','',''),(2123402,'1','152','757',316,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:41:51','',''),(2123417,'1','152','757',316,'Retail Sale Id 1261268',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 08:42:55','',''),(2123418,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 08:42:55','',''),(2123631,'1','152','757',316,'Retail Sale Id 1261377',800.00,0.00,0.00,0.00,47.50,'2021-12-02 08:55:51','',''),(2123632,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 08:55:51','',''),(2123671,'1','152','757',316,'Retail Sale Id 1261394',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:57:36','',''),(2123672,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:57:36','',''),(2123971,'1','152','757',316,'Retail Sale Id 1261556',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:12:18','',''),(2123972,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:12:18','',''),(2124180,'1','152','757',316,'Retail Sale Id 1261640',697.60,0.00,0.00,0.00,41.42,'2021-12-02 09:21:40','',''),(2124181,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 09:21:40','',''),(2124234,'1','152','757',316,'Retail Sale Id 1261669',3699.20,0.00,0.00,0.00,219.64,'2021-12-02 09:24:25','',''),(2124235,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-02 09:24:25','',''),(2124272,'1','152','757',316,'Retail Sale Id 1261688',11297.44,0.00,0.00,0.00,256.76,'2021-12-02 09:26:47','',''),(2124273,'1','152','757',316,'Retail sales',0.00,0.00,0.00,18.34,0.00,'2021-12-02 09:26:47','',''),(2124352,'1','152','757',316,'Retail Sale Id 1261725',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:31:37','',''),(2124353,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:31:37','',''),(2124385,'1','152','757',316,'Retail Sale Id 1261740',8297.52,0.00,0.00,0.00,188.58,'2021-12-02 09:33:47','',''),(2124386,'1','152','757',316,'Retail sales',0.00,0.00,0.00,13.47,0.00,'2021-12-02 09:33:47','',''),(2124423,'1','152','757',316,'Retail Sale Id 1261763',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 09:36:58','',''),(2124424,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 09:36:58','',''),(2124505,'1','152','757',316,'Retail Sale Id 1261803',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:42:32','',''),(2124506,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:42:32','',''),(2124529,'1','152','757',316,'Retail Sale Id 1261813',2899.20,0.00,0.00,0.00,172.14,'2021-12-02 09:43:37','',''),(2124530,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-02 09:43:37','',''),(2124551,'1','152','757',316,'Retail Sale Id 1261826',998.40,0.00,0.00,0.00,59.28,'2021-12-02 09:44:30','',''),(2124552,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:44:30','',''),(2124574,'1','152','757',316,'Retail Sale Id 1261836',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 09:45:36','',''),(2124575,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 09:45:36','',''),(2124621,'1','152','757',316,'Retail Sale Id 1261859',6776.00,0.00,0.00,0.00,154.00,'2021-12-02 09:48:43','',''),(2124622,'1','152','757',316,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:48:43','',''),(2124639,'1','152','757',316,'Retail Sale Id 1261868',20944.00,0.00,0.00,0.00,476.00,'2021-12-02 09:49:35','',''),(2124640,'1','152','757',316,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-02 09:49:35','',''),(2124709,'1','152','757',316,'Retail Sale Id 1261912',499.20,0.00,0.00,0.00,29.64,'2021-12-02 09:52:31','',''),(2124710,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 09:52:31','',''),(2124793,'1','152','757',316,'Retail Sale Id 1261958',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:56:48','',''),(2124794,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:56:48','',''),(2124914,'1','152','757',316,'Retail Sale Id 1262016',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 10:02:50','',''),(2124915,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 10:02:50','',''),(2124953,'1','152','757',316,'Retail Sale Id 1262035',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 10:05:05','',''),(2124954,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 10:05:05','',''),(2125009,'1','152','757',316,'Retail Sale Id 1262071',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 10:09:26','',''),(2125010,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 10:09:26','',''),(2125037,'1','152','757',316,'Retail Sale Id 1262082',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 10:10:59','',''),(2125038,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 10:10:59','',''),(2125065,'1','152','757',316,'Retail Sale Id 1262096',2700.80,0.00,0.00,0.00,160.36,'2021-12-02 10:12:27','',''),(2125066,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-02 10:12:27','',''),(2125108,'1','152','757',316,'Retail Sale Id 1262117',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 10:14:49','',''),(2125109,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 10:14:49','',''),(2125148,'1','152','757',316,'Retail Sale Id 1262139',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 10:17:05','',''),(2125149,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:17:05','',''),(2125168,'1','152','757',316,'Retail Sale Id 1262150',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 10:18:28','',''),(2125169,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:18:28','',''),(2125196,'1','152','757',316,'Retail Sale Id 1262162',7700.00,0.00,0.00,0.00,175.00,'2021-12-02 10:19:47','',''),(2125197,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:19:47','',''),(2125234,'1','152','757',316,'Retail Sale Id 1262185',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 10:21:52','',''),(2125235,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 10:21:52','',''),(2125259,'1','152','757',316,'Retail Sale Id 1262198',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:23:20','',''),(2125260,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:23:20','',''),(2125333,'1','152','757',316,'Retail Sale Id 1262225',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:26:35','',''),(2125334,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:26:35','',''),(2125356,'1','152','757',316,'Retail Sale Id 1262240',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 10:28:00','',''),(2125357,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 10:28:00','',''),(2125372,'1','152','757',316,'Retail Sale Id 1262248',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:29:19','',''),(2125373,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:29:19','',''),(2125500,'1','152','757',316,'Retail Sale Id 1262311',6502.40,0.00,0.00,0.00,386.08,'2021-12-02 10:37:10','',''),(2125501,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-02 10:37:10','',''),(2125538,'1','152','757',316,'Retail Sale Id 1262328',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:39:38','',''),(2125539,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:39:38','',''),(2125568,'1','152','757',316,'Retail Sale Id 1262343',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 10:41:55','',''),(2125569,'1','152','757',316,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 10:41:55','',''),(2125636,'1','152','757',316,'Retail Sale Id 1262377',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:45:05','',''),(2125637,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:45:05','',''),(2125684,'1','152','757',316,'Retail Sale Id 1262401',998.40,0.00,0.00,0.00,59.28,'2021-12-02 10:48:22','',''),(2125685,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:48:22','',''),(2125752,'1','152','757',316,'Retail Sale Id 1262428',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 10:52:31','',''),(2125753,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 10:52:31','',''),(2126094,'1','152','757',316,'Retail Sale Id 1262619',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 11:15:14','',''),(2126095,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:15:14','',''),(2126132,'1','152','757',316,'Retail Sale Id 1262641',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 11:16:58','',''),(2126133,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 11:16:58','',''),(2126204,'1','152','757',316,'Retail Sale Id 1262679',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 11:21:01','',''),(2126205,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:21:01','',''),(2126320,'1','152','757',316,'Retail Sale Id 1262737',5152.00,0.00,0.00,0.00,305.90,'2021-12-02 11:27:56','',''),(2126321,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.05,0.00,'2021-12-02 11:27:56','',''),(2126542,'1','152','757',316,'Retail Sale Id 1262822',73920.00,0.00,0.00,0.00,1680.00,'2021-12-02 11:37:33','',''),(2126543,'1','152','757',316,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-02 11:37:33','',''),(2126587,'1','152','757',316,'Retail Sale Id 1262841',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 11:39:41','',''),(2126588,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:39:41','',''),(2126907,'1','152','757',316,'Retail Sale Id 1263008',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 12:05:39','',''),(2126908,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 12:05:39','',''),(2126922,'1','152','757',316,'Retail Sale Id 1263016',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:07:25','',''),(2126923,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:07:25','',''),(2127023,'1','152','757',316,'Retail Sale Id 1263065',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 12:16:56','',''),(2127024,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:16:56','',''),(2127148,'1','152','757',316,'Retail Sale Id 1263128',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 12:25:56','',''),(2127149,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 12:25:56','',''),(2127198,'1','152','757',316,'Retail Sale Id 1263154',3148.80,0.00,0.00,0.00,186.96,'2021-12-02 12:29:58','',''),(2127199,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.92,0.00,'2021-12-02 12:29:58','',''),(2127216,'1','152','757',316,'Retail Sale Id 1263181',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:31:10','',''),(2127217,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:31:10','',''),(2127372,'1','152','757',316,'Retail Sale Id 1263263',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 12:43:45','',''),(2127373,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 12:43:45','',''),(2127423,'1','152','757',316,'Retail Sale Id 1263283',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 12:47:27','',''),(2127424,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:47:27','',''),(2127506,'1','152','757',316,'Retail Sale Id 1263318',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 12:53:05','',''),(2127507,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 12:53:05','',''),(2127516,'1','152','757',316,'Retail Sale Id 1263322',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:54:12','',''),(2127517,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:54:12','',''),(2127606,'1','152','757',316,'Retail Sale Id 1263364',640.00,0.00,0.00,0.00,38.00,'2021-12-02 13:00:48','',''),(2127607,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 13:00:48','',''),(2127833,'1','152','757',316,'Retail Sale Id 1263473',5497.60,0.00,0.00,0.00,326.42,'2021-12-02 13:15:58','',''),(2127834,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-02 13:15:58','',''),(2127931,'1','152','757',316,'Retail Sale Id 1263514',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 13:22:48','',''),(2127932,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 13:22:48','',''),(2127951,'1','152','757',316,'Retail Sale Id 1263520',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 13:24:04','',''),(2127952,'1','152','757',316,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:24:04','',''),(2128001,'1','152','757',316,'Retail Sale Id 1263536',998.40,0.00,0.00,0.00,59.28,'2021-12-02 13:26:41','',''),(2128002,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 13:26:41','',''),(2128025,'1','152','757',316,'Retail Sale Id 1263546',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 13:28:05','',''),(2128026,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:28:05','',''),(2128154,'1','152','757',316,'Retail Sale Id 1263603',2899.20,0.00,0.00,0.00,172.14,'2021-12-02 13:38:27','',''),(2128155,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-02 13:38:27','',''),(2128246,'1','152','757',316,'Retail Sale Id 1263637',697.60,0.00,0.00,0.00,41.42,'2021-12-02 13:43:49','',''),(2128247,'1','152','757',316,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 13:43:49','',''),(2128314,'1','152','757',316,'Retail Sale Id 1263678',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 13:47:52','',''),(2128315,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:47:52','',''),(2128350,'1','152','757',316,'Retail Sale Id 1263690',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 13:49:04','',''),(2128351,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 13:49:04','',''),(2128411,'1','152','757',316,'Retail Sale Id 1263721',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 13:53:26','',''),(2128412,'1','152','757',316,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 13:53:26','',''),(2128652,'1','152','757',316,'Retail Sale Id 1263825',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:06:56','',''),(2128653,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:06:56','',''),(2128694,'1','152','757',316,'Retail Sale Id 1263848',2297.60,0.00,0.00,0.00,136.42,'2021-12-02 14:09:52','',''),(2128695,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-02 14:09:52','',''),(2128935,'1','152','757',316,'Retail Sale Id 1263956',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:22:32','',''),(2128936,'1','152','757',316,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:22:32','',''),(2129011,'1','152','757',316,'Retail Sale Id 1263980',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:25:29','',''),(2129012,'1','152','757',316,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:25:29','',''),(2129053,'1','152','757',316,'Retail Sale Id 1263989',499.20,0.00,0.00,0.00,29.64,'2021-12-02 14:26:39','',''),(2129054,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 14:26:39','',''),(2129112,'1','152','757',316,'Retail Sale Id 1264009',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 14:28:23','',''),(2129113,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:28:23','',''),(2129335,'1','152','757',316,'Retail Sale Id 1264099',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 14:39:03','',''),(2129336,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 14:39:03','',''),(2130052,'1','152','757',316,'Retail Sale Id 1264456',3251.20,0.00,0.00,0.00,193.04,'2021-12-02 15:20:56','',''),(2130053,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.08,0.00,'2021-12-02 15:20:56','',''),(2130090,'1','152','757',316,'Retail Sale Id 1264477',1600.00,0.00,0.00,0.00,95.00,'2021-12-02 15:23:20','',''),(2130091,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 15:23:20','',''),(2130116,'1','152','757',316,'Retail Sale Id 1264487',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 15:24:04','',''),(2130117,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 15:24:04','',''),(2130134,'1','152','757',316,'Retail Sale Id 1264496',15400.00,0.00,0.00,0.00,350.00,'2021-12-02 15:25:12','',''),(2130135,'1','152','757',316,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 15:25:12','',''),(2130164,'1','152','757',316,'Retail Sale Id 1264509',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 15:26:09','',''),(2130165,'1','152','757',316,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 15:26:09','',''),(2130184,'1','152','757',316,'Retail Sale Id 1264520',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:27:18','',''),(2130185,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:27:18','',''),(2130213,'1','152','757',316,'Retail Sale Id 1264532',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:28:17','',''),(2130214,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:28:17','',''),(2130251,'1','152','757',316,'Retail Sale Id 1264548',601.60,0.00,0.00,0.00,35.72,'2021-12-02 15:29:41','',''),(2130252,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-02 15:29:41','',''),(2130275,'1','152','757',316,'Retail Sale Id 1264562',403.20,0.00,0.00,0.00,23.94,'2021-12-02 15:30:46','',''),(2130276,'1','152','757',316,'Retail sales',0.00,0.00,0.00,0.63,0.00,'2021-12-02 15:30:46','',''),(2130406,'1','152','757',316,'Retail Sale Id 1264623',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 15:36:46','',''),(2130407,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:36:46','',''),(2130492,'1','152','757',316,'Retail Sale Id 1264666',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 15:41:08','',''),(2130493,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 15:41:08','',''),(2130546,'1','152','757',316,'Retail Sale Id 1264701',5760.00,0.00,0.00,0.00,342.00,'2021-12-02 15:43:28','',''),(2130547,'1','152','757',316,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:43:28','',''),(2130588,'1','152','757',316,'Retail Sale Id 1264725',1848.00,0.00,0.00,0.00,42.00,'2021-12-02 15:45:11','',''),(2130589,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:45:11','',''),(2130640,'1','152','757',316,'Retail Sale Id 1264752',5600.00,0.00,0.00,0.00,332.50,'2021-12-02 15:47:35','',''),(2130641,'1','152','757',316,'Retail sales',0.00,0.00,0.00,8.75,0.00,'2021-12-02 15:47:35','',''),(2130728,'1','152','757',316,'Retail Sale Id 1264800',3603.20,0.00,0.00,0.00,213.94,'2021-12-02 15:51:35','',''),(2130729,'1','152','757',316,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-02 15:51:35','',''),(2130928,'1','152','757',316,'Retail Sale Id 1264903',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:00:17','',''),(2130929,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:00:17','',''),(2130942,'1','152','757',316,'Retail Sale Id 1264911',2297.60,0.00,0.00,0.00,136.42,'2021-12-02 16:01:06','',''),(2130943,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-02 16:01:06','',''),(2130994,'1','152','757',316,'Retail Sale Id 1264932',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 16:02:59','',''),(2130995,'1','152','757',316,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 16:02:59','',''),(2131018,'1','152','757',316,'Retail Sale Id 1264944',2400.00,0.00,0.00,0.00,142.50,'2021-12-02 16:04:08','',''),(2131019,'1','152','757',316,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-02 16:04: