-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_151
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_151`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_151` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_151`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3217 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2517,20008,'',0,'20','1','151','SALES','','2020-07-08 22:16:17',5,0.00,0.00,'','490','2020-07-08 22:16:17','490',0,1),(2518,40007,'',0,'6.1','1','151','CASH','','2020-07-08 22:16:52',5,0.00,0.00,'','490','2020-07-08 22:16:52','490',0,1),(2519,400072,'',0,'24','1','151','Salaries & Wages','','2020-07-08 22:22:53',5,0.00,0.00,'','490','2020-07-08 22:22:53','490',0,1),(2520,400073,'',0,'24','1','151','PURCHASES','','2020-07-08 22:24:49',5,0.00,0.00,'','490','2020-07-08 22:24:49','490',0,1),(2521,400197,'',0,'2','1','151','ZNB E-BILLS:1015372548','','2020-07-08 22:39:36',5,0.00,0.00,'','490','2020-07-08 22:39:36','490',0,1),(2522,400198,'',0,'2','1','151','ZBN(POS):1015965368','','2020-07-08 22:41:39',5,0.00,0.00,'','490','2020-07-08 22:41:39','490',0,1),(2910,400327,'',0,'2','1','151','DANKANO-EBILLS(ZNB:1014717618)','KANO','2020-10-29 14:04:01',5,0.00,0.00,'','489','2020-10-29 14:04:01','489',0,1),(3214,400493,'',0,'2','1','151','FID POS COLLECTION-5620141491','','2021-02-26 16:05:49',5,0.00,0.00,'','489','2021-02-26 16:05:49','489',0,1),(3215,400494,'',0,'2','1','151','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:20:26',5,0.00,0.00,'','792','2023-02-20 14:20:26','792',0,0),(3216,400495,'',0,'2','1','151','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:29:54',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:35:04','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1757 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1755,'','1','151','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 14:03:22',5,'489','2020-10-29 14:03:22','489'),(1756,'','1','151','BOMPAI LPG','BOMPAI LPG','00000000000','abdulhameed3617@gmail.com','KANO','KANO','BOMPAI LPG','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-12-04 13:23:03',5,'909','2022-12-04 13:23:03','909');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16358 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','151',15065,'755',3614.00,1000.00,'2021-05-24','','2021-05-24 20:39:36','483','483',2021,'483','2021-05-24 20:39:36',5),('1','151',16356,'755',-732.13,4500.00,'2021-09-08','new dipping','2021-09-08 17:59:38','483','483',2021,'483','2021-09-08 17:59:38',5),('1','151',16357,'755',5727.65,1000.00,'2022-07-15','new','2022-07-15 09:05:26','483','483',2022,'483','2022-07-15 09:05:26',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2121 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','151','755',2119,'5','LPG NOZZLE 1',2443982.65,'LPG DESPENSER','',NULL,NULL,'',5,'2022-02-03 06:37:05','483'),('1','151','755',2120,'5','LPG NOZZLE 2',1727932.25,'LPG DESPENSER','',NULL,NULL,'',5,'2022-02-03 06:37:41','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258004 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','151',142624,'Daily Shift','2020-06-30','2020-06-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-10 10:41:22','490','2020-07-10 10:43:05',10,0),('1','151',143134,'Daily Shift','2020-07-01','2020-07-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-15 14:21:50','490','2020-07-15 14:23:08',10,0),('1','151',143510,'DAILYSHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-17 10:34:32','490','2020-07-17 10:35:03',10,0),('1','151',143520,'DAILYSHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-17 11:17:45','490','2020-07-17 11:18:16',10,0),('1','151',143524,'DAILYSHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'490',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',2,0),('1','151',143648,'DAILYSHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'490',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',2,0),('1','151',143655,'DAILYSHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 12:22:13','490','2020-07-18 12:23:18',10,0),('1','151',143664,'DAILYSHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 13:10:21','490','2020-07-18 13:10:56',10,0),('1','151',143680,'DAILYSHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 13:47:22','490','2020-07-18 13:48:21',10,0),('1','151',143691,'DAILYSHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 14:06:13','490','2020-07-18 14:06:47',10,0),('1','151',143697,'DAILYSHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 14:53:47','490','2020-07-18 14:54:12',10,0),('1','151',143715,'DAILYSHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 15:15:34','490','2020-07-18 15:16:28',10,0),('1','151',143738,'DAILYSHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-18 19:13:58','490','2020-07-18 19:14:27',10,0),('1','151',143828,'DAILYSHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 13:36:24','490','2020-07-19 13:36:53',10,0),('1','151',143831,'DAILYSHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 13:48:03','490','2020-07-19 13:48:27',10,0),('1','151',143836,'DAILYSHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 14:07:09','490','2020-07-19 14:08:12',10,0),('1','151',143841,'DAILYSHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 14:52:11','490','2020-07-19 14:53:09',10,0),('1','151',143855,'DAILYSHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 15:53:24','490','2020-07-19 15:53:58',10,0),('1','151',143861,'DAILYSHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 16:14:15','490','2020-07-19 16:14:51',10,0),('1','151',143863,'DAILYSHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 16:36:57','490','2020-07-19 16:38:00',10,0),('1','151',143868,'DAILYSHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 16:57:00','490','2020-07-19 16:57:21',10,0),('1','151',143871,'DAILYSHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 17:16:20','490','2020-07-19 17:16:43',10,0),('1','151',143876,'DAILYSHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 17:29:57','490','2020-07-19 17:32:43',10,0),('1','151',143882,'DAILYSHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 17:59:36','490','2020-07-19 18:00:40',10,0),('1','151',143886,'DAILYSHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 19:12:38','490','2020-07-19 19:13:01',10,0),('1','151',143890,'DAILYSHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 19:42:58','490','2020-07-19 19:43:23',10,0),('1','151',143892,'DAILYSHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 19:59:27','490','2020-07-19 20:00:03',10,0),('1','151',143894,'DAILYSHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-19 20:19:40','490','2020-07-19 20:20:03',10,0),('1','151',143955,'DAILYSHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 12:25:03','490','2020-07-20 12:27:38',10,0),('1','151',143962,'DAILYSHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 12:50:08','490','2020-07-20 12:50:58',10,0),('1','151',143992,'DAILYSHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 14:25:37','490','2020-07-20 14:26:50',10,0),('1','151',143997,'DAILYSHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 14:45:03','490','2020-07-20 14:46:32',10,0),('1','151',144004,'DAILYSHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 15:05:15','490','2020-07-20 15:05:36',10,0),('1','151',144007,'DAILYSHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 15:24:04','490','2020-07-20 15:24:31',10,0),('1','151',144008,'DAILYSHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 15:45:09','490','2020-07-20 15:45:43',10,0),('1','151',144011,'DAILYSHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-20 15:57:55','490','2020-07-20 15:58:23',10,0),('1','151',144087,'DAILYSHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-21 13:14:05','490','2020-07-21 13:14:38',10,0),('1','151',144122,'DAILYSHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-22 15:40:05','490','2020-07-22 15:40:26',10,0),('1','151',144285,'DAILYSHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-22 15:55:33','490','2020-07-22 15:55:50',10,0),('1','151',144303,'DAILYSHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-22 19:31:42','490','2020-07-22 19:32:23',10,0),('1','151',144435,'DAILYSHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-23 17:44:08','490','2020-07-23 17:44:52',10,0),('1','151',144587,'DAILYSHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-24 19:23:59','490','2020-07-24 19:24:37',10,0),('1','151',144721,'DAILYSHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-25 19:03:50','490','2020-07-25 19:06:08',10,0),('1','151',144724,'DAILYSHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-25 19:27:57','490','2020-07-25 19:38:20',10,0),('1','151',144831,'DAILYSHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-26 19:51:33','490','2020-07-26 19:52:02',10,0),('1','151',144901,'DAILYSHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-27 12:28:53','490','2020-07-27 12:29:15',10,0),('1','151',144988,'DAILYSHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-27 19:52:44','490','2020-07-27 19:53:25',10,0),('1','151',145267,'DAILYSHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-30 11:08:10','490','2020-07-30 11:08:49',10,0),('1','151',145269,'DAILYSHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-30 11:26:15','490','2020-07-30 11:26:42',10,0),('1','151',145273,'DAILYSHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-30 11:47:04','490','2020-07-30 11:47:28',10,0),('1','151',145299,'DAILYSHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-30 13:59:02','490','2020-07-30 13:59:25',10,0),('1','151',145327,'DAILYSHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-30 15:54:02','490','2020-07-30 15:54:26',10,0),('1','151',145408,'DAILYSHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-31 20:42:52','490','2020-07-31 20:43:33',10,0),('1','151',145409,'DAILYSHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'490',0.00,0.00,'490','2020-07-31 21:00:41','490','2020-07-31 21:01:23',10,0),('1','151',145466,'DAILYSHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-01 18:48:07','490','2020-08-01 18:48:30',10,0),('1','151',146034,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-05 14:43:04','490','2020-08-05 14:43:26',10,0),('1','151',146042,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-05 15:00:00','490','2020-08-05 15:00:25',10,0),('1','151',146046,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-05 15:13:39','490','2020-08-05 15:14:44',10,0),('1','151',146049,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-05 15:26:15','490','2020-08-05 15:26:46',10,0),('1','151',146774,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 10:38:09','490','2020-08-11 10:38:37',10,0),('1','151',146781,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 11:02:25','490','2020-08-11 11:03:14',10,0),('1','151',146789,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 11:24:23','490','2020-08-11 11:24:58',10,0),('1','151',146793,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 11:37:25','490','2020-08-11 11:37:55',10,0),('1','151',146797,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 12:28:43','490','2020-08-11 12:29:08',10,0),('1','151',146806,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 12:42:35','490','2020-08-11 12:43:01',10,0),('1','151',146816,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 13:42:37','490','2020-08-11 13:44:01',10,0),('1','151',146871,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-11 18:52:19','490','2020-08-11 18:52:39',10,0),('1','151',147166,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-13 10:18:15','490','2020-08-13 10:20:12',10,0),('1','151',147344,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-14 10:33:45','490','2020-08-14 10:34:07',10,0),('1','151',147372,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-14 14:13:27','490','2020-08-14 14:14:03',10,0),('1','151',147480,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-15 10:41:09','490','2020-08-15 10:41:34',10,0),('1','151',147560,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-15 19:24:40','490','2020-08-15 19:25:32',10,0),('1','151',147688,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-16 19:34:57','490','2020-08-16 19:35:21',10,0),('1','151',147822,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-17 15:35:29','490','2020-08-17 15:35:48',10,0),('1','151',147867,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-17 19:37:59','490','2020-08-17 19:38:27',10,0),('1','151',147987,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-18 19:13:43','490','2020-08-18 19:14:29',10,0),('1','151',148129,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-19 19:38:20','490','2020-08-19 19:38:46',10,0),('1','151',148284,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-20 20:40:56','490','2020-08-20 20:41:59',10,0),('1','151',148286,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-20 21:06:07','490','2020-08-20 21:07:41',10,0),('1','151',148429,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-21 19:31:08','490','2020-08-21 19:31:27',10,0),('1','151',148539,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-22 17:15:49','490','2020-08-22 17:16:09',10,0),('1','151',148559,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-22 19:48:13','490','2020-08-22 19:48:31',10,0),('1','151',148666,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-23 19:39:17','490','2020-08-23 19:39:36',10,0),('1','151',148668,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-23 19:53:19','490','2020-08-23 19:53:41',10,0),('1','151',148806,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-24 18:43:43','490','2020-08-24 18:44:44',10,0),('1','151',148964,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-25 18:57:49','490','2020-08-25 18:58:23',10,0),('1','151',149047,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-26 12:55:51','490','2020-08-26 12:56:11',10,0),('1','151',149144,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-26 18:40:33','490','2020-08-26 18:40:55',10,0),('1','151',149299,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-27 18:48:14','490','2020-08-27 18:48:36',10,0),('1','151',149442,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-28 18:38:43','490','2020-08-28 18:39:47',10,0),('1','151',149669,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-30 15:44:24','490','2020-08-30 15:44:50',10,0),('1','151',149673,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-30 16:16:52','490','2020-08-30 16:17:15',10,0),('1','151',149674,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-30 16:28:02','490','2020-08-30 16:28:25',10,0),('1','151',149842,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'490',0.00,0.00,'490','2020-08-31 19:16:20','490','2020-08-31 19:16:53',10,0),('1','151',149917,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-01 11:37:28','490','2020-09-01 11:38:09',10,0),('1','151',150018,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-01 22:20:23','490','2020-09-01 22:20:55',10,0),('1','151',150135,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-02 18:21:12','490','2020-09-02 18:21:31',10,0),('1','151',150373,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-03 18:38:43','490','2020-09-03 18:39:07',10,0),('1','151',150545,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-04 20:13:21','490','2020-09-04 20:14:16',10,0),('1','151',150707,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-05 18:47:15','490','2020-09-05 18:47:41',10,0),('1','151',150845,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-06 20:47:38','490','2020-09-06 20:48:51',10,0),('1','151',150899,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-07 11:27:50','490','2020-09-07 11:28:17',10,0),('1','151',150988,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-07 18:53:58','490','2020-09-07 18:54:18',10,0),('1','151',151153,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-08 21:26:58','490','2020-09-08 21:27:18',10,0),('1','151',151279,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-09 19:20:37','490','2020-09-09 19:20:58',10,0),('1','151',151415,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-10 17:28:37','490','2020-09-10 17:29:09',10,0),('1','151',151487,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-11 10:42:47','490','2020-09-11 10:43:38',10,0),('1','151',151583,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-11 18:57:41','490','2020-09-11 18:58:13',10,0),('1','151',151697,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-12 19:12:01','490','2020-09-12 19:12:25',10,0),('1','151',151790,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-13 15:07:53','490','2020-09-13 15:08:20',10,0),('1','151',151817,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-13 19:18:07','490','2020-09-13 19:18:25',10,0),('1','151',151925,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-14 14:15:55','490','2020-09-14 14:17:10',10,0),('1','151',152007,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-14 19:37:53','490','2020-09-14 19:39:23',10,0),('1','151',152056,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-15 10:36:24','490','2020-09-15 10:37:03',10,0),('1','151',152163,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-15 20:14:49','490','2020-09-15 20:15:17',10,0),('1','151',152268,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-16 14:08:15','490','2020-09-16 14:09:12',10,0),('1','151',152376,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-17 11:20:57','490','2020-09-17 11:21:19',10,0),('1','151',152426,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-17 15:25:01','490','2020-09-17 15:25:33',10,0),('1','151',152612,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-18 19:18:50','490','2020-09-18 19:19:21',10,0),('1','151',152759,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-19 19:18:52','490','2020-09-19 19:19:16',10,0),('1','151',152761,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-19 19:32:47','490','2020-09-19 19:34:16',10,0),('1','151',152763,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-19 19:39:52','490','2020-09-19 19:40:15',10,0),('1','151',152886,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-20 18:43:20','490','2020-09-20 18:45:03',10,0),('1','151',153026,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-21 14:54:26','490','2020-09-21 14:54:49',10,0),('1','151',153032,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-21 15:12:53','490','2020-09-21 15:13:16',10,0),('1','151',153081,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-21 19:16:48','490','2020-09-21 19:17:06',10,0),('1','151',153265,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-22 19:25:18','490','2020-09-22 19:25:55',10,0),('1','151',153471,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-23 19:39:34','490','2020-09-23 19:39:57',10,0),('1','151',153630,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-24 18:06:38','490','2020-09-24 18:07:15',10,0),('1','151',153636,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-24 19:04:30','490','2020-09-24 19:05:03',10,0),('1','151',153798,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-25 18:34:55','490','2020-09-25 18:35:13',10,0),('1','151',153924,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-26 20:22:04','490','2020-09-26 20:22:49',10,0),('1','151',153927,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-26 20:42:52','490','2020-09-26 20:44:42',10,0),('1','151',154013,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-27 14:17:15','490','2020-09-27 14:18:02',10,0),('1','151',154034,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-27 16:33:59','490','2020-09-27 16:34:15',10,0),('1','151',154295,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-29 10:12:35','490','2020-09-29 10:13:20',10,0),('1','151',154413,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-29 20:46:43','490','2020-09-29 20:47:26',10,0),('1','151',154572,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-09-30 18:03:02','490','2020-09-30 18:03:20',10,0),('1','151',154863,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-02 18:26:36','490','2020-10-02 18:26:59',10,0),('1','151',154961,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-03 13:08:15','490','2020-10-03 13:08:42',10,0),('1','151',155016,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-03 19:12:37','490','2020-10-03 19:13:43',10,0),('1','151',155116,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-04 16:13:46','490','2020-10-04 16:14:15',10,0),('1','151',155135,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-04 20:31:09','490','2020-10-04 20:31:31',10,0),('1','151',155279,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-05 17:21:25','490','2020-10-05 17:22:00',10,0),('1','151',155297,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-05 18:35:53','490','2020-10-05 18:40:50',10,0),('1','151',155487,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-07 09:13:35','490','2020-10-07 09:13:55',10,0),('1','151',155580,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-07 14:53:35','490','2020-10-07 14:54:04',10,0),('1','151',155593,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-07 19:18:18','490','2020-10-07 19:19:01',10,0),('1','151',155784,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-08 21:16:21','490','2020-10-08 21:16:46',10,0),('1','151',155785,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-08 21:44:08','490','2020-10-08 21:44:37',10,0),('1','151',155931,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-09 19:59:26','490','2020-10-09 19:59:49',10,0),('1','151',155976,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-10 10:10:16','490','2020-10-10 10:10:37',10,0),('1','151',156061,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-10 16:53:15','490','2020-10-10 16:53:39',10,0),('1','151',156063,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-10 19:59:10','490','2020-10-10 19:59:59',10,0),('1','151',156200,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-11 18:59:08','490','2020-10-11 18:59:28',10,0),('1','151',156260,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-12 09:40:59','490','2020-10-12 09:41:35',10,0),('1','151',156267,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-12 21:01:48','490','2020-10-12 21:02:13',10,0),('1','151',156565,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-13 18:33:05','490','2020-10-13 18:33:22',10,0),('1','151',156571,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-13 18:57:55','490','2020-10-13 18:58:12',10,0),('1','151',156741,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-14 22:41:07','490','2020-10-14 22:41:47',10,0),('1','151',156806,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-15 12:38:24','490','2020-10-15 12:39:05',10,0),('1','151',156899,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-15 19:11:45','490','2020-10-15 19:12:07',10,0),('1','151',157045,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-16 16:35:55','490','2020-10-16 16:36:23',10,0),('1','151',157135,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-17 10:17:26','490','2020-10-17 10:17:49',10,0),('1','151',157140,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-17 10:26:32','490','2020-10-17 10:26:51',10,0),('1','151',157269,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-17 19:01:15','490','2020-10-17 19:01:36',10,0),('1','151',157437,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-18 17:53:03','490','2020-10-18 17:53:22',10,0),('1','151',157446,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-18 19:13:30','490','2020-10-18 19:13:54',10,0),('1','151',157569,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-19 14:15:56','490','2020-10-19 14:16:30',10,0),('1','151',157574,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-19 19:36:26','490','2020-10-19 19:36:46',10,0),('1','151',157774,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-20 15:09:06','490','2020-10-20 15:09:28',10,0),('1','151',157810,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-20 18:25:14','490','2020-10-20 18:25:38',10,0),('1','151',157948,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-21 19:11:24','490','2020-10-21 19:11:42',10,0),('1','151',158035,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-22 14:09:04','490','2020-10-22 14:09:32',10,0),('1','151',158054,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-22 19:17:18','490','2020-10-22 19:17:35',10,0),('1','151',158170,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-23 13:39:56','490','2020-10-23 13:40:34',10,0),('1','151',158263,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-23 22:47:17','490','2020-10-23 22:47:46',10,0),('1','151',158436,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-25 08:27:22','490','2020-10-25 08:27:53',10,0),('1','151',158439,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-25 08:57:18','490','2020-10-25 08:57:46',10,0),('1','151',158564,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-25 17:59:56','490','2020-10-25 18:00:15',10,0),('1','151',158733,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-26 18:27:33','490','2020-10-26 18:28:32',10,0),('1','151',158824,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-27 10:23:57','490','2020-10-27 10:24:16',10,0),('1','151',158826,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-27 19:16:18','490','2020-10-27 19:16:44',10,0),('1','151',159105,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-28 18:08:45','490','2020-10-28 18:09:05',10,0),('1','151',159111,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-28 19:22:54','490','2020-10-28 19:23:25',10,0),('1','151',159268,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-29 19:04:42','490','2020-10-29 19:05:16',10,0),('1','151',159271,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-29 19:12:57','490','2020-10-29 19:14:16',10,0),('1','151',159275,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-29 20:20:46','490','2020-10-29 20:22:09',10,0),('1','151',159443,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-30 17:49:31','490','2020-10-30 17:49:53',10,0),('1','151',159447,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-30 19:10:56','490','2020-10-30 19:11:23',10,0),('1','151',159636,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'490',0.00,0.00,'490','2020-10-31 20:52:48','490','2020-10-31 20:53:16',10,0),('1','151',159736,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-01 20:08:52','490','2020-11-01 20:09:27',10,0),('1','151',159889,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-02 15:43:19','490','2020-11-02 15:44:06',10,0),('1','151',159893,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-02 18:37:43','490','2020-11-02 18:38:01',10,0),('1','151',160028,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-03 11:44:45','490','2020-11-03 11:45:05',10,0),('1','151',160127,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-03 19:11:42','490','2020-11-03 19:12:02',10,0),('1','151',160263,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-04 14:35:56','490','2020-11-04 14:38:12',10,0),('1','151',160271,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-04 18:56:16','490','2020-11-04 18:56:53',10,0),('1','151',160353,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-05 10:20:09','490','2020-11-05 10:20:39',10,0),('1','151',160588,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-06 18:44:39','490','2020-11-06 18:44:59',10,0),('1','151',160653,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-07 10:14:50','490','2020-11-07 10:15:06',10,0),('1','151',160686,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-07 19:42:45','490','2020-11-07 19:43:21',10,0),('1','151',160878,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-08 16:22:29','490','2020-11-08 16:22:54',10,0),('1','151',160894,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-08 19:51:57','490','2020-11-08 19:52:17',10,0),('1','151',161092,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-09 19:13:18','490','2020-11-09 19:13:39',10,0),('1','151',161185,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-10 18:38:09','490','2020-11-10 18:42:38',10,0),('1','151',161313,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-11 13:43:14','490','2020-11-11 13:43:54',10,0),('1','151',161458,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-11 18:35:56','490','2020-11-11 18:36:30',10,0),('1','151',161663,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-12 19:24:09','490','2020-11-12 19:24:29',10,0),('1','151',161823,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-13 15:52:14','490','2020-11-13 15:52:37',10,0),('1','151',161828,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-13 18:58:49','490','2020-11-13 18:59:37',10,0),('1','151',162023,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-14 16:27:24','490','2020-11-14 16:27:45',10,0),('1','151',162029,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-14 18:35:25','490','2020-11-14 18:35:54',10,0),('1','151',162244,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-15 20:01:02','490','2020-11-15 20:01:38',10,0),('1','151',162321,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'483',0.00,0.00,'490','2020-11-16 13:39:39','490','2020-11-16 13:40:00',10,0),('1','151',162380,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-16 19:01:02','490','2020-11-16 19:01:29',10,0),('1','151',162641,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-17 19:01:38','490','2020-11-17 19:01:56',10,0),('1','151',162643,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-17 19:15:14','490','2020-11-17 19:15:32',10,0),('1','151',162813,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-18 18:52:13','490','2020-11-18 18:52:33',10,0),('1','151',162905,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-19 11:47:55','490','2020-11-19 11:48:29',10,0),('1','151',162911,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-19 19:25:40','490','2020-11-19 19:26:03',10,0),('1','151',163194,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-20 17:44:03','490','2020-11-20 17:44:30',10,0),('1','151',163340,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-21 14:53:05','490','2020-11-21 14:53:27',10,0),('1','151',163342,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-21 17:27:08','490','2020-11-21 17:27:50',10,0),('1','151',163538,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-22 18:00:36','490','2020-11-22 18:00:58',10,0),('1','151',163539,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-22 18:24:02','490','2020-11-22 18:24:20',10,0),('1','151',163726,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-23 17:46:17','490','2020-11-23 17:46:35',10,0),('1','151',163786,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-24 10:03:59','490','2020-11-24 10:04:38',10,0),('1','151',163790,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-24 19:44:10','490','2020-11-24 19:44:27',10,0),('1','151',164063,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-25 16:36:25','490','2020-11-25 16:36:46',10,0),('1','151',164067,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-25 20:01:27','490','2020-11-25 20:01:54',10,0),('1','151',164248,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-26 17:29:44','490','2020-11-26 17:30:16',10,0),('1','151',164352,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-27 11:21:41','490','2020-11-27 11:22:02',10,0),('1','151',164448,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-27 20:54:27','490','2020-11-27 20:54:45',10,0),('1','151',164551,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-28 14:09:40','490','2020-11-28 14:10:16',10,0),('1','151',164605,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-28 19:58:52','490','2020-11-28 19:59:26',10,0),('1','151',164745,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-29 17:54:30','490','2020-11-29 17:54:47',10,0),('1','151',164814,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-30 10:07:49','490','2020-11-30 10:08:09',10,0),('1','151',164818,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-11-30 17:51:57','490','2020-11-30 17:52:19',10,0),('1','151',165084,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-01 15:44:34','490','2020-12-01 15:45:03',10,0),('1','151',165096,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-01 17:40:12','490','2020-12-01 17:40:33',10,0),('1','151',165268,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-02 16:49:44','490','2020-12-02 16:50:05',10,0),('1','151',165274,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-02 17:03:48','490','2020-12-02 17:04:22',10,0),('1','151',165448,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-03 21:52:30','490','2020-12-03 21:54:16',10,0),('1','151',165537,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-04 12:57:35','490','2020-12-04 13:00:27',10,0),('1','151',165604,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-04 18:02:32','490','2020-12-04 18:02:55',10,0),('1','151',165768,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-05 16:24:15','490','2020-12-05 16:27:13',10,0),('1','151',165772,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-05 18:38:03','490','2020-12-05 18:38:34',10,0),('1','151',165969,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-07 08:17:54','490','2020-12-07 08:18:19',10,0),('1','151',165978,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-07 08:38:46','490','2020-12-07 08:39:02',10,0),('1','151',165981,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-07 19:43:37','490','2020-12-07 19:43:58',10,0),('1','151',166260,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-08 13:27:04','490','2020-12-08 13:27:29',10,0),('1','151',166263,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-08 20:08:21','490','2020-12-08 20:08:51',10,0),('1','151',166507,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-09 22:28:18','490','2020-12-09 22:29:06',10,0),('1','151',166520,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-10 07:43:43','490','2020-12-10 07:46:33',10,0),('1','151',166523,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-10 17:46:47','490','2020-12-10 17:47:07',10,0),('1','151',166884,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-11 18:58:53','490','2020-12-11 18:59:14',10,0),('1','151',167030,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-12 18:07:40','490','2020-12-12 18:07:59',10,0),('1','151',167036,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-12 18:39:05','490','2020-12-12 18:39:24',10,0),('1','151',167173,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-13 17:59:25','490','2020-12-13 18:01:06',10,0),('1','151',167233,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-14 09:46:20','490','2020-12-14 09:46:39',10,0),('1','151',167240,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-14 17:43:03','490','2020-12-14 17:43:31',10,0),('1','151',167562,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-15 18:06:49','490','2020-12-15 18:07:14',10,0),('1','151',167733,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-16 19:13:06','490','2020-12-16 19:13:28',10,0),('1','151',167834,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-17 12:51:35','490','2020-12-17 12:51:53',10,0),('1','151',167838,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-17 17:38:34','490','2020-12-17 17:38:51',10,0),('1','151',168091,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-18 16:46:11','490','2020-12-18 16:46:31',10,0),('1','151',168167,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-19 10:39:37','490','2020-12-19 10:44:34',10,0),('1','151',168180,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-19 17:54:30','490','2020-12-19 17:54:48',10,0),('1','151',168385,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-20 15:18:29','490','2020-12-20 15:18:51',10,0),('1','151',168598,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-21 17:54:04','490','2020-12-21 17:54:22',10,0),('1','151',168690,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-22 12:08:15','490','2020-12-22 12:08:34',10,0),('1','151',168701,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-22 18:00:20','490','2020-12-22 18:00:49',10,0),('1','151',168929,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-23 18:24:23','490','2020-12-23 18:24:50',10,0),('1','151',169006,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-24 11:28:32','490','2020-12-24 11:29:19',10,0),('1','151',169014,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-24 17:48:40','490','2020-12-24 17:49:23',10,0),('1','151',169246,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-25 16:39:53','490','2020-12-25 16:40:20',10,0),('1','151',169249,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-25 18:22:46','490','2020-12-25 18:23:20',10,0),('1','151',169454,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-26 20:44:46','490','2020-12-26 20:45:14',10,0),('1','151',169518,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-27 13:38:45','490','2020-12-27 13:39:05',10,0),('1','151',169525,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-27 17:56:58','490','2020-12-27 17:57:20',10,0),('1','151',169762,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-28 17:59:02','490','2020-12-28 17:59:33',10,0),('1','151',169765,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-28 18:17:47','490','2020-12-28 18:28:29',10,0),('1','151',169919,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-29 18:26:48','490','2020-12-29 18:27:13',10,0),('1','151',169981,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-30 10:00:39','490','2020-12-30 10:01:00',10,0),('1','151',170035,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-30 17:46:04','490','2020-12-30 17:46:26',10,0),('1','151',170319,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'490',0.00,0.00,'490','2020-12-31 18:10:54','490','2020-12-31 18:11:15',10,0),('1','151',170501,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-01 22:36:20','490','2021-01-01 22:36:42',10,0),('1','151',170674,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-02 22:39:52','490','2021-01-02 22:40:21',10,0),('1','151',170676,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-02 23:03:44','490','2021-01-02 23:04:07',10,0),('1','151',170800,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-03 17:12:19','490','2021-01-03 17:12:53',10,0),('1','151',170974,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-04 18:14:13','490','2021-01-04 18:14:30',10,0),('1','151',171042,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-05 12:03:36','490','2021-01-05 12:04:06',10,0),('1','151',171155,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-05 18:58:34','490','2021-01-05 18:59:01',10,0),('1','151',171362,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-06 18:03:20','490','2021-01-06 18:03:39',10,0),('1','151',171417,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-07 17:58:51','490','2021-01-07 17:59:30',10,0),('1','151',171755,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-08 17:48:23','490','2021-01-08 17:48:50',10,0),('1','151',171955,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-09 21:39:45','490','2021-01-09 21:40:26',10,0),('1','151',172128,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-11 09:11:01','490','2021-01-11 09:12:07',10,0),('1','151',172135,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-11 21:15:15','490','2021-01-11 21:16:02',10,0),('1','151',172507,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-12 20:07:12','490','2021-01-12 20:07:32',10,0),('1','151',172578,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-13 19:33:34','490','2021-01-13 19:33:53',10,0),('1','151',172838,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-14 18:26:31','490','2021-01-14 18:27:16',10,0),('1','151',172897,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-15 12:36:53','490','2021-01-15 12:37:15',10,0),('1','151',172963,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-15 17:28:21','490','2021-01-15 17:28:47',10,0),('1','151',173205,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-16 18:49:07','490','2021-01-16 18:49:25',10,0),('1','151',173327,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-17 15:55:38','490','2021-01-17 15:56:25',10,0),('1','151',173332,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-19 18:22:07','490','2021-01-19 18:22:32',10,0),('1','151',173848,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-20 13:09:18','490','2021-01-20 13:09:49',10,0),('1','151',173860,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-20 17:59:12','490','2021-01-20 17:59:30',10,0),('1','151',174111,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-21 16:49:14','490','2021-01-21 16:49:32',10,0),('1','151',174295,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-22 17:33:12','490','2021-01-22 17:33:40',10,0),('1','151',174328,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-23 13:41:52','490','2021-01-23 13:45:33',10,0),('1','151',174424,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-23 18:49:21','490','2021-01-23 18:49:39',10,0),('1','151',174539,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-24 12:39:11','490','2021-01-24 12:39:32',10,0),('1','151',174541,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-24 18:04:10','490','2021-01-24 18:04:27',10,0),('1','151',174772,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-25 13:47:34','490','2021-01-25 13:48:04',10,0),('1','151',174805,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-25 15:58:44','490','2021-01-25 15:59:55',10,0),('1','151',174810,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-25 16:13:42','490','2021-01-25 16:14:08',10,0),('1','151',174946,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-26 13:02:36','490','2021-01-26 13:03:01',10,0),('1','151',174949,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-26 17:52:59','490','2021-01-26 17:53:46',10,0),('1','151',175149,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-27 13:21:50','490','2021-01-27 13:23:20',10,0),('1','151',175160,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-27 18:09:01','490','2021-01-27 18:09:23',10,0),('1','151',175308,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-28 13:09:12','490','2021-01-28 13:09:51',10,0),('1','151',175334,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-28 18:29:46','490','2021-01-28 18:30:51',10,0),('1','151',175470,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-29 12:53:03','490','2021-01-29 12:53:31',10,0),('1','151',175509,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-29 17:41:06','490','2021-01-29 17:41:33',10,0),('1','151',175676,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-30 13:45:14','490','2021-01-30 13:45:34',10,0),('1','151',175683,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-30 17:42:45','490','2021-01-30 17:43:11',10,0),('1','151',175876,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-31 15:15:25','490','2021-01-31 15:15:50',10,0),('1','151',175880,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-01-31 17:00:01','490','2021-01-31 17:00:24',10,0),('1','151',175974,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-01 16:59:22','490','2021-02-01 16:59:50',10,0),('1','151',176120,'DAY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-02 13:43:08','490','2021-02-02 13:43:46',10,0),('1','151',176262,'DAYLY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-02 15:15:14','490','2021-02-02 15:15:34',10,0),('1','151',176298,'DAILYSHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-02 16:50:25','490','2021-02-02 16:51:05',10,0),('1','151',176336,'DAYLY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-03 14:16:11','490','2021-02-03 14:16:56',10,0),('1','151',176476,'DAYLY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-03 17:45:08','490','2021-02-03 17:45:27',10,0),('1','151',176557,'DAYLY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-04 10:07:10','490','2021-02-04 10:07:51',10,0),('1','151',176642,'DAYLY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-04 17:51:53','490','2021-02-04 17:52:17',10,0),('1','151',176786,'DAYLY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-05 14:15:42','490','2021-02-05 14:16:08',10,0),('1','151',176969,'DAYLY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-06 06:21:35','490','2021-02-06 06:22:04',10,0),('1','151',176995,'DAYLY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-06 13:14:31','490','2021-02-06 13:14:59',10,0),('1','151',177106,'DAYLY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-06 18:24:39','490','2021-02-06 18:24:58',10,0),('1','151',177236,'DAYLY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-07 12:28:13','490','2021-02-07 12:28:40',10,0),('1','151',177330,'DAYLY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-07 18:46:39','490','2021-02-07 18:47:13',10,0),('1','151',177429,'DAYLY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-08 18:17:01','490','2021-02-08 18:17:29',10,0),('1','151',177631,'DAYLY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-09 10:29:31','490','2021-02-09 10:30:51',10,0),('1','151',177703,'DAYLY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-09 14:26:57','490','2021-02-09 14:27:33',10,0),('1','151',177789,'DAYLY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-09 18:30:15','490','2021-02-09 18:31:10',10,0),('1','151',177886,'DAYLY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-10 13:16:00','490','2021-02-10 13:16:16',10,0),('1','151',177986,'DAYLY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-10 15:19:09','490','2021-02-10 15:19:26',10,0),('1','151',178091,'DAYLY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-11 13:11:13','490','2021-02-11 13:11:39',10,0),('1','151',178192,'DAYLY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-11 18:11:00','490','2021-02-11 18:11:52',10,0),('1','151',178300,'DALY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-12 17:20:30','490','2021-02-12 17:20:58',10,0),('1','151',178459,'DALY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-12 17:42:13','490','2021-02-12 17:42:30',10,0),('1','151',178679,'DALY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-13 18:50:40','490','2021-02-13 18:51:10',10,0),('1','151',178725,'DAYLY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-14 09:19:49','490','2021-02-14 09:20:07',10,0),('1','151',178766,'DAYLY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-14 13:37:38','490','2021-02-14 13:38:08',10,0),('1','151',178821,'DAYLY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-14 21:55:57','490','2021-02-14 21:56:20',10,0),('1','151',178904,'DAYLY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-15 19:24:41','490','2021-02-15 19:25:17',10,0),('1','151',179142,'DAYLY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-16 13:28:05','490','2021-02-16 13:28:26',10,0),('1','151',179374,'DAYLY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-17 18:27:02','490','2021-02-17 18:27:19',10,0),('1','151',179570,'DAYLY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-18 15:54:31','490','2021-02-18 15:55:11',10,0),('1','151',179730,'DALY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-19 17:24:56','490','2021-02-19 17:25:15',10,0),('1','151',179988,'DAYLY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-20 12:01:15','490','2021-02-20 12:01:35',10,0),('1','151',180072,'DAYLY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-20 20:23:49','490','2021-02-20 20:24:09',10,0),('1','151',180168,'Daily Shift ','2021-02-21','2021-02-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-21 21:03:11','490','2021-02-21 21:03:30',10,0),('1','151',180341,'DAYLY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-22 17:38:13','490','2021-02-22 17:38:54',10,0),('1','151',180550,'DAYLY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-23 14:10:27','490','2021-02-23 14:11:46',10,0),('1','151',180656,'DAYLY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-23 17:42:06','490','2021-02-23 17:42:27',10,0),('1','151',180733,'DAYLY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-24 19:07:27','490','2021-02-24 19:08:14',10,0),('1','151',180951,'DALY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-25 10:17:14','490','2021-02-25 10:17:38',10,0),('1','151',181035,'DAILYSHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-25 18:26:10','490','2021-02-25 18:26:47',10,0),('1','151',181129,'DAYLY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-26 09:53:20','490','2021-02-26 09:53:46',10,0),('1','151',181236,'DAILYSHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-26 20:30:41','490','2021-02-26 20:30:54',10,0),('1','151',181376,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-27 17:29:35','490','2021-02-27 17:29:54',10,0),('1','151',181522,'DAYLY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-02-28 10:30:07','490','2021-02-28 10:30:35',10,0),('1','151',181577,'DAILYSHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-01 07:16:42','490','2021-03-01 07:17:06',10,0),('1','151',181721,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-01 17:05:51','490','2021-03-01 17:43:44',10,0),('1','151',181869,'DAILYSHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-01 18:02:38','490','2021-03-01 18:03:03',10,0),('1','151',181905,'DAYLY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-02 20:02:43','490','2021-03-02 20:03:06',10,0),('1','151',182101,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-03 09:42:27','490','2021-03-03 09:43:10',10,0),('1','151',182154,'DAILYSHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-03 18:17:41','490','2021-03-03 18:18:45',10,0),('1','151',182302,'DAYLY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-04 14:17:25','490','2021-03-04 14:19:40',10,0),('1','151',182508,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-05 18:06:14','490','2021-03-05 18:06:40',10,0),('1','151',182681,'DAYLY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-06 12:35:09','490','2021-03-06 12:35:54',10,0),('1','151',182767,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-07 09:44:09','490','2021-03-07 09:44:40',10,0),('1','151',182869,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-07 14:04:26','490','2021-03-07 14:04:51',10,0),('1','151',182921,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-07 17:39:58','490','2021-03-07 17:40:27',10,0),('1','151',182984,'DAYLY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-08 19:52:57','490','2021-03-08 19:53:22',10,0),('1','151',183209,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-09 08:23:52','490','2021-03-09 08:30:53',10,0),('1','151',183243,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-10 12:18:46','490','2021-03-10 12:19:19',10,0),('1','151',183524,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-10 16:21:10','490','2021-03-10 16:21:32',10,0),('1','151',183651,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-11 17:49:00','490','2021-03-11 17:49:49',10,0),('1','151',183877,'DAYLY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-12 16:15:22','490','2021-03-12 16:15:48',10,0),('1','151',184037,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-12 17:46:26','490','2021-03-12 17:46:47',10,0),('1','151',184069,'DAILYSHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-13 17:38:59','490','2021-03-13 17:39:22',10,0),('1','151',184264,'DAYLY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-14 11:54:25','490','2021-03-14 11:54:43',10,0),('1','151',184357,'DAILYSHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-14 17:32:13','490','2021-03-14 17:32:46',10,0),('1','151',184471,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-15 17:03:38','490','2021-03-15 17:04:16',10,0),('1','151',184678,'DAYLY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-16 17:00:26','490','2021-03-16 17:01:01',10,0),('1','151',184902,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-17 19:33:07','490','2021-03-17 19:33:32',10,0),('1','151',185099,'DAYLY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-18 15:09:25','490','2021-03-18 15:09:51',10,0),('1','151',185222,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-18 17:27:16','490','2021-03-18 17:27:43',10,0),('1','151',185265,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-19 18:17:04','490','2021-03-19 18:20:22',10,0),('1','151',185461,'DAYLY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-20 15:35:30','490','2021-03-20 15:37:22',10,0),('1','151',185597,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-20 17:28:32','490','2021-03-20 17:29:08',10,0),('1','151',185678,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-21 17:47:16','490','2021-03-21 17:51:55',10,0),('1','151',185865,'DAYLY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-22 14:59:36','490','2021-03-22 14:59:56',10,0),('1','151',186008,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-22 19:01:37','490','2021-03-22 19:02:11',10,0),('1','151',186099,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-23 18:02:02','490','2021-03-23 18:02:50',10,0),('1','151',186310,'DAYLY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-24 13:42:54','490','2021-03-24 13:43:15',10,0),('1','151',186442,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-24 17:35:48','490','2021-03-24 17:36:22',10,0),('1','151',186548,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-25 18:49:19','490','2021-03-25 18:49:42',10,0),('1','151',186749,'DAYLY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-26 12:52:52','490','2021-03-26 12:53:13',10,0),('1','151',186909,'DAYLY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-26 17:35:52','490','2021-03-26 17:39:19',10,0),('1','151',186979,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-27 15:44:42','490','2021-03-27 15:45:06',10,0),('1','151',187161,'DAYLY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-28 22:36:20','490','2021-03-28 22:37:26',10,0),('1','151',187344,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-29 12:51:03','490','2021-03-29 12:51:29',10,0),('1','151',187460,'DAILYSHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-29 19:25:29','490','2021-03-29 19:25:48',10,0),('1','151',187576,'DAYLY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-30 17:38:44','490','2021-03-30 17:39:15',10,0),('1','151',187788,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-03-31 17:27:11','490','2021-03-31 17:27:36',10,0),('1','151',188014,'DAYLY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-01 10:49:23','490','2021-04-01 10:50:34',10,0),('1','151',188102,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-01 18:55:27','490','2021-04-01 18:56:44',10,0),('1','151',188210,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-02 19:22:19','490','2021-04-02 19:22:55',10,0),('1','151',188421,'DAYLY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-03 17:58:49','490','2021-04-03 18:00:25',10,0),('1','151',188604,'DAYLY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-04 12:17:08','490','2021-04-04 12:17:34',10,0),('1','151',188685,'DAILYSHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-04 17:44:46','490','2021-04-04 18:05:02',10,0),('1','151',188801,'DAYLY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-05 12:04:44','490','2021-04-05 12:05:36',10,0),('1','151',188892,'DAILYSHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-05 20:28:04','490','2021-04-05 20:28:57',10,0),('1','151',189008,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-06 17:29:26','490','2021-04-06 17:30:00',10,0),('1','151',189194,'DAYLY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-07 17:54:00','490','2021-04-07 17:54:28',10,0),('1','151',189424,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-08 11:59:11','490','2021-04-08 11:59:31',10,0),('1','151',189514,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-08 19:16:41','490','2021-04-08 19:17:05',10,0),('1','151',189614,'DAYLY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-09 15:54:26','490','2021-04-09 15:55:01',10,0),('1','151',189759,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-09 18:13:51','490','2021-04-09 18:14:08',10,0),('1','151',189807,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-10 18:20:22','490','2021-04-10 18:22:29',10,0),('1','151',190028,'DAYLY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-11 10:28:07','490','2021-04-11 10:28:27',10,0),('1','151',190086,'DAILYSHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-11 16:09:05','490','2021-04-11 16:09:27',10,0),('1','151',190269,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-12 18:50:26','490','2021-04-12 18:50:52',10,0),('1','151',190434,'DAYLY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-13 09:17:12','490','2021-04-13 09:17:37',10,0),('1','151',190482,'DAILYSHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-13 18:37:40','490','2021-04-13 18:38:15',10,0),('1','151',190688,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-14 09:08:12','490','2021-04-14 09:08:32',10,0),('1','151',190706,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-14 18:25:21','490','2021-04-14 18:25:58',10,0),('1','151',190883,'DAYLY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-15 14:16:25','490','2021-04-15 14:17:03',10,0),('1','151',191014,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-15 18:21:24','490','2021-04-15 18:21:51',10,0),('1','151',191090,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-16 17:25:31','490','2021-04-16 17:25:52',10,0),('1','151',191288,'DAYLY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-17 15:29:08','490','2021-04-17 15:29:44',10,0),('1','151',191443,'DAILYSHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-17 17:33:43','490','2021-04-17 17:34:01',10,0),('1','151',191497,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-18 15:20:21','490','2021-04-18 15:21:08',10,0),('1','151',191707,'DAYLY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-19 18:48:59','490','2021-04-19 18:49:21',10,0),('1','151',191952,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-20 16:45:01','490','2021-04-20 16:45:38',10,0),('1','151',192131,'DAYLY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-21 18:27:41','490','2021-04-21 18:28:12',10,0),('1','151',192328,'DAILY SHIFT if','2021-04-22','2021-04-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-22 18:37:08','490','2021-04-22 18:37:28',10,0),('1','151',192565,'DAYLY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-23 10:40:35','490','2021-04-23 10:41:17',10,0),('1','151',192637,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-23 17:38:38','490','2021-04-23 17:40:39',10,0),('1','151',192776,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-24 18:26:06','490','2021-04-24 18:26:38',10,0),('1','151',192954,'DAYLY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-25 10:38:04','490','2021-04-25 10:38:33',10,0),('1','151',193021,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-25 18:35:23','490','2021-04-25 18:35:49',10,0),('1','151',193155,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-26 17:41:30','490','2021-04-26 17:42:33',10,0),('1','151',193405,'DAYLY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-27 10:17:56','490','2021-04-27 10:18:25',10,0),('1','151',193486,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-27 18:00:44','490','2021-04-27 18:01:23',10,0),('1','151',193645,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-28 17:40:12','490','2021-04-28 17:40:44',10,0),('1','151',193850,'DAYLY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-29 17:13:29','490','2021-04-29 17:14:22',10,0),('1','151',194067,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-04-30 18:13:07','490','2021-04-30 18:13:39',10,0),('1','151',194289,'DAYLY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-01 16:33:12','490','2021-05-01 16:34:05',10,0),('1','151',194529,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-02 17:34:19','490','2021-05-02 17:35:15',10,0),('1','151',194669,'abdulrahman kyauta adamu','2021-05-03','2021-05-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-03 13:02:41','490','2021-05-03 13:06:56',10,0),('1','151',194802,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-03 17:36:09','490','2021-05-03 17:37:07',10,0),('1','151',195017,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-04 18:42:57','490','2021-05-04 18:43:27',10,0),('1','151',195141,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-05 09:59:35','490','2021-05-05 10:00:03',10,0),('1','151',195189,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-05 18:29:55','490','2021-05-05 18:30:26',10,0),('1','151',195291,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-06 11:23:00','490','2021-05-06 11:23:26',10,0),('1','151',195399,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-06 17:22:49','490','2021-05-06 17:23:09',10,0),('1','151',195557,'DAYLY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-07 17:31:28','490','2021-05-07 17:32:30',10,0),('1','151',195790,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-08 20:32:58','490','2021-05-08 20:35:04',10,0),('1','151',196009,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-09 16:49:23','490','2021-05-09 16:50:21',10,0),('1','151',196212,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-10 18:18:24','490','2021-05-10 18:19:17',10,0),('1','151',196449,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-11 11:11:52','490','2021-05-11 11:13:01',10,0),('1','151',196545,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-11 18:33:26','490','2021-05-11 18:34:34',10,0),('1','151',196655,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-12 15:48:16','490','2021-05-12 15:48:57',10,0),('1','151',196815,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-12 18:12:13','490','2021-05-12 18:12:34',10,0),('1','151',196881,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-13 19:46:44','490','2021-05-13 19:48:08',10,0),('1','151',197025,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-14 13:50:04','490','2021-05-14 13:50:29',10,0),('1','151',197141,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-14 18:47:46','490','2021-05-14 18:48:13',10,0),('1','151',197679,'Daily Shift','2021-05-15','2021-05-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-17 13:03:23','490','2021-05-17 13:03:48',10,0),('1','151',197702,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-17 13:15:45','490','2021-05-17 13:16:09',10,0),('1','151',197708,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-17 13:25:20','490','2021-05-17 13:25:43',10,0),('1','151',197720,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-17 16:06:54','490','2021-05-17 16:07:32',10,0),('1','151',197895,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-18 19:35:28','490','2021-05-18 19:35:57',10,0),('1','151',198108,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-19 15:42:25','490','2021-05-19 15:43:01',10,0),('1','151',198372,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-20 20:10:09','490','2021-05-20 20:11:04',10,0),('1','151',198560,'Daily Shift ','2021-05-21','2021-05-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-21 13:47:46','490','2021-05-21 13:48:29',10,0),('1','151',198713,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-21 18:20:27','490','2021-05-21 18:20:51',10,0),('1','151',198792,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-22 18:36:20','490','2021-05-22 18:36:40',10,0),('1','151',198971,'DAILY SHIFT ','2021-05-23','2021-05-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-23 10:50:19','490','2021-05-23 10:50:57',10,0),('1','151',199069,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-23 18:26:46','490','2021-05-23 18:27:48',10,0),('1','151',199191,'DAILY SHIFT ','2021-05-24','2021-05-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-24 19:20:27','490','2021-05-24 19:28:07',10,0),('1','151',199433,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-25 18:46:33','490','2021-05-25 18:47:39',10,0),('1','151',199674,'DAILYSHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-26 14:05:36','490','2021-05-26 14:06:50',10,0),('1','151',199817,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-26 17:56:02','490','2021-05-26 17:56:21',10,0),('1','151',199867,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-27 14:57:12','490','2021-05-27 14:58:50',10,0),('1','151',200041,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-27 18:02:00','490','2021-05-27 18:03:06',10,0),('1','151',200091,'DAILY SHIFT ','2021-05-28','2021-05-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-28 18:27:48','490','2021-05-28 18:28:10',10,0),('1','151',200323,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-29 16:13:25','490','2021-05-29 16:13:54',10,0),('1','151',200441,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-30 17:38:25','490','2021-05-30 17:38:50',10,0),('1','151',200696,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-31 14:09:45','490','2021-05-31 14:10:40',10,0),('1','151',200875,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-05-31 18:21:01','490','2021-05-31 18:21:22',10,0),('1','151',200940,'DAILY SHIFT ','2021-06-01','2021-06-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-01 18:28:58','490','2021-06-01 18:31:37',10,0),('1','151',201113,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-02 10:49:02','490','2021-06-02 10:49:22',10,0),('1','151',201233,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-02 18:22:14','490','2021-06-02 18:22:34',10,0),('1','151',201296,'DAILY SHIFT ','2021-06-03','2021-06-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-03 17:00:36','490','2021-06-03 17:02:55',10,0),('1','151',201492,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-04 18:05:35','490','2021-06-04 18:06:04',10,0),('1','151',201759,'DAILY SHIFT ','2021-06-05','2021-06-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-05 11:00:22','490','2021-06-05 11:00:45',10,0),('1','151',201866,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-05 19:02:56','490','2021-06-05 19:03:19',10,0),('1','151',202032,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-06 12:54:33','490','2021-06-06 12:55:01',10,0),('1','151',202143,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-06 20:41:28','490','2021-06-06 20:41:53',10,0),('1','151',202210,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-07 18:57:36','490','2021-06-07 18:58:02',10,0),('1','151',202431,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-08 11:47:08','490','2021-06-08 11:47:33',10,0),('1','151',202525,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-08 17:54:27','490','2021-06-08 17:55:17',10,0),('1','151',202741,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-09 18:36:12','490','2021-06-09 18:36:39',10,0),('1','151',202835,'DAILY SHIFT ','2021-06-10','2021-06-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-10 09:53:06','490','2021-06-10 09:53:51',10,0),('1','151',202940,'DAILYSHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-10 18:00:56','490','2021-06-10 18:02:28',10,0),('1','151',203099,'DAILY SHIFT ','2021-06-11','2021-06-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-11 18:24:55','490','2021-06-11 18:25:33',10,0),('1','151',203306,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-12 17:27:43','490','2021-06-12 17:29:04',10,0),('1','151',203520,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-13 14:44:16','490','2021-06-13 14:45:14',10,0),('1','151',203660,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-13 21:03:14','490','2021-06-13 21:03:57',10,0),('1','151',203726,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-14 17:54:53','490','2021-06-14 17:56:16',10,0),('1','151',203949,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-15 11:33:36','490','2021-06-15 11:34:01',10,0),('1','151',204075,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-15 17:30:22','490','2021-06-15 17:31:38',10,0),('1','151',204186,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-16 14:11:39','490','2021-06-16 14:12:23',10,0),('1','151',204333,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-16 18:19:09','490','2021-06-16 18:19:33',10,0),('1','151',204393,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-17 20:40:56','490','2021-06-17 20:41:35',10,0),('1','151',204617,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-18 11:40:11','490','2021-06-18 11:40:40',10,0),('1','151',204722,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-18 18:36:53','490','2021-06-18 18:37:30',10,0),('1','151',204826,'DAILY SHIFT ','2021-06-19','2021-06-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-19 16:41:38','490','2021-06-19 16:43:07',10,0),('1','151',205042,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-20 18:30:17','490','2021-06-20 18:31:02',10,0),('1','151',205226,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-21 12:48:08','490','2021-06-21 12:49:34',10,0),('1','151',205360,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-21 17:55:57','490','2021-06-21 17:56:18',10,0),('1','151',205521,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-22 17:34:27','490','2021-06-22 17:35:18',10,0),('1','151',205744,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-23 21:52:25','490','2021-06-23 21:54:01',10,0),('1','151',205933,'DAILY SHIFT ','2021-06-24','2021-06-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-24 10:17:50','490','2021-06-24 10:18:30',10,0),('1','151',206025,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-24 18:02:58','490','2021-06-24 18:03:41',10,0),('1','151',206145,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-25 18:11:29','490','2021-06-25 18:11:53',10,0),('1','151',206419,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-26 10:51:57','490','2021-06-26 10:52:18',10,0),('1','151',206441,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-26 20:30:47','490','2021-06-26 20:32:12',10,0),('1','151',206576,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-27 16:22:52','490','2021-06-27 16:24:14',10,0),('1','151',206799,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-28 18:05:25','490','2021-06-28 18:08:56',10,0),('1','151',207096,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-29 18:01:15','490','2021-06-29 18:02:06',10,0),('1','151',207245,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-06-30 17:44:18','490','2021-06-30 17:45:17',10,0),('1','151',207536,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-01 10:45:38','490','2021-07-01 10:46:14',10,0),('1','151',207590,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-01 17:50:37','490','2021-07-01 17:52:12',10,0),('1','151',207700,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-02 19:16:08','490','2021-07-02 19:18:13',10,0),('1','151',207911,'DAILY SHIFT ','2021-07-03','2021-07-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-03 10:24:51','490','2021-07-03 10:25:29',10,0),('1','151',207997,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-03 23:17:04','490','2021-07-03 23:17:36',10,0),('1','151',208109,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-04 14:30:16','490','2021-07-04 14:30:54',10,0),('1','151',208260,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-04 22:46:53','490','2021-07-04 22:47:39',10,0),('1','151',208418,'DAILY SHIFT ','2021-07-05','2021-07-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-05 17:03:21','490','2021-07-05 17:04:45',10,0),('1','151',208564,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-06 17:46:45','490','2021-07-06 17:47:42',10,0),('1','151',208757,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-07 18:08:19','490','2021-07-07 18:08:55',10,0),('1','151',208996,'DAILY SHIFT ','2021-07-08','2021-07-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-08 15:38:08','490','2021-07-08 15:38:55',10,0),('1','151',209240,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-09 19:10:05','490','2021-07-10 07:16:01',10,0),('1','151',209457,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-10 12:15:00','490','2021-07-10 12:16:00',10,0),('1','151',209539,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-10 17:42:43','490','2021-07-10 17:43:22',10,0),('1','151',209641,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-11 21:30:06','490','2021-07-11 21:30:23',10,0),('1','151',209875,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-12 18:23:02','490','2021-07-12 18:23:38',10,0),('1','151',210142,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-13 10:00:33','490','2021-07-13 10:00:56',10,0),('1','151',210180,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-13 18:39:23','490','2021-07-13 18:40:30',10,0),('1','151',210307,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-15 19:07:12','490','2021-07-15 19:08:13',10,0),('1','151',210730,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-16 20:11:24','490','2021-07-16 20:12:59',10,0),('1','151',210984,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-17 12:24:14','490','2021-07-17 12:25:13',10,0),('1','151',211256,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-19 09:31:54','490','2021-07-19 09:35:23',10,0),('1','151',211449,'DAILYSHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-19 12:11:47','490','2021-07-19 12:12:29',10,0),('1','151',211501,'DAILYSHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-19 18:33:41','490','2021-07-19 18:34:15',10,0),('1','151',211611,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-20 13:38:12','490','2021-07-20 13:48:45',10,0),('1','151',211690,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-20 18:30:37','490','2021-07-20 18:32:11',10,0),('1','151',211781,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-21 17:45:25','490','2021-07-21 17:46:21',10,0),('1','151',212114,'DAILYSHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-22 17:42:27','490','2021-07-22 17:42:50',10,0),('1','151',212233,'DAILAY SHIFT ','2021-07-23','2021-07-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-23 12:52:27','490','2021-07-23 12:52:56',10,0),('1','151',212358,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-23 19:16:18','490','2021-07-23 19:16:42',10,0),('1','151',212455,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-24 17:41:17','490','2021-07-24 17:42:34',10,0),('1','151',212665,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-25 14:32:04','490','2021-07-25 14:35:26',10,0),('1','151',212799,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-25 17:39:21','490','2021-07-25 17:40:01',10,0),('1','151',212870,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-26 18:27:04','490','2021-07-26 18:28:20',10,0),('1','151',213272,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-27 12:14:19','490','2021-07-27 12:14:42',10,0),('1','151',213286,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-27 18:16:38','490','2021-07-27 18:17:13',10,0),('1','151',213392,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-28 16:26:52','490','2021-07-28 16:29:20',10,0),('1','151',213642,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-29 19:04:08','490','2021-07-29 19:06:53',10,0),('1','151',214016,'DAILYSHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-30 18:30:53','490','2021-07-30 18:32:11',10,0),('1','151',214121,'DAILY SHIFT ','2021-07-31','2021-07-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-07-31 16:08:40','490','2021-07-31 16:10:01',10,0),('1','151',214338,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-01 20:24:43','490','2021-08-01 20:26:00',10,0),('1','151',214611,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-02 10:04:55','490','2021-08-02 10:08:06',10,0),('1','151',214629,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-03 16:47:53','490','2021-08-03 16:49:17',10,0),('1','151',214961,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-03 18:10:25','490','2021-08-03 18:11:16',10,0),('1','151',215038,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-04 18:40:53','490','2021-08-04 18:41:35',10,0),('1','151',215316,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-05 15:14:13','490','2021-08-05 15:15:08',10,0),('1','151',215402,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-05 18:02:51','490','2021-08-05 18:03:26',10,0),('1','151',215464,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-06 19:54:08','490','2021-08-06 19:54:37',10,0),('1','151',215679,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-07 19:25:05','490','2021-08-07 19:31:09',10,0),('1','151',215917,'DAILY SHIFT ','2021-08-08','2021-08-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-08 12:15:24','490','2021-08-08 12:15:49',10,0),('1','151',215988,'DAILYSHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-08 18:29:36','490','2021-08-08 18:30:17',10,0),('1','151',216128,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-09 17:25:06','490','2021-08-09 17:27:07',10,0),('1','151',216322,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-10 17:47:12','490','2021-08-10 17:47:37',10,0),('1','151',216555,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-11 17:34:45','490','2021-08-11 17:35:18',10,0),('1','151',216756,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-11 17:59:10','490','2021-08-11 17:59:32',10,0),('1','151',216905,'DAILYSHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-12 17:46:22','490','2021-08-12 17:47:21',10,0),('1','151',217100,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-13 10:29:24','490','2021-08-13 10:29:50',10,0),('1','151',217128,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-13 18:28:45','490','2021-08-13 18:30:29',10,0),('1','151',217306,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-14 07:48:46','490','2021-08-14 07:49:52',10,0),('1','151',217313,'DAILYSHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-14 18:26:35','490','2021-08-14 18:28:30',10,0),('1','151',217527,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-15 13:28:57','490','2021-08-15 13:33:15',10,0),('1','151',217587,'DAILYSHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-15 18:20:33','490','2021-08-15 18:25:19',10,0),('1','151',217736,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-16 18:23:18','490','2021-08-16 18:32:19',10,0),('1','151',217985,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-17 18:27:04','490','2021-08-17 18:29:10',10,0),('1','151',218224,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-18 11:48:31','490','2021-08-18 11:54:03',10,0),('1','151',218332,'DAILYSHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-18 18:40:17','490','2021-08-18 18:41:00',10,0),('1','151',218479,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-19 18:41:25','490','2021-08-19 18:45:47',10,0),('1','151',218702,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-20 18:34:48','490','2021-08-20 18:36:25',10,0),('1','151',218912,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-21 17:36:09','490','2021-08-21 18:05:27',10,0),('1','151',219084,'DAILYSHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-21 18:37:11','490','2021-08-21 18:37:34',10,0),('1','151',219115,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-22 17:01:32','490','2021-08-22 17:12:08',10,0),('1','151',219333,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-23 18:33:07','490','2021-08-23 18:36:55',10,0),('1','151',219604,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-24 08:32:02','490','2021-08-24 09:25:14',10,0),('1','151',219666,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-24 20:03:17','490','2021-08-24 20:08:07',10,0),('1','151',219805,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-25 15:32:25','490','2021-08-25 15:41:54',10,0),('1','151',219979,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-25 18:56:19','490','2021-08-25 18:56:58',10,0),('1','151',220049,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-26 18:32:28','490','2021-08-26 18:37:25',10,0),('1','151',220226,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-27 19:18:32','490','2021-08-27 19:20:56',10,0),('1','151',220514,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-28 18:34:31','490','2021-08-28 18:37:42',10,0),('1','151',220691,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-29 17:50:03','490','2021-08-29 17:54:27',10,0),('1','151',221000,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-30 18:49:38','490','2021-08-30 18:54:00',10,0),('1','151',221142,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-31 12:11:26','490','2021-08-31 12:17:33',10,0),('1','151',221273,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-08-31 18:14:18','490','2021-08-31 18:18:54',10,0),('1','151',221389,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-01 16:43:16','490','2021-09-01 16:52:06',10,0),('1','151',221619,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-02 18:16:55','490','2021-09-02 18:27:11',10,0),('1','151',221835,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-03 18:46:26','490','2021-09-03 18:53:59',10,0),('1','151',222046,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-04 16:37:00','490','2021-09-04 16:50:35',10,0),('1','151',222262,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-05 18:31:28','490','2021-09-05 18:32:30',10,0),('1','151',222482,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-06 13:39:07','490','2021-09-06 13:51:50',10,0),('1','151',222659,'DAILYSHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-06 18:10:35','490','2021-09-06 18:11:00',10,0),('1','151',222768,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-07 17:31:27','490','2021-09-07 17:31:59',10,0),('1','151',222937,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-08 18:14:03','490','2021-09-08 18:14:55',10,0),('1','151',223180,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-09 08:38:54','490','2021-09-09 08:39:22',10,0),('1','151',223217,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-09 13:34:48','490','2021-09-09 13:36:40',10,0),('1','151',223321,'DAILYSHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-09 18:23:02','490','2021-09-09 18:24:10',10,0),('1','151',223404,'DAILY SHIFT ','2021-09-10','2021-09-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-10 18:11:50','490','2021-09-10 18:22:58',10,0),('1','151',223632,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-11 18:06:34','490','2021-09-11 18:19:47',10,0),('1','151',223884,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-12 18:33:05','490','2021-09-12 18:38:33',10,0),('1','151',224071,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-13 17:58:08','490','2021-09-13 18:02:00',10,0),('1','151',224305,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-14 18:10:22','490','2021-09-14 18:20:38',10,0),('1','151',224552,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-15 13:47:29','490','2021-09-15 13:50:07',10,0),('1','151',224693,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-15 18:26:23','490','2021-09-15 18:29:44',10,0),('1','151',224775,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-16 18:27:58','490','2021-09-16 18:42:22',10,0),('1','151',225006,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-17 15:23:58','490','2021-09-17 15:26:37',10,0),('1','151',225193,'DAILYSHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-17 18:37:10','490','2021-09-17 18:37:38',10,0),('1','151',225250,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-18 18:12:23','490','2021-09-18 18:15:40',10,0),('1','151',225503,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-19 18:15:00','490','2021-09-19 18:17:26',10,0),('1','151',225694,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-20 15:14:49','490','2021-09-20 15:22:05',10,0),('1','151',225910,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-20 18:17:52','490','2021-09-20 18:19:25',10,0),('1','151',225968,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-21 18:13:02','490','2021-09-21 18:16:16',10,0),('1','151',226278,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-22 18:28:43','490','2021-09-22 22:10:44',10,0),('1','151',226492,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-23 09:49:49','490','2021-09-23 09:50:26',10,0),('1','151',226639,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-23 18:02:52','490','2021-09-23 18:04:52',10,0),('1','151',226759,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-24 18:09:44','490','2021-09-24 18:14:56',10,0),('1','151',227030,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-25 18:57:17','490','2021-09-25 19:10:52',10,0),('1','151',227176,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-26 17:29:35','490','2021-09-26 17:42:06',10,0),('1','151',227791,'DAILY SHIFT30','2021-09-28','2021-09-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-28 16:30:53','490','2021-09-28 16:32:49',10,0),('1','151',228107,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-30 09:59:55','490','2021-09-30 10:02:59',10,0),('1','151',228175,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-09-30 10:12:57','490','2021-09-30 10:13:29',10,0),('1','151',228494,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-01 16:40:07','490','2021-10-01 16:40:44',10,0),('1','151',229167,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-05 18:17:11','490','2021-10-05 18:19:22',10,0),('1','151',229408,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-06 19:59:46','490','2021-10-06 20:09:56',10,0),('1','151',229652,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-07 19:48:15','490','2021-10-07 19:51:18',10,0),('1','151',229879,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-08 17:54:18','490','2021-10-09 08:28:06',10,0),('1','151',230121,'DALY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-10 22:49:53','490','2021-10-10 22:54:55',10,0),('1','151',230506,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-10 23:21:03','490','2021-10-10 23:21:37',10,0),('1','151',230507,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-11 18:23:09','490','2021-10-11 18:28:39',10,0),('1','151',230782,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-12 18:19:28','490','2021-10-12 18:25:55',10,0),('1','151',231087,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-13 18:05:17','490','2021-10-13 18:15:42',10,0),('1','151',231361,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-14 09:23:59','490','2021-10-14 09:26:06',10,0),('1','151',231454,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-14 18:17:17','490','2021-10-14 18:21:05',10,0),('1','151',231622,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-15 18:06:50','490','2021-10-15 18:10:55',10,0),('1','151',231897,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-16 18:10:55','490','2021-10-16 18:18:16',10,0),('1','151',232122,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-17 16:42:26','490','2021-10-17 16:59:32',10,0),('1','151',232327,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-18 18:04:46','490','2021-10-18 18:09:38',10,0),('1','151',232593,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-19 15:20:28','490','2021-10-19 15:26:06',10,0),('1','151',232753,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-19 18:20:41','490','2021-10-19 18:22:10',10,0),('1','151',232849,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-20 18:16:18','490','2021-10-20 18:22:06',10,0),('1','151',233109,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-21 17:41:10','490','2021-10-21 17:44:10',10,0),('1','151',233366,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-22 17:59:40','490','2021-10-22 18:04:08',10,0),('1','151',233583,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-23 18:14:31','490','2021-10-23 18:18:59',10,0),('1','151',233834,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-24 13:43:41','490','2021-10-24 13:46:29',10,0),('1','151',233952,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-25 18:32:47','490','2021-10-25 18:35:18',10,0),('1','151',234301,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-26 15:42:09','490','2021-10-26 15:48:41',10,0),('1','151',234505,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-26 17:50:45','490','2021-10-26 17:53:29',10,0),('1','151',234575,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-27 18:01:28','490','2021-10-27 18:07:29',10,0),('1','151',234820,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-28 18:55:54','490','2021-10-28 19:00:26',10,0),('1','151',235100,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-29 10:38:55','490','2021-10-29 10:50:24',10,0),('1','151',235177,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-29 22:13:00','490','2021-10-29 22:14:26',10,0),('1','151',235378,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-30 17:54:19','490','2021-10-30 17:58:56',10,0),('1','151',235525,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-10-31 21:24:40','490','2021-10-31 21:26:41',10,0),('1','151',235754,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-01 21:19:11','490','2021-11-01 21:24:57',10,0),('1','151',236059,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-02 18:05:05','490','2021-11-02 18:11:52',10,0),('1','151',236236,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-03 16:44:54','490','2021-11-03 16:49:17',10,0),('1','151',236512,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-04 18:12:19','490','2021-11-04 18:20:01',10,0),('1','151',236736,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-05 14:25:54','490','2021-11-05 14:27:49',10,0),('1','151',236869,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-05 18:05:33','490','2021-11-05 18:06:14',10,0),('1','151',236999,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-06 18:06:41','490','2021-11-06 18:07:44',10,0),('1','151',237177,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-07 21:10:47','490','2021-11-07 21:11:39',10,0),('1','151',237469,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-08 11:12:15','490','2021-11-08 11:12:42',10,0),('1','151',237493,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-08 19:58:17','490','2021-11-08 20:00:08',10,0),('1','151',237604,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-09 17:11:10','490','2021-11-09 17:12:28',10,0),('1','151',237856,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-10 17:58:52','490','2021-11-10 17:59:32',10,0),('1','151',238100,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-11 21:58:38','490','2021-11-11 22:03:04',10,0),('1','151',238423,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-12 21:21:10','490','2021-11-12 21:24:50',10,0),('1','151',238610,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-13 14:24:37','490','2021-11-13 14:25:56',10,0),('1','151',238758,'DAILYSHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-13 17:57:17','490','2021-11-13 17:58:16',10,0),('1','151',238844,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-14 20:54:15','490','2021-11-14 21:00:01',10,0),('1','151',239067,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-15 15:56:47','490','2021-11-15 16:00:56',10,0),('1','151',239225,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-15 17:33:23','490','2021-11-15 17:33:47',10,0),('1','151',239295,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-16 17:51:20','490','2021-11-16 17:56:14',10,0),('1','151',239525,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-17 15:31:23','490','2021-11-17 15:32:38',10,0),('1','151',239694,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-17 18:23:02','490','2021-11-17 18:23:29',10,0),('1','151',239800,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-18 10:04:21','490','2021-11-18 10:05:08',10,0),('1','151',239857,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-18 18:58:28','490','2021-11-18 19:02:25',10,0),('1','151',240030,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-19 17:47:50','490','2021-11-19 17:50:57',10,0),('1','151',240205,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-20 12:05:45','490','2021-11-20 12:06:59',10,0),('1','151',240290,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-20 17:55:34','490','2021-11-20 17:56:04',10,0),('1','151',240449,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-21 17:59:26','490','2021-11-21 18:01:40',10,0),('1','151',240749,'DAYLY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-22 14:24:11','490','2021-11-22 14:24:56',10,0),('1','151',240839,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-22 18:03:34','490','2021-11-22 18:03:59',10,0),('1','151',240973,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-23 18:40:32','490','2021-11-23 18:44:19',10,0),('1','151',241225,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-24 13:00:55','490','2021-11-24 13:03:17',10,0),('1','151',241386,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-24 18:15:27','490','2021-11-24 18:16:08',10,0),('1','151',241495,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-25 17:56:10','490','2021-11-25 17:59:41',10,0),('1','151',241720,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-26 18:18:14','490','2021-11-26 18:19:16',10,0),('1','151',241956,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-27 12:34:07','490','2021-11-27 12:34:52',10,0),('1','151',242128,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-27 18:30:04','490','2021-11-27 18:34:33',10,0),('1','151',242196,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-28 18:51:53','490','2021-11-28 18:52:43',10,0),('1','151',242420,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-29 15:33:40','490','2021-11-29 15:36:15',10,0),('1','151',242598,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-29 18:05:11','490','2021-11-30 04:47:37',10,0),('1','151',242653,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-11-30 18:27:12','490','2021-11-30 18:28:03',10,0),('1','151',242916,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-01 14:23:24','490','2021-12-01 14:24:58',10,0),('1','151',243060,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-01 18:09:40','490','2021-12-01 18:10:55',10,0),('1','151',243128,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-02 17:44:09','490','2021-12-02 17:45:31',10,0),('1','151',243363,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-03 10:42:54','490','2021-12-03 10:45:14',10,0),('1','151',243477,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-04 05:16:40','490','2021-12-04 05:18:50',10,0),('1','151',243596,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-04 17:18:44','490','2021-12-04 17:24:54',10,0),('1','151',243823,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-05 18:50:17','490','2021-12-05 18:52:45',10,0),('1','151',244043,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-06 18:16:10','490','2021-12-06 18:17:28',10,0),('1','151',244229,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-06 18:33:23','490','2021-12-06 18:33:56',10,0),('1','151',244298,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-07 12:57:38','490','2021-12-07 12:59:23',10,0),('1','151',244426,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-07 17:57:44','490','2021-12-07 17:59:31',10,0),('1','151',244510,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-08 18:53:11','490','2021-12-08 18:55:17',10,0),('1','151',244744,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-09 14:12:24','490','2021-12-09 14:14:47',10,0),('1','151',244886,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-09 17:40:20','490','2021-12-09 17:45:42',10,0),('1','151',244963,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-10 17:43:23','490','2021-12-10 17:47:11',10,0),('1','151',245218,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-11 12:06:30','490','2021-12-11 12:08:40',10,0),('1','151',245311,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-11 18:19:18','490','2021-12-11 18:22:24',10,0),('1','151',245427,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-14 07:46:25','490','2021-12-14 07:49:25',10,0),('1','151',245989,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-14 15:18:35','490','2021-12-14 15:20:19',10,0),('1','151',246107,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-14 17:45:14','490','2021-12-14 17:45:39',10,0),('1','151',246190,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-15 18:01:41','490','2021-12-15 18:04:55',10,0),('1','151',246446,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-16 17:46:43','490','2021-12-16 17:48:10',10,0),('1','151',246701,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-17 10:04:14','490','2021-12-17 10:06:36',10,0),('1','151',246794,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-17 20:43:09','490','2021-12-17 20:45:59',10,0),('1','151',246940,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-18 18:01:06','490','2021-12-18 18:04:35',10,0),('1','151',247170,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-19 17:48:36','490','2021-12-19 17:53:26',10,0),('1','151',247386,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-20 13:41:54','490','2021-12-20 13:42:44',10,0),('1','151',247571,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-20 17:45:06','490','2021-12-20 17:45:39',10,0),('1','151',247681,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-21 18:15:58','490','2021-12-21 18:18:49',10,0),('1','151',247888,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-22 13:00:02','490','2021-12-22 13:00:47',10,0),('1','151',248044,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-22 17:46:53','490','2021-12-22 17:47:22',10,0),('1','151',248161,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-23 18:07:59','490','2021-12-23 18:11:09',10,0),('1','151',248414,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-24 15:00:42','490','2021-12-24 15:01:22',10,0),('1','151',248545,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-24 18:11:22','490','2021-12-24 18:12:06',10,0),('1','151',248646,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-25 18:13:58','490','2021-12-25 18:16:43',10,0),('1','151',248863,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-26 21:13:56','490','2021-12-26 21:15:06',10,0),('1','151',249122,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-27 14:58:16','490','2021-12-27 15:23:10',10,0),('1','151',249334,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-28 18:17:03','490','2021-12-28 18:17:53',10,0),('1','151',249586,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-29 16:26:04','490','2021-12-29 16:27:40',10,0),('1','151',249851,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-30 18:17:09','490','2021-12-30 18:17:54',10,0),('1','151',250099,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'490',0.00,0.00,'490','2021-12-31 16:58:51','490','2021-12-31 17:02:51',10,0),('1','151',250355,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-01 09:30:04','490','2022-01-01 09:30:55',10,0),('1','151',250405,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-01 18:11:58','490','2022-01-01 18:12:40',10,0),('1','151',250560,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-02 17:10:55','490','2022-01-02 17:15:55',10,0),('1','151',250793,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-03 17:59:26','490','2022-01-03 18:00:33',10,0),('1','151',251020,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-04 15:12:28','490','2022-01-04 15:15:40',10,0),('1','151',251186,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-04 18:12:04','490','2022-01-04 18:16:06',10,0),('1','151',251274,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-05 19:00:03','490','2022-01-05 19:04:45',10,0),('1','151',251516,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-06 19:03:34','490','2022-01-06 19:11:19',10,0),('1','151',251762,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-07 10:56:45','490','2022-01-07 10:57:10',10,0),('1','151',251848,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-07 12:06:35','490','2022-01-07 12:07:04',10,0),('1','151',251856,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-07 19:04:43','490','2022-01-07 19:05:14',10,0),('1','151',251997,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-08 18:59:49','490','2022-01-08 19:08:17',10,0),('1','151',252232,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-09 19:09:20','490','2022-01-09 19:12:48',10,0),('1','151',252489,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-10 19:11:43','490','2022-01-10 19:17:45',10,0),('1','151',252711,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-11 19:13:42','490','2022-01-11 19:17:13',10,0),('1','151',252982,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-12 18:03:08','490','2022-01-12 18:10:14',10,0),('1','151',253316,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-13 20:01:24','490','2022-01-13 20:02:49',10,0),('1','151',253485,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-14 18:46:07','490','2022-01-14 18:56:35',10,0),('1','151',253717,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-15 19:19:41','490','2022-01-15 19:20:27',10,0),('1','151',253972,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-16 18:48:27','490','2022-01-16 18:51:54',10,0),('1','151',254196,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-17 13:33:31','490','2022-01-17 13:35:17',10,0),('1','151',254324,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-17 14:04:34','490','2022-01-17 14:05:14',10,0),('1','151',254341,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-17 19:09:25','490','2022-01-17 19:10:00',10,0),('1','151',254451,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-18 18:59:56','490','2022-01-18 19:04:28',10,0),('1','151',254693,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-19 19:25:35','490','2022-01-19 19:36:43',10,0),('1','151',254941,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-20 15:37:39','490','2022-01-20 15:42:08',10,0),('1','151',255108,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-20 18:46:32','490','2022-01-20 18:51:49',10,0),('1','151',255190,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-21 18:50:59','490','2022-01-21 18:56:42',10,0),('1','151',255462,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-22 18:00:30','490','2022-01-22 18:17:10',10,0),('1','151',255711,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-23 22:38:37','490','2022-01-23 22:40:03',10,0),('1','151',255943,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-24 14:11:04','490','2022-01-24 14:14:57',10,0),('1','151',256095,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-24 19:07:59','490','2022-01-24 19:12:31',10,0),('1','151',256216,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-25 19:48:06','490','2022-01-25 19:59:28',10,0),('1','151',256483,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-26 18:45:44','490','2022-01-26 18:57:47',10,0),('1','151',256662,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-27 08:29:15','490','2022-01-27 08:29:45',10,0),('1','151',256762,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-27 18:56:54','490','2022-01-27 18:57:24',10,0),('1','151',256994,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-28 15:59:21','490','2022-01-28 16:02:32',10,0),('1','151',257138,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-28 19:17:16','490','2022-01-28 19:21:28',10,0),('1','151',257321,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-29 19:03:58','490','2022-01-29 19:07:01',10,0),('1','151',257498,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-30 19:18:23','490','2022-01-30 19:26:17',10,0),('1','151',257499,'Daily Shif','2022-01-31','2022-01-31 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-31 15:08:11','490','2022-01-31 15:08:29',10,0),('1','151',257500,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'490',0.00,0.00,'490','2022-01-31 19:27:40','490','2022-01-31 19:28:04',10,0),('1','151',257501,'Daily Shif','2022-02-01','2022-02-01 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-02 08:41:27','490','2022-02-02 08:42:17',10,0),('1','151',257502,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-02 12:19:08','490','2022-02-02 12:19:26',10,0),('1','151',257503,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-02 19:31:54','490','2022-02-02 19:32:21',10,0),('1','151',257504,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-03 17:38:59','490','2022-02-03 17:39:22',10,0),('1','151',257505,'Daily Shif','2022-02-04','2022-02-04 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-04 17:35:25','490','2022-02-04 17:36:02',10,0),('1','151',257506,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-04 18:08:26','490','2022-02-04 18:08:48',10,0),('1','151',257507,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-05 19:06:58','490','2022-02-05 19:07:28',10,0),('1','151',257508,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-06 13:56:51','490','2022-02-06 13:57:11',10,0),('1','151',257509,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-06 21:34:35','490','2022-02-06 21:35:00',10,0),('1','151',257510,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-07 18:00:11','490','2022-02-07 18:00:45',10,0),('1','151',257511,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-08 19:35:32','490','2022-02-08 19:35:53',10,0),('1','151',257512,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-09 13:44:10','490','2022-02-09 13:44:29',10,0),('1','151',257513,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-09 19:02:33','490','2022-02-09 19:02:51',10,0),('1','151',257514,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-10 19:09:45','490','2022-02-10 19:10:06',10,0),('1','151',257515,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-11 13:54:34','490','2022-02-11 13:54:56',10,0),('1','151',257516,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-11 19:23:30','490','2022-02-11 19:23:51',10,0),('1','151',257517,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-12 19:18:39','490','2022-02-12 19:19:08',10,0),('1','151',257518,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-13 14:20:00','490','2022-02-13 14:20:20',10,0),('1','151',257519,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-14 20:03:12','490','2022-02-14 20:03:38',10,0),('1','151',257520,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-16 13:10:18','490','2022-02-16 13:10:48',10,0),('1','151',257521,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-16 18:54:14','490','2022-02-16 18:54:32',10,0),('1','151',257522,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-17 19:02:34','490','2022-02-17 19:02:57',10,0),('1','151',257523,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-19 07:42:35','490','2022-02-19 07:43:45',10,0),('1','151',257524,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-19 15:59:29','490','2022-02-19 16:00:03',10,0),('1','151',257525,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-19 16:27:40','490','2022-02-19 16:28:00',10,0),('1','151',257526,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-20 19:07:34','490','2022-02-20 19:07:54',10,0),('1','151',257527,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'490',0.00,0.00,'490','2022-02-21 17:53:34','490','2022-02-21 17:53:59',10,0),('1','151',257528,'DAILY SHIFT','2022-02-22','2022-02-22 06:58:33','2022-02-23 06:58:33','490',0.00,0.00,'490','2022-02-22 19:13:13','490','2022-02-22 19:13:42',10,0),('1','151',257529,'DAILY SHIFT','2022-02-23','2022-02-23 07:32:32','2022-02-24 07:32:32','490',0.00,0.00,'490','2022-02-23 19:03:18','490','2022-02-23 19:03:42',10,0),('1','151',257530,'DAILY SHIFT','2022-02-24','2022-02-24 07:03:38','2022-02-25 07:03:38','490',0.00,0.00,'490','2022-02-24 10:03:26','490','2022-02-24 10:04:00',10,0),('1','151',257531,'DAILY SHIFT','2022-02-24','2022-02-24 10:17:47','2022-02-25 10:17:47','490',0.00,0.00,'490','2022-02-24 19:20:20','490','2022-02-24 19:20:48',10,0),('1','151',257532,'DAILY SHIFT','2022-02-25','2022-02-25 07:47:33','2022-02-26 07:47:33','490',0.00,0.00,'490','2022-02-25 19:08:27','490','2022-02-25 19:08:53',10,0),('1','151',257533,'DAILY SHIFT','2022-02-26','2022-02-26 10:19:20','2022-02-27 10:19:20','490',0.00,0.00,'490','2022-02-26 14:59:46','490','2022-02-26 15:00:04',10,0),('1','151',257534,'DAILY SHIFT','2022-02-26','2022-02-26 15:06:23','2022-02-27 15:06:23','490',0.00,0.00,'490','2022-02-26 19:06:11','490','2022-02-26 19:06:39',10,0),('1','151',257535,'DAILY SHIFT','2022-02-27','2022-02-27 07:35:32','2022-02-28 07:35:32','490',0.00,0.00,'490','2022-02-27 19:06:14','490','2022-02-27 19:06:36',10,0),('1','151',257536,'DAILY SHIFT','2022-02-27','2022-02-27 19:29:29','2022-02-28 19:29:29','490',0.00,0.00,'490','2022-02-28 10:43:32','490','2022-02-28 10:43:52',10,0),('1','151',257537,'DAILY SHIFT','2022-02-28','2022-02-28 10:44:15','2022-03-01 10:44:15','490',0.00,0.00,'490','2022-02-28 19:09:17','490','2022-02-28 19:09:45',10,0),('1','151',257538,'DAILY SHIFT','2022-03-01','2022-03-01 07:39:35','2022-03-02 07:39:35','490',0.00,0.00,'490','2022-03-01 19:05:57','490','2022-03-02 09:12:21',10,0),('1','151',257539,'DAILY SHIFT','2022-03-02','2022-03-02 09:16:10','2022-03-03 09:16:10','490',0.00,0.00,'490','2022-03-02 19:13:46','490','2022-03-02 19:14:10',10,0),('1','151',257540,'DAILY SHIFT','2022-03-03','2022-03-03 07:39:12','2022-03-04 07:39:12','490',0.00,0.00,'490','2022-03-03 18:34:42','490','2022-03-03 18:35:00',10,0),('1','151',257541,'DAILY SHIFT','2022-03-04','2022-03-04 07:11:23','2022-03-05 07:11:23','490',0.00,0.00,'490','2022-03-04 19:03:33','490','2022-03-04 19:04:26',10,0),('1','151',257542,'DAILY SHIFT','2022-03-05','2022-03-05 07:45:55','2022-03-06 07:45:55','490',0.00,0.00,'490','2022-03-05 16:49:22','490','2022-03-05 16:50:00',10,0),('1','151',257543,'DAILY SHIFT','2022-03-05','2022-03-05 16:51:13','2022-03-06 16:51:13','490',0.00,0.00,'490','2022-03-06 18:57:34','490','2022-03-06 18:58:00',10,0),('1','151',257544,'DAILY SHIFT','2022-03-06','2022-03-06 18:58:25','2022-03-07 18:58:25','490',0.00,0.00,'490','2022-03-06 19:10:01','490','2022-03-06 19:10:23',10,0),('1','151',257545,'DAILY SHIFT','2022-03-07','2022-03-07 08:07:12','2022-03-08 08:07:12','490',0.00,0.00,'490','2022-03-07 18:58:37','490','2022-03-08 07:39:32',10,0),('1','151',257546,'DAILY SHIFT','2022-03-08','2022-03-08 07:40:32','2022-03-09 07:40:32','490',0.00,0.00,'490','2022-03-08 19:21:45','490','2022-03-08 19:22:15',10,0),('1','151',257547,'DAILY SHIFT','2022-03-09','2022-03-09 06:30:45','2022-03-10 06:30:45','490',0.00,0.00,'490','2022-03-09 18:57:59','490','2022-03-09 18:58:19',10,0),('1','151',257548,'DAILY SHIFT','2022-03-10','2022-03-10 07:12:22','2022-03-11 07:12:22','490',0.00,0.00,'490','2022-03-10 19:03:35','490','2022-03-10 19:04:45',10,0),('1','151',257549,'DAILY SHIFT','2022-03-10','2022-03-10 19:09:15','2022-03-11 19:09:15','490',0.00,0.00,'490','2022-03-10 19:14:37','490','2022-03-10 19:14:58',10,0),('1','151',257550,'DAILY SHIFT','2022-03-11','2022-03-11 08:12:10','2022-03-12 08:12:10','490',0.00,0.00,'490','2022-03-11 19:11:43','490','2022-03-11 19:12:12',10,0),('1','151',257551,'DAILY SHIFT','2022-03-12','2022-03-12 07:23:57','2022-03-13 07:23:57','490',0.00,0.00,'490','2022-03-12 18:14:48','490','2022-03-12 18:15:37',10,0),('1','151',257552,'DAILY SHIFT','2022-03-13','2022-03-13 07:11:07','2022-03-14 07:11:07','490',0.00,0.00,'490','2022-03-13 21:58:31','490','2022-03-13 21:58:51',10,0),('1','151',257553,'DAILY SHIFT','2022-03-14','2022-03-14 06:47:43','2022-03-15 06:47:43','490',0.00,0.00,'490','2022-03-14 19:38:58','490','2022-03-14 19:39:17',10,0),('1','151',257554,'DAILY SHIFT','2022-03-15','2022-03-15 07:21:41','2022-03-16 07:21:41','490',0.00,0.00,'490','2022-03-15 19:14:08','490','2022-03-15 19:14:27',10,0),('1','151',257555,'DAILY SHIFT','2022-03-16','2022-03-16 06:56:14','2022-03-17 06:56:14','490',0.00,0.00,'490','2022-03-16 16:00:26','490','2022-03-16 16:00:47',10,0),('1','151',257556,'DAILY SHIFT','2022-03-16','2022-03-16 17:05:38','2022-03-17 17:05:38','490',0.00,0.00,'490','2022-03-16 19:10:24','490','2022-03-16 19:11:08',10,0),('1','151',257557,'DAILY SHIFT','2022-03-17','2022-03-17 07:32:56','2022-03-18 07:32:56','490',0.00,0.00,'490','2022-03-18 09:47:48','490','2022-03-18 09:48:22',10,0),('1','151',257558,'DAILY SHIFT','2022-03-18','2022-03-18 09:58:55','2022-03-19 09:58:55','490',0.00,0.00,'490','2022-03-18 19:18:15','490','2022-03-18 19:18:37',10,0),('1','151',257559,'DAILY SHIFT','2022-03-19','2022-03-19 07:21:40','2022-03-20 07:21:40','490',0.00,0.00,'490','2022-03-19 10:20:37','490','2022-03-19 10:20:56',10,0),('1','151',257560,'DAILY SHIFT','2022-03-19','2022-03-19 10:40:54','2022-03-20 10:40:54','490',0.00,0.00,'490','2022-03-19 19:12:59','490','2022-03-19 19:13:17',10,0),('1','151',257561,'DAILY SHIFT','2022-03-20','2022-03-20 07:01:20','2022-03-21 07:01:20','490',0.00,0.00,'490','2022-03-20 19:50:53','490','2022-03-20 19:51:28',10,0),('1','151',257562,'DAILY SHIFT','2022-03-21','2022-03-21 07:15:53','2022-03-22 07:15:53','490',0.00,0.00,'490','2022-03-21 12:31:09','490','2022-03-21 12:31:41',10,0),('1','151',257563,'DAILY SHIFT','2022-03-21','2022-03-21 12:55:48','2022-03-22 12:55:48','490',0.00,0.00,'490','2022-03-21 19:10:40','490','2022-03-21 19:11:04',10,0),('1','151',257564,'DAILY SHIFT','2022-03-22','2022-03-22 07:17:59','2022-03-23 07:17:59','490',0.00,0.00,'490','2022-03-22 22:14:14','490','2022-03-22 22:14:43',10,0),('1','151',257565,'DAILY SHIFT','2022-03-23','2022-03-23 07:57:51','2022-03-24 07:57:51','490',0.00,0.00,'490','2022-03-23 18:54:45','490','2022-03-23 18:55:05',10,0),('1','151',257566,'DAILY SHIFT','2022-03-24','2022-03-24 06:58:38','2022-03-25 06:58:38','490',0.00,0.00,'490','2022-03-24 19:12:02','490','2022-03-24 19:12:42',10,0),('1','151',257567,'DAILY SHIFT','2022-03-25','2022-03-25 07:32:52','2022-03-26 07:32:52','490',0.00,0.00,'490','2022-03-25 18:31:28','490','2022-03-25 18:31:51',10,0),('1','151',257568,'DAILY SHIFT','2022-03-26','2022-03-26 10:00:40','2022-03-27 10:00:40','490',0.00,0.00,'490','2022-03-26 19:24:40','490','2022-03-26 19:25:02',10,0),('1','151',257569,'DAILY SHIFT','2022-03-27','2022-03-27 07:29:49','2022-03-28 07:29:49','490',0.00,0.00,'490','2022-03-27 18:58:29','490','2022-03-27 18:59:07',10,0),('1','151',257570,'DAILY SHIFT','2022-03-28','2022-03-28 07:13:19','2022-03-29 07:13:19','490',0.00,0.00,'490','2022-03-28 19:02:20','490','2022-03-28 19:02:50',10,0),('1','151',257571,'DAILY SHIFT','2022-03-29','2022-03-29 09:27:05','2022-03-30 09:27:05','490',0.00,0.00,'490','2022-03-29 19:49:17','490','2022-03-29 19:49:47',10,0),('1','151',257572,'DAILY SHIFT','2022-03-30','2022-03-30 06:58:19','2022-03-31 06:58:19','490',0.00,0.00,'490','2022-03-30 16:46:24','490','2022-03-30 16:46:47',10,0),('1','151',257573,'DAILY SHIFT','2022-03-31','2022-03-31 06:32:23','2022-04-01 06:32:23','490',0.00,0.00,'490','2022-03-31 19:23:10','490','2022-03-31 19:23:38',10,0),('1','151',257574,'DAILY SHIFT','2022-04-01','2022-04-01 06:49:45','2022-04-02 06:49:45','490',0.00,0.00,'490','2022-04-01 12:27:21','490','2022-04-01 12:27:59',10,0),('1','151',257575,'DAILY SHIFT','2022-04-01','2022-04-01 12:40:25','2022-04-02 12:40:25','490',0.00,0.00,'490','2022-04-01 20:44:38','490','2022-04-01 20:45:09',10,0),('1','151',257576,'DAILY SHIFT','2022-04-02','2022-04-02 07:20:07','2022-04-03 07:20:07','490',0.00,0.00,'490','2022-04-02 14:47:22','490','2022-04-02 14:47:55',10,0),('1','151',257577,'DAILY SHIFT','2022-04-02','2022-04-02 17:00:41','2022-04-03 17:00:41','490',0.00,0.00,'490','2022-04-02 21:18:07','490','2022-04-02 21:18:36',10,0),('1','151',257578,'DAILY SHIFT','2022-04-03','2022-04-03 07:12:34','2022-04-04 07:12:34','490',0.00,0.00,'490','2022-04-03 19:54:36','490','2022-04-03 19:55:08',10,0),('1','151',257579,'DAILY SHIFT','2022-04-04','2022-04-04 07:16:43','2022-04-05 07:16:43','490',0.00,0.00,'490','2022-04-04 19:28:59','490','2022-04-04 19:29:29',10,0),('1','151',257580,'DAILY SHIFT','2022-04-05','2022-04-05 07:03:47','2022-04-06 07:03:47','490',0.00,0.00,'490','2022-04-05 17:54:46','490','2022-04-05 17:55:06',10,0),('1','151',257581,'DAILY SHIFT','2022-04-06','2022-04-06 07:20:49','2022-04-07 07:20:49','490',0.00,0.00,'490','2022-04-06 19:15:27','490','2022-04-07 07:46:04',10,0),('1','151',257582,'DAILY SHIFT','2022-04-07','2022-04-07 07:46:35','2022-04-08 07:46:35','490',0.00,0.00,'490','2022-04-07 15:53:52','490','2022-04-07 15:54:16',10,0),('1','151',257583,'DAILY SHIFT','2022-04-07','2022-04-07 17:20:09','2022-04-08 17:20:09','490',0.00,0.00,'490','2022-04-07 18:57:13','490','2022-04-07 18:57:32',10,0),('1','151',257584,'DAILY SHIFT','2022-04-08','2022-04-08 07:00:20','2022-04-09 07:00:20','490',0.00,0.00,'490','2022-04-08 18:25:00','490','2022-04-08 18:27:58',10,0),('1','151',257585,'DAILY SHIFT','2022-04-09','2022-04-09 11:09:42','2022-04-10 11:09:42','490',0.00,0.00,'490','2022-04-09 19:11:17','490','2022-04-10 07:24:04',10,0),('1','151',257586,'DAILY SHIFT','2022-04-10','2022-04-10 07:24:42','2022-04-11 07:24:42','490',0.00,0.00,'490','2022-04-10 18:54:36','490','2022-04-10 18:54:57',10,0),('1','151',257587,'DAILY SHIFT','2022-04-11','2022-04-11 07:22:51','2022-04-12 07:22:51','490',0.00,0.00,'490','2022-04-11 15:06:14','490','2022-04-11 15:06:44',10,0),('1','151',257588,'DAILY SHIFT','2022-04-11','2022-04-11 16:25:12','2022-04-12 16:25:12','490',0.00,0.00,'490','2022-04-11 18:48:20','490','2022-04-11 18:49:12',10,0),('1','151',257589,'DAILY SHIFT','2022-04-12','2022-04-12 06:57:55','2022-04-13 06:57:55','490',0.00,0.00,'490','2022-04-12 18:45:20','490','2022-04-13 07:43:51',10,0),('1','151',257590,'DAILY SHIFT','2022-04-13','2022-04-13 07:45:08','2022-04-14 07:45:08','490',0.00,0.00,'490','2022-04-13 18:33:11','490','2022-04-13 18:33:59',10,0),('1','151',257591,'DAILY SHIFT','2022-04-14','2022-04-14 06:53:11','2022-04-15 06:53:11','490',0.00,0.00,'490','2022-04-14 14:25:23','490','2022-04-14 14:26:49',10,0),('1','151',257592,'DAILY SHIFT','2022-04-14','2022-04-14 15:22:40','2022-04-15 15:22:40','490',0.00,0.00,'490','2022-04-14 19:05:37','490','2022-04-14 19:06:00',10,0),('1','151',257593,'DAILY SHIFT','2022-04-15','2022-04-15 07:15:33','2022-04-16 07:15:33','490',0.00,0.00,'490','2022-04-15 19:05:45','490','2022-04-15 19:06:44',10,0),('1','151',257594,'DAILY SHIFT','2022-04-16','2022-04-16 09:16:05','2022-04-17 09:16:05','490',0.00,0.00,'490','2022-04-16 17:19:33','490','2022-04-16 17:19:55',10,0),('1','151',257595,'DAILY SHIFT','2022-04-17','2022-04-17 06:59:14','2022-04-18 06:59:14','490',0.00,0.00,'490','2022-04-17 18:09:16','490','2022-04-17 18:09:34',10,0),('1','151',257596,'DAILY SHIFT','2022-04-18','2022-04-18 07:07:31','2022-04-19 07:07:31','490',0.00,0.00,'490','2022-04-18 19:20:19','490','2022-04-18 19:20:49',10,0),('1','151',257597,'DAILY SHIFT','2022-04-19','2022-04-19 07:24:07','2022-04-20 07:24:07','490',0.00,0.00,'490','2022-04-19 13:17:57','490','2022-04-19 13:18:30',10,0),('1','151',257598,'DAILY SHIFT','2022-04-19','2022-04-19 13:38:35','2022-04-20 13:38:35','490',0.00,0.00,'490','2022-04-19 19:17:25','490','2022-04-19 19:17:54',10,0),('1','151',257599,'DAILY SHIFT','2022-04-20','2022-04-20 07:13:53','2022-04-21 07:13:53','490',0.00,0.00,'490','2022-04-20 19:13:08','490','2022-04-20 19:13:44',10,0),('1','151',257600,'DAILY SHIFT','2022-04-21','2022-04-21 06:42:30','2022-04-22 06:42:30','490',0.00,0.00,'490','2022-04-21 17:09:58','490','2022-04-21 17:10:22',10,0),('1','151',257601,'DAILY SHIFT','2022-04-21','2022-04-21 17:15:15','2022-04-22 17:15:15','490',0.00,0.00,'490','2022-04-22 19:06:25','490','2022-04-22 19:06:48',10,0),('1','151',257602,'DAILY SHIFT','2022-04-22','2022-04-22 19:12:11','2022-04-23 19:12:11','490',0.00,0.00,'490','2022-04-22 19:32:38','490','2022-04-22 19:33:16',10,0),('1','151',257603,'DAILY SHIFT','2022-04-23','2022-04-23 06:40:54','2022-04-24 06:40:54','490',0.00,0.00,'490','2022-04-23 18:49:02','490','2022-04-23 18:49:26',10,0),('1','151',257604,'DAILY SHIFT','2022-04-24','2022-04-24 07:35:58','2022-04-25 07:35:58','490',0.00,0.00,'490','2022-04-24 19:23:37','490','2022-04-24 19:23:57',10,0),('1','151',257605,'DAILY SHIFT','2022-04-25','2022-04-25 06:42:05','2022-04-26 06:42:05','490',0.00,0.00,'490','2022-04-25 19:14:50','490','2022-04-25 19:15:20',10,0),('1','151',257606,'DAILY SHIFT','2022-04-26','2022-04-26 07:33:35','2022-04-27 07:33:35','490',0.00,0.00,'490','2022-04-26 19:02:34','490','2022-04-26 19:03:31',10,0),('1','151',257607,'DAILY SHIFT','2022-04-27','2022-04-27 06:44:10','2022-04-28 06:44:10','490',0.00,0.00,'490','2022-04-27 18:35:30','490','2022-04-27 18:35:55',10,0),('1','151',257608,'DAILY SHIFT','2022-04-28','2022-04-28 07:23:30','2022-04-29 07:23:30','490',0.00,0.00,'490','2022-04-28 07:27:23','490','2022-04-28 07:28:37',10,0),('1','151',257609,'DAILY SHIFT','2022-04-28','2022-04-28 07:30:23','2022-04-29 07:30:23','490',0.00,0.00,'490','2022-04-28 18:57:07','490','2022-04-28 18:57:32',10,0),('1','151',257610,'DAILY SHIFT','2022-04-29','2022-04-29 06:33:37','2022-04-30 06:33:37','490',0.00,0.00,'490','2022-04-29 19:05:25','490','2022-04-29 19:05:46',10,0),('1','151',257611,'DAILY SHIFT','2022-04-30','2022-04-30 09:52:33','2022-05-01 09:52:33','490',0.00,0.00,'490','2022-04-30 19:29:15','490','2022-04-30 19:29:41',10,0),('1','151',257612,'DAILY SHIFT','2022-05-01','2022-05-01 06:32:47','2022-05-02 06:32:47','490',0.00,0.00,'490','2022-05-01 14:39:00','490','2022-05-01 14:39:23',10,0),('1','151',257613,'DAILY SHIFT','2022-05-01','2022-05-01 14:49:12','2022-05-02 14:49:12','490',0.00,0.00,'490','2022-05-01 15:01:38','490','2022-05-01 15:02:01',10,0),('1','151',257614,'DAILY SHIFT','2022-05-02','2022-05-02 09:08:12','2022-05-03 09:08:12','490',0.00,0.00,'490','2022-05-02 09:08:43','490','2022-05-02 09:09:29',10,0),('1','151',257615,'DAILY SHIFT','2022-05-02','2022-05-02 09:09:58','2022-05-03 09:09:58','490',0.00,0.00,'490','2022-05-02 09:10:37','490','2022-05-02 09:11:27',10,0),('1','151',257616,'DAILY SHIFT','2022-05-02','2022-05-02 09:11:52','2022-05-03 09:11:52','490',0.00,0.00,'490','2022-05-02 18:31:46','490','2022-05-02 18:32:09',10,0),('1','151',257617,'DAILY SHIFT','2022-05-03','2022-05-03 06:39:10','2022-05-04 06:39:10','490',0.00,0.00,'490','2022-05-03 18:19:03','490','2022-05-03 18:19:24',10,0),('1','151',257618,'DAILY SHIFT','2022-05-04','2022-05-04 07:06:26','2022-05-05 07:06:26','490',0.00,0.00,'490','2022-05-04 18:55:03','490','2022-05-04 18:55:31',10,0),('1','151',257619,'DAILY SHIFT','2022-05-04','2022-05-04 19:07:26','2022-05-05 19:07:26','490',0.00,0.00,'490','2022-05-04 19:11:38','490','2022-05-04 19:11:57',10,0),('1','151',257620,'DAILY SHIFT','2022-05-05','2022-05-05 06:43:59','2022-05-06 06:43:59','490',0.00,0.00,'490','2022-05-05 18:45:03','490','2022-05-05 18:45:38',10,0),('1','151',257621,'DAILY SHIFT','2022-05-06','2022-05-06 07:43:18','2022-05-07 07:43:18','490',0.00,0.00,'490','2022-05-06 16:35:12','490','2022-05-06 16:36:10',10,0),('1','151',257622,'DAILY SHIFT','2022-05-07','2022-05-07 06:56:45','2022-05-08 06:56:45','490',0.00,0.00,'490','2022-05-07 18:46:14','490','2022-05-07 18:46:37',10,0),('1','151',257623,'DAILY SHIFT','2022-05-08','2022-05-08 07:13:33','2022-05-09 07:13:33','490',0.00,0.00,'490','2022-05-08 19:29:28','490','2022-05-08 19:29:48',10,0),('1','151',257624,'DAILY SHIFT','2022-05-09','2022-05-09 07:26:00','2022-05-10 07:26:00','490',0.00,0.00,'490','2022-05-09 19:02:20','490','2022-05-09 19:02:45',10,0),('1','151',257625,'DAILY SHIFT','2022-05-10','2022-05-10 07:07:02','2022-05-11 07:07:02','490',0.00,0.00,'490','2022-05-10 18:55:15','490','2022-05-10 18:55:41',10,0),('1','151',257626,'DAILY SHIFT','2022-05-11','2022-05-11 07:26:36','2022-05-12 07:26:36','490',0.00,0.00,'490','2022-05-11 18:47:59','490','2022-05-11 18:48:26',10,0),('1','151',257627,'DAILY SHIFT','2022-05-12','2022-05-12 07:17:24','2022-05-13 07:17:24','490',0.00,0.00,'490','2022-05-12 18:51:17','490','2022-05-12 18:51:50',10,0),('1','151',257628,'DAILY SHIFT','2022-05-13','2022-05-13 06:48:35','2022-05-14 06:48:35','490',0.00,0.00,'490','2022-05-13 20:19:51','490','2022-05-13 20:20:11',10,0),('1','151',257629,'DAILY SHIFT','2022-05-14','2022-05-14 07:40:32','2022-05-15 07:40:32','490',0.00,0.00,'490','2022-05-14 09:04:13','490','2022-05-14 09:04:33',10,0),('1','151',257630,'DAILY SHIFT','2022-05-14','2022-05-14 09:13:46','2022-05-15 09:13:46','490',0.00,0.00,'490','2022-05-14 19:03:07','490','2022-05-14 19:03:31',10,0),('1','151',257631,'DAILY SHIFT','2022-05-15','2022-05-15 06:53:04','2022-05-16 06:53:04','490',0.00,0.00,'490','2022-05-15 19:39:38','490','2022-05-15 19:39:57',10,0),('1','151',257632,'DAILY SHIFT','2022-05-16','2022-05-16 07:37:52','2022-05-17 07:37:52','490',0.00,0.00,'490','2022-05-16 19:05:42','490','2022-05-16 19:06:54',10,0),('1','151',257633,'DAILY SHIFT','2022-05-17','2022-05-17 06:43:08','2022-05-18 06:43:08','490',0.00,0.00,'490','2022-05-17 19:03:17','490','2022-05-17 19:03:37',10,0),('1','151',257634,'DAILY SHIFT','2022-05-18','2022-05-18 07:20:08','2022-05-19 07:20:08','490',0.00,0.00,'490','2022-05-18 12:10:15','490','2022-05-18 12:10:47',10,0),('1','151',257635,'DAILY SHIFT','2022-05-18','2022-05-18 12:56:21','2022-05-19 12:56:21','490',0.00,0.00,'490','2022-05-18 18:58:41','490','2022-05-18 20:08:23',10,0),('1','151',257636,'DAILY SHIFT','2022-05-19','2022-05-19 07:00:25','2022-05-20 07:00:25','490',0.00,0.00,'490','2022-05-19 20:29:53','490','2022-05-19 20:30:20',10,0),('1','151',257637,'DAILY SHIFT','2022-05-20','2022-05-20 07:47:57','2022-05-21 07:47:57','490',0.00,0.00,'490','2022-05-20 16:24:41','490','2022-05-20 16:25:02',10,0),('1','151',257638,'DAILY SHIFT','2022-05-21','2022-05-21 06:44:21','2022-05-22 06:44:21','490',0.00,0.00,'490','2022-05-21 10:44:45','490','2022-05-21 10:45:22',10,0),('1','151',257639,'DAILY SHIFT','2022-05-21','2022-05-21 10:47:51','2022-05-22 10:47:51','490',0.00,0.00,'490','2022-05-21 18:58:10','490','2022-05-21 18:58:32',10,0),('1','151',257640,'DAILY SHIFT','2022-05-22','2022-05-22 07:29:03','2022-05-23 07:29:03','490',0.00,0.00,'490','2022-05-22 18:52:25','490','2022-05-22 18:52:45',10,0),('1','151',257641,'DAILY SHIFT','2022-05-23','2022-05-23 10:07:36','2022-05-24 10:07:36','490',0.00,0.00,'490','2022-05-23 11:41:01','490','2022-05-23 11:41:24',10,0),('1','151',257642,'DAILY SHIFT','2022-05-23','2022-05-23 11:47:27','2022-05-24 11:47:27','490',0.00,0.00,'490','2022-05-23 18:55:38','490','2022-05-23 18:55:58',10,0),('1','151',257643,'DAILY SHIFT','2022-05-24','2022-05-24 06:49:19','2022-05-25 06:49:19','490',0.00,0.00,'490','2022-05-24 19:16:07','490','2022-05-24 19:16:50',10,0),('1','151',257644,'DAILY SHIFT','2022-05-25','2022-05-25 06:41:34','2022-05-26 06:41:34','490',0.00,0.00,'490','2022-05-25 18:58:47','490','2022-05-25 18:59:11',10,0),('1','151',257645,'DAILY SHIFT','2022-05-26','2022-05-26 07:18:54','2022-05-27 07:18:54','490',0.00,0.00,'490','2022-05-26 19:00:01','490','2022-05-26 19:00:22',10,0),('1','151',257646,'DAILY SHIFT','2022-05-27','2022-05-27 06:43:29','2022-05-28 06:43:29','490',0.00,0.00,'490','2022-05-27 11:39:24','490','2022-05-27 11:39:44',10,0),('1','151',257647,'DAILY SHIFT','2022-05-27','2022-05-27 12:21:11','2022-05-28 12:21:11','490',0.00,0.00,'490','2022-05-27 19:02:05','490','2022-05-27 19:02:26',10,0),('1','151',257648,'DAILY SHIFT','2022-05-28','2022-05-28 07:48:08','2022-05-29 07:48:08','490',0.00,0.00,'490','2022-05-28 21:12:59','490','2022-05-28 21:13:21',10,0),('1','151',257649,'DAILY SHIFT','2022-05-29','2022-05-29 06:59:34','2022-05-30 06:59:34','490',0.00,0.00,'490','2022-05-29 19:04:59','490','2022-05-29 19:05:33',10,0),('1','151',257650,'DAILY SHIFT','2022-05-30','2022-05-30 07:17:59','2022-05-31 07:17:59','490',0.00,0.00,'490','2022-05-30 19:15:02','490','2022-05-30 19:15:25',10,0),('1','151',257651,'DAILY SHIFT','2022-05-31','2022-05-31 06:30:07','2022-06-01 06:30:07','490',0.00,0.00,'490','2022-05-31 11:26:26','490','2022-05-31 11:26:48',10,0),('1','151',257652,'DAILY SHIFT','2022-05-31','2022-05-31 11:47:43','2022-06-01 11:47:43','490',0.00,0.00,'490','2022-05-31 19:00:52','490','2022-05-31 19:01:15',10,0),('1','151',257653,'DAILY SHIFT','2022-06-01','2022-06-01 07:33:17','2022-06-02 07:33:17','490',0.00,0.00,'490','2022-06-01 19:13:40','490','2022-06-01 19:14:07',10,0),('1','151',257654,'DAILY SHIFT','2022-06-02','2022-06-02 07:10:36','2022-06-03 07:10:36','490',0.00,0.00,'490','2022-06-02 17:04:14','490','2022-06-02 17:10:13',10,0),('1','151',257655,'DAILY SHIFT','2022-06-03','2022-06-03 07:26:32','2022-06-04 07:26:32','490',0.00,0.00,'490','2022-06-03 19:08:23','490','2022-06-03 19:08:56',10,0),('1','151',257656,'DAILY SHIFT','2022-06-04','2022-06-04 06:52:37','2022-06-05 06:52:37','490',0.00,0.00,'490','2022-06-04 17:36:20','490','2022-06-04 17:36:42',10,0),('1','151',257657,'DAILY SHIFT','2022-06-05','2022-06-05 07:18:39','2022-06-06 07:18:39','490',0.00,0.00,'490','2022-06-05 18:57:23','490','2022-06-05 18:57:55',10,0),('1','151',257658,'DAILY SHIFT','2022-06-06','2022-06-06 07:08:47','2022-06-07 07:08:47','490',0.00,0.00,'490','2022-06-06 18:57:08','490','2022-06-06 18:58:00',10,0),('1','151',257659,'DAILY SHIFT','2022-06-07','2022-06-07 07:51:49','2022-06-08 07:51:49','490',0.00,0.00,'490','2022-06-07 19:24:11','490','2022-06-07 19:24:56',10,0),('1','151',257660,'DAILY SHIFT','2022-06-08','2022-06-08 06:36:54','2022-06-09 06:36:54','490',0.00,0.00,'490','2022-06-08 09:24:03','490','2022-06-08 09:24:25',10,0),('1','151',257661,'DAILY SHIFT','2022-06-08','2022-06-08 09:33:08','2022-06-09 09:33:08','490',0.00,0.00,'490','2022-06-08 10:45:12','490','2022-06-08 10:45:32',10,0),('1','151',257662,'DAILY SHIFT','2022-06-08','2022-06-08 10:46:04','2022-06-09 10:46:04','490',0.00,0.00,'490','2022-06-08 19:07:06','490','2022-06-08 19:07:32',10,0),('1','151',257663,'DAILY SHIFT','2022-06-09','2022-06-09 07:30:14','2022-06-10 07:30:14','490',0.00,0.00,'490','2022-06-09 19:10:01','490','2022-06-09 19:10:42',10,0),('1','151',257664,'DAILY SHIFT','2022-06-10','2022-06-10 06:32:57','2022-06-11 06:32:57','490',0.00,0.00,'490','2022-06-10 10:20:17','490','2022-06-10 10:20:38',10,0),('1','151',257665,'DAILY SHIFT','2022-06-10','2022-06-10 10:29:41','2022-06-11 10:29:41','490',0.00,0.00,'490','2022-06-10 19:13:36','490','2022-06-10 19:14:08',10,0),('1','151',257666,'DAILY SHIFT','2022-06-11','2022-06-11 07:24:49','2022-06-12 07:24:49','490',0.00,0.00,'490','2022-06-11 18:47:40','490','2022-06-11 18:48:07',10,0),('1','151',257667,'DAILY SHIFT','2022-06-12','2022-06-12 06:43:35','2022-06-13 06:43:35','490',0.00,0.00,'490','2022-06-12 14:05:29','490','2022-06-12 14:05:56',10,0),('1','151',257668,'DAILY SHIFT','2022-06-12','2022-06-12 14:10:44','2022-06-13 14:10:44','490',0.00,0.00,'490','2022-06-12 19:41:20','490','2022-06-12 19:41:42',10,0),('1','151',257669,'DAILY SHIFT','2022-06-13','2022-06-13 07:29:46','2022-06-14 07:29:46','490',0.00,0.00,'490','2022-06-13 19:01:18','490','2022-06-13 19:01:42',10,0),('1','151',257670,'DAILY SHIFT','2022-06-14','2022-06-14 07:05:43','2022-06-15 07:05:43','490',0.00,0.00,'490','2022-06-14 14:34:29','490','2022-06-14 14:35:34',10,0),('1','151',257671,'DAILY SHIFT','2022-06-14','2022-06-14 15:01:34','2022-06-15 15:01:34','490',0.00,0.00,'490','2022-06-14 18:30:05','490','2022-06-14 18:31:41',10,0),('1','151',257672,'DAILY SHIFT','2022-06-15','2022-06-15 07:44:09','2022-06-16 07:44:09','490',0.00,0.00,'490','2022-06-15 18:49:32','490','2022-06-15 18:57:06',10,0),('1','151',257673,'DAILY SHIFT','2022-06-16','2022-06-16 07:39:38','2022-06-17 07:39:38','490',0.00,0.00,'490','2022-06-16 15:16:09','490','2022-06-16 15:16:42',10,0),('1','151',257674,'DAILY SHIFT','2022-06-16','2022-06-16 15:28:37','2022-06-17 15:28:37','490',0.00,0.00,'490','2022-06-16 19:37:44','490','2022-06-16 19:38:05',10,0),('1','151',257675,'DAILY SHIFT','2022-06-17','2022-06-17 07:50:06','2022-06-18 07:50:06','490',0.00,0.00,'490','2022-06-17 18:58:57','490','2022-06-17 18:59:25',10,0),('1','151',257676,'DAILY SHIFT','2022-06-18','2022-06-18 06:38:10','2022-06-19 06:38:10','490',0.00,0.00,'490','2022-06-18 16:43:07','490','2022-06-18 16:43:34',10,0),('1','151',257677,'DAILY SHIFT','2022-06-18','2022-06-18 17:32:38','2022-06-19 17:32:38','490',0.00,0.00,'490','2022-06-18 19:21:17','490','2022-06-18 19:21:36',10,0),('1','151',257678,'DAILY SHIFT','2022-06-19','2022-06-19 07:42:20','2022-06-20 07:42:20','490',0.00,0.00,'490','2022-06-19 18:38:49','490','2022-06-19 18:39:28',10,0),('1','151',257679,'DAILY SHIFT','2022-06-19','2022-06-19 19:25:31','2022-06-20 19:25:31','490',0.00,0.00,'490','2022-06-19 19:36:08','490','2022-06-19 19:36:32',10,0),('1','151',257680,'DAILY SHIFT','2022-06-20','2022-06-20 06:41:53','2022-06-21 06:41:53','490',0.00,0.00,'490','2022-06-20 19:14:03','490','2022-06-20 19:14:32',10,0),('1','151',257681,'DAILY SHIFT','2022-06-21','2022-06-21 07:11:35','2022-06-22 07:11:35','490',0.00,0.00,'490','2022-06-21 13:54:46','490','2022-06-21 13:55:12',10,0),('1','151',257682,'DAILY SHIFT','2022-06-21','2022-06-21 16:23:03','2022-06-22 16:23:03','490',0.00,0.00,'490','2022-06-21 19:21:42','490','2022-06-21 19:22:14',10,0),('1','151',257683,'DAILY SHIFT','2022-06-22','2022-06-22 06:42:34','2022-06-23 06:42:34','490',0.00,0.00,'490','2022-06-22 19:03:59','490','2022-06-22 19:04:35',10,0),('1','151',257684,'DAILY SHIFT','2022-06-23','2022-06-23 07:34:18','2022-06-24 07:34:18','490',0.00,0.00,'490','2022-06-23 18:31:23','490','2022-06-23 18:31:46',10,0),('1','151',257685,'DAILY SHIFT','2022-06-24','2022-06-24 06:45:12','2022-06-25 06:45:12','490',0.00,0.00,'490','2022-06-24 19:32:23','490','2022-06-24 19:32:44',10,0),('1','151',257686,'DAILY SHIFT','2022-06-25','2022-06-25 10:15:12','2022-06-26 10:15:12','490',0.00,0.00,'490','2022-06-25 19:07:43','490','2022-06-25 19:08:10',10,0),('1','151',257687,'DAILY SHIFT','2022-06-26','2022-06-26 08:36:32','2022-06-27 08:36:32','490',0.00,0.00,'490','2022-06-26 12:40:25','490','2022-06-26 12:40:47',10,0),('1','151',257688,'DAILY SHIFT','2022-06-26','2022-06-26 12:45:43','2022-06-27 12:45:43','490',0.00,0.00,'490','2022-06-26 18:45:33','490','2022-06-26 18:46:02',10,0),('1','151',257689,'DAILY SHIFT','2022-06-27','2022-06-27 07:14:14','2022-06-28 07:14:14','490',0.00,0.00,'490','2022-06-27 19:23:11','490','2022-06-27 19:23:45',10,0),('1','151',257690,'DAILY SHIFT','2022-06-28','2022-06-28 06:48:41','2022-06-29 06:48:41','490',0.00,0.00,'490','2022-06-28 06:49:27','490','2022-06-28 07:23:52',10,0),('1','151',257691,'Daily Shif','2022-06-28','2022-06-28 07:24:18','2022-06-29 07:24:18','490',0.00,0.00,'490','2022-06-28 13:40:11','490','2022-06-28 13:40:37',10,0),('1','151',257692,'DAILY SHIFT','2022-06-28','2022-06-28 15:05:52','2022-06-29 15:05:52','490',0.00,0.00,'490','2022-06-28 19:20:18','490','2022-06-28 19:20:40',10,0),('1','151',257693,'DAILY SHIFT','2022-06-29','2022-06-29 08:12:22','2022-06-30 08:12:22','490',0.00,0.00,'490','2022-06-29 19:26:49','490','2022-06-29 19:27:15',10,0),('1','151',257694,'DAILY SHIFT','2022-06-30','2022-06-30 07:04:07','2022-07-01 07:04:07','490',0.00,0.00,'490','2022-06-30 17:36:50','490','2022-06-30 17:37:15',10,0),('1','151',257695,'DAILY SHIFT','2022-07-01','2022-07-01 07:19:47','2022-07-02 07:19:47','490',0.00,0.00,'490','2022-07-01 19:40:13','490','2022-07-01 19:40:42',10,0),('1','151',257696,'DAILY SHIFT','2022-07-02','2022-07-02 06:54:37','2022-07-03 06:54:37','490',0.00,0.00,'490','2022-07-02 18:09:07','490','2022-07-02 18:09:34',10,0),('1','151',257697,'DAILY SHIFT','2022-07-03','2022-07-03 06:50:17','2022-07-04 06:50:17','490',0.00,0.00,'490','2022-07-03 16:27:37','490','2022-07-03 16:28:20',10,0),('1','151',257698,'DAILY SHIFT','2022-07-03','2022-07-03 16:33:45','2022-07-04 16:33:45','490',0.00,0.00,'490','2022-07-03 20:47:13','490','2022-07-03 20:47:36',10,0),('1','151',257699,'DAILY SHIFT','2022-07-03','2022-07-03 20:50:00','2022-07-04 20:50:00','490',0.00,0.00,'490','2022-07-03 21:00:52','490','2022-07-03 21:01:13',10,0),('1','151',257700,'DAILY SHIFT','2022-07-04','2022-07-04 06:51:50','2022-07-05 06:51:50','490',0.00,0.00,'490','2022-07-04 19:23:29','490','2022-07-04 19:24:09',10,0),('1','151',257701,'DAILY SHIFT','2022-07-05','2022-07-05 07:06:49','2022-07-06 07:06:49','490',0.00,0.00,'490','2022-07-05 20:01:30','490','2022-07-05 20:02:04',10,0),('1','151',257702,'DAILY SHIFT','2022-07-06','2022-07-06 06:59:48','2022-07-07 06:59:48','490',0.00,0.00,'490','2022-07-07 00:13:38','490','2022-07-07 00:14:41',10,0),('1','151',257703,'DAILY SHIFT','2022-07-07','2022-07-07 06:49:55','2022-07-08 06:49:55','490',0.00,0.00,'909','2022-07-08 00:09:12','909','2022-07-08 00:09:39',10,0),('1','151',257704,'DAILY SHIFT','2022-07-08','2022-07-08 07:08:28','2022-07-09 07:08:28','909',0.00,0.00,'909','2022-07-09 06:41:37','909','2022-07-09 06:41:58',10,0),('1','151',257705,'DAILY SHIFT','2022-07-09','2022-07-09 06:43:01','2022-07-10 06:43:01','909',0.00,0.00,'909','2022-07-10 06:55:30','909','2022-07-10 06:55:51',10,0),('1','151',257706,'DAILY SHIFT','2022-07-10','2022-07-10 06:56:24','2022-07-11 06:56:24','909',0.00,0.00,'909','2022-07-11 06:39:54','909','2022-07-11 06:41:03',10,0),('1','151',257707,'DAILY SHIFT','2022-07-11','2022-07-11 06:42:58','2022-07-12 06:42:58','909',0.00,0.00,'909','2022-07-12 06:51:22','909','2022-07-12 06:52:04',10,0),('1','151',257708,'DAILY SHIFT','2022-07-12','2022-07-12 06:52:56','2022-07-13 06:52:56','909',0.00,0.00,'909','2022-07-12 19:25:24','909','2022-07-12 19:25:55',10,0),('1','151',257709,'DAILY SHIFT','2022-07-13','2022-07-13 06:28:29','2022-07-14 06:28:29','909',0.00,0.00,'909','2022-07-14 06:26:07','909','2022-07-14 06:26:31',10,0),('1','151',257710,'DAILY SHIFT','2022-07-14','2022-07-14 06:26:57','2022-07-15 06:26:57','909',0.00,0.00,'909','2022-07-15 07:06:12','909','2022-07-15 07:07:40',10,0),('1','151',257711,'DAILY SHIFT','2022-07-15','2022-07-15 07:08:23','2022-07-16 07:08:23','909',0.00,0.00,'909','2022-07-15 08:39:20','909','2022-07-15 08:39:39',10,0),('1','151',257712,'DAILY SHIFT','2022-07-15','2022-07-15 09:06:42','2022-07-16 09:06:42','909',0.00,0.00,'909','2022-07-16 06:31:13','909','2022-07-16 06:31:49',10,0),('1','151',257713,'DAILY SHIFT','2022-07-16','2022-07-16 06:32:29','2022-07-17 06:32:29','909',0.00,0.00,'909','2022-07-16 22:55:49','909','2022-07-16 22:56:24',10,0),('1','151',257714,'DAILY SHIFT','2022-07-17','2022-07-17 07:07:16','2022-07-18 07:07:16','909',0.00,0.00,'909','2022-07-18 00:34:33','909','2022-07-18 00:35:13',10,0),('1','151',257715,'DAILY SHIFT','2022-07-18','2022-07-18 07:05:15','2022-07-19 07:05:15','909',0.00,0.00,'909','2022-07-19 06:52:47','909','2022-07-19 06:53:06',10,0),('1','151',257716,'DAILY SHIFT','2022-07-19','2022-07-19 06:53:43','2022-07-20 06:53:43','909',0.00,0.00,'909','2022-07-20 07:09:00','909','2022-07-20 07:09:21',10,0),('1','151',257717,'DAILY SHIFT','2022-07-20','2022-07-20 07:09:44','2022-07-21 07:09:44','909',0.00,0.00,'909','2022-07-21 07:26:49','909','2022-07-21 07:27:08',10,0),('1','151',257718,'DAILY SHIFT','2022-07-21','2022-07-21 07:27:30','2022-07-22 07:27:30','909',0.00,0.00,'909','2022-07-22 00:04:33','909','2022-07-22 00:05:04',10,0),('1','151',257719,'DAILY SHIFT','2022-07-22','2022-07-22 07:00:19','2022-07-23 07:00:19','909',0.00,0.00,'909','2022-07-22 19:41:42','909','2022-07-22 19:42:13',10,0),('1','151',257720,'DAILY SHIFT','2022-07-23','2022-07-23 06:43:42','2022-07-24 06:43:42','909',0.00,0.00,'909','2022-07-23 19:25:37','909','2022-07-23 19:26:17',10,0),('1','151',257721,'DAILY SHIFT','2022-07-24','2022-07-24 08:32:24','2022-07-25 08:32:24','909',0.00,0.00,'909','2022-07-25 06:50:15','909','2022-07-25 06:50:51',10,0),('1','151',257722,'DAILY SHIFT','2022-07-25','2022-07-25 06:51:13','2022-07-26 06:51:13','909',0.00,0.00,'909','2022-07-25 19:29:41','909','2022-07-25 19:30:19',10,0),('1','151',257723,'DAILY SHIFT','2022-07-26','2022-07-26 06:35:50','2022-07-27 06:35:50','909',0.00,0.00,'909','2022-07-27 06:35:05','909','2022-07-27 06:35:25',10,0),('1','151',257724,'DAILY SHIFT','2022-07-27','2022-07-27 06:36:00','2022-07-28 06:36:00','909',0.00,0.00,'909','2022-07-27 11:01:12','909','2022-07-27 11:01:32',10,0),('1','151',257725,'DAILY SHIFT','2022-07-27','2022-07-27 11:09:43','2022-07-28 11:09:43','909',0.00,0.00,'909','2022-07-27 11:31:08','909','2022-07-27 11:31:50',10,0),('1','151',257726,'DAILY SHIFT','2022-07-27','2022-07-27 11:39:23','2022-07-28 11:39:23','909',0.00,0.00,'909','2022-07-27 20:57:52','909','2022-07-27 20:58:19',10,0),('1','151',257727,'DAILY SHIFT','2022-07-28','2022-07-28 07:06:34','2022-07-29 07:06:34','909',0.00,0.00,'909','2022-07-28 23:49:15','909','2022-07-28 23:49:49',10,0),('1','151',257728,'DAILY SHIFT','2022-07-29','2022-07-29 06:23:39','2022-07-30 06:23:39','909',0.00,0.00,'909','2022-07-30 06:45:47','909','2022-07-30 06:46:17',10,0),('1','151',257729,'DAILY SHIFT','2022-07-30','2022-07-30 06:46:51','2022-07-31 06:46:51','909',0.00,0.00,'909','2022-07-31 06:49:50','909','2022-07-31 06:50:11',10,0),('1','151',257730,'DAILY SHIFT','2022-07-31','2022-07-31 06:50:35','2022-08-01 06:50:35','909',0.00,0.00,'909','2022-07-31 19:49:53','909','2022-07-31 19:50:19',10,0),('1','151',257731,'DAILY SHIFT','2022-08-01','2022-08-01 07:14:20','2022-08-02 07:14:20','909',0.00,0.00,'909','2022-08-01 19:37:54','909','2022-08-01 19:38:35',10,0),('1','151',257732,'DAILY SHIFT','2022-08-02','2022-08-02 07:10:37','2022-08-03 07:10:37','909',0.00,0.00,'909','2022-08-03 06:57:02','909','2022-08-03 06:57:41',10,0),('1','151',257733,'DAILY SHIFT','2022-08-03','2022-08-03 06:58:03','2022-08-04 06:58:03','909',0.00,0.00,'909','2022-08-03 19:14:58','909','2022-08-03 19:15:25',10,0),('1','151',257734,'Daily Shif','2022-08-04','2022-08-04 06:59:40','2022-08-05 06:59:40','909',0.00,0.00,'909','2022-08-04 19:42:33','909','2022-08-04 19:43:02',10,0),('1','151',257735,'DAILY SHIFT','2022-08-05','2022-08-05 07:02:48','2022-08-06 07:02:48','909',0.00,0.00,'909','2022-08-05 19:43:04','909','2022-08-05 19:43:29',10,0),('1','151',257736,'DAILY SHIFT','2022-08-06','2022-08-06 07:17:06','2022-08-07 07:17:06','909',0.00,0.00,'909','2022-08-06 18:51:58','909','2022-08-06 18:52:32',10,0),('1','151',257737,'DAILY SHIFT','2022-08-07','2022-08-07 07:07:11','2022-08-08 07:07:11','909',0.00,0.00,'909','2022-08-07 23:35:36','909','2022-08-07 23:36:20',10,0),('1','151',257738,'DAILY SHIFT','2022-08-08','2022-08-08 07:29:25','2022-08-09 07:29:25','909',0.00,0.00,'909','2022-08-08 18:44:31','909','2022-08-08 18:45:19',10,0),('1','151',257739,'DAILY SHIFT','2022-08-09','2022-08-09 06:56:08','2022-08-10 06:56:08','909',0.00,0.00,'909','2022-08-10 07:06:54','909','2022-08-10 07:11:52',10,0),('1','151',257740,'DAILY SHIFT','2022-08-10','2022-08-10 07:12:31','2022-08-11 07:12:31','909',0.00,0.00,'909','2022-08-10 12:17:45','909','2022-08-10 12:18:02',10,0),('1','151',257741,'DAILY SHIFT','2022-08-10','2022-08-10 12:19:41','2022-08-11 12:19:41','909',0.00,0.00,'909','2022-08-10 23:55:10','909','2022-08-10 23:56:49',10,0),('1','151',257742,'DAILY SHIFT','2022-08-11','2022-08-11 07:49:57','2022-08-12 07:49:57','909',0.00,0.00,'909','2022-08-11 19:01:23','909','2022-08-11 19:01:43',10,0),('1','151',257743,'DAILY SHIFT','2022-08-12','2022-08-12 07:07:45','2022-08-13 07:07:45','909',0.00,0.00,'909','2022-08-12 13:40:55','909','2022-08-12 13:41:15',10,0),('1','151',257744,'DAILY SHIFT','2022-08-12','2022-08-12 13:42:07','2022-08-13 13:42:07','909',0.00,0.00,'909','2022-08-13 07:11:40','909','2022-08-13 07:11:59',10,0),('1','151',257745,'DAILY SHIFT','2022-08-13','2022-08-13 07:12:20','2022-08-14 07:12:20','909',0.00,0.00,'909','2022-08-13 19:23:42','909','2022-08-13 19:24:10',10,0),('1','151',257746,'DAILY SHIFT','2022-08-14','2022-08-14 07:04:16','2022-08-15 07:04:16','909',0.00,0.00,'909','2022-08-14 15:27:00','909','2022-08-14 15:27:21',10,0),('1','151',257747,'DAILY SHIFT','2022-08-14','2022-08-14 15:58:18','2022-08-15 15:58:18','909',0.00,0.00,'909','2022-08-15 07:50:20','909','2022-08-15 07:50:36',10,0),('1','151',257748,'DAILY SHIFT','2022-08-15','2022-08-15 07:51:11','2022-08-16 07:51:11','909',0.00,0.00,'909','2022-08-15 19:08:51','909','2022-08-15 19:09:12',10,0),('1','151',257749,'DAILY SHIFT','2022-08-16','2022-08-16 06:59:43','2022-08-17 06:59:43','909',0.00,0.00,'909','2022-08-16 19:37:27','909','2022-08-16 19:37:59',10,0),('1','151',257750,'DAILY SHIFT','2022-08-17','2022-08-17 07:02:59','2022-08-18 07:02:59','909',0.00,0.00,'909','2022-08-17 19:28:58','909','2022-08-17 19:29:46',10,0),('1','151',257751,'DAILY SHIFT','2022-08-18','2022-08-18 06:48:57','2022-08-19 06:48:57','909',0.00,0.00,'909','2022-08-18 19:24:14','909','2022-08-18 19:24:45',10,0),('1','151',257752,'DAILY SHIFT','2022-08-19','2022-08-19 07:11:41','2022-08-20 07:11:41','909',0.00,0.00,'909','2022-08-19 10:43:43','909','2022-08-19 10:44:02',10,0),('1','151',257753,'DAILY SHIFT','2022-08-19','2022-08-19 10:44:27','2022-08-20 10:44:27','909',0.00,0.00,'909','2022-08-19 19:27:22','909','2022-08-19 19:27:45',10,0),('1','151',257754,'DAILY SHIFT','2022-08-20','2022-08-20 06:58:58','2022-08-21 06:58:58','909',0.00,0.00,'909','2022-08-20 19:15:31','909','2022-08-20 19:15:58',10,0),('1','151',257755,'DAILY SHIFT','2022-08-21','2022-08-21 06:43:07','2022-08-22 06:43:07','909',0.00,0.00,'909','2022-08-21 11:51:57','909','2022-08-21 11:52:14',10,0),('1','151',257756,'DAILY SHIFT','2022-08-21','2022-08-21 11:52:29','2022-08-22 11:52:29','909',0.00,0.00,'909','2022-08-21 19:03:38','909','2022-08-21 19:03:55',10,0),('1','151',257757,'DAILY SHIFT','2022-08-22','2022-08-22 07:02:26','2022-08-23 07:02:26','909',0.00,0.00,'909','2022-08-23 07:03:10','909','2022-08-23 07:04:11',10,0),('1','151',257758,'DAILY SHIFT','2022-08-23','2022-08-23 07:04:48','2022-08-24 07:04:48','909',0.00,0.00,'909','2022-08-23 17:23:41','909','2022-08-23 17:24:01',10,0),('1','151',257759,'DAILY SHIFT','2022-08-23','2022-08-23 17:24:22','2022-08-24 17:24:22','909',0.00,0.00,'909','2022-08-23 19:06:33','909','2022-08-23 19:06:52',10,0),('1','151',257760,'DAILY SHIFT','2022-08-24','2022-08-24 06:53:42','2022-08-25 06:53:42','909',0.00,0.00,'909','2022-08-24 19:13:45','909','2022-08-24 19:14:07',10,0),('1','151',257761,'DAILY SHIFT','2022-08-25','2022-08-25 07:52:52','2022-08-26 07:52:52','909',0.00,0.00,'909','2022-08-25 19:10:52','909','2022-08-25 19:11:17',10,0),('1','151',257762,'DAILY SHIFT','2022-08-26','2022-08-26 07:00:00','2022-08-27 07:00:00','909',0.00,0.00,'909','2022-08-26 11:36:54','909','2022-08-26 11:37:12',10,0),('1','151',257763,'DAILY SHIFT','2022-08-26','2022-08-26 15:06:04','2022-08-27 15:06:04','909',0.00,0.00,'909','2022-08-26 19:16:21','909','2022-08-26 19:16:39',10,0),('1','151',257764,'DAILY SHIFT','2022-08-27','2022-08-27 09:33:21','2022-08-28 09:33:21','909',0.00,0.00,'909','2022-08-27 19:16:32','909','2022-08-27 19:16:49',10,0),('1','151',257765,'DAILY SHIFT','2022-08-28','2022-08-28 06:53:23','2022-08-29 06:53:23','909',0.00,0.00,'909','2022-08-28 16:43:34','909','2022-08-28 16:43:54',10,0),('1','151',257766,'DAILY SHIFT','2022-08-29','2022-08-29 10:17:46','2022-08-30 10:17:46','909',0.00,0.00,'909','2022-08-29 19:50:55','909','2022-08-29 19:51:24',10,0),('1','151',257767,'DAILY SHIFT4390','2022-08-30','2022-08-30 06:56:03','2022-08-31 06:56:03','909',0.00,0.00,'909','2022-08-30 17:16:51','909','2022-08-30 17:29:23',10,0),('1','151',257768,'DAILY SHIFT','2022-08-30','2022-08-30 17:37:19','2022-08-31 17:37:19','909',0.00,0.00,'909','2022-08-30 19:25:13','909','2022-08-30 19:25:29',10,0),('1','151',257769,'DAILY SHIFT','2022-08-31','2022-08-31 06:55:14','2022-09-01 06:55:14','909',0.00,0.00,'909','2022-08-31 18:57:20','909','2022-08-31 18:57:37',10,0),('1','151',257770,'DAILY SHIFT','2022-09-01','2022-09-01 06:46:01','2022-09-02 06:46:01','909',0.00,0.00,'909','2022-09-01 14:10:23','909','2022-09-01 14:10:42',10,0),('1','151',257771,'DAILY SHIFT','2022-09-01','2022-09-01 14:11:00','2022-09-02 14:11:00','909',0.00,0.00,'909','2022-09-01 19:48:33','909','2022-09-01 19:48:52',10,0),('1','151',257772,'DAILY SHIFT','2022-09-02','2022-09-02 06:55:50','2022-09-03 06:55:50','909',0.00,0.00,'909','2022-09-02 16:46:40','909','2022-09-02 16:47:04',10,0),('1','151',257773,'DAILY SHIFT','2022-09-02','2022-09-02 16:47:18','2022-09-03 16:47:18','909',0.00,0.00,'909','2022-09-02 19:49:30','909','2022-09-02 19:49:54',10,0),('1','151',257774,'DAILY SHIFT','2022-09-03','2022-09-03 06:38:18','2022-09-04 06:38:18','909',0.00,0.00,'909','2022-09-03 19:31:35','909','2022-09-03 19:32:10',10,0),('1','151',257775,'DAILY SHIFT','2022-09-04','2022-09-04 06:46:34','2022-09-05 06:46:34','909',0.00,0.00,'909','2022-09-04 14:48:18','909','2022-09-04 14:48:39',10,0),('1','151',257776,'DAILY SHIFT','2022-09-04','2022-09-04 14:49:16','2022-09-05 14:49:16','909',0.00,0.00,'909','2022-09-04 19:25:59','909','2022-09-04 19:26:18',10,0),('1','151',257777,'DAILY SHIFT','2022-09-05','2022-09-05 07:00:50','2022-09-06 07:00:50','909',0.00,0.00,'909','2022-09-05 19:46:26','909','2022-09-05 19:46:50',10,0),('1','151',257778,'DAILY SHIFT','2022-09-06','2022-09-06 06:47:01','2022-09-07 06:47:01','909',0.00,0.00,'909','2022-09-06 12:47:48','909','2022-09-06 12:48:06',10,0),('1','151',257779,'DAILY SHIFT','2022-09-06','2022-09-06 12:48:34','2022-09-07 12:48:34','909',0.00,0.00,'909','2022-09-06 20:36:26','909','2022-09-06 20:36:49',10,0),('1','151',257780,'DAILY SHIFT','2022-09-07','2022-09-07 06:41:10','2022-09-08 06:41:10','909',0.00,0.00,'909','2022-09-07 20:08:19','909','2022-09-07 20:08:37',10,0),('1','151',257781,'DAILY SHIFT','2022-09-08','2022-09-08 06:39:54','2022-09-09 06:39:54','909',0.00,0.00,'909','2022-09-08 09:30:39','909','2022-09-08 09:30:57',10,0),('1','151',257782,'DAILY SHIFT','2022-09-08','2022-09-08 09:40:28','2022-09-09 09:40:28','909',0.00,0.00,'909','2022-09-08 20:05:52','909','2022-09-08 20:06:11',10,0),('1','151',257783,'DAILY SHIFT','2022-09-09','2022-09-09 07:02:25','2022-09-10 07:02:25','909',0.00,0.00,'909','2022-09-09 19:52:09','909','2022-09-09 19:52:29',10,0),('1','151',257784,'DAILY SHIFT','2022-09-10','2022-09-10 06:54:31','2022-09-11 06:54:31','909',0.00,0.00,'909','2022-09-10 14:20:36','909','2022-09-10 14:20:53',10,0),('1','151',257785,'DAILY SHIFT','2022-09-10','2022-09-10 16:46:12','2022-09-11 16:46:12','909',0.00,0.00,'909','2022-09-10 19:21:32','909','2022-09-10 19:21:52',10,0),('1','151',257786,'DAILY SHIFT','2022-09-11','2022-09-11 06:56:32','2022-09-12 06:56:32','909',0.00,0.00,'909','2022-09-11 19:16:01','909','2022-09-11 19:16:19',10,0),('1','151',257787,'DAILY SHIFT','2022-09-12','2022-09-12 06:53:20','2022-09-13 06:53:20','909',0.00,0.00,'909','2022-09-12 15:00:13','909','2022-09-12 15:00:34',10,0),('1','151',257788,'DAILY SHIFT','2022-09-13','2022-09-13 12:27:24','2022-09-14 12:27:24','909',0.00,0.00,'909','2022-09-13 19:13:48','909','2022-09-13 19:14:04',10,0),('1','151',257789,'DAILY SHIFT','2022-09-14','2022-09-14 07:08:30','2022-09-15 07:08:30','909',0.00,0.00,'909','2022-09-14 21:12:56','909','2022-09-14 21:13:19',10,0),('1','151',257790,'DAILY SHIFT','2022-09-15','2022-09-15 07:01:25','2022-09-16 07:01:25','909',0.00,0.00,'909','2022-09-15 08:08:36','909','2022-09-15 08:08:56',10,0),('1','151',257791,'DAILY SHIFT','2022-09-15','2022-09-15 08:09:49','2022-09-16 08:09:49','909',0.00,0.00,'909','2022-09-15 19:33:05','909','2022-09-15 19:33:28',10,0),('1','151',257792,'DAILY SHIFT','2022-09-16','2022-09-16 07:01:26','2022-09-17 07:01:26','909',0.00,0.00,'909','2022-09-16 16:55:48','909','2022-09-16 16:56:09',10,0),('1','151',257793,'DAILY SHIFT','2022-09-16','2022-09-16 17:25:42','2022-09-17 17:25:42','909',0.00,0.00,'909','2022-09-16 19:55:31','909','2022-09-16 19:55:49',10,0),('1','151',257794,'DAILY SHIFT','2022-09-17','2022-09-17 06:46:02','2022-09-18 06:46:02','909',0.00,0.00,'909','2022-09-17 19:17:36','909','2022-09-17 19:18:04',10,0),('1','151',257795,'DAILY SHIFT','2022-09-18','2022-09-18 07:07:16','2022-09-19 07:07:16','909',0.00,0.00,'909','2022-09-18 18:47:44','909','2022-09-18 18:48:01',10,0),('1','151',257796,'DAILY SHIFT','2022-09-20','2022-09-20 13:01:32','2022-09-21 13:01:32','909',0.00,0.00,'909','2022-09-20 19:08:05','909','2022-09-20 19:08:31',10,0),('1','151',257797,'DAILY SHIFT','2022-09-21','2022-09-21 06:55:49','2022-09-22 06:55:49','909',0.00,0.00,'909','2022-09-21 18:31:11','909','2022-09-21 18:31:31',10,0),('1','151',257798,'DAILY SHIFT','2022-09-22','2022-09-22 06:54:24','2022-09-23 06:54:24','909',0.00,0.00,'909','2022-09-22 18:17:00','909','2022-09-22 18:17:20',10,0),('1','151',257799,'DAILY SHIFT','2022-09-23','2022-09-23 07:07:43','2022-09-24 07:07:43','909',0.00,0.00,'909','2022-09-23 19:19:16','909','2022-09-23 19:19:45',10,0),('1','151',257800,'DAILY SHIFT','2022-09-24','2022-09-24 09:36:55','2022-09-25 09:36:55','909',0.00,0.00,'909','2022-09-24 19:24:41','909','2022-09-24 19:25:05',10,0),('1','151',257801,'DAILY SHIFT','2022-09-25','2022-09-25 06:59:12','2022-09-26 06:59:12','909',0.00,0.00,'909','2022-09-25 12:02:03','909','2022-09-25 12:02:23',10,0),('1','151',257802,'DAILY SHIFT','2022-09-25','2022-09-25 12:02:42','2022-09-26 12:02:42','909',0.00,0.00,'909','2022-09-25 19:01:00','909','2022-09-25 19:01:25',10,0),('1','151',257803,'DAILY SHIFT','2022-09-26','2022-09-26 06:44:29','2022-09-27 06:44:29','909',0.00,0.00,'909','2022-09-26 19:06:23','909','2022-09-26 19:06:48',10,0),('1','151',257804,'DAILY SHIFT','2022-09-27','2022-09-27 06:57:00','2022-09-28 06:57:00','909',0.00,0.00,'909','2022-09-27 10:41:32','909','2022-09-27 10:41:49',10,0),('1','151',257805,'DAILY SHIFT','2022-09-27','2022-09-27 14:02:30','2022-09-28 14:02:30','909',0.00,0.00,'909','2022-09-27 19:03:29','909','2022-09-27 19:03:48',10,0),('1','151',257806,'DAILY SHIFT','2022-09-28','2022-09-28 07:00:28','2022-09-29 07:00:28','909',0.00,0.00,'909','2022-09-28 19:06:51','909','2022-09-28 19:07:18',10,0),('1','151',257807,'DAILY SHIFT','2022-09-29','2022-09-29 06:41:14','2022-09-30 06:41:14','909',0.00,0.00,'909','2022-09-29 16:09:28','909','2022-09-29 16:09:46',10,0),('1','151',257808,'DAILY SHIFT','2022-09-29','2022-09-29 16:11:50','2022-09-30 16:11:50','909',0.00,0.00,'909','2022-09-29 19:02:47','909','2022-09-29 19:03:15',10,0),('1','151',257809,'DAILY SHIFT','2022-09-30','2022-09-30 07:01:51','2022-10-01 07:01:51','909',0.00,0.00,'909','2022-09-30 19:08:24','909','2022-09-30 19:08:46',10,0),('1','151',257810,'DAILY SHIFT','2022-10-01','2022-10-01 07:00:54','2022-10-02 07:00:54','909',0.00,0.00,'909','2022-10-01 18:45:30','909','2022-10-01 18:46:05',10,0),('1','151',257811,'DAILY SHIFT','2022-10-02','2022-10-02 06:47:54','2022-10-03 06:47:54','909',0.00,0.00,'909','2022-10-02 19:11:35','909','2022-10-02 19:11:52',10,0),('1','151',257812,'DAILY SHIFT','2022-10-03','2022-10-03 06:55:41','2022-10-04 06:55:41','909',0.00,0.00,'909','2022-10-03 19:34:34','909','2022-10-03 19:34:59',10,0),('1','151',257813,'DAILY SHIFT','2022-10-04','2022-10-04 06:38:28','2022-10-05 06:38:28','909',0.00,0.00,'909','2022-10-04 18:58:02','909','2022-10-04 18:58:26',10,0),('1','151',257814,'DAILY SHIFT','2022-10-05','2022-10-05 06:59:56','2022-10-06 06:59:56','909',0.00,0.00,'909','2022-10-05 18:56:10','909','2022-10-05 18:56:34',10,0),('1','151',257815,'DAILY SHIFT','2022-10-06','2022-10-06 06:51:34','2022-10-07 06:51:34','909',0.00,0.00,'909','2022-10-06 13:17:20','909','2022-10-06 13:18:00',10,0),('1','151',257816,'DAILY SHIFT','2022-10-06','2022-10-06 13:24:05','2022-10-07 13:24:05','909',0.00,0.00,'909','2022-10-06 19:12:30','909','2022-10-06 19:12:47',10,0),('1','151',257817,'DAILY SHIFT','2022-10-07','2022-10-07 07:01:23','2022-10-08 07:01:23','909',0.00,0.00,'909','2022-10-07 19:18:04','909','2022-10-07 19:18:18',10,0),('1','151',257818,'DAILY SHIFT','2022-10-08','2022-10-08 06:57:34','2022-10-09 06:57:34','909',0.00,0.00,'909','2022-10-08 17:21:22','909','2022-10-08 17:21:45',10,0),('1','151',257819,'DAILY SHIFT','2022-10-08','2022-10-08 17:25:18','2022-10-09 17:25:18','909',0.00,0.00,'909','2022-10-08 19:05:05','909','2022-10-08 19:05:25',10,0),('1','151',257820,'DAILY SHIFT','2022-10-09','2022-10-09 06:55:04','2022-10-10 06:55:04','909',0.00,0.00,'909','2022-10-09 17:52:17','909','2022-10-09 17:52:37',10,0),('1','151',257821,'DAILY SHIFT','2022-10-12','2022-10-12 07:05:45','2022-10-13 07:05:45','909',0.00,0.00,'909','2022-10-12 18:56:41','909','2022-10-12 18:56:59',10,0),('1','151',257822,'DAILY SHIFT','2022-10-13','2022-10-13 07:00:01','2022-10-14 07:00:01','909',0.00,0.00,'909','2022-10-13 18:48:59','909','2022-10-13 18:49:21',10,0),('1','151',257823,'DAILY SHIFT','2022-10-14','2022-10-14 07:11:06','2022-10-15 07:11:06','909',0.00,0.00,'909','2022-10-14 16:23:48','909','2022-10-14 16:24:12',10,0),('1','151',257824,'DAILY SHIFT','2022-10-14','2022-10-14 16:27:12','2022-10-15 16:27:12','909',0.00,0.00,'909','2022-10-14 18:52:00','909','2022-10-14 18:52:18',10,0),('1','151',257825,'DAILY SHIFT','2022-10-15','2022-10-15 07:02:57','2022-10-16 07:02:57','909',0.00,0.00,'909','2022-10-15 18:59:03','909','2022-10-15 18:59:28',10,0),('1','151',257826,'DAILY SHIFT','2022-10-16','2022-10-16 06:50:35','2022-10-17 06:50:35','909',0.00,0.00,'909','2022-10-16 18:49:22','909','2022-10-16 18:50:07',10,0),('1','151',257827,'DAILY SHIFT','2022-10-17','2022-10-17 06:54:53','2022-10-18 06:54:53','909',0.00,0.00,'909','2022-10-17 11:13:28','909','2022-10-17 11:13:47',10,0),('1','151',257828,'DAILY SHIFT','2022-10-17','2022-10-17 12:05:57','2022-10-18 12:05:57','909',0.00,0.00,'909','2022-10-17 19:05:56','909','2022-10-17 19:07:41',10,0),('1','151',257829,'DAILY SHIFT','2022-10-18','2022-10-18 06:56:47','2022-10-19 06:56:47','909',0.00,0.00,'909','2022-10-18 18:54:24','909','2022-10-18 18:55:01',10,0),('1','151',257830,'DAILY SHIFT','2022-10-19','2022-10-19 06:54:08','2022-10-20 06:54:08','909',0.00,0.00,'909','2022-10-19 15:33:23','909','2022-10-19 15:33:42',10,0),('1','151',257831,'DAILY SHIFT','2022-10-19','2022-10-19 16:39:47','2022-10-20 16:39:47','909',0.00,0.00,'909','2022-10-19 18:35:35','909','2022-10-19 18:35:55',10,0),('1','151',257832,'DAILY SHIFT','2022-10-20','2022-10-20 11:16:14','2022-10-21 11:16:14','909',0.00,0.00,'909','2022-10-20 18:42:13','909','2022-10-20 18:42:34',10,0),('1','151',257833,'DAILY SHIFT','2022-10-21','2022-10-21 07:43:27','2022-10-22 07:43:27','909',0.00,0.00,'909','2022-10-21 18:52:19','909','2022-10-21 18:52:52',10,0),('1','151',257834,'DAILY SHIFT','2022-10-22','2022-10-22 06:58:47','2022-10-23 06:58:47','909',0.00,0.00,'909','2022-10-22 19:05:07','909','2022-10-22 19:05:30',10,0),('1','151',257835,'DAILY SHIFT','2022-10-23','2022-10-23 12:32:09','2022-10-24 12:32:09','909',0.00,0.00,'909','2022-10-23 18:40:30','909','2022-10-23 18:40:53',10,0),('1','151',257836,'DAILY SHIFT','2022-10-24','2022-10-24 07:08:46','2022-10-25 07:08:46','909',0.00,0.00,'909','2022-10-24 10:04:01','909','2022-10-24 10:04:21',10,0),('1','151',257837,'DAILY SHIFT','2022-10-24','2022-10-24 10:51:19','2022-10-25 10:51:19','909',0.00,0.00,'909','2022-10-24 19:25:20','909','2022-10-24 19:25:45',10,0),('1','151',257838,'DAILY SHIFT ','2022-10-25','2022-10-25 06:58:15','2022-10-26 06:58:15','909',0.00,0.00,'909','2022-10-25 18:42:12','909','2022-10-25 18:46:42',10,0),('1','151',257839,'DAILY SHIFT','2022-10-26','2022-10-26 06:59:26','2022-10-27 06:59:26','909',0.00,0.00,'909','2022-10-26 13:11:46','909','2022-10-26 13:12:03',10,0),('1','151',257840,'DAILY SHIFT','2022-10-26','2022-10-26 14:49:10','2022-10-27 14:49:10','909',0.00,0.00,'909','2022-10-26 19:04:49','909','2022-10-26 19:05:08',10,0),('1','151',257841,'DAILY SHIFT','2022-10-27','2022-10-27 06:53:56','2022-10-28 06:53:56','909',0.00,0.00,'909','2022-10-27 19:04:03','909','2022-10-27 19:04:31',10,0),('1','151',257842,'DAILY SHIFT','2022-10-28','2022-10-28 06:58:06','2022-10-29 06:58:06','909',0.00,0.00,'909','2022-10-28 18:28:27','909','2022-10-28 18:28:50',10,0),('1','151',257843,'DAILY SHIFT','2022-10-31','2022-10-31 16:15:42','2022-11-01 16:15:42','909',0.00,0.00,'909','2022-10-31 19:18:13','909','2022-10-31 19:18:35',10,0),('1','151',257844,'DAILY SHIFT','2022-11-01','2022-11-01 07:01:05','2022-11-02 07:01:05','909',0.00,0.00,'909','2022-11-01 19:02:45','909','2022-11-01 19:03:19',10,0),('1','151',257845,'DAILY SHIFT','2022-11-02','2022-11-02 07:16:24','2022-11-03 07:16:24','909',0.00,0.00,'909','2022-11-02 16:59:47','909','2022-11-02 17:00:09',10,0),('1','151',257846,'DAILY SHIFT','2022-11-05','2022-11-05 11:50:55','2022-11-06 11:50:55','909',0.00,0.00,'909','2022-11-05 19:00:05','909','2022-11-05 19:00:24',10,0),('1','151',257847,'DAILY SHIFT','2022-11-06','2022-11-06 07:47:51','2022-11-07 07:47:51','909',0.00,0.00,'909','2022-11-06 18:44:02','909','2022-11-06 18:44:24',10,0),('1','151',257848,'DAILY SHIFT','2022-11-07','2022-11-07 07:08:58','2022-11-08 07:08:58','909',0.00,0.00,'909','2022-11-07 15:35:53','909','2022-11-07 15:36:17',10,0),('1','151',257849,'DAILY SHIFT','2022-11-07','2022-11-07 16:14:05','2022-11-08 16:14:05','909',0.00,0.00,'909','2022-11-07 17:58:58','909','2022-11-07 17:59:16',10,0),('1','151',257850,'DAILY SHIFT','2022-11-08','2022-11-08 08:37:47','2022-11-09 08:37:47','909',0.00,0.00,'909','2022-11-08 18:38:52','909','2022-11-08 18:39:30',10,0),('1','151',257851,'DAILY SHIFT','2022-11-09','2022-11-09 07:06:02','2022-11-10 07:06:02','909',0.00,0.00,'909','2022-11-09 18:48:39','909','2022-11-09 18:49:21',10,0),('1','151',257852,'DAILY SHIFT','2022-11-10','2022-11-10 06:59:01','2022-11-11 06:59:01','909',0.00,0.00,'909','2022-11-10 11:38:11','909','2022-11-10 11:38:29',10,0),('1','151',257853,'DAILY SHIFT','2022-11-10','2022-11-10 13:45:08','2022-11-11 13:45:08','909',0.00,0.00,'909','2022-11-10 18:42:35','909','2022-11-10 18:42:58',10,0),('1','151',257854,'DAILY SHIFT','2022-11-11','2022-11-11 06:56:41','2022-11-12 06:56:41','909',0.00,0.00,'909','2022-11-11 18:35:18','909','2022-11-11 18:35:47',10,0),('1','151',257855,'DAILY SHIFT','2022-11-12','2022-11-12 06:56:48','2022-11-13 06:56:48','909',0.00,0.00,'909','2022-11-12 17:40:33','909','2022-11-12 17:41:08',10,0),('1','151',257856,'DAILY SHIFT','2022-11-13','2022-11-13 07:09:01','2022-11-14 07:09:01','909',0.00,0.00,'909','2022-11-13 18:29:42','909','2022-11-13 18:29:58',10,0),('1','151',257857,'DAILY SHIFT','2022-11-14','2022-11-14 06:56:31','2022-11-15 06:56:31','909',0.00,0.00,'909','2022-11-14 19:13:09','909','2022-11-14 19:13:27',10,0),('1','151',257858,'DAILY SHIFT','2022-11-15','2022-11-15 06:56:04','2022-11-16 06:56:04','909',0.00,0.00,'909','2022-11-15 11:34:56','909','2022-11-15 11:35:13',10,0),('1','151',257859,'DAILY SHIFT','2022-11-15','2022-11-15 12:29:43','2022-11-16 12:29:43','909',0.00,0.00,'909','2022-11-15 18:43:20','909','2022-11-15 18:43:39',10,0),('1','151',257860,'DAILY SHIFT','2022-11-16','2022-11-16 06:57:04','2022-11-17 06:57:04','909',0.00,0.00,'909','2022-11-16 18:29:52','909','2022-11-16 18:30:13',10,0),('1','151',257861,'DAILY SHIFT','2022-11-17','2022-11-17 06:59:34','2022-11-18 06:59:34','909',0.00,0.00,'909','2022-11-17 18:37:42','909','2022-11-17 18:38:04',10,0),('1','151',257862,'DAILY SHIFT','2022-11-18','2022-11-18 06:58:13','2022-11-19 06:58:13','909',0.00,0.00,'909','2022-11-18 11:18:00','909','2022-11-18 11:18:24',10,0),('1','151',257863,'DAILY SHIFT','2022-11-18','2022-11-18 13:31:46','2022-11-19 13:31:46','909',0.00,0.00,'909','2022-11-18 18:44:46','909','2022-11-18 18:45:02',10,0),('1','151',257864,'DAILY SHIFT','2022-11-19','2022-11-19 06:58:05','2022-11-20 06:58:05','909',0.00,0.00,'909','2022-11-20 06:57:09','909','2022-11-20 06:57:30',10,0),('1','151',257865,'DAILY SHIFT','2022-11-20','2022-11-20 06:57:44','2022-11-21 06:57:44','909',0.00,0.00,'909','2022-11-20 18:40:24','909','2022-11-20 18:40:54',10,0),('1','151',257866,'DAILY SHIFT','2022-11-21','2022-11-21 11:43:00','2022-11-22 11:43:00','909',0.00,0.00,'909','2022-11-21 18:38:36','909','2022-11-21 18:38:54',10,0),('1','151',257867,'DAILY SHIFT','2022-11-22','2022-11-22 07:02:15','2022-11-23 07:02:15','909',0.00,0.00,'909','2022-11-22 18:28:01','909','2022-11-22 18:28:20',10,0),('1','151',257868,'DAILY SHIFT','2022-11-23','2022-11-23 07:06:11','2022-11-24 07:06:11','909',0.00,0.00,'909','2022-11-23 18:27:42','909','2022-11-23 18:28:01',10,0),('1','151',257869,'DAILY SHIFT','2022-11-24','2022-11-24 07:04:40','2022-11-25 07:04:40','909',0.00,0.00,'909','2022-11-24 17:40:26','909','2022-11-24 17:40:52',10,0),('1','151',257870,'DAILY SHIFT','2022-11-25','2022-11-25 14:50:07','2022-11-26 14:50:07','909',0.00,0.00,'909','2022-11-25 18:26:13','909','2022-11-25 18:26:31',10,0),('1','151',257871,'DAILY SHIFT','2022-11-26','2022-11-26 12:23:36','2022-11-27 12:23:36','909',0.00,0.00,'909','2022-11-26 18:51:41','909','2022-11-26 18:52:00',10,0),('1','151',257872,'DAILY SHIFT','2022-11-27','2022-11-27 06:59:43','2022-11-28 06:59:43','909',0.00,0.00,'909','2022-11-27 18:44:10','909','2022-11-27 18:44:35',10,0),('1','151',257873,'DAILY SHIFT','2022-11-28','2022-11-28 07:20:18','2022-11-29 07:20:18','909',0.00,0.00,'909','2022-11-28 19:06:59','909','2022-11-28 19:07:26',10,0),('1','151',257874,'DAILY SHIFT','2022-11-29','2022-11-29 07:02:03','2022-11-30 07:02:03','909',0.00,0.00,'909','2022-11-29 18:57:14','909','2022-11-29 18:57:42',10,0),('1','151',257875,'DAILY SHIFT','2022-11-30','2022-11-30 07:07:13','2022-12-01 07:07:13','909',0.00,0.00,'909','2022-11-30 18:36:39','909','2022-11-30 18:37:29',10,0),('1','151',257876,'DAILY SHIFT','2022-12-01','2022-12-01 06:55:00','2022-12-02 06:55:00','909',0.00,0.00,'909','2022-12-01 18:51:15','909','2022-12-01 18:51:35',10,0),('1','151',257877,'DAILY SHIFT','2022-12-02','2022-12-02 06:54:24','2022-12-03 06:54:24','909',0.00,0.00,'909','2022-12-02 18:08:53','909','2022-12-02 18:09:13',10,0),('1','151',257878,'DAILY SHIFT','2022-12-03','2022-12-03 11:17:55','2022-12-04 11:17:55','909',0.00,0.00,'909','2022-12-03 19:10:05','909','2022-12-03 19:10:24',10,0),('1','151',257879,'DAILY SHIFT','2022-12-04','2022-12-04 06:57:53','2022-12-05 06:57:53','909',0.00,0.00,'909','2022-12-04 18:52:36','909','2022-12-04 18:52:59',10,0),('1','151',257880,'DAILY SHIFT','2022-12-05','2022-12-05 07:06:07','2022-12-06 07:06:07','909',0.00,0.00,'909','2022-12-05 12:08:54','909','2022-12-05 12:09:15',10,0),('1','151',257881,'DAILY SHIFT','2022-12-05','2022-12-05 12:09:39','2022-12-06 12:09:39','909',0.00,0.00,'909','2022-12-05 19:42:12','909','2022-12-05 19:42:34',10,0),('1','151',257882,'DAILY SHIFT','2022-12-06','2022-12-06 06:57:43','2022-12-07 06:57:43','909',0.00,0.00,'909','2022-12-06 18:54:44','909','2022-12-06 18:55:10',10,0),('1','151',257883,'DAILY SHIFT','2022-12-07','2022-12-07 07:09:46','2022-12-08 07:09:46','909',0.00,0.00,'909','2022-12-07 18:36:17','909','2022-12-07 18:36:35',10,0),('1','151',257884,'DAILY SHIFT','2022-12-08','2022-12-08 06:54:45','2022-12-09 06:54:45','909',0.00,0.00,'909','2022-12-08 18:40:47','909','2022-12-08 18:41:14',10,0),('1','151',257885,'DAILY SHIFT','2022-12-09','2022-12-09 06:59:17','2022-12-10 06:59:17','909',0.00,0.00,'909','2022-12-09 18:43:01','909','2022-12-09 18:43:33',10,0),('1','151',257886,'DAILY SHIFT','2022-12-10','2022-12-10 06:53:07','2022-12-11 06:53:07','909',0.00,0.00,'909','2022-12-10 18:27:32','909','2022-12-10 18:28:13',10,0),('1','151',257887,'DAILY SHIFT','2022-12-11','2022-12-11 06:53:16','2022-12-12 06:53:16','909',0.00,0.00,'909','2022-12-11 18:43:40','909','2022-12-11 18:44:10',10,0),('1','151',257888,'DAILY SHIFT','2022-12-12','2022-12-12 07:00:03','2022-12-13 07:00:03','909',0.00,0.00,'909','2022-12-12 18:40:38','909','2022-12-12 18:41:08',10,0),('1','151',257889,'DAILY SHIFT','2022-12-13','2022-12-13 06:58:23','2022-12-14 06:58:23','909',0.00,0.00,'909','2022-12-13 18:52:30','909','2022-12-13 18:53:11',10,0),('1','151',257890,'DAILY SHIFT','2022-12-14','2022-12-14 06:53:49','2022-12-15 06:53:49','909',0.00,0.00,'909','2022-12-14 18:56:35','909','2022-12-14 18:56:56',10,0),('1','151',257891,'DAILY SHIFT','2022-12-15','2022-12-15 06:48:16','2022-12-16 06:48:16','909',0.00,0.00,'909','2022-12-15 14:40:51','909','2022-12-15 14:41:30',10,0),('1','151',257892,'DAILY SHIFT','2022-12-15','2022-12-15 15:07:14','2022-12-16 15:07:14','909',0.00,0.00,'909','2022-12-15 19:17:28','909','2022-12-15 19:17:45',10,0),('1','151',257893,'DAILY SHIFT','2022-12-16','2022-12-16 06:54:31','2022-12-17 06:54:31','909',0.00,0.00,'909','2022-12-16 18:40:28','909','2022-12-16 18:40:50',10,0),('1','151',257894,'DAILY SHIFT','2022-12-17','2022-12-17 07:01:22','2022-12-18 07:01:22','909',0.00,0.00,'909','2022-12-17 18:39:19','909','2022-12-17 18:39:35',10,0),('1','151',257895,'DAILY SHIFT','2022-12-18','2022-12-18 06:59:52','2022-12-19 06:59:52','909',0.00,0.00,'909','2022-12-18 18:45:26','909','2022-12-18 18:45:55',10,0),('1','151',257896,'DAILY SHIFT','2022-12-19','2022-12-19 06:54:44','2022-12-20 06:54:44','909',0.00,0.00,'909','2022-12-19 18:29:27','909','2022-12-19 18:29:45',10,0),('1','151',257897,'DAILY SHIFT','2022-12-20','2022-12-20 06:59:40','2022-12-21 06:59:40','909',0.00,0.00,'909','2022-12-20 18:35:51','909','2022-12-20 18:36:29',10,0),('1','151',257898,'DAILY SHIFT','2022-12-21','2022-12-21 06:53:43','2022-12-22 06:53:43','909',0.00,0.00,'909','2022-12-21 18:27:17','909','2022-12-21 18:27:41',10,0),('1','151',257899,'DAILY SHIFT','2022-12-22','2022-12-22 07:05:49','2022-12-23 07:05:49','909',0.00,0.00,'909','2022-12-22 18:47:43','909','2022-12-22 18:48:11',10,0),('1','151',257900,'DAILY SHIFT','2022-12-23','2022-12-23 07:02:09','2022-12-24 07:02:09','909',0.00,0.00,'909','2022-12-23 18:24:38','909','2022-12-23 18:24:57',10,0),('1','151',257901,'DAILY SHIFT','2022-12-24','2022-12-24 06:57:58','2022-12-25 06:57:58','909',0.00,0.00,'909','2022-12-24 18:38:40','909','2022-12-24 18:40:29',10,0),('1','151',257902,'DAILY SHIFT','2022-12-25','2022-12-25 06:55:50','2022-12-26 06:55:50','909',0.00,0.00,'909','2022-12-25 18:41:20','909','2022-12-25 18:41:48',10,0),('1','151',257903,'DAILY SHIFT','2022-12-26','2022-12-26 07:00:15','2022-12-27 07:00:15','909',0.00,0.00,'909','2022-12-26 18:33:10','909','2022-12-26 18:34:18',10,0),('1','151',257904,'DAILY SHIFT','2022-12-27','2022-12-27 06:57:32','2022-12-28 06:57:32','909',0.00,0.00,'909','2022-12-27 15:55:44','909','2022-12-27 15:56:06',10,0),('1','151',257905,'DAILY SHIFT','2022-12-27','2022-12-27 15:58:29','2022-12-28 15:58:29','909',0.00,0.00,'909','2022-12-27 17:18:51','909','2022-12-27 17:19:07',10,0),('1','151',257906,'DAILY SHIFT','2022-12-27','2022-12-27 18:02:43','2022-12-28 18:02:43','909',0.00,0.00,'909','2022-12-27 19:21:35','909','2022-12-27 19:21:51',10,0),('1','151',257907,'DAILY SHIFT','2022-12-28','2022-12-28 07:03:40','2022-12-29 07:03:40','909',0.00,0.00,'909','2022-12-28 18:52:23','909','2022-12-28 18:53:06',10,0),('1','151',257908,'DAILY SHIFT','2022-12-29','2022-12-29 07:09:41','2022-12-30 07:09:41','909',0.00,0.00,'909','2022-12-29 17:09:55','909','2022-12-29 17:10:17',10,0),('1','151',257909,'DAILY SHIFT','2022-12-30','2022-12-30 07:07:56','2022-12-31 07:07:56','909',0.00,0.00,'909','2022-12-30 18:38:34','909','2022-12-30 18:39:00',10,0),('1','151',257910,'DAILY SHIFT','2022-12-31','2022-12-31 10:41:15','2023-01-01 10:41:15','909',0.00,0.00,'909','2022-12-31 18:43:49','909','2022-12-31 18:44:09',10,0),('1','151',257911,'DAILY SHIFT','2023-01-01','2023-01-01 06:55:27','2023-01-02 06:55:27','909',0.00,0.00,'909','2023-01-01 18:29:59','909','2023-01-01 18:30:28',10,0),('1','151',257912,'DAILY SHIFT','2023-01-02','2023-01-02 07:06:29','2023-01-03 07:06:29','909',0.00,0.00,'909','2023-01-02 18:21:55','909','2023-01-02 18:22:21',10,0),('1','151',257913,'DAILY SHIFT','2023-01-03','2023-01-03 06:59:32','2023-01-04 06:59:32','909',0.00,0.00,'909','2023-01-03 18:44:21','909','2023-01-03 18:44:53',10,0),('1','151',257914,'DAILY SHIFT','2023-01-04','2023-01-04 07:09:07','2023-01-05 07:09:07','909',0.00,0.00,'909','2023-01-04 18:43:51','909','2023-01-04 18:44:39',10,0),('1','151',257915,'DAILY SHIFT','2023-01-05','2023-01-05 07:15:48','2023-01-06 07:15:48','909',0.00,0.00,'909','2023-01-05 18:47:20','909','2023-01-05 18:48:01',10,0),('1','151',257916,'DAILY SHIFT','2023-01-06','2023-01-06 07:01:35','2023-01-07 07:01:35','909',0.00,0.00,'909','2023-01-06 18:53:38','909','2023-01-06 18:54:07',10,0),('1','151',257917,'DAILY SHIFT','2023-01-07','2023-01-07 07:14:01','2023-01-08 07:14:01','909',0.00,0.00,'909','2023-01-07 18:45:03','909','2023-01-07 18:45:36',10,0),('1','151',257918,'DAILY SHIFT','2023-01-08','2023-01-08 06:58:42','2023-01-09 06:58:42','909',0.00,0.00,'1019','2023-01-08 18:25:06','1019','2023-01-08 18:25:27',10,0),('1','151',257919,'DAILY SHIFT','2023-01-09','2023-01-09 07:02:27','2023-01-10 07:02:27','1019',0.00,0.00,'1019','2023-01-09 18:37:26','1019','2023-01-09 18:37:51',10,0),('1','151',257920,'DAILY SHIFT','2023-01-09','2023-01-09 18:47:35','2023-01-10 18:47:35','1019',0.00,0.00,'1019','2023-01-09 18:51:21','1019','2023-01-09 18:51:48',10,0),('1','151',257921,'DAILY SHIFT','2023-01-10','2023-01-10 06:29:48','2023-01-11 06:29:48','1019',0.00,0.00,'1019','2023-01-10 18:52:29','1019','2023-01-10 18:52:51',10,0),('1','151',257922,'DAILY SHIFT','2023-01-11','2023-01-11 07:08:09','2023-01-12 07:08:09','1019',0.00,0.00,'1019','2023-01-11 18:31:11','1019','2023-01-11 18:31:53',10,0),('1','151',257923,'DAILY SHIFT','2023-01-12','2023-01-12 06:50:22','2023-01-13 06:50:22','1019',0.00,0.00,'1019','2023-01-12 12:40:10','1019','2023-01-12 12:40:29',10,0),('1','151',257924,'DAILY SHIFT','2023-01-12','2023-01-12 12:40:51','2023-01-13 12:40:51','1019',0.00,0.00,'1019','2023-01-12 19:13:49','1019','2023-01-12 19:14:08',10,0),('1','151',257925,'DAILY SHIFT','2023-01-13','2023-01-13 07:09:29','2023-01-14 07:09:29','1019',0.00,0.00,'1019','2023-01-13 19:00:23','1019','2023-01-13 19:00:43',10,0),('1','151',257926,'DAILY SHIFT','2023-01-14','2023-01-14 06:55:51','2023-01-15 06:55:51','1019',0.00,0.00,'1019','2023-01-14 11:16:46','1019','2023-01-14 11:17:05',10,0),('1','151',257927,'DAILY SHIFT','2023-01-14','2023-01-14 12:30:27','2023-01-15 12:30:27','1019',0.00,0.00,'1019','2023-01-14 19:00:55','1019','2023-01-14 19:01:16',10,0),('1','151',257928,'DAILY SHIFT','2023-01-15','2023-01-15 07:06:10','2023-01-16 07:06:10','1019',0.00,0.00,'1019','2023-01-15 18:43:12','1019','2023-01-15 18:44:15',10,0),('1','151',257929,'DAILY SHIFT','2023-01-16','2023-01-16 06:59:13','2023-01-17 06:59:13','1019',0.00,0.00,'1019','2023-01-16 13:10:37','1019','2023-01-16 13:10:55',10,0),('1','151',257930,'DAILY SHIFT','2023-01-16','2023-01-16 14:56:26','2023-01-17 14:56:26','1019',0.00,0.00,'1019','2023-01-16 19:00:09','1019','2023-01-16 19:00:30',10,0),('1','151',257931,'DAILY SHIFT','2023-01-17','2023-01-17 07:03:05','2023-01-18 07:03:05','1019',0.00,0.00,'1019','2023-01-17 19:04:46','1019','2023-01-17 19:05:31',10,0),('1','151',257932,'DAILY SHIFT','2023-01-18','2023-01-18 07:00:01','2023-01-19 07:00:01','1019',0.00,0.00,'1019','2023-01-18 13:39:38','1019','2023-01-18 13:39:57',10,0),('1','151',257933,'DAILY SHIFT','2023-01-18','2023-01-18 17:50:27','2023-01-19 17:50:27','1019',0.00,0.00,'1019','2023-01-18 17:51:39','1019','2023-01-18 17:51:57',10,0),('1','151',257934,'DAILY SHIFT','2023-01-19','2023-01-19 11:21:06','2023-01-20 11:21:06','1019',0.00,0.00,'1019','2023-01-19 18:48:02','1019','2023-01-19 18:48:57',10,0),('1','151',257935,'DAILY SHIFT','2023-01-20','2023-01-20 07:00:53','2023-01-21 07:00:53','1019',0.00,0.00,'1019','2023-01-20 18:54:36','1019','2023-01-20 18:57:21',10,0),('1','151',257936,'DAILY SHIFT','2023-01-21','2023-01-21 07:08:12','2023-01-22 07:08:12','1019',0.00,0.00,'1019','2023-01-21 10:31:50','1019','2023-01-21 10:32:10',10,0),('1','151',257937,'DAILY SHIFT','2023-01-21','2023-01-21 11:24:23','2023-01-22 11:24:23','1019',0.00,0.00,'1019','2023-01-21 19:12:17','1019','2023-01-21 19:13:08',10,0),('1','151',257938,'DAILY SHIFT','2023-01-22','2023-01-22 06:58:58','2023-01-23 06:58:58','1019',0.00,0.00,'1019','2023-01-22 18:52:28','1019','2023-01-22 18:53:09',10,0),('1','151',257939,'DAILY SHIFT','2023-01-23','2023-01-23 07:02:55','2023-01-24 07:02:55','1019',0.00,0.00,'1019','2023-01-23 10:51:28','1019','2023-01-23 10:51:46',10,0),('1','151',257940,'DAILY SHIFT','2023-01-23','2023-01-23 11:58:20','2023-01-24 11:58:20','1019',0.00,0.00,'1019','2023-01-23 19:09:18','1019','2023-01-23 19:09:47',10,0),('1','151',257941,'DAILY SHIFT','2023-01-24','2023-01-24 07:01:19','2023-01-25 07:01:19','1019',0.00,0.00,'1019','2023-01-24 19:15:05','1019','2023-01-24 19:15:40',10,0),('1','151',257942,'DAILY SHIFT','2023-01-25','2023-01-25 07:08:13','2023-01-26 07:08:13','1019',0.00,0.00,'1019','2023-01-25 11:24:52','1019','2023-01-25 11:48:32',10,0),('1','151',257943,'DAILY SHIFT','2023-01-25','2023-01-25 13:27:10','2023-01-26 13:27:10','1019',0.00,0.00,'1019','2023-01-25 19:08:20','1019','2023-01-25 19:08:37',10,0),('1','151',257944,'DAILY SHIFT','2023-01-26','2023-01-26 07:03:56','2023-01-27 07:03:56','1019',0.00,0.00,'1019','2023-01-26 19:04:54','1019','2023-01-26 19:05:12',10,0),('1','151',257945,'DAILY SHIFT','2023-01-27','2023-01-27 07:06:28','2023-01-28 07:06:28','1019',0.00,0.00,'1019','2023-01-27 14:40:20','1019','2023-01-27 14:40:40',10,0),('1','151',257946,'DAILY SHIFT','2023-01-27','2023-01-27 14:56:31','2023-01-28 14:56:31','1019',0.00,0.00,'1019','2023-01-27 19:08:20','1019','2023-01-27 19:08:55',10,0),('1','151',257947,'DAILY SHIFT','2023-01-28','2023-01-28 09:46:33','2023-01-29 09:46:33','1019',0.00,0.00,'1019','2023-01-28 19:19:52','1019','2023-01-28 19:20:12',10,0),('1','151',257948,'DAILY SHIFT','2023-01-29','2023-01-29 07:00:16','2023-01-30 07:00:16','1019',0.00,0.00,'1019','2023-01-29 16:53:42','1019','2023-01-29 16:54:15',10,0),('1','151',257949,'DAILY SHIFT','2023-01-29','2023-01-29 17:15:39','2023-01-30 17:15:39','1019',0.00,0.00,'1019','2023-01-29 19:09:54','1019','2023-01-29 19:10:43',10,0),('1','151',257950,'DAILY SHIFT','2023-01-30','2023-01-30 06:55:10','2023-01-31 06:55:10','1019',0.00,0.00,'1019','2023-01-30 17:54:06','1019','2023-01-30 17:54:29',10,0),('1','151',257951,'DAILY SHIFT','2023-01-31','2023-01-31 08:31:15','2023-02-01 08:31:15','1019',0.00,0.00,'1019','2023-01-31 20:34:23','1019','2023-01-31 20:34:41',10,0),('1','151',257952,'DAILY SHIFT','2023-02-01','2023-02-01 06:57:55','2023-02-02 06:57:55','1019',0.00,0.00,'1019','2023-02-01 18:29:45','1019','2023-02-01 18:30:19',10,0),('1','151',257953,'DAILY SHIFT','2023-02-02','2023-02-02 06:48:37','2023-02-03 06:48:37','1019',0.00,0.00,'1019','2023-02-02 19:46:35','1019','2023-02-02 19:47:11',10,0),('1','151',257954,'DAILY SHIFT','2023-02-03','2023-02-03 06:55:22','2023-02-04 06:55:22','1019',0.00,0.00,'1019','2023-02-03 19:26:18','1019','2023-02-03 19:27:02',10,0),('1','151',257955,'DAILY SHIFT','2023-02-04','2023-02-04 06:50:40','2023-02-05 06:50:40','1019',0.00,0.00,'1019','2023-02-04 19:45:44','1019','2023-02-04 19:46:07',10,0),('1','151',257956,'DAILY SHIFT','2023-02-05','2023-02-05 06:52:42','2023-02-06 06:52:42','1019',0.00,0.00,'1019','2023-02-05 19:23:08','1019','2023-02-05 19:23:38',10,0),('1','151',257957,'DAILY SHIFT','2023-02-06','2023-02-06 06:56:37','2023-02-07 06:56:37','1019',0.00,0.00,'1019','2023-02-06 19:47:32','1019','2023-02-06 19:47:54',10,0),('1','151',257958,'DAILY SHIFT','2023-02-07','2023-02-07 06:51:13','2023-02-08 06:51:13','1019',0.00,0.00,'1019','2023-02-07 19:14:58','1019','2023-02-07 19:15:29',10,0),('1','151',257959,'DAILY SHIFT','2023-02-08','2023-02-08 06:50:46','2023-02-09 06:50:46','1019',0.00,0.00,'1019','2023-02-08 19:27:31','1019','2023-02-08 19:27:50',10,0),('1','151',257960,'DAILY SHIFT','2023-02-09','2023-02-09 06:50:11','2023-02-10 06:50:11','1019',0.00,0.00,'1019','2023-02-09 19:22:15','1019','2023-02-09 19:22:49',10,0),('1','151',257961,'DAILY SHIFT','2023-02-10','2023-02-10 06:51:38','2023-02-11 06:51:38','1019',0.00,0.00,'1019','2023-02-10 19:17:28','1019','2023-02-10 19:17:52',10,0),('1','151',257962,'DAILY SHIFT','2023-02-11','2023-02-11 06:51:30','2023-02-12 06:51:30','1019',0.00,0.00,'1019','2023-02-11 19:03:57','1019','2023-02-11 19:04:17',10,0),('1','151',257963,'DAILY SHIFT','2023-02-12','2023-02-12 07:03:35','2023-02-13 07:03:35','1019',0.00,0.00,'1019','2023-02-12 18:44:52','1019','2023-02-12 18:45:15',10,0),('1','151',257964,'DAILY SHIFT','2023-02-12','2023-02-12 19:03:55','2023-02-13 19:03:55','1019',0.00,0.00,'1019','2023-02-12 19:26:22','1019','2023-02-12 19:26:37',10,0),('1','151',257965,'DAILY SHIFT','2023-02-13','2023-02-13 06:49:48','2023-02-14 06:49:48','1019',0.00,0.00,'1019','2023-02-13 19:27:56','1019','2023-02-13 19:28:24',10,0),('1','151',257966,'DAILY SHIFT','2023-02-14','2023-02-14 06:57:45','2023-02-15 06:57:45','1019',0.00,0.00,'1019','2023-02-14 20:04:15','1019','2023-02-14 20:04:43',10,0),('1','151',257967,'DAILY SHIFT','2023-02-15','2023-02-15 06:52:15','2023-02-16 06:52:15','1019',0.00,0.00,'1019','2023-02-15 19:14:41','1019','2023-02-15 19:15:03',10,0),('1','151',257968,'DAILY SHIFT','2023-02-16','2023-02-16 07:02:36','2023-02-17 07:02:36','1019',0.00,0.00,'1019','2023-02-16 19:09:25','1019','2023-02-16 19:10:02',10,0),('1','151',257969,'DAILY SHIFT','2023-02-17','2023-02-17 06:52:16','2023-02-18 06:52:16','1019',0.00,0.00,'1019','2023-02-17 19:15:00','1019','2023-02-17 19:15:34',10,0),('1','151',257970,'DAILY SHIFT','2023-02-18','2023-02-18 07:02:41','2023-02-19 07:02:41','1019',0.00,0.00,'1019','2023-02-18 19:15:59','1019','2023-02-18 19:16:25',10,0),('1','151',257971,'DAILY SHIFT','2023-02-19','2023-02-19 06:47:58','2023-02-20 06:47:58','1019',0.00,0.00,'1019','2023-02-19 20:29:31','1019','2023-02-19 20:29:53',10,0),('1','151',257972,'DAILY SHIFT','2023-02-20','2023-02-20 06:55:47','2023-02-21 06:55:47','1019',0.00,0.00,'1019','2023-02-20 18:51:46','1019','2023-02-20 18:52:17',10,0),('1','151',257973,'DAILY SHIFT','2023-02-21','2023-02-21 06:44:41','2023-02-22 06:44:41','1019',0.00,0.00,'1019','2023-02-21 19:31:33','1019','2023-02-21 19:32:03',10,0),('1','151',257974,'DAILY SHIFT','2023-02-22','2023-02-22 06:56:37','2023-02-23 06:56:37','1019',0.00,0.00,'1019','2023-02-22 20:01:13','1019','2023-02-22 20:01:51',10,0),('1','151',257975,'DAILY SHIFT','2023-02-23','2023-02-23 06:39:50','2023-02-24 06:39:50','1019',0.00,0.00,'1019','2023-02-23 19:53:17','1019','2023-02-23 19:53:40',10,0),('1','151',257976,'DAILY SHIFT','2023-02-24','2023-02-24 06:52:36','2023-02-25 06:52:36','1019',0.00,0.00,'1019','2023-02-24 13:43:46','1019','2023-02-24 13:44:10',10,0),('1','151',257977,'DAILY SHIFT','2023-02-24','2023-02-24 14:02:38','2023-02-25 14:02:38','1019',0.00,0.00,'1019','2023-02-24 20:25:44','1019','2023-02-24 20:26:04',10,0),('1','151',257978,'DAILY SHIFT','2023-02-26','2023-02-26 06:59:31','2023-02-27 06:59:31','1019',0.00,0.00,'1019','2023-02-26 19:04:29','1019','2023-02-26 19:04:53',10,0),('1','151',257979,'DAILY SHIFT','2023-02-27','2023-02-27 06:41:41','2023-02-28 06:41:41','1019',0.00,0.00,'1019','2023-02-27 19:27:32','1019','2023-02-27 19:28:01',10,0),('1','151',257980,'DAILY SHIFT','2023-02-28','2023-02-28 07:10:05','2023-03-01 07:10:05','1019',0.00,0.00,'1019','2023-02-28 18:52:52','1019','2023-02-28 18:53:16',10,0),('1','151',257981,'DAILY SHIFT','2023-03-01','2023-03-01 06:45:50','2023-03-02 06:45:50','1019',0.00,0.00,'1019','2023-03-01 20:09:32','1019','2023-03-01 20:09:58',10,0),('1','151',257982,'DAILY SHIFT','2023-03-02','2023-03-02 06:53:56','2023-03-03 06:53:56','1019',0.00,0.00,'1019','2023-03-02 19:08:26','1019','2023-03-02 19:08:53',10,0),('1','151',257983,'DAILY SHIFT','2023-03-03','2023-03-03 06:30:47','2023-03-04 06:30:47','1019',0.00,0.00,'1019','2023-03-03 19:45:49','1019','2023-03-03 19:46:14',10,0),('1','151',257984,'DAILY SHIFT','2023-03-04','2023-03-04 06:52:19','2023-03-05 06:52:19','1019',0.00,0.00,'1019','2023-03-04 19:38:28','1019','2023-03-04 19:38:49',10,0),('1','151',257985,'DAILY SHIFT','2023-03-05','2023-03-05 06:50:54','2023-03-06 06:50:54','1019',0.00,0.00,'1019','2023-03-05 19:12:27','1019','2023-03-05 19:12:50',10,0),('1','151',257986,'DAILY SHIFT','2023-03-06','2023-03-06 06:52:37','2023-03-07 06:52:37','1019',0.00,0.00,'1019','2023-03-06 20:02:14','1019','2023-03-06 20:02:50',10,0),('1','151',257987,'DAILY SHIFT','2023-03-07','2023-03-07 06:48:24','2023-03-08 06:48:24','1019',0.00,0.00,'1019','2023-03-07 19:23:52','1019','2023-03-07 19:24:16',10,0),('1','151',257988,'DAILY SHIFT','2023-03-08','2023-03-08 07:01:39','2023-03-09 07:01:39','1019',0.00,0.00,'1019','2023-03-08 08:09:40','1019','2023-03-08 08:09:57',10,0),('1','151',257989,'DAILY SHIFT','2023-03-08','2023-03-08 08:12:30','2023-03-09 08:12:30','1019',0.00,0.00,'1019','2023-03-08 19:32:43','1019','2023-03-08 19:33:10',10,0),('1','151',257990,'DAILY SHIFT','2023-03-09','2023-03-09 06:49:14','2023-03-10 06:49:14','1019',0.00,0.00,'1019','2023-03-09 16:58:14','1019','2023-03-09 17:00:09',10,0),('1','151',257991,'DAILY SHIFT','2023-03-10','2023-03-10 06:56:49','2023-03-11 06:56:49','1019',0.00,0.00,'1019','2023-03-10 19:27:55','1019','2023-03-10 19:28:33',10,0),('1','151',257992,'DAILY SHIFT','2023-03-11','2023-03-11 06:50:48','2023-03-12 06:50:48','1019',0.00,0.00,'1019','2023-03-11 19:31:07','1019','2023-03-11 19:31:41',10,0),('1','151',257993,'DAILY SHIFT','2023-03-12','2023-03-12 07:02:38','2023-03-13 07:02:38','1019',0.00,0.00,'1019','2023-03-12 12:27:39','1019','2023-03-12 12:27:58',10,0),('1','151',257994,'DAILY SHIFT','2023-03-12','2023-03-12 14:52:26','2023-03-13 14:52:26','1019',0.00,0.00,'1019','2023-03-12 19:43:17','1019','2023-03-12 19:43:35',10,0),('1','151',257995,'DAILY SHIFT','2023-03-13','2023-03-13 06:46:53','2023-03-14 06:46:53','1019',0.00,0.00,'1019','2023-03-13 19:35:25','1019','2023-03-13 19:35:51',10,0),('1','151',257996,'DAILY SHIFT','2023-03-14','2023-03-14 06:47:48','2023-03-15 06:47:48','1019',0.00,0.00,'1019','2023-03-14 19:30:20','1019','2023-03-14 19:30:54',10,0),('1','151',257997,'DAILY SHIFT','2023-03-15','2023-03-15 06:52:42','2023-03-16 06:52:42','1019',0.00,0.00,'1019','2023-03-15 09:09:48','1019','2023-03-15 09:10:15',10,0),('1','151',257998,'DAILY SHIFT','2023-03-15','2023-03-15 12:29:38','2023-03-16 12:29:38','1019',0.00,0.00,'1019','2023-03-15 19:47:55','1019','2023-03-15 19:48:17',10,0),('1','151',257999,'DAILY SHIFT','2023-03-16','2023-03-16 06:56:21','2023-03-17 06:56:21','1019',0.00,0.00,'1019','2023-03-16 19:22:48','1019','2023-03-16 19:23:22',10,0),('1','151',258000,'DAILY SHIFT','2023-03-17','2023-03-17 06:48:24','2023-03-18 06:48:24','1019',0.00,0.00,'1019','2023-03-17 12:50:11','1019','2023-03-17 12:50:42',10,0),('1','151',258001,'DAILY SHIFT','2023-03-17','2023-03-17 12:51:45','2023-03-18 12:51:45','1019',0.00,0.00,'1019','2023-03-19 07:02:58','1019','2023-03-19 07:03:20',10,0),('1','151',258002,'DAILY SHIFT','2023-03-19','2023-03-19 07:03:42','2023-03-20 07:03:42','1019',0.00,0.00,'1019','2023-03-19 16:48:15','1019','2023-03-19 16:48:34',10,0),('1','151',258003,'DAILY SHIFT','2023-03-20','2023-03-20 07:04:06','2023-03-21 07:04:06','1019',0.00,0.00,'1019','2023-03-20 11:29:38','1019','2023-03-20 11:29:57',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904603 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','151','755','142624',2854708,'2119','314',1296456.28,1296734.79,0.00,0.00,278.51,71298.56,0.00,0.00,0.00),('1','151','755','142624',2854709,'2120','314',479286.92,480328.52,0.00,0.00,1041.60,266649.60,0.00,0.00,0.00),('1','151','755','143134',2864933,'2119','314',1296734.79,1298279.20,0.00,0.00,1544.41,395368.96,0.00,0.00,0.00),('1','151','755','143134',2864934,'2120','314',480328.52,481463.52,0.00,0.00,1135.00,290560.00,0.00,0.00,0.00),('1','151','755','143510',2872321,'2119','314',1298279.20,1298279.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143510',2872322,'2120','314',481463.52,481620.52,0.00,0.00,157.00,40192.00,0.00,0.00,0.00),('1','151','755','143520',2872515,'2119','314',1298279.20,1298622.07,0.00,0.00,342.87,87774.72,0.00,0.00,0.00),('1','151','755','143520',2872516,'2120','314',481620.52,481707.02,0.00,0.00,86.50,22144.00,0.00,0.00,0.00),('1','151','755','143524',2872605,'2119','314',1298622.07,0.00,0.00,0.00,1009.38,258401.28,0.00,0.00,0.00),('1','151','755','143524',2872606,'2120','314',481707.02,0.00,0.00,0.00,2559.80,655308.80,0.00,0.00,0.00),('1','151','755','143648',2875106,'2119','314',1298622.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143648',2875107,'2120','314',481707.02,0.00,0.00,0.00,446.00,114176.00,0.00,0.00,0.00),('1','151','755','143655',2875204,'2119','314',1299631.97,1300334.42,0.00,0.00,702.45,179827.20,0.00,0.00,0.00),('1','151','755','143655',2875205,'2120','314',484712.89,485709.85,0.00,0.00,996.96,255221.76,0.00,0.00,0.00),('1','151','755','143664',2875383,'2119','314',1300334.42,1301326.01,0.00,0.00,991.59,253847.04,0.00,0.00,0.00),('1','151','755','143664',2875384,'2120','314',485709.85,487018.85,0.00,0.00,1309.00,335104.00,0.00,0.00,0.00),('1','151','755','143680',2875734,'2119','314',1301326.01,1301326.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143680',2875735,'2120','314',487018.85,487597.85,0.00,0.00,579.00,148224.00,0.00,0.00,0.00),('1','151','755','143691',2875965,'2119','314',1301326.01,1301619.83,0.00,0.00,293.82,75217.92,0.00,0.00,0.00),('1','151','755','143691',2875966,'2120','314',487597.85,487938.21,0.00,0.00,340.36,87132.16,0.00,0.00,0.00),('1','151','755','143697',2876049,'2119','314',1301619.83,1302922.99,0.00,0.00,1303.16,333608.96,0.00,0.00,0.00),('1','151','755','143697',2876050,'2120','314',487938.21,490001.21,0.00,0.00,2063.00,528128.00,0.00,0.00,0.00),('1','151','755','143715',2876399,'2119','314',1302922.99,1302922.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143715',2876400,'2120','314',490001.21,490197.37,0.00,0.00,196.16,50216.96,0.00,0.00,0.00),('1','151','755','143738',2876861,'2119','314',1302922.99,1303136.38,0.00,0.00,213.39,54627.84,0.00,0.00,0.00),('1','151','755','143738',2876862,'2120','314',490197.37,490366.37,0.00,0.00,169.00,43264.00,0.00,0.00,0.00),('1','151','755','143828',2878782,'2119','314',1303136.38,1303387.05,0.00,0.00,250.67,64171.52,0.00,0.00,0.00),('1','151','755','143828',2878783,'2120','314',490366.37,490611.39,0.00,0.00,245.02,62725.12,0.00,0.00,0.00),('1','151','755','143831',2878819,'2119','314',1303387.05,1304212.42,0.00,0.00,825.37,211294.72,0.00,0.00,0.00),('1','151','755','143831',2878820,'2120','314',490611.39,491489.67,0.00,0.00,878.28,224839.68,0.00,0.00,0.00),('1','151','755','143836',2878896,'2119','314',1304212.42,1305133.33,0.00,0.00,920.91,235752.96,0.00,0.00,0.00),('1','151','755','143836',2878897,'2120','314',491489.67,492354.46,0.00,0.00,864.79,221386.24,0.00,0.00,0.00),('1','151','755','143841',2878980,'2119','314',1305133.33,1305148.54,0.00,0.00,15.21,3893.76,0.00,0.00,0.00),('1','151','755','143841',2878981,'2120','314',492354.46,492354.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143855',2879358,'2119','314',1305148.54,1305404.54,0.00,0.00,256.00,65812.48,0.00,0.00,0.00),('1','151','755','143855',2879359,'2120','314',492354.46,492714.80,0.00,0.00,360.34,92247.04,0.00,0.00,0.00),('1','151','755','143861',2879472,'2119','314',1305404.54,1306721.88,0.00,0.00,1317.34,337239.04,0.00,0.00,0.00),('1','151','755','143861',2879473,'2120','314',492714.80,494563.81,0.00,0.00,1849.01,473346.56,0.00,0.00,0.00),('1','151','755','143863',2879515,'2119','314',1306721.88,1307414.42,0.00,0.00,692.54,177290.24,0.00,0.00,0.00),('1','151','755','143863',2879516,'2120','314',494563.81,494721.81,0.00,0.00,158.00,40448.00,0.00,0.00,0.00),('1','151','755','143868',2879610,'2119','314',1307414.42,1307414.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143868',2879611,'2120','314',494721.81,495304.81,0.00,0.00,583.00,149248.00,0.00,0.00,0.00),('1','151','755','143871',2879683,'2119','314',1307414.42,1309350.90,0.00,0.00,1936.48,495738.88,0.00,0.00,0.00),('1','151','755','143871',2879684,'2120','314',495304.81,496249.54,0.00,0.00,944.73,241850.88,0.00,0.00,0.00),('1','151','755','143876',2879783,'2119','314',1309350.90,1310469.90,0.00,0.00,1119.00,286464.00,0.00,0.00,0.00),('1','151','755','143876',2879784,'2120','314',496249.54,496249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143882',2879858,'2119','314',1310469.90,1310494.75,0.00,0.00,24.85,6361.60,0.00,0.00,0.00),('1','151','755','143882',2879859,'2120','314',496249.54,496793.54,0.00,0.00,544.00,139264.00,0.00,0.00,0.00),('1','151','755','143886',2879923,'2119','314',1310494.75,1311130.90,0.00,0.00,636.15,175577.40,0.00,0.00,0.00),('1','151','755','143886',2879924,'2120','314',496793.54,497457.59,0.00,0.00,664.05,183277.80,0.00,0.00,0.00),('1','151','755','143890',2879984,'2119','314',1311130.90,1312265.36,0.00,0.00,1134.46,313110.96,0.00,0.00,0.00),('1','151','755','143890',2879985,'2120','314',497457.59,499023.59,0.00,0.00,1566.00,432216.00,0.00,0.00,0.00),('1','151','755','143892',2880001,'2119','314',1312265.36,1312265.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','143892',2880002,'2120','314',499023.59,499137.59,0.00,0.00,114.00,31464.00,0.00,0.00,0.00),('1','151','755','143894',2880016,'2119','314',1312265.36,1312412.22,0.00,0.00,146.86,40533.36,0.00,0.00,0.00),('1','151','755','143894',2880017,'2120','314',499137.59,499456.25,0.00,0.00,318.66,87950.16,0.00,0.00,0.00),('1','151','755','143955',2881144,'2119','314',1312412.22,1313520.66,0.00,0.00,1108.44,305929.44,0.00,0.00,0.00),('1','151','755','143955',2881145,'2120','314',499456.25,500889.42,0.00,0.00,1433.17,395554.92,0.00,0.00,0.00),('1','151','755','143962',2881290,'2119','314',1313520.66,1314199.41,0.00,0.00,678.75,187335.00,0.00,0.00,0.00),('1','151','755','143962',2881291,'2120','314',500889.42,502260.42,0.00,0.00,1371.00,378396.00,0.00,0.00,0.00),('1','151','755','143992',2881904,'2119','314',1314199.41,1315168.60,0.00,0.00,969.19,267496.44,0.00,0.00,0.00),('1','151','755','143992',2881905,'2120','314',502260.42,503886.35,0.00,0.00,1625.93,448756.68,0.00,0.00,0.00),('1','151','755','143997',2881998,'2119','314',1315168.60,1315721.01,0.00,0.00,552.41,152465.16,0.00,0.00,0.00),('1','151','755','143997',2881999,'2120','314',503886.35,505310.35,0.00,0.00,1424.00,393024.00,0.00,0.00,0.00),('1','151','755','144004',2882122,'2119','314',1315721.01,1316593.72,0.00,0.00,872.71,240867.96,0.00,0.00,0.00),('1','151','755','144004',2882123,'2120','314',505310.35,507152.59,0.00,0.00,1842.24,508458.24,0.00,0.00,0.00),('1','151','755','144007',2882168,'2119','314',1316593.72,1317154.97,0.00,0.00,561.25,154905.00,0.00,0.00,0.00),('1','151','755','144007',2882169,'2120','314',507152.59,508170.59,0.00,0.00,1018.00,280968.00,0.00,0.00,0.00),('1','151','755','144008',2882170,'2119','314',1317154.97,1317621.81,0.00,0.00,466.84,128847.84,0.00,0.00,0.00),('1','151','755','144008',2882171,'2120','314',508170.59,508553.94,0.00,0.00,383.35,105804.60,0.00,0.00,0.00),('1','151','755','144011',2882206,'2119','314',1317621.81,1319514.63,0.00,0.00,1892.82,522418.32,0.00,0.00,0.00),('1','151','755','144011',2882207,'2120','314',508553.94,509274.12,0.00,0.00,720.18,198769.68,0.00,0.00,0.00),('1','151','755','144087',2883817,'2119','314',1319514.63,1320580.63,0.00,0.00,1066.00,294216.00,0.00,0.00,0.00),('1','151','755','144087',2883818,'2120','314',509274.12,509274.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','144122',2884331,'2119','314',1320580.63,1320580.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','144122',2884332,'2120','314',509274.12,513375.07,0.00,0.00,4100.95,1131862.20,0.00,0.00,0.00),('1','151','755','144285',2887560,'2119','314',1320580.63,1320624.47,0.00,0.00,43.84,12099.84,0.00,0.00,0.00),('1','151','755','144285',2887561,'2120','314',513375.07,513800.84,0.00,0.00,425.77,117512.52,0.00,0.00,0.00),('1','151','755','144303',2887957,'2119','314',1320624.47,1321886.28,0.00,0.00,1261.81,348259.56,0.00,0.00,0.00),('1','151','755','144303',2887958,'2120','314',513800.84,514520.29,0.00,0.00,719.45,198568.20,0.00,0.00,0.00),('1','151','755','144435',2890356,'2119','314',1321886.28,1323407.11,0.00,0.00,1520.83,419749.08,0.00,0.00,0.00),('1','151','755','144435',2890357,'2120','314',514520.29,515603.29,0.00,0.00,1083.00,298908.00,0.00,0.00,0.00),('1','151','755','144587',2893450,'2119','314',1323407.11,1325488.72,0.00,0.00,2081.61,532892.16,0.00,0.00,53.36),('1','151','755','144587',2893451,'2120','314',515603.29,516783.62,0.00,0.00,1180.33,302164.48,0.00,0.00,0.00),('1','151','755','144721',2895936,'2119','314',1325488.72,1326177.62,0.00,0.00,688.90,176358.40,0.00,0.00,0.00),('1','151','755','144721',2895937,'2120','314',516783.62,517392.62,0.00,0.00,609.00,155904.00,0.00,0.00,0.00),('1','151','755','144724',2895979,'2119','314',1326177.62,1326771.14,0.00,0.00,593.52,151941.12,0.00,0.00,0.00),('1','151','755','144724',2895980,'2120','314',517392.62,517870.00,0.00,0.00,477.38,122209.28,0.00,0.00,0.00),('1','151','755','144831',2897952,'2119','314',1326771.14,1328421.78,0.00,0.00,1650.64,422563.84,0.00,0.00,0.00),('1','151','755','144831',2897953,'2120','314',517870.00,518935.98,0.00,0.00,1065.98,272890.88,0.00,0.00,0.00),('1','151','755','144901',2899313,'2119','314',1328421.78,1328815.39,0.00,0.00,393.61,100764.16,0.00,0.00,0.00),('1','151','755','144901',2899314,'2120','314',518935.98,519271.98,0.00,0.00,336.00,86016.00,0.00,0.00,0.00),('1','151','755','144988',2900920,'2119','314',1328815.39,1330118.16,0.00,0.00,1302.77,333509.12,0.00,0.00,0.00),('1','151','755','144988',2900921,'2120','314',519271.98,520376.70,0.00,0.00,1104.72,282808.32,0.00,0.00,0.00),('1','151','755','145267',2906437,'2119','314',1330118.16,1331412.81,0.00,0.00,1294.65,331430.40,0.00,0.00,0.00),('1','151','755','145267',2906438,'2120','314',520376.70,521292.70,0.00,0.00,916.00,234496.00,0.00,0.00,0.00),('1','151','755','145269',2906453,'2119','314',1331412.81,1331934.03,0.00,0.00,521.22,133432.32,0.00,0.00,0.00),('1','151','755','145269',2906454,'2120','314',521292.70,521881.58,0.00,0.00,588.88,150753.28,0.00,0.00,0.00),('1','151','755','145273',2906504,'2119','314',1331934.03,1333879.68,0.00,0.00,1945.65,498086.40,0.00,0.00,0.00),('1','151','755','145273',2906505,'2120','314',521881.58,523398.58,0.00,0.00,1517.00,388352.00,0.00,0.00,0.00),('1','151','755','145299',2907012,'2119','314',1333879.68,1334164.32,0.00,0.00,284.64,72867.84,0.00,0.00,0.00),('1','151','755','145299',2907013,'2120','314',523398.58,523699.63,0.00,0.00,301.05,77068.80,0.00,0.00,0.00),('1','151','755','145327',2907485,'2119','314',1334164.32,1336278.07,0.00,0.00,2113.75,541120.00,0.00,0.00,0.00),('1','151','755','145327',2907486,'2120','314',523699.63,525556.63,0.00,0.00,1857.00,475392.00,0.00,0.00,0.00),('1','151','755','145408',2909142,'2119','314',1336278.07,1336823.90,0.00,0.00,545.83,139732.48,0.00,0.00,0.00),('1','151','755','145408',2909143,'2120','314',525556.63,525993.78,0.00,0.00,437.15,111910.40,0.00,0.00,0.00),('1','151','755','145409',2909144,'2119','314',1336823.90,1338654.64,0.00,0.00,1830.74,468669.44,0.00,0.00,0.00),('1','151','755','145409',2909145,'2120','314',525993.78,527756.78,0.00,0.00,1763.00,451328.00,0.00,0.00,0.00),('1','151','755','145466',2910443,'2119','314',1338654.64,1340979.03,0.00,0.00,2324.39,595043.84,0.00,0.00,0.00),('1','151','755','145466',2910444,'2120','314',527756.78,530010.78,0.00,0.00,2254.00,577024.00,0.00,0.00,0.00),('1','151','755','146034',2921421,'2119','314',1340979.03,1341909.08,0.00,0.00,930.05,238092.80,0.00,0.00,0.00),('1','151','755','146034',2921422,'2120','314',530010.78,530637.23,0.00,0.00,626.45,160371.20,0.00,0.00,0.00),('1','151','755','146042',2921619,'2119','314',1341909.08,1343158.56,0.00,0.00,1249.48,319866.88,0.00,0.00,0.00),('1','151','755','146042',2921620,'2120','314',530637.23,531784.37,0.00,0.00,1147.14,293667.84,0.00,0.00,0.00),('1','151','755','146046',2921729,'2119','314',1343158.56,1343165.56,0.00,0.00,7.00,1792.00,0.00,0.00,0.00),('1','151','755','146046',2921730,'2120','314',531784.37,532406.37,0.00,0.00,622.00,159232.00,0.00,0.00,0.00),('1','151','755','146049',2921797,'2119','314',1343165.56,1344174.68,0.00,0.00,1009.12,258334.72,0.00,0.00,0.00),('1','151','755','146049',2921798,'2120','314',532406.37,533578.60,0.00,0.00,1172.23,300090.88,0.00,0.00,0.00),('1','151','755','146774',2936430,'2119','314',1344174.68,1345003.12,0.00,0.00,828.44,212080.64,0.00,0.00,0.00),('1','151','755','146774',2936431,'2120','314',533578.60,533922.72,0.00,0.00,344.12,88094.72,0.00,0.00,0.00),('1','151','755','146781',2936538,'2119','314',1345003.12,1345647.08,0.00,0.00,643.96,164853.76,0.00,0.00,0.00),('1','151','755','146781',2936539,'2120','314',533922.72,534441.42,0.00,0.00,518.70,132787.20,0.00,0.00,0.00),('1','151','755','146789',2936645,'2119','314',1345647.08,1346238.99,0.00,0.00,591.91,151528.96,0.00,0.00,0.00),('1','151','755','146789',2936646,'2120','314',534441.42,535010.02,0.00,0.00,568.60,145561.60,0.00,0.00,0.00),('1','151','755','146793',2936749,'2119','314',1346238.99,1347439.40,0.00,0.00,1200.41,307304.96,0.00,0.00,0.00),('1','151','755','146793',2936750,'2120','314',535010.02,536494.14,0.00,0.00,1484.12,379934.72,0.00,0.00,0.00),('1','151','755','146797',2936792,'2119','314',1347439.40,1347962.01,0.00,0.00,522.61,133788.16,0.00,0.00,0.00),('1','151','755','146797',2936793,'2120','314',536494.14,536733.14,0.00,0.00,239.00,61184.00,0.00,0.00,0.00),('1','151','755','146806',2936900,'2119','314',1347962.01,1349295.97,0.00,0.00,1333.96,341493.76,0.00,0.00,0.00),('1','151','755','146806',2936901,'2120','314',536733.14,538338.62,0.00,0.00,1605.48,411002.88,0.00,0.00,0.00),('1','151','755','146816',2937042,'2119','314',1349295.97,1350196.26,0.00,0.00,900.29,230474.24,0.00,0.00,0.00),('1','151','755','146816',2937043,'2120','314',538338.62,539117.62,0.00,0.00,779.00,199424.00,0.00,0.00,0.00),('1','151','755','146871',2938218,'2119','314',1350196.26,1351080.94,0.00,0.00,884.68,226478.08,0.00,0.00,0.00),('1','151','755','146871',2938219,'2120','314',539117.62,539843.52,0.00,0.00,725.90,185830.40,0.00,0.00,0.00),('1','151','755','147166',2942396,'2119','314',1351080.94,1352222.75,0.00,0.00,1141.81,292303.36,0.00,0.00,0.00),('1','151','755','147166',2942397,'2120','314',539843.52,541717.52,0.00,0.00,1874.00,479744.00,0.00,0.00,0.00),('1','151','755','147344',2944871,'2119','314',1352222.75,1352834.20,0.00,0.00,611.45,156531.20,0.00,0.00,0.00),('1','151','755','147344',2944872,'2120','314',541717.52,543978.22,0.00,0.00,2260.70,578739.20,0.00,0.00,0.00),('1','151','755','147372',2945446,'2119','314',1352834.20,1353271.72,0.00,0.00,437.52,112005.12,0.00,0.00,0.00),('1','151','755','147372',2945447,'2120','314',543978.22,545266.22,0.00,0.00,1288.00,329728.00,0.00,0.00,0.00),('1','151','755','147480',2947467,'2119','314',1353271.72,1353653.13,0.00,0.00,381.41,97640.96,0.00,0.00,0.00),('1','151','755','147480',2947468,'2120','314',545266.22,545986.36,0.00,0.00,720.14,184355.84,0.00,0.00,0.00),('1','151','755','147560',2948964,'2119','314',1353653.13,1354496.01,0.00,0.00,842.88,215777.28,0.00,0.00,0.00),('1','151','755','147560',2948965,'2120','314',545986.36,548435.36,0.00,0.00,2449.00,626944.00,0.00,0.00,0.00),('1','151','755','147688',2951086,'2119','314',1354496.01,1355626.87,0.00,0.00,1130.86,289500.16,0.00,0.00,0.00),('1','151','755','147688',2951087,'2120','314',548435.36,550684.98,0.00,0.00,2249.62,575902.72,0.00,0.00,0.00),('1','151','755','147822',2953577,'2119','314',1355626.87,1355972.24,0.00,0.00,345.37,88414.72,0.00,0.00,0.00),('1','151','755','147822',2953578,'2120','314',550684.98,551733.98,0.00,0.00,1049.00,268544.00,0.00,0.00,0.00),('1','151','755','147867',2954393,'2119','314',1355972.24,1356886.13,0.00,0.00,913.89,233955.84,0.00,0.00,0.00),('1','151','755','147867',2954394,'2120','314',551733.98,552478.32,0.00,0.00,744.34,190551.04,0.00,0.00,0.00),('1','151','755','147987',2956318,'2119','314',1356886.13,1358718.47,0.00,0.00,1832.34,469079.04,0.00,0.00,0.00),('1','151','755','147987',2956319,'2120','314',552478.32,553510.32,0.00,0.00,1032.00,264192.00,0.00,0.00,0.00),('1','151','755','148129',2958725,'2119','314',1358718.47,1360654.39,0.00,0.00,1935.92,495595.52,0.00,0.00,0.00),('1','151','755','148129',2958726,'2120','314',553510.32,554747.32,0.00,0.00,1237.00,316672.00,0.00,0.00,0.00),('1','151','755','148284',2961389,'2119','314',1360654.39,1361700.98,0.00,0.00,1046.59,267927.04,0.00,0.00,0.00),('1','151','755','148284',2961390,'2120','314',554747.32,555199.32,0.00,0.00,452.00,115712.00,0.00,0.00,0.00),('1','151','755','148286',2961392,'2119','314',1361700.98,1362350.94,0.00,0.00,649.96,166389.76,0.00,0.00,0.00),('1','151','755','148286',2961393,'2120','314',555199.32,555716.50,0.00,0.00,517.18,132398.08,0.00,0.00,0.00),('1','151','755','148429',2963974,'2119','314',1362350.94,1364073.08,0.00,0.00,1722.14,440867.84,0.00,0.00,0.00),('1','151','755','148429',2963975,'2120','314',555716.50,556824.49,0.00,0.00,1107.99,283645.44,0.00,0.00,0.00),('1','151','755','148539',2965948,'2119','314',1364073.08,1364466.75,0.00,0.00,393.67,100779.52,0.00,0.00,0.00),('1','151','755','148539',2965949,'2120','314',556824.49,556983.49,0.00,0.00,159.00,40704.00,0.00,0.00,0.00),('1','151','755','148559',2966196,'2119','314',1364466.75,1365912.05,0.00,0.00,1445.30,369996.80,0.00,0.00,0.00),('1','151','755','148559',2966197,'2120','314',556983.49,557923.38,0.00,0.00,939.89,240611.84,0.00,0.00,0.00),('1','151','755','148666',2968052,'2119','314',1365912.05,1366949.83,0.00,0.00,1037.78,265671.68,0.00,0.00,0.00),('1','151','755','148666',2968053,'2120','314',557923.38,558281.28,0.00,0.00,357.90,91622.40,0.00,0.00,0.00),('1','151','755','148668',2968070,'2119','314',1366949.83,1367689.00,0.00,0.00,739.17,189227.52,0.00,0.00,0.00),('1','151','755','148668',2968071,'2120','314',558281.28,558702.51,0.00,0.00,421.23,107834.88,0.00,0.00,0.00),('1','151','755','148806',2970202,'2119','314',1367689.00,1369837.46,0.00,0.00,2148.46,550005.76,0.00,0.00,0.00),('1','151','755','148806',2970203,'2120','314',558702.51,559977.51,0.00,0.00,1275.00,326400.00,0.00,0.00,0.00),('1','151','755','148964',2973319,'2119','314',1369837.46,1371764.09,0.00,0.00,1926.63,493217.28,0.00,0.00,0.00),('1','151','755','148964',2973320,'2120','314',559977.51,561093.21,0.00,0.00,1115.70,285619.20,0.00,0.00,0.00),('1','151','755','149047',2974963,'2119','314',1371764.09,1372810.34,0.00,0.00,1046.25,267840.00,0.00,0.00,0.00),('1','151','755','149047',2974964,'2120','314',561093.21,561636.21,0.00,0.00,543.00,139008.00,0.00,0.00,0.00),('1','151','755','149144',2976829,'2119','314',1372810.34,1373555.95,0.00,0.00,745.61,190876.16,0.00,0.00,0.00),('1','151','755','149144',2976830,'2120','314',561636.21,562145.27,0.00,0.00,509.06,130319.36,0.00,0.00,0.00),('1','151','755','149299',2979526,'2119','314',1373555.95,1375401.79,0.00,0.00,1845.84,472535.04,0.00,0.00,0.00),('1','151','755','149299',2979527,'2120','314',562145.27,563333.27,0.00,0.00,1188.00,304128.00,0.00,0.00,0.00),('1','151','755','149442',2981925,'2119','314',1375401.79,1377264.04,0.00,0.00,1862.25,476736.00,0.00,0.00,0.00),('1','151','755','149442',2981926,'2120','314',563333.27,564789.19,0.00,0.00,1455.92,372715.52,0.00,0.00,0.00),('1','151','755','149669',2985729,'2119','314',1377264.04,1378065.20,0.00,0.00,801.16,205096.96,0.00,0.00,0.00),('1','151','755','149669',2985730,'2120','314',564789.19,565277.19,0.00,0.00,488.00,124928.00,0.00,0.00,0.00),('1','151','755','149673',2985772,'2119','314',1378065.20,1379051.61,0.00,0.00,986.41,252520.96,0.00,0.00,0.00),('1','151','755','149673',2985773,'2120','314',565277.19,566257.62,0.00,0.00,980.43,250990.08,0.00,0.00,0.00),('1','151','755','149674',2985774,'2119','314',1379051.61,1379807.41,0.00,0.00,755.80,193484.80,0.00,0.00,0.00),('1','151','755','149674',2985775,'2120','314',566257.62,568147.62,0.00,0.00,1890.00,483840.00,0.00,0.00,0.00),('1','151','755','149842',2988742,'2119','314',1379807.41,1382039.42,0.00,0.00,2232.01,571394.56,0.00,0.00,0.00),('1','151','755','149842',2988743,'2120','314',568147.62,569870.21,0.00,0.00,1722.59,440983.04,0.00,0.00,0.00),('1','151','755','149917',2989972,'2119','314',1382039.42,1382474.55,0.00,0.00,435.13,111393.28,0.00,0.00,0.00),('1','151','755','149917',2989973,'2120','314',569870.21,570091.21,0.00,0.00,221.00,56576.00,0.00,0.00,0.00),('1','151','755','150018',2991937,'2119','314',1382474.55,1384210.61,0.00,0.00,1736.06,444431.36,0.00,0.00,0.00),('1','151','755','150018',2991938,'2120','314',570091.21,571539.40,0.00,0.00,1448.19,370736.64,0.00,0.00,0.00),('1','151','755','150135',2994649,'2119','314',1384210.61,1385383.31,0.00,0.00,1172.70,300211.20,0.00,0.00,0.00),('1','151','755','150135',2994650,'2120','314',571539.40,572400.40,0.00,0.00,861.00,220416.00,0.00,0.00,0.00),('1','151','755','150373',2998322,'2119','314',1385383.31,1388268.78,0.00,0.00,2885.47,738680.32,0.00,0.00,0.00),('1','151','755','150373',2998323,'2120','314',572400.40,574139.40,0.00,0.00,1739.00,445184.00,0.00,0.00,0.00),('1','151','755','150545',3001731,'2119','314',1388268.78,1389085.39,0.00,0.00,816.61,209052.16,0.00,0.00,0.00),('1','151','755','150545',3001732,'2120','314',574139.40,574888.55,0.00,0.00,749.15,191782.40,0.00,0.00,0.00),('1','151','755','150707',3005109,'2119','314',1389085.39,1391006.13,0.00,0.00,1920.74,491709.44,0.00,0.00,0.00),('1','151','755','150707',3005110,'2120','314',574888.55,575977.55,0.00,0.00,1089.00,278784.00,0.00,0.00,0.00),('1','151','755','150845',3007493,'2119','314',1391006.13,1392358.06,0.00,0.00,1351.93,346094.08,0.00,0.00,0.00),('1','151','755','150845',3007494,'2120','314',575977.55,578504.62,0.00,0.00,2527.07,646929.92,0.00,0.00,0.00),('1','151','755','150899',3008436,'2119','314',1392358.06,1392408.06,0.00,0.00,50.00,12800.00,0.00,0.00,0.00),('1','151','755','150899',3008437,'2120','314',578504.62,579244.62,0.00,0.00,740.00,189440.00,0.00,0.00,0.00),('1','151','755','150988',3010138,'2119','314',1392408.06,1393183.76,0.00,0.00,775.70,198579.20,0.00,0.00,0.00),('1','151','755','150988',3010139,'2120','314',579244.62,580828.51,0.00,0.00,1583.89,405475.84,0.00,0.00,0.00),('1','151','755','151153',3013087,'2119','314',1393183.76,1393773.89,0.00,0.00,590.13,151073.28,0.00,0.00,0.00),('1','151','755','151153',3013088,'2120','314',580828.51,582520.51,0.00,0.00,1692.00,433152.00,0.00,0.00,0.00),('1','151','755','151279',3015700,'2119','314',1393773.89,1395008.31,0.00,0.00,1234.42,316011.52,0.00,0.00,0.00),('1','151','755','151279',3015701,'2120','314',582520.51,585203.31,0.00,0.00,2682.80,686796.80,0.00,0.00,0.00),('1','151','755','151415',3018318,'2119','314',1395008.31,1395084.84,0.00,0.00,76.53,19591.68,0.00,0.00,0.00),('1','151','755','151415',3018319,'2120','314',585203.31,585838.31,0.00,0.00,635.00,403225.00,0.00,0.00,0.00),('1','151','755','151487',3019327,'2119','314',1395084.84,1395830.68,0.00,0.00,745.84,190935.04,0.00,0.00,0.00),('1','151','755','151487',3019328,'2120','314',585838.31,586696.68,0.00,0.00,858.37,219742.72,0.00,0.00,0.00),('1','151','755','151583',3021190,'2119','314',1395830.68,1397269.22,0.00,0.00,1438.54,368266.24,0.00,0.00,0.00),('1','151','755','151583',3021191,'2120','314',586696.68,588225.68,0.00,0.00,1529.00,391424.00,0.00,0.00,0.00),('1','151','755','151697',3023262,'2119','314',1397269.22,1399848.61,0.00,0.00,2579.39,660323.84,0.00,0.00,0.00),('1','151','755','151697',3023263,'2120','314',588225.68,589798.59,0.00,0.00,1572.91,402664.96,0.00,0.00,0.00),('1','151','755','151790',3024942,'2119','314',1399848.61,1400297.06,0.00,0.00,448.45,114803.20,0.00,0.00,0.00),('1','151','755','151790',3024943,'2120','314',589798.59,589820.59,0.00,0.00,22.00,5632.00,0.00,0.00,0.00),('1','151','755','151817',3025459,'2119','314',1400297.06,1401838.71,0.00,0.00,1541.65,394662.40,0.00,0.00,0.00),('1','151','755','151817',3025460,'2120','314',589820.59,590824.81,0.00,0.00,1004.22,257080.32,0.00,0.00,0.00),('1','151','755','151925',3027525,'2119','314',1401838.71,1403037.16,0.00,0.00,1198.45,306803.20,0.00,0.00,0.00),('1','151','755','151925',3027526,'2120','314',590824.81,591709.81,0.00,0.00,885.00,226560.00,0.00,0.00,0.00),('1','151','755','152007',3029233,'2119','314',1403037.16,1403903.29,0.00,0.00,866.13,221729.28,0.00,0.00,0.00),('1','151','755','152007',3029234,'2120','314',591709.81,592511.00,0.00,0.00,801.19,205104.64,0.00,0.00,0.00),('1','151','755','152056',3029932,'2119','314',1403903.29,1404655.22,0.00,0.00,751.93,192494.08,0.00,0.00,0.00),('1','151','755','152056',3029933,'2120','314',592511.00,593016.00,0.00,0.00,505.00,129280.00,0.00,0.00,0.00),('1','151','755','152163',3031930,'2119','314',1404655.22,1405142.00,0.00,0.00,486.78,124615.68,0.00,0.00,0.00),('1','151','755','152163',3031931,'2120','314',593016.00,593315.58,0.00,0.00,299.58,76692.48,0.00,0.00,0.00),('1','151','755','152268',3034190,'2119','314',1405142.00,1406219.60,0.00,0.00,1077.60,275865.60,0.00,0.00,0.00),('1','151','755','152268',3034191,'2120','314',593315.58,594548.58,0.00,0.00,1233.00,315648.00,0.00,0.00,0.00),('1','151','755','152376',3035928,'2119','314',1406219.60,1407337.19,0.00,0.00,1117.59,286103.04,0.00,0.00,0.00),('1','151','755','152376',3035929,'2120','314',594548.58,595529.87,0.00,0.00,981.29,251210.24,0.00,0.00,0.00),('1','151','755','152426',3036891,'2119','314',1407337.19,1408902.13,0.00,0.00,1564.94,400624.64,0.00,0.00,0.00),('1','151','755','152426',3036892,'2120','314',595529.87,596428.87,0.00,0.00,899.00,230144.00,0.00,0.00,0.00),('1','151','755','152612',3040202,'2119','314',1408902.13,1411279.13,0.00,0.00,2377.00,608512.00,0.00,0.00,0.00),('1','151','755','152612',3040203,'2120','314',596428.87,597455.08,0.00,0.00,1026.21,262709.76,0.00,0.00,0.00),('1','151','755','152759',3042839,'2119','314',1411279.13,1411958.75,0.00,0.00,679.62,173982.72,0.00,0.00,0.00),('1','151','755','152759',3042840,'2120','314',597455.08,597929.08,0.00,0.00,474.00,121344.00,0.00,0.00,0.00),('1','151','755','152761',3042895,'2119','314',1411958.75,1412516.58,0.00,0.00,557.83,142804.48,0.00,0.00,0.00),('1','151','755','152761',3042896,'2120','314',597929.08,597929.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','152763',3042919,'2119','314',1412516.58,1412516.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','152763',3042920,'2120','314',597929.08,598532.28,0.00,0.00,603.20,154419.20,0.00,0.00,0.00),('1','151','755','152886',3045241,'2119','314',1412516.58,1414397.51,0.00,0.00,1880.93,481518.08,0.00,0.00,0.00),('1','151','755','152886',3045242,'2120','314',598532.28,599731.22,0.00,0.00,1198.94,306928.64,0.00,0.00,0.00),('1','151','755','153026',3047796,'2119','314',1414397.51,1414469.38,0.00,0.00,71.87,18398.72,0.00,0.00,0.00),('1','151','755','153026',3047797,'2120','314',599731.22,599843.22,0.00,0.00,112.00,28672.00,0.00,0.00,0.00),('1','151','755','153032',3047855,'2119','314',1414469.38,1414602.70,0.00,0.00,133.32,36263.04,0.00,0.00,0.00),('1','151','755','153032',3047856,'2120','314',599843.22,599872.22,0.00,0.00,29.00,7888.00,0.00,0.00,0.00),('1','151','755','153081',3048560,'2119','314',1414602.70,1415845.07,0.00,0.00,1242.37,337924.64,0.00,0.00,0.00),('1','151','755','153081',3048561,'2120','314',599872.22,600718.98,0.00,0.00,846.76,230318.72,0.00,0.00,0.00),('1','151','755','153265',3051811,'2119','314',1415845.07,1417167.71,0.00,0.00,1322.64,359758.08,0.00,0.00,0.00),('1','151','755','153265',3051812,'2120','314',600718.98,601917.98,0.00,0.00,1199.00,326128.00,0.00,0.00,0.00),('1','151','755','153471',3055745,'2119','314',1417167.71,1419340.69,0.00,0.00,2172.98,591050.56,0.00,0.00,0.00),('1','151','755','153471',3055746,'2120','314',601917.98,603167.46,0.00,0.00,1249.48,339858.56,0.00,0.00,0.00),('1','151','755','153630',3058629,'2119','314',1419340.69,1420191.14,0.00,0.00,850.45,231322.40,0.00,0.00,0.00),('1','151','755','153630',3058630,'2120','314',603167.46,603494.46,0.00,0.00,327.00,88944.00,0.00,0.00,0.00),('1','151','755','153636',3058734,'2119','314',1420191.14,1421039.12,0.00,0.00,847.98,230650.56,0.00,0.00,0.00),('1','151','755','153636',3058735,'2120','314',603494.46,604031.62,0.00,0.00,537.16,146107.52,0.00,0.00,0.00),('1','151','755','153798',3061596,'2119','314',1421039.12,1423078.67,0.00,0.00,2039.55,554757.60,0.00,0.00,0.00),('1','151','755','153798',3061597,'2120','314',604031.62,604864.89,0.00,0.00,833.27,226649.44,0.00,0.00,0.00),('1','151','755','153924',3063901,'2119','314',1423078.67,1423314.72,0.00,0.00,236.05,64205.60,0.00,0.00,0.00),('1','151','755','153924',3063902,'2120','314',604864.89,604961.89,0.00,0.00,97.00,26384.00,0.00,0.00,0.00),('1','151','755','153927',3063920,'2119','314',1423314.72,1424859.75,0.00,0.00,1545.03,420248.16,0.00,0.00,0.00),('1','151','755','153927',3063921,'2120','314',604961.89,606130.54,0.00,0.00,1168.65,317872.80,0.00,0.00,0.00),('1','151','755','154013',3065346,'2119','314',1424859.75,1426097.87,0.00,0.00,1238.12,336768.64,0.00,0.00,0.00),('1','151','755','154013',3065347,'2120','314',606130.54,606781.54,0.00,0.00,651.00,177072.00,0.00,0.00,0.00),('1','151','755','154034',3065769,'2119','314',1426097.87,1426282.51,0.00,0.00,184.64,50222.08,0.00,0.00,0.00),('1','151','755','154034',3065770,'2120','314',606781.54,606911.54,0.00,0.00,130.00,35360.00,0.00,0.00,0.00),('1','151','755','154295',3070397,'2119','314',1426282.51,1426673.86,0.00,0.00,391.35,106447.20,0.00,0.00,0.00),('1','151','755','154295',3070398,'2120','314',606911.54,607047.54,0.00,0.00,136.00,36992.00,0.00,0.00,0.00),('1','151','755','154413',3072555,'2119','314',1426673.86,1426879.69,0.00,0.00,205.83,55985.76,0.00,0.00,0.00),('1','151','755','154413',3072556,'2120','314',607047.54,607231.38,0.00,0.00,183.84,50004.48,0.00,0.00,0.00),('1','151','755','154572',3075721,'2119','314',1426879.69,1429580.55,0.00,0.00,2700.86,734633.92,0.00,0.00,0.00),('1','151','755','154572',3075722,'2120','314',607231.38,608763.38,0.00,0.00,1532.00,416704.00,0.00,0.00,0.00),('1','151','755','154863',3081121,'2119','314',1429580.55,1431211.42,0.00,0.00,1630.87,443596.64,0.00,0.00,0.00),('1','151','755','154863',3081122,'2120','314',608763.38,610135.18,0.00,0.00,1371.80,373129.60,0.00,0.00,0.00),('1','151','755','154961',3082894,'2119','314',1431211.42,1432147.62,0.00,0.00,936.20,254646.40,0.00,0.00,0.00),('1','151','755','154961',3082895,'2120','314',610135.18,610786.18,0.00,0.00,651.00,177072.00,0.00,0.00,0.00),('1','151','755','155016',3083995,'2119','314',1432147.62,1433366.92,0.00,0.00,1219.30,331649.60,0.00,0.00,0.00),('1','151','755','155016',3083996,'2120','314',610786.18,611830.61,0.00,0.00,1044.43,284084.96,0.00,0.00,0.00),('1','151','755','155116',3085953,'2119','314',1433366.92,1434409.85,0.00,0.00,1042.93,283676.96,0.00,0.00,0.00),('1','151','755','155116',3085954,'2120','314',611830.61,613123.61,0.00,0.00,1293.00,351696.00,0.00,0.00,0.00),('1','151','755','155135',3086274,'2119','314',1434409.85,1435403.42,0.00,0.00,993.57,270251.04,0.00,0.00,0.00),('1','151','755','155135',3086275,'2120','314',613123.61,613722.99,0.00,0.00,599.38,163031.36,0.00,0.00,0.00),('1','151','755','155279',3089008,'2119','314',1435403.42,1437230.23,0.00,0.00,1826.81,496892.32,0.00,0.00,0.00),('1','151','755','155279',3089009,'2120','314',613722.99,614894.99,0.00,0.00,1172.00,318784.00,0.00,0.00,0.00),('1','151','755','155297',3089282,'2119','314',1437230.23,1437400.12,0.00,0.00,169.89,46210.08,0.00,0.00,0.00),('1','151','755','155297',3089283,'2120','314',614894.99,614972.42,0.00,0.00,77.43,21060.96,0.00,0.00,0.00),('1','151','755','155487',3092668,'2119','314',1437400.12,1439627.99,0.00,0.00,2227.87,605980.64,0.00,0.00,0.00),('1','151','755','155487',3092669,'2120','314',614972.42,615922.75,0.00,0.00,950.33,258489.76,0.00,0.00,0.00),('1','151','755','155580',3094300,'2119','314',1439627.99,1440378.38,0.00,0.00,750.39,204106.08,0.00,0.00,0.00),('1','151','755','155580',3094301,'2120','314',615922.75,616335.75,0.00,0.00,413.00,112336.00,0.00,0.00,0.00),('1','151','755','155593',3094631,'2119','314',1440378.38,1441835.25,0.00,0.00,1456.87,396268.64,0.00,0.00,0.00),('1','151','755','155593',3094632,'2120','314',616335.75,617138.37,0.00,0.00,802.62,218312.64,0.00,0.00,0.00),('1','151','755','155784',3098145,'2119','314',1441835.25,1443118.41,0.00,0.00,1283.16,349019.52,0.00,0.00,0.00),('1','151','755','155784',3098146,'2120','314',617138.37,618216.37,0.00,0.00,1078.00,293216.00,0.00,0.00,0.00),('1','151','755','155785',3098147,'2119','314',1443118.41,1443542.70,0.00,0.00,424.29,115406.88,0.00,0.00,0.00),('1','151','755','155785',3098148,'2120','314',618216.37,618556.00,0.00,0.00,339.63,92379.36,0.00,0.00,0.00),('1','151','755','155931',3100761,'2119','314',1443542.70,1445467.85,0.00,0.00,1925.15,523640.80,0.00,0.00,0.00),('1','151','755','155931',3100762,'2120','314',618556.00,619616.03,0.00,0.00,1060.03,288328.16,0.00,0.00,0.00),('1','151','755','155976',3101497,'2119','314',1445467.85,1445993.16,0.00,0.00,525.31,142884.32,0.00,0.00,0.00),('1','151','755','155976',3101498,'2120','314',619616.03,619929.03,0.00,0.00,313.00,85136.00,0.00,0.00,0.00),('1','151','755','156061',3103224,'2119','314',1445993.16,1446646.70,0.00,0.00,653.54,177762.88,0.00,0.00,0.00),('1','151','755','156061',3103225,'2120','314',619929.03,620482.03,0.00,0.00,553.00,150416.00,0.00,0.00,0.00),('1','151','755','156063',3103254,'2119','314',1446646.70,1447156.86,0.00,0.00,510.16,138763.52,0.00,0.00,0.00),('1','151','755','156063',3103255,'2120','314',620482.03,620831.67,0.00,0.00,349.64,95102.08,0.00,0.00,0.00),('1','151','755','156200',3105592,'2119','314',1447156.86,1449580.56,0.00,0.00,2423.70,659246.40,0.00,0.00,0.00),('1','151','755','156200',3105593,'2120','314',620831.67,621463.32,0.00,0.00,631.65,171808.80,0.00,0.00,0.00),('1','151','755','156260',3106621,'2119','314',1449580.56,1449997.24,0.00,0.00,416.68,113336.96,0.00,0.00,0.00),('1','151','755','156260',3106622,'2120','314',621463.32,621683.32,0.00,0.00,220.00,59840.00,0.00,0.00,0.00),('1','151','755','156267',3106758,'2119','314',1449997.24,1451446.81,0.00,0.00,1449.57,394283.04,0.00,0.00,0.00),('1','151','755','156267',3106759,'2120','314',621683.32,622682.68,0.00,0.00,999.36,271825.92,0.00,0.00,0.00),('1','151','755','156565',3112386,'2119','314',1451446.81,1452919.77,0.00,0.00,1472.96,400645.12,0.00,0.00,0.00),('1','151','755','156565',3112387,'2120','314',622682.68,623370.68,0.00,0.00,688.00,187136.00,0.00,0.00,0.00),('1','151','755','156571',3112499,'2119','314',1452919.77,1453077.53,0.00,0.00,157.76,42910.72,0.00,0.00,0.00),('1','151','755','156571',3112500,'2120','314',623370.68,623474.73,0.00,0.00,104.05,28301.60,0.00,0.00,0.00),('1','151','755','156741',3115545,'2119','314',1453077.53,1454965.34,0.00,0.00,1887.81,513484.32,0.00,0.00,0.00),('1','151','755','156741',3115546,'2120','314',623474.73,624707.86,0.00,0.00,1233.13,335411.36,0.00,0.00,0.00),('1','151','755','156806',3116756,'2119','314',1454965.34,1455798.30,0.00,0.00,832.96,226565.12,0.00,0.00,0.00),('1','151','755','156806',3116757,'2120','314',624707.86,625039.86,0.00,0.00,332.00,90304.00,0.00,0.00,0.00),('1','151','755','156899',3118424,'2119','314',1455798.30,1456556.88,0.00,0.00,758.58,206333.76,0.00,0.00,0.00),('1','151','755','156899',3118425,'2120','314',625039.86,625513.35,0.00,0.00,473.49,128789.28,0.00,0.00,0.00),('1','151','755','157045',3121211,'2119','314',1456556.88,1457429.66,0.00,0.00,872.78,237396.16,0.00,0.00,0.00),('1','151','755','157045',3121212,'2120','314',625513.35,626063.14,0.00,0.00,549.79,149542.88,0.00,0.00,0.00),('1','151','755','157135',3122584,'2119','314',1457429.66,1458403.94,0.00,0.00,974.28,265004.16,0.00,0.00,0.00),('1','151','755','157135',3122585,'2120','314',626063.14,626570.14,0.00,0.00,507.00,137904.00,0.00,0.00,0.00),('1','151','755','157140',3122693,'2119','314',1458403.94,1458831.94,0.00,0.00,428.00,116416.00,0.00,0.00,0.00),('1','151','755','157140',3122694,'2120','314',626570.14,626570.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','157269',3125116,'2119','314',1458831.94,1460125.69,0.00,0.00,1293.75,351900.00,0.00,0.00,0.00),('1','151','755','157269',3125117,'2120','314',626570.14,627387.48,0.00,0.00,817.34,222316.48,0.00,0.00,0.00),('1','151','755','157437',3127930,'2119','314',1460125.69,1461776.43,0.00,0.00,1650.74,449001.28,0.00,0.00,0.00),('1','151','755','157437',3127931,'2120','314',627387.48,628214.48,0.00,0.00,827.00,224944.00,0.00,0.00,0.00),('1','151','755','157446',3128021,'2119','314',1461776.43,1462018.60,0.00,0.00,242.17,65870.24,0.00,0.00,0.00),('1','151','755','157446',3128022,'2120','314',628214.48,628341.48,0.00,0.00,127.00,34544.00,0.00,0.00,0.00),('1','151','755','157569',3130098,'2119','314',1462018.60,1462651.07,0.00,0.00,632.47,172031.84,0.00,0.00,0.00),('1','151','755','157569',3130099,'2120','314',628341.48,628807.48,0.00,0.00,466.00,126752.00,0.00,0.00,0.00),('1','151','755','157574',3130149,'2119','314',1462651.07,1463514.45,0.00,0.00,863.38,234839.36,0.00,0.00,0.00),('1','151','755','157574',3130150,'2120','314',628807.48,629761.36,0.00,0.00,953.88,259455.36,0.00,0.00,0.00),('1','151','755','157774',3133979,'2119','314',1463514.45,1464527.93,0.00,0.00,1013.48,275666.56,0.00,0.00,0.00),('1','151','755','157774',3133980,'2120','314',629761.36,631557.36,0.00,0.00,1796.00,488512.00,0.00,0.00,0.00),('1','151','755','157810',3134612,'2119','314',1464527.93,1464917.70,0.00,0.00,389.77,106017.44,0.00,0.00,0.00),('1','151','755','157810',3134613,'2120','314',631557.36,631947.16,0.00,0.00,389.80,106025.60,0.00,0.00,0.00),('1','151','755','157948',3137280,'2119','314',1464917.70,1466334.12,0.00,0.00,1416.42,385266.24,0.00,0.00,0.00),('1','151','755','157948',3137281,'2120','314',631947.16,633071.67,0.00,0.00,1124.51,305866.72,0.00,0.00,0.00),('1','151','755','158035',3138849,'2119','314',1466334.12,1467272.10,0.00,0.00,937.98,255130.56,0.00,0.00,0.00),('1','151','755','158035',3138850,'2120','314',633071.67,633331.67,0.00,0.00,260.00,70720.00,0.00,0.00,0.00),('1','151','755','158054',3139155,'2119','314',1467272.10,1468771.13,0.00,0.00,1499.03,407736.16,0.00,0.00,0.00),('1','151','755','158054',3139156,'2120','314',633331.67,634156.53,0.00,0.00,824.86,224361.92,0.00,0.00,0.00),('1','151','755','158170',3141235,'2119','314',1468771.13,1470135.45,0.00,0.00,1364.32,371095.04,0.00,0.00,0.00),('1','151','755','158170',3141236,'2120','314',634156.53,634972.53,0.00,0.00,816.00,221952.00,0.00,0.00,0.00),('1','151','755','158263',3143060,'2119','314',1470135.45,1470968.51,0.00,0.00,833.06,226592.32,0.00,0.00,0.00),('1','151','755','158263',3143061,'2120','314',634972.53,635867.35,0.00,0.00,894.82,243391.04,0.00,0.00,0.00),('1','151','755','158436',3146334,'2119','314',1470968.51,1472309.13,0.00,0.00,1340.62,364648.64,0.00,0.00,0.00),('1','151','755','158436',3146335,'2120','314',635867.35,637304.35,0.00,0.00,1437.00,390864.00,0.00,0.00,0.00),('1','151','755','158439',3146374,'2119','314',1472309.13,1472987.36,0.00,0.00,678.23,184478.56,0.00,0.00,0.00),('1','151','755','158439',3146375,'2120','314',637304.35,637856.14,0.00,0.00,551.79,150086.88,0.00,0.00,0.00),('1','151','755','158564',3148637,'2119','314',1472987.36,1474840.05,0.00,0.00,1852.69,503931.68,0.00,0.00,0.00),('1','151','755','158564',3148638,'2120','314',637856.14,639526.14,0.00,0.00,1670.00,454240.00,0.00,0.00,0.00),('1','151','755','158733',3151818,'2119','314',1474840.05,1476668.68,0.00,0.00,1828.63,497387.36,0.00,0.00,0.00),('1','151','755','158733',3151819,'2120','314',639526.14,641091.19,0.00,0.00,1565.05,425693.60,0.00,0.00,0.00),('1','151','755','158824',3153059,'2119','314',1476668.68,1477385.77,0.00,0.00,717.09,195048.48,0.00,0.00,0.00),('1','151','755','158824',3153060,'2120','314',641091.19,641541.19,0.00,0.00,450.00,122400.00,0.00,0.00,0.00),('1','151','755','158826',3153079,'2119','314',1477385.77,1478545.68,0.00,0.00,1159.91,315495.52,0.00,0.00,0.00),('1','151','755','158826',3153080,'2120','314',641541.19,642781.92,0.00,0.00,1240.73,337478.56,0.00,0.00,0.00),('1','151','755','159105',3158277,'2119','314',1478545.68,1479947.60,0.00,0.00,1401.92,381322.24,0.00,0.00,0.00),('1','151','755','159105',3158278,'2120','314',642781.92,643517.92,0.00,0.00,736.00,200192.00,0.00,0.00,0.00),('1','151','755','159111',3158302,'2119','314',1479947.60,1480636.71,0.00,0.00,689.11,187437.92,0.00,0.00,0.00),('1','151','755','159111',3158303,'2120','314',643517.92,644301.18,0.00,0.00,783.26,213046.72,0.00,0.00,0.00),('1','151','755','159268',3161332,'2119','314',1480636.71,1481570.66,0.00,0.00,933.95,254034.40,0.00,0.00,0.00),('1','151','755','159268',3161333,'2120','314',644301.18,645794.10,0.00,0.00,1492.92,406074.24,0.00,0.00,0.00),('1','151','755','159271',3161374,'2119','314',1481570.66,1481918.70,0.00,0.00,348.04,94666.88,0.00,0.00,0.00),('1','151','755','159271',3161375,'2120','314',645794.10,646130.10,0.00,0.00,336.00,91392.00,0.00,0.00,0.00),('1','151','755','159275',3161429,'2119','314',1481918.70,1482516.38,0.00,0.00,597.68,162568.96,0.00,0.00,0.00),('1','151','755','159275',3161430,'2120','314',646130.10,646634.58,0.00,0.00,504.48,0.00,0.00,0.00,0.00),('1','151','755','159443',3163972,'2119','314',1482516.38,1483939.20,0.00,0.00,1422.82,387007.04,0.00,0.00,0.00),('1','151','755','159443',3163973,'2120','314',646634.58,647685.87,0.00,0.00,1051.29,285950.88,0.00,0.00,0.00),('1','151','755','159447',3164059,'2119','314',1483939.20,1484276.32,0.00,0.00,337.12,91696.64,0.00,0.00,0.00),('1','151','755','159447',3164060,'2120','314',647685.87,647963.68,0.00,0.00,277.81,75564.32,0.00,0.00,0.00),('1','151','755','159636',3167471,'2119','314',1484276.32,1486264.34,0.00,0.00,1988.02,540741.44,0.00,0.00,0.00),('1','151','755','159636',3167472,'2120','314',647963.68,649921.68,0.00,0.00,1958.00,532576.00,0.00,0.00,0.00),('1','151','755','159736',3169044,'2119','314',1486264.34,1488076.92,0.00,0.00,1812.58,493021.76,0.00,0.00,0.00),('1','151','755','159736',3169045,'2120','314',649921.68,651659.50,0.00,0.00,1737.82,472687.04,0.00,0.00,0.00),('1','151','755','159889',3171712,'2119','314',1488076.92,1488826.12,0.00,0.00,749.20,203782.40,0.00,0.00,0.00),('1','151','755','159889',3171713,'2120','314',651659.50,651932.50,0.00,0.00,273.00,74256.00,0.00,0.00,0.00),('1','151','755','159893',3171793,'2119','314',1488826.12,1489997.52,0.00,0.00,1171.40,318620.80,0.00,0.00,0.00),('1','151','755','159893',3171794,'2120','314',651932.50,652974.63,0.00,0.00,1042.13,283459.36,0.00,0.00,0.00),('1','151','755','160028',3174242,'2119','314',1489997.52,1491232.83,0.00,0.00,1235.31,336004.32,0.00,0.00,0.00),('1','151','755','160028',3174243,'2120','314',652974.63,654071.63,0.00,0.00,1097.00,298384.00,0.00,0.00,0.00),('1','151','755','160127',3176283,'2119','314',1491232.83,1491945.42,0.00,0.00,712.59,193824.48,0.00,0.00,0.00),('1','151','755','160127',3176284,'2120','314',654071.63,654967.42,0.00,0.00,895.79,243654.88,0.00,0.00,0.00),('1','151','755','160263',3178553,'2119','314',1491945.42,1492341.72,0.00,0.00,396.30,107793.60,0.00,0.00,0.00),('1','151','755','160263',3178554,'2120','314',654967.42,655211.90,0.00,0.00,244.48,66498.56,0.00,0.00,0.00),('1','151','755','160271',3178735,'2119','314',1492341.72,1494354.51,0.00,0.00,2012.79,547478.88,0.00,0.00,0.00),('1','151','755','160271',3178736,'2120','314',655211.90,657447.90,0.00,0.00,2236.00,608192.00,0.00,0.00,0.00),('1','151','755','160353',3180105,'2119','314',1494354.51,1494642.29,0.00,0.00,287.78,78276.16,0.00,0.00,0.00),('1','151','755','160353',3180106,'2120','314',657447.90,657485.90,0.00,0.00,38.00,10336.00,0.00,0.00,0.00),('1','151','755','160588',3184564,'2119','314',1494642.29,1496495.79,0.00,0.00,1853.50,548636.00,0.00,0.00,0.00),('1','151','755','160588',3184565,'2120','314',657485.90,659397.34,0.00,0.00,1911.44,565786.24,0.00,0.00,0.00),('1','151','755','160653',3185537,'2119','314',1496495.79,1496831.94,0.00,0.00,336.15,99500.40,0.00,0.00,0.00),('1','151','755','160653',3185538,'2120','314',659397.34,659848.34,0.00,0.00,451.00,133496.00,0.00,0.00,0.00),('1','151','755','160686',3186150,'2119','314',1496831.94,1498015.96,0.00,0.00,1184.02,350469.92,0.00,0.00,0.00),('1','151','755','160686',3186151,'2120','314',659848.34,661057.32,0.00,0.00,1208.98,357858.08,0.00,0.00,0.00),('1','151','755','160878',3189387,'2119','314',1498015.96,1498811.09,0.00,0.00,795.13,235358.48,0.00,0.00,0.00),('1','151','755','160878',3189388,'2120','314',661057.32,662443.32,0.00,0.00,1386.00,410256.00,0.00,0.00,0.00),('1','151','755','160894',3189587,'2119','314',1498811.09,1499364.20,0.00,0.00,553.11,163720.56,0.00,0.00,0.00),('1','151','755','160894',3189588,'2120','314',662443.32,663025.30,0.00,0.00,581.98,172266.08,0.00,0.00,0.00),('1','151','755','161092',3193227,'2119','314',1499364.20,1500990.82,0.00,0.00,1626.62,481479.52,0.00,0.00,0.00),('1','151','755','161092',3193228,'2120','314',663025.30,664805.30,0.00,0.00,1780.00,526880.00,0.00,0.00,0.00),('1','151','755','161185',3195014,'2119','314',1500990.82,1502397.39,0.00,0.00,1406.57,416344.72,0.00,0.00,0.00),('1','151','755','161185',3195015,'2120','314',664805.30,666589.44,0.00,0.00,1784.14,528105.44,0.00,0.00,0.00),('1','151','755','161313',3196952,'2119','314',1502397.39,1502992.86,0.00,0.00,595.47,176209.12,0.00,0.00,0.00),('1','151','755','161313',3196953,'2120','314',666589.44,667396.93,0.00,0.00,807.49,239017.04,0.00,0.00,0.00),('1','151','755','161458',3199486,'2119','314',1502992.86,1503384.15,0.00,0.00,391.29,115821.84,0.00,0.00,0.00),('1','151','755','161458',3199487,'2120','314',667396.93,668136.78,0.00,0.00,739.85,218995.60,0.00,0.00,0.00),('1','151','755','161663',3202978,'2119','314',1503384.15,1504601.05,0.00,0.00,1216.90,360202.40,0.00,0.00,0.00),('1','151','755','161663',3202979,'2120','314',668136.78,669892.78,0.00,0.00,1756.00,519776.00,0.00,0.00,0.00),('1','151','755','161823',3205864,'2119','314',1504601.05,1504843.92,0.00,0.00,242.87,71889.52,0.00,0.00,0.00),('1','151','755','161823',3205865,'2120','314',669892.78,670107.78,0.00,0.00,215.00,63640.00,0.00,0.00,0.00),('1','151','755','161828',3205924,'2119','314',1504843.92,1505738.13,0.00,0.00,894.21,264686.16,0.00,0.00,0.00),('1','151','755','161828',3205925,'2120','314',670107.78,671522.69,0.00,0.00,1414.91,418813.36,0.00,0.00,0.00),('1','151','755','162023',3209505,'2119','314',1505738.13,1506711.59,0.00,0.00,973.46,288144.16,0.00,0.00,0.00),('1','151','755','162023',3209506,'2120','314',671522.69,672839.10,0.00,0.00,1316.41,389657.36,0.00,0.00,0.00),('1','151','755','162029',3209570,'2119','314',1506711.59,1507099.76,0.00,0.00,388.17,114898.32,0.00,0.00,0.00),('1','151','755','162029',3209571,'2120','314',672839.10,673090.83,0.00,0.00,251.73,74512.08,0.00,0.00,0.00),('1','151','755','162244',3213177,'2119','314',1507099.76,1508159.88,0.00,0.00,1060.12,313795.52,0.00,0.00,0.00),('1','151','755','162244',3213178,'2120','314',673090.83,674973.54,0.00,0.00,1882.71,557282.16,0.00,0.00,0.00),('1','151','755','162321',3214339,'2119','314',1508159.88,1508658.00,0.00,0.00,498.12,147443.52,0.00,0.00,0.00),('1','151','755','162321',3214340,'2120','314',674973.54,675430.54,0.00,0.00,457.00,135272.00,0.00,0.00,0.00),('1','151','755','162380',3215384,'2119','314',1508658.00,1509426.22,0.00,0.00,768.22,227393.12,0.00,0.00,0.00),('1','151','755','162380',3215385,'2120','314',675430.54,676632.29,0.00,0.00,1201.75,355718.00,0.00,0.00,0.00),('1','151','755','162641',3219695,'2119','314',1509426.22,1510372.28,0.00,0.00,946.06,280033.76,0.00,0.00,0.00),('1','151','755','162641',3219696,'2120','314',676632.29,678275.29,0.00,0.00,1643.00,486328.00,0.00,0.00,0.00),('1','151','755','162643',3219699,'2119','314',1510372.28,1510502.95,0.00,0.00,130.67,38678.32,0.00,0.00,0.00),('1','151','755','162643',3219700,'2120','314',678275.29,678396.81,0.00,0.00,121.52,35969.92,0.00,0.00,0.00),('1','151','755','162813',3222871,'2119','314',1510502.95,1512076.83,0.00,0.00,1573.88,465868.48,0.00,0.00,0.00),('1','151','755','162813',3222872,'2120','314',678396.81,680202.93,0.00,0.00,1806.12,534611.52,0.00,0.00,0.00),('1','151','755','162905',3224370,'2119','314',1512076.83,1512424.74,0.00,0.00,347.91,102981.36,0.00,0.00,0.00),('1','151','755','162905',3224371,'2120','314',680202.93,680789.93,0.00,0.00,587.00,173752.00,0.00,0.00,0.00),('1','151','755','162911',3224509,'2119','314',1512424.74,1512912.78,0.00,0.00,488.04,144459.84,0.00,0.00,0.00),('1','151','755','162911',3224510,'2120','314',680789.93,681479.49,0.00,0.00,689.56,204109.76,0.00,0.00,0.00),('1','151','755','163194',3229669,'2119','314',1512912.78,1514239.89,0.00,0.00,1327.11,392824.56,0.00,0.00,0.00),('1','151','755','163194',3229670,'2120','314',681479.49,683202.49,0.00,0.00,1723.00,510008.00,0.00,0.00,0.00),('1','151','755','163340',3232238,'2119','314',1514239.89,1514413.76,0.00,0.00,173.87,51465.52,0.00,0.00,0.00),('1','151','755','163340',3232239,'2120','314',683202.49,683258.49,0.00,0.00,56.00,16576.00,0.00,0.00,0.00),('1','151','755','163342',3232241,'2119','314',1514413.76,1515438.64,0.00,0.00,1024.88,303364.48,0.00,0.00,0.00),('1','151','755','163342',3232242,'2120','314',683258.49,684855.51,0.00,0.00,1597.02,472717.92,0.00,0.00,0.00),('1','151','755','163538',3235837,'2119','314',1515438.64,1516408.20,0.00,0.00,969.56,286989.76,0.00,0.00,0.00),('1','151','755','163538',3235838,'2120','314',684855.51,685838.51,0.00,0.00,983.00,290968.00,0.00,0.00,0.00),('1','151','755','163539',3235839,'2119','314',1516408.20,1516977.00,0.00,0.00,568.80,168364.80,0.00,0.00,0.00),('1','151','755','163539',3235840,'2120','314',685838.51,686314.83,0.00,0.00,476.32,140990.72,0.00,0.00,0.00),('1','151','755','163726',3239203,'2119','314',1516977.00,1518214.66,0.00,0.00,1237.66,366347.36,0.00,0.00,0.00),('1','151','755','163726',3239204,'2120','314',686314.83,688225.83,0.00,0.00,1911.00,565656.00,0.00,0.00,0.00),('1','151','755','163786',3240165,'2119','314',1518214.66,1518391.84,0.00,0.00,177.18,52445.28,0.00,0.00,0.00),('1','151','755','163786',3240166,'2120','314',688225.83,688437.83,0.00,0.00,212.00,62752.00,0.00,0.00,0.00),('1','151','755','163790',3240211,'2119','314',1518391.84,1519658.25,0.00,0.00,1266.41,374857.36,0.00,0.00,0.00),('1','151','755','163790',3240212,'2120','314',688437.83,689838.86,0.00,0.00,1401.03,414704.88,0.00,0.00,0.00),('1','151','755','164063',3245281,'2119','314',1519658.25,1520698.91,0.00,0.00,1040.66,308035.36,0.00,0.00,0.00),('1','151','755','164063',3245282,'2120','314',689838.86,690708.86,0.00,0.00,870.00,257520.00,0.00,0.00,0.00),('1','151','755','164067',3245360,'2119','314',1520698.91,1521236.03,0.00,0.00,537.12,158987.52,0.00,0.00,0.00),('1','151','755','164067',3245361,'2120','314',690708.86,691283.20,0.00,0.00,574.34,170004.64,0.00,0.00,0.00),('1','151','755','164248',3248599,'2119','314',1521236.03,1522539.14,0.00,0.00,1303.11,385720.56,0.00,0.00,0.00),('1','151','755','164248',3248600,'2120','314',691283.20,692984.20,0.00,0.00,1701.00,503496.00,0.00,0.00,0.00),('1','151','755','164352',3250620,'2119','314',1522539.14,1522725.53,0.00,0.00,186.39,55171.44,0.00,0.00,0.00),('1','151','755','164352',3250621,'2120','314',692984.20,693245.20,0.00,0.00,261.00,77256.00,0.00,0.00,0.00),('1','151','755','164448',3252280,'2119','314',1522725.53,1523743.61,0.00,0.00,1018.08,301351.68,0.00,0.00,0.00),('1','151','755','164448',3252281,'2120','314',693245.20,694648.80,0.00,0.00,1403.60,415465.60,0.00,0.00,0.00),('1','151','755','164551',3254112,'2119','314',1523743.61,1524774.98,0.00,0.00,1031.37,305285.52,0.00,0.00,0.00),('1','151','755','164551',3254113,'2120','314',694648.80,695772.80,0.00,0.00,1124.00,332704.00,0.00,0.00,0.00),('1','151','755','164605',3255057,'2119','314',1524774.98,1524899.58,0.00,0.00,124.60,36881.60,0.00,0.00,0.00),('1','151','755','164605',3255058,'2120','314',695772.80,695881.80,0.00,0.00,109.00,32264.00,0.00,0.00,0.00),('1','151','755','164745',3257766,'2119','314',1524899.58,1526701.53,0.00,0.00,1801.95,533377.20,0.00,0.00,0.00),('1','151','755','164745',3257767,'2120','314',695881.80,698142.80,0.00,0.00,2261.00,669256.00,0.00,0.00,0.00),('1','151','755','164814',3258811,'2119','314',1526701.53,1526934.15,0.00,0.00,232.62,68855.52,0.00,0.00,0.00),('1','151','755','164814',3258812,'2120','314',698142.80,698395.80,0.00,0.00,253.00,74888.00,0.00,0.00,0.00),('1','151','755','164818',3258891,'2119','314',1526934.15,1528166.46,0.00,0.00,1232.31,364763.76,0.00,0.00,0.00),('1','151','755','164818',3258892,'2120','314',698395.80,699608.84,0.00,0.00,1213.04,359059.84,0.00,0.00,0.00),('1','151','755','165084',3263711,'2119','314',1528166.46,1529188.62,0.00,0.00,1022.16,327091.20,0.00,0.00,0.00),('1','151','755','165084',3263712,'2120','314',699608.84,700695.84,0.00,0.00,1087.00,347840.00,0.00,0.00,0.00),('1','151','755','165096',3263954,'2119','314',1529188.62,1529795.82,0.00,0.00,607.20,194304.00,0.00,0.00,0.00),('1','151','755','165096',3263955,'2120','314',700695.84,701266.31,0.00,0.00,570.47,182550.40,0.00,0.00,0.00),('1','151','755','165268',3266956,'2119','314',1529795.82,1530702.78,0.00,0.00,906.96,290227.20,0.00,0.00,0.00),('1','151','755','165268',3266957,'2120','314',701266.31,702400.33,0.00,0.00,1134.02,362886.40,0.00,0.00,0.00),('1','151','755','165274',3267024,'2119','314',1530702.78,1531295.32,0.00,0.00,592.54,189612.80,0.00,0.00,0.00),('1','151','755','165274',3267025,'2120','314',702400.33,703137.33,0.00,0.00,737.00,235840.00,0.00,0.00,0.00),('1','151','755','165448',3269965,'2119','314',1531295.32,1532549.57,0.00,0.00,1254.25,401360.00,0.00,0.00,0.00),('1','151','755','165448',3269966,'2120','314',703137.33,705318.91,0.00,0.00,2181.58,698105.60,0.00,0.00,0.00),('1','151','755','165537',3271395,'2119','314',1532549.57,1533028.81,0.00,0.00,479.24,153356.80,0.00,0.00,0.00),('1','151','755','165537',3271396,'2120','314',705318.91,705929.91,0.00,0.00,611.00,195520.00,0.00,0.00,0.00),('1','151','755','165604',3272674,'2119','314',1533028.81,1533914.73,0.00,0.00,885.92,283494.40,0.00,0.00,0.00),('1','151','755','165604',3272675,'2120','314',705929.91,706974.91,0.00,0.00,1045.00,334400.00,0.00,0.00,0.00),('1','151','755','165768',3275871,'2119','314',1533914.73,1533977.73,0.00,0.00,63.00,20160.00,0.00,0.00,0.00),('1','151','755','165768',3275872,'2120','314',706974.91,706974.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','165772',3275935,'2119','314',1533977.73,1534979.65,0.00,0.00,1001.92,320614.40,0.00,0.00,0.00),('1','151','755','165772',3275936,'2120','314',706974.91,708318.62,0.00,0.00,1343.71,429987.20,0.00,0.00,0.00),('1','151','755','165969',3279269,'2119','314',1534979.65,1535925.17,0.00,0.00,945.52,302566.40,0.00,0.00,0.00),('1','151','755','165969',3279270,'2120','314',708318.62,709567.62,0.00,0.00,1249.00,399680.00,0.00,0.00,0.00),('1','151','755','165978',3279400,'2119','314',1535925.17,1536226.81,0.00,0.00,301.64,96524.80,0.00,0.00,0.00),('1','151','755','165978',3279401,'2120','314',709567.62,709821.84,0.00,0.00,254.22,81350.40,0.00,0.00,0.00),('1','151','755','165981',3279428,'2119','314',1536226.81,1537641.71,0.00,0.00,1414.90,452768.00,0.00,0.00,0.00),('1','151','755','165981',3279429,'2120','314',709821.84,711638.51,0.00,0.00,1816.67,581334.40,0.00,0.00,0.00),('1','151','755','166260',3284465,'2119','314',1537641.71,1538163.93,0.00,0.00,522.22,167110.40,0.00,0.00,0.00),('1','151','755','166260',3284466,'2120','314',711638.51,711829.51,0.00,0.00,191.00,61120.00,0.00,0.00,0.00),('1','151','755','166263',3284510,'2119','314',1538163.93,1539144.61,0.00,0.00,980.68,313817.60,0.00,0.00,0.00),('1','151','755','166263',3284511,'2120','314',711829.51,711829.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','166507',3289048,'2119','314',1539144.61,1540170.61,0.00,0.00,1026.00,328320.00,0.00,0.00,0.00),('1','151','755','166507',3289049,'2120','314',711829.51,713452.51,0.00,0.00,1623.00,519360.00,0.00,0.00,0.00),('1','151','755','166520',3289234,'2119','314',1540170.61,1540170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','166520',3289235,'2120','314',713452.51,714350.51,0.00,0.00,898.00,287360.00,0.00,0.00,0.00),('1','151','755','166523',3289267,'2119','314',1540170.61,1541479.67,0.00,0.00,1309.06,418899.20,0.00,0.00,0.00),('1','151','755','166523',3289268,'2120','314',714350.51,715975.51,0.00,0.00,1625.00,520000.00,0.00,0.00,0.00),('1','151','755','166884',3295547,'2119','314',1541479.67,1542731.70,0.00,0.00,1252.03,400649.60,0.00,0.00,0.00),('1','151','755','166884',3295548,'2120','314',715975.51,717858.19,0.00,0.00,1882.68,602457.60,0.00,0.00,0.00),('1','151','755','167030',3298198,'2119','314',1542731.70,1543222.87,0.00,0.00,491.17,157174.40,0.00,0.00,0.00),('1','151','755','167030',3298199,'2120','314',717858.19,718785.19,0.00,0.00,927.00,296640.00,0.00,0.00,0.00),('1','151','755','167036',3298325,'2119','314',1543222.87,1543750.07,0.00,0.00,527.20,168704.00,0.00,0.00,0.00),('1','151','755','167036',3298326,'2120','314',718785.19,719622.71,0.00,0.00,837.52,268006.40,0.00,0.00,0.00),('1','151','755','167173',3300768,'2119','314',1543750.07,1544639.65,0.00,0.00,889.58,284665.60,0.00,0.00,0.00),('1','151','755','167173',3300769,'2120','314',719622.71,721247.21,0.00,0.00,1624.50,519840.00,0.00,0.00,0.00),('1','151','755','167233',3301634,'2119','314',1544639.65,1544914.56,0.00,0.00,274.91,87971.20,0.00,0.00,0.00),('1','151','755','167233',3301635,'2120','314',721247.21,721677.21,0.00,0.00,430.00,137600.00,0.00,0.00,0.00),('1','151','755','167240',3301757,'2119','314',1544914.56,1545671.21,0.00,0.00,756.65,242128.00,0.00,0.00,0.00),('1','151','755','167240',3301758,'2120','314',721677.21,723070.06,0.00,0.00,1392.85,445712.00,0.00,0.00,0.00),('1','151','755','167562',3307834,'2119','314',1545671.21,1546497.12,0.00,0.00,825.91,264291.20,0.00,0.00,0.00),('1','151','755','167562',3307835,'2120','314',723070.06,724697.06,0.00,0.00,1627.00,520640.00,0.00,0.00,0.00),('1','151','755','167733',3310751,'2119','314',1546497.12,1547767.41,0.00,0.00,1270.29,406492.80,0.00,0.00,0.00),('1','151','755','167733',3310752,'2120','314',724697.06,726766.74,0.00,0.00,2069.68,662297.60,0.00,0.00,0.00),('1','151','755','167834',3312428,'2119','314',1547767.41,1548173.26,0.00,0.00,405.85,129872.00,0.00,0.00,0.00),('1','151','755','167834',3312429,'2120','314',726766.74,727538.74,0.00,0.00,772.00,247040.00,0.00,0.00,0.00),('1','151','755','167838',3312482,'2119','314',1548173.26,1548750.25,0.00,0.00,576.99,184636.80,0.00,0.00,0.00),('1','151','755','167838',3312483,'2120','314',727538.74,728767.04,0.00,0.00,1228.30,393056.00,0.00,0.00,0.00),('1','151','755','168091',3317355,'2119','314',1548750.25,1549967.78,0.00,0.00,1217.53,389609.60,0.00,0.00,0.00),('1','151','755','168091',3317356,'2120','314',728767.04,730315.04,0.00,0.00,1548.00,495360.00,0.00,0.00,0.00),('1','151','755','168167',3318553,'2119','314',1549967.78,1550414.19,0.00,0.00,446.41,142851.20,0.00,0.00,0.00),('1','151','755','168167',3318554,'2120','314',730315.04,730734.04,0.00,0.00,419.00,134080.00,0.00,0.00,0.00),('1','151','755','168180',3318848,'2119','314',1550414.19,1551203.34,0.00,0.00,789.15,252528.00,0.00,0.00,0.00),('1','151','755','168180',3318849,'2120','314',730734.04,731974.64,0.00,0.00,1240.60,396992.00,0.00,0.00,0.00),('1','151','755','168385',3322715,'2119','314',1551203.34,1552247.09,0.00,0.00,1043.75,334000.00,0.00,0.00,0.00),('1','151','755','168385',3322716,'2120','314',731974.64,733478.64,0.00,0.00,1504.00,481280.00,0.00,0.00,0.00),('1','151','755','168598',3326476,'2119','314',1552247.09,1553693.74,0.00,0.00,1446.65,462928.00,0.00,0.00,0.00),('1','151','755','168598',3326477,'2120','314',733478.64,735561.53,0.00,0.00,2082.89,666524.80,0.00,0.00,0.00),('1','151','755','168690',3328172,'2119','314',1553693.74,1554156.97,0.00,0.00,463.23,148233.60,0.00,0.00,0.00),('1','151','755','168690',3328173,'2120','314',735561.53,736144.53,0.00,0.00,583.00,186560.00,0.00,0.00,0.00),('1','151','755','168701',3328357,'2119','314',1554156.97,1554537.52,0.00,0.00,380.55,121776.00,0.00,0.00,0.00),('1','151','755','168701',3328358,'2120','314',736144.53,736546.14,0.00,0.00,401.61,128515.20,0.00,0.00,0.00),('1','151','755','168929',3332335,'2119','314',1554537.52,1555729.79,0.00,0.00,1192.27,381526.40,0.00,0.00,0.00),('1','151','755','168929',3332336,'2120','314',736546.14,738932.39,0.00,0.00,2386.25,763600.00,0.00,0.00,0.00),('1','151','755','169006',3333693,'2119','314',1555729.79,1555827.62,0.00,0.00,97.83,31305.60,0.00,0.00,0.00),('1','151','755','169006',3333694,'2120','314',738932.39,739089.39,0.00,0.00,157.00,50240.00,0.00,0.00,0.00),('1','151','755','169014',3333818,'2119','314',1555827.62,1557216.30,0.00,0.00,1388.68,444377.60,0.00,0.00,0.00),('1','151','755','169014',3333819,'2120','314',739089.39,740841.15,0.00,0.00,1751.76,560563.20,0.00,0.00,0.00),('1','151','755','169246',3338183,'2119','314',1557216.30,1557710.76,0.00,0.00,494.46,158227.20,0.00,0.00,0.00),('1','151','755','169246',3338184,'2120','314',740841.15,741728.15,0.00,0.00,887.00,283840.00,0.00,0.00,0.00),('1','151','755','169249',3338216,'2119','314',1557710.76,1558422.92,0.00,0.00,712.16,227891.20,0.00,0.00,0.00),('1','151','755','169249',3338217,'2120','314',741728.15,742741.62,0.00,0.00,1013.47,324310.40,0.00,0.00,0.00),('1','151','755','169454',3342233,'2119','314',1558422.92,1559447.34,0.00,0.00,1024.42,327814.40,0.00,0.00,0.00),('1','151','755','169454',3342234,'2120','314',742741.62,744350.62,0.00,0.00,1609.00,514880.00,0.00,0.00,0.00),('1','151','755','169518',3343476,'2119','314',1559447.34,1559460.14,0.00,0.00,12.80,4096.00,0.00,0.00,0.00),('1','151','755','169518',3343477,'2120','314',744350.62,744442.62,0.00,0.00,92.00,29440.00,0.00,0.00,0.00),('1','151','755','169525',3343598,'2119','314',1559460.14,1560489.67,0.00,0.00,1029.53,337685.84,0.00,0.00,0.00),('1','151','755','169525',3343599,'2120','314',744442.62,745734.76,0.00,0.00,1292.14,423821.92,0.00,0.00,0.00),('1','151','755','169762',3348067,'2119','314',1560489.67,1561318.50,0.00,0.00,828.83,271856.24,0.00,0.00,0.00),('1','151','755','169762',3348068,'2120','314',745734.76,747186.76,0.00,0.00,1452.00,476256.00,0.00,0.00,0.00),('1','151','755','169765',3348134,'2119','314',1561318.50,1561684.33,0.00,0.00,365.83,119992.24,0.00,0.00,0.00),('1','151','755','169765',3348135,'2120','314',747186.76,747532.46,0.00,0.00,345.70,113389.60,0.00,0.00,0.00),('1','151','755','169919',3351118,'2119','314',1561684.33,1562804.05,0.00,0.00,1119.72,367268.16,0.00,0.00,0.00),('1','151','755','169919',3351119,'2120','314',747532.46,749807.46,0.00,0.00,2275.00,746200.00,0.00,0.00,0.00),('1','151','755','169981',3352091,'2119','314',1562804.05,1563151.28,0.00,0.00,347.23,113891.44,0.00,0.00,0.00),('1','151','755','169981',3352092,'2120','314',749807.46,749945.46,0.00,0.00,138.00,45264.00,0.00,0.00,0.00),('1','151','755','170035',3353088,'2119','314',1563151.28,1563844.01,0.00,0.00,692.73,227215.44,0.00,0.00,0.00),('1','151','755','170035',3353089,'2120','314',749945.46,750689.07,0.00,0.00,743.61,243904.08,0.00,0.00,0.00),('1','151','755','170319',3357986,'2119','314',1563844.01,1564992.80,0.00,0.00,1148.79,376803.12,0.00,0.00,0.00),('1','151','755','170319',3357987,'2120','314',750689.07,752987.07,0.00,0.00,2298.00,753744.00,0.00,0.00,0.00),('1','151','755','170501',3361129,'2119','314',1564992.80,1566775.53,0.00,0.00,1782.73,584735.44,0.00,0.00,0.00),('1','151','755','170501',3361130,'2120','314',752987.07,754659.37,0.00,0.00,1672.30,548514.40,0.00,0.00,0.00),('1','151','755','170674',3364375,'2119','314',1566775.53,1567256.22,0.00,0.00,480.69,157666.32,0.00,0.00,0.00),('1','151','755','170674',3364376,'2120','314',754659.37,755340.37,0.00,0.00,681.00,223368.00,0.00,0.00,0.00),('1','151','755','170676',3364379,'2119','314',1567256.22,1567915.93,0.00,0.00,659.71,216384.88,0.00,0.00,0.00),('1','151','755','170676',3364380,'2120','314',755340.37,756456.96,0.00,0.00,1116.59,366241.52,0.00,0.00,0.00),('1','151','755','170800',3366656,'2119','314',1567915.93,1569199.53,0.00,0.00,1283.60,421020.80,0.00,0.00,0.00),('1','151','755','170800',3366657,'2120','314',756456.96,758009.96,0.00,0.00,1553.00,509384.00,0.00,0.00,0.00),('1','151','755','170974',3369572,'2119','314',1569199.53,1570328.72,0.00,0.00,1129.19,370374.32,0.00,0.00,0.00),('1','151','755','170974',3369573,'2120','314',758009.96,760265.39,0.00,0.00,2255.43,739781.04,0.00,0.00,0.00),('1','151','755','171042',3370834,'2119','314',1570328.72,1571019.58,0.00,0.00,690.86,226602.08,0.00,0.00,0.00),('1','151','755','171042',3370835,'2120','314',760265.39,760851.39,0.00,0.00,586.00,192208.00,0.00,0.00,0.00),('1','151','755','171155',3373065,'2119','314',1571019.58,1571663.42,0.00,0.00,643.84,211179.52,0.00,0.00,0.00),('1','151','755','171155',3373066,'2120','314',760851.39,761657.82,0.00,0.00,806.43,264509.04,0.00,0.00,0.00),('1','151','755','171362',3376922,'2119','314',1571663.42,1572589.49,0.00,0.00,926.07,303750.96,0.00,0.00,0.00),('1','151','755','171362',3376923,'2120','314',761657.82,763811.82,0.00,0.00,2154.00,706512.00,0.00,0.00,0.00),('1','151','755','171417',3377736,'2119','314',1572589.49,1573725.75,0.00,0.00,1136.26,372693.28,0.00,0.00,0.00),('1','151','755','171417',3377737,'2120','314',763811.82,765308.35,0.00,0.00,1496.53,490861.84,0.00,0.00,0.00),('1','151','755','171755',3383950,'2119','314',1573725.75,1574270.39,0.00,0.00,544.64,178641.92,0.00,0.00,0.00),('1','151','755','171755',3383951,'2120','314',765308.35,766904.35,0.00,0.00,1596.00,523488.00,0.00,0.00,0.00),('1','151','755','171955',3387429,'2119','314',1574270.39,1575298.97,0.00,0.00,1028.58,337374.24,0.00,0.00,0.00),('1','151','755','171955',3387430,'2120','314',766904.35,768613.23,0.00,0.00,1708.88,560512.64,0.00,0.00,0.00),('1','151','755','172128',3390530,'2119','314',1575298.97,1575790.90,0.00,0.00,491.93,161353.04,0.00,0.00,0.00),('1','151','755','172128',3390531,'2120','314',768613.23,770010.23,0.00,0.00,1397.00,458216.00,0.00,0.00,0.00),('1','151','755','172135',3390672,'2119','314',1575790.90,1577184.95,0.00,0.00,1394.05,457248.40,0.00,0.00,0.00),('1','151','755','172135',3390673,'2120','314',770010.23,771677.16,0.00,0.00,1666.93,546753.04,0.00,0.00,0.00),('1','151','755','172507',3397520,'2119','314',1577184.95,1577664.48,0.00,0.00,479.53,157285.84,0.00,0.00,0.00),('1','151','755','172507',3397521,'2120','314',771677.16,772761.16,0.00,0.00,1084.00,355552.00,0.00,0.00,0.00),('1','151','755','172578',3398721,'2119','314',1577664.48,1579157.10,0.00,0.00,1492.62,489579.36,0.00,0.00,0.00),('1','151','755','172578',3398722,'2120','314',772761.16,774473.66,0.00,0.00,1712.50,561700.00,0.00,0.00,0.00),('1','151','755','172838',3403573,'2119','314',1579157.10,1579974.72,0.00,0.00,817.62,268179.36,0.00,0.00,0.00),('1','151','755','172838',3403574,'2120','314',774473.66,776800.66,0.00,0.00,2327.00,763256.00,0.00,0.00,0.00),('1','151','755','172897',3404561,'2119','314',1579974.72,1579974.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','172897',3404562,'2120','314',776800.66,776900.66,0.00,0.00,100.00,32800.00,0.00,0.00,0.00),('1','151','755','172963',3405830,'2119','314',1579974.72,1580732.47,0.00,0.00,757.75,248542.00,0.00,0.00,0.00),('1','151','755','172963',3405831,'2120','314',776900.66,777693.97,0.00,0.00,793.31,260205.68,0.00,0.00,0.00),('1','151','755','173205',3410755,'2119','314',1580732.47,1580732.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','173205',3410756,'2120','314',777693.97,778015.32,0.00,0.00,321.35,105402.80,0.00,0.00,0.00),('1','151','755','173327',3412925,'2119','314',1580732.47,1581801.88,0.00,0.00,1069.41,350766.48,0.00,0.00,0.00),('1','151','755','173327',3412926,'2120','314',778015.32,779618.32,0.00,0.00,1603.00,525784.00,0.00,0.00,0.00),('1','151','755','173332',3413028,'2119','314',1581801.88,1582924.44,0.00,0.00,1122.56,368199.68,0.00,0.00,0.00),('1','151','755','173332',3413029,'2120','314',779618.32,781958.65,0.00,0.00,2340.33,767628.24,0.00,0.00,0.00),('1','151','755','173848',3422430,'2119','314',1582924.44,1583285.11,0.00,0.00,360.67,118299.76,0.00,0.00,0.00),('1','151','755','173848',3422431,'2120','314',781958.65,782823.65,0.00,0.00,865.00,283720.00,0.00,0.00,0.00),('1','151','755','173860',3422605,'2119','314',1583285.11,1583872.94,0.00,0.00,587.83,192808.24,0.00,0.00,0.00),('1','151','755','173860',3422606,'2120','314',782823.65,784045.44,0.00,0.00,1221.79,400747.12,0.00,0.00,0.00),('1','151','755','174111',3427141,'2119','314',1583872.94,1584622.84,0.00,0.00,749.90,245967.20,0.00,0.00,0.00),('1','151','755','174111',3427142,'2120','314',784045.44,786065.44,0.00,0.00,2020.00,662560.00,0.00,0.00,0.00),('1','151','755','174295',3430509,'2119','314',1584622.84,1585691.05,0.00,0.00,1068.21,350372.88,0.00,0.00,0.00),('1','151','755','174295',3430510,'2120','314',786065.44,788230.72,0.00,0.00,2165.28,710211.84,0.00,0.00,0.00),('1','151','755','174328',3431020,'2119','314',1585691.05,1586097.09,0.00,0.00,406.04,133181.12,0.00,0.00,0.00),('1','151','755','174328',3431021,'2120','314',788230.72,789210.72,0.00,0.00,980.00,321440.00,0.00,0.00,0.00),('1','151','755','174424',3432454,'2119','314',1586097.09,1586784.30,0.00,0.00,687.21,225404.88,0.00,0.00,0.00),('1','151','755','174424',3432455,'2120','314',789210.72,790051.92,0.00,0.00,841.20,275913.60,0.00,0.00,0.00),('1','151','755','174539',3434633,'2119','314',1586784.30,1587288.38,0.00,0.00,504.08,165338.24,0.00,0.00,0.00),('1','151','755','174539',3434634,'2120','314',790051.92,791220.81,0.00,0.00,1168.89,383395.92,0.00,0.00,0.00),('1','151','755','174541',3434648,'2119','314',1587288.38,1587955.60,0.00,0.00,667.22,218848.16,0.00,0.00,0.00),('1','151','755','174541',3434649,'2120','314',791220.81,792239.81,0.00,0.00,1019.00,334232.00,0.00,0.00,0.00),('1','151','755','174772',3438730,'2119','314',1587955.60,1588802.07,0.00,0.00,846.47,277642.16,0.00,0.00,0.00),('1','151','755','174772',3438731,'2120','314',792239.81,792869.81,0.00,0.00,630.00,206640.00,0.00,0.00,0.00),('1','151','755','174805',3439515,'2119','314',1588802.07,1589063.45,0.00,0.00,261.38,85732.64,0.00,0.00,0.00),('1','151','755','174805',3439516,'2120','314',792869.81,793329.81,0.00,0.00,460.00,0.00,0.00,0.00,0.00),('1','151','755','174810',3439619,'2119','314',1589063.45,1589063.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','174810',3439620,'2120','314',793329.81,793789.81,0.00,0.00,460.00,150880.00,0.00,0.00,0.00),('1','151','755','174946',3442146,'2119','314',1589063.45,1589608.37,0.00,0.00,544.92,191811.84,0.00,0.00,0.00),('1','151','755','174946',3442147,'2120','314',793789.81,794664.58,0.00,0.00,874.77,307919.04,0.00,0.00,0.00),('1','151','755','174949',3442186,'2119','314',1589608.37,1590139.01,0.00,0.00,530.64,186785.28,0.00,0.00,0.00),('1','151','755','174949',3442187,'2120','314',794664.58,795692.22,0.00,0.00,1027.64,361729.28,0.00,0.00,0.00),('1','151','755','175149',3445791,'2119','314',1590139.01,1590515.66,0.00,0.00,376.65,132580.80,0.00,0.00,0.00),('1','151','755','175149',3445792,'2120','314',795692.22,796564.48,0.00,0.00,872.26,307035.52,0.00,0.00,0.00),('1','151','755','175160',3445965,'2119','314',1590515.66,1591397.62,0.00,0.00,881.96,310449.92,0.00,0.00,0.00),('1','151','755','175160',3445966,'2120','314',796564.48,797311.88,0.00,0.00,747.40,263084.80,0.00,0.00,0.00),('1','151','755','175308',3448762,'2119','314',1591397.62,1591762.87,0.00,0.00,365.25,128568.00,0.00,0.00,0.00),('1','151','755','175308',3448763,'2120','314',797311.88,798264.32,0.00,0.00,952.44,335258.88,0.00,0.00,0.00),('1','151','755','175334',3449270,'2119','314',1591762.87,1592395.41,0.00,0.00,632.54,222654.08,0.00,0.00,0.00),('1','151','755','175334',3449271,'2120','314',798264.32,799182.32,0.00,0.00,918.00,323136.00,0.00,0.00,0.00),('1','151','755','175470',3451707,'2119','314',1592395.41,1592972.77,0.00,0.00,577.36,203230.72,0.00,0.00,0.00),('1','151','755','175470',3451708,'2120','314',799182.32,799946.10,0.00,0.00,763.78,268850.56,0.00,0.00,0.00),('1','151','755','175509',3452371,'2119','314',1592972.77,1593628.35,0.00,0.00,655.58,230764.16,0.00,0.00,0.00),('1','151','755','175509',3452372,'2120','314',799946.10,800906.37,0.00,0.00,960.27,338015.04,0.00,0.00,0.00),('1','151','755','175676',3455431,'2119','314',1593628.35,1594400.05,0.00,0.00,771.70,271638.40,0.00,0.00,0.00),('1','151','755','175676',3455432,'2120','314',800906.37,801879.37,0.00,0.00,973.00,342496.00,0.00,0.00,0.00),('1','151','755','175683',3455512,'2119','314',1594400.05,1594849.77,0.00,0.00,449.72,158301.44,0.00,0.00,0.00),('1','151','755','175683',3455513,'2120','314',801879.37,802352.39,0.00,0.00,473.02,166503.04,0.00,0.00,0.00),('1','151','755','175876',3459092,'2119','314',1594849.77,1595825.00,0.00,0.00,975.23,0.00,0.00,0.00,0.00),('1','151','755','175876',3459093,'2120','314',802352.39,803923.20,0.00,0.00,1570.81,552925.12,0.00,0.00,0.00),('1','151','755','175880',3459156,'2119','314',1595825.00,1596296.01,0.00,0.00,471.01,165795.52,0.00,0.00,0.00),('1','151','755','175880',3459157,'2120','314',803923.20,804530.20,0.00,0.00,607.00,213664.00,0.00,0.00,0.00),('1','151','755','175974',3460833,'2119','314',1596296.01,1596935.47,0.00,0.00,639.46,225089.92,0.00,0.00,0.00),('1','151','755','175974',3460834,'2120','314',804530.20,805546.47,0.00,0.00,1016.27,357727.04,0.00,0.00,0.00),('1','151','755','176120',3463540,'2119','314',1596935.47,1597966.55,0.00,0.00,1031.08,362940.16,0.00,0.00,0.00),('1','151','755','176120',3463541,'2120','314',805546.47,806916.47,0.00,0.00,1370.00,482240.00,0.00,0.00,0.00),('1','151','755','176262',3466195,'2119','314',1597966.55,1599012.74,0.00,0.00,1046.19,368258.88,0.00,0.00,0.00),('1','151','755','176262',3466196,'2120','314',806916.47,808136.47,0.00,0.00,1220.00,429440.00,0.00,0.00,0.00),('1','151','755','176298',3466870,'2119','314',1599060.34,1599248.40,0.00,0.00,188.06,66197.12,0.00,0.00,0.00),('1','151','755','176298',3466871,'2120','314',807679.12,808150.12,0.00,0.00,471.00,165792.00,0.00,0.00,0.00),('1','151','755','176336',3467419,'2119','314',1599248.40,1599999.99,0.00,0.00,751.59,264559.68,0.00,0.00,0.00),('1','151','755','176336',3467420,'2120','314',808150.12,809376.09,0.00,0.00,1225.97,431541.44,0.00,0.00,0.00),('1','151','755','176476',3470006,'2119','314',1599999.99,1600740.34,0.00,0.00,740.35,260603.20,0.00,0.00,0.00),('1','151','755','176476',3470007,'2120','314',809376.09,810486.35,0.00,0.00,1110.26,390811.52,0.00,0.00,0.00),('1','151','755','176557',3471645,'2119','314',1600740.34,1601073.97,0.00,0.00,333.63,117437.76,0.00,0.00,0.00),('1','151','755','176557',3471646,'2120','314',810486.35,810991.00,0.00,0.00,504.65,168836.80,0.00,0.00,0.00),('1','151','755','176642',3473286,'2119','314',1601073.97,1601739.08,0.00,0.00,665.11,234095.86,0.00,0.00,0.00),('1','151','755','176642',3473287,'2120','314',810991.00,811770.33,0.00,0.00,779.33,226762.66,0.00,0.00,0.00),('1','151','755','176786',3475766,'2119','314',1601739.08,1601932.65,0.00,0.00,193.57,68136.64,0.00,0.00,0.00),('1','151','755','176786',3475767,'2120','314',811770.33,813433.73,0.00,0.00,1663.40,585516.80,0.00,0.00,0.00),('1','151','755','176969',3479187,'2119','314',1601932.65,1602556.50,0.00,0.00,623.85,219595.20,0.00,0.00,0.00),('1','151','755','176969',3479188,'2120','314',813433.73,814055.73,0.00,0.00,622.00,218944.00,0.00,0.00,0.00),('1','151','755','176995',3479499,'2119','314',1602556.50,1603481.11,0.00,0.00,924.61,325462.72,0.00,0.00,0.00),('1','151','755','176995',3479500,'2120','314',814055.73,814920.94,0.00,0.00,865.21,304553.92,0.00,0.00,0.00),('1','151','755','177106',3481917,'2119','314',1603481.11,1604123.15,0.00,0.00,642.04,225995.24,0.00,0.00,0.00),('1','151','755','177106',3481918,'2120','314',814920.94,815878.98,0.00,0.00,958.04,337230.08,0.00,0.00,0.00),('1','151','755','177236',3484338,'2119','314',1604123.15,1605084.39,0.00,0.00,961.24,338007.48,0.00,0.00,0.00),('1','151','755','177236',3484339,'2120','314',815878.98,816107.58,0.00,0.00,228.60,80467.20,0.00,0.00,0.00),('1','151','755','177330',3486184,'2119','314',1605084.39,1605831.67,0.00,0.00,747.28,263042.56,0.00,0.00,0.00),('1','151','755','177330',3486185,'2120','314',816107.58,816773.74,0.00,0.00,666.16,234488.32,0.00,0.00,0.00),('1','151','755','177429',3488236,'2119','314',1605831.67,1607011.23,0.00,0.00,1179.56,415205.12,0.00,0.00,0.00),('1','151','755','177429',3488237,'2120','314',816773.74,818430.60,0.00,0.00,1656.86,583214.72,0.00,0.00,0.00),('1','151','755','177631',3492382,'2119','314',1607011.23,1607255.54,0.00,0.00,244.31,84042.64,0.00,0.00,0.00),('1','151','755','177631',3492383,'2120','314',818430.60,818572.54,0.00,0.00,141.94,48827.36,0.00,0.00,0.00),('1','151','755','177703',3493692,'2119','314',1607255.54,1607598.35,0.00,0.00,342.81,117926.64,0.00,0.00,0.00),('1','151','755','177703',3493693,'2120','314',818572.54,818995.25,0.00,0.00,422.71,145812.24,0.00,0.00,0.00),('1','151','755','177789',3495202,'2119','314',1607598.35,1608431.39,0.00,0.00,833.04,285635.76,0.00,0.00,0.00),('1','151','755','177789',3495203,'2120','314',818995.25,819676.06,0.00,0.00,680.81,234198.64,0.00,0.00,0.00),('1','151','755','177886',3496920,'2119','314',1608431.39,1609481.94,0.00,0.00,1050.55,361389.20,0.00,0.00,0.00),('1','151','755','177886',3496921,'2120','314',819676.06,820468.32,0.00,0.00,792.26,272537.44,0.00,0.00,0.00),('1','151','755','177986',3498924,'2119','314',1609481.94,1609679.45,0.00,0.00,197.51,67943.44,0.00,0.00,0.00),('1','151','755','177986',3498925,'2120','314',820468.32,820745.01,0.00,0.00,276.69,95181.36,0.00,0.00,0.00),('1','151','755','178091',3500967,'2119','314',1609679.45,1610480.58,0.00,0.00,801.13,275588.72,0.00,0.00,0.00),('1','151','755','178091',3500968,'2120','314',820745.01,821557.87,0.00,0.00,812.86,279623.84,0.00,0.00,0.00),('1','151','755','178192',3502853,'2119','314',1610480.58,1611183.23,0.00,0.00,702.65,241711.60,0.00,0.00,0.00),('1','151','755','178192',3502854,'2120','314',821557.87,822393.11,0.00,0.00,835.24,287322.56,0.00,0.00,0.00),('1','151','755','178300',3504731,'2119','314',1611183.23,1611755.00,0.00,0.00,571.77,196688.88,0.00,0.00,0.00),('1','151','755','178300',3504732,'2120','314',822393.11,823107.11,0.00,0.00,714.00,245616.00,0.00,0.00,0.00),('1','151','755','178459',3507856,'2119','314',1611755.00,1612287.09,0.00,0.00,532.09,183038.96,0.00,0.00,0.00),('1','151','755','178459',3507857,'2120','314',823107.11,823747.01,0.00,0.00,639.90,220125.60,0.00,0.00,0.00),('1','151','755','178679',3511922,'2119','314',1612287.09,1613424.38,0.00,0.00,1137.29,391227.76,0.00,0.00,0.00),('1','151','755','178679',3511923,'2120','314',823747.01,825805.01,0.00,0.00,2058.00,707952.00,0.00,0.00,0.00),('1','151','755','178725',3512604,'2119','314',1613424.38,1613691.33,0.00,0.00,266.95,91830.80,0.00,0.00,0.00),('1','151','755','178725',3512605,'2120','314',825805.01,825805.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','178766',3513286,'2119','314',1613691.33,1614190.83,0.00,0.00,499.50,171828.00,0.00,0.00,0.00),('1','151','755','178766',3513287,'2120','314',825805.01,826236.88,0.00,0.00,431.87,148563.28,0.00,0.00,0.00),('1','151','755','178821',3514358,'2119','314',1614190.83,1614583.07,0.00,0.00,392.24,134930.56,0.00,0.00,0.00),('1','151','755','178821',3514359,'2120','314',826236.88,827119.49,0.00,0.00,882.61,303617.84,0.00,0.00,0.00),('1','151','755','178904',3515769,'2119','314',1614583.07,1615877.62,0.00,0.00,1294.55,445325.20,0.00,0.00,0.00),('1','151','755','178904',3515770,'2120','314',827119.49,828770.74,0.00,0.00,1651.25,568030.00,0.00,0.00,0.00),('1','151','755','179142',3520242,'2119','314',1615877.62,1616495.13,0.00,0.00,617.51,212423.44,0.00,0.00,0.00),('1','151','755','179142',3520243,'2120','314',828770.74,829804.72,0.00,0.00,1033.98,355689.12,0.00,0.00,0.00),('1','151','755','179374',3524730,'2119','314',1616495.13,1617805.24,0.00,0.00,1310.11,467368.24,0.00,0.00,0.00),('1','151','755','179374',3524731,'2120','314',829804.72,831100.29,0.00,0.00,1295.57,463930.00,0.00,0.00,0.00),('1','151','755','179570',3528451,'2119','314',1617805.24,1618629.10,0.00,0.00,823.86,296589.60,0.00,0.00,0.00),('1','151','755','179570',3528452,'2120','314',831100.29,832216.17,0.00,0.00,1115.88,401716.80,0.00,0.00,0.00),('1','151','755','179730',3531745,'2119','314',1618629.10,1620205.79,0.00,0.00,1576.69,567608.40,0.00,0.00,0.00),('1','151','755','179730',3531746,'2120','314',832216.17,834026.33,0.00,0.00,1810.16,651657.60,0.00,0.00,0.00),('1','151','755','179988',3536365,'2119','314',1620205.79,1620674.74,0.00,0.00,468.95,168822.00,0.00,0.00,0.00),('1','151','755','179988',3536366,'2120','314',834026.33,834748.91,0.00,0.00,722.58,260128.80,0.00,0.00,0.00),('1','151','755','180072',3537820,'2119','314',1620674.74,1621148.53,0.00,0.00,473.79,170564.40,0.00,0.00,0.00),('1','151','755','180072',3537821,'2120','314',834748.91,835440.56,0.00,0.00,691.65,248994.00,0.00,0.00,0.00),('1','151','755','180168',3539872,'2119','314',1621148.53,1622774.18,0.00,0.00,1625.65,585234.00,0.00,0.00,0.00),('1','151','755','180168',3539873,'2120','314',835440.56,837236.62,0.00,0.00,1796.06,646581.60,0.00,0.00,0.00),('1','151','755','180341',3542809,'2119','314',1622774.18,1623986.39,0.00,0.00,1212.21,436395.60,0.00,0.00,0.00),('1','151','755','180341',3542810,'2120','314',837236.62,838961.74,0.00,0.00,1725.12,596129.76,0.00,0.00,0.00),('1','151','755','180550',3546698,'2119','314',1623986.39,1624914.66,0.00,0.00,928.27,334177.20,0.00,0.00,0.00),('1','151','755','180550',3546699,'2120','314',838961.74,839897.42,0.00,0.00,935.68,336844.80,0.00,0.00,0.00),('1','151','755','180656',3548491,'2119','314',1624914.66,1625271.68,0.00,0.00,357.02,128527.20,0.00,0.00,0.00),('1','151','755','180656',3548492,'2120','314',839897.42,840262.50,0.00,0.00,365.08,131428.80,0.00,0.00,0.00),('1','151','755','180733',3550046,'2119','314',1625271.68,1626492.83,0.00,0.00,1221.15,439614.00,0.00,0.00,0.00),('1','151','755','180733',3550047,'2120','314',840262.50,842208.41,0.00,0.00,1945.91,700527.60,0.00,0.00,0.00),('1','151','755','180951',3554379,'2119','314',1626492.83,1626954.70,0.00,0.00,461.87,166273.20,0.00,0.00,0.00),('1','151','755','180951',3554380,'2120','314',842208.41,842436.82,0.00,0.00,228.41,82227.60,0.00,0.00,0.00),('1','151','755','181035',3555726,'2119','314',1626954.70,1627803.55,0.00,0.00,848.85,305586.00,0.00,0.00,0.00),('1','151','755','181035',3555727,'2120','314',842436.82,843405.79,0.00,0.00,968.97,348829.20,0.00,0.00,0.00),('1','151','755','181129',3557647,'2119','314',1627803.55,1627955.28,0.00,0.00,151.73,54622.80,0.00,0.00,0.00),('1','151','755','181129',3557648,'2120','314',843405.79,843591.60,0.00,0.00,185.81,66891.60,0.00,0.00,0.00),('1','151','755','181236',3559844,'2119','314',1627955.28,1628485.71,0.00,0.00,530.43,190954.80,0.00,0.00,0.00),('1','151','755','181236',3559845,'2120','314',843591.60,844188.39,0.00,0.00,596.79,214844.40,0.00,0.00,0.00),('1','151','755','181376',3562259,'2119','314',1628485.71,1629976.54,0.00,0.00,1490.83,536698.80,0.00,0.00,0.00),('1','151','755','181376',3562260,'2120','314',844188.39,845464.26,0.00,0.00,1275.87,459313.20,0.00,0.00,0.00),('1','151','755','181522',3565070,'2119','314',1629976.54,1630147.81,0.00,0.00,171.27,61657.20,0.00,0.00,0.00),('1','151','755','181522',3565071,'2120','314',845464.26,845951.30,0.00,0.00,487.04,175334.40,0.00,0.00,0.00),('1','151','755','181577',3565795,'2119','314',1630147.81,1631227.35,0.00,0.00,1079.54,388634.40,0.00,0.00,0.00),('1','151','755','181577',3565796,'2120','314',845951.30,847363.53,0.00,0.00,1412.23,508402.80,0.00,0.00,0.00),('1','151','755','181721',3568300,'2119','314',1631227.35,1632326.03,0.00,0.00,1098.68,395524.80,0.00,0.00,0.00),('1','151','755','181721',3568301,'2120','314',847363.53,848301.58,0.00,0.00,938.05,337698.00,0.00,0.00,0.00),('1','151','755','181869',3570963,'2119','314',1632326.03,1632457.61,0.00,0.00,131.58,47368.80,0.00,0.00,0.00),('1','151','755','181869',3570964,'2120','314',848301.58,848485.60,0.00,0.00,184.02,66247.20,0.00,0.00,0.00),('1','151','755','181905',3571578,'2119','314',1632457.61,1634191.78,0.00,0.00,1734.17,624301.20,0.00,0.00,0.00),('1','151','755','181905',3571579,'2120','314',848485.60,850508.49,0.00,0.00,2022.89,728240.40,0.00,0.00,0.00),('1','151','755','182101',3575432,'2119','314',1634191.78,1634426.82,0.00,0.00,235.04,84614.40,0.00,0.00,0.00),('1','151','755','182101',3575433,'2120','314',850508.49,850761.26,0.00,0.00,252.77,90997.20,0.00,0.00,0.00),('1','151','755','182154',3576165,'2119','314',1634426.82,1635764.35,0.00,0.00,1337.53,481510.80,0.00,0.00,0.00),('1','151','755','182154',3576166,'2120','314',850761.26,852172.33,0.00,0.00,1411.07,507985.20,0.00,0.00,0.00),('1','151','755','182302',3578850,'2119','314',1635764.35,1636441.44,0.00,0.00,677.09,243752.40,0.00,0.00,0.00),('1','151','755','182302',3578851,'2120','314',852172.33,853298.29,0.00,0.00,1125.96,405345.60,0.00,0.00,0.00),('1','151','755','182508',3582416,'2119','314',1636441.44,1637869.02,0.00,0.00,1427.58,513928.80,0.00,0.00,0.00),('1','151','755','182508',3582417,'2120','314',853298.29,854816.34,0.00,0.00,1518.05,546498.00,0.00,0.00,0.00),('1','151','755','182681',3585805,'2119','314',1637869.02,1638437.66,0.00,0.00,568.64,204710.40,0.00,0.00,0.00),('1','151','755','182681',3585806,'2120','314',854816.34,855788.17,0.00,0.00,971.83,349858.80,0.00,0.00,0.00),('1','151','755','182767',3587366,'2119','314',1638437.66,1639018.67,0.00,0.00,581.01,209163.60,0.00,0.00,0.00),('1','151','755','182767',3587367,'2120','314',855788.17,856666.83,0.00,0.00,878.66,316317.60,0.00,0.00,0.00),('1','151','755','182869',3589220,'2119','314',1639018.67,1639211.04,0.00,0.00,192.37,69253.20,0.00,0.00,0.00),('1','151','755','182869',3589221,'2120','314',856666.83,857636.94,0.00,0.00,970.11,349239.60,0.00,0.00,0.00),('1','151','755','182921',3590226,'2119','314',1639211.04,1639659.18,0.00,0.00,448.14,161330.40,0.00,0.00,0.00),('1','151','755','182921',3590227,'2120','314',857636.94,858410.71,0.00,0.00,773.77,278557.20,0.00,0.00,0.00),('1','151','755','182984',3591398,'2119','314',1639659.18,1640889.33,0.00,0.00,1230.15,442854.00,0.00,0.00,0.00),('1','151','755','182984',3591399,'2120','314',858410.71,860168.90,0.00,0.00,1758.19,632948.40,0.00,0.00,0.00),('1','151','755','183209',3595545,'2119','314',1640889.33,1641112.83,0.00,0.00,223.50,80460.00,0.00,0.00,0.00),('1','151','755','183209',3595546,'2120','314',860168.90,860302.46,0.00,0.00,133.56,48081.60,0.00,0.00,0.00),('1','151','755','183243',3595908,'2119','314',1641112.83,1642314.59,0.00,0.00,1201.76,432633.60,0.00,0.00,0.00),('1','151','755','183243',3595909,'2120','314',860302.46,861759.43,0.00,0.00,1456.97,524509.20,0.00,0.00,0.00),('1','151','755','183524',3600985,'2119','314',1642314.59,1642925.40,0.00,0.00,610.81,219891.60,0.00,0.00,0.00),('1','151','755','183524',3600986,'2120','314',861759.43,863055.45,0.00,0.00,1296.02,466567.20,0.00,0.00,0.00),('1','151','755','183651',3603387,'2119','314',1642925.40,1644015.00,0.00,0.00,1089.60,392256.00,0.00,0.00,0.00),('1','151','755','183651',3603388,'2120','314',863055.45,864640.15,0.00,0.00,1584.70,570492.00,0.00,0.00,0.00),('1','151','755','183877',3607681,'2119','314',1644015.00,1644689.41,0.00,0.00,674.41,242787.60,0.00,0.00,0.00),('1','151','755','183877',3607682,'2120','314',864640.15,865803.85,0.00,0.00,1163.70,418932.00,0.00,0.00,0.00),('1','151','755','184037',3610476,'2119','314',1644689.41,1644928.74,0.00,0.00,239.33,86158.80,0.00,0.00,0.00),('1','151','755','184037',3610477,'2120','314',865803.85,866179.25,0.00,0.00,375.40,135144.00,0.00,0.00,0.00),('1','151','755','184069',3611135,'2119','314',1644928.74,1646585.85,0.00,0.00,1657.11,596559.60,0.00,0.00,0.00),('1','151','755','184069',3611136,'2120','314',866179.25,867707.50,0.00,0.00,1528.25,550170.00,0.00,0.00,0.00),('1','151','755','184264',3614543,'2119','314',1646585.85,1646721.03,0.00,0.00,135.18,48664.80,0.00,0.00,0.00),('1','151','755','184264',3614544,'2120','314',867707.50,868298.58,0.00,0.00,591.08,212788.80,0.00,0.00,0.00),('1','151','755','184357',3616045,'2119','314',1646721.03,1647729.63,0.00,0.00,1008.60,363096.00,0.00,0.00,0.00),('1','151','755','184357',3616046,'2120','314',868298.58,869446.83,0.00,0.00,1148.25,413370.00,0.00,0.00,0.00),('1','151','755','184471',3618125,'2119','314',1647729.63,1648768.38,0.00,0.00,1038.75,373950.00,0.00,0.00,0.00),('1','151','755','184471',3618126,'2120','314',869446.83,870793.59,0.00,0.00,1346.76,484833.60,0.00,0.00,0.00),('1','151','755','184678',3622044,'2119','314',1648768.38,1649606.11,0.00,0.00,837.73,301582.80,0.00,0.00,0.00),('1','151','755','184678',3622045,'2120','314',870793.59,872443.99,0.00,0.00,1650.40,594144.00,0.00,0.00,0.00),('1','151','755','184902',3625941,'2119','314',1649606.11,1650786.22,0.00,0.00,1180.11,424839.60,0.00,0.00,0.00),('1','151','755','184902',3625942,'2120','314',872443.99,874289.94,0.00,0.00,1845.95,664542.00,0.00,0.00,0.00),('1','151','755','185099',3629393,'2119','314',1650786.22,1651215.81,0.00,0.00,429.59,154652.40,0.00,0.00,0.00),('1','151','755','185099',3629394,'2120','314',874289.94,875377.14,0.00,0.00,1087.20,391392.00,0.00,0.00,0.00),('1','151','755','185222',3631400,'2119','314',1651215.81,1651426.04,0.00,0.00,210.23,75682.80,0.00,0.00,0.00),('1','151','755','185222',3631401,'2120','314',875377.14,875592.81,0.00,0.00,215.67,77641.20,0.00,0.00,0.00),('1','151','755','185265',3631952,'2119','314',1651426.04,1652565.56,0.00,0.00,1139.52,410227.20,0.00,0.00,0.00),('1','151','755','185265',3631953,'2120','314',875592.81,877002.57,0.00,0.00,1409.76,507513.60,0.00,0.00,0.00),('1','151','755','185461',3635752,'2119','314',1652565.56,1653055.89,0.00,0.00,490.33,176518.80,0.00,0.00,0.00),('1','151','755','185461',3635753,'2120','314',877002.57,878099.70,0.00,0.00,1097.13,394966.80,0.00,0.00,0.00),('1','151','755','185597',3638219,'2119','314',1653055.89,1653215.80,0.00,0.00,159.91,57567.60,0.00,0.00,0.00),('1','151','755','185597',3638220,'2120','314',878099.70,878293.72,0.00,0.00,194.02,69847.20,0.00,0.00,0.00),('1','151','755','185678',3639534,'2119','314',1653215.80,1654229.58,0.00,0.00,1013.78,364960.80,0.00,0.00,0.00),('1','151','755','185678',3639535,'2120','314',878293.72,879773.31,0.00,0.00,1479.59,532652.40,0.00,0.00,0.00),('1','151','755','185865',3643002,'2119','314',1654229.58,1654945.76,0.00,0.00,716.18,257824.80,0.00,0.00,0.00),('1','151','755','185865',3643003,'2120','314',879773.31,880764.67,0.00,0.00,991.36,356889.60,0.00,0.00,0.00),('1','151','755','186008',3645501,'2119','314',1654945.76,1655320.83,0.00,0.00,375.07,135025.20,0.00,0.00,0.00),('1','151','755','186008',3645502,'2120','314',880764.67,881133.31,0.00,0.00,368.64,132710.40,0.00,0.00,0.00),('1','151','755','186099',3647113,'2119','314',1655320.83,1656532.08,0.00,0.00,1211.25,436050.00,0.00,0.00,0.00),('1','151','755','186099',3647114,'2120','314',881133.31,882721.02,0.00,0.00,1587.71,571575.60,0.00,0.00,0.00),('1','151','755','186310',3650624,'2119','314',1656532.08,1656830.77,0.00,0.00,298.69,107528.40,0.00,0.00,0.00),('1','151','755','186310',3650625,'2120','314',882721.02,883395.18,0.00,0.00,674.16,242697.60,0.00,0.00,0.00),('1','151','755','186442',3652779,'2119','314',1656830.77,1657375.32,0.00,0.00,544.55,196038.00,0.00,0.00,0.00),('1','151','755','186442',3652780,'2120','314',883395.18,883894.96,0.00,0.00,499.78,179920.80,0.00,0.00,0.00),('1','151','755','186548',3654591,'2119','314',1657375.32,1658754.13,0.00,0.00,1378.81,496371.60,0.00,0.00,0.00),('1','151','755','186548',3654592,'2120','314',883894.96,884799.55,0.00,0.00,904.59,325652.40,0.00,0.00,0.00),('1','151','755','186749',3658124,'2119','314',1658754.13,1659371.74,0.00,0.00,617.61,222339.60,0.00,0.00,0.00),('1','151','755','186749',3658125,'2120','314',884799.55,885378.97,0.00,0.00,579.42,208591.20,0.00,0.00,0.00),('1','151','755','186909',3660855,'2119','314',1659371.74,1659684.07,0.00,0.00,312.33,112438.80,0.00,0.00,0.00),('1','151','755','186909',3660856,'2120','314',885378.97,885639.92,0.00,0.00,260.95,93942.00,0.00,0.00,0.00),('1','151','755','186979',3661901,'2119','314',1659684.07,1660561.65,0.00,0.00,877.58,315928.80,0.00,0.00,0.00),('1','151','755','186979',3661902,'2120','314',885639.92,886449.25,0.00,0.00,809.33,291358.80,0.00,0.00,0.00),('1','151','755','187161',3665027,'2119','314',1660561.65,1661639.21,0.00,0.00,1077.56,387921.60,0.00,0.00,0.00),('1','151','755','187161',3665028,'2120','314',886449.25,888467.18,0.00,0.00,2017.93,726454.80,0.00,0.00,0.00),('1','151','755','187344',3668397,'2119','314',1661639.21,1662146.07,0.00,0.00,506.86,182469.60,0.00,0.00,0.00),('1','151','755','187344',3668398,'2120','314',888467.18,889397.93,0.00,0.00,930.75,335070.00,0.00,0.00,0.00),('1','151','755','187460',3670558,'2119','314',1662146.07,1662755.99,0.00,0.00,609.92,219571.20,0.00,0.00,0.00),('1','151','755','187460',3670559,'2120','314',889397.93,890166.61,0.00,0.00,768.68,276724.80,0.00,0.00,0.00),('1','151','755','187576',3672461,'2119','314',1662755.99,1663782.03,0.00,0.00,1026.04,369374.40,0.00,0.00,0.00),('1','151','755','187576',3672462,'2120','314',890166.61,892310.26,0.00,0.00,2143.65,771714.00,0.00,0.00,0.00),('1','151','755','187788',3676308,'2119','314',1663782.03,1665305.30,0.00,0.00,1523.27,548377.20,0.00,0.00,0.00),('1','151','755','187788',3676309,'2120','314',892310.26,894035.99,0.00,0.00,1725.73,621262.80,0.00,0.00,0.00),('1','151','755','188014',3680243,'2119','314',1665305.30,1665848.23,0.00,0.00,542.93,195454.80,0.00,0.00,0.00),('1','151','755','188014',3680244,'2120','314',894035.99,894788.56,0.00,0.00,752.57,270925.20,0.00,0.00,0.00),('1','151','755','188102',3681635,'2119','314',1665848.23,1666680.87,0.00,0.00,832.64,299750.40,0.00,0.00,0.00),('1','151','755','188102',3681636,'2120','314',894788.56,895836.70,0.00,0.00,1048.14,377330.40,0.00,0.00,0.00),('1','151','755','188210',3683576,'2119','314',1666680.87,1668192.31,0.00,0.00,1511.44,544118.40,0.00,0.00,0.00),('1','151','755','188210',3683577,'2120','314',895836.70,896980.88,0.00,0.00,1144.18,411904.80,0.00,0.00,0.00),('1','151','755','188421',3687165,'2119','314',1668192.31,1669648.80,0.00,0.00,1456.49,524336.40,0.00,0.00,0.00),('1','151','755','188421',3687166,'2120','314',896980.88,899243.98,0.00,0.00,2263.10,814716.00,0.00,0.00,0.00),('1','151','755','188604',3690374,'2119','314',1669648.80,1670147.42,0.00,0.00,498.62,179503.20,0.00,0.00,0.00),('1','151','755','188604',3690375,'2120','314',899243.98,899548.13,0.00,0.00,304.15,109494.00,0.00,0.00,0.00),('1','151','755','188685',3691749,'2119','314',1670147.42,1671107.10,0.00,0.00,959.68,345484.80,0.00,0.00,0.00),('1','151','755','188685',3691750,'2120','314',899548.13,900859.45,0.00,0.00,1311.32,472075.20,0.00,0.00,0.00),('1','151','755','188801',3693936,'2119','314',1671107.10,1671296.21,0.00,0.00,189.11,68079.60,0.00,0.00,0.00),('1','151','755','188801',3693937,'2120','314',900859.45,901309.76,0.00,0.00,450.31,162111.60,0.00,0.00,0.00),('1','151','755','188892',3695494,'2119','314',1671296.21,1672161.45,0.00,0.00,865.24,311486.40,0.00,0.00,0.00),('1','151','755','188892',3695495,'2120','314',901309.76,902323.32,0.00,0.00,1013.56,364881.60,0.00,0.00,0.00),('1','151','755','189008',3697647,'2119','314',1672161.45,1673724.25,0.00,0.00,1562.80,562608.00,0.00,0.00,0.00),('1','151','755','189008',3697648,'2120','314',902323.32,903399.90,0.00,0.00,1076.58,387568.80,0.00,0.00,0.00),('1','151','755','189194',3700941,'2119','314',1673724.25,1675104.79,0.00,0.00,1380.54,496994.40,0.00,0.00,0.00),('1','151','755','189194',3700942,'2120','314',903399.90,905450.85,0.00,0.00,2050.95,738342.00,0.00,0.00,0.00),('1','151','755','189424',3705117,'2119','314',1675104.79,1675439.45,0.00,0.00,334.66,120477.60,0.00,0.00,0.00),('1','151','755','189424',3705118,'2120','314',905450.85,906219.46,0.00,0.00,768.61,276699.60,0.00,0.00,0.00),('1','151','755','189514',3706652,'2119','314',1675439.45,1676350.45,0.00,0.00,911.00,327960.00,0.00,0.00,0.00),('1','151','755','189514',3706653,'2120','314',906219.46,907435.90,0.00,0.00,1216.44,437918.40,0.00,0.00,0.00),('1','151','755','189614',3708446,'2119','314',1676350.45,1677230.44,0.00,0.00,879.99,316796.40,0.00,0.00,0.00),('1','151','755','189614',3708447,'2120','314',907435.90,908971.05,0.00,0.00,1535.15,552654.00,0.00,0.00,0.00),('1','151','755','189759',3710966,'2119','314',1677230.44,1677501.60,0.00,0.00,271.16,97617.60,0.00,0.00,0.00),('1','151','755','189759',3710967,'2120','314',908971.05,909184.11,0.00,0.00,213.06,76701.60,0.00,0.00,0.00),('1','151','755','189807',3711844,'2119','314',1677501.60,1678881.26,0.00,0.00,1379.66,496677.60,0.00,0.00,0.00),('1','151','755','189807',3711845,'2120','314',909184.11,911189.08,0.00,0.00,2004.97,721789.20,0.00,0.00,0.00),('1','151','755','190028',3716233,'2119','314',1678881.26,1679149.75,0.00,0.00,268.49,96656.40,0.00,0.00,0.00),('1','151','755','190028',3716234,'2120','314',911189.08,911582.97,0.00,0.00,393.89,141800.40,0.00,0.00,0.00),('1','151','755','190086',3717202,'2119','314',1679149.75,1680117.74,0.00,0.00,967.99,348476.40,0.00,0.00,0.00),('1','151','755','190086',3717203,'2120','314',911582.97,912846.59,0.00,0.00,1263.62,454903.20,0.00,0.00,0.00),('1','151','755','190269',3720564,'2119','314',1680117.74,1682285.84,0.00,0.00,2168.10,780516.00,0.00,0.00,0.00),('1','151','755','190269',3720565,'2120','314',912846.59,915062.69,0.00,0.00,2216.10,797796.00,0.00,0.00,0.00),('1','151','755','190434',3723791,'2119','314',1682285.84,1682448.01,0.00,0.00,162.17,58381.20,0.00,0.00,0.00),('1','151','755','190434',3723792,'2120','314',915062.69,915131.50,0.00,0.00,68.81,24771.60,0.00,0.00,0.00),('1','151','755','190482',3724487,'2119','314',1682448.01,1684308.51,0.00,0.00,1860.50,669780.00,0.00,0.00,0.00),('1','151','755','190482',3724488,'2120','314',915131.50,917321.96,0.00,0.00,2190.46,788565.60,0.00,0.00,0.00),('1','151','755','190688',3728371,'2119','314',1684308.51,1684402.01,0.00,0.00,93.50,33660.00,0.00,0.00,0.00),('1','151','755','190688',3728372,'2120','314',917321.96,917760.18,0.00,0.00,438.22,157759.20,0.00,0.00,0.00),('1','151','755','190706',3728744,'2119','314',1684402.01,1685508.84,0.00,0.00,1106.83,398458.80,0.00,0.00,0.00),('1','151','755','190706',3728745,'2120','314',917760.18,919145.27,0.00,0.00,1385.09,498632.40,0.00,0.00,0.00),('1','151','755','190883',3732156,'2119','314',1685508.84,1686391.05,0.00,0.00,882.21,317595.60,0.00,0.00,0.00),('1','151','755','190883',3732157,'2120','314',919145.27,920287.93,0.00,0.00,1142.66,411357.60,0.00,0.00,0.00),('1','151','755','191014',3734335,'2119','314',1686391.05,1686758.31,0.00,0.00,367.26,132213.60,0.00,0.00,0.00),('1','151','755','191014',3734336,'2120','314',920287.93,920973.89,0.00,0.00,685.96,246945.60,0.00,0.00,0.00),('1','151','755','191090',3735622,'2119','314',1686758.31,1687815.82,0.00,0.00,1057.51,380703.60,0.00,0.00,0.00),('1','151','755','191090',3735623,'2120','314',920973.89,922561.66,0.00,0.00,1587.77,571597.20,0.00,0.00,0.00),('1','151','755','191288',3739244,'2119','314',1687815.82,1688128.36,0.00,0.00,312.54,112514.40,0.00,0.00,0.00),('1','151','755','191288',3739245,'2120','314',922561.66,923034.97,0.00,0.00,473.31,170391.60,0.00,0.00,0.00),('1','151','755','191443',3742036,'2119','314',1688128.36,1688378.84,0.00,0.00,250.48,90172.80,0.00,0.00,0.00),('1','151','755','191443',3742037,'2120','314',923034.97,923435.73,0.00,0.00,400.76,144273.60,0.00,0.00,0.00),('1','151','755','191497',3742995,'2119','314',1688378.84,1689274.93,0.00,0.00,896.09,322592.40,0.00,0.00,0.00),('1','151','755','191497',3742996,'2120','314',923435.73,924617.59,0.00,0.00,1181.86,425469.60,0.00,0.00,0.00),('1','151','755','191707',3747179,'2119','314',1689274.93,1690274.03,0.00,0.00,999.10,359676.00,0.00,0.00,0.00),('1','151','755','191707',3747180,'2120','314',924617.59,926304.38,0.00,0.00,1686.79,607244.40,0.00,0.00,0.00),('1','151','755','191952',3751729,'2119','314',1690274.03,1690917.11,0.00,0.00,643.08,231508.80,0.00,0.00,0.00),('1','151','755','191952',3751730,'2120','314',926304.38,927454.33,0.00,0.00,1149.95,413982.00,0.00,0.00,0.00),('1','151','755','192131',3754930,'2119','314',1690917.11,1691418.75,0.00,0.00,501.64,180590.40,0.00,0.00,0.00),('1','151','755','192131',3754931,'2120','314',927454.33,928615.42,0.00,0.00,1161.09,417992.40,0.00,0.00,0.00),('1','151','755','192328',3758753,'2119','314',1691418.75,1692127.46,0.00,0.00,708.71,255135.60,0.00,0.00,0.00),('1','151','755','192328',3758754,'2120','314',928615.42,930455.23,0.00,0.00,1839.81,662331.60,0.00,0.00,0.00),('1','151','755','192565',3762873,'2119','314',1692127.46,1692223.81,0.00,0.00,96.35,34686.00,0.00,0.00,0.00),('1','151','755','192565',3762874,'2120','314',930455.23,930734.45,0.00,0.00,279.22,100519.20,0.00,0.00,0.00),('1','151','755','192637',3764024,'2119','314',1692223.81,1692654.96,0.00,0.00,431.15,155214.00,0.00,0.00,0.00),('1','151','755','192637',3764025,'2120','314',930734.45,931730.58,0.00,0.00,996.13,358606.80,0.00,0.00,0.00),('1','151','755','192776',3766530,'2119','314',1692654.96,1694338.88,0.00,0.00,1683.92,606211.20,0.00,0.00,0.00),('1','151','755','192776',3766531,'2120','314',931730.58,932765.00,0.00,0.00,1034.42,372391.20,0.00,0.00,0.00),('1','151','755','192954',3769905,'2119','314',1694338.88,1694579.40,0.00,0.00,240.52,86587.20,0.00,0.00,0.00),('1','151','755','192954',3769906,'2120','314',932765.00,932911.50,0.00,0.00,146.50,52740.00,0.00,0.00,0.00),('1','151','755','193021',3771056,'2119','314',1694579.40,1695112.95,0.00,0.00,533.55,192078.00,0.00,0.00,0.00),('1','151','755','193021',3771057,'2120','314',932911.50,933600.48,0.00,0.00,688.98,248032.80,0.00,0.00,0.00),('1','151','755','193155',3773886,'2119','314',1695112.95,1696282.34,0.00,0.00,1169.39,420980.40,0.00,0.00,0.00),('1','151','755','193155',3773887,'2120','314',933600.48,935437.47,0.00,0.00,1836.99,661316.40,0.00,0.00,0.00),('1','151','755','193405',3778835,'2119','314',1696282.34,1696364.11,0.00,0.00,81.77,29437.20,0.00,0.00,0.00),('1','151','755','193405',3778836,'2120','314',935437.47,935668.01,0.00,0.00,230.54,82994.40,0.00,0.00,0.00),('1','151','755','193486',3780226,'2119','314',1696364.11,1696950.01,0.00,0.00,585.90,210924.00,0.00,0.00,0.00),('1','151','755','193486',3780227,'2120','314',935668.01,936709.17,0.00,0.00,1041.16,374817.60,0.00,0.00,0.00),('1','151','755','193645',3782995,'2119','314',1696950.01,1697922.03,0.00,0.00,972.02,349927.20,0.00,0.00,0.00),('1','151','755','193645',3782996,'2120','314',936709.17,938443.45,0.00,0.00,1734.28,624340.80,0.00,0.00,0.00),('1','151','755','193850',3786848,'2119','314',1697922.03,1698475.98,0.00,0.00,553.95,199422.00,0.00,0.00,0.00),('1','151','755','193850',3786849,'2120','314',938443.45,939894.60,0.00,0.00,1451.15,522414.00,0.00,0.00,0.00),('1','151','755','194067',3790805,'2119','314',1698475.98,1699726.56,0.00,0.00,1250.58,450208.80,0.00,0.00,0.00),('1','151','755','194067',3790806,'2120','314',939894.60,941201.05,0.00,0.00,1306.45,470322.00,0.00,0.00,0.00),('1','151','755','194289',3794826,'2119','314',1699726.56,1700268.82,0.00,0.00,542.26,195213.60,0.00,0.00,0.00),('1','151','755','194289',3794827,'2120','314',941201.05,942632.05,0.00,0.00,1431.00,515160.00,0.00,0.00,0.00),('1','151','755','194529',3798914,'2119','314',1700268.82,1702388.21,0.00,0.00,2119.39,762980.40,0.00,0.00,0.00),('1','151','755','194529',3798915,'2120','314',942632.05,943620.31,0.00,0.00,988.26,355773.60,0.00,0.00,0.00),('1','151','755','194669',3801588,'2119','314',1702388.21,1703335.47,0.00,0.00,947.26,341013.60,0.00,0.00,0.00),('1','151','755','194669',3801589,'2120','314',943620.31,944056.34,0.00,0.00,436.03,156970.80,0.00,0.00,0.00),('1','151','755','194802',3804202,'2119','314',1703335.47,1703817.63,0.00,0.00,482.16,173577.60,0.00,0.00,0.00),('1','151','755','194802',3804203,'2120','314',944056.34,944915.20,0.00,0.00,858.86,309189.60,0.00,0.00,0.00),('1','151','755','195017',3808247,'2119','314',1703817.63,1704775.28,0.00,0.00,957.65,344754.00,0.00,0.00,0.00),('1','151','755','195017',3808248,'2120','314',944915.20,946611.25,0.00,0.00,1696.05,610578.00,0.00,0.00,0.00),('1','151','755','195141',3810432,'2119','314',1704775.28,1704904.28,0.00,0.00,129.00,46440.00,0.00,0.00,0.00),('1','151','755','195141',3810433,'2120','314',946611.25,947016.86,0.00,0.00,405.61,146019.60,0.00,0.00,0.00),('1','151','755','195189',3811309,'2119','314',1704904.28,1705598.94,0.00,0.00,694.66,250077.60,0.00,0.00,0.00),('1','151','755','195189',3811310,'2120','314',947016.86,948259.74,0.00,0.00,1242.88,447436.80,0.00,0.00,0.00),('1','151','755','195291',3813238,'2119','314',1705598.94,1705918.79,0.00,0.00,319.85,115146.00,0.00,0.00,0.00),('1','151','755','195291',3813239,'2120','314',948259.74,949173.09,0.00,0.00,913.35,328806.00,0.00,0.00,0.00),('1','151','755','195399',3814963,'2119','314',1705918.79,1706477.34,0.00,0.00,558.55,194375.40,0.00,0.00,0.00),('1','151','755','195399',3814964,'2120','314',949173.09,949984.09,0.00,0.00,811.00,282228.00,0.00,0.00,0.00),('1','151','755','195557',3817607,'2119','314',1706477.34,1707316.43,0.00,0.00,839.09,292003.32,0.00,0.00,0.00),('1','151','755','195557',3817608,'2120','314',949984.09,951649.22,0.00,0.00,1665.13,579465.24,0.00,0.00,0.00),('1','151','755','195790',3821550,'2119','314',1707316.43,1708058.72,0.00,0.00,742.29,258316.92,0.00,0.00,0.00),('1','151','755','195790',3821551,'2120','314',951649.22,952983.78,0.00,0.00,1334.56,464426.88,0.00,0.00,0.00),('1','151','755','196009',3825646,'2119','314',1708058.72,1708972.61,0.00,0.00,913.89,318033.72,0.00,0.00,0.00),('1','151','755','196009',3825647,'2120','314',952983.78,954627.00,0.00,0.00,1643.22,571840.56,0.00,0.00,0.00),('1','151','755','196212',3829634,'2119','314',1708972.61,1711011.84,0.00,0.00,2039.23,709652.04,0.00,0.00,0.00),('1','151','755','196212',3829635,'2120','314',954627.00,956055.87,0.00,0.00,1428.87,497246.76,0.00,0.00,0.00),('1','151','755','196449',3833829,'2119','314',1711011.84,1711392.82,0.00,0.00,380.98,132581.04,0.00,0.00,0.00),('1','151','755','196449',3833830,'2120','314',956055.87,956713.13,0.00,0.00,657.26,228726.48,0.00,0.00,0.00),('1','151','755','196545',3835507,'2119','314',1711392.82,1712405.65,0.00,0.00,1012.83,352464.84,0.00,0.00,0.00),('1','151','755','196545',3835508,'2120','314',956713.13,957928.90,0.00,0.00,1215.77,423087.96,0.00,0.00,0.00),('1','151','755','196655',3837538,'2119','314',1712405.65,1713113.21,0.00,0.00,707.56,246230.88,0.00,0.00,0.00),('1','151','755','196655',3837539,'2120','314',957928.90,959522.05,0.00,0.00,1593.15,554416.20,0.00,0.00,0.00),('1','151','755','196815',3840319,'2119','314',1713113.21,1713415.40,0.00,0.00,302.19,105162.12,0.00,0.00,0.00),('1','151','755','196815',3840320,'2120','314',959522.05,959975.09,0.00,0.00,453.04,157657.92,0.00,0.00,0.00),('1','151','755','196881',3841528,'2119','314',1713415.40,1713953.53,0.00,0.00,538.13,187269.24,0.00,0.00,0.00),('1','151','755','196881',3841529,'2120','314',959975.09,961554.10,0.00,0.00,1579.01,549495.48,0.00,0.00,0.00),('1','151','755','197025',3844214,'2119','314',1713953.53,1714602.13,0.00,0.00,648.60,225712.80,0.00,0.00,0.00),('1','151','755','197025',3844215,'2120','314',961554.10,962513.60,0.00,0.00,959.50,333906.00,0.00,0.00,0.00),('1','151','755','197141',3846119,'2119','314',1714602.13,1714829.50,0.00,0.00,227.37,79124.76,0.00,0.00,0.00),('1','151','755','197141',3846120,'2120','314',962513.60,963085.64,0.00,0.00,572.04,199069.92,0.00,0.00,0.00),('1','151','755','197679',3855398,'2119','314',1714829.50,1715612.85,0.00,0.00,783.35,272605.80,0.00,0.00,0.00),('1','151','755','197679',3855399,'2120','314',963085.64,964650.03,0.00,0.00,1564.39,544407.72,0.00,0.00,0.00),('1','151','755','197702',3855732,'2119','314',1715612.85,1715842.74,0.00,0.00,229.89,80001.72,0.00,0.00,0.00),('1','151','755','197702',3855733,'2120','314',964650.03,965260.27,0.00,0.00,610.24,212363.52,0.00,0.00,0.00),('1','151','755','197708',3855853,'2119','314',1715842.74,1716111.08,0.00,0.00,268.34,93382.32,0.00,0.00,0.00),('1','151','755','197708',3855854,'2120','314',965260.27,966074.54,0.00,0.00,814.27,283365.96,0.00,0.00,0.00),('1','151','755','197720',3856022,'2119','314',1716111.08,1716658.85,0.00,0.00,547.77,190623.96,0.00,0.00,0.00),('1','151','755','197720',3856023,'2120','314',966074.54,967410.63,0.00,0.00,1336.09,464959.32,0.00,0.00,0.00),('1','151','755','197895',3859111,'2119','314',1716658.85,1717362.34,0.00,0.00,703.49,244814.52,0.00,0.00,0.00),('1','151','755','197895',3859112,'2120','314',967410.63,969070.80,0.00,0.00,1660.17,577739.16,0.00,0.00,0.00),('1','151','755','198108',3863026,'2119','314',1717362.34,1718003.18,0.00,0.00,640.84,223012.32,0.00,0.00,0.00),('1','151','755','198108',3863027,'2120','314',969070.80,970561.41,0.00,0.00,1490.61,518732.28,0.00,0.00,0.00),('1','151','755','198372',3867275,'2119','314',1718003.18,1718976.36,0.00,0.00,973.18,338666.64,0.00,0.00,0.00),('1','151','755','198372',3867276,'2120','314',970561.41,972529.24,0.00,0.00,1967.83,684804.84,0.00,0.00,0.00),('1','151','755','198560',3870744,'2119','314',1718976.36,1719615.07,0.00,0.00,638.71,222271.08,0.00,0.00,0.00),('1','151','755','198560',3870745,'2120','314',972529.24,973428.82,0.00,0.00,899.58,313053.84,0.00,0.00,0.00),('1','151','755','198713',3873576,'2119','314',1719615.07,1719864.70,0.00,0.00,249.63,86871.24,0.00,0.00,0.00),('1','151','755','198713',3873577,'2120','314',973428.82,973831.12,0.00,0.00,402.30,140000.40,0.00,0.00,0.00),('1','151','755','198792',3874479,'2119','314',1719864.70,1720795.57,0.00,0.00,930.87,323942.76,0.00,0.00,0.00),('1','151','755','198792',3874480,'2120','314',973831.12,975865.33,0.00,0.00,2034.21,707905.08,0.00,0.00,0.00),('1','151','755','198971',3877762,'2119','314',1720795.57,1720973.22,0.00,0.00,177.65,61822.20,0.00,0.00,0.00),('1','151','755','198971',3877763,'2120','314',975865.33,976590.88,0.00,0.00,725.55,252491.40,0.00,0.00,0.00),('1','151','755','199069',3879412,'2119','314',1720973.22,1721604.24,0.00,0.00,631.02,219594.96,0.00,0.00,0.00),('1','151','755','199069',3879413,'2120','314',976590.88,977660.57,0.00,0.00,1069.69,372252.12,0.00,0.00,0.00),('1','151','755','199191',3881696,'2119','314',1721604.24,1722556.24,0.00,0.00,952.00,331296.00,0.00,0.00,0.00),('1','151','755','199191',3881697,'2120','314',977660.57,979541.25,0.00,0.00,1880.68,654476.64,0.00,0.00,0.00),('1','151','755','199433',3885495,'2119','314',1722556.24,1723350.39,0.00,0.00,794.15,276364.20,0.00,0.00,0.00),('1','151','755','199433',3885496,'2120','314',979541.25,981505.98,0.00,0.00,1964.73,683726.04,0.00,0.00,0.00),('1','151','755','199674',3889414,'2119','314',1723350.39,1724119.64,0.00,0.00,769.25,267699.00,0.00,0.00,0.00),('1','151','755','199674',3889415,'2120','314',981505.98,982550.82,0.00,0.00,1044.84,363604.32,0.00,0.00,0.00),('1','151','755','199817',3891735,'2119','314',1724119.64,1724377.70,0.00,0.00,258.06,89804.88,0.00,0.00,0.00),('1','151','755','199817',3891736,'2120','314',982550.82,982910.29,0.00,0.00,359.47,125095.56,0.00,0.00,0.00),('1','151','755','199867',3892480,'2119','314',1724377.70,1724965.20,0.00,0.00,587.50,204450.00,0.00,0.00,0.00),('1','151','755','199867',3892481,'2120','314',982910.29,983914.89,0.00,0.00,1004.60,349600.80,0.00,0.00,0.00),('1','151','755','200041',3895864,'2119','314',1724965.20,1725057.69,0.00,0.00,92.49,32186.52,0.00,0.00,0.00),('1','151','755','200041',3895865,'2120','314',983914.89,984161.53,0.00,0.00,246.64,85830.72,0.00,0.00,0.00),('1','151','755','200091',3896721,'2119','314',1725057.69,1725659.78,0.00,0.00,602.09,209527.32,0.00,0.00,0.00),('1','151','755','200091',3896722,'2120','314',984161.53,985805.53,0.00,0.00,1644.00,572112.00,0.00,0.00,0.00),('1','151','755','200323',3900599,'2119','314',1725659.78,1726241.91,0.00,0.00,582.13,202581.24,0.00,0.00,0.00),('1','151','755','200323',3900600,'2120','314',985805.53,987142.04,0.00,0.00,1336.51,465105.48,0.00,0.00,0.00),('1','151','755','200441',3902974,'2119','314',1726241.91,1727158.29,0.00,0.00,916.38,318900.24,0.00,0.00,0.00),('1','151','755','200441',3902975,'2120','314',987142.04,989289.63,0.00,0.00,2147.59,747361.32,0.00,0.00,0.00),('1','151','755','200696',3907532,'2119','314',1727158.29,1727514.14,0.00,0.00,355.85,123835.80,0.00,0.00,0.00),('1','151','755','200696',3907533,'2120','314',989289.63,990381.05,0.00,0.00,1091.42,379814.16,0.00,0.00,0.00),('1','151','755','200875',3910874,'2119','314',1727514.14,1727569.87,0.00,0.00,55.73,19394.04,0.00,0.00,0.00),('1','151','755','200875',3910875,'2120','314',990381.05,990478.32,0.00,0.00,97.27,33849.96,0.00,0.00,0.00),('1','151','755','200940',3911685,'2119','314',1727569.87,1728754.82,0.00,0.00,1184.95,412362.60,0.00,0.00,0.00),('1','151','755','200940',3911686,'2120','314',990478.32,992919.56,0.00,0.00,2441.24,849551.52,0.00,0.00,0.00),('1','151','755','201113',3914653,'2119','314',1728754.82,1728916.88,0.00,0.00,162.06,56396.88,0.00,0.00,0.00),('1','151','755','201113',3914654,'2120','314',992919.56,993467.50,0.00,0.00,547.94,190683.12,0.00,0.00,0.00),('1','151','755','201233',3916611,'2119','314',1728916.88,1729317.57,0.00,0.00,400.69,139440.12,0.00,0.00,0.00),('1','151','755','201233',3916612,'2120','314',993467.50,994305.55,0.00,0.00,838.05,291641.40,0.00,0.00,0.00),('1','151','755','201296',3917844,'2119','314',1729317.57,1730230.92,0.00,0.00,913.35,317845.80,0.00,0.00,0.00),('1','151','755','201296',3917845,'2120','314',994305.55,996632.84,0.00,0.00,2327.29,809896.92,0.00,0.00,0.00),('1','151','755','201492',3921434,'2119','314',1730230.92,1731474.38,0.00,0.00,1243.46,432724.08,0.00,0.00,0.00),('1','151','755','201492',3921435,'2120','314',996632.84,998941.87,0.00,0.00,2309.03,803542.44,0.00,0.00,0.00),('1','151','755','201759',3926583,'2119','314',1731474.38,1731839.51,0.00,0.00,365.13,127065.24,0.00,0.00,0.00),('1','151','755','201759',3926584,'2120','314',998941.87,999484.56,0.00,0.00,542.69,188856.12,0.00,0.00,0.00),('1','151','755','201866',3928450,'2119','314',1731839.51,1732894.18,0.00,0.00,1054.67,367025.16,0.00,0.00,0.00),('1','151','755','201866',3928451,'2120','314',999484.56,1000179.83,0.00,0.00,695.27,241953.96,0.00,0.00,0.00),('1','151','755','202032',3931652,'2119','314',1732894.18,1733610.99,0.00,0.00,716.81,249449.88,0.00,0.00,0.00),('1','151','755','202032',3931653,'2120','314',1000179.83,1000695.39,0.00,0.00,515.56,179414.88,0.00,0.00,0.00),('1','151','755','202143',3933605,'2119','314',1733610.99,1733965.78,0.00,0.00,354.79,123466.92,0.00,0.00,0.00),('1','151','755','202143',3933606,'2120','314',1000695.39,1000934.67,0.00,0.00,239.28,83269.44,0.00,0.00,0.00),('1','151','755','202210',3934644,'2119','314',1733965.78,1735794.37,0.00,0.00,1828.59,636349.32,0.00,0.00,0.00),('1','151','755','202210',3934645,'2120','314',1000934.67,1001649.59,0.00,0.00,714.92,248792.16,0.00,0.00,0.00),('1','151','755','202431',3938473,'2119','314',1735794.37,1736209.53,0.00,0.00,415.16,144475.68,0.00,0.00,0.00),('1','151','755','202431',3938474,'2120','314',1001649.59,1002566.02,0.00,0.00,916.43,318917.64,0.00,0.00,0.00),('1','151','755','202525',3940146,'2119','314',1736209.53,1736782.22,0.00,0.00,572.69,199296.12,0.00,0.00,0.00),('1','151','755','202525',3940147,'2120','314',1002566.02,1003622.82,0.00,0.00,1056.80,367766.40,0.00,0.00,0.00),('1','151','755','202741',3943801,'2119','314',1736782.22,1737626.88,0.00,0.00,844.66,293941.68,0.00,0.00,0.00),('1','151','755','202741',3943802,'2120','314',1003622.82,1005500.20,0.00,0.00,1877.38,653328.24,0.00,0.00,0.00),('1','151','755','202835',3945781,'2119','314',1737626.88,1737653.14,0.00,0.00,26.26,9453.60,0.00,0.00,0.00),('1','151','755','202835',3945782,'2120','314',1005500.20,1005653.22,0.00,0.00,153.02,55087.20,0.00,0.00,0.00),('1','151','755','202940',3947430,'2119','314',1737653.14,1739046.01,0.00,0.00,1392.87,501433.20,0.00,0.00,0.00),('1','151','755','202940',3947431,'2120','314',1005653.22,1006487.33,0.00,0.00,834.11,300279.60,0.00,0.00,0.00),('1','151','755','203099',3950753,'2119','314',1739046.01,1739651.67,0.00,0.00,605.66,218037.60,0.00,0.00,0.00),('1','151','755','203099',3950754,'2120','314',1006487.33,1008106.29,0.00,0.00,1618.96,582825.60,0.00,0.00,0.00),('1','151','755','203306',3954486,'2119','314',1739651.67,1740404.19,0.00,0.00,752.52,270907.20,0.00,0.00,0.00),('1','151','755','203306',3954487,'2120','314',1008106.29,1010112.93,0.00,0.00,2006.64,722390.40,0.00,0.00,0.00),('1','151','755','203520',3958266,'2119','314',1740404.19,1740774.05,0.00,0.00,369.86,133149.60,0.00,0.00,0.00),('1','151','755','203520',3958267,'2120','314',1010112.93,1011443.97,0.00,0.00,1331.04,479174.40,0.00,0.00,0.00),('1','151','755','203660',3960860,'2119','314',1740774.05,1741058.91,0.00,0.00,284.86,102549.60,0.00,0.00,0.00),('1','151','755','203660',3960861,'2120','314',1011443.97,1011830.14,0.00,0.00,386.17,139021.20,0.00,0.00,0.00),('1','151','755','203726',3962008,'2119','314',1741058.91,1742253.64,0.00,0.00,1194.73,430102.80,0.00,0.00,0.00),('1','151','755','203726',3962009,'2120','314',1011830.14,1013415.18,0.00,0.00,1585.04,570614.40,0.00,0.00,0.00),('1','151','755','203949',3966023,'2119','314',1742253.64,1742554.96,0.00,0.00,301.32,108475.20,0.00,0.00,0.00),('1','151','755','203949',3966024,'2120','314',1013415.18,1014139.16,0.00,0.00,723.98,260632.80,0.00,0.00,0.00),('1','151','755','204075',3968105,'2119','314',1742554.96,1742941.76,0.00,0.00,386.80,139248.00,0.00,0.00,0.00),('1','151','755','204075',3968106,'2120','314',1014139.16,1014926.28,0.00,0.00,787.12,283363.20,0.00,0.00,0.00),('1','151','755','204186',3970318,'2119','314',1742941.76,1743573.89,0.00,0.00,632.13,227566.80,0.00,0.00,0.00),('1','151','755','204186',3970319,'2120','314',1014926.28,1016010.49,0.00,0.00,1084.21,390315.60,0.00,0.00,0.00),('1','151','755','204333',3972936,'2119','314',1743573.89,1743876.11,0.00,0.00,302.22,108799.20,0.00,0.00,0.00),('1','151','755','204333',3972937,'2120','314',1016010.49,1016221.45,0.00,0.00,210.96,75945.60,0.00,0.00,0.00),('1','151','755','204393',3973967,'2119','314',1743876.11,1745009.31,0.00,0.00,1133.20,407952.00,0.00,0.00,0.00),('1','151','755','204393',3973968,'2120','314',1016221.45,1017856.35,0.00,0.00,1634.90,588564.00,0.00,0.00,0.00),('1','151','755','204617',3978049,'2119','314',1745009.31,1745698.61,0.00,0.00,689.30,248148.00,0.00,0.00,0.00),('1','151','755','204617',3978050,'2120','314',1017856.35,1018385.22,0.00,0.00,528.87,190393.20,0.00,0.00,0.00),('1','151','755','204722',3979821,'2119','314',1745698.61,1746372.09,0.00,0.00,673.48,242452.80,0.00,0.00,0.00),('1','151','755','204722',3979822,'2120','314',1018385.22,1019005.58,0.00,0.00,620.36,223329.60,0.00,0.00,0.00),('1','151','755','204826',3981474,'2119','314',1746372.09,1747630.67,0.00,0.00,1258.58,453088.80,0.00,0.00,0.00),('1','151','755','204826',3981475,'2120','314',1019005.58,1020491.76,0.00,0.00,1486.18,535024.80,0.00,0.00,0.00),('1','151','755','205042',3985237,'2119','314',1747630.67,1749437.91,0.00,0.00,1807.24,650606.40,0.00,0.00,0.00),('1','151','755','205042',3985238,'2120','314',1020491.76,1021980.57,0.00,0.00,1488.81,535971.60,0.00,0.00,0.00),('1','151','755','205226',3988633,'2119','314',1749437.91,1749861.06,0.00,0.00,423.15,152334.00,0.00,0.00,0.00),('1','151','755','205226',3988634,'2120','314',1021980.57,1022771.32,0.00,0.00,790.75,284670.00,0.00,0.00,0.00),('1','151','755','205360',3990981,'2119','314',1749861.06,1750600.26,0.00,0.00,739.20,266112.00,0.00,0.00,0.00),('1','151','755','205360',3990982,'2120','314',1022771.32,1023080.79,0.00,0.00,309.47,111409.20,0.00,0.00,0.00),('1','151','755','205521',3993782,'2119','314',1750600.26,1751535.98,0.00,0.00,935.72,336859.20,0.00,0.00,0.00),('1','151','755','205521',3993783,'2120','314',1023080.79,1025089.29,0.00,0.00,2008.50,723060.00,0.00,0.00,0.00),('1','151','755','205744',3997869,'2119','314',1751535.98,1753203.13,0.00,0.00,1667.15,600174.00,0.00,0.00,0.00),('1','151','755','205744',3997870,'2120','314',1025089.29,1026483.45,0.00,0.00,1394.16,501897.60,0.00,0.00,0.00),('1','151','755','205933',4001473,'2119','314',1753203.13,1753353.15,0.00,0.00,150.02,56407.52,0.00,0.00,0.00),('1','151','755','205933',4001474,'2120','314',1026483.45,1026721.91,0.00,0.00,238.46,89660.96,0.00,0.00,0.00),('1','151','755','206025',4002897,'2119','314',1753353.15,1754301.12,0.00,0.00,947.97,356436.72,0.00,0.00,0.00),('1','151','755','206025',4002898,'2120','314',1026721.91,1027557.42,0.00,0.00,835.51,314151.76,0.00,0.00,0.00),('1','151','755','206145',4005192,'2119','314',1754301.12,1755572.64,0.00,0.00,1271.52,478091.52,0.00,0.00,0.00),('1','151','755','206145',4005193,'2120','314',1027557.42,1028889.31,0.00,0.00,1331.89,500790.64,0.00,0.00,0.00),('1','151','755','206419',4009745,'2119','314',1755572.64,1755698.06,0.00,0.00,125.42,47157.92,0.00,0.00,0.00),('1','151','755','206419',4009746,'2120','314',1028889.31,1028954.32,0.00,0.00,65.01,24443.76,0.00,0.00,0.00),('1','151','755','206441',4010197,'2119','314',1755698.06,1756849.49,0.00,0.00,1151.43,432937.68,0.00,0.00,0.00),('1','151','755','206441',4010198,'2120','314',1028954.32,1029878.87,0.00,0.00,924.55,347630.80,0.00,0.00,0.00),('1','151','755','206576',4012570,'2119','314',1756849.49,1758083.92,0.00,0.00,1234.43,464145.68,0.00,0.00,0.00),('1','151','755','206576',4012571,'2120','314',1029878.87,1031058.76,0.00,0.00,1179.89,443638.64,0.00,0.00,0.00),('1','151','755','206799',4016536,'2119','314',1758083.92,1759108.00,0.00,0.00,1024.08,385054.08,0.00,0.00,0.00),('1','151','755','206799',4016537,'2120','314',1031058.76,1032447.16,0.00,0.00,1388.40,522038.40,0.00,0.00,0.00),('1','151','755','207096',4021794,'2119','314',1759108.00,1760070.45,0.00,0.00,962.45,361881.20,0.00,0.00,0.00),('1','151','755','207096',4021795,'2120','314',1032447.16,1033728.65,0.00,0.00,1281.49,481840.24,0.00,0.00,0.00),('1','151','755','207245',4024683,'2119','314',1760070.45,1761958.35,0.00,0.00,1887.90,709850.40,0.00,0.00,0.00),('1','151','755','207245',4024684,'2120','314',1033728.65,1035142.94,0.00,0.00,1414.29,531773.04,0.00,0.00,0.00),('1','151','755','207536',4029764,'2119','314',1761958.35,1762680.33,0.00,0.00,721.98,271464.48,0.00,0.00,0.00),('1','151','755','207536',4029765,'2120','314',1035142.94,1035612.51,0.00,0.00,469.57,176558.32,0.00,0.00,0.00),('1','151','755','207590',4030692,'2119','314',1762680.33,1763663.88,0.00,0.00,983.55,369814.80,0.00,0.00,0.00),('1','151','755','207590',4030693,'2120','314',1035612.51,1036495.19,0.00,0.00,882.68,331887.68,0.00,0.00,0.00),('1','151','755','207700',4032556,'2119','314',1763663.88,1765833.97,0.00,0.00,2170.09,833314.56,0.00,0.00,0.00),('1','151','755','207700',4032557,'2120','314',1036495.19,1038336.57,0.00,0.00,1841.38,707089.92,0.00,0.00,0.00),('1','151','755','207911',4036095,'2119','314',1765833.97,1766063.31,0.00,0.00,229.34,88066.56,0.00,0.00,0.00),('1','151','755','207911',4036096,'2120','314',1038336.57,1038498.07,0.00,0.00,161.50,62016.00,0.00,0.00,0.00),('1','151','755','207997',4037577,'2119','314',1766063.31,1767530.38,0.00,0.00,1467.07,563354.88,0.00,0.00,0.00),('1','151','755','207997',4037578,'2120','314',1038498.07,1039620.53,0.00,0.00,1122.46,431024.64,0.00,0.00,0.00),('1','151','755','208109',4039605,'2119','314',1767530.38,1768403.99,0.00,0.00,873.61,335466.24,0.00,0.00,0.00),('1','151','755','208109',4039606,'2120','314',1039620.53,1040657.39,0.00,0.00,1036.86,398154.24,0.00,0.00,0.00),('1','151','755','208260',4042485,'2119','314',1768403.99,1768981.09,0.00,0.00,577.10,221606.40,0.00,0.00,0.00),('1','151','755','208260',4042486,'2120','314',1040657.39,1041069.66,0.00,0.00,412.27,158311.68,0.00,0.00,0.00),('1','151','755','208418',4045068,'2119','314',1768981.09,1770805.65,0.00,0.00,1824.56,700631.04,0.00,0.00,0.00),('1','151','755','208418',4045069,'2120','314',1041069.66,1042748.92,0.00,0.00,1679.26,644835.84,0.00,0.00,0.00),('1','151','755','208564',4047587,'2119','314',1770805.65,1773170.66,0.00,0.00,2365.01,908163.84,0.00,0.00,0.00),('1','151','755','208564',4047588,'2120','314',1042748.92,1044886.68,0.00,0.00,2137.76,820899.84,0.00,0.00,0.00),('1','151','755','208757',4051064,'2119','314',1773170.66,1775653.96,0.00,0.00,2483.30,953587.20,0.00,0.00,0.00),('1','151','755','208757',4051065,'2120','314',1044886.68,1046891.23,0.00,0.00,2004.55,769747.20,0.00,0.00,0.00),('1','151','755','208996',4055115,'2119','314',1775653.96,1776910.44,0.00,0.00,1256.48,502592.00,0.00,0.00,0.00),('1','151','755','208996',4055116,'2120','314',1046891.23,1047872.94,0.00,0.00,981.71,392684.00,0.00,0.00,0.00),('1','151','755','209240',4059274,'2119','314',1776910.44,1778670.56,0.00,0.00,1760.12,704048.00,0.00,0.00,0.00),('1','151','755','209240',4059275,'2120','314',1047872.94,1049373.84,0.00,0.00,1500.90,600360.00,0.00,0.00,0.00),('1','151','755','209457',4063108,'2119','314',1778670.56,1779270.85,0.00,0.00,600.29,240116.00,0.00,0.00,0.00),('1','151','755','209457',4063109,'2120','314',1049373.84,1050012.53,0.00,0.00,638.69,255476.00,0.00,0.00,0.00),('1','151','755','209539',4064630,'2119','314',1779270.85,1780106.89,0.00,0.00,836.04,334416.00,0.00,0.00,0.00),('1','151','755','209539',4064631,'2120','314',1050012.53,1050605.80,0.00,0.00,593.27,237308.00,0.00,0.00,0.00),('1','151','755','209641',4066553,'2119','314',1780106.89,1781716.83,0.00,0.00,1609.94,643976.00,0.00,0.00,0.00),('1','151','755','209641',4066554,'2120','314',1050605.80,1052104.55,0.00,0.00,1498.75,599500.00,0.00,0.00,0.00),('1','151','755','209875',4070602,'2119','314',1781716.83,1783693.16,0.00,0.00,1976.33,830058.60,0.00,0.00,0.00),('1','151','755','209875',4070603,'2120','314',1052104.55,1053763.30,0.00,0.00,1658.75,696675.00,0.00,0.00,0.00),('1','151','755','210142',4075285,'2119','314',1783693.16,1784367.95,0.00,0.00,674.79,283411.80,0.00,0.00,0.00),('1','151','755','210142',4075286,'2120','314',1053763.30,1053961.43,0.00,0.00,198.13,83214.60,0.00,0.00,0.00),('1','151','755','210180',4075947,'2119','314',1784367.95,1785353.83,0.00,0.00,985.88,414069.60,0.00,0.00,0.00),('1','151','755','210180',4075948,'2120','314',1053961.43,1054765.18,0.00,0.00,803.75,337575.00,0.00,0.00,0.00),('1','151','755','210307',4078326,'2119','314',1785353.83,1787210.27,0.00,0.00,1856.44,779704.80,0.00,0.00,0.00),('1','151','755','210307',4078327,'2120','314',1054765.18,1056214.10,0.00,0.00,1448.92,608546.40,0.00,0.00,0.00),('1','151','755','210730',4085963,'2119','314',1787210.27,1789216.11,0.00,0.00,2005.84,842452.80,0.00,0.00,0.00),('1','151','755','210730',4085964,'2120','314',1056214.10,1057394.40,0.00,0.00,1180.30,495726.00,0.00,0.00,0.00),('1','151','755','210984',4090012,'2119','314',1789216.11,1789532.18,0.00,0.00,316.07,132749.40,0.00,0.00,0.00),('1','151','755','210984',4090013,'2120','314',1057394.40,1057721.08,0.00,0.00,326.68,137205.60,0.00,0.00,0.00),('1','151','755','211256',4095182,'2119','314',1789532.18,1791470.74,0.00,0.00,1938.56,821949.44,0.00,0.00,0.00),('1','151','755','211256',4095183,'2120','314',1057721.08,1059195.43,0.00,0.00,1474.35,625124.40,0.00,0.00,0.00),('1','151','755','211449',4098523,'2119','314',1791470.74,1792056.69,0.00,0.00,585.95,248442.80,0.00,0.00,0.00),('1','151','755','211449',4098524,'2120','314',1059195.43,1059755.69,0.00,0.00,560.26,237550.24,0.00,0.00,0.00),('1','151','755','211501',4099398,'2119','314',1792056.69,1793541.25,0.00,0.00,1484.56,629453.44,0.00,0.00,0.00),('1','151','755','211501',4099399,'2120','314',1059755.69,1060816.00,0.00,0.00,1060.31,449571.44,0.00,0.00,0.00),('1','151','755','211611',4101373,'2119','314',1793541.25,1794887.25,0.00,0.00,1346.00,570704.00,0.00,0.00,0.00),('1','151','755','211611',4101374,'2120','314',1060816.00,1061664.13,0.00,0.00,848.13,359607.12,0.00,0.00,0.00),('1','151','755','211690',4102601,'2119','314',1794887.25,1795598.81,0.00,0.00,711.56,301701.44,0.00,0.00,0.00),('1','151','755','211690',4102602,'2120','314',1061664.13,1062176.42,0.00,0.00,512.29,217210.96,0.00,0.00,0.00),('1','151','755','211781',4104123,'2119','314',1795598.81,1797688.86,0.00,0.00,2090.05,886181.20,0.00,0.00,0.00),('1','151','755','211781',4104124,'2120','314',1062176.42,1063107.66,0.00,0.00,931.24,394845.76,0.00,0.00,0.00),('1','151','755','212114',4110144,'2119','314',1797688.86,1799404.92,0.00,0.00,1716.06,727609.44,0.00,0.00,0.00),('1','151','755','212114',4110145,'2120','314',1063107.66,1064639.78,0.00,0.00,1532.12,649618.88,0.00,0.00,0.00),('1','151','755','212233',4112158,'2119','314',1799404.92,1800047.13,0.00,0.00,642.21,272297.04,0.00,0.00,0.00),('1','151','755','212233',4112159,'2120','314',1064639.78,1065354.75,0.00,0.00,714.97,303147.28,0.00,0.00,0.00),('1','151','755','212358',4114434,'2119','314',1800047.13,1800662.38,0.00,0.00,615.25,260866.00,0.00,0.00,0.00),('1','151','755','212358',4114435,'2120','314',1065354.75,1065887.66,0.00,0.00,532.91,225953.84,0.00,0.00,0.00),('1','151','755','212455',4116294,'2119','314',1800662.38,1802546.83,0.00,0.00,1884.45,799006.80,0.00,0.00,0.00),('1','151','755','212455',4116295,'2120','314',1065887.66,1067414.55,0.00,0.00,1526.89,647401.36,0.00,0.00,0.00),('1','151','755','212665',4120058,'2119','314',1802546.83,1803571.41,0.00,0.00,1024.58,434421.92,0.00,0.00,0.00),('1','151','755','212665',4120059,'2120','314',1067414.55,1068387.97,0.00,0.00,973.42,412730.08,0.00,0.00,0.00),('1','151','755','212799',4122413,'2119','314',1803571.41,1803993.40,0.00,0.00,421.99,178923.76,0.00,0.00,0.00),('1','151','755','212799',4122414,'2120','314',1068387.97,1068668.30,0.00,0.00,280.33,118859.92,0.00,0.00,0.00),('1','151','755','212870',4123622,'2119','314',1803993.40,1805868.58,0.00,0.00,1875.18,795076.32,0.00,0.00,0.00),('1','151','755','212870',4123623,'2120','314',1068668.30,1070468.49,0.00,0.00,1800.19,763280.56,0.00,0.00,0.00),('1','151','755','213272',4130375,'2119','314',1805868.58,1805896.71,0.00,0.00,28.13,11927.12,0.00,0.00,0.00),('1','151','755','213272',4130376,'2120','314',1070468.49,1070598.67,0.00,0.00,130.18,55196.32,0.00,0.00,0.00),('1','151','755','213286',4130562,'2119','314',1805896.71,1806644.44,0.00,0.00,747.73,317037.52,0.00,0.00,0.00),('1','151','755','213286',4130563,'2120','314',1070598.67,1071304.08,0.00,0.00,705.41,299093.84,0.00,0.00,0.00),('1','151','755','213392',4132380,'2119','314',1806644.44,1808270.83,0.00,0.00,1626.39,689589.36,0.00,0.00,0.00),('1','151','755','213392',4132381,'2120','314',1071304.08,1072733.55,0.00,0.00,1429.47,575866.55,0.00,0.00,0.00),('1','151','755','213642',4136557,'2119','314',1808270.83,1810507.84,0.00,0.00,2237.01,948492.24,0.00,0.00,0.00),('1','151','755','213642',4136558,'2120','314',1072733.55,1074796.49,0.00,0.00,2062.94,874686.56,0.00,0.00,0.00),('1','151','755','214016',4142729,'2119','314',1810507.84,1811369.88,0.00,0.00,862.04,365504.96,0.00,0.00,0.00),('1','151','755','214016',4142730,'2120','314',1074796.49,1075508.37,0.00,0.00,711.88,301837.12,0.00,0.00,0.00),('1','151','755','214121',4144454,'2119','314',1811369.88,1812948.36,0.00,0.00,1578.48,669275.52,0.00,0.00,0.00),('1','151','755','214121',4144455,'2120','314',1075508.37,1077023.21,0.00,0.00,1514.84,642292.16,0.00,0.00,0.00),('1','151','755','214338',4148352,'2119','314',1812948.36,1814765.25,0.00,0.00,1816.89,770361.36,0.00,0.00,0.00),('1','151','755','214338',4148353,'2120','314',1077023.21,1078780.70,0.00,0.00,1757.49,745175.76,0.00,0.00,0.00),('1','151','755','214611',4152887,'2119','314',1814765.25,1815304.29,0.00,0.00,539.04,228552.96,0.00,0.00,0.00),('1','151','755','214611',4152888,'2120','314',1078780.70,1079219.09,0.00,0.00,438.39,185877.36,0.00,0.00,0.00),('1','151','755','214629',4153168,'2119','314',1815304.29,1815560.44,0.00,0.00,256.15,108607.60,0.00,0.00,0.00),('1','151','755','214629',4153169,'2120','314',1079219.09,1079450.76,0.00,0.00,231.67,98228.08,0.00,0.00,0.00),('1','151','755','214961',4159031,'2119','314',1815560.44,1817627.17,0.00,0.00,2066.73,876293.52,0.00,0.00,0.00),('1','151','755','214961',4159032,'2120','314',1079450.76,1081268.64,0.00,0.00,1817.88,770781.12,0.00,0.00,0.00),('1','151','755','215038',4160102,'2119','314',1817627.17,1819214.40,0.00,0.00,1587.23,672985.52,0.00,0.00,0.00),('1','151','755','215038',4160103,'2120','314',1081268.64,1082713.77,0.00,0.00,1445.13,612735.12,0.00,0.00,0.00),('1','151','755','215316',4165003,'2119','314',1819214.40,1820063.22,0.00,0.00,848.82,359899.68,0.00,0.00,0.00),('1','151','755','215316',4165004,'2120','314',1082713.77,1083395.56,0.00,0.00,681.79,289078.96,0.00,0.00,0.00),('1','151','755','215402',4166480,'2119','314',1820063.22,1820208.43,0.00,0.00,145.21,61569.04,0.00,0.00,0.00),('1','151','755','215402',4166481,'2120','314',1083395.56,1083475.62,0.00,0.00,80.06,33945.44,0.00,0.00,0.00),('1','151','755','215464',4167303,'2119','314',1820208.43,1821397.33,0.00,0.00,1188.90,523116.00,0.00,0.00,0.00),('1','151','755','215464',4167304,'2120','314',1083475.62,1084615.56,0.00,0.00,1139.94,501573.60,0.00,0.00,0.00),('1','151','755','215679',4171129,'2119','314',1821397.33,1822832.73,0.00,0.00,1435.40,631576.00,0.00,0.00,0.00),('1','151','755','215679',4171130,'2120','314',1084615.56,1086935.85,0.00,0.00,2320.29,1020927.60,0.00,0.00,0.00),('1','151','755','215917',4175206,'2119','314',1822832.73,1823182.36,0.00,0.00,349.63,153837.20,0.00,0.00,0.00),('1','151','755','215917',4175207,'2120','314',1086935.85,1087404.02,0.00,0.00,468.17,205994.80,0.00,0.00,0.00),('1','151','755','215988',4176367,'2119','314',1823182.36,1824115.20,0.00,0.00,932.84,410449.60,0.00,0.00,0.00),('1','151','755','215988',4176368,'2120','314',1087404.02,1088298.21,0.00,0.00,894.19,393443.60,0.00,0.00,0.00),('1','151','755','216128',4178747,'2119','314',1824115.20,1825702.80,0.00,0.00,1587.60,676774.18,0.00,0.00,0.00),('1','151','755','216128',4178748,'2120','314',1088298.21,1089444.58,0.00,0.00,1146.37,504402.80,0.00,0.00,0.00),('1','151','755','216322',4182270,'2119','314',1825702.80,1827085.27,0.00,0.00,1382.47,608286.80,0.00,0.00,0.00),('1','151','755','216322',4182271,'2120','314',1089444.58,1090970.03,0.00,0.00,1525.45,671198.00,0.00,0.00,0.00),('1','151','755','216555',4186307,'2119','314',1827085.27,1827874.28,0.00,0.00,789.01,347164.40,0.00,0.00,0.00),('1','151','755','216555',4186308,'2120','314',1090970.03,1091833.10,0.00,0.00,863.07,379750.80,0.00,0.00,0.00),('1','151','755','216756',4190017,'2119','314',1827874.28,1828364.98,0.00,0.00,490.70,215908.00,0.00,0.00,0.00),('1','151','755','216756',4190018,'2120','314',1091833.10,1092162.33,0.00,0.00,329.23,144861.20,0.00,0.00,0.00),('1','151','755','216905',4192509,'2119','314',1828364.98,1830126.98,0.00,0.00,1762.00,775280.00,0.00,0.00,0.00),('1','151','755','216905',4192510,'2120','314',1092162.33,1093520.30,0.00,0.00,1357.97,597506.80,0.00,0.00,0.00),('1','151','755','217100',4195710,'2119','314',1830126.98,1830474.44,0.00,0.00,347.46,164001.12,0.00,0.00,0.00),('1','151','755','217100',4195711,'2120','314',1093520.30,1093723.15,0.00,0.00,202.85,95745.20,0.00,0.00,0.00),('1','151','755','217128',4196312,'2119','314',1830474.44,1831285.82,0.00,0.00,811.38,382971.36,0.00,0.00,0.00),('1','151','755','217128',4196313,'2120','314',1093723.15,1094433.56,0.00,0.00,710.41,335313.52,0.00,0.00,0.00),('1','151','755','217306',4199731,'2119','314',1831285.82,1831345.11,0.00,0.00,59.29,27984.88,0.00,0.00,0.00),('1','151','755','217306',4199732,'2120','314',1094433.56,1094475.27,0.00,0.00,41.71,19687.12,0.00,0.00,0.00),('1','151','755','217313',4199848,'2119','314',1831345.11,1832967.65,0.00,0.00,1622.54,765838.88,0.00,0.00,0.00),('1','151','755','217313',4199849,'2120','314',1094475.27,1095906.58,0.00,0.00,1431.31,675578.32,0.00,0.00,0.00),('1','151','755','217527',4203524,'2119','314',1832967.65,1833760.07,0.00,0.00,792.42,374022.24,0.00,0.00,0.00),('1','151','755','217527',4203525,'2120','314',1095906.58,1096620.31,0.00,0.00,713.73,336880.56,0.00,0.00,0.00),('1','151','755','217587',4204545,'2119','314',1833760.07,1834367.96,0.00,0.00,607.89,286924.08,0.00,0.00,0.00),('1','151','755','217587',4204546,'2120','314',1096620.31,1097096.09,0.00,0.00,475.78,224568.16,0.00,0.00,0.00),('1','151','755','217736',4207057,'2119','314',1834367.96,1836082.57,0.00,0.00,1714.61,809295.92,0.00,0.00,0.00),('1','151','755','217736',4207058,'2120','314',1097096.09,1098392.59,0.00,0.00,1296.50,611948.00,0.00,0.00,0.00),('1','151','755','217985',4211767,'2119','314',1836082.57,1837509.02,0.00,0.00,1426.45,673284.40,0.00,0.00,0.00),('1','151','755','217985',4211768,'2120','314',1098392.59,1099831.94,0.00,0.00,1439.35,679373.20,0.00,0.00,0.00),('1','151','755','218224',4215835,'2119','314',1837509.02,1837873.49,0.00,0.00,364.47,172029.84,0.00,0.00,0.00),('1','151','755','218224',4215836,'2120','314',1099831.94,1100608.27,0.00,0.00,776.33,366427.76,0.00,0.00,0.00),('1','151','755','218332',4217665,'2119','314',1837873.49,1838453.50,0.00,0.00,580.01,273764.72,0.00,0.00,0.00),('1','151','755','218332',4217666,'2120','314',1100608.27,1101149.54,0.00,0.00,541.27,255479.44,0.00,0.00,0.00),('1','151','755','218479',4220255,'2119','314',1838453.50,1839996.36,0.00,0.00,1542.86,728229.92,0.00,0.00,0.00),('1','151','755','218479',4220256,'2120','314',1101149.54,1102814.54,0.00,0.00,1665.00,785880.00,0.00,0.00,0.00),('1','151','755','218702',4224235,'2119','314',1839996.36,1841453.48,0.00,0.00,1457.12,687760.64,0.00,0.00,0.00),('1','151','755','218702',4224236,'2120','314',1102814.54,1104063.87,0.00,0.00,1249.33,589683.76,0.00,0.00,0.00),('1','151','755','218912',4228018,'2119','314',1841453.48,1842507.12,0.00,0.00,1053.64,497318.08,0.00,0.00,0.00),('1','151','755','218912',4228019,'2120','314',1104063.87,1104815.68,0.00,0.00,751.81,354854.32,0.00,0.00,0.00),('1','151','755','219084',4231056,'2119','314',1842507.12,1842730.12,0.00,0.00,223.00,105256.00,0.00,0.00,0.00),('1','151','755','219084',4231057,'2120','314',1104815.68,1104985.85,0.00,0.00,170.17,80320.24,0.00,0.00,0.00),('1','151','755','219115',4231533,'2119','314',1842730.12,1844308.27,0.00,0.00,1578.15,725949.00,0.00,0.00,0.00),('1','151','755','219115',4231534,'2120','314',1104985.85,1106282.11,0.00,0.00,1296.26,596279.60,0.00,0.00,0.00),('1','151','755','219333',4235329,'2119','314',1844308.27,1846236.11,0.00,0.00,1927.84,886806.40,0.00,0.00,0.00),('1','151','755','219333',4235330,'2120','314',1106282.11,1108025.82,0.00,0.00,1743.71,802106.60,0.00,0.00,0.00),('1','151','755','219604',4239873,'2119','314',1846236.11,1846317.06,0.00,0.00,80.95,37237.00,0.00,0.00,0.00),('1','151','755','219604',4239874,'2120','314',1108025.82,1108185.26,0.00,0.00,159.44,73342.40,0.00,0.00,0.00),('1','151','755','219666',4240916,'2119','314',1846317.06,1847548.74,0.00,0.00,1231.68,566572.80,0.00,0.00,0.00),('1','151','755','219666',4240917,'2120','314',1108185.26,1109067.02,0.00,0.00,881.76,405609.60,0.00,0.00,0.00),('1','151','755','219805',4243695,'2119','314',1847548.74,1848958.16,0.00,0.00,1409.42,648333.20,0.00,0.00,0.00),('1','151','755','219805',4243696,'2120','314',1109067.02,1110030.20,0.00,0.00,963.18,443062.80,0.00,0.00,0.00),('1','151','755','219979',4246837,'2119','314',1848958.16,1849192.94,0.00,0.00,234.78,107998.80,0.00,0.00,0.00),('1','151','755','219979',4246838,'2120','314',1110030.20,1110297.96,0.00,0.00,267.76,123169.60,0.00,0.00,0.00),('1','151','755','220049',4247945,'2119','314',1849192.94,1850646.93,0.00,0.00,1453.99,668835.40,0.00,0.00,0.00),('1','151','755','220049',4247946,'2120','314',1110297.96,1111947.35,0.00,0.00,1649.39,758719.40,0.00,0.00,0.00),('1','151','755','220226',4251251,'2119','314',1850646.93,1851631.55,0.00,0.00,984.62,452925.20,0.00,0.00,0.00),('1','151','755','220226',4251252,'2120','314',1111947.35,1113025.02,0.00,0.00,1077.67,495728.20,0.00,0.00,0.00),('1','151','755','220514',4256153,'2119','314',1851631.55,1852566.16,0.00,0.00,934.61,429920.60,0.00,0.00,0.00),('1','151','755','220514',4256154,'2120','314',1113025.02,1114597.92,0.00,0.00,1572.90,723534.00,0.00,0.00,0.00),('1','151','755','220691',4259337,'2119','314',1852566.16,1853433.81,0.00,0.00,867.65,399119.00,0.00,0.00,0.00),('1','151','755','220691',4259338,'2120','314',1114597.92,1116040.59,0.00,0.00,1442.67,663628.20,0.00,0.00,0.00),('1','151','755','221000',4264761,'2119','314',1853433.81,1855033.50,0.00,0.00,1599.69,735857.40,0.00,0.00,0.00),('1','151','755','221000',4264762,'2120','314',1116040.59,1117895.41,0.00,0.00,1854.82,853217.20,0.00,0.00,0.00),('1','151','755','221142',4267373,'2119','314',1855033.50,1855512.33,0.00,0.00,478.83,220261.80,0.00,0.00,0.00),('1','151','755','221142',4267374,'2120','314',1117895.41,1118575.20,0.00,0.00,679.79,312703.40,0.00,0.00,0.00),('1','151','755','221273',4269529,'2119','314',1855512.33,1856248.05,0.00,0.00,735.72,338431.20,0.00,0.00,0.00),('1','151','755','221273',4269530,'2120','314',1118575.20,1119298.03,0.00,0.00,722.83,332501.80,0.00,0.00,0.00),('1','151','755','221389',4271793,'2119','314',1856248.05,1857770.05,0.00,0.00,1522.00,700120.00,0.00,0.00,0.00),('1','151','755','221389',4271794,'2120','314',1119298.03,1120904.04,0.00,0.00,1606.01,738764.60,0.00,0.00,0.00),('1','151','755','221619',4276090,'2119','314',1857770.05,1860115.76,0.00,0.00,2345.71,1079026.60,0.00,0.00,0.00),('1','151','755','221619',4276091,'2120','314',1120904.04,1122693.89,0.00,0.00,1789.85,823331.00,0.00,0.00,0.00),('1','151','755','221835',4279839,'2119','314',1860115.76,1862178.80,0.00,0.00,2063.04,948998.40,0.00,0.00,0.00),('1','151','755','221835',4279840,'2120','314',1122693.89,1124555.43,0.00,0.00,1861.54,856308.40,0.00,0.00,0.00),('1','151','755','222046',4283899,'2119','314',1862178.80,1863652.92,0.00,0.00,1474.12,678095.20,0.00,0.00,0.00),('1','151','755','222046',4283900,'2120','314',1124555.43,1125872.33,0.00,0.00,1316.90,605774.00,0.00,0.00,0.00),('1','151','755','222262',4287452,'2119','314',1863652.92,1864844.38,0.00,0.00,1191.46,548071.60,0.00,0.00,0.00),('1','151','755','222262',4287453,'2120','314',1125872.33,1127560.10,0.00,0.00,1687.77,776374.20,0.00,0.00,0.00),('1','151','755','222482',4291225,'2119','314',1864844.38,1865453.57,0.00,0.00,609.19,280227.40,0.00,0.00,0.00),('1','151','755','222482',4291226,'2120','314',1127560.10,1128409.44,0.00,0.00,849.34,390696.40,0.00,0.00,0.00),('1','151','755','222659',4294370,'2119','314',1865453.57,1866169.38,0.00,0.00,715.81,329272.60,0.00,0.00,0.00),('1','151','755','222659',4294371,'2120','314',1128409.44,1129057.29,0.00,0.00,647.85,298011.00,0.00,0.00,0.00),('1','151','755','222768',4296282,'2119','314',1866169.38,1867511.41,0.00,0.00,1342.03,617333.80,0.00,0.00,0.00),('1','151','755','222768',4296283,'2120','314',1129057.29,1130504.69,0.00,0.00,1447.40,665804.00,0.00,0.00,0.00),('1','151','755','222937',4299655,'2119','314',1867511.41,1869184.40,0.00,0.00,1672.99,769575.40,0.00,0.00,0.00),('1','151','755','222937',4299656,'2120','314',1130504.69,1132048.33,0.00,0.00,1543.64,710074.40,0.00,0.00,0.00),('1','151','755','223180',4303775,'2119','314',1869184.40,1869306.79,0.00,0.00,122.39,56812.00,0.00,0.00,0.00),('1','151','755','223180',4303776,'2120','314',1132048.33,1132194.96,0.00,0.00,146.63,67899.80,0.00,0.00,0.00),('1','151','755','223217',4304232,'2119','314',1869306.79,1869806.03,0.00,0.00,499.24,239635.20,0.00,0.00,0.00),('1','151','755','223217',4304233,'2120','314',1132194.96,1132780.07,0.00,0.00,585.11,280852.80,0.00,0.00,0.00),('1','151','755','223321',4305900,'2119','314',1869806.03,1870473.81,0.00,0.00,667.78,320534.40,0.00,0.00,0.00),('1','151','755','223321',4305901,'2120','314',1132780.07,1133270.34,0.00,0.00,490.27,235329.60,0.00,0.00,0.00),('1','151','755','223404',4307804,'2119','314',1870473.81,1871689.77,0.00,0.00,1215.96,583660.80,0.00,0.00,0.00),('1','151','755','223404',4307805,'2120','314',1133270.34,1134622.29,0.00,0.00,1351.95,648936.00,0.00,0.00,0.00),('1','151','755','223632',4311957,'2119','314',1871689.77,1873125.28,0.00,0.00,1435.51,689044.80,0.00,0.00,0.00),('1','151','755','223632',4311958,'2120','314',1134622.29,1136078.16,0.00,0.00,1455.87,698817.60,0.00,0.00,0.00),('1','151','755','223884',4316474,'2119','314',1873125.28,1874803.84,0.00,0.00,1678.56,805708.80,0.00,0.00,0.00),('1','151','755','223884',4316475,'2120','314',1136078.16,1137237.95,0.00,0.00,1159.79,556699.20,0.00,0.00,0.00),('1','151','755','224071',4319852,'2119','314',1874803.84,1875991.24,0.00,0.00,1187.40,569952.00,0.00,0.00,0.00),('1','151','755','224071',4319853,'2120','314',1137237.95,1138502.77,0.00,0.00,1264.82,607113.60,0.00,0.00,0.00),('1','151','755','224305',4324073,'2119','314',1875991.24,1877709.53,0.00,0.00,1718.29,905601.96,0.00,0.00,0.00),('1','151','755','224305',4324074,'2120','314',1138502.77,1139908.78,0.00,0.00,1406.01,759245.40,0.00,0.00,0.00),('1','151','755','224552',4328152,'2119','314',1877709.53,1878424.85,0.00,0.00,715.32,386272.80,0.00,0.00,0.00),('1','151','755','224552',4328153,'2120','314',1139908.78,1140573.16,0.00,0.00,664.38,358765.20,0.00,0.00,0.00),('1','151','755','224693',4330624,'2119','314',1878424.85,1878942.32,0.00,0.00,517.47,279433.80,0.00,0.00,0.00),('1','151','755','224693',4330625,'2120','314',1140573.16,1140898.64,0.00,0.00,325.48,175759.20,0.00,0.00,0.00),('1','151','755','224775',4332219,'2119','314',1878942.32,1880191.52,0.00,0.00,1249.20,674568.00,0.00,0.00,0.00),('1','151','755','224775',4332220,'2120','314',1140898.64,1142313.44,0.00,0.00,1414.80,763992.00,0.00,0.00,0.00),('1','151','755','225006',4336475,'2119','314',1880191.52,1880578.64,0.00,0.00,387.12,209044.80,0.00,0.00,0.00),('1','151','755','225006',4336476,'2120','314',1142313.44,1142829.18,0.00,0.00,515.74,278499.60,0.00,0.00,0.00),('1','151','755','225193',4339745,'2119','314',1880578.64,1881379.13,0.00,0.00,800.49,432264.60,0.00,0.00,0.00),('1','151','755','225193',4339746,'2120','314',1142829.18,1143636.59,0.00,0.00,807.41,436001.40,0.00,0.00,0.00),('1','151','755','225250',4340908,'2119','314',1881379.13,1882819.42,0.00,0.00,1440.29,777756.60,0.00,0.00,0.00),('1','151','755','225250',4340909,'2120','314',1143636.59,1145131.78,0.00,0.00,1495.19,807402.60,0.00,0.00,0.00),('1','151','755','225503',4345265,'2119','314',1882819.42,1884359.10,0.00,0.00,1539.68,831427.20,0.00,0.00,0.00),('1','151','755','225503',4345266,'2120','314',1145131.78,1146453.88,0.00,0.00,1322.10,713934.00,0.00,0.00,0.00),('1','151','755','225694',4348709,'2119','314',1884359.10,1885142.96,0.00,0.00,783.86,423284.40,0.00,0.00,0.00),('1','151','755','225694',4348710,'2120','314',1146453.88,1147347.09,0.00,0.00,893.21,482333.40,0.00,0.00,0.00),('1','151','755','225910',4352529,'2119','314',1885142.96,1885278.01,0.00,0.00,135.05,72927.00,0.00,0.00,0.00),('1','151','755','225910',4352530,'2120','314',1147347.09,1147487.48,0.00,0.00,140.39,75810.60,0.00,0.00,0.00),('1','151','755','225968',4353340,'2119','314',1885278.01,1886818.53,0.00,0.00,1540.52,831880.80,0.00,0.00,0.00),('1','151','755','225968',4353341,'2120','314',1147487.48,1149035.97,0.00,0.00,1548.49,836184.60,0.00,0.00,0.00),('1','151','755','226278',4358950,'2119','314',1886818.53,1888305.77,0.00,0.00,1487.24,803109.60,0.00,0.00,0.00),('1','151','755','226278',4358951,'2120','314',1149035.97,1150661.71,0.00,0.00,1625.74,877899.60,0.00,0.00,0.00),('1','151','755','226492',4362710,'2119','314',1888305.77,1888465.28,0.00,0.00,159.51,86135.40,0.00,0.00,0.00),('1','151','755','226492',4362711,'2120','314',1150661.71,1150806.28,0.00,0.00,144.57,78067.80,0.00,0.00,0.00),('1','151','755','226639',4365603,'2119','314',1888465.28,1888865.94,0.00,0.00,400.66,216356.40,0.00,0.00,0.00),('1','151','755','226639',4365604,'2120','314',1150806.28,1151148.41,0.00,0.00,342.13,184750.20,0.00,0.00,0.00),('1','151','755','226759',4367615,'2119','314',1888865.94,1890007.24,0.00,0.00,1141.30,616302.00,0.00,0.00,0.00),('1','151','755','226759',4367616,'2120','314',1151148.41,1152677.77,0.00,0.00,1529.36,825854.40,0.00,0.00,0.00),('1','151','755','227030',4372320,'2119','314',1890007.24,1891078.86,0.00,0.00,1071.62,578674.80,0.00,0.00,0.00),('1','151','755','227030',4372321,'2120','314',1152677.77,1153846.46,0.00,0.00,1168.69,631092.60,0.00,0.00,0.00),('1','151','755','227176',4375168,'2119','314',1891078.86,1891193.88,0.00,0.00,115.02,62110.80,0.00,0.00,0.00),('1','151','755','227176',4375169,'2120','314',1153846.46,1154217.13,0.00,0.00,370.67,200161.80,0.00,0.00,0.00),('1','151','755','227791',4386007,'2119','314',1891193.88,1891257.23,0.00,0.00,63.35,34209.00,0.00,0.00,0.00),('1','151','755','227791',4386008,'2120','314',1154217.13,1154366.49,0.00,0.00,149.36,80654.40,0.00,0.00,0.00),('1','151','755','228107',4391919,'2119','314',1891257.23,1891489.45,0.00,0.00,232.22,125398.80,0.00,0.00,0.00),('1','151','755','228107',4391920,'2120','314',1154366.49,1154647.52,0.00,0.00,281.03,151756.20,0.00,0.00,0.00),('1','151','755','228175',4393201,'2119','314',1891489.45,1891547.29,0.00,0.00,57.84,31233.60,0.00,0.00,0.00),('1','151','755','228175',4393202,'2120','314',1154647.52,1154744.75,0.00,0.00,97.23,52504.20,0.00,0.00,0.00),('1','151','755','228494',4399310,'2119','314',1891547.29,1892124.59,0.00,0.00,577.30,311742.00,0.00,0.00,0.00),('1','151','755','228494',4399311,'2120','314',1154744.75,1155405.96,0.00,0.00,661.21,357053.40,0.00,0.00,0.00),('1','151','755','229167',4411961,'2119','314',1892124.59,1894261.35,0.00,0.00,2136.76,1153850.40,0.00,0.00,0.00),('1','151','755','229167',4411962,'2120','314',1155405.96,1157452.11,0.00,0.00,2046.15,1104921.00,0.00,0.00,0.00),('1','151','755','229408',4416265,'2119','314',1894261.35,1896055.59,0.00,0.00,1794.24,1007618.84,0.00,0.00,0.00),('1','151','755','229408',4416266,'2120','314',1157452.11,1159266.08,0.00,0.00,1813.97,1023587.36,0.00,0.00,0.00),('1','151','755','229652',4421094,'2119','314',1896055.59,1897399.27,0.00,0.00,1343.68,784709.12,0.00,0.00,0.00),('1','151','755','229652',4421095,'2120','314',1159266.08,1161103.11,0.00,0.00,1837.03,1072825.52,0.00,0.00,0.00),('1','151','755','229879',4425560,'2119','314',1897399.27,1898697.83,0.00,0.00,1298.56,758359.04,0.00,0.00,0.00),('1','151','755','229879',4425561,'2120','314',1161103.11,1162767.39,0.00,0.00,1664.28,971939.52,0.00,0.00,0.00),('1','151','755','230121',4429761,'2119','314',1898697.83,1899627.57,0.00,0.00,929.74,542968.16,0.00,0.00,0.00),('1','151','755','230121',4429762,'2120','314',1162767.39,1163913.09,0.00,0.00,1145.70,669088.80,0.00,0.00,0.00),('1','151','755','230506',4437367,'2119','314',1899627.57,1899627.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','230506',4437368,'2120','314',1163913.09,1163937.75,0.00,0.00,24.66,14401.44,0.00,0.00,0.00),('1','151','755','230507',4437369,'2119','314',1899627.57,1900976.65,0.00,0.00,1349.08,787862.72,0.00,0.00,0.00),('1','151','755','230507',4437370,'2120','314',1163937.75,1165737.01,0.00,0.00,1799.26,1050767.84,0.00,0.00,0.00),('1','151','755','230782',4442107,'2119','314',1900976.65,1902176.15,0.00,0.00,1199.50,700508.00,0.00,0.00,0.00),('1','151','755','230782',4442108,'2120','314',1165737.01,1167527.40,0.00,0.00,1790.39,1045587.76,0.00,0.00,0.00),('1','151','755','231087',4447270,'2119','314',1902176.15,1903103.58,0.00,0.00,927.43,541619.12,0.00,0.00,0.00),('1','151','755','231087',4447271,'2120','314',1167527.40,1169042.89,0.00,0.00,1515.49,885046.16,0.00,0.00,0.00),('1','151','755','231361',4451732,'2119','314',1903103.58,1903216.53,0.00,0.00,112.95,65962.80,0.00,0.00,0.00),('1','151','755','231361',4451733,'2120','314',1169042.89,1169179.13,0.00,0.00,136.24,79564.16,0.00,0.00,0.00),('1','151','755','231454',4453098,'2119','314',1903216.53,1903810.58,0.00,0.00,594.05,346925.20,0.00,0.00,0.00),('1','151','755','231454',4453099,'2120','314',1169179.13,1170403.14,0.00,0.00,1224.01,714821.84,0.00,0.00,0.00),('1','151','755','231622',4456332,'2119','314',1903810.58,1904815.36,0.00,0.00,1004.78,586791.52,0.00,0.00,0.00),('1','151','755','231622',4456333,'2120','314',1170403.14,1171910.75,0.00,0.00,1507.61,880444.24,0.00,0.00,0.00),('1','151','755','231897',4461135,'2119','314',1904815.36,1905833.47,0.00,0.00,1018.11,594576.24,0.00,0.00,0.00),('1','151','755','231897',4461136,'2120','314',1171910.75,1173498.21,0.00,0.00,1587.46,927076.64,0.00,0.00,0.00),('1','151','755','232122',4465150,'2119','314',1905833.47,1906545.49,0.00,0.00,712.02,415819.68,0.00,0.00,0.00),('1','151','755','232122',4465151,'2120','314',1173498.21,1174735.59,0.00,0.00,1237.38,722629.92,0.00,0.00,0.00),('1','151','755','232327',4468884,'2119','314',1906545.49,1907689.33,0.00,0.00,1143.84,668002.56,0.00,0.00,0.00),('1','151','755','232327',4468885,'2120','314',1174735.59,1176448.08,0.00,0.00,1712.49,1000094.16,0.00,0.00,0.00),('1','151','755','232593',4473635,'2119','314',1907689.33,1908247.46,0.00,0.00,558.13,325947.92,0.00,0.00,0.00),('1','151','755','232593',4473636,'2120','314',1176448.08,1177557.50,0.00,0.00,1109.42,647901.28,0.00,0.00,0.00),('1','151','755','232753',4476686,'2119','314',1908247.46,1908496.31,0.00,0.00,248.85,145328.40,0.00,0.00,0.00),('1','151','755','232753',4476687,'2120','314',1177557.50,1177758.98,0.00,0.00,201.48,117664.32,0.00,0.00,0.00),('1','151','755','232849',4478246,'2119','314',1908496.31,1910005.78,0.00,0.00,1509.47,881530.48,0.00,0.00,0.00),('1','151','755','232849',4478247,'2120','314',1177758.98,1179570.66,0.00,0.00,1811.68,1058021.12,0.00,0.00,0.00),('1','151','755','233109',4482982,'2119','314',1910005.78,1911115.27,0.00,0.00,1109.49,647942.16,0.00,0.00,0.00),('1','151','755','233109',4482983,'2120','314',1179570.66,1180943.25,0.00,0.00,1372.59,801592.56,0.00,0.00,0.00),('1','151','755','233366',4487642,'2119','314',1911115.27,1912463.74,0.00,0.00,1348.47,787506.48,0.00,0.00,0.00),('1','151','755','233366',4487643,'2120','314',1180943.25,1182357.74,0.00,0.00,1414.49,826062.16,0.00,0.00,0.00),('1','151','755','233583',4491837,'2119','314',1912463.74,1913759.45,0.00,0.00,1295.71,756694.64,0.00,0.00,0.00),('1','151','755','233583',4491838,'2120','314',1182357.74,1183967.08,0.00,0.00,1609.34,939854.56,0.00,0.00,0.00),('1','151','755','233834',4496114,'2119','314',1913759.45,1914526.07,0.00,0.00,766.62,478370.88,0.00,0.00,0.00),('1','151','755','233834',4496115,'2120','314',1183967.08,1184797.41,0.00,0.00,830.33,518125.92,0.00,0.00,0.00),('1','151','755','233952',4498260,'2119','314',1914526.07,1915795.45,0.00,0.00,1269.38,792093.12,0.00,0.00,0.00),('1','151','755','233952',4498261,'2120','314',1184797.41,1186524.00,0.00,0.00,1726.59,1077392.16,0.00,0.00,0.00),('1','151','755','234301',4504600,'2119','314',1915795.45,1916501.02,0.00,0.00,705.57,440275.68,0.00,0.00,0.00),('1','151','755','234301',4504601,'2120','314',1186524.00,1187287.34,0.00,0.00,763.34,476324.16,0.00,0.00,0.00),('1','151','755','234505',4508179,'2119','314',1916501.02,1916877.88,0.00,0.00,376.86,235160.64,0.00,0.00,0.00),('1','151','755','234505',4508180,'2120','314',1187287.34,1187858.41,0.00,0.00,571.07,356347.68,0.00,0.00,0.00),('1','151','755','234575',4509323,'2119','314',1916877.88,1917986.80,0.00,0.00,1108.92,691966.08,0.00,0.00,0.00),('1','151','755','234575',4509324,'2120','314',1187858.41,1189401.44,0.00,0.00,1543.03,962850.72,0.00,0.00,0.00),('1','151','755','234820',4513730,'2119','314',1917986.80,1919106.40,0.00,0.00,1119.60,698630.40,0.00,0.00,0.00),('1','151','755','234820',4513731,'2120','314',1189401.44,1190819.20,0.00,0.00,1417.76,884682.24,0.00,0.00,0.00),('1','151','755','235100',4518620,'2119','314',1919106.40,1919376.10,0.00,0.00,269.70,168292.80,0.00,0.00,0.00),('1','151','755','235100',4518621,'2120','314',1190819.20,1191240.31,0.00,0.00,421.11,262772.64,0.00,0.00,0.00),('1','151','755','235177',4520093,'2119','314',1919376.10,1919800.14,0.00,0.00,424.04,264600.96,0.00,0.00,0.00),('1','151','755','235177',4520094,'2120','314',1191240.31,1191995.53,0.00,0.00,755.22,471257.28,0.00,0.00,0.00),('1','151','755','235378',4523527,'2119','314',1919800.14,1920874.15,0.00,0.00,1074.01,670182.24,0.00,0.00,0.00),('1','151','755','235378',4523528,'2120','314',1191995.53,1193431.07,0.00,0.00,1435.54,895776.96,0.00,0.00,0.00),('1','151','755','235525',4526074,'2119','314',1920874.15,1921737.98,0.00,0.00,863.83,539029.92,0.00,0.00,0.00),('1','151','755','235525',4526075,'2120','314',1193431.07,1194709.00,0.00,0.00,1277.93,797428.32,0.00,0.00,0.00),('1','151','755','235754',4530162,'2119','314',1921737.98,1922915.48,0.00,0.00,1177.50,753600.00,0.00,0.00,0.00),('1','151','755','235754',4530163,'2120','314',1194709.00,1196424.91,0.00,0.00,1715.91,1098182.40,0.00,0.00,0.00),('1','151','755','236059',4535347,'2119','314',1922915.48,1923920.60,0.00,0.00,1005.12,643276.80,0.00,0.00,0.00),('1','151','755','236059',4535348,'2120','314',1196424.91,1197956.94,0.00,0.00,1532.03,980499.20,0.00,0.00,0.00),('1','151','755','236236',4538694,'2119','314',1923920.60,1924868.32,0.00,0.00,947.72,606540.80,0.00,0.00,0.00),('1','151','755','236236',4538695,'2120','314',1197956.94,1199194.07,0.00,0.00,1237.13,791763.20,0.00,0.00,0.00),('1','151','755','236512',4543566,'2119','314',1924868.32,1925950.43,0.00,0.00,1082.11,692550.40,0.00,0.00,0.00),('1','151','755','236512',4543567,'2120','314',1199194.07,1200825.70,0.00,0.00,1631.63,1044243.20,0.00,0.00,0.00),('1','151','755','236736',4547202,'2119','314',1925950.43,1926867.46,0.00,0.00,917.03,586899.20,0.00,0.00,0.00),('1','151','755','236736',4547203,'2120','314',1200825.70,1201989.45,0.00,0.00,1163.75,744800.00,0.00,0.00,0.00),('1','151','755','236869',4549623,'2119','314',1926867.46,1927261.55,0.00,0.00,394.09,252217.60,0.00,0.00,0.00),('1','151','755','236869',4549624,'2120','314',1201989.45,1202287.31,0.00,0.00,297.86,190630.40,0.00,0.00,0.00),('1','151','755','236999',4551823,'2119','314',1927261.55,1928498.47,0.00,0.00,1236.92,791628.80,0.00,0.00,0.00),('1','151','755','236999',4551824,'2120','314',1202287.31,1203838.70,0.00,0.00,1551.39,992889.60,0.00,0.00,0.00),('1','151','755','237177',4554992,'2119','314',1928498.47,1929487.64,0.00,0.00,989.17,633068.80,0.00,0.00,0.00),('1','151','755','237177',4554993,'2120','314',1203838.70,1205212.69,0.00,0.00,1373.99,879353.60,0.00,0.00,0.00),('1','151','755','237469',4560475,'2119','314',1929487.64,1929547.12,0.00,0.00,59.48,38067.20,0.00,0.00,0.00),('1','151','755','237469',4560476,'2120','314',1205212.69,1205365.30,0.00,0.00,152.61,97670.40,0.00,0.00,0.00),('1','151','755','237493',4560850,'2119','314',1929547.12,1930684.06,0.00,0.00,1136.94,727641.60,0.00,0.00,0.00),('1','151','755','237493',4560851,'2120','314',1205365.30,1206538.07,0.00,0.00,1172.77,750572.80,0.00,0.00,0.00),('1','151','755','237604',4562768,'2119','314',1930684.06,1931557.50,0.00,0.00,873.44,561941.44,0.00,0.00,0.00),('1','151','755','237604',4562769,'2120','314',1206538.07,1208018.29,0.00,0.00,1480.22,950385.76,0.00,0.00,0.00),('1','151','755','237856',4567007,'2119','314',1931557.50,1932560.87,0.00,0.00,1003.37,642156.80,0.00,0.00,0.00),('1','151','755','237856',4567008,'2120','314',1208018.29,1209541.15,0.00,0.00,1522.86,974630.40,0.00,0.00,0.00),('1','151','755','238100',4570969,'2119','314',1932560.87,1933671.73,0.00,0.00,1110.86,710950.40,0.00,0.00,0.00),('1','151','755','238100',4570970,'2120','314',1209541.15,1210792.80,0.00,0.00,1251.65,801056.00,0.00,0.00,0.00),('1','151','755','238423',4576475,'2119','314',1933671.73,1934996.81,0.00,0.00,1325.08,848051.20,0.00,0.00,0.00),('1','151','755','238423',4576476,'2120','314',1210792.80,1212480.12,0.00,0.00,1687.32,1079884.80,0.00,0.00,0.00),('1','151','755','238610',4579404,'2119','314',1934996.81,1935738.72,0.00,0.00,741.91,474822.40,0.00,0.00,0.00),('1','151','755','238610',4579405,'2120','314',1212480.12,1213434.91,0.00,0.00,954.79,611065.60,0.00,0.00,0.00),('1','151','755','238758',4582132,'2119','314',1935738.72,1936015.87,0.00,0.00,277.15,177376.00,0.00,0.00,0.00),('1','151','755','238758',4582133,'2120','314',1213434.91,1213772.91,0.00,0.00,338.00,216320.00,0.00,0.00,0.00),('1','151','755','238844',4583546,'2119','314',1936015.87,1936928.45,0.00,0.00,912.58,584051.20,0.00,0.00,0.00),('1','151','755','238844',4583547,'2120','314',1213772.91,1215199.74,0.00,0.00,1426.83,913171.20,0.00,0.00,0.00),('1','151','755','239067',4587621,'2119','314',1936928.45,1937721.73,0.00,0.00,793.28,507699.20,0.00,0.00,0.00),('1','151','755','239067',4587622,'2120','314',1215199.74,1216181.94,0.00,0.00,982.20,628608.00,0.00,0.00,0.00),('1','151','755','239225',4590316,'2119','314',1937721.73,1937762.82,0.00,0.00,41.09,26297.60,0.00,0.00,0.00),('1','151','755','239225',4590317,'2120','314',1216181.94,1216233.78,0.00,0.00,51.84,33177.60,0.00,0.00,0.00),('1','151','755','239295',4591543,'2119','314',1937762.82,1938822.53,0.00,0.00,1059.71,678214.40,0.00,0.00,0.00),('1','151','755','239295',4591544,'2120','314',1216233.78,1217665.16,0.00,0.00,1431.38,916083.20,0.00,0.00,0.00),('1','151','755','239525',4595479,'2119','314',1938822.53,1939638.09,0.00,0.00,815.56,447358.00,0.00,0.00,0.00),('1','151','755','239525',4595480,'2120','314',1217665.16,1218809.86,0.00,0.00,1144.70,732608.00,0.00,0.00,0.00),('1','151','755','239694',4598505,'2119','314',1939638.09,1940004.85,0.00,0.00,366.76,234726.40,0.00,0.00,0.00),('1','151','755','239694',4598506,'2120','314',1218809.86,1219051.11,0.00,0.00,241.25,154400.00,0.00,0.00,0.00),('1','151','755','239800',4600176,'2119','314',1940004.85,1940141.86,0.00,0.00,137.01,89878.56,0.00,0.00,0.00),('1','151','755','239800',4600177,'2120','314',1219051.11,1219275.00,0.00,0.00,223.89,146871.84,0.00,0.00,0.00),('1','151','755','239857',4601288,'2119','314',1940141.86,1941181.29,0.00,0.00,1039.43,681866.08,0.00,0.00,0.00),('1','151','755','239857',4601289,'2120','314',1219275.00,1220091.81,0.00,0.00,816.81,535827.36,0.00,0.00,0.00),('1','151','755','240030',4604261,'2119','314',1941181.29,1942454.80,0.00,0.00,1273.51,835422.56,0.00,0.00,0.00),('1','151','755','240030',4604262,'2120','314',1220091.81,1220927.92,0.00,0.00,836.11,548488.16,0.00,0.00,0.00),('1','151','755','240205',4607331,'2119','314',1942454.80,1942692.46,0.00,0.00,237.66,155904.96,0.00,0.00,0.00),('1','151','755','240205',4607332,'2120','314',1220927.92,1221443.43,0.00,0.00,515.51,338174.56,0.00,0.00,0.00),('1','151','755','240290',4608878,'2119','314',1942692.46,1943283.26,0.00,0.00,590.80,387564.80,0.00,0.00,0.00),('1','151','755','240290',4608879,'2120','314',1221443.43,1221893.01,0.00,0.00,449.58,294924.48,0.00,0.00,0.00),('1','151','755','240449',4611270,'2119','314',1943283.26,1944036.97,0.00,0.00,753.71,482374.40,0.00,0.00,0.00),('1','151','755','240449',4611271,'2120','314',1221893.01,1223256.58,0.00,0.00,1363.57,872684.80,0.00,0.00,0.00),('1','151','755','240749',4615893,'2119','314',1944036.97,1944684.18,0.00,0.00,647.21,414214.40,0.00,0.00,0.00),('1','151','755','240749',4615894,'2120','314',1223256.58,1223984.28,0.00,0.00,727.70,465728.00,0.00,0.00,0.00),('1','151','755','240839',4617546,'2119','314',1944684.18,1945085.99,0.00,0.00,401.81,257158.40,0.00,0.00,0.00),('1','151','755','240839',4617547,'2120','314',1223984.28,1224315.09,0.00,0.00,330.81,211718.40,0.00,0.00,0.00),('1','151','755','240973',4619985,'2119','314',1945085.99,1946328.61,0.00,0.00,1242.62,795276.80,0.00,0.00,0.00),('1','151','755','240973',4619986,'2120','314',1224315.09,1225760.50,0.00,0.00,1445.41,925062.40,0.00,0.00,0.00),('1','151','755','241225',4624558,'2119','314',1946328.61,1946707.95,0.00,0.00,379.34,242777.60,0.00,0.00,0.00),('1','151','755','241225',4624559,'2120','314',1225760.50,1226451.22,0.00,0.00,690.72,442060.80,0.00,0.00,0.00),('1','151','755','241386',4627273,'2119','314',1946707.95,1946882.70,0.00,0.00,174.75,111840.00,0.00,0.00,0.00),('1','151','755','241386',4627274,'2120','314',1226451.22,1226679.74,0.00,0.00,228.52,146252.80,0.00,0.00,0.00),('1','151','755','241495',4629073,'2119','314',1946882.70,1947489.28,0.00,0.00,606.58,388211.20,0.00,0.00,0.00),('1','151','755','241495',4629074,'2120','314',1226679.74,1227799.44,0.00,0.00,1119.70,716608.00,0.00,0.00,0.00),('1','151','755','241720',4633174,'2119','314',1947489.28,1948538.23,0.00,0.00,1048.95,671328.00,0.00,0.00,0.00),('1','151','755','241720',4633175,'2120','314',1227799.44,1229109.95,0.00,0.00,1310.51,838726.40,0.00,0.00,0.00),('1','151','755','241956',4637263,'2119','314',1948538.23,1948975.20,0.00,0.00,436.97,279660.80,0.00,0.00,0.00),('1','151','755','241956',4637264,'2120','314',1229109.95,1229538.87,0.00,0.00,428.92,274508.80,0.00,0.00,0.00),('1','151','755','242128',4640151,'2119','314',1948975.20,1949380.37,0.00,0.00,405.17,259308.80,0.00,0.00,0.00),('1','151','755','242128',4640152,'2120','314',1229538.87,1229833.01,0.00,0.00,294.14,188249.60,0.00,0.00,0.00),('1','151','755','242196',4641425,'2119','314',1949380.37,1950323.59,0.00,0.00,943.22,603660.80,0.00,0.00,0.00),('1','151','755','242196',4641426,'2120','314',1229833.01,1231279.87,0.00,0.00,1446.86,925990.40,0.00,0.00,0.00),('1','151','755','242420',4645330,'2119','314',1950323.59,1951242.41,0.00,0.00,918.82,588044.80,0.00,0.00,0.00),('1','151','755','242420',4645331,'2120','314',1231279.87,1232456.03,0.00,0.00,1176.16,752742.40,0.00,0.00,0.00),('1','151','755','242598',4648462,'2119','314',1951242.41,1951607.14,0.00,0.00,364.73,233427.20,0.00,0.00,0.00),('1','151','755','242598',4648463,'2120','314',1232456.03,1232729.69,0.00,0.00,273.66,175142.40,0.00,0.00,0.00),('1','151','755','242653',4649552,'2119','314',1951607.14,1952864.44,0.00,0.00,1257.30,804672.00,0.00,0.00,0.00),('1','151','755','242653',4649553,'2120','314',1232729.69,1234218.60,0.00,0.00,1488.91,952902.40,0.00,0.00,0.00),('1','151','755','242916',4653793,'2119','314',1952864.44,1953699.90,0.00,0.00,835.46,534694.40,0.00,0.00,0.00),('1','151','755','242916',4653794,'2120','314',1234218.60,1235153.65,0.00,0.00,935.05,598432.00,0.00,0.00,0.00),('1','151','755','243060',4656437,'2119','314',1953699.90,1953986.58,0.00,0.00,286.68,183475.20,0.00,0.00,0.00),('1','151','755','243060',4656438,'2120','314',1235153.65,1235360.59,0.00,0.00,206.94,132441.60,0.00,0.00,0.00),('1','151','755','243128',4657601,'2119','314',1953986.58,1955428.19,0.00,0.00,1441.61,922630.40,0.00,0.00,0.00),('1','151','755','243128',4657602,'2120','314',1235360.59,1237011.96,0.00,0.00,1651.37,1056876.80,0.00,0.00,0.00),('1','151','755','243363',4661790,'2119','314',1955428.19,1955861.30,0.00,0.00,433.11,277190.40,0.00,0.00,0.00),('1','151','755','243363',4661791,'2120','314',1237011.96,1237460.38,0.00,0.00,448.42,286988.80,0.00,0.00,0.00),('1','151','755','243477',4663723,'2119','314',1955861.30,1956198.00,0.00,0.00,336.70,215488.00,0.00,0.00,0.00),('1','151','755','243477',4663724,'2120','314',1237460.38,1238090.75,0.00,0.00,630.37,403436.80,0.00,0.00,0.00),('1','151','755','243596',4665725,'2119','314',1956198.00,1957267.96,0.00,0.00,1069.96,684774.40,0.00,0.00,0.00),('1','151','755','243596',4665726,'2120','314',1238090.75,1239697.72,0.00,0.00,1606.97,1028460.80,0.00,0.00,0.00),('1','151','755','243823',4669803,'2119','314',1957267.96,1958461.42,0.00,0.00,1193.46,763814.40,0.00,0.00,0.00),('1','151','755','243823',4669804,'2120','314',1239697.72,1240949.88,0.00,0.00,1252.16,801382.40,0.00,0.00,0.00),('1','151','755','244043',4673608,'2119','314',1958461.42,1959231.00,0.00,0.00,769.58,492531.20,0.00,0.00,0.00),('1','151','755','244043',4673609,'2120','314',1240949.88,1242212.64,0.00,0.00,1262.76,808166.40,0.00,0.00,0.00),('1','151','755','244229',4676809,'2119','314',1959231.00,1959370.81,0.00,0.00,139.81,89478.40,0.00,0.00,0.00),('1','151','755','244229',4676810,'2120','314',1242212.64,1242342.44,0.00,0.00,129.80,83072.00,0.00,0.00,0.00),('1','151','755','244298',4677800,'2119','314',1959370.81,1960107.12,0.00,0.00,736.31,471238.40,0.00,0.00,0.00),('1','151','755','244298',4677801,'2120','314',1242342.44,1243176.79,0.00,0.00,834.35,533984.00,0.00,0.00,0.00),('1','151','755','244426',4680124,'2119','314',1960107.12,1960598.57,0.00,0.00,491.45,314528.00,0.00,0.00,0.00),('1','151','755','244426',4680125,'2120','314',1243176.79,1243612.35,0.00,0.00,435.56,278758.40,0.00,0.00,0.00),('1','151','755','244510',4681608,'2119','314',1960598.57,1961400.42,0.00,0.00,801.85,513184.00,0.00,0.00,0.00),('1','151','755','244510',4681609,'2120','314',1243612.35,1244981.29,0.00,0.00,1368.94,876121.60,0.00,0.00,0.00),('1','151','755','244744',4685472,'2119','314',1961400.42,1962060.89,0.00,0.00,660.47,422700.80,0.00,0.00,0.00),('1','151','755','244744',4685473,'2120','314',1244981.29,1245704.88,0.00,0.00,723.59,463097.60,0.00,0.00,0.00),('1','151','755','244886',4688149,'2119','314',1962060.89,1962464.59,0.00,0.00,403.70,258368.00,0.00,0.00,0.00),('1','151','755','244886',4688150,'2120','314',1245704.88,1246098.81,0.00,0.00,393.93,252115.20,0.00,0.00,0.00),('1','151','755','244963',4689526,'2119','314',1962464.59,1963475.32,0.00,0.00,1010.73,630695.52,0.00,0.00,0.00),('1','151','755','244963',4689527,'2120','314',1246098.81,1247694.01,0.00,0.00,1595.20,995404.80,0.00,0.00,0.00),('1','151','755','245218',4693865,'2119','314',1963475.32,1963947.14,0.00,0.00,471.82,294415.68,0.00,0.00,0.00),('1','151','755','245218',4693866,'2120','314',1247694.01,1248287.11,0.00,0.00,593.10,370094.40,0.00,0.00,0.00),('1','151','755','245311',4695459,'2119','314',1963947.14,1964339.10,0.00,0.00,391.96,244583.04,0.00,0.00,0.00),('1','151','755','245311',4695460,'2120','314',1248287.11,1248762.16,0.00,0.00,475.05,296431.20,0.00,0.00,0.00),('1','151','755','245427',4697595,'2119','314',1964339.10,1966709.17,0.00,0.00,2370.07,1478923.68,0.00,0.00,0.00),('1','151','755','245427',4697596,'2120','314',1248762.16,1251821.86,0.00,0.00,3059.70,1909152.80,0.00,0.00,0.00),('1','151','755','245989',4706583,'2119','314',1966709.17,1967440.33,0.00,0.00,731.16,450394.56,0.00,0.00,0.00),('1','151','755','245989',4706584,'2120','314',1251821.86,1252908.55,0.00,0.00,1086.69,669401.04,0.00,0.00,0.00),('1','151','755','246107',4708747,'2119','314',1967440.33,1967761.24,0.00,0.00,320.91,197680.56,0.00,0.00,0.00),('1','151','755','246107',4708748,'2120','314',1252908.55,1253161.85,0.00,0.00,253.30,156032.80,0.00,0.00,0.00),('1','151','755','246190',4710040,'2119','314',1967761.24,1969051.93,0.00,0.00,1290.69,795065.04,0.00,0.00,0.00),('1','151','755','246190',4710041,'2120','314',1253161.85,1254517.40,0.00,0.00,1355.55,835018.80,0.00,0.00,0.00),('1','151','755','246446',4714452,'2119','314',1969051.93,1970364.97,0.00,0.00,1313.04,808832.64,0.00,0.00,0.00),('1','151','755','246446',4714453,'2120','314',1254517.40,1256044.19,0.00,0.00,1526.79,940502.64,0.00,0.00,0.00),('1','151','755','246701',4718777,'2119','314',1970364.97,1970663.45,0.00,0.00,298.48,183863.68,0.00,0.00,0.00),('1','151','755','246701',4718778,'2120','314',1256044.19,1256044.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','246794',4720450,'2119','314',1970663.45,1971514.54,0.00,0.00,851.09,524271.44,0.00,0.00,0.00),('1','151','755','246794',4720451,'2120','314',1256044.19,1256993.41,0.00,0.00,949.22,584719.52,0.00,0.00,0.00),('1','151','755','246940',4723056,'2119','314',1971514.54,1972583.61,0.00,0.00,1069.07,658547.12,0.00,0.00,0.00),('1','151','755','246940',4723057,'2120','314',1256993.41,1258305.99,0.00,0.00,1312.58,808549.28,0.00,0.00,0.00),('1','151','755','247170',4726927,'2119','314',1972583.61,1974010.39,0.00,0.00,1426.78,878896.48,0.00,0.00,0.00),('1','151','755','247170',4726928,'2120','314',1258305.99,1259751.40,0.00,0.00,1445.41,890372.56,0.00,0.00,0.00),('1','151','755','247386',4730931,'2119','314',1974010.39,1974694.60,0.00,0.00,684.21,421473.36,0.00,0.00,0.00),('1','151','755','247386',4730932,'2120','314',1259751.40,1260726.95,0.00,0.00,975.55,600938.80,0.00,0.00,0.00),('1','151','755','247571',4733869,'2119','314',1974694.60,1975311.78,0.00,0.00,617.18,380182.88,0.00,0.00,0.00),('1','151','755','247571',4733870,'2120','314',1260726.95,1261166.91,0.00,0.00,439.96,271015.36,0.00,0.00,0.00),('1','151','755','247681',4735632,'2119','314',1975311.78,1976383.24,0.00,0.00,1071.46,660019.36,0.00,0.00,0.00),('1','151','755','247681',4735633,'2120','314',1261166.91,1262510.71,0.00,0.00,1343.80,827780.80,0.00,0.00,0.00),('1','151','755','247888',4739461,'2119','314',1976383.24,1976830.01,0.00,0.00,446.77,275210.32,0.00,0.00,0.00),('1','151','755','247888',4739462,'2120','314',1262510.71,1263046.39,0.00,0.00,535.68,329978.88,0.00,0.00,0.00),('1','151','755','248044',4741800,'2119','314',1976830.01,1977092.64,0.00,0.00,262.63,161780.08,0.00,0.00,0.00),('1','151','755','248044',4741801,'2120','314',1263046.39,1263348.76,0.00,0.00,302.37,186259.92,0.00,0.00,0.00),('1','151','755','248161',4743879,'2119','314',1977092.64,1978096.87,0.00,0.00,1004.23,618605.68,0.00,0.00,0.00),('1','151','755','248161',4743880,'2120','314',1263348.76,1264770.02,0.00,0.00,1421.26,875496.16,0.00,0.00,0.00),('1','151','755','248414',4748134,'2119','314',1978096.87,1978677.11,0.00,0.00,580.24,357427.84,0.00,0.00,0.00),('1','151','755','248414',4748135,'2120','314',1264770.02,1265683.88,0.00,0.00,913.86,562937.76,0.00,0.00,0.00),('1','151','755','248545',4750539,'2119','314',1978677.11,1979035.16,0.00,0.00,358.05,220558.80,0.00,0.00,0.00),('1','151','755','248545',4750540,'2120','314',1265683.88,1265933.17,0.00,0.00,249.29,153562.64,0.00,0.00,0.00),('1','151','755','248646',4752037,'2119','314',1979035.16,1980234.26,0.00,0.00,1199.10,738645.60,0.00,0.00,0.00),('1','151','755','248646',4752038,'2120','314',1265933.17,1266874.55,0.00,0.00,941.38,579890.08,0.00,0.00,0.00),('1','151','755','248863',4755825,'2119','314',1980234.26,1981303.48,0.00,0.00,1069.22,641532.00,0.00,0.00,0.00),('1','151','755','248863',4755826,'2120','314',1266874.55,1267925.76,0.00,0.00,1051.21,630726.00,0.00,0.00,0.00),('1','151','755','249122',4759952,'2119','314',1981303.48,1982091.45,0.00,0.00,787.97,472782.00,0.00,0.00,0.00),('1','151','755','249122',4759953,'2120','314',1267925.76,1268695.09,0.00,0.00,769.33,461598.00,0.00,0.00,0.00),('1','151','755','249334',4763865,'2119','314',1982091.45,1983221.99,0.00,0.00,1130.54,678324.00,0.00,0.00,0.00),('1','151','755','249334',4763866,'2120','314',1268695.09,1270251.15,0.00,0.00,1556.06,933636.00,0.00,0.00,0.00),('1','151','755','249586',4768017,'2119','314',1983221.99,1984329.70,0.00,0.00,1107.71,664626.00,0.00,0.00,0.00),('1','151','755','249586',4768018,'2120','314',1270251.15,1270934.00,0.00,0.00,682.85,409710.00,0.00,0.00,0.00),('1','151','755','249851',4772488,'2119','314',1984329.70,1985205.22,0.00,0.00,875.52,525312.00,0.00,0.00,0.00),('1','151','755','249851',4772489,'2120','314',1270934.00,1272227.37,0.00,0.00,1293.37,776022.00,0.00,0.00,0.00),('1','151','755','250099',4776571,'2119','314',1985205.22,1986333.87,0.00,0.00,1128.65,677190.00,0.00,0.00,0.00),('1','151','755','250099',4776572,'2120','314',1272227.37,1273418.00,0.00,0.00,1190.63,714378.00,0.00,0.00,0.00),('1','151','755','250355',4780833,'2119','314',1986333.87,1986410.25,0.00,0.00,76.38,45828.00,0.00,0.00,0.00),('1','151','755','250355',4780834,'2120','314',1273418.00,1273526.43,0.00,0.00,108.43,65058.00,0.00,0.00,0.00),('1','151','755','250405',4781580,'2119','314',1986410.25,1987251.08,0.00,0.00,840.83,477591.44,0.00,0.00,0.00),('1','151','755','250405',4781581,'2120','314',1273526.43,1274771.69,0.00,0.00,1245.26,707307.68,0.00,0.00,0.00),('1','151','755','250560',4784346,'2119','314',1987251.08,1988295.04,0.00,0.00,1043.96,592969.28,0.00,0.00,0.00),('1','151','755','250560',4784347,'2120','314',1274771.69,1275952.16,0.00,0.00,1180.47,670506.96,0.00,0.00,0.00),('1','151','755','250793',4788410,'2119','314',1988295.04,1989517.11,0.00,0.00,1222.07,694135.76,0.00,0.00,0.00),('1','151','755','250793',4788411,'2120','314',1275952.16,1277552.06,0.00,0.00,1599.90,908743.20,0.00,0.00,0.00),('1','151','755','251020',4792502,'2119','314',1989517.11,1990324.05,0.00,0.00,806.94,458341.92,0.00,0.00,0.00),('1','151','755','251020',4792503,'2120','314',1277552.06,1278420.94,0.00,0.00,868.88,493523.84,0.00,0.00,0.00),('1','151','755','251186',4795378,'2119','314',1990324.05,1990712.39,0.00,0.00,388.34,220577.12,0.00,0.00,0.00),('1','151','755','251186',4795379,'2120','314',1278420.94,1278810.15,0.00,0.00,389.21,221071.28,0.00,0.00,0.00),('1','151','755','251274',4796814,'2119','314',1990712.39,1991912.44,0.00,0.00,1200.05,681628.40,0.00,0.00,0.00),('1','151','755','251274',4796815,'2120','314',1278810.15,1280481.94,0.00,0.00,1671.79,949576.72,0.00,0.00,0.00),('1','151','755','251516',4800913,'2119','314',1991912.44,1993215.67,0.00,0.00,1303.23,740234.64,0.00,0.00,0.00),('1','151','755','251516',4800914,'2120','314',1280481.94,1281852.23,0.00,0.00,1370.29,778324.72,0.00,0.00,0.00),('1','151','755','251762',4805368,'2119','314',1993215.67,1993222.02,0.00,0.00,6.35,3606.80,0.00,0.00,0.00),('1','151','755','251762',4805369,'2120','314',1281852.23,1282014.34,0.00,0.00,162.11,92078.48,0.00,0.00,0.00),('1','151','755','251848',4806733,'2119','314',1993222.02,1993222.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','251848',4806734,'2120','314',1282014.34,1282014.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','251856',4806875,'2119','314',1993222.02,1993886.09,0.00,0.00,664.07,377191.76,0.00,0.00,0.00),('1','151','755','251856',4806876,'2120','314',1282014.34,1282893.46,0.00,0.00,879.12,499340.16,0.00,0.00,0.00),('1','151','755','251997',4809369,'2119','314',1993886.09,1995241.60,0.00,0.00,1355.51,769929.68,0.00,0.00,0.00),('1','151','755','251997',4809370,'2120','314',1282893.46,1284377.79,0.00,0.00,1484.33,843099.44,0.00,0.00,0.00),('1','151','755','252232',4813528,'2119','314',1995241.60,1995951.14,0.00,0.00,709.54,403018.72,0.00,0.00,0.00),('1','151','755','252232',4813529,'2120','314',1284377.79,1285238.59,0.00,0.00,860.80,488934.40,0.00,0.00,0.00),('1','151','755','252489',4818086,'2119','314',1995951.14,1997309.06,0.00,0.00,1357.92,771298.56,0.00,0.00,0.00),('1','151','755','252489',4818087,'2120','314',1285238.59,1286666.53,0.00,0.00,1427.94,811069.92,0.00,0.00,0.00),('1','151','755','252711',4821977,'2119','314',1997309.06,1998469.46,0.00,0.00,1160.40,659107.20,0.00,0.00,0.00),('1','151','755','252711',4821978,'2120','314',1286666.53,1287983.57,0.00,0.00,1317.04,748078.72,0.00,0.00,0.00),('1','151','755','252982',4826223,'2119','314',1998469.46,1999680.18,0.00,0.00,1210.72,687688.96,0.00,0.00,0.00),('1','151','755','252982',4826224,'2120','314',1287983.57,1289387.18,0.00,0.00,1403.61,797250.48,0.00,0.00,0.00),('1','151','755','253316',4831879,'2119','314',1999680.18,2000755.84,0.00,0.00,1075.66,610974.88,0.00,0.00,0.00),('1','151','755','253316',4831880,'2120','314',1289387.18,1290704.99,0.00,0.00,1317.81,748516.08,0.00,0.00,0.00),('1','151','755','253485',4834862,'2119','314',2000755.84,2001759.46,0.00,0.00,1003.62,570056.16,0.00,0.00,0.00),('1','151','755','253485',4834863,'2120','314',1290704.99,1292025.49,0.00,0.00,1320.50,750044.00,0.00,0.00,0.00),('1','151','755','253717',4838814,'2119','314',2001759.46,2002831.54,0.00,0.00,1072.08,608941.44,0.00,0.00,0.00),('1','151','755','253717',4838815,'2120','314',1292025.49,1293066.14,0.00,0.00,1040.65,591089.20,0.00,0.00,0.00),('1','151','755','253972',4843190,'2119','314',2002831.54,2003833.25,0.00,0.00,1001.71,568971.28,0.00,0.00,0.00),('1','151','755','253972',4843191,'2120','314',1293066.14,1294368.31,0.00,0.00,1302.17,739632.56,0.00,0.00,0.00),('1','151','755','254196',4847410,'2119','314',2003833.25,2004211.25,0.00,0.00,378.00,214704.00,0.00,0.00,0.00),('1','151','755','254196',4847411,'2120','314',1294368.31,1294993.60,0.00,0.00,625.29,355164.72,0.00,0.00,0.00),('1','151','755','254324',4849558,'2119','314',2004211.25,2004211.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','254324',4849559,'2120','314',1294993.60,1294993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','254341',4849829,'2119','314',2004211.25,2004873.06,0.00,0.00,661.81,375908.08,0.00,0.00,0.00),('1','151','755','254341',4849830,'2120','314',1294993.60,1295537.84,0.00,0.00,544.24,309128.32,0.00,0.00,0.00),('1','151','755','254451',4851769,'2119','314',2004873.06,2006127.46,0.00,0.00,1254.40,712499.20,0.00,0.00,0.00),('1','151','755','254451',4851770,'2120','314',1295537.84,1296906.72,0.00,0.00,1368.88,777523.84,0.00,0.00,0.00),('1','151','755','254693',4856033,'2119','314',2006127.46,2007733.70,0.00,0.00,1606.24,912344.32,0.00,0.00,0.00),('1','151','755','254693',4856034,'2120','314',1296906.72,1298226.77,0.00,0.00,1320.05,749788.40,0.00,0.00,0.00),('1','151','755','254941',4860246,'2119','314',2007733.70,2008436.91,0.00,0.00,703.21,399423.28,0.00,0.00,0.00),('1','151','755','254941',4860247,'2120','314',1298226.77,1299155.94,0.00,0.00,929.17,527768.56,0.00,0.00,0.00),('1','151','755','255108',4863128,'2119','314',2008436.91,2008624.03,0.00,0.00,187.12,106284.16,0.00,0.00,0.00),('1','151','755','255108',4863129,'2120','314',1299155.94,1299326.34,0.00,0.00,170.40,96787.20,0.00,0.00,0.00),('1','151','755','255190',4864483,'2119','314',2008624.03,2009833.47,0.00,0.00,1209.44,686961.92,0.00,0.00,0.00),('1','151','755','255190',4864484,'2120','314',1299326.34,1300613.44,0.00,0.00,1287.10,731072.80,0.00,0.00,0.00),('1','151','755','255462',4869141,'2119','314',2009833.47,2010962.46,0.00,0.00,1128.99,467702.45,0.00,0.00,0.00),('1','151','755','255462',4869142,'2120','314',1300613.44,1301371.39,0.00,0.00,757.95,430515.60,0.00,0.00,0.00),('1','151','755','255711',4873231,'2119','314',2010962.46,2012490.81,0.00,0.00,1528.35,868102.80,0.00,0.00,0.00),('1','151','755','255711',4873232,'2120','314',1301371.39,1302880.74,0.00,0.00,1509.35,857310.80,0.00,0.00,0.00),('1','151','755','255943',4876988,'2119','314',2012490.81,2013299.15,0.00,0.00,808.34,459137.12,0.00,0.00,0.00),('1','151','755','255943',4876989,'2120','314',1302880.74,1303520.29,0.00,0.00,639.55,363264.40,0.00,0.00,0.00),('1','151','755','256095',4879629,'2119','314',2013299.15,2014082.46,0.00,0.00,783.31,444920.08,0.00,0.00,0.00),('1','151','755','256095',4879630,'2120','314',1303520.29,1304141.03,0.00,0.00,620.74,352580.32,0.00,0.00,0.00),('1','151','755','256216',4881274,'2119','314',2014082.46,2015714.81,0.00,0.00,1632.35,927174.80,0.00,0.00,0.00),('1','151','755','256216',4881275,'2120','314',1304141.03,1305389.67,0.00,0.00,1248.64,709227.52,0.00,0.00,0.00),('1','151','755','256483',4885963,'2119','314',2015714.81,2017029.10,0.00,0.00,1314.29,746516.72,0.00,0.00,0.00),('1','151','755','256483',4885964,'2120','314',1305389.67,1306549.77,0.00,0.00,1160.10,658936.80,0.00,0.00,0.00),('1','151','755','256662',4889124,'2119','314',2017029.10,2017029.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','256662',4889125,'2120','314',1306549.77,1306549.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','256762',4890453,'2119','314',2017029.10,2018565.27,0.00,0.00,1536.17,872544.56,0.00,0.00,0.00),('1','151','755','256762',4890454,'2120','314',1306549.77,1307859.02,0.00,0.00,1309.25,743654.00,0.00,0.00,0.00),('1','151','755','256994',4894493,'2119','314',2018565.27,2019593.21,0.00,0.00,1027.94,583869.92,0.00,0.00,0.00),('1','151','755','256994',4894494,'2120','314',1307859.02,1308663.14,0.00,0.00,804.12,456740.16,0.00,0.00,0.00),('1','151','755','257138',4897472,'2119','314',2019593.21,2019933.95,0.00,0.00,340.74,193540.32,0.00,0.00,0.00),('1','151','755','257138',4897473,'2120','314',1308663.14,1308988.89,0.00,0.00,325.75,185026.00,0.00,0.00,0.00),('1','151','755','257321',4900563,'2119','314',2019933.95,2021455.81,0.00,0.00,1521.86,735962.98,0.00,0.00,0.00),('1','151','755','257321',4900564,'2120','314',1308988.89,1310238.93,0.00,0.00,1250.04,710022.72,0.00,0.00,0.00),('1','151','755','257498',4903591,'2119','314',2021455.81,2023019.26,0.00,0.00,1563.45,888039.60,0.00,0.00,0.00),('1','151','755','257498',4903592,'2120','314',1310238.93,1311536.17,0.00,0.00,1297.24,736832.32,0.00,0.00,0.00),('1','151','755','257499',4903593,'2119','314',2023019.26,2023909.89,0.00,0.00,890.63,505877.84,0.00,0.00,0.00),('1','151','755','257499',4903594,'2120','314',1311536.17,1312348.83,0.00,0.00,812.66,461590.88,0.00,0.00,0.00),('1','151','755','257500',4903595,'2119','314',2023909.89,2024054.43,0.00,0.00,144.54,82098.72,0.00,0.00,0.00),('1','151','755','257500',4903596,'2120','314',1312348.83,1312498.79,0.00,0.00,149.96,85177.28,0.00,0.00,0.00),('1','151','755','257501',4903597,'2119','314',2024054.43,2026134.98,0.00,0.00,2080.55,1122354.82,0.00,0.00,0.00),('1','151','755','257501',4903598,'2120','314',1312498.79,1314104.82,0.00,0.00,1606.03,912225.04,0.00,0.00,0.00),('1','151','755','257502',4903599,'2119','314',2026134.98,2026501.13,0.00,0.00,366.15,207973.20,0.00,0.00,0.00),('1','151','755','257502',4903600,'2120','314',1314104.82,1314473.03,0.00,0.00,368.21,209143.28,0.00,0.00,0.00),('1','151','755','257503',4903601,'2119','314',2026501.13,2027335.82,0.00,0.00,834.69,474103.92,0.00,0.00,0.00),('1','151','755','257503',4903602,'2120','314',1314473.03,1315204.90,0.00,0.00,731.87,415702.16,0.00,0.00,0.00),('1','151','755','257504',4903603,'2119','314',2028990.74,2030585.24,0.00,0.00,1594.50,905676.00,0.00,0.00,0.00),('1','151','755','257504',4903604,'2120','314',1316580.75,1318121.36,0.00,0.00,1540.61,875066.48,0.00,0.00,0.00),('1','151','755','257505',4903605,'2119','314',2030585.24,2031848.03,0.00,0.00,1262.79,717264.72,0.00,0.00,0.00),('1','151','755','257505',4903606,'2120','314',1318121.36,1319360.96,0.00,0.00,1239.60,704092.80,0.00,0.00,0.00),('1','151','755','257506',4903607,'2119','314',2031848.03,2031848.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257506',4903608,'2120','314',1319360.96,1319360.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257507',4903609,'2119','314',2031848.03,2033484.09,0.00,0.00,1636.06,929282.08,0.00,0.00,0.00),('1','151','755','257507',4903610,'2120','314',1319360.96,1321035.27,0.00,0.00,1674.31,951008.08,0.00,0.00,0.00),('1','151','755','257508',4903611,'2119','314',2033484.09,2034104.66,0.00,0.00,620.57,352483.76,0.00,0.00,0.00),('1','151','755','257508',4903612,'2120','314',1321035.27,1321607.27,0.00,0.00,572.00,324896.00,0.00,0.00,0.00),('1','151','755','257509',4903613,'2119','314',2034104.66,2034857.96,0.00,0.00,753.30,427874.40,0.00,0.00,0.00),('1','151','755','257509',4903614,'2120','314',1321607.27,1322190.99,0.00,0.00,583.72,331552.96,0.00,0.00,0.00),('1','151','755','257510',4903615,'2119','314',2034857.96,2036237.52,0.00,0.00,1379.56,783590.08,0.00,0.00,0.00),('1','151','755','257510',4903616,'2120','314',1322190.99,1323847.06,0.00,0.00,1656.07,940647.76,0.00,0.00,0.00),('1','151','755','257511',4903617,'2119','314',2036237.52,2037884.97,0.00,0.00,1647.45,935751.60,0.00,0.00,0.00),('1','151','755','257511',4903618,'2120','314',1323847.06,1325560.17,0.00,0.00,1713.11,973046.48,0.00,0.00,0.00),('1','151','755','257512',4903619,'2119','314',2037884.97,2038480.71,0.00,0.00,595.74,338380.32,0.00,0.00,0.00),('1','151','755','257512',4903620,'2120','314',1325560.17,1326085.88,0.00,0.00,525.71,298603.28,0.00,0.00,0.00),('1','151','755','257513',4903621,'2119','314',2038480.71,2038935.59,0.00,0.00,454.88,258371.84,0.00,0.00,0.00),('1','151','755','257513',4903622,'2120','314',1326085.88,1326463.70,0.00,0.00,377.82,214601.76,0.00,0.00,0.00),('1','151','755','257514',4903623,'2119','314',2038935.59,2040321.07,0.00,0.00,1385.48,786952.64,0.00,0.00,0.00),('1','151','755','257514',4903624,'2120','314',1326463.70,1327764.00,0.00,0.00,1300.30,738570.40,0.00,0.00,0.00),('1','151','755','257515',4903625,'2119','314',2040321.07,2040751.81,0.00,0.00,430.74,244660.32,0.00,0.00,0.00),('1','151','755','257515',4903626,'2120','314',1327764.00,1328292.73,0.00,0.00,528.73,300318.64,0.00,0.00,0.00),('1','151','755','257516',4903627,'2119','314',2040751.81,2041020.06,0.00,0.00,268.25,152366.00,0.00,0.00,0.00),('1','151','755','257516',4903628,'2120','314',1328292.73,1328599.30,0.00,0.00,306.57,174131.76,0.00,0.00,0.00),('1','151','755','257517',4903629,'2119','314',2041020.06,2042321.48,0.00,0.00,1301.42,739206.56,0.00,0.00,0.00),('1','151','755','257517',4903630,'2120','314',1328599.30,1330001.70,0.00,0.00,1402.40,796563.20,0.00,0.00,0.00),('1','151','755','257518',4903631,'2119','314',2042321.48,2042831.02,0.00,0.00,509.54,289418.72,0.00,0.00,0.00),('1','151','755','257518',4903632,'2120','314',1330001.70,1330666.86,0.00,0.00,665.16,377810.88,0.00,0.00,0.00),('1','151','755','257519',4903633,'2119','314',2042831.02,2044126.90,0.00,0.00,1295.88,736059.84,0.00,0.00,0.00),('1','151','755','257519',4903634,'2120','314',1330666.86,1331785.30,0.00,0.00,1118.44,635273.92,0.00,0.00,0.00),('1','151','755','257520',4903635,'2119','314',2044126.90,2044126.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257520',4903636,'2120','314',1331785.30,1331785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257521',4903637,'2119','314',2044126.90,2044708.26,0.00,0.00,581.36,330212.48,0.00,0.00,0.00),('1','151','755','257521',4903638,'2120','314',1331785.30,1332294.03,0.00,0.00,508.73,288958.64,0.00,0.00,0.00),('1','151','755','257522',4903639,'2119','314',2044708.26,2045780.43,0.00,0.00,1072.17,608992.56,0.00,0.00,0.00),('1','151','755','257522',4903640,'2120','314',1332294.03,1333288.40,0.00,0.00,994.37,564802.16,0.00,0.00,0.00),('1','151','755','257523',4903641,'2119','314',2045780.43,2047117.46,0.00,0.00,1337.03,759433.04,0.00,0.00,0.00),('1','151','755','257523',4903642,'2120','314',1333288.40,1334590.64,0.00,0.00,1302.24,739672.32,0.00,0.00,0.00),('1','151','755','257524',4903643,'2119','314',2047117.46,2048046.95,0.00,0.00,929.49,527950.32,0.00,0.00,0.00),('1','151','755','257524',4903644,'2120','314',1334590.64,1335545.92,0.00,0.00,955.28,542599.04,0.00,0.00,0.00),('1','151','755','257525',4903645,'2119','314',2048046.95,2048046.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257525',4903646,'2120','314',1335545.92,1335545.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257526',4903647,'2119','314',2048046.95,2049275.07,0.00,0.00,1228.12,697572.16,0.00,0.00,0.00),('1','151','755','257526',4903648,'2120','314',1335545.92,1336730.86,0.00,0.00,1184.94,673045.92,0.00,0.00,0.00),('1','151','755','257527',4903649,'2119','314',2049275.07,2050311.06,0.00,0.00,1035.99,588442.32,0.00,0.00,0.00),('1','151','755','257527',4903650,'2120','314',1336730.86,1337769.66,0.00,0.00,1038.80,590038.40,0.00,0.00,0.00),('1','151','755','257528',4903651,'2119','314',2050311.06,2051445.38,0.00,0.00,1134.32,644293.76,0.00,0.00,0.00),('1','151','755','257528',4903652,'2120','314',1337769.66,1338742.01,0.00,0.00,972.35,552294.80,0.00,0.00,0.00),('1','151','755','257529',4903653,'2119','314',2051445.38,2052415.44,0.00,0.00,970.06,550994.08,0.00,0.00,0.00),('1','151','755','257529',4903654,'2120','314',1338742.01,1339843.35,0.00,0.00,1101.34,625561.12,0.00,0.00,0.00),('1','151','755','257530',4903655,'2119','314',2052415.44,2052633.38,0.00,0.00,217.94,123789.92,0.00,0.00,0.00),('1','151','755','257530',4903656,'2120','314',1339843.35,1340025.65,0.00,0.00,182.30,103546.40,0.00,0.00,0.00),('1','151','755','257531',4903657,'2119','314',2052633.38,2053530.64,0.00,0.00,897.26,509643.68,0.00,0.00,0.00),('1','151','755','257531',4903658,'2120','314',1340025.65,1340734.65,0.00,0.00,709.00,402712.00,0.00,0.00,0.00),('1','151','755','257532',4903659,'2119','314',2053530.64,2054480.04,0.00,0.00,949.40,539259.20,0.00,0.00,0.00),('1','151','755','257532',4903660,'2120','314',1340734.65,1341753.91,0.00,0.00,1019.26,578939.68,0.00,0.00,0.00),('1','151','755','257533',4903661,'2119','314',2054480.04,2055016.10,0.00,0.00,536.06,304482.08,0.00,0.00,0.00),('1','151','755','257533',4903662,'2120','314',1341753.91,1342155.33,0.00,0.00,401.42,228006.56,0.00,0.00,0.00),('1','151','755','257534',4903663,'2119','314',2055016.10,2055568.05,0.00,0.00,551.95,313507.60,0.00,0.00,0.00),('1','151','755','257534',4903664,'2120','314',1342155.33,1342698.87,0.00,0.00,543.54,308730.72,0.00,0.00,0.00),('1','151','755','257535',4903665,'2119','314',2055568.05,2056464.31,0.00,0.00,896.26,509075.68,0.00,0.00,0.00),('1','151','755','257535',4903666,'2120','314',1342698.87,1343905.41,0.00,0.00,1206.54,685314.72,0.00,0.00,0.00),('1','151','755','257536',4903667,'2119','314',2056464.31,2056464.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257536',4903668,'2120','314',1343905.41,1343905.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257537',4903669,'2119','314',2056464.31,2057454.97,0.00,0.00,990.66,562694.88,0.00,0.00,0.00),('1','151','755','257537',4903670,'2120','314',1343905.41,1344878.22,0.00,0.00,972.81,552556.08,0.00,0.00,0.00),('1','151','755','257538',4903671,'2119','314',2057454.97,2058532.76,0.00,0.00,1077.79,612184.72,0.00,0.00,0.00),('1','151','755','257538',4903672,'2120','314',1344878.22,1346273.78,0.00,0.00,1395.56,792678.08,0.00,0.00,0.00),('1','151','755','257539',4903673,'2119','314',2058532.76,2059527.01,0.00,0.00,994.25,564734.00,0.00,0.00,0.00),('1','151','755','257539',4903674,'2120','314',1346273.78,1347353.21,0.00,0.00,1079.43,613116.24,0.00,0.00,0.00),('1','151','755','257540',4903675,'2119','314',2059527.01,2060680.91,0.00,0.00,1153.90,655415.20,0.00,0.00,0.00),('1','151','755','257540',4903676,'2120','314',1347353.21,1348493.40,0.00,0.00,1140.19,647627.92,0.00,0.00,0.00),('1','151','755','257541',4903677,'2119','314',2060680.91,2062073.51,0.00,0.00,1392.60,790996.80,0.00,0.00,0.00),('1','151','755','257541',4903678,'2120','314',1348493.40,1349896.63,0.00,0.00,1403.23,797034.64,0.00,0.00,0.00),('1','151','755','257542',4903679,'2119','314',2062073.51,2063013.71,0.00,0.00,940.20,534033.60,0.00,0.00,0.00),('1','151','755','257542',4903680,'2120','314',1349896.63,1350839.73,0.00,0.00,943.10,535680.80,0.00,0.00,0.00),('1','151','755','257543',4903681,'2119','314',2063013.71,2063708.95,0.00,0.00,695.24,394896.32,0.00,0.00,0.00),('1','151','755','257543',4903682,'2120','314',1350839.73,1351627.20,0.00,0.00,787.47,447282.96,0.00,0.00,0.00),('1','151','755','257544',4903683,'2119','314',2063708.95,2063952.72,0.00,0.00,243.77,138461.36,0.00,0.00,0.00),('1','151','755','257544',4903684,'2120','314',1351627.20,1351927.34,0.00,0.00,300.14,170479.52,0.00,0.00,0.00),('1','151','755','257545',4903685,'2119','314',2063952.72,2065029.30,0.00,0.00,1076.58,611497.44,0.00,0.00,0.00),('1','151','755','257545',4903686,'2120','314',1351927.34,1353328.97,0.00,0.00,1401.63,796125.84,0.00,0.00,0.00),('1','151','755','257546',4903687,'2119','314',2065029.30,2066437.42,0.00,0.00,1408.12,799812.16,0.00,0.00,0.00),('1','151','755','257546',4903688,'2120','314',1353328.97,1354494.48,0.00,0.00,1165.51,662009.68,0.00,0.00,0.00),('1','151','755','257547',4903689,'2119','314',2066437.42,2067474.48,0.00,0.00,1037.06,663718.40,0.00,0.00,0.00),('1','151','755','257547',4903690,'2120','314',1354494.48,1355409.83,0.00,0.00,915.35,585824.00,0.00,0.00,0.00),('1','151','755','257548',4903691,'2119','314',2067474.48,2068607.54,0.00,0.00,1133.06,725158.40,0.00,0.00,0.00),('1','151','755','257548',4903692,'2120','314',1355409.83,1356534.36,0.00,0.00,1124.53,719699.20,0.00,0.00,0.00),('1','151','755','257549',4903693,'2119','314',2068607.54,2068607.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257549',4903694,'2120','314',1356534.36,1356534.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257550',4903695,'2119','314',2068607.54,2069794.19,0.00,0.00,1186.65,759456.00,0.00,0.00,0.00),('1','151','755','257550',4903696,'2120','314',1356534.36,1357498.55,0.00,0.00,964.19,617081.60,0.00,0.00,0.00),('1','151','755','257551',4903697,'2119','314',2069794.19,2071118.89,0.00,0.00,1324.70,847808.00,0.00,0.00,0.00),('1','151','755','257551',4903698,'2120','314',1357498.55,1358564.07,0.00,0.00,1065.52,681932.80,0.00,0.00,0.00),('1','151','755','257552',4903699,'2119','314',2071118.89,2072274.29,0.00,0.00,1155.40,739456.00,0.00,0.00,0.00),('1','151','755','257552',4903700,'2120','314',1358564.07,1359410.03,0.00,0.00,845.96,541414.40,0.00,0.00,0.00),('1','151','755','257553',4903701,'2119','314',2072274.29,2073236.98,0.00,0.00,962.69,616121.60,0.00,0.00,0.00),('1','151','755','257553',4903702,'2120','314',1359410.03,1360941.66,0.00,0.00,1531.63,980243.20,0.00,0.00,0.00),('1','151','755','257554',4903703,'2119','314',2073236.98,2074812.88,0.00,0.00,1575.90,1071612.00,0.00,0.00,0.00),('1','151','755','257554',4903704,'2120','314',1360941.66,1362239.47,0.00,0.00,1297.81,882510.80,0.00,0.00,0.00),('1','151','755','257555',4903705,'2119','314',2074812.88,2075882.15,0.00,0.00,1069.27,727103.60,0.00,0.00,0.00),('1','151','755','257555',4903706,'2120','314',1362239.47,1362789.63,0.00,0.00,550.16,374108.80,0.00,0.00,0.00),('1','151','755','257556',4903707,'2119','314',2075882.15,2075925.53,0.00,0.00,43.38,29498.40,0.00,0.00,0.00),('1','151','755','257556',4903708,'2120','314',1362789.63,1362834.68,0.00,0.00,45.05,30634.00,0.00,0.00,0.00),('1','151','755','257557',4903709,'2119','314',2075925.53,2077340.75,0.00,0.00,1415.22,962349.60,0.00,0.00,0.00),('1','151','755','257557',4903710,'2120','314',1362834.68,1363781.71,0.00,0.00,947.03,574865.27,0.00,0.00,0.00),('1','151','755','257558',4903711,'2119','314',2077340.75,2078705.79,0.00,0.00,1365.04,873625.60,0.00,0.00,0.00),('1','151','755','257558',4903712,'2120','314',1363781.71,1364823.70,0.00,0.00,1041.99,666873.60,0.00,0.00,0.00),('1','151','755','257559',4903713,'2119','314',2078705.79,2078890.44,0.00,0.00,184.65,118176.00,0.00,0.00,0.00),('1','151','755','257559',4903714,'2120','314',1364823.70,1364907.75,0.00,0.00,84.05,53792.00,0.00,0.00,0.00),('1','151','755','257560',4903715,'2119','314',2078890.44,2079474.84,0.00,0.00,584.40,374016.00,0.00,0.00,0.00),('1','151','755','257560',4903716,'2120','314',1364907.75,1365445.24,0.00,0.00,537.49,343993.60,0.00,0.00,0.00),('1','151','755','257561',4903717,'2119','314',2079474.84,2080875.76,0.00,0.00,1400.92,896588.80,0.00,0.00,0.00),('1','151','755','257561',4903718,'2120','314',1365445.24,1366558.41,0.00,0.00,1113.17,712428.80,0.00,0.00,0.00),('1','151','755','257562',4903719,'2119','314',2080875.76,2081277.20,0.00,0.00,401.44,256921.60,0.00,0.00,0.00),('1','151','755','257562',4903720,'2120','314',1366558.41,1367006.55,0.00,0.00,448.14,286809.60,0.00,0.00,0.00),('1','151','755','257563',4903721,'2119','314',2081277.20,2082027.35,0.00,0.00,750.15,480096.00,0.00,0.00,0.00),('1','151','755','257563',4903722,'2120','314',1367006.55,1367585.51,0.00,0.00,578.96,370534.40,0.00,0.00,0.00),('1','151','755','257564',4903723,'2119','314',2082027.35,2083062.50,0.00,0.00,1035.15,662496.00,0.00,0.00,0.00),('1','151','755','257564',4903724,'2120','314',1367585.51,1368551.76,0.00,0.00,966.25,618400.00,0.00,0.00,0.00),('1','151','755','257565',4903725,'2119','314',2083062.50,2084197.07,0.00,0.00,1134.57,726124.80,0.00,0.00,0.00),('1','151','755','257565',4903726,'2120','314',1368551.76,1369586.76,0.00,0.00,1035.00,662400.00,0.00,0.00,0.00),('1','151','755','257566',4903727,'2119','314',2084197.07,2085474.16,0.00,0.00,1277.09,817337.60,0.00,0.00,0.00),('1','151','755','257566',4903728,'2120','314',1369586.76,1370415.20,0.00,0.00,828.44,530201.60,0.00,0.00,0.00),('1','151','755','257567',4903729,'2119','314',2085474.16,2086598.36,0.00,0.00,1124.20,719488.00,0.00,0.00,0.00),('1','151','755','257567',4903730,'2120','314',1370415.20,1371276.03,0.00,0.00,860.83,550931.20,0.00,0.00,0.00),('1','151','755','257568',4903731,'2119','314',2086598.36,2087595.53,0.00,0.00,997.17,638188.80,0.00,0.00,0.00),('1','151','755','257568',4903732,'2120','314',1371276.03,1372185.95,0.00,0.00,909.92,582348.80,0.00,0.00,0.00),('1','151','755','257569',4903733,'2119','314',2087595.53,2089012.88,0.00,0.00,1417.35,963798.00,0.00,0.00,0.00),('1','151','755','257569',4903734,'2120','314',1372185.95,1373358.02,0.00,0.00,1172.07,797007.60,0.00,0.00,0.00),('1','151','755','257570',4903735,'2119','314',2089012.88,2090307.74,0.00,0.00,1294.86,880504.80,0.00,0.00,0.00),('1','151','755','257570',4903736,'2120','314',1373358.02,1374761.89,0.00,0.00,1403.87,954631.60,0.00,0.00,0.00),('1','151','755','257571',4903737,'2119','314',2090307.74,2091777.51,0.00,0.00,1469.77,999443.60,0.00,0.00,0.00),('1','151','755','257571',4903738,'2120','314',1374761.89,1375675.87,0.00,0.00,913.98,621506.40,0.00,0.00,0.00),('1','151','755','257572',4903739,'2119','314',2091777.51,2092639.43,0.00,0.00,861.92,586105.60,0.00,0.00,0.00),('1','151','755','257572',4903740,'2120','314',1375675.87,1376457.85,0.00,0.00,781.98,531746.40,0.00,0.00,0.00),('1','151','755','257573',4903741,'2119','314',2092639.43,2094509.65,0.00,0.00,1870.22,1196940.80,0.00,0.00,0.00),('1','151','755','257573',4903742,'2120','314',1376457.85,1377909.98,0.00,0.00,1452.13,929363.20,0.00,0.00,0.00),('1','151','755','257574',4903743,'2119','314',2094509.65,2095354.29,0.00,0.00,844.64,540569.60,0.00,0.00,0.00),('1','151','755','257574',4903744,'2120','314',1377909.98,1378476.81,0.00,0.00,566.83,362771.20,0.00,0.00,0.00),('1','151','755','257575',4903745,'2119','314',2095354.29,2096847.95,0.00,0.00,1493.66,955942.40,0.00,0.00,0.00),('1','151','755','257575',4903746,'2120','314',1378476.81,1379498.09,0.00,0.00,1021.28,653619.20,0.00,0.00,0.00),('1','151','755','257576',4903747,'2119','314',2096847.95,2098016.51,0.00,0.00,1168.56,747878.40,0.00,0.00,0.00),('1','151','755','257576',4903748,'2120','314',1379498.09,1380356.59,0.00,0.00,858.50,549440.00,0.00,0.00,0.00),('1','151','755','257577',4903749,'2119','314',2098016.51,2098433.11,0.00,0.00,416.60,266624.00,0.00,0.00,0.00),('1','151','755','257577',4903750,'2120','314',1380356.59,1380693.61,0.00,0.00,337.02,215692.80,0.00,0.00,0.00),('1','151','755','257578',4903751,'2119','314',2098433.11,2100243.59,0.00,0.00,1810.48,1158707.20,0.00,0.00,0.00),('1','151','755','257578',4903752,'2120','314',1380693.61,1382698.45,0.00,0.00,2004.84,1283097.60,0.00,0.00,0.00),('1','151','755','257579',4903753,'2119','314',2100243.59,2101881.56,0.00,0.00,1637.97,1048300.80,0.00,0.00,0.00),('1','151','755','257579',4903754,'2120','314',1382698.45,1384130.60,0.00,0.00,1432.15,916576.00,0.00,0.00,0.00),('1','151','755','257580',4903755,'2119','314',2101881.56,2102356.27,0.00,0.00,474.71,303814.40,0.00,0.00,0.00),('1','151','755','257580',4903756,'2120','314',1384130.60,1385172.12,0.00,0.00,1041.52,666572.80,0.00,0.00,0.00),('1','151','755','257581',4903757,'2119','314',2102356.27,2103928.16,0.00,0.00,1571.89,1006009.60,0.00,0.00,0.00),('1','151','755','257581',4903758,'2120','314',1385172.12,1386540.57,0.00,0.00,1368.45,875808.00,0.00,0.00,0.00),('1','151','755','257582',4903759,'2119','314',2103928.16,2104571.32,0.00,0.00,643.16,411622.40,0.00,0.00,0.00),('1','151','755','257582',4903760,'2120','314',1386540.57,1387430.85,0.00,0.00,890.28,569779.20,0.00,0.00,0.00),('1','151','755','257583',4903761,'2119','314',2104571.32,2104682.15,0.00,0.00,110.83,70931.20,0.00,0.00,0.00),('1','151','755','257583',4903762,'2120','314',1387430.85,1387504.13,0.00,0.00,73.28,46899.20,0.00,0.00,0.00),('1','151','755','257584',4903763,'2119','314',2104682.15,2105672.86,0.00,0.00,990.71,634054.40,0.00,0.00,0.00),('1','151','755','257584',4903764,'2120','314',1387504.13,1388390.18,0.00,0.00,886.05,567072.00,0.00,0.00,0.00),('1','151','755','257585',4903765,'2119','314',2105672.86,2106255.26,0.00,0.00,582.40,372736.00,0.00,0.00,0.00),('1','151','755','257585',4903766,'2120','314',1388390.18,1389077.70,0.00,0.00,687.52,440012.80,0.00,0.00,0.00),('1','151','755','257586',4903767,'2119','314',2106255.26,2107407.24,0.00,0.00,1151.98,737267.20,0.00,0.00,0.00),('1','151','755','257586',4903768,'2120','314',1389077.70,1390164.50,0.00,0.00,1086.80,695552.00,0.00,0.00,0.00),('1','151','755','257587',4903769,'2119','314',2107407.24,2108040.24,0.00,0.00,633.00,405120.00,0.00,0.00,0.00),('1','151','755','257587',4903770,'2120','314',1390164.50,1390891.22,0.00,0.00,726.72,465100.80,0.00,0.00,0.00),('1','151','755','257588',4903771,'2119','314',2108040.24,2108285.83,0.00,0.00,245.59,157177.60,0.00,0.00,0.00),('1','151','755','257588',4903772,'2120','314',1390891.22,1391091.38,0.00,0.00,200.16,128102.40,0.00,0.00,0.00),('1','151','755','257589',4903773,'2119','314',2108285.83,2109592.57,0.00,0.00,1306.74,836313.60,0.00,0.00,0.00),('1','151','755','257589',4903774,'2120','314',1391091.38,1392065.65,0.00,0.00,974.27,623532.80,0.00,0.00,0.00),('1','151','755','257590',4903775,'2119','314',2109592.57,2110412.05,0.00,0.00,819.48,524467.20,0.00,0.00,0.00),('1','151','755','257590',4903776,'2120','314',1392065.65,1392952.45,0.00,0.00,886.80,567552.00,0.00,0.00,0.00),('1','151','755','257591',4903777,'2119','314',2110412.05,2111094.06,0.00,0.00,682.01,436486.40,0.00,0.00,0.00),('1','151','755','257591',4903778,'2120','314',1392952.45,1393487.92,0.00,0.00,535.47,342700.80,0.00,0.00,0.00),('1','151','755','257592',4903779,'2119','314',2111094.06,2111552.44,0.00,0.00,458.38,293363.20,0.00,0.00,0.00),('1','151','755','257592',4903780,'2120','314',1393487.92,1393827.24,0.00,0.00,339.32,217164.80,0.00,0.00,0.00),('1','151','755','257593',4903781,'2119','314',2111552.44,2112659.25,0.00,0.00,1106.81,708358.40,0.00,0.00,0.00),('1','151','755','257593',4903782,'2120','314',1393827.24,1394763.90,0.00,0.00,936.66,599462.40,0.00,0.00,0.00),('1','151','755','257594',4903783,'2119','314',2112659.25,2113797.35,0.00,0.00,1138.10,728384.00,0.00,0.00,0.00),('1','151','755','257594',4903784,'2120','314',1394763.90,1395559.51,0.00,0.00,795.61,509190.40,0.00,0.00,0.00),('1','151','755','257595',4903785,'2119','314',2113797.35,2114963.03,0.00,0.00,1165.68,746035.20,0.00,0.00,0.00),('1','151','755','257595',4903786,'2120','314',1395559.51,1396536.08,0.00,0.00,976.57,625004.80,0.00,0.00,0.00),('1','151','755','257596',4903787,'2119','314',2114963.03,2116089.92,0.00,0.00,1126.89,716727.04,0.00,0.00,0.00),('1','151','755','257596',4903788,'2120','314',1396536.08,1397306.67,0.00,0.00,770.59,490145.24,0.00,0.00,0.00),('1','151','755','257597',4903789,'2119','314',2116089.92,2116365.34,0.00,0.00,275.42,175167.12,0.00,0.00,0.00),('1','151','755','257597',4903790,'2120','314',1397306.67,1397560.85,0.00,0.00,254.18,161658.48,0.00,0.00,0.00),('1','151','755','257598',4903791,'2119','314',2116365.34,2116811.41,0.00,0.00,446.07,283700.52,0.00,0.00,0.00),('1','151','755','257598',4903792,'2120','314',1397560.85,1398085.15,0.00,0.00,524.30,333454.80,0.00,0.00,0.00),('1','151','755','257599',4903793,'2119','314',2116811.41,2117797.02,0.00,0.00,985.61,626847.96,0.00,0.00,0.00),('1','151','755','257599',4903794,'2120','314',1398085.15,1398882.58,0.00,0.00,797.43,507165.48,0.00,0.00,0.00),('1','151','755','257600',4903795,'2119','314',2117797.02,2118305.62,0.00,0.00,508.60,323469.60,0.00,0.00,0.00),('1','151','755','257600',4903796,'2120','314',1398882.58,1399601.78,0.00,0.00,719.20,457411.20,0.00,0.00,0.00),('1','151','755','257601',4903797,'2119','314',2118305.62,2119151.63,0.00,0.00,846.01,538062.36,0.00,0.00,0.00),('1','151','755','257601',4903798,'2120','314',1399601.78,1400391.73,0.00,0.00,789.95,502408.20,0.00,0.00,0.00),('1','151','755','257602',4903799,'2119','314',2119151.63,2119595.65,0.00,0.00,444.02,282396.72,0.00,0.00,0.00),('1','151','755','257602',4903800,'2120','314',1400391.73,1400462.61,0.00,0.00,70.88,45079.68,0.00,0.00,0.00),('1','151','755','257603',4903801,'2119','314',2119595.65,2120557.58,0.00,0.00,961.93,611787.48,0.00,0.00,0.00),('1','151','755','257603',4903802,'2120','314',1400462.61,1401350.05,0.00,0.00,887.44,564411.84,0.00,0.00,0.00),('1','151','755','257604',4903803,'2119','314',2120557.58,2121882.18,0.00,0.00,1324.60,842445.60,0.00,0.00,0.00),('1','151','755','257604',4903804,'2120','314',1401350.05,1402140.46,0.00,0.00,790.41,502700.76,0.00,0.00,0.00),('1','151','755','257605',4903805,'2119','314',2121882.18,2122824.08,0.00,0.00,941.90,599048.40,0.00,0.00,0.00),('1','151','755','257605',4903806,'2120','314',1402140.46,1403132.24,0.00,0.00,991.78,630772.08,0.00,0.00,0.00),('1','151','755','257606',4903807,'2119','314',2122824.08,2123816.84,0.00,0.00,992.76,631395.36,0.00,0.00,0.00),('1','151','755','257606',4903808,'2120','314',1403132.24,1404196.81,0.00,0.00,1064.57,677066.52,0.00,0.00,0.00),('1','151','755','257607',4903809,'2119','314',2123816.84,2124824.80,0.00,0.00,1007.96,641062.56,0.00,0.00,0.00),('1','151','755','257607',4903810,'2120','314',1404196.81,1405454.76,0.00,0.00,1257.95,800056.20,0.00,0.00,0.00),('1','151','755','257608',4903811,'2119','314',2124824.80,2124824.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257608',4903812,'2120','314',1405454.76,1405454.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257609',4903813,'2119','314',2124824.80,2126274.31,0.00,0.00,1449.51,921888.36,0.00,0.00,0.00),('1','151','755','257609',4903814,'2120','314',1405454.76,1406513.04,0.00,0.00,1058.28,673066.08,0.00,0.00,0.00),('1','151','755','257610',4903815,'2119','314',2126274.31,2127276.28,0.00,0.00,1001.97,637252.92,0.00,0.00,0.00),('1','151','755','257610',4903816,'2120','314',1406513.04,1407550.28,0.00,0.00,1037.24,659684.64,0.00,0.00,0.00),('1','151','755','257611',4903817,'2119','314',2127276.28,2128946.85,0.00,0.00,1670.57,1062482.52,0.00,0.00,0.00),('1','151','755','257611',4903818,'2120','314',1407550.28,1408801.49,0.00,0.00,1251.21,795769.56,0.00,0.00,0.00),('1','151','755','257612',4903819,'2119','314',2128946.85,2129615.98,0.00,0.00,669.13,425566.68,0.00,0.00,0.00),('1','151','755','257612',4903820,'2120','314',1408801.49,1409269.72,0.00,0.00,468.23,297794.28,0.00,0.00,0.00),('1','151','755','257613',4903821,'2119','314',2129615.98,2129615.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257613',4903822,'2120','314',1409269.72,1409269.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257614',4903823,'2119','314',2129615.98,2129615.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257614',4903824,'2120','314',1409269.72,1409269.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257615',4903825,'2119','314',2129615.98,2129615.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257615',4903826,'2120','314',1409269.72,1409269.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257616',4903827,'2119','314',2129615.98,2130560.43,0.00,0.00,944.45,600670.20,0.00,0.00,0.00),('1','151','755','257616',4903828,'2120','314',1409269.72,1409882.99,0.00,0.00,613.27,390039.72,0.00,0.00,0.00),('1','151','755','257617',4903829,'2119','314',2130560.43,2131549.17,0.00,0.00,988.74,628838.64,0.00,0.00,0.00),('1','151','755','257617',4903830,'2120','314',1409882.99,1410709.57,0.00,0.00,826.58,525704.88,0.00,0.00,0.00),('1','151','755','257618',4903831,'2119','314',2131549.17,2132191.09,0.00,0.00,641.92,408261.12,0.00,0.00,0.00),('1','151','755','257618',4903832,'2120','314',1410709.57,1411211.05,0.00,0.00,501.48,318941.28,0.00,0.00,0.00),('1','151','755','257619',4903833,'2119','314',2132191.09,2132524.31,0.00,0.00,333.22,211927.92,0.00,0.00,0.00),('1','151','755','257619',4903834,'2120','314',1411211.05,1411433.25,0.00,0.00,222.20,141319.20,0.00,0.00,0.00),('1','151','755','257620',4903835,'2119','314',2132524.31,2133681.18,0.00,0.00,1156.87,735769.32,0.00,0.00,0.00),('1','151','755','257620',4903836,'2120','314',1411433.25,1412658.45,0.00,0.00,1225.20,779227.20,0.00,0.00,0.00),('1','151','755','257621',4903837,'2119','314',2133681.18,2134656.02,0.00,0.00,974.84,619998.24,0.00,0.00,0.00),('1','151','755','257621',4903838,'2120','314',1412658.45,1413254.81,0.00,0.00,596.36,379284.96,0.00,0.00,0.00),('1','151','755','257622',4903839,'2119','314',2134656.02,2135808.11,0.00,0.00,1152.09,732729.24,0.00,0.00,0.00),('1','151','755','257622',4903840,'2120','314',1413254.81,1414576.21,0.00,0.00,1321.40,840410.40,0.00,0.00,0.00),('1','151','755','257623',4903841,'2119','314',2135808.11,2137242.39,0.00,0.00,1434.28,912202.08,0.00,0.00,0.00),('1','151','755','257623',4903842,'2120','314',1414576.21,1415372.98,0.00,0.00,796.77,506745.72,0.00,0.00,0.00),('1','151','755','257624',4903843,'2119','314',2137242.39,2138258.63,0.00,0.00,1016.24,646328.64,0.00,0.00,0.00),('1','151','755','257624',4903844,'2120','314',1415372.98,1416551.25,0.00,0.00,1178.27,749379.72,0.00,0.00,0.00),('1','151','755','257625',4903845,'2119','314',2138258.63,2139681.92,0.00,0.00,1423.29,905212.44,0.00,0.00,0.00),('1','151','755','257625',4903846,'2120','314',1416551.25,1417665.64,0.00,0.00,1114.39,708752.04,0.00,0.00,0.00),('1','151','755','257626',4903847,'2119','314',2139681.92,2140757.44,0.00,0.00,1075.52,684030.72,0.00,0.00,0.00),('1','151','755','257626',4903848,'2120','314',1417665.64,1418879.69,0.00,0.00,1214.05,772135.80,0.00,0.00,0.00),('1','151','755','257627',4903849,'2119','314',2140757.44,2142118.38,0.00,0.00,1360.94,865557.84,0.00,0.00,0.00),('1','151','755','257627',4903850,'2120','314',1418879.69,1419761.72,0.00,0.00,882.03,560971.08,0.00,0.00,0.00),('1','151','755','257628',4903851,'2119','314',2142118.38,2143305.16,0.00,0.00,1186.78,754792.08,0.00,0.00,0.00),('1','151','755','257628',4903852,'2120','314',1419761.72,1420322.24,0.00,0.00,560.52,356490.72,0.00,0.00,0.00),('1','151','755','257629',4903853,'2119','314',2143305.16,2143338.75,0.00,0.00,33.59,21363.24,0.00,0.00,0.00),('1','151','755','257629',4903854,'2120','314',1420322.24,1420322.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257630',4903855,'2119','314',2143338.75,2144615.92,0.00,0.00,1277.17,812280.12,0.00,0.00,0.00),('1','151','755','257630',4903856,'2120','314',1420322.24,1421142.06,0.00,0.00,819.82,521405.52,0.00,0.00,0.00),('1','151','755','257631',4903857,'2119','314',2144615.92,2145314.18,0.00,0.00,698.26,485988.96,0.00,0.00,0.00),('1','151','755','257631',4903858,'2120','314',1421142.06,1422050.73,0.00,0.00,908.67,632434.32,0.00,0.00,0.00),('1','151','755','257632',4903859,'2119','314',2145314.18,2146635.41,0.00,0.00,1321.23,919576.08,0.00,0.00,0.00),('1','151','755','257632',4903860,'2120','314',1422050.73,1422782.99,0.00,0.00,732.26,509652.96,0.00,0.00,0.00),('1','151','755','257633',4903861,'2119','314',2146635.41,2147482.37,0.00,0.00,846.96,589484.16,0.00,0.00,0.00),('1','151','755','257633',4903862,'2120','314',1422782.99,1423946.10,0.00,0.00,1163.11,809524.56,0.00,0.00,0.00),('1','151','755','257634',4903863,'2119','314',2147482.37,2147987.56,0.00,0.00,505.19,351612.24,0.00,0.00,0.00),('1','151','755','257634',4903864,'2120','314',1423946.10,1424189.74,0.00,0.00,243.64,169573.44,0.00,0.00,0.00),('1','151','755','257635',4903865,'2119','314',2147987.56,2148714.76,0.00,0.00,727.20,506131.20,0.00,0.00,0.00),('1','151','755','257635',4903866,'2120','314',1424189.74,1424722.33,0.00,0.00,532.59,370682.64,0.00,0.00,0.00),('1','151','755','257636',4903867,'2119','314',2148714.76,2149566.12,0.00,0.00,851.36,592546.56,0.00,0.00,0.00),('1','151','755','257636',4903868,'2120','314',1424722.33,1425724.77,0.00,0.00,1002.44,697698.24,0.00,0.00,0.00),('1','151','755','257637',4903869,'2119','314',2149566.12,2150468.28,0.00,0.00,902.16,627903.36,0.00,0.00,0.00),('1','151','755','257637',4903870,'2120','314',1425724.77,1426369.93,0.00,0.00,645.16,449031.36,0.00,0.00,0.00),('1','151','755','257638',4903871,'2119','314',2150468.28,2150622.87,0.00,0.00,154.59,107020.24,0.00,0.00,0.00),('1','151','755','257638',4903872,'2120','314',1426369.93,1426494.58,0.00,0.00,124.65,86183.44,0.00,0.00,0.00),('1','151','755','257639',4903873,'2119','314',2150622.87,2151513.19,0.00,0.00,890.32,605417.60,0.00,0.00,0.00),('1','151','755','257639',4903874,'2120','314',1426494.58,1427468.71,0.00,0.00,974.13,662408.40,0.00,0.00,0.00),('1','151','755','257640',4903875,'2119','314',2151513.19,2152624.09,0.00,0.00,1110.90,755412.00,0.00,0.00,0.00),('1','151','755','257640',4903876,'2120','314',1427468.71,1428281.47,0.00,0.00,812.76,552676.80,0.00,0.00,0.00),('1','151','755','257641',4903877,'2119','314',2152624.09,2152899.95,0.00,0.00,275.86,187584.80,0.00,0.00,0.00),('1','151','755','257641',4903878,'2120','314',1428281.47,1428504.46,0.00,0.00,222.99,151633.20,0.00,0.00,0.00),('1','151','755','257642',4903879,'2119','314',2152899.95,2153520.91,0.00,0.00,620.96,422252.80,0.00,0.00,0.00),('1','151','755','257642',4903880,'2120','314',1428504.46,1429128.35,0.00,0.00,623.89,424245.20,0.00,0.00,0.00),('1','151','755','257643',4903881,'2119','314',2153520.91,2154769.41,0.00,0.00,1248.50,848980.00,0.00,0.00,0.00),('1','151','755','257643',4903882,'2120','314',1429128.35,1430022.93,0.00,0.00,894.58,608314.40,0.00,0.00,0.00),('1','151','755','257644',4903883,'2119','314',2154769.41,2155820.92,0.00,0.00,1051.51,778117.40,0.00,0.00,0.00),('1','151','755','257644',4903884,'2120','314',1430022.93,1431110.83,0.00,0.00,1087.90,805046.00,0.00,0.00,0.00),('1','151','755','257645',4903885,'2119','314',2155820.92,2156769.23,0.00,0.00,948.31,701749.40,0.00,0.00,0.00),('1','151','755','257645',4903886,'2120','314',1431110.83,1431822.32,0.00,0.00,711.49,526502.60,0.00,0.00,0.00),('1','151','755','257646',4903887,'2119','314',2156769.23,2156989.30,0.00,0.00,220.07,162851.80,0.00,0.00,0.00),('1','151','755','257646',4903888,'2120','314',1431822.32,1431988.49,0.00,0.00,166.17,122965.80,0.00,0.00,0.00),('1','151','755','257647',4903889,'2119','314',2156989.30,2157709.31,0.00,0.00,720.01,532807.40,0.00,0.00,0.00),('1','151','755','257647',4903890,'2120','314',1431988.49,1432585.46,0.00,0.00,596.97,441757.80,0.00,0.00,0.00),('1','151','755','257648',4903891,'2119','314',2157709.31,2158970.19,0.00,0.00,1260.88,933051.20,0.00,0.00,0.00),('1','151','755','257648',4903892,'2120','314',1432585.46,1433512.01,0.00,0.00,926.55,685647.00,0.00,0.00,0.00),('1','151','755','257649',4903893,'2119','314',2158970.19,2159892.65,0.00,0.00,922.46,645722.00,0.00,0.00,0.00),('1','151','755','257649',4903894,'2120','314',1433512.01,1434429.90,0.00,0.00,917.89,642523.00,0.00,0.00,0.00),('1','151','755','257650',4903895,'2119','314',2159892.65,2161392.30,0.00,0.00,1499.65,1049755.00,0.00,0.00,0.00),('1','151','755','257650',4903896,'2120','314',1434429.90,1435391.75,0.00,0.00,961.85,673295.00,0.00,0.00,0.00),('1','151','755','257651',4903897,'2119','314',2161392.30,2161792.49,0.00,0.00,400.19,272129.20,0.00,0.00,0.00),('1','151','755','257651',4903898,'2120','314',1435391.75,1435512.29,0.00,0.00,120.54,81967.20,0.00,0.00,0.00),('1','151','755','257652',4903899,'2119','314',2161792.49,2162518.03,0.00,0.00,725.54,493367.20,0.00,0.00,0.00),('1','151','755','257652',4903900,'2120','314',1435512.29,1436171.48,0.00,0.00,659.19,448249.20,0.00,0.00,0.00),('1','151','755','257653',4903901,'2119','314',2162518.03,2164228.74,0.00,0.00,1710.71,1163282.80,0.00,0.00,0.00),('1','151','755','257653',4903902,'2120','314',1436171.48,1437118.33,0.00,0.00,946.85,643858.00,0.00,0.00,0.00),('1','151','755','257654',4903903,'2119','314',2164228.74,2164610.72,0.00,0.00,381.98,259746.40,0.00,0.00,0.00),('1','151','755','257654',4903904,'2120','314',1437118.33,1437426.23,0.00,0.00,307.90,209372.00,0.00,0.00,0.00),('1','151','755','257655',4903905,'2119','314',2164610.72,2166092.44,0.00,0.00,1481.72,1007569.60,0.00,0.00,0.00),('1','151','755','257655',4903906,'2120','314',1437426.23,1438619.47,0.00,0.00,1193.24,811403.20,0.00,0.00,0.00),('1','151','755','257656',4903907,'2119','314',2166092.44,2166911.91,0.00,0.00,819.47,557239.60,0.00,0.00,0.00),('1','151','755','257656',4903908,'2120','314',1438619.47,1439637.23,0.00,0.00,1017.76,692076.80,0.00,0.00,0.00),('1','151','755','257657',4903909,'2119','314',2166911.91,2168541.75,0.00,0.00,1629.84,1108291.20,0.00,0.00,0.00),('1','151','755','257657',4903910,'2120','314',1439637.23,1440463.82,0.00,0.00,826.59,562081.20,0.00,0.00,0.00),('1','151','755','257658',4903911,'2119','314',2168541.75,2169541.06,0.00,0.00,999.31,679530.80,0.00,0.00,0.00),('1','151','755','257658',4903912,'2120','314',1440463.82,1441515.62,0.00,0.00,1051.80,715224.00,0.00,0.00,0.00),('1','151','755','257659',4903913,'2119','314',2169541.06,2170995.05,0.00,0.00,1453.99,988713.20,0.00,0.00,0.00),('1','151','755','257659',4903914,'2120','314',1441515.62,1442639.47,0.00,0.00,1123.85,764218.00,0.00,0.00,0.00),('1','151','755','257660',4903915,'2119','314',2170995.05,2171135.40,0.00,0.00,140.35,95438.00,0.00,0.00,0.00),('1','151','755','257660',4903916,'2120','314',1442639.47,1442724.02,0.00,0.00,84.55,57494.00,0.00,0.00,0.00),('1','151','755','257661',4903917,'2119','314',2171135.40,2171135.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257661',4903918,'2120','314',1442724.02,1442724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257662',4903919,'2119','314',2171135.40,2172077.95,0.00,0.00,942.55,654281.60,0.00,0.00,0.00),('1','151','755','257662',4903920,'2120','314',1442724.02,1443577.06,0.00,0.00,853.04,588820.00,0.00,0.00,0.00),('1','151','755','257663',4903921,'2119','314',2172077.95,2173222.52,0.00,0.00,1144.57,778307.60,0.00,0.00,0.00),('1','151','755','257663',4903922,'2120','314',1443577.06,1444623.59,0.00,0.00,1046.53,711640.40,0.00,0.00,0.00),('1','151','755','257664',4903923,'2119','314',2173222.52,2173404.65,0.00,0.00,182.13,123848.40,0.00,0.00,0.00),('1','151','755','257664',4903924,'2120','314',1444623.59,1444824.98,0.00,0.00,201.39,136945.20,0.00,0.00,0.00),('1','151','755','257665',4903925,'2119','314',2173404.65,2174073.44,0.00,0.00,668.79,501592.50,0.00,0.00,0.00),('1','151','755','257665',4903926,'2120','314',1444824.98,1445519.07,0.00,0.00,694.09,520567.50,0.00,0.00,0.00),('1','151','755','257666',4903927,'2119','314',2174073.44,2175135.87,0.00,0.00,1062.43,796822.50,0.00,0.00,0.00),('1','151','755','257666',4903928,'2120','314',1445519.07,1446627.34,0.00,0.00,1108.27,831202.50,0.00,0.00,0.00),('1','151','755','257667',4903929,'2119','314',2175135.87,2175657.33,0.00,0.00,521.46,391095.00,0.00,0.00,0.00),('1','151','755','257667',4903930,'2120','314',1446627.34,1447080.30,0.00,0.00,452.96,339720.00,0.00,0.00,0.00),('1','151','755','257668',4903931,'2119','314',2175657.33,2175958.34,0.00,0.00,301.01,225757.50,0.00,0.00,0.00),('1','151','755','257668',4903932,'2120','314',1447080.30,1447408.01,0.00,0.00,327.71,245782.50,0.00,0.00,0.00),('1','151','755','257669',4903933,'2119','314',2175958.34,2177470.00,0.00,0.00,1511.66,1133745.00,0.00,0.00,0.00),('1','151','755','257669',4903934,'2120','314',1447408.01,1448640.27,0.00,0.00,1232.26,924195.00,0.00,0.00,0.00),('1','151','755','257670',4903935,'2119','314',2177470.00,2178091.92,0.00,0.00,621.92,466440.00,0.00,0.00,0.00),('1','151','755','257670',4903936,'2120','314',1448640.27,1449183.05,0.00,0.00,542.78,407085.00,0.00,0.00,0.00),('1','151','755','257671',4903937,'2119','314',2178091.92,2178575.95,0.00,0.00,484.03,363022.50,0.00,0.00,0.00),('1','151','755','257671',4903938,'2120','314',1449183.05,1449552.51,0.00,0.00,369.46,277095.00,0.00,0.00,0.00),('1','151','755','257672',4903939,'2119','314',2178575.95,2180032.63,0.00,0.00,1456.68,1092510.00,0.00,0.00,0.00),('1','151','755','257672',4903940,'2120','314',1449552.51,1450583.85,0.00,0.00,1031.34,773505.00,0.00,0.00,0.00),('1','151','755','257673',4903941,'2119','314',2180032.63,2180559.40,0.00,0.00,526.77,395077.50,0.00,0.00,0.00),('1','151','755','257673',4903942,'2120','314',1450583.85,1451225.93,0.00,0.00,642.08,481560.00,0.00,0.00,0.00),('1','151','755','257674',4903943,'2119','314',2180559.40,2180988.21,0.00,0.00,428.81,321607.50,0.00,0.00,0.00),('1','151','755','257674',4903944,'2120','314',1451225.93,1451613.89,0.00,0.00,387.96,290970.00,0.00,0.00,0.00),('1','151','755','257675',4903945,'2119','314',2180988.21,2182293.56,0.00,0.00,1305.35,979012.50,0.00,0.00,0.00),('1','151','755','257675',4903946,'2120','314',1451613.89,1452328.42,0.00,0.00,714.53,535897.50,0.00,0.00,0.00),('1','151','755','257676',4903947,'2119','314',2182293.56,2183171.54,0.00,0.00,877.98,658485.00,0.00,0.00,0.00),('1','151','755','257676',4903948,'2120','314',1452328.42,1453150.01,0.00,0.00,821.59,616192.50,0.00,0.00,0.00),('1','151','755','257677',4903949,'2119','314',2183171.54,2183445.59,0.00,0.00,274.05,205537.50,0.00,0.00,0.00),('1','151','755','257677',4903950,'2120','314',1453150.01,1453309.38,0.00,0.00,159.37,119527.50,0.00,0.00,0.00),('1','151','755','257678',4903951,'2119','314',2183445.59,2184584.17,0.00,0.00,1138.58,853935.00,0.00,0.00,0.00),('1','151','755','257678',4903952,'2120','314',1453309.38,1454214.30,0.00,0.00,904.92,678690.00,0.00,0.00,0.00),('1','151','755','257679',4903953,'2119','314',2184584.17,2184584.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257679',4903954,'2120','314',1454214.30,1454214.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257680',4903955,'2119','314',2184584.17,2185762.36,0.00,0.00,1178.19,883642.50,0.00,0.00,0.00),('1','151','755','257680',4903956,'2120','314',1454214.30,1455053.03,0.00,0.00,838.73,629047.50,0.00,0.00,0.00),('1','151','755','257681',4903957,'2119','314',2185762.36,2186331.41,0.00,0.00,569.05,426787.50,0.00,0.00,0.00),('1','151','755','257681',4903958,'2120','314',1455053.03,1455414.06,0.00,0.00,361.03,270772.50,0.00,0.00,0.00),('1','151','755','257682',4903959,'2119','314',2186331.41,2186612.69,0.00,0.00,281.28,210960.00,0.00,0.00,0.00),('1','151','755','257682',4903960,'2120','314',1455414.06,1455636.66,0.00,0.00,222.60,166950.00,0.00,0.00,0.00),('1','151','755','257683',4903961,'2119','314',2186612.69,2187847.16,0.00,0.00,1234.47,925852.50,0.00,0.00,0.00),('1','151','755','257683',4903962,'2120','314',1455636.66,1456582.34,0.00,0.00,945.68,709260.00,0.00,0.00,0.00),('1','151','755','257684',4903963,'2119','314',2187847.16,2188969.31,0.00,0.00,1122.15,841612.50,0.00,0.00,0.00),('1','151','755','257684',4903964,'2120','314',1456582.34,1457364.38,0.00,0.00,782.04,586530.00,0.00,0.00,0.00),('1','151','755','257685',4903965,'2119','314',2188969.31,2190092.70,0.00,0.00,1123.39,842542.50,0.00,0.00,0.00),('1','151','755','257685',4903966,'2120','314',1457364.38,1458206.09,0.00,0.00,841.71,631282.50,0.00,0.00,0.00),('1','151','755','257686',4903967,'2119','314',2190092.70,2191208.08,0.00,0.00,1115.38,836535.00,0.00,0.00,0.00),('1','151','755','257686',4903968,'2120','314',1458206.09,1459041.41,0.00,0.00,835.32,626490.00,0.00,0.00,0.00),('1','151','755','257687',4903969,'2119','314',2191208.08,2191599.09,0.00,0.00,391.01,293257.50,0.00,0.00,0.00),('1','151','755','257687',4903970,'2120','314',1459041.41,1459345.64,0.00,0.00,304.23,228172.50,0.00,0.00,0.00),('1','151','755','257688',4903971,'2119','314',2191599.09,2192173.72,0.00,0.00,574.63,430972.50,0.00,0.00,0.00),('1','151','755','257688',4903972,'2120','314',1459345.64,1459855.87,0.00,0.00,510.23,382672.50,0.00,0.00,0.00),('1','151','755','257689',4903973,'2119','314',2192173.72,2193737.31,0.00,0.00,1563.59,1172692.50,0.00,0.00,0.00),('1','151','755','257689',4903974,'2120','314',1459855.87,1460820.47,0.00,0.00,964.60,723450.00,0.00,0.00,0.00),('1','151','755','257690',4903975,'2119','314',2193737.31,2193737.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257690',4903976,'2120','314',1460820.47,1460820.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257691',4903977,'2119','314',2193737.31,2194250.36,0.00,0.00,513.05,384787.50,0.00,0.00,0.00),('1','151','755','257691',4903978,'2120','314',1460820.47,1461263.78,0.00,0.00,443.31,332482.50,0.00,0.00,0.00),('1','151','755','257692',4903979,'2119','314',2194250.36,2194527.13,0.00,0.00,276.77,207577.50,0.00,0.00,0.00),('1','151','755','257692',4903980,'2120','314',1461263.78,1461582.03,0.00,0.00,318.25,238687.50,0.00,0.00,0.00),('1','151','755','257693',4903981,'2119','314',2194527.13,2196262.75,0.00,0.00,1735.62,1301715.00,0.00,0.00,0.00),('1','151','755','257693',4903982,'2120','314',1461582.03,1462405.04,0.00,0.00,823.01,617257.50,0.00,0.00,0.00),('1','151','755','257694',4903983,'2119','314',2196262.75,2197133.62,0.00,0.00,870.87,653152.50,0.00,0.00,0.00),('1','151','755','257694',4903984,'2120','314',1462405.04,1463149.78,0.00,0.00,744.74,558555.00,0.00,0.00,0.00),('1','151','755','257695',4903985,'2119','314',2197133.62,2198766.98,0.00,0.00,1633.36,1225020.00,0.00,0.00,0.00),('1','151','755','257695',4903986,'2120','314',1463149.78,1464323.84,0.00,0.00,1174.06,880545.00,0.00,0.00,0.00),('1','151','755','257696',4903987,'2119','314',2198766.98,2199907.09,0.00,0.00,1140.11,855082.50,0.00,0.00,0.00),('1','151','755','257696',4903988,'2120','314',1464323.84,1465357.15,0.00,0.00,1033.31,774982.50,0.00,0.00,0.00),('1','151','755','257697',4903989,'2119','314',2199907.09,2200561.18,0.00,0.00,654.09,490567.50,0.00,0.00,0.00),('1','151','755','257697',4903990,'2120','314',1465357.15,1465877.60,0.00,0.00,520.45,390337.50,0.00,0.00,0.00),('1','151','755','257698',4903991,'2119','314',2200561.18,2200561.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257698',4903992,'2120','314',1465877.60,1465877.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257699',4903993,'2119','314',2200561.18,2200851.55,0.00,0.00,290.37,217777.50,0.00,0.00,0.00),('1','151','755','257699',4903994,'2120','314',1465877.60,1465976.59,0.00,0.00,98.99,74242.50,0.00,0.00,0.00),('1','151','755','257700',4903995,'2119','314',2200851.55,2201950.51,0.00,0.00,1098.96,824220.00,0.00,0.00,0.00),('1','151','755','257700',4903996,'2120','314',1465976.59,1466880.85,0.00,0.00,904.26,678195.00,0.00,0.00,0.00),('1','151','755','257701',4903997,'2119','314',2201950.51,2203222.51,0.00,0.00,1272.00,954000.00,0.00,0.00,0.00),('1','151','755','257701',4903998,'2120','314',1466880.85,1467832.75,0.00,0.00,951.90,713925.00,0.00,0.00,0.00),('1','151','755','257702',4903999,'2119','314',2203222.51,2204910.80,0.00,0.00,1688.29,1266217.50,0.00,0.00,0.00),('1','151','755','257702',4904000,'2120','314',1467832.75,1469154.34,0.00,0.00,1321.59,831703.74,0.00,0.00,0.00),('1','151','755','257703',4904001,'2119','314',2204910.80,2206123.06,0.00,0.00,1212.26,909195.00,0.00,0.00,0.00),('1','151','755','257703',4904002,'2120','314',1469154.34,1470838.52,0.00,0.00,1684.18,1263135.00,0.00,0.00,0.00),('1','151','755','257704',4904003,'2119','314',2206123.06,2207872.64,0.00,0.00,1749.58,1312185.00,0.00,0.00,0.00),('1','151','755','257704',4904004,'2120','314',1470838.52,1472679.91,0.00,0.00,1841.39,1381042.50,0.00,0.00,0.00),('1','151','755','257705',4904005,'2119','314',2207872.64,2209002.51,0.00,0.00,1129.87,847402.50,0.00,0.00,0.00),('1','151','755','257705',4904006,'2120','314',1472679.91,1473712.52,0.00,0.00,1032.61,774457.50,0.00,0.00,0.00),('1','151','755','257706',4904007,'2119','314',2209002.51,2209573.65,0.00,0.00,571.14,428355.00,0.00,0.00,0.00),('1','151','755','257706',4904008,'2120','314',1473712.52,1474589.43,0.00,0.00,876.91,657682.50,0.00,0.00,0.00),('1','151','755','257707',4904009,'2119','314',2209573.65,2210250.04,0.00,0.00,676.39,507292.50,0.00,0.00,0.00),('1','151','755','257707',4904010,'2120','314',1474589.43,1475388.03,0.00,0.00,798.60,598950.00,0.00,0.00,0.00),('1','151','755','257708',4904011,'2119','314',2210250.04,2210952.19,0.00,0.00,702.15,526612.50,0.00,0.00,0.00),('1','151','755','257708',4904012,'2120','314',1475388.03,1476202.63,0.00,0.00,814.60,610950.00,0.00,0.00,0.00),('1','151','755','257709',4904013,'2119','314',2210952.19,2211819.56,0.00,0.00,867.37,650527.50,0.00,0.00,0.00),('1','151','755','257709',4904014,'2120','314',1476202.63,1477302.00,0.00,0.00,1099.37,824527.50,0.00,0.00,0.00),('1','151','755','257710',4904015,'2119','314',2211819.56,2212911.42,0.00,0.00,1091.86,818895.00,0.00,0.00,0.00),('1','151','755','257710',4904016,'2120','314',1477302.00,1478270.69,0.00,0.00,968.69,726517.50,0.00,0.00,0.00),('1','151','755','257711',4904017,'2119','314',2212911.42,2212919.37,0.00,0.00,7.95,5962.50,0.00,0.00,0.00),('1','151','755','257711',4904018,'2120','314',1478270.69,1478291.88,0.00,0.00,21.19,15892.50,0.00,0.00,0.00),('1','151','755','257712',4904019,'2119','314',2212919.37,2213615.03,0.00,0.00,695.66,521745.00,0.00,0.00,0.00),('1','151','755','257712',4904020,'2120','314',1478291.88,1478980.72,0.00,0.00,688.84,516630.00,0.00,0.00,0.00),('1','151','755','257713',4904021,'2119','314',2213615.03,2214586.30,0.00,0.00,971.27,728452.50,0.00,0.00,0.00),('1','151','755','257713',4904022,'2120','314',1478980.72,1480021.24,0.00,0.00,1040.52,780390.00,0.00,0.00,0.00),('1','151','755','257714',4904023,'2119','314',2214586.30,2215491.97,0.00,0.00,905.67,599504.37,0.00,0.00,0.00),('1','151','755','257714',4904024,'2120','314',1480021.24,1481278.92,0.00,0.00,1257.68,943260.00,0.00,0.00,0.00),('1','151','755','257715',4904025,'2119','314',2215491.97,2216568.96,0.00,0.00,1076.99,807742.50,0.00,0.00,0.00),('1','151','755','257715',4904026,'2120','314',1481278.92,1482527.26,0.00,0.00,1248.34,936255.00,0.00,0.00,0.00),('1','151','755','257716',4904027,'2119','314',2216568.96,2218023.44,0.00,0.00,1454.48,1090860.00,0.00,0.00,0.00),('1','151','755','257716',4904028,'2120','314',1482527.26,1483810.98,0.00,0.00,1283.72,962790.00,0.00,0.00,0.00),('1','151','755','257717',4904029,'2119','314',2218023.44,2219189.39,0.00,0.00,1165.95,874462.50,0.00,0.00,0.00),('1','151','755','257717',4904030,'2120','314',1483810.98,1484924.68,0.00,0.00,1113.70,835275.00,0.00,0.00,0.00),('1','151','755','257718',4904031,'2119','314',2219189.39,2220351.34,0.00,0.00,1161.95,871462.50,0.00,0.00,0.00),('1','151','755','257718',4904032,'2120','314',1484924.68,1485901.83,0.00,0.00,977.15,732862.50,0.00,0.00,0.00),('1','151','755','257719',4904033,'2119','314',2220351.34,2221231.29,0.00,0.00,879.95,659962.50,0.00,0.00,0.00),('1','151','755','257719',4904034,'2120','314',1485901.83,1486674.58,0.00,0.00,772.75,579562.50,0.00,0.00,0.00),('1','151','755','257720',4904035,'2119','314',2221231.29,2222066.93,0.00,0.00,835.64,626730.00,0.00,0.00,0.00),('1','151','755','257720',4904036,'2120','314',1486674.58,1487722.44,0.00,0.00,1047.86,785895.00,0.00,0.00,0.00),('1','151','755','257721',4904037,'2119','314',2222066.93,2222826.67,0.00,0.00,759.74,569805.00,0.00,0.00,0.00),('1','151','755','257721',4904038,'2120','314',1487722.44,1488635.25,0.00,0.00,912.81,684607.50,0.00,0.00,0.00),('1','151','755','257722',4904039,'2119','314',2222826.67,2223744.88,0.00,0.00,918.21,688657.50,0.00,0.00,0.00),('1','151','755','257722',4904040,'2120','314',1488635.25,1489681.44,0.00,0.00,1046.19,784642.50,0.00,0.00,0.00),('1','151','755','257723',4904041,'2119','314',2223744.88,2224780.41,0.00,0.00,1035.53,776647.50,0.00,0.00,0.00),('1','151','755','257723',4904042,'2120','314',1489681.44,1490958.58,0.00,0.00,1277.14,957855.00,0.00,0.00,0.00),('1','151','755','257724',4904043,'2119','314',2224780.41,2224932.62,0.00,0.00,152.21,114157.50,0.00,0.00,0.00),('1','151','755','257724',4904044,'2120','314',1490958.58,1491201.53,0.00,0.00,242.95,182212.50,0.00,0.00,0.00),('1','151','755','257725',4904045,'2119','314',2224932.62,2224932.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257725',4904046,'2120','314',1491201.53,1491201.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257726',4904047,'2119','314',2224932.62,2225760.11,0.00,0.00,827.49,620617.50,0.00,0.00,0.00),('1','151','755','257726',4904048,'2120','314',1491201.53,1492206.03,0.00,0.00,1004.50,753375.00,0.00,0.00,0.00),('1','151','755','257727',4904049,'2119','314',2225760.11,2226774.80,0.00,0.00,1014.69,761017.50,0.00,0.00,0.00),('1','151','755','257727',4904050,'2120','314',1492206.03,1493191.34,0.00,0.00,985.31,738982.50,0.00,0.00,0.00),('1','151','755','257728',4904051,'2119','314',2226774.80,2227847.03,0.00,0.00,1072.23,804172.50,0.00,0.00,0.00),('1','151','755','257728',4904052,'2120','314',1493191.34,1494231.82,0.00,0.00,1040.48,780360.00,0.00,0.00,0.00),('1','151','755','257729',4904053,'2119','314',2227847.03,2228896.83,0.00,0.00,1049.80,787350.00,0.00,0.00,0.00),('1','151','755','257729',4904054,'2120','314',1494231.82,1495083.11,0.00,0.00,851.29,638467.50,0.00,0.00,0.00),('1','151','755','257730',4904055,'2119','314',2228896.83,2229717.42,0.00,0.00,820.59,615442.50,0.00,0.00,0.00),('1','151','755','257730',4904056,'2120','314',1495083.11,1496132.23,0.00,0.00,1049.12,786840.00,0.00,0.00,0.00),('1','151','755','257731',4904057,'2119','314',2229717.42,2230825.54,0.00,0.00,1108.12,831090.00,0.00,0.00,0.00),('1','151','755','257731',4904058,'2120','314',1496132.23,1497243.94,0.00,0.00,1111.71,833782.50,0.00,0.00,0.00),('1','151','755','257732',4904059,'2119','314',2230825.54,2231797.95,0.00,0.00,972.41,729307.50,0.00,0.00,0.00),('1','151','755','257732',4904060,'2120','314',1497243.94,1498389.27,0.00,0.00,1145.33,858997.50,0.00,0.00,0.00),('1','151','755','257733',4904061,'2119','314',2231797.95,2232999.96,0.00,0.00,1202.01,901507.50,0.00,0.00,0.00),('1','151','755','257733',4904062,'2120','314',1498389.27,1499580.20,0.00,0.00,1190.93,893197.50,0.00,0.00,0.00),('1','151','755','257734',4904063,'2119','314',2232999.96,2234291.21,0.00,0.00,1291.25,968437.50,0.00,0.00,0.00),('1','151','755','257734',4904064,'2120','314',1499580.20,1501056.85,0.00,0.00,1476.65,1107487.50,0.00,0.00,0.00),('1','151','755','257735',4904065,'2119','314',2234291.21,2235438.15,0.00,0.00,1146.94,860205.00,0.00,0.00,0.00),('1','151','755','257735',4904066,'2120','314',1501056.85,1502321.88,0.00,0.00,1265.03,948772.50,0.00,0.00,0.00),('1','151','755','257736',4904067,'2119','314',2235438.15,2236531.10,0.00,0.00,1092.95,819712.50,0.00,0.00,0.00),('1','151','755','257736',4904068,'2120','314',1502321.88,1503653.75,0.00,0.00,1331.87,998902.50,0.00,0.00,0.00),('1','151','755','257737',4904069,'2119','314',2236531.10,2237882.59,0.00,0.00,1351.49,1013617.50,0.00,0.00,0.00),('1','151','755','257737',4904070,'2120','314',1503653.75,1504890.68,0.00,0.00,1236.93,927697.50,0.00,0.00,0.00),('1','151','755','257738',4904071,'2119','314',2237882.59,2238717.43,0.00,0.00,834.84,626130.00,0.00,0.00,0.00),('1','151','755','257738',4904072,'2120','314',1504890.68,1505992.29,0.00,0.00,1101.61,826207.50,0.00,0.00,0.00),('1','151','755','257739',4904073,'2119','314',2238717.43,2239964.07,0.00,0.00,1246.64,934980.00,0.00,0.00,0.00),('1','151','755','257739',4904074,'2120','314',1505992.29,1507362.32,0.00,0.00,1370.03,1027522.50,0.00,0.00,0.00),('1','151','755','257740',4904075,'2119','314',2239964.07,2240354.66,0.00,0.00,390.59,292942.50,0.00,0.00,0.00),('1','151','755','257740',4904076,'2120','314',1507362.32,1507798.85,0.00,0.00,436.53,327397.50,0.00,0.00,0.00),('1','151','755','257741',4904077,'2119','314',2240354.66,2240969.75,0.00,0.00,615.09,461317.50,0.00,0.00,0.00),('1','151','755','257741',4904078,'2120','314',1507798.85,1508351.43,0.00,0.00,552.58,414435.00,0.00,0.00,0.00),('1','151','755','257742',4904079,'2119','314',2240969.75,2242177.45,0.00,0.00,1207.70,905775.00,0.00,0.00,0.00),('1','151','755','257742',4904080,'2120','314',1508351.43,1509376.42,0.00,0.00,1024.99,768742.50,0.00,0.00,0.00),('1','151','755','257743',4904081,'2119','314',2242177.45,2242602.21,0.00,0.00,424.76,318570.00,0.00,0.00,0.00),('1','151','755','257743',4904082,'2120','314',1509376.42,1510092.95,0.00,0.00,716.53,537397.50,0.00,0.00,0.00),('1','151','755','257744',4904083,'2119','314',2242602.21,2243072.36,0.00,0.00,470.15,352612.50,0.00,0.00,0.00),('1','151','755','257744',4904084,'2120','314',1510092.95,1510565.21,0.00,0.00,472.26,354195.00,0.00,0.00,0.00),('1','151','755','257745',4904085,'2119','314',2243072.36,2244327.55,0.00,0.00,1255.19,941392.50,0.00,0.00,0.00),('1','151','755','257745',4904086,'2120','314',1510565.21,1511726.01,0.00,0.00,1160.80,870600.00,0.00,0.00,0.00),('1','151','755','257746',4904087,'2119','314',2244327.55,2244855.80,0.00,0.00,528.25,396187.50,0.00,0.00,0.00),('1','151','755','257746',4904088,'2120','314',1511726.01,1512397.54,0.00,0.00,671.53,503647.50,0.00,0.00,0.00),('1','151','755','257747',4904089,'2119','314',2244855.80,2245206.96,0.00,0.00,351.16,263370.00,0.00,0.00,0.00),('1','151','755','257747',4904090,'2120','314',1512397.54,1512832.68,0.00,0.00,435.14,326355.00,0.00,0.00,0.00),('1','151','755','257748',4904091,'2119','314',2245206.96,2246372.85,0.00,0.00,1165.89,874417.50,0.00,0.00,0.00),('1','151','755','257748',4904092,'2120','314',1512832.68,1513862.43,0.00,0.00,1029.75,772312.50,0.00,0.00,0.00),('1','151','755','257749',4904093,'2119','314',2246372.85,2247342.68,0.00,0.00,969.83,727372.50,0.00,0.00,0.00),('1','151','755','257749',4904094,'2120','314',1513862.43,1514926.47,0.00,0.00,1064.04,798030.00,0.00,0.00,0.00),('1','151','755','257750',4904095,'2119','314',2247342.68,2248657.21,0.00,0.00,1314.53,985897.50,0.00,0.00,0.00),('1','151','755','257750',4904096,'2120','314',1514926.47,1515980.35,0.00,0.00,1053.88,790410.00,0.00,0.00,0.00),('1','151','755','257751',4904097,'2119','314',2248657.21,2249453.15,0.00,0.00,795.94,596955.00,0.00,0.00,0.00),('1','151','755','257751',4904098,'2120','314',1515980.35,1517189.14,0.00,0.00,1208.79,906592.50,0.00,0.00,0.00),('1','151','755','257752',4904099,'2119','314',2249453.15,2249608.40,0.00,0.00,155.25,116437.50,0.00,0.00,0.00),('1','151','755','257752',4904100,'2120','314',1517189.14,1517248.24,0.00,0.00,59.10,44325.00,0.00,0.00,0.00),('1','151','755','257753',4904101,'2119','314',2249608.40,2250682.75,0.00,0.00,1074.35,805762.50,0.00,0.00,0.00),('1','151','755','257753',4904102,'2120','314',1517248.24,1518228.04,0.00,0.00,979.80,734850.00,0.00,0.00,0.00),('1','151','755','257754',4904103,'2119','314',2250682.75,2251737.50,0.00,0.00,1054.75,791062.50,0.00,0.00,0.00),('1','151','755','257754',4904104,'2120','314',1518228.04,1519337.14,0.00,0.00,1109.10,831825.00,0.00,0.00,0.00),('1','151','755','257755',4904105,'2119','314',2251737.50,2251953.41,0.00,0.00,215.91,161932.50,0.00,0.00,0.00),('1','151','755','257755',4904106,'2120','314',1519337.14,1519489.45,0.00,0.00,152.31,114232.50,0.00,0.00,0.00),('1','151','755','257756',4904107,'2119','314',2251953.41,2252679.57,0.00,0.00,726.16,544620.00,0.00,0.00,0.00),('1','151','755','257756',4904108,'2120','314',1519489.45,1520230.80,0.00,0.00,741.35,556012.50,0.00,0.00,0.00),('1','151','755','257757',4904109,'2119','314',2252679.57,2253610.45,0.00,0.00,930.88,698160.00,0.00,0.00,0.00),('1','151','755','257757',4904110,'2120','314',1520230.80,1521123.59,0.00,0.00,892.79,669592.50,0.00,0.00,0.00),('1','151','755','257758',4904111,'2119','314',2253610.45,2254221.93,0.00,0.00,611.48,458610.00,0.00,0.00,0.00),('1','151','755','257758',4904112,'2120','314',1521123.59,1521787.34,0.00,0.00,663.75,497812.50,0.00,0.00,0.00),('1','151','755','257759',4904113,'2119','314',2254221.93,2254368.25,0.00,0.00,146.32,109740.00,0.00,0.00,0.00),('1','151','755','257759',4904114,'2120','314',1521787.34,1521903.87,0.00,0.00,116.53,87397.50,0.00,0.00,0.00),('1','151','755','257760',4904115,'2119','314',2254368.25,2255212.52,0.00,0.00,844.27,633202.50,0.00,0.00,0.00),('1','151','755','257760',4904116,'2120','314',1521903.87,1522841.01,0.00,0.00,937.14,702855.00,0.00,0.00,0.00),('1','151','755','257761',4904117,'2119','314',2255212.52,2256289.22,0.00,0.00,1076.70,807525.00,0.00,0.00,0.00),('1','151','755','257761',4904118,'2120','314',1522841.01,1523840.80,0.00,0.00,999.79,749842.50,0.00,0.00,0.00),('1','151','755','257762',4904119,'2119','314',2256289.22,2256515.38,0.00,0.00,226.16,169620.00,0.00,0.00,0.00),('1','151','755','257762',4904120,'2120','314',1523840.80,1524060.33,0.00,0.00,219.53,164647.50,0.00,0.00,0.00),('1','151','755','257763',4904121,'2119','314',2256515.38,2256997.91,0.00,0.00,482.53,361897.50,0.00,0.00,0.00),('1','151','755','257763',4904122,'2120','314',1524060.33,1524630.48,0.00,0.00,570.15,427612.50,0.00,0.00,0.00),('1','151','755','257764',4904123,'2119','314',2256997.91,2257935.63,0.00,0.00,937.72,703290.00,0.00,0.00,0.00),('1','151','755','257764',4904124,'2120','314',1524630.48,1525674.49,0.00,0.00,1044.01,783007.50,0.00,0.00,0.00),('1','151','755','257765',4904125,'2119','314',2257935.63,2258649.00,0.00,0.00,713.37,535027.50,0.00,0.00,0.00),('1','151','755','257765',4904126,'2120','314',1525674.49,1526501.26,0.00,0.00,826.77,620077.50,0.00,0.00,0.00),('1','151','755','257766',4904127,'2119','314',2258649.00,2259826.83,0.00,0.00,1177.83,883372.50,0.00,0.00,0.00),('1','151','755','257766',4904128,'2120','314',1526501.26,1527887.35,0.00,0.00,1386.09,1039567.50,0.00,0.00,0.00),('1','151','755','257767',4904129,'2119','314',2259826.83,2260740.03,0.00,0.00,913.20,684900.00,0.00,0.00,0.00),('1','151','755','257767',4904130,'2120','314',1527887.35,1529012.28,0.00,0.00,1124.93,843697.50,0.00,0.00,0.00),('1','151','755','257768',4904131,'2119','314',2260740.03,2260970.02,0.00,0.00,229.99,172492.50,0.00,0.00,0.00),('1','151','755','257768',4904132,'2120','314',1529012.28,1529272.80,0.00,0.00,260.52,195390.00,0.00,0.00,0.00),('1','151','755','257769',4904133,'2119','314',2260970.02,2262383.58,0.00,0.00,1413.56,1060170.00,0.00,0.00,0.00),('1','151','755','257769',4904134,'2120','314',1529272.80,1530580.78,0.00,0.00,1307.98,980985.00,0.00,0.00,0.00),('1','151','755','257770',4904135,'2119','314',2262383.58,2263011.21,0.00,0.00,627.63,470722.50,0.00,0.00,0.00),('1','151','755','257770',4904136,'2120','314',1530580.78,1531301.21,0.00,0.00,720.43,540322.50,0.00,0.00,0.00),('1','151','755','257771',4904137,'2119','314',2263011.21,2263603.77,0.00,0.00,592.56,444420.00,0.00,0.00,0.00),('1','151','755','257771',4904138,'2120','314',1531301.21,1531998.53,0.00,0.00,697.32,522990.00,0.00,0.00,0.00),('1','151','755','257772',4904139,'2119','314',2263603.77,2264185.52,0.00,0.00,581.75,436312.50,0.00,0.00,0.00),('1','151','755','257772',4904140,'2120','314',1531998.53,1532672.42,0.00,0.00,673.89,505417.50,0.00,0.00,0.00),('1','151','755','257773',4904141,'2119','314',2264185.52,2264499.68,0.00,0.00,314.16,235620.00,0.00,0.00,0.00),('1','151','755','257773',4904142,'2120','314',1532672.42,1532958.74,0.00,0.00,286.32,214740.00,0.00,0.00,0.00),('1','151','755','257774',4904143,'2119','314',2264499.68,2266033.39,0.00,0.00,1533.71,1150282.50,0.00,0.00,0.00),('1','151','755','257774',4904144,'2120','314',1532958.74,1534417.34,0.00,0.00,1458.60,1093950.00,0.00,0.00,0.00),('1','151','755','257775',4904145,'2119','314',2266033.39,2266461.07,0.00,0.00,427.68,320760.00,0.00,0.00,0.00),('1','151','755','257775',4904146,'2120','314',1534417.34,1534934.91,0.00,0.00,517.57,388177.50,0.00,0.00,0.00),('1','151','755','257776',4904147,'2119','314',2266461.07,2267086.58,0.00,0.00,625.51,469132.50,0.00,0.00,0.00),('1','151','755','257776',4904148,'2120','314',1534934.91,1535497.62,0.00,0.00,562.71,422032.50,0.00,0.00,0.00),('1','151','755','257777',4904149,'2119','314',2267086.58,2268271.20,0.00,0.00,1184.62,888465.00,0.00,0.00,0.00),('1','151','755','257777',4904150,'2120','314',1535497.62,1536672.10,0.00,0.00,1174.48,880860.00,0.00,0.00,0.00),('1','151','755','257778',4904151,'2119','314',2268271.20,2268769.52,0.00,0.00,498.32,373740.00,0.00,0.00,0.00),('1','151','755','257778',4904152,'2120','314',1536672.10,1537180.33,0.00,0.00,508.23,381172.50,0.00,0.00,0.00),('1','151','755','257779',4904153,'2119','314',2268769.52,2269441.96,0.00,0.00,672.44,504330.00,0.00,0.00,0.00),('1','151','755','257779',4904154,'2120','314',1537180.33,1537957.99,0.00,0.00,777.66,583245.00,0.00,0.00,0.00),('1','151','755','257780',4904155,'2119','314',2269441.96,2270906.90,0.00,0.00,1464.94,1098705.00,0.00,0.00,0.00),('1','151','755','257780',4904156,'2120','314',1537957.99,1539415.47,0.00,0.00,1457.48,1093110.00,0.00,0.00,0.00),('1','151','755','257781',4904157,'2119','314',2270906.90,2270952.31,0.00,0.00,45.41,34057.50,0.00,0.00,0.00),('1','151','755','257781',4904158,'2120','314',1539415.47,1539512.63,0.00,0.00,97.16,72870.00,0.00,0.00,0.00),('1','151','755','257782',4904159,'2119','314',2270952.31,2271951.28,0.00,0.00,998.97,749227.50,0.00,0.00,0.00),('1','151','755','257782',4904160,'2120','314',1539512.63,1540478.13,0.00,0.00,965.50,724125.00,0.00,0.00,0.00),('1','151','755','257783',4904161,'2119','314',2271951.28,2273049.37,0.00,0.00,1098.09,823567.50,0.00,0.00,0.00),('1','151','755','257783',4904162,'2120','314',1540478.13,1541535.01,0.00,0.00,1056.88,792660.00,0.00,0.00,0.00),('1','151','755','257784',4904163,'2119','314',2273049.37,2273332.81,0.00,0.00,283.44,212580.00,0.00,0.00,0.00),('1','151','755','257784',4904164,'2120','314',1541535.01,1541728.59,0.00,0.00,193.58,145185.00,0.00,0.00,0.00),('1','151','755','257785',4904165,'2119','314',2273332.81,2273629.56,0.00,0.00,296.75,222562.50,0.00,0.00,0.00),('1','151','755','257785',4904166,'2120','314',1541728.59,1541973.27,0.00,0.00,244.68,183510.00,0.00,0.00,0.00),('1','151','755','257786',4904167,'2119','314',2273629.56,2274844.58,0.00,0.00,1215.02,911265.00,0.00,0.00,0.00),('1','151','755','257786',4904168,'2120','314',1541973.27,1543138.91,0.00,0.00,1165.64,874230.00,0.00,0.00,0.00),('1','151','755','257787',4904169,'2119','314',2274844.58,2275633.82,0.00,0.00,789.24,591930.00,0.00,0.00,0.00),('1','151','755','257787',4904170,'2120','314',1543138.91,1543966.88,0.00,0.00,827.97,620977.50,0.00,0.00,0.00),('1','151','755','257788',4904171,'2119','314',2275633.82,2276482.97,0.00,0.00,849.15,636862.50,0.00,0.00,0.00),('1','151','755','257788',4904172,'2120','314',1543966.88,1544702.09,0.00,0.00,735.21,551407.50,0.00,0.00,0.00),('1','151','755','257789',4904173,'2119','314',2276482.97,2277983.01,0.00,0.00,1500.04,1125030.00,0.00,0.00,0.00),('1','151','755','257789',4904174,'2120','314',1544702.09,1546102.29,0.00,0.00,1400.20,1050150.00,0.00,0.00,0.00),('1','151','755','257790',4904175,'2119','314',2277983.01,2277985.28,0.00,0.00,2.27,1702.50,0.00,0.00,0.00),('1','151','755','257790',4904176,'2120','314',1546102.29,1546129.78,0.00,0.00,27.49,20617.50,0.00,0.00,0.00),('1','151','755','257791',4904177,'2119','314',2277985.28,2279416.84,0.00,0.00,1431.56,1073670.00,0.00,0.00,0.00),('1','151','755','257791',4904178,'2120','314',1546129.78,1547676.05,0.00,0.00,1546.27,1159702.50,0.00,0.00,0.00),('1','151','755','257792',4904179,'2119','314',2279416.84,2280201.71,0.00,0.00,784.87,588652.50,0.00,0.00,0.00),('1','151','755','257792',4904180,'2120','314',1547676.05,1548463.00,0.00,0.00,786.95,590212.50,0.00,0.00,0.00),('1','151','755','257793',4904181,'2119','314',2280201.71,2280380.66,0.00,0.00,178.95,134212.50,0.00,0.00,0.00),('1','151','755','257793',4904182,'2120','314',1548463.00,1548645.91,0.00,0.00,182.91,137182.50,0.00,0.00,0.00),('1','151','755','257794',4904183,'2119','314',2280380.66,2281739.06,0.00,0.00,1358.40,1018800.00,0.00,0.00,0.00),('1','151','755','257794',4904184,'2120','314',1548645.91,1549605.96,0.00,0.00,960.05,720037.50,0.00,0.00,0.00),('1','151','755','257795',4904185,'2119','314',2281739.06,2282758.23,0.00,0.00,1019.17,764377.50,0.00,0.00,0.00),('1','151','755','257795',4904186,'2120','314',1549605.96,1550448.63,0.00,0.00,842.67,632002.50,0.00,0.00,0.00),('1','151','755','257796',4904187,'2119','314',2282758.23,2283385.87,0.00,0.00,627.64,470730.00,0.00,0.00,0.00),('1','151','755','257796',4904188,'2120','314',1550448.63,1551104.10,0.00,0.00,655.47,491602.50,0.00,0.00,0.00),('1','151','755','257797',4904189,'2119','314',2283385.87,2284392.53,0.00,0.00,1006.66,754995.00,0.00,0.00,0.00),('1','151','755','257797',4904190,'2120','314',1551104.10,1552005.61,0.00,0.00,901.51,676132.50,0.00,0.00,0.00),('1','151','755','257798',4904191,'2119','314',2284392.53,2285051.30,0.00,0.00,658.77,494077.50,0.00,0.00,0.00),('1','151','755','257798',4904192,'2120','314',1552005.61,1552699.89,0.00,0.00,694.28,520710.00,0.00,0.00,0.00),('1','151','755','257799',4904193,'2119','314',2285051.30,2286085.23,0.00,0.00,1033.93,775447.50,0.00,0.00,0.00),('1','151','755','257799',4904194,'2120','314',1552699.89,1553702.31,0.00,0.00,1002.42,751815.00,0.00,0.00,0.00),('1','151','755','257800',4904195,'2119','314',2286085.23,2287183.05,0.00,0.00,1097.82,823365.00,0.00,0.00,0.00),('1','151','755','257800',4904196,'2120','314',1553702.31,1554950.95,0.00,0.00,1248.64,936480.00,0.00,0.00,0.00),('1','151','755','257801',4904197,'2119','314',2287183.05,2287287.52,0.00,0.00,104.47,78352.50,0.00,0.00,0.00),('1','151','755','257801',4904198,'2120','314',1554950.95,1555055.48,0.00,0.00,104.53,78397.50,0.00,0.00,0.00),('1','151','755','257802',4904199,'2119','314',2287287.52,2288218.50,0.00,0.00,930.98,698235.00,0.00,0.00,0.00),('1','151','755','257802',4904200,'2120','314',1555055.48,1555910.03,0.00,0.00,854.55,640912.50,0.00,0.00,0.00),('1','151','755','257803',4904201,'2119','314',2288218.50,2289407.47,0.00,0.00,1188.97,891727.50,0.00,0.00,0.00),('1','151','755','257803',4904202,'2120','314',1555910.03,1557006.99,0.00,0.00,1096.96,822720.00,0.00,0.00,0.00),('1','151','755','257804',4904203,'2119','314',2289407.47,2289626.57,0.00,0.00,219.10,164325.00,0.00,0.00,0.00),('1','151','755','257804',4904204,'2120','314',1557006.99,1557270.59,0.00,0.00,263.60,197700.00,0.00,0.00,0.00),('1','151','755','257805',4904205,'2119','314',2289626.57,2290162.92,0.00,0.00,536.35,402262.50,0.00,0.00,0.00),('1','151','755','257805',4904206,'2120','314',1557270.59,1557817.43,0.00,0.00,546.84,410130.00,0.00,0.00,0.00),('1','151','755','257806',4904207,'2119','314',2290162.92,2291322.53,0.00,0.00,1159.61,869707.50,0.00,0.00,0.00),('1','151','755','257806',4904208,'2120','314',1557817.43,1558976.38,0.00,0.00,1158.95,869212.50,0.00,0.00,0.00),('1','151','755','257807',4904209,'2119','314',2291322.53,2292005.76,0.00,0.00,683.23,512422.50,0.00,0.00,0.00),('1','151','755','257807',4904210,'2120','314',1558976.38,1559468.45,0.00,0.00,492.07,369052.50,0.00,0.00,0.00),('1','151','755','257808',4904211,'2119','314',2292005.76,2292237.25,0.00,0.00,231.49,173617.50,0.00,0.00,0.00),('1','151','755','257808',4904212,'2120','314',1559468.45,1559620.02,0.00,0.00,151.57,113677.50,0.00,0.00,0.00),('1','151','755','257809',4904213,'2119','314',2292237.25,2293297.03,0.00,0.00,1059.78,794835.00,0.00,0.00,0.00),('1','151','755','257809',4904214,'2120','314',1559620.02,1560598.90,0.00,0.00,978.88,734160.00,0.00,0.00,0.00),('1','151','755','257810',4904215,'2119','314',2293297.03,2294304.29,0.00,0.00,1007.26,755445.00,0.00,0.00,0.00),('1','151','755','257810',4904216,'2120','314',1560598.90,1561735.27,0.00,0.00,1136.37,852277.50,0.00,0.00,0.00),('1','151','755','257811',4904217,'2119','314',2294304.29,2295394.68,0.00,0.00,1090.39,817792.50,0.00,0.00,0.00),('1','151','755','257811',4904218,'2120','314',1561735.27,1562733.84,0.00,0.00,998.57,748927.50,0.00,0.00,0.00),('1','151','755','257812',4904219,'2119','314',2295394.68,2296481.61,0.00,0.00,1086.93,815197.50,0.00,0.00,0.00),('1','151','755','257812',4904220,'2120','314',1562733.84,1564109.32,0.00,0.00,1375.48,1031610.00,0.00,0.00,0.00),('1','151','755','257813',4904221,'2119','314',2296481.61,2297314.88,0.00,0.00,833.27,624952.50,0.00,0.00,0.00),('1','151','755','257813',4904222,'2120','314',1564109.32,1565074.70,0.00,0.00,965.38,724035.00,0.00,0.00,0.00),('1','151','755','257814',4904223,'2119','314',2297314.88,2298321.48,0.00,0.00,1006.60,754950.00,0.00,0.00,0.00),('1','151','755','257814',4904224,'2120','314',1565074.70,1566180.23,0.00,0.00,1105.53,829147.50,0.00,0.00,0.00),('1','151','755','257815',4904225,'2119','314',2298321.48,2298603.82,0.00,0.00,282.34,211755.00,0.00,0.00,0.00),('1','151','755','257815',4904226,'2120','314',1566180.23,1566544.00,0.00,0.00,363.77,272827.50,0.00,0.00,0.00),('1','151','755','257816',4904227,'2119','314',2298603.82,2299089.53,0.00,0.00,485.71,364282.50,0.00,0.00,0.00),('1','151','755','257816',4904228,'2120','314',1566544.00,1567082.32,0.00,0.00,538.32,403740.00,0.00,0.00,0.00),('1','151','755','257817',4904229,'2119','314',2299089.53,2300121.14,0.00,0.00,1031.61,773707.50,0.00,0.00,0.00),('1','151','755','257817',4904230,'2120','314',1567082.32,1568017.41,0.00,0.00,935.09,701317.50,0.00,0.00,0.00),('1','151','755','257818',4904231,'2119','314',2300121.14,2300913.68,0.00,0.00,792.54,594405.00,0.00,0.00,0.00),('1','151','755','257818',4904232,'2120','314',1568017.41,1568791.35,0.00,0.00,773.94,580455.00,0.00,0.00,0.00),('1','151','755','257819',4904233,'2119','314',2300913.68,2301005.06,0.00,0.00,91.38,68535.00,0.00,0.00,0.00),('1','151','755','257819',4904234,'2120','314',1568791.35,1568911.23,0.00,0.00,119.88,89910.00,0.00,0.00,0.00),('1','151','755','257820',4904235,'2119','314',2301005.06,2301806.63,0.00,0.00,801.57,601177.50,0.00,0.00,0.00),('1','151','755','257820',4904236,'2120','314',1568911.23,1569649.89,0.00,0.00,738.66,553995.00,0.00,0.00,0.00),('1','151','755','257821',4904237,'2119','314',2301806.63,2303167.71,0.00,0.00,1361.08,1020810.00,0.00,0.00,0.00),('1','151','755','257821',4904238,'2120','314',1569649.89,1570827.09,0.00,0.00,1177.20,882900.00,0.00,0.00,0.00),('1','151','755','257822',4904239,'2119','314',2303167.71,2304017.60,0.00,0.00,849.89,637417.50,0.00,0.00,0.00),('1','151','755','257822',4904240,'2120','314',1570827.09,1571574.42,0.00,0.00,747.33,560497.50,0.00,0.00,0.00),('1','151','755','257823',4904241,'2119','314',2304017.60,2304178.25,0.00,0.00,160.65,120487.50,0.00,0.00,0.00),('1','151','755','257823',4904242,'2120','314',1571574.42,1571740.09,0.00,0.00,165.67,124252.50,0.00,0.00,0.00),('1','151','755','257824',4904243,'2119','314',2304178.25,2304502.79,0.00,0.00,324.54,243405.00,0.00,0.00,0.00),('1','151','755','257824',4904244,'2120','314',1571740.09,1571933.25,0.00,0.00,193.16,144870.00,0.00,0.00,0.00),('1','151','755','257825',4904245,'2119','314',2304502.79,2305462.36,0.00,0.00,959.57,719677.50,0.00,0.00,0.00),('1','151','755','257825',4904246,'2120','314',1571933.25,1572848.52,0.00,0.00,915.27,686452.50,0.00,0.00,0.00),('1','151','755','257826',4904247,'2119','314',2305462.36,2306215.98,0.00,0.00,753.62,565215.00,0.00,0.00,0.00),('1','151','755','257826',4904248,'2120','314',1572848.52,1573704.47,0.00,0.00,855.95,641962.50,0.00,0.00,0.00),('1','151','755','257827',4904249,'2119','314',2306215.98,2306495.08,0.00,0.00,279.10,209325.00,0.00,0.00,0.00),('1','151','755','257827',4904250,'2120','314',1573704.47,1573947.55,0.00,0.00,243.08,182310.00,0.00,0.00,0.00),('1','151','755','257828',4904251,'2119','314',2306495.08,2307161.69,0.00,0.00,666.61,499957.50,0.00,0.00,0.00),('1','151','755','257828',4904252,'2120','314',1573947.55,1574556.93,0.00,0.00,609.38,457035.00,0.00,0.00,0.00),('1','151','755','257829',4904253,'2119','314',2307161.69,2308318.51,0.00,0.00,1156.82,867615.00,0.00,0.00,0.00),('1','151','755','257829',4904254,'2120','314',1574556.93,1575513.05,0.00,0.00,956.12,717090.00,0.00,0.00,0.00),('1','151','755','257830',4904255,'2119','314',2308318.51,2308861.88,0.00,0.00,543.37,407527.50,0.00,0.00,0.00),('1','151','755','257830',4904256,'2120','314',1575513.05,1576084.28,0.00,0.00,571.23,428422.50,0.00,0.00,0.00),('1','151','755','257831',4904257,'2119','314',2308861.88,2308861.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257831',4904258,'2120','314',1576084.28,1576084.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257832',4904259,'2119','314',2308861.88,2308866.55,0.00,0.00,4.67,3502.50,0.00,0.00,0.00),('1','151','755','257832',4904260,'2120','314',1576084.28,1576202.38,0.00,0.00,118.10,88575.00,0.00,0.00,0.00),('1','151','755','257833',4904261,'2119','314',2308866.55,2309918.45,0.00,0.00,1051.90,788925.00,0.00,0.00,0.00),('1','151','755','257833',4904262,'2120','314',1576202.38,1577286.77,0.00,0.00,1084.39,813292.50,0.00,0.00,0.00),('1','151','755','257834',4904263,'2119','314',2309918.45,2310994.93,0.00,0.00,1076.48,807360.00,0.00,0.00,0.00),('1','151','755','257834',4904264,'2120','314',1577286.77,1578406.49,0.00,0.00,1119.72,839790.00,0.00,0.00,0.00),('1','151','755','257835',4904265,'2119','314',2310994.93,2311644.32,0.00,0.00,649.39,487042.50,0.00,0.00,0.00),('1','151','755','257835',4904266,'2120','314',1578406.49,1578981.90,0.00,0.00,575.41,431557.50,0.00,0.00,0.00),('1','151','755','257836',4904267,'2119','314',2311644.32,2311859.77,0.00,0.00,215.45,161587.50,0.00,0.00,0.00),('1','151','755','257836',4904268,'2120','314',1578981.90,1579230.91,0.00,0.00,249.01,186757.50,0.00,0.00,0.00),('1','151','755','257837',4904269,'2119','314',2311859.77,2312716.77,0.00,0.00,857.00,642750.00,0.00,0.00,0.00),('1','151','755','257837',4904270,'2120','314',1579230.91,1580019.74,0.00,0.00,788.83,591622.50,0.00,0.00,0.00),('1','151','755','257838',4904271,'2119','314',2312716.77,2313741.34,0.00,0.00,1024.57,768427.50,0.00,0.00,0.00),('1','151','755','257838',4904272,'2120','314',1580019.74,1581013.65,0.00,0.00,993.91,745432.50,0.00,0.00,0.00),('1','151','755','257839',4904273,'2119','314',2313741.34,2314146.83,0.00,0.00,405.49,304117.50,0.00,0.00,0.00),('1','151','755','257839',4904274,'2120','314',1581013.65,1581475.81,0.00,0.00,462.16,346620.00,0.00,0.00,0.00),('1','151','755','257840',4904275,'2119','314',2314146.83,2314502.87,0.00,0.00,356.04,267030.00,0.00,0.00,0.00),('1','151','755','257840',4904276,'2120','314',1581475.81,1581907.12,0.00,0.00,431.31,323482.50,0.00,0.00,0.00),('1','151','755','257841',4904277,'2119','314',2314502.87,2315473.10,0.00,0.00,970.23,756779.40,0.00,0.00,0.00),('1','151','755','257841',4904278,'2120','314',1581907.12,1582821.47,0.00,0.00,914.35,713193.00,0.00,0.00,0.00),('1','151','755','257842',4904279,'2119','314',2315473.10,2316413.95,0.00,0.00,940.85,733863.00,0.00,0.00,0.00),('1','151','755','257842',4904280,'2120','314',1582821.47,1583748.66,0.00,0.00,927.19,723208.20,0.00,0.00,0.00),('1','151','755','257843',4904281,'2119','314',2316413.95,2317023.41,0.00,0.00,609.46,475378.80,0.00,0.00,0.00),('1','151','755','257843',4904282,'2120','314',1583748.66,1584431.74,0.00,0.00,683.08,532802.40,0.00,0.00,0.00),('1','151','755','257844',4904283,'2119','314',2317023.41,2318708.61,0.00,0.00,1685.20,1314456.00,0.00,0.00,0.00),('1','151','755','257844',4904284,'2120','314',1584431.74,1585982.83,0.00,0.00,1551.09,1209850.20,0.00,0.00,0.00),('1','151','755','257845',4904285,'2119','314',2318708.61,2319726.55,0.00,0.00,1017.94,793993.20,0.00,0.00,0.00),('1','151','755','257845',4904286,'2120','314',1585982.83,1587304.39,0.00,0.00,1321.56,1030816.80,0.00,0.00,0.00),('1','151','755','257846',4904287,'2119','314',2319726.55,2320380.97,0.00,0.00,654.42,510447.60,0.00,0.00,0.00),('1','151','755','257846',4904288,'2120','314',1587304.39,1587987.85,0.00,0.00,683.46,533098.80,0.00,0.00,0.00),('1','151','755','257847',4904289,'2119','314',2320380.97,2322097.23,0.00,0.00,1716.26,1338682.80,0.00,0.00,0.00),('1','151','755','257847',4904290,'2120','314',1587987.85,1588327.79,0.00,0.00,339.94,265153.20,0.00,0.00,0.00),('1','151','755','257848',4904291,'2119','314',2322097.23,2322493.63,0.00,0.00,396.40,309192.00,0.00,0.00,0.00),('1','151','755','257848',4904292,'2120','314',1588327.79,1588979.33,0.00,0.00,651.54,508201.20,0.00,0.00,0.00),('1','151','755','257849',4904293,'2119','314',2322493.63,2322493.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257849',4904294,'2120','314',1588979.33,1589079.74,0.00,0.00,100.41,78319.80,0.00,0.00,0.00),('1','151','755','257850',4904295,'2119','314',2322493.63,2323404.69,0.00,0.00,911.06,710626.80,0.00,0.00,0.00),('1','151','755','257850',4904296,'2120','314',1589079.74,1590178.01,0.00,0.00,1098.27,856650.60,0.00,0.00,0.00),('1','151','755','257851',4904297,'2119','314',2323404.69,2324336.15,0.00,0.00,931.46,726538.80,0.00,0.00,0.00),('1','151','755','257851',4904298,'2120','314',1590178.01,1591081.29,0.00,0.00,903.28,704558.40,0.00,0.00,0.00),('1','151','755','257852',4904299,'2119','314',2324336.15,2324604.79,0.00,0.00,268.64,209539.20,0.00,0.00,0.00),('1','151','755','257852',4904300,'2120','314',1591081.29,1591333.69,0.00,0.00,252.40,196872.00,0.00,0.00,0.00),('1','151','755','257853',4904301,'2119','314',2324604.79,2325073.18,0.00,0.00,468.39,365344.20,0.00,0.00,0.00),('1','151','755','257853',4904302,'2120','314',1591333.69,1591795.70,0.00,0.00,462.01,360367.80,0.00,0.00,0.00),('1','151','755','257854',4904303,'2119','314',2325073.18,2326047.85,0.00,0.00,974.67,760242.60,0.00,0.00,0.00),('1','151','755','257854',4904304,'2120','314',1591795.70,1592717.07,0.00,0.00,921.37,718668.60,0.00,0.00,0.00),('1','151','755','257855',4904305,'2119','314',2326047.85,2326883.85,0.00,0.00,836.00,652080.00,0.00,0.00,0.00),('1','151','755','257855',4904306,'2120','314',1592717.07,1593551.04,0.00,0.00,833.97,650496.60,0.00,0.00,0.00),('1','151','755','257856',4904307,'2119','314',2326883.85,2327716.18,0.00,0.00,832.33,649217.40,0.00,0.00,0.00),('1','151','755','257856',4904308,'2120','314',1593551.04,1594475.72,0.00,0.00,924.68,721250.40,0.00,0.00,0.00),('1','151','755','257857',4904309,'2119','314',2327716.18,2328811.45,0.00,0.00,1095.27,854310.60,0.00,0.00,0.00),('1','151','755','257857',4904310,'2120','314',1594475.72,1595588.63,0.00,0.00,1112.91,868069.80,0.00,0.00,0.00),('1','151','755','257858',4904311,'2119','314',2328811.45,2329078.30,0.00,0.00,266.85,208143.00,0.00,0.00,0.00),('1','151','755','257858',4904312,'2120','314',1595588.63,1595870.59,0.00,0.00,281.96,219928.80,0.00,0.00,0.00),('1','151','755','257859',4904313,'2119','314',2329078.30,2329529.51,0.00,0.00,451.21,351943.80,0.00,0.00,0.00),('1','151','755','257859',4904314,'2120','314',1595870.59,1596374.46,0.00,0.00,503.87,393018.60,0.00,0.00,0.00),('1','151','755','257860',4904315,'2119','314',2329529.51,2330227.96,0.00,0.00,698.45,544791.00,0.00,0.00,0.00),('1','151','755','257860',4904316,'2120','314',1596374.46,1596992.79,0.00,0.00,618.33,482297.40,0.00,0.00,0.00),('1','151','755','257861',4904317,'2119','314',2330227.96,2331125.27,0.00,0.00,897.31,699901.80,0.00,0.00,0.00),('1','151','755','257861',4904318,'2120','314',1596992.79,1597928.46,0.00,0.00,935.67,729822.60,0.00,0.00,0.00),('1','151','755','257862',4904319,'2119','314',2331125.27,2331363.49,0.00,0.00,238.22,185811.60,0.00,0.00,0.00),('1','151','755','257862',4904320,'2120','314',1597928.46,1598156.00,0.00,0.00,227.54,177481.20,0.00,0.00,0.00),('1','151','755','257863',4904321,'2119','314',2331363.49,2331921.33,0.00,0.00,557.84,435115.20,0.00,0.00,0.00),('1','151','755','257863',4904322,'2120','314',1598156.00,1598696.24,0.00,0.00,540.24,421387.20,0.00,0.00,0.00),('1','151','755','257864',4904323,'2119','314',2331921.33,2333067.67,0.00,0.00,1146.34,894145.20,0.00,0.00,0.00),('1','151','755','257864',4904324,'2120','314',1598696.24,1599813.82,0.00,0.00,1117.58,871712.40,0.00,0.00,0.00),('1','151','755','257865',4904325,'2119','314',2333067.67,2333958.70,0.00,0.00,891.03,695003.40,0.00,0.00,0.00),('1','151','755','257865',4904326,'2120','314',1599813.82,1600622.05,0.00,0.00,808.23,630419.40,0.00,0.00,0.00),('1','151','755','257866',4904327,'2119','314',2333958.70,2334625.29,0.00,0.00,666.59,519940.20,0.00,0.00,0.00),('1','151','755','257866',4904328,'2120','314',1600622.05,1601320.85,0.00,0.00,698.80,545064.00,0.00,0.00,0.00),('1','151','755','257867',4904329,'2119','314',2334625.29,2335643.37,0.00,0.00,1018.08,794102.40,0.00,0.00,0.00),('1','151','755','257867',4904330,'2120','314',1601320.85,1602316.13,0.00,0.00,995.28,776318.40,0.00,0.00,0.00),('1','151','755','257868',4904331,'2119','314',2335643.37,2336495.04,0.00,0.00,851.67,664302.60,0.00,0.00,0.00),('1','151','755','257868',4904332,'2120','314',1602316.13,1603259.53,0.00,0.00,943.40,735852.00,0.00,0.00,0.00),('1','151','755','257869',4904333,'2119','314',2336495.04,2336903.94,0.00,0.00,408.90,318942.00,0.00,0.00,0.00),('1','151','755','257869',4904334,'2120','314',1603259.53,1603695.71,0.00,0.00,436.18,340220.40,0.00,0.00,0.00),('1','151','755','257870',4904335,'2119','314',2336903.94,2336987.41,0.00,0.00,83.47,65106.60,0.00,0.00,0.00),('1','151','755','257870',4904336,'2120','314',1603695.71,1603780.49,0.00,0.00,84.78,66128.40,0.00,0.00,0.00),('1','151','755','257871',4904337,'2119','314',2336987.41,2337648.27,0.00,0.00,660.86,515470.80,0.00,0.00,0.00),('1','151','755','257871',4904338,'2120','314',1603780.49,1604551.92,0.00,0.00,771.43,601715.40,0.00,0.00,0.00),('1','151','755','257872',4904339,'2119','314',2337648.27,2338638.88,0.00,0.00,990.61,772675.80,0.00,0.00,0.00),('1','151','755','257872',4904340,'2120','314',1604551.92,1605572.69,0.00,0.00,1020.77,796200.60,0.00,0.00,0.00),('1','151','755','257873',4904341,'2119','314',2338638.88,2340033.31,0.00,0.00,1394.43,1037883.04,0.00,0.00,0.00),('1','151','755','257873',4904342,'2120','314',1605572.69,1606854.37,0.00,0.00,1281.68,952318.00,0.00,0.00,0.00),('1','151','755','257874',4904343,'2119','314',2340033.31,2340946.10,0.00,0.00,912.79,671813.44,0.00,0.00,0.00),('1','151','755','257874',4904344,'2120','314',1606854.37,1607769.91,0.00,0.00,915.54,673837.44,0.00,0.00,0.00),('1','151','755','257875',4904345,'2119','314',2340946.10,2341832.40,0.00,0.00,886.30,652316.80,0.00,0.00,0.00),('1','151','755','257875',4904346,'2120','314',1607769.91,1608726.56,0.00,0.00,956.65,704094.40,0.00,0.00,0.00),('1','151','755','257876',4904347,'2119','314',2341832.40,2342984.56,0.00,0.00,1152.16,847989.76,0.00,0.00,0.00),('1','151','755','257876',4904348,'2120','314',1608726.56,1609806.26,0.00,0.00,1079.70,794659.20,0.00,0.00,0.00),('1','151','755','257877',4904349,'2119','314',2342984.56,2343650.58,0.00,0.00,666.02,490190.72,0.00,0.00,0.00),('1','151','755','257877',4904350,'2120','314',1609806.26,1611038.50,0.00,0.00,1232.24,906928.64,0.00,0.00,0.00),('1','151','755','257878',4904351,'2119','314',2343650.58,2343695.15,0.00,0.00,44.57,32803.52,0.00,0.00,0.00),('1','151','755','257878',4904352,'2120','314',1611038.50,1612678.23,0.00,0.00,1639.73,1206841.28,0.00,0.00,0.00),('1','151','755','257879',4904353,'2119','314',2343695.15,2343832.62,0.00,0.00,137.47,101177.92,0.00,0.00,0.00),('1','151','755','257879',4904354,'2120','314',1612678.23,1614470.23,0.00,0.00,1792.00,1318912.00,0.00,0.00,0.00),('1','151','755','257880',4904355,'2119','314',2343832.62,2343832.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257880',4904356,'2120','314',1614470.23,1615356.46,0.00,0.00,886.23,652265.28,0.00,0.00,0.00),('1','151','755','257881',4904357,'2119','314',2343832.62,2343859.79,0.00,0.00,27.17,19997.12,0.00,0.00,0.00),('1','151','755','257881',4904358,'2120','314',1615356.46,1616724.79,0.00,0.00,1368.33,1007090.88,0.00,0.00,0.00),('1','151','755','257882',4904359,'2119','314',2343859.79,2344273.94,0.00,0.00,414.15,304814.40,0.00,0.00,0.00),('1','151','755','257882',4904360,'2120','314',1616724.79,1618121.29,0.00,0.00,1396.50,1027824.00,0.00,0.00,0.00),('1','151','755','257883',4904361,'2119','314',2344273.94,2345388.52,0.00,0.00,1114.58,820330.88,0.00,0.00,0.00),('1','151','755','257883',4904362,'2120','314',1618121.29,1619215.82,0.00,0.00,1094.53,805574.08,0.00,0.00,0.00),('1','151','755','257884',4904363,'2119','314',2345388.52,2346571.54,0.00,0.00,1183.02,870702.72,0.00,0.00,0.00),('1','151','755','257884',4904364,'2120','314',1619215.82,1620230.28,0.00,0.00,1014.46,746642.56,0.00,0.00,0.00),('1','151','755','257885',4904365,'2119','314',2346571.54,2347507.78,0.00,0.00,936.24,689072.64,0.00,0.00,0.00),('1','151','755','257885',4904366,'2120','314',1620230.28,1621252.13,0.00,0.00,1021.85,752081.60,0.00,0.00,0.00),('1','151','755','257886',4904367,'2119','314',2347507.78,2348575.57,0.00,0.00,1067.79,785893.44,0.00,0.00,0.00),('1','151','755','257886',4904368,'2120','314',1621252.13,1622285.98,0.00,0.00,1033.85,760913.60,0.00,0.00,0.00),('1','151','755','257887',4904369,'2119','314',2348575.57,2349504.44,0.00,0.00,928.87,683648.32,0.00,0.00,0.00),('1','151','755','257887',4904370,'2120','314',1622285.98,1623142.43,0.00,0.00,856.45,630347.20,0.00,0.00,0.00),('1','151','755','257888',4904371,'2119','314',2349504.44,2350568.53,0.00,0.00,1064.09,783170.24,0.00,0.00,0.00),('1','151','755','257888',4904372,'2120','314',1623142.43,1624203.71,0.00,0.00,1061.28,781102.08,0.00,0.00,0.00),('1','151','755','257889',4904373,'2119','314',2350568.53,2351387.58,0.00,0.00,819.05,602820.80,0.00,0.00,0.00),('1','151','755','257889',4904374,'2120','314',1624203.71,1625241.71,0.00,0.00,1038.00,763968.00,0.00,0.00,0.00),('1','151','755','257890',4904375,'2119','314',2351387.58,2352516.88,0.00,0.00,1129.30,831164.80,0.00,0.00,0.00),('1','151','755','257890',4904376,'2120','314',1625241.71,1626150.58,0.00,0.00,908.87,668928.32,0.00,0.00,0.00),('1','151','755','257891',4904377,'2119','314',2352516.88,2353074.34,0.00,0.00,557.46,410290.56,0.00,0.00,0.00),('1','151','755','257891',4904378,'2120','314',1626150.58,1626750.03,0.00,0.00,599.45,441195.20,0.00,0.00,0.00),('1','151','755','257892',4904379,'2119','314',2353074.34,2353324.52,0.00,0.00,250.18,184132.48,0.00,0.00,0.00),('1','151','755','257892',4904380,'2120','314',1626750.03,1627272.04,0.00,0.00,522.01,384199.36,0.00,0.00,0.00),('1','151','755','257893',4904381,'2119','314',2353324.52,2354195.91,0.00,0.00,871.39,641343.04,0.00,0.00,0.00),('1','151','755','257893',4904382,'2120','314',1627272.04,1628002.59,0.00,0.00,730.55,537684.80,0.00,0.00,0.00),('1','151','755','257894',4904383,'2119','314',2354195.91,2355151.73,0.00,0.00,955.82,703483.52,0.00,0.00,0.00),('1','151','755','257894',4904384,'2120','314',1628002.59,1628850.39,0.00,0.00,847.80,623980.80,0.00,0.00,0.00),('1','151','755','257895',4904385,'2119','314',2355151.73,2356205.07,0.00,0.00,1053.34,775258.24,0.00,0.00,0.00),('1','151','755','257895',4904386,'2120','314',1628850.39,1629692.16,0.00,0.00,841.77,619542.72,0.00,0.00,0.00),('1','151','755','257896',4904387,'2119','314',2356205.07,2357219.23,0.00,0.00,1014.16,746421.76,0.00,0.00,0.00),('1','151','755','257896',4904388,'2120','314',1629692.16,1630724.02,0.00,0.00,1031.86,759448.96,0.00,0.00,0.00),('1','151','755','257897',4904389,'2119','314',2357219.23,2358073.35,0.00,0.00,854.12,628632.32,0.00,0.00,0.00),('1','151','755','257897',4904390,'2120','314',1630724.02,1631733.05,0.00,0.00,1009.03,742646.08,0.00,0.00,0.00),('1','151','755','257898',4904391,'2119','314',2358073.35,2359074.99,0.00,0.00,1001.64,737207.04,0.00,0.00,0.00),('1','151','755','257898',4904392,'2120','314',1631733.05,1632764.10,0.00,0.00,1031.05,758852.80,0.00,0.00,0.00),('1','151','755','257899',4904393,'2119','314',2359074.99,2360476.03,0.00,0.00,1401.04,1031165.44,0.00,0.00,0.00),('1','151','755','257899',4904394,'2120','314',1632764.10,1634054.11,0.00,0.00,1290.01,949447.36,0.00,0.00,0.00),('1','151','755','257900',4904395,'2119','314',2360476.03,2361405.97,0.00,0.00,929.94,684435.84,0.00,0.00,0.00),('1','151','755','257900',4904396,'2120','314',1634054.11,1635149.72,0.00,0.00,1095.61,806368.96,0.00,0.00,0.00),('1','151','755','257901',4904397,'2119','314',2361405.97,2362725.62,0.00,0.00,1319.65,971262.40,0.00,0.00,0.00),('1','151','755','257901',4904398,'2120','314',1635149.72,1636647.28,0.00,0.00,1497.56,1102204.16,0.00,0.00,0.00),('1','151','755','257902',4904399,'2119','314',2362725.62,2363617.55,0.00,0.00,891.93,656460.48,0.00,0.00,0.00),('1','151','755','257902',4904400,'2120','314',1636647.28,1637723.85,0.00,0.00,1076.57,792355.52,0.00,0.00,0.00),('1','151','755','257903',4904401,'2119','314',2363617.55,2364544.53,0.00,0.00,926.98,682257.28,0.00,0.00,0.00),('1','151','755','257903',4904402,'2120','314',1637723.85,1638725.12,0.00,0.00,1001.27,736934.72,0.00,0.00,0.00),('1','151','755','257904',4904403,'2119','314',2364544.53,2365137.66,0.00,0.00,593.13,436543.68,0.00,0.00,0.00),('1','151','755','257904',4904404,'2120','314',1638725.12,1639445.47,0.00,0.00,720.35,530177.60,0.00,0.00,0.00),('1','151','755','257905',4904405,'2119','314',2365137.66,2365137.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257905',4904406,'2120','314',1639445.47,1639445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257906',4904407,'2119','314',2365137.66,2365328.82,0.00,0.00,191.16,140693.76,0.00,0.00,0.00),('1','151','755','257906',4904408,'2120','314',1639445.47,1639587.97,0.00,0.00,142.50,104880.00,0.00,0.00,0.00),('1','151','755','257907',4904409,'2119','314',2365328.82,2366563.12,0.00,0.00,1234.30,908444.80,0.00,0.00,0.00),('1','151','755','257907',4904410,'2120','314',1639587.97,1640958.55,0.00,0.00,1370.58,1008746.88,0.00,0.00,0.00),('1','151','755','257908',4904411,'2119','314',2366563.12,2367284.82,0.00,0.00,721.70,531171.20,0.00,0.00,0.00),('1','151','755','257908',4904412,'2120','314',1640958.55,1641868.08,0.00,0.00,909.53,669414.08,0.00,0.00,0.00),('1','151','755','257909',4904413,'2119','314',2367284.82,2368278.43,0.00,0.00,993.61,731296.96,0.00,0.00,0.00),('1','151','755','257909',4904414,'2120','314',1641868.08,1643046.78,0.00,0.00,1178.70,867523.20,0.00,0.00,0.00),('1','151','755','257910',4904415,'2119','314',2368278.43,2369366.71,0.00,0.00,1088.28,800974.08,0.00,0.00,0.00),('1','151','755','257910',4904416,'2120','314',1643046.78,1644263.73,0.00,0.00,1216.95,895675.20,0.00,0.00,0.00),('1','151','755','257911',4904417,'2119','314',2369366.71,2370193.03,0.00,0.00,826.32,608171.52,0.00,0.00,0.00),('1','151','755','257911',4904418,'2120','314',1644263.73,1645305.17,0.00,0.00,1041.44,766499.84,0.00,0.00,0.00),('1','151','755','257912',4904419,'2119','314',2370193.03,2371373.75,0.00,0.00,1180.72,869009.92,0.00,0.00,0.00),('1','151','755','257912',4904420,'2120','314',1645305.17,1646500.41,0.00,0.00,1195.24,879696.64,0.00,0.00,0.00),('1','151','755','257913',4904421,'2119','314',2371373.75,2372518.29,0.00,0.00,1144.54,842381.44,0.00,0.00,0.00),('1','151','755','257913',4904422,'2120','314',1646500.41,1647570.26,0.00,0.00,1069.85,787409.60,0.00,0.00,0.00),('1','151','755','257914',4904423,'2119','314',2372518.29,2373691.78,0.00,0.00,1173.49,863688.64,0.00,0.00,0.00),('1','151','755','257914',4904424,'2120','314',1647570.26,1648774.64,0.00,0.00,1204.38,886423.68,0.00,0.00,0.00),('1','151','755','257915',4904425,'2119','314',2373691.78,2374757.62,0.00,0.00,1065.84,784458.24,0.00,0.00,0.00),('1','151','755','257915',4904426,'2120','314',1648774.64,1649977.04,0.00,0.00,1202.40,884966.40,0.00,0.00,0.00),('1','151','755','257916',4904427,'2119','314',2374757.62,2375782.55,0.00,0.00,1024.93,754348.48,0.00,0.00,0.00),('1','151','755','257916',4904428,'2120','314',1649977.04,1651268.92,0.00,0.00,1291.88,950823.68,0.00,0.00,0.00),('1','151','755','257917',4904429,'2119','314',2375782.55,2376850.57,0.00,0.00,1068.02,786062.72,0.00,0.00,0.00),('1','151','755','257917',4904430,'2120','314',1651268.92,1652433.39,0.00,0.00,1164.47,857049.92,0.00,0.00,0.00),('1','151','755','257918',4904431,'2119','314',2376850.57,2377768.96,0.00,0.00,918.39,675935.04,0.00,0.00,0.00),('1','151','755','257918',4904432,'2120','314',1652433.39,1653426.64,0.00,0.00,993.25,731032.00,0.00,0.00,0.00),('1','151','755','257919',4904433,'2119','314',2377768.96,2378757.78,0.00,0.00,988.82,727771.52,0.00,0.00,0.00),('1','151','755','257919',4904434,'2120','314',1653426.64,1654532.70,0.00,0.00,1106.06,814060.16,0.00,0.00,0.00),('1','151','755','257920',4904435,'2119','314',2378757.78,2378757.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257920',4904436,'2120','314',1654532.70,1654532.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257921',4904437,'2119','314',2378757.78,2379714.74,0.00,0.00,956.96,704322.56,0.00,0.00,0.00),('1','151','755','257921',4904438,'2120','314',1654532.70,1655711.94,0.00,0.00,1179.24,867920.64,0.00,0.00,0.00),('1','151','755','257922',4904439,'2119','314',2379714.74,2380559.38,0.00,0.00,844.64,621655.04,0.00,0.00,0.00),('1','151','755','257922',4904440,'2120','314',1655711.94,1656624.72,0.00,0.00,912.78,671806.08,0.00,0.00,0.00),('1','151','755','257923',4904441,'2119','314',2380559.38,2380915.66,0.00,0.00,356.28,262222.08,0.00,0.00,0.00),('1','151','755','257923',4904442,'2120','314',1656624.72,1656971.99,0.00,0.00,347.27,255590.72,0.00,0.00,0.00),('1','151','755','257924',4904443,'2119','314',2380915.66,2381690.67,0.00,0.00,775.01,570407.36,0.00,0.00,0.00),('1','151','755','257924',4904444,'2120','314',1656971.99,1657685.83,0.00,0.00,713.84,525386.24,0.00,0.00,0.00),('1','151','755','257925',4904445,'2119','314',2381690.67,2383021.22,0.00,0.00,1330.55,979284.80,0.00,0.00,0.00),('1','151','755','257925',4904446,'2120','314',1657685.83,1658870.98,0.00,0.00,1185.15,872270.40,0.00,0.00,0.00),('1','151','755','257926',4904447,'2119','314',2383021.22,2383320.25,0.00,0.00,299.03,220086.08,0.00,0.00,0.00),('1','151','755','257926',4904448,'2120','314',1658870.98,1659141.70,0.00,0.00,270.72,199249.92,0.00,0.00,0.00),('1','151','755','257927',4904449,'2119','314',2383320.25,2384146.04,0.00,0.00,825.79,607781.44,0.00,0.00,0.00),('1','151','755','257927',4904450,'2120','314',1659141.70,1660023.96,0.00,0.00,882.26,649343.36,0.00,0.00,0.00),('1','151','755','257928',4904451,'2119','314',2384146.04,2385120.58,0.00,0.00,974.54,717261.44,0.00,0.00,0.00),('1','151','755','257928',4904452,'2120','314',1660023.96,1661148.00,0.00,0.00,1124.04,827293.44,0.00,0.00,0.00),('1','151','755','257929',4904453,'2119','314',2385120.58,2385499.51,0.00,0.00,378.93,278892.48,0.00,0.00,0.00),('1','151','755','257929',4904454,'2120','314',1661148.00,1661528.40,0.00,0.00,380.40,279974.40,0.00,0.00,0.00),('1','151','755','257930',4904455,'2119','314',2385499.51,2386094.92,0.00,0.00,595.41,438221.76,0.00,0.00,0.00),('1','151','755','257930',4904456,'2120','314',1661528.40,1662070.95,0.00,0.00,542.55,399316.80,0.00,0.00,0.00),('1','151','755','257931',4904457,'2119','314',2386094.92,2387002.12,0.00,0.00,907.20,667699.20,0.00,0.00,0.00),('1','151','755','257931',4904458,'2120','314',1662070.95,1663359.06,0.00,0.00,1288.11,948048.96,0.00,0.00,0.00),('1','151','755','257932',4904459,'2119','314',2387002.12,2387519.86,0.00,0.00,517.74,381056.64,0.00,0.00,0.00),('1','151','755','257932',4904460,'2120','314',1663359.06,1664049.31,0.00,0.00,690.25,508024.00,0.00,0.00,0.00),('1','151','755','257933',4904461,'2119','314',2387519.86,2387800.30,0.00,0.00,280.44,206403.84,0.00,0.00,0.00),('1','151','755','257933',4904462,'2120','314',1664049.31,1664395.96,0.00,0.00,346.65,255134.40,0.00,0.00,0.00),('1','151','755','257934',4904463,'2119','314',2387800.30,2388645.34,0.00,0.00,845.04,621949.44,0.00,0.00,0.00),('1','151','755','257934',4904464,'2120','314',1664395.96,1665459.45,0.00,0.00,1063.49,782728.64,0.00,0.00,0.00),('1','151','755','257935',4904465,'2119','314',2388645.34,2389809.24,0.00,0.00,1163.90,856630.40,0.00,0.00,0.00),('1','151','755','257935',4904466,'2120','314',1665459.45,1666607.55,0.00,0.00,1148.10,845001.60,0.00,0.00,0.00),('1','151','755','257936',4904467,'2119','314',2389809.24,2389995.86,0.00,0.00,186.62,137352.32,0.00,0.00,0.00),('1','151','755','257936',4904468,'2120','314',1666607.55,1666827.49,0.00,0.00,219.94,161875.84,0.00,0.00,0.00),('1','151','755','257937',4904469,'2119','314',2389995.86,2390969.68,0.00,0.00,973.82,716731.52,0.00,0.00,0.00),('1','151','755','257937',4904470,'2120','314',1666827.49,1667796.19,0.00,0.00,968.70,712963.20,0.00,0.00,0.00),('1','151','755','257938',4904471,'2119','314',2390969.68,2391983.15,0.00,0.00,1013.47,745913.92,0.00,0.00,0.00),('1','151','755','257938',4904472,'2120','314',1667796.19,1668951.64,0.00,0.00,1155.45,850411.20,0.00,0.00,0.00),('1','151','755','257939',4904473,'2119','314',2391983.15,2392212.07,0.00,0.00,228.92,168485.12,0.00,0.00,0.00),('1','151','755','257939',4904474,'2120','314',1668951.64,1669212.35,0.00,0.00,260.71,191882.56,0.00,0.00,0.00),('1','151','755','257940',4904475,'2119','314',2392212.07,2392890.01,0.00,0.00,677.94,498963.84,0.00,0.00,0.00),('1','151','755','257940',4904476,'2120','314',1669212.35,1669980.60,0.00,0.00,768.25,565432.00,0.00,0.00,0.00),('1','151','755','257941',4904477,'2119','314',2392890.01,2394128.14,0.00,0.00,1238.13,911263.68,0.00,0.00,0.00),('1','151','755','257941',4904478,'2120','314',1669980.60,1671406.27,0.00,0.00,1425.67,1049293.12,0.00,0.00,0.00),('1','151','755','257942',4904479,'2119','314',2394128.14,2394388.97,0.00,0.00,260.83,191970.88,0.00,0.00,0.00),('1','151','755','257942',4904480,'2120','314',1671406.27,1671621.23,0.00,0.00,214.96,158210.56,0.00,0.00,0.00),('1','151','755','257943',4904481,'2119','314',2394388.97,2394883.24,0.00,0.00,494.27,363782.72,0.00,0.00,0.00),('1','151','755','257943',4904482,'2120','314',1671621.23,1672291.25,0.00,0.00,670.02,493134.72,0.00,0.00,0.00),('1','151','755','257944',4904483,'2119','314',2394883.24,2395847.07,0.00,0.00,963.83,709378.88,0.00,0.00,0.00),('1','151','755','257944',4904484,'2120','314',1672291.25,1673478.83,0.00,0.00,1187.58,874058.88,0.00,0.00,0.00),('1','151','755','257945',4904485,'2119','314',2395847.07,2396421.79,0.00,0.00,574.72,422993.92,0.00,0.00,0.00),('1','151','755','257945',4904486,'2120','314',1673478.83,1674117.88,0.00,0.00,639.05,470340.80,0.00,0.00,0.00),('1','151','755','257946',4904487,'2119','314',2396421.79,2396937.13,0.00,0.00,515.34,379290.24,0.00,0.00,0.00),('1','151','755','257946',4904488,'2120','314',1674117.88,1674540.02,0.00,0.00,422.14,310695.04,0.00,0.00,0.00),('1','151','755','257947',4904489,'2119','314',2396937.13,2397876.26,0.00,0.00,939.13,691199.68,0.00,0.00,0.00),('1','151','755','257947',4904490,'2120','314',1674540.02,1675406.60,0.00,0.00,866.58,637802.88,0.00,0.00,0.00),('1','151','755','257948',4904491,'2119','314',2397876.26,2398673.59,0.00,0.00,797.33,586834.88,0.00,0.00,0.00),('1','151','755','257948',4904492,'2120','314',1675406.60,1676402.68,0.00,0.00,996.08,733114.88,0.00,0.00,0.00),('1','151','755','257949',4904493,'2119','314',2398673.59,2398838.51,0.00,0.00,164.92,121381.12,0.00,0.00,0.00),('1','151','755','257949',4904494,'2120','314',1676402.68,1676539.33,0.00,0.00,136.65,100574.40,0.00,0.00,0.00),('1','151','755','257950',4904495,'2119','314',2398838.51,2399599.90,0.00,0.00,761.39,560383.04,0.00,0.00,0.00),('1','151','755','257950',4904496,'2120','314',1676539.33,1677486.68,0.00,0.00,947.35,697249.60,0.00,0.00,0.00),('1','151','755','257951',4904497,'2119','314',2399599.90,2400478.91,0.00,0.00,879.01,646951.36,0.00,0.00,0.00),('1','151','755','257951',4904498,'2120','314',1677486.68,1678328.26,0.00,0.00,841.58,619402.88,0.00,0.00,0.00),('1','151','755','257952',4904499,'2119','314',2400478.91,2401072.96,0.00,0.00,594.05,437220.80,0.00,0.00,0.00),('1','151','755','257952',4904500,'2120','314',1678328.26,1679135.35,0.00,0.00,807.09,594018.24,0.00,0.00,0.00),('1','151','755','257953',4904501,'2119','314',2401072.96,2402134.70,0.00,0.00,1061.74,781440.64,0.00,0.00,0.00),('1','151','755','257953',4904502,'2120','314',1679135.35,1680202.72,0.00,0.00,1067.37,785584.32,0.00,0.00,0.00),('1','151','755','257954',4904503,'2119','314',2402134.70,2403066.82,0.00,0.00,932.12,686040.32,0.00,0.00,0.00),('1','151','755','257954',4904504,'2120','314',1680202.72,1681237.23,0.00,0.00,1034.51,761399.36,0.00,0.00,0.00),('1','151','755','257955',4904505,'2119','314',2403066.82,2403789.97,0.00,0.00,723.15,532238.40,0.00,0.00,0.00),('1','151','755','257955',4904506,'2120','314',1681237.23,1682462.54,0.00,0.00,1225.31,901828.16,0.00,0.00,0.00),('1','151','755','257956',4904507,'2119','314',2403789.97,2404809.85,0.00,0.00,1019.88,750631.68,0.00,0.00,0.00),('1','151','755','257956',4904508,'2120','314',1682462.54,1683806.49,0.00,0.00,1343.95,989147.20,0.00,0.00,0.00),('1','151','755','257957',4904509,'2119','314',2404809.85,2405758.39,0.00,0.00,948.54,698125.44,0.00,0.00,0.00),('1','151','755','257957',4904510,'2120','314',1683806.49,1685023.22,0.00,0.00,1216.73,895513.28,0.00,0.00,0.00),('1','151','755','257958',4904511,'2119','314',2405758.39,2406722.58,0.00,0.00,964.19,709643.84,0.00,0.00,0.00),('1','151','755','257958',4904512,'2120','314',1685023.22,1686303.66,0.00,0.00,1280.44,942403.84,0.00,0.00,0.00),('1','151','755','257959',4904513,'2119','314',2406722.58,2407621.12,0.00,0.00,898.54,661325.44,0.00,0.00,0.00),('1','151','755','257959',4904514,'2120','314',1686303.66,1687897.50,0.00,0.00,1593.84,1173066.24,0.00,0.00,0.00),('1','151','755','257960',4904515,'2119','314',2407621.12,2408681.19,0.00,0.00,1060.07,780211.52,0.00,0.00,0.00),('1','151','755','257960',4904516,'2120','314',1687897.50,1688963.46,0.00,0.00,1065.96,784546.56,0.00,0.00,0.00),('1','151','755','257961',4904517,'2119','314',2408681.19,2409308.44,0.00,0.00,627.25,461656.00,0.00,0.00,0.00),('1','151','755','257961',4904518,'2120','314',1688963.46,1690111.72,0.00,0.00,1148.26,845119.36,0.00,0.00,0.00),('1','151','755','257962',4904519,'2119','314',2409308.44,2410575.90,0.00,0.00,1267.46,932850.56,0.00,0.00,0.00),('1','151','755','257962',4904520,'2120','314',1690111.72,1691509.91,0.00,0.00,1398.19,1029067.84,0.00,0.00,0.00),('1','151','755','257963',4904521,'2119','314',2410575.90,2411579.86,0.00,0.00,1003.96,738914.56,0.00,0.00,0.00),('1','151','755','257963',4904522,'2120','314',1691509.91,1692686.28,0.00,0.00,1176.37,865808.32,0.00,0.00,0.00),('1','151','755','257964',4904523,'2119','314',2411579.86,2411579.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257964',4904524,'2120','314',1692686.28,1692686.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','151','755','257965',4904525,'2119','314',2411579.86,2412641.73,0.00,0.00,1061.87,781536.32,0.00,0.00,0.00),('1','151','755','257965',4904526,'2120','314',1692686.28,1693746.64,0.00,0.00,1060.36,780424.96,0.00,0.00,0.00),('1','151','755','257966',4904527,'2119','314',2412641.73,2413585.05,0.00,0.00,943.32,694283.52,0.00,0.00,0.00),('1','151','755','257966',4904528,'2120','314',1693746.64,1694960.80,0.00,0.00,1214.16,893621.76,0.00,0.00,0.00),('1','151','755','257967',4904529,'2119','314',2413585.05,2414531.85,0.00,0.00,946.80,696844.80,0.00,0.00,0.00),('1','151','755','257967',4904530,'2120','314',1694960.80,1695872.80,0.00,0.00,912.00,671232.00,0.00,0.00,0.00),('1','151','755','257968',4904531,'2119','314',2414531.85,2415458.09,0.00,0.00,926.24,681712.64,0.00,0.00,0.00),('1','151','755','257968',4904532,'2120','314',1695872.80,1696850.28,0.00,0.00,977.48,719425.28,0.00,0.00,0.00),('1','151','755','257969',4904533,'2119','314',2415458.09,2416320.54,0.00,0.00,862.45,634763.20,0.00,0.00,0.00),('1','151','755','257969',4904534,'2120','314',1696850.28,1697856.62,0.00,0.00,1006.34,740666.24,0.00,0.00,0.00),('1','151','755','257970',4904535,'2119','314',2416320.54,2417269.11,0.00,0.00,948.57,698147.52,0.00,0.00,0.00),('1','151','755','257970',4904536,'2120','314',1697856.62,1699264.44,0.00,0.00,1407.82,1036155.52,0.00,0.00,0.00),('1','151','755','257971',4904537,'2119','314',2417269.11,2418408.61,0.00,0.00,1139.50,838672.00,0.00,0.00,0.00),('1','151','755','257971',4904538,'2120','314',1699264.44,1700599.79,0.00,0.00,1335.35,982817.60,0.00,0.00,0.00),('1','151','755','257972',4904539,'2119','314',2418408.61,2419445.26,0.00,0.00,1036.65,762974.40,0.00,0.00,0.00),('1','151','755','257972',4904540,'2120','314',1700599.79,1701842.70,0.00,0.00,1242.91,914781.76,0.00,0.00,0.00),('1','151','755','257973',4904541,'2119','314',2419445.26,2420637.22,0.00,0.00,1191.96,877282.56,0.00,0.00,0.00),('1','151','755','257973',4904542,'2120','314',1701842.70,1703024.81,0.00,0.00,1182.11,870032.96,0.00,0.00,0.00),('1','151','755','257974',4904543,'2119','314',2420637.22,2421824.96,0.00,0.00,1187.74,874176.64,0.00,0.00,0.00),('1','151','755','257974',4904544,'2120','314',1703024.81,1704165.88,0.00,0.00,1141.07,839827.52,0.00,0.00,0.00),('1','151','755','257975',4904545,'2119','314',2421824.96,2423325.93,0.00,0.00,1500.97,1104713.92,0.00,0.00,0.00),('1','151','755','257975',4904546,'2120','314',1704165.88,1705653.01,0.00,0.00,1487.13,1094527.68,0.00,0.00,0.00),('1','151','755','257976',4904547,'2119','314',2423325.93,2423687.43,0.00,0.00,361.50,266064.00,0.00,0.00,0.00),('1','151','755','257976',4904548,'2120','314',1705653.01,1706091.26,0.00,0.00,438.25,322552.00,0.00,0.00,0.00),('1','151','755','257977',4904549,'2119','314',2423687.43,2424747.05,0.00,0.00,1059.62,779880.32,0.00,0.00,0.00),('1','151','755','257977',4904550,'2120','314',1706091.26,1707139.02,0.00,0.00,1047.76,771151.36,0.00,0.00,0.00),('1','151','755','257978',4904551,'2119','314',2424747.05,2425787.39,0.00,0.00,1040.34,765690.24,0.00,0.00,0.00),('1','151','755','257978',4904552,'2120','314',1707139.02,1708257.99,0.00,0.00,1118.97,823561.92,0.00,0.00,0.00),('1','151','755','257979',4904553,'2119','314',2425787.39,2426817.49,0.00,0.00,1030.10,758153.60,0.00,0.00,0.00),('1','151','755','257979',4904554,'2120','314',1708257.99,1709305.11,0.00,0.00,1047.12,770680.32,0.00,0.00,0.00),('1','151','755','257980',4904555,'2119','314',2426817.49,2427838.52,0.00,0.00,1021.03,751478.08,0.00,0.00,0.00),('1','151','755','257980',4904556,'2120','314',1709305.11,1710310.91,0.00,0.00,1005.80,740268.80,0.00,0.00,0.00),('1','151','755','257981',4904557,'2119','314',2427838.52,2428677.60,0.00,0.00,839.08,617562.88,0.00,0.00,0.00),('1','151','755','257981',4904558,'2120','314',1710310.91,1711627.48,0.00,0.00,1316.57,968995.52,0.00,0.00,0.00),('1','151','755','257982',4904559,'2119','314',2428677.60,2429563.24,0.00,0.00,885.64,651831.04,0.00,0.00,0.00),('1','151','755','257982',4904560,'2120','314',1711627.48,1712629.98,0.00,0.00,1002.50,737840.00,0.00,0.00,0.00),('1','151','755','257983',4904561,'2119','314',2429563.24,2430372.27,0.00,0.00,809.03,595446.08,0.00,0.00,0.00),('1','151','755','257983',4904562,'2120','314',1712629.98,1713936.07,0.00,0.00,1306.09,961282.24,0.00,0.00,0.00),('1','151','755','257984',4904563,'2119','314',2430372.27,2431706.29,0.00,0.00,1334.02,981838.72,0.00,0.00,0.00),('1','151','755','257984',4904564,'2120','314',1713936.07,1714799.09,0.00,0.00,863.02,635182.72,0.00,0.00,0.00),('1','151','755','257985',4904565,'2119','314',2431706.29,2432433.17,0.00,0.00,726.88,534983.68,0.00,0.00,0.00),('1','151','755','257985',4904566,'2120','314',1714799.09,1715635.47,0.00,0.00,836.38,615575.68,0.00,0.00,0.00),('1','151','755','257986',4904567,'2119','314',2432433.17,2433727.62,0.00,0.00,1294.45,952715.20,0.00,0.00,0.00),('1','151','755','257986',4904568,'2120','314',1715635.47,1716497.19,0.00,0.00,861.72,634225.92,0.00,0.00,0.00),('1','151','755','257987',4904569,'2119','314',2433727.62,2434184.61,0.00,0.00,456.99,336344.64,0.00,0.00,0.00),('1','151','755','257987',4904570,'2120','314',1716497.19,1717372.24,0.00,0.00,875.05,644036.80,0.00,0.00,0.00),('1','151','755','257988',4904571,'2119','314',2434184.61,2434196.69,0.00,0.00,12.08,8890.88,0.00,0.00,0.00),('1','151','755','257988',4904572,'2120','314',1717372.24,1717396.82,0.00,0.00,24.58,18090.88,0.00,0.00,0.00),('1','151','755','257989',4904573,'2119','314',2434196.69,2435169.32,0.00,0.00,972.63,706129.38,0.00,0.00,0.00),('1','151','755','257989',4904574,'2120','314',1717396.82,1718184.96,0.00,0.00,788.14,572189.64,0.00,0.00,0.00),('1','151','755','257990',4904575,'2119','314',2435169.32,2435775.27,0.00,0.00,605.95,439919.70,0.00,0.00,0.00),('1','151','755','257990',4904576,'2120','314',1718184.96,1719030.89,0.00,0.00,845.93,614145.18,0.00,0.00,0.00),('1','151','755','257991',4904577,'2119','314',2435775.27,2436730.03,0.00,0.00,954.76,693155.76,0.00,0.00,0.00),('1','151','755','257991',4904578,'2120','314',1719030.89,1720095.93,0.00,0.00,1065.04,773219.04,0.00,0.00,0.00),('1','151','755','257992',4904579,'2119','314',2436730.03,2437741.44,0.00,0.00,1011.41,734283.66,0.00,0.00,0.00),('1','151','755','257992',4904580,'2120','314',1720095.93,1721234.75,0.00,0.00,1138.82,826783.32,0.00,0.00,0.00),('1','151','755','257993',4904581,'2119','314',2437741.44,2437923.23,0.00,0.00,181.79,131979.54,0.00,0.00,0.00),('1','151','755','257993',4904582,'2120','314',1721234.75,1721405.97,0.00,0.00,171.22,124305.72,0.00,0.00,0.00),('1','151','755','257994',4904583,'2119','314',2437923.23,2438310.43,0.00,0.00,387.20,281107.20,0.00,0.00,0.00),('1','151','755','257994',4904584,'2120','314',1721405.97,1721790.64,0.00,0.00,384.67,279270.42,0.00,0.00,0.00),('1','151','755','257995',4904585,'2119','314',2438310.43,2438953.31,0.00,0.00,642.88,466730.88,0.00,0.00,0.00),('1','151','755','257995',4904586,'2120','314',1721790.64,1722486.42,0.00,0.00,695.78,505136.28,0.00,0.00,0.00),('1','151','755','257996',4904587,'2119','314',2438953.31,2439965.68,0.00,0.00,1012.37,734980.62,0.00,0.00,0.00),('1','151','755','257996',4904588,'2120','314',1722486.42,1723613.77,0.00,0.00,1127.35,818456.10,0.00,0.00,0.00),('1','151','755','257997',4904589,'2119','314',2439965.68,2440097.55,0.00,0.00,131.87,95737.62,0.00,0.00,0.00),('1','151','755','257997',4904590,'2120','314',1723613.77,1723737.98,0.00,0.00,124.21,90176.46,0.00,0.00,0.00),('1','151','755','257998',4904591,'2119','314',2440097.55,2440592.16,0.00,0.00,494.61,359086.86,0.00,0.00,0.00),('1','151','755','257998',4904592,'2120','314',1723737.98,1724367.93,0.00,0.00,629.95,457343.70,0.00,0.00,0.00),('1','151','755','257999',4904593,'2119','314',2440592.16,2441696.03,0.00,0.00,1103.87,801409.62,0.00,0.00,0.00),('1','151','755','257999',4904594,'2120','314',1724367.93,1725519.03,0.00,0.00,1151.10,835698.60,0.00,0.00,0.00),('1','151','755','258000',4904595,'2119','314',2441696.03,2442274.90,0.00,0.00,578.87,420259.62,0.00,0.00,0.00),('1','151','755','258000',4904596,'2120','314',1725519.03,1726059.27,0.00,0.00,540.24,392214.24,0.00,0.00,0.00),('1','151','755','258001',4904597,'2119','314',2442274.90,2443077.43,0.00,0.00,802.53,582636.78,0.00,0.00,0.00),('1','151','755','258001',4904598,'2120','314',1726059.27,1726971.10,0.00,0.00,911.83,661988.58,0.00,0.00,0.00),('1','151','755','258002',4904599,'2119','314',2443077.43,2443896.92,0.00,0.00,819.49,594949.74,0.00,0.00,0.00),('1','151','755','258002',4904600,'2120','314',1726971.10,1727856.18,0.00,0.00,885.08,642568.08,0.00,0.00,0.00),('1','151','755','258003',4904601,'2119','314',2443896.92,2443982.65,0.00,0.00,85.73,62239.98,0.00,0.00,0.00),('1','151','755','258003',4904602,'2120','314',1727856.18,1727932.25,0.00,0.00,76.07,55226.82,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730148 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','151','142624','314',202.00,256.00,0.00,1320.11,266662.22,337948.16,71285.94,428932),('1','151','143134','314',202.00,256.00,0.00,2679.41,541240.82,685928.96,144688.14,430436),('1','151','143510','314',202.00,256.00,0.00,157.00,31714.00,40192.00,8478.00,431534),('1','151','143520','314',202.00,256.00,0.00,429.37,86732.74,109918.72,23185.98,431563),('1','151','143524','314',202.00,256.00,0.00,3569.18,720974.36,913710.08,192735.72,431573),('1','151','143648','314',202.00,256.00,0.00,446.00,90092.00,114176.00,24084.00,431917),('1','151','143655','314',202.00,256.00,0.00,1699.41,343280.82,435048.96,91768.14,431932),('1','151','143664','314',202.00,256.00,0.00,2300.59,464719.18,588951.04,124231.86,431957),('1','151','143680','314',202.00,256.00,0.00,579.00,116958.00,148224.00,31266.00,432003),('1','151','143691','314',202.00,256.00,0.00,634.18,128104.36,162350.08,34245.72,432034),('1','151','143697','314',202.00,256.00,0.00,3366.16,679964.32,861736.96,181772.64,432048),('1','151','143715','314',202.00,256.00,0.00,196.16,39624.32,50216.96,10592.64,432096),('1','151','143738','314',202.00,256.00,0.00,382.39,77242.78,97891.84,20649.06,432163),('1','151','143828','314',202.00,256.00,0.00,495.69,100129.38,126896.64,26767.26,432427),('1','151','143831','314',202.00,256.00,0.00,1703.65,344137.30,436134.40,91997.10,432434),('1','151','143836','314',202.00,256.00,0.00,1785.70,360711.40,457139.20,96427.80,432447),('1','151','143841','314',202.00,256.00,0.00,15.21,3072.42,3893.76,821.34,432460),('1','151','143855','314',202.00,256.00,0.00,616.34,124500.68,158059.52,33558.84,432500),('1','151','143861','314',202.00,256.00,0.00,3166.35,639602.70,810585.60,170982.90,432516),('1','151','143863','314',202.00,256.00,0.00,850.54,171809.08,217738.24,45929.16,432520),('1','151','143868','314',202.00,256.00,0.00,583.00,117766.00,149248.00,31482.00,432533),('1','151','143871','314',202.00,256.00,0.00,2881.21,582004.42,737589.76,155585.34,432540),('1','151','143876','314',202.00,256.00,0.00,1119.00,226038.00,286464.00,60426.00,432552),('1','151','143882','314',202.00,256.00,0.00,568.85,114907.70,145625.60,30717.90,432570),('1','151','143886','314',202.00,276.00,0.00,1300.20,262640.40,358855.20,96214.80,432580),('1','151','143890','314',202.00,276.00,0.00,2700.46,545492.92,745326.96,199834.04,432589),('1','151','143892','314',202.00,276.00,0.00,114.00,23028.00,31464.00,8436.00,432592),('1','151','143894','314',202.00,276.00,0.00,465.52,94035.04,128483.52,34448.48,432596),('1','151','143955','314',210.00,276.00,0.00,2541.61,533738.10,701484.36,167746.26,432775),('1','151','143962','314',210.00,276.00,0.00,2049.75,430447.50,565731.00,135283.50,432794),('1','151','143992','314',210.00,276.00,0.00,2595.12,544975.20,716253.12,171277.92,432881),('1','151','143997','314',210.00,276.00,0.00,1976.41,415046.10,545489.16,130443.06,432894),('1','151','144004','314',202.00,276.00,0.00,2714.95,548419.90,749326.20,200906.30,432913),('1','151','144007','314',202.00,276.00,0.00,1579.25,319008.50,435873.00,116864.50,432920),('1','151','144008','314',202.00,276.00,0.00,850.19,171738.38,234652.44,62914.06,432921),('1','151','144011','314',202.00,276.00,0.00,2613.00,527826.00,721188.00,193362.00,432928),('1','151','144087','314',202.00,276.00,0.00,1066.00,219564.00,294216.00,74652.00,433154),('1','151','144122','314',210.00,276.00,0.00,4100.95,838598.22,1131862.20,293263.98,433253),('1','151','144285','314',202.00,276.00,0.00,469.61,94861.22,129612.36,34751.14,433726),('1','151','144303','314',202.00,276.00,0.00,1981.26,400214.52,546827.76,146613.24,433776),('1','151','144435','314',210.00,276.00,0.00,2603.83,546804.30,718657.08,171852.78,434159),('1','151','144587','314',210.00,256.00,0.00,3261.94,685007.40,835056.64,150049.24,434592),('1','151','144721','314',210.00,256.00,0.00,1297.90,272559.00,332262.40,59703.40,434982),('1','151','144724','314',210.00,256.00,0.00,1070.90,224889.00,274150.40,49261.40,434989),('1','151','144831','314',210.00,256.00,0.00,2716.62,570490.20,695454.72,124964.52,435285),('1','151','144901','314',210.00,256.00,0.00,729.61,153218.10,186780.16,33562.06,435492),('1','151','144988','314',210.00,256.00,0.00,2407.49,505572.90,616317.44,110744.54,435742),('1','151','145267','314',210.00,256.00,0.00,2210.65,464236.50,565926.40,101689.90,436547),('1','151','145269','314',210.00,256.00,0.00,1110.10,233121.00,284185.60,51064.60,436551),('1','151','145273','314',210.00,256.00,0.00,3462.65,727156.50,886438.40,159281.90,436561),('1','151','145299','314',210.00,256.00,0.00,585.69,122994.90,149936.64,26941.74,436635),('1','151','145327','314',210.00,256.00,0.00,3970.75,833857.50,1016512.00,182654.50,436706),('1','151','145408','314',210.00,256.00,0.00,982.98,206425.80,251642.88,45217.08,436938),('1','151','145409','314',210.00,256.00,0.00,3593.74,754685.40,919997.44,165312.04,436939),('1','151','145466','314',210.00,256.00,0.00,4578.39,961461.90,1172067.84,210605.94,437108),('1','151','146034','314',210.00,256.00,0.00,1556.50,326865.00,398464.00,71599.00,438742),('1','151','146042','314',210.00,256.00,0.00,2396.62,503290.20,613534.72,110244.52,438764),('1','151','146046','314',210.00,256.00,0.00,629.00,132090.00,161024.00,28934.00,438774),('1','151','146049','314',210.00,256.00,0.00,2181.35,458083.50,558425.60,100342.10,438781),('1','151','146774','314',210.00,256.00,0.00,1172.56,246237.60,300175.36,53937.76,440921),('1','151','146781','314',210.00,256.00,0.00,1162.66,244158.60,297640.96,53482.36,440940),('1','151','146789','314',210.00,256.00,0.00,1160.51,243707.10,297090.56,53383.46,440962),('1','151','146793','314',210.00,256.00,0.00,2684.53,563751.30,687239.68,123488.38,440972),('1','151','146797','314',210.00,256.00,0.00,761.61,159938.10,194972.16,35034.06,440980),('1','151','146806','314',210.00,256.00,0.00,2939.44,617282.40,752496.64,135214.24,441004),('1','151','146816','314',210.00,256.00,0.00,1679.29,352650.90,429898.24,77247.34,441030),('1','151','146871','314',210.00,256.00,0.00,1610.58,338221.80,412308.48,74086.68,441189),('1','151','147166','314',210.00,256.00,0.00,3015.81,633320.10,772047.36,138727.26,441892),('1','151','147344','314',210.00,256.00,0.00,2872.15,603151.50,735270.40,132118.90,442299),('1','151','147372','314',210.00,256.00,0.00,1725.52,362359.20,441733.12,79373.92,442381),('1','151','147480','314',210.00,256.00,0.00,1101.55,231325.50,281996.80,50671.30,442671),('1','151','147560','314',210.00,256.00,0.00,3291.88,691294.80,842721.28,151426.48,442900),('1','151','147688','314',210.00,256.00,0.00,3380.48,709900.80,865402.88,155502.08,443229),('1','151','147822','314',210.00,256.00,0.00,1394.37,292817.70,356958.72,64141.02,443618),('1','151','147867','314',210.00,256.00,0.00,1658.23,348228.30,424506.88,76278.58,443728),('1','151','147987','314',207.00,256.00,0.00,2864.34,592918.38,733271.04,140352.66,444040),('1','151','148129','314',207.00,256.00,0.00,3172.92,656794.44,812267.52,155473.08,444410),('1','151','148284','314',207.00,256.00,0.00,1498.59,310208.13,383639.04,73430.91,444803),('1','151','148286','314',207.00,256.00,0.00,1167.14,241597.98,298787.84,57189.86,444805),('1','151','148429','314',207.00,256.00,0.00,2830.13,585836.91,724513.28,138676.37,445197),('1','151','148539','314',207.00,256.00,0.00,552.67,114402.69,141483.52,27080.83,445488),('1','151','148559','314',207.00,256.00,0.00,2385.19,493734.33,610608.64,116874.31,445535),('1','151','148666','314',207.00,256.00,0.00,1395.68,288905.76,357294.08,68388.32,445807),('1','151','148668','314',207.00,256.00,0.00,1160.40,240202.80,297062.40,56859.60,445811),('1','151','148806','314',207.00,256.00,0.00,3423.46,708656.22,876405.76,167749.54,446163),('1','151','148964','314',207.00,256.00,0.00,3042.33,629762.31,778836.48,149074.17,446584),('1','151','149047','314',207.00,256.00,0.00,1589.25,328974.75,406848.00,77873.25,446796),('1','151','149144','314',213.00,256.00,0.00,1254.67,267244.71,321195.52,53950.81,447068),('1','151','149299','314',213.00,256.00,0.00,3033.84,646207.92,776663.04,130455.12,447468),('1','151','149442','314',213.00,256.00,0.00,3318.17,706770.21,849451.52,142681.31,447853),('1','151','149669','314',213.00,256.00,0.00,1289.16,274591.08,330024.96,55433.88,448473),('1','151','149673','314',213.00,256.00,0.00,1966.84,418936.92,503511.04,84574.12,448483),('1','151','149674','314',213.00,256.00,0.00,2645.80,563555.40,677324.80,113769.40,448484),('1','151','149842','314',213.00,256.00,0.00,3954.60,842329.80,1012377.60,170047.80,448925),('1','151','149917','314',213.00,256.00,0.00,656.13,139755.69,167969.28,28213.59,449122),('1','151','150018','314',213.00,256.00,0.00,3184.25,678245.25,815168.00,136922.75,449385),('1','151','150135','314',213.00,256.00,0.00,2033.70,433178.10,520627.20,87449.10,449709),('1','151','150373','314',213.00,256.00,0.00,4624.47,985012.11,1183864.32,198852.21,450317),('1','151','150545','314',213.00,256.00,0.00,1565.76,333506.88,400834.56,67327.68,450785),('1','151','150707','314',213.00,256.00,0.00,3009.74,641074.62,770493.44,129418.82,451209),('1','151','150845','314',213.00,256.00,0.00,3879.00,826227.00,993024.00,166797.00,451568),('1','151','150899','314',213.00,256.00,0.00,790.00,168270.00,202240.00,33970.00,451703),('1','151','150988','314',213.00,256.00,0.00,2359.59,502592.67,604055.04,101462.37,451949),('1','151','151153','314',213.00,256.00,0.00,2282.13,486093.69,584225.28,98131.59,452397),('1','151','151279','314',213.00,256.00,0.00,3917.22,834367.86,1002808.32,168440.46,452745),('1','151','151415','314',213.00,256.00,0.00,711.53,151555.89,422816.68,271260.79,453120),('1','151','151487','314',213.00,256.00,0.00,1604.21,341696.73,410677.76,68981.03,453298),('1','151','151583','314',213.00,256.00,0.00,2967.54,632086.02,759690.24,127604.22,453573),('1','151','151697','314',213.00,256.00,0.00,4152.30,884439.90,1062988.80,178548.90,453888),('1','151','151790','314',213.00,256.00,0.00,470.45,100205.85,120435.20,20229.35,454129),('1','151','151817','314',213.00,256.00,0.00,2545.87,542270.31,651742.72,109472.41,454196),('1','151','151925','314',213.00,256.00,0.00,2083.45,443774.85,533363.20,89588.35,454490),('1','151','152007','314',213.00,256.00,0.00,1667.32,355139.16,426833.92,71694.76,454710),('1','151','152056','314',213.00,256.00,0.00,1256.93,267726.09,321774.08,54047.99,454836),('1','151','152163','314',213.00,256.00,0.00,786.36,167494.68,201308.16,33813.48,455117),('1','151','152268','314',213.00,256.00,0.00,2310.60,492157.80,591513.60,99355.80,455404),('1','151','152376','314',213.00,256.00,0.00,2098.88,447061.44,537313.28,90251.84,455683),('1','151','152426','314',213.00,256.00,0.00,2463.94,524819.22,630768.64,105949.42,455817),('1','151','152612','314',213.00,256.00,0.00,3403.21,724883.73,871221.76,146338.03,456319),('1','151','152759','314',213.00,256.00,0.00,1153.62,245721.06,295326.72,49605.66,456716),('1','151','152761','314',213.00,256.00,0.00,557.83,118817.79,142804.48,23986.69,456720),('1','151','152763','314',213.00,256.00,0.00,603.20,128481.60,154419.20,25937.60,456724),('1','151','152886','314',213.00,256.00,0.00,3079.87,656012.31,788446.72,132434.41,457059),('1','151','153026','314',213.00,256.00,0.00,183.87,39164.31,47070.72,7906.41,457446),('1','151','153032','314',213.00,272.00,0.00,162.32,34574.16,44151.04,9576.88,457458),('1','151','153081','314',213.00,272.00,0.00,2089.13,444984.69,568243.36,123258.67,457576),('1','151','153265','314',213.00,272.00,0.00,2521.64,537109.32,685886.08,148776.76,458090),('1','151','153471','314',213.00,272.00,0.00,3422.46,728983.98,930909.12,201925.14,458659),('1','151','153630','314',213.00,272.00,0.00,1177.45,250796.85,320266.40,69469.55,459083),('1','151','153636','314',213.00,272.00,0.00,1385.14,295034.82,376758.08,81723.26,459094),('1','151','153798','314',213.00,272.00,0.00,2872.82,611910.66,781407.04,169496.38,459533),('1','151','153924','314',213.00,272.00,0.00,333.05,70939.65,90589.60,19649.95,459857),('1','151','153927','314',213.00,272.00,0.00,2713.68,578013.84,738120.96,160107.12,459862),('1','151','154013','314',213.00,272.00,0.00,1889.12,402382.56,513840.64,111458.08,460084),('1','151','154034','314',213.00,272.00,0.00,314.64,67018.32,85582.08,18563.76,460143),('1','151','154295','314',213.00,272.00,0.00,527.35,112325.55,143439.20,31113.65,460841),('1','151','154413','314',213.00,272.00,0.00,389.67,82999.71,105990.24,22990.53,461150),('1','151','154572','314',213.00,272.00,0.00,4232.86,901599.18,1151337.92,249738.74,461597),('1','151','154863','314',213.00,272.00,0.00,3002.67,639568.71,816726.24,177157.53,462395),('1','151','154961','314',213.00,272.00,0.00,1587.20,338073.60,431718.40,93644.80,462649),('1','151','155016','314',213.00,272.00,0.00,2263.73,482174.49,615734.56,133560.07,462801),('1','151','155116','314',213.00,272.00,0.00,2335.93,497553.09,635372.96,137819.87,463081),('1','151','155135','314',213.00,272.00,0.00,1592.95,339298.35,433282.40,93984.05,463122),('1','151','155279','314',213.00,272.00,0.00,2998.81,638746.53,815676.32,176929.79,463525),('1','151','155297','314',213.00,272.00,0.00,247.32,52679.16,67271.04,14591.88,463561),('1','151','155487','314',213.00,272.00,0.00,3178.20,676956.60,864470.40,187513.80,464055),('1','151','155580','314',220.00,272.00,0.00,1163.39,255945.80,316442.08,60496.28,464319),('1','151','155593','314',220.00,272.00,0.00,2259.49,497087.80,614581.28,117493.48,464356),('1','151','155784','314',220.00,272.00,0.00,2361.16,519455.20,642235.52,122780.32,464869),('1','151','155785','314',220.00,272.00,0.00,763.92,168062.40,207786.24,39723.84,464870),('1','151','155931','314',220.00,272.00,0.00,2985.18,656739.60,811968.96,155229.36,465249),('1','151','155976','314',220.00,272.00,0.00,838.31,184428.20,228020.32,43592.12,465366),('1','151','156061','314',220.00,272.00,0.00,1206.54,265438.80,328178.88,62740.08,465611),('1','151','156063','314',220.00,272.00,0.00,859.80,189156.00,233865.60,44709.60,465615),('1','151','156200','314',220.00,272.00,0.00,3055.35,672177.00,831055.20,158878.20,465961),('1','151','156260','314',220.00,272.00,0.00,636.68,140069.60,173176.96,33107.36,466121),('1','151','156267','314',220.00,272.00,0.00,2448.93,538764.60,666108.96,127344.36,466140),('1','151','156565','314',220.00,272.00,0.00,2160.96,475411.20,587781.12,112369.92,466936),('1','151','156571','314',220.00,272.00,0.00,261.81,57598.20,71212.32,13614.12,466948),('1','151','156741','314',220.00,272.00,0.00,3120.94,686606.80,848895.68,162288.88,467419),('1','151','156806','314',220.00,272.00,0.00,1164.96,256291.20,316869.12,60577.92,467602),('1','151','156899','314',220.00,272.00,0.00,1232.07,271055.40,335123.04,64067.64,467853),('1','151','157045','314',220.00,272.00,0.00,1422.57,312965.40,386939.04,73973.64,468252),('1','151','157135','314',220.00,0.00,0.00,1481.28,325881.60,402908.16,77026.56,468452),('1','151','157140','314',220.00,272.00,0.00,428.00,94160.00,116416.00,22256.00,468465),('1','151','157269','314',220.00,272.00,0.00,2111.09,464439.80,574216.48,109776.68,468814),('1','151','157437','314',220.00,272.00,0.00,2477.74,545102.80,673945.28,128842.48,469247),('1','151','157446','314',220.00,272.00,0.00,369.17,81217.40,100414.24,19196.84,469264),('1','151','157569','314',220.00,272.00,0.00,1098.47,241663.40,298783.84,57120.44,469578),('1','151','157574','314',220.00,272.00,0.00,1817.26,399797.20,494294.72,94497.52,469589),('1','151','157774','314',220.00,272.00,0.00,2809.48,618085.60,764178.56,146092.96,470137),('1','151','157810','314',220.00,272.00,0.00,779.57,171505.40,212043.04,40537.64,470227),('1','151','157948','314',220.00,275.00,0.00,2540.93,559004.60,691132.96,132128.36,470598),('1','151','158035','314',220.00,272.00,0.00,1197.98,263555.60,325850.56,62294.96,470830),('1','151','158054','314',220.00,272.00,0.00,2323.89,511255.80,632098.08,120842.28,470877),('1','151','158170','314',220.00,272.00,0.00,2180.32,479670.40,593047.04,113376.64,471175),('1','151','158263','314',220.00,272.00,0.00,1727.88,380133.60,469983.36,89849.76,471416),('1','151','158436','314',220.00,272.00,0.00,2777.62,611076.40,755512.64,144436.24,471878),('1','151','158439','314',220.00,272.00,0.00,1230.02,270604.40,334565.44,63961.04,471885),('1','151','158564','314',220.00,272.00,0.00,3522.69,774991.80,958171.68,183179.88,472212),('1','151','158733','314',220.00,272.00,0.00,3393.68,746609.60,923080.96,176471.36,472667),('1','151','158824','314',220.00,272.00,0.00,1167.09,256759.80,317448.48,60688.68,472879),('1','151','158826','314',220.00,272.00,0.00,2400.64,528140.80,652974.08,124833.28,472883),('1','151','159105','314',220.00,272.00,0.00,2137.92,470342.40,581514.24,111171.84,473649),('1','151','159111','314',220.00,272.00,0.00,1472.37,323921.40,400484.64,76563.24,473656),('1','151','159268','314',220.00,272.00,0.00,2426.87,533911.40,660108.64,126197.24,474090),('1','151','159271','314',220.00,272.00,0.00,684.04,150488.80,186058.88,35570.08,474097),('1','151','159275','314',220.00,272.00,0.00,1102.16,242475.20,162568.96,-79906.24,474103),('1','151','159443','314',220.00,272.00,0.00,2474.11,544304.20,672957.92,128653.72,474516),('1','151','159447','314',220.00,272.00,0.00,614.93,135284.60,167260.96,31976.36,474525),('1','151','159636','314',220.00,272.00,0.00,3946.02,868124.40,1073317.44,205193.04,475024),('1','151','159736','314',220.00,272.00,0.00,3550.40,781088.00,965708.80,184620.80,475261),('1','151','159889','314',220.00,272.00,0.00,1022.20,224884.00,278038.40,53154.40,475674),('1','151','159893','314',220.00,272.00,0.00,2213.53,486976.60,602080.16,115103.56,475684),('1','151','160028','314',220.00,272.00,0.00,2332.31,513108.20,634388.32,121280.12,476019),('1','151','160127','314',220.00,272.00,0.00,1608.38,353843.60,437479.36,83635.76,476270),('1','151','160263','314',220.00,272.00,0.00,640.78,140971.60,174292.16,33320.56,476644),('1','151','160271','314',220.00,272.00,0.00,4248.79,934733.80,1155670.88,220937.08,476666),('1','151','160353','314',220.00,272.00,0.00,325.78,71671.60,88612.16,16940.56,476871),('1','151','160588','314',225.00,296.00,0.00,3764.94,847111.50,1114422.24,267310.74,477493),('1','151','160653','314',225.00,296.00,0.00,787.15,177108.75,232996.40,55887.65,477649),('1','151','160686','314',225.00,296.00,0.00,2393.00,538425.00,708328.00,169903.00,477741),('1','151','160878','314',225.00,296.00,0.00,2181.13,490754.25,645614.48,154860.23,478217),('1','151','160894','314',225.00,296.00,0.00,1135.09,255395.25,335986.64,80591.39,478250),('1','151','161092','314',225.00,296.00,0.00,3406.62,766489.50,1008359.52,241870.02,478783),('1','151','161185','314',225.00,296.00,0.00,3190.71,717909.75,944450.16,226540.41,479026),('1','151','161313','314',225.00,296.00,0.00,1402.96,315666.00,415226.16,99560.16,479324),('1','151','161458','314',225.00,296.00,0.00,1131.14,254506.50,334817.44,80310.94,479714),('1','151','161663','314',225.00,296.00,0.00,2972.90,668902.50,879978.40,211075.90,480241),('1','151','161823','314',225.00,296.00,0.00,457.87,103020.75,135529.52,32508.77,480656),('1','151','161828','314',225.00,296.00,0.00,2309.12,519552.00,683499.52,163947.52,480667),('1','151','162023','314',225.00,296.00,0.00,2289.87,515220.75,677801.52,162580.77,481182),('1','151','162029','314',225.00,296.00,0.00,639.90,143977.50,189410.40,45432.90,481199),('1','151','162244','314',225.00,296.00,0.00,2942.83,662136.75,871077.68,208940.93,481734),('1','151','162321','314',225.00,296.00,0.00,955.12,214902.00,282715.52,67813.52,481928),('1','151','162380','314',225.00,296.00,0.00,1969.97,443243.25,583111.12,139867.87,482089),('1','151','162641','314',225.00,296.00,0.00,2589.06,582538.50,766361.76,183823.26,482738),('1','151','162643','314',225.00,296.00,0.00,252.19,56742.75,74648.24,17905.49,482740),('1','151','162813','314',225.00,296.00,0.00,3380.00,760500.00,1000480.00,239980.00,483191),('1','151','162905','314',225.00,296.00,0.00,934.91,210354.75,276733.36,66378.61,483438),('1','151','162911','314',225.00,296.00,0.00,1177.60,264960.00,348569.60,83609.60,483454),('1','151','163194','314',225.00,296.00,0.00,3050.11,686274.75,902832.56,216557.81,484184),('1','151','163340','314',225.00,296.00,0.00,229.87,51720.75,68041.52,16320.77,484563),('1','151','163342','314',225.00,296.00,0.00,2621.90,589927.50,776082.40,186154.90,484565),('1','151','163538','314',225.00,296.00,0.00,1952.56,439326.00,577957.76,138631.76,485085),('1','151','163539','314',225.00,296.00,0.00,1045.12,235152.00,309355.52,74203.52,485086),('1','151','163726','314',225.00,296.00,0.00,3148.66,708448.50,932003.36,223554.86,485583),('1','151','163786','314',225.00,296.00,0.00,389.18,87565.50,115197.28,27631.78,485720),('1','151','163790','314',225.00,296.00,0.00,2667.44,600174.00,789562.24,189388.24,485730),('1','151','164063','314',225.00,296.00,0.00,1910.66,429898.50,565555.36,135656.86,486459),('1','151','164067','314',225.00,296.00,0.00,1111.46,250078.50,328992.16,78913.66,486469),('1','151','164248','314',225.00,296.00,0.00,3004.11,675924.75,889216.56,213291.81,486943),('1','151','164352','314',225.00,296.00,0.00,447.39,100662.75,132427.44,31764.69,487213),('1','151','164448','314',225.00,296.00,0.00,2421.68,544878.00,716817.28,171939.28,487465),('1','151','164551','314',225.00,296.00,0.00,2155.37,484958.25,637989.52,153031.27,487756),('1','151','164605','314',225.00,296.00,0.00,233.60,52560.00,69145.60,16585.60,487893),('1','151','164745','314',225.00,296.00,0.00,4062.95,914163.75,1202633.20,288469.45,488275),('1','151','164814','314',225.00,296.00,0.00,485.62,109264.50,143743.52,34479.02,488450),('1','151','164818','314',225.00,296.00,0.00,2445.35,550203.75,723823.60,173619.85,488460),('1','151','165084','314',225.00,320.00,0.00,2109.16,474561.00,674931.20,200370.20,489141),('1','151','165096','314',230.00,320.00,0.00,1177.67,270864.10,376854.40,105990.30,489170),('1','151','165268','314',230.00,320.00,0.00,2040.98,469425.40,653113.60,183688.20,489627),('1','151','165274','314',230.00,320.00,0.00,1329.54,305794.20,425452.80,119658.60,489641),('1','151','165448','314',230.00,320.00,0.00,3435.83,790240.90,1099465.60,309224.70,490081),('1','151','165537','314',230.00,320.00,0.00,1090.24,250755.20,348876.80,98121.60,490316),('1','151','165604','314',230.00,320.00,0.00,1930.92,444111.60,617894.40,173782.80,490498),('1','151','165768','314',230.00,320.00,0.00,63.00,14490.00,20160.00,5670.00,490951),('1','151','165772','314',230.00,320.00,0.00,2345.63,539494.90,750601.60,211106.70,490961),('1','151','165969','314',230.00,320.00,0.00,2194.52,504739.60,702246.40,197506.80,491469),('1','151','165978','314',230.00,320.00,0.00,555.86,127847.80,177875.20,50027.40,491492),('1','151','165981','314',230.00,320.00,0.00,3231.57,743261.10,1034102.40,290841.30,491499),('1','151','166260','314',230.00,320.00,0.00,713.22,164040.60,228230.40,64189.80,492238),('1','151','166263','314',230.00,320.00,0.00,980.68,225556.40,313817.60,88261.20,492244),('1','151','166507','314',230.00,320.00,0.00,2649.00,609270.00,847680.00,238410.00,492898),('1','151','166520','314',230.00,320.00,0.00,898.00,206540.00,287360.00,80820.00,492933),('1','151','166523','314',230.00,320.00,0.00,2934.06,674833.80,938899.20,264065.40,492940),('1','151','166884','314',230.00,320.00,0.00,3134.71,720983.30,1003107.20,282123.90,493923),('1','151','167030','314',230.00,320.00,0.00,1418.17,326179.10,453814.40,127635.30,494319),('1','151','167036','314',230.00,320.00,0.00,1364.72,313885.60,436710.40,122824.80,494333),('1','151','167173','314',230.00,320.00,0.00,2514.08,578238.40,804505.60,226267.20,494700),('1','151','167233','314',230.00,320.00,0.00,704.91,162129.30,225571.20,63441.90,494846),('1','151','167240','314',230.00,320.00,0.00,2149.50,494385.00,687840.00,193455.00,494863),('1','151','167562','314',270.00,320.00,0.00,2452.91,662285.70,784931.20,122645.50,495735),('1','151','167733','314',270.00,320.00,0.00,3339.97,901791.90,1068790.40,166998.50,496176),('1','151','167834','314',270.00,320.00,0.00,1177.85,318019.50,376912.00,58892.50,496441),('1','151','167838','314',270.00,320.00,0.00,1805.29,487428.30,577692.80,90264.50,496451),('1','151','168091','314',270.00,320.00,0.00,2765.53,746693.10,884969.60,138276.50,497139),('1','151','168167','314',270.00,320.00,0.00,865.41,233660.70,276931.20,43270.50,497319),('1','151','168180','314',270.00,320.00,0.00,2029.75,548032.50,649520.00,101487.50,497356),('1','151','168385','314',270.00,320.00,0.00,2547.75,687892.50,815280.00,127387.50,497921),('1','151','168598','314',270.00,320.00,0.00,3529.54,952975.80,1129452.80,176477.00,498477),('1','151','168690','314',270.00,320.00,0.00,1046.23,282482.10,334793.60,52311.50,498726),('1','151','168701','314',270.00,320.00,0.00,782.16,211183.20,250291.20,39108.00,498757),('1','151','168929','314',270.00,320.00,0.00,3578.52,966200.40,1145126.40,178926.00,499355),('1','151','169006','314',270.00,320.00,0.00,254.83,68804.10,81545.60,12741.50,499549),('1','151','169014','314',270.00,320.00,0.00,3140.44,847918.80,1004940.80,157022.00,499569),('1','151','169246','314',270.00,320.00,0.00,1381.46,372994.20,442067.20,69073.00,500164),('1','151','169249','314',270.00,320.00,0.00,1725.63,465920.10,552201.60,86281.50,500169),('1','151','169454','314',270.00,320.00,0.00,2633.42,711023.40,842694.40,131671.00,500689),('1','151','169518','314',270.00,320.00,0.00,104.80,28296.00,33536.00,5240.00,500859),('1','151','169525','314',270.00,328.00,0.00,2321.67,626850.90,761507.76,134656.86,500878),('1','151','169762','314',270.00,320.00,0.00,2280.83,615824.10,748112.24,132288.14,501518),('1','151','169765','314',270.00,328.00,0.00,711.53,192113.10,233381.84,41268.74,501524),('1','151','169919','314',270.00,328.00,0.00,3394.72,916574.40,1113468.16,196893.76,501948),('1','151','169981','314',270.00,328.00,0.00,485.23,131012.10,159155.44,28143.34,502091),('1','151','170035','314',270.00,328.00,0.00,1436.34,387811.80,471119.52,83307.72,502232),('1','151','170319','314',270.00,328.00,0.00,3446.79,930633.30,1130547.12,199913.82,502970),('1','151','170501','314',270.00,328.00,0.00,3455.03,932858.10,1133249.84,200391.74,503440),('1','151','170674','314',270.00,0.00,0.00,1161.69,313656.30,381034.32,67378.02,503894),('1','151','170676','314',270.00,328.00,0.00,1776.30,479601.00,582626.40,103025.40,503896),('1','151','170800','314',270.00,328.00,0.00,2836.60,765882.00,930404.80,164522.80,504233),('1','151','170974','314',270.00,328.00,0.00,3384.62,913847.40,1110155.36,196307.96,504691),('1','151','171042','314',270.00,328.00,0.00,1276.86,344752.20,418810.08,74057.88,504866),('1','151','171155','314',270.00,328.00,0.00,1450.27,391572.90,475688.56,84115.66,505184),('1','151','171362','314',270.00,328.00,0.00,3080.07,831618.90,1010262.96,178644.06,505726),('1','151','171417','314',270.00,328.00,0.00,2632.79,710853.30,863555.12,152701.82,505865),('1','151','171755','314',270.00,328.00,0.00,2140.64,577972.80,702129.92,124157.12,506777),('1','151','171955','314',270.00,328.00,0.00,2737.46,739114.20,897886.88,158772.68,507295),('1','151','172128','314',270.00,328.00,0.00,1888.93,510011.10,619569.04,109557.94,507742),('1','151','172135','314',270.00,328.00,0.00,3060.98,826464.60,1004001.44,177536.84,507761),('1','151','172507','314',270.00,328.00,0.00,1563.53,422153.10,512837.84,90684.74,508761),('1','151','172578','314',270.00,328.00,0.00,3205.12,865382.40,1051279.36,185896.96,508948),('1','151','172838','314',270.00,328.00,0.00,3144.62,849047.40,1031435.36,182387.96,509642),('1','151','172897','314',270.00,328.00,0.00,100.00,27000.00,32800.00,5800.00,509782),('1','151','172963','314',270.00,328.00,0.00,1551.06,418786.20,508747.68,89961.48,509963),('1','151','173205','314',270.00,328.00,0.00,321.35,86764.50,105402.80,18638.30,510611),('1','151','173327','314',270.00,328.00,0.00,2672.41,721550.70,876550.48,154999.78,510928),('1','151','173332','314',270.00,328.00,0.00,3462.89,934980.30,1135827.92,200847.62,510941),('1','151','173848','314',270.00,328.00,0.00,1225.67,330930.90,402019.76,71088.86,512318),('1','151','173860','314',270.00,328.00,0.00,1809.62,488597.40,593555.36,104957.96,512350),('1','151','174111','314',270.00,328.00,0.00,2769.90,747873.00,908527.20,160654.20,513019),('1','151','174295','314',270.00,328.00,0.00,3233.49,873042.30,1060584.72,187542.42,513498),('1','151','174328','314',270.00,328.00,0.00,1386.04,374230.80,454621.12,80390.32,513571),('1','151','174424','314',270.00,328.00,0.00,1528.41,412670.70,501318.48,88647.78,513819),('1','151','174539','314',270.00,328.00,0.00,1672.97,451701.90,548734.16,97032.26,514112),('1','151','174541','314',270.00,328.00,0.00,1686.22,455279.40,553080.16,97800.76,514116),('1','151','174772','314',270.00,328.00,0.00,1476.47,398646.90,484282.16,85635.26,514725),('1','151','174805','314',270.00,328.00,0.00,721.38,194772.60,85732.64,-109039.96,514820),('1','151','174810','314',270.00,328.00,0.00,460.00,124200.00,150880.00,26680.00,514833),('1','151','174946','314',270.00,352.00,0.00,1419.69,383316.30,499730.88,116414.58,515185),('1','151','174949','314',270.00,352.00,0.00,1558.28,420735.60,548514.56,127778.96,515192),('1','151','175149','314',270.00,352.00,0.00,1248.91,337205.70,439616.32,102410.62,515722),('1','151','175160','314',290.00,352.00,0.00,1629.36,472514.40,573534.72,101020.32,515753),('1','151','175308','314',290.00,352.00,0.00,1317.69,382130.10,463826.88,81696.78,516136),('1','151','175334','314',290.00,352.00,0.00,1550.54,449656.60,545790.08,96133.48,516202),('1','151','175470','314',290.00,352.00,0.00,1341.14,388930.60,472081.28,83150.68,516558),('1','151','175509','314',290.00,352.00,0.00,1615.85,468596.50,568779.20,100182.70,516659),('1','151','175676','314',290.00,352.00,0.00,1744.70,505963.00,614134.40,108171.40,517100),('1','151','175683','314',290.00,352.00,0.00,922.74,267594.60,324804.48,57209.88,517115),('1','151','175876','314',290.00,352.00,0.00,2546.04,738351.60,552925.12,-185426.48,517635),('1','151','175880','314',290.00,352.00,0.00,1078.01,312622.90,379459.52,66836.62,517643),('1','151','175974','314',290.00,352.00,0.00,1655.73,480161.70,582816.96,102655.26,517874),('1','151','176120','314',290.00,352.00,0.00,2401.08,696313.20,845180.16,148866.96,518244),('1','151','176262','314',290.00,352.00,0.00,2266.19,657195.10,797698.88,140503.78,518627),('1','151','176298','314',290.00,352.00,0.00,659.06,191127.40,231989.12,40861.72,518716),('1','151','176336','314',290.00,352.00,0.00,1977.56,573492.40,696101.12,122608.72,518781),('1','151','176476','314',290.00,352.00,0.00,1850.61,536676.90,651414.72,114737.82,519172),('1','151','176557','314',290.00,352.00,0.00,838.28,243101.20,286274.56,43173.36,519368),('1','151','176642','314',290.00,352.00,0.00,1444.44,394545.10,460858.52,66313.42,519605),('1','151','176786','314',290.00,352.00,0.00,1856.97,538521.30,653653.44,115132.14,519991),('1','151','176969','314',302.00,352.00,0.00,1245.85,376246.70,438539.20,62292.50,520483),('1','151','176995','314',302.00,352.00,0.00,1789.82,540525.64,630016.64,89491.00,520540),('1','151','177106','314',302.00,352.00,0.00,1600.08,483224.16,563225.32,80001.16,520846),('1','151','177236','314',302.00,352.00,0.00,1189.84,359331.68,418474.68,59143.00,521166),('1','151','177330','314',302.00,352.00,0.00,1413.44,426858.88,497530.88,70672.00,521414),('1','151','177429','314',302.00,352.00,0.00,2836.42,856598.84,998419.84,141821.00,521669),('1','151','177631','314',302.00,344.00,0.00,386.25,116647.50,132870.00,16222.50,522217),('1','151','177703','314',302.00,344.00,0.00,765.52,231187.04,263738.88,32551.84,522424),('1','151','177789','314',302.00,344.00,0.00,1513.85,457182.70,519834.40,62651.70,522670),('1','151','177886','314',302.00,344.00,0.00,1842.81,556528.62,633926.64,77398.02,522899),('1','151','177986','314',302.00,344.00,0.00,474.20,143208.40,163124.80,19916.40,523175),('1','151','178091','314',302.00,0.00,0.00,1613.99,524812.96,555212.56,30399.60,523448),('1','151','178192','314',344.00,344.00,0.00,1537.89,529034.16,529034.16,0.00,523710),('1','151','178300','314',344.00,344.00,0.00,1285.77,388302.54,442304.88,54002.34,523980),('1','151','178459','314',302.00,344.00,0.00,1171.99,353940.98,403164.56,49223.58,524417),('1','151','178679','314',302.00,344.00,0.00,3195.29,964977.58,1099179.76,134202.18,524990),('1','151','178725','314',302.00,344.00,0.00,266.95,80618.90,91830.80,11211.90,525091),('1','151','178766','314',302.00,344.00,0.00,931.37,281273.74,320391.28,39117.54,525205),('1','151','178821','314',302.00,344.00,0.00,1274.85,385004.70,438548.40,53543.70,525361),('1','151','178904','314',302.00,344.00,0.00,2945.80,889631.60,1013355.20,123723.60,525563),('1','151','179142','314',302.00,344.00,0.00,1651.49,498749.98,568112.56,69362.58,526187),('1','151','179374','314',302.00,344.00,0.00,2605.68,913588.52,931298.24,17709.72,526811),('1','151','179570','314',360.00,360.00,0.00,1939.74,695464.40,698306.40,2842.00,527333),('1','151','179730','314',302.00,360.00,0.00,3386.85,1022828.70,1219266.00,196437.30,527777),('1','151','179988','314',302.00,360.00,0.00,1191.53,359842.06,428950.80,69108.74,528440),('1','151','180072','314',302.00,360.00,0.00,1165.44,351962.88,419558.40,67595.52,528657),('1','151','180168','314',302.00,360.00,0.00,3421.71,1033356.42,1231815.60,198459.18,528915),('1','151','180341','314',302.00,360.00,0.00,2937.33,911775.16,1032525.36,120750.20,529348),('1','151','180550','314',318.00,360.00,0.00,1863.95,592736.10,671022.00,78285.90,529908),('1','151','180656','314',318.00,360.00,0.00,722.10,229627.80,259956.00,30328.20,530189),('1','151','180733','314',318.00,360.00,0.00,3167.06,1007125.08,1140141.60,133016.52,530387),('1','151','180951','314',318.00,360.00,0.00,690.28,219509.04,248500.80,28991.76,530983),('1','151','181035','314',318.00,360.00,0.00,1817.82,578066.76,654415.20,76348.44,531187),('1','151','181129','314',318.00,360.00,0.00,337.54,107337.72,121514.40,14176.68,531440),('1','151','181236','314',318.00,360.00,0.00,1127.22,358455.96,405799.20,47343.24,531730),('1','151','181376','314',318.00,360.00,0.00,2766.70,879810.60,996012.00,116201.40,532093),('1','151','181522','314',318.00,360.00,0.00,658.31,209342.58,236991.60,27649.02,532483),('1','151','181577','314',318.00,360.00,0.00,2491.77,792382.86,897037.20,104654.34,532619),('1','151','181721','314',318.00,360.00,0.00,2036.73,647680.14,733222.80,85542.66,532991),('1','151','181869','314',318.00,360.00,0.00,315.60,100360.80,113616.00,13255.20,533416),('1','151','181905','314',318.00,360.00,0.00,3757.06,1194745.08,1352541.60,157796.52,533507),('1','151','182101','314',318.00,360.00,0.00,487.81,155123.58,175611.60,20488.02,534033),('1','151','182154','314',318.00,360.00,0.00,2748.60,874054.80,989496.00,115441.20,534163),('1','151','182302','314',318.00,360.00,0.00,1803.05,573369.90,649098.00,75728.10,534547),('1','151','182508','314',318.00,360.00,0.00,2945.63,936710.34,1060426.80,123716.46,535087),('1','151','182681','314',318.00,360.00,0.00,1540.47,489869.46,554569.20,64699.74,535555),('1','151','182767','314',318.00,360.00,0.00,1459.67,464175.06,525481.20,61306.14,535787),('1','151','182869','314',318.00,360.00,0.00,1162.48,369668.64,418492.80,48824.16,536062),('1','151','182921','314',318.00,360.00,0.00,1221.91,388567.38,439887.60,51320.22,536211),('1','151','182984','314',318.00,360.00,0.00,2988.34,950292.12,1075802.40,125510.28,536386),('1','151','183209','314',318.00,360.00,0.00,357.06,113545.08,128541.60,14996.52,536959),('1','151','183243','314',318.00,360.00,0.00,2658.73,845476.14,957142.80,111666.66,537032),('1','151','183524','314',318.00,360.00,0.00,1906.83,606371.94,686458.80,80086.86,537774),('1','151','183651','314',318.00,360.00,0.00,2674.30,850427.40,962748.00,112320.60,538110),('1','151','183877','314',318.00,360.00,0.00,1838.11,584518.98,661719.60,77200.62,538715),('1','151','184037','314',318.00,360.00,0.00,614.73,195484.14,221302.80,25818.66,539146),('1','151','184069','314',318.00,360.00,0.00,3185.36,1012944.48,1146729.60,133785.12,539231),('1','151','184264','314',318.00,360.00,0.00,726.26,230950.68,261453.60,30502.92,539748),('1','151','184357','314',318.00,360.00,0.00,2156.85,685878.30,776466.00,90587.70,539984),('1','151','184471','314',318.00,360.00,0.00,2385.51,758592.18,858783.60,100191.42,540269),('1','151','184678','314',318.00,360.00,0.00,2488.13,791225.34,895726.80,104501.46,540843),('1','151','184902','314',318.00,360.00,0.00,3026.06,962287.08,1089381.60,127094.52,541430),('1','151','185099','314',318.00,360.00,0.00,1516.79,482339.22,546044.40,63705.18,541942),('1','151','185222','314',318.00,360.00,0.00,425.90,135436.20,153324.00,17887.80,542254),('1','151','185265','314',318.00,360.00,0.00,2549.28,810671.04,917740.80,107069.76,542346),('1','151','185461','314',318.00,360.00,0.00,1587.46,504812.28,571485.60,66673.32,542877),('1','151','185597','314',318.00,360.00,0.00,353.93,112549.74,127414.80,14865.06,543234),('1','151','185678','314',318.00,360.00,0.00,2493.37,792891.66,897613.20,104721.54,543446),('1','151','185865','314',318.00,360.00,0.00,1707.54,542997.72,614714.40,71716.68,543959),('1','151','186008','314',318.00,360.00,0.00,743.71,236499.78,267735.60,31235.82,544336),('1','151','186099','314',318.00,360.00,0.00,2798.96,890069.28,1007625.60,117556.32,544562),('1','151','186310','314',318.00,360.00,0.00,972.85,309366.30,350226.00,40859.70,545121),('1','151','186442','314',318.00,360.00,0.00,1044.33,332096.94,375958.80,43861.86,545476),('1','151','186548','314',318.00,360.00,0.00,2283.40,726121.20,822024.00,95902.80,545742),('1','151','186749','314',318.00,360.00,0.00,1197.03,380655.54,430930.80,50275.26,546269),('1','151','186909','314',318.00,360.00,0.00,573.28,182303.04,206380.80,24077.76,546677),('1','151','186979','314',318.00,360.00,0.00,1686.91,536437.38,607287.60,70850.22,546845),('1','151','187161','314',318.00,360.00,0.00,3095.49,984365.82,1114376.40,130010.58,547333),('1','151','187344','314',318.00,360.00,0.00,1437.61,457159.98,517539.60,60379.62,547814),('1','151','187460','314',318.00,360.00,0.00,1378.60,438394.80,496296.00,57901.20,548123),('1','151','187576','314',318.00,360.00,0.00,3169.69,1007961.42,1141088.40,133126.98,548425),('1','151','187788','314',318.00,360.00,0.00,3249.00,1033182.00,1169640.00,136458.00,548993),('1','151','188014','314',318.00,360.00,0.00,1295.50,411969.00,466380.00,54411.00,549579),('1','151','188102','314',318.00,360.00,0.00,1880.78,598088.04,677080.80,78992.76,549800),('1','151','188210','314',318.00,360.00,0.00,2655.62,844487.16,956023.20,111536.04,550087),('1','151','188421','314',318.00,360.00,0.00,3719.59,1182829.62,1339052.40,156222.78,550633),('1','151','188604','314',318.00,360.00,0.00,802.77,255280.86,288997.20,33716.34,551096),('1','151','188685','314',318.00,360.00,0.00,2271.00,722178.00,817560.00,95382.00,551305),('1','151','188801','314',318.00,360.00,0.00,639.42,203335.56,230191.20,26855.64,551623),('1','151','188892','314',318.00,360.00,0.00,1878.80,597458.40,676368.00,78909.60,551861),('1','151','189008','314',318.00,360.00,0.00,2639.38,839322.84,950176.80,110853.96,552165),('1','151','189194','314',318.00,360.00,0.00,3431.49,1091213.82,1235336.40,144122.58,552653),('1','151','189424','314',318.00,360.00,0.00,1103.27,350839.86,397177.20,46337.34,553256),('1','151','189514','314',318.00,360.00,0.00,2127.44,676525.92,765878.40,89352.48,553485),('1','151','189614','314',318.00,360.00,0.00,2415.14,768014.52,869450.40,101435.88,553747),('1','151','189759','314',318.00,360.00,0.00,484.22,153981.96,174319.20,20337.24,554118),('1','151','189807','314',318.00,360.00,0.00,3384.63,1076312.34,1218466.80,142154.46,554244),('1','151','190028','314',318.00,360.00,0.00,662.38,210636.84,238456.80,27819.96,554825),('1','151','190086','314',318.00,360.00,0.00,2231.61,709651.98,803379.60,93727.62,554965),('1','151','190269','314',323.00,360.00,0.00,4384.20,1416096.60,1578312.00,162215.40,555443),('1','151','190434','314',323.00,360.00,0.00,230.98,74606.54,83152.80,8546.26,555879),('1','151','190482','314',323.00,360.00,0.00,4050.96,1308460.08,1458345.60,149885.52,556000),('1','151','190688','314',323.00,360.00,0.00,531.72,171090.01,191419.20,20329.19,556543),('1','151','190706','314',323.00,360.00,0.00,2491.92,804890.16,897091.20,92201.04,556592),('1','151','190883','314',323.00,360.00,0.00,2024.87,654033.01,728953.20,74920.19,557071),('1','151','191014','314',323.00,360.00,0.00,1053.22,340190.06,379159.20,38969.14,557412),('1','151','191090','314',323.00,360.00,0.00,2645.28,854425.44,952300.80,97875.36,557598),('1','151','191288','314',323.00,360.00,0.00,785.85,253829.55,282906.00,29076.45,558132),('1','151','191443','314',323.00,360.00,0.00,651.24,210350.52,234446.40,24095.88,558552),('1','151','191497','314',323.00,360.00,0.00,2077.95,671177.85,748062.00,76884.15,558684),('1','151','191707','314',323.00,360.00,0.00,2685.89,867542.47,966920.40,99377.93,559246),('1','151','191952','314',323.00,360.00,0.00,1793.03,579148.69,645490.80,66342.11,559890),('1','151','192131','314',323.00,360.00,0.00,1662.73,537061.79,598582.80,61521.01,560370),('1','151','192328','314',323.00,360.00,0.00,2548.52,823171.96,917467.20,94295.24,560893),('1','151','192565','314',323.00,360.00,0.00,375.57,121309.11,135205.20,13896.09,561504),('1','151','192637','314',323.00,360.00,0.00,1427.28,461011.44,513820.80,52809.36,561691),('1','151','192776','314',323.00,360.00,0.00,2718.34,878023.82,978602.40,100578.58,562044),('1','151','192954','314',323.00,360.00,0.00,387.02,125007.46,139327.20,14319.74,562520),('1','151','193021','314',323.00,360.00,0.00,1222.53,394877.19,440110.80,45233.61,562687),('1','151','193155','314',323.00,360.00,0.00,3006.38,971060.74,1082296.80,111236.06,563066),('1','151','193405','314',323.00,360.00,0.00,312.31,100876.13,112431.60,11555.47,563714),('1','151','193486','314',323.00,360.00,0.00,1627.06,525540.38,585741.60,60201.22,563924),('1','151','193645','314',323.00,360.00,0.00,2706.30,874134.90,974268.00,100133.10,564314),('1','151','193850','314',323.00,360.00,0.00,2005.10,647647.30,721836.00,74188.70,564844),('1','151','194067','314',323.00,360.00,0.00,2557.03,825920.69,920530.80,94610.11,565396),('1','151','194289','314',323.00,360.00,0.00,1973.26,637362.98,710373.60,73010.62,565968),('1','151','194529','314',323.00,360.00,0.00,3107.65,1003770.95,1118754.00,114983.05,566557),('1','151','194669','314',323.00,360.00,0.00,1383.29,446802.67,497984.40,51181.73,566927),('1','151','194802','314',323.00,360.00,0.00,1341.02,433149.46,482767.20,49617.74,567278),('1','151','195017','314',323.00,360.00,0.00,2653.70,857145.10,955332.00,98186.90,567845),('1','151','195141','314',323.00,360.00,0.00,534.61,172679.03,192459.60,19780.57,568162),('1','151','195189','314',323.00,360.00,0.00,1937.54,625825.42,697514.40,71688.98,568289),('1','151','195291','314',323.00,360.00,0.00,1233.20,398323.60,443952.00,45628.40,568564),('1','151','195399','314',348.00,348.00,0.00,1369.55,475203.40,476603.40,1400.00,568822),('1','151','195557','314',323.00,348.00,0.00,2504.22,808863.06,871468.56,62605.50,569218),('1','151','195790','314',323.00,348.00,0.00,2076.85,670822.55,722743.80,51921.25,569807),('1','151','196009','314',323.00,348.00,0.00,2557.11,825946.53,889874.28,63927.75,570368),('1','151','196212','314',317.00,348.00,0.00,3468.10,1099387.70,1206898.80,107511.10,570878),('1','151','196449','314',317.00,348.00,0.00,1038.24,329122.08,361307.52,32185.44,571492),('1','151','196545','314',317.00,348.00,0.00,2228.60,706466.20,775552.80,69086.60,571733),('1','151','196655','314',317.00,348.00,0.00,2300.71,729325.07,800647.08,71322.01,572020),('1','151','196815','314',317.00,348.00,0.00,755.23,239407.91,262820.04,23412.13,572440),('1','151','196881','314',317.00,348.00,0.00,2117.14,671133.38,736764.72,65631.34,572619),('1','151','197025','314',317.00,348.00,0.00,1608.10,509767.70,559618.80,49851.10,572987),('1','151','197141','314',317.00,348.00,0.00,799.41,253412.97,278194.68,24781.71,573282),('1','151','197679','314',317.00,348.00,0.00,2347.74,744233.58,817013.52,72779.94,574602),('1','151','197702','314',317.00,348.00,0.00,840.13,266321.21,292365.24,26044.03,574662),('1','151','197708','314',317.00,348.00,0.00,1082.61,376748.28,376748.28,0.00,574678),('1','151','197720','314',348.00,348.00,0.00,1883.86,655583.28,655583.28,0.00,574704),('1','151','197895','314',348.00,348.00,0.00,2363.66,822553.68,822553.68,0.00,575173),('1','151','198108','314',348.00,348.00,0.00,2131.45,741744.60,741744.60,0.00,575731),('1','151','198372','314',348.00,348.00,0.00,2941.01,1023471.48,1023471.48,0.00,576400),('1','151','198560','314',348.00,348.00,0.00,1538.29,535324.92,535324.92,0.00,576913),('1','151','198713','314',348.00,348.00,0.00,651.93,226871.64,226871.64,0.00,577314),('1','151','198792','314',348.00,348.00,0.00,2965.08,1031847.84,1031847.84,0.00,577468),('1','151','198971','314',348.00,348.00,0.00,903.20,314313.60,314313.60,0.00,577952),('1','151','199069','314',348.00,348.00,0.00,1700.71,591847.08,591847.08,0.00,578198),('1','151','199191','314',348.00,348.00,0.00,2832.68,985772.64,985772.64,0.00,578495),('1','151','199433','314',317.00,348.00,0.00,2758.88,874564.96,960090.24,85525.28,579094),('1','151','199674','314',317.00,348.00,0.00,1814.09,575066.53,631303.32,56236.79,579679),('1','151','199817','314',317.00,348.00,0.00,617.53,211017.38,214900.44,3883.06,580037),('1','151','199867','314',348.00,348.00,0.00,1592.10,554050.80,554050.80,0.00,580152),('1','151','200041','314',348.00,348.00,0.00,339.13,118017.24,118017.24,0.00,580628),('1','151','200091','314',348.00,348.00,0.00,2246.09,781639.32,781639.32,0.00,580750),('1','151','200323','314',348.00,348.00,0.00,1918.64,665886.72,667686.72,1800.00,581344),('1','151','200441','314',348.00,348.00,0.00,3063.97,1066261.56,1066261.56,0.00,581666),('1','151','200696','314',348.00,348.00,0.00,1447.27,502785.96,503649.96,864.00,582324),('1','151','200875','314',312.00,348.00,0.00,153.00,47736.00,53244.00,5508.00,582791),('1','151','200940','314',312.00,348.00,0.00,3626.19,1131371.28,1261914.12,130542.84,582930),('1','151','201113','314',312.00,348.00,0.00,710.00,221520.00,247080.00,25560.00,583382),('1','151','201233','314',312.00,348.00,0.00,1238.74,386486.88,431081.52,44594.64,583692),('1','151','201296','314',312.00,348.00,0.00,3240.64,1011079.68,1127742.72,116663.04,583861),('1','151','201492','314',312.00,348.00,0.00,3552.49,1108376.88,1236266.52,127889.64,584369),('1','151','201759','314',312.00,348.00,0.00,907.82,283239.84,315921.36,32681.52,585078),('1','151','201866','314',312.00,348.00,0.00,1749.94,545981.28,608979.12,62997.84,585359),('1','151','202032','314',312.00,348.00,0.00,1232.37,384499.44,428864.76,44365.32,585795),('1','151','202143','314',312.00,348.00,0.00,594.07,185349.84,206736.36,21386.52,586081),('1','151','202210','314',312.00,348.00,0.00,2543.51,793575.12,885141.48,91566.36,586249),('1','151','202431','314',312.00,348.00,0.00,1331.59,415456.08,463393.32,47937.24,586817),('1','151','202525','314',312.00,348.00,0.00,1629.49,508400.88,567062.52,58661.64,587066),('1','151','202741','314',312.00,348.00,0.00,2722.04,849276.48,947269.92,97993.44,587603),('1','151','202835','314',312.00,360.00,0.00,179.28,55935.36,64540.80,8605.44,587861),('1','151','202940','314',312.00,360.00,0.00,2226.98,694817.76,801712.80,106895.04,588120),('1','151','203099','314',312.00,360.00,0.00,2224.62,694081.44,800863.20,106781.76,588545),('1','151','203306','314',312.00,360.00,0.00,2759.16,860857.92,993297.60,132439.68,589093),('1','151','203520','314',312.00,360.00,0.00,1700.90,530680.80,612324.00,81643.20,589624),('1','151','203660','314',312.00,360.00,0.00,671.03,209361.36,241570.80,32209.44,589992),('1','151','203726','314',312.00,360.00,0.00,2779.77,867288.24,1000717.20,133428.96,590160),('1','151','203949','314',312.00,360.00,0.00,1025.30,319893.60,369108.00,49214.40,590743),('1','151','204075','314',312.00,360.00,0.00,1173.92,366263.04,422611.20,56348.16,591057),('1','151','204186','314',312.00,360.00,0.00,1716.34,535498.08,617882.40,82384.32,591359),('1','151','204333','314',322.00,360.00,0.00,513.18,165243.96,184744.80,19500.84,591737),('1','151','204393','314',322.00,360.00,0.00,2768.10,891328.20,996516.00,105187.80,591889),('1','151','204617','314',322.00,360.00,0.00,1218.17,392250.74,438541.20,46290.46,592464),('1','151','204722','314',322.00,360.00,0.00,1293.84,416616.48,465782.40,49165.92,592726),('1','151','204826','314',322.00,360.00,0.00,2744.76,883812.72,988113.60,104300.88,592968),('1','151','205042','314',322.00,360.00,0.00,3296.05,1061328.10,1186578.00,125249.90,593516),('1','151','205226','314',322.00,360.00,0.00,1213.90,390875.80,437004.00,46128.20,593998),('1','151','205360','314',322.00,360.00,0.00,1048.67,337671.74,377521.20,39849.46,594341),('1','151','205521','314',322.00,360.00,0.00,2944.22,948038.84,1059919.20,111880.36,594742),('1','151','205744','314',322.00,360.00,0.00,3061.31,985741.82,1102071.60,116329.78,595327),('1','151','205933','314',322.00,376.00,0.00,388.48,125090.56,146068.48,20977.92,595829),('1','151','206025','314',322.00,376.00,0.00,1783.48,574280.56,670588.48,96307.92,596058),('1','151','206145','314',322.00,376.00,0.00,2603.41,838298.02,978882.16,140584.14,596365),('1','151','206419','314',322.00,376.00,0.00,190.43,61318.46,71601.68,10283.22,597053),('1','151','206441','314',322.00,376.00,0.00,2075.98,668465.56,780568.48,112102.92,597112),('1','151','206576','314',322.00,376.00,0.00,2414.32,777411.04,907784.32,130373.28,597456),('1','151','206799','314',322.00,376.00,0.00,2412.48,776818.56,907092.48,130273.92,598035),('1','151','207096','314',322.00,376.00,0.00,2243.94,722548.68,843721.44,121172.76,598803),('1','151','207245','314',322.00,376.00,0.00,3302.19,1063305.18,1241623.44,178318.26,599198),('1','151','207536','314',322.00,376.00,0.00,1191.55,383679.10,448022.80,64343.70,599940),('1','151','207590','314',322.00,376.00,0.00,1866.23,600926.06,701702.48,100776.42,600077),('1','151','207700','314',384.00,384.00,0.00,4011.47,1455392.56,1540404.48,85011.92,600356),('1','151','207911','314',322.00,384.00,0.00,390.84,125850.48,150082.56,24232.08,600888),('1','151','207997','314',332.00,384.00,0.00,2589.53,859723.96,994379.52,134655.56,601119),('1','151','208109','314',332.00,384.00,0.00,1910.47,634276.04,733620.48,99344.44,601403),('1','151','208260','314',332.00,384.00,0.00,989.37,328470.84,379918.08,51447.24,601800),('1','151','208418','314',332.00,384.00,0.00,3503.82,1163268.24,1345466.88,182198.64,602193),('1','151','208564','314',332.00,384.00,0.00,4502.77,1494919.64,1729063.68,234144.04,602564),('1','151','208757','314',332.00,384.00,0.00,4487.85,1489966.20,1723334.40,233368.20,603072),('1','151','208996','314',332.00,400.00,0.00,2238.19,743079.08,895276.00,152196.92,603669),('1','151','209240','314',334.00,400.00,0.00,3261.02,1089180.68,1304408.00,215227.32,604286),('1','151','209457','314',334.00,400.00,0.00,1238.98,413819.32,495592.00,81772.68,604835),('1','151','209539','314',334.00,400.00,0.00,1429.31,477389.54,571724.00,94334.46,605059),('1','151','209641','314',334.00,400.00,0.00,3108.69,1038302.46,1243476.00,205173.54,605316),('1','151','209875','314',334.00,420.00,0.00,3635.08,1214116.72,1526733.60,312616.88,605916),('1','151','210142','314',334.00,420.00,0.00,872.92,291555.28,366626.40,75071.12,606611),('1','151','210180','314',334.00,420.00,0.00,1789.63,597736.42,751644.60,153908.18,606710),('1','151','210307','314',334.00,420.00,0.00,3305.36,1103990.24,1388251.20,284260.96,607044),('1','151','210730','314',334.00,420.00,0.00,3186.14,1064170.76,1338178.80,274008.04,608155),('1','151','210984','314',334.00,420.00,0.00,642.75,214678.50,269955.00,55276.50,608793),('1','151','211256','314',344.00,424.00,0.00,3412.91,1445635.44,1447073.84,1438.40,609509),('1','151','211449','314',424.00,424.00,0.00,1146.21,483397.04,485993.04,2596.00,610011),('1','151','211501','314',380.00,424.00,0.00,2544.87,967050.60,1079024.88,111974.28,610148),('1','151','211611','314',380.00,424.00,0.00,2194.13,833769.40,930311.12,96541.72,610434),('1','151','211690','314',380.00,424.00,0.00,1223.85,465063.00,518912.40,53849.40,610622),('1','151','211781','314',380.00,424.00,0.00,3021.29,1148090.20,1281026.96,132936.76,610858),('1','151','212114','314',380.00,424.00,0.00,3248.18,1234308.40,1377228.32,142919.92,611733),('1','151','212233','314',380.00,424.00,0.00,1357.18,515728.40,575444.32,59715.92,612037),('1','151','212358','314',380.00,424.00,0.00,1148.16,436300.80,486819.84,50519.04,612368),('1','151','212455','314',380.00,424.00,0.00,3411.34,1296309.20,1446408.16,150098.96,612627),('1','151','212665','314',380.00,424.00,0.00,1998.00,759240.00,847152.00,87912.00,613187),('1','151','212799','314',382.00,424.00,0.00,702.32,268286.24,297783.68,29497.44,613541),('1','151','212870','314',382.00,424.00,0.00,3675.37,1403991.34,1558356.88,154365.54,613717),('1','151','213272','314',382.00,424.00,0.00,158.31,61986.42,67123.44,5137.02,614761),('1','151','213286','314',382.00,424.00,0.00,1453.14,555099.48,616131.36,61031.88,614795),('1','151','213392','314',382.00,424.00,0.00,3055.86,1143489.59,1265455.91,121966.32,615068),('1','151','213642','314',382.00,424.00,0.00,4299.95,1642580.90,1823178.80,180597.90,615733),('1','151','214016','314',382.00,424.00,0.00,1573.92,601237.44,667342.08,66104.64,616713),('1','151','214121','314',382.00,424.00,0.00,3093.32,1181648.24,1311567.68,129919.44,616977),('1','151','214338','314',382.00,424.00,0.00,3574.38,1365413.16,1515537.12,150123.96,617548),('1','151','214611','314',382.00,424.00,0.00,977.43,373378.26,414430.32,41052.06,618253),('1','151','214629','314',382.00,424.00,0.00,487.82,186347.24,206835.68,20488.44,618301),('1','151','214961','314',382.00,424.00,0.00,3884.61,1483921.02,1647074.64,163153.62,619180),('1','151','215038','314',382.00,424.00,0.00,3032.36,1158361.52,1285720.64,127359.12,619367),('1','151','215316','314',382.00,424.00,0.00,1530.61,584693.02,648978.64,64285.62,620088),('1','151','215402','314',382.00,424.00,0.00,225.27,86053.14,95514.48,9461.34,620311),('1','151','215464','314',382.00,424.00,0.00,2328.84,889616.88,1024689.60,135072.72,620446),('1','151','215679','314',384.00,440.00,0.00,3755.69,1442184.96,1652503.60,210318.64,621017),('1','151','215917','314',384.00,440.00,0.00,817.80,313889.20,359832.00,45942.80,621619),('1','151','215988','314',382.00,440.00,0.00,1827.03,697925.46,803893.20,105967.74,621811),('1','151','216128','314',382.00,440.00,0.00,2733.97,1028479.80,1181176.98,152697.18,622166),('1','151','216322','314',382.00,440.00,0.00,2907.92,1110825.44,1279484.80,168659.36,622680),('1','151','216555','314',382.00,440.00,0.00,1652.08,631094.56,726915.20,95820.64,623300),('1','151','216756','314',382.00,440.00,0.00,819.93,313213.26,360769.20,47555.94,623832),('1','151','216905','314',382.00,440.00,0.00,3119.97,1191828.54,1372786.80,180958.26,624218),('1','151','217100','314',382.00,472.00,0.00,550.31,210218.42,259746.32,49527.90,624723),('1','151','217128','314',382.00,472.00,0.00,1521.79,581323.78,718284.88,136961.10,624798),('1','151','217306','314',382.00,472.00,0.00,101.00,38582.00,47672.00,9090.00,625258),('1','151','217313','314',382.00,472.00,0.00,3053.85,1166570.70,1441417.20,274846.50,625276),('1','151','217527','314',382.00,472.00,0.00,1506.15,578049.30,710902.80,132853.50,625838),('1','151','217587','314',427.00,472.00,0.00,1083.67,462727.09,511492.24,48765.15,625994),('1','151','217736','314',427.00,472.00,0.00,3011.11,1285743.97,1421243.92,135499.95,626379),('1','151','217985','314',427.00,472.00,0.00,2865.80,1223696.60,1352657.60,128961.00,627048),('1','151','218224','314',427.00,472.00,0.00,1140.80,487121.60,538457.60,51336.00,627674),('1','151','218332','314',427.00,472.00,0.00,1121.28,478786.56,529244.16,50457.60,627957),('1','151','218479','314',427.00,472.00,0.00,3207.86,1369756.22,1514109.92,144353.70,628335),('1','151','218702','314',427.00,472.00,0.00,2706.45,1155654.15,1277444.40,121790.25,628908),('1','151','218912','314',427.00,472.00,0.00,1805.45,770927.15,852172.40,81245.25,629469),('1','151','219084','314',427.00,472.00,0.00,393.17,167883.59,185576.24,17692.65,629922),('1','151','219115','314',427.00,460.00,0.00,2874.41,1192273.07,1322228.60,129955.53,630000),('1','151','219333','314',427.00,460.00,0.00,3671.55,1567751.85,1688913.00,121161.15,630572),('1','151','219604','314',427.00,460.00,0.00,240.39,102646.53,110579.40,7932.87,631280),('1','151','219666','314',460.00,460.00,0.00,2113.44,972182.40,972182.40,0.00,631443),('1','151','219805','314',460.00,460.00,0.00,2372.60,1091396.00,1091396.00,0.00,631814),('1','151','219979','314',460.00,460.00,0.00,502.54,231168.40,231168.40,0.00,632289),('1','151','220049','314',460.00,460.00,0.00,3103.38,1427554.80,1427554.80,0.00,632459),('1','151','220226','314',427.00,460.00,0.00,2062.29,880597.83,948653.40,68055.57,632941),('1','151','220514','314',427.00,460.00,0.00,2507.51,1070706.77,1153454.60,82747.83,633681),('1','151','220691','314',427.00,460.00,0.00,2310.32,986506.64,1062747.20,76240.56,634139),('1','151','221000','314',427.00,460.00,0.00,3454.51,1475075.77,1589074.60,113998.83,634952),('1','151','221142','314',427.00,460.00,0.00,1158.62,494730.74,532965.20,38234.46,635312),('1','151','221273','314',427.00,460.00,0.00,1458.55,622800.85,670933.00,48132.15,635657),('1','151','221389','314',427.00,460.00,0.00,3128.01,1335660.27,1438884.60,103224.33,635959),('1','151','221619','314',427.00,460.00,0.00,4135.56,1765884.12,1902357.60,136473.48,636560),('1','151','221835','314',427.00,460.00,0.00,3924.58,1675795.66,1805306.80,129511.14,637121),('1','151','222046','314',427.00,460.00,0.00,2791.02,1191765.54,1283869.20,92103.66,637685),('1','151','222262','314',427.00,460.00,0.00,2879.23,1229431.21,1324445.80,95014.59,638225),('1','151','222482','314',427.00,460.00,0.00,1458.53,622792.31,670923.80,48131.49,638791),('1','151','222659','314',427.00,460.00,0.00,1363.66,582282.82,627283.60,45000.78,639265),('1','151','222768','314',427.00,460.00,0.00,2789.43,1191086.61,1283137.80,92051.19,639535),('1','151','222937','314',427.00,460.00,0.00,3216.63,1373501.01,1479649.80,106148.79,640000),('1','151','223180','314',427.00,460.00,0.00,269.02,114871.54,124711.80,9840.26,640627),('1','151','223217','314',427.00,480.00,0.00,1084.35,463017.45,520488.00,57470.55,640711),('1','151','223321','314',427.00,480.00,0.00,1158.05,494487.35,555864.00,61376.65,640967),('1','151','223404','314',427.00,480.00,0.00,2567.91,1096497.57,1232596.80,136099.23,641187),('1','151','223632','314',427.00,480.00,0.00,2891.38,1234619.26,1387862.40,153243.14,641761),('1','151','223884','314',427.00,480.00,0.00,2838.35,1277149.02,1362408.00,85258.98,642398),('1','151','224071','314',480.00,480.00,0.00,2452.22,1175162.37,1177065.60,1903.23,642900),('1','151','224305','314',457.00,540.00,0.00,3124.30,1411399.39,1664847.36,253447.97,643500),('1','151','224552','314',457.00,540.00,0.00,1379.70,630854.90,745038.00,114183.10,644141),('1','151','224693','314',540.00,540.00,0.00,842.95,455193.00,455193.00,0.00,644520),('1','151','224775','314',540.00,540.00,0.00,2664.00,1438560.00,1438560.00,0.00,644719),('1','151','225006','314',540.00,540.00,0.00,902.86,487544.40,487544.40,0.00,645319),('1','151','225193','314',458.00,540.00,0.00,1607.90,736418.20,868266.00,131847.80,645803),('1','151','225250','314',458.00,540.00,0.00,2935.48,1344449.84,1585159.20,240709.36,645958),('1','151','225503','314',458.00,540.00,0.00,2861.78,1310695.24,1545361.20,234665.96,646583),('1','151','225694','314',458.00,540.00,0.00,1677.07,768098.06,905617.80,137519.74,647091),('1','151','225910','314',457.00,540.00,0.00,275.44,125876.08,148737.60,22861.52,647672),('1','151','225968','314',457.00,540.00,0.00,3089.01,1411677.57,1668065.40,256387.83,647806),('1','151','226278','314',457.00,540.00,0.00,3112.98,1422631.86,1681009.20,258377.34,648609),('1','151','226492','314',457.00,540.00,0.00,304.08,138964.56,164203.20,25238.64,649143),('1','151','226639','314',457.00,540.00,0.00,742.79,356539.20,401106.60,44567.40,649547),('1','151','226759','314',480.00,540.00,0.00,2670.66,1281916.80,1442156.40,160239.60,649838),('1','151','227030','314',480.00,540.00,0.00,2240.31,1075348.80,1209767.40,134418.60,650552),('1','151','227176','314',480.00,540.00,0.00,485.69,233131.20,262272.60,29141.40,650938),('1','151','227791','314',480.00,540.00,0.00,212.71,102100.80,114863.40,12762.60,652527),('1','151','228107','314',480.00,540.00,0.00,513.25,246360.00,277155.00,30795.00,653365),('1','151','228175','314',480.00,540.00,0.00,155.07,74433.60,83737.80,9304.20,653529),('1','151','228494','314',480.00,540.00,0.00,1238.51,594484.80,668795.40,74310.60,654362),('1','151','229167','314',480.00,540.00,0.00,4182.91,2099820.82,2258771.40,158950.58,656090),('1','151','229408','314',502.00,540.00,0.00,3608.21,1806066.56,2031206.20,225139.64,656710),('1','151','229652','314',502.00,584.00,0.00,3180.71,1596716.42,1857534.64,260818.22,657338),('1','151','229879','314',502.00,584.00,0.00,2962.84,1487345.68,1730298.56,242952.88,657913),('1','151','230121','314',502.00,584.00,0.00,2075.44,1041870.88,1212056.96,170186.08,658527),('1','151','230506','314',502.00,584.00,0.00,24.66,12379.32,14401.44,2022.12,659544),('1','151','230507','314',502.00,584.00,0.00,3148.34,1580466.68,1838630.56,258163.88,659545),('1','151','230782','314',502.00,584.00,0.00,2989.89,1500924.78,1746095.76,245170.98,660249),('1','151','231087','314',502.00,584.00,0.00,2442.92,1226345.84,1426665.28,200319.44,661046),('1','151','231361','314',502.00,584.00,0.00,249.19,125093.38,145526.96,20433.58,661799),('1','151','231454','314',526.00,584.00,0.00,1818.06,956299.56,1061747.04,105447.48,662032),('1','151','231622','314',526.00,584.00,0.00,2512.39,1321517.14,1467235.76,145718.62,662489),('1','151','231897','314',526.00,584.00,0.00,2605.57,1370529.82,1521652.88,151123.06,663221),('1','151','232122','314',526.00,584.00,0.00,1949.40,1025384.40,1138449.60,113065.20,663810),('1','151','232327','314',526.00,584.00,0.00,2856.33,1502429.58,1668096.72,165667.14,664343),('1','151','232593','314',526.00,584.00,0.00,1667.55,877131.30,973849.20,96717.90,665044),('1','151','232753','314',542.00,584.00,0.00,450.33,244078.86,262992.72,18913.86,665470),('1','151','232849','314',542.00,584.00,0.00,3321.15,1800063.30,1939551.60,139488.30,665727),('1','151','233109','314',542.00,584.00,0.00,2482.08,1309651.84,1449534.72,139882.88,666405),('1','151','233366','314',526.00,584.00,0.00,2762.96,1453316.96,1613568.64,160251.68,667081),('1','151','233583','314',526.00,584.00,0.00,2905.05,1528056.30,1696549.20,168492.90,667659),('1','151','233834','314',526.00,624.00,0.00,1596.95,839995.70,996496.80,156501.10,668309),('1','151','233952','314',526.00,624.00,0.00,2995.97,1575880.22,1869485.28,293605.06,668616),('1','151','234301','314',526.00,624.00,0.00,1468.91,772646.66,916599.84,143953.18,669547),('1','151','234505','314',526.00,624.00,0.00,947.93,498611.18,591508.32,92897.14,670093),('1','151','234575','314',526.00,624.00,0.00,2651.95,1394925.70,1654816.80,259891.10,670263),('1','151','234820','314',526.00,624.00,0.00,2537.36,1334651.36,1583312.64,248661.28,670917),('1','151','235100','314',526.00,624.00,0.00,690.81,363366.06,431065.44,67699.38,671664),('1','151','235177','314',572.00,624.00,0.00,1179.26,674536.72,735858.24,61321.52,671868),('1','151','235378','314',572.00,624.00,0.00,2509.55,1435462.60,1565959.20,130496.60,672383),('1','151','235525','314',572.00,624.00,0.00,2141.76,1225086.72,1336458.24,111371.52,672762),('1','151','235754','314',574.00,640.00,0.00,2893.41,1659727.38,1851782.40,192055.02,673356),('1','151','236059','314',572.00,640.00,0.00,2537.15,1451249.80,1623776.00,172526.20,674154),('1','151','236236','314',572.00,640.00,0.00,2184.85,1249734.20,1398304.00,148569.80,674632),('1','151','236512','314',572.00,640.00,0.00,2713.74,1552259.28,1736793.60,184534.32,675362),('1','151','236736','314',572.00,640.00,0.00,2080.78,1190206.16,1331699.20,141493.04,675933),('1','151','236869','314',572.00,640.00,0.00,691.95,395795.40,442848.00,47052.60,676285),('1','151','236999','314',572.00,640.00,0.00,2788.31,1594913.32,1784518.40,189605.08,676601),('1','151','237177','314',572.00,640.00,0.00,2363.16,1351727.52,1512422.40,160694.88,677065),('1','151','237469','314',572.00,640.00,0.00,212.09,121315.48,135737.60,14422.12,677826),('1','151','237493','314',592.00,640.00,0.00,2309.71,1367348.32,1478214.40,110866.08,677890),('1','151','237604','314',592.00,656.00,0.00,2353.66,1393366.72,1512327.20,118960.48,678181),('1','151','237856','314',592.00,640.00,0.00,2526.23,1495528.16,1616787.20,121259.04,678847),('1','151','238100','314',592.00,640.00,0.00,2362.51,1398605.92,1512006.40,113400.48,679483),('1','151','238423','314',592.00,640.00,0.00,3012.40,1783340.80,1927936.00,144595.20,680291),('1','151','238610','314',592.00,640.00,0.00,1696.70,1004446.40,1085888.00,81441.60,680785),('1','151','238758','314',592.00,640.00,0.00,615.15,364168.80,393696.00,29527.20,681174),('1','151','238844','314',592.00,640.00,0.00,2339.41,1384930.72,1497222.40,112291.68,681388),('1','151','239067','314',592.00,640.00,0.00,1775.48,1051084.16,1136307.20,85223.04,681966),('1','151','239225','314',592.00,640.00,0.00,92.93,55014.56,59475.20,4460.64,682394),('1','151','239295','314',592.00,640.00,0.00,2491.09,1474725.28,1594297.60,119572.32,682566),('1','151','239525','314',592.00,640.00,0.00,1960.26,1094502.00,1179966.00,85464.00,683170),('1','151','239694','314',592.00,640.00,0.00,608.01,359941.92,389126.40,29184.48,683609),('1','151','239800','314',592.00,656.00,0.00,360.90,213652.80,236750.40,23097.60,683875),('1','151','239857','314',612.00,656.00,0.00,1856.24,1136018.88,1217693.44,81674.56,684029),('1','151','240030','314',612.00,656.00,0.00,2109.62,1291087.44,1383910.72,92823.28,684464),('1','151','240205','314',612.00,656.00,0.00,753.17,460940.04,494079.52,33139.48,684930),('1','151','240290','314',612.00,656.00,0.00,1040.38,636712.56,682489.28,45776.72,685141),('1','151','240449','314',612.00,640.00,0.00,2117.28,1295775.36,1355059.20,59283.84,685567),('1','151','240749','314',612.00,640.00,0.00,1374.91,841444.92,879942.40,38497.48,686294),('1','151','240839','314',612.00,640.00,0.00,732.62,448363.44,468876.80,20513.36,686539),('1','151','240973','314',612.00,640.00,0.00,2688.03,1645074.36,1720339.20,75264.84,686909),('1','151','241225','314',612.00,640.00,0.00,1070.06,654876.72,684838.40,29961.68,687567),('1','151','241386','314',612.00,640.00,0.00,403.27,246801.24,258092.80,11291.56,687998),('1','151','241495','314',612.00,640.00,0.00,1726.28,1056483.36,1104819.20,48335.84,688287),('1','151','241720','314',612.00,640.00,0.00,2359.46,1443989.52,1510054.40,66064.88,688883),('1','151','241956','314',612.00,640.00,0.00,865.89,529924.68,554169.60,24244.92,689513),('1','151','242128','314',602.00,640.00,0.00,699.31,420984.62,447558.40,26573.78,689944),('1','151','242196','314',602.00,640.00,0.00,2390.08,1438828.16,1529651.20,90823.04,690119),('1','151','242420','314',602.00,640.00,0.00,2094.98,1261177.96,1340787.20,79609.24,690697),('1','151','242598','314',602.00,640.00,0.00,638.39,384310.78,408569.60,24258.82,691164),('1','151','242653','314',602.00,640.00,0.00,2746.21,1653218.42,1757574.40,104355.98,691311),('1','151','242916','314',602.00,640.00,0.00,1770.51,1128803.52,1133126.40,4322.88,691991),('1','151','243060','314',602.00,640.00,0.00,493.62,297159.24,315916.80,18757.56,692369),('1','151','243128','314',602.00,640.00,0.00,3092.98,1861973.96,1979507.20,117533.24,692552),('1','151','243363','314',602.00,640.00,0.00,881.53,530681.06,564179.20,33498.14,693169),('1','151','243477','314',602.00,640.00,0.00,967.07,582176.14,618924.80,36748.66,693448),('1','151','243596','314',602.00,640.00,0.00,2676.93,1611511.86,1713235.20,101723.34,693758),('1','151','243823','314',602.00,640.00,0.00,2445.62,1472263.24,1565196.80,92933.56,694356),('1','151','244043','314',602.00,640.00,0.00,2032.34,1223468.68,1300697.60,77228.92,694915),('1','151','244229','314',602.00,640.00,0.00,269.61,162305.22,172550.40,10245.18,695411),('1','151','244298','314',602.00,640.00,0.00,1570.66,945537.32,1005222.40,59685.08,695583),('1','151','244426','314',592.00,640.00,0.00,927.01,548789.92,593286.40,44496.48,695913),('1','151','244510','314',592.00,640.00,0.00,2170.79,1285107.68,1389305.60,104197.92,696134),('1','151','244744','314',592.00,640.00,0.00,1384.06,819363.52,885798.40,66434.88,696747),('1','151','244886','314',597.00,640.00,0.00,797.63,476185.11,510483.20,34298.09,697121),('1','151','244963','314',570.00,624.00,0.00,2605.93,1485380.10,1626100.32,140720.22,697321),('1','151','245218','314',570.00,624.00,0.00,1064.92,607004.40,664510.08,57505.68,697966),('1','151','245311','314',570.00,624.00,0.00,867.01,494195.70,541014.24,46818.54,698198),('1','151','245427','314',570.00,624.00,0.00,5429.77,3094968.90,3388076.48,293107.58,698512),('1','151','245989','314',570.00,616.00,0.00,1817.85,1036174.50,1119795.60,83621.10,699960),('1','151','246107','314',570.00,616.00,0.00,574.21,327299.70,353713.36,26413.66,700273),('1','151','246190','314',570.00,616.00,0.00,2646.24,1508356.80,1630083.84,121727.04,700472),('1','151','246446','314',570.00,616.00,0.00,2839.83,1618703.10,1749335.28,130632.18,701166),('1','151','246701','314',570.00,616.00,0.00,298.48,170133.60,183863.68,13730.08,701831),('1','151','246794','314',570.00,616.00,0.00,1800.31,1026176.70,1108990.96,82814.26,702056),('1','151','246940','314',570.00,616.00,0.00,2381.65,1357540.50,1467096.40,109555.90,702437),('1','151','247170','314',570.00,616.00,0.00,2872.19,1637148.30,1769269.04,132120.74,703040),('1','151','247386','314',570.00,616.00,0.00,1659.76,944692.14,1022412.16,77720.02,703591),('1','151','247571','314',552.00,616.00,0.00,1057.14,583541.28,651198.24,67656.96,704073),('1','151','247681','314',552.00,616.00,0.00,2415.26,1333223.52,1487800.16,154576.64,704352),('1','151','247888','314',552.00,616.00,0.00,982.45,542312.40,605189.20,62876.80,704899),('1','151','248044','314',552.00,616.00,0.00,565.00,311880.00,348040.00,36160.00,705288),('1','151','248161','314',552.00,616.00,0.00,2425.49,1338870.48,1494101.84,155231.36,705596),('1','151','248414','314',552.00,616.00,0.00,1494.10,824743.20,920365.60,95622.40,706247),('1','151','248545','314',552.00,616.00,0.00,607.34,335251.68,374121.44,38869.76,706582),('1','151','248646','314',552.00,616.00,0.00,2140.48,1181544.96,1318535.68,136990.72,706841),('1','151','248863','314',552.00,600.00,0.00,2120.43,1170477.36,1272258.00,101780.64,707402),('1','151','249122','314',552.00,600.00,0.00,1557.30,859629.60,934380.00,74750.40,708056),('1','151','249334','314',547.00,600.00,0.00,2686.60,1469570.20,1611960.00,142389.80,708616),('1','151','249586','314',547.00,600.00,0.00,1790.56,979436.32,1074336.00,94899.68,709252),('1','151','249851','314',547.00,600.00,0.00,2168.89,1186382.83,1301334.00,114951.17,709932),('1','151','250099','314',547.00,600.00,0.00,2319.28,1268646.16,1391568.00,122921.84,710565),('1','151','250355','314',547.00,600.00,0.00,184.81,101091.07,110886.00,9794.93,711206),('1','151','250405','314',547.00,600.00,0.00,2086.09,1151521.68,1184899.12,33377.44,711328),('1','151','250560','314',552.00,568.00,0.00,2224.43,1227885.36,1263476.24,35590.88,711739),('1','151','250793','314',552.00,568.00,0.00,2821.97,1557727.44,1602878.96,45151.52,712351),('1','151','251020','314',552.00,568.00,0.00,1675.82,925052.64,951865.76,26813.12,712933),('1','151','251186','314',552.00,568.00,0.00,777.55,429207.60,441648.40,12440.80,713362),('1','151','251274','314',552.00,568.00,0.00,2871.84,1585255.68,1631205.12,45949.44,713592),('1','151','251516','314',552.00,568.00,0.00,2673.52,1475783.04,1518559.36,42776.32,714227),('1','151','251762','314',552.00,568.00,0.00,168.46,92989.92,95685.28,2695.36,714872),('1','151','251848','314',552.00,527.00,0.00,0.00,0.00,0.00,0.00,715088),('1','151','251856','314',527.00,568.00,0.00,1543.19,813261.13,876531.92,63270.79,715108),('1','151','251997','314',527.00,568.00,0.00,2839.84,1496595.68,1613029.12,116433.44,715490),('1','151','252232','314',527.00,568.00,0.00,1570.34,827569.18,891953.12,64383.94,716113),('1','151','252489','314',527.00,568.00,0.00,2785.86,1468148.22,1582368.48,114220.26,716761),('1','151','252711','314',527.00,568.00,0.00,2477.44,1305610.88,1407185.92,101575.04,717346),('1','151','252982','314',527.00,568.00,0.00,2614.33,1377751.91,1484939.44,107187.53,718037),('1','151','253316','314',527.00,568.00,0.00,2393.47,1261358.69,1359490.96,98132.27,718912),('1','151','253485','314',527.00,568.00,0.00,2324.12,1224811.24,1320100.16,95288.92,719354),('1','151','253717','314',527.00,568.00,0.00,2112.73,1113408.71,1200030.64,86621.93,719953),('1','151','253972','314',527.00,568.00,0.00,2303.88,1214144.76,1308603.84,94459.08,720610),('1','151','254196','314',527.00,568.00,0.00,1003.29,528733.83,569868.72,41134.89,721203),('1','151','254324','314',527.00,527.00,0.00,0.00,0.00,0.00,0.00,721527),('1','151','254341','314',527.00,568.00,0.00,1206.05,635588.35,685036.40,49448.05,721571),('1','151','254451','314',527.00,568.00,0.00,2623.28,1382468.56,1490023.04,107554.48,721866),('1','151','254693','314',527.00,568.00,0.00,2926.29,1542154.83,1662132.72,119977.89,722477),('1','151','254941','314',527.00,568.00,0.00,1632.38,860264.26,927191.84,66927.58,723108),('1','151','255108','314',527.00,568.00,0.00,357.52,188413.04,203071.36,14658.32,723538),('1','151','255190','314',527.00,568.00,0.00,2496.54,1315676.58,1418034.72,102358.14,723750),('1','151','255462','314',527.00,568.00,0.00,1886.94,841600.33,898218.05,56617.72,724427),('1','151','255711','314',527.00,568.00,0.00,3037.70,1600867.90,1725413.60,124545.70,725040),('1','151','255943','314',527.00,568.00,0.00,1447.89,763038.03,822401.52,59363.49,725632),('1','151','256095','314',527.00,568.00,0.00,1404.05,739934.35,797500.40,57566.05,726006),('1','151','256216','314',527.00,568.00,0.00,2880.99,1518281.73,1636402.32,118120.59,726297),('1','151','256483','314',527.00,568.00,0.00,2474.39,1304003.53,1405453.52,101449.99,726998),('1','151','256662','314',527.00,527.00,0.00,0.00,0.00,0.00,0.00,727464),('1','151','256762','314',527.00,568.00,0.00,2845.42,1499536.34,1616198.56,116662.22,727696),('1','151','256994','314',527.00,568.00,0.00,1832.06,965495.62,1040610.08,75114.46,728313),('1','151','257138','314',527.00,568.00,0.00,666.49,351240.23,378566.32,27326.09,728702),('1','151','257321','314',527.00,568.00,0.00,2771.90,1347692.30,1445985.70,98293.40,729160),('1','151','257498','314',527.00,568.00,0.00,2860.69,1507583.63,1624871.92,117288.29,729642),('1','151','257499','314',527.00,568.00,0.00,1703.29,897633.83,967468.72,69834.89,729643),('1','151','257500','314',527.00,568.00,0.00,294.50,155201.50,167276.00,12074.50,729644),('1','151','257501','314',527.00,568.00,0.00,3686.58,1890530.05,2034579.86,144049.81,729645),('1','151','257502','314',527.00,568.00,0.00,734.36,387007.72,417116.48,30108.76,729646),('1','151','257503','314',527.00,568.00,0.00,1566.56,825577.12,889806.08,64228.96,729647),('1','151','257504','314',527.00,568.00,0.00,3135.11,1652202.97,1780742.48,128539.51,729648),('1','151','257505','314',527.00,568.00,0.00,2502.39,1318759.53,1421357.52,102597.99,729649),('1','151','257506','314',527.00,527.00,0.00,0.00,0.00,0.00,0.00,729650),('1','151','257507','314',517.00,568.00,0.00,3310.37,1711461.29,1880290.16,168828.87,729651),('1','151','257508','314',517.00,568.00,0.00,1192.57,616558.69,677379.76,60821.07,729652),('1','151','257509','314',517.00,568.00,0.00,1337.02,691239.34,759427.36,68188.02,729653),('1','151','257510','314',517.00,568.00,0.00,3035.63,1569420.71,1724237.84,154817.13,729654),('1','151','257511','314',517.00,568.00,0.00,3360.56,1737409.52,1908798.08,171388.56,729655),('1','151','257512','314',517.00,568.00,0.00,1121.45,579789.65,636983.60,57193.95,729656),('1','151','257513','314',517.00,568.00,0.00,832.70,430505.90,472973.60,42467.70,729657),('1','151','257514','314',517.00,568.00,0.00,2685.78,1388548.26,1525523.04,136974.78,729658),('1','151','257515','314',517.00,568.00,0.00,959.47,496045.99,544978.96,48932.97,729659),('1','151','257516','314',517.00,568.00,0.00,574.82,297181.94,326497.76,29315.82,729660),('1','151','257517','314',517.00,568.00,0.00,2703.82,1397874.94,1535769.76,137894.82,729661),('1','151','257518','314',517.00,568.00,0.00,1174.70,607319.90,667229.60,59909.70,729662),('1','151','257519','314',517.00,568.00,0.00,2414.32,1248203.44,1371333.76,123130.32,729663),('1','151','257520','314',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729664),('1','151','257521','314',517.00,568.00,0.00,1090.09,563576.53,619171.12,55594.59,729665),('1','151','257522','314',517.00,568.00,0.00,2066.54,1068401.18,1173794.72,105393.54,729666),('1','151','257523','314',517.00,568.00,0.00,2639.27,1364502.59,1499105.36,134602.77,729667),('1','151','257524','314',517.00,568.00,0.00,1884.77,974426.09,1070549.36,96123.27,729668),('1','151','257525','314',517.00,517.00,0.00,0.00,0.00,0.00,0.00,729669),('1','151','257526','314',517.00,568.00,0.00,2413.06,1247552.02,1370618.08,123066.06,729670),('1','151','257527','314',517.00,568.00,0.00,2074.79,1072666.43,1178480.72,105814.29,729671),('1','151','257528','314',517.00,568.00,0.00,2106.67,1089148.39,1196588.56,107440.17,729672),('1','151','257529','314',517.00,568.00,0.00,2071.40,1070913.80,1176555.20,105641.40,729673),('1','151','257530','314',517.00,568.00,0.00,400.24,206924.08,227336.32,20412.24,729674),('1','151','257531','314',517.00,568.00,0.00,1606.26,830436.42,912355.68,81919.26,729675),('1','151','257532','314',517.00,568.00,0.00,1968.66,1017797.22,1118198.88,100401.66,729676),('1','151','257533','314',517.00,568.00,0.00,937.48,484677.16,532488.64,47811.48,729677),('1','151','257534','314',517.00,568.00,0.00,1095.49,566368.33,622238.32,55869.99,729678),('1','151','257535','314',517.00,568.00,0.00,2102.80,1087147.60,1194390.40,107242.80,729679),('1','151','257536','314',517.00,517.00,0.00,0.00,0.00,0.00,0.00,729680),('1','151','257537','314',527.00,568.00,0.00,1963.47,1034748.69,1115250.96,80502.27,729681),('1','151','257538','314',527.00,568.00,0.00,2473.35,1303455.45,1404862.80,101407.35,729682),('1','151','257539','314',527.00,568.00,0.00,2073.68,1092829.36,1177850.24,85020.88,729683),('1','151','257540','314',527.00,568.00,0.00,2294.09,1208985.43,1303043.12,94057.69,729684),('1','151','257541','314',527.00,568.00,0.00,2795.83,1473402.41,1588031.44,114629.03,729685),('1','151','257542','314',527.00,568.00,0.00,1883.30,992499.10,1069714.40,77215.30,729686),('1','151','257543','314',527.00,568.00,0.00,1482.71,781388.17,842179.28,60791.11,729687),('1','151','257544','314',527.00,568.00,0.00,543.91,286640.57,308940.88,22300.31,729688),('1','151','257545','314',527.00,568.00,0.00,2478.21,1306016.67,1407623.28,101606.61,729689),('1','151','257546','314',527.00,568.00,0.00,2573.63,1356303.01,1461821.84,105518.83,729690),('1','151','257547','314',527.00,640.00,0.00,1952.41,1028920.07,1249542.40,220622.33,729691),('1','151','257548','314',527.00,640.00,0.00,2257.59,1189749.93,1444857.60,255107.67,729692),('1','151','257549','314',527.00,517.00,0.00,0.00,0.00,0.00,0.00,729693),('1','151','257550','314',527.00,640.00,0.00,2150.84,1133492.68,1376537.60,243044.92,729694),('1','151','257551','314',527.00,640.00,0.00,2390.22,1259645.94,1529740.80,270094.86,729695),('1','151','257552','314',527.00,640.00,0.00,2001.36,1054716.72,1280870.40,226153.68,729696),('1','151','257553','314',527.00,640.00,0.00,2494.32,1314506.64,1596364.80,281858.16,729697),('1','151','257554','314',527.00,680.00,0.00,2873.71,1514445.17,1954122.80,439677.63,729698),('1','151','257555','314',527.00,680.00,0.00,1619.43,853439.61,1101212.40,247772.79,729699),('1','151','257556','314',527.00,680.00,0.00,88.43,46602.61,60132.40,13529.79,729700),('1','151','257557','314',527.00,680.00,0.00,2362.25,1199031.32,1537214.87,338183.55,729701),('1','151','257558','314',527.00,640.00,0.00,2407.03,1268504.81,1540499.20,271994.39,729702),('1','151','257559','314',527.00,640.00,0.00,268.70,141604.90,171968.00,30363.10,729703),('1','151','257560','314',527.00,640.00,0.00,1121.89,591236.03,718009.60,126773.57,729704),('1','151','257561','314',527.00,640.00,0.00,2514.09,1324925.43,1609017.60,284092.17,729705),('1','151','257562','314',527.00,640.00,0.00,849.58,447728.66,543731.20,96002.54,729706),('1','151','257563','314',527.00,640.00,0.00,1329.11,700440.97,850630.40,150189.43,729707),('1','151','257564','314',527.00,640.00,0.00,2001.40,1054737.80,1280896.00,226158.20,729708),('1','151','257565','314',527.00,640.00,0.00,2169.57,1143363.39,1388524.80,245161.41,729709),('1','151','257566','314',527.00,640.00,0.00,2105.53,1109614.31,1347539.20,237924.89,729710),('1','151','257567','314',527.00,640.00,0.00,1985.03,1046110.81,1270419.20,224308.39,729711),('1','151','257568','314',527.00,640.00,0.00,1907.09,1005036.43,1220537.60,215501.17,729712),('1','151','257569','314',527.00,680.00,0.00,2589.42,1364624.34,1760805.60,396181.26,729713),('1','151','257570','314',527.00,680.00,0.00,2698.73,1422230.71,1835136.40,412905.69,729714),('1','151','257571','314',527.00,680.00,0.00,2383.75,1256236.25,1620950.00,364713.75,729715),('1','151','257572','314',527.00,680.00,0.00,1643.90,866335.30,1117852.00,251516.70,729716),('1','151','257573','314',612.00,640.00,0.00,3322.35,2033278.20,2126304.00,93025.80,729717),('1','151','257574','314',612.00,640.00,0.00,1411.47,863819.64,903340.80,39521.16,729718),('1','151','257575','314',612.00,640.00,0.00,2514.94,1539143.28,1609561.60,70418.32,729719),('1','151','257576','314',612.00,640.00,0.00,2027.06,1240560.72,1297318.40,56757.68,729720),('1','151','257577','314',612.00,640.00,0.00,753.62,461215.44,482316.80,21101.36,729721),('1','151','257578','314',612.00,640.00,0.00,3815.32,2334975.84,2441804.80,106828.96,729722),('1','151','257579','314',612.00,640.00,0.00,3070.12,1878913.44,1964876.80,85963.36,729723),('1','151','257580','314',612.00,640.00,0.00,1516.23,927932.76,970387.20,42454.44,729724),('1','151','257581','314',612.00,640.00,0.00,2940.34,1799488.08,1881817.60,82329.52,729725),('1','151','257582','314',612.00,640.00,0.00,1533.44,938465.28,981401.60,42936.32,729726),('1','151','257583','314',612.00,640.00,0.00,184.11,112675.32,117830.40,5155.08,729727),('1','151','257584','314',612.00,640.00,0.00,1876.76,1148577.12,1201126.40,52549.28,729728),('1','151','257585','314',612.00,640.00,0.00,1269.92,777191.04,812748.80,35557.76,729729),('1','151','257586','314',612.00,640.00,0.00,2238.78,1370133.36,1432819.20,62685.84,729730),('1','151','257587','314',612.00,640.00,0.00,1359.72,832148.64,870220.80,38072.16,729731),('1','151','257588','314',612.00,640.00,0.00,445.75,272799.00,285280.00,12481.00,729732),('1','151','257589','314',612.00,640.00,0.00,2281.01,1395978.12,1459846.40,63868.28,729733),('1','151','257590','314',612.00,640.00,0.00,1706.28,1044243.36,1092019.20,47775.84,729734),('1','151','257591','314',612.00,640.00,0.00,1217.48,745097.76,779187.20,34089.44,729735),('1','151','257592','314',612.00,640.00,0.00,797.70,488192.40,510528.00,22335.60,729736),('1','151','257593','314',612.00,640.00,0.00,2043.47,1250603.64,1307820.80,57217.16,729737),('1','151','257594','314',612.00,640.00,0.00,1933.71,1183430.52,1237574.40,54143.88,729738),('1','151','257595','314',612.00,640.00,0.00,2142.25,1311057.00,1371040.00,59983.00,729739),('1','151','257596','314',612.00,640.00,0.00,1897.48,1161257.76,1206872.28,45614.52,729740),('1','151','257597','314',612.00,636.00,0.00,529.60,324115.20,336825.60,12710.40,729741),('1','151','257598','314',612.00,636.00,0.00,970.37,593866.44,617155.32,23288.88,729742),('1','151','257599','314',612.00,636.00,0.00,1783.04,1091220.48,1134013.44,42792.96,729743),('1','151','257600','314',612.00,636.00,0.00,1227.80,751413.60,780880.80,29467.20,729744),('1','151','257601','314',612.00,636.00,0.00,1635.96,1001207.52,1040470.56,39263.04,729745),('1','151','257602','314',612.00,636.00,0.00,514.90,315118.80,327476.40,12357.60,729746),('1','151','257603','314',612.00,636.00,0.00,1849.37,1131814.44,1176199.32,44384.88,729747),('1','151','257604','314',612.00,636.00,0.00,2115.01,1294386.12,1345146.36,50760.24,729748),('1','151','257605','314',612.00,636.00,0.00,1933.68,1183412.16,1229820.48,46408.32,729749),('1','151','257606','314',612.00,636.00,0.00,2057.33,1259085.96,1308461.88,49375.92,729750),('1','151','257607','314',612.00,636.00,0.00,2265.91,1386736.92,1441118.76,54381.84,729751),('1','151','257608','314',612.00,636.00,0.00,0.00,0.00,0.00,0.00,729752),('1','151','257609','314',612.00,636.00,0.00,2507.79,1534767.48,1594954.44,60186.96,729753),('1','151','257610','314',612.00,636.00,0.00,2039.21,1247996.52,1296937.56,48941.04,729754),('1','151','257611','314',612.00,636.00,0.00,2921.78,1788129.36,1858252.08,70122.72,729755),('1','151','257612','314',612.00,636.00,0.00,1137.36,696064.32,723360.96,27296.64,729756),('1','151','257613','314',612.00,612.00,0.00,0.00,0.00,0.00,0.00,729757),('1','151','257614','314',602.00,636.00,0.00,0.00,0.00,0.00,0.00,729758),('1','151','257615','314',602.00,636.00,0.00,0.00,0.00,0.00,0.00,729759),('1','151','257616','314',602.00,636.00,0.00,1557.72,937747.44,990709.92,52962.48,729760),('1','151','257617','314',602.00,636.00,0.00,1815.32,1092822.64,1154543.52,61720.88,729761),('1','151','257618','314',602.00,636.00,0.00,1143.40,688326.80,727202.40,38875.60,729762),('1','151','257619','314',602.00,636.00,0.00,555.42,334362.84,353247.12,18884.28,729763),('1','151','257620','314',602.00,636.00,0.00,2382.07,1434006.14,1514996.52,80990.38,729764),('1','151','257621','314',602.00,636.00,0.00,1571.20,945862.40,999283.20,53420.80,729765),('1','151','257622','314',602.00,636.00,0.00,2473.49,1489040.98,1573139.64,84098.66,729766),('1','151','257623','314',602.00,636.00,0.00,2231.05,1343092.10,1418947.80,75855.70,729767),('1','151','257624','314',602.00,636.00,0.00,2194.51,1321095.02,1395708.36,74613.34,729768),('1','151','257625','314',602.00,636.00,0.00,2537.68,1527683.36,1613964.48,86281.12,729769),('1','151','257626','314',602.00,636.00,0.00,2289.57,1378321.14,1456166.52,77845.38,729770),('1','151','257627','314',602.00,636.00,0.00,2242.97,1350267.94,1426528.92,76260.98,729771),('1','151','257628','314',602.00,636.00,0.00,1747.30,1051874.60,1111282.80,59408.20,729772),('1','151','257629','314',602.00,636.00,0.00,33.59,20221.18,21363.24,1142.06,729773),('1','151','257630','314',602.00,636.00,0.00,2096.99,1262387.98,1333685.64,71297.66,729774),('1','151','257631','314',602.00,696.00,0.00,1606.93,967371.86,1118423.28,151051.42,729775),('1','151','257632','314',602.00,696.00,0.00,2053.49,1236200.98,1429229.04,193028.06,729776),('1','151','257633','314',602.00,696.00,0.00,2010.07,1210062.14,1399008.72,188946.58,729777),('1','151','257634','314',602.00,696.00,0.00,748.83,450795.66,521185.68,70390.02,729778),('1','151','257635','314',602.00,696.00,0.00,1259.79,758393.58,876813.84,118420.26,729779),('1','151','257636','314',602.00,696.00,0.00,1853.80,1115987.60,1290244.80,174257.20,729780),('1','151','257637','314',602.00,696.00,0.00,1547.32,931486.64,1076934.72,145448.08,729781),('1','151','257638','314',602.00,696.00,0.00,279.24,168102.48,193203.68,25101.20,729782),('1','151','257639','314',602.00,680.00,0.00,1864.45,1122398.90,1267826.00,145427.10,729783),('1','151','257640','314',602.00,680.00,0.00,1923.66,1158043.32,1308088.80,150045.48,729784),('1','151','257641','314',602.00,680.00,0.00,498.85,300307.70,339218.00,38910.30,729785),('1','151','257642','314',602.00,680.00,0.00,1244.85,749399.70,846498.00,97098.30,729786),('1','151','257643','314',602.00,680.00,0.00,2143.08,1290134.16,1457294.40,167160.24,729787),('1','151','257644','314',660.00,740.00,0.00,2139.41,1412010.60,1583163.40,171152.80,729788),('1','151','257645','314',660.00,740.00,0.00,1659.80,1095468.00,1228252.00,132784.00,729789),('1','151','257646','314',660.00,740.00,0.00,386.24,254918.40,285817.60,30899.20,729790),('1','151','257647','314',647.00,740.00,0.00,1316.98,852086.06,974565.20,122479.14,729791),('1','151','257648','314',647.00,740.00,0.00,2187.43,1415267.21,1618698.20,203430.99,729792),('1','151','257649','314',647.00,700.00,0.00,1840.35,1190706.45,1288245.00,97538.55,729793),('1','151','257650','314',647.00,700.00,0.00,2461.50,1592590.50,1723050.00,130459.50,729794),('1','151','257651','314',647.00,680.00,0.00,520.73,336912.31,354096.40,17184.09,729795),('1','151','257652','314',647.00,680.00,0.00,1384.73,895920.31,941616.40,45696.09,729796),('1','151','257653','314',647.00,680.00,0.00,2657.56,1719441.32,1807140.80,87699.48,729797),('1','151','257654','314',647.00,680.00,0.00,689.88,446352.36,469118.40,22766.04,729798),('1','151','257655','314',647.00,680.00,0.00,2674.96,1730699.12,1818972.80,88273.68,729799),('1','151','257656','314',647.00,680.00,0.00,1837.23,1188687.81,1249316.40,60628.59,729800),('1','151','257657','314',647.00,680.00,0.00,2456.43,1589310.21,1670372.40,81062.19,729801),('1','151','257658','314',647.00,680.00,0.00,2051.11,1327068.17,1394754.80,67686.63,729802),('1','151','257659','314',647.00,680.00,0.00,2577.84,1667862.48,1752931.20,85068.72,729803),('1','151','257660','314',647.00,680.00,0.00,224.90,145510.30,152932.00,7421.70,729804),('1','151','257661','314',647.00,647.00,0.00,0.00,0.00,0.00,0.00,729805),('1','151','257662','314',682.00,750.00,0.00,1795.59,1224592.38,1243101.60,18509.22,729806),('1','151','257663','314',682.00,680.00,0.00,2191.10,1494330.20,1489948.00,-4382.20,729807),('1','151','257664','314',682.00,680.00,0.00,383.52,261560.64,260793.60,-767.04,729808),('1','151','257665','314',682.00,750.00,0.00,1362.88,929484.16,1022160.00,92675.84,729809),('1','151','257666','314',682.00,750.00,0.00,2170.70,1480417.40,1628025.00,147607.60,729810),('1','151','257667','314',682.00,750.00,0.00,974.42,664554.44,730815.00,66260.56,729811),('1','151','257668','314',682.00,750.00,0.00,628.72,428787.04,471540.00,42752.96,729812),('1','151','257669','314',682.00,750.00,0.00,2743.92,1871353.44,2057940.00,186586.56,729813),('1','151','257670','314',682.00,750.00,0.00,1164.70,794325.40,873525.00,79199.60,729814),('1','151','257671','314',682.00,750.00,0.00,853.49,582080.18,640117.50,58037.32,729815),('1','151','257672','314',682.00,750.00,0.00,2488.02,1696829.64,1866015.00,169185.36,729816),('1','151','257673','314',682.00,750.00,0.00,1168.85,797155.70,876637.50,79481.80,729817),('1','151','257674','314',682.00,750.00,0.00,816.77,557037.14,612577.50,55540.36,729818),('1','151','257675','314',682.00,750.00,0.00,2019.88,1377558.16,1514910.00,137351.84,729819),('1','151','257676','314',682.00,750.00,0.00,1699.57,1159106.74,1274677.50,115570.76,729820),('1','151','257677','314',682.00,750.00,0.00,433.42,295592.44,325065.00,29472.56,729821),('1','151','257678','314',682.00,750.00,0.00,2043.50,1393667.00,1532625.00,138958.00,729822),('1','151','257679','314',682.00,682.00,0.00,0.00,0.00,0.00,0.00,729823),('1','151','257680','314',692.00,750.00,0.00,2016.92,1395708.64,1512690.00,116981.36,729824),('1','151','257681','314',692.00,750.00,0.00,930.08,643615.36,697560.00,53944.64,729825),('1','151','257682','314',692.00,750.00,0.00,503.88,348684.96,377910.00,29225.04,729826),('1','151','257683','314',692.00,750.00,0.00,2180.15,1508663.80,1635112.50,126448.70,729827),('1','151','257684','314',692.00,750.00,0.00,1904.19,1317699.48,1428142.50,110443.02,729828),('1','151','257685','314',692.00,750.00,0.00,1965.10,1359849.20,1473825.00,113975.80,729829),('1','151','257686','314',692.00,750.00,0.00,1950.70,1349884.40,1463025.00,113140.60,729830),('1','151','257687','314',692.00,750.00,0.00,695.24,481106.08,521430.00,40323.92,729831),('1','151','257688','314',692.00,750.00,0.00,1084.86,750723.12,813645.00,62921.88,729832),('1','151','257689','314',692.00,750.00,0.00,2528.19,1749507.48,1896142.50,146635.02,729833),('1','151','257690','314',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729834),('1','151','257691','314',692.00,750.00,0.00,956.36,661801.12,717270.00,55468.88,729835),('1','151','257692','314',692.00,750.00,0.00,595.02,411753.84,446265.00,34511.16,729836),('1','151','257693','314',692.00,750.00,0.00,2558.63,1770571.96,1918972.50,148400.54,729837),('1','151','257694','314',692.00,750.00,0.00,1615.61,1118002.12,1211707.50,93705.38,729838),('1','151','257695','314',692.00,750.00,0.00,2807.42,1942734.64,2105565.00,162830.36,729839),('1','151','257696','314',692.00,750.00,0.00,2173.42,1504006.64,1630065.00,126058.36,729840),('1','151','257697','314',692.00,750.00,0.00,1174.54,812781.68,880905.00,68123.32,729841),('1','151','257698','314',692.00,680.00,0.00,0.00,0.00,0.00,0.00,729842),('1','151','257699','314',692.00,750.00,0.00,389.36,269437.12,292020.00,22582.88,729843),('1','151','257700','314',692.00,750.00,0.00,2003.22,1386228.24,1502415.00,116186.76,729844),('1','151','257701','314',692.00,750.00,0.00,2223.90,1538938.80,1667925.00,128986.20,729845),('1','151','257702','314',692.00,750.00,0.00,3009.88,1940968.02,2097921.24,156953.22,729846),('1','151','257703','314',692.00,750.00,0.00,2896.44,2004336.48,2172330.00,167993.52,729847),('1','151','257704','314',692.00,750.00,0.00,3590.97,2484951.24,2693227.50,208276.26,729848),('1','151','257705','314',692.00,750.00,0.00,2162.48,1496436.16,1621860.00,125423.84,729849),('1','151','257706','314',692.00,750.00,0.00,1448.05,1002050.60,1086037.50,83986.90,729850),('1','151','257707','314',692.00,750.00,0.00,1474.99,1020693.08,1106242.50,85549.42,729851),('1','151','257708','314',692.00,750.00,0.00,1516.75,1049591.00,1137562.50,87971.50,729852),('1','151','257709','314',692.00,750.00,0.00,1966.74,1360984.08,1475055.00,114070.92,729853),('1','151','257710','314',692.00,750.00,0.00,2060.55,1425900.60,1545412.50,119511.90,729854),('1','151','257711','314',692.00,750.00,0.00,29.14,20164.88,21855.00,1690.12,729855),('1','151','257712','314',692.00,750.00,0.00,1384.50,958074.00,1038375.00,80301.00,729856),('1','151','257713','314',692.00,750.00,0.00,2011.79,1392158.68,1508842.50,116683.82,729857),('1','151','257714','314',692.00,750.00,0.00,2163.35,1426100.27,1542764.37,116664.10,729858),('1','151','257715','314',692.00,750.00,0.00,2325.33,1609128.36,1743997.50,134869.14,729859),('1','151','257716','314',692.00,750.00,0.00,2738.20,1894834.40,2053650.00,158815.60,729860),('1','151','257717','314',692.00,750.00,0.00,2279.65,1577517.80,1709737.50,132219.70,729861),('1','151','257718','314',692.00,750.00,0.00,2139.10,1480257.20,1604325.00,124067.80,729862),('1','151','257719','314',692.00,750.00,0.00,1652.70,1143668.40,1239525.00,95856.60,729863),('1','151','257720','314',692.00,750.00,0.00,1883.50,1303382.00,1412625.00,109243.00,729864),('1','151','257721','314',692.00,750.00,0.00,1672.55,1157404.60,1254412.50,97007.90,729865),('1','151','257722','314',692.00,750.00,0.00,1964.40,1359364.80,1473300.00,113935.20,729866),('1','151','257723','314',692.00,750.00,0.00,2312.67,1600367.64,1734502.50,134134.86,729867),('1','151','257724','314',692.00,750.00,0.00,395.16,273450.72,296370.00,22919.28,729868),('1','151','257725','314',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729869),('1','151','257726','314',692.00,750.00,0.00,1831.99,1267737.08,1373992.50,106255.42,729870),('1','151','257727','314',692.00,750.00,0.00,2000.00,1384000.00,1500000.00,116000.00,729871),('1','151','257728','314',692.00,750.00,0.00,2112.71,1461995.32,1584532.50,122537.18,729872),('1','151','257729','314',692.00,750.00,0.00,1901.09,1315554.28,1425817.50,110263.22,729873),('1','151','257730','314',692.00,750.00,0.00,1869.71,1293839.32,1402282.50,108443.18,729874),('1','151','257731','314',692.00,750.00,0.00,2219.83,1536122.36,1664872.50,128750.14,729875),('1','151','257732','314',692.00,750.00,0.00,2117.74,1465476.08,1588305.00,122828.92,729876),('1','151','257733','314',692.00,750.00,0.00,2392.94,1655914.48,1794705.00,138790.52,729877),('1','151','257734','314',692.00,750.00,0.00,2767.90,1915386.80,2075925.00,160538.20,729878),('1','151','257735','314',692.00,750.00,0.00,2411.97,1669083.24,1808977.50,139894.26,729879),('1','151','257736','314',692.00,750.00,0.00,2424.82,1677975.44,1818615.00,140639.56,729880),('1','151','257737','314',685.00,750.00,0.00,2588.42,1773067.70,1941315.00,168247.30,729881),('1','151','257738','314',685.00,750.00,0.00,1936.45,1326468.25,1452337.50,125869.25,729882),('1','151','257739','314',685.00,750.00,0.00,2616.67,1792418.95,1962502.50,170083.55,729883),('1','151','257740','314',685.00,750.00,0.00,827.12,566577.20,620340.00,53762.80,729884),('1','151','257741','314',685.00,750.00,0.00,1167.67,799853.95,875752.50,75898.55,729885),('1','151','257742','314',685.00,750.00,0.00,2232.69,1529392.65,1674517.50,145124.85,729886),('1','151','257743','314',685.00,750.00,0.00,1141.29,781783.65,855967.50,74183.85,729887),('1','151','257744','314',685.00,750.00,0.00,942.41,645550.85,706807.50,61256.65,729888),('1','151','257745','314',685.00,750.00,0.00,2415.99,1654953.15,1811992.50,157039.35,729889),('1','151','257746','314',685.00,750.00,0.00,1199.78,821849.30,899835.00,77985.70,729890),('1','151','257747','314',685.00,750.00,0.00,786.30,538615.50,589725.00,51109.50,729891),('1','151','257748','314',685.00,750.00,0.00,2195.64,1504013.40,1646730.00,142716.60,729892),('1','151','257749','314',685.00,750.00,0.00,2033.87,1393200.95,1525402.50,132201.55,729893),('1','151','257750','314',692.00,750.00,0.00,2368.41,1638939.72,1776307.50,137367.78,729894),('1','151','257751','314',692.00,750.00,0.00,2004.73,1387273.16,1503547.50,116274.34,729895),('1','151','257752','314',692.00,750.00,0.00,214.35,148330.20,160762.50,12432.30,729896),('1','151','257753','314',685.00,750.00,0.00,2054.15,1407092.75,1540612.50,133519.75,729897),('1','151','257754','314',685.00,750.00,0.00,2163.85,1482237.25,1622887.50,140650.25,729898),('1','151','257755','314',685.00,750.00,0.00,368.22,252230.70,276165.00,23934.30,729899),('1','151','257756','314',685.00,750.00,0.00,1467.51,1005244.35,1100632.50,95388.15,729900),('1','151','257757','314',685.00,750.00,0.00,1823.67,1249213.95,1367752.50,118538.55,729901),('1','151','257758','314',685.00,750.00,0.00,1275.23,873532.55,956422.50,82889.95,729902),('1','151','257759','314',685.00,750.00,0.00,262.85,180052.25,197137.50,17085.25,729903),('1','151','257760','314',685.00,750.00,0.00,1781.41,1220265.85,1336057.50,115791.65,729904),('1','151','257761','314',685.00,750.00,0.00,2076.49,1422395.65,1557367.50,134971.85,729905),('1','151','257762','314',685.00,750.00,0.00,445.69,305297.65,334267.50,28969.85,729906),('1','151','257763','314',685.00,750.00,0.00,1052.68,721085.80,789510.00,68424.20,729907),('1','151','257764','314',685.00,750.00,0.00,1981.73,1357485.05,1486297.50,128812.45,729908),('1','151','257765','314',685.00,750.00,0.00,1540.14,1054995.90,1155105.00,100109.10,729909),('1','151','257766','314',685.00,750.00,0.00,2563.92,1756285.20,1922940.00,166654.80,729910),('1','151','257767','314',685.00,750.00,0.00,2038.13,1396119.05,1528597.50,132478.45,729911),('1','151','257768','314',685.00,750.00,0.00,490.51,335999.35,367882.50,31883.15,729912),('1','151','257769','314',685.00,750.00,0.00,2721.54,1864254.90,2041155.00,176900.10,729913),('1','151','257770','314',685.00,750.00,0.00,1348.06,923421.10,1011045.00,87623.90,729914),('1','151','257771','314',685.00,750.00,0.00,1289.88,883567.80,967410.00,83842.20,729915),('1','151','257772','314',685.00,750.00,0.00,1255.64,860113.40,941730.00,81616.60,729916),('1','151','257773','314',685.00,750.00,0.00,600.48,411328.80,450360.00,39031.20,729917),('1','151','257774','314',685.00,750.00,0.00,2992.31,2049732.35,2244232.50,194500.15,729918),('1','151','257775','314',685.00,750.00,0.00,945.25,647496.25,708937.50,61441.25,729919),('1','151','257776','314',685.00,750.00,0.00,1188.22,813930.70,891165.00,77234.30,729920),('1','151','257777','314',685.00,750.00,0.00,2359.10,1615983.50,1769325.00,153341.50,729921),('1','151','257778','314',685.00,750.00,0.00,1006.55,689486.75,754912.50,65425.75,729922),('1','151','257779','314',685.00,750.00,0.00,1450.10,993318.50,1087575.00,94256.50,729923),('1','151','257780','314',685.00,750.00,0.00,2922.42,2001857.70,2191815.00,189957.30,729924),('1','151','257781','314',685.00,750.00,0.00,142.57,97660.45,106927.50,9267.05,729925),('1','151','257782','314',685.00,750.00,0.00,1964.47,1345661.95,1473352.50,127690.55,729926),('1','151','257783','314',685.00,750.00,0.00,2154.97,1476154.45,1616227.50,140073.05,729927),('1','151','257784','314',685.00,750.00,0.00,477.02,326758.70,357765.00,31006.30,729928),('1','151','257785','314',685.00,750.00,0.00,541.43,370879.55,406072.50,35192.95,729929),('1','151','257786','314',685.00,750.00,0.00,2380.66,1630752.10,1785495.00,154742.90,729930),('1','151','257787','314',685.00,750.00,0.00,1617.21,1107788.85,1212907.50,105118.65,729931),('1','151','257788','314',685.00,750.00,0.00,1584.36,1085286.60,1188270.00,102983.40,729932),('1','151','257789','314',685.00,750.00,0.00,2900.24,1986664.40,2175180.00,188515.60,729933),('1','151','257790','314',685.00,750.00,0.00,29.76,20385.60,22320.00,1934.40,729934),('1','151','257791','314',685.00,750.00,0.00,2977.83,2039813.55,2233372.50,193558.95,729935),('1','151','257792','314',685.00,750.00,0.00,1571.82,1076696.70,1178865.00,102168.30,729936),('1','151','257793','314',685.00,750.00,0.00,361.86,247874.10,271395.00,23520.90,729937),('1','151','257794','314',685.00,750.00,0.00,2318.45,1588138.25,1738837.50,150699.25,729938),('1','151','257795','314',685.00,750.00,0.00,1861.84,1275360.40,1396380.00,121019.60,729939),('1','151','257796','314',685.00,750.00,0.00,1283.11,878930.35,962332.50,83402.15,729940),('1','151','257797','314',685.00,750.00,0.00,1908.17,1307096.45,1431127.50,124031.05,729941),('1','151','257798','314',685.00,750.00,0.00,1353.05,926839.25,1014787.50,87948.25,729942),('1','151','257799','314',677.00,750.00,0.00,2036.35,1378608.95,1527262.50,148653.55,729943),('1','151','257800','314',677.00,750.00,0.00,2346.46,1588553.42,1759845.00,171291.58,729944),('1','151','257801','314',677.00,750.00,0.00,209.00,141493.00,156750.00,15257.00,729945),('1','151','257802','314',677.00,750.00,0.00,1785.53,1208803.81,1339147.50,130343.69,729946),('1','151','257803','314',677.00,750.00,0.00,2285.93,1547574.61,1714447.50,166872.89,729947),('1','151','257804','314',677.00,750.00,0.00,482.70,326787.90,362025.00,35237.10,729948),('1','151','257805','314',677.00,750.00,0.00,1083.19,733319.63,812392.50,79072.87,729949),('1','151','257806','314',677.00,750.00,0.00,2318.56,1569665.12,1738920.00,169254.88,729950),('1','151','257807','314',677.00,750.00,0.00,1175.30,795678.10,881475.00,85796.90,729951),('1','151','257808','314',677.00,750.00,0.00,383.06,259331.62,287295.00,27963.38,729952),('1','151','257809','314',677.00,750.00,0.00,2038.66,1380172.82,1528995.00,148822.18,729953),('1','151','257810','314',677.00,750.00,0.00,2143.63,1451237.51,1607722.50,156484.99,729954),('1','151','257811','314',677.00,750.00,0.00,2088.96,1414225.92,1566720.00,152494.08,729955),('1','151','257812','314',677.00,750.00,0.00,2462.41,1667051.57,1846807.50,179755.93,729956),('1','151','257813','314',677.00,750.00,0.00,1798.65,1217686.05,1348987.50,131301.45,729957),('1','151','257814','314',677.00,750.00,0.00,2112.13,1429912.01,1584097.50,154185.49,729958),('1','151','257815','314',677.00,750.00,0.00,646.11,437416.47,484582.50,47166.03,729959),('1','151','257816','314',677.00,750.00,0.00,1024.03,693268.31,768022.50,74754.19,729960),('1','151','257817','314',677.00,750.00,0.00,1966.70,1331455.90,1475025.00,143569.10,729961),('1','151','257818','314',677.00,750.00,0.00,1566.48,1060506.96,1174860.00,114353.04,729962),('1','151','257819','314',677.00,750.00,0.00,211.26,143023.02,158445.00,15421.98,729963),('1','151','257820','314',677.00,750.00,0.00,1540.23,1042735.71,1155172.50,112436.79,729964),('1','151','257821','314',677.00,750.00,0.00,2538.28,1718415.56,1903710.00,185294.44,729965),('1','151','257822','314',677.00,750.00,0.00,1597.22,1081317.94,1197915.00,116597.06,729966),('1','151','257823','314',677.00,750.00,0.00,326.32,220918.64,244740.00,23821.36,729967),('1','151','257824','314',677.00,750.00,0.00,517.70,350482.90,388275.00,37792.10,729968),('1','151','257825','314',677.00,750.00,0.00,1874.84,1269266.68,1406130.00,136863.32,729969),('1','151','257826','314',677.00,750.00,0.00,1609.57,1089678.89,1207177.50,117498.61,729970),('1','151','257827','314',677.00,750.00,0.00,522.18,353515.86,391635.00,38119.14,729971),('1','151','257828','314',677.00,750.00,0.00,1275.99,863845.23,956992.50,93147.27,729972),('1','151','257829','314',677.00,750.00,0.00,2112.94,1430460.38,1584705.00,154244.62,729973),('1','151','257830','314',677.00,750.00,0.00,1114.60,754584.20,835950.00,81365.80,729974),('1','151','257831','314',677.00,750.00,0.00,0.00,0.00,0.00,0.00,729975),('1','151','257832','314',677.00,750.00,0.00,122.77,83115.29,92077.50,8962.21,729976),('1','151','257833','314',677.00,750.00,0.00,2136.29,1446268.33,1602217.50,155949.17,729977),('1','151','257834','314',677.00,750.00,0.00,2196.20,1486827.40,1647150.00,160322.60,729978),('1','151','257835','314',677.00,750.00,0.00,1224.80,829189.60,918600.00,89410.40,729979),('1','151','257836','314',677.00,750.00,0.00,464.46,314439.42,348345.00,33905.58,729980),('1','151','257837','314',677.00,750.00,0.00,1645.83,1114226.91,1234372.50,120145.59,729981),('1','151','257838','314',677.00,750.00,0.00,2018.48,1366510.96,1513860.00,147349.04,729982),('1','151','257839','314',677.00,750.00,0.00,867.65,587399.05,650737.50,63338.45,729983),('1','151','257840','314',677.00,750.00,0.00,787.35,533035.95,590512.50,57476.55,729984),('1','151','257841','314',677.00,780.00,0.00,1884.58,1275860.66,1469972.40,194111.74,729985),('1','151','257842','314',677.00,780.00,0.00,1868.04,1264663.08,1457071.20,192408.12,729986),('1','151','257843','314',685.00,780.00,0.00,1292.54,885389.90,1008181.20,122791.30,729987),('1','151','257844','314',685.00,780.00,0.00,3236.29,2216858.65,2524306.20,307447.55,729988),('1','151','257845','314',685.00,780.00,0.00,2339.50,1602557.50,1824810.00,222252.50,729989),('1','151','257846','314',685.00,780.00,0.00,1337.88,916447.80,1043546.40,127098.60,729990),('1','151','257847','314',685.00,780.00,0.00,2056.20,1408497.00,1603836.00,195339.00,729991),('1','151','257848','314',685.00,780.00,0.00,1047.94,717838.90,817393.20,99554.30,729992),('1','151','257849','314',685.00,780.00,0.00,100.41,68780.85,78319.80,9538.95,729993),('1','151','257850','314',685.00,780.00,0.00,2009.33,1376391.05,1567277.40,190886.35,729994),('1','151','257851','314',685.00,780.00,0.00,1834.74,1256796.90,1431097.20,174300.30,729995),('1','151','257852','314',685.00,780.00,0.00,521.04,356912.40,406411.20,49498.80,729996),('1','151','257853','314',685.00,780.00,0.00,930.40,637324.00,725712.00,88388.00,729997),('1','151','257854','314',685.00,780.00,0.00,1896.04,1298787.40,1478911.20,180123.80,729998),('1','151','257855','314',685.00,780.00,0.00,1669.97,1143929.45,1302576.60,158647.15,729999),('1','151','257856','314',685.00,780.00,0.00,1757.01,1203551.85,1370467.80,166915.95,730000),('1','151','257857','314',685.00,780.00,0.00,2208.18,1512603.30,1722380.40,209777.10,730001),('1','151','257858','314',685.00,780.00,0.00,548.81,375934.85,428071.80,52136.95,730002),('1','151','257859','314',685.00,780.00,0.00,955.08,654229.80,744962.40,90732.60,730003),('1','151','257860','314',685.00,780.00,0.00,1316.78,901994.30,1027088.40,125094.10,730004),('1','151','257861','314',685.00,780.00,0.00,1832.98,1255591.30,1429724.40,174133.10,730005),('1','151','257862','314',685.00,780.00,0.00,465.76,319045.60,363292.80,44247.20,730006),('1','151','257863','314',685.00,780.00,0.00,1098.08,752184.80,856502.40,104317.60,730007),('1','151','257864','314',685.00,780.00,0.00,2263.92,1550785.20,1765857.60,215072.40,730008),('1','151','257865','314',685.00,780.00,0.00,1699.26,1163993.10,1325422.80,161429.70,730009),('1','151','257866','314',685.00,780.00,0.00,1365.39,935292.15,1065004.20,129712.05,730010),('1','151','257867','314',685.00,780.00,0.00,2013.36,1379151.60,1570420.80,191269.20,730011),('1','151','257868','314',685.00,780.00,0.00,1795.07,1229622.95,1400154.60,170531.65,730012),('1','151','257869','314',685.00,780.00,0.00,845.08,578879.80,659162.40,80282.60,730013),('1','151','257870','314',685.00,780.00,0.00,168.25,115251.25,131235.00,15983.75,730014),('1','151','257871','314',685.00,780.00,0.00,1432.29,981118.65,1117186.20,136067.55,730015),('1','151','257872','314',685.00,780.00,0.00,2011.38,1377795.30,1568876.40,191081.10,730016),('1','151','257873','314',685.00,780.00,0.00,2676.11,1833135.35,1990201.04,157065.69,730017),('1','151','257874','314',685.00,736.00,0.00,1828.33,1252406.05,1345650.88,93244.83,730018),('1','151','257875','314',685.00,736.00,0.00,1842.95,1262420.75,1356411.20,93990.45,730019),('1','151','257876','314',685.00,736.00,0.00,2231.86,1528824.10,1642648.96,113824.86,730020),('1','151','257877','314',685.00,736.00,0.00,1898.26,1300308.10,1397119.36,96811.26,730021),('1','151','257878','314',685.00,736.00,0.00,1684.30,1153745.50,1239644.80,85899.30,730022),('1','151','257879','314',685.00,736.00,0.00,1929.47,1321686.95,1420089.92,98402.97,730023),('1','151','257880','314',685.00,736.00,0.00,886.23,607067.55,652265.28,45197.73,730024),('1','151','257881','314',685.00,736.00,0.00,1395.50,955917.50,1027088.00,71170.50,730025),('1','151','257882','314',685.00,736.00,0.00,1810.65,1240295.25,1332638.40,92343.15,730026),('1','151','257883','314',685.00,736.00,0.00,2209.11,1513240.35,1625904.96,112664.61,730027),('1','151','257884','314',685.00,736.00,0.00,2197.48,1505273.80,1617345.28,112071.48,730028),('1','151','257885','314',685.00,736.00,0.00,1958.09,1341291.65,1441154.24,99862.59,730029),('1','151','257886','314',685.00,736.00,0.00,2101.64,1439623.40,1546807.04,107183.64,730030),('1','151','257887','314',685.00,736.00,0.00,1785.32,1222944.20,1313995.52,91051.32,730031),('1','151','257888','314',685.00,736.00,0.00,2125.37,1455878.45,1564272.32,108393.87,730032),('1','151','257889','314',685.00,736.00,0.00,1857.05,1272079.25,1366788.80,94709.55,730033),('1','151','257890','314',685.00,736.00,0.00,2038.17,1396146.45,1500093.12,103946.67,730034),('1','151','257891','314',685.00,736.00,0.00,1156.91,792483.35,851485.76,59002.41,730035),('1','151','257892','314',676.00,736.00,0.00,772.19,522000.44,568331.84,46331.40,730036),('1','151','257893','314',676.00,736.00,0.00,1601.94,1082911.44,1179027.84,96116.40,730037),('1','151','257894','314',676.00,736.00,0.00,1803.62,1219247.12,1327464.32,108217.20,730038),('1','151','257895','314',676.00,736.00,0.00,1895.11,1281094.36,1394800.96,113706.60,730039),('1','151','257896','314',676.00,736.00,0.00,2046.02,1383109.52,1505870.72,122761.20,730040),('1','151','257897','314',676.00,736.00,0.00,1863.15,1259489.40,1371278.40,111789.00,730041),('1','151','257898','314',676.00,736.00,0.00,2032.69,1374098.44,1496059.84,121961.40,730042),('1','151','257899','314',676.00,736.00,0.00,2691.05,1819149.80,1980612.80,161463.00,730043),('1','151','257900','314',676.00,736.00,0.00,2025.55,1369271.80,1490804.80,121533.00,730044),('1','151','257901','314',676.00,736.00,0.00,2817.21,1904433.96,2073466.56,169032.60,730045),('1','151','257902','314',676.00,736.00,0.00,1968.50,1330706.00,1448816.00,118110.00,730046),('1','151','257903','314',676.00,736.00,0.00,1928.25,1303497.00,1419192.00,115695.00,730047),('1','151','257904','314',676.00,736.00,0.00,1313.48,887912.48,966721.28,78808.80,730048),('1','151','257905','314',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730049),('1','151','257906','314',676.00,736.00,0.00,333.66,225554.16,245573.76,20019.60,730050),('1','151','257907','314',676.00,736.00,0.00,2604.88,1760898.88,1917191.68,156292.80,730051),('1','151','257908','314',676.00,736.00,0.00,1631.23,1102711.48,1200585.28,97873.80,730052),('1','151','257909','314',676.00,736.00,0.00,2172.31,1468481.56,1598820.16,130338.60,730053),('1','151','257910','314',676.00,736.00,0.00,2305.23,1558335.48,1696649.28,138313.80,730054),('1','151','257911','314',676.00,736.00,0.00,1867.76,1262605.76,1374671.36,112065.60,730055),('1','151','257912','314',676.00,736.00,0.00,2375.96,1606148.96,1748706.56,142557.60,730056),('1','151','257913','314',676.00,736.00,0.00,2214.39,1496927.64,1629791.04,132863.40,730057),('1','151','257914','314',676.00,736.00,0.00,2377.87,1607440.12,1750112.32,142672.20,730058),('1','151','257915','314',676.00,736.00,0.00,2268.24,1533330.24,1669424.64,136094.40,730059),('1','151','257916','314',676.00,736.00,0.00,2316.81,1566163.56,1705172.16,139008.60,730060),('1','151','257917','314',676.00,736.00,0.00,2232.49,1509163.24,1643112.64,133949.40,730061),('1','151','257918','314',676.00,736.00,0.00,1911.64,1292268.64,1406967.04,114698.40,730062),('1','151','257919','314',676.00,736.00,0.00,2094.88,1416138.88,1541831.68,125692.80,730063),('1','151','257920','314',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730064),('1','151','257921','314',676.00,736.00,0.00,2136.20,1444071.20,1572243.20,128172.00,730065),('1','151','257922','314',676.00,736.00,0.00,1757.42,1188015.92,1293461.12,105445.20,730066),('1','151','257923','314',676.00,736.00,0.00,703.55,475599.80,517812.80,42213.00,730067),('1','151','257924','314',676.00,736.00,0.00,1488.85,1006462.60,1095793.60,89331.00,730068),('1','151','257925','314',676.00,736.00,0.00,2515.70,1700613.20,1851555.20,150942.00,730069),('1','151','257926','314',676.00,736.00,0.00,569.75,385151.00,419336.00,34185.00,730070),('1','151','257927','314',676.00,736.00,0.00,1708.05,1154641.80,1257124.80,102483.00,730071),('1','151','257928','314',676.00,736.00,0.00,2098.58,1418640.08,1544554.88,125914.80,730072),('1','151','257929','314',676.00,736.00,0.00,759.33,513307.08,558866.88,45559.80,730073),('1','151','257930','314',676.00,736.00,0.00,1137.96,769260.96,837538.56,68277.60,730074),('1','151','257931','314',676.00,736.00,0.00,2195.31,1484029.56,1615748.16,131718.60,730075),('1','151','257932','314',676.00,736.00,0.00,1207.99,816601.24,889080.64,72479.40,730076),('1','151','257933','314',676.00,736.00,0.00,627.09,423912.84,461538.24,37625.40,730077),('1','151','257934','314',651.00,736.00,0.00,1908.53,1242453.03,1404678.08,162225.05,730078),('1','151','257935','314',651.00,736.00,0.00,2312.00,1505112.00,1701632.00,196520.00,730079),('1','151','257936','314',651.00,736.00,0.00,406.56,264670.56,299228.16,34557.60,730080),('1','151','257937','314',651.00,736.00,0.00,1942.52,1264580.52,1429694.72,165114.20,730081),('1','151','257938','314',651.00,736.00,0.00,2168.92,1411966.92,1596325.12,184358.20,730082),('1','151','257939','314',651.00,736.00,0.00,489.63,318749.13,360367.68,41618.55,730083),('1','151','257940','314',651.00,736.00,0.00,1446.19,941469.69,1064395.84,122926.15,730084),('1','151','257941','314',651.00,736.00,0.00,2663.80,1734133.80,1960556.80,226423.00,730085),('1','151','257942','314',651.00,736.00,0.00,475.79,309739.29,350181.44,40442.15,730086),('1','151','257943','314',651.00,736.00,0.00,1164.29,757952.79,856917.44,98964.65,730087),('1','151','257944','314',651.00,736.00,0.00,2151.41,1400567.91,1583437.76,182869.85,730088),('1','151','257945','314',651.00,736.00,0.00,1213.77,790164.27,893334.72,103170.45,730089),('1','151','257946','314',651.00,736.00,0.00,937.48,610299.48,689985.28,79685.80,730090),('1','151','257947','314',651.00,736.00,0.00,1805.71,1175517.21,1329002.56,153485.35,730091),('1','151','257948','314',651.00,736.00,0.00,1793.41,1167509.91,1319949.76,152439.85,730092),('1','151','257949','314',651.00,736.00,0.00,301.57,196322.07,221955.52,25633.45,730093),('1','151','257950','314',651.00,736.00,0.00,1708.74,1112389.74,1257632.64,145242.90,730094),('1','151','257951','314',651.00,736.00,0.00,1720.59,1120104.09,1266354.24,146250.15,730095),('1','151','257952','314',651.00,736.00,0.00,1401.14,912142.14,1031239.04,119096.90,730096),('1','151','257953','314',661.00,736.00,0.00,2129.11,1407341.71,1567024.96,159683.25,730097),('1','151','257954','314',661.00,736.00,0.00,1966.63,1299942.43,1447439.68,147497.25,730098),('1','151','257955','314',661.00,736.00,0.00,1948.46,1287932.06,1434066.56,146134.50,730099),('1','151','257956','314',661.00,736.00,0.00,2363.83,1562491.63,1739778.88,177287.25,730100),('1','151','257957','314',661.00,736.00,0.00,2165.27,1431243.47,1593638.72,162395.25,730101),('1','151','257958','314',661.00,736.00,0.00,2244.63,1483700.43,1652047.68,168347.25,730102),('1','151','257959','314',661.00,736.00,0.00,2492.38,1647463.18,1834391.68,186928.50,730103),('1','151','257960','314',661.00,736.00,0.00,2126.03,1405305.83,1564758.08,159452.25,730104),('1','151','257961','314',661.00,736.00,0.00,1775.51,1173612.11,1306775.36,133163.25,730105),('1','151','257962','314',661.00,736.00,0.00,2665.65,1761994.65,1961918.40,199923.75,730106),('1','151','257963','314',661.00,736.00,0.00,2180.33,1441198.13,1604722.88,163524.75,730107),('1','151','257964','314',661.00,736.00,0.00,0.00,0.00,0.00,0.00,730108),('1','151','257965','314',661.00,736.00,0.00,2122.23,1402794.03,1561961.28,159167.25,730109),('1','151','257966','314',661.00,736.00,0.00,2157.48,1426094.28,1587905.28,161811.00,730110),('1','151','257967','314',661.00,736.00,0.00,1858.80,1228666.80,1368076.80,139410.00,730111),('1','151','257968','314',661.00,736.00,0.00,1903.72,1258358.92,1401137.92,142779.00,730112),('1','151','257969','314',661.00,736.00,0.00,1868.79,1235270.19,1375429.44,140159.25,730113),('1','151','257970','314',661.00,736.00,0.00,2356.39,1557573.79,1734303.04,176729.25,730114),('1','151','257971','314',661.00,736.00,0.00,2474.85,1635875.85,1821489.60,185613.75,730115),('1','151','257972','314',661.00,736.00,0.00,2279.56,1506789.16,1677756.16,170967.00,730116),('1','151','257973','314',661.00,736.00,0.00,2374.07,1569260.27,1747315.52,178055.25,730117),('1','151','257974','314',661.00,736.00,0.00,2328.81,1539343.41,1714004.16,174660.75,730118),('1','151','257975','314',661.00,736.00,0.00,2988.10,1975134.10,2199241.60,224107.50,730119),('1','151','257976','314',661.00,736.00,0.00,799.75,528634.75,588616.00,59981.25,730120),('1','151','257977','314',651.00,736.00,0.00,2107.38,1371904.38,1551031.68,179127.30,730121),('1','151','257978','314',651.00,736.00,0.00,2159.31,1405710.81,1589252.16,183541.35,730122),('1','151','257979','314',651.00,736.00,0.00,2077.22,1352270.22,1528833.92,176563.70,730123),('1','151','257980','314',651.00,736.00,0.00,2026.83,1319466.33,1491746.88,172280.55,730124),('1','151','257981','314',651.00,736.00,0.00,2155.65,1403328.15,1586558.40,183230.25,730125),('1','151','257982','314',651.00,736.00,0.00,1888.14,1229179.14,1389671.04,160491.90,730126),('1','151','257983','314',651.00,736.00,0.00,2115.12,1376943.12,1556728.32,179785.20,730127),('1','151','257984','314',651.00,736.00,0.00,2197.04,1430273.04,1617021.44,186748.40,730128),('1','151','257985','314',651.00,736.00,0.00,1563.26,1017682.26,1150559.36,132877.10,730129),('1','151','257986','314',651.00,736.00,0.00,2156.17,1403666.67,1586941.12,183274.45,730130),('1','151','257987','314',651.00,736.00,0.00,1332.04,867158.04,980381.44,113223.40,730131),('1','151','257988','314',651.00,736.00,0.00,36.66,23865.66,26981.76,3116.10,730132),('1','151','257989','314',651.00,736.00,0.00,1760.77,1146261.27,1278319.02,132057.75,730133),('1','151','257990','314',651.00,726.00,0.00,1451.88,945173.88,1054064.88,108891.00,730134),('1','151','257991','314',651.00,726.00,0.00,2019.80,1314889.80,1466374.80,151485.00,730135),('1','151','257992','314',651.00,726.00,0.00,2150.23,1399799.73,1561066.98,161267.25,730136),('1','151','257993','314',651.00,726.00,0.00,353.01,229809.51,256285.26,26475.75,730137),('1','151','257994','314',651.00,726.00,0.00,771.87,502487.37,560377.62,57890.25,730138),('1','151','257995','314',651.00,726.00,0.00,1338.66,871467.66,971867.16,100399.50,730139),('1','151','257996','314',651.00,726.00,0.00,2139.72,1392957.72,1553436.72,160479.00,730140),('1','151','257997','314',651.00,726.00,0.00,256.08,166708.08,185914.08,19206.00,730141),('1','151','257998','314',651.00,726.00,0.00,1124.56,732088.56,816430.56,84342.00,730142),('1','151','257999','314',651.00,726.00,0.00,2254.97,1467985.47,1637108.22,169122.75,730143),('1','151','258000','314',651.00,726.00,0.00,1119.11,728540.61,812473.86,83933.25,730144),('1','151','258001','314',651.00,726.00,0.00,1714.36,1116048.36,1244625.36,128577.00,730145),('1','151','258002','314',651.00,726.00,0.00,1704.57,1109675.07,1237517.82,127842.75,730146),('1','151','258003','314',651.00,726.00,0.00,161.80,105331.80,117466.80,12135.00,730147);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',293,'151','LPG TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=756 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','151','293',755,1,'314','LPG SKID',7000.00,1.00,1999.83,'TANK CONTAINING LPG','490','2020-07-08 22:04:19','2020-07-10 09:52:41','490',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','151',755,4338.20,'2023-03-20 11:29:01');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2753365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108039,'1','151','755',314,'Retail Sale Id 1254033',1920.00,0.00,0.00,0.00,114.00,'2021-12-01 06:17:12','',''),(2108040,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 06:17:12','',''),(2108156,'1','151','755',314,'Retail Sale Id 1254105',7040.00,0.00,0.00,0.00,418.00,'2021-12-01 06:28:41','',''),(2108157,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 06:28:41','',''),(2108279,'1','151','755',314,'Retail Sale Id 1254154',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:35:46','',''),(2108280,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:35:46','',''),(2108315,'1','151','755',314,'Retail Sale Id 1254174',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 06:38:09','',''),(2108316,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:38:09','',''),(2108339,'1','151','755',314,'Retail Sale Id 1254185',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:40:26','',''),(2108340,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:40:26','',''),(2108383,'1','151','755',314,'Retail Sale Id 1254210',499.20,0.00,0.00,0.00,29.64,'2021-12-01 06:44:36','',''),(2108384,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 06:44:36','',''),(2108536,'1','151','755',314,'Retail Sale Id 1254277',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:53:46','',''),(2108537,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:53:46','',''),(2108546,'1','151','755',314,'Retail Sale Id 1254288',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 06:54:30','',''),(2108547,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 06:54:30','',''),(2108621,'1','151','755',314,'Retail Sale Id 1254321',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 06:57:37','',''),(2108622,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:57:37','',''),(2108672,'1','151','755',314,'Retail Sale Id 1254348',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 06:59:47','',''),(2108673,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:59:47','',''),(2108963,'1','151','755',314,'Retail Sale Id 1254461',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 07:12:53','',''),(2108964,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:12:53','',''),(2109021,'1','151','755',314,'Retail Sale Id 1254491',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:16:14','',''),(2109022,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:16:14','',''),(2109041,'1','151','755',314,'Retail Sale Id 1254504',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 07:17:15','',''),(2109042,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 07:17:15','',''),(2109127,'1','151','755',314,'Retail Sale Id 1254542',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 07:21:13','',''),(2109128,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 07:21:13','',''),(2109148,'1','151','755',314,'Retail Sale Id 1254552',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 07:22:14','',''),(2109149,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:22:14','',''),(2109199,'1','151','755',314,'Retail Sale Id 1254560',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:23:14','',''),(2109200,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:23:14','',''),(2109293,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,960000.00,1500.00,0.00,0.00,'2021-12-01 07:28:42','',''),(2109308,'1','151',NULL,314,'Reception corrector for bridging 125810',0.00,0.00,0.00,1500.00,0.00,'2021-12-01 07:29:48','',''),(2109309,'1','151','755',314,'Received from bridging 125810',0.00,0.00,1500.00,0.00,0.00,'2021-12-01 07:29:48','',''),(2109326,'1','151','755',314,'Retail Sale Id 1254619',7500.80,0.00,0.00,0.00,0.00,'2021-12-01 07:31:01','',''),(2109327,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-01 07:31:01','',''),(2109336,'1','151','755',314,'Retail Sale Id 1254625',998.40,0.00,0.00,0.00,0.00,'2021-12-01 07:31:40','',''),(2109337,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:31:40','',''),(2109352,'1','151','755',314,'Retail Sale Id 1254634',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:32:31','',''),(2109353,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:32:31','',''),(2109354,'1','151','755',314,'Retail Sale Id 1254634',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:32:31','',''),(2109355,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:32:31','',''),(2109412,'1','151','755',314,'Retail Sale Id 1254670',3699.20,0.00,0.00,0.00,0.00,'2021-12-01 07:35:36','',''),(2109413,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-01 07:35:36','',''),(2109430,'1','151','755',314,'Retail Sale Id 1254678',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:36:23','',''),(2109431,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:36:23','',''),(2109444,'1','151','755',314,'Retail Sale Id 1254688',2502.40,0.00,0.00,0.00,0.00,'2021-12-01 07:37:04','',''),(2109445,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 07:37:04','',''),(2109476,'1','151','755',314,'Retail Sale Id 1254703',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:38:15','',''),(2109477,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:38:15','',''),(2109558,'1','151','755',314,'Retail Sale Id 1254731',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 07:41:27','',''),(2109559,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:41:27','',''),(2109560,'1','151','755',314,'Retail Sale Id 1254731',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:41:27','',''),(2109561,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:41:27','',''),(2109578,'1','151','755',314,'Retail Sale Id 1254743',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:42:17','',''),(2109579,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:42:17','',''),(2109580,'1','151','755',314,'Retail Sale Id 1254743',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:42:17','',''),(2109581,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:42:17','',''),(2109604,'1','151','755',314,'Retail Sale Id 1254754',7001.60,0.00,0.00,0.00,0.00,'2021-12-01 07:43:38','',''),(2109605,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 07:43:38','',''),(2109612,'1','151','755',314,'Retail Sale Id 1254760',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 07:44:17','',''),(2109613,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:44:17','',''),(2109719,'1','151','755',314,'Retail Sale Id 1254801',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 07:47:38','',''),(2109720,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:47:38','',''),(2109748,'1','151','755',314,'Retail Sale Id 1254817',1280.00,0.00,0.00,0.00,0.00,'2021-12-01 07:48:58','',''),(2109749,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:48:58','',''),(2109764,'1','151','755',314,'Retail Sale Id 1254825',998.40,0.00,0.00,0.00,0.00,'2021-12-01 07:49:43','',''),(2109765,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:49:43','',''),(2109831,'1','151','755',314,'Retail Sale Id 1254851',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:53:16','',''),(2109832,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:53:16','',''),(2110174,'1','151','755',314,'Retail Sale Id 1255022',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:12:17','',''),(2110175,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:12:17','',''),(2110216,'1','151','755',314,'Retail Sale Id 1255041',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:14:11','',''),(2110217,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:14:11','',''),(2110314,'1','151','755',314,'Retail Sale Id 1255094',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:19:48','',''),(2110315,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:19:48','',''),(2110390,'1','151','755',314,'Retail Sale Id 1255132',3001.60,0.00,0.00,0.00,0.00,'2021-12-01 08:23:44','',''),(2110391,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:23:44','',''),(2110405,'1','151','755',314,'Retail Sale Id 1255140',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 08:24:53','',''),(2110406,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:24:53','',''),(2110500,'1','151','755',314,'Retail Sale Id 1255187',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 08:31:31','',''),(2110501,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:31:31','',''),(2110531,'1','151','755',314,'Retail Sale Id 1255202',4998.40,0.00,0.00,0.00,0.00,'2021-12-01 08:33:13','',''),(2110532,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 08:33:13','',''),(2110578,'1','151','755',314,'Retail Sale Id 1255218',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:35:38','',''),(2110579,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:35:38','',''),(2110687,'1','151','755',314,'Retail Sale Id 1255271',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 08:41:19','',''),(2110688,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:41:19','',''),(2110742,'1','151','755',314,'Retail Sale Id 1255298',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 08:44:11','',''),(2110743,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:44:11','',''),(2110756,'1','151','755',314,'Retail Sale Id 1255305',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:45:19','',''),(2110757,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:45:19','',''),(2110776,'1','151','755',314,'Retail Sale Id 1255316',1203.20,0.00,0.00,0.00,0.00,'2021-12-01 08:46:46','',''),(2110777,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 08:46:46','',''),(2110862,'1','151','755',314,'Retail Sale Id 1255371',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 08:52:05','',''),(2110863,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:52:05','',''),(2110932,'1','151','755',314,'Retail Sale Id 1255408',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 08:56:07','',''),(2110933,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:56:07','',''),(2110996,'1','151','755',314,'Retail Sale Id 1255437',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 08:59:57','',''),(2110997,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:59:57','',''),(2111018,'1','151','755',314,'Retail Sale Id 1255454',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:01:16','',''),(2111019,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:01:16','',''),(2111036,'1','151','755',314,'Retail Sale Id 1255460',3500.80,0.00,0.00,0.00,0.00,'2021-12-01 09:02:14','',''),(2111037,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 09:02:14','',''),(2111052,'1','151','755',314,'Retail Sale Id 1255468',2502.40,0.00,0.00,0.00,0.00,'2021-12-01 09:03:19','',''),(2111053,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 09:03:19','',''),(2111150,'1','151','755',314,'Retail Sale Id 1255514',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 09:09:09','',''),(2111151,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:09:09','',''),(2111152,'1','151','755',314,'Retail Sale Id 1255514',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 09:09:09','',''),(2111153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:09:09','',''),(2111154,'1','151','755',314,'Retail Sale Id 1255514',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:09:09','',''),(2111155,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:09:09','',''),(2111192,'1','151','755',314,'Retail Sale Id 1255534',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 09:11:53','',''),(2111193,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:11:53','',''),(2111194,'1','151','755',314,'Retail Sale Id 1255534',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 09:11:53','',''),(2111195,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:11:53','',''),(2111226,'1','151','755',314,'Retail Sale Id 1255553',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 09:13:45','',''),(2111227,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:13:45','',''),(2111282,'1','151','755',314,'Retail Sale Id 1255588',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 09:16:45','',''),(2111283,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:16:45','',''),(2111303,'1','151','755',314,'Retail Sale Id 1255599',6502.40,0.00,0.00,0.00,0.00,'2021-12-01 09:18:06','',''),(2111304,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 09:18:06','',''),(2111312,'1','151','755',314,'Retail Sale Id 1255605',6502.40,0.00,0.00,0.00,0.00,'2021-12-01 09:18:55','',''),(2111313,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 09:18:55','',''),(2111330,'1','151','755',314,'Retail Sale Id 1255615',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:20:04','',''),(2111331,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:20:04','',''),(2111395,'1','151','755',314,'Retail Sale Id 1255649',998.40,0.00,0.00,0.00,0.00,'2021-12-01 09:23:46','',''),(2111396,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:23:46','',''),(2111438,'1','151','755',314,'Retail Sale Id 1255663',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 09:26:15','',''),(2111439,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 09:26:15','',''),(2111462,'1','151','755',314,'Retail Sale Id 1255677',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 09:27:43','',''),(2111463,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:27:43','',''),(2111498,'1','151','755',314,'Retail Sale Id 1255697',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 09:29:31','',''),(2111499,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:29:31','',''),(2111551,'1','151','755',314,'Retail Sale Id 1255727',3801.60,0.00,0.00,0.00,0.00,'2021-12-01 09:34:32','',''),(2111552,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 09:34:32','',''),(2111565,'1','151','755',314,'Retail Sale Id 1255736',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:35:19','',''),(2111566,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:35:19','',''),(2111597,'1','151','755',314,'Retail Sale Id 1255752',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 09:36:58','',''),(2111598,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:36:58','',''),(2111609,'1','151','755',314,'Retail Sale Id 1255758',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:37:42','',''),(2111610,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:37:42','',''),(2111625,'1','151','755',314,'Retail Sale Id 1255767',998.40,0.00,0.00,0.00,0.00,'2021-12-01 09:38:24','',''),(2111626,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:38:24','',''),(2111676,'1','151','755',314,'Retail Sale Id 1255796',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 09:42:04','',''),(2111677,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:42:04','',''),(2111690,'1','151','755',314,'Retail Sale Id 1255803',1900.80,0.00,0.00,0.00,0.00,'2021-12-01 09:43:06','',''),(2111691,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 09:43:06','',''),(2111712,'1','151','755',314,'Retail Sale Id 1255812',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 09:44:46','',''),(2111713,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:44:46','',''),(2111714,'1','151','755',314,'Retail Sale Id 1255812',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:44:46','',''),(2111715,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:44:46','',''),(2111732,'1','151','755',314,'Retail Sale Id 1255826',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:45:51','',''),(2111733,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:45:51','',''),(2111746,'1','151','755',314,'Retail Sale Id 1255835',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 09:46:57','',''),(2111747,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:46:57','',''),(2111816,'1','151','755',314,'Retail Sale Id 1255868',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:52:25','',''),(2111817,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:52:25','',''),(2111818,'1','151','755',314,'Retail Sale Id 1255868',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:52:25','',''),(2111819,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:52:25','',''),(2111835,'1','151','755',314,'Retail Sale Id 1255876',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 09:54:09','',''),(2111836,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:54:09','',''),(2111837,'1','151','755',314,'Retail Sale Id 1255876',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 09:54:09','',''),(2111838,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:54:09','',''),(2111878,'1','151','755',314,'Retail Sale Id 1255898',10880.00,0.00,0.00,0.00,0.00,'2021-12-01 09:57:00','',''),(2111879,'1','151','755',314,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 09:57:00','',''),(2111932,'1','151','755',314,'Retail Sale Id 1255918',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:00:01','',''),(2111933,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:00:01','',''),(2111934,'1','151','755',314,'Retail Sale Id 1255918',32000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:00:01','',''),(2111935,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:00:01','',''),(2111967,'1','151','755',314,'Retail Sale Id 1255933',4499.20,0.00,0.00,0.00,0.00,'2021-12-01 10:01:15','',''),(2111968,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 10:01:15','',''),(2112031,'1','151','755',314,'Retail Sale Id 1255963',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 10:06:33','',''),(2112032,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 10:06:33','',''),(2112062,'1','151','755',314,'Retail Sale Id 1255981',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:09:15','',''),(2112063,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:09:15','',''),(2112092,'1','151','755',314,'Retail Sale Id 1255999',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 10:11:33','',''),(2112093,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:11:33','',''),(2112124,'1','151','755',314,'Retail Sale Id 1256016',3001.60,0.00,0.00,0.00,0.00,'2021-12-01 10:13:01','',''),(2112125,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 10:13:01','',''),(2112180,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112181,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112182,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112183,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112184,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112185,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112186,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112187,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112188,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112189,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112190,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112191,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112192,'1','151','755',314,'Retail Sale Id 1256046',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:16:12','',''),(2112193,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:16:12','',''),(2112369,'1','151','755',314,'Retail Sale Id 1256129',2502.40,0.00,0.00,0.00,0.00,'2021-12-01 10:30:35','',''),(2112370,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 10:30:35','',''),(2112495,'1','151','755',314,'Retail Sale Id 1256193',3801.60,0.00,0.00,0.00,0.00,'2021-12-01 10:39:37','',''),(2112496,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 10:39:37','',''),(2112513,'1','151','755',314,'Retail Sale Id 1256204',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:41:46','',''),(2112514,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:41:46','',''),(2112515,'1','151','755',314,'Retail Sale Id 1256204',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:41:46','',''),(2112516,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:41:46','',''),(2112517,'1','151','755',314,'Retail Sale Id 1256204',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:41:46','',''),(2112518,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:41:46','',''),(2112519,'1','151','755',314,'Retail Sale Id 1256204',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:41:46','',''),(2112520,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:41:46','',''),(2112560,'1','151','755',314,'Retail Sale Id 1256227',3001.60,0.00,0.00,0.00,0.00,'2021-12-01 10:45:59','',''),(2112561,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 10:45:59','',''),(2112580,'1','151','755',314,'Retail Sale Id 1256236',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:47:36','',''),(2112581,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:47:36','',''),(2112630,'1','151','755',314,'Retail Sale Id 1256263',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:52:05','',''),(2112631,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:52:05','',''),(2112828,'1','151','755',314,'Retail Sale Id 1256367',1497.60,0.00,0.00,0.00,0.00,'2021-12-01 11:08:12','',''),(2112829,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 11:08:12','',''),(2112890,'1','151','755',314,'Retail Sale Id 1256400',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 11:12:44','',''),(2112891,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:12:44','',''),(2113074,'1','151','755',314,'Retail Sale Id 1256476',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 11:22:29','',''),(2113075,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:22:29','',''),(2113104,'1','151','755',314,'Retail Sale Id 1256492',7001.60,0.00,0.00,0.00,0.00,'2021-12-01 11:24:38','',''),(2113105,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 11:24:38','',''),(2113186,'1','151','755',314,'Retail Sale Id 1256529',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 11:28:44','',''),(2113187,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 11:28:44','',''),(2113188,'1','151','755',314,'Retail Sale Id 1256529',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 11:28:44','',''),(2113189,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 11:28:44','',''),(2113296,'1','151','755',314,'Retail Sale Id 1256591',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:37:35','',''),(2113297,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:37:35','',''),(2113402,'1','151','755',314,'Retail Sale Id 1256647',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 11:45:22','',''),(2113403,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:45:22','',''),(2113421,'1','151','755',314,'Retail Sale Id 1256656',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 11:47:11','',''),(2113422,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:47:11','',''),(2113471,'1','151','755',314,'Retail Sale Id 1256680',6502.40,0.00,0.00,0.00,0.00,'2021-12-01 11:50:54','',''),(2113472,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 11:50:54','',''),(2113503,'1','151','755',314,'Retail Sale Id 1256696',7001.60,0.00,0.00,0.00,0.00,'2021-12-01 11:53:34','',''),(2113504,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 11:53:34','',''),(2113571,'1','151','755',314,'Retail Sale Id 1256735',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 11:59:25','',''),(2113572,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:59:25','',''),(2113597,'1','151','755',314,'Retail Sale Id 1256752',3897.60,0.00,0.00,0.00,0.00,'2021-12-01 12:02:36','',''),(2113598,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 12:02:36','',''),(2113651,'1','151','755',314,'Retail Sale Id 1256773',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 12:09:24','',''),(2113652,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:09:24','',''),(2113703,'1','151','755',314,'Retail Sale Id 1256800',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 12:12:43','',''),(2113704,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:12:43','',''),(2113741,'1','151','755',314,'Retail Sale Id 1256827',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 12:15:31','',''),(2113742,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:15:31','',''),(2113743,'1','151','755',314,'Retail Sale Id 1256827',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 12:15:31','',''),(2113744,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:15:31','',''),(2113771,'1','151','755',314,'Retail Sale Id 1256840',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 12:17:20','',''),(2113772,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:17:20','',''),(2113851,'1','151','755',314,'Retail Sale Id 1256882',4480.00,0.00,0.00,0.00,0.00,'2021-12-01 12:22:05','',''),(2113852,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 12:22:05','',''),(2113887,'1','151','755',314,'Retail Sale Id 1256899',2502.40,0.00,0.00,0.00,0.00,'2021-12-01 12:24:06','',''),(2113888,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 12:24:06','',''),(2113919,'1','151','755',314,'Retail Sale Id 1256914',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 12:27:10','',''),(2113920,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:27:10','',''),(2113921,'1','151','755',314,'Retail Sale Id 1256914',16000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:27:10','',''),(2113922,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 12:27:10','',''),(2113949,'1','151','755',314,'Retail Sale Id 1256929',601.60,0.00,0.00,0.00,0.00,'2021-12-01 12:29:06','',''),(2113950,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-01 12:29:06','',''),(2114055,'1','151','755',314,'Retail Sale Id 1256984',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 12:40:35','',''),(2114056,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:40:35','',''),(2114057,'1','151','755',314,'Retail Sale Id 1256984',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:40:35','',''),(2114058,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:40:35','',''),(2114182,'1','151','755',314,'Retail Sale Id 1257047',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 12:53:50','',''),(2114183,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 12:53:50','',''),(2114200,'1','151','755',314,'Retail Sale Id 1257058',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 12:55:45','',''),(2114201,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:55:45','',''),(2114202,'1','151','755',314,'Retail Sale Id 1257058',1932.80,0.00,0.00,0.00,0.00,'2021-12-01 12:55:45','',''),(2114203,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-01 12:55:45','',''),(2114222,'1','151','755',314,'Retail Sale Id 1257072',2560.00,0.00,0.00,0.00,0.00,'2021-12-01 12:59:05','',''),(2114223,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 12:59:05','',''),(2114298,'1','151','755',314,'Retail Sale Id 1257102',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:04:25','',''),(2114299,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:04:25','',''),(2114446,'1','151','755',314,'Retail Sale Id 1257212',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:14:05','',''),(2114447,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:14:05','',''),(2114488,'1','151','755',314,'Retail Sale Id 1257234',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:16:42','',''),(2114489,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:16:42','',''),(2114522,'1','151','755',314,'Retail Sale Id 1257252',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 13:19:20','',''),(2114523,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 13:19:20','',''),(2114540,'1','151','755',314,'Retail Sale Id 1257263',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:21:03','',''),(2114541,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:21:03','',''),(2114566,'1','151','755',314,'Retail Sale Id 1257280',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 13:22:48','',''),(2114567,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:22:48','',''),(2114588,'1','151','755',314,'Retail Sale Id 1257290',1702.40,0.00,0.00,0.00,0.00,'2021-12-01 13:24:12','',''),(2114589,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 13:24:12','',''),(2114596,'1','151','755',314,'Retail Sale Id 1257293',3699.20,0.00,0.00,0.00,0.00,'2021-12-01 13:24:58','',''),(2114597,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-01 13:24:58','',''),(2114629,'1','151','755',314,'Retail Sale Id 1257305',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 13:27:51','',''),(2114630,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:27:51','',''),(2114631,'1','151','755',314,'Retail Sale Id 1257305',3827.20,0.00,0.00,0.00,0.00,'2021-12-01 13:27:51','',''),(2114632,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.98,0.00,'2021-12-01 13:27:51','',''),(2114661,'1','151','755',314,'Retail Sale Id 1257320',3699.20,0.00,0.00,0.00,0.00,'2021-12-01 13:30:52','',''),(2114662,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-01 13:30:52','',''),(2114711,'1','151','755',314,'Retail Sale Id 1257345',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 13:35:09','',''),(2114712,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:35:09','',''),(2114756,'1','151','755',314,'Retail Sale Id 1257360',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:37:37','',''),(2114757,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:37:37','',''),(2114850,'1','151','755',314,'Retail Sale Id 1257383',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 13:41:29','',''),(2114851,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 13:41:29','',''),(2114892,'1','151','755',314,'Retail Sale Id 1257395',1497.60,0.00,0.00,0.00,0.00,'2021-12-01 13:43:41','',''),(2114893,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 13:43:41','',''),(2114898,'1','151','755',314,'Retail Sale Id 1257399',998.40,0.00,0.00,0.00,0.00,'2021-12-01 13:44:28','',''),(2114899,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:44:28','',''),(2114915,'1','151','755',314,'Retail Sale Id 1257404',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:45:15','',''),(2114916,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:45:15','',''),(2115057,'1','151','755',314,'Retail Sale Id 1257459',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 13:53:00','',''),(2115058,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:53:00','',''),(2115102,'1','151','755',314,'Retail Sale Id 1257480',3750.40,0.00,0.00,0.00,0.00,'2021-12-01 13:55:37','',''),(2115103,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.86,0.00,'2021-12-01 13:55:37','',''),(2115122,'1','151','755',314,'Retail Sale Id 1257493',7500.80,0.00,0.00,0.00,0.00,'2021-12-01 13:56:43','',''),(2115123,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-01 13:56:43','',''),(2115152,'1','151','755',314,'Retail Sale Id 1257509',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 13:58:24','',''),(2115153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:58:24','',''),(2115154,'1','151','755',314,'Retail Sale Id 1257509',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:58:24','',''),(2115155,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:58:24','',''),(2115176,'1','151','755',314,'Retail Sale Id 1257521',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:59:32','',''),(2115177,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:59:32','',''),(2115522,'1','151','755',314,'Retail Sale Id 1257697',147859.20,0.00,0.00,0.00,0.00,'2021-12-01 14:21:34','',''),(2115523,'1','151','755',314,'Retail sales',0.00,0.00,0.00,231.03,0.00,'2021-12-01 14:21:34','',''),(2115524,'1','151','755',314,'Retail Sale Id 1257697',219193.60,0.00,0.00,0.00,0.00,'2021-12-01 14:21:34','',''),(2115525,'1','151','755',314,'Retail sales',0.00,0.00,0.00,342.49,0.00,'2021-12-01 14:21:34','',''),(2115613,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,2612680.00,4340.00,0.00,0.00,'2021-12-01 14:27:46','',''),(2115628,'1','151',NULL,314,'Reception corrector for bridging 125855',0.00,0.00,0.00,4340.00,0.00,'2021-12-01 14:28:52','',''),(2115629,'1','151','755',314,'Received from bridging 125855',0.00,0.00,4340.00,0.00,0.00,'2021-12-01 14:28:52','',''),(2117403,'1','151','755',314,'Retail Sale Id 1258573',4697.60,0.00,0.00,0.00,278.92,'2021-12-01 16:10:24','',''),(2117404,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.34,0.00,'2021-12-01 16:10:24','',''),(2117426,'1','151','755',314,'Retail Sale Id 1258582',5497.60,0.00,0.00,0.00,326.42,'2021-12-01 16:11:26','',''),(2117427,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-01 16:11:26','',''),(2117448,'1','151','755',314,'Retail Sale Id 1258596',3840.00,0.00,0.00,0.00,228.00,'2021-12-01 16:12:39','',''),(2117449,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:12:39','',''),(2117490,'1','151','755',314,'Retail Sale Id 1258609',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:13:57','',''),(2117491,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:13:57','',''),(2117519,'1','151','755',314,'Retail Sale Id 1258619',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:15:07','',''),(2117520,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:15:07','',''),(2117567,'1','151','755',314,'Retail Sale Id 1258643',8499.20,0.00,0.00,0.00,504.64,'2021-12-01 16:16:52','',''),(2117568,'1','151','755',314,'Retail sales',0.00,0.00,0.00,13.28,0.00,'2021-12-01 16:16:52','',''),(2117599,'1','151','755',314,'Retail Sale Id 1258658',3897.60,0.00,0.00,0.00,231.42,'2021-12-01 16:18:33','',''),(2117600,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 16:18:33','',''),(2117652,'1','151','755',314,'Retail Sale Id 1258687',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:20:25','',''),(2117653,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:20:25','',''),(2117654,'1','151','755',314,'Retail Sale Id 1258687',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 16:20:25','',''),(2117655,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:20:25','',''),(2117694,'1','151','755',314,'Retail Sale Id 1258711',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:22:11','',''),(2117695,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:22:11','',''),(2117732,'1','151','755',314,'Retail Sale Id 1258733',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 16:23:42','',''),(2117733,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 16:23:42','',''),(2117794,'1','151','755',314,'Retail Sale Id 1258775',5120.00,0.00,0.00,0.00,304.00,'2021-12-01 16:27:06','',''),(2117795,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 16:27:06','',''),(2117872,'1','151','755',314,'Retail Sale Id 1258817',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:30:27','',''),(2117873,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:30:27','',''),(2117972,'1','151','755',314,'Retail Sale Id 1258872',20000.00,0.00,0.00,0.00,1187.50,'2021-12-01 16:35:37','',''),(2117973,'1','151','755',314,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-01 16:35:37','',''),(2118022,'1','151','755',314,'Retail Sale Id 1258899',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 16:38:03','',''),(2118023,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 16:38:03','',''),(2118048,'1','151','755',314,'Retail Sale Id 1258911',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:39:15','',''),(2118049,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:39:15','',''),(2118088,'1','151','755',314,'Retail Sale Id 1258935',7040.00,0.00,0.00,0.00,418.00,'2021-12-01 16:41:08','',''),(2118089,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 16:41:08','',''),(2118108,'1','151','755',314,'Retail Sale Id 1258946',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:42:10','',''),(2118109,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:42:10','',''),(2118188,'1','151','755',314,'Retail Sale Id 1258987',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 16:46:19','',''),(2118189,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 16:46:19','',''),(2118401,'1','151','755',314,'Retail Sale Id 1259092',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 16:55:45','',''),(2118402,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:55:45','',''),(2118476,'1','151','755',314,'Retail Sale Id 1259131',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 16:59:02','',''),(2118477,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 16:59:02','',''),(2118518,'1','151','755',314,'Retail Sale Id 1259152',1280.00,0.00,0.00,0.00,76.00,'2021-12-01 17:00:42','',''),(2118519,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:00:42','',''),(2118654,'1','151','755',314,'Retail Sale Id 1259216',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 17:07:16','',''),(2118655,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:07:16','',''),(2118696,'1','151','755',314,'Retail Sale Id 1259239',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 17:09:28','',''),(2118697,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:09:28','',''),(2118798,'1','151','755',314,'Retail Sale Id 1259294',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 17:15:20','',''),(2118799,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:15:20','',''),(2118824,'1','151','755',314,'Retail Sale Id 1259305',998.40,0.00,0.00,0.00,59.28,'2021-12-01 17:16:46','',''),(2118825,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:16:46','',''),(2118995,'1','151','755',314,'Retail Sale Id 1259393',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 17:28:46','',''),(2118996,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:28:46','',''),(2119392,'1','151','755',314,'Retail Sale Id 1259585',23264.00,0.00,0.00,0.00,1381.30,'2021-12-01 18:07:33','',''),(2119393,'1','151','755',314,'Retail sales',0.00,0.00,0.00,36.35,0.00,'2021-12-01 18:07:33','',''),(2119394,'1','151','755',314,'Retail Sale Id 1259585',135564.80,0.00,0.00,0.00,8049.16,'2021-12-01 18:07:33','',''),(2119395,'1','151','755',314,'Retail sales',0.00,0.00,0.00,211.82,0.00,'2021-12-01 18:07:33','',''),(2120256,'1','151','755',314,'Retail Sale Id 1259779',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 05:39:07','',''),(2120257,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 05:39:07','',''),(2120484,'1','151','755',314,'Retail Sale Id 1259895',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 06:12:16','',''),(2120485,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 06:12:16','',''),(2120508,'1','151','755',314,'Retail Sale Id 1259908',998.40,0.00,0.00,0.00,59.28,'2021-12-02 06:14:49','',''),(2120509,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:14:49','',''),(2120510,'1','151','755',314,'Retail Sale Id 1259908',998.40,0.00,0.00,0.00,59.28,'2021-12-02 06:14:49','',''),(2120511,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:14:49','',''),(2120536,'1','151','755',314,'Retail Sale Id 1259922',4499.20,0.00,0.00,0.00,267.14,'2021-12-02 06:17:12','',''),(2120537,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-02 06:17:12','',''),(2120567,'1','151','755',314,'Retail Sale Id 1259933',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:18:45','',''),(2120568,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:18:45','',''),(2120606,'1','151','755',314,'Retail Sale Id 1259950',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 06:21:31','',''),(2120607,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 06:21:31','',''),(2120618,'1','151','755',314,'Retail Sale Id 1259958',697.60,0.00,0.00,0.00,41.42,'2021-12-02 06:22:52','',''),(2120619,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 06:22:52','',''),(2120640,'1','151','755',314,'Retail Sale Id 1259967',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:24:18','',''),(2120641,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:24:18','',''),(2120654,'1','151','755',314,'Retail Sale Id 1259974',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 06:25:43','',''),(2120655,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 06:25:43','',''),(2120692,'1','151','755',314,'Retail Sale Id 1259994',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:28:32','',''),(2120693,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:28:32','',''),(2120841,'1','151','755',314,'Retail Sale Id 1260063',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:38:11','',''),(2120842,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:38:11','',''),(2121036,'1','151','755',314,'Retail Sale Id 1260123',12000.00,0.00,0.00,0.00,712.50,'2021-12-02 06:47:05','',''),(2121037,'1','151','755',314,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 06:47:05','',''),(2121250,'1','151','755',314,'Retail Sale Id 1260219',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:59:22','',''),(2121251,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:59:22','',''),(2121288,'1','151','755',314,'Retail Sale Id 1260239',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 07:01:31','',''),(2121289,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:01:31','',''),(2121388,'1','151','755',314,'Retail Sale Id 1260290',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:07:08','',''),(2121389,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:07:08','',''),(2121390,'1','151','755',314,'Retail Sale Id 1260290',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:07:08','',''),(2121391,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:07:08','',''),(2121416,'1','151','755',314,'Retail Sale Id 1260304',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:08:40','',''),(2121417,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:08:40','',''),(2121524,'1','151','755',314,'Retail Sale Id 1260340',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 07:12:57','',''),(2121525,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:12:57','',''),(2121550,'1','151','755',314,'Retail Sale Id 1260354',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 07:14:23','',''),(2121551,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 07:14:23','',''),(2121633,'1','151','755',314,'Retail Sale Id 1260399',3801.60,0.00,0.00,0.00,225.72,'2021-12-02 07:18:37','',''),(2121634,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-02 07:18:37','',''),(2121767,'1','151','755',314,'Retail Sale Id 1260460',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 07:25:12','',''),(2121768,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 07:25:12','',''),(2121797,'1','151','755',314,'Retail Sale Id 1260474',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 07:26:32','',''),(2121798,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:26:32','',''),(2121829,'1','151','755',314,'Retail Sale Id 1260492',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:28:21','',''),(2121830,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:28:21','',''),(2121913,'1','151','755',314,'Retail Sale Id 1260549',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:33:35','',''),(2121914,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:33:35','',''),(2121915,'1','151','755',314,'Retail Sale Id 1260549',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:33:35','',''),(2121916,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:33:35','',''),(2121995,'1','151','755',314,'Retail Sale Id 1260597',25600.00,0.00,0.00,0.00,1520.00,'2021-12-02 07:37:53','',''),(2121996,'1','151','755',314,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 07:37:53','',''),(2122072,'1','151','755',314,'Retail Sale Id 1260632',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 07:40:52','',''),(2122073,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 07:40:52','',''),(2122151,'1','151','755',314,'Retail Sale Id 1260673',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:44:27','',''),(2122152,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:44:27','',''),(2122211,'1','151','755',314,'Retail Sale Id 1260706',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:47:46','',''),(2122212,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:47:46','',''),(2122305,'1','151','755',314,'Retail Sale Id 1260740',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:50:36','',''),(2122306,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:50:36','',''),(2122345,'1','151','755',314,'Retail Sale Id 1260757',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 07:51:56','',''),(2122346,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:51:56','',''),(2122375,'1','151','755',314,'Retail Sale Id 1260777',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 07:53:30','',''),(2122376,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 07:53:30','',''),(2122402,'1','151','755',314,'Retail Sale Id 1260788',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:54:47','',''),(2122403,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:54:47','',''),(2122438,'1','151','755',314,'Retail Sale Id 1260804',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:56:00','',''),(2122439,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:56:00','',''),(2122464,'1','151','755',314,'Retail Sale Id 1260816',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:57:00','',''),(2122465,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:57:00','',''),(2122486,'1','151','755',314,'Retail Sale Id 1260831',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:58:03','',''),(2122487,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:58:03','',''),(2122532,'1','151','755',314,'Retail Sale Id 1260848',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 07:59:21','',''),(2122533,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:59:21','',''),(2122613,'1','151','755',314,'Retail Sale Id 1260879',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:02:42','',''),(2122614,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:02:42','',''),(2122637,'1','151','755',314,'Retail Sale Id 1260889',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 08:03:52','',''),(2122638,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 08:03:52','',''),(2122663,'1','151','755',314,'Retail Sale Id 1260904',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:04:53','',''),(2122664,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:04:53','',''),(2122695,'1','151','755',314,'Retail Sale Id 1260915',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:05:53','',''),(2122696,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:05:53','',''),(2122759,'1','151','755',314,'Retail Sale Id 1260952',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:09:50','',''),(2122762,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:09:50','',''),(2122787,'1','151','755',314,'Retail Sale Id 1260968',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:11:34','',''),(2122788,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:11:34','',''),(2122809,'1','151','755',314,'Retail Sale Id 1260979',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 08:12:58','',''),(2122810,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:12:58','',''),(2122838,'1','151','755',314,'Retail Sale Id 1260994',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:14:13','',''),(2122839,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:14:13','',''),(2122906,'1','151','755',314,'Retail Sale Id 1261029',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:18:07','',''),(2122907,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:18:07','',''),(2123000,'1','151','755',314,'Retail Sale Id 1261081',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:22:50','',''),(2123001,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:22:50','',''),(2123039,'1','151','755',314,'Retail Sale Id 1261101',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 08:24:26','',''),(2123040,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 08:24:26','',''),(2123087,'1','151','755',314,'Retail Sale Id 1261120',697.60,0.00,0.00,0.00,41.42,'2021-12-02 08:26:47','',''),(2123088,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 08:26:47','',''),(2123163,'1','151','755',314,'Retail Sale Id 1261160',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 08:30:56','',''),(2123164,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 08:30:56','',''),(2123358,'1','151','755',314,'Retail Sale Id 1261238',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 08:40:18','',''),(2123359,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:40:18','',''),(2123459,'1','151','755',314,'Retail Sale Id 1261291',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:45:24','',''),(2123460,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:45:24','',''),(2123499,'1','151','755',314,'Retail Sale Id 1261308',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:47:27','',''),(2123500,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:47:27','',''),(2123523,'1','151','755',314,'Retail Sale Id 1261320',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 08:49:27','',''),(2123524,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:49:27','',''),(2123551,'1','151','755',314,'Retail Sale Id 1261333',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:51:47','',''),(2123552,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:51:47','',''),(2123613,'1','151','755',314,'Retail Sale Id 1261366',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:54:47','',''),(2123614,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:54:47','',''),(2123633,'1','151','755',314,'Retail Sale Id 1261376',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:55:52','',''),(2123634,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:55:52','',''),(2123663,'1','151','755',314,'Retail Sale Id 1261390',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:57:17','',''),(2123664,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:57:17','',''),(2123733,'1','151','755',314,'Retail Sale Id 1261425',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:00:52','',''),(2123734,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:00:52','',''),(2123811,'1','151','755',314,'Retail Sale Id 1261474',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:04:50','',''),(2123812,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:04:50','',''),(2123839,'1','151','755',314,'Retail Sale Id 1261490',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:06:21','',''),(2123840,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:06:22','',''),(2123929,'1','151','755',314,'Retail Sale Id 1261536',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 09:10:42','',''),(2123930,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:10:42','',''),(2123985,'1','151','755',314,'Retail Sale Id 1261561',3801.60,0.00,0.00,0.00,225.72,'2021-12-02 09:12:50','',''),(2123986,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-02 09:12:50','',''),(2124037,'1','151','755',314,'Retail Sale Id 1261584',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:15:17','',''),(2124038,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:15:17','',''),(2124102,'1','151','755',314,'Retail Sale Id 1261597',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 09:17:07','',''),(2124103,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 09:17:07','',''),(2124142,'1','151','755',314,'Retail Sale Id 1261620',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:19:11','',''),(2124143,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:19:11','',''),(2124232,'1','151','755',314,'Retail Sale Id 1261664',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:24:18','',''),(2124233,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:24:18','',''),(2124250,'1','151','755',314,'Retail Sale Id 1261678',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:25:39','',''),(2124251,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:25:39','',''),(2124274,'1','151','755',314,'Retail Sale Id 1261689',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:26:52','',''),(2124275,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:26:52','',''),(2124324,'1','151','755',314,'Retail Sale Id 1261709',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:29:55','',''),(2124325,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:29:55','',''),(2124350,'1','151','755',314,'Retail Sale Id 1261724',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:31:34','',''),(2124351,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:31:34','',''),(2124374,'1','151','755',314,'Retail Sale Id 1261735',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:33:00','',''),(2124375,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:33:00','',''),(2124387,'1','151','755',314,'Retail Sale Id 1261742',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:34:02','',''),(2124388,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:34:02','',''),(2124409,'1','151','755',314,'Retail Sale Id 1261754',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:35:32','',''),(2124410,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:35:32','',''),(2124427,'1','151','755',314,'Retail Sale Id 1261765',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:37:36','',''),(2124428,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:37:36','',''),(2124455,'1','151','755',314,'Retail Sale Id 1261779',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:39:54','',''),(2124456,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:39:54','',''),(2124483,'1','151','755',314,'Retail Sale Id 1261793',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:41:41','',''),(2124484,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:41:41','',''),(2124523,'1','151','755',314,'Retail Sale Id 1261812',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:43:33','',''),(2124524,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:43:33','',''),(2124525,'1','151','755',314,'Retail Sale Id 1261812',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:43:33','',''),(2124526,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:43:33','',''),(2124555,'1','151','755',314,'Retail Sale Id 1261828',7500.80,0.00,0.00,0.00,445.36,'2021-12-02 09:44:51','',''),(2124556,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-02 09:44:51','',''),(2124596,'1','151','755',314,'Retail Sale Id 1261846',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:47:10','',''),(2124597,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:47:10','',''),(2124598,'1','151','755',314,'Retail Sale Id 1261846',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:47:10','',''),(2124599,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:47:10','',''),(2124643,'1','151','755',314,'Retail Sale Id 1261860',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 09:49:42','',''),(2124644,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:49:42','',''),(2124645,'1','151','755',314,'Retail Sale Id 1261860',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:49:42','',''),(2124646,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:49:42','',''),(2124683,'1','151','755',314,'Retail Sale Id 1261899',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:51:20','',''),(2124684,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:51:20','',''),(2124713,'1','151','755',314,'Retail Sale Id 1261913',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:52:40','',''),(2124714,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:52:40','',''),(2124737,'1','151','755',314,'Retail Sale Id 1261926',998.40,0.00,0.00,0.00,59.28,'2021-12-02 09:53:52','',''),(2124738,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:53:52','',''),(2124785,'1','151','755',314,'Retail Sale Id 1261952',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:56:24','',''),(2124786,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:56:24','',''),(2124833,'1','151','755',314,'Retail Sale Id 1261977',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 09:58:30','',''),(2124834,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:58:30','',''),(2124855,'1','151','755',314,'Retail Sale Id 1261989',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:59:39','',''),(2124856,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:59:39','',''),(2124877,'1','151','755',314,'Retail Sale Id 1262003',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:01:25','',''),(2124878,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:01:25','',''),(2124908,'1','151','755',314,'Retail Sale Id 1262013',10003.20,0.00,0.00,0.00,593.94,'2021-12-02 10:02:38','',''),(2124909,'1','151','755',314,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-02 10:02:38','',''),(2124941,'1','151','755',314,'Retail Sale Id 1262028',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:04:10','',''),(2124942,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:04:10','',''),(2124961,'1','151','755',314,'Retail Sale Id 1262039',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:05:29','',''),(2124962,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:05:29','',''),(2124989,'1','151','755',314,'Retail Sale Id 1262055',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 10:07:59','',''),(2124990,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:07:59','',''),(2125007,'1','151','755',314,'Retail Sale Id 1262070',8998.40,0.00,0.00,0.00,534.28,'2021-12-02 10:09:21','',''),(2125008,'1','151','755',314,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-02 10:09:21','',''),(2125045,'1','151','755',314,'Retail Sale Id 1262086',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:11:27','',''),(2125046,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:11:27','',''),(2125073,'1','151','755',314,'Retail Sale Id 1262100',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:12:55','',''),(2125074,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:12:55','',''),(2125075,'1','151','755',314,'Retail Sale Id 1262100',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:12:55','',''),(2125076,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:12:55','',''),(2125100,'1','151','755',314,'Retail Sale Id 1262112',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 10:14:11','',''),(2125101,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 10:14:11','',''),(2125136,'1','151','755',314,'Retail Sale Id 1262133',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:16:22','',''),(2125137,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:16:22','',''),(2125166,'1','151','755',314,'Retail Sale Id 1262149',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 10:18:22','',''),(2125167,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:18:22','',''),(2125198,'1','151','755',314,'Retail Sale Id 1262163',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 10:19:49','',''),(2125199,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 10:19:49','',''),(2125230,'1','151','755',314,'Retail Sale Id 1262183',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 10:21:48','',''),(2125231,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 10:21:48','',''),(2125282,'1','151','755',314,'Retail Sale Id 1262200',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:23:26','',''),(2125283,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:23:26','',''),(2125303,'1','151','755',314,'Retail Sale Id 1262210',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 10:25:10','',''),(2125304,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:25:10','',''),(2125305,'1','151','755',314,'Retail Sale Id 1262210',1280.00,0.00,0.00,0.00,76.00,'2021-12-02 10:25:10','',''),(2125306,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:25:10','',''),(2125327,'1','151','755',314,'Retail Sale Id 1262222',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 10:26:12','',''),(2125328,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:26:12','',''),(2125346,'1','151','755',314,'Retail Sale Id 1262235',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 10:27:14','',''),(2125347,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 10:27:14','',''),(2125376,'1','151','755',314,'Retail Sale Id 1262247',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 10:29:28','',''),(2125377,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:29:28','',''),(2125388,'1','151','755',314,'Retail Sale Id 1262255',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:30:25','',''),(2125389,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:30:25','',''),(2125414,'1','151','755',314,'Retail Sale Id 1262269',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 10:32:07','',''),(2125415,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:32:07','',''),(2125444,'1','151','755',314,'Retail Sale Id 1262283',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:34:13','',''),(2125445,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:34:13','',''),(2125496,'1','151','755',314,'Retail Sale Id 1262310',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:37:07','',''),(2125497,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:37:07','',''),(2125624,'1','151','755',314,'Retail Sale Id 1262370',7040.00,0.00,0.00,0.00,418.00,'2021-12-02 10:44:51','',''),(2125625,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 10:44:51','',''),(2125690,'1','151','755',314,'Retail Sale Id 1262405',5497.60,0.00,0.00,0.00,326.42,'2021-12-02 10:49:16','',''),(2125691,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-02 10:49:16','',''),(2125736,'1','151','755',314,'Retail Sale Id 1262420',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:51:43','',''),(2125737,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:51:43','',''),(2125756,'1','151','755',314,'Retail Sale Id 1262430',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:52:43','',''),(2125757,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:52:43','',''),(2125798,'1','151','755',314,'Retail Sale Id 1262449',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:56:18','',''),(2125799,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:56:18','',''),(2125826,'1','151','755',314,'Retail Sale Id 1262467',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:58:35','',''),(2125827,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:58:35','',''),(2125850,'1','151','755',314,'Retail Sale Id 1262482',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:00:17','',''),(2125851,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:00:17','',''),(2125954,'1','151','755',314,'Retail Sale Id 1262541',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:06:22','',''),(2125955,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:06:22','',''),(2126104,'1','151','755',314,'Retail Sale Id 1262622',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 11:15:33','',''),(2126105,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 11:15:33','',''),(2126136,'1','151','755',314,'Retail Sale Id 1262640',12000.00,0.00,0.00,0.00,712.50,'2021-12-02 11:17:11','',''),(2126137,'1','151','755',314,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 11:17:11','',''),(2126232,'1','151','755',314,'Retail Sale Id 1262657',16000.00,0.00,0.00,0.00,950.00,'2021-12-02 11:22:19','',''),(2126233,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 11:22:19','',''),(2126270,'1','151','755',314,'Retail Sale Id 1262711',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:25:27','',''),(2126271,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:25:27','',''),(2126316,'1','151','755',314,'Retail Sale Id 1262734',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 11:27:49','',''),(2126317,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:27:49','',''),(2126482,'1','151','755',314,'Retail Sale Id 1262802',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:35:18','',''),(2126483,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:35:18','',''),(2126509,'1','151','755',314,'Retail Sale Id 1262812',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 11:36:22','',''),(2126510,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 11:36:22','',''),(2126563,'1','151','755',314,'Retail Sale Id 1262830',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:38:44','',''),(2126564,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:38:44','',''),(2126591,'1','151','755',314,'Retail Sale Id 1262843',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:39:57','',''),(2126592,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:39:57','',''),(2126677,'1','151','755',314,'Retail Sale Id 1262884',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 11:47:18','',''),(2126678,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 11:47:18','',''),(2126793,'1','151','755',314,'Retail Sale Id 1262947',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 11:55:48','',''),(2126794,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:55:48','',''),(2126832,'1','151','755',314,'Retail Sale Id 1262969',4480.00,0.00,0.00,0.00,266.00,'2021-12-02 11:59:03','',''),(2126833,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 11:59:03','',''),(2126883,'1','151','755',314,'Retail Sale Id 1262992',697.60,0.00,0.00,0.00,41.42,'2021-12-02 12:04:07','',''),(2126884,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 12:04:07','',''),(2126901,'1','151','755',314,'Retail Sale Id 1263004',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 12:05:16','',''),(2126902,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:05:16','',''),(2127562,'1','151','755',314,'Retail Sale Id 1263342',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 12:58:12','',''),(2127563,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 12:58:12','',''),(2127862,'1','151','755',314,'Retail Sale Id 1263481',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 13:16:54','',''),(2127863,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 13:16:54','',''),(2127911,'1','151','755',314,'Retail Sale Id 1263504',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:20:49','',''),(2127912,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:20:49','',''),(2127913,'1','151','755',314,'Retail Sale Id 1263504',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:20:49','',''),(2127914,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:20:49','',''),(2127953,'1','151','755',314,'Retail Sale Id 1263524',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:24:08','',''),(2127954,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:24:08','',''),(2128099,'1','151','755',314,'Retail Sale Id 1263581',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:34:53','',''),(2128100,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:34:53','',''),(2128101,'1','151','755',314,'Retail Sale Id 1263581',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:34:53','',''),(2128102,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:34:53','',''),(2128103,'1','151','755',314,'Retail Sale Id 1263581',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 13:34:53','',''),(2128104,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 13:34:53','',''),(2128119,'1','151','755',314,'Retail Sale Id 1263590',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 13:36:04','',''),(2128120,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:36:04','',''),(2128138,'1','151','755',314,'Retail Sale Id 1263596',7500.80,0.00,0.00,0.00,445.36,'2021-12-02 13:37:29','',''),(2128139,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-02 13:37:29','',''),(2128150,'1','151','755',314,'Retail Sale Id 1263600',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:38:23','',''),(2128151,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:38:23','',''),(2128268,'1','151','755',314,'Retail Sale Id 1263648',2201.60,0.00,0.00,0.00,130.72,'2021-12-02 13:45:23','',''),(2128269,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-02 13:45:23','',''),(2128475,'1','151','755',314,'Retail Sale Id 1263742',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 13:55:49','',''),(2128476,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:55:49','',''),(2128517,'1','151','755',314,'Retail Sale Id 1263761',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:57:53','',''),(2128518,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:57:53','',''),(2128558,'1','151','755',314,'Retail Sale Id 1263779',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 14:00:56','',''),(2128559,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:00:56','',''),(2128602,'1','151','755',314,'Retail Sale Id 1263798',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:03:52','',''),(2128603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:03:52','',''),(2128648,'1','151','755',314,'Retail Sale Id 1263823',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:06:51','',''),(2128649,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:06:51','',''),(2128674,'1','151','755',314,'Retail Sale Id 1263837',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:08:28','',''),(2128675,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:08:28','',''),(2128698,'1','151','755',314,'Retail Sale Id 1263849',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 14:10:09','',''),(2128699,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 14:10:09','',''),(2128730,'1','151','755',314,'Retail Sale Id 1263859',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 14:11:32','',''),(2128731,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:11:32','',''),(2128758,'1','151','755',314,'Retail Sale Id 1263867',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:12:51','',''),(2128759,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:12:51','',''),(2128784,'1','151','755',314,'Retail Sale Id 1263879',4480.00,0.00,0.00,0.00,266.00,'2021-12-02 14:14:53','',''),(2128785,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 14:14:53','',''),(2128810,'1','151','755',314,'Retail Sale Id 1263892',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 14:16:26','',''),(2128811,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:16:26','',''),(2128864,'1','151','755',314,'Retail Sale Id 1263919',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 14:18:58','',''),(2128865,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 14:18:58','',''),(2128895,'1','151','755',314,'Retail Sale Id 1263931',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 14:20:27','',''),(2128896,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:20:27','',''),(2128914,'1','151','755',314,'Retail Sale Id 1263948',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:21:44','',''),(2128915,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:21:44','',''),(2128952,'1','151','755',314,'Retail Sale Id 1263960',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:23:14','',''),(2128953,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:23:14','',''),(2128991,'1','151','755',314,'Retail Sale Id 1263969',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 14:24:28','',''),(2128992,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:24:28','',''),(2129059,'1','151','755',314,'Retail Sale Id 1263992',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:26:51','',''),(2129060,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:26:51','',''),(2129108,'1','151','755',314,'Retail Sale Id 1264006',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 14:28:20','',''),(2129109,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 14:28:20','',''),(2129152,'1','151','755',314,'Retail Sale Id 1264023',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 14:30:28','',''),(2129153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:30:28','',''),(2129194,'1','151','755',314,'Retail Sale Id 1264039',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 14:31:39','',''),(2129195,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 14:31:39','',''),(2129218,'1','151','755',314,'Retail Sale Id 1264051',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 14:33:45','',''),(2129219,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:33:45','',''),(2129220,'1','151','755',314,'Retail Sale Id 1264051',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:33:45','',''),(2129221,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:33:45','',''),(2129222,'1','151','755',314,'Retail Sale Id 1264051',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:33:45','',''),(2129223,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:33:45','',''),(2129248,'1','151','755',314,'Retail Sale Id 1264063',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:35:02','',''),(2129249,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:35:02','',''),(2129272,'1','151','755',314,'Retail Sale Id 1264077',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:36:48','',''),(2129273,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:36:48','',''),(2129274,'1','151','755',314,'Retail Sale Id 1264077',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:36:48','',''),(2129275,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:36:48','',''),(2129276,'1','151','755',314,'Retail Sale Id 1264077',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:36:48','',''),(2129277,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:36:48','',''),(2129298,'1','151','755',314,'Retail Sale Id 1264086',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:38:08','',''),(2129299,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:38:08','',''),(2129347,'1','151','755',314,'Retail Sale Id 1264102',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:39:23','',''),(2129348,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:39:23','',''),(2129398,'1','151','755',314,'Retail Sale Id 1264120',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 14:41:23','',''),(2129399,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 14:41:23','',''),(2129527,'1','151','755',314,'Retail Sale Id 1264186',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:48:47','',''),(2129528,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:48:47','',''),(2129667,'1','151','755',314,'Retail Sale Id 1264259',697.60,0.00,0.00,0.00,41.42,'2021-12-02 14:56:56','',''),(2129668,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 14:56:56','',''),(2129697,'1','151','755',314,'Retail Sale Id 1264277',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 14:58:11','',''),(2129698,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:58:11','',''),(2129753,'1','151','755',314,'Retail Sale Id 1264303',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:03:25','',''),(2129754,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:03:25','',''),(2129781,'1','151','755',314,'Retail Sale Id 1264316',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 15:05:30','',''),(2129782,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:05:30','',''),(2129936,'1','151','755',314,'Retail Sale Id 1264393',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 15:14:43','',''),(2129937,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:14:43','',''),(2129992,'1','151','755',314,'Retail Sale Id 1264424',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:17:30','',''),(2129993,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:17:30','',''),(2130140,'1','151','755',314,'Retail Sale Id 1264497',1900.80,0.00,0.00,0.00,112.86,'2021-12-02 15:25:25','',''),(2130141,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 15:25:25','',''),(2130172,'1','151','755',314,'Retail Sale Id 1264512',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:26:40','',''),(2130173,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:26:40','',''),(2130200,'1','151','755',314,'Retail Sale Id 1264530',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 15:28:03','',''),(2130201,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 15:28:03','',''),(2130239,'1','151','755',314,'Retail Sale Id 1264545',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 15:29:19','',''),(2130240,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:29:19','',''),(2130295,'1','151','755',314,'Retail Sale Id 1264571',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 15:31:46','',''),(2130296,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:31:46','',''),(2130346,'1','151','755',314,'Retail Sale Id 1264597',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:34:20','',''),(2130347,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:34:20','',''),(2130348,'1','151','755',314,'Retail Sale Id 1264597',3840.00,0.00,0.00,0.00,228.00,'2021-12-02 15:34:20','',''),(2130349,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:34:20','',''),(2130350,'1','151','755',314,'Retail Sale Id 1264597',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:34:20','',''),(2130351,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:34:20','',''),(2130382,'1','151','755',314,'Retail Sale Id 1264609',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 15:35:47','',''),(2130383,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 15:35:47','',''),(2130572,'1','151','755',314,'Retail Sale Id 1264715',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:44:37','',''),(2130573,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:44:37','',''),(2130602,'1','151','755',314,'Retail Sale Id 1264732',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 15:45:49','',''),(2130603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:45:49','',''),(2130680,'1','151','755',314,'Retail Sale Id 1264773',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 15:49:51','',''),(2130681,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 15:49:51','',''),(2130746,'1','151','755',314,'Retail Sale Id 1264806',1920.00,0.00,0.00,0.00,114.00,'2021-12-02 15:52:25','',''),(2130747,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:52:25','',''),(2130772,'1','151','755',314,'Retail Sale Id 1264824',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:53:41','',''),(2130773,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:53:41','',''),(2130840,'1','151','755',314,'Retail Sale Id 1264858',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:55:57','',''),(2130841,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:55:57','',''),(2130870,'1','151','755',314,'Retail Sale Id 1264872',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:57:24','',''),(2130871,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:57:24','',''),(2130906,'1','151','755',314,'Retail Sale Id 1264891',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 15:59:26','',''),(2130907,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:59:26','',''),(2130934,'1','151','755',314,'Retail Sale Id 1264907',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:00:46','',''),(2130935,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:00:46','',''),(2130974,'1','151','755',314,'Retail Sale Id 1264922',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 16:01:57','',''),(2130975,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 16:01:57','',''),(2131016,'1','151','755',314,'Retail Sale Id 1264942',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:03:57','',''),(2131017,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:03:57','',''),(2131044,'1','151','755',314,'Retail Sale Id 1264951',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 16:04:59','',''),(2131045,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:04:59','',''),(2131072,'1','151','755',314,'Retail Sale Id 1264962',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:06:09','',''),(2131073,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:06:09','',''),(2131214,'1','151','755',314,'Retail Sale Id 1265036',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 16:12:51','',''),(2131215,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:12:51','',''),(2131242,'1','151','755',314,'Retail Sale Id 1265048',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 16:14:08','',''),(2131243,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:14:08','',''),(2131303,'1','151','755',314,'Retail Sale Id 1265077',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 16:17:09','',''),(2131304,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 16:17:09','',''),(2131388,'1','151','755',314,'Retail Sale Id 1265126',697.60,0.00,0.00,0.00,41.42,'2021-12-02 16:21:45','',''),(2131389,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 16:21:45','',''),(2131444,'1','151','755',314,'Retail Sale Id 1265151',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:24:26','',''),(2131445,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:24:27','',''),(2131446,'1','151','755',314,'Retail Sale Id 1265151',16000.00,0.00,0.00,0.00,950.00,'2021-12-02 16:24:27','',''),(2131447,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 16:24:27','',''),(2131494,'1','151','755',314,'Retail Sale Id 1265176',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:26:52','',''),(2131495,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:26:52','',''),(2131716,'1','151','755',314,'Retail Sale Id 1265279',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:34:44','',''),(2131717,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:34:44','',''),(2131718,'1','151','755',314,'Retail Sale Id 1265279',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:34:44','',''),(2131719,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:34:44','',''),(2131720,'1','151','755',314,'Retail Sale Id 1265279',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:34:44','',''),(2131721,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:34:44','',''),(2131829,'1','151','755',314,'Retail Sale Id 1265335',2560.00,0.00,0.00,0.00,152.00,'2021-12-02 16:41:39','',''),(2131830,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:41:39','',''),(2131885,'1','151','755',314,'Retail Sale Id 1265354',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 16:43:59','',''),(2131886,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 16:43:59','',''),(2131924,'1','151','755',314,'Retail Sale Id 1265377',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 16:45:17','',''),(2131925,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 16:45:17','',''),(2131954,'1','151','755',314,'Retail Sale Id 1265397',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 16:46:55','',''),(2131955,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 16:46:55','',''),(2132207,'1','151','755',314,'Retail Sale Id 1265523',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:02:10','',''),(2132208,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:02:10','',''),(2132209,'1','151','755',314,'Retail Sale Id 1265523',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:02:10','',''),(2132210,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:02:10','',''),(2132354,'1','151','755',314,'Retail Sale Id 1265592',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:11:57','',''),(2132355,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:11:57','',''),(2132765,'1','151','755',314,'Retail Sale Id 1265778',424908.80,0.00,0.00,0.00,25228.96,'2021-12-02 17:41:40','',''),(2132766,'1','151','755',314,'Retail sales',0.00,0.00,0.00,663.92,0.00,'2021-12-02 17:41:40','',''),(2132767,'1','151','755',314,'Retail Sale Id 1265778',483961.60,0.00,0.00,0.00,28735.22,'2021-12-02 17:41:40','',''),(2132768,'1','151','755',314,'Retail sales',0.00,0.00,0.00,756.19,0.00,'2021-12-02 17:41:40','',''),(2134053,'1','151','755',314,'Retail Sale Id 1266120',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 06:15:16','',''),(2134054,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:15:16','',''),(2134141,'1','151','755',314,'Retail Sale Id 1266168',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 06:26:17','',''),(2134142,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:26:17','',''),(2134147,'1','151','755',314,'Retail Sale Id 1266172',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 06:27:11','',''),(2134148,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:27:11','',''),(2134271,'1','151','755',314,'Retail Sale Id 1266222',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 06:35:11','',''),(2134272,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 06:35:11','',''),(2134313,'1','151','755',314,'Retail Sale Id 1266243',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 06:37:45','',''),(2134314,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:37:45','',''),(2134334,'1','151','755',314,'Retail Sale Id 1266254',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 06:38:50','',''),(2134335,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:38:50','',''),(2134354,'1','151','755',314,'Retail Sale Id 1266266',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 06:39:35','',''),(2134355,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 06:39:35','',''),(2134405,'1','151','755',314,'Retail Sale Id 1266292',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 06:42:53','',''),(2134406,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 06:42:53','',''),(2134421,'1','151','755',314,'Retail Sale Id 1266301',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 06:43:44','',''),(2134422,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:43:44','',''),(2134487,'1','151','755',314,'Retail Sale Id 1266333',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 06:46:43','',''),(2134488,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 06:46:43','',''),(2134543,'1','151','755',314,'Retail Sale Id 1266358',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 06:49:48','',''),(2134544,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:49:48','',''),(2134585,'1','151','755',314,'Retail Sale Id 1266379',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 06:52:20','',''),(2134586,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 06:52:20','',''),(2134603,'1','151','755',314,'Retail Sale Id 1266388',1932.80,0.00,0.00,0.00,114.76,'2021-12-03 06:53:20','',''),(2134604,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-03 06:53:20','',''),(2134649,'1','151','755',314,'Retail Sale Id 1266413',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:55:29','',''),(2134650,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:55:29','',''),(2134733,'1','151','755',314,'Retail Sale Id 1266448',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 07:00:11','',''),(2134734,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:00:11','',''),(2134815,'1','151','755',314,'Retail Sale Id 1266495',7500.80,0.00,0.00,0.00,445.36,'2021-12-03 07:05:27','',''),(2134816,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-03 07:05:27','',''),(2134845,'1','151','755',314,'Retail Sale Id 1266516',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 07:06:58','',''),(2134846,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 07:06:58','',''),(2134891,'1','151','755',314,'Retail Sale Id 1266539',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:10:21','',''),(2134892,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:10:21','',''),(2134909,'1','151','755',314,'Retail Sale Id 1266549',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:11:51','',''),(2134910,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:11:51','',''),(2134950,'1','151','755',314,'Retail Sale Id 1266557',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 07:12:44','',''),(2134951,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 07:12:44','',''),(2134970,'1','151','755',314,'Retail Sale Id 1266569',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 07:14:03','',''),(2134971,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 07:14:03','',''),(2135044,'1','151','755',314,'Retail Sale Id 1266608',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 07:18:03','',''),(2135045,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 07:18:03','',''),(2135093,'1','151','755',314,'Retail Sale Id 1266626',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 07:20:33','',''),(2135094,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 07:20:33','',''),(2135095,'1','151','755',314,'Retail Sale Id 1266626',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:20:33','',''),(2135096,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:20:33','',''),(2135115,'1','151','755',314,'Retail Sale Id 1266636',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:21:46','',''),(2135116,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:21:46','',''),(2135135,'1','151','755',314,'Retail Sale Id 1266647',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:22:56','',''),(2135136,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:22:56','',''),(2135157,'1','151','755',314,'Retail Sale Id 1266660',4198.40,0.00,0.00,0.00,249.28,'2021-12-03 07:24:17','',''),(2135158,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.56,0.00,'2021-12-03 07:24:17','',''),(2135172,'1','151','755',314,'Retail Sale Id 1266666',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:25:26','',''),(2135173,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:25:26','',''),(2135188,'1','151','755',314,'Retail Sale Id 1266674',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 07:26:13','',''),(2135189,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:26:13','',''),(2135202,'1','151','755',314,'Retail Sale Id 1266681',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:27:11','',''),(2135203,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:27:11','',''),(2135222,'1','151','755',314,'Retail Sale Id 1266691',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 07:28:21','',''),(2135223,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:28:21','',''),(2135270,'1','151','755',314,'Retail Sale Id 1266715',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 07:31:39','',''),(2135271,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:31:39','',''),(2135288,'1','151','755',314,'Retail Sale Id 1266727',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:32:52','',''),(2135289,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:32:52','',''),(2135352,'1','151','755',314,'Retail Sale Id 1266755',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:35:46','',''),(2135353,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:35:46','',''),(2135405,'1','151','755',314,'Retail Sale Id 1266777',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 07:38:01','',''),(2135406,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:38:01','',''),(2135413,'1','151','755',314,'Retail Sale Id 1266781',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 07:38:33','',''),(2135414,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:38:33','',''),(2135431,'1','151','755',314,'Retail Sale Id 1266790',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:39:54','',''),(2135432,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:39:54','',''),(2135489,'1','151','755',314,'Retail Sale Id 1266818',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 07:43:38','',''),(2135490,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 07:43:38','',''),(2135554,'1','151','755',314,'Retail Sale Id 1266850',998.40,0.00,0.00,0.00,59.28,'2021-12-03 07:46:47','',''),(2135555,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:46:47','',''),(2135572,'1','151','755',314,'Retail Sale Id 1266856',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 07:47:33','',''),(2135573,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 07:47:33','',''),(2135582,'1','151','755',314,'Retail Sale Id 1266863',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:48:16','',''),(2135583,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:48:16','',''),(2135602,'1','151','755',314,'Retail Sale Id 1266874',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 07:49:21','',''),(2135603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:49:21','',''),(2135621,'1','151','755',314,'Retail Sale Id 1266877',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 07:50:00','',''),(2135622,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 07:50:00','',''),(2135643,'1','151','755',314,'Retail Sale Id 1266890',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:50:50','',''),(2135644,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:50:50','',''),(2135659,'1','151','755',314,'Retail Sale Id 1266896',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 07:51:57','',''),(2135660,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:51:57','',''),(2135681,'1','151','755',314,'Retail Sale Id 1266909',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:52:49','',''),(2135682,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:52:49','',''),(2135701,'1','151','755',314,'Retail Sale Id 1266917',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 07:53:59','',''),(2135702,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:53:59','',''),(2135707,'1','151','755',314,'Retail Sale Id 1266922',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:54:47','',''),(2135708,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:54:47','',''),(2135773,'1','151','755',314,'Retail Sale Id 1266949',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 07:58:17','',''),(2135774,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:58:17','',''),(2135845,'1','151','755',314,'Retail Sale Id 1266973',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 08:01:19','',''),(2135846,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 08:01:19','',''),(2135901,'1','151','755',314,'Retail Sale Id 1266989',998.40,0.00,0.00,0.00,59.28,'2021-12-03 08:02:46','',''),(2135902,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:02:46','',''),(2136048,'1','151','755',314,'Retail Sale Id 1267057',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 08:08:35','',''),(2136049,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:08:35','',''),(2136060,'1','151','755',314,'Retail Sale Id 1267064',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 08:09:23','',''),(2136061,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:09:23','',''),(2136082,'1','151','755',314,'Retail Sale Id 1267076',998.40,0.00,0.00,0.00,59.28,'2021-12-03 08:10:32','',''),(2136083,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:10:32','',''),(2136100,'1','151','755',314,'Retail Sale Id 1267086',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 08:11:22','',''),(2136101,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:11:22','',''),(2136156,'1','151','755',314,'Retail Sale Id 1267114',2560.00,0.00,0.00,0.00,152.00,'2021-12-03 08:14:04','',''),(2136157,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 08:14:04','',''),(2136206,'1','151','755',314,'Retail Sale Id 1267144',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 08:17:14','',''),(2136207,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:17:14','',''),(2136255,'1','151','755',314,'Retail Sale Id 1267170',4499.20,0.00,0.00,0.00,267.14,'2021-12-03 08:20:04','',''),(2136256,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 08:20:04','',''),(2136598,'1','151','755',314,'Retail Sale Id 1267290',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 08:37:39','',''),(2136599,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:37:39','',''),(2136620,'1','151','755',314,'Retail Sale Id 1267298',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 08:38:31','',''),(2136621,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:38:31','',''),(2136820,'1','151','755',314,'Retail Sale Id 1267366',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 08:46:21','',''),(2136821,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 08:46:21','',''),(2136832,'1','151','755',314,'Retail Sale Id 1267375',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 08:47:18','',''),(2136833,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 08:47:18','',''),(2136890,'1','151','755',314,'Retail Sale Id 1267406',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 08:50:57','',''),(2136891,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:50:57','',''),(2136962,'1','151','755',314,'Retail Sale Id 1267443',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 08:55:04','',''),(2136963,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:55:04','',''),(2137184,'1','151','755',314,'Retail Sale Id 1267564',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 09:06:38','',''),(2137185,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:06:38','',''),(2137186,'1','151','755',314,'Retail Sale Id 1267564',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 09:06:38','',''),(2137187,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:06:38','',''),(2137209,'1','151','755',314,'Retail Sale Id 1267573',998.40,0.00,0.00,0.00,59.28,'2021-12-03 09:07:27','',''),(2137210,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:07:27','',''),(2137243,'1','151','755',314,'Retail Sale Id 1267595',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:08:59','',''),(2137244,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:08:59','',''),(2137265,'1','151','755',314,'Retail Sale Id 1267614',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 09:10:20','',''),(2137266,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 09:10:20','',''),(2137289,'1','151','755',314,'Retail Sale Id 1267633',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 09:11:35','',''),(2137290,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 09:11:35','',''),(2137308,'1','151','755',314,'Retail Sale Id 1267642',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:12:34','',''),(2137309,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:12:34','',''),(2137324,'1','151','755',314,'Retail Sale Id 1267653',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:13:16','',''),(2137325,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:13:16','',''),(2137348,'1','151','755',314,'Retail Sale Id 1267667',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:14:42','',''),(2137349,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:14:42','',''),(2137350,'1','151','755',314,'Retail Sale Id 1267667',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:14:42','',''),(2137351,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:14:42','',''),(2137385,'1','151','755',314,'Retail Sale Id 1267685',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:16:10','',''),(2137386,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:16:10','',''),(2137411,'1','151','755',314,'Retail Sale Id 1267704',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:17:26','',''),(2137412,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:17:26','',''),(2137519,'1','151','755',314,'Retail Sale Id 1267753',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 09:23:48','',''),(2137520,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:23:48','',''),(2137551,'1','151','755',314,'Retail Sale Id 1267766',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:25:53','',''),(2137552,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:25:53','',''),(2137673,'1','151','755',314,'Retail Sale Id 1267842',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 09:33:31','',''),(2137674,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:33:31','',''),(2137743,'1','151','755',314,'Retail Sale Id 1267882',800.00,0.00,0.00,0.00,47.50,'2021-12-03 09:38:06','',''),(2137744,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 09:38:06','',''),(2137763,'1','151','755',314,'Retail Sale Id 1267897',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:39:27','',''),(2137764,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:39:27','',''),(2137807,'1','151','755',314,'Retail Sale Id 1267918',3603.20,0.00,0.00,0.00,213.94,'2021-12-03 09:42:27','',''),(2137808,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-03 09:42:27','',''),(2137809,'1','151','755',314,'Retail Sale Id 1267918',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 09:42:27','',''),(2137810,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 09:42:27','',''),(2137857,'1','151','755',314,'Retail Sale Id 1267943',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:45:07','',''),(2137858,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:45:07','',''),(2137879,'1','151','755',314,'Retail Sale Id 1267953',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 09:46:13','',''),(2137880,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:46:13','',''),(2137920,'1','151','755',314,'Retail Sale Id 1267974',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:48:44','',''),(2137921,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:48:44','',''),(2137992,'1','151','755',314,'Retail Sale Id 1268008',6502.40,0.00,0.00,0.00,386.08,'2021-12-03 09:53:13','',''),(2137993,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-03 09:53:13','',''),(2138020,'1','151','755',314,'Retail Sale Id 1268021',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 09:55:14','',''),(2138021,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 09:55:14','',''),(2138036,'1','151','755',314,'Retail Sale Id 1268031',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:56:08','',''),(2138037,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:56:08','',''),(2138058,'1','151','755',314,'Retail Sale Id 1268039',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 09:57:38','',''),(2138059,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:57:38','',''),(2138060,'1','151','755',314,'Retail Sale Id 1268039',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:57:38','',''),(2138061,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:57:38','',''),(2138086,'1','151','755',314,'Retail Sale Id 1268054',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:59:12','',''),(2138087,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:59:12','',''),(2138088,'1','151','755',314,'Retail Sale Id 1268054',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:59:12','',''),(2138089,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:59:12','',''),(2138150,'1','151','755',314,'Retail Sale Id 1268087',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 10:02:53','',''),(2138151,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:02:53','',''),(2138167,'1','151','755',314,'Retail Sale Id 1268094',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:04:08','',''),(2138168,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:04:08','',''),(2138191,'1','151','755',314,'Retail Sale Id 1268106',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 10:05:33','',''),(2138192,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:05:33','',''),(2138213,'1','151','755',314,'Retail Sale Id 1268120',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 10:06:34','',''),(2138214,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:06:34','',''),(2138233,'1','151','755',314,'Retail Sale Id 1268129',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:07:29','',''),(2138234,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:07:29','',''),(2138284,'1','151','755',314,'Retail Sale Id 1268151',998.40,0.00,0.00,0.00,59.28,'2021-12-03 10:10:00','',''),(2138285,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:10:00','',''),(2138673,'1','151','755',314,'Return of Retail Sale Id 1268031',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 10:32:24','',''),(2138684,'1','151','755',314,'Return of Retail Sale Id 1267897',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 10:33:38','',''),(2138721,'1','151','755',314,'Return of Retail Sale Id 1267564',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-03 10:36:27','',''),(2138722,'1','151','755',314,'Return of Retail Sale Id 1267564',0.00,32000.00,50.00,0.00,-1900.00,'2021-12-03 10:36:27','',''),(2138759,'1','151','755',314,'Return of Retail Sale Id 1268054',0.00,3200.00,5.00,0.00,-190.00,'2021-12-03 10:37:50','',''),(2138760,'1','151','755',314,'Return of Retail Sale Id 1268054',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 10:37:50','',''),(2138817,'1','151','755',314,'Retail Sale Id 1268413',3769.60,0.00,0.00,0.00,223.82,'2021-12-03 10:41:32','',''),(2138818,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.89,0.00,'2021-12-03 10:41:32','',''),(2138819,'1','151','755',314,'Retail Sale Id 1268413',145190.40,0.00,0.00,0.00,8620.68,'2021-12-03 10:41:32','',''),(2138820,'1','151','755',314,'Retail sales',0.00,0.00,0.00,226.86,0.00,'2021-12-03 10:41:32','',''),(2139025,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,2689736.00,4468.00,0.00,0.00,'2021-12-03 10:58:42','',''),(2139044,'1','151',NULL,314,'Reception corrector for bridging 126057',0.00,0.00,0.00,4468.00,0.00,'2021-12-03 11:00:21','',''),(2139045,'1','151','755',314,'Received from bridging 126057',0.00,0.00,4468.00,0.00,0.00,'2021-12-03 11:00:21','',''),(2140186,'1','151','755',314,'Retail Sale Id 1269167',1100.80,0.00,0.00,0.00,65.36,'2021-12-03 12:29:17','',''),(2140187,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-03 12:29:17','',''),(2140194,'1','151','755',314,'Retail Sale Id 1269174',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 12:30:01','',''),(2140195,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 12:30:01','',''),(2140212,'1','151','755',314,'Retail Sale Id 1269181',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 12:31:02','',''),(2140213,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:31:02','',''),(2140224,'1','151','755',314,'Retail Sale Id 1269191',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 12:32:05','',''),(2140225,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:32:05','',''),(2140242,'1','151','755',314,'Retail Sale Id 1269208',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 12:33:36','',''),(2140243,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:33:36','',''),(2140321,'1','151','755',314,'Retail Sale Id 1269246',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 12:39:40','',''),(2140322,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:39:40','',''),(2140339,'1','151','755',314,'Retail Sale Id 1269253',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 12:41:02','',''),(2140340,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 12:41:02','',''),(2140361,'1','151','755',314,'Retail Sale Id 1269260',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 12:42:00','',''),(2140362,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 12:42:00','',''),(2140371,'1','151','755',314,'Retail Sale Id 1269268',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 12:43:17','',''),(2140372,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:43:17','',''),(2140385,'1','151','755',314,'Retail Sale Id 1269273',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 12:44:07','',''),(2140386,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 12:44:07','',''),(2140393,'1','151','755',314,'Retail Sale Id 1269277',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 12:44:55','',''),(2140394,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 12:44:55','',''),(2140407,'1','151','755',314,'Retail Sale Id 1269284',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 12:46:14','',''),(2140408,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:46:14','',''),(2140421,'1','151','755',314,'Retail Sale Id 1269290',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 12:47:11','',''),(2140422,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:47:11','',''),(2140423,'1','151','755',314,'Retail Sale Id 1269290',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 12:47:11','',''),(2140424,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:47:11','',''),(2140431,'1','151','755',314,'Retail Sale Id 1269297',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 12:48:03','',''),(2140432,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 12:48:03','',''),(2140449,'1','151','755',314,'Retail Sale Id 1269305',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 12:48:56','',''),(2140450,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 12:48:56','',''),(2140469,'1','151','755',314,'Retail Sale Id 1269311',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 12:50:02','',''),(2140470,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 12:50:02','',''),(2140483,'1','151','755',314,'Retail Sale Id 1269318',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 12:50:55','',''),(2140484,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 12:50:55','',''),(2140499,'1','151','755',314,'Retail Sale Id 1269327',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 12:51:46','',''),(2140500,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 12:51:46','',''),(2140513,'1','151','755',314,'Retail Sale Id 1269335',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 12:52:42','',''),(2140514,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:52:42','',''),(2140523,'1','151','755',314,'Retail Sale Id 1269340',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 12:53:32','',''),(2140524,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:53:32','',''),(2140565,'1','151','755',314,'Retail Sale Id 1269358',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 12:56:27','',''),(2140566,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:56:27','',''),(2140626,'1','151','755',314,'Retail Sale Id 1269388',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 13:01:38','',''),(2140627,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 13:01:38','',''),(2140648,'1','151','755',314,'Retail Sale Id 1269399',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 13:03:51','',''),(2140649,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:03:51','',''),(2140781,'1','151','755',314,'Retail Sale Id 1269465',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 13:15:36','',''),(2140782,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:15:36','',''),(2140810,'1','151','755',314,'Retail Sale Id 1269471',2297.60,0.00,0.00,0.00,136.42,'2021-12-03 13:17:38','',''),(2140811,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-03 13:17:38','',''),(2140853,'1','151','755',314,'Retail Sale Id 1269484',16000.00,0.00,0.00,0.00,950.00,'2021-12-03 13:20:13','',''),(2140854,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 13:20:13','',''),(2140871,'1','151','755',314,'Retail Sale Id 1269493',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 13:21:31','',''),(2140872,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:21:31','',''),(2140921,'1','151','755',314,'Retail Sale Id 1269516',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 13:26:18','',''),(2140922,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:26:18','',''),(2140966,'1','151','755',314,'Retail Sale Id 1269542',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 13:29:24','',''),(2140967,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:29:24','',''),(2141351,'1','151','755',314,'Retail Sale Id 1269704',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 13:48:44','',''),(2141352,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:48:44','',''),(2141427,'1','151','755',314,'Retail Sale Id 1269722',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 13:51:24','',''),(2141428,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:51:24','',''),(2141429,'1','151','755',314,'Retail Sale Id 1269722',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 13:51:24','',''),(2141430,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:51:24','',''),(2141461,'1','151','755',314,'Retail Sale Id 1269738',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 13:52:59','',''),(2141462,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:52:59','',''),(2141473,'1','151','755',314,'Retail Sale Id 1269747',2560.00,0.00,0.00,0.00,152.00,'2021-12-03 13:53:43','',''),(2141474,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:53:43','',''),(2141560,'1','151','755',314,'Retail Sale Id 1269787',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 14:00:03','',''),(2141561,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:00:03','',''),(2141616,'1','151','755',314,'Retail Sale Id 1269811',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 14:03:44','',''),(2141617,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:03:44','',''),(2141643,'1','151','755',314,'Retail Sale Id 1269822',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 14:04:49','',''),(2141644,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:04:49','',''),(2141659,'1','151','755',314,'Retail Sale Id 1269828',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:05:54','',''),(2141660,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:05:54','',''),(2141725,'1','151','755',314,'Retail Sale Id 1269852',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 14:09:12','',''),(2141726,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:09:12','',''),(2141774,'1','151','755',314,'Retail Sale Id 1269877',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 14:12:34','',''),(2141775,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:12:34','',''),(2141794,'1','151','755',314,'Retail Sale Id 1269888',1849.60,0.00,0.00,0.00,109.82,'2021-12-03 14:14:25','',''),(2141795,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.89,0.00,'2021-12-03 14:14:25','',''),(2141856,'1','151','755',314,'Retail Sale Id 1269913',1868.80,0.00,0.00,0.00,110.96,'2021-12-03 14:18:36','',''),(2141857,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-03 14:18:36','',''),(2141900,'1','151','755',314,'Retail Sale Id 1269927',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 14:20:58','',''),(2141901,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 14:20:58','',''),(2142032,'1','151','755',314,'Retail Sale Id 1269976',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 14:27:58','',''),(2142033,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 14:27:58','',''),(2142071,'1','151','755',314,'Retail Sale Id 1269995',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 14:30:46','',''),(2142072,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:30:46','',''),(2142073,'1','151','755',314,'Retail Sale Id 1269995',6662.40,0.00,0.00,0.00,395.58,'2021-12-03 14:30:46','',''),(2142074,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.41,0.00,'2021-12-03 14:30:46','',''),(2142148,'1','151','755',314,'Retail Sale Id 1270022',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 14:34:46','',''),(2142149,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:34:46','',''),(2142150,'1','151','755',314,'Retail Sale Id 1270022',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 14:34:46','',''),(2142151,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:34:46','',''),(2142195,'1','151','755',314,'Retail Sale Id 1270035',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 14:37:15','',''),(2142196,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:37:15','',''),(2142246,'1','151','755',314,'Retail Sale Id 1270053',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 14:39:57','',''),(2142247,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 14:39:57','',''),(2142353,'1','151','755',314,'Retail Sale Id 1270089',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 14:43:51','',''),(2142354,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:43:51','',''),(2142355,'1','151','755',314,'Retail Sale Id 1270089',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 14:43:51','',''),(2142356,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:43:51','',''),(2142381,'1','151','755',314,'Retail Sale Id 1270104',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 14:45:06','',''),(2142382,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:45:06','',''),(2142423,'1','151','755',314,'Retail Sale Id 1270122',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 14:46:51','',''),(2142424,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:46:51','',''),(2142425,'1','151','755',314,'Retail Sale Id 1270122',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 14:46:51','',''),(2142426,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:46:51','',''),(2142459,'1','151','755',314,'Retail Sale Id 1270147',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:48:05','',''),(2142460,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:48:05','',''),(2142494,'1','151','755',314,'Retail Sale Id 1270165',3801.60,0.00,0.00,0.00,225.72,'2021-12-03 14:49:38','',''),(2142495,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 14:49:38','',''),(2142587,'1','151','755',314,'Retail Sale Id 1270211',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:54:15','',''),(2142588,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:54:15','',''),(2142623,'1','151','755',314,'Retail Sale Id 1270222',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 14:55:48','',''),(2142624,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:55:48','',''),(2142697,'1','151','755',314,'Retail Sale Id 1270255',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 14:59:28','',''),(2142698,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 14:59:28','',''),(2142775,'1','151','755',314,'Retail Sale Id 1270296',1907.20,0.00,0.00,0.00,113.24,'2021-12-03 15:05:16','',''),(2142776,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.98,0.00,'2021-12-03 15:05:16','',''),(2142790,'1','151','755',314,'Retail Sale Id 1270302',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:06:00','',''),(2142791,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:06:00','',''),(2142836,'1','151','755',314,'Retail Sale Id 1270325',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 15:09:06','',''),(2142837,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:09:06','',''),(2142878,'1','151','755',314,'Retail Sale Id 1270350',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:11:05','',''),(2142879,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:11:05','',''),(2142936,'1','151','755',314,'Retail Sale Id 1270375',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:13:38','',''),(2142937,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:13:38','',''),(2142970,'1','151','755',314,'Retail Sale Id 1270398',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:15:05','',''),(2142971,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:15:05','',''),(2143008,'1','151','755',314,'Retail Sale Id 1270422',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 15:16:54','',''),(2143009,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:16:54','',''),(2143010,'1','151','755',314,'Retail Sale Id 1270422',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:16:54','',''),(2143011,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:16:54','',''),(2143033,'1','151','755',314,'Retail Sale Id 1270436',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:18:04','',''),(2143034,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:18:04','',''),(2143073,'1','151','755',314,'Retail Sale Id 1270459',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 15:20:05','',''),(2143074,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:20:06','',''),(2143075,'1','151','755',314,'Retail Sale Id 1270459',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:20:06','',''),(2143076,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:20:06','',''),(2143206,'1','151','755',314,'Retail Sale Id 1270529',12.80,0.00,0.00,0.00,0.76,'2021-12-03 15:27:29','',''),(2143207,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.02,0.00,'2021-12-03 15:27:29','',''),(2143208,'1','151','755',314,'Retail Sale Id 1270529',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 15:27:29','',''),(2143209,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:27:29','',''),(2143222,'1','151','755',314,'Retail Sale Id 1270538',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 15:28:24','',''),(2143223,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:28:24','',''),(2143224,'1','151','755',314,'Retail Sale Id 1270538',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:28:24','',''),(2143225,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:28:24','',''),(2143241,'1','151','755',314,'Retail Sale Id 1270547',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:29:08','',''),(2143242,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:29:08','',''),(2143273,'1','151','755',314,'Retail Sale Id 1270561',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:30:22','',''),(2143274,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:30:22','',''),(2143305,'1','151','755',314,'Retail Sale Id 1270577',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:32:01','',''),(2143306,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:32:01','',''),(2143307,'1','151','755',314,'Retail Sale Id 1270577',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:32:01','',''),(2143308,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:32:01','',''),(2143343,'1','151','755',314,'Retail Sale Id 1270601',1900.80,0.00,0.00,0.00,112.86,'2021-12-03 15:33:55','',''),(2143344,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 15:33:55','',''),(2143391,'1','151','755',314,'Retail Sale Id 1270613',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:35:03','',''),(2143392,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:35:03','',''),(2143407,'1','151','755',314,'Retail Sale Id 1270627',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:36:05','',''),(2143408,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:36:05','',''),(2143452,'1','151','755',314,'Retail Sale Id 1270646',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:37:50','',''),(2143453,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:37:50','',''),(2143484,'1','151','755',314,'Retail Sale Id 1270667',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 15:39:03','',''),(2143485,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:39:03','',''),(2143570,'1','151','755',314,'Retail Sale Id 1270709',1907.20,0.00,0.00,0.00,113.24,'2021-12-03 15:42:35','',''),(2143571,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.98,0.00,'2021-12-03 15:42:35','',''),(2143602,'1','151','755',314,'Retail Sale Id 1270723',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:43:44','',''),(2143603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:43:44','',''),(2143624,'1','151','755',314,'Retail Sale Id 1270736',3827.20,0.00,0.00,0.00,227.24,'2021-12-03 15:44:57','',''),(2143625,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.98,0.00,'2021-12-03 15:44:57','',''),(2143658,'1','151','755',314,'Retail Sale Id 1270746',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:46:08','',''),(2143659,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:46:08','',''),(2143660,'1','151','755',314,'Retail Sale Id 1270746',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:46:08','',''),(2143661,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:46:08','',''),(2143678,'1','151','755',314,'Retail Sale Id 1270759',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 15:47:09','',''),(2143679,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:47:09','',''),(2143720,'1','151','755',314,'Retail Sale Id 1270779',3840.00,0.00,0.00,0.00,228.00,'2021-12-03 15:48:12','',''),(2143721,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:48:12','',''),(2143750,'1','151','755',314,'Retail Sale Id 1270792',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:49:21','',''),(2143751,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:49:21','',''),(2143794,'1','151','755',314,'Retail Sale Id 1270818',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 15:51:46','',''),(2143795,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:51:46','',''),(2143820,'1','151','755',314,'Retail Sale Id 1270831',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 15:52:54','',''),(2143821,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:52:54','',''),(2143838,'1','151','755',314,'Retail Sale Id 1270840',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 15:53:58','',''),(2143839,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:53:58','',''),(2143873,'1','151','755',314,'Retail Sale Id 1270857',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 15:55:37','',''),(2143874,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:55:37','',''),(2143899,'1','151','755',314,'Retail Sale Id 1270872',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 15:57:09','',''),(2143900,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 15:57:09','',''),(2143927,'1','151','755',314,'Retail Sale Id 1270885',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:58:19','',''),(2143928,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:58:19','',''),(2143950,'1','151','755',314,'Retail Sale Id 1270896',800.00,0.00,0.00,0.00,47.50,'2021-12-03 15:59:36','',''),(2143951,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 15:59:36','',''),(2143979,'1','151','755',314,'Retail Sale Id 1270909',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:00:38','',''),(2143980,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:00:38','',''),(2144055,'1','151','755',314,'Retail Sale Id 1270941',1932.80,0.00,0.00,0.00,114.76,'2021-12-03 16:03:48','',''),(2144056,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-03 16:03:48','',''),(2144218,'1','151','755',314,'Retail Sale Id 1271026',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 16:10:48','',''),(2144219,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:10:48','',''),(2144260,'1','151','755',314,'Retail Sale Id 1271050',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 16:13:02','',''),(2144261,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:13:02','',''),(2144280,'1','151','755',314,'Retail Sale Id 1271061',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 16:14:31','',''),(2144281,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:14:31','',''),(2144342,'1','151','755',314,'Retail Sale Id 1271090',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 16:18:05','',''),(2144343,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:18:05','',''),(2144498,'1','151','755',314,'Retail Sale Id 1271172',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 16:26:09','',''),(2144499,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:26:09','',''),(2144586,'1','151','755',314,'Retail Sale Id 1271211',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 16:30:37','',''),(2144587,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:30:37','',''),(2144588,'1','151','755',314,'Retail Sale Id 1271211',2560.00,0.00,0.00,0.00,152.00,'2021-12-03 16:30:37','',''),(2144589,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:30:37','',''),(2144702,'1','151','755',314,'Retail Sale Id 1271272',7001.60,0.00,0.00,0.00,415.72,'2021-12-03 16:36:44','',''),(2144703,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 16:36:44','',''),(2144828,'1','151','755',314,'Retail Sale Id 1271333',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 16:42:14','',''),(2144829,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:42:14','',''),(2144852,'1','151','755',314,'Retail Sale Id 1271347',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 16:43:16','',''),(2144853,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:43:16','',''),(2144869,'1','151','755',314,'Retail Sale Id 1271358',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:44:35','',''),(2144870,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:44:35','',''),(2144899,'1','151','755',314,'Retail Sale Id 1271371',1920.00,0.00,0.00,0.00,114.00,'2021-12-03 16:45:56','',''),(2144900,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:45:56','',''),(2144917,'1','151','755',314,'Retail Sale Id 1271379',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 16:47:14','',''),(2144918,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:47:14','',''),(2144935,'1','151','755',314,'Retail Sale Id 1271388',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:48:06','',''),(2144936,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:48:06','',''),(2145040,'1','151','755',314,'Retail Sale Id 1271432',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 16:53:34','',''),(2145041,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:53:34','',''),(2145042,'1','151','755',314,'Retail Sale Id 1271432',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 16:53:34','',''),(2145043,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:53:34','',''),(2145153,'1','151','755',314,'Retail Sale Id 1271466',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:56:41','',''),(2145154,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:56:41','',''),(2145254,'1','151','755',314,'Retail Sale Id 1271518',3859.20,0.00,0.00,0.00,229.14,'2021-12-03 17:03:43','',''),(2145255,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.03,0.00,'2021-12-03 17:03:43','',''),(2145296,'1','151','755',314,'Retail Sale Id 1271543',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 17:06:08','',''),(2145297,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 17:06:08','',''),(2145361,'1','151','755',314,'Retail Sale Id 1271575',5497.60,0.00,0.00,0.00,326.42,'2021-12-03 17:12:26','',''),(2145362,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-03 17:12:26','',''),(2145406,'1','151','755',314,'Retail Sale Id 1271599',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 17:16:35','',''),(2145407,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 17:16:35','',''),(2145431,'1','151','755',314,'Retail Sale Id 1271612',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 17:19:46','',''),(2145432,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:19:46','',''),(2145481,'1','151','755',314,'Retail Sale Id 1271637',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 17:25:50','',''),(2145482,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 17:25:50','',''),(2145493,'1','151','755',314,'Retail Sale Id 1271643',998.40,0.00,0.00,0.00,59.28,'2021-12-03 17:26:40','',''),(2145494,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:26:40','',''),(2146495,'1','151','755',314,'Retail Sale Id 1271950',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 05:43:31','',''),(2146496,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:43:31','',''),(2146565,'1','151','755',314,'Retail Sale Id 1271972',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 05:54:54','',''),(2146566,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 05:54:54','',''),(2146590,'1','151','755',314,'Retail Sale Id 1271977',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 05:56:30','',''),(2146591,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 05:56:30','',''),(2146602,'1','151','755',314,'Retail Sale Id 1271979',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 05:57:49','',''),(2146603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 05:57:49','',''),(2146610,'1','151','755',314,'Retail Sale Id 1271982',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 05:59:13','',''),(2146611,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 05:59:13','',''),(2146851,'1','151','755',314,'Retail Sale Id 1272066',499.20,0.00,0.00,0.00,29.64,'2021-12-04 06:23:42','',''),(2146852,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 06:23:42','',''),(2146853,'1','151','755',314,'Retail Sale Id 1272066',499.20,0.00,0.00,0.00,29.64,'2021-12-04 06:23:42','',''),(2146854,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 06:23:42','',''),(2146855,'1','151','755',314,'Retail Sale Id 1272066',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:23:42','',''),(2146856,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:23:42','',''),(2146908,'1','151','755',314,'Retail Sale Id 1272085',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:26:30','',''),(2146909,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:26:30','',''),(2146972,'1','151','755',314,'Retail Sale Id 1272103',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:28:21','',''),(2146973,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:28:21','',''),(2147060,'1','151','755',314,'Retail Sale Id 1272147',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 06:34:24','',''),(2147061,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:34:25','',''),(2147062,'1','151','755',314,'Retail Sale Id 1272147',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 06:34:25','',''),(2147063,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:34:25','',''),(2147064,'1','151','755',314,'Retail Sale Id 1272147',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 06:34:25','',''),(2147065,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:34:25','',''),(2147160,'1','151','755',314,'Retail Sale Id 1272188',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 06:39:14','',''),(2147161,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:39:14','',''),(2147354,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147355,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147356,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147357,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147358,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147359,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147360,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147361,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147362,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147363,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147364,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147365,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147366,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147367,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147368,'1','151','755',314,'Retail Sale Id 1272275',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:49:56','',''),(2147369,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:49:56','',''),(2147400,'1','151','755',314,'Retail Sale Id 1272293',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:52:11','',''),(2147401,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:52:11','',''),(2147436,'1','151','755',314,'Retail Sale Id 1272312',1203.20,0.00,0.00,0.00,71.44,'2021-12-04 06:54:07','',''),(2147437,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 06:54:07','',''),(2147438,'1','151','755',314,'Retail Sale Id 1272312',1798.40,0.00,0.00,0.00,106.78,'2021-12-04 06:54:07','',''),(2147439,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 06:54:07','',''),(2147653,'1','151','755',314,'Retail Sale Id 1272414',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 07:05:05','',''),(2147654,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:05:05','',''),(2147655,'1','151','755',314,'Retail Sale Id 1272414',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:05:06','',''),(2147656,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:05:06','',''),(2147819,'1','151','755',314,'Retail Sale Id 1272504',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:14:51','',''),(2147820,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:14:51','',''),(2147878,'1','151','755',314,'Retail Sale Id 1272537',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:17:17','',''),(2147879,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:17:17','',''),(2148040,'1','151','755',314,'Retail Sale Id 1272623',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 07:25:47','',''),(2148041,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:25:47','',''),(2148325,'1','151','755',314,'Retail Sale Id 1272778',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:39:13','',''),(2148326,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:39:13','',''),(2148327,'1','151','755',314,'Retail Sale Id 1272778',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:39:13','',''),(2148328,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:39:13','',''),(2148482,'1','151','755',314,'Retail Sale Id 1272912',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 07:48:18','',''),(2148483,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 07:48:18','',''),(2148529,'1','151','755',314,'Retail Sale Id 1272939',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:50:59','',''),(2148530,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:50:59','',''),(2148566,'1','151','755',314,'Retail Sale Id 1272967',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 07:53:17','',''),(2148567,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 07:53:17','',''),(2148602,'1','151','755',314,'Retail Sale Id 1272980',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:55:41','',''),(2148603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:55:41','',''),(2148628,'1','151','755',314,'Retail Sale Id 1273013',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 07:57:20','',''),(2148629,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:57:20','',''),(2148661,'1','151','755',314,'Retail Sale Id 1273033',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:59:01','',''),(2148662,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:59:01','',''),(2148729,'1','151','755',314,'Retail Sale Id 1273058',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:01:29','',''),(2148730,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:01:29','',''),(2148753,'1','151','755',314,'Retail Sale Id 1273068',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:02:45','',''),(2148754,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:02:45','',''),(2148791,'1','151','755',314,'Retail Sale Id 1273084',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:04:09','',''),(2148792,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:04:09','',''),(2148841,'1','151','755',314,'Retail Sale Id 1273118',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 08:06:10','',''),(2148842,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 08:06:10','',''),(2148870,'1','151','755',314,'Retail Sale Id 1273129',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:07:13','',''),(2148871,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:07:13','',''),(2148944,'1','151','755',314,'Retail Sale Id 1273183',3897.60,0.00,0.00,0.00,231.42,'2021-12-04 08:11:10','',''),(2148945,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:11:10','',''),(2148966,'1','151','755',314,'Retail Sale Id 1273195',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:12:11','',''),(2148967,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:12:11','',''),(2148996,'1','151','755',314,'Retail Sale Id 1273207',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:13:19','',''),(2148997,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:13:19','',''),(2149073,'1','151','755',314,'Retail Sale Id 1273239',8499.20,0.00,0.00,0.00,504.64,'2021-12-04 08:15:54','',''),(2149074,'1','151','755',314,'Retail sales',0.00,0.00,0.00,13.28,0.00,'2021-12-04 08:15:54','',''),(2149119,'1','151','755',314,'Retail Sale Id 1273257',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:17:32','',''),(2149120,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:17:32','',''),(2149213,'1','151','755',314,'Retail Sale Id 1273329',3603.20,0.00,0.00,0.00,213.94,'2021-12-04 08:22:22','',''),(2149214,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-04 08:22:22','',''),(2149268,'1','151','755',314,'Retail Sale Id 1273395',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:24:32','',''),(2149269,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:24:32','',''),(2149300,'1','151','755',314,'Retail Sale Id 1273411',7500.80,0.00,0.00,0.00,445.36,'2021-12-04 08:25:46','',''),(2149301,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-04 08:25:46','',''),(2149318,'1','151','755',314,'Retail Sale Id 1273420',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:26:49','',''),(2149319,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:26:49','',''),(2149346,'1','151','755',314,'Retail Sale Id 1273434',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:27:58','',''),(2149347,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:27:58','',''),(2149348,'1','151','755',314,'Retail Sale Id 1273434',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:27:58','',''),(2149349,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:27:58','',''),(2149396,'1','151','755',314,'Retail Sale Id 1273459',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:29:57','',''),(2149397,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:29:57','',''),(2149398,'1','151','755',314,'Retail Sale Id 1273459',7040.00,0.00,0.00,0.00,418.00,'2021-12-04 08:29:57','',''),(2149399,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 08:29:57','',''),(2149454,'1','151','755',314,'Retail Sale Id 1273517',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:31:42','',''),(2149455,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:31:42','',''),(2149519,'1','151','755',314,'Retail Sale Id 1273542',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:33:34','',''),(2149520,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:33:34','',''),(2149584,'1','151','755',314,'Retail Sale Id 1273573',1900.80,0.00,0.00,0.00,112.86,'2021-12-04 08:36:11','',''),(2149585,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 08:36:11','',''),(2149694,'1','151','755',314,'Retail Sale Id 1273619',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:40:49','',''),(2149695,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:40:49','',''),(2149784,'1','151','755',314,'Retail Sale Id 1273663',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:44:18','',''),(2149785,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:44:18','',''),(2149814,'1','151','755',314,'Retail Sale Id 1273681',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 08:45:30','',''),(2149815,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:45:30','',''),(2149852,'1','151','755',314,'Retail Sale Id 1273700',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 08:46:48','',''),(2149853,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:46:48','',''),(2149870,'1','151','755',314,'Retail Sale Id 1273712',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 08:47:43','',''),(2149871,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:47:43','',''),(2149890,'1','151','755',314,'Retail Sale Id 1273720',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:48:44','',''),(2149891,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:48:44','',''),(2149990,'1','151','755',314,'Retail Sale Id 1273782',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:53:31','',''),(2149991,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:53:31','',''),(2149992,'1','151','755',314,'Retail Sale Id 1273782',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:53:31','',''),(2149993,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:53:31','',''),(2150014,'1','151','755',314,'Retail Sale Id 1273794',6003.20,0.00,0.00,0.00,356.44,'2021-12-04 08:54:47','',''),(2150015,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 08:54:47','',''),(2150067,'1','151','755',314,'Retail Sale Id 1273821',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:57:06','',''),(2150068,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:57:06','',''),(2150097,'1','151','755',314,'Retail Sale Id 1273836',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 08:58:35','',''),(2150098,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 08:58:35','',''),(2150127,'1','151','755',314,'Retail Sale Id 1273850',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:59:31','',''),(2150128,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:59:31','',''),(2150223,'1','151','755',314,'Retail Sale Id 1273907',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 09:04:20','',''),(2150224,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:04:20','',''),(2150247,'1','151','755',314,'Retail Sale Id 1273921',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 09:05:21','',''),(2150248,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:05:21','',''),(2150377,'1','151','755',314,'Retail Sale Id 1273985',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:12:35','',''),(2150378,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:12:35','',''),(2150379,'1','151','755',314,'Retail Sale Id 1273985',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:12:35','',''),(2150380,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:12:35','',''),(2150415,'1','151','755',314,'Retail Sale Id 1274002',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 09:14:25','',''),(2150416,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:14:25','',''),(2150485,'1','151','755',314,'Retail Sale Id 1274040',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:17:45','',''),(2150486,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:17:45','',''),(2150511,'1','151','755',314,'Retail Sale Id 1274056',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 09:18:55','',''),(2150512,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:18:55','',''),(2150547,'1','151','755',314,'Retail Sale Id 1274072',3801.60,0.00,0.00,0.00,225.72,'2021-12-04 09:20:28','',''),(2150548,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-04 09:20:28','',''),(2150583,'1','151','755',314,'Retail Sale Id 1274095',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:21:58','',''),(2150584,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:21:58','',''),(2150607,'1','151','755',314,'Retail Sale Id 1274107',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 09:23:04','',''),(2150608,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 09:23:04','',''),(2150647,'1','151','755',314,'Retail Sale Id 1274129',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:25:48','',''),(2150648,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:25:48','',''),(2150696,'1','151','755',314,'Retail Sale Id 1274149',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 09:27:51','',''),(2150697,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 09:27:51','',''),(2150716,'1','151','755',314,'Retail Sale Id 1274159',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:28:46','',''),(2150717,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:28:46','',''),(2150762,'1','151','755',314,'Retail Sale Id 1274185',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 09:31:00','',''),(2150763,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:31:00','',''),(2150788,'1','151','755',314,'Retail Sale Id 1274202',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 09:32:24','',''),(2150789,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:32:24','',''),(2150830,'1','151','755',314,'Retail Sale Id 1274227',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 09:34:26','',''),(2150831,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:34:26','',''),(2150832,'1','151','755',314,'Retail Sale Id 1274227',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:34:26','',''),(2150833,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:34:26','',''),(2155077,'1','151','755',314,'Retail Sale Id 1275777',32000.00,0.00,0.00,0.00,1900.00,'2021-12-04 13:08:57','',''),(2155078,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:08:57','',''),(2155100,'1','151','755',314,'Retail Sale Id 1275785',16000.00,0.00,0.00,0.00,950.00,'2021-12-04 13:10:20','',''),(2155101,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 13:10:20','',''),(2155121,'1','151','755',314,'Retail Sale Id 1275794',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:11:30','',''),(2155122,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:11:30','',''),(2155145,'1','151','755',314,'Retail Sale Id 1275804',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 13:12:57','',''),(2155146,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:12:57','',''),(2155168,'1','151','755',314,'Retail Sale Id 1275813',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 13:14:15','',''),(2155169,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:14:15','',''),(2155197,'1','151','755',314,'Retail Sale Id 1275827',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 13:15:53','',''),(2155198,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:15:53','',''),(2155249,'1','151','755',314,'Retail Sale Id 1275842',16000.00,0.00,0.00,0.00,950.00,'2021-12-04 13:19:46','',''),(2155250,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 13:19:46','',''),(2155286,'1','151','755',314,'Retail Sale Id 1275859',7500.80,0.00,0.00,0.00,445.36,'2021-12-04 13:21:24','',''),(2155287,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-04 13:21:24','',''),(2155311,'1','151','755',314,'Retail Sale Id 1275870',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 13:22:51','',''),(2155312,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 13:22:51','',''),(2155338,'1','151','755',314,'Retail Sale Id 1275878',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 13:24:25','',''),(2155339,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:24:25','',''),(2155444,'1','151','755',314,'Retail Sale Id 1275909',6003.20,0.00,0.00,0.00,356.44,'2021-12-04 13:27:38','',''),(2155445,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 13:27:38','',''),(2155466,'1','151','755',314,'Retail Sale Id 1275918',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 13:29:13','',''),(2155467,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:29:13','',''),(2155504,'1','151','755',314,'Retail Sale Id 1275934',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 13:31:06','',''),(2155505,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 13:31:06','',''),(2155523,'1','151','755',314,'Retail Sale Id 1275947',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 13:32:11','',''),(2155524,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:32:11','',''),(2155541,'1','151','755',314,'Retail Sale Id 1275957',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:33:28','',''),(2155542,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:33:28','',''),(2155561,'1','151','755',314,'Retail Sale Id 1275968',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 13:34:42','',''),(2155562,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:34:42','',''),(2155563,'1','151','755',314,'Retail Sale Id 1275968',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 13:34:42','',''),(2155564,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:34:42','',''),(2155608,'1','151','755',314,'Retail Sale Id 1275988',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 13:37:20','',''),(2155609,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:37:20','',''),(2155610,'1','151','755',314,'Retail Sale Id 1275988',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 13:37:20','',''),(2155611,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:37:20','',''),(2155632,'1','151','755',314,'Retail Sale Id 1275999',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:38:47','',''),(2155633,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:38:47','',''),(2155648,'1','151','755',314,'Retail Sale Id 1276006',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 13:39:42','',''),(2155649,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:39:42','',''),(2155680,'1','151','755',314,'Retail Sale Id 1276022',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 13:41:28','',''),(2155681,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:41:28','',''),(2155708,'1','151','755',314,'Retail Sale Id 1276038',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:42:47','',''),(2155709,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:42:47','',''),(2155784,'1','151','755',314,'Retail Sale Id 1276077',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:46:55','',''),(2155785,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:46:55','',''),(2155824,'1','151','755',314,'Retail Sale Id 1276089',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:48:31','',''),(2155825,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:48:31','',''),(2155872,'1','151','755',314,'Retail Sale Id 1276104',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 13:49:43','',''),(2155873,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 13:49:43','',''),(2155956,'1','151','755',314,'Retail Sale Id 1276148',902.40,0.00,0.00,0.00,53.58,'2021-12-04 13:55:03','',''),(2155957,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-04 13:55:03','',''),(2155976,'1','151','755',314,'Retail Sale Id 1276158',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 13:56:18','',''),(2155977,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:56:18','',''),(2156011,'1','151','755',314,'Retail Sale Id 1276171',652.80,0.00,0.00,0.00,38.76,'2021-12-04 13:57:32','',''),(2156012,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 13:57:32','',''),(2156035,'1','151','755',314,'Retail Sale Id 1276184',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:58:44','',''),(2156036,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:58:44','',''),(2156074,'1','151','755',314,'Retail Sale Id 1276201',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:00:42','',''),(2156075,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:00:42','',''),(2156164,'1','151','755',314,'Retail Sale Id 1276228',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:04:08','',''),(2156165,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:04:08','',''),(2156166,'1','151','755',314,'Retail Sale Id 1276228',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:04:08','',''),(2156167,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:04:08','',''),(2156168,'1','151','755',314,'Retail Sale Id 1276228',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:04:08','',''),(2156169,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:04:08','',''),(2156226,'1','151','755',314,'Retail Sale Id 1276256',652.80,0.00,0.00,0.00,38.76,'2021-12-04 14:05:51','',''),(2156227,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 14:05:51','',''),(2156253,'1','151','755',314,'Retail Sale Id 1276270',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 14:06:58','',''),(2156254,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:06:58','',''),(2156323,'1','151','755',314,'Retail Sale Id 1276310',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:10:45','',''),(2156324,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:10:45','',''),(2156343,'1','151','755',314,'Retail Sale Id 1276321',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 14:11:58','',''),(2156344,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:11:58','',''),(2156377,'1','151','755',314,'Retail Sale Id 1276336',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:13:23','',''),(2156378,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:13:23','',''),(2156416,'1','151','755',314,'Retail Sale Id 1276350',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:14:25','',''),(2156417,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:14:25','',''),(2156446,'1','151','755',314,'Retail Sale Id 1276366',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:15:58','',''),(2156447,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:15:58','',''),(2156476,'1','151','755',314,'Retail Sale Id 1276380',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:17:22','',''),(2156477,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:17:22','',''),(2156542,'1','151','755',314,'Retail Sale Id 1276416',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 14:20:22','',''),(2156543,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 14:20:22','',''),(2156578,'1','151','755',314,'Retail Sale Id 1276439',4499.20,0.00,0.00,0.00,267.14,'2021-12-04 14:22:21','',''),(2156579,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-04 14:22:21','',''),(2156602,'1','151','755',314,'Retail Sale Id 1276450',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 14:23:32','',''),(2156603,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:23:32','',''),(2156641,'1','151','755',314,'Retail Sale Id 1276465',2521.60,0.00,0.00,0.00,149.72,'2021-12-04 14:26:16','',''),(2156642,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.94,0.00,'2021-12-04 14:26:16','',''),(2156703,'1','151','755',314,'Retail Sale Id 1276496',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:30:12','',''),(2156704,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:30:12','',''),(2156733,'1','151','755',314,'Retail Sale Id 1276509',7001.60,0.00,0.00,0.00,415.72,'2021-12-04 14:32:03','',''),(2156734,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 14:32:03','',''),(2156778,'1','151','755',314,'Retail Sale Id 1276525',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 14:34:22','',''),(2156779,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:34:22','',''),(2156780,'1','151','755',314,'Retail Sale Id 1276525',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 14:34:22','',''),(2156781,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:34:22','',''),(2156890,'1','151','755',314,'Retail Sale Id 1276586',2560.00,0.00,0.00,0.00,152.00,'2021-12-04 14:40:27','',''),(2156891,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:40:27','',''),(2156959,'1','151','755',314,'Retail Sale Id 1276603',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 14:43:57','',''),(2156960,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:43:57','',''),(2157030,'1','151','755',314,'Retail Sale Id 1276623',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 14:46:17','',''),(2157031,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 14:46:17','',''),(2157132,'1','151','755',314,'Retail Sale Id 1276665',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:51:30','',''),(2157133,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:51:30','',''),(2157161,'1','151','755',314,'Retail Sale Id 1276677',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:53:19','',''),(2157162,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:53:19','',''),(2157163,'1','151','755',314,'Retail Sale Id 1276677',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 14:53:19','',''),(2157164,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:53:19','',''),(2157183,'1','151','755',314,'Retail Sale Id 1276686',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:54:30','',''),(2157184,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:54:30','',''),(2157242,'1','151','755',314,'Retail Sale Id 1276705',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:56:29','',''),(2157243,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:56:29','',''),(2157283,'1','151','755',314,'Retail Sale Id 1276718',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:58:26','',''),(2157284,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:58:26','',''),(2157316,'1','151','755',314,'Retail Sale Id 1276733',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 14:59:44','',''),(2157317,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:59:44','',''),(2157336,'1','151','755',314,'Retail Sale Id 1276743',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 15:01:20','',''),(2157337,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:01:20','',''),(2157386,'1','151','755',314,'Retail Sale Id 1276759',3801.60,0.00,0.00,0.00,225.72,'2021-12-04 15:03:24','',''),(2157387,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-04 15:03:24','',''),(2157448,'1','151','755',314,'Retail Sale Id 1276794',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 15:07:24','',''),(2157449,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 15:07:24','',''),(2157582,'1','151','755',314,'Retail Sale Id 1276853',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:15:20','',''),(2157583,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:15:20','',''),(2157618,'1','151','755',314,'Retail Sale Id 1276876',2099.20,0.00,0.00,0.00,124.64,'2021-12-04 15:17:32','',''),(2157619,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-04 15:17:32','',''),(2157720,'1','151','755',314,'Retail Sale Id 1276910',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 15:21:31','',''),(2157721,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:21:31','',''),(2157748,'1','151','755',314,'Retail Sale Id 1276927',7001.60,0.00,0.00,0.00,415.72,'2021-12-04 15:23:24','',''),(2157749,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 15:23:24','',''),(2157836,'1','151','755',314,'Retail Sale Id 1276962',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:26:37','',''),(2157837,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:26:37','',''),(2157871,'1','151','755',314,'Retail Sale Id 1276976',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:27:51','',''),(2157872,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:27:51','',''),(2160091,'1','151','755',314,'Retail Sale Id 1278115',299936.00,0.00,0.00,0.00,17808.70,'2021-12-04 17:18:02','',''),(2160092,'1','151','755',314,'Retail sales',0.00,0.00,0.00,468.65,0.00,'2021-12-04 17:18:02','',''),(2160093,'1','151','755',314,'Retail Sale Id 1278115',726624.00,0.00,0.00,0.00,43143.30,'2021-12-04 17:18:02','',''),(2160094,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1135.35,0.00,'2021-12-04 17:18:02','',''),(2160585,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,2193212.42,3643.21,0.00,0.00,'2021-12-04 17:44:25','',''),(2160616,'1','151',NULL,314,'Reception corrector for bridging 126233',0.00,0.00,0.00,3643.21,0.00,'2021-12-04 17:46:17','',''),(2160617,'1','151','755',314,'Received from bridging 126233',0.00,0.00,3643.21,0.00,0.00,'2021-12-04 17:46:17','',''),(2162199,'1','151','755',314,'Retail Sale Id 1278734',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:28:08','',''),(2162200,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:28:09','',''),(2162213,'1','151','755',314,'Retail Sale Id 1278744',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 06:29:59','',''),(2162214,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 06:29:59','',''),(2162340,'1','151','755',314,'Retail Sale Id 1278798',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:39:26','',''),(2162341,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:39:26','',''),(2162350,'1','151','755',314,'Retail Sale Id 1278807',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 06:40:26','',''),(2162351,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:40:26','',''),(2162362,'1','151','755',314,'Retail Sale Id 1278813',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 06:41:16','',''),(2162363,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:41:16','',''),(2162372,'1','151','755',314,'Retail Sale Id 1278818',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:42:04','',''),(2162373,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:42:04','',''),(2162408,'1','151','755',314,'Retail Sale Id 1278831',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 06:43:57','',''),(2162409,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 06:43:57','',''),(2162410,'1','151','755',314,'Retail Sale Id 1278831',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 06:43:57','',''),(2162411,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 06:43:57','',''),(2162458,'1','151','755',314,'Retail Sale Id 1278843',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 06:45:25','',''),(2162459,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:45:25','',''),(2162472,'1','151','755',314,'Retail Sale Id 1278852',32000.00,0.00,0.00,0.00,1900.00,'2021-12-05 06:46:24','',''),(2162473,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 06:46:24','',''),(2162527,'1','151','755',314,'Retail Sale Id 1278876',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 06:50:03','',''),(2162528,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 06:50:03','',''),(2162637,'1','151','755',314,'Retail Sale Id 1278936',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:55:47','',''),(2162638,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:55:47','',''),(2162649,'1','151','755',314,'Retail Sale Id 1278944',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:56:35','',''),(2162650,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:56:35','',''),(2162669,'1','151','755',314,'Retail Sale Id 1278952',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 06:57:27','',''),(2162670,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:57:27','',''),(2162694,'1','151','755',314,'Retail Sale Id 1278965',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 06:59:04','',''),(2162695,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:59:04','',''),(2162710,'1','151','755',314,'Retail Sale Id 1278973',25600.00,0.00,0.00,0.00,1520.00,'2021-12-05 07:00:07','',''),(2162711,'1','151','755',314,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 07:00:07','',''),(2162736,'1','151','755',314,'Retail Sale Id 1278987',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 07:01:56','',''),(2162737,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 07:01:56','',''),(2162746,'1','151','755',314,'Retail Sale Id 1278994',998.40,0.00,0.00,0.00,59.28,'2021-12-05 07:02:43','',''),(2162747,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:02:43','',''),(2162795,'1','151','755',314,'Retail Sale Id 1279015',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 07:04:45','',''),(2162796,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 07:04:45','',''),(2162865,'1','151','755',314,'Retail Sale Id 1279051',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 07:08:55','',''),(2162866,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 07:08:55','',''),(2162959,'1','151','755',314,'Retail Sale Id 1279104',6003.20,0.00,0.00,0.00,356.44,'2021-12-05 07:13:40','',''),(2162960,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 07:13:40','',''),(2162973,'1','151','755',314,'Retail Sale Id 1279110',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 07:14:38','',''),(2162974,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 07:14:39','',''),(2162975,'1','151','755',314,'Retail Sale Id 1279110',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 07:14:39','',''),(2162976,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:14:39','',''),(2163003,'1','151','755',314,'Retail Sale Id 1279128',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 07:16:21','',''),(2163004,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 07:16:21','',''),(2163005,'1','151','755',314,'Retail Sale Id 1279128',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 07:16:21','',''),(2163006,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 07:16:21','',''),(2163068,'1','151','755',314,'Retail Sale Id 1279159',1900.80,0.00,0.00,0.00,112.86,'2021-12-05 07:20:08','',''),(2163069,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 07:20:08','',''),(2163286,'1','151','755',314,'Retail Sale Id 1279316',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 07:34:02','',''),(2163287,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:34:02','',''),(2163356,'1','151','755',314,'Retail Sale Id 1279361',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 07:38:12','',''),(2163357,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:38:12','',''),(2163429,'1','151','755',314,'Retail Sale Id 1279399',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 07:41:21','',''),(2163430,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:41:21','',''),(2163443,'1','151','755',314,'Retail Sale Id 1279408',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 07:42:42','',''),(2163444,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:42:42','',''),(2163473,'1','151','755',314,'Retail Sale Id 1279421',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 07:44:23','',''),(2163474,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:44:23','',''),(2163501,'1','151','755',314,'Retail Sale Id 1279438',3897.60,0.00,0.00,0.00,231.42,'2021-12-05 07:46:23','',''),(2163502,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:46:23','',''),(2163536,'1','151','755',314,'Retail Sale Id 1279458',1900.80,0.00,0.00,0.00,112.86,'2021-12-05 07:47:53','',''),(2163537,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 07:47:53','',''),(2163600,'1','151','755',314,'Retail Sale Id 1279485',3897.60,0.00,0.00,0.00,231.42,'2021-12-05 07:51:07','',''),(2163601,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:51:07','',''),(2163629,'1','151','755',314,'Retail Sale Id 1279495',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 07:51:55','',''),(2163630,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:51:55','',''),(2163738,'1','151','755',314,'Retail Sale Id 1279551',1932.80,0.00,0.00,0.00,114.76,'2021-12-05 07:58:47','',''),(2163739,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-05 07:58:47','',''),(2163750,'1','151','755',314,'Retail Sale Id 1279561',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 07:59:40','',''),(2163751,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 07:59:40','',''),(2163884,'1','151','755',314,'Retail Sale Id 1279637',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:06:27','',''),(2163885,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:06:27','',''),(2164056,'1','151','755',314,'Retail Sale Id 1279746',601.60,0.00,0.00,0.00,35.72,'2021-12-05 08:15:26','',''),(2164057,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-05 08:15:26','',''),(2164096,'1','151','755',314,'Retail Sale Id 1279766',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 08:17:53','',''),(2164097,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:17:53','',''),(2164132,'1','151','755',314,'Retail Sale Id 1279782',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 08:18:56','',''),(2164133,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:18:56','',''),(2164160,'1','151','755',314,'Retail Sale Id 1279796',998.40,0.00,0.00,0.00,59.28,'2021-12-05 08:20:35','',''),(2164161,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:20:35','',''),(2164180,'1','151','755',314,'Retail Sale Id 1279808',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:21:36','',''),(2164181,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:21:36','',''),(2164198,'1','151','755',314,'Retail Sale Id 1279819',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 08:22:34','',''),(2164199,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:22:34','',''),(2164274,'1','151','755',314,'Retail Sale Id 1279844',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:25:12','',''),(2164275,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:25:12','',''),(2164300,'1','151','755',314,'Retail Sale Id 1279862',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 08:26:20','',''),(2164301,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:26:20','',''),(2164362,'1','151','755',314,'Retail Sale Id 1279905',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 08:29:18','',''),(2164363,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:29:18','',''),(2164436,'1','151','755',314,'Retail Sale Id 1279939',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 08:32:55','',''),(2164437,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:32:55','',''),(2164456,'1','151','755',314,'Retail Sale Id 1279948',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:33:57','',''),(2164457,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:33:57','',''),(2164538,'1','151','755',314,'Retail Sale Id 1280000',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 08:38:26','',''),(2164539,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 08:38:26','',''),(2164586,'1','151','755',314,'Retail Sale Id 1280021',3852.80,0.00,0.00,0.00,228.76,'2021-12-05 08:41:41','',''),(2164587,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 08:41:41','',''),(2164741,'1','151','755',314,'Retail Sale Id 1280084',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:49:17','',''),(2164742,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:49:17','',''),(2164799,'1','151','755',314,'Retail Sale Id 1280117',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:52:43','',''),(2164800,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:52:43','',''),(2164847,'1','151','755',314,'Retail Sale Id 1280142',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:55:07','',''),(2164848,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:55:07','',''),(2164916,'1','151','755',314,'Retail Sale Id 1280185',697.60,0.00,0.00,0.00,41.42,'2021-12-05 08:59:19','',''),(2164917,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 08:59:19','',''),(2164957,'1','151','755',314,'Retail Sale Id 1280205',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:01:43','',''),(2164958,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:01:43','',''),(2165011,'1','151','755',314,'Retail Sale Id 1280231',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 09:04:29','',''),(2165012,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:04:29','',''),(2165043,'1','151','755',314,'Retail Sale Id 1280249',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 09:06:20','',''),(2165044,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:06:20','',''),(2165075,'1','151','755',314,'Retail Sale Id 1280265',1952.00,0.00,0.00,0.00,115.90,'2021-12-05 09:07:43','',''),(2165076,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:07:43','',''),(2165152,'1','151','755',314,'Retail Sale Id 1280309',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 09:10:55','',''),(2165153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 09:10:55','',''),(2165183,'1','151','755',314,'Retail Sale Id 1280321',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:12:28','',''),(2165184,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:12:28','',''),(2165211,'1','151','755',314,'Retail Sale Id 1280339',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:13:52','',''),(2165212,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:13:52','',''),(2165308,'1','151','755',314,'Retail Sale Id 1280420',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:20:34','',''),(2165309,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:20:34','',''),(2165310,'1','151','755',314,'Retail Sale Id 1280420',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:20:34','',''),(2165311,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:20:34','',''),(2165438,'1','151','755',314,'Retail Sale Id 1280494',4198.40,0.00,0.00,0.00,249.28,'2021-12-05 09:28:00','',''),(2165439,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.56,0.00,'2021-12-05 09:28:00','',''),(2165456,'1','151','755',314,'Retail Sale Id 1280506',1798.40,0.00,0.00,0.00,106.78,'2021-12-05 09:29:10','',''),(2165457,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 09:29:10','',''),(2165484,'1','151','755',314,'Retail Sale Id 1280519',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 09:30:08','',''),(2165485,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:30:08','',''),(2165504,'1','151','755',314,'Retail Sale Id 1280535',2502.40,0.00,0.00,0.00,148.58,'2021-12-05 09:31:10','',''),(2165505,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 09:31:10','',''),(2165672,'1','151','755',314,'Retail Sale Id 1280619',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 09:40:03','',''),(2165673,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 09:40:03','',''),(2165735,'1','151','755',314,'Retail Sale Id 1280651',652.80,0.00,0.00,0.00,38.76,'2021-12-05 09:42:54','',''),(2165736,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 09:42:54','',''),(2165826,'1','151','755',314,'Retail Sale Id 1280681',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 09:46:01','',''),(2165827,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 09:46:01','',''),(2165878,'1','151','755',314,'Retail Sale Id 1280696',998.40,0.00,0.00,0.00,59.28,'2021-12-05 09:47:03','',''),(2165879,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:47:03','',''),(2165941,'1','151','755',314,'Retail Sale Id 1280724',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:49:47','',''),(2165942,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:49:47','',''),(2165987,'1','151','755',314,'Retail Sale Id 1280751',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:53:13','',''),(2165988,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:53:13','',''),(2165989,'1','151','755',314,'Retail Sale Id 1280751',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:53:13','',''),(2165990,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:53:13','',''),(2165991,'1','151','755',314,'Retail Sale Id 1280751',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 09:53:13','',''),(2165992,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:53:13','',''),(2166179,'1','151','755',314,'Retail Sale Id 1280850',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 10:04:19','',''),(2166180,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:04:19','',''),(2166199,'1','151','755',314,'Retail Sale Id 1280860',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 10:05:35','',''),(2166200,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:05:35','',''),(2166241,'1','151','755',314,'Retail Sale Id 1280882',32000.00,0.00,0.00,0.00,1900.00,'2021-12-05 10:09:03','',''),(2166242,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 10:09:03','',''),(2166271,'1','151','755',314,'Retail Sale Id 1280896',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 10:11:09','',''),(2166272,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:11:09','',''),(2166291,'1','151','755',314,'Retail Sale Id 1280907',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:12:19','',''),(2166292,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:12:19','',''),(2166379,'1','151','755',314,'Retail Sale Id 1280954',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 10:18:02','',''),(2166380,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 10:18:02','',''),(2166381,'1','151','755',314,'Retail Sale Id 1280954',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 10:18:02','',''),(2166382,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 10:18:02','',''),(2166391,'1','151','755',314,'Retail Sale Id 1280959',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:19:02','',''),(2166392,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:19:02','',''),(2166423,'1','151','755',314,'Retail Sale Id 1280975',2700.80,0.00,0.00,0.00,160.36,'2021-12-05 10:21:00','',''),(2166424,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-05 10:21:00','',''),(2166453,'1','151','755',314,'Retail Sale Id 1280991',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:22:35','',''),(2166454,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:22:35','',''),(2166455,'1','151','755',314,'Retail Sale Id 1280991',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 10:22:35','',''),(2166456,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:22:35','',''),(2166483,'1','151','755',314,'Retail Sale Id 1281006',998.40,0.00,0.00,0.00,59.28,'2021-12-05 10:24:44','',''),(2166484,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:24:44','',''),(2166558,'1','151','755',314,'Retail Sale Id 1281043',998.40,0.00,0.00,0.00,59.28,'2021-12-05 10:29:24','',''),(2166559,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:29:24','',''),(2166590,'1','151','755',314,'Retail Sale Id 1281059',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 10:31:18','',''),(2166591,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 10:31:18','',''),(2166650,'1','151','755',314,'Retail Sale Id 1281091',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 10:35:14','',''),(2166651,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:35:14','',''),(2166670,'1','151','755',314,'Retail Sale Id 1281103',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 10:36:13','',''),(2166671,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:36:13','',''),(2167647,'1','151','755',314,'Retail Sale Id 1281610',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 11:31:57','',''),(2167648,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:31:57','',''),(2167683,'1','151','755',314,'Retail Sale Id 1281621',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 11:32:46','',''),(2167684,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:32:46','',''),(2167713,'1','151','755',314,'Retail Sale Id 1281636',1900.80,0.00,0.00,0.00,112.86,'2021-12-05 11:35:16','',''),(2167714,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 11:35:16','',''),(2167783,'1','151','755',314,'Retail Sale Id 1281674',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:39:36','',''),(2167784,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:39:36','',''),(2167808,'1','151','755',314,'Retail Sale Id 1281694',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 11:41:55','',''),(2167809,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:41:55','',''),(2167862,'1','151','755',314,'Retail Sale Id 1281758',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 11:45:37','',''),(2167863,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:45:37','',''),(2167883,'1','151','755',314,'Retail Sale Id 1281767',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 11:46:36','',''),(2167884,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:46:36','',''),(2167915,'1','151','755',314,'Retail Sale Id 1281783',3852.80,0.00,0.00,0.00,228.76,'2021-12-05 11:48:04','',''),(2167916,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 11:48:04','',''),(2167961,'1','151','755',314,'Retail Sale Id 1281817',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 11:51:03','',''),(2167963,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:51:03','',''),(2167988,'1','151','755',314,'Retail Sale Id 1281832',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:52:21','',''),(2167989,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:52:21','',''),(2167990,'1','151','755',314,'Retail Sale Id 1281832',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 11:52:21','',''),(2167991,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:52:21','',''),(2167992,'1','151','755',314,'Retail Sale Id 1281832',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 11:52:21','',''),(2167993,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:52:21','',''),(2168032,'1','151','755',314,'Retail Sale Id 1281852',2502.40,0.00,0.00,0.00,148.58,'2021-12-05 11:54:52','',''),(2168033,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 11:54:52','',''),(2168052,'1','151','755',314,'Retail Sale Id 1281863',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 11:56:02','',''),(2168053,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:56:02','',''),(2168075,'1','151','755',314,'Retail Sale Id 1281876',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 11:57:19','',''),(2168076,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:57:19','',''),(2168152,'1','151','755',314,'Retail Sale Id 1281916',6003.20,0.00,0.00,0.00,356.44,'2021-12-05 12:01:47','',''),(2168153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 12:01:47','',''),(2168210,'1','151','755',314,'Retail Sale Id 1281946',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:05:18','',''),(2168211,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:05:18','',''),(2168212,'1','151','755',314,'Retail Sale Id 1281946',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:05:18','',''),(2168213,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:05:18','',''),(2168214,'1','151','755',314,'Retail Sale Id 1281946',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:05:18','',''),(2168215,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:05:18','',''),(2168216,'1','151','755',314,'Retail Sale Id 1281946',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:05:18','',''),(2168217,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:05:18','',''),(2168218,'1','151','755',314,'Retail Sale Id 1281946',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:05:18','',''),(2168219,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:05:18','',''),(2168234,'1','151','755',314,'Retail Sale Id 1281956',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:06:13','',''),(2168235,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:06:13','',''),(2168279,'1','151','755',314,'Retail Sale Id 1281983',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 12:08:21','',''),(2168280,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 12:08:21','',''),(2168354,'1','151','755',314,'Retail Sale Id 1282021',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 12:12:34','',''),(2168355,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:12:34','',''),(2168450,'1','151','755',314,'Retail Sale Id 1282064',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:16:10','',''),(2168451,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:16:10','',''),(2168472,'1','151','755',314,'Retail Sale Id 1282075',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:17:03','',''),(2168473,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:17:03','',''),(2168504,'1','151','755',314,'Retail Sale Id 1282088',1203.20,0.00,0.00,0.00,71.44,'2021-12-05 12:18:14','',''),(2168505,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-05 12:18:14','',''),(2168524,'1','151','755',314,'Retail Sale Id 1282096',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:19:05','',''),(2168525,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:19:05','',''),(2168601,'1','151','755',314,'Retail Sale Id 1282136',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:22:11','',''),(2168602,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:22:11','',''),(2168625,'1','151','755',314,'Retail Sale Id 1282151',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:23:34','',''),(2168626,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:23:34','',''),(2168654,'1','151','755',314,'Retail Sale Id 1282161',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 12:24:20','',''),(2168655,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:24:20','',''),(2168676,'1','151','755',314,'Retail Sale Id 1282170',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:25:06','',''),(2168677,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:25:06','',''),(2168700,'1','151','755',314,'Retail Sale Id 1282183',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:26:09','',''),(2168701,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:26:09','',''),(2168726,'1','151','755',314,'Retail Sale Id 1282198',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:26:56','',''),(2168727,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:26:56','',''),(2168744,'1','151','755',314,'Retail Sale Id 1282208',998.40,0.00,0.00,0.00,59.28,'2021-12-05 12:27:45','',''),(2168745,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:27:45','',''),(2168931,'1','151','755',314,'Retail Sale Id 1282305',8998.40,0.00,0.00,0.00,534.28,'2021-12-05 12:37:48','',''),(2168932,'1','151','755',314,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-05 12:37:48','',''),(2168933,'1','151','755',314,'Retail Sale Id 1282305',8998.40,0.00,0.00,0.00,534.28,'2021-12-05 12:37:48','',''),(2168934,'1','151','755',314,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-05 12:37:48','',''),(2169075,'1','151','755',314,'Retail Sale Id 1282383',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 12:45:19','',''),(2169076,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:45:19','',''),(2169105,'1','151','755',314,'Retail Sale Id 1282403',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 12:47:06','',''),(2169106,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:47:06','',''),(2169197,'1','151','755',314,'Retail Sale Id 1282460',3500.80,0.00,0.00,0.00,207.86,'2021-12-05 12:53:52','',''),(2169198,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 12:53:52','',''),(2169224,'1','151','755',314,'Retail Sale Id 1282479',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 12:54:51','',''),(2169226,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:54:51','',''),(2169341,'1','151','755',314,'Retail Sale Id 1282530',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:00:34','',''),(2169342,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:00:34','',''),(2169405,'1','151','755',314,'Retail Sale Id 1282563',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 13:03:35','',''),(2169406,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:03:35','',''),(2169451,'1','151','755',314,'Retail Sale Id 1282597',3500.80,0.00,0.00,0.00,207.86,'2021-12-05 13:06:19','',''),(2169452,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 13:06:19','',''),(2169467,'1','151','755',314,'Retail Sale Id 1282622',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 13:07:18','',''),(2169468,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:07:18','',''),(2169550,'1','151','755',314,'Retail Sale Id 1282659',24000.00,0.00,0.00,0.00,1425.00,'2021-12-05 13:11:34','',''),(2169551,'1','151','755',314,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-05 13:11:34','',''),(2169582,'1','151','755',314,'Retail Sale Id 1282679',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 13:13:56','',''),(2169583,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:13:56','',''),(2169672,'1','151','755',314,'Retail Sale Id 1282717',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 13:19:11','',''),(2169673,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 13:19:11','',''),(2169700,'1','151','755',314,'Retail Sale Id 1282733',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:21:05','',''),(2169701,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:21:05','',''),(2169746,'1','151','755',314,'Retail Sale Id 1282762',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 13:24:03','',''),(2169747,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:24:03','',''),(2169756,'1','151','755',314,'Retail Sale Id 1282765',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:24:55','',''),(2169757,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:24:55','',''),(2169776,'1','151','755',314,'Retail Sale Id 1282777',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 13:25:37','',''),(2169777,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:25:37','',''),(2169849,'1','151','755',314,'Retail Sale Id 1282806',6003.20,0.00,0.00,0.00,356.44,'2021-12-05 13:29:11','',''),(2169850,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 13:29:11','',''),(2169861,'1','151','755',314,'Retail Sale Id 1282813',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:29:56','',''),(2169862,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:29:56','',''),(2169907,'1','151','755',314,'Retail Sale Id 1282832',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 13:32:03','',''),(2169908,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:32:03','',''),(2169939,'1','151','755',314,'Retail Sale Id 1282845',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:34:11','',''),(2169940,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:34:11','',''),(2169941,'1','151','755',314,'Retail Sale Id 1282845',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:34:11','',''),(2169942,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:34:11','',''),(2170269,'1','151','755',314,'Retail Sale Id 1282978',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 13:50:53','',''),(2170270,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:50:53','',''),(2170318,'1','151','755',314,'Retail Sale Id 1282990',2700.80,0.00,0.00,0.00,160.36,'2021-12-05 13:52:27','',''),(2170319,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-05 13:52:27','',''),(2170328,'1','151','755',314,'Retail Sale Id 1282997',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:53:17','',''),(2170329,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:53:17','',''),(2170344,'1','151','755',314,'Retail Sale Id 1283007',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 13:54:20','',''),(2170345,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:54:20','',''),(2170358,'1','151','755',314,'Retail Sale Id 1283015',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:55:07','',''),(2170359,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:55:07','',''),(2170378,'1','151','755',314,'Retail Sale Id 1283022',2502.40,0.00,0.00,0.00,148.58,'2021-12-05 13:56:05','',''),(2170379,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 13:56:05','',''),(2170419,'1','151','755',314,'Retail Sale Id 1283033',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 13:57:27','',''),(2170420,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:57:27','',''),(2170437,'1','151','755',314,'Retail Sale Id 1283041',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:58:26','',''),(2170438,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:58:26','',''),(2170459,'1','151','755',314,'Retail Sale Id 1283050',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 13:59:30','',''),(2170460,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:59:30','',''),(2170471,'1','151','755',314,'Retail Sale Id 1283055',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:00:32','',''),(2170472,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:00:32','',''),(2170497,'1','151','755',314,'Retail Sale Id 1283070',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 14:02:26','',''),(2170498,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 14:02:26','',''),(2170513,'1','151','755',314,'Retail Sale Id 1283079',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:03:25','',''),(2170514,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:03:25','',''),(2170567,'1','151','755',314,'Retail Sale Id 1283107',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:07:08','',''),(2170568,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:07:08','',''),(2170579,'1','151','755',314,'Retail Sale Id 1283113',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 14:08:03','',''),(2170580,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:08:03','',''),(2170612,'1','151','755',314,'Retail Sale Id 1283128',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:09:41','',''),(2170613,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:09:41','',''),(2170650,'1','151','755',314,'Retail Sale Id 1283145',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 14:11:42','',''),(2170651,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:11:42','',''),(2170665,'1','151','755',314,'Retail Sale Id 1283153',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:12:44','',''),(2170666,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:12:44','',''),(2170681,'1','151','755',314,'Retail Sale Id 1283160',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 14:13:41','',''),(2170682,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:13:41','',''),(2170705,'1','151','755',314,'Retail Sale Id 1283164',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:14:33','',''),(2170706,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:14:33','',''),(2170727,'1','151','755',314,'Retail Sale Id 1283176',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 14:15:21','',''),(2170728,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:15:21','',''),(2170769,'1','151','755',314,'Retail Sale Id 1283184',499.20,0.00,0.00,0.00,29.64,'2021-12-05 14:16:20','',''),(2170770,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 14:16:20','',''),(2170798,'1','151','755',314,'Retail Sale Id 1283195',998.40,0.00,0.00,0.00,59.28,'2021-12-05 14:17:18','',''),(2170799,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:17:18','',''),(2170816,'1','151','755',314,'Retail Sale Id 1283201',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:18:22','',''),(2170817,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:18:22','',''),(2170863,'1','151','755',314,'Retail Sale Id 1283219',697.60,0.00,0.00,0.00,41.42,'2021-12-05 14:20:03','',''),(2170864,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 14:20:03','',''),(2170875,'1','151','755',314,'Retail Sale Id 1283227',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 14:20:58','',''),(2170876,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:20:58','',''),(2170951,'1','151','755',314,'Retail Sale Id 1283263',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 14:26:07','',''),(2170952,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:26:07','',''),(2170965,'1','151','755',314,'Retail Sale Id 1283271',5401.60,0.00,0.00,0.00,320.72,'2021-12-05 14:27:11','',''),(2170966,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.44,0.00,'2021-12-05 14:27:11','',''),(2170981,'1','151','755',314,'Retail Sale Id 1283280',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:28:20','',''),(2170982,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:28:20','',''),(2170999,'1','151','755',314,'Retail Sale Id 1283289',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:29:21','',''),(2171000,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:29:21','',''),(2171052,'1','151','755',314,'Retail Sale Id 1283304',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 14:31:19','',''),(2171053,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:31:19','',''),(2171137,'1','151','755',314,'Retail Sale Id 1283329',2560.00,0.00,0.00,0.00,152.00,'2021-12-05 14:35:01','',''),(2171138,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 14:35:01','',''),(2171185,'1','151','755',314,'Retail Sale Id 1283336',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 14:36:45','',''),(2171186,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 14:36:45','',''),(2171187,'1','151','755',314,'Retail Sale Id 1283336',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 14:36:45','',''),(2171188,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 14:36:45','',''),(2171205,'1','151','755',314,'Retail Sale Id 1283345',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:38:16','',''),(2171206,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:38:16','',''),(2171235,'1','151','755',314,'Retail Sale Id 1283361',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:40:02','',''),(2171236,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:40:02','',''),(2171249,'1','151','755',314,'Retail Sale Id 1283369',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:41:18','',''),(2171250,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:41:18','',''),(2171275,'1','151','755',314,'Retail Sale Id 1283377',998.40,0.00,0.00,0.00,59.28,'2021-12-05 14:42:30','',''),(2171276,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:42:30','',''),(2171312,'1','151','755',314,'Retail Sale Id 1283387',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 14:44:18','',''),(2171313,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:44:18','',''),(2171355,'1','151','755',314,'Retail Sale Id 1283404',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 14:46:42','',''),(2171356,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 14:46:42','',''),(2171363,'1','151','755',314,'Retail Sale Id 1283408',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:47:36','',''),(2171364,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:47:36','',''),(2171405,'1','151','755',314,'Retail Sale Id 1283426',998.40,0.00,0.00,0.00,59.28,'2021-12-05 14:50:05','',''),(2171406,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:50:05','',''),(2171417,'1','151','755',314,'Retail Sale Id 1283433',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 14:50:59','',''),(2171418,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 14:50:59','',''),(2171505,'1','151','755',314,'Retail Sale Id 1283479',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 14:56:53','',''),(2171506,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 14:56:53','',''),(2171555,'1','151','755',314,'Retail Sale Id 1283504',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:00:31','',''),(2171556,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:00:31','',''),(2171577,'1','151','755',314,'Retail Sale Id 1283515',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 15:02:43','',''),(2171578,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:02:43','',''),(2171623,'1','151','755',314,'Retail Sale Id 1283539',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 15:06:31','',''),(2171624,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 15:06:31','',''),(2171637,'1','151','755',314,'Retail Sale Id 1283547',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 15:07:58','',''),(2171638,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:07:58','',''),(2171657,'1','151','755',314,'Retail Sale Id 1283557',6003.20,0.00,0.00,0.00,356.44,'2021-12-05 15:09:22','',''),(2171658,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 15:09:22','',''),(2171689,'1','151','755',314,'Retail Sale Id 1283572',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:12:05','',''),(2171690,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:12:05','',''),(2171701,'1','151','755',314,'Retail Sale Id 1283579',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 15:13:04','',''),(2171702,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:13:04','',''),(2171727,'1','151','755',314,'Retail Sale Id 1283595',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:15:33','',''),(2171728,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:15:33','',''),(2171818,'1','151','755',314,'Retail Sale Id 1283636',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 15:21:31','',''),(2171819,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:21:31','',''),(2171842,'1','151','755',314,'Retail Sale Id 1283649',3852.80,0.00,0.00,0.00,228.76,'2021-12-05 15:22:57','',''),(2171843,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 15:22:57','',''),(2171856,'1','151','755',314,'Retail Sale Id 1283656',998.40,0.00,0.00,0.00,59.28,'2021-12-05 15:23:36','',''),(2171857,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:23:36','',''),(2171868,'1','151','755',314,'Retail Sale Id 1283663',1900.80,0.00,0.00,0.00,112.86,'2021-12-05 15:24:50','',''),(2171869,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 15:24:50','',''),(2171882,'1','151','755',314,'Retail Sale Id 1283670',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:25:52','',''),(2171883,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:25:52','',''),(2171890,'1','151','755',314,'Retail Sale Id 1283675',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:26:42','',''),(2171891,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:26:42','',''),(2171900,'1','151','755',314,'Retail Sale Id 1283680',1299.20,0.00,0.00,0.00,77.14,'2021-12-05 15:27:32','',''),(2171901,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 15:27:32','',''),(2171914,'1','151','755',314,'Retail Sale Id 1283687',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:28:36','',''),(2171915,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:28:36','',''),(2171924,'1','151','755',314,'Retail Sale Id 1283696',998.40,0.00,0.00,0.00,59.28,'2021-12-05 15:29:19','',''),(2171925,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:29:19','',''),(2171958,'1','151','755',314,'Retail Sale Id 1283709',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:30:37','',''),(2171959,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:30:37','',''),(2171995,'1','151','755',314,'Retail Sale Id 1283722',3897.60,0.00,0.00,0.00,231.42,'2021-12-05 15:31:57','',''),(2171996,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 15:31:57','',''),(2172020,'1','151','755',314,'Retail Sale Id 1283727',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 15:32:44','',''),(2172021,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:32:44','',''),(2172040,'1','151','755',314,'Retail Sale Id 1283738',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:33:56','',''),(2172041,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:33:56','',''),(2172058,'1','151','755',314,'Retail Sale Id 1283750',3001.60,0.00,0.00,0.00,178.22,'2021-12-05 15:34:59','',''),(2172059,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:34:59','',''),(2172080,'1','151','755',314,'Retail Sale Id 1283760',5497.60,0.00,0.00,0.00,326.42,'2021-12-05 15:36:35','',''),(2172081,'1','151','755',314,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-05 15:36:35','',''),(2172165,'1','151','755',314,'Retail Sale Id 1283807',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 15:40:49','',''),(2172166,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 15:40:49','',''),(2172193,'1','151','755',314,'Retail Sale Id 1283818',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 15:41:49','',''),(2172194,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:41:49','',''),(2172235,'1','151','755',314,'Retail Sale Id 1283841',7001.60,0.00,0.00,0.00,415.72,'2021-12-05 15:43:37','',''),(2172236,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 15:43:37','',''),(2172261,'1','151','755',314,'Retail Sale Id 1283862',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:45:09','',''),(2172262,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:45:09','',''),(2172317,'1','151','755',314,'Retail Sale Id 1283886',3852.80,0.00,0.00,0.00,228.76,'2021-12-05 15:47:15','',''),(2172318,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 15:47:15','',''),(2172339,'1','151','755',314,'Retail Sale Id 1283900',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 15:48:42','',''),(2172340,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:48:42','',''),(2172361,'1','151','755',314,'Retail Sale Id 1283911',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:49:40','',''),(2172362,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:49:40','',''),(2172457,'1','151','755',314,'Retail Sale Id 1283964',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 15:55:30','',''),(2172458,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 15:55:30','',''),(2172486,'1','151','755',314,'Retail Sale Id 1283979',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 15:57:32','',''),(2172487,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:57:32','',''),(2172506,'1','151','755',314,'Retail Sale Id 1283989',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 15:58:43','',''),(2172507,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:58:43','',''),(2172528,'1','151','755',314,'Retail Sale Id 1283999',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 15:59:43','',''),(2172529,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 15:59:43','',''),(2172550,'1','151','755',314,'Retail Sale Id 1284011',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:01:14','',''),(2172551,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:01:14','',''),(2172552,'1','151','755',314,'Retail Sale Id 1284011',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:01:14','',''),(2172553,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:01:14','',''),(2172554,'1','151','755',314,'Retail Sale Id 1284011',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:01:14','',''),(2172555,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:01:14','',''),(2172626,'1','151','755',314,'Retail Sale Id 1284052',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 16:05:54','',''),(2172627,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 16:05:54','',''),(2172654,'1','151','755',314,'Retail Sale Id 1284065',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 16:07:43','',''),(2172655,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:07:43','',''),(2172670,'1','151','755',314,'Retail Sale Id 1284077',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 16:08:38','',''),(2172671,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 16:08:38','',''),(2172672,'1','151','755',314,'Retail Sale Id 1284077',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:08:38','',''),(2172673,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:08:38','',''),(2172684,'1','151','755',314,'Retail Sale Id 1284081',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:09:23','',''),(2172685,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:09:23','',''),(2172740,'1','151','755',314,'Retail Sale Id 1284107',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:12:58','',''),(2172741,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:12:58','',''),(2172742,'1','151','755',314,'Retail Sale Id 1284107',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 16:12:58','',''),(2172743,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:12:58','',''),(2172754,'1','151','755',314,'Retail Sale Id 1284115',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 16:13:43','',''),(2172755,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:13:43','',''),(2172772,'1','151','755',314,'Retail Sale Id 1284122',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 16:14:52','',''),(2172773,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:14:52','',''),(2172784,'1','151','755',314,'Retail Sale Id 1284128',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 16:16:01','',''),(2172785,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:16:01','',''),(2172804,'1','151','755',314,'Retail Sale Id 1284142',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 16:17:29','',''),(2172805,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 16:17:29','',''),(2172814,'1','151','755',314,'Retail Sale Id 1284144',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 16:18:18','',''),(2172815,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:18:18','',''),(2172824,'1','151','755',314,'Retail Sale Id 1284150',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 16:19:01','',''),(2172825,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:19:01','',''),(2172854,'1','151','755',314,'Retail Sale Id 1284171',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:20:40','',''),(2172855,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:20:40','',''),(2172870,'1','151','755',314,'Retail Sale Id 1284180',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:21:34','',''),(2172871,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:21:34','',''),(2172924,'1','151','755',314,'Retail Sale Id 1284207',3897.60,0.00,0.00,0.00,231.42,'2021-12-05 16:24:27','',''),(2172925,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 16:24:27','',''),(2172961,'1','151','755',314,'Retail Sale Id 1284230',3801.60,0.00,0.00,0.00,225.72,'2021-12-05 16:27:29','',''),(2172962,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 16:27:29','',''),(2172993,'1','151','755',314,'Retail Sale Id 1284249',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 16:29:44','',''),(2172994,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:29:44','',''),(2173009,'1','151','755',314,'Retail Sale Id 1284259',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:31:19','',''),(2173010,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:31:19','',''),(2173111,'1','151','755',314,'Retail Sale Id 1284306',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:36:22','',''),(2173112,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:36:22','',''),(2173143,'1','151','755',314,'Retail Sale Id 1284321',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 16:38:03','',''),(2173144,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:38:03','',''),(2173163,'1','151','755',314,'Retail Sale Id 1284335',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:39:02','',''),(2173164,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:39:02','',''),(2173183,'1','151','755',314,'Retail Sale Id 1284346',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 16:40:17','',''),(2173184,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:40:17','',''),(2173185,'1','151','755',314,'Retail Sale Id 1284346',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 16:40:17','',''),(2173186,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:40:17','',''),(2173215,'1','151','755',314,'Retail Sale Id 1284361',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 16:42:19','',''),(2173216,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:42:19','',''),(2173229,'1','151','755',314,'Retail Sale Id 1284370',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:43:10','',''),(2173230,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:43:10','',''),(2173247,'1','151','755',314,'Retail Sale Id 1284377',2502.40,0.00,0.00,0.00,148.58,'2021-12-05 16:44:16','',''),(2173248,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 16:44:16','',''),(2173327,'1','151','755',314,'Retail Sale Id 1284418',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:49:34','',''),(2173328,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:49:34','',''),(2173367,'1','151','755',314,'Retail Sale Id 1284438',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 16:52:11','',''),(2173368,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:52:11','',''),(2173385,'1','151','755',314,'Retail Sale Id 1284448',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 16:53:05','',''),(2173386,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:53:05','',''),(2173431,'1','151','755',314,'Retail Sale Id 1284472',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:56:14','',''),(2173432,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:56:14','',''),(2173449,'1','151','755',314,'Retail Sale Id 1284484',2003.20,0.00,0.00,0.00,118.94,'2021-12-05 16:57:02','',''),(2173450,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:57:02','',''),(2173489,'1','151','755',314,'Retail Sale Id 1284505',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 17:00:03','',''),(2173490,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 17:00:03','',''),(2173680,'1','151','755',314,'Retail Sale Id 1284583',3897.60,0.00,0.00,0.00,231.42,'2021-12-05 17:12:34','',''),(2173681,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 17:12:34','',''),(2173684,'1','151','755',314,'Retail Sale Id 1284585',1900.80,0.00,0.00,0.00,112.86,'2021-12-05 17:13:10','',''),(2173685,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 17:13:10','',''),(2173700,'1','151','755',314,'Retail Sale Id 1284594',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 17:14:41','',''),(2173701,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:14:41','',''),(2173702,'1','151','755',314,'Retail Sale Id 1284594',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 17:14:41','',''),(2173703,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:14:41','',''),(2173704,'1','151','755',314,'Retail Sale Id 1284594',4000.00,0.00,0.00,0.00,237.50,'2021-12-05 17:14:41','',''),(2173705,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:14:41','',''),(2173726,'1','151','755',314,'Retail Sale Id 1284609',8998.40,0.00,0.00,0.00,534.28,'2021-12-05 17:17:23','',''),(2173727,'1','151','755',314,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-05 17:17:23','',''),(2174248,'1','151','755',314,'Retail Sale Id 1284844',226905.60,0.00,0.00,0.00,13472.52,'2021-12-05 18:47:57','',''),(2174249,'1','151','755',314,'Retail sales',0.00,0.00,0.00,354.54,0.00,'2021-12-05 18:47:57','',''),(2174252,'1','151','755',314,'Retail Sale Id 1284846',112012.80,0.00,0.00,0.00,6650.76,'2021-12-05 18:49:43','',''),(2174253,'1','151','755',314,'Retail sales',0.00,0.00,0.00,175.02,0.00,'2021-12-05 18:49:43','',''),(2174689,'1','151','755',314,'Retail Sale Id 1284883',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 05:30:19','',''),(2174690,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 05:30:19','',''),(2174706,'1','151','755',314,'Retail Sale Id 1284885',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 05:32:55','',''),(2174707,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 05:32:55','',''),(2174728,'1','151','755',314,'Retail Sale Id 1284886',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 05:34:40','',''),(2174729,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 05:34:40','',''),(2174743,'1','151','755',314,'Retail Sale Id 1284887',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 05:35:51','',''),(2174744,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 05:35:51','',''),(2174852,'1','151','755',314,'Retail Sale Id 1284930',4300.80,0.00,0.00,0.00,255.36,'2021-12-06 06:14:06','',''),(2174853,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.72,0.00,'2021-12-06 06:14:06','',''),(2174917,'1','151','755',314,'Retail Sale Id 1284970',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 06:25:50','',''),(2174918,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:25:50','',''),(2175091,'1','151','755',314,'Retail Sale Id 1285022',998.40,0.00,0.00,0.00,59.28,'2021-12-06 06:40:29','',''),(2175092,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:40:29','',''),(2175093,'1','151','755',314,'Retail Sale Id 1285022',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 06:40:29','',''),(2175094,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:40:29','',''),(2175127,'1','151','755',314,'Retail Sale Id 1285040',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 06:44:57','',''),(2175128,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:44:57','',''),(2175165,'1','151','755',314,'Retail Sale Id 1285059',16000.00,0.00,0.00,0.00,950.00,'2021-12-06 06:47:26','',''),(2175166,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 06:47:26','',''),(2175240,'1','151','755',314,'Retail Sale Id 1285102',998.40,0.00,0.00,0.00,59.28,'2021-12-06 06:53:26','',''),(2175241,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:53:26','',''),(2175262,'1','151','755',314,'Retail Sale Id 1285113',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 06:55:11','',''),(2175263,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:55:11','',''),(2175264,'1','151','755',314,'Retail Sale Id 1285113',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 06:55:11','',''),(2175265,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:55:11','',''),(2175295,'1','151','755',314,'Retail Sale Id 1285121',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 06:56:56','',''),(2175296,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:56:56','',''),(2175618,'1','151','755',314,'Retail Sale Id 1285254',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:16:48','',''),(2175619,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:16:48','',''),(2175642,'1','151','755',314,'Retail Sale Id 1285278',998.40,0.00,0.00,0.00,59.28,'2021-12-06 07:17:58','',''),(2175643,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:17:58','',''),(2175676,'1','151','755',314,'Retail Sale Id 1285296',7500.80,0.00,0.00,0.00,445.36,'2021-12-06 07:20:39','',''),(2175677,'1','151','755',314,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-06 07:20:39','',''),(2175698,'1','151','755',314,'Retail Sale Id 1285309',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 07:21:35','',''),(2175699,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:21:35','',''),(2175722,'1','151','755',314,'Retail Sale Id 1285320',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 07:22:48','',''),(2175723,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:22:48','',''),(2175768,'1','151','755',314,'Retail Sale Id 1285343',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:25:23','',''),(2175769,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:25:23','',''),(2175802,'1','151','755',314,'Retail Sale Id 1285360',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 07:27:22','',''),(2175803,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:27:22','',''),(2175804,'1','151','755',314,'Retail Sale Id 1285360',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:27:22','',''),(2175805,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:27:22','',''),(2175822,'1','151','755',314,'Retail Sale Id 1285369',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 07:28:37','',''),(2175823,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:28:37','',''),(2175836,'1','151','755',314,'Retail Sale Id 1285375',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:30:01','',''),(2175837,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:30:01','',''),(2175858,'1','151','755',314,'Retail Sale Id 1285384',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:31:16','',''),(2175859,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:31:16','',''),(2175875,'1','151','755',314,'Retail Sale Id 1285393',3500.80,0.00,0.00,0.00,207.86,'2021-12-06 07:32:18','',''),(2175876,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 07:32:18','',''),(2175929,'1','151','755',314,'Retail Sale Id 1285420',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 07:35:27','',''),(2175930,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:35:27','',''),(2175973,'1','151','755',314,'Retail Sale Id 1285444',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:37:45','',''),(2175974,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:37:45','',''),(2175993,'1','151','755',314,'Retail Sale Id 1285454',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 07:38:48','',''),(2175994,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:38:48','',''),(2176007,'1','151','755',314,'Retail Sale Id 1285460',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 07:39:55','',''),(2176008,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:39:55','',''),(2176072,'1','151','755',314,'Retail Sale Id 1285488',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:42:10','',''),(2176073,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:42:10','',''),(2176131,'1','151','755',314,'Retail Sale Id 1285524',16000.00,0.00,0.00,0.00,950.00,'2021-12-06 07:45:10','',''),(2176132,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 07:45:10','',''),(2176176,'1','151','755',314,'Retail Sale Id 1285543',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 07:46:49','',''),(2176177,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:46:49','',''),(2176329,'1','151','755',314,'Retail Sale Id 1285597',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:52:51','',''),(2176330,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:52:51','',''),(2176341,'1','151','755',314,'Retail Sale Id 1285607',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 07:53:53','',''),(2176342,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:53:53','',''),(2176367,'1','151','755',314,'Retail Sale Id 1285618',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 07:54:59','',''),(2176368,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:54:59','',''),(2176399,'1','151','755',314,'Retail Sale Id 1285631',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:56:12','',''),(2176400,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:56:12','',''),(2176427,'1','151','755',314,'Retail Sale Id 1285644',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:57:34','',''),(2176428,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:57:34','',''),(2176493,'1','151','755',314,'Retail Sale Id 1285684',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:00:49','',''),(2176494,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:00:49','',''),(2176535,'1','151','755',314,'Retail Sale Id 1285709',1952.00,0.00,0.00,0.00,115.90,'2021-12-06 08:03:32','',''),(2176536,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 08:03:32','',''),(2176588,'1','151','755',314,'Retail Sale Id 1285734',6003.20,0.00,0.00,0.00,356.44,'2021-12-06 08:06:14','',''),(2176589,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 08:06:14','',''),(2176634,'1','151','755',314,'Retail Sale Id 1285756',3801.60,0.00,0.00,0.00,225.72,'2021-12-06 08:08:07','',''),(2176635,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-06 08:08:07','',''),(2176690,'1','151','755',314,'Retail Sale Id 1285787',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 08:12:24','',''),(2176691,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:12:24','',''),(2176762,'1','151','755',314,'Retail Sale Id 1285825',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 08:17:50','',''),(2176763,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 08:17:50','',''),(2176788,'1','151','755',314,'Retail Sale Id 1285841',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 08:19:37','',''),(2176789,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:19:37','',''),(2176830,'1','151','755',314,'Retail Sale Id 1285865',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 08:24:10','',''),(2176831,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:24:10','',''),(2176869,'1','151','755',314,'Retail Sale Id 1285885',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 08:27:51','',''),(2176870,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:27:51','',''),(2176881,'1','151','755',314,'Retail Sale Id 1285892',2950.40,0.00,0.00,0.00,175.18,'2021-12-06 08:29:28','',''),(2176882,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.61,0.00,'2021-12-06 08:29:28','',''),(2176893,'1','151','755',314,'Retail Sale Id 1285897',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:30:30','',''),(2176894,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:30:30','',''),(2176921,'1','151','755',314,'Retail Sale Id 1285913',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 08:32:34','',''),(2176922,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:32:34','',''),(2176923,'1','151','755',314,'Retail Sale Id 1285913',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:32:34','',''),(2176924,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:32:34','',''),(2176945,'1','151','755',314,'Retail Sale Id 1285918',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 08:34:04','',''),(2176946,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:34:04','',''),(2176982,'1','151','755',314,'Retail Sale Id 1285937',998.40,0.00,0.00,0.00,59.28,'2021-12-06 08:36:48','',''),(2176983,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:36:48','',''),(2176997,'1','151','755',314,'Retail Sale Id 1285945',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:37:47','',''),(2176998,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:37:47','',''),(2177007,'1','151','755',314,'Retail Sale Id 1285950',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:38:44','',''),(2177008,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:38:44','',''),(2177027,'1','151','755',314,'Retail Sale Id 1285959',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 08:40:18','',''),(2177028,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:40:18','',''),(2177035,'1','151','755',314,'Retail Sale Id 1285964',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:41:22','',''),(2177036,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:41:22','',''),(2177062,'1','151','755',314,'Retail Sale Id 1285974',3500.80,0.00,0.00,0.00,207.86,'2021-12-06 08:42:50','',''),(2177063,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 08:42:50','',''),(2177076,'1','151','755',314,'Retail Sale Id 1285980',2502.40,0.00,0.00,0.00,148.58,'2021-12-06 08:43:57','',''),(2177077,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 08:43:57','',''),(2177096,'1','151','755',314,'Retail Sale Id 1285991',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 08:44:59','',''),(2177097,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:44:59','',''),(2177128,'1','151','755',314,'Retail Sale Id 1286005',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 08:47:32','',''),(2177129,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:47:32','',''),(2177163,'1','151','755',314,'Retail Sale Id 1286024',3897.60,0.00,0.00,0.00,231.42,'2021-12-06 08:49:42','',''),(2177164,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:49:42','',''),(2177177,'1','151','755',314,'Retail Sale Id 1286029',4998.40,0.00,0.00,0.00,296.78,'2021-12-06 08:50:39','',''),(2177178,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 08:50:39','',''),(2177195,'1','151','755',314,'Retail Sale Id 1286040',11500.80,0.00,0.00,0.00,682.86,'2021-12-06 08:52:44','',''),(2177196,'1','151','755',314,'Retail sales',0.00,0.00,0.00,17.97,0.00,'2021-12-06 08:52:44','',''),(2177209,'1','151','755',314,'Retail Sale Id 1286048',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 08:53:48','',''),(2177210,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:53:48','',''),(2177239,'1','151','755',314,'Retail Sale Id 1286065',652.80,0.00,0.00,0.00,38.76,'2021-12-06 08:55:57','',''),(2177240,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 08:55:57','',''),(2177241,'1','151','755',314,'Retail Sale Id 1286065',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 08:55:57','',''),(2177242,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 08:55:57','',''),(2177266,'1','151','755',314,'Retail Sale Id 1286075',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 08:57:35','',''),(2177267,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:57:35','',''),(2177286,'1','151','755',314,'Retail Sale Id 1286088',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 08:59:04','',''),(2177287,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:59:04','',''),(2177325,'1','151','755',314,'Retail Sale Id 1286103',2502.40,0.00,0.00,0.00,148.58,'2021-12-06 09:01:46','',''),(2177326,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 09:01:46','',''),(2177397,'1','151','755',314,'Retail Sale Id 1286138',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 09:06:53','',''),(2177398,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:06:53','',''),(2177443,'1','151','755',314,'Retail Sale Id 1286157',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:09:52','',''),(2177444,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:09:52','',''),(2177480,'1','151','755',314,'Retail Sale Id 1286174',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 09:12:39','',''),(2177481,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:12:39','',''),(2177512,'1','151','755',314,'Retail Sale Id 1286184',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:14:42','',''),(2177513,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:14:42','',''),(2177530,'1','151','755',314,'Retail Sale Id 1286196',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 09:16:02','',''),(2177531,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:16:02','',''),(2177634,'1','151','755',314,'Retail Sale Id 1286244',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:23:10','',''),(2177635,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:23:10','',''),(2177648,'1','151','755',314,'Retail Sale Id 1286252',4998.40,0.00,0.00,0.00,296.78,'2021-12-06 09:24:15','',''),(2177649,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 09:24:15','',''),(2177666,'1','151','755',314,'Retail Sale Id 1286260',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:25:12','',''),(2177667,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:25:12','',''),(2177721,'1','151','755',314,'Retail Sale Id 1286288',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:28:02','',''),(2177722,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:28:02','',''),(2177776,'1','151','755',314,'Retail Sale Id 1286313',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:31:07','',''),(2177777,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:31:07','',''),(2177831,'1','151','755',314,'Retail Sale Id 1286334',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:34:07','',''),(2177832,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:34:07','',''),(2177916,'1','151','755',314,'Retail Sale Id 1286360',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:38:01','',''),(2177917,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:38:01','',''),(2177948,'1','151','755',314,'Retail Sale Id 1286366',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 09:38:48','',''),(2177949,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:38:48','',''),(2177962,'1','151','755',314,'Retail Sale Id 1286374',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:40:00','',''),(2177963,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:40:00','',''),(2177976,'1','151','755',314,'Retail Sale Id 1286384',1600.00,0.00,0.00,0.00,95.00,'2021-12-06 09:41:12','',''),(2177977,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 09:41:12','',''),(2177992,'1','151','755',314,'Retail Sale Id 1286390',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 09:42:21','',''),(2177993,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:42:21','',''),(2178004,'1','151','755',314,'Retail Sale Id 1286398',998.40,0.00,0.00,0.00,59.28,'2021-12-06 09:43:14','',''),(2178005,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 09:43:14','',''),(2178036,'1','151','755',314,'Retail Sale Id 1286405',3897.60,0.00,0.00,0.00,231.42,'2021-12-06 09:44:39','',''),(2178037,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:44:39','',''),(2178056,'1','151','755',314,'Retail Sale Id 1286419',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:45:49','',''),(2178057,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:45:49','',''),(2178125,'1','151','755',314,'Retail Sale Id 1286456',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:51:17','',''),(2178126,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:51:17','',''),(2178139,'1','151','755',314,'Retail Sale Id 1286465',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:52:31','',''),(2178140,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:52:31','',''),(2178165,'1','151','755',314,'Retail Sale Id 1286475',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 09:53:56','',''),(2178166,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:53:56','',''),(2178187,'1','151','755',314,'Retail Sale Id 1286487',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 09:55:01','',''),(2178188,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:55:01','',''),(2178196,'1','151','755',314,'Retail Sale Id 1286492',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 09:56:05','',''),(2178197,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:56:05','',''),(2178208,'1','151','755',314,'Retail Sale Id 1286502',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:57:23','',''),(2178209,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:57:23','',''),(2178224,'1','151','755',314,'Retail Sale Id 1286511',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 09:58:23','',''),(2178225,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 09:58:23','',''),(2178236,'1','151','755',314,'Retail Sale Id 1286518',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 09:59:39','',''),(2178237,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:59:39','',''),(2178249,'1','151','755',314,'Retail Sale Id 1286525',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:00:44','',''),(2178250,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:00:44','',''),(2178272,'1','151','755',314,'Retail Sale Id 1286531',7001.60,0.00,0.00,0.00,415.72,'2021-12-06 10:01:48','',''),(2178273,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 10:01:48','',''),(2178312,'1','151','755',314,'Retail Sale Id 1286552',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 10:03:57','',''),(2178313,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:03:57','',''),(2178346,'1','151','755',314,'Retail Sale Id 1286561',6003.20,0.00,0.00,0.00,356.44,'2021-12-06 10:05:03','',''),(2178347,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 10:05:03','',''),(2178362,'1','151','755',314,'Retail Sale Id 1286570',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 10:06:05','',''),(2178363,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:06:05','',''),(2178409,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178410,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178411,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178412,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178413,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178414,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178415,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178416,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178417,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178418,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178419,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178420,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178421,'1','151','755',314,'Retail Sale Id 1286592',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:08:50','',''),(2178422,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:08:50','',''),(2178449,'1','151','755',314,'Retail Sale Id 1286607',9600.00,0.00,0.00,0.00,570.00,'2021-12-06 10:10:38','',''),(2178450,'1','151','755',314,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 10:10:38','',''),(2178477,'1','151','755',314,'Retail Sale Id 1286622',7001.60,0.00,0.00,0.00,415.72,'2021-12-06 10:12:27','',''),(2178478,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 10:12:27','',''),(2178501,'1','151','755',314,'Retail Sale Id 1286637',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 10:13:50','',''),(2178502,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:13:50','',''),(2178511,'1','151','755',314,'Retail Sale Id 1286642',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:14:48','',''),(2178512,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:14:48','',''),(2178535,'1','151','755',314,'Retail Sale Id 1286655',998.40,0.00,0.00,0.00,59.28,'2021-12-06 10:15:52','',''),(2178536,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:15:52','',''),(2178549,'1','151','755',314,'Retail Sale Id 1286661',3500.80,0.00,0.00,0.00,207.86,'2021-12-06 10:16:56','',''),(2178550,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 10:16:56','',''),(2178575,'1','151','755',314,'Retail Sale Id 1286673',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 10:18:47','',''),(2178576,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:18:47','',''),(2178639,'1','151','755',314,'Retail Sale Id 1286712',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 10:24:35','',''),(2178640,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 10:24:35','',''),(2178659,'1','151','755',314,'Retail Sale Id 1286721',998.40,0.00,0.00,0.00,59.28,'2021-12-06 10:25:47','',''),(2178660,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:25:47','',''),(2178713,'1','151','755',314,'Retail Sale Id 1286746',15001.60,0.00,0.00,0.00,890.72,'2021-12-06 10:28:48','',''),(2178714,'1','151','755',314,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-06 10:28:48','',''),(2178731,'1','151','755',314,'Retail Sale Id 1286758',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 10:30:10','',''),(2178732,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:30:10','',''),(2178759,'1','151','755',314,'Retail Sale Id 1286770',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 10:32:00','',''),(2178760,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:32:00','',''),(2178792,'1','151','755',314,'Retail Sale Id 1286785',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 10:34:16','',''),(2178793,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:34:16','',''),(2178852,'1','151','755',314,'Retail Sale Id 1286824',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 10:38:19','',''),(2178853,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:38:19','',''),(2178876,'1','151','755',314,'Retail Sale Id 1286839',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 10:40:58','',''),(2178877,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:40:58','',''),(2178964,'1','151','755',314,'Retail Sale Id 1286881',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 10:45:45','',''),(2178965,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 10:45:45','',''),(2179096,'1','151','755',314,'Retail Sale Id 1286964',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 10:53:31','',''),(2179097,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:53:31','',''),(2179120,'1','151','755',314,'Retail Sale Id 1286978',3852.80,0.00,0.00,0.00,228.76,'2021-12-06 10:54:49','',''),(2179121,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 10:54:49','',''),(2179137,'1','151','755',314,'Retail Sale Id 1286986',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 10:56:08','',''),(2179138,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:56:08','',''),(2179167,'1','151','755',314,'Retail Sale Id 1287008',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 10:57:38','',''),(2179168,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:57:38','',''),(2179189,'1','151','755',314,'Retail Sale Id 1287024',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 10:59:04','',''),(2179190,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:59:04','',''),(2179205,'1','151','755',314,'Retail Sale Id 1287031',16000.00,0.00,0.00,0.00,950.00,'2021-12-06 10:59:58','',''),(2179206,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 10:59:58','',''),(2179223,'1','151','755',314,'Retail Sale Id 1287038',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:01:13','',''),(2179224,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:01:13','',''),(2179265,'1','151','755',314,'Retail Sale Id 1287061',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:04:14','',''),(2179266,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:04:14','',''),(2179305,'1','151','755',314,'Retail Sale Id 1287090',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 11:06:34','',''),(2179306,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:06:34','',''),(2179333,'1','151','755',314,'Retail Sale Id 1287099',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:07:41','',''),(2179334,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:07:41','',''),(2179353,'1','151','755',314,'Retail Sale Id 1287112',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:08:59','',''),(2179354,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:08:59','',''),(2179425,'1','151','755',314,'Retail Sale Id 1287146',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 11:13:32','',''),(2179426,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:13:32','',''),(2179445,'1','151','755',314,'Retail Sale Id 1287154',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 11:14:31','',''),(2179446,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 11:14:31','',''),(2179475,'1','151','755',314,'Retail Sale Id 1287170',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:16:24','',''),(2179476,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:16:24','',''),(2179503,'1','151','755',314,'Retail Sale Id 1287190',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:17:50','',''),(2179504,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:17:50','',''),(2179513,'1','151','755',314,'Retail Sale Id 1287198',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:18:40','',''),(2179514,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:18:40','',''),(2179537,'1','151','755',314,'Retail Sale Id 1287211',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:20:02','',''),(2179538,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:20:02','',''),(2179561,'1','151','755',314,'Retail Sale Id 1287227',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:21:50','',''),(2179562,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:21:50','',''),(2179617,'1','151','755',314,'Retail Sale Id 1287260',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:25:27','',''),(2179618,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:25:27','',''),(2179643,'1','151','755',314,'Retail Sale Id 1287273',998.40,0.00,0.00,0.00,59.28,'2021-12-06 11:27:41','',''),(2179644,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:27:41','',''),(2179659,'1','151','755',314,'Retail Sale Id 1287283',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 11:28:38','',''),(2179660,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:28:38','',''),(2179710,'1','151','755',314,'Retail Sale Id 1287306',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:32:11','',''),(2179711,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:32:11','',''),(2179774,'1','151','755',314,'Retail Sale Id 1287344',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 11:37:56','',''),(2179775,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:37:56','',''),(2179898,'1','151','755',314,'Retail Sale Id 1287462',16000.00,0.00,0.00,0.00,950.00,'2021-12-06 11:47:37','',''),(2179899,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 11:47:37','',''),(2179916,'1','151','755',314,'Retail Sale Id 1287471',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 11:48:50','',''),(2179917,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:48:50','',''),(2179978,'1','151','755',314,'Retail Sale Id 1287508',3801.60,0.00,0.00,0.00,225.72,'2021-12-06 11:53:52','',''),(2179979,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-06 11:53:52','',''),(2180014,'1','151','755',314,'Retail Sale Id 1287520',3852.80,0.00,0.00,0.00,228.76,'2021-12-06 11:55:25','',''),(2180015,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 11:55:25','',''),(2180076,'1','151','755',314,'Retail Sale Id 1287555',697.60,0.00,0.00,0.00,41.42,'2021-12-06 11:58:59','',''),(2180077,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 11:58:59','',''),(2180152,'1','151','755',314,'Retail Sale Id 1287589',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:04:07','',''),(2180153,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:04:07','',''),(2180154,'1','151','755',314,'Retail Sale Id 1287589',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:04:07','',''),(2180155,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:04:07','',''),(2180232,'1','151','755',314,'Retail Sale Id 1287635',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:09:00','',''),(2180233,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:09:00','',''),(2180250,'1','151','755',314,'Retail Sale Id 1287642',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:09:55','',''),(2180251,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:09:55','',''),(2180266,'1','151','755',314,'Retail Sale Id 1287651',6003.20,0.00,0.00,0.00,356.44,'2021-12-06 12:10:53','',''),(2180267,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 12:10:53','',''),(2180282,'1','151','755',314,'Retail Sale Id 1287668',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 12:12:14','',''),(2180283,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 12:12:14','',''),(2180302,'1','151','755',314,'Retail Sale Id 1287683',3801.60,0.00,0.00,0.00,225.72,'2021-12-06 12:13:17','',''),(2180303,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-06 12:13:17','',''),(2180324,'1','151','755',314,'Retail Sale Id 1287694',3500.80,0.00,0.00,0.00,207.86,'2021-12-06 12:14:19','',''),(2180325,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 12:14:19','',''),(2180346,'1','151','755',314,'Retail Sale Id 1287708',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:15:42','',''),(2180347,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:15:42','',''),(2180414,'1','151','755',314,'Retail Sale Id 1287745',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 12:19:08','',''),(2180415,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:19:08','',''),(2180434,'1','151','755',314,'Retail Sale Id 1287756',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 12:20:22','',''),(2180435,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:20:22','',''),(2180476,'1','151','755',314,'Retail Sale Id 1287777',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 12:24:01','',''),(2180477,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:24:01','',''),(2180492,'1','151','755',314,'Retail Sale Id 1287785',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:25:04','',''),(2180493,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:25:04','',''),(2180546,'1','151','755',314,'Retail Sale Id 1287816',998.40,0.00,0.00,0.00,59.28,'2021-12-06 12:28:52','',''),(2180547,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:28:52','',''),(2180564,'1','151','755',314,'Retail Sale Id 1287826',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:29:49','',''),(2180565,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:29:49','',''),(2180633,'1','151','755',314,'Retail Sale Id 1287858',7001.60,0.00,0.00,0.00,415.72,'2021-12-06 12:33:55','',''),(2180634,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 12:33:55','',''),(2180698,'1','151','755',314,'Retail Sale Id 1287893',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 12:37:13','',''),(2180699,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:37:13','',''),(2180726,'1','151','755',314,'Retail Sale Id 1287907',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 12:38:59','',''),(2180727,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:38:59','',''),(2180760,'1','151','755',314,'Retail Sale Id 1287922',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:41:24','',''),(2180761,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:41:24','',''),(2180778,'1','151','755',314,'Retail Sale Id 1287929',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:42:41','',''),(2180779,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:42:41','',''),(2180798,'1','151','755',314,'Retail Sale Id 1287939',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:44:05','',''),(2180799,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:44:05','',''),(2180818,'1','151','755',314,'Retail Sale Id 1287954',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 12:45:10','',''),(2180819,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 12:45:10','',''),(2180834,'1','151','755',314,'Retail Sale Id 1287963',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:46:39','',''),(2180835,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:46:39','',''),(2180836,'1','151','755',314,'Retail Sale Id 1287963',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:46:39','',''),(2180837,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:46:39','',''),(2180874,'1','151','755',314,'Retail Sale Id 1287982',1100.80,0.00,0.00,0.00,65.36,'2021-12-06 12:48:27','',''),(2180875,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-06 12:48:27','',''),(2180945,'1','151','755',314,'Retail Sale Id 1288021',4998.40,0.00,0.00,0.00,296.78,'2021-12-06 12:53:07','',''),(2180946,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 12:53:07','',''),(2180966,'1','151','755',314,'Retail Sale Id 1288033',2560.00,0.00,0.00,0.00,152.00,'2021-12-06 12:54:18','',''),(2180967,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 12:54:18','',''),(2180986,'1','151','755',314,'Retail Sale Id 1288041',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 12:55:28','',''),(2180987,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:55:28','',''),(2181030,'1','151','755',314,'Retail Sale Id 1288067',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 12:58:01','',''),(2181031,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:58:01','',''),(2181074,'1','151','755',314,'Retail Sale Id 1288084',998.40,0.00,0.00,0.00,59.28,'2021-12-06 12:59:48','',''),(2181075,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:59:48','',''),(2181110,'1','151','755',314,'Retail Sale Id 1288102',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 13:01:32','',''),(2181111,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:01:32','',''),(2181112,'1','151','755',314,'Retail Sale Id 1288102',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:01:32','',''),(2181113,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:01:32','',''),(2181138,'1','151','755',314,'Retail Sale Id 1288114',998.40,0.00,0.00,0.00,59.28,'2021-12-06 13:03:29','',''),(2181139,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:03:29','',''),(2181154,'1','151','755',314,'Retail Sale Id 1288120',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 13:04:29','',''),(2181155,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:04:29','',''),(2181172,'1','151','755',314,'Retail Sale Id 1288132',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:05:37','',''),(2181173,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:05:37','',''),(2181190,'1','151','755',314,'Retail Sale Id 1288142',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 13:06:58','',''),(2181191,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 13:06:58','',''),(2181216,'1','151','755',314,'Retail Sale Id 1288152',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 13:08:13','',''),(2181217,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:08:13','',''),(2181240,'1','151','755',314,'Retail Sale Id 1288167',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:09:29','',''),(2181241,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:09:29','',''),(2181322,'1','151','755',314,'Retail Sale Id 1288213',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 13:14:00','',''),(2181323,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:14:00','',''),(2181375,'1','151','755',314,'Retail Sale Id 1288237',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 13:16:02','',''),(2181376,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:16:02','',''),(2181421,'1','151','755',314,'Retail Sale Id 1288245',3852.80,0.00,0.00,0.00,228.76,'2021-12-06 13:17:52','',''),(2181422,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 13:17:52','',''),(2181445,'1','151','755',314,'Retail Sale Id 1288260',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:19:27','',''),(2181446,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:19:27','',''),(2181447,'1','151','755',314,'Retail Sale Id 1288260',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:19:27','',''),(2181448,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:19:27','',''),(2181494,'1','151','755',314,'Retail Sale Id 1288276',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:21:24','',''),(2181495,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:21:24','',''),(2181530,'1','151','755',314,'Retail Sale Id 1288296',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 13:25:26','',''),(2181531,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 13:25:26','',''),(2181560,'1','151','755',314,'Retail Sale Id 1288316',4499.20,0.00,0.00,0.00,267.14,'2021-12-06 13:28:08','',''),(2181561,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 13:28:08','',''),(2181582,'1','151','755',314,'Retail Sale Id 1288326',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:29:58','',''),(2181583,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:29:58','',''),(2181676,'1','151','755',314,'Retail Sale Id 1288351',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 13:34:56','',''),(2181677,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:34:56','',''),(2181678,'1','151','755',314,'Retail Sale Id 1288351',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 13:34:56','',''),(2181679,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:34:56','',''),(2181726,'1','151','755',314,'Retail Sale Id 1288375',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 13:36:48','',''),(2181727,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 13:36:48','',''),(2181740,'1','151','755',314,'Retail Sale Id 1288381',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:37:56','',''),(2181741,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:37:56','',''),(2181772,'1','151','755',314,'Retail Sale Id 1288404',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 13:39:42','',''),(2181773,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:39:42','',''),(2181854,'1','151','755',314,'Retail Sale Id 1288436',998.40,0.00,0.00,0.00,59.28,'2021-12-06 13:42:52','',''),(2181855,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:42:52','',''),(2181885,'1','151','755',314,'Retail Sale Id 1288449',4998.40,0.00,0.00,0.00,296.78,'2021-12-06 13:44:24','',''),(2181886,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:44:24','',''),(2181909,'1','151','755',314,'Retail Sale Id 1288462',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 13:45:45','',''),(2181910,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:45:45','',''),(2181935,'1','151','755',314,'Retail Sale Id 1288474',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 13:47:08','',''),(2181936,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:47:08','',''),(2181957,'1','151','755',314,'Retail Sale Id 1288486',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 13:48:18','',''),(2181958,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:48:18','',''),(2181999,'1','151','755',314,'Retail Sale Id 1288498',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 13:49:58','',''),(2182000,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:49:58','',''),(2182009,'1','151','755',314,'Retail Sale Id 1288510',4998.40,0.00,0.00,0.00,296.78,'2021-12-06 13:50:53','',''),(2182010,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:50:53','',''),(2182025,'1','151','755',314,'Retail Sale Id 1288517',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 13:51:46','',''),(2182026,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:51:46','',''),(2182059,'1','151','755',314,'Retail Sale Id 1288535',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 13:53:23','',''),(2182060,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:53:23','',''),(2182079,'1','151','755',314,'Retail Sale Id 1288546',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:54:29','',''),(2182080,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:54:29','',''),(2182111,'1','151','755',314,'Retail Sale Id 1288559',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:55:47','',''),(2182112,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:55:47','',''),(2182113,'1','151','755',314,'Retail Sale Id 1288559',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:55:47','',''),(2182114,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:55:47','',''),(2182133,'1','151','755',314,'Retail Sale Id 1288568',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 13:57:04','',''),(2182134,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:57:04','',''),(2182135,'1','151','755',314,'Retail Sale Id 1288568',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 13:57:04','',''),(2182136,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:57:04','',''),(2182153,'1','151','755',314,'Retail Sale Id 1288583',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 13:58:24','',''),(2182154,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:58:24','',''),(2182223,'1','151','755',314,'Retail Sale Id 1288604',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:00:34','',''),(2182224,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:00:34','',''),(2182261,'1','151','755',314,'Retail Sale Id 1288622',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 14:02:19','',''),(2182262,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 14:02:19','',''),(2182325,'1','151','755',314,'Retail Sale Id 1288658',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 14:05:55','',''),(2182326,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:05:55','',''),(2182327,'1','151','755',314,'Retail Sale Id 1288658',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 14:05:55','',''),(2182328,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:05:55','',''),(2182329,'1','151','755',314,'Retail Sale Id 1288658',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 14:05:55','',''),(2182330,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:05:55','',''),(2182331,'1','151','755',314,'Retail Sale Id 1288658',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:05:55','',''),(2182332,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:05:55','',''),(2182363,'1','151','755',314,'Retail Sale Id 1288671',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:07:24','',''),(2182364,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:07:24','',''),(2182395,'1','151','755',314,'Retail Sale Id 1288685',1900.80,0.00,0.00,0.00,112.86,'2021-12-06 14:09:02','',''),(2182396,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 14:09:02','',''),(2182397,'1','151','755',314,'Retail Sale Id 1288685',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:09:02','',''),(2182398,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:09:02','',''),(2182430,'1','151','755',314,'Retail Sale Id 1288695',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:10:01','',''),(2182431,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:10:01','',''),(2182457,'1','151','755',314,'Retail Sale Id 1288708',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 14:11:09','',''),(2182458,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:11:09','',''),(2182488,'1','151','755',314,'Retail Sale Id 1288720',998.40,0.00,0.00,0.00,59.28,'2021-12-06 14:12:05','',''),(2182489,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:12:05','',''),(2182507,'1','151','755',314,'Retail Sale Id 1288728',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 14:13:22','',''),(2182508,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:13:22','',''),(2182537,'1','151','755',314,'Retail Sale Id 1288742',3500.80,0.00,0.00,0.00,207.86,'2021-12-06 14:14:54','',''),(2182538,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 14:14:54','',''),(2182557,'1','151','755',314,'Retail Sale Id 1288752',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:15:49','',''),(2182558,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:15:49','',''),(2182597,'1','151','755',314,'Retail Sale Id 1288765',998.40,0.00,0.00,0.00,59.28,'2021-12-06 14:17:04','',''),(2182598,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:17:04','',''),(2182660,'1','151','755',314,'Retail Sale Id 1288802',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 14:20:43','',''),(2182661,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:20:43','',''),(2182742,'1','151','755',314,'Retail Sale Id 1288840',998.40,0.00,0.00,0.00,59.28,'2021-12-06 14:24:51','',''),(2182743,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:24:51','',''),(2182782,'1','151','755',314,'Retail Sale Id 1288863',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 14:27:33','',''),(2182783,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:27:33','',''),(2182822,'1','151','755',314,'Retail Sale Id 1288881',1299.20,0.00,0.00,0.00,77.14,'2021-12-06 14:30:04','',''),(2182823,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 14:30:05','',''),(2182850,'1','151','755',314,'Retail Sale Id 1288897',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:31:37','',''),(2182851,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:31:37','',''),(2182895,'1','151','755',314,'Retail Sale Id 1288915',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:33:33','',''),(2182896,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:33:33','',''),(2182915,'1','151','755',314,'Retail Sale Id 1288931',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 14:34:31','',''),(2182916,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:34:31','',''),(2182930,'1','151','755',314,'Retail Sale Id 1288935',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 14:35:25','',''),(2182931,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:35:25','',''),(2182958,'1','151','755',314,'Retail Sale Id 1288949',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:37:07','',''),(2182959,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:37:07','',''),(2182984,'1','151','755',314,'Retail Sale Id 1288961',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 14:38:57','',''),(2182985,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:38:57','',''),(2183004,'1','151','755',314,'Retail Sale Id 1288972',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:40:10','',''),(2183005,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:40:10','',''),(2183045,'1','151','755',314,'Retail Sale Id 1288980',6003.20,0.00,0.00,0.00,356.44,'2021-12-06 14:41:28','',''),(2183046,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 14:41:28','',''),(2183077,'1','151','755',314,'Retail Sale Id 1288991',12800.00,0.00,0.00,0.00,760.00,'2021-12-06 14:42:40','',''),(2183080,'1','151','755',314,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 14:42:40','',''),(2183101,'1','151','755',314,'Retail Sale Id 1289004',1497.60,0.00,0.00,0.00,88.92,'2021-12-06 14:43:55','',''),(2183102,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:43:55','',''),(2183103,'1','151','755',314,'Retail Sale Id 1289004',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 14:43:55','',''),(2183104,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:43:55','',''),(2183129,'1','151','755',314,'Retail Sale Id 1289015',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:45:24','',''),(2183130,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:45:24','',''),(2183155,'1','151','755',314,'Retail Sale Id 1289029',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 14:47:10','',''),(2183156,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:47:10','',''),(2183157,'1','151','755',314,'Retail Sale Id 1289029',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 14:47:10','',''),(2183158,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:47:10','',''),(2183190,'1','151','755',314,'Retail Sale Id 1289039',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:48:12','',''),(2183191,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:48:12','',''),(2183212,'1','151','755',314,'Retail Sale Id 1289048',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:49:29','',''),(2183213,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:49:29','',''),(2183311,'1','151','755',314,'Retail Sale Id 1289095',1702.40,0.00,0.00,0.00,101.08,'2021-12-06 14:54:01','',''),(2183312,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-06 14:54:01','',''),(2183339,'1','151','755',314,'Retail Sale Id 1289109',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 14:55:22','',''),(2183340,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:55:22','',''),(2183371,'1','151','755',314,'Retail Sale Id 1289125',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 14:57:07','',''),(2183372,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:57:07','',''),(2183395,'1','151','755',314,'Retail Sale Id 1289136',2502.40,0.00,0.00,0.00,148.58,'2021-12-06 14:58:34','',''),(2183396,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:58:34','',''),(2183419,'1','151','755',314,'Retail Sale Id 1289149',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 15:00:02','',''),(2183420,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:00:02','',''),(2183461,'1','151','755',314,'Retail Sale Id 1289171',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:02:14','',''),(2183462,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:02:14','',''),(2183487,'1','151','755',314,'Retail Sale Id 1289187',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 15:03:40','',''),(2183488,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:03:40','',''),(2183647,'1','151','755',314,'Retail Sale Id 1289256',3001.60,0.00,0.00,0.00,178.22,'2021-12-06 15:12:53','',''),(2183648,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:12:53','',''),(2183661,'1','151','755',314,'Retail Sale Id 1289263',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 15:13:48','',''),(2183662,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:13:48','',''),(2183689,'1','151','755',314,'Retail Sale Id 1289272',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 15:14:51','',''),(2183690,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:14:51','',''),(2183708,'1','151','755',314,'Retail Sale Id 1289282',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 15:15:57','',''),(2183709,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:15:57','',''),(2183728,'1','151','755',314,'Retail Sale Id 1289293',998.40,0.00,0.00,0.00,59.28,'2021-12-06 15:17:02','',''),(2183729,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:17:02','',''),(2183754,'1','151','755',314,'Retail Sale Id 1289306',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 15:18:20','',''),(2183755,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:18:20','',''),(2183770,'1','151','755',314,'Retail Sale Id 1289316',4000.00,0.00,0.00,0.00,237.50,'2021-12-06 15:19:25','',''),(2183771,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:19:25','',''),(2183820,'1','151','755',314,'Retail Sale Id 1289333',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:21:08','',''),(2183821,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:21:08','',''),(2183885,'1','151','755',314,'Retail Sale Id 1289358',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 15:23:24','',''),(2183886,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:23:24','',''),(2183909,'1','151','755',314,'Retail Sale Id 1289371',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:24:22','',''),(2183910,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:24:22','',''),(2183939,'1','151','755',314,'Retail Sale Id 1289387',2003.20,0.00,0.00,0.00,118.94,'2021-12-06 15:25:41','',''),(2183940,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:25:41','',''),(2184240,'1','151','755',314,'Return of Retail Sale Id 1289387',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 15:40:18','',''),(2184367,'1','151','755',314,'Return of Retail Sale Id 1289029',0.00,1920.00,3.00,0.00,-114.00,'2021-12-06 15:44:04','',''),(2184368,'1','151','755',314,'Return of Retail Sale Id 1289029',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 15:44:04','',''),(2184445,'1','151','755',314,'Return of Retail Sale Id 1287907',0.00,3200.00,5.00,0.00,-190.00,'2021-12-06 15:46:56','',''),(2184474,'1','151','755',314,'Return of Retail Sale Id 1286334',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 15:48:40','',''),(2184563,'1','151','755',314,'Return of Retail Sale Id 1289109',0.00,1920.00,3.00,0.00,-114.00,'2021-12-06 15:53:29','',''),(2184586,'1','151','755',314,'Return of Retail Sale Id 1289048',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 15:54:26','',''),(2184615,'1','151','755',314,'Return of Retail Sale Id 1289358',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 15:55:49','',''),(2184638,'1','151','755',314,'Return of Retail Sale Id 1289333',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 15:57:04','',''),(2184654,'1','151','755',314,'Return of Retail Sale Id 1289371',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 15:57:55','',''),(2184674,'1','151','755',314,'Return of Retail Sale Id 1289316',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 15:58:57','',''),(2184695,'1','151','755',314,'Return of Retail Sale Id 1289306',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 16:00:16','',''),(2184716,'1','151','755',314,'Return of Retail Sale Id 1289136',0.00,2502.40,3.91,0.00,-148.58,'2021-12-06 16:01:28','',''),(2184743,'1','151','755',314,'Return of Retail Sale Id 1288961',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 16:03:06','',''),(2184768,'1','151','755',314,'Return of Retail Sale Id 1288742',0.00,3500.80,5.47,0.00,-207.86,'2021-12-06 16:04:42','',''),(2184805,'1','151','755',314,'Return of Retail Sale Id 1288152',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 16:06:28','',''),(2184817,'1','151','755',314,'Return of Retail Sale Id 1288462',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 16:07:30','',''),(2184832,'1','151','755',314,'Return of Retail Sale Id 1288120',0.00,3200.00,5.00,0.00,-190.00,'2021-12-06 16:08:51','',''),(2184856,'1','151','755',314,'Return of Retail Sale Id 1287683',0.00,3801.60,5.94,0.00,-225.72,'2021-12-06 16:10:30','',''),(2184880,'1','151','755',314,'Return of Retail Sale Id 1286405',0.00,3897.60,6.09,0.00,-231.42,'2021-12-06 16:12:19','',''),(2184896,'1','151','755',314,'Return of Retail Sale Id 1287893',0.00,3200.00,5.00,0.00,-190.00,'2021-12-06 16:13:17','',''),(2184918,'1','151','755',314,'Return of Retail Sale Id 1287520',0.00,3852.80,6.02,0.00,-228.76,'2021-12-06 16:14:59','',''),(2185120,'1','151','755',314,'Retail Sale Id 1289904',2560.00,0.00,0.00,0.00,152.00,'2021-12-06 16:25:02','',''),(2185121,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 16:25:02','',''),(2185199,'1','151','755',314,'Retail Sale Id 1289946',2502.40,0.00,0.00,0.00,148.58,'2021-12-06 16:29:15','',''),(2185200,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 16:29:15','',''),(2185252,'1','151','755',314,'Retail Sale Id 1289977',3852.80,0.00,0.00,0.00,228.76,'2021-12-06 16:32:02','',''),(2185253,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:32:02','',''),(2185348,'1','151','755',314,'Retail Sale Id 1290019',3852.80,0.00,0.00,0.00,228.76,'2021-12-06 16:36:46','',''),(2185349,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:36:46','',''),(2186176,'1','151','755',314,'Return of Retail Sale Id 1289171',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 17:33:21','',''),(2186194,'1','151','755',314,'Return of Retail Sale Id 1289149',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:36:31','',''),(2186213,'1','151','755',314,'Return of Retail Sale Id 1287963',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:37:50','',''),(2186214,'1','151','755',314,'Return of Retail Sale Id 1287963',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:37:50','',''),(2186237,'1','151','755',314,'Return of Retail Sale Id 1288658',0.00,1920.00,3.00,0.00,-114.00,'2021-12-06 17:39:18','',''),(2186238,'1','151','755',314,'Return of Retail Sale Id 1288658',0.00,1920.00,3.00,0.00,-114.00,'2021-12-06 17:39:18','',''),(2186239,'1','151','755',314,'Return of Retail Sale Id 1288658',0.00,3200.00,5.00,0.00,-190.00,'2021-12-06 17:39:18','',''),(2186240,'1','151','755',314,'Return of Retail Sale Id 1288658',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:39:18','',''),(2186243,'1','151','755',314,'Return of Retail Sale Id 1289256',0.00,3001.60,4.69,0.00,-178.22,'2021-12-06 17:40:35','',''),(2186246,'1','151','755',314,'Return of Retail Sale Id 1290019',0.00,3852.80,6.02,0.00,-228.76,'2021-12-06 17:41:07','',''),(2186257,'1','151','755',314,'Return of Retail Sale Id 1288559',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:43:42','',''),(2186258,'1','151','755',314,'Return of Retail Sale Id 1288559',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:43:42','',''),(2186285,'1','151','755',314,'Return of Retail Sale Id 1287061',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 17:46:06','',''),(2186297,'1','151','755',314,'Return of Retail Sale Id 1284883',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:48:28','',''),(2186310,'1','151','755',314,'Return of Retail Sale Id 1289977',0.00,3852.80,6.02,0.00,-228.76,'2021-12-06 17:50:21','',''),(2186321,'1','151','755',314,'Return of Retail Sale Id 1285022',0.00,998.40,1.56,0.00,-59.28,'2021-12-06 17:51:40','',''),(2186322,'1','151','755',314,'Return of Retail Sale Id 1285022',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 17:51:40','',''),(2186333,'1','151','755',314,'Return of Retail Sale Id 1288510',0.00,4998.40,7.81,0.00,-296.78,'2021-12-06 17:52:46','',''),(2186340,'1','151','755',314,'Return of Retail Sale Id 1289187',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 17:53:47','',''),(2186349,'1','151','755',314,'Return of Retail Sale Id 1289904',0.00,2560.00,4.00,0.00,-152.00,'2021-12-06 17:54:54','',''),(2186352,'1','151','755',314,'Return of Retail Sale Id 1289263',0.00,2003.20,3.13,0.00,-118.94,'2021-12-06 17:55:37','',''),(2186355,'1','151','755',314,'Return of Retail Sale Id 1289946',0.00,2502.40,3.91,0.00,-148.58,'2021-12-06 17:56:25','',''),(2186360,'1','151','755',314,'Return of Retail Sale Id 1289004',0.00,1497.60,2.34,0.00,-88.92,'2021-12-06 17:57:20','',''),(2186361,'1','151','755',314,'Return of Retail Sale Id 1289004',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 17:57:20','',''),(2186366,'1','151','755',314,'Return of Retail Sale Id 1288802',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 17:58:08','',''),(2186379,'1','151','755',314,'Return of Retail Sale Id 1287777',0.00,4000.00,6.25,0.00,-237.50,'2021-12-06 18:00:23','',''),(2186403,'1','151','755',314,'Return of Retail Sale Id 1288102',0.00,3840.00,6.00,0.00,-228.00,'2021-12-06 18:01:56','',''),(2186404,'1','151','755',314,'Return of Retail Sale Id 1288102',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 18:01:56','',''),(2186407,'1','151','755',314,'Return of Retail Sale Id 1287858',0.00,7001.60,10.94,0.00,-415.72,'2021-12-06 18:03:45','',''),(2186418,'1','151','755',314,'Return of Retail Sale Id 1287635',0.00,8000.00,12.50,0.00,-475.00,'2021-12-06 18:04:44','',''),(2186442,'1','151','755',314,'Return of Retail Sale Id 1285059',0.00,16000.00,25.00,0.00,-950.00,'2021-12-06 18:09:35','',''),(2186443,'1','151','755',314,'Retail Sale Id 1290560',499.20,0.00,0.00,0.00,29.64,'2021-12-06 18:12:44','',''),(2186444,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-06 18:12:44','',''),(2186445,'1','151','755',314,'Retail Sale Id 1290560',276518.40,0.00,0.00,0.00,16418.28,'2021-12-06 18:12:44','',''),(2186446,'1','151','755',314,'Retail sales',0.00,0.00,0.00,432.06,0.00,'2021-12-06 18:12:44','',''),(2186506,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,421400.00,700.00,0.00,0.00,'2021-12-06 18:29:30','',''),(2186509,'1','151',NULL,314,'Reception corrector for bridging 126402',0.00,0.00,0.00,700.00,0.00,'2021-12-06 18:30:45','',''),(2186510,'1','151','755',314,'Received from bridging 126402',0.00,0.00,700.00,0.00,0.00,'2021-12-06 18:30:45','',''),(2186513,'1','151','755',314,'Retail Sale Id 1290571',83072.00,0.00,0.00,0.00,4932.40,'2021-12-06 18:32:57','',''),(2186514,'1','151','755',314,'Retail sales',0.00,0.00,0.00,129.80,0.00,'2021-12-06 18:32:57','',''),(2186515,'1','151','755',314,'Retail Sale Id 1290571',89478.40,0.00,0.00,0.00,5312.78,'2021-12-06 18:32:57','',''),(2186516,'1','151','755',314,'Retail sales',0.00,0.00,0.00,139.81,0.00,'2021-12-06 18:32:57','',''),(2187531,'1','151','755',314,'Retail Sale Id 1290849',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 06:34:46','',''),(2187532,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 06:34:46','',''),(2187551,'1','151','755',314,'Retail Sale Id 1290860',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 06:35:59','',''),(2187552,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:35:59','',''),(2187567,'1','151','755',314,'Retail Sale Id 1290869',1798.40,0.00,0.00,0.00,106.78,'2021-12-07 06:37:20','',''),(2187568,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 06:37:20','',''),(2187591,'1','151','755',314,'Retail Sale Id 1290880',3801.60,0.00,0.00,0.00,225.72,'2021-12-07 06:39:00','',''),(2187592,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-07 06:39:00','',''),(2187613,'1','151','755',314,'Retail Sale Id 1290894',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:40:26','',''),(2187614,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:40:26','',''),(2187615,'1','151','755',314,'Retail Sale Id 1290894',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:40:26','',''),(2187616,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:40:26','',''),(2187653,'1','151','755',314,'Retail Sale Id 1290916',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:42:37','',''),(2187654,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:42:37','',''),(2187667,'1','151','755',314,'Retail Sale Id 1290924',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 06:43:46','',''),(2187668,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:43:46','',''),(2187693,'1','151','755',314,'Retail Sale Id 1290940',4480.00,0.00,0.00,0.00,266.00,'2021-12-07 06:45:54','',''),(2187694,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 06:45:54','',''),(2187706,'1','151','755',314,'Retail Sale Id 1290947',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 06:47:14','',''),(2187707,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:47:14','',''),(2187766,'1','151','755',314,'Retail Sale Id 1290969',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:50:28','',''),(2187767,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:50:28','',''),(2187856,'1','151','755',314,'Retail Sale Id 1291002',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:56:00','',''),(2187857,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:56:00','',''),(2187986,'1','151','755',314,'Retail Sale Id 1291069',998.40,0.00,0.00,0.00,59.28,'2021-12-07 07:02:44','',''),(2187987,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:02:44','',''),(2187988,'1','151','755',314,'Retail Sale Id 1291069',1702.40,0.00,0.00,0.00,101.08,'2021-12-07 07:02:44','',''),(2187989,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 07:02:44','',''),(2188084,'1','151','755',314,'Retail Sale Id 1291117',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:07:33','',''),(2188085,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:07:33','',''),(2188086,'1','151','755',314,'Retail Sale Id 1291117',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:07:33','',''),(2188087,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:07:33','',''),(2188106,'1','151','755',314,'Retail Sale Id 1291123',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:08:25','',''),(2188107,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:08:25','',''),(2188128,'1','151','755',314,'Retail Sale Id 1291138',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 07:09:32','',''),(2188129,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:09:33','',''),(2188150,'1','151','755',314,'Retail Sale Id 1291151',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 07:10:41','',''),(2188151,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:10:41','',''),(2188176,'1','151','755',314,'Retail Sale Id 1291164',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 07:11:51','',''),(2188177,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:11:51','',''),(2188256,'1','151','755',314,'Retail Sale Id 1291195',998.40,0.00,0.00,0.00,59.28,'2021-12-07 07:15:17','',''),(2188257,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:15:17','',''),(2188270,'1','151','755',314,'Retail Sale Id 1291206',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 07:16:28','',''),(2188271,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:16:28','',''),(2188273,'1','151','755',314,'Retail Sale Id 1291206',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 07:16:28','',''),(2188274,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:16:28','',''),(2188318,'1','151','755',314,'Retail Sale Id 1291232',998.40,0.00,0.00,0.00,59.28,'2021-12-07 07:18:29','',''),(2188319,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:18:29','',''),(2188342,'1','151','755',314,'Retail Sale Id 1291246',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 07:19:28','',''),(2188343,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:19:28','',''),(2188398,'1','151','755',314,'Retail Sale Id 1291275',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:22:02','',''),(2188399,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:22:02','',''),(2188436,'1','151','755',314,'Retail Sale Id 1291295',8320.00,0.00,0.00,0.00,494.00,'2021-12-07 07:24:20','',''),(2188437,'1','151','755',314,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 07:24:20','',''),(2188474,'1','151','755',314,'Retail Sale Id 1291312',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 07:26:05','',''),(2188475,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:26:05','',''),(2188476,'1','151','755',314,'Retail Sale Id 1291312',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 07:26:05','',''),(2188477,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:26:05','',''),(2188496,'1','151','755',314,'Retail Sale Id 1291320',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 07:27:07','',''),(2188497,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:27:07','',''),(2188498,'1','151','755',314,'Retail Sale Id 1291320',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 07:27:07','',''),(2188499,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:27:07','',''),(2188549,'1','151','755',314,'Retail Sale Id 1291343',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 07:29:00','',''),(2188550,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:29:00','',''),(2188575,'1','151','755',314,'Retail Sale Id 1291358',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 07:30:14','',''),(2188576,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:30:14','',''),(2188606,'1','151','755',314,'Retail Sale Id 1291372',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:31:24','',''),(2188607,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:31:24','',''),(2188682,'1','151','755',314,'Retail Sale Id 1291417',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:35:38','',''),(2188683,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:35:38','',''),(2188780,'1','151','755',314,'Retail Sale Id 1291467',7001.60,0.00,0.00,0.00,415.72,'2021-12-07 07:40:17','',''),(2188781,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 07:40:17','',''),(2188804,'1','151','755',314,'Retail Sale Id 1291479',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:41:38','',''),(2188805,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:41:38','',''),(2188806,'1','151','755',314,'Retail Sale Id 1291479',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 07:41:38','',''),(2188807,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:41:38','',''),(2188936,'1','151','755',314,'Retail Sale Id 1291574',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 07:49:17','',''),(2188937,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:49:17','',''),(2189016,'1','151','755',314,'Retail Sale Id 1291610',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 07:53:19','',''),(2189017,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:53:19','',''),(2189151,'1','151','755',314,'Retail Sale Id 1291659',7001.60,0.00,0.00,0.00,415.72,'2021-12-07 08:00:20','',''),(2189152,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 08:00:20','',''),(2189183,'1','151','755',314,'Retail Sale Id 1291686',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 08:02:52','',''),(2189184,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:02:52','',''),(2189201,'1','151','755',314,'Retail Sale Id 1291697',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 08:03:57','',''),(2189202,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:03:57','',''),(2189219,'1','151','755',314,'Retail Sale Id 1291707',32000.00,0.00,0.00,0.00,1900.00,'2021-12-07 08:04:54','',''),(2189220,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:04:54','',''),(2189249,'1','151','755',314,'Retail Sale Id 1291721',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 08:07:04','',''),(2189250,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:07:05','',''),(2189304,'1','151','755',314,'Retail Sale Id 1291740',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:09:05','',''),(2189305,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:09:05','',''),(2189329,'1','151','755',314,'Retail Sale Id 1291750',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:10:14','',''),(2189330,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:10:14','',''),(2189331,'1','151','755',314,'Retail Sale Id 1291750',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:10:14','',''),(2189332,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:10:14','',''),(2189341,'1','151','755',314,'Retail Sale Id 1291754',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:11:12','',''),(2189342,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:11:12','',''),(2189359,'1','151','755',314,'Retail Sale Id 1291767',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 08:12:11','',''),(2189360,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:12:11','',''),(2189412,'1','151','755',314,'Retail Sale Id 1291791',4480.00,0.00,0.00,0.00,266.00,'2021-12-07 08:15:13','',''),(2189413,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 08:15:13','',''),(2189533,'1','151','755',314,'Retail Sale Id 1291854',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:22:13','',''),(2189534,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:22:13','',''),(2189593,'1','151','755',314,'Retail Sale Id 1291880',998.40,0.00,0.00,0.00,59.28,'2021-12-07 08:26:16','',''),(2189594,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:26:16','',''),(2189595,'1','151','755',314,'Retail Sale Id 1291880',1497.60,0.00,0.00,0.00,88.92,'2021-12-07 08:26:16','',''),(2189596,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:26:16','',''),(2189764,'1','151','755',314,'Retail Sale Id 1291958',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 08:35:47','',''),(2189765,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:35:47','',''),(2189807,'1','151','755',314,'Retail Sale Id 1291969',998.40,0.00,0.00,0.00,59.28,'2021-12-07 08:37:32','',''),(2189808,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:37:32','',''),(2190146,'1','151','755',314,'Retail Sale Id 1292112',3500.80,0.00,0.00,0.00,207.86,'2021-12-07 08:54:00','',''),(2190147,'1','151','755',314,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 08:54:00','',''),(2190174,'1','151','755',314,'Retail Sale Id 1292128',998.40,0.00,0.00,0.00,59.28,'2021-12-07 08:55:36','',''),(2190175,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:55:36','',''),(2190190,'1','151','755',314,'Retail Sale Id 1292136',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 08:56:56','',''),(2190191,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:56:56','',''),(2190238,'1','151','755',314,'Retail Sale Id 1292160',6400.00,0.00,0.00,0.00,380.00,'2021-12-07 09:00:52','',''),(2190239,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:00:52','',''),(2190369,'1','151','755',314,'Retail Sale Id 1292223',2150.40,0.00,0.00,0.00,127.68,'2021-12-07 09:08:36','',''),(2190370,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.36,0.00,'2021-12-07 09:08:36','',''),(2190699,'1','151',NULL,314,'Purchased from AA RANO NIGERIA LIMITED',0.00,903000.00,1500.00,0.00,0.00,'2021-12-07 09:26:20','',''),(2190739,'1','151',NULL,314,'Reception corrector for bridging 126450',0.00,0.00,0.00,1500.00,0.00,'2021-12-07 09:27:52','',''),(2190740,'1','151','755',314,'Received from bridging 126450',0.00,0.00,1500.00,0.00,0.00,'2021-12-07 09:27:52','',''),(2190766,'1','151','755',314,'Retail Sale Id 1292414',64000.00,0.00,0.00,0.00,3800.00,'2021-12-07 09:28:50','',''),(2190767,'1','151','755',314,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 09:28:50','',''),(2190800,'1','151','755',314,'Retail Sale Id 1292432',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 09:30:03','',''),(2190801,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:30:03','',''),(2190850,'1','151','755',314,'Retail Sale Id 1292454',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 09:32:16','',''),(2190851,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:32:16','',''),(2190862,'1','151','755',314,'Retail Sale Id 1292461',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 09:33:05','',''),(2190863,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:33:05','',''),(2190884,'1','151','755',314,'Retail Sale Id 1292471',2003.20,0.00,0.00,0.00,118.94,'2021-12-07 09:34:03','',''),(2190885,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:34:03','',''),(2190910,'1','151','755',314,'Retail Sale Id 1292484',3852.80,0.00,0.00,0.00,228.76,'2021-12-07 09:35:33','',''),(2190911,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 09:35:33','',''),(2190990,'1','151','755',314,'Retail Sale Id 1292527',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 09:40:10','',''),(2190991,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:40:10','',''),(2191068,'1','151','755',314,'Retail Sale Id 1292556',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 09:44:23','',''),(2191069,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:44:23','',''),(2191080,'1','151','755',314,'Retail Sale Id 1292574',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 09:45:13','',''),(2191081,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:45:13','',''),(2191090,'1','151','755',314,'Retail Sale Id 1292580',7001.60,0.00,0.00,0.00,415.72,'2021-12-07 09:46:18','',''),(2191091,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 09:46:18','',''),(2191106,'1','151','755',314,'Retail Sale Id 1292587',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 09:48:31','',''),(2191107,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:48:31','',''),(2191124,'1','151','755',314,'Retail Sale Id 1292597',6003.20,0.00,0.00,0.00,356.44,'2021-12-07 09:49:54','',''),(2191125,'1','151','755',314,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-07 09:49:54','',''),(2191186,'1','151','755',314,'Retail Sale Id 1292631',300.80,0.00,0.00,0.00,17.86,'2021-12-07 09:54:02','',''),(2191187,'1','151','755',314,'Retail sales',0.00,0.00,0.00,0.47,0.00,'2021-12-07 09:54:02','',''),(2191206,'1','151','755',314,'Retail Sale Id 1292644',3852.80,0.00,0.00,0.00,228.76,'2021-12-07 09:55:22','',''),(2191207,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 09:55:22','',''),(2191274,'1','151','755',314,'Retail Sale Id 1292679',3852.80,0.00,0.00,0.00,228.76,'2021-12-07 09:59:55','',''),(2191275,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 09:59:55','',''),(2191335,'1','151','755',314,'Retail Sale Id 1292709',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:04:04','',''),(2191336,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:04:04','',''),(2191413,'1','151','755',314,'Retail Sale Id 1292745',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 10:09:03','',''),(2191414,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 10:09:03','',''),(2191459,'1','151','755',314,'Retail Sale Id 1292771',16000.00,0.00,0.00,0.00,950.00,'2021-12-07 10:12:10','',''),(2191460,'1','151','755',314,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 10:12:10','',''),(2191503,'1','151','755',314,'Retail Sale Id 1292797',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:15:08','',''),(2191504,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:15:08','',''),(2191527,'1','151','755',314,'Retail Sale Id 1292811',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:16:37','',''),(2191528,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:16:37','',''),(2191559,'1','151','755',314,'Retail Sale Id 1292827',32000.00,0.00,0.00,0.00,1900.00,'2021-12-07 10:18:56','',''),(2191560,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 10:18:56','',''),(2191597,'1','151','755',314,'Retail Sale Id 1292845',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:21:33','',''),(2191598,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:21:33','',''),(2191611,'1','151','755',314,'Retail Sale Id 1292855',1900.80,0.00,0.00,0.00,112.86,'2021-12-07 10:22:58','',''),(2191612,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-07 10:22:58','',''),(2191637,'1','151','755',314,'Retail Sale Id 1292866',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:25:36','',''),(2191638,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:25:36','',''),(2191682,'1','151','755',314,'Retail Sale Id 1292887',2297.60,0.00,0.00,0.00,136.42,'2021-12-07 10:28:12','',''),(2191683,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-07 10:28:12','',''),(2191698,'1','151','755',314,'Retail Sale Id 1292894',1497.60,0.00,0.00,0.00,88.92,'2021-12-07 10:30:44','',''),(2191699,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:30:44','',''),(2191747,'1','151','755',314,'Retail Sale Id 1292922',7001.60,0.00,0.00,0.00,415.72,'2021-12-07 10:34:24','',''),(2191748,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 10:34:24','',''),(2191759,'1','151','755',314,'Retail Sale Id 1292929',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 10:35:27','',''),(2191760,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 10:35:27','',''),(2191771,'1','151','755',314,'Retail Sale Id 1292936',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:36:45','',''),(2191772,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:36:45','',''),(2191773,'1','151','755',314,'Retail Sale Id 1292936',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:36:45','',''),(2191774,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:36:45','',''),(2191849,'1','151','755',314,'Retail Sale Id 1292974',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:41:13','',''),(2191850,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:41:13','',''),(2191929,'1','151','755',314,'Retail Sale Id 1293011',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:45:12','',''),(2191930,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:45:12','',''),(2191931,'1','151','755',314,'Retail Sale Id 1293011',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:45:12','',''),(2191932,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:45:12','',''),(2192016,'1','151','755',314,'Retail Sale Id 1293040',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 10:48:23','',''),(2192017,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 10:48:23','',''),(2192032,'1','151','755',314,'Retail Sale Id 1293055',7001.60,0.00,0.00,0.00,415.72,'2021-12-07 10:49:39','',''),(2192033,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 10:49:39','',''),(2192072,'1','151','755',314,'Retail Sale Id 1293076',4998.40,0.00,0.00,0.00,296.78,'2021-12-07 10:51:52','',''),(2192073,'1','151','755',314,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 10:51:52','',''),(2192111,'1','151','755',314,'Retail Sale Id 1293096',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:53:55','',''),(2192112,'1','151','755',314,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:53:55','',''),(2192139,'1','151','755',314,'Retail Sale Id 1293109',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 10:55:27','',''),(2192140,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:55:27','',''),(2192179,'1','151','755',314,'Retail Sale Id 1293130',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:57:47','',''),(2192180,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:57:47','',''),(2192199,'1','151','755',314,'Retail Sale Id 1293142',1497.60,0.00,0.00,0.00,88.92,'2021-12-07 10:58:59','',''),(2192200,'1','151','755',314,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:58:59','',''),(2192229,'1','151','755',314,'Retail Sale Id 1293154',32000.00,0.00,0.00,0.00,1900.00,'2021-12-07 11:00:43','',''),(2192230,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:00:43','',''),(2192231,'1','151','755',314,'Retail Sale Id 1293154',32000.00,0.00,0.00,0.00,1900.00,'2021-12-07 11:00:43','',''),(2192232,'1','151','755',314,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:00:43','',''),(2192286,'1','151','755',314,'Retail Sale Id 1293168',998.40,0.00,0.00,0.00,59.28,'2021-12-07 11:02:45','',''),(2192287,'1','151','755',314,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:02:45','',''),(2192308,'1','151','755',314,'Retail Sale Id 1293179',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 11:03:46','',''),(2192309,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:03:46','',''),(2192324,'1','151','755',314,'Retail Sale Id 1293188',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 11:04:35','',''),(2192325,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:04:35','',''),(2192342,'1','151','755',314,'Retail Sale Id 1293197',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 11:05:51','',''),(2192343,'1','151','755',314,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:05:51','',''),(2192358,'1','151','755',314,'Retail Sale Id 1293204',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 11:06:36','',''),(2192359,'1','151','755',314,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:06:36','',''),(2192392,'1','151','755',314,'Retail Sale Id 1293222',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 11:08:17','',''),(2192393,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:08:17','',''),(2192394,'1','151','755',314,'Retail Sale Id 1293222',3001.60,0.00,0.00,0.00,178.22,'2021-12-07 11:08:17','',''),(2192395,'1','151','755',314,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:08:17','',''),(2192396,'1','151','755',314,'Retail Sale Id 1293222',6400.00,0.00,0.00,0.00,380.00,'2021-12-07 11:08:17','',''),(2192397,'1','151','755',314,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 11:08:17','',''),(2192440,'1','151','755',314,'Retail Sale Id 1293245',2003.20,0.00,0.00,0