-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_150
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_150`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_150` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_150`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3216 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2611,20011,'',0,'22','1','150','PURCHASES','','2020-08-10 22:12:18',5,0.00,0.00,'','479','2020-08-10 22:12:18','479',0,1),(2612,400094,'',0,'24','1','150','PURCHASES','','2020-08-10 22:12:40',5,0.00,0.00,'','479','2020-08-10 22:12:40','479',0,1),(2613,20019,'',0,'20','1','150','SALES','','2020-08-10 22:13:01',5,0.00,0.00,'','479','2020-08-10 22:13:01','479',0,1),(2614,40018,'',0,'6.1','1','150','CASH','','2020-08-10 22:13:18',5,0.00,0.00,'','479','2020-08-10 22:13:18','479',0,1),(2615,400095,'',0,'24','1','150','SALARIES & WAGES','','2020-08-10 22:13:57',5,0.00,0.00,'','479','2020-08-10 22:13:57','479',0,1),(2616,400227,'',0,'2','1','150','ZBN(POS):1015965368','','2020-08-10 22:14:28',5,0.00,0.00,'','479','2020-08-10 22:14:28','479',0,1),(2617,400228,'',0,'2','1','150','ZB(E-BILL)1015372548','','2020-08-10 22:14:44',5,0.00,0.00,'','479','2020-08-10 22:14:44','479',0,1),(2661,400112,'',0,'24','1','150','OPERATIONAL LOSS','AA RANO HOUSE HOTORO KANO.','2020-08-13 14:07:57',5,0.00,0.00,'','479','2020-08-13 14:07:57','479',0,1),(2909,400326,'',0,'2','1','150','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:02:08',5,0.00,0.00,'','489','2020-10-29 14:02:08','489',0,1),(3213,400492,'',0,'2','1','150','FID POS COLLECTION-5620141491','','2021-02-26 16:05:03',5,0.00,0.00,'','489','2021-02-26 16:05:03','489',0,1),(3214,400493,'',0,'2','1','150','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:07:49',5,0.00,0.00,'','792','2023-02-20 14:07:49','792',0,0),(3215,400494,'',0,'2','1','150','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:21:43',5,0.00,0.00,'2023-03-16','792','2023-03-17 12:23:29','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1611 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1610,'','1','150','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 14:07:03',5,'479','2020-08-13 14:07:03','479');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','150',13170,'771',4620.00,2.00,'2020-11-19','','2020-11-19 10:49:54','483','483',2020,'483','2020-11-19 10:49:54',5),('1','150',16351,'771',-1428.66,2764.00,'2021-09-08','new dipping','2021-09-08 14:53:26','483','483',2021,'483','2021-09-08 14:53:26',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2942 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','150','771',2142,'5','LPG NOZZLE ',1692290.29,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','150','771',2941,'5','LPG NOZZLE 2',345959.55,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258035 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','150',146984,'DAILY','2020-08-04','2020-08-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 13:13:51','507','2020-08-12 13:23:45',10,0),('1','150',147007,'DAILY','2020-08-04','2020-08-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 13:33:24','507','2020-08-12 13:34:05',10,0),('1','150',147030,'DAILY','2020-08-06','2020-08-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 14:11:37','507','2020-08-12 14:12:19',10,0),('1','150',147070,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 15:58:12','507','2020-08-12 15:58:41',10,0),('1','150',147079,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 16:15:47','507','2020-08-12 16:16:17',10,0),('1','150',147085,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 16:36:41','507','2020-08-12 16:37:10',10,0),('1','150',147092,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 16:51:02','507','2020-08-12 16:51:30',10,0),('1','150',147094,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 17:02:03','507','2020-08-12 17:03:24',10,0),('1','150',147099,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-12 17:20:03','507','2020-08-12 17:20:30',10,0),('1','150',147156,'DAILY','2020-08-12','2020-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-13 09:29:35','507','2020-08-13 09:30:01',10,0),('1','150',147305,'DAILY','2020-08-13','2020-08-13 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-13 18:52:49','507','2020-08-13 18:54:40',10,0),('1','150',147381,'DAILY','2020-08-14','2020-08-14 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-14 14:33:03','507','2020-08-14 14:33:38',10,0),('1','150',147508,'DAILY','2020-08-15','2020-08-15 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-15 14:10:55','507','2020-08-15 14:11:26',10,0),('1','150',147668,'DAILY','2020-08-16','2020-08-16 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-16 17:55:58','507','2020-08-16 17:56:29',10,0),('1','150',147861,'DAILY','2020-08-17','2020-08-17 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-17 18:51:38','507','2020-08-17 18:52:37',10,0),('1','150',147985,'DAILY','2020-08-18','2020-08-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-18 18:41:23','507','2020-08-18 18:41:47',10,0),('1','150',148004,'DAILY','2020-08-19','2020-08-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-19 08:45:47','507','2020-08-19 08:46:16',10,0),('1','150',148123,'DAILY','2020-08-19','2020-08-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-19 18:46:29','507','2020-08-19 18:47:09',10,0),('1','150',148271,'DAILY','2020-08-20','2020-08-20 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-20 18:35:47','507','2020-08-20 18:36:16',10,0),('1','150',148366,'DAILY','2020-08-21','2020-08-21 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-21 15:18:21','507','2020-08-21 15:18:48',10,0),('1','150',148555,'DAILY','2020-08-22','2020-08-22 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-22 18:43:18','507','2020-08-22 18:43:52',10,0),('1','150',148810,'DAILY','2020-08-24','2020-08-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-24 19:30:58','507','2020-08-24 19:31:27',10,0),('1','150',148966,'DAILY','2020-08-25','2020-08-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-25 19:06:16','507','2020-08-25 19:06:49',10,0),('1','150',149027,'DAILY','2020-08-26','2020-08-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-26 11:56:33','507','2020-08-26 11:57:06',10,0),('1','150',149034,'DAILY','2020-08-26','2020-08-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-26 12:11:35','507','2020-08-26 12:12:12',10,0),('1','150',149145,'DAILY','2020-08-26','2020-08-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-26 18:42:15','507','2020-08-26 18:42:46',10,0),('1','150',149300,'DAILY','2020-08-27','2020-08-27 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-27 18:51:39','507','2020-08-27 18:52:13',10,0),('1','150',149449,'DAILY','2020-08-28','2020-08-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-28 18:54:25','507','2020-08-28 18:54:54',10,0),('1','150',149601,'DAILY','2020-08-29','2020-08-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-29 21:09:21','507','2020-08-29 21:09:47',10,0),('1','150',149689,'DAILY','2020-08-30','2020-08-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-30 18:50:35','507','2020-08-30 18:51:03',10,0),('1','150',149753,'DAILY','2020-08-31','2020-08-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-31 11:28:26','507','2020-08-31 11:28:50',10,0),('1','150',149836,'DAILY','2020-08-31','2020-08-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-08-31 18:36:32','507','2020-08-31 18:37:13',10,0),('1','150',150030,'DAILY','2020-09-02','2020-09-02 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-02 09:14:09','507','2020-09-02 09:14:34',10,0),('1','150',150148,'DAILY','2020-09-02','2020-09-02 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-02 19:09:48','507','2020-09-02 19:10:14',10,0),('1','150',150315,'DAILY','2020-09-03','2020-09-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-03 15:29:38','507','2020-09-03 15:30:39',10,0),('1','150',150544,'DAILY','2020-09-04','2020-09-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-04 18:39:19','507','2020-09-04 18:39:44',10,0),('1','150',150654,'DAILY','2020-09-05','2020-09-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-05 14:14:54','507','2020-09-05 14:16:39',10,0),('1','150',150841,'DAILY','2020-09-06','2020-09-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-06 19:13:08','507','2020-09-06 19:13:33',10,0),('1','150',150987,'DAILY','2020-09-07','2020-09-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-07 18:39:57','507','2020-09-07 18:40:23',10,0),('1','150',151029,'DAILY','2020-09-08','2020-09-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-08 09:59:16','507','2020-09-08 09:59:40',10,0),('1','150',151136,'DAILY','2020-09-08','2020-09-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-08 18:45:51','507','2020-09-08 18:46:21',10,0),('1','150',151287,'DAILY','2020-09-09','2020-09-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-09 20:37:57','507','2020-09-09 20:38:31',10,0),('1','150',151423,'DAILY','2020-09-10','2020-09-10 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-10 18:39:25','507','2020-09-10 18:40:26',10,0),('1','150',151582,'DAILY','2020-09-11','2020-09-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-11 18:34:43','507','2020-09-11 18:35:13',10,0),('1','150',151663,'DAILY','2020-09-12','2020-09-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-12 14:22:23','507','2020-09-12 14:23:16',10,0),('1','150',151813,'DAILY','2020-09-13','2020-09-13 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-13 18:19:13','507','2020-09-13 18:19:38',10,0),('1','150',151990,'DAILY','2020-09-14','2020-09-14 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-14 17:39:58','507','2020-09-14 17:40:21',10,0),('1','150',152159,'DAILY','2020-09-15','2020-09-15 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-15 18:33:19','507','2020-09-15 18:33:56',10,0),('1','150',152306,'DAILY','2020-09-16','2020-09-16 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-16 16:53:49','507','2020-09-16 16:54:48',10,0),('1','150',152473,'DAILY','2020-09-17','2020-09-17 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-17 19:08:01','507','2020-09-17 19:08:24',10,0),('1','150',152608,'DAILY','2020-09-18','2020-09-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-18 19:03:19','507','2020-09-18 19:03:44',10,0),('1','150',152683,'DAILY','2020-09-19','2020-09-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-19 12:32:22','507','2020-09-19 12:32:52',10,0),('1','150',152889,'DAILY','2020-09-20','2020-09-20 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-20 18:57:29','507','2020-09-20 18:57:48',10,0),('1','150',153024,'DAILY','2020-09-21','2020-09-21 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-21 14:49:46','507','2020-09-21 14:50:28',10,0),('1','150',153260,'DAILY','2020-09-22','2020-09-22 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-22 18:57:37','507','2020-09-22 18:58:00',10,0),('1','150',153468,'DAILY','2020-09-23','2020-09-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-23 18:33:40','507','2020-09-23 18:34:04',10,0),('1','150',153530,'DAILY','2020-09-24','2020-09-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-24 09:57:36','507','2020-09-24 09:58:32',10,0),('1','150',153635,'DAILY','2020-09-24','2020-09-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-24 18:28:38','507','2020-09-24 18:29:01',10,0),('1','150',153795,'DAILY','2020-09-25','2020-09-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-26 14:19:08','507','2020-09-26 14:20:25',10,0),('1','150',153877,'DAILY','2020-09-26','2020-09-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-26 14:26:45','507','2020-09-26 14:27:06',10,0),('1','150',153916,'DAILY','2020-09-26','2020-09-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-26 18:34:27','507','2020-09-26 18:34:49',10,0),('1','150',154236,'DAILY','2020-09-28','2020-09-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-28 18:13:17','507','2020-09-28 18:13:40',10,0),('1','150',154415,'DAILY','2020-09-29','2020-09-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-29 20:10:38','507','2020-09-29 20:11:12',10,0),('1','150',154432,'DAILY','2020-09-30','2020-09-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-30 08:25:24','507','2020-09-30 08:25:48',10,0),('1','150',154589,'DAILY','2020-09-30','2020-09-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-09-30 20:57:03','507','2020-09-30 20:58:02',10,0),('1','150',154721,'DAILY','2020-10-01','2020-10-01 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-01 18:31:00','507','2020-10-01 18:31:28',10,0),('1','150',154849,'DAILY','2020-10-02','2020-10-02 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-02 16:36:09','507','2020-10-02 16:36:31',10,0),('1','150',155111,'DAILY','2020-10-04','2020-10-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-04 15:51:46','507','2020-10-04 15:52:07',10,0),('1','150',155299,'DAILY','2020-10-05','2020-10-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-05 18:46:01','507','2020-10-05 18:46:36',10,0),('1','150',155452,'DAILY','2020-10-06','2020-10-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-06 18:33:30','507','2020-10-06 18:33:55',10,0),('1','150',155635,'DAILY','2020-10-07','2020-10-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-07 19:30:10','507','2020-10-07 19:30:37',10,0),('1','150',155774,'DAILY','2020-10-08','2020-10-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-08 19:05:44','507','2020-10-08 19:06:12',10,0),('1','150',155936,'DAILY','2020-10-09','2020-10-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-09 21:44:41','507','2020-10-09 21:45:39',10,0),('1','150',156087,'DAILY','2020-10-10','2020-10-10 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-10 20:35:23','507','2020-10-10 20:35:55',10,0),('1','150',156112,'Daily ','2020-10-10','2020-10-10 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-11 07:52:16','507','2020-10-11 07:55:35',10,0),('1','150',156196,'DAILY','2020-10-11','2020-10-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-11 18:23:45','507','2020-10-11 18:24:15',10,0),('1','150',156407,'DAILY','2020-10-12','2020-10-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-12 18:16:25','507','2020-10-12 18:16:47',10,0),('1','150',156561,'DAILY','2020-10-13','2020-10-13 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-13 18:16:56','507','2020-10-13 18:17:16',10,0),('1','150',156646,'DAILY','2020-10-14','2020-10-14 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-14 12:26:12','507','2020-10-14 12:26:39',10,0),('1','150',157072,'DAILY','2020-10-16','2020-10-16 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-16 18:23:51','507','2020-10-16 18:24:12',10,0),('1','150',157268,'DAILY','2020-10-17','2020-10-17 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-17 18:45:33','507','2020-10-17 18:45:56',10,0),('1','150',157312,'DAILY','2020-10-18','2020-10-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-18 08:48:03','507','2020-10-18 08:48:37',10,0),('1','150',157441,'DAILY','2020-10-18','2020-10-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-18 18:20:54','507','2020-10-18 18:22:05',10,0),('1','150',157643,'DAILY','2020-10-19','2020-10-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-19 18:12:22','507','2020-10-19 18:13:15',10,0),('1','150',157804,'DAILY','2020-10-20','2020-10-20 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-20 17:53:52','507','2020-10-20 17:54:13',10,0),('1','150',158090,'DAILY','2020-10-22','2020-10-22 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-22 21:14:02','507','2020-10-22 21:14:59',10,0),('1','150',158252,'DAILY','2020-10-23','2020-10-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-23 18:08:28','507','2020-10-23 18:08:49',10,0),('1','150',158293,'DAILY','2020-10-24','2020-10-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-24 10:02:01','507','2020-10-24 10:02:22',10,0),('1','150',158414,'DAILY','2020-10-24','2020-10-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-24 18:13:12','507','2020-10-24 18:13:37',10,0),('1','150',158568,'DAILY','2020-10-25','2020-10-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-25 18:18:42','507','2020-10-25 18:19:02',10,0),('1','150',158625,'DAILY','2020-10-26','2020-10-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-26 10:13:39','507','2020-10-26 10:14:09',10,0),('1','150',158752,'DAILY','2020-10-26','2020-10-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-26 20:37:44','507','2020-10-26 20:38:05',10,0),('1','150',158932,'DAILY','2020-10-27','2020-10-27 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-27 18:13:22','507','2020-10-27 18:13:51',10,0),('1','150',158933,'DAILY','2020-10-27','2020-10-27 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-27 18:28:58','507','2020-10-27 18:29:19',10,0),('1','150',159114,'DAILY','2020-10-28','2020-10-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-28 18:49:51','507','2020-10-28 18:50:14',10,0),('1','150',159115,'DAILY','2020-10-28','2020-10-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-28 19:02:12','507','2020-10-28 19:02:38',10,0),('1','150',159265,'DAILY','2020-10-29','2020-10-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-29 18:18:59','507','2020-10-29 18:19:23',10,0),('1','150',159424,'DAILY','2020-10-30','2020-10-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-30 16:17:51','507','2020-10-30 16:18:15',10,0),('1','150',159428,'DAILY','2020-10-30','2020-10-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-30 16:30:18','507','2020-10-30 16:30:41',10,0),('1','150',159629,'DAILY','2020-10-31','2020-10-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-31 19:18:29','507','2020-10-31 19:18:48',10,0),('1','150',159630,'DAILY','2020-10-31','2020-10-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-10-31 19:23:25','507','2020-10-31 19:23:51',10,0),('1','150',159673,'DAILY','2020-11-01','2020-11-01 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-01 13:04:20','507','2020-11-01 13:04:45',10,0),('1','150',159674,'DAILY','2020-11-01','2020-11-01 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-01 19:04:22','507','2020-11-01 19:04:45',10,0),('1','150',159734,'DAILY','2020-11-01','2020-11-01 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-01 19:07:09','507','2020-11-01 19:07:29',10,0),('1','150',159930,'DAILY','2020-11-02','2020-11-02 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-02 18:13:12','507','2020-11-02 18:13:35',10,0),('1','150',159997,'DAILY','2020-11-03','2020-11-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-03 09:33:56','507','2020-11-03 09:34:20',10,0),('1','150',159999,'DAILY','2020-11-03','2020-11-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-03 09:42:00','507','2020-11-03 09:42:22',10,0),('1','150',160126,'DAILY','2020-11-03','2020-11-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-03 18:50:45','507','2020-11-03 18:51:07',10,0),('1','150',160308,'DAILY','2020-11-04','2020-11-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-04 18:42:54','507','2020-11-04 18:43:28',10,0),('1','150',160343,'DAILY','2020-11-05','2020-11-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-05 09:55:32','507','2020-11-05 09:56:03',10,0),('1','150',160347,'DAILY','2020-11-05','2020-11-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-05 10:04:59','507','2020-11-05 10:05:50',10,0),('1','150',160452,'DAILY','2020-11-05','2020-11-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-05 18:19:26','507','2020-11-05 18:19:50',10,0),('1','150',160586,'DAILY','2020-11-06','2020-11-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-06 18:11:51','507','2020-11-06 18:12:17',10,0),('1','150',160663,'DAILY','2020-11-07','2020-11-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-07 10:58:48','507','2020-11-07 10:59:28',10,0),('1','150',160665,'DAILY','2020-11-07','2020-11-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-07 11:21:32','507','2020-11-07 11:21:53',10,0),('1','150',160746,'DAILY','2020-11-07','2020-11-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-07 18:51:58','507','2020-11-07 18:52:45',10,0),('1','150',160889,'DAILY','2020-11-08','2020-11-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-08 18:43:12','507','2020-11-08 18:43:38',10,0),('1','150',160952,'DAILY','2020-11-09','2020-11-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-09 08:52:38','507','2020-11-09 08:53:09',10,0),('1','150',160956,'DAILY','2020-11-09','2020-11-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-09 09:01:20','507','2020-11-09 09:01:43',10,0),('1','150',161090,'DAILY','2020-11-09','2020-11-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-09 18:47:06','507','2020-11-09 18:47:37',10,0),('1','150',161285,'DAILY','2020-11-10','2020-11-10 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-10 21:16:16','507','2020-11-10 21:17:07',10,0),('1','150',161462,'DAILY','2020-11-11','2020-11-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-11 18:41:09','507','2020-11-11 18:41:30',10,0),('1','150',161465,'DAILY','2020-11-11','2020-11-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-11 18:58:30','507','2020-11-11 19:01:12',10,0),('1','150',161468,'DAILY','2020-11-11','2020-11-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-11 19:03:42','507','2020-11-11 19:04:09',10,0),('1','150',161660,'DAILY','2020-11-12','2020-11-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-12 18:42:03','507','2020-11-12 18:42:25',10,0),('1','150',161861,'DAILY','2020-11-13','2020-11-13 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-13 18:01:08','507','2020-11-13 18:01:31',10,0),('1','150',162239,'DAILY','2020-11-15','2020-11-15 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-15 18:51:43','507','2020-11-15 18:52:04',10,0),('1','150',162417,'DAILY','2020-11-16','2020-11-16 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-16 15:40:04','507','2020-11-16 15:40:25',10,0),('1','150',162890,'DAILY','2020-11-18','2020-11-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-19 11:10:57','507','2020-11-19 11:11:22',10,0),('1','150',162999,'DAILY','2020-11-19','2020-11-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-19 18:02:51','507','2020-11-19 18:03:12',10,0),('1','150',163199,'DAILY','2020-11-20','2020-11-20 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-20 18:06:03','507','2020-11-20 18:06:24',10,0),('1','150',163366,'DAILY','2020-11-21','2020-11-21 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-21 18:09:35','507','2020-11-21 18:10:10',10,0),('1','150',163545,'DAILY','2020-11-22','2020-11-22 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-22 18:45:06','507','2020-11-22 18:45:32',10,0),('1','150',163660,'DAILY','2020-11-23','2020-11-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-23 13:00:04','507','2020-11-23 13:01:17',10,0),('1','150',163741,'DAILY','2020-11-23','2020-11-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-23 18:40:36','507','2020-11-23 18:41:17',10,0),('1','150',163898,'DAILY','2020-11-24','2020-11-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-24 19:00:15','507','2020-11-24 19:00:39',10,0),('1','150',163991,'DAILY','2020-11-25','2020-11-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-25 12:56:09','507','2020-11-25 12:57:35',10,0),('1','150',164077,'DAILY','2020-11-25','2020-11-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-25 18:41:34','507','2020-11-25 18:41:57',10,0),('1','150',164256,'DAILY','2020-11-26','2020-11-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-26 18:41:54','507','2020-11-26 18:42:18',10,0),('1','150',164440,'DAILY','2020-11-27','2020-11-27 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-27 18:52:52','507','2020-11-27 18:53:19',10,0),('1','150',164600,'DAILY','2020-11-28','2020-11-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-28 18:37:30','507','2020-11-28 18:37:55',10,0),('1','150',164657,'DAILY','2020-11-29','2020-11-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-29 10:59:47','507','2020-11-29 11:00:10',10,0),('1','150',164795,'DAILY','2020-11-29','2020-11-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-11-30 08:37:16','507','2020-11-30 08:37:45',10,0),('1','150',164990,'DAILY','2020-11-30','2020-11-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-01 08:02:20','507','2020-12-01 08:02:40',10,0),('1','150',164993,'DAILY','2020-11-30','2020-11-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-01 08:15:24','507','2020-12-01 08:15:46',10,0),('1','150',165129,'DAILY','2020-12-01','2020-12-01 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-01 20:34:24','507','2020-12-01 20:34:48',10,0),('1','150',165306,'DAILY','2020-12-02','2020-12-02 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-02 19:16:53','507','2020-12-02 19:17:19',10,0),('1','150',165364,'DAILY','2020-12-03','2020-12-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-03 10:42:07','507','2020-12-03 10:42:33',10,0),('1','150',165438,'DAILY','2020-12-03','2020-12-03 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-03 18:15:18','507','2020-12-03 18:16:05',10,0),('1','150',165602,'DAILY','2020-12-04','2020-12-04 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-04 17:53:39','507','2020-12-04 17:54:00',10,0),('1','150',165791,'DAILY','2020-12-05','2020-12-05 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-05 18:39:39','507','2020-12-05 18:40:00',10,0),('1','150',165926,'DAILY','2020-12-06','2020-12-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-06 19:05:38','507','2020-12-06 19:05:56',10,0),('1','150',165966,'DAILY','2020-12-06','2020-12-06 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-07 08:07:59','507','2020-12-07 08:08:24',10,0),('1','150',166136,'DAILY','2020-12-07','2020-12-07 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-07 18:14:21','507','2020-12-07 18:14:45',10,0),('1','150',166229,'DAILY','2020-12-08','2020-12-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-08 11:50:55','507','2020-12-08 11:51:18',10,0),('1','150',166311,'DAILY','2020-12-08','2020-12-08 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-08 18:21:43','507','2020-12-08 18:22:02',10,0),('1','150',166486,'DAILY','2020-12-09','2020-12-09 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-09 18:14:31','507','2020-12-09 18:14:51',10,0),('1','150',166701,'DAILY','2020-12-10','2020-12-10 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-10 19:09:55','507','2020-12-10 19:10:31',10,0),('1','150',166885,'DAILY','2020-12-11','2020-12-11 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-12 09:12:23','507','2020-12-12 09:13:01',10,0),('1','150',166942,'DAILY','2020-12-12','2020-12-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-12 10:44:04','507','2020-12-12 10:44:32',10,0),('1','150',167054,'DAILY','2020-12-12','2020-12-12 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-13 07:06:11','507','2020-12-13 07:06:34',10,0),('1','150',167177,'DAILY','2020-12-13','2020-12-13 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-13 18:33:16','507','2020-12-13 18:34:03',10,0),('1','150',167374,'DAILY','2020-12-14','2020-12-14 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-14 19:08:55','507','2020-12-14 19:09:32',10,0),('1','150',167556,'DAILY','2020-12-15','2020-12-15 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-15 17:19:52','507','2020-12-15 17:20:24',10,0),('1','150',167743,'DAILY','2020-12-16','2020-12-16 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-16 21:20:37','507','2020-12-16 21:21:00',10,0),('1','150',167917,'DAILY','2020-12-17','2020-12-17 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-17 19:12:53','507','2020-12-17 19:13:17',10,0),('1','150',167995,'DAILY','2020-12-18','2020-12-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-18 12:01:38','507','2020-12-18 12:01:59',10,0),('1','150',168106,'DAILY','2020-12-18','2020-12-18 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-18 18:07:40','507','2020-12-18 18:08:01',10,0),('1','150',168278,'DAILY','2020-12-19','2020-12-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-19 17:54:49','507','2020-12-19 17:55:12',10,0),('1','150',168404,'DAILY','2020-12-20','2020-12-20 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-20 18:14:47','507','2020-12-20 18:15:13',10,0),('1','150',168612,'DAILY','2020-12-21','2020-12-21 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-21 18:59:49','507','2020-12-21 19:00:12',10,0),('1','150',168641,'DAILY','2020-12-21','2020-12-21 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-22 08:21:10','507','2020-12-22 08:21:31',10,0),('1','150',168772,'DAILY','2020-12-22','2020-12-22 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-22 18:52:36','507','2020-12-22 18:53:00',10,0),('1','150',168916,'DAILY','2020-12-23','2020-12-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-23 16:59:49','507','2020-12-23 17:01:18',10,0),('1','150',168933,'DAILY','2020-12-23','2020-12-23 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-23 18:52:57','507','2020-12-23 18:53:27',10,0),('1','150',169119,'Daily ','2020-12-24','2020-12-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-24 21:17:31','507','2020-12-24 21:18:03',10,0),('1','150',169121,'Daily ','2020-12-24','2020-12-24 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-24 21:31:58','507','2020-12-24 21:32:18',10,0),('1','150',169268,'DAILY','2020-12-25','2020-12-25 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-25 18:53:41','507','2020-12-25 18:54:04',10,0),('1','150',169504,'DAILY','2020-12-26','2020-12-26 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-27 11:48:01','507','2020-12-27 11:48:25',10,0),('1','150',169772,'DAILY','2020-12-28','2020-12-28 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-28 19:54:25','507','2020-12-28 19:54:56',10,0),('1','150',169936,'DAILY','2020-12-29','2020-12-29 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-29 20:39:28','507','2020-12-29 20:39:54',10,0),('1','150',170008,'DAILY','2020-12-19','2020-12-19 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-30 11:25:01','507','2020-12-30 11:25:24',10,0),('1','150',170154,'DAILY','2020-12-30','2020-12-30 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-30 21:10:40','507','2020-12-30 21:10:59',10,0),('1','150',170287,'DAILY','2020-12-31','2020-12-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-31 15:31:12','507','2020-12-31 15:31:33',10,0),('1','150',170330,'DAILY','2020-12-31','2020-12-31 00:00:00',NULL,'507',0.00,0.00,'507','2020-12-31 19:02:37','507','2020-12-31 19:03:16',10,0),('1','150',170482,'DAILY','2021-01-01','2021-01-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-01 18:10:56','507','2021-01-01 18:11:18',10,0),('1','150',170655,'DAILY','2021-01-02','2021-01-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-02 18:57:28','507','2021-01-02 18:57:49',10,0),('1','150',170659,'DAILY','2021-01-02','2021-01-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-02 19:10:36','507','2021-01-02 19:10:58',10,0),('1','150',170810,'DAILY','2021-01-03','2021-01-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-03 18:53:07','507','2021-01-03 18:53:32',10,0),('1','150',170985,'DAILY','2021-01-04','2021-01-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-04 18:57:44','507','2021-01-04 18:58:12',10,0),('1','150',171206,'DAILY','2021-01-05','2021-01-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-05 18:59:33','507','2021-01-05 19:00:31',10,0),('1','150',171359,'Daily ','2021-01-06','2021-01-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-06 18:41:51','507','2021-01-06 18:42:09',10,0),('1','150',171575,'DAILY','2021-01-07','2021-01-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-07 18:59:45','507','2021-01-07 19:00:04',10,0),('1','150',171759,'DAILY','2021-01-08','2021-01-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-08 18:15:48','507','2021-01-08 18:16:10',10,0),('1','150',171952,'DAILY','2021-01-09','2021-01-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-09 21:20:04','507','2021-01-09 21:21:05',10,0),('1','150',172075,'DAILY','2021-01-10','2021-01-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-10 18:17:28','507','2021-01-10 18:19:56',10,0),('1','150',172080,'DAILY','2021-01-10','2021-01-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-10 19:16:43','507','2021-01-10 19:17:06',10,0),('1','150',172273,'DAILY','2021-01-11','2021-01-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-11 19:00:28','507','2021-01-11 19:00:50',10,0),('1','150',172440,'DAILY','2021-01-12','2021-01-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-12 16:01:47','507','2021-01-12 16:03:20',10,0),('1','150',172697,'DAILY','2021-01-13','2021-01-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-13 18:57:48','507','2021-01-13 18:58:12',10,0),('1','150',172837,'DAILY','2021-01-14','2021-01-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-14 15:40:03','507','2021-01-14 15:40:24',10,0),('1','150',173043,'DAILY','2021-01-15','2021-01-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-15 18:28:50','507','2021-01-15 18:29:11',10,0),('1','150',173202,'DAILY','2021-01-16','2021-01-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-16 18:15:21','507','2021-01-16 18:15:42',10,0),('1','150',173385,'DAILY','2021-01-17','2021-01-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-17 20:50:48','507','2021-01-17 20:51:21',10,0),('1','150',173566,'DAILY','2021-01-18','2021-01-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-18 16:42:57','507','2021-01-18 16:43:16',10,0),('1','150',173757,'DAILY','2021-01-19','2021-01-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-19 19:06:21','507','2021-01-19 19:06:57',10,0),('1','150',173936,'DAILY','2021-01-20','2021-01-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-20 18:54:21','507','2021-01-20 18:54:44',10,0),('1','150',174123,'DAILY','2021-01-21','2021-01-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-21 18:54:49','507','2021-01-21 18:55:13',10,0),('1','150',174313,'DAILY','2021-01-22','2021-01-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-22 18:54:42','507','2021-01-22 18:55:06',10,0),('1','150',174480,'DAILY','2021-01-23','2021-01-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-23 18:58:19','507','2021-01-23 19:01:15',10,0),('1','150',174597,'DAILY','2021-01-24','2021-01-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-24 16:09:50','507','2021-01-24 16:10:13',10,0),('1','150',174631,'DAILY','2021-01-24','2021-01-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-24 18:56:05','507','2021-01-24 18:56:26',10,0),('1','150',174833,'DAILY','2021-01-25','2021-01-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-25 18:44:51','507','2021-01-25 18:45:14',10,0),('1','150',174998,'DAILY','2021-01-26','2021-01-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-26 15:51:58','507','2021-01-26 15:52:40',10,0),('1','150',175041,'DAILY','2021-01-26','2021-01-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-26 21:19:45','507','2021-01-26 21:20:17',10,0),('1','150',175232,'DAILY','2021-01-27','2021-01-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-27 19:24:10','507','2021-01-27 19:24:34',10,0),('1','150',175411,'DAILY','2021-01-28','2021-01-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-28 19:34:31','507','2021-01-28 19:34:57',10,0),('1','150',175571,'DAILY','2021-01-29','2021-01-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-29 17:14:16','507','2021-01-29 17:14:39',10,0),('1','150',175749,'DAILY','2021-01-30','2021-01-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-30 19:34:19','507','2021-01-30 19:34:43',10,0),('1','150',175833,'DAILY','2021-01-31','2021-01-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-31 12:04:50','507','2021-01-31 12:05:11',10,0),('1','150',175913,'DAILY','2021-01-31','2021-01-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-01-31 19:30:46','507','2021-01-31 19:31:08',10,0),('1','150',176136,'DAILY','2021-02-01','2021-02-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-01 19:03:22','507','2021-02-01 19:03:44',10,0),('1','150',176320,'DAILY','2021-02-02','2021-02-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-02 19:31:52','507','2021-02-02 19:32:14',10,0),('1','150',176505,'DAILY','2021-02-03','2021-02-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-03 16:14:22','507','2021-02-03 16:14:52',10,0),('1','150',176760,'DAILY','2021-02-04','2021-02-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-04 19:37:06','507','2021-02-04 19:37:26',10,0),('1','150',176925,'DAILY','2021-02-05','2021-02-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-05 16:30:29','507','2021-02-05 16:30:53',10,0),('1','150',177211,'DAILY','2021-02-06','2021-02-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-06 19:28:35','507','2021-02-06 19:28:57',10,0),('1','150',177414,'DAILY','2021-02-07','2021-02-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-07 19:37:34','507','2021-02-07 19:37:56',10,0),('1','150',177417,'DAILY','2021-02-07','2021-02-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-07 19:47:00','507','2021-02-07 19:47:25',10,0),('1','150',177651,'DAILY','2021-02-08','2021-02-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-09 07:55:29','507','2021-02-09 07:55:55',10,0),('1','150',177869,'DAILY','2021-02-09','2021-02-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-09 19:05:04','507','2021-02-09 19:05:27',10,0),('1','150',178064,'DAILY','2021-02-10','2021-02-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-10 19:13:00','507','2021-02-10 19:13:21',10,0),('1','150',178179,'DAILY','2021-02-11','2021-02-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-11 12:38:14','507','2021-02-11 12:38:39',10,0),('1','150',178281,'DAILY','2021-02-11','2021-02-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-11 19:27:45','507','2021-02-11 19:28:11',10,0),('1','150',178467,'DAILY','2021-02-12','2021-02-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-12 18:31:31','507','2021-02-12 18:31:52',10,0),('1','150',178593,'DAILY','2021-02-13','2021-02-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-13 12:02:24','507','2021-02-13 12:02:50',10,0),('1','150',178699,'DAILY','2021-02-13','2021-02-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-13 18:35:16','507','2021-02-13 18:35:41',10,0),('1','150',178867,'DAILY','2021-02-14','2021-02-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-14 17:45:10','507','2021-02-14 17:45:34',10,0),('1','150',179113,'DAILY','2021-02-15','2021-02-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-15 19:39:14','507','2021-02-15 19:39:40',10,0),('1','150',179217,'DAILY','2021-02-16','2021-02-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-16 18:38:36','507','2021-02-16 18:39:52',10,0),('1','150',179362,'DAILY','2021-02-17','2021-02-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-17 11:56:29','507','2021-02-17 11:56:56',10,0),('1','150',179453,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-17 18:37:09','507','2021-02-17 18:37:35',10,0),('1','150',179573,'DAILY','2021-02-18','2021-02-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-18 18:35:25','507','2021-02-18 18:35:52',10,0),('1','150',179769,'DAILY','2021-02-19','2021-02-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-19 14:40:00','507','2021-02-19 14:40:24',10,0),('1','150',179914,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-19 19:03:20','507','2021-02-19 19:03:53',10,0),('1','150',179989,'DAILY','2021-02-20','2021-02-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-20 18:58:08','507','2021-02-20 18:58:36',10,0),('1','150',180169,'DAILY','2021-02-21','2021-02-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-21 11:05:52','507','2021-02-21 11:06:20',10,0),('1','150',180237,'DAILY','2021-02-21','2021-02-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-21 18:42:28','507','2021-02-21 18:43:00',10,0),('1','150',180335,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-22 19:47:34','507','2021-02-22 19:48:18',10,0),('1','150',180543,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-23 09:48:31','507','2021-02-23 09:49:04',10,0),('1','150',180625,'DAILY','2021-02-23','2021-02-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-23 18:34:53','507','2021-02-23 18:35:22',10,0),('1','150',180732,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-24 18:51:35','507','2021-02-24 18:52:16',10,0),('1','150',180955,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-25 15:43:33','507','2021-02-25 15:43:55',10,0),('1','150',181127,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-26 18:35:00','507','2021-02-26 18:35:27',10,0),('1','150',181332,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-27 16:27:43','507','2021-02-27 16:28:12',10,0),('1','150',181519,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-02-28 18:32:40','507','2021-02-28 18:33:17',10,0),('1','150',181698,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-01 10:22:57','507','2021-03-01 10:24:10',10,0),('1','150',181777,'DAILY','2021-03-01','2021-03-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-01 18:31:12','507','2021-03-01 18:31:43',10,0),('1','150',181900,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-02 19:20:44','507','2021-03-02 19:21:04',10,0),('1','150',182291,'DAILY','2021-03-03','2021-03-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-03 18:28:28','507','2021-03-03 18:29:02',10,0),('1','150',182293,'DAILY','2021-03-03','2021-03-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-03 19:08:48','507','2021-03-03 19:09:07',10,0),('1','150',182304,'DAILY','2021-03-04','2021-03-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-04 18:39:02','507','2021-03-04 18:42:49',10,0),('1','150',182489,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 12:08:41','507','2021-03-08 12:09:04',10,0),('1','150',183094,'DAILY','2021-03-06','2021-03-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 12:30:07','507','2021-03-08 12:30:26',10,0),('1','150',183097,'DAILY','2021-03-06','2021-03-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 12:38:41','507','2021-03-08 12:39:06',10,0),('1','150',183102,'DAILY','2021-03-07','2021-03-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 12:44:53','507','2021-03-08 12:45:18',10,0),('1','150',183103,'DAILY','2021-03-08','2021-03-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 12:50:57','507','2021-03-08 12:51:24',10,0),('1','150',183107,'DAILY','2021-03-08','2021-03-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-08 18:33:44','507','2021-03-08 18:34:05',10,0),('1','150',183224,'Daily ','2021-03-09','2021-03-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-09 18:22:20','507','2021-03-09 18:22:42',10,0),('1','150',183443,'Daily ','2021-03-10','2021-03-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-10 10:30:47','507','2021-03-10 10:31:08',10,0),('1','150',183498,'DAILY','2021-03-10','2021-03-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-10 18:20:38','507','2021-03-10 18:21:00',10,0),('1','150',183636,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-11 19:28:18','507','2021-03-11 19:28:54',10,0),('1','150',183919,'DAILY','2021-03-12','2021-03-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-12 18:24:08','507','2021-03-12 18:24:45',10,0),('1','150',184443,'Daily ','2021-03-13','2021-03-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-14 20:24:40','507','2021-03-14 20:25:02',10,0),('1','150',184444,'Daily ','2021-03-14','2021-03-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-14 20:41:13','507','2021-03-14 20:41:31',10,0),('1','150',184530,'DAILY','2021-03-15','2021-03-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-15 18:35:49','507','2021-03-15 18:36:25',10,0),('1','150',184675,'DAILY','2021-03-16','2021-03-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-16 14:11:12','507','2021-03-16 14:11:35',10,0),('1','150',184821,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-16 18:59:23','507','2021-03-16 18:59:49',10,0),('1','150',184869,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-17 19:04:34','507','2021-03-17 19:05:07',10,0),('1','150',185095,'DAILY','2021-03-18','2021-03-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-19 05:44:59','507','2021-03-19 05:45:42',10,0),('1','150',185253,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-19 08:20:11','507','2021-03-19 08:20:35',10,0),('1','150',185295,'DAILY','2021-03-19','2021-03-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-19 18:31:14','507','2021-03-19 18:31:40',10,0),('1','150',185456,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-20 18:50:22','507','2021-03-20 18:50:45',10,0),('1','150',185667,'DAILY','2021-03-21','2021-03-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-21 11:45:02','507','2021-03-21 11:45:20',10,0),('1','150',185776,'DAILY','2021-03-21','2021-03-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-21 18:48:58','507','2021-03-21 18:49:20',10,0),('1','150',185864,'DAILY SHIP','2021-03-22','2021-03-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-22 18:36:51','507','2021-03-22 18:37:47',10,0),('1','150',186077,'DAILY SHIf','2021-03-23','2021-03-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-23 12:14:41','507','2021-03-23 12:15:04',10,0),('1','150',186250,'DAILY SHIf','2021-03-23','2021-03-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-23 18:37:14','507','2021-03-23 18:38:16',10,0),('1','150',186307,'DAILY SHIf','2021-03-24','2021-03-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-24 18:44:21','507','2021-03-24 18:44:49',10,0),('1','150',186522,'DAILY SHIF','2021-03-25','2021-03-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-25 13:30:11','507','2021-03-25 13:30:39',10,0),('1','150',186663,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-25 18:44:45','507','2021-03-25 18:45:10',10,0),('1','150',186741,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-26 19:17:20','507','2021-03-26 19:17:48',10,0),('1','150',186970,'DAILY SHIF','2021-03-27','2021-03-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-27 18:40:31','507','2021-03-27 18:40:51',10,0),('1','150',187132,'DAILY SHIf','2021-03-27','2021-03-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-27 18:54:48','507','2021-03-27 18:55:09',10,0),('1','150',187304,'DAILY SHIf','2021-03-28','2021-03-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-28 18:31:25','507','2021-03-28 18:31:46',10,0),('1','150',187534,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-29 17:36:20','507','2021-03-29 17:36:47',10,0),('1','150',187540,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-29 18:51:15','507','2021-03-29 18:51:31',10,0),('1','150',187565,'DAILY SHIF','2021-03-30','2021-03-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-30 18:15:09','507','2021-03-30 18:15:30',10,0),('1','150',187787,'DAILY SHIF','2021-03-31','2021-03-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-03-31 13:57:57','507','2021-03-31 13:58:21',10,0),('1','150',187984,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-01 08:11:35','507','2021-04-01 08:11:57',10,0),('1','150',188049,'DAILY SHIf','2021-04-01','2021-04-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-01 18:27:05','507','2021-04-01 18:27:34',10,0),('1','150',188200,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-02 09:02:07','507','2021-04-02 09:02:38',10,0),('1','150',188271,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-02 18:49:27','507','2021-04-02 18:49:56',10,0),('1','150',188415,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-03 15:13:50','507','2021-04-03 15:14:27',10,0),('1','150',188630,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-04 18:27:03','507','2021-04-04 18:27:34',10,0),('1','150',188799,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-05 17:27:32','507','2021-04-05 17:28:17',10,0),('1','150',188999,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-06 18:31:09','507','2021-04-06 18:31:39',10,0),('1','150',189192,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-07 18:50:51','507','2021-04-07 18:51:42',10,0),('1','150',189413,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-08 09:17:15','507','2021-04-08 09:17:51',10,0),('1','150',189487,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-08 18:17:08','507','2021-04-08 18:17:41',10,0),('1','150',189611,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-09 18:20:46','507','2021-04-09 18:21:17',10,0),('1','150',189804,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-10 11:43:50','507','2021-04-10 11:44:35',10,0),('1','150',189913,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-10 18:31:24','507','2021-04-10 18:32:06',10,0),('1','150',190025,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-11 18:55:28','507','2021-04-11 18:55:50',10,0),('1','150',190204,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-12 10:20:00','507','2021-04-12 10:20:27',10,0),('1','150',190296,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-12 19:23:20','507','2021-04-12 19:23:49',10,0),('1','150',190425,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-13 18:49:42','507','2021-04-13 18:50:04',10,0),('1','150',190662,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-14 08:49:53','507','2021-04-14 08:50:36',10,0),('1','150',190708,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-14 18:33:29','507','2021-04-14 18:34:04',10,0),('1','150',190880,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-15 18:37:30','507','2021-04-15 18:37:55',10,0),('1','150',191081,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-16 13:12:17','507','2021-04-16 13:12:39',10,0),('1','150',191200,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-16 18:43:12','507','2021-04-16 18:43:33',10,0),('1','150',191283,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-17 18:40:30','507','2021-04-17 18:40:54',10,0),('1','150',191541,'DAILY','2021-04-18','2021-04-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-18 09:57:11','507','2021-04-18 10:26:07',10,0),('1','150',191548,'DAILY','2021-04-18','2021-04-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-18 10:30:20','507','2021-04-18 10:30:42',10,0),('1','150',191551,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-18 18:40:22','507','2021-04-18 18:40:57',10,0),('1','150',191717,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-19 19:43:28','507','2021-04-19 19:43:54',10,0),('1','150',191930,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-20 12:00:12','507','2021-04-20 12:00:36',10,0),('1','150',192028,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-20 18:41:06','507','2021-04-20 18:41:29',10,0),('1','150',192123,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-21 19:22:31','507','2021-04-21 19:23:02',10,0),('1','150',192366,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-22 15:55:31','507','2021-04-22 15:56:12',10,0),('1','150',192556,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-23 18:50:37','507','2021-04-23 18:51:03',10,0),('1','150',192758,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-24 18:35:04','507','2021-04-24 18:35:37',10,0),('1','150',192951,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-25 18:42:48','507','2021-04-25 18:43:30',10,0),('1','150',193160,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-26 16:15:38','507','2021-04-26 16:16:16',10,0),('1','150',193400,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-27 18:45:33','507','2021-04-27 18:46:02',10,0),('1','150',193641,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-28 16:35:56','507','2021-04-28 16:36:31',10,0),('1','150',193846,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-29 19:51:44','507','2021-04-29 19:53:14',10,0),('1','150',194084,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-04-30 15:55:27','507','2021-04-30 15:55:59',10,0),('1','150',194288,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-01 19:52:58','507','2021-05-01 19:53:31',10,0),('1','150',194517,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-02 08:21:03','507','2021-05-02 08:21:29',10,0),('1','150',194536,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-02 19:38:13','507','2021-05-02 19:38:39',10,0),('1','150',194667,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-03 15:09:08','507','2021-05-03 15:09:34',10,0),('1','150',194893,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-04 19:18:40','507','2021-05-04 19:19:05',10,0),('1','150',195080,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-05 11:21:27','507','2021-05-05 11:21:50',10,0),('1','150',195204,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-05 18:46:05','507','2021-05-05 18:46:34',10,0),('1','150',195293,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-06 18:52:18','507','2021-05-06 18:52:47',10,0),('1','150',195556,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-07 18:32:50','507','2021-05-07 18:33:12',10,0),('1','150',195774,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-08 18:17:25','507','2021-05-08 18:18:06',10,0),('1','150',196000,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-09 19:46:58','507','2021-05-09 19:47:25',10,0),('1','150',196220,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-10 16:04:02','507','2021-05-10 16:04:31',10,0),('1','150',196437,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-11 18:37:29','507','2021-05-11 18:38:19',10,0),('1','150',196654,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-12 12:52:51','507','2021-05-12 12:53:38',10,0),('1','150',196805,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-12 20:53:24','507','2021-05-12 20:53:51',10,0),('1','150',196919,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-13 18:45:19','507','2021-05-13 18:45:44',10,0),('1','150',197027,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-16 12:09:21','507','2021-05-16 12:09:43',10,0),('1','150',197343,'Daily ','2021-05-16','2021-05-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-16 12:30:21','507','2021-05-16 12:30:41',10,0),('1','150',197346,'Daily ','2021-05-16','2021-05-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-17 06:36:21','507','2021-05-17 06:36:44',10,0),('1','150',197824,'Daily shift','2021-05-17','2021-05-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-17 18:45:44','507','2021-05-17 18:46:06',10,0),('1','150',197865,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-18 18:43:13','507','2021-05-18 18:47:42',10,0),('1','150',198166,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-19 18:32:18','507','2021-05-19 18:32:42',10,0),('1','150',198338,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-20 18:45:20','507','2021-05-20 18:45:49',10,0),('1','150',198562,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-21 08:24:42','507','2021-05-21 08:25:02',10,0),('1','150',198637,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-21 18:50:05','507','2021-05-21 18:51:20',10,0),('1','150',198772,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-22 18:28:32','507','2021-05-22 18:29:00',10,0),('1','150',199013,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-23 20:39:44','507','2021-05-23 20:40:18',10,0),('1','150',199271,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-24 18:39:04','507','2021-05-24 18:39:38',10,0),('1','150',199455,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-25 18:48:15','507','2021-05-25 18:49:01',10,0),('1','150',199630,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-26 19:15:47','507','2021-05-26 19:16:07',10,0),('1','150',199861,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-27 18:52:08','507','2021-05-27 18:52:36',10,0),('1','150',200085,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-28 17:38:28','507','2021-05-28 17:38:55',10,0),('1','150',200283,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-30 05:51:01','507','2021-05-30 05:51:24',10,0),('1','150',200488,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-30 12:47:48','507','2021-05-30 12:48:06',10,0),('1','150',200599,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-30 18:49:11','507','2021-05-30 18:49:49',10,0),('1','150',200686,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-05-31 18:57:59','507','2021-05-31 18:59:05',10,0),('1','150',200912,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-01 08:42:21','507','2021-06-01 08:42:48',10,0),('1','150',200985,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-01 19:24:13','507','2021-06-01 19:24:42',10,0),('1','150',201100,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-02 16:53:06','507','2021-06-02 16:54:07',10,0),('1','150',201302,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-03 18:37:17','507','2021-06-03 18:37:37',10,0),('1','150',201491,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-04 18:40:18','507','2021-06-04 18:40:45',10,0),('1','150',201756,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-05 19:15:59','507','2021-06-05 19:18:50',10,0),('1','150',202020,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-06 10:26:40','507','2021-06-06 10:27:12',10,0),('1','150',202145,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-06 18:52:48','507','2021-06-06 18:53:19',10,0),('1','150',202202,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-07 19:18:58','507','2021-06-07 19:19:21',10,0),('1','150',202421,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-08 08:33:09','507','2021-06-08 08:33:28',10,0),('1','150',202490,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-08 18:53:21','507','2021-06-08 18:53:45',10,0),('1','150',202639,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-09 17:57:21','507','2021-06-09 17:57:44',10,0),('1','150',202838,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-10 19:00:52','507','2021-06-10 19:01:40',10,0),('1','150',203104,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-11 16:08:36','507','2021-06-11 16:08:59',10,0),('1','150',203297,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-13 05:37:53','507','2021-06-13 05:38:15',10,0),('1','150',203517,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-13 12:31:06','507','2021-06-13 12:31:30',10,0),('1','150',203631,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-13 18:35:42','507','2021-06-13 18:36:09',10,0),('1','150',203723,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-14 18:44:32','507','2021-06-14 18:45:28',10,0),('1','150',203954,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-15 08:07:34','507','2021-06-15 08:08:11',10,0),('1','150',204005,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-15 18:38:30','507','2021-06-15 18:39:32',10,0),('1','150',204181,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-16 19:17:04','507','2021-06-16 19:17:50',10,0),('1','150',204386,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-17 10:39:53','507','2021-06-17 10:40:19',10,0),('1','150',204515,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-18 05:24:02','507','2021-06-18 05:25:10',10,0),('1','150',204607,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-18 18:36:24','507','2021-06-18 18:36:59',10,0),('1','150',204830,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-19 11:26:59','507','2021-06-19 11:27:23',10,0),('1','150',204941,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-19 18:32:40','507','2021-06-19 18:33:32',10,0),('1','150',205033,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-20 19:29:36','507','2021-06-20 19:30:06',10,0),('1','150',205313,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-21 19:14:28','507','2021-06-21 19:15:15',10,0),('1','150',205698,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-22 19:16:41','507','2021-06-22 19:17:15',10,0),('1','150',205797,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-23 19:03:26','507','2021-06-23 19:03:51',10,0),('1','150',205934,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-24 16:27:29','507','2021-06-24 16:27:53',10,0),('1','150',206142,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-25 18:39:02','507','2021-06-25 18:39:52',10,0),('1','150',206354,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-26 15:53:19','507','2021-06-26 15:53:50',10,0),('1','150',206511,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-26 18:55:34','507','2021-06-26 18:56:04',10,0),('1','150',206564,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-27 19:32:32','507','2021-06-27 19:33:28',10,0),('1','150',206785,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-28 19:25:19','507','2021-06-28 19:27:27',10,0),('1','150',207013,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-29 19:31:25','507','2021-06-29 19:32:05',10,0),('1','150',207345,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-06-30 18:47:14','507','2021-06-30 18:47:52',10,0),('1','150',207511,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-01 10:46:54','507','2021-07-01 10:47:20',10,0),('1','150',207573,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-01 19:25:43','507','2021-07-01 19:26:40',10,0),('1','150',207691,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-02 16:42:27','507','2021-07-02 16:43:16',10,0),('1','150',207998,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-03 19:57:05','507','2021-07-03 19:58:06',10,0),('1','150',208148,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-04 08:32:40','507','2021-07-04 08:33:07',10,0),('1','150',208163,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-04 19:33:18','507','2021-07-04 19:35:01',10,0),('1','150',208349,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-05 15:33:42','507','2021-07-05 15:34:33',10,0),('1','150',208507,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-05 19:49:29','507','2021-07-05 19:49:51',10,0),('1','150',208562,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-06 18:59:28','507','2021-07-06 19:00:13',10,0),('1','150',208749,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-07 09:40:51','507','2021-07-07 09:41:21',10,0),('1','150',208851,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-07 19:15:16','507','2021-07-07 19:15:39',10,0),('1','150',208997,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-08 06:20:55','507','2021-07-08 06:21:20',10,0),('1','150',208998,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-08 19:08:57','507','2021-07-08 19:09:42',10,0),('1','150',209281,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-09 09:40:32','507','2021-07-09 09:40:57',10,0),('1','150',209286,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-09 18:56:41','507','2021-07-09 18:57:28',10,0),('1','150',209427,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-10 20:24:41','507','2021-07-10 20:25:27',10,0),('1','150',209635,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-11 19:52:48','507','2021-07-11 19:53:53',10,0),('1','150',209860,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-12 17:26:53','507','2021-07-12 17:27:21',10,0),('1','150',210092,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-13 19:32:53','507','2021-07-13 19:35:14',10,0),('1','150',210300,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-14 16:47:42','507','2021-07-14 16:48:11',10,0),('1','150',210553,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-15 19:38:16','507','2021-07-15 19:38:52',10,0),('1','150',210772,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-16 18:38:39','507','2021-07-16 18:39:10',10,0),('1','150',210940,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-17 20:12:24','507','2021-07-17 20:14:32',10,0),('1','150',211215,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-18 13:43:30','507','2021-07-18 13:44:01',10,0),('1','150',211301,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-18 20:06:03','507','2021-07-18 20:07:02',10,0),('1','150',211362,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-19 20:03:26','507','2021-07-19 20:04:21',10,0),('1','150',211643,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-20 17:14:26','507','2021-07-20 17:15:18',10,0),('1','150',211771,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-21 18:45:38','507','2021-07-21 18:46:11',10,0),('1','150',212021,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-22 16:02:16','507','2021-07-22 16:02:53',10,0),('1','150',212219,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-23 18:39:45','507','2021-07-23 18:40:45',10,0),('1','150',212449,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-24 18:48:58','507','2021-07-24 18:49:37',10,0),('1','150',212657,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-25 19:19:38','507','2021-07-25 19:21:35',10,0),('1','150',212867,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-26 19:35:32','507','2021-07-26 19:37:02',10,0),('1','150',213200,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-27 19:02:24','507','2021-07-27 19:03:03',10,0),('1','150',213443,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-28 19:44:30','507','2021-07-28 19:45:24',10,0),('1','150',213675,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-29 19:43:31','507','2021-07-29 19:44:59',10,0),('1','150',213872,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-30 14:04:23','507','2021-07-30 14:06:50',10,0),('1','150',214018,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-30 20:02:12','507','2021-07-30 20:03:39',10,0),('1','150',214126,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-07-31 20:11:06','507','2021-07-31 20:11:32',10,0),('1','150',214363,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-01 11:27:24','507','2021-08-01 11:27:47',10,0),('1','150',214415,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-01 20:05:50','507','2021-08-01 20:06:27',10,0),('1','150',214515,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-02 17:49:23','507','2021-08-02 17:51:03',10,0),('1','150',214764,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-03 19:50:44','507','2021-08-03 19:52:18',10,0),('1','150',214990,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-04 11:00:12','507','2021-08-04 11:01:00',10,0),('1','150',215087,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-04 19:25:00','507','2021-08-04 19:25:33',10,0),('1','150',215219,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-05 19:27:11','507','2021-08-05 19:29:47',10,0),('1','150',215434,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-06 09:42:32','507','2021-08-06 09:43:07',10,0),('1','150',215515,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-06 18:52:06','507','2021-08-06 18:53:25',10,0),('1','150',215668,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-08 08:41:39','507','2021-08-08 08:42:14',10,0),('1','150',215942,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-08 19:53:16','507','2021-08-08 19:53:58',10,0),('1','150',216090,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-09 20:54:45','507','2021-08-09 20:56:12',10,0),('1','150',216311,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-10 08:53:26','507','2021-08-10 08:54:49',10,0),('1','150',216383,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-10 19:48:57','507','2021-08-10 19:50:07',10,0),('1','150',216542,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-11 17:20:16','507','2021-08-11 17:20:49',10,0),('1','150',216827,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-12 19:48:04','507','2021-08-12 19:49:31',10,0),('1','150',217053,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-13 12:30:17','507','2021-08-13 12:30:58',10,0),('1','150',217157,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-13 18:51:45','507','2021-08-13 18:52:25',10,0),('1','150',217275,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-14 20:00:13','507','2021-08-14 20:01:39',10,0),('1','150',217496,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-15 10:46:01','507','2021-08-15 10:47:05',10,0),('1','150',217558,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-15 19:03:14','507','2021-08-15 19:06:41',10,0),('1','150',217704,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-16 20:00:50','507','2021-08-16 20:03:23',10,0),('1','150',217972,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-17 09:09:36','507','2021-08-17 09:10:02',10,0),('1','150',218045,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-17 19:27:31','507','2021-08-17 19:28:57',10,0),('1','150',218213,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-18 19:24:09','507','2021-08-18 19:25:59',10,0),('1','150',218435,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-19 09:51:50','507','2021-08-19 09:53:08',10,0),('1','150',218535,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-19 18:43:21','507','2021-08-19 18:45:43',10,0),('1','150',218675,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-20 19:36:54','507','2021-08-20 19:37:36',10,0),('1','150',218895,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-21 08:16:02','507','2021-08-21 08:16:26',10,0),('1','150',218936,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-21 19:23:27','507','2021-08-22 05:28:22',10,0),('1','150',219109,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-22 19:24:26','507','2021-08-22 19:25:21',10,0),('1','150',219321,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-23 18:36:51','507','2021-08-23 18:37:32',10,0),('1','150',219581,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-24 18:55:27','507','2021-08-24 18:55:52',10,0),('1','150',219799,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-25 09:04:55','507','2021-08-25 09:06:08',10,0),('1','150',219882,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-25 18:56:17','507','2021-08-25 18:57:09',10,0),('1','150',220029,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-26 19:26:54','507','2021-08-26 19:27:51',10,0),('1','150',220231,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-27 10:32:28','507','2021-08-27 10:32:56',10,0),('1','150',220337,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-27 19:01:16','507','2021-08-27 19:01:42',10,0),('1','150',220455,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-28 19:54:38','507','2021-08-28 19:55:14',10,0),('1','150',220717,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-29 18:49:43','507','2021-08-29 18:52:01',10,0),('1','150',220896,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-30 17:34:32','507','2021-08-30 17:35:50',10,0),('1','150',221131,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-08-31 19:20:41','507','2021-08-31 19:21:23',10,0),('1','150',221376,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-01 18:45:31','507','2021-09-01 18:46:23',10,0),('1','150',221586,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-01 19:37:08','507','2021-09-01 19:37:29',10,0),('1','150',221621,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-02 19:39:03','507','2021-09-02 19:40:05',10,0),('1','150',221837,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-03 10:17:36','507','2021-09-03 10:18:31',10,0),('1','150',221906,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-03 19:20:53','507','2021-09-03 19:21:55',10,0),('1','150',222090,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-04 18:23:26','507','2021-09-04 18:26:12',10,0),('1','150',222259,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-05 19:31:46','507','2021-09-05 19:33:35',10,0),('1','150',222478,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-06 13:01:22','507','2021-09-06 13:03:13',10,0),('1','150',222625,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-07 07:12:36','507','2021-09-07 07:13:04',10,0),('1','150',222741,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-07 18:44:31','507','2021-09-07 18:45:23',10,0),('1','150',222935,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-08 17:12:37','507','2021-09-08 17:13:22',10,0),('1','150',223166,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-09 18:16:13','507','2021-09-09 18:17:48',10,0),('1','150',223407,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-10 14:12:54','507','2021-09-10 14:13:31',10,0),('1','150',223547,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-11 07:51:37','507','2021-09-11 07:52:08',10,0),('1','150',223666,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-11 18:23:48','507','2021-09-11 18:24:51',10,0),('1','150',223895,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-12 19:27:31','507','2021-09-12 19:28:19',10,0),('1','150',224069,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-13 18:53:38','507','2021-09-13 18:54:31',10,0),('1','150',224296,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-14 19:23:36','507','2021-09-14 19:24:05',10,0),('1','150',224602,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-15 09:46:35','507','2021-09-15 09:47:07',10,0),('1','150',224614,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-15 18:45:24','507','2021-09-15 18:45:50',10,0),('1','150',224765,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-16 17:34:27','507','2021-09-16 17:37:21',10,0),('1','150',225003,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-17 16:35:50','507','2021-09-17 16:55:41',10,0),('1','150',225252,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-18 19:03:27','507','2021-09-18 19:04:10',10,0),('1','150',225472,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-19 15:21:05','507','2021-09-19 15:21:35',10,0),('1','150',225633,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-19 19:50:26','507','2021-09-19 19:50:53',10,0),('1','150',225682,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-20 16:56:53','507','2021-09-20 17:00:26',10,0),('1','150',225927,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-20 18:37:59','507','2021-09-20 18:38:34',10,0),('1','150',225966,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-21 16:16:35','507','2021-09-21 16:18:01',10,0),('1','150',226227,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-22 18:43:22','507','2021-09-22 18:45:05',10,0),('1','150',226466,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-23 19:09:43','507','2021-09-23 19:10:22',10,0),('1','150',226805,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-24 18:37:51','507','2021-09-24 18:38:16',10,0),('1','150',227029,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-26 10:34:09','507','2021-09-26 10:34:53',10,0),('1','150',227255,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-26 19:31:33','507','2021-09-26 19:31:54',10,0),('1','150',227411,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-27 18:46:50','507','2021-09-27 18:47:37',10,0),('1','150',227599,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-28 09:06:22','507','2021-09-28 09:06:59',10,0),('1','150',227660,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-28 19:22:34','507','2021-09-28 19:25:55',10,0),('1','150',227841,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-29 18:55:57','507','2021-09-29 18:56:24',10,0),('1','150',228106,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-30 11:52:23','507','2021-09-30 11:53:00',10,0),('1','150',228218,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-09-30 19:22:25','507','2021-09-30 19:23:01',10,0),('1','150',228339,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-01 09:12:09','507','2021-10-01 09:15:43',10,0),('1','150',228398,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-01 17:22:28','507','2021-10-01 17:22:59',10,0),('1','150',228519,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-02 19:16:22','507','2021-10-02 19:19:07',10,0),('1','150',228741,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-03 09:46:13','507','2021-10-03 09:47:25',10,0),('1','150',228795,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-03 19:40:23','507','2021-10-03 19:40:50',10,0),('1','150',228927,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-05 07:38:47','507','2021-10-05 07:39:42',10,0),('1','150',229198,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-05 18:31:32','507','2021-10-05 18:32:53',10,0),('1','150',229423,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-06 19:58:48','507','2021-10-06 19:59:38',10,0),('1','150',229679,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-07 10:35:50','507','2021-10-07 10:36:24',10,0),('1','150',229739,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-07 18:42:44','507','2021-10-07 18:43:16',10,0),('1','150',229881,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-08 18:48:31','507','2021-10-08 18:49:09',10,0),('1','150',230076,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-09 14:10:50','507','2021-10-09 14:12:03',10,0),('1','150',230220,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-09 18:14:12','507','2021-10-09 18:14:49',10,0),('1','150',230280,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-10 19:16:47','507','2021-10-10 19:17:29',10,0),('1','150',230541,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-11 10:25:59','507','2021-10-11 10:27:13',10,0),('1','150',230612,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-11 19:01:48','507','2021-10-11 19:02:35',10,0),('1','150',230775,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-13 07:05:54','507','2021-10-13 07:06:56',10,0),('1','150',231080,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-13 19:04:05','507','2021-10-13 19:04:52',10,0),('1','150',231425,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-14 19:24:38','507','2021-10-14 19:25:16',10,0),('1','150',231670,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-15 10:33:52','507','2021-10-15 10:35:07',10,0),('1','150',231737,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-15 20:00:32','507','2021-10-15 20:01:07',10,0),('1','150',231882,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-16 19:28:25','507','2021-10-16 19:29:01',10,0),('1','150',232093,'Daily shift','2021-10-17','2021-10-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-17 09:09:39','507','2021-10-17 09:11:30',10,0),('1','150',232155,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-17 19:00:59','507','2021-10-17 19:01:53',10,0),('1','150',232320,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-18 19:17:03','507','2021-10-18 19:17:42',10,0),('1','150',232576,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-19 09:01:40','507','2021-10-19 09:03:55',10,0),('1','150',232659,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-19 12:06:45','507','2021-10-19 12:09:39',10,0),('1','150',232700,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-19 19:09:38','507','2021-10-19 19:10:21',10,0),('1','150',232836,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-20 19:21:27','507','2021-10-20 19:22:22',10,0),('1','150',233102,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-21 11:10:04','507','2021-10-21 11:11:37',10,0),('1','150',233229,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-21 18:47:34','507','2021-10-21 18:48:46',10,0),('1','150',233362,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-22 19:15:41','507','2021-10-22 19:16:54',10,0),('1','150',233593,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-23 16:33:38','507','2021-10-23 16:37:59',10,0),('1','150',233782,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-23 19:14:23','507','2021-10-23 19:15:02',10,0),('1','150',233829,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-24 19:16:04','507','2021-10-24 19:17:24',10,0),('1','150',234036,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-25 18:15:54','507','2021-10-25 18:16:32',10,0),('1','150',234300,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-26 17:50:58','507','2021-10-26 17:52:47',10,0),('1','150',234553,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-27 18:40:51','507','2021-10-27 18:41:33',10,0),('1','150',234821,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-28 16:12:36','507','2021-10-28 17:53:53',10,0),('1','150',235066,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-29 21:08:06','507','2021-10-29 21:09:06',10,0),('1','150',235300,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-30 19:19:35','507','2021-10-30 19:20:44',10,0),('1','150',235486,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-30 19:26:19','507','2021-10-30 19:26:57',10,0),('1','150',235515,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-10-31 19:18:06','507','2021-10-31 19:18:58',10,0),('1','150',235744,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-01 19:18:58','507','2021-11-01 19:30:04',10,0),('1','150',236008,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-02 19:16:22','507','2021-11-02 19:17:06',10,0),('1','150',236231,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-03 19:23:54','507','2021-11-03 19:24:40',10,0),('1','150',236556,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-04 19:04:05','507','2021-11-04 19:05:03',10,0),('1','150',236730,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-05 19:30:34','507','2021-11-05 19:31:46',10,0),('1','150',236985,'Daily','2021-11-06','2021-11-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-06 07:25:21','507','2021-11-06 07:25:41',10,0),('1','150',236996,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-06 18:33:26','507','2021-11-06 18:34:09',10,0),('1','150',237159,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-07 13:41:04','507','2021-11-07 13:41:35',10,0),('1','150',237289,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-07 18:25:31','507','2021-11-07 18:26:13',10,0),('1','150',237373,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-08 19:05:52','507','2021-11-08 19:06:16',10,0),('1','150',237596,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-09 17:20:06','507','2021-11-09 17:20:29',10,0),('1','150',237867,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-10 18:32:30','507','2021-11-10 18:32:53',10,0),('1','150',238106,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-11 18:49:07','507','2021-11-11 18:49:43',10,0),('1','150',238343,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-12 07:03:37','507','2021-11-12 07:03:56',10,0),('1','150',238450,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-12 19:26:49','507','2021-11-12 19:27:19',10,0),('1','150',238589,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-13 19:03:33','507','2021-11-13 19:03:58',10,0),('1','150',238905,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-14 12:03:50','507','2021-11-14 12:04:21',10,0),('1','150',238926,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-14 19:30:23','507','2021-11-14 19:30:41',10,0),('1','150',239048,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-15 19:28:08','507','2021-11-15 19:28:33',10,0),('1','150',239345,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-16 19:11:02','507','2021-11-16 19:11:28',10,0),('1','150',239618,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-17 19:02:18','507','2021-11-17 19:02:39',10,0),('1','150',239745,'Daily','2021-11-17','2021-11-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-18 04:46:49','507','2021-11-18 04:47:19',10,0),('1','150',239753,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-18 18:46:01','507','2021-11-18 18:46:30',10,0),('1','150',239983,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-19 16:27:18','507','2021-11-19 16:28:32',10,0),('1','150',240181,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-20 18:43:25','507','2021-11-20 18:44:11',10,0),('1','150',240439,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-21 19:00:27','507','2021-11-21 19:00:59',10,0),('1','150',240676,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-22 19:01:20','507','2021-11-22 19:01:47',10,0),('1','150',240961,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-23 18:56:35','507','2021-11-23 18:57:14',10,0),('1','150',241212,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-24 14:55:07','507','2021-11-24 14:57:10',10,0),('1','150',241397,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-24 18:52:35','507','2021-11-24 18:52:57',10,0),('1','150',241477,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-25 18:43:52','507','2021-11-25 18:44:19',10,0),('1','150',241791,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-26 19:27:50','507','2021-11-26 19:28:55',10,0),('1','150',242130,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-27 19:17:51','507','2021-11-27 19:18:12',10,0),('1','150',242352,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-28 20:16:15','507','2021-11-28 20:16:35',10,0),('1','150',242634,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-29 20:45:08','507','2021-11-29 20:45:24',10,0),('1','150',242672,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-11-30 21:12:37','507','2021-11-30 21:13:11',10,0),('1','150',243017,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-01 11:28:31','507','2021-12-01 11:29:00',10,0),('1','150',243119,'Daily','2021-12-02','2021-12-02 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-02 19:23:54','507','2021-12-02 19:24:36',10,0),('1','150',243347,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-03 20:45:06','507','2021-12-03 20:45:28',10,0),('1','150',243580,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-04 19:52:12','507','2021-12-04 19:52:39',10,0),('1','150',243815,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-05 19:09:30','507','2021-12-05 19:09:56',10,0),('1','150',244035,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-06 19:04:03','507','2021-12-06 19:04:23',10,0),('1','150',244271,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-07 15:37:00','507','2021-12-07 15:37:18',10,0),('1','150',244664,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-08 18:44:54','507','2021-12-08 18:47:06',10,0),('1','150',244746,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-09 18:33:33','507','2021-12-09 18:34:25',10,0),('1','150',244986,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-10 18:50:57','507','2021-12-10 18:51:25',10,0),('1','150',245196,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-11 14:35:20','507','2021-12-11 14:36:00',10,0),('1','150',245494,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-12 19:08:53','507','2021-12-12 19:10:58',10,0),('1','150',245672,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-13 19:02:52','507','2021-12-13 19:03:33',10,0),('1','150',245939,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-14 07:42:18','507','2021-12-14 07:42:47',10,0),('1','150',245986,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-14 19:11:12','507','2021-12-14 19:11:41',10,0),('1','150',246182,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-15 18:23:18','507','2021-12-15 18:24:06',10,0),('1','150',246441,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-16 15:13:25','507','2021-12-16 15:13:56',10,0),('1','150',246695,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-17 19:12:51','507','2021-12-17 19:13:23',10,0),('1','150',246927,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-18 18:37:11','507','2021-12-18 18:37:43',10,0),('1','150',247161,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-19 08:28:38','507','2021-12-19 08:29:14',10,0),('1','150',247214,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-19 18:26:35','507','2021-12-19 18:35:18',10,0),('1','150',247392,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-20 18:43:10','507','2021-12-20 18:43:31',10,0),('1','150',247662,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-21 10:53:45','507','2021-12-21 10:54:10',10,0),('1','150',247753,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-21 18:50:15','507','2021-12-21 18:50:50',10,0),('1','150',247897,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-22 19:01:28','507','2021-12-22 19:01:55',10,0),('1','150',248146,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-23 07:45:03','507','2021-12-23 07:45:33',10,0),('1','150',248204,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-23 18:57:50','507','2021-12-23 18:58:22',10,0),('1','150',248349,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-23 19:08:14','507','2021-12-23 19:08:39',10,0),('1','150',248390,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-24 14:23:16','507','2021-12-24 14:23:47',10,0),('1','150',248532,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-24 18:41:42','507','2021-12-24 18:42:01',10,0),('1','150',248632,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-25 18:41:16','507','2021-12-25 18:41:40',10,0),('1','150',248861,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-26 18:04:42','507','2021-12-26 18:05:07',10,0),('1','150',249099,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-27 18:15:38','507','2021-12-27 18:15:59',10,0),('1','150',249337,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-28 18:34:10','507','2021-12-28 18:34:45',10,0),('1','150',249578,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-29 15:24:03','507','2021-12-29 15:24:31',10,0),('1','150',249796,'OPERATIONAL LOST','2021-12-29','2021-12-29 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-29 19:25:59','507','2021-12-29 19:26:56',10,0),('1','150',249846,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-30 18:48:31','507','2021-12-30 18:49:13',10,0),('1','150',250094,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'507',0.00,0.00,'507','2021-12-31 18:05:26','507','2021-12-31 18:05:52',10,0),('1','150',250329,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-01 18:18:19','507','2022-01-01 18:19:00',10,0),('1','150',250556,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-02 18:09:36','507','2022-01-02 18:09:58',10,0),('1','150',250794,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-03 12:02:42','507','2022-01-03 12:03:28',10,0),('1','150',250889,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-03 18:26:33','507','2022-01-03 18:27:03',10,0),('1','150',251019,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-04 18:46:31','507','2022-01-04 18:47:23',10,0),('1','150',251265,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-05 19:37:27','507','2022-01-05 19:38:39',10,0),('1','150',251629,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-06 12:24:16','507','2022-01-06 12:24:43',10,0),('1','150',251631,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-06 19:41:37','507','2022-01-06 19:45:46',10,0),('1','150',251759,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-08 06:57:49','507','2022-01-08 06:58:14',10,0),('1','150',251989,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-08 18:31:25','507','2022-01-08 18:32:01',10,0),('1','150',252237,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-09 19:28:48','507','2022-01-09 19:29:21',10,0),('1','150',252473,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-10 20:03:04','507','2022-01-10 20:03:23',10,0),('1','150',252701,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-11 12:54:53','507','2022-01-11 12:56:57',10,0),('1','150',252826,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-11 19:52:07','507','2022-01-11 19:52:31',10,0),('1','150',252968,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-12 19:48:39','507','2022-01-12 19:49:06',10,0),('1','150',253285,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-13 19:02:35','507','2022-01-13 19:03:01',10,0),('1','150',253475,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-14 19:35:00','507','2022-01-14 19:35:22',10,0),('1','150',253712,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-15 19:23:59','507','2022-01-15 19:24:20',10,0),('1','150',253957,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-16 16:35:50','507','2022-01-16 16:36:22',10,0),('1','150',254113,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-16 19:47:54','507','2022-01-16 19:48:14',10,0),('1','150',254189,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-17 19:44:06','507','2022-01-17 19:44:54',10,0),('1','150',254440,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-18 19:23:59','507','2022-01-18 19:24:29',10,0),('1','150',254685,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-19 13:06:20','507','2022-01-19 13:06:39',10,0),('1','150',254824,'OPERATIONAL LOST','2022-01-19','2022-01-19 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-19 13:10:06','507','2022-01-19 13:10:23',10,0),('1','150',254828,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-19 19:31:33','507','2022-01-19 19:31:52',10,0),('1','150',254971,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-20 20:24:30','507','2022-01-20 20:25:39',10,0),('1','150',255220,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-21 19:21:14','507','2022-01-21 19:21:44',10,0),('1','150',255504,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-22 11:50:25','507','2022-01-22 11:50:59',10,0),('1','150',255566,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-22 19:25:55','507','2022-01-22 19:26:19',10,0),('1','150',255770,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-23 20:05:52','507','2022-01-23 20:06:20',10,0),('1','150',256032,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-24 12:22:00','507','2022-01-24 12:22:23',10,0),('1','150',256061,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-24 19:36:32','507','2022-01-24 19:37:10',10,0),('1','150',256250,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-25 20:10:56','507','2022-01-25 20:11:52',10,0),('1','150',256476,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-26 19:55:12','507','2022-01-26 19:56:03',10,0),('1','150',256675,'OPERATIONAL LOST','2022-01-26','2022-01-26 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-26 20:02:11','507','2022-01-26 20:02:48',10,0),('1','150',256753,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-27 19:37:29','507','2022-01-27 19:38:26',10,0),('1','150',256953,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-28 19:40:28','507','2022-01-28 19:41:33',10,0),('1','150',257227,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-29 14:16:52','507','2022-01-29 14:17:43',10,0),('1','150',257357,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-29 19:43:00','507','2022-01-29 19:43:22',10,0),('1','150',257518,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-30 19:31:39','507','2022-01-31 06:37:04',10,0),('1','150',257519,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-31 15:15:48','507','2022-01-31 15:16:50',10,0),('1','150',257520,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'507',0.00,0.00,'507','2022-01-31 19:35:39','507','2022-01-31 19:36:49',10,0),('1','150',257521,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-01 20:44:41','507','2022-02-01 20:46:32',10,0),('1','150',257522,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-02 20:11:56','507','2022-02-02 20:12:10',10,0),('1','150',257523,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-02 20:31:36','507','2022-02-02 20:31:57',10,0),('1','150',257524,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-03 19:48:47','507','2022-02-03 19:49:04',10,0),('1','150',257525,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-05 07:55:47','507','2022-02-05 07:56:24',10,0),('1','150',257526,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-05 20:03:20','507','2022-02-05 20:03:43',10,0),('1','150',257527,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-06 19:36:14','507','2022-02-06 19:36:38',10,0),('1','150',257528,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-07 11:53:52','507','2022-02-07 11:54:12',10,0),('1','150',257529,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-07 19:26:43','507','2022-02-07 19:27:09',10,0),('1','150',257530,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-08 19:26:59','507','2022-02-08 19:27:20',10,0),('1','150',257531,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-09 19:33:15','507','2022-02-09 19:33:34',10,0),('1','150',257532,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-10 10:09:05','507','2022-02-10 10:09:22',10,0),('1','150',257533,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-10 20:01:38','507','2022-02-10 20:01:56',10,0),('1','150',257534,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-11 20:07:12','507','2022-02-11 20:07:29',10,0),('1','150',257535,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-13 14:46:00','507','2022-02-13 14:46:17',10,0),('1','150',257536,'OPERATIONAL LOST','2022-02-13','2022-02-13 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-13 14:56:56','507','2022-02-13 14:57:22',10,0),('1','150',257537,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-13 19:21:17','507','2022-02-13 19:21:38',10,0),('1','150',257538,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-14 19:40:52','507','2022-02-14 19:41:07',10,0),('1','150',257539,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-15 19:30:59','507','2022-02-15 19:31:25',10,0),('1','150',257540,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-16 19:34:54','507','2022-02-16 19:35:39',10,0),('1','150',257541,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-17 19:10:56','507','2022-02-17 19:11:17',10,0),('1','150',257542,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-18 19:21:29','507','2022-02-18 19:21:53',10,0),('1','150',257543,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-19 19:31:16','507','2022-02-19 19:31:34',10,0),('1','150',257544,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-20 10:14:52','507','2022-02-20 10:15:08',10,0),('1','150',257545,'OPERATIONAL LOST','2022-02-20','2022-02-20 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-20 11:09:12','507','2022-02-20 11:09:27',10,0),('1','150',257546,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-20 19:23:17','507','2022-02-20 19:23:38',10,0),('1','150',257547,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'507',0.00,0.00,'507','2022-02-21 19:54:33','507','2022-02-21 19:54:55',10,0),('1','150',257548,'DAILY SHIFT','2022-02-22','2022-02-22 06:12:59','2022-02-23 06:12:59','507',0.00,0.00,'507','2022-02-22 18:21:57','507','2022-02-22 18:22:24',10,0),('1','150',257549,'OPERATIONAL LOST','2022-02-22','2022-02-22 18:26:45','2022-02-23 18:26:45','507',0.00,0.00,'507','2022-02-22 18:28:12','507','2022-02-22 18:28:42',10,0),('1','150',257550,'DAILY SHIFT','2022-02-23','2022-02-23 06:17:45','2022-02-24 06:17:45','507',0.00,0.00,'507','2022-02-23 19:29:11','507','2022-02-23 19:29:33',10,0),('1','150',257551,'DAILY SHIFT','2022-02-24','2022-02-24 06:18:58','2022-02-25 06:18:58','507',0.00,0.00,'507','2022-02-24 19:21:08','507','2022-02-24 19:21:28',10,0),('1','150',257552,'DAILY SHIFT','2022-02-25','2022-02-25 06:12:48','2022-02-26 06:12:48','507',0.00,0.00,'507','2022-02-25 19:24:17','507','2022-02-25 19:25:03',10,0),('1','150',257553,'DAILY SHIFT','2022-02-26','2022-02-26 06:38:15','2022-02-27 06:38:15','507',0.00,0.00,'507','2022-02-26 10:38:54','507','2022-02-26 10:39:27',10,0),('1','150',257554,'DAILY SHIFT','2022-02-26','2022-02-26 10:41:52','2022-02-27 10:41:52','507',0.00,0.00,'507','2022-02-26 19:20:48','507','2022-02-26 19:21:24',10,0),('1','150',257555,'DAILY SHIFT','2022-02-27','2022-02-27 06:35:20','2022-02-28 06:35:20','507',0.00,0.00,'507','2022-02-27 19:16:04','507','2022-02-27 19:16:21',10,0),('1','150',257556,'DAILY SHIFT','2022-02-28','2022-02-28 06:56:00','2022-03-01 06:56:00','507',0.00,0.00,'507','2022-02-28 18:39:19','507','2022-02-28 18:39:37',10,0),('1','150',257557,'DAILY SHIFT','2022-03-01','2022-03-01 06:49:53','2022-03-02 06:49:53','507',0.00,0.00,'507','2022-03-01 19:40:14','507','2022-03-01 19:40:32',10,0),('1','150',257558,'DAILY SHIFT','2022-03-02','2022-03-02 06:40:02','2022-03-03 06:40:02','507',0.00,0.00,'507','2022-03-02 19:26:52','507','2022-03-02 19:27:11',10,0),('1','150',257559,'DAILY SHIFT','2022-03-03','2022-03-03 06:42:09','2022-03-04 06:42:09','507',0.00,0.00,'507','2022-03-03 08:22:58','507','2022-03-03 08:23:17',10,0),('1','150',257560,'DAILY SHIFT','2022-03-03','2022-03-03 08:25:36','2022-03-04 08:25:36','507',0.00,0.00,'507','2022-03-03 18:45:57','507','2022-03-03 18:46:14',10,0),('1','150',257561,'DAILY SHIFT','2022-03-04','2022-03-04 07:51:48','2022-03-05 07:51:48','507',0.00,0.00,'507','2022-03-04 19:18:38','507','2022-03-04 19:19:05',10,0),('1','150',257562,'DAILY SHIFT','2022-03-05','2022-03-05 06:40:55','2022-03-06 06:40:55','507',0.00,0.00,'507','2022-03-05 19:46:22','507','2022-03-05 19:46:45',10,0),('1','150',257563,'DAILY SHIFT','2022-03-06','2022-03-06 06:29:15','2022-03-07 06:29:15','507',0.00,0.00,'507','2022-03-06 15:32:09','507','2022-03-06 15:32:29',10,0),('1','150',257564,'DAILY SHIFT','2022-03-07','2022-03-07 06:24:56','2022-03-08 06:24:56','507',0.00,0.00,'507','2022-03-07 19:56:04','507','2022-03-07 19:56:20',10,0),('1','150',257565,'DAILY SHIFT','2022-03-08','2022-03-08 06:51:29','2022-03-09 06:51:29','507',0.00,0.00,'507','2022-03-08 19:41:47','507','2022-03-08 19:42:04',10,0),('1','150',257566,'DAILY SHIFT','2022-03-09','2022-03-09 06:42:19','2022-03-10 06:42:19','507',0.00,0.00,'507','2022-03-09 18:45:42','507','2022-03-09 18:46:00',10,0),('1','150',257567,'DAILY SHIFT','2022-03-10','2022-03-10 07:03:20','2022-03-11 07:03:20','507',0.00,0.00,'507','2022-03-10 20:00:51','507','2022-03-10 20:01:08',10,0),('1','150',257568,'DAILY SHIFT','2022-03-11','2022-03-11 08:02:53','2022-03-12 08:02:53','507',0.00,0.00,'507','2022-03-11 19:38:21','507','2022-03-11 19:38:38',10,0),('1','150',257569,'DAILY SHIFT','2022-03-12','2022-03-12 08:23:45','2022-03-13 08:23:45','507',0.00,0.00,'507','2022-03-12 15:34:30','507','2022-03-12 15:35:08',10,0),('1','150',257570,'DAILY SHIFT','2022-03-12','2022-03-12 15:37:55','2022-03-13 15:37:55','507',0.00,0.00,'507','2022-03-12 19:15:54','507','2022-03-12 19:16:09',10,0),('1','150',257571,'DAILY SHIFT','2022-03-13','2022-03-13 07:04:33','2022-03-14 07:04:33','507',0.00,0.00,'507','2022-03-13 19:20:40','507','2022-03-13 19:21:08',10,0),('1','150',257572,'DAILY SHIFT','2022-03-14','2022-03-14 08:38:40','2022-03-15 08:38:40','507',0.00,0.00,'507','2022-03-14 19:35:26','507','2022-03-14 19:35:42',10,0),('1','150',257573,'DAILY SHIFT','2022-03-15','2022-03-15 07:09:19','2022-03-16 07:09:19','507',0.00,0.00,'507','2022-03-15 19:44:28','507','2022-03-15 19:44:50',10,0),('1','150',257574,'DAILY SHIFT','2022-03-16','2022-03-16 09:12:16','2022-03-17 09:12:16','507',0.00,0.00,'507','2022-03-16 19:27:36','507','2022-03-16 19:27:57',10,0),('1','150',257575,'DAILY SHIFT','2022-03-17','2022-03-17 08:31:01','2022-03-18 08:31:01','507',0.00,0.00,'507','2022-03-17 19:44:11','507','2022-03-17 19:44:30',10,0),('1','150',257576,'DAILY SHIFT','2022-03-18','2022-03-18 07:00:14','2022-03-19 07:00:14','507',0.00,0.00,'507','2022-03-18 19:39:16','507','2022-03-18 19:39:39',10,0),('1','150',257577,'DAILY SHIFT','2022-03-19','2022-03-19 06:59:35','2022-03-20 06:59:35','507',0.00,0.00,'507','2022-03-19 13:58:40','507','2022-03-19 13:58:57',10,0),('1','150',257578,'DAILY SHIFT','2022-03-19','2022-03-19 14:19:47','2022-03-20 14:19:47','507',0.00,0.00,'507','2022-03-19 19:19:30','507','2022-03-19 19:19:54',10,0),('1','150',257579,'DAILY SHIFT','2022-03-20','2022-03-20 07:03:21','2022-03-21 07:03:21','507',0.00,0.00,'507','2022-03-20 19:23:52','507','2022-03-20 19:24:11',10,0),('1','150',257580,'DAILY SHIFT','2022-03-21','2022-03-21 06:58:34','2022-03-22 06:58:34','507',0.00,0.00,'507','2022-03-21 20:13:37','507','2022-03-21 20:13:57',10,0),('1','150',257581,'DAILY SHIFT','2022-03-22','2022-03-22 06:50:38','2022-03-23 06:50:38','507',0.00,0.00,'507','2022-03-22 19:26:03','507','2022-03-22 19:26:27',10,0),('1','150',257582,'DAILY SHIFT','2022-03-23','2022-03-23 06:46:01','2022-03-24 06:46:01','507',0.00,0.00,'507','2022-03-23 14:52:06','507','2022-03-23 14:52:32',10,0),('1','150',257583,'DAILY SHIFT','2022-03-23','2022-03-23 15:05:14','2022-03-24 15:05:14','507',0.00,0.00,'507','2022-03-23 20:01:24','507','2022-03-23 20:01:43',10,0),('1','150',257584,'DAILY SHIFT','2022-03-24','2022-03-24 06:44:00','2022-03-25 06:44:00','507',0.00,0.00,'507','2022-03-24 19:48:45','507','2022-03-24 19:49:10',10,0),('1','150',257585,'DAILY SHIFT','2022-03-25','2022-03-25 06:40:01','2022-03-26 06:40:01','507',0.00,0.00,'507','2022-03-25 19:38:08','507','2022-03-25 19:38:26',10,0),('1','150',257586,'DAILY SHIFT','2022-03-26','2022-03-26 06:49:28','2022-03-27 06:49:28','507',0.00,0.00,'507','2022-03-26 19:37:57','507','2022-03-26 19:38:19',10,0),('1','150',257587,'DAILY SHIFT','2022-03-27','2022-03-27 06:42:38','2022-03-28 06:42:38','507',0.00,0.00,'507','2022-03-27 12:14:24','507','2022-03-27 12:14:39',10,0),('1','150',257588,'DAILY SHIFT','2022-03-27','2022-03-27 12:45:36','2022-03-28 12:45:36','507',0.00,0.00,'507','2022-03-27 12:46:42','507','2022-03-27 12:46:58',10,0),('1','150',257589,'DAILY SHIFT','2022-03-27','2022-03-27 12:48:55','2022-03-28 12:48:55','507',0.00,0.00,'507','2022-03-27 19:43:57','507','2022-03-27 19:44:15',10,0),('1','150',257590,'DAILY SHIFT','2022-03-28','2022-03-28 06:04:48','2022-03-29 06:04:48','507',0.00,0.00,'507','2022-03-28 19:40:54','507','2022-03-28 19:41:12',10,0),('1','150',257591,'DAILY SHIFT','2022-03-29','2022-03-29 06:14:33','2022-03-30 06:14:33','507',0.00,0.00,'507','2022-03-29 19:24:51','507','2022-03-29 19:25:14',10,0),('1','150',257592,'DAILY SHIFT','2022-03-30','2022-03-30 06:14:13','2022-03-31 06:14:13','507',0.00,0.00,'507','2022-03-30 14:41:05','507','2022-03-30 14:41:23',10,0),('1','150',257593,'DAILY SHIFT','2022-03-30','2022-03-30 15:09:42','2022-03-31 15:09:42','507',0.00,0.00,'507','2022-03-30 19:31:28','507','2022-03-30 19:31:44',10,0),('1','150',257594,'DAILY SHIFT','2022-03-31','2022-03-31 06:51:12','2022-04-01 06:51:12','507',0.00,0.00,'507','2022-03-31 19:38:29','507','2022-03-31 19:38:49',10,0),('1','150',257595,'DAILY SHIFT','2022-04-01','2022-04-01 06:06:34','2022-04-02 06:06:34','507',0.00,0.00,'507','2022-04-01 19:00:34','507','2022-04-01 19:01:30',10,0),('1','150',257596,'DAILY SHIFT','2022-04-02','2022-04-02 06:04:31','2022-04-03 06:04:31','507',0.00,0.00,'507','2022-04-02 20:35:34','507','2022-04-02 20:35:54',10,0),('1','150',257597,'DAILY SHIFT','2022-04-03','2022-04-03 05:51:14','2022-04-04 05:51:14','507',0.00,0.00,'507','2022-04-03 18:04:37','507','2022-04-03 18:04:59',10,0),('1','150',257598,'DAILY SHIFT','2022-04-04','2022-04-04 06:43:52','2022-04-05 06:43:52','507',0.00,0.00,'507','2022-04-04 19:18:10','507','2022-04-04 19:18:25',10,0),('1','150',257599,'DAILY SHIFT','2022-04-05','2022-04-05 06:59:06','2022-04-06 06:59:06','507',0.00,0.00,'507','2022-04-05 20:26:25','507','2022-04-05 20:26:52',10,0),('1','150',257600,'DAILY SHIFT','2022-04-06','2022-04-06 06:45:14','2022-04-07 06:45:14','507',0.00,0.00,'507','2022-04-06 19:41:18','507','2022-04-06 19:41:36',10,0),('1','150',257601,'DAILY SHIFT','2022-04-07','2022-04-07 06:39:55','2022-04-08 06:39:55','507',0.00,0.00,'507','2022-04-07 19:58:04','507','2022-04-07 19:58:27',10,0),('1','150',257602,'DAILY SHIFT','2022-04-08','2022-04-08 06:57:02','2022-04-09 06:57:02','507',0.00,0.00,'507','2022-04-08 19:32:53','507','2022-04-08 19:33:20',10,0),('1','150',257603,'DAILY SHIFT','2022-04-09','2022-04-09 06:56:00','2022-04-10 06:56:00','507',0.00,0.00,'507','2022-04-09 19:24:10','507','2022-04-09 19:24:35',10,0),('1','150',257604,'DAILY SHIFT','2022-04-10','2022-04-10 06:50:17','2022-04-11 06:50:17','507',0.00,0.00,'507','2022-04-10 19:33:53','507','2022-04-10 19:34:27',10,0),('1','150',257605,'DAILY SHIFT','2022-04-11','2022-04-11 05:47:47','2022-04-12 05:47:47','507',0.00,0.00,'507','2022-04-11 20:16:29','507','2022-04-11 20:16:50',10,0),('1','150',257606,'DAILY SHIFT','2022-04-12','2022-04-12 05:52:13','2022-04-13 05:52:13','507',0.00,0.00,'507','2022-04-12 18:36:35','507','2022-04-12 18:36:54',10,0),('1','150',257607,'DAILY SHIFT','2022-04-12','2022-04-12 19:38:55','2022-04-13 19:38:55','507',0.00,0.00,'507','2022-04-12 19:40:08','507','2022-04-12 19:40:30',10,0),('1','150',257608,'DAILY SHIFT','2022-04-13','2022-04-13 06:01:14','2022-04-14 06:01:14','507',0.00,0.00,'507','2022-04-13 19:30:59','507','2022-04-13 19:31:24',10,0),('1','150',257609,'DAILY SHIFT','2022-04-14','2022-04-14 05:51:04','2022-04-15 05:51:04','507',0.00,0.00,'507','2022-04-14 20:04:09','507','2022-04-14 20:04:37',10,0),('1','150',257610,'OPERATIONAL LOST','2022-04-15','2022-04-15 05:52:06','2022-04-16 05:52:06','507',0.00,0.00,'507','2022-04-15 12:08:36','507','2022-04-15 12:08:59',10,0),('1','150',257611,'DAILY SHIFT','2022-04-15','2022-04-15 12:17:44','2022-04-16 12:17:44','507',0.00,0.00,'507','2022-04-15 19:43:50','507','2022-04-15 19:44:13',10,0),('1','150',257612,'DAILY SHIFT','2022-04-16','2022-04-16 05:49:24','2022-04-17 05:49:24','507',0.00,0.00,'507','2022-04-16 19:51:28','507','2022-04-16 19:51:51',10,0),('1','150',257613,'DAILY SHIFT','2022-04-17','2022-04-17 05:54:14','2022-04-18 05:54:14','507',0.00,0.00,'507','2022-04-17 17:46:47','507','2022-04-17 17:47:08',10,0),('1','150',257614,'DAILY SHIFT','2022-04-18','2022-04-18 06:39:59','2022-04-19 06:39:59','507',0.00,0.00,'507','2022-04-18 19:37:58','507','2022-04-18 19:38:39',10,0),('1','150',257615,'DAILY SHIFT','2022-04-19','2022-04-19 06:36:14','2022-04-20 06:36:14','507',0.00,0.00,'507','2022-04-19 19:25:07','507','2022-04-19 19:25:31',10,0),('1','150',257616,'DAILY SHIFT','2022-04-20','2022-04-20 06:30:10','2022-04-21 06:30:10','507',0.00,0.00,'507','2022-04-20 18:42:27','507','2022-04-20 18:42:48',10,0),('1','150',257617,'DAILY SHIFT','2022-04-21','2022-04-21 07:51:14','2022-04-22 07:51:14','507',0.00,0.00,'507','2022-04-21 20:04:52','507','2022-04-21 20:05:19',10,0),('1','150',257618,'DAILY SHIFT','2022-04-22','2022-04-22 06:42:55','2022-04-23 06:42:55','507',0.00,0.00,'507','2022-04-22 19:31:27','507','2022-04-22 19:32:36',10,0),('1','150',257619,'DAILY SHIFT','2022-04-23','2022-04-23 06:43:28','2022-04-24 06:43:28','507',0.00,0.00,'507','2022-04-23 10:09:27','507','2022-04-23 10:09:46',10,0),('1','150',257620,'DAILY SHIFT','2022-04-23','2022-04-23 10:37:38','2022-04-24 10:37:38','507',0.00,0.00,'507','2022-04-23 19:46:47','507','2022-04-23 19:47:07',10,0),('1','150',257621,'DAILY SHIFT','2022-04-24','2022-04-24 06:35:47','2022-04-25 06:35:47','507',0.00,0.00,'507','2022-04-24 19:34:18','507','2022-04-24 19:34:44',10,0),('1','150',257622,'DAILY SHIFT','2022-04-25','2022-04-25 05:40:15','2022-04-26 05:40:15','507',0.00,0.00,'507','2022-04-25 19:11:09','507','2022-04-25 19:11:34',10,0),('1','150',257623,'DAILY SHIFT','2022-04-26','2022-04-26 08:31:48','2022-04-27 08:31:48','507',0.00,0.00,'507','2022-04-26 20:09:23','507','2022-04-26 20:09:46',10,0),('1','150',257624,'DAILY SHIFT','2022-04-27','2022-04-27 05:42:39','2022-04-28 05:42:39','507',0.00,0.00,'507','2022-04-27 20:51:59','507','2022-04-27 20:52:23',10,0),('1','150',257625,'DAILY SHIFT','2022-04-28','2022-04-28 05:41:34','2022-04-29 05:41:34','507',0.00,0.00,'507','2022-04-28 20:41:02','507','2022-04-28 20:41:28',10,0),('1','150',257626,'DAILY SHIFT','2022-04-29','2022-04-29 05:42:10','2022-04-30 05:42:10','507',0.00,0.00,'507','2022-04-29 19:43:17','507','2022-04-29 19:43:41',10,0),('1','150',257627,'DAILY SHIFT','2022-04-30','2022-04-30 07:01:53','2022-05-01 07:01:53','507',0.00,0.00,'507','2022-04-30 20:43:49','507','2022-04-30 20:44:11',10,0),('1','150',257628,'DAILY SHIFT','2022-05-01','2022-05-01 05:48:27','2022-05-02 05:48:27','507',0.00,0.00,'507','2022-05-01 15:48:36','507','2022-05-01 15:48:54',10,0),('1','150',257629,'DAILY SHIFT','2022-05-01','2022-05-01 16:22:19','2022-05-02 16:22:19','507',0.00,0.00,'507','2022-05-01 20:01:04','507','2022-05-01 20:01:31',10,0),('1','150',257630,'25','2022-05-02','2022-05-02 12:44:50','2022-05-03 12:44:50','507',0.00,0.00,'507','2022-05-02 19:34:49','507','2022-05-02 19:35:06',10,0),('1','150',257631,'DAILY SHIFT','2022-05-03','2022-05-03 05:42:16','2022-05-04 05:42:16','507',0.00,0.00,'507','2022-05-03 19:20:55','507','2022-05-03 19:22:15',10,0),('1','150',257632,'DAILY SHIFT','2022-05-04','2022-05-04 05:39:18','2022-05-05 05:39:18','507',0.00,0.00,'507','2022-05-04 19:32:44','507','2022-05-04 19:33:03',10,0),('1','150',257633,'DAILY SHIFT','2022-05-05','2022-05-05 05:38:14','2022-05-06 05:38:14','507',0.00,0.00,'507','2022-05-05 10:59:15','507','2022-05-05 10:59:40',10,0),('1','150',257634,'DAILY SHIFT','2022-05-05','2022-05-05 11:03:30','2022-05-06 11:03:30','507',0.00,0.00,'507','2022-05-05 19:16:33','507','2022-05-05 19:16:52',10,0),('1','150',257635,'DAILY SHIFT','2022-05-06','2022-05-06 05:49:09','2022-05-07 05:49:09','507',0.00,0.00,'507','2022-05-06 19:19:28','507','2022-05-06 19:19:46',10,0),('1','150',257636,'DAILY SHIFT','2022-05-07','2022-05-07 05:50:13','2022-05-08 05:50:13','507',0.00,0.00,'507','2022-05-07 18:05:54','507','2022-05-07 18:06:18',10,0),('1','150',257637,'DAILY SHIFT','2022-05-08','2022-05-08 09:11:03','2022-05-09 09:11:03','507',0.00,0.00,'507','2022-05-08 19:16:10','507','2022-05-08 19:16:32',10,0),('1','150',257638,'DAILY SHIFT','2022-05-09','2022-05-09 05:43:48','2022-05-10 05:43:48','507',0.00,0.00,'507','2022-05-09 17:55:18','507','2022-05-09 17:55:39',10,0),('1','150',257639,'OPERATIONAL LOST','2022-05-09','2022-05-09 17:58:29','2022-05-10 17:58:29','507',0.00,0.00,'507','2022-05-09 17:59:44','507','2022-05-09 18:00:01',10,0),('1','150',257640,'DAILY SHIFT','2022-05-12','2022-05-12 13:31:34','2022-05-13 13:31:34','507',0.00,0.00,'507','2022-05-12 19:18:58','507','2022-05-12 19:19:24',10,0),('1','150',257641,'DAILY SHIFT','2022-05-13','2022-05-13 06:44:16','2022-05-14 06:44:16','507',0.00,0.00,'507','2022-05-13 19:23:34','507','2022-05-13 19:24:19',10,0),('1','150',257642,'DAILY SHIFT','2022-05-14','2022-05-14 06:56:04','2022-05-15 06:56:04','507',0.00,0.00,'507','2022-05-15 08:13:36','507','2022-05-15 08:13:57',10,0),('1','150',257643,'DAILY SHIFT','2022-05-15','2022-05-15 08:18:05','2022-05-16 08:18:05','507',0.00,0.00,'507','2022-05-15 08:20:56','507','2022-05-15 08:21:17',10,0),('1','150',257644,'DAILY SHIFT','2022-05-15','2022-05-15 08:44:48','2022-05-16 08:44:48','507',0.00,0.00,'507','2022-05-15 20:11:36','507','2022-05-15 20:12:03',10,0),('1','150',257645,'DAILY SHIFT','2022-05-16','2022-05-16 06:46:56','2022-05-17 06:46:56','507',0.00,0.00,'507','2022-05-16 19:23:37','507','2022-05-16 19:24:05',10,0),('1','150',257646,'DAILY SHIFT','2022-05-17','2022-05-17 06:47:40','2022-05-18 06:47:40','507',0.00,0.00,'507','2022-05-17 11:22:59','507','2022-05-17 11:23:22',10,0),('1','150',257647,'DAILY SHIFT','2022-05-17','2022-05-17 14:00:57','2022-05-18 14:00:57','507',0.00,0.00,'507','2022-05-17 19:39:39','507','2022-05-17 19:40:00',10,0),('1','150',257648,'DAILY SHIFT','2022-05-18','2022-05-18 06:42:44','2022-05-19 06:42:44','507',0.00,0.00,'507','2022-05-18 19:30:55','507','2022-05-18 19:31:19',10,0),('1','150',257649,'DAILY SHIFT','2022-05-20','2022-05-20 06:45:38','2022-05-21 06:45:38','507',0.00,0.00,'507','2022-05-20 19:10:25','507','2022-05-20 19:10:47',10,0),('1','150',257650,'DAILY SHIFT','2022-05-21','2022-05-21 06:52:36','2022-05-22 06:52:36','507',0.00,0.00,'507','2022-05-21 19:38:53','507','2022-05-21 19:39:28',10,0),('1','150',257651,'DAILY SHIFT','2022-05-22','2022-05-22 06:39:15','2022-05-23 06:39:15','507',0.00,0.00,'507','2022-05-22 11:00:04','507','2022-05-22 11:00:49',10,0),('1','150',257652,'DAILY SHIFT','2022-05-22','2022-05-22 11:07:09','2022-05-23 11:07:09','507',0.00,0.00,'507','2022-05-22 19:21:34','507','2022-05-22 19:22:06',10,0),('1','150',257653,'DAILY SHIFT','2022-05-23','2022-05-23 10:15:29','2022-05-24 10:15:29','507',0.00,0.00,'507','2022-05-23 19:36:51','507','2022-05-23 19:37:07',10,0),('1','150',257654,'DAILY SHIFT','2022-05-24','2022-05-24 06:50:54','2022-05-25 06:50:54','507',0.00,0.00,'507','2022-05-24 19:21:15','507','2022-05-24 19:21:32',10,0),('1','150',257655,'DAILY SHIFT','2022-05-25','2022-05-25 06:38:30','2022-05-26 06:38:30','507',0.00,0.00,'507','2022-05-25 10:16:08','507','2022-05-25 10:16:27',10,0),('1','150',257656,'DAILY SHIFT','2022-05-25','2022-05-25 10:19:22','2022-05-26 10:19:22','507',0.00,0.00,'507','2022-05-25 19:23:44','507','2022-05-25 19:24:09',10,0),('1','150',257657,'DAILY SHIFT','2022-05-26','2022-05-26 07:04:13','2022-05-27 07:04:13','507',0.00,0.00,'507','2022-05-26 19:22:38','507','2022-05-26 19:23:04',10,0),('1','150',257658,'DAILY SHIFT','2022-05-27','2022-05-27 06:57:23','2022-05-28 06:57:23','507',0.00,0.00,'507','2022-05-27 19:20:26','507','2022-05-27 19:20:45',10,0),('1','150',257659,'DAILY SHIFT','2022-05-28','2022-05-28 06:52:29','2022-05-29 06:52:29','507',0.00,0.00,'507','2022-05-28 15:07:58','507','2022-05-28 15:08:12',10,0),('1','150',257660,'DAILY SHIFT','2022-05-28','2022-05-28 15:08:40','2022-05-29 15:08:40','507',0.00,0.00,'507','2022-05-28 19:29:47','507','2022-05-28 19:30:03',10,0),('1','150',257661,'DAILY SHIFT','2022-05-29','2022-05-29 06:55:45','2022-05-30 06:55:45','507',0.00,0.00,'507','2022-05-29 19:37:29','507','2022-05-29 19:37:45',10,0),('1','150',257662,'DAILY SHIFT','2022-05-30','2022-05-30 07:08:52','2022-05-31 07:08:52','507',0.00,0.00,'507','2022-05-30 19:48:29','507','2022-05-30 19:48:50',10,0),('1','150',257663,'DAILY SHIFT','2022-05-31','2022-05-31 07:26:00','2022-06-01 07:26:00','507',0.00,0.00,'507','2022-05-31 08:55:43','507','2022-05-31 08:56:01',10,0),('1','150',257664,'DAILY SHIFT','2022-05-31','2022-05-31 12:18:31','2022-06-01 12:18:31','507',0.00,0.00,'507','2022-05-31 20:14:14','507','2022-05-31 20:14:29',10,0),('1','150',257665,'DAILY SHIFT','2022-06-01','2022-06-01 06:50:52','2022-06-02 06:50:52','507',0.00,0.00,'507','2022-06-01 20:07:28','507','2022-06-01 20:08:39',10,0),('1','150',257666,'DAILY SHIFT','2022-06-02','2022-06-02 06:46:28','2022-06-03 06:46:28','507',0.00,0.00,'507','2022-06-02 18:58:04','507','2022-06-02 18:58:19',10,0),('1','150',257667,'DAILY SHIFT','2022-06-03','2022-06-03 08:24:25','2022-06-04 08:24:25','507',0.00,0.00,'507','2022-06-03 19:59:44','507','2022-06-03 20:00:03',10,0),('1','150',257668,'DAILY SHIFT','2022-06-04','2022-06-04 07:06:56','2022-06-05 07:06:56','507',0.00,0.00,'507','2022-06-04 19:35:29','507','2022-06-04 19:36:11',10,0),('1','150',257669,'DAILY SHIFT','2022-06-05','2022-06-05 08:13:21','2022-06-06 08:13:21','507',0.00,0.00,'507','2022-06-05 12:27:18','507','2022-06-05 12:27:44',10,0),('1','150',257670,'DAILY SHIFT','2022-06-06','2022-06-06 10:25:39','2022-06-07 10:25:39','507',0.00,0.00,'507','2022-06-06 19:25:19','507','2022-06-06 19:26:03',10,0),('1','150',257671,'DAILY SHIFT','2022-06-07','2022-06-07 07:10:05','2022-06-08 07:10:05','507',0.00,0.00,'507','2022-06-07 19:16:19','507','2022-06-07 19:16:40',10,0),('1','150',257672,'DAILY SHIFT','2022-06-08','2022-06-08 07:37:28','2022-06-09 07:37:28','507',0.00,0.00,'507','2022-06-08 19:38:01','507','2022-06-08 19:38:23',10,0),('1','150',257673,'DAILY SHIFT','2022-06-09','2022-06-09 11:10:38','2022-06-10 11:10:38','507',0.00,0.00,'507','2022-06-09 19:27:32','507','2022-06-09 19:27:51',10,0),('1','150',257674,'OPERATIONAL LOST','2022-06-09','2022-06-09 19:37:33','2022-06-10 19:37:33','507',0.00,0.00,'507','2022-06-09 19:39:52','507','2022-06-09 19:40:11',10,0),('1','150',257675,'DAILY SHIFT','2022-06-10','2022-06-10 05:41:15','2022-06-11 05:41:15','507',0.00,0.00,'507','2022-06-10 19:18:07','507','2022-06-10 19:18:29',10,0),('1','150',257676,'DAILY SHIFT','2022-06-11','2022-06-11 07:27:57','2022-06-12 07:27:57','507',0.00,0.00,'507','2022-06-11 19:29:33','507','2022-06-11 19:30:10',10,0),('1','150',257677,'DAILY SHIFT','2022-06-12','2022-06-12 07:13:49','2022-06-13 07:13:49','507',0.00,0.00,'507','2022-06-12 16:24:11','507','2022-06-12 16:24:34',10,0),('1','150',257678,'DAILY SHIFT','2022-06-13','2022-06-13 07:12:02','2022-06-14 07:12:02','507',0.00,0.00,'507','2022-06-13 19:41:19','507','2022-06-13 19:41:41',10,0),('1','150',257679,'DAILY SHIFT','2022-06-14','2022-06-14 07:05:24','2022-06-15 07:05:24','507',0.00,0.00,'507','2022-06-14 19:30:43','507','2022-06-14 19:31:07',10,0),('1','150',257680,'DAILY SHIFT','2022-06-15','2022-06-15 07:34:50','2022-06-16 07:34:50','507',0.00,0.00,'507','2022-06-15 19:38:52','507','2022-06-15 19:39:17',10,0),('1','150',257681,'OPERATIONAL LOST','2022-06-15','2022-06-15 19:49:19','2022-06-16 19:49:19','507',0.00,0.00,'507','2022-06-15 19:50:55','507','2022-06-15 19:51:21',10,0),('1','150',257682,'DAILY SHIFT','2022-06-17','2022-06-17 10:21:06','2022-06-18 10:21:06','507',0.00,0.00,'507','2022-06-17 19:26:00','507','2022-06-17 19:26:21',10,0),('1','150',257683,'DAILY SHIFT','2022-06-18','2022-06-18 08:28:05','2022-06-19 08:28:05','507',0.00,0.00,'507','2022-06-18 19:41:44','507','2022-06-18 19:42:03',10,0),('1','150',257684,'DAILY SHIFT','2022-06-19','2022-06-19 09:20:37','2022-06-20 09:20:37','507',0.00,0.00,'507','2022-06-19 19:39:26','507','2022-06-19 19:39:52',10,0),('1','150',257685,'DAILY SHIFT','2022-06-20','2022-06-20 05:34:13','2022-06-21 05:34:13','507',0.00,0.00,'507','2022-06-20 19:36:00','507','2022-06-20 19:36:15',10,0),('1','150',257686,'DAILY SHIFT','2022-06-21','2022-06-21 05:41:47','2022-06-22 05:41:47','507',0.00,0.00,'507','2022-06-21 19:55:19','507','2022-06-21 19:55:36',10,0),('1','150',257687,'DAILY SHIFT','2022-06-22','2022-06-22 05:41:15','2022-06-23 05:41:15','507',0.00,0.00,'507','2022-06-22 15:04:51','507','2022-06-22 15:05:07',10,0),('1','150',257688,'DAILY SHIFT','2022-06-22','2022-06-22 15:17:58','2022-06-23 15:17:58','507',0.00,0.00,'507','2022-06-22 20:21:25','507','2022-06-22 20:21:42',10,0),('1','150',257689,'DAILY SHIFT','2022-06-23','2022-06-23 05:40:12','2022-06-24 05:40:12','507',0.00,0.00,'507','2022-06-23 19:31:54','507','2022-06-23 19:32:38',10,0),('1','150',257690,'DAILY SHIFT','2022-06-24','2022-06-24 08:21:19','2022-06-25 08:21:19','507',0.00,0.00,'507','2022-06-25 05:41:50','507','2022-06-25 05:42:19',10,0),('1','150',257691,'DAILY SHIFT','2022-06-25','2022-06-25 05:42:40','2022-06-26 05:42:40','507',0.00,0.00,'507','2022-06-25 16:30:08','507','2022-06-25 16:30:35',10,0),('1','150',257692,'DAILY SHIFT','2022-06-26','2022-06-26 07:08:49','2022-06-27 07:08:49','507',0.00,0.00,'507','2022-06-26 19:46:32','507','2022-06-26 19:47:11',10,0),('1','150',257693,'DAILY SHIFT','2022-06-27','2022-06-27 09:54:33','2022-06-28 09:54:33','507',0.00,0.00,'507','2022-06-27 20:38:48','507','2022-06-27 20:39:16',10,0),('1','150',257694,'DAILY SHIFT','2022-06-28','2022-06-28 06:17:40','2022-06-29 06:17:40','507',0.00,0.00,'507','2022-06-28 15:12:28','507','2022-06-28 15:13:54',10,0),('1','150',257695,'DAILY SHIFT','2022-06-28','2022-06-28 15:54:14','2022-06-29 15:54:14','507',0.00,0.00,'507','2022-06-28 19:47:21','507','2022-06-28 19:47:41',10,0),('1','150',257696,'DAILY SHIFT','2022-06-29','2022-06-29 08:26:30','2022-06-30 08:26:30','507',0.00,0.00,'507','2022-06-29 19:35:24','507','2022-06-29 19:36:20',10,0),('1','150',257697,'DAILY SHIFT','2022-06-30','2022-06-30 05:55:13','2022-07-01 05:55:13','507',0.00,0.00,'507','2022-06-30 19:58:51','507','2022-06-30 19:59:09',10,0),('1','150',257698,'DAILY SHIFT','2022-07-01','2022-07-01 06:52:32','2022-07-02 06:52:32','507',0.00,0.00,'507','2022-07-01 12:11:16','507','2022-07-01 12:11:34',10,0),('1','150',257699,'OPERATIONAL LOST','2022-07-01','2022-07-01 12:15:07','2022-07-02 12:15:07','507',0.00,0.00,'507','2022-07-01 13:59:09','507','2022-07-01 13:59:32',10,0),('1','150',257700,'DAILY SHIFT','2022-07-01','2022-07-01 14:00:26','2022-07-02 14:00:26','507',0.00,0.00,'507','2022-07-01 20:06:44','507','2022-07-01 20:07:04',10,0),('1','150',257701,'DAILY SHIFT','2022-07-02','2022-07-02 07:03:53','2022-07-03 07:03:53','507',0.00,0.00,'507','2022-07-02 20:18:25','507','2022-07-02 20:18:50',10,0),('1','150',257702,'DAILY SHIFT','2022-07-03','2022-07-03 07:00:15','2022-07-04 07:00:15','507',0.00,0.00,'507','2022-07-03 14:15:28','507','2022-07-03 14:16:02',10,0),('1','150',257703,'DAILY SHIFT','2022-07-03','2022-07-03 14:27:29','2022-07-04 14:27:29','507',0.00,0.00,'507','2022-07-03 19:45:32','507','2022-07-03 19:46:33',10,0),('1','150',257704,'DAILY SHIFT','2022-07-04','2022-07-04 07:35:35','2022-07-05 07:35:35','507',0.00,0.00,'507','2022-07-04 20:05:02','507','2022-07-04 20:05:19',10,0),('1','150',257705,'DAILY SHIFT','2022-07-05','2022-07-05 05:34:21','2022-07-06 05:34:21','507',0.00,0.00,'507','2022-07-05 19:55:10','507','2022-07-05 19:55:42',10,0),('1','150',257706,'DAILY SHIFT','2022-07-06','2022-07-06 05:45:52','2022-07-07 05:45:52','507',0.00,0.00,'507','2022-07-06 19:44:23','507','2022-07-06 19:44:45',10,0),('1','150',257707,'DAILY SHIFT','2022-07-07','2022-07-07 06:41:35','2022-07-08 06:41:35','507',0.00,0.00,'507','2022-07-07 19:52:22','507','2022-07-07 19:52:40',10,0),('1','150',257708,'DAILY SHIFT','2022-07-08','2022-07-08 07:30:09','2022-07-09 07:30:09','507',0.00,0.00,'507','2022-07-08 19:26:54','507','2022-07-08 19:27:18',10,0),('1','150',257709,'DAILY SHIFT','2022-07-09','2022-07-09 11:07:19','2022-07-10 11:07:19','507',0.00,0.00,'507','2022-07-09 15:27:44','507','2022-07-09 15:28:42',10,0),('1','150',257710,'DAILY SHIFT','2022-07-10','2022-07-10 07:46:10','2022-07-11 07:46:10','507',0.00,0.00,'507','2022-07-10 19:40:27','507','2022-07-10 19:41:03',10,0),('1','150',257711,'DAILY SHIFT','2022-07-11','2022-07-11 06:55:21','2022-07-12 06:55:21','507',0.00,0.00,'507','2022-07-11 19:19:21','507','2022-07-11 19:19:43',10,0),('1','150',257712,'DAILY SHIFT','2022-07-12','2022-07-12 07:24:45','2022-07-13 07:24:45','507',0.00,0.00,'507','2022-07-13 06:46:58','507','2022-07-13 06:47:37',10,0),('1','150',257713,'DAILY SHIFT','2022-07-13','2022-07-13 06:47:54','2022-07-14 06:47:54','507',0.00,0.00,'507','2022-07-13 13:58:17','507','2022-07-13 13:58:42',10,0),('1','150',257714,'DAILY SHIFT','2022-07-14','2022-07-14 06:54:57','2022-07-15 06:54:57','507',0.00,0.00,'507','2022-07-14 20:16:11','507','2022-07-14 20:20:14',10,0),('1','150',257715,'DAILY SHIFT','2022-07-15','2022-07-15 06:34:10','2022-07-16 06:34:10','507',0.00,0.00,'507','2022-07-15 20:03:09','507','2022-07-15 20:03:31',10,0),('1','150',257716,'DAILY SHIFT','2022-07-16','2022-07-16 06:37:24','2022-07-17 06:37:24','507',0.00,0.00,'507','2022-07-16 20:40:49','507','2022-07-16 20:41:14',10,0),('1','150',257717,'DAILY SHIFT','2022-07-17','2022-07-17 08:40:57','2022-07-18 08:40:57','507',0.00,0.00,'507','2022-07-17 19:45:20','507','2022-07-17 19:45:46',10,0),('1','150',257718,'DAILY SHIFT','2022-07-18','2022-07-18 06:37:59','2022-07-19 06:37:59','507',0.00,0.00,'507','2022-07-18 19:49:33','507','2022-07-18 19:49:53',10,0),('1','150',257719,'DAILY SHIFT','2022-07-19','2022-07-19 06:35:44','2022-07-20 06:35:44','507',0.00,0.00,'507','2022-07-20 07:08:57','507','2022-07-20 07:09:38',10,0),('1','150',257720,'DAILY SHIFT','2022-07-20','2022-07-20 07:09:58','2022-07-21 07:09:58','507',0.00,0.00,'507','2022-07-20 20:11:55','507','2022-07-20 20:12:29',10,0),('1','150',257721,'DAILY SHIFT','2022-07-21','2022-07-21 06:55:35','2022-07-22 06:55:35','507',0.00,0.00,'507','2022-07-21 19:48:19','507','2022-07-21 19:48:43',10,0),('1','150',257722,'DAILY SHIFT','2022-07-22','2022-07-22 09:31:02','2022-07-23 09:31:02','507',0.00,0.00,'507','2022-07-22 14:31:28','507','2022-07-22 14:31:55',10,0),('1','150',257723,'DAILY SHIFT','2022-07-22','2022-07-22 14:32:20','2022-07-23 14:32:20','507',0.00,0.00,'507','2022-07-22 19:31:59','507','2022-07-22 19:32:32',10,0),('1','150',257724,'DAILY SHIFT','2022-07-23','2022-07-23 05:40:27','2022-07-24 05:40:27','507',0.00,0.00,'507','2022-07-23 19:48:04','507','2022-07-23 19:48:24',10,0),('1','150',257725,'DAILY SHIFT','2022-07-24','2022-07-24 06:50:25','2022-07-25 06:50:25','507',0.00,0.00,'507','2022-07-24 20:32:16','507','2022-07-24 20:32:44',10,0),('1','150',257726,'DAILY SHIFT','2022-07-25','2022-07-25 05:43:26','2022-07-26 05:43:26','507',0.00,0.00,'507','2022-07-25 12:18:19','507','2022-07-25 12:18:43',10,0),('1','150',257727,'DAILY SHIFT','2022-07-25','2022-07-25 12:19:12','2022-07-26 12:19:12','507',0.00,0.00,'507','2022-07-25 19:42:29','507','2022-07-25 19:42:51',10,0),('1','150',257728,'DAILY SHIFT','2022-07-26','2022-07-26 05:53:28','2022-07-27 05:53:28','507',0.00,0.00,'507','2022-07-26 20:15:40','507','2022-07-26 20:16:03',10,0),('1','150',257729,'DAILY SHIFT','2022-07-27','2022-07-27 05:49:19','2022-07-28 05:49:19','507',0.00,0.00,'507','2022-07-27 19:52:29','507','2022-07-27 19:53:02',10,0),('1','150',257730,'DAILY SHIFT','2022-07-28','2022-07-28 05:32:03','2022-07-29 05:32:03','507',0.00,0.00,'507','2022-07-28 12:20:18','507','2022-07-28 12:20:48',10,0),('1','150',257731,'DAILY SHIFT','2022-07-28','2022-07-28 12:39:21','2022-07-29 12:39:21','507',0.00,0.00,'507','2022-07-28 19:32:51','507','2022-07-28 19:33:15',10,0),('1','150',257732,'DAILY SHIFT','2022-07-29','2022-07-29 05:35:38','2022-07-30 05:35:38','507',0.00,0.00,'507','2022-07-29 20:31:27','507','2022-07-29 20:31:47',10,0),('1','150',257733,'DAILY SHIFT','2022-07-30','2022-07-30 07:22:28','2022-07-31 07:22:28','507',0.00,0.00,'507','2022-07-30 18:47:46','507','2022-07-30 18:48:45',10,0),('1','150',257734,'DAILY SHIFT','2022-07-31','2022-07-31 05:59:49','2022-08-01 05:59:49','507',0.00,0.00,'507','2022-07-31 10:16:26','507','2022-07-31 10:16:45',10,0),('1','150',257735,'DAILY SHIFT','2022-07-31','2022-07-31 10:17:12','2022-08-01 10:17:12','507',0.00,0.00,'507','2022-07-31 19:55:27','507','2022-07-31 19:55:49',10,0),('1','150',257736,'DAILY SHIFT','2022-08-01','2022-08-01 05:38:11','2022-08-02 05:38:11','507',0.00,0.00,'507','2022-08-01 19:50:58','507','2022-08-01 19:51:28',10,0),('1','150',257737,'DAILY SHIFT','2022-08-02','2022-08-02 05:39:05','2022-08-03 05:39:05','507',0.00,0.00,'507','2022-08-02 14:21:40','507','2022-08-02 14:22:15',10,0),('1','150',257738,'DAILY SHIFT','2022-08-02','2022-08-02 16:38:04','2022-08-03 16:38:04','507',0.00,0.00,'507','2022-08-02 19:44:37','507','2022-08-02 19:45:00',10,0),('1','150',257739,'DAILY SHIFT','2022-08-03','2022-08-03 06:11:19','2022-08-04 06:11:19','507',0.00,0.00,'507','2022-08-03 19:51:12','507','2022-08-03 19:52:18',10,0),('1','150',257740,'DAILY SHIFT','2022-08-04','2022-08-04 05:40:46','2022-08-05 05:40:46','507',0.00,0.00,'507','2022-08-04 19:55:19','507','2022-08-04 19:55:52',10,0),('1','150',257741,'DAILY SHIFT','2022-08-05','2022-08-05 07:16:57','2022-08-06 07:16:57','507',0.00,0.00,'507','2022-08-05 14:00:12','507','2022-08-05 14:00:57',10,0),('1','150',257742,'DAILY SHIFT','2022-08-05','2022-08-05 14:04:08','2022-08-06 14:04:08','507',0.00,0.00,'507','2022-08-05 20:03:17','507','2022-08-05 20:03:45',10,0),('1','150',257743,'DAILY SHIFT','2022-08-06','2022-08-06 06:18:15','2022-08-07 06:18:15','507',0.00,0.00,'507','2022-08-06 20:08:45','507','2022-08-06 20:09:16',10,0),('1','150',257744,'DAILY SHIFT','2022-08-07','2022-08-07 06:39:30','2022-08-08 06:39:30','507',0.00,0.00,'507','2022-08-07 17:52:30','507','2022-08-07 17:52:56',10,0),('1','150',257745,'DAILY SHIFT','2022-08-08','2022-08-08 06:44:50','2022-08-09 06:44:50','507',0.00,0.00,'507','2022-08-08 20:12:32','507','2022-08-08 20:12:59',10,0),('1','150',257746,'DAILY SHIFT','2022-08-09','2022-08-09 06:40:51','2022-08-10 06:40:51','507',0.00,0.00,'507','2022-08-09 20:07:29','507','2022-08-09 20:08:21',10,0),('1','150',257747,'DAILY SHIFT','2022-08-10','2022-08-10 06:41:30','2022-08-11 06:41:30','507',0.00,0.00,'507','2022-08-10 20:04:38','507','2022-08-10 20:05:01',10,0),('1','150',257748,'DAILY SHIFT','2022-08-11','2022-08-11 06:40:41','2022-08-12 06:40:41','507',0.00,0.00,'507','2022-08-11 09:57:47','507','2022-08-11 09:58:05',10,0),('1','150',257749,'DAILY SHIFT','2022-08-11','2022-08-11 10:05:58','2022-08-12 10:05:58','507',0.00,0.00,'507','2022-08-11 19:51:36','507','2022-08-11 19:52:03',10,0),('1','150',257750,'DAILY SHIFT','2022-08-12','2022-08-12 06:38:39','2022-08-13 06:38:39','507',0.00,0.00,'507','2022-08-12 19:57:09','507','2022-08-12 19:57:33',10,0),('1','150',257751,'DAILY SHIFT','2022-08-13','2022-08-13 06:38:35','2022-08-14 06:38:35','507',0.00,0.00,'507','2022-08-13 19:21:19','507','2022-08-13 19:22:06',10,0),('1','150',257752,'DAILY SHIFT','2022-08-14','2022-08-14 06:39:37','2022-08-15 06:39:37','507',0.00,0.00,'507','2022-08-14 10:13:25','507','2022-08-14 10:13:54',10,0),('1','150',257753,'DAILY SHIFT','2022-08-14','2022-08-14 10:14:15','2022-08-15 10:14:15','507',0.00,0.00,'507','2022-08-14 18:57:55','507','2022-08-14 18:58:20',10,0),('1','150',257754,'DAILY SHIFT','2022-08-15','2022-08-15 10:09:37','2022-08-16 10:09:37','507',0.00,0.00,'507','2022-08-15 20:23:06','507','2022-08-15 20:23:31',10,0),('1','150',257755,'DAILY SHIFT','2022-08-16','2022-08-16 06:46:02','2022-08-17 06:46:02','507',0.00,0.00,'507','2022-08-16 14:57:03','507','2022-08-16 14:57:20',10,0),('1','150',257756,'DAILY SHIFT','2022-08-16','2022-08-16 15:02:44','2022-08-17 15:02:44','507',0.00,0.00,'507','2022-08-16 19:31:59','507','2022-08-16 19:32:17',10,0),('1','150',257757,'DAILY SHIFT','2022-08-17','2022-08-17 06:24:49','2022-08-18 06:24:49','507',0.00,0.00,'507','2022-08-17 19:38:48','507','2022-08-17 19:39:09',10,0),('1','150',257758,'DAILY SHIFT','2022-08-18','2022-08-18 06:38:34','2022-08-19 06:38:34','507',0.00,0.00,'507','2022-08-18 19:33:00','507','2022-08-18 19:33:49',10,0),('1','150',257759,'DAILY SHIFT','2022-08-19','2022-08-19 08:45:28','2022-08-20 08:45:28','507',0.00,0.00,'507','2022-08-19 19:17:22','507','2022-08-19 19:17:43',10,0),('1','150',257760,'DAILY SHIFT','2022-08-20','2022-08-20 06:57:26','2022-08-21 06:57:26','507',0.00,0.00,'507','2022-08-20 19:45:46','507','2022-08-20 19:46:36',10,0),('1','150',257761,'DAILY SHIFT','2022-08-21','2022-08-21 06:41:47','2022-08-22 06:41:47','507',0.00,0.00,'507','2022-08-21 19:39:10','507','2022-08-21 19:39:35',10,0),('1','150',257762,'DAILY SALES','2022-08-22','2022-08-22 07:11:52','2022-08-23 07:11:52','507',0.00,0.00,'507','2022-08-22 17:11:46','507','2022-08-22 17:12:02',10,0),('1','150',257763,'DAILY SALES','2022-08-23','2022-08-23 06:59:35','2022-08-24 06:59:35','507',0.00,0.00,'507','2022-08-24 06:32:24','507','2022-08-24 06:32:51',10,0),('1','150',257764,'Daily Shift ','2022-08-24','2022-08-24 06:43:33','2022-08-25 06:43:33','507',0.00,0.00,'507','2022-08-24 19:32:45','507','2022-08-24 19:33:09',10,0),('1','150',257765,'Daily Shift ','2022-08-25','2022-08-25 06:32:18','2022-08-26 06:32:18','507',0.00,0.00,'507','2022-08-25 20:11:59','507','2022-08-25 20:12:18',10,0),('1','150',257766,'DAILY SALES','2022-08-26','2022-08-26 06:10:46','2022-08-27 06:10:46','507',0.00,0.00,'507','2022-08-26 14:19:24','507','2022-08-26 14:19:52',10,0),('1','150',257767,'DAILY SALES','2022-08-27','2022-08-27 14:12:00','2022-08-28 14:12:00','507',0.00,0.00,'507','2022-08-27 20:14:04','507','2022-08-27 20:14:23',10,0),('1','150',257768,'DAILY SALES','2022-08-28','2022-08-28 07:02:02','2022-08-29 07:02:02','507',0.00,0.00,'507','2022-08-28 19:48:10','507','2022-08-28 19:48:29',10,0),('1','150',257769,'DAILY SALES','2022-08-29','2022-08-29 06:40:30','2022-08-30 06:40:30','507',0.00,0.00,'507','2022-08-29 17:35:16','507','2022-08-29 17:35:47',10,0),('1','150',257770,'DAILY SALES','2022-08-29','2022-08-29 17:36:42','2022-08-30 17:36:42','507',0.00,0.00,'507','2022-08-29 20:20:12','507','2022-08-29 20:20:34',10,0),('1','150',257771,'DAILY SALES','2022-08-30','2022-08-30 06:21:27','2022-08-31 06:21:27','507',0.00,0.00,'507','2022-08-30 19:47:55','507','2022-08-30 19:48:54',10,0),('1','150',257772,'DAILY SALES','2022-08-31','2022-08-31 06:14:20','2022-09-01 06:14:20','507',0.00,0.00,'507','2022-08-31 19:36:48','507','2022-08-31 19:37:16',10,0),('1','150',257773,'DAILY SALES','2022-09-01','2022-09-01 06:22:49','2022-09-02 06:22:49','507',0.00,0.00,'507','2022-09-01 08:09:56','507','2022-09-01 08:10:37',10,0),('1','150',257774,'DAILY SALES','2022-09-01','2022-09-01 10:07:26','2022-09-02 10:07:26','507',0.00,0.00,'507','2022-09-01 20:16:42','507','2022-09-01 20:17:15',10,0),('1','150',257775,'DAILY SALES','2022-09-02','2022-09-02 07:44:29','2022-09-03 07:44:29','507',0.00,0.00,'507','2022-09-02 19:49:24','507','2022-09-02 19:49:50',10,0),('1','150',257776,'DAILY SALES','2022-09-03','2022-09-03 06:14:42','2022-09-04 06:14:42','507',0.00,0.00,'507','2022-09-03 15:31:34','507','2022-09-03 15:32:07',10,0),('1','150',257777,'OPERATIONAL LOST','2022-09-03','2022-09-03 15:34:54','2022-09-04 15:34:54','507',0.00,0.00,'507','2022-09-03 15:37:41','507','2022-09-03 15:38:24',10,0),('1','150',257778,'DAILY SALES','2022-09-04','2022-09-04 06:29:31','2022-09-05 06:29:31','507',0.00,0.00,'507','2022-09-04 19:44:39','507','2022-09-04 19:45:04',10,0),('1','150',257779,'DAILY SALES','2022-09-05','2022-09-05 06:33:56','2022-09-06 06:33:56','507',0.00,0.00,'507','2022-09-05 14:16:28','507','2022-09-05 14:16:48',10,0),('1','150',257780,'OPERATIONAL LOST','2022-09-05','2022-09-05 14:17:33','2022-09-06 14:17:33','507',0.00,0.00,'507','2022-09-05 14:21:47','507','2022-09-05 14:22:20',10,0),('1','150',257781,'DAILY SALES','2022-09-05','2022-09-05 14:22:51','2022-09-06 14:22:51','507',0.00,0.00,'507','2022-09-05 19:49:47','507','2022-09-05 19:50:10',10,0),('1','150',257782,'DAILY SALES','2022-09-06','2022-09-06 06:01:01','2022-09-07 06:01:01','507',0.00,0.00,'507','2022-09-06 20:01:21','507','2022-09-06 20:01:48',10,0),('1','150',257783,'DAILY SALES','2022-09-07','2022-09-07 06:01:39','2022-09-08 06:01:39','507',0.00,0.00,'507','2022-09-07 19:44:17','507','2022-09-07 19:50:01',10,0),('1','150',257784,'DAILY SALES','2022-09-08','2022-09-08 05:58:56','2022-09-09 05:58:56','507',0.00,0.00,'507','2022-09-08 12:57:35','507','2022-09-08 12:57:53',10,0),('1','150',257785,'DAILY SALES','2022-09-08','2022-09-08 12:58:22','2022-09-09 12:58:22','507',0.00,0.00,'507','2022-09-08 20:09:49','507','2022-09-08 20:10:18',10,0),('1','150',257786,'DAILY SALES','2022-09-09','2022-09-09 06:05:05','2022-09-10 06:05:05','507',0.00,0.00,'507','2022-09-09 19:37:52','507','2022-09-09 19:38:15',10,0),('1','150',257787,'DAILY SALES','2022-09-10','2022-09-10 05:43:42','2022-09-11 05:43:42','507',0.00,0.00,'507','2022-09-10 19:54:07','507','2022-09-10 19:54:29',10,0),('1','150',257788,'DAILY SALES','2022-09-11','2022-09-11 05:46:42','2022-09-12 05:46:42','507',0.00,0.00,'507','2022-09-11 10:41:34','507','2022-09-11 10:41:57',10,0),('1','150',257789,'OPERATIONAL LOST','2022-09-11','2022-09-11 10:42:16','2022-09-12 10:42:16','507',0.00,0.00,'507','2022-09-11 10:43:44','507','2022-09-11 10:44:03',10,0),('1','150',257790,'DAILY SALES','2022-09-13','2022-09-13 06:45:44','2022-09-14 06:45:44','507',0.00,0.00,'507','2022-09-13 20:07:27','507','2022-09-13 20:08:13',10,0),('1','150',257791,'DAILY SALES','2022-09-14','2022-09-14 06:45:50','2022-09-15 06:45:50','507',0.00,0.00,'507','2022-09-14 20:12:50','507','2022-09-14 20:13:07',10,0),('1','150',257792,'DAILY SALES','2022-09-15','2022-09-15 06:43:33','2022-09-16 06:43:33','507',0.00,0.00,'507','2022-09-15 19:48:03','507','2022-09-15 19:48:29',10,0),('1','150',257793,'OPERATIONAL LOST','2022-09-15','2022-09-15 19:48:52','2022-09-16 19:48:52','507',0.00,0.00,'507','2022-09-15 19:50:29','507','2022-09-15 19:50:54',10,0),('1','150',257794,'DAILY SALES','2022-09-16','2022-09-16 06:41:15','2022-09-17 06:41:15','507',0.00,0.00,'507','2022-09-16 19:42:30','507','2022-09-16 19:43:30',10,0),('1','150',257795,'DAILY SALES','2022-09-17','2022-09-17 07:06:47','2022-09-18 07:06:47','507',0.00,0.00,'507','2022-09-17 20:21:31','507','2022-09-17 20:22:11',10,0),('1','150',257796,'DAILY SALES','2022-09-18','2022-09-18 06:09:54','2022-09-19 06:09:54','507',0.00,0.00,'507','2022-09-18 14:19:10','507','2022-09-18 14:19:40',10,0),('1','150',257797,'DAILY SALES','2022-09-20','2022-09-20 06:18:22','2022-09-21 06:18:22','507',0.00,0.00,'507','2022-09-20 20:24:49','507','2022-09-20 20:25:11',10,0),('1','150',257798,'DAILY SALES','2022-09-21','2022-09-21 06:27:40','2022-09-22 06:27:40','507',0.00,0.00,'507','2022-09-21 20:06:34','507','2022-09-21 20:06:50',10,0),('1','150',257799,'DAILY SALES','2022-09-22','2022-09-22 06:13:18','2022-09-23 06:13:18','507',0.00,0.00,'507','2022-09-22 18:12:54','507','2022-09-22 18:13:14',10,0),('1','150',257800,'OPERATIONAL LOST','2022-09-22','2022-09-22 18:26:26','2022-09-23 18:26:26','507',0.00,0.00,'507','2022-09-22 18:27:08','507','2022-09-22 18:27:34',10,0),('1','150',257801,'OPERATIONAL LOST','2022-09-22','2022-09-22 20:37:18','2022-09-23 20:37:18','507',0.00,0.00,'507','2022-09-22 20:39:02','507','2022-09-22 20:39:43',10,0),('1','150',257802,'DAILY SALES','2022-09-23','2022-09-23 06:12:25','2022-09-24 06:12:25','507',0.00,0.00,'507','2022-09-23 19:26:54','507','2022-09-23 19:27:13',10,0),('1','150',257803,'DAILY SALES','2022-09-24','2022-09-24 06:15:41','2022-09-25 06:15:41','507',0.00,0.00,'507','2022-09-24 19:34:48','507','2022-09-24 19:58:52',10,0),('1','150',257804,'DAILY SALES','2022-09-25','2022-09-25 06:08:37','2022-09-26 06:08:37','507',0.00,0.00,'507','2022-09-25 15:07:02','507','2022-09-25 15:07:22',10,0),('1','150',257805,'DAILY SALES','2022-09-26','2022-09-26 06:14:58','2022-09-27 06:14:58','507',0.00,0.00,'507','2022-09-26 20:58:28','507','2022-09-26 20:58:49',10,0),('1','150',257806,'DAILY SALES','2022-09-27','2022-09-27 06:29:14','2022-09-28 06:29:14','507',0.00,0.00,'507','2022-09-27 20:23:57','507','2022-09-27 20:24:19',10,0),('1','150',257807,'DAILY SALES','2022-09-28','2022-09-28 06:17:26','2022-09-29 06:17:26','507',0.00,0.00,'507','2022-09-28 14:10:31','507','2022-09-28 14:11:05',10,0),('1','150',257808,'DAILY SALES','2022-09-28','2022-09-28 14:12:25','2022-09-29 14:12:25','507',0.00,0.00,'507','2022-09-28 20:14:36','507','2022-09-28 20:14:56',10,0),('1','150',257809,'DAILY SALES','2022-09-29','2022-09-29 06:17:53','2022-09-30 06:17:53','507',0.00,0.00,'507','2022-09-29 20:01:55','507','2022-09-29 20:02:15',10,0),('1','150',257810,'DAILY SALES','2022-09-30','2022-09-30 06:11:01','2022-10-01 06:11:01','507',0.00,0.00,'507','2022-09-30 20:24:19','507','2022-09-30 20:24:37',10,0),('1','150',257811,'DAILY SALES','2022-10-01','2022-10-01 06:55:27','2022-10-02 06:55:27','507',0.00,0.00,'507','2022-10-01 08:22:38','507','2022-10-01 08:22:58',10,0),('1','150',257812,'DAILY SALES','2022-10-01','2022-10-01 08:23:21','2022-10-02 08:23:21','507',0.00,0.00,'507','2022-10-01 20:15:37','507','2022-10-01 20:15:54',10,0),('1','150',257813,'DAILY SALES','2022-10-02','2022-10-02 06:59:38','2022-10-03 06:59:38','507',0.00,0.00,'507','2022-10-02 20:20:45','507','2022-10-02 20:21:07',10,0),('1','150',257814,'DAILY SALES','2022-10-03','2022-10-03 06:33:26','2022-10-04 06:33:26','507',0.00,0.00,'507','2022-10-03 13:53:04','507','2022-10-03 13:53:20',10,0),('1','150',257815,'OPERATIONAL LOST','2022-10-03','2022-10-03 13:53:45','2022-10-04 13:53:45','507',0.00,0.00,'507','2022-10-03 13:54:52','507','2022-10-03 13:55:11',10,0),('1','150',257816,'DAILY SALES','2022-10-04','2022-10-04 09:59:26','2022-10-05 09:59:26','507',0.00,0.00,'507','2022-10-04 20:04:05','507','2022-10-04 20:04:26',10,0),('1','150',257817,'DAILY SALES','2022-10-05','2022-10-05 06:30:49','2022-10-06 06:30:49','507',0.00,0.00,'507','2022-10-05 20:05:38','507','2022-10-05 20:09:05',10,0),('1','150',257818,'DAILY SALES','2022-10-06','2022-10-06 06:44:09','2022-10-07 06:44:09','507',0.00,0.00,'507','2022-10-06 11:27:26','507','2022-10-06 11:27:48',10,0),('1','150',257819,'OPERATIONAL LOST','2022-10-06','2022-10-06 11:28:06','2022-10-07 11:28:06','507',0.00,0.00,'507','2022-10-06 11:29:04','507','2022-10-06 11:29:20',10,0),('1','150',257820,'DAILY SALES','2022-10-07','2022-10-07 08:21:38','2022-10-08 08:21:38','507',0.00,0.00,'507','2022-10-07 20:03:12','507','2022-10-07 20:03:29',10,0),('1','150',257821,'DAILY SALES','2022-10-08','2022-10-08 06:56:28','2022-10-09 06:56:28','507',0.00,0.00,'507','2022-10-08 15:04:33','507','2022-10-08 15:04:59',10,0),('1','150',257822,'OPERATIONAL LOST','2022-10-08','2022-10-08 15:06:01','2022-10-09 15:06:01','507',0.00,0.00,'507','2022-10-08 15:07:18','507','2022-10-08 15:07:37',10,0),('1','150',257823,'DAILY SALES','2022-10-09','2022-10-09 08:58:41','2022-10-10 08:58:41','507',0.00,0.00,'507','2022-10-09 20:00:26','507','2022-10-09 20:00:54',10,0),('1','150',257824,'DAILY SALES','2022-10-10','2022-10-10 06:34:55','2022-10-11 06:34:55','507',0.00,0.00,'507','2022-10-10 15:04:15','507','2022-10-10 15:04:33',10,0),('1','150',257825,'OPERATIONAL LOST','2022-10-10','2022-10-10 15:05:04','2022-10-11 15:05:04','507',0.00,0.00,'507','2022-10-10 15:05:50','507','2022-10-10 15:06:08',10,0),('1','150',257826,'DAILY SALES','2022-10-12','2022-10-12 06:42:08','2022-10-13 06:42:08','507',0.00,0.00,'507','2022-10-12 20:09:57','507','2022-10-12 20:10:17',10,0),('1','150',257827,'DAILY SALES','2022-10-13','2022-10-13 06:35:07','2022-10-14 06:35:07','507',0.00,0.00,'507','2022-10-13 19:57:58','507','2022-10-13 19:58:18',10,0),('1','150',257828,'OPERATIONAL LOST','2022-10-13','2022-10-13 19:58:42','2022-10-14 19:58:42','507',0.00,0.00,'507','2022-10-13 19:59:34','507','2022-10-13 19:59:50',10,0),('1','150',257829,'DAILY SALES','2022-10-14','2022-10-14 13:49:43','2022-10-15 13:49:43','507',0.00,0.00,'507','2022-10-14 19:11:38','507','2022-10-14 19:11:59',10,0),('1','150',257830,'DAILY SALES','2022-10-15','2022-10-15 06:38:49','2022-10-16 06:38:49','507',0.00,0.00,'507','2022-10-15 20:22:40','507','2022-10-15 20:23:04',10,0),('1','150',257831,'DAILY SALES','2022-10-16','2022-10-16 06:39:06','2022-10-17 06:39:06','507',0.00,0.00,'507','2022-10-16 20:09:46','507','2022-10-16 20:10:04',10,0),('1','150',257832,'DAILY SALES','2022-10-17','2022-10-17 06:19:36','2022-10-18 06:19:36','507',0.00,0.00,'507','2022-10-17 20:03:43','507','2022-10-17 20:04:11',10,0),('1','150',257833,'DAILY SALES','2022-10-18','2022-10-18 06:19:18','2022-10-19 06:19:18','507',0.00,0.00,'507','2022-10-18 19:45:14','507','2022-10-18 19:45:37',10,0),('1','150',257834,'DAILY SALES','2022-10-19','2022-10-19 06:27:19','2022-10-20 06:27:19','507',0.00,0.00,'507','2022-10-19 20:04:24','507','2022-10-19 20:04:43',10,0),('1','150',257835,'DAILY SALES','2022-10-20','2022-10-20 09:38:01','2022-10-21 09:38:01','507',0.00,0.00,'507','2022-10-20 19:11:48','507','2022-10-20 19:12:09',10,0),('1','150',257836,'DAILY SALES','2022-10-21','2022-10-21 06:12:39','2022-10-22 06:12:39','507',0.00,0.00,'507','2022-10-21 19:14:49','507','2022-10-21 19:15:12',10,0),('1','150',257837,'DAILY SALES','2022-10-22','2022-10-22 06:24:47','2022-10-23 06:24:47','507',0.00,0.00,'507','2022-10-22 19:59:34','507','2022-10-22 19:59:58',10,0),('1','150',257838,'DAILY SALES','2022-10-23','2022-10-23 06:12:54','2022-10-24 06:12:54','507',0.00,0.00,'507','2022-10-23 11:13:24','507','2022-10-23 11:13:51',10,0),('1','150',257839,'OPERATIONAL LOST','2022-10-23','2022-10-23 11:14:24','2022-10-24 11:14:24','507',0.00,0.00,'507','2022-10-23 11:15:30','507','2022-10-23 11:15:51',10,0),('1','150',257840,'DAILY SALES','2022-10-23','2022-10-23 11:16:13','2022-10-24 11:16:13','507',0.00,0.00,'507','2022-10-23 19:51:54','507','2022-10-23 19:52:18',10,0),('1','150',257841,'DAILY SALES','2022-10-24','2022-10-24 06:07:59','2022-10-25 06:07:59','507',0.00,0.00,'507','2022-10-24 19:23:41','507','2022-10-24 19:24:01',10,0),('1','150',257842,'DAILY SALES','2022-10-25','2022-10-25 06:06:47','2022-10-26 06:06:47','507',0.00,0.00,'507','2022-10-25 19:03:45','507','2022-10-25 19:04:13',10,0),('1','150',257843,'DAILY SALES','2022-10-26','2022-10-26 06:07:21','2022-10-27 06:07:21','507',0.00,0.00,'507','2022-10-26 10:40:57','507','2022-10-26 10:41:37',10,0),('1','150',257844,'OPERATIONAL LOST','2022-10-26','2022-10-26 11:56:32','2022-10-27 11:56:32','507',0.00,0.00,'507','2022-10-26 11:57:58','507','2022-10-26 11:58:16',10,0),('1','150',257845,'DAILY SALES','2022-10-27','2022-10-27 06:01:40','2022-10-28 06:01:40','507',0.00,0.00,'507','2022-10-27 19:27:38','507','2022-10-27 19:27:58',10,0),('1','150',257846,'DAILY SALES','2022-10-28','2022-10-28 06:04:29','2022-10-29 06:04:29','507',0.00,0.00,'507','2022-10-28 19:20:23','507','2022-10-28 19:20:46',10,0),('1','150',257847,'DAILY SALES','2022-10-29','2022-10-29 05:58:03','2022-10-30 05:58:03','507',0.00,0.00,'507','2022-10-29 19:36:31','507','2022-10-29 19:36:50',10,0),('1','150',257848,'DAILY SALES','2022-10-30','2022-10-30 06:09:05','2022-10-31 06:09:05','507',0.00,0.00,'507','2022-10-30 10:36:34','507','2022-10-30 10:36:53',10,0),('1','150',257849,'OPERATIONAL LOST','2022-10-30','2022-10-30 10:48:20','2022-10-31 10:48:20','507',0.00,0.00,'507','2022-10-30 10:49:13','507','2022-10-30 10:49:29',10,0),('1','150',257850,'DAILY SALES','2022-10-30','2022-10-30 10:49:47','2022-10-31 10:49:47','507',0.00,0.00,'507','2022-10-30 19:02:45','507','2022-10-30 19:03:05',10,0),('1','150',257851,'DAILY SALES','2022-10-31','2022-10-31 06:10:34','2022-11-01 06:10:34','507',0.00,0.00,'507','2022-10-31 19:54:21','507','2022-10-31 19:54:37',10,0),('1','150',257852,'DAILY SALES','2022-11-01','2022-11-01 06:06:00','2022-11-02 06:06:00','507',0.00,0.00,'507','2022-11-01 20:40:59','507','2022-11-01 20:41:20',10,0),('1','150',257853,'DAILY SALES','2022-11-02','2022-11-02 06:12:29','2022-11-03 06:12:29','507',0.00,0.00,'507','2022-11-02 14:04:50','507','2022-11-02 14:05:13',10,0),('1','150',257854,'OPERATIONAL LOST','2022-11-02','2022-11-02 14:06:34','2022-11-03 14:06:34','507',0.00,0.00,'507','2022-11-02 14:09:49','507','2022-11-02 14:10:07',10,0),('1','150',257855,'DAILY SALES','2022-11-04','2022-11-04 07:10:29','2022-11-05 07:10:29','507',0.00,0.00,'507','2022-11-04 19:12:04','507','2022-11-04 19:12:37',10,0),('1','150',257856,'DAILY SALES ','2022-11-05','2022-11-05 08:34:22','2022-11-06 08:34:22','507',0.00,0.00,'507','2022-11-05 20:04:29','507','2022-11-05 20:04:58',10,0),('1','150',257857,'DAILY SALES','2022-11-06','2022-11-06 08:25:35','2022-11-07 08:25:35','507',0.00,0.00,'507','2022-11-06 20:41:59','507','2022-11-06 20:42:21',10,0),('1','150',257858,'DAILY SALES','2022-11-07','2022-11-07 07:13:10','2022-11-08 07:13:10','507',0.00,0.00,'507','2022-11-07 09:10:39','507','2022-11-07 09:11:26',10,0),('1','150',257859,'OPERATIONAL LOST','2022-11-07','2022-11-07 09:11:59','2022-11-08 09:11:59','507',0.00,0.00,'507','2022-11-07 09:17:49','507','2022-11-07 09:18:21',10,0),('1','150',257860,'DAILY SALES','2022-11-07','2022-11-07 09:21:06','2022-11-08 09:21:06','507',0.00,0.00,'507','2022-11-07 19:30:43','507','2022-11-07 19:31:27',10,0),('1','150',257861,'DAILY SALES','2022-11-08','2022-11-08 06:02:09','2022-11-09 06:02:09','507',0.00,0.00,'507','2022-11-08 19:14:20','507','2022-11-08 19:14:45',10,0),('1','150',257862,'DAILY SALES','2022-11-09','2022-11-09 06:00:23','2022-11-10 06:00:23','507',0.00,0.00,'507','2022-11-09 19:16:29','507','2022-11-09 19:17:12',10,0),('1','150',257863,'DAILY SALES','2022-11-10','2022-11-10 06:00:22','2022-11-11 06:00:22','507',0.00,0.00,'507','2022-11-10 18:43:36','507','2022-11-10 18:44:06',10,0),('1','150',257864,'DAILY SALES','2022-11-11','2022-11-11 06:00:14','2022-11-12 06:00:14','507',0.00,0.00,'507','2022-11-11 09:58:35','507','2022-11-11 09:58:56',10,0),('1','150',257865,'OPERATIONAL LOST','2022-11-11','2022-11-11 09:59:47','2022-11-12 09:59:47','507',0.00,0.00,'507','2022-11-11 10:04:38','507','2022-11-11 10:05:26',10,0),('1','150',257866,'DAILY SALES','2022-11-11','2022-11-11 10:58:11','2022-11-12 10:58:11','507',0.00,0.00,'507','2022-11-11 19:13:35','507','2022-11-11 19:14:36',10,0),('1','150',257867,'DAILY SALES','2022-11-12','2022-11-12 06:16:06','2022-11-13 06:16:06','507',0.00,0.00,'507','2022-11-12 20:58:15','507','2022-11-12 20:59:51',10,0),('1','150',257868,'DAILY SALES','2022-11-13','2022-11-13 06:01:24','2022-11-14 06:01:24','507',0.00,0.00,'507','2022-11-13 19:34:26','507','2022-11-13 19:35:03',10,0),('1','150',257869,'DAILY SALES','2022-11-14','2022-11-14 06:01:01','2022-11-15 06:01:01','507',0.00,0.00,'507','2022-11-15 02:28:23','507','2022-11-15 02:29:12',10,0),('1','150',257870,'OPERATIONAL LOSS ','2022-11-15','2022-11-15 08:22:09','2022-11-16 08:22:09','507',0.00,0.00,'507','2022-11-15 08:28:05','507','2022-11-15 08:28:33',10,0),('1','150',257871,'DAILY SALES ','2022-11-15','2022-11-15 08:34:04','2022-11-16 08:34:04','507',0.00,0.00,'507','2022-11-15 20:10:15','507','2022-11-15 20:11:01',10,0),('1','150',257872,'DAILY SALES','2022-11-16','2022-11-16 05:46:49','2022-11-17 05:46:49','507',0.00,0.00,'507','2022-11-16 19:08:59','507','2022-11-16 19:09:42',10,0),('1','150',257873,'DAILY SALES','2022-11-17','2022-11-17 05:58:53','2022-11-18 05:58:53','507',0.00,0.00,'507','2022-11-17 20:38:53','507','2022-11-17 20:39:17',10,0),('1','150',257874,'DAILY SALES','2022-11-18','2022-11-18 06:05:06','2022-11-19 06:05:06','507',0.00,0.00,'507','2022-11-18 16:54:30','507','2022-11-18 16:54:51',10,0),('1','150',257875,'OPERATIONAL LOST','2022-11-18','2022-11-18 16:55:20','2022-11-19 16:55:20','507',0.00,0.00,'507','2022-11-18 16:56:50','507','2022-11-18 16:57:10',10,0),('1','150',257876,'DAILY SALES','2022-11-18','2022-11-18 17:14:20','2022-11-19 17:14:20','507',0.00,0.00,'507','2022-11-18 18:53:57','507','2022-11-18 18:54:17',10,0),('1','150',257877,'DAILY SALES','2022-11-19','2022-11-19 06:08:17','2022-11-20 06:08:17','507',0.00,0.00,'507','2022-11-19 19:09:58','507','2022-11-19 19:10:25',10,0),('1','150',257878,'DAILY SALES','2022-11-20','2022-11-20 07:13:49','2022-11-21 07:13:49','507',0.00,0.00,'507','2022-11-20 19:31:15','507','2022-11-20 19:31:40',10,0),('1','150',257879,'DAILY SALES','2022-11-21','2022-11-21 06:15:16','2022-11-22 06:15:16','507',0.00,0.00,'507','2022-11-21 20:05:07','507','2022-11-21 20:05:34',10,0),('1','150',257880,'DAILY SALES','2022-11-22','2022-11-22 06:24:33','2022-11-23 06:24:33','507',0.00,0.00,'507','2022-11-22 09:20:08','507','2022-11-22 09:20:39',10,0),('1','150',257881,'DAILY SALES','2022-11-22','2022-11-22 09:21:09','2022-11-23 09:21:09','507',0.00,0.00,'507','2022-11-22 19:05:44','507','2022-11-22 19:06:34',10,0),('1','150',257882,'DAILY SALES','2022-11-23','2022-11-23 06:27:06','2022-11-24 06:27:06','507',0.00,0.00,'507','2022-11-23 18:49:43','507','2022-11-23 18:50:18',10,0),('1','150',257883,'DAILY SALES','2022-11-24','2022-11-24 06:23:40','2022-11-25 06:23:40','507',0.00,0.00,'507','2022-11-24 19:00:11','507','2022-11-24 19:00:39',10,0),('1','150',257884,'DAILY SALES','2022-11-25','2022-11-25 06:08:04','2022-11-26 06:08:04','507',0.00,0.00,'507','2022-11-25 19:19:18','507','2022-11-25 19:19:50',10,0),('1','150',257885,'DAILY SALES','2022-11-26','2022-11-26 06:19:12','2022-11-27 06:19:12','507',0.00,0.00,'507','2022-11-26 11:09:11','507','2022-11-26 11:09:53',10,0),('1','150',257886,'DAILY SALES','2022-11-26','2022-11-26 12:22:45','2022-11-27 12:22:45','507',0.00,0.00,'507','2022-11-26 19:01:23','507','2022-11-26 19:01:52',10,0),('1','150',257887,'DAILY SALES','2022-11-27','2022-11-27 06:12:59','2022-11-28 06:12:59','507',0.00,0.00,'507','2022-11-27 18:56:10','507','2022-11-27 18:56:38',10,0),('1','150',257888,'DAILY SALES','2022-11-28','2022-11-28 06:28:53','2022-11-29 06:28:53','507',0.00,0.00,'507','2022-11-28 19:22:30','507','2022-11-28 19:22:53',10,0),('1','150',257889,'DAILY SALES','2022-11-29','2022-11-29 06:12:33','2022-11-30 06:12:33','507',0.00,0.00,'507','2022-11-29 14:01:08','507','2022-11-29 14:01:47',10,0),('1','150',257890,'DAILY SALES','2022-11-29','2022-11-29 16:08:55','2022-11-30 16:08:55','507',0.00,0.00,'507','2022-11-29 19:37:16','507','2022-11-29 19:37:54',10,0),('1','150',257891,'DAILY SALES ','2022-11-30','2022-11-30 06:42:37','2022-12-01 06:42:37','507',0.00,0.00,'507','2022-11-30 20:00:23','507','2022-11-30 20:00:46',10,0),('1','150',257892,'DAILY SALES','2022-12-01','2022-12-01 06:40:48','2022-12-02 06:40:48','507',0.00,0.00,'507','2022-12-01 20:23:50','507','2022-12-01 20:24:33',10,0),('1','150',257893,'DAILY SALES ','2022-12-02','2022-12-02 06:41:38','2022-12-03 06:41:38','507',0.00,0.00,'507','2022-12-02 19:09:51','507','2022-12-02 19:10:21',10,0),('1','150',257894,'DAILY SALES','2022-12-03','2022-12-03 06:52:45','2022-12-04 06:52:45','507',0.00,0.00,'507','2022-12-03 08:59:45','507','2022-12-03 09:00:16',10,0),('1','150',257895,'DAILY SALES','2022-12-03','2022-12-03 09:00:54','2022-12-04 09:00:54','507',0.00,0.00,'507','2022-12-03 19:00:12','507','2022-12-03 19:00:47',10,0),('1','150',257896,'DAILY SALES','2022-12-04','2022-12-04 06:47:46','2022-12-05 06:47:46','507',0.00,0.00,'507','2022-12-04 20:43:45','507','2022-12-04 20:44:10',10,0),('1','150',257897,'DAILY SALES','2022-12-05','2022-12-05 06:46:19','2022-12-06 06:46:19','507',0.00,0.00,'507','2022-12-05 19:37:56','507','2022-12-05 19:38:30',10,0),('1','150',257898,'OPERATIONAL LOST','2022-12-06','2022-12-06 11:25:27','2022-12-07 11:25:27','507',0.00,0.00,'507','2022-12-06 11:31:13','507','2022-12-06 11:31:49',10,0),('1','150',257899,'DAILY SALES','2022-12-06','2022-12-06 11:32:12','2022-12-07 11:32:12','507',0.00,0.00,'507','2022-12-06 11:53:07','507','2022-12-06 11:53:34',10,0),('1','150',257900,'DAILY SALES','2022-12-06','2022-12-06 11:53:58','2022-12-07 11:53:58','507',0.00,0.00,'507','2022-12-07 07:13:27','507','2022-12-07 07:13:55',10,0),('1','150',257901,'DAILY SALES','2022-12-07','2022-12-07 07:14:25','2022-12-08 07:14:25','507',0.00,0.00,'507','2022-12-07 19:37:25','507','2022-12-07 19:37:44',10,0),('1','150',257902,'DAILY SALES','2022-12-08','2022-12-08 06:58:27','2022-12-09 06:58:27','507',0.00,0.00,'507','2022-12-08 18:55:54','507','2022-12-08 18:56:20',10,0),('1','150',257903,'DAILY SALES ','2022-12-09','2022-12-09 06:28:01','2022-12-10 06:28:01','507',0.00,0.00,'507','2022-12-09 09:18:59','507','2022-12-09 09:19:17',10,0),('1','150',257904,'DAILY SALES','2022-12-09','2022-12-09 09:19:42','2022-12-10 09:19:42','507',0.00,0.00,'507','2022-12-09 19:05:46','507','2022-12-09 19:06:19',10,0),('1','150',257905,'Operation lost ','2022-12-10','2022-12-10 06:42:29','2022-12-11 06:42:29','507',0.00,0.00,'507','2022-12-10 06:50:29','507','2022-12-10 06:50:57',10,0),('1','150',257906,'DAILY SALES ','2022-12-10','2022-12-10 06:51:53','2022-12-11 06:51:53','507',0.00,0.00,'507','2022-12-10 19:35:42','507','2022-12-10 19:36:04',10,0),('1','150',257907,'DAILY SALES','2022-12-11','2022-12-11 06:43:44','2022-12-12 06:43:44','507',0.00,0.00,'507','2022-12-11 18:52:20','507','2022-12-11 18:52:47',10,0),('1','150',257908,'DAILY SALES','2022-12-12','2022-12-12 06:46:43','2022-12-13 06:46:43','507',0.00,0.00,'507','2022-12-12 15:40:47','507','2022-12-12 15:41:04',10,0),('1','150',257909,'OPERATIONAL LOST','2022-12-12','2022-12-12 15:58:38','2022-12-13 15:58:38','507',0.00,0.00,'507','2022-12-12 16:02:02','507','2022-12-12 16:02:19',10,0),('1','150',257910,'DAILY SALES','2022-12-12','2022-12-12 16:02:44','2022-12-13 16:02:44','507',0.00,0.00,'507','2022-12-12 19:10:42','507','2022-12-12 19:11:04',10,0),('1','150',257911,'DAILY SALES','2022-12-13','2022-12-13 06:50:55','2022-12-14 06:50:55','507',0.00,0.00,'507','2022-12-13 19:39:13','507','2022-12-13 19:39:38',10,0),('1','150',257912,'DAILY SALES ','2022-12-14','2022-12-14 06:44:47','2022-12-15 06:44:47','507',0.00,0.00,'507','2022-12-14 19:10:28','507','2022-12-14 19:11:11',10,0),('1','150',257913,'DAILY SALES','2022-12-15','2022-12-15 06:40:00','2022-12-16 06:40:00','507',0.00,0.00,'507','2022-12-15 19:06:44','507','2022-12-15 19:07:26',10,0),('1','150',257914,'DAILY SALES ','2022-12-16','2022-12-16 06:39:21','2022-12-17 06:39:21','507',0.00,0.00,'507','2022-12-16 17:21:01','507','2022-12-16 17:21:31',10,0),('1','150',257915,'DAILY SALES ','2022-12-17','2022-12-17 06:16:45','2022-12-18 06:16:45','507',0.00,0.00,'507','2022-12-17 19:10:57','507','2022-12-17 19:11:41',10,0),('1','150',257916,'DAILY SALES','2022-12-18','2022-12-18 06:36:59','2022-12-19 06:36:59','507',0.00,0.00,'507','2022-12-18 19:10:34','507','2022-12-18 19:11:27',10,0),('1','150',257917,'DAILY SALES','2022-12-19','2022-12-19 06:46:10','2022-12-20 06:46:10','507',0.00,0.00,'507','2022-12-19 19:04:28','507','2022-12-19 19:04:53',10,0),('1','150',257918,'DAILY SALES','2022-12-20','2022-12-20 07:04:01','2022-12-21 07:04:01','507',0.00,0.00,'507','2022-12-20 07:36:54','507','2022-12-20 07:37:14',10,0),('1','150',257919,'DAILY SALES','2022-12-20','2022-12-20 07:37:33','2022-12-21 07:37:33','507',0.00,0.00,'507','2022-12-20 19:34:08','507','2022-12-20 19:34:31',10,0),('1','150',257920,'DAILY SALES','2022-12-21','2022-12-21 06:49:10','2022-12-22 06:49:10','507',0.00,0.00,'507','2022-12-21 19:19:22','507','2022-12-21 19:19:50',10,0),('1','150',257921,'DAILY SALES ','2022-12-22','2022-12-22 06:56:36','2022-12-23 06:56:36','507',0.00,0.00,'507','2022-12-22 19:28:19','507','2022-12-22 19:28:50',10,0),('1','150',257922,'DAILY SALES','2022-12-23','2022-12-23 06:43:31','2022-12-24 06:43:31','507',0.00,0.00,'507','2022-12-23 19:37:42','507','2022-12-23 19:38:01',10,0),('1','150',257923,'DAILY SALES','2022-12-24','2022-12-24 06:47:41','2022-12-25 06:47:41','507',0.00,0.00,'507','2022-12-24 20:41:20','507','2022-12-24 20:41:48',10,0),('1','150',257924,'DAILY SALES','2022-12-25','2022-12-25 06:50:34','2022-12-26 06:50:34','507',0.00,0.00,'507','2022-12-25 10:42:17','507','2022-12-25 10:42:50',10,0),('1','150',257925,'DAILY SALES','2022-12-25','2022-12-25 11:17:25','2022-12-26 11:17:25','507',0.00,0.00,'507','2022-12-25 19:00:02','507','2022-12-25 19:00:22',10,0),('1','150',257926,'DAILY SALES','2022-12-26','2022-12-26 06:46:52','2022-12-27 06:46:52','507',0.00,0.00,'507','2022-12-26 19:05:03','507','2022-12-26 19:05:29',10,0),('1','150',257927,'DAILY SALES','2022-12-27','2022-12-27 06:53:29','2022-12-28 06:53:29','507',0.00,0.00,'507','2022-12-27 18:54:11','507','2022-12-27 18:54:35',10,0),('1','150',257928,'DAILY SALES','2022-12-28','2022-12-28 06:40:02','2022-12-29 06:40:02','507',0.00,0.00,'507','2022-12-28 16:29:00','507','2022-12-28 16:29:22',10,0),('1','150',257929,'OPERATIONAL LOST','2022-12-28','2022-12-28 16:38:23','2022-12-29 16:38:23','507',0.00,0.00,'507','2022-12-28 17:26:09','507','2022-12-28 17:26:35',10,0),('1','150',257930,'DAILY SALES','2022-12-29','2022-12-29 06:42:10','2022-12-30 06:42:10','507',0.00,0.00,'507','2022-12-29 19:14:09','507','2022-12-29 19:14:30',10,0),('1','150',257931,'DAILY SALES','2022-12-30','2022-12-30 06:45:18','2022-12-31 06:45:18','507',0.00,0.00,'507','2022-12-30 19:23:18','507','2022-12-30 19:23:35',10,0),('1','150',257932,'DAILY SALES','2022-12-31','2022-12-31 06:47:18','2023-01-01 06:47:18','507',0.00,0.00,'507','2022-12-31 19:16:23','507','2022-12-31 19:16:50',10,0),('1','150',257933,'DAILY SALES','2023-01-01','2023-01-01 06:53:20','2023-01-02 06:53:20','507',0.00,0.00,'507','2023-01-01 11:22:59','507','2023-01-01 11:23:18',10,0),('1','150',257934,'DAILY SALES','2023-01-01','2023-01-01 11:23:49','2023-01-02 11:23:49','507',0.00,0.00,'507','2023-01-01 19:02:43','507','2023-01-01 19:03:06',10,0),('1','150',257935,'DAILY SALES ','2023-01-02','2023-01-02 06:41:44','2023-01-03 06:41:44','507',0.00,0.00,'507','2023-01-02 19:29:05','507','2023-01-02 19:29:25',10,0),('1','150',257936,'DAILY SALES ','2023-01-03','2023-01-03 06:47:49','2023-01-04 06:47:49','507',0.00,0.00,'507','2023-01-03 19:38:19','507','2023-01-03 19:38:42',10,0),('1','150',257937,'DAILY SALES','2023-01-04','2023-01-04 06:56:15','2023-01-05 06:56:15','507',0.00,0.00,'507','2023-01-04 15:19:47','507','2023-01-04 15:20:05',10,0),('1','150',257938,'OPERATIONAL LOST','2023-01-04','2023-01-04 15:20:56','2023-01-05 15:20:56','507',0.00,0.00,'507','2023-01-04 15:23:27','507','2023-01-04 15:23:58',10,0),('1','150',257939,'DAILY SALES','2023-01-04','2023-01-04 16:10:35','2023-01-05 16:10:35','507',0.00,0.00,'507','2023-01-04 19:13:35','507','2023-01-04 19:13:58',10,0),('1','150',257940,'DAILY SALES','2023-01-05','2023-01-05 06:54:08','2023-01-06 06:54:08','507',0.00,0.00,'507','2023-01-05 19:17:31','507','2023-01-05 19:17:52',10,0),('1','150',257941,'DAILY SALES','2023-01-06','2023-01-06 07:05:39','2023-01-07 07:05:39','507',0.00,0.00,'507','2023-01-06 19:20:32','507','2023-01-06 19:20:55',10,0),('1','150',257942,'DAILY SALES','2023-01-07','2023-01-07 07:13:02','2023-01-08 07:13:02','507',0.00,0.00,'507','2023-01-07 17:56:02','507','2023-01-07 17:56:23',10,0),('1','150',257943,'OPERATIONAL LOST','2023-01-07','2023-01-07 18:00:18','2023-01-08 18:00:18','507',0.00,0.00,'507','2023-01-07 18:03:10','507','2023-01-07 18:03:35',10,0),('1','150',257944,'DAILY SALES','2023-01-08','2023-01-08 07:06:25','2023-01-09 07:06:25','507',0.00,0.00,'507','2023-01-08 19:43:24','507','2023-01-08 19:43:47',10,0),('1','150',257945,'DAILY SALES','2023-01-09','2023-01-09 07:00:00','2023-01-10 07:00:00','507',0.00,0.00,'507','2023-01-09 19:52:18','507','2023-01-09 19:52:51',10,0),('1','150',257946,'DAILY SALES','2023-01-10','2023-01-10 07:00:05','2023-01-11 07:00:05','507',0.00,0.00,'507','2023-01-10 11:30:57','507','2023-01-10 11:31:20',10,0),('1','150',257947,'OPERATIONAL LOST','2023-01-10','2023-01-10 11:31:57','2023-01-11 11:31:57','507',0.00,0.00,'507','2023-01-10 11:34:35','507','2023-01-10 11:34:59',10,0),('1','150',257948,'DAILY SALES','2023-01-10','2023-01-10 13:17:10','2023-01-11 13:17:10','507',0.00,0.00,'507','2023-01-10 19:50:53','507','2023-01-10 19:51:22',10,0),('1','150',257949,'DAILY SALES','2023-01-11','2023-01-11 06:57:27','2023-01-12 06:57:27','507',0.00,0.00,'507','2023-01-11 19:50:50','507','2023-01-11 19:51:13',10,0),('1','150',257950,'DAILY SALES','2023-01-12','2023-01-12 06:56:05','2023-01-13 06:56:05','507',0.00,0.00,'507','2023-01-12 19:07:41','507','2023-01-12 19:08:06',10,0),('1','150',257951,'OPERATIONAL LOST','2023-01-12','2023-01-12 19:08:31','2023-01-13 19:08:31','507',0.00,0.00,'507','2023-01-13 07:00:54','507','2023-01-13 07:01:31',10,0),('1','150',257952,'DAILY SALES','2023-01-13','2023-01-13 07:06:19','2023-01-14 07:06:19','507',0.00,0.00,'507','2023-01-13 19:15:17','507','2023-01-13 19:16:08',10,0),('1','150',257953,'DAILY SALES','2023-01-14','2023-01-14 07:11:27','2023-01-15 07:11:27','507',0.00,0.00,'507','2023-01-14 19:47:13','507','2023-01-14 19:48:43',10,0),('1','150',257954,'DAILY SALES','2023-01-15','2023-01-15 07:05:33','2023-01-16 07:05:33','507',0.00,0.00,'507','2023-01-15 14:37:15','507','2023-01-15 14:37:46',10,0),('1','150',257955,'OPERATIONAL LOST','2023-01-15','2023-01-15 14:39:46','2023-01-16 14:39:46','507',0.00,0.00,'507','2023-01-15 14:42:19','507','2023-01-15 14:42:39',10,0),('1','150',257956,'DAILY SALES','2023-01-16','2023-01-16 06:59:31','2023-01-17 06:59:31','507',0.00,0.00,'507','2023-01-16 19:04:06','507','2023-01-16 19:04:31',10,0),('1','150',257957,'DAILY SALES','2023-01-17','2023-01-17 07:00:31','2023-01-18 07:00:31','507',0.00,0.00,'507','2023-01-17 19:55:09','507','2023-01-17 19:55:42',10,0),('1','150',257958,'DAILY SALES','2023-01-18','2023-01-18 07:07:23','2023-01-19 07:07:23','507',0.00,0.00,'507','2023-01-18 19:21:47','507','2023-01-18 19:22:09',10,0),('1','150',257959,'DAILY SALES','2023-01-19','2023-01-19 08:32:57','2023-01-20 08:32:57','507',0.00,0.00,'507','2023-01-19 19:26:18','507','2023-01-19 19:26:39',10,0),('1','150',257960,'DAILY SALES','2023-01-20','2023-01-20 07:06:44','2023-01-21 07:06:44','507',0.00,0.00,'507','2023-01-20 19:19:36','507','2023-01-20 19:23:04',10,0),('1','150',257961,'DAILY SALES','2023-01-21','2023-01-21 07:28:34','2023-01-22 07:28:34','507',0.00,0.00,'507','2023-01-21 19:16:10','507','2023-01-21 19:18:24',10,0),('1','150',257962,'DAILY SALES','2023-01-22','2023-01-22 07:10:05','2023-01-23 07:10:05','507',0.00,0.00,'507','2023-01-22 15:18:57','507','2023-01-22 15:19:34',10,0),('1','150',257963,'OPERATIONAL LOST','2023-01-22','2023-01-22 15:20:30','2023-01-23 15:20:30','507',0.00,0.00,'507','2023-01-22 15:26:04','507','2023-01-22 15:26:25',10,0),('1','150',257964,'DAILY SALES','2023-01-22','2023-01-22 16:35:02','2023-01-23 16:35:02','507',0.00,0.00,'507','2023-01-22 20:11:44','507','2023-01-22 20:12:00',10,0),('1','150',257965,'DAILY SALES','2023-01-23','2023-01-23 06:43:39','2023-01-24 06:43:39','507',0.00,0.00,'507','2023-01-23 19:27:40','507','2023-01-23 19:27:58',10,0),('1','150',257966,'DAILY SALES','2023-01-24','2023-01-24 07:08:00','2023-01-25 07:08:00','507',0.00,0.00,'507','2023-01-24 19:21:34','507','2023-01-24 19:22:02',10,0),('1','150',257967,'DAILY SALES','2023-01-25','2023-01-25 07:06:00','2023-01-26 07:06:00','507',0.00,0.00,'507','2023-01-25 19:27:31','507','2023-01-25 19:28:06',10,0),('1','150',257968,'DAILY SALES','2023-01-26','2023-01-26 07:07:13','2023-01-27 07:07:13','507',0.00,0.00,'507','2023-01-26 11:55:45','507','2023-01-26 11:56:23',10,0),('1','150',257969,'DAILY SALES','2023-01-26','2023-01-26 11:56:49','2023-01-27 11:56:49','507',0.00,0.00,'507','2023-01-26 19:42:16','507','2023-01-26 19:42:43',10,0),('1','150',257970,'DAILY SALES','2023-01-27','2023-01-27 06:58:05','2023-01-28 06:58:05','507',0.00,0.00,'507','2023-01-27 19:08:31','507','2023-01-27 19:09:16',10,0),('1','150',257971,'DAILY SALES','2023-01-28','2023-01-28 07:08:44','2023-01-29 07:08:44','507',0.00,0.00,'507','2023-01-28 19:27:32','507','2023-01-28 19:27:54',10,0),('1','150',257972,'DAILY SALES','2023-01-29','2023-01-29 07:03:48','2023-01-30 07:03:48','507',0.00,0.00,'507','2023-01-29 19:45:00','507','2023-01-29 19:45:26',10,0),('1','150',257973,'DAILY SALES','2023-01-30','2023-01-30 07:10:00','2023-01-31 07:10:00','507',0.00,0.00,'507','2023-01-30 11:13:07','507','2023-01-30 11:13:29',10,0),('1','150',257974,'DAILY SALES','2023-01-30','2023-01-30 11:13:52','2023-01-31 11:13:52','507',0.00,0.00,'507','2023-01-30 20:03:22','507','2023-01-30 20:03:54',10,0),('1','150',257975,'DAILY SALES','2023-01-31','2023-01-31 07:07:53','2023-02-01 07:07:53','507',0.00,0.00,'507','2023-01-31 20:12:20','507','2023-01-31 20:12:59',10,0),('1','150',257976,'DAILY SALES','2023-02-01','2023-02-01 07:08:04','2023-02-02 07:08:04','507',0.00,0.00,'507','2023-02-01 19:57:08','507','2023-02-01 19:57:35',10,0),('1','150',257977,'DAILY SALES','2023-02-02','2023-02-02 07:05:55','2023-02-03 07:05:55','507',0.00,0.00,'507','2023-02-02 15:25:12','507','2023-02-02 15:25:43',10,0),('1','150',257978,'OPERATIONAL LOST','2023-02-02','2023-02-02 17:39:56','2023-02-03 17:39:56','507',0.00,0.00,'507','2023-02-02 17:43:17','507','2023-02-02 17:43:50',10,0),('1','150',257979,'DAILY SALES','2023-02-02','2023-02-02 17:44:10','2023-02-03 17:44:10','507',0.00,0.00,'507','2023-02-02 17:50:28','507','2023-02-02 17:51:02',10,0),('1','150',257980,'DAILY SALES','2023-02-02','2023-02-02 17:51:14','2023-02-03 17:51:14','507',0.00,0.00,'507','2023-02-02 20:18:19','507','2023-02-02 20:19:31',10,0),('1','150',257981,'DAILY SALES','2023-02-03','2023-02-03 06:54:30','2023-02-04 06:54:30','507',0.00,0.00,'507','2023-02-03 20:31:11','507','2023-02-03 20:32:14',10,0),('1','150',257982,'DAILY SALES','2023-02-04','2023-02-04 06:53:25','2023-02-05 06:53:25','507',0.00,0.00,'507','2023-02-04 20:26:07','507','2023-02-04 20:26:28',10,0),('1','150',257983,'DAILY SALES','2023-02-05','2023-02-05 06:56:50','2023-02-06 06:56:50','507',0.00,0.00,'507','2023-02-05 20:22:31','507','2023-02-05 20:23:08',10,0),('1','150',257984,'DAILY SALES','2023-02-06','2023-02-06 06:59:01','2023-02-07 06:59:01','507',0.00,0.00,'507','2023-02-06 11:25:54','507','2023-02-06 11:26:20',10,0),('1','150',257985,'DAILY SALES','2023-02-06','2023-02-06 12:06:52','2023-02-07 12:06:52','507',0.00,0.00,'507','2023-02-06 20:36:08','507','2023-02-06 20:36:45',10,0),('1','150',257986,'DAILY SALES','2023-02-07','2023-02-07 07:03:41','2023-02-08 07:03:41','507',0.00,0.00,'507','2023-02-07 20:28:33','507','2023-02-07 20:28:57',10,0),('1','150',257987,'DAILY SALES','2023-02-08','2023-02-08 06:59:26','2023-02-09 06:59:26','507',0.00,0.00,'507','2023-02-08 20:27:33','507','2023-02-08 20:28:01',10,0),('1','150',257988,'DAILY SALES','2023-02-09','2023-02-09 07:36:58','2023-02-10 07:36:58','507',0.00,0.00,'507','2023-02-09 16:39:30','507','2023-02-09 16:40:27',10,0),('1','150',257989,'DAILY SALES','2023-02-09','2023-02-09 16:53:24','2023-02-10 16:53:24','507',0.00,0.00,'507','2023-02-09 16:54:08','507','2023-02-09 16:54:54',10,0),('1','150',257990,'OPERATIONAL LOST','2023-02-09','2023-02-09 16:55:18','2023-02-10 16:55:18','507',0.00,0.00,'507','2023-02-09 16:58:22','507','2023-02-09 16:58:49',10,0),('1','150',257991,'DAILY SALES','2023-02-09','2023-02-09 17:17:53','2023-02-10 17:17:53','507',0.00,0.00,'507','2023-02-09 19:51:52','507','2023-02-09 19:52:25',10,0),('1','150',257992,'DAILY SALES','2023-02-10','2023-02-10 08:11:31','2023-02-11 08:11:31','507',0.00,0.00,'507','2023-02-10 19:44:40','507','2023-02-10 19:45:11',10,0),('1','150',257993,'DAILY SALES','2023-02-11','2023-02-11 07:11:03','2023-02-12 07:11:03','507',0.00,0.00,'507','2023-02-11 19:31:57','507','2023-02-11 19:32:29',10,0),('1','150',257994,'DAILY SALES','2023-02-12','2023-02-12 07:09:06','2023-02-13 07:09:06','507',0.00,0.00,'507','2023-02-12 20:43:51','507','2023-02-12 20:44:50',10,0),('1','150',257995,'DAILY SALES','2023-02-13','2023-02-13 06:50:19','2023-02-14 06:50:19','507',0.00,0.00,'507','2023-02-13 08:45:30','507','2023-02-13 08:45:47',10,0),('1','150',257996,'DAILY SALES','2023-02-13','2023-02-13 09:44:56','2023-02-14 09:44:56','507',0.00,0.00,'507','2023-02-13 20:19:06','507','2023-02-13 20:19:28',10,0),('1','150',257997,'DAILY SALES','2023-02-14','2023-02-14 06:55:17','2023-02-15 06:55:17','507',0.00,0.00,'507','2023-02-14 20:37:29','507','2023-02-14 20:38:04',10,0),('1','150',257998,'DAILY SALES','2023-02-15','2023-02-15 06:49:08','2023-02-16 06:49:08','507',0.00,0.00,'507','2023-02-15 20:10:40','507','2023-02-15 20:11:06',10,0),('1','150',257999,'DAILY SALES','2023-02-16','2023-02-16 07:12:51','2023-02-17 07:12:51','507',0.00,0.00,'507','2023-02-16 19:16:34','507','2023-02-16 19:17:14',10,0),('1','150',258000,'DAILY SALES','2023-02-17','2023-02-17 07:29:45','2023-02-18 07:29:45','507',0.00,0.00,'507','2023-02-17 20:06:32','507','2023-02-17 20:06:54',10,0),('1','150',258001,'DAILY SALES','2023-02-18','2023-02-18 07:13:20','2023-02-19 07:13:20','507',0.00,0.00,'507','2023-02-18 20:29:31','507','2023-02-18 20:30:04',10,0),('1','150',258002,'DAILY SALES','2023-02-19','2023-02-19 07:22:19','2023-02-20 07:22:19','507',0.00,0.00,'507','2023-02-19 20:25:04','507','2023-02-19 20:25:27',10,0),('1','150',258003,'DAILY SALES','2023-02-20','2023-02-20 07:20:26','2023-02-21 07:20:26','507',0.00,0.00,'507','2023-02-20 19:58:29','507','2023-02-20 19:58:49',10,0),('1','150',258004,'DAILY SALES','2023-02-21','2023-02-21 07:11:45','2023-02-22 07:11:45','507',0.00,0.00,'507','2023-02-21 19:33:59','507','2023-02-21 19:34:34',10,0),('1','150',258005,'DAILY SALES','2023-02-22','2023-02-22 07:18:28','2023-02-23 07:18:28','507',0.00,0.00,'507','2023-02-22 19:28:54','507','2023-02-22 19:29:28',10,0),('1','150',258006,'DAILY SALES','2023-02-23','2023-02-23 07:12:12','2023-02-24 07:12:12','507',0.00,0.00,'507','2023-02-23 20:38:34','507','2023-02-23 20:39:41',10,0),('1','150',258007,'Daily Sales ','2023-02-24','2023-02-24 10:31:32','2023-02-25 10:31:32','507',0.00,0.00,'507','2023-02-24 20:50:11','507','2023-02-24 20:50:34',10,0),('1','150',258008,'DAILY SALES','2023-02-26','2023-02-26 07:14:54','2023-02-27 07:14:54','507',0.00,0.00,'507','2023-02-26 19:57:27','507','2023-02-26 20:01:56',10,0),('1','150',258009,'DAILY SALES ','2023-02-27','2023-02-27 08:46:14','2023-02-28 08:46:14','507',0.00,0.00,'507','2023-02-27 20:02:30','507','2023-02-27 20:02:57',10,0),('1','150',258010,'DAILY SALES','2023-02-28','2023-02-28 07:12:23','2023-03-01 07:12:23','507',0.00,0.00,'507','2023-02-28 19:32:32','507','2023-02-28 19:33:04',10,0),('1','150',258011,'DAILY SALES','2023-03-01','2023-03-01 07:12:48','2023-03-02 07:12:48','507',0.00,0.00,'507','2023-03-01 20:23:59','507','2023-03-01 20:24:23',10,0),('1','150',258012,'DAILY SALES','2023-03-02','2023-03-02 07:13:27','2023-03-03 07:13:27','507',0.00,0.00,'507','2023-03-02 21:14:32','507','2023-03-02 21:15:00',10,0),('1','150',258013,'DAILY SALES','2023-03-03','2023-03-03 07:12:36','2023-03-04 07:12:36','507',0.00,0.00,'507','2023-03-03 10:37:35','507','2023-03-03 10:37:53',10,0),('1','150',258014,'DAILY SALES','2023-03-03','2023-03-03 11:26:42','2023-03-04 11:26:42','507',0.00,0.00,'507','2023-03-03 20:03:16','507','2023-03-03 20:03:36',10,0),('1','150',258015,'DAILY SALES','2023-03-04','2023-03-04 07:16:55','2023-03-05 07:16:55','507',0.00,0.00,'507','2023-03-04 19:45:52','507','2023-03-04 19:47:54',10,0),('1','150',258016,'DAILY SALES','2023-03-05','2023-03-05 07:16:30','2023-03-06 07:16:30','507',0.00,0.00,'507','2023-03-05 20:15:38','507','2023-03-05 20:16:13',10,0),('1','150',258017,'DAILY SALES','2023-03-06','2023-03-06 07:07:46','2023-03-07 07:07:46','507',0.00,0.00,'507','2023-03-06 19:38:56','507','2023-03-06 19:39:18',10,0),('1','150',258018,'DAILY SALES','2023-03-07','2023-03-07 07:14:56','2023-03-08 07:14:56','507',0.00,0.00,'507','2023-03-07 19:39:44','507','2023-03-07 19:40:10',10,0),('1','150',258019,'DAILY SALES','2023-03-08','2023-03-08 07:39:36','2023-03-09 07:39:36','507',0.00,0.00,'507','2023-03-08 20:31:09','507','2023-03-08 20:31:40',10,0),('1','150',258020,'DAILY SALES','2023-03-09','2023-03-09 07:25:32','2023-03-10 07:25:32','507',0.00,0.00,'507','2023-03-09 20:03:48','507','2023-03-09 20:04:31',10,0),('1','150',258021,'DAILY SALES','2023-03-10','2023-03-10 07:25:12','2023-03-11 07:25:12','507',0.00,0.00,'507','2023-03-10 15:49:18','507','2023-03-10 15:50:26',10,0),('1','150',258022,'DAILY SALES','2023-03-10','2023-03-10 17:35:57','2023-03-11 17:35:57','507',0.00,0.00,'507','2023-03-10 20:12:03','507','2023-03-10 20:12:24',10,0),('1','150',258023,'DAILY SALES','2023-03-11','2023-03-11 07:19:45','2023-03-12 07:19:45','507',0.00,0.00,'507','2023-03-11 20:11:42','507','2023-03-11 20:12:11',10,0),('1','150',258024,'DAILY SALES','2023-03-12','2023-03-12 06:52:34','2023-03-13 06:52:34','507',0.00,0.00,'507','2023-03-13 07:00:31','507','2023-03-13 07:00:54',10,0),('1','150',258025,'DAILY SALES','2023-03-13','2023-03-13 07:01:10','2023-03-14 07:01:10','507',0.00,0.00,'507','2023-03-13 20:05:22','507','2023-03-13 20:06:03',10,0),('1','150',258026,'SHIFT BALANCE OF 12/03/2023','2023-03-12','2023-03-13 20:20:23','2023-03-14 20:20:23','507',0.00,0.00,'507','2023-03-13 20:23:34','507','2023-03-13 20:24:03',10,0),('1','150',258027,'DAILY SALES','2023-03-14','2023-03-14 06:43:09','2023-03-15 06:43:09','507',0.00,0.00,'507','2023-03-14 20:36:34','507','2023-03-14 20:37:07',10,0),('1','150',258028,'DAILY SALES','2023-03-15','2023-03-15 06:46:24','2023-03-16 06:46:24','507',0.00,0.00,'507','2023-03-15 20:19:49','507','2023-03-15 20:39:19',10,0),('1','150',258029,'DAILY SALES','2023-03-16','2023-03-16 07:25:41','2023-03-17 07:25:41','507',0.00,0.00,'507','2023-03-16 19:38:00','507','2023-03-16 19:38:50',10,0),('1','150',258030,'DAILY SALES','2023-03-17','2023-03-17 06:39:08','2023-03-18 06:39:08','507',0.00,0.00,'507','2023-03-17 19:55:14','507','2023-03-17 19:55:49',10,0),('1','150',258031,'DAILY SALES','2023-03-18','2023-03-18 06:47:56','2023-03-19 06:47:56','507',0.00,0.00,'507','2023-03-18 18:33:29','507','2023-03-18 18:33:50',10,0),('1','150',258032,'DAILY SALES','2023-03-18','2023-03-18 18:38:20','2023-03-19 18:38:20','507',0.00,0.00,'507','2023-03-18 20:04:59','507','2023-03-18 20:05:31',10,0),('1','150',258033,'DAILY SALES','2023-03-19','2023-03-19 06:44:53','2023-03-20 06:44:53','507',0.00,0.00,'507','2023-03-19 20:16:13','507','2023-03-19 20:16:41',10,0),('1','150',258034,'DAILY SALES','2023-03-20','2023-03-20 07:02:58','2023-03-21 07:02:58','507',0.00,0.00,'507','2023-03-20 21:17:01','507','2023-03-20 21:17:22',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904832 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','150','771','146984',2940225,'2142','329',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','147007',2940522,'2142','329',0.00,2028.89,0.00,0.00,2028.89,568089.20,0.00,0.00,0.00),('1','150','771','147030',2940779,'2142','329',2028.89,4725.56,0.00,0.00,2696.67,755067.60,0.00,0.00,0.00),('1','150','771','147070',2941475,'2142','329',4725.56,7308.06,0.00,0.00,2582.50,723100.00,0.00,0.00,0.00),('1','150','771','147079',2941555,'2142','329',7308.06,9317.88,0.00,0.00,2009.82,562749.60,0.00,0.00,0.00),('1','150','771','147085',2941575,'2142','329',9317.88,12656.88,0.00,0.00,3339.00,934920.00,0.00,0.00,0.00),('1','150','771','147092',2941610,'2142','329',12656.88,14604.20,0.00,0.00,1947.32,545249.60,0.00,0.00,0.00),('1','150','771','147094',2941612,'2142','329',14604.20,16928.84,0.00,0.00,2324.64,650899.20,0.00,0.00,0.00),('1','150','771','147099',2941629,'2142','329',16928.84,17211.84,0.00,0.00,283.00,79240.00,0.00,0.00,0.00),('1','150','771','147156',2942368,'2142','329',17211.84,18564.87,0.00,0.00,1353.03,378848.40,0.00,0.00,0.00),('1','150','771','147305',2944203,'2142','329',18564.87,21093.97,0.00,0.00,2529.10,708148.00,0.00,0.00,0.00),('1','150','771','147381',2945567,'2142','329',21093.97,22453.97,0.00,0.00,1360.00,380800.00,0.00,0.00,0.00),('1','150','771','147508',2947972,'2142','329',22453.97,24989.97,0.00,0.00,2536.00,710080.00,0.00,0.00,0.00),('1','150','771','147668',2950870,'2142','329',24989.97,26015.97,0.00,0.00,1026.00,287280.00,0.00,0.00,0.00),('1','150','771','147861',2954286,'2142','329',26015.97,28675.72,0.00,0.00,2659.75,744730.00,0.00,0.00,0.00),('1','150','771','147985',2956294,'2142','329',28675.72,31067.93,0.00,0.00,2392.21,669818.80,0.00,0.00,0.00),('1','150','771','148004',2956452,'2142','329',31067.93,31375.93,0.00,0.00,308.00,86240.00,0.00,0.00,0.00),('1','150','771','148123',2958644,'2142','329',31375.93,33090.57,0.00,0.00,1714.64,480099.20,0.00,0.00,0.00),('1','150','771','148271',2961284,'2142','329',33090.57,35282.17,0.00,0.00,2191.60,613648.00,0.00,0.00,0.00),('1','150','771','148366',2962954,'2142','329',35282.17,36625.17,0.00,0.00,1343.00,376040.00,0.00,0.00,0.00),('1','150','771','148555',2966163,'2142','329',36625.17,40151.17,0.00,0.00,3526.00,987280.00,0.00,0.00,0.00),('1','150','771','148810',2970252,'2142','329',40151.17,41548.17,0.00,0.00,1397.00,391160.00,0.00,0.00,0.00),('1','150','771','148966',2973361,'2142','329',41548.17,44232.99,0.00,0.00,2684.82,751749.60,0.00,0.00,0.00),('1','150','771','149027',2974440,'2142','329',44232.99,45380.99,0.00,0.00,1148.00,321440.00,0.00,0.00,0.00),('1','150','771','149034',2974689,'2142','329',45380.99,45440.99,0.00,0.00,60.00,16800.00,0.00,0.00,0.00),('1','150','771','149145',2976831,'2142','329',45440.99,46745.70,0.00,0.00,1304.71,365318.80,0.00,0.00,0.00),('1','150','771','149300',2979528,'2142','329',46745.70,49863.70,0.00,0.00,3118.00,873040.00,0.00,0.00,0.00),('1','150','771','149449',2982011,'2142','329',49863.70,52631.34,0.00,0.00,2767.64,774939.20,0.00,0.00,0.00),('1','150','771','149601',2984597,'2142','329',52631.34,55116.34,0.00,0.00,2485.00,695800.00,0.00,0.00,0.00),('1','150','771','149689',2985954,'2142','329',55116.34,58697.94,0.00,0.00,3581.60,1002848.00,0.00,0.00,0.00),('1','150','771','149753',2987079,'2142','329',58697.94,59948.94,0.00,0.00,1251.00,350280.00,0.00,0.00,0.00),('1','150','771','149836',2988680,'2142','329',59948.94,61425.36,0.00,0.00,1476.42,413397.60,0.00,0.00,0.00),('1','150','771','150030',2992108,'2142','329',61425.36,65283.36,0.00,0.00,3858.00,1080240.00,0.00,0.00,0.00),('1','150','771','150148',2994790,'2142','329',65283.36,67308.68,0.00,0.00,2025.32,567089.60,0.00,0.00,0.00),('1','150','771','150315',2997237,'2142','329',67308.68,69082.68,0.00,0.00,1774.00,496720.00,0.00,0.00,0.00),('1','150','771','150544',3001730,'2142','329',69082.68,72850.93,0.00,0.00,3768.25,1055110.00,0.00,0.00,0.00),('1','150','771','150654',3003974,'2142','329',72850.93,74463.93,0.00,0.00,1613.00,451640.00,0.00,0.00,0.00),('1','150','771','150841',3007422,'2142','329',74463.93,76521.78,0.00,0.00,2057.85,576198.00,0.00,0.00,0.00),('1','150','771','150987',3010137,'2142','329',76521.78,79443.42,0.00,0.00,2921.64,818059.20,0.00,0.00,0.00),('1','150','771','151029',3010723,'2142','329',79443.42,79759.42,0.00,0.00,316.00,88480.00,0.00,0.00,0.00),('1','150','771','151136',3012873,'2142','329',79759.42,81989.95,0.00,0.00,2230.53,624548.40,0.00,0.00,0.00),('1','150','771','151287',3015767,'2142','329',81989.95,84962.95,0.00,0.00,2973.00,832440.00,0.00,0.00,0.00),('1','150','771','151423',3018379,'2142','329',84962.95,86095.20,0.00,0.00,1132.25,317030.00,0.00,0.00,0.00),('1','150','771','151582',3021189,'2142','329',86095.20,88449.77,0.00,0.00,2354.57,659279.60,0.00,0.00,0.00),('1','150','771','151663',3022657,'2142','329',88449.77,90362.77,0.00,0.00,1913.00,535640.00,0.00,0.00,0.00),('1','150','771','151813',3025419,'2142','329',90362.77,94420.62,0.00,0.00,4057.85,1136198.00,0.00,0.00,0.00),('1','150','771','151990',3028892,'2142','329',94420.62,96285.62,0.00,0.00,1865.00,522200.00,0.00,0.00,0.00),('1','150','771','152159',3031898,'2142','329',96285.62,98764.01,0.00,0.00,2478.39,693949.20,0.00,0.00,0.00),('1','150','771','152306',3034884,'2142','329',98764.01,100686.01,0.00,0.00,1922.00,538160.00,0.00,0.00,0.00),('1','150','771','152473',3037687,'2142','329',100686.01,102090.51,0.00,0.00,1404.50,393260.00,0.00,0.00,0.00),('1','150','771','152608',3040154,'2142','329',102090.51,104477.54,0.00,0.00,2387.03,668368.40,0.00,0.00,0.00),('1','150','771','152683',3041570,'2142','329',104477.54,106154.54,0.00,0.00,1677.00,469560.00,0.00,0.00,0.00),('1','150','771','152889',3045258,'2142','329',106154.54,110523.82,0.00,0.00,4369.28,1223398.40,0.00,0.00,0.00),('1','150','771','153024',3047779,'2142','329',110523.82,111825.82,0.00,0.00,1302.00,364560.00,0.00,0.00,0.00),('1','150','771','153260',3051737,'2142','329',111825.82,115246.76,0.00,0.00,3420.94,957863.20,0.00,0.00,0.00),('1','150','771','153468',3055719,'2142','329',115246.76,117546.47,0.00,0.00,2299.71,643918.80,0.00,0.00,0.00),('1','150','771','153530',3056747,'2142','329',117546.47,118092.47,0.00,0.00,546.00,152880.00,0.00,0.00,0.00),('1','150','771','153635',3058733,'2142','329',118092.47,119633.79,0.00,0.00,1541.32,431569.60,0.00,0.00,0.00),('1','150','771','153795',3061577,'2142','329',119633.79,122028.07,0.00,0.00,2394.28,670398.40,0.00,0.00,0.00),('1','150','771','153877',3062904,'2142','329',122028.07,123887.07,0.00,0.00,1859.00,520520.00,0.00,0.00,0.00),('1','150','771','153916',3063827,'2142','329',123887.07,125004.03,0.00,0.00,1116.96,312748.80,0.00,0.00,0.00),('1','150','771','154236',3069313,'2142','329',125004.03,125873.03,0.00,0.00,869.00,243320.00,0.00,0.00,0.00),('1','150','771','154415',3072575,'2142','329',125873.03,128925.06,0.00,0.00,3052.03,854568.40,0.00,0.00,0.00),('1','150','771','154432',3072839,'2142','329',128925.06,129556.06,0.00,0.00,631.00,176680.00,0.00,0.00,0.00),('1','150','771','154589',3075965,'2142','329',129556.06,130324.09,0.00,0.00,768.03,215048.40,0.00,0.00,0.00),('1','150','771','154721',3078510,'2142','329',130324.09,134455.44,0.00,0.00,4131.35,1156778.00,0.00,0.00,0.00),('1','150','771','154849',3080869,'2142','329',134455.44,136074.44,0.00,0.00,1619.00,453320.00,0.00,0.00,0.00),('1','150','771','155111',3085852,'2142','329',136074.44,139630.83,0.00,0.00,3556.39,995789.20,0.00,0.00,0.00),('1','150','771','155299',3089286,'2142','329',139630.83,141514.83,0.00,0.00,1884.00,527520.00,0.00,0.00,0.00),('1','150','771','155452',3092246,'2142','329',141514.83,143783.75,0.00,0.00,2268.92,635297.60,0.00,0.00,0.00),('1','150','771','155635',3095587,'2142','329',143783.75,147031.75,0.00,0.00,3248.00,909440.00,0.00,0.00,0.00),('1','150','771','155774',3098026,'2142','329',147031.75,149476.39,0.00,0.00,2444.64,684499.20,0.00,0.00,0.00),('1','150','771','155936',3100826,'2142','329',149476.39,151894.24,0.00,0.00,2417.85,676998.00,0.00,0.00,0.00),('1','150','771','156087',3103465,'2142','329',151894.24,152251.24,0.00,0.00,357.00,99960.00,0.00,0.00,0.00),('1','150','771','156112',3103820,'2142','329',152251.24,154543.20,0.00,0.00,2291.96,641748.80,0.00,0.00,0.00),('1','150','771','156196',3105555,'2142','329',154543.20,157506.48,0.00,0.00,2963.28,829718.40,0.00,0.00,0.00),('1','150','771','156407',3109387,'2142','329',157506.48,159707.90,0.00,0.00,2201.42,616397.60,0.00,0.00,0.00),('1','150','771','156561',3112326,'2142','329',159707.90,161956.11,0.00,0.00,2248.21,629498.80,0.00,0.00,0.00),('1','150','771','156646',3113877,'2142','329',161956.11,163067.11,0.00,0.00,1111.00,311080.00,0.00,0.00,0.00),('1','150','771','157072',3121668,'2142','329',163067.11,165162.28,0.00,0.00,2095.17,586647.60,0.00,0.00,0.00),('1','150','771','157268',3125115,'2142','329',165162.28,168202.85,0.00,0.00,3040.57,851359.60,0.00,0.00,0.00),('1','150','771','157312',3125702,'2142','329',168202.85,169045.85,0.00,0.00,843.00,236040.00,0.00,0.00,0.00),('1','150','771','157441',3127956,'2142','329',169045.85,170312.45,0.00,0.00,1266.60,354648.00,0.00,0.00,0.00),('1','150','771','157643',3131558,'2142','329',170312.45,172652.45,0.00,0.00,2340.00,655200.00,0.00,0.00,0.00),('1','150','771','157804',3134546,'2142','329',172652.45,174669.45,0.00,0.00,2017.00,564760.00,0.00,0.00,0.00),('1','150','771','158090',3139800,'2142','329',174669.45,177381.77,0.00,0.00,2712.32,759449.60,0.00,0.00,0.00),('1','150','771','158252',3142913,'2142','329',177381.77,179348.34,0.00,0.00,1966.57,550639.60,0.00,0.00,0.00),('1','150','771','158293',3143597,'2142','329',179348.34,180320.34,0.00,0.00,972.00,272160.00,0.00,0.00,0.00),('1','150','771','158414',3146070,'2142','329',180320.34,182107.34,0.00,0.00,1787.00,500360.00,0.00,0.00,0.00),('1','150','771','158568',3148657,'2142','329',182107.34,184926.34,0.00,0.00,2819.00,789320.00,0.00,0.00,0.00),('1','150','771','158625',3149599,'2142','329',184926.34,185761.34,0.00,0.00,835.00,233800.00,0.00,0.00,0.00),('1','150','771','158752',3152047,'2142','329',185761.34,187112.34,0.00,0.00,1351.00,378280.00,0.00,0.00,0.00),('1','150','771','158932',3155075,'2142','329',187112.34,188083.76,0.00,0.00,971.42,271997.60,0.00,0.00,0.00),('1','150','771','158933',3155076,'2142','329',188083.76,188992.17,0.00,0.00,908.41,268889.36,0.00,0.00,0.00),('1','150','771','159114',3158308,'2142','329',188992.17,191751.32,0.00,0.00,2759.15,816708.40,0.00,0.00,0.00),('1','150','771','159115',3158309,'2142','329',191751.32,191751.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','159265',3161329,'2142','329',191751.32,194938.69,0.00,0.00,3187.37,943461.52,0.00,0.00,0.00),('1','150','771','159424',3163771,'2142','329',194938.69,196775.89,0.00,0.00,1837.20,543811.20,0.00,0.00,0.00),('1','150','771','159428',3163785,'2142','329',196775.89,196775.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','159629',3167369,'2142','329',196775.89,198837.20,0.00,0.00,2061.31,610147.76,0.00,0.00,0.00),('1','150','771','159630',3167370,'2142','329',198837.20,200437.99,0.00,0.00,1600.79,486640.16,0.00,0.00,0.00),('1','150','771','159673',3167979,'2142','329',200437.99,201965.12,0.00,0.00,1527.13,464247.52,0.00,0.00,0.00),('1','150','771','159674',3167980,'2142','329',201965.12,201965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','159734',3169042,'2142','329',201965.12,203589.98,0.00,0.00,1624.86,493957.44,0.00,0.00,0.00),('1','150','771','159930',3172568,'2142','329',203589.98,206163.20,0.00,0.00,2573.22,782258.88,0.00,0.00,0.00),('1','150','771','159997',3173644,'2142','329',206163.20,206863.85,0.00,0.00,700.65,212997.60,0.00,0.00,0.00),('1','150','771','159999',3173659,'2142','329',206863.85,206863.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','160126',3176282,'2142','329',206863.85,208623.38,0.00,0.00,1759.53,534897.12,0.00,0.00,0.00),('1','150','771','160308',3179400,'2142','329',208623.38,211092.62,0.00,0.00,2469.24,750648.96,0.00,0.00,0.00),('1','150','771','160343',3179957,'2142','329',211092.62,211901.96,0.00,0.00,809.34,258988.80,0.00,0.00,0.00),('1','150','771','160347',3180012,'2142','329',211901.96,211901.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','160452',3182076,'2142','329',211901.96,213283.05,0.00,0.00,1381.09,441948.80,0.00,0.00,0.00),('1','150','771','160586',3184562,'2142','329',213283.05,215610.55,0.00,0.00,2327.50,744800.00,0.00,0.00,0.00),('1','150','771','160663',3185739,'2142','329',215610.55,216780.08,0.00,0.00,1169.53,374249.60,0.00,0.00,0.00),('1','150','771','160665',3185765,'2142','329',216780.08,216780.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','160746',3187088,'2142','329',216780.08,218568.58,0.00,0.00,1788.50,572320.00,0.00,0.00,0.00),('1','150','771','160889',3189530,'2142','329',218568.58,221448.64,0.00,0.00,2880.06,921619.20,0.00,0.00,0.00),('1','150','771','160952',3190536,'2142','329',221448.64,222034.57,0.00,0.00,585.93,187497.60,0.00,0.00,0.00),('1','150','771','160956',3190591,'2142','329',222034.57,222034.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','161090',3193192,'2142','329',222034.57,223328.85,0.00,0.00,1294.28,414169.60,0.00,0.00,0.00),('1','150','771','161285',3196691,'2142','329',223328.85,225185.75,0.00,0.00,1856.90,594208.00,0.00,0.00,0.00),('1','150','771','161462',3199526,'2142','329',225185.75,226645.50,0.00,0.00,1459.75,467120.00,0.00,0.00,0.00),('1','150','771','161465',3199557,'2142','329',226645.50,226645.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','161468',3199603,'2142','329',226645.50,227513.06,0.00,0.00,867.56,277619.20,0.00,0.00,0.00),('1','150','771','161660',3202959,'2142','329',227513.06,229805.09,0.00,0.00,2292.03,733449.60,0.00,0.00,0.00),('1','150','771','161861',3206392,'2142','329',229805.09,231839.68,0.00,0.00,2034.59,651068.80,0.00,0.00,0.00),('1','150','771','162239',3213098,'2142','329',231839.68,235350.79,0.00,0.00,3511.11,1067377.44,0.00,0.00,0.00),('1','150','771','162417',3216176,'2142','329',235350.79,235654.79,0.00,0.00,304.00,499776.00,0.00,0.00,0.00),('1','150','771','162890',3224129,'2142','329',235654.79,238894.44,0.00,0.00,3239.65,984853.60,0.00,0.00,0.00),('1','150','771','162999',3226205,'2142','329',238894.44,240824.44,0.00,0.00,1930.00,586720.00,0.00,0.00,0.00),('1','150','771','163199',3229701,'2142','329',240824.44,243105.26,0.00,0.00,2280.82,693369.28,0.00,0.00,0.00),('1','150','771','163366',3232678,'2142','329',243105.26,245993.78,0.00,0.00,2888.52,878110.08,0.00,0.00,0.00),('1','150','771','163545',3235904,'2142','329',245993.78,249191.31,0.00,0.00,3197.53,972049.12,0.00,0.00,0.00),('1','150','771','163660',3237963,'2142','329',249191.31,249778.08,0.00,0.00,586.77,178378.08,0.00,0.00,0.00),('1','150','771','163741',3239450,'2142','329',249778.08,251328.77,0.00,0.00,1550.69,471409.76,0.00,0.00,0.00),('1','150','771','163898',3242253,'2142','329',251328.77,253656.79,0.00,0.00,2328.02,707718.08,0.00,0.00,0.00),('1','150','771','163991',3243873,'2142','329',253656.79,254053.00,0.00,0.00,396.21,120447.84,0.00,0.00,0.00),('1','150','771','164077',3245521,'2142','329',254053.00,255338.27,0.00,0.00,1285.27,390722.08,0.00,0.00,0.00),('1','150','771','164256',3248721,'2142','329',255338.27,257776.16,0.00,0.00,2437.89,741118.56,0.00,0.00,0.00),('1','150','771','164440',3252236,'2142','329',257776.16,259262.41,0.00,0.00,1486.25,451820.00,0.00,0.00,0.00),('1','150','771','164600',3255011,'2142','329',259262.41,262812.44,0.00,0.00,3550.03,1079209.12,0.00,0.00,0.00),('1','150','771','164657',3255953,'2142','329',262812.44,264177.40,0.00,0.00,1364.96,414947.84,0.00,0.00,0.00),('1','150','771','164795',3258503,'2142','329',264177.40,265993.28,0.00,0.00,1815.88,552027.52,0.00,0.00,0.00),('1','150','771','164990',3261887,'2142','329',265993.28,268039.82,0.00,0.00,2046.54,622148.16,0.00,0.00,0.00),('1','150','771','164993',3261921,'2142','329',268039.82,268627.39,0.00,0.00,587.57,188022.40,0.00,0.00,0.00),('1','150','771','165129',3264465,'2142','329',268627.39,270584.45,0.00,0.00,1957.06,626259.20,0.00,0.00,0.00),('1','150','771','165306',3267596,'2142','329',270584.45,273128.79,0.00,0.00,2544.34,773479.36,0.00,0.00,0.00),('1','150','771','165364',3268426,'2142','329',273128.79,273659.29,0.00,0.00,530.50,161272.00,0.00,0.00,0.00),('1','150','771','165438',3269877,'2142','329',273659.29,275995.44,0.00,0.00,2336.15,710189.60,0.00,0.00,0.00),('1','150','771','165602',3272645,'2142','329',275995.44,278403.94,0.00,0.00,2408.50,732184.00,0.00,0.00,0.00),('1','150','771','165791',3276286,'2142','329',278403.94,281747.45,0.00,0.00,3343.51,1016427.04,0.00,0.00,0.00),('1','150','771','165926',3278690,'2142','329',281747.45,283733.96,0.00,0.00,1986.51,603899.04,0.00,0.00,0.00),('1','150','771','165966',3279250,'2142','329',283733.96,284775.46,0.00,0.00,1041.50,316616.00,0.00,0.00,0.00),('1','150','771','166136',3282421,'2142','329',284775.46,287392.06,0.00,0.00,2616.60,795446.40,0.00,0.00,0.00),('1','150','771','166229',3283802,'2142','329',287392.06,288333.88,0.00,0.00,941.82,286313.28,0.00,0.00,0.00),('1','150','771','166311',3285513,'2142','329',288333.88,289860.88,0.00,0.00,1527.00,464208.00,0.00,0.00,0.00),('1','150','771','166486',3288845,'2142','329',289860.88,292636.70,0.00,0.00,2775.82,843849.28,0.00,0.00,0.00),('1','150','771','166701',3292390,'2142','329',292636.70,294629.49,0.00,0.00,1992.79,605808.16,0.00,0.00,0.00),('1','150','771','166885',3295549,'2142','329',294629.49,296968.63,0.00,0.00,2339.14,711098.56,0.00,0.00,0.00),('1','150','771','166942',3296470,'2142','329',296968.63,297463.69,0.00,0.00,495.06,150498.24,0.00,0.00,0.00),('1','150','771','167054',3298626,'2142','329',297463.69,299293.45,0.00,0.00,1829.76,556247.04,0.00,0.00,0.00),('1','150','771','167177',3300798,'2142','329',299293.45,302439.30,0.00,0.00,3145.85,956338.40,0.00,0.00,0.00),('1','150','771','167374',3304288,'2142','329',302439.30,304869.10,0.00,0.00,2429.80,738659.20,0.00,0.00,0.00),('1','150','771','167556',3307783,'2142','329',304869.10,306643.59,0.00,0.00,1774.49,539444.96,0.00,0.00,0.00),('1','150','771','167743',3310847,'2142','329',306643.59,309034.09,0.00,0.00,2390.50,726712.00,0.00,0.00,0.00),('1','150','771','167917',3313899,'2142','329',309034.09,311355.71,0.00,0.00,2321.62,705772.48,0.00,0.00,0.00),('1','150','771','167995',3315352,'2142','329',311355.71,311793.71,0.00,0.00,438.00,133152.00,0.00,0.00,0.00),('1','150','771','168106',3317628,'2142','329',311793.71,313772.44,0.00,0.00,1978.73,601533.92,0.00,0.00,0.00),('1','150','771','168278',3320852,'2142','329',313772.44,316872.96,0.00,0.00,3100.52,942558.08,0.00,0.00,0.00),('1','150','771','168404',3323099,'2142','329',316872.96,320340.56,0.00,0.00,3467.60,1054150.40,0.00,0.00,0.00),('1','150','771','168612',3326807,'2142','329',320340.56,322093.25,0.00,0.00,1752.69,532817.76,0.00,0.00,0.00),('1','150','771','168641',3327188,'2142','329',322093.25,322991.90,0.00,0.00,898.65,273189.60,0.00,0.00,0.00),('1','150','771','168772',3329683,'2142','329',322991.90,326344.63,0.00,0.00,3352.73,1019229.92,0.00,0.00,0.00),('1','150','771','168916',3332128,'2142','329',326344.63,327143.25,0.00,0.00,798.62,242780.48,0.00,0.00,0.00),('1','150','771','168933',3332361,'2142','329',327143.25,329859.89,0.00,0.00,2716.64,825858.56,0.00,0.00,0.00),('1','150','771','169119',3335708,'2142','329',329859.89,332178.47,0.00,0.00,2318.58,704848.32,0.00,0.00,0.00),('1','150','771','169121',3335739,'2142','329',332178.47,333240.29,0.00,0.00,1061.82,322793.28,0.00,0.00,0.00),('1','150','771','169268',3338516,'2142','329',333240.29,335760.93,0.00,0.00,2520.64,766274.56,0.00,0.00,0.00),('1','150','771','169504',3343193,'2142','329',335760.93,337165.69,0.00,0.00,1404.76,427047.04,0.00,0.00,0.00),('1','150','771','169772',3348198,'2142','329',337165.69,341063.22,0.00,0.00,3897.53,1184849.12,0.00,0.00,0.00),('1','150','771','169936',3351380,'2142','329',341063.22,342493.45,0.00,0.00,1430.23,434789.92,0.00,0.00,0.00),('1','150','771','170008',3352601,'2142','329',342493.45,343205.45,0.00,0.00,712.00,216448.00,0.00,0.00,0.00),('1','150','771','170154',3355208,'2142','329',343205.45,346265.31,0.00,0.00,3059.86,930197.44,0.00,0.00,0.00),('1','150','771','170287',3357503,'2142','329',346265.31,347295.57,0.00,0.00,1030.26,313199.04,0.00,0.00,0.00),('1','150','771','170330',3358231,'2142','329',347295.57,349322.41,0.00,0.00,2026.84,616159.36,0.00,0.00,0.00),('1','150','771','170482',3360821,'2142','329',349322.41,352206.12,0.00,0.00,2883.71,876647.84,0.00,0.00,0.00),('1','150','771','170655',3364089,'2142','329',352206.12,352627.69,0.00,0.00,421.57,128157.28,0.00,0.00,0.00),('1','150','771','170659',3364141,'2142','329',352627.69,354364.03,0.00,0.00,1736.34,527847.36,0.00,0.00,0.00),('1','150','771','170810',3366751,'2142','329',354364.03,356979.06,0.00,0.00,2615.03,836809.60,0.00,0.00,0.00),('1','150','771','170985',3369725,'2142','329',356979.06,358517.09,0.00,0.00,1538.03,492169.60,0.00,0.00,0.00),('1','150','771','171206',3374031,'2142','329',358517.09,361820.87,0.00,0.00,3303.78,1057209.60,0.00,0.00,0.00),('1','150','771','171359',3376878,'2142','329',361820.87,363849.93,0.00,0.00,2029.06,649299.20,0.00,0.00,0.00),('1','150','771','171575',3380716,'2142','329',363849.93,366534.21,0.00,0.00,2684.28,858969.60,0.00,0.00,0.00),('1','150','771','171759',3384018,'2142','329',366534.21,368957.08,0.00,0.00,2422.87,775318.40,0.00,0.00,0.00),('1','150','771','171952',3387396,'2142','329',368957.08,371814.70,0.00,0.00,2857.62,914438.40,0.00,0.00,0.00),('1','150','771','172075',3389685,'2142','329',371814.70,373422.13,0.00,0.00,1607.43,514377.60,0.00,0.00,0.00),('1','150','771','172080',3389739,'2142','329',373422.13,374652.97,0.00,0.00,1230.84,393868.80,0.00,0.00,0.00),('1','150','771','172273',3393212,'2142','329',374652.97,377123.84,0.00,0.00,2470.87,790678.40,0.00,0.00,0.00),('1','150','771','172440',3396344,'2142','329',377123.84,378394.46,0.00,0.00,1270.62,406598.40,0.00,0.00,0.00),('1','150','771','172697',3400991,'2142','329',378394.46,381816.33,0.00,0.00,3421.87,1094998.40,0.00,0.00,0.00),('1','150','771','172837',3403572,'2142','329',381816.33,383710.70,0.00,0.00,1894.37,606198.40,0.00,0.00,0.00),('1','150','771','173043',3407415,'2142','329',383710.70,386825.72,0.00,0.00,3115.02,996806.40,0.00,0.00,0.00),('1','150','771','173202',3410700,'2142','329',386825.72,389230.06,0.00,0.00,2404.34,769388.80,0.00,0.00,0.00),('1','150','771','173385',3413903,'2142','329',389230.06,392065.68,0.00,0.00,2835.62,907398.40,0.00,0.00,0.00),('1','150','771','173566',3417350,'2142','329',392065.68,394025.27,0.00,0.00,1959.59,627068.80,0.00,0.00,0.00),('1','150','771','173757',3420714,'2142','329',394025.27,397330.77,0.00,0.00,3305.50,1057760.00,0.00,0.00,0.00),('1','150','771','173936',3424019,'2142','329',397330.77,398562.73,0.00,0.00,1231.96,394227.20,0.00,0.00,0.00),('1','150','771','174123',3427302,'2142','329',398562.73,401984.38,0.00,0.00,3421.65,1094928.00,0.00,0.00,0.00),('1','150','771','174313',3430788,'2142','329',401984.38,403655.31,0.00,0.00,1670.93,534697.60,0.00,0.00,0.00),('1','150','771','174480',3433544,'2142','329',403655.31,407551.37,0.00,0.00,3896.06,1246739.20,0.00,0.00,0.00),('1','150','771','174597',3435696,'2142','329',407551.37,408806.84,0.00,0.00,1255.47,401750.40,0.00,0.00,0.00),('1','150','771','174631',3436281,'2142','329',408806.84,410657.65,0.00,0.00,1850.81,592259.20,0.00,0.00,0.00),('1','150','771','174833',3439993,'2142','329',410657.65,413201.65,0.00,0.00,2544.00,814080.00,0.00,0.00,0.00),('1','150','771','174998',3443204,'2142','329',413201.65,413449.07,0.00,0.00,247.42,79174.40,0.00,0.00,0.00),('1','150','771','175041',3443990,'2142','329',413449.07,415854.90,0.00,0.00,2405.83,866098.80,0.00,0.00,0.00),('1','150','771','175232',3447408,'2142','329',415854.90,418587.67,0.00,0.00,2732.77,983797.20,0.00,0.00,0.00),('1','150','771','175411',3450691,'2142','329',418587.67,421305.09,0.00,0.00,2717.42,978271.20,0.00,0.00,0.00),('1','150','771','175571',3453592,'2142','329',421305.09,423518.06,0.00,0.00,2212.97,796669.20,0.00,0.00,0.00),('1','150','771','175749',3456884,'2142','329',423518.06,427452.50,0.00,0.00,3934.44,1416398.40,0.00,0.00,0.00),('1','150','771','175833',3458246,'2142','329',427452.50,428331.44,0.00,0.00,878.94,316418.40,0.00,0.00,0.00),('1','150','771','175913',3459690,'2142','329',428331.44,430261.16,0.00,0.00,1929.72,694699.20,0.00,0.00,0.00),('1','150','771','176136',3463822,'2142','329',430261.16,433051.46,0.00,0.00,2790.30,1004508.00,0.00,0.00,0.00),('1','150','771','176320',3467228,'2142','329',433051.46,435816.97,0.00,0.00,2765.51,995583.60,0.00,0.00,0.00),('1','150','771','176505',3470644,'2142','329',435816.97,437894.19,0.00,0.00,2077.22,747799.20,0.00,0.00,0.00),('1','150','771','176760',3475411,'2142','329',437894.19,440240.05,0.00,0.00,2345.86,844509.60,0.00,0.00,0.00),('1','150','771','176925',3478491,'2142','329',440240.05,442474.13,0.00,0.00,2234.08,804268.80,0.00,0.00,0.00),('1','150','771','177211',3484029,'2142','329',442474.13,446099.40,0.00,0.00,3625.27,1305097.20,0.00,0.00,0.00),('1','150','771','177414',3488030,'2142','329',446099.40,447551.17,0.00,0.00,1451.77,522637.20,0.00,0.00,0.00),('1','150','771','177417',3488084,'2142','329',447551.17,449270.67,0.00,0.00,1719.50,619020.00,0.00,0.00,0.00),('1','150','771','177651',3492685,'2142','329',449270.67,452181.61,0.00,0.00,2910.94,1047938.40,0.00,0.00,0.00),('1','150','771','177869',3496657,'2142','329',452181.61,454123.72,0.00,0.00,1942.11,699159.60,0.00,0.00,0.00),('1','150','771','178064',3500576,'2142','329',454123.72,456332.52,0.00,0.00,2208.80,795168.00,0.00,0.00,0.00),('1','150','771','178179',3502635,'2142','329',456332.52,456950.77,0.00,0.00,618.25,222570.00,0.00,0.00,0.00),('1','150','771','178281',3504508,'2142','329',456950.77,458796.18,0.00,0.00,1845.41,664347.60,0.00,0.00,0.00),('1','150','771','178467',3507962,'2142','329',458796.18,461100.92,0.00,0.00,2304.74,829706.40,0.00,0.00,0.00),('1','150','771','178593',3510332,'2142','329',461100.92,461815.19,0.00,0.00,714.27,257137.20,0.00,0.00,0.00),('1','150','771','178699',3512262,'2142','329',461815.19,463907.13,0.00,0.00,2091.94,753098.40,0.00,0.00,0.00),('1','150','771','178867',3515320,'2142','329',463907.13,467017.55,0.00,0.00,3110.42,1119751.20,0.00,0.00,0.00),('1','150','771','179113',3519738,'2142','329',467017.55,469084.16,0.00,0.00,2066.61,743979.60,0.00,0.00,0.00),('1','150','771','179217',3521646,'2142','329',469084.16,471483.14,0.00,0.00,2398.98,863632.80,0.00,0.00,0.00),('1','150','771','179362',3524642,'2142','329',471483.14,472368.29,0.00,0.00,885.15,314154.00,0.00,0.00,0.00),('1','150','771','179453',3526120,'2142','329',472368.29,473755.34,0.00,0.00,1387.05,499338.00,0.00,0.00,0.00),('1','150','771','179573',3528482,'2142','329',473755.34,476316.62,0.00,0.00,2561.28,913277.08,0.00,0.00,0.00),('1','150','771','179769',3532418,'2142','329',476316.62,477805.51,0.00,0.00,1488.89,536000.40,0.00,0.00,0.00),('1','150','771','179914',3535112,'2142','329',477805.51,478678.78,0.00,0.00,873.27,314377.20,0.00,0.00,0.00),('1','150','771','179989',3536367,'2142','329',478678.78,481726.00,0.00,0.00,3047.22,1097193.80,0.00,0.00,0.00),('1','150','771','180169',3539874,'2142','329',481726.00,482878.76,0.00,0.00,1152.76,414993.60,0.00,0.00,0.00),('1','150','771','180237',3541000,'2142','329',482878.76,484954.16,0.00,0.00,2075.40,745646.40,0.00,0.00,0.00),('1','150','771','180335',3542773,'2142','329',484954.16,487524.92,0.00,0.00,2570.76,925473.60,0.00,0.00,0.00),('1','150','771','180543',3546677,'2142','329',487524.92,488320.67,0.00,0.00,795.75,288608.40,0.00,0.00,0.00),('1','150','771','180625',3547960,'2142','329',488320.67,489629.81,0.00,0.00,1309.14,470192.40,0.00,0.00,0.00),('1','150','771','180732',3550045,'2142','329',489629.81,492134.14,0.00,0.00,2504.33,901558.80,0.00,0.00,0.00),('1','150','771','180955',3554388,'2142','329',492134.14,493683.78,0.00,0.00,1549.64,557870.40,0.00,0.00,0.00),('1','150','771','181127',3557644,'2142','329',493683.78,496304.65,0.00,0.00,2620.87,943653.20,0.00,0.00,0.00),('1','150','771','181332',3561692,'2142','329',496304.65,498838.81,0.00,0.00,2534.16,912297.60,0.00,0.00,0.00),('1','150','771','181519',3565064,'2142','329',498838.81,502714.13,0.00,0.00,3875.32,1397095.20,0.00,0.00,0.00),('1','150','771','181698',3568067,'2142','329',502714.13,503532.95,0.00,0.00,818.82,294744.60,0.00,0.00,0.00),('1','150','771','181777',3569456,'2142','329',503532.95,505049.55,0.00,0.00,1516.60,547616.00,0.00,0.00,0.00),('1','150','771','181900',3571510,'2142','329',505049.55,507902.29,0.00,0.00,2852.74,1026986.40,0.00,0.00,0.00),('1','150','771','182291',3578745,'2142','329',507902.29,508462.12,0.00,0.00,559.83,201538.80,0.00,0.00,0.00),('1','150','771','182293',3578763,'2142','329',508462.12,510938.00,0.00,0.00,2475.88,891316.80,0.00,0.00,0.00),('1','150','771','182304',3578874,'2142','329',510938.00,513418.69,0.00,0.00,2480.69,893048.40,0.00,0.00,0.00),('1','150','771','182489',3582286,'2142','329',513418.69,516626.86,0.00,0.00,3208.17,1154941.20,0.00,0.00,0.00),('1','150','771','183094',3593514,'2142','329',516626.86,518782.44,0.00,0.00,2155.58,776008.80,0.00,0.00,0.00),('1','150','771','183097',3593517,'2142','329',518782.44,519978.19,0.00,0.00,1195.75,430470.00,0.00,0.00,0.00),('1','150','771','183102',3593568,'2142','329',519978.19,523674.13,0.00,0.00,3695.94,1330538.40,0.00,0.00,0.00),('1','150','771','183103',3593569,'2142','329',523674.13,524289.68,0.00,0.00,615.55,221598.00,0.00,0.00,0.00),('1','150','771','183107',3593615,'2142','329',524289.68,525919.85,0.00,0.00,1630.17,586861.20,0.00,0.00,0.00),('1','150','771','183224',3595728,'2142','329',525919.85,528398.05,0.00,0.00,2478.20,892152.00,0.00,0.00,0.00),('1','150','771','183443',3599572,'2142','329',528398.05,529230.59,0.00,0.00,832.54,299714.40,0.00,0.00,0.00),('1','150','771','183498',3600392,'2142','329',529230.59,530557.27,0.00,0.00,1326.68,477604.80,0.00,0.00,0.00),('1','150','771','183636',3603242,'2142','329',530557.27,532654.11,0.00,0.00,2096.84,754862.40,0.00,0.00,0.00),('1','150','771','183919',3608342,'2142','329',532654.11,534532.27,0.00,0.00,1878.16,676137.60,0.00,0.00,0.00),('1','150','771','184443',3617730,'2142','329',534532.27,537683.93,0.00,0.00,3151.66,1134597.60,0.00,0.00,0.00),('1','150','771','184444',3617731,'2142','329',537683.93,539737.37,0.00,0.00,2053.44,739238.40,0.00,0.00,0.00),('1','150','771','184530',3619101,'2142','329',539737.37,543058.97,0.00,0.00,3321.60,1195776.00,0.00,0.00,0.00),('1','150','771','184675',3621997,'2142','329',543058.97,544456.89,0.00,0.00,1397.92,503251.20,0.00,0.00,0.00),('1','150','771','184821',3624625,'2142','329',544456.89,545179.22,0.00,0.00,722.33,260038.80,0.00,0.00,0.00),('1','150','771','184869',3625489,'2142','329',545179.22,547264.87,0.00,0.00,2085.65,750834.00,0.00,0.00,0.00),('1','150','771','185095',3629365,'2142','329',547264.87,549616.85,0.00,0.00,2351.98,846712.80,0.00,0.00,0.00),('1','150','771','185253',3631854,'2142','329',549616.85,549906.60,0.00,0.00,289.75,104310.00,0.00,0.00,0.00),('1','150','771','185295',3632415,'2142','329',549906.60,551589.31,0.00,0.00,1682.71,605775.60,0.00,0.00,0.00),('1','150','771','185456',3635704,'2142','329',551589.31,554476.52,0.00,0.00,2887.21,1039395.60,0.00,0.00,0.00),('1','150','771','185667',3639462,'2142','329',554476.52,555861.72,0.00,0.00,1385.20,498672.00,0.00,0.00,0.00),('1','150','771','185776',3641148,'2142','329',555861.72,557554.48,0.00,0.00,1692.76,609393.60,0.00,0.00,0.00),('1','150','771','185864',3643001,'2142','329',557554.48,560159.36,0.00,0.00,2604.88,937756.80,0.00,0.00,0.00),('1','150','771','186077',3646819,'2142','329',560159.36,561205.60,0.00,0.00,1046.24,376646.40,0.00,0.00,0.00),('1','150','771','186250',3649709,'2142','329',561205.60,562107.43,0.00,0.00,901.83,324658.80,0.00,0.00,0.00),('1','150','771','186307',3650620,'2142','329',562107.43,564332.64,0.00,0.00,2225.21,801075.60,0.00,0.00,0.00),('1','150','771','186522',3654293,'2142','329',564332.64,565832.38,0.00,0.00,1499.74,539906.40,0.00,0.00,0.00),('1','150','771','186663',3656639,'2142','329',565832.38,566773.79,0.00,0.00,941.41,338907.60,0.00,0.00,0.00),('1','150','771','186741',3658048,'2142','329',566773.79,569135.37,0.00,0.00,2361.58,850168.80,0.00,0.00,0.00),('1','150','771','186970',3661796,'2142','329',569135.37,571245.36,0.00,0.00,2109.99,759596.40,0.00,0.00,0.00),('1','150','771','187132',3664643,'2142','329',571245.36,572208.55,0.00,0.00,963.19,346748.40,0.00,0.00,0.00),('1','150','771','187304',3667626,'2142','329',572208.55,575565.94,0.00,0.00,3357.39,1208660.40,0.00,0.00,0.00),('1','150','771','187534',3671851,'2142','329',575565.94,576780.46,0.00,0.00,1214.52,437227.20,0.00,0.00,0.00),('1','150','771','187540',3671958,'2142','329',576780.46,577874.94,0.00,0.00,1094.48,394012.80,0.00,0.00,0.00),('1','150','771','187565',3672322,'2142','329',577874.94,580700.33,0.00,0.00,2825.39,1017140.40,0.00,0.00,0.00),('1','150','771','187787',3676307,'2142','329',580700.33,582172.17,0.00,0.00,1471.84,529862.40,0.00,0.00,0.00),('1','150','771','187984',3679722,'2142','329',582172.17,583213.98,0.00,0.00,1041.81,375051.60,0.00,0.00,0.00),('1','150','771','188049',3680650,'2142','329',583213.98,586599.30,0.00,0.00,3385.32,1218715.20,0.00,0.00,0.00),('1','150','771','188200',3683485,'2142','329',586599.30,587440.12,0.00,0.00,840.82,302695.20,0.00,0.00,0.00),('1','150','771','188271',3684555,'2142','329',587440.12,590031.70,0.00,0.00,2591.58,932968.80,0.00,0.00,0.00),('1','150','771','188415',3687114,'2142','329',590031.70,592766.23,0.00,0.00,2734.53,984430.80,0.00,0.00,0.00),('1','150','771','188630',3690768,'2142','329',592766.23,595508.06,0.00,0.00,2741.83,987058.80,0.00,0.00,0.00),('1','150','771','188799',3693905,'2142','329',595508.06,598238.31,0.00,0.00,2730.25,982890.00,0.00,0.00,0.00),('1','150','771','188999',3697539,'2142','329',598238.31,600398.99,0.00,0.00,2160.68,777844.80,0.00,0.00,0.00),('1','150','771','189192',3700938,'2142','329',600398.99,602833.37,0.00,0.00,2434.38,876376.80,0.00,0.00,0.00),('1','150','771','189413',3704990,'2142','329',602833.37,603590.51,0.00,0.00,757.14,272570.40,0.00,0.00,0.00),('1','150','771','189487',3706133,'2142','329',603590.51,605036.70,0.00,0.00,1446.19,520628.40,0.00,0.00,0.00),('1','150','771','189611',3708413,'2142','329',605036.70,607581.90,0.00,0.00,2545.20,916272.00,0.00,0.00,0.00),('1','150','771','189804',3711833,'2142','329',607581.90,608849.44,0.00,0.00,1267.54,456314.40,0.00,0.00,0.00),('1','150','771','189913',3713497,'2142','329',608849.44,610075.81,0.00,0.00,1226.37,441493.20,0.00,0.00,0.00),('1','150','771','190025',3716196,'2142','329',610075.81,613042.34,0.00,0.00,2966.53,1067950.80,0.00,0.00,0.00),('1','150','771','190204',3719625,'2142','329',613042.34,614031.40,0.00,0.00,989.06,356061.60,0.00,0.00,0.00),('1','150','771','190296',3721022,'2142','329',614031.40,616055.29,0.00,0.00,2023.89,728600.40,0.00,0.00,0.00),('1','150','771','190425',3723697,'2142','329',616055.29,619042.33,0.00,0.00,2987.04,1075334.40,0.00,0.00,0.00),('1','150','771','190662',3728120,'2142','329',619042.33,619474.85,0.00,0.00,432.52,155707.20,0.00,0.00,0.00),('1','150','771','190708',3728762,'2142','329',619474.85,621173.63,0.00,0.00,1698.78,611560.80,0.00,0.00,0.00),('1','150','771','190880',3732113,'2142','329',621173.63,623812.42,0.00,0.00,2638.79,949964.40,0.00,0.00,0.00),('1','150','771','191081',3735512,'2142','329',623812.42,624863.06,0.00,0.00,1050.64,378230.40,0.00,0.00,0.00),('1','150','771','191200',3737557,'2142','329',624863.06,626030.21,0.00,0.00,1167.15,420174.00,0.00,0.00,0.00),('1','150','771','191283',3739198,'2142','329',626030.21,628850.28,0.00,0.00,2820.07,1015225.20,0.00,0.00,0.00),('1','150','771','191541',3743587,'2142','329',628850.28,628850.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','191548',3743722,'2142','329',628850.28,629516.50,0.00,0.00,666.22,239839.20,0.00,0.00,0.00),('1','150','771','191551',3743766,'2142','329',629516.50,631562.61,0.00,0.00,2046.11,736599.60,0.00,0.00,0.00),('1','150','771','191717',3747256,'2142','329',631562.61,633979.76,0.00,0.00,2417.15,870174.00,0.00,0.00,0.00),('1','150','771','191930',3751497,'2142','329',633979.76,634724.66,0.00,0.00,744.90,268164.00,0.00,0.00,0.00),('1','150','771','192028',3753120,'2142','329',634724.66,636224.51,0.00,0.00,1499.85,539946.00,0.00,0.00,0.00),('1','150','771','192123',3754845,'2142','329',636224.51,638553.43,0.00,0.00,2328.92,838411.20,0.00,0.00,0.00),('1','150','771','192366',3759170,'2142','329',638553.43,640042.24,0.00,0.00,1488.81,535971.60,0.00,0.00,0.00),('1','150','771','192556',3762827,'2142','329',640042.24,642813.15,0.00,0.00,2770.91,997527.60,0.00,0.00,0.00),('1','150','771','192758',3766292,'2142','329',642813.15,645157.14,0.00,0.00,2343.99,843836.40,0.00,0.00,0.00),('1','150','771','192951',3769873,'2142','329',645157.14,649131.43,0.00,0.00,3974.29,1430744.40,0.00,0.00,0.00),('1','150','771','193160',3773925,'2142','329',649131.43,650586.39,0.00,0.00,1454.96,523785.60,0.00,0.00,0.00),('1','150','771','193400',3778788,'2142','329',650586.39,653979.77,0.00,0.00,3393.38,1221616.80,0.00,0.00,0.00),('1','150','771','193641',3782994,'2142','329',653979.77,656027.51,0.00,0.00,2047.74,737186.40,0.00,0.00,0.00),('1','150','771','193846',3786842,'2142','329',656027.51,659012.03,0.00,0.00,2984.52,1074427.20,0.00,0.00,0.00),('1','150','771','194084',3790942,'2142','329',659012.03,661035.46,0.00,0.00,2023.43,728434.80,0.00,0.00,0.00),('1','150','771','194288',3794825,'2142','329',661035.46,665992.70,0.00,0.00,4957.24,1784606.40,0.00,0.00,0.00),('1','150','771','194517',3798739,'2142','329',665992.70,666432.00,0.00,0.00,439.30,158148.00,0.00,0.00,0.00),('1','150','771','194536',3799025,'2142','329',666432.00,669408.68,0.00,0.00,2976.68,1071604.80,0.00,0.00,0.00),('1','150','771','194667',3801585,'2142','329',669408.68,671583.77,0.00,0.00,2175.09,783032.40,0.00,0.00,0.00),('1','150','771','194893',3806104,'2142','329',671583.77,675627.63,0.00,0.00,4043.86,1455789.60,0.00,0.00,0.00),('1','150','771','195080',3809391,'2142','329',675627.63,676712.61,0.00,0.00,1084.98,390592.80,0.00,0.00,0.00),('1','150','771','195204',3811527,'2142','329',676712.61,678568.96,0.00,0.00,1856.35,668286.00,0.00,0.00,0.00),('1','150','771','195293',3813242,'2142','329',678568.96,681573.23,0.00,0.00,3004.27,1081537.20,0.00,0.00,0.00),('1','150','771','195556',3817606,'2142','329',681573.23,683717.59,0.00,0.00,2144.36,771969.60,0.00,0.00,0.00),('1','150','771','195774',3821383,'2142','329',683717.59,686855.97,0.00,0.00,3138.38,1129816.80,0.00,0.00,0.00),('1','150','771','196000',3825558,'2142','329',686855.97,690722.17,0.00,0.00,3866.20,1391832.00,0.00,0.00,0.00),('1','150','771','196220',3829716,'2142','329',690722.17,692741.88,0.00,0.00,2019.71,727095.60,0.00,0.00,0.00),('1','150','771','196437',3833686,'2142','329',692741.88,696285.66,0.00,0.00,3543.78,1275760.80,0.00,0.00,0.00),('1','150','771','196654',3837537,'2142','329',696285.66,698013.77,0.00,0.00,1728.11,622119.60,0.00,0.00,0.00),('1','150','771','196805',3840175,'2142','329',698013.77,699167.30,0.00,0.00,1153.53,415270.80,0.00,0.00,0.00),('1','150','771','196919',3842070,'2142','329',699167.30,700647.80,0.00,0.00,1480.50,532980.00,0.00,0.00,0.00),('1','150','771','197027',3844235,'2142','329',700647.80,703503.25,0.00,0.00,2855.45,1027962.00,0.00,0.00,0.00),('1','150','771','197343',3850144,'2142','329',703503.25,705945.16,0.00,0.00,2441.91,879087.60,0.00,0.00,0.00),('1','150','771','197346',3850148,'2142','329',705945.16,708505.32,0.00,0.00,2560.16,921657.60,0.00,0.00,0.00),('1','150','771','197824',3858053,'2142','329',708505.32,711422.60,0.00,0.00,2917.28,1050220.80,0.00,0.00,0.00),('1','150','771','197865',3858709,'2142','329',711422.60,713806.28,0.00,0.00,2383.68,858124.80,0.00,0.00,0.00),('1','150','771','198166',3863831,'2142','329',713806.28,716046.44,0.00,0.00,2240.16,806457.60,0.00,0.00,0.00),('1','150','771','198338',3866942,'2142','329',716046.44,718652.83,0.00,0.00,2606.39,938300.40,0.00,0.00,0.00),('1','150','771','198562',3870762,'2142','329',718652.83,719189.55,0.00,0.00,536.72,193219.20,0.00,0.00,0.00),('1','150','771','198637',3871967,'2142','329',719189.55,720949.95,0.00,0.00,1760.40,633744.00,0.00,0.00,0.00),('1','150','771','198772',3874246,'2142','329',720949.95,724613.73,0.00,0.00,3663.78,1318960.80,0.00,0.00,0.00),('1','150','771','199013',3878288,'2142','329',724613.73,727737.46,0.00,0.00,3123.73,1124542.80,0.00,0.00,0.00),('1','150','771','199271',3882702,'2142','329',727737.46,730135.31,0.00,0.00,2397.85,863226.00,0.00,0.00,0.00),('1','150','771','199455',3885703,'2142','329',730135.31,732664.47,0.00,0.00,2529.16,910497.60,0.00,0.00,0.00),('1','150','771','199630',3889075,'2142','329',732664.47,735307.85,0.00,0.00,2643.38,951616.80,0.00,0.00,0.00),('1','150','771','199861',3892432,'2142','329',735307.85,738141.96,0.00,0.00,2834.11,1020279.60,0.00,0.00,0.00),('1','150','771','200085',3896672,'2142','329',738141.96,740508.92,0.00,0.00,2366.96,852105.60,0.00,0.00,0.00),('1','150','771','200283',3900151,'2142','329',740508.92,744373.70,0.00,0.00,3864.78,1391320.80,0.00,0.00,0.00),('1','150','771','200488',3903986,'2142','329',744373.70,746075.68,0.00,0.00,1701.98,612712.80,0.00,0.00,0.00),('1','150','771','200599',3905780,'2142','329',746075.68,747711.34,0.00,0.00,1635.66,588837.60,0.00,0.00,0.00),('1','150','771','200686',3907444,'2142','329',747711.34,750565.08,0.00,0.00,2853.74,1027346.40,0.00,0.00,0.00),('1','150','771','200912',3911416,'2142','329',750565.08,751346.80,0.00,0.00,781.72,281419.20,0.00,0.00,0.00),('1','150','771','200985',3912416,'2142','329',751346.80,753902.90,0.00,0.00,2556.10,920196.00,0.00,0.00,0.00),('1','150','771','201100',3914526,'2142','329',753902.90,756688.42,0.00,0.00,2785.52,1002787.20,0.00,0.00,0.00),('1','150','771','201302',3917900,'2142','329',756688.42,759747.78,0.00,0.00,3059.36,1101369.60,0.00,0.00,0.00),('1','150','771','201491',3921433,'2142','329',759747.78,762870.48,0.00,0.00,3122.70,1124172.00,0.00,0.00,0.00),('1','150','771','201756',3926568,'2142','329',762870.48,766977.60,0.00,0.00,4107.12,1478563.20,0.00,0.00,0.00),('1','150','771','202020',3931492,'2142','329',766977.60,768146.03,0.00,0.00,1168.43,420634.80,0.00,0.00,0.00),('1','150','771','202145',3933661,'2142','329',768146.03,769669.15,0.00,0.00,1523.12,548323.20,0.00,0.00,0.00),('1','150','771','202202',3934540,'2142','329',769669.15,772858.20,0.00,0.00,3189.05,1148058.00,0.00,0.00,0.00),('1','150','771','202421',3938362,'2142','329',772858.20,773264.77,0.00,0.00,406.57,146365.20,0.00,0.00,0.00),('1','150','771','202490',3939383,'2142','329',773264.77,775727.53,0.00,0.00,2462.76,886593.60,0.00,0.00,0.00),('1','150','771','202639',3942134,'2142','329',775727.53,778356.69,0.00,0.00,2629.16,946497.60,0.00,0.00,0.00),('1','150','771','202838',3945801,'2142','329',778356.69,780894.02,0.00,0.00,2537.33,913438.80,0.00,0.00,0.00),('1','150','771','203104',3950796,'2142','329',780894.02,783286.35,0.00,0.00,2392.33,861238.80,0.00,0.00,0.00),('1','150','771','203297',3954348,'2142','329',783286.35,786624.71,0.00,0.00,3338.36,1201809.60,0.00,0.00,0.00),('1','150','771','203517',3958260,'2142','329',786624.71,788379.11,0.00,0.00,1754.40,631584.00,0.00,0.00,0.00),('1','150','771','203631',3960347,'2142','329',788379.11,789771.25,0.00,0.00,1392.14,501170.40,0.00,0.00,0.00),('1','150','771','203723',3961984,'2142','329',789771.25,792856.44,0.00,0.00,3085.19,1160031.44,0.00,0.00,0.00),('1','150','771','203954',3966042,'2142','329',792856.44,793268.81,0.00,0.00,412.37,155051.12,0.00,0.00,0.00),('1','150','771','204005',3966616,'2142','329',793268.81,794735.77,0.00,0.00,1466.96,551576.96,0.00,0.00,0.00),('1','150','771','204181',3970298,'2142','329',794735.77,797763.09,0.00,0.00,3027.32,1138272.32,0.00,0.00,0.00),('1','150','771','204386',3973930,'2142','329',797763.09,798668.77,0.00,0.00,905.68,340535.68,0.00,0.00,0.00),('1','150','771','204515',3976080,'2142','329',798668.77,800027.17,0.00,0.00,1358.40,510758.40,0.00,0.00,0.00),('1','150','771','204607',3977945,'2142','329',800027.17,802756.50,0.00,0.00,2729.33,1026228.08,0.00,0.00,0.00),('1','150','771','204830',3981516,'2142','329',802756.50,804043.11,0.00,0.00,1286.61,483765.36,0.00,0.00,0.00),('1','150','771','204941',3983327,'2142','329',804043.11,805635.23,0.00,0.00,1592.12,598637.12,0.00,0.00,0.00),('1','150','771','205033',3985165,'2142','329',805635.23,809477.13,0.00,0.00,3841.90,1444554.40,0.00,0.00,0.00),('1','150','771','205313',3990010,'2142','329',809477.13,811682.84,0.00,0.00,2205.71,829346.96,0.00,0.00,0.00),('1','150','771','205698',3997350,'2142','329',811682.84,813403.58,0.00,0.00,1720.74,646998.24,0.00,0.00,0.00),('1','150','771','205797',3998898,'2142','329',813403.58,817058.45,0.00,0.00,3654.87,1374231.12,0.00,0.00,0.00),('1','150','771','205934',4001475,'2142','329',817058.45,818942.62,0.00,0.00,1884.17,708447.92,0.00,0.00,0.00),('1','150','771','206142',4005149,'2142','329',818942.62,821495.17,0.00,0.00,2552.55,959758.80,0.00,0.00,0.00),('1','150','771','206354',4008801,'2142','329',821495.17,824369.25,0.00,0.00,2874.08,1080654.08,0.00,0.00,0.00),('1','150','771','206511',4011531,'2142','329',824369.25,825354.39,0.00,0.00,985.14,370412.64,0.00,0.00,0.00),('1','150','771','206564',4012492,'2142','329',825354.39,829484.05,0.00,0.00,4129.66,1552752.16,0.00,0.00,0.00),('1','150','771','206785',4016393,'2142','329',829484.05,832422.24,0.00,0.00,2938.19,1104759.44,0.00,0.00,0.00),('1','150','771','207013',4020563,'2142','329',832422.24,834684.26,0.00,0.00,2262.02,850519.52,0.00,0.00,0.00),('1','150','771','207345',4026242,'2142','329',834684.26,838364.08,0.00,0.00,3679.82,1383612.32,0.00,0.00,0.00),('1','150','771','207511',4029328,'2142','329',838364.08,839704.33,0.00,0.00,1340.25,503934.00,0.00,0.00,0.00),('1','150','771','207573',4030418,'2142','329',839704.33,842362.40,0.00,0.00,2658.07,999434.32,0.00,0.00,0.00),('1','150','771','207691',4032465,'2142','329',842362.40,844805.32,0.00,0.00,2442.92,938081.28,0.00,0.00,0.00),('1','150','771','207998',4037579,'2142','329',844805.32,849506.18,0.00,0.00,4700.86,1805130.24,0.00,0.00,0.00),('1','150','771','208148',4040148,'2142','329',849506.18,850076.46,0.00,0.00,570.28,218987.52,0.00,0.00,0.00),('1','150','771','208163',4040445,'2142','329',850076.46,853507.71,0.00,0.00,3431.25,1317600.00,0.00,0.00,0.00),('1','150','771','208349',4043874,'2142','329',853507.71,855249.02,0.00,0.00,1741.31,668663.04,0.00,0.00,0.00),('1','150','771','208507',4046777,'2142','329',855249.02,856105.52,0.00,0.00,856.50,328896.00,0.00,0.00,0.00),('1','150','771','208562',4047584,'2142','329',856105.52,859293.83,0.00,0.00,3188.31,1224311.04,0.00,0.00,0.00),('1','150','771','208749',4050985,'2142','329',859293.83,860419.73,0.00,0.00,1125.90,432345.60,0.00,0.00,0.00),('1','150','771','208851',4052461,'2142','329',860419.73,862611.54,0.00,0.00,2191.81,841655.04,0.00,0.00,0.00),('1','150','771','208997',4055117,'2142','329',862611.54,862828.86,0.00,0.00,217.32,83450.88,0.00,0.00,0.00),('1','150','771','208998',4055118,'2142','329',862828.86,865917.37,0.00,0.00,3088.51,1235404.00,0.00,0.00,0.00),('1','150','771','209281',4060051,'2142','329',865917.37,866379.99,0.00,0.00,462.62,185048.00,0.00,0.00,0.00),('1','150','771','209286',4060157,'2142','329',866379.99,868708.87,0.00,0.00,2328.88,931552.00,0.00,0.00,0.00),('1','150','771','209427',4062806,'2142','329',868708.87,871779.38,0.00,0.00,3070.51,1228204.00,0.00,0.00,0.00),('1','150','771','209635',4066531,'2142','329',871779.38,875457.76,0.00,0.00,3678.38,1471352.00,0.00,0.00,0.00),('1','150','771','209860',4070426,'2142','329',875457.76,877114.92,0.00,0.00,1657.16,696007.20,0.00,0.00,0.00),('1','150','771','210092',4074676,'2142','329',877114.92,880512.81,0.00,0.00,3397.89,1427113.80,0.00,0.00,0.00),('1','150','771','210300',4078271,'2142','329',880512.81,882416.75,0.00,0.00,1903.94,799654.80,0.00,0.00,0.00),('1','150','771','210553',4082661,'2142','329',882416.75,885944.20,0.00,0.00,3527.45,1481529.00,0.00,0.00,0.00),('1','150','771','210772',4086572,'2142','329',885944.20,887484.59,0.00,0.00,1540.39,646963.80,0.00,0.00,0.00),('1','150','771','210940',4089553,'2142','329',887484.59,891521.66,0.00,0.00,4037.07,1695569.40,0.00,0.00,0.00),('1','150','771','211215',4094243,'2142','329',891521.66,893048.63,0.00,0.00,1526.97,641327.40,0.00,0.00,0.00),('1','150','771','211301',4095984,'2142','329',893048.63,893964.49,0.00,0.00,915.86,384661.20,0.00,0.00,0.00),('1','150','771','211362',4097160,'2142','329',893964.49,896882.30,0.00,0.00,2917.81,1225480.20,0.00,0.00,0.00),('1','150','771','211643',4101928,'2142','329',896882.30,898577.65,0.00,0.00,1695.35,712047.00,0.00,0.00,0.00),('1','150','771','211771',4104044,'2142','329',898577.65,901923.39,0.00,0.00,3345.74,1405210.80,0.00,0.00,0.00),('1','150','771','212021',4108334,'2142','329',901923.39,903795.76,0.00,0.00,1872.37,786395.40,0.00,0.00,0.00),('1','150','771','212219',4112041,'2142','329',903795.76,906916.20,0.00,0.00,3120.44,1310584.80,0.00,0.00,0.00),('1','150','771','212449',4116267,'2142','329',906916.20,909747.74,0.00,0.00,2831.54,1189246.80,0.00,0.00,0.00),('1','150','771','212657',4119977,'2142','329',909747.74,912654.48,0.00,0.00,2906.74,1220830.80,0.00,0.00,0.00),('1','150','771','212867',4123612,'2142','329',912654.48,914906.35,0.00,0.00,2251.87,945785.40,0.00,0.00,0.00),('1','150','771','213200',4129218,'2142','329',914906.35,918368.20,0.00,0.00,3461.85,1453977.00,0.00,0.00,0.00),('1','150','771','213443',4133181,'2142','329',918368.20,920118.79,0.00,0.00,1750.59,735247.80,0.00,0.00,0.00),('1','150','771','213675',4137096,'2142','329',920118.79,923691.23,0.00,0.00,3572.44,1500424.80,0.00,0.00,0.00),('1','150','771','213872',4140459,'2142','329',923691.23,925492.23,0.00,0.00,1801.00,756420.00,0.00,0.00,0.00),('1','150','771','214018',4142744,'2142','329',925492.23,926633.11,0.00,0.00,1140.88,479169.60,0.00,0.00,0.00),('1','150','771','214126',4144552,'2142','329',926633.11,930189.19,0.00,0.00,3556.08,1493553.60,0.00,0.00,0.00),('1','150','771','214363',4148664,'2142','329',930189.19,931215.69,0.00,0.00,1026.50,431130.00,0.00,0.00,0.00),('1','150','771','214415',4149616,'2142','329',931215.69,933506.32,0.00,0.00,2290.63,962064.60,0.00,0.00,0.00),('1','150','771','214515',4151480,'2142','329',933506.32,936387.41,0.00,0.00,2881.09,1210057.80,0.00,0.00,0.00),('1','150','771','214764',4155769,'2142','329',936387.41,940436.35,0.00,0.00,4048.94,1700554.80,0.00,0.00,0.00),('1','150','771','214990',4159490,'2142','329',940436.35,941616.81,0.00,0.00,1180.46,495793.20,0.00,0.00,0.00),('1','150','771','215087',4160968,'2142','329',941616.81,943573.72,0.00,0.00,1956.91,821902.20,0.00,0.00,0.00),('1','150','771','215219',4163468,'2142','329',943573.72,946276.92,0.00,0.00,2703.20,1211033.60,0.00,0.00,0.00),('1','150','771','215434',4167048,'2142','329',946276.92,946950.39,0.00,0.00,673.47,301714.56,0.00,0.00,0.00),('1','150','771','215515',4168150,'2142','329',946950.39,949214.96,0.00,0.00,2264.57,1014527.36,0.00,0.00,0.00),('1','150','771','215668',4171044,'2142','329',949214.96,952110.07,0.00,0.00,2895.11,1297009.28,0.00,0.00,0.00),('1','150','771','215942',4175558,'2142','329',952110.07,954827.74,0.00,0.00,2717.67,1217516.16,0.00,0.00,0.00),('1','150','771','216090',4178366,'2142','329',954827.74,957620.55,0.00,0.00,2792.81,1251178.88,0.00,0.00,0.00),('1','150','771','216311',4182201,'2142','329',957620.55,957947.39,0.00,0.00,326.84,147731.68,0.00,0.00,0.00),('1','150','771','216383',4183149,'2142','329',957947.39,960856.01,0.00,0.00,2908.62,1314696.24,0.00,0.00,0.00),('1','150','771','216542',4186208,'2142','329',960856.01,962828.86,0.00,0.00,1972.85,891728.20,0.00,0.00,0.00),('1','150','771','216827',4190978,'2142','329',962828.86,966753.97,0.00,0.00,3925.11,1774149.72,0.00,0.00,0.00),('1','150','771','217053',4194898,'2142','329',966753.97,968060.08,0.00,0.00,1306.11,626932.80,0.00,0.00,0.00),('1','150','771','217157',4196869,'2142','329',968060.08,969129.83,0.00,0.00,1069.75,513480.00,0.00,0.00,0.00),('1','150','771','217275',4199338,'2142','329',969129.83,972115.98,0.00,0.00,2986.15,1433352.00,0.00,0.00,0.00),('1','150','771','217496',4203160,'2142','329',972115.98,972944.88,0.00,0.00,828.90,397872.00,0.00,0.00,0.00),('1','150','771','217558',4204021,'2142','329',972944.88,975041.35,0.00,0.00,2096.47,1006305.60,0.00,0.00,0.00),('1','150','771','217704',4206690,'2142','329',975041.35,977563.09,0.00,0.00,2521.74,1210435.20,0.00,0.00,0.00),('1','150','771','217972',4211644,'2142','329',977563.09,978210.30,0.00,0.00,647.21,310660.80,0.00,0.00,0.00),('1','150','771','218045',4212602,'2142','329',978210.30,980161.24,0.00,0.00,1950.94,936451.20,0.00,0.00,0.00),('1','150','771','218213',4215715,'2142','329',980161.24,982843.90,0.00,0.00,2682.66,1287676.80,0.00,0.00,0.00),('1','150','771','218435',4219748,'2142','329',982843.90,983601.51,0.00,0.00,757.61,363652.80,0.00,0.00,0.00),('1','150','771','218535',4221373,'2142','329',983601.51,985437.22,0.00,0.00,1835.71,881140.80,0.00,0.00,0.00),('1','150','771','218675',4223995,'2142','329',985437.22,988396.96,0.00,0.00,2959.74,1420675.20,0.00,0.00,0.00),('1','150','771','218895',4227919,'2142','329',988396.96,988700.21,0.00,0.00,303.25,145560.00,0.00,0.00,0.00),('1','150','771','218936',4228322,'2142','329',988700.21,991299.66,0.00,0.00,2599.45,1247736.00,0.00,0.00,0.00),('1','150','771','219109',4231506,'2142','329',991299.66,994138.78,0.00,0.00,2839.12,1362777.60,0.00,0.00,0.00),('1','150','771','219321',4235232,'2142','329',994138.78,996504.20,0.00,0.00,2365.42,1135401.60,0.00,0.00,0.00),('1','150','771','219581',4239644,'2142','329',996504.20,999045.65,0.00,0.00,2541.45,1219896.00,0.00,0.00,0.00),('1','150','771','219799',4243639,'2142','329',999045.65,999602.75,0.00,0.00,557.10,267408.00,0.00,0.00,0.00),('1','150','771','219882',4244833,'2142','329',999602.75,1001567.27,0.00,0.00,1964.52,942969.60,0.00,0.00,0.00),('1','150','771','220029',4247786,'2142','329',1001567.27,1004363.52,0.00,0.00,2796.25,1342200.00,0.00,0.00,0.00),('1','150','771','220231',4251298,'2142','329',1004363.52,1004853.64,0.00,0.00,490.12,235257.60,0.00,0.00,0.00),('1','150','771','220337',4253008,'2142','329',1004853.64,1006885.01,0.00,0.00,2031.37,975057.60,0.00,0.00,0.00),('1','150','771','220455',4255481,'2142','329',1006885.01,1010184.44,0.00,0.00,3299.43,1583726.40,0.00,0.00,0.00),('1','150','771','220717',4259636,'2142','329',1010184.44,1013342.85,0.00,0.00,3158.41,1516036.80,0.00,0.00,0.00),('1','150','771','220896',4263153,'2142','329',1013342.85,1015669.31,0.00,0.00,2326.46,1116700.80,0.00,0.00,0.00),('1','150','771','221131',4267286,'2142','329',1015669.31,1019002.60,0.00,0.00,3333.29,1599979.20,0.00,0.00,0.00),('1','150','771','221376',4271700,'2142','329',1019002.60,1020861.08,0.00,0.00,1858.48,892070.40,0.00,0.00,0.00),('1','150','771','221586',4275588,'2142','329',1020861.08,1021661.20,0.00,0.00,800.12,384057.60,0.00,0.00,0.00),('1','150','771','221621',4276093,'2142','329',1021661.20,1025237.34,0.00,0.00,3576.14,1716547.20,0.00,0.00,0.00),('1','150','771','221837',4279846,'2142','329',1025237.34,1025990.33,0.00,0.00,752.99,361435.20,0.00,0.00,0.00),('1','150','771','221906',4280955,'2142','329',1025990.33,1028133.08,0.00,0.00,2142.75,1028520.00,0.00,0.00,0.00),('1','150','771','222090',4284344,'2142','329',1028133.08,1031208.01,0.00,0.00,3074.93,1475966.40,0.00,0.00,0.00),('1','150','771','222259',4287438,'2142','329',1031208.01,1035010.30,0.00,0.00,3802.29,1825099.20,0.00,0.00,0.00),('1','150','771','222478',4291199,'2142','329',1035010.30,1036470.63,0.00,0.00,1460.33,700958.40,0.00,0.00,0.00),('1','150','771','222625',4293644,'2142','329',1036470.63,1037558.02,0.00,0.00,1087.39,521947.20,0.00,0.00,0.00),('1','150','771','222741',4295897,'2142','329',1037558.02,1040406.20,0.00,0.00,2848.18,1367126.40,0.00,0.00,0.00),('1','150','771','222935',4299650,'2142','329',1040406.20,1042430.01,0.00,0.00,2023.81,971428.80,0.00,0.00,0.00),('1','150','771','223166',4303670,'2142','329',1042430.01,1045026.78,0.00,0.00,2596.77,1246449.60,0.00,0.00,0.00),('1','150','771','223407',4307812,'2142','329',1045026.78,1046296.42,0.00,0.00,1269.64,610027.20,0.00,0.00,0.00),('1','150','771','223547',4310139,'2142','329',1046296.42,1047738.96,0.00,0.00,1442.54,738580.48,0.00,0.00,0.00),('1','150','771','223666',4312364,'2142','329',1047738.96,1049758.38,0.00,0.00,2019.42,1033943.04,0.00,0.00,0.00),('1','150','771','223895',4316634,'2142','329',1049758.38,1052752.68,0.00,0.00,2994.30,1533081.60,0.00,0.00,0.00),('1','150','771','224069',4319831,'2142','329',1052752.68,1053774.84,0.00,0.00,1022.16,523345.92,0.00,0.00,0.00),('1','150','771','224069',4319832,'2941','329',0.00,1679.68,0.00,0.00,1679.68,859996.16,0.00,0.00,0.00),('1','150','771','224296',4324010,'2142','329',1053774.84,1053864.93,0.00,0.00,90.09,46126.08,0.00,0.00,0.00),('1','150','771','224296',4324011,'2941','329',1679.68,3911.05,0.00,0.00,2231.37,1142461.44,0.00,0.00,0.00),('1','150','771','224602',4329010,'2142','329',1053864.93,1054092.80,0.00,0.00,227.87,116669.44,0.00,0.00,0.00),('1','150','771','224602',4329011,'2941','329',3911.05,4336.94,0.00,0.00,425.89,218055.68,0.00,0.00,0.00),('1','150','771','224614',4329298,'2142','329',1054092.80,1054907.45,0.00,0.00,814.65,417100.80,0.00,0.00,0.00),('1','150','771','224614',4329299,'2941','329',4336.94,5352.49,0.00,0.00,1015.55,519961.60,0.00,0.00,0.00),('1','150','771','224765',4332175,'2142','329',1054907.45,1055416.38,0.00,0.00,508.93,260572.16,0.00,0.00,0.00),('1','150','771','224765',4332176,'2941','329',5352.49,6922.40,0.00,0.00,1569.91,803793.92,0.00,0.00,0.00),('1','150','771','225003',4336469,'2142','329',1055416.38,1056663.37,0.00,0.00,1246.99,638458.88,0.00,0.00,0.00),('1','150','771','225003',4336470,'2941','329',6922.40,7153.22,0.00,0.00,230.82,118179.84,0.00,0.00,0.00),('1','150','771','225252',4340912,'2142','329',1056663.37,1057088.00,0.00,0.00,424.63,217410.56,0.00,0.00,0.00),('1','150','771','225252',4340913,'2941','329',7153.22,10123.33,0.00,0.00,2970.11,1520696.32,0.00,0.00,0.00),('1','150','771','225472',4344995,'2142','329',1057088.00,1058506.19,0.00,0.00,1418.19,726113.28,0.00,0.00,0.00),('1','150','771','225472',4344996,'2941','329',10123.33,10464.38,0.00,0.00,341.05,174617.60,0.00,0.00,0.00),('1','150','771','225633',4347850,'2142','329',1058506.19,1058566.44,0.00,0.00,60.25,30848.00,0.00,0.00,0.00),('1','150','771','225633',4347851,'2941','329',10464.38,11806.65,0.00,0.00,1342.27,687242.24,0.00,0.00,0.00),('1','150','771','225682',4348626,'2142','329',1058566.44,1058983.94,0.00,0.00,417.50,213760.00,0.00,0.00,0.00),('1','150','771','225682',4348627,'2941','329',11806.65,12209.29,0.00,0.00,402.64,206151.68,0.00,0.00,0.00),('1','150','771','225927',4352793,'2142','329',1058983.94,1060655.01,0.00,0.00,1671.07,909062.08,0.00,0.00,0.00),('1','150','771','225927',4352794,'2941','329',12209.29,12209.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','225966',4353334,'2142','329',1060655.01,1061883.57,0.00,0.00,1228.56,668336.64,0.00,0.00,0.00),('1','150','771','225966',4353335,'2941','329',12209.29,12477.23,0.00,0.00,267.94,145759.36,0.00,0.00,0.00),('1','150','771','226227',4358314,'2142','329',1061883.57,1063130.17,0.00,0.00,1246.60,678150.40,0.00,0.00,0.00),('1','150','771','226227',4358315,'2941','329',12477.23,13704.39,0.00,0.00,1227.16,667575.04,0.00,0.00,0.00),('1','150','771','226466',4362483,'2142','329',1063130.17,1063719.60,0.00,0.00,589.43,320649.92,0.00,0.00,0.00),('1','150','771','226466',4362484,'2941','329',13704.39,15633.68,0.00,0.00,1929.29,1049533.76,0.00,0.00,0.00),('1','150','771','226805',4368466,'2142','329',1063719.60,1065537.58,0.00,0.00,1817.98,988981.12,0.00,0.00,0.00),('1','150','771','226805',4368467,'2941','329',15633.68,15794.45,0.00,0.00,160.77,87458.88,0.00,0.00,0.00),('1','150','771','227029',4372318,'2142','329',1065537.58,1067355.76,0.00,0.00,1818.18,989089.92,0.00,0.00,0.00),('1','150','771','227029',4372319,'2941','329',15794.45,17235.73,0.00,0.00,1441.28,784056.32,0.00,0.00,0.00),('1','150','771','227255',4376253,'2142','329',1067355.76,1067420.10,0.00,0.00,64.34,35000.96,0.00,0.00,0.00),('1','150','771','227255',4376254,'2941','329',17235.73,19963.70,0.00,0.00,2727.97,1484015.68,0.00,0.00,0.00),('1','150','771','227411',4379079,'2142','329',1067420.10,1069391.22,0.00,0.00,1971.12,1072289.28,0.00,0.00,0.00),('1','150','771','227411',4379080,'2941','329',19963.70,20134.96,0.00,0.00,171.26,93165.44,0.00,0.00,0.00),('1','150','771','227599',4382484,'2142','329',1069391.22,1069743.95,0.00,0.00,352.73,191885.12,0.00,0.00,0.00),('1','150','771','227599',4382485,'2941','329',20134.96,20194.16,0.00,0.00,59.20,32204.80,0.00,0.00,0.00),('1','150','771','227660',4383395,'2142','329',1069743.95,1070011.04,0.00,0.00,267.09,145296.96,0.00,0.00,0.00),('1','150','771','227660',4383396,'2941','329',20194.16,22024.57,0.00,0.00,1830.41,995743.04,0.00,0.00,0.00),('1','150','771','227841',4386845,'2142','329',1070011.04,1072116.94,0.00,0.00,2105.90,1145609.60,0.00,0.00,0.00),('1','150','771','227841',4386846,'2941','329',22024.57,22509.56,0.00,0.00,484.99,263834.56,0.00,0.00,0.00),('1','150','771','228106',4391917,'2142','329',1072116.94,1072517.17,0.00,0.00,400.23,217725.12,0.00,0.00,0.00),('1','150','771','228106',4391918,'2941','329',22509.56,22641.59,0.00,0.00,132.03,71824.32,0.00,0.00,0.00),('1','150','771','228218',4394203,'2142','329',1072517.17,1073205.77,0.00,0.00,688.60,374598.40,0.00,0.00,0.00),('1','150','771','228218',4394204,'2941','329',22641.59,24141.22,0.00,0.00,1499.63,815798.72,0.00,0.00,0.00),('1','150','771','228339',4396408,'2142','329',1073205.77,1073857.29,0.00,0.00,651.52,354426.88,0.00,0.00,0.00),('1','150','771','228339',4396409,'2941','329',24141.22,24418.47,0.00,0.00,277.25,150824.00,0.00,0.00,0.00),('1','150','771','228398',4397341,'2142','329',1073857.29,1075220.66,0.00,0.00,1363.37,763487.20,0.00,0.00,0.00),('1','150','771','228398',4397342,'2941','329',24418.47,25075.65,0.00,0.00,657.18,368020.80,0.00,0.00,0.00),('1','150','771','228519',4399740,'2142','329',1075220.66,1075917.94,0.00,0.00,697.28,390476.80,0.00,0.00,0.00),('1','150','771','228519',4399741,'2941','329',25075.65,27533.35,0.00,0.00,2457.70,1376312.00,0.00,0.00,0.00),('1','150','771','228741',4403955,'2142','329',1075917.94,1076575.01,0.00,0.00,657.07,367959.20,0.00,0.00,0.00),('1','150','771','228741',4403956,'2941','329',27533.35,27748.38,0.00,0.00,215.03,120416.80,0.00,0.00,0.00),('1','150','771','228795',4404625,'2142','329',1076575.01,1079065.59,0.00,0.00,2490.58,1394724.80,0.00,0.00,0.00),('1','150','771','228795',4404626,'2941','329',27748.38,27796.42,0.00,0.00,48.04,26902.40,0.00,0.00,0.00),('1','150','771','228927',4407312,'2142','329',1079065.59,1082020.85,0.00,0.00,2955.26,1654945.60,0.00,0.00,0.00),('1','150','771','228927',4407313,'2941','329',27796.42,27861.77,0.00,0.00,65.35,36596.00,0.00,0.00,0.00),('1','150','771','229198',4412335,'2142','329',1082020.85,1083399.00,0.00,0.00,1378.15,771764.00,0.00,0.00,0.00),('1','150','771','229198',4412336,'2941','329',27861.77,28746.86,0.00,0.00,885.09,495650.40,0.00,0.00,0.00),('1','150','771','229423',4416380,'2142','329',1083399.00,1085990.41,0.00,0.00,2591.41,1513383.44,0.00,0.00,0.00),('1','150','771','229423',4416381,'2941','329',28746.86,28889.59,0.00,0.00,142.73,83354.32,0.00,0.00,0.00),('1','150','771','229679',4421376,'2142','329',1085990.41,1086025.08,0.00,0.00,34.67,20247.28,0.00,0.00,0.00),('1','150','771','229679',4421377,'2941','329',28889.59,29374.45,0.00,0.00,484.86,283158.24,0.00,0.00,0.00),('1','150','771','229739',4422516,'2142','329',1086025.08,1086313.35,0.00,0.00,288.27,168349.68,0.00,0.00,0.00),('1','150','771','229739',4422517,'2941','329',29374.45,30578.54,0.00,0.00,1204.09,703188.56,0.00,0.00,0.00),('1','150','771','229881',4425583,'2142','329',1086313.35,1086967.93,0.00,0.00,654.58,382274.72,0.00,0.00,0.00),('1','150','771','229881',4425584,'2941','329',30578.54,32537.60,0.00,0.00,1959.06,1144091.04,0.00,0.00,0.00),('1','150','771','230076',4429260,'2142','329',1086967.93,1087450.14,0.00,0.00,482.21,281610.64,0.00,0.00,0.00),('1','150','771','230076',4429261,'2941','329',32537.60,33745.12,0.00,0.00,1207.52,705191.68,0.00,0.00,0.00),('1','150','771','230220',4431723,'2142','329',1087450.14,1087450.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','230220',4431724,'2941','329',33745.12,34755.35,0.00,0.00,1010.23,589974.32,0.00,0.00,0.00),('1','150','771','230280',4433012,'2142','329',1087450.14,1087878.61,0.00,0.00,428.47,250226.48,0.00,0.00,0.00),('1','150','771','230280',4433013,'2941','329',34755.35,37744.16,0.00,0.00,2988.81,1745465.04,0.00,0.00,0.00),('1','150','771','230541',4437723,'2142','329',1087878.61,1087916.37,0.00,0.00,37.76,22051.84,0.00,0.00,0.00),('1','150','771','230541',4437724,'2941','329',37744.16,38500.31,0.00,0.00,756.15,441591.60,0.00,0.00,0.00),('1','150','771','230612',4439229,'2142','329',1087916.37,1088191.00,0.00,0.00,274.63,160383.92,0.00,0.00,0.00),('1','150','771','230612',4439230,'2941','329',38500.31,39724.19,0.00,0.00,1223.88,714745.92,0.00,0.00,0.00),('1','150','771','230775',4442049,'2142','329',1088191.00,1088581.91,0.00,0.00,390.91,228291.44,0.00,0.00,0.00),('1','150','771','230775',4442050,'2941','329',39724.19,41734.84,0.00,0.00,2010.65,1174219.60,0.00,0.00,0.00),('1','150','771','231080',4447098,'2142','329',1088581.91,1089121.69,0.00,0.00,539.78,315231.52,0.00,0.00,0.00),('1','150','771','231080',4447099,'2941','329',41734.84,43485.19,0.00,0.00,1750.35,1022204.40,0.00,0.00,0.00),('1','150','771','231425',4452628,'2142','329',1089121.69,1091110.91,0.00,0.00,1989.22,1161704.48,0.00,0.00,0.00),('1','150','771','231425',4452629,'2941','329',43485.19,43747.58,0.00,0.00,262.39,153235.76,0.00,0.00,0.00),('1','150','771','231670',4456787,'2142','329',1091110.91,1091254.74,0.00,0.00,143.83,83996.72,0.00,0.00,0.00),('1','150','771','231670',4456788,'2941','329',43747.58,44308.27,0.00,0.00,560.69,327442.96,0.00,0.00,0.00),('1','150','771','231737',4458310,'2142','329',1091254.74,1092858.62,0.00,0.00,1603.88,936665.92,0.00,0.00,0.00),('1','150','771','231737',4458311,'2941','329',44308.27,44365.19,0.00,0.00,56.92,33241.28,0.00,0.00,0.00),('1','150','771','231882',4460921,'2142','329',1092858.62,1095694.74,0.00,0.00,2836.12,1656294.08,0.00,0.00,0.00),('1','150','771','231882',4460922,'2941','329',44365.19,44419.82,0.00,0.00,54.63,31903.92,0.00,0.00,0.00),('1','150','771','232093',4464820,'2142','329',1095694.74,1096204.63,0.00,0.00,509.89,297775.76,0.00,0.00,0.00),('1','150','771','232093',4464821,'2941','329',44419.82,44430.94,0.00,0.00,11.12,6494.08,0.00,0.00,0.00),('1','150','771','232155',4465731,'2142','329',1096204.63,1098597.97,0.00,0.00,2393.34,1397710.56,0.00,0.00,0.00),('1','150','771','232155',4465732,'2941','329',44430.94,44499.33,0.00,0.00,68.39,39939.76,0.00,0.00,0.00),('1','150','771','232320',4468792,'2142','329',1098597.97,1100544.20,0.00,0.00,1946.23,1136598.32,0.00,0.00,0.00),('1','150','771','232320',4468793,'2941','329',44499.33,44710.53,0.00,0.00,211.20,123340.80,0.00,0.00,0.00),('1','150','771','232576',4473556,'2142','329',1100544.20,1100941.84,0.00,0.00,397.64,232221.76,0.00,0.00,0.00),('1','150','771','232576',4473557,'2941','329',44710.53,44807.78,0.00,0.00,97.25,56794.00,0.00,0.00,0.00),('1','150','771','232659',4474912,'2142','329',1100941.84,1101302.37,0.00,0.00,360.53,210849.52,0.00,0.00,0.00),('1','150','771','232659',4474913,'2941','329',44807.78,44991.51,0.00,0.00,183.73,107298.32,0.00,0.00,0.00),('1','150','771','232700',4475692,'2142','329',1101302.37,1102677.63,0.00,0.00,1375.26,825156.00,0.00,0.00,0.00),('1','150','771','232700',4475693,'2941','329',44991.51,44991.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','232836',4478125,'2142','329',1102677.63,1103809.38,0.00,0.00,1131.75,679050.00,0.00,0.00,0.00),('1','150','771','232836',4478126,'2941','329',44991.51,46322.19,0.00,0.00,1330.68,798408.00,0.00,0.00,0.00),('1','150','771','233102',4482923,'2142','329',1103809.38,1104676.78,0.00,0.00,867.40,520440.00,0.00,0.00,0.00),('1','150','771','233102',4482924,'2941','329',46322.19,46362.94,0.00,0.00,40.75,24450.00,0.00,0.00,0.00),('1','150','771','233229',4485105,'2142','329',1104676.78,1105706.64,0.00,0.00,1029.86,617916.00,0.00,0.00,0.00),('1','150','771','233229',4485106,'2941','329',46362.94,46504.62,0.00,0.00,141.68,85008.00,0.00,0.00,0.00),('1','150','771','233362',4487592,'2142','329',1105706.64,1106481.32,0.00,0.00,774.68,483400.32,0.00,0.00,0.00),('1','150','771','233362',4487593,'2941','329',46504.62,47674.04,0.00,0.00,1169.42,729718.08,0.00,0.00,0.00),('1','150','771','233593',4491885,'2142','329',1106481.32,1108361.78,0.00,0.00,1880.46,1173407.04,0.00,0.00,0.00),('1','150','771','233593',4491886,'2941','329',47674.04,47915.07,0.00,0.00,241.03,150402.72,0.00,0.00,0.00),('1','150','771','233782',4495243,'2142','329',1108361.78,1108849.19,0.00,0.00,487.41,304143.84,0.00,0.00,0.00),('1','150','771','233782',4495244,'2941','329',47915.07,47918.11,0.00,0.00,3.04,1896.96,0.00,0.00,0.00),('1','150','771','233829',4496057,'2142','329',1108849.19,1111679.50,0.00,0.00,2830.31,1766113.44,0.00,0.00,0.00),('1','150','771','233829',4496058,'2941','329',47918.11,47978.41,0.00,0.00,60.30,37627.20,0.00,0.00,0.00),('1','150','771','234036',4499732,'2142','329',1111679.50,1113028.22,0.00,0.00,1348.72,841601.28,0.00,0.00,0.00),('1','150','771','234036',4499733,'2941','329',47978.41,48014.79,0.00,0.00,36.38,22701.12,0.00,0.00,0.00),('1','150','771','234300',4504598,'2142','329',1113028.22,1114306.59,0.00,0.00,1278.37,797702.88,0.00,0.00,0.00),('1','150','771','234300',4504599,'2941','329',48014.79,48148.61,0.00,0.00,133.82,83503.68,0.00,0.00,0.00),('1','150','771','234553',4509090,'2142','329',1114306.59,1116323.55,0.00,0.00,2016.96,1258583.04,0.00,0.00,0.00),('1','150','771','234553',4509091,'2941','329',48148.61,48296.94,0.00,0.00,148.33,92557.92,0.00,0.00,0.00),('1','150','771','234821',4513732,'2142','329',1116323.55,1116591.16,0.00,0.00,267.61,166988.64,0.00,0.00,0.00),('1','150','771','234821',4513733,'2941','329',48296.94,49924.12,0.00,0.00,1627.18,1015360.32,0.00,0.00,0.00),('1','150','771','235066',4518114,'2142','329',1116591.16,1118918.21,0.00,0.00,2327.05,1452079.20,0.00,0.00,0.00),('1','150','771','235066',4518115,'2941','329',49924.12,50892.95,0.00,0.00,968.83,604549.92,0.00,0.00,0.00),('1','150','771','235300',4522111,'2142','329',1118918.21,1120584.93,0.00,0.00,1666.72,1040033.28,0.00,0.00,0.00),('1','150','771','235300',4522112,'2941','329',50892.95,50964.91,0.00,0.00,71.96,44903.04,0.00,0.00,0.00),('1','150','771','235486',4525491,'2142','329',1120584.93,1120584.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','235486',4525492,'2941','329',50964.91,51881.67,0.00,0.00,916.76,572058.24,0.00,0.00,0.00),('1','150','771','235515',4525956,'2142','329',1120584.93,1122318.74,0.00,0.00,1733.81,1081897.44,0.00,0.00,0.00),('1','150','771','235515',4525957,'2941','329',51881.67,53038.10,0.00,0.00,1156.43,721612.32,0.00,0.00,0.00),('1','150','771','235744',4530066,'2142','329',1122318.74,1123667.10,0.00,0.00,1348.36,862950.40,0.00,0.00,0.00),('1','150','771','235744',4530067,'2941','329',53038.10,53346.30,0.00,0.00,308.20,197248.00,0.00,0.00,0.00),('1','150','771','236008',4534534,'2142','329',1123667.10,1125152.39,0.00,0.00,1485.29,950585.60,0.00,0.00,0.00),('1','150','771','236008',4534535,'2941','329',53346.30,54748.80,0.00,0.00,1402.50,897600.00,0.00,0.00,0.00),('1','150','771','236231',4538655,'2142','329',1125152.39,1127114.55,0.00,0.00,1962.16,1255782.40,0.00,0.00,0.00),('1','150','771','236231',4538656,'2941','329',54748.80,55362.39,0.00,0.00,613.59,392697.60,0.00,0.00,0.00),('1','150','771','236556',4544101,'2142','329',1127114.55,1129090.30,0.00,0.00,1975.75,1264480.00,0.00,0.00,0.00),('1','150','771','236556',4544102,'2941','329',55362.39,55489.71,0.00,0.00,127.32,81484.80,0.00,0.00,0.00),('1','150','771','236730',4547123,'2142','329',1129090.30,1131290.55,0.00,0.00,2200.25,1408160.00,0.00,0.00,0.00),('1','150','771','236730',4547124,'2941','329',55489.71,55886.46,0.00,0.00,396.75,253920.00,0.00,0.00,0.00),('1','150','771','236985',4551619,'2142','329',1131290.55,1131532.11,0.00,0.00,241.56,154598.40,0.00,0.00,0.00),('1','150','771','236985',4551620,'2941','329',55886.46,55886.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','236996',4551751,'2142','329',1131532.11,1133292.57,0.00,0.00,1760.46,1126694.40,0.00,0.00,0.00),('1','150','771','236996',4551752,'2941','329',55886.46,56255.66,0.00,0.00,369.20,236288.00,0.00,0.00,0.00),('1','150','771','237159',4554852,'2142','329',1133292.57,1134910.25,0.00,0.00,1617.68,1035315.20,0.00,0.00,0.00),('1','150','771','237159',4554853,'2941','329',56255.66,56490.28,0.00,0.00,234.62,150156.80,0.00,0.00,0.00),('1','150','771','237289',4557045,'2142','329',1134910.25,1135318.47,0.00,0.00,408.22,261260.80,0.00,0.00,0.00),('1','150','771','237289',4557046,'2941','329',56490.28,57082.57,0.00,0.00,592.29,379065.60,0.00,0.00,0.00),('1','150','771','237373',4558688,'2142','329',1135318.47,1137349.79,0.00,0.00,2031.32,1300044.80,0.00,0.00,0.00),('1','150','771','237373',4558689,'2941','329',57082.57,57471.21,0.00,0.00,388.64,248729.60,0.00,0.00,0.00),('1','150','771','237596',4562702,'2142','329',1137349.79,1138267.32,0.00,0.00,917.53,601369.60,0.00,0.00,0.00),('1','150','771','237596',4562703,'2941','329',57471.21,58300.54,0.00,0.00,829.33,544040.48,0.00,0.00,0.00),('1','150','771','237867',4567106,'2142','329',1138267.32,1139132.93,0.00,0.00,865.61,555129.28,0.00,0.00,0.00),('1','150','771','237867',4567107,'2941','329',58300.54,59951.18,0.00,0.00,1650.64,1056409.60,0.00,0.00,0.00),('1','150','771','238106',4570995,'2142','329',1139132.93,1140997.62,0.00,0.00,1864.69,1193401.60,0.00,0.00,0.00),('1','150','771','238106',4570996,'2941','329',59951.18,60394.22,0.00,0.00,443.04,283545.60,0.00,0.00,0.00),('1','150','771','238343',4575176,'2142','329',1140997.62,1141172.44,0.00,0.00,174.82,111884.80,0.00,0.00,0.00),('1','150','771','238343',4575177,'2941','329',60394.22,60431.73,0.00,0.00,37.51,24006.40,0.00,0.00,0.00),('1','150','771','238450',4576866,'2142','329',1141172.44,1142913.96,0.00,0.00,1741.52,1114572.80,0.00,0.00,0.00),('1','150','771','238450',4576867,'2941','329',60431.73,60536.90,0.00,0.00,105.17,67308.80,0.00,0.00,0.00),('1','150','771','238589',4579289,'2142','329',1142913.96,1144295.87,0.00,0.00,1381.91,884422.40,0.00,0.00,0.00),('1','150','771','238589',4579290,'2941','329',60536.90,61555.37,0.00,0.00,1018.47,651820.80,0.00,0.00,0.00),('1','150','771','238905',4584746,'2142','329',1144295.87,1144898.70,0.00,0.00,602.83,385811.20,0.00,0.00,0.00),('1','150','771','238905',4584747,'2941','329',61555.37,61994.81,0.00,0.00,439.44,281241.60,0.00,0.00,0.00),('1','150','771','238926',4585178,'2142','329',1144898.70,1146149.54,0.00,0.00,1250.84,800537.60,0.00,0.00,0.00),('1','150','771','238926',4585179,'2941','329',61994.81,62072.94,0.00,0.00,78.13,50003.20,0.00,0.00,0.00),('1','150','771','239048',4587471,'2142','329',1146149.54,1148118.45,0.00,0.00,1968.91,1260102.40,0.00,0.00,0.00),('1','150','771','239048',4587472,'2941','329',62072.94,62268.73,0.00,0.00,195.79,125305.60,0.00,0.00,0.00),('1','150','771','239345',4592390,'2142','329',1148118.45,1149874.65,0.00,0.00,1756.20,1123968.00,0.00,0.00,0.00),('1','150','771','239345',4592391,'2941','329',62268.73,62458.73,0.00,0.00,190.00,121600.00,0.00,0.00,0.00),('1','150','771','239618',4597108,'2142','329',1149874.65,1151971.99,0.00,0.00,2097.34,1342297.60,0.00,0.00,0.00),('1','150','771','239618',4597109,'2941','329',62458.73,62464.98,0.00,0.00,6.25,4000.00,0.00,0.00,0.00),('1','150','771','239745',4599464,'2142','329',1151971.99,1153474.59,0.00,0.00,1502.60,961664.00,0.00,0.00,0.00),('1','150','771','239745',4599465,'2941','329',62464.98,62464.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','239753',4599558,'2142','329',1153474.59,1155210.42,0.00,0.00,1735.83,1110931.20,0.00,0.00,0.00),('1','150','771','239753',4599559,'2941','329',62464.98,62856.25,0.00,0.00,391.27,250412.80,0.00,0.00,0.00),('1','150','771','239983',4603538,'2142','329',1155210.42,1156457.14,0.00,0.00,1246.72,797900.80,0.00,0.00,0.00),('1','150','771','239983',4603539,'2941','329',62856.25,63215.71,0.00,0.00,359.46,230054.40,0.00,0.00,0.00),('1','150','771','240181',4607034,'2142','329',1156457.14,1157723.31,0.00,0.00,1266.17,810348.80,0.00,0.00,0.00),('1','150','771','240181',4607035,'2941','329',63215.71,64580.33,0.00,0.00,1364.62,873356.80,0.00,0.00,0.00),('1','150','771','240439',4611187,'2142','329',1157723.31,1159311.20,0.00,0.00,1587.89,1016249.60,0.00,0.00,0.00),('1','150','771','240439',4611188,'2941','329',64580.33,65620.84,0.00,0.00,1040.51,665926.40,0.00,0.00,0.00),('1','150','771','240676',4614829,'2142','329',1159311.20,1160808.61,0.00,0.00,1497.41,958342.40,0.00,0.00,0.00),('1','150','771','240676',4614830,'2941','329',65620.84,66273.46,0.00,0.00,652.62,417676.80,0.00,0.00,0.00),('1','150','771','240961',4619836,'2142','329',1160808.61,1162063.87,0.00,0.00,1255.26,803366.40,0.00,0.00,0.00),('1','150','771','240961',4619837,'2941','329',66273.46,67052.87,0.00,0.00,779.41,498822.40,0.00,0.00,0.00),('1','150','771','241212',4624421,'2142','329',1162063.87,1163023.49,0.00,0.00,959.62,614156.80,0.00,0.00,0.00),('1','150','771','241212',4624422,'2941','329',67052.87,67301.05,0.00,0.00,248.18,158835.20,0.00,0.00,0.00),('1','150','771','241397',4627405,'2142','329',1163023.49,1163047.06,0.00,0.00,23.57,15084.80,0.00,0.00,0.00),('1','150','771','241397',4627406,'2941','329',67301.05,67919.38,0.00,0.00,618.33,395731.20,0.00,0.00,0.00),('1','150','771','241477',4628923,'2142','329',1163047.06,1164312.40,0.00,0.00,1265.34,809817.60,0.00,0.00,0.00),('1','150','771','241477',4628924,'2941','329',67919.38,68727.23,0.00,0.00,807.85,517024.00,0.00,0.00,0.00),('1','150','771','241791',4634262,'2142','329',1164312.40,1165091.10,0.00,0.00,778.70,498368.00,0.00,0.00,0.00),('1','150','771','241791',4634263,'2941','329',68727.23,68958.97,0.00,0.00,231.74,148313.60,0.00,0.00,0.00),('1','150','771','242130',4640167,'2142','329',1165091.10,1165727.35,0.00,0.00,636.25,407200.00,0.00,0.00,0.00),('1','150','771','242130',4640168,'2941','329',68958.97,69093.26,0.00,0.00,134.29,85945.60,0.00,0.00,0.00),('1','150','771','242352',4644196,'2142','329',1165727.35,1165789.01,0.00,0.00,61.66,39462.40,0.00,0.00,0.00),('1','150','771','242352',4644197,'2941','329',69093.26,69093.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','242634',4649198,'2142','329',1165789.01,1165789.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','242634',4649199,'2941','329',69093.26,70520.57,0.00,0.00,1427.31,913478.40,0.00,0.00,0.00),('1','150','771','242672',4649742,'2142','329',1165789.01,1167052.56,0.00,0.00,1263.55,808672.00,0.00,0.00,0.00),('1','150','771','242672',4649743,'2941','329',70520.57,70692.45,0.00,0.00,171.88,110003.20,0.00,0.00,0.00),('1','150','771','243017',4655576,'2142','329',1167052.56,1167459.90,0.00,0.00,407.34,260697.60,0.00,0.00,0.00),('1','150','771','243017',4655577,'2941','329',70692.45,70692.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','243119',4657569,'2142','329',1167459.90,1169111.50,0.00,0.00,1651.60,1057024.00,0.00,0.00,0.00),('1','150','771','243119',4657570,'2941','329',70692.45,71004.95,0.00,0.00,312.50,200000.00,0.00,0.00,0.00),('1','150','771','243347',4661668,'2142','329',1169111.50,1170271.79,0.00,0.00,1160.29,742585.60,0.00,0.00,0.00),('1','150','771','243347',4661669,'2941','329',71004.95,71445.58,0.00,0.00,440.63,282003.20,0.00,0.00,0.00),('1','150','771','243580',4665607,'2142','329',1170271.79,1171242.51,0.00,0.00,970.72,621260.80,0.00,0.00,0.00),('1','150','771','243580',4665608,'2941','329',71445.58,71836.21,0.00,0.00,390.63,250003.20,0.00,0.00,0.00),('1','150','771','243815',4669737,'2142','329',1171242.51,1172250.90,0.00,0.00,1008.39,645369.60,0.00,0.00,0.00),('1','150','771','243815',4669738,'2941','329',71836.21,72292.46,0.00,0.00,456.25,292000.00,0.00,0.00,0.00),('1','150','771','244035',4673541,'2142','329',1172250.90,1172347.93,0.00,0.00,97.03,62099.20,0.00,0.00,0.00),('1','150','771','244035',4673542,'2941','329',72292.46,73505.76,0.00,0.00,1213.30,776512.00,0.00,0.00,0.00),('1','150','771','244271',4677484,'2142','329',1172347.93,1172640.07,0.00,0.00,292.14,186969.60,0.00,0.00,0.00),('1','150','771','244271',4677485,'2941','329',73505.76,73505.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','244664',4684353,'2142','329',1172640.07,1173454.68,0.00,0.00,814.61,521350.40,0.00,0.00,0.00),('1','150','771','244664',4684354,'2941','329',73505.76,73597.80,0.00,0.00,92.04,58905.60,0.00,0.00,0.00),('1','150','771','244746',4685475,'2142','329',1173454.68,1174354.73,0.00,0.00,900.05,576032.00,0.00,0.00,0.00),('1','150','771','244746',4685476,'2941','329',73597.80,74871.89,0.00,0.00,1274.09,815417.60,0.00,0.00,0.00),('1','150','771','244986',4689697,'2142','329',1174354.73,1174892.05,0.00,0.00,537.32,339586.24,0.00,0.00,0.00),('1','150','771','244986',4689698,'2941','329',74871.89,75726.81,0.00,0.00,854.92,540309.44,0.00,0.00,0.00),('1','150','771','245196',4693669,'2142','329',1174892.05,1175523.87,0.00,0.00,631.82,399310.24,0.00,0.00,0.00),('1','150','771','245196',4693670,'2941','329',75726.81,76476.81,0.00,0.00,750.00,474000.00,0.00,0.00,0.00),('1','150','771','245494',4698560,'2142','329',1175523.87,1177552.20,0.00,0.00,2028.33,1281904.56,0.00,0.00,0.00),('1','150','771','245494',4698561,'2941','329',76476.81,76968.28,0.00,0.00,491.47,310609.04,0.00,0.00,0.00),('1','150','771','245672',4701792,'2142','329',1177552.20,1178814.95,0.00,0.00,1262.75,798058.00,0.00,0.00,0.00),('1','150','771','245672',4701793,'2941','329',76968.28,77890.29,0.00,0.00,922.01,582710.32,0.00,0.00,0.00),('1','150','771','245939',4705848,'2142','329',1178814.95,1179027.25,0.00,0.00,212.30,134173.60,0.00,0.00,0.00),('1','150','771','245939',4705849,'2941','329',77890.29,77932.45,0.00,0.00,42.16,26645.12,0.00,0.00,0.00),('1','150','771','245986',4706507,'2142','329',1179027.25,1180570.82,0.00,0.00,1543.57,950839.12,0.00,0.00,0.00),('1','150','771','245986',4706508,'2941','329',77932.45,78157.40,0.00,0.00,224.95,138569.20,0.00,0.00,0.00),('1','150','771','246182',4710028,'2142','329',1180570.82,1182420.94,0.00,0.00,1850.12,1139673.92,0.00,0.00,0.00),('1','150','771','246182',4710029,'2941','329',78157.40,78546.96,0.00,0.00,389.56,239968.96,0.00,0.00,0.00),('1','150','771','246441',4714412,'2142','329',1182420.94,1183477.39,0.00,0.00,1056.45,650773.20,0.00,0.00,0.00),('1','150','771','246441',4714413,'2941','329',78546.96,78860.62,0.00,0.00,313.66,193214.56,0.00,0.00,0.00),('1','150','771','246695',4718727,'2142','329',1183477.39,1184859.90,0.00,0.00,1382.51,851626.16,0.00,0.00,0.00),('1','150','771','246695',4718728,'2941','329',78860.62,80485.70,0.00,0.00,1625.08,1001049.28,0.00,0.00,0.00),('1','150','771','246927',4722960,'2142','329',1184859.90,1186953.40,0.00,0.00,2093.50,1289596.00,0.00,0.00,0.00),('1','150','771','246927',4722961,'2941','329',80485.70,80853.32,0.00,0.00,367.62,226453.92,0.00,0.00,0.00),('1','150','771','247161',4726881,'2142','329',1186953.40,1187070.59,0.00,0.00,117.19,72189.04,0.00,0.00,0.00),('1','150','771','247161',4726882,'2941','329',80853.32,80894.24,0.00,0.00,40.92,25206.72,0.00,0.00,0.00),('1','150','771','247214',4727546,'2142','329',1187070.59,1188880.00,0.00,0.00,1809.41,1114596.56,0.00,0.00,0.00),('1','150','771','247214',4727547,'2941','329',80894.24,81399.23,0.00,0.00,504.99,311073.84,0.00,0.00,0.00),('1','150','771','247392',4730986,'2142','329',1188880.00,1190773.02,0.00,0.00,1893.02,1166100.32,0.00,0.00,0.00),('1','150','771','247392',4730987,'2941','329',81399.23,81431.85,0.00,0.00,32.62,20093.92,0.00,0.00,0.00),('1','150','771','247662',4735467,'2142','329',1190773.02,1191151.98,0.00,0.00,378.96,233439.36,0.00,0.00,0.00),('1','150','771','247662',4735468,'2941','329',81431.85,81431.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','247753',4737023,'2142','329',1191151.98,1192183.02,0.00,0.00,1031.04,610375.68,0.00,0.00,0.00),('1','150','771','247753',4737024,'2941','329',81431.85,82207.43,0.00,0.00,775.58,459143.36,0.00,0.00,0.00),('1','150','771','247897',4739520,'2142','329',1192183.02,1192762.27,0.00,0.00,579.25,342916.00,0.00,0.00,0.00),('1','150','771','247897',4739521,'2941','329',82207.43,84221.48,0.00,0.00,2014.05,1192317.60,0.00,0.00,0.00),('1','150','771','248146',4743723,'2142','329',1192762.27,1192762.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','248146',4743724,'2941','329',84221.48,84431.21,0.00,0.00,209.73,124160.16,0.00,0.00,0.00),('1','150','771','248204',4744552,'2142','329',1192762.27,1193652.50,0.00,0.00,890.23,527016.16,0.00,0.00,0.00),('1','150','771','248204',4744553,'2941','329',84431.21,84939.92,0.00,0.00,508.71,301156.32,0.00,0.00,0.00),('1','150','771','248349',4747273,'2142','329',1193652.50,1194666.02,0.00,0.00,1013.52,600003.84,0.00,0.00,0.00),('1','150','771','248349',4747274,'2941','329',84939.92,84939.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','248390',4747881,'2142','329',1194666.02,1195763.99,0.00,0.00,1097.97,649998.24,0.00,0.00,0.00),('1','150','771','248390',4747882,'2941','329',84939.92,85931.07,0.00,0.00,991.15,586760.80,0.00,0.00,0.00),('1','150','771','248532',4750304,'2142','329',1195763.99,1195871.43,0.00,0.00,107.44,63604.48,0.00,0.00,0.00),('1','150','771','248532',4750305,'2941','329',85931.07,86729.37,0.00,0.00,798.30,472593.60,0.00,0.00,0.00),('1','150','771','248632',4751892,'2142','329',1195871.43,1198483.09,0.00,0.00,2611.66,1546102.72,0.00,0.00,0.00),('1','150','771','248632',4751893,'2941','329',86729.37,86731.40,0.00,0.00,2.03,1201.76,0.00,0.00,0.00),('1','150','771','248861',4755821,'2142','329',1198483.09,1198748.16,0.00,0.00,265.07,156921.44,0.00,0.00,0.00),('1','150','771','248861',4755822,'2941','329',86731.40,88307.45,0.00,0.00,1576.05,933021.60,0.00,0.00,0.00),('1','150','771','249099',4759788,'2142','329',1198748.16,1199036.34,0.00,0.00,288.18,170602.56,0.00,0.00,0.00),('1','150','771','249099',4759789,'2941','329',88307.45,89606.69,0.00,0.00,1299.24,769150.08,0.00,0.00,0.00),('1','150','771','249337',4763878,'2142','329',1199036.34,1200773.22,0.00,0.00,1736.88,1028232.96,0.00,0.00,0.00),('1','150','771','249337',4763879,'2941','329',89606.69,89917.50,0.00,0.00,310.81,183999.52,0.00,0.00,0.00),('1','150','771','249578',4767925,'2142','329',1200773.22,1201664.81,0.00,0.00,891.59,527821.28,0.00,0.00,0.00),('1','150','771','249578',4767926,'2941','329',89917.50,90400.03,0.00,0.00,482.53,285657.76,0.00,0.00,0.00),('1','150','771','249796',4771690,'2142','329',1201664.81,1201664.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','249796',4771691,'2941','329',90400.03,90400.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','249846',4772468,'2142','329',1201664.81,1203793.49,0.00,0.00,2128.68,1260178.56,0.00,0.00,0.00),('1','150','771','249846',4772469,'2941','329',90400.03,91028.24,0.00,0.00,628.21,371900.32,0.00,0.00,0.00),('1','150','771','250094',4776527,'2142','329',1203793.49,1205488.28,0.00,0.00,1694.79,1003315.68,0.00,0.00,0.00),('1','150','771','250094',4776528,'2941','329',91028.24,91784.29,0.00,0.00,756.05,447581.60,0.00,0.00,0.00),('1','150','771','250329',4780593,'2142','329',1205488.28,1206650.18,0.00,0.00,1161.90,687844.80,0.00,0.00,0.00),('1','150','771','250329',4780594,'2941','329',91784.29,92631.73,0.00,0.00,847.44,501684.48,0.00,0.00,0.00),('1','150','771','250556',4784297,'2142','329',1206650.18,1207986.00,0.00,0.00,1335.82,790805.44,0.00,0.00,0.00),('1','150','771','250556',4784298,'2941','329',92631.73,93191.19,0.00,0.00,559.46,331200.32,0.00,0.00,0.00),('1','150','771','250794',4788412,'2142','329',1207986.00,1208328.45,0.00,0.00,342.45,202730.40,0.00,0.00,0.00),('1','150','771','250794',4788413,'2941','329',93191.19,93696.77,0.00,0.00,505.58,299303.36,0.00,0.00,0.00),('1','150','771','250889',4790102,'2142','329',1208328.45,1209118.01,0.00,0.00,789.56,467419.52,0.00,0.00,0.00),('1','150','771','250889',4790103,'2941','329',93696.77,93921.61,0.00,0.00,224.84,133105.28,0.00,0.00,0.00),('1','150','771','251019',4792500,'2142','329',1209118.01,1210630.33,0.00,0.00,1512.32,895293.44,0.00,0.00,0.00),('1','150','771','251019',4792501,'2941','329',93921.61,94310.93,0.00,0.00,389.32,230477.44,0.00,0.00,0.00),('1','150','771','251265',4796751,'2142','329',1210630.33,1211773.33,0.00,0.00,1143.00,676656.00,0.00,0.00,0.00),('1','150','771','251265',4796752,'2941','329',94310.93,94946.11,0.00,0.00,635.18,376026.56,0.00,0.00,0.00),('1','150','771','251629',4802936,'2142','329',1211773.33,1211773.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','251629',4802937,'2941','329',94946.11,95192.81,0.00,0.00,246.70,146046.40,0.00,0.00,0.00),('1','150','771','251631',4802950,'2142','329',1211773.33,1212799.66,0.00,0.00,1026.33,607587.36,0.00,0.00,0.00),('1','150','771','251631',4802951,'2941','329',95192.81,95319.86,0.00,0.00,127.05,75213.60,0.00,0.00,0.00),('1','150','771','251759',4805361,'2142','329',1212799.66,1213167.86,0.00,0.00,368.20,217974.40,0.00,0.00,0.00),('1','150','771','251759',4805362,'2941','329',95319.86,96871.48,0.00,0.00,1551.62,918559.04,0.00,0.00,0.00),('1','150','771','251989',4809324,'2142','329',1213167.86,1213827.09,0.00,0.00,659.23,390264.16,0.00,0.00,0.00),('1','150','771','251989',4809325,'2941','329',96871.48,98217.68,0.00,0.00,1346.20,796950.40,0.00,0.00,0.00),('1','150','771','252237',4813565,'2142','329',1213827.09,1214296.13,0.00,0.00,469.04,277671.68,0.00,0.00,0.00),('1','150','771','252237',4813566,'2941','329',98217.68,100340.79,0.00,0.00,2123.11,1256881.12,0.00,0.00,0.00),('1','150','771','252473',4817931,'2142','329',1214296.13,1216359.09,0.00,0.00,2062.96,1221272.32,0.00,0.00,0.00),('1','150','771','252473',4817932,'2941','329',100340.79,100340.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','252701',4821907,'2142','329',1216359.09,1216873.92,0.00,0.00,514.83,304779.36,0.00,0.00,0.00),('1','150','771','252701',4821908,'2941','329',100340.79,100594.17,0.00,0.00,253.38,150000.96,0.00,0.00,0.00),('1','150','771','252826',4823715,'2142','329',1216873.92,1217049.77,0.00,0.00,175.85,104103.20,0.00,0.00,0.00),('1','150','771','252826',4823716,'2941','329',100594.17,101440.28,0.00,0.00,846.11,500897.12,0.00,0.00,0.00),('1','150','771','252968',4826115,'2142','329',1217049.77,1218573.58,0.00,0.00,1523.81,902095.52,0.00,0.00,0.00),('1','150','771','252968',4826116,'2941','329',101440.28,102050.41,0.00,0.00,610.13,361196.96,0.00,0.00,0.00),('1','150','771','253285',4831472,'2142','329',1218573.58,1220114.84,0.00,0.00,1541.26,912425.92,0.00,0.00,0.00),('1','150','771','253285',4831473,'2941','329',102050.41,102502.53,0.00,0.00,452.12,267655.04,0.00,0.00,0.00),('1','150','771','253475',4834797,'2142','329',1220114.84,1220994.06,0.00,0.00,879.22,520498.24,0.00,0.00,0.00),('1','150','771','253475',4834798,'2941','329',102502.53,103804.18,0.00,0.00,1301.65,770576.80,0.00,0.00,0.00),('1','150','771','253712',4838786,'2142','329',1220994.06,1221450.14,0.00,0.00,456.08,269999.36,0.00,0.00,0.00),('1','150','771','253712',4838787,'2941','329',103804.18,105903.55,0.00,0.00,2099.37,1242827.04,0.00,0.00,0.00),('1','150','771','253957',4843062,'2142','329',1221450.14,1222054.36,0.00,0.00,604.22,357698.24,0.00,0.00,0.00),('1','150','771','253957',4843063,'2941','329',105903.55,105903.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','254113',4845904,'2142','329',1222054.36,1222770.84,0.00,0.00,716.48,424156.16,0.00,0.00,0.00),('1','150','771','254113',4845905,'2941','329',105903.55,105911.32,0.00,0.00,7.77,4599.84,0.00,0.00,0.00),('1','150','771','254189',4847351,'2142','329',1222770.84,1224384.62,0.00,0.00,1613.78,955357.76,0.00,0.00,0.00),('1','150','771','254189',4847352,'2941','329',105911.32,106181.02,0.00,0.00,269.70,159662.40,0.00,0.00,0.00),('1','150','771','254440',4851653,'2142','329',1224384.62,1225588.40,0.00,0.00,1203.78,712637.76,0.00,0.00,0.00),('1','150','771','254440',4851654,'2941','329',106181.02,106772.24,0.00,0.00,591.22,350002.24,0.00,0.00,0.00),('1','150','771','254685',4855983,'2142','329',1225588.40,1226343.92,0.00,0.00,755.52,447267.84,0.00,0.00,0.00),('1','150','771','254685',4855984,'2941','329',106772.24,106772.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','254824',4858189,'2142','329',1226343.92,1226446.86,0.00,0.00,102.94,60940.48,0.00,0.00,0.00),('1','150','771','254824',4858190,'2941','329',106772.24,106772.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','254828',4858214,'2142','329',1226446.86,1227235.52,0.00,0.00,788.66,466886.72,0.00,0.00,0.00),('1','150','771','254828',4858215,'2941','329',106772.24,106941.16,0.00,0.00,168.92,100000.64,0.00,0.00,0.00),('1','150','771','254971',4860549,'2142','329',1227235.52,1228560.83,0.00,0.00,1325.31,784583.52,0.00,0.00,0.00),('1','150','771','254971',4860550,'2941','329',106941.16,107568.69,0.00,0.00,627.53,371497.76,0.00,0.00,0.00),('1','150','771','255220',4864844,'2142','329',1228560.83,1229366.92,0.00,0.00,806.09,477205.28,0.00,0.00,0.00),('1','150','771','255220',4864845,'2941','329',107568.69,108678.56,0.00,0.00,1109.87,657043.04,0.00,0.00,0.00),('1','150','771','255504',4869607,'2142','329',1229366.92,1229810.59,0.00,0.00,443.67,262652.64,0.00,0.00,0.00),('1','150','771','255504',4869608,'2941','329',108678.56,108706.69,0.00,0.00,28.13,16652.96,0.00,0.00,0.00),('1','150','771','255566',4870644,'2142','329',1229810.59,1229964.37,0.00,0.00,153.78,91037.76,0.00,0.00,0.00),('1','150','771','255566',4870645,'2941','329',108706.69,110058.48,0.00,0.00,1351.79,800259.68,0.00,0.00,0.00),('1','150','771','255770',4874001,'2142','329',1229964.37,1230589.37,0.00,0.00,625.00,370000.00,0.00,0.00,0.00),('1','150','771','255770',4874002,'2941','329',110058.48,112120.64,0.00,0.00,2062.16,1220798.72,0.00,0.00,0.00),('1','150','771','256032',4878497,'2142','329',1230589.37,1230891.67,0.00,0.00,302.30,178961.60,0.00,0.00,0.00),('1','150','771','256032',4878498,'2941','329',112120.64,112395.61,0.00,0.00,274.97,162782.24,0.00,0.00,0.00),('1','150','771','256061',4879071,'2142','329',1230891.67,1231815.26,0.00,0.00,923.59,546765.28,0.00,0.00,0.00),('1','150','771','256061',4879072,'2941','329',112395.61,112561.86,0.00,0.00,166.25,98420.00,0.00,0.00,0.00),('1','150','771','256250',4881741,'2142','329',1231815.26,1233200.87,0.00,0.00,1385.61,820281.12,0.00,0.00,0.00),('1','150','771','256250',4881742,'2941','329',112561.86,113296.58,0.00,0.00,734.72,434954.24,0.00,0.00,0.00),('1','150','771','256476',4885950,'2142','329',1233200.87,1234914.54,0.00,0.00,1713.67,1014492.64,0.00,0.00,0.00),('1','150','771','256476',4885951,'2941','329',113296.58,113521.83,0.00,0.00,225.25,133348.00,0.00,0.00,0.00),('1','150','771','256675',4889314,'2142','329',1234914.54,1234914.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','256675',4889315,'2941','329',113521.83,113532.74,0.00,0.00,10.91,6458.72,0.00,0.00,0.00),('1','150','771','256753',4890273,'2142','329',1234914.54,1236143.25,0.00,0.00,1228.71,727396.32,0.00,0.00,0.00),('1','150','771','256753',4890274,'2941','329',113532.74,114158.34,0.00,0.00,625.60,370355.20,0.00,0.00,0.00),('1','150','771','256953',4894057,'2142','329',1236143.25,1237586.91,0.00,0.00,1443.66,854646.72,0.00,0.00,0.00),('1','150','771','256953',4894058,'2941','329',114158.34,114791.22,0.00,0.00,632.88,374664.96,0.00,0.00,0.00),('1','150','771','257227',4899013,'2142','329',1237586.91,1238186.73,0.00,0.00,599.82,355093.44,0.00,0.00,0.00),('1','150','771','257227',4899014,'2941','329',114791.22,115572.32,0.00,0.00,781.10,462411.20,0.00,0.00,0.00),('1','150','771','257357',4901247,'2142','329',1238186.73,1239255.33,0.00,0.00,1068.60,632611.20,0.00,0.00,0.00),('1','150','771','257357',4901248,'2941','329',115572.32,115572.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257518',4903798,'2142','329',1239255.33,1241655.43,0.00,0.00,2400.10,1365656.80,0.00,0.00,0.00),('1','150','771','257518',4903799,'2941','329',115572.32,116375.15,0.00,0.00,802.83,456007.44,0.00,0.00,0.00),('1','150','771','257519',4903800,'2142','329',1241655.43,1242219.09,0.00,0.00,563.66,320158.88,0.00,0.00,0.00),('1','150','771','257519',4903801,'2941','329',116375.15,116736.01,0.00,0.00,360.86,204968.48,0.00,0.00,0.00),('1','150','771','257520',4903802,'2142','329',1242219.09,1242683.70,0.00,0.00,464.61,263898.48,0.00,0.00,0.00),('1','150','771','257520',4903803,'2941','329',116736.01,117272.26,0.00,0.00,536.25,304590.00,0.00,0.00,0.00),('1','150','771','257521',4903804,'2142','329',1242683.70,1244240.50,0.00,0.00,1556.80,884262.40,0.00,0.00,0.00),('1','150','771','257521',4903805,'2941','329',117272.26,118291.01,0.00,0.00,1018.75,578650.00,0.00,0.00,0.00),('1','150','771','257522',4903806,'2142','329',1244240.50,1245547.34,0.00,0.00,1306.84,742285.12,0.00,0.00,0.00),('1','150','771','257522',4903807,'2941','329',118291.01,118553.84,0.00,0.00,262.83,149287.44,0.00,0.00,0.00),('1','150','771','257523',4903808,'2142','329',1245547.34,1245547.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257523',4903809,'2941','329',118553.84,119546.30,0.00,0.00,992.46,563717.28,0.00,0.00,0.00),('1','150','771','257524',4903810,'2142','329',1245547.34,1246213.40,0.00,0.00,666.06,378322.08,0.00,0.00,0.00),('1','150','771','257524',4903811,'2941','329',119546.30,121364.21,0.00,0.00,1817.91,1032572.88,0.00,0.00,0.00),('1','150','771','257525',4903812,'2142','329',1246213.40,1247672.22,0.00,0.00,1458.82,828609.76,0.00,0.00,0.00),('1','150','771','257525',4903813,'2941','329',121364.21,122377.63,0.00,0.00,1013.42,575622.56,0.00,0.00,0.00),('1','150','771','257526',4903814,'2142','329',1247672.22,1248971.55,0.00,0.00,1299.33,738019.44,0.00,0.00,0.00),('1','150','771','257526',4903815,'2941','329',122377.63,123382.95,0.00,0.00,1005.32,571021.76,0.00,0.00,0.00),('1','150','771','257527',4903816,'2142','329',1248971.55,1250723.32,0.00,0.00,1751.77,995005.36,0.00,0.00,0.00),('1','150','771','257527',4903817,'2941','329',123382.95,124388.40,0.00,0.00,1005.45,571095.60,0.00,0.00,0.00),('1','150','771','257528',4903818,'2142','329',1250723.32,1250738.11,0.00,0.00,14.79,8400.72,0.00,0.00,0.00),('1','150','771','257528',4903819,'2941','329',124388.40,124655.34,0.00,0.00,266.94,151621.92,0.00,0.00,0.00),('1','150','771','257529',4903820,'2142','329',1250738.11,1251839.40,0.00,0.00,1101.29,625532.72,0.00,0.00,0.00),('1','150','771','257529',4903821,'2941','329',124655.34,125123.79,0.00,0.00,468.45,266079.60,0.00,0.00,0.00),('1','150','771','257530',4903822,'2142','329',1251839.40,1252883.14,0.00,0.00,1043.74,592844.32,0.00,0.00,0.00),('1','150','771','257530',4903823,'2941','329',125123.79,125876.64,0.00,0.00,752.85,427618.80,0.00,0.00,0.00),('1','150','771','257531',4903824,'2142','329',1252883.14,1253924.76,0.00,0.00,1041.62,591640.16,0.00,0.00,0.00),('1','150','771','257531',4903825,'2941','329',125876.64,126509.51,0.00,0.00,632.87,359470.16,0.00,0.00,0.00),('1','150','771','257532',4903826,'2142','329',1253924.76,1254048.81,0.00,0.00,124.05,70460.40,0.00,0.00,0.00),('1','150','771','257532',4903827,'2941','329',126509.51,126700.56,0.00,0.00,191.05,108516.40,0.00,0.00,0.00),('1','150','771','257533',4903828,'2142','329',1254048.81,1254763.31,0.00,0.00,714.50,405836.00,0.00,0.00,0.00),('1','150','771','257533',4903829,'2941','329',126700.56,127178.72,0.00,0.00,478.16,271594.88,0.00,0.00,0.00),('1','150','771','257534',4903830,'2142','329',1254763.31,1255433.94,0.00,0.00,670.63,380917.84,0.00,0.00,0.00),('1','150','771','257534',4903831,'2941','329',127178.72,128986.27,0.00,0.00,1807.55,1026688.40,0.00,0.00,0.00),('1','150','771','257535',4903832,'2142','329',1255433.94,1256047.21,0.00,0.00,613.27,348337.36,0.00,0.00,0.00),('1','150','771','257535',4903833,'2941','329',128986.27,129791.18,0.00,0.00,804.91,457188.88,0.00,0.00,0.00),('1','150','771','257536',4903834,'2142','329',1256047.21,1256078.19,0.00,0.00,30.98,17596.64,0.00,0.00,0.00),('1','150','771','257536',4903835,'2941','329',129791.18,129791.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257537',4903836,'2142','329',1256078.19,1257371.93,0.00,0.00,1293.74,734844.32,0.00,0.00,0.00),('1','150','771','257537',4903837,'2941','329',129791.18,129969.78,0.00,0.00,178.60,101444.80,0.00,0.00,0.00),('1','150','771','257538',4903838,'2142','329',1257371.93,1258263.63,0.00,0.00,891.70,506485.60,0.00,0.00,0.00),('1','150','771','257538',4903839,'2941','329',129969.78,130678.77,0.00,0.00,708.99,402706.32,0.00,0.00,0.00),('1','150','771','257539',4903840,'2142','329',1258263.63,1259183.19,0.00,0.00,919.56,522310.08,0.00,0.00,0.00),('1','150','771','257539',4903841,'2941','329',130678.77,131166.68,0.00,0.00,487.91,277132.88,0.00,0.00,0.00),('1','150','771','257540',4903842,'2142','329',1259183.19,1260062.42,0.00,0.00,879.23,499402.64,0.00,0.00,0.00),('1','150','771','257540',4903843,'2941','329',131166.68,131392.65,0.00,0.00,225.97,128350.96,0.00,0.00,0.00),('1','150','771','257541',4903844,'2142','329',1260062.42,1261137.84,0.00,0.00,1075.42,610838.56,0.00,0.00,0.00),('1','150','771','257541',4903845,'2941','329',131392.65,131820.61,0.00,0.00,427.96,243081.28,0.00,0.00,0.00),('1','150','771','257542',4903846,'2142','329',1261137.84,1262241.86,0.00,0.00,1104.02,627083.36,0.00,0.00,0.00),('1','150','771','257542',4903847,'2941','329',131820.61,132164.95,0.00,0.00,344.34,195585.12,0.00,0.00,0.00),('1','150','771','257543',4903848,'2142','329',1262241.86,1263537.37,0.00,0.00,1295.51,735849.68,0.00,0.00,0.00),('1','150','771','257543',4903849,'2941','329',132164.95,132749.47,0.00,0.00,584.52,332007.36,0.00,0.00,0.00),('1','150','771','257544',4903850,'2142','329',1263537.37,1263537.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257544',4903851,'2941','329',132749.47,133116.46,0.00,0.00,366.99,208450.32,0.00,0.00,0.00),('1','150','771','257545',4903852,'2142','329',1263537.37,1265171.26,0.00,0.00,1633.89,928049.52,0.00,0.00,0.00),('1','150','771','257545',4903853,'2941','329',133116.46,133116.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257546',4903854,'2142','329',1265171.26,1266940.47,0.00,0.00,1769.21,1004911.28,0.00,0.00,0.00),('1','150','771','257546',4903855,'2941','329',133116.46,133124.47,0.00,0.00,8.01,4549.68,0.00,0.00,0.00),('1','150','771','257547',4903856,'2142','329',1266940.47,1268324.05,0.00,0.00,1383.58,785873.44,0.00,0.00,0.00),('1','150','771','257547',4903857,'2941','329',133124.47,133827.04,0.00,0.00,702.57,399059.76,0.00,0.00,0.00),('1','150','771','257548',4903858,'2142','329',1268324.05,1269125.06,0.00,0.00,801.01,454973.68,0.00,0.00,0.00),('1','150','771','257548',4903859,'2941','329',133827.04,134496.49,0.00,0.00,669.45,380247.60,0.00,0.00,0.00),('1','150','771','257549',4903860,'2142','329',1269125.06,1269125.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257549',4903861,'2941','329',134496.49,134522.66,0.00,0.00,26.17,14864.56,0.00,0.00,0.00),('1','150','771','257550',4903862,'2142','329',1269125.06,1270111.05,0.00,0.00,985.99,560042.32,0.00,0.00,0.00),('1','150','771','257550',4903863,'2941','329',134522.66,134948.15,0.00,0.00,425.49,241678.32,0.00,0.00,0.00),('1','150','771','257551',4903864,'2142','329',1270111.05,1271283.34,0.00,0.00,1172.29,665860.72,0.00,0.00,0.00),('1','150','771','257551',4903865,'2941','329',134948.15,135892.55,0.00,0.00,944.40,536419.20,0.00,0.00,0.00),('1','150','771','257552',4903866,'2142','329',1271283.34,1272101.19,0.00,0.00,817.85,464538.80,0.00,0.00,0.00),('1','150','771','257552',4903867,'2941','329',135892.55,136422.57,0.00,0.00,530.02,301051.36,0.00,0.00,0.00),('1','150','771','257553',4903868,'2142','329',1272101.19,1272275.15,0.00,0.00,173.96,98809.28,0.00,0.00,0.00),('1','150','771','257553',4903869,'2941','329',136422.57,136422.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257554',4903870,'2142','329',1272275.15,1272706.15,0.00,0.00,431.00,244808.00,0.00,0.00,0.00),('1','150','771','257554',4903871,'2941','329',136422.57,137496.10,0.00,0.00,1073.53,609765.04,0.00,0.00,0.00),('1','150','771','257555',4903872,'2142','329',1272706.15,1274022.21,0.00,0.00,1316.06,747522.08,0.00,0.00,0.00),('1','150','771','257555',4903873,'2941','329',137496.10,138099.59,0.00,0.00,603.49,342782.32,0.00,0.00,0.00),('1','150','771','257556',4903874,'2142','329',1274022.21,1275175.81,0.00,0.00,1153.60,655244.80,0.00,0.00,0.00),('1','150','771','257556',4903875,'2941','329',138099.59,138182.07,0.00,0.00,82.48,46848.64,0.00,0.00,0.00),('1','150','771','257557',4903876,'2142','329',1275175.81,1276534.63,0.00,0.00,1358.82,771809.76,0.00,0.00,0.00),('1','150','771','257557',4903877,'2941','329',138182.07,138458.70,0.00,0.00,276.63,157125.84,0.00,0.00,0.00),('1','150','771','257558',4903878,'2142','329',1276534.63,1277838.73,0.00,0.00,1304.10,740728.80,0.00,0.00,0.00),('1','150','771','257558',4903879,'2941','329',138458.70,138892.73,0.00,0.00,434.03,246529.04,0.00,0.00,0.00),('1','150','771','257559',4903880,'2142','329',1277838.73,1277941.43,0.00,0.00,102.70,58333.60,0.00,0.00,0.00),('1','150','771','257559',4903881,'2941','329',138892.73,138992.90,0.00,0.00,100.17,57046.56,0.00,0.00,0.00),('1','150','771','257560',4903882,'2142','329',1277941.43,1278851.51,0.00,0.00,910.08,527846.40,0.00,0.00,0.00),('1','150','771','257560',4903883,'2941','329',138992.90,139579.62,0.00,0.00,586.72,340297.60,0.00,0.00,0.00),('1','150','771','257561',4903884,'2142','329',1278851.51,1279714.04,0.00,0.00,862.53,500267.40,0.00,0.00,0.00),('1','150','771','257561',4903885,'2941','329',139579.62,140539.87,0.00,0.00,960.25,556945.00,0.00,0.00,0.00),('1','150','771','257562',4903886,'2142','329',1279714.04,1281241.43,0.00,0.00,1527.39,885886.20,0.00,0.00,0.00),('1','150','771','257562',4903887,'2941','329',140539.87,141254.25,0.00,0.00,714.38,414340.40,0.00,0.00,0.00),('1','150','771','257563',4903888,'2142','329',1281241.43,1282511.77,0.00,0.00,1270.34,736797.20,0.00,0.00,0.00),('1','150','771','257563',4903889,'2941','329',141254.25,141254.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257564',4903890,'2142','329',1282511.77,1284566.28,0.00,0.00,2054.51,1191615.80,0.00,0.00,0.00),('1','150','771','257564',4903891,'2941','329',141254.25,141818.50,0.00,0.00,564.25,327265.00,0.00,0.00,0.00),('1','150','771','257565',4903892,'2142','329',1284566.28,1285651.02,0.00,0.00,1084.74,629149.20,0.00,0.00,0.00),('1','150','771','257565',4903893,'2941','329',141818.50,142523.72,0.00,0.00,705.22,409027.60,0.00,0.00,0.00),('1','150','771','257566',4903894,'2142','329',1285651.02,1286584.49,0.00,0.00,933.47,597420.80,0.00,0.00,0.00),('1','150','771','257566',4903895,'2941','329',142523.72,142937.28,0.00,0.00,413.56,264678.40,0.00,0.00,0.00),('1','150','771','257567',4903896,'2142','329',1286584.49,1288102.56,0.00,0.00,1518.07,971564.80,0.00,0.00,0.00),('1','150','771','257567',4903897,'2941','329',142937.28,143179.32,0.00,0.00,242.04,154905.60,0.00,0.00,0.00),('1','150','771','257568',4903898,'2142','329',1288102.56,1289370.91,0.00,0.00,1268.35,811744.00,0.00,0.00,0.00),('1','150','771','257568',4903899,'2941','329',143179.32,143510.96,0.00,0.00,331.64,214809.60,0.00,0.00,0.00),('1','150','771','257569',4903900,'2142','329',1289370.91,1290412.56,0.00,0.00,1041.65,666656.00,0.00,0.00,0.00),('1','150','771','257569',4903901,'2941','329',143510.96,143995.25,0.00,0.00,484.29,309945.60,0.00,0.00,0.00),('1','150','771','257570',4903902,'2142','329',1290412.56,1290688.85,0.00,0.00,276.29,176825.60,0.00,0.00,0.00),('1','150','771','257570',4903903,'2941','329',143995.25,144295.08,0.00,0.00,299.83,191891.20,0.00,0.00,0.00),('1','150','771','257571',4903904,'2142','329',1290688.85,1292028.90,0.00,0.00,1340.05,857632.00,0.00,0.00,0.00),('1','150','771','257571',4903905,'2941','329',144295.08,145001.59,0.00,0.00,706.51,452166.40,0.00,0.00,0.00),('1','150','771','257572',4903906,'2142','329',1292028.90,1293013.25,0.00,0.00,984.35,629984.00,0.00,0.00,0.00),('1','150','771','257572',4903907,'2941','329',145001.59,145344.93,0.00,0.00,343.34,219737.60,0.00,0.00,0.00),('1','150','771','257573',4903908,'2142','329',1293013.25,1294146.09,0.00,0.00,1132.84,770331.20,0.00,0.00,0.00),('1','150','771','257573',4903909,'2941','329',145344.93,145809.20,0.00,0.00,464.27,315703.60,0.00,0.00,0.00),('1','150','771','257574',4903910,'2142','329',1294146.09,1295140.63,0.00,0.00,994.54,676287.20,0.00,0.00,0.00),('1','150','771','257574',4903911,'2941','329',145809.20,146143.12,0.00,0.00,333.92,227065.60,0.00,0.00,0.00),('1','150','771','257575',4903912,'2142','329',1295140.63,1295712.47,0.00,0.00,571.84,388851.20,0.00,0.00,0.00),('1','150','771','257575',4903913,'2941','329',146143.12,146934.93,0.00,0.00,791.81,538430.80,0.00,0.00,0.00),('1','150','771','257576',4903914,'2142','329',1295712.47,1296449.29,0.00,0.00,736.82,485831.20,0.00,0.00,0.00),('1','150','771','257576',4903915,'2941','329',146934.93,147538.72,0.00,0.00,603.79,397003.76,0.00,0.00,0.00),('1','150','771','257577',4903916,'2142','329',1296449.29,1296986.36,0.00,0.00,537.07,352317.92,0.00,0.00,0.00),('1','150','771','257577',4903917,'2941','329',147538.72,148006.24,0.00,0.00,467.52,306693.12,0.00,0.00,0.00),('1','150','771','257578',4903918,'2142','329',1296986.36,1297277.14,0.00,0.00,290.78,190751.68,0.00,0.00,0.00),('1','150','771','257578',4903919,'2941','329',148006.24,148155.44,0.00,0.00,149.20,97875.20,0.00,0.00,0.00),('1','150','771','257579',4903920,'2142','329',1297277.14,1298380.93,0.00,0.00,1103.79,724086.24,0.00,0.00,0.00),('1','150','771','257579',4903921,'2941','329',148155.44,148670.18,0.00,0.00,514.74,337669.44,0.00,0.00,0.00),('1','150','771','257580',4903922,'2142','329',1298380.93,1299108.89,0.00,0.00,727.96,477611.76,0.00,0.00,0.00),('1','150','771','257580',4903923,'2941','329',148670.18,149352.48,0.00,0.00,682.30,447588.80,0.00,0.00,0.00),('1','150','771','257581',4903924,'2142','329',1299108.89,1299714.06,0.00,0.00,605.17,396991.52,0.00,0.00,0.00),('1','150','771','257581',4903925,'2941','329',149352.48,149991.48,0.00,0.00,639.00,419184.00,0.00,0.00,0.00),('1','150','771','257582',4903926,'2142','329',1299714.06,1300006.90,0.00,0.00,292.84,192103.04,0.00,0.00,0.00),('1','150','771','257582',4903927,'2941','329',149991.48,150247.41,0.00,0.00,255.93,167890.08,0.00,0.00,0.00),('1','150','771','257583',4903928,'2142','329',1300006.90,1300301.36,0.00,0.00,294.46,193165.76,0.00,0.00,0.00),('1','150','771','257583',4903929,'2941','329',150247.41,150443.43,0.00,0.00,196.02,128589.12,0.00,0.00,0.00),('1','150','771','257584',4903930,'2142','329',1300301.36,1301131.12,0.00,0.00,829.76,544322.56,0.00,0.00,0.00),('1','150','771','257584',4903931,'2941','329',150443.43,151077.11,0.00,0.00,633.68,415694.08,0.00,0.00,0.00),('1','150','771','257585',4903932,'2142','329',1301131.12,1301850.72,0.00,0.00,719.60,472057.60,0.00,0.00,0.00),('1','150','771','257585',4903933,'2941','329',151077.11,151731.12,0.00,0.00,654.01,429030.56,0.00,0.00,0.00),('1','150','771','257586',4903934,'2142','329',1301850.72,1302787.22,0.00,0.00,936.50,614344.00,0.00,0.00,0.00),('1','150','771','257586',4903935,'2941','329',151731.12,152568.99,0.00,0.00,837.87,549642.72,0.00,0.00,0.00),('1','150','771','257587',4903936,'2142','329',1302787.22,1302966.03,0.00,0.00,178.81,117299.36,0.00,0.00,0.00),('1','150','771','257587',4903937,'2941','329',152568.99,152740.69,0.00,0.00,171.70,112635.20,0.00,0.00,0.00),('1','150','771','257588',4903938,'2142','329',1302966.03,1303167.57,0.00,0.00,201.54,132210.24,0.00,0.00,0.00),('1','150','771','257588',4903939,'2941','329',152740.69,152740.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257589',4903940,'2142','329',1303167.57,1303869.30,0.00,0.00,701.73,482790.24,0.00,0.00,0.00),('1','150','771','257589',4903941,'2941','329',152740.69,153237.43,0.00,0.00,496.74,341757.12,0.00,0.00,0.00),('1','150','771','257590',4903942,'2142','329',1303869.30,1304725.23,0.00,0.00,855.93,588879.84,0.00,0.00,0.00),('1','150','771','257590',4903943,'2941','329',153237.43,153800.28,0.00,0.00,562.85,387240.80,0.00,0.00,0.00),('1','150','771','257591',4903944,'2142','329',1304725.23,1305675.70,0.00,0.00,950.47,653923.36,0.00,0.00,0.00),('1','150','771','257591',4903945,'2941','329',153800.28,154366.48,0.00,0.00,566.20,389545.60,0.00,0.00,0.00),('1','150','771','257592',4903946,'2142','329',1305675.70,1306381.41,0.00,0.00,705.71,485528.48,0.00,0.00,0.00),('1','150','771','257592',4903947,'2941','329',154366.48,154523.16,0.00,0.00,156.68,107795.84,0.00,0.00,0.00),('1','150','771','257593',4903948,'2142','329',1306381.41,1306945.78,0.00,0.00,564.37,388286.56,0.00,0.00,0.00),('1','150','771','257593',4903949,'2941','329',154523.16,154882.16,0.00,0.00,359.00,246992.00,0.00,0.00,0.00),('1','150','771','257594',4903950,'2142','329',1306945.78,1308751.55,0.00,0.00,1805.77,1199031.28,0.00,0.00,0.00),('1','150','771','257594',4903951,'2941','329',154882.16,155338.79,0.00,0.00,456.63,303202.32,0.00,0.00,0.00),('1','150','771','257595',4903952,'2142','329',1308751.55,1309743.99,0.00,0.00,992.44,658980.16,0.00,0.00,0.00),('1','150','771','257595',4903953,'2941','329',155338.79,155883.85,0.00,0.00,545.06,361919.84,0.00,0.00,0.00),('1','150','771','257596',4903954,'2142','329',1309743.99,1311148.44,0.00,0.00,1404.45,932554.80,0.00,0.00,0.00),('1','150','771','257596',4903955,'2941','329',155883.85,157740.51,0.00,0.00,1856.66,1232822.24,0.00,0.00,0.00),('1','150','771','257597',4903956,'2142','329',1311148.44,1312514.57,0.00,0.00,1366.13,907110.32,0.00,0.00,0.00),('1','150','771','257597',4903957,'2941','329',157740.51,158256.44,0.00,0.00,515.93,342577.52,0.00,0.00,0.00),('1','150','771','257598',4903958,'2142','329',1312514.57,1313759.77,0.00,0.00,1245.20,826812.80,0.00,0.00,0.00),('1','150','771','257598',4903959,'2941','329',158256.44,158787.98,0.00,0.00,531.54,352942.56,0.00,0.00,0.00),('1','150','771','257599',4903960,'2142','329',1313759.77,1315238.92,0.00,0.00,1479.15,982155.60,0.00,0.00,0.00),('1','150','771','257599',4903961,'2941','329',158787.98,159431.58,0.00,0.00,643.60,427350.40,0.00,0.00,0.00),('1','150','771','257600',4903962,'2142','329',1315238.92,1316331.50,0.00,0.00,1092.58,725473.12,0.00,0.00,0.00),('1','150','771','257600',4903963,'2941','329',159431.58,160011.10,0.00,0.00,579.52,384801.28,0.00,0.00,0.00),('1','150','771','257601',4903964,'2142','329',1316331.50,1317472.19,0.00,0.00,1140.69,757418.16,0.00,0.00,0.00),('1','150','771','257601',4903965,'2941','329',160011.10,160524.95,0.00,0.00,513.85,341196.40,0.00,0.00,0.00),('1','150','771','257602',4903966,'2142','329',1317472.19,1318713.64,0.00,0.00,1241.45,824322.80,0.00,0.00,0.00),('1','150','771','257602',4903967,'2941','329',160524.95,161247.92,0.00,0.00,722.97,480052.08,0.00,0.00,0.00),('1','150','771','257603',4903968,'2142','329',1318713.64,1319714.35,0.00,0.00,1000.71,664471.44,0.00,0.00,0.00),('1','150','771','257603',4903969,'2941','329',161247.92,161985.74,0.00,0.00,737.82,489912.48,0.00,0.00,0.00),('1','150','771','257604',4903970,'2142','329',1319714.35,1321333.78,0.00,0.00,1619.43,1075301.52,0.00,0.00,0.00),('1','150','771','257604',4903971,'2941','329',161985.74,162802.16,0.00,0.00,816.42,542102.88,0.00,0.00,0.00),('1','150','771','257605',4903972,'2142','329',1321333.78,1322678.23,0.00,0.00,1344.45,892714.80,0.00,0.00,0.00),('1','150','771','257605',4903973,'2941','329',162802.16,163420.89,0.00,0.00,618.73,410836.72,0.00,0.00,0.00),('1','150','771','257606',4903974,'2142','329',1322678.23,1323483.40,0.00,0.00,805.17,534632.88,0.00,0.00,0.00),('1','150','771','257606',4903975,'2941','329',163420.89,163634.28,0.00,0.00,213.39,141690.96,0.00,0.00,0.00),('1','150','771','257607',4903976,'2142','329',1323483.40,1324140.24,0.00,0.00,656.84,436141.76,0.00,0.00,0.00),('1','150','771','257607',4903977,'2941','329',163634.28,163634.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257608',4903978,'2142','329',1324140.24,1325224.69,0.00,0.00,1084.45,720074.80,0.00,0.00,0.00),('1','150','771','257608',4903979,'2941','329',163634.28,164186.13,0.00,0.00,551.85,366428.40,0.00,0.00,0.00),('1','150','771','257609',4903980,'2142','329',1325224.69,1326462.04,0.00,0.00,1237.35,821600.40,0.00,0.00,0.00),('1','150','771','257609',4903981,'2941','329',164186.13,165169.70,0.00,0.00,983.57,653090.48,0.00,0.00,0.00),('1','150','771','257610',4903982,'2142','329',1326462.04,1327068.98,0.00,0.00,606.94,403008.16,0.00,0.00,0.00),('1','150','771','257610',4903983,'2941','329',165169.70,165296.52,0.00,0.00,126.82,84208.48,0.00,0.00,0.00),('1','150','771','257611',4903984,'2142','329',1327068.98,1327714.39,0.00,0.00,645.41,428552.24,0.00,0.00,0.00),('1','150','771','257611',4903985,'2941','329',165296.52,165876.42,0.00,0.00,579.90,385053.60,0.00,0.00,0.00),('1','150','771','257612',4903986,'2142','329',1327714.39,1328935.19,0.00,0.00,1220.80,810611.20,0.00,0.00,0.00),('1','150','771','257612',4903987,'2941','329',165876.42,166727.23,0.00,0.00,850.81,564937.84,0.00,0.00,0.00),('1','150','771','257613',4903988,'2142','329',1328935.19,1330096.48,0.00,0.00,1161.29,771096.56,0.00,0.00,0.00),('1','150','771','257613',4903989,'2941','329',166727.23,167101.14,0.00,0.00,373.91,248276.24,0.00,0.00,0.00),('1','150','771','257614',4903990,'2142','329',1330096.48,1331601.93,0.00,0.00,1505.45,999618.80,0.00,0.00,0.00),('1','150','771','257614',4903991,'2941','329',167101.14,167709.61,0.00,0.00,608.47,404024.08,0.00,0.00,0.00),('1','150','771','257615',4903992,'2142','329',1331601.93,1332647.17,0.00,0.00,1045.24,694039.36,0.00,0.00,0.00),('1','150','771','257615',4903993,'2941','329',167709.61,168012.56,0.00,0.00,302.95,201158.80,0.00,0.00,0.00),('1','150','771','257616',4903994,'2142','329',1332647.17,1333508.69,0.00,0.00,861.52,572049.28,0.00,0.00,0.00),('1','150','771','257616',4903995,'2941','329',168012.56,168357.00,0.00,0.00,344.44,228708.16,0.00,0.00,0.00),('1','150','771','257617',4903996,'2142','329',1333508.69,1334442.27,0.00,0.00,933.58,619897.12,0.00,0.00,0.00),('1','150','771','257617',4903997,'2941','329',168357.00,169307.20,0.00,0.00,950.20,630932.80,0.00,0.00,0.00),('1','150','771','257618',4903998,'2142','329',1334442.27,1335728.81,0.00,0.00,1286.54,854262.56,0.00,0.00,0.00),('1','150','771','257618',4903999,'2941','329',169307.20,169664.33,0.00,0.00,357.13,237134.32,0.00,0.00,0.00),('1','150','771','257619',4904000,'2142','329',1335728.81,1335972.78,0.00,0.00,243.97,161996.08,0.00,0.00,0.00),('1','150','771','257619',4904001,'2941','329',169664.33,169771.10,0.00,0.00,106.77,70895.28,0.00,0.00,0.00),('1','150','771','257620',4904002,'2142','329',1335972.78,1336824.66,0.00,0.00,851.88,565648.32,0.00,0.00,0.00),('1','150','771','257620',4904003,'2941','329',169771.10,170685.81,0.00,0.00,914.71,607367.44,0.00,0.00,0.00),('1','150','771','257621',4904004,'2142','329',1336824.66,1338211.83,0.00,0.00,1387.17,921080.88,0.00,0.00,0.00),('1','150','771','257621',4904005,'2941','329',170685.81,171348.96,0.00,0.00,663.15,440331.60,0.00,0.00,0.00),('1','150','771','257622',4904006,'2142','329',1338211.83,1338925.96,0.00,0.00,714.13,474182.32,0.00,0.00,0.00),('1','150','771','257622',4904007,'2941','329',171348.96,171935.57,0.00,0.00,586.61,389509.04,0.00,0.00,0.00),('1','150','771','257623',4904008,'2142','329',1338925.96,1339944.16,0.00,0.00,1018.20,676084.80,0.00,0.00,0.00),('1','150','771','257623',4904009,'2941','329',171935.57,172646.65,0.00,0.00,711.08,472157.12,0.00,0.00,0.00),('1','150','771','257624',4904010,'2142','329',1339944.16,1340644.30,0.00,0.00,700.14,464892.96,0.00,0.00,0.00),('1','150','771','257624',4904011,'2941','329',172646.65,172955.89,0.00,0.00,309.24,205335.36,0.00,0.00,0.00),('1','150','771','257625',4904012,'2142','329',1340644.30,1342044.26,0.00,0.00,1399.96,929573.44,0.00,0.00,0.00),('1','150','771','257625',4904013,'2941','329',172955.89,173308.35,0.00,0.00,352.46,234033.44,0.00,0.00,0.00),('1','150','771','257626',4904014,'2142','329',1342044.26,1343649.67,0.00,0.00,1605.41,1065992.24,0.00,0.00,0.00),('1','150','771','257626',4904015,'2941','329',173308.35,173609.51,0.00,0.00,301.16,199970.24,0.00,0.00,0.00),('1','150','771','257627',4904016,'2142','329',1343649.67,1346858.77,0.00,0.00,3209.10,2130842.40,0.00,0.00,0.00),('1','150','771','257627',4904017,'2941','329',173609.51,173992.11,0.00,0.00,382.60,254046.40,0.00,0.00,0.00),('1','150','771','257628',4904018,'2142','329',1346858.77,1347484.67,0.00,0.00,625.90,415597.60,0.00,0.00,0.00),('1','150','771','257628',4904019,'2941','329',173992.11,175144.00,0.00,0.00,1151.89,764854.96,0.00,0.00,0.00),('1','150','771','257629',4904020,'2142','329',1347484.67,1348028.10,0.00,0.00,543.43,360837.52,0.00,0.00,0.00),('1','150','771','257629',4904021,'2941','329',175144.00,175307.85,0.00,0.00,163.85,108796.40,0.00,0.00,0.00),('1','150','771','257630',4904022,'2142','329',1348028.10,1348230.90,0.00,0.00,202.80,134659.20,0.00,0.00,0.00),('1','150','771','257630',4904023,'2941','329',175307.85,175842.70,0.00,0.00,534.85,355140.40,0.00,0.00,0.00),('1','150','771','257631',4904024,'2142','329',1348230.90,1349497.90,0.00,0.00,1267.00,841288.00,0.00,0.00,0.00),('1','150','771','257631',4904025,'2941','329',175842.70,176372.28,0.00,0.00,529.58,351641.12,0.00,0.00,0.00),('1','150','771','257632',4904026,'2142','329',1349497.90,1350864.26,0.00,0.00,1366.36,907263.04,0.00,0.00,0.00),('1','150','771','257632',4904027,'2941','329',176372.28,176825.00,0.00,0.00,452.72,300606.08,0.00,0.00,0.00),('1','150','771','257633',4904028,'2142','329',1350864.26,1350905.61,0.00,0.00,41.35,27456.40,0.00,0.00,0.00),('1','150','771','257633',4904029,'2941','329',176825.00,177179.30,0.00,0.00,354.30,235255.20,0.00,0.00,0.00),('1','150','771','257634',4904030,'2142','329',1350905.61,1352209.35,0.00,0.00,1303.74,865683.36,0.00,0.00,0.00),('1','150','771','257634',4904031,'2941','329',177179.30,177321.40,0.00,0.00,142.10,94354.40,0.00,0.00,0.00),('1','150','771','257635',4904032,'2142','329',1352209.35,1352855.03,0.00,0.00,645.68,428731.52,0.00,0.00,0.00),('1','150','771','257635',4904033,'2941','329',177321.40,178294.91,0.00,0.00,973.51,646410.64,0.00,0.00,0.00),('1','150','771','257636',4904034,'2142','329',1352855.03,1354364.76,0.00,0.00,1509.73,1002460.72,0.00,0.00,0.00),('1','150','771','257636',4904035,'2941','329',178294.91,178661.60,0.00,0.00,366.69,243482.16,0.00,0.00,0.00),('1','150','771','257637',4904036,'2142','329',1354364.76,1355811.06,0.00,0.00,1446.30,960343.20,0.00,0.00,0.00),('1','150','771','257637',4904037,'2941','329',178661.60,178944.14,0.00,0.00,282.54,187606.56,0.00,0.00,0.00),('1','150','771','257638',4904038,'2142','329',1355811.06,1356988.77,0.00,0.00,1177.71,781999.44,0.00,0.00,0.00),('1','150','771','257638',4904039,'2941','329',178944.14,179120.50,0.00,0.00,176.36,117103.04,0.00,0.00,0.00),('1','150','771','257639',4904040,'2142','329',1356988.77,1357048.17,0.00,0.00,59.40,39441.60,0.00,0.00,0.00),('1','150','771','257639',4904041,'2941','329',179120.50,179120.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257640',4904042,'2142','329',1357048.17,1357667.25,0.00,0.00,619.08,411069.12,0.00,0.00,0.00),('1','150','771','257640',4904043,'2941','329',179120.50,179463.81,0.00,0.00,343.31,227957.84,0.00,0.00,0.00),('1','150','771','257641',4904044,'2142','329',1357667.25,1358691.37,0.00,0.00,1024.12,680015.68,0.00,0.00,0.00),('1','150','771','257641',4904045,'2941','329',179463.81,179990.63,0.00,0.00,526.82,349808.48,0.00,0.00,0.00),('1','150','771','257642',4904046,'2142','329',1358691.37,1359939.75,0.00,0.00,1248.38,828924.32,0.00,0.00,0.00),('1','150','771','257642',4904047,'2941','329',179990.63,180780.18,0.00,0.00,789.55,524261.20,0.00,0.00,0.00),('1','150','771','257643',4904048,'2142','329',1359939.75,1360135.74,0.00,0.00,195.99,130137.36,0.00,0.00,0.00),('1','150','771','257643',4904049,'2941','329',180780.18,180780.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257644',4904050,'2142','329',1360135.74,1361306.59,0.00,0.00,1170.85,796178.00,0.00,0.00,0.00),('1','150','771','257644',4904051,'2941','329',180780.18,181502.54,0.00,0.00,722.36,491204.80,0.00,0.00,0.00),('1','150','771','257645',4904052,'2142','329',1361306.59,1362435.11,0.00,0.00,1128.52,767393.60,0.00,0.00,0.00),('1','150','771','257645',4904053,'2941','329',181502.54,182179.07,0.00,0.00,676.53,460040.40,0.00,0.00,0.00),('1','150','771','257646',4904054,'2142','329',1362435.11,1362711.40,0.00,0.00,276.29,187877.20,0.00,0.00,0.00),('1','150','771','257646',4904055,'2941','329',182179.07,182542.89,0.00,0.00,363.82,247397.60,0.00,0.00,0.00),('1','150','771','257647',4904056,'2142','329',1362711.40,1363118.77,0.00,0.00,407.37,277011.60,0.00,0.00,0.00),('1','150','771','257647',4904057,'2941','329',182542.89,183399.52,0.00,0.00,856.63,582508.40,0.00,0.00,0.00),('1','150','771','257648',4904058,'2142','329',1363118.77,1364165.21,0.00,0.00,1046.44,711579.20,0.00,0.00,0.00),('1','150','771','257648',4904059,'2941','329',183399.52,184018.79,0.00,0.00,619.27,421103.60,0.00,0.00,0.00),('1','150','771','257649',4904060,'2142','329',1364165.21,1365314.06,0.00,0.00,1148.85,781218.00,0.00,0.00,0.00),('1','150','771','257649',4904061,'2941','329',184018.79,185435.53,0.00,0.00,1416.74,963383.20,0.00,0.00,0.00),('1','150','771','257650',4904062,'2142','329',1365314.06,1366974.81,0.00,0.00,1660.75,1129310.00,0.00,0.00,0.00),('1','150','771','257650',4904063,'2941','329',185435.53,186235.31,0.00,0.00,799.78,543850.40,0.00,0.00,0.00),('1','150','771','257651',4904064,'2142','329',1366974.81,1367349.59,0.00,0.00,374.78,254850.40,0.00,0.00,0.00),('1','150','771','257651',4904065,'2941','329',186235.31,186384.76,0.00,0.00,149.45,101626.00,0.00,0.00,0.00),('1','150','771','257652',4904066,'2142','329',1367349.59,1368325.74,0.00,0.00,976.15,663782.00,0.00,0.00,0.00),('1','150','771','257652',4904067,'2941','329',186384.76,186888.91,0.00,0.00,504.15,342822.00,0.00,0.00,0.00),('1','150','771','257653',4904068,'2142','329',1368325.74,1369554.89,0.00,0.00,1229.15,835822.00,0.00,0.00,0.00),('1','150','771','257653',4904069,'2941','329',186888.91,187467.57,0.00,0.00,578.66,393488.80,0.00,0.00,0.00),('1','150','771','257654',4904070,'2142','329',1369554.89,1370419.13,0.00,0.00,864.24,587683.20,0.00,0.00,0.00),('1','150','771','257654',4904071,'2941','329',187467.57,188292.41,0.00,0.00,824.84,560891.20,0.00,0.00,0.00),('1','150','771','257655',4904072,'2142','329',1370419.13,1370540.02,0.00,0.00,120.89,82205.20,0.00,0.00,0.00),('1','150','771','257655',4904073,'2941','329',188292.41,188526.69,0.00,0.00,234.28,159310.40,0.00,0.00,0.00),('1','150','771','257656',4904074,'2142','329',1370540.02,1371354.46,0.00,0.00,814.44,586396.80,0.00,0.00,0.00),('1','150','771','257656',4904075,'2941','329',188526.69,188748.54,0.00,0.00,221.85,159732.00,0.00,0.00,0.00),('1','150','771','257657',4904076,'2142','329',1371354.46,1372306.06,0.00,0.00,951.60,685152.00,0.00,0.00,0.00),('1','150','771','257657',4904077,'2941','329',188748.54,189347.31,0.00,0.00,598.77,431114.40,0.00,0.00,0.00),('1','150','771','257658',4904078,'2142','329',1372306.06,1373077.50,0.00,0.00,771.44,555436.80,0.00,0.00,0.00),('1','150','771','257658',4904079,'2941','329',189347.31,190113.38,0.00,0.00,766.07,551570.40,0.00,0.00,0.00),('1','150','771','257659',4904080,'2142','329',1373077.50,1373993.59,0.00,0.00,916.09,659584.80,0.00,0.00,0.00),('1','150','771','257659',4904081,'2941','329',190113.38,190483.40,0.00,0.00,370.02,266414.40,0.00,0.00,0.00),('1','150','771','257660',4904082,'2142','329',1373993.59,1374699.00,0.00,0.00,705.41,507895.20,0.00,0.00,0.00),('1','150','771','257660',4904083,'2941','329',190483.40,190753.15,0.00,0.00,269.75,194220.00,0.00,0.00,0.00),('1','150','771','257661',4904084,'2142','329',1374699.00,1376246.84,0.00,0.00,1547.84,1114444.80,0.00,0.00,0.00),('1','150','771','257661',4904085,'2941','329',190753.15,191490.00,0.00,0.00,736.85,530532.00,0.00,0.00,0.00),('1','150','771','257662',4904086,'2142','329',1376246.84,1377062.65,0.00,0.00,815.81,587383.20,0.00,0.00,0.00),('1','150','771','257662',4904087,'2941','329',191490.00,192085.17,0.00,0.00,595.17,428522.40,0.00,0.00,0.00),('1','150','771','257663',4904088,'2142','329',1377062.65,1377324.17,0.00,0.00,261.52,198755.20,0.00,0.00,0.00),('1','150','771','257663',4904089,'2941','329',192085.17,192085.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257664',4904090,'2142','329',1377324.17,1378496.84,0.00,0.00,1172.67,891229.20,0.00,0.00,0.00),('1','150','771','257664',4904091,'2941','329',192085.17,192324.94,0.00,0.00,239.77,182225.20,0.00,0.00,0.00),('1','150','771','257665',4904092,'2142','329',1378496.84,1379931.97,0.00,0.00,1435.13,1090698.80,0.00,0.00,0.00),('1','150','771','257665',4904093,'2941','329',192324.94,193031.82,0.00,0.00,706.88,537228.80,0.00,0.00,0.00),('1','150','771','257666',4904094,'2142','329',1379931.97,1381220.52,0.00,0.00,1288.55,979298.00,0.00,0.00,0.00),('1','150','771','257666',4904095,'2941','329',193031.82,193453.15,0.00,0.00,421.33,320210.80,0.00,0.00,0.00),('1','150','771','257667',4904096,'2142','329',1381220.52,1382784.33,0.00,0.00,1563.81,1188495.60,0.00,0.00,0.00),('1','150','771','257667',4904097,'2941','329',193453.15,193785.97,0.00,0.00,332.82,252943.20,0.00,0.00,0.00),('1','150','771','257668',4904098,'2142','329',1382784.33,1384509.80,0.00,0.00,1725.47,1311357.20,0.00,0.00,0.00),('1','150','771','257668',4904099,'2941','329',193785.97,194258.16,0.00,0.00,472.19,358864.40,0.00,0.00,0.00),('1','150','771','257669',4904100,'2142','329',1384509.80,1385532.90,0.00,0.00,1023.10,777556.00,0.00,0.00,0.00),('1','150','771','257669',4904101,'2941','329',194258.16,194258.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257670',4904102,'2142','329',1385532.90,1386988.11,0.00,0.00,1455.21,1105959.60,0.00,0.00,0.00),('1','150','771','257670',4904103,'2941','329',194258.16,194503.19,0.00,0.00,245.03,186222.80,0.00,0.00,0.00),('1','150','771','257671',4904104,'2142','329',1386988.11,1387626.48,0.00,0.00,638.37,485285.80,0.00,0.00,0.00),('1','150','771','257671',4904105,'2941','329',194503.19,195204.87,0.00,0.00,701.68,533276.80,0.00,0.00,0.00),('1','150','771','257672',4904106,'2142','329',1387626.48,1388687.34,0.00,0.00,1060.86,806253.60,0.00,0.00,0.00),('1','150','771','257672',4904107,'2941','329',195204.87,195867.34,0.00,0.00,662.47,503477.20,0.00,0.00,0.00),('1','150','771','257673',4904108,'2142','329',1388687.34,1389910.20,0.00,0.00,1222.86,929373.60,0.00,0.00,0.00),('1','150','771','257673',4904109,'2941','329',195867.34,196098.34,0.00,0.00,231.00,175560.00,0.00,0.00,0.00),('1','150','771','257674',4904110,'2142','329',1389910.20,1390146.01,0.00,0.00,235.81,179215.60,0.00,0.00,0.00),('1','150','771','257674',4904111,'2941','329',196098.34,196098.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257675',4904112,'2142','329',1390146.01,1391382.74,0.00,0.00,1236.73,939914.80,0.00,0.00,0.00),('1','150','771','257675',4904113,'2941','329',196098.34,196435.93,0.00,0.00,337.59,256568.40,0.00,0.00,0.00),('1','150','771','257676',4904114,'2142','329',1391382.74,1392562.62,0.00,0.00,1179.88,896708.80,0.00,0.00,0.00),('1','150','771','257676',4904115,'2941','329',196435.93,197296.46,0.00,0.00,860.53,654002.80,0.00,0.00,0.00),('1','150','771','257677',4904116,'2142','329',1392562.62,1393323.79,0.00,0.00,761.17,578489.20,0.00,0.00,0.00),('1','150','771','257677',4904117,'2941','329',197296.46,198108.76,0.00,0.00,812.30,617348.00,0.00,0.00,0.00),('1','150','771','257678',4904118,'2142','329',1393323.79,1394716.40,0.00,0.00,1392.61,1058383.60,0.00,0.00,0.00),('1','150','771','257678',4904119,'2941','329',198108.76,198653.07,0.00,0.00,544.31,413675.60,0.00,0.00,0.00),('1','150','771','257679',4904120,'2142','329',1394716.40,1395858.04,0.00,0.00,1141.64,867646.40,0.00,0.00,0.00),('1','150','771','257679',4904121,'2941','329',198653.07,199156.85,0.00,0.00,503.78,382872.80,0.00,0.00,0.00),('1','150','771','257680',4904122,'2142','329',1395858.04,1396972.29,0.00,0.00,1114.25,846830.00,0.00,0.00,0.00),('1','150','771','257680',4904123,'2941','329',199156.85,199594.14,0.00,0.00,437.29,332340.40,0.00,0.00,0.00),('1','150','771','257681',4904124,'2142','329',1396972.29,1397050.21,0.00,0.00,77.92,59219.20,0.00,0.00,0.00),('1','150','771','257681',4904125,'2941','329',199594.14,199594.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257682',4904126,'2142','329',1397050.21,1398037.47,0.00,0.00,987.26,750317.60,0.00,0.00,0.00),('1','150','771','257682',4904127,'2941','329',199594.14,200469.43,0.00,0.00,875.29,665220.40,0.00,0.00,0.00),('1','150','771','257683',4904128,'2142','329',1398037.47,1399913.52,0.00,0.00,1876.05,1425798.00,0.00,0.00,0.00),('1','150','771','257683',4904129,'2941','329',200469.43,200748.00,0.00,0.00,278.57,211713.20,0.00,0.00,0.00),('1','150','771','257684',4904130,'2142','329',1399913.52,1401044.26,0.00,0.00,1130.74,859362.40,0.00,0.00,0.00),('1','150','771','257684',4904131,'2941','329',200748.00,201694.15,0.00,0.00,946.15,719074.00,0.00,0.00,0.00),('1','150','771','257685',4904132,'2142','329',1401044.26,1402008.30,0.00,0.00,964.04,732670.40,0.00,0.00,0.00),('1','150','771','257685',4904133,'2941','329',201694.15,202420.15,0.00,0.00,726.00,551760.00,0.00,0.00,0.00),('1','150','771','257686',4904134,'2142','329',1402008.30,1403741.13,0.00,0.00,1732.83,1316950.80,0.00,0.00,0.00),('1','150','771','257686',4904135,'2941','329',202420.15,202888.45,0.00,0.00,468.30,355908.00,0.00,0.00,0.00),('1','150','771','257687',4904136,'2142','329',1403741.13,1404939.58,0.00,0.00,1198.45,910822.00,0.00,0.00,0.00),('1','150','771','257687',4904137,'2941','329',202888.45,202892.00,0.00,0.00,3.55,2698.00,0.00,0.00,0.00),('1','150','771','257688',4904138,'2142','329',1404939.58,1405708.15,0.00,0.00,768.57,584113.20,0.00,0.00,0.00),('1','150','771','257688',4904139,'2941','329',202892.00,202892.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257689',4904140,'2142','329',1405708.15,1407094.97,0.00,0.00,1386.82,1053983.20,0.00,0.00,0.00),('1','150','771','257689',4904141,'2941','329',202892.00,202935.43,0.00,0.00,43.43,33006.80,0.00,0.00,0.00),('1','150','771','257690',4904142,'2142','329',1407094.97,1408505.83,0.00,0.00,1410.86,1072253.60,0.00,0.00,0.00),('1','150','771','257690',4904143,'2941','329',202935.43,203306.53,0.00,0.00,371.10,282036.00,0.00,0.00,0.00),('1','150','771','257691',4904144,'2142','329',1408505.83,1409799.19,0.00,0.00,1293.36,982953.60,0.00,0.00,0.00),('1','150','771','257691',4904145,'2941','329',203306.53,203449.78,0.00,0.00,143.25,108870.00,0.00,0.00,0.00),('1','150','771','257692',4904146,'2142','329',1409799.19,1411497.30,0.00,0.00,1698.11,1290563.60,0.00,0.00,0.00),('1','150','771','257692',4904147,'2941','329',203449.78,204344.92,0.00,0.00,895.14,680306.40,0.00,0.00,0.00),('1','150','771','257693',4904148,'2142','329',1411497.30,1413163.89,0.00,0.00,1666.59,1266608.40,0.00,0.00,0.00),('1','150','771','257693',4904149,'2941','329',204344.92,204657.90,0.00,0.00,312.98,237864.80,0.00,0.00,0.00),('1','150','771','257694',4904150,'2142','329',1413163.89,1413731.68,0.00,0.00,567.79,431520.40,0.00,0.00,0.00),('1','150','771','257694',4904151,'2941','329',204657.90,205211.63,0.00,0.00,553.73,420834.80,0.00,0.00,0.00),('1','150','771','257695',4904152,'2142','329',1413731.68,1414102.21,0.00,0.00,370.53,281602.80,0.00,0.00,0.00),('1','150','771','257695',4904153,'2941','329',205211.63,205525.95,0.00,0.00,314.32,238883.20,0.00,0.00,0.00),('1','150','771','257696',4904154,'2142','329',1414102.21,1415420.43,0.00,0.00,1318.22,1001847.20,0.00,0.00,0.00),('1','150','771','257696',4904155,'2941','329',205525.95,206144.70,0.00,0.00,618.75,470250.00,0.00,0.00,0.00),('1','150','771','257697',4904156,'2142','329',1415420.43,1416828.80,0.00,0.00,1408.37,1070361.20,0.00,0.00,0.00),('1','150','771','257697',4904157,'2941','329',206144.70,206752.18,0.00,0.00,607.48,461684.80,0.00,0.00,0.00),('1','150','771','257698',4904158,'2142','329',1416828.80,1416828.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257698',4904159,'2941','329',206752.18,207236.56,0.00,0.00,484.38,368128.80,0.00,0.00,0.00),('1','150','771','257699',4904160,'2142','329',1416828.80,1416828.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257699',4904161,'2941','329',207236.56,207236.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257700',4904162,'2142','329',1416828.80,1418199.20,0.00,0.00,1370.40,1041504.00,0.00,0.00,0.00),('1','150','771','257700',4904163,'2941','329',207236.56,207370.50,0.00,0.00,133.94,101794.40,0.00,0.00,0.00),('1','150','771','257701',4904164,'2142','329',1418199.20,1419880.01,0.00,0.00,1680.81,1277415.60,0.00,0.00,0.00),('1','150','771','257701',4904165,'2941','329',207370.50,208207.66,0.00,0.00,837.16,636241.60,0.00,0.00,0.00),('1','150','771','257702',4904166,'2142','329',1419880.01,1420727.94,0.00,0.00,847.93,644426.80,0.00,0.00,0.00),('1','150','771','257702',4904167,'2941','329',208207.66,208682.80,0.00,0.00,475.14,361106.40,0.00,0.00,0.00),('1','150','771','257703',4904168,'2142','329',1420727.94,1421796.26,0.00,0.00,1068.32,811923.20,0.00,0.00,0.00),('1','150','771','257703',4904169,'2941','329',208682.80,208779.86,0.00,0.00,97.06,73765.60,0.00,0.00,0.00),('1','150','771','257704',4904170,'2142','329',1421796.26,1423430.55,0.00,0.00,1634.29,1242060.40,0.00,0.00,0.00),('1','150','771','257704',4904171,'2941','329',208779.86,209014.14,0.00,0.00,234.28,178052.80,0.00,0.00,0.00),('1','150','771','257705',4904172,'2142','329',1423430.55,1424464.12,0.00,0.00,1033.57,785513.20,0.00,0.00,0.00),('1','150','771','257705',4904173,'2941','329',209014.14,209862.62,0.00,0.00,848.48,644844.80,0.00,0.00,0.00),('1','150','771','257706',4904174,'2142','329',1424464.12,1425730.62,0.00,0.00,1266.50,962540.00,0.00,0.00,0.00),('1','150','771','257706',4904175,'2941','329',209862.62,210188.41,0.00,0.00,325.79,247600.40,0.00,0.00,0.00),('1','150','771','257707',4904176,'2142','329',1425730.62,1426850.26,0.00,0.00,1119.64,850926.40,0.00,0.00,0.00),('1','150','771','257707',4904177,'2941','329',210188.41,210679.99,0.00,0.00,491.58,373600.80,0.00,0.00,0.00),('1','150','771','257708',4904178,'2142','329',1426850.26,1428642.29,0.00,0.00,1792.03,1361942.80,0.00,0.00,0.00),('1','150','771','257708',4904179,'2941','329',210679.99,211074.85,0.00,0.00,394.86,300093.60,0.00,0.00,0.00),('1','150','771','257709',4904180,'2142','329',1428642.29,1429187.66,0.00,0.00,545.37,414481.20,0.00,0.00,0.00),('1','150','771','257709',4904181,'2941','329',211074.85,211074.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257710',4904182,'2142','329',1429187.66,1429796.68,0.00,0.00,609.02,462855.20,0.00,0.00,0.00),('1','150','771','257710',4904183,'2941','329',211074.85,212311.75,0.00,0.00,1236.90,940044.00,0.00,0.00,0.00),('1','150','771','257711',4904184,'2142','329',1429796.68,1430495.38,0.00,0.00,698.70,531012.00,0.00,0.00,0.00),('1','150','771','257711',4904185,'2941','329',212311.75,213180.86,0.00,0.00,869.11,660523.60,0.00,0.00,0.00),('1','150','771','257712',4904186,'2142','329',1430495.38,1431271.05,0.00,0.00,775.67,589509.20,0.00,0.00,0.00),('1','150','771','257712',4904187,'2941','329',213180.86,214024.48,0.00,0.00,843.62,641151.20,0.00,0.00,0.00),('1','150','771','257713',4904188,'2142','329',1431271.05,1431606.07,0.00,0.00,335.02,254615.20,0.00,0.00,0.00),('1','150','771','257713',4904189,'2941','329',214024.48,214299.32,0.00,0.00,274.84,208878.40,0.00,0.00,0.00),('1','150','771','257714',4904190,'2142','329',1431606.07,1432406.02,0.00,0.00,799.95,607962.00,0.00,0.00,0.00),('1','150','771','257714',4904191,'2941','329',214299.32,215103.90,0.00,0.00,804.58,611480.80,0.00,0.00,0.00),('1','150','771','257715',4904192,'2142','329',1432406.02,1433186.56,0.00,0.00,780.54,593210.40,0.00,0.00,0.00),('1','150','771','257715',4904193,'2941','329',215103.90,215629.83,0.00,0.00,525.93,399706.80,0.00,0.00,0.00),('1','150','771','257716',4904194,'2142','329',1433186.56,1433312.31,0.00,0.00,125.75,95570.00,0.00,0.00,0.00),('1','150','771','257716',4904195,'2941','329',215629.83,216023.32,0.00,0.00,393.49,299052.40,0.00,0.00,0.00),('1','150','771','257717',4904196,'2142','329',1433312.31,1433794.26,0.00,0.00,481.95,366282.00,0.00,0.00,0.00),('1','150','771','257717',4904197,'2941','329',216023.32,216027.27,0.00,0.00,3.95,3002.00,0.00,0.00,0.00),('1','150','771','257718',4904198,'2142','329',1433794.26,1434194.29,0.00,0.00,400.03,304022.80,0.00,0.00,0.00),('1','150','771','257718',4904199,'2941','329',216027.27,216622.38,0.00,0.00,595.11,452283.60,0.00,0.00,0.00),('1','150','771','257719',4904200,'2142','329',1434194.29,1435061.11,0.00,0.00,866.82,658783.20,0.00,0.00,0.00),('1','150','771','257719',4904201,'2941','329',216622.38,217309.15,0.00,0.00,686.77,521945.20,0.00,0.00,0.00),('1','150','771','257720',4904202,'2142','329',1435061.11,1435906.42,0.00,0.00,845.31,642435.60,0.00,0.00,0.00),('1','150','771','257720',4904203,'2941','329',217309.15,217776.35,0.00,0.00,467.20,355072.00,0.00,0.00,0.00),('1','150','771','257721',4904204,'2142','329',1435906.42,1437156.69,0.00,0.00,1250.27,950205.20,0.00,0.00,0.00),('1','150','771','257721',4904205,'2941','329',217776.35,218053.52,0.00,0.00,277.17,210649.20,0.00,0.00,0.00),('1','150','771','257722',4904206,'2142','329',1437156.69,1437664.74,0.00,0.00,508.05,386118.00,0.00,0.00,0.00),('1','150','771','257722',4904207,'2941','329',218053.52,218214.04,0.00,0.00,160.52,121995.20,0.00,0.00,0.00),('1','150','771','257723',4904208,'2142','329',1437664.74,1438233.99,0.00,0.00,569.25,432630.00,0.00,0.00,0.00),('1','150','771','257723',4904209,'2941','329',218214.04,218402.86,0.00,0.00,188.82,143503.20,0.00,0.00,0.00),('1','150','771','257724',4904210,'2142','329',1438233.99,1439622.74,0.00,0.00,1388.75,1033230.00,0.00,0.00,0.00),('1','150','771','257724',4904211,'2941','329',218402.86,218829.65,0.00,0.00,426.79,317531.76,0.00,0.00,0.00),('1','150','771','257725',4904212,'2142','329',1439622.74,1441292.78,0.00,0.00,1670.04,1246277.76,0.00,0.00,0.00),('1','150','771','257725',4904213,'2941','329',218829.65,219394.42,0.00,0.00,564.77,420188.88,0.00,0.00,0.00),('1','150','771','257726',4904214,'2142','329',1441292.78,1441584.51,0.00,0.00,291.73,217047.12,0.00,0.00,0.00),('1','150','771','257726',4904215,'2941','329',219394.42,219451.35,0.00,0.00,56.93,42355.92,0.00,0.00,0.00),('1','150','771','257727',4904216,'2142','329',1441584.51,1442167.63,0.00,0.00,583.12,433841.28,0.00,0.00,0.00),('1','150','771','257727',4904217,'2941','329',219451.35,219981.78,0.00,0.00,530.43,394639.92,0.00,0.00,0.00),('1','150','771','257728',4904218,'2142','329',1442167.63,1443200.52,0.00,0.00,1032.89,768470.16,0.00,0.00,0.00),('1','150','771','257728',4904219,'2941','329',219981.78,220717.48,0.00,0.00,735.70,547360.80,0.00,0.00,0.00),('1','150','771','257729',4904220,'2142','329',1443200.52,1444502.91,0.00,0.00,1302.39,968978.16,0.00,0.00,0.00),('1','150','771','257729',4904221,'2941','329',220717.48,220999.71,0.00,0.00,282.23,209979.12,0.00,0.00,0.00),('1','150','771','257730',4904222,'2142','329',1444502.91,1445270.20,0.00,0.00,767.29,570863.76,0.00,0.00,0.00),('1','150','771','257730',4904223,'2941','329',220999.71,221158.70,0.00,0.00,158.99,118288.56,0.00,0.00,0.00),('1','150','771','257731',4904224,'2142','329',1445270.20,1445560.00,0.00,0.00,289.80,215611.20,0.00,0.00,0.00),('1','150','771','257731',4904225,'2941','329',221158.70,221859.24,0.00,0.00,700.54,521201.76,0.00,0.00,0.00),('1','150','771','257732',4904226,'2142','329',1445560.00,1446227.69,0.00,0.00,667.69,496761.36,0.00,0.00,0.00),('1','150','771','257732',4904227,'2941','329',221859.24,222755.88,0.00,0.00,896.64,667100.16,0.00,0.00,0.00),('1','150','771','257733',4904228,'2142','329',1446227.69,1448480.25,0.00,0.00,2252.56,1675904.64,0.00,0.00,0.00),('1','150','771','257733',4904229,'2941','329',222755.88,222911.14,0.00,0.00,155.26,115513.44,0.00,0.00,0.00),('1','150','771','257734',4904230,'2142','329',1448480.25,1448719.10,0.00,0.00,238.85,177704.40,0.00,0.00,0.00),('1','150','771','257734',4904231,'2941','329',222911.14,222927.95,0.00,0.00,16.81,12506.64,0.00,0.00,0.00),('1','150','771','257735',4904232,'2142','329',1448719.10,1450653.85,0.00,0.00,1934.75,1439454.00,0.00,0.00,0.00),('1','150','771','257735',4904233,'2941','329',222927.95,223229.24,0.00,0.00,301.29,224159.76,0.00,0.00,0.00),('1','150','771','257736',4904234,'2142','329',1450653.85,1452456.36,0.00,0.00,1802.51,1341067.44,0.00,0.00,0.00),('1','150','771','257736',4904235,'2941','329',223229.24,223366.50,0.00,0.00,137.26,102121.44,0.00,0.00,0.00),('1','150','771','257737',4904236,'2142','329',1452456.36,1453341.80,0.00,0.00,885.44,658767.36,0.00,0.00,0.00),('1','150','771','257737',4904237,'2941','329',223366.50,223572.41,0.00,0.00,205.91,153197.04,0.00,0.00,0.00),('1','150','771','257738',4904238,'2142','329',1453341.80,1453988.09,0.00,0.00,646.29,480839.76,0.00,0.00,0.00),('1','150','771','257738',4904239,'2941','329',223572.41,223621.93,0.00,0.00,49.52,36842.88,0.00,0.00,0.00),('1','150','771','257739',4904240,'2142','329',1453988.09,1455619.26,0.00,0.00,1631.17,1213590.48,0.00,0.00,0.00),('1','150','771','257739',4904241,'2941','329',223621.93,224014.61,0.00,0.00,392.68,292153.92,0.00,0.00,0.00),('1','150','771','257740',4904242,'2142','329',1455619.26,1457083.28,0.00,0.00,1464.02,1089230.88,0.00,0.00,0.00),('1','150','771','257740',4904243,'2941','329',224014.61,224428.52,0.00,0.00,413.91,307949.04,0.00,0.00,0.00),('1','150','771','257741',4904244,'2142','329',1457083.28,1457787.85,0.00,0.00,704.57,524200.08,0.00,0.00,0.00),('1','150','771','257741',4904245,'2941','329',224428.52,224547.31,0.00,0.00,118.79,88379.76,0.00,0.00,0.00),('1','150','771','257742',4904246,'2142','329',1457787.85,1458375.82,0.00,0.00,587.97,437449.68,0.00,0.00,0.00),('1','150','771','257742',4904247,'2941','329',224547.31,224727.61,0.00,0.00,180.30,134143.20,0.00,0.00,0.00),('1','150','771','257743',4904248,'2142','329',1458375.82,1460125.22,0.00,0.00,1749.40,1301553.60,0.00,0.00,0.00),('1','150','771','257743',4904249,'2941','329',224727.61,225199.31,0.00,0.00,471.70,350944.80,0.00,0.00,0.00),('1','150','771','257744',4904250,'2142','329',1460125.22,1461261.62,0.00,0.00,1136.40,845481.60,0.00,0.00,0.00),('1','150','771','257744',4904251,'2941','329',225199.31,225997.26,0.00,0.00,797.95,593674.80,0.00,0.00,0.00),('1','150','771','257745',4904252,'2142','329',1461261.62,1462560.00,0.00,0.00,1298.38,976381.76,0.00,0.00,0.00),('1','150','771','257745',4904253,'2941','329',225997.26,226727.70,0.00,0.00,730.44,549290.88,0.00,0.00,0.00),('1','150','771','257746',4904254,'2142','329',1462560.00,1463290.50,0.00,0.00,730.50,549336.00,0.00,0.00,0.00),('1','150','771','257746',4904255,'2941','329',226727.70,227379.23,0.00,0.00,651.53,489950.56,0.00,0.00,0.00),('1','150','771','257747',4904256,'2142','329',1463290.50,1464279.65,0.00,0.00,989.15,743840.80,0.00,0.00,0.00),('1','150','771','257747',4904257,'2941','329',227379.23,228054.70,0.00,0.00,675.47,507953.44,0.00,0.00,0.00),('1','150','771','257748',4904258,'2142','329',1464279.65,1464483.99,0.00,0.00,204.34,153663.68,0.00,0.00,0.00),('1','150','771','257748',4904259,'2941','329',228054.70,228176.97,0.00,0.00,122.27,91947.04,0.00,0.00,0.00),('1','150','771','257749',4904260,'2142','329',1464483.99,1465261.47,0.00,0.00,777.48,584664.96,0.00,0.00,0.00),('1','150','771','257749',4904261,'2941','329',228176.97,228690.60,0.00,0.00,513.63,386249.76,0.00,0.00,0.00),('1','150','771','257750',4904262,'2142','329',1465261.47,1466345.69,0.00,0.00,1084.22,815333.44,0.00,0.00,0.00),('1','150','771','257750',4904263,'2941','329',228690.60,229594.54,0.00,0.00,903.94,679762.88,0.00,0.00,0.00),('1','150','771','257751',4904264,'2142','329',1466345.69,1467184.20,0.00,0.00,838.51,630559.52,0.00,0.00,0.00),('1','150','771','257751',4904265,'2941','329',229594.54,230575.91,0.00,0.00,981.37,737990.24,0.00,0.00,0.00),('1','150','771','257752',4904266,'2142','329',1467184.20,1467275.87,0.00,0.00,91.67,68935.84,0.00,0.00,0.00),('1','150','771','257752',4904267,'2941','329',230575.91,230732.19,0.00,0.00,156.28,117522.56,0.00,0.00,0.00),('1','150','771','257753',4904268,'2142','329',1467275.87,1468401.05,0.00,0.00,1125.18,846135.36,0.00,0.00,0.00),('1','150','771','257753',4904269,'2941','329',230732.19,231123.58,0.00,0.00,391.39,294325.28,0.00,0.00,0.00),('1','150','771','257754',4904270,'2142','329',1468401.05,1469918.22,0.00,0.00,1517.17,1140911.84,0.00,0.00,0.00),('1','150','771','257754',4904271,'2941','329',231123.58,232406.97,0.00,0.00,1283.39,965109.28,0.00,0.00,0.00),('1','150','771','257755',4904272,'2142','329',1469918.22,1470902.87,0.00,0.00,984.65,732579.60,0.00,0.00,0.00),('1','150','771','257755',4904273,'2941','329',232406.97,232572.27,0.00,0.00,165.30,122983.20,0.00,0.00,0.00),('1','150','771','257756',4904274,'2142','329',1470902.87,1471226.75,0.00,0.00,323.88,240966.72,0.00,0.00,0.00),('1','150','771','257756',4904275,'2941','329',232572.27,232858.73,0.00,0.00,286.46,213126.24,0.00,0.00,0.00),('1','150','771','257757',4904276,'2142','329',1471226.75,1472244.65,0.00,0.00,1017.90,757317.60,0.00,0.00,0.00),('1','150','771','257757',4904277,'2941','329',232858.73,233494.22,0.00,0.00,635.49,472804.56,0.00,0.00,0.00),('1','150','771','257758',4904278,'2142','329',1472244.65,1473392.55,0.00,0.00,1147.90,854037.60,0.00,0.00,0.00),('1','150','771','257758',4904279,'2941','329',233494.22,233852.84,0.00,0.00,358.62,266813.28,0.00,0.00,0.00),('1','150','771','257759',4904280,'2142','329',1473392.55,1474495.56,0.00,0.00,1103.01,820639.44,0.00,0.00,0.00),('1','150','771','257759',4904281,'2941','329',233852.84,234108.55,0.00,0.00,255.71,190248.24,0.00,0.00,0.00),('1','150','771','257760',4904282,'2142','329',1474495.56,1476266.97,0.00,0.00,1771.41,1317929.04,0.00,0.00,0.00),('1','150','771','257760',4904283,'2941','329',234108.55,234560.00,0.00,0.00,451.45,335878.80,0.00,0.00,0.00),('1','150','771','257761',4904284,'2142','329',1476266.97,1477078.62,0.00,0.00,811.65,603867.60,0.00,0.00,0.00),('1','150','771','257761',4904285,'2941','329',234560.00,235718.84,0.00,0.00,1158.84,862176.96,0.00,0.00,0.00),('1','150','771','257762',4904286,'2142','329',1477078.62,1477626.85,0.00,0.00,548.23,407883.12,0.00,0.00,0.00),('1','150','771','257762',4904287,'2941','329',235718.84,236169.86,0.00,0.00,451.02,335558.88,0.00,0.00,0.00),('1','150','771','257763',4904288,'2142','329',1477626.85,1479018.39,0.00,0.00,1391.54,1035305.76,0.00,0.00,0.00),('1','150','771','257763',4904289,'2941','329',236169.86,236750.22,0.00,0.00,580.36,431787.84,0.00,0.00,0.00),('1','150','771','257764',4904290,'2142','329',1479018.39,1479982.13,0.00,0.00,963.74,717022.56,0.00,0.00,0.00),('1','150','771','257764',4904291,'2941','329',236750.22,237215.21,0.00,0.00,464.99,345952.56,0.00,0.00,0.00),('1','150','771','257765',4904292,'2142','329',1479982.13,1480975.17,0.00,0.00,993.04,738821.76,0.00,0.00,0.00),('1','150','771','257765',4904293,'2941','329',237215.21,237752.56,0.00,0.00,537.35,399788.40,0.00,0.00,0.00),('1','150','771','257766',4904294,'2142','329',1480975.17,1481214.56,0.00,0.00,239.39,178106.16,0.00,0.00,0.00),('1','150','771','257766',4904295,'2941','329',237752.56,237783.04,0.00,0.00,30.48,22677.12,0.00,0.00,0.00),('1','150','771','257767',4904296,'2142','329',1481214.56,1482226.94,0.00,0.00,1012.38,753210.72,0.00,0.00,0.00),('1','150','771','257767',4904297,'2941','329',237783.04,237955.08,0.00,0.00,172.04,127997.76,0.00,0.00,0.00),('1','150','771','257768',4904298,'2142','329',1482226.94,1483885.19,0.00,0.00,1658.25,1233738.00,0.00,0.00,0.00),('1','150','771','257768',4904299,'2941','329',237955.08,238810.23,0.00,0.00,855.15,636231.60,0.00,0.00,0.00),('1','150','771','257769',4904300,'2142','329',1483885.19,1484760.96,0.00,0.00,875.77,651572.88,0.00,0.00,0.00),('1','150','771','257769',4904301,'2941','329',238810.23,239402.09,0.00,0.00,591.86,440343.84,0.00,0.00,0.00),('1','150','771','257770',4904302,'2142','329',1484760.96,1485322.17,0.00,0.00,561.21,417540.24,0.00,0.00,0.00),('1','150','771','257770',4904303,'2941','329',239402.09,239538.51,0.00,0.00,136.42,101496.48,0.00,0.00,0.00),('1','150','771','257771',4904304,'2142','329',1485322.17,1486582.67,0.00,0.00,1260.50,937812.00,0.00,0.00,0.00),('1','150','771','257771',4904305,'2941','329',239538.51,240487.87,0.00,0.00,949.36,706323.84,0.00,0.00,0.00),('1','150','771','257772',4904306,'2142','329',1486582.67,1488103.27,0.00,0.00,1520.60,1131326.40,0.00,0.00,0.00),('1','150','771','257772',4904307,'2941','329',240487.87,241313.97,0.00,0.00,826.10,614618.40,0.00,0.00,0.00),('1','150','771','257773',4904308,'2142','329',1488103.27,1488178.10,0.00,0.00,74.83,55673.52,0.00,0.00,0.00),('1','150','771','257773',4904309,'2941','329',241313.97,241313.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257774',4904310,'2142','329',1488178.10,1489089.30,0.00,0.00,911.20,677932.80,0.00,0.00,0.00),('1','150','771','257774',4904311,'2941','329',241313.97,241832.85,0.00,0.00,518.88,386602.72,0.00,0.00,0.00),('1','150','771','257775',4904312,'2142','329',1489089.30,1490408.66,0.00,0.00,1319.36,981603.84,0.00,0.00,0.00),('1','150','771','257775',4904313,'2941','329',241832.85,242780.51,0.00,0.00,947.66,705059.04,0.00,0.00,0.00),('1','150','771','257776',4904314,'2142','329',1490408.66,1491617.02,0.00,0.00,1208.36,899019.84,0.00,0.00,0.00),('1','150','771','257776',4904315,'2941','329',242780.51,243084.21,0.00,0.00,303.70,225952.80,0.00,0.00,0.00),('1','150','771','257777',4904316,'2142','329',1491617.02,1491617.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257777',4904317,'2941','329',243084.21,243128.12,0.00,0.00,43.91,32669.04,0.00,0.00,0.00),('1','150','771','257778',4904318,'2142','329',1491617.02,1493603.94,0.00,0.00,1986.92,1478268.48,0.00,0.00,0.00),('1','150','771','257778',4904319,'2941','329',243128.12,243736.21,0.00,0.00,608.09,452418.96,0.00,0.00,0.00),('1','150','771','257779',4904320,'2142','329',1493603.94,1494096.27,0.00,0.00,492.33,366293.52,0.00,0.00,0.00),('1','150','771','257779',4904321,'2941','329',243736.21,244337.12,0.00,0.00,600.91,447077.04,0.00,0.00,0.00),('1','150','771','257780',4904322,'2142','329',1494096.27,1494096.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257780',4904323,'2941','329',244337.12,244648.87,0.00,0.00,311.75,231942.00,0.00,0.00,0.00),('1','150','771','257781',4904324,'2142','329',1494096.27,1494810.85,0.00,0.00,714.58,531647.52,0.00,0.00,0.00),('1','150','771','257781',4904325,'2941','329',244648.87,244825.88,0.00,0.00,177.01,131695.44,0.00,0.00,0.00),('1','150','771','257782',4904326,'2142','329',1494810.85,1495994.65,0.00,0.00,1183.80,880747.20,0.00,0.00,0.00),('1','150','771','257782',4904327,'2941','329',244825.88,245320.23,0.00,0.00,494.35,367796.40,0.00,0.00,0.00),('1','150','771','257783',4904328,'2142','329',1495994.65,1496904.27,0.00,0.00,909.62,676757.28,0.00,0.00,0.00),('1','150','771','257783',4904329,'2941','329',245320.23,246232.77,0.00,0.00,912.54,678929.76,0.00,0.00,0.00),('1','150','771','257784',4904330,'2142','329',1496904.27,1497562.63,0.00,0.00,658.36,489819.84,0.00,0.00,0.00),('1','150','771','257784',4904331,'2941','329',246232.77,246411.07,0.00,0.00,178.30,132655.20,0.00,0.00,0.00),('1','150','771','257785',4904332,'2142','329',1497562.63,1498159.11,0.00,0.00,596.48,443781.12,0.00,0.00,0.00),('1','150','771','257785',4904333,'2941','329',246411.07,246809.06,0.00,0.00,397.99,296104.56,0.00,0.00,0.00),('1','150','771','257786',4904334,'2142','329',1498159.11,1498984.54,0.00,0.00,825.43,614119.92,0.00,0.00,0.00),('1','150','771','257786',4904335,'2941','329',246809.06,247557.09,0.00,0.00,748.03,556534.32,0.00,0.00,0.00),('1','150','771','257787',4904336,'2142','329',1498984.54,1500900.86,0.00,0.00,1916.32,1425742.08,0.00,0.00,0.00),('1','150','771','257787',4904337,'2941','329',247557.09,247902.93,0.00,0.00,345.84,257304.96,0.00,0.00,0.00),('1','150','771','257788',4904338,'2142','329',1500900.86,1501288.83,0.00,0.00,387.97,288649.68,0.00,0.00,0.00),('1','150','771','257788',4904339,'2941','329',247902.93,247950.36,0.00,0.00,47.43,35287.92,0.00,0.00,0.00),('1','150','771','257789',4904340,'2142','329',1501288.83,1501288.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257789',4904341,'2941','329',247950.36,247964.87,0.00,0.00,14.51,10795.44,0.00,0.00,0.00),('1','150','771','257790',4904342,'2142','329',1501288.83,1502425.24,0.00,0.00,1136.41,845489.04,0.00,0.00,0.00),('1','150','771','257790',4904343,'2941','329',247964.87,248851.64,0.00,0.00,886.77,659756.88,0.00,0.00,0.00),('1','150','771','257791',4904344,'2142','329',1502425.24,1503438.19,0.00,0.00,1012.95,753634.80,0.00,0.00,0.00),('1','150','771','257791',4904345,'2941','329',248851.64,249689.96,0.00,0.00,838.32,623710.08,0.00,0.00,0.00),('1','150','771','257792',4904346,'2142','329',1503438.19,1504544.98,0.00,0.00,1106.79,823451.76,0.00,0.00,0.00),('1','150','771','257792',4904347,'2941','329',249689.96,250079.55,0.00,0.00,389.59,289854.96,0.00,0.00,0.00),('1','150','771','257793',4904348,'2142','329',1504544.98,1504574.15,0.00,0.00,29.17,21702.48,0.00,0.00,0.00),('1','150','771','257793',4904349,'2941','329',250079.55,250079.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257794',4904350,'2142','329',1504574.15,1506457.51,0.00,0.00,1883.36,1401219.84,0.00,0.00,0.00),('1','150','771','257794',4904351,'2941','329',250079.55,250335.94,0.00,0.00,256.39,190754.16,0.00,0.00,0.00),('1','150','771','257795',4904352,'2142','329',1506457.51,1508639.14,0.00,0.00,2181.63,1605679.68,0.00,0.00,0.00),('1','150','771','257795',4904353,'2941','329',250335.94,250518.03,0.00,0.00,182.09,134018.24,0.00,0.00,0.00),('1','150','771','257796',4904354,'2142','329',1508639.14,1508764.55,0.00,0.00,125.41,92301.76,0.00,0.00,0.00),('1','150','771','257796',4904355,'2941','329',250518.03,251249.60,0.00,0.00,731.57,538435.52,0.00,0.00,0.00),('1','150','771','257797',4904356,'2142','329',1508764.55,1509811.43,0.00,0.00,1046.88,770503.68,0.00,0.00,0.00),('1','150','771','257797',4904357,'2941','329',251249.60,251998.10,0.00,0.00,748.50,550896.00,0.00,0.00,0.00),('1','150','771','257798',4904358,'2142','329',1509811.43,1510924.98,0.00,0.00,1113.55,819572.80,0.00,0.00,0.00),('1','150','771','257798',4904359,'2941','329',251998.10,252789.89,0.00,0.00,791.79,582757.44,0.00,0.00,0.00),('1','150','771','257799',4904360,'2142','329',1510924.98,1512063.82,0.00,0.00,1138.84,838186.24,0.00,0.00,0.00),('1','150','771','257799',4904361,'2941','329',252789.89,253159.58,0.00,0.00,369.69,272091.84,0.00,0.00,0.00),('1','150','771','257800',4904362,'2142','329',1512063.82,1512063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257800',4904363,'2941','329',253159.58,253159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257801',4904364,'2142','329',1512063.82,1512077.28,0.00,0.00,13.46,9906.56,0.00,0.00,0.00),('1','150','771','257801',4904365,'2941','329',253159.58,253159.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257802',4904366,'2142','329',1512077.28,1513329.29,0.00,0.00,1252.01,921479.36,0.00,0.00,0.00),('1','150','771','257802',4904367,'2941','329',253159.58,254114.43,0.00,0.00,954.85,702769.60,0.00,0.00,0.00),('1','150','771','257803',4904368,'2142','329',1513329.29,1514667.51,0.00,0.00,1338.22,984929.92,0.00,0.00,0.00),('1','150','771','257803',4904369,'2941','329',254114.43,254942.76,0.00,0.00,828.33,609650.88,0.00,0.00,0.00),('1','150','771','257804',4904370,'2142','329',1514667.51,1515616.50,0.00,0.00,948.99,698456.64,0.00,0.00,0.00),('1','150','771','257804',4904371,'2941','329',254942.76,255272.72,0.00,0.00,329.96,242850.56,0.00,0.00,0.00),('1','150','771','257805',4904372,'2142','329',1515616.50,1517265.47,0.00,0.00,1648.97,1213641.92,0.00,0.00,0.00),('1','150','771','257805',4904373,'2941','329',255272.72,255950.00,0.00,0.00,677.28,498478.08,0.00,0.00,0.00),('1','150','771','257806',4904374,'2142','329',1517265.47,1518213.21,0.00,0.00,947.74,697536.64,0.00,0.00,0.00),('1','150','771','257806',4904375,'2941','329',255950.00,256774.60,0.00,0.00,824.60,606905.60,0.00,0.00,0.00),('1','150','771','257807',4904376,'2142','329',1518213.21,1519157.56,0.00,0.00,944.35,695041.60,0.00,0.00,0.00),('1','150','771','257807',4904377,'2941','329',256774.60,256895.34,0.00,0.00,120.74,88864.64,0.00,0.00,0.00),('1','150','771','257808',4904378,'2142','329',1519157.56,1519555.40,0.00,0.00,397.84,292810.24,0.00,0.00,0.00),('1','150','771','257808',4904379,'2941','329',256895.34,257586.58,0.00,0.00,691.24,508752.64,0.00,0.00,0.00),('1','150','771','257809',4904380,'2142','329',1519555.40,1520561.90,0.00,0.00,1006.50,740784.00,0.00,0.00,0.00),('1','150','771','257809',4904381,'2941','329',257586.58,258574.93,0.00,0.00,988.35,727425.60,0.00,0.00,0.00),('1','150','771','257810',4904382,'2142','329',1520561.90,1522313.42,0.00,0.00,1751.52,1289118.72,0.00,0.00,0.00),('1','150','771','257810',4904383,'2941','329',258574.93,259079.88,0.00,0.00,504.95,371643.20,0.00,0.00,0.00),('1','150','771','257811',4904384,'2142','329',1522313.42,1522393.02,0.00,0.00,79.60,58585.60,0.00,0.00,0.00),('1','150','771','257811',4904385,'2941','329',259079.88,259084.17,0.00,0.00,4.29,3157.44,0.00,0.00,0.00),('1','150','771','257812',4904386,'2142','329',1522393.02,1523938.22,0.00,0.00,1545.20,1137267.20,0.00,0.00,0.00),('1','150','771','257812',4904387,'2941','329',259084.17,259731.38,0.00,0.00,647.21,476346.56,0.00,0.00,0.00),('1','150','771','257813',4904388,'2142','329',1523938.22,1525143.16,0.00,0.00,1204.94,886835.84,0.00,0.00,0.00),('1','150','771','257813',4904389,'2941','329',259731.38,260779.55,0.00,0.00,1048.17,771453.12,0.00,0.00,0.00),('1','150','771','257814',4904390,'2142','329',1525143.16,1525500.62,0.00,0.00,357.46,263090.56,0.00,0.00,0.00),('1','150','771','257814',4904391,'2941','329',260779.55,261348.11,0.00,0.00,568.56,418460.16,0.00,0.00,0.00),('1','150','771','257815',4904392,'2142','329',1525500.62,1525539.08,0.00,0.00,38.46,28306.56,0.00,0.00,0.00),('1','150','771','257815',4904393,'2941','329',261348.11,261348.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257816',4904394,'2142','329',1525539.08,1526119.01,0.00,0.00,579.93,426828.48,0.00,0.00,0.00),('1','150','771','257816',4904395,'2941','329',261348.11,262115.88,0.00,0.00,767.77,565078.72,0.00,0.00,0.00),('1','150','771','257817',4904396,'2142','329',1526119.01,1526974.21,0.00,0.00,855.20,629427.20,0.00,0.00,0.00),('1','150','771','257817',4904397,'2941','329',262115.88,263270.83,0.00,0.00,1154.95,850043.20,0.00,0.00,0.00),('1','150','771','257818',4904398,'2142','329',1526974.21,1527308.35,0.00,0.00,334.14,245927.04,0.00,0.00,0.00),('1','150','771','257818',4904399,'2941','329',263270.83,263456.60,0.00,0.00,185.77,136726.72,0.00,0.00,0.00),('1','150','771','257819',4904400,'2142','329',1527308.35,1527308.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257819',4904401,'2941','329',263456.60,263478.84,0.00,0.00,22.24,16368.64,0.00,0.00,0.00),('1','150','771','257820',4904402,'2142','329',1527308.35,1527965.23,0.00,0.00,656.88,483463.68,0.00,0.00,0.00),('1','150','771','257820',4904403,'2941','329',263478.84,264446.58,0.00,0.00,967.74,712256.64,0.00,0.00,0.00),('1','150','771','257821',4904404,'2142','329',1527965.23,1528901.96,0.00,0.00,936.73,689433.28,0.00,0.00,0.00),('1','150','771','257821',4904405,'2941','329',264446.58,265074.48,0.00,0.00,627.90,462134.40,0.00,0.00,0.00),('1','150','771','257822',4904406,'2142','329',1528901.96,1528901.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257822',4904407,'2941','329',265074.48,265115.23,0.00,0.00,40.75,29992.00,0.00,0.00,0.00),('1','150','771','257823',4904408,'2142','329',1528901.96,1530141.91,0.00,0.00,1239.95,947321.80,0.00,0.00,0.00),('1','150','771','257823',4904409,'2941','329',265115.23,265979.22,0.00,0.00,863.99,660088.36,0.00,0.00,0.00),('1','150','771','257824',4904410,'2142','329',1530141.91,1530585.62,0.00,0.00,443.71,338994.44,0.00,0.00,0.00),('1','150','771','257824',4904411,'2941','329',265979.22,266625.27,0.00,0.00,646.05,493582.20,0.00,0.00,0.00),('1','150','771','257825',4904412,'2142','329',1530585.62,1530585.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257825',4904413,'2941','329',266625.27,266641.57,0.00,0.00,16.30,12453.20,0.00,0.00,0.00),('1','150','771','257826',4904414,'2142','329',1530585.62,1532203.79,0.00,0.00,1618.17,1210391.16,0.00,0.00,0.00),('1','150','771','257826',4904415,'2941','329',266641.57,267456.37,0.00,0.00,814.80,609470.40,0.00,0.00,0.00),('1','150','771','257827',4904416,'2142','329',1532203.79,1532917.02,0.00,0.00,713.23,533496.04,0.00,0.00,0.00),('1','150','771','257827',4904417,'2941','329',267456.37,268365.02,0.00,0.00,908.65,679670.20,0.00,0.00,0.00),('1','150','771','257828',4904418,'2142','329',1532917.02,1532922.17,0.00,0.00,5.15,3852.20,0.00,0.00,0.00),('1','150','771','257828',4904419,'2941','329',268365.02,268365.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257829',4904420,'2142','329',1532922.17,1533417.05,0.00,0.00,494.88,370170.24,0.00,0.00,0.00),('1','150','771','257829',4904421,'2941','329',268365.02,268477.12,0.00,0.00,112.10,83850.80,0.00,0.00,0.00),('1','150','771','257830',4904422,'2142','329',1533417.05,1534836.61,0.00,0.00,1419.56,1062082.88,0.00,0.00,0.00),('1','150','771','257830',4904423,'2941','329',268477.12,269317.61,0.00,0.00,840.49,628686.52,0.00,0.00,0.00),('1','150','771','257831',4904424,'2142','329',1534836.61,1536402.32,0.00,0.00,1565.71,1171151.08,0.00,0.00,0.00),('1','150','771','257831',4904425,'2941','329',269317.61,269881.04,0.00,0.00,563.43,421445.64,0.00,0.00,0.00),('1','150','771','257832',4904426,'2142','329',1536402.32,1537925.92,0.00,0.00,1523.60,1139652.80,0.00,0.00,0.00),('1','150','771','257832',4904427,'2941','329',269881.04,270207.33,0.00,0.00,326.29,244064.92,0.00,0.00,0.00),('1','150','771','257833',4904428,'2142','329',1537925.92,1539379.60,0.00,0.00,1453.68,1087352.64,0.00,0.00,0.00),('1','150','771','257833',4904429,'2941','329',270207.33,270524.83,0.00,0.00,317.50,237490.00,0.00,0.00,0.00),('1','150','771','257834',4904430,'2142','329',1539379.60,1540446.39,0.00,0.00,1066.79,810760.40,0.00,0.00,0.00),('1','150','771','257834',4904431,'2941','329',270524.83,270984.94,0.00,0.00,460.11,349683.60,0.00,0.00,0.00),('1','150','771','257835',4904432,'2142','329',1540446.39,1541363.48,0.00,0.00,917.09,696988.40,0.00,0.00,0.00),('1','150','771','257835',4904433,'2941','329',270984.94,271301.22,0.00,0.00,316.28,240372.80,0.00,0.00,0.00),('1','150','771','257836',4904434,'2142','329',1541363.48,1542315.70,0.00,0.00,952.22,723687.20,0.00,0.00,0.00),('1','150','771','257836',4904435,'2941','329',271301.22,271570.46,0.00,0.00,269.24,204622.40,0.00,0.00,0.00),('1','150','771','257837',4904436,'2142','329',1542315.70,1543506.39,0.00,0.00,1190.69,904924.40,0.00,0.00,0.00),('1','150','771','257837',4904437,'2941','329',271570.46,272051.83,0.00,0.00,481.37,365841.20,0.00,0.00,0.00),('1','150','771','257838',4904438,'2142','329',1543506.39,1543963.18,0.00,0.00,456.79,347160.40,0.00,0.00,0.00),('1','150','771','257838',4904439,'2941','329',272051.83,272126.37,0.00,0.00,74.54,56650.40,0.00,0.00,0.00),('1','150','771','257839',4904440,'2142','329',1543963.18,1543984.96,0.00,0.00,21.78,16552.80,0.00,0.00,0.00),('1','150','771','257839',4904441,'2941','329',272126.37,272126.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257840',4904442,'2142','329',1543984.96,1544880.11,0.00,0.00,895.15,680314.00,0.00,0.00,0.00),('1','150','771','257840',4904443,'2941','329',272126.37,272677.08,0.00,0.00,550.71,418539.60,0.00,0.00,0.00),('1','150','771','257841',4904444,'2142','329',1544880.11,1545724.21,0.00,0.00,844.10,641516.00,0.00,0.00,0.00),('1','150','771','257841',4904445,'2941','329',272677.08,273285.59,0.00,0.00,608.51,462467.60,0.00,0.00,0.00),('1','150','771','257842',4904446,'2142','329',1545724.21,1546984.26,0.00,0.00,1260.05,957638.00,0.00,0.00,0.00),('1','150','771','257842',4904447,'2941','329',273285.59,273639.78,0.00,0.00,354.19,269184.40,0.00,0.00,0.00),('1','150','771','257843',4904448,'2142','329',1546984.26,1547321.02,0.00,0.00,336.76,269408.00,0.00,0.00,0.00),('1','150','771','257843',4904449,'2941','329',273639.78,273672.43,0.00,0.00,32.65,26120.00,0.00,0.00,0.00),('1','150','771','257844',4904450,'2142','329',1547321.02,1547348.90,0.00,0.00,27.88,22304.00,0.00,0.00,0.00),('1','150','771','257844',4904451,'2941','329',273672.43,273672.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257845',4904452,'2142','329',1547348.90,1548625.82,0.00,0.00,1276.92,1021536.00,0.00,0.00,0.00),('1','150','771','257845',4904453,'2941','329',273672.43,274069.10,0.00,0.00,396.67,317336.00,0.00,0.00,0.00),('1','150','771','257846',4904454,'2142','329',1548625.82,1549383.86,0.00,0.00,758.04,606432.00,0.00,0.00,0.00),('1','150','771','257846',4904455,'2941','329',274069.10,274684.30,0.00,0.00,615.20,492160.00,0.00,0.00,0.00),('1','150','771','257847',4904456,'2142','329',1549383.86,1550957.16,0.00,0.00,1573.30,1202308.80,0.00,0.00,0.00),('1','150','771','257847',4904457,'2941','329',274684.30,275109.21,0.00,0.00,424.91,322931.60,0.00,0.00,0.00),('1','150','771','257848',4904458,'2142','329',1550957.16,1551325.94,0.00,0.00,368.78,280272.80,0.00,0.00,0.00),('1','150','771','257848',4904459,'2941','329',275109.21,275134.87,0.00,0.00,25.66,19501.60,0.00,0.00,0.00),('1','150','771','257849',4904460,'2142','329',1551325.94,1551366.46,0.00,0.00,40.52,30795.20,0.00,0.00,0.00),('1','150','771','257849',4904461,'2941','329',275134.87,275134.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257850',4904462,'2142','329',1551366.46,1552358.35,0.00,0.00,991.89,753836.40,0.00,0.00,0.00),('1','150','771','257850',4904463,'2941','329',275134.87,275602.05,0.00,0.00,467.18,355056.80,0.00,0.00,0.00),('1','150','771','257851',4904464,'2142','329',1552358.35,1553406.86,0.00,0.00,1048.51,796867.60,0.00,0.00,0.00),('1','150','771','257851',4904465,'2941','329',275602.05,276061.32,0.00,0.00,459.27,349045.20,0.00,0.00,0.00),('1','150','771','257852',4904466,'2142','329',1553406.86,1554784.07,0.00,0.00,1377.21,1046679.60,0.00,0.00,0.00),('1','150','771','257852',4904467,'2941','329',276061.32,276348.85,0.00,0.00,287.53,218522.80,0.00,0.00,0.00),('1','150','771','257853',4904468,'2142','329',1554784.07,1555324.26,0.00,0.00,540.19,410544.40,0.00,0.00,0.00),('1','150','771','257853',4904469,'2941','329',276348.85,276498.91,0.00,0.00,150.06,114045.60,0.00,0.00,0.00),('1','150','771','257854',4904470,'2142','329',1555324.26,1555382.42,0.00,0.00,58.16,44201.60,0.00,0.00,0.00),('1','150','771','257854',4904471,'2941','329',276498.91,276498.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257855',4904472,'2142','329',1555382.42,1556133.68,0.00,0.00,751.26,570957.60,0.00,0.00,0.00),('1','150','771','257855',4904473,'2941','329',276498.91,276926.58,0.00,0.00,427.67,325029.20,0.00,0.00,0.00),('1','150','771','257856',4904474,'2142','329',1556133.68,1557594.54,0.00,0.00,1460.86,1110253.60,0.00,0.00,0.00),('1','150','771','257856',4904475,'2941','329',276926.58,277388.94,0.00,0.00,462.36,351393.60,0.00,0.00,0.00),('1','150','771','257857',4904476,'2142','329',1557594.54,1559044.21,0.00,0.00,1449.67,1101749.20,0.00,0.00,0.00),('1','150','771','257857',4904477,'2941','329',277388.94,277625.57,0.00,0.00,236.63,179838.80,0.00,0.00,0.00),('1','150','771','257858',4904478,'2142','329',1559044.21,1559044.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257858',4904479,'2941','329',277625.57,277716.35,0.00,0.00,90.78,68992.80,0.00,0.00,0.00),('1','150','771','257859',4904480,'2142','329',1559044.21,1559044.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257859',4904481,'2941','329',277716.35,277716.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257860',4904482,'2142','329',1559044.21,1559802.68,0.00,0.00,758.47,576437.20,0.00,0.00,0.00),('1','150','771','257860',4904483,'2941','329',277716.35,278274.43,0.00,0.00,558.08,424140.80,0.00,0.00,0.00),('1','150','771','257861',4904484,'2142','329',1559802.68,1560721.73,0.00,0.00,919.05,698478.00,0.00,0.00,0.00),('1','150','771','257861',4904485,'2941','329',278274.43,278780.09,0.00,0.00,505.66,384301.60,0.00,0.00,0.00),('1','150','771','257862',4904486,'2142','329',1560721.73,1561727.52,0.00,0.00,1005.79,764400.40,0.00,0.00,0.00),('1','150','771','257862',4904487,'2941','329',278780.09,279059.04,0.00,0.00,278.95,212002.00,0.00,0.00,0.00),('1','150','771','257863',4904488,'2142','329',1561727.52,1562627.17,0.00,0.00,899.65,683734.00,0.00,0.00,0.00),('1','150','771','257863',4904489,'2941','329',279059.04,279228.51,0.00,0.00,169.47,128797.20,0.00,0.00,0.00),('1','150','771','257864',4904490,'2142','329',1562627.17,1562882.05,0.00,0.00,254.88,193708.80,0.00,0.00,0.00),('1','150','771','257864',4904491,'2941','329',279228.51,279257.57,0.00,0.00,29.06,22085.60,0.00,0.00,0.00),('1','150','771','257865',4904492,'2142','329',1562882.05,1562882.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257865',4904493,'2941','329',279257.57,279257.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257866',4904494,'2142','329',1562882.05,1563608.87,0.00,0.00,726.82,552383.20,0.00,0.00,0.00),('1','150','771','257866',4904495,'2941','329',279257.57,279456.12,0.00,0.00,198.55,150898.00,0.00,0.00,0.00),('1','150','771','257867',4904496,'2142','329',1563608.87,1564776.65,0.00,0.00,1167.78,887512.80,0.00,0.00,0.00),('1','150','771','257867',4904497,'2941','329',279456.12,279752.65,0.00,0.00,296.53,225362.80,0.00,0.00,0.00),('1','150','771','257868',4904498,'2142','329',1564776.65,1566064.58,0.00,0.00,1287.93,978826.80,0.00,0.00,0.00),('1','150','771','257868',4904499,'2941','329',279752.65,280231.88,0.00,0.00,479.23,364214.80,0.00,0.00,0.00),('1','150','771','257869',4904500,'2142','329',1566064.58,1566786.64,0.00,0.00,722.06,548765.60,0.00,0.00,0.00),('1','150','771','257869',4904501,'2941','329',280231.88,280607.69,0.00,0.00,375.81,285615.60,0.00,0.00,0.00),('1','150','771','257870',4904502,'2142','329',1566786.64,1566786.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257870',4904503,'2941','329',280607.69,280607.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257871',4904504,'2142','329',1566786.64,1567854.16,0.00,0.00,1067.52,811315.20,0.00,0.00,0.00),('1','150','771','257871',4904505,'2941','329',280607.69,280864.46,0.00,0.00,256.77,195145.20,0.00,0.00,0.00),('1','150','771','257872',4904506,'2142','329',1567854.16,1569030.05,0.00,0.00,1175.89,893676.40,0.00,0.00,0.00),('1','150','771','257872',4904507,'2941','329',280864.46,281187.36,0.00,0.00,322.90,245404.00,0.00,0.00,0.00),('1','150','771','257873',4904508,'2142','329',1569030.05,1570203.30,0.00,0.00,1173.25,891670.00,0.00,0.00,0.00),('1','150','771','257873',4904509,'2941','329',281187.36,281461.92,0.00,0.00,274.56,208665.60,0.00,0.00,0.00),('1','150','771','257874',4904510,'2142','329',1570203.30,1570850.26,0.00,0.00,646.96,491689.60,0.00,0.00,0.00),('1','150','771','257874',4904511,'2941','329',281461.92,281775.03,0.00,0.00,313.11,237963.60,0.00,0.00,0.00),('1','150','771','257875',4904512,'2142','329',1570850.26,1570859.30,0.00,0.00,9.04,6870.40,0.00,0.00,0.00),('1','150','771','257875',4904513,'2941','329',281775.03,281775.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257876',4904514,'2142','329',1570859.30,1571006.43,0.00,0.00,147.13,111818.80,0.00,0.00,0.00),('1','150','771','257876',4904515,'2941','329',281775.03,281868.26,0.00,0.00,93.23,70854.80,0.00,0.00,0.00),('1','150','771','257877',4904516,'2142','329',1571006.43,1572164.51,0.00,0.00,1158.08,880140.80,0.00,0.00,0.00),('1','150','771','257877',4904517,'2941','329',281868.26,282339.33,0.00,0.00,471.07,358013.20,0.00,0.00,0.00),('1','150','771','257878',4904518,'2142','329',1572164.51,1573344.65,0.00,0.00,1180.14,896906.40,0.00,0.00,0.00),('1','150','771','257878',4904519,'2941','329',282339.33,282966.81,0.00,0.00,627.48,476884.80,0.00,0.00,0.00),('1','150','771','257879',4904520,'2142','329',1573344.65,1574399.70,0.00,0.00,1055.05,801838.00,0.00,0.00,0.00),('1','150','771','257879',4904521,'2941','329',282966.81,283353.67,0.00,0.00,386.86,294013.60,0.00,0.00,0.00),('1','150','771','257880',4904522,'2142','329',1574399.70,1574500.41,0.00,0.00,100.71,76539.60,0.00,0.00,0.00),('1','150','771','257880',4904523,'2941','329',283353.67,283353.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257881',4904524,'2142','329',1574500.41,1575387.25,0.00,0.00,886.84,673998.40,0.00,0.00,0.00),('1','150','771','257881',4904525,'2941','329',283353.67,283623.49,0.00,0.00,269.82,205063.20,0.00,0.00,0.00),('1','150','771','257882',4904526,'2142','329',1575387.25,1576602.59,0.00,0.00,1215.34,923658.40,0.00,0.00,0.00),('1','150','771','257882',4904527,'2941','329',283623.49,283770.93,0.00,0.00,147.44,112054.40,0.00,0.00,0.00),('1','150','771','257883',4904528,'2142','329',1576602.59,1577444.08,0.00,0.00,841.49,639532.40,0.00,0.00,0.00),('1','150','771','257883',4904529,'2941','329',283770.93,284123.39,0.00,0.00,352.46,267869.60,0.00,0.00,0.00),('1','150','771','257884',4904530,'2142','329',1577444.08,1578394.04,0.00,0.00,949.96,721969.60,0.00,0.00,0.00),('1','150','771','257884',4904531,'2941','329',284123.39,284483.02,0.00,0.00,359.63,273318.80,0.00,0.00,0.00),('1','150','771','257885',4904532,'2142','329',1578394.04,1578751.48,0.00,0.00,357.44,271654.40,0.00,0.00,0.00),('1','150','771','257885',4904533,'2941','329',284483.02,284505.39,0.00,0.00,22.37,17001.20,0.00,0.00,0.00),('1','150','771','257886',4904534,'2142','329',1578751.48,1579349.89,0.00,0.00,598.41,454791.60,0.00,0.00,0.00),('1','150','771','257886',4904535,'2941','329',284505.39,284801.35,0.00,0.00,295.96,224929.60,0.00,0.00,0.00),('1','150','771','257887',4904536,'2142','329',1579349.89,1581163.05,0.00,0.00,1813.16,1378001.60,0.00,0.00,0.00),('1','150','771','257887',4904537,'2941','329',284801.35,285157.66,0.00,0.00,356.31,270795.60,0.00,0.00,0.00),('1','150','771','257888',4904538,'2142','329',1581163.05,1582368.75,0.00,0.00,1205.70,916332.00,0.00,0.00,0.00),('1','150','771','257888',4904539,'2941','329',285157.66,285383.60,0.00,0.00,225.94,171714.40,0.00,0.00,0.00),('1','150','771','257889',4904540,'2142','329',1582368.75,1582998.78,0.00,0.00,630.03,478822.80,0.00,0.00,0.00),('1','150','771','257889',4904541,'2941','329',285383.60,285401.37,0.00,0.00,17.77,13505.20,0.00,0.00,0.00),('1','150','771','257890',4904542,'2142','329',1582998.78,1583382.82,0.00,0.00,384.04,291870.40,0.00,0.00,0.00),('1','150','771','257890',4904543,'2941','329',285401.37,285592.08,0.00,0.00,190.71,144939.60,0.00,0.00,0.00),('1','150','771','257891',4904544,'2142','329',1583382.82,1584432.98,0.00,0.00,1050.16,798121.60,0.00,0.00,0.00),('1','150','771','257891',4904545,'2941','329',285592.08,286101.32,0.00,0.00,509.24,387022.40,0.00,0.00,0.00),('1','150','771','257892',4904546,'2142','329',1584432.98,1585449.69,0.00,0.00,1016.71,772699.60,0.00,0.00,0.00),('1','150','771','257892',4904547,'2941','329',286101.32,286595.79,0.00,0.00,494.47,375797.20,0.00,0.00,0.00),('1','150','771','257893',4904548,'2142','329',1585449.69,1586217.31,0.00,0.00,767.62,583391.20,0.00,0.00,0.00),('1','150','771','257893',4904549,'2941','329',286595.79,287258.60,0.00,0.00,662.81,503735.60,0.00,0.00,0.00),('1','150','771','257894',4904550,'2142','329',1586217.31,1586245.47,0.00,0.00,28.16,21401.60,0.00,0.00,0.00),('1','150','771','257894',4904551,'2941','329',287258.60,287368.41,0.00,0.00,109.81,83455.60,0.00,0.00,0.00),('1','150','771','257895',4904552,'2142','329',1586245.47,1587425.64,0.00,0.00,1180.17,896929.20,0.00,0.00,0.00),('1','150','771','257895',4904553,'2941','329',287368.41,287825.17,0.00,0.00,456.76,347137.60,0.00,0.00,0.00),('1','150','771','257896',4904554,'2142','329',1587425.64,1588982.36,0.00,0.00,1556.72,1183107.20,0.00,0.00,0.00),('1','150','771','257896',4904555,'2941','329',287825.17,288172.02,0.00,0.00,346.85,263606.00,0.00,0.00,0.00),('1','150','771','257897',4904556,'2142','329',1588982.36,1589767.97,0.00,0.00,785.61,597063.60,0.00,0.00,0.00),('1','150','771','257897',4904557,'2941','329',288172.02,288998.23,0.00,0.00,826.21,627919.60,0.00,0.00,0.00),('1','150','771','257898',4904558,'2142','329',1589767.97,1589767.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257898',4904559,'2941','329',288998.23,288998.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257899',4904560,'2142','329',1589767.97,1589767.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257899',4904561,'2941','329',288998.23,288998.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257900',4904562,'2142','329',1589767.97,1590149.52,0.00,0.00,381.55,289978.00,0.00,0.00,0.00),('1','150','771','257900',4904563,'2941','329',288998.23,289655.08,0.00,0.00,656.85,499206.00,0.00,0.00,0.00),('1','150','771','257901',4904564,'2142','329',1590149.52,1591123.51,0.00,0.00,973.99,740232.40,0.00,0.00,0.00),('1','150','771','257901',4904565,'2941','329',289655.08,290142.40,0.00,0.00,487.32,370363.20,0.00,0.00,0.00),('1','150','771','257902',4904566,'2142','329',1591123.51,1591787.76,0.00,0.00,664.25,504830.00,0.00,0.00,0.00),('1','150','771','257902',4904567,'2941','329',290142.40,290802.41,0.00,0.00,660.01,501607.60,0.00,0.00,0.00),('1','150','771','257903',4904568,'2142','329',1591787.76,1591926.45,0.00,0.00,138.69,105404.40,0.00,0.00,0.00),('1','150','771','257903',4904569,'2941','329',290802.41,290956.69,0.00,0.00,154.28,117252.80,0.00,0.00,0.00),('1','150','771','257904',4904570,'2142','329',1591926.45,1592435.67,0.00,0.00,509.22,374785.92,0.00,0.00,0.00),('1','150','771','257904',4904571,'2941','329',290956.69,291318.03,0.00,0.00,361.34,265946.24,0.00,0.00,0.00),('1','150','771','257905',4904572,'2142','329',1592435.67,1592468.04,0.00,0.00,32.37,23824.32,0.00,0.00,0.00),('1','150','771','257905',4904573,'2941','329',291318.03,291318.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257906',4904574,'2142','329',1592468.04,1593573.80,0.00,0.00,1105.76,813839.36,0.00,0.00,0.00),('1','150','771','257906',4904575,'2941','329',291318.03,292241.31,0.00,0.00,923.28,679534.08,0.00,0.00,0.00),('1','150','771','257907',4904576,'2142','329',1593573.80,1594840.73,0.00,0.00,1266.93,932460.48,0.00,0.00,0.00),('1','150','771','257907',4904577,'2941','329',292241.31,293119.87,0.00,0.00,878.56,646620.16,0.00,0.00,0.00),('1','150','771','257908',4904578,'2142','329',1594840.73,1595240.00,0.00,0.00,399.27,293862.72,0.00,0.00,0.00),('1','150','771','257908',4904579,'2941','329',293119.87,293522.40,0.00,0.00,402.53,296262.08,0.00,0.00,0.00),('1','150','771','257909',4904580,'2142','329',1595240.00,1595240.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257909',4904581,'2941','329',293522.40,293522.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257910',4904582,'2142','329',1595240.00,1595569.63,0.00,0.00,329.63,242607.68,0.00,0.00,0.00),('1','150','771','257910',4904583,'2941','329',293522.40,293590.95,0.00,0.00,68.55,50452.80,0.00,0.00,0.00),('1','150','771','257911',4904584,'2142','329',1595569.63,1596817.14,0.00,0.00,1247.51,918167.36,0.00,0.00,0.00),('1','150','771','257911',4904585,'2941','329',293590.95,293810.07,0.00,0.00,219.12,161272.32,0.00,0.00,0.00),('1','150','771','257912',4904586,'2142','329',1596817.14,1597779.16,0.00,0.00,962.02,708046.72,0.00,0.00,0.00),('1','150','771','257912',4904587,'2941','329',293810.07,294109.25,0.00,0.00,299.18,220196.48,0.00,0.00,0.00),('1','150','771','257913',4904588,'2142','329',1597779.16,1598706.09,0.00,0.00,926.93,682220.48,0.00,0.00,0.00),('1','150','771','257913',4904589,'2941','329',294109.25,294586.50,0.00,0.00,477.25,351256.00,0.00,0.00,0.00),('1','150','771','257914',4904590,'2142','329',1598706.09,1599466.43,0.00,0.00,760.34,559610.24,0.00,0.00,0.00),('1','150','771','257914',4904591,'2941','329',294586.50,294989.27,0.00,0.00,402.77,296438.72,0.00,0.00,0.00),('1','150','771','257915',4904592,'2142','329',1599466.43,1601028.10,0.00,0.00,1561.67,1149389.12,0.00,0.00,0.00),('1','150','771','257915',4904593,'2941','329',294989.27,295176.12,0.00,0.00,186.85,137521.60,0.00,0.00,0.00),('1','150','771','257916',4904594,'2142','329',1601028.10,1602529.65,0.00,0.00,1501.55,1105140.80,0.00,0.00,0.00),('1','150','771','257916',4904595,'2941','329',295176.12,295642.16,0.00,0.00,466.04,343005.44,0.00,0.00,0.00),('1','150','771','257917',4904596,'2142','329',1602529.65,1603365.39,0.00,0.00,835.74,615104.64,0.00,0.00,0.00),('1','150','771','257917',4904597,'2941','329',295642.16,296211.52,0.00,0.00,569.36,419048.96,0.00,0.00,0.00),('1','150','771','257918',4904598,'2142','329',1603365.39,1603400.32,0.00,0.00,34.93,25708.48,0.00,0.00,0.00),('1','150','771','257918',4904599,'2941','329',296211.52,296211.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257919',4904600,'2142','329',1603400.32,1604440.21,0.00,0.00,1039.89,765359.04,0.00,0.00,0.00),('1','150','771','257919',4904601,'2941','329',296211.52,296618.51,0.00,0.00,406.99,299544.64,0.00,0.00,0.00),('1','150','771','257920',4904602,'2142','329',1604440.21,1605492.86,0.00,0.00,1052.65,774750.40,0.00,0.00,0.00),('1','150','771','257920',4904603,'2941','329',296618.51,297267.53,0.00,0.00,649.02,477678.72,0.00,0.00,0.00),('1','150','771','257921',4904604,'2142','329',1605492.86,1606845.15,0.00,0.00,1352.29,995285.44,0.00,0.00,0.00),('1','150','771','257921',4904605,'2941','329',297267.53,297736.30,0.00,0.00,468.77,345014.72,0.00,0.00,0.00),('1','150','771','257922',4904606,'2142','329',1606845.15,1608345.15,0.00,0.00,1500.00,1104000.00,0.00,0.00,0.00),('1','150','771','257922',4904607,'2941','329',297736.30,298259.94,0.00,0.00,523.64,385399.04,0.00,0.00,0.00),('1','150','771','257923',4904608,'2142','329',1608345.15,1610181.99,0.00,0.00,1836.84,1351914.24,0.00,0.00,0.00),('1','150','771','257923',4904609,'2941','329',298259.94,299256.72,0.00,0.00,996.78,733630.08,0.00,0.00,0.00),('1','150','771','257924',4904610,'2142','329',1610181.99,1610646.30,0.00,0.00,464.31,341732.16,0.00,0.00,0.00),('1','150','771','257924',4904611,'2941','329',299256.72,299406.06,0.00,0.00,149.34,109914.24,0.00,0.00,0.00),('1','150','771','257925',4904612,'2142','329',1610646.30,1611323.70,0.00,0.00,677.40,498566.40,0.00,0.00,0.00),('1','150','771','257925',4904613,'2941','329',299406.06,299901.24,0.00,0.00,495.18,364452.48,0.00,0.00,0.00),('1','150','771','257926',4904614,'2142','329',1611323.70,1612194.22,0.00,0.00,870.52,640702.72,0.00,0.00,0.00),('1','150','771','257926',4904615,'2941','329',299901.24,300861.20,0.00,0.00,959.96,706530.56,0.00,0.00,0.00),('1','150','771','257927',4904616,'2142','329',1612194.22,1613005.63,0.00,0.00,811.41,597197.76,0.00,0.00,0.00),('1','150','771','257927',4904617,'2941','329',300861.20,301403.79,0.00,0.00,542.59,399346.24,0.00,0.00,0.00),('1','150','771','257928',4904618,'2142','329',1613005.63,1613616.49,0.00,0.00,610.86,449592.96,0.00,0.00,0.00),('1','150','771','257928',4904619,'2941','329',301403.79,301724.58,0.00,0.00,320.79,236101.44,0.00,0.00,0.00),('1','150','771','257929',4904620,'2142','329',1613616.49,1613616.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257929',4904621,'2941','329',301724.58,301724.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257930',4904622,'2142','329',1613616.49,1614601.73,0.00,0.00,985.24,725136.64,0.00,0.00,0.00),('1','150','771','257930',4904623,'2941','329',301724.58,302371.61,0.00,0.00,647.03,476214.08,0.00,0.00,0.00),('1','150','771','257931',4904624,'2142','329',1614601.73,1615583.70,0.00,0.00,981.97,722729.92,0.00,0.00,0.00),('1','150','771','257931',4904625,'2941','329',302371.61,302844.60,0.00,0.00,472.99,348120.64,0.00,0.00,0.00),('1','150','771','257932',4904626,'2142','329',1615583.70,1616745.28,0.00,0.00,1161.58,854922.88,0.00,0.00,0.00),('1','150','771','257932',4904627,'2941','329',302844.60,303522.98,0.00,0.00,678.38,499287.68,0.00,0.00,0.00),('1','150','771','257933',4904628,'2142','329',1616745.28,1617007.99,0.00,0.00,262.71,193354.56,0.00,0.00,0.00),('1','150','771','257933',4904629,'2941','329',303522.98,303712.88,0.00,0.00,189.90,139766.40,0.00,0.00,0.00),('1','150','771','257934',4904630,'2142','329',1617007.99,1617663.46,0.00,0.00,655.47,482425.92,0.00,0.00,0.00),('1','150','771','257934',4904631,'2941','329',303712.88,304087.69,0.00,0.00,374.81,275860.16,0.00,0.00,0.00),('1','150','771','257935',4904632,'2142','329',1617663.46,1618639.21,0.00,0.00,975.75,718152.00,0.00,0.00,0.00),('1','150','771','257935',4904633,'2941','329',304087.69,304652.15,0.00,0.00,564.46,415442.56,0.00,0.00,0.00),('1','150','771','257936',4904634,'2142','329',1618639.21,1619759.00,0.00,0.00,1119.79,824165.44,0.00,0.00,0.00),('1','150','771','257936',4904635,'2941','329',304652.15,305041.62,0.00,0.00,389.47,286649.92,0.00,0.00,0.00),('1','150','771','257937',4904636,'2142','329',1619759.00,1620448.21,0.00,0.00,689.21,507258.56,0.00,0.00,0.00),('1','150','771','257937',4904637,'2941','329',305041.62,305309.79,0.00,0.00,268.17,197373.12,0.00,0.00,0.00),('1','150','771','257938',4904638,'2142','329',1620448.21,1620448.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257938',4904639,'2941','329',305309.79,305309.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257939',4904640,'2142','329',1620448.21,1620818.47,0.00,0.00,370.26,272511.36,0.00,0.00,0.00),('1','150','771','257939',4904641,'2941','329',305309.79,305451.83,0.00,0.00,142.04,104541.44,0.00,0.00,0.00),('1','150','771','257940',4904642,'2142','329',1620818.47,1621802.88,0.00,0.00,984.41,724525.76,0.00,0.00,0.00),('1','150','771','257940',4904643,'2941','329',305451.83,306103.10,0.00,0.00,651.27,479334.72,0.00,0.00,0.00),('1','150','771','257941',4904644,'2142','329',1621802.88,1622830.74,0.00,0.00,1027.86,756504.96,0.00,0.00,0.00),('1','150','771','257941',4904645,'2941','329',306103.10,306735.89,0.00,0.00,632.79,465733.44,0.00,0.00,0.00),('1','150','771','257942',4904646,'2142','329',1622830.74,1623734.86,0.00,0.00,904.12,665432.32,0.00,0.00,0.00),('1','150','771','257942',4904647,'2941','329',306735.89,307135.84,0.00,0.00,399.95,294363.20,0.00,0.00,0.00),('1','150','771','257943',4904648,'2142','329',1623734.86,1623734.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257943',4904649,'2941','329',307135.84,307135.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257944',4904650,'2142','329',1623734.86,1625431.96,0.00,0.00,1697.10,1249065.60,0.00,0.00,0.00),('1','150','771','257944',4904651,'2941','329',307135.84,308197.54,0.00,0.00,1061.70,781411.20,0.00,0.00,0.00),('1','150','771','257945',4904652,'2142','329',1625431.96,1626364.77,0.00,0.00,932.81,686548.16,0.00,0.00,0.00),('1','150','771','257945',4904653,'2941','329',308197.54,309124.35,0.00,0.00,926.81,682132.16,0.00,0.00,0.00),('1','150','771','257946',4904654,'2142','329',1626364.77,1626758.69,0.00,0.00,393.92,289925.12,0.00,0.00,0.00),('1','150','771','257946',4904655,'2941','329',309124.35,309392.99,0.00,0.00,268.64,197719.04,0.00,0.00,0.00),('1','150','771','257947',4904656,'2142','329',1626758.69,1626758.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257947',4904657,'2941','329',309392.99,309392.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257948',4904658,'2142','329',1626758.69,1627625.23,0.00,0.00,866.54,637773.44,0.00,0.00,0.00),('1','150','771','257948',4904659,'2941','329',309392.99,309865.21,0.00,0.00,472.22,347553.92,0.00,0.00,0.00),('1','150','771','257949',4904660,'2142','329',1627625.23,1628631.83,0.00,0.00,1006.60,740857.60,0.00,0.00,0.00),('1','150','771','257949',4904661,'2941','329',309865.21,310822.67,0.00,0.00,957.46,704690.56,0.00,0.00,0.00),('1','150','771','257950',4904662,'2142','329',1628631.83,1629752.06,0.00,0.00,1120.23,824489.28,0.00,0.00,0.00),('1','150','771','257950',4904663,'2941','329',310822.67,311456.63,0.00,0.00,633.96,466594.56,0.00,0.00,0.00),('1','150','771','257951',4904664,'2142','329',1629752.06,1629752.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257951',4904665,'2941','329',311456.63,311456.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257952',4904666,'2142','329',1629752.06,1630704.52,0.00,0.00,952.46,701010.56,0.00,0.00,0.00),('1','150','771','257952',4904667,'2941','329',311456.63,312154.66,0.00,0.00,698.03,513750.08,0.00,0.00,0.00),('1','150','771','257953',4904668,'2142','329',1630704.52,1632052.59,0.00,0.00,1348.07,992179.52,0.00,0.00,0.00),('1','150','771','257953',4904669,'2941','329',312154.66,313120.57,0.00,0.00,965.91,710909.76,0.00,0.00,0.00),('1','150','771','257954',4904670,'2142','329',1632052.59,1632795.52,0.00,0.00,742.93,546796.48,0.00,0.00,0.00),('1','150','771','257954',4904671,'2941','329',313120.57,313566.97,0.00,0.00,446.40,328550.40,0.00,0.00,0.00),('1','150','771','257955',4904672,'2142','329',1632795.52,1632795.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257955',4904673,'2941','329',313566.97,313566.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257956',4904674,'2142','329',1632795.52,1633924.53,0.00,0.00,1129.01,830951.36,0.00,0.00,0.00),('1','150','771','257956',4904675,'2941','329',313566.97,314265.77,0.00,0.00,698.80,514316.80,0.00,0.00,0.00),('1','150','771','257957',4904676,'2142','329',1633924.53,1635255.36,0.00,0.00,1330.83,979490.88,0.00,0.00,0.00),('1','150','771','257957',4904677,'2941','329',314265.77,314698.18,0.00,0.00,432.41,318253.76,0.00,0.00,0.00),('1','150','771','257958',4904678,'2142','329',1635255.36,1636374.83,0.00,0.00,1119.47,823929.92,0.00,0.00,0.00),('1','150','771','257958',4904679,'2941','329',314698.18,315127.29,0.00,0.00,429.11,315824.96,0.00,0.00,0.00),('1','150','771','257959',4904680,'2142','329',1636374.83,1637138.27,0.00,0.00,763.44,561891.84,0.00,0.00,0.00),('1','150','771','257959',4904681,'2941','329',315127.29,315733.82,0.00,0.00,606.53,446406.08,0.00,0.00,0.00),('1','150','771','257960',4904682,'2142','329',1637138.27,1637884.16,0.00,0.00,745.89,548975.04,0.00,0.00,0.00),('1','150','771','257960',4904683,'2941','329',315733.82,316277.24,0.00,0.00,543.42,399957.12,0.00,0.00,0.00),('1','150','771','257961',4904684,'2142','329',1637884.16,1639038.39,0.00,0.00,1154.23,849513.28,0.00,0.00,0.00),('1','150','771','257961',4904685,'2941','329',316277.24,316778.66,0.00,0.00,501.42,369045.12,0.00,0.00,0.00),('1','150','771','257962',4904686,'2142','329',1639038.39,1639605.21,0.00,0.00,566.82,417179.52,0.00,0.00,0.00),('1','150','771','257962',4904687,'2941','329',316778.66,317216.69,0.00,0.00,438.03,322390.08,0.00,0.00,0.00),('1','150','771','257963',4904688,'2142','329',1639605.21,1639605.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257963',4904689,'2941','329',317216.69,317216.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257964',4904690,'2142','329',1639605.21,1639818.47,0.00,0.00,213.26,156959.36,0.00,0.00,0.00),('1','150','771','257964',4904691,'2941','329',317216.69,317477.25,0.00,0.00,260.56,191772.16,0.00,0.00,0.00),('1','150','771','257965',4904692,'2142','329',1639818.47,1640732.50,0.00,0.00,914.03,672726.08,0.00,0.00,0.00),('1','150','771','257965',4904693,'2941','329',317477.25,317937.98,0.00,0.00,460.73,339097.28,0.00,0.00,0.00),('1','150','771','257966',4904694,'2142','329',1640732.50,1641434.88,0.00,0.00,702.38,516951.68,0.00,0.00,0.00),('1','150','771','257966',4904695,'2941','329',317937.98,318455.51,0.00,0.00,517.53,380902.08,0.00,0.00,0.00),('1','150','771','257967',4904696,'2142','329',1641434.88,1641968.65,0.00,0.00,533.77,392854.72,0.00,0.00,0.00),('1','150','771','257967',4904697,'2941','329',318455.51,318991.34,0.00,0.00,535.83,394370.88,0.00,0.00,0.00),('1','150','771','257968',4904698,'2142','329',1641968.65,1642249.32,0.00,0.00,280.67,206573.12,0.00,0.00,0.00),('1','150','771','257968',4904699,'2941','329',318991.34,319145.58,0.00,0.00,154.24,113520.64,0.00,0.00,0.00),('1','150','771','257969',4904700,'2142','329',1642249.32,1642878.35,0.00,0.00,629.03,462966.08,0.00,0.00,0.00),('1','150','771','257969',4904701,'2941','329',319145.58,319525.83,0.00,0.00,380.25,279864.00,0.00,0.00,0.00),('1','150','771','257970',4904702,'2142','329',1642878.35,1643702.48,0.00,0.00,824.13,606559.68,0.00,0.00,0.00),('1','150','771','257970',4904703,'2941','329',319525.83,319969.35,0.00,0.00,443.52,326430.72,0.00,0.00,0.00),('1','150','771','257971',4904704,'2142','329',1643702.48,1644535.94,0.00,0.00,833.46,613426.56,0.00,0.00,0.00),('1','150','771','257971',4904705,'2941','329',319969.35,320677.08,0.00,0.00,707.73,520889.28,0.00,0.00,0.00),('1','150','771','257972',4904706,'2142','329',1644535.94,1645452.55,0.00,0.00,916.61,674624.96,0.00,0.00,0.00),('1','150','771','257972',4904707,'2941','329',320677.08,321509.35,0.00,0.00,832.27,612550.72,0.00,0.00,0.00),('1','150','771','257973',4904708,'2142','329',1645452.55,1645452.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257973',4904709,'2941','329',321509.35,321509.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257974',4904710,'2142','329',1645452.55,1646435.11,0.00,0.00,982.56,723164.16,0.00,0.00,0.00),('1','150','771','257974',4904711,'2941','329',321509.35,321768.55,0.00,0.00,259.20,190771.20,0.00,0.00,0.00),('1','150','771','257975',4904712,'2142','329',1646435.11,1647388.98,0.00,0.00,953.87,702048.32,0.00,0.00,0.00),('1','150','771','257975',4904713,'2941','329',321768.55,322241.29,0.00,0.00,472.74,347936.64,0.00,0.00,0.00),('1','150','771','257976',4904714,'2142','329',1647388.98,1648175.72,0.00,0.00,786.74,579040.64,0.00,0.00,0.00),('1','150','771','257976',4904715,'2941','329',322241.29,322761.63,0.00,0.00,520.34,382970.24,0.00,0.00,0.00),('1','150','771','257977',4904716,'2142','329',1648175.72,1648835.58,0.00,0.00,659.86,485656.96,0.00,0.00,0.00),('1','150','771','257977',4904717,'2941','329',322761.63,323257.89,0.00,0.00,496.26,365247.36,0.00,0.00,0.00),('1','150','771','257978',4904718,'2142','329',1648835.58,1648835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257978',4904719,'2941','329',323257.89,323257.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257979',4904720,'2142','329',1648835.58,1648835.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257979',4904721,'2941','329',323257.89,323257.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257980',4904722,'2142','329',1648835.58,1648996.76,0.00,0.00,161.18,118628.48,0.00,0.00,0.00),('1','150','771','257980',4904723,'2941','329',323257.89,323466.07,0.00,0.00,208.18,153220.48,0.00,0.00,0.00),('1','150','771','257981',4904724,'2142','329',1648996.76,1649855.17,0.00,0.00,858.41,631789.76,0.00,0.00,0.00),('1','150','771','257981',4904725,'2941','329',323466.07,324202.95,0.00,0.00,736.88,542343.68,0.00,0.00,0.00),('1','150','771','257982',4904726,'2142','329',1649855.17,1651175.93,0.00,0.00,1320.76,972079.36,0.00,0.00,0.00),('1','150','771','257982',4904727,'2941','329',324202.95,324743.56,0.00,0.00,540.61,397888.96,0.00,0.00,0.00),('1','150','771','257983',4904728,'2142','329',1651175.93,1652470.92,0.00,0.00,1294.99,953112.64,0.00,0.00,0.00),('1','150','771','257983',4904729,'2941','329',324743.56,325152.56,0.00,0.00,409.00,301024.00,0.00,0.00,0.00),('1','150','771','257984',4904730,'2142','329',1652470.92,1652575.33,0.00,0.00,104.41,76845.76,0.00,0.00,0.00),('1','150','771','257984',4904731,'2941','329',325152.56,325222.14,0.00,0.00,69.58,51210.88,0.00,0.00,0.00),('1','150','771','257985',4904732,'2142','329',1652575.33,1653348.33,0.00,0.00,773.00,568928.00,0.00,0.00,0.00),('1','150','771','257985',4904733,'2941','329',325222.14,325766.46,0.00,0.00,544.32,400619.52,0.00,0.00,0.00),('1','150','771','257986',4904734,'2142','329',1653348.33,1654318.14,0.00,0.00,969.81,713780.16,0.00,0.00,0.00),('1','150','771','257986',4904735,'2941','329',325766.46,326194.98,0.00,0.00,428.52,315390.72,0.00,0.00,0.00),('1','150','771','257987',4904736,'2142','329',1654318.14,1655071.57,0.00,0.00,753.43,554524.48,0.00,0.00,0.00),('1','150','771','257987',4904737,'2941','329',326194.98,327004.37,0.00,0.00,809.39,595711.04,0.00,0.00,0.00),('1','150','771','257988',4904738,'2142','329',1655071.57,1655606.52,0.00,0.00,534.95,393723.20,0.00,0.00,0.00),('1','150','771','257988',4904739,'2941','329',327004.37,327326.42,0.00,0.00,322.05,237028.80,0.00,0.00,0.00),('1','150','771','257989',4904740,'2142','329',1655606.52,1655606.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257989',4904741,'2941','329',327326.42,327326.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257990',4904742,'2142','329',1655606.52,1655606.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257990',4904743,'2941','329',327326.42,327326.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','257991',4904744,'2142','329',1655606.52,1655825.87,0.00,0.00,219.35,161441.60,0.00,0.00,0.00),('1','150','771','257991',4904745,'2941','329',327326.42,327483.66,0.00,0.00,157.24,115728.64,0.00,0.00,0.00),('1','150','771','257992',4904746,'2142','329',1655825.87,1656477.72,0.00,0.00,651.85,479761.60,0.00,0.00,0.00),('1','150','771','257992',4904747,'2941','329',327483.66,328168.26,0.00,0.00,684.60,503865.60,0.00,0.00,0.00),('1','150','771','257993',4904748,'2142','329',1656477.72,1657352.59,0.00,0.00,874.87,643904.32,0.00,0.00,0.00),('1','150','771','257993',4904749,'2941','329',328168.26,328937.65,0.00,0.00,769.39,566271.04,0.00,0.00,0.00),('1','150','771','257994',4904750,'2142','329',1657352.59,1658695.76,0.00,0.00,1343.17,988573.12,0.00,0.00,0.00),('1','150','771','257994',4904751,'2941','329',328937.65,329593.26,0.00,0.00,655.61,482528.96,0.00,0.00,0.00),('1','150','771','257995',4904752,'2142','329',1658695.76,1658746.33,0.00,0.00,50.57,37219.52,0.00,0.00,0.00),('1','150','771','257995',4904753,'2941','329',329593.26,329675.33,0.00,0.00,82.07,60403.52,0.00,0.00,0.00),('1','150','771','257996',4904754,'2142','329',1658746.33,1659634.33,0.00,0.00,888.00,653568.00,0.00,0.00,0.00),('1','150','771','257996',4904755,'2941','329',329675.33,330069.41,0.00,0.00,394.08,290042.88,0.00,0.00,0.00),('1','150','771','257997',4904756,'2142','329',1659634.33,1660438.36,0.00,0.00,804.03,591766.08,0.00,0.00,0.00),('1','150','771','257997',4904757,'2941','329',330069.41,330667.54,0.00,0.00,598.13,440223.68,0.00,0.00,0.00),('1','150','771','257998',4904758,'2142','329',1660438.36,1661145.29,0.00,0.00,706.93,520300.48,0.00,0.00,0.00),('1','150','771','257998',4904759,'2941','329',330667.54,331187.11,0.00,0.00,519.57,382403.52,0.00,0.00,0.00),('1','150','771','257999',4904760,'2142','329',1661145.29,1662104.51,0.00,0.00,959.22,705985.92,0.00,0.00,0.00),('1','150','771','257999',4904761,'2941','329',331187.11,331492.34,0.00,0.00,305.23,224649.28,0.00,0.00,0.00),('1','150','771','258000',4904762,'2142','329',1662104.51,1663194.08,0.00,0.00,1089.57,801923.52,0.00,0.00,0.00),('1','150','771','258000',4904763,'2941','329',331492.34,331631.36,0.00,0.00,139.02,102318.72,0.00,0.00,0.00),('1','150','771','258001',4904764,'2142','329',1663194.08,1664679.47,0.00,0.00,1485.39,1093247.04,0.00,0.00,0.00),('1','150','771','258001',4904765,'2941','329',331631.36,331836.20,0.00,0.00,204.84,150762.24,0.00,0.00,0.00),('1','150','771','258002',4904766,'2142','329',1664679.47,1666251.17,0.00,0.00,1571.70,1156771.20,0.00,0.00,0.00),('1','150','771','258002',4904767,'2941','329',331836.20,332252.05,0.00,0.00,415.85,306065.60,0.00,0.00,0.00),('1','150','771','258003',4904768,'2142','329',1666251.17,1667089.28,0.00,0.00,838.11,616848.96,0.00,0.00,0.00),('1','150','771','258003',4904769,'2941','329',332252.05,332527.43,0.00,0.00,275.38,202679.68,0.00,0.00,0.00),('1','150','771','258004',4904770,'2142','329',1667089.28,1667677.99,0.00,0.00,588.71,433290.56,0.00,0.00,0.00),('1','150','771','258004',4904771,'2941','329',332527.43,332929.08,0.00,0.00,401.65,295614.40,0.00,0.00,0.00),('1','150','771','258005',4904772,'2142','329',1667677.99,1668569.90,0.00,0.00,891.91,656445.76,0.00,0.00,0.00),('1','150','771','258005',4904773,'2941','329',332929.08,333519.68,0.00,0.00,590.60,434681.60,0.00,0.00,0.00),('1','150','771','258006',4904774,'2142','329',1668569.90,1669732.87,0.00,0.00,1162.97,855945.92,0.00,0.00,0.00),('1','150','771','258006',4904775,'2941','329',333519.68,334099.04,0.00,0.00,579.36,426408.96,0.00,0.00,0.00),('1','150','771','258007',4904776,'2142','329',1669732.87,1671005.89,0.00,0.00,1273.02,936942.72,0.00,0.00,0.00),('1','150','771','258007',4904777,'2941','329',334099.04,334775.17,0.00,0.00,676.13,497631.68,0.00,0.00,0.00),('1','150','771','258008',4904778,'2142','329',1671005.89,1672933.38,0.00,0.00,1927.49,1418632.64,0.00,0.00,0.00),('1','150','771','258008',4904779,'2941','329',334775.17,335112.01,0.00,0.00,336.84,247914.24,0.00,0.00,0.00),('1','150','771','258009',4904780,'2142','329',1672933.38,1673767.25,0.00,0.00,833.87,613728.32,0.00,0.00,0.00),('1','150','771','258009',4904781,'2941','329',335112.01,335902.64,0.00,0.00,790.63,581903.68,0.00,0.00,0.00),('1','150','771','258010',4904782,'2142','329',1673767.25,1674778.64,0.00,0.00,1011.39,744383.04,0.00,0.00,0.00),('1','150','771','258010',4904783,'2941','329',335902.64,336252.73,0.00,0.00,350.09,257666.24,0.00,0.00,0.00),('1','150','771','258011',4904784,'2142','329',1674778.64,1675424.72,0.00,0.00,646.08,475514.88,0.00,0.00,0.00),('1','150','771','258011',4904785,'2941','329',336252.73,336949.78,0.00,0.00,697.05,513028.80,0.00,0.00,0.00),('1','150','771','258012',4904786,'2142','329',1675424.72,1676445.81,0.00,0.00,1021.09,751522.24,0.00,0.00,0.00),('1','150','771','258012',4904787,'2941','329',336949.78,337211.34,0.00,0.00,261.56,192508.16,0.00,0.00,0.00),('1','150','771','258013',4904788,'2142','329',1676445.81,1676665.65,0.00,0.00,219.84,161802.24,0.00,0.00,0.00),('1','150','771','258013',4904789,'2941','329',337211.34,337240.58,0.00,0.00,29.24,21520.64,0.00,0.00,0.00),('1','150','771','258014',4904790,'2142','329',1676665.65,1677493.85,0.00,0.00,828.20,609555.20,0.00,0.00,0.00),('1','150','771','258014',4904791,'2941','329',337240.58,337346.56,0.00,0.00,105.98,78001.28,0.00,0.00,0.00),('1','150','771','258015',4904792,'2142','329',1677493.85,1678563.09,0.00,0.00,1069.24,786960.64,0.00,0.00,0.00),('1','150','771','258015',4904793,'2941','329',337346.56,337876.55,0.00,0.00,529.99,390072.64,0.00,0.00,0.00),('1','150','771','258016',4904794,'2142','329',1678563.09,1679985.16,0.00,0.00,1422.07,1046643.52,0.00,0.00,0.00),('1','150','771','258016',4904795,'2941','329',337876.55,338365.77,0.00,0.00,489.22,360065.92,0.00,0.00,0.00),('1','150','771','258017',4904796,'2142','329',1679985.16,1680830.15,0.00,0.00,844.99,621912.64,0.00,0.00,0.00),('1','150','771','258017',4904797,'2941','329',338365.77,338701.22,0.00,0.00,335.45,246891.20,0.00,0.00,0.00),('1','150','771','258018',4904798,'2142','329',1680830.15,1681637.77,0.00,0.00,807.62,594408.32,0.00,0.00,0.00),('1','150','771','258018',4904799,'2941','329',338701.22,339031.00,0.00,0.00,329.78,242718.08,0.00,0.00,0.00),('1','150','771','258019',4904800,'2142','329',1681637.77,1682190.64,0.00,0.00,552.87,387009.00,0.00,0.00,0.00),('1','150','771','258019',4904801,'2941','329',339031.00,339641.58,0.00,0.00,610.58,427406.00,0.00,0.00,0.00),('1','150','771','258020',4904802,'2142','329',1682190.64,1682992.69,0.00,0.00,802.05,561435.00,0.00,0.00,0.00),('1','150','771','258020',4904803,'2941','329',339641.58,340237.99,0.00,0.00,596.41,417487.00,0.00,0.00,0.00),('1','150','771','258021',4904804,'2142','329',1682992.69,1683402.15,0.00,0.00,409.46,286622.00,0.00,0.00,0.00),('1','150','771','258021',4904805,'2941','329',340237.99,340665.41,0.00,0.00,427.42,299194.00,0.00,0.00,0.00),('1','150','771','258022',4904806,'2142','329',1683402.15,1683519.93,0.00,0.00,117.78,82446.00,0.00,0.00,0.00),('1','150','771','258022',4904807,'2941','329',340665.41,340724.12,0.00,0.00,58.71,41097.00,0.00,0.00,0.00),('1','150','771','258023',4904808,'2142','329',1683519.93,1684555.29,0.00,0.00,1035.36,724752.00,0.00,0.00,0.00),('1','150','771','258023',4904809,'2941','329',340724.12,341277.55,0.00,0.00,553.43,387401.00,0.00,0.00,0.00),('1','150','771','258024',4904810,'2142','329',1684555.29,1685472.71,0.00,0.00,917.42,642194.00,0.00,0.00,0.00),('1','150','771','258024',4904811,'2941','329',341277.55,341694.29,0.00,0.00,416.74,291718.00,0.00,0.00,0.00),('1','150','771','258025',4904812,'2142','329',1685472.71,1686455.53,0.00,0.00,982.82,687974.00,0.00,0.00,0.00),('1','150','771','258025',4904813,'2941','329',341694.29,341998.56,0.00,0.00,304.27,212989.00,0.00,0.00,0.00),('1','150','771','258026',4904814,'2142','329',1686455.53,1686722.98,0.00,0.00,267.45,187215.00,0.00,0.00,0.00),('1','150','771','258026',4904815,'2941','329',341998.56,341998.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','150','771','258027',4904816,'2142','329',1686722.98,1687317.33,0.00,0.00,594.35,416045.00,0.00,0.00,0.00),('1','150','771','258027',4904817,'2941','329',341998.56,342651.60,0.00,0.00,653.04,457128.00,0.00,0.00,0.00),('1','150','771','258028',4904818,'2142','329',1687317.33,1687979.59,0.00,0.00,662.26,463582.00,0.00,0.00,0.00),('1','150','771','258028',4904819,'2941','329',342651.60,343236.69,0.00,0.00,585.09,409563.00,0.00,0.00,0.00),('1','150','771','258029',4904820,'2142','329',1687979.59,1688981.35,0.00,0.00,1001.76,701232.00,0.00,0.00,0.00),('1','150','771','258029',4904821,'2941','329',343236.69,343494.72,0.00,0.00,258.03,180621.00,0.00,0.00,0.00),('1','150','771','258030',4904822,'2142','329',1688981.35,1689591.27,0.00,0.00,609.92,426944.00,0.00,0.00,0.00),('1','150','771','258030',4904823,'2941','329',343494.72,344038.84,0.00,0.00,544.12,380884.00,0.00,0.00,0.00),('1','150','771','258031',4904824,'2142','329',1689591.27,1690288.69,0.00,0.00,697.42,488194.00,0.00,0.00,0.00),('1','150','771','258031',4904825,'2941','329',344038.84,344294.09,0.00,0.00,255.25,178675.00,0.00,0.00,0.00),('1','150','771','258032',4904826,'2142','329',1690288.69,1690498.00,0.00,0.00,209.31,146517.00,0.00,0.00,0.00),('1','150','771','258032',4904827,'2941','329',344294.09,344405.01,0.00,0.00,110.92,77644.00,0.00,0.00,0.00),('1','150','771','258033',4904828,'2142','329',1690498.00,1691367.69,0.00,0.00,869.69,608783.00,0.00,0.00,0.00),('1','150','771','258033',4904829,'2941','329',344405.01,345362.29,0.00,0.00,957.28,670096.00,0.00,0.00,0.00),('1','150','771','258034',4904830,'2142','329',1691367.69,1692290.29,0.00,0.00,922.60,645820.00,0.00,0.00,0.00),('1','150','771','258034',4904831,'2941','329',345362.29,345959.55,0.00,0.00,597.26,418082.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730202 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','150','146984','329',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441517),('1','150','147007','329',210.00,280.00,0.00,2028.89,426066.90,568089.20,142022.30,441567),('1','150','147030','329',210.00,280.00,0.00,2696.67,566300.70,755067.60,188766.90,441611),('1','150','147070','329',210.00,280.00,0.00,2582.50,542325.00,723100.00,180775.00,441714),('1','150','147079','329',210.00,280.00,0.00,2009.82,422062.20,562749.60,140687.40,441727),('1','150','147085','329',210.00,280.00,0.00,3339.00,701190.00,934920.00,233730.00,441735),('1','150','147092','329',210.00,280.00,0.00,1947.32,408937.20,545249.60,136312.40,441746),('1','150','147094','329',210.00,280.00,0.00,2324.64,488174.40,650899.20,162724.80,441748),('1','150','147099','329',210.00,280.00,0.00,283.00,59430.00,79240.00,19810.00,441755),('1','150','147156','329',210.00,280.00,0.00,1353.03,284136.30,378848.40,94712.10,441880),('1','150','147305','329',210.00,280.00,0.00,2529.10,531111.00,708148.00,177037.00,442192),('1','150','147381','329',210.00,280.00,0.00,1360.00,285600.00,380800.00,95200.00,442405),('1','150','147508','329',210.00,280.00,0.00,2536.00,532560.00,710080.00,177520.00,442754),('1','150','147668','329',210.00,280.00,0.00,1026.00,215460.00,287280.00,71820.00,443187),('1','150','147861','329',210.00,280.00,0.00,2659.75,558547.50,744730.00,186182.50,443715),('1','150','147985','329',210.00,280.00,0.00,2392.21,502364.10,669818.80,167454.70,444036),('1','150','148004','329',210.00,280.00,0.00,308.00,64680.00,86240.00,21560.00,444075),('1','150','148123','329',222.00,280.00,0.00,1714.64,380650.08,480099.20,99449.12,444396),('1','150','148271','329',222.00,280.00,0.00,2191.60,486535.20,613648.00,127112.80,444774),('1','150','148366','329',222.00,280.00,0.00,1343.00,298146.00,376040.00,77894.00,445036),('1','150','148555','329',222.00,280.00,0.00,3526.00,782772.00,987280.00,204508.00,445527),('1','150','148810','329',222.00,280.00,0.00,1397.00,310134.00,391160.00,81026.00,446172),('1','150','148966','329',222.00,280.00,0.00,2684.82,596030.04,751749.60,155719.56,446588),('1','150','149027','329',222.00,280.00,0.00,1148.00,254856.00,321440.00,66584.00,446746),('1','150','149034','329',222.00,280.00,0.00,60.00,13320.00,16800.00,3480.00,446765),('1','150','149145','329',225.00,280.00,0.00,1304.71,293559.75,365318.80,71759.05,447069),('1','150','149300','329',225.00,280.00,0.00,3118.00,701550.00,873040.00,171490.00,447469),('1','150','149449','329',225.00,280.00,0.00,2767.64,622719.00,774939.20,152220.20,447870),('1','150','149601','329',225.00,280.00,0.00,2485.00,559125.00,695800.00,136675.00,448287),('1','150','149689','329',225.00,280.00,0.00,3581.60,805860.00,1002848.00,196988.00,448520),('1','150','149753','329',225.00,280.00,0.00,1251.00,281475.00,350280.00,68805.00,448689),('1','150','149836','329',225.00,280.00,0.00,1476.42,332194.50,413397.60,81203.10,448915),('1','150','150030','329',225.00,280.00,0.00,3858.00,868050.00,1080240.00,212190.00,449413),('1','150','150148','329',225.00,280.00,0.00,2025.32,455697.00,567089.60,111392.60,449740),('1','150','150315','329',225.00,280.00,0.00,1774.00,399150.00,496720.00,97570.00,450171),('1','150','150544','329',225.00,280.00,0.00,3768.25,847856.25,1055110.00,207253.75,450784),('1','150','150654','329',225.00,280.00,0.00,1613.00,362925.00,451640.00,88715.00,451066),('1','150','150841','329',225.00,280.00,0.00,2057.85,463016.25,576198.00,113181.75,451562),('1','150','150987','329',225.00,280.00,0.00,2921.64,657369.00,818059.20,160690.20,451948),('1','150','151029','329',225.00,280.00,0.00,316.00,71100.00,88480.00,17380.00,452054),('1','150','151136','329',225.00,280.00,0.00,2230.53,501869.25,624548.40,122679.15,452350),('1','150','151287','329',225.00,280.00,0.00,2973.00,668925.00,832440.00,163515.00,452758),('1','150','151423','329',225.00,280.00,0.00,1132.25,254756.25,317030.00,62273.75,453134),('1','150','151582','329',225.00,280.00,0.00,2354.57,529778.25,659279.60,129501.35,453572),('1','150','151663','329',225.00,280.00,0.00,1913.00,430425.00,535640.00,105215.00,453797),('1','150','151813','329',225.00,280.00,0.00,4057.85,913016.25,1136198.00,223181.75,454188),('1','150','151990','329',225.00,280.00,0.00,1865.00,419625.00,522200.00,102575.00,454673),('1','150','152159','329',225.00,280.00,0.00,2478.39,557637.75,693949.20,136311.45,455111),('1','150','152306','329',225.00,280.00,0.00,1922.00,432450.00,538160.00,105710.00,455501),('1','150','152473','329',225.00,280.00,0.00,1404.50,316012.50,393260.00,77247.50,455947),('1','150','152608','329',225.00,280.00,0.00,2387.03,537081.75,668368.40,131286.65,456311),('1','150','152683','329',225.00,280.00,0.00,1677.00,377325.00,469560.00,92235.00,456501),('1','150','152889','329',225.00,280.00,0.00,4369.28,983088.00,1223398.40,240310.40,457065),('1','150','153024','329',225.00,280.00,0.00,1302.00,292950.00,364560.00,71610.00,457442),('1','150','153260','329',225.00,280.00,0.00,3420.94,769711.50,957863.20,188151.70,458079),('1','150','153468','329',225.00,280.00,0.00,2299.71,517434.75,643918.80,126484.05,458654),('1','150','153530','329',225.00,280.00,0.00,546.00,122850.00,152880.00,30030.00,458807),('1','150','153635','329',225.00,280.00,0.00,1541.32,346797.00,431569.60,84772.60,459093),('1','150','153795','329',225.00,280.00,0.00,2394.28,538713.00,670398.40,131685.40,459528),('1','150','153877','329',225.00,280.00,0.00,1859.00,418275.00,520520.00,102245.00,459733),('1','150','153916','329',225.00,280.00,0.00,1116.96,251316.00,312748.80,61432.80,459841),('1','150','154236','329',225.00,280.00,0.00,869.00,195525.00,243320.00,47795.00,460693),('1','150','154415','329',225.00,280.00,0.00,3052.03,686706.75,854568.40,167861.65,461154),('1','150','154432','329',225.00,280.00,0.00,631.00,141975.00,176680.00,34705.00,461201),('1','150','154589','329',225.00,280.00,0.00,768.03,172806.75,215048.40,42241.65,461634),('1','150','154721','329',225.00,280.00,0.00,4131.35,929553.75,1156778.00,227224.25,462005),('1','150','154849','329',225.00,280.00,0.00,1619.00,364275.00,453320.00,89045.00,462359),('1','150','155111','329',231.00,280.00,0.00,3556.39,821526.09,995789.20,174263.11,463068),('1','150','155299','329',231.00,280.00,0.00,1884.00,435204.00,527520.00,92316.00,463563),('1','150','155452','329',231.00,280.00,0.00,2268.92,524120.52,635297.60,111177.08,463972),('1','150','155635','329',231.00,280.00,0.00,3248.00,750288.00,909440.00,159152.00,464479),('1','150','155774','329',231.00,280.00,0.00,2444.64,564711.84,684499.20,119787.36,464849),('1','150','155936','329',231.00,280.00,0.00,2417.85,558523.35,676998.00,118474.65,465258),('1','150','156087','329',231.00,280.00,0.00,357.00,82467.00,99960.00,17493.00,465662),('1','150','156112','329',231.00,280.00,0.00,2291.96,529442.76,641748.80,112306.04,465725),('1','150','156196','329',231.00,280.00,0.00,2963.28,684517.68,829718.40,145200.72,465953),('1','150','156407','329',231.00,280.00,0.00,2201.42,508528.02,616397.60,107869.58,466511),('1','150','156561','329',231.00,280.00,0.00,2248.21,519336.51,629498.80,110162.29,466929),('1','150','156646','329',231.00,280.00,0.00,1111.00,256641.00,311080.00,54439.00,467157),('1','150','157072','329',211.00,280.00,0.00,2095.17,442080.87,586647.60,144566.73,468311),('1','150','157268','329',211.00,280.00,0.00,3040.57,641560.27,851359.60,209799.33,468813),('1','150','157312','329',211.00,280.00,0.00,843.00,177873.00,236040.00,58167.00,468919),('1','150','157441','329',231.00,280.00,0.00,1266.60,292584.60,354648.00,62063.40,469253),('1','150','157643','329',231.00,280.00,0.00,2340.00,540540.00,655200.00,114660.00,469781),('1','150','157804','329',231.00,280.00,0.00,2017.00,465927.00,564760.00,98833.00,470213),('1','150','158090','329',231.00,280.00,0.00,2712.32,626545.92,759449.60,132903.68,470956),('1','150','158252','329',231.00,280.00,0.00,1966.57,454277.67,550639.60,96361.93,471397),('1','150','158293','329',231.00,280.00,0.00,972.00,224532.00,272160.00,47628.00,471495),('1','150','158414','329',231.00,280.00,0.00,1787.00,412797.00,500360.00,87563.00,471828),('1','150','158568','329',231.00,280.00,0.00,2819.00,651189.00,789320.00,138131.00,472217),('1','150','158625','329',231.00,280.00,0.00,835.00,192885.00,233800.00,40915.00,472367),('1','150','158752','329',231.00,280.00,0.00,1351.00,312081.00,378280.00,66199.00,472703),('1','150','158932','329',231.00,280.00,0.00,971.42,224398.02,271997.60,47599.58,473168),('1','150','158933','329',231.00,296.00,0.00,908.41,209842.71,268889.36,59046.65,473169),('1','150','159114','329',231.00,296.00,0.00,2759.15,637363.65,816708.40,179344.75,473659),('1','150','159115','329',231.00,296.00,0.00,0.00,0.00,0.00,0.00,473660),('1','150','159265','329',211.00,296.00,0.00,3187.37,672535.07,943461.52,270926.45,474087),('1','150','159424','329',211.00,296.00,0.00,1837.20,387649.20,543811.20,156162.00,474473),('1','150','159428','329',211.00,296.00,0.00,0.00,0.00,0.00,0.00,474479),('1','150','159629','329',221.00,296.00,0.00,2061.31,455549.51,610147.76,154598.25,475013),('1','150','159630','329',221.00,304.00,0.00,1600.79,353774.59,486640.16,132865.57,475014),('1','150','159673','329',221.00,304.00,0.00,1527.13,337495.73,464247.52,126751.79,475107),('1','150','159674','329',221.00,304.00,0.00,0.00,0.00,0.00,0.00,475108),('1','150','159734','329',225.00,304.00,0.00,1624.86,365593.50,493957.44,128363.94,475259),('1','150','159930','329',225.00,304.00,0.00,2573.22,578974.50,782258.88,203284.38,475777),('1','150','159997','329',225.00,304.00,0.00,700.65,157646.25,212997.60,55351.35,475939),('1','150','159999','329',225.00,304.00,0.00,0.00,0.00,0.00,0.00,475944),('1','150','160126','329',225.00,304.00,0.00,1759.53,395894.25,534897.12,139002.87,476269),('1','150','160308','329',225.00,304.00,0.00,2469.24,555579.00,750648.96,195069.96,476750),('1','150','160343','329',225.00,320.00,0.00,809.34,182101.50,258988.80,76887.30,476844),('1','150','160347','329',225.00,320.00,0.00,0.00,0.00,0.00,0.00,476854),('1','150','160452','329',235.00,320.00,0.00,1381.09,324556.15,441948.80,117392.65,477133),('1','150','160586','329',235.00,320.00,0.00,2327.50,546962.50,744800.00,197837.50,477491),('1','150','160663','329',235.00,320.00,0.00,1169.53,274839.55,374249.60,99410.05,477675),('1','150','160665','329',235.00,320.00,0.00,0.00,0.00,0.00,0.00,477679),('1','150','160746','329',235.00,320.00,0.00,1788.50,420297.50,572320.00,152022.50,477890),('1','150','160889','329',235.00,320.00,0.00,2880.06,676814.10,921619.20,244805.10,478239),('1','150','160952','329',235.00,320.00,0.00,585.93,137693.55,187497.60,49804.05,478401),('1','150','160956','329',235.00,320.00,0.00,0.00,0.00,0.00,0.00,478409),('1','150','161090','329',235.00,320.00,0.00,1294.28,304155.80,414169.60,110013.80,478780),('1','150','161285','329',235.00,320.00,0.00,1856.90,436371.50,594208.00,157836.50,479273),('1','150','161462','329',235.00,320.00,0.00,1459.75,343041.25,467120.00,124078.75,479722),('1','150','161465','329',235.00,320.00,0.00,0.00,0.00,0.00,0.00,479727),('1','150','161468','329',235.00,320.00,0.00,867.56,203876.60,277619.20,73742.60,479732),('1','150','161660','329',235.00,320.00,0.00,2292.03,538627.05,733449.60,194822.55,480236),('1','150','161861','329',235.00,320.00,0.00,2034.59,478128.65,651068.80,172940.15,480738),('1','150','162239','329',235.00,304.00,0.00,3511.11,825110.85,1067377.44,242266.59,481723),('1','150','162417','329',235.00,304.00,0.00,304.00,71440.00,499776.00,428336.00,482193),('1','150','162890','329',237.00,304.00,0.00,3239.65,767797.05,984853.60,217056.55,483398),('1','150','162999','329',237.00,304.00,0.00,1930.00,457410.00,586720.00,129310.00,483691),('1','150','163199','329',237.00,304.00,0.00,2280.82,540554.34,693369.28,152814.94,484191),('1','150','163366','329',237.00,304.00,0.00,2888.52,684579.24,878110.08,193530.84,484629),('1','150','163545','329',260.00,304.00,0.00,3197.53,831357.80,972049.12,140691.32,485096),('1','150','163660','329',260.00,304.00,0.00,586.77,152560.20,178378.08,25817.88,485396),('1','150','163741','329',237.00,304.00,0.00,1550.69,367513.53,471409.76,103896.23,485609),('1','150','163898','329',237.00,304.00,0.00,2328.02,551740.74,707718.08,155977.34,486016),('1','150','163991','329',237.00,304.00,0.00,396.21,93901.77,120447.84,26546.07,486257),('1','150','164077','329',237.00,304.00,0.00,1285.27,304608.99,390722.08,86113.09,486486),('1','150','164256','329',237.00,304.00,0.00,2437.89,577779.93,741118.56,163338.63,486959),('1','150','164440','329',237.00,304.00,0.00,1486.25,352241.25,451820.00,99578.75,487451),('1','150','164600','329',237.00,304.00,0.00,3550.03,841357.11,1079209.12,237852.01,487884),('1','150','164657','329',237.00,304.00,0.00,1364.96,323495.52,414947.84,91452.32,488033),('1','150','164795','329',237.00,304.00,0.00,1815.88,430363.56,552027.52,121663.96,488405),('1','150','164990','329',237.00,304.00,0.00,2046.54,485029.98,622148.16,137118.18,488887),('1','150','164993','329',237.00,320.00,0.00,587.57,139254.09,188022.40,48768.31,488894),('1','150','165129','329',237.00,320.00,0.00,1957.06,463823.22,626259.20,162435.98,489252),('1','150','165306','329',237.00,304.00,0.00,2544.34,603008.58,773479.36,170470.78,489713),('1','150','165364','329',237.00,304.00,0.00,530.50,125728.50,161272.00,35543.50,489857),('1','150','165438','329',287.00,304.00,0.00,2336.15,670475.05,710189.60,39714.55,490067),('1','150','165602','329',287.00,304.00,0.00,2408.50,691239.50,732184.00,40944.50,490494),('1','150','165791','329',287.00,304.00,0.00,3343.51,959587.37,1016427.04,56839.67,491005),('1','150','165926','329',287.00,304.00,0.00,1986.51,570128.37,603899.04,33770.67,491363),('1','150','165966','329',287.00,304.00,0.00,1041.50,298910.50,316616.00,17705.50,491464),('1','150','166136','329',287.00,304.00,0.00,2616.60,750964.20,795446.40,44482.20,491913),('1','150','166229','329',287.00,304.00,0.00,941.82,270302.34,286313.28,16010.94,492148),('1','150','166311','329',252.00,304.00,0.00,1527.00,384804.00,464208.00,79404.00,492375),('1','150','166486','329',252.00,304.00,0.00,2775.82,699506.64,843849.28,144342.64,492856),('1','150','166701','329',225.00,304.00,0.00,1992.79,448377.75,605808.16,157430.41,493421),('1','150','166885','329',225.00,304.00,0.00,2339.14,526306.50,711098.56,184792.06,493924),('1','150','166942','329',225.00,304.00,0.00,495.06,111388.50,150498.24,39109.74,494074),('1','150','167054','329',252.00,304.00,0.00,1829.76,461099.52,556247.04,95147.52,494374),('1','150','167177','329',252.00,304.00,0.00,3145.85,792754.20,956338.40,163584.20,494708),('1','150','167374','329',275.00,304.00,0.00,2429.80,668195.00,738659.20,70464.20,495238),('1','150','167556','329',275.00,304.00,0.00,1774.49,487984.75,539444.96,51460.21,495723),('1','150','167743','329',257.00,304.00,0.00,2390.50,614358.50,726712.00,112353.50,496196),('1','150','167917','329',257.00,304.00,0.00,2321.62,596656.34,705772.48,109116.14,496658),('1','150','167995','329',257.00,304.00,0.00,438.00,112566.00,133152.00,20586.00,496877),('1','150','168106','329',276.00,304.00,0.00,1978.73,546129.48,601533.92,55404.44,497171),('1','150','168278','329',276.00,304.00,0.00,3100.52,855743.52,942558.08,86814.56,497635),('1','150','168404','329',276.00,304.00,0.00,3467.60,957057.60,1054150.40,97092.80,497969),('1','150','168612','329',276.00,304.00,0.00,1752.69,483742.44,532817.76,49075.32,498511),('1','150','168641','329',276.00,304.00,0.00,898.65,248027.40,273189.60,25162.20,498583),('1','150','168772','329',276.00,304.00,0.00,3352.73,925353.48,1019229.92,93876.44,498940),('1','150','168916','329',276.00,304.00,0.00,798.62,220419.12,242780.48,22361.36,499326),('1','150','168933','329',261.00,304.00,0.00,2716.64,709043.04,825858.56,116815.52,499361),('1','150','169119','329',261.00,304.00,0.00,2318.58,605149.38,704848.32,99698.94,499834),('1','150','169121','329',261.00,304.00,0.00,1061.82,277135.02,322793.28,45658.26,499838),('1','150','169268','329',261.00,304.00,0.00,2520.64,657887.04,766274.56,108387.52,500212),('1','150','169504','329',261.00,304.00,0.00,1404.76,366642.36,427047.04,60404.68,500821),('1','150','169772','329',261.00,304.00,0.00,3897.53,1017255.33,1184849.12,167593.79,501535),('1','150','169936','329',261.00,304.00,0.00,1430.23,373290.03,434789.92,61499.89,501985),('1','150','170008','329',261.00,304.00,0.00,712.00,185832.00,216448.00,30616.00,502159),('1','150','170154','329',261.00,304.00,0.00,3059.86,798623.46,930197.44,131573.98,502529),('1','150','170287','329',261.00,304.00,0.00,1030.26,268897.86,313199.04,44301.18,502888),('1','150','170330','329',276.00,304.00,0.00,2026.84,559407.84,616159.36,56751.52,502999),('1','150','170482','329',276.00,304.00,0.00,2883.71,795903.96,876647.84,80743.88,503402),('1','150','170655','329',276.00,304.00,0.00,421.57,116353.32,128157.28,11803.96,503847),('1','150','170659','329',276.00,304.00,0.00,1736.34,479229.84,527847.36,48617.52,503857),('1','150','170810','329',276.00,304.00,0.00,2615.03,721748.28,836809.60,115061.32,504253),('1','150','170985','329',276.00,320.00,0.00,1538.03,424496.28,492169.60,67673.32,504713),('1','150','171206','329',276.00,320.00,0.00,3303.78,911843.28,1057209.60,145366.32,505319),('1','150','171359','329',276.00,320.00,0.00,2029.06,560020.56,649299.20,89278.64,505719),('1','150','171575','329',276.00,320.00,0.00,2684.28,740861.28,858969.60,118108.32,506303),('1','150','171759','329',276.00,320.00,0.00,2422.87,668712.12,775318.40,106606.28,506787),('1','150','171952','329',276.00,320.00,0.00,2857.62,788703.12,914438.40,125735.28,507290),('1','150','172075','329',276.00,320.00,0.00,1607.43,443650.68,514377.60,70726.92,507616),('1','150','172080','329',276.00,320.00,0.00,1230.84,339711.84,393868.80,54156.96,507623),('1','150','172273','329',276.00,320.00,0.00,2470.87,681960.12,790678.40,108718.28,508142),('1','150','172440','329',276.00,320.00,0.00,1270.62,350691.12,406598.40,55907.28,508589),('1','150','172697','329',276.00,320.00,0.00,3421.87,944436.12,1094998.40,150562.28,509263),('1','150','172837','329',276.00,320.00,0.00,1894.37,522846.12,606198.40,83352.28,509641),('1','150','173043','329',293.00,320.00,0.00,3115.02,912700.86,996806.40,84105.54,510182),('1','150','173202','329',293.00,320.00,0.00,2404.34,704471.62,769388.80,64917.18,510604),('1','150','173385','329',293.00,320.00,0.00,2835.62,830836.66,907398.40,76561.74,511083),('1','150','173566','329',293.00,320.00,0.00,1959.59,574159.87,627068.80,52908.93,511584),('1','150','173757','329',293.00,320.00,0.00,3305.50,968511.50,1057760.00,89248.50,512073),('1','150','173936','329',293.00,320.00,0.00,1231.96,360964.28,394227.20,33262.92,512543),('1','150','174123','329',293.00,320.00,0.00,3421.65,1002543.45,1094928.00,92384.55,513041),('1','150','174313','329',293.00,320.00,0.00,1670.93,489582.49,534697.60,45115.11,513538),('1','150','174480','329',293.00,320.00,0.00,3896.06,1141545.58,1246739.20,105193.62,513964),('1','150','174597','329',293.00,320.00,0.00,1255.47,367852.71,401750.40,33897.69,514265),('1','150','174631','329',293.00,320.00,0.00,1850.81,542287.33,592259.20,49971.87,514342),('1','150','174833','329',293.00,320.00,0.00,2544.00,745392.00,814080.00,68688.00,514886),('1','150','174998','329',300.00,320.00,0.00,247.42,74226.00,79174.40,4948.40,515333),('1','150','175041','329',300.00,320.00,0.00,2405.83,721749.00,866098.80,144349.80,515426),('1','150','175232','329',300.00,360.00,0.00,2732.77,819831.00,983797.20,163966.20,515939),('1','150','175411','329',300.00,360.00,0.00,2717.42,815226.00,978271.20,163045.20,516402),('1','150','175571','329',300.00,360.00,0.00,2212.97,663891.00,796669.20,132778.20,516831),('1','150','175749','329',300.00,360.00,0.00,3934.44,1180332.00,1416398.40,236066.40,517294),('1','150','175833','329',300.00,360.00,0.00,878.94,263682.00,316418.40,52736.40,517512),('1','150','175913','329',300.00,360.00,0.00,1929.72,578916.00,694699.20,115783.20,517720),('1','150','176136','329',300.00,360.00,0.00,2790.30,837090.00,1004508.00,167418.00,518285),('1','150','176320','329',303.00,360.00,0.00,2765.51,837949.53,995583.60,157634.07,518753),('1','150','176505','329',303.00,360.00,0.00,2077.22,629397.66,747799.20,118401.54,519252),('1','150','176760','329',303.00,360.00,0.00,2345.86,710795.58,844509.60,133714.02,519928),('1','150','176925','329',303.00,360.00,0.00,2234.08,676926.24,804268.80,127342.56,520377),('1','150','177211','329',303.00,360.00,0.00,3625.27,1098456.81,1305097.20,206640.39,521112),('1','150','177414','329',303.00,360.00,0.00,1451.77,439886.31,522637.20,82750.89,521636),('1','150','177417','329',303.00,360.00,0.00,1719.50,521008.50,619020.00,98011.50,521643),('1','150','177651','329',303.00,360.00,0.00,2910.94,882014.82,1047938.40,165923.58,522274),('1','150','177869','329',303.00,360.00,0.00,1942.11,588459.33,699159.60,110700.27,522863),('1','150','178064','329',303.00,360.00,0.00,2208.80,669266.40,795168.00,125901.60,523382),('1','150','178179','329',303.00,360.00,0.00,618.25,187329.75,222570.00,35240.25,523677),('1','150','178281','329',303.00,360.00,0.00,1845.41,559159.23,664347.60,105188.37,523938),('1','150','178467','329',303.00,360.00,0.00,2304.74,698336.22,829706.40,131370.18,524432),('1','150','178593','329',303.00,360.00,0.00,714.27,216423.81,257137.20,40713.39,524771),('1','150','178699','329',303.00,360.00,0.00,2091.94,633857.82,753098.40,119240.58,525042),('1','150','178867','329',303.00,360.00,0.00,3110.42,942457.26,1119751.20,177293.94,525483),('1','150','179113','329',303.00,360.00,0.00,2066.61,626182.83,743979.60,117796.77,526110),('1','150','179217','329',303.00,360.00,0.00,2398.98,726890.94,863632.80,136741.86,526396),('1','150','179362','329',303.00,360.00,0.00,885.15,268200.45,314154.00,45953.55,526789),('1','150','179453','329',303.00,360.00,0.00,1387.05,420276.15,499338.00,79061.85,527025),('1','150','179573','329',303.00,360.00,0.00,2561.28,776067.84,913277.08,137209.24,527340),('1','150','179769','329',303.00,360.00,0.00,1488.89,451133.67,536000.40,84866.73,527873),('1','150','179914','329',303.00,360.00,0.00,873.27,264600.81,314377.20,49776.39,528265),('1','150','179989','329',303.00,360.00,0.00,3047.22,923307.66,1097193.80,173886.14,528441),('1','150','180169','329',303.00,360.00,0.00,1152.76,349286.28,414993.60,65707.32,528916),('1','150','180237','329',303.00,360.00,0.00,2075.40,628846.20,745646.40,116800.20,529087),('1','150','180335','329',303.00,360.00,0.00,2570.76,778940.28,925473.60,146533.32,529340),('1','150','180543','329',303.00,360.00,0.00,795.75,241112.25,288608.40,47496.15,529899),('1','150','180625','329',303.00,360.00,0.00,1309.14,396669.42,470192.40,73522.98,530098),('1','150','180732','329',303.00,360.00,0.00,2504.33,758811.99,901558.80,142746.81,530386),('1','150','180955','329',303.00,360.00,0.00,1549.64,469540.92,557870.40,88329.48,530987),('1','150','181127','329',303.00,360.00,0.00,2620.87,794123.61,943653.20,149529.59,531438),('1','150','181332','329',303.00,360.00,0.00,2534.16,767850.48,912297.60,144447.12,531991),('1','150','181519','329',303.00,360.00,0.00,3875.32,1174221.96,1397095.20,222873.24,532480),('1','150','181698','329',303.00,360.00,0.00,818.82,248102.46,294744.60,46642.14,532945),('1','150','181777','329',303.00,360.00,0.00,1516.60,459529.80,547616.00,88086.20,533149),('1','150','181900','329',303.00,360.00,0.00,2852.74,864380.22,1026986.40,162606.18,533496),('1','150','182291','329',303.00,360.00,0.00,559.83,169628.49,201538.80,31910.31,534525),('1','150','182293','329',303.00,360.00,0.00,2475.88,750191.64,891316.80,141125.16,534529),('1','150','182304','329',303.00,360.00,0.00,2480.69,751649.07,893048.40,141399.33,534551),('1','150','182489','329',303.00,360.00,0.00,3208.17,972075.51,1154941.20,182865.69,535056),('1','150','183094','329',303.00,360.00,0.00,2155.58,653140.74,776008.80,122868.06,536675),('1','150','183097','329',303.00,360.00,0.00,1195.75,362312.25,430470.00,68157.75,536678),('1','150','183102','329',303.00,360.00,0.00,3695.94,1119869.82,1330538.40,210668.58,536689),('1','150','183103','329',303.00,360.00,0.00,615.55,186511.65,221598.00,35086.35,536690),('1','150','183107','329',303.00,360.00,0.00,1630.17,493941.51,586861.20,92919.69,536696),('1','150','183224','329',303.00,360.00,0.00,2478.20,750894.60,892152.00,141257.40,536990),('1','150','183443','329',303.00,360.00,0.00,832.54,252259.62,299714.40,47454.78,537549),('1','150','183498','329',303.00,360.00,0.00,1326.68,414064.89,477604.80,63539.91,537699),('1','150','183636','329',318.00,360.00,0.00,2096.84,666795.12,754862.40,88067.28,538079),('1','150','183919','329',318.00,360.00,0.00,1878.16,597254.88,676137.60,78882.72,538822),('1','150','184443','329',318.00,360.00,0.00,3151.66,1002227.88,1134597.60,132369.72,540205),('1','150','184444','329',318.00,360.00,0.00,2053.44,652993.92,739238.40,86244.48,540206),('1','150','184530','329',328.00,360.00,0.00,3321.60,1089484.80,1195776.00,106291.20,540428),('1','150','184675','329',328.00,360.00,0.00,1397.92,458517.76,503251.20,44733.44,540836),('1','150','184821','329',328.00,360.00,0.00,722.33,235187.24,260038.80,24851.56,541229),('1','150','184869','329',323.00,360.00,0.00,2085.65,673664.95,750834.00,77169.05,541352),('1','150','185095','329',323.00,360.00,0.00,2351.98,759689.54,846712.80,87023.26,541934),('1','150','185253','329',323.00,360.00,0.00,289.75,93589.25,104310.00,10720.75,542328),('1','150','185295','329',323.00,360.00,0.00,1682.71,549742.68,605775.60,56032.92,542426),('1','150','185456','329',328.00,360.00,0.00,2887.21,947004.88,1039395.60,92390.72,542868),('1','150','185667','329',328.00,360.00,0.00,1385.20,454345.60,498672.00,44326.40,543429),('1','150','185776','329',328.00,360.00,0.00,1692.76,548852.98,609393.60,60540.62,543714),('1','150','185864','329',323.00,360.00,0.00,2604.88,841376.24,937756.80,96380.56,543958),('1','150','186077','329',323.00,360.00,0.00,1046.24,337935.52,376646.40,38710.88,544513),('1','150','186250','329',323.00,360.00,0.00,901.83,291291.09,324658.80,33367.71,544975),('1','150','186307','329',323.00,360.00,0.00,2225.21,718742.83,801075.60,82332.77,545118),('1','150','186522','329',323.00,360.00,0.00,1499.74,484416.02,539906.40,55490.38,545691),('1','150','186663','329',323.00,360.00,0.00,941.41,304075.43,338907.60,34832.17,546045),('1','150','186741','329',323.00,360.00,0.00,2361.58,762790.34,850168.80,87378.46,546254),('1','150','186970','329',323.00,360.00,0.00,2109.99,681526.77,759596.40,78069.63,546824),('1','150','187132','329',323.00,360.00,0.00,963.19,311110.37,346748.40,35638.03,547266),('1','150','187304','329',323.00,360.00,0.00,3357.39,1084436.97,1208660.40,124223.43,547715),('1','150','187534','329',323.00,360.00,0.00,1214.52,392289.96,437227.20,44937.24,548326),('1','150','187540','329',323.00,360.00,0.00,1094.48,353517.04,394012.80,40495.76,548340),('1','150','187565','329',323.00,360.00,0.00,2825.39,912600.97,1017140.40,104539.43,548400),('1','150','187787','329',323.00,360.00,0.00,1471.84,475404.32,529862.40,54458.08,548992),('1','150','187984','329',323.00,360.00,0.00,1041.81,336504.63,375051.60,38546.97,549503),('1','150','188049','329',323.00,360.00,0.00,3385.32,1093458.36,1218715.20,125256.84,549657),('1','150','188200','329',323.00,360.00,0.00,840.82,271584.86,302695.20,31110.34,550068),('1','150','188271','329',323.00,360.00,0.00,2591.58,837080.34,932968.80,95888.46,550245),('1','150','188415','329',323.00,360.00,0.00,2734.53,883253.19,984430.80,101177.61,550623),('1','150','188630','329',323.00,360.00,0.00,2741.83,885611.09,987058.80,101447.71,551156),('1','150','188799','329',323.00,360.00,0.00,2730.25,881870.75,982890.00,101019.25,551619),('1','150','188999','329',323.00,360.00,0.00,2160.68,697899.64,777844.80,79945.16,552145),('1','150','189192','329',323.00,360.00,0.00,2434.38,786304.74,876376.80,90072.06,552651),('1','150','189413','329',323.00,360.00,0.00,757.14,244556.22,272570.40,28014.18,553233),('1','150','189487','329',323.00,360.00,0.00,1446.19,467119.37,520628.40,53509.03,553416),('1','150','189611','329',323.00,360.00,0.00,2545.20,822099.60,916272.00,94172.40,553742),('1','150','189804','329',323.00,360.00,0.00,1267.54,409415.42,456314.40,46898.98,554239),('1','150','189913','329',323.00,360.00,0.00,1226.37,396117.51,441493.20,45375.69,554510),('1','150','190025','329',323.00,360.00,0.00,2966.53,958189.19,1067950.80,109761.61,554818),('1','150','190204','329',323.00,360.00,0.00,989.06,319466.38,356061.60,36595.22,555285),('1','150','190296','329',323.00,360.00,0.00,2023.89,653716.47,728600.40,74883.93,555516),('1','150','190425','329',323.00,360.00,0.00,2987.04,964813.92,1075334.40,110520.48,555863),('1','150','190662','329',323.00,360.00,0.00,432.52,139703.96,155707.20,16003.24,556497),('1','150','190708','329',323.00,360.00,0.00,1698.78,548705.94,611560.80,62854.86,556596),('1','150','190880','329',323.00,360.00,0.00,2638.79,852329.17,949964.40,97635.23,557064),('1','150','191081','329',323.00,360.00,0.00,1050.64,339356.72,378230.40,38873.68,557579),('1','150','191200','329',323.00,360.00,0.00,1167.15,376989.45,420174.00,43184.55,557905),('1','150','191283','329',323.00,360.00,0.00,2820.07,910882.61,1015225.20,104342.59,558123),('1','150','191541','329',323.00,360.00,0.00,0.00,0.00,0.00,0.00,558786),('1','150','191548','329',323.00,360.00,0.00,666.22,215189.06,239839.20,24650.14,558805),('1','150','191551','329',323.00,360.00,0.00,2046.11,660893.53,736599.60,75706.07,558812),('1','150','191717','329',323.00,360.00,0.00,2417.15,780739.45,870174.00,89434.55,559263),('1','150','191930','329',323.00,360.00,0.00,744.90,240602.70,268164.00,27561.30,559845),('1','150','192028','329',323.00,360.00,0.00,1499.85,484451.55,539946.00,55494.45,560100),('1','150','192123','329',323.00,360.00,0.00,2328.92,752241.16,838411.20,86170.04,560358),('1','150','192366','329',323.00,360.00,0.00,1488.81,480885.63,535971.60,55085.97,560977),('1','150','192556','329',323.00,360.00,0.00,2770.91,895003.93,997527.60,102523.67,561490),('1','150','192758','329',323.00,360.00,0.00,2343.99,757108.77,843836.40,86727.63,562008),('1','150','192951','329',323.00,360.00,0.00,3974.29,1283695.67,1430744.40,147048.73,562515),('1','150','193160','329',323.00,360.00,0.00,1454.96,469952.08,523785.60,53833.52,563073),('1','150','193400','329',323.00,360.00,0.00,3393.38,1096061.74,1221616.80,125555.06,563705),('1','150','193641','329',323.00,360.00,0.00,2047.74,661420.02,737186.40,75766.38,564313),('1','150','193846','329',323.00,360.00,0.00,2984.52,963999.96,1074427.20,110427.24,564840),('1','150','194084','329',323.00,360.00,0.00,2023.43,653567.89,728434.80,74866.91,565427),('1','150','194288','329',323.00,360.00,0.00,4957.24,1601188.52,1784606.40,183417.88,565967),('1','150','194517','329',323.00,360.00,0.00,439.30,141893.90,158148.00,16254.10,566529),('1','150','194536','329',323.00,360.00,0.00,2976.68,961467.64,1071604.80,110137.16,566575),('1','150','194667','329',323.00,360.00,0.00,2175.09,702554.07,783032.40,80478.33,566925),('1','150','194893','329',323.00,360.00,0.00,4043.86,1306166.78,1455789.60,149622.82,567520),('1','150','195080','329',323.00,360.00,0.00,1084.98,350448.54,390592.80,40144.26,568011),('1','150','195204','329',323.00,360.00,0.00,1856.35,599601.05,668286.00,68684.95,568325),('1','150','195293','329',323.00,360.00,0.00,3004.27,970379.21,1081537.20,111157.99,568566),('1','150','195556','329',323.00,360.00,0.00,2144.36,692628.28,771969.60,79341.32,569217),('1','150','195774','329',323.00,360.00,0.00,3138.38,1013696.74,1129816.80,116120.06,569775),('1','150','196000','329',323.00,360.00,0.00,3866.20,1248782.60,1391832.00,143049.40,570351),('1','150','196220','329',323.00,360.00,0.00,2019.71,652366.33,727095.60,74729.27,570894),('1','150','196437','329',323.00,360.00,0.00,3543.78,1144640.94,1275760.80,131119.86,571465),('1','150','196654','329',323.00,360.00,0.00,1728.11,558179.53,622119.60,63940.07,572019),('1','150','196805','329',323.00,360.00,0.00,1153.53,372590.19,415270.80,42680.61,572414),('1','150','196919','329',323.00,360.00,0.00,1480.50,478201.50,532980.00,54778.50,572701),('1','150','197027','329',323.00,360.00,0.00,2855.45,922310.35,1027962.00,105651.65,572991),('1','150','197343','329',323.00,360.00,0.00,2441.91,788736.93,879087.60,90350.67,573818),('1','150','197346','329',323.00,360.00,0.00,2560.16,917495.10,921657.60,4162.50,573821),('1','150','197824','329',323.00,360.00,0.00,2917.28,942281.44,1050220.80,107939.36,574997),('1','150','197865','329',323.00,360.00,0.00,2383.68,769928.64,858124.80,88196.16,575103),('1','150','198166','329',323.00,360.00,0.00,2240.16,712047.06,806457.60,94410.54,575870),('1','150','198338','329',317.00,360.00,0.00,2606.39,826225.63,938300.40,112074.77,576332),('1','150','198562','329',317.00,360.00,0.00,536.72,170140.24,193219.20,23078.96,576917),('1','150','198637','329',317.00,360.00,0.00,1760.40,558046.80,633744.00,75697.20,577104),('1','150','198772','329',317.00,360.00,0.00,3663.78,1161418.26,1318960.80,157542.54,577427),('1','150','199013','329',317.00,360.00,0.00,3123.73,990222.41,1124542.80,134320.39,578045),('1','150','199271','329',317.00,360.00,0.00,2397.85,760118.45,863226.00,103107.55,578676),('1','150','199455','329',317.00,360.00,0.00,2529.16,801743.72,910497.60,108753.88,579136),('1','150','199630','329',317.00,360.00,0.00,2643.38,837951.46,951616.80,113665.34,579604),('1','150','199861','329',317.00,360.00,0.00,2834.11,898412.87,1020279.60,121866.73,580142),('1','150','200085','329',317.00,360.00,0.00,2366.96,750326.32,852105.60,101779.28,580738),('1','150','200283','329',317.00,360.00,0.00,3864.78,1225135.26,1391320.80,166185.54,581255),('1','150','200488','329',317.00,360.00,0.00,1701.98,539527.66,612712.80,73185.14,581784),('1','150','200599','329',317.00,360.00,0.00,1635.66,518504.22,588837.60,70333.38,582069),('1','150','200686','329',317.00,360.00,0.00,2853.74,904635.58,1027346.40,122710.82,582302),('1','150','200912','329',317.00,360.00,0.00,781.72,247805.24,281419.20,33613.96,582874),('1','150','200985','329',317.00,360.00,0.00,2556.10,810283.70,920196.00,109912.30,583051),('1','150','201100','329',317.00,360.00,0.00,2785.52,883009.84,1002787.20,119777.36,583355),('1','150','201302','329',317.00,360.00,0.00,3059.36,969817.12,1101369.60,131552.48,583873),('1','150','201491','329',317.00,360.00,0.00,3122.70,989895.90,1124172.00,134276.10,584368),('1','150','201756','329',317.00,360.00,0.00,4107.12,1301957.04,1478563.20,176606.16,585073),('1','150','202020','329',317.00,360.00,0.00,1168.43,370392.31,420634.80,50242.49,585766),('1','150','202145','329',317.00,360.00,0.00,1523.12,482829.04,548323.20,65494.16,586085),('1','150','202202','329',317.00,360.00,0.00,3189.05,1010928.85,1148058.00,137129.15,586231),('1','150','202421','329',317.00,360.00,0.00,406.57,128882.69,146365.20,17482.51,586791),('1','150','202490','329',317.00,360.00,0.00,2462.76,780694.92,886593.60,105898.68,586968),('1','150','202639','329',317.00,360.00,0.00,2629.16,833443.72,946497.60,113053.88,587351),('1','150','202838','329',317.00,360.00,0.00,2537.33,804333.61,913438.80,109105.19,587866),('1','150','203104','329',317.00,360.00,0.00,2392.33,758368.61,861238.80,102870.19,588554),('1','150','203297','329',317.00,360.00,0.00,3338.36,1058260.12,1201809.60,143549.48,589068),('1','150','203517','329',317.00,360.00,0.00,1754.40,556144.80,631584.00,75439.20,589621),('1','150','203631','329',317.00,360.00,0.00,1392.14,441308.38,501170.40,59862.02,589919),('1','150','203723','329',0.00,376.00,0.00,3085.19,950686.17,1160031.44,209345.27,590155),('1','150','203954','329',317.00,376.00,0.00,412.37,130721.29,155051.12,24329.83,590750),('1','150','204005','329',317.00,376.00,0.00,1466.96,471771.42,551576.96,79805.54,590867),('1','150','204181','329',322.00,376.00,0.00,3027.32,974797.04,1138272.32,163475.28,591350),('1','150','204386','329',322.00,376.00,0.00,905.68,291628.96,340535.68,48906.72,591878),('1','150','204515','329',322.00,376.00,0.00,1358.40,437404.80,510758.40,73353.60,592197),('1','150','204607','329',322.00,376.00,0.00,2729.33,878844.26,1026228.08,147383.82,592443),('1','150','204830','329',322.00,376.00,0.00,1286.61,414288.42,483765.36,69476.94,592976),('1','150','204941','329',322.00,376.00,0.00,1592.12,512662.64,598637.12,85974.48,593253),('1','150','205033','329',322.00,376.00,0.00,3841.90,1237091.80,1444554.40,207462.60,593499),('1','150','205313','329',322.00,376.00,0.00,2205.71,710238.62,829346.96,119108.34,594218),('1','150','205698','329',322.00,376.00,0.00,1720.74,554078.28,646998.24,92919.96,595225),('1','150','205797','329',322.00,376.00,0.00,3654.87,1176868.14,1374231.12,197362.98,595466),('1','150','205934','329',322.00,376.00,0.00,1884.17,606702.74,708447.92,101745.18,595830),('1','150','206142','329',322.00,376.00,0.00,2552.55,821921.10,959758.80,137837.70,596358),('1','150','206354','329',322.00,376.00,0.00,2874.08,925453.76,1080654.08,155200.32,596899),('1','150','206511','329',322.00,376.00,0.00,985.14,365479.20,370412.64,4933.44,597298),('1','150','206564','329',376.00,376.00,0.00,4129.66,1373971.66,1552752.16,178780.50,597436),('1','150','206785','329',322.00,376.00,0.00,2938.19,946097.18,1104759.44,158662.26,598006),('1','150','207013','329',322.00,376.00,0.00,2262.02,728370.44,850519.52,122149.08,598601),('1','150','207345','329',322.00,376.00,0.00,3679.82,1184902.04,1383612.32,198710.28,599448),('1','150','207511','329',322.00,376.00,0.00,1340.25,431560.50,503934.00,72373.50,599877),('1','150','207573','329',322.00,376.00,0.00,2658.07,779004.94,999434.32,220429.38,600032),('1','150','207691','329',0.00,384.00,0.00,2442.92,0.00,938081.28,938081.28,600335),('1','150','207998','329',322.00,384.00,0.00,4700.86,1513676.92,1805130.24,291453.32,601120),('1','150','208148','329',322.00,384.00,0.00,570.28,183630.16,218987.52,35357.36,601493),('1','150','208163','329',322.00,384.00,0.00,3431.25,1104862.50,1317600.00,212737.50,601532),('1','150','208349','329',322.00,384.00,0.00,1741.31,560701.82,668663.04,107961.22,602015),('1','150','208507','329',322.00,384.00,0.00,856.50,275793.00,328896.00,53103.00,602431),('1','150','208562','329',322.00,384.00,0.00,3188.31,1026635.82,1224311.04,197675.22,602562),('1','150','208749','329',322.00,384.00,0.00,1125.90,362539.80,432345.60,69805.80,603056),('1','150','208851','329',322.00,384.00,0.00,2191.81,705762.82,841655.04,135892.22,603289),('1','150','208997','329',0.00,384.00,0.00,217.32,0.00,83450.88,83450.88,603670),('1','150','208998','329',0.00,400.00,0.00,3088.51,0.00,1235404.00,1235404.00,603671),('1','150','209281','329',0.00,400.00,0.00,462.62,0.00,185048.00,185048.00,604394),('1','150','209286','329',322.00,400.00,0.00,2328.88,749899.36,931552.00,181652.64,604405),('1','150','209427','329',322.00,400.00,0.00,3070.51,988704.22,1228204.00,239499.78,604774),('1','150','209635','329',322.00,400.00,0.00,3678.38,1184438.36,1471352.00,286913.64,605307),('1','150','209860','329',0.00,420.00,0.00,1657.16,0.00,696007.20,696007.20,605886),('1','150','210092','329',0.00,420.00,0.00,3397.89,1066660.42,1427113.80,360453.38,606497),('1','150','210300','329',322.00,420.00,0.00,1903.94,613068.68,799654.80,186586.12,607034),('1','150','210553','329',345.00,420.00,0.00,3527.45,1216970.25,1481529.00,264558.75,607680),('1','150','210772','329',345.00,420.00,0.00,1540.39,531434.55,646963.80,115529.25,608263),('1','150','210940','329',345.00,420.00,0.00,4037.07,1392789.15,1695569.40,302780.25,608699),('1','150','211215','329',345.00,420.00,0.00,1526.97,526804.65,641327.40,114522.75,609394),('1','150','211301','329',345.00,420.00,0.00,915.86,315971.70,384661.20,68689.50,609628),('1','150','211362','329',345.00,420.00,0.00,2917.81,1006644.45,1225480.20,218835.75,609791),('1','150','211643','329',345.00,420.00,0.00,1695.35,584895.75,712047.00,127151.25,610518),('1','150','211771','329',345.00,420.00,0.00,3345.74,1154280.30,1405210.80,250930.50,610838),('1','150','212021','329',345.00,420.00,0.00,1872.37,645967.65,786395.40,140427.75,611478),('1','150','212219','329',345.00,420.00,0.00,3120.44,1076551.80,1310584.80,234033.00,612013),('1','150','212449','329',345.00,420.00,0.00,2831.54,976881.30,1189246.80,212365.50,612620),('1','150','212657','329',345.00,420.00,0.00,2906.74,1002825.30,1220830.80,218005.50,613173),('1','150','212867','329',345.00,420.00,0.00,2251.87,776895.15,945785.40,168890.25,613712),('1','150','213200','329',345.00,420.00,0.00,3461.85,1194338.25,1453977.00,259638.75,614578),('1','150','213443','329',345.00,420.00,0.00,1750.59,650059.69,735247.80,85188.11,615195),('1','150','213675','329',386.00,420.00,0.00,3572.44,1378961.84,1500424.80,121462.96,615816),('1','150','213872','329',386.00,420.00,0.00,1801.00,695186.00,756420.00,61234.00,616346),('1','150','214018','329',386.00,420.00,0.00,1140.88,440379.68,479169.60,38789.92,616717),('1','150','214126','329',386.00,420.00,0.00,3556.08,1372646.88,1493553.60,120906.72,616989),('1','150','214363','329',386.00,420.00,0.00,1026.50,418289.90,431130.00,12840.10,617606),('1','150','214415','329',420.00,420.00,0.00,2290.63,906473.24,962064.60,55591.36,617749),('1','150','214515','329',386.00,420.00,0.00,2881.09,1112100.74,1210057.80,97957.06,618013),('1','150','214764','329',386.00,420.00,0.00,4048.94,1562890.84,1700554.80,137663.96,618662),('1','150','214990','329',386.00,420.00,0.00,1180.46,455657.56,495793.20,40135.64,619253),('1','150','215087','329',386.00,420.00,0.00,1956.91,755367.26,821902.20,66534.94,619503),('1','150','215219','329',0.00,448.00,0.00,2703.20,0.00,1211033.60,1211033.60,619834),('1','150','215434','329',0.00,448.00,0.00,673.47,0.00,301714.56,301714.56,620391),('1','150','215515','329',0.00,448.00,0.00,2264.57,703743.62,1014527.36,310783.74,620590),('1','150','215668','329',386.00,448.00,0.00,2895.11,1117512.46,1297009.28,179496.82,620998),('1','150','215942','329',386.00,448.00,0.00,2717.67,1073046.52,1217516.16,144469.64,621684),('1','150','216090','329',396.00,448.00,0.00,2792.81,1105952.76,1251178.88,145226.12,622087),('1','150','216311','329',0.00,452.00,0.00,326.84,0.00,147731.68,147731.68,622657),('1','150','216383','329',0.00,452.00,0.00,2908.62,999460.44,1314696.24,315235.80,622835),('1','150','216542','329',396.00,452.00,0.00,1972.85,781248.60,891728.20,110479.60,623275),('1','150','216827','329',396.00,452.00,0.00,3925.11,1554343.56,1774149.72,219806.16,624002),('1','150','217053','329',0.00,480.00,0.00,1306.11,0.00,626932.80,626932.80,624595),('1','150','217157','329',0.00,480.00,0.00,1069.75,279335.41,513480.00,234144.59,624878),('1','150','217275','329',431.00,480.00,0.00,2986.15,1287030.65,1433352.00,146321.35,625185),('1','150','217496','329',431.00,480.00,0.00,828.90,357255.90,397872.00,40616.10,625774),('1','150','217558','329',431.00,480.00,0.00,2096.47,903578.57,1006305.60,102727.03,625917),('1','150','217704','329',431.00,480.00,0.00,2521.74,1086869.94,1210435.20,123565.26,626312),('1','150','217972','329',431.00,480.00,0.00,647.21,278947.51,310660.80,31713.29,627019),('1','150','218045','329',431.00,480.00,0.00,1950.94,840855.14,936451.20,95596.06,627197),('1','150','218213','329',431.00,480.00,0.00,2682.66,1156226.46,1287676.80,131450.34,627650),('1','150','218435','329',431.00,480.00,0.00,757.61,326529.91,363652.80,37122.89,628238),('1','150','218535','329',431.00,480.00,0.00,1835.71,791191.01,881140.80,89949.79,628490),('1','150','218675','329',431.00,480.00,0.00,2959.74,1275647.94,1420675.20,145027.26,628856),('1','150','218895','329',431.00,480.00,0.00,303.25,130700.75,145560.00,14859.25,629438),('1','150','218936','329',431.00,480.00,0.00,2599.45,1120362.95,1247736.00,127373.05,629529),('1','150','219109','329',431.00,480.00,0.00,2839.12,1223660.72,1362777.60,139116.88,629990),('1','150','219321','329',431.00,480.00,0.00,2365.42,1019496.02,1135401.60,115905.58,630549),('1','150','219581','329',431.00,480.00,0.00,2541.45,1095364.95,1219896.00,124531.05,631227),('1','150','219799','329',431.00,480.00,0.00,557.10,240110.10,267408.00,27297.90,631802),('1','150','219882','329',431.00,480.00,0.00,1964.52,846708.12,942969.60,96261.48,632013),('1','150','220029','329',431.00,480.00,0.00,2796.25,1205183.75,1342200.00,137016.25,632419),('1','150','220231','329',431.00,480.00,0.00,490.12,211241.72,235257.60,24015.88,632950),('1','150','220337','329',431.00,480.00,0.00,2031.37,875520.47,975057.60,99537.13,633218),('1','150','220455','329',431.00,480.00,0.00,3299.43,1422054.33,1583726.40,161672.07,633540),('1','150','220717','329',431.00,480.00,0.00,3158.41,1361274.71,1516036.80,154762.09,634202),('1','150','220896','329',431.00,480.00,0.00,2326.46,1002704.26,1116700.80,113996.54,634685),('1','150','221131','329',431.00,480.00,0.00,3333.29,1436647.99,1599979.20,163331.21,635289),('1','150','221376','329',431.00,480.00,0.00,1858.48,801004.88,892070.40,91065.52,635934),('1','150','221586','329',431.00,480.00,0.00,800.12,344851.72,384057.60,39205.88,636486),('1','150','221621','329',431.00,480.00,0.00,3576.14,1541316.34,1716547.20,175230.86,636562),('1','150','221837','329',431.00,480.00,0.00,752.99,324538.69,361435.20,36896.51,637124),('1','150','221906','329',431.00,480.00,0.00,2142.75,923525.25,1028520.00,104994.75,637298),('1','150','222090','329',431.00,480.00,0.00,3074.93,1325294.83,1475966.40,150671.57,637779),('1','150','222259','329',431.00,480.00,0.00,3802.29,1638786.99,1825099.20,186312.21,638220),('1','150','222478','329',431.00,480.00,0.00,1460.33,629402.23,700958.40,71556.17,638783),('1','150','222625','329',431.00,480.00,0.00,1087.39,468665.09,521947.20,53282.11,639167),('1','150','222741','329',431.00,480.00,0.00,2848.18,1227565.58,1367126.40,139560.82,639470),('1','150','222935','329',431.00,480.00,0.00,2023.81,872262.11,971428.80,99166.69,639998),('1','150','223166','329',431.00,480.00,0.00,2596.77,1119207.87,1246449.60,127241.73,640601),('1','150','223407','329',431.00,480.00,0.00,1269.64,369086.85,610027.20,240940.35,641190),('1','150','223547','329',0.00,480.00,0.00,1442.54,0.00,738580.48,738580.48,641535),('1','150','223666','329',0.00,512.00,0.00,2019.42,837675.00,1033943.04,196268.04,641832),('1','150','223895','329',459.00,512.00,0.00,2994.30,1374383.70,1533081.60,158697.90,642426),('1','150','224069','329',459.00,512.00,0.00,2701.84,1240144.56,1383342.08,143197.52,642896),('1','150','224296','329',459.00,512.00,0.00,2321.46,1065550.14,1188587.52,123037.38,643483),('1','150','224602','329',459.00,512.00,0.00,653.76,300075.84,334725.12,34649.28,644276),('1','150','224614','329',459.00,512.00,0.00,1830.20,840061.80,937062.40,97000.60,644310),('1','150','224765','329',459.00,512.00,0.00,2078.84,954187.56,1064366.08,110178.52,644705),('1','150','225003','329',459.00,512.00,0.00,1477.81,678314.79,756638.72,78323.93,645316),('1','150','225252','329',459.00,512.00,0.00,3394.74,1558185.66,1738106.88,179921.22,645960),('1','150','225472','329',459.00,512.00,0.00,1759.24,807491.16,900730.88,93239.72,646524),('1','150','225633','329',459.00,512.00,0.00,1402.52,646334.58,718090.24,71755.66,646939),('1','150','225682','329',461.00,512.00,0.00,820.14,225424.39,419911.68,194487.29,647066),('1','150','225927','329',0.00,544.00,0.00,1671.07,0.00,909062.08,909062.08,647721),('1','150','225966','329',0.00,544.00,0.00,1496.50,0.00,814096.00,814096.00,647804),('1','150','226227','329',0.00,544.00,0.00,2473.76,836996.21,1345725.44,508729.23,648486),('1','150','226466','329',461.00,544.00,0.00,2518.72,1161129.92,1370183.68,209053.76,649099),('1','150','226805','329',461.00,544.00,0.00,1978.75,912203.75,1076440.00,164236.25,649964),('1','150','227029','329',461.00,544.00,0.00,3259.46,1502611.06,1773146.24,270535.18,650551),('1','150','227255','329',461.00,544.00,0.00,2792.31,1357062.66,1519016.64,161953.98,651135),('1','150','227411','329',486.00,544.00,0.00,2142.38,1041196.68,1165454.72,124258.04,651529),('1','150','227599','329',486.00,544.00,0.00,411.93,200197.98,224089.92,23891.94,652026),('1','150','227660','329',486.00,544.00,0.00,2097.50,1019385.00,1141040.00,121655.00,652174),('1','150','227841','329',486.00,544.00,0.00,2590.89,1259172.54,1409444.16,150271.62,652655),('1','150','228106','329',486.00,544.00,0.00,532.26,258678.36,289549.44,30871.08,653364),('1','150','228218','329',486.00,544.00,0.00,2188.23,1063479.78,1190397.12,126917.34,653645),('1','150','228339','329',486.00,544.00,0.00,928.77,451382.22,505250.88,53868.66,653965),('1','150','228398','329',0.00,560.00,0.00,2020.55,0.00,1131508.00,1131508.00,654101),('1','150','228519','329',0.00,560.00,0.00,3154.98,1162429.38,1766788.80,604359.42,654420),('1','150','228741','329',486.00,560.00,0.00,872.10,423840.60,488376.00,64535.40,654987),('1','150','228795','329',486.00,560.00,0.00,2538.62,1233769.32,1421627.20,187857.88,655105),('1','150','228927','329',486.00,560.00,0.00,3020.61,1468016.46,1691541.60,223525.14,655457),('1','150','229198','329',486.00,560.00,0.00,2263.24,1099934.64,1267414.40,167479.76,656155),('1','150','229423','329',0.00,584.00,0.00,2734.14,0.00,1596737.76,1596737.76,656739),('1','150','229679','329',0.00,584.00,0.00,519.53,0.00,303405.52,303405.52,657392),('1','150','229739','329',0.00,584.00,0.00,1492.36,0.00,871538.24,871538.24,657545),('1','150','229881','329',526.00,584.00,0.00,2613.64,1374774.64,1526365.76,151591.12,657917),('1','150','230076','329',526.00,584.00,0.00,1689.73,888797.98,986802.32,98004.34,658430),('1','150','230220','329',526.00,584.00,0.00,1010.23,531380.98,589974.32,58593.34,658803),('1','150','230280','329',526.00,584.00,0.00,3417.28,1797489.28,1995691.52,198202.24,658945),('1','150','230541','329',526.00,584.00,0.00,793.91,417596.66,463643.44,46046.78,659612),('1','150','230612','329',526.00,584.00,0.00,1498.51,788216.26,875129.84,86913.58,659805),('1','150','230775','329',526.00,584.00,0.00,2401.56,1263220.56,1402511.04,139290.48,660236),('1','150','231080','329',526.00,584.00,0.00,2290.13,1204608.38,1337435.92,132827.54,661029),('1','150','231425','329',526.00,584.00,0.00,2251.61,1184346.86,1314940.24,130593.38,661951),('1','150','231670','329',526.00,584.00,0.00,704.52,370577.52,411439.68,40862.16,662589),('1','150','231737','329',526.00,584.00,0.00,1660.80,873580.80,969907.20,96326.40,662780),('1','150','231882','329',526.00,584.00,0.00,2890.75,1520534.50,1688198.00,167663.50,663184),('1','150','232093','329',526.00,584.00,0.00,521.01,274051.26,304269.84,30218.58,663745),('1','150','232155','329',526.00,584.00,0.00,2461.73,1294869.98,1437650.32,142780.34,663890),('1','150','232320','329',526.00,584.00,0.00,2157.43,1134808.18,1259939.12,125130.94,664329),('1','150','232576','329',526.00,584.00,0.00,494.89,260312.14,289015.76,28703.62,665013),('1','150','232659','329',526.00,584.00,0.00,544.26,96641.98,318147.84,221505.86,665220),('1','150','232700','329',0.00,584.00,0.00,1375.26,0.00,825156.00,825156.00,665324),('1','150','232836','329',0.00,600.00,0.00,2462.43,0.00,1477458.00,1477458.00,665697),('1','150','233102','329',0.00,600.00,0.00,908.15,0.00,544890.00,544890.00,666392),('1','150','233229','329',0.00,600.00,0.00,1171.54,455783.40,702924.00,247140.60,666729),('1','150','233362','329',0.00,624.00,0.00,1944.10,0.00,1213118.40,1213118.40,667073),('1','150','233593','329',0.00,624.00,0.00,2121.49,0.00,1323809.76,1323809.76,667678),('1','150','233782','329',0.00,624.00,0.00,490.45,0.00,306040.80,306040.80,668173),('1','150','233829','329',0.00,624.00,0.00,2890.61,1247735.70,1803740.64,556004.94,668298),('1','150','234036','329',570.00,624.00,0.00,1385.10,789507.00,864302.40,74795.40,668846),('1','150','234300','329',570.00,624.00,0.00,1412.19,804948.30,881206.56,76258.26,669546),('1','150','234553','329',570.00,624.00,0.00,2165.29,1234215.30,1351140.96,116925.66,670215),('1','150','234821','329',570.00,624.00,0.00,1894.79,1080030.30,1182348.96,102318.66,670918),('1','150','235066','329',570.00,624.00,0.00,3295.88,1878651.60,2056629.12,177977.52,671585),('1','150','235300','329',570.00,624.00,0.00,1738.68,991047.60,1084936.32,93888.72,672189),('1','150','235486','329',570.00,624.00,0.00,916.76,522553.20,572058.24,49505.04,672669),('1','150','235515','329',570.00,624.00,0.00,2890.24,1647436.80,1803509.76,156072.96,672743),('1','150','235744','329',0.00,640.00,0.00,1656.56,0.00,1060198.40,1060198.40,673337),('1','150','236008','329',0.00,640.00,0.00,2887.79,1309942.08,1848185.60,538243.52,674029),('1','150','236231','329',592.00,640.00,0.00,2575.75,1524844.00,1648480.00,123636.00,674624),('1','150','236556','329',592.00,640.00,0.00,2103.07,1245017.44,1345964.80,100947.36,675464),('1','150','236730','329',592.00,640.00,0.00,2597.00,1537424.00,1662080.00,124656.00,675923),('1','150','236985','329',592.00,640.00,0.00,241.56,143003.52,154598.40,11594.88,676570),('1','150','236996','329',592.00,640.00,0.00,2129.66,1260758.72,1362982.40,102223.68,676594),('1','150','237159','329',592.00,640.00,0.00,1852.30,1096561.60,1185472.00,88910.40,677036),('1','150','237289','329',592.00,640.00,0.00,1000.51,592301.92,640326.40,48024.48,677359),('1','150','237373','329',592.00,640.00,0.00,2419.96,1432616.32,1548774.40,116158.08,677578),('1','150','237596','329',592.00,640.00,0.00,1746.86,19612.96,1145410.08,1125797.12,678165),('1','150','237867','329',0.00,656.00,0.00,2516.25,922655.68,1611538.88,688883.20,678870),('1','150','238106','329',592.00,640.00,0.00,2307.73,1366176.16,1476947.20,110771.04,679491),('1','150','238343','329',592.00,640.00,0.00,212.33,125699.36,135891.20,10191.84,680092),('1','150','238450','329',592.00,640.00,0.00,1846.69,1100199.28,1181881.60,81682.32,680369),('1','150','238589','329',602.00,640.00,0.00,2400.38,1445028.76,1536243.20,91214.44,680753),('1','150','238905','329',602.00,640.00,0.00,1042.27,627446.54,667052.80,39606.26,681545),('1','150','238926','329',602.00,640.00,0.00,1328.97,800039.94,850540.80,50500.86,681601),('1','150','239048','329',602.00,640.00,0.00,2164.70,1360713.32,1385408.00,24694.68,681933),('1','150','239345','329',640.00,640.00,0.00,1946.20,1245568.00,1245568.00,0.00,682689),('1','150','239618','329',640.00,640.00,0.00,2103.59,1299136.18,1346297.60,47161.42,683406),('1','150','239745','329',602.00,640.00,0.00,1502.60,904565.20,961664.00,57098.80,683752),('1','150','239753','329',602.00,640.00,0.00,2127.10,1280514.20,1361344.00,80829.80,683773),('1','150','239983','329',602.00,640.00,0.00,1606.18,966920.36,1027955.20,61034.84,684366),('1','150','240181','329',602.00,640.00,0.00,2630.79,1583735.58,1683705.60,99970.02,684877),('1','150','240439','329',602.00,640.00,0.00,2628.40,1582296.80,1682176.00,99879.20,685546),('1','150','240676','329',602.00,640.00,0.00,2150.03,1294318.06,1376019.20,81701.14,686124),('1','150','240961','329',602.00,640.00,0.00,2034.67,1224871.34,1302188.80,77317.46,686886),('1','150','241212','329',602.00,640.00,0.00,1207.80,727095.60,772992.00,45896.40,687545),('1','150','241397','329',602.00,640.00,0.00,641.90,386423.80,410816.00,24392.20,688032),('1','150','241477','329',602.00,640.00,0.00,2073.19,1248060.38,1326841.60,78781.22,688250),('1','150','241791','329',602.00,640.00,0.00,1010.44,608284.88,646681.60,38396.72,689066),('1','150','242130','329',602.00,640.00,0.00,770.54,463865.08,493145.60,29280.52,689949),('1','150','242352','329',602.00,640.00,0.00,61.66,37119.32,39462.40,2343.08,690528),('1','150','242634','329',602.00,640.00,0.00,1427.31,859240.62,913478.40,54237.78,691265),('1','150','242672','329',602.00,640.00,0.00,1435.43,864128.86,918675.20,54546.34,691351),('1','150','243017','329',602.00,640.00,0.00,407.34,245218.68,260697.60,15478.92,692249),('1','150','243119','329',602.00,640.00,0.00,1964.10,1168747.20,1257024.00,88276.80,692535),('1','150','243347','329',592.00,640.00,0.00,1600.92,947744.64,1024588.80,76844.16,693137),('1','150','243580','329',592.00,640.00,0.00,1361.35,805919.20,871264.00,65344.80,693730),('1','150','243815','329',592.00,640.00,0.00,1464.64,867066.88,937369.60,70302.72,694342),('1','150','244035','329',592.00,640.00,0.00,1310.33,775715.36,838611.20,62895.84,694901),('1','150','244271','329',592.00,640.00,0.00,292.14,172946.88,186969.60,14022.72,695522),('1','150','244664','329',592.00,640.00,0.00,906.65,536736.80,580256.00,43519.20,696541),('1','150','244746','329',592.00,640.00,0.00,2174.14,1287090.88,1391449.60,104358.72,696749),('1','150','244986','329',0.00,632.00,0.00,1392.24,0.00,879895.68,879895.68,697367),('1','150','245196','329',0.00,632.00,0.00,1381.82,0.00,873310.24,873310.24,697924),('1','150','245494','329',0.00,632.00,0.00,2519.80,0.00,1592513.60,1592513.60,698668),('1','150','245672','329',0.00,632.00,0.00,2184.76,0.00,1380768.32,1380768.32,699139),('1','150','245939','329',0.00,632.00,0.00,254.46,0.00,160818.72,160818.72,699835),('1','150','245986','329',0.00,616.00,0.00,1768.52,645906.24,1089408.32,443502.08,699953),('1','150','246182','329',552.00,616.00,0.00,2239.68,1236303.36,1379642.88,143339.52,700464),('1','150','246441','329',552.00,616.00,0.00,1370.11,756300.72,843987.76,87687.04,701159),('1','150','246695','329',552.00,616.00,0.00,3007.59,1660189.68,1852675.44,192485.76,701821),('1','150','246927','329',552.00,616.00,0.00,2461.12,1358538.24,1516049.92,157511.68,702416),('1','150','247161','329',552.00,616.00,0.00,158.11,87276.72,97395.76,10119.04,703025),('1','150','247214','329',552.00,616.00,0.00,2314.40,1287643.26,1425670.40,138027.14,703142),('1','150','247392','329',558.00,616.00,0.00,1925.64,1074507.12,1186194.24,111687.12,703603),('1','150','247662','329',558.00,616.00,0.00,378.96,211459.68,233439.36,21979.68,704315),('1','150','247753','329',0.00,592.00,0.00,1806.62,861127.92,1069519.04,208391.12,704523),('1','150','247897','329',558.00,592.00,0.00,2593.30,1447061.40,1535233.60,88172.20,704921),('1','150','248146','329',558.00,592.00,0.00,209.73,117029.34,124160.16,7130.82,705566),('1','150','248204','329',558.00,592.00,0.00,1398.94,780608.52,828172.48,47563.96,705698),('1','150','248349','329',558.00,592.00,0.00,1013.52,565544.16,600003.84,34459.68,706091),('1','150','248390','329',558.00,592.00,0.00,2089.12,1165728.96,1236759.04,71030.08,706199),('1','150','248532','329',558.00,592.00,0.00,905.74,505402.92,536198.08,30795.16,706546),('1','150','248632','329',558.00,592.00,0.00,2613.69,1458439.02,1547304.48,88865.46,706817),('1','150','248861','329',558.00,592.00,0.00,1841.12,1027344.96,1089943.04,62598.08,707400),('1','150','249099','329',558.00,592.00,0.00,1587.42,838960.68,939752.64,100791.96,708020),('1','150','249337','329',510.00,592.00,0.00,2047.69,1044321.90,1212232.48,167910.58,708621),('1','150','249578','329',510.00,592.00,0.00,1374.12,700801.20,813479.04,112677.84,709235),('1','150','249796','329',510.00,592.00,0.00,0.00,0.00,0.00,0.00,709803),('1','150','249846','329',510.00,592.00,0.00,2756.89,1406013.90,1632078.88,226064.98,709926),('1','150','250094','329',510.00,592.00,0.00,2450.84,1249928.40,1450897.28,200968.88,710556),('1','150','250329','329',510.00,592.00,0.00,2009.34,1024763.40,1189529.28,164765.88,711158),('1','150','250556','329',510.00,592.00,0.00,1895.28,966592.80,1122005.76,155412.96,711733),('1','150','250794','329',510.00,592.00,0.00,848.03,432495.30,502033.76,69538.46,712352),('1','150','250889','329',510.00,592.00,0.00,1014.40,517344.00,600524.80,83180.80,712582),('1','150','251019','329',510.00,592.00,0.00,1901.64,969836.40,1125770.88,155934.48,712932),('1','150','251265','329',510.00,592.00,0.00,1778.18,906871.80,1052682.56,145810.76,713575),('1','150','251629','329',510.00,592.00,0.00,246.70,125817.00,146046.40,20229.40,714515),('1','150','251631','329',510.00,592.00,0.00,1153.38,588223.80,682800.96,94577.16,714519),('1','150','251759','329',510.00,592.00,0.00,1919.82,979108.20,1136533.44,157425.24,714869),('1','150','251989','329',510.00,592.00,0.00,2005.43,1022769.30,1187214.56,164445.26,715475),('1','150','252237','329',510.00,592.00,0.00,2592.15,1321996.50,1534552.80,212556.30,716120),('1','150','252473','329',510.00,592.00,0.00,2062.96,1052109.60,1221272.32,169162.72,716731),('1','150','252701','329',510.00,592.00,0.00,768.21,391787.10,454780.32,62993.22,717329),('1','150','252826','329',510.00,592.00,0.00,1021.96,521199.60,605000.32,83800.72,717628),('1','150','252968','329',510.00,592.00,0.00,2133.94,1088309.40,1263292.48,174983.08,718011),('1','150','253285','329',510.00,592.00,0.00,1993.38,1016623.80,1180080.96,163457.16,718826),('1','150','253475','329',510.00,592.00,0.00,2180.87,1112243.70,1291075.04,178831.34,719335),('1','150','253712','329',510.00,592.00,0.00,2555.45,1303279.50,1512826.40,209546.90,719946),('1','150','253957','329',510.00,592.00,0.00,604.22,308152.20,357698.24,49546.04,720579),('1','150','254113','329',510.00,592.00,0.00,724.25,369367.50,428756.00,59388.50,720989),('1','150','254189','329',510.00,592.00,0.00,1883.48,960574.80,1115020.16,154445.36,721193),('1','150','254440','329',510.00,592.00,0.00,1795.00,915450.00,1062640.00,147190.00,721846),('1','150','254685','329',510.00,592.00,0.00,755.52,385315.20,447267.84,61952.64,722465),('1','150','254824','329',510.00,592.00,0.00,102.94,52499.40,60940.48,8441.08,722798),('1','150','254828','329',510.00,592.00,0.00,957.58,488365.80,566887.36,78521.56,722806),('1','150','254971','329',510.00,592.00,0.00,1952.84,995948.40,1156081.28,160132.88,723168),('1','150','255220','329',510.00,592.00,0.00,1915.96,977139.60,1134248.32,157108.72,723809),('1','150','255504','329',510.00,592.00,0.00,471.80,240618.00,279305.60,38687.60,724508),('1','150','255566','329',510.00,592.00,0.00,1505.57,767840.70,891297.44,123456.74,724649),('1','150','255770','329',510.00,592.00,0.00,2687.16,1370451.60,1590798.72,220347.12,725174),('1','150','256032','329',510.00,592.00,0.00,577.27,294407.70,341743.84,47336.14,725845),('1','150','256061','329',510.00,592.00,0.00,1089.84,555818.40,645185.28,89366.88,725922),('1','150','256250','329',510.00,592.00,0.00,2120.33,1081368.30,1255235.36,173867.06,726368),('1','150','256476','329',510.00,592.00,0.00,1938.92,988849.20,1147840.64,158991.44,726991),('1','150','256675','329',510.00,592.00,0.00,10.91,5564.10,6458.72,894.62,727498),('1','150','256753','329',510.00,592.00,0.00,1854.31,945698.10,1097751.52,152053.42,727678),('1','150','256953','329',510.00,592.00,0.00,2076.54,1059035.40,1229311.68,170276.28,728233),('1','150','257227','329',510.00,592.00,0.00,1380.92,704269.20,817504.64,113235.44,728943),('1','150','257357','329',510.00,592.00,0.00,1068.60,544986.00,632611.20,87625.20,729263),('1','150','257518','329',0.00,568.00,0.00,3202.93,0.00,1821664.24,1821664.24,729685),('1','150','257519','329',0.00,568.00,0.00,924.52,104585.70,525127.36,420541.66,729686),('1','150','257520','329',510.00,568.00,0.00,1000.86,510438.60,568488.48,58049.88,729687),('1','150','257521','329',510.00,568.00,0.00,2575.55,1313530.50,1462912.40,149381.90,729688),('1','150','257522','329',510.00,568.00,0.00,1569.67,785019.90,891572.56,106552.66,729689),('1','150','257523','329',500.00,568.00,0.00,992.46,496230.00,563717.28,67487.28,729690),('1','150','257524','329',500.00,568.00,0.00,2483.97,1241985.00,1410894.96,168909.96,729691),('1','150','257525','329',500.00,568.00,0.00,2472.24,1236120.00,1404232.32,168112.32,729692),('1','150','257526','329',500.00,568.00,0.00,2304.65,1152325.00,1309041.20,156716.20,729693),('1','150','257527','329',500.00,568.00,0.00,2757.22,1378610.00,1566100.96,187490.96,729694),('1','150','257528','329',500.00,568.00,0.00,281.73,140865.00,160022.64,19157.64,729695),('1','150','257529','329',500.00,568.00,0.00,1569.74,784870.00,891612.32,106742.32,729696),('1','150','257530','329',500.00,568.00,0.00,1796.59,898295.00,1020463.12,122168.12,729697),('1','150','257531','329',500.00,568.00,0.00,1674.49,837245.00,951110.32,113865.32,729698),('1','150','257532','329',500.00,568.00,0.00,315.10,157550.00,178976.80,21426.80,729699),('1','150','257533','329',500.00,568.00,0.00,1192.66,596330.00,677430.88,81100.88,729700),('1','150','257534','329',500.00,568.00,0.00,2478.18,1239090.00,1407606.24,168516.24,729701),('1','150','257535','329',500.00,568.00,0.00,1418.18,709090.00,805526.24,96436.24,729702),('1','150','257536','329',500.00,568.00,0.00,30.98,15490.00,17596.64,2106.64,729703),('1','150','257537','329',500.00,568.00,0.00,1472.34,736170.00,836289.12,100119.12,729704),('1','150','257538','329',500.00,568.00,0.00,1600.69,800345.00,909191.92,108846.92,729705),('1','150','257539','329',500.00,568.00,0.00,1407.47,703735.00,799442.96,95707.96,729706),('1','150','257540','329',500.00,568.00,0.00,1105.20,552600.00,627753.60,75153.60,729707),('1','150','257541','329',500.00,568.00,0.00,1503.38,751690.00,853919.84,102229.84,729708),('1','150','257542','329',500.00,568.00,0.00,1448.36,724180.00,822668.48,98488.48,729709),('1','150','257543','329',500.00,568.00,0.00,1880.03,940015.00,1067857.04,127842.04,729710),('1','150','257544','329',500.00,568.00,0.00,366.99,183495.00,208450.32,24955.32,729711),('1','150','257545','329',500.00,568.00,0.00,1633.89,816945.00,928049.52,111104.52,729712),('1','150','257546','329',500.00,568.00,0.00,1777.22,888610.00,1009460.96,120850.96,729713),('1','150','257547','329',500.00,568.00,0.00,2086.15,1043075.00,1184933.20,141858.20,729714),('1','150','257548','329',500.00,568.00,0.00,1470.46,735230.00,835221.28,99991.28,729715),('1','150','257549','329',500.00,568.00,0.00,26.17,13085.00,14864.56,1779.56,729716),('1','150','257550','329',500.00,568.00,0.00,1411.48,705740.00,801720.64,95980.64,729717),('1','150','257551','329',500.00,568.00,0.00,2116.69,1058345.00,1202279.92,143934.92,729718),('1','150','257552','329',500.00,568.00,0.00,1347.87,673935.00,765590.16,91655.16,729719),('1','150','257553','329',500.00,568.00,0.00,173.96,86980.00,98809.28,11829.28,729720),('1','150','257554','329',500.00,568.00,0.00,1504.53,752265.00,854573.04,102308.04,729721),('1','150','257555','329',500.00,568.00,0.00,1919.55,959775.00,1090304.40,130529.40,729722),('1','150','257556','329',500.00,568.00,0.00,1236.08,618040.00,702093.44,84053.44,729723),('1','150','257557','329',500.00,568.00,0.00,1635.45,817725.00,928935.60,111210.60,729724),('1','150','257558','329',500.00,568.00,0.00,1738.13,869065.00,987257.84,118192.84,729725),('1','150','257559','329',500.00,568.00,0.00,202.87,95415.00,115380.16,19965.16,729726),('1','150','257560','329',0.00,580.00,0.00,1496.80,28329.00,868144.00,839815.00,729727),('1','150','257561','329',532.00,580.00,0.00,1822.78,969718.96,1057212.40,87493.44,729728),('1','150','257562','329',532.00,580.00,0.00,2241.77,1192621.64,1300226.60,107604.96,729729),('1','150','257563','329',532.00,580.00,0.00,1270.34,675820.88,736797.20,60976.32,729730),('1','150','257564','329',532.00,580.00,0.00,2618.76,1393180.32,1518880.80,125700.48,729731),('1','150','257565','329',532.00,580.00,0.00,1789.96,952258.72,1038176.80,85918.08,729732),('1','150','257566','329',0.00,640.00,0.00,1347.03,26626.50,862099.20,835472.70,729733),('1','150','257567','329',582.00,640.00,0.00,1760.11,1024384.02,1126470.40,102086.38,729734),('1','150','257568','329',582.00,640.00,0.00,1599.99,931194.18,1026553.60,95359.42,729735),('1','150','257569','329',582.00,640.00,0.00,1525.94,888097.08,976601.60,88504.52,729736),('1','150','257570','329',582.00,640.00,0.00,576.12,335301.84,368716.80,33414.96,729737),('1','150','257571','329',582.00,640.00,0.00,2046.56,1191097.92,1309798.40,118700.48,729738),('1','150','257572','329',582.00,640.00,0.00,1327.69,772715.58,849721.60,77006.02,729739),('1','150','257573','329',0.00,680.00,0.00,1597.11,0.00,1086034.80,1086034.80,729740),('1','150','257574','329',0.00,680.00,0.00,1328.46,756033.48,903352.80,147319.32,729741),('1','150','257575','329',606.00,680.00,0.00,1363.65,826371.90,927282.00,100910.10,729742),('1','150','257576','329',606.00,680.00,0.00,1340.61,85718.70,882834.96,797116.26,729743),('1','150','257577','329',0.00,656.00,0.00,1004.59,0.00,659011.04,659011.04,729744),('1','150','257578','329',0.00,656.00,0.00,439.98,260468.16,288626.88,28158.72,729745),('1','150','257579','329',592.00,656.00,0.00,1618.53,975125.86,1061755.68,86629.82,729746),('1','150','257580','329',606.00,656.00,0.00,1410.26,854617.56,925200.56,70583.00,729747),('1','150','257581','329',606.00,656.00,0.00,1244.17,753967.02,816175.52,62208.50,729748),('1','150','257582','329',606.00,656.00,0.00,548.77,332554.62,359993.12,27438.50,729749),('1','150','257583','329',606.00,656.00,0.00,490.48,293307.04,321754.88,28447.84,729750),('1','150','257584','329',598.00,656.00,0.00,1463.44,875137.12,960016.64,84879.52,729751),('1','150','257585','329',598.00,656.00,0.00,1373.61,821418.78,901088.16,79669.38,729752),('1','150','257586','329',598.00,656.00,0.00,1774.37,1061073.26,1163986.72,102913.46,729753),('1','150','257587','329',598.00,656.00,0.00,350.51,209604.98,229934.56,20329.58,729754),('1','150','257588','329',598.00,656.00,0.00,201.54,120520.92,132210.24,11689.32,729755),('1','150','257589','329',0.00,688.00,0.00,1198.47,644592.24,824547.36,179955.12,729756),('1','150','257590','329',617.00,688.00,0.00,1418.78,875387.26,976120.64,100733.38,729757),('1','150','257591','329',617.00,688.00,0.00,1516.67,935785.39,1043468.96,107683.57,729758),('1','150','257592','329',617.00,688.00,0.00,862.39,532094.63,593324.32,61229.69,729759),('1','150','257593','329',617.00,688.00,0.00,923.37,569719.29,635278.56,65559.27,729760),('1','150','257594','329',0.00,664.00,0.00,2262.40,0.00,1502233.60,1502233.60,729761),('1','150','257595','329',0.00,664.00,0.00,1537.50,0.00,1020900.00,1020900.00,729762),('1','150','257596','329',0.00,664.00,0.00,3261.11,1956385.62,2165377.04,208991.42,729763),('1','150','257597','329',602.00,664.00,0.00,1882.06,1133000.12,1249687.84,116687.72,729764),('1','150','257598','329',602.00,664.00,0.00,1776.74,1069597.48,1179755.36,110157.88,729765),('1','150','257599','329',602.00,664.00,0.00,2122.75,1277895.50,1409506.00,131610.50,729766),('1','150','257600','329',602.00,664.00,0.00,1672.10,1006604.20,1110274.40,103670.20,729767),('1','150','257601','329',602.00,664.00,0.00,1654.54,996033.08,1098614.56,102581.48,729768),('1','150','257602','329',602.00,664.00,0.00,1964.42,1182580.84,1304374.88,121794.04,729769),('1','150','257603','329',602.00,664.00,0.00,1738.53,1046595.06,1154383.92,107788.86,729770),('1','150','257604','329',602.00,664.00,0.00,2435.85,1466381.70,1617404.40,151022.70,729771),('1','150','257605','329',602.00,664.00,0.00,1963.18,1181834.36,1303551.52,121717.16,729772),('1','150','257606','329',602.00,664.00,0.00,1018.56,613173.12,676323.84,63150.72,729773),('1','150','257607','329',602.00,664.00,0.00,656.84,395417.68,436141.76,40724.08,729774),('1','150','257608','329',602.00,664.00,0.00,1636.30,985052.60,1086503.20,101450.60,729775),('1','150','257609','329',602.00,664.00,0.00,2220.92,1336993.84,1474690.88,137697.04,729776),('1','150','257610','329',602.00,664.00,0.00,733.76,441723.52,487216.64,45493.12,729777),('1','150','257611','329',602.00,664.00,0.00,1225.31,737636.62,813605.84,75969.22,729778),('1','150','257612','329',602.00,664.00,0.00,2071.61,1247109.22,1375549.04,128439.82,729779),('1','150','257613','329',602.00,664.00,0.00,1535.20,924190.40,1019372.80,95182.40,729780),('1','150','257614','329',602.00,664.00,0.00,2113.92,1272579.84,1403642.88,131063.04,729781),('1','150','257615','329',602.00,664.00,0.00,1348.19,811610.38,895198.16,83587.78,729782),('1','150','257616','329',602.00,664.00,0.00,1205.96,717109.32,800757.44,83648.12,729783),('1','150','257617','329',592.00,664.00,0.00,1883.78,1115197.76,1250829.92,135632.16,729784),('1','150','257618','329',592.00,664.00,0.00,1643.67,973052.64,1091396.88,118344.24,729785),('1','150','257619','329',592.00,664.00,0.00,350.74,207638.08,232891.36,25253.28,729786),('1','150','257620','329',592.00,664.00,0.00,1766.59,1045821.28,1173015.76,127194.48,729787),('1','150','257621','329',592.00,664.00,0.00,2050.32,1213789.44,1361412.48,147623.04,729788),('1','150','257622','329',592.00,664.00,0.00,1300.74,770038.08,863691.36,93653.28,729789),('1','150','257623','329',592.00,664.00,0.00,1729.28,1023733.76,1148241.92,124508.16,729790),('1','150','257624','329',592.00,664.00,0.00,1009.38,597552.96,670228.32,72675.36,729791),('1','150','257625','329',592.00,664.00,0.00,1752.42,1037432.64,1163606.88,126174.24,729792),('1','150','257626','329',592.00,664.00,0.00,1906.57,1128689.44,1265962.48,137273.04,729793),('1','150','257627','329',592.00,664.00,0.00,3591.70,2126286.40,2384888.80,258602.40,729794),('1','150','257628','329',592.00,664.00,0.00,1777.79,1052451.68,1180452.56,128000.88,729795),('1','150','257629','329',592.00,664.00,0.00,707.28,418709.76,469633.92,50924.16,729796),('1','150','257630','329',592.00,664.00,0.00,737.65,436688.80,489799.60,53110.80,729797),('1','150','257631','329',592.00,664.00,0.00,1796.58,1063575.36,1192929.12,129353.76,729798),('1','150','257632','329',592.00,664.00,0.00,1819.08,1076895.36,1207869.12,130973.76,729799),('1','150','257633','329',592.00,664.00,0.00,395.65,234224.80,262711.60,28486.80,729800),('1','150','257634','329',592.00,664.00,0.00,1445.84,855937.28,960037.76,104100.48,729801),('1','150','257635','329',592.00,664.00,0.00,1619.19,958560.48,1075142.16,116581.68,729802),('1','150','257636','329',592.00,664.00,0.00,1876.42,1110840.64,1245942.88,135102.24,729803),('1','150','257637','329',592.00,664.00,0.00,1728.84,1023473.28,1147949.76,124476.48,729804),('1','150','257638','329',592.00,664.00,0.00,1354.07,801609.44,899102.48,97493.04,729805),('1','150','257639','329',592.00,664.00,0.00,59.40,35164.80,39441.60,4276.80,729806),('1','150','257640','329',592.00,664.00,0.00,962.39,569734.88,639026.96,69292.08,729807),('1','150','257641','329',592.00,664.00,0.00,1550.94,918156.48,1029824.16,111667.68,729808),('1','150','257642','329',592.00,664.00,0.00,2037.93,1206454.56,1353185.52,146730.96,729809),('1','150','257643','329',592.00,664.00,0.00,195.99,116026.08,130137.36,14111.28,729810),('1','150','257644','329',0.00,680.00,0.00,1893.21,1120780.32,1287382.80,166602.48,729811),('1','150','257645','329',592.00,680.00,0.00,1805.05,1068589.60,1227434.00,158844.40,729812),('1','150','257646','329',592.00,680.00,0.00,640.11,378945.12,435274.80,56329.68,729813),('1','150','257647','329',602.00,680.00,0.00,1264.00,760928.00,859520.00,98592.00,729814),('1','150','257648','329',602.00,680.00,0.00,1665.71,1002757.42,1132682.80,129925.38,729815),('1','150','257649','329',602.00,680.00,0.00,2565.59,1544485.18,1744601.20,200116.02,729816),('1','150','257650','329',602.00,680.00,0.00,2460.53,1481239.06,1673160.40,191921.34,729817),('1','150','257651','329',602.00,680.00,0.00,524.23,315586.46,356476.40,40889.94,729818),('1','150','257652','329',602.00,680.00,0.00,1480.30,891140.60,1006604.00,115463.40,729819),('1','150','257653','329',602.00,680.00,0.00,1807.81,1088301.62,1229310.80,141009.18,729820),('1','150','257654','329',602.00,680.00,0.00,1689.08,1016826.16,1148574.40,131748.24,729821),('1','150','257655','329',602.00,680.00,0.00,355.17,213812.34,241515.60,27703.26,729822),('1','150','257656','329',602.00,680.00,0.00,1036.29,592410.56,746128.80,153718.24,729823),('1','150','257657','329',662.00,720.00,0.00,1550.37,1026344.94,1116266.40,89921.46,729824),('1','150','257658','329',662.00,720.00,0.00,1537.51,1017831.62,1107007.20,89175.58,729825),('1','150','257659','329',662.00,720.00,0.00,1286.11,851404.82,925999.20,74594.38,729826),('1','150','257660','329',662.00,720.00,0.00,975.16,645555.92,702115.20,56559.28,729827),('1','150','257661','329',662.00,720.00,0.00,2284.69,1512464.78,1644976.80,132512.02,729828),('1','150','257662','329',662.00,720.00,0.00,1410.98,934068.76,1015905.60,81836.84,729829),('1','150','257663','329',0.00,760.00,0.00,261.52,0.00,198755.20,198755.20,729830),('1','150','257664','329',0.00,760.00,0.00,1412.44,924926.54,1073454.40,148527.86,729831),('1','150','257665','329',662.00,760.00,0.00,2142.01,1418010.62,1627927.60,209916.98,729832),('1','150','257666','329',662.00,760.00,0.00,1709.88,1131940.56,1299508.80,167568.24,729833),('1','150','257667','329',662.00,760.00,0.00,1896.63,1270347.46,1441438.80,171091.34,729834),('1','150','257668','329',682.00,760.00,0.00,2197.66,1498804.12,1670221.60,171417.48,729835),('1','150','257669','329',682.00,760.00,0.00,1023.10,697754.20,777556.00,79801.80,729836),('1','150','257670','329',682.00,760.00,0.00,1700.24,1159563.68,1292182.40,132618.72,729837),('1','150','257671','329',682.00,760.00,0.00,1340.05,913914.10,1018562.60,104648.50,729838),('1','150','257672','329',682.00,760.00,0.00,1723.33,1175311.06,1309730.80,134419.74,729839),('1','150','257673','329',682.00,760.00,0.00,1453.86,991532.52,1104933.60,113401.08,729840),('1','150','257674','329',682.00,760.00,0.00,235.81,160822.42,179215.60,18393.18,729841),('1','150','257675','329',682.00,760.00,0.00,1574.32,1073686.24,1196483.20,122796.96,729842),('1','150','257676','329',682.00,760.00,0.00,2040.41,1391559.62,1550711.60,159151.98,729843),('1','150','257677','329',682.00,760.00,0.00,1573.47,1073106.54,1195837.20,122730.66,729844),('1','150','257678','329',682.00,760.00,0.00,1936.92,1320979.44,1472059.20,151079.76,729845),('1','150','257679','329',682.00,760.00,0.00,1645.42,1122176.44,1250519.20,128342.76,729846),('1','150','257680','329',682.00,760.00,0.00,1551.54,1058150.28,1179170.40,121020.12,729847),('1','150','257681','329',682.00,760.00,0.00,77.92,53141.44,59219.20,6077.76,729848),('1','150','257682','329',682.00,760.00,0.00,1862.55,1270259.10,1415538.00,145278.90,729849),('1','150','257683','329',682.00,760.00,0.00,2154.62,1469450.84,1637511.20,168060.36,729850),('1','150','257684','329',682.00,760.00,0.00,2076.89,1416438.98,1578436.40,161997.42,729851),('1','150','257685','329',682.00,760.00,0.00,1690.04,1152607.28,1284430.40,131823.12,729852),('1','150','257686','329',682.00,760.00,0.00,2201.13,1501170.66,1672858.80,171688.14,729853),('1','150','257687','329',682.00,760.00,0.00,1202.00,819764.00,913520.00,93756.00,729854),('1','150','257688','329',682.00,760.00,0.00,768.57,524164.74,584113.20,59948.46,729855),('1','150','257689','329',682.00,760.00,0.00,1430.25,975430.50,1086990.00,111559.50,729856),('1','150','257690','329',682.00,760.00,0.00,1781.96,1215296.72,1354289.60,138992.88,729857),('1','150','257691','329',682.00,760.00,0.00,1436.61,979768.02,1091823.60,112055.58,729858),('1','150','257692','329',682.00,760.00,0.00,2593.25,1768596.50,1970870.00,202273.50,729859),('1','150','257693','329',682.00,760.00,0.00,1979.57,1350066.74,1504473.20,154406.46,729860),('1','150','257694','329',682.00,760.00,0.00,1121.52,764876.64,852355.20,87478.56,729861),('1','150','257695','329',682.00,760.00,0.00,684.85,467067.70,520486.00,53418.30,729862),('1','150','257696','329',682.00,760.00,0.00,1936.97,1321013.54,1472097.20,151083.66,729863),('1','150','257697','329',682.00,760.00,0.00,2015.85,1374809.70,1532046.00,157236.30,729864),('1','150','257698','329',682.00,760.00,0.00,484.38,330347.16,368128.80,37781.64,729865),('1','150','257699','329',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729866),('1','150','257700','329',682.00,760.00,0.00,1504.34,1025959.88,1143298.40,117338.52,729867),('1','150','257701','329',682.00,760.00,0.00,2517.97,1717255.54,1913657.20,196401.66,729868),('1','150','257702','329',682.00,760.00,0.00,1323.07,902333.74,1005533.20,103199.46,729869),('1','150','257703','329',682.00,760.00,0.00,1165.38,794789.16,885688.80,90899.64,729870),('1','150','257704','329',682.00,760.00,0.00,1868.57,1274364.74,1420113.20,145748.46,729871),('1','150','257705','329',682.00,760.00,0.00,1882.05,1283558.10,1430358.00,146799.90,729872),('1','150','257706','329',682.00,760.00,0.00,1592.29,1085941.78,1210140.40,124198.62,729873),('1','150','257707','329',682.00,760.00,0.00,1611.22,1098852.04,1224527.20,125675.16,729874),('1','150','257708','329',682.00,760.00,0.00,2186.89,1491458.98,1662036.40,170577.42,729875),('1','150','257709','329',682.00,760.00,0.00,545.37,371942.34,414481.20,42538.86,729876),('1','150','257710','329',682.00,760.00,0.00,1845.92,1258917.44,1402899.20,143981.76,729877),('1','150','257711','329',682.00,760.00,0.00,1567.81,1069246.42,1191535.60,122289.18,729878),('1','150','257712','329',682.00,760.00,0.00,1619.29,1104355.78,1230660.40,126304.62,729879),('1','150','257713','329',682.00,760.00,0.00,609.86,415924.52,463493.60,47569.08,729880),('1','150','257714','329',682.00,760.00,0.00,1604.53,1094289.46,1219442.80,125153.34,729881),('1','150','257715','329',682.00,760.00,0.00,1306.47,891012.54,992917.20,101904.66,729882),('1','150','257716','329',682.00,760.00,0.00,519.24,354121.68,394622.40,40500.72,729883),('1','150','257717','329',682.00,760.00,0.00,485.90,331383.80,369284.00,37900.20,729884),('1','150','257718','329',682.00,760.00,0.00,995.14,678685.48,756306.40,77620.92,729885),('1','150','257719','329',682.00,760.00,0.00,1553.59,1059548.38,1180728.40,121180.02,729886),('1','150','257720','329',682.00,760.00,0.00,1312.51,895131.82,997507.60,102375.78,729887),('1','150','257721','329',682.00,760.00,0.00,1527.44,1041714.08,1160854.40,119140.32,729888),('1','150','257722','329',682.00,760.00,0.00,668.57,455964.74,508113.20,52148.46,729889),('1','150','257723','329',682.00,760.00,0.00,758.07,517003.74,576133.20,59129.46,729890),('1','150','257724','329',0.00,744.00,0.00,1815.54,0.00,1350761.76,1350761.76,729891),('1','150','257725','329',0.00,744.00,0.00,2234.81,0.00,1666466.64,1666466.64,729892),('1','150','257726','329',0.00,744.00,0.00,348.66,0.00,259403.04,259403.04,729893),('1','150','257727','329',0.00,744.00,0.00,1113.55,745003.16,828481.20,83478.04,729894),('1','150','257728','329',682.00,744.00,0.00,1768.59,1206178.38,1315830.96,109652.58,729895),('1','150','257729','329',682.00,744.00,0.00,1584.62,1080710.84,1178957.28,98246.44,729896),('1','150','257730','329',682.00,744.00,0.00,926.28,631722.96,689152.32,57429.36,729897),('1','150','257731','329',682.00,744.00,0.00,990.34,675411.88,736812.96,61401.08,729898),('1','150','257732','329',682.00,744.00,0.00,1564.33,1066873.06,1163861.52,96988.46,729899),('1','150','257733','329',682.00,744.00,0.00,2407.82,1642133.24,1791418.08,149284.84,729900),('1','150','257734','329',682.00,744.00,0.00,255.66,174360.12,190211.04,15850.92,729901),('1','150','257735','329',682.00,744.00,0.00,2236.04,1509658.66,1663613.76,153955.10,729902),('1','150','257736','329',675.00,744.00,0.00,1939.77,1309344.75,1443188.88,133844.13,729903),('1','150','257737','329',675.00,744.00,0.00,1091.35,736661.25,811964.40,75303.15,729904),('1','150','257738','329',675.00,744.00,0.00,695.81,469671.75,517682.64,48010.89,729905),('1','150','257739','329',675.00,744.00,0.00,2023.85,1366098.75,1505744.40,139645.65,729906),('1','150','257740','329',675.00,744.00,0.00,1877.93,1267602.75,1397179.92,129577.17,729907),('1','150','257741','329',675.00,744.00,0.00,823.36,555768.00,612579.84,56811.84,729908),('1','150','257742','329',675.00,744.00,0.00,768.27,518582.25,571592.88,53010.63,729909),('1','150','257743','329',675.00,744.00,0.00,2221.10,1499242.50,1652498.40,153255.90,729910),('1','150','257744','329',675.00,744.00,0.00,1934.35,1305686.25,1439156.40,133470.15,729911),('1','150','257745','329',0.00,752.00,0.00,2028.82,0.00,1525672.64,1525672.64,729912),('1','150','257746','329',0.00,752.00,0.00,1382.03,0.00,1039286.56,1039286.56,729913),('1','150','257747','329',0.00,752.00,0.00,1664.62,0.00,1251794.24,1251794.24,729914),('1','150','257748','329',0.00,752.00,0.00,326.61,14904.00,245610.72,230706.72,729915),('1','150','257749','329',675.00,752.00,0.00,1291.11,871499.25,970914.72,99415.47,729916),('1','150','257750','329',675.00,752.00,0.00,1988.16,1342008.00,1495096.32,153088.32,729917),('1','150','257751','329',675.00,752.00,0.00,1819.88,1228419.00,1368549.76,140130.76,729918),('1','150','257752','329',675.00,752.00,0.00,247.95,167366.25,186458.40,19092.15,729919),('1','150','257753','329',675.00,752.00,0.00,1516.57,1023684.75,1140460.64,116775.89,729920),('1','150','257754','329',675.00,752.00,0.00,2800.56,1890378.00,2106021.12,215643.12,729921),('1','150','257755','329',675.00,752.00,0.00,1149.95,776216.25,855562.80,79346.55,729922),('1','150','257756','329',675.00,744.00,0.00,610.34,411979.50,454092.96,42113.46,729923),('1','150','257757','329',675.00,744.00,0.00,1653.39,1116038.25,1230122.16,114083.91,729924),('1','150','257758','329',675.00,744.00,0.00,1506.52,1016901.00,1120850.88,103949.88,729925),('1','150','257759','329',675.00,744.00,0.00,1358.72,917136.00,1010887.68,93751.68,729926),('1','150','257760','329',675.00,744.00,0.00,2222.86,1500430.50,1653807.84,153377.34,729927),('1','150','257761','329',675.00,744.00,0.00,1970.49,1330080.75,1466044.56,135963.81,729928),('1','150','257762','329',675.00,744.00,0.00,999.25,674493.75,743442.00,68948.25,729929),('1','150','257763','329',675.00,744.00,0.00,1971.90,1331032.50,1467093.60,136061.10,729930),('1','150','257764','329',675.00,744.00,0.00,1428.73,964392.75,1062975.12,98582.37,729931),('1','150','257765','329',675.00,744.00,0.00,1530.39,1033013.25,1138610.16,105596.91,729932),('1','150','257766','329',675.00,744.00,0.00,269.87,182162.25,200783.28,18621.03,729933),('1','150','257767','329',675.00,744.00,0.00,1184.42,799483.50,881208.48,81724.98,729934),('1','150','257768','329',675.00,744.00,0.00,2513.40,1696545.00,1869969.60,173424.60,729935),('1','150','257769','329',675.00,744.00,0.00,1467.63,990650.25,1091916.72,101266.47,729936),('1','150','257770','329',675.00,744.00,0.00,697.63,470900.25,519036.72,48136.47,729937),('1','150','257771','329',675.00,744.00,0.00,2209.86,1491655.50,1644135.84,152480.34,729938),('1','150','257772','329',675.00,744.00,0.00,2346.70,1584022.50,1745944.80,161922.30,729939),('1','150','257773','329',675.00,744.00,0.00,74.83,50510.25,55673.52,5163.27,729940),('1','150','257774','329',675.00,744.00,0.00,1430.08,965304.00,1064535.52,99231.52,729941),('1','150','257775','329',675.00,744.00,0.00,2267.02,1530238.50,1686662.88,156424.38,729942),('1','150','257776','329',675.00,744.00,0.00,1512.06,1020640.50,1124972.64,104332.14,729943),('1','150','257777','329',675.00,744.00,0.00,43.91,29639.25,32669.04,3029.79,729944),('1','150','257778','329',675.00,744.00,0.00,2595.01,1751631.75,1930687.44,179055.69,729945),('1','150','257779','329',675.00,744.00,0.00,1093.24,737937.00,813370.56,75433.56,729946),('1','150','257780','329',675.00,744.00,0.00,311.75,210431.25,231942.00,21510.75,729947),('1','150','257781','329',675.00,744.00,0.00,891.59,601823.25,663342.96,61519.71,729948),('1','150','257782','329',675.00,744.00,0.00,1678.15,1132751.25,1248543.60,115792.35,729949),('1','150','257783','329',675.00,744.00,0.00,1822.16,1229958.00,1355687.04,125729.04,729950),('1','150','257784','329',675.00,744.00,0.00,836.66,564745.50,622475.04,57729.54,729951),('1','150','257785','329',675.00,744.00,0.00,994.47,671267.25,739885.68,68618.43,729952),('1','150','257786','329',675.00,744.00,0.00,1573.46,1062085.50,1170654.24,108568.74,729953),('1','150','257787','329',675.00,744.00,0.00,2262.16,1526958.00,1683047.04,156089.04,729954),('1','150','257788','329',675.00,744.00,0.00,435.40,293895.00,323937.60,30042.60,729955),('1','150','257789','329',675.00,744.00,0.00,14.51,9794.25,10795.44,1001.19,729956),('1','150','257790','329',675.00,744.00,0.00,2023.18,1365646.50,1505245.92,139599.42,729957),('1','150','257791','329',675.00,744.00,0.00,1851.27,1249607.25,1377344.88,127737.63,729958),('1','150','257792','329',675.00,744.00,0.00,1496.38,1010056.50,1113306.72,103250.22,729959),('1','150','257793','329',675.00,744.00,0.00,29.17,19689.75,21702.48,2012.73,729960),('1','150','257794','329',675.00,744.00,0.00,2139.75,1444331.25,1591974.00,147642.75,729961),('1','150','257795','329',675.00,744.00,0.00,2363.72,1595511.00,1739697.92,144186.92,729962),('1','150','257796','329',675.00,736.00,0.00,856.98,578461.50,630737.28,52275.78,729963),('1','150','257797','329',675.00,736.00,0.00,1795.38,1211881.50,1321399.68,109518.18,729964),('1','150','257798','329',675.00,736.00,0.00,1905.34,1286104.50,1402330.24,116225.74,729965),('1','150','257799','329',675.00,736.00,0.00,1508.53,1018257.75,1110278.08,92020.33,729966),('1','150','257800','329',675.00,736.00,0.00,0.00,0.00,0.00,0.00,729967),('1','150','257801','329',675.00,736.00,0.00,13.46,9085.50,9906.56,821.06,729968),('1','150','257802','329',670.00,736.00,0.00,2206.86,1478596.20,1624248.96,145652.76,729969),('1','150','257803','329',670.00,736.00,0.00,2166.55,1451588.50,1594580.80,142992.30,729970),('1','150','257804','329',670.00,736.00,0.00,1278.95,856896.50,941307.20,84410.70,729971),('1','150','257805','329',670.00,736.00,0.00,2326.25,1558587.50,1712120.00,153532.50,729972),('1','150','257806','329',670.00,736.00,0.00,1772.34,1187467.80,1304442.24,116974.44,729973),('1','150','257807','329',670.00,736.00,0.00,1065.09,713610.30,783906.24,70295.94,729974),('1','150','257808','329',670.00,736.00,0.00,1089.08,729683.60,801562.88,71879.28,729975),('1','150','257809','329',670.00,736.00,0.00,1994.85,1336549.50,1468209.60,131660.10,729976),('1','150','257810','329',670.00,736.00,0.00,2256.47,1511834.90,1660761.92,148927.02,729977),('1','150','257811','329',670.00,736.00,0.00,83.89,56206.30,61743.04,5536.74,729978),('1','150','257812','329',670.00,736.00,0.00,2192.41,1468914.70,1613613.76,144699.06,729979),('1','150','257813','329',670.00,736.00,0.00,2253.11,1509583.70,1658288.96,148705.26,729980),('1','150','257814','329',670.00,736.00,0.00,926.02,620433.40,681550.72,61117.32,729981),('1','150','257815','329',670.00,736.00,0.00,38.46,25768.20,28306.56,2538.36,729982),('1','150','257816','329',670.00,736.00,0.00,1347.70,902959.00,991907.20,88948.20,729983),('1','150','257817','329',670.00,736.00,0.00,2010.15,1346800.50,1479470.40,132669.90,729984),('1','150','257818','329',670.00,736.00,0.00,519.91,348339.70,382653.76,34314.06,729985),('1','150','257819','329',670.00,736.00,0.00,22.24,14900.80,16368.64,1467.84,729986),('1','150','257820','329',670.00,736.00,0.00,1624.62,1088495.40,1195720.32,107224.92,729987),('1','150','257821','329',670.00,736.00,0.00,1564.63,1048302.10,1151567.68,103265.58,729988),('1','150','257822','329',670.00,736.00,0.00,40.75,27302.50,29992.00,2689.50,729989),('1','150','257823','329',670.00,764.00,0.00,2103.94,1409639.80,1607410.16,197770.36,729990),('1','150','257824','329',670.00,764.00,0.00,1089.76,730139.20,832576.64,102437.44,729991),('1','150','257825','329',670.00,764.00,0.00,16.30,10921.00,12453.20,1532.20,729992),('1','150','257826','329',670.00,748.00,0.00,2432.97,1630089.90,1819861.56,189771.66,729993),('1','150','257827','329',670.00,748.00,0.00,1621.88,1086659.60,1213166.24,126506.64,729994),('1','150','257828','329',670.00,748.00,0.00,5.15,3450.50,3852.20,401.70,729995),('1','150','257829','329',670.00,748.00,0.00,606.98,406676.60,454021.04,47344.44,729996),('1','150','257830','329',670.00,748.00,0.00,2260.05,1514233.50,1690769.40,176535.90,729997),('1','150','257831','329',670.00,748.00,0.00,2129.14,1426523.80,1592596.72,166072.92,729998),('1','150','257832','329',670.00,748.00,0.00,1849.89,1239426.30,1383717.72,144291.42,729999),('1','150','257833','329',670.00,748.00,0.00,1771.18,1186690.60,1324842.64,138152.04,730000),('1','150','257834','329',670.00,760.00,0.00,1526.90,1023023.00,1160444.00,137421.00,730001),('1','150','257835','329',670.00,760.00,0.00,1233.37,826357.90,937361.20,111003.30,730002),('1','150','257836','329',670.00,760.00,0.00,1221.46,818378.20,928309.60,109931.40,730003),('1','150','257837','329',670.00,760.00,0.00,1672.06,1120280.20,1270765.60,150485.40,730004),('1','150','257838','329',670.00,760.00,0.00,531.33,355991.10,403810.80,47819.70,730005),('1','150','257839','329',670.00,760.00,0.00,21.78,14592.60,16552.80,1960.20,730006),('1','150','257840','329',670.00,760.00,0.00,1445.86,968726.20,1098853.60,130127.40,730007),('1','150','257841','329',670.00,760.00,0.00,1452.61,973248.70,1103983.60,130734.90,730008),('1','150','257842','329',670.00,760.00,0.00,1614.24,1081540.80,1226822.40,145281.60,730009),('1','150','257843','329',670.00,760.00,0.00,369.41,247504.70,295528.00,48023.30,730010),('1','150','257844','329',670.00,800.00,0.00,27.88,18679.60,22304.00,3624.40,730011),('1','150','257845','329',670.00,800.00,0.00,1673.59,1121305.30,1338872.00,217566.70,730012),('1','150','257846','329',670.00,800.00,0.00,1373.24,920070.80,1098592.00,178521.20,730013),('1','150','257847','329',670.00,800.00,0.00,1998.21,1338800.70,1525240.40,186439.70,730014),('1','150','257848','329',670.00,760.00,0.00,394.44,264274.80,299774.40,35499.60,730015),('1','150','257849','329',670.00,760.00,0.00,40.52,27148.40,30795.20,3646.80,730016),('1','150','257850','329',670.00,760.00,0.00,1459.07,977576.90,1108893.20,131316.30,730017),('1','150','257851','329',670.00,760.00,0.00,1507.78,1010212.60,1145912.80,135700.20,730018),('1','150','257852','329',670.00,760.00,0.00,1664.74,1115375.80,1265202.40,149826.60,730019),('1','150','257853','329',670.00,760.00,0.00,690.25,462467.50,524590.00,62122.50,730020),('1','150','257854','329',670.00,760.00,0.00,58.16,38967.20,44201.60,5234.40,730021),('1','150','257855','329',670.00,760.00,0.00,1178.93,789883.10,895986.80,106103.70,730022),('1','150','257856','329',670.00,760.00,0.00,1923.22,1288557.40,1461647.20,173089.80,730023),('1','150','257857','329',670.00,760.00,0.00,1686.30,1129821.00,1281588.00,151767.00,730024),('1','150','257858','329',670.00,760.00,0.00,90.78,60822.60,68992.80,8170.20,730025),('1','150','257859','329',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730026),('1','150','257860','329',670.00,760.00,0.00,1316.55,882088.50,1000578.00,118489.50,730027),('1','150','257861','329',670.00,760.00,0.00,1424.71,954555.70,1082779.60,128223.90,730028),('1','150','257862','329',670.00,760.00,0.00,1284.74,860775.80,976402.40,115626.60,730029),('1','150','257863','329',670.00,760.00,0.00,1069.12,716310.40,812531.20,96220.80,730030),('1','150','257864','329',670.00,760.00,0.00,283.94,190239.80,215794.40,25554.60,730031),('1','150','257865','329',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730032),('1','150','257866','329',685.00,760.00,0.00,925.37,633878.45,703281.20,69402.75,730033),('1','150','257867','329',685.00,760.00,0.00,1464.31,1003052.35,1112875.60,109823.25,730034),('1','150','257868','329',685.00,760.00,0.00,1767.16,1210504.60,1343041.60,132537.00,730035),('1','150','257869','329',685.00,760.00,0.00,1097.87,752040.95,834381.20,82340.25,730036),('1','150','257870','329',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730037),('1','150','257871','329',685.00,760.00,0.00,1324.29,907138.65,1006460.40,99321.75,730038),('1','150','257872','329',685.00,760.00,0.00,1498.79,1026671.15,1139080.40,112409.25,730039),('1','150','257873','329',685.00,760.00,0.00,1447.81,991749.85,1100335.60,108585.75,730040),('1','150','257874','329',685.00,760.00,0.00,960.07,657647.95,729653.20,72005.25,730041),('1','150','257875','329',685.00,760.00,0.00,9.04,6192.40,6870.40,678.00,730042),('1','150','257876','329',685.00,760.00,0.00,240.36,164646.60,182673.60,18027.00,730043),('1','150','257877','329',685.00,760.00,0.00,1629.15,1115967.75,1238154.00,122186.25,730044),('1','150','257878','329',685.00,760.00,0.00,1807.62,1238219.70,1373791.20,135571.50,730045),('1','150','257879','329',685.00,760.00,0.00,1441.91,987708.35,1095851.60,108143.25,730046),('1','150','257880','329',685.00,760.00,0.00,100.71,68986.35,76539.60,7553.25,730047),('1','150','257881','329',685.00,760.00,0.00,1156.66,792312.10,879061.60,86749.50,730048),('1','150','257882','329',685.00,760.00,0.00,1362.78,933504.30,1035712.80,102208.50,730049),('1','150','257883','329',685.00,760.00,0.00,1193.95,817855.75,907402.00,89546.25,730050),('1','150','257884','329',685.00,760.00,0.00,1309.59,897069.15,995288.40,98219.25,730051),('1','150','257885','329',685.00,760.00,0.00,379.81,260169.85,288655.60,28485.75,730052),('1','150','257886','329',685.00,760.00,0.00,894.37,612643.45,679721.20,67077.75,730053),('1','150','257887','329',685.00,760.00,0.00,2169.47,1486086.95,1648797.20,162710.25,730054),('1','150','257888','329',685.00,760.00,0.00,1431.64,980673.40,1088046.40,107373.00,730055),('1','150','257889','329',685.00,760.00,0.00,647.80,443743.00,492328.00,48585.00,730056),('1','150','257890','329',670.00,760.00,0.00,574.75,385082.50,436810.00,51727.50,730057),('1','150','257891','329',670.00,760.00,0.00,1559.40,1044798.00,1185144.00,140346.00,730058),('1','150','257892','329',670.00,760.00,0.00,1511.18,1012490.60,1148496.80,136006.20,730059),('1','150','257893','329',670.00,760.00,0.00,1430.43,958388.10,1087126.80,128738.70,730060),('1','150','257894','329',670.00,760.00,0.00,137.97,92439.90,104857.20,12417.30,730061),('1','150','257895','329',670.00,760.00,0.00,1636.93,1096743.10,1244066.80,147323.70,730062),('1','150','257896','329',670.00,760.00,0.00,1903.57,1275391.90,1446713.20,171321.30,730063),('1','150','257897','329',670.00,760.00,0.00,1611.82,1079919.40,1224983.20,145063.80,730064),('1','150','257898','329',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730065),('1','150','257899','329',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730066),('1','150','257900','329',685.00,760.00,0.00,1038.40,711304.00,789184.00,77880.00,730067),('1','150','257901','329',685.00,760.00,0.00,1461.31,1000997.35,1110595.60,109598.25,730068),('1','150','257902','329',685.00,760.00,0.00,1324.26,907118.10,1006437.60,99319.50,730069),('1','150','257903','329',685.00,760.00,0.00,292.97,200684.45,222657.20,21972.75,730070),('1','150','257904','329',685.00,760.00,0.00,870.56,583275.20,640732.16,57456.96,730071),('1','150','257905','329',670.00,736.00,0.00,32.37,21687.90,23824.32,2136.42,730072),('1','150','257906','329',670.00,736.00,0.00,2029.04,1359456.80,1493373.44,133916.64,730073),('1','150','257907','329',670.00,736.00,0.00,2145.49,1437478.30,1579080.64,141602.34,730074),('1','150','257908','329',670.00,736.00,0.00,801.80,537206.00,590124.80,52918.80,730075),('1','150','257909','329',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730076),('1','150','257910','329',670.00,736.00,0.00,398.18,264391.52,293060.48,28668.96,730077),('1','150','257911','329',664.00,736.00,0.00,1466.63,973842.32,1079439.68,105597.36,730078),('1','150','257912','329',664.00,736.00,0.00,1261.20,837436.80,928243.20,90806.40,730079),('1','150','257913','329',664.00,736.00,0.00,1404.18,932375.52,1033476.48,101100.96,730080),('1','150','257914','329',664.00,736.00,0.00,1163.11,772305.04,856048.96,83743.92,730081),('1','150','257915','329',664.00,736.00,0.00,1748.52,1161017.28,1286910.72,125893.44,730082),('1','150','257916','329',664.00,736.00,0.00,1967.59,1306479.76,1448146.24,141666.48,730083),('1','150','257917','329',664.00,736.00,0.00,1405.10,932986.40,1034153.60,101167.20,730084),('1','150','257918','329',664.00,736.00,0.00,34.93,23193.52,25708.48,2514.96,730085),('1','150','257919','329',664.00,736.00,0.00,1446.88,960728.32,1064903.68,104175.36,730086),('1','150','257920','329',664.00,736.00,0.00,1701.67,1129908.88,1252429.12,122520.24,730087),('1','150','257921','329',664.00,736.00,0.00,1821.06,1209183.84,1340300.16,131116.32,730088),('1','150','257922','329',664.00,736.00,0.00,2023.64,1343696.96,1489399.04,145702.08,730089),('1','150','257923','329',664.00,736.00,0.00,2833.62,1881523.68,2085544.32,204020.64,730090),('1','150','257924','329',664.00,736.00,0.00,613.65,407463.60,451646.40,44182.80,730091),('1','150','257925','329',664.00,736.00,0.00,1172.58,778593.12,863018.88,84425.76,730092),('1','150','257926','329',664.00,736.00,0.00,1830.48,1215438.72,1347233.28,131794.56,730093),('1','150','257927','329',664.00,736.00,0.00,1354.00,899056.00,996544.00,97488.00,730094),('1','150','257928','329',664.00,736.00,0.00,931.65,618615.60,685694.40,67078.80,730095),('1','150','257929','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730096),('1','150','257930','329',664.00,736.00,0.00,1632.27,1083827.28,1201350.72,117523.44,730097),('1','150','257931','329',664.00,736.00,0.00,1454.96,966093.44,1070850.56,104757.12,730098),('1','150','257932','329',664.00,736.00,0.00,1839.96,1221733.44,1354210.56,132477.12,730099),('1','150','257933','329',664.00,736.00,0.00,452.61,300533.04,333120.96,32587.92,730100),('1','150','257934','329',664.00,736.00,0.00,1030.28,684105.92,758286.08,74180.16,730101),('1','150','257935','329',664.00,736.00,0.00,1540.21,1022699.44,1133594.56,110895.12,730102),('1','150','257936','329',664.00,736.00,0.00,1509.26,1002148.64,1110815.36,108666.72,730103),('1','150','257937','329',664.00,736.00,0.00,957.38,635700.32,704631.68,68931.36,730104),('1','150','257938','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730105),('1','150','257939','329',664.00,736.00,0.00,512.30,340167.20,377052.80,36885.60,730106),('1','150','257940','329',664.00,736.00,0.00,1635.68,1086091.52,1203860.48,117768.96,730107),('1','150','257941','329',664.00,736.00,0.00,1660.65,1102671.60,1222238.40,119566.80,730108),('1','150','257942','329',664.00,736.00,0.00,1304.07,865902.48,959795.52,93893.04,730109),('1','150','257943','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730110),('1','150','257944','329',664.00,736.00,0.00,2758.80,1831843.20,2030476.80,198633.60,730111),('1','150','257945','329',664.00,736.00,0.00,1859.62,1234787.68,1368680.32,133892.64,730112),('1','150','257946','329',664.00,736.00,0.00,662.56,439939.84,487644.16,47704.32,730113),('1','150','257947','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730114),('1','150','257948','329',664.00,736.00,0.00,1338.76,888936.64,985327.36,96390.72,730115),('1','150','257949','329',664.00,736.00,0.00,1964.06,1304135.84,1445548.16,141412.32,730116),('1','150','257950','329',664.00,736.00,0.00,1754.19,1164782.16,1291083.84,126301.68,730117),('1','150','257951','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730118),('1','150','257952','329',664.00,736.00,0.00,1650.49,1095925.36,1214760.64,118835.28,730119),('1','150','257953','329',664.00,736.00,0.00,2313.98,1536482.72,1703089.28,166606.56,730120),('1','150','257954','329',664.00,736.00,0.00,1189.33,789715.12,875346.88,85631.76,730121),('1','150','257955','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730122),('1','150','257956','329',664.00,736.00,0.00,1827.81,1213665.84,1345268.16,131602.32,730123),('1','150','257957','329',664.00,736.00,0.00,1763.24,1170791.36,1297744.64,126953.28,730124),('1','150','257958','329',664.00,736.00,0.00,1548.58,1028257.12,1139754.88,111497.76,730125),('1','150','257959','329',664.00,736.00,0.00,1369.97,909660.08,1008297.92,98637.84,730126),('1','150','257960','329',664.00,736.00,0.00,1289.31,856101.84,948932.16,92830.32,730127),('1','150','257961','329',664.00,736.00,0.00,1655.65,1099351.60,1218558.40,119206.80,730128),('1','150','257962','329',664.00,736.00,0.00,1004.85,667220.40,739569.60,72349.20,730129),('1','150','257963','329',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730130),('1','150','257964','329',664.00,736.00,0.00,473.82,303244.80,348731.52,45486.72,730131),('1','150','257965','329',640.00,736.00,0.00,1374.76,879846.40,1011823.36,131976.96,730132),('1','150','257966','329',640.00,736.00,0.00,1219.91,780742.40,897853.76,117111.36,730133),('1','150','257967','329',640.00,736.00,0.00,1069.60,684544.00,787225.60,102681.60,730134),('1','150','257968','329',640.00,736.00,0.00,434.91,278342.40,320093.76,41751.36,730135),('1','150','257969','329',640.00,736.00,0.00,1009.28,645939.20,742830.08,96890.88,730136),('1','150','257970','329',640.00,736.00,0.00,1267.65,811296.00,932990.40,121694.40,730137),('1','150','257971','329',640.00,736.00,0.00,1541.19,986361.60,1134315.84,147954.24,730138),('1','150','257972','329',640.00,736.00,0.00,1748.88,1119283.20,1287175.68,167892.48,730139),('1','150','257973','329',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730140),('1','150','257974','329',640.00,736.00,0.00,1241.76,794726.40,913935.36,119208.96,730141),('1','150','257975','329',640.00,736.00,0.00,1426.61,913030.40,1049984.96,136954.56,730142),('1','150','257976','329',640.00,736.00,0.00,1307.08,836531.20,962010.88,125479.68,730143),('1','150','257977','329',640.00,736.00,0.00,1156.12,739916.80,850904.32,110987.52,730144),('1','150','257978','329',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730145),('1','150','257979','329',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730146),('1','150','257980','329',640.00,736.00,0.00,369.36,236390.40,271848.96,35458.56,730147),('1','150','257981','329',640.00,736.00,0.00,1595.29,1020985.60,1174133.44,153147.84,730148),('1','150','257982','329',640.00,736.00,0.00,1861.37,1191276.80,1369968.32,178691.52,730149),('1','150','257983','329',640.00,736.00,0.00,1703.99,1090553.60,1254136.64,163583.04,730150),('1','150','257984','329',640.00,736.00,0.00,173.99,111353.60,128056.64,16703.04,730151),('1','150','257985','329',640.00,736.00,0.00,1317.32,843084.80,969547.52,126462.72,730152),('1','150','257986','329',640.00,736.00,0.00,1398.33,894931.20,1029170.88,134239.68,730153),('1','150','257987','329',640.00,736.00,0.00,1562.82,1000204.80,1150235.52,150030.72,730154),('1','150','257988','329',640.00,736.00,0.00,857.00,548480.00,630752.00,82272.00,730155),('1','150','257989','329',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730156),('1','150','257990','329',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730157),('1','150','257991','329',640.00,736.00,0.00,376.59,241017.60,277170.24,36152.64,730158),('1','150','257992','329',640.00,736.00,0.00,1336.45,855328.00,983627.20,128299.20,730159),('1','150','257993','329',640.00,736.00,0.00,1644.26,1052326.40,1210175.36,157848.96,730160),('1','150','257994','329',640.00,736.00,0.00,1998.78,1279219.20,1471102.08,191882.88,730161),('1','150','257995','329',640.00,736.00,0.00,132.64,84889.60,97623.04,12733.44,730162),('1','150','257996','329',640.00,736.00,0.00,1282.08,820531.20,943610.88,123079.68,730163),('1','150','257997','329',640.00,736.00,0.00,1402.16,897382.40,1031989.76,134607.36,730164),('1','150','257998','329',640.00,736.00,0.00,1226.50,784960.00,902704.00,117744.00,730165),('1','150','257999','329',640.00,736.00,0.00,1264.45,809248.00,930635.20,121387.20,730166),('1','150','258000','329',640.00,736.00,0.00,1228.59,786297.60,904242.24,117944.64,730167),('1','150','258001','329',640.00,736.00,0.00,1690.23,1081747.20,1244009.28,162262.08,730168),('1','150','258002','329',640.00,736.00,0.00,1987.55,1272032.00,1462836.80,190804.80,730169),('1','150','258003','329',640.00,736.00,0.00,1113.49,712633.60,819528.64,106895.04,730170),('1','150','258004','329',640.00,736.00,0.00,990.36,633830.40,728904.96,95074.56,730171),('1','150','258005','329',640.00,736.00,0.00,1482.51,948806.40,1091127.36,142320.96,730172),('1','150','258006','329',640.00,736.00,0.00,1742.33,1115091.20,1282354.88,167263.68,730173),('1','150','258007','329',640.00,736.00,0.00,1949.15,1247456.00,1434574.40,187118.40,730174),('1','150','258008','329',640.00,736.00,0.00,2264.33,1449171.20,1666546.88,217375.68,730175),('1','150','258009','329',640.00,736.00,0.00,1624.50,1039680.00,1195632.00,155952.00,730176),('1','150','258010','329',640.00,736.00,0.00,1361.48,871347.20,1002049.28,130702.08,730177),('1','150','258011','329',640.00,736.00,0.00,1343.13,859603.20,988543.68,128940.48,730178),('1','150','258012','329',640.00,736.00,0.00,1282.65,820896.00,944030.40,123134.40,730179),('1','150','258013','329',640.00,736.00,0.00,249.08,159411.20,183322.88,23911.68,730180),('1','150','258014','329',640.00,736.00,0.00,934.18,597875.20,687556.48,89681.28,730181),('1','150','258015','329',640.00,736.00,0.00,1599.23,1023507.20,1177033.28,153526.08,730182),('1','150','258016','329',640.00,736.00,0.00,1911.29,1223225.60,1406709.44,183483.84,730183),('1','150','258017','329',640.00,736.00,0.00,1180.44,755481.60,868803.84,113322.24,730184),('1','150','258018','329',640.00,736.00,0.00,1137.40,727936.00,837126.40,109190.40,730185),('1','150','258019','329',640.00,736.00,0.00,1163.45,744608.00,814415.00,69807.00,730186),('1','150','258020','329',640.00,700.00,0.00,1398.46,895014.40,978922.00,83907.60,730187),('1','150','258021','329',640.00,700.00,0.00,836.88,535603.20,585816.00,50212.80,730188),('1','150','258022','329',640.00,700.00,0.00,176.49,112953.60,123543.00,10589.40,730189),('1','150','258023','329',640.00,700.00,0.00,1588.79,1012517.90,1112153.00,99635.10,730190),('1','150','258024','329',634.00,700.00,0.00,1334.16,845857.44,933912.00,88054.56,730191),('1','150','258025','329',634.00,700.00,0.00,1287.09,816015.06,900963.00,84947.94,730192),('1','150','258026','329',634.00,700.00,0.00,267.45,169563.30,187215.00,17651.70,730193),('1','150','258027','329',634.00,700.00,0.00,1247.39,790845.26,873173.00,82327.74,730194),('1','150','258028','329',634.00,700.00,0.00,1247.35,790819.90,873145.00,82325.10,730195),('1','150','258029','329',634.00,700.00,0.00,1259.79,798706.86,881853.00,83146.14,730196),('1','150','258030','329',634.00,700.00,0.00,1154.04,731661.36,807828.00,76166.64,730197),('1','150','258031','329',634.00,700.00,0.00,952.67,603992.78,666869.00,62876.22,730198),('1','150','258032','329',634.00,700.00,0.00,320.23,203025.82,224161.00,21135.18,730199),('1','150','258033','329',634.00,700.00,0.00,1826.97,1158298.98,1278879.00,120580.02,730200),('1','150','258034','329',634.00,700.00,0.00,1519.86,963591.24,1063902.00,100310.76,730201);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=307 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',306,'150','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=772 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','150','306',771,1,'329','LPG TANK',7000.00,1.00,934.21,'TANK CONTAINING LPG','479','2020-08-10 22:09:36','2020-08-12 11:56:26','487',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','150',771,1542.94,'2023-03-20 21:16:24');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2744816 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2113176,'1','150','771',329,'Retail Sale Id 1256522',260697.60,0.00,0.00,0.00,15478.92,'2021-12-01 11:27:52','',''),(2113177,'1','150','771',329,'Retail sales',0.00,0.00,0.00,407.34,0.00,'2021-12-01 11:27:52','',''),(2120782,'1','150','771',329,'Retail Sale Id 1260046',0.00,0.00,0.00,0.00,0.00,'2021-12-02 06:35:39','',''),(2120783,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-02 06:35:39','',''),(2123557,'1','150','771',329,'Retail Sale Id 1261334',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 08:52:01','',''),(2123558,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:52:01','',''),(2123573,'1','150','771',329,'Retail Sale Id 1261349',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:52:35','',''),(2123574,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:52:35','',''),(2123585,'1','150','771',329,'Retail Sale Id 1261352',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 08:53:12','',''),(2123586,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 08:53:12','',''),(2123595,'1','150','771',329,'Retail Sale Id 1261358',16000.00,0.00,0.00,0.00,950.00,'2021-12-02 08:53:48','',''),(2123596,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 08:53:48','',''),(2123607,'1','150','771',329,'Retail Sale Id 1261363',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:54:30','',''),(2123608,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:54:30','',''),(2123621,'1','150','771',329,'Retail Sale Id 1261371',9600.00,0.00,0.00,0.00,570.00,'2021-12-02 08:55:14','',''),(2123622,'1','150','771',329,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 08:55:14','',''),(2123639,'1','150','771',329,'Retail Sale Id 1261379',48000.00,0.00,0.00,0.00,2850.00,'2021-12-02 08:56:00','',''),(2123640,'1','150','771',329,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-02 08:56:00','',''),(2123659,'1','150','771',329,'Retail Sale Id 1261388',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 08:56:50','',''),(2123660,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:56:50','',''),(2123675,'1','150','771',329,'Retail Sale Id 1261397',28000.00,0.00,0.00,0.00,1662.50,'2021-12-02 08:57:55','',''),(2123676,'1','150','771',329,'Retail sales',0.00,0.00,0.00,43.75,0.00,'2021-12-02 08:57:55','',''),(2127370,'1','150','771',329,'Retail Sale Id 1263262',200000.00,0.00,0.00,0.00,11875.00,'2021-12-02 12:43:36','',''),(2127371,'1','150','771',329,'Retail sales',0.00,0.00,0.00,312.50,0.00,'2021-12-02 12:43:36','',''),(2127499,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,2125280.00,3590.00,0.00,0.00,'2021-12-02 12:52:43','',''),(2129134,'1','150','771',329,'Retail Sale Id 1264020',50003.20,0.00,0.00,0.00,3750.24,'2021-12-02 14:29:42','',''),(2129135,'1','150','771',329,'Retail sales',0.00,0.00,0.00,78.13,0.00,'2021-12-02 14:29:42','',''),(2133417,'1','150','771',329,'Retail Sale Id 1266033',823020.80,0.00,0.00,0.00,61726.56,'2021-12-02 19:23:00','',''),(2133418,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1285.97,0.00,'2021-12-02 19:23:00','',''),(2133816,'1','150','771',329,'Retail Sale Id 1266066',0.00,0.00,0.00,0.00,0.00,'2021-12-03 05:46:18','',''),(2133817,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-03 05:46:18','',''),(2133822,'1','150','771',329,'Retail Sale Id 1266067',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 05:47:33','',''),(2133823,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 05:47:33','',''),(2144352,'1','150','771',329,'Retail Sale Id 1271100',250003.20,0.00,0.00,0.00,18750.24,'2021-12-03 16:18:53','',''),(2144353,'1','150','771',329,'Retail sales',0.00,0.00,0.00,390.63,0.00,'2021-12-03 16:18:53','',''),(2144378,'1','150','771',329,'Retail Sale Id 1271112',250003.20,0.00,0.00,0.00,18750.24,'2021-12-03 16:19:34','',''),(2144379,'1','150','771',329,'Retail sales',0.00,0.00,0.00,390.63,0.00,'2021-12-03 16:19:34','',''),(2144414,'1','150',NULL,329,'Reception corrector for bridging 125948',0.00,0.00,0.00,3590.00,0.00,'2021-12-03 16:21:23','',''),(2144415,'1','150','771',329,'Received from bridging 125948',0.00,0.00,3590.00,0.00,0.00,'2021-12-03 16:21:23','',''),(2146193,'1','150','771',329,'Retail Sale Id 1271921',492582.40,0.00,0.00,0.00,36943.68,'2021-12-03 20:43:43','',''),(2146194,'1','150','771',329,'Retail sales',0.00,0.00,0.00,769.66,0.00,'2021-12-03 20:43:43','',''),(2146206,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,3113920.00,5260.00,0.00,0.00,'2021-12-03 20:53:44','',''),(2146440,'1','150','771',329,'Retail Sale Id 1271933',0.00,0.00,0.00,0.00,0.00,'2021-12-04 05:13:14','',''),(2146441,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-04 05:13:14','',''),(2160790,'1','150','771',329,'Retail Sale Id 1278386',250003.20,0.00,0.00,0.00,18750.24,'2021-12-04 18:02:49','',''),(2160791,'1','150','771',329,'Retail sales',0.00,0.00,0.00,390.63,0.00,'2021-12-04 18:02:49','',''),(2160804,'1','150','771',329,'Retail Sale Id 1278391',250003.20,0.00,0.00,0.00,18750.24,'2021-12-04 18:03:23','',''),(2160805,'1','150','771',329,'Retail sales',0.00,0.00,0.00,390.63,0.00,'2021-12-04 18:03:23','',''),(2160849,'1','150','771',329,'Retail Sale Id 1278414',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 18:07:39','',''),(2160850,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 18:07:39','',''),(2161284,'1','150','771',329,'Retail Sale Id 1278573',368057.60,0.00,0.00,0.00,27604.32,'2021-12-04 19:51:06','',''),(2161285,'1','150','771',329,'Retail sales',0.00,0.00,0.00,575.09,0.00,'2021-12-04 19:51:06','',''),(2161811,'1','150','771',329,'Retail Sale Id 1278594',0.00,0.00,0.00,0.00,0.00,'2021-12-05 05:04:47','',''),(2161812,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-05 05:04:47','',''),(2163048,'1','150','771',329,'Retail Sale Id 1279150',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:18:56','',''),(2163049,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:18:56','',''),(2163066,'1','150','771',329,'Retail Sale Id 1279153',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 07:19:41','',''),(2163067,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 07:19:41','',''),(2163074,'1','150','771',329,'Retail Sale Id 1279161',48000.00,0.00,0.00,0.00,3600.00,'2021-12-05 07:20:25','',''),(2163075,'1','150','771',329,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-05 07:20:25','',''),(2169863,'1','150','771',329,'Retail Sale Id 1282815',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:30:09','',''),(2169864,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:30:09','',''),(2169873,'1','150','771',329,'Retail Sale Id 1282820',95001.60,0.00,0.00,0.00,7125.12,'2021-12-05 13:30:50','',''),(2169874,'1','150','771',329,'Retail sales',0.00,0.00,0.00,148.44,0.00,'2021-12-05 13:30:50','',''),(2169883,'1','150','771',329,'Retail Sale Id 1282824',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 13:31:25','',''),(2169884,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:31:25','',''),(2169893,'1','150','771',329,'Retail Sale Id 1282831',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:31:53','',''),(2169894,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:31:53','',''),(2169915,'1','150','771',329,'Retail Sale Id 1282836',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 13:32:27','',''),(2169916,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:32:27','',''),(2169917,'1','150','771',329,'Retail Sale Id 1282837',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:32:57','',''),(2169918,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:32:57','',''),(2169925,'1','150','771',329,'Retail Sale Id 1282841',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:33:28','',''),(2169926,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:33:28','',''),(2169951,'1','150','771',329,'Retail Sale Id 1282853',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:34:25','',''),(2169952,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:34:25','',''),(2169961,'1','150','771',329,'Retail Sale Id 1282856',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 13:34:46','',''),(2169962,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:34:46','',''),(2169971,'1','150','771',329,'Retail Sale Id 1282862',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:35:30','',''),(2169972,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:35:30','',''),(2169981,'1','150','771',329,'Retail Sale Id 1282867',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:35:50','',''),(2169982,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:35:50','',''),(2169987,'1','150','771',329,'Retail Sale Id 1282869',48000.00,0.00,0.00,0.00,3600.00,'2021-12-05 13:36:18','',''),(2169988,'1','150','771',329,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-05 13:36:18','',''),(2170003,'1','150','771',329,'Retail Sale Id 1282879',12000.00,0.00,0.00,0.00,900.00,'2021-12-05 13:36:54','',''),(2170004,'1','150','771',329,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-05 13:36:54','',''),(2170043,'1','150','771',329,'Retail Sale Id 1282893',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:39:06','',''),(2170044,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:39:06','',''),(2170049,'1','150','771',329,'Retail Sale Id 1282896',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:39:49','',''),(2170050,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:39:49','',''),(2172289,'1','150','771',329,'Retail Sale Id 1283872',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 15:46:15','',''),(2172290,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 15:46:15','',''),(2172305,'1','150','771',329,'Retail Sale Id 1283880',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 15:46:53','',''),(2172306,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 15:46:53','',''),(2172319,'1','150','771',329,'Retail Sale Id 1283887',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:47:18','',''),(2172320,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:47:18','',''),(2172323,'1','150','771',329,'Retail Sale Id 1283890',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 15:47:39','',''),(2172324,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 15:47:39','',''),(2174062,'1','150','771',329,'Retail Sale Id 1284779',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:51:24','',''),(2174063,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:51:24','',''),(2174324,'1','150','771',329,'Retail Sale Id 1284853',430368.00,0.00,0.00,0.00,32277.60,'2021-12-05 19:09:02','',''),(2174325,'1','150','771',329,'Retail sales',0.00,0.00,0.00,672.45,0.00,'2021-12-05 19:09:02','',''),(2174774,'1','150','771',329,'Retail Sale Id 1284882',0.00,0.00,0.00,0.00,0.00,'2021-12-06 05:50:44','',''),(2174775,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-06 05:50:44','',''),(2174776,'1','150','771',329,'Retail Sale Id 1284895',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 05:53:46','',''),(2174777,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 05:53:46','',''),(2174778,'1','150','771',329,'Retail Sale Id 1284896',9600.00,0.00,0.00,0.00,720.00,'2021-12-06 05:54:08','',''),(2174779,'1','150','771',329,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 05:54:08','',''),(2174780,'1','150','771',329,'Retail Sale Id 1284897',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 05:54:27','',''),(2174781,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 05:54:27','',''),(2174782,'1','150','771',329,'Retail Sale Id 1284898',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 05:54:47','',''),(2174783,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 05:54:47','',''),(2174784,'1','150','771',329,'Retail Sale Id 1284899',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 05:55:15','',''),(2174785,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 05:55:15','',''),(2186562,'1','150','771',329,'Retail Sale Id 1290587',773510.40,0.00,0.00,0.00,58013.28,'2021-12-06 19:03:40','',''),(2186563,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1208.61,0.00,'2021-12-06 19:03:40','',''),(2186568,'1','150',NULL,329,'Reception corrector for bridging 126135',0.00,0.00,0.00,5260.00,0.00,'2021-12-06 19:07:11','',''),(2186569,'1','150','771',329,'Received from bridging 126135',0.00,0.00,5260.00,0.00,0.00,'2021-12-06 19:07:11','',''),(2186983,'1','150','771',329,'Retail Sale Id 1290608',0.00,0.00,0.00,0.00,0.00,'2021-12-07 05:10:02','',''),(2186984,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-07 05:10:02','',''),(2191018,'1','150','771',329,'Retail Sale Id 1292543',186969.60,0.00,0.00,0.00,14022.72,'2021-12-07 09:41:49','',''),(2191019,'1','150','771',329,'Retail sales',0.00,0.00,0.00,292.14,0.00,'2021-12-07 09:41:49','',''),(2208514,'1','150','771',329,'Retail Sale Id 1300809',0.00,0.00,0.00,0.00,0.00,'2021-12-08 15:25:25','',''),(2208515,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-08 15:25:25','',''),(2209087,'1','150','771',329,'Retail Sale Id 1301097',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 15:55:44','',''),(2209088,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 15:55:44','',''),(2209143,'1','150','771',329,'Retail Sale Id 1301125',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:58:53','',''),(2209144,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:58:53','',''),(2209163,'1','150','771',329,'Retail Sale Id 1301137',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 15:59:51','',''),(2209164,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 15:59:51','',''),(2209191,'1','150','771',329,'Retail Sale Id 1301148',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:00:50','',''),(2209192,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:00:50','',''),(2209219,'1','150','771',329,'Retail Sale Id 1301165',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 16:01:59','',''),(2209220,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 16:01:59','',''),(2209301,'1','150','771',329,'Retail Sale Id 1301207',4499.20,0.00,0.00,0.00,337.44,'2021-12-08 16:06:01','',''),(2209302,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-08 16:06:01','',''),(2209321,'1','150','771',329,'Retail Sale Id 1301215',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:07:04','',''),(2209322,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:07:04','',''),(2209377,'1','150','771',329,'Retail Sale Id 1301239',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:09:26','',''),(2209378,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:09:26','',''),(2209406,'1','150','771',329,'Retail Sale Id 1301249',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:10:28','',''),(2209407,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:10:28','',''),(2209432,'1','150','771',329,'Retail Sale Id 1301263',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:11:34','',''),(2209433,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:11:34','',''),(2209460,'1','150','771',329,'Retail Sale Id 1301279',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 16:12:12','',''),(2209461,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 16:12:12','',''),(2209474,'1','150','771',329,'Retail Sale Id 1301284',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:12:52','',''),(2209475,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:12:52','',''),(2209514,'1','150','771',329,'Retail Sale Id 1301306',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 16:14:52','',''),(2209515,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 16:14:52','',''),(2209553,'1','150','771',329,'Retail Sale Id 1301321',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:16:10','',''),(2209554,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:16:10','',''),(2209590,'1','150','771',329,'Retail Sale Id 1301329',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:16:49','',''),(2209591,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:16:49','',''),(2209632,'1','150','771',329,'Retail Sale Id 1301342',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:18:43','',''),(2209633,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:18:43','',''),(2209650,'1','150','771',329,'Retail Sale Id 1301356',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:19:28','',''),(2209651,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:19:28','',''),(2209660,'1','150','771',329,'Retail Sale Id 1301363',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 16:20:16','',''),(2209661,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 16:20:16','',''),(2209692,'1','150','771',329,'Retail Sale Id 1301379',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:21:57','',''),(2209693,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:21:57','',''),(2209747,'1','150','771',329,'Retail Sale Id 1301414',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:24:36','',''),(2209748,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:24:36','',''),(2209769,'1','150','771',329,'Retail Sale Id 1301424',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 16:25:39','',''),(2209770,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 16:25:39','',''),(2209804,'1','150','771',329,'Retail Sale Id 1301558',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:29:11','',''),(2209805,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:29:11','',''),(2210229,'1','150','771',329,'Retail Sale Id 1301767',100000.00,0.00,0.00,0.00,7500.00,'2021-12-08 16:49:05','',''),(2210230,'1','150','771',329,'Retail sales',0.00,0.00,0.00,156.25,0.00,'2021-12-08 16:49:05','',''),(2210235,'1','150','771',329,'Retail Sale Id 1301770',50003.20,0.00,0.00,0.00,3750.24,'2021-12-08 16:49:30','',''),(2210236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,78.13,0.00,'2021-12-08 16:49:30','',''),(2210593,'1','150','771',329,'Retail Sale Id 1301961',50003.20,0.00,0.00,0.00,3750.24,'2021-12-08 17:16:39','',''),(2210594,'1','150','771',329,'Retail sales',0.00,0.00,0.00,78.13,0.00,'2021-12-08 17:16:39','',''),(2211012,'1','150','771',329,'Retail Sale Id 1302151',10003.20,0.00,0.00,0.00,750.24,'2021-12-08 18:09:17','',''),(2211013,'1','150','771',329,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-08 18:09:17','',''),(2211015,'1','150','771',329,'Retail Sale Id 1302152',90003.20,0.00,0.00,0.00,6750.24,'2021-12-08 18:09:58','',''),(2211016,'1','150','771',329,'Retail sales',0.00,0.00,0.00,140.63,0.00,'2021-12-08 18:09:58','',''),(2211149,'1','150','771',329,'Retail Sale Id 1302201',213126.40,0.00,0.00,0.00,15984.48,'2021-12-08 18:44:13','',''),(2211150,'1','150','771',329,'Retail sales',0.00,0.00,0.00,333.01,0.00,'2021-12-08 18:44:13','',''),(2211814,'1','150','771',329,'Retail Sale Id 1302283',998.40,0.00,0.00,0.00,74.88,'2021-12-09 05:50:55','',''),(2211815,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 05:50:55','',''),(2211818,'1','150','771',329,'Retail Sale Id 1302285',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 05:51:58','',''),(2211819,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 05:51:58','',''),(2211824,'1','150','771',329,'Retail Sale Id 1302288',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 05:52:52','',''),(2211825,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 05:52:52','',''),(2211830,'1','150','771',329,'Retail Sale Id 1302291',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 05:53:29','',''),(2211831,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 05:53:29','',''),(2211838,'1','150','771',329,'Retail Sale Id 1302295',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 05:54:35','',''),(2211839,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 05:54:35','',''),(2211849,'1','150','771',329,'Retail Sale Id 1302300',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 05:55:21','',''),(2211850,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 05:55:21','',''),(2211855,'1','150','771',329,'Retail Sale Id 1302303',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 05:56:20','',''),(2211856,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 05:56:20','',''),(2211865,'1','150','771',329,'Retail Sale Id 1302307',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 05:57:17','',''),(2211866,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 05:57:17','',''),(2211875,'1','150','771',329,'Retail Sale Id 1302314',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 05:58:15','',''),(2211876,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 05:58:15','',''),(2211885,'1','150','771',329,'Retail Sale Id 1302319',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 05:58:59','',''),(2211886,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 05:58:59','',''),(2211900,'1','150','771',329,'Retail Sale Id 1302325',499.20,0.00,0.00,0.00,37.44,'2021-12-09 06:01:23','',''),(2211901,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-09 06:01:23','',''),(2211930,'1','150','771',329,'Retail Sale Id 1302342',1702.40,0.00,0.00,0.00,127.68,'2021-12-09 06:04:11','',''),(2211931,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-09 06:04:11','',''),(2211974,'1','150','771',329,'Retail Sale Id 1302360',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 06:08:32','',''),(2211975,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 06:08:32','',''),(2212002,'1','150','771',329,'Retail Sale Id 1302376',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:11:46','',''),(2212003,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:11:46','',''),(2212016,'1','150','771',329,'Retail Sale Id 1302383',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:12:39','',''),(2212017,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:12:39','',''),(2212028,'1','150','771',329,'Retail Sale Id 1302387',6003.20,0.00,0.00,0.00,450.24,'2021-12-09 06:13:31','',''),(2212029,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-09 06:13:31','',''),(2212084,'1','150','771',329,'Retail Sale Id 1302417',998.40,0.00,0.00,0.00,74.88,'2021-12-09 06:18:22','',''),(2212085,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 06:18:22','',''),(2212127,'1','150','771',329,'Retail Sale Id 1302424',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:20:05','',''),(2212128,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:20:05','',''),(2212242,'1','150','771',329,'Retail Sale Id 1302478',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:26:55','',''),(2212243,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:26:55','',''),(2212252,'1','150','771',329,'Retail Sale Id 1302482',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:27:54','',''),(2212253,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:27:54','',''),(2212266,'1','150','771',329,'Retail Sale Id 1302490',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:28:53','',''),(2212267,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:28:53','',''),(2212286,'1','150','771',329,'Retail Sale Id 1302500',998.40,0.00,0.00,0.00,74.88,'2021-12-09 06:30:05','',''),(2212287,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 06:30:05','',''),(2212344,'1','150','771',329,'Retail Sale Id 1302524',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 06:33:53','',''),(2212345,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 06:33:53','',''),(2212359,'1','150','771',329,'Retail Sale Id 1302527',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 06:34:36','',''),(2212360,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 06:34:36','',''),(2212377,'1','150','771',329,'Retail Sale Id 1302532',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:35:40','',''),(2212378,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:35:40','',''),(2212398,'1','150','771',329,'Retail Sale Id 1302538',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:36:24','',''),(2212399,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:36:24','',''),(2212508,'1','150','771',329,'Retail Sale Id 1302593',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 06:42:15','',''),(2212509,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 06:42:15','',''),(2212516,'1','150','771',329,'Retail Sale Id 1302597',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 06:42:51','',''),(2212517,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 06:42:51','',''),(2212597,'1','150','771',329,'Retail Sale Id 1302634',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:46:59','',''),(2212598,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:46:59','',''),(2212617,'1','150','771',329,'Retail Sale Id 1302645',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:47:50','',''),(2212618,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:47:50','',''),(2212623,'1','150','771',329,'Retail Sale Id 1302651',998.40,0.00,0.00,0.00,74.88,'2021-12-09 06:48:41','',''),(2212624,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 06:48:41','',''),(2212670,'1','150','771',329,'Retail Sale Id 1302672',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:50:47','',''),(2212671,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:50:47','',''),(2212738,'1','150','771',329,'Retail Sale Id 1302700',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 06:55:16','',''),(2212739,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 06:55:16','',''),(2212756,'1','150','771',329,'Retail Sale Id 1302705',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:55:53','',''),(2212757,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:55:53','',''),(2212782,'1','150','771',329,'Retail Sale Id 1302716',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:57:30','',''),(2212783,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:57:30','',''),(2212808,'1','150','771',329,'Retail Sale Id 1302727',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 06:58:32','',''),(2212809,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 06:58:32','',''),(2212862,'1','150','771',329,'Retail Sale Id 1302755',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:01:38','',''),(2212863,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:01:38','',''),(2212880,'1','150','771',329,'Retail Sale Id 1302764',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 07:02:27','',''),(2212881,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 07:02:27','',''),(2212888,'1','150','771',329,'Retail Sale Id 1302769',499.20,0.00,0.00,0.00,37.44,'2021-12-09 07:03:22','',''),(2212889,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-09 07:03:22','',''),(2212898,'1','150','771',329,'Retail Sale Id 1302773',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:03:59','',''),(2212899,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:03:59','',''),(2212906,'1','150','771',329,'Retail Sale Id 1302777',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:04:41','',''),(2212907,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:04:41','',''),(2213040,'1','150','771',329,'Retail Sale Id 1302832',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:11:37','',''),(2213041,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:11:37','',''),(2213128,'1','150','771',329,'Retail Sale Id 1302876',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:15:36','',''),(2213129,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:15:36','',''),(2213167,'1','150','771',329,'Retail Sale Id 1302895',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:16:56','',''),(2213168,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:16:56','',''),(2213190,'1','150','771',329,'Retail Sale Id 1302904',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 07:17:37','',''),(2213191,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 07:17:37','',''),(2213202,'1','150','771',329,'Retail Sale Id 1302911',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:18:22','',''),(2213203,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:18:22','',''),(2213220,'1','150','771',329,'Retail Sale Id 1302920',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:19:11','',''),(2213221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:19:11','',''),(2213274,'1','150','771',329,'Retail Sale Id 1302941',601.60,0.00,0.00,0.00,45.12,'2021-12-09 07:21:01','',''),(2213275,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-09 07:21:01','',''),(2213294,'1','150','771',329,'Retail Sale Id 1302951',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:21:40','',''),(2213295,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:21:40','',''),(2213308,'1','150','771',329,'Retail Sale Id 1302959',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:22:21','',''),(2213309,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:22:21','',''),(2213330,'1','150','771',329,'Retail Sale Id 1302969',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:23:30','',''),(2213331,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:23:30','',''),(2213394,'1','150','771',329,'Retail Sale Id 1303005',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:26:20','',''),(2213395,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:26:20','',''),(2213478,'1','150','771',329,'Retail Sale Id 1303046',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:30:15','',''),(2213479,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:30:15','',''),(2213550,'1','150','771',329,'Retail Sale Id 1303079',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:33:47','',''),(2213551,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:33:47','',''),(2213566,'1','150','771',329,'Retail Sale Id 1303088',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:34:20','',''),(2213567,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:34:20','',''),(2213592,'1','150','771',329,'Retail Sale Id 1303103',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:36:05','',''),(2213593,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:36:05','',''),(2213602,'1','150','771',329,'Retail Sale Id 1303107',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:36:32','',''),(2213603,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:36:32','',''),(2213622,'1','150','771',329,'Retail Sale Id 1303118',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:37:47','',''),(2213623,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:37:47','',''),(2213640,'1','150','771',329,'Retail Sale Id 1303125',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:38:23','',''),(2213641,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:38:23','',''),(2213668,'1','150','771',329,'Retail Sale Id 1303143',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 07:40:25','',''),(2213669,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 07:40:25','',''),(2213703,'1','150','771',329,'Retail Sale Id 1303156',4499.20,0.00,0.00,0.00,337.44,'2021-12-09 07:41:57','',''),(2213704,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-09 07:41:57','',''),(2213725,'1','150','771',329,'Retail Sale Id 1303165',7097.60,0.00,0.00,0.00,532.32,'2021-12-09 07:43:00','',''),(2213726,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.09,0.00,'2021-12-09 07:43:00','',''),(2213750,'1','150','771',329,'Retail Sale Id 1303176',6003.20,0.00,0.00,0.00,450.24,'2021-12-09 07:43:43','',''),(2213751,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-09 07:43:43','',''),(2213766,'1','150','771',329,'Retail Sale Id 1303185',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:44:47','',''),(2213767,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:44:47','',''),(2213776,'1','150','771',329,'Retail Sale Id 1303190',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:45:21','',''),(2213777,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:45:21','',''),(2213791,'1','150','771',329,'Retail Sale Id 1303197',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:45:58','',''),(2213792,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:45:58','',''),(2213830,'1','150','771',329,'Retail Sale Id 1303215',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:47:49','',''),(2213831,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:47:49','',''),(2213848,'1','150','771',329,'Retail Sale Id 1303225',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:48:41','',''),(2213849,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:48:41','',''),(2213892,'1','150','771',329,'Retail Sale Id 1303243',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:51:07','',''),(2213893,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:51:07','',''),(2213908,'1','150','771',329,'Retail Sale Id 1303255',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:52:31','',''),(2213909,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:52:31','',''),(2213952,'1','150','771',329,'Retail Sale Id 1303272',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:53:55','',''),(2213953,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:53:55','',''),(2213968,'1','150','771',329,'Retail Sale Id 1303277',3801.60,0.00,0.00,0.00,285.12,'2021-12-09 07:54:53','',''),(2213969,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-09 07:54:53','',''),(2213976,'1','150','771',329,'Retail Sale Id 1303282',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:55:25','',''),(2213977,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:55:25','',''),(2213996,'1','150','771',329,'Retail Sale Id 1303291',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:56:33','',''),(2213997,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:56:33','',''),(2214010,'1','150','771',329,'Retail Sale Id 1303297',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:57:28','',''),(2214011,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:57:28','',''),(2214194,'1','150','771',329,'Retail Sale Id 1303399',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:08:25','',''),(2214195,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:08:25','',''),(2214222,'1','150','771',329,'Retail Sale Id 1303413',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:09:33','',''),(2214223,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:09:33','',''),(2214326,'1','150','771',329,'Retail Sale Id 1303467',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:15:14','',''),(2214327,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:15:14','',''),(2214399,'1','150','771',329,'Retail Sale Id 1303501',998.40,0.00,0.00,0.00,74.88,'2021-12-09 08:18:16','',''),(2214400,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 08:18:16','',''),(2214412,'1','150','771',329,'Retail Sale Id 1303507',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:19:03','',''),(2214413,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:19:03','',''),(2214553,'1','150','771',329,'Retail Sale Id 1303556',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:25:21','',''),(2214554,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:25:21','',''),(2214592,'1','150','771',329,'Retail Sale Id 1303571',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:26:20','',''),(2214593,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:26:20','',''),(2214616,'1','150','771',329,'Retail Sale Id 1303584',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:28:07','',''),(2214617,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:28:07','',''),(2214645,'1','150','771',329,'Retail Sale Id 1303591',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 08:28:52','',''),(2214646,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 08:28:52','',''),(2214720,'1','150','771',329,'Retail Sale Id 1303624',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:32:32','',''),(2214721,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:32:32','',''),(2214734,'1','150','771',329,'Retail Sale Id 1303634',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 08:33:25','',''),(2214735,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:33:25','',''),(2214758,'1','150','771',329,'Retail Sale Id 1303651',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:34:24','',''),(2214759,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:34:24','',''),(2214778,'1','150','771',329,'Retail Sale Id 1303661',0.00,0.00,0.00,0.00,0.00,'2021-12-09 08:35:43','',''),(2214779,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-09 08:35:43','',''),(2214827,'1','150','771',329,'Retail Sale Id 1303686',640.00,0.00,0.00,0.00,48.00,'2021-12-09 08:38:21','',''),(2214828,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 08:38:21','',''),(2214849,'1','150','771',329,'Retail Sale Id 1303694',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:39:07','',''),(2214850,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:39:07','',''),(2214865,'1','150','771',329,'Retail Sale Id 1303704',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 08:39:35','',''),(2214866,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 08:39:35','',''),(2214939,'1','150','771',329,'Retail Sale Id 1303738',998.40,0.00,0.00,0.00,74.88,'2021-12-09 08:43:07','',''),(2214940,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 08:43:07','',''),(2214959,'1','150','771',329,'Retail Sale Id 1303749',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 08:43:56','',''),(2214960,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 08:43:56','',''),(2214975,'1','150','771',329,'Retail Sale Id 1303750',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:44:29','',''),(2214976,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:44:29','',''),(2214997,'1','150','771',329,'Retail Sale Id 1303759',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:45:25','',''),(2214998,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:45:25','',''),(2215028,'1','150','771',329,'Retail Sale Id 1303774',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:47:09','',''),(2215029,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:47:09','',''),(2215062,'1','150','771',329,'Retail Sale Id 1303790',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:49:17','',''),(2215063,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:49:17','',''),(2215100,'1','150','771',329,'Retail Sale Id 1303811',5100.80,0.00,0.00,0.00,382.56,'2021-12-09 08:52:05','',''),(2215101,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.97,0.00,'2021-12-09 08:52:05','',''),(2215126,'1','150','771',329,'Retail Sale Id 1303823',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:53:52','',''),(2215127,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:53:52','',''),(2215152,'1','150','771',329,'Retail Sale Id 1303836',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:55:01','',''),(2215153,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:55:01','',''),(2215174,'1','150','771',329,'Retail Sale Id 1303848',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 08:57:00','',''),(2215175,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 08:57:00','',''),(2215196,'1','150','771',329,'Retail Sale Id 1303861',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:58:18','',''),(2215197,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:58:18','',''),(2215248,'1','150','771',329,'Retail Sale Id 1303889',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:01:12','',''),(2215249,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:01:12','',''),(2215289,'1','150','771',329,'Retail Sale Id 1303908',6003.20,0.00,0.00,0.00,450.24,'2021-12-09 09:02:57','',''),(2215290,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-09 09:02:57','',''),(2215346,'1','150','771',329,'Retail Sale Id 1303936',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:06:52','',''),(2215347,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:06:52','',''),(2215364,'1','150','771',329,'Retail Sale Id 1303946',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:07:57','',''),(2215365,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:07:57','',''),(2215380,'1','150','771',329,'Retail Sale Id 1303953',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:08:56','',''),(2215381,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:08:56','',''),(2215414,'1','150','771',329,'Retail Sale Id 1303974',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:11:17','',''),(2215415,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:11:17','',''),(2215442,'1','150','771',329,'Retail Sale Id 1303985',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:12:38','',''),(2215443,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:12:38','',''),(2215468,'1','150','771',329,'Retail Sale Id 1304000',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:14:49','',''),(2215469,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:14:49','',''),(2215545,'1','150','771',329,'Retail Sale Id 1304039',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:19:40','',''),(2215546,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:19:40','',''),(2215589,'1','150','771',329,'Retail Sale Id 1304060',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:21:51','',''),(2215590,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:21:51','',''),(2215597,'1','150','771',329,'Retail Sale Id 1304065',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:22:30','',''),(2215598,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:22:30','',''),(2215615,'1','150','771',329,'Retail Sale Id 1304075',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:23:07','',''),(2215616,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:23:07','',''),(2215646,'1','150','771',329,'Retail Sale Id 1304088',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 09:24:06','',''),(2215647,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 09:24:06','',''),(2215666,'1','150','771',329,'Retail Sale Id 1304100',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:25:14','',''),(2215667,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:25:14','',''),(2215694,'1','150','771',329,'Retail Sale Id 1304112',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:26:52','',''),(2215695,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:26:52','',''),(2215708,'1','150','771',329,'Retail Sale Id 1304119',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:27:49','',''),(2215709,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:27:49','',''),(2215726,'1','150','771',329,'Retail Sale Id 1304130',499.20,0.00,0.00,0.00,37.44,'2021-12-09 09:28:33','',''),(2215727,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-09 09:28:33','',''),(2215738,'1','150','771',329,'Retail Sale Id 1304136',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:29:27','',''),(2215739,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:29:27','',''),(2215750,'1','150','771',329,'Retail Sale Id 1304142',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:30:31','',''),(2215751,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:30:31','',''),(2215768,'1','150','771',329,'Retail Sale Id 1304154',902.40,0.00,0.00,0.00,67.68,'2021-12-09 09:31:42','',''),(2215769,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 09:31:42','',''),(2215790,'1','150','771',329,'Retail Sale Id 1304161',800.00,0.00,0.00,0.00,60.00,'2021-12-09 09:32:37','',''),(2215791,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 09:32:37','',''),(2215815,'1','150','771',329,'Retail Sale Id 1304175',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:33:39','',''),(2215816,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:33:39','',''),(2215855,'1','150','771',329,'Retail Sale Id 1304184',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:34:42','',''),(2215856,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:34:42','',''),(2215893,'1','150','771',329,'Retail Sale Id 1304202',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 09:36:10','',''),(2215894,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 09:36:10','',''),(2215911,'1','150','771',329,'Retail Sale Id 1304209',6080.00,0.00,0.00,0.00,456.00,'2021-12-09 09:37:11','',''),(2215912,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-09 09:37:11','',''),(2215986,'1','150','771',329,'Retail Sale Id 1304243',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:41:08','',''),(2215987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:41:08','',''),(2216018,'1','150','771',329,'Retail Sale Id 1304250',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 09:42:07','',''),(2216019,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 09:42:07','',''),(2216213,'1','150','771',329,'Retail Sale Id 1304328',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:52:12','',''),(2216214,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:52:12','',''),(2216233,'1','150','771',329,'Retail Sale Id 1304337',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:53:24','',''),(2216234,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:53:24','',''),(2216282,'1','150','771',329,'Retail Sale Id 1304351',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:54:56','',''),(2216283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:54:56','',''),(2216298,'1','150','771',329,'Retail Sale Id 1304366',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:55:32','',''),(2216299,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:55:32','',''),(2216314,'1','150','771',329,'Retail Sale Id 1304371',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:56:18','',''),(2216315,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:56:18','',''),(2216334,'1','150','771',329,'Retail Sale Id 1304380',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:57:08','',''),(2216335,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:57:08','',''),(2216492,'1','150','771',329,'Retail Sale Id 1304454',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 10:05:25','',''),(2216493,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:05:25','',''),(2216515,'1','150','771',329,'Retail Sale Id 1304463',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 10:06:22','',''),(2216516,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 10:06:22','',''),(2216531,'1','150','771',329,'Retail Sale Id 1304475',697.60,0.00,0.00,0.00,52.32,'2021-12-09 10:07:23','',''),(2216532,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 10:07:23','',''),(2217088,'1','150','771',329,'Retail Sale Id 1304771',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:45:03','',''),(2217089,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:45:03','',''),(2217132,'1','150','771',329,'Retail Sale Id 1304795',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:47:43','',''),(2217133,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:47:43','',''),(2217146,'1','150','771',329,'Retail Sale Id 1304800',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:48:39','',''),(2217147,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:48:39','',''),(2217170,'1','150','771',329,'Retail Sale Id 1304810',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:49:44','',''),(2217171,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:49:44','',''),(2217186,'1','150','771',329,'Retail Sale Id 1304822',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 10:50:54','',''),(2217187,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:50:54','',''),(2217220,'1','150','771',329,'Retail Sale Id 1304831',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 10:52:58','',''),(2217221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 10:52:58','',''),(2217234,'1','150','771',329,'Retail Sale Id 1304844',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 10:54:16','',''),(2217235,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 10:54:16','',''),(2217246,'1','150','771',329,'Retail Sale Id 1304851',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 10:55:27','',''),(2217247,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 10:55:27','',''),(2217264,'1','150','771',329,'Retail Sale Id 1304861',499.20,0.00,0.00,0.00,37.44,'2021-12-09 10:56:42','',''),(2217265,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-09 10:56:42','',''),(2217275,'1','150','771',329,'Retail Sale Id 1304864',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 10:57:44','',''),(2217276,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:57:44','',''),(2217295,'1','150','771',329,'Retail Sale Id 1304874',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:58:55','',''),(2217296,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:58:55','',''),(2217348,'1','150','771',329,'Retail Sale Id 1304901',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:02:01','',''),(2217349,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:02:01','',''),(2217364,'1','150','771',329,'Retail Sale Id 1304906',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:03:05','',''),(2217365,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:03:05','',''),(2217428,'1','150','771',329,'Retail Sale Id 1304944',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:07:15','',''),(2217429,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:07:15','',''),(2217915,'1','150','771',329,'Retail Sale Id 1305175',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 11:37:57','',''),(2217916,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 11:37:57','',''),(2217929,'1','150','771',329,'Retail Sale Id 1305180',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:38:47','',''),(2217930,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:38:47','',''),(2217951,'1','150','771',329,'Retail Sale Id 1305190',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 11:40:42','',''),(2217952,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 11:40:42','',''),(2217963,'1','150','771',329,'Retail Sale Id 1305196',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 11:41:41','',''),(2217964,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 11:41:41','',''),(2218014,'1','150','771',329,'Retail Sale Id 1305205',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 11:45:12','',''),(2218015,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 11:45:12','',''),(2218028,'1','150','771',329,'Retail Sale Id 1305226',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:45:47','',''),(2218029,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:45:47','',''),(2218056,'1','150','771',329,'Retail Sale Id 1305238',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:47:19','',''),(2218057,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:47:19','',''),(2218070,'1','150','771',329,'Retail Sale Id 1305243',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 11:47:52','',''),(2218071,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 11:47:52','',''),(2218076,'1','150','771',329,'Retail Sale Id 1305247',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:48:24','',''),(2218077,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:48:24','',''),(2218088,'1','150','771',329,'Retail Sale Id 1305254',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:48:57','',''),(2218089,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:48:57','',''),(2218098,'1','150','771',329,'Retail Sale Id 1305262',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:49:22','',''),(2218099,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:49:22','',''),(2218130,'1','150','771',329,'Retail Sale Id 1305279',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:51:16','',''),(2218131,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:51:16','',''),(2218210,'1','150','771',329,'Retail Sale Id 1305322',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 11:56:18','',''),(2218211,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 11:56:18','',''),(2218220,'1','150','771',329,'Retail Sale Id 1305327',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:57:11','',''),(2218221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:57:11','',''),(2218230,'1','150','771',329,'Retail Sale Id 1305334',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:58:12','',''),(2218231,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:58:12','',''),(2218246,'1','150','771',329,'Retail Sale Id 1305344',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:58:58','',''),(2218247,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:58:58','',''),(2218264,'1','150','771',329,'Retail Sale Id 1305351',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:00:07','',''),(2218265,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:00:07','',''),(2218272,'1','150','771',329,'Retail Sale Id 1305356',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 12:00:52','',''),(2218273,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 12:00:52','',''),(2218302,'1','150','771',329,'Retail Sale Id 1305372',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:02:28','',''),(2218303,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:02:28','',''),(2218391,'1','150','771',329,'Retail Sale Id 1305416',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:09:18','',''),(2218392,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:09:18','',''),(2218421,'1','150','771',329,'Retail Sale Id 1305434',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 12:11:40','',''),(2218422,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 12:11:40','',''),(2218457,'1','150','771',329,'Retail Sale Id 1305446',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:12:28','',''),(2218458,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:12:28','',''),(2218616,'1','150','771',329,'Retail Sale Id 1305527',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:23:32','',''),(2218617,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:23:32','',''),(2218628,'1','150','771',329,'Retail Sale Id 1305536',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:24:06','',''),(2218629,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:24:06','',''),(2218642,'1','150','771',329,'Retail Sale Id 1305549',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:24:45','',''),(2218643,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:24:45','',''),(2218646,'1','150','771',329,'Retail Sale Id 1305552',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 12:25:26','',''),(2218647,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 12:25:26','',''),(2218656,'1','150','771',329,'Retail Sale Id 1305556',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:26:07','',''),(2218657,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:26:07','',''),(2218668,'1','150','771',329,'Retail Sale Id 1305563',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:26:57','',''),(2218669,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:26:57','',''),(2218722,'1','150','771',329,'Retail Sale Id 1305591',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:29:53','',''),(2218723,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:29:53','',''),(2218756,'1','150','771',329,'Retail Sale Id 1305612',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:32:19','',''),(2218757,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:32:19','',''),(2218798,'1','150','771',329,'Retail Sale Id 1305631',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 12:35:05','',''),(2218799,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 12:35:05','',''),(2218892,'1','150','771',329,'Retail Sale Id 1305678',652.80,0.00,0.00,0.00,48.96,'2021-12-09 12:40:32','',''),(2218893,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 12:40:32','',''),(2218914,'1','150','771',329,'Retail Sale Id 1305687',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 12:41:17','',''),(2218915,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 12:41:17','',''),(2218986,'1','150','771',329,'Retail Sale Id 1305726',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:45:17','',''),(2218987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:45:17','',''),(2218993,'1','150','771',329,'Retail Sale Id 1305732',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:45:58','',''),(2218994,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:45:58','',''),(2219011,'1','150','771',329,'Retail Sale Id 1305741',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:46:47','',''),(2219012,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:46:47','',''),(2219031,'1','150','771',329,'Retail Sale Id 1305749',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 12:47:46','',''),(2219032,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 12:47:46','',''),(2219091,'1','150','771',329,'Retail Sale Id 1305774',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:50:17','',''),(2219092,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:50:17','',''),(2219158,'1','150','771',329,'Retail Sale Id 1305815',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 12:54:42','',''),(2219159,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 12:54:42','',''),(2219168,'1','150','771',329,'Retail Sale Id 1305819',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:55:26','',''),(2219169,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:55:26','',''),(2219192,'1','150','771',329,'Retail Sale Id 1305832',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:56:39','',''),(2219193,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:56:39','',''),(2219291,'1','150','771',329,'Retail Sale Id 1305869',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 13:01:42','',''),(2219292,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 13:01:42','',''),(2219351,'1','150','771',329,'Retail Sale Id 1305912',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:07:43','',''),(2219352,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:07:43','',''),(2219367,'1','150','771',329,'Retail Sale Id 1305924',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 13:08:38','',''),(2219368,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 13:08:38','',''),(2219385,'1','150','771',329,'Retail Sale Id 1305933',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:09:23','',''),(2219386,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:09:23','',''),(2219442,'1','150','771',329,'Retail Sale Id 1305952',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 13:11:56','',''),(2219443,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 13:11:56','',''),(2219510,'1','150','771',329,'Retail Sale Id 1305980',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:17:05','',''),(2219511,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:17:05','',''),(2219522,'1','150','771',329,'Retail Sale Id 1305985',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 13:17:49','',''),(2219523,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 13:17:49','',''),(2219532,'1','150','771',329,'Retail Sale Id 1305990',0.00,0.00,0.00,0.00,0.00,'2021-12-09 13:18:48','',''),(2219533,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-09 13:18:48','',''),(2219552,'1','150','771',329,'Retail Sale Id 1305999',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:20:23','',''),(2219553,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:20:23','',''),(2219591,'1','150','771',329,'Retail Sale Id 1306017',998.40,0.00,0.00,0.00,74.88,'2021-12-09 13:24:06','',''),(2219592,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 13:24:06','',''),(2219601,'1','150','771',329,'Retail Sale Id 1306023',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 13:24:58','',''),(2219602,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 13:24:58','',''),(2219613,'1','150','771',329,'Retail Sale Id 1306029',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:25:39','',''),(2219614,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:25:39','',''),(2219635,'1','150','771',329,'Retail Sale Id 1306036',998.40,0.00,0.00,0.00,74.88,'2021-12-09 13:26:43','',''),(2219636,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 13:26:43','',''),(2219646,'1','150','771',329,'Retail Sale Id 1306041',1702.40,0.00,0.00,0.00,127.68,'2021-12-09 13:27:21','',''),(2219647,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-09 13:27:21','',''),(2219672,'1','150','771',329,'Retail Sale Id 1306047',30080.00,0.00,0.00,0.00,2256.00,'2021-12-09 13:28:11','',''),(2219673,'1','150','771',329,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-09 13:28:11','',''),(2219690,'1','150','771',329,'Retail Sale Id 1306053',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 13:29:12','',''),(2219691,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:29:12','',''),(2219761,'1','150','771',329,'Retail Sale Id 1306079',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 13:31:52','',''),(2219762,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 13:31:52','',''),(2219928,'1','150','771',329,'Retail Sale Id 1306122',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:38:58','',''),(2219929,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:38:58','',''),(2219942,'1','150','771',329,'Retail Sale Id 1306127',499.20,0.00,0.00,0.00,37.44,'2021-12-09 13:40:17','',''),(2219943,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-09 13:40:17','',''),(2219964,'1','150','771',329,'Retail Sale Id 1306138',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:41:00','',''),(2219965,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:41:00','',''),(2219972,'1','150','771',329,'Retail Sale Id 1306142',998.40,0.00,0.00,0.00,74.88,'2021-12-09 13:41:33','',''),(2219973,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 13:41:33','',''),(2219980,'1','150','771',329,'Retail Sale Id 1306147',4499.20,0.00,0.00,0.00,337.44,'2021-12-09 13:42:12','',''),(2219981,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-09 13:42:12','',''),(2220034,'1','150','771',329,'Retail Sale Id 1306174',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 13:45:08','',''),(2220035,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:45:08','',''),(2220246,'1','150','771',329,'Retail Sale Id 1306280',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:00:00','',''),(2220247,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:00:00','',''),(2220278,'1','150','771',329,'Retail Sale Id 1306296',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 14:03:31','',''),(2220279,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 14:03:31','',''),(2220440,'1','150','771',329,'Retail Sale Id 1306361',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 14:12:28','',''),(2220441,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:12:28','',''),(2220460,'1','150','771',329,'Retail Sale Id 1306391',3500.80,0.00,0.00,0.00,262.56,'2021-12-09 14:14:07','',''),(2220461,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-09 14:14:07','',''),(2220530,'1','150','771',329,'Retail Sale Id 1306441',2899.20,0.00,0.00,0.00,217.44,'2021-12-09 14:17:51','',''),(2220531,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-09 14:17:51','',''),(2220542,'1','150','771',329,'Retail Sale Id 1306446',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:18:32','',''),(2220543,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:18:32','',''),(2220554,'1','150','771',329,'Retail Sale Id 1306452',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 14:19:13','',''),(2220555,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 14:19:13','',''),(2220582,'1','150','771',329,'Retail Sale Id 1306467',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 14:21:49','',''),(2220583,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 14:21:49','',''),(2220618,'1','150','771',329,'Retail Sale Id 1306484',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:22:31','',''),(2220619,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:22:31','',''),(2220622,'1','150','771',329,'Retail Sale Id 1306488',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:23:05','',''),(2220623,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:23:05','',''),(2220642,'1','150','771',329,'Retail Sale Id 1306498',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 14:23:56','',''),(2220643,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:23:56','',''),(2220663,'1','150','771',329,'Retail Sale Id 1306510',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 14:25:23','',''),(2220664,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 14:25:23','',''),(2221066,'1','150','771',329,'Retail Sale Id 1306693',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:42:28','',''),(2221067,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:42:28','',''),(2221086,'1','150','771',329,'Retail Sale Id 1306702',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:43:06','',''),(2221087,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:43:06','',''),(2221139,'1','150','771',329,'Retail Sale Id 1306723',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 14:45:17','',''),(2221140,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 14:45:17','',''),(2221182,'1','150','771',329,'Retail Sale Id 1306744',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:47:02','',''),(2221183,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:47:02','',''),(2221496,'1','150','771',329,'Retail Sale Id 1306855',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:00:25','',''),(2221497,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:00:25','',''),(2221512,'1','150','771',329,'Retail Sale Id 1306862',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:01:39','',''),(2221513,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:01:39','',''),(2221524,'1','150','771',329,'Retail Sale Id 1306870',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 15:02:36','',''),(2221525,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 15:02:36','',''),(2221570,'1','150','771',329,'Retail Sale Id 1306895',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 15:04:30','',''),(2221571,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 15:04:31','',''),(2221600,'1','150','771',329,'Retail Sale Id 1306909',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:06:10','',''),(2221601,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:06:10','',''),(2221648,'1','150','771',329,'Retail Sale Id 1306933',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:08:22','',''),(2221649,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:08:22','',''),(2222148,'1','150','771',329,'Retail Sale Id 1307192',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 15:32:48','',''),(2222149,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 15:32:48','',''),(2222160,'1','150','771',329,'Retail Sale Id 1307199',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:33:21','',''),(2222161,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:33:21','',''),(2222188,'1','150','771',329,'Retail Sale Id 1307214',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:35:08','',''),(2222189,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:35:08','',''),(2222200,'1','150','771',329,'Retail Sale Id 1307221',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:35:52','',''),(2222201,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:35:52','',''),(2222232,'1','150','771',329,'Retail Sale Id 1307236',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 15:37:21','',''),(2222233,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 15:37:21','',''),(2222296,'1','150','771',329,'Retail Sale Id 1307264',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 15:40:19','',''),(2222297,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 15:40:19','',''),(2222326,'1','150','771',329,'Retail Sale Id 1307281',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:42:09','',''),(2222327,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:42:09','',''),(2222344,'1','150','771',329,'Retail Sale Id 1307291',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 15:43:27','',''),(2222345,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 15:43:27','',''),(2222358,'1','150','771',329,'Retail Sale Id 1307298',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 15:44:13','',''),(2222359,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 15:44:13','',''),(2222374,'1','150','771',329,'Retail Sale Id 1307304',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:45:05','',''),(2222375,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:45:05','',''),(2222388,'1','150','771',329,'Retail Sale Id 1307312',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:45:57','',''),(2222389,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:45:57','',''),(2222409,'1','150','771',329,'Retail Sale Id 1307320',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:47:25','',''),(2222410,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:47:25','',''),(2222596,'1','150','771',329,'Retail Sale Id 1307412',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:57:12','',''),(2222597,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:57:12','',''),(2222707,'1','150','771',329,'Retail Sale Id 1307467',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 16:03:31','',''),(2222708,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 16:03:31','',''),(2222721,'1','150','771',329,'Retail Sale Id 1307475',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:04:10','',''),(2222722,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:04:10','',''),(2222837,'1','150','771',329,'Retail Sale Id 1307535',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 16:09:55','',''),(2222838,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 16:09:55','',''),(2222875,'1','150','771',329,'Retail Sale Id 1307554',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:11:55','',''),(2222876,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:11:55','',''),(2222925,'1','150','771',329,'Retail Sale Id 1307579',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:14:53','',''),(2222926,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:14:53','',''),(2223413,'1','150','771',329,'Retail Sale Id 1307799',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:41:01','',''),(2223414,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:41:01','',''),(2223560,'1','150','771',329,'Retail Sale Id 1307853',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:47:52','',''),(2223561,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:47:52','',''),(2223572,'1','150','771',329,'Retail Sale Id 1307859',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:48:23','',''),(2223573,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:48:23','',''),(2224302,'1','150','771',329,'Retail Sale Id 1307871',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 18:04:22','',''),(2224303,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 18:04:22','',''),(2224447,'1','150','771',329,'Retail Sale Id 1308277',494912.00,0.00,0.00,0.00,37118.40,'2021-12-09 18:33:06','',''),(2224448,'1','150','771',329,'Retail sales',0.00,0.00,0.00,773.30,0.00,'2021-12-09 18:33:06','',''),(2224472,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,3593440.00,6070.00,0.00,0.00,'2021-12-09 18:39:39','',''),(2225055,'1','150','771',329,'Retail Sale Id 1308347',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 05:59:42','',''),(2225056,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 05:59:42','',''),(2225063,'1','150','771',329,'Retail Sale Id 1308350',3950.00,0.00,0.00,0.00,3950.00,'2021-12-10 06:00:15','',''),(2225064,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 06:00:15','',''),(2225132,'1','150','771',329,'Retail Sale Id 1308376',1301.92,0.00,0.00,0.00,1301.92,'2021-12-10 06:08:40','',''),(2225133,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 06:08:40','',''),(2225142,'1','150','771',329,'Retail Sale Id 1308381',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 06:09:30','',''),(2225143,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 06:09:30','',''),(2225148,'1','150','771',329,'Retail Sale Id 1308383',701.52,0.00,0.00,0.00,701.52,'2021-12-10 06:10:12','',''),(2225149,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 06:10:12','',''),(2225189,'1','150','771',329,'Retail Sale Id 1308385',1700.08,0.00,0.00,0.00,1700.08,'2021-12-10 06:16:33','',''),(2225190,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-10 06:16:33','',''),(2225574,'1','150','771',329,'Retail Sale Id 1308579',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 06:47:43','',''),(2225575,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 06:47:43','',''),(2225608,'1','150','771',329,'Retail Sale Id 1308597',6351.60,0.00,0.00,0.00,6351.60,'2021-12-10 06:49:28','',''),(2225609,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-10 06:49:28','',''),(2225630,'1','150','771',329,'Retail Sale Id 1308608',5997.68,0.00,0.00,0.00,5997.68,'2021-12-10 06:50:39','',''),(2225631,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-10 06:50:39','',''),(2225644,'1','150','771',329,'Retail Sale Id 1308615',650.96,0.00,0.00,0.00,650.96,'2021-12-10 06:51:39','',''),(2225645,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 06:51:39','',''),(2230186,'1','150','771',329,'Retail Sale Id 1310713',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 10:53:33','',''),(2230187,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 10:53:33','',''),(2230254,'1','150','771',329,'Retail Sale Id 1310755',5100.24,0.00,0.00,0.00,5100.24,'2021-12-10 10:58:47','',''),(2230255,'1','150','771',329,'Retail sales',0.00,0.00,0.00,8.07,0.00,'2021-12-10 10:58:47','',''),(2230275,'1','150','771',329,'Retail Sale Id 1310761',998.56,0.00,0.00,0.00,998.56,'2021-12-10 10:59:32','',''),(2230276,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 10:59:32','',''),(2230287,'1','150','771',329,'Retail Sale Id 1310767',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 11:00:04','',''),(2230288,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 11:00:04','',''),(2230302,'1','150','771',329,'Retail Sale Id 1310774',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 11:01:13','',''),(2230303,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 11:01:13','',''),(2230326,'1','150','771',329,'Retail Sale Id 1310788',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 11:02:35','',''),(2230327,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 11:02:35','',''),(2230346,'1','150','771',329,'Retail Sale Id 1310799',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 11:03:30','',''),(2230347,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 11:03:30','',''),(2230354,'1','150','771',329,'Retail Sale Id 1310803',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 11:04:06','',''),(2230355,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 11:04:06','',''),(2230396,'1','150','771',329,'Retail Sale Id 1310814',0.00,0.00,0.00,0.00,0.00,'2021-12-10 11:05:33','',''),(2230397,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-10 11:05:33','',''),(2230542,'1','150','771',329,'Retail Sale Id 1310872',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 11:14:49','',''),(2230543,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 11:14:49','',''),(2230556,'1','150','771',329,'Retail Sale Id 1310881',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 11:15:39','',''),(2230557,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 11:15:39','',''),(2230570,'1','150','771',329,'Retail Sale Id 1310891',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 11:16:57','',''),(2230571,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 11:16:57','',''),(2230588,'1','150','771',329,'Retail Sale Id 1310901',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 11:17:38','',''),(2230589,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 11:17:38','',''),(2230647,'1','150','771',329,'Retail Sale Id 1310917',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 11:20:26','',''),(2230648,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:20:26','',''),(2230684,'1','150','771',329,'Retail Sale Id 1310922',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 11:21:10','',''),(2230685,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 11:21:10','',''),(2230771,'1','150','771',329,'Retail Sale Id 1310962',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 11:27:56','',''),(2230772,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:27:56','',''),(2230777,'1','150','771',329,'Retail Sale Id 1310964',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 11:28:55','',''),(2230778,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 11:28:55','',''),(2230830,'1','150','771',329,'Retail Sale Id 1310997',3501.28,0.00,0.00,0.00,3501.28,'2021-12-10 11:32:45','',''),(2230831,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 11:32:45','',''),(2230865,'1','150','771',329,'Retail Sale Id 1311016',4499.84,0.00,0.00,0.00,4499.84,'2021-12-10 11:34:56','',''),(2230866,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-10 11:34:56','',''),(2231421,'1','150','771',329,'Retail Sale Id 1311299',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 12:16:07','',''),(2231422,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:16:07','',''),(2231453,'1','150','771',329,'Retail Sale Id 1311317',12652.64,0.00,0.00,0.00,12652.64,'2021-12-10 12:18:51','',''),(2231454,'1','150','771',329,'Retail sales',0.00,0.00,0.00,20.02,0.00,'2021-12-10 12:18:51','',''),(2231469,'1','150','771',329,'Retail Sale Id 1311324',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 12:19:59','',''),(2231470,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 12:19:59','',''),(2231523,'1','150','771',329,'Retail Sale Id 1311352',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 12:24:38','',''),(2231524,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 12:24:38','',''),(2231529,'1','150','771',329,'Retail Sale Id 1311357',998.56,0.00,0.00,0.00,998.56,'2021-12-10 12:25:19','',''),(2231530,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 12:25:19','',''),(2231582,'1','150','771',329,'Retail Sale Id 1311383',998.56,0.00,0.00,0.00,998.56,'2021-12-10 12:29:02','',''),(2231583,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 12:29:02','',''),(2231596,'1','150','771',329,'Retail Sale Id 1311392',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 12:32:03','',''),(2231597,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 12:32:03','',''),(2231624,'1','150','771',329,'Retail Sale Id 1311409',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 12:36:05','',''),(2231625,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:36:05','',''),(2231783,'1','150','771',329,'Retail Sale Id 1311495',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 12:49:17','',''),(2231784,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 12:49:17','',''),(2231916,'1','150','771',329,'Retail Sale Id 1311559',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 12:57:47','',''),(2231917,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 12:57:47','',''),(2231932,'1','150','771',329,'Retail Sale Id 1311569',2502.72,0.00,0.00,0.00,2502.72,'2021-12-10 12:58:38','',''),(2231933,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 12:58:38','',''),(2231958,'1','150','771',329,'Retail Sale Id 1311582',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 13:00:12','',''),(2231959,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 13:00:12','',''),(2231992,'1','150','771',329,'Retail Sale Id 1311599',5700.64,0.00,0.00,0.00,5700.64,'2021-12-10 13:03:09','',''),(2231993,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.02,0.00,'2021-12-10 13:03:09','',''),(2232006,'1','150','771',329,'Retail Sale Id 1311607',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 13:04:19','',''),(2232007,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 13:04:20','',''),(2232022,'1','150','771',329,'Retail Sale Id 1311614',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 13:05:23','',''),(2232023,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 13:05:23','',''),(2232030,'1','150','771',329,'Retail Sale Id 1311620',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:06:10','',''),(2232031,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:06:10','',''),(2232139,'1','150','771',329,'Retail Sale Id 1311663',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:11:47','',''),(2232140,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:11:47','',''),(2232185,'1','150','771',329,'Retail Sale Id 1311683',7501.84,0.00,0.00,0.00,7501.84,'2021-12-10 13:14:38','',''),(2232186,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.87,0.00,'2021-12-10 13:14:38','',''),(2232284,'1','150','771',329,'Retail Sale Id 1311723',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:19:36','',''),(2232285,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:19:36','',''),(2232407,'1','150','771',329,'Retail Sale Id 1311785',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 13:29:01','',''),(2232408,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 13:29:01','',''),(2232437,'1','150','771',329,'Retail Sale Id 1311807',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 13:30:52','',''),(2232438,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 13:30:52','',''),(2232475,'1','150','771',329,'Retail Sale Id 1311825',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:33:04','',''),(2232476,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:33:04','',''),(2232484,'1','150','771',329,'Retail Sale Id 1311830',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 13:33:46','',''),(2232485,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 13:33:46','',''),(2232556,'1','150','771',329,'Retail Sale Id 1311868',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 13:37:02','',''),(2232557,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:37:02','',''),(2232634,'1','150','771',329,'Retail Sale Id 1311893',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:40:11','',''),(2232635,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:40:11','',''),(2232648,'1','150','771',329,'Retail Sale Id 1311901',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 13:41:08','',''),(2232649,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 13:41:08','',''),(2232673,'1','150','771',329,'Retail Sale Id 1311911',4999.12,0.00,0.00,0.00,4999.12,'2021-12-10 13:41:48','',''),(2232674,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 13:41:48','',''),(2232689,'1','150','771',329,'Retail Sale Id 1311917',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 13:42:44','',''),(2232690,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:42:44','',''),(2232731,'1','150','771',329,'Retail Sale Id 1311933',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 13:44:30','',''),(2232732,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 13:44:30','',''),(2232773,'1','150','771',329,'Retail Sale Id 1311952',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 13:46:44','',''),(2232774,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:46:44','',''),(2232945,'1','150','771',329,'Retail Sale Id 1312028',2502.72,0.00,0.00,0.00,2502.72,'2021-12-10 13:55:08','',''),(2232946,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 13:55:08','',''),(2232975,'1','150','771',329,'Retail Sale Id 1312041',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 13:56:39','',''),(2232976,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 13:56:39','',''),(2232995,'1','150','771',329,'Retail Sale Id 1312053',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 13:57:30','',''),(2232996,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:57:30','',''),(2233019,'1','150','771',329,'Retail Sale Id 1312061',600.40,0.00,0.00,0.00,600.40,'2021-12-10 13:58:32','',''),(2233020,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.95,0.00,'2021-12-10 13:58:32','',''),(2233039,'1','150','771',329,'Retail Sale Id 1312072',1700.08,0.00,0.00,0.00,1700.08,'2021-12-10 13:59:20','',''),(2233040,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-10 13:59:20','',''),(2233071,'1','150','771',329,'Retail Sale Id 1312079',6351.60,0.00,0.00,0.00,6351.60,'2021-12-10 14:00:35','',''),(2233072,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-10 14:00:35','',''),(2233118,'1','150','771',329,'Retail Sale Id 1312089',998.56,0.00,0.00,0.00,998.56,'2021-12-10 14:01:35','',''),(2233119,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:01:35','',''),(2233225,'1','150','771',329,'Retail Sale Id 1312132',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:06:41','',''),(2233226,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:06:41','',''),(2233238,'1','150','771',329,'Retail Sale Id 1312138',998.56,0.00,0.00,0.00,998.56,'2021-12-10 14:07:35','',''),(2233239,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:07:35','',''),(2233257,'1','150','771',329,'Retail Sale Id 1312143',7002.56,0.00,0.00,0.00,7002.56,'2021-12-10 14:08:27','',''),(2233258,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 14:08:27','',''),(2233285,'1','150','771',329,'Retail Sale Id 1312158',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:11:23','',''),(2233286,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:11:23','',''),(2233295,'1','150','771',329,'Retail Sale Id 1312163',1301.92,0.00,0.00,0.00,1301.92,'2021-12-10 14:12:05','',''),(2233296,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 14:12:05','',''),(2233309,'1','150','771',329,'Retail Sale Id 1312170',47400.00,0.00,0.00,0.00,47400.00,'2021-12-10 14:13:00','',''),(2233310,'1','150','771',329,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-10 14:13:00','',''),(2233329,'1','150','771',329,'Retail Sale Id 1312183',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 14:13:42','',''),(2233330,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 14:13:42','',''),(2233343,'1','150','771',329,'Retail Sale Id 1312190',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:14:32','',''),(2233344,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:14:32','',''),(2233359,'1','150','771',329,'Retail Sale Id 1312198',998.56,0.00,0.00,0.00,998.56,'2021-12-10 14:15:05','',''),(2233360,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:15:05','',''),(2233367,'1','150','771',329,'Retail Sale Id 1312204',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 14:16:06','',''),(2233368,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:16:06','',''),(2233387,'1','150','771',329,'Retail Sale Id 1312214',4000.56,0.00,0.00,0.00,4000.56,'2021-12-10 14:16:54','',''),(2233388,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 14:16:54','',''),(2233421,'1','150','771',329,'Retail Sale Id 1312225',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 14:18:01','',''),(2233422,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:18:01','',''),(2233447,'1','150','771',329,'Retail Sale Id 1312239',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:20:01','',''),(2233448,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:20:01','',''),(2233463,'1','150','771',329,'Retail Sale Id 1312248',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 14:20:39','',''),(2233464,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:20:39','',''),(2233565,'1','150','771',329,'Retail Sale Id 1312283',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 14:24:31','',''),(2233566,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:24:31','',''),(2233613,'1','150','771',329,'Retail Sale Id 1312294',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 14:26:02','',''),(2233614,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:26:02','',''),(2233630,'1','150','771',329,'Retail Sale Id 1312304',998.56,0.00,0.00,0.00,998.56,'2021-12-10 14:27:05','',''),(2233631,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:27:05','',''),(2233644,'1','150','771',329,'Retail Sale Id 1312312',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 14:27:47','',''),(2233645,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:27:47','',''),(2233697,'1','150','771',329,'Retail Sale Id 1312338',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 14:29:43','',''),(2233698,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 14:29:43','',''),(2233805,'1','150','771',329,'Retail Sale Id 1312395',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:34:43','',''),(2233806,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:34:43','',''),(2233843,'1','150','771',329,'Retail Sale Id 1312405',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 14:36:09','',''),(2233844,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:36:09','',''),(2233868,'1','150','771',329,'Retail Sale Id 1312415',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 14:37:16','',''),(2233869,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 14:37:16','',''),(2233894,'1','150','771',329,'Retail Sale Id 1312426',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 14:38:24','',''),(2233895,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 14:38:24','',''),(2233925,'1','150','771',329,'Retail Sale Id 1312437',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 14:39:38','',''),(2233926,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:39:38','',''),(2233974,'1','150','771',329,'Retail Sale Id 1312459',701.52,0.00,0.00,0.00,701.52,'2021-12-10 14:41:41','',''),(2233975,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 14:41:41','',''),(2234001,'1','150','771',329,'Retail Sale Id 1312467',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 14:42:21','',''),(2234002,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 14:42:21','',''),(2234013,'1','150','771',329,'Retail Sale Id 1312472',3501.28,0.00,0.00,0.00,3501.28,'2021-12-10 14:42:57','',''),(2234014,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 14:42:57','',''),(2234037,'1','150','771',329,'Retail Sale Id 1312484',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 14:43:57','',''),(2234038,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:43:57','',''),(2234059,'1','150','771',329,'Retail Sale Id 1312500',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 14:44:59','',''),(2234060,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:44:59','',''),(2234081,'1','150','771',329,'Retail Sale Id 1312507',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 14:45:39','',''),(2234082,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:45:39','',''),(2234143,'1','150','771',329,'Retail Sale Id 1312530',2502.72,0.00,0.00,0.00,2502.72,'2021-12-10 14:47:50','',''),(2234144,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 14:47:50','',''),(2234183,'1','150','771',329,'Retail Sale Id 1312552',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 14:49:07','',''),(2234184,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:49:07','',''),(2234428,'1','150','771',329,'Retail Sale Id 1312672',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 15:02:58','',''),(2234429,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:02:58','',''),(2234444,'1','150','771',329,'Retail Sale Id 1312679',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 15:03:44','',''),(2234445,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:03:44','',''),(2234470,'1','150','771',329,'Retail Sale Id 1312695',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 15:05:35','',''),(2234471,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:05:35','',''),(2234532,'1','150','771',329,'Retail Sale Id 1312721',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:08:06','',''),(2234533,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:08:06','',''),(2234546,'1','150','771',329,'Retail Sale Id 1312729',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:09:10','',''),(2234547,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:09:10','',''),(2234571,'1','150','771',329,'Retail Sale Id 1312739',1801.20,0.00,0.00,0.00,1801.20,'2021-12-10 15:09:59','',''),(2234572,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-10 15:09:59','',''),(2234581,'1','150','771',329,'Retail Sale Id 1312746',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:10:41','',''),(2234582,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:10:41','',''),(2234625,'1','150','771',329,'Retail Sale Id 1312762',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:12:21','',''),(2234626,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:12:21','',''),(2234643,'1','150','771',329,'Retail Sale Id 1312769',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:13:08','',''),(2234644,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:13:08','',''),(2234665,'1','150','771',329,'Retail Sale Id 1312783',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:13:53','',''),(2234666,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:13:53','',''),(2234691,'1','150','771',329,'Retail Sale Id 1312791',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:14:48','',''),(2234692,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:14:48','',''),(2234729,'1','150','771',329,'Retail Sale Id 1312817',998.56,0.00,0.00,0.00,998.56,'2021-12-10 15:16:38','',''),(2234730,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:16:38','',''),(2234747,'1','150','771',329,'Retail Sale Id 1312827',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:17:39','',''),(2234748,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:17:39','',''),(2234765,'1','150','771',329,'Retail Sale Id 1312838',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 15:18:29','',''),(2234766,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 15:18:29','',''),(2234795,'1','150','771',329,'Retail Sale Id 1312852',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 15:19:29','',''),(2234796,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:19:29','',''),(2234811,'1','150','771',329,'Retail Sale Id 1312859',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 15:20:11','',''),(2234812,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:20:11','',''),(2234841,'1','150','771',329,'Retail Sale Id 1312877',3798.32,0.00,0.00,0.00,3798.32,'2021-12-10 15:21:29','',''),(2234842,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:21:29','',''),(2234886,'1','150','771',329,'Retail Sale Id 1312903',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:22:57','',''),(2234887,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:22:57','',''),(2234920,'1','150','771',329,'Retail Sale Id 1312924',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 15:24:21','',''),(2234921,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:24:21','',''),(2235022,'1','150','771',329,'Retail Sale Id 1312965',998.56,0.00,0.00,0.00,998.56,'2021-12-10 15:27:20','',''),(2235023,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:27:20','',''),(2235060,'1','150','771',329,'Retail Sale Id 1312977',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:28:20','',''),(2235061,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:28:20','',''),(2235089,'1','150','771',329,'Retail Sale Id 1312985',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 15:29:18','',''),(2235090,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:29:18','',''),(2235111,'1','150','771',329,'Retail Sale Id 1312996',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 15:30:12','',''),(2235112,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:30:12','',''),(2235119,'1','150','771',329,'Retail Sale Id 1312999',998.56,0.00,0.00,0.00,998.56,'2021-12-10 15:30:44','',''),(2235120,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:30:44','',''),(2235135,'1','150','771',329,'Retail Sale Id 1313009',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:31:36','',''),(2235136,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:31:36','',''),(2235145,'1','150','771',329,'Retail Sale Id 1313016',998.56,0.00,0.00,0.00,998.56,'2021-12-10 15:32:15','',''),(2235146,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:32:15','',''),(2235167,'1','150','771',329,'Retail Sale Id 1313025',701.52,0.00,0.00,0.00,701.52,'2021-12-10 15:32:59','',''),(2235168,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 15:32:59','',''),(2235183,'1','150','771',329,'Retail Sale Id 1313033',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:33:42','',''),(2235184,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:33:42','',''),(2235213,'1','150','771',329,'Retail Sale Id 1313046',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:35:04','',''),(2235214,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:35:04','',''),(2235225,'1','150','771',329,'Retail Sale Id 1313051',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:35:49','',''),(2235226,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:35:49','',''),(2235247,'1','150','771',329,'Retail Sale Id 1313063',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:36:41','',''),(2235248,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:36:41','',''),(2235283,'1','150','771',329,'Retail Sale Id 1313078',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 15:37:43','',''),(2235284,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 15:37:43','',''),(2235291,'1','150','771',329,'Retail Sale Id 1313083',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 15:38:29','',''),(2235292,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:38:29','',''),(2235303,'1','150','771',329,'Retail Sale Id 1313090',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:39:10','',''),(2235304,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:39:10','',''),(2235319,'1','150','771',329,'Retail Sale Id 1313096',998.56,0.00,0.00,0.00,998.56,'2021-12-10 15:39:48','',''),(2235320,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:39:48','',''),(2235353,'1','150','771',329,'Retail Sale Id 1313107',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:40:56','',''),(2235354,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:40:56','',''),(2235369,'1','150','771',329,'Retail Sale Id 1313116',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:41:44','',''),(2235370,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:41:44','',''),(2235405,'1','150','771',329,'Retail Sale Id 1313132',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:42:55','',''),(2235406,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:42:55','',''),(2235447,'1','150','771',329,'Retail Sale Id 1313159',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 15:44:45','',''),(2235448,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 15:44:45','',''),(2235467,'1','150','771',329,'Retail Sale Id 1313174',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:45:49','',''),(2235468,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:45:49','',''),(2235479,'1','150','771',329,'Retail Sale Id 1313185',4999.12,0.00,0.00,0.00,4999.12,'2021-12-10 15:46:32','',''),(2235480,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 15:46:32','',''),(2235501,'1','150','771',329,'Retail Sale Id 1313195',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:47:37','',''),(2235502,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:47:37','',''),(2235520,'1','150','771',329,'Retail Sale Id 1313206',1301.92,0.00,0.00,0.00,1301.92,'2021-12-10 15:48:41','',''),(2235521,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:48:41','',''),(2235540,'1','150','771',329,'Retail Sale Id 1313220',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 15:49:46','',''),(2235541,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:49:46','',''),(2235556,'1','150','771',329,'Retail Sale Id 1313236',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:50:49','',''),(2235557,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:50:49','',''),(2235578,'1','150','771',329,'Retail Sale Id 1313242',897.44,0.00,0.00,0.00,897.44,'2021-12-10 15:51:55','',''),(2235579,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-10 15:51:55','',''),(2235599,'1','150','771',329,'Retail Sale Id 1313257',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 15:52:57','',''),(2235600,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 15:52:57','',''),(2235628,'1','150','771',329,'Retail Sale Id 1313271',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 15:54:19','',''),(2235629,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:54:19','',''),(2235642,'1','150','771',329,'Retail Sale Id 1313279',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 15:55:10','',''),(2235643,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:55:10','',''),(2235672,'1','150','771',329,'Retail Sale Id 1313286',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 15:55:58','',''),(2235673,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:55:58','',''),(2235729,'1','150','771',329,'Retail Sale Id 1313319',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 15:58:54','',''),(2235730,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 15:58:54','',''),(2235767,'1','150','771',329,'Retail Sale Id 1313336',1497.84,0.00,0.00,0.00,1497.84,'2021-12-10 16:00:08','',''),(2235768,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 16:00:08','',''),(2235820,'1','150','771',329,'Retail Sale Id 1313367',3798.32,0.00,0.00,0.00,3798.32,'2021-12-10 16:03:05','',''),(2235821,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:03:05','',''),(2235851,'1','150','771',329,'Retail Sale Id 1313383',4999.12,0.00,0.00,0.00,4999.12,'2021-12-10 16:04:44','',''),(2235852,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 16:04:44','',''),(2235902,'1','150','771',329,'Retail Sale Id 1313397',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:06:38','',''),(2235903,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:06:38','',''),(2235924,'1','150','771',329,'Retail Sale Id 1313405',1301.92,0.00,0.00,0.00,1301.92,'2021-12-10 16:07:28','',''),(2235925,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 16:07:28','',''),(2235940,'1','150','771',329,'Retail Sale Id 1313410',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 16:08:06','',''),(2235941,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:08:06','',''),(2235981,'1','150','771',329,'Retail Sale Id 1313431',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:09:52','',''),(2235982,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:09:52','',''),(2236087,'1','150','771',329,'Retail Sale Id 1313490',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 16:14:46','',''),(2236088,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:14:46','',''),(2236097,'1','150','771',329,'Retail Sale Id 1313497',897.44,0.00,0.00,0.00,897.44,'2021-12-10 16:15:27','',''),(2236098,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-10 16:15:27','',''),(2236120,'1','150','771',329,'Retail Sale Id 1313508',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:16:23','',''),(2236121,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:16:23','',''),(2236142,'1','150','771',329,'Retail Sale Id 1313519',2098.24,0.00,0.00,0.00,2098.24,'2021-12-10 16:17:44','',''),(2236143,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.32,0.00,'2021-12-10 16:17:44','',''),(2236158,'1','150','771',329,'Retail Sale Id 1313534',1301.92,0.00,0.00,0.00,1301.92,'2021-12-10 16:18:40','',''),(2236159,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 16:18:40','',''),(2236182,'1','150','771',329,'Retail Sale Id 1313542',2546.96,0.00,0.00,0.00,2546.96,'2021-12-10 16:19:31','',''),(2236183,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 16:19:31','',''),(2236207,'1','150','771',329,'Retail Sale Id 1313559',998.56,0.00,0.00,0.00,998.56,'2021-12-10 16:20:24','',''),(2236208,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 16:20:24','',''),(2236227,'1','150','771',329,'Retail Sale Id 1313569',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:21:08','',''),(2236228,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:21:08','',''),(2236256,'1','150','771',329,'Retail Sale Id 1313586',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 16:22:19','',''),(2236257,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 16:22:19','',''),(2236294,'1','150','771',329,'Retail Sale Id 1313607',998.56,0.00,0.00,0.00,998.56,'2021-12-10 16:24:00','',''),(2236295,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 16:24:00','',''),(2236355,'1','150','771',329,'Retail Sale Id 1313639',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 16:26:35','',''),(2236356,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:26:35','',''),(2236403,'1','150','771',329,'Retail Sale Id 1313658',7900.00,0.00,0.00,0.00,7900.00,'2021-12-10 16:28:59','',''),(2236404,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:28:59','',''),(2236437,'1','150','771',329,'Retail Sale Id 1313671',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:30:19','',''),(2236438,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:30:19','',''),(2236457,'1','150','771',329,'Retail Sale Id 1313685',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 16:31:23','',''),(2236458,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 16:31:23','',''),(2236477,'1','150','771',329,'Retail Sale Id 1313691',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 16:32:04','',''),(2236478,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:32:04','',''),(2236499,'1','150','771',329,'Retail Sale Id 1313706',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 16:33:14','',''),(2236500,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 16:33:14','',''),(2236525,'1','150','771',329,'Retail Sale Id 1313714',3501.28,0.00,0.00,0.00,3501.28,'2021-12-10 16:34:29','',''),(2236526,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 16:34:29','',''),(2236561,'1','150','771',329,'Retail Sale Id 1313728',5997.68,0.00,0.00,0.00,5997.68,'2021-12-10 16:36:21','',''),(2236562,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-10 16:36:21','',''),(2236573,'1','150','771',329,'Retail Sale Id 1313734',998.56,0.00,0.00,0.00,998.56,'2021-12-10 16:37:05','',''),(2236574,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 16:37:05','',''),(2236690,'1','150','771',329,'Retail Sale Id 1313779',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 16:42:32','',''),(2236691,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:42:32','',''),(2236704,'1','150','771',329,'Retail Sale Id 1313785',2502.72,0.00,0.00,0.00,2502.72,'2021-12-10 16:43:19','',''),(2236705,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 16:43:19','',''),(2236712,'1','150','771',329,'Retail Sale Id 1313794',3197.92,0.00,0.00,0.00,3197.92,'2021-12-10 16:43:46','',''),(2236713,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 16:43:46','',''),(2236720,'1','150','771',329,'Retail Sale Id 1313798',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 16:44:29','',''),(2236721,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:44:29','',''),(2236744,'1','150','771',329,'Retail Sale Id 1313811',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 16:45:55','',''),(2236745,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:45:55','',''),(2236756,'1','150','771',329,'Retail Sale Id 1313819',998.56,0.00,0.00,0.00,998.56,'2021-12-10 16:46:36','',''),(2236757,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 16:46:36','',''),(2236810,'1','150','771',329,'Retail Sale Id 1313845',998.56,0.00,0.00,0.00,998.56,'2021-12-10 16:50:07','',''),(2236811,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 16:50:07','',''),(2236828,'1','150','771',329,'Retail Sale Id 1313853',3899.44,0.00,0.00,0.00,3899.44,'2021-12-10 16:51:17','',''),(2236829,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 16:51:17','',''),(2236850,'1','150','771',329,'Retail Sale Id 1313867',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 16:52:43','',''),(2236851,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:52:43','',''),(2236921,'1','150','771',329,'Retail Sale Id 1313897',0.00,0.00,0.00,0.00,0.00,'2021-12-10 16:56:28','',''),(2236922,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-10 16:56:28','',''),(2236984,'1','150','771',329,'Retail Sale Id 1313937',3002.00,0.00,0.00,0.00,3002.00,'2021-12-10 17:00:28','',''),(2236985,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 17:00:28','',''),(2237002,'1','150','771',329,'Retail Sale Id 1313943',1997.12,0.00,0.00,0.00,1997.12,'2021-12-10 17:01:25','',''),(2237003,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 17:01:25','',''),(2237028,'1','150','771',329,'Retail Sale Id 1313956',4999.12,0.00,0.00,0.00,4999.12,'2021-12-10 17:02:50','',''),(2237029,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 17:02:50','',''),(2237039,'1','150','771',329,'Retail Sale Id 1313960',5997.68,0.00,0.00,0.00,5997.68,'2021-12-10 17:03:21','',''),(2237040,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-10 17:03:21','',''),(2237180,'1','150','771',329,'Retail Sale Id 1314027',998.56,0.00,0.00,0.00,998.56,'2021-12-10 17:15:24','',''),(2237181,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 17:15:24','',''),(2237518,'1','150','771',329,'Retail Sale Id 1314159',1902.32,0.00,0.00,0.00,1902.32,'2021-12-10 17:46:20','',''),(2237519,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 17:46:20','',''),(2237825,'1','150','771',329,'Retail Sale Id 1314337',235988.80,0.00,0.00,0.00,235988.80,'2021-12-10 18:49:09','',''),(2237826,'1','150','771',329,'Retail sales',0.00,0.00,0.00,373.40,0.00,'2021-12-10 18:49:09','',''),(2238329,'1','150','771',329,'Retail Sale Id 1314405',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 05:26:36','',''),(2238330,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 05:26:36','',''),(2238331,'1','150','771',329,'Retail Sale Id 1314407',998.56,0.00,0.00,0.00,998.56,'2021-12-11 05:33:34','',''),(2238332,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 05:33:34','',''),(2238369,'1','150','771',329,'Retail Sale Id 1314412',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 05:44:20','',''),(2238370,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 05:44:20','',''),(2238375,'1','150','771',329,'Retail Sale Id 1314415',998.56,0.00,0.00,0.00,998.56,'2021-12-11 05:46:56','',''),(2238376,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 05:46:56','',''),(2238390,'1','150','771',329,'Retail Sale Id 1314418',499.28,0.00,0.00,0.00,499.28,'2021-12-11 05:53:31','',''),(2238391,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-11 05:53:31','',''),(2238411,'1','150','771',329,'Retail Sale Id 1314428',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 05:59:33','',''),(2238412,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 05:59:33','',''),(2238434,'1','150','771',329,'Retail Sale Id 1314438',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:03:42','',''),(2238435,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:03:42','',''),(2238442,'1','150','771',329,'Retail Sale Id 1314442',701.52,0.00,0.00,0.00,701.52,'2021-12-11 06:05:25','',''),(2238443,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-11 06:05:25','',''),(2238492,'1','150','771',329,'Retail Sale Id 1314449',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:08:14','',''),(2238493,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:08:14','',''),(2238506,'1','150','771',329,'Retail Sale Id 1314453',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 06:09:06','',''),(2238507,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 06:09:06','',''),(2238520,'1','150','771',329,'Retail Sale Id 1314454',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:09:49','',''),(2238521,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:09:49','',''),(2238546,'1','150','771',329,'Retail Sale Id 1314464',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 06:11:20','',''),(2238547,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 06:11:20','',''),(2238558,'1','150','771',329,'Retail Sale Id 1314470',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 06:12:18','',''),(2238559,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 06:12:18','',''),(2238570,'1','150','771',329,'Retail Sale Id 1314478',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 06:14:53','',''),(2238571,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 06:14:53','',''),(2238629,'1','150','771',329,'Retail Sale Id 1314501',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 06:20:28','',''),(2238630,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 06:20:28','',''),(2238678,'1','150','771',329,'Retail Sale Id 1314524',948.00,0.00,0.00,0.00,948.00,'2021-12-11 06:24:18','',''),(2238679,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-11 06:24:18','',''),(2238684,'1','150','771',329,'Retail Sale Id 1314528',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 06:24:54','',''),(2238685,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 06:24:54','',''),(2238703,'1','150','771',329,'Retail Sale Id 1314537',998.56,0.00,0.00,0.00,998.56,'2021-12-11 06:25:50','',''),(2238704,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 06:25:50','',''),(2238725,'1','150','771',329,'Retail Sale Id 1314551',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:27:42','',''),(2238726,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:27:42','',''),(2238749,'1','150','771',329,'Retail Sale Id 1314564',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 06:28:57','',''),(2238750,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 06:28:57','',''),(2238766,'1','150','771',329,'Retail Sale Id 1314570',998.56,0.00,0.00,0.00,998.56,'2021-12-11 06:30:51','',''),(2238767,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 06:30:51','',''),(2238802,'1','150','771',329,'Retail Sale Id 1314585',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 06:33:18','',''),(2238803,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 06:33:18','',''),(2238846,'1','150','771',329,'Retail Sale Id 1314594',1200.80,0.00,0.00,0.00,1200.80,'2021-12-11 06:35:01','',''),(2238847,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-11 06:35:01','',''),(2238858,'1','150','771',329,'Retail Sale Id 1314601',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:35:52','',''),(2238859,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:35:52','',''),(2238874,'1','150','771',329,'Retail Sale Id 1314608',998.56,0.00,0.00,0.00,998.56,'2021-12-11 06:36:53','',''),(2238875,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 06:36:53','',''),(2238886,'1','150','771',329,'Retail Sale Id 1314614',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 06:37:28','',''),(2238887,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 06:37:28','',''),(2238904,'1','150','771',329,'Retail Sale Id 1314621',4000.56,0.00,0.00,0.00,4000.56,'2021-12-11 06:38:55','',''),(2238905,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 06:38:55','',''),(2239002,'1','150','771',329,'Retail Sale Id 1314677',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 06:47:05','',''),(2239003,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:47:05','',''),(2239038,'1','150','771',329,'Retail Sale Id 1314701',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 06:49:38','',''),(2239039,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 06:49:38','',''),(2239066,'1','150','771',329,'Retail Sale Id 1314713',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 06:51:42','',''),(2239067,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 06:51:42','',''),(2239106,'1','150','771',329,'Retail Sale Id 1314732',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 06:54:00','',''),(2239107,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 06:54:00','',''),(2239124,'1','150','771',329,'Retail Sale Id 1314740',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 06:54:54','',''),(2239125,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 06:54:54','',''),(2239152,'1','150','771',329,'Retail Sale Id 1314754',998.56,0.00,0.00,0.00,998.56,'2021-12-11 06:56:35','',''),(2239153,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 06:56:35','',''),(2239172,'1','150','771',329,'Retail Sale Id 1314762',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 06:57:40','',''),(2239173,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 06:57:40','',''),(2239207,'1','150','771',329,'Retail Sale Id 1314771',2546.96,0.00,0.00,0.00,2546.96,'2021-12-11 06:59:57','',''),(2239208,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 06:59:57','',''),(2239223,'1','150','771',329,'Retail Sale Id 1314797',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 07:00:38','',''),(2239224,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:00:38','',''),(2239235,'1','150','771',329,'Retail Sale Id 1314805',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:01:29','',''),(2239236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:01:29','',''),(2239248,'1','150','771',329,'Retail Sale Id 1314809',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 07:02:07','',''),(2239249,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 07:02:07','',''),(2239266,'1','150','771',329,'Retail Sale Id 1314818',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 07:03:12','',''),(2239267,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 07:03:12','',''),(2239282,'1','150','771',329,'Retail Sale Id 1314824',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 07:04:05','',''),(2239283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:04:05','',''),(2239296,'1','150','771',329,'Retail Sale Id 1314830',2698.64,0.00,0.00,0.00,2698.64,'2021-12-11 07:04:52','',''),(2239297,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-11 07:04:52','',''),(2239312,'1','150','771',329,'Retail Sale Id 1314839',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:06:07','',''),(2239313,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:06:07','',''),(2239330,'1','150','771',329,'Retail Sale Id 1314849',1403.04,0.00,0.00,0.00,1403.04,'2021-12-11 07:06:48','',''),(2239331,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-11 07:06:48','',''),(2239346,'1','150','771',329,'Retail Sale Id 1314856',1200.80,0.00,0.00,0.00,1200.80,'2021-12-11 07:07:32','',''),(2239347,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-11 07:07:32','',''),(2239374,'1','150','771',329,'Retail Sale Id 1314871',998.56,0.00,0.00,0.00,998.56,'2021-12-11 07:09:36','',''),(2239375,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:09:36','',''),(2239390,'1','150','771',329,'Retail Sale Id 1314878',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 07:10:19','',''),(2239391,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 07:10:19','',''),(2239400,'1','150','771',329,'Retail Sale Id 1314883',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:11:00','',''),(2239401,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:11:00','',''),(2239426,'1','150','771',329,'Retail Sale Id 1314899',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 07:13:38','',''),(2239427,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:13:38','',''),(2239499,'1','150','771',329,'Retail Sale Id 1314941',1200.80,0.00,0.00,0.00,1200.80,'2021-12-11 07:17:37','',''),(2239500,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-11 07:17:37','',''),(2239509,'1','150','771',329,'Retail Sale Id 1314945',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 07:18:12','',''),(2239510,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:18:12','',''),(2239541,'1','150','771',329,'Retail Sale Id 1314961',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 07:20:35','',''),(2239542,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:20:35','',''),(2239579,'1','150','771',329,'Retail Sale Id 1314983',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:22:44','',''),(2239580,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:22:44','',''),(2239600,'1','150','771',329,'Retail Sale Id 1314995',6320.00,0.00,0.00,0.00,6320.00,'2021-12-11 07:24:07','',''),(2239601,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 07:24:07','',''),(2239618,'1','150','771',329,'Retail Sale Id 1315018',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 07:24:56','',''),(2239619,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 07:24:56','',''),(2239636,'1','150','771',329,'Retail Sale Id 1315026',6351.60,0.00,0.00,0.00,6351.60,'2021-12-11 07:25:40','',''),(2239637,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-11 07:25:40','',''),(2239652,'1','150','771',329,'Retail Sale Id 1315036',998.56,0.00,0.00,0.00,998.56,'2021-12-11 07:26:20','',''),(2239653,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:26:20','',''),(2239672,'1','150','771',329,'Retail Sale Id 1315043',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:27:08','',''),(2239673,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:27:08','',''),(2239756,'1','150','771',329,'Retail Sale Id 1315083',998.56,0.00,0.00,0.00,998.56,'2021-12-11 07:31:53','',''),(2239757,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:31:53','',''),(2239778,'1','150','771',329,'Retail Sale Id 1315094',4000.56,0.00,0.00,0.00,4000.56,'2021-12-11 07:32:31','',''),(2239779,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 07:32:31','',''),(2239803,'1','150','771',329,'Retail Sale Id 1315107',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:33:46','',''),(2239804,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:33:46','',''),(2239831,'1','150','771',329,'Retail Sale Id 1315122',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 07:35:32','',''),(2239832,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 07:35:32','',''),(2239853,'1','150','771',329,'Retail Sale Id 1315136',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 07:36:27','',''),(2239854,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:36:27','',''),(2239887,'1','150','771',329,'Retail Sale Id 1315159',998.56,0.00,0.00,0.00,998.56,'2021-12-11 07:38:15','',''),(2239888,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:38:15','',''),(2239939,'1','150','771',329,'Retail Sale Id 1315183',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 07:40:51','',''),(2239940,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:40:51','',''),(2239987,'1','150','771',329,'Retail Sale Id 1315206',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 07:43:30','',''),(2239988,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 07:43:30','',''),(2240064,'1','150','771',329,'Retail Sale Id 1315253',701.52,0.00,0.00,0.00,701.52,'2021-12-11 07:47:27','',''),(2240065,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-11 07:47:27','',''),(2240112,'1','150','771',329,'Retail Sale Id 1315273',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:48:44','',''),(2240113,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:48:44','',''),(2240132,'1','150','771',329,'Retail Sale Id 1315281',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 07:49:38','',''),(2240133,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 07:49:38','',''),(2240182,'1','150','771',329,'Retail Sale Id 1315293',1700.08,0.00,0.00,0.00,1700.08,'2021-12-11 07:50:25','',''),(2240183,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-11 07:50:25','',''),(2240200,'1','150','771',329,'Retail Sale Id 1315300',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 07:51:28','',''),(2240201,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:51:28','',''),(2240220,'1','150','771',329,'Retail Sale Id 1315311',998.56,0.00,0.00,0.00,998.56,'2021-12-11 07:52:46','',''),(2240221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:52:46','',''),(2240270,'1','150','771',329,'Retail Sale Id 1315337',4499.84,0.00,0.00,0.00,4499.84,'2021-12-11 07:54:47','',''),(2240271,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-11 07:54:47','',''),(2240284,'1','150','771',329,'Retail Sale Id 1315344',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 07:55:29','',''),(2240285,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 07:55:29','',''),(2240329,'1','150','771',329,'Retail Sale Id 1315365',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 07:57:09','',''),(2240330,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:57:09','',''),(2240349,'1','150','771',329,'Retail Sale Id 1315377',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 07:58:12','',''),(2240350,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:58:12','',''),(2240398,'1','150','771',329,'Retail Sale Id 1315397',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:00:00','',''),(2240399,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:00:00','',''),(2240418,'1','150','771',329,'Retail Sale Id 1315409',0.00,0.00,0.00,0.00,0.00,'2021-12-11 08:01:15','',''),(2240419,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-11 08:01:15','',''),(2240449,'1','150','771',329,'Retail Sale Id 1315419',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 08:02:46','',''),(2240450,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 08:02:46','',''),(2240490,'1','150','771',329,'Retail Sale Id 1315434',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:04:35','',''),(2240491,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:04:35','',''),(2240537,'1','150','771',329,'Retail Sale Id 1315443',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:05:42','',''),(2240538,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:05:42','',''),(2240560,'1','150','771',329,'Retail Sale Id 1315452',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 08:06:53','',''),(2240561,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 08:06:53','',''),(2240576,'1','150','771',329,'Retail Sale Id 1315459',998.56,0.00,0.00,0.00,998.56,'2021-12-11 08:07:51','',''),(2240577,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 08:07:51','',''),(2240628,'1','150','771',329,'Retail Sale Id 1315475',4999.12,0.00,0.00,0.00,4999.12,'2021-12-11 08:09:54','',''),(2240629,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 08:09:54','',''),(2240656,'1','150','771',329,'Retail Sale Id 1315488',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:10:59','',''),(2240657,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:10:59','',''),(2240683,'1','150','771',329,'Retail Sale Id 1315498',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:12:24','',''),(2240684,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:12:24','',''),(2240693,'1','150','771',329,'Retail Sale Id 1315506',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:13:01','',''),(2240694,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:13:02','',''),(2240924,'1','150','771',329,'Retail Sale Id 1315638',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 08:24:18','',''),(2240925,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:24:18','',''),(2240962,'1','150','771',329,'Retail Sale Id 1315654',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:26:45','',''),(2240963,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:26:45','',''),(2241007,'1','150','771',329,'Retail Sale Id 1315679',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 08:29:22','',''),(2241008,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 08:29:22','',''),(2241068,'1','150','771',329,'Retail Sale Id 1315701',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 08:31:45','',''),(2241069,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:31:45','',''),(2241088,'1','150','771',329,'Retail Sale Id 1315714',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:33:01','',''),(2241089,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:33:01','',''),(2241118,'1','150','771',329,'Retail Sale Id 1315730',39000.72,0.00,0.00,0.00,39000.72,'2021-12-11 08:34:18','',''),(2241119,'1','150','771',329,'Retail sales',0.00,0.00,0.00,61.71,0.00,'2021-12-11 08:34:18','',''),(2241364,'1','150','771',329,'Retail Sale Id 1315836',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:46:04','',''),(2241365,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:46:04','',''),(2241394,'1','150','771',329,'Retail Sale Id 1315851',2546.96,0.00,0.00,0.00,2546.96,'2021-12-11 08:47:37','',''),(2241395,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 08:47:37','',''),(2241435,'1','150','771',329,'Retail Sale Id 1315864',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:49:24','',''),(2241436,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:49:24','',''),(2241455,'1','150','771',329,'Retail Sale Id 1315875',998.56,0.00,0.00,0.00,998.56,'2021-12-11 08:50:11','',''),(2241458,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 08:50:11','',''),(2241467,'1','150','771',329,'Retail Sale Id 1315881',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 08:50:54','',''),(2241468,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:50:54','',''),(2241485,'1','150','771',329,'Retail Sale Id 1315890',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 08:51:55','',''),(2241486,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 08:51:55','',''),(2241503,'1','150','771',329,'Retail Sale Id 1315898',4000.56,0.00,0.00,0.00,4000.56,'2021-12-11 08:53:07','',''),(2241504,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 08:53:07','',''),(2241521,'1','150','771',329,'Retail Sale Id 1315908',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 08:54:01','',''),(2241522,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 08:54:01','',''),(2241585,'1','150','771',329,'Retail Sale Id 1315933',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 08:56:26','',''),(2241586,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:56:26','',''),(2241634,'1','150','771',329,'Retail Sale Id 1315948',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 08:57:59','',''),(2241635,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:57:59','',''),(2241646,'1','150','771',329,'Retail Sale Id 1315955',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 08:58:35','',''),(2241647,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:58:35','',''),(2241693,'1','150','771',329,'Retail Sale Id 1315975',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 08:59:51','',''),(2241694,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:59:51','',''),(2241724,'1','150','771',329,'Retail Sale Id 1315987',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 09:01:02','',''),(2241725,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:01:02','',''),(2241740,'1','150','771',329,'Retail Sale Id 1315996',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 09:01:45','',''),(2241741,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 09:01:45','',''),(2241746,'1','150','771',329,'Retail Sale Id 1315999',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 09:02:24','',''),(2241747,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 09:02:24','',''),(2241778,'1','150','771',329,'Retail Sale Id 1316021',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:03:39','',''),(2241779,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:03:39','',''),(2241860,'1','150','771',329,'Retail Sale Id 1316059',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 09:07:24','',''),(2241861,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:07:24','',''),(2241872,'1','150','771',329,'Retail Sale Id 1316064',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 09:08:01','',''),(2241873,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 09:08:01','',''),(2241904,'1','150','771',329,'Retail Sale Id 1316080',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 09:09:26','',''),(2241905,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:09:26','',''),(2241929,'1','150','771',329,'Retail Sale Id 1316093',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 09:10:32','',''),(2241930,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:10:32','',''),(2241937,'1','150','771',329,'Retail Sale Id 1316100',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:11:08','',''),(2241938,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:11:08','',''),(2241953,'1','150','771',329,'Retail Sale Id 1316109',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:11:53','',''),(2241954,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:11:53','',''),(2241994,'1','150','771',329,'Retail Sale Id 1316123',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:13:16','',''),(2241995,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:13:16','',''),(2242018,'1','150','771',329,'Retail Sale Id 1316135',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:14:12','',''),(2242019,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:14:12','',''),(2242046,'1','150','771',329,'Retail Sale Id 1316147',6351.60,0.00,0.00,0.00,6351.60,'2021-12-11 09:15:31','',''),(2242047,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-11 09:15:31','',''),(2242066,'1','150','771',329,'Retail Sale Id 1316171',3501.28,0.00,0.00,0.00,3501.28,'2021-12-11 09:16:41','',''),(2242067,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-11 09:16:41','',''),(2242090,'1','150','771',329,'Retail Sale Id 1316180',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 09:17:32','',''),(2242091,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:17:32','',''),(2242112,'1','150','771',329,'Retail Sale Id 1316187',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 09:18:17','',''),(2242113,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:18:17','',''),(2242135,'1','150','771',329,'Retail Sale Id 1316193',2799.76,0.00,0.00,0.00,2799.76,'2021-12-11 09:19:09','',''),(2242136,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.43,0.00,'2021-12-11 09:19:09','',''),(2242150,'1','150','771',329,'Retail Sale Id 1316199',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 09:20:03','',''),(2242151,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:20:03','',''),(2242168,'1','150','771',329,'Retail Sale Id 1316207',4999.12,0.00,0.00,0.00,4999.12,'2021-12-11 09:20:58','',''),(2242169,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 09:20:58','',''),(2242179,'1','150','771',329,'Retail Sale Id 1316211',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:21:38','',''),(2242180,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:21:38','',''),(2242263,'1','150','771',329,'Retail Sale Id 1316250',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:25:43','',''),(2242264,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:25:43','',''),(2242283,'1','150','771',329,'Retail Sale Id 1316261',998.56,0.00,0.00,0.00,998.56,'2021-12-11 09:27:29','',''),(2242284,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 09:27:29','',''),(2242309,'1','150','771',329,'Retail Sale Id 1316274',2698.64,0.00,0.00,0.00,2698.64,'2021-12-11 09:29:15','',''),(2242310,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-11 09:29:15','',''),(2242323,'1','150','771',329,'Retail Sale Id 1316281',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:29:57','',''),(2242324,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:29:57','',''),(2242341,'1','150','771',329,'Retail Sale Id 1316292',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 09:31:04','',''),(2242342,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:31:04','',''),(2242368,'1','150','771',329,'Retail Sale Id 1316307',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:32:18','',''),(2242369,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:32:18','',''),(2242392,'1','150','771',329,'Retail Sale Id 1316319',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 09:33:24','',''),(2242393,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:33:24','',''),(2242414,'1','150','771',329,'Retail Sale Id 1316330',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:34:23','',''),(2242415,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:34:23','',''),(2242472,'1','150','771',329,'Retail Sale Id 1316362',1497.84,0.00,0.00,0.00,1497.84,'2021-12-11 09:37:12','',''),(2242473,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:37:12','',''),(2242576,'1','150','771',329,'Retail Sale Id 1316418',6496.96,0.00,0.00,0.00,6496.96,'2021-12-11 09:41:39','',''),(2242577,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.28,0.00,'2021-12-11 09:41:39','',''),(2242620,'1','150','771',329,'Retail Sale Id 1316438',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:43:46','',''),(2242621,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:43:46','',''),(2242660,'1','150','771',329,'Retail Sale Id 1316456',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 09:45:13','',''),(2242661,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:45:13','',''),(2242684,'1','150','771',329,'Retail Sale Id 1316467',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:46:13','',''),(2242685,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:46:13','',''),(2242702,'1','150','771',329,'Retail Sale Id 1316476',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 09:46:51','',''),(2242703,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:46:51','',''),(2242712,'1','150','771',329,'Retail Sale Id 1316480',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 09:47:39','',''),(2242713,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:47:39','',''),(2242724,'1','150','771',329,'Retail Sale Id 1316489',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 09:48:22','',''),(2242725,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 09:48:22','',''),(2242740,'1','150','771',329,'Retail Sale Id 1316496',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 09:49:06','',''),(2242741,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:49:06','',''),(2242774,'1','150','771',329,'Retail Sale Id 1316513',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 09:50:26','',''),(2242775,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:50:26','',''),(2242786,'1','150','771',329,'Retail Sale Id 1316520',0.00,0.00,0.00,0.00,0.00,'2021-12-11 09:51:08','',''),(2242787,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-11 09:51:08','',''),(2243203,'1','150','771',329,'Retail Sale Id 1316699',701.52,0.00,0.00,0.00,701.52,'2021-12-11 10:11:54','',''),(2243204,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-11 10:11:54','',''),(2243245,'1','150','771',329,'Retail Sale Id 1316721',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 10:13:53','',''),(2243246,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 10:13:53','',''),(2243282,'1','150','771',329,'Retail Sale Id 1316733',998.56,0.00,0.00,0.00,998.56,'2021-12-11 10:14:56','',''),(2243283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:14:56','',''),(2243421,'1','150','771',329,'Retail Sale Id 1316793',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 10:20:52','',''),(2243422,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:20:52','',''),(2243477,'1','150','771',329,'Retail Sale Id 1316821',4000.56,0.00,0.00,0.00,4000.56,'2021-12-11 10:24:31','',''),(2243478,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 10:24:31','',''),(2243503,'1','150','771',329,'Retail Sale Id 1316835',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 10:25:49','',''),(2243504,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:25:49','',''),(2243575,'1','150','771',329,'Retail Sale Id 1316870',998.56,0.00,0.00,0.00,998.56,'2021-12-11 10:29:11','',''),(2243576,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:29:11','',''),(2243599,'1','150','771',329,'Retail Sale Id 1316881',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 10:30:09','',''),(2243600,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:30:09','',''),(2243645,'1','150','771',329,'Retail Sale Id 1316903',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 10:33:17','',''),(2243646,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 10:33:17','',''),(2243742,'1','150','771',329,'Retail Sale Id 1316933',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 10:38:53','',''),(2243743,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 10:38:53','',''),(2243780,'1','150','771',329,'Retail Sale Id 1316971',2597.52,0.00,0.00,0.00,2597.52,'2021-12-11 10:40:43','',''),(2243781,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-11 10:40:43','',''),(2243806,'1','150','771',329,'Retail Sale Id 1316980',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 10:41:52','',''),(2243807,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:41:52','',''),(2243828,'1','150','771',329,'Retail Sale Id 1316993',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 10:42:52','',''),(2243829,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 10:42:52','',''),(2243840,'1','150','771',329,'Retail Sale Id 1316997',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 10:43:35','',''),(2243841,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 10:43:35','',''),(2243858,'1','150','771',329,'Retail Sale Id 1317006',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 10:44:38','',''),(2243859,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:44:38','',''),(2243888,'1','150','771',329,'Retail Sale Id 1317023',998.56,0.00,0.00,0.00,998.56,'2021-12-11 10:46:04','',''),(2243889,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:46:04','',''),(2243892,'1','150','771',329,'Retail Sale Id 1317025',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 10:46:44','',''),(2243893,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:46:44','',''),(2243918,'1','150','771',329,'Retail Sale Id 1317039',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 10:47:40','',''),(2243919,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 10:47:40','',''),(2243926,'1','150','771',329,'Retail Sale Id 1317044',802.64,0.00,0.00,0.00,802.64,'2021-12-11 10:48:28','',''),(2243927,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-11 10:48:28','',''),(2243942,'1','150','771',329,'Retail Sale Id 1317052',1997.12,0.00,0.00,0.00,1997.12,'2021-12-11 10:49:08','',''),(2243943,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 10:49:08','',''),(2243984,'1','150','771',329,'Retail Sale Id 1317074',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 10:52:09','',''),(2243985,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:52:09','',''),(2244014,'1','150','771',329,'Retail Sale Id 1317088',998.56,0.00,0.00,0.00,998.56,'2021-12-11 10:53:59','',''),(2244015,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:53:59','',''),(2244024,'1','150','771',329,'Retail Sale Id 1317093',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 10:54:37','',''),(2244025,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:54:37','',''),(2244060,'1','150','771',329,'Retail Sale Id 1317113',6648.64,0.00,0.00,0.00,6648.64,'2021-12-11 10:56:30','',''),(2244061,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.52,0.00,'2021-12-11 10:56:30','',''),(2244104,'1','150','771',329,'Retail Sale Id 1317131',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 10:58:54','',''),(2244105,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 10:58:54','',''),(2244188,'1','150','771',329,'Retail Sale Id 1317163',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 11:02:00','',''),(2244189,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:02:00','',''),(2244207,'1','150','771',329,'Retail Sale Id 1317167',2521.68,0.00,0.00,0.00,2521.68,'2021-12-11 11:02:52','',''),(2244208,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.99,0.00,'2021-12-11 11:02:52','',''),(2244223,'1','150','771',329,'Retail Sale Id 1317174',2546.96,0.00,0.00,0.00,2546.96,'2021-12-11 11:03:20','',''),(2244224,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 11:03:20','',''),(2244235,'1','150','771',329,'Retail Sale Id 1317179',998.56,0.00,0.00,0.00,998.56,'2021-12-11 11:03:54','',''),(2244236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 11:03:54','',''),(2244251,'1','150','771',329,'Retail Sale Id 1317190',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 11:04:40','',''),(2244252,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 11:04:40','',''),(2244273,'1','150','771',329,'Retail Sale Id 1317198',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 11:05:43','',''),(2244274,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:05:43','',''),(2244293,'1','150','771',329,'Retail Sale Id 1317206',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 11:06:46','',''),(2244294,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 11:06:46','',''),(2244301,'1','150','771',329,'Retail Sale Id 1317213',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 11:07:28','',''),(2244302,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:07:28','',''),(2244315,'1','150','771',329,'Retail Sale Id 1317223',1301.92,0.00,0.00,0.00,1301.92,'2021-12-11 11:08:01','',''),(2244316,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 11:08:01','',''),(2244331,'1','150','771',329,'Retail Sale Id 1317231',2502.72,0.00,0.00,0.00,2502.72,'2021-12-11 11:08:47','',''),(2244332,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 11:08:47','',''),(2244369,'1','150','771',329,'Retail Sale Id 1317249',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 11:10:38','',''),(2244370,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:10:38','',''),(2244456,'1','150','771',329,'Retail Sale Id 1317290',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 11:15:26','',''),(2244457,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:15:26','',''),(2244470,'1','150','771',329,'Retail Sale Id 1317294',499.28,0.00,0.00,0.00,499.28,'2021-12-11 11:16:09','',''),(2244471,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-11 11:16:10','',''),(2244487,'1','150','771',329,'Retail Sale Id 1317306',701.52,0.00,0.00,0.00,701.52,'2021-12-11 11:16:59','',''),(2244488,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-11 11:16:59','',''),(2244509,'1','150','771',329,'Retail Sale Id 1317316',1200.80,0.00,0.00,0.00,1200.80,'2021-12-11 11:18:11','',''),(2244510,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-11 11:18:11','',''),(2244539,'1','150','771',329,'Retail Sale Id 1317332',7900.00,0.00,0.00,0.00,7900.00,'2021-12-11 11:19:58','',''),(2244540,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:19:58','',''),(2244575,'1','150','771',329,'Retail Sale Id 1317349',3197.92,0.00,0.00,0.00,3197.92,'2021-12-11 11:21:34','',''),(2244576,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 11:21:34','',''),(2244593,'1','150','771',329,'Retail Sale Id 1317359',3002.00,0.00,0.00,0.00,3002.00,'2021-12-11 11:22:26','',''),(2244594,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 11:22:26','',''),(2244622,'1','150','771',329,'Retail Sale Id 1317368',1902.32,0.00,0.00,0.00,1902.32,'2021-12-11 11:23:13','',''),(2244623,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:23:13','',''),(2244662,'1','150','771',329,'Retail Sale Id 1317392',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 11:25:22','',''),(2244663,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 11:25:22','',''),(2244770,'1','150','771',329,'Retail Sale Id 1317441',3899.44,0.00,0.00,0.00,3899.44,'2021-12-11 11:31:12','',''),(2244771,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 11:31:12','',''),(2244890,'1','150','771',329,'Retail Sale Id 1317508',5997.68,0.00,0.00,0.00,5997.68,'2021-12-11 11:38:39','',''),(2244891,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-11 11:38:39','',''),(2247594,'1','150','771',329,'Retail Sale Id 1318892',166462.48,0.00,0.00,0.00,166462.48,'2021-12-11 14:34:33','',''),(2247595,'1','150','771',329,'Retail sales',0.00,0.00,0.00,263.39,0.00,'2021-12-11 14:34:33','',''),(2253963,'1','150','771',329,'Retail Sale Id 1321743',0.00,0.00,0.00,0.00,0.00,'2021-12-12 08:24:10','',''),(2253964,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-12 08:24:10','',''),(2254647,'1','150','771',329,'Retail Sale Id 1322076',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 09:04:33','',''),(2254648,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:04:33','',''),(2254757,'1','150','771',329,'Retail Sale Id 1322137',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 09:10:42','',''),(2254758,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 09:10:42','',''),(2254797,'1','150','771',329,'Retail Sale Id 1322148',998.56,0.00,0.00,0.00,998.56,'2021-12-12 09:11:58','',''),(2254798,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:11:58','',''),(2254813,'1','150','771',329,'Retail Sale Id 1322162',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 09:12:51','',''),(2254814,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:12:51','',''),(2254833,'1','150','771',329,'Retail Sale Id 1322172',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 09:14:08','',''),(2254834,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 09:14:08','',''),(2254855,'1','150','771',329,'Retail Sale Id 1322188',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 09:15:32','',''),(2254856,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:15:32','',''),(2254875,'1','150','771',329,'Retail Sale Id 1322196',3160.00,0.00,0.00,0.00,3160.00,'2021-12-12 09:16:47','',''),(2254876,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 09:16:47','',''),(2254891,'1','150','771',329,'Retail Sale Id 1322206',998.56,0.00,0.00,0.00,998.56,'2021-12-12 09:17:56','',''),(2254892,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:17:56','',''),(2254925,'1','150','771',329,'Retail Sale Id 1322224',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 09:19:14','',''),(2254926,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 09:19:14','',''),(2254933,'1','150','771',329,'Retail Sale Id 1322226',998.56,0.00,0.00,0.00,998.56,'2021-12-12 09:19:51','',''),(2254934,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:19:51','',''),(2255137,'1','150','771',329,'Retail Sale Id 1322316',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 09:31:59','',''),(2255138,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:31:59','',''),(2255243,'1','150','771',329,'Retail Sale Id 1322366',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 09:38:07','',''),(2255244,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 09:38:07','',''),(2255259,'1','150','771',329,'Retail Sale Id 1322382',998.56,0.00,0.00,0.00,998.56,'2021-12-12 09:39:44','',''),(2255260,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:39:44','',''),(2255279,'1','150','771',329,'Retail Sale Id 1322395',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 09:41:45','',''),(2255280,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 09:41:45','',''),(2255295,'1','150','771',329,'Retail Sale Id 1322405',2546.96,0.00,0.00,0.00,2546.96,'2021-12-12 09:43:01','',''),(2255296,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 09:43:01','',''),(2255313,'1','150','771',329,'Retail Sale Id 1322411',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 09:44:21','',''),(2255314,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:44:21','',''),(2255329,'1','150','771',329,'Retail Sale Id 1322423',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 09:45:06','',''),(2255330,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 09:45:06','',''),(2255387,'1','150','771',329,'Retail Sale Id 1322442',998.56,0.00,0.00,0.00,998.56,'2021-12-12 09:47:18','',''),(2255388,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:47:18','',''),(2255431,'1','150','771',329,'Retail Sale Id 1322465',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 09:50:00','',''),(2255432,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:50:00','',''),(2255447,'1','150','771',329,'Retail Sale Id 1322475',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 09:51:07','',''),(2255448,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 09:51:07','',''),(2255478,'1','150','771',329,'Retail Sale Id 1322486',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 09:52:28','',''),(2255479,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 09:52:28','',''),(2255494,'1','150','771',329,'Retail Sale Id 1322495',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 09:53:04','',''),(2255495,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 09:53:04','',''),(2255528,'1','150','771',329,'Retail Sale Id 1322508',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 09:54:13','',''),(2255529,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:54:13','',''),(2255544,'1','150','771',329,'Retail Sale Id 1322516',2597.52,0.00,0.00,0.00,2597.52,'2021-12-12 09:55:11','',''),(2255545,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 09:55:11','',''),(2255577,'1','150','771',329,'Retail Sale Id 1322530',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 09:55:59','',''),(2255578,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:55:59','',''),(2255593,'1','150','771',329,'Retail Sale Id 1322537',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 09:56:49','',''),(2255594,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 09:56:49','',''),(2255652,'1','150','771',329,'Retail Sale Id 1322561',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 09:59:23','',''),(2255653,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:59:23','',''),(2255664,'1','150','771',329,'Retail Sale Id 1322568',2502.72,0.00,0.00,0.00,2502.72,'2021-12-12 09:59:53','',''),(2255665,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 09:59:53','',''),(2255686,'1','150','771',329,'Retail Sale Id 1322580',7002.56,0.00,0.00,0.00,7002.56,'2021-12-12 10:01:02','',''),(2255687,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 10:01:02','',''),(2255708,'1','150','771',329,'Retail Sale Id 1322588',4499.84,0.00,0.00,0.00,4499.84,'2021-12-12 10:01:54','',''),(2255709,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-12 10:01:54','',''),(2255727,'1','150','771',329,'Retail Sale Id 1322592',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:02:37','',''),(2255728,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:02:37','',''),(2255749,'1','150','771',329,'Retail Sale Id 1322602',2502.72,0.00,0.00,0.00,2502.72,'2021-12-12 10:03:23','',''),(2255750,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 10:03:23','',''),(2255761,'1','150','771',329,'Retail Sale Id 1322611',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:04:12','',''),(2255762,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:04:12','',''),(2255781,'1','150','771',329,'Retail Sale Id 1322619',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:05:04','',''),(2255782,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:05:04','',''),(2255807,'1','150','771',329,'Retail Sale Id 1322635',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 10:05:59','',''),(2255808,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:05:59','',''),(2255839,'1','150','771',329,'Retail Sale Id 1322655',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:07:30','',''),(2255840,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:07:30','',''),(2255865,'1','150','771',329,'Retail Sale Id 1322669',31998.16,0.00,0.00,0.00,31998.16,'2021-12-12 10:09:08','',''),(2255866,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.63,0.00,'2021-12-12 10:09:08','',''),(2255874,'1','150','771',329,'Retail Sale Id 1322673',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 10:09:38','',''),(2255875,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:09:38','',''),(2255882,'1','150','771',329,'Retail Sale Id 1322676',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 10:10:17','',''),(2255883,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:10:17','',''),(2255892,'1','150','771',329,'Retail Sale Id 1322682',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:10:51','',''),(2255893,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:10:51','',''),(2255917,'1','150','771',329,'Retail Sale Id 1322693',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:11:47','',''),(2255918,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:11:47','',''),(2255960,'1','150','771',329,'Retail Sale Id 1322714',2597.52,0.00,0.00,0.00,2597.52,'2021-12-12 10:13:54','',''),(2255961,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 10:13:54','',''),(2255978,'1','150','771',329,'Retail Sale Id 1322721',2546.96,0.00,0.00,0.00,2546.96,'2021-12-12 10:14:28','',''),(2255979,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 10:14:28','',''),(2255986,'1','150','771',329,'Retail Sale Id 1322726',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:15:05','',''),(2255987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:15:05','',''),(2255998,'1','150','771',329,'Retail Sale Id 1322732',499.28,0.00,0.00,0.00,499.28,'2021-12-12 10:15:42','',''),(2255999,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-12 10:15:42','',''),(2256010,'1','150','771',329,'Retail Sale Id 1322741',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:16:17','',''),(2256011,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:16:17','',''),(2256030,'1','150','771',329,'Retail Sale Id 1322757',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 10:17:07','',''),(2256031,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:17:07','',''),(2256040,'1','150','771',329,'Retail Sale Id 1322762',4999.12,0.00,0.00,0.00,4999.12,'2021-12-12 10:17:55','',''),(2256041,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 10:17:55','',''),(2256055,'1','150','771',329,'Retail Sale Id 1322769',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:18:42','',''),(2256056,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:18:42','',''),(2256083,'1','150','771',329,'Retail Sale Id 1322786',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:21:20','',''),(2256084,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:21:20','',''),(2256121,'1','150','771',329,'Retail Sale Id 1322806',6351.60,0.00,0.00,0.00,6351.60,'2021-12-12 10:23:50','',''),(2256122,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-12 10:23:50','',''),(2256133,'1','150','771',329,'Retail Sale Id 1322811',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 10:24:26','',''),(2256134,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:24:26','',''),(2256147,'1','150','771',329,'Retail Sale Id 1322821',802.64,0.00,0.00,0.00,802.64,'2021-12-12 10:25:13','',''),(2256148,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 10:25:13','',''),(2256173,'1','150','771',329,'Retail Sale Id 1322826',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:26:01','',''),(2256174,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:26:01','',''),(2256189,'1','150','771',329,'Retail Sale Id 1322840',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 10:27:03','',''),(2256190,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:27:03','',''),(2256209,'1','150','771',329,'Retail Sale Id 1322849',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:28:09','',''),(2256210,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:28:09','',''),(2256221,'1','150','771',329,'Retail Sale Id 1322854',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 10:28:52','',''),(2256222,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:28:52','',''),(2256235,'1','150','771',329,'Retail Sale Id 1322866',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:30:01','',''),(2256236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:30:01','',''),(2256255,'1','150','771',329,'Retail Sale Id 1322877',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:30:35','',''),(2256256,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:30:35','',''),(2256273,'1','150','771',329,'Retail Sale Id 1322886',6496.96,0.00,0.00,0.00,6496.96,'2021-12-12 10:31:24','',''),(2256274,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.28,0.00,'2021-12-12 10:31:24','',''),(2256289,'1','150','771',329,'Retail Sale Id 1322893',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:32:14','',''),(2256290,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:32:14','',''),(2256339,'1','150','771',329,'Retail Sale Id 1322921',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:34:39','',''),(2256340,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:34:39','',''),(2256347,'1','150','771',329,'Retail Sale Id 1322925',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 10:35:14','',''),(2256348,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:35:14','',''),(2256369,'1','150','771',329,'Retail Sale Id 1322940',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:36:34','',''),(2256370,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:36:34','',''),(2256441,'1','150','771',329,'Retail Sale Id 1322978',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 10:40:11','',''),(2256442,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 10:40:11','',''),(2256473,'1','150','771',329,'Retail Sale Id 1322993',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 10:41:37','',''),(2256474,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:41:37','',''),(2256504,'1','150','771',329,'Retail Sale Id 1323003',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:42:48','',''),(2256505,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:42:48','',''),(2256538,'1','150','771',329,'Retail Sale Id 1323017',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:44:15','',''),(2256539,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:44:15','',''),(2256554,'1','150','771',329,'Retail Sale Id 1323028',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 10:45:06','',''),(2256555,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 10:45:06','',''),(2256586,'1','150','771',329,'Retail Sale Id 1323040',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 10:46:29','',''),(2256587,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 10:46:29','',''),(2256602,'1','150','771',329,'Retail Sale Id 1323049',5997.68,0.00,0.00,0.00,5997.68,'2021-12-12 10:47:11','',''),(2256603,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 10:47:11','',''),(2256608,'1','150','771',329,'Retail Sale Id 1323052',998.56,0.00,0.00,0.00,998.56,'2021-12-12 10:47:55','',''),(2256609,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:47:55','',''),(2256624,'1','150','771',329,'Retail Sale Id 1323064',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 10:48:38','',''),(2256625,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 10:48:38','',''),(2256642,'1','150','771',329,'Retail Sale Id 1323074',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:49:27','',''),(2256643,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:49:27','',''),(2256662,'1','150','771',329,'Retail Sale Id 1323083',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 10:50:18','',''),(2256663,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:50:18','',''),(2256680,'1','150','771',329,'Retail Sale Id 1323093',4000.56,0.00,0.00,0.00,4000.56,'2021-12-12 10:51:19','',''),(2256681,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 10:51:19','',''),(2256703,'1','150','771',329,'Retail Sale Id 1323108',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 10:52:21','',''),(2256704,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:52:21','',''),(2256743,'1','150','771',329,'Retail Sale Id 1323123',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 10:53:50','',''),(2256744,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:53:50','',''),(2256775,'1','150','771',329,'Retail Sale Id 1323140',499.28,0.00,0.00,0.00,499.28,'2021-12-12 10:55:40','',''),(2256776,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-12 10:55:40','',''),(2256832,'1','150','771',329,'Retail Sale Id 1323169',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 10:57:48','',''),(2256833,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:57:48','',''),(2256867,'1','150','771',329,'Retail Sale Id 1323185',2546.96,0.00,0.00,0.00,2546.96,'2021-12-12 10:59:27','',''),(2256868,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 10:59:27','',''),(2256887,'1','150','771',329,'Retail Sale Id 1323199',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 11:00:10','',''),(2256888,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:00:10','',''),(2256916,'1','150','771',329,'Retail Sale Id 1323206',3697.20,0.00,0.00,0.00,3697.20,'2021-12-12 11:00:51','',''),(2256917,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.85,0.00,'2021-12-12 11:00:51','',''),(2256930,'1','150','771',329,'Retail Sale Id 1323215',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 11:01:31','',''),(2256931,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:01:31','',''),(2256946,'1','150','771',329,'Retail Sale Id 1323227',4449.28,0.00,0.00,0.00,4449.28,'2021-12-12 11:02:19','',''),(2256947,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.04,0.00,'2021-12-12 11:02:19','',''),(2256986,'1','150','771',329,'Retail Sale Id 1323240',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 11:03:51','',''),(2256987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:03:51','',''),(2257004,'1','150','771',329,'Retail Sale Id 1323249',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 11:04:42','',''),(2257005,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:04:42','',''),(2257020,'1','150','771',329,'Retail Sale Id 1323261',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 11:05:28','',''),(2257021,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 11:05:28','',''),(2257048,'1','150','771',329,'Retail Sale Id 1323272',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 11:06:33','',''),(2257049,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:06:33','',''),(2257064,'1','150','771',329,'Retail Sale Id 1323286',4999.12,0.00,0.00,0.00,4999.12,'2021-12-12 11:07:07','',''),(2257065,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 11:07:07','',''),(2257080,'1','150','771',329,'Retail Sale Id 1323294',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 11:07:52','',''),(2257081,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 11:07:52','',''),(2257096,'1','150','771',329,'Retail Sale Id 1323303',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 11:08:30','',''),(2257097,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:08:30','',''),(2257118,'1','150','771',329,'Retail Sale Id 1323314',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 11:09:10','',''),(2257119,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:09:10','',''),(2257154,'1','150','771',329,'Retail Sale Id 1323332',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 11:10:19','',''),(2257155,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:10:19','',''),(2257168,'1','150','771',329,'Retail Sale Id 1323338',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 11:11:26','',''),(2257169,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:11:26','',''),(2257196,'1','150','771',329,'Retail Sale Id 1323352',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 11:12:27','',''),(2257197,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:12:27','',''),(2257213,'1','150','771',329,'Retail Sale Id 1323357',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 11:13:24','',''),(2257214,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 11:13:24','',''),(2257235,'1','150','771',329,'Retail Sale Id 1323371',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 11:14:36','',''),(2257236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:14:36','',''),(2257253,'1','150','771',329,'Retail Sale Id 1323381',998.56,0.00,0.00,0.00,998.56,'2021-12-12 11:15:19','',''),(2257254,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:15:19','',''),(2257285,'1','150','771',329,'Retail Sale Id 1323388',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 11:16:03','',''),(2257286,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:16:03','',''),(2257315,'1','150','771',329,'Retail Sale Id 1323403',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 11:16:47','',''),(2257316,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:16:47','',''),(2261759,'1','150',NULL,329,'Reception corrector for bridging 126773',0.00,0.00,0.00,3676.42,0.00,'2021-12-12 14:50:59','',''),(2261760,'1','150','771',329,'Received from bridging 126773',0.00,0.00,3676.42,0.00,0.00,'2021-12-12 14:50:59','',''),(2261882,'1','150','771',329,'Retail Sale Id 1325474',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 14:57:50','',''),(2261883,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 14:57:50','',''),(2261901,'1','150','771',329,'Retail Sale Id 1325483',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 14:58:54','',''),(2261902,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 14:58:54','',''),(2261923,'1','150','771',329,'Retail Sale Id 1325495',998.56,0.00,0.00,0.00,998.56,'2021-12-12 14:59:59','',''),(2261924,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:59:59','',''),(2261939,'1','150','771',329,'Retail Sale Id 1325504',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 15:00:54','',''),(2261940,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:00:54','',''),(2262070,'1','150','771',329,'Retail Sale Id 1325545',4999.12,0.00,0.00,0.00,4999.12,'2021-12-12 15:07:13','',''),(2262071,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 15:07:13','',''),(2262096,'1','150','771',329,'Retail Sale Id 1325560',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 15:08:24','',''),(2262097,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:08:24','',''),(2262137,'1','150','771',329,'Retail Sale Id 1325577',3501.28,0.00,0.00,0.00,3501.28,'2021-12-12 15:10:56','',''),(2262138,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-12 15:10:56','',''),(2262155,'1','150','771',329,'Retail Sale Id 1325588',3899.44,0.00,0.00,0.00,3899.44,'2021-12-12 15:12:20','',''),(2262156,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-12 15:12:20','',''),(2262177,'1','150','771',329,'Retail Sale Id 1325599',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:13:35','',''),(2262178,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:13:35','',''),(2262191,'1','150','771',329,'Retail Sale Id 1325606',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:14:14','',''),(2262192,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:14:14','',''),(2262197,'1','150','771',329,'Retail Sale Id 1325611',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 15:14:58','',''),(2262198,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:14:58','',''),(2262218,'1','150','771',329,'Retail Sale Id 1325619',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:15:35','',''),(2262219,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:15:35','',''),(2262228,'1','150','771',329,'Retail Sale Id 1325623',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:16:09','',''),(2262229,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:16:09','',''),(2262240,'1','150','771',329,'Retail Sale Id 1325630',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:16:45','',''),(2262241,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:16:45','',''),(2262250,'1','150','771',329,'Retail Sale Id 1325637',4000.56,0.00,0.00,0.00,4000.56,'2021-12-12 15:17:26','',''),(2262251,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 15:17:26','',''),(2262260,'1','150','771',329,'Retail Sale Id 1325641',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:17:57','',''),(2262261,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:17:57','',''),(2262291,'1','150','771',329,'Retail Sale Id 1325651',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:19:43','',''),(2262292,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:19:43','',''),(2262327,'1','150','771',329,'Retail Sale Id 1325670',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:22:33','',''),(2262328,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:22:33','',''),(2262349,'1','150','771',329,'Retail Sale Id 1325681',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 15:23:55','',''),(2262350,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:23:55','',''),(2262388,'1','150','771',329,'Retail Sale Id 1325697',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:25:45','',''),(2262389,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:25:45','',''),(2262426,'1','150','771',329,'Retail Sale Id 1325715',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 15:27:35','',''),(2262427,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:27:35','',''),(2262440,'1','150','771',329,'Retail Sale Id 1325722',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 15:28:38','',''),(2262441,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:28:38','',''),(2262459,'1','150','771',329,'Retail Sale Id 1325732',4000.56,0.00,0.00,0.00,4000.56,'2021-12-12 15:30:10','',''),(2262460,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 15:30:10','',''),(2262485,'1','150','771',329,'Retail Sale Id 1325745',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 15:31:30','',''),(2262486,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:31:30','',''),(2262512,'1','150','771',329,'Retail Sale Id 1325758',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 15:32:39','',''),(2262513,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:32:39','',''),(2262526,'1','150','771',329,'Retail Sale Id 1325765',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:33:50','',''),(2262527,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:33:50','',''),(2262576,'1','150','771',329,'Retail Sale Id 1325784',1801.20,0.00,0.00,0.00,1801.20,'2021-12-12 15:36:25','',''),(2262577,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-12 15:36:25','',''),(2262608,'1','150','771',329,'Retail Sale Id 1325799',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:38:00','',''),(2262609,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:38:00','',''),(2262624,'1','150','771',329,'Retail Sale Id 1325807',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 15:39:04','',''),(2262625,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 15:39:04','',''),(2262644,'1','150','771',329,'Retail Sale Id 1325815',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 15:40:14','',''),(2262645,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:40:14','',''),(2262658,'1','150','771',329,'Retail Sale Id 1325825',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 15:40:54','',''),(2262659,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 15:40:54','',''),(2262696,'1','150','771',329,'Retail Sale Id 1325841',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 15:42:33','',''),(2262697,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:42:33','',''),(2262744,'1','150','771',329,'Retail Sale Id 1325858',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:44:05','',''),(2262745,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:44:05','',''),(2262766,'1','150','771',329,'Retail Sale Id 1325869',4000.56,0.00,0.00,0.00,4000.56,'2021-12-12 15:45:42','',''),(2262767,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 15:45:42','',''),(2262774,'1','150','771',329,'Retail Sale Id 1325874',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:46:36','',''),(2262775,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:46:36','',''),(2262786,'1','150','771',329,'Retail Sale Id 1325881',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 15:47:23','',''),(2262787,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:47:23','',''),(2262802,'1','150','771',329,'Retail Sale Id 1325889',802.64,0.00,0.00,0.00,802.64,'2021-12-12 15:48:12','',''),(2262803,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 15:48:12','',''),(2262816,'1','150','771',329,'Retail Sale Id 1325896',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:49:04','',''),(2262817,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:49:04','',''),(2262822,'1','150','771',329,'Retail Sale Id 1325900',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:49:38','',''),(2262823,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:49:38','',''),(2262839,'1','150','771',329,'Retail Sale Id 1325908',632.00,0.00,0.00,0.00,632.00,'2021-12-12 15:50:33','',''),(2262840,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 15:50:33','',''),(2262853,'1','150','771',329,'Retail Sale Id 1325917',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:51:26','',''),(2262854,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:51:26','',''),(2262877,'1','150','771',329,'Retail Sale Id 1325929',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 15:53:11','',''),(2262878,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:53:11','',''),(2262911,'1','150','771',329,'Retail Sale Id 1325943',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 15:56:06','',''),(2262912,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 15:56:06','',''),(2262955,'1','150','771',329,'Retail Sale Id 1325967',998.56,0.00,0.00,0.00,998.56,'2021-12-12 15:59:09','',''),(2262956,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:59:09','',''),(2262977,'1','150','771',329,'Retail Sale Id 1325976',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:00:29','',''),(2262978,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:00:29','',''),(2262983,'1','150','771',329,'Retail Sale Id 1325980',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:01:11','',''),(2262984,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:01:11','',''),(2263001,'1','150','771',329,'Retail Sale Id 1325992',2546.96,0.00,0.00,0.00,2546.96,'2021-12-12 16:02:08','',''),(2263002,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 16:02:08','',''),(2263015,'1','150','771',329,'Retail Sale Id 1325998',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:03:05','',''),(2263016,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:03:05','',''),(2263023,'1','150','771',329,'Retail Sale Id 1326002',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 16:03:44','',''),(2263024,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:03:44','',''),(2263100,'1','150','771',329,'Retail Sale Id 1326042',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:09:45','',''),(2263101,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:09:45','',''),(2263142,'1','150','771',329,'Retail Sale Id 1326062',2698.64,0.00,0.00,0.00,2698.64,'2021-12-12 16:12:50','',''),(2263143,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-12 16:12:50','',''),(2263158,'1','150','771',329,'Retail Sale Id 1326065',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 16:13:23','',''),(2263159,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 16:13:23','',''),(2263172,'1','150','771',329,'Retail Sale Id 1326072',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 16:14:47','',''),(2263173,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 16:14:47','',''),(2263196,'1','150','771',329,'Retail Sale Id 1326086',7002.56,0.00,0.00,0.00,7002.56,'2021-12-12 16:16:23','',''),(2263197,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 16:16:23','',''),(2263210,'1','150','771',329,'Retail Sale Id 1326092',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:17:17','',''),(2263211,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:17:17','',''),(2263228,'1','150','771',329,'Retail Sale Id 1326101',1700.08,0.00,0.00,0.00,1700.08,'2021-12-12 16:18:02','',''),(2263229,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-12 16:18:02','',''),(2263266,'1','150','771',329,'Retail Sale Id 1326119',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:20:31','',''),(2263267,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:20:31','',''),(2263292,'1','150','771',329,'Retail Sale Id 1326130',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:22:20','',''),(2263293,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:22:20','',''),(2263305,'1','150','771',329,'Retail Sale Id 1326135',897.44,0.00,0.00,0.00,897.44,'2021-12-12 16:23:10','',''),(2263306,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 16:23:10','',''),(2263324,'1','150','771',329,'Retail Sale Id 1326142',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:23:53','',''),(2263325,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:23:53','',''),(2263360,'1','150','771',329,'Retail Sale Id 1326150',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 16:25:07','',''),(2263361,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 16:25:07','',''),(2263397,'1','150','771',329,'Retail Sale Id 1326158',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:26:10','',''),(2263398,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:26:10','',''),(2263429,'1','150','771',329,'Retail Sale Id 1326175',4499.84,0.00,0.00,0.00,4499.84,'2021-12-12 16:28:39','',''),(2263430,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-12 16:28:39','',''),(2263441,'1','150','771',329,'Retail Sale Id 1326180',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 16:29:28','',''),(2263442,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 16:29:28','',''),(2263462,'1','150','771',329,'Retail Sale Id 1326191',2900.88,0.00,0.00,0.00,2900.88,'2021-12-12 16:31:22','',''),(2263463,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.59,0.00,'2021-12-12 16:31:22','',''),(2263480,'1','150','771',329,'Retail Sale Id 1326201',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 16:32:04','',''),(2263481,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 16:32:04','',''),(2263492,'1','150','771',329,'Retail Sale Id 1326210',15800.00,0.00,0.00,0.00,15800.00,'2021-12-12 16:32:56','',''),(2263493,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 16:32:56','',''),(2263520,'1','150','771',329,'Retail Sale Id 1326226',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:34:27','',''),(2263521,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:34:27','',''),(2263546,'1','150','771',329,'Retail Sale Id 1326236',4999.12,0.00,0.00,0.00,4999.12,'2021-12-12 16:35:20','',''),(2263547,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 16:35:20','',''),(2263562,'1','150','771',329,'Retail Sale Id 1326245',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 16:36:21','',''),(2263563,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:36:21','',''),(2263576,'1','150','771',329,'Retail Sale Id 1326254',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:37:39','',''),(2263577,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:37:39','',''),(2263677,'1','150','771',329,'Retail Sale Id 1326293',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:44:02','',''),(2263678,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:44:02','',''),(2263695,'1','150','771',329,'Retail Sale Id 1326303',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:45:11','',''),(2263696,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:45:11','',''),(2263725,'1','150','771',329,'Retail Sale Id 1326317',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 16:47:02','',''),(2263726,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:47:02','',''),(2263781,'1','150','771',329,'Retail Sale Id 1326341',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:49:17','',''),(2263782,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:49:17','',''),(2263797,'1','150','771',329,'Retail Sale Id 1326350',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:50:12','',''),(2263798,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:50:12','',''),(2263817,'1','150','771',329,'Retail Sale Id 1326361',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 16:51:08','',''),(2263818,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:51:08','',''),(2263839,'1','150','771',329,'Retail Sale Id 1326369',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 16:52:19','',''),(2263840,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 16:52:19','',''),(2263859,'1','150','771',329,'Retail Sale Id 1326380',4000.56,0.00,0.00,0.00,4000.56,'2021-12-12 16:53:52','',''),(2263860,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 16:53:52','',''),(2263880,'1','150','771',329,'Retail Sale Id 1326389',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:54:42','',''),(2263881,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:54:42','',''),(2263892,'1','150','771',329,'Retail Sale Id 1326395',1598.96,0.00,0.00,0.00,1598.96,'2021-12-12 16:56:10','',''),(2263893,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-12 16:56:10','',''),(2263905,'1','150','771',329,'Retail Sale Id 1326403',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:56:56','',''),(2263906,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:56:56','',''),(2263915,'1','150','771',329,'Retail Sale Id 1326408',6351.60,0.00,0.00,0.00,6351.60,'2021-12-12 16:57:56','',''),(2263916,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-12 16:57:56','',''),(2263931,'1','150','771',329,'Retail Sale Id 1326416',998.56,0.00,0.00,0.00,998.56,'2021-12-12 16:58:49','',''),(2263932,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:58:49','',''),(2263943,'1','150','771',329,'Retail Sale Id 1326422',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 16:59:43','',''),(2263944,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:59:43','',''),(2263969,'1','150','771',329,'Retail Sale Id 1326434',3197.92,0.00,0.00,0.00,3197.92,'2021-12-12 17:01:25','',''),(2263970,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 17:01:25','',''),(2263987,'1','150','771',329,'Retail Sale Id 1326438',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:02:08','',''),(2263988,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:02:08','',''),(2264018,'1','150','771',329,'Retail Sale Id 1326450',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 17:03:58','',''),(2264019,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:03:58','',''),(2264057,'1','150','771',329,'Retail Sale Id 1326468',998.56,0.00,0.00,0.00,998.56,'2021-12-12 17:07:33','',''),(2264058,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:07:33','',''),(2264073,'1','150','771',329,'Retail Sale Id 1326475',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 17:08:36','',''),(2264074,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:08:36','',''),(2264089,'1','150','771',329,'Retail Sale Id 1326481',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:09:40','',''),(2264090,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:09:41','',''),(2264103,'1','150','771',329,'Retail Sale Id 1326488',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 17:10:51','',''),(2264104,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:10:51','',''),(2264111,'1','150','771',329,'Retail Sale Id 1326492',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 17:11:32','',''),(2264112,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 17:11:32','',''),(2264117,'1','150','771',329,'Retail Sale Id 1326496',1200.80,0.00,0.00,0.00,1200.80,'2021-12-12 17:13:08','',''),(2264118,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 17:13:08','',''),(2264138,'1','150','771',329,'Retail Sale Id 1326499',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:14:16','',''),(2264139,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:14:16','',''),(2264142,'1','150','771',329,'Retail Sale Id 1326501',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 17:14:55','',''),(2264143,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 17:14:55','',''),(2264150,'1','150','771',329,'Retail Sale Id 1326506',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 17:15:37','',''),(2264151,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 17:15:37','',''),(2264154,'1','150','771',329,'Retail Sale Id 1326508',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:16:20','',''),(2264155,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:16:20','',''),(2264170,'1','150','771',329,'Retail Sale Id 1326516',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 17:18:41','',''),(2264171,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 17:18:41','',''),(2264174,'1','150','771',329,'Retail Sale Id 1326518',1497.84,0.00,0.00,0.00,1497.84,'2021-12-12 17:19:15','',''),(2264175,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 17:19:15','',''),(2264194,'1','150','771',329,'Retail Sale Id 1326524',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 17:21:34','',''),(2264195,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:21:34','',''),(2264202,'1','150','771',329,'Retail Sale Id 1326528',701.52,0.00,0.00,0.00,701.52,'2021-12-12 17:22:50','',''),(2264203,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 17:22:50','',''),(2264216,'1','150','771',329,'Retail Sale Id 1326535',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 17:23:59','',''),(2264217,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 17:23:59','',''),(2264226,'1','150','771',329,'Retail Sale Id 1326538',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:24:38','',''),(2264227,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:24:38','',''),(2264242,'1','150','771',329,'Retail Sale Id 1326548',701.52,0.00,0.00,0.00,701.52,'2021-12-12 17:25:57','',''),(2264243,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 17:25:57','',''),(2264258,'1','150','771',329,'Retail Sale Id 1326555',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 17:27:05','',''),(2264259,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:27:05','',''),(2264270,'1','150','771',329,'Retail Sale Id 1326561',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 17:28:22','',''),(2264271,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:28:22','',''),(2264278,'1','150','771',329,'Retail Sale Id 1326565',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:29:16','',''),(2264279,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:29:16','',''),(2264282,'1','150','771',329,'Retail Sale Id 1326567',2502.72,0.00,0.00,0.00,2502.72,'2021-12-12 17:29:51','',''),(2264283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 17:29:51','',''),(2264333,'1','150','771',329,'Retail Sale Id 1326590',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 17:38:46','',''),(2264334,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:38:46','',''),(2264359,'1','150','771',329,'Retail Sale Id 1326602',2502.72,0.00,0.00,0.00,2502.72,'2021-12-12 17:41:40','',''),(2264360,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 17:41:40','',''),(2264371,'1','150','771',329,'Retail Sale Id 1326606',998.56,0.00,0.00,0.00,998.56,'2021-12-12 17:42:59','',''),(2264372,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:42:59','',''),(2264383,'1','150','771',329,'Retail Sale Id 1326613',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 17:44:47','',''),(2264384,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:44:47','',''),(2264389,'1','150','771',329,'Retail Sale Id 1326617',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 17:45:21','',''),(2264390,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 17:45:21','',''),(2264396,'1','150','771',329,'Retail Sale Id 1326619',31600.00,0.00,0.00,0.00,31600.00,'2021-12-12 17:46:07','',''),(2264397,'1','150','771',329,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 17:46:07','',''),(2264418,'1','150','771',329,'Retail Sale Id 1326628',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 17:48:07','',''),(2264419,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 17:48:07','',''),(2264436,'1','150','771',329,'Retail Sale Id 1326636',3798.32,0.00,0.00,0.00,3798.32,'2021-12-12 17:51:27','',''),(2264437,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:51:27','',''),(2264448,'1','150','771',329,'Retail Sale Id 1326642',1902.32,0.00,0.00,0.00,1902.32,'2021-12-12 17:52:51','',''),(2264449,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:52:51','',''),(2264479,'1','150','771',329,'Retail Sale Id 1326659',7900.00,0.00,0.00,0.00,7900.00,'2021-12-12 18:02:37','',''),(2264480,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 18:02:37','',''),(2264487,'1','150','771',329,'Retail Sale Id 1326663',1301.92,0.00,0.00,0.00,1301.92,'2021-12-12 18:05:17','',''),(2264488,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 18:05:17','',''),(2264495,'1','150','771',329,'Retail Sale Id 1326667',4999.12,0.00,0.00,0.00,4999.12,'2021-12-12 18:07:53','',''),(2264496,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 18:07:53','',''),(2264546,'1','150','771',329,'Retail Sale Id 1326677',3002.00,0.00,0.00,0.00,3002.00,'2021-12-12 18:14:24','',''),(2264547,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 18:14:24','',''),(2264570,'1','150','771',329,'Retail Sale Id 1326689',1997.12,0.00,0.00,0.00,1997.12,'2021-12-12 18:20:06','',''),(2264571,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 18:20:06','',''),(2264725,'1','150','771',329,'Retail Sale Id 1326736',829127.12,0.00,0.00,0.00,829127.12,'2021-12-12 19:08:15','',''),(2264726,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1311.91,0.00,'2021-12-12 19:08:15','',''),(2265260,'1','150','771',329,'Retail Sale Id 1326771',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 05:37:21','',''),(2265261,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 05:37:21','',''),(2265273,'1','150','771',329,'Retail Sale Id 1326774',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 05:48:34','',''),(2265274,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 05:48:34','',''),(2265279,'1','150','771',329,'Retail Sale Id 1326777',4999.12,0.00,0.00,0.00,4999.12,'2021-12-13 05:50:55','',''),(2265280,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 05:50:55','',''),(2265282,'1','150','771',329,'Retail Sale Id 1326778',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 05:53:15','',''),(2265283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 05:53:15','',''),(2265286,'1','150','771',329,'Retail Sale Id 1326780',2698.64,0.00,0.00,0.00,2698.64,'2021-12-13 05:55:52','',''),(2265287,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-13 05:55:52','',''),(2265291,'1','150','771',329,'Retail Sale Id 1326781',6351.60,0.00,0.00,0.00,6351.60,'2021-12-13 05:57:17','',''),(2265292,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-13 05:57:17','',''),(2265305,'1','150','771',329,'Retail Sale Id 1326784',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 05:59:43','',''),(2265306,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 05:59:43','',''),(2265311,'1','150','771',329,'Retail Sale Id 1326787',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 06:01:39','',''),(2265312,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 06:01:39','',''),(2265323,'1','150','771',329,'Retail Sale Id 1326790',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:06:03','',''),(2265324,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:06:03','',''),(2265327,'1','150','771',329,'Retail Sale Id 1326792',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:07:20','',''),(2265328,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:07:20','',''),(2265335,'1','150','771',329,'Retail Sale Id 1326796',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 06:08:59','',''),(2265336,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:08:59','',''),(2265347,'1','150','771',329,'Retail Sale Id 1326801',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:11:30','',''),(2265348,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:11:30','',''),(2265349,'1','150','771',329,'Retail Sale Id 1326802',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:12:28','',''),(2265350,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:12:28','',''),(2265359,'1','150','771',329,'Retail Sale Id 1326808',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 06:14:24','',''),(2265360,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:14:24','',''),(2265369,'1','150','771',329,'Retail Sale Id 1326811',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:15:25','',''),(2265370,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:15:25','',''),(2265379,'1','150','771',329,'Retail Sale Id 1326817',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 06:17:31','',''),(2265380,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:17:31','',''),(2265397,'1','150','771',329,'Retail Sale Id 1326825',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:19:43','',''),(2265398,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:19:43','',''),(2265413,'1','150','771',329,'Retail Sale Id 1326829',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 06:20:18','',''),(2265414,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 06:20:18','',''),(2265423,'1','150','771',329,'Retail Sale Id 1326835',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 06:21:24','',''),(2265424,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 06:21:24','',''),(2265447,'1','150','771',329,'Retail Sale Id 1326847',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:25:54','',''),(2265448,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:25:54','',''),(2265455,'1','150','771',329,'Retail Sale Id 1326851',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 06:28:09','',''),(2265456,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:28:09','',''),(2265504,'1','150','771',329,'Retail Sale Id 1326871',12640.00,0.00,0.00,0.00,12640.00,'2021-12-13 06:34:21','',''),(2265505,'1','150','771',329,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 06:34:21','',''),(2265520,'1','150','771',329,'Retail Sale Id 1326879',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 06:35:52','',''),(2265521,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:35:52','',''),(2265527,'1','150','771',329,'Retail Sale Id 1326882',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:36:23','',''),(2265528,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:36:23','',''),(2265535,'1','150','771',329,'Retail Sale Id 1326886',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 06:37:36','',''),(2265536,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:37:36','',''),(2265549,'1','150','771',329,'Retail Sale Id 1326892',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:39:01','',''),(2265550,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:39:01','',''),(2265572,'1','150','771',329,'Retail Sale Id 1326902',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:41:26','',''),(2265573,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:41:26','',''),(2265605,'1','150','771',329,'Retail Sale Id 1326913',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 06:43:17','',''),(2265606,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:43:17','',''),(2265619,'1','150','771',329,'Retail Sale Id 1326917',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:44:38','',''),(2265620,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:44:38','',''),(2265625,'1','150','771',329,'Retail Sale Id 1326920',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:45:47','',''),(2265626,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:45:47','',''),(2265637,'1','150','771',329,'Retail Sale Id 1326926',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 06:46:42','',''),(2265638,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 06:46:42','',''),(2265643,'1','150','771',329,'Retail Sale Id 1326930',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:47:31','',''),(2265644,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:47:31','',''),(2265651,'1','150','771',329,'Retail Sale Id 1326933',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 06:49:00','',''),(2265652,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 06:49:00','',''),(2265704,'1','150','771',329,'Retail Sale Id 1326959',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 06:53:45','',''),(2265705,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:53:45','',''),(2265732,'1','150','771',329,'Retail Sale Id 1326972',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 06:56:08','',''),(2265733,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:56:08','',''),(2265761,'1','150','771',329,'Retail Sale Id 1326991',998.56,0.00,0.00,0.00,998.56,'2021-12-13 06:58:57','',''),(2265762,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 06:58:57','',''),(2265791,'1','150','771',329,'Retail Sale Id 1327018',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 07:01:03','',''),(2265792,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:01:03','',''),(2265807,'1','150','771',329,'Retail Sale Id 1327025',998.56,0.00,0.00,0.00,998.56,'2021-12-13 07:01:54','',''),(2265808,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 07:01:54','',''),(2265819,'1','150','771',329,'Retail Sale Id 1327037',499.28,0.00,0.00,0.00,499.28,'2021-12-13 07:03:23','',''),(2265820,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 07:03:23','',''),(2265845,'1','150','771',329,'Retail Sale Id 1327048',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 07:04:46','',''),(2265846,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:04:46','',''),(2265879,'1','150','771',329,'Retail Sale Id 1327069',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 07:06:41','',''),(2265880,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:06:41','',''),(2265919,'1','150','771',329,'Retail Sale Id 1327088',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 07:08:41','',''),(2265920,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:08:41','',''),(2265939,'1','150','771',329,'Retail Sale Id 1327097',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 07:10:09','',''),(2265940,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:10:09','',''),(2265975,'1','150','771',329,'Retail Sale Id 1327119',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 07:12:36','',''),(2265976,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 07:12:36','',''),(2266025,'1','150','771',329,'Retail Sale Id 1327144',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 07:15:44','',''),(2266026,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 07:15:44','',''),(2266065,'1','150','771',329,'Retail Sale Id 1327166',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 07:18:54','',''),(2266066,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 07:18:54','',''),(2266083,'1','150','771',329,'Retail Sale Id 1327175',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 07:19:54','',''),(2266084,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 07:19:54','',''),(2266101,'1','150','771',329,'Retail Sale Id 1327182',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 07:20:47','',''),(2266102,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:20:47','',''),(2266125,'1','150','771',329,'Retail Sale Id 1327196',499.28,0.00,0.00,0.00,499.28,'2021-12-13 07:22:41','',''),(2266126,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 07:22:41','',''),(2266147,'1','150','771',329,'Retail Sale Id 1327209',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 07:24:17','',''),(2266148,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 07:24:17','',''),(2266179,'1','150','771',329,'Retail Sale Id 1327219',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 07:26:06','',''),(2266180,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:26:06','',''),(2266185,'1','150','771',329,'Retail Sale Id 1327223',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 07:27:00','',''),(2266186,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:27:00','',''),(2266209,'1','150','771',329,'Retail Sale Id 1327236',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 07:28:56','',''),(2266210,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 07:28:56','',''),(2266229,'1','150','771',329,'Retail Sale Id 1327243',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 07:29:38','',''),(2266230,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 07:29:38','',''),(2266246,'1','150','771',329,'Retail Sale Id 1327251',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 07:30:26','',''),(2266247,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 07:30:26','',''),(2266261,'1','150','771',329,'Retail Sale Id 1327259',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 07:31:07','',''),(2266262,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 07:31:07','',''),(2266285,'1','150','771',329,'Retail Sale Id 1327272',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 07:32:46','',''),(2266286,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 07:32:46','',''),(2266319,'1','150','771',329,'Retail Sale Id 1327288',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 07:35:09','',''),(2266320,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 07:35:09','',''),(2266335,'1','150','771',329,'Retail Sale Id 1327296',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 07:36:23','',''),(2266336,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 07:36:23','',''),(2266429,'1','150','771',329,'Retail Sale Id 1327345',14599.20,0.00,0.00,0.00,14599.20,'2021-12-13 07:42:07','',''),(2266430,'1','150','771',329,'Retail sales',0.00,0.00,0.00,23.10,0.00,'2021-12-13 07:42:07','',''),(2266476,'1','150','771',329,'Retail Sale Id 1327364',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 07:44:23','',''),(2266477,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 07:44:23','',''),(2266488,'1','150','771',329,'Retail Sale Id 1327370',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 07:45:03','',''),(2266490,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 07:45:03','',''),(2266530,'1','150','771',329,'Retail Sale Id 1327389',1801.20,0.00,0.00,0.00,1801.20,'2021-12-13 07:47:35','',''),(2266531,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-13 07:47:35','',''),(2266544,'1','150','771',329,'Retail Sale Id 1327394',998.56,0.00,0.00,0.00,998.56,'2021-12-13 07:48:16','',''),(2266545,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 07:48:16','',''),(2266560,'1','150','771',329,'Retail Sale Id 1327400',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 07:49:08','',''),(2266561,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 07:49:08','',''),(2266658,'1','150','771',329,'Retail Sale Id 1327450',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 07:55:26','',''),(2266659,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:55:26','',''),(2266706,'1','150','771',329,'Retail Sale Id 1327470',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 07:58:15','',''),(2266707,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:58:15','',''),(2266751,'1','150','771',329,'Retail Sale Id 1327491',998.56,0.00,0.00,0.00,998.56,'2021-12-13 07:59:53','',''),(2266752,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 07:59:53','',''),(2266791,'1','150','771',329,'Retail Sale Id 1327511',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 08:02:07','',''),(2266792,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 08:02:07','',''),(2266823,'1','150','771',329,'Retail Sale Id 1327519',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 08:02:51','',''),(2266824,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:02:51','',''),(2266866,'1','150','771',329,'Retail Sale Id 1327527',701.52,0.00,0.00,0.00,701.52,'2021-12-13 08:03:39','',''),(2266867,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-13 08:03:39','',''),(2266886,'1','150','771',329,'Retail Sale Id 1327536',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 08:04:48','',''),(2266887,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:04:48','',''),(2266959,'1','150','771',329,'Retail Sale Id 1327567',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 08:08:21','',''),(2266960,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 08:08:21','',''),(2266986,'1','150','771',329,'Retail Sale Id 1327575',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 08:09:13','',''),(2266987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 08:09:13','',''),(2267111,'1','150','771',329,'Retail Sale Id 1327618',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 08:13:58','',''),(2267112,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:13:58','',''),(2267226,'1','150','771',329,'Retail Sale Id 1327650',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 08:19:19','',''),(2267227,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:19:19','',''),(2267268,'1','150','771',329,'Retail Sale Id 1327671',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 08:22:05','',''),(2267269,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:22:05','',''),(2267282,'1','150','771',329,'Retail Sale Id 1327679',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 08:22:54','',''),(2267283,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 08:22:54','',''),(2267292,'1','150','771',329,'Retail Sale Id 1327684',9802.32,0.00,0.00,0.00,9802.32,'2021-12-13 08:23:51','',''),(2267293,'1','150','771',329,'Retail sales',0.00,0.00,0.00,15.51,0.00,'2021-12-13 08:23:51','',''),(2267310,'1','150','771',329,'Retail Sale Id 1327695',5997.68,0.00,0.00,0.00,5997.68,'2021-12-13 08:25:07','',''),(2267311,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-13 08:25:07','',''),(2267320,'1','150','771',329,'Retail Sale Id 1327704',499.28,0.00,0.00,0.00,499.28,'2021-12-13 08:26:04','',''),(2267321,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 08:26:04','',''),(2267336,'1','150','771',329,'Retail Sale Id 1327712',5997.68,0.00,0.00,0.00,5997.68,'2021-12-13 08:26:56','',''),(2267337,'1','150','771',329,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-13 08:26:56','',''),(2267354,'1','150','771',329,'Retail Sale Id 1327718',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 08:27:44','',''),(2267355,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 08:27:44','',''),(2267362,'1','150','771',329,'Retail Sale Id 1327723',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 08:28:29','',''),(2267363,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:28:29','',''),(2267422,'1','150','771',329,'Retail Sale Id 1327754',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 08:31:22','',''),(2267423,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 08:31:22','',''),(2267442,'1','150','771',329,'Retail Sale Id 1327766',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 08:32:07','',''),(2267443,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 08:32:07','',''),(2267468,'1','150','771',329,'Retail Sale Id 1327777',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 08:33:24','',''),(2267469,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 08:33:24','',''),(2267530,'1','150','771',329,'Retail Sale Id 1327813',3160.00,0.00,0.00,0.00,3160.00,'2021-12-13 08:36:18','',''),(2267531,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 08:36:18','',''),(2267603,'1','150','771',329,'Retail Sale Id 1327832',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 08:38:57','',''),(2267604,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:38:57','',''),(2267631,'1','150','771',329,'Retail Sale Id 1327854',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 08:40:07','',''),(2267632,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:40:07','',''),(2267655,'1','150','771',329,'Retail Sale Id 1327865',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 08:41:45','',''),(2267656,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 08:41:45','',''),(2267671,'1','150','771',329,'Retail Sale Id 1327873',998.56,0.00,0.00,0.00,998.56,'2021-12-13 08:43:28','',''),(2267672,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 08:43:28','',''),(2267742,'1','150','771',329,'Retail Sale Id 1327896',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 08:45:56','',''),(2267743,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:45:56','',''),(2267898,'1','150','771',329,'Retail Sale Id 1327945',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 08:55:04','',''),(2267899,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 08:55:04','',''),(2268065,'1','150','771',329,'Retail Sale Id 1328021',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 09:03:54','',''),(2268066,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:03:54','',''),(2268094,'1','150','771',329,'Retail Sale Id 1328034',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 09:05:37','',''),(2268095,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:05:37','',''),(2268118,'1','150','771',329,'Retail Sale Id 1328048',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 09:06:57','',''),(2268119,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:06:57','',''),(2268173,'1','150','771',329,'Retail Sale Id 1328062',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 09:09:31','',''),(2268174,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:09:31','',''),(2268244,'1','150','771',329,'Retail Sale Id 1328091',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 09:12:55','',''),(2268245,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:12:55','',''),(2268268,'1','150','771',329,'Retail Sale Id 1328105',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 09:14:52','',''),(2268269,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 09:14:52','',''),(2268278,'1','150','771',329,'Retail Sale Id 1328111',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 09:15:36','',''),(2268279,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:15:36','',''),(2268332,'1','150','771',329,'Retail Sale Id 1328134',17708.64,0.00,0.00,0.00,17708.64,'2021-12-13 09:18:27','',''),(2268333,'1','150','771',329,'Retail sales',0.00,0.00,0.00,28.02,0.00,'2021-12-13 09:18:27','',''),(2268348,'1','150','771',329,'Retail Sale Id 1328143',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 09:19:31','',''),(2268349,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 09:19:31','',''),(2268354,'1','150','771',329,'Retail Sale Id 1328146',998.56,0.00,0.00,0.00,998.56,'2021-12-13 09:20:12','',''),(2268355,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:20:12','',''),(2268366,'1','150','771',329,'Retail Sale Id 1328156',650.96,0.00,0.00,0.00,650.96,'2021-12-13 09:21:16','',''),(2268367,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-13 09:21:16','',''),(2268388,'1','150','771',329,'Retail Sale Id 1328166',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 09:22:38','',''),(2268389,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 09:22:38','',''),(2268428,'1','150','771',329,'Retail Sale Id 1328184',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 09:24:12','',''),(2268429,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:24:12','',''),(2268442,'1','150','771',329,'Retail Sale Id 1328191',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 09:25:07','',''),(2268443,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:25:07','',''),(2268456,'1','150','771',329,'Retail Sale Id 1328199',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 09:25:48','',''),(2268457,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 09:25:48','',''),(2268466,'1','150','771',329,'Retail Sale Id 1328203',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 09:26:35','',''),(2268467,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 09:26:35','',''),(2268490,'1','150','771',329,'Retail Sale Id 1328220',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 09:27:44','',''),(2268491,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:27:44','',''),(2268628,'1','150','771',329,'Retail Sale Id 1328292',998.56,0.00,0.00,0.00,998.56,'2021-12-13 09:37:54','',''),(2268629,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:37:54','',''),(2268640,'1','150','771',329,'Retail Sale Id 1328297',499.28,0.00,0.00,0.00,499.28,'2021-12-13 09:38:38','',''),(2268641,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 09:38:38','',''),(2268700,'1','150','771',329,'Retail Sale Id 1328328',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 09:43:30','',''),(2268701,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:43:30','',''),(2268755,'1','150','771',329,'Retail Sale Id 1328358',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 09:47:06','',''),(2268756,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 09:47:06','',''),(2268771,'1','150','771',329,'Retail Sale Id 1328367',998.56,0.00,0.00,0.00,998.56,'2021-12-13 09:47:52','',''),(2268772,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:47:52','',''),(2268827,'1','150','771',329,'Retail Sale Id 1328395',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 09:50:56','',''),(2268828,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:50:56','',''),(2268881,'1','150','771',329,'Retail Sale Id 1328419',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 09:54:28','',''),(2268882,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:54:28','',''),(2269031,'1','150','771',329,'Retail Sale Id 1328486',998.56,0.00,0.00,0.00,998.56,'2021-12-13 10:03:06','',''),(2269032,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:03:06','',''),(2269119,'1','150','771',329,'Retail Sale Id 1328539',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 10:09:36','',''),(2269120,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:09:36','',''),(2269155,'1','150','771',329,'Retail Sale Id 1328563',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 10:12:09','',''),(2269156,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:12:09','',''),(2269173,'1','150','771',329,'Retail Sale Id 1328575',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 10:13:21','',''),(2269174,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:13:21','',''),(2269181,'1','150','771',329,'Retail Sale Id 1328577',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 10:14:26','',''),(2269182,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 10:14:26','',''),(2269317,'1','150','771',329,'Retail Sale Id 1328651',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 10:25:24','',''),(2269318,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:25:24','',''),(2269355,'1','150','771',329,'Retail Sale Id 1328671',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 10:27:58','',''),(2269356,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 10:27:58','',''),(2269411,'1','150','771',329,'Retail Sale Id 1328697',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 10:31:08','',''),(2269412,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:31:08','',''),(2269457,'1','150','771',329,'Retail Sale Id 1328712',11799.44,0.00,0.00,0.00,11799.44,'2021-12-13 10:33:43','',''),(2269458,'1','150','771',329,'Retail sales',0.00,0.00,0.00,18.67,0.00,'2021-12-13 10:33:43','',''),(2269477,'1','150','771',329,'Retail Sale Id 1328725',998.56,0.00,0.00,0.00,998.56,'2021-12-13 10:34:54','',''),(2269478,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:34:54','',''),(2269497,'1','150','771',329,'Retail Sale Id 1328732',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 10:35:43','',''),(2269498,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:35:43','',''),(2269511,'1','150','771',329,'Retail Sale Id 1328737',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 10:36:25','',''),(2269512,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 10:36:25','',''),(2269560,'1','150','771',329,'Retail Sale Id 1328759',998.56,0.00,0.00,0.00,998.56,'2021-12-13 10:39:29','',''),(2269561,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:39:29','',''),(2269572,'1','150','771',329,'Retail Sale Id 1328766',11698.32,0.00,0.00,0.00,11698.32,'2021-12-13 10:40:20','',''),(2269573,'1','150','771',329,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-13 10:40:20','',''),(2269584,'1','150','771',329,'Retail Sale Id 1328773',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 10:41:02','',''),(2269585,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:41:02','',''),(2269606,'1','150','771',329,'Retail Sale Id 1328783',499.28,0.00,0.00,0.00,499.28,'2021-12-13 10:42:18','',''),(2269607,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 10:42:18','',''),(2269674,'1','150','771',329,'Retail Sale Id 1328808',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 10:46:13','',''),(2269675,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:46:13','',''),(2269688,'1','150','771',329,'Retail Sale Id 1328820',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 10:47:02','',''),(2269689,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 10:47:02','',''),(2269788,'1','150','771',329,'Retail Sale Id 1328877',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 10:51:56','',''),(2269789,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 10:51:56','',''),(2269886,'1','150','771',329,'Retail Sale Id 1328923',7002.56,0.00,0.00,0.00,7002.56,'2021-12-13 10:59:12','',''),(2269887,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-13 10:59:12','',''),(2269906,'1','150','771',329,'Retail Sale Id 1328933',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 10:59:47','',''),(2269907,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 10:59:47','',''),(2269937,'1','150','771',329,'Retail Sale Id 1328939',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 11:00:41','',''),(2269938,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 11:00:41','',''),(2269953,'1','150','771',329,'Retail Sale Id 1328946',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 11:01:37','',''),(2269954,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 11:01:37','',''),(2269979,'1','150','771',329,'Retail Sale Id 1328964',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 11:04:08','',''),(2269980,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 11:04:08','',''),(2269993,'1','150','771',329,'Retail Sale Id 1328970',499.28,0.00,0.00,0.00,499.28,'2021-12-13 11:05:18','',''),(2269994,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 11:05:18','',''),(2270092,'1','150','771',329,'Retail Sale Id 1329015',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 11:13:11','',''),(2270093,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:13:11','',''),(2270141,'1','150','771',329,'Retail Sale Id 1329042',3950.00,0.00,0.00,0.00,3950.00,'2021-12-13 11:16:52','',''),(2270142,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 11:16:52','',''),(2270185,'1','150','771',329,'Retail Sale Id 1329065',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 11:19:12','',''),(2270186,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:19:12','',''),(2270207,'1','150','771',329,'Retail Sale Id 1329076',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 11:20:49','',''),(2270208,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 11:20:49','',''),(2270266,'1','150','771',329,'Retail Sale Id 1329103',650.96,0.00,0.00,0.00,650.96,'2021-12-13 11:26:13','',''),(2270267,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-13 11:26:13','',''),(2270294,'1','150','771',329,'Retail Sale Id 1329110',2546.96,0.00,0.00,0.00,2546.96,'2021-12-13 11:27:43','',''),(2270295,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 11:27:43','',''),(2270320,'1','150','771',329,'Retail Sale Id 1329122',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 11:29:50','',''),(2270321,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 11:29:50','',''),(2270342,'1','150','771',329,'Retail Sale Id 1329132',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 11:31:17','',''),(2270343,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:31:17','',''),(2270370,'1','150','771',329,'Retail Sale Id 1329147',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 11:33:29','',''),(2270371,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 11:33:29','',''),(2270380,'1','150','771',329,'Retail Sale Id 1329152',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 11:34:44','',''),(2270381,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:34:44','',''),(2270412,'1','150','771',329,'Retail Sale Id 1329167',15800.00,0.00,0.00,0.00,15800.00,'2021-12-13 11:37:24','',''),(2270413,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 11:37:24','',''),(2270427,'1','150','771',329,'Retail Sale Id 1329172',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 11:38:29','',''),(2270428,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:38:29','',''),(2270451,'1','150','771',329,'Retail Sale Id 1329180',11097.92,0.00,0.00,0.00,11097.92,'2021-12-13 11:39:55','',''),(2270452,'1','150','771',329,'Retail sales',0.00,0.00,0.00,17.56,0.00,'2021-12-13 11:39:55','',''),(2270461,'1','150','771',329,'Retail Sale Id 1329192',4999.12,0.00,0.00,0.00,4999.12,'2021-12-13 11:40:41','',''),(2270462,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 11:40:41','',''),(2270477,'1','150','771',329,'Retail Sale Id 1329200',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 11:41:42','',''),(2270478,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 11:41:42','',''),(2270530,'1','150','771',329,'Retail Sale Id 1329229',998.56,0.00,0.00,0.00,998.56,'2021-12-13 11:47:18','',''),(2270531,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 11:47:18','',''),(2270562,'1','150','771',329,'Retail Sale Id 1329245',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 11:50:02','',''),(2270563,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 11:50:02','',''),(2270584,'1','150','771',329,'Retail Sale Id 1329257',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 11:51:57','',''),(2270585,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 11:51:57','',''),(2270663,'1','150','771',329,'Retail Sale Id 1329295',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 12:00:44','',''),(2270664,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:00:44','',''),(2270695,'1','150','771',329,'Retail Sale Id 1329313',998.56,0.00,0.00,0.00,998.56,'2021-12-13 12:03:03','',''),(2270696,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:03:03','',''),(2270713,'1','150','771',329,'Retail Sale Id 1329322',6351.60,0.00,0.00,0.00,6351.60,'2021-12-13 12:04:22','',''),(2270714,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-13 12:04:22','',''),(2270909,'1','150','771',329,'Retail Sale Id 1329431',2597.52,0.00,0.00,0.00,2597.52,'2021-12-13 12:19:52','',''),(2270910,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-13 12:19:52','',''),(2270935,'1','150','771',329,'Retail Sale Id 1329445',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 12:20:53','',''),(2270936,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:20:53','',''),(2270955,'1','150','771',329,'Retail Sale Id 1329456',15800.00,0.00,0.00,0.00,15800.00,'2021-12-13 12:22:57','',''),(2270956,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 12:22:57','',''),(2270988,'1','150','771',329,'Retail Sale Id 1329474',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 12:26:05','',''),(2270989,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 12:26:05','',''),(2271004,'1','150','771',329,'Retail Sale Id 1329482',998.56,0.00,0.00,0.00,998.56,'2021-12-13 12:27:00','',''),(2271005,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:27:00','',''),(2271016,'1','150','771',329,'Retail Sale Id 1329489',998.56,0.00,0.00,0.00,998.56,'2021-12-13 12:28:12','',''),(2271017,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:28:12','',''),(2271048,'1','150','771',329,'Retail Sale Id 1329512',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 12:30:44','',''),(2271049,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 12:30:44','',''),(2271058,'1','150','771',329,'Retail Sale Id 1329518',3899.44,0.00,0.00,0.00,3899.44,'2021-12-13 12:31:45','',''),(2271059,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-13 12:31:45','',''),(2271106,'1','150','771',329,'Retail Sale Id 1329548',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 12:35:03','',''),(2271107,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 12:35:03','',''),(2271186,'1','150','771',329,'Retail Sale Id 1329595',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 12:40:57','',''),(2271187,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:40:57','',''),(2271235,'1','150','771',329,'Retail Sale Id 1329617',3501.28,0.00,0.00,0.00,3501.28,'2021-12-13 12:43:58','',''),(2271236,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-13 12:43:58','',''),(2271267,'1','150','771',329,'Retail Sale Id 1329636',2546.96,0.00,0.00,0.00,2546.96,'2021-12-13 12:45:52','',''),(2271268,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 12:45:52','',''),(2271354,'1','150','771',329,'Retail Sale Id 1329675',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 12:52:08','',''),(2271355,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 12:52:08','',''),(2271380,'1','150','771',329,'Retail Sale Id 1329691',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 12:53:15','',''),(2271381,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:53:15','',''),(2271421,'1','150','771',329,'Retail Sale Id 1329708',499.28,0.00,0.00,0.00,499.28,'2021-12-13 12:55:17','',''),(2271422,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 12:55:17','',''),(2271437,'1','150','771',329,'Retail Sale Id 1329716',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 12:56:26','',''),(2271438,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 12:56:26','',''),(2271471,'1','150','771',329,'Retail Sale Id 1329737',4999.12,0.00,0.00,0.00,4999.12,'2021-12-13 12:58:26','',''),(2271472,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 12:58:26','',''),(2271493,'1','150','771',329,'Retail Sale Id 1329746',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 12:59:22','',''),(2271494,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 12:59:22','',''),(2271561,'1','150','771',329,'Retail Sale Id 1329775',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 13:02:55','',''),(2271562,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:02:55','',''),(2271611,'1','150','771',329,'Retail Sale Id 1329798',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 13:06:30','',''),(2271612,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:06:30','',''),(2271639,'1','150','771',329,'Retail Sale Id 1329811',2401.60,0.00,0.00,0.00,2401.60,'2021-12-13 13:08:33','',''),(2271640,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-13 13:08:33','',''),(2271667,'1','150','771',329,'Retail Sale Id 1329826',1403.04,0.00,0.00,0.00,1403.04,'2021-12-13 13:10:14','',''),(2271668,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-13 13:10:14','',''),(2271675,'1','150','771',329,'Retail Sale Id 1329829',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 13:11:12','',''),(2271676,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 13:11:12','',''),(2271693,'1','150','771',329,'Retail Sale Id 1329840',1200.80,0.00,0.00,0.00,1200.80,'2021-12-13 13:13:11','',''),(2271694,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-13 13:13:11','',''),(2271705,'1','150','771',329,'Retail Sale Id 1329847',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 13:13:47','',''),(2271706,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:13:47','',''),(2271717,'1','150','771',329,'Retail Sale Id 1329853',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 13:14:33','',''),(2271718,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 13:14:33','',''),(2271731,'1','150','771',329,'Retail Sale Id 1329861',998.56,0.00,0.00,0.00,998.56,'2021-12-13 13:15:26','',''),(2271732,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:15:26','',''),(2271768,'1','150','771',329,'Retail Sale Id 1329876',701.52,0.00,0.00,0.00,701.52,'2021-12-13 13:16:33','',''),(2271769,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-13 13:16:33','',''),(2271820,'1','150','771',329,'Retail Sale Id 1329896',4999.12,0.00,0.00,0.00,4999.12,'2021-12-13 13:18:57','',''),(2271821,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 13:18:57','',''),(2271834,'1','150','771',329,'Retail Sale Id 1329905',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 13:20:50','',''),(2271835,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:20:50','',''),(2271840,'1','150','771',329,'Retail Sale Id 1329908',897.44,0.00,0.00,0.00,897.44,'2021-12-13 13:21:24','',''),(2271841,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-13 13:21:24','',''),(2271937,'1','150','771',329,'Retail Sale Id 1329932',7002.56,0.00,0.00,0.00,7002.56,'2021-12-13 13:24:42','',''),(2271938,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-13 13:24:42','',''),(2271978,'1','150','771',329,'Retail Sale Id 1329943',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 13:26:10','',''),(2271979,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:26:10','',''),(2272018,'1','150','771',329,'Retail Sale Id 1329966',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 13:28:51','',''),(2272019,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:28:51','',''),(2272089,'1','150','771',329,'Retail Sale Id 1329998',998.56,0.00,0.00,0.00,998.56,'2021-12-13 13:33:35','',''),(2272090,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:33:35','',''),(2272204,'1','150','771',329,'Retail Sale Id 1330039',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 13:39:58','',''),(2272205,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:39:58','',''),(2272210,'1','150','771',329,'Retail Sale Id 1330042',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 13:40:26','',''),(2272211,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 13:40:26','',''),(2272228,'1','150','771',329,'Retail Sale Id 1330050',998.56,0.00,0.00,0.00,998.56,'2021-12-13 13:41:23','',''),(2272229,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:41:23','',''),(2272268,'1','150','771',329,'Retail Sale Id 1330069',2546.96,0.00,0.00,0.00,2546.96,'2021-12-13 13:44:28','',''),(2272269,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 13:44:28','',''),(2272311,'1','150','771',329,'Retail Sale Id 1330093',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 13:47:25','',''),(2272312,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:47:25','',''),(2272335,'1','150','771',329,'Retail Sale Id 1330097',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 13:48:00','',''),(2272336,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 13:48:00','',''),(2272378,'1','150','771',329,'Retail Sale Id 1330108',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 13:49:53','',''),(2272379,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 13:49:53','',''),(2272396,'1','150','771',329,'Retail Sale Id 1330116',3501.28,0.00,0.00,0.00,3501.28,'2021-12-13 13:50:48','',''),(2272397,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-13 13:50:48','',''),(2272410,'1','150','771',329,'Retail Sale Id 1330126',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 13:51:29','',''),(2272411,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:51:29','',''),(2272452,'1','150','771',329,'Retail Sale Id 1330145',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 13:53:58','',''),(2272453,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 13:53:58','',''),(2272539,'1','150','771',329,'Retail Sale Id 1330179',998.56,0.00,0.00,0.00,998.56,'2021-12-13 13:57:19','',''),(2272540,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:57:19','',''),(2272586,'1','150','771',329,'Retail Sale Id 1330200',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:00:16','',''),(2272587,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:00:16','',''),(2272592,'1','150','771',329,'Retail Sale Id 1330207',802.64,0.00,0.00,0.00,802.64,'2021-12-13 14:00:56','',''),(2272593,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 14:00:56','',''),(2272614,'1','150','771',329,'Retail Sale Id 1330216',998.56,0.00,0.00,0.00,998.56,'2021-12-13 14:02:16','',''),(2272615,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 14:02:16','',''),(2272624,'1','150','771',329,'Retail Sale Id 1330222',1200.80,0.00,0.00,0.00,1200.80,'2021-12-13 14:02:43','',''),(2272625,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-13 14:02:43','',''),(2272630,'1','150','771',329,'Retail Sale Id 1330226',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 14:03:27','',''),(2272631,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 14:03:27','',''),(2272648,'1','150','771',329,'Retail Sale Id 1330230',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 14:04:13','',''),(2272649,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 14:04:13','',''),(2272656,'1','150','771',329,'Retail Sale Id 1330237',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 14:04:50','',''),(2272657,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 14:04:50','',''),(2272664,'1','150','771',329,'Retail Sale Id 1330240',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 14:05:41','',''),(2272665,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:05:41','',''),(2272704,'1','150','771',329,'Retail Sale Id 1330255',998.56,0.00,0.00,0.00,998.56,'2021-12-13 14:08:30','',''),(2272705,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 14:08:30','',''),(2272744,'1','150','771',329,'Retail Sale Id 1330275',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 14:11:05','',''),(2272745,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:11:05','',''),(2272770,'1','150','771',329,'Retail Sale Id 1330293',998.56,0.00,0.00,0.00,998.56,'2021-12-13 14:12:20','',''),(2272771,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 14:12:20','',''),(2272794,'1','150','771',329,'Retail Sale Id 1330373',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 14:14:31','',''),(2272795,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:14:31','',''),(2272826,'1','150','771',329,'Retail Sale Id 1330397',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 14:15:26','',''),(2272827,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:15:26','',''),(2272845,'1','150','771',329,'Retail Sale Id 1330404',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:16:23','',''),(2272846,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:16:23','',''),(2272859,'1','150','771',329,'Retail Sale Id 1330412',2546.96,0.00,0.00,0.00,2546.96,'2021-12-13 14:17:05','',''),(2272860,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 14:17:05','',''),(2272867,'1','150','771',329,'Retail Sale Id 1330414',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 14:17:39','',''),(2272868,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 14:17:39','',''),(2272928,'1','150','771',329,'Retail Sale Id 1330434',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 14:21:22','',''),(2272929,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 14:21:22','',''),(2272958,'1','150','771',329,'Retail Sale Id 1330443',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:22:48','',''),(2272959,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:22:48','',''),(2272980,'1','150','771',329,'Retail Sale Id 1330458',4999.12,0.00,0.00,0.00,4999.12,'2021-12-13 14:24:09','',''),(2272981,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 14:24:09','',''),(2272986,'1','150','771',329,'Retail Sale Id 1330462',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 14:24:47','',''),(2272987,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 14:24:47','',''),(2272998,'1','150','771',329,'Retail Sale Id 1330467',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 14:25:41','',''),(2272999,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:25:41','',''),(2273002,'1','150','771',329,'Retail Sale Id 1330470',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:26:16','',''),(2273003,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:26:16','',''),(2273010,'1','150','771',329,'Retail Sale Id 1330473',998.56,0.00,0.00,0.00,998.56,'2021-12-13 14:26:59','',''),(2273011,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 14:26:59','',''),(2273040,'1','150','771',329,'Retail Sale Id 1330491',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 14:28:33','',''),(2273041,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:28:33','',''),(2273060,'1','150','771',329,'Retail Sale Id 1330500',1099.68,0.00,0.00,0.00,1099.68,'2021-12-13 14:29:23','',''),(2273061,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.74,0.00,'2021-12-13 14:29:23','',''),(2273066,'1','150','771',329,'Retail Sale Id 1330504',499.28,0.00,0.00,0.00,499.28,'2021-12-13 14:30:00','',''),(2273067,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 14:30:00','',''),(2273076,'1','150','771',329,'Retail Sale Id 1330508',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 14:30:31','',''),(2273077,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:30:31','',''),(2273082,'1','150','771',329,'Retail Sale Id 1330511',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 14:31:06','',''),(2273083,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 14:31:06','',''),(2273086,'1','150','771',329,'Retail Sale Id 1330515',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 14:31:45','',''),(2273087,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:31:45','',''),(2273124,'1','150','771',329,'Retail Sale Id 1330527',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:33:28','',''),(2273125,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:33:28','',''),(2273166,'1','150','771',329,'Retail Sale Id 1330540',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 14:34:34','',''),(2273167,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:34:34','',''),(2273199,'1','150','771',329,'Retail Sale Id 1330551',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 14:36:25','',''),(2273200,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:36:25','',''),(2273227,'1','150','771',329,'Retail Sale Id 1330568',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 14:37:54','',''),(2273228,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 14:37:54','',''),(2273263,'1','150','771',329,'Retail Sale Id 1330585',6351.60,0.00,0.00,0.00,6351.60,'2021-12-13 14:39:58','',''),(2273264,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-13 14:39:58','',''),(2273277,'1','150','771',329,'Retail Sale Id 1330590',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 14:40:55','',''),(2273278,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:40:55','',''),(2273308,'1','150','771',329,'Retail Sale Id 1330600',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 14:42:03','',''),(2273309,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:42:03','',''),(2273334,'1','150','771',329,'Retail Sale Id 1330614',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 14:44:14','',''),(2273335,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 14:44:14','',''),(2273354,'1','150','771',329,'Retail Sale Id 1330628',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 14:45:27','',''),(2273355,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 14:45:27','',''),(2273437,'1','150','771',329,'Retail Sale Id 1330672',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:52:17','',''),(2273438,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:52:17','',''),(2273461,'1','150','771',329,'Retail Sale Id 1330684',2546.96,0.00,0.00,0.00,2546.96,'2021-12-13 14:53:36','',''),(2273462,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 14:53:36','',''),(2273473,'1','150','771',329,'Retail Sale Id 1330691',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 14:54:13','',''),(2273474,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 14:54:13','',''),(2273489,'1','150','771',329,'Retail Sale Id 1330697',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 14:55:13','',''),(2273490,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:55:13','',''),(2273511,'1','150','771',329,'Retail Sale Id 1330708',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 14:57:10','',''),(2273512,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:57:10','',''),(2273527,'1','150','771',329,'Retail Sale Id 1330715',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 14:58:17','',''),(2273528,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:58:17','',''),(2273623,'1','150','771',329,'Retail Sale Id 1330775',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 15:06:02','',''),(2273624,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 15:06:02','',''),(2273643,'1','150','771',329,'Retail Sale Id 1330787',998.56,0.00,0.00,0.00,998.56,'2021-12-13 15:07:12','',''),(2273644,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:07:12','',''),(2273663,'1','150','771',329,'Retail Sale Id 1330798',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 15:08:11','',''),(2273664,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:08:11','',''),(2273845,'1','150','771',329,'Retail Sale Id 1330880',802.64,0.00,0.00,0.00,802.64,'2021-12-13 15:18:58','',''),(2273846,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 15:18:58','',''),(2273859,'1','150','771',329,'Retail Sale Id 1330885',998.56,0.00,0.00,0.00,998.56,'2021-12-13 15:19:46','',''),(2273860,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:19:46','',''),(2273893,'1','150','771',329,'Retail Sale Id 1330899',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 15:21:11','',''),(2273894,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:21:11','',''),(2273938,'1','150','771',329,'Retail Sale Id 1330925',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 15:23:23','',''),(2273939,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:23:23','',''),(2274013,'1','150','771',329,'Retail Sale Id 1330954',3501.28,0.00,0.00,0.00,3501.28,'2021-12-13 15:26:24','',''),(2274014,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-13 15:26:24','',''),(2274053,'1','150','771',329,'Retail Sale Id 1330968',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 15:27:38','',''),(2274054,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 15:27:38','',''),(2274091,'1','150','771',329,'Retail Sale Id 1330980',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 15:28:53','',''),(2274092,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 15:28:53','',''),(2274111,'1','150','771',329,'Retail Sale Id 1330990',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 15:29:57','',''),(2274112,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:29:57','',''),(2274133,'1','150','771',329,'Retail Sale Id 1330999',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 15:30:57','',''),(2274134,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 15:30:57','',''),(2274226,'1','150','771',329,'Retail Sale Id 1331039',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 15:34:32','',''),(2274227,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:34:32','',''),(2274279,'1','150','771',329,'Retail Sale Id 1331055',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 15:36:56','',''),(2274280,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 15:36:56','',''),(2274299,'1','150','771',329,'Retail Sale Id 1331069',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 15:37:31','',''),(2274300,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:37:31','',''),(2274323,'1','150','771',329,'Retail Sale Id 1331080',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 15:38:42','',''),(2274324,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:38:42','',''),(2274399,'1','150','771',329,'Retail Sale Id 1331121',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 15:41:49','',''),(2274400,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:41:49','',''),(2274435,'1','150','771',329,'Retail Sale Id 1331138',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 15:43:33','',''),(2274436,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 15:43:34','',''),(2274445,'1','150','771',329,'Retail Sale Id 1331145',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 15:44:01','',''),(2274446,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 15:44:01','',''),(2274461,'1','150','771',329,'Retail Sale Id 1331153',998.56,0.00,0.00,0.00,998.56,'2021-12-13 15:44:43','',''),(2274462,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:44:43','',''),(2274479,'1','150','771',329,'Retail Sale Id 1331161',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 15:45:31','',''),(2274480,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:45:31','',''),(2274493,'1','150','771',329,'Retail Sale Id 1331168',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 15:46:10','',''),(2274494,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 15:46:10','',''),(2274509,'1','150','771',329,'Retail Sale Id 1331173',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 15:47:09','',''),(2274510,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 15:47:09','',''),(2274527,'1','150','771',329,'Retail Sale Id 1331188',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 15:48:00','',''),(2274528,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 15:48:00','',''),(2274533,'1','150','771',329,'Retail Sale Id 1331193',998.56,0.00,0.00,0.00,998.56,'2021-12-13 15:48:36','',''),(2274534,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:48:36','',''),(2274551,'1','150','771',329,'Retail Sale Id 1331200',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 15:49:33','',''),(2274552,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 15:49:33','',''),(2274573,'1','150','771',329,'Retail Sale Id 1331210',3160.00,0.00,0.00,0.00,3160.00,'2021-12-13 15:50:43','',''),(2274574,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:50:43','',''),(2274589,'1','150','771',329,'Retail Sale Id 1331221',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 15:51:16','',''),(2274590,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 15:51:16','',''),(2274603,'1','150','771',329,'Retail Sale Id 1331231',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 15:52:09','',''),(2274604,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 15:52:09','',''),(2274629,'1','150','771',329,'Retail Sale Id 1331244',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 15:54:08','',''),(2274630,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 15:54:08','',''),(2274657,'1','150','771',329,'Retail Sale Id 1331258',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 15:55:18','',''),(2274658,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:55:18','',''),(2274681,'1','150','771',329,'Retail Sale Id 1331269',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 15:56:42','',''),(2274682,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 15:56:42','',''),(2274694,'1','150','771',329,'Retail Sale Id 1331278',4000.56,0.00,0.00,0.00,4000.56,'2021-12-13 15:57:14','',''),(2274695,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 15:57:14','',''),(2274708,'1','150','771',329,'Retail Sale Id 1331285',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 15:58:13','',''),(2274709,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:58:13','',''),(2274727,'1','150','771',329,'Retail Sale Id 1331294',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 15:59:20','',''),(2274728,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 15:59:20','',''),(2274748,'1','150','771',329,'Retail Sale Id 1331305',998.56,0.00,0.00,0.00,998.56,'2021-12-13 16:00:27','',''),(2274749,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:00:27','',''),(2274760,'1','150','771',329,'Retail Sale Id 1331313',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 16:01:28','',''),(2274761,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 16:01:28','',''),(2274779,'1','150','771',329,'Retail Sale Id 1331324',998.56,0.00,0.00,0.00,998.56,'2021-12-13 16:02:19','',''),(2274780,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:02:19','',''),(2274843,'1','150','771',329,'Retail Sale Id 1331352',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 16:05:34','',''),(2274844,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 16:05:34','',''),(2274889,'1','150','771',329,'Retail Sale Id 1331376',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 16:08:26','',''),(2274890,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:08:26','',''),(2274911,'1','150','771',329,'Retail Sale Id 1331388',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 16:09:44','',''),(2274912,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 16:09:44','',''),(2274929,'1','150','771',329,'Retail Sale Id 1331396',6351.60,0.00,0.00,0.00,6351.60,'2021-12-13 16:10:30','',''),(2274930,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-13 16:10:30','',''),(2274955,'1','150','771',329,'Retail Sale Id 1331409',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 16:11:58','',''),(2274956,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 16:11:58','',''),(2274972,'1','150','771',329,'Retail Sale Id 1331417',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 16:12:41','',''),(2274973,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 16:12:41','',''),(2275034,'1','150','771',329,'Retail Sale Id 1331449',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 16:15:41','',''),(2275035,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 16:15:41','',''),(2275046,'1','150','771',329,'Retail Sale Id 1331454',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 16:16:19','',''),(2275047,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:16:19','',''),(2275062,'1','150','771',329,'Retail Sale Id 1331464',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 16:17:12','',''),(2275063,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:17:12','',''),(2275085,'1','150','771',329,'Retail Sale Id 1331473',1497.84,0.00,0.00,0.00,1497.84,'2021-12-13 16:18:33','',''),(2275086,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 16:18:33','',''),(2275103,'1','150','771',329,'Retail Sale Id 1331481',1997.12,0.00,0.00,0.00,1997.12,'2021-12-13 16:19:22','',''),(2275104,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 16:19:22','',''),(2275115,'1','150','771',329,'Retail Sale Id 1331491',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 16:20:05','',''),(2275116,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:20:05','',''),(2275137,'1','150','771',329,'Retail Sale Id 1331498',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 16:20:49','',''),(2275138,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 16:20:49','',''),(2275153,'1','150','771',329,'Retail Sale Id 1331505',3197.92,0.00,0.00,0.00,3197.92,'2021-12-13 16:21:24','',''),(2275154,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 16:21:24','',''),(2275161,'1','150','771',329,'Retail Sale Id 1331510',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 16:21:58','',''),(2275162,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 16:21:58','',''),(2275206,'1','150','771',329,'Retail Sale Id 1331534',998.56,0.00,0.00,0.00,998.56,'2021-12-13 16:24:20','',''),(2275207,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:24:20','',''),(2275220,'1','150','771',329,'Retail Sale Id 1331542',802.64,0.00,0.00,0.00,802.64,'2021-12-13 16:25:05','',''),(2275221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 16:25:05','',''),(2275231,'1','150','771',329,'Retail Sale Id 1331548',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 16:25:51','',''),(2275232,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 16:25:51','',''),(2275257,'1','150','771',329,'Retail Sale Id 1331559',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 16:27:02','',''),(2275258,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:27:02','',''),(2275293,'1','150','771',329,'Retail Sale Id 1331578',7900.00,0.00,0.00,0.00,7900.00,'2021-12-13 16:29:03','',''),(2275294,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:29:03','',''),(2275364,'1','150','771',329,'Retail Sale Id 1331612',3002.00,0.00,0.00,0.00,3002.00,'2021-12-13 16:33:19','',''),(2275365,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 16:33:19','',''),(2275403,'1','150','771',329,'Retail Sale Id 1331634',998.56,0.00,0.00,0.00,998.56,'2021-12-13 16:35:21','',''),(2275404,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:35:21','',''),(2275437,'1','150','771',329,'Retail Sale Id 1331653',3798.32,0.00,0.00,0.00,3798.32,'2021-12-13 16:37:24','',''),(2275438,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:37:24','',''),(2275451,'1','150','771',329,'Retail Sale Id 1331661',998.56,0.00,0.00,0.00,998.56,'2021-12-13 16:38:04','',''),(2275452,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:38:04','',''),(2275458,'1','150','771',329,'Retail Sale Id 1331663',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 16:38:39','',''),(2275459,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:38:39','',''),(2275468,'1','150','771',329,'Retail Sale Id 1331670',1902.32,0.00,0.00,0.00,1902.32,'2021-12-13 16:39:34','',''),(2275469,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:39:34','',''),(2275524,'1','150','771',329,'Retail Sale Id 1331700',2502.72,0.00,0.00,0.00,2502.72,'2021-12-13 16:42:47','',''),(2275525,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 16:42:47','',''),(2275717,'1','150','771',329,'Retail Sale Id 1331798',1301.92,0.00,0.00,0.00,1301.92,'2021-12-13 16:55:50','',''),(2275718,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 16:55:50','',''),(2276456,'1','150',NULL,329,'Reception corrector for bridging 127277',0.00,0.00,0.00,2393.55,0.00,'2021-12-13 18:55:44','',''),(2276457,'1','150','771',329,'Received from bridging 127277',0.00,0.00,2393.55,0.00,0.00,'2021-12-13 18:55:44','',''),(2276460,'1','150','771',329,'Retail Sale Id 1332083',303044.00,0.00,0.00,0.00,303044.00,'2021-12-13 19:02:14','',''),(2276461,'1','150','771',329,'Retail sales',0.00,0.00,0.00,479.50,0.00,'2021-12-13 19:02:14','',''),(2276930,'1','150','771',329,'Retail Sale Id 1332120',1902.32,0.00,0.00,0.00,1902.32,'2021-12-14 06:02:22','',''),(2276931,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-14 06:02:22','',''),(2276938,'1','150','771',329,'Retail Sale Id 1332124',1997.12,0.00,0.00,0.00,1997.12,'2021-12-14 06:04:01','',''),(2276939,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 06:04:01','',''),(2276977,'1','150','771',329,'Retail Sale Id 1332136',30001.04,0.00,0.00,0.00,30001.04,'2021-12-14 06:08:14','',''),(2276978,'1','150','771',329,'Retail sales',0.00,0.00,0.00,47.47,0.00,'2021-12-14 06:08:14','',''),(2276987,'1','150','771',329,'Retail Sale Id 1332140',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:08:53','',''),(2276988,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:08:53','',''),(2277007,'1','150','771',329,'Retail Sale Id 1332149',1997.12,0.00,0.00,0.00,1997.12,'2021-12-14 06:11:20','',''),(2277008,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 06:11:20','',''),(2277019,'1','150','771',329,'Retail Sale Id 1332155',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:12:28','',''),(2277020,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:12:28','',''),(2277025,'1','150','771',329,'Retail Sale Id 1332158',998.56,0.00,0.00,0.00,998.56,'2021-12-14 06:13:41','',''),(2277026,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 06:13:41','',''),(2277041,'1','150','771',329,'Retail Sale Id 1332165',7602.96,0.00,0.00,0.00,7602.96,'2021-12-14 06:16:02','',''),(2277042,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.03,0.00,'2021-12-14 06:16:03','',''),(2277081,'1','150','771',329,'Retail Sale Id 1332184',3197.92,0.00,0.00,0.00,3197.92,'2021-12-14 06:18:54','',''),(2277082,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-14 06:18:54','',''),(2277102,'1','150','771',329,'Retail Sale Id 1332193',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:20:52','',''),(2277103,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:20:52','',''),(2277114,'1','150','771',329,'Retail Sale Id 1332198',1997.12,0.00,0.00,0.00,1997.12,'2021-12-14 06:21:55','',''),(2277115,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 06:21:55','',''),(2277149,'1','150','771',329,'Retail Sale Id 1332208',3798.32,0.00,0.00,0.00,3798.32,'2021-12-14 06:24:09','',''),(2277150,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 06:24:09','',''),(2277194,'1','150','771',329,'Retail Sale Id 1332218',1497.84,0.00,0.00,0.00,1497.84,'2021-12-14 06:26:27','',''),(2277195,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-14 06:26:27','',''),(2277204,'1','150','771',329,'Retail Sale Id 1332222',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:27:35','',''),(2277205,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:27:35','',''),(2277222,'1','150','771',329,'Retail Sale Id 1332227',4000.56,0.00,0.00,0.00,4000.56,'2021-12-14 06:28:22','',''),(2277223,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-14 06:28:22','',''),(2277238,'1','150','771',329,'Retail Sale Id 1332236',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:30:02','',''),(2277239,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:30:02','',''),(2277272,'1','150','771',329,'Retail Sale Id 1332243',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:32:22','',''),(2277273,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:32:22','',''),(2277308,'1','150','771',329,'Retail Sale Id 1332248',3798.32,0.00,0.00,0.00,3798.32,'2021-12-14 06:33:08','',''),(2277309,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 06:33:08','',''),(2277341,'1','150','771',329,'Retail Sale Id 1332254',998.56,0.00,0.00,0.00,998.56,'2021-12-14 06:34:42','',''),(2277342,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 06:34:42','',''),(2277371,'1','150','771',329,'Retail Sale Id 1332262',1598.96,0.00,0.00,0.00,1598.96,'2021-12-14 06:36:37','',''),(2277372,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-14 06:36:37','',''),(2277377,'1','150','771',329,'Retail Sale Id 1332268',1997.12,0.00,0.00,0.00,1997.12,'2021-12-14 06:37:30','',''),(2277378,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 06:37:30','',''),(2277410,'1','150','771',329,'Retail Sale Id 1332276',3197.92,0.00,0.00,0.00,3197.92,'2021-12-14 06:39:22','',''),(2277411,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-14 06:39:22','',''),(2277444,'1','150','771',329,'Retail Sale Id 1332287',1497.84,0.00,0.00,0.00,1497.84,'2021-12-14 06:40:33','',''),(2277445,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-14 06:40:33','',''),(2277465,'1','150','771',329,'Retail Sale Id 1332311',9802.32,0.00,0.00,0.00,9802.32,'2021-12-14 06:42:00','',''),(2277466,'1','150','771',329,'Retail sales',0.00,0.00,0.00,15.51,0.00,'2021-12-14 06:42:00','',''),(2277475,'1','150','771',329,'Retail Sale Id 1332316',3798.32,0.00,0.00,0.00,3798.32,'2021-12-14 06:42:55','',''),(2277476,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 06:42:55','',''),(2277531,'1','150','771',329,'Retail Sale Id 1332326',1997.12,0.00,0.00,0.00,1997.12,'2021-12-14 06:45:33','',''),(2277532,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 06:45:33','',''),(2277547,'1','150','771',329,'Retail Sale Id 1332347',1902.32,0.00,0.00,0.00,1902.32,'2021-12-14 06:46:50','',''),(2277548,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-14 06:46:50','',''),(2277579,'1','150','771',329,'Retail Sale Id 1332369',7900.00,0.00,0.00,0.00,7900.00,'2021-12-14 06:48:43','',''),(2277580,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 06:48:43','',''),(2277585,'1','150','771',329,'Retail Sale Id 1332385',998.56,0.00,0.00,0.00,998.56,'2021-12-14 06:49:37','',''),(2277586,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 06:49:37','',''),(2277601,'1','150','771',329,'Retail Sale Id 1332393',1497.84,0.00,0.00,0.00,1497.84,'2021-12-14 06:50:18','',''),(2277602,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-14 06:50:18','',''),(2277619,'1','150','771',329,'Retail Sale Id 1332399',897.44,0.00,0.00,0.00,897.44,'2021-12-14 06:51:08','',''),(2277620,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-14 06:51:08','',''),(2277688,'1','150','771',329,'Retail Sale Id 1332424',3798.32,0.00,0.00,0.00,3798.32,'2021-12-14 06:55:15','',''),(2277689,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 06:55:15','',''),(2277696,'1','150','771',329,'Retail Sale Id 1332427',650.96,0.00,0.00,0.00,650.96,'2021-12-14 06:56:05','',''),(2277697,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-14 06:56:05','',''),(2277704,'1','150','771',329,'Retail Sale Id 1332432',897.44,0.00,0.00,0.00,897.44,'2021-12-14 06:56:49','',''),(2277705,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-14 06:56:49','',''),(2277774,'1','150','771',329,'Retail Sale Id 1332467',39898.16,0.00,0.00,0.00,39898.16,'2021-12-14 07:02:46','',''),(2277775,'1','150','771',329,'Retail sales',0.00,0.00,0.00,63.13,0.00,'2021-12-14 07:02:46','',''),(2277814,'1','150','771',329,'Retail Sale Id 1332482',7002.56,0.00,0.00,0.00,7002.56,'2021-12-14 07:05:43','',''),(2277815,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-14 07:05:43','',''),(2278071,'1','150','771',329,'Retail Sale Id 1332628',0.00,0.00,0.00,0.00,0.00,'2021-12-14 07:22:50','',''),(2278072,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-14 07:22:50','',''),(2278226,'1','150','771',329,'Return of Retail Sale Id 1332467',0.00,39898.16,63.13,0.00,-39898.16,'2021-12-14 07:31:54','',''),(2278339,'1','150','771',329,'Retail Sale Id 1332752',195.92,0.00,0.00,0.00,195.92,'2021-12-14 07:38:14','',''),(2278340,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.31,0.00,'2021-12-14 07:38:14','',''),(2280484,'1','150','771',329,'Retail Sale Id 1333896',3800.72,0.00,0.00,0.00,3800.72,'2021-12-14 09:27:24','',''),(2280485,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-14 09:27:24','',''),(2280488,'1','150','771',329,'Retail Sale Id 1333898',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 09:27:53','',''),(2280489,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:27:53','',''),(2280500,'1','150','771',329,'Retail Sale Id 1333904',5001.92,0.00,0.00,0.00,5001.92,'2021-12-14 09:28:34','',''),(2280501,'1','150','771',329,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-14 09:28:34','',''),(2280910,'1','150','771',329,'Retail Sale Id 1334111',2999.92,0.00,0.00,0.00,2999.92,'2021-12-14 09:53:09','',''),(2280911,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 09:53:09','',''),(2280931,'1','150','771',329,'Retail Sale Id 1334126',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 09:54:27','',''),(2280932,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:54:27','',''),(2280943,'1','150','771',329,'Retail Sale Id 1334132',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 09:55:30','',''),(2280944,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:55:30','',''),(2280953,'1','150','771',329,'Retail Sale Id 1334142',3997.84,0.00,0.00,0.00,3997.84,'2021-12-14 09:56:01','',''),(2280954,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-14 09:56:01','',''),(2280973,'1','150','771',329,'Retail Sale Id 1334150',15597.12,0.00,0.00,0.00,15597.12,'2021-12-14 09:57:20','',''),(2280974,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.32,0.00,'2021-12-14 09:57:20','',''),(2280981,'1','150','771',329,'Retail Sale Id 1334157',3080.00,0.00,0.00,0.00,3080.00,'2021-12-14 09:57:44','',''),(2280982,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 09:57:44','',''),(2280995,'1','150','771',329,'Retail Sale Id 1334164',6997.76,0.00,0.00,0.00,6997.76,'2021-12-14 09:58:17','',''),(2280996,'1','150','771',329,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-14 09:58:17','',''),(2281001,'1','150','771',329,'Retail Sale Id 1334168',1503.04,0.00,0.00,0.00,1503.04,'2021-12-14 09:58:55','',''),(2281002,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 09:58:55','',''),(2281011,'1','150','771',329,'Retail Sale Id 1334171',4502.96,0.00,0.00,0.00,4502.96,'2021-12-14 09:59:26','',''),(2281012,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.31,0.00,'2021-12-14 09:59:26','',''),(2281177,'1','150','771',329,'Retail Sale Id 1334261',997.92,0.00,0.00,0.00,997.92,'2021-12-14 10:09:34','',''),(2281178,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 10:09:34','',''),(2281186,'1','150','771',329,'Retail Sale Id 1334264',498.96,0.00,0.00,0.00,498.96,'2021-12-14 10:09:58','',''),(2281187,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.81,0.00,'2021-12-14 10:09:58','',''),(2281198,'1','150','771',329,'Retail Sale Id 1334268',1798.72,0.00,0.00,0.00,1798.72,'2021-12-14 10:10:25','',''),(2281199,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-14 10:10:25','',''),(2281222,'1','150','771',329,'Retail Sale Id 1334278',3800.72,0.00,0.00,0.00,3800.72,'2021-12-14 10:11:16','',''),(2281223,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-14 10:11:16','',''),(2281416,'1','150','771',329,'Retail Sale Id 1334326',23198.56,0.00,0.00,0.00,23198.56,'2021-12-14 10:19:37','',''),(2281417,'1','150','771',329,'Retail sales',0.00,0.00,0.00,37.66,0.00,'2021-12-14 10:19:37','',''),(2281622,'1','150','771',329,'Retail Sale Id 1334523',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 10:30:53','',''),(2281623,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 10:30:53','',''),(2281634,'1','150','771',329,'Retail Sale Id 1334529',15400.00,0.00,0.00,0.00,15400.00,'2021-12-14 10:31:36','',''),(2281635,'1','150','771',329,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 10:31:36','',''),(2281800,'1','150','771',329,'Retail Sale Id 1334619',3997.84,0.00,0.00,0.00,3997.84,'2021-12-14 10:40:37','',''),(2281801,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-14 10:40:37','',''),(2281810,'1','150','771',329,'Retail Sale Id 1334625',800.80,0.00,0.00,0.00,800.80,'2021-12-14 10:41:02','',''),(2281811,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.30,0.00,'2021-12-14 10:41:02','',''),(2281824,'1','150','771',329,'Retail Sale Id 1334630',1299.76,0.00,0.00,0.00,1299.76,'2021-12-14 10:41:29','',''),(2281825,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-14 10:41:29','',''),(2281846,'1','150','771',329,'Retail Sale Id 1334640',3696.00,0.00,0.00,0.00,3696.00,'2021-12-14 10:42:52','',''),(2281847,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:42:52','',''),(2281870,'1','150','771',329,'Retail Sale Id 1334654',3080.00,0.00,0.00,0.00,3080.00,'2021-12-14 10:43:51','',''),(2281871,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:43:51','',''),(2281880,'1','150','771',329,'Retail Sale Id 1334661',3098.48,0.00,0.00,0.00,3098.48,'2021-12-14 10:44:16','',''),(2281881,'1','150','771',329,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-14 10:44:16','',''),(2282086,'1','150','771',329,'Retail Sale Id 1334776',1798.72,0.00,0.00,0.00,1798.72,'2021-12-14 10:57:13','',''),(2282087,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-14 10:57:13','',''),(2282092,'1','150','771',329,'Retail Sale Id 1334781',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 10:57:50','',''),(2282093,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:57:50','',''),(2282102,'1','150','771',329,'Retail Sale Id 1334786',3702.16,0.00,0.00,0.00,3702.16,'2021-12-14 10:58:16','',''),(2282103,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 10:58:16','',''),(2282121,'1','150','771',329,'Retail Sale Id 1334798',4700.08,0.00,0.00,0.00,4700.08,'2021-12-14 11:00:02','',''),(2282122,'1','150','771',329,'Retail sales',0.00,0.00,0.00,7.63,0.00,'2021-12-14 11:00:02','',''),(2282125,'1','150','771',329,'Retail Sale Id 1334799',6160.00,0.00,0.00,0.00,6160.00,'2021-12-14 11:00:27','',''),(2282126,'1','150','771',329,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-14 11:00:27','',''),(2282149,'1','150','771',329,'Retail Sale Id 1334807',2500.96,0.00,0.00,0.00,2500.96,'2021-12-14 11:01:56','',''),(2282150,'1','150','771',329,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 11:01:56','',''),(2282163,'1','150','771',329,'Retail Sale Id 1334815',1201.20,0.00,0.00,0.00,1201.20,'2021-12-14 11:03:07','',''),(2282164,'1','150','771',329,'Retail sales',0.00,0.00,0.00,1.95,0.00,'2021-12-14 11:03:07','',''),(2282174,'1','150','771',329,'Retail Sale Id 1334819',3997.84,0.00,0.00,0.00,3997.84,'2021-12-14 11:03:32','',''),(2282175,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-14 11:03:32','',''),(2282196,'1','150','771',329,'Retail Sale Id 1334823',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 11:04:00','',''),(2282197,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:04:00','',''),(2282216,'1','150','771',329,'Retail Sale Id 1334836',1897.28,0.00,0.00,0.00,1897.28,'2021-12-14 11:04:52','',''),(2282217,'1','150','771',329,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 11:04:52','',''),(2282220,'1','150','771',329,'Retail Sale Id 1334839',498.96,0.00,0.00,0.00,498.96,'2021-12-14 11:05:21','',''),(2282221,'1','150','771',329,'Retail sales',0.00,0.00,0.00,0.81,0.00,'2021-12-14 11:05:21','',''),(2282226,'1','150','771',329,'Retail Sale Id 1334842',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 11:05:50','',''),(2282227,'1','150','771',329,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:05:50','',''),(2282255,'1','150','771',329,'Retail Sale Id 1334861',17999.52,0.00,0.00,0.00,17999.52,'2021-12-14 11:07:49','',''),(2282256,'1','150','771',329,'Retail sales',0.00,0.00,0.00,29.22,0.00,'2021-12-14 11:07:49','',''),(2282257,'1','150','771',329,'Retail Sale Id 1334862',3899.28,0.00,0.00,0.00,3899.28,'2021-12-14 11:08:12','',''),(2282258,'1','150','771',329,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-14 11:08:12','',''),(2282263,'1','150','771',329,'Retail Sale Id 1334867',1398.32,0.00,0.00,0.00,1398.32,'2021-12-14 11:08:33','',''),(2282264,'1','150','771',329,'Retail sales',0.00,0.00,0.00,2.27,0.00,'2021-12-14 11:08:33','',''),(2282544,'1','150','771',329,'Retail Sale Id 1335408',167207.04,0.00,0.00,271.44,167207.04,'2021-12-14 12:36:11','',''),(2283400,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,3013920.00,5460.00,0.00,0.00,'2021-12-14 14:13:35','',''),(2283407,'1','150',NULL,329,'Reception corrector for bridging 127360',0.00,0.00,0.00,5460.00,0.00,'2021-12-14 14:14:28','',''),(2283408,'1','150','771',329,'Received from bridging 127360',0.00,0.00,5460.00,0.00,0.00,'2021-12-14 14:14:28','',''),(2283416,'1','150','771',329,'Retail Sale Id 1336078',50000.72,0.00,0.00,81.17,5194.88,'2021-12-14 14:15:29','',''),(2283420,'1','150','771',329,'Retail Sale Id 1336086',30800.00,0.00,0.00,50.00,3200.00,'2021-12-14 14:15:52','',''),(2283630,'1','150','771',329,'Retail Sale Id 1336238',7700.00,0.00,0.00,12.50,800.00,'2021-12-14 14:37:43','',''),(2283635,'1','150','771',329,'Retail Sale Id 1336242',6160.00,0.00,0.00,10.00,640.00,'2021-12-14 14:38:14','',''),(2283637,'1','150','771',329,'Retail Sale Id 1336245',3080.00,0.00,0.00,5.00,320.00,'2021-12-14 14:38:40','',''),(2283907,'1','150','771',329,'Retail Sale Id 1336469',3850.00,0.00,0.00,6.25,400.00,'2021-12-14 15:16:57','',''),(2283914,'1','150','771',329,'Retail Sale Id 1336476',1897.28,0.00,0.00,3.08,197.12,'2021-12-14 15:17:53','',''),(2283916,'1','150','771',329,'Retail Sale Id 1336478',3498.88,0.00,0.00,5.68,363.52,'2021-12-14 15:18:19','',''),(2285073,'1','150','771',329,'Retail Sale Id 1337360',7700.00,0.00,0.00,12.50,800.00,'2021-12-14 17:05:10','',''),(2285078,'1','150','771',329,'Retail Sale Id 1337364',7700.00,0.00,0.00,12.50,800.00,'2021-12-14 17:05:31','',''),(2285082,'1','150','771',329,'Retail Sale Id 1337367',6160.00,0.00,0.00,10.00,640.00,'2021-12-14 17:05:52','',''),(2285085,'1','150','771',329,'Retail Sale Id 1337368',9240.00,0.00,0.00,15.00,960.00,'2021-12-14 17:06:20','',''),(2285087,'1','150','771',329,'Retail Sale Id 1337371',12320.00,0.00,0.00,20.00,1280.00,'2021-12-14 17:06:50','',''),(2285090,'1','150','771',329,'Retail Sale Id 1337373',3080.00,0.00,0.00,5.00,320.00,'2021-12-14 17:07:12','',''),(2285095,'1','150','771',329,'Retail Sale Id 1337377',2002.00,0.00,0.00,3.25,208.00,'2021-12-14 17:07:50','',''),(2285097,'1','150','771',329,'Retail Sale Id 1337383',2999.92,0.00,0.00,4.87,311.68,'2021-12-14 17:08:11','',''),(2285101,'1','150','771',329,'Retail Sale Id 1337387',3997.84,0.00,0.00,6.49,415.36,'2021-12-14 17:08:30','',''),(2285104,'1','150','771',329,'Retail Sale Id 1337389',5001.92,0.00,0.00,8.12,519.68,'2021-12-14 17:08:54','',''),(2285107,'1','150','771',329,'Retail Sale Id 1337392',5999.84,0.00,0.00,9.74,623.36,'2021-12-14 17:09:21','',''),(2285113,'1','150','771',329,'Retail Sale Id 1337397',6997.76,0.00,0.00,11.36,727.04,'2021-12-14 17:09:39','',''),(2285115,'1','150','771',329,'Retail Sale Id 1337399',8001.84,0.00,0.00,12.99,831.36,'2021-12-14 17:10:18','',''),(2285134,'1','150','771',329,'Retail Sale Id 1337412',8999.76,0.00,0.00,14.61,935.04,'2021-12-14 17:13:47','',''),(2285135,'1','150','771',329,'Retail Sale Id 1337413',9997.68,0.00,0.00,16.23,1038.72,'2021-12-14 17:14:09','',''),(2285144,'1','150','771',329,'Retail Sale Id 1337422',11999.68,0.00,0.00,19.48,1246.72,'2021-12-14 17:16:29','',''),(2285154,'1','150','771',329,'Retail Sale Id 1337431',30800.00,0.00,0.00,50.00,3200.00,'2021-12-14 17:17:46','',''),(2285157,'1','150','771',329,'Retail Sale Id 1337435',5500.88,0.00,0.00,8.93,571.52,'2021-12-14 17:18:11','',''),(2285176,'1','150','771',329,'Retail Sale Id 1337443',1503.04,0.00,0.00,2.44,156.16,'2021-12-14 17:19:24','',''),(2285177,'1','150','771',329,'Retail Sale Id 1337446',7700.00,0.00,0.00,12.50,800.00,'2021-12-14 17:19:52','',''),(2285362,'1','150','771',329,'Retail Sale Id 1337603',456104.88,0.00,0.00,740.43,47387.52,'2021-12-14 19:10:50','',''),(2285766,'1','150','771',329,'Retail Sale Id 1337652',1700.16,0.00,0.00,2.76,176.64,'2021-12-15 05:43:45','',''),(2285794,'1','150','771',329,'Retail Sale Id 1337669',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 05:57:59','',''),(2285797,'1','150','771',329,'Retail Sale Id 1337672',3702.16,0.00,0.00,6.01,384.64,'2021-12-15 05:58:29','',''),(2285798,'1','150','771',329,'Retail Sale Id 1337673',997.92,0.00,0.00,1.62,103.68,'2021-12-15 05:58:52','',''),(2285799,'1','150','771',329,'Retail Sale Id 1337674',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 05:59:19','',''),(2285816,'1','150','771',329,'Retail Sale Id 1337675',15400.00,0.00,0.00,25.00,1600.00,'2021-12-15 06:00:23','',''),(2285817,'1','150','771',329,'Retail Sale Id 1337677',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 06:00:55','',''),(2285819,'1','150','771',329,'Retail Sale Id 1337679',1798.72,0.00,0.00,2.92,186.88,'2021-12-15 06:01:25','',''),(2285823,'1','150','771',329,'Retail Sale Id 1337683',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 06:02:35','',''),(2285824,'1','150','771',329,'Retail Sale Id 1337684',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 06:03:06','',''),(2285826,'1','150','771',329,'Retail Sale Id 1337686',800.80,0.00,0.00,1.30,83.20,'2021-12-15 06:03:58','',''),(2285829,'1','150','771',329,'Retail Sale Id 1337689',1398.32,0.00,0.00,2.27,145.28,'2021-12-15 06:04:30','',''),(2285834,'1','150','771',329,'Retail Sale Id 1337694',6997.76,0.00,0.00,11.36,727.04,'2021-12-15 06:05:00','',''),(2285838,'1','150','771',329,'Retail Sale Id 1337696',899.36,0.00,0.00,1.46,93.44,'2021-12-15 06:05:32','',''),(2285841,'1','150','771',329,'Retail Sale Id 1337699',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 06:06:26','',''),(2285844,'1','150','771',329,'Retail Sale Id 1337702',997.92,0.00,0.00,1.62,103.68,'2021-12-15 06:06:59','',''),(2286105,'1','150','771',329,'Retail Sale Id 1337802',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 06:33:56','',''),(2286117,'1','150','771',329,'Retail Sale Id 1337807',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 06:34:38','',''),(2286125,'1','150','771',329,'Retail Sale Id 1337814',1299.76,0.00,0.00,2.11,135.04,'2021-12-15 06:36:27','',''),(2286131,'1','150','771',329,'Retail Sale Id 1337820',0.00,0.00,0.00,0.00,0.00,'2021-12-15 06:37:05','',''),(2286185,'1','150','771',329,'Retail Sale Id 1337852',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 06:42:17','',''),(2286189,'1','150','771',329,'Retail Sale Id 1337855',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 06:42:50','',''),(2286192,'1','150','771',329,'Retail Sale Id 1337859',1299.76,0.00,0.00,2.11,135.04,'2021-12-15 06:43:24','',''),(2286196,'1','150','771',329,'Retail Sale Id 1337865',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 06:44:03','',''),(2286201,'1','150','771',329,'Retail Sale Id 1337871',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 06:44:34','',''),(2286380,'1','150','771',329,'Retail Sale Id 1338024',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 07:05:55','',''),(2286386,'1','150','771',329,'Retail Sale Id 1338030',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 07:06:22','',''),(2286389,'1','150','771',329,'Retail Sale Id 1338033',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 07:06:56','',''),(2286392,'1','150','771',329,'Retail Sale Id 1338040',3098.48,0.00,0.00,5.03,321.92,'2021-12-15 07:07:22','',''),(2286397,'1','150','771',329,'Retail Sale Id 1338050',4700.08,0.00,0.00,7.63,488.32,'2021-12-15 07:07:49','',''),(2286440,'1','150','771',329,'Retail Sale Id 1338103',2550.24,0.00,0.00,4.14,264.96,'2021-12-15 07:15:02','',''),(2286447,'1','150','771',329,'Retail Sale Id 1338111',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 07:15:34','',''),(2286455,'1','150','771',329,'Retail Sale Id 1338117',3098.48,0.00,0.00,5.03,321.92,'2021-12-15 07:16:40','',''),(2286474,'1','150','771',329,'Retail Sale Id 1338143',2297.68,0.00,0.00,3.73,238.72,'2021-12-15 07:19:16','',''),(2286482,'1','150','771',329,'Retail Sale Id 1338150',6997.76,0.00,0.00,11.36,727.04,'2021-12-15 07:19:55','',''),(2286565,'1','150','771',329,'Retail Sale Id 1338219',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 07:29:30','',''),(2286614,'1','150','771',329,'Retail Sale Id 1338263',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 07:34:28','',''),(2286816,'1','150','771',329,'Retail Sale Id 1338410',15400.00,0.00,0.00,25.00,1600.00,'2021-12-15 07:51:18','',''),(2286892,'1','150','771',329,'Retail Sale Id 1338480',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 08:00:44','',''),(2286913,'1','150','771',329,'Retail Sale Id 1338484',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 08:01:58','',''),(2287033,'1','150','771',329,'Retail Sale Id 1338563',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 08:11:28','',''),(2287048,'1','150','771',329,'Retail Sale Id 1338574',2500.96,0.00,0.00,4.06,259.84,'2021-12-15 08:12:08','',''),(2287050,'1','150','771',329,'Retail Sale Id 1338576',2999.92,0.00,0.00,4.87,311.68,'2021-12-15 08:12:35','',''),(2287053,'1','150','771',329,'Retail Sale Id 1338578',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 08:13:01','',''),(2287058,'1','150','771',329,'Retail Sale Id 1338584',2999.92,0.00,0.00,4.87,311.68,'2021-12-15 08:13:39','',''),(2287067,'1','150','771',329,'Retail Sale Id 1338590',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 08:14:11','',''),(2287075,'1','150','771',329,'Retail Sale Id 1338598',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 08:14:48','',''),(2287085,'1','150','771',329,'Retail Sale Id 1338612',1201.20,0.00,0.00,1.95,124.80,'2021-12-15 08:16:35','',''),(2287091,'1','150','771',329,'Retail Sale Id 1338616',899.36,0.00,0.00,1.46,93.44,'2021-12-15 08:17:19','',''),(2287423,'1','150','771',329,'Retail Sale Id 1338888',2999.92,0.00,0.00,4.87,311.68,'2021-12-15 08:51:41','',''),(2287497,'1','150','771',329,'Retail Sale Id 1338960',997.92,0.00,0.00,1.62,103.68,'2021-12-15 09:02:02','',''),(2287501,'1','150','771',329,'Retail Sale Id 1338980',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 09:03:02','',''),(2287513,'1','150','771',329,'Retail Sale Id 1338985',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 09:04:16','',''),(2287544,'1','150','771',329,'Retail Sale Id 1339008',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 09:07:46','',''),(2287710,'1','150','771',329,'Retail Sale Id 1339124',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 09:23:29','',''),(2287716,'1','150','771',329,'Retail Sale Id 1339132',6997.76,0.00,0.00,11.36,727.04,'2021-12-15 09:23:58','',''),(2287720,'1','150','771',329,'Retail Sale Id 1339135',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 09:24:28','',''),(2287736,'1','150','771',329,'Retail Sale Id 1339150',5999.84,0.00,0.00,9.74,623.36,'2021-12-15 09:26:05','',''),(2287746,'1','150','771',329,'Retail Sale Id 1339163',4700.08,0.00,0.00,7.63,488.32,'2021-12-15 09:27:26','',''),(2287806,'1','150','771',329,'Retail Sale Id 1339213',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 09:34:39','',''),(2287815,'1','150','771',329,'Retail Sale Id 1339218',15400.00,0.00,0.00,25.00,1600.00,'2021-12-15 09:35:47','',''),(2287829,'1','150','771',329,'Retail Sale Id 1339230',3702.16,0.00,0.00,6.01,384.64,'2021-12-15 09:36:16','',''),(2287835,'1','150','771',329,'Retail Sale Id 1339234',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 09:36:51','',''),(2287839,'1','150','771',329,'Retail Sale Id 1339241',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 09:37:27','',''),(2287843,'1','150','771',329,'Retail Sale Id 1339243',3098.48,0.00,0.00,5.03,321.92,'2021-12-15 09:38:06','',''),(2287847,'1','150','771',329,'Retail Sale Id 1339252',997.92,0.00,0.00,1.62,103.68,'2021-12-15 09:38:44','',''),(2287848,'1','150','771',329,'Retail Sale Id 1339253',2500.96,0.00,0.00,4.06,259.84,'2021-12-15 09:39:10','',''),(2287853,'1','150','771',329,'Retail Sale Id 1339258',498.96,0.00,0.00,0.81,51.84,'2021-12-15 09:39:41','',''),(2287917,'1','150','771',329,'Retail Sale Id 1339306',7502.88,0.00,0.00,12.18,779.52,'2021-12-15 09:46:58','',''),(2287920,'1','150','771',329,'Retail Sale Id 1339309',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 09:47:35','',''),(2287931,'1','150','771',329,'Retail Sale Id 1339321',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 09:48:37','',''),(2287964,'1','150','771',329,'Retail Sale Id 1339328',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 09:53:34','',''),(2287967,'1','150','771',329,'Retail Sale Id 1339356',2999.92,0.00,0.00,4.87,311.68,'2021-12-15 09:54:06','',''),(2287970,'1','150','771',329,'Retail Sale Id 1339362',30800.00,0.00,0.00,50.00,3200.00,'2021-12-15 09:54:43','',''),(2287988,'1','150','771',329,'Retail Sale Id 1339366',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 09:55:27','',''),(2288016,'1','150','771',329,'Retail Sale Id 1339383',3702.16,0.00,0.00,6.01,384.64,'2021-12-15 09:57:57','',''),(2288055,'1','150','771',329,'Retail Sale Id 1339387',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 10:04:25','',''),(2288060,'1','150','771',329,'Retail Sale Id 1339426',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 10:05:05','',''),(2288079,'1','150','771',329,'Retail Sale Id 1339445',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 10:07:57','',''),(2288102,'1','150','771',329,'Retail Sale Id 1339452',2999.92,0.00,0.00,4.87,311.68,'2021-12-15 10:08:38','',''),(2288108,'1','150','771',329,'Retail Sale Id 1339461',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 10:09:46','',''),(2288143,'1','150','771',329,'Retail Sale Id 1339490',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 10:15:43','',''),(2288275,'1','150','771',329,'Retail Sale Id 1339611',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 10:35:24','',''),(2288477,'1','150','771',329,'Retail Sale Id 1339768',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 10:58:32','',''),(2288668,'1','150','771',329,'Retail Sale Id 1339946',9997.68,0.00,0.00,16.23,1038.72,'2021-12-15 11:20:25','',''),(2288793,'1','150','771',329,'Retail Sale Id 1340015',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 11:33:44','',''),(2288799,'1','150','771',329,'Retail Sale Id 1340050',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 11:34:16','',''),(2288805,'1','150','771',329,'Retail Sale Id 1340057',6997.76,0.00,0.00,11.36,727.04,'2021-12-15 11:34:59','',''),(2288814,'1','150','771',329,'Retail Sale Id 1340067',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 11:36:48','',''),(2288818,'1','150','771',329,'Retail Sale Id 1340071',2500.96,0.00,0.00,4.06,259.84,'2021-12-15 11:37:17','',''),(2288825,'1','150','771',329,'Retail Sale Id 1340074',3098.48,0.00,0.00,5.03,321.92,'2021-12-15 11:37:47','',''),(2288860,'1','150','771',329,'Retail Sale Id 1340112',2002.00,0.00,0.00,3.25,208.00,'2021-12-15 11:43:13','',''),(2288864,'1','150','771',329,'Retail Sale Id 1340119',5001.92,0.00,0.00,8.12,519.68,'2021-12-15 11:44:10','',''),(2288869,'1','150','771',329,'Retail Sale Id 1340125',3997.84,0.00,0.00,6.49,415.36,'2021-12-15 11:45:08','',''),(2288872,'1','150','771',329,'Retail Sale Id 1340129',3702.16,0.00,0.00,6.01,384.64,'2021-12-15 11:45:41','',''),(2288875,'1','150','771',329,'Retail Sale Id 1340132',1798.72,0.00,0.00,2.92,186.88,'2021-12-15 11:46:15','',''),(2288881,'1','150','771',329,'Retail Sale Id 1340137',1503.04,0.00,0.00,2.44,156.16,'2021-12-15 11:47:01','',''),(2288883,'1','150','771',329,'Retail Sale Id 1340139',4502.96,0.00,0.00,7.31,467.84,'2021-12-15 11:47:33','',''),(2288901,'1','150','771',329,'Retail Sale Id 1340153',498.96,0.00,0.00,0.81,51.84,'2021-12-15 11:48:55','',''),(2288915,'1','150','771',329,'Retail Sale Id 1340168',3800.72,0.00,0.00,6.17,394.88,'2021-12-15 11:50:13','',''),(2288934,'1','150','771',329,'Retail Sale Id 1340186',15400.00,0.00,0.00,25.00,1600.00,'2021-12-15 11:52:23','',''),(2289245,'1','150','771',329,'Retail Sale Id 1340500',12320.00,0.00,0.00,20.00,1280.00,'2021-12-15 12:38:02','',''),(2289254,'1','150','771',329,'Retail Sale Id 1340514',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 12:39:03','',''),(2289669,'1','150','771',329,'Retail Sale Id 1340842',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 13:32:12','',''),(2289675,'1','150','771',329,'Retail Sale Id 1340849',9240.00,0.00,0.00,15.00,960.00,'2021-12-15 13:33:22','',''),(2289681,'1','150','771',329,'Retail Sale Id 1340854',3080.00,0.00,0.00,5.00,320.00,'2021-12-15 13:33:55','',''),(2290486,'1','150','771',329,'Retail Sale Id 1341411',30800.00,0.00,0.00,50.00,3200.00,'2021-12-15 14:47:34','',''),(2291702,'1','150','771',329,'Retail Sale Id 1342385',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 16:29:16','',''),(2291715,'1','150','771',329,'Retail Sale Id 1342396',15400.00,0.00,0.00,25.00,1600.00,'2021-12-15 16:30:34','',''),(2291748,'1','150','771',329,'Retail Sale Id 1342430',3080.00,0.00,0.00,5.00,320.00,'2021-12-15 16:33:33','',''),(2291756,'1','150','771',329,'Retail Sale Id 1342439',6160.00,0.00,0.00,10.00,640.00,'2021-12-15 16:33:56','',''),(2292060,'1','150','771',329,'Retail Sale Id 1342678',29999.20,0.00,0.00,48.70,3116.80,'2021-12-15 17:01:24','',''),(2292074,'1','150','771',329,'Retail Sale Id 1342717',7700.00,0.00,0.00,12.50,800.00,'2021-12-15 17:03:27','',''),(2292116,'1','150','771',329,'Retail Sale Id 1342747',3850.00,0.00,0.00,6.25,400.00,'2021-12-15 17:07:17','',''),(2292191,'1','150','771',329,'Retail Sale Id 1342808',9997.68,0.00,0.00,16.23,1038.72,'2021-12-15 17:15:49','',''),(2292564,'1','150','771',329,'Retail Sale Id 1343087',758351.44,0.00,0.00,1231.09,78789.76,'2021-12-15 18:20:28','',''),(2292949,'1','150','771',329,'Retail Sale Id 1343191',0.00,0.00,0.00,0.00,0.00,'2021-12-16 05:40:52','',''),(2293053,'1','150','771',329,'Retail Sale Id 1343274',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 06:17:40','',''),(2293072,'1','150','771',329,'Retail Sale Id 1343277',3702.16,0.00,0.00,6.01,384.64,'2021-12-16 06:18:12','',''),(2293083,'1','150','771',329,'Retail Sale Id 1343280',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 06:19:17','',''),(2293084,'1','150','771',329,'Retail Sale Id 1343287',1299.76,0.00,0.00,2.11,135.04,'2021-12-16 06:19:45','',''),(2293089,'1','150','771',329,'Retail Sale Id 1343290',6997.76,0.00,0.00,11.36,727.04,'2021-12-16 06:20:18','',''),(2293098,'1','150','771',329,'Retail Sale Id 1343293',5001.92,0.00,0.00,8.12,519.68,'2021-12-16 06:21:07','',''),(2293106,'1','150','771',329,'Retail Sale Id 1343296',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 06:21:41','',''),(2293272,'1','150','771',329,'Retail Sale Id 1343424',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 06:42:11','',''),(2293278,'1','150','771',329,'Retail Sale Id 1343431',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 06:42:35','',''),(2293281,'1','150','771',329,'Retail Sale Id 1343434',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 06:43:00','',''),(2293285,'1','150','771',329,'Retail Sale Id 1343438',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 06:43:25','',''),(2293291,'1','150','771',329,'Retail Sale Id 1343445',15400.00,0.00,0.00,25.00,1600.00,'2021-12-16 06:43:49','',''),(2293296,'1','150','771',329,'Retail Sale Id 1343451',2297.68,0.00,0.00,3.73,238.72,'2021-12-16 06:44:17','',''),(2293543,'1','150','771',329,'Retail Sale Id 1343630',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 07:03:52','',''),(2293551,'1','150','771',329,'Retail Sale Id 1343637',5001.92,0.00,0.00,8.12,519.68,'2021-12-16 07:04:46','',''),(2293556,'1','150','771',329,'Retail Sale Id 1343644',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 07:05:11','',''),(2293559,'1','150','771',329,'Retail Sale Id 1343647',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 07:05:40','',''),(2293566,'1','150','771',329,'Retail Sale Id 1343655',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 07:06:06','',''),(2293569,'1','150','771',329,'Retail Sale Id 1343657',899.36,0.00,0.00,1.46,93.44,'2021-12-16 07:06:30','',''),(2293573,'1','150','771',329,'Retail Sale Id 1343661',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 07:07:03','',''),(2293591,'1','150','771',329,'Retail Sale Id 1343679',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 07:09:05','',''),(2293599,'1','150','771',329,'Retail Sale Id 1343687',4502.96,0.00,0.00,7.31,467.84,'2021-12-16 07:09:59','',''),(2293654,'1','150','771',329,'Retail Sale Id 1343738',652.96,0.00,0.00,1.06,67.84,'2021-12-16 07:16:02','',''),(2293659,'1','150','771',329,'Retail Sale Id 1343742',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 07:16:32','',''),(2293936,'1','150','771',329,'Retail Sale Id 1343746',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 07:38:46','',''),(2293940,'1','150','771',329,'Retail Sale Id 1343943',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 07:39:16','',''),(2293955,'1','150','771',329,'Retail Sale Id 1343958',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 07:40:44','',''),(2293973,'1','150','771',329,'Retail Sale Id 1343965',997.92,0.00,0.00,1.62,103.68,'2021-12-16 07:41:39','',''),(2293996,'1','150','771',329,'Retail Sale Id 1343978',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 07:42:06','',''),(2294000,'1','150','771',329,'Retail Sale Id 1343980',1398.32,0.00,0.00,2.27,145.28,'2021-12-16 07:42:47','',''),(2294028,'1','150','771',329,'Retail Sale Id 1343993',2500.96,0.00,0.00,4.06,259.84,'2021-12-16 07:43:36','',''),(2294046,'1','150','771',329,'Retail Sale Id 1344000',1299.76,0.00,0.00,2.11,135.04,'2021-12-16 07:44:17','',''),(2295549,'1','150','771',329,'Retail Sale Id 1345135',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 09:44:30','',''),(2295553,'1','150','771',329,'Retail Sale Id 1345141',1798.72,0.00,0.00,2.92,186.88,'2021-12-16 09:45:01','',''),(2295557,'1','150','771',329,'Retail Sale Id 1345142',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 09:45:41','',''),(2295604,'1','150','771',329,'Retail Sale Id 1345177',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 09:49:56','',''),(2295609,'1','150','771',329,'Retail Sale Id 1345190',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 09:50:24','',''),(2295614,'1','150','771',329,'Retail Sale Id 1345196',3498.88,0.00,0.00,5.68,363.52,'2021-12-16 09:51:00','',''),(2295620,'1','150','771',329,'Retail Sale Id 1345202',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 09:51:42','',''),(2295666,'1','150','771',329,'Retail Sale Id 1345229',61600.00,0.00,0.00,100.00,6400.00,'2021-12-16 09:54:13','',''),(2295838,'1','150','771',329,'Retail Sale Id 1345316',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:06:27','',''),(2295847,'1','150','771',329,'Retail Sale Id 1345324',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 10:07:09','',''),(2295855,'1','150','771',329,'Retail Sale Id 1345329',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 10:08:09','',''),(2295862,'1','150','771',329,'Retail Sale Id 1345335',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:08:45','',''),(2295867,'1','150','771',329,'Retail Sale Id 1345340',2500.96,0.00,0.00,4.06,259.84,'2021-12-16 10:09:17','',''),(2295875,'1','150','771',329,'Retail Sale Id 1345348',1398.32,0.00,0.00,2.27,145.28,'2021-12-16 10:09:55','',''),(2296004,'1','150','771',329,'Retail Sale Id 1345484',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:24:03','',''),(2296007,'1','150','771',329,'Retail Sale Id 1345487',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 10:24:38','',''),(2296014,'1','150','771',329,'Retail Sale Id 1345493',3498.88,0.00,0.00,5.68,363.52,'2021-12-16 10:25:25','',''),(2296017,'1','150','771',329,'Retail Sale Id 1345496',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 10:25:55','',''),(2296021,'1','150','771',329,'Retail Sale Id 1345500',5802.72,0.00,0.00,9.42,602.88,'2021-12-16 10:26:31','',''),(2296026,'1','150','771',329,'Retail Sale Id 1345505',5901.28,0.00,0.00,9.58,613.12,'2021-12-16 10:27:11','',''),(2296032,'1','150','771',329,'Retail Sale Id 1345509',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:27:47','',''),(2296123,'1','150','771',329,'Retail Sale Id 1345520',3702.16,0.00,0.00,6.01,384.64,'2021-12-16 10:39:56','',''),(2296149,'1','150','771',329,'Retail Sale Id 1345603',6997.76,0.00,0.00,11.36,727.04,'2021-12-16 10:43:04','',''),(2296163,'1','150','771',329,'Retail Sale Id 1345639',1897.28,0.00,0.00,3.08,197.12,'2021-12-16 10:44:09','',''),(2296170,'1','150','771',329,'Retail Sale Id 1345645',3498.88,0.00,0.00,5.68,363.52,'2021-12-16 10:44:52','',''),(2296216,'1','150','771',329,'Retail Sale Id 1345663',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:50:28','',''),(2296232,'1','150','771',329,'Retail Sale Id 1345705',3702.16,0.00,0.00,6.01,384.64,'2021-12-16 10:52:36','',''),(2296237,'1','150','771',329,'Retail Sale Id 1345713',30800.00,0.00,0.00,50.00,3200.00,'2021-12-16 10:53:06','',''),(2296241,'1','150','771',329,'Retail Sale Id 1345717',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:53:37','',''),(2296245,'1','150','771',329,'Retail Sale Id 1345721',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 10:54:04','',''),(2296290,'1','150','771',329,'Retail Sale Id 1345766',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 10:58:46','',''),(2296295,'1','150','771',329,'Retail Sale Id 1345773',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 10:59:19','',''),(2296300,'1','150','771',329,'Retail Sale Id 1345776',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 10:59:59','',''),(2296306,'1','150','771',329,'Retail Sale Id 1345783',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 11:00:28','',''),(2296311,'1','150','771',329,'Retail Sale Id 1345788',997.92,0.00,0.00,1.62,103.68,'2021-12-16 11:00:59','',''),(2296315,'1','150','771',329,'Retail Sale Id 1345792',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 11:01:31','',''),(2296364,'1','150','771',329,'Retail Sale Id 1345842',4502.96,0.00,0.00,7.31,467.84,'2021-12-16 11:07:49','',''),(2296382,'1','150','771',329,'Retail Sale Id 1345848',2550.24,0.00,0.00,4.14,264.96,'2021-12-16 11:09:01','',''),(2296389,'1','150','771',329,'Retail Sale Id 1345859',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 11:09:34','',''),(2296399,'1','150','771',329,'Retail Sale Id 1345868',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 11:10:25','',''),(2296676,'1','150','771',329,'Retail Sale Id 1346118',2500.96,0.00,0.00,4.06,259.84,'2021-12-16 11:42:49','',''),(2296685,'1','150','771',329,'Retail Sale Id 1346122',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 11:43:54','',''),(2296692,'1','150','771',329,'Retail Sale Id 1346135',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 11:44:43','',''),(2296701,'1','150','771',329,'Retail Sale Id 1346144',15400.00,0.00,0.00,25.00,1600.00,'2021-12-16 11:46:11','',''),(2296714,'1','150','771',329,'Retail Sale Id 1346157',3997.84,0.00,0.00,6.49,415.36,'2021-12-16 11:47:36','',''),(2296726,'1','150','771',329,'Retail Sale Id 1346168',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 11:49:12','',''),(2296819,'1','150','771',329,'Retail Sale Id 1346255',3702.16,0.00,0.00,6.01,384.64,'2021-12-16 12:01:04','',''),(2297017,'1','150','771',329,'Retail Sale Id 1346404',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 12:21:45','',''),(2297029,'1','150','771',329,'Retail Sale Id 1346418',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 12:23:37','',''),(2297039,'1','150','771',329,'Retail Sale Id 1346430',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 12:24:50','',''),(2297209,'1','150','771',329,'Retail Sale Id 1346561',0.00,0.00,0.00,0.00,0.00,'2021-12-16 12:44:03','',''),(2297321,'1','150','771',329,'Retail Sale Id 1346662',29999.20,0.00,0.00,48.70,3116.80,'2021-12-16 12:55:01','',''),(2297328,'1','150','771',329,'Retail Sale Id 1346666',12320.00,0.00,0.00,20.00,1280.00,'2021-12-16 12:55:56','',''),(2297345,'1','150','771',329,'Retail Sale Id 1346674',15400.00,0.00,0.00,25.00,1600.00,'2021-12-16 12:57:29','',''),(2297361,'1','150','771',329,'Retail Sale Id 1346689',95498.48,0.00,0.00,155.03,9921.92,'2021-12-16 12:59:15','',''),(2297371,'1','150','771',329,'Retail Sale Id 1346701',46200.00,0.00,0.00,75.00,4800.00,'2021-12-16 13:00:57','',''),(2297451,'1','150','771',329,'Retail Sale Id 1346782',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:12:54','',''),(2297461,'1','150','771',329,'Retail Sale Id 1346793',997.92,0.00,0.00,1.62,103.68,'2021-12-16 13:14:07','',''),(2297468,'1','150','771',329,'Retail Sale Id 1346799',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:14:49','',''),(2297477,'1','150','771',329,'Retail Sale Id 1346806',3098.48,0.00,0.00,5.03,321.92,'2021-12-16 13:15:40','',''),(2297487,'1','150','771',329,'Retail Sale Id 1346812',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:16:47','',''),(2297494,'1','150','771',329,'Retail Sale Id 1346823',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:17:32','',''),(2297500,'1','150','771',329,'Retail Sale Id 1346827',5001.92,0.00,0.00,8.12,519.68,'2021-12-16 13:17:56','',''),(2297513,'1','150','771',329,'Retail Sale Id 1346834',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:19:37','',''),(2297523,'1','150','771',329,'Retail Sale Id 1346852',2500.96,0.00,0.00,4.06,259.84,'2021-12-16 13:20:52','',''),(2297549,'1','150','771',329,'Retail Sale Id 1346881',997.92,0.00,0.00,1.62,103.68,'2021-12-16 13:23:36','',''),(2297580,'1','150','771',329,'Retail Sale Id 1346904',997.92,0.00,0.00,1.62,103.68,'2021-12-16 13:25:52','',''),(2297589,'1','150','771',329,'Retail Sale Id 1346910',800.80,0.00,0.00,1.30,83.20,'2021-12-16 13:26:31','',''),(2297601,'1','150','771',329,'Retail Sale Id 1346920',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 13:27:39','',''),(2297620,'1','150','771',329,'Retail Sale Id 1346929',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 13:29:24','',''),(2297648,'1','150','771',329,'Retail Sale Id 1346953',2999.92,0.00,0.00,4.87,311.68,'2021-12-16 13:32:26','',''),(2297659,'1','150','771',329,'Retail Sale Id 1346965',1503.04,0.00,0.00,2.44,156.16,'2021-12-16 13:33:46','',''),(2297675,'1','150','771',329,'Retail Sale Id 1346981',997.92,0.00,0.00,1.62,103.68,'2021-12-16 13:35:15','',''),(2297724,'1','150','771',329,'Retail Sale Id 1347013',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 13:38:26','',''),(2297741,'1','150','771',329,'Retail Sale Id 1347031',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:40:44','',''),(2297755,'1','150','771',329,'Retail Sale Id 1347049',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:42:24','',''),(2297773,'1','150','771',329,'Retail Sale Id 1347058',2500.96,0.00,0.00,4.06,259.84,'2021-12-16 13:43:32','',''),(2297796,'1','150','771',329,'Retail Sale Id 1347063',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 13:44:25','',''),(2297805,'1','150','771',329,'Retail Sale Id 1347072',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:45:14','',''),(2297811,'1','150','771',329,'Retail Sale Id 1347080',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:46:05','',''),(2297840,'1','150','771',329,'Retail Sale Id 1347096',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:47:43','',''),(2297879,'1','150','771',329,'Retail Sale Id 1347125',2002.00,0.00,0.00,3.25,208.00,'2021-12-16 13:50:37','',''),(2297887,'1','150','771',329,'Retail Sale Id 1347134',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 13:51:36','',''),(2297896,'1','150','771',329,'Retail Sale Id 1347147',2550.24,0.00,0.00,4.14,264.96,'2021-12-16 13:52:42','',''),(2297905,'1','150','771',329,'Retail Sale Id 1347154',6196.96,0.00,0.00,10.06,643.84,'2021-12-16 13:53:48','',''),(2297918,'1','150','771',329,'Retail Sale Id 1347165',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:55:20','',''),(2297934,'1','150','771',329,'Retail Sale Id 1347178',6751.36,0.00,0.00,10.96,701.44,'2021-12-16 13:57:24','',''),(2297960,'1','150','771',329,'Retail Sale Id 1347199',3800.72,0.00,0.00,6.17,394.88,'2021-12-16 13:59:57','',''),(2297981,'1','150','771',329,'Retail Sale Id 1347210',997.92,0.00,0.00,1.62,103.68,'2021-12-16 14:01:56','',''),(2298002,'1','150','771',329,'Retail Sale Id 1347233',1897.28,0.00,0.00,3.08,197.12,'2021-12-16 14:05:15','',''),(2298011,'1','150','771',329,'Retail Sale Id 1347243',1201.20,0.00,0.00,1.95,124.80,'2021-12-16 14:06:03','',''),(2298030,'1','150','771',329,'Retail Sale Id 1347249',997.92,0.00,0.00,1.62,103.68,'2021-12-16 14:06:57','',''),(2298249,'1','150','771',329,'Retail Sale Id 1347427',7700.00,0.00,0.00,12.50,800.00,'2021-12-16 14:26:45','',''),(2298754,'1','150','771',329,'Retail Sale Id 1347805',83652.80,0.00,0.00,135.80,8691.20,'2021-12-16 15:12:53','',''),(2301247,'1','150','771',329,'Retail Sale Id 1349396',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 05:44:55','',''),(2301248,'1','150','771',329,'Retail Sale Id 1349397',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 05:45:30','',''),(2301249,'1','150','771',329,'Retail Sale Id 1349398',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 05:47:20','',''),(2301252,'1','150','771',329,'Retail Sale Id 1349399',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 05:48:28','',''),(2301255,'1','150','771',329,'Retail Sale Id 1349400',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 05:49:40','',''),(2301258,'1','150','771',329,'Retail Sale Id 1349405',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 05:50:58','',''),(2301259,'1','150','771',329,'Retail Sale Id 1349406',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 05:53:15','',''),(2301289,'1','150','771',329,'Retail Sale Id 1349443',997.92,0.00,0.00,1.62,103.68,'2021-12-17 06:08:09','',''),(2301296,'1','150','771',329,'Retail Sale Id 1349450',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 06:09:36','',''),(2301322,'1','150','771',329,'Retail Sale Id 1349457',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 06:12:14','',''),(2301335,'1','150','771',329,'Retail Sale Id 1349462',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 06:13:17','',''),(2301340,'1','150','771',329,'Retail Sale Id 1349466',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 06:14:22','',''),(2301349,'1','150','771',329,'Retail Sale Id 1349473',997.92,0.00,0.00,1.62,103.68,'2021-12-17 06:15:55','',''),(2301353,'1','150','771',329,'Retail Sale Id 1349477',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 06:17:09','',''),(2301362,'1','150','771',329,'Retail Sale Id 1349485',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 06:18:51','',''),(2301375,'1','150','771',329,'Retail Sale Id 1349488',5500.88,0.00,0.00,8.93,571.52,'2021-12-17 06:19:23','',''),(2301379,'1','150','771',329,'Retail Sale Id 1349492',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 06:19:59','',''),(2301490,'1','150','771',329,'Retail Sale Id 1349586',0.00,0.00,0.00,0.00,0.00,'2021-12-17 06:39:09','',''),(2303151,'1','150','771',329,'Retail Sale Id 1350888',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 09:10:41','',''),(2303220,'1','150','771',329,'Retail Sale Id 1350904',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 09:13:12','',''),(2303228,'1','150','771',329,'Retail Sale Id 1350912',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 09:14:34','',''),(2303241,'1','150','771',329,'Retail Sale Id 1350920',702.24,0.00,0.00,1.14,72.96,'2021-12-17 09:16:11','',''),(2303246,'1','150','771',329,'Retail Sale Id 1350927',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 09:17:08','',''),(2303265,'1','150','771',329,'Retail Sale Id 1350945',1250.48,0.00,0.00,2.03,129.92,'2021-12-17 09:19:32','',''),(2303281,'1','150','771',329,'Retail Sale Id 1350959',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 09:20:44','',''),(2303326,'1','150','771',329,'Retail Sale Id 1350996',997.92,0.00,0.00,1.62,103.68,'2021-12-17 09:24:30','',''),(2303377,'1','150','771',329,'Retail Sale Id 1351035',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 09:28:49','',''),(2303422,'1','150','771',329,'Retail Sale Id 1351070',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 09:32:47','',''),(2303474,'1','150','771',329,'Retail Sale Id 1351104',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 09:35:45','',''),(2303486,'1','150','771',329,'Retail Sale Id 1351112',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 09:36:30','',''),(2303516,'1','150','771',329,'Retail Sale Id 1351130',997.92,0.00,0.00,1.62,103.68,'2021-12-17 09:38:35','',''),(2303571,'1','150','771',329,'Retail Sale Id 1351172',30800.00,0.00,0.00,50.00,3200.00,'2021-12-17 09:43:19','',''),(2303587,'1','150','771',329,'Retail Sale Id 1351180',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 09:45:03','',''),(2303604,'1','150','771',329,'Retail Sale Id 1351201',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 09:46:44','',''),(2303612,'1','150','771',329,'Retail Sale Id 1351209',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 09:47:57','',''),(2303624,'1','150','771',329,'Retail Sale Id 1351217',1250.48,0.00,0.00,2.03,129.92,'2021-12-17 09:49:06','',''),(2303671,'1','150','771',329,'Retail Sale Id 1351246',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 09:52:40','',''),(2303676,'1','150','771',329,'Retail Sale Id 1351252',997.92,0.00,0.00,1.62,103.68,'2021-12-17 09:53:35','',''),(2303746,'1','150','771',329,'Retail Sale Id 1351314',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 10:00:31','',''),(2303757,'1','150','771',329,'Retail Sale Id 1351325',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 10:01:43','',''),(2303765,'1','150','771',329,'Retail Sale Id 1351332',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 10:02:24','',''),(2303778,'1','150','771',329,'Retail Sale Id 1351344',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 10:03:42','',''),(2303788,'1','150','771',329,'Retail Sale Id 1351404',498.96,0.00,0.00,0.81,51.84,'2021-12-17 10:06:21','',''),(2303798,'1','150','771',329,'Retail Sale Id 1351412',1552.32,0.00,0.00,2.52,161.28,'2021-12-17 10:07:12','',''),(2303803,'1','150','771',329,'Retail Sale Id 1351416',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 10:07:55','',''),(2303812,'1','150','771',329,'Retail Sale Id 1351421',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 10:08:56','',''),(2303834,'1','150','771',329,'Retail Sale Id 1351431',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 10:10:12','',''),(2303844,'1','150','771',329,'Retail Sale Id 1351440',0.00,0.00,0.00,0.00,0.00,'2021-12-17 10:11:12','',''),(2303971,'1','150','771',329,'Retail Sale Id 1351562',5500.88,0.00,0.00,8.93,571.52,'2021-12-17 10:26:10','',''),(2303985,'1','150','771',329,'Retail Sale Id 1351576',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 10:27:44','',''),(2303992,'1','150','771',329,'Retail Sale Id 1351583',997.92,0.00,0.00,1.62,103.68,'2021-12-17 10:28:41','',''),(2303998,'1','150','771',329,'Retail Sale Id 1351589',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 10:29:32','',''),(2304013,'1','150','771',329,'Retail Sale Id 1351601',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 10:31:12','',''),(2304024,'1','150','771',329,'Retail Sale Id 1351610',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 10:32:52','',''),(2304184,'1','150','771',329,'Retail Sale Id 1351750',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 10:51:20','',''),(2304189,'1','150','771',329,'Retail Sale Id 1351775',3400.32,0.00,0.00,5.52,353.28,'2021-12-17 10:52:10','',''),(2304281,'1','150','771',329,'Retail Sale Id 1351856',12320.00,0.00,0.00,20.00,1280.00,'2021-12-17 11:02:47','',''),(2304287,'1','150','771',329,'Retail Sale Id 1351864',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 11:03:27','',''),(2304332,'1','150','771',329,'Retail Sale Id 1351905',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 11:07:22','',''),(2304342,'1','150','771',329,'Retail Sale Id 1351914',4952.64,0.00,0.00,8.04,514.56,'2021-12-17 11:08:43','',''),(2304347,'1','150','771',329,'Retail Sale Id 1351919',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 11:09:19','',''),(2304373,'1','150','771',329,'Retail Sale Id 1351946',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 11:11:56','',''),(2304395,'1','150','771',329,'Retail Sale Id 1351969',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 11:14:08','',''),(2304434,'1','150','771',329,'Retail Sale Id 1352001',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 11:17:16','',''),(2304447,'1','150','771',329,'Retail Sale Id 1352013',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 11:18:38','',''),(2304472,'1','150','771',329,'Retail Sale Id 1352021',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 11:19:27','',''),(2304482,'1','150','771',329,'Retail Sale Id 1352030',6997.76,0.00,0.00,11.36,727.04,'2021-12-17 11:20:20','',''),(2304499,'1','150','771',329,'Retail Sale Id 1352046',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 11:21:49','',''),(2304505,'1','150','771',329,'Retail Sale Id 1352053',652.96,0.00,0.00,1.06,67.84,'2021-12-17 11:22:25','',''),(2304515,'1','150','771',329,'Retail Sale Id 1352060',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 11:23:18','',''),(2304530,'1','150','771',329,'Retail Sale Id 1352073',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 11:24:21','',''),(2304540,'1','150','771',329,'Retail Sale Id 1352082',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 11:25:14','',''),(2304590,'1','150','771',329,'Retail Sale Id 1352132',997.92,0.00,0.00,1.62,103.68,'2021-12-17 11:29:25','',''),(2304620,'1','150','771',329,'Retail Sale Id 1352159',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 11:32:41','',''),(2304635,'1','150','771',329,'Retail Sale Id 1352178',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 11:34:08','',''),(2304673,'1','150','771',329,'Retail Sale Id 1352212',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 11:38:30','',''),(2304722,'1','150','771',329,'Retail Sale Id 1352263',1250.48,0.00,0.00,2.03,129.92,'2021-12-17 11:45:10','',''),(2304736,'1','150','771',329,'Retail Sale Id 1352280',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 11:47:05','',''),(2304745,'1','150','771',329,'Retail Sale Id 1352299',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 11:47:58','',''),(2304762,'1','150','771',329,'Retail Sale Id 1352313',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 11:50:44','',''),(2304793,'1','150','771',329,'Retail Sale Id 1352336',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 11:53:41','',''),(2304809,'1','150','771',329,'Retail Sale Id 1352351',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 11:55:56','',''),(2304839,'1','150','771',329,'Retail Sale Id 1352370',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 11:59:20','',''),(2304915,'1','150','771',329,'Retail Sale Id 1352431',30997.12,0.00,0.00,50.32,3220.48,'2021-12-17 12:07:40','',''),(2304963,'1','150','771',329,'Retail Sale Id 1352478',997.92,0.00,0.00,1.62,103.68,'2021-12-17 12:15:15','',''),(2304971,'1','150','771',329,'Retail Sale Id 1352486',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 12:16:15','',''),(2304976,'1','150','771',329,'Retail Sale Id 1352490',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 12:17:12','',''),(2304996,'1','150','771',329,'Retail Sale Id 1352521',3702.16,0.00,0.00,6.01,384.64,'2021-12-17 12:20:32','',''),(2305003,'1','150','771',329,'Retail Sale Id 1352528',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 12:22:12','',''),(2305052,'1','150','771',329,'Retail Sale Id 1352575',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 12:30:18','',''),(2305106,'1','150','771',329,'Retail Sale Id 1352613',340469.36,0.00,0.00,552.71,35373.44,'2021-12-17 12:36:42','',''),(2305126,'1','150','771',329,'Retail Sale Id 1352622',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 12:38:12','',''),(2305147,'1','150','771',329,'Retail Sale Id 1352651',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 12:42:44','',''),(2305154,'1','150','771',329,'Retail Sale Id 1352657',1201.20,0.00,0.00,1.95,124.80,'2021-12-17 12:43:51','',''),(2305163,'1','150','771',329,'Retail Sale Id 1352667',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 12:45:06','',''),(2305178,'1','150','771',329,'Retail Sale Id 1352679',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 12:47:14','',''),(2305222,'1','150','771',329,'Retail Sale Id 1352737',6498.80,0.00,0.00,10.55,675.20,'2021-12-17 12:55:48','',''),(2305245,'1','150','771',329,'Retail Sale Id 1352760',3702.16,0.00,0.00,6.01,384.64,'2021-12-17 12:59:41','',''),(2305258,'1','150','771',329,'Retail Sale Id 1352775',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 13:01:35','',''),(2305274,'1','150','771',329,'Retail Sale Id 1352787',3702.16,0.00,0.00,6.01,384.64,'2021-12-17 13:02:43','',''),(2305281,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,3052560.00,5530.00,0.00,0.00,'2021-12-17 13:04:08','',''),(2305288,'1','150',NULL,329,'Reception corrector for bridging 127732',0.00,0.00,0.00,5530.00,0.00,'2021-12-17 13:04:55','',''),(2305289,'1','150','771',329,'Received from bridging 127732',0.00,0.00,5530.00,0.00,0.00,'2021-12-17 13:04:55','',''),(2305303,'1','150','771',329,'Retail Sale Id 1352811',3702.16,0.00,0.00,6.01,384.64,'2021-12-17 13:06:17','',''),(2305313,'1','150','771',329,'Retail Sale Id 1352820',997.92,0.00,0.00,1.62,103.68,'2021-12-17 13:07:41','',''),(2305322,'1','150','771',329,'Retail Sale Id 1352832',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 13:09:25','',''),(2305360,'1','150','771',329,'Retail Sale Id 1352872',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 13:16:45','',''),(2305384,'1','150','771',329,'Retail Sale Id 1352900',5001.92,0.00,0.00,8.12,519.68,'2021-12-17 13:19:38','',''),(2305396,'1','150','771',329,'Retail Sale Id 1352908',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 13:22:00','',''),(2305404,'1','150','771',329,'Retail Sale Id 1352918',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 13:23:47','',''),(2305411,'1','150','771',329,'Retail Sale Id 1352932',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 13:24:50','',''),(2305418,'1','150','771',329,'Retail Sale Id 1352937',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 13:25:46','',''),(2305421,'1','150','771',329,'Retail Sale Id 1352940',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 13:26:18','',''),(2305433,'1','150','771',329,'Retail Sale Id 1352951',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 13:27:35','',''),(2305441,'1','150','771',329,'Retail Sale Id 1352958',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 13:28:19','',''),(2305466,'1','150','771',329,'Retail Sale Id 1352982',997.92,0.00,0.00,1.62,103.68,'2021-12-17 13:31:57','',''),(2305474,'1','150','771',329,'Retail Sale Id 1352993',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 13:32:51','',''),(2305495,'1','150','771',329,'Retail Sale Id 1353008',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 13:34:18','',''),(2305498,'1','150','771',329,'Retail Sale Id 1353014',3498.88,0.00,0.00,5.68,363.52,'2021-12-17 13:34:51','',''),(2305517,'1','150','771',329,'Retail Sale Id 1353033',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 13:37:12','',''),(2305579,'1','150','771',329,'Retail Sale Id 1353068',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 13:42:25','',''),(2305611,'1','150','771',329,'Retail Sale Id 1353083',997.92,0.00,0.00,1.62,103.68,'2021-12-17 13:44:01','',''),(2305628,'1','150','771',329,'Retail Sale Id 1353099',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 13:46:33','',''),(2305642,'1','150','771',329,'Retail Sale Id 1353113',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 13:48:43','',''),(2305655,'1','150','771',329,'Retail Sale Id 1353120',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 13:50:46','',''),(2305659,'1','150','771',329,'Retail Sale Id 1353125',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 13:52:04','',''),(2305664,'1','150','771',329,'Retail Sale Id 1353128',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 13:52:44','',''),(2305671,'1','150','771',329,'Retail Sale Id 1353139',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 13:53:43','',''),(2305682,'1','150','771',329,'Retail Sale Id 1353151',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 13:54:36','',''),(2305705,'1','150','771',329,'Retail Sale Id 1353166',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 13:56:12','',''),(2305728,'1','150','771',329,'Retail Sale Id 1353178',20020.00,0.00,0.00,32.50,2080.00,'2021-12-17 13:58:02','',''),(2305747,'1','150','771',329,'Retail Sale Id 1353186',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 13:59:06','',''),(2305763,'1','150','771',329,'Retail Sale Id 1353196',5001.92,0.00,0.00,8.12,519.68,'2021-12-17 13:59:58','',''),(2305782,'1','150','771',329,'Retail Sale Id 1353203',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 14:01:46','',''),(2305787,'1','150','771',329,'Retail Sale Id 1353215',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 14:02:25','',''),(2305797,'1','150','771',329,'Retail Sale Id 1353218',702.24,0.00,0.00,1.14,72.96,'2021-12-17 14:03:08','',''),(2305829,'1','150','771',329,'Retail Sale Id 1353241',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 14:05:53','',''),(2305851,'1','150','771',329,'Retail Sale Id 1353257',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 14:07:29','',''),(2305907,'1','150','771',329,'Retail Sale Id 1353304',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 14:13:47','',''),(2305916,'1','150','771',329,'Retail Sale Id 1353314',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 14:15:16','',''),(2305923,'1','150','771',329,'Retail Sale Id 1353322',498.96,0.00,0.00,0.81,51.84,'2021-12-17 14:16:24','',''),(2305933,'1','150','771',329,'Retail Sale Id 1353333',3197.04,0.00,0.00,5.19,332.16,'2021-12-17 14:17:50','',''),(2305937,'1','150','771',329,'Retail Sale Id 1353335',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 14:18:33','',''),(2305946,'1','150','771',329,'Retail Sale Id 1353349',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 14:20:27','',''),(2305954,'1','150','771',329,'Retail Sale Id 1353354',200002.88,0.00,0.00,324.68,20779.52,'2021-12-17 14:21:25','',''),(2305969,'1','150','771',329,'Retail Sale Id 1353366',11001.76,0.00,0.00,17.86,1143.04,'2021-12-17 14:23:15','',''),(2306008,'1','150','771',329,'Retail Sale Id 1353392',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 14:27:40','',''),(2306018,'1','150','771',329,'Retail Sale Id 1353406',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 14:28:34','',''),(2306039,'1','150','771',329,'Retail Sale Id 1353414',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 14:31:06','',''),(2306053,'1','150','771',329,'Retail Sale Id 1353440',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 14:32:41','',''),(2306061,'1','150','771',329,'Retail Sale Id 1353446',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 14:33:25','',''),(2306068,'1','150','771',329,'Retail Sale Id 1353453',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 14:34:15','',''),(2306080,'1','150','771',329,'Retail Sale Id 1353463',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 14:35:17','',''),(2306091,'1','150','771',329,'Retail Sale Id 1353479',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 14:36:07','',''),(2306103,'1','150','771',329,'Retail Sale Id 1353491',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 14:37:23','',''),(2306155,'1','150','771',329,'Retail Sale Id 1353522',5999.84,0.00,0.00,9.74,623.36,'2021-12-17 14:40:45','',''),(2306261,'1','150','771',329,'Retail Sale Id 1353592',7102.48,0.00,0.00,11.53,737.92,'2021-12-17 14:47:19','',''),(2306281,'1','150','771',329,'Retail Sale Id 1353612',997.92,0.00,0.00,1.62,103.68,'2021-12-17 14:49:18','',''),(2306288,'1','150','771',329,'Retail Sale Id 1353620',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 14:50:12','',''),(2306295,'1','150','771',329,'Retail Sale Id 1353624',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 14:50:49','',''),(2306304,'1','150','771',329,'Retail Sale Id 1353635',3856.16,0.00,0.00,6.26,400.64,'2021-12-17 14:51:46','',''),(2306331,'1','150','771',329,'Retail Sale Id 1353645',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 14:53:35','',''),(2306385,'1','150','771',329,'Retail Sale Id 1353660',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 14:55:08','',''),(2306483,'1','150','771',329,'Retail Sale Id 1353750',6997.76,0.00,0.00,11.36,727.04,'2021-12-17 15:06:49','',''),(2306492,'1','150','771',329,'Retail Sale Id 1353758',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:07:58','',''),(2306506,'1','150','771',329,'Retail Sale Id 1353771',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:09:02','',''),(2306515,'1','150','771',329,'Retail Sale Id 1353792',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 15:09:59','',''),(2306520,'1','150','771',329,'Retail Sale Id 1353797',5001.92,0.00,0.00,8.12,519.68,'2021-12-17 15:10:40','',''),(2306526,'1','150','771',329,'Retail Sale Id 1353802',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:11:31','',''),(2306537,'1','150','771',329,'Retail Sale Id 1353812',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 15:12:51','',''),(2306548,'1','150','771',329,'Retail Sale Id 1353822',1299.76,0.00,0.00,2.11,135.04,'2021-12-17 15:14:06','',''),(2306554,'1','150','771',329,'Retail Sale Id 1353832',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:14:54','',''),(2306566,'1','150','771',329,'Retail Sale Id 1353840',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:15:39','',''),(2306579,'1','150','771',329,'Retail Sale Id 1353851',3252.48,0.00,0.00,5.28,337.92,'2021-12-17 15:17:13','',''),(2306594,'1','150','771',329,'Retail Sale Id 1353861',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 15:18:06','',''),(2306602,'1','150','771',329,'Retail Sale Id 1353868',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:19:01','',''),(2306617,'1','150','771',329,'Retail Sale Id 1353878',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:19:47','',''),(2306653,'1','150','771',329,'Retail Sale Id 1353888',2100.56,0.00,0.00,3.41,218.24,'2021-12-17 15:20:58','',''),(2306668,'1','150','771',329,'Retail Sale Id 1353899',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 15:21:46','',''),(2306673,'1','150','771',329,'Retail Sale Id 1353906',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:22:32','',''),(2306678,'1','150','771',329,'Retail Sale Id 1353911',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 15:23:22','',''),(2306690,'1','150','771',329,'Retail Sale Id 1353923',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 15:24:09','',''),(2306697,'1','150','771',329,'Retail Sale Id 1353932',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:24:46','',''),(2306708,'1','150','771',329,'Retail Sale Id 1353940',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 15:25:32','',''),(2306745,'1','150','771',329,'Retail Sale Id 1353967',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:27:43','',''),(2306757,'1','150','771',329,'Retail Sale Id 1353980',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:29:00','',''),(2306767,'1','150','771',329,'Retail Sale Id 1353989',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 15:30:04','',''),(2306793,'1','150','771',329,'Retail Sale Id 1354002',2999.92,0.00,0.00,4.87,311.68,'2021-12-17 15:31:06','',''),(2306796,'1','150','771',329,'Retail Sale Id 1354007',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 15:31:41','',''),(2306860,'1','150','771',329,'Retail Sale Id 1354039',1299.76,0.00,0.00,2.11,135.04,'2021-12-17 15:35:30','',''),(2306869,'1','150','771',329,'Retail Sale Id 1354049',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:36:20','',''),(2306879,'1','150','771',329,'Retail Sale Id 1354057',1552.32,0.00,0.00,2.52,161.28,'2021-12-17 15:37:03','',''),(2306904,'1','150','771',329,'Retail Sale Id 1354069',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:38:07','',''),(2306912,'1','150','771',329,'Retail Sale Id 1354082',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:39:08','',''),(2306925,'1','150','771',329,'Retail Sale Id 1354089',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:39:57','',''),(2306939,'1','150','771',329,'Retail Sale Id 1354102',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:41:08','',''),(2306970,'1','150','771',329,'Retail Sale Id 1354118',5999.84,0.00,0.00,9.74,623.36,'2021-12-17 15:43:04','',''),(2306991,'1','150','771',329,'Retail Sale Id 1354141',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 15:44:26','',''),(2307016,'1','150','771',329,'Retail Sale Id 1354160',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:45:42','',''),(2307042,'1','150','771',329,'Retail Sale Id 1354174',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 15:47:14','',''),(2307052,'1','150','771',329,'Retail Sale Id 1354192',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:48:02','',''),(2307073,'1','150','771',329,'Retail Sale Id 1354215',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:49:47','',''),(2307087,'1','150','771',329,'Retail Sale Id 1354233',5001.92,0.00,0.00,8.12,519.68,'2021-12-17 15:51:11','',''),(2307092,'1','150','771',329,'Retail Sale Id 1354239',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 15:52:01','',''),(2307106,'1','150','771',329,'Retail Sale Id 1354252',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:53:01','',''),(2307110,'1','150','771',329,'Retail Sale Id 1354256',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:53:30','',''),(2307125,'1','150','771',329,'Retail Sale Id 1354274',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:54:55','',''),(2307134,'1','150','771',329,'Retail Sale Id 1354282',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:55:51','',''),(2307157,'1','150','771',329,'Retail Sale Id 1354298',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 15:57:27','',''),(2307163,'1','150','771',329,'Retail Sale Id 1354319',997.92,0.00,0.00,1.62,103.68,'2021-12-17 15:58:09','',''),(2307175,'1','150','771',329,'Retail Sale Id 1354329',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 15:59:22','',''),(2307194,'1','150','771',329,'Retail Sale Id 1354346',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 16:01:09','',''),(2307204,'1','150','771',329,'Retail Sale Id 1354361',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 16:02:26','',''),(2307221,'1','150','771',329,'Retail Sale Id 1354368',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 16:03:27','',''),(2307226,'1','150','771',329,'Retail Sale Id 1354375',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 16:03:51','',''),(2307241,'1','150','771',329,'Retail Sale Id 1354391',0.00,0.00,0.00,0.00,0.00,'2021-12-17 16:05:02','',''),(2307658,'1','150','771',329,'Retail Sale Id 1354830',7502.88,0.00,0.00,12.18,779.52,'2021-12-17 16:46:07','',''),(2307669,'1','150','771',329,'Retail Sale Id 1354839',997.92,0.00,0.00,1.62,103.68,'2021-12-17 16:47:12','',''),(2307687,'1','150','771',329,'Retail Sale Id 1354846',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 16:47:56','',''),(2307716,'1','150','771',329,'Retail Sale Id 1354857',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 16:49:14','',''),(2307750,'1','150','771',329,'Retail Sale Id 1354891',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 16:52:42','',''),(2307761,'1','150','771',329,'Retail Sale Id 1354898',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 16:53:49','',''),(2307766,'1','150','771',329,'Retail Sale Id 1354902',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 16:54:33','',''),(2307772,'1','150','771',329,'Retail Sale Id 1354908',3098.48,0.00,0.00,5.03,321.92,'2021-12-17 16:55:17','',''),(2307778,'1','150','771',329,'Retail Sale Id 1354913',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 16:55:53','',''),(2307786,'1','150','771',329,'Retail Sale Id 1354921',997.92,0.00,0.00,1.62,103.68,'2021-12-17 16:57:31','',''),(2307787,'1','150','771',329,'Retail Sale Id 1354923',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 16:58:01','',''),(2307801,'1','150','771',329,'Retail Sale Id 1354936',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 16:59:11','',''),(2307811,'1','150','771',329,'Retail Sale Id 1354946',3800.72,0.00,0.00,6.17,394.88,'2021-12-17 17:01:07','',''),(2307822,'1','150','771',329,'Retail Sale Id 1354957',9997.68,0.00,0.00,16.23,1038.72,'2021-12-17 17:02:56','',''),(2307823,'1','150','771',329,'Retail Sale Id 1354958',997.92,0.00,0.00,1.62,103.68,'2021-12-17 17:03:18','',''),(2307828,'1','150','771',329,'Retail Sale Id 1354962',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 17:04:27','',''),(2307836,'1','150','771',329,'Retail Sale Id 1354969',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 17:05:20','',''),(2307840,'1','150','771',329,'Retail Sale Id 1354973',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 17:06:21','',''),(2307849,'1','150','771',329,'Retail Sale Id 1354983',997.92,0.00,0.00,1.62,103.68,'2021-12-17 17:07:12','',''),(2307856,'1','150','771',329,'Retail Sale Id 1354990',997.92,0.00,0.00,1.62,103.68,'2021-12-17 17:08:13','',''),(2307865,'1','150','771',329,'Retail Sale Id 1355002',6196.96,0.00,0.00,10.06,643.84,'2021-12-17 17:09:21','',''),(2307896,'1','150','771',329,'Retail Sale Id 1355025',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 17:12:21','',''),(2307904,'1','150','771',329,'Retail Sale Id 1355033',997.92,0.00,0.00,1.62,103.68,'2021-12-17 17:13:18','',''),(2307993,'1','150','771',329,'Retail Sale Id 1355077',1897.28,0.00,0.00,3.08,197.12,'2021-12-17 17:20:22','',''),(2308046,'1','150','771',329,'Retail Sale Id 1355112',3702.16,0.00,0.00,6.01,384.64,'2021-12-17 17:26:05','',''),(2308051,'1','150','771',329,'Retail Sale Id 1355117',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 17:26:34','',''),(2308089,'1','150','771',329,'Retail Sale Id 1355154',1700.16,0.00,0.00,2.76,176.64,'2021-12-17 17:37:33','',''),(2308093,'1','150','771',329,'Retail Sale Id 1355158',3997.84,0.00,0.00,6.49,415.36,'2021-12-17 17:38:15','',''),(2308099,'1','150','771',329,'Retail Sale Id 1355163',6997.76,0.00,0.00,11.36,727.04,'2021-12-17 17:39:12','',''),(2308108,'1','150','771',329,'Retail Sale Id 1355170',997.92,0.00,0.00,1.62,103.68,'2021-12-17 17:40:47','',''),(2308116,'1','150','771',329,'Retail Sale Id 1355177',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 17:42:41','',''),(2308143,'1','150','771',329,'Retail Sale Id 1355203',498.96,0.00,0.00,0.81,51.84,'2021-12-17 17:47:27','',''),(2308167,'1','150','771',329,'Retail Sale Id 1355225',1503.04,0.00,0.00,2.44,156.16,'2021-12-17 17:52:17','',''),(2308211,'1','150','771',329,'Retail Sale Id 1355237',2500.96,0.00,0.00,4.06,259.84,'2021-12-17 17:54:49','',''),(2308303,'1','150','771',329,'Retail Sale Id 1355291',1250.48,0.00,0.00,2.03,129.92,'2021-12-17 18:08:31','',''),(2308306,'1','150','771',329,'Retail Sale Id 1355294',2002.00,0.00,0.00,3.25,208.00,'2021-12-17 18:09:36','',''),(2308319,'1','150','771',329,'Retail Sale Id 1355308',997.92,0.00,0.00,1.62,103.68,'2021-12-17 18:13:59','',''),(2308325,'1','150','771',329,'Retail Sale Id 1355313',7700.00,0.00,0.00,12.50,800.00,'2021-12-17 18:15:51','',''),(2308513,'1','150','771',329,'Retail Sale Id 1355409',390266.80,0.00,0.00,633.55,40547.20,'2021-12-17 19:12:26','',''),(2309038,'1','150','771',329,'Retail Sale Id 1355438',997.92,0.00,0.00,1.62,103.68,'2021-12-18 05:43:15','',''),(2309039,'1','150','771',329,'Retail Sale Id 1355439',498.96,0.00,0.00,0.81,51.84,'2021-12-18 05:44:37','',''),(2309040,'1','150','771',329,'Retail Sale Id 1355440',997.92,0.00,0.00,1.62,103.68,'2021-12-18 05:45:32','',''),(2309041,'1','150','771',329,'Retail Sale Id 1355441',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 05:46:33','',''),(2309052,'1','150','771',329,'Retail Sale Id 1355450',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 05:59:49','',''),(2309054,'1','150','771',329,'Retail Sale Id 1355452',997.92,0.00,0.00,1.62,103.68,'2021-12-18 06:00:58','',''),(2309056,'1','150','771',329,'Retail Sale Id 1355455',997.92,0.00,0.00,1.62,103.68,'2021-12-18 06:03:23','',''),(2309057,'1','150','771',329,'Retail Sale Id 1355456',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 06:04:07','',''),(2309058,'1','150','771',329,'Retail Sale Id 1355457',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:04:51','',''),(2309063,'1','150','771',329,'Retail Sale Id 1355462',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 06:07:26','',''),(2309065,'1','150','771',329,'Retail Sale Id 1355464',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 06:08:25','',''),(2309068,'1','150','771',329,'Retail Sale Id 1355466',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:08:59','',''),(2309070,'1','150','771',329,'Retail Sale Id 1355468',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 06:09:50','',''),(2309074,'1','150','771',329,'Retail Sale Id 1355482',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 06:11:48','',''),(2309083,'1','150','771',329,'Retail Sale Id 1355490',1398.32,0.00,0.00,2.27,145.28,'2021-12-18 06:13:21','',''),(2309086,'1','150','771',329,'Retail Sale Id 1355493',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 06:14:12','',''),(2309090,'1','150','771',329,'Retail Sale Id 1355497',997.92,0.00,0.00,1.62,103.68,'2021-12-18 06:15:21','',''),(2309094,'1','150','771',329,'Retail Sale Id 1355502',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 06:16:18','',''),(2309099,'1','150','771',329,'Retail Sale Id 1355506',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 06:17:34','',''),(2309104,'1','150','771',329,'Retail Sale Id 1355511',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 06:19:07','',''),(2309127,'1','150','771',329,'Retail Sale Id 1355531',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:24:01','',''),(2309137,'1','150','771',329,'Retail Sale Id 1355541',997.92,0.00,0.00,1.62,103.68,'2021-12-18 06:25:59','',''),(2309149,'1','150','771',329,'Retail Sale Id 1355551',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 06:27:11','',''),(2309158,'1','150','771',329,'Retail Sale Id 1355560',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 06:29:39','',''),(2309162,'1','150','771',329,'Retail Sale Id 1355564',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 06:30:43','',''),(2309172,'1','150','771',329,'Retail Sale Id 1355575',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:32:46','',''),(2309179,'1','150','771',329,'Retail Sale Id 1355581',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 06:33:48','',''),(2309187,'1','150','771',329,'Retail Sale Id 1355586',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 06:34:40','',''),(2309193,'1','150','771',329,'Retail Sale Id 1355591',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:35:17','',''),(2309197,'1','150','771',329,'Retail Sale Id 1355596',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 06:35:44','',''),(2309204,'1','150','771',329,'Retail Sale Id 1355604',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 06:36:32','',''),(2309209,'1','150','771',329,'Retail Sale Id 1355608',2698.08,0.00,0.00,4.38,280.32,'2021-12-18 06:37:04','',''),(2309218,'1','150','771',329,'Retail Sale Id 1355613',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:37:37','',''),(2309230,'1','150','771',329,'Retail Sale Id 1355626',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 06:39:13','',''),(2309260,'1','150','771',329,'Retail Sale Id 1355657',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 06:42:45','',''),(2309269,'1','150','771',329,'Retail Sale Id 1355675',899.36,0.00,0.00,1.46,93.44,'2021-12-18 06:43:36','',''),(2309282,'1','150','771',329,'Retail Sale Id 1355689',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 06:45:56','',''),(2309313,'1','150','771',329,'Retail Sale Id 1355722',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 06:50:00','',''),(2309320,'1','150','771',329,'Retail Sale Id 1355730',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 06:50:37','',''),(2309327,'1','150','771',329,'Retail Sale Id 1355737',6997.76,0.00,0.00,11.36,727.04,'2021-12-18 06:51:26','',''),(2309340,'1','150','771',329,'Retail Sale Id 1355743',899.36,0.00,0.00,1.46,93.44,'2021-12-18 06:52:07','',''),(2309354,'1','150','771',329,'Retail Sale Id 1355755',997.92,0.00,0.00,1.62,103.68,'2021-12-18 06:53:02','',''),(2309408,'1','150','771',329,'Retail Sale Id 1355786',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 06:55:22','',''),(2309432,'1','150','771',329,'Retail Sale Id 1355808',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 06:57:33','',''),(2309443,'1','150','771',329,'Retail Sale Id 1355818',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 06:58:50','',''),(2309474,'1','150','771',329,'Retail Sale Id 1355838',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:00:47','',''),(2309494,'1','150','771',329,'Retail Sale Id 1355852',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 07:02:17','',''),(2309512,'1','150','771',329,'Retail Sale Id 1355864',800.80,0.00,0.00,1.30,83.20,'2021-12-18 07:03:14','',''),(2309529,'1','150','771',329,'Retail Sale Id 1355874',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 07:04:33','',''),(2309582,'1','150','771',329,'Retail Sale Id 1355908',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:07:47','',''),(2309596,'1','150','771',329,'Retail Sale Id 1355925',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 07:09:40','',''),(2309603,'1','150','771',329,'Retail Sale Id 1355929',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:10:13','',''),(2309617,'1','150','771',329,'Retail Sale Id 1355940',1798.72,0.00,0.00,2.92,186.88,'2021-12-18 07:11:23','',''),(2309627,'1','150','771',329,'Retail Sale Id 1355951',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 07:12:07','',''),(2309632,'1','150','771',329,'Retail Sale Id 1355956',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:12:43','',''),(2309677,'1','150','771',329,'Retail Sale Id 1355989',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 07:16:39','',''),(2309698,'1','150','771',329,'Retail Sale Id 1356001',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 07:17:58','',''),(2309708,'1','150','771',329,'Retail Sale Id 1356006',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 07:18:42','',''),(2309716,'1','150','771',329,'Retail Sale Id 1356016',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 07:19:59','',''),(2309731,'1','150','771',329,'Retail Sale Id 1356033',997.92,0.00,0.00,1.62,103.68,'2021-12-18 07:21:30','',''),(2309739,'1','150','771',329,'Retail Sale Id 1356038',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 07:22:11','',''),(2309761,'1','150','771',329,'Retail Sale Id 1356044',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 07:22:49','',''),(2309774,'1','150','771',329,'Retail Sale Id 1356057',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 07:23:42','',''),(2309782,'1','150','771',329,'Retail Sale Id 1356064',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:24:17','',''),(2309791,'1','150','771',329,'Retail Sale Id 1356074',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 07:25:27','',''),(2309809,'1','150','771',329,'Retail Sale Id 1356086',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 07:26:17','',''),(2309815,'1','150','771',329,'Retail Sale Id 1356093',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 07:26:58','',''),(2309820,'1','150','771',329,'Retail Sale Id 1356098',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 07:27:38','',''),(2309832,'1','150','771',329,'Retail Sale Id 1356108',6997.76,0.00,0.00,11.36,727.04,'2021-12-18 07:29:02','',''),(2309853,'1','150','771',329,'Retail Sale Id 1356121',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 07:31:18','',''),(2309924,'1','150','771',329,'Retail Sale Id 1356178',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 07:38:37','',''),(2309944,'1','150','771',329,'Retail Sale Id 1356200',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 07:40:13','',''),(2309953,'1','150','771',329,'Retail Sale Id 1356208',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 07:40:46','',''),(2309966,'1','150','771',329,'Retail Sale Id 1356218',3597.44,0.00,0.00,5.84,373.76,'2021-12-18 07:41:32','',''),(2309976,'1','150','771',329,'Retail Sale Id 1356230',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:42:15','',''),(2309983,'1','150','771',329,'Retail Sale Id 1356236',997.92,0.00,0.00,1.62,103.68,'2021-12-18 07:43:17','',''),(2309993,'1','150','771',329,'Retail Sale Id 1356246',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 07:44:14','',''),(2310019,'1','150','771',329,'Retail Sale Id 1356252',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 07:44:55','',''),(2310030,'1','150','771',329,'Retail Sale Id 1356264',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 07:45:33','',''),(2310049,'1','150','771',329,'Retail Sale Id 1356269',3498.88,0.00,0.00,5.68,363.52,'2021-12-18 07:46:05','',''),(2310058,'1','150','771',329,'Retail Sale Id 1356277',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 07:46:52','',''),(2310066,'1','150','771',329,'Retail Sale Id 1356285',997.92,0.00,0.00,1.62,103.68,'2021-12-18 07:47:38','',''),(2310078,'1','150','771',329,'Retail Sale Id 1356295',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 07:48:22','',''),(2310088,'1','150','771',329,'Retail Sale Id 1356304',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 07:48:56','',''),(2310095,'1','150','771',329,'Retail Sale Id 1356308',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 07:49:47','',''),(2310110,'1','150','771',329,'Retail Sale Id 1356323',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 07:51:33','',''),(2310129,'1','150','771',329,'Retail Sale Id 1356340',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 07:53:18','',''),(2310137,'1','150','771',329,'Retail Sale Id 1356348',0.00,0.00,0.00,0.00,0.00,'2021-12-18 07:54:03','',''),(2312059,'1','150','771',329,'Retail Sale Id 1357958',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 10:34:20','',''),(2312075,'1','150','771',329,'Retail Sale Id 1357973',899.36,0.00,0.00,1.46,93.44,'2021-12-18 10:35:19','',''),(2312088,'1','150','771',329,'Retail Sale Id 1357985',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 10:36:07','',''),(2312098,'1','150','771',329,'Retail Sale Id 1357996',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 10:36:40','',''),(2312103,'1','150','771',329,'Retail Sale Id 1358000',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 10:37:07','',''),(2312112,'1','150','771',329,'Retail Sale Id 1358009',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 10:37:48','',''),(2312122,'1','150','771',329,'Retail Sale Id 1358019',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 10:38:55','',''),(2312133,'1','150','771',329,'Retail Sale Id 1358031',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 10:39:53','',''),(2312147,'1','150','771',329,'Retail Sale Id 1358043',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 10:40:54','',''),(2312155,'1','150','771',329,'Retail Sale Id 1358055',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 10:41:39','',''),(2312163,'1','150','771',329,'Retail Sale Id 1358061',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 10:42:16','',''),(2312171,'1','150','771',329,'Retail Sale Id 1358074',652.96,0.00,0.00,1.06,67.84,'2021-12-18 10:43:16','',''),(2312186,'1','150','771',329,'Retail Sale Id 1358087',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 10:44:15','',''),(2312194,'1','150','771',329,'Retail Sale Id 1358097',597.52,0.00,0.00,0.97,62.08,'2021-12-18 10:45:11','',''),(2312204,'1','150','771',329,'Retail Sale Id 1358104',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 10:45:51','',''),(2312205,'1','150','771',329,'Retail Sale Id 1358106',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 10:46:32','',''),(2312225,'1','150','771',329,'Retail Sale Id 1358127',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 10:48:28','',''),(2312269,'1','150','771',329,'Retail Sale Id 1358157',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 10:51:36','',''),(2312279,'1','150','771',329,'Retail Sale Id 1358166',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 10:52:11','',''),(2312292,'1','150','771',329,'Retail Sale Id 1358178',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 10:53:05','',''),(2312302,'1','150','771',329,'Retail Sale Id 1358187',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 10:53:47','',''),(2312306,'1','150','771',329,'Retail Sale Id 1358194',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 10:54:26','',''),(2312321,'1','150','771',329,'Retail Sale Id 1358206',652.96,0.00,0.00,1.06,67.84,'2021-12-18 10:55:31','',''),(2312381,'1','150','771',329,'Retail Sale Id 1358255',997.92,0.00,0.00,1.62,103.68,'2021-12-18 11:00:21','',''),(2312385,'1','150','771',329,'Retail Sale Id 1358262',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 11:00:51','',''),(2312389,'1','150','771',329,'Retail Sale Id 1358265',2297.68,0.00,0.00,3.73,238.72,'2021-12-18 11:01:29','',''),(2312400,'1','150','771',329,'Retail Sale Id 1358274',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 11:02:15','',''),(2312405,'1','150','771',329,'Retail Sale Id 1358279',997.92,0.00,0.00,1.62,103.68,'2021-12-18 11:02:43','',''),(2312413,'1','150','771',329,'Retail Sale Id 1358285',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 11:03:31','',''),(2312446,'1','150','771',329,'Retail Sale Id 1358309',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:05:52','',''),(2312465,'1','150','771',329,'Retail Sale Id 1358328',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 11:07:02','',''),(2312472,'1','150','771',329,'Retail Sale Id 1358335',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 11:07:36','',''),(2312478,'1','150','771',329,'Retail Sale Id 1358344',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:08:06','',''),(2312499,'1','150','771',329,'Retail Sale Id 1358363',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:09:49','',''),(2312511,'1','150','771',329,'Retail Sale Id 1358373',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 11:10:35','',''),(2312527,'1','150','771',329,'Retail Sale Id 1358382',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 11:11:17','',''),(2312542,'1','150','771',329,'Retail Sale Id 1358397',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 11:12:58','',''),(2312556,'1','150','771',329,'Retail Sale Id 1358402',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:13:46','',''),(2312580,'1','150','771',329,'Retail Sale Id 1358408',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 11:14:18','',''),(2312587,'1','150','771',329,'Retail Sale Id 1358417',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:15:02','',''),(2312654,'1','150','771',329,'Retail Sale Id 1358443',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 11:20:00','',''),(2312657,'1','150','771',329,'Retail Sale Id 1358471',1398.32,0.00,0.00,2.27,145.28,'2021-12-18 11:20:21','',''),(2312671,'1','150','771',329,'Retail Sale Id 1358483',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 11:21:37','',''),(2312702,'1','150','771',329,'Retail Sale Id 1358516',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 11:23:49','',''),(2312718,'1','150','771',329,'Retail Sale Id 1358537',3498.88,0.00,0.00,5.68,363.52,'2021-12-18 11:25:25','',''),(2312736,'1','150','771',329,'Retail Sale Id 1358548',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:26:40','',''),(2312765,'1','150','771',329,'Retail Sale Id 1358574',899.36,0.00,0.00,1.46,93.44,'2021-12-18 11:29:01','',''),(2312777,'1','150','771',329,'Retail Sale Id 1358587',498.96,0.00,0.00,0.81,51.84,'2021-12-18 11:30:10','',''),(2312796,'1','150','771',329,'Retail Sale Id 1358606',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 11:31:11','',''),(2312805,'1','150','771',329,'Retail Sale Id 1358615',3498.88,0.00,0.00,5.68,363.52,'2021-12-18 11:31:53','',''),(2312841,'1','150','771',329,'Retail Sale Id 1358652',997.92,0.00,0.00,1.62,103.68,'2021-12-18 11:35:15','',''),(2312859,'1','150','771',329,'Retail Sale Id 1358671',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:36:41','',''),(2312881,'1','150','771',329,'Retail Sale Id 1358692',997.92,0.00,0.00,1.62,103.68,'2021-12-18 11:38:27','',''),(2312913,'1','150','771',329,'Retail Sale Id 1358725',800.80,0.00,0.00,1.30,83.20,'2021-12-18 11:41:33','',''),(2312935,'1','150','771',329,'Retail Sale Id 1358748',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 11:43:48','',''),(2312942,'1','150','771',329,'Retail Sale Id 1358755',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 11:44:40','',''),(2312972,'1','150','771',329,'Retail Sale Id 1358782',800.80,0.00,0.00,1.30,83.20,'2021-12-18 11:47:54','',''),(2312979,'1','150','771',329,'Retail Sale Id 1358786',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 11:48:54','',''),(2312986,'1','150','771',329,'Retail Sale Id 1358794',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 11:49:54','',''),(2312991,'1','150','771',329,'Retail Sale Id 1358798',997.92,0.00,0.00,1.62,103.68,'2021-12-18 11:50:32','',''),(2313021,'1','150','771',329,'Retail Sale Id 1358833',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 11:54:47','',''),(2313031,'1','150','771',329,'Retail Sale Id 1358839',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 11:55:45','',''),(2313061,'1','150','771',329,'Retail Sale Id 1358864',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 11:59:39','',''),(2313067,'1','150','771',329,'Retail Sale Id 1358868',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 12:00:25','',''),(2313074,'1','150','771',329,'Retail Sale Id 1358875',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 12:01:08','',''),(2313075,'1','150','771',329,'Retail Sale Id 1358878',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 12:01:50','',''),(2313086,'1','150','771',329,'Retail Sale Id 1358887',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 12:02:52','',''),(2313091,'1','150','771',329,'Retail Sale Id 1358891',997.92,0.00,0.00,1.62,103.68,'2021-12-18 12:03:29','',''),(2313099,'1','150','771',329,'Retail Sale Id 1358899',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 12:04:15','',''),(2313113,'1','150','771',329,'Retail Sale Id 1358913',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 12:05:36','',''),(2313127,'1','150','771',329,'Retail Sale Id 1358925',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 12:06:59','',''),(2313145,'1','150','771',329,'Retail Sale Id 1358944',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 12:09:02','',''),(2313152,'1','150','771',329,'Retail Sale Id 1358949',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 12:09:58','',''),(2313190,'1','150','771',329,'Retail Sale Id 1358990',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 12:12:56','',''),(2313213,'1','150','771',329,'Retail Sale Id 1359005',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 12:14:31','',''),(2313299,'1','150','771',329,'Retail Sale Id 1359095',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 12:25:01','',''),(2313313,'1','150','771',329,'Retail Sale Id 1359105',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 12:26:06','',''),(2313320,'1','150','771',329,'Retail Sale Id 1359112',702.24,0.00,0.00,1.14,72.96,'2021-12-18 12:26:52','',''),(2313324,'1','150','771',329,'Retail Sale Id 1359117',800.80,0.00,0.00,1.30,83.20,'2021-12-18 12:27:35','',''),(2313331,'1','150','771',329,'Retail Sale Id 1359128',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 12:28:52','',''),(2313343,'1','150','771',329,'Retail Sale Id 1359136',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 12:29:27','',''),(2313395,'1','150','771',329,'Retail Sale Id 1359187',498.96,0.00,0.00,0.81,51.84,'2021-12-18 12:35:51','',''),(2313408,'1','150','771',329,'Retail Sale Id 1359201',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 12:37:35','',''),(2313448,'1','150','771',329,'Retail Sale Id 1359224',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 12:39:34','',''),(2313475,'1','150','771',329,'Retail Sale Id 1359243',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 12:41:31','',''),(2313510,'1','150','771',329,'Retail Sale Id 1359280',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 12:44:50','',''),(2313521,'1','150','771',329,'Retail Sale Id 1359292',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 12:45:50','',''),(2313530,'1','150','771',329,'Retail Sale Id 1359306',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 12:46:49','',''),(2313547,'1','150','771',329,'Retail Sale Id 1359319',997.92,0.00,0.00,1.62,103.68,'2021-12-18 12:48:34','',''),(2313578,'1','150','771',329,'Retail Sale Id 1359352',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 12:51:46','',''),(2313589,'1','150','771',329,'Retail Sale Id 1359362',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 12:52:26','',''),(2313605,'1','150','771',329,'Retail Sale Id 1359373',4502.96,0.00,0.00,7.31,467.84,'2021-12-18 12:53:30','',''),(2313611,'1','150','771',329,'Retail Sale Id 1359383',997.92,0.00,0.00,1.62,103.68,'2021-12-18 12:54:05','',''),(2313619,'1','150','771',329,'Retail Sale Id 1359392',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 12:54:51','',''),(2313627,'1','150','771',329,'Retail Sale Id 1359396',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 12:55:28','',''),(2313680,'1','150','771',329,'Retail Sale Id 1359448',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 13:00:09','',''),(2313688,'1','150','771',329,'Retail Sale Id 1359455',997.92,0.00,0.00,1.62,103.68,'2021-12-18 13:00:54','',''),(2313694,'1','150','771',329,'Retail Sale Id 1359464',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 13:01:27','',''),(2313712,'1','150','771',329,'Retail Sale Id 1359483',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 13:03:40','',''),(2313723,'1','150','771',329,'Retail Sale Id 1359496',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 13:04:53','',''),(2313734,'1','150','771',329,'Retail Sale Id 1359503',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 13:05:24','',''),(2313741,'1','150','771',329,'Retail Sale Id 1359508',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 13:06:04','',''),(2313800,'1','150','771',329,'Retail Sale Id 1359542',11500.72,0.00,0.00,18.67,1194.88,'2021-12-18 13:11:08','',''),(2313843,'1','150','771',329,'Retail Sale Id 1359578',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 13:14:56','',''),(2313854,'1','150','771',329,'Retail Sale Id 1359594',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 13:16:14','',''),(2313865,'1','150','771',329,'Retail Sale Id 1359604',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 13:16:58','',''),(2313869,'1','150','771',329,'Retail Sale Id 1359609',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 13:17:35','',''),(2313877,'1','150','771',329,'Retail Sale Id 1359617',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 13:18:21','',''),(2313959,'1','150','771',329,'Retail Sale Id 1359671',3997.84,0.00,0.00,6.49,415.36,'2021-12-18 13:24:31','',''),(2313991,'1','150','771',329,'Retail Sale Id 1359702',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 13:28:00','',''),(2314001,'1','150','771',329,'Retail Sale Id 1359715',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 13:29:22','',''),(2314007,'1','150','771',329,'Retail Sale Id 1359719',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 13:30:17','',''),(2314012,'1','150','771',329,'Retail Sale Id 1359725',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 13:31:00','',''),(2314080,'1','150','771',329,'Retail Sale Id 1359800',597.52,0.00,0.00,0.97,62.08,'2021-12-18 13:38:58','',''),(2314086,'1','150','771',329,'Retail Sale Id 1359805',702.24,0.00,0.00,1.14,72.96,'2021-12-18 13:39:37','',''),(2314112,'1','150','771',329,'Retail Sale Id 1359831',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 13:41:42','',''),(2314186,'1','150','771',329,'Retail Sale Id 1359878',997.92,0.00,0.00,1.62,103.68,'2021-12-18 13:47:15','',''),(2314214,'1','150','771',329,'Retail Sale Id 1359889',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 13:48:14','',''),(2314232,'1','150','771',329,'Retail Sale Id 1359898',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 13:48:44','',''),(2314265,'1','150','771',329,'Retail Sale Id 1359912',5001.92,0.00,0.00,8.12,519.68,'2021-12-18 13:49:29','',''),(2314281,'1','150','771',329,'Retail Sale Id 1359922',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 13:50:39','',''),(2314315,'1','150','771',329,'Retail Sale Id 1359935',400.40,0.00,0.00,0.65,41.60,'2021-12-18 13:51:59','',''),(2314434,'1','150','771',329,'Retail Sale Id 1360028',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 14:01:00','',''),(2314565,'1','150','771',329,'Retail Sale Id 1360143',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 14:11:12','',''),(2314571,'1','150','771',329,'Retail Sale Id 1360152',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 14:11:49','',''),(2314738,'1','150','771',329,'Retail Sale Id 1360292',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 14:26:20','',''),(2314743,'1','150','771',329,'Retail Sale Id 1360297',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 14:27:01','',''),(2314749,'1','150','771',329,'Retail Sale Id 1360304',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 14:27:22','',''),(2314757,'1','150','771',329,'Retail Sale Id 1360312',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 14:28:04','',''),(2314773,'1','150','771',329,'Retail Sale Id 1360318',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 14:28:41','',''),(2314779,'1','150','771',329,'Retail Sale Id 1360322',2500.96,0.00,0.00,4.06,259.84,'2021-12-18 14:29:10','',''),(2314786,'1','150','771',329,'Retail Sale Id 1360330',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 14:29:40','',''),(2314795,'1','150','771',329,'Retail Sale Id 1360339',0.00,0.00,0.00,0.00,0.00,'2021-12-18 14:30:31','',''),(2314804,'1','150','771',329,'Retail Sale Id 1360348',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 14:31:41','',''),(2315044,'1','150','771',329,'Retail Sale Id 1360535',997.92,0.00,0.00,1.62,103.68,'2021-12-18 14:50:10','',''),(2315055,'1','150','771',329,'Retail Sale Id 1360547',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 14:51:16','',''),(2315061,'1','150','771',329,'Retail Sale Id 1360553',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 14:51:47','',''),(2315163,'1','150','771',329,'Retail Sale Id 1360643',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 15:00:42','',''),(2315172,'1','150','771',329,'Retail Sale Id 1360653',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 15:01:43','',''),(2315182,'1','150','771',329,'Retail Sale Id 1360664',1398.32,0.00,0.00,2.27,145.28,'2021-12-18 15:02:26','',''),(2315206,'1','150','771',329,'Retail Sale Id 1360694',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 15:04:46','',''),(2315212,'1','150','771',329,'Retail Sale Id 1360698',6997.76,0.00,0.00,11.36,727.04,'2021-12-18 15:05:24','',''),(2315226,'1','150','771',329,'Retail Sale Id 1360702',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 15:05:56','',''),(2315407,'1','150','771',329,'Retail Sale Id 1360847',2002.00,0.00,0.00,3.25,208.00,'2021-12-18 15:21:17','',''),(2315419,'1','150','771',329,'Retail Sale Id 1360862',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 15:22:21','',''),(2315434,'1','150','771',329,'Retail Sale Id 1360875',997.92,0.00,0.00,1.62,103.68,'2021-12-18 15:23:18','',''),(2315474,'1','150','771',329,'Retail Sale Id 1360909',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 15:26:02','',''),(2315491,'1','150','771',329,'Retail Sale Id 1360921',1299.76,0.00,0.00,2.11,135.04,'2021-12-18 15:27:47','',''),(2315522,'1','150','771',329,'Retail Sale Id 1360951',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 15:30:12','',''),(2315563,'1','150','771',329,'Retail Sale Id 1360989',2999.92,0.00,0.00,4.87,311.68,'2021-12-18 15:33:31','',''),(2315571,'1','150','771',329,'Retail Sale Id 1360999',1503.04,0.00,0.00,2.44,156.16,'2021-12-18 15:34:11','',''),(2315624,'1','150','771',329,'Retail Sale Id 1361042',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 15:38:10','',''),(2315651,'1','150','771',329,'Retail Sale Id 1361071',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 15:40:10','',''),(2315686,'1','150','771',329,'Retail Sale Id 1361116',1897.28,0.00,0.00,3.08,197.12,'2021-12-18 15:43:09','',''),(2315773,'1','150','771',329,'Retail Sale Id 1361136',92498.56,0.00,0.00,150.16,9610.24,'2021-12-18 15:48:51','',''),(2315959,'1','150','771',329,'Retail Sale Id 1361221',3800.72,0.00,0.00,6.17,394.88,'2021-12-18 15:57:16','',''),(2316501,'1','150','771',329,'Retail Sale Id 1361804',7700.00,0.00,0.00,12.50,800.00,'2021-12-18 16:34:52','',''),(2316608,'1','150','771',329,'Retail Sale Id 1361844',6196.96,0.00,0.00,10.06,643.84,'2021-12-18 16:43:33','',''),(2316739,'1','150','771',329,'Retail Sale Id 1362014',3098.48,0.00,0.00,5.03,321.92,'2021-12-18 16:53:42','',''),(2316795,'1','150','771',329,'Retail Sale Id 1362069',15400.00,0.00,0.00,25.00,1600.00,'2021-12-18 16:57:30','',''),(2316881,'1','150','771',329,'Retail Sale Id 1362167',498.96,0.00,0.00,0.81,51.84,'2021-12-18 17:05:09','',''),(2317451,'1','150','771',329,'Retail Sale Id 1362659',575830.64,0.00,0.00,934.79,59826.56,'2021-12-18 18:36:31','',''),(2317854,'1','150','771',329,'Retail Sale Id 1362762',6997.76,0.00,0.00,11.36,727.04,'2021-12-19 05:57:56','',''),(2317860,'1','150','771',329,'Retail Sale Id 1362768',997.92,0.00,0.00,1.62,103.68,'2021-12-19 06:00:06','',''),(2317864,'1','150','771',329,'Retail Sale Id 1362771',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 06:00:47','',''),(2317867,'1','150','771',329,'Retail Sale Id 1362774',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 06:01:29','',''),(2317870,'1','150','771',329,'Retail Sale Id 1362777',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 06:02:27','',''),(2317871,'1','150','771',329,'Retail Sale Id 1362779',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 06:03:06','',''),(2317873,'1','150','771',329,'Retail Sale Id 1362781',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 06:03:36','',''),(2317876,'1','150','771',329,'Retail Sale Id 1362783',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 06:04:21','',''),(2317877,'1','150','771',329,'Retail Sale Id 1362784',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 06:04:51','',''),(2317878,'1','150','771',329,'Retail Sale Id 1362787',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 06:05:31','',''),(2317884,'1','150','771',329,'Retail Sale Id 1362789',997.92,0.00,0.00,1.62,103.68,'2021-12-19 06:06:15','',''),(2317895,'1','150','771',329,'Retail Sale Id 1362800',1299.76,0.00,0.00,2.11,135.04,'2021-12-19 06:11:12','',''),(2317897,'1','150','771',329,'Retail Sale Id 1362802',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 06:12:06','',''),(2317902,'1','150','771',329,'Retail Sale Id 1362806',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 06:13:35','',''),(2317905,'1','150','771',329,'Retail Sale Id 1362810',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 06:14:24','',''),(2317925,'1','150','771',329,'Retail Sale Id 1362825',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 06:19:35','',''),(2317927,'1','150','771',329,'Retail Sale Id 1362827',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 06:20:21','',''),(2318241,'1','150','771',329,'Retail Sale Id 1362941',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 06:55:41','',''),(2318250,'1','150','771',329,'Retail Sale Id 1363041',18498.48,0.00,0.00,30.03,1921.92,'2021-12-19 06:56:53','',''),(2319278,'1','150','771',329,'Retail Sale Id 1363915',18208.96,0.00,0.00,29.56,1891.84,'2021-12-19 08:26:56','',''),(2319327,'1','150','771',329,'Retail Sale Id 1363964',0.00,0.00,0.00,0.00,0.00,'2021-12-19 08:30:59','',''),(2319696,'1','150','771',329,'Retail Sale Id 1364222',5001.92,0.00,0.00,8.12,519.68,'2021-12-19 09:02:55','',''),(2319703,'1','150','771',329,'Retail Sale Id 1364233',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 09:04:01','',''),(2319710,'1','150','771',329,'Retail Sale Id 1364240',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 09:05:03','',''),(2319713,'1','150','771',329,'Retail Sale Id 1364244',1299.76,0.00,0.00,2.11,135.04,'2021-12-19 09:05:43','',''),(2319727,'1','150','771',329,'Retail Sale Id 1364253',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:07:10','',''),(2319746,'1','150','771',329,'Retail Sale Id 1364264',997.92,0.00,0.00,1.62,103.68,'2021-12-19 09:08:04','',''),(2319759,'1','150','771',329,'Retail Sale Id 1364276',702.24,0.00,0.00,1.14,72.96,'2021-12-19 09:10:01','',''),(2319779,'1','150','771',329,'Retail Sale Id 1364291',2100.56,0.00,0.00,3.41,218.24,'2021-12-19 09:11:24','',''),(2319867,'1','150','771',329,'Retail Sale Id 1364341',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:16:59','',''),(2319885,'1','150','771',329,'Retail Sale Id 1364350',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 09:17:51','',''),(2320028,'1','150','771',329,'Retail Sale Id 1364418',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 09:23:29','',''),(2320055,'1','150','771',329,'Retail Sale Id 1364434',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 09:24:28','',''),(2320141,'1','150','771',329,'Retail Sale Id 1364477',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 09:28:36','',''),(2320184,'1','150','771',329,'Retail Sale Id 1364502',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 09:30:39','',''),(2320193,'1','150','771',329,'Retail Sale Id 1364510',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 09:31:25','',''),(2320204,'1','150','771',329,'Retail Sale Id 1364523',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 09:32:10','',''),(2320217,'1','150','771',329,'Retail Sale Id 1364535',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:32:50','',''),(2320228,'1','150','771',329,'Retail Sale Id 1364545',702.24,0.00,0.00,1.14,72.96,'2021-12-19 09:33:43','',''),(2320241,'1','150','771',329,'Retail Sale Id 1364563',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 09:34:57','',''),(2320252,'1','150','771',329,'Retail Sale Id 1364574',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 09:35:53','',''),(2320268,'1','150','771',329,'Retail Sale Id 1364588',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:37:14','',''),(2320274,'1','150','771',329,'Retail Sale Id 1364597',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:37:49','',''),(2320287,'1','150','771',329,'Retail Sale Id 1364612',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 09:38:52','',''),(2320296,'1','150','771',329,'Retail Sale Id 1364619',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 09:39:24','',''),(2320303,'1','150','771',329,'Retail Sale Id 1364626',5001.92,0.00,0.00,8.12,519.68,'2021-12-19 09:39:54','',''),(2320315,'1','150','771',329,'Retail Sale Id 1364639',15400.00,0.00,0.00,25.00,1600.00,'2021-12-19 09:40:33','',''),(2320326,'1','150','771',329,'Retail Sale Id 1364647',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 09:41:33','',''),(2320333,'1','150','771',329,'Retail Sale Id 1364656',997.92,0.00,0.00,1.62,103.68,'2021-12-19 09:41:59','',''),(2320338,'1','150','771',329,'Retail Sale Id 1364660',1299.76,0.00,0.00,2.11,135.04,'2021-12-19 09:42:25','',''),(2320346,'1','150','771',329,'Retail Sale Id 1364668',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 09:43:07','',''),(2320359,'1','150','771',329,'Retail Sale Id 1364680',6196.96,0.00,0.00,10.06,643.84,'2021-12-19 09:44:13','',''),(2320365,'1','150','771',329,'Retail Sale Id 1364687',15400.00,0.00,0.00,25.00,1600.00,'2021-12-19 09:45:03','',''),(2320375,'1','150','771',329,'Retail Sale Id 1364695',18498.48,0.00,0.00,30.03,1921.92,'2021-12-19 09:45:57','',''),(2320392,'1','150','771',329,'Retail Sale Id 1364711',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 09:47:54','',''),(2320424,'1','150','771',329,'Retail Sale Id 1364747',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 09:50:54','',''),(2320477,'1','150','771',329,'Retail Sale Id 1364800',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 09:55:37','',''),(2320512,'1','150','771',329,'Retail Sale Id 1364834',997.92,0.00,0.00,1.62,103.68,'2021-12-19 09:58:30','',''),(2320539,'1','150','771',329,'Retail Sale Id 1364863',997.92,0.00,0.00,1.62,103.68,'2021-12-19 10:00:44','',''),(2320609,'1','150','771',329,'Retail Sale Id 1364933',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 10:06:18','',''),(2320631,'1','150','771',329,'Retail Sale Id 1364955',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 10:07:53','',''),(2320651,'1','150','771',329,'Retail Sale Id 1364977',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 10:09:53','',''),(2320663,'1','150','771',329,'Retail Sale Id 1364987',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 10:10:44','',''),(2320684,'1','150','771',329,'Retail Sale Id 1365000',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 10:11:40','',''),(2320709,'1','150','771',329,'Retail Sale Id 1365019',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 10:12:41','',''),(2320739,'1','150','771',329,'Retail Sale Id 1365055',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 10:15:19','',''),(2320756,'1','150','771',329,'Retail Sale Id 1365071',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 10:16:52','',''),(2320772,'1','150','771',329,'Retail Sale Id 1365081',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:18:05','',''),(2320788,'1','150','771',329,'Retail Sale Id 1365103',12701.92,0.00,0.00,20.62,1319.68,'2021-12-19 10:19:42','',''),(2320795,'1','150','771',329,'Retail Sale Id 1365110',702.24,0.00,0.00,1.14,72.96,'2021-12-19 10:20:15','',''),(2320857,'1','150','771',329,'Retail Sale Id 1365167',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 10:25:08','',''),(2320877,'1','150','771',329,'Retail Sale Id 1365186',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 10:26:40','',''),(2320888,'1','150','771',329,'Retail Sale Id 1365198',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 10:27:33','',''),(2320898,'1','150','771',329,'Retail Sale Id 1365208',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 10:28:31','',''),(2320913,'1','150','771',329,'Retail Sale Id 1365222',30800.00,0.00,0.00,50.00,3200.00,'2021-12-19 10:29:14','',''),(2320929,'1','150','771',329,'Retail Sale Id 1365231',15400.00,0.00,0.00,25.00,1600.00,'2021-12-19 10:29:43','',''),(2320935,'1','150','771',329,'Retail Sale Id 1365234',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:30:32','',''),(2320975,'1','150','771',329,'Retail Sale Id 1365278',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 10:34:10','',''),(2320984,'1','150','771',329,'Retail Sale Id 1365289',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:35:06','',''),(2320988,'1','150','771',329,'Retail Sale Id 1365293',997.92,0.00,0.00,1.62,103.68,'2021-12-19 10:35:46','',''),(2321000,'1','150','771',329,'Retail Sale Id 1365303',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:36:46','',''),(2321057,'1','150','771',329,'Retail Sale Id 1365362',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 10:42:01','',''),(2321080,'1','150','771',329,'Retail Sale Id 1365382',5901.28,0.00,0.00,9.58,613.12,'2021-12-19 10:44:18','',''),(2321112,'1','150','771',329,'Retail Sale Id 1365419',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 10:47:49','',''),(2321117,'1','150','771',329,'Retail Sale Id 1365425',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 10:48:27','',''),(2321145,'1','150','771',329,'Retail Sale Id 1365450',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 10:50:24','',''),(2321155,'1','150','771',329,'Retail Sale Id 1365461',1299.76,0.00,0.00,2.11,135.04,'2021-12-19 10:51:13','',''),(2321229,'1','150','771',329,'Retail Sale Id 1365539',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:57:45','',''),(2321241,'1','150','771',329,'Retail Sale Id 1365552',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 10:58:36','',''),(2321252,'1','150','771',329,'Retail Sale Id 1365564',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 10:59:30','',''),(2321263,'1','150','771',329,'Retail Sale Id 1365576',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 11:00:27','',''),(2321280,'1','150','771',329,'Retail Sale Id 1365590',3098.48,0.00,0.00,5.03,321.92,'2021-12-19 11:01:42','',''),(2321286,'1','150','771',329,'Retail Sale Id 1365598',997.92,0.00,0.00,1.62,103.68,'2021-12-19 11:02:16','',''),(2321293,'1','150','771',329,'Retail Sale Id 1365606',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 11:02:47','',''),(2321298,'1','150','771',329,'Retail Sale Id 1365611',997.92,0.00,0.00,1.62,103.68,'2021-12-19 11:03:24','',''),(2321339,'1','150','771',329,'Retail Sale Id 1365651',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 11:06:53','',''),(2321350,'1','150','771',329,'Retail Sale Id 1365661',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 11:07:33','',''),(2321363,'1','150','771',329,'Retail Sale Id 1365675',702.24,0.00,0.00,1.14,72.96,'2021-12-19 11:08:32','',''),(2321386,'1','150','771',329,'Retail Sale Id 1365695',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 11:10:11','',''),(2321436,'1','150','771',329,'Retail Sale Id 1365728',2500.96,0.00,0.00,4.06,259.84,'2021-12-19 11:12:50','',''),(2321440,'1','150','771',329,'Retail Sale Id 1365733',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 11:13:33','',''),(2321463,'1','150','771',329,'Retail Sale Id 1365748',2999.92,0.00,0.00,4.87,311.68,'2021-12-19 11:15:00','',''),(2321483,'1','150','771',329,'Retail Sale Id 1365774',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 11:16:37','',''),(2321498,'1','150','771',329,'Retail Sale Id 1365791',6997.76,0.00,0.00,11.36,727.04,'2021-12-19 11:18:12','',''),(2321554,'1','150','771',329,'Retail Sale Id 1365843',3800.72,0.00,0.00,6.17,394.88,'2021-12-19 11:22:45','',''),(2321563,'1','150','771',329,'Retail Sale Id 1365853',1897.28,0.00,0.00,3.08,197.12,'2021-12-19 11:23:36','',''),(2321573,'1','150','771',329,'Retail Sale Id 1365862',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 11:24:24','',''),(2321607,'1','150','771',329,'Retail Sale Id 1365889',1503.04,0.00,0.00,2.44,156.16,'2021-12-19 11:26:32','',''),(2321616,'1','150','771',329,'Retail Sale Id 1365901',2002.00,0.00,0.00,3.25,208.00,'2021-12-19 11:27:13','',''),(2321629,'1','150','771',329,'Retail Sale Id 1365912',997.92,0.00,0.00,1.62,103.68,'2021-12-19 11:28:13','',''),(2321644,'1','150','771',329,'Retail Sale Id 1365926',1299.76,0.00,0.00,2.11,135.04,'2021-12-19 11:29:36','',''),(2321656,'1','150','771',329,'Retail Sale Id 1365938',7700.00,0.00,0.00,12.50,800.00,'2021-12-19 11:30:40','',''),(2321687,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,2572380.00,4610.00,0.00,0.00,'2021-12-19 11:33:43','',''),(2321697,'1','150',NULL,329,'Reception corrector for bridging 127965',0.00,0.00,0.00,4610.00,0.00,'2021-12-19 11:34:46','',''),(2321698,'1','150','771',329,'Received from bridging 127965',0.00,0.00,4610.00,0.00,0.00,'2021-12-19 11:34:46','',''),(2321775,'1','150','771',329,'Retail Sale Id 1366037',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 11:41:34','',''),(2321781,'1','150','771',329,'Retail Sale Id 1366042',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 11:42:06','',''),(2321790,'1','150','771',329,'Retail Sale Id 1366050',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 11:42:43','',''),(2321798,'1','150','771',329,'Retail Sale Id 1366056',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 11:43:20','',''),(2321816,'1','150','771',329,'Retail Sale Id 1366074',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 11:44:38','',''),(2321827,'1','150','771',329,'Retail Sale Id 1366086',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 11:45:29','',''),(2321834,'1','150','771',329,'Retail Sale Id 1366092',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 11:46:15','',''),(2321854,'1','150','771',329,'Retail Sale Id 1366110',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 11:47:37','',''),(2321890,'1','150','771',329,'Retail Sale Id 1366146',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 11:50:47','',''),(2321908,'1','150','771',329,'Retail Sale Id 1366167',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 11:52:11','',''),(2321919,'1','150','771',329,'Retail Sale Id 1366177',997.92,0.00,0.00,1.62,93.96,'2021-12-19 11:53:00','',''),(2321933,'1','150','771',329,'Retail Sale Id 1366190',498.96,0.00,0.00,0.81,46.98,'2021-12-19 11:54:03','',''),(2321942,'1','150','771',329,'Retail Sale Id 1366199',997.92,0.00,0.00,1.62,93.96,'2021-12-19 11:54:57','',''),(2321947,'1','150','771',329,'Retail Sale Id 1366205',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 11:55:26','',''),(2321959,'1','150','771',329,'Retail Sale Id 1366214',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 11:56:20','',''),(2321970,'1','150','771',329,'Retail Sale Id 1366225',1201.20,0.00,0.00,1.95,113.10,'2021-12-19 11:57:02','',''),(2321976,'1','150','771',329,'Retail Sale Id 1366232',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 11:57:42','',''),(2321981,'1','150','771',329,'Retail Sale Id 1366236',6997.76,0.00,0.00,11.36,658.88,'2021-12-19 11:58:33','',''),(2321991,'1','150','771',329,'Retail Sale Id 1366247',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 11:59:20','',''),(2322006,'1','150','771',329,'Retail Sale Id 1366262',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 12:00:39','',''),(2322027,'1','150','771',329,'Retail Sale Id 1366291',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 12:02:20','',''),(2322042,'1','150','771',329,'Retail Sale Id 1366299',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:03:34','',''),(2322043,'1','150','771',329,'Retail Sale Id 1366304',997.92,0.00,0.00,1.62,93.96,'2021-12-19 12:03:53','',''),(2322058,'1','150','771',329,'Retail Sale Id 1366316',15400.00,0.00,0.00,25.00,1450.00,'2021-12-19 12:04:53','',''),(2322063,'1','150','771',329,'Retail Sale Id 1366320',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 12:05:30','',''),(2322077,'1','150','771',329,'Retail Sale Id 1366335',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 12:07:02','',''),(2322086,'1','150','771',329,'Retail Sale Id 1366346',15400.00,0.00,0.00,25.00,1450.00,'2021-12-19 12:07:45','',''),(2322096,'1','150','771',329,'Retail Sale Id 1366353',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 12:08:35','',''),(2322103,'1','150','771',329,'Retail Sale Id 1366358',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 12:09:16','',''),(2322110,'1','150','771',329,'Retail Sale Id 1366364',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 12:10:08','',''),(2322118,'1','150','771',329,'Retail Sale Id 1366372',2802.80,0.00,0.00,4.55,263.90,'2021-12-19 12:10:48','',''),(2322126,'1','150','771',329,'Retail Sale Id 1366379',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 12:11:21','',''),(2322137,'1','150','771',329,'Retail Sale Id 1366389',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 12:12:14','',''),(2322167,'1','150','771',329,'Retail Sale Id 1366408',997.92,0.00,0.00,1.62,93.96,'2021-12-19 12:14:51','',''),(2322236,'1','150','771',329,'Retail Sale Id 1366492',7601.44,0.00,0.00,12.34,715.72,'2021-12-19 12:20:46','',''),(2322246,'1','150','771',329,'Retail Sale Id 1366505',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 12:21:40','',''),(2322256,'1','150','771',329,'Retail Sale Id 1366513',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 12:22:53','',''),(2322292,'1','150','771',329,'Retail Sale Id 1366549',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:27:09','',''),(2322316,'1','150','771',329,'Retail Sale Id 1366573',2599.52,0.00,0.00,4.22,244.76,'2021-12-19 12:29:27','',''),(2322360,'1','150','771',329,'Retail Sale Id 1366615',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 12:34:29','',''),(2322370,'1','150','771',329,'Retail Sale Id 1366624',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:35:26','',''),(2322391,'1','150','771',329,'Retail Sale Id 1366650',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 12:38:19','',''),(2322399,'1','150','771',329,'Retail Sale Id 1366658',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 12:39:13','',''),(2322426,'1','150','771',329,'Retail Sale Id 1366671',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:40:56','',''),(2322435,'1','150','771',329,'Retail Sale Id 1366678',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 12:41:49','',''),(2322442,'1','150','771',329,'Retail Sale Id 1366685',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 12:42:41','',''),(2322451,'1','150','771',329,'Retail Sale Id 1366694',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 12:43:40','',''),(2322466,'1','150','771',329,'Retail Sale Id 1366710',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 12:45:01','',''),(2322479,'1','150','771',329,'Retail Sale Id 1366719',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:45:50','',''),(2322511,'1','150','771',329,'Retail Sale Id 1366735',6196.96,0.00,0.00,10.06,583.48,'2021-12-19 12:47:16','',''),(2322526,'1','150','771',329,'Retail Sale Id 1366753',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 12:48:27','',''),(2322559,'1','150','771',329,'Retail Sale Id 1366777',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 12:50:42','',''),(2322575,'1','150','771',329,'Retail Sale Id 1366792',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 12:52:24','',''),(2322610,'1','150','771',329,'Retail Sale Id 1366834',997.92,0.00,0.00,1.62,93.96,'2021-12-19 12:55:19','',''),(2322619,'1','150','771',329,'Retail Sale Id 1366843',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 12:56:08','',''),(2322633,'1','150','771',329,'Retail Sale Id 1366862',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 12:57:43','',''),(2322644,'1','150','771',329,'Retail Sale Id 1366873',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 12:58:34','',''),(2322691,'1','150','771',329,'Retail Sale Id 1366910',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 13:02:17','',''),(2322700,'1','150','771',329,'Retail Sale Id 1366921',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:03:13','',''),(2322703,'1','150','771',329,'Retail Sale Id 1366924',5999.84,0.00,0.00,9.74,564.92,'2021-12-19 13:03:55','',''),(2322711,'1','150','771',329,'Retail Sale Id 1366932',997.92,0.00,0.00,1.62,93.96,'2021-12-19 13:04:49','',''),(2322720,'1','150','771',329,'Retail Sale Id 1366938',1700.16,0.00,0.00,2.76,160.08,'2021-12-19 13:05:41','',''),(2322727,'1','150','771',329,'Retail Sale Id 1366948',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:06:33','',''),(2322734,'1','150','771',329,'Retail Sale Id 1366955',10502.80,0.00,0.00,17.05,988.90,'2021-12-19 13:07:21','',''),(2322746,'1','150','771',329,'Retail Sale Id 1366967',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:08:17','',''),(2322758,'1','150','771',329,'Retail Sale Id 1366982',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 13:09:45','',''),(2322777,'1','150','771',329,'Retail Sale Id 1366994',997.92,0.00,0.00,1.62,93.96,'2021-12-19 13:10:47','',''),(2322784,'1','150','771',329,'Retail Sale Id 1367003',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 13:11:17','',''),(2322817,'1','150','771',329,'Retail Sale Id 1367030',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:14:51','',''),(2322838,'1','150','771',329,'Retail Sale Id 1367053',5001.92,0.00,0.00,8.12,470.96,'2021-12-19 13:16:45','',''),(2322857,'1','150','771',329,'Retail Sale Id 1367069',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:18:34','',''),(2322873,'1','150','771',329,'Retail Sale Id 1367084',800.80,0.00,0.00,1.30,75.40,'2021-12-19 13:20:01','',''),(2322883,'1','150','771',329,'Retail Sale Id 1367092',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:20:55','',''),(2322900,'1','150','771',329,'Retail Sale Id 1367111',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:22:36','',''),(2322923,'1','150','771',329,'Retail Sale Id 1367130',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:24:06','',''),(2322928,'1','150','771',329,'Retail Sale Id 1367136',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 13:24:31','',''),(2322945,'1','150','771',329,'Retail Sale Id 1367151',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 13:25:34','',''),(2322951,'1','150','771',329,'Retail Sale Id 1367157',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:26:09','',''),(2322992,'1','150','771',329,'Retail Sale Id 1367184',4798.64,0.00,0.00,7.79,451.82,'2021-12-19 13:29:27','',''),(2323002,'1','150','771',329,'Retail Sale Id 1367192',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 13:30:03','',''),(2323010,'1','150','771',329,'Retail Sale Id 1367198',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:30:57','',''),(2323032,'1','150','771',329,'Retail Sale Id 1367211',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 13:32:04','',''),(2323046,'1','150','771',329,'Retail Sale Id 1367223',4502.96,0.00,0.00,7.31,423.98,'2021-12-19 13:32:50','',''),(2323060,'1','150','771',329,'Retail Sale Id 1367232',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:33:36','',''),(2323098,'1','150','771',329,'Retail Sale Id 1367257',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 13:35:59','',''),(2323116,'1','150','771',329,'Retail Sale Id 1367274',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 13:37:39','',''),(2323127,'1','150','771',329,'Retail Sale Id 1367283',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 13:38:49','',''),(2323134,'1','150','771',329,'Retail Sale Id 1367292',5248.32,0.00,0.00,8.52,494.16,'2021-12-19 13:39:18','',''),(2323142,'1','150','771',329,'Retail Sale Id 1367297',3850.00,0.00,0.00,6.25,362.50,'2021-12-19 13:40:07','',''),(2323160,'1','150','771',329,'Retail Sale Id 1367306',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 13:40:48','',''),(2323231,'1','150','771',329,'Retail Sale Id 1367351',702.24,0.00,0.00,1.14,66.12,'2021-12-19 13:45:33','',''),(2323264,'1','150','771',329,'Retail Sale Id 1367384',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 13:49:26','',''),(2323304,'1','150','771',329,'Retail Sale Id 1367410',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 13:51:45','',''),(2323497,'1','150','771',329,'Retail Sale Id 1367578',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 14:04:40','',''),(2323513,'1','150','771',329,'Retail Sale Id 1367595',7502.88,0.00,0.00,12.18,706.44,'2021-12-19 14:05:41','',''),(2323530,'1','150','771',329,'Retail Sale Id 1367604',5001.92,0.00,0.00,8.12,470.96,'2021-12-19 14:06:25','',''),(2323548,'1','150','771',329,'Retail Sale Id 1367620',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 14:08:05','',''),(2323572,'1','150','771',329,'Retail Sale Id 1367630',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 14:09:02','',''),(2323584,'1','150','771',329,'Retail Sale Id 1367642',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 14:09:37','',''),(2323603,'1','150','771',329,'Retail Sale Id 1367653',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 14:10:34','',''),(2323613,'1','150','771',329,'Retail Sale Id 1367663',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 14:11:26','',''),(2323634,'1','150','771',329,'Retail Sale Id 1367686',997.92,0.00,0.00,1.62,93.96,'2021-12-19 14:13:06','',''),(2323650,'1','150','771',329,'Retail Sale Id 1367703',652.96,0.00,0.00,1.06,61.48,'2021-12-19 14:14:51','',''),(2323666,'1','150','771',329,'Retail Sale Id 1367717',3498.88,0.00,0.00,5.68,329.44,'2021-12-19 14:16:09','',''),(2323675,'1','150','771',329,'Retail Sale Id 1367725',1250.48,0.00,0.00,2.03,117.74,'2021-12-19 14:16:48','',''),(2323688,'1','150','771',329,'Retail Sale Id 1367738',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 14:18:01','',''),(2323694,'1','150','771',329,'Retail Sale Id 1367745',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 14:18:45','',''),(2323738,'1','150','771',329,'Retail Sale Id 1367779',1552.32,0.00,0.00,2.52,146.16,'2021-12-19 14:22:53','',''),(2323760,'1','150','771',329,'Retail Sale Id 1367796',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 14:24:53','',''),(2323769,'1','150','771',329,'Retail Sale Id 1367806',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 14:25:38','',''),(2323781,'1','150','771',329,'Retail Sale Id 1367815',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 14:27:28','',''),(2323796,'1','150','771',329,'Retail Sale Id 1367833',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 14:28:58','',''),(2323899,'1','150','771',329,'Retail Sale Id 1367910',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 14:36:48','',''),(2323910,'1','150','771',329,'Retail Sale Id 1367921',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 14:37:43','',''),(2323922,'1','150','771',329,'Retail Sale Id 1367931',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 14:38:55','',''),(2323929,'1','150','771',329,'Retail Sale Id 1367940',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 14:39:35','',''),(2323937,'1','150','771',329,'Retail Sale Id 1367946',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 14:40:20','',''),(2323952,'1','150','771',329,'Retail Sale Id 1367960',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 14:42:14','',''),(2323963,'1','150','771',329,'Retail Sale Id 1367970',2500.96,0.00,0.00,4.06,235.48,'2021-12-19 14:43:08','',''),(2323968,'1','150','771',329,'Retail Sale Id 1367979',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 14:43:48','',''),(2323978,'1','150','771',329,'Retail Sale Id 1367987',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 14:44:29','',''),(2323995,'1','150','771',329,'Retail Sale Id 1368003',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 14:46:12','',''),(2324024,'1','150','771',329,'Retail Sale Id 1368030',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 14:48:39','',''),(2324111,'1','150','771',329,'Retail Sale Id 1368123',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 14:59:03','',''),(2324117,'1','150','771',329,'Retail Sale Id 1368127',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 14:59:52','',''),(2324126,'1','150','771',329,'Retail Sale Id 1368133',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 15:00:34','',''),(2324129,'1','150','771',329,'Retail Sale Id 1368138',23100.00,0.00,0.00,37.50,2175.00,'2021-12-19 15:01:22','',''),(2324136,'1','150','771',329,'Retail Sale Id 1368147',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 15:02:02','',''),(2324144,'1','150','771',329,'Retail Sale Id 1368151',652.96,0.00,0.00,1.06,61.48,'2021-12-19 15:02:46','',''),(2324153,'1','150','771',329,'Retail Sale Id 1368160',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 15:03:22','',''),(2324155,'1','150','771',329,'Retail Sale Id 1368164',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 15:03:49','',''),(2324168,'1','150','771',329,'Retail Sale Id 1368174',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:04:41','',''),(2324173,'1','150','771',329,'Retail Sale Id 1368179',1201.20,0.00,0.00,1.95,113.10,'2021-12-19 15:05:23','',''),(2324180,'1','150','771',329,'Retail Sale Id 1368187',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 15:06:23','',''),(2324191,'1','150','771',329,'Retail Sale Id 1368198',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:07:50','',''),(2324199,'1','150','771',329,'Retail Sale Id 1368207',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 15:08:41','',''),(2324214,'1','150','771',329,'Retail Sale Id 1368217',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:10:02','',''),(2324222,'1','150','771',329,'Retail Sale Id 1368230',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:11:35','',''),(2324235,'1','150','771',329,'Retail Sale Id 1368244',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:13:11','',''),(2324256,'1','150','771',329,'Retail Sale Id 1368252',1299.76,0.00,0.00,2.11,122.38,'2021-12-19 15:14:48','',''),(2324268,'1','150','771',329,'Retail Sale Id 1368264',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 15:15:40','',''),(2324275,'1','150','771',329,'Retail Sale Id 1368272',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 15:16:29','',''),(2324281,'1','150','771',329,'Retail Sale Id 1368279',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:16:59','',''),(2324320,'1','150','771',329,'Retail Sale Id 1368307',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 15:20:19','',''),(2324337,'1','150','771',329,'Retail Sale Id 1368314',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:22:17','',''),(2324364,'1','150','771',329,'Retail Sale Id 1368341',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 15:25:17','',''),(2324385,'1','150','771',329,'Retail Sale Id 1368365',3498.88,0.00,0.00,5.68,329.44,'2021-12-19 15:28:19','',''),(2324400,'1','150','771',329,'Retail Sale Id 1368374',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:28:46','',''),(2324420,'1','150','771',329,'Retail Sale Id 1368393',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 15:30:59','',''),(2324430,'1','150','771',329,'Retail Sale Id 1368405',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 15:31:35','',''),(2324435,'1','150','771',329,'Retail Sale Id 1368408',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:32:05','',''),(2324463,'1','150','771',329,'Retail Sale Id 1368439',997.92,0.00,0.00,1.62,93.96,'2021-12-19 15:35:41','',''),(2324486,'1','150','771',329,'Retail Sale Id 1368463',652.96,0.00,0.00,1.06,61.48,'2021-12-19 15:37:59','',''),(2324492,'1','150','771',329,'Retail Sale Id 1368469',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:39:00','',''),(2324501,'1','150','771',329,'Retail Sale Id 1368478',498.96,0.00,0.00,0.81,46.98,'2021-12-19 15:39:47','',''),(2324510,'1','150','771',329,'Retail Sale Id 1368488',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 15:41:06','',''),(2324522,'1','150','771',329,'Retail Sale Id 1368499',652.96,0.00,0.00,1.06,61.48,'2021-12-19 15:41:59','',''),(2324530,'1','150','771',329,'Retail Sale Id 1368506',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:43:05','',''),(2324555,'1','150','771',329,'Retail Sale Id 1368521',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 15:44:12','',''),(2324587,'1','150','771',329,'Retail Sale Id 1368550',2698.08,0.00,0.00,4.38,254.04,'2021-12-19 15:47:22','',''),(2324616,'1','150','771',329,'Retail Sale Id 1368585',3800.72,0.00,0.00,6.17,357.86,'2021-12-19 15:50:22','',''),(2324637,'1','150','771',329,'Retail Sale Id 1368608',2999.92,0.00,0.00,4.87,282.46,'2021-12-19 15:51:34','',''),(2324694,'1','150','771',329,'Retail Sale Id 1368647',3997.84,0.00,0.00,6.49,376.42,'2021-12-19 15:55:41','',''),(2324699,'1','150','771',329,'Retail Sale Id 1368651',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 15:56:35','',''),(2324785,'1','150','771',329,'Retail Sale Id 1368717',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 16:02:37','',''),(2324790,'1','150','771',329,'Retail Sale Id 1368722',2002.00,0.00,0.00,3.25,188.50,'2021-12-19 16:03:15','',''),(2324815,'1','150','771',329,'Retail Sale Id 1368747',1897.28,0.00,0.00,3.08,178.64,'2021-12-19 16:06:32','',''),(2324822,'1','150','771',329,'Retail Sale Id 1368756',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 16:07:15','',''),(2324830,'1','150','771',329,'Retail Sale Id 1368763',0.00,0.00,0.00,0.00,0.00,'2021-12-19 16:08:01','',''),(2325753,'1','150','771',329,'Retail Sale Id 1369530',444930.64,0.00,0.00,722.29,41892.82,'2021-12-19 18:25:52','',''),(2326121,'1','150','771',329,'Retail Sale Id 1369567',3098.48,0.00,0.00,5.03,291.74,'2021-12-20 05:48:20','',''),(2326122,'1','150','771',329,'Retail Sale Id 1369568',997.92,0.00,0.00,1.62,93.96,'2021-12-20 05:50:04','',''),(2326123,'1','150','771',329,'Retail Sale Id 1369569',1897.28,0.00,0.00,3.08,178.64,'2021-12-20 05:50:38','',''),(2326124,'1','150','771',329,'Retail Sale Id 1369570',2500.96,0.00,0.00,4.06,235.48,'2021-12-20 05:51:14','',''),(2326125,'1','150','771',329,'Retail Sale Id 1369571',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 05:53:02','',''),(2326137,'1','150','771',329,'Retail Sale Id 1369581',1250.48,0.00,0.00,2.03,117.74,'2021-12-20 06:04:24','',''),(2326138,'1','150','771',329,'Retail Sale Id 1369582',1897.28,0.00,0.00,3.08,178.64,'2021-12-20 06:05:05','',''),(2326139,'1','150','771',329,'Retail Sale Id 1369583',1503.04,0.00,0.00,2.44,141.52,'2021-12-20 06:05:52','',''),(2326170,'1','150','771',329,'Retail Sale Id 1369594',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 06:11:00','',''),(2326198,'1','150','771',329,'Retail Sale Id 1369600',7700.00,0.00,0.00,12.50,725.00,'2021-12-20 06:14:38','',''),(2326211,'1','150','771',329,'Retail Sale Id 1369607',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 06:17:45','',''),(2326213,'1','150','771',329,'Retail Sale Id 1369610',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:18:55','',''),(2326222,'1','150','771',329,'Retail Sale Id 1369618',7700.00,0.00,0.00,12.50,725.00,'2021-12-20 06:21:13','',''),(2326224,'1','150','771',329,'Retail Sale Id 1369619',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:21:52','',''),(2326228,'1','150','771',329,'Retail Sale Id 1369623',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 06:23:17','',''),(2326232,'1','150','771',329,'Retail Sale Id 1369627',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 06:24:17','',''),(2326236,'1','150','771',329,'Retail Sale Id 1369631',498.96,0.00,0.00,0.81,46.98,'2021-12-20 06:25:04','',''),(2326241,'1','150','771',329,'Retail Sale Id 1369635',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:25:44','',''),(2326272,'1','150','771',329,'Retail Sale Id 1369653',1798.72,0.00,0.00,2.92,169.36,'2021-12-20 06:30:45','',''),(2326280,'1','150','771',329,'Retail Sale Id 1369660',597.52,0.00,0.00,0.97,56.26,'2021-12-20 06:32:03','',''),(2326306,'1','150','771',329,'Retail Sale Id 1369673',7700.00,0.00,0.00,12.50,725.00,'2021-12-20 06:35:58','',''),(2326322,'1','150','771',329,'Retail Sale Id 1369688',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:39:58','',''),(2326328,'1','150','771',329,'Retail Sale Id 1369695',1299.76,0.00,0.00,2.11,122.38,'2021-12-20 06:40:59','',''),(2326332,'1','150','771',329,'Retail Sale Id 1369700',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 06:41:44','',''),(2326360,'1','150','771',329,'Retail Sale Id 1369723',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:46:25','',''),(2326376,'1','150','771',329,'Retail Sale Id 1369735',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 06:49:28','',''),(2326402,'1','150','771',329,'Retail Sale Id 1369763',1897.28,0.00,0.00,3.08,178.64,'2021-12-20 06:53:15','',''),(2326474,'1','150','771',329,'Retail Sale Id 1369783',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 06:56:31','',''),(2326512,'1','150','771',329,'Retail Sale Id 1369793',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 06:58:30','',''),(2326515,'1','150','771',329,'Retail Sale Id 1369799',997.92,0.00,0.00,1.62,93.96,'2021-12-20 06:59:06','',''),(2326580,'1','150','771',329,'Retail Sale Id 1369858',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 07:07:50','',''),(2326586,'1','150','771',329,'Retail Sale Id 1369866',1503.04,0.00,0.00,2.44,141.52,'2021-12-20 07:08:49','',''),(2326589,'1','150','771',329,'Retail Sale Id 1369869',2500.96,0.00,0.00,4.06,235.48,'2021-12-20 07:09:29','',''),(2326639,'1','150','771',329,'Retail Sale Id 1369923',997.92,0.00,0.00,1.62,93.96,'2021-12-20 07:15:59','',''),(2326658,'1','150','771',329,'Retail Sale Id 1369928',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 07:16:57','',''),(2326664,'1','150','771',329,'Retail Sale Id 1369933',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 07:17:49','',''),(2326679,'1','150','771',329,'Retail Sale Id 1369940',3098.48,0.00,0.00,5.03,291.74,'2021-12-20 07:19:02','',''),(2326686,'1','150','771',329,'Retail Sale Id 1369947',3997.84,0.00,0.00,6.49,376.42,'2021-12-20 07:20:04','',''),(2326691,'1','150','771',329,'Retail Sale Id 1369952',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 07:20:42','',''),(2326715,'1','150','771',329,'Retail Sale Id 1369966',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 07:22:32','',''),(2326721,'1','150','771',329,'Retail Sale Id 1369970',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 07:23:28','',''),(2326736,'1','150','771',329,'Retail Sale Id 1369983',997.92,0.00,0.00,1.62,93.96,'2021-12-20 07:25:04','',''),(2326748,'1','150','771',329,'Retail Sale Id 1369994',3800.72,0.00,0.00,6.17,357.86,'2021-12-20 07:26:55','',''),(2326776,'1','150','771',329,'Retail Sale Id 1370023',0.00,0.00,0.00,0.00,0.00,'2021-12-20 07:31:23','',''),(2332936,'1','150','771',329,'Retail Sale Id 1374905',1076958.96,0.00,0.00,1748.31,101401.98,'2021-12-20 18:41:06','',''),(2333325,'1','150','771',329,'Retail Sale Id 1374949',0.00,0.00,0.00,0.00,0.00,'2021-12-21 05:48:37','',''),(2335855,'1','150','771',329,'Retail Sale Id 1377037',233439.36,0.00,0.00,378.96,21979.68,'2021-12-21 10:53:16','',''),(2335941,'1','150','771',329,'Retail Sale Id 1377102',150000.96,0.00,0.00,253.38,150000.96,'2021-12-21 11:00:32','',''),(2335950,'1','150','771',329,'Retail Sale Id 1377110',5920.00,0.00,0.00,10.00,5920.00,'2021-12-21 11:01:44','',''),(2336010,'1','150',NULL,329,'Purchased from AA RANO NIGERIA LIMITED',0.00,2544480.00,4560.00,0.00,0.00,'2021-12-21 11:07:50','',''),(2336050,'1','150',NULL,329,'Reception corrector for bridging 128201',0.00,0.00,0.00,4560.00,0.00,'2021-12-21 11:12:44','',''),(2336051,'1','150','771',329,'Received from bridging 128201',0.00,0.00,4560.00,0.00,0.00,'2021-12-21 11:12:44','',''),(2336158,'1','150','771',329,'Retail Sale Id 1377288',3599.36,0.00,0.00,6.08,206.72,'2021-12-21 11:22:52','',''),(2336175,'1','150','771',329,'Retail Sale Id 1377304',3498.72,0.00,0.00,5.91,200.94,'2021-12-21 11:24:00','',''),(2336179,'1','150','771',329,'Retail Sale Id 1377308',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 11:24:43','',''),(2336193,'1','150','771',329,'Retail Sale Id 1377312',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 11:25:30','',''),(2336214,'1','150','771',329,'Retail Sale Id 1377333',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 11:28:08','',''),(2336228,'1','150','771',329,'Retail Sale Id 1377348',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 11:30:32','',''),(2336234,'1','150','771',329,'Retail Sale Id 1377353',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 11:31:15','',''),(2336251,'1','150','771',329,'Retail Sale Id 1377370',3599.36,0.00,0.00,6.08,206.72,'2021-12-21 11:33:55','',''),(2336269,'1','150','771',329,'Retail Sale Id 1377388',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 11:36:43','',''),(2336292,'1','150','771',329,'Retail Sale Id 1377404',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 11:39:22','',''),(2336310,'1','150','771',329,'Retail Sale Id 1377422',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 11:41:55','',''),(2336317,'1','150','771',329,'Retail Sale Id 1377430',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 11:42:45','',''),(2336332,'1','150','771',329,'Retail Sale Id 1377442',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 11:44:37','',''),(2336343,'1','150','771',329,'Retail Sale Id 1377455',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 11:47:14','',''),(2336383,'1','150','771',329,'Retail Sale Id 1377488',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 11:52:07','',''),(2336393,'1','150','771',329,'Retail Sale Id 1377495',3498.72,0.00,0.00,5.91,200.94,'2021-12-21 11:52:47','',''),(2336413,'1','150','771',329,'Retail Sale Id 1377513',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 11:55:16','',''),(2336449,'1','150','771',329,'Retail Sale Id 1377540',2397.60,0.00,0.00,4.05,137.70,'2021-12-21 11:59:13','',''),(2336467,'1','150','771',329,'Retail Sale Id 1377555',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 12:01:04','',''),(2336472,'1','150','771',329,'Retail Sale Id 1377559',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 12:01:33','',''),(2336517,'1','150','771',329,'Retail Sale Id 1377591',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 12:06:01','',''),(2336688,'1','150','771',329,'Retail Sale Id 1377760',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 12:28:25','',''),(2336726,'1','150','771',329,'Retail Sale Id 1377782',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 12:32:35','',''),(2336756,'1','150','771',329,'Retail Sale Id 1377811',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 12:35:33','',''),(2336813,'1','150','771',329,'Retail Sale Id 1377868',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 12:41:41','',''),(2336822,'1','150','771',329,'Retail Sale Id 1377873',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 12:42:57','',''),(2336830,'1','150','771',329,'Retail Sale Id 1377880',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 12:43:35','',''),(2336834,'1','150','771',329,'Retail Sale Id 1377885',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 12:44:11','',''),(2336843,'1','150','771',329,'Retail Sale Id 1377893',4499.20,0.00,0.00,7.60,258.40,'2021-12-21 12:45:01','',''),(2336849,'1','150','771',329,'Retail Sale Id 1377899',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 12:45:53','',''),(2336863,'1','150','771',329,'Retail Sale Id 1377917',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 12:47:59','',''),(2336867,'1','150','771',329,'Retail Sale Id 1377922',698.56,0.00,0.00,1.18,40.12,'2021-12-21 12:48:32','',''),(2336885,'1','150','771',329,'Retail Sale Id 1377948',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 12:51:08','',''),(2336898,'1','150','771',329,'Retail Sale Id 1377964',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 12:52:49','',''),(2336905,'1','150','771',329,'Retail Sale Id 1377971',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 12:53:33','',''),(2336909,'1','150','771',329,'Retail Sale Id 1377977',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 12:54:09','',''),(2336917,'1','150','771',329,'Retail Sale Id 1377983',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 12:54:55','',''),(2336932,'1','150','771',329,'Retail Sale Id 1377990',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 12:55:50','',''),(2336944,'1','150','771',329,'Retail Sale Id 1377997',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 12:56:46','',''),(2336953,'1','150','771',329,'Retail Sale Id 1378003',10401.44,0.00,0.00,17.57,597.38,'2021-12-21 12:57:58','',''),(2336967,'1','150','771',329,'Retail Sale Id 1378015',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 12:59:42','',''),(2337004,'1','150','771',329,'Retail Sale Id 1378040',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:02:43','',''),(2337016,'1','150','771',329,'Retail Sale Id 1378051',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 13:03:46','',''),(2337041,'1','150','771',329,'Retail Sale Id 1378079',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 13:06:45','',''),(2337121,'1','150','771',329,'Retail Sale Id 1378143',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:13:06','',''),(2337125,'1','150','771',329,'Retail Sale Id 1378147',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 13:13:42','',''),(2337143,'1','150','771',329,'Retail Sale Id 1378163',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 13:14:52','',''),(2337164,'1','150','771',329,'Retail Sale Id 1378173',4001.92,0.00,0.00,6.76,229.84,'2021-12-21 13:16:43','',''),(2337181,'1','150','771',329,'Retail Sale Id 1378190',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 13:18:20','',''),(2337202,'1','150','771',329,'Retail Sale Id 1378211',597.92,0.00,0.00,1.01,34.34,'2021-12-21 13:21:09','',''),(2337209,'1','150','771',329,'Retail Sale Id 1378218',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:21:34','',''),(2337236,'1','150','771',329,'Retail Sale Id 1378242',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 13:24:25','',''),(2337286,'1','150','771',329,'Retail Sale Id 1378295',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 13:30:58','',''),(2337297,'1','150','771',329,'Retail Sale Id 1378306',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 13:31:59','',''),(2337493,'1','150','771',329,'Retail Sale Id 1378406',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 13:45:04','',''),(2337514,'1','150','771',329,'Retail Sale Id 1378416',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:46:01','',''),(2337599,'1','150','771',329,'Retail Sale Id 1378489',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:52:23','',''),(2337606,'1','150','771',329,'Retail Sale Id 1378497',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 13:53:00','',''),(2337619,'1','150','771',329,'Retail Sale Id 1378508',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 13:54:04','',''),(2337631,'1','150','771',329,'Retail Sale Id 1378520',698.56,0.00,0.00,1.18,40.12,'2021-12-21 13:56:00','',''),(2337652,'1','150','771',329,'Retail Sale Id 1378539',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 13:58:00','',''),(2337688,'1','150','771',329,'Retail Sale Id 1378576',497.28,0.00,0.00,0.84,28.56,'2021-12-21 14:02:42','',''),(2337698,'1','150','771',329,'Retail Sale Id 1378583',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 14:03:34','',''),(2337743,'1','150','771',329,'Retail Sale Id 1378629',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 14:08:28','',''),(2337757,'1','150','771',329,'Retail Sale Id 1378644',2498.24,0.00,0.00,4.22,143.48,'2021-12-21 14:10:09','',''),(2337766,'1','150','771',329,'Retail Sale Id 1378653',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 14:11:01','',''),(2337790,'1','150','771',329,'Retail Sale Id 1378676',2397.60,0.00,0.00,4.05,137.70,'2021-12-21 14:13:54','',''),(2337834,'1','150','771',329,'Retail Sale Id 1378709',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 14:17:04','',''),(2337855,'1','150','771',329,'Retail Sale Id 1378718',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 14:17:53','',''),(2337896,'1','150','771',329,'Retail Sale Id 1378730',15001.28,0.00,0.00,25.34,861.56,'2021-12-21 14:19:26','',''),(2337951,'1','150','771',329,'Retail Sale Id 1378772',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 14:24:36','',''),(2337958,'1','150','771',329,'Retail Sale Id 1378778',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 14:25:09','',''),(2338032,'1','150','771',329,'Retail Sale Id 1378851',4001.92,0.00,0.00,6.76,229.84,'2021-12-21 14:30:07','',''),(2338048,'1','150','771',329,'Retail Sale Id 1378870',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 14:31:46','',''),(2338069,'1','150','771',329,'Retail Sale Id 1378880',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 14:33:31','',''),(2338092,'1','150','771',329,'Retail Sale Id 1378910',497.28,0.00,0.00,0.84,28.56,'2021-12-21 14:35:37','',''),(2338124,'1','150','771',329,'Retail Sale Id 1378946',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 14:39:14','',''),(2338139,'1','150','771',329,'Retail Sale Id 1378957',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 14:41:02','',''),(2338153,'1','150','771',329,'Retail Sale Id 1378978',11100.00,0.00,0.00,18.75,637.50,'2021-12-21 14:42:20','',''),(2338171,'1','150','771',329,'Retail Sale Id 1378994',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 14:43:38','',''),(2338182,'1','150','771',329,'Retail Sale Id 1379006',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 14:44:44','',''),(2338194,'1','150','771',329,'Retail Sale Id 1379018',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 14:45:28','',''),(2338437,'1','150','771',329,'Retail Sale Id 1379210',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:04:02','',''),(2338448,'1','150','771',329,'Retail Sale Id 1379220',11100.00,0.00,0.00,18.75,637.50,'2021-12-21 15:05:07','',''),(2338454,'1','150','771',329,'Retail Sale Id 1379229',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 15:05:40','',''),(2338460,'1','150','771',329,'Retail Sale Id 1379234',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 15:06:13','',''),(2338464,'1','150','771',329,'Retail Sale Id 1379239',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 15:06:43','',''),(2338469,'1','150','771',329,'Retail Sale Id 1379243',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:07:10','',''),(2338474,'1','150','771',329,'Retail Sale Id 1379248',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:07:46','',''),(2338479,'1','150','771',329,'Retail Sale Id 1379256',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:08:16','',''),(2338486,'1','150','771',329,'Retail Sale Id 1379264',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:08:52','',''),(2338491,'1','150','771',329,'Retail Sale Id 1379269',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:09:25','',''),(2338511,'1','150','771',329,'Retail Sale Id 1379281',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 15:10:06','',''),(2338516,'1','150','771',329,'Retail Sale Id 1379287',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 15:10:38','',''),(2338523,'1','150','771',329,'Retail Sale Id 1379295',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 15:11:15','',''),(2338529,'1','150','771',329,'Retail Sale Id 1379301',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 15:11:52','',''),(2338531,'1','150','771',329,'Retail Sale Id 1379305',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:12:17','',''),(2338632,'1','150','771',329,'Retail Sale Id 1379379',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:20:18','',''),(2338637,'1','150','771',329,'Retail Sale Id 1379384',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 15:20:49','',''),(2338648,'1','150','771',329,'Retail Sale Id 1379396',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 15:22:53','',''),(2338669,'1','150','771',329,'Retail Sale Id 1379419',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:24:55','',''),(2338672,'1','150','771',329,'Retail Sale Id 1379423',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 15:25:40','',''),(2338684,'1','150','771',329,'Retail Sale Id 1379433',3901.28,0.00,0.00,6.59,224.06,'2021-12-21 15:27:01','',''),(2338693,'1','150','771',329,'Retail Sale Id 1379444',1302.40,0.00,0.00,2.20,74.80,'2021-12-21 15:27:39','',''),(2338700,'1','150','771',329,'Retail Sale Id 1379449',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 15:28:19','',''),(2338707,'1','150','771',329,'Retail Sale Id 1379457',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:29:04','',''),(2338715,'1','150','771',329,'Retail Sale Id 1379465',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:29:36','',''),(2338722,'1','150','771',329,'Retail Sale Id 1379474',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:30:08','',''),(2338736,'1','150','771',329,'Retail Sale Id 1379484',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:30:57','',''),(2338743,'1','150','771',329,'Retail Sale Id 1379491',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 15:31:36','',''),(2338759,'1','150','771',329,'Retail Sale Id 1379508',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:33:13','',''),(2338788,'1','150','771',329,'Retail Sale Id 1379525',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:34:41','',''),(2338797,'1','150','771',329,'Retail Sale Id 1379534',2498.24,0.00,0.00,4.22,143.48,'2021-12-21 15:35:19','',''),(2338831,'1','150','771',329,'Retail Sale Id 1379556',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:37:02','',''),(2338888,'1','150','771',329,'Retail Sale Id 1379582',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 15:39:09','',''),(2338919,'1','150','771',329,'Retail Sale Id 1379598',4001.92,0.00,0.00,6.76,229.84,'2021-12-21 15:39:57','',''),(2338960,'1','150','771',329,'Retail Sale Id 1379629',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 15:42:31','',''),(2338969,'1','150','771',329,'Retail Sale Id 1379648',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:43:12','',''),(2338973,'1','150','771',329,'Retail Sale Id 1379652',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 15:43:43','',''),(2338992,'1','150','771',329,'Retail Sale Id 1379667',1900.32,0.00,0.00,3.21,109.14,'2021-12-21 15:44:45','',''),(2339007,'1','150','771',329,'Retail Sale Id 1379675',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 15:45:32','',''),(2339019,'1','150','771',329,'Retail Sale Id 1379686',4001.92,0.00,0.00,6.76,229.84,'2021-12-21 15:46:28','',''),(2339030,'1','150','771',329,'Retail Sale Id 1379696',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 15:47:14','',''),(2339038,'1','150','771',329,'Retail Sale Id 1379702',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 15:47:46','',''),(2339049,'1','150','771',329,'Retail Sale Id 1379715',2498.24,0.00,0.00,4.22,143.48,'2021-12-21 15:48:40','',''),(2339057,'1','150','771',329,'Retail Sale Id 1379724',4001.92,0.00,0.00,6.76,229.84,'2021-12-21 15:49:23','',''),(2339100,'1','150','771',329,'Retail Sale Id 1379767',6097.60,0.00,0.00,10.30,350.20,'2021-12-21 15:52:54','',''),(2339113,'1','150','771',329,'Retail Sale Id 1379781',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 15:53:41','',''),(2339122,'1','150','771',329,'Retail Sale Id 1379788',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 15:54:18','',''),(2339157,'1','150','771',329,'Retail Sale Id 1379814',2397.60,0.00,0.00,4.05,137.70,'2021-12-21 15:56:45','',''),(2339188,'1','150','771',329,'Retail Sale Id 1379838',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 15:58:21','',''),(2339208,'1','150','771',329,'Retail Sale Id 1379851',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 15:59:13','',''),(2339216,'1','150','771',329,'Retail Sale Id 1379858',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 15:59:47','',''),(2339263,'1','150','771',329,'Retail Sale Id 1379897',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:02:48','',''),(2339266,'1','150','771',329,'Retail Sale Id 1379902',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:03:16','',''),(2339273,'1','150','771',329,'Retail Sale Id 1379910',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:03:47','',''),(2339282,'1','150','771',329,'Retail Sale Id 1379918',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:04:17','',''),(2339295,'1','150','771',329,'Retail Sale Id 1379937',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:05:41','',''),(2339322,'1','150','771',329,'Retail Sale Id 1379961',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 16:07:44','',''),(2339367,'1','150','771',329,'Retail Sale Id 1379979',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:09:28','',''),(2339477,'1','150','771',329,'Retail Sale Id 1380095',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:18:23','',''),(2339489,'1','150','771',329,'Retail Sale Id 1380106',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 16:19:05','',''),(2339513,'1','150','771',329,'Retail Sale Id 1380129',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:20:59','',''),(2339520,'1','150','771',329,'Retail Sale Id 1380139',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 16:21:38','',''),(2339529,'1','150','771',329,'Retail Sale Id 1380145',1302.40,0.00,0.00,2.20,74.80,'2021-12-21 16:22:04','',''),(2339535,'1','150','771',329,'Retail Sale Id 1380152',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 16:22:43','',''),(2339544,'1','150','771',329,'Retail Sale Id 1380160',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:23:30','',''),(2339551,'1','150','771',329,'Retail Sale Id 1380167',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:23:54','',''),(2339579,'1','150','771',329,'Retail Sale Id 1380195',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:27:11','',''),(2339586,'1','150','771',329,'Retail Sale Id 1380203',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 16:28:15','',''),(2339607,'1','150','771',329,'Retail Sale Id 1380211',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 16:29:06','',''),(2339647,'1','150','771',329,'Retail Sale Id 1380245',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 16:31:21','',''),(2339654,'1','150','771',329,'Retail Sale Id 1380250',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:31:55','',''),(2339661,'1','150','771',329,'Retail Sale Id 1380260',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:32:52','',''),(2339670,'1','150','771',329,'Retail Sale Id 1380267',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:33:22','',''),(2339691,'1','150','771',329,'Retail Sale Id 1380291',1000.48,0.00,0.00,1.69,57.46,'2021-12-21 16:34:54','',''),(2339712,'1','150','771',329,'Retail Sale Id 1380309',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 16:37:19','',''),(2339721,'1','150','771',329,'Retail Sale Id 1380318',6002.88,0.00,0.00,10.14,344.76,'2021-12-21 16:37:52','',''),(2339727,'1','150','771',329,'Retail Sale Id 1380324',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 16:38:35','',''),(2339732,'1','150','771',329,'Retail Sale Id 1380332',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:39:14','',''),(2339743,'1','150','771',329,'Retail Sale Id 1380344',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 16:39:54','',''),(2339746,'1','150','771',329,'Retail Sale Id 1380346',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:40:23','',''),(2339769,'1','150','771',329,'Retail Sale Id 1380369',4801.12,0.00,0.00,8.11,275.74,'2021-12-21 16:42:20','',''),(2339779,'1','150','771',329,'Retail Sale Id 1380379',29600.00,0.00,0.00,50.00,1700.00,'2021-12-21 16:43:17','',''),(2339797,'1','150','771',329,'Retail Sale Id 1380398',1201.76,0.00,0.00,2.03,69.02,'2021-12-21 16:44:44','',''),(2339804,'1','150','771',329,'Retail Sale Id 1380405',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 16:45:18','',''),(2339808,'1','150','771',329,'Retail Sale Id 1380411',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 16:45:49','',''),(2339820,'1','150','771',329,'Retail Sale Id 1380421',1799.68,0.00,0.00,3.04,103.36,'2021-12-21 16:46:17','',''),(2339838,'1','150','771',329,'Retail Sale Id 1380436',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 16:47:48','',''),(2339840,'1','150','771',329,'Retail Sale Id 1380443',1497.76,0.00,0.00,2.53,86.02,'2021-12-21 16:48:17','',''),(2339847,'1','150','771',329,'Retail Sale Id 1380448',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 16:48:45','',''),(2339852,'1','150','771',329,'Retail Sale Id 1380453',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 16:49:25','',''),(2339857,'1','150','771',329,'Retail Sale Id 1380458',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 16:49:50','',''),(2339878,'1','150','771',329,'Retail Sale Id 1380474',2498.24,0.00,0.00,4.22,143.48,'2021-12-21 16:51:40','',''),(2339931,'1','150','771',329,'Retail Sale Id 1380529',6500.16,0.00,0.00,10.98,373.32,'2021-12-21 16:56:33','',''),(2339950,'1','150','771',329,'Retail Sale Id 1380540',1302.40,0.00,0.00,2.20,74.80,'2021-12-21 16:57:42','',''),(2339957,'1','150','771',329,'Retail Sale Id 1380551',2000.96,0.00,0.00,3.38,114.92,'2021-12-21 16:58:29','',''),(2339965,'1','150','771',329,'Retail Sale Id 1380556',5002.40,0.00,0.00,8.45,287.30,'2021-12-21 16:59:13','',''),(2339981,'1','150','771',329,'Retail Sale Id 1380573',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 17:01:15','',''),(2339985,'1','150','771',329,'Retail Sale Id 1380579',3700.00,0.00,0.00,6.25,212.50,'2021-12-21 17:01:50','',''),(2339999,'1','150','771',329,'Retail Sale Id 1380591',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 17:02:41','',''),(2340007,'1','150','771',329,'Retail Sale Id 1380599',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 17:03:27','',''),(2340015,'1','150','771',329,'Retail Sale Id 1380611',3001.44,0.00,0.00,5.07,172.38,'2021-12-21 17:05:27','',''),(2340028,'1','150','771',329,'Retail Sale Id 1380620',4197.28,0.00,0.00,7.09,241.06,'2021-12-21 17:06:10','',''),(2340035,'1','150','771',329,'Retail Sale Id 1380629',7400.00,0.00,0.00,12.50,425.00,'2021-12-21 17:07:15','',''),(2340042,'1','150','771',329,'Retail Sale Id 1380634',402.56,0.00,0.00,0.68,23.12,'2021-12-21 17:08:04','',''),(2340068,'1','150','771',329,'Retail Sale Id 1380651',497.28,0.00,0.00,0.84,28.56,'2021-12-21 17:09:25','',''),(2340099,'1','150','771',329,'Retail Sale Id 1380683',2000.96,0.00,0.0